-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_198
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_198`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_198` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_198`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3823 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3808,400123,'',0,'22','1','198','PURCHASES','','2021-10-29 22:53:54',5,0.00,0.00,'','479','2021-10-29 22:53:54','479',0,1),(3809,20057,'',0,'20','1','198','SALES','','2021-10-29 22:54:25',5,0.00,0.00,'','479','2021-10-29 22:54:25','479',0,1),(3810,400348,'',0,'24','1','198','SALARIES & WAGES','','2021-10-29 22:54:56',5,0.00,0.00,'','479','2021-10-29 22:54:56','479',0,1),(3811,400349,'',0,'24','1','198','PURCHASES','','2021-10-29 22:55:15',5,0.00,0.00,'','479','2021-10-29 22:55:15','479',0,1),(3812,400666,'',0,'2','1','198','ZB(LPG)1014471475','','2021-10-29 22:56:21',5,0.00,0.00,'','479','2021-10-29 22:56:21','479',0,1),(3813,400667,'',0,'2','1','198','FB(IBAL)2023855223','','2021-10-29 22:57:07',5,0.00,0.00,'','479','2021-10-29 22:57:07','479',0,1),(3814,400668,'',0,'2','1','198','E-BILLS 1015372548','','2021-10-29 22:58:37',5,0.00,0.00,'','479','2021-10-29 22:58:37','479',0,1),(3815,400669,'',0,'2','1','198','UNITY BANK-0024061656','','2021-10-29 22:59:55',5,0.00,0.00,'','479','2021-10-29 22:59:55','479',0,1),(3816,400670,'',0,'2','1','198','DANKANO-EBILLS:ZNB1014717618','','2021-10-29 23:01:14',5,0.00,0.00,'','479','2021-10-29 23:01:14','479',0,1),(3817,400671,'',0,'2','1','198','UBA YOLA-1021398099','','2021-10-29 23:01:47',5,0.00,0.00,'','479','2021-10-29 23:01:47','479',0,1),(3818,400672,'',0,'2','1','198','FID POS COLLECTION-5620141491','','2021-10-29 23:02:25',5,0.00,0.00,'','479','2021-10-29 23:02:25','479',0,1),(3819,40057,'',0,'6.1','1','198','CASH','','2021-10-29 23:03:26',5,0.00,0.00,'','479','2021-10-29 23:03:26','479',0,1),(3820,400673,'',0,'2','1','198','ZNB POS COLLECTION:-1015965368','','2022-08-03 17:07:42',5,0.00,0.00,'','792','2022-08-03 17:07:42','792',0,0),(3821,400674,'',0,'2','1','198','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:49:51',5,0.00,0.00,'','792','2023-02-20 14:49:51','792',0,0),(3822,400675,'',0,'2','1','198','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:52:46',5,0.00,0.00,'2023-03-17','792','2023-03-17 10:48:32','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4333 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3671,'','1','198','kabo gas','murtala muhammad','08069446768','abukhadijatuassalafi@gmail.com','KANO','KANO','gwarzo road BUK NEW CAMPUS','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-11-04 17:37:39',5,'706','2021-11-04 17:37:39','706'),(3673,'','1','198','CLASSIC GAS ','MUNTARI MUHD','08122206882','hgaya@aaranonigeria.com','KANO MINICIPAL','KANO','SHARADA OPP AL IHSAN FILLING STATION','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-05 16:45:45',5,'706','2021-11-05 16:45:45','706'),(3674,'','1','198','GOMA','GOMA GAS','07068961984','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO','GAIDA SERVICE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-05 16:47:34',5,'706','2021-11-05 16:47:34','706'),(3675,'','1','198','MASS GAS','MAHMUD','08146578835','hgaya@aaranonigeria.com','DAWAKIN KUDU LGA','KANO','NO. 13 DANDINSHE QUATERS','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-05 16:50:02',5,'706','2021-11-05 16:50:02','706'),(3682,'','1','198','MKD GAS','ALH AMINU','08109065050','hgaya@aaranonigeria.com','GWALE ','KANO','JA ENN, AJAWA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-08 09:00:54',5,'706','2021-11-08 09:00:54','706'),(3683,'','1','198','HANNAFI KERO AND GAS','HANNAFI ALHASSAN','08038021154','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO','SAMEGU MASALLACIN MISAD','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-08 09:40:21',5,'706','2021-11-08 09:40:21','706'),(3684,'','1','198','SAIRA GAS','SANI DORAYI','09034888221','hgaya@aaranonigeria.com','GWALE LGA','KANO','DORAYI GIDAN DAGACI','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-08 09:52:19',5,'706','2021-11-08 09:52:19','706'),(3687,'','1','198','AGOGO GAS','SA ADU AGOGO','08165505805','hgaya@aaranonigeria.com','UNGOGGO LGA','KANO','KOFAR DAWANAU','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-08 12:34:14',5,'706','2022-01-01 13:13:49','706'),(3688,'','1','198','SIR AHMAD GAS','ASHIRU UMAR','07036446190','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO','DORAYI CARANCHI','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-09 10:37:51',5,'706','2021-11-09 10:37:51','706'),(3689,'','1','198','CLEAN GAS','IMRANA MUHAMMAD','08149526960','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO','FANSHEKARA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-09 10:40:47',5,'706','2021-11-09 10:40:47','706'),(3690,'','1','198','UMAR GAS ','AMINU IDRIS','08030803959','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO','NAIBAWA LAYIN DAN HASSAN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-09 13:55:58',5,'706','2021-11-09 13:55:58','706'),(3692,'','1','198','DAN IYA GAS','MUDASSIR DOGO','07066507412','hgaya@aaranonigeria.com','FAGGE','KANO STATE','NO:2 UNITY ROAD','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-09 15:40:29',5,'706','2021-11-09 15:40:29','706'),(3693,'','1','198','SABREEN GAS','ALH ABUBAKAR','08039702656','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','UNGUWAR JAKADA ALONG PANSHEKARA ROAD','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-09 16:00:29',5,'706','2021-11-09 16:00:29','706'),(3694,'','1','198','KOLA GAS','MUHAMMAD SHAMSUDDEEN','07032495222','hgaya@aaranonigeria.com','KUMBOTSO','KANO','PANSHEKARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-09 17:38:46',5,'706','2021-11-09 17:38:46','706'),(3695,'','1','198','MARS GAS','SADIQ SURAJ ABDULLAHI','08036873537','hgaya@aaranonigeria.com','KMC','KANO','GANDU GRA,243','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 07:12:15',5,'706','2021-11-10 07:12:15','706'),(3696,'','1','198','BELMAG GAS','HAMZA HASSAN','07038997719','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SHARADA,OPP,SALANTA PRIMARY SCHOOL','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 07:25:01',5,'706','2022-01-02 15:38:26','706'),(3697,'','1','198','NUR GAS','USAINI ','08033016899','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SHARADA, PHASE 3','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 07:56:50',5,'706','2021-12-10 10:46:06','706'),(3698,'','1','198','DEALER','DEALER','08136374343','hgaya@aaranonigeria.com','KANO','KANO','SHARADA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 08:40:19',5,'706','2021-11-10 08:40:19','706'),(3705,'','1','198','MAZAWAJE GAS','MAZAWAJE','64324472','hgaya@aaranonigeria.com','DALA LGA','KANO','GWAMMAJA, DALA LGA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-10 12:05:09',5,'706','2021-11-10 12:05:09','706'),(3706,'','1','198','GULU GAS ','KABIRU YA U','08031328129','hgaya@aaranonigeria.com','FAGGE LGA','KANO','GALADIMA ROAD','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-10 12:27:09',5,'706','2021-11-10 12:27:09','706'),(3713,'','1','198','CITY GAS','DAYYABU SANI','08069157224','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','ZOO ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 13:25:47',5,'706','2021-11-10 13:25:47','706'),(3717,'','1','198','ABACHA GAS','SANI','07036942899','hgaya@aaranonigeria.com','KUMBOTSO','KANO','NAIBAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 14:22:24',5,'706','2021-11-10 14:22:24','706'),(3720,'','1','198','MURTALA GAS ','MUSA ABUBAKAR','09038138866','hgaya@aaranonigeria.com','GWALE','KANO','KABUGA , JANBULO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 14:46:28',5,'706','2021-11-10 14:46:28','706'),(3721,'','1','198','RAHMANIYYA GAS ','ABDULBASIRU','08034324984','hgaya@aaranonigeria.com','GWALE','KANO','GORON DUTSE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 14:53:49',5,'706','2021-11-10 14:53:49','706'),(3722,'','1','198','AS GAS ','AMINU SULAIMAN','09074726766','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SHARADA SABON GIDA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 16:03:51',5,'706','2021-11-10 16:03:51','706'),(3723,'','1','198','MUY','MUHAMMAD UMAR YAKASAI','07033131165','hgaya@aaranonigeria.com','KUMBOTSO','KANO','TUKUNTAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-10 16:57:25',5,'706','2021-11-10 16:57:25','706'),(3725,'','1','198','S&S GAS ','KAMAL ','08146205438','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SHARADA UPHASE 2','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 07:39:13',5,'706','2021-11-11 07:39:13','706'),(3726,'','1','198','GREAT PRINCE','GREAT PRINCE','09126529701','hgaya@aaranonigeria.com','KMC','KANO','NEW ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 08:54:16',5,'706','2021-11-11 08:54:16','706'),(3728,'','1','198','SILVER GAS ','ANAS','08055667510','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SABUWAR GANDU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 09:49:19',5,'706','2021-11-11 09:49:19','706'),(3729,'','1','198','BALAGO GAS ','ABBA','07068620290','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','KOFAR WAMBAI, SABUWAR GANDU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 10:15:47',5,'706','2021-11-11 10:15:47','706'),(3732,'','1','198','HASKE NNWEKA','NNWEKACHI','08068119893','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SABON GARI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 12:53:39',5,'706','2021-11-11 12:53:39','706'),(3733,'','1','198','BEN GAS','BENSON','08034092830','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SARKIN YAKI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 12:56:13',5,'706','2021-11-11 12:56:13','706'),(3734,'','1','198','S.MANAGERR GAS','SHUAIBU UMAR','07039666785','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','JAOJI QUATERS ZOO ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-11 13:39:43',5,'706','2021-11-11 13:39:43','706'),(3736,'','1','198','ALIMS MULTILINK ENT.','MUYIDDEEN','08037757338','hgaya@aaranonigeria.com','DALA','KANO','DALA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-12 09:25:15',5,'706','2021-11-12 09:25:15','706'),(3739,'','1','198','AMINCI GAS VENTURE','HAMISU YUSUF TAHIR','07035030184','hgaya@aaranonigeria.com','FAGGE LGA','KANO STATE','RIJIYAR LEMO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-13 09:14:25',5,'706','2021-11-13 09:14:25','706'),(3740,'','1','198','P. G. Y. GAS','DAN HAJIYA','09076649883','hgaya@aaranonigeria.com','KMC','KANO STATE','YAKASAI','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-13 09:54:38',5,'706','2021-11-13 09:54:38','706'),(3741,'','1','198','SALIHU GAS','SALIHU','09069231219','hgaya@aaranonigeria.com','DALA LGA','KANO STATE','DAN DINSHE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-13 10:38:32',5,'706','2021-11-13 10:38:32','706'),(3743,'','1','198','BABA GAS','TAHIR ISYAKU','08038234567','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','ME DILE, PRIMARY','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-13 11:08:22',5,'706','2021-11-13 11:08:22','706'),(3744,'','1','198','DAN HASSAN GAS','KABIRU DAN HASSAN','07032094332','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','SABUWAR GANDU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-13 11:52:33',5,'706','2021-11-13 11:52:33','706'),(3745,'','1','198','AL-ANSAR  GAS','BASHIR SHEHU MUH,D','07031171617','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','SABUWAR GANDU','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-13 12:12:42',5,'706','2021-11-13 12:12:42','706'),(3746,'','1','198','G $ G GAS','G $ G GAS','07061328726','hgaya@aaranonigeria.com','KMC','KANO STATE','SHARADA OPP GIDAN WANKA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-13 12:19:30',5,'706','2021-11-13 12:19:30','706'),(3747,'','1','198','MAI TABA GAS','IBRAHIM ZUBAIRU MUHD','07067806741','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','GYADIGYADI, ZARIA ROAD','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-13 12:42:48',5,'706','2021-11-13 12:42:48','706'),(3748,'','1','198','DAN SA, AH GAS','BILYAMIN ','07032048958','hgaya@aaranonigeria.com','KMC LGA','KANO STATE','ZOO R0AD BEHIND ISYAKA RABI U HOSPITAL','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-13 12:54:13',5,'706','2021-11-13 12:54:13','706'),(3749,'','1','198','HAMDALA GAS ','HALIFA SANUSI','07066211117','hgaya@aaranonigeria.com','KMC','KANO STATE','KWANAR BODA STREET','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-13 14:43:15',5,'706','2021-11-13 14:43:15','706'),(3750,'','1','198','SALMANU GULU GAS','SALMANU','07069414547','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','DORAYI CHARANCHI','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-13 15:14:29',5,'706','2021-11-13 15:14:29','706'),(3751,'','1','198','GAS SOLUTION','HABIB LAWAN','09036234902','hgaya@aaranonigeria.com','TARAUNI','KANO','GYADI-GYADI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-14 10:02:33',5,'706','2021-11-14 10:02:33','706'),(3753,'','1','198','GAYYANKO GAS','SHAREEF YAKUBU','08141847662','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','GADON KAYA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-15 09:37:40',5,'706','2021-11-15 09:37:40','706'),(3754,'','1','198','BIN UHMAN','ABDULSALAM UTHMAN ABUBAKAR','08031177623','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','KOFAR WAIKA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-15 10:14:32',5,'706','2021-11-15 10:14:32','706'),(3755,'','1','198','MMH GODIYA GAS','MUHMOUD MUSA MUHMOUD','08022140825','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','SALLANTA SABON GIDA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-15 10:20:43',5,'706','2021-11-15 10:20:43','706'),(3758,'','1','198','KURSUN GAS','IBRAHIM RABIU BARI','09073681399','hgaya@aaranonigeria.com','ROGO ','KANO STATE','BARI KOFAR GABAS','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-15 12:00:58',5,'706','2021-11-15 12:00:58','706'),(3759,'','1','198','DAN KASUWA GLOBAL ENTERPRISES','AMIRU IBRAHIM SAADU','08080138950','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','BUBBBUGAJE UNGUWAR KAWU','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-15 12:12:01',5,'706','2021-11-15 12:12:01','706'),(3760,'','1','198','UMMINAA GAS','UMAR DAUDA ADAM','08032838127','hgaya@aaranonigeria.com','DALA LGA','KANO STATE','KURNA LAYIN ADO MAI KUSA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-15 12:54:57',5,'706','2021-11-15 12:54:57','706'),(3761,'','1','198','SALISU GULU GAS','SALISU','07033796589','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','GAIDA DIGA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-15 13:07:05',5,'706','2021-11-15 13:07:05','706'),(3763,'','1','198','AFAFATA GAS','SALIHU ALIYU','08106131771','hgaya@aaranonigeria.com','JAKARA','KANO','JAKARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-15 14:02:14',5,'706','2021-11-15 14:02:14','706'),(3765,'','1','198','C.G.S','OGOCHUKWU','08065497313','hgaya@aaranonigeria.com','TARAUNI','KANO','TARAUNI PRIMARY','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-15 14:18:42',5,'706','2021-11-15 14:18:42','706'),(3766,'','1','198','211 ENERGY SOLUTION','HALLIRU GWARZO','08063339989','hgaya@aaranonigeria.com','NASARAWA','KANO','UDB ROAD,KANO.','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-15 14:21:03',5,'706','2021-11-15 14:21:03','706'),(3767,'','1','198','EMIRATE','NURA KABIR','09048894685','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SHARADA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-15 14:26:49',5,'706','2021-11-15 14:26:49','706'),(3769,'','1','198','MUSBY ','LAWAN','08106559260','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SHARADA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-15 15:52:43',5,'706','2021-11-16 16:30:52','706'),(3770,'','1','198','H. N. DAUDA GAS ','NAZIRU HALLIRU','08035011330','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','SHEKA SOLAR LADO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 08:40:13',5,'706','2021-11-16 08:40:13','706'),(3771,'','1','198','J. P. GAS','BEN ILUOBE','08054018204','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','ADJACENT COURTROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 08:57:25',5,'706','2021-11-16 08:57:25','706'),(3772,'','1','198','MUHYIDDEEN GAS','MUHYIDDEEN','08037757338','hgaya@aaranonigeria.com','DALA LGA','KANO STATE','KOKI OPP GIDAN MARIA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-16 09:31:28',5,'706','2021-11-16 09:31:28','706'),(3773,'','1','198','SAHABI FAG0-3 GAS','ALH SAHABI','08146858029','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','ZOO ROAD','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-11-16 09:57:05',5,'706','2021-11-16 09:57:05','706'),(3774,'','1','198','BABA FAGO GAS','BABA','08036865717','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','YAN DILLALE','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-11-16 10:01:41',5,'706','2021-11-16 10:01:41','706'),(3775,'','1','198','HOMMER CONCEPT $ TECHNICAL LTD','OGA BC ','08036034105','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','NO 20 TARAUNI MARKET ROAD','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-11-16 10:19:21',5,'706','2022-09-08 11:19:23','953'),(3776,'','1','198','SANI RABI U GAS','SANI RABI U','08065732331','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','MEDILE KWANAR HAMDALA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 10:29:02',5,'706','2021-11-16 10:29:02','706'),(3777,'','1','198','FAGO ONE GAS','Y. G. FAGO','07038287815','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','NO 2$3 YAN DILLALE','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-11-16 10:36:47',5,'706','2021-11-16 10:36:47','706'),(3778,'','1','198','GALADIMA GULU GAS','BUHARI GULU','07068242928','hgaya@aaranonigeria.com','FAGGE LGA','KANO STATE','GALADIMA ROAD ','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-16 10:40:23',5,'706','2021-11-16 10:40:23','706'),(3779,'','1','198','TANKA','AUWAL NASEER MUAZZAM','09033177419','saidsalisuabba@gmail.com','GWALE','KANO','KUNTAU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 10:44:31',5,'706','2022-02-14 15:32:00','706'),(3780,'','1','198','RA\'ISHFA GAS','BASHIR MUHAMMAD','07032684828','hgaya@aaranonigeria.com','KUNBOTSO','KANO','ZAWACIKI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 10:49:51',5,'706','2021-11-16 10:49:51','706'),(3781,'','1','198','AMFANI GAS','MUHAMMAD','09064954704','hgaya@aaranonigeria.com','FAGGE','KANO','KURNA TUDUN BOJUWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 10:53:37',5,'706','2021-11-16 10:53:37','706'),(3782,'','1','198','BB GAS','HAJIYA FATIMA','08138893435','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GIDA DUBU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 10:55:01',5,'706','2021-11-16 10:55:01','706'),(3783,'','1','198','ADA GAS','ADA BAUCHI','07025007771','hgaya@aaranonigeria.com','DARAZO','BAUCHI','DARAZON BAUCHI','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-16 10:56:56',5,'706','2021-11-16 10:56:56','706'),(3784,'','1','198','AL\'IKLAS GAS','ALH TASHIR','07067806741','hgaya@aaranonigeria.com','KANO MUNINCIPAL','KANO','OPPOSITE BASHIR TOFA RESIDENT','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-16 11:02:13',5,'706','2021-11-16 11:02:13','706'),(3785,'','1','198','Success Gas','Abdulhadi Isah','08032806424','hgaya@aaranonigeria.com','Kumbotso','Kano','Sharada Kwanar Ganduje','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 12:33:49',5,'706','2021-11-16 12:33:49','706'),(3786,'','1','198','YELLOW GAS','BASHIR MAULA','07069693423','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA LAYIN DANLARAI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 12:54:26',5,'706','2021-11-16 12:54:26','706'),(3787,'','1','198','EMIR GAS','AMINU','08081676748','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SALEGU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 12:55:22',5,'706','2022-01-01 13:17:09','706'),(3788,'','1','198','KOGUNA GAS','HUZAIFI','07062864595','hgaya@aaranonigeria.com','KUMBOTSO','KANO','DORAYI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 12:56:23',5,'706','2022-01-01 13:20:53','706'),(3789,'','1','198','BNY GAS','SALITU','09049663506','hgaya@aaranonigeria.com','KUMBOTSO','KANO','YAN KUSA GAIDA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 12:59:23',5,'706','2021-12-10 10:53:56','706'),(3790,'','1','198','JND GAS','ABUBAKAR','09023004734','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SABON TITI MANDAWARI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 13:00:23',5,'706','2021-11-16 13:00:23','706'),(3791,'','1','198','SHAMSU GAS','SHAMSUDDEEN','09012003050','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 13:01:12',5,'706','2021-11-16 13:01:12','706'),(3792,'','1','198','MUHAMMAD GAS','MUHAMMAD','07042444538','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA LAYIN KUSA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 13:02:11',5,'706','2021-11-16 13:02:11','706'),(3793,'','1','198','WALI GULU GAS','YUSUF SALISU','07032842779','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA DUGA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 13:03:15',5,'706','2021-11-16 13:03:15','706'),(3794,'','1','198','MY GAS','MUYUDDEEN GAS','08162473390','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA LAYIN SERVICE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 13:04:14',5,'706','2021-11-16 13:04:14','706'),(3795,'','1','198','COOKIE WELL GAS','SALIM','08134742422 ','hgaya@aaranonigeria.com','KUMBOTSO','KANO','ZAWACIKI GIDA DUBU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 13:05:31',5,'706','2021-11-16 13:05:31','706'),(3797,'','1','198','MAI DALA GAS','ARABI IBRAHIM','08068537322','hgaya@aaranonigeria.com','FAGGE LGA','KANO STATE','NEW ROAD S/GARI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-16 16:11:00',5,'706','2021-11-16 16:11:00','706'),(3798,'','1','198','FARUK GARO GAS','MANSUR','08066232382','hgaya@aaranonigeria.com','GWALE','KANO STATE','BUK OLD SIDE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-17 07:42:28',5,'706','2021-11-17 07:42:28','706'),(3800,'','1','198','NASIR GAS','MUKHTAR','08148474707','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','UNGUWA UKU','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-11-17 08:57:02',5,'706','2021-11-17 08:57:02','706'),(3801,'','1','198','OPERATIONAL LOSS','SHARADA LPG','0000000000','hgaya@aaranonigeria.com','NASSARAWA','KANO STATE','HOTORO','Nigeria',2500.00,0.00,0.00,'0000-00-00','2021-11-17 09:30:55',5,'706','2021-11-17 09:30:55','706'),(3802,'','1','198','BULK SALES','SHARADA','0000000000000','hgaya@aaranonigeria.com','NASSARAWA','KANO STATE','HOTORO','Nigeria',1661.54,0.00,0.00,'0000-00-00','2021-11-17 09:36:57',5,'706','2021-11-17 09:36:57','706'),(3803,'','1','198','KABIRU GAS','KABIRU','08178177254','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','AKWA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-17 11:24:56',5,'706','2021-11-17 11:24:56','706'),(3808,'','1','198','ALBARKA GAS','SADIK MUHD','09122082133','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','JA ENN DIGA','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-18 10:21:32',5,'706','2021-11-18 10:21:32','706'),(3812,'','1','198','BATOOL GAS','ABBA BAMALLI','08130006217','hgaya@aaranonigeria.com','AJINGI','KANO','AJINGI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-18 17:24:36',5,'706','2021-11-18 17:24:36','706'),(3820,'','1','198','NA KURMI','KABIRU TIJJANI','08035595337','hgaya@aaranonigeria.com','DALA','KANO','YALWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-21 06:39:48',5,'706','2022-09-21 11:40:21','953'),(3822,'','1','198','KB GAS','KABIRU AHMAD','08065412714','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','TARAUNI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-21 12:52:21',5,'706','2021-11-21 12:52:21','706'),(3826,'','1','198','KK GAS ','PIUS ','07067666752','hgaya@aaranonigeria.com','FAGGE','KANO','SABON GARI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-22 08:13:11',5,'706','2021-11-22 08:13:11','706'),(3827,'','1','198','AUWAL GAS ','AUWAL SULAIMAN','08066046854','hgaya@aaranonigeria.com','NASSARAWA','KANO STATE','BRIGADE AHMADIYYA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-22 08:21:53',5,'706','2021-11-22 08:21:53','706'),(3828,'','1','198','UNITY','JOEL DAMENA','07017853008','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','COCACOLA JUNCTION','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-22 09:00:23',5,'706','2021-11-22 09:00:23','706'),(3829,'','1','198','DANDALI GAS','HARUNA ALIYU','08077682207','hgaya@aaranonigeria.com','DALA LGA','KANO STATE','WAKILIN DUKIYA G/DUTSE','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-11-22 11:42:35',5,'706','2021-11-22 11:42:35','706'),(3833,'','1','198','PRIDAY GAS','PRIDAY','08036238369','hgaya@aaranonigeria.com','FAGGE LGA','KANO STATE','23 NEW ROAD S/GARI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-23 07:55:40',5,'706','2021-11-23 07:55:40','706'),(3834,'','1','198','RAHMAH GAS','ALIYU HAMZA ALI','07069622027','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','MANDAWARI DAN BAFFA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-23 09:13:41',5,'706','2021-11-23 09:13:41','706'),(3835,'','1','198','RYNUS','KABIRU AHMAD','07030182444','hgaya@aaranonigeria.com','RANO','KANO','LAYIN LIMAN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-23 12:07:59',5,'706','2021-11-23 12:07:59','706'),(3836,'','1','198','JAN GERO GAS','KABIRU USMAN','07066023068','hgaya@aaranonigeria.com','TARAUNI','KANO','SALLARI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-23 12:26:44',5,'706','2021-11-23 12:26:44','706'),(3840,'','1','198','DHG ','DAN HASSAN','07034203232','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-24 11:01:13',5,'706','2021-11-24 11:01:13','706'),(3845,'','1','198','ABBAS GAS','ABBAS','08030710831','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','TUDUN WAZIRCHI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-24 15:18:18',5,'706','2021-11-24 15:18:18','706'),(3848,'','1','198','AMZUR','ABUBAKAR AMINU','08087766246','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GURUN GAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-25 08:55:36',5,'706','2021-11-25 08:55:36','706'),(3849,'','1','198','NORTH WEST','RILWANU','08062770496','hgaya@aaranonigeria.com','TARAUNI','KANO','KUNDILA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-25 08:59:45',5,'706','2021-11-25 08:59:45','706'),(3850,'','1','198','PRIME STORE','ABRAHAM','08036920574','hgaya@aaranonigeria.com','NASSARAWA','KANO','MAIDUGURI ROAD ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-25 09:01:01',5,'706','2021-11-25 09:01:01','706'),(3851,'','1','198','KABARA','ALI ABDULLAHI','07019275439','hgaya@aaranonigeria.com','GWALE','KANO','JAIN LAYIN SHAGO TARA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-25 09:02:17',5,'706','2021-11-25 09:02:17','706'),(3853,'','1','198','MBJ GAS','ANAS MA\'AZU','08062985100','hgaya@aaranonigeria.com','NASSARAWA','KANO','TSAMIYAR BOKA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-25 11:06:20',5,'706','2021-11-25 11:06:20','706'),(3854,'','1','198','LIMAN GAS','ISAH BASHIR','07036070248','hgaya@aaranonigeria.com','NASSARAWA','KANO','AUDU UTAI ROAD BRIGADE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-25 15:15:21',5,'706','2021-11-25 15:15:21','706'),(3855,'','1','198','GOLDEN GAS','MUAZU SULAIMAN AHMAD','09071171261','hgaya@aaranonigeria.com','MINJIBIR','KANO STATE','668 INDABAWA QTRS','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-26 15:39:40',5,'706','2021-11-26 15:39:40','706'),(3857,'','1','198','INAS','MUSTAPHA BILYA','08063666399','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SHEKA GABAS 117','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-27 10:31:06',5,'706','2021-11-27 10:31:06','706'),(3875,'','1','198','LAMIDO BROTHERS','LAMIDO','08036282603','hgaya@aaranonigeria.com','TARAUNI','KANO','DANGI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-27 15:22:51',5,'706','2021-11-27 15:22:51','706'),(3879,'','1','198','IBR GAS','MUSTAPHA IBRAHIM  USMAN','07039216138','hgaya@aaranonigeria.com','KUMBOTSO','KANO STATE','SHARADA JAIEIN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-28 09:33:49',5,'706','2021-11-28 09:33:49','706'),(3880,'','1','198','MAI NASARA','JAMILU SHUAIBU','08038497665','hgaya@aaranonigeria.com','KUMBOTSO','KANO STATE','NAIBAWA LAYIN DAN HASSAN','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-11-28 10:20:27',5,'706','2021-11-28 10:20:27','706'),(3882,'','1','198','RAHMANIYYA GASSS','ABDUL ','08034322984','hgaya@aaranonigeria.com','DALA LGA','KANO STATE','GORON DUTSE','Nigeria',800.00,0.00,0.00,'0000-00-00','2021-11-28 12:35:36',5,'706','2021-11-28 12:35:36','706'),(3883,'','1','198','SAUKI GAS','ABDULLAHI MUHAMMAD','08140248464','hgaya@aaranonigeria.com','KUMBOTSO','KANO','GAIDA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-28 14:44:12',5,'706','2021-11-28 14:44:12','706'),(3926,'','1','198','NAGARTA GAS ','ILYA KURA ','08022652934','hgaya@aaranonigeria.com','KUMBOTSO','KANO','BEHIND KASUWA FANSHEKARA QUATERS ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-01 08:32:54',5,'706','2021-12-01 08:32:54','706'),(3927,'','1','198','MEKASON ENTERPRICES','HENRY BOLOGI','08035924137','hgaya@aaranonigeria.com','FAGGE LGA','KANO STATE','NO 26 BALADUS, S/GARI','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-12-01 13:29:52',5,'706','2021-12-01 13:29:52','706'),(3928,'','1','198','DEEN GAS','NAZIR UMAR','07035884640/08065454853','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','JA OJI QTRS ZARIA ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-01 13:44:00',5,'706','2021-12-18 13:35:46','706'),(3945,'','1','198','AMANA RESOURCE GAS','MUSTAPHA IBRAHIM','08065305133','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','JA ENN BAKIN DIGA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-03 15:39:18',5,'706','2021-12-03 15:39:18','706'),(3946,'','1','198','ABBA GAS','SHAFIU YUSUF','09034463712','hgaya@aaranonigeria.com','KUMBOTSO','KANO','MIDILE UNGUWAR FULANI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-04 11:42:43',5,'706','2021-12-04 11:42:43','706'),(3951,'','1','198','MA\'AWIYYA GAS','MA\'AWIYYA ABDULLAHI','08130677592','hgaya@aaranonigeria.com','FAGGE','KANO','NO.3 UNITY ROAD','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-06 07:54:32',5,'706','2021-12-06 07:54:32','706'),(3970,'','1','198','UBA ALI GAS','UBA ALI','07034435850','hgaya@aaranonigeria.com','KUMBOTSO','KANO','HAUSAWA M.MURTALA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-07 11:47:40',5,'706','2021-12-07 11:47:40','706'),(3974,'','1','198','B A GAS','HARUNA ALI','07036156256','hgaya@aaranonigeria.com','KUMBOTSO','KANO','SHAGARI QTRS','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-12-07 16:11:49',5,'706','2021-12-07 16:11:49','706'),(3982,'','1','198','YUSHAU GAS','UMAR ABBAS','09017356161','hgaya@aaranonigeria.com','KUMBOTSO','KANO','MIDILE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-08 13:49:51',5,'706','2021-12-08 13:49:51','706'),(3997,'','1','198','M. A. S. GAS','MAHMUD SULAIMAN','08039252510','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','ZAWACIKI GIDA DUBU','Nigeria',1500.00,0.00,0.00,'0000-00-00','2021-12-10 09:28:41',5,'706','2021-12-10 09:28:41','706'),(3998,'','1','198','BABA ZANGO','AUWAL BADAMASI','09070471438','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','GAIDA TITIN KUMBOTSO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-10 10:16:25',5,'706','2021-12-10 10:16:25','706'),(4013,'','1','198',' ABU SULTAN GAS','ABDULLAHI MUHAMMAD GARBA','09027768571','hgaya@aaranonigeria.com','TARAUNI','KANO','HOTORO LIMAWA GRA','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-12-12 11:40:17',5,'706','2021-12-12 11:40:17','706'),(4025,'','1','198','M Z GAS','DAN LAMI ',' 08060989532','hgaya@aaranonigeria.com','GWALE LGA','KANO STATE','SABON TITIN DAN DAGO','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-12-14 12:41:59',5,'706','2021-12-14 12:41:59','706'),(4034,'','1','198','M H _GAS','ABBA SANI','07060450666','hgaya@aaranonigeria.com','KANO','KANO','TUDUN RUBUDI UNGOGGO LGA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-16 10:21:43',5,'706','2021-12-16 10:21:43','706'),(4043,'','1','198','M M H GAS','YUNUSA BADAMASI','08022140825','hgaya@aaranonigeria.com','KUMBOTSO','KANO','BABBAN LAYI SHARADA','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-12-17 10:33:24',5,'706','2021-12-17 10:33:24','706'),(4049,'','1','198','A A H _GAS ','HARUNA ABUBAKAR','09037209185','hgaya@aaranonigeria.com','KUMBOTSO','KANO STATE','DORAYI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-19 10:48:05',5,'706','2021-12-19 10:48:05','706'),(4053,'','1','198','SILVER 2 GAS','YUSUF MUKHTAR','07036881594/08056351553','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','ME DILE TURBA','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-12-19 13:56:39',5,'706','2021-12-19 13:56:39','706'),(4054,'','1','198','A. A. RAHMAH GAS','ABDULHAMID ABDUSSALAM','08037011909','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','MUNDADU SHEKA GARI','Nigeria',2000.00,0.00,0.00,'0000-00-00','2021-12-19 14:06:28',5,'706','2021-12-19 14:06:28','706'),(4062,'','1','198','KARIM GAS','KARIM','08021308558','hgaya@aaranonigeria.com','TARAUNI','KANO','CBN QTRS HOTORO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-21 08:41:12',5,'706','2021-12-21 08:41:12','706'),(4115,'','1','198','ZANGO GAS ','UMAR YUSUF TANKO','08162473231','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO STATE','YAHYA GUSAU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-30 10:13:06',5,'706','2021-12-30 10:13:06','706'),(4116,'','1','198','ZOLA GAS','SAFIYANU ADO','08066378481','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SHARADA PHASE 1 ','Nigeria',700.00,0.00,0.00,'0000-00-00','2021-12-30 11:21:21',5,'706','2022-01-23 17:10:52','706'),(4117,'','1','198','BINDAWA GAS ','SUNUSI YUSUF ','08067237468','hgaya@aaranonigeria.com','UNGOGGO','KANO','UNGOGGO KUNTIRE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-30 12:35:26',5,'706','2021-12-30 12:35:26','706'),(4141,'','1','198','ALKHAIRAT GAS','HANNAFI YAU','08092992423','hgaya@aaranonigeria.com','KUMBOTSO','KANO','ZAWACHIKI GABAS','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-05 17:06:15',5,'706','2022-01-05 17:06:15','706'),(4151,'','1','198','SRASIP GAS','ABDULKADIR TIJJANI SPEAKING','08133353333','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SABUWAR KOFA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-06 16:18:16',5,'706','2022-01-06 16:18:16','706'),(4152,'','1','198','trasif GAS','ABDULDIR TIJJANI',' 08133533333','hgaya@aaranonigeria.com','KMC','KANO STATE','SABUWAR KOFA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-01-06 16:22:15',5,'706','2022-01-06 16:22:15','706'),(4159,'','1','198','SANI YUSUF SANI','SYS GAS','08026197946','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','SABON TITI SANI MAI NAGGE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-09 09:41:30',5,'706','2022-01-09 09:41:30','706'),(4165,'','1','198','CONTINTENTAL RESOURCES LTD','ODOH ADAORA','07025007771','adaoraodoh22@gmail,com','AZARE','BAUCHI','PLOT 322, STATE LOCUST, AZARE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-11 09:57:18',5,'706','2022-01-11 09:57:18','706'),(4207,'','1','198','SABUWAR SINGA GAS','AMIRU','08063197324','hgaya@aaranonigeria.com','GWALE','KANO STATE','GADON KAYA , BABBAN LAYI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-20 11:01:46',5,'706','2022-01-20 11:01:46','706'),(4226,'','1','198','DG  GAS','YUSIF  ISAH','08039521636','hgaya@aaranonigeria.com','KUMBOTSO','KANO','DORAYI  GULU GAS','Nigeria',700.00,0.00,0.00,'0000-00-00','2022-01-23 10:04:12',5,'706','2022-01-23 10:04:12','706'),(4232,'','1','198','GULU DIGGER','SALUSU SULAIMAN','07033796589','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','GAIDA DIGGER','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-24 15:25:20',5,'706','2022-01-24 15:25:20','706'),(4242,'','1','198','AMMAM GAS','YAHAYA ABUBAKAR','07037360424','hgaya@aaranonigeria.com','KMC','KANO','GANDU ALBASA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-01-27 10:51:30',5,'706','2022-01-27 10:51:30','706'),(4243,'','1','198','AMARA GAS ','MUHAMMAD UMAR SA\'ID ','09030899969','hgaya@aaranonigeria.com','KMC','KANO STATE','TUKUNTAWA GIDAN RADIO','Nigeria',800.00,0.00,0.00,'0000-00-00','2022-02-02 11:16:10',5,'706','2022-02-02 11:16:10','706'),(4244,'','1','198','L.A GAS ','LAWAN ABDULLAHI','08023797882','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','SANI ABACHA YOUTH CENTER KUMBOTSO LGA','Nigeria',800.00,0.00,0.00,'0000-00-00','2022-02-02 11:17:24',5,'706','2022-02-02 11:17:24','706'),(4245,'','1','198','SALHAZ GAS','NURADDEEN ADAM','08038685676','hgaya@aaranonigeria.com','TARAUNI LGA','KANO STATE','KARKASARA TARAUNI LGA','Nigeria',800.00,0.00,0.00,'0000-00-00','2022-02-05 16:52:11',5,'706','2022-02-05 16:52:11','706'),(4246,'','1','198','SANI GAS','SANI','07032025985','hgaya@aaranonigeria.com','KANO MUNICIPAL','KANO','YAKASAI','Nigeria',700.00,0.00,0.00,'0000-00-00','2022-02-06 09:19:03',5,'706','2022-02-06 09:19:03','706'),(4247,'','1','198','AB  GAS','MUHAMMAD HADIYATULLAH','09120906411','hgaya@aaranonigeria.com','GWALE LGA','KANO','HARADA K GANDUJE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-02-06 14:32:49',5,'706','2022-02-06 14:32:49','706'),(4248,'','1','198','innocent GAS','ADAYI INNOCENT','07046368346','hgaya@aaranonigeria.com','KUMBOTSO LGA','KANO STATE','FANSHEKARA K 3','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-02-24 10:29:45',5,'706','2022-02-24 10:29:45','706'),(4249,'','1','198','ROG GAS','YAHAYA UBANDOMA','08032982894','hgaya@aaranonigeria.com','TARAUNI','KANO STATE','FARM CENTER','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-03-01 19:38:19',5,'706','2022-03-01 19:38:19','706'),(4250,'','1','198','ASY  GAS','MUSTAPHA  ABDULLAHI','09065452563','hgaya@aaranonigeria.com','KMC','KANO STATE','SABUWAR GANDU LAYIN GIDAN KAJI ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-03-03 11:50:05',5,'706','2022-03-03 11:50:05','706'),(4251,'','1','198','DEEN GAS & MINERAL RESOURCES','KAHAR BADIRU ZAKARIYAU','07061521980','badirukahar4@gmail.com','KANO','Kano','NO 21/22 MOBILE POLICE BARRACK BY BAKIN ZUWO, NEAR POLICE STATION, HOTORO KANO.','Nigeria',2000.00,0.00,0.00,'0000-00-00','2022-04-04 09:47:58',5,'706','2022-04-04 09:47:58','706'),(4252,'','1','198','NUR GAS 2','IBRAHIM MUHD','08034851043','badirukahar4@gmail.com','NASARAWA','Kano','GIGINYU NASARAWA','Nigeria',2000.00,0.00,0.00,'0000-00-00','2022-04-05 08:50:48',5,'706','2022-04-05 08:50:48','706'),(4253,'','1','198','Shazen Gas','Bashir sani','09019579407','abbansultan32@gmail.com','Gwale','Kano','Kofar wayka gwale ','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-04-06 09:32:43',5,'706','2022-04-06 09:32:43','706'),(4254,'','1','198','EMPIRE GAS','KABIRU NASIRU','09061272788','badirukahar4@gmail.com','KUMBUSTU','Kano','SHEKA KUMBUSTU','Nigeria',2000.00,0.00,0.00,'0000-00-00','2022-04-08 13:54:31',5,'706','2022-04-08 13:54:31','706'),(4255,'','1','198','AH GAS','ADAMU','08143931290','adamuwadahrb@gmail.com','KANO','Kano','KOFAR WAIKA','Nigeria',2000.00,0.00,0.00,'0000-00-00','2022-04-12 12:34:23',5,'706','2022-04-12 12:34:23','706'),(4256,'','1','198','ELERA AGRO','MURTALA MUHAMMAD','09096893897','eleraagro@gmail.com','KANO','KANO','SHARADA PHASE 1','Nigeria',2000.00,0.00,0.00,'0000-00-00','2022-04-22 14:56:00',5,'706','2022-04-22 14:56:00','706'),(4257,'','1','198','IGWE','SANI IGWE','0907673905','musasamaila@','KANO','KANO','UNGUWA UKKU UNGUWAR KASHU','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-04-28 11:13:01',5,'706','2022-04-28 11:13:01','706'),(4258,'','1','198','DUNIYA','HAMISU WALI','08024694187','dunia@gmail.com','KANO','KANO','SAGAGI,KANO','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-06-06 13:10:42',5,'871','2022-06-06 13:10:42','871'),(4259,'','1','198','shehu area manager A A RANO','SHEHU KIBIYA','08037677908','abbansultan32@gmail.com','KIBIYA','KANO','KOFAR FADA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-06-12 19:02:51',5,'871','2022-06-12 19:02:51','871'),(4260,'','1','198','ELHAJ GAS','ABDULLAHI YUSUF','08096994332','abbansultan32@gmail.com','KUNBOTSO','KANO','N014 CHALAWA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-06-20 10:46:57',5,'871','2022-06-20 10:50:49','871'),(4261,'','1','198','A  MALAN  GAS','A  MALAN','08092135690','abbansultan32@gmail.com','KANO','KANO','TUDUN YPLA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-07-22 12:45:10',5,'871','2022-07-22 12:45:10','871'),(4262,'','1','198','NANET GAS','NAFI,U USAINI','07065357530','abbansultan32@gmail.com','KUNBOTSO','KANO','CHALAWA NDC','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-07-25 12:05:48',5,'871','2022-07-25 12:07:46','871'),(4263,'','1','198','ASIYA MAI WAINA','MAI WAINA GAS','08069612059','abbansultan32@gmail.com','KUNBOTSO','KANO','GAIDAN FULANI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-07-28 13:21:59',5,'871','2022-07-28 13:21:59','871'),(4264,'','1','198','ONE DAIL GAS','NASAR SIDI ALI','08037878747','abbansultan32@gmail.com','TARAUNI','KANO','KWNDILA ZARIYA ROAD F3','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-08-03 10:50:41',5,'871','2022-08-03 10:50:41','871'),(4265,'','1','198','DANBURJI VENTURES GAS','ASHIRU ABDULLAHI DANBURJI','08034512400','abbansultan32@gmail.com','KANO','KANO','NO 110 UGUWAR GINI DAN AGUNDI ROAD WAKILIN KUDUS OFFICE','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-08-11 15:22:03',5,'871','2022-08-11 15:22:03','871'),(4266,'','1','198','ZAWACIKI GAS','ABDULNAS SANI MUHD','09125051863','abbansultan32@gmail.com','KUNBOTSO','KANO','ZAWACIKI UNGUWAN JAKADA ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-08-17 07:29:30',5,'871','2022-08-17 07:29:30','871'),(4267,'','1','198','AL,IKLAS GAS 2','YAHAYA NASIRY','07038382968','abbansultan32@gmail.com','TARAUNI','KANO','HAUSAWA','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-08-20 13:59:15',0,'871','2022-08-20 14:10:17','871'),(4268,'','1','198','DOGO GAS','UMAR JIBRIN','09017160340','abbansultan32@gmail.com','FAGE','KANO','SABONGARI HAUSA /IBO RAOD NO 14','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-08-22 13:50:45',5,'871','2022-08-22 13:50:45','871'),(4269,'','1','198','ALKHAIRAT GAS KARAYE','SAFIYANU IBRAHIM','08067363083','abbansultan32@gmail.com','KARAYE','KANO','KARAYE KOFAR KUDU','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-08-23 09:55:50',5,'871','2022-08-23 09:55:50','871'),(4270,'','1','198','MUSDAT SHEHU GAS','isa shehu isa','09057805858','abbansultan32@gmail.com','gwale','KANO','gadon kaya ','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-08-26 17:05:57',5,'871','2022-09-21 13:08:22','953'),(4271,'','1','198','FBI GASES','24 SHARADA BATA KANO','08036056322','abbansultan32@gmail.com','KANO','KANO','SHARADA KANO','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-08-27 12:18:18',5,'871','2022-08-27 12:18:18','871'),(4272,'','1','198','BC GAS','NO 20 TARAUNI MARKET KANO','08036034105','bcgas@yahoo.com','KANO','KANO','NO 20 TARAUNI MARKET KANO STATE','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-09-08 11:25:22',5,'953','2022-09-08 11:25:22','953'),(4273,'','1','198','FAISAL AND BROTHERS INVESTIMEN','MAHMUD SULEIMAN YUSUF','08093931365','mahmudsuleimanyusuf19@gmail.co','KANO','KANO','DARMANAWA DAN TSINKE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-08 13:29:35',5,'953','2022-09-08 13:29:35','953'),(4274,'','1','198','VICTORY GAS','VICTORY','08165894057','aliyuibrahimmaibulo@gmail.com','KANO','KANO','SANI MAINAGGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-08 13:33:54',5,'953','2022-09-08 13:33:54','953'),(4275,'','1','198','UFA GAS','FAROUK UMAR ABUBAKAR','09098999551','farukdanfodio@gmail.com','KANO','KANO','tukuntaw kanoa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-08 13:35:55',5,'953','2022-09-08 13:35:55','953'),(4276,'','1','198','CLEAN GAS PANSHEKARA','IMRAN','08149526960','cleangas@gmail.com','KANO','KANO','PANSHEKARA','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-09-10 12:52:59',5,'953','2022-09-10 12:52:59','953'),(4277,'','1','198','KHALEEL TECHNICAL SERVICES & G','IBRAHIM ISAH','07036230036','khaleeltecnicalservices@gmail.','KANO','KANO','ZAWACIKI QTRS','Nigeria',200.00,0.00,0.00,'0000-00-00','2022-09-11 17:37:35',5,'953','2022-09-11 17:37:35','953'),(4278,'','1','198','ARAB GAS','SABIU ARAB','08037353836','arabgas003@gmail.com','KANO','KANO','TUDUN FULANI DARMANAWA KANO','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-09-11 17:55:06',5,'953','2022-09-11 17:55:06','953'),(4279,'','1','198','AMAM BAKERY','ARSALAN','07032796101','arsalanadamu@gmail.com','KANO','KANO','AGANDU','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-09-13 12:45:37',5,'953','2022-09-13 12:45:37','953'),(4280,'','1','198','LAMUS GAS','LAMUS GAS','08065013466','balaahmadlawan@gmail.com','kano','kano','bawwo road,zoo road kano','Nigeria',35000.00,0.00,0.00,'0000-00-00','2022-09-14 10:45:52',5,'953','2022-09-14 10:45:52','953'),(4281,'','1','198','YBY','YUSUF BELLO','08062173352','bcgas@yahoo.com','KUNBOTSO','KANO','MIDILE','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-15 09:56:28',5,'953','2022-09-15 09:56:28','953'),(4282,'','1','198','A Y SHITU GAS','SHITU','08063670490','abbansultan32@gmail.com','KUNBOTSO','KANO','GAIDA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-15 14:01:36',5,'953','2022-09-15 14:01:36','953'),(4283,'','1','198','HARUNA MUHAMMAD DK','KHALIFA MUHAMMAD','07025786824','harunamuhammad@gmail.com','KMC','KANO','SHARADA KWANAR KASUWA KANO\r\n','Nigeria',25000.00,0.00,0.00,'0000-00-00','2022-09-16 16:39:00',5,'953','2022-09-16 16:39:00','953'),(4284,'','1','198','SAS','SUNUSI SALMANU','08144534444','sunusisalmanu@gmail.com','GWALE','KANO','KUNTAU, GWALE LOCAL GOV. KANO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-17 12:08:02',5,'953','2022-09-17 12:08:02','953'),(4285,'','1','198','MARTABA GAS','MUSTAPHA','09065612221','mustaphaadammuhammad@gmail.com','KANO','KANO','SHEKA KARSHEN KWALTA','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-09-18 16:02:49',5,'953','2022-09-18 16:02:49','953'),(4286,'','1','198','UK GAS','ABDULLAHI IBRAHIM','07033804130','abbansultan32@gmail.com','TARAUNI','KANO','NO 5 KARKASA TARAUNI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-09-25 10:24:35',5,'953','2022-09-25 10:24:35','953'),(4287,'','1','198','MAI JAMA\"A GLOBAL LINK','AHMED BELLO MAUDE','08066276798','abmaude66@gmailcom','YOBE','YOBE','N09 MUHAMMAD IDRIS WAY POTISKUM, YOBE STATE','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-09-28 14:46:26',5,'953','2022-09-28 15:00:16','953'),(4288,'','1','198','AU GULU GAS','UMAR SALISU','07033041443','umarsalisu@gmail.com','KANO','KANO','GADON KAYA ,MAI TANGARIN STREET GWALE','Nigeria',25000.00,0.00,0.00,'0000-00-00','2022-09-29 16:36:25',5,'953','2022-09-29 16:36:25','953'),(4289,'','1','198','AKIB','ABUBAKAR','08032147654','akib1@gmail.com','KANO','KANO','BUNKURE','Nigeria',2500.00,0.00,0.00,'0000-00-00','2022-10-15 11:50:07',5,'953','2022-10-15 11:50:07','953'),(4290,'','1','198','A L D H COOKING GAS','ALIYU DAHIRU','08067079966','harunamuhammad@gmail.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 12:04:38',5,'953','2022-10-16 12:04:38','953'),(4291,'','1','198','KBSHOW GAS','KABIRU ADAMU ALI','08037170707','bcgas@yahoo.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 12:06:00',5,'953','2022-10-16 12:06:00','953'),(4292,'','1','198','MAM GAS','MUSBAHU ALIYU MUHD','08039374922','harunamuhammad@gmail.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 12:08:34',5,'953','2022-10-16 12:08:34','953'),(4293,'','1','198','GREEN GAS MAXI','ABDULSAMAD SUNUSI','08066114355','abbansultan32@gmail.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 12:20:40',5,'953','2022-10-16 12:20:40','953'),(4294,'','1','198','JABIR KWANA','JABIR KWANA','08066700755','abdulhameed3617@gmail.com','KANO','KANO','KWANAR DANGORA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-16 15:14:03',5,'953','2022-10-16 15:14:03','953'),(4295,'','1','198','MAI BAKA','ABUBAKAR KASIM','08081727580','maibaka@gmail.com','KANO','KANO','RIJIYAR ZAKI','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-10-16 15:17:32',5,'953','2022-10-16 15:17:32','953'),(4296,'','1','198','RANAU ASSOCIATES ','ADO ABDULLAHI','08034535613','adrano2004@gmail.com','KANO','KANO','GANDU','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-10-23 13:11:08',5,'953','2022-10-23 13:11:08','953'),(4297,'','1','198','Multi synergy gas','alhaji','07061200757','hassanu11id1030@gmail.com','KANO','KANO','nil','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-03 16:52:29',5,'953','2022-11-03 16:52:29','953'),(4298,'','1','198','MAI KEKE ','ADAMU HAMZA','08038861354','hassanu11id1030@gmail.com','KANO','KANO','JAE KWANAR GANDUJE','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-10 10:51:55',5,'953','2022-11-10 10:51:55','953'),(4299,'','1','198','JIKAN TAJIRA GWARZO GAS','MUHAMMAD GARBA GWARZO','08072065686','jikan tajira@yahoo.com','KANO','KANO','KOFAR FADA GWARZO, KANO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-12 13:18:04',5,'953','2022-11-12 13:18:04','953'),(4300,'','1','198','SULEIMAN GAS','SULEIMAN YUSUF','08022372902','suleiman@gmail.com','KANO','KANO','JA\'OJI KANO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-13 17:25:40',5,'953','2022-11-13 17:25:40','953'),(4301,'','1','198','EL HAGE A INDUSTRIES LTD','ABDULLAHI YUSUF','08096994332','hassanu11id1030@gmail.com','KANO','KANO','14 CHALLAWA INDUSTRIAL ESTATE KANO','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-18 10:36:40',5,'953','2022-11-18 10:36:40','953'),(4302,'','1','198','GARAJE GAS','DANJUMA SHUAIBU','07084348419','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-20 12:49:42',5,'953','2022-11-20 12:49:42','953'),(4303,'','1','198','LUK','LAWAN KHALEED ABDUL','07030072785','hassanu11id1030@gmail.com','KANO','KANO','CHIRANCHI UNGUWAR KWARI','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-22 07:36:35',5,'953','2022-11-22 07:36:35','953'),(4304,'','1','198','M MAIKATI','AUWAL YAHAYYA','08169064409','auwalhaiyya@gmail.com','KANO','KANO','NAIBAWA','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-11-23 10:27:21',5,'953','2022-11-23 10:27:21','953'),(4305,'','1','198','MAI GAS','ALIYU ABUBAKAR','09122612135','adrano2004@gmail.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-23 15:34:07',5,'953','2022-11-23 15:34:07','953'),(4306,'','1','198','SAMINU GAS','MUSBAHU MUHAMMAD','07030949648','hassanu11id1030@gmail.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-26 11:58:45',5,'953','2022-11-26 11:58:45','953'),(4307,'','1','198','MUBARAK GAS','MUBARAK LAWAL','08133375700','hassanu11id1030@gmail.com','KANO','KANO','NIL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 11:03:47',5,'953','2022-11-30 11:03:47','953'),(4308,'','1','198','AMHAZ MICRO GAS','TARMAZI ALI','08061597073','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-07 13:38:08',5,'953','2022-12-07 13:38:08','953'),(4309,'','1','198','BA TUDUNWADA REFILLING GAS','ALIYU MAMUDA YAHAYA','09061900081','hassanu11id1030@gmail.com','KANO','KANO','TUDUNWADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-09 14:26:05',5,'953','2022-12-09 14:26:05','953'),(4310,'','1','198','GULU GAS SHARADA','ALHAJI MAIKUDI','08065880610','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-17 16:38:42',5,'953','2022-12-17 16:38:42','953'),(4311,'','1','198','SAF GAS','SURAJ','07038350313','safhotel@gmail.com','KANO','KANO','sakau layout wudil','Nigeria',5000.00,0.00,0.00,'0000-00-00','2022-12-22 21:05:49',5,'953','2022-12-22 21:05:49','953'),(4312,'','1','198','SAFhotel GAS','SURAJ','07038350313','safhotel@gmail.com','KANO','KANO','sakau layout wudil','Nigeria',1500.00,0.00,0.00,'0000-00-00','2022-12-22 21:06:57',5,'953','2022-12-22 21:06:57','953'),(4313,'','1','198','AWO GAS','ABDULLAHI IDRIS','08104494202','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-23 15:50:05',5,'953','2022-12-23 15:50:05','953'),(4314,'','1','198','RUMI GAS INTEGRATED','SANI AMINU ABUBAKAR','08089111199','adrano2004@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-06 20:22:51',5,'953','2023-01-06 20:22:51','953'),(4315,'','1','198','BEST CLASS KABUGA GAS INTEGRAT','SANI AMINU ABUBAKAR','09023770969','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-06 20:26:52',5,'953','2023-01-06 20:26:52','953'),(4316,'','1','198','GUARANTY GAS','ABUBAKAR MUHAMMAD ISYAKU','08061619280','hassanu11id1030@gmail.com','KANO','KANO','SHARADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-09 14:42:16',5,'953','2023-01-09 14:42:16','953'),(4317,'','1','198','CARDINAL GAS','RABILU SANI YAHAYA','08037662320','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-10 14:49:39',5,'953','2023-01-10 14:49:39','953'),(4318,'','1','198','AL-IHSAN','MUSTAPHA ABUBAKAR','08076779003','alihsangas@gmail.com','KANO','KANO','KUNTAU ZENAVISION','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-01-10 16:39:11',5,'953','2023-01-10 16:39:11','953'),(4319,'','1','198','barhama gas','barhama','0907673905','usamaumar596@gmail.com','KANO','KANO','No 31 zaria road','Nigeria',200.00,0.00,0.00,'0000-00-00','2023-01-11 17:55:50',5,'953','2023-01-11 17:55:50','953'),(4320,'','1','198','ALKHAIR GAS','NAZIFI ABUBAKAR','07064731933','hassanu11id1030@gmail.com','KANO','KANO','LAMIDO CRESCENT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-15 15:12:43',5,'953','2023-01-15 15:12:43','953'),(4321,'','1','198','UNITED GASES','ALHAJI ABDULRAZAK','08065671926','hassanu11id1030@gmail.com','KANO','KANO','PLOT 13 CHALLAWA INDUSTRIAL AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-20 11:45:43',5,'953','2023-01-20 11:45:43','953'),(4322,'','1','198','HS GLOBAL GENERAL ENTERPRISE','TASIU ABDULLAHI','09037387547','hassanu11id1030@gmail.com','KANO','KANO','SHARADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-24 16:02:40',5,'953','2023-01-24 16:02:40','953'),(4323,'','1','198','NHD GAS','NIZIRU HALLARU DAUDA','08035011330','hassanu11id1030@gmail.com','KANO','KANO','SHEKA VARANDA SOLAR LADO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-25 10:06:28',5,'953','2023-01-25 10:06:28','953'),(4324,'','1','198','TRANSFER TO BOMPAI PLANT','BOMPAI PLANT','09061715576','hassanu11id1030@gmail.com','KANO','KANO','KANO','Nigeria',5000.00,0.00,0.00,'0000-00-00','2023-02-03 10:35:08',5,'953','2023-02-03 10:35:08','953'),(4325,'','1','198','JUDA OIL & GAS','JUDA OIL & GAS','08060166511','hassanu11id1030@gmail.com','KANO','KANO','GADON KAYA BABBAN LAYI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-06 19:07:26',5,'953','2023-02-06 19:07:26','953'),(4326,'','1','198','RISHCO RESTAURANT GAS ','UMAR SALISU ','08060577812','hassanu11id1030@gmail.com','KANO','KANO','TITIN ADAMU DAN KURA ZOO ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-18 10:49:56',5,'953','2023-02-18 10:49:56','953'),(4327,'','1','198','STOCK GAP','alhaji','09061715576','adrano2004@gmail.com','PORTACOURT','PORTACOURT','PORTHACOURT','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-02-22 08:45:02',5,'953','2023-02-22 08:45:02','953'),(4328,'','1','198','STOCKGAP','ALHAJI ABDULRAZAK','08034535613','aliyufaragai09@yahoo.com','PORTHATRCOURT','PORTHATRCOURT','PORTHATRCOURT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-22 08:51:03',5,'953','2023-02-22 08:51:03','953'),(4329,'','1','198','STOCKGAP GAS','alhaji','08034535613','aliyufaragai09@yahoo.com','RIVERS','RIVERS','PORTHARCOURT','Nigeria',1500.00,0.00,0.00,'0000-00-00','2023-02-22 09:03:08',5,'953','2023-02-22 09:03:08','953'),(4330,'','1','198','RIMGIM','GARBA USMAN RIMGIM','08035049918','adrano2004@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-27 17:41:40',5,'953','2023-02-27 17:41:40','953'),(4331,'','1','198','GUEST PRIDE HOTEL GAS','BASHIR ABUBAKAR ','08027538808','hassanu11id1030@gmail.com','KANO','KANO','NO-1 ARCH IBRAHIM HARUNA LINK FARM CENTER','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-09 10:03:52',5,'953','2023-03-09 10:03:52','953'),(4332,'','1','198','RASHKO ','alhaji','08081652217','adrano2004@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-09 12:42:38',5,'953','2023-03-09 12:42:38','953');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (1,'1','198','4267',0,'CLASH','2022-08-20 14:09:50');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','198',1,'1016',0.00,22502.00,'2022-07-26','new','2022-07-26 12:36:09','483','483',2022,'483','2022-07-26 12:36:09',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3010 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','198','1016',3002,'5','LPG NOZZLE 1',687768.79,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1017',3003,'5','LPG NOZZLE 2',671332.36,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1017',3004,'5','LPG NOZZLE 3',2105.74,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1017',3005,'5','LPG NOZZLE 4',238.05,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1017',3006,'5','LPG NOZZLE 5',17.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1016',3007,'5','LPG NOZZLE 6',225.16,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1016',3008,'5','LPG NOZZLE 7',6.00,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','198','1016',3009,'5','LPG NOZZLE 8',30.00,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257967 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','198',236677,'DAILY SHIFTS','2021-11-04','2021-11-04 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-04 17:45:30','706','2021-11-04 17:45:53',10,0),('1','198',236739,'DAILY SHIFTS','2021-11-05','2021-11-05 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-05 18:20:03','706','2021-11-05 18:20:50',10,0),('1','198',236962,'DAILY SHIFTS','2021-11-06','2021-11-06 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-06 17:58:29','706','2021-11-06 17:59:19',10,0),('1','198',237167,'DAILY SHIFTS','2021-11-07','2021-11-07 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-08 05:04:23','706','2021-11-08 05:05:03',10,0),('1','198',237369,'DAILY SHIFTS','2021-11-08','2021-11-08 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-08 18:05:54','706','2021-11-08 18:06:20',10,0),('1','198',237598,'DAILY shift ','2021-11-09','2021-11-09 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-09 21:12:43','706','2021-11-09 21:13:19',10,0),('1','198',237862,'DAILY SHIFTS','2021-11-10','2021-11-10 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-10 21:02:06','706','2021-11-10 21:03:10',10,0),('1','198',238127,'DAILY SHIFTS','2021-11-11','2021-11-11 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-12 04:09:42','706','2021-11-12 04:10:33',10,0),('1','198',238336,'DAILY SHIFTS','2021-11-12','2021-11-12 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-12 09:56:41','706','2021-11-12 09:57:04',10,0),('1','198',238457,'DAILY SHIFTS','2021-11-12','2021-11-12 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-12 21:02:45','706','2021-11-12 21:03:20',10,0),('1','198',238592,'DAILY SHIFTS','2021-11-13','2021-11-13 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-14 03:48:22','706','2021-11-14 03:48:54',10,0),('1','198',238811,'DAILY SHIFTS','2021-11-14','2021-11-14 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-14 17:49:24','706','2021-11-14 17:49:58',10,0),('1','198',239075,'DAILY SHIFTS','2021-11-15','2021-11-15 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-15 17:44:07','706','2021-11-15 17:45:22',10,0),('1','198',239298,'DAILY SHIFTS','2021-11-16','2021-11-16 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-17 04:51:35','706','2021-11-17 04:52:07',10,0),('1','198',239509,'DAILY SHIFTS','2021-11-17','2021-11-17 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-17 09:25:24','706','2021-11-17 09:26:09',10,0),('1','198',239611,'DAILY SHIFTS','2021-11-17','2021-11-17 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-17 09:58:37','706','2021-11-17 09:58:58',10,0),('1','198',239624,'DAILY SHIFTS','2021-11-17','2021-11-17 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-17 17:53:08','706','2021-11-17 17:53:52',10,0),('1','198',239756,'DAILY SHIFTS','2021-11-18','2021-11-18 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-19 05:53:58','706','2021-11-19 05:54:48',10,0),('1','198',239993,'DAILY SHIFTS','2021-11-19','2021-11-19 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-20 04:53:04','706','2021-11-20 04:53:35',10,0),('1','198',240179,'DAILY SHIFTS','2021-11-20','2021-11-20 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-20 17:42:28','706','2021-11-20 17:43:01',10,0),('1','198',240427,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-21 17:24:49','706','2021-11-21 17:25:18',10,0),('1','198',240684,'DAILY SHIFTS','2021-11-22','2021-11-22 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-23 05:18:57','706','2021-11-23 05:19:33',10,0),('1','198',240957,'DAILY SHIFTS','2021-11-23','2021-11-23 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-24 06:07:17','706','2021-11-24 06:08:29',10,0),('1','198',241224,'DAILY SHIFTS','2021-11-24','2021-11-24 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-25 04:51:12','706','2021-11-25 04:51:51',10,0),('1','198',241470,'DAILY SHIFTS','2021-11-25','2021-11-25 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-25 20:39:42','706','2021-11-25 20:40:13',10,0),('1','198',241741,'DAILY SHIFTS','2021-11-26','2021-11-26 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-26 09:28:09','706','2021-11-26 09:28:31',10,0),('1','198',241823,'DAILY SHIFTS','2021-11-26','2021-11-26 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-27 08:15:39','706','2021-11-27 08:16:25',10,0),('1','198',242024,'DAILY SHIFTS','2021-11-27','2021-11-27 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-28 05:29:35','706','2021-11-28 05:30:24',10,0),('1','198',242194,'DAILY SHIFTS','2021-11-28','2021-11-28 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-29 05:01:25','706','2021-11-29 05:01:56',10,0),('1','198',242413,'DAILY SHIFTS','2021-11-29','2021-11-29 00:00:00',NULL,'706',0.00,0.00,'706','2021-11-30 06:09:28','706','2021-11-30 06:09:53',10,0),('1','198',242679,'DAILY SHIFTS','2021-11-30','2021-11-30 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-01 05:18:13','706','2021-12-01 05:18:59',10,0),('1','198',242908,'DAILY SHIFTS','2021-12-01','2021-12-01 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-02 06:10:18','706','2021-12-02 06:11:09',10,0),('1','198',243145,'DAILY SHIFTS','2021-12-02','2021-12-02 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-03 06:00:06','706','2021-12-03 06:01:45',10,0),('1','198',243368,'DAILY SHIFTS','2021-12-03','2021-12-03 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-03 14:22:39','706','2021-12-03 14:23:21',10,0),('1','198',243513,'DAILY SHIFTS','2021-12-03','2021-12-03 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-03 15:00:32','706','2021-12-03 15:01:05',10,0),('1','198',243519,'DAILY SHIFTS','2021-12-03','2021-12-03 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-04 07:09:54','706','2021-12-04 07:11:17',10,0),('1','198',243629,'DAILY SHIFTS','2021-12-04','2021-12-04 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-05 06:03:42','706','2021-12-05 06:04:25',10,0),('1','198',243830,'DAILY SHIFTS','2021-12-05','2021-12-05 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-06 05:14:29','706','2021-12-06 05:15:29',10,0),('1','198',244037,'DAILY SHIFTS','2021-12-06','2021-12-06 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-07 06:51:27','706','2021-12-07 06:53:15',10,0),('1','198',244312,'DAILY SHIFTS','2021-12-07','2021-12-07 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-08 05:53:23','706','2021-12-08 05:54:27',10,0),('1','198',244517,'DAILY SHIFTS','2021-12-08','2021-12-08 00:00:00',NULL,'706',30100.00,31600.00,'706','2021-12-09 06:03:32','706','2021-12-09 06:05:03',10,0),('1','198',244758,'DAILY SHIFTS','2021-12-09','2021-12-09 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-09 20:17:57','706','2021-12-09 20:20:13',10,0),('1','198',244956,'DAILY SHIFTS','2021-12-10','2021-12-10 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-11 06:13:40','706','2021-12-11 06:14:26',10,0),('1','198',245222,'DAILY sifts','2021-12-11','2021-12-11 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-12 06:03:11','706','2021-12-12 06:04:52',10,0),('1','198',245440,'DAILY SHIFTS','2021-12-12','2021-12-12 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-13 05:31:41','706','2021-12-13 05:32:41',10,0),('1','198',245671,'DAILY SHIFTS','2021-12-13','2021-12-13 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-13 06:30:13','706','2021-12-13 06:30:47',10,0),('1','198',245690,'DAILY SHIFTS','2021-12-13','2021-12-13 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-13 06:41:25','706','2021-12-13 06:41:50',10,0),('1','198',245693,'DAILY SHIFTS','2021-12-13','2021-12-13 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-14 06:17:56','706','2021-12-14 06:19:55',10,0),('1','198',245949,'DAILY SHIFTS','2021-12-14','2021-12-14 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-15 05:49:41','706','2021-12-15 05:50:16',10,0),('1','198',246189,'DAILY SHIFTS','2021-12-15','2021-12-15 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-15 20:41:47','706','2021-12-15 20:42:33',10,0),('1','198',246461,'DAILY SHIFTS','2021-12-16','2021-12-16 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-17 04:41:39','706','2021-12-17 04:42:09',10,0),('1','198',246682,'DAILY SHIFTS','2021-12-17','2021-12-17 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-18 06:10:11','706','2021-12-18 06:12:35',10,0),('1','198',246941,'DAILY SHIFTS','2021-12-18','2021-12-18 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-19 05:38:20','706','2021-12-19 05:39:01',10,0),('1','198',247162,'DAILY SHIFTS','2021-12-19','2021-12-19 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-19 18:06:12','706','2021-12-19 18:06:53',10,0),('1','198',247397,'DAILY SHIFTS','2021-12-20','2021-12-20 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-20 18:01:53','706','2021-12-20 18:02:31',10,0),('1','198',247648,'DAILY SHIFTS','2021-12-21','2021-12-21 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-21 22:29:13','706','2021-12-22 06:38:16',10,0),('1','198',247928,'DAILY SHIFTS','2021-12-22','2021-12-22 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-22 06:58:46','706','2021-12-22 06:59:09',10,0),('1','198',247937,'DAILY SHIFTS','2021-12-22','2021-12-22 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-23 06:20:23','706','2021-12-23 06:21:07',10,0),('1','198',248167,'DAILY SHIFTS','2021-12-23','2021-12-23 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-23 19:45:46','706','2021-12-23 19:47:27',10,0),('1','198',248420,'DAILY SHIFTS','2021-12-24','2021-12-24 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-24 22:55:35','706','2021-12-24 22:57:50',10,0),('1','198',248636,'DAILY SHIFTS','2021-12-25','2021-12-25 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-25 18:14:21','706','2021-12-25 18:15:38',10,0),('1','198',248873,'DAILY SHIFTS','2021-12-26','2021-12-26 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-26 18:01:36','706','2021-12-26 18:01:58',10,0),('1','198',249106,'DAILY SHIFTS','2021-12-27','2021-12-27 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-28 06:03:18','706','2021-12-28 06:03:47',10,0),('1','198',249345,'DAILY SHIFTS','2021-12-28','2021-12-28 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-29 05:14:22','706','2021-12-29 05:14:55',10,0),('1','198',249573,'DAILY shift as','2021-12-29','2021-12-29 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-30 06:02:29','706','2021-12-30 06:03:31',10,0),('1','198',249853,'DAILY SHIFTS','2021-12-30','2021-12-30 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-30 20:31:50','706','2021-12-30 20:32:42',10,0),('1','198',250064,'DAILY SHIFTS','2021-12-30','2021-12-30 00:00:00',NULL,'706',0.00,0.00,'706','2021-12-30 21:10:24','706','2021-12-30 21:10:42',10,0),('1','198',250105,'DAILY SHIFTS','2021-12-31','2021-12-31 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-01 05:37:03','706','2022-01-01 05:37:57',10,0),('1','198',250327,'DAILY SHIFTS','2022-01-01','2022-01-01 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-01 20:19:16','706','2022-01-01 20:21:01',10,0),('1','198',250562,'DAILY SHIFTS','2022-01-02','2022-01-02 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-03 06:16:38','706','2022-01-03 06:17:22',10,0),('1','198',250804,'DAILY SHIFTS','2022-01-03','2022-01-03 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-04 05:57:54','706','2022-01-04 05:58:43',10,0),('1','198',251021,'DAILY SHIFTS','2022-01-04','2022-01-04 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-05 06:31:24','706','2022-01-05 06:32:37',10,0),('1','198',251285,'DAILY SHIFTS','2022-01-05','2022-01-05 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-06 07:01:18','706','2022-01-06 07:02:04',10,0),('1','198',251515,'DAILY SHIFTS','2022-01-06','2022-01-06 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-07 06:05:03','706','2022-01-07 06:05:36',10,0),('1','198',251751,'DAILY SHIFTS','2022-01-07','2022-01-07 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-08 07:20:58','706','2022-01-08 07:21:48',10,0),('1','198',252000,'DAILY SHIFTS','2022-01-08','2022-01-08 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-09 08:52:32','706','2022-01-09 08:53:09',10,0),('1','198',252271,'DAILY SHIFTS','2022-01-09','2022-01-09 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-09 21:28:07','706','2022-01-09 21:29:08',10,0),('1','198',252479,'DAILY SHIFTS','2022-01-10','2022-01-10 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-11 06:05:14','706','2022-01-11 06:06:14',10,0),('1','198',252702,'DAILY SHIFTS','2022-01-11','2022-01-11 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-12 06:45:59','706','2022-01-12 06:46:41',10,0),('1','198',252962,'DAILY SHIFTS','2022-01-12','2022-01-12 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-12 21:32:58','706','2022-01-13 07:48:33',10,0),('1','198',253222,'DAILY SHIFTS5','2022-01-13','2022-01-13 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-14 06:12:59','706','2022-01-14 06:21:17',10,0),('1','198',253465,'DAILY SHIFTS','2022-01-14','2022-01-14 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-14 22:58:00','706','2022-01-14 22:59:47',10,0),('1','198',253697,'DAILY SHIFTS','2022-01-15','2022-01-15 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-16 06:25:35','706','2022-01-16 06:29:42',10,0),('1','198',253946,'DAILY SHIFTS','2022-01-16','2022-01-16 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-16 21:38:32','706','2022-01-16 21:39:33',10,0),('1','198',254225,'DAILY SHIFTS','2022-01-17','2022-01-17 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-17 08:45:39','706','2022-01-17 08:47:02',10,0),('1','198',254250,'DAILY SHIFTS','2022-01-17','2022-01-17 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-18 06:54:38','706','2022-01-18 06:57:37',10,0),('1','198',254444,'DAILY SHIFTS','2022-01-18','2022-01-18 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-19 07:29:53','706','2022-01-19 07:32:09',10,0),('1','198',254713,'DAILY SHIFTS','2022-01-19','2022-01-19 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-19 19:14:00','706','2022-01-20 06:14:26',10,0),('1','198',254932,'DAILY SHIFTS','2022-01-20','2022-01-20 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-21 07:16:19','706','2022-01-21 07:19:17',10,0),('1','198',255197,'DAILY SHIFTS','2022-01-21','2022-01-21 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-22 07:25:26','706','2022-01-22 07:29:20',10,0),('1','198',255465,'DAILY SHIFTS','2022-01-22','2022-01-22 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-22 18:53:46','706','2022-01-22 18:57:00',10,0),('1','198',255706,'DAILY SHIFTS','2022-01-23','2022-01-23 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-24 07:53:32','706','2022-01-24 07:55:49',10,0),('1','198',255974,'DAILY SHIFTS','2022-01-24','2022-01-24 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-25 06:53:03','706','2022-01-25 06:58:55',10,0),('1','198',256217,'DAILY SHIFTS','2022-01-25','2022-01-25 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-26 06:48:53','706','2022-01-26 06:59:57',10,0),('1','198',256481,'DAILY SHIFTS','2022-01-26','2022-01-26 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-27 06:37:41','706','2022-01-27 06:51:39',10,0),('1','198',256722,'DAILY SHIFTS','2022-01-27','2022-01-27 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-28 07:26:34','706','2022-01-28 07:27:56',10,0),('1','198',256976,'DAILY SHIFTS','2022-01-28','2022-01-28 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-29 09:55:51','706','2022-01-29 10:02:29',10,0),('1','198',257300,'DAILY SHIFTS','2022-01-29','2022-01-29 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-29 19:51:34','706','2022-01-30 06:47:03',10,0),('1','198',257485,'DAILY SHIFTS','2022-01-30','2022-01-30 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-31 08:07:05','706','2022-01-31 08:09:28',10,0),('1','198',257486,'DAILY SHIFTS','2022-01-31','2022-01-31 00:00:00',NULL,'706',0.00,0.00,'706','2022-01-31 19:32:55','706','2022-01-31 19:33:24',10,0),('1','198',257487,'DAILY SHIFTS','2022-02-01','2022-02-01 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-02 07:59:36','706','2022-02-02 08:00:01',10,0),('1','198',257488,'DAILY SHIFTS','2022-02-02','2022-02-02 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-02 19:29:46','706','2022-02-02 19:30:16',10,0),('1','198',257489,'DAILY SHIFTS','2022-02-03','2022-02-03 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-04 07:35:25','706','2022-02-04 07:36:00',10,0),('1','198',257490,'DAILY SHIFTS','2022-02-04','2022-02-04 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-05 07:40:58','706','2022-02-05 07:41:29',10,0),('1','198',257491,'DAILY SHIFTS','2022-02-05','2022-02-05 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-06 07:02:16','706','2022-02-06 07:02:44',10,0),('1','198',257492,'DAILY SHIFTS','2022-02-06','2022-02-06 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-07 07:45:21','706','2022-02-07 07:45:51',10,0),('1','198',257493,'DAILY SHIFTS','2022-02-07','2022-02-07 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-08 07:28:36','706','2022-02-08 07:29:42',10,0),('1','198',257494,'DAILY SHIFTS','2022-02-08','2022-02-08 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-09 06:40:02','706','2022-02-09 06:40:24',10,0),('1','198',257495,'DAILY SHIFTS','2022-02-09','2022-02-09 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-10 07:59:44','706','2022-02-10 08:00:05',10,0),('1','198',257496,'DAILY SHIFTS','2022-02-10','2022-02-10 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-11 07:26:01','706','2022-02-11 07:26:40',10,0),('1','198',257497,'DAILY SHIFTS','2022-02-11','2022-02-11 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-12 07:43:06','706','2022-02-12 07:43:33',10,0),('1','198',257498,'DAILY SHIFTS','2022-02-12','2022-02-12 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-13 07:42:12','706','2022-02-13 07:51:23',10,0),('1','198',257499,'DAILY SHIFTS','2022-02-13','2022-02-13 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-14 06:20:39','706','2022-02-14 06:21:00',10,0),('1','198',257500,'DAILY SHIFTS','2022-02-14','2022-02-14 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-15 07:36:08','706','2022-02-15 07:36:46',10,0),('1','198',257501,'DAILY SHIFTS','2022-02-15','2022-02-15 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-16 07:54:29','706','2022-02-16 07:55:03',10,0),('1','198',257502,'DAILY SHIFTS','2022-02-16','2022-02-16 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-17 08:45:16','706','2022-02-17 08:46:17',10,0),('1','198',257503,'DAILY SHIFTS','2022-02-17','2022-02-17 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-18 08:10:16','706','2022-02-18 08:10:53',10,0),('1','198',257504,'DAILY SHIFTS','2022-02-18','2022-02-18 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-19 08:21:51','706','2022-02-19 08:22:19',10,0),('1','198',257505,'DAILY SHIFTS','2022-02-19','2022-02-19 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-20 08:17:49','706','2022-02-20 08:18:23',10,0),('1','198',257506,'DAILY SHIFTS','2022-02-20','2022-02-20 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-21 07:32:25','706','2022-02-21 07:32:49',10,0),('1','198',257507,'DAILY SHIFTS','2022-02-21','2022-02-21 00:00:00',NULL,'706',0.00,0.00,'706','2022-02-22 07:34:53','706','2022-02-22 07:35:31',10,0),('1','198',257508,'DAILY SHIFTS','2022-02-22','2022-02-22 07:36:12','2022-02-23 07:36:12','706',0.00,0.00,'706','2022-02-22 19:26:43','706','2022-02-22 19:27:03',10,0),('1','198',257509,'DAILY SHIFTS','2022-02-23','2022-02-23 08:12:33','2022-02-24 08:12:33','706',0.00,0.00,'706','2022-02-24 06:08:14','706','2022-02-24 06:09:16',10,0),('1','198',257510,'DAILY SHIFTS','2022-02-24','2022-02-24 06:09:47','2022-02-25 06:09:47','706',0.00,0.00,'706','2022-02-24 19:21:58','706','2022-02-24 19:22:21',10,0),('1','198',257511,'DAILY SHIFTS','2022-02-25','2022-02-25 07:43:25','2022-02-26 07:43:25','706',0.00,0.00,'706','2022-02-26 10:17:27','706','2022-02-26 10:17:52',10,0),('1','198',257512,'DAILY SHIFTS','2022-02-26','2022-02-26 10:18:20','2022-02-27 10:18:20','706',0.00,0.00,'706','2022-02-26 19:24:40','706','2022-02-26 19:25:01',10,0),('1','198',257513,'DAILY SHIFTS','2022-02-27','2022-02-27 08:09:46','2022-02-28 08:09:46','706',0.00,0.00,'706','2022-02-28 06:28:04','706','2022-02-28 06:28:31',10,0),('1','198',257514,'DAILY SHIFTS','2022-02-28','2022-02-28 06:28:57','2022-03-01 06:28:57','706',0.00,0.00,'706','2022-03-01 07:03:46','706','2022-03-01 07:04:04',10,0),('1','198',257515,'DAILY SHIFTS','2022-03-01','2022-03-01 07:04:40','2022-03-02 07:04:40','706',0.00,0.00,'706','2022-03-02 07:18:47','706','2022-03-02 07:19:20',10,0),('1','198',257516,'DAILY SHIFTS','2022-03-02','2022-03-02 07:19:44','2022-03-03 07:19:44','706',0.00,0.00,'706','2022-03-03 06:32:32','706','2022-03-03 06:32:53',10,0),('1','198',257517,'DAILY SHIFTS','2022-03-03','2022-03-03 06:33:29','2022-03-04 06:33:29','706',0.00,0.00,'706','2022-03-04 07:41:35','706','2022-03-04 07:42:03',10,0),('1','198',257518,'DAILY SHIFTS','2022-03-04','2022-03-04 07:42:52','2022-03-05 07:42:52','706',0.00,0.00,'706','2022-03-05 07:00:15','706','2022-03-05 07:00:56',10,0),('1','198',257519,'DAILY SHIFTS','2022-03-05','2022-03-05 07:01:26','2022-03-06 07:01:26','706',0.00,0.00,'706','2022-03-06 06:07:46','706','2022-03-06 06:08:13',10,0),('1','198',257520,'DAILY SHIFTS','2022-03-06','2022-03-06 06:08:48','2022-03-07 06:08:48','706',0.00,0.00,'706','2022-03-07 07:42:54','706','2022-03-07 07:43:45',10,0),('1','198',257521,'DAILY SHIFTS','2022-03-07','2022-03-07 07:45:16','2022-03-08 07:45:16','706',0.00,0.00,'706','2022-03-08 06:00:34','706','2022-03-08 06:01:01',10,0),('1','198',257522,'DAILY SHIFTS','2022-03-08','2022-03-08 06:02:07','2022-03-09 06:02:07','706',0.00,0.00,'706','2022-03-09 06:04:32','706','2022-03-09 06:05:02',10,0),('1','198',257523,'DAILY SHIFTS','2022-03-08','2022-03-09 07:12:55','2022-03-10 07:12:55','706',0.00,0.00,'706','2022-03-09 07:41:36','706','2022-03-09 07:42:05',10,0),('1','198',257524,'DAILY SHIFTS','2022-03-09','2022-03-09 07:52:01','2022-03-10 07:52:01','706',0.00,0.00,'706','2022-03-09 23:02:39','706','2022-03-09 23:03:01',10,0),('1','198',257525,'DAILY SHIFTS','2022-03-10','2022-03-10 07:41:12','2022-03-11 07:41:12','706',0.00,0.00,'706','2022-03-11 06:54:30','706','2022-03-11 06:58:12',10,0),('1','198',257526,'DAILY SHIFTS','2022-03-11','2022-03-11 06:59:37','2022-03-12 06:59:37','706',0.00,0.00,'706','2022-03-11 23:39:37','706','2022-03-11 23:40:00',10,0),('1','198',257527,'DAILY SHIFTS','2022-03-12','2022-03-12 07:58:20','2022-03-13 07:58:20','706',0.00,0.00,'706','2022-03-13 06:14:01','706','2022-03-13 06:14:33',10,0),('1','198',257528,'DAILY SHIFTS','2022-03-13','2022-03-13 06:15:04','2022-03-14 06:15:04','706',0.00,0.00,'706','2022-03-13 23:09:42','706','2022-03-13 23:10:14',10,0),('1','198',257529,'DAILY  SHIFT','2022-03-14','2022-03-14 07:31:21','2022-03-15 07:31:21','706',0.00,0.00,'706','2022-03-15 06:30:09','706','2022-03-15 06:30:36',10,0),('1','198',257530,'DAILY SHIFTS','2022-03-15','2022-03-15 06:31:19','2022-03-16 06:31:19','706',0.00,0.00,'706','2022-03-15 19:31:43','706','2022-03-15 19:32:12',10,0),('1','198',257531,'DAILY  SHIFT','2022-03-16','2022-03-16 05:53:33','2022-03-17 05:53:33','706',0.00,0.00,'706','2022-03-16 19:22:32','706','2022-03-16 19:23:09',10,0),('1','198',257532,'DAILY  SHIFT','2022-03-17','2022-03-17 06:54:32','2022-03-18 06:54:32','706',0.00,0.00,'706','2022-03-17 19:36:52','706','2022-03-17 19:37:22',10,0),('1','198',257533,'DAILY  SHIFT','2022-03-18','2022-03-18 07:36:10','2022-03-19 07:36:10','706',0.00,0.00,'706','2022-03-19 06:27:19','706','2022-03-19 06:27:46',10,0),('1','198',257534,'DAILY  SHIFT','2022-03-19','2022-03-19 06:28:55','2022-03-20 06:28:55','706',0.00,0.00,'706','2022-03-19 22:49:01','706','2022-03-19 22:49:32',10,0),('1','198',257535,'DAILY  SHIFT','2022-03-20','2022-03-20 19:08:07','2022-03-21 19:08:07','706',0.00,0.00,'706','2022-03-20 19:17:24','706','2022-03-20 19:17:54',10,0),('1','198',257536,'DAILY SHIFTS','2022-03-21','2022-03-21 10:04:40','2022-03-22 10:04:40','706',0.00,0.00,'706','2022-03-22 05:51:51','706','2022-03-22 05:52:27',10,0),('1','198',257537,'DAILY SHIFTS','2022-03-22','2022-03-22 05:59:38','2022-03-23 05:59:38','706',0.00,0.00,'706','2022-03-22 23:39:36','706','2022-03-22 23:40:18',10,0),('1','198',257538,'DAILY SHIFTS','2022-03-23','2022-03-23 07:01:37','2022-03-24 07:01:37','706',0.00,0.00,'706','2022-03-24 00:26:29','706','2022-03-24 00:27:06',10,0),('1','198',257539,'DAILY  SHIFT','2022-03-24','2022-03-24 07:43:44','2022-03-25 07:43:44','706',0.00,0.00,'706','2022-03-25 06:20:46','706','2022-03-25 06:21:26',10,0),('1','198',257540,'DAILY SHIFTS','2022-03-25','2022-03-25 06:22:03','2022-03-26 06:22:03','706',0.00,0.00,'706','2022-03-26 00:18:34','706','2022-03-26 00:23:58',10,0),('1','198',257541,'DAILY SHIFTS','2022-03-26','2022-03-26 08:45:26','2022-03-27 08:45:26','706',0.00,0.00,'706','2022-03-27 05:52:30','706','2022-03-27 05:53:10',10,0),('1','198',257542,'DAILY SHIFTS','2022-03-27','2022-03-27 05:57:00','2022-03-28 05:57:00','706',0.00,0.00,'706','2022-03-28 08:15:37','706','2022-03-28 08:16:14',10,0),('1','198',257543,'DAILY SHIFTS','2022-03-28','2022-03-28 08:17:03','2022-03-29 08:17:03','706',0.00,0.00,'706','2022-03-29 07:32:21','706','2022-03-29 07:34:37',10,0),('1','198',257544,'DAILY SHIFTS','2022-03-29','2022-03-29 07:36:39','2022-03-30 07:36:39','706',0.00,0.00,'706','2022-03-30 07:22:52','706','2022-03-30 07:23:19',10,0),('1','198',257545,'DAILY SHIFTS','2022-03-30','2022-03-30 07:24:11','2022-03-31 07:24:11','706',0.00,0.00,'706','2022-03-31 06:14:16','706','2022-03-31 06:14:54',10,0),('1','198',257546,'DAILY SHIFTS','2022-03-31','2022-03-31 07:40:55','2022-04-01 07:40:55','706',0.00,0.00,'706','2022-04-01 07:26:41','706','2022-04-01 07:27:00',10,0),('1','198',257547,'DAILY SHIFTS','2022-04-01','2022-04-01 07:27:31','2022-04-02 07:27:31','706',0.00,0.00,'706','2022-04-02 06:00:32','706','2022-04-02 06:01:05',10,0),('1','198',257548,'DAILY SHIFTS','2022-04-02','2022-04-02 06:01:44','2022-04-03 06:01:44','706',0.00,0.00,'706','2022-04-03 08:06:52','706','2022-04-03 08:07:22',10,0),('1','198',257549,'DAILY SHIFTS','2022-04-03','2022-04-03 08:08:05','2022-04-04 08:08:05','706',0.00,0.00,'706','2022-04-03 08:16:30','706','2022-04-03 08:17:05',10,0),('1','198',257550,'DAILY SHIFTS','2022-04-03','2022-04-03 08:17:38','2022-04-04 08:17:38','706',0.00,0.00,'706','2022-04-03 11:34:34','706','2022-04-03 11:35:01',10,0),('1','198',257551,'DAILY SHIFT','2022-04-03','2022-04-03 11:35:45','2022-04-04 11:35:45','706',0.00,0.00,'706','2022-04-04 07:25:00','706','2022-04-04 07:25:30',10,0),('1','198',257552,'DAILY SHIFTS','2022-04-04','2022-04-04 08:01:08','2022-04-05 08:01:08','706',0.00,0.00,'706','2022-04-05 07:23:03','706','2022-04-05 07:23:32',10,0),('1','198',257553,'DAILY SHIFTS','2022-04-05','2022-04-05 07:24:10','2022-04-06 07:24:10','706',0.00,0.00,'706','2022-04-06 07:32:21','706','2022-04-06 07:32:44',10,0),('1','198',257554,'DAILY SHIFTS','2022-04-06','2022-04-06 07:34:16','2022-04-07 07:34:16','706',0.00,0.00,'706','2022-04-07 06:58:40','706','2022-04-07 06:59:12',10,0),('1','198',257555,'DAILY SHIFTS','2022-04-07','2022-04-07 06:59:46','2022-04-08 06:59:46','706',0.00,0.00,'706','2022-04-08 07:41:21','706','2022-04-08 07:41:47',10,0),('1','198',257556,'DAILY SHIFTS','2022-04-08','2022-04-08 07:42:13','2022-04-09 07:42:13','706',0.00,0.00,'706','2022-04-09 07:36:35','706','2022-04-09 07:37:04',10,0),('1','198',257557,'DAILY SHIFTS','2022-04-09','2022-04-09 07:37:49','2022-04-10 07:37:49','706',0.00,0.00,'706','2022-04-10 07:21:58','706','2022-04-10 07:22:27',10,0),('1','198',257558,'DAILY SHIFTS','2022-04-10','2022-04-10 07:22:58','2022-04-11 07:22:58','706',0.00,0.00,'706','2022-04-10 15:10:34','706','2022-04-10 15:11:02',10,0),('1','198',257559,'DAILY  SHIFT','2022-04-10','2022-04-10 15:12:31','2022-04-11 15:12:31','706',0.00,0.00,'706','2022-04-11 07:03:07','706','2022-04-11 07:03:36',10,0),('1','198',257560,'DAILY SHIFTS','2022-04-11','2022-04-11 07:04:04','2022-04-12 07:04:04','706',0.00,0.00,'706','2022-04-12 06:59:52','706','2022-04-12 07:00:17',10,0),('1','198',257561,'DAILY SHIFTS','2022-04-12','2022-04-12 07:01:02','2022-04-13 07:01:02','706',0.00,0.00,'706','2022-04-12 20:50:11','706','2022-04-12 20:51:04',10,0),('1','198',257562,'DAILY SHIFTS','2022-04-13','2022-04-13 07:22:49','2022-04-14 07:22:49','706',0.00,0.00,'706','2022-04-14 05:01:22','706','2022-04-14 05:01:50',10,0),('1','198',257563,'DAILY SHIFTS','2022-04-14','2022-04-14 06:48:51','2022-04-15 06:48:51','706',0.00,0.00,'706','2022-04-14 19:57:07','706','2022-04-14 19:57:29',10,0),('1','198',257564,'DAILY SHIFTS','2022-04-15','2022-04-15 06:40:41','2022-04-16 06:40:41','706',0.00,0.00,'706','2022-04-15 19:41:17','706','2022-04-15 19:41:56',10,0),('1','198',257565,'DAILY SHIFTS','2022-04-16','2022-04-16 07:11:12','2022-04-17 07:11:12','706',0.00,0.00,'706','2022-04-17 07:19:31','706','2022-04-17 07:20:01',10,0),('1','198',257566,'DAILY SHIFTS','2022-04-17','2022-04-17 07:20:37','2022-04-18 07:20:37','706',0.00,0.00,'706','2022-04-17 19:28:54','706','2022-04-17 19:29:31',10,0),('1','198',257567,'DAILY SHIFTS','2022-04-18','2022-04-18 06:24:26','2022-04-19 06:24:26','706',0.00,0.00,'706','2022-04-19 05:29:39','706','2022-04-19 05:30:05',10,0),('1','198',257568,'DAILY SHIFTS','2022-04-19','2022-04-19 07:06:16','2022-04-20 07:06:16','706',0.00,0.00,'706','2022-04-19 19:26:35','706','2022-04-19 19:27:06',10,0),('1','198',257569,'DAILY SHIFTS','2022-04-20','2022-04-20 06:52:47','2022-04-21 06:52:47','706',0.00,0.00,'706','2022-04-20 20:28:18','706','2022-04-20 20:28:48',10,0),('1','198',257570,'DAILY SHIFTS','2022-04-21','2022-04-21 07:05:45','2022-04-22 07:05:45','706',0.00,0.00,'706','2022-04-21 20:27:20','706','2022-04-21 20:27:49',10,0),('1','198',257571,'DAILY SHIFTS','2022-04-22','2022-04-22 06:40:59','2022-04-23 06:40:59','706',0.00,0.00,'706','2022-04-23 06:20:20','706','2022-04-23 06:20:57',10,0),('1','198',257572,'DAILY SHIFTS','2022-04-23','2022-04-23 07:13:04','2022-04-24 07:13:04','706',0.00,0.00,'706','2022-04-23 20:03:43','706','2022-04-23 20:04:12',10,0),('1','198',257573,'DAILY SHIFTS','2022-04-24','2022-04-24 07:27:36','2022-04-25 07:27:36','706',0.00,0.00,'706','2022-04-24 13:53:05','706','2022-04-24 13:53:37',10,0),('1','198',257574,'DAILY SHIFT','2022-04-24','2022-04-24 13:55:58','2022-04-25 13:55:58','706',0.00,0.00,'706','2022-04-24 20:35:32','706','2022-04-24 20:36:41',10,0),('1','198',257575,'DAILY SHIFT','2022-04-25','2022-04-25 07:00:20','2022-04-26 07:00:20','706',0.00,0.00,'706','2022-04-25 19:50:19','706','2022-04-25 19:50:45',10,0),('1','198',257576,'DAILY SHIFTS','2022-04-26','2022-04-26 07:05:45','2022-04-27 07:05:45','706',0.00,0.00,'706','2022-04-26 19:46:21','706','2022-04-26 19:49:33',10,0),('1','198',257577,'DAILY SHIFT','2022-04-27','2022-04-27 07:01:16','2022-04-28 07:01:16','706',0.00,0.00,'706','2022-04-28 07:04:10','706','2022-04-28 07:04:48',10,0),('1','198',257578,'DAILY SHIFT','2022-04-28','2022-04-28 07:05:26','2022-04-29 07:05:26','706',0.00,0.00,'706','2022-04-29 00:36:58','706','2022-04-29 00:38:05',10,0),('1','198',257579,'DAILY SHIFT','2022-04-29','2022-04-29 08:18:40','2022-04-30 08:18:40','706',0.00,0.00,'706','2022-04-30 06:40:14','706','2022-04-30 06:41:03',10,0),('1','198',257580,'DAILY SHIFT','2022-04-30','2022-04-30 06:42:42','2022-05-01 06:42:42','706',0.00,0.00,'871','2022-05-01 05:19:30','871','2022-05-01 05:20:01',10,0),('1','198',257581,'DAILY SHIFT','2022-05-01','2022-05-01 06:51:20','2022-05-02 06:51:20','871',0.00,0.00,'871','2022-05-02 05:39:22','871','2022-05-02 05:39:46',10,0),('1','198',257582,'DAILY SHIFT','2022-05-02','2022-05-02 09:37:58','2022-05-03 09:37:58','871',0.00,0.00,'871','2022-05-03 06:32:54','871','2022-05-03 06:33:41',10,0),('1','198',257583,'DAILY SHIFT','2022-05-03','2022-05-03 06:34:18','2022-05-04 06:34:18','871',0.00,0.00,'871','2022-05-04 00:16:53','871','2022-05-04 00:17:23',10,0),('1','198',257584,'DAILY SHIFT','2022-05-04','2022-05-04 06:55:30','2022-05-05 06:55:30','871',0.00,0.00,'871','2022-05-04 20:06:49','871','2022-05-04 20:07:19',10,0),('1','198',257585,'DAILY SHIFT','2022-05-05','2022-05-05 07:20:20','2022-05-06 07:20:20','871',0.00,0.00,'871','2022-05-06 05:47:32','871','2022-05-06 05:48:13',10,0),('1','198',257586,'DAILY SHIFT','2022-05-06','2022-05-06 06:05:17','2022-05-07 06:05:17','871',0.00,0.00,'871','2022-05-06 20:27:38','871','2022-05-06 20:28:38',10,0),('1','198',257587,'DAILY SHIFT','2022-05-07','2022-05-07 06:09:51','2022-05-08 06:09:51','871',0.00,0.00,'871','2022-05-07 18:11:43','871','2022-05-07 18:12:10',10,0),('1','198',257588,'DAILY SHIFT','2022-05-07','2022-05-07 18:13:29','2022-05-08 18:13:29','871',0.00,0.00,'871','2022-05-08 07:16:34','871','2022-05-08 07:17:14',10,0),('1','198',257589,'DAILY SHIFT','2022-05-08','2022-05-08 07:17:57','2022-05-09 07:17:57','871',0.00,0.00,'871','2022-05-09 00:39:29','871','2022-05-09 00:40:30',10,0),('1','198',257590,'DAILY SHIFT','2022-05-09','2022-05-09 06:35:28','2022-05-10 06:35:28','871',0.00,0.00,'871','2022-05-10 06:37:35','871','2022-05-10 06:38:08',10,0),('1','198',257591,'DAILY SHIFT','2022-05-10','2022-05-10 06:39:22','2022-05-11 06:39:22','871',0.00,0.00,'871','2022-05-11 06:25:49','871','2022-05-11 06:28:13',10,0),('1','198',257592,'DAILY SHIFT','2022-05-11','2022-05-11 06:29:18','2022-05-12 06:29:18','871',0.00,0.00,'871','2022-05-12 06:16:02','871','2022-05-12 06:16:36',10,0),('1','198',257593,'DAILY SHIFT','2022-05-12','2022-05-12 06:17:11','2022-05-13 06:17:11','871',0.00,0.00,'871','2022-05-13 00:40:10','871','2022-05-13 00:40:44',10,0),('1','198',257594,'DAILY SHIFT','2022-05-13','2022-05-13 06:50:28','2022-05-14 06:50:28','871',0.00,0.00,'871','2022-05-14 07:07:39','871','2022-05-14 07:08:08',10,0),('1','198',257595,'DAILY SHIFT','2022-05-14','2022-05-14 07:08:58','2022-05-15 07:08:58','871',0.00,0.00,'871','2022-05-14 19:44:27','871','2022-05-14 19:44:57',10,0),('1','198',257596,'DAILY SHIFT','2022-05-15','2022-05-15 05:51:16','2022-05-16 05:51:16','871',0.00,0.00,'871','2022-05-15 19:40:50','871','2022-05-15 19:41:17',10,0),('1','198',257597,'DAILY SHIFT','2022-05-16','2022-05-16 06:55:22','2022-05-17 06:55:22','871',0.00,0.00,'871','2022-05-17 05:49:41','871','2022-05-17 05:50:40',10,0),('1','198',257598,'DAILY SHIFT','2022-05-17','2022-05-17 05:51:41','2022-05-18 05:51:41','871',0.00,0.00,'871','2022-05-18 05:42:29','871','2022-05-18 05:43:05',10,0),('1','198',257599,'DAILY SHIFT','2022-05-18','2022-05-18 05:44:08','2022-05-19 05:44:08','871',0.00,0.00,'871','2022-05-19 06:30:23','871','2022-05-19 06:31:01',10,0),('1','198',257600,'DAILY SHIFT','2022-05-19','2022-05-19 06:31:35','2022-05-20 06:31:35','871',0.00,0.00,'871','2022-05-20 06:01:44','871','2022-05-20 06:02:15',10,0),('1','198',257601,'DAILY SHIFT','2022-05-20','2022-05-20 06:03:15','2022-05-21 06:03:15','871',0.00,0.00,'871','2022-05-21 05:45:07','871','2022-05-21 05:46:07',10,0),('1','198',257602,'DAILY SHIFT','2022-05-21','2022-05-21 06:11:17','2022-05-22 06:11:17','871',0.00,0.00,'871','2022-05-22 06:22:20','871','2022-05-22 06:22:54',10,0),('1','198',257603,'DAILY SHIFT','2022-05-22','2022-05-22 06:23:51','2022-05-23 06:23:51','871',0.00,0.00,'871','2022-05-23 06:28:01','871','2022-05-23 06:28:47',10,0),('1','198',257604,'DAILY SHIFT','2022-05-23','2022-05-23 06:30:20','2022-05-24 06:30:20','871',0.00,0.00,'871','2022-05-23 16:41:17','871','2022-05-23 16:41:39',10,0),('1','198',257605,'DAILY SHIFT','2022-05-23','2022-05-23 16:42:06','2022-05-24 16:42:06','871',0.00,0.00,'871','2022-05-23 19:36:25','871','2022-05-23 19:36:49',10,0),('1','198',257606,'DAILY SHIFT','2022-05-24','2022-05-24 07:00:54','2022-05-25 07:00:54','871',0.00,0.00,'871','2022-05-25 05:58:09','871','2022-05-25 05:59:11',10,0),('1','198',257607,'DAILY SHIFT','2022-05-25','2022-05-25 06:01:24','2022-05-26 06:01:24','871',0.00,0.00,'871','2022-05-25 07:20:33','871','2022-05-25 07:21:01',10,0),('1','198',257608,'DAILY SHIFT','2022-05-25','2022-05-25 07:21:29','2022-05-26 07:21:29','871',0.00,0.00,'871','2022-05-25 08:29:10','871','2022-05-25 08:29:39',10,0),('1','198',257609,'DAILY SHIFT','2022-05-25','2022-05-25 08:30:09','2022-05-26 08:30:09','871',0.00,0.00,'871','2022-05-26 06:33:57','871','2022-05-26 06:34:26',10,0),('1','198',257610,'DAILY SHIFT','2022-05-26','2022-05-26 06:34:54','2022-05-27 06:34:54','871',0.00,0.00,'871','2022-05-27 05:31:23','871','2022-05-27 05:31:48',10,0),('1','198',257611,'DAILY SHIFT','2022-05-27','2022-05-27 05:48:51','2022-05-28 05:48:51','871',0.00,0.00,'871','2022-05-28 06:57:01','871','2022-05-28 06:57:26',10,0),('1','198',257612,'DAILY SHIFT','2022-05-28','2022-05-28 06:58:08','2022-05-29 06:58:08','871',0.00,0.00,'871','2022-05-29 06:51:02','871','2022-05-29 06:52:03',10,0),('1','198',257613,'DAILY SHIFT','2022-05-29','2022-05-29 06:52:38','2022-05-30 06:52:38','871',0.00,0.00,'871','2022-05-30 06:38:23','871','2022-05-30 06:39:43',10,0),('1','198',257614,'DAILY SHIFT','2022-05-30','2022-05-30 06:40:13','2022-05-31 06:40:13','871',0.00,0.00,'871','2022-05-31 06:45:33','871','2022-05-31 06:46:06',10,0),('1','198',257615,'DAILY SHIFT','2022-05-31','2022-05-31 06:47:09','2022-06-01 06:47:09','871',0.00,0.00,'871','2022-06-01 06:46:37','871','2022-06-01 06:47:23',10,0),('1','198',257616,'DAILY SHIFT','2022-06-01','2022-06-01 06:47:50','2022-06-02 06:47:50','871',0.00,0.00,'871','2022-06-02 06:43:52','871','2022-06-02 06:44:38',10,0),('1','198',257617,'DAILY SHIFT','2022-06-02','2022-06-02 06:45:24','2022-06-03 06:45:24','871',0.00,0.00,'871','2022-06-03 06:55:11','871','2022-06-03 06:55:43',10,0),('1','198',257618,'DAILY SHIFT','2022-06-03','2022-06-03 06:56:17','2022-06-04 06:56:17','871',0.00,0.00,'871','2022-06-04 07:06:51','871','2022-06-04 07:07:33',10,0),('1','198',257619,'DAILY SHIFT','2022-06-04','2022-06-04 07:08:24','2022-06-05 07:08:24','871',0.00,0.00,'871','2022-06-05 07:15:48','871','2022-06-05 07:16:21',10,0),('1','198',257620,'DAILY SHIFT','2022-06-05','2022-06-05 07:21:14','2022-06-06 07:21:14','871',0.00,0.00,'871','2022-06-06 06:56:35','871','2022-06-06 06:56:59',10,0),('1','198',257621,'DAILY SHIFT','2022-06-06','2022-06-06 06:57:39','2022-06-07 06:57:39','871',0.00,0.00,'871','2022-06-07 07:52:00','871','2022-06-07 07:52:30',10,0),('1','198',257622,'DAILY SHIFT','2022-06-07','2022-06-07 07:53:09','2022-06-08 07:53:09','871',0.00,0.00,'871','2022-06-07 23:37:10','871','2022-06-07 23:38:33',10,0),('1','198',257623,'DAILY SHIFT','2022-06-08','2022-06-08 06:38:42','2022-06-09 06:38:42','871',0.00,0.00,'871','2022-06-09 06:56:37','871','2022-06-09 06:57:10',10,0),('1','198',257624,'DAILY SHIFT','2022-06-09','2022-06-09 06:57:36','2022-06-10 06:57:36','871',0.00,0.00,'871','2022-06-10 00:09:48','871','2022-06-10 00:10:32',10,0),('1','198',257625,'DAILY SHIFT','2022-06-10','2022-06-10 06:55:07','2022-06-11 06:55:07','871',0.00,0.00,'871','2022-06-11 07:02:27','871','2022-06-11 07:03:11',10,0),('1','198',257626,'DAILY SHIFT','2022-06-11','2022-06-11 07:04:01','2022-06-12 07:04:01','871',0.00,0.00,'871','2022-06-11 14:40:09','871','2022-06-11 14:40:46',10,0),('1','198',257627,'DAILY SHIFT','2022-06-11','2022-06-11 14:42:42','2022-06-12 14:42:42','871',0.00,0.00,'871','2022-06-12 07:19:07','871','2022-06-12 07:19:31',10,0),('1','198',257628,'DAILY SHIFT','2022-06-12','2022-06-12 07:20:56','2022-06-13 07:20:56','871',0.00,0.00,'871','2022-06-13 06:26:32','871','2022-06-13 06:27:35',10,0),('1','198',257629,'DAILY SHIFT','2022-06-13','2022-06-13 06:29:23','2022-06-14 06:29:23','871',0.00,0.00,'871','2022-06-14 06:43:52','871','2022-06-14 06:44:26',10,0),('1','198',257630,'DAILY SHIFT','2022-06-14','2022-06-14 06:55:18','2022-06-15 06:55:18','871',0.00,0.00,'871','2022-06-14 20:08:03','871','2022-06-14 20:08:39',10,0),('1','198',257631,'DAILY SHIFT','2022-06-15','2022-06-15 06:50:01','2022-06-16 06:50:01','871',0.00,0.00,'871','2022-06-15 19:25:41','871','2022-06-15 19:26:09',10,0),('1','198',257632,'DAILY SHIFT','2022-06-16','2022-06-16 07:15:52','2022-06-17 07:15:52','871',0.00,0.00,'871','2022-06-17 07:05:30','871','2022-06-17 07:05:58',10,0),('1','198',257633,'DAILY SHIFT','2022-06-17','2022-06-17 07:06:25','2022-06-18 07:06:25','871',0.00,0.00,'871','2022-06-18 07:16:19','871','2022-06-18 07:18:06',10,0),('1','198',257634,'DAILY SHIFT','2022-06-18','2022-06-18 07:18:38','2022-06-19 07:18:38','871',0.00,0.00,'871','2022-06-19 06:52:06','871','2022-06-19 06:52:58',10,0),('1','198',257635,'DAILY SHIFT','2022-06-19','2022-06-19 06:53:55','2022-06-20 06:53:55','871',0.00,0.00,'871','2022-06-20 05:41:26','871','2022-06-20 05:41:54',10,0),('1','198',257636,'DAILY SHIFT','2022-06-20','2022-06-20 05:42:25','2022-06-21 05:42:25','871',0.00,0.00,'871','2022-06-21 07:21:03','871','2022-06-21 07:21:31',10,0),('1','198',257637,'DAILY SHIFT','2022-06-21','2022-06-21 07:22:38','2022-06-22 07:22:38','871',0.00,0.00,'871','2022-06-22 06:46:11','871','2022-06-22 06:46:43',10,0),('1','198',257638,'DAILY SHIFT','2022-06-22','2022-06-22 06:47:12','2022-06-23 06:47:12','871',0.00,0.00,'871','2022-06-22 20:17:49','871','2022-06-22 20:18:15',10,0),('1','198',257639,'DAILY SHIFT','2022-06-23','2022-06-23 07:13:14','2022-06-24 07:13:14','871',0.00,0.00,'871','2022-06-23 19:39:12','871','2022-06-23 19:39:42',10,0),('1','198',257640,'DAILY SHIFT','2022-06-24','2022-06-24 07:24:15','2022-06-25 07:24:15','871',0.00,0.00,'871','2022-06-24 20:18:30','871','2022-06-24 20:18:54',10,0),('1','198',257641,'DAILY SHIFT','2022-06-25','2022-06-25 07:32:40','2022-06-26 07:32:40','871',0.00,0.00,'871','2022-06-25 20:19:14','871','2022-06-25 20:19:46',10,0),('1','198',257642,'DAILY SHIFT','2022-06-26','2022-06-26 07:46:24','2022-06-27 07:46:24','871',0.00,0.00,'871','2022-06-27 07:15:22','871','2022-06-27 07:15:49',10,0),('1','198',257643,'DAILY SHIFT','2022-06-27','2022-06-27 07:16:24','2022-06-28 07:16:24','871',0.00,0.00,'871','2022-06-28 07:03:20','871','2022-06-28 07:04:46',10,0),('1','198',257644,'DAILY SHIFT','2022-06-28','2022-06-28 07:06:07','2022-06-29 07:06:07','871',0.00,0.00,'871','2022-06-29 07:04:36','871','2022-06-29 07:04:57',10,0),('1','198',257645,'DAILY SHIFT','2022-06-29','2022-06-29 07:05:29','2022-06-30 07:05:29','871',0.00,0.00,'871','2022-06-30 07:03:12','871','2022-06-30 07:03:42',10,0),('1','198',257646,'DAILY SHIFT','2022-06-30','2022-06-30 07:04:14','2022-07-01 07:04:14','871',0.00,0.00,'871','2022-07-01 07:10:08','871','2022-07-01 07:11:04',10,0),('1','198',257647,'DAILY SHIFT','2022-07-01','2022-07-01 07:11:46','2022-07-02 07:11:46','871',0.00,0.00,'871','2022-07-01 14:02:25','871','2022-07-01 14:02:49',10,0),('1','198',257648,'DAILY SHIFT','2022-07-01','2022-07-01 14:03:18','2022-07-02 14:03:18','871',0.00,0.00,'871','2022-07-02 06:57:14','871','2022-07-02 06:57:59',10,0),('1','198',257649,'DAILY SHIFT','2022-07-02','2022-07-02 06:58:37','2022-07-03 06:58:37','871',0.00,0.00,'871','2022-07-03 07:06:16','871','2022-07-03 07:06:52',10,0),('1','198',257650,'DAILY SHIFT','2022-07-03','2022-07-03 07:07:46','2022-07-04 07:07:46','871',0.00,0.00,'871','2022-07-04 07:13:14','871','2022-07-04 07:13:42',10,0),('1','198',257651,'DAILY SHIFT','2022-07-04','2022-07-04 07:16:43','2022-07-05 07:16:43','871',0.00,0.00,'871','2022-07-05 06:57:55','871','2022-07-05 06:58:28',10,0),('1','198',257652,'DAILY SHIFT','2022-07-05','2022-07-05 06:59:13','2022-07-06 06:59:13','871',0.00,0.00,'871','2022-07-06 07:29:51','871','2022-07-06 07:31:00',10,0),('1','198',257653,'DAILY SHIFT','2022-07-06','2022-07-06 07:31:39','2022-07-07 07:31:39','871',0.00,0.00,'871','2022-07-07 07:08:08','871','2022-07-07 07:08:39',10,0),('1','198',257654,'DAILY SHIFT','2022-07-07','2022-07-07 07:09:09','2022-07-08 07:09:09','871',0.00,0.00,'871','2022-07-08 06:22:47','871','2022-07-08 06:24:49',10,0),('1','198',257655,'DAILY SHIFT','2022-07-08','2022-07-08 06:25:47','2022-07-09 06:25:47','871',0.00,0.00,'871','2022-07-09 08:44:21','871','2022-07-09 08:44:51',10,0),('1','198',257656,'DAILY SHIFT','2022-07-09','2022-07-09 09:03:46','2022-07-10 09:03:46','871',0.00,0.00,'871','2022-07-10 07:11:03','871','2022-07-10 07:11:35',10,0),('1','198',257657,'DAILY SHIFT','2022-07-10','2022-07-10 07:12:01','2022-07-11 07:12:01','871',0.00,0.00,'871','2022-07-11 05:43:29','871','2022-07-11 05:43:55',10,0),('1','198',257658,'DAILY SHIFT','2022-07-11','2022-07-11 06:22:51','2022-07-12 06:22:51','871',0.00,0.00,'871','2022-07-11 12:54:04','871','2022-07-11 12:54:33',10,0),('1','198',257659,'DAILY SHIFT','2022-07-11','2022-07-11 12:55:52','2022-07-12 12:55:52','871',0.00,0.00,'871','2022-07-12 06:58:00','871','2022-07-12 06:58:57',10,0),('1','198',257660,'DAILY  SHIFT','2022-07-12','2022-07-12 07:00:46','2022-07-13 07:00:46','871',0.00,0.00,'871','2022-07-13 00:26:29','871','2022-07-13 00:26:58',10,0),('1','198',257661,'DAILY SHIFT','2022-07-13','2022-07-13 06:19:32','2022-07-14 06:19:32','871',0.00,0.00,'871','2022-07-14 08:56:51','871','2022-07-14 08:57:20',10,0),('1','198',257662,'DAILY SHIFT','2022-07-14','2022-07-14 08:57:50','2022-07-15 08:57:50','871',0.00,0.00,'871','2022-07-15 09:08:48','871','2022-07-15 09:09:30',10,0),('1','198',257663,'DAILY SHIFT','2022-07-15','2022-07-15 09:10:43','2022-07-16 09:10:43','871',0.00,0.00,'871','2022-07-16 07:17:17','871','2022-07-16 07:17:49',10,0),('1','198',257664,'DAILY SHIFT','2022-07-16','2022-07-16 07:18:43','2022-07-17 07:18:43','871',0.00,0.00,'871','2022-07-16 21:11:29','871','2022-07-16 21:12:03',10,0),('1','198',257665,'DAILY SHIFT','2022-07-17','2022-07-17 07:03:31','2022-07-18 07:03:31','871',20760.00,21600.00,'871','2022-07-18 05:57:03','871','2022-07-18 05:57:37',10,0),('1','198',257666,'DAILY SHIFT','2022-07-18','2022-07-18 07:20:42','2022-07-19 07:20:42','871',0.00,0.00,'871','2022-07-19 00:20:13','871','2022-07-19 00:20:49',10,0),('1','198',257667,'DAILY SHIFT','2022-07-19','2022-07-19 07:28:46','2022-07-20 07:28:46','871',0.00,0.00,'871','2022-07-20 07:30:54','871','2022-07-20 07:31:32',10,0),('1','198',257668,'DAILY SHIFT','2022-07-20','2022-07-20 07:32:01','2022-07-21 07:32:01','871',0.00,0.00,'871','2022-07-21 00:11:33','871','2022-07-21 00:12:10',10,0),('1','198',257669,'DAILY SHIFT','2022-07-21','2022-07-21 07:27:20','2022-07-22 07:27:20','871',0.00,0.00,'871','2022-07-22 07:14:12','871','2022-07-22 07:14:44',10,0),('1','198',257670,'DAILY SHIFT','2022-07-22','2022-07-22 07:15:26','2022-07-23 07:15:26','871',0.00,0.00,'871','2022-07-23 07:22:35','871','2022-07-23 07:23:08',10,0),('1','198',257671,'DAILY SHIFT','2022-07-23','2022-07-23 07:23:47','2022-07-24 07:23:47','871',0.00,0.00,'871','2022-07-24 07:24:50','871','2022-07-24 07:25:26',10,0),('1','198',257672,'DAILY SHIFT','2022-07-24','2022-07-24 07:26:43','2022-07-25 07:26:43','871',0.00,0.00,'871','2022-07-24 11:58:56','871','2022-07-24 11:59:23',10,0),('1','198',257673,'DAILY SHIFT','2022-07-24','2022-07-24 12:00:11','2022-07-25 12:00:11','871',0.00,0.00,'871','2022-07-25 07:35:31','871','2022-07-25 07:36:15',10,0),('1','198',257674,'DAILY SHIFT','2022-07-25','2022-07-25 07:37:01','2022-07-26 07:37:01','871',0.00,0.00,'871','2022-07-25 18:49:36','871','2022-07-25 18:50:08',10,0),('1','198',257675,'DAILY SHIFT','2022-07-26','2022-07-26 07:42:47','2022-07-27 07:42:47','871',0.00,0.00,'871','2022-07-27 07:26:31','871','2022-07-27 07:26:58',10,0),('1','198',257676,'DAILY SHIFT','2022-07-27','2022-07-27 07:28:23','2022-07-28 07:28:23','871',0.00,0.00,'871','2022-07-28 07:43:58','871','2022-07-28 07:44:21',10,0),('1','198',257677,'DAILY SHIFT','2022-07-28','2022-07-28 07:44:53','2022-07-29 07:44:53','871',0.00,0.00,'871','2022-07-29 07:28:20','871','2022-07-29 07:28:47',10,0),('1','198',257678,'DAILY SHIFT','2022-07-29','2022-07-29 07:29:19','2022-07-30 07:29:19','871',0.00,0.00,'871','2022-07-30 08:18:21','871','2022-07-30 08:18:46',10,0),('1','198',257679,'DAILY SHIFT','2022-07-30','2022-07-30 09:38:31','2022-07-31 09:38:31','871',0.00,0.00,'871','2022-07-31 06:24:37','871','2022-07-31 06:25:38',10,0),('1','198',257680,'DAILY SHIFT','2022-07-31','2022-07-31 06:26:06','2022-08-01 06:26:06','871',0.00,0.00,'871','2022-08-01 07:34:31','871','2022-08-01 07:34:59',10,0),('1','198',257681,'DAILY SHIFT','2022-08-01','2022-08-01 07:35:29','2022-08-02 07:35:29','871',0.00,0.00,'871','2022-08-02 07:12:18','871','2022-08-02 07:13:14',10,0),('1','198',257682,'DAILY SHIFT','2022-08-02','2022-08-02 07:14:03','2022-08-03 07:14:03','871',0.00,0.00,'871','2022-08-03 07:40:28','871','2022-08-03 07:41:01',10,0),('1','198',257683,'DAILY SHIFT','2022-08-03','2022-08-03 07:41:33','2022-08-04 07:41:33','871',0.00,0.00,'871','2022-08-04 06:40:01','871','2022-08-04 06:40:31',10,0),('1','198',257684,'DAILY SHIFT','2022-08-04','2022-08-04 07:21:41','2022-08-05 07:21:41','871',0.00,0.00,'871','2022-08-05 07:23:00','871','2022-08-05 07:23:29',10,0),('1','198',257685,'DAILY SHIFT','2022-08-05','2022-08-05 07:24:03','2022-08-06 07:24:03','871',0.00,0.00,'871','2022-08-05 09:35:10','871','2022-08-05 09:35:38',10,0),('1','198',257686,'DAILY SHIFT','2022-08-05','2022-08-05 09:36:12','2022-08-06 09:36:12','871',0.00,0.00,'871','2022-08-06 08:01:54','871','2022-08-06 08:02:25',10,0),('1','198',257687,'DAILY SHIFT','2022-08-06','2022-08-06 08:02:53','2022-08-07 08:02:53','871',0.00,0.00,'871','2022-08-06 23:33:04','871','2022-08-06 23:43:16',10,0),('1','198',257688,'DAILY SHIFT','2022-08-07','2022-08-07 07:37:31','2022-08-08 07:37:31','871',0.00,0.00,'871','2022-08-07 23:37:17','871','2022-08-07 23:37:54',10,0),('1','198',257689,'DAILY SHIFT','2022-08-08','2022-08-08 07:56:31','2022-08-09 07:56:31','871',0.00,0.00,'871','2022-08-09 07:56:51','871','2022-08-09 07:57:19',10,0),('1','198',257690,'DAILY SHIFT','2022-08-09','2022-08-09 07:57:48','2022-08-10 07:57:48','871',0.00,0.00,'871','2022-08-10 00:12:05','871','2022-08-10 00:14:08',10,0),('1','198',257691,'DAILY SHIFT','2022-08-10','2022-08-10 07:26:30','2022-08-11 07:26:30','871',0.00,0.00,'871','2022-08-11 07:54:31','871','2022-08-11 07:55:09',10,0),('1','198',257692,'DAILY SHIFT','2022-08-11','2022-08-11 07:55:49','2022-08-12 07:55:49','871',0.00,0.00,'871','2022-08-12 07:57:36','871','2022-08-12 07:58:04',10,0),('1','198',257693,'DAILY SHIFT','2022-08-12','2022-08-12 07:59:02','2022-08-13 07:59:02','871',0.00,0.00,'871','2022-08-13 07:45:30','871','2022-08-13 07:46:12',10,0),('1','198',257694,'DAILY SHIFT','2022-08-13','2022-08-13 07:46:50','2022-08-14 07:46:50','871',0.00,0.00,'871','2022-08-13 23:48:27','871','2022-08-13 23:49:05',10,0),('1','198',257695,'DAILY SHIFT','2022-08-14','2022-08-14 06:53:41','2022-08-15 06:53:41','871',0.00,0.00,'871','2022-08-14 10:14:57','871','2022-08-14 10:15:22',10,0),('1','198',257696,'DAILY SHIFT','2022-08-14','2022-08-14 10:15:54','2022-08-15 10:15:54','871',0.00,0.00,'871','2022-08-14 23:30:18','871','2022-08-14 23:30:59',10,0),('1','198',257697,'DAILY SHIFT','2022-08-15','2022-08-15 07:29:57','2022-08-16 07:29:57','871',0.00,0.00,'871','2022-08-16 07:52:34','871','2022-08-16 07:53:00',10,0),('1','198',257698,'DAILY SHIFT','2022-08-16','2022-08-16 07:54:55','2022-08-17 07:54:55','871',0.00,0.00,'871','2022-08-17 07:22:15','871','2022-08-17 07:22:39',10,0),('1','198',257699,'DAILY SHIFT','2022-08-17','2022-08-17 07:25:12','2022-08-18 07:25:12','871',0.00,0.00,'871','2022-08-18 06:06:56','871','2022-08-18 06:07:24',10,0),('1','198',257700,'DAILY SHIFT','2022-08-18','2022-08-18 07:38:28','2022-08-19 07:38:28','871',0.00,0.00,'871','2022-08-18 23:37:10','871','2022-08-18 23:37:42',10,0),('1','198',257701,'DAILY SHIFT','2022-08-19','2022-08-19 07:37:45','2022-08-20 07:37:45','871',0.00,0.00,'871','2022-08-20 07:15:36','871','2022-08-20 07:16:09',10,0),('1','198',257702,'DAILY SHIFT','2022-08-20','2022-08-20 07:16:48','2022-08-21 07:16:48','871',0.00,0.00,'871','2022-08-21 06:08:48','871','2022-08-21 06:09:15',10,0),('1','198',257703,'DAILY SHIFT','2022-08-21','2022-08-21 06:23:13','2022-08-22 06:23:13','871',0.00,0.00,'871','2022-08-21 19:30:54','871','2022-08-21 19:31:41',10,0),('1','198',257704,'DAILY SHIFT','2022-08-22','2022-08-22 06:57:32','2022-08-23 06:57:32','871',0.00,0.00,'871','2022-08-23 07:30:31','871','2022-08-23 07:31:04',10,0),('1','198',257705,'DAILY SHIFT','2022-08-23','2022-08-23 07:31:41','2022-08-24 07:31:41','871',0.00,0.00,'871','2022-08-23 19:33:52','871','2022-08-23 19:34:36',10,0),('1','198',257706,'DAILY SHIFT','2022-08-24','2022-08-24 07:36:04','2022-08-25 07:36:04','871',0.00,0.00,'871','2022-08-24 19:17:18','871','2022-08-24 19:17:44',10,0),('1','198',257707,'daily shift','2022-08-25','2022-08-25 08:18:42','2022-08-26 08:18:42','871',0.00,0.00,'871','2022-08-25 15:11:57','871','2022-08-25 15:12:17',10,0),('1','198',257708,'daily shift','2022-08-25','2022-08-25 15:12:44','2022-08-26 15:12:44','871',0.00,0.00,'871','2022-08-25 22:49:53','871','2022-08-25 22:50:28',10,0),('1','198',257709,'DAILY SHIFT','2022-08-26','2022-08-26 06:41:31','2022-08-27 06:41:31','871',0.00,0.00,'871','2022-08-27 06:52:44','871','2022-08-27 06:53:09',10,0),('1','198',257710,'DAILY SHIFT','2022-08-27','2022-08-27 06:54:21','2022-08-28 06:54:21','871',0.00,0.00,'871','2022-08-27 19:20:54','871','2022-08-27 19:21:44',10,0),('1','198',257711,'DAILY SHIFT','2022-08-28','2022-08-28 07:51:24','2022-08-29 07:51:24','871',0.00,0.00,'871','2022-08-28 18:35:16','871','2022-08-28 18:35:54',10,0),('1','198',257712,'DAILY SHIFT','2022-08-29','2022-08-29 07:56:43','2022-08-30 07:56:43','871',0.00,0.00,'871','2022-08-30 05:59:02','871','2022-08-30 05:59:30',10,0),('1','198',257713,'DAILY  SHIFT','2022-08-30','2022-08-30 07:32:17','2022-08-31 07:32:17','871',0.00,0.00,'871','2022-08-30 19:27:33','871','2022-08-30 19:28:01',10,0),('1','198',257714,'DAILY SHIFT','2022-08-31','2022-08-31 07:14:05','2022-09-01 07:14:05','871',0.00,0.00,'871','2022-09-01 07:12:35','871','2022-09-01 07:13:19',10,0),('1','198',257715,'DAILY SHIFT','2022-09-01','2022-09-01 07:14:51','2022-09-02 07:14:51','871',0.00,0.00,'871','2022-09-01 10:51:17','871','2022-09-01 10:52:00',10,0),('1','198',257716,'DAILY SHIFT','2022-09-01','2022-09-01 11:05:20','2022-09-02 11:05:20','871',0.00,0.00,'871','2022-09-02 07:26:56','871','2022-09-02 07:27:25',10,0),('1','198',257717,'DAILY SHIFT','2022-09-02','2022-09-02 07:28:20','2022-09-03 07:28:20','871',0.00,0.00,'871','2022-09-03 06:58:27','871','2022-09-03 06:59:10',10,0),('1','198',257718,'DAILY SHIFT','2022-09-03','2022-09-03 07:03:46','2022-09-04 07:03:46','871',0.00,0.00,'871','2022-09-04 08:51:51','871','2022-09-04 08:54:28',10,0),('1','198',257719,'DAILY SHIFT','2022-09-04','2022-09-04 09:18:39','2022-09-05 09:18:39','871',0.00,0.00,'871','2022-09-05 07:54:05','871','2022-09-05 07:54:35',10,0),('1','198',257720,'DAILY SHIFT','2022-09-05','2022-09-05 07:55:24','2022-09-06 07:55:24','871',0.00,0.00,'871','2022-09-06 06:47:27','871','2022-09-06 06:48:00',10,0),('1','198',257721,'DAILY SHIFT','2022-09-06','2022-09-06 06:55:19','2022-09-07 06:55:19','871',0.00,0.00,'871','2022-09-06 19:10:16','871','2022-09-06 19:10:40',10,0),('1','198',257722,'DAILY SHIFT','2022-09-07','2022-09-07 07:06:26','2022-09-08 07:06:26','871',0.00,0.00,'953','2022-09-07 21:22:06','953','2022-09-07 21:23:12',10,0),('1','198',257723,'DAILY SHIFT','2022-09-08','2022-09-08 07:00:40','2022-09-09 07:00:40','953',0.00,0.00,'953','2022-09-08 19:05:26','953','2022-09-08 19:06:09',10,0),('1','198',257724,'DAILY SHIFT','2022-09-09','2022-09-09 07:14:05','2022-09-10 07:14:05','953',0.00,0.00,'953','2022-09-09 19:06:12','953','2022-09-09 19:08:09',10,0),('1','198',257725,'DAILY SHIFT','2022-09-10','2022-09-10 07:00:45','2022-09-11 07:00:45','953',0.00,0.00,'953','2022-09-10 19:11:17','953','2022-09-10 19:11:53',10,0),('1','198',257726,'DAILY SHIFT','2022-09-11','2022-09-11 06:56:36','2022-09-12 06:56:36','953',0.00,0.00,'953','2022-09-11 19:22:26','953','2022-09-11 19:22:53',10,0),('1','198',257727,'DAILY SHIFT','2022-09-12','2022-09-12 07:07:36','2022-09-13 07:07:36','953',0.00,0.00,'953','2022-09-12 11:19:47','953','2022-09-12 11:20:19',10,0),('1','198',257728,'DAILY SALES','2022-09-12','2022-09-12 11:20:59','2022-09-13 11:20:59','953',0.00,0.00,'953','2022-09-12 20:49:28','953','2022-09-12 20:50:03',10,0),('1','198',257729,'DAILY SHIFT','2022-09-13','2022-09-13 07:12:12','2022-09-14 07:12:12','953',0.00,0.00,'953','2022-09-13 20:03:40','953','2022-09-13 20:04:11',10,0),('1','198',257730,'DAILY SHIFT','2022-09-14','2022-09-14 07:02:24','2022-09-15 07:02:24','953',0.00,0.00,'953','2022-09-14 13:44:31','953','2022-09-14 13:45:03',10,0),('1','198',257731,'DAILY SALES','2022-09-14','2022-09-14 15:21:25','2022-09-15 15:21:25','953',0.00,0.00,'953','2022-09-14 20:25:08','953','2022-09-14 20:25:45',10,0),('1','198',257732,'DAILY SHIFT','2022-09-15','2022-09-15 07:01:53','2022-09-16 07:01:53','953',0.00,0.00,'953','2022-09-15 20:11:31','953','2022-09-15 20:12:09',10,0),('1','198',257733,'DAILY SHIFT','2022-09-16','2022-09-16 07:08:36','2022-09-17 07:08:36','953',0.00,0.00,'953','2022-09-16 19:00:15','953','2022-09-16 19:00:49',10,0),('1','198',257734,'DAILY SHIFT','2022-09-17','2022-09-17 07:05:27','2022-09-18 07:05:27','953',0.00,0.00,'953','2022-09-17 13:37:30','953','2022-09-17 13:37:53',10,0),('1','198',257735,'DAILY SHIFT','2022-09-17','2022-09-17 13:38:32','2022-09-18 13:38:32','953',0.00,0.00,'953','2022-09-17 13:45:05','953','2022-09-17 13:45:30',10,0),('1','198',257736,'DAILY SHIFT','2022-09-17','2022-09-17 13:46:34','2022-09-18 13:46:34','953',0.00,0.00,'953','2022-09-17 18:34:20','953','2022-09-17 18:34:46',10,0),('1','198',257737,'DAILY SHIFT','2022-09-18','2022-09-18 06:52:12','2022-09-19 06:52:12','953',0.00,0.00,'953','2022-09-18 23:01:38','953','2022-09-18 23:02:11',10,0),('1','198',257738,'DAILY SHIFT','2022-09-19','2022-09-19 07:03:12','2022-09-20 07:03:12','953',0.00,0.00,'953','2022-09-19 18:30:37','953','2022-09-19 18:31:04',10,0),('1','198',257739,'DAILY SHIFT','2022-09-20','2022-09-20 07:01:49','2022-09-21 07:01:49','953',0.00,0.00,'953','2022-09-20 18:51:50','953','2022-09-20 18:52:30',10,0),('1','198',257740,'DAILY SHIFT','2022-09-21','2022-09-21 07:33:37','2022-09-22 07:33:37','953',0.00,0.00,'953','2022-09-21 18:21:30','953','2022-09-21 18:22:02',10,0),('1','198',257741,'DAILY SHIFT','2022-09-22','2022-09-22 07:02:55','2022-09-23 07:02:55','953',0.00,0.00,'953','2022-09-22 12:50:19','953','2022-09-22 12:50:43',10,0),('1','198',257742,'DAILY SHIFT','2022-09-22','2022-09-22 13:07:40','2022-09-23 13:07:40','953',0.00,0.00,'953','2022-09-22 13:48:19','953','2022-09-22 13:48:35',10,0),('1','198',257743,'DAILY SHIFT','2022-09-22','2022-09-22 13:49:00','2022-09-23 13:49:00','953',0.00,0.00,'953','2022-09-22 18:43:13','953','2022-09-22 18:43:56',10,0),('1','198',257744,'DAILY SHIFT','2022-09-23','2022-09-23 07:14:11','2022-09-24 07:14:11','953',0.00,0.00,'953','2022-09-23 18:31:41','953','2022-09-23 18:32:14',10,0),('1','198',257745,'DAILY SHIFT','2022-09-24','2022-09-24 07:06:39','2022-09-25 07:06:39','953',0.00,0.00,'953','2022-09-24 18:47:11','953','2022-09-24 18:47:40',10,0),('1','198',257746,'DAILY SHIFT','2022-09-25','2022-09-25 07:15:07','2022-09-26 07:15:07','953',0.00,0.00,'953','2022-09-25 18:19:02','953','2022-09-25 18:19:28',10,0),('1','198',257747,'DAILY SHIFT','2022-09-26','2022-09-26 06:58:51','2022-09-27 06:58:51','953',0.00,0.00,'953','2022-09-26 11:01:59','953','2022-09-26 11:02:40',10,0),('1','198',257748,'DAILY SHIFT','2022-09-26','2022-09-26 11:16:23','2022-09-27 11:16:23','953',0.00,0.00,'953','2022-09-26 18:32:39','953','2022-09-26 18:33:08',10,0),('1','198',257749,'DAILY SHIFT','2022-09-27','2022-09-27 07:20:26','2022-09-28 07:20:26','953',0.00,0.00,'953','2022-09-27 21:23:30','953','2022-09-27 21:24:00',10,0),('1','198',257750,'DAILY SHIFT','2022-09-28','2022-09-28 07:04:25','2022-09-29 07:04:25','953',0.00,0.00,'953','2022-09-28 18:37:39','953','2022-09-28 18:38:13',10,0),('1','198',257751,'DAILY SHIFT','2022-09-29','2022-09-29 07:05:09','2022-09-30 07:05:09','953',0.00,0.00,'953','2022-09-29 18:27:58','953','2022-09-29 18:28:50',10,0),('1','198',257752,'DAILY SHIFT','2022-09-30','2022-09-30 07:05:36','2022-10-01 07:05:36','953',0.00,0.00,'953','2022-09-30 19:04:02','953','2022-09-30 19:04:32',10,0),('1','198',257753,'DAILY SHIFT','2022-10-01','2022-10-01 06:41:54','2022-10-02 06:41:54','953',0.00,0.00,'953','2022-10-01 18:30:52','953','2022-10-01 18:31:26',10,0),('1','198',257754,'DAILY SHIFT','2022-10-02','2022-10-02 06:45:35','2022-10-03 06:45:35','953',0.00,0.00,'953','2022-10-02 18:44:50','953','2022-10-02 18:45:16',10,0),('1','198',257755,'DAILY SHIFT','2022-10-03','2022-10-03 06:50:01','2022-10-04 06:50:01','953',0.00,0.00,'953','2022-10-03 17:39:34','953','2022-10-03 17:40:02',10,0),('1','198',257756,'DAILY SHIFT','2022-10-03','2022-10-03 17:40:30','2022-10-04 17:40:30','953',0.00,0.00,'953','2022-10-03 17:45:18','953','2022-10-03 17:45:43',10,0),('1','198',257757,'DAILY SHIFT','2022-10-03','2022-10-03 17:50:17','2022-10-04 17:50:17','953',0.00,0.00,'953','2022-10-03 18:35:15','953','2022-10-03 18:35:40',10,0),('1','198',257758,'DAILY SHIFT','2022-10-04','2022-10-04 07:02:42','2022-10-05 07:02:42','953',0.00,0.00,'953','2022-10-04 18:33:12','953','2022-10-04 18:33:36',10,0),('1','198',257759,'DAILY SHIFT','2022-10-05','2022-10-05 06:58:27','2022-10-06 06:58:27','953',0.00,0.00,'953','2022-10-05 18:56:16','953','2022-10-05 18:56:50',10,0),('1','198',257760,'DAILY SHIFT','2022-10-06','2022-10-06 06:56:42','2022-10-07 06:56:42','953',0.00,0.00,'953','2022-10-06 18:31:26','953','2022-10-06 18:31:53',10,0),('1','198',257761,'DAILY SHIFT','2022-10-07','2022-10-07 07:01:27','2022-10-08 07:01:27','953',0.00,0.00,'953','2022-10-07 18:35:46','953','2022-10-07 18:36:13',10,0),('1','198',257762,'DAILY SHIFT','2022-10-08','2022-10-08 07:03:57','2022-10-09 07:03:57','953',0.00,0.00,'953','2022-10-08 18:39:31','953','2022-10-08 18:41:20',10,0),('1','198',257763,'DAILY SHIFT','2022-10-09','2022-10-09 07:17:18','2022-10-10 07:17:18','953',0.00,0.00,'953','2022-10-09 20:23:02','953','2022-10-09 20:23:36',10,0),('1','198',257764,'DAILY SHIFT','2022-10-10','2022-10-10 06:58:16','2022-10-11 06:58:16','953',0.00,0.00,'953','2022-10-10 18:31:40','953','2022-10-10 18:32:00',10,0),('1','198',257765,'DAILY SHIFT','2022-10-11','2022-10-11 06:55:32','2022-10-12 06:55:32','953',0.00,0.00,'953','2022-10-11 17:35:58','953','2022-10-11 17:36:25',10,0),('1','198',257766,'DAILY SHIFT','2022-10-12','2022-10-12 06:59:35','2022-10-13 06:59:35','953',0.00,0.00,'953','2022-10-12 18:27:01','953','2022-10-12 18:27:32',10,0),('1','198',257767,'DAILY SHIFT','2022-10-13','2022-10-13 07:01:45','2022-10-14 07:01:45','953',0.00,0.00,'953','2022-10-13 08:41:04','953','2022-10-13 08:41:42',10,0),('1','198',257768,'DAILY SHIFT','2022-10-13','2022-10-13 08:42:53','2022-10-14 08:42:53','953',0.00,0.00,'953','2022-10-13 08:59:20','953','2022-10-13 08:59:45',10,0),('1','198',257769,'DAILY SHIFT','2022-10-13','2022-10-13 09:00:11','2022-10-14 09:00:11','953',0.00,0.00,'953','2022-10-13 18:32:53','953','2022-10-13 18:33:29',10,0),('1','198',257770,'DAILY SHIFT','2022-10-14','2022-10-14 06:57:48','2022-10-15 06:57:48','953',0.00,0.00,'953','2022-10-14 20:59:11','953','2022-10-14 21:00:40',10,0),('1','198',257771,'DAILY SHIFT','2022-10-15','2022-10-15 06:42:19','2022-10-16 06:42:19','953',0.00,0.00,'953','2022-10-16 06:36:30','953','2022-10-16 06:36:55',10,0),('1','198',257772,'DAILY SHIFT','2022-10-16','2022-10-16 06:59:27','2022-10-17 06:59:27','953',0.00,0.00,'953','2022-10-16 19:14:00','953','2022-10-16 19:14:33',10,0),('1','198',257773,'DAILY SHIFT','2022-10-17','2022-10-17 07:20:08','2022-10-18 07:20:08','953',0.00,0.00,'953','2022-10-17 15:03:10','953','2022-10-17 15:05:43',10,0),('1','198',257774,'DAILY SHIFT','2022-10-17','2022-10-17 15:38:20','2022-10-18 15:38:20','953',0.00,0.00,'953','2022-10-17 17:25:55','953','2022-10-17 17:26:23',10,0),('1','198',257775,'DAILY SHIFT','2022-10-18','2022-10-18 07:12:26','2022-10-19 07:12:26','953',0.00,0.00,'953','2022-10-18 18:35:42','953','2022-10-18 18:36:16',10,0),('1','198',257776,'DAILY SHIFT','2022-10-19','2022-10-19 06:46:48','2022-10-20 06:46:48','953',0.00,0.00,'953','2022-10-19 11:14:10','953','2022-10-19 11:14:44',10,0),('1','198',257777,'DAILY SHIFT','2022-10-19','2022-10-19 11:16:43','2022-10-20 11:16:43','953',0.00,0.00,'953','2022-10-19 17:20:23','953','2022-10-19 17:20:48',10,0),('1','198',257778,'DAILY SHIFT','2022-10-19','2022-10-19 17:21:30','2022-10-20 17:21:30','953',0.00,0.00,'953','2022-10-19 20:02:46','953','2022-10-19 20:03:26',10,0),('1','198',257779,'DAILY SHIFT','2022-10-20','2022-10-20 06:41:00','2022-10-21 06:41:00','953',0.00,0.00,'953','2022-10-20 20:36:53','953','2022-10-20 20:37:20',10,0),('1','198',257780,'DAILY SHIFT','2022-10-21','2022-10-21 06:45:48','2022-10-22 06:45:48','953',0.00,0.00,'953','2022-10-21 19:25:25','953','2022-10-21 19:25:54',10,0),('1','198',257781,'DAILY SHIFT','2022-10-22','2022-10-22 06:53:53','2022-10-23 06:53:53','953',0.00,0.00,'953','2022-10-22 23:06:09','953','2022-10-22 23:06:36',10,0),('1','198',257782,'DAILY SHIFT','2022-10-23','2022-10-23 07:02:49','2022-10-24 07:02:49','953',0.00,0.00,'953','2022-10-23 18:18:11','953','2022-10-23 18:18:34',10,0),('1','198',257783,'DAILY SHIFT','2022-10-24','2022-10-24 07:13:04','2022-10-25 07:13:04','953',0.00,0.00,'953','2022-10-24 18:34:21','953','2022-10-24 18:34:44',10,0),('1','198',257784,'DAILY SHIFT','2022-10-25','2022-10-25 07:05:32','2022-10-26 07:05:32','953',0.00,0.00,'953','2022-10-25 14:13:04','953','2022-10-25 14:13:47',10,0),('1','198',257785,'DAILY SHIFT','2022-10-25','2022-10-25 14:15:12','2022-10-26 14:15:12','953',0.00,0.00,'953','2022-10-25 14:53:13','953','2022-10-25 14:53:51',10,0),('1','198',257786,'DAILY SHIFT','2022-10-25','2022-10-25 17:46:16','2022-10-26 17:46:16','953',0.00,0.00,'953','2022-10-25 18:55:21','953','2022-10-25 18:56:00',10,0),('1','198',257787,'DAILY SHIFT','2022-10-26','2022-10-26 07:20:56','2022-10-27 07:20:56','953',0.00,0.00,'953','2022-10-26 18:32:02','953','2022-10-26 18:32:27',10,0),('1','198',257788,'DAILY SHIFT','2022-10-27','2022-10-27 07:10:56','2022-10-28 07:10:56','953',0.00,0.00,'953','2022-10-27 19:56:42','953','2022-10-27 19:57:10',10,0),('1','198',257789,'DAILY SHIFT','2022-10-28','2022-10-28 07:02:02','2022-10-29 07:02:02','953',0.00,0.00,'953','2022-10-29 10:12:59','953','2022-10-29 10:13:28',10,0),('1','198',257790,'DAILY SHIFT','2022-10-29','2022-10-29 10:13:58','2022-10-30 10:13:58','953',0.00,0.00,'953','2022-10-29 18:53:54','953','2022-10-29 18:54:20',10,0),('1','198',257791,'DAILY SHIFT','2022-10-30','2022-10-30 07:24:05','2022-10-31 07:24:05','953',0.00,0.00,'953','2022-10-30 16:32:13','953','2022-10-30 16:32:34',10,0),('1','198',257792,'DAILY SHIFT','2022-10-30','2022-10-30 16:33:24','2022-10-31 16:33:24','953',0.00,0.00,'953','2022-10-30 16:38:00','953','2022-10-30 16:38:19',10,0),('1','198',257793,'DAILY SHIFT','2022-11-01','2022-11-01 07:07:09','2022-11-02 07:07:09','953',0.00,0.00,'953','2022-11-01 07:08:05','953','2022-11-01 07:08:28',10,0),('1','198',257794,'DAILY SHIFT','2022-11-01','2022-11-01 07:08:50','2022-11-02 07:08:50','953',0.00,0.00,'953','2022-11-01 18:24:27','953','2022-11-01 18:24:55',10,0),('1','198',257795,'DAILY SHIFT','2022-11-02','2022-11-02 07:16:41','2022-11-03 07:16:41','953',0.00,0.00,'953','2022-11-02 17:29:18','953','2022-11-02 17:29:46',10,0),('1','198',257796,'OPERATIONAL LOSS','2022-11-02','2022-11-02 17:31:06','2022-11-03 17:31:06','953',0.00,0.00,'953','2022-11-02 17:37:17','953','2022-11-02 17:37:46',10,0),('1','198',257797,'DAILY SHIFT','2022-11-06','2022-11-06 08:25:45','2022-11-07 08:25:45','953',0.00,0.00,'953','2022-11-06 18:43:35','953','2022-11-06 18:44:04',10,0),('1','198',257798,'DAILY SHIFT','2022-11-07','2022-11-07 07:13:34','2022-11-08 07:13:34','953',0.00,0.00,'953','2022-11-07 18:41:04','953','2022-11-07 18:41:26',10,0),('1','198',257799,'DAILY SHIFT','2022-11-08','2022-11-08 07:16:46','2022-11-09 07:16:46','953',0.00,0.00,'953','2022-11-08 18:25:46','953','2022-11-08 18:26:05',10,0),('1','198',257800,'DAILY SHIFT','2022-11-09','2022-11-09 07:12:40','2022-11-10 07:12:40','953',0.00,0.00,'953','2022-11-09 18:47:39','953','2022-11-09 18:48:28',10,0),('1','198',257801,'DAILY SHIFT','2022-11-10','2022-11-10 07:20:54','2022-11-11 07:20:54','953',0.00,0.00,'953','2022-11-10 14:07:15','953','2022-11-10 14:07:43',10,0),('1','198',257802,'OPERATIONAL LOSS','2022-11-10','2022-11-10 14:09:29','2022-11-11 14:09:29','953',0.00,0.00,'953','2022-11-10 14:16:25','953','2022-11-10 14:16:55',10,0),('1','198',257803,'DAILY SHIFT','2022-11-10','2022-11-10 14:28:23','2022-11-11 14:28:23','953',0.00,0.00,'953','2022-11-10 18:30:44','953','2022-11-10 18:33:40',10,0),('1','198',257804,'DAILY SHIFT','2022-11-11','2022-11-11 07:32:27','2022-11-12 07:32:27','953',0.00,0.00,'953','2022-11-11 18:36:10','953','2022-11-11 18:36:36',10,0),('1','198',257805,'DAILY SHIFT','2022-11-12','2022-11-12 07:25:00','2022-11-13 07:25:00','953',0.00,0.00,'953','2022-11-12 18:56:50','953','2022-11-12 18:57:19',10,0),('1','198',257806,'DAILY SHIFT','2022-11-13','2022-11-13 07:21:46','2022-11-14 07:21:46','953',0.00,0.00,'953','2022-11-13 18:34:51','953','2022-11-13 18:35:23',10,0),('1','198',257807,'DAILY SHIFT','2022-11-14','2022-11-14 07:01:12','2022-11-15 07:01:12','953',0.00,0.00,'953','2022-11-14 18:31:23','953','2022-11-14 18:31:47',10,0),('1','198',257808,'DAILY SHIFT','2022-11-15','2022-11-15 07:19:59','2022-11-16 07:19:59','953',0.00,0.00,'953','2022-11-15 18:28:29','953','2022-11-15 18:28:57',10,0),('1','198',257809,'DAILY SHIFT','2022-11-16','2022-11-16 07:08:19','2022-11-17 07:08:19','953',0.00,0.00,'953','2022-11-16 18:30:00','953','2022-11-16 18:30:28',10,0),('1','198',257810,'DAILY SHIFT','2022-11-17','2022-11-17 06:56:49','2022-11-18 06:56:49','953',0.00,0.00,'953','2022-11-17 14:30:47','953','2022-11-17 14:31:16',10,0),('1','198',257811,'OPERATIONAL LOSS','2022-11-17','2022-11-17 14:32:23','2022-11-18 14:32:23','953',0.00,0.00,'953','2022-11-17 14:43:54','953','2022-11-17 14:44:16',10,0),('1','198',257812,'DAILY SHIFT','2022-11-17','2022-11-17 14:44:48','2022-11-18 14:44:48','953',0.00,0.00,'953','2022-11-17 18:36:57','953','2022-11-17 18:37:22',10,0),('1','198',257813,'DAILY SHIFT','2022-11-18','2022-11-18 07:22:59','2022-11-19 07:22:59','953',0.00,0.00,'953','2022-11-18 18:35:31','953','2022-11-18 18:35:55',10,0),('1','198',257814,'DAILY SHIFT','2022-11-19','2022-11-19 07:24:00','2022-11-20 07:24:00','953',0.00,0.00,'953','2022-11-19 18:35:51','953','2022-11-19 18:36:25',10,0),('1','198',257815,'DAILY SHIFT','2022-11-20','2022-11-20 07:08:38','2022-11-21 07:08:38','953',0.00,0.00,'953','2022-11-20 18:39:26','953','2022-11-20 18:40:01',10,0),('1','198',257816,'DAILY SHIFT','2022-11-21','2022-11-21 07:14:09','2022-11-22 07:14:09','953',0.00,0.00,'953','2022-11-21 18:26:08','953','2022-11-21 18:26:55',10,0),('1','198',257817,'DAILY SHIFT','2022-11-22','2022-11-22 07:00:01','2022-11-23 07:00:01','953',0.00,0.00,'953','2022-11-22 18:51:13','953','2022-11-22 18:51:38',10,0),('1','198',257818,'DAILY SHIFT','2022-11-23','2022-11-23 07:08:55','2022-11-24 07:08:55','953',0.00,0.00,'953','2022-11-23 18:20:46','953','2022-11-23 18:21:15',10,0),('1','198',257819,'DAILY SHIFT','2022-11-24','2022-11-24 06:53:41','2022-11-25 06:53:41','953',0.00,0.00,'953','2022-11-24 11:19:58','953','2022-11-24 11:20:25',10,0),('1','198',257820,'OPERATIONAL LOSS','2022-11-24','2022-11-24 11:21:07','2022-11-25 11:21:07','953',0.00,0.00,'953','2022-11-24 11:22:38','953','2022-11-24 11:23:06',10,0),('1','198',257821,'DAILY SHIFT','2022-11-24','2022-11-24 11:36:43','2022-11-25 11:36:43','953',0.00,0.00,'953','2022-11-24 18:37:12','953','2022-11-24 18:37:35',10,0),('1','198',257822,'DAILY SHIFT','2022-11-25','2022-11-25 07:22:37','2022-11-26 07:22:37','953',0.00,0.00,'953','2022-11-25 18:38:17','953','2022-11-25 18:40:09',10,0),('1','198',257823,'DAILY SHIFT','2022-11-26','2022-11-26 10:02:00','2022-11-27 10:02:00','953',0.00,0.00,'953','2022-11-26 18:40:54','953','2022-11-26 18:41:25',10,0),('1','198',257824,'DAILY SHIFT','2022-11-27','2022-11-27 07:10:42','2022-11-28 07:10:42','953',0.00,0.00,'953','2022-11-27 19:34:31','953','2022-11-27 19:35:17',10,0),('1','198',257825,'DAILY SHIFT','2022-11-28','2022-11-28 07:19:01','2022-11-29 07:19:01','953',0.00,0.00,'953','2022-11-28 09:49:24','953','2022-11-28 09:49:43',10,0),('1','198',257826,'DAILY SHIFT','2022-11-28','2022-11-28 09:50:51','2022-11-29 09:50:51','953',0.00,0.00,'953','2022-11-28 18:32:27','953','2022-11-28 18:32:56',10,0),('1','198',257827,'DAILY SHIFT','2022-11-29','2022-11-29 07:15:05','2022-11-30 07:15:05','953',0.00,0.00,'953','2022-11-29 18:35:14','953','2022-11-29 18:35:46',10,0),('1','198',257828,'DAILY SHIFT','2022-11-30','2022-11-30 07:14:11','2022-12-01 07:14:11','953',0.00,0.00,'953','2022-11-30 18:56:46','953','2022-11-30 18:57:33',10,0),('1','198',257829,'DAILY SHIFT','2022-12-01','2022-12-01 07:07:47','2022-12-02 07:07:47','953',0.00,0.00,'953','2022-12-01 19:42:32','953','2022-12-01 19:43:09',10,0),('1','198',257830,'DAILY SHIFT','2022-12-02','2022-12-02 07:34:17','2022-12-03 07:34:17','953',0.00,0.00,'953','2022-12-02 18:28:02','953','2022-12-02 18:29:27',10,0),('1','198',257831,'DAILY SHIFT','2022-12-03','2022-12-03 07:13:59','2022-12-04 07:13:59','953',0.00,0.00,'953','2022-12-03 18:36:25','953','2022-12-03 18:37:31',10,0),('1','198',257832,'DAILY SHIFT','2022-12-04','2022-12-04 07:06:28','2022-12-05 07:06:28','953',0.00,0.00,'953','2022-12-04 19:23:35','953','2022-12-04 19:24:09',10,0),('1','198',257833,'DAILY SHIFT','2022-12-05','2022-12-05 07:26:50','2022-12-06 07:26:50','953',0.00,0.00,'953','2022-12-05 11:28:54','953','2022-12-05 11:29:27',10,0),('1','198',257834,'OPERATIONAL LOSS','2022-12-05','2022-12-05 11:31:37','2022-12-06 11:31:37','953',0.00,0.00,'953','2022-12-05 11:38:45','953','2022-12-05 11:39:17',10,0),('1','198',257835,'DAILY SHIFT','2022-12-05','2022-12-05 11:54:05','2022-12-06 11:54:05','953',0.00,0.00,'953','2022-12-05 18:28:11','953','2022-12-05 18:28:46',10,0),('1','198',257836,'DAILY SHIFT','2022-12-06','2022-12-06 07:35:53','2022-12-07 07:35:53','953',0.00,0.00,'953','2022-12-06 18:20:46','953','2022-12-06 18:21:13',10,0),('1','198',257837,'DAILY SHIFT','2022-12-07','2022-12-07 07:31:17','2022-12-08 07:31:17','953',0.00,0.00,'953','2022-12-07 18:23:53','953','2022-12-07 18:24:26',10,0),('1','198',257838,'DAILY SHIFT','2022-12-08','2022-12-08 07:05:33','2022-12-09 07:05:33','953',0.00,0.00,'953','2022-12-08 18:36:24','953','2022-12-08 18:37:06',10,0),('1','198',257839,'DAILY SHIFT','2022-12-09','2022-12-09 07:15:05','2022-12-10 07:15:05','953',0.00,0.00,'953','2022-12-09 18:14:25','953','2022-12-09 18:15:16',10,0),('1','198',257840,'DAILY SHIFT','2022-12-10','2022-12-10 07:19:41','2022-12-11 07:19:41','953',0.00,0.00,'953','2022-12-10 18:26:30','953','2022-12-10 18:27:08',10,0),('1','198',257841,'DAILY SHIFT','2022-12-11','2022-12-11 07:24:46','2022-12-12 07:24:46','953',0.00,0.00,'953','2022-12-11 09:31:08','953','2022-12-11 09:31:33',10,0),('1','198',257842,'OPERATIONAL LOSS','2022-12-11','2022-12-11 09:36:15','2022-12-12 09:36:15','953',0.00,0.00,'953','2022-12-11 09:39:25','953','2022-12-11 09:39:48',10,0),('1','198',257843,'DAILY SHIFT','2022-12-11','2022-12-11 09:43:07','2022-12-12 09:43:07','953',0.00,0.00,'953','2022-12-11 18:53:27','953','2022-12-11 18:53:56',10,0),('1','198',257844,'DAILY SHIFT','2022-12-12','2022-12-12 07:37:00','2022-12-13 07:37:00','953',0.00,0.00,'953','2022-12-12 18:12:59','953','2022-12-12 18:13:28',10,0),('1','198',257845,'DAILY SHIFT','2022-12-13','2022-12-13 07:22:46','2022-12-14 07:22:46','953',0.00,0.00,'953','2022-12-13 18:10:23','953','2022-12-13 18:10:55',10,0),('1','198',257846,'DAILY SHIFT','2022-12-14','2022-12-14 07:06:44','2022-12-15 07:06:44','953',0.00,0.00,'953','2022-12-14 18:06:34','953','2022-12-14 18:07:02',10,0),('1','198',257847,'DAILY SHIFT','2022-12-15','2022-12-15 07:26:16','2022-12-16 07:26:16','953',0.00,0.00,'953','2022-12-15 11:14:31','953','2022-12-15 11:14:51',10,0),('1','198',257848,'DAILY SHIFT','2022-12-15','2022-12-15 11:15:24','2022-12-16 11:15:24','953',0.00,0.00,'953','2022-12-15 11:17:42','953','2022-12-15 11:18:03',10,0),('1','198',257849,'DAILY SHIFT','2022-12-15','2022-12-15 11:21:58','2022-12-16 11:21:58','953',0.00,0.00,'953','2022-12-15 18:12:01','953','2022-12-15 18:12:37',10,0),('1','198',257850,'DAILY SHIFT','2022-12-16','2022-12-16 07:22:19','2022-12-17 07:22:19','953',0.00,0.00,'953','2022-12-16 18:16:43','953','2022-12-16 18:17:38',10,0),('1','198',257851,'DAILY SHIFT','2022-12-17','2022-12-17 07:19:29','2022-12-18 07:19:29','953',0.00,0.00,'953','2022-12-17 18:16:26','953','2022-12-17 18:16:44',10,0),('1','198',257852,'DAILY SHIFT','2022-12-18','2022-12-18 07:38:58','2022-12-19 07:38:58','953',0.00,0.00,'953','2022-12-18 18:16:54','953','2022-12-18 18:17:23',10,0),('1','198',257853,'DAILY SHIFT','2022-12-19','2022-12-19 07:36:43','2022-12-20 07:36:43','953',0.00,0.00,'953','2022-12-19 18:28:46','953','2022-12-19 18:29:15',10,0),('1','198',257854,'DAILY SHIFT','2022-12-20','2022-12-20 07:29:28','2022-12-21 07:29:28','953',0.00,0.00,'953','2022-12-20 18:14:07','953','2022-12-20 18:14:43',10,0),('1','198',257855,'DAILY SHIFT','2022-12-21','2022-12-21 07:31:03','2022-12-22 07:31:03','953',0.00,0.00,'953','2022-12-21 12:58:14','953','2022-12-21 12:58:45',10,0),('1','198',257856,'DAILY SHIFT','2022-12-21','2022-12-21 13:08:25','2022-12-22 13:08:25','953',0.00,0.00,'953','2022-12-21 18:22:17','953','2022-12-21 18:22:59',10,0),('1','198',257857,'DAILY SHIFT','2022-12-22','2022-12-22 07:31:20','2022-12-23 07:31:20','953',0.00,0.00,'953','2022-12-22 18:29:02','953','2022-12-22 18:29:49',10,0),('1','198',257858,'DAILY SHIFT','2022-12-23','2022-12-23 06:57:36','2022-12-24 06:57:36','953',0.00,0.00,'953','2022-12-23 18:24:08','953','2022-12-23 18:24:50',10,0),('1','198',257859,'DAILY SHIFT','2022-12-24','2022-12-24 07:52:16','2022-12-25 07:52:16','953',0.00,0.00,'953','2022-12-24 18:21:11','953','2022-12-24 18:22:09',10,0),('1','198',257860,'DAILY SHIFT','2022-12-25','2022-12-25 07:30:48','2022-12-26 07:30:48','953',0.00,0.00,'953','2022-12-25 18:42:16','953','2022-12-25 18:42:54',10,0),('1','198',257861,'DAILY SHIFT','2022-12-26','2022-12-26 07:29:08','2022-12-27 07:29:08','953',0.00,0.00,'953','2022-12-26 13:24:44','953','2022-12-26 13:25:01',10,0),('1','198',257862,'OPERATIONAL LOSS','2022-12-26','2022-12-26 13:28:08','2022-12-27 13:28:08','953',0.00,0.00,'953','2022-12-26 13:31:25','953','2022-12-26 13:31:51',10,0),('1','198',257863,'DAILY SHIFT','2022-12-26','2022-12-26 13:38:01','2022-12-27 13:38:01','953',0.00,0.00,'953','2022-12-26 18:44:21','953','2022-12-26 18:45:17',10,0),('1','198',257864,'DAILY SHIFT','2022-12-27','2022-12-27 07:32:54','2022-12-28 07:32:54','953',0.00,0.00,'953','2022-12-27 18:10:57','953','2022-12-27 18:11:26',10,0),('1','198',257865,'DAILY SHIFT','2022-12-28','2022-12-28 07:23:44','2022-12-29 07:23:44','953',0.00,0.00,'953','2022-12-28 18:22:25','953','2022-12-28 18:22:56',10,0),('1','198',257866,'DAILY SHIFT','2022-12-29','2022-12-29 07:29:46','2022-12-30 07:29:46','953',0.00,0.00,'953','2022-12-29 18:15:38','953','2022-12-29 18:16:09',10,0),('1','198',257867,'DAILY SHIFT8','2022-12-30','2022-12-30 07:25:21','2022-12-31 07:25:21','953',0.00,0.00,'953','2022-12-30 18:41:05','953','2022-12-30 18:41:43',10,0),('1','198',257868,'DAILY SHIFT','2022-12-31','2022-12-31 10:06:38','2023-01-01 10:06:38','953',0.00,0.00,'953','2022-12-31 18:51:55','953','2022-12-31 18:52:22',10,0),('1','198',257869,'DAILY SHIFT','2023-01-01','2023-01-01 07:33:02','2023-01-02 07:33:02','953',0.00,0.00,'953','2023-01-01 18:33:42','953','2023-01-01 18:34:09',10,0),('1','198',257870,'DAILY SHIFT','2023-01-02','2023-01-02 08:00:13','2023-01-03 08:00:13','953',0.00,0.00,'953','2023-01-02 13:10:50','953','2023-01-02 13:11:19',10,0),('1','198',257871,'OPERATIONAL LOSS','2023-01-02','2023-01-02 13:12:47','2023-01-03 13:12:47','953',0.00,0.00,'953','2023-01-02 13:19:19','953','2023-01-02 13:19:53',10,0),('1','198',257872,'DAILY SHIFT','2023-01-02','2023-01-02 13:24:25','2023-01-03 13:24:25','953',0.00,0.00,'953','2023-01-02 18:02:40','953','2023-01-02 18:03:21',10,0),('1','198',257873,'DAILY SHIFT','2023-01-03','2023-01-03 07:26:33','2023-01-04 07:26:33','953',0.00,0.00,'953','2023-01-03 19:47:06','953','2023-01-03 19:47:38',10,0),('1','198',257874,'DAILY SHIFT','2023-01-04','2023-01-04 07:51:53','2023-01-05 07:51:53','953',0.00,0.00,'953','2023-01-04 18:09:19','953','2023-01-04 18:09:55',10,0),('1','198',257875,'DAILY SHIFT','2023-01-05','2023-01-05 07:36:44','2023-01-06 07:36:44','953',0.00,0.00,'953','2023-01-05 18:17:13','953','2023-01-05 18:17:53',10,0),('1','198',257876,'DAILY SHIFT','2023-01-06','2023-01-06 07:25:10','2023-01-07 07:25:10','953',0.00,0.00,'953','2023-01-06 18:39:11','953','2023-01-06 18:39:47',10,0),('1','198',257877,'DAILY SHIFT','2023-01-07','2023-01-07 07:34:55','2023-01-08 07:34:55','953',0.00,0.00,'953','2023-01-07 18:48:38','953','2023-01-07 18:49:22',10,0),('1','198',257878,'DAILY SHIFT','2023-01-08','2023-01-08 07:28:44','2023-01-09 07:28:44','953',0.00,0.00,'953','2023-01-08 18:36:44','953','2023-01-08 18:37:13',10,0),('1','198',257879,'DAILY SHIFT','2023-01-09','2023-01-09 07:23:41','2023-01-10 07:23:41','953',0.00,0.00,'953','2023-01-09 18:06:30','953','2023-01-09 18:07:09',10,0),('1','198',257880,'DAILY SHIFT','2023-01-10','2023-01-10 07:34:08','2023-01-11 07:34:08','953',0.00,0.00,'953','2023-01-10 10:35:52','953','2023-01-10 10:36:19',10,0),('1','198',257881,'OPERATIONAL LOSS','2023-01-10','2023-01-10 10:39:43','2023-01-11 10:39:43','953',0.00,0.00,'953','2023-01-10 10:48:04','953','2023-01-10 10:48:33',10,0),('1','198',257882,'DAILY SHIFT','2023-01-10','2023-01-10 10:56:22','2023-01-11 10:56:22','953',0.00,0.00,'953','2023-01-10 18:04:04','953','2023-01-10 18:04:33',10,0),('1','198',257883,'DAILY SHIFT','2023-01-11','2023-01-11 07:21:26','2023-01-12 07:21:26','953',0.00,0.00,'953','2023-01-11 18:19:19','953','2023-01-11 18:20:23',10,0),('1','198',257884,'DAILY SHIFT','2023-01-12','2023-01-12 07:31:41','2023-01-13 07:31:41','953',0.00,0.00,'953','2023-01-12 18:21:00','953','2023-01-12 18:22:13',10,0),('1','198',257885,'DAILY SHIFT','2023-01-13','2023-01-13 07:42:45','2023-01-14 07:42:45','953',0.00,0.00,'953','2023-01-13 18:06:13','953','2023-01-13 18:06:43',10,0),('1','198',257886,'DAILY SHIFT','2023-01-14','2023-01-14 07:44:49','2023-01-15 07:44:49','953',0.00,0.00,'953','2023-01-14 18:17:54','953','2023-01-14 18:18:18',10,0),('1','198',257887,'DAILY SHIFT','2023-01-15','2023-01-15 07:22:23','2023-01-16 07:22:23','953',0.00,0.00,'953','2023-01-15 18:16:45','953','2023-01-15 18:17:13',10,0),('1','198',257888,'DAILY SHIFT','2023-01-16','2023-01-16 07:23:45','2023-01-17 07:23:45','953',0.00,0.00,'953','2023-01-16 18:31:06','953','2023-01-16 18:31:42',10,0),('1','198',257889,'DAILY SHIFT','2023-01-17','2023-01-17 07:19:10','2023-01-18 07:19:10','953',0.00,0.00,'953','2023-01-17 10:46:53','953','2023-01-17 10:47:17',10,0),('1','198',257890,'OPERATIONAL LOSS','2023-01-17','2023-01-17 10:47:57','2023-01-18 10:47:57','953',0.00,0.00,'953','2023-01-17 10:58:22','953','2023-01-17 10:58:45',10,0),('1','198',257891,'DAILY SHIFT','2023-01-17','2023-01-17 10:59:14','2023-01-18 10:59:14','953',0.00,0.00,'953','2023-01-17 18:12:25','953','2023-01-17 18:12:54',10,0),('1','198',257892,'DAILY SHIFT','2023-01-18','2023-01-18 07:11:38','2023-01-19 07:11:38','953',0.00,0.00,'953','2023-01-18 18:16:40','953','2023-01-18 18:17:16',10,0),('1','198',257893,'DAILY SHIFT','2023-01-19','2023-01-19 07:31:32','2023-01-20 07:31:32','953',0.00,0.00,'953','2023-01-19 18:35:19','953','2023-01-19 18:35:48',10,0),('1','198',257894,'DAILY SHIFT','2023-01-20','2023-01-20 07:27:02','2023-01-21 07:27:02','953',0.00,0.00,'953','2023-01-20 18:08:25','953','2023-01-20 18:09:54',10,0),('1','198',257895,'DAILY SHIFT','2023-01-21','2023-01-21 07:19:14','2023-01-22 07:19:14','953',0.00,0.00,'953','2023-01-21 15:04:21','953','2023-01-21 15:04:44',10,0),('1','198',257896,'OPERATIONAL LOSS','2023-01-21','2023-01-21 15:06:25','2023-01-22 15:06:25','953',0.00,0.00,'953','2023-01-21 15:10:07','953','2023-01-21 15:10:35',10,0),('1','198',257897,'DAILY SHIFT','2023-01-21','2023-01-21 15:18:26','2023-01-22 15:18:26','953',0.00,0.00,'953','2023-01-21 18:15:50','953','2023-01-21 18:16:46',10,0),('1','198',257898,'DAILY SHIFT','2023-01-22','2023-01-22 07:27:39','2023-01-23 07:27:39','953',0.00,0.00,'953','2023-01-22 18:10:23','953','2023-01-22 18:11:03',10,0),('1','198',257899,'DAILY SHIFT','2023-01-23','2023-01-23 06:56:29','2023-01-24 06:56:29','953',0.00,0.00,'953','2023-01-23 18:30:01','953','2023-01-23 18:30:39',10,0),('1','198',257900,'DAILY SHIFT','2023-01-24','2023-01-24 07:42:03','2023-01-25 07:42:03','953',0.00,0.00,'953','2023-01-24 18:09:33','953','2023-01-24 18:10:10',10,0),('1','198',257901,'DAILY SHIFT','2023-01-25','2023-01-25 07:43:03','2023-01-26 07:43:03','953',0.00,0.00,'953','2023-01-25 18:21:03','953','2023-01-25 18:21:37',10,0),('1','198',257902,'DAILY SHIFT','2023-01-26','2023-01-26 07:37:51','2023-01-27 07:37:51','953',0.00,0.00,'953','2023-01-26 18:45:39','953','2023-01-26 18:46:37',10,0),('1','198',257903,'DAILY SHIFT','2023-01-27','2023-01-27 07:22:39','2023-01-28 07:22:39','953',0.00,0.00,'953','2023-01-27 18:46:44','953','2023-01-27 18:47:35',10,0),('1','198',257904,'DAILY SHIFT','2023-01-28','2023-01-28 10:12:22','2023-01-29 10:12:22','953',0.00,0.00,'953','2023-01-28 11:33:20','953','2023-01-28 11:33:48',10,0),('1','198',257905,'OPERATIONAL LOSS','2023-01-28','2023-01-28 11:35:48','2023-01-29 11:35:48','953',0.00,0.00,'953','2023-01-28 11:38:00','953','2023-01-28 11:38:25',10,0),('1','198',257906,'DAILY SHIFT','2023-01-28','2023-01-28 11:41:05','2023-01-29 11:41:05','953',0.00,0.00,'953','2023-01-28 18:53:44','953','2023-01-28 18:54:19',10,0),('1','198',257907,'DAILY SHIFT','2023-01-29','2023-01-29 07:39:26','2023-01-30 07:39:26','953',0.00,0.00,'953','2023-01-29 18:11:09','953','2023-01-29 18:11:42',10,0),('1','198',257908,'DAILY SHIFT','2023-01-30','2023-01-30 07:40:38','2023-01-31 07:40:38','953',0.00,0.00,'953','2023-01-30 18:50:17','953','2023-01-30 18:51:06',10,0),('1','198',257909,'DAILY SHIFT','2023-01-31','2023-01-31 07:06:38','2023-02-01 07:06:38','953',0.00,0.00,'953','2023-01-31 18:41:08','953','2023-01-31 18:42:58',10,0),('1','198',257910,'DAILY SHIFT','2023-02-01','2023-02-01 07:24:08','2023-02-02 07:24:08','953',0.00,0.00,'953','2023-02-01 18:48:29','953','2023-02-01 18:49:23',10,0),('1','198',257911,'DAILY SHIFT','2023-02-02','2023-02-02 07:36:12','2023-02-03 07:36:12','953',0.00,0.00,'953','2023-02-02 18:36:42','953','2023-02-02 18:38:30',10,0),('1','198',257912,'DAILY SHIFT','2023-02-03','2023-02-03 07:24:53','2023-02-04 07:24:53','953',0.00,0.00,'953','2023-02-03 19:34:49','953','2023-02-03 19:35:34',10,0),('1','198',257913,'DAILY SHIFT','2023-02-04','2023-02-04 07:37:45','2023-02-05 07:37:45','953',0.00,0.00,'953','2023-02-04 15:32:57','953','2023-02-04 15:34:03',10,0),('1','198',257914,'TRANSFER TO BOMPAI LPG','2023-02-04','2023-02-04 15:35:43','2023-02-05 15:35:43','953',0.00,0.00,'953','2023-02-04 15:39:35','953','2023-02-04 15:40:08',10,0),('1','198',257915,'DAILY SHIFT','2023-02-04','2023-02-04 15:47:17','2023-02-05 15:47:17','953',0.00,0.00,'953','2023-02-04 19:02:33','953','2023-02-04 19:03:46',10,0),('1','198',257916,'DAILY SHIFT','2023-02-05','2023-02-05 08:01:24','2023-02-06 08:01:24','953',0.00,0.00,'953','2023-02-05 19:02:35','953','2023-02-05 19:03:20',10,0),('1','198',257917,'DAILY SHIFT','2023-02-06','2023-02-06 07:27:00','2023-02-07 07:27:00','953',0.00,0.00,'953','2023-02-06 19:14:55','953','2023-02-06 19:16:25',10,0),('1','198',257918,'DAILY SHIFT','2023-02-07','2023-02-07 07:23:35','2023-02-08 07:23:35','953',0.00,0.00,'953','2023-02-07 19:32:53','953','2023-02-07 19:34:32',10,0),('1','198',257919,'DAILY SHIFT','2023-02-08','2023-02-08 07:40:03','2023-02-09 07:40:03','953',0.00,0.00,'953','2023-02-08 19:18:40','953','2023-02-08 19:20:01',10,0),('1','198',257920,'DAILY SHIFT','2023-02-09','2023-02-09 07:39:01','2023-02-10 07:39:01','953',0.00,0.00,'953','2023-02-09 19:08:08','953','2023-02-09 19:09:25',10,0),('1','198',257921,'DAILY SHIFT','2023-02-10','2023-02-10 07:30:21','2023-02-11 07:30:21','953',0.00,0.00,'953','2023-02-10 18:33:32','953','2023-02-10 18:39:47',10,0),('1','198',257922,'DAILY SHIFT','2023-02-11','2023-02-11 07:24:01','2023-02-12 07:24:01','953',0.00,0.00,'953','2023-02-11 18:38:45','953','2023-02-11 18:39:19',10,0),('1','198',257923,'DAILY SHIFT','2023-02-12','2023-02-12 07:23:13','2023-02-13 07:23:13','953',0.00,0.00,'953','2023-02-12 17:07:03','953','2023-02-12 17:07:30',10,0),('1','198',257924,'OPERATIONAL LOSS','2023-02-12','2023-02-12 17:08:50','2023-02-13 17:08:50','953',0.00,0.00,'953','2023-02-12 17:34:59','953','2023-02-12 17:35:31',10,0),('1','198',257925,'DAILY SHIFT','2023-02-12','2023-02-12 17:36:26','2023-02-13 17:36:26','953',0.00,0.00,'953','2023-02-12 18:55:58','953','2023-02-12 18:56:49',10,0),('1','198',257926,'DAILY SHIFT','2023-02-13','2023-02-13 07:23:55','2023-02-14 07:23:55','953',0.00,0.00,'953','2023-02-13 19:14:04','953','2023-02-13 19:14:47',10,0),('1','198',257927,'DAILY SHIFT','2023-02-14','2023-02-14 07:23:15','2023-02-15 07:23:15','953',0.00,0.00,'953','2023-02-14 18:29:46','953','2023-02-14 18:30:28',10,0),('1','198',257928,'DAILY SHIFT','2023-02-15','2023-02-15 07:31:08','2023-02-16 07:31:08','953',0.00,0.00,'953','2023-02-15 18:38:16','953','2023-02-15 18:40:59',10,0),('1','198',257929,'DAILY SHIFT','2023-02-16','2023-02-16 07:46:19','2023-02-17 07:46:19','953',0.00,0.00,'953','2023-02-16 18:30:28','953','2023-02-16 18:31:53',10,0),('1','198',257930,'DAILY SHIFT','2023-02-17','2023-02-17 07:39:21','2023-02-18 07:39:21','953',0.00,0.00,'953','2023-02-17 18:45:00','953','2023-02-17 18:46:06',10,0),('1','198',257931,'DAILY SHIFT','2023-02-18','2023-02-18 07:52:19','2023-02-19 07:52:19','953',0.00,0.00,'953','2023-02-18 19:07:01','953','2023-02-18 19:09:24',10,0),('1','198',257932,'DAILY SHIFT','2023-02-19','2023-02-19 08:03:23','2023-02-20 08:03:23','953',0.00,0.00,'953','2023-02-19 19:15:31','953','2023-02-19 19:16:11',10,0),('1','198',257933,'DAILY SHIFT','2023-02-20','2023-02-20 07:26:01','2023-02-21 07:26:01','953',0.00,0.00,'953','2023-02-20 18:33:50','953','2023-02-20 18:34:25',10,0),('1','198',257934,'DAILY SHIFT','2023-02-21','2023-02-21 07:34:29','2023-02-22 07:34:29','953',0.00,0.00,'953','2023-02-21 18:50:25','953','2023-02-21 18:53:59',10,0),('1','198',257935,'DAILY SHIFT84','2023-02-22','2023-02-22 08:38:14','2023-02-23 08:38:14','953',0.00,0.00,'953','2023-02-22 08:43:03','953','2023-02-22 08:43:29',10,0),('1','198',257936,'DAILY SHIFT','2023-02-22','2023-02-22 09:07:19','2023-02-23 09:07:19','953',0.00,0.00,'953','2023-02-22 18:57:50','953','2023-02-22 18:58:32',10,0),('1','198',257937,'DAILY SHIFT','2023-02-23','2023-02-23 07:51:41','2023-02-24 07:51:41','953',0.00,0.00,'953','2023-02-23 19:06:11','953','2023-02-23 19:07:44',10,0),('1','198',257938,'DAILY SHIFT','2023-02-24','2023-02-24 07:28:12','2023-02-25 07:28:12','953',0.00,0.00,'953','2023-02-24 19:35:23','953','2023-02-24 19:38:11',10,0),('1','198',257939,'DAILY SHIFT','2023-02-26','2023-02-26 07:34:45','2023-02-27 07:34:45','953',0.00,0.00,'953','2023-02-26 19:38:24','953','2023-02-26 19:39:13',10,0),('1','198',257940,'DAILY SHIFT','2023-02-27','2023-02-27 07:42:00','2023-02-28 07:42:00','953',0.00,0.00,'953','2023-02-27 18:34:41','953','2023-02-27 18:35:57',10,0),('1','198',257941,'DAILY SHIFT','2023-02-28','2023-02-28 07:36:36','2023-03-01 07:36:36','953',0.00,0.00,'953','2023-02-28 18:28:28','953','2023-02-28 18:29:13',10,0),('1','198',257942,'DAILY SHIFT','2023-03-01','2023-03-01 10:27:43','2023-03-02 10:27:43','953',0.00,0.00,'953','2023-03-01 18:50:39','953','2023-03-01 18:51:13',10,0),('1','198',257943,'DAILY SHIFT','2023-03-02','2023-03-02 07:22:03','2023-03-03 07:22:03','953',0.00,0.00,'953','2023-03-02 10:30:54','953','2023-03-02 10:31:25',10,0),('1','198',257944,'OPERATIONAL LOSS','2023-03-02','2023-03-02 10:33:02','2023-03-03 10:33:02','953',0.00,0.00,'953','2023-03-02 10:37:01','953','2023-03-02 10:38:05',10,0),('1','198',257945,'DAILY SHIFT','2023-03-02','2023-03-02 10:44:33','2023-03-03 10:44:33','953',0.00,0.00,'953','2023-03-02 19:10:45','953','2023-03-02 19:11:22',10,0),('1','198',257946,'DAILY SHIFT','2023-03-03','2023-03-03 06:54:16','2023-03-04 06:54:16','953',0.00,0.00,'953','2023-03-03 18:56:46','953','2023-03-03 18:57:49',10,0),('1','198',257947,'DAILY SHIFT','2023-03-04','2023-03-04 07:28:08','2023-03-05 07:28:08','953',0.00,0.00,'953','2023-03-04 18:42:55','953','2023-03-04 18:43:50',10,0),('1','198',257948,'DAILY SHIFT','2023-03-05','2023-03-05 07:19:04','2023-03-06 07:19:04','953',0.00,0.00,'953','2023-03-05 18:26:24','953','2023-03-05 18:27:18',10,0),('1','198',257949,'DAILY SHIFT','2023-03-06','2023-03-06 06:53:22','2023-03-07 06:53:22','953',0.00,0.00,'953','2023-03-06 18:40:22','953','2023-03-06 18:42:57',10,0),('1','198',257950,'DAILY SHIFT','2023-03-07','2023-03-07 07:26:08','2023-03-08 07:26:08','953',0.00,0.00,'953','2023-03-07 18:42:47','953','2023-03-07 18:43:20',10,0),('1','198',257951,'DAILY SHIFT','2023-03-08','2023-03-08 07:37:56','2023-03-09 07:37:56','953',0.00,0.00,'953','2023-03-09 09:07:19','953','2023-03-09 09:08:09',10,0),('1','198',257952,'DAILY SHIFT','2023-03-09','2023-03-09 09:08:38','2023-03-10 09:08:38','953',0.00,0.00,'953','2023-03-09 18:36:37','953','2023-03-09 18:37:20',10,0),('1','198',257953,'DAILY SHIFT','2023-03-10','2023-03-10 09:07:42','2023-03-11 09:07:42','953',0.00,0.00,'953','2023-03-10 18:20:15','953','2023-03-10 18:21:03',10,0),('1','198',257954,'DAILY SHIFT','2023-03-11','2023-03-11 07:31:06','2023-03-12 07:31:06','953',0.00,0.00,'953','2023-03-11 12:03:50','953','2023-03-11 12:04:13',10,0),('1','198',257955,'OPERATIONAL LOSS','2023-03-11','2023-03-11 12:05:06','2023-03-12 12:05:06','953',0.00,0.00,'953','2023-03-11 12:07:45','953','2023-03-11 12:08:10',10,0),('1','198',257956,'DAILY SHIFT','2023-03-11','2023-03-11 12:11:16','2023-03-12 12:11:16','953',0.00,0.00,'953','2023-03-11 20:08:12','953','2023-03-11 20:09:08',10,0),('1','198',257957,'DAILY SHIFT','2023-03-12','2023-03-12 07:04:55','2023-03-13 07:04:55','953',0.00,0.00,'953','2023-03-12 19:25:42','953','2023-03-12 19:26:40',10,0),('1','198',257958,'DAILY SHIFT','2023-03-13','2023-03-13 07:25:08','2023-03-14 07:25:08','953',0.00,0.00,'953','2023-03-13 19:28:21','953','2023-03-13 19:29:15',10,0),('1','198',257959,'DAILY SHIFT','2023-03-14','2023-03-14 09:50:53','2023-03-15 09:50:53','953',0.00,0.00,'953','2023-03-14 19:05:15','953','2023-03-14 19:05:59',10,0),('1','198',257960,'DAILY SHIFT','2023-03-15','2023-03-15 07:40:33','2023-03-16 07:40:33','953',0.00,0.00,'953','2023-03-15 19:06:01','953','2023-03-15 19:06:36',10,0),('1','198',257961,'DAILY SHIFT','2023-03-16','2023-03-16 07:37:00','2023-03-17 07:37:00','953',0.00,0.00,'953','2023-03-16 14:16:19','953','2023-03-16 14:16:49',10,0),('1','198',257962,'OPERATIONAL LOSS','2023-03-16','2023-03-16 14:18:09','2023-03-17 14:18:09','953',0.00,0.00,'953','2023-03-16 14:22:51','953','2023-03-16 14:23:23',10,0),('1','198',257963,'DAILY SHIFT','2023-03-16','2023-03-16 14:28:39','2023-03-17 14:28:39','953',0.00,0.00,'953','2023-03-16 19:07:54','953','2023-03-16 19:09:21',10,0),('1','198',257964,'DAILY SHIFT','2023-03-17','2023-03-17 07:13:23','2023-03-18 07:13:23','953',0.00,0.00,'953','2023-03-17 18:59:45','953','2023-03-17 19:00:28',10,0),('1','198',257965,'DAILY SHIFT','2023-03-19','2023-03-19 07:31:01','2023-03-20 07:31:01','953',0.00,0.00,'953','2023-03-19 19:13:59','953','2023-03-19 19:15:43',10,0),('1','198',257966,'DAILY SHIFT','2023-03-20','2023-03-20 07:37:09','2023-03-21 07:37:09','953',0.00,0.00,'953','2023-03-20 10:50:55','953','2023-03-20 10:51:38',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4907150 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','198','1016','236677',4546278,'3002','463',0.00,1633.24,0.00,0.00,1633.24,991274.92,0.00,0.00,0.00),('1','198','1017','236677',4546279,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','236739',4547237,'3002','463',1633.24,3332.72,0.00,0.00,1699.48,1036679.68,0.00,0.00,0.00),('1','198','1017','236739',4547238,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','236962',4551228,'3002','463',3332.72,5051.95,0.00,0.00,1719.23,1047405.68,0.00,0.00,0.00),('1','198','1017','236962',4551229,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','237167',4554865,'3002','463',5051.95,6638.11,0.00,0.00,1586.16,960891.48,0.00,0.00,0.00),('1','198','1017','237167',4554866,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','237369',4558682,'3002','463',6638.11,9751.03,0.00,0.00,3112.92,1887444.72,0.00,0.00,0.00),('1','198','1017','237369',4558683,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','237598',4562706,'3002','463',9751.03,14680.30,0.00,0.00,4929.27,2987530.32,0.00,0.00,0.00),('1','198','1017','237598',4562707,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','237862',4567054,'3002','463',14680.30,18415.03,0.00,0.00,3734.73,2265151.68,0.00,0.00,0.00),('1','198','1017','237862',4567055,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','238127',4571162,'3002','463',18415.03,22857.86,0.00,0.00,4442.83,2692000.00,0.00,0.00,0.00),('1','198','1017','238127',4571163,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','238336',4575124,'3002','463',22857.86,23317.96,0.00,0.00,460.10,279881.60,0.00,0.00,0.00),('1','198','1017','238336',4575125,'3003','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','238457',4576921,'3002','463',23317.96,23338.46,0.00,0.00,20.50,12628.00,0.00,0.00,0.00),('1','198','1017','238457',4576922,'3003','463',0.00,2228.28,0.00,0.00,2228.28,1349256.48,0.00,0.00,0.00),('1','198','1016','238592',4579309,'3002','463',23338.46,23338.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','238592',4579310,'3003','463',2228.28,8185.34,0.00,0.00,5957.06,3603919.76,0.00,0.00,0.00),('1','198','1016','238811',4583249,'3002','463',23338.46,23338.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','238811',4583250,'3003','463',8185.34,12158.13,0.00,0.00,3972.79,2403288.64,0.00,0.00,0.00),('1','198','1016','239075',4587727,'3002','463',23338.46,23338.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','239075',4587728,'3003','463',12158.13,17822.24,0.00,0.00,5664.11,3425908.40,0.00,0.00,0.00),('1','198','1016','239298',4591586,'3002','463',23338.46,23338.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','239298',4591587,'3003','463',17822.24,22556.55,0.00,0.00,4734.31,2865706.96,0.00,0.00,0.00),('1','198','1016','239509',4595336,'3002','463',23338.46,23338.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','239509',4595337,'3003','463',22556.55,22976.33,0.00,0.00,419.78,254684.48,0.00,0.00,0.00),('1','198','1016','239611',4597014,'3002','463',23338.46,23338.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','239611',4597015,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','239624',4597212,'3002','463',23338.46,25621.11,0.00,0.00,2282.65,1395961.84,0.00,0.00,0.00),('1','198','1017','239624',4597213,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','239756',4599578,'3002','463',25621.11,28225.84,0.00,0.00,2604.73,1620019.76,0.00,0.00,0.00),('1','198','1017','239756',4599579,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','239993',4603590,'3002','463',28225.84,30156.06,0.00,0.00,1930.22,1202079.04,0.00,0.00,0.00),('1','198','1017','239993',4603591,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','240179',4607019,'3002','463',30156.06,31970.63,0.00,0.00,1814.57,1126822.24,0.00,0.00,0.00),('1','198','1017','240179',4607020,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','240427',4611090,'3002','463',31970.63,34069.62,0.00,0.00,2098.99,1283553.92,0.00,0.00,0.00),('1','198','1017','240427',4611091,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','240684',4614887,'3002','463',34069.62,38742.56,0.00,0.00,4672.94,2863250.08,0.00,0.00,0.00),('1','198','1017','240684',4614888,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','240957',4619822,'3002','463',38742.56,41843.74,0.00,0.00,3101.18,1894265.68,0.00,0.00,0.00),('1','198','1017','240957',4619823,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','241224',4624556,'3002','463',41843.74,43840.31,0.00,0.00,1996.57,1224376.40,0.00,0.00,0.00),('1','198','1017','241224',4624557,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','241470',4628867,'3002','463',43840.31,47122.53,0.00,0.00,3282.22,2008243.04,0.00,0.00,0.00),('1','198','1017','241470',4628868,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','241741',4633402,'3002','463',47122.53,47701.74,0.00,0.00,579.21,357084.72,0.00,0.00,0.00),('1','198','1017','241741',4633403,'3003','463',22976.33,22976.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','241823',4634710,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','241823',4634711,'3003','463',22976.33,26016.23,0.00,0.00,3039.90,1857160.80,0.00,0.00,0.00),('1','198','1016','242024',4638193,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','242024',4638194,'3003','463',26016.23,29332.21,0.00,0.00,3315.98,2026987.36,0.00,0.00,0.00),('1','198','1016','242194',4641422,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','242194',4641423,'3003','463',29332.21,33310.36,0.00,0.00,3978.15,2432854.80,0.00,0.00,0.00),('1','198','1016','242413',4645294,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','242413',4645295,'3003','463',33310.36,35196.03,0.00,0.00,1885.67,1158371.44,0.00,0.00,0.00),('1','198','1016','242679',4649803,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','242679',4649804,'3003','463',35196.03,39039.86,0.00,0.00,3843.83,2354593.36,0.00,0.00,0.00),('1','198','1016','242908',4653746,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','242908',4653747,'3003','463',39039.86,42150.08,0.00,0.00,3110.22,1910232.72,0.00,0.00,0.00),('1','198','1016','243145',4657768,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','243145',4657769,'3003','463',42150.08,45700.74,0.00,0.00,3550.66,2177911.60,0.00,0.00,0.00),('1','198','1016','243368',4661883,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','243368',4661884,'3003','463',45700.74,47433.08,0.00,0.00,1732.34,1064781.76,0.00,0.00,0.00),('1','198','1016','243513',4664290,'3002','463',47701.74,47701.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','243513',4664291,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','243519',4664397,'3002','463',47701.74,48794.18,0.00,0.00,1092.44,668630.08,0.00,0.00,0.00),('1','198','1017','243519',4664398,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','243629',4666205,'3002','463',48794.18,51080.36,0.00,0.00,2286.18,1408653.76,0.00,0.00,0.00),('1','198','1017','243629',4666206,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','243830',4669844,'3002','463',51080.36,53771.05,0.00,0.00,2690.69,1650661.60,0.00,0.00,0.00),('1','198','1017','243830',4669845,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','244037',4673545,'3002','463',53771.05,58080.97,0.00,0.00,4309.92,2635270.16,0.00,0.00,0.00),('1','198','1017','244037',4673546,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','244312',4677916,'3002','463',58080.97,59923.51,0.00,0.00,1842.54,1135905.28,0.00,0.00,0.00),('1','198','1017','244312',4677917,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','244517',4681713,'3002','463',59923.51,62477.43,50.00,31600.00,2503.92,1533887.48,0.00,0.00,0.00),('1','198','1017','244517',4681714,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','244758',4685624,'3002','463',62477.43,64509.95,0.00,0.00,2032.52,1251047.00,0.00,0.00,0.00),('1','198','1017','244758',4685625,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','244956',4689490,'3002','463',64509.95,68150.89,0.00,0.00,3640.94,2197818.56,0.00,0.00,0.00),('1','198','1017','244956',4689491,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','245222',4693886,'3002','463',68150.89,70425.71,0.00,0.00,2274.82,1381139.60,0.00,0.00,0.00),('1','198','1017','245222',4693887,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','245440',4697717,'3002','463',70425.71,71904.91,0.00,0.00,1479.20,898068.80,0.00,0.00,0.00),('1','198','1017','245440',4697718,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','245671',4701790,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','245671',4701791,'3003','463',47433.08,47433.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','245690',4701979,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','245690',4701980,'3003','463',47433.08,48229.91,0.00,0.00,796.83,478098.00,0.00,0.00,0.00),('1','198','1016','245693',4702000,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','245693',4702001,'3003','463',48229.91,50715.76,0.00,0.00,2485.85,1505603.90,0.00,0.00,0.00),('1','198','1016','245949',4705944,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','245949',4705945,'3003','463',50715.76,53016.06,0.00,0.00,2300.30,1338168.80,0.00,0.00,0.00),('1','198','1016','246189',4710038,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','246189',4710039,'3003','463',53016.06,56316.58,0.00,0.00,3300.52,1906947.86,0.00,0.00,0.00),('1','198','1016','246461',4714613,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','246461',4714614,'3003','463',56316.58,58996.44,0.00,0.00,2679.86,1554565.96,0.00,0.00,0.00),('1','198','1016','246682',4718656,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','246682',4718657,'3003','463',58996.44,60716.96,0.00,0.00,1720.52,1017220.32,0.00,0.00,0.00),('1','198','1016','246941',4723058,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','246941',4723059,'3003','463',60716.96,64074.22,0.00,0.00,3357.26,1936400.66,0.00,0.00,0.00),('1','198','1016','247162',4726883,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','247162',4726884,'3003','463',64074.22,66312.55,0.00,0.00,2238.33,1292072.88,0.00,0.00,0.00),('1','198','1016','247397',4731056,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','247397',4731057,'3003','463',66312.55,69311.35,0.00,0.00,2998.80,1722394.40,0.00,0.00,0.00),('1','198','1016','247648',4735344,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','247648',4735345,'3003','463',69311.35,71845.24,0.00,0.00,2533.89,1451654.92,0.00,0.00,0.00),('1','198','1016','247928',4739811,'3002','463',71904.91,71904.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','247928',4739812,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','247937',4739866,'3002','463',71904.91,74198.72,0.00,0.00,2293.81,1324989.78,0.00,0.00,0.00),('1','198','1017','247937',4739867,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','248167',4743923,'3002','463',74198.72,76698.13,0.00,0.00,2499.41,1438764.46,0.00,0.00,0.00),('1','198','1017','248167',4743924,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','248420',4748176,'3002','463',76698.13,79094.67,0.00,0.00,2396.54,1384321.32,0.00,0.00,0.00),('1','198','1017','248420',4748177,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','248636',4751920,'3002','463',79094.67,80935.53,0.00,0.00,1840.86,1064648.88,0.00,0.00,0.00),('1','198','1017','248636',4751921,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','248873',4755973,'3002','463',80935.53,83697.21,0.00,0.00,2761.68,1557966.10,0.00,0.00,0.00),('1','198','1017','248873',4755974,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','249106',4759843,'3002','463',83697.21,87801.65,0.00,0.00,4104.44,2303036.55,0.00,0.00,0.00),('1','198','1017','249106',4759844,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','249345',4763948,'3002','463',87801.65,90260.80,0.00,0.00,2459.15,1388595.60,0.00,0.00,0.00),('1','198','1017','249345',4763949,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','249573',4767885,'3002','463',90260.80,94836.67,0.00,0.00,4575.87,2572917.00,0.00,0.00,0.00),('1','198','1017','249573',4767886,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','249853',4772508,'3002','463',94836.67,96233.30,0.00,0.00,1396.63,807892.00,0.00,0.00,0.00),('1','198','1017','249853',4772509,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','250064',4776154,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','250064',4776155,'3003','463',71845.24,71845.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','250105',4776654,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','250105',4776655,'3003','463',71845.24,76731.39,0.00,0.00,4886.15,2719371.32,0.00,0.00,0.00),('1','198','1016','250327',4780573,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','250327',4780574,'3003','463',76731.39,80408.59,0.00,0.00,3677.20,2018970.10,0.00,0.00,0.00),('1','198','1016','250562',4784364,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','250562',4784365,'3003','463',80408.59,83491.92,0.00,0.00,3083.33,1696509.48,0.00,0.00,0.00),('1','198','1016','250804',4788525,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','250804',4788526,'3003','463',83491.92,86080.07,0.00,0.00,2588.15,1424170.20,0.00,0.00,0.00),('1','198','1016','251021',4792504,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','251021',4792505,'3003','463',86080.07,89911.41,0.00,0.00,3831.34,2102314.88,0.00,0.00,0.00),('1','198','1016','251285',4796929,'3002','463',96233.30,96233.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','251285',4796930,'3003','463',89911.41,93270.13,0.00,0.00,3358.72,1843135.80,0.00,0.00,0.00),('1','198','1016','251515',4800911,'3002','463',96233.30,96259.71,0.00,0.00,26.41,15000.88,0.00,0.00,0.00),('1','198','1017','251515',4800912,'3003','463',93270.13,96087.95,0.00,0.00,2817.82,1549655.76,0.00,0.00,0.00),('1','198','1016','251751',4805313,'3002','463',96259.71,98470.61,0.00,0.00,2210.90,1216181.44,0.00,0.00,0.00),('1','198','1017','251751',4805314,'3003','463',96087.95,96645.48,0.00,0.00,557.53,309979.04,0.00,0.00,0.00),('1','198','1016','252000',4809392,'3002','463',98470.61,101918.94,0.00,0.00,3448.33,1893405.44,0.00,0.00,0.00),('1','198','1017','252000',4809393,'3003','463',96645.48,96670.48,0.00,0.00,25.00,14200.00,0.00,0.00,0.00),('1','198','1016','252271',4813998,'3002','463',101918.94,104026.65,0.00,0.00,2107.71,1158784.96,0.00,0.00,0.00),('1','198','1017','252271',4813999,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','252479',4817951,'3002','463',104026.65,105509.33,0.00,0.00,1482.68,821961.92,0.00,0.00,0.00),('1','198','1017','252479',4817952,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','252702',4821909,'3002','463',105509.33,108980.65,0.00,0.00,3471.32,1899019.40,0.00,0.00,0.00),('1','198','1017','252702',4821910,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','252962',4826060,'3002','463',108980.65,111927.68,0.00,0.00,2947.03,1620359.64,0.00,0.00,0.00),('1','198','1017','252962',4826061,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','253222',4830345,'3002','463',111927.68,113674.13,0.00,0.00,1746.45,962994.12,0.00,0.00,0.00),('1','198','1017','253222',4830346,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','253465',4834667,'3002','463',113674.13,116120.69,0.00,0.00,2446.56,1340008.00,0.00,0.00,0.00),('1','198','1017','253465',4834668,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','253697',4838644,'3002','463',116120.69,117853.77,0.00,0.00,1733.08,956164.80,0.00,0.00,0.00),('1','198','1017','253697',4838645,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','253946',4843004,'3002','463',117853.77,119832.36,0.00,0.00,1978.59,1085278.40,0.00,0.00,0.00),('1','198','1017','253946',4843005,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','254225',4847742,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','254225',4847743,'3003','463',96670.48,96670.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','254250',4848127,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','254250',4848128,'3003','463',96670.48,98527.38,0.00,0.00,1856.90,1019214.00,0.00,0.00,0.00),('1','198','1016','254444',4851718,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','254444',4851719,'3003','463',98527.38,101351.78,0.00,0.00,2824.40,1549741.12,0.00,0.00,0.00),('1','198','1016','254713',4856225,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','254713',4856226,'3003','463',101351.78,103474.43,0.00,0.00,2122.65,1166833.12,0.00,0.00,0.00),('1','198','1016','254932',4860192,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','254932',4860193,'3003','463',103474.43,106702.92,0.00,0.00,3228.49,1770152.40,0.00,0.00,0.00),('1','198','1016','255197',4864545,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','255197',4864546,'3003','463',106702.92,108703.77,0.00,0.00,2000.85,1099711.52,0.00,0.00,0.00),('1','198','1016','255465',4869146,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','255465',4869147,'3003','463',108703.77,111335.18,0.00,0.00,2631.41,1443858.56,0.00,0.00,0.00),('1','198','1016','255706',4873218,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','255706',4873219,'3003','463',111335.18,113992.10,0.00,0.00,2656.92,1452644.96,0.00,0.00,0.00),('1','198','1016','255974',4877353,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','255974',4877354,'3003','463',113992.10,115839.32,0.00,0.00,1847.22,1017971.20,0.00,0.00,0.00),('1','198','1016','256217',4881276,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','256217',4881277,'3003','463',115839.32,118922.66,0.00,0.00,3083.34,1691727.40,0.00,0.00,0.00),('1','198','1016','256481',4885960,'3002','463',119832.36,119832.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','256481',4885961,'3003','463',118922.66,120582.66,0.00,0.00,1660.00,914498.42,0.00,0.00,0.00),('1','198','1016','256722',4889949,'3002','463',119832.36,121491.61,0.00,0.00,1659.25,907264.76,0.00,0.00,0.00),('1','198','1017','256722',4889950,'3003','463',120582.66,121299.13,0.00,0.00,716.47,395431.76,0.00,0.00,0.00),('1','198','1016','256976',4894263,'3002','463',121491.61,123994.37,0.00,0.00,2502.76,1374207.84,0.00,0.00,0.00),('1','198','1017','256976',4894264,'3003','463',121299.13,121299.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257300',4900146,'3002','463',123994.37,127233.37,0.00,0.00,3239.00,1775558.00,0.00,0.00,0.00),('1','198','1017','257300',4900147,'3003','463',121299.13,121299.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257485',4903492,'3002','463',127233.37,130077.59,0.00,0.00,2844.22,1560699.20,0.00,0.00,0.00),('1','198','1017','257485',4903493,'3003','463',121299.13,121299.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257486',4903494,'3002','463',130077.59,132733.26,0.00,0.00,2655.67,1461160.72,0.00,0.00,0.00),('1','198','1017','257486',4903495,'3003','463',121299.13,121299.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257487',4903496,'3002','463',132733.26,134987.49,0.00,0.00,2254.23,1243964.80,0.00,0.00,0.00),('1','198','1017','257487',4903497,'3003','463',121299.13,121329.63,0.00,0.00,30.50,17080.00,0.00,0.00,0.00),('1','198','1016','257488',4903498,'3002','463',134987.49,138001.40,0.00,0.00,3013.91,1654921.60,0.00,0.00,0.00),('1','198','1017','257488',4903499,'3003','463',121329.63,121329.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257489',4903500,'3002','463',138001.40,140098.47,0.00,0.00,2097.07,1158121.92,0.00,0.00,0.00),('1','198','1017','257489',4903501,'3003','463',121329.63,121329.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257490',4903502,'3002','463',140098.47,142970.47,0.00,0.00,2872.00,1581416.96,0.00,0.00,0.00),('1','198','1017','257490',4903503,'3003','463',121329.63,121334.63,0.00,0.00,5.00,2800.00,0.00,0.00,0.00),('1','198','1016','257491',4903504,'3002','463',142970.47,143611.43,0.00,0.00,640.96,355656.00,0.00,0.00,0.00),('1','198','1017','257491',4903505,'3003','463',121334.63,123023.87,0.00,0.00,1689.24,930006.40,0.00,0.00,0.00),('1','198','1016','257492',4903506,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257492',4903507,'3003','463',123023.87,126118.98,0.00,0.00,3095.11,1696694.20,0.00,0.00,0.00),('1','198','1016','257493',4903508,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257493',4903509,'3003','463',126118.98,128225.65,0.00,0.00,2106.67,1157870.72,0.00,0.00,0.00),('1','198','1016','257494',4903510,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257494',4903511,'3003','463',128225.65,130576.06,0.00,0.00,2350.41,1294915.12,0.00,0.00,0.00),('1','198','1016','257495',4903512,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257495',4903513,'3003','463',130576.06,132611.77,0.00,0.00,2035.71,1122205.60,0.00,0.00,0.00),('1','198','1016','257496',4903514,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257496',4903515,'3003','463',132611.77,135702.72,0.00,0.00,3090.95,1694745.44,0.00,0.00,0.00),('1','198','1016','257497',4903516,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257497',4903517,'3003','463',135702.72,137650.30,0.00,0.00,1947.58,1068663.88,0.00,0.00,0.00),('1','198','1016','257498',4903518,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257498',4903519,'3003','463',137650.30,139692.56,0.00,0.00,2042.26,1124621.60,0.00,0.00,0.00),('1','198','1016','257499',4903520,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257499',4903521,'3003','463',139692.56,142774.75,0.00,0.00,3082.19,1696163.20,0.00,0.00,0.00),('1','198','1016','257500',4903522,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257500',4903523,'3003','463',142774.75,144276.81,0.00,0.00,1502.06,832347.20,0.00,0.00,0.00),('1','198','1016','257501',4903524,'3002','463',143611.43,143611.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257501',4903525,'3003','463',144276.81,145405.52,0.00,0.00,1128.71,627949.60,0.00,0.00,0.00),('1','198','1016','257502',4903526,'3002','463',143611.43,145374.14,0.00,0.00,1762.71,960967.60,0.00,0.00,0.00),('1','198','1017','257502',4903527,'3003','463',145405.52,145867.76,0.00,0.00,462.24,257563.84,0.00,0.00,0.00),('1','198','1016','257503',4903528,'3002','463',145374.14,146625.58,0.00,0.00,1251.44,690604.32,0.00,0.00,0.00),('1','198','1017','257503',4903529,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257504',4903530,'3002','463',146625.58,148304.75,0.00,0.00,1679.17,927519.20,0.00,0.00,0.00),('1','198','1017','257504',4903531,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257505',4903532,'3002','463',148304.75,150488.42,0.00,0.00,2183.67,1199151.20,0.00,0.00,0.00),('1','198','1017','257505',4903533,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257506',4903534,'3002','463',150488.42,152060.06,0.00,0.00,1571.64,867008.16,0.00,0.00,0.00),('1','198','1017','257506',4903535,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257507',4903536,'3002','463',152060.06,153532.16,0.00,0.00,1472.10,814766.24,0.00,0.00,0.00),('1','198','1017','257507',4903537,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257508',4903538,'3002','463',153532.16,156079.05,0.00,0.00,2546.89,1396125.76,0.00,0.00,0.00),('1','198','1017','257508',4903539,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257509',4903540,'3002','463',156079.05,157829.97,0.00,0.00,1750.92,964491.20,0.00,0.00,0.00),('1','198','1017','257509',4903541,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257510',4903542,'3002','463',157829.97,159634.18,0.00,0.00,1804.21,998692.96,0.00,0.00,0.00),('1','198','1017','257510',4903543,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257511',4903544,'3002','463',159634.18,162100.96,0.00,0.00,2466.78,1349800.80,0.00,0.00,0.00),('1','198','1017','257511',4903545,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257512',4903546,'3002','463',162100.96,163990.55,0.00,0.00,1889.59,1040962.40,0.00,0.00,0.00),('1','198','1017','257512',4903547,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257513',4903548,'3002','463',163990.55,165393.08,0.00,0.00,1402.53,774811.04,0.00,0.00,0.00),('1','198','1017','257513',4903549,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257514',4903550,'3002','463',165393.08,167275.11,0.00,0.00,1882.03,1033636.24,0.00,0.00,0.00),('1','198','1017','257514',4903551,'3003','463',145867.76,145867.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257515',4903552,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257515',4903553,'3003','463',145867.76,150854.11,0.00,0.00,4986.35,2765210.00,0.00,0.00,0.00),('1','198','1016','257516',4903554,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257516',4903555,'3003','463',150854.11,153392.58,0.00,0.00,2538.47,1398568.80,0.00,0.00,0.00),('1','198','1016','257517',4903556,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257517',4903557,'3003','463',153392.58,156678.08,0.00,0.00,3285.50,1798971.68,0.00,0.00,0.00),('1','198','1016','257518',4903558,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257518',4903559,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257518',4903560,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257518',4903561,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257518',4903562,'3003','463',156678.08,159491.87,0.00,0.00,2813.79,1542627.28,0.00,0.00,0.00),('1','198','1017','257518',4903563,'3004','463',0.00,18.57,0.00,0.00,18.57,10399.20,0.00,0.00,0.00),('1','198','1017','257518',4903564,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257518',4903565,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257519',4903566,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257519',4903567,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257519',4903568,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257519',4903569,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257519',4903570,'3003','463',159491.87,161260.93,0.00,0.00,1769.06,981687.60,0.00,0.00,0.00),('1','198','1017','257519',4903571,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257519',4903572,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257519',4903573,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257520',4903574,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257520',4903575,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257520',4903576,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257520',4903577,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257520',4903578,'3003','463',161260.93,163959.89,0.00,0.00,2698.96,1481423.44,0.00,0.00,0.00),('1','198','1017','257520',4903579,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257520',4903580,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257520',4903581,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257521',4903582,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257521',4903583,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257521',4903584,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257521',4903585,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257521',4903586,'3003','463',163959.89,165970.07,0.00,0.00,2010.18,1111996.00,0.00,0.00,0.00),('1','198','1017','257521',4903587,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257521',4903588,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257521',4903589,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257522',4903590,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257522',4903591,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257522',4903592,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257522',4903593,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257522',4903594,'3003','463',165970.07,168808.77,0.00,0.00,2838.70,1560479.52,0.00,0.00,0.00),('1','198','1017','257522',4903595,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257522',4903596,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257522',4903597,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257523',4903598,'3002','463',167275.11,167275.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257523',4903599,'3003','463',168808.77,170214.37,0.00,0.00,1405.60,759024.00,0.00,0.00,0.00),('1','198','1017','257523',4903600,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257523',4903601,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257523',4903602,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257523',4903603,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257523',4903604,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257523',4903605,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257524',4903606,'3002','463',167275.11,168381.44,0.00,0.00,1106.33,702951.20,0.00,0.00,0.00),('1','198','1017','257524',4903607,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257524',4903608,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257524',4903609,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257524',4903610,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257524',4903611,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257524',4903612,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257524',4903613,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257525',4903614,'3002','463',168381.44,169723.86,0.00,0.00,1342.42,854418.80,0.00,0.00,0.00),('1','198','1017','257525',4903615,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257525',4903616,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257525',4903617,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257525',4903618,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257525',4903619,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257525',4903620,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257525',4903621,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257526',4903622,'3002','463',169723.86,171177.61,0.00,0.00,1453.75,918810.00,0.00,0.00,0.00),('1','198','1016','257526',4903623,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257526',4903624,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257526',4903625,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257526',4903626,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257526',4903627,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257526',4903628,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257526',4903629,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257527',4903630,'3002','463',171177.61,172670.84,0.00,0.00,1493.23,945100.20,0.00,0.00,0.00),('1','198','1016','257527',4903631,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257527',4903632,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257527',4903633,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257527',4903634,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257527',4903635,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257527',4903636,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257527',4903637,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257528',4903638,'3002','463',172670.84,174165.31,0.00,0.00,1494.47,943570.80,0.00,0.00,0.00),('1','198','1016','257528',4903639,'3007','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257528',4903640,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257528',4903641,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257528',4903642,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257528',4903643,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257528',4903644,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257528',4903645,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257529',4903646,'3002','463',174165.31,175620.04,0.00,0.00,1454.73,921870.20,0.00,0.00,0.00),('1','198','1016','257529',4903647,'3007','463',0.00,3.00,0.00,0.00,3.00,1920.00,0.00,0.00,0.00),('1','198','1016','257529',4903648,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257529',4903649,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257529',4903650,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257529',4903651,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257529',4903652,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257529',4903653,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257530',4903654,'3002','463',175620.04,176905.89,0.00,0.00,1285.85,861316.80,0.00,0.00,0.00),('1','198','1016','257530',4903655,'3007','463',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257530',4903656,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257530',4903657,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257530',4903658,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257530',4903659,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257530',4903660,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257530',4903661,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257531',4903662,'3002','463',176905.89,178228.97,0.00,0.00,1323.08,888516.80,0.00,0.00,0.00),('1','198','1017','257531',4903663,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257531',4903664,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257531',4903665,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257531',4903666,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257531',4903667,'3007','463',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257531',4903668,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257531',4903669,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257532',4903670,'3002','463',178228.97,179260.17,0.00,0.00,1031.20,693544.00,0.00,0.00,0.00),('1','198','1017','257532',4903671,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257532',4903672,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257532',4903673,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257532',4903674,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257532',4903675,'3007','463',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257532',4903676,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257532',4903677,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257533',4903678,'3002','463',179260.17,180621.10,0.00,0.00,1360.93,866414.08,0.00,0.00,0.00),('1','198','1017','257533',4903679,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257533',4903680,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257533',4903681,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257533',4903682,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257533',4903683,'3007','463',3.00,5.34,0.00,0.00,2.34,1497.60,0.00,0.00,0.00),('1','198','1016','257533',4903684,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257533',4903685,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257534',4903686,'3002','463',180621.10,181971.12,0.00,0.00,1350.02,854124.80,0.00,0.00,0.00),('1','198','1016','257534',4903687,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257534',4903688,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257534',4903689,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257534',4903690,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257534',4903691,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257534',4903692,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257534',4903693,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257535',4903694,'3002','463',181971.12,183680.65,0.00,0.00,1709.53,1069919.20,0.00,0.00,0.00),('1','198','1016','257535',4903695,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257535',4903696,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257535',4903697,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257535',4903698,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257535',4903699,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257535',4903700,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257535',4903701,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257536',4903702,'3002','463',183680.65,184952.03,0.00,0.00,1271.38,808384.00,0.00,0.00,0.00),('1','198','1017','257536',4903703,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257536',4903704,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257536',4903705,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257536',4903706,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257536',4903707,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257536',4903708,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257536',4903709,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257537',4903710,'3002','463',184952.03,186012.56,0.00,0.00,1060.53,673870.56,0.00,0.00,0.00),('1','198','1016','257537',4903711,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257537',4903712,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257537',4903713,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257537',4903714,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257537',4903715,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257537',4903716,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257537',4903717,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257538',4903718,'3002','463',186012.56,187930.13,0.00,0.00,1917.57,1211442.80,0.00,0.00,0.00),('1','198','1017','257538',4903719,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257538',4903720,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257538',4903721,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257538',4903722,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257538',4903723,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257538',4903724,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257538',4903725,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257539',4903726,'3002','463',187930.13,189586.24,0.00,0.00,1656.11,1045534.40,0.00,0.00,0.00),('1','198','1017','257539',4903727,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257539',4903728,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257539',4903729,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257539',4903730,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257539',4903731,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257539',4903732,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257539',4903733,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257540',4903734,'3002','463',189586.24,191792.95,0.00,0.00,2206.71,1385995.20,0.00,0.00,0.00),('1','198','1016','257540',4903735,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257540',4903736,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257540',4903737,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257540',4903738,'3003','463',170214.37,170214.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257540',4903739,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257540',4903740,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257540',4903741,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257541',4903742,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257541',4903743,'3003','463',170214.37,171876.64,0.00,0.00,1662.27,1044189.12,0.00,0.00,0.00),('1','198','1017','257541',4903744,'3004','463',18.57,18.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257541',4903745,'3005','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257541',4903746,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257541',4903747,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257541',4903748,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257541',4903749,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257542',4903750,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257542',4903751,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257542',4903752,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257542',4903753,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257542',4903754,'3003','463',171876.64,173078.04,0.00,0.00,1201.40,814797.40,0.00,0.00,0.00),('1','198','1017','257542',4903755,'3004','463',18.57,24.45,0.00,0.00,5.88,3998.40,0.00,0.00,0.00),('1','198','1017','257542',4903756,'3005','463',0.00,10.88,0.00,0.00,10.88,7398.40,0.00,0.00,0.00),('1','198','1017','257542',4903757,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257543',4903758,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257543',4903759,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257543',4903760,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257543',4903761,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257543',4903762,'3003','463',173078.04,174707.65,0.00,0.00,1629.61,1097548.00,0.00,0.00,0.00),('1','198','1017','257543',4903763,'3004','463',24.45,36.95,0.00,0.00,12.50,8500.00,0.00,0.00,0.00),('1','198','1017','257543',4903764,'3005','463',10.88,10.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257543',4903765,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257544',4903766,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257544',4903767,'3003','463',174707.65,176212.65,0.00,0.00,1505.00,1013496.06,0.00,0.00,0.00),('1','198','1017','257544',4903768,'3004','463',36.95,42.89,0.00,0.00,5.94,4039.20,0.00,0.00,0.00),('1','198','1017','257544',4903769,'3005','463',10.88,10.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257544',4903770,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257544',4903771,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257544',4903772,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257544',4903773,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257545',4903774,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257545',4903775,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257545',4903776,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257545',4903777,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257545',4903778,'3003','463',176212.65,177709.45,0.00,0.00,1496.80,1003011.22,0.00,0.00,0.00),('1','198','1017','257545',4903779,'3004','463',42.89,55.39,0.00,0.00,12.50,8500.00,0.00,0.00,0.00),('1','198','1017','257545',4903780,'3005','463',10.88,10.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257545',4903781,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257546',4903782,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257546',4903783,'3003','463',177709.45,180586.77,0.00,0.00,2877.32,1816067.84,0.00,0.00,0.00),('1','198','1017','257546',4903784,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257546',4903785,'3005','463',10.88,10.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257546',4903786,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257546',4903787,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257546',4903788,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257546',4903789,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257547',4903790,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257547',4903791,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257547',4903792,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257547',4903793,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257547',4903794,'3003','463',180586.77,184342.24,0.00,0.00,3755.47,2385586.00,0.00,0.00,0.00),('1','198','1017','257547',4903795,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257547',4903796,'3005','463',10.88,16.35,0.00,0.00,5.47,3500.80,0.00,0.00,0.00),('1','198','1017','257547',4903797,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257548',4903798,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257548',4903799,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257548',4903800,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257548',4903801,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257548',4903802,'3003','463',184342.24,190113.45,0.00,0.00,5771.21,3665887.28,0.00,0.00,0.00),('1','198','1017','257548',4903803,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257548',4903804,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257548',4903805,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257549',4903806,'3002','463',191792.95,191792.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257549',4903807,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257549',4903808,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257549',4903809,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257549',4903810,'3003','463',190113.45,193785.58,0.00,0.00,3672.13,2271376.96,0.00,0.00,0.00),('1','198','1017','257549',4903811,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257549',4903812,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257549',4903813,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257550',4903814,'3002','463',191792.95,191828.89,0.00,0.00,35.94,23001.60,0.00,0.00,0.00),('1','198','1016','257550',4903815,'3007','463',5.34,5.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257550',4903816,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257550',4903817,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257550',4903818,'3003','463',193785.58,194765.52,0.00,0.00,979.94,607661.60,0.00,0.00,0.00),('1','198','1017','257550',4903819,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257550',4903820,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257550',4903821,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257551',4903822,'3002','463',191828.89,195509.45,0.00,0.00,3680.56,2307932.80,0.00,0.00,0.00),('1','198','1017','257551',4903823,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257551',4903824,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257551',4903825,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257551',4903826,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257551',4903827,'3007','463',5.34,17.84,0.00,0.00,12.50,8000.00,0.00,0.00,0.00),('1','198','1016','257551',4903828,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257551',4903829,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257552',4903830,'3002','463',195509.45,200488.97,0.00,0.00,4979.52,3101654.40,0.00,0.00,0.00),('1','198','1017','257552',4903831,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257552',4903832,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257552',4903833,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257552',4903834,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257552',4903835,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257552',4903836,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257552',4903837,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257553',4903838,'3002','463',200488.97,202708.06,0.00,0.00,2219.09,1390037.60,0.00,0.00,0.00),('1','198','1016','257553',4903839,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257553',4903840,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257553',4903841,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257553',4903842,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257553',4903843,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257553',4903844,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257553',4903845,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257554',4903846,'3002','463',202708.06,205805.41,0.00,0.00,3097.35,1934945.76,0.00,0.00,0.00),('1','198','1016','257554',4903847,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257554',4903848,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257554',4903849,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257554',4903850,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257554',4903851,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257554',4903852,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257554',4903853,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257555',4903854,'3002','463',205805.41,208566.53,0.00,0.00,2761.12,1724036.80,0.00,0.00,0.00),('1','198','1016','257555',4903855,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257555',4903856,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257555',4903857,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257555',4903858,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257555',4903859,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257555',4903860,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257555',4903861,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257556',4903862,'3002','463',208566.53,212219.91,0.00,0.00,3653.38,2270490.88,0.00,0.00,0.00),('1','198','1016','257556',4903863,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257556',4903864,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257556',4903865,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257556',4903866,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257556',4903867,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257556',4903868,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257556',4903869,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257557',4903870,'3002','463',212219.91,215293.75,0.00,0.00,3073.84,1924274.32,0.00,0.00,0.00),('1','198','1016','257557',4903871,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257557',4903872,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257557',4903873,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257557',4903874,'3003','463',194765.52,194765.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257557',4903875,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257557',4903876,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257557',4903877,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257558',4903878,'3002','463',215293.75,216137.07,0.00,0.00,843.32,529032.80,0.00,0.00,0.00),('1','198','1016','257558',4903879,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257558',4903880,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257558',4903881,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257558',4903882,'3003','463',194765.52,194811.17,0.00,0.00,45.65,29216.00,0.00,0.00,0.00),('1','198','1017','257558',4903883,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257558',4903884,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257558',4903885,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257559',4903886,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257559',4903887,'3003','463',194811.17,195972.81,0.00,0.00,1161.64,725189.92,0.00,0.00,0.00),('1','198','1017','257559',4903888,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257559',4903889,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257559',4903890,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257559',4903891,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257559',4903892,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257559',4903893,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257560',4903894,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257560',4903895,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257560',4903896,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257560',4903897,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257560',4903898,'3003','463',195972.81,198015.70,0.00,0.00,2042.89,1280404.24,0.00,0.00,0.00),('1','198','1017','257560',4903899,'3004','463',55.39,55.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257560',4903900,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257560',4903901,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257561',4903902,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257561',4903903,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257561',4903904,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257561',4903905,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257561',4903906,'3003','463',198015.70,199712.50,0.00,0.00,1696.80,1066329.60,0.00,0.00,0.00),('1','198','1017','257561',4903907,'3004','463',55.39,61.39,0.00,0.00,6.00,3840.00,0.00,0.00,0.00),('1','198','1017','257561',4903908,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257561',4903909,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257562',4903910,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257562',4903911,'3003','463',199712.50,201725.67,0.00,0.00,2013.17,1259183.60,0.00,0.00,0.00),('1','198','1017','257562',4903912,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257562',4903913,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257562',4903914,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257562',4903915,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257562',4903916,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257562',4903917,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257563',4903918,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257563',4903919,'3003','463',201725.67,204382.75,0.00,0.00,2657.08,1665107.68,0.00,0.00,0.00),('1','198','1017','257563',4903920,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257563',4903921,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257563',4903922,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257563',4903923,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257563',4903924,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257563',4903925,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257564',4903926,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257564',4903927,'3003','463',204382.75,206381.87,0.00,0.00,1999.12,1256792.80,0.00,0.00,0.00),('1','198','1017','257564',4903928,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257564',4903929,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257564',4903930,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257564',4903931,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257564',4903932,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257564',4903933,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257565',4903934,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257565',4903935,'3003','463',206381.87,207499.33,0.00,0.00,1117.46,708614.48,0.00,0.00,0.00),('1','198','1017','257565',4903936,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257565',4903937,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257565',4903938,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257565',4903939,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257565',4903940,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257565',4903941,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257566',4903942,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257566',4903943,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257566',4903944,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257566',4903945,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257566',4903946,'3003','463',207499.33,208744.07,0.00,0.00,1244.74,788101.60,0.00,0.00,0.00),('1','198','1017','257566',4903947,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257566',4903948,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257566',4903949,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257567',4903950,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257567',4903951,'3003','463',208744.07,210506.93,0.00,0.00,1762.86,1106823.96,0.00,0.00,0.00),('1','198','1017','257567',4903952,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257567',4903953,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257567',4903954,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257567',4903955,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257567',4903956,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257567',4903957,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257568',4903958,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257568',4903959,'3003','463',210506.93,211719.13,0.00,0.00,1212.20,765591.20,0.00,0.00,0.00),('1','198','1017','257568',4903960,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257568',4903961,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257568',4903962,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257568',4903963,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257568',4903964,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257568',4903965,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257569',4903966,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257569',4903967,'3003','463',211719.13,213200.25,0.00,0.00,1481.12,931177.56,0.00,0.00,0.00),('1','198','1017','257569',4903968,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257569',4903969,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257569',4903970,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257569',4903971,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257569',4903972,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257569',4903973,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257570',4903974,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257570',4903975,'3003','463',213200.25,214443.45,0.00,0.00,1243.20,782128.20,0.00,0.00,0.00),('1','198','1017','257570',4903976,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257570',4903977,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257570',4903978,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257570',4903979,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257570',4903980,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257570',4903981,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257571',4903982,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257571',4903983,'3003','463',214443.45,216255.07,0.00,0.00,1811.62,1134524.32,0.00,0.00,0.00),('1','198','1017','257571',4903984,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257571',4903985,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257571',4903986,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257571',4903987,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257571',4903988,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257571',4903989,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257572',4903990,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257572',4903991,'3003','463',216255.07,217862.19,0.00,0.00,1607.12,1004899.24,0.00,0.00,0.00),('1','198','1017','257572',4903992,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257572',4903993,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257572',4903994,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257572',4903995,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257572',4903996,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257572',4903997,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257573',4903998,'3002','463',216137.07,216137.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257573',4903999,'3003','463',217862.19,219106.05,0.00,0.00,1243.86,769553.00,0.00,0.00,0.00),('1','198','1017','257573',4904000,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257573',4904001,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257573',4904002,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257573',4904003,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257573',4904004,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257573',4904005,'3009','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257574',4904006,'3002','463',216137.07,217130.16,0.00,0.00,993.09,623080.24,0.00,0.00,0.00),('1','198','1017','257574',4904007,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257574',4904008,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257574',4904009,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257574',4904010,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257574',4904011,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257574',4904012,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257574',4904013,'3009','463',0.00,12.50,0.00,0.00,12.50,7950.00,0.00,0.00,0.00),('1','198','1016','257575',4904014,'3002','463',217130.16,218859.54,0.00,0.00,1729.38,1085970.68,0.00,0.00,0.00),('1','198','1017','257575',4904015,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257575',4904016,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257575',4904017,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257575',4904018,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257575',4904019,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257575',4904020,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257575',4904021,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257576',4904022,'3002','463',218859.54,221327.01,0.00,0.00,2467.47,1535339.62,0.00,0.00,0.00),('1','198','1017','257576',4904023,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257576',4904024,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257576',4904025,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257576',4904026,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257576',4904027,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257576',4904028,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257576',4904029,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257577',4904030,'3002','463',221327.01,222515.23,0.00,0.00,1188.22,750183.28,0.00,0.00,0.00),('1','198','1017','257577',4904031,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257577',4904032,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257577',4904033,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257577',4904034,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257577',4904035,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257577',4904036,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257577',4904037,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257578',4904038,'3002','463',222515.23,224184.49,0.00,0.00,1669.26,1047986.70,0.00,0.00,0.00),('1','198','1016','257578',4904039,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257578',4904040,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257578',4904041,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257578',4904042,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257578',4904043,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257578',4904044,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257578',4904045,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257579',4904046,'3002','463',224184.49,226264.12,0.00,0.00,2079.63,1301652.28,0.00,0.00,0.00),('1','198','1017','257579',4904047,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257579',4904048,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257579',4904049,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257579',4904050,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257579',4904051,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257579',4904052,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257579',4904053,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257580',4904054,'3002','463',226264.12,228343.63,0.00,0.00,2079.51,1312475.64,0.00,0.00,0.00),('1','198','1016','257580',4904055,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257580',4904056,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257580',4904057,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257580',4904058,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257580',4904059,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257580',4904060,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257580',4904061,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257581',4904062,'3002','463',228343.63,230972.59,0.00,0.00,2628.96,1651415.56,0.00,0.00,0.00),('1','198','1016','257581',4904063,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257581',4904064,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257581',4904065,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257581',4904066,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257581',4904067,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257581',4904068,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257581',4904069,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257582',4904070,'3002','463',230972.59,233217.35,0.00,0.00,2244.76,1404725.72,0.00,0.00,0.00),('1','198','1017','257582',4904071,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257582',4904072,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257582',4904073,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257582',4904074,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257582',4904075,'3007','463',17.84,17.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257582',4904076,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257582',4904077,'3009','463',12.50,12.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257583',4904078,'3002','463',233217.35,234747.67,0.00,0.00,1530.32,956395.00,0.00,0.00,0.00),('1','198','1016','257583',4904079,'3007','463',17.84,23.84,0.00,0.00,6.00,3816.00,0.00,0.00,0.00),('1','198','1016','257583',4904080,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257583',4904081,'3009','463',12.50,25.00,0.00,0.00,12.50,7950.00,0.00,0.00,0.00),('1','198','1017','257583',4904082,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257583',4904083,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257583',4904084,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257583',4904085,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257584',4904086,'3002','463',234747.67,235900.59,0.00,0.00,1152.92,727669.12,0.00,0.00,0.00),('1','198','1016','257584',4904087,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257584',4904088,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257584',4904089,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257584',4904090,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257584',4904091,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257584',4904092,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257584',4904093,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257585',4904094,'3002','463',235900.59,237492.61,0.00,0.00,1592.02,1003515.72,0.00,0.00,0.00),('1','198','1017','257585',4904095,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257585',4904096,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257585',4904097,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257585',4904098,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257585',4904099,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257585',4904100,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257585',4904101,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257586',4904102,'3002','463',237492.61,239828.75,0.00,0.00,2336.14,1462252.52,0.00,0.00,0.00),('1','198','1016','257586',4904103,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257586',4904104,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257586',4904105,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257586',4904106,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257586',4904107,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257586',4904108,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257586',4904109,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257587',4904110,'3002','463',239828.75,240446.58,0.00,0.00,617.83,392939.88,0.00,0.00,0.00),('1','198','1017','257587',4904111,'3003','463',219106.05,219106.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257587',4904112,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257587',4904113,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257587',4904114,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257587',4904115,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257587',4904116,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257587',4904117,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257588',4904118,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257588',4904119,'3003','463',219106.05,220067.32,0.00,0.00,961.27,607066.72,0.00,0.00,0.00),('1','198','1017','257588',4904120,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257588',4904121,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257588',4904122,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257588',4904123,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257588',4904124,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257588',4904125,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257589',4904126,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257589',4904127,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257589',4904128,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257589',4904129,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257589',4904130,'3003','463',220067.32,221390.33,0.00,0.00,1323.01,834416.36,0.00,0.00,0.00),('1','198','1017','257589',4904131,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257589',4904132,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257589',4904133,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257590',4904134,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257590',4904135,'3003','463',221390.33,224004.34,0.00,0.00,2614.01,1613742.20,0.00,0.00,0.00),('1','198','1017','257590',4904136,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257590',4904137,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257590',4904138,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257590',4904139,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257590',4904140,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257590',4904141,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257591',4904142,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257591',4904143,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257591',4904144,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257591',4904145,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257591',4904146,'3003','463',224004.34,225979.36,0.00,0.00,1975.02,1222254.96,0.00,0.00,0.00),('1','198','1017','257591',4904147,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257591',4904148,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257591',4904149,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257592',4904150,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257592',4904151,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257592',4904152,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257592',4904153,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257592',4904154,'3003','463',225979.36,228375.15,0.00,0.00,2395.79,1477196.12,0.00,0.00,0.00),('1','198','1017','257592',4904155,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257592',4904156,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257592',4904157,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257593',4904158,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257593',4904159,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257593',4904160,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257593',4904161,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257593',4904162,'3003','463',228375.15,229743.44,0.00,0.00,1368.29,848566.52,0.00,0.00,0.00),('1','198','1017','257593',4904163,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257593',4904164,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257593',4904165,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257594',4904166,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257594',4904167,'3003','463',229743.44,231199.35,0.00,0.00,1455.91,905897.08,0.00,0.00,0.00),('1','198','1017','257594',4904168,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257594',4904169,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257594',4904170,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257594',4904171,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257594',4904172,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257594',4904173,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257595',4904174,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257595',4904175,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257595',4904176,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257595',4904177,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257595',4904178,'3003','463',231199.35,232469.44,0.00,0.00,1270.09,790621.00,0.00,0.00,0.00),('1','198','1017','257595',4904179,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257595',4904180,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257595',4904181,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257596',4904182,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257596',4904183,'3003','463',232469.44,233340.34,0.00,0.00,870.90,597757.80,0.00,0.00,0.00),('1','198','1017','257596',4904184,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257596',4904185,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257596',4904186,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257596',4904187,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257596',4904188,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257596',4904189,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257597',4904190,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257597',4904191,'3003','463',233340.34,234589.41,0.00,0.00,1249.07,855651.12,0.00,0.00,0.00),('1','198','1017','257597',4904192,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257597',4904193,'3005','463',16.35,16.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257597',4904194,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257597',4904195,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257597',4904196,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257597',4904197,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257598',4904198,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257598',4904199,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257598',4904200,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257598',4904201,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257598',4904202,'3003','463',234589.41,235599.27,0.00,0.00,1009.86,699910.16,0.00,0.00,0.00),('1','198','1017','257598',4904203,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257598',4904204,'3005','463',16.35,18.51,0.00,0.00,2.16,1503.36,0.00,0.00,0.00),('1','198','1017','257598',4904205,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257599',4904206,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257599',4904207,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257599',4904208,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257599',4904209,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257599',4904210,'3003','463',235599.27,236766.84,0.00,0.00,1167.57,800114.24,0.00,0.00,0.00),('1','198','1017','257599',4904211,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257599',4904212,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257599',4904213,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257600',4904214,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257600',4904215,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257600',4904216,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257600',4904217,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257600',4904218,'3003','463',236766.84,237877.42,0.00,0.00,1110.58,766547.16,0.00,0.00,0.00),('1','198','1017','257600',4904219,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257600',4904220,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257600',4904221,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257601',4904222,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257601',4904223,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257601',4904224,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257601',4904225,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257601',4904226,'3003','463',237877.42,239007.99,0.00,0.00,1130.57,704009.96,0.00,0.00,0.00),('1','198','1017','257601',4904227,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257601',4904228,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257601',4904229,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257602',4904230,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257602',4904231,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257602',4904232,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257602',4904233,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257602',4904234,'3003','463',239007.99,240442.66,0.00,0.00,1434.67,888952.60,0.00,0.00,0.00),('1','198','1017','257602',4904235,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257602',4904236,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257602',4904237,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257603',4904238,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257603',4904239,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257603',4904240,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257603',4904241,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257603',4904242,'3003','463',240442.66,241395.97,0.00,0.00,953.31,592692.12,0.00,0.00,0.00),('1','198','1017','257603',4904243,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257603',4904244,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257603',4904245,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257604',4904246,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257604',4904247,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257604',4904248,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257604',4904249,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257604',4904250,'3003','463',241395.97,243041.76,0.00,0.00,1645.79,1010612.12,0.00,0.00,0.00),('1','198','1017','257604',4904251,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257604',4904252,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257604',4904253,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257605',4904254,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257605',4904255,'3003','463',243041.76,243541.78,0.00,0.00,500.02,309564.64,0.00,0.00,0.00),('1','198','1017','257605',4904256,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257605',4904257,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257605',4904258,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257605',4904259,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257605',4904260,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257605',4904261,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257606',4904262,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257606',4904263,'3003','463',243541.78,244871.83,0.00,0.00,1330.05,824531.40,0.00,0.00,0.00),('1','198','1017','257606',4904264,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257606',4904265,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257606',4904266,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257606',4904267,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257606',4904268,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257606',4904269,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257607',4904270,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257607',4904271,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257607',4904272,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257607',4904273,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257607',4904274,'3003','463',244871.83,244917.83,0.00,0.00,46.00,28888.00,0.00,0.00,0.00),('1','198','1017','257607',4904275,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257607',4904276,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257607',4904277,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257608',4904278,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257608',4904279,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257608',4904280,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257608',4904281,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257608',4904282,'3003','463',244917.83,245022.82,0.00,0.00,104.99,66462.56,0.00,0.00,0.00),('1','198','1017','257608',4904283,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257608',4904284,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257608',4904285,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257609',4904286,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257609',4904287,'3003','463',245022.82,245857.25,0.00,0.00,834.43,574143.66,0.00,0.00,0.00),('1','198','1017','257609',4904288,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257609',4904289,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257609',4904290,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257609',4904291,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257609',4904292,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257609',4904293,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257610',4904294,'3002','463',240446.58,240446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257610',4904295,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257610',4904296,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257610',4904297,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257610',4904298,'3003','463',245857.25,246952.54,0.00,0.00,1095.29,752045.10,0.00,0.00,0.00),('1','198','1017','257610',4904299,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257610',4904300,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257610',4904301,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257611',4904302,'3002','463',240446.58,241540.39,0.00,0.00,1093.81,750335.16,0.00,0.00,0.00),('1','198','1016','257611',4904303,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257611',4904304,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257611',4904305,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257611',4904306,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257611',4904307,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257611',4904308,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257611',4904309,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257612',4904310,'3002','463',241540.39,242702.50,0.00,0.00,1162.11,800436.56,0.00,0.00,0.00),('1','198','1016','257612',4904311,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257612',4904312,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257612',4904313,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257612',4904314,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257612',4904315,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257612',4904316,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257612',4904317,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257613',4904318,'3002','463',242702.50,243890.63,0.00,0.00,1188.13,815341.84,0.00,0.00,0.00),('1','198','1016','257613',4904319,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257613',4904320,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257613',4904321,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257613',4904322,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257613',4904323,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257613',4904324,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257613',4904325,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257614',4904326,'3002','463',243890.63,245040.94,0.00,0.00,1150.31,789543.92,0.00,0.00,0.00),('1','198','1016','257614',4904327,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257614',4904328,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257614',4904329,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257614',4904330,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257614',4904331,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257614',4904332,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257614',4904333,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257615',4904334,'3002','463',245040.94,246163.48,0.00,0.00,1122.54,762904.20,0.00,0.00,0.00),('1','198','1016','257615',4904335,'3007','463',23.84,23.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257615',4904336,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257615',4904337,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257615',4904338,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257615',4904339,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257615',4904340,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257615',4904341,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257616',4904342,'3002','463',246163.48,246893.75,0.00,0.00,730.27,493820.60,0.00,0.00,0.00),('1','198','1016','257616',4904343,'3007','463',23.84,25.31,0.00,0.00,1.47,999.60,0.00,0.00,0.00),('1','198','1016','257616',4904344,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257616',4904345,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257616',4904346,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257616',4904347,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257616',4904348,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257616',4904349,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257617',4904350,'3002','463',246893.75,248085.08,0.00,0.00,1191.33,807386.40,0.00,0.00,0.00),('1','198','1016','257617',4904351,'3007','463',25.31,25.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257617',4904352,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257617',4904353,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257617',4904354,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257617',4904355,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257617',4904356,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257617',4904357,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257618',4904358,'3002','463',248085.08,249617.07,0.00,0.00,1531.99,1037270.84,0.00,0.00,0.00),('1','198','1016','257618',4904359,'3007','463',25.31,25.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257618',4904360,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257618',4904361,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257618',4904362,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257618',4904363,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257618',4904364,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257618',4904365,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257619',4904366,'3002','463',249617.07,250996.03,0.00,0.00,1378.96,936998.72,0.00,0.00,0.00),('1','198','1016','257619',4904367,'3007','463',25.31,28.31,0.00,0.00,3.00,2040.00,0.00,0.00,0.00),('1','198','1016','257619',4904368,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257619',4904369,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257619',4904370,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257619',4904371,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257619',4904372,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257619',4904373,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257620',4904374,'3002','463',250996.03,252095.44,0.00,0.00,1099.41,746257.08,0.00,0.00,0.00),('1','198','1017','257620',4904375,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257620',4904376,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257620',4904377,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257620',4904378,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257620',4904379,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257620',4904380,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257620',4904381,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257621',4904382,'3002','463',252095.44,253527.30,0.00,0.00,1431.86,969299.80,0.00,0.00,0.00),('1','198','1016','257621',4904383,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257621',4904384,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257621',4904385,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257621',4904386,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257621',4904387,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257621',4904388,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257621',4904389,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257622',4904390,'3002','463',253527.30,254616.93,0.00,0.00,1089.63,738707.04,0.00,0.00,0.00),('1','198','1017','257622',4904391,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257622',4904392,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257622',4904393,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257622',4904394,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257622',4904395,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257622',4904396,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257622',4904397,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257623',4904398,'3002','463',254616.93,255962.62,0.00,0.00,1345.69,910685.66,0.00,0.00,0.00),('1','198','1016','257623',4904399,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257623',4904400,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257623',4904401,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257623',4904402,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257623',4904403,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257623',4904404,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257623',4904405,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257624',4904406,'3002','463',255962.62,257280.69,0.00,0.00,1318.07,892216.36,0.00,0.00,0.00),('1','198','1016','257624',4904407,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257624',4904408,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257624',4904409,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257624',4904410,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257624',4904411,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257624',4904412,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257624',4904413,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257625',4904414,'3002','463',257280.69,258203.10,0.00,0.00,922.41,660910.40,0.00,0.00,0.00),('1','198','1017','257625',4904415,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257625',4904416,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257625',4904417,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257625',4904418,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257625',4904419,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257625',4904420,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257625',4904421,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257626',4904422,'3002','463',258203.10,258837.61,0.00,0.00,634.51,455087.20,0.00,0.00,0.00),('1','198','1016','257626',4904423,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257626',4904424,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257626',4904425,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257626',4904426,'3003','463',246952.54,246952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257626',4904427,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257626',4904428,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257626',4904429,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257627',4904430,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257627',4904431,'3003','463',246952.54,247736.21,0.00,0.00,783.67,563716.80,0.00,0.00,0.00),('1','198','1017','257627',4904432,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257627',4904433,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257627',4904434,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257627',4904435,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257627',4904436,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257627',4904437,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257628',4904438,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257628',4904439,'3003','463',247736.21,249173.54,0.00,0.00,1437.33,1024844.80,0.00,0.00,0.00),('1','198','1017','257628',4904440,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257628',4904441,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257628',4904442,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257628',4904443,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257628',4904444,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257628',4904445,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257629',4904446,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257629',4904447,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257629',4904448,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257629',4904449,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257629',4904450,'3003','463',249173.54,250390.52,0.00,0.00,1216.98,873607.00,0.00,0.00,0.00),('1','198','1017','257629',4904451,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257629',4904452,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257629',4904453,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257630',4904454,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257630',4904455,'3003','463',250390.52,251543.36,0.00,0.00,1152.84,827954.80,0.00,0.00,0.00),('1','198','1017','257630',4904456,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257630',4904457,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257630',4904458,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257630',4904459,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257630',4904460,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257630',4904461,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257631',4904462,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257631',4904463,'3003','463',251543.36,252714.29,0.00,0.00,1170.93,839599.60,0.00,0.00,0.00),('1','198','1017','257631',4904464,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257631',4904465,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257631',4904466,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257631',4904467,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257631',4904468,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257631',4904469,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257632',4904470,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257632',4904471,'3003','463',252714.29,254136.78,0.00,0.00,1422.49,1018995.80,0.00,0.00,0.00),('1','198','1017','257632',4904472,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257632',4904473,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257632',4904474,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257632',4904475,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257632',4904476,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257632',4904477,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257633',4904478,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257633',4904479,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257633',4904480,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257633',4904481,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257633',4904482,'3003','463',254136.78,255240.41,0.00,0.00,1103.63,791713.60,0.00,0.00,0.00),('1','198','1017','257633',4904483,'3004','463',61.39,61.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257633',4904484,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257633',4904485,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257634',4904486,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257634',4904487,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257634',4904488,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257634',4904489,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257634',4904490,'3003','463',255240.41,256581.18,0.00,0.00,1340.77,963090.00,0.00,0.00,0.00),('1','198','1017','257634',4904491,'3004','463',61.39,67.50,0.00,0.00,6.11,4399.20,0.00,0.00,0.00),('1','198','1017','257634',4904492,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257634',4904493,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257635',4904494,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257635',4904495,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257635',4904496,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257635',4904497,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257635',4904498,'3003','463',256581.18,257361.83,0.00,0.00,780.65,560928.00,0.00,0.00,0.00),('1','198','1017','257635',4904499,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257635',4904500,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257635',4904501,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257636',4904502,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257636',4904503,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257636',4904504,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257636',4904505,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257636',4904506,'3003','463',257361.83,258927.45,0.00,0.00,1565.62,1120616.40,0.00,0.00,0.00),('1','198','1017','257636',4904507,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257636',4904508,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257636',4904509,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257637',4904510,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257637',4904511,'3003','463',258927.45,260224.32,0.00,0.00,1296.87,930316.40,0.00,0.00,0.00),('1','198','1017','257637',4904512,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257637',4904513,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257637',4904514,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257637',4904515,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257637',4904516,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257637',4904517,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257638',4904518,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257638',4904519,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257638',4904520,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257638',4904521,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257638',4904522,'3003','463',260224.32,261259.50,0.00,0.00,1035.18,744959.60,0.00,0.00,0.00),('1','198','1017','257638',4904523,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257638',4904524,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257638',4904525,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257639',4904526,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257639',4904527,'3003','463',261259.50,262332.17,0.00,0.00,1072.67,771702.40,0.00,0.00,0.00),('1','198','1017','257639',4904528,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257639',4904529,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257639',4904530,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257639',4904531,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257639',4904532,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257639',4904533,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257640',4904534,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257640',4904535,'3003','463',262332.17,263386.88,0.00,0.00,1054.71,757041.20,0.00,0.00,0.00),('1','198','1017','257640',4904536,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257640',4904537,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257640',4904538,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257640',4904539,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257640',4904540,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257640',4904541,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257641',4904542,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257641',4904543,'3003','463',263386.88,264600.28,0.00,0.00,1213.40,870568.00,0.00,0.00,0.00),('1','198','1017','257641',4904544,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257641',4904545,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257641',4904546,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257641',4904547,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257641',4904548,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257641',4904549,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257642',4904550,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257642',4904551,'3003','463',264600.28,265640.63,0.00,0.00,1040.35,747746.20,0.00,0.00,0.00),('1','198','1017','257642',4904552,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257642',4904553,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257642',4904554,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257642',4904555,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257642',4904556,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257642',4904557,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257643',4904558,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257643',4904559,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257643',4904560,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257643',4904561,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257643',4904562,'3003','463',265640.63,266914.48,0.00,0.00,1273.85,916972.00,0.00,0.00,0.00),('1','198','1017','257643',4904563,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257643',4904564,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257643',4904565,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257644',4904566,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257644',4904567,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257644',4904568,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257644',4904569,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257644',4904570,'3003','463',266914.48,268258.05,0.00,0.00,1343.57,964370.40,0.00,0.00,0.00),('1','198','1017','257644',4904571,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257644',4904572,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257644',4904573,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257645',4904574,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257645',4904575,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257645',4904576,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257645',4904577,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257645',4904578,'3003','463',268258.05,269286.27,0.00,0.00,1028.22,740068.40,0.00,0.00,0.00),('1','198','1017','257645',4904579,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257645',4904580,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257645',4904581,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257646',4904582,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257646',4904583,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257646',4904584,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257646',4904585,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257646',4904586,'3003','463',269286.27,270638.26,0.00,0.00,1351.99,972880.20,0.00,0.00,0.00),('1','198','1017','257646',4904587,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257646',4904588,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257646',4904589,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257647',4904590,'3002','463',258837.61,258837.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257647',4904591,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257647',4904592,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257647',4904593,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257647',4904594,'3003','463',270638.26,271246.45,0.00,0.00,608.19,437446.80,0.00,0.00,0.00),('1','198','1017','257647',4904595,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257647',4904596,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257647',4904597,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257648',4904598,'3002','463',258837.61,259456.67,0.00,0.00,619.06,444913.20,0.00,0.00,0.00),('1','198','1016','257648',4904599,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257648',4904600,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257648',4904601,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257648',4904602,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257648',4904603,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257648',4904604,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257648',4904605,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257649',4904606,'3002','463',259456.67,261572.18,0.00,0.00,2115.51,1516848.60,0.00,0.00,0.00),('1','198','1016','257649',4904607,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257649',4904608,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257649',4904609,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257649',4904610,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257649',4904611,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257649',4904612,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257649',4904613,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257650',4904614,'3002','463',261572.18,262680.45,0.00,0.00,1108.27,797204.40,0.00,0.00,0.00),('1','198','1016','257650',4904615,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257650',4904616,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257650',4904617,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257650',4904618,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257650',4904619,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257650',4904620,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257650',4904621,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257651',4904622,'3002','463',262680.45,264239.42,0.00,0.00,1558.97,1119892.80,0.00,0.00,0.00),('1','198','1016','257651',4904623,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257651',4904624,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257651',4904625,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257651',4904626,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257651',4904627,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257651',4904628,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257651',4904629,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257652',4904630,'3002','463',264239.42,265744.64,0.00,0.00,1505.22,1080388.40,0.00,0.00,0.00),('1','198','1016','257652',4904631,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257652',4904632,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257652',4904633,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257652',4904634,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257652',4904635,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257652',4904636,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257652',4904637,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257653',4904638,'3002','463',265744.64,267781.48,0.00,0.00,2036.84,1462034.80,0.00,0.00,0.00),('1','198','1017','257653',4904639,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257653',4904640,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257653',4904641,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257653',4904642,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257653',4904643,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257653',4904644,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257653',4904645,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257654',4904646,'3002','463',267781.48,270550.96,0.00,0.00,2769.48,1985758.40,0.00,0.00,0.00),('1','198','1016','257654',4904647,'3007','463',28.31,28.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257654',4904648,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257654',4904649,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257654',4904650,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257654',4904651,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257654',4904652,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257654',4904653,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257655',4904654,'3002','463',270550.96,274542.58,0.00,0.00,3991.62,2868669.20,0.00,0.00,0.00),('1','198','1016','257655',4904655,'3007','463',28.31,33.31,0.00,0.00,5.00,3600.00,0.00,0.00,0.00),('1','198','1016','257655',4904656,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257655',4904657,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257655',4904658,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257655',4904659,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257655',4904660,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257655',4904661,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257656',4904662,'3002','463',274542.58,276998.14,0.00,0.00,2455.56,1767383.20,0.00,0.00,0.00),('1','198','1017','257656',4904663,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257656',4904664,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257656',4904665,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257656',4904666,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257656',4904667,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257656',4904668,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257656',4904669,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257657',4904670,'3002','463',276998.14,280728.65,0.00,0.00,3730.51,2677124.40,0.00,0.00,0.00),('1','198','1016','257657',4904671,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257657',4904672,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257657',4904673,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257657',4904674,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257657',4904675,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257657',4904676,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257657',4904677,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257658',4904678,'3002','463',280728.65,283138.76,0.00,0.00,2410.11,1696179.20,0.00,0.00,0.00),('1','198','1017','257658',4904679,'3003','463',271246.45,271246.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257658',4904680,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257658',4904681,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257658',4904682,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257658',4904683,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257658',4904684,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257658',4904685,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257659',4904686,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257659',4904687,'3003','463',271246.45,272377.45,0.00,0.00,1131.00,799350.00,0.00,0.00,0.00),('1','198','1017','257659',4904688,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257659',4904689,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257659',4904690,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257659',4904691,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257659',4904692,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257659',4904693,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257660',4904694,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257660',4904695,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257660',4904696,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257660',4904697,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257660',4904698,'3003','463',272377.45,273470.37,0.00,0.00,1092.92,782852.40,0.00,0.00,0.00),('1','198','1017','257660',4904699,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257660',4904700,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257660',4904701,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257661',4904702,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257661',4904703,'3003','463',273470.37,274172.49,0.00,0.00,702.12,502730.60,0.00,0.00,0.00),('1','198','1017','257661',4904704,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257661',4904705,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257661',4904706,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257661',4904707,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257661',4904708,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257661',4904709,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257662',4904710,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257662',4904711,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257662',4904712,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257662',4904713,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257662',4904714,'3003','463',274172.49,275146.62,0.00,0.00,974.13,695003.60,0.00,0.00,0.00),('1','198','1017','257662',4904715,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257662',4904716,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257662',4904717,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257663',4904718,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257663',4904719,'3003','463',275146.62,276572.35,0.00,0.00,1425.73,1018267.40,0.00,0.00,0.00),('1','198','1017','257663',4904720,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257663',4904721,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257663',4904722,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257663',4904723,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257663',4904724,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257663',4904725,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257664',4904726,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257664',4904727,'3003','463',276572.35,278462.30,0.00,0.00,1889.95,1349072.60,0.00,0.00,0.00),('1','198','1017','257664',4904728,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257664',4904729,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257664',4904730,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257664',4904731,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257664',4904732,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257664',4904733,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257665',4904734,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257665',4904735,'3003','463',278462.30,279379.71,30.00,21600.00,887.41,636425.20,0.00,0.00,0.00),('1','198','1017','257665',4904736,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257665',4904737,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257665',4904738,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257665',4904739,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257665',4904740,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257665',4904741,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257666',4904742,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257666',4904743,'3003','463',279379.71,281357.20,0.00,0.00,1977.49,1417672.80,0.00,0.00,0.00),('1','198','1017','257666',4904744,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257666',4904745,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257666',4904746,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257666',4904747,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257666',4904748,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257666',4904749,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257667',4904750,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257667',4904751,'3003','463',281357.20,282854.59,0.00,0.00,1497.39,1074272.80,0.00,0.00,0.00),('1','198','1017','257667',4904752,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257667',4904753,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257667',4904754,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257667',4904755,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257667',4904756,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257667',4904757,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257668',4904758,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257668',4904759,'3003','463',282854.59,284932.69,0.00,0.00,2078.10,1481294.80,0.00,0.00,0.00),('1','198','1017','257668',4904760,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257668',4904761,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257668',4904762,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257668',4904763,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257668',4904764,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257668',4904765,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257669',4904766,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257669',4904767,'3003','463',284932.69,289841.63,0.00,0.00,4908.94,3464866.80,0.00,0.00,0.00),('1','198','1017','257669',4904768,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257669',4904769,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257669',4904770,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257669',4904771,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257669',4904772,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257669',4904773,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257670',4904774,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257670',4904775,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257670',4904776,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257670',4904777,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257670',4904778,'3003','463',289841.63,292757.48,0.00,0.00,2915.85,2071303.40,0.00,0.00,0.00),('1','198','1017','257670',4904779,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257670',4904780,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257670',4904781,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257671',4904782,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257671',4904783,'3003','463',292757.48,294979.16,0.00,0.00,2221.68,1583469.60,0.00,0.00,0.00),('1','198','1017','257671',4904784,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257671',4904785,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257671',4904786,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257671',4904787,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257671',4904788,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257671',4904789,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257672',4904790,'3002','463',283138.76,283138.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257672',4904791,'3003','463',294979.16,295284.04,0.00,0.00,304.88,219163.60,0.00,0.00,0.00),('1','198','1017','257672',4904792,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257672',4904793,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257672',4904794,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257672',4904795,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257672',4904796,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257672',4904797,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257673',4904798,'3002','463',283138.76,284067.23,0.00,0.00,928.47,662002.60,0.00,0.00,0.00),('1','198','1017','257673',4904799,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257673',4904800,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257673',4904801,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257673',4904802,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257673',4904803,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257673',4904804,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257673',4904805,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257674',4904806,'3002','463',284067.23,285628.76,0.00,0.00,1561.53,1109695.60,0.00,0.00,0.00),('1','198','1016','257674',4904807,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257674',4904808,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257674',4904809,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257674',4904810,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257674',4904811,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257674',4904812,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257674',4904813,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257675',4904814,'3002','463',285628.76,287096.60,0.00,0.00,1467.84,1052414.80,0.00,0.00,0.00),('1','198','1017','257675',4904815,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257675',4904816,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257675',4904817,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257675',4904818,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257675',4904819,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257675',4904820,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257675',4904821,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257676',4904822,'3002','463',287096.60,288513.60,0.00,0.00,1417.00,1016540.00,0.00,0.00,0.00),('1','198','1017','257676',4904823,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257676',4904824,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257676',4904825,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257676',4904826,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257676',4904827,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257676',4904828,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257676',4904829,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257677',4904830,'3002','463',288513.60,290042.46,0.00,0.00,1528.86,1098369.20,0.00,0.00,0.00),('1','198','1017','257677',4904831,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257677',4904832,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257677',4904833,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257677',4904834,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257677',4904835,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257677',4904836,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257677',4904837,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257678',4904838,'3002','463',290042.46,291812.86,0.00,0.00,1770.40,1264770.80,0.00,0.00,0.00),('1','198','1017','257678',4904839,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257678',4904840,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257678',4904841,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257678',4904842,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257678',4904843,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257678',4904844,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257678',4904845,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257679',4904846,'3002','463',291812.86,293481.39,0.00,0.00,1668.53,1193141.60,0.00,0.00,0.00),('1','198','1017','257679',4904847,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257679',4904848,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257679',4904849,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257679',4904850,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257679',4904851,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257679',4904852,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257679',4904853,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257680',4904854,'3002','463',293481.39,297545.09,0.00,0.00,4063.70,2873574.00,0.00,0.00,0.00),('1','198','1016','257680',4904855,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257680',4904856,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257680',4904857,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257680',4904858,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257680',4904859,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257680',4904860,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257680',4904861,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257681',4904862,'3002','463',297545.09,299383.60,0.00,0.00,1838.51,1316587.20,0.00,0.00,0.00),('1','198','1016','257681',4904863,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257681',4904864,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257681',4904865,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257681',4904866,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257681',4904867,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257681',4904868,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257681',4904869,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257682',4904870,'3002','463',299383.60,301099.94,0.00,0.00,1716.34,1229672.00,0.00,0.00,0.00),('1','198','1017','257682',4904871,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257682',4904872,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257682',4904873,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257682',4904874,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257682',4904875,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257682',4904876,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257682',4904877,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257683',4904878,'3002','463',301099.94,303065.90,0.00,0.00,1965.96,1406021.20,0.00,0.00,0.00),('1','198','1017','257683',4904879,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257683',4904880,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257683',4904881,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257683',4904882,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257683',4904883,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257683',4904884,'3008','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257683',4904885,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257684',4904886,'3002','463',303065.90,306250.61,0.00,0.00,3184.71,2272571.20,0.00,0.00,0.00),('1','198','1017','257684',4904887,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257684',4904888,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257684',4904889,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257684',4904890,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257684',4904891,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257684',4904892,'3008','463',0.00,1.00,0.00,0.00,1.00,720.00,0.00,0.00,0.00),('1','198','1016','257684',4904893,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257685',4904894,'3002','463',306250.61,306585.52,0.00,0.00,334.91,240628.40,0.00,0.00,0.00),('1','198','1017','257685',4904895,'3003','463',295284.04,295284.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257685',4904896,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257685',4904897,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257685',4904898,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257685',4904899,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257685',4904900,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257685',4904901,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257686',4904902,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257686',4904903,'3003','463',295284.04,297877.61,0.00,0.00,2593.57,1849886.20,0.00,0.00,0.00),('1','198','1017','257686',4904904,'3004','463',67.50,67.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257686',4904905,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257686',4904906,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257686',4904907,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257686',4904908,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257686',4904909,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257687',4904910,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257687',4904911,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257687',4904912,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257687',4904913,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257687',4904914,'3003','463',297877.61,301051.39,0.00,0.00,3173.78,2259093.20,0.00,0.00,0.00),('1','198','1017','257687',4904915,'3004','463',67.50,70.50,0.00,0.00,3.00,2160.00,0.00,0.00,0.00),('1','198','1017','257687',4904916,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257687',4904917,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257688',4904918,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257688',4904919,'3003','463',301051.39,304086.89,0.00,0.00,3035.50,2154900.60,0.00,0.00,0.00),('1','198','1017','257688',4904920,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257688',4904921,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257688',4904922,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257688',4904923,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257688',4904924,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257688',4904925,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257689',4904926,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257689',4904927,'3003','463',304086.89,309697.60,0.00,0.00,5610.71,3961687.00,0.00,0.00,0.00),('1','198','1017','257689',4904928,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257689',4904929,'3005','463',18.51,18.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257689',4904930,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257689',4904931,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257689',4904932,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257689',4904933,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257690',4904934,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257690',4904935,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257690',4904936,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257690',4904937,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257690',4904938,'3003','463',309697.60,311125.48,0.00,0.00,1427.88,1027363.60,0.00,0.00,0.00),('1','198','1017','257690',4904939,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257690',4904940,'3005','463',18.51,23.51,0.00,0.00,5.00,3600.00,0.00,0.00,0.00),('1','198','1017','257690',4904941,'3006','463',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257691',4904942,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257691',4904943,'3003','463',311125.48,313290.14,0.00,0.00,2164.66,1540380.60,0.00,0.00,0.00),('1','198','1017','257691',4904944,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257691',4904945,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257691',4904946,'3006','463',0.00,6.00,0.00,0.00,6.00,4320.00,0.00,0.00,0.00),('1','198','1016','257691',4904947,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257691',4904948,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257691',4904949,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257692',4904950,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257692',4904951,'3003','463',313290.14,315267.42,0.00,0.00,1977.28,1413003.00,0.00,0.00,0.00),('1','198','1017','257692',4904952,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257692',4904953,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257692',4904954,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257692',4904955,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257692',4904956,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257692',4904957,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257693',4904958,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257693',4904959,'3003','463',315267.42,317057.28,0.00,0.00,1789.86,1281499.20,0.00,0.00,0.00),('1','198','1017','257693',4904960,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257693',4904961,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257693',4904962,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257693',4904963,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257693',4904964,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257693',4904965,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257694',4904966,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257694',4904967,'3003','463',317057.28,319032.89,0.00,0.00,1975.61,1403387.20,0.00,0.00,0.00),('1','198','1017','257694',4904968,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257694',4904969,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257694',4904970,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257694',4904971,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257694',4904972,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257694',4904973,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257695',4904974,'3002','463',306585.52,306585.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257695',4904975,'3003','463',319032.89,319337.42,0.00,0.00,304.53,215581.60,0.00,0.00,0.00),('1','198','1017','257695',4904976,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257695',4904977,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257695',4904978,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257695',4904979,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257695',4904980,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257695',4904981,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257696',4904982,'3002','463',306585.52,307898.37,0.00,0.00,1312.85,940742.00,0.00,0.00,0.00),('1','198','1017','257696',4904983,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257696',4904984,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257696',4904985,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257696',4904986,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257696',4904987,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257696',4904988,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257696',4904989,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257697',4904990,'3002','463',307898.37,309597.74,0.00,0.00,1699.37,1214946.40,0.00,0.00,0.00),('1','198','1017','257697',4904991,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257697',4904992,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257697',4904993,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257697',4904994,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257697',4904995,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257697',4904996,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257697',4904997,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257698',4904998,'3002','463',309597.74,311205.55,0.00,0.00,1607.81,1150519.00,0.00,0.00,0.00),('1','198','1017','257698',4904999,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257698',4905000,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257698',4905001,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257698',4905002,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257698',4905003,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257698',4905004,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257698',4905005,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257699',4905006,'3002','463',311205.55,312957.95,0.00,0.00,1752.40,1251622.60,0.00,0.00,0.00),('1','198','1017','257699',4905007,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257699',4905008,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257699',4905009,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257699',4905010,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257699',4905011,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257699',4905012,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257699',4905013,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257700',4905014,'3002','463',312957.95,316758.57,0.00,0.00,3800.62,2679439.20,0.00,0.00,0.00),('1','198','1017','257700',4905015,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257700',4905016,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257700',4905017,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257700',4905018,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257700',4905019,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257700',4905020,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257700',4905021,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257701',4905022,'3002','463',316758.57,318428.69,0.00,0.00,1670.12,1194467.80,0.00,0.00,0.00),('1','198','1017','257701',4905023,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257701',4905024,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257701',4905025,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257701',4905026,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257701',4905027,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257701',4905028,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257701',4905029,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257702',4905030,'3002','463',318428.69,320686.37,0.00,0.00,2257.68,1603990.40,0.00,0.00,0.00),('1','198','1017','257702',4905031,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257702',4905032,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257702',4905033,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257702',4905034,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257702',4905035,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257702',4905036,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257702',4905037,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257703',4905038,'3002','463',320686.37,322776.76,0.00,0.00,2090.39,1483860.80,0.00,0.00,0.00),('1','198','1017','257703',4905039,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257703',4905040,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257703',4905041,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257703',4905042,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257703',4905043,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257703',4905044,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257703',4905045,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257704',4905046,'3002','463',322776.76,324914.42,0.00,0.00,2137.66,1522549.40,0.00,0.00,0.00),('1','198','1017','257704',4905047,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257704',4905048,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257704',4905049,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257704',4905050,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257704',4905051,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257704',4905052,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257704',4905053,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257705',4905054,'3002','463',324914.42,326735.05,0.00,0.00,1820.63,1297612.20,0.00,0.00,0.00),('1','198','1016','257705',4905055,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257705',4905056,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257705',4905057,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257705',4905058,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257705',4905059,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257705',4905060,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257705',4905061,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257706',4905062,'3002','463',326735.05,328375.66,0.00,0.00,1640.61,1169339.20,0.00,0.00,0.00),('1','198','1017','257706',4905063,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257706',4905064,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257706',4905065,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257706',4905066,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257706',4905067,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257706',4905068,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257706',4905069,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257707',4905070,'3002','463',328375.66,330765.23,0.00,0.00,2389.57,1687296.20,0.00,0.00,0.00),('1','198','1017','257707',4905071,'3003','463',319337.42,319337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257707',4905072,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257707',4905073,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257707',4905074,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257707',4905075,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257707',4905076,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257707',4905077,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257708',4905078,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257708',4905079,'3003','463',319337.42,320852.32,0.00,0.00,1514.90,1068533.60,0.00,0.00,0.00),('1','198','1017','257708',4905080,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257708',4905081,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257708',4905082,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257708',4905083,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257708',4905084,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257708',4905085,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257709',4905086,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257709',4905087,'3003','463',320852.32,322742.01,0.00,0.00,1889.69,1347736.80,0.00,0.00,0.00),('1','198','1017','257709',4905088,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257709',4905089,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257709',4905090,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257709',4905091,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257709',4905092,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257709',4905093,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257710',4905094,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257710',4905095,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257710',4905096,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257710',4905097,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257710',4905098,'3003','463',322742.01,327218.07,0.00,0.00,4476.06,3161633.20,0.00,0.00,0.00),('1','198','1017','257710',4905099,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257710',4905100,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257710',4905101,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257711',4905102,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257711',4905103,'3003','463',327218.07,328757.71,0.00,0.00,1539.64,1096669.40,0.00,0.00,0.00),('1','198','1017','257711',4905104,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257711',4905105,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257711',4905106,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257711',4905107,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257711',4905108,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257711',4905109,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257712',4905110,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257712',4905111,'3003','463',328757.71,331581.94,0.00,0.00,2824.23,2000535.60,0.00,0.00,0.00),('1','198','1017','257712',4905112,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257712',4905113,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257712',4905114,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257712',4905115,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257712',4905116,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257712',4905117,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257713',4905118,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257713',4905119,'3003','463',331581.94,334057.58,0.00,0.00,2475.64,1765279.80,0.00,0.00,0.00),('1','198','1017','257713',4905120,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257713',4905121,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257713',4905122,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257713',4905123,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257713',4905124,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257713',4905125,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257714',4905126,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257714',4905127,'3003','463',334057.58,336386.76,0.00,0.00,2329.18,1660019.60,0.00,0.00,0.00),('1','198','1017','257714',4905128,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257714',4905129,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257714',4905130,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257714',4905131,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257714',4905132,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257714',4905133,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257715',4905134,'3002','463',330765.23,330765.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257715',4905135,'3003','463',336386.76,336933.53,0.00,0.00,546.77,390224.40,0.00,0.00,0.00),('1','198','1017','257715',4905136,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257715',4905137,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257715',4905138,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257715',4905139,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257715',4905140,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257715',4905141,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257716',4905142,'3002','463',330765.23,333869.44,0.00,0.00,3104.21,2199318.40,0.00,0.00,0.00),('1','198','1017','257716',4905143,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257716',4905144,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257716',4905145,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257716',4905146,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257716',4905147,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257716',4905148,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257716',4905149,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257717',4905150,'3002','463',333869.44,337128.82,0.00,0.00,3259.38,2314783.60,0.00,0.00,0.00),('1','198','1017','257717',4905151,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257717',4905152,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257717',4905153,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257717',4905154,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257717',4905155,'3007','463',33.31,33.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257717',4905156,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257717',4905157,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257718',4905158,'3002','463',337128.82,343390.27,0.00,0.00,6261.45,4421961.20,0.00,0.00,0.00),('1','198','1017','257718',4905159,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257718',4905160,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257718',4905161,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257718',4905162,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257718',4905163,'3007','463',33.31,38.87,0.00,0.00,5.56,4003.20,0.00,0.00,0.00),('1','198','1016','257718',4905164,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257718',4905165,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257719',4905166,'3002','463',343390.27,347884.95,0.00,0.00,4494.68,3183579.60,0.00,0.00,0.00),('1','198','1017','257719',4905167,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257719',4905168,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257719',4905169,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257719',4905170,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257719',4905171,'3007','463',38.87,38.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257719',4905172,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257719',4905173,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257720',4905174,'3002','463',347884.95,351874.38,0.00,0.00,3989.43,2824725.80,0.00,0.00,0.00),('1','198','1016','257720',4905175,'3007','463',38.87,38.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257720',4905176,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257720',4905177,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257720',4905178,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257720',4905179,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257720',4905180,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257720',4905181,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257721',4905182,'3002','463',351874.38,356704.72,0.00,0.00,4830.34,3403508.40,0.00,0.00,0.00),('1','198','1016','257721',4905183,'3007','463',38.87,38.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257721',4905184,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257721',4905185,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257721',4905186,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257721',4905187,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257721',4905188,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257721',4905189,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257722',4905190,'3002','463',356704.72,363448.59,0.00,0.00,6743.87,4750967.40,0.00,0.00,0.00),('1','198','1017','257722',4905191,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257722',4905192,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257722',4905193,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257722',4905194,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257722',4905195,'3007','463',38.87,44.84,0.00,0.00,5.97,4298.40,0.00,0.00,0.00),('1','198','1016','257722',4905196,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257722',4905197,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257723',4905198,'3002','463',363448.59,368312.46,0.00,0.00,4863.87,3438516.40,0.00,0.00,0.00),('1','198','1017','257723',4905199,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257723',4905200,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257723',4905201,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257723',4905202,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257723',4905203,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257723',4905204,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257723',4905205,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257724',4905206,'3002','463',368312.46,372976.54,0.00,0.00,4664.08,3295589.40,0.00,0.00,0.00),('1','198','1017','257724',4905207,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257724',4905208,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257724',4905209,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257724',4905210,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257724',4905211,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257724',4905212,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257724',4905213,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257725',4905214,'3002','463',372976.54,376393.62,0.00,0.00,3417.08,2418727.60,0.00,0.00,0.00),('1','198','1017','257725',4905215,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257725',4905216,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257725',4905217,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257725',4905218,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257725',4905219,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257725',4905220,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257725',4905221,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257726',4905222,'3002','463',376393.62,380516.74,0.00,0.00,4123.12,2910444.60,0.00,0.00,0.00),('1','198','1017','257726',4905223,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257726',4905224,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257726',4905225,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257726',4905226,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257726',4905227,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257726',4905228,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257726',4905229,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257727',4905230,'3002','463',380516.74,381612.25,0.00,0.00,1095.51,767755.00,0.00,0.00,0.00),('1','198','1017','257727',4905231,'3003','463',336933.53,336933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257727',4905232,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257727',4905233,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257727',4905234,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257727',4905235,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257727',4905236,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257727',4905237,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257728',4905238,'3002','463',381612.25,381612.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257728',4905239,'3003','463',336933.53,341411.60,0.00,0.00,4478.07,3156979.00,0.00,0.00,0.00),('1','198','1017','257728',4905240,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257728',4905241,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257728',4905242,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257728',4905243,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257728',4905244,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257728',4905245,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257729',4905246,'3002','463',381612.25,381612.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257729',4905247,'3003','463',341411.60,346039.05,0.00,0.00,4627.45,3268758.40,0.00,0.00,0.00),('1','198','1017','257729',4905248,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257729',4905249,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257729',4905250,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257729',4905251,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257729',4905252,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257729',4905253,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257730',4905254,'3002','463',381612.25,381612.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257730',4905255,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257730',4905256,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257730',4905257,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257730',4905258,'3003','463',346039.05,347754.46,0.00,0.00,1715.41,1213054.60,0.00,0.00,0.00),('1','198','1017','257730',4905259,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257730',4905260,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257730',4905261,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257731',4905262,'3002','463',381612.25,382907.53,0.00,0.00,1295.28,914641.60,0.00,0.00,0.00),('1','198','1017','257731',4905263,'3003','463',347754.46,347759.46,0.00,0.00,5.00,3600.00,0.00,0.00,0.00),('1','198','1017','257731',4905264,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257731',4905265,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257731',4905266,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257731',4905267,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257731',4905268,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257731',4905269,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257732',4905270,'3002','463',382907.53,386949.16,0.00,0.00,4041.63,2855280.80,0.00,0.00,0.00),('1','198','1017','257732',4905271,'3003','463',347759.46,347933.53,0.00,0.00,174.07,123330.40,0.00,0.00,0.00),('1','198','1017','257732',4905272,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257732',4905273,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257732',4905274,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257732',4905275,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257732',4905276,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257732',4905277,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257733',4905278,'3002','463',386949.16,392165.17,0.00,0.00,5216.01,3673448.20,0.00,0.00,0.00),('1','198','1017','257733',4905279,'3003','463',347933.53,347933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257733',4905280,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257733',4905281,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257733',4905282,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257733',4905283,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257733',4905284,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257733',4905285,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257734',4905286,'3002','463',392165.17,393983.64,0.00,0.00,1818.47,1287608.80,0.00,0.00,0.00),('1','198','1017','257734',4905287,'3003','463',347933.53,347933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257734',4905288,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257734',4905289,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257734',4905290,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257734',4905291,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257734',4905292,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257734',4905293,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257735',4905294,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257735',4905295,'3003','463',347933.53,347933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257735',4905296,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257735',4905297,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257735',4905298,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257735',4905299,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257735',4905300,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257735',4905301,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257736',4905302,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257736',4905303,'3003','463',347933.53,350033.53,0.00,0.00,2100.00,1486483.00,0.00,0.00,0.00),('1','198','1017','257736',4905304,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257736',4905305,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257736',4905306,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257736',4905307,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257736',4905308,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257736',4905309,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257737',4905310,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257737',4905311,'3003','463',350033.53,353062.49,0.00,0.00,3028.96,2143961.20,0.00,0.00,0.00),('1','198','1017','257737',4905312,'3004','463',70.50,70.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257737',4905313,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257737',4905314,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257737',4905315,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257737',4905316,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257737',4905317,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257738',4905318,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257738',4905319,'3003','463',353062.49,355516.21,0.00,0.00,2453.72,1743108.40,0.00,0.00,0.00),('1','198','1017','257738',4905320,'3004','463',70.50,74.67,0.00,0.00,4.17,3002.40,0.00,0.00,0.00),('1','198','1017','257738',4905321,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257738',4905322,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257738',4905323,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257738',4905324,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257738',4905325,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257739',4905326,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257739',4905327,'3003','463',355516.21,357814.10,0.00,0.00,2297.89,1635700.20,0.00,0.00,0.00),('1','198','1017','257739',4905328,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257739',4905329,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257739',4905330,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257739',4905331,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257739',4905332,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257739',4905333,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257740',4905334,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257740',4905335,'3003','463',357814.10,359894.40,0.00,0.00,2080.30,1478790.80,0.00,0.00,0.00),('1','198','1017','257740',4905336,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257740',4905337,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257740',4905338,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257740',4905339,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257740',4905340,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257740',4905341,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257741',4905342,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257741',4905343,'3003','463',359894.40,360949.30,0.00,0.00,1054.90,748293.20,0.00,0.00,0.00),('1','198','1017','257741',4905344,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257741',4905345,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257741',4905346,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257741',4905347,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257741',4905348,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257741',4905349,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257742',4905350,'3002','463',393983.64,393983.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257742',4905351,'3003','463',360949.30,360949.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257742',4905352,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257742',4905353,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257742',4905354,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257742',4905355,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257742',4905356,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257742',4905357,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257743',4905358,'3002','463',393983.64,395480.19,0.00,0.00,1496.55,1062583.20,0.00,0.00,0.00),('1','198','1017','257743',4905359,'3003','463',360949.30,360949.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257743',4905360,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257743',4905361,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257743',4905362,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257743',4905363,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257743',4905364,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257743',4905365,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257744',4905366,'3002','463',395480.19,397860.31,0.00,0.00,2380.12,1688196.40,0.00,0.00,0.00),('1','198','1017','257744',4905367,'3003','463',360949.30,360949.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257744',4905368,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257744',4905369,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257744',4905370,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257744',4905371,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257744',4905372,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257744',4905373,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257745',4905374,'3002','463',397860.31,400007.76,0.00,0.00,2147.45,1531264.00,0.00,0.00,0.00),('1','198','1017','257745',4905375,'3003','463',360949.30,360949.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257745',4905376,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257745',4905377,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257745',4905378,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257745',4905379,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257745',4905380,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257745',4905381,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257746',4905382,'3002','463',400007.76,403510.19,0.00,0.00,3502.43,2476629.60,0.00,0.00,0.00),('1','198','1017','257746',4905383,'3003','463',360949.30,360949.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257746',4905384,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257746',4905385,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257746',4905386,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257746',4905387,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257746',4905388,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257746',4905389,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257747',4905390,'3002','463',403510.19,403844.45,0.00,0.00,334.26,237935.60,0.00,0.00,0.00),('1','198','1017','257747',4905391,'3003','463',360949.30,360949.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257747',4905392,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257747',4905393,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257747',4905394,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257747',4905395,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257747',4905396,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257747',4905397,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257748',4905398,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257748',4905399,'3003','463',360949.30,363544.09,0.00,0.00,2594.79,1838170.00,0.00,0.00,0.00),('1','198','1017','257748',4905400,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257748',4905401,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257748',4905402,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257748',4905403,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257748',4905404,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257748',4905405,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257749',4905406,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257749',4905407,'3003','463',363544.09,365766.63,0.00,0.00,2222.54,1579962.20,0.00,0.00,0.00),('1','198','1017','257749',4905408,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257749',4905409,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257749',4905410,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257749',4905411,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257749',4905412,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257749',4905413,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257750',4905414,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257750',4905415,'3003','463',365766.63,369781.24,0.00,0.00,4014.61,2841101.40,0.00,0.00,0.00),('1','198','1017','257750',4905416,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257750',4905417,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257750',4905418,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257750',4905419,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257750',4905420,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257750',4905421,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257751',4905422,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257751',4905423,'3003','463',369781.24,376098.26,0.00,0.00,6317.02,4450348.20,0.00,0.00,0.00),('1','198','1017','257751',4905424,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257751',4905425,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257751',4905426,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257751',4905427,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257751',4905428,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257751',4905429,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257752',4905430,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257752',4905431,'3003','463',376098.26,379790.24,0.00,0.00,3691.98,2618282.80,0.00,0.00,0.00),('1','198','1017','257752',4905432,'3004','463',74.67,74.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257752',4905433,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257752',4905434,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257752',4905435,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257752',4905436,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257752',4905437,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257753',4905438,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257753',4905439,'3003','463',379790.24,382106.72,0.00,0.00,2316.48,1653875.60,0.00,0.00,0.00),('1','198','1017','257753',4905440,'3004','463',74.67,99.67,0.00,0.00,25.00,18000.00,0.00,0.00,0.00),('1','198','1017','257753',4905441,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257753',4905442,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257753',4905443,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257753',4905444,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257753',4905445,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257754',4905446,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257754',4905447,'3003','463',382106.72,383862.81,0.00,0.00,1756.09,1253624.80,0.00,0.00,0.00),('1','198','1017','257754',4905448,'3004','463',99.67,99.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257754',4905449,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257754',4905450,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257754',4905451,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257754',4905452,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257754',4905453,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257755',4905454,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257755',4905455,'3003','463',383862.81,385555.91,0.00,0.00,1693.10,1211234.20,0.00,0.00,0.00),('1','198','1017','257755',4905456,'3004','463',99.67,101.34,0.00,0.00,1.67,1202.40,0.00,0.00,0.00),('1','198','1017','257755',4905457,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257755',4905458,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257755',4905459,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257755',4905460,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257755',4905461,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257756',4905462,'3002','463',403844.45,403844.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257756',4905463,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257756',4905464,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257756',4905465,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257756',4905466,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257756',4905467,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257756',4905468,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257756',4905469,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257757',4905470,'3002','463',403844.45,404426.13,0.00,0.00,581.68,411057.80,0.00,0.00,0.00),('1','198','1017','257757',4905471,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257757',4905472,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257757',4905473,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257757',4905474,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257757',4905475,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257757',4905476,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257757',4905477,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257758',4905478,'3002','463',404426.13,407433.56,0.00,0.00,3007.43,2133399.60,0.00,0.00,0.00),('1','198','1017','257758',4905479,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257758',4905480,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257758',4905481,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257758',4905482,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257758',4905483,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257758',4905484,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257758',4905485,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257759',4905486,'3002','463',407433.56,409590.25,0.00,0.00,2156.69,1537046.80,0.00,0.00,0.00),('1','198','1017','257759',4905487,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257759',4905488,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257759',4905489,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257759',4905490,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257759',4905491,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257759',4905492,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257759',4905493,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257760',4905494,'3002','463',409590.25,414551.29,0.00,0.00,4961.04,3512901.20,0.00,0.00,0.00),('1','198','1017','257760',4905495,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257760',4905496,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257760',4905497,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257760',4905498,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257760',4905499,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257760',4905500,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257760',4905501,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257761',4905502,'3002','463',414551.29,416988.35,0.00,0.00,2437.06,1735222.80,0.00,0.00,0.00),('1','198','1017','257761',4905503,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257761',4905504,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257761',4905505,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257761',4905506,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257761',4905507,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257761',4905508,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257761',4905509,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257762',4905510,'3002','463',416988.35,419570.83,0.00,0.00,2582.48,1842145.80,0.00,0.00,0.00),('1','198','1017','257762',4905511,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257762',4905512,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257762',4905513,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257762',4905514,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257762',4905515,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257762',4905516,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257762',4905517,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257763',4905518,'3002','463',419570.83,421621.69,0.00,0.00,2050.86,1458126.40,0.00,0.00,0.00),('1','198','1017','257763',4905519,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257763',4905520,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257763',4905521,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257763',4905522,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257763',4905523,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257763',4905524,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257763',4905525,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257764',4905526,'3002','463',421621.69,424364.53,0.00,0.00,2742.84,1952169.20,0.00,0.00,0.00),('1','198','1017','257764',4905527,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257764',4905528,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257764',4905529,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257764',4905530,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257764',4905531,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257764',4905532,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257764',4905533,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257765',4905534,'3002','463',424364.53,426314.72,0.00,0.00,1950.19,1404016.80,0.00,0.00,0.00),('1','198','1017','257765',4905535,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257765',4905536,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257765',4905537,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257765',4905538,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257765',4905539,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257765',4905540,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257765',4905541,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257766',4905542,'3002','463',426314.72,428553.03,0.00,0.00,2238.31,1592533.20,0.00,0.00,0.00),('1','198','1017','257766',4905543,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257766',4905544,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257766',4905545,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257766',4905546,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257766',4905547,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257766',4905548,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257766',4905549,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257767',4905550,'3002','463',428553.03,428652.10,0.00,0.00,99.07,71170.40,0.00,0.00,0.00),('1','198','1017','257767',4905551,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257767',4905552,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257767',4905553,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257767',4905554,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257767',4905555,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257767',4905556,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257767',4905557,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257768',4905558,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257768',4905559,'3003','463',385555.91,385555.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257768',4905560,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257768',4905561,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257768',4905562,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257768',4905563,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257768',4905564,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257768',4905565,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257769',4905566,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257769',4905567,'3003','463',385555.91,388151.67,0.00,0.00,2595.76,1842564.40,0.00,0.00,0.00),('1','198','1017','257769',4905568,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257769',4905569,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257769',4905570,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257769',4905571,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257769',4905572,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257769',4905573,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257770',4905574,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257770',4905575,'3003','463',388151.67,391437.43,0.00,0.00,3285.76,2325073.40,0.00,0.00,0.00),('1','198','1017','257770',4905576,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257770',4905577,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257770',4905578,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257770',4905579,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257770',4905580,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257770',4905581,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257771',4905582,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257771',4905583,'3003','463',391437.43,399312.08,0.00,0.00,7874.65,5541198.40,0.00,0.00,0.00),('1','198','1017','257771',4905584,'3004','463',101.34,101.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257771',4905585,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257771',4905586,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257771',4905587,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257771',4905588,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257771',4905589,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257772',4905590,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257772',4905591,'3003','463',399312.08,405712.58,0.00,0.00,6400.50,4509654.00,0.00,0.00,0.00),('1','198','1017','257772',4905592,'3004','463',101.34,109.34,0.00,0.00,8.00,5760.00,0.00,0.00,0.00),('1','198','1017','257772',4905593,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257772',4905594,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257772',4905595,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257772',4905596,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257772',4905597,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257773',4905598,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257773',4905599,'3003','463',405712.58,410316.11,0.00,0.00,4603.53,3236924.60,0.00,0.00,0.00),('1','198','1017','257773',4905600,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257773',4905601,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257773',4905602,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257773',4905603,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257773',4905604,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257773',4905605,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257774',4905606,'3002','463',428652.10,428652.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257774',4905607,'3003','463',410316.11,410316.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257774',4905608,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257774',4905609,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257774',4905610,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257774',4905611,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257774',4905612,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257774',4905613,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257775',4905614,'3002','463',428652.10,433095.56,0.00,0.00,4443.46,3167612.20,0.00,0.00,0.00),('1','198','1017','257775',4905615,'3003','463',410316.11,410316.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257775',4905616,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257775',4905617,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257775',4905618,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257775',4905619,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257775',4905620,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257775',4905621,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257776',4905622,'3002','463',433095.56,434672.61,0.00,0.00,1577.05,1123878.70,0.00,0.00,0.00),('1','198','1017','257776',4905623,'3003','463',410316.11,410316.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257776',4905624,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257776',4905625,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257776',4905626,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257776',4905627,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257776',4905628,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257776',4905629,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257777',4905630,'3002','463',434672.61,438070.86,0.00,0.00,3398.25,2451019.20,0.00,0.00,0.00),('1','198','1017','257777',4905631,'3003','463',410316.11,410316.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257777',4905632,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257777',4905633,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257777',4905634,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257777',4905635,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257777',4905636,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257777',4905637,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257778',4905638,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257778',4905639,'3003','463',410316.11,411601.52,0.00,0.00,1285.41,927566.20,0.00,0.00,0.00),('1','198','1017','257778',4905640,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257778',4905641,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257778',4905642,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257778',4905643,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257778',4905644,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257778',4905645,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257779',4905646,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257779',4905647,'3003','463',411601.52,419802.34,0.00,0.00,8200.82,5920241.30,0.00,0.00,0.00),('1','198','1017','257779',4905648,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257779',4905649,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257779',4905650,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257779',4905651,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257779',4905652,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257779',4905653,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257780',4905654,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257780',4905655,'3003','463',419802.34,425925.26,0.00,0.00,6122.92,4426374.60,0.00,0.00,0.00),('1','198','1017','257780',4905656,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257780',4905657,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257780',4905658,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257780',4905659,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257780',4905660,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257780',4905661,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257781',4905662,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257781',4905663,'3003','463',425925.26,428315.38,0.00,0.00,2390.12,1744787.60,0.00,0.00,0.00),('1','198','1017','257781',4905664,'3004','463',109.34,109.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257781',4905665,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257781',4905666,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257781',4905667,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257781',4905668,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257781',4905669,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257782',4905670,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257782',4905671,'3003','463',428315.38,430184.64,0.00,0.00,1869.26,1364559.80,0.00,0.00,0.00),('1','198','1017','257782',4905672,'3004','463',109.34,112.35,0.00,0.00,3.01,2197.30,0.00,0.00,0.00),('1','198','1017','257782',4905673,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257782',4905674,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257782',4905675,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257782',4905676,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257782',4905677,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257783',4905678,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257783',4905679,'3003','463',430184.64,432188.04,0.00,0.00,2003.40,1462482.00,0.00,0.00,0.00),('1','198','1017','257783',4905680,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257783',4905681,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257783',4905682,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257783',4905683,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257783',4905684,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257783',4905685,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257784',4905686,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257784',4905687,'3003','463',432188.04,434906.53,0.00,0.00,2718.49,1964105.20,0.00,0.00,0.00),('1','198','1017','257784',4905688,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257784',4905689,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257784',4905690,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257784',4905691,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257784',4905692,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257784',4905693,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257785',4905694,'3002','463',438070.86,438070.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257785',4905695,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257785',4905696,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257785',4905697,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257785',4905698,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257785',4905699,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257785',4905700,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257785',4905701,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257786',4905702,'3002','463',438070.86,438374.51,0.00,0.00,303.65,219164.50,0.00,0.00,0.00),('1','198','1017','257786',4905703,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257786',4905704,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257786',4905705,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257786',4905706,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257786',4905707,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257786',4905708,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257786',4905709,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257787',4905710,'3002','463',438374.51,440530.43,0.00,0.00,2155.92,1569721.60,0.00,0.00,0.00),('1','198','1017','257787',4905711,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257787',4905712,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257787',4905713,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257787',4905714,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257787',4905715,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257787',4905716,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257787',4905717,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257788',4905718,'3002','463',440530.43,442033.33,0.00,0.00,1502.90,1178273.60,0.00,0.00,0.00),('1','198','1017','257788',4905719,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257788',4905720,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257788',4905721,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257788',4905722,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257788',4905723,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257788',4905724,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257788',4905725,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257789',4905726,'3002','463',442033.33,443744.10,0.00,0.00,1710.77,1334400.60,0.00,0.00,0.00),('1','198','1017','257789',4905727,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257789',4905728,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257789',4905729,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257789',4905730,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257789',4905731,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257789',4905732,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257789',4905733,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257790',4905734,'3002','463',443744.10,445646.12,0.00,0.00,1902.02,1483575.60,0.00,0.00,0.00),('1','198','1017','257790',4905735,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257790',4905736,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257790',4905737,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257790',4905738,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257790',4905739,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257790',4905740,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257790',4905741,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257791',4905742,'3002','463',445646.12,447129.10,0.00,0.00,1482.98,1156724.40,0.00,0.00,0.00),('1','198','1017','257791',4905743,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257791',4905744,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257791',4905745,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257791',4905746,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257791',4905747,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257791',4905748,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257791',4905749,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257792',4905750,'3002','463',447129.10,447129.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257792',4905751,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257792',4905752,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257792',4905753,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257792',4905754,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257792',4905755,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257792',4905756,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257792',4905757,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257793',4905758,'3002','463',447129.10,447129.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257793',4905759,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257793',4905760,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257793',4905761,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257793',4905762,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257793',4905763,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257793',4905764,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257793',4905765,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257794',4905766,'3002','463',447129.10,449813.45,0.00,0.00,2684.35,2093793.00,0.00,0.00,0.00),('1','198','1017','257794',4905767,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257794',4905768,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257794',4905769,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257794',4905770,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257794',4905771,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257794',4905772,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257794',4905773,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257795',4905774,'3002','463',449813.45,451785.72,0.00,0.00,1972.27,1538370.60,0.00,0.00,0.00),('1','198','1017','257795',4905775,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257795',4905776,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257795',4905777,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257795',4905778,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257795',4905779,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257795',4905780,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257795',4905781,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257796',4905782,'3002','463',451785.72,451785.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257796',4905783,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257796',4905784,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257796',4905785,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257796',4905786,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257796',4905787,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257796',4905788,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257796',4905789,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257797',4905790,'3002','463',451785.72,453681.70,0.00,0.00,1895.98,1478864.40,0.00,0.00,0.00),('1','198','1017','257797',4905791,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257797',4905792,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257797',4905793,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257797',4905794,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257797',4905795,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257797',4905796,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257797',4905797,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257798',4905798,'3002','463',453681.70,455846.48,0.00,0.00,2164.78,1688528.40,0.00,0.00,0.00),('1','198','1017','257798',4905799,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257798',4905800,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257798',4905801,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257798',4905802,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257798',4905803,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257798',4905804,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257798',4905805,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257799',4905806,'3002','463',455846.48,457745.30,0.00,0.00,1898.82,1481079.60,0.00,0.00,0.00),('1','198','1017','257799',4905807,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257799',4905808,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257799',4905809,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257799',4905810,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257799',4905811,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257799',4905812,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257799',4905813,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257800',4905814,'3002','463',457745.30,459358.87,0.00,0.00,1613.57,1253844.60,0.00,0.00,0.00),('1','198','1017','257800',4905815,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257800',4905816,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257800',4905817,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257800',4905818,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257800',4905819,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257800',4905820,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257800',4905821,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257801',4905822,'3002','463',459358.87,461838.38,0.00,0.00,2479.51,1865428.20,0.00,0.00,0.00),('1','198','1017','257801',4905823,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257801',4905824,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257801',4905825,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257801',4905826,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257801',4905827,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257801',4905828,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257801',4905829,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257802',4905830,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257802',4905831,'3003','463',434906.53,434906.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257802',4905832,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257802',4905833,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257802',4905834,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257802',4905835,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257802',4905836,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257802',4905837,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257803',4905838,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257803',4905839,'3003','463',434906.53,437180.44,0.00,0.00,2273.91,1705621.40,0.00,0.00,0.00),('1','198','1017','257803',4905840,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257803',4905841,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257803',4905842,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257803',4905843,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257803',4905844,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257803',4905845,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257804',4905846,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257804',4905847,'3003','463',437180.44,439742.42,0.00,0.00,2561.98,1939970.40,0.00,0.00,0.00),('1','198','1017','257804',4905848,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257804',4905849,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257804',4905850,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257804',4905851,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257804',4905852,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257804',4905853,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257805',4905854,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257805',4905855,'3003','463',439742.42,446539.32,0.00,0.00,6796.90,5088900.80,0.00,0.00,0.00),('1','198','1017','257805',4905856,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257805',4905857,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257805',4905858,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257805',4905859,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257805',4905860,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257805',4905861,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257806',4905862,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257806',4905863,'3003','463',446539.32,450074.98,0.00,0.00,3535.66,2688306.08,0.00,0.00,0.00),('1','198','1017','257806',4905864,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257806',4905865,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257806',4905866,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257806',4905867,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257806',4905868,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257806',4905869,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257807',4905870,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257807',4905871,'3003','463',450074.98,452723.07,0.00,0.00,2648.09,2045544.24,0.00,0.00,0.00),('1','198','1017','257807',4905872,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257807',4905873,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257807',4905874,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257807',4905875,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257807',4905876,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257807',4905877,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257808',4905878,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257808',4905879,'3003','463',452723.07,455687.54,0.00,0.00,2964.47,2286275.72,0.00,0.00,0.00),('1','198','1017','257808',4905880,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257808',4905881,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257808',4905882,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257808',4905883,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257808',4905884,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257808',4905885,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257809',4905886,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257809',4905887,'3003','463',455687.54,457920.33,0.00,0.00,2232.79,1726495.82,0.00,0.00,0.00),('1','198','1017','257809',4905888,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257809',4905889,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257809',4905890,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257809',4905891,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257809',4905892,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257809',4905893,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257810',4905894,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257810',4905895,'3003','463',457920.33,459490.48,0.00,0.00,1570.15,1188205.40,0.00,0.00,0.00),('1','198','1017','257810',4905896,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257810',4905897,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257810',4905898,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257810',4905899,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257810',4905900,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257810',4905901,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257811',4905902,'3002','463',461838.38,461838.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257811',4905903,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257811',4905904,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257811',4905905,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257811',4905906,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257811',4905907,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257811',4905908,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257811',4905909,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257812',4905910,'3002','463',461838.38,463518.65,0.00,0.00,1680.27,1265174.20,0.00,0.00,0.00),('1','198','1017','257812',4905911,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257812',4905912,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257812',4905913,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257812',4905914,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257812',4905915,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257812',4905916,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257812',4905917,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257813',4905918,'3002','463',463518.65,465979.29,0.00,0.00,2460.64,1867883.60,0.00,0.00,0.00),('1','198','1017','257813',4905919,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257813',4905920,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257813',4905921,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257813',4905922,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257813',4905923,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257813',4905924,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257813',4905925,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257814',4905926,'3002','463',465979.29,469781.83,0.00,0.00,3802.54,2869249.20,0.00,0.00,0.00),('1','198','1017','257814',4905927,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257814',4905928,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257814',4905929,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257814',4905930,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257814',4905931,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257814',4905932,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257814',4905933,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257815',4905934,'3002','463',469781.83,473290.52,0.00,0.00,3508.69,2645704.60,0.00,0.00,0.00),('1','198','1017','257815',4905935,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257815',4905936,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257815',4905937,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257815',4905938,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257815',4905939,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257815',4905940,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257815',4905941,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257816',4905942,'3002','463',473290.52,475718.46,0.00,0.00,2427.94,1832892.40,0.00,0.00,0.00),('1','198','1017','257816',4905943,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257816',4905944,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257816',4905945,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257816',4905946,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257816',4905947,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257816',4905948,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257816',4905949,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257817',4905950,'3002','463',475718.46,482170.05,0.00,0.00,6451.59,4828960.20,0.00,0.00,0.00),('1','198','1017','257817',4905951,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257817',4905952,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257817',4905953,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257817',4905954,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257817',4905955,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257817',4905956,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257817',4905957,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257818',4905958,'3002','463',482170.05,485684.40,0.00,0.00,3514.35,2649587.80,0.00,0.00,0.00),('1','198','1017','257818',4905959,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257818',4905960,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257818',4905961,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257818',4905962,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257818',4905963,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257818',4905964,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257818',4905965,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257819',4905966,'3002','463',485684.40,486504.55,0.00,0.00,820.15,618702.60,0.00,0.00,0.00),('1','198','1017','257819',4905967,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257819',4905968,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257819',4905969,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257819',4905970,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257819',4905971,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257819',4905972,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257819',4905973,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257820',4905974,'3002','463',486504.55,486504.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257820',4905975,'3003','463',459490.48,459490.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257820',4905976,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257820',4905977,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257820',4905978,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257820',4905979,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257820',4905980,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257820',4905981,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257821',4905982,'3002','463',486504.55,486504.56,0.00,0.00,0.01,7.80,0.00,0.00,0.00),('1','198','1017','257821',4905983,'3003','463',459490.48,462377.21,0.00,0.00,2886.73,2171003.80,0.00,0.00,0.00),('1','198','1017','257821',4905984,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257821',4905985,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257821',4905986,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257821',4905987,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257821',4905988,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257821',4905989,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257822',4905990,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257822',4905991,'3003','463',462377.21,466090.60,0.00,0.00,3713.39,2789884.20,0.00,0.00,0.00),('1','198','1017','257822',4905992,'3004','463',112.35,112.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257822',4905993,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257822',4905994,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257822',4905995,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257822',4905996,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257822',4905997,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257823',4905998,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257823',4905999,'3003','463',466090.60,469870.30,0.00,0.00,3779.70,2861192.40,0.00,0.00,0.00),('1','198','1017','257823',4906000,'3004','463',112.35,127.41,0.00,0.00,15.06,11746.80,0.00,0.00,0.00),('1','198','1017','257823',4906001,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257823',4906002,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257823',4906003,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257823',4906004,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257823',4906005,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257824',4906006,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257824',4906007,'3003','463',469870.30,473036.46,0.00,0.00,3166.16,2390490.40,0.00,0.00,0.00),('1','198','1017','257824',4906008,'3004','463',127.41,127.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257824',4906009,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257824',4906010,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257824',4906011,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257824',4906012,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257824',4906013,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257825',4906014,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257825',4906015,'3003','463',473036.46,473297.49,0.00,0.00,261.03,200383.40,0.00,0.00,0.00),('1','198','1017','257825',4906016,'3004','463',127.41,127.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257825',4906017,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257825',4906018,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257825',4906019,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257825',4906020,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257825',4906021,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257826',4906022,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257826',4906023,'3003','463',473297.49,476790.41,0.00,0.00,3492.92,2508740.12,0.00,0.00,0.00),('1','198','1017','257826',4906024,'3004','463',127.41,133.52,0.00,0.00,6.11,4496.96,0.00,0.00,0.00),('1','198','1017','257826',4906025,'3005','463',23.51,23.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257826',4906026,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257826',4906027,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257826',4906028,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257826',4906029,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257827',4906030,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257827',4906031,'3003','463',476790.41,480833.53,0.00,0.00,4043.12,2911999.92,0.00,0.00,0.00),('1','198','1017','257827',4906032,'3004','463',133.52,595.11,0.00,0.00,461.59,329785.24,0.00,0.00,0.00),('1','198','1017','257827',4906033,'3005','463',23.51,30.31,0.00,0.00,6.80,5004.80,0.00,0.00,0.00),('1','198','1017','257827',4906034,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257827',4906035,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257827',4906036,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257827',4906037,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257828',4906038,'3002','463',486504.56,486504.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257828',4906039,'3003','463',480833.53,484235.47,0.00,0.00,3401.94,2459976.76,0.00,0.00,0.00),('1','198','1017','257828',4906040,'3004','463',595.11,614.35,0.00,0.00,19.24,13835.64,0.00,0.00,0.00),('1','198','1017','257828',4906041,'3005','463',30.31,34.39,0.00,0.00,4.08,3002.88,0.00,0.00,0.00),('1','198','1017','257828',4906042,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257828',4906043,'3007','463',44.84,44.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257828',4906044,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257828',4906045,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257829',4906046,'3002','463',486504.56,493952.11,0.00,0.00,7447.55,5336494.90,0.00,0.00,0.00),('1','198','1017','257829',4906047,'3003','463',484235.47,484235.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257829',4906048,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257829',4906049,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257829',4906050,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257829',4906051,'3007','463',44.84,47.84,0.00,0.00,3.00,2208.00,0.00,0.00,0.00),('1','198','1016','257829',4906052,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257829',4906053,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257830',4906054,'3002','463',493952.11,499226.56,0.00,0.00,5274.45,3793908.76,0.00,0.00,0.00),('1','198','1017','257830',4906055,'3003','463',484235.47,484235.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257830',4906056,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257830',4906057,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257830',4906058,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257830',4906059,'3007','463',47.84,51.92,0.00,0.00,4.08,3002.88,0.00,0.00,0.00),('1','198','1016','257830',4906060,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257830',4906061,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257831',4906062,'3002','463',499226.56,503193.25,0.00,0.00,3966.69,2870258.30,0.00,0.00,0.00),('1','198','1017','257831',4906063,'3003','463',484235.47,484235.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257831',4906064,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257831',4906065,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257831',4906066,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257831',4906067,'3007','463',51.92,51.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257831',4906068,'3008','463',1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257831',4906069,'3009','463',25.00,25.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257832',4906070,'3002','463',503193.25,509358.45,0.00,0.00,6165.20,4445070.10,0.00,0.00,0.00),('1','198','1017','257832',4906071,'3003','463',484235.47,484235.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257832',4906072,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257832',4906073,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257832',4906074,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257832',4906075,'3007','463',51.92,76.92,0.00,0.00,25.00,18400.00,0.00,0.00,0.00),('1','198','1016','257832',4906076,'3008','463',1.00,6.00,0.00,0.00,5.00,3680.00,0.00,0.00,0.00),('1','198','1016','257832',4906077,'3009','463',25.00,30.00,0.00,0.00,5.00,3680.00,0.00,0.00,0.00),('1','198','1016','257833',4906078,'3002','463',509358.45,510660.70,0.00,0.00,1302.25,935899.70,0.00,0.00,0.00),('1','198','1017','257833',4906079,'3003','463',484235.47,484235.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257833',4906080,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257833',4906081,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257833',4906082,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257833',4906083,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257833',4906084,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257833',4906085,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257834',4906086,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257834',4906087,'3003','463',484235.47,484235.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257834',4906088,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257834',4906089,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257834',4906090,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257834',4906091,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257834',4906092,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257834',4906093,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257835',4906094,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257835',4906095,'3003','463',484235.47,487061.06,0.00,0.00,2825.59,2032134.84,0.00,0.00,0.00),('1','198','1017','257835',4906096,'3004','463',614.35,614.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257835',4906097,'3005','463',34.39,34.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257835',4906098,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257835',4906099,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257835',4906100,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257835',4906101,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257836',4906102,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257836',4906103,'3003','463',487061.06,491963.27,0.00,0.00,4902.21,3517273.82,0.00,0.00,0.00),('1','198','1017','257836',4906104,'3004','463',614.35,680.42,0.00,0.00,66.07,47327.52,0.00,0.00,0.00),('1','198','1017','257836',4906105,'3005','463',34.39,104.55,0.00,0.00,70.16,50337.76,0.00,0.00,0.00),('1','198','1017','257836',4906106,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257836',4906107,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257836',4906108,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257836',4906109,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257837',4906110,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257837',4906111,'3003','463',491963.27,496603.50,0.00,0.00,4640.23,3329883.00,0.00,0.00,0.00),('1','198','1017','257837',4906112,'3004','463',680.42,693.38,0.00,0.00,12.96,9538.56,0.00,0.00,0.00),('1','198','1017','257837',4906113,'3005','463',104.55,104.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257837',4906114,'3006','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257837',4906115,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257837',4906116,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257837',4906117,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257838',4906118,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257838',4906119,'3003','463',496603.50,499598.02,0.00,0.00,2994.52,2148998.30,0.00,0.00,0.00),('1','198','1017','257838',4906120,'3004','463',693.38,1057.64,0.00,0.00,364.26,268095.36,0.00,0.00,0.00),('1','198','1017','257838',4906121,'3005','463',104.55,208.22,0.00,0.00,103.67,76301.12,0.00,0.00,0.00),('1','198','1017','257838',4906122,'3006','463',6.00,12.00,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','198','1016','257838',4906123,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257838',4906124,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257838',4906125,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257839',4906126,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257839',4906127,'3003','463',499598.02,503495.34,0.00,0.00,3897.32,2806371.76,0.00,0.00,0.00),('1','198','1017','257839',4906128,'3004','463',1057.64,1057.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257839',4906129,'3005','463',208.22,208.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257839',4906130,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257839',4906131,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257839',4906132,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257839',4906133,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257840',4906134,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257840',4906135,'3003','463',503495.34,506762.14,0.00,0.00,3266.80,2351216.64,0.00,0.00,0.00),('1','198','1017','257840',4906136,'3004','463',1057.64,1086.70,0.00,0.00,29.06,21388.16,0.00,0.00,0.00),('1','198','1017','257840',4906137,'3005','463',208.22,211.22,0.00,0.00,3.00,2208.00,0.00,0.00,0.00),('1','198','1017','257840',4906138,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257840',4906139,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257840',4906140,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257840',4906141,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257841',4906142,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257841',4906143,'3003','463',506762.14,507789.24,0.00,0.00,1027.10,736716.26,0.00,0.00,0.00),('1','198','1017','257841',4906144,'3004','463',1086.70,1188.69,0.00,0.00,101.99,72464.64,0.00,0.00,0.00),('1','198','1017','257841',4906145,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257841',4906146,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257841',4906147,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257841',4906148,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257841',4906149,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257842',4906150,'3002','463',510660.70,510660.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257842',4906151,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257842',4906152,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257842',4906153,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257842',4906154,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257842',4906155,'3007','463',76.92,76.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257842',4906156,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257842',4906157,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257843',4906158,'3002','463',510660.70,524706.30,0.00,0.00,14045.60,10082494.06,0.00,0.00,0.00),('1','198','1017','257843',4906159,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257843',4906160,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257843',4906161,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257843',4906162,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257843',4906163,'3007','463',76.92,95.42,0.00,0.00,18.50,13616.00,0.00,0.00,0.00),('1','198','1016','257843',4906164,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257843',4906165,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257844',4906166,'3002','463',524706.30,528370.07,0.00,0.00,3663.77,2629631.78,0.00,0.00,0.00),('1','198','1017','257844',4906167,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257844',4906168,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257844',4906169,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257844',4906170,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257844',4906171,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257844',4906172,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257844',4906173,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257845',4906174,'3002','463',528370.07,531879.60,0.00,0.00,3509.53,2531131.60,0.00,0.00,0.00),('1','198','1017','257845',4906175,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257845',4906176,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257845',4906177,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257845',4906178,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257845',4906179,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257845',4906180,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257845',4906181,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257846',4906182,'3002','463',531879.60,535154.10,0.00,0.00,3274.50,2358017.18,0.00,0.00,0.00),('1','198','1016','257846',4906183,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257846',4906184,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257846',4906185,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257846',4906186,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257846',4906187,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257846',4906188,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257846',4906189,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257847',4906190,'3002','463',535154.10,536226.02,0.00,0.00,1071.92,778351.12,0.00,0.00,0.00),('1','198','1017','257847',4906191,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257847',4906192,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257847',4906193,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257847',4906194,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257847',4906195,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257847',4906196,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257847',4906197,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257848',4906198,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257848',4906199,'3003','463',507789.24,507789.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257848',4906200,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257848',4906201,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257848',4906202,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257848',4906203,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257848',4906204,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257848',4906205,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257849',4906206,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257849',4906207,'3003','463',507789.24,510739.05,0.00,0.00,2949.81,2114294.62,0.00,0.00,0.00),('1','198','1017','257849',4906208,'3004','463',1188.69,1188.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257849',4906209,'3005','463',211.22,211.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257849',4906210,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257849',4906211,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257849',4906212,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257849',4906213,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257850',4906214,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257850',4906215,'3003','463',510739.05,514315.12,0.00,0.00,3576.07,2570121.82,0.00,0.00,0.00),('1','198','1017','257850',4906216,'3004','463',1188.69,1671.13,0.00,0.00,482.44,344025.84,0.00,0.00,0.00),('1','198','1017','257850',4906217,'3005','463',211.22,223.86,0.00,0.00,12.64,9303.04,0.00,0.00,0.00),('1','198','1017','257850',4906218,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257850',4906219,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257850',4906220,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257850',4906221,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257851',4906222,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257851',4906223,'3003','463',514315.12,519903.99,0.00,0.00,5588.87,4010967.28,0.00,0.00,0.00),('1','198','1017','257851',4906224,'3004','463',1671.13,1677.24,0.00,0.00,6.11,4496.96,0.00,0.00,0.00),('1','198','1017','257851',4906225,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257851',4906226,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257851',4906227,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257851',4906228,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257851',4906229,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257852',4906230,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257852',4906231,'3003','463',519903.99,522686.42,0.00,0.00,2782.43,2006183.98,0.00,0.00,0.00),('1','198','1017','257852',4906232,'3004','463',1677.24,1956.09,0.00,0.00,278.85,202880.60,0.00,0.00,0.00),('1','198','1017','257852',4906233,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257852',4906234,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257852',4906235,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257852',4906236,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257852',4906237,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257853',4906238,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257853',4906239,'3003','463',522686.42,525269.69,0.00,0.00,2583.27,1868854.58,0.00,0.00,0.00),('1','198','1017','257853',4906240,'3004','463',1956.09,1956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257853',4906241,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257853',4906242,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257853',4906243,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257853',4906244,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257853',4906245,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257854',4906246,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257854',4906247,'3003','463',525269.69,529664.28,0.00,0.00,4394.59,3159048.92,0.00,0.00,0.00),('1','198','1017','257854',4906248,'3004','463',1956.09,1967.10,0.00,0.00,11.01,8103.36,0.00,0.00,0.00),('1','198','1017','257854',4906249,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257854',4906250,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257854',4906251,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257854',4906252,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257854',4906253,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257855',4906254,'3002','463',536226.02,536226.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257855',4906255,'3003','463',529664.28,531435.24,0.00,0.00,1770.96,1274082.96,0.00,0.00,0.00),('1','198','1017','257855',4906256,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257855',4906257,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257855',4906258,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257855',4906259,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257855',4906260,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257855',4906261,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257856',4906262,'3002','463',536226.02,537970.10,0.00,0.00,1744.08,1258649.08,0.00,0.00,0.00),('1','198','1017','257856',4906263,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257856',4906264,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257856',4906265,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257856',4906266,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257856',4906267,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257856',4906268,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257856',4906269,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257857',4906270,'3002','463',537970.10,546036.45,0.00,0.00,8066.35,5763207.94,0.00,0.00,0.00),('1','198','1017','257857',4906271,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257857',4906272,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257857',4906273,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257857',4906274,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257857',4906275,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257857',4906276,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257857',4906277,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257858',4906278,'3002','463',546036.45,550263.05,0.00,0.00,4226.60,3042852.34,0.00,0.00,0.00),('1','198','1017','257858',4906279,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257858',4906280,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257858',4906281,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257858',4906282,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257858',4906283,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257858',4906284,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257858',4906285,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257859',4906286,'3002','463',550263.05,554379.36,0.00,0.00,4116.31,2966850.56,0.00,0.00,0.00),('1','198','1017','257859',4906287,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257859',4906288,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257859',4906289,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257859',4906290,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257859',4906291,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257859',4906292,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257859',4906293,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257860',4906294,'3002','463',554379.36,558152.88,0.00,0.00,3773.52,2713835.62,0.00,0.00,0.00),('1','198','1017','257860',4906295,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257860',4906296,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257860',4906297,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257860',4906298,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257860',4906299,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257860',4906300,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257860',4906301,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257861',4906302,'3002','463',558152.88,560239.81,0.00,0.00,2086.93,1498982.48,0.00,0.00,0.00),('1','198','1017','257861',4906303,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257861',4906304,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257861',4906305,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257861',4906306,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257861',4906307,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257861',4906308,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257861',4906309,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257862',4906310,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257862',4906311,'3003','463',531435.24,531435.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257862',4906312,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257862',4906313,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257862',4906314,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257862',4906315,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257862',4906316,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257862',4906317,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257863',4906318,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257863',4906319,'3003','463',531435.24,534332.21,0.00,0.00,2896.97,2075019.84,0.00,0.00,0.00),('1','198','1017','257863',4906320,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257863',4906321,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257863',4906322,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257863',4906323,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257863',4906324,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257863',4906325,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257864',4906326,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257864',4906327,'3003','463',534332.21,537365.16,0.00,0.00,3032.95,2192549.98,0.00,0.00,0.00),('1','198','1017','257864',4906328,'3004','463',1967.10,1967.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257864',4906329,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257864',4906330,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257864',4906331,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257864',4906332,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257864',4906333,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257865',4906334,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257865',4906335,'3003','463',537365.16,540039.86,0.00,0.00,2674.70,1932434.78,0.00,0.00,0.00),('1','198','1017','257865',4906336,'3004','463',1967.10,1975.25,0.00,0.00,8.15,5998.40,0.00,0.00,0.00),('1','198','1017','257865',4906337,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257865',4906338,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257865',4906339,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257865',4906340,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257865',4906341,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257866',4906342,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257866',4906343,'3003','463',540039.86,544856.50,0.00,0.00,4816.64,3463551.34,0.00,0.00,0.00),('1','198','1017','257866',4906344,'3004','463',1975.25,1980.75,0.00,0.00,5.50,3905.00,0.00,0.00,0.00),('1','198','1017','257866',4906345,'3005','463',223.86,223.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257866',4906346,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257866',4906347,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257866',4906348,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257866',4906349,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257867',4906350,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257867',4906351,'3003','463',544856.50,547465.06,0.00,0.00,2608.56,1893768.08,0.00,0.00,0.00),('1','198','1017','257867',4906352,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257867',4906353,'3005','463',223.86,227.86,0.00,0.00,4.00,2944.00,0.00,0.00,0.00),('1','198','1017','257867',4906354,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257867',4906355,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257867',4906356,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257867',4906357,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257868',4906358,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257868',4906359,'3003','463',547465.06,551590.68,0.00,0.00,4125.62,2972869.16,0.00,0.00,0.00),('1','198','1017','257868',4906360,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257868',4906361,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257868',4906362,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257868',4906363,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257868',4906364,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257868',4906365,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257869',4906366,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257869',4906367,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257869',4906368,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257869',4906369,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257869',4906370,'3003','463',551590.68,554459.43,0.00,0.00,2868.75,2068895.72,0.00,0.00,0.00),('1','198','1017','257869',4906371,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257869',4906372,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257869',4906373,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257870',4906374,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257870',4906375,'3003','463',554459.43,555980.53,0.00,0.00,1521.10,1097683.36,0.00,0.00,0.00),('1','198','1017','257870',4906376,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257870',4906377,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257870',4906378,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257870',4906379,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257870',4906380,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257870',4906381,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257871',4906382,'3002','463',560239.81,560239.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257871',4906383,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257871',4906384,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257871',4906385,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257871',4906386,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257871',4906387,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257871',4906388,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257871',4906389,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257872',4906390,'3002','463',560239.81,562363.45,0.00,0.00,2123.64,1533719.92,0.00,0.00,0.00),('1','198','1017','257872',4906391,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257872',4906392,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257872',4906393,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257872',4906394,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257872',4906395,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257872',4906396,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257872',4906397,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257873',4906398,'3002','463',562363.45,565125.62,0.00,0.00,2762.17,1998519.08,0.00,0.00,0.00),('1','198','1017','257873',4906399,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257873',4906400,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257873',4906401,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257873',4906402,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257873',4906403,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257873',4906404,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257873',4906405,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257874',4906406,'3002','463',565125.62,568043.13,0.00,0.00,2917.51,2111529.30,0.00,0.00,0.00),('1','198','1017','257874',4906407,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257874',4906408,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257874',4906409,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257874',4906410,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257874',4906411,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257874',4906412,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257874',4906413,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257875',4906414,'3002','463',568043.13,571868.42,0.00,0.00,3825.29,2754181.36,0.00,0.00,0.00),('1','198','1017','257875',4906415,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257875',4906416,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257875',4906417,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257875',4906418,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257875',4906419,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257875',4906420,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257875',4906421,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257876',4906422,'3002','463',571868.42,574948.79,0.00,0.00,3080.37,2229750.28,0.00,0.00,0.00),('1','198','1017','257876',4906423,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257876',4906424,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257876',4906425,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257876',4906426,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257876',4906427,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257876',4906428,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257876',4906429,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257877',4906430,'3002','463',574948.79,577509.35,0.00,0.00,2560.56,1855565.00,0.00,0.00,0.00),('1','198','1017','257877',4906431,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257877',4906432,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257877',4906433,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257877',4906434,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257877',4906435,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257877',4906436,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257877',4906437,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257878',4906438,'3002','463',577509.35,580748.47,0.00,0.00,3239.12,2337615.60,0.00,0.00,0.00),('1','198','1017','257878',4906439,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257878',4906440,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257878',4906441,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257878',4906442,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257878',4906443,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257878',4906444,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257878',4906445,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257879',4906446,'3002','463',580748.47,584253.54,0.00,0.00,3505.07,2524504.14,0.00,0.00,0.00),('1','198','1017','257879',4906447,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257879',4906448,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257879',4906449,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257879',4906450,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257879',4906451,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257879',4906452,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257879',4906453,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257880',4906454,'3002','463',584253.54,584782.82,0.00,0.00,529.28,382081.06,0.00,0.00,0.00),('1','198','1017','257880',4906455,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257880',4906456,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257880',4906457,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257880',4906458,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257880',4906459,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257880',4906460,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257880',4906461,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257881',4906462,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257881',4906463,'3003','463',555980.53,555980.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257881',4906464,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257881',4906465,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257881',4906466,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257881',4906467,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257881',4906468,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257881',4906469,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257882',4906470,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257882',4906471,'3003','463',555980.53,559188.94,0.00,0.00,3208.41,2316680.94,0.00,0.00,0.00),('1','198','1017','257882',4906472,'3004','463',1980.75,1980.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257882',4906473,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257882',4906474,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257882',4906475,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257882',4906476,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257882',4906477,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257883',4906478,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257883',4906479,'3003','463',559188.94,561912.65,0.00,0.00,2723.71,1964628.24,0.00,0.00,0.00),('1','198','1017','257883',4906480,'3004','463',1980.75,1983.74,0.00,0.00,2.99,2200.64,0.00,0.00,0.00),('1','198','1017','257883',4906481,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257883',4906482,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257883',4906483,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257883',4906484,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257883',4906485,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257884',4906486,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257884',4906487,'3003','463',561912.65,566043.17,0.00,0.00,4130.52,2981394.24,0.00,0.00,0.00),('1','198','1017','257884',4906488,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257884',4906489,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257884',4906490,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257884',4906491,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257884',4906492,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257884',4906493,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257885',4906494,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257885',4906495,'3003','463',566043.17,568459.92,0.00,0.00,2416.75,1737084.58,0.00,0.00,0.00),('1','198','1017','257885',4906496,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257885',4906497,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257885',4906498,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257885',4906499,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257885',4906500,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257885',4906501,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257886',4906502,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257886',4906503,'3003','463',568459.92,571085.01,0.00,0.00,2625.09,1905183.28,0.00,0.00,0.00),('1','198','1017','257886',4906504,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257886',4906505,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257886',4906506,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257886',4906507,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257886',4906508,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257886',4906509,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257887',4906510,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257887',4906511,'3003','463',571085.01,574860.52,0.00,0.00,3775.51,2717503.50,0.00,0.00,0.00),('1','198','1017','257887',4906512,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257887',4906513,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257887',4906514,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257887',4906515,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257887',4906516,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257887',4906517,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257888',4906518,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257888',4906519,'3003','463',574860.52,579417.20,0.00,0.00,4556.68,3275731.04,0.00,0.00,0.00),('1','198','1017','257888',4906520,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257888',4906521,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257888',4906522,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257888',4906523,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257888',4906524,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257888',4906525,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257889',4906526,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257889',4906527,'3003','463',579417.20,580485.25,0.00,0.00,1068.05,769011.90,0.00,0.00,0.00),('1','198','1017','257889',4906528,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257889',4906529,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257889',4906530,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257889',4906531,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257889',4906532,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257889',4906533,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257890',4906534,'3002','463',584782.82,584782.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257890',4906535,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257890',4906536,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257890',4906537,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257890',4906538,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257890',4906539,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257890',4906540,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257890',4906541,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257891',4906542,'3002','463',584782.82,587626.24,0.00,0.00,2843.42,2049507.42,0.00,0.00,0.00),('1','198','1016','257891',4906543,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257891',4906544,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257891',4906545,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257891',4906546,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257891',4906547,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257891',4906548,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257891',4906549,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257892',4906550,'3002','463',587626.24,591961.70,0.00,0.00,4335.46,3122434.06,0.00,0.00,0.00),('1','198','1017','257892',4906551,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257892',4906552,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257892',4906553,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257892',4906554,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257892',4906555,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257892',4906556,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257892',4906557,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257893',4906558,'3002','463',591961.70,595153.89,0.00,0.00,3192.19,2295318.28,0.00,0.00,0.00),('1','198','1017','257893',4906559,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257893',4906560,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257893',4906561,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257893',4906562,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257893',4906563,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257893',4906564,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257893',4906565,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257894',4906566,'3002','463',595153.89,597738.32,0.00,0.00,2584.43,1867241.20,0.00,0.00,0.00),('1','198','1017','257894',4906567,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257894',4906568,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257894',4906569,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257894',4906570,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257894',4906571,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257894',4906572,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257894',4906573,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257895',4906574,'3002','463',597738.32,599950.49,0.00,0.00,2212.17,1594160.04,0.00,0.00,0.00),('1','198','1017','257895',4906575,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257895',4906576,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257895',4906577,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257895',4906578,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257895',4906579,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257895',4906580,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257895',4906581,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257896',4906582,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257896',4906583,'3003','463',580485.25,580485.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257896',4906584,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257896',4906585,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257896',4906586,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257896',4906587,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257896',4906588,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257896',4906589,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257897',4906590,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257897',4906591,'3003','463',580485.25,581620.84,0.00,0.00,1135.59,821370.74,0.00,0.00,0.00),('1','198','1017','257897',4906592,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257897',4906593,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257897',4906594,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257897',4906595,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257897',4906596,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257897',4906597,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257898',4906598,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257898',4906599,'3003','463',581620.84,584854.11,0.00,0.00,3233.27,2334177.10,0.00,0.00,0.00),('1','198','1017','257898',4906600,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257898',4906601,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257898',4906602,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257898',4906603,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257898',4906604,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257898',4906605,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257899',4906606,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257899',4906607,'3003','463',584854.11,588315.28,0.00,0.00,3461.17,2495866.50,0.00,0.00,0.00),('1','198','1017','257899',4906608,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257899',4906609,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257899',4906610,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257899',4906611,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257899',4906612,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257899',4906613,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257900',4906614,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257900',4906615,'3003','463',588315.28,591148.86,0.00,0.00,2833.58,2043460.14,0.00,0.00,0.00),('1','198','1017','257900',4906616,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257900',4906617,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257900',4906618,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257900',4906619,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257900',4906620,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257900',4906621,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257901',4906622,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257901',4906623,'3003','463',591148.86,596659.09,0.00,0.00,5510.23,3952432.52,0.00,0.00,0.00),('1','198','1017','257901',4906624,'3004','463',1983.74,1983.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257901',4906625,'3005','463',227.86,227.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257901',4906626,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257901',4906627,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257901',4906628,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257901',4906629,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257902',4906630,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257902',4906631,'3003','463',596659.09,600114.98,0.00,0.00,3455.89,2496236.36,0.00,0.00,0.00),('1','198','1017','257902',4906632,'3004','463',1983.74,1989.74,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','198','1017','257902',4906633,'3005','463',227.86,238.05,0.00,0.00,10.19,7499.84,0.00,0.00,0.00),('1','198','1017','257902',4906634,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257902',4906635,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257902',4906636,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257902',4906637,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257903',4906638,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257903',4906639,'3003','463',600114.98,603857.62,0.00,0.00,3742.64,2702248.94,0.00,0.00,0.00),('1','198','1017','257903',4906640,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257903',4906641,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257903',4906642,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257903',4906643,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257903',4906644,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257903',4906645,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257904',4906646,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257904',4906647,'3003','463',603857.62,604054.88,0.00,0.00,197.26,142803.32,0.00,0.00,0.00),('1','198','1017','257904',4906648,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257904',4906649,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257904',4906650,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257904',4906651,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257904',4906652,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257904',4906653,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257905',4906654,'3002','463',599950.49,599950.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257905',4906655,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257905',4906656,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257905',4906657,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257905',4906658,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257905',4906659,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257905',4906660,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257905',4906661,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257906',4906662,'3002','463',599950.49,603880.88,0.00,0.00,3930.39,2826558.56,0.00,0.00,0.00),('1','198','1017','257906',4906663,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257906',4906664,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257906',4906665,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257906',4906666,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257906',4906667,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257906',4906668,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257906',4906669,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257907',4906670,'3002','463',603880.88,606686.54,0.00,0.00,2805.66,2029218.36,0.00,0.00,0.00),('1','198','1017','257907',4906671,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257907',4906672,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257907',4906673,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257907',4906674,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257907',4906675,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257907',4906676,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257907',4906677,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257908',4906678,'3002','463',606686.54,611197.29,0.00,0.00,4510.75,3229934.58,0.00,0.00,0.00),('1','198','1017','257908',4906679,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257908',4906680,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257908',4906681,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257908',4906682,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257908',4906683,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257908',4906684,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257908',4906685,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257909',4906686,'3002','463',611197.29,614156.25,0.00,0.00,2958.96,2138299.00,0.00,0.00,0.00),('1','198','1017','257909',4906687,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257909',4906688,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257909',4906689,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257909',4906690,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257909',4906691,'3007','463',95.42,95.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257909',4906692,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257909',4906693,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257910',4906694,'3002','463',614156.25,616902.81,0.00,0.00,2746.56,1985298.52,0.00,0.00,0.00),('1','198','1017','257910',4906695,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257910',4906696,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257910',4906697,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257910',4906698,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257910',4906699,'3007','463',95.42,205.68,0.00,0.00,110.26,81151.36,0.00,0.00,0.00),('1','198','1016','257910',4906700,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257910',4906701,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257911',4906702,'3002','463',616902.81,618968.27,0.00,0.00,2065.46,1504622.76,0.00,0.00,0.00),('1','198','1017','257911',4906703,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257911',4906704,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257911',4906705,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257911',4906706,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257911',4906707,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257911',4906708,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257911',4906709,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257912',4906710,'3002','463',618968.27,620871.24,0.00,0.00,1902.97,1387206.32,0.00,0.00,0.00),('1','198','1017','257912',4906711,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257912',4906712,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257912',4906713,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257912',4906714,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257912',4906715,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257912',4906716,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257912',4906717,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257913',4906718,'3002','463',620871.24,623012.59,0.00,0.00,2141.35,1554466.60,0.00,0.00,0.00),('1','198','1017','257913',4906719,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257913',4906720,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257913',4906721,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257913',4906722,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257913',4906723,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257913',4906724,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257913',4906725,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257914',4906726,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257914',4906727,'3003','463',604054.88,604054.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257914',4906728,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257914',4906729,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257914',4906730,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257914',4906731,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257914',4906732,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257914',4906733,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257915',4906734,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257915',4906735,'3003','463',604054.88,604692.77,0.00,0.00,637.89,467317.60,0.00,0.00,0.00),('1','198','1017','257915',4906736,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257915',4906737,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257915',4906738,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257915',4906739,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257915',4906740,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257915',4906741,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257916',4906742,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257916',4906743,'3003','463',604692.77,607357.22,0.00,0.00,2664.45,1939591.44,0.00,0.00,0.00),('1','198','1017','257916',4906744,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257916',4906745,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257916',4906746,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257916',4906747,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257916',4906748,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257916',4906749,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257917',4906750,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257917',4906751,'3003','463',607357.22,609907.27,0.00,0.00,2550.05,1848083.92,0.00,0.00,0.00),('1','198','1017','257917',4906752,'3004','463',1989.74,1989.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257917',4906753,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257917',4906754,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257917',4906755,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257917',4906756,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257917',4906757,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257918',4906758,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257918',4906759,'3003','463',609907.27,615181.09,0.00,0.00,5273.82,3783370.34,0.00,0.00,0.00),('1','198','1017','257918',4906760,'3004','463',1989.74,1994.74,0.00,0.00,5.00,3680.00,0.00,0.00,0.00),('1','198','1017','257918',4906761,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257918',4906762,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257918',4906763,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257918',4906764,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257918',4906765,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257919',4906766,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257919',4906767,'3003','463',615181.09,617511.21,0.00,0.00,2330.12,1687574.72,0.00,0.00,0.00),('1','198','1017','257919',4906768,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257919',4906769,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257919',4906770,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257919',4906771,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257919',4906772,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257919',4906773,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257920',4906774,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257920',4906775,'3003','463',617511.21,620469.32,0.00,0.00,2958.11,2139734.42,0.00,0.00,0.00),('1','198','1017','257920',4906776,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257920',4906777,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257920',4906778,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257920',4906779,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257920',4906780,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257920',4906781,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257921',4906782,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257921',4906783,'3003','463',620469.32,623103.76,0.00,0.00,2634.44,1906432.50,0.00,0.00,0.00),('1','198','1017','257921',4906784,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257921',4906785,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257921',4906786,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257921',4906787,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257921',4906788,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257921',4906789,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257922',4906790,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257922',4906791,'3003','463',623103.76,625942.57,0.00,0.00,2838.81,2056513.94,0.00,0.00,0.00),('1','198','1017','257922',4906792,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257922',4906793,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257922',4906794,'3006','463',12.00,12.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257922',4906795,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257922',4906796,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257922',4906797,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257923',4906798,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257923',4906799,'3003','463',625942.57,628514.47,0.00,0.00,2571.90,1857813.46,0.00,0.00,0.00),('1','198','1017','257923',4906800,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257923',4906801,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257923',4906802,'3006','463',12.00,17.00,0.00,0.00,5.00,3680.00,0.00,0.00,0.00),('1','198','1016','257923',4906803,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257923',4906804,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257923',4906805,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257924',4906806,'3002','463',623012.59,623012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257924',4906807,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257924',4906808,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257924',4906809,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257924',4906810,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257924',4906811,'3007','463',205.68,205.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257924',4906812,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257924',4906813,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257925',4906814,'3002','463',623012.59,623397.35,0.00,0.00,384.76,278774.28,0.00,0.00,0.00),('1','198','1016','257925',4906815,'3007','463',205.68,205.86,0.00,0.00,0.18,132.48,0.00,0.00,0.00),('1','198','1016','257925',4906816,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257925',4906817,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257925',4906818,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257925',4906819,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257925',4906820,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257925',4906821,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257926',4906822,'3002','463',623397.35,625912.09,0.00,0.00,2514.74,1819566.74,0.00,0.00,0.00),('1','198','1017','257926',4906823,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257926',4906824,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257926',4906825,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257926',4906826,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257926',4906827,'3007','463',205.86,205.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257926',4906828,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257926',4906829,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257927',4906830,'3002','463',625912.09,628424.85,0.00,0.00,2512.76,1811732.44,0.00,0.00,0.00),('1','198','1017','257927',4906831,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257927',4906832,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257927',4906833,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257927',4906834,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257927',4906835,'3007','463',205.86,220.86,0.00,0.00,15.00,11040.00,0.00,0.00,0.00),('1','198','1016','257927',4906836,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257927',4906837,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257928',4906838,'3002','463',628424.85,631659.38,0.00,0.00,3234.53,2326245.22,0.00,0.00,0.00),('1','198','1017','257928',4906839,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257928',4906840,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257928',4906841,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257928',4906842,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257928',4906843,'3007','463',220.86,222.44,0.00,0.00,1.58,1162.88,0.00,0.00,0.00),('1','198','1016','257928',4906844,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257928',4906845,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257929',4906846,'3002','463',631659.38,634369.96,0.00,0.00,2710.58,1962163.96,0.00,0.00,0.00),('1','198','1017','257929',4906847,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257929',4906848,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257929',4906849,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257929',4906850,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257929',4906851,'3007','463',222.44,222.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257929',4906852,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257929',4906853,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257930',4906854,'3002','463',634369.96,636671.85,0.00,0.00,2301.89,1661065.74,0.00,0.00,0.00),('1','198','1017','257930',4906855,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257930',4906856,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257930',4906857,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257930',4906858,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257930',4906859,'3007','463',222.44,225.16,0.00,0.00,2.72,2001.92,0.00,0.00,0.00),('1','198','1016','257930',4906860,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257930',4906861,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257931',4906862,'3002','463',636671.85,640132.65,0.00,0.00,3460.80,2494198.76,0.00,0.00,0.00),('1','198','1017','257931',4906863,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257931',4906864,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257931',4906865,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257931',4906866,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257931',4906867,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257931',4906868,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257931',4906869,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257932',4906870,'3002','463',640132.65,643006.54,0.00,0.00,2873.89,2079294.98,0.00,0.00,0.00),('1','198','1017','257932',4906871,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257932',4906872,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257932',4906873,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257932',4906874,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257932',4906875,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257932',4906876,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257932',4906877,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257933',4906878,'3002','463',643006.54,645421.03,0.00,0.00,2414.49,1750610.94,0.00,0.00,0.00),('1','198','1017','257933',4906879,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257933',4906880,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257933',4906881,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257933',4906882,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257933',4906883,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257933',4906884,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257933',4906885,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257934',4906886,'3002','463',645421.03,648018.51,0.00,0.00,2597.48,1884380.80,0.00,0.00,0.00),('1','198','1017','257934',4906887,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257934',4906888,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257934',4906889,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257934',4906890,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257934',4906891,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257934',4906892,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257934',4906893,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257935',4906894,'3002','463',648018.51,648103.84,0.00,0.00,85.33,62472.94,0.00,0.00,0.00),('1','198','1017','257935',4906895,'3003','463',628514.47,628514.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257935',4906896,'3004','463',1994.74,1994.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257935',4906897,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257935',4906898,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257935',4906899,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257935',4906900,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257935',4906901,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257936',4906902,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257936',4906903,'3003','463',628514.47,630422.19,0.00,0.00,1907.72,1391416.02,0.00,0.00,0.00),('1','198','1017','257936',4906904,'3004','463',1994.74,1997.74,0.00,0.00,3.00,2208.00,0.00,0.00,0.00),('1','198','1017','257936',4906905,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257936',4906906,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257936',4906907,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257936',4906908,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257936',4906909,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257937',4906910,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257937',4906911,'3003','463',630422.19,634011.44,0.00,0.00,3589.25,2601825.06,0.00,0.00,0.00),('1','198','1017','257937',4906912,'3004','463',1997.74,1997.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257937',4906913,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257937',4906914,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257937',4906915,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257937',4906916,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257937',4906917,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257938',4906918,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257938',4906919,'3003','463',634011.44,637813.57,0.00,0.00,3802.13,2764862.00,0.00,0.00,0.00),('1','198','1017','257938',4906920,'3004','463',1997.74,1997.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257938',4906921,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257938',4906922,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257938',4906923,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257938',4906924,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257938',4906925,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257939',4906926,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257939',4906927,'3003','463',637813.57,643685.56,0.00,0.00,5871.99,4260798.52,0.00,0.00,0.00),('1','198','1017','257939',4906928,'3004','463',1997.74,2097.74,0.00,0.00,100.00,71000.00,0.00,0.00,0.00),('1','198','1017','257939',4906929,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257939',4906930,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257939',4906931,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257939',4906932,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257939',4906933,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257940',4906934,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257940',4906935,'3003','463',643685.56,646337.73,0.00,0.00,2652.17,1922396.12,0.00,0.00,0.00),('1','198','1017','257940',4906936,'3004','463',2097.74,2100.74,0.00,0.00,3.00,2130.00,0.00,0.00,0.00),('1','198','1017','257940',4906937,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257940',4906938,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257940',4906939,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257940',4906940,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257940',4906941,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257941',4906942,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257941',4906943,'3003','463',646337.73,650324.45,0.00,0.00,3986.72,2856945.34,0.00,0.00,0.00),('1','198','1017','257941',4906944,'3004','463',2100.74,2100.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257941',4906945,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257941',4906946,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257941',4906947,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257941',4906948,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257941',4906949,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257942',4906950,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257942',4906951,'3003','463',650324.45,652766.15,0.00,0.00,2441.70,1770216.04,0.00,0.00,0.00),('1','198','1017','257942',4906952,'3004','463',2100.74,2105.74,0.00,0.00,5.00,3680.00,0.00,0.00,0.00),('1','198','1017','257942',4906953,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257942',4906954,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257942',4906955,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257942',4906956,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257942',4906957,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257943',4906958,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257943',4906959,'3003','463',652766.15,653033.58,0.00,0.00,267.43,195777.30,0.00,0.00,0.00),('1','198','1017','257943',4906960,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257943',4906961,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257943',4906962,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257943',4906963,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257943',4906964,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257943',4906965,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257944',4906966,'3002','463',648103.84,648103.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257944',4906967,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257944',4906968,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257944',4906969,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257944',4906970,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257944',4906971,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257944',4906972,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257944',4906973,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257945',4906974,'3002','463',648103.84,649945.10,0.00,0.00,1841.26,1337118.94,0.00,0.00,0.00),('1','198','1017','257945',4906975,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257945',4906976,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257945',4906977,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257945',4906978,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257945',4906979,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257945',4906980,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257945',4906981,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257946',4906982,'3002','463',649945.10,652291.17,0.00,0.00,2346.07,1709966.90,0.00,0.00,0.00),('1','198','1016','257946',4906983,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257946',4906984,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257946',4906985,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257946',4906986,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257946',4906987,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257946',4906988,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257946',4906989,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257947',4906990,'3002','463',652291.17,654894.48,0.00,0.00,2603.31,1891659.08,0.00,0.00,0.00),('1','198','1017','257947',4906991,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257947',4906992,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257947',4906993,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257947',4906994,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257947',4906995,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257947',4906996,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257947',4906997,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257948',4906998,'3002','463',654894.48,656940.38,0.00,0.00,2045.90,1487085.02,0.00,0.00,0.00),('1','198','1017','257948',4906999,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257948',4907000,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257948',4907001,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257948',4907002,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257948',4907003,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257948',4907004,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257948',4907005,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257949',4907006,'3002','463',656940.38,660372.90,0.00,0.00,3432.52,2481236.94,0.00,0.00,0.00),('1','198','1017','257949',4907007,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257949',4907008,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257949',4907009,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257949',4907010,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257949',4907011,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257949',4907012,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257949',4907013,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257950',4907014,'3002','463',660372.90,662285.44,0.00,0.00,1912.54,1392562.18,0.00,0.00,0.00),('1','198','1017','257950',4907015,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257950',4907016,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257950',4907017,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257950',4907018,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257950',4907019,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257950',4907020,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257950',4907021,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257951',4907022,'3002','463',662285.44,664629.78,0.00,0.00,2344.34,1678134.28,0.00,0.00,0.00),('1','198','1017','257951',4907023,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257951',4907024,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257951',4907025,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257951',4907026,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257951',4907027,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257951',4907028,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257951',4907029,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257952',4907030,'3002','463',664629.78,667141.23,0.00,0.00,2511.45,1796396.20,0.00,0.00,0.00),('1','198','1017','257952',4907031,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257952',4907032,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257952',4907033,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257952',4907034,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257952',4907035,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257952',4907036,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257952',4907037,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257953',4907038,'3002','463',667141.23,669089.83,0.00,0.00,1948.60,1400582.76,0.00,0.00,0.00),('1','198','1017','257953',4907039,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257953',4907040,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257953',4907041,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257953',4907042,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257953',4907043,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257953',4907044,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257953',4907045,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257954',4907046,'3002','463',669089.83,672634.53,0.00,0.00,3544.70,2501094.20,0.00,0.00,0.00),('1','198','1017','257954',4907047,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257954',4907048,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257954',4907049,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257954',4907050,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257954',4907051,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257954',4907052,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257954',4907053,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257955',4907054,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257955',4907055,'3003','463',653033.58,653033.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257955',4907056,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257955',4907057,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257955',4907058,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257955',4907059,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257955',4907060,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257955',4907061,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257956',4907062,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257956',4907063,'3003','463',653033.58,655583.96,0.00,0.00,2550.38,1824722.30,0.00,0.00,0.00),('1','198','1017','257956',4907064,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257956',4907065,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257956',4907066,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257956',4907067,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257956',4907068,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257956',4907069,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257957',4907070,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257957',4907071,'3003','463',655583.96,661525.12,0.00,0.00,5941.16,4236002.36,0.00,0.00,0.00),('1','198','1017','257957',4907072,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257957',4907073,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257957',4907074,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257957',4907075,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257957',4907076,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257957',4907077,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257958',4907078,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257958',4907079,'3003','463',661525.12,663888.85,0.00,0.00,2363.73,1687168.98,0.00,0.00,0.00),('1','198','1017','257958',4907080,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257958',4907081,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257958',4907082,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257958',4907083,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257958',4907084,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257958',4907085,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257959',4907086,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257959',4907087,'3003','463',663888.85,666490.13,0.00,0.00,2601.28,1851207.58,0.00,0.00,0.00),('1','198','1017','257959',4907088,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257959',4907089,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257959',4907090,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257959',4907091,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257959',4907092,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257959',4907093,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257960',4907094,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257960',4907095,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257960',4907096,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257960',4907097,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257960',4907098,'3003','463',666490.13,669297.88,0.00,0.00,2807.75,2003563.88,0.00,0.00,0.00),('1','198','1017','257960',4907099,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257960',4907100,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257960',4907101,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257961',4907102,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257961',4907103,'3003','463',669297.88,671332.36,0.00,0.00,2034.48,1449604.04,0.00,0.00,0.00),('1','198','1017','257961',4907104,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257961',4907105,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257961',4907106,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257961',4907107,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257961',4907108,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257961',4907109,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257962',4907110,'3002','463',672634.53,672634.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257962',4907111,'3003','463',671332.36,671332.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257962',4907112,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257962',4907113,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257962',4907114,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257962',4907115,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257962',4907116,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257962',4907117,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257963',4907118,'3002','463',672634.53,674366.12,0.00,0.00,1731.59,1234004.22,0.00,0.00,0.00),('1','198','1017','257963',4907119,'3003','463',671332.36,671332.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257963',4907120,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257963',4907121,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257963',4907122,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257963',4907123,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257963',4907124,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257963',4907125,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257964',4907126,'3002','463',674366.12,678439.32,0.00,0.00,4073.20,2918577.66,0.00,0.00,0.00),('1','198','1017','257964',4907127,'3003','463',671332.36,671332.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257964',4907128,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257964',4907129,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257964',4907130,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257964',4907131,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257964',4907132,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257964',4907133,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257965',4907134,'3002','463',678439.32,686893.94,0.00,0.00,8454.62,6022157.04,0.00,0.00,0.00),('1','198','1017','257965',4907135,'3003','463',671332.36,671332.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257965',4907136,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257965',4907137,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257965',4907138,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257965',4907139,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257965',4907140,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257965',4907141,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257966',4907142,'3002','463',686893.94,687768.79,0.00,0.00,874.85,614663.76,0.00,0.00,0.00),('1','198','1017','257966',4907143,'3003','463',671332.36,671332.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257966',4907144,'3004','463',2105.74,2105.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257966',4907145,'3005','463',238.05,238.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1017','257966',4907146,'3006','463',17.00,17.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257966',4907147,'3007','463',225.16,225.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257966',4907148,'3008','463',6.00,6.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','198','1016','257966',4907149,'3009','463',30.00,30.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730098 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','198','236677','463',582.00,616.00,0.00,1633.24,950545.68,991274.92,40729.24,675792),('1','198','236739','463',582.00,616.00,0.00,1699.48,989097.36,1036679.68,47582.32,675940),('1','198','236962','463',582.00,616.00,0.00,1719.23,1000591.86,1047405.68,46813.82,676519),('1','198','237167','463',582.00,616.00,0.00,1586.16,923145.12,960891.48,37746.36,677044),('1','198','237369','463',582.00,616.00,0.00,3112.92,1811719.44,1887444.72,75725.28,677574),('1','198','237598','463',582.00,616.00,0.00,4929.27,2868835.14,2987530.32,118695.18,678167),('1','198','237862','463',582.00,616.00,0.00,3734.73,2173612.86,2265151.68,91538.82,678859),('1','198','238127','463',582.00,616.00,0.00,4442.83,2585727.06,2692000.00,106272.94,679534),('1','198','238336','463',582.00,616.00,0.00,460.10,267778.20,279881.60,12103.40,680081),('1','198','238457','463',582.00,616.00,0.00,2248.78,1331227.76,1361884.48,30656.72,680386),('1','198','238592','463',592.00,616.00,0.00,5957.06,3526579.52,3603919.76,77340.24,680758),('1','198','238811','463',592.00,616.00,0.00,3972.79,2351891.68,2403288.64,51396.96,681319),('1','198','239075','463',592.00,616.00,0.00,5664.11,3353153.12,3425908.40,72755.28,681987),('1','198','239298','463',592.00,616.00,0.00,4734.31,2802711.52,2865706.96,62995.44,682573),('1','198','239509','463',592.00,616.00,0.00,419.78,248509.76,254684.48,6174.72,683131),('1','198','239611','463',592.00,616.00,0.00,0.00,0.00,0.00,0.00,683387),('1','198','239624','463',616.00,616.00,0.00,2282.65,1374155.30,1395961.84,21806.54,683422),('1','198','239756','463',602.00,632.00,0.00,2604.73,1568047.46,1620019.76,51972.30,683778),('1','198','239993','463',602.00,632.00,0.00,1930.22,1161992.44,1202079.04,40086.60,684383),('1','198','240179','463',602.00,632.00,0.00,1814.57,1092371.14,1126822.24,34451.10,684873),('1','198','240427','463',0.00,632.00,0.00,2098.99,0.00,1283553.92,1283553.92,685523),('1','198','240684','463',0.00,632.00,0.00,4672.94,0.00,2863250.08,2863250.08,686140),('1','198','240957','463',0.00,632.00,0.00,3101.18,0.00,1894265.68,1894265.68,686879),('1','198','241224','463',0.00,632.00,0.00,1996.57,0.00,1224376.40,1224376.40,687566),('1','198','241470','463',0.00,632.00,0.00,3282.22,0.00,2008243.04,2008243.04,688233),('1','198','241741','463',0.00,632.00,0.00,579.21,21088.06,357084.72,335996.66,688935),('1','198','241823','463',602.00,632.00,0.00,3039.90,1830019.80,1857160.80,27141.00,689144),('1','198','242024','463',602.00,632.00,0.00,3315.98,1996219.96,2026987.36,30767.40,689666),('1','198','242194','463',602.00,632.00,0.00,3978.15,2394846.30,2432854.80,38008.50,690117),('1','198','242413','463',602.00,632.00,0.00,1885.67,1135173.34,1158371.44,23198.10,690686),('1','198','242679','463',602.00,632.00,0.00,3843.83,2313985.66,2354593.36,40607.70,691364),('1','198','242908','463',602.00,632.00,0.00,3110.22,1872352.44,1910232.72,37880.28,691978),('1','198','243145','463',602.00,632.00,0.00,3550.66,2137497.32,2177911.60,40414.28,692585),('1','198','243368','463',602.00,632.00,0.00,1732.34,1042868.68,1064781.76,21913.08,693183),('1','198','243513','463',602.00,632.00,0.00,0.00,0.00,0.00,0.00,693555),('1','198','243519','463',0.00,632.00,0.00,1092.44,657648.88,668630.08,10981.20,693570),('1','198','243629','463',602.00,632.00,0.00,2286.18,1376280.36,1408653.76,32373.40,693837),('1','198','243830','463',602.00,632.00,0.00,2690.69,1619795.38,1650661.60,30866.22,694365),('1','198','244037','463',602.00,632.00,0.00,4309.92,2594571.84,2635270.16,40698.32,694903),('1','198','244312','463',602.00,632.00,0.00,1842.54,1109209.08,1135905.28,26696.20,695610),('1','198','244517','463',602.00,632.00,50.00,2503.92,1507359.84,1533887.48,26527.64,696150),('1','198','244758','463',602.00,632.00,0.00,2032.52,1223577.04,1251047.00,27469.96,696776),('1','198','244956','463',600.00,624.00,0.00,3640.94,2184564.00,2197818.56,13254.56,697309),('1','198','245222','463',600.00,624.00,0.00,2274.82,1364892.00,1381139.60,16247.60,697972),('1','198','245440','463',600.00,624.00,0.00,1479.20,887520.00,898068.80,10548.80,698536),('1','198','245671','463',600.00,624.00,0.00,0.00,0.00,0.00,0.00,699138),('1','198','245690','463',602.00,624.00,0.00,796.83,479691.66,478098.00,-1593.66,699177),('1','198','245693','463',602.00,624.00,0.00,2485.85,1496481.70,1505603.90,9122.20,699182),('1','198','245949','463',602.00,624.00,0.00,2300.30,1384780.60,1338168.80,-46611.80,699863),('1','198','246189','463',602.00,616.00,0.00,3300.52,1986913.04,1906947.86,-79965.18,700471),('1','198','246461','463',602.00,616.00,0.00,2679.86,1613275.72,1554565.96,-58709.76,701197),('1','198','246682','463',602.00,616.00,0.00,1720.52,1035753.04,1017220.32,-18532.72,701798),('1','198','246941','463',602.00,616.00,0.00,3357.26,2021070.52,1936400.66,-84669.86,702438),('1','198','247162','463',602.00,616.00,0.00,2238.33,1177741.58,1292072.88,114331.30,703026),('1','198','247397','463',526.00,608.00,0.00,2998.80,1577368.80,1722394.40,145025.60,703614),('1','198','247648','463',526.00,608.00,0.00,2533.89,1332826.14,1451654.92,118828.78,704287),('1','198','247928','463',526.00,608.00,0.00,0.00,0.00,0.00,0.00,704988),('1','198','247937','463',552.00,608.00,0.00,2293.81,1266183.12,1324989.78,58806.66,705003),('1','198','248167','463',552.00,608.00,0.00,2499.41,1379674.32,1438764.46,59090.14,705606),('1','198','248420','463',552.00,608.00,0.00,2396.54,1322890.08,1384321.32,61431.24,706260),('1','198','248636','463',552.00,608.00,0.00,1840.86,1016154.72,1064648.88,48494.16,706823),('1','198','248873','463',552.00,608.00,0.00,2761.68,1524447.36,1557966.10,33518.74,707429),('1','198','249106','463',552.00,600.00,0.00,4104.44,2265650.88,2303036.55,37385.67,708029),('1','198','249345','463',552.00,600.00,0.00,2459.15,1357450.80,1388595.60,31144.80,708633),('1','198','249573','463',552.00,600.00,0.00,4575.87,2525880.24,2572917.00,47036.76,709226),('1','198','249853','463',552.00,600.00,0.00,1396.63,770939.76,807892.00,36952.24,709935),('1','198','250064','463',552.00,600.00,0.00,0.00,0.00,0.00,0.00,710488),('1','198','250105','463',530.00,600.00,0.00,4886.15,2589659.50,2719371.32,129711.82,710578),('1','198','250327','463',530.00,568.00,0.00,3677.20,1948916.00,2018970.10,70054.10,711154),('1','198','250562','463',530.00,568.00,0.00,3083.33,1634164.90,1696509.48,62344.58,711743),('1','198','250804','463',530.00,568.00,0.00,2588.15,1371719.50,1424170.20,52450.70,712374),('1','198','251021','463',530.00,568.00,0.00,3831.34,2030610.20,2102314.88,71704.68,712934),('1','198','251285','463',530.00,568.00,0.00,3358.72,1780121.60,1843135.80,63014.20,713615),('1','198','251515','463',530.00,568.00,0.00,2844.23,1506884.78,1564656.64,57771.86,714226),('1','198','251751','463',522.00,568.00,0.00,2768.43,1445120.46,1526160.48,81040.02,714854),('1','198','252000','463',522.00,568.00,0.00,3473.33,1813078.26,1907605.44,94527.18,715495),('1','198','252271','463',522.00,568.00,0.00,2107.71,1100224.62,1158784.96,58560.34,716192),('1','198','252479','463',522.00,568.00,0.00,1482.68,773958.96,821961.92,48002.96,716739),('1','198','252702','463',522.00,568.00,0.00,3471.32,1812029.04,1899019.40,86990.36,717330),('1','198','252962','463',522.00,560.00,0.00,2947.03,1538349.66,1620359.64,82009.98,718000),('1','198','253222','463',522.00,560.00,0.00,1746.45,911646.90,962994.12,51347.22,718670),('1','198','253465','463',522.00,560.00,0.00,2446.56,1277104.32,1340008.00,62903.68,719315),('1','198','253697','463',522.00,560.00,0.00,1733.08,904667.76,956164.80,51497.04,719920),('1','198','253946','463',522.00,560.00,0.00,1978.59,1032823.98,1085278.40,52454.42,720560),('1','198','254225','463',522.00,560.00,0.00,0.00,0.00,0.00,0.00,721263),('1','198','254250','463',522.00,560.00,0.00,1856.90,978586.30,1019214.00,40627.70,721324),('1','198','254444','463',527.00,560.00,0.00,2824.40,1488458.80,1549741.12,61282.32,721854),('1','198','254713','463',527.00,560.00,0.00,2122.65,1118636.55,1166833.12,48196.57,722516),('1','198','254932','463',527.00,560.00,0.00,3228.49,1701414.23,1770152.40,68738.17,723093),('1','198','255197','463',527.00,560.00,0.00,2000.85,1054447.95,1099711.52,45263.57,723764),('1','198','255465','463',527.00,560.00,0.00,2631.41,1386753.07,1443858.56,57105.49,724430),('1','198','255706','463',527.00,560.00,0.00,2656.92,1400196.84,1452644.96,52448.12,725032),('1','198','255974','463',527.00,560.00,0.00,1847.22,973484.94,1017971.20,44486.26,725700),('1','198','256217','463',527.00,560.00,0.00,3083.34,1624920.18,1691727.40,66807.22,726298),('1','198','256481','463',527.00,560.00,0.00,1660.00,874820.00,914498.42,39678.42,726996),('1','198','256722','463',527.00,560.00,0.00,2375.72,1252004.44,1302696.52,50692.08,727621),('1','198','256976','463',527.00,560.00,0.00,2502.76,1318954.52,1374207.84,55253.32,728274),('1','198','257300','463',527.00,560.00,0.00,3239.00,1706953.00,1775558.00,68605.00,729111),('1','198','257485','463',527.00,560.00,0.00,2844.22,1498903.94,1560699.20,61795.26,729616),('1','198','257486','463',527.00,560.00,0.00,2655.67,1399538.09,1461160.72,61622.63,729617),('1','198','257487','463',527.00,560.00,0.00,2284.73,1204052.71,1261044.80,56992.09,729618),('1','198','257488','463',527.00,560.00,0.00,3013.91,1588330.57,1654921.60,66591.03,729619),('1','198','257489','463',527.00,560.00,0.00,2097.07,1105155.89,1158121.92,52966.03,729620),('1','198','257490','463',527.00,560.00,0.00,2877.00,1516179.00,1584216.96,68037.96,729621),('1','198','257491','463',527.00,560.00,0.00,2330.20,1228015.40,1285662.40,57647.00,729622),('1','198','257492','463',527.00,560.00,0.00,3095.11,1631122.97,1696694.20,65571.23,729623),('1','198','257493','463',527.00,560.00,0.00,2106.67,1110215.09,1157870.72,47655.63,729624),('1','198','257494','463',527.00,560.00,0.00,2350.41,1238666.07,1294915.12,56249.05,729625),('1','198','257495','463',527.00,560.00,0.00,2035.71,1072819.17,1122205.60,49386.43,729626),('1','198','257496','463',527.00,560.00,0.00,3090.95,1628930.65,1694745.44,65814.79,729627),('1','198','257497','463',527.00,560.00,0.00,1947.58,1026374.66,1068663.88,42289.22,729628),('1','198','257498','463',527.00,560.00,0.00,2042.26,1076271.02,1124621.60,48350.58,729629),('1','198','257499','463',527.00,560.00,0.00,3082.19,1624314.13,1696163.20,71849.07,729630),('1','198','257500','463',527.00,560.00,0.00,1502.06,791585.62,832347.20,40761.58,729631),('1','198','257501','463',527.00,560.00,0.00,1128.71,594830.17,627949.60,33119.43,729632),('1','198','257502','463',527.00,560.00,0.00,2224.95,1154664.95,1218531.44,63866.49,729633),('1','198','257503','463',517.00,560.00,0.00,1251.44,646994.48,690604.32,43609.84,729634),('1','198','257504','463',517.00,560.00,0.00,1679.17,868130.89,927519.20,59388.31,729635),('1','198','257505','463',517.00,560.00,0.00,2183.67,1128957.39,1199151.20,70193.81,729636),('1','198','257506','463',517.00,560.00,0.00,1571.64,812537.88,867008.16,54470.28,729637),('1','198','257507','463',517.00,560.00,0.00,1472.10,761075.70,814766.24,53690.54,729638),('1','198','257508','463',517.00,560.00,0.00,2546.89,1316742.13,1396125.76,79383.63,729639),('1','198','257509','463',517.00,560.00,0.00,1750.92,905225.64,964491.20,59265.56,729640),('1','198','257510','463',517.00,560.00,0.00,1804.21,932776.57,998692.96,65916.39,729641),('1','198','257511','463',517.00,560.00,0.00,2466.78,1275325.26,1349800.80,74475.54,729642),('1','198','257512','463',517.00,560.00,0.00,1889.59,976918.03,1040962.40,64044.37,729643),('1','198','257513','463',517.00,560.00,0.00,1402.53,725108.01,774811.04,49703.03,729644),('1','198','257514','463',517.00,560.00,0.00,1882.03,973009.51,1033636.24,60626.73,729645),('1','198','257515','463',517.00,560.00,0.00,4986.35,2577942.95,2765210.00,187267.05,729646),('1','198','257516','463',517.00,560.00,0.00,2538.47,1312388.99,1398568.80,86179.81,729647),('1','198','257517','463',517.00,560.00,0.00,3285.50,1698603.50,1798971.68,100368.18,729648),('1','198','257518','463',517.00,560.00,0.00,2832.36,1464330.12,1553026.48,88696.36,729649),('1','198','257519','463',517.00,560.00,0.00,1769.06,914604.02,981687.60,67083.58,729650),('1','198','257520','463',517.00,560.00,0.00,2698.96,1395362.32,1481423.44,86061.12,729651),('1','198','257521','463',517.00,560.00,0.00,2010.18,1039263.06,1111996.00,72732.94,729652),('1','198','257522','463',517.00,560.00,0.00,2838.70,1467607.90,1560479.52,92871.62,729653),('1','198','257523','463',517.00,560.00,0.00,1405.60,726695.20,759024.00,32328.80,729654),('1','198','257524','463',517.00,560.00,0.00,1106.33,571972.61,702951.20,130978.59,729655),('1','198','257525','463',517.00,640.00,0.00,1342.42,694031.14,854418.80,160387.66,729656),('1','198','257526','463',517.00,640.00,0.00,1453.75,751588.75,918810.00,167221.25,729657),('1','198','257527','463',517.00,640.00,0.00,1493.23,771999.91,945100.20,173100.29,729658),('1','198','257528','463',517.00,640.00,0.00,1494.47,772640.99,943570.80,170929.81,729659),('1','198','257529','463',517.00,640.00,0.00,1457.73,753646.41,923790.20,170143.79,729660),('1','198','257530','463',517.00,640.00,0.00,1285.85,664784.45,861316.80,196532.35,729661),('1','198','257531','463',517.00,680.00,0.00,1323.08,684032.36,888516.80,204484.44,729662),('1','198','257532','463',517.00,680.00,0.00,1031.20,533130.40,693544.00,160413.60,729663),('1','198','257533','463',517.00,640.00,0.00,1363.27,704810.59,867911.68,163101.09,729664),('1','198','257534','463',517.00,640.00,0.00,1350.02,697960.34,854124.80,156164.46,729665),('1','198','257535','463',517.00,640.00,0.00,1709.53,883827.01,1069919.20,186092.19,729666),('1','198','257536','463',517.00,640.00,0.00,1271.38,657303.46,808384.00,151080.54,729667),('1','198','257537','463',517.00,640.00,0.00,1060.53,548294.01,673870.56,125576.55,729668),('1','198','257538','463',517.00,640.00,0.00,1917.57,991383.69,1211442.80,220059.11,729669),('1','198','257539','463',517.00,640.00,0.00,1656.11,856208.87,1045534.40,189325.53,729670),('1','198','257540','463',517.00,640.00,0.00,2206.71,1140869.07,1385995.20,245126.13,729671),('1','198','257541','463',517.00,640.00,0.00,1662.27,1017309.24,1044189.12,26879.88,729672),('1','198','257542','463',612.00,640.00,0.00,1218.16,745513.92,826194.20,80680.28,729673),('1','198','257543','463',612.00,680.00,0.00,1642.11,1004971.32,1106048.00,101076.68,729674),('1','198','257544','463',612.00,680.00,0.00,1510.94,924695.28,1017535.26,92839.98,729675),('1','198','257545','463',612.00,680.00,0.00,1509.30,923691.60,1011511.22,87819.62,729676),('1','198','257546','463',517.00,640.00,0.00,2877.32,1487574.44,1816067.84,328493.40,729677),('1','198','257547','463',517.00,640.00,0.00,3760.94,1944405.98,2389086.80,444680.82,729678),('1','198','257548','463',517.00,640.00,0.00,5771.21,2983715.57,3665887.28,682171.71,729679),('1','198','257549','463',517.00,640.00,0.00,3672.13,1898491.21,2271376.96,372885.75,729680),('1','198','257550','463',517.00,640.00,0.00,1015.88,528624.26,630663.20,102038.94,729681),('1','198','257551','463',612.00,640.00,0.00,3693.06,2260152.72,2315932.80,55780.08,729682),('1','198','257552','463',612.00,640.00,0.00,4979.52,3047466.24,3101654.40,54188.16,729683),('1','198','257553','463',612.00,640.00,0.00,2219.09,1358083.08,1390037.60,31954.52,729684),('1','198','257554','463',612.00,640.00,0.00,3097.35,1895578.20,1934945.76,39367.56,729685),('1','198','257555','463',612.00,640.00,0.00,2761.12,1689805.44,1724036.80,34231.36,729686),('1','198','257556','463',612.00,640.00,0.00,3653.38,2235868.56,2270490.88,34622.32,729687),('1','198','257557','463',612.00,640.00,0.00,3073.84,1881190.08,1924274.32,43084.24,729688),('1','198','257558','463',612.00,640.00,0.00,888.97,544049.64,558248.80,14199.16,729689),('1','198','257559','463',612.00,640.00,0.00,1161.64,710923.68,725189.92,14266.24,729690),('1','198','257560','463',612.00,640.00,0.00,2042.89,1250248.68,1280404.24,30155.56,729691),('1','198','257561','463',612.00,640.00,0.00,1702.80,1042113.60,1070169.60,28056.00,729692),('1','198','257562','463',612.00,640.00,0.00,2013.17,1232060.04,1259183.60,27123.56,729693),('1','198','257563','463',612.00,640.00,0.00,2657.08,1626132.96,1665107.68,38974.72,729694),('1','198','257564','463',612.00,640.00,0.00,1999.12,1223461.44,1256792.80,33331.36,729695),('1','198','257565','463',612.00,640.00,0.00,1117.46,683885.52,708614.48,24728.96,729696),('1','198','257566','463',612.00,640.00,0.00,1244.74,761780.88,788101.60,26320.72,729697),('1','198','257567','463',612.00,636.00,0.00,1762.86,1078870.32,1106823.96,27953.64,729698),('1','198','257568','463',612.00,636.00,0.00,1212.20,741866.40,765591.20,23724.80,729699),('1','198','257569','463',612.00,636.00,0.00,1481.12,906445.44,931177.56,24732.12,729700),('1','198','257570','463',612.00,636.00,0.00,1243.20,760838.40,782128.20,21289.80,729701),('1','198','257571','463',612.00,636.00,0.00,1811.62,1108711.44,1134524.32,25812.88,729702),('1','198','257572','463',612.00,636.00,0.00,1607.12,983557.44,1004899.24,21341.80,729703),('1','198','257573','463',612.00,636.00,0.00,1243.86,761230.52,769553.00,8322.48,729704),('1','198','257574','463',602.00,636.00,0.00,1005.59,605365.18,631030.24,25665.06,729705),('1','198','257575','463',602.00,636.00,0.00,1729.38,1041086.76,1085970.68,44883.92,729706),('1','198','257576','463',602.00,636.00,0.00,2467.47,1485416.94,1535339.62,49922.68,729707),('1','198','257577','463',602.00,636.00,0.00,1188.22,715308.44,750183.28,34874.84,729708),('1','198','257578','463',602.00,636.00,0.00,1669.26,1004894.52,1047986.70,43092.18,729709),('1','198','257579','463',602.00,636.00,0.00,2079.63,1251937.26,1301652.28,49715.02,729710),('1','198','257580','463',602.00,636.00,0.00,2079.51,1251865.02,1312475.64,60610.62,729711),('1','198','257581','463',602.00,636.00,0.00,2628.96,1582633.92,1651415.56,68781.64,729712),('1','198','257582','463',602.00,636.00,0.00,2244.76,1351345.52,1404725.72,53380.20,729713),('1','198','257583','463',602.00,636.00,0.00,1548.82,932389.64,968161.00,35771.36,729714),('1','198','257584','463',602.00,636.00,0.00,1152.92,694057.84,727669.12,33611.28,729715),('1','198','257585','463',602.00,636.00,0.00,1592.02,958396.04,1003515.72,45119.68,729716),('1','198','257586','463',602.00,636.00,0.00,2336.14,1406356.28,1462252.52,55896.24,729717),('1','198','257587','463',602.00,636.00,0.00,617.83,371933.66,392939.88,21006.22,729718),('1','198','257588','463',602.00,636.00,0.00,961.27,578684.54,607066.72,28382.18,729719),('1','198','257589','463',602.00,636.00,0.00,1323.01,796452.02,834416.36,37964.34,729720),('1','198','257590','463',602.00,628.00,0.00,2614.01,1573634.02,1613742.20,40108.18,729721),('1','198','257591','463',602.00,628.00,0.00,1975.02,1188962.04,1222254.96,33292.92,729722),('1','198','257592','463',602.00,628.00,0.00,2395.79,1442265.58,1477196.12,34930.54,729723),('1','198','257593','463',602.00,628.00,0.00,1368.29,823710.58,848566.52,24855.94,729724),('1','198','257594','463',602.00,628.00,0.00,1455.91,876457.82,905897.08,29439.26,729725),('1','198','257595','463',602.00,628.00,0.00,1270.09,764594.18,790621.00,26026.82,729726),('1','198','257596','463',602.00,696.00,0.00,870.90,524281.80,597757.80,73476.00,729727),('1','198','257597','463',602.00,696.00,0.00,1249.07,751940.14,855651.12,103710.98,729728),('1','198','257598','463',602.00,696.00,0.00,1012.02,609236.04,701413.52,92177.48,729729),('1','198','257599','463',602.00,696.00,0.00,1167.57,702877.14,800114.24,97237.10,729730),('1','198','257600','463',602.00,696.00,0.00,1110.58,668569.16,766547.16,97978.00,729731),('1','198','257601','463',602.00,696.00,0.00,1130.57,680603.14,704009.96,23406.82,729732),('1','198','257602','463',602.00,628.00,0.00,1434.67,863671.34,888952.60,25281.26,729733),('1','198','257603','463',602.00,628.00,0.00,953.31,573892.62,592692.12,18799.50,729734),('1','198','257604','463',602.00,628.00,0.00,1645.79,990765.58,1010612.12,19846.54,729735),('1','198','257605','463',602.00,628.00,0.00,500.02,301012.04,309564.64,8552.60,729736),('1','198','257606','463',602.00,628.00,0.00,1330.05,800690.10,824531.40,23841.30,729737),('1','198','257607','463',602.00,628.00,0.00,46.00,27692.00,28888.00,1196.00,729738),('1','198','257608','463',602.00,628.00,0.00,104.99,63203.98,66462.56,3258.58,729739),('1','198','257609','463',602.00,690.00,0.00,834.43,502326.86,574143.66,71816.80,729740),('1','198','257610','463',602.00,690.00,0.00,1095.29,659364.58,752045.10,92680.52,729741),('1','198','257611','463',602.00,690.00,0.00,1093.81,704413.64,750335.16,45921.52,729742),('1','198','257612','463',644.00,690.00,0.00,1162.11,748398.84,800436.56,52037.72,729743),('1','198','257613','463',644.00,690.00,0.00,1188.13,765155.72,815341.84,50186.12,729744),('1','198','257614','463',644.00,688.00,0.00,1150.31,740799.64,789543.92,48744.28,729745),('1','198','257615','463',644.00,688.00,0.00,1122.54,745366.56,762904.20,17537.64,729746),('1','198','257616','463',664.00,680.00,0.00,731.74,485875.36,494820.20,8944.84,729747),('1','198','257617','463',664.00,680.00,0.00,1191.33,791043.12,807386.40,16343.28,729748),('1','198','257618','463',664.00,680.00,0.00,1531.99,1017241.36,1037270.84,20029.48,729749),('1','198','257619','463',664.00,680.00,0.00,1381.96,917621.44,939038.72,21417.28,729750),('1','198','257620','463',664.00,680.00,0.00,1099.41,730008.24,746257.08,16248.84,729751),('1','198','257621','463',664.00,680.00,0.00,1431.86,950755.04,969299.80,18544.76,729752),('1','198','257622','463',664.00,680.00,0.00,1089.63,723514.32,738707.04,15192.72,729753),('1','198','257623','463',664.00,680.00,0.00,1345.69,893538.16,910685.66,17147.50,729754),('1','198','257624','463',664.00,680.00,0.00,1318.07,875198.48,892216.36,17017.88,729755),('1','198','257625','463',664.00,680.00,0.00,922.41,612480.24,660910.40,48430.16,729756),('1','198','257626','463',664.00,720.00,0.00,634.51,421314.64,455087.20,33772.56,729757),('1','198','257627','463',664.00,720.00,0.00,783.67,520356.88,563716.80,43359.92,729758),('1','198','257628','463',664.00,720.00,0.00,1437.33,954387.12,1024844.80,70457.68,729759),('1','198','257629','463',664.00,720.00,0.00,1216.98,808074.72,873607.00,65532.28,729760),('1','198','257630','463',664.00,720.00,0.00,1152.84,765485.76,827954.80,62469.04,729761),('1','198','257631','463',664.00,720.00,0.00,1170.93,777497.52,839599.60,62102.08,729762),('1','198','257632','463',664.00,720.00,0.00,1422.49,944533.36,1018995.80,74462.44,729763),('1','198','257633','463',664.00,720.00,0.00,1103.63,732810.32,791713.60,58903.28,729764),('1','198','257634','463',664.00,720.00,0.00,1346.88,894328.32,967489.20,73160.88,729765),('1','198','257635','463',664.00,720.00,0.00,780.65,518351.60,560928.00,42576.40,729766),('1','198','257636','463',664.00,720.00,0.00,1565.62,1039571.68,1120616.40,81044.72,729767),('1','198','257637','463',664.00,720.00,0.00,1296.87,861121.68,930316.40,69194.72,729768),('1','198','257638','463',664.00,720.00,0.00,1035.18,687359.52,744959.60,57600.08,729769),('1','198','257639','463',664.00,720.00,0.00,1072.67,712252.88,771702.40,59449.52,729770),('1','198','257640','463',664.00,720.00,0.00,1054.71,700327.44,757041.20,56713.76,729771),('1','198','257641','463',664.00,720.00,0.00,1213.40,805697.60,870568.00,64870.40,729772),('1','198','257642','463',664.00,720.00,0.00,1040.35,690792.40,747746.20,56953.80,729773),('1','198','257643','463',664.00,720.00,0.00,1273.85,845836.40,916972.00,71135.60,729774),('1','198','257644','463',664.00,720.00,0.00,1343.57,892130.48,964370.40,72239.92,729775),('1','198','257645','463',664.00,720.00,0.00,1028.22,682738.08,740068.40,57330.32,729776),('1','198','257646','463',664.00,720.00,0.00,1351.99,897721.36,972880.20,75158.84,729777),('1','198','257647','463',664.00,720.00,0.00,608.19,403838.16,437446.80,33608.64,729778),('1','198','257648','463',664.00,720.00,0.00,619.06,428389.52,444913.20,16523.68,729779),('1','198','257649','463',692.00,720.00,0.00,2115.51,1463932.92,1516848.60,52915.68,729780),('1','198','257650','463',692.00,720.00,0.00,1108.27,766922.84,797204.40,30281.56,729781),('1','198','257651','463',692.00,720.00,0.00,1558.97,1078807.24,1119892.80,41085.56,729782),('1','198','257652','463',692.00,720.00,0.00,1505.22,1041612.24,1080388.40,38776.16,729783),('1','198','257653','463',692.00,720.00,0.00,2036.84,1409493.28,1462034.80,52541.52,729784),('1','198','257654','463',692.00,720.00,0.00,2769.48,1916480.16,1985758.40,69278.24,729785),('1','198','257655','463',692.00,720.00,0.00,3996.62,2765661.04,2872269.20,106608.16,729786),('1','198','257656','463',692.00,720.00,0.00,2455.56,1699247.52,1767383.20,68135.68,729787),('1','198','257657','463',692.00,720.00,0.00,3730.51,2581512.92,2677124.40,95611.48,729788),('1','198','257658','463',692.00,720.00,0.00,2410.11,1667796.12,1696179.20,28383.08,729789),('1','198','257659','463',692.00,720.00,0.00,1131.00,782652.00,799350.00,16698.00,729790),('1','198','257660','463',692.00,720.00,0.00,1092.92,756300.64,782852.40,26551.76,729791),('1','198','257661','463',692.00,720.00,0.00,702.12,485867.04,502730.60,16863.56,729792),('1','198','257662','463',692.00,720.00,0.00,974.13,674097.96,695003.60,20905.64,729793),('1','198','257663','463',692.00,720.00,0.00,1425.73,986605.16,1018267.40,31662.24,729794),('1','198','257664','463',692.00,720.00,0.00,1889.95,1307845.40,1349072.60,41227.20,729795),('1','198','257665','463',692.00,720.00,30.00,887.41,614087.72,636425.20,22337.48,729796),('1','198','257666','463',692.00,720.00,0.00,1977.49,1368423.08,1417672.80,49249.72,729797),('1','198','257667','463',692.00,720.00,0.00,1497.39,1036193.88,1074272.80,38078.92,729798),('1','198','257668','463',692.00,720.00,0.00,2078.10,1438045.20,1481294.80,43249.60,729799),('1','198','257669','463',692.00,720.00,0.00,4908.94,3396986.48,3464866.80,67880.32,729800),('1','198','257670','463',692.00,720.00,0.00,2915.85,2017768.20,2071303.40,53535.20,729801),('1','198','257671','463',692.00,720.00,0.00,2221.68,1537402.56,1583469.60,46067.04,729802),('1','198','257672','463',692.00,720.00,0.00,304.88,210976.96,219163.60,8186.64,729803),('1','198','257673','463',692.00,720.00,0.00,928.47,642501.24,662002.60,19501.36,729804),('1','198','257674','463',692.00,720.00,0.00,1561.53,1080578.76,1109695.60,29116.84,729805),('1','198','257675','463',692.00,720.00,0.00,1467.84,1015745.28,1052414.80,36669.52,729806),('1','198','257676','463',692.00,720.00,0.00,1417.00,980564.00,1016540.00,35976.00,729807),('1','198','257677','463',692.00,720.00,0.00,1528.86,1057971.12,1098369.20,40398.08,729808),('1','198','257678','463',692.00,720.00,0.00,1770.40,1225116.80,1264770.80,39654.00,729809),('1','198','257679','463',692.00,720.00,0.00,1668.53,1154622.76,1193141.60,38518.84,729810),('1','198','257680','463',692.00,720.00,0.00,4063.70,2812080.40,2873574.00,61493.60,729811),('1','198','257681','463',692.00,720.00,0.00,1838.51,1272248.92,1316587.20,44338.28,729812),('1','198','257682','463',692.00,720.00,0.00,1716.34,1187707.28,1229672.00,41964.72,729813),('1','198','257683','463',692.00,720.00,0.00,1965.96,1360444.32,1406021.20,45576.88,729814),('1','198','257684','463',692.00,720.00,0.00,3185.71,2204511.32,2273291.20,68779.88,729815),('1','198','257685','463',692.00,720.00,0.00,334.91,231757.72,240628.40,8870.68,729816),('1','198','257686','463',692.00,720.00,0.00,2593.57,1776595.45,1849886.20,73290.75,729817),('1','198','257687','463',685.00,720.00,0.00,3176.78,2176094.30,2261253.20,85158.90,729818),('1','198','257688','463',685.00,720.00,0.00,3035.50,2079317.50,2154900.60,75583.10,729819),('1','198','257689','463',685.00,720.00,0.00,5610.71,3843336.35,3961687.00,118350.65,729820),('1','198','257690','463',685.00,720.00,0.00,1432.88,981522.80,1030963.60,49440.80,729821),('1','198','257691','463',685.00,720.00,0.00,2170.66,1486902.10,1544700.60,57798.50,729822),('1','198','257692','463',685.00,720.00,0.00,1977.28,1354436.80,1413003.00,58566.20,729823),('1','198','257693','463',685.00,720.00,0.00,1789.86,1226054.10,1281499.20,55445.10,729824),('1','198','257694','463',685.00,720.00,0.00,1975.61,1353292.85,1403387.20,50094.35,729825),('1','198','257695','463',685.00,720.00,0.00,304.53,208603.05,215581.60,6978.55,729826),('1','198','257696','463',685.00,720.00,0.00,1312.85,899302.25,940742.00,41439.75,729827),('1','198','257697','463',685.00,720.00,0.00,1699.37,1164068.45,1214946.40,50877.95,729828),('1','198','257698','463',685.00,720.00,0.00,1607.81,1101349.85,1150519.00,49169.15,729829),('1','198','257699','463',685.00,720.00,0.00,1752.40,1200394.00,1251622.60,51228.60,729830),('1','198','257700','463',685.00,720.00,0.00,3800.62,2603424.70,2679439.20,76014.50,729831),('1','198','257701','463',685.00,720.00,0.00,1670.12,1144032.20,1194467.80,50435.60,729832),('1','198','257702','463',685.00,720.00,0.00,2257.68,1546510.80,1603990.40,57479.60,729833),('1','198','257703','463',685.00,720.00,0.00,2090.39,1431917.15,1483860.80,51943.65,729834),('1','198','257704','463',685.00,720.00,0.00,2137.66,1464297.10,1522549.40,58252.30,729835),('1','198','257705','463',685.00,720.00,0.00,1820.63,1247131.55,1297612.20,50480.65,729836),('1','198','257706','463',685.00,720.00,0.00,1640.61,1123817.85,1169339.20,45521.35,729837),('1','198','257707','463',685.00,720.00,0.00,2389.57,1636855.45,1687296.20,50440.75,729838),('1','198','257708','463',685.00,720.00,0.00,1514.90,1037706.50,1068533.60,30827.10,729839),('1','198','257709','463',685.00,720.00,0.00,1889.69,1294437.65,1347736.80,53299.15,729840),('1','198','257710','463',685.00,720.00,0.00,4476.06,3066101.10,3161633.20,95532.10,729841),('1','198','257711','463',685.00,720.00,0.00,1539.64,1054653.40,1096669.40,42016.00,729842),('1','198','257712','463',685.00,720.00,0.00,2824.23,1934597.55,2000535.60,65938.05,729843),('1','198','257713','463',685.00,720.00,0.00,2475.64,1695813.40,1765279.80,69466.40,729844),('1','198','257714','463',685.00,720.00,0.00,2329.18,1595488.30,1660019.60,64531.30,729845),('1','198','257715','463',685.00,720.00,0.00,546.77,374537.45,390224.40,15686.95,729846),('1','198','257716','463',685.00,720.00,0.00,3104.21,2126383.85,2199318.40,72934.55,729847),('1','198','257717','463',685.00,720.00,0.00,3259.38,2232675.30,2314783.60,82108.30,729848),('1','198','257718','463',685.00,720.00,0.00,6267.01,4292901.85,4425964.40,133062.55,729849),('1','198','257719','463',685.00,720.00,0.00,4494.68,3078855.80,3183579.60,104723.80,729850),('1','198','257720','463',685.00,720.00,0.00,3989.43,2732759.55,2824725.80,91966.25,729851),('1','198','257721','463',685.00,720.00,0.00,4830.34,3308782.90,3403508.40,94725.50,729852),('1','198','257722','463',685.00,720.00,0.00,6749.84,4623640.40,4755265.80,131625.40,729853),('1','198','257723','463',685.00,720.00,0.00,4863.87,3331750.95,3438516.40,106765.45,729854),('1','198','257724','463',685.00,720.00,0.00,4664.08,3194894.80,3295589.40,100694.60,729855),('1','198','257725','463',685.00,720.00,0.00,3417.08,2340699.80,2418727.60,78027.80,729856),('1','198','257726','463',685.00,720.00,0.00,4123.12,2824337.20,2910444.60,86107.40,729857),('1','198','257727','463',685.00,720.00,0.00,1095.51,750424.35,767755.00,17330.65,729858),('1','198','257728','463',685.00,720.00,0.00,4478.07,3067477.95,3156979.00,89501.05,729859),('1','198','257729','463',685.00,720.00,0.00,4627.45,3169803.25,3268758.40,98955.15,729860),('1','198','257730','463',685.00,720.00,0.00,1715.41,1175055.85,1213054.60,37998.75,729861),('1','198','257731','463',685.00,720.00,0.00,1300.28,890691.80,918241.60,27549.80,729862),('1','198','257732','463',685.00,720.00,0.00,4215.70,2887754.50,2978611.20,90856.70,729863),('1','198','257733','463',685.00,720.00,0.00,5216.01,3572966.85,3673448.20,100481.35,729864),('1','198','257734','463',685.00,720.00,0.00,1818.47,1245651.95,1287608.80,41956.85,729865),('1','198','257735','463',685.00,720.00,0.00,0.00,0.00,0.00,0.00,729866),('1','198','257736','463',685.00,720.00,0.00,2100.00,1438500.00,1486483.00,47983.00,729867),('1','198','257737','463',685.00,720.00,0.00,3028.96,2074837.60,2143961.20,69123.60,729868),('1','198','257738','463',685.00,720.00,0.00,2457.89,1683654.65,1746110.80,62456.15,729869),('1','198','257739','463',685.00,720.00,0.00,2297.89,1574054.65,1635700.20,61645.55,729870),('1','198','257740','463',685.00,720.00,0.00,2080.30,1425005.50,1478790.80,53785.30,729871),('1','198','257741','463',685.00,720.00,0.00,1054.90,722606.50,748293.20,25686.70,729872),('1','198','257742','463',685.00,720.00,0.00,0.00,0.00,0.00,0.00,729873),('1','198','257743','463',685.00,720.00,0.00,1496.55,1025136.75,1062583.20,37446.45,729874),('1','198','257744','463',685.00,720.00,0.00,2380.12,1630382.20,1688196.40,57814.20,729875),('1','198','257745','463',685.00,720.00,0.00,2147.45,1471003.25,1531264.00,60260.75,729876),('1','198','257746','463',685.00,720.00,0.00,3502.43,2399164.55,2476629.60,77465.05,729877),('1','198','257747','463',685.00,720.00,0.00,334.26,228968.10,237935.60,8967.50,729878),('1','198','257748','463',677.00,720.00,0.00,2594.79,1756672.83,1838170.00,81497.17,729879),('1','198','257749','463',677.00,720.00,0.00,2222.54,1504659.58,1579962.20,75302.62,729880),('1','198','257750','463',677.00,720.00,0.00,4014.61,2717890.97,2841101.40,123210.43,729881),('1','198','257751','463',677.00,720.00,0.00,6317.02,4276622.54,4450348.20,173725.66,729882),('1','198','257752','463',677.00,720.00,0.00,3691.98,2499470.46,2618282.80,118812.34,729883),('1','198','257753','463',677.00,720.00,0.00,2341.48,1585181.96,1671875.60,86693.64,729884),('1','198','257754','463',677.00,720.00,0.00,1756.09,1188872.93,1253624.80,64751.87,729885),('1','198','257755','463',677.00,720.00,0.00,1694.77,1147359.29,1212436.60,65077.31,729886),('1','198','257756','463',677.00,720.00,0.00,0.00,0.00,0.00,0.00,729887),('1','198','257757','463',677.00,720.00,0.00,581.68,393797.36,411057.80,17260.44,729888),('1','198','257758','463',677.00,720.00,0.00,3007.43,2036030.11,2133399.60,97369.49,729889),('1','198','257759','463',677.00,720.00,0.00,2156.69,1460079.13,1537046.80,76967.67,729890),('1','198','257760','463',677.00,720.00,0.00,4961.04,3358624.08,3512901.20,154277.12,729891),('1','198','257761','463',677.00,720.00,0.00,2437.06,1649889.62,1735222.80,85333.18,729892),('1','198','257762','463',677.00,720.00,0.00,2582.48,1748338.96,1842145.80,93806.84,729893),('1','198','257763','463',677.00,720.00,0.00,2050.86,1388432.22,1458126.40,69694.18,729894),('1','198','257764','463',677.00,720.00,0.00,2742.84,1856902.68,1952169.20,95266.52,729895),('1','198','257765','463',677.00,720.00,0.00,1950.19,1320278.63,1404016.80,83738.17,729896),('1','198','257766','463',677.00,720.00,0.00,2238.31,1515335.87,1592533.20,77197.33,729897),('1','198','257767','463',677.00,720.00,0.00,99.07,67070.39,71170.40,4100.01,729898),('1','198','257768','463',677.00,720.00,0.00,0.00,0.00,0.00,0.00,729899),('1','198','257769','463',677.00,720.00,0.00,2595.76,1757329.52,1842564.40,85234.88,729900),('1','198','257770','463',677.00,720.00,0.00,3285.76,2224459.52,2325073.40,100613.88,729901),('1','198','257771','463',677.00,720.00,0.00,7874.65,5331138.05,5541198.40,210060.35,729902),('1','198','257772','463',677.00,720.00,0.00,6408.50,4338554.50,4515414.00,176859.50,729903),('1','198','257773','463',677.00,720.00,0.00,4603.53,3116589.81,3236924.60,120334.79,729904),('1','198','257774','463',677.00,720.00,0.00,0.00,0.00,0.00,0.00,729905),('1','198','257775','463',677.00,720.00,0.00,4443.46,3008222.42,3167612.20,159389.78,729906),('1','198','257776','463',677.00,720.00,0.00,1577.05,1067662.85,1123878.70,56215.85,729907),('1','198','257777','463',677.00,730.00,0.00,3398.25,2300615.25,2451019.20,150403.95,729908),('1','198','257778','463',677.00,730.00,0.00,1285.41,870222.57,927566.20,57343.63,729909),('1','198','257779','463',677.00,730.00,0.00,8200.82,5551955.14,5920241.30,368286.16,729910),('1','198','257780','463',677.00,730.00,0.00,6122.92,4145216.84,4426374.60,281157.76,729911),('1','198','257781','463',677.00,730.00,0.00,2390.12,1618111.24,1744787.60,126676.36,729912),('1','198','257782','463',677.00,730.00,0.00,1872.27,1267526.79,1366757.10,99230.31,729913),('1','198','257783','463',677.00,730.00,0.00,2003.40,1356301.80,1462482.00,106180.20,729914),('1','198','257784','463',677.00,730.00,0.00,2718.49,1840417.73,1964105.20,123687.47,729915),('1','198','257785','463',677.00,730.00,0.00,0.00,0.00,0.00,0.00,729916),('1','198','257786','463',677.00,730.00,0.00,303.65,205571.05,219164.50,13593.45,729917),('1','198','257787','463',677.00,730.00,0.00,2155.92,1459557.84,1569721.60,110163.76,729918),('1','198','257788','463',677.00,784.00,0.00,1502.90,1017463.30,1178273.60,160810.30,729919),('1','198','257789','463',677.00,780.00,0.00,1710.77,1158191.29,1334400.60,176209.31,729920),('1','198','257790','463',677.00,780.00,0.00,1902.02,1287667.54,1483575.60,195908.06,729921),('1','198','257791','463',677.00,780.00,0.00,1482.98,1003977.46,1156724.40,152746.94,729922),('1','198','257792','463',677.00,780.00,0.00,0.00,0.00,0.00,0.00,729923),('1','198','257793','463',685.00,780.00,0.00,0.00,0.00,0.00,0.00,729924),('1','198','257794','463',685.00,780.00,0.00,2684.35,1838779.75,2093793.00,255013.25,729925),('1','198','257795','463',685.00,780.00,0.00,1972.27,1351004.95,1538370.60,187365.65,729926),('1','198','257796','463',685.00,780.00,0.00,0.00,0.00,0.00,0.00,729927),('1','198','257797','463',685.00,780.00,0.00,1895.98,1298746.30,1478864.40,180118.10,729928),('1','198','257798','463',685.00,780.00,0.00,2164.78,1482874.30,1688528.40,205654.10,729929),('1','198','257799','463',685.00,780.00,0.00,1898.82,1300691.70,1481079.60,180387.90,729930),('1','198','257800','463',685.00,780.00,0.00,1613.57,1105295.45,1253844.60,148549.15,729931),('1','198','257801','463',685.00,780.00,0.00,2479.51,1698464.35,1865428.20,166963.85,729932),('1','198','257802','463',685.00,780.00,0.00,0.00,0.00,0.00,0.00,729933),('1','198','257803','463',685.00,780.00,0.00,2273.91,1557628.35,1705621.40,147993.05,729934),('1','198','257804','463',685.00,780.00,0.00,2561.98,1754956.30,1939970.40,185014.10,729935),('1','198','257805','463',685.00,780.00,0.00,6796.90,4655876.50,5088900.80,433024.30,729936),('1','198','257806','463',685.00,780.00,0.00,3535.66,2421927.10,2688306.08,266378.98,729937),('1','198','257807','463',685.00,780.00,0.00,2648.09,1813941.65,2045544.24,231602.59,729938),('1','198','257808','463',685.00,780.00,0.00,2964.47,2030661.95,2286275.72,255613.77,729939),('1','198','257809','463',685.00,780.00,0.00,2232.79,1529461.15,1726495.82,197034.67,729940),('1','198','257810','463',685.00,780.00,0.00,1570.15,1075552.75,1188205.40,112652.65,729941),('1','198','257811','463',685.00,780.00,0.00,0.00,0.00,0.00,0.00,729942),('1','198','257812','463',697.00,780.00,0.00,1680.27,1171148.19,1265174.20,94026.01,729943),('1','198','257813','463',697.00,780.00,0.00,2460.64,1715066.08,1867883.60,152817.52,729944),('1','198','257814','463',697.00,780.00,0.00,3802.54,2650370.38,2869249.20,218878.82,729945),('1','198','257815','463',697.00,780.00,0.00,3508.69,2445556.93,2645704.60,200147.67,729946),('1','198','257816','463',697.00,780.00,0.00,2427.94,1692274.18,1832892.40,140618.22,729947),('1','198','257817','463',697.00,780.00,0.00,6451.59,4496758.23,4828960.20,332201.97,729948),('1','198','257818','463',697.00,780.00,0.00,3514.35,2449501.95,2649587.80,200085.85,729949),('1','198','257819','463',697.00,780.00,0.00,820.15,571644.55,618702.60,47058.05,729950),('1','198','257820','463',697.00,780.00,0.00,0.00,0.00,0.00,0.00,729951),('1','198','257821','463',685.00,780.00,0.00,2886.74,1977416.90,2171011.60,193594.70,729952),('1','198','257822','463',685.00,780.00,0.00,3713.39,2543672.15,2789884.20,246212.05,729953),('1','198','257823','463',685.00,780.00,0.00,3794.76,2599410.60,2872939.20,273528.60,729954),('1','198','257824','463',685.00,780.00,0.00,3166.16,2168819.60,2390490.40,221670.80,729955),('1','198','257825','463',685.00,780.00,0.00,261.03,178805.55,200383.40,21577.85,729956),('1','198','257826','463',685.00,736.00,0.00,3499.03,2396835.55,2513237.08,116401.53,729957),('1','198','257827','463',685.00,736.00,0.00,4511.51,3090384.35,3246789.96,156405.61,729958),('1','198','257828','463',685.00,736.00,0.00,3425.26,2346303.10,2476815.28,130512.18,729959),('1','198','257829','463',685.00,736.00,0.00,7450.55,5103626.75,5338702.90,235076.15,729960),('1','198','257830','463',685.00,736.00,0.00,5278.53,3615793.05,3796911.64,181118.59,729961),('1','198','257831','463',685.00,736.00,0.00,3966.69,2717182.65,2870258.30,153075.65,729962),('1','198','257832','463',685.00,736.00,0.00,6200.20,4247137.00,4470830.10,223693.10,729963),('1','198','257833','463',685.00,736.00,0.00,1302.25,892041.25,935899.70,43858.45,729964),('1','198','257834','463',685.00,736.00,0.00,0.00,0.00,0.00,0.00,729965),('1','198','257835','463',685.00,736.00,0.00,2825.59,1935529.15,2032134.84,96605.69,729966),('1','198','257836','463',685.00,736.00,0.00,5038.44,3451331.40,3614939.10,163607.70,729967),('1','198','257837','463',685.00,736.00,0.00,4653.19,3187435.15,3339421.56,151986.41,729968),('1','198','257838','463',685.00,736.00,0.00,3468.45,2375888.25,2497810.78,121922.53,729969),('1','198','257839','463',685.00,736.00,0.00,3897.32,2669664.20,2806371.76,136707.56,729970),('1','198','257840','463',685.00,736.00,0.00,3298.86,2259719.10,2374812.80,115093.70,729971),('1','198','257841','463',685.00,736.00,0.00,1129.09,773426.65,809180.90,35754.25,729972),('1','198','257842','463',685.00,736.00,0.00,0.00,0.00,0.00,0.00,729973),('1','198','257843','463',675.00,736.00,0.00,14064.10,9493267.50,10096110.06,602842.56,729974),('1','198','257844','463',675.00,736.00,0.00,3663.77,2473044.75,2629631.78,156587.03,729975),('1','198','257845','463',675.00,736.00,0.00,3509.53,2368932.75,2531131.60,162198.85,729976),('1','198','257846','463',675.00,736.00,0.00,3274.50,2210287.50,2358017.18,147729.68,729977),('1','198','257847','463',675.00,736.00,0.00,1071.92,723546.00,778351.12,54805.12,729978),('1','198','257848','463',675.00,736.00,0.00,0.00,0.00,0.00,0.00,729979),('1','198','257849','463',676.00,736.00,0.00,2949.81,1994071.56,2114294.62,120223.06,729980),('1','198','257850','463',676.00,736.00,0.00,4071.15,2752097.40,2923450.70,171353.30,729981),('1','198','257851','463',676.00,736.00,0.00,5594.98,3782206.48,4015464.24,233257.76,729982),('1','198','257852','463',676.00,736.00,0.00,3061.28,2069425.28,2209064.58,139639.30,729983),('1','198','257853','463',676.00,736.00,0.00,2583.27,1746290.52,1868854.58,122564.06,729984),('1','198','257854','463',676.00,736.00,0.00,4405.60,2978185.60,3167152.28,188966.68,729985),('1','198','257855','463',676.00,736.00,0.00,1770.96,1197168.96,1274082.96,76914.00,729986),('1','198','257856','463',676.00,736.00,0.00,1744.08,1178998.08,1258649.08,79651.00,729987),('1','198','257857','463',676.00,736.00,0.00,8066.35,5452852.60,5763207.94,310355.34,729988),('1','198','257858','463',676.00,736.00,0.00,4226.60,2857181.60,3042852.34,185670.74,729989),('1','198','257859','463',676.00,736.00,0.00,4116.31,2782625.56,2966850.56,184225.00,729990),('1','198','257860','463',676.00,736.00,0.00,3773.52,2550899.52,2713835.62,162936.10,729991),('1','198','257861','463',676.00,736.00,0.00,2086.93,1410764.68,1498982.48,88217.80,729992),('1','198','257862','463',676.00,736.00,0.00,0.00,0.00,0.00,0.00,729993),('1','198','257863','463',676.00,736.00,0.00,2896.97,1958351.72,2075019.84,116668.12,729994),('1','198','257864','463',676.00,736.00,0.00,3032.95,2050274.20,2192549.98,142275.78,729995),('1','198','257865','463',676.00,736.00,0.00,2682.85,1813606.60,1938433.18,124826.58,729996),('1','198','257866','463',676.00,736.00,0.00,4822.14,3259766.64,3467456.34,207689.70,729997),('1','198','257867','463',676.00,736.00,0.00,2612.56,1766090.56,1896712.08,130621.52,729998),('1','198','257868','463',676.00,736.00,0.00,4125.62,2788919.12,2972869.16,183950.04,729999),('1','198','257869','463',676.00,736.00,0.00,2868.75,1939275.00,2068895.72,129620.72,730000),('1','198','257870','463',676.00,736.00,0.00,1521.10,1028263.60,1097683.36,69419.76,730001),('1','198','257871','463',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730002),('1','198','257872','463',676.00,736.00,0.00,2123.64,1435580.64,1533719.92,98139.28,730003),('1','198','257873','463',676.00,736.00,0.00,2762.17,1867226.92,1998519.08,131292.16,730004),('1','198','257874','463',676.00,736.00,0.00,2917.51,1972236.76,2111529.30,139292.54,730005),('1','198','257875','463',676.00,736.00,0.00,3825.29,2585896.04,2754181.36,168285.32,730006),('1','198','257876','463',676.00,736.00,0.00,3080.37,2082330.12,2229750.28,147420.16,730007),('1','198','257877','463',676.00,736.00,0.00,2560.56,1730938.56,1855565.00,124626.44,730008),('1','198','257878','463',676.00,736.00,0.00,3239.12,2189645.12,2337615.60,147970.48,730009),('1','198','257879','463',676.00,736.00,0.00,3505.07,2369427.32,2524504.14,155076.82,730010),('1','198','257880','463',676.00,736.00,0.00,529.28,357793.28,382081.06,24287.78,730011),('1','198','257881','463',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730012),('1','198','257882','463',676.00,736.00,0.00,3208.41,2168885.16,2316680.94,147795.78,730013),('1','198','257883','463',676.00,736.00,0.00,2726.70,1843249.20,1966828.88,123579.68,730014),('1','198','257884','463',676.00,736.00,0.00,4130.52,2792231.52,2981394.24,189162.72,730015),('1','198','257885','463',676.00,736.00,0.00,2416.75,1633723.00,1737084.58,103361.58,730016),('1','198','257886','463',676.00,736.00,0.00,2625.09,1774560.84,1905183.28,130622.44,730017),('1','198','257887','463',676.00,736.00,0.00,3775.51,2552244.76,2717503.50,165258.74,730018),('1','198','257888','463',676.00,736.00,0.00,4556.68,3080315.68,3275731.04,195415.36,730019),('1','198','257889','463',676.00,736.00,0.00,1068.05,722001.80,769011.90,47010.10,730020),('1','198','257890','463',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730021),('1','198','257891','463',676.00,736.00,0.00,2843.42,1922151.92,2049507.42,127355.50,730022),('1','198','257892','463',676.00,736.00,0.00,4335.46,2930770.96,3122434.06,191663.10,730023),('1','198','257893','463',676.00,736.00,0.00,3192.19,2157920.44,2295318.28,137397.84,730024),('1','198','257894','463',676.00,736.00,0.00,2584.43,1747074.68,1867241.20,120166.52,730025),('1','198','257895','463',676.00,736.00,0.00,2212.17,1495426.92,1594160.04,98733.12,730026),('1','198','257896','463',676.00,736.00,0.00,0.00,0.00,0.00,0.00,730027),('1','198','257897','463',651.00,736.00,0.00,1135.59,739269.09,821370.74,82101.65,730028),('1','198','257898','463',651.00,736.00,0.00,3233.27,2104858.77,2334177.10,229318.33,730029),('1','198','257899','463',651.00,736.00,0.00,3461.17,2253221.67,2495866.50,242644.83,730030),('1','198','257900','463',651.00,736.00,0.00,2833.58,1844660.58,2043460.14,198799.56,730031),('1','198','257901','463',651.00,736.00,0.00,5510.23,3587159.73,3952432.52,365272.79,730032),('1','198','257902','463',651.00,736.00,0.00,3472.08,2260324.08,2508152.20,247828.12,730033),('1','198','257903','463',651.00,736.00,0.00,3742.64,2436458.64,2702248.94,265790.30,730034),('1','198','257904','463',651.00,736.00,0.00,197.26,128416.26,142803.32,14387.06,730035),('1','198','257905','463',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730036),('1','198','257906','463',661.00,736.00,0.00,3930.39,2597987.79,2826558.56,228570.77,730037),('1','198','257907','463',661.00,736.00,0.00,2805.66,1854541.26,2029218.36,174677.10,730038),('1','198','257908','463',661.00,736.00,0.00,4510.75,2981605.75,3229934.58,248328.83,730039),('1','198','257909','463',661.00,736.00,0.00,2958.96,1955872.56,2138299.00,182426.44,730040),('1','198','257910','463',661.00,736.00,0.00,2856.82,1888358.02,2066449.88,178091.86,730041),('1','198','257911','463',661.00,736.00,0.00,2065.46,1365269.06,1504622.76,139353.70,730042),('1','198','257912','463',661.00,736.00,0.00,1902.97,1257863.17,1387206.32,129343.15,730043),('1','198','257913','463',661.00,736.00,0.00,2141.35,1415432.35,1554466.60,139034.25,730044),('1','198','257914','463',661.00,736.00,0.00,0.00,0.00,0.00,0.00,730045),('1','198','257915','463',661.00,736.00,0.00,637.89,421645.29,467317.60,45672.31,730046),('1','198','257916','463',661.00,736.00,0.00,2664.45,1761201.45,1939591.44,178389.99,730047),('1','198','257917','463',661.00,736.00,0.00,2550.05,1685583.05,1848083.92,162500.87,730048),('1','198','257918','463',661.00,736.00,0.00,5278.82,3489300.02,3787050.34,297750.32,730049),('1','198','257919','463',661.00,736.00,0.00,2330.12,1540209.32,1687574.72,147365.40,730050),('1','198','257920','463',661.00,736.00,0.00,2958.11,1955310.71,2139734.42,184423.71,730051),('1','198','257921','463',661.00,736.00,0.00,2634.44,1741364.84,1906432.50,165067.66,730052),('1','198','257922','463',661.00,736.00,0.00,2838.81,1876453.41,2056513.94,180060.53,730053),('1','198','257923','463',661.00,736.00,0.00,2576.90,1703330.90,1861493.46,158162.56,730054),('1','198','257924','463',661.00,736.00,0.00,0.00,0.00,0.00,0.00,730055),('1','198','257925','463',661.00,736.00,0.00,384.94,254445.34,278906.76,24461.42,730056),('1','198','257926','463',661.00,736.00,0.00,2514.74,1662243.14,1819566.74,157323.60,730057),('1','198','257927','463',661.00,736.00,0.00,2527.76,1670849.36,1822772.44,151923.08,730058),('1','198','257928','463',661.00,736.00,0.00,3236.11,2139068.71,2327408.10,188339.39,730059),('1','198','257929','463',661.00,736.00,0.00,2710.58,1791693.38,1962163.96,170470.58,730060),('1','198','257930','463',661.00,736.00,0.00,2304.61,1523347.21,1663067.66,139720.45,730061),('1','198','257931','463',661.00,736.00,0.00,3460.80,2287588.80,2494198.76,206609.96,730062),('1','198','257932','463',661.00,736.00,0.00,2873.89,1899641.29,2079294.98,179653.69,730063),('1','198','257933','463',661.00,736.00,0.00,2414.49,1595977.89,1750610.94,154633.05,730064),('1','198','257934','463',661.00,736.00,0.00,2597.48,1716934.28,1884380.80,167446.52,730065),('1','198','257935','463',661.00,736.00,0.00,85.33,56403.13,62472.94,6069.81,730066),('1','198','257936','463',651.00,736.00,0.00,1910.72,1243878.72,1393624.02,149745.30,730067),('1','198','257937','463',651.00,736.00,0.00,3589.25,2336601.75,2601825.06,265223.31,730068),('1','198','257938','463',651.00,736.00,0.00,3802.13,2475186.63,2764862.00,289675.37,730069),('1','198','257939','463',651.00,736.00,0.00,5971.99,3887765.49,4331798.52,444033.03,730070),('1','198','257940','463',651.00,736.00,0.00,2655.17,1728515.67,1924526.12,196010.45,730071),('1','198','257941','463',651.00,736.00,0.00,3986.72,2595354.72,2856945.34,261590.62,730072),('1','198','257942','463',651.00,736.00,0.00,2446.70,1592801.70,1773896.04,181094.34,730073),('1','198','257943','463',651.00,736.00,0.00,267.43,174096.93,195777.30,21680.37,730074),('1','198','257944','463',651.00,736.00,0.00,0.00,0.00,0.00,0.00,730075),('1','198','257945','463',651.00,736.00,0.00,1841.26,1198660.26,1337118.94,138458.68,730076),('1','198','257946','463',651.00,736.00,0.00,2346.07,1527291.57,1709966.90,182675.33,730077),('1','198','257947','463',651.00,736.00,0.00,2603.31,1694754.81,1891659.08,196904.27,730078),('1','198','257948','463',651.00,736.00,0.00,2045.90,1331880.90,1487085.02,155204.12,730079),('1','198','257949','463',651.00,736.00,0.00,3432.52,2234570.52,2481236.94,246666.42,730080),('1','198','257950','463',651.00,736.00,0.00,1912.54,1245063.54,1392562.18,147498.64,730081),('1','198','257951','463',651.00,726.00,0.00,2344.34,1526165.34,1678134.28,151968.94,730082),('1','198','257952','463',651.00,726.00,0.00,2511.45,1634953.95,1796396.20,161442.25,730083),('1','198','257953','463',651.00,726.00,0.00,1948.60,1268538.60,1400582.76,132044.16,730084),('1','198','257954','463',651.00,726.00,0.00,3544.70,2307599.70,2501094.20,193494.50,730085),('1','198','257955','463',651.00,726.00,0.00,0.00,0.00,0.00,0.00,730086),('1','198','257956','463',651.00,726.00,0.00,2550.38,1660297.38,1824722.30,164424.92,730087),('1','198','257957','463',651.00,726.00,0.00,5941.16,3867695.16,4236002.36,368307.20,730088),('1','198','257958','463',651.00,726.00,0.00,2363.73,1538788.23,1687168.98,148380.75,730089),('1','198','257959','463',651.00,726.00,0.00,2601.28,1693433.28,1851207.58,157774.30,730090),('1','198','257960','463',651.00,726.00,0.00,2807.75,1827845.25,2003563.88,175718.63,730091),('1','198','257961','463',651.00,726.00,0.00,2034.48,1324446.48,1449604.04,125157.56,730092),('1','198','257962','463',651.00,726.00,0.00,0.00,0.00,0.00,0.00,730093),('1','198','257963','463',651.00,726.00,0.00,1731.59,1127265.09,1234004.22,106739.13,730094),('1','198','257964','463',651.00,726.00,0.00,4073.20,2651653.20,2918577.66,266924.46,730095),('1','198','257965','463',651.00,726.00,0.00,8454.62,5503957.62,6022157.04,518199.42,730096),('1','198','257966','463',651.00,726.00,0.00,874.85,569527.35,614663.76,45136.41,730097);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=421 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',420,'198','LPG PRODUCT TANKS','TANKS CONTAINING LPG RODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1018 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','198','420',1016,1,'463','LPG TANK 1',25000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-10-29 22:50:29','2021-10-29 22:50:29','479',5,1),('1','198','420',1017,1,'463','LPG TANK 2',25000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-10-29 22:52:28','2021-10-29 22:52:28','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','198',1016,9485.74,'2023-03-20 10:50:29'),(2,'1','198',1017,0.00,'2023-03-20 10:47:40');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2736096 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108174,'1','198','1017',463,'Retail Sale Id 1254111',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 06:30:03','',''),(2108175,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:30:03','',''),(2108508,'1','198','1017',463,'Retail Sale Id 1254264',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 06:52:46','',''),(2108509,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 06:52:46','',''),(2108611,'1','198','1017',463,'Retail Sale Id 1254314',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 06:56:55','',''),(2108612,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 06:56:55','',''),(2108687,'1','198','1017',463,'Retail Sale Id 1254352',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:00:33','',''),(2108688,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:00:33','',''),(2108689,'1','198','1017',463,'Retail Sale Id 1254352',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 07:00:33','',''),(2108690,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:00:33','',''),(2108738,'1','198','1017',463,'Retail Sale Id 1254375',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:03:28','',''),(2108739,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:03:28','',''),(2108740,'1','198','1017',463,'Retail Sale Id 1254375',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:03:28','',''),(2108741,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:03:28','',''),(2108742,'1','198','1017',463,'Retail Sale Id 1254375',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 07:03:28','',''),(2108743,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:03:28','',''),(2108769,'1','198','1017',463,'Retail Sale Id 1254390',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:04:59','',''),(2108770,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:04:59','',''),(2108933,'1','198','1017',463,'Retail Sale Id 1254450',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:11:50','',''),(2108934,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:11:50','',''),(2108971,'1','198','1017',463,'Retail Sale Id 1254467',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:13:07','',''),(2108972,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:13:07','',''),(2109015,'1','198','1017',463,'Retail Sale Id 1254487',98800.00,0.00,0.00,0.00,975.00,'2021-12-01 07:15:56','',''),(2109016,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,162.50,0.00,'2021-12-01 07:15:56','',''),(2109039,'1','198','1017',463,'Retail Sale Id 1254501',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 07:17:02','',''),(2109040,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:17:02','',''),(2109328,'1','198','1017',463,'Retail Sale Id 1254614',1997.12,0.00,0.00,0.00,94.80,'2021-12-01 07:31:07','',''),(2109329,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-01 07:31:07','',''),(2109639,'1','198','1017',463,'Retail Sale Id 1254770',30400.00,0.00,0.00,0.00,300.00,'2021-12-01 07:45:08','',''),(2109640,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 07:45:08','',''),(2109693,'1','198','1017',463,'Retail Sale Id 1254790',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:46:53','',''),(2109694,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:46:53','',''),(2109695,'1','198','1017',463,'Retail Sale Id 1254790',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:46:53','',''),(2109696,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:46:53','',''),(2109728,'1','198','1017',463,'Retail Sale Id 1254805',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 07:48:04','',''),(2109729,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 07:48:04','',''),(2109782,'1','198','1017',463,'Retail Sale Id 1254831',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 07:50:41','',''),(2109783,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 07:50:41','',''),(2110100,'1','198','1017',463,'Retail Sale Id 1254986',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 08:07:26','',''),(2110101,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:07:26','',''),(2110120,'1','198','1017',463,'Retail Sale Id 1254996',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 08:08:38','',''),(2110121,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 08:08:38','',''),(2110137,'1','198','1017',463,'Retail Sale Id 1255005',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 08:09:37','',''),(2110138,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 08:09:37','',''),(2110212,'1','198','1017',463,'Retail Sale Id 1255038',3147.36,0.00,0.00,0.00,149.40,'2021-12-01 08:14:07','',''),(2110213,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-01 08:14:07','',''),(2110300,'1','198','1017',463,'Retail Sale Id 1255088',7600.00,0.00,0.00,0.00,75.00,'2021-12-01 08:19:09','',''),(2110301,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:19:09','',''),(2110346,'1','198','1017',463,'Retail Sale Id 1255109',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 08:20:58','',''),(2110347,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 08:20:58','',''),(2110364,'1','198','1017',463,'Retail Sale Id 1255118',60800.00,0.00,0.00,0.00,600.00,'2021-12-01 08:21:58','',''),(2110365,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 08:21:58','',''),(2110374,'1','198','1017',463,'Retail Sale Id 1255123',60800.00,0.00,0.00,0.00,600.00,'2021-12-01 08:22:34','',''),(2110375,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 08:22:34','',''),(2110437,'1','198','1017',463,'Retail Sale Id 1255156',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 08:27:29','',''),(2110438,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 08:27:29','',''),(2110461,'1','198','1017',463,'Retail Sale Id 1255170',32224.00,0.00,0.00,0.00,318.00,'2021-12-01 08:29:12','',''),(2110462,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-01 08:29:12','',''),(2110712,'1','198','1017',463,'Retail Sale Id 1255286',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 08:42:45','',''),(2110713,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:42:45','',''),(2110800,'1','198','1017',463,'Retail Sale Id 1255335',60800.00,0.00,0.00,0.00,600.00,'2021-12-01 08:48:01','',''),(2110801,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 08:48:01','',''),(2110812,'1','198','1017',463,'Retail Sale Id 1255345',7600.00,0.00,0.00,0.00,75.00,'2021-12-01 08:48:38','',''),(2110813,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:48:38','',''),(2110838,'1','198','1017',463,'Retail Sale Id 1255358',3648.00,0.00,0.00,0.00,36.00,'2021-12-01 08:50:17','',''),(2110839,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:50:17','',''),(2110918,'1','198','1017',463,'Retail Sale Id 1255399',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 08:55:24','',''),(2110919,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 08:55:24','',''),(2111210,'1','198','1017',463,'Retail Sale Id 1255543',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 09:13:06','',''),(2111211,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 09:13:06','',''),(2111316,'1','198','1017',463,'Retail Sale Id 1255610',6320.00,0.00,0.00,0.00,300.00,'2021-12-01 09:19:08','',''),(2111317,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:19:08','',''),(2111344,'1','198','1017',463,'Retail Sale Id 1255623',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 09:21:11','',''),(2111345,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 09:21:11','',''),(2111346,'1','198','1017',463,'Retail Sale Id 1255623',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 09:21:11','',''),(2111347,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:21:11','',''),(2111386,'1','198','1017',463,'Retail Sale Id 1255642',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 09:23:23','',''),(2111387,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:23:23','',''),(2111494,'1','198','1017',463,'Retail Sale Id 1255696',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 09:29:23','',''),(2111495,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 09:29:23','',''),(2111496,'1','198','1017',463,'Retail Sale Id 1255696',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 09:29:23','',''),(2111497,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:29:23','',''),(2111531,'1','198','1017',463,'Retail Sale Id 1255715',6301.04,0.00,0.00,0.00,299.10,'2021-12-01 09:32:55','',''),(2111532,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,9.97,0.00,'2021-12-01 09:32:55','',''),(2111581,'1','198','1017',463,'Retail Sale Id 1255743',12160.00,0.00,0.00,0.00,120.00,'2021-12-01 09:36:14','',''),(2111582,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 09:36:14','',''),(2111656,'1','198','1017',463,'Retail Sale Id 1255785',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 09:40:20','',''),(2111657,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:40:20','',''),(2111658,'1','198','1017',463,'Retail Sale Id 1255785',15800.00,0.00,0.00,0.00,750.00,'2021-12-01 09:40:20','',''),(2111659,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:40:20','',''),(2111738,'1','198','1017',463,'Retail Sale Id 1255829',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 09:46:20','',''),(2111739,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:46:20','',''),(2111750,'1','198','1017',463,'Retail Sale Id 1255838',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 09:47:22','',''),(2111751,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 09:47:22','',''),(2111820,'1','198','1017',463,'Retail Sale Id 1255869',9199.04,0.00,0.00,0.00,90.78,'2021-12-01 09:52:35','',''),(2111821,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,15.13,0.00,'2021-12-01 09:52:35','',''),(2111829,'1','198','1017',463,'Retail Sale Id 1255874',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 09:53:21','',''),(2111830,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 09:53:21','',''),(2111859,'1','198','1017',463,'Retail Sale Id 1255891',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 09:55:40','',''),(2111860,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 09:55:40','',''),(2111861,'1','198','1017',463,'Retail Sale Id 1255891',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 09:55:40','',''),(2111862,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:55:40','',''),(2111957,'1','198','1017',463,'Retail Sale Id 1255929',632.00,0.00,0.00,0.00,30.00,'2021-12-01 10:01:03','',''),(2111958,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 10:01:03','',''),(2111959,'1','198','1017',463,'Retail Sale Id 1255929',632.00,0.00,0.00,0.00,30.00,'2021-12-01 10:01:03','',''),(2111960,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 10:01:03','',''),(2111991,'1','198','1017',463,'Retail Sale Id 1255947',3160.00,0.00,0.00,0.00,150.00,'2021-12-01 10:02:44','',''),(2111992,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:02:44','',''),(2111999,'1','198','1017',463,'Retail Sale Id 1255952',3103.12,0.00,0.00,0.00,147.30,'2021-12-01 10:03:44','',''),(2112000,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.91,0.00,'2021-12-01 10:03:44','',''),(2112118,'1','198','1017',463,'Retail Sale Id 1256014',91200.00,0.00,0.00,0.00,900.00,'2021-12-01 10:12:39','',''),(2112119,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 10:12:39','',''),(2112158,'1','198','1017',463,'Retail Sale Id 1256034',3160.00,0.00,0.00,0.00,150.00,'2021-12-01 10:15:05','',''),(2112159,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:15:05','',''),(2112160,'1','198','1017',463,'Retail Sale Id 1256034',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 10:15:05','',''),(2112161,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 10:15:05','',''),(2112162,'1','198','1017',463,'Retail Sale Id 1256034',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 10:15:05','',''),(2112163,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:15:05','',''),(2112206,'1','198','1017',463,'Retail Sale Id 1256053',3160.00,0.00,0.00,0.00,150.00,'2021-12-01 10:17:22','',''),(2112207,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:17:22','',''),(2112229,'1','198','1017',463,'Retail Sale Id 1256063',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 10:18:37','',''),(2112230,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 10:18:37','',''),(2112243,'1','198','1017',463,'Retail Sale Id 1256072',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 10:19:56','',''),(2112244,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:19:56','',''),(2112251,'1','198','1017',463,'Retail Sale Id 1256076',3197.92,0.00,0.00,0.00,151.80,'2021-12-01 10:21:22','',''),(2112252,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-01 10:21:22','',''),(2112265,'1','198','1017',463,'Retail Sale Id 1256086',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 10:22:41','',''),(2112266,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 10:22:41','',''),(2112363,'1','198','1017',463,'Retail Sale Id 1256127',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 10:30:27','',''),(2112364,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 10:30:27','',''),(2112365,'1','198','1017',463,'Retail Sale Id 1256127',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 10:30:27','',''),(2112366,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 10:30:27','',''),(2112457,'1','198','1017',463,'Retail Sale Id 1256176',3160.00,0.00,0.00,0.00,150.00,'2021-12-01 10:36:55','',''),(2112458,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 10:36:55','',''),(2112459,'1','198','1017',463,'Retail Sale Id 1256176',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 10:36:55','',''),(2112460,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:36:55','',''),(2112546,'1','198','1017',463,'Retail Sale Id 1256220',30400.00,0.00,0.00,0.00,300.00,'2021-12-01 10:44:51','',''),(2112547,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:44:51','',''),(2112568,'1','198','1017',463,'Retail Sale Id 1256233',1497.84,0.00,0.00,0.00,71.10,'2021-12-01 10:47:09','',''),(2112569,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-01 10:47:09','',''),(2112676,'1','198','1017',463,'Retail Sale Id 1256290',4000.56,0.00,0.00,0.00,189.90,'2021-12-01 10:57:02','',''),(2112677,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-01 10:57:02','',''),(2112753,'1','198','1017',463,'Retail Sale Id 1256328',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 11:02:59','',''),(2112754,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 11:02:59','',''),(2112800,'1','198','1017',463,'Retail Sale Id 1256353',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 11:06:33','',''),(2112801,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:06:33','',''),(2112826,'1','198','1017',463,'Retail Sale Id 1256366',998.56,0.00,0.00,0.00,47.40,'2021-12-01 11:08:02','',''),(2112827,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-01 11:08:02','',''),(2112852,'1','198','1017',463,'Retail Sale Id 1256381',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 11:09:42','',''),(2112853,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 11:09:42','',''),(2113150,'1','198','1017',463,'Retail Sale Id 1256509',1997.12,0.00,0.00,0.00,94.80,'2021-12-01 11:26:30','',''),(2113151,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-01 11:26:30','',''),(2113302,'1','198','1017',463,'Retail Sale Id 1256594',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 11:38:11','',''),(2113303,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 11:38:11','',''),(2113304,'1','198','1017',463,'Retail Sale Id 1256594',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 11:38:11','',''),(2113305,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:38:11','',''),(2113325,'1','198','1017',463,'Retail Sale Id 1256604',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 11:39:32','',''),(2113326,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 11:39:32','',''),(2113415,'1','198','1017',463,'Retail Sale Id 1256654',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 11:46:36','',''),(2113416,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 11:46:36','',''),(2113465,'1','198','1017',463,'Retail Sale Id 1256678',2528.00,0.00,0.00,0.00,120.00,'2021-12-01 11:50:16','',''),(2113466,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 11:50:16','',''),(2113493,'1','198','1017',463,'Retail Sale Id 1256690',7002.56,0.00,0.00,0.00,332.40,'2021-12-01 11:52:48','',''),(2113494,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-01 11:52:48','',''),(2113553,'1','198','1017',463,'Retail Sale Id 1256720',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 11:57:07','',''),(2113554,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:57:07','',''),(2113693,'1','198','1017',463,'Retail Sale Id 1256804',1801.20,0.00,0.00,0.00,85.50,'2021-12-01 12:12:16','',''),(2113694,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-01 12:12:16','',''),(2113961,'1','198','1017',463,'Retail Sale Id 1256936',1997.12,0.00,0.00,0.00,94.80,'2021-12-01 12:29:54','',''),(2113962,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-01 12:29:54','',''),(2114023,'1','198','1017',463,'Retail Sale Id 1256966',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 12:35:43','',''),(2114024,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:35:43','',''),(2114089,'1','198','1017',463,'Retail Sale Id 1257000',24320.00,0.00,0.00,0.00,240.00,'2021-12-01 12:43:09','',''),(2114090,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 12:43:09','',''),(2114103,'1','198','1017',463,'Retail Sale Id 1257008',30400.00,0.00,0.00,0.00,300.00,'2021-12-01 12:44:48','',''),(2114104,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:44:48','',''),(2114109,'1','198','1017',463,'Retail Sale Id 1257011',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 12:46:07','',''),(2114110,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 12:46:07','',''),(2114220,'1','198','1017',463,'Retail Sale Id 1257071',35264.00,0.00,0.00,0.00,348.00,'2021-12-01 12:58:47','',''),(2114221,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-01 12:58:47','',''),(2114232,'1','198','1017',463,'Retail Sale Id 1257075',3002.00,0.00,0.00,0.00,142.50,'2021-12-01 12:59:58','',''),(2114233,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-01 12:59:58','',''),(2114256,'1','198','1017',463,'Retail Sale Id 1257085',1264.00,0.00,0.00,0.00,60.00,'2021-12-01 13:01:56','',''),(2114257,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 13:01:56','',''),(2114283,'1','198','1017',463,'Retail Sale Id 1257098',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:03:48','',''),(2114284,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:03:48','',''),(2114324,'1','198','1017',463,'Retail Sale Id 1257107',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 13:05:43','',''),(2114325,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 13:05:43','',''),(2114326,'1','198','1017',463,'Retail Sale Id 1257107',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 13:05:43','',''),(2114327,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 13:05:43','',''),(2114364,'1','198','1017',463,'Retail Sale Id 1257123',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:08:14','',''),(2114365,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:08:14','',''),(2114496,'1','198','1017',463,'Retail Sale Id 1257239',36480.00,0.00,0.00,0.00,360.00,'2021-12-01 13:17:05','',''),(2114497,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 13:17:05','',''),(2114546,'1','198','1017',463,'Retail Sale Id 1257267',45600.00,0.00,0.00,0.00,450.00,'2021-12-01 13:21:30','',''),(2114547,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-01 13:21:30','',''),(2114590,'1','198','1017',463,'Retail Sale Id 1257288',30400.00,0.00,0.00,0.00,300.00,'2021-12-01 13:24:13','',''),(2114591,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 13:24:13','',''),(2114693,'1','198','1017',463,'Retail Sale Id 1257337',68400.00,0.00,0.00,0.00,675.00,'2021-12-01 13:33:45','',''),(2114694,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,112.50,0.00,'2021-12-01 13:33:45','',''),(2114742,'1','198','1017',463,'Retail Sale Id 1257357',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:36:47','',''),(2114743,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:36:47','',''),(2114783,'1','198','1017',463,'Retail Sale Id 1257368',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 13:39:17','',''),(2114784,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 13:39:17','',''),(2114785,'1','198','1017',463,'Retail Sale Id 1257368',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 13:39:17','',''),(2114786,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 13:39:17','',''),(2114787,'1','198','1017',463,'Retail Sale Id 1257368',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:39:17','',''),(2114788,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:39:17','',''),(2114868,'1','198','1017',463,'Retail Sale Id 1257387',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 13:42:22','',''),(2114869,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 13:42:22','',''),(2114936,'1','198','1017',463,'Retail Sale Id 1257410',91200.00,0.00,0.00,0.00,900.00,'2021-12-01 13:46:03','',''),(2114937,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 13:46:03','',''),(2114986,'1','198','1017',463,'Retail Sale Id 1257427',5997.68,0.00,0.00,0.00,284.70,'2021-12-01 13:49:04','',''),(2114987,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-01 13:49:04','',''),(2115019,'1','198','1017',463,'Retail Sale Id 1257442',322.32,0.00,0.00,0.00,15.30,'2021-12-01 13:51:08','',''),(2115020,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,0.51,0.00,'2021-12-01 13:51:08','',''),(2115027,'1','198','1017',463,'Retail Sale Id 1257446',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:51:51','',''),(2115028,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:51:51','',''),(2115061,'1','198','1017',463,'Retail Sale Id 1257460',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 13:53:06','',''),(2115062,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 13:53:06','',''),(2115092,'1','198','1017',463,'Retail Sale Id 1257475',18240.00,0.00,0.00,0.00,180.00,'2021-12-01 13:54:58','',''),(2115093,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 13:54:58','',''),(2115146,'1','198','1017',463,'Retail Sale Id 1257506',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:58:14','',''),(2115147,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:58:14','',''),(2115148,'1','198','1017',463,'Retail Sale Id 1257506',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 13:58:14','',''),(2115149,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:58:14','',''),(2115247,'1','198','1017',463,'Retail Sale Id 1257554',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 14:03:12','',''),(2115248,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 14:03:12','',''),(2115291,'1','198','1017',463,'Retail Sale Id 1257573',7798.88,0.00,0.00,0.00,370.20,'2021-12-01 14:05:34','',''),(2115292,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.34,0.00,'2021-12-01 14:05:34','',''),(2115475,'1','198','1017',463,'Retail Sale Id 1257679',3160.00,0.00,0.00,0.00,150.00,'2021-12-01 14:18:34','',''),(2115476,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:18:34','',''),(2115622,'1','198','1017',463,'Retail Sale Id 1257754',3501.28,0.00,0.00,0.00,166.20,'2021-12-01 14:28:13','',''),(2115623,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-01 14:28:13','',''),(2115752,'1','198','1017',463,'Retail Sale Id 1257820',3160.00,0.00,0.00,0.00,150.00,'2021-12-01 14:37:53','',''),(2115753,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:37:53','',''),(2115843,'1','198','1017',463,'Retail Sale Id 1257864',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 14:46:20','',''),(2115844,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 14:46:20','',''),(2115845,'1','198','1017',463,'Retail Sale Id 1257864',6320.00,0.00,0.00,0.00,300.00,'2021-12-01 14:46:20','',''),(2115846,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 14:46:20','',''),(2115867,'1','198','1017',463,'Retail Sale Id 1257876',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 14:47:55','',''),(2115868,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:47:56','',''),(2115916,'1','198','1017',463,'Retail Sale Id 1257895',30400.00,0.00,0.00,0.00,300.00,'2021-12-01 14:50:10','',''),(2115917,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 14:50:10','',''),(2116110,'1','198','1017',463,'Retail Sale Id 1257963',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 15:00:23','',''),(2116111,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:00:23','',''),(2116350,'1','198','1017',463,'Retail Sale Id 1258084',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 15:17:47','',''),(2116351,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 15:17:47','',''),(2116352,'1','198','1017',463,'Retail Sale Id 1258084',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 15:17:47','',''),(2116353,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 15:17:47','',''),(2116446,'1','198','1017',463,'Retail Sale Id 1258127',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 15:23:33','',''),(2116447,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 15:23:33','',''),(2116604,'1','198','1017',463,'Retail Sale Id 1258203',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 15:33:36','',''),(2116605,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 15:33:36','',''),(2116624,'1','198','1017',463,'Retail Sale Id 1258214',3002.00,0.00,0.00,0.00,142.50,'2021-12-01 15:35:21','',''),(2116625,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-01 15:35:21','',''),(2116820,'1','198','1017',463,'Retail Sale Id 1258305',182400.00,0.00,0.00,0.00,1800.00,'2021-12-01 15:46:28','',''),(2116821,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-01 15:46:28','',''),(2116862,'1','198','1017',463,'Retail Sale Id 1258325',152000.00,0.00,0.00,0.00,1500.00,'2021-12-01 15:47:55','',''),(2116863,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-01 15:47:55','',''),(2116882,'1','198','1017',463,'Retail Sale Id 1258334',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 15:49:00','',''),(2116883,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 15:49:00','',''),(2117096,'1','198','1017',463,'Retail Sale Id 1258428',91200.00,0.00,0.00,0.00,900.00,'2021-12-01 15:57:46','',''),(2117097,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 15:57:46','',''),(2117587,'1','198','1017',463,'Retail Sale Id 1258656',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 16:17:59','',''),(2117588,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 16:17:59','',''),(2117650,'1','198','1017',463,'Retail Sale Id 1258690',60800.00,0.00,0.00,0.00,600.00,'2021-12-01 16:20:23','',''),(2117651,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 16:20:23','',''),(2117678,'1','198','1017',463,'Retail Sale Id 1258703',7900.00,0.00,0.00,0.00,375.00,'2021-12-01 16:21:30','',''),(2117679,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:21:30','',''),(2117802,'1','198','1017',463,'Retail Sale Id 1258785',499.28,0.00,0.00,0.00,23.70,'2021-12-01 16:27:23','',''),(2117803,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-01 16:27:23','',''),(2117998,'1','198','1017',463,'Retail Sale Id 1258889',1902.32,0.00,0.00,0.00,90.30,'2021-12-01 16:37:04','',''),(2117999,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-01 16:37:04','',''),(2118110,'1','198','1017',463,'Retail Sale Id 1258947',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 16:42:13','',''),(2118111,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 16:42:13','',''),(2118238,'1','198','1017',463,'Retail Sale Id 1259015',3798.32,0.00,0.00,0.00,180.30,'2021-12-01 16:48:48','',''),(2118239,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 16:48:48','',''),(2118387,'1','198','1017',463,'Retail Sale Id 1259086',1398.40,0.00,0.00,0.00,13.80,'2021-12-01 16:55:18','',''),(2118388,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.30,0.00,'2021-12-01 16:55:18','',''),(2120770,'1','198','1017',463,'Retail Sale Id 1260037',1403.04,0.00,0.00,0.00,66.60,'2021-12-02 06:34:19','',''),(2120771,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.22,0.00,'2021-12-02 06:34:19','',''),(2120918,'1','198','1017',463,'Retail Sale Id 1260080',1824.00,0.00,0.00,0.00,18.00,'2021-12-02 06:40:52','',''),(2120919,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:40:52','',''),(2121188,'1','198','1017',463,'Retail Sale Id 1260195',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 06:55:59','',''),(2121189,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 06:55:59','',''),(2121216,'1','198','1017',463,'Retail Sale Id 1260206',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 06:57:15','',''),(2121217,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 06:57:15','',''),(2121659,'1','198','1017',463,'Retail Sale Id 1260409',86944.00,0.00,0.00,0.00,858.00,'2021-12-02 07:20:02','',''),(2121660,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,143.00,0.00,'2021-12-02 07:20:02','',''),(2121675,'1','198','1017',463,'Retail Sale Id 1260416',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 07:20:52','',''),(2121676,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 07:20:52','',''),(2121823,'1','198','1017',463,'Retail Sale Id 1260489',1997.12,0.00,0.00,0.00,94.80,'2021-12-02 07:27:56','',''),(2121824,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-02 07:27:56','',''),(2122025,'1','198','1017',463,'Retail Sale Id 1260609',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 07:38:55','',''),(2122026,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:38:55','',''),(2122098,'1','198','1017',463,'Retail Sale Id 1260651',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 07:42:04','',''),(2122099,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 07:42:04','',''),(2122229,'1','198','1017',463,'Retail Sale Id 1260719',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 07:48:52','',''),(2122230,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:48:52','',''),(2122231,'1','198','1017',463,'Retail Sale Id 1260719',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 07:48:52','',''),(2122232,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:48:52','',''),(2122295,'1','198','1017',463,'Retail Sale Id 1260736',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 07:50:14','',''),(2122296,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:50:14','',''),(2122361,'1','198','1017',463,'Retail Sale Id 1260768',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 07:52:39','',''),(2122362,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:52:39','',''),(2122536,'1','198','1017',463,'Retail Sale Id 1260850',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 07:59:27','',''),(2122537,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:59:27','',''),(2122657,'1','198','1017',463,'Retail Sale Id 1260902',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:04:37','',''),(2122658,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:04:37','',''),(2122749,'1','198','1017',463,'Retail Sale Id 1260946',4999.12,0.00,0.00,0.00,237.30,'2021-12-02 08:08:59','',''),(2122750,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-02 08:08:59','',''),(2122811,'1','198','1017',463,'Retail Sale Id 1260980',91200.00,0.00,0.00,0.00,900.00,'2021-12-02 08:13:06','',''),(2122812,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 08:13:06','',''),(2122840,'1','198','1017',463,'Retail Sale Id 1260995',3141.04,0.00,0.00,0.00,149.10,'2021-12-02 08:14:28','',''),(2122841,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.97,0.00,'2021-12-02 08:14:28','',''),(2123023,'1','198','1017',463,'Retail Sale Id 1261089',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:23:39','',''),(2123024,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:23:39','',''),(2123081,'1','198','1017',463,'Retail Sale Id 1261119',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:26:39','',''),(2123082,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:26:39','',''),(2123101,'1','198','1017',463,'Retail Sale Id 1261128',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 08:27:40','',''),(2123102,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 08:27:40','',''),(2123125,'1','198','1017',463,'Retail Sale Id 1261141',1997.12,0.00,0.00,0.00,94.80,'2021-12-02 08:28:44','',''),(2123126,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-02 08:28:44','',''),(2123215,'1','198','1017',463,'Retail Sale Id 1261188',30400.00,0.00,0.00,0.00,300.00,'2021-12-02 08:33:57','',''),(2123216,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:33:57','',''),(2123421,'1','198','1017',463,'Retail Sale Id 1261270',9480.00,0.00,0.00,0.00,450.00,'2021-12-02 08:43:21','',''),(2123422,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 08:43:21','',''),(2123451,'1','198','1017',463,'Retail Sale Id 1261285',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 08:44:29','',''),(2123452,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 08:44:29','',''),(2123469,'1','198','1017',463,'Retail Sale Id 1261297',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:45:57','',''),(2123470,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:45:57','',''),(2123493,'1','198','1017',463,'Retail Sale Id 1261306',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 08:47:02','',''),(2123494,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 08:47:02','',''),(2123543,'1','198','1017',463,'Retail Sale Id 1261332',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 08:51:32','',''),(2123544,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 08:51:32','',''),(2123545,'1','198','1017',463,'Retail Sale Id 1261332',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 08:51:32','',''),(2123546,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 08:51:32','',''),(2123547,'1','198','1017',463,'Retail Sale Id 1261332',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:51:32','',''),(2123548,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:51:32','',''),(2123549,'1','198','1017',463,'Retail Sale Id 1261332',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:51:32','',''),(2123550,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:51:32','',''),(2123609,'1','198','1017',463,'Retail Sale Id 1261364',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 08:54:40','',''),(2123610,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:54:40','',''),(2123645,'1','198','1017',463,'Retail Sale Id 1261384',3160.00,0.00,0.00,0.00,150.00,'2021-12-02 08:56:19','',''),(2123646,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:56:19','',''),(2123765,'1','198','1017',463,'Retail Sale Id 1261457',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 09:02:51','',''),(2123766,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:02:51','',''),(2123853,'1','198','1017',463,'Retail Sale Id 1261504',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:06:57','',''),(2123854,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:06:57','',''),(2123889,'1','198','1017',463,'Retail Sale Id 1261520',2528.00,0.00,0.00,0.00,120.00,'2021-12-02 09:08:23','',''),(2123890,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 09:08:23','',''),(2123913,'1','198','1017',463,'Retail Sale Id 1261530',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 09:09:46','',''),(2123914,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:09:46','',''),(2124096,'1','198','1017',463,'Retail Sale Id 1261598',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 09:16:56','',''),(2124097,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:16:56','',''),(2124124,'1','198','1017',463,'Retail Sale Id 1261608',30400.00,0.00,0.00,0.00,300.00,'2021-12-02 09:18:18','',''),(2124125,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 09:18:18','',''),(2124148,'1','198','1017',463,'Retail Sale Id 1261622',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:19:40','',''),(2124149,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:19:40','',''),(2124164,'1','198','1017',463,'Retail Sale Id 1261631',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 09:20:27','',''),(2124165,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:20:27','',''),(2124200,'1','198','1017',463,'Retail Sale Id 1261647',11552.00,0.00,0.00,0.00,114.00,'2021-12-02 09:22:49','',''),(2124201,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-02 09:22:49','',''),(2124226,'1','198','1017',463,'Retail Sale Id 1261666',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 09:24:09','',''),(2124227,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:24:09','',''),(2124260,'1','198','1017',463,'Retail Sale Id 1261682',3501.28,0.00,0.00,0.00,166.20,'2021-12-02 09:26:06','',''),(2124261,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-02 09:26:06','',''),(2124280,'1','198','1017',463,'Retail Sale Id 1261691',7600.00,0.00,0.00,0.00,75.00,'2021-12-02 09:27:33','',''),(2124281,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:27:33','',''),(2124310,'1','198','1017',463,'Retail Sale Id 1261705',3160.00,0.00,0.00,0.00,150.00,'2021-12-02 09:29:01','',''),(2124311,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:29:01','',''),(2124378,'1','198','1017',463,'Retail Sale Id 1261737',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:33:15','',''),(2124379,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:33:15','',''),(2124389,'1','198','1017',463,'Retail Sale Id 1261743',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:34:10','',''),(2124390,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:34:10','',''),(2124411,'1','198','1017',463,'Retail Sale Id 1261756',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:35:33','',''),(2124412,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:35:33','',''),(2124461,'1','198','1017',463,'Retail Sale Id 1261782',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:40:15','',''),(2124462,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:40:15','',''),(2124780,'1','198','1017',463,'Retail Sale Id 1261951',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:56:11','',''),(2124781,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:56:11','',''),(2124809,'1','198','1017',463,'Retail Sale Id 1261968',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 09:57:44','',''),(2124810,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:57:44','',''),(2124841,'1','198','1017',463,'Retail Sale Id 1261983',1997.12,0.00,0.00,0.00,94.80,'2021-12-02 09:58:52','',''),(2124842,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-02 09:58:52','',''),(2124894,'1','198','1017',463,'Retail Sale Id 1262008',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 10:01:59','',''),(2124895,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 10:01:59','',''),(2124937,'1','198','1017',463,'Retail Sale Id 1262027',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 10:03:50','',''),(2124938,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 10:03:50','',''),(2125001,'1','198','1017',463,'Retail Sale Id 1262067',44080.00,0.00,0.00,0.00,435.00,'2021-12-02 10:08:56','',''),(2125002,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,72.50,0.00,'2021-12-02 10:08:56','',''),(2125015,'1','198','1017',463,'Retail Sale Id 1262075',3648.00,0.00,0.00,0.00,36.00,'2021-12-02 10:10:09','',''),(2125016,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:10:09','',''),(2125130,'1','198','1017',463,'Retail Sale Id 1262125',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 10:16:07','',''),(2125131,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 10:16:07','',''),(2125132,'1','198','1017',463,'Retail Sale Id 1262125',4430.32,0.00,0.00,0.00,210.30,'2021-12-02 10:16:07','',''),(2125133,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,7.01,0.00,'2021-12-02 10:16:07','',''),(2125162,'1','198','1017',463,'Retail Sale Id 1262147',115520.00,0.00,0.00,0.00,1140.00,'2021-12-02 10:18:06','',''),(2125163,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,190.00,0.00,'2021-12-02 10:18:06','',''),(2125184,'1','198','1017',463,'Retail Sale Id 1262157',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 10:19:09','',''),(2125185,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 10:19:09','',''),(2125202,'1','198','1017',463,'Retail Sale Id 1262165',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 10:19:55','',''),(2125203,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:19:55','',''),(2125232,'1','198','1017',463,'Retail Sale Id 1262177',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 10:21:49','',''),(2125233,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 10:21:49','',''),(2125255,'1','198','1017',463,'Retail Sale Id 1262195',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 10:23:03','',''),(2125256,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 10:23:03','',''),(2125301,'1','198','1017',463,'Retail Sale Id 1262207',22496.00,0.00,0.00,0.00,222.00,'2021-12-02 10:25:04','',''),(2125302,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,37.00,0.00,'2021-12-02 10:25:04','',''),(2125344,'1','198','1017',463,'Retail Sale Id 1262234',91200.00,0.00,0.00,0.00,900.00,'2021-12-02 10:27:05','',''),(2125345,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 10:27:05','',''),(2125366,'1','198','1017',463,'Retail Sale Id 1262244',304000.00,0.00,0.00,0.00,3000.00,'2021-12-02 10:28:53','',''),(2125367,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-02 10:28:53','',''),(2125386,'1','198','1017',463,'Retail Sale Id 1262254',38000.00,0.00,0.00,0.00,375.00,'2021-12-02 10:30:16','',''),(2125387,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-02 10:30:16','',''),(2125402,'1','198','1017',463,'Retail Sale Id 1262263',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 10:31:33','',''),(2125403,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 10:31:33','',''),(2125432,'1','198','1017',463,'Retail Sale Id 1262277',7600.00,0.00,0.00,0.00,75.00,'2021-12-02 10:33:35','',''),(2125433,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:33:35','',''),(2125530,'1','198','1017',463,'Retail Sale Id 1262324',4999.12,0.00,0.00,0.00,237.30,'2021-12-02 10:38:59','',''),(2125531,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-02 10:38:59','',''),(2125576,'1','198','1017',463,'Retail Sale Id 1262346',25499.52,0.00,0.00,0.00,251.64,'2021-12-02 10:42:10','',''),(2125577,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,41.94,0.00,'2021-12-02 10:42:10','',''),(2125880,'1','198','1017',463,'Retail Sale Id 1262499',3501.28,0.00,0.00,0.00,166.20,'2021-12-02 11:02:14','',''),(2125881,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-02 11:02:14','',''),(2125962,'1','198','1017',463,'Retail Sale Id 1262545',3147.36,0.00,0.00,0.00,149.40,'2021-12-02 11:07:10','',''),(2125963,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-02 11:07:10','',''),(2126051,'1','198','1017',463,'Retail Sale Id 1262593',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 11:12:13','',''),(2126052,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 11:12:13','',''),(2126262,'1','198','1017',463,'Retail Sale Id 1262708',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 11:24:58','',''),(2126263,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:24:58','',''),(2126332,'1','198','1017',463,'Retail Sale Id 1262742',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 11:28:30','',''),(2126333,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 11:28:30','',''),(2126384,'1','198','1017',463,'Retail Sale Id 1262765',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 11:30:54','',''),(2126385,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 11:30:54','',''),(2126386,'1','198','1017',463,'Retail Sale Id 1262765',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 11:30:54','',''),(2126387,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 11:30:54','',''),(2126611,'1','198','1017',463,'Retail Sale Id 1262852',15200.00,0.00,0.00,0.00,150.00,'2021-12-02 11:41:16','',''),(2126612,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 11:41:16','',''),(2126641,'1','198','1017',463,'Retail Sale Id 1262868',60800.00,0.00,0.00,0.00,600.00,'2021-12-02 11:43:42','',''),(2126642,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 11:43:42','',''),(2126859,'1','198','1017',463,'Retail Sale Id 1262982',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 12:01:35','',''),(2126860,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 12:01:35','',''),(2126871,'1','198','1017',463,'Retail Sale Id 1262988',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 12:03:05','',''),(2126872,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 12:03:05','',''),(2126879,'1','198','1017',463,'Retail Sale Id 1262993',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 12:03:54','',''),(2126880,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:03:54','',''),(2126905,'1','198','1017',463,'Retail Sale Id 1263006',3147.36,0.00,0.00,0.00,149.40,'2021-12-02 12:05:26','',''),(2126906,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-02 12:05:26','',''),(2126918,'1','198','1017',463,'Retail Sale Id 1263013',121200.00,0.00,0.00,0.00,800.00,'2021-12-02 12:07:04','',''),(2126919,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 12:07:04','',''),(2126936,'1','198','1017',463,'Retail Sale Id 1263023',17024.00,0.00,0.00,0.00,168.00,'2021-12-02 12:09:05','',''),(2126937,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-02 12:09:05','',''),(2127066,'1','198','1017',463,'Retail Sale Id 1263085',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 12:20:47','',''),(2127067,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 12:20:47','',''),(2127196,'1','198','1017',463,'Retail Sale Id 1263153',7600.00,0.00,0.00,0.00,75.00,'2021-12-02 12:29:57','',''),(2127197,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:29:57','',''),(2127230,'1','198','1017',463,'Retail Sale Id 1263190',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 12:32:07','',''),(2127231,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 12:32:07','',''),(2127284,'1','198','1017',463,'Retail Sale Id 1263215',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 12:36:36','',''),(2127285,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:36:36','',''),(2127328,'1','198','1017',463,'Retail Sale Id 1263243',7600.00,0.00,0.00,0.00,75.00,'2021-12-02 12:39:28','',''),(2127329,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:39:28','',''),(2127390,'1','198','1017',463,'Retail Sale Id 1263272',21888.00,0.00,0.00,0.00,216.00,'2021-12-02 12:46:11','',''),(2127391,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-02 12:46:11','',''),(2127421,'1','198','1017',463,'Retail Sale Id 1263281',30400.00,0.00,0.00,0.00,300.00,'2021-12-02 12:47:22','',''),(2127422,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:47:22','',''),(2127477,'1','198','1017',463,'Retail Sale Id 1263302',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 12:50:22','',''),(2127478,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 12:50:22','',''),(2127612,'1','198','1017',463,'Retail Sale Id 1263366',60800.00,0.00,0.00,0.00,600.00,'2021-12-02 13:01:03','',''),(2127613,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 13:01:03','',''),(2127634,'1','198','1017',463,'Retail Sale Id 1263380',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 13:02:09','',''),(2127635,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 13:02:09','',''),(2127656,'1','198','1017',463,'Retail Sale Id 1263391',3103.12,0.00,0.00,0.00,147.30,'2021-12-02 13:03:38','',''),(2127657,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.91,0.00,'2021-12-02 13:03:38','',''),(2127694,'1','198','1017',463,'Retail Sale Id 1263411',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 13:07:20','',''),(2127695,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 13:07:20','',''),(2128017,'1','198','1017',463,'Retail Sale Id 1263545',3899.44,0.00,0.00,0.00,185.10,'2021-12-02 13:27:50','',''),(2128018,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-02 13:27:50','',''),(2128051,'1','198','1017',463,'Retail Sale Id 1263560',1997.12,0.00,0.00,0.00,94.80,'2021-12-02 13:30:21','',''),(2128052,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-02 13:30:21','',''),(2128077,'1','198','1017',463,'Retail Sale Id 1263572',1301.92,0.00,0.00,0.00,61.80,'2021-12-02 13:32:34','',''),(2128078,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-02 13:32:34','',''),(2128089,'1','198','1017',463,'Retail Sale Id 1263577',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 13:33:29','',''),(2128090,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 13:33:29','',''),(2128128,'1','198','1017',463,'Retail Sale Id 1263592',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 13:36:18','',''),(2128129,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 13:36:18','',''),(2128130,'1','198','1017',463,'Retail Sale Id 1263592',6320.00,0.00,0.00,0.00,300.00,'2021-12-02 13:36:18','',''),(2128131,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 13:36:18','',''),(2128136,'1','198','1017',463,'Retail Sale Id 1263595',7002.56,0.00,0.00,0.00,332.40,'2021-12-02 13:37:08','',''),(2128137,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-02 13:37:08','',''),(2128158,'1','198','1017',463,'Retail Sale Id 1263605',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 13:38:39','',''),(2128159,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 13:38:39','',''),(2128182,'1','198','1017',463,'Retail Sale Id 1263608',600.40,0.00,0.00,0.00,28.50,'2021-12-02 13:39:29','',''),(2128183,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,0.95,0.00,'2021-12-02 13:39:29','',''),(2128202,'1','198','1017',463,'Retail Sale Id 1263615',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 13:40:56','',''),(2128203,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:40:56','',''),(2128234,'1','198','1017',463,'Retail Sale Id 1263633',3002.00,0.00,0.00,0.00,142.50,'2021-12-02 13:43:16','',''),(2128235,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-02 13:43:16','',''),(2128236,'1','198','1017',463,'Retail Sale Id 1263633',4999.12,0.00,0.00,0.00,237.30,'2021-12-02 13:43:16','',''),(2128237,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-02 13:43:16','',''),(2128306,'1','198','1017',463,'Retail Sale Id 1263675',121600.00,0.00,0.00,0.00,1200.00,'2021-12-02 13:47:36','',''),(2128307,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 13:47:36','',''),(2128346,'1','198','1017',463,'Retail Sale Id 1263689',38000.00,0.00,0.00,0.00,375.00,'2021-12-02 13:48:58','',''),(2128347,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-02 13:48:58','',''),(2128360,'1','198','1017',463,'Retail Sale Id 1263695',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 13:49:57','',''),(2128361,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 13:49:57','',''),(2128395,'1','198','1017',463,'Retail Sale Id 1263713',10944.00,0.00,0.00,0.00,108.00,'2021-12-02 13:52:41','',''),(2128396,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-02 13:52:41','',''),(2128574,'1','198','1017',463,'Retail Sale Id 1263787',3160.00,0.00,0.00,0.00,150.00,'2021-12-02 14:02:32','',''),(2128575,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:02:32','',''),(2128576,'1','198','1017',463,'Retail Sale Id 1263787',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 14:02:32','',''),(2128577,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:02:32','',''),(2128608,'1','198','1017',463,'Retail Sale Id 1263804',5997.68,0.00,0.00,0.00,284.70,'2021-12-02 14:04:14','',''),(2128609,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-02 14:04:14','',''),(2128646,'1','198','1017',463,'Retail Sale Id 1263824',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 14:06:47','',''),(2128647,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 14:06:47','',''),(2128726,'1','198','1017',463,'Retail Sale Id 1263858',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 14:11:16','',''),(2128727,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:11:16','',''),(2128839,'1','198','1017',463,'Retail Sale Id 1263909',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 14:17:50','',''),(2128840,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:17:50','',''),(2128899,'1','198','1017',463,'Retail Sale Id 1263938',3160.00,0.00,0.00,0.00,150.00,'2021-12-02 14:20:37','',''),(2128900,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 14:20:37','',''),(2129116,'1','198','1017',463,'Retail Sale Id 1264010',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 14:28:41','',''),(2129117,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 14:28:41','',''),(2129146,'1','198','1017',463,'Retail Sale Id 1264027',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 14:30:19','',''),(2129147,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 14:30:19','',''),(2129411,'1','198','1017',463,'Retail Sale Id 1264124',638.32,0.00,0.00,0.00,30.30,'2021-12-02 14:41:43','',''),(2129412,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-02 14:41:43','',''),(2129618,'1','198','1017',463,'Retail Sale Id 1264234',7600.00,0.00,0.00,0.00,75.00,'2021-12-02 14:54:26','',''),(2129619,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:54:26','',''),(2129638,'1','198','1017',463,'Retail Sale Id 1264243',998.56,0.00,0.00,0.00,47.40,'2021-12-02 14:55:32','',''),(2129639,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-02 14:55:32','',''),(2129699,'1','198','1017',463,'Retail Sale Id 1264278',16720.00,0.00,0.00,0.00,165.00,'2021-12-02 14:58:14','',''),(2129700,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,27.50,0.00,'2021-12-02 14:58:14','',''),(2129835,'1','198','1017',463,'Retail Sale Id 1264345',2502.72,0.00,0.00,0.00,118.80,'2021-12-02 15:09:02','',''),(2129836,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-02 15:09:02','',''),(2129928,'1','198','1017',463,'Retail Sale Id 1264392',24320.00,0.00,0.00,0.00,240.00,'2021-12-02 15:14:24','',''),(2129929,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 15:14:24','',''),(2129980,'1','198','1017',463,'Retail Sale Id 1264418',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 15:16:59','',''),(2129981,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:16:59','',''),(2130014,'1','198','1017',463,'Retail Sale Id 1264439',12160.00,0.00,0.00,0.00,120.00,'2021-12-02 15:18:40','',''),(2130015,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-02 15:18:40','',''),(2130034,'1','198','1017',463,'Retail Sale Id 1264447',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 15:20:00','',''),(2130035,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 15:20:00','',''),(2130094,'1','198','1017',463,'Retail Sale Id 1264479',12640.00,0.00,0.00,0.00,600.00,'2021-12-02 15:23:43','',''),(2130095,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-02 15:23:43','',''),(2130352,'1','198','1017',463,'Retail Sale Id 1264595',54720.00,0.00,0.00,0.00,540.00,'2021-12-02 15:34:21','',''),(2130353,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-02 15:34:21','',''),(2130392,'1','198','1017',463,'Retail Sale Id 1264615',7900.00,0.00,0.00,0.00,375.00,'2021-12-02 15:35:55','',''),(2130393,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:35:55','',''),(2130574,'1','198','1017',463,'Retail Sale Id 1264716',2502.72,0.00,0.00,0.00,118.80,'2021-12-02 15:44:39','',''),(2130575,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-02 15:44:39','',''),(2130758,'1','198','1017',463,'Retail Sale Id 1264817',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 15:53:07','',''),(2130759,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 15:53:07','',''),(2131263,'1','198','1017',463,'Retail Sale Id 1265064',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 16:15:10','',''),(2131264,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:15:10','',''),(2131297,'1','198','1017',463,'Retail Sale Id 1265079',3002.00,0.00,0.00,0.00,142.50,'2021-12-02 16:16:50','',''),(2131298,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-02 16:16:50','',''),(2131365,'1','198','1017',463,'Retail Sale Id 1265112',121600.00,0.00,0.00,0.00,1200.00,'2021-12-02 16:20:12','',''),(2131366,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 16:20:12','',''),(2131382,'1','198','1017',463,'Retail Sale Id 1265123',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 16:21:20','',''),(2131383,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:21:20','',''),(2131524,'1','198','1017',463,'Retail Sale Id 1265196',1997.12,0.00,0.00,0.00,94.80,'2021-12-02 16:28:18','',''),(2131525,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-02 16:28:18','',''),(2131680,'1','198','1017',463,'Retail Sale Id 1265256',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 16:33:08','',''),(2131681,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:33:08','',''),(2131724,'1','198','1017',463,'Retail Sale Id 1265283',2000.32,0.00,0.00,0.00,19.74,'2021-12-02 16:35:10','',''),(2131725,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.29,0.00,'2021-12-02 16:35:10','',''),(2131921,'1','198','1017',463,'Retail Sale Id 1265376',3798.32,0.00,0.00,0.00,180.30,'2021-12-02 16:45:09','',''),(2131922,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:45:09','',''),(2132016,'1','198','1017',463,'Retail Sale Id 1265434',1902.32,0.00,0.00,0.00,90.30,'2021-12-02 16:51:03','',''),(2132017,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-02 16:51:03','',''),(2134887,'1','198','1017',463,'Retail Sale Id 1266537',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 07:10:19','',''),(2134888,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 07:10:19','',''),(2134889,'1','198','1017',463,'Retail Sale Id 1266537',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 07:10:19','',''),(2134890,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:10:19','',''),(2134954,'1','198','1017',463,'Retail Sale Id 1266559',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 07:12:55','',''),(2134955,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 07:12:55','',''),(2134990,'1','198','1017',463,'Retail Sale Id 1266579',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 07:15:06','',''),(2134991,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:15:06','',''),(2135067,'1','198','1017',463,'Retail Sale Id 1266611',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 07:18:56','',''),(2135068,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 07:18:56','',''),(2135178,'1','198','1017',463,'Retail Sale Id 1266669',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 07:25:42','',''),(2135179,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 07:25:42','',''),(2135180,'1','198','1017',463,'Retail Sale Id 1266669',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 07:25:42','',''),(2135181,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:25:42','',''),(2135204,'1','198','1017',463,'Retail Sale Id 1266682',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 07:27:18','',''),(2135205,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:27:18','',''),(2135206,'1','198','1017',463,'Retail Sale Id 1266682',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 07:27:18','',''),(2135207,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:27:18','',''),(2135331,'1','198','1017',463,'Retail Sale Id 1266747',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 07:34:48','',''),(2135332,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:34:48','',''),(2135485,'1','198','1017',463,'Retail Sale Id 1266817',998.56,0.00,0.00,0.00,47.40,'2021-12-03 07:43:26','',''),(2135486,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-03 07:43:26','',''),(2135606,'1','198','1017',463,'Retail Sale Id 1266875',76000.00,0.00,0.00,0.00,750.00,'2021-12-03 07:49:32','',''),(2135607,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-03 07:49:32','',''),(2135631,'1','198','1017',463,'Retail Sale Id 1266884',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 07:50:21','',''),(2135632,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 07:50:21','',''),(2135719,'1','198','1017',463,'Retail Sale Id 1266921',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 07:55:17','',''),(2135720,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:55:17','',''),(2136072,'1','198','1017',463,'Retail Sale Id 1267070',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 08:10:08','',''),(2136073,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:10:08','',''),(2136096,'1','198','1017',463,'Retail Sale Id 1267084',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 08:11:14','',''),(2136097,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 08:11:14','',''),(2136330,'1','198','1017',463,'Retail Sale Id 1267205',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 08:24:27','',''),(2136331,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 08:24:27','',''),(2136348,'1','198','1017',463,'Retail Sale Id 1267210',6320.00,0.00,0.00,0.00,300.00,'2021-12-03 08:25:10','',''),(2136349,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 08:25:10','',''),(2136412,'1','198','1017',463,'Retail Sale Id 1267243',2502.72,0.00,0.00,0.00,118.80,'2021-12-03 08:29:33','',''),(2136413,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-03 08:29:33','',''),(2136434,'1','198','1017',463,'Retail Sale Id 1267255',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 08:31:34','',''),(2136435,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:31:34','',''),(2136874,'1','198','1017',463,'Retail Sale Id 1267396',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 08:49:47','',''),(2136875,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 08:49:47','',''),(2136932,'1','198','1017',463,'Retail Sale Id 1267425',91200.00,0.00,0.00,0.00,900.00,'2021-12-03 08:53:43','',''),(2136933,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 08:53:43','',''),(2137048,'1','198','1017',463,'Retail Sale Id 1267485',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 08:59:59','',''),(2137049,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 08:59:59','',''),(2137050,'1','198','1017',463,'Retail Sale Id 1267485',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 08:59:59','',''),(2137051,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 08:59:59','',''),(2137132,'1','198','1017',463,'Retail Sale Id 1267533',9424.00,0.00,0.00,0.00,93.00,'2021-12-03 09:03:55','',''),(2137133,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-03 09:03:55','',''),(2137148,'1','198','1017',463,'Retail Sale Id 1267544',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 09:04:46','',''),(2137149,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 09:04:46','',''),(2137168,'1','198','1017',463,'Retail Sale Id 1267553',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 09:05:48','',''),(2137169,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 09:05:48','',''),(2137421,'1','198','1017',463,'Retail Sale Id 1267709',9164.00,0.00,0.00,0.00,435.00,'2021-12-03 09:17:47','',''),(2137422,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-03 09:17:47','',''),(2137701,'1','198','1017',463,'Retail Sale Id 1267858',121600.00,0.00,0.00,0.00,1200.00,'2021-12-03 09:35:00','',''),(2137702,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 09:35:00','',''),(2137930,'1','198','1017',463,'Retail Sale Id 1267977',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 09:49:14','',''),(2137931,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:49:14','',''),(2138122,'1','198','1017',463,'Retail Sale Id 1268070',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:01:30','',''),(2138123,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:01:30','',''),(2138154,'1','198','1017',463,'Retail Sale Id 1268085',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 10:02:59','',''),(2138155,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 10:02:59','',''),(2138385,'1','198','1017',463,'Retail Sale Id 1268207',632.00,0.00,0.00,0.00,30.00,'2021-12-03 10:15:43','',''),(2138386,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 10:15:43','',''),(2138456,'1','198','1017',463,'Retail Sale Id 1268236',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:19:43','',''),(2138457,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:19:43','',''),(2138478,'1','198','1017',463,'Retail Sale Id 1268244',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:20:55','',''),(2138479,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:20:55','',''),(2138556,'1','198','1017',463,'Retail Sale Id 1268291',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 10:25:44','',''),(2138557,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 10:25:44','',''),(2138647,'1','198','1017',463,'Retail Sale Id 1268335',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 10:31:05','',''),(2138648,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 10:31:05','',''),(2138649,'1','198','1017',463,'Retail Sale Id 1268335',5062.32,0.00,0.00,0.00,240.30,'2021-12-03 10:31:05','',''),(2138650,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-03 10:31:05','',''),(2138651,'1','198','1017',463,'Retail Sale Id 1268335',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:31:05','',''),(2138652,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:31:05','',''),(2138709,'1','198','1017',463,'Retail Sale Id 1268364',998.56,0.00,0.00,0.00,47.40,'2021-12-03 10:35:42','',''),(2138710,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-03 10:35:42','',''),(2138805,'1','198','1017',463,'Retail Sale Id 1268408',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:40:44','',''),(2138806,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:40:44','',''),(2138835,'1','198','1017',463,'Retail Sale Id 1268422',2528.00,0.00,0.00,0.00,120.00,'2021-12-03 10:42:55','',''),(2138836,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 10:42:55','',''),(2138861,'1','198','1017',463,'Retail Sale Id 1268444',1497.84,0.00,0.00,0.00,71.10,'2021-12-03 10:45:04','',''),(2138862,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-03 10:45:04','',''),(2138871,'1','198','1017',463,'Retail Sale Id 1268449',79648.00,0.00,0.00,0.00,786.00,'2021-12-03 10:46:02','',''),(2138872,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,131.00,0.00,'2021-12-03 10:46:02','',''),(2138975,'1','198','1017',463,'Retail Sale Id 1268501',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:54:07','',''),(2138976,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:54:07','',''),(2139013,'1','198','1017',463,'Retail Sale Id 1268519',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 10:57:59','',''),(2139014,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:57:59','',''),(2139149,'1','198','1017',463,'Retail Sale Id 1268591',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 11:08:16','',''),(2139150,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:08:16','',''),(2139207,'1','198','1017',463,'Retail Sale Id 1268622',2528.00,0.00,0.00,0.00,120.00,'2021-12-03 11:12:34','',''),(2139208,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 11:12:34','',''),(2139231,'1','198','1017',463,'Retail Sale Id 1268633',1497.84,0.00,0.00,0.00,71.10,'2021-12-03 11:14:04','',''),(2139232,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-03 11:14:04','',''),(2139243,'1','198','1017',463,'Retail Sale Id 1268642',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 11:14:59','',''),(2139244,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 11:14:59','',''),(2139265,'1','198','1017',463,'Retail Sale Id 1268652',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 11:16:03','',''),(2139266,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:16:03','',''),(2139350,'1','198','1017',463,'Retail Sale Id 1268689',38000.00,0.00,0.00,0.00,375.00,'2021-12-03 11:21:47','',''),(2139351,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-03 11:21:47','',''),(2139392,'1','198','1017',463,'Retail Sale Id 1268717',30400.00,0.00,0.00,0.00,300.00,'2021-12-03 11:26:21','',''),(2139393,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 11:26:21','',''),(2139417,'1','198','1017',463,'Retail Sale Id 1268731',7600.00,0.00,0.00,0.00,75.00,'2021-12-03 11:28:22','',''),(2139418,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:28:22','',''),(2139427,'1','198','1017',463,'Retail Sale Id 1268736',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 11:29:24','',''),(2139428,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 11:29:24','',''),(2139443,'1','198','1017',463,'Retail Sale Id 1268747',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 11:30:40','',''),(2139444,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 11:30:40','',''),(2139445,'1','198','1017',463,'Retail Sale Id 1268747',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 11:30:40','',''),(2139446,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 11:30:40','',''),(2139576,'1','198','1017',463,'Retail Sale Id 1268823',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 11:41:29','',''),(2139577,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:41:29','',''),(2139813,'1','198','1017',463,'Retail Sale Id 1268952',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 11:59:22','',''),(2139814,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 11:59:22','',''),(2139943,'1','198','1017',463,'Retail Sale Id 1269040',1997.12,0.00,0.00,0.00,94.80,'2021-12-03 12:07:09','',''),(2139944,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-03 12:07:09','',''),(2140138,'1','198','1017',463,'Retail Sale Id 1269139',30400.00,0.00,0.00,0.00,300.00,'2021-12-03 12:25:16','',''),(2140139,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 12:25:16','',''),(2140155,'1','198','1017',463,'Retail Sale Id 1269147',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 12:26:46','',''),(2140156,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 12:26:46','',''),(2140172,'1','198','1017',463,'Retail Sale Id 1269157',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 12:28:11','',''),(2140173,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:28:11','',''),(2140311,'1','198','1017',463,'Retail Sale Id 1269240',1264.00,0.00,0.00,0.00,60.00,'2021-12-03 12:39:18','',''),(2140312,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 12:39:18','',''),(2140415,'1','198','1017',463,'Retail Sale Id 1269287',1997.12,0.00,0.00,0.00,94.80,'2021-12-03 12:47:03','',''),(2140416,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-03 12:47:03','',''),(2140441,'1','198','1017',463,'Retail Sale Id 1269302',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 12:48:42','',''),(2140442,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 12:48:42','',''),(2140561,'1','198','1017',463,'Retail Sale Id 1269355',9120.00,0.00,0.00,0.00,90.00,'2021-12-03 12:56:19','',''),(2140562,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 12:56:19','',''),(2140681,'1','198','1017',463,'Retail Sale Id 1269412',71440.00,0.00,0.00,0.00,705.00,'2021-12-03 13:05:50','',''),(2140682,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,117.50,0.00,'2021-12-03 13:05:50','',''),(2140695,'1','198','1017',463,'Retail Sale Id 1269420',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 13:06:59','',''),(2140696,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 13:06:59','',''),(2140711,'1','198','1017',463,'Retail Sale Id 1269427',998.56,0.00,0.00,0.00,47.40,'2021-12-03 13:08:28','',''),(2140712,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-03 13:08:28','',''),(2140739,'1','198','1017',463,'Retail Sale Id 1269442',11248.00,0.00,0.00,0.00,111.00,'2021-12-03 13:11:56','',''),(2140740,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-03 13:11:56','',''),(2140891,'1','198','1017',463,'Retail Sale Id 1269505',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 13:24:12','',''),(2140892,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 13:24:12','',''),(2140893,'1','198','1017',463,'Retail Sale Id 1269505',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 13:24:12','',''),(2140894,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:24:12','',''),(2141039,'1','198','1017',463,'Retail Sale Id 1269580',60800.00,0.00,0.00,0.00,600.00,'2021-12-03 13:34:10','',''),(2141040,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 13:34:10','',''),(2141106,'1','198','1017',463,'Retail Sale Id 1269616',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 13:38:33','',''),(2141107,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 13:38:33','',''),(2141120,'1','198','1017',463,'Retail Sale Id 1269623',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 13:39:24','',''),(2141121,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 13:39:24','',''),(2141176,'1','198','1017',463,'Retail Sale Id 1269644',17024.00,0.00,0.00,0.00,168.00,'2021-12-03 13:42:32','',''),(2141177,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-03 13:42:32','',''),(2141270,'1','198','1017',463,'Retail Sale Id 1269690',88768.00,0.00,0.00,0.00,876.00,'2021-12-03 13:47:07','',''),(2141271,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,146.00,0.00,'2021-12-03 13:47:07','',''),(2141393,'1','198','1017',463,'Retail Sale Id 1269710',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 13:49:21','',''),(2141394,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 13:49:21','',''),(2141417,'1','198','1017',463,'Retail Sale Id 1269723',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 13:51:10','',''),(2141418,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 13:51:10','',''),(2141509,'1','198','1017',463,'Retail Sale Id 1269763',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 13:55:44','',''),(2141510,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 13:55:44','',''),(2141578,'1','198','1017',463,'Retail Sale Id 1269796',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 14:01:36','',''),(2141579,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:01:36','',''),(2141806,'1','198','1017',463,'Retail Sale Id 1269895',79575.04,0.00,0.00,0.00,785.28,'2021-12-03 14:15:39','',''),(2141807,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,130.88,0.00,'2021-12-03 14:15:39','',''),(2141832,'1','198','1017',463,'Retail Sale Id 1269903',3103.12,0.00,0.00,0.00,147.30,'2021-12-03 14:17:27','',''),(2141833,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.91,0.00,'2021-12-03 14:17:27','',''),(2141888,'1','198','1017',463,'Retail Sale Id 1269921',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 14:20:11','',''),(2141889,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:20:11','',''),(2141919,'1','198','1017',463,'Return of Retail Sale Id 1269580',0.00,60800.00,100.00,0.00,-600.00,'2021-12-03 14:21:47','',''),(2142066,'1','198',NULL,463,'Purchased from AA RANO NIGERIA LIMITED',0.00,0.00,636.72,0.00,0.00,'2021-12-03 14:30:30','',''),(2142099,'1','198',NULL,463,'Reception corrector for bridging 126079',0.00,0.00,0.00,636.72,0.00,'2021-12-03 14:32:39','',''),(2142100,'1','198','1016',463,'Received from bridging 126079',0.00,0.00,636.72,0.00,0.00,'2021-12-03 14:32:39','',''),(2142175,'1','198','1016',463,'Returned bridging 126079',0.00,0.00,0.00,636.72,0.00,'2021-12-03 14:36:31','',''),(2142176,'1','198',NULL,463,'Reception Return corrector for bridging 126079',0.00,0.00,636.72,0.00,0.00,'2021-12-03 14:36:31','',''),(2142208,'1','198','1016',463,'Retail Sale Id 1270039',48640.00,0.00,0.00,0.00,48640.00,'2021-12-03 14:37:55','',''),(2142209,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-03 14:37:55','',''),(2142299,'1','198','1016',463,'Retail Sale Id 1270075',3798.32,0.00,0.00,0.00,3798.32,'2021-12-03 14:42:06','',''),(2142300,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 14:42:06','',''),(2142301,'1','198',NULL,463,'Returned purchase #86302 to AA RANO NIGERIA LIMITED',0.00,0.00,0.00,636.72,0.00,'2021-12-03 14:42:07','',''),(2142471,'1','198','1016',463,'Return of Retail Sale Id 1270039',0.00,48640.00,80.00,0.00,-48640.00,'2021-12-03 14:48:32','',''),(2142502,'1','198','1016',463,'Return of Retail Sale Id 1270075',0.00,3798.32,6.01,0.00,-3798.32,'2021-12-03 14:50:11','',''),(2142667,'1','198','1017',463,'Distributed to OPERATIONAL LOSS for sales id:336999',0.00,0.00,0.00,543.25,0.00,'2021-12-03 14:57:29','',''),(2142674,'1','198','1016',463,'Distributed to OPERATIONAL LOSS for sales id:336999',0.00,0.00,0.00,636.72,0.00,'2021-12-03 14:58:13','',''),(2142746,'1','198',NULL,463,'Purchased from AA RANO NIGERIA LIMITED',0.00,15080100.00,25050.00,0.00,0.00,'2021-12-03 15:02:56','',''),(2142914,'1','198',NULL,463,'Reception corrector for bridging 126084',0.00,0.00,0.00,25000.00,0.00,'2021-12-03 15:12:25','',''),(2142915,'1','198','1016',463,'Received from bridging 126084',0.00,0.00,25000.00,0.00,0.00,'2021-12-03 15:12:25','',''),(2142928,'1','198','1016',463,'Retail Sale Id 1270372',31600.00,0.00,0.00,0.00,1500.00,'2021-12-03 15:13:17','',''),(2142929,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 15:13:17','',''),(2142942,'1','198','1016',463,'Retail Sale Id 1270380',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 15:13:48','',''),(2142943,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:13:48','',''),(2142956,'1','198','1016',463,'Retail Sale Id 1270387',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 15:14:22','',''),(2142957,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 15:14:22','',''),(2142968,'1','198','1016',463,'Retail Sale Id 1270400',109440.00,0.00,0.00,0.00,1080.00,'2021-12-03 15:15:01','',''),(2142969,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-03 15:15:01','',''),(2142992,'1','198','1016',463,'Retail Sale Id 1270413',121600.00,0.00,0.00,0.00,1200.00,'2021-12-03 15:15:54','',''),(2142993,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 15:15:54','',''),(2143004,'1','198','1016',463,'Retail Sale Id 1270421',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 15:16:46','',''),(2143005,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:16:46','',''),(2143030,'1','198','1016',463,'Retail Sale Id 1270435',998.56,0.00,0.00,0.00,47.40,'2021-12-03 15:17:37','',''),(2143031,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-03 15:17:37','',''),(2143049,'1','198','1016',463,'Retail Sale Id 1270449',4999.12,0.00,0.00,0.00,237.30,'2021-12-03 15:18:58','',''),(2143050,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-03 15:18:58','',''),(2143069,'1','198','1016',463,'Retail Sale Id 1270460',1997.12,0.00,0.00,0.00,94.80,'2021-12-03 15:19:42','',''),(2143070,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-03 15:19:42','',''),(2143093,'1','198','1016',463,'Retail Sale Id 1270473',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 15:20:54','',''),(2143094,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:20:54','',''),(2143139,'1','198','1016',463,'Retail Sale Id 1270494',7904.00,0.00,0.00,0.00,78.00,'2021-12-03 15:23:30','',''),(2143140,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-03 15:23:30','',''),(2143249,'1','198','1016',463,'Retail Sale Id 1270550',2098.24,0.00,0.00,0.00,99.60,'2021-12-03 15:29:22','',''),(2143250,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.32,0.00,'2021-12-03 15:29:22','',''),(2143251,'1','198','1016',463,'Retail Sale Id 1270550',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 15:29:22','',''),(2143252,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:29:22','',''),(2143313,'1','198','1016',463,'Retail Sale Id 1270579',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 15:32:09','',''),(2143314,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:32:09','',''),(2143373,'1','198','1016',463,'Retail Sale Id 1270604',1497.84,0.00,0.00,0.00,71.10,'2021-12-03 15:34:18','',''),(2143374,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-03 15:34:18','',''),(2143466,'1','198','1016',463,'Retail Sale Id 1270656',121600.00,0.00,0.00,0.00,1200.00,'2021-12-03 15:38:15','',''),(2143467,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 15:38:15','',''),(2143586,'1','198','1016',463,'Retail Sale Id 1270716',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 15:43:28','',''),(2143587,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:43:28','',''),(2143622,'1','198','1016',463,'Retail Sale Id 1270733',152000.00,0.00,0.00,0.00,1500.00,'2021-12-03 15:44:50','',''),(2143623,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-03 15:44:50','',''),(2143666,'1','198','1016',463,'Retail Sale Id 1270752',9120.00,0.00,0.00,0.00,90.00,'2021-12-03 15:46:28','',''),(2143667,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 15:46:28','',''),(2143734,'1','198','1016',463,'Retail Sale Id 1270782',30400.00,0.00,0.00,0.00,300.00,'2021-12-03 15:48:34','',''),(2143735,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 15:48:34','',''),(2143901,'1','198','1016',463,'Retail Sale Id 1270873',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 15:57:12','',''),(2143902,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 15:57:12','',''),(2143942,'1','198','1016',463,'Retail Sale Id 1270892',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 15:58:59','',''),(2143943,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:58:59','',''),(2143967,'1','198','1016',463,'Retail Sale Id 1270902',30400.00,0.00,0.00,0.00,300.00,'2021-12-03 16:00:15','',''),(2143968,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:00:15','',''),(2144310,'1','198','1016',463,'Retail Sale Id 1271079',6320.00,0.00,0.00,0.00,300.00,'2021-12-03 16:16:44','',''),(2144311,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:16:44','',''),(2145076,'1','198','1016',463,'Retail Sale Id 1271442',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 16:54:14','',''),(2145077,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:54:14','',''),(2145559,'1','198','1016',463,'Retail Sale Id 1271676',1902.32,0.00,0.00,0.00,90.30,'2021-12-03 17:35:52','',''),(2145560,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-03 17:35:52','',''),(2145561,'1','198','1016',463,'Retail Sale Id 1271676',3160.00,0.00,0.00,0.00,150.00,'2021-12-03 17:35:52','',''),(2145562,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:35:52','',''),(2145701,'1','198','1016',463,'Retail Sale Id 1271743',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 17:56:25','',''),(2145702,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 17:56:25','',''),(2145703,'1','198','1016',463,'Retail Sale Id 1271743',3798.32,0.00,0.00,0.00,180.30,'2021-12-03 17:56:25','',''),(2145704,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 17:56:25','',''),(2145705,'1','198','1016',463,'Retail Sale Id 1271743',7900.00,0.00,0.00,0.00,375.00,'2021-12-03 17:56:25','',''),(2145706,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:56:25','',''),(2147727,'1','198','1016',463,'Return of Retail Sale Id 1270902',0.00,30400.00,50.00,0.00,-300.00,'2021-12-04 07:09:06','',''),(2147792,'1','198','1016',463,'Retail Sale Id 1272487',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 07:13:14','',''),(2147793,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:13:14','',''),(2148166,'1','198','1016',463,'Retail Sale Id 1272689',1997.12,0.00,0.00,0.00,94.80,'2021-12-04 07:32:06','',''),(2148167,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-04 07:32:06','',''),(2148289,'1','198','1016',463,'Retail Sale Id 1272758',3040.00,0.00,0.00,0.00,30.00,'2021-12-04 07:37:24','',''),(2148290,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:37:24','',''),(2148321,'1','198','1016',463,'Retail Sale Id 1272776',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 07:39:02','',''),(2148322,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:39:02','',''),(2148369,'1','198','1016',463,'Retail Sale Id 1272804',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 07:40:46','',''),(2148370,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:40:46','',''),(2148382,'1','198','1016',463,'Retail Sale Id 1272816',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 07:41:55','',''),(2148383,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:41:55','',''),(2148410,'1','198','1016',463,'Retail Sale Id 1272860',60800.00,0.00,0.00,0.00,600.00,'2021-12-04 07:43:28','',''),(2148411,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 07:43:29','',''),(2148655,'1','198','1016',463,'Retail Sale Id 1273029',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 07:58:52','',''),(2148656,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:58:52','',''),(2148833,'1','198','1016',463,'Retail Sale Id 1273114',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 08:05:56','',''),(2148834,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 08:05:56','',''),(2148900,'1','198','1016',463,'Retail Sale Id 1273159',129200.00,0.00,0.00,0.00,1275.00,'2021-12-04 08:08:55','',''),(2148901,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,212.50,0.00,'2021-12-04 08:08:55','',''),(2149011,'1','198','1016',463,'Retail Sale Id 1273215',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 08:13:36','',''),(2149012,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 08:13:36','',''),(2149100,'1','198','1016',463,'Retail Sale Id 1273248',30400.00,0.00,0.00,0.00,300.00,'2021-12-04 08:16:56','',''),(2149101,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:16:56','',''),(2149150,'1','198','1016',463,'Retail Sale Id 1273272',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 08:19:20','',''),(2149151,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 08:19:20','',''),(2149182,'1','198','1016',463,'Retail Sale Id 1273291',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 08:20:29','',''),(2149183,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:20:29','',''),(2149499,'1','198','1016',463,'Retail Sale Id 1273531',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 08:32:44','',''),(2149500,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 08:32:44','',''),(2149612,'1','198','1016',463,'Retail Sale Id 1273591',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 08:37:27','',''),(2149613,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:37:27','',''),(2149800,'1','198','1016',463,'Retail Sale Id 1273675',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 08:44:56','',''),(2149801,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:44:56','',''),(2149942,'1','198','1016',463,'Retail Sale Id 1273753',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 08:51:19','',''),(2149943,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 08:51:19','',''),(2150018,'1','198','1016',463,'Retail Sale Id 1273796',3040.00,0.00,0.00,0.00,30.00,'2021-12-04 08:55:01','',''),(2150019,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:55:01','',''),(2150107,'1','198','1016',463,'Retail Sale Id 1273841',3147.36,0.00,0.00,0.00,149.40,'2021-12-04 08:58:58','',''),(2150108,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-04 08:58:58','',''),(2150153,'1','198','1016',463,'Retail Sale Id 1273862',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 09:00:51','',''),(2150154,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:00:51','',''),(2150183,'1','198','1016',463,'Retail Sale Id 1273878',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 09:02:30','',''),(2150184,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 09:02:30','',''),(2150317,'1','198','1016',463,'Retail Sale Id 1273957',3002.00,0.00,0.00,0.00,142.50,'2021-12-04 09:09:29','',''),(2150318,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-04 09:09:29','',''),(2150429,'1','198','1016',463,'Retail Sale Id 1274010',68400.00,0.00,0.00,0.00,675.00,'2021-12-04 09:15:06','',''),(2150430,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,112.50,0.00,'2021-12-04 09:15:06','',''),(2150527,'1','198','1016',463,'Retail Sale Id 1274064',11692.00,0.00,0.00,0.00,555.00,'2021-12-04 09:19:31','',''),(2150528,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-04 09:19:31','',''),(2150639,'1','198','1016',463,'Retail Sale Id 1274123',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 09:24:53','',''),(2150640,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:24:53','',''),(2150663,'1','198','1016',463,'Retail Sale Id 1274137',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 09:26:16','',''),(2150664,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 09:26:16','',''),(2150665,'1','198','1016',463,'Retail Sale Id 1274137',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 09:26:16','',''),(2150666,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:26:16','',''),(2150681,'1','198','1016',463,'Retail Sale Id 1274143',3147.36,0.00,0.00,0.00,149.40,'2021-12-04 09:27:06','',''),(2150682,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-04 09:27:06','',''),(2150724,'1','198','1016',463,'Retail Sale Id 1274164',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 09:29:23','',''),(2150725,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 09:29:23','',''),(2152387,'1','198','1016',463,'Retail Sale Id 1274362',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 10:28:34','',''),(2152388,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:28:34','',''),(2152411,'1','198','1016',463,'Retail Sale Id 1274374',1257.68,0.00,0.00,0.00,59.70,'2021-12-04 10:29:57','',''),(2152412,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.99,0.00,'2021-12-04 10:29:57','',''),(2152460,'1','198','1016',463,'Return of Retail Sale Id 1274362',0.00,7900.00,12.50,0.00,-375.00,'2021-12-04 10:33:25','',''),(2152692,'1','198','1016',463,'Retail Sale Id 1274480',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 10:49:54','',''),(2152693,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 10:49:54','',''),(2152771,'1','198','1016',463,'Retail Sale Id 1274510',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 10:53:26','',''),(2152772,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:53:26','',''),(2152811,'1','198','1016',463,'Retail Sale Id 1274527',18240.00,0.00,0.00,0.00,180.00,'2021-12-04 10:55:48','',''),(2152812,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-04 10:55:48','',''),(2152857,'1','198','1016',463,'Retail Sale Id 1274549',5062.32,0.00,0.00,0.00,240.30,'2021-12-04 10:58:40','',''),(2152858,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-04 10:58:40','',''),(2152894,'1','198','1016',463,'Retail Sale Id 1274566',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 11:00:52','',''),(2152895,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 11:00:52','',''),(2152896,'1','198','1016',463,'Retail Sale Id 1274566',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 11:00:52','',''),(2152897,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 11:00:52','',''),(2152952,'1','198','1016',463,'Retail Sale Id 1274592',47120.00,0.00,0.00,0.00,465.00,'2021-12-04 11:03:20','',''),(2152953,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,77.50,0.00,'2021-12-04 11:03:20','',''),(2152966,'1','198','1016',463,'Retail Sale Id 1274599',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 11:04:24','',''),(2152967,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 11:04:24','',''),(2152986,'1','198','1016',463,'Retail Sale Id 1274611',6320.00,0.00,0.00,0.00,300.00,'2021-12-04 11:05:30','',''),(2152987,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 11:05:30','',''),(2153046,'1','198','1016',463,'Retail Sale Id 1274642',66871.92,0.00,0.00,0.00,3174.30,'2021-12-04 11:08:30','',''),(2153047,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,105.81,0.00,'2021-12-04 11:08:30','',''),(2153085,'1','198','1016',463,'Retail Sale Id 1274660',1264.00,0.00,0.00,0.00,60.00,'2021-12-04 11:10:28','',''),(2153086,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 11:10:28','',''),(2153329,'1','198','1016',463,'Retail Sale Id 1274783',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 11:21:53','',''),(2153330,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:21:53','',''),(2153426,'1','198','1016',463,'Retail Sale Id 1274836',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 11:28:26','',''),(2153427,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 11:28:26','',''),(2153457,'1','198','1016',463,'Retail Sale Id 1274855',1997.12,0.00,0.00,0.00,94.80,'2021-12-04 11:30:17','',''),(2153458,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-04 11:30:17','',''),(2153517,'1','198','1016',463,'Retail Sale Id 1274883',15200.00,0.00,0.00,0.00,150.00,'2021-12-04 11:32:41','',''),(2153518,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 11:32:41','',''),(2153600,'1','198','1016',463,'Retail Sale Id 1274927',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 11:37:05','',''),(2153601,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 11:37:05','',''),(2153602,'1','198','1016',463,'Retail Sale Id 1274927',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 11:37:05','',''),(2153603,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 11:37:05','',''),(2153645,'1','198','1016',463,'Retail Sale Id 1274936',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 11:38:13','',''),(2153646,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:38:13','',''),(2153824,'1','198','1016',463,'Retail Sale Id 1275015',152000.00,0.00,0.00,0.00,1500.00,'2021-12-04 11:49:08','',''),(2153825,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-04 11:49:08','',''),(2153848,'1','198','1016',463,'Retail Sale Id 1275027',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 11:50:40','',''),(2153849,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 11:50:40','',''),(2154008,'1','198','1016',463,'Retail Sale Id 1275084',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 11:59:18','',''),(2154009,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 11:59:18','',''),(2154010,'1','198','1016',463,'Retail Sale Id 1275084',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 11:59:18','',''),(2154011,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:59:18','',''),(2154107,'1','198','1016',463,'Retail Sale Id 1275110',15200.00,0.00,0.00,0.00,150.00,'2021-12-04 12:02:57','',''),(2154108,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 12:02:57','',''),(2154188,'1','198','1016',463,'Retail Sale Id 1275123',91200.00,0.00,0.00,0.00,900.00,'2021-12-04 12:05:13','',''),(2154189,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 12:05:13','',''),(2154252,'1','198','1016',463,'Retail Sale Id 1275155',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 12:09:09','',''),(2154253,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:09:09','',''),(2154301,'1','198','1016',463,'Retail Sale Id 1275181',7296.00,0.00,0.00,0.00,72.00,'2021-12-04 12:11:37','',''),(2154302,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 12:11:37','',''),(2154323,'1','198','1016',463,'Retail Sale Id 1275191',6320.00,0.00,0.00,0.00,300.00,'2021-12-04 12:13:22','',''),(2154324,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 12:13:22','',''),(2154349,'1','198','1016',463,'Retail Sale Id 1275209',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 12:15:05','',''),(2154350,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:15:05','',''),(2154435,'1','198','1016',463,'Retail Sale Id 1275253',33440.00,0.00,0.00,0.00,330.00,'2021-12-04 12:21:42','',''),(2154436,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-04 12:21:42','',''),(2154601,'1','198','1016',463,'Retail Sale Id 1275337',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 12:30:52','',''),(2154602,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:30:52','',''),(2154651,'1','198','1016',463,'Retail Sale Id 1275359',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 12:33:29','',''),(2154652,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 12:33:29','',''),(2154685,'1','198','1016',463,'Retail Sale Id 1275375',1257.68,0.00,0.00,0.00,59.70,'2021-12-04 12:36:05','',''),(2154686,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.99,0.00,'2021-12-04 12:36:05','',''),(2154802,'1','198','1016',463,'Retail Sale Id 1275434',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 12:44:47','',''),(2154803,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 12:44:47','',''),(2154838,'1','198','1016',463,'Retail Sale Id 1275453',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 12:47:24','',''),(2154839,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 12:47:24','',''),(2155005,'1','198','1016',463,'Retail Sale Id 1275734',3648.00,0.00,0.00,0.00,36.00,'2021-12-04 13:04:39','',''),(2155006,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:04:39','',''),(2155260,'1','198','1016',463,'Retail Sale Id 1275851',38000.00,0.00,0.00,0.00,375.00,'2021-12-04 13:20:31','',''),(2155261,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-04 13:20:31','',''),(2155288,'1','198','1016',463,'Retail Sale Id 1275861',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 13:21:39','',''),(2155289,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:21:39','',''),(2155378,'1','198','1016',463,'Retail Sale Id 1275892',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 13:25:41','',''),(2155379,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 13:25:41','',''),(2155634,'1','198','1016',463,'Retail Sale Id 1276000',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 13:38:47','',''),(2155635,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 13:38:47','',''),(2155662,'1','198','1016',463,'Retail Sale Id 1276012',30400.00,0.00,0.00,0.00,300.00,'2021-12-04 13:40:21','',''),(2155663,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:40:21','',''),(2155702,'1','198','1016',463,'Retail Sale Id 1276035',6320.00,0.00,0.00,0.00,300.00,'2021-12-04 13:42:28','',''),(2155703,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:42:28','',''),(2155750,'1','198','1016',463,'Retail Sale Id 1276059',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 13:44:58','',''),(2155751,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:44:58','',''),(2155814,'1','198','1016',463,'Retail Sale Id 1276088',15200.00,0.00,0.00,0.00,150.00,'2021-12-04 13:48:06','',''),(2155815,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 13:48:06','',''),(2155854,'1','198','1016',463,'Retail Sale Id 1276098',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 13:49:14','',''),(2155855,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:49:14','',''),(2156142,'1','198','1016',463,'Retail Sale Id 1276224',23750.56,0.00,0.00,0.00,1127.40,'2021-12-04 14:03:28','',''),(2156143,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,37.58,0.00,'2021-12-04 14:03:28','',''),(2156414,'1','198','1016',463,'Retail Sale Id 1276349',3002.00,0.00,0.00,0.00,142.50,'2021-12-04 14:14:20','',''),(2156415,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-04 14:14:20','',''),(2156506,'1','198','1016',463,'Retail Sale Id 1276398',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 14:18:36','',''),(2156507,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 14:18:36','',''),(2156584,'1','198','1016',463,'Retail Sale Id 1276442',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 14:22:42','',''),(2156585,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:22:42','',''),(2156586,'1','198','1016',463,'Retail Sale Id 1276442',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 14:22:42','',''),(2156587,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:22:42','',''),(2156588,'1','198','1016',463,'Retail Sale Id 1276442',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 14:22:42','',''),(2156589,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:22:42','',''),(2156665,'1','198','1016',463,'Retail Sale Id 1276475',1264.00,0.00,0.00,0.00,60.00,'2021-12-04 14:27:35','',''),(2156666,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:27:35','',''),(2156685,'1','198','1016',463,'Retail Sale Id 1276487',1264.00,0.00,0.00,0.00,60.00,'2021-12-04 14:29:01','',''),(2156686,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:29:01','',''),(2156707,'1','198','1016',463,'Retail Sale Id 1276498',7002.56,0.00,0.00,0.00,332.40,'2021-12-04 14:30:18','',''),(2156708,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-04 14:30:18','',''),(2156749,'1','198','1016',463,'Retail Sale Id 1276521',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 14:33:03','',''),(2156750,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 14:33:03','',''),(2156862,'1','198','1016',463,'Retail Sale Id 1276572',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 14:38:31','',''),(2156863,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:38:31','',''),(2157106,'1','198','1016',463,'Retail Sale Id 1276651',30400.00,0.00,0.00,0.00,300.00,'2021-12-04 14:49:31','',''),(2157107,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:49:31','',''),(2157140,'1','198','1016',463,'Retail Sale Id 1276671',60600.00,0.00,0.00,0.00,400.00,'2021-12-04 14:51:45','',''),(2157141,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 14:51:45','',''),(2157442,'1','198','1016',463,'Retail Sale Id 1276792',4000.56,0.00,0.00,0.00,189.90,'2021-12-04 15:07:08','',''),(2157443,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-04 15:07:08','',''),(2157546,'1','198','1016',463,'Retail Sale Id 1276845',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 15:14:02','',''),(2157547,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 15:14:02','',''),(2157610,'1','198','1016',463,'Retail Sale Id 1276872',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 15:17:06','',''),(2157611,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:17:06','',''),(2157666,'1','198','1016',463,'Retail Sale Id 1276889',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 15:19:15','',''),(2157667,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 15:19:15','',''),(2157668,'1','198','1016',463,'Retail Sale Id 1276889',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 15:19:15','',''),(2157669,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:19:15','',''),(2157802,'1','198','1016',463,'Retail Sale Id 1276947',6320.00,0.00,0.00,0.00,300.00,'2021-12-04 15:25:15','',''),(2157803,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 15:25:15','',''),(2157852,'1','198','1016',463,'Retail Sale Id 1276968',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 15:27:05','',''),(2157853,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 15:27:05','',''),(2157889,'1','198','1016',463,'Retail Sale Id 1276987',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 15:28:31','',''),(2157890,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 15:28:31','',''),(2157909,'1','198','1016',463,'Retail Sale Id 1276997',1902.32,0.00,0.00,0.00,90.30,'2021-12-04 15:29:36','',''),(2157910,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-04 15:29:36','',''),(2158024,'1','198','1016',463,'Retail Sale Id 1277054',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 15:35:04','',''),(2158025,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:35:04','',''),(2158134,'1','198','1016',463,'Retail Sale Id 1277106',6320.00,0.00,0.00,0.00,300.00,'2021-12-04 15:41:01','',''),(2158135,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 15:41:01','',''),(2158224,'1','198','1016',463,'Retail Sale Id 1277148',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 15:44:42','',''),(2158225,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 15:44:42','',''),(2158348,'1','198','1016',463,'Retail Sale Id 1277202',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 15:50:47','',''),(2158349,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:50:47','',''),(2158400,'1','198','1016',463,'Retail Sale Id 1277228',21280.00,0.00,0.00,0.00,210.00,'2021-12-04 15:53:17','',''),(2158401,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-04 15:53:17','',''),(2158416,'1','198','1016',463,'Retail Sale Id 1277238',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 15:54:14','',''),(2158417,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 15:54:14','',''),(2158450,'1','198','1016',463,'Retail Sale Id 1277261',30400.00,0.00,0.00,0.00,300.00,'2021-12-04 15:55:39','',''),(2158451,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 15:55:39','',''),(2158522,'1','198','1016',463,'Retail Sale Id 1277309',3002.00,0.00,0.00,0.00,142.50,'2021-12-04 15:59:29','',''),(2158523,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-04 15:59:29','',''),(2158555,'1','198','1016',463,'Retail Sale Id 1277326',600.40,0.00,0.00,0.00,28.50,'2021-12-04 16:00:36','',''),(2158556,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.95,0.00,'2021-12-04 16:00:36','',''),(2158676,'1','198','1016',463,'Retail Sale Id 1277385',7600.00,0.00,0.00,0.00,75.00,'2021-12-04 16:07:15','',''),(2158677,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:07:15','',''),(2158730,'1','198','1016',463,'Retail Sale Id 1277412',3798.32,0.00,0.00,0.00,180.30,'2021-12-04 16:09:24','',''),(2158731,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 16:09:24','',''),(2158769,'1','198','1016',463,'Retail Sale Id 1277431',998.56,0.00,0.00,0.00,47.40,'2021-12-04 16:11:02','',''),(2158770,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-04 16:11:02','',''),(2158801,'1','198','1016',463,'Retail Sale Id 1277449',6958.32,0.00,0.00,0.00,330.30,'2021-12-04 16:12:28','',''),(2158802,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.01,0.00,'2021-12-04 16:12:28','',''),(2159243,'1','198','1016',463,'Retail Sale Id 1277680',7900.00,0.00,0.00,0.00,375.00,'2021-12-04 16:32:11','',''),(2159244,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:32:11','',''),(2159287,'1','198','1016',463,'Retail Sale Id 1277702',3160.00,0.00,0.00,0.00,150.00,'2021-12-04 16:35:30','',''),(2159288,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:35:30','',''),(2162017,'1','198','1016',463,'Retail Sale Id 1278647',60800.00,0.00,0.00,0.00,600.00,'2021-12-05 06:07:42','',''),(2162018,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 06:07:42','',''),(2162537,'1','198','1016',463,'Retail Sale Id 1278881',6320.00,0.00,0.00,0.00,300.00,'2021-12-05 06:50:12','',''),(2162538,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 06:50:12','',''),(2162539,'1','198','1016',463,'Retail Sale Id 1278881',6320.00,0.00,0.00,0.00,300.00,'2021-12-05 06:50:12','',''),(2162540,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 06:50:12','',''),(2162993,'1','198','1016',463,'Retail Sale Id 1279121',1997.12,0.00,0.00,0.00,94.80,'2021-12-05 07:15:56','',''),(2162994,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-05 07:15:56','',''),(2163278,'1','198','1016',463,'Retail Sale Id 1279312',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 07:33:47','',''),(2163279,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 07:33:47','',''),(2163318,'1','198','1016',463,'Retail Sale Id 1279334',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 07:35:58','',''),(2163319,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 07:35:58','',''),(2163320,'1','198','1016',463,'Retail Sale Id 1279334',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 07:35:58','',''),(2163321,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 07:35:58','',''),(2163584,'1','198','1016',463,'Retail Sale Id 1279476',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 07:50:26','',''),(2163585,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 07:50:26','',''),(2163627,'1','198','1016',463,'Retail Sale Id 1279494',2502.72,0.00,0.00,0.00,118.80,'2021-12-05 07:51:53','',''),(2163628,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-05 07:51:53','',''),(2163762,'1','198','1016',463,'Retail Sale Id 1279566',5688.00,0.00,0.00,0.00,270.00,'2021-12-05 08:00:08','',''),(2163763,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 08:00:08','',''),(2163852,'1','198','1016',463,'Retail Sale Id 1279618',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 08:05:10','',''),(2163853,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:05:10','',''),(2164078,'1','198','1016',463,'Retail Sale Id 1279758',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 08:16:42','',''),(2164079,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 08:16:42','',''),(2164080,'1','198','1016',463,'Retail Sale Id 1279758',3103.12,0.00,0.00,0.00,147.30,'2021-12-05 08:16:42','',''),(2164081,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.91,0.00,'2021-12-05 08:16:42','',''),(2164134,'1','198','1016',463,'Retail Sale Id 1279774',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 08:19:19','',''),(2164135,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:19:19','',''),(2164266,'1','198','1016',463,'Retail Sale Id 1279840',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 08:24:18','',''),(2164267,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:24:18','',''),(2164268,'1','198','1016',463,'Retail Sale Id 1279840',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 08:24:18','',''),(2164269,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:24:18','',''),(2164304,'1','198','1016',463,'Retail Sale Id 1279868',499.28,0.00,0.00,0.00,23.70,'2021-12-05 08:26:30','',''),(2164305,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-05 08:26:30','',''),(2164324,'1','198','1016',463,'Retail Sale Id 1279887',3002.00,0.00,0.00,0.00,142.50,'2021-12-05 08:27:42','',''),(2164325,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-05 08:27:42','',''),(2164424,'1','198','1016',463,'Retail Sale Id 1279935',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 08:32:29','',''),(2164425,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:32:29','',''),(2164426,'1','198','1016',463,'Retail Sale Id 1279935',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 08:32:29','',''),(2164427,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 08:32:29','',''),(2164554,'1','198','1016',463,'Retail Sale Id 1280008',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 08:39:39','',''),(2164555,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 08:39:39','',''),(2164556,'1','198','1016',463,'Retail Sale Id 1280008',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 08:39:39','',''),(2164557,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:39:39','',''),(2164604,'1','198','1016',463,'Retail Sale Id 1280028',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 08:42:14','',''),(2164605,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:42:14','',''),(2164674,'1','198','1016',463,'Retail Sale Id 1280053',2502.72,0.00,0.00,0.00,118.80,'2021-12-05 08:45:36','',''),(2164675,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-05 08:45:36','',''),(2164743,'1','198','1016',463,'Retail Sale Id 1280085',60800.00,0.00,0.00,0.00,600.00,'2021-12-05 08:49:27','',''),(2164744,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 08:49:27','',''),(2164777,'1','198','1016',463,'Retail Sale Id 1280104',60800.00,0.00,0.00,0.00,600.00,'2021-12-05 08:51:28','',''),(2164778,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 08:51:28','',''),(2164821,'1','198','1016',463,'Retail Sale Id 1280130',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 08:53:47','',''),(2164822,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:53:47','',''),(2164930,'1','198','1016',463,'Retail Sale Id 1280192',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 09:00:12','',''),(2164931,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:00:12','',''),(2165290,'1','198','1016',463,'Retail Sale Id 1280410',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 09:19:38','',''),(2165291,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:19:38','',''),(2165538,'1','198','1016',463,'Retail Sale Id 1280553',44080.00,0.00,0.00,0.00,435.00,'2021-12-05 09:32:56','',''),(2165539,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,72.50,0.00,'2021-12-05 09:32:56','',''),(2165892,'1','198','1016',463,'Retail Sale Id 1280703',7249.04,0.00,0.00,0.00,344.10,'2021-12-05 09:47:33','',''),(2165893,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.47,0.00,'2021-12-05 09:47:33','',''),(2165947,'1','198','1016',463,'Retail Sale Id 1280728',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 09:50:19','',''),(2165948,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 09:50:19','',''),(2166075,'1','198','1016',463,'Retail Sale Id 1280798',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 09:58:10','',''),(2166076,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 09:58:10','',''),(2166132,'1','198','1016',463,'Retail Sale Id 1280825',121600.00,0.00,0.00,0.00,1200.00,'2021-12-05 10:01:11','',''),(2166133,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-05 10:01:11','',''),(2166152,'1','198','1016',463,'Retail Sale Id 1280837',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 10:02:46','',''),(2166153,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 10:02:46','',''),(2166263,'1','198','1016',463,'Retail Sale Id 1280893',499.28,0.00,0.00,0.00,23.70,'2021-12-05 10:10:35','',''),(2166264,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-05 10:10:35','',''),(2166323,'1','198','1016',463,'Retail Sale Id 1280921',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 10:14:36','',''),(2166324,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 10:14:36','',''),(2166325,'1','198','1016',463,'Retail Sale Id 1280921',2698.64,0.00,0.00,0.00,128.10,'2021-12-05 10:14:36','',''),(2166326,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-05 10:14:36','',''),(2166425,'1','198','1016',463,'Retail Sale Id 1280979',3147.36,0.00,0.00,0.00,149.40,'2021-12-05 10:21:04','',''),(2166426,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-05 10:21:04','',''),(2166441,'1','198','1016',463,'Retail Sale Id 1280986',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 10:21:53','',''),(2166442,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 10:21:53','',''),(2166465,'1','198','1016',463,'Retail Sale Id 1280998',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 10:23:13','',''),(2166466,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 10:23:13','',''),(2166600,'1','198','1016',463,'Retail Sale Id 1281067',6320.00,0.00,0.00,0.00,300.00,'2021-12-05 10:31:39','',''),(2166601,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 10:31:39','',''),(2166688,'1','198','1016',463,'Retail Sale Id 1281111',5062.32,0.00,0.00,0.00,240.30,'2021-12-05 10:37:06','',''),(2166689,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-05 10:37:06','',''),(2166951,'1','198','1016',463,'Retail Sale Id 1281251',7600.00,0.00,0.00,0.00,75.00,'2021-12-05 10:51:16','',''),(2166952,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:51:16','',''),(2167057,'1','198','1016',463,'Retail Sale Id 1281307',2698.64,0.00,0.00,0.00,128.10,'2021-12-05 10:57:59','',''),(2167058,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.27,0.00,'2021-12-05 10:57:59','',''),(2167138,'1','198','1016',463,'Retail Sale Id 1281341',18252.16,0.00,0.00,0.00,180.12,'2021-12-05 11:02:14','',''),(2167139,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,30.02,0.00,'2021-12-05 11:02:14','',''),(2167154,'1','198','1016',463,'Retail Sale Id 1281350',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 11:03:44','',''),(2167155,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 11:03:44','',''),(2167156,'1','198','1016',463,'Retail Sale Id 1281350',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 11:03:44','',''),(2167157,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:03:44','',''),(2167176,'1','198','1016',463,'Retail Sale Id 1281359',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 11:05:02','',''),(2167177,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:05:02','',''),(2167280,'1','198','1016',463,'Retail Sale Id 1281398',30400.00,0.00,0.00,0.00,300.00,'2021-12-05 11:10:58','',''),(2167281,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:10:58','',''),(2167332,'1','198','1016',463,'Retail Sale Id 1281461',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 11:14:44','',''),(2167333,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:14:44','',''),(2167334,'1','198','1016',463,'Retail Sale Id 1281461',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 11:14:44','',''),(2167335,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:14:44','',''),(2167348,'1','198','1016',463,'Retail Sale Id 1281468',998.56,0.00,0.00,0.00,47.40,'2021-12-05 11:15:35','',''),(2167349,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-05 11:15:35','',''),(2167395,'1','198','1016',463,'Retail Sale Id 1281488',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 11:18:09','',''),(2167396,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 11:18:09','',''),(2167447,'1','198','1016',463,'Retail Sale Id 1281508',48640.00,0.00,0.00,0.00,480.00,'2021-12-05 11:20:53','',''),(2167448,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-05 11:20:53','',''),(2167899,'1','198','1016',463,'Retail Sale Id 1281775',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 11:47:27','',''),(2167900,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:47:27','',''),(2167941,'1','198','1016',463,'Retail Sale Id 1281804',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 11:49:38','',''),(2167942,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:49:38','',''),(2167962,'1','198','1016',463,'Retail Sale Id 1281819',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 11:51:03','',''),(2167964,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 11:51:03','',''),(2168003,'1','198','1016',463,'Retail Sale Id 1281837',3002.00,0.00,0.00,0.00,142.50,'2021-12-05 11:52:59','',''),(2168004,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-05 11:52:59','',''),(2168376,'1','198','1016',463,'Retail Sale Id 1282040',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 12:14:06','',''),(2168377,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 12:14:06','',''),(2168506,'1','198','1016',463,'Retail Sale Id 1282090',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 12:18:16','',''),(2168507,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:18:16','',''),(2168508,'1','198','1016',463,'Retail Sale Id 1282090',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 12:18:16','',''),(2168509,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:18:16','',''),(2168540,'1','198','1016',463,'Retail Sale Id 1282106',1801.20,0.00,0.00,0.00,85.50,'2021-12-05 12:19:49','',''),(2168541,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.85,0.00,'2021-12-05 12:19:49','',''),(2168702,'1','198','1016',463,'Retail Sale Id 1282189',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 12:26:14','',''),(2168703,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 12:26:14','',''),(2168738,'1','198','1016',463,'Retail Sale Id 1282202',12.64,0.00,0.00,0.00,0.60,'2021-12-05 12:27:32','',''),(2168739,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.02,0.00,'2021-12-05 12:27:32','',''),(2168764,'1','198','1016',463,'Retail Sale Id 1282217',9796.00,0.00,0.00,0.00,465.00,'2021-12-05 12:28:33','',''),(2168765,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-05 12:28:33','',''),(2168854,'1','198','1016',463,'Retail Sale Id 1282245',7331.20,0.00,0.00,0.00,348.00,'2021-12-05 12:33:37','',''),(2168855,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.60,0.00,'2021-12-05 12:33:37','',''),(2168880,'1','198','1016',463,'Retail Sale Id 1282281',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 12:34:42','',''),(2168881,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:34:42','',''),(2168896,'1','198','1016',463,'Retail Sale Id 1282289',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 12:35:40','',''),(2168897,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:35:40','',''),(2168910,'1','198','1016',463,'Retail Sale Id 1282295',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 12:36:40','',''),(2168911,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:36:40','',''),(2168937,'1','198','1016',463,'Retail Sale Id 1282309',5062.32,0.00,0.00,0.00,240.30,'2021-12-05 12:38:02','',''),(2168938,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-05 12:38:02','',''),(2168969,'1','198','1016',463,'Retail Sale Id 1282327',45600.00,0.00,0.00,0.00,450.00,'2021-12-05 12:39:35','',''),(2168970,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-05 12:39:35','',''),(2168987,'1','198','1016',463,'Retail Sale Id 1282337',45600.00,0.00,0.00,0.00,450.00,'2021-12-05 12:40:31','',''),(2168988,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-05 12:40:31','',''),(2169091,'1','198','1016',463,'Retail Sale Id 1282395',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 12:46:07','',''),(2169092,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:46:07','',''),(2169117,'1','198','1016',463,'Retail Sale Id 1282420',11248.00,0.00,0.00,0.00,111.00,'2021-12-05 12:48:40','',''),(2169118,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-05 12:48:40','',''),(2169267,'1','198','1016',463,'Retail Sale Id 1282500',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 12:56:47','',''),(2169268,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 12:56:47','',''),(2169269,'1','198','1016',463,'Retail Sale Id 1282500',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 12:56:47','',''),(2169270,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 12:56:47','',''),(2169361,'1','198','1016',463,'Retail Sale Id 1282543',30400.00,0.00,0.00,0.00,300.00,'2021-12-05 13:01:27','',''),(2169362,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:01:27','',''),(2169853,'1','198','1016',463,'Retail Sale Id 1282808',3103.12,0.00,0.00,0.00,147.30,'2021-12-05 13:29:23','',''),(2169854,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.91,0.00,'2021-12-05 13:29:23','',''),(2169879,'1','198','1016',463,'Retail Sale Id 1282823',60800.00,0.00,0.00,0.00,600.00,'2021-12-05 13:31:23','',''),(2169880,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 13:31:23','',''),(2169949,'1','198','1016',463,'Retail Sale Id 1282854',10640.00,0.00,0.00,0.00,105.00,'2021-12-05 13:34:25','',''),(2169950,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-05 13:34:25','',''),(2170069,'1','198','1016',463,'Retail Sale Id 1282902',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 13:40:31','',''),(2170070,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:40:31','',''),(2170147,'1','198','1016',463,'Retail Sale Id 1282919',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 13:43:05','',''),(2170148,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 13:43:05','',''),(2170267,'1','198','1016',463,'Retail Sale Id 1282977',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 13:50:52','',''),(2170268,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 13:50:52','',''),(2170384,'1','198','1016',463,'Retail Sale Id 1283027',30400.00,0.00,0.00,0.00,300.00,'2021-12-05 13:56:39','',''),(2170385,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:56:39','',''),(2170495,'1','198','1016',463,'Retail Sale Id 1283069',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 14:01:59','',''),(2170496,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:01:59','',''),(2170547,'1','198','1016',463,'Retail Sale Id 1283096',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 14:05:24','',''),(2170548,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 14:05:24','',''),(2170830,'1','198','1016',463,'Retail Sale Id 1283205',3103.12,0.00,0.00,0.00,147.30,'2021-12-05 14:18:27','',''),(2170831,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.91,0.00,'2021-12-05 14:18:27','',''),(2170945,'1','198','1016',463,'Retail Sale Id 1283261',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 14:25:41','',''),(2170946,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:25:41','',''),(2171050,'1','198','1016',463,'Retail Sale Id 1283303',111264.00,0.00,0.00,0.00,1098.00,'2021-12-05 14:31:15','',''),(2171051,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,183.00,0.00,'2021-12-05 14:31:16','',''),(2171227,'1','198','1016',463,'Retail Sale Id 1283358',6320.00,0.00,0.00,0.00,300.00,'2021-12-05 14:39:36','',''),(2171228,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 14:39:36','',''),(2171381,'1','198','1016',463,'Retail Sale Id 1283418',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 14:48:40','',''),(2171382,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 14:48:40','',''),(2171495,'1','198','1016',463,'Retail Sale Id 1283477',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 14:56:16','',''),(2171496,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:56:16','',''),(2171741,'1','198','1016',463,'Retail Sale Id 1283604',499.28,0.00,0.00,0.00,23.70,'2021-12-05 15:16:27','',''),(2171742,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-05 15:16:27','',''),(2171808,'1','198','1016',463,'Retail Sale Id 1283632',1497.84,0.00,0.00,0.00,71.10,'2021-12-05 15:20:49','',''),(2171809,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-05 15:20:49','',''),(2171810,'1','198','1016',463,'Retail Sale Id 1283632',3002.00,0.00,0.00,0.00,142.50,'2021-12-05 15:20:49','',''),(2171811,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-05 15:20:49','',''),(2171920,'1','198','1016',463,'Retail Sale Id 1283692',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 15:29:05','',''),(2171921,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:29:05','',''),(2171942,'1','198','1016',463,'Retail Sale Id 1283704',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 15:30:19','',''),(2171943,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 15:30:19','',''),(2172066,'1','198','1016',463,'Retail Sale Id 1283747',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 15:35:24','',''),(2172067,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 15:35:24','',''),(2172177,'1','198','1016',463,'Retail Sale Id 1283812',37696.00,0.00,0.00,0.00,372.00,'2021-12-05 15:41:16','',''),(2172178,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-05 15:41:16','',''),(2172195,'1','198','1016',463,'Retail Sale Id 1283820',91200.00,0.00,0.00,0.00,900.00,'2021-12-05 15:42:05','',''),(2172196,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 15:42:05','',''),(2172225,'1','198','1016',463,'Retail Sale Id 1283833',2502.72,0.00,0.00,0.00,118.80,'2021-12-05 15:43:16','',''),(2172226,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-05 15:43:16','',''),(2172251,'1','198','1016',463,'Retail Sale Id 1283844',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 15:44:44','',''),(2172252,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 15:44:44','',''),(2172309,'1','198','1016',463,'Retail Sale Id 1283883',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 15:47:01','',''),(2172310,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:47:02','',''),(2172642,'1','198','1016',463,'Retail Sale Id 1284061',3160.00,0.00,0.00,0.00,150.00,'2021-12-05 16:07:11','',''),(2172643,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:07:11','',''),(2172734,'1','198','1016',463,'Retail Sale Id 1284104',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 16:12:34','',''),(2172735,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 16:12:34','',''),(2172874,'1','198','1016',463,'Retail Sale Id 1284182',63630.00,0.00,0.00,0.00,420.00,'2021-12-05 16:21:49','',''),(2172875,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-05 16:21:49','',''),(2172916,'1','198','1016',463,'Retail Sale Id 1284200',90900.00,0.00,0.00,0.00,600.00,'2021-12-05 16:23:52','',''),(2172917,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 16:23:52','',''),(2172936,'1','198','1016',463,'Retail Sale Id 1284215',151500.00,0.00,0.00,0.00,1000.00,'2021-12-05 16:25:25','',''),(2172937,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-05 16:25:25','',''),(2172985,'1','198','1016',463,'Retail Sale Id 1284245',30300.00,0.00,0.00,0.00,200.00,'2021-12-05 16:29:04','',''),(2172986,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 16:29:04','',''),(2173039,'1','198','1016',463,'Retail Sale Id 1284263',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 16:32:31','',''),(2173040,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 16:32:31','',''),(2173073,'1','198','1016',463,'Retail Sale Id 1284288',650.96,0.00,0.00,0.00,30.90,'2021-12-05 16:34:17','',''),(2173074,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-05 16:34:17','',''),(2173209,'1','198','1016',463,'Retail Sale Id 1284358',7900.00,0.00,0.00,0.00,375.00,'2021-12-05 16:42:01','',''),(2173210,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:42:01','',''),(2173263,'1','198','1016',463,'Retail Sale Id 1284386',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 16:45:23','',''),(2173264,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 16:45:23','',''),(2173277,'1','198','1016',463,'Retail Sale Id 1284392',3798.32,0.00,0.00,0.00,180.30,'2021-12-05 16:46:09','',''),(2173278,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 16:46:09','',''),(2173423,'1','198','1016',463,'Retail Sale Id 1284468',2212.00,0.00,0.00,0.00,105.00,'2021-12-05 16:55:36','',''),(2173424,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-05 16:55:36','',''),(2173506,'1','198','1016',463,'Retail Sale Id 1284512',1902.32,0.00,0.00,0.00,90.30,'2021-12-05 17:01:08','',''),(2173507,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-05 17:01:08','',''),(2174678,'1','198','1016',463,'Return of Retail Sale Id 1283027',0.00,30400.00,50.00,0.00,-300.00,'2021-12-06 05:13:48','',''),(2174894,'1','198','1016',463,'Retail Sale Id 1284961',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 06:22:19','',''),(2174895,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 06:22:19','',''),(2175137,'1','198','1016',463,'Retail Sale Id 1285044',4999.12,0.00,0.00,0.00,237.30,'2021-12-06 06:45:29','',''),(2175138,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,7.91,0.00,'2021-12-06 06:45:29','',''),(2175565,'1','198','1016',463,'Retail Sale Id 1285233',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 07:13:58','',''),(2175566,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 07:13:58','',''),(2175672,'1','198','1016',463,'Retail Sale Id 1285294',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 07:20:24','',''),(2175673,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 07:20:24','',''),(2175716,'1','198','1016',463,'Retail Sale Id 1285312',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 07:22:45','',''),(2175717,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 07:22:45','',''),(2175718,'1','198','1016',463,'Retail Sale Id 1285312',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 07:22:45','',''),(2175719,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 07:22:45','',''),(2175846,'1','198','1016',463,'Retail Sale Id 1285381',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 07:30:54','',''),(2175847,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 07:30:54','',''),(2175848,'1','198','1016',463,'Retail Sale Id 1285381',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 07:30:54','',''),(2175849,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:30:54','',''),(2175939,'1','198','1016',463,'Retail Sale Id 1285422',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 07:35:53','',''),(2175940,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:35:53','',''),(2175941,'1','198','1016',463,'Retail Sale Id 1285422',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 07:35:53','',''),(2175942,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 07:35:53','',''),(2176200,'1','198','1016',463,'Retail Sale Id 1285556',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 07:48:12','',''),(2176201,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:48:12','',''),(2176454,'1','198','1016',463,'Retail Sale Id 1285633',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 07:58:40','',''),(2176455,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 07:58:40','',''),(2176509,'1','198','1016',463,'Retail Sale Id 1285694',181800.00,0.00,0.00,0.00,1200.00,'2021-12-06 08:02:04','',''),(2176510,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-06 08:02:04','',''),(2176533,'1','198','1016',463,'Retail Sale Id 1285708',6301.04,0.00,0.00,0.00,299.10,'2021-12-06 08:03:19','',''),(2176534,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.97,0.00,'2021-12-06 08:03:19','',''),(2176550,'1','198','1016',463,'Retail Sale Id 1285720',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 08:04:35','',''),(2176551,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 08:04:35','',''),(2176570,'1','198','1016',463,'Retail Sale Id 1285727',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 08:05:37','',''),(2176571,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 08:05:37','',''),(2176621,'1','198','1016',463,'Retail Sale Id 1285750',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 08:07:25','',''),(2176622,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 08:07:25','',''),(2176654,'1','198','1016',463,'Retail Sale Id 1285770',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 08:09:41','',''),(2176655,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:09:41','',''),(2176674,'1','198','1016',463,'Retail Sale Id 1285781',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 08:11:22','',''),(2176675,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 08:11:22','',''),(2176696,'1','198','1016',463,'Retail Sale Id 1285791',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 08:12:49','',''),(2176697,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 08:12:49','',''),(2176714,'1','198','1016',463,'Retail Sale Id 1285801',998.56,0.00,0.00,0.00,47.40,'2021-12-06 08:14:10','',''),(2176715,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-06 08:14:10','',''),(2176822,'1','198','1016',463,'Retail Sale Id 1285856',6301.04,0.00,0.00,0.00,299.10,'2021-12-06 08:23:04','',''),(2176823,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.97,0.00,'2021-12-06 08:23:04','',''),(2176877,'1','198','1016',463,'Retail Sale Id 1285889',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 08:29:20','',''),(2176878,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:29:20','',''),(2176879,'1','198','1016',463,'Retail Sale Id 1285889',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 08:29:20','',''),(2176880,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 08:29:20','',''),(2177074,'1','198','1016',463,'Retail Sale Id 1285963',53200.00,0.00,0.00,0.00,525.00,'2021-12-06 08:43:44','',''),(2177075,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,87.50,0.00,'2021-12-06 08:43:44','',''),(2177118,'1','198','1016',463,'Retail Sale Id 1285997',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 08:46:30','',''),(2177119,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:46:30','',''),(2177253,'1','198','1016',463,'Retail Sale Id 1286033',85728.00,0.00,0.00,0.00,846.00,'2021-12-06 08:56:28','',''),(2177254,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,141.00,0.00,'2021-12-06 08:56:28','',''),(2177371,'1','198','1016',463,'Retail Sale Id 1286115',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 09:05:17','',''),(2177372,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:05:17','',''),(2177500,'1','198','1016',463,'Retail Sale Id 1286177',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 09:13:59','',''),(2177501,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 09:13:59','',''),(2177502,'1','198','1016',463,'Retail Sale Id 1286177',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 09:13:59','',''),(2177503,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 09:13:59','',''),(2177504,'1','198','1016',463,'Retail Sale Id 1286177',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 09:13:59','',''),(2177505,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 09:13:59','',''),(2177506,'1','198','1016',463,'Retail Sale Id 1286177',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 09:13:59','',''),(2177507,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:13:59','',''),(2177532,'1','198','1016',463,'Retail Sale Id 1286194',9480.00,0.00,0.00,0.00,450.00,'2021-12-06 09:16:09','',''),(2177533,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 09:16:09','',''),(2178016,'1','198','1016',463,'Retail Sale Id 1286310',60600.00,0.00,0.00,0.00,400.00,'2021-12-06 09:43:39','',''),(2178017,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 09:43:39','',''),(2178141,'1','198','1016',463,'Retail Sale Id 1286410',60600.00,0.00,0.00,0.00,400.00,'2021-12-06 09:52:36','',''),(2178142,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 09:52:36','',''),(2178157,'1','198','1016',463,'Retail Sale Id 1286472',3002.00,0.00,0.00,0.00,142.50,'2021-12-06 09:53:43','',''),(2178158,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-06 09:53:43','',''),(2178190,'1','198','1016',463,'Retail Sale Id 1286488',24320.00,0.00,0.00,0.00,240.00,'2021-12-06 09:55:22','',''),(2178191,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 09:55:22','',''),(2178328,'1','198','1016',463,'Retail Sale Id 1286559',1200.80,0.00,0.00,0.00,57.00,'2021-12-06 10:05:03','',''),(2178329,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-06 10:05:03','',''),(2178330,'1','198','1016',463,'Retail Sale Id 1286559',1997.12,0.00,0.00,0.00,94.80,'2021-12-06 10:05:03','',''),(2178331,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-06 10:05:03','',''),(2178332,'1','198','1016',463,'Retail Sale Id 1286559',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:05:03','',''),(2178333,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:05:03','',''),(2178334,'1','198','1016',463,'Retail Sale Id 1286559',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:05:03','',''),(2178335,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:05:03','',''),(2178336,'1','198','1016',463,'Retail Sale Id 1286559',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:05:03','',''),(2178337,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:05:03','',''),(2178338,'1','198','1016',463,'Retail Sale Id 1286559',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:05:03','',''),(2178339,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:05:03','',''),(2178340,'1','198','1016',463,'Retail Sale Id 1286559',5056.00,0.00,0.00,0.00,240.00,'2021-12-06 10:05:03','',''),(2178341,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 10:05:03','',''),(2178342,'1','198','1016',463,'Retail Sale Id 1286559',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 10:05:03','',''),(2178343,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:05:03','',''),(2178344,'1','198','1016',463,'Retail Sale Id 1286559',9480.00,0.00,0.00,0.00,450.00,'2021-12-06 10:05:03','',''),(2178345,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 10:05:03','',''),(2178396,'1','198','1016',463,'Retail Sale Id 1286586',15400.64,0.00,0.00,0.00,151.98,'2021-12-06 10:08:22','',''),(2178397,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.33,0.00,'2021-12-06 10:08:22','',''),(2178802,'1','198','1016',463,'Retail Sale Id 1286792',119168.00,0.00,0.00,0.00,1176.00,'2021-12-06 10:35:04','',''),(2178803,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,196.00,0.00,'2021-12-06 10:35:04','',''),(2178818,'1','198','1016',463,'Retail Sale Id 1286804',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:36:43','',''),(2178819,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:36:43','',''),(2178850,'1','198','1016',463,'Retail Sale Id 1286825',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:38:14','',''),(2178851,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:38:14','',''),(2178914,'1','198','1016',463,'Retail Sale Id 1286859',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 10:43:04','',''),(2178915,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:43:04','',''),(2178916,'1','198','1016',463,'Retail Sale Id 1286859',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 10:43:04','',''),(2178917,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:43:04','',''),(2178976,'1','198','1016',463,'Retail Sale Id 1286890',2528.00,0.00,0.00,0.00,120.00,'2021-12-06 10:46:13','',''),(2178977,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 10:46:13','',''),(2178992,'1','198','1016',463,'Retail Sale Id 1286897',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 10:47:04','',''),(2178993,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:47:04','',''),(2179020,'1','198','1016',463,'Retail Sale Id 1286918',60800.00,0.00,0.00,0.00,600.00,'2021-12-06 10:48:52','',''),(2179021,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 10:48:52','',''),(2179046,'1','198','1016',463,'Retail Sale Id 1286937',30400.00,0.00,0.00,0.00,300.00,'2021-12-06 10:50:20','',''),(2179047,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 10:50:20','',''),(2179098,'1','198','1016',463,'Retail Sale Id 1286962',38000.00,0.00,0.00,0.00,375.00,'2021-12-06 10:53:34','',''),(2179099,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-06 10:53:34','',''),(2179124,'1','198','1016',463,'Retail Sale Id 1286981',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 10:54:56','',''),(2179125,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 10:54:56','',''),(2179139,'1','198','1016',463,'Retail Sale Id 1286989',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 10:56:14','',''),(2179140,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 10:56:14','',''),(2179273,'1','198','1016',463,'Retail Sale Id 1287070',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 11:04:30','',''),(2179274,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 11:04:30','',''),(2179645,'1','198','1016',463,'Retail Sale Id 1287275',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 11:27:41','',''),(2179646,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:27:41','',''),(2179714,'1','198','1016',463,'Retail Sale Id 1287310',15200.00,0.00,0.00,0.00,150.00,'2021-12-06 11:32:13','',''),(2179715,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 11:32:13','',''),(2179734,'1','198','1016',463,'Retail Sale Id 1287321',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 11:34:14','',''),(2179735,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:34:14','',''),(2179754,'1','198','1016',463,'Retail Sale Id 1287333',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 11:36:04','',''),(2179755,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 11:36:04','',''),(2179869,'1','198','1016',463,'Retail Sale Id 1287383',60800.00,0.00,0.00,0.00,600.00,'2021-12-06 11:44:45','',''),(2179870,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 11:44:45','',''),(2179882,'1','198','1016',463,'Retail Sale Id 1287438',21280.00,0.00,0.00,0.00,210.00,'2021-12-06 11:47:23','',''),(2179883,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-06 11:47:23','',''),(2179930,'1','198','1016',463,'Retail Sale Id 1287479',30400.00,0.00,0.00,0.00,300.00,'2021-12-06 11:49:35','',''),(2179931,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:49:35','',''),(2179946,'1','198','1016',463,'Retail Sale Id 1287492',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 11:51:09','',''),(2179947,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 11:51:09','',''),(2179966,'1','198','1016',463,'Retail Sale Id 1287503',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 11:52:50','',''),(2179967,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:52:50','',''),(2179988,'1','198','1016',463,'Retail Sale Id 1287513',7600.00,0.00,0.00,0.00,75.00,'2021-12-06 11:54:33','',''),(2179989,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:54:33','',''),(2180038,'1','198','1016',463,'Retail Sale Id 1287535',17024.00,0.00,0.00,0.00,168.00,'2021-12-06 11:56:31','',''),(2180039,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-06 11:56:31','',''),(2180170,'1','198','1016',463,'Retail Sale Id 1287603',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 12:04:54','',''),(2180171,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 12:04:54','',''),(2180188,'1','198','1016',463,'Retail Sale Id 1287610',1997.12,0.00,0.00,0.00,94.80,'2021-12-06 12:05:53','',''),(2180189,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-06 12:05:53','',''),(2180314,'1','198','1016',463,'Retail Sale Id 1287690',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 12:14:07','',''),(2180315,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:14:07','',''),(2180420,'1','198','1016',463,'Retail Sale Id 1287749',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 12:19:30','',''),(2180421,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:19:30','',''),(2180850,'1','198','1016',463,'Retail Sale Id 1287964',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 12:47:05','',''),(2180851,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 12:47:05','',''),(2180970,'1','198','1016',463,'Retail Sale Id 1288032',6320.00,0.00,0.00,0.00,300.00,'2021-12-06 12:54:21','',''),(2180971,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 12:54:21','',''),(2181043,'1','198','1016',463,'Retail Sale Id 1288072',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 12:58:27','',''),(2181044,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 12:58:27','',''),(2181045,'1','198','1016',463,'Retail Sale Id 1288072',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 12:58:27','',''),(2181046,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:58:27','',''),(2181212,'1','198','1016',463,'Retail Sale Id 1288153',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 13:08:11','',''),(2181213,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:08:11','',''),(2181540,'1','198','1016',463,'Retail Sale Id 1288304',998.56,0.00,0.00,0.00,47.40,'2021-12-06 13:26:36','',''),(2181541,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-06 13:26:36','',''),(2181542,'1','198','1016',463,'Retail Sale Id 1288304',3002.00,0.00,0.00,0.00,142.50,'2021-12-06 13:26:36','',''),(2181543,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-06 13:26:36','',''),(2181544,'1','198','1016',463,'Retail Sale Id 1288304',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 13:26:36','',''),(2181545,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 13:26:36','',''),(2181594,'1','198','1016',463,'Retail Sale Id 1288331',12160.00,0.00,0.00,0.00,120.00,'2021-12-06 13:30:35','',''),(2181595,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 13:30:35','',''),(2181694,'1','198','1016',463,'Retail Sale Id 1288343',51680.00,0.00,0.00,0.00,510.00,'2021-12-06 13:35:25','',''),(2181695,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,85.00,0.00,'2021-12-06 13:35:25','',''),(2181754,'1','198','1016',463,'Retail Sale Id 1288382',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 13:38:50','',''),(2181755,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 13:38:50','',''),(2181791,'1','198','1016',463,'Retail Sale Id 1288408',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 13:39:59','',''),(2181792,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:39:59','',''),(2181889,'1','198','1016',463,'Retail Sale Id 1288441',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 13:44:32','',''),(2181890,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:44:32','',''),(2181917,'1','198','1016',463,'Retail Sale Id 1288465',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 13:46:06','',''),(2181918,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:46:06','',''),(2182087,'1','198','1016',463,'Retail Sale Id 1288529',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 13:54:44','',''),(2182088,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 13:54:44','',''),(2182565,'1','198','1016',463,'Retail Sale Id 1288755',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 14:16:16','',''),(2182566,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 14:16:16','',''),(2182567,'1','198','1016',463,'Retail Sale Id 1288755',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 14:16:16','',''),(2182568,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:16:16','',''),(2182569,'1','198','1016',463,'Retail Sale Id 1288755',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 14:16:16','',''),(2182570,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:16:16','',''),(2182571,'1','198','1016',463,'Retail Sale Id 1288755',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 14:16:16','',''),(2182572,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:16:16','',''),(2182599,'1','198','1016',463,'Retail Sale Id 1288768',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 14:17:10','',''),(2182600,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 14:17:10','',''),(2182712,'1','198','1016',463,'Retail Sale Id 1288826',2212.00,0.00,0.00,0.00,105.00,'2021-12-06 14:23:21','',''),(2182713,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 14:23:21','',''),(2182732,'1','198','1016',463,'Retail Sale Id 1288837',1301.92,0.00,0.00,0.00,61.80,'2021-12-06 14:24:25','',''),(2182733,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-06 14:24:25','',''),(2182752,'1','198','1016',463,'Retail Sale Id 1288846',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 14:25:29','',''),(2182753,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 14:25:29','',''),(2182772,'1','198','1016',463,'Retail Sale Id 1288859',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 14:26:42','',''),(2182773,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:26:42','',''),(2182808,'1','198','1016',463,'Retail Sale Id 1288875',997.12,0.00,0.00,0.00,9.84,'2021-12-06 14:28:42','',''),(2182809,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.64,0.00,'2021-12-06 14:28:42','',''),(2182866,'1','198','1016',463,'Retail Sale Id 1288908',114000.00,0.00,0.00,0.00,1125.00,'2021-12-06 14:32:25','',''),(2182867,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,187.50,0.00,'2021-12-06 14:32:25','',''),(2182936,'1','198','1016',463,'Retail Sale Id 1288939',29184.00,0.00,0.00,0.00,288.00,'2021-12-06 14:35:47','',''),(2182937,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-06 14:35:47','',''),(2182954,'1','198','1016',463,'Retail Sale Id 1288948',998.56,0.00,0.00,0.00,47.40,'2021-12-06 14:37:01','',''),(2182955,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-06 14:37:01','',''),(2182992,'1','198','1016',463,'Retail Sale Id 1288967',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 14:39:39','',''),(2182993,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:39:39','',''),(2183109,'1','198','1016',463,'Retail Sale Id 1289007',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 14:43:59','',''),(2183110,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:43:59','',''),(2183137,'1','198','1016',463,'Retail Sale Id 1289019',456000.00,0.00,0.00,0.00,4500.00,'2021-12-06 14:45:44','',''),(2183138,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-06 14:45:44','',''),(2183222,'1','198','1016',463,'Retail Sale Id 1289055',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 14:49:54','',''),(2183223,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:49:54','',''),(2183329,'1','198','1016',463,'Retail Sale Id 1289104',998.56,0.00,0.00,0.00,47.40,'2021-12-06 14:54:58','',''),(2183330,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-06 14:54:58','',''),(2183643,'1','198','1016',463,'Retail Sale Id 1289204',90900.00,0.00,0.00,0.00,600.00,'2021-12-06 15:12:38','',''),(2183644,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 15:12:38','',''),(2183677,'1','198','1016',463,'Retail Sale Id 1289271',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:14:28','',''),(2183678,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:14:28','',''),(2183679,'1','198','1016',463,'Retail Sale Id 1289271',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:14:28','',''),(2183680,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:14:28','',''),(2183681,'1','198','1016',463,'Retail Sale Id 1289271',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:14:28','',''),(2183682,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:14:28','',''),(2183683,'1','198','1016',463,'Retail Sale Id 1289271',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:14:28','',''),(2183684,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:14:28','',''),(2183925,'1','198','1016',463,'Retail Sale Id 1289380',998.56,0.00,0.00,0.00,47.40,'2021-12-06 15:25:11','',''),(2183926,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-06 15:25:11','',''),(2183927,'1','198','1016',463,'Retail Sale Id 1289380',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:25:11','',''),(2183928,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:25:11','',''),(2184031,'1','198','1016',463,'Retail Sale Id 1289436',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:30:57','',''),(2184032,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:30:57','',''),(2184059,'1','198','1016',463,'Retail Sale Id 1289451',3160.00,0.00,0.00,0.00,150.00,'2021-12-06 15:32:20','',''),(2184060,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:32:20','',''),(2184061,'1','198','1016',463,'Retail Sale Id 1289451',7900.00,0.00,0.00,0.00,375.00,'2021-12-06 15:32:20','',''),(2184062,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:32:20','',''),(2184158,'1','198','1016',463,'Retail Sale Id 1289499',30400.00,0.00,0.00,0.00,300.00,'2021-12-06 15:37:49','',''),(2184159,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 15:37:49','',''),(2184408,'1','198','1016',463,'Retail Sale Id 1289573',66880.00,0.00,0.00,0.00,660.00,'2021-12-06 15:45:39','',''),(2184409,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-06 15:45:39','',''),(2184496,'1','198','1016',463,'Retail Sale Id 1289610',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 15:49:37','',''),(2184497,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 15:49:37','',''),(2184556,'1','198','1016',463,'Retail Sale Id 1289640',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 15:52:49','',''),(2184557,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 15:52:49','',''),(2184589,'1','198','1016',463,'Retail Sale Id 1289655',2502.72,0.00,0.00,0.00,118.80,'2021-12-06 15:54:27','',''),(2184590,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-06 15:54:27','',''),(2184611,'1','198','1016',463,'Retail Sale Id 1289665',1099.68,0.00,0.00,0.00,52.20,'2021-12-06 15:55:40','',''),(2184612,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.74,0.00,'2021-12-06 15:55:40','',''),(2184843,'1','198','1016',463,'Retail Sale Id 1289774',1902.32,0.00,0.00,0.00,90.30,'2021-12-06 16:09:48','',''),(2184844,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-06 16:09:48','',''),(2184989,'1','198','1016',463,'Retail Sale Id 1289840',15200.00,0.00,0.00,0.00,150.00,'2021-12-06 16:18:52','',''),(2184990,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 16:18:52','',''),(2185185,'1','198','1016',463,'Retail Sale Id 1289938',897.44,0.00,0.00,0.00,42.60,'2021-12-06 16:28:42','',''),(2185186,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.42,0.00,'2021-12-06 16:28:42','',''),(2185336,'1','198','1016',463,'Retail Sale Id 1290014',3798.32,0.00,0.00,0.00,180.30,'2021-12-06 16:36:17','',''),(2185337,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 16:36:17','',''),(2185425,'1','198','1016',463,'Retail Sale Id 1290051',3040.00,0.00,0.00,0.00,30.00,'2021-12-06 16:40:36','',''),(2185426,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:40:36','',''),(2185624,'1','198','1016',463,'Retail Sale Id 1290148',1497.84,0.00,0.00,0.00,71.10,'2021-12-06 16:51:23','',''),(2185625,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-06 16:51:23','',''),(2185726,'1','198','1016',463,'Retail Sale Id 1290204',1598.96,0.00,0.00,0.00,75.90,'2021-12-06 16:57:24','',''),(2185727,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.53,0.00,'2021-12-06 16:57:24','',''),(2185842,'1','198','1016',463,'Retail Sale Id 1290268',30300.00,0.00,0.00,0.00,200.00,'2021-12-06 17:05:58','',''),(2185843,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 17:05:58','',''),(2185905,'1','198','1016',463,'Retail Sale Id 1290300',60600.00,0.00,0.00,0.00,400.00,'2021-12-06 17:09:43','',''),(2185906,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 17:09:43','',''),(2185969,'1','198','1016',463,'Retail Sale Id 1290336',24320.00,0.00,0.00,0.00,240.00,'2021-12-06 17:14:01','',''),(2185970,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 17:14:01','',''),(2186041,'1','198','1016',463,'Retail Sale Id 1290373',212100.00,0.00,0.00,0.00,1400.00,'2021-12-06 17:21:57','',''),(2186042,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-06 17:21:57','',''),(2187412,'1','198','1016',463,'Retail Sale Id 1290789',151500.00,0.00,0.00,0.00,1000.00,'2021-12-07 06:24:42','',''),(2187413,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 06:24:42','',''),(2187434,'1','198','1016',463,'Retail Sale Id 1290800',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 06:26:33','',''),(2187435,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:26:33','',''),(2187705,'1','198','1016',463,'Return of Retail Sale Id 1290800',0.00,7900.00,12.50,0.00,-375.00,'2021-12-07 06:47:07','',''),(2187738,'1','198','1016',463,'Return of Retail Sale Id 1287479',0.00,30400.00,50.00,0.00,-300.00,'2021-12-07 06:49:29','',''),(2187773,'1','198','1016',463,'Return of Retail Sale Id 1289499',0.00,30400.00,50.00,0.00,-300.00,'2021-12-07 06:50:38','',''),(2187846,'1','198','1016',463,'Retail Sale Id 1290997',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 06:54:55','',''),(2187847,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:54:55','',''),(2187863,'1','198','1016',463,'Retail Sale Id 1291005',151500.00,0.00,0.00,0.00,1000.00,'2021-12-07 06:56:20','',''),(2187864,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-07 06:56:20','',''),(2187875,'1','198','1016',463,'Retail Sale Id 1291010',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 06:56:55','',''),(2187876,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:56:55','',''),(2187893,'1','198','1016',463,'Retail Sale Id 1291018',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 06:58:15','',''),(2187894,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 06:58:15','',''),(2188110,'1','198','1016',463,'Retail Sale Id 1291125',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 07:08:44','',''),(2188111,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:08:44','',''),(2188152,'1','198','1016',463,'Retail Sale Id 1291153',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 07:10:52','',''),(2188153,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:10:52','',''),(2188262,'1','198','1016',463,'Retail Sale Id 1291201',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 07:15:44','',''),(2188263,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:15:44','',''),(2188776,'1','198','1016',463,'Retail Sale Id 1291464',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 07:40:10','',''),(2188777,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:40:10','',''),(2188792,'1','198','1016',463,'Retail Sale Id 1291474',6952.00,0.00,0.00,0.00,330.00,'2021-12-07 07:41:07','',''),(2188793,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 07:41:07','',''),(2188920,'1','198','1016',463,'Retail Sale Id 1291567',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 07:48:03','',''),(2188921,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:48:03','',''),(2188957,'1','198','1016',463,'Retail Sale Id 1291582',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 07:49:49','',''),(2188958,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 07:49:49','',''),(2189027,'1','198','1016',463,'Retail Sale Id 1291613',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 07:53:50','',''),(2189028,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:53:50','',''),(2189385,'1','198','1016',463,'Retail Sale Id 1291780',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 08:13:46','',''),(2189386,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:13:46','',''),(2189424,'1','198','1016',463,'Retail Sale Id 1291799',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:15:56','',''),(2189425,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:15:56','',''),(2189671,'1','198','1016',463,'Retail Sale Id 1291921',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:31:54','',''),(2189672,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:31:54','',''),(2189797,'1','198','1016',463,'Retail Sale Id 1291963',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 08:36:41','',''),(2189798,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 08:36:41','',''),(2189826,'1','198','1016',463,'Retail Sale Id 1291972',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:38:15','',''),(2189827,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:38:15','',''),(2189828,'1','198','1016',463,'Retail Sale Id 1291972',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:38:15','',''),(2189829,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:38:15','',''),(2189894,'1','198','1016',463,'Retail Sale Id 1292003',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:42:02','',''),(2189895,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:42:02','',''),(2189967,'1','198','1016',463,'Retail Sale Id 1292027',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:44:52','',''),(2189968,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:44:52','',''),(2190108,'1','198','1016',463,'Retail Sale Id 1292096',1497.84,0.00,0.00,0.00,71.10,'2021-12-07 08:52:06','',''),(2190109,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-07 08:52:06','',''),(2190110,'1','198','1016',463,'Retail Sale Id 1292096',3002.00,0.00,0.00,0.00,142.50,'2021-12-07 08:52:06','',''),(2190111,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-07 08:52:06','',''),(2190142,'1','198','1016',463,'Retail Sale Id 1292111',1997.12,0.00,0.00,0.00,94.80,'2021-12-07 08:53:51','',''),(2190143,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-07 08:53:51','',''),(2190176,'1','198','1016',463,'Retail Sale Id 1292130',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 08:55:43','',''),(2190177,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 08:55:43','',''),(2190178,'1','198','1016',463,'Retail Sale Id 1292130',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 08:55:43','',''),(2190179,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 08:55:43','',''),(2190192,'1','198','1016',463,'Retail Sale Id 1292138',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 08:56:57','',''),(2190193,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:56:57','',''),(2190258,'1','198','1016',463,'Retail Sale Id 1292172',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 09:02:09','',''),(2190259,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 09:02:09','',''),(2190355,'1','198','1016',463,'Retail Sale Id 1292216',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 09:07:59','',''),(2190356,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 09:07:59','',''),(2190503,'1','198','1016',463,'Retail Sale Id 1292295',499.28,0.00,0.00,0.00,23.70,'2021-12-07 09:15:21','',''),(2190504,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-07 09:15:21','',''),(2190543,'1','198','1016',463,'Retail Sale Id 1292314',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 09:17:29','',''),(2190544,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 09:17:29','',''),(2190657,'1','198','1016',463,'Retail Sale Id 1292366',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 09:24:01','',''),(2190658,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:24:01','',''),(2190659,'1','198','1016',463,'Retail Sale Id 1292366',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 09:24:01','',''),(2190660,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 09:24:01','',''),(2190661,'1','198','1016',463,'Retail Sale Id 1292366',15800.00,0.00,0.00,0.00,750.00,'2021-12-07 09:24:01','',''),(2190662,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 09:24:01','',''),(2190702,'1','198','1016',463,'Retail Sale Id 1292388',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 09:26:28','',''),(2190703,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 09:26:28','',''),(2190942,'1','198','1016',463,'Retail Sale Id 1292504',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 09:37:32','',''),(2190943,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:37:32','',''),(2190992,'1','198','1016',463,'Retail Sale Id 1292528',20064.00,0.00,0.00,0.00,198.00,'2021-12-07 09:40:12','',''),(2190993,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-07 09:40:12','',''),(2191254,'1','198','1016',463,'Retail Sale Id 1292668',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 09:58:36','',''),(2191255,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 09:58:36','',''),(2191347,'1','198','1016',463,'Retail Sale Id 1292716',650.96,0.00,0.00,0.00,30.90,'2021-12-07 10:04:55','',''),(2191348,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.03,0.00,'2021-12-07 10:04:55','',''),(2191370,'1','198','1016',463,'Retail Sale Id 1292726',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 10:06:13','',''),(2191371,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 10:06:13','',''),(2191438,'1','198','1016',463,'Retail Sale Id 1292764',44080.00,0.00,0.00,0.00,435.00,'2021-12-07 10:10:51','',''),(2191439,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,72.50,0.00,'2021-12-07 10:10:51','',''),(2191485,'1','198','1016',463,'Retail Sale Id 1292789',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 10:14:34','',''),(2191486,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 10:14:34','',''),(2191487,'1','198','1016',463,'Retail Sale Id 1292789',5688.00,0.00,0.00,0.00,270.00,'2021-12-07 10:14:34','',''),(2191488,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 10:14:34','',''),(2191507,'1','198','1016',463,'Retail Sale Id 1292801',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 10:15:29','',''),(2191508,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:15:29','',''),(2191551,'1','198','1016',463,'Retail Sale Id 1292822',12160.00,0.00,0.00,0.00,120.00,'2021-12-07 10:17:54','',''),(2191552,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 10:17:54','',''),(2191595,'1','198','1016',463,'Retail Sale Id 1292846',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 10:21:30','',''),(2191596,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:21:30','',''),(2191627,'1','198','1016',463,'Retail Sale Id 1292862',30400.00,0.00,0.00,0.00,300.00,'2021-12-07 10:24:28','',''),(2191628,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 10:24:28','',''),(2192010,'1','198','1016',463,'Retail Sale Id 1293037',91200.00,0.00,0.00,0.00,900.00,'2021-12-07 10:48:06','',''),(2192011,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 10:48:06','',''),(2192020,'1','198','1016',463,'Retail Sale Id 1293044',998.56,0.00,0.00,0.00,47.40,'2021-12-07 10:48:57','',''),(2192021,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-07 10:48:57','',''),(2192133,'1','198','1016',463,'Retail Sale Id 1293105',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 10:55:12','',''),(2192134,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 10:55:12','',''),(2192352,'1','198','1016',463,'Retail Sale Id 1293201',7002.56,0.00,0.00,0.00,332.40,'2021-12-07 11:06:23','',''),(2192353,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-07 11:06:23','',''),(2192428,'1','198','1016',463,'Retail Sale Id 1293238',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 11:09:45','',''),(2192429,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 11:09:45','',''),(2192430,'1','198','1016',463,'Retail Sale Id 1293238',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 11:09:45','',''),(2192431,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 11:09:45','',''),(2192488,'1','198','1016',463,'Retail Sale Id 1293273',30400.00,0.00,0.00,0.00,300.00,'2021-12-07 11:13:14','',''),(2192489,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 11:13:14','',''),(2192506,'1','198','1016',463,'Retail Sale Id 1293288',998.56,0.00,0.00,0.00,47.40,'2021-12-07 11:14:07','',''),(2192507,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-07 11:14:07','',''),(2192518,'1','198','1016',463,'Retail Sale Id 1293295',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 11:15:08','',''),(2192519,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 11:15:08','',''),(2192534,'1','198','1016',463,'Retail Sale Id 1293304',106400.00,0.00,0.00,0.00,1050.00,'2021-12-07 11:16:29','',''),(2192535,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,175.00,0.00,'2021-12-07 11:16:29','',''),(2192562,'1','198','1016',463,'Retail Sale Id 1293319',2528.00,0.00,0.00,0.00,120.00,'2021-12-07 11:18:19','',''),(2192563,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:18:19','',''),(2192584,'1','198','1016',463,'Retail Sale Id 1293343',6496.96,0.00,0.00,0.00,308.40,'2021-12-07 11:19:36','',''),(2192585,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.28,0.00,'2021-12-07 11:19:36','',''),(2192682,'1','198','1016',463,'Retail Sale Id 1293407',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 11:27:52','',''),(2192683,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 11:27:52','',''),(2192708,'1','198','1016',463,'Retail Sale Id 1293423',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 11:29:20','',''),(2192709,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 11:29:20','',''),(2192710,'1','198','1016',463,'Retail Sale Id 1293423',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 11:29:20','',''),(2192711,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 11:29:20','',''),(2192799,'1','198','1016',463,'Retail Sale Id 1293462',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 11:36:07','',''),(2192800,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 11:36:07','',''),(2192877,'1','198','1016',463,'Retail Sale Id 1293504',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 11:41:23','',''),(2192878,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 11:41:23','',''),(2192997,'1','198','1016',463,'Retail Sale Id 1293553',30400.00,0.00,0.00,0.00,300.00,'2021-12-07 11:48:18','',''),(2192998,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 11:48:18','',''),(2193013,'1','198','1016',463,'Retail Sale Id 1293562',26448.00,0.00,0.00,0.00,261.00,'2021-12-07 11:50:25','',''),(2193014,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,43.50,0.00,'2021-12-07 11:50:25','',''),(2193025,'1','198','1016',463,'Retail Sale Id 1293567',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 11:51:16','',''),(2193026,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 11:51:16','',''),(2193149,'1','198','1016',463,'Retail Sale Id 1293640',2528.00,0.00,0.00,0.00,120.00,'2021-12-07 12:02:41','',''),(2193150,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 12:02:41','',''),(2193425,'1','198','1016',463,'Retail Sale Id 1293797',998.56,0.00,0.00,0.00,47.40,'2021-12-07 12:29:07','',''),(2193426,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-07 12:29:07','',''),(2193575,'1','198','1016',463,'Retail Sale Id 1293872',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 12:40:11','',''),(2193576,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:40:11','',''),(2193614,'1','198','1016',463,'Retail Sale Id 1293886',15504.00,0.00,0.00,0.00,153.00,'2021-12-07 12:43:49','',''),(2193615,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.50,0.00,'2021-12-07 12:43:49','',''),(2193847,'1','198','1016',463,'Retail Sale Id 1294026',7600.00,0.00,0.00,0.00,75.00,'2021-12-07 12:59:02','',''),(2193848,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:59:02','',''),(2194385,'1','198','1016',463,'Retail Sale Id 1294352',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 13:30:00','',''),(2194386,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 13:30:00','',''),(2194469,'1','198','1016',463,'Retail Sale Id 1294385',31600.00,0.00,0.00,0.00,1500.00,'2021-12-07 13:35:10','',''),(2194470,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 13:35:10','',''),(2194629,'1','198','1016',463,'Retail Sale Id 1294459',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 13:45:05','',''),(2194630,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 13:45:05','',''),(2194833,'1','198','1016',463,'Retail Sale Id 1294550',1997.12,0.00,0.00,0.00,94.80,'2021-12-07 13:57:31','',''),(2194834,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-07 13:57:31','',''),(2194891,'1','198','1016',463,'Retail Sale Id 1294581',45600.00,0.00,0.00,0.00,450.00,'2021-12-07 14:01:36','',''),(2194892,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-07 14:01:36','',''),(2195035,'1','198','1016',463,'Retail Sale Id 1294652',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 14:10:23','',''),(2195036,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 14:10:23','',''),(2195085,'1','198','1016',463,'Retail Sale Id 1294670',3197.92,0.00,0.00,0.00,151.80,'2021-12-07 14:12:28','',''),(2195086,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-07 14:12:28','',''),(2195376,'1','198','1016',463,'Retail Sale Id 1294791',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 14:27:45','',''),(2195377,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 14:27:45','',''),(2195623,'1','198','1016',463,'Retail Sale Id 1294928',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 14:42:13','',''),(2195624,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:42:13','',''),(2195824,'1','198','1016',463,'Retail Sale Id 1295028',7002.56,0.00,0.00,0.00,332.40,'2021-12-07 14:51:29','',''),(2195825,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-07 14:51:29','',''),(2195852,'1','198','1016',463,'Retail Sale Id 1295047',7600.00,0.00,0.00,0.00,75.00,'2021-12-07 14:52:51','',''),(2195853,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:52:51','',''),(2195912,'1','198','1016',463,'Retail Sale Id 1295079',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 14:57:10','',''),(2195913,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:57:10','',''),(2195960,'1','198','1016',463,'Retail Sale Id 1295101',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 15:00:30','',''),(2195961,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:00:30','',''),(2195982,'1','198','1016',463,'Retail Sale Id 1295112',30400.00,0.00,0.00,0.00,300.00,'2021-12-07 15:02:00','',''),(2195983,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 15:02:00','',''),(2196084,'1','198','1016',463,'Retail Sale Id 1295155',36480.00,0.00,0.00,0.00,360.00,'2021-12-07 15:07:30','',''),(2196085,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 15:07:30','',''),(2196350,'1','198','1016',463,'Retail Sale Id 1295286',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 15:21:29','',''),(2196351,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 15:21:29','',''),(2196352,'1','198','1016',463,'Retail Sale Id 1295286',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 15:21:29','',''),(2196353,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:21:29','',''),(2196388,'1','198','1016',463,'Retail Sale Id 1295314',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 15:23:37','',''),(2196389,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:23:37','',''),(2196472,'1','198','1016',463,'Retail Sale Id 1295357',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 15:27:33','',''),(2196473,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:27:33','',''),(2196711,'1','198','1016',463,'Retail Sale Id 1295473',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 15:38:43','',''),(2196712,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:38:43','',''),(2196845,'1','198','1016',463,'Retail Sale Id 1295524',7600.00,0.00,0.00,0.00,75.00,'2021-12-07 15:44:45','',''),(2196846,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:44:45','',''),(2196879,'1','198','1016',463,'Retail Sale Id 1295551',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 15:46:12','',''),(2196880,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:46:12','',''),(2196881,'1','198','1016',463,'Retail Sale Id 1295551',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 15:46:12','',''),(2196882,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:46:12','',''),(2196901,'1','198','1016',463,'Retail Sale Id 1295562',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 15:47:15','',''),(2196902,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:47:15','',''),(2196949,'1','198','1016',463,'Retail Sale Id 1295588',3160.00,0.00,0.00,0.00,150.00,'2021-12-07 15:50:02','',''),(2196950,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:50:02','',''),(2196974,'1','198','1016',463,'Retail Sale Id 1295601',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 15:51:12','',''),(2196975,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 15:51:12','',''),(2197034,'1','198','1016',463,'Retail Sale Id 1295633',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 15:53:47','',''),(2197035,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:53:47','',''),(2197290,'1','198','1016',463,'Retail Sale Id 1295760',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 16:05:53','',''),(2197291,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:05:53','',''),(2197352,'1','198','1016',463,'Retail Sale Id 1295795',35264.00,0.00,0.00,0.00,348.00,'2021-12-07 16:08:41','',''),(2197353,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-07 16:08:41','',''),(2197414,'1','198','1016',463,'Retail Sale Id 1295830',60800.00,0.00,0.00,0.00,600.00,'2021-12-07 16:12:31','',''),(2197415,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 16:12:31','',''),(2197488,'1','198','1016',463,'Retail Sale Id 1295860',1997.12,0.00,0.00,0.00,94.80,'2021-12-07 16:15:40','',''),(2197489,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-07 16:15:40','',''),(2197506,'1','198','1016',463,'Retail Sale Id 1295877',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 16:16:31','',''),(2197507,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 16:16:31','',''),(2197566,'1','198','1016',463,'Retail Sale Id 1295913',3798.32,0.00,0.00,0.00,180.30,'2021-12-07 16:19:02','',''),(2197567,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 16:19:02','',''),(2197721,'1','198','1016',463,'Retail Sale Id 1295993',1902.32,0.00,0.00,0.00,90.30,'2021-12-07 16:26:44','',''),(2197722,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-07 16:26:44','',''),(2197723,'1','198','1016',463,'Retail Sale Id 1295993',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 16:26:44','',''),(2197724,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:26:44','',''),(2197938,'1','198','1016',463,'Retail Sale Id 1296106',3147.36,0.00,0.00,0.00,149.40,'2021-12-07 16:37:08','',''),(2197939,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-07 16:37:08','',''),(2198051,'1','198','1016',463,'Retail Sale Id 1296168',12160.00,0.00,0.00,0.00,120.00,'2021-12-07 16:44:54','',''),(2198052,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 16:44:54','',''),(2198202,'1','198','1016',463,'Retail Sale Id 1296246',3002.00,0.00,0.00,0.00,142.50,'2021-12-07 16:53:59','',''),(2198203,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-07 16:53:59','',''),(2198543,'1','198','1016',463,'Retail Sale Id 1296415',7900.00,0.00,0.00,0.00,375.00,'2021-12-07 17:13:06','',''),(2198544,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:13:06','',''),(2198549,'1','198','1016',463,'Retail Sale Id 1296417',3002.00,0.00,0.00,0.00,142.50,'2021-12-07 17:13:45','',''),(2198550,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-07 17:13:45','',''),(2199710,'1','198','1016',463,'Return of Retail Sale Id 1295830',0.00,60800.00,100.00,0.00,-600.00,'2021-12-08 05:51:46','',''),(2199715,'1','198','1016',463,'Return of Retail Sale Id 1295112',0.00,30400.00,50.00,0.00,-300.00,'2021-12-08 05:52:26','',''),(2200252,'1','198','1016',463,'Retail Sale Id 1296994',7600.00,0.00,0.00,0.00,75.00,'2021-12-08 06:49:41','',''),(2200253,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:49:41','',''),(2200274,'1','198','1016',463,'Retail Sale Id 1297000',60800.00,0.00,0.00,0.00,600.00,'2021-12-08 06:50:57','',''),(2200275,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 06:50:57','',''),(2200563,'1','198','1016',463,'Retail Sale Id 1297135',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 07:07:42','',''),(2200564,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 07:07:42','',''),(2200615,'1','198','1016',463,'Retail Sale Id 1297159',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 07:12:16','',''),(2200616,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:12:16','',''),(2200641,'1','198','1016',463,'Retail Sale Id 1297173',3147.36,0.00,0.00,0.00,149.40,'2021-12-08 07:14:08','',''),(2200642,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-08 07:14:08','',''),(2200673,'1','198','1016',463,'Retail Sale Id 1297189',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 07:16:09','',''),(2200674,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 07:16:09','',''),(2200784,'1','198','1016',463,'Retail Sale Id 1297234',7002.56,0.00,0.00,0.00,332.40,'2021-12-08 07:20:21','',''),(2200785,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.08,0.00,'2021-12-08 07:20:21','',''),(2200812,'1','198','1016',463,'Retail Sale Id 1297248',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 07:21:53','',''),(2200813,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:21:53','',''),(2200963,'1','198','1016',463,'Retail Sale Id 1297310',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 07:30:23','',''),(2200964,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:30:23','',''),(2201059,'1','198','1016',463,'Retail Sale Id 1297354',60800.00,0.00,0.00,0.00,600.00,'2021-12-08 07:34:46','',''),(2201060,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 07:34:46','',''),(2201501,'1','198','1016',463,'Retail Sale Id 1297558',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 07:57:43','',''),(2201502,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 07:57:43','',''),(2201589,'1','198','1016',463,'Retail Sale Id 1297597',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 08:02:20','',''),(2201590,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 08:02:20','',''),(2201961,'1','198','1016',463,'Retail Sale Id 1297792',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 08:26:26','',''),(2201962,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 08:26:26','',''),(2202336,'1','198','1016',463,'Retail Sale Id 1297930',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 08:45:24','',''),(2202337,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 08:45:24','',''),(2202372,'1','198','1016',463,'Retail Sale Id 1297945',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 08:46:59','',''),(2202373,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:46:59','',''),(2202578,'1','198','1016',463,'Retail Sale Id 1298025',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 08:56:33','',''),(2202579,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:56:33','',''),(2202738,'1','198','1016',463,'Retail Sale Id 1298113',91200.00,0.00,0.00,0.00,900.00,'2021-12-08 09:06:39','',''),(2202739,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-08 09:06:39','',''),(2202787,'1','198','1016',463,'Retail Sale Id 1298143',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 09:10:14','',''),(2202788,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:10:14','',''),(2202880,'1','198','1016',463,'Retail Sale Id 1298179',4000.56,0.00,0.00,0.00,189.90,'2021-12-08 09:14:43','',''),(2202881,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-08 09:14:43','',''),(2202989,'1','198','1016',463,'Retail Sale Id 1298230',5498.40,0.00,0.00,0.00,261.00,'2021-12-08 09:21:35','',''),(2202990,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.70,0.00,'2021-12-08 09:21:35','',''),(2203091,'1','198','1016',463,'Retail Sale Id 1298282',132848.00,0.00,0.00,0.00,1311.00,'2021-12-08 09:31:12','',''),(2203092,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,218.50,0.00,'2021-12-08 09:31:12','',''),(2203277,'1','198','1016',463,'Retail Sale Id 1298377',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 09:46:22','',''),(2203278,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 09:46:22','',''),(2203360,'1','198','1016',463,'Retail Sale Id 1298409',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 09:50:45','',''),(2203361,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 09:50:45','',''),(2203378,'1','198','1016',463,'Retail Sale Id 1298418',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 09:52:16','',''),(2203379,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:52:16','',''),(2203440,'1','198','1016',463,'Retail Sale Id 1298450',30400.00,0.00,0.00,0.00,300.00,'2021-12-08 09:57:42','',''),(2203441,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:57:42','',''),(2203464,'1','198','1016',463,'Retail Sale Id 1298462',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 09:59:29','',''),(2203465,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 09:59:29','',''),(2203466,'1','198','1016',463,'Retail Sale Id 1298462',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 09:59:29','',''),(2203467,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 09:59:29','',''),(2203488,'1','198','1016',463,'Retail Sale Id 1298466',3002.00,0.00,0.00,0.00,142.50,'2021-12-08 10:00:57','',''),(2203489,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-08 10:00:57','',''),(2203550,'1','198','1016',463,'Retail Sale Id 1298491',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 10:04:56','',''),(2203551,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 10:04:56','',''),(2203687,'1','198','1016',463,'Retail Sale Id 1298558',3147.36,0.00,0.00,0.00,149.40,'2021-12-08 10:14:00','',''),(2203688,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-08 10:14:00','',''),(2203721,'1','198','1016',463,'Retail Sale Id 1298576',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 10:15:48','',''),(2203722,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 10:15:48','',''),(2203753,'1','198','1016',463,'Retail Sale Id 1298588',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 10:17:22','',''),(2203754,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:17:22','',''),(2203775,'1','198','1016',463,'Retail Sale Id 1298596',1997.12,0.00,0.00,0.00,94.80,'2021-12-08 10:19:01','',''),(2203776,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-08 10:19:01','',''),(2203883,'1','198','1016',463,'Retail Sale Id 1298655',3147.36,0.00,0.00,0.00,149.40,'2021-12-08 10:25:54','',''),(2203884,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.98,0.00,'2021-12-08 10:25:54','',''),(2203923,'1','198','1016',463,'Retail Sale Id 1298673',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 10:27:54','',''),(2203924,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 10:27:54','',''),(2203965,'1','198','1016',463,'Retail Sale Id 1298683',7912.64,0.00,0.00,0.00,375.60,'2021-12-08 10:30:28','',''),(2203966,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.52,0.00,'2021-12-08 10:30:28','',''),(2203991,'1','198','1016',463,'Retail Sale Id 1298698',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 10:31:58','',''),(2203992,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 10:31:58','',''),(2204011,'1','198','1016',463,'Retail Sale Id 1298709',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 10:33:37','',''),(2204012,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 10:33:37','',''),(2204198,'1','198','1016',463,'Retail Sale Id 1298805',6958.32,0.00,0.00,0.00,330.30,'2021-12-08 10:50:10','',''),(2204199,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,11.01,0.00,'2021-12-08 10:50:10','',''),(2204212,'1','198','1016',463,'Retail Sale Id 1298811',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 10:51:07','',''),(2204213,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 10:51:07','',''),(2204290,'1','198','1016',463,'Retail Sale Id 1298850',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 10:57:18','',''),(2204291,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 10:57:18','',''),(2204368,'1','198','1016',463,'Retail Sale Id 1298889',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 11:04:03','',''),(2204369,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:04:03','',''),(2204384,'1','198','1016',463,'Retail Sale Id 1298897',30400.00,0.00,0.00,0.00,300.00,'2021-12-08 11:05:28','',''),(2204385,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 11:05:28','',''),(2204438,'1','198','1016',463,'Retail Sale Id 1298926',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 11:08:06','',''),(2204439,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 11:08:06','',''),(2204452,'1','198','1016',463,'Retail Sale Id 1298932',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 11:08:58','',''),(2204453,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 11:08:58','',''),(2204618,'1','198','1016',463,'Retail Sale Id 1299019',7600.00,0.00,0.00,0.00,75.00,'2021-12-08 11:20:37','',''),(2204619,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:20:37','',''),(2204702,'1','198','1016',463,'Retail Sale Id 1299063',33440.00,0.00,0.00,0.00,330.00,'2021-12-08 11:27:06','',''),(2204703,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 11:27:06','',''),(2204750,'1','198','1016',463,'Retail Sale Id 1299085',57760.00,0.00,0.00,0.00,570.00,'2021-12-08 11:30:50','',''),(2204751,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-08 11:30:50','',''),(2204806,'1','198','1016',463,'Retail Sale Id 1299120',1997.12,0.00,0.00,0.00,94.80,'2021-12-08 11:34:43','',''),(2204807,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-08 11:34:43','',''),(2205190,'1','198','1016',463,'Retail Sale Id 1299311',2000.32,0.00,0.00,0.00,19.74,'2021-12-08 11:59:55','',''),(2205191,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.29,0.00,'2021-12-08 11:59:55','',''),(2205265,'1','198','1016',463,'Retail Sale Id 1299335',5062.32,0.00,0.00,0.00,240.30,'2021-12-08 12:04:32','',''),(2205266,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-08 12:04:32','',''),(2205285,'1','198','1016',463,'Retail Sale Id 1299343',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 12:06:46','',''),(2205286,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 12:06:46','',''),(2205291,'1','198','1016',463,'Retail Sale Id 1299347',1497.84,0.00,0.00,0.00,71.10,'2021-12-08 12:07:38','',''),(2205292,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.37,0.00,'2021-12-08 12:07:38','',''),(2205315,'1','198','1016',463,'Retail Sale Id 1299357',7600.00,0.00,0.00,0.00,75.00,'2021-12-08 12:09:04','',''),(2205316,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:09:04','',''),(2205401,'1','198','1016',463,'Retail Sale Id 1299397',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 12:15:24','',''),(2205402,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 12:15:24','',''),(2205416,'1','198','1016',463,'Retail Sale Id 1299402',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 12:17:02','',''),(2205417,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 12:17:02','',''),(2205445,'1','198','1016',463,'Retail Sale Id 1299417',45600.00,0.00,0.00,0.00,450.00,'2021-12-08 12:18:54','',''),(2205446,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-08 12:18:54','',''),(2205455,'1','198','1016',463,'Retail Sale Id 1299422',45600.00,0.00,0.00,0.00,450.00,'2021-12-08 12:19:48','',''),(2205456,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-08 12:19:48','',''),(2205485,'1','198','1016',463,'Retail Sale Id 1299437',7904.00,0.00,0.00,0.00,78.00,'2021-12-08 12:22:44','',''),(2205486,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-08 12:22:44','',''),(2205507,'1','198','1016',463,'Retail Sale Id 1299449',3002.00,0.00,0.00,0.00,142.50,'2021-12-08 12:24:50','',''),(2205508,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-08 12:24:50','',''),(2206017,'1','198','1016',463,'Retail Sale Id 1299675',30400.00,0.00,0.00,0.00,300.00,'2021-12-08 12:57:33','',''),(2206018,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 12:57:33','',''),(2206044,'1','198','1016',463,'Retail Sale Id 1299681',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 13:00:33','',''),(2206045,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:00:33','',''),(2206046,'1','198','1016',463,'Retail Sale Id 1299681',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 13:00:33','',''),(2206047,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:00:33','',''),(2206080,'1','198','1016',463,'Retail Sale Id 1299700',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 13:03:15','',''),(2206081,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 13:03:15','',''),(2206082,'1','198','1016',463,'Retail Sale Id 1299700',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 13:03:15','',''),(2206083,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 13:03:15','',''),(2206084,'1','198','1016',463,'Retail Sale Id 1299700',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 13:03:15','',''),(2206085,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 13:03:15','',''),(2206086,'1','198','1016',463,'Retail Sale Id 1299700',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 13:03:15','',''),(2206087,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 13:03:15','',''),(2206116,'1','198','1016',463,'Retail Sale Id 1299715',37875.00,0.00,0.00,0.00,250.00,'2021-12-08 13:05:29','',''),(2206117,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-08 13:05:29','',''),(2206152,'1','198','1016',463,'Retail Sale Id 1299736',91200.00,0.00,0.00,0.00,900.00,'2021-12-08 13:07:57','',''),(2206153,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-08 13:07:57','',''),(2206341,'1','198','1016',463,'Retail Sale Id 1299826',3002.00,0.00,0.00,0.00,142.50,'2021-12-08 13:19:51','',''),(2206342,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-08 13:19:51','',''),(2206425,'1','198','1016',463,'Retail Sale Id 1299869',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 13:26:59','',''),(2206426,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:26:59','',''),(2206457,'1','198','1016',463,'Retail Sale Id 1299885',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 13:28:51','',''),(2206458,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:28:51','',''),(2206501,'1','198','1016',463,'Retail Sale Id 1299898',60600.00,0.00,0.00,0.00,400.00,'2021-12-08 13:30:18','',''),(2206502,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 13:30:18','',''),(2206674,'1','198','1016',463,'Retail Sale Id 1299957',62418.00,0.00,0.00,0.00,412.00,'2021-12-08 13:41:04','',''),(2206675,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,103.00,0.00,'2021-12-08 13:41:04','',''),(2206761,'1','198','1016',463,'Retail Sale Id 1299999',181800.00,0.00,0.00,0.00,1200.00,'2021-12-08 13:44:25','',''),(2206762,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-08 13:44:25','',''),(2206872,'1','198','1016',463,'Retail Sale Id 1300041',15200.00,0.00,0.00,0.00,150.00,'2021-12-08 13:51:04','',''),(2206873,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 13:51:04','',''),(2207020,'1','198','1016',463,'Retail Sale Id 1300106',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 13:59:56','',''),(2207021,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 13:59:56','',''),(2207156,'1','198','1016',463,'Retail Sale Id 1300160',30300.00,0.00,0.00,0.00,200.00,'2021-12-08 14:08:47','',''),(2207157,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 14:08:47','',''),(2207212,'1','198','1016',463,'Retail Sale Id 1300183',3002.00,0.00,0.00,0.00,142.50,'2021-12-08 14:12:17','',''),(2207213,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-08 14:12:17','',''),(2207337,'1','198','1016',463,'Retail Sale Id 1300263',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 14:20:16','',''),(2207338,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 14:20:16','',''),(2207565,'1','198','1016',463,'Retail Sale Id 1300344',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 14:30:29','',''),(2207566,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:30:29','',''),(2207636,'1','198','1016',463,'Retail Sale Id 1300380',7600.00,0.00,0.00,0.00,75.00,'2021-12-08 14:33:44','',''),(2207637,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:33:44','',''),(2207760,'1','198','1016',463,'Retail Sale Id 1300447',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 14:40:48','',''),(2207761,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:40:48','',''),(2207812,'1','198','1016',463,'Retail Sale Id 1300472',4000.56,0.00,0.00,0.00,189.90,'2021-12-08 14:43:27','',''),(2207813,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-08 14:43:27','',''),(2207897,'1','198','1016',463,'Retail Sale Id 1300525',3002.00,0.00,0.00,0.00,142.50,'2021-12-08 14:48:27','',''),(2207898,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-08 14:48:27','',''),(2208295,'1','198','1016',463,'Retail Sale Id 1300704',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 15:13:58','',''),(2208296,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:13:58','',''),(2208659,'1','198','1016',463,'Retail Sale Id 1300880',12160.00,0.00,0.00,0.00,120.00,'2021-12-08 15:32:55','',''),(2208660,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 15:32:55','',''),(2208709,'1','198','1016',463,'Retail Sale Id 1300912',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 15:35:15','',''),(2208710,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 15:35:15','',''),(2208711,'1','198','1016',463,'Retail Sale Id 1300912',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 15:35:15','',''),(2208712,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:35:15','',''),(2208741,'1','198','1016',463,'Retail Sale Id 1300925',3501.28,0.00,0.00,0.00,166.20,'2021-12-08 15:36:39','',''),(2208742,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-08 15:36:39','',''),(2208943,'1','198','1016',463,'Retail Sale Id 1301033',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 15:47:06','',''),(2208944,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 15:47:06','',''),(2208963,'1','198','1016',463,'Retail Sale Id 1301042',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 15:48:14','',''),(2208964,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 15:48:14','',''),(2209029,'1','198','1016',463,'Retail Sale Id 1301073',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 15:52:52','',''),(2209030,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 15:52:52','',''),(2209031,'1','198','1016',463,'Retail Sale Id 1301073',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 15:52:52','',''),(2209032,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:52:52','',''),(2209099,'1','198','1016',463,'Retail Sale Id 1301103',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 15:56:19','',''),(2209100,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 15:56:19','',''),(2209135,'1','198','1016',463,'Retail Sale Id 1301121',998.56,0.00,0.00,0.00,47.40,'2021-12-08 15:58:14','',''),(2209136,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-08 15:58:14','',''),(2209173,'1','198','1016',463,'Retail Sale Id 1301140',7600.00,0.00,0.00,0.00,75.00,'2021-12-08 16:00:04','',''),(2209174,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:00:04','',''),(2209241,'1','198','1016',463,'Retail Sale Id 1301178',17024.00,0.00,0.00,0.00,168.00,'2021-12-08 16:03:05','',''),(2209242,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-08 16:03:05','',''),(2209297,'1','198','1016',463,'Retail Sale Id 1301203',12.64,0.00,0.00,0.00,0.60,'2021-12-08 16:05:49','',''),(2209298,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.02,0.00,'2021-12-08 16:05:49','',''),(2209343,'1','198','1016',463,'Retail Sale Id 1301222',7887.36,0.00,0.00,0.00,374.40,'2021-12-08 16:08:09','',''),(2209344,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.48,0.00,'2021-12-08 16:08:09','',''),(2209452,'1','198','1016',463,'Retail Sale Id 1301275',3160.00,0.00,0.00,0.00,150.00,'2021-12-08 16:12:06','',''),(2209453,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:12:06','',''),(2209454,'1','198','1016',463,'Retail Sale Id 1301275',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 16:12:06','',''),(2209455,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:12:06','',''),(2209480,'1','198','1016',463,'Retail Sale Id 1301289',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 16:13:05','',''),(2209481,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:13:05','',''),(2209502,'1','198','1016',463,'Retail Sale Id 1301301',7900.00,0.00,0.00,0.00,375.00,'2021-12-08 16:14:21','',''),(2209503,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:14:21','',''),(2209634,'1','198','1016',463,'Retail Sale Id 1301349',30400.00,0.00,0.00,0.00,300.00,'2021-12-08 16:18:51','',''),(2209635,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 16:18:51','',''),(2209759,'1','198','1016',463,'Retail Sale Id 1301420',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 16:25:26','',''),(2209760,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 16:25:26','',''),(2209959,'1','198','1016',463,'Retail Sale Id 1301632',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 16:36:06','',''),(2209960,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:36:06','',''),(2209961,'1','198','1016',463,'Retail Sale Id 1301632',3798.32,0.00,0.00,0.00,180.30,'2021-12-08 16:36:06','',''),(2209962,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:36:06','',''),(2209985,'1','198','1016',463,'Retail Sale Id 1301644',1997.12,0.00,0.00,0.00,94.80,'2021-12-08 16:37:18','',''),(2209986,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-08 16:37:18','',''),(2210021,'1','198','1016',463,'Retail Sale Id 1301663',701.52,0.00,0.00,0.00,33.30,'2021-12-08 16:39:09','',''),(2210022,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.11,0.00,'2021-12-08 16:39:09','',''),(2210023,'1','198','1016',463,'Retail Sale Id 1301663',1902.32,0.00,0.00,0.00,90.30,'2021-12-08 16:39:09','',''),(2210024,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-08 16:39:09','',''),(2210294,'1','198','1016',463,'Retail Sale Id 1301800',7600.00,0.00,0.00,0.00,75.00,'2021-12-08 16:52:39','',''),(2210295,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:52:39','',''),(2210322,'1','198','1016',463,'Retail Sale Id 1301808',15200.00,0.00,0.00,0.00,150.00,'2021-12-08 16:54:12','',''),(2210323,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 16:54:12','',''),(2210491,'1','198','1016',463,'Retail Sale Id 1301908',1264.00,0.00,0.00,0.00,60.00,'2021-12-08 17:07:33','',''),(2210492,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 17:07:33','',''),(2211895,'1','198','1016',463,'Return of Retail Sale Id 1301349',0.00,30400.00,50.00,0.00,-300.00,'2021-12-09 06:00:54','',''),(2211940,'1','198','1016',463,'Sale Id shift 244517',0.00,0.00,0.00,50.00,0.00,'2021-12-09 06:05:03','',''),(2211941,'1','198',NULL,463,'Sale Id shift 244517',30100.00,0.00,0.00,0.00,0.00,'2021-12-09 06:05:03','',''),(2212282,'1','198','1016',463,'Retail Sale Id 1302496',90900.00,0.00,0.00,0.00,600.00,'2021-12-09 06:29:56','',''),(2212283,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 06:29:56','',''),(2212304,'1','198','1016',463,'Retail Sale Id 1302514',90900.00,0.00,0.00,0.00,600.00,'2021-12-09 06:31:40','',''),(2212305,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 06:31:40','',''),(2212408,'1','198','1016',463,'Retail Sale Id 1302546',3040.00,0.00,0.00,0.00,30.00,'2021-12-09 06:36:51','',''),(2212409,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 06:36:51','',''),(2212652,'1','198','1016',463,'Retail Sale Id 1302663',7600.00,0.00,0.00,0.00,75.00,'2021-12-09 06:50:07','',''),(2212653,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:50:07','',''),(2212912,'1','198','1016',463,'Retail Sale Id 1302781',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 07:04:58','',''),(2212913,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 07:04:58','',''),(2212947,'1','198','1016',463,'Retail Sale Id 1302794',6351.60,0.00,0.00,0.00,301.50,'2021-12-09 07:06:39','',''),(2212948,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.05,0.00,'2021-12-09 07:06:39','',''),(2213322,'1','198','1016',463,'Retail Sale Id 1302966',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 07:23:08','',''),(2213323,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 07:23:08','',''),(2213687,'1','198','1016',463,'Retail Sale Id 1303149',3160.00,0.00,0.00,0.00,150.00,'2021-12-09 07:41:14','',''),(2213688,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 07:41:14','',''),(2213770,'1','198','1016',463,'Retail Sale Id 1303186',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 07:45:07','',''),(2213771,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:45:07','',''),(2213794,'1','198','1016',463,'Retail Sale Id 1303198',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 07:46:09','',''),(2213795,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 07:46:09','',''),(2213840,'1','198','1016',463,'Retail Sale Id 1303219',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 07:48:08','',''),(2213841,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:48:08','',''),(2213898,'1','198','1016',463,'Retail Sale Id 1303246',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 07:51:28','',''),(2213899,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 07:51:28','',''),(2213942,'1','198','1016',463,'Retail Sale Id 1303265',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 07:53:22','',''),(2213943,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 07:53:22','',''),(2214252,'1','198','1016',463,'Retail Sale Id 1303430',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 08:11:04','',''),(2214253,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 08:11:04','',''),(2214254,'1','198','1016',463,'Retail Sale Id 1303430',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 08:11:04','',''),(2214255,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:11:04','',''),(2214308,'1','198','1016',463,'Retail Sale Id 1303459',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 08:14:34','',''),(2214309,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 08:14:34','',''),(2214354,'1','198','1016',463,'Retail Sale Id 1303485',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 08:16:32','',''),(2214355,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:16:32','',''),(2214391,'1','198','1016',463,'Retail Sale Id 1303495',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 08:17:59','',''),(2214392,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:17:59','',''),(2214494,'1','198','1016',463,'Retail Sale Id 1303536',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 08:22:55','',''),(2214495,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:22:55','',''),(2214496,'1','198','1016',463,'Retail Sale Id 1303536',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 08:22:55','',''),(2214497,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:22:55','',''),(2214559,'1','198','1016',463,'Retail Sale Id 1303562',3160.00,0.00,0.00,0.00,150.00,'2021-12-09 08:25:29','',''),(2214560,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:25:29','',''),(2214677,'1','198','1016',463,'Retail Sale Id 1303603',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 08:30:13','',''),(2214678,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 08:30:13','',''),(2214710,'1','198','1016',463,'Retail Sale Id 1303619',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 08:31:58','',''),(2214711,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 08:31:58','',''),(2214712,'1','198','1016',463,'Retail Sale Id 1303619',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 08:31:58','',''),(2214713,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:31:58','',''),(2215513,'1','198','1016',463,'Retail Sale Id 1304024',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 09:17:25','',''),(2215514,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:17:25','',''),(2215561,'1','198','1016',463,'Retail Sale Id 1304047',5100.24,0.00,0.00,0.00,242.10,'2021-12-09 09:20:13','',''),(2215562,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.07,0.00,'2021-12-09 09:20:13','',''),(2215611,'1','198','1016',463,'Retail Sale Id 1304072',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 09:22:55','',''),(2215612,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 09:22:55','',''),(2215674,'1','198','1016',463,'Retail Sale Id 1304102',6301.04,0.00,0.00,0.00,299.10,'2021-12-09 09:25:28','',''),(2215675,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.97,0.00,'2021-12-09 09:25:28','',''),(2215696,'1','198','1016',463,'Retail Sale Id 1304113',948.00,0.00,0.00,0.00,45.00,'2021-12-09 09:27:02','',''),(2215697,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-09 09:27:02','',''),(2215724,'1','198','1016',463,'Retail Sale Id 1304129',2528.00,0.00,0.00,0.00,120.00,'2021-12-09 09:28:25','',''),(2215725,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 09:28:25','',''),(2215786,'1','198','1016',463,'Retail Sale Id 1304160',18240.00,0.00,0.00,0.00,180.00,'2021-12-09 09:32:27','',''),(2215787,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-09 09:32:28','',''),(2215919,'1','198','1016',463,'Retail Sale Id 1304213',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 09:37:29','',''),(2215920,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 09:37:29','',''),(2215978,'1','198','1016',463,'Retail Sale Id 1304239',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 09:40:52','',''),(2215979,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:40:52','',''),(2216004,'1','198','1016',463,'Retail Sale Id 1304248',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 09:41:57','',''),(2216005,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 09:41:57','',''),(2216153,'1','198','1016',463,'Retail Sale Id 1304291',3197.92,0.00,0.00,0.00,151.80,'2021-12-09 09:48:26','',''),(2216154,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.06,0.00,'2021-12-09 09:48:26','',''),(2216254,'1','198','1016',463,'Retail Sale Id 1304343',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 09:53:53','',''),(2216255,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 09:53:53','',''),(2216376,'1','198','1016',463,'Retail Sale Id 1304403',6320.00,0.00,0.00,0.00,300.00,'2021-12-09 09:59:25','',''),(2216377,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 09:59:25','',''),(2216553,'1','198','1016',463,'Retail Sale Id 1304486',5700.64,0.00,0.00,0.00,270.60,'2021-12-09 10:08:23','',''),(2216554,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.02,0.00,'2021-12-09 10:08:23','',''),(2216581,'1','198','1016',463,'Retail Sale Id 1304503',632.00,0.00,0.00,0.00,30.00,'2021-12-09 10:11:16','',''),(2216582,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 10:11:16','',''),(2216617,'1','198','1016',463,'Retail Sale Id 1304516',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 10:13:21','',''),(2216618,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:13:21','',''),(2216627,'1','198','1016',463,'Retail Sale Id 1304523',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 10:14:34','',''),(2216628,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:14:34','',''),(2216805,'1','198','1016',463,'Retail Sale Id 1304621',30400.00,0.00,0.00,0.00,300.00,'2021-12-09 10:26:04','',''),(2216806,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:26:04','',''),(2216885,'1','198','1016',463,'Retail Sale Id 1304664',3040.00,0.00,0.00,0.00,30.00,'2021-12-09 10:31:03','',''),(2216886,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:31:03','',''),(2216915,'1','198','1016',463,'Retail Sale Id 1304681',7600.00,0.00,0.00,0.00,75.00,'2021-12-09 10:32:54','',''),(2216916,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:32:54','',''),(2216959,'1','198','1016',463,'Retail Sale Id 1304703',44384.00,0.00,0.00,0.00,438.00,'2021-12-09 10:36:10','',''),(2216960,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,73.00,0.00,'2021-12-09 10:36:10','',''),(2217058,'1','198','1016',463,'Retail Sale Id 1304755',90900.00,0.00,0.00,0.00,600.00,'2021-12-09 10:42:51','',''),(2217059,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 10:42:51','',''),(2217126,'1','198','1016',463,'Retail Sale Id 1304793',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 10:47:36','',''),(2217127,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 10:47:36','',''),(2217128,'1','198','1016',463,'Retail Sale Id 1304793',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 10:47:36','',''),(2217129,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 10:47:36','',''),(2217182,'1','198','1016',463,'Retail Sale Id 1304819',30400.00,0.00,0.00,0.00,300.00,'2021-12-09 10:50:34','',''),(2217183,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:50:34','',''),(2217200,'1','198','1016',463,'Retail Sale Id 1304828',3002.00,0.00,0.00,0.00,142.50,'2021-12-09 10:51:24','',''),(2217201,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-09 10:51:24','',''),(2217210,'1','198','1016',463,'Retail Sale Id 1304836',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 10:52:17','',''),(2217211,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 10:52:17','',''),(2217224,'1','198','1016',463,'Retail Sale Id 1304839',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 10:53:26','',''),(2217225,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 10:53:26','',''),(2217346,'1','198','1016',463,'Retail Sale Id 1304899',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 11:01:54','',''),(2217347,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:01:54','',''),(2217374,'1','198','1016',463,'Retail Sale Id 1304914',5997.68,0.00,0.00,0.00,284.70,'2021-12-09 11:03:44','',''),(2217375,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-09 11:03:44','',''),(2217508,'1','198','1016',463,'Retail Sale Id 1304978',46965.00,0.00,0.00,0.00,310.00,'2021-12-09 11:13:51','',''),(2217509,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,77.50,0.00,'2021-12-09 11:13:51','',''),(2217516,'1','198','1016',463,'Retail Sale Id 1304983',4000.56,0.00,0.00,0.00,189.90,'2021-12-09 11:14:58','',''),(2217517,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-09 11:14:58','',''),(2217542,'1','198','1016',463,'Retail Sale Id 1304996',998.56,0.00,0.00,0.00,47.40,'2021-12-09 11:16:42','',''),(2217543,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.58,0.00,'2021-12-09 11:16:42','',''),(2217607,'1','198','1016',463,'Retail Sale Id 1305030',8512.00,0.00,0.00,0.00,84.00,'2021-12-09 11:20:40','',''),(2217608,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-09 11:20:40','',''),(2217687,'1','198','1016',463,'Retail Sale Id 1305067',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 11:23:48','',''),(2217688,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:23:48','',''),(2217862,'1','198','1016',463,'Retail Sale Id 1305148',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 11:34:25','',''),(2217863,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 11:34:25','',''),(2217880,'1','198','1016',463,'Retail Sale Id 1305158',3002.00,0.00,0.00,0.00,142.50,'2021-12-09 11:35:39','',''),(2217881,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-09 11:35:39','',''),(2217955,'1','198','1016',463,'Retail Sale Id 1305192',3160.00,0.00,0.00,0.00,150.00,'2021-12-09 11:41:00','',''),(2217956,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 11:41:00','',''),(2217972,'1','198','1016',463,'Retail Sale Id 1305200',3002.00,0.00,0.00,0.00,142.50,'2021-12-09 11:42:28','',''),(2217973,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-09 11:42:28','',''),(2218144,'1','198','1016',463,'Retail Sale Id 1305285',1997.12,0.00,0.00,0.00,94.80,'2021-12-09 11:52:01','',''),(2218145,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-09 11:52:01','',''),(2218228,'1','198','1016',463,'Retail Sale Id 1305332',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 11:58:11','',''),(2218229,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:58:11','',''),(2218268,'1','198','1016',463,'Retail Sale Id 1305353',10950.08,0.00,0.00,0.00,108.06,'2021-12-09 12:00:21','',''),(2218269,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,18.01,0.00,'2021-12-09 12:00:21','',''),(2218286,'1','198','1016',463,'Retail Sale Id 1305366',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 12:01:56','',''),(2218287,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:01:56','',''),(2218320,'1','198','1016',463,'Retail Sale Id 1305381',1997.12,0.00,0.00,0.00,94.80,'2021-12-09 12:03:56','',''),(2218321,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-09 12:03:56','',''),(2218692,'1','198','1016',463,'Retail Sale Id 1305578',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 12:28:18','',''),(2218693,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 12:28:18','',''),(2218702,'1','198','1016',463,'Retail Sale Id 1305583',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 12:28:56','',''),(2218703,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 12:28:56','',''),(2218720,'1','198','1016',463,'Retail Sale Id 1305592',3648.00,0.00,0.00,0.00,36.00,'2021-12-09 12:29:50','',''),(2218721,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:29:50','',''),(2218780,'1','198','1016',463,'Retail Sale Id 1305623',4000.56,0.00,0.00,0.00,189.90,'2021-12-09 12:33:52','',''),(2218781,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-09 12:33:52','',''),(2218800,'1','198','1016',463,'Retail Sale Id 1305637',49248.00,0.00,0.00,0.00,486.00,'2021-12-09 12:35:13','',''),(2218801,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,81.00,0.00,'2021-12-09 12:35:13','',''),(2218934,'1','198','1016',463,'Retail Sale Id 1305698',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 12:42:39','',''),(2218935,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 12:42:39','',''),(2219329,'1','198','1016',463,'Retail Sale Id 1305895',5997.68,0.00,0.00,0.00,284.70,'2021-12-09 13:05:08','',''),(2219330,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-09 13:05:08','',''),(2219401,'1','198','1016',463,'Retail Sale Id 1305941',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 13:10:12','',''),(2219402,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 13:10:12','',''),(2219478,'1','198','1016',463,'Retail Sale Id 1305963',37696.00,0.00,0.00,0.00,372.00,'2021-12-09 13:13:50','',''),(2219479,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-09 13:13:50','',''),(2219492,'1','198','1016',463,'Retail Sale Id 1305970',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 13:15:46','',''),(2219493,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:15:46','',''),(2219548,'1','198','1016',463,'Retail Sale Id 1305998',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 13:20:05','',''),(2219549,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 13:20:05','',''),(2219609,'1','198','1016',463,'Retail Sale Id 1306027',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 13:25:28','',''),(2219610,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 13:25:28','',''),(2219611,'1','198','1016',463,'Retail Sale Id 1306027',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 13:25:28','',''),(2219612,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 13:25:28','',''),(2219763,'1','198','1016',463,'Retail Sale Id 1306080',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 13:32:05','',''),(2219764,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 13:32:05','',''),(2220126,'1','198','1016',463,'Retail Sale Id 1306221',1997.12,0.00,0.00,0.00,94.80,'2021-12-09 13:51:36','',''),(2220127,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-09 13:51:36','',''),(2220321,'1','198','1016',463,'Retail Sale Id 1306312',5997.68,0.00,0.00,0.00,284.70,'2021-12-09 14:05:45','',''),(2220322,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,9.49,0.00,'2021-12-09 14:05:45','',''),(2220534,'1','198','1016',463,'Retail Sale Id 1306443',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 14:18:19','',''),(2220535,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 14:18:19','',''),(2220536,'1','198','1016',463,'Retail Sale Id 1306443',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 14:18:19','',''),(2220537,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 14:18:19','',''),(2220728,'1','198','1016',463,'Retail Sale Id 1306539',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 14:27:53','',''),(2220729,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 14:27:53','',''),(2220966,'1','198','1016',463,'Retail Sale Id 1306638',7600.00,0.00,0.00,0.00,75.00,'2021-12-09 14:37:51','',''),(2220967,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:37:51','',''),(2221044,'1','198','1016',463,'Retail Sale Id 1306675',3160.00,0.00,0.00,0.00,150.00,'2021-12-09 14:41:31','',''),(2221045,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:41:31','',''),(2221046,'1','198','1016',463,'Retail Sale Id 1306675',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 14:41:31','',''),(2221047,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 14:41:31','',''),(2221048,'1','198','1016',463,'Retail Sale Id 1306675',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 14:41:31','',''),(2221049,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:41:31','',''),(2221167,'1','198','1016',463,'Retail Sale Id 1306740',1200.80,0.00,0.00,0.00,57.00,'2021-12-09 14:46:46','',''),(2221168,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.90,0.00,'2021-12-09 14:46:46','',''),(2221510,'1','198','1016',463,'Retail Sale Id 1306863',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 15:01:39','',''),(2221511,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:01:39','',''),(2221586,'1','198','1016',463,'Retail Sale Id 1306908',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 15:05:34','',''),(2221587,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:05:34','',''),(2221626,'1','198','1016',463,'Retail Sale Id 1306925',1997.12,0.00,0.00,0.00,94.80,'2021-12-09 15:07:15','',''),(2221627,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.16,0.00,'2021-12-09 15:07:16','',''),(2221666,'1','198','1016',463,'Retail Sale Id 1306947',3002.00,0.00,0.00,0.00,142.50,'2021-12-09 15:09:05','',''),(2221667,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-09 15:09:05','',''),(2221859,'1','198','1016',463,'Retail Sale Id 1307054',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 15:19:20','',''),(2221860,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 15:19:20','',''),(2221921,'1','198','1016',463,'Retail Sale Id 1307079',4000.56,0.00,0.00,0.00,189.90,'2021-12-09 15:21:35','',''),(2221922,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-09 15:21:35','',''),(2222015,'1','198','1016',463,'Retail Sale Id 1307131',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 15:26:47','',''),(2222016,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:26:47','',''),(2222180,'1','198','1016',463,'Retail Sale Id 1307209',3501.28,0.00,0.00,0.00,166.20,'2021-12-09 15:35:04','',''),(2222181,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.54,0.00,'2021-12-09 15:35:04','',''),(2222228,'1','198','1016',463,'Retail Sale Id 1307232',1264.00,0.00,0.00,0.00,60.00,'2021-12-09 15:37:08','',''),(2222229,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:37:08','',''),(2222290,'1','198','1016',463,'Retail Sale Id 1307260',45600.00,0.00,0.00,0.00,450.00,'2021-12-09 15:39:58','',''),(2222291,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-09 15:39:58','',''),(2222314,'1','198','1016',463,'Retail Sale Id 1307275',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 15:41:11','',''),(2222315,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 15:41:11','',''),(2222421,'1','198','1016',463,'Retail Sale Id 1307325',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 15:48:07','',''),(2222422,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:48:07','',''),(2222441,'1','198','1016',463,'Retail Sale Id 1307337',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 15:49:30','',''),(2222442,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:49:30','',''),(2222501,'1','198','1016',463,'Retail Sale Id 1307369',2528.00,0.00,0.00,0.00,120.00,'2021-12-09 15:53:06','',''),(2222502,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 15:53:06','',''),(2222527,'1','198','1016',463,'Retail Sale Id 1307381',3798.32,0.00,0.00,0.00,180.30,'2021-12-09 15:54:09','',''),(2222528,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:54:09','',''),(2222557,'1','198','1016',463,'Retail Sale Id 1307394',3160.00,0.00,0.00,0.00,150.00,'2021-12-09 15:55:09','',''),(2222558,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 15:55:09','',''),(2222598,'1','198','1016',463,'Retail Sale Id 1307414',64448.00,0.00,0.00,0.00,636.00,'2021-12-09 15:57:29','',''),(2222599,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,106.00,0.00,'2021-12-09 15:57:29','',''),(2222650,'1','198','1016',463,'Retail Sale Id 1307439',24320.00,0.00,0.00,0.00,240.00,'2021-12-09 16:00:26','',''),(2222651,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 16:00:26','',''),(2222709,'1','198','1016',463,'Retail Sale Id 1307468',50160.00,0.00,0.00,0.00,495.00,'2021-12-09 16:03:35','',''),(2222710,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,82.50,0.00,'2021-12-09 16:03:35','',''),(2222779,'1','198','1016',463,'Retail Sale Id 1307494',3160.00,0.00,0.00,0.00,150.00,'2021-12-09 16:07:06','',''),(2222780,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:07:06','',''),(2222781,'1','198','1016',463,'Retail Sale Id 1307494',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 16:07:06','',''),(2222782,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:07:06','',''),(2222799,'1','198','1016',463,'Retail Sale Id 1307512',15200.00,0.00,0.00,0.00,150.00,'2021-12-09 16:08:15','',''),(2222800,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 16:08:15','',''),(2222873,'1','198','1016',463,'Retail Sale Id 1307553',3002.00,0.00,0.00,0.00,142.50,'2021-12-09 16:11:54','',''),(2222874,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-09 16:11:54','',''),(2223097,'1','198','1016',463,'Retail Sale Id 1307662',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 16:24:25','',''),(2223098,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:24:25','',''),(2223121,'1','198','1016',463,'Retail Sale Id 1307675',1902.32,0.00,0.00,0.00,90.30,'2021-12-09 16:25:56','',''),(2223122,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-09 16:25:56','',''),(2223158,'1','198','1016',463,'Retail Sale Id 1307686',7600.00,0.00,0.00,0.00,75.00,'2021-12-09 16:27:07','',''),(2223159,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:27:07','',''),(2223196,'1','198','1016',463,'Retail Sale Id 1307704',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 16:28:30','',''),(2223197,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:28:30','',''),(2223224,'1','198','1016',463,'Retail Sale Id 1307716',2502.72,0.00,0.00,0.00,118.80,'2021-12-09 16:30:37','',''),(2223225,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.96,0.00,'2021-12-09 16:30:37','',''),(2223272,'1','198','1016',463,'Retail Sale Id 1307740',1276.80,0.00,0.00,0.00,12.60,'2021-12-09 16:33:29','',''),(2223273,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.10,0.00,'2021-12-09 16:33:29','',''),(2223544,'1','198','1016',463,'Retail Sale Id 1307846',3002.00,0.00,0.00,0.00,142.50,'2021-12-09 16:46:51','',''),(2223545,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.75,0.00,'2021-12-09 16:46:51','',''),(2223687,'1','198','1016',463,'Retail Sale Id 1307914',30400.00,0.00,0.00,0.00,300.00,'2021-12-09 16:55:29','',''),(2223688,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:55:29','',''),(2223713,'1','198','1016',463,'Retail Sale Id 1307926',499.28,0.00,0.00,0.00,23.70,'2021-12-09 16:57:10','',''),(2223714,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.79,0.00,'2021-12-09 16:57:10','',''),(2223840,'1','198','1016',463,'Retail Sale Id 1307981',7900.00,0.00,0.00,0.00,375.00,'2021-12-09 17:04:24','',''),(2223841,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:04:24','',''),(2225337,'1','198','1016',463,'Retail Sale Id 1308470',7500.00,0.00,0.00,0.00,0.00,'2021-12-10 06:28:55','',''),(2225338,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:28:55','',''),(2225469,'1','198','1016',463,'Retail Sale Id 1308527',3744.00,0.00,0.00,0.00,144.00,'2021-12-10 06:38:46','',''),(2225470,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:38:46','',''),(2225471,'1','198','1016',463,'Retail Sale Id 1308527',3744.00,0.00,0.00,0.00,144.00,'2021-12-10 06:38:46','',''),(2225472,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:38:46','',''),(2225473,'1','198','1016',463,'Retail Sale Id 1308527',3744.00,0.00,0.00,0.00,144.00,'2021-12-10 06:38:46','',''),(2225474,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:38:46','',''),(2225556,'1','198','1016',463,'Retail Sale Id 1308569',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 06:46:24','',''),(2225557,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:46:24','',''),(2225782,'1','198','1016',463,'Retail Sale Id 1308685',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 07:01:48','',''),(2225783,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:01:48','',''),(2225902,'1','198','1016',463,'Retail Sale Id 1308744',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 07:09:27','',''),(2225903,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 07:09:27','',''),(2225904,'1','198','1016',463,'Retail Sale Id 1308744',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 07:09:27','',''),(2225905,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:09:27','',''),(2225956,'1','198','1016',463,'Retail Sale Id 1308778',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 07:12:28','',''),(2225957,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:12:28','',''),(2225958,'1','198','1016',463,'Retail Sale Id 1308778',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 07:12:28','',''),(2225959,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:12:28','',''),(2226006,'1','198','1016',463,'Retail Sale Id 1308803',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 07:15:44','',''),(2226007,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:15:44','',''),(2226230,'1','198','1016',463,'Retail Sale Id 1308917',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 07:27:04','',''),(2226231,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:27:04','',''),(2226340,'1','198','1016',463,'Retail Sale Id 1308964',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 07:33:06','',''),(2226341,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 07:33:06','',''),(2226379,'1','198','1016',463,'Retail Sale Id 1308981',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 07:35:08','',''),(2226380,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:35:08','',''),(2226539,'1','198','1016',463,'Retail Sale Id 1309060',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 07:44:52','',''),(2226540,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:44:52','',''),(2226923,'1','198','1016',463,'Retail Sale Id 1309212',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 08:02:54','',''),(2226924,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:02:54','',''),(2227237,'1','198','1016',463,'Retail Sale Id 1309343',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 08:17:57','',''),(2227238,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:17:57','',''),(2227491,'1','198','1016',463,'Retail Sale Id 1309452',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 08:29:11','',''),(2227492,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:29:11','',''),(2227593,'1','198','1016',463,'Retail Sale Id 1309505',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 08:34:02','',''),(2227594,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 08:34:02','',''),(2227718,'1','198','1016',463,'Retail Sale Id 1309570',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 08:41:13','',''),(2227719,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:41:13','',''),(2227754,'1','198','1016',463,'Retail Sale Id 1309587',3000.00,0.00,0.00,0.00,0.00,'2021-12-10 08:43:12','',''),(2227755,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:43:12','',''),(2228172,'1','198','1016',463,'Retail Sale Id 1309778',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 09:00:20','',''),(2228173,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:00:20','',''),(2228302,'1','198','1016',463,'Retail Sale Id 1309842',4998.24,0.00,0.00,0.00,192.24,'2021-12-10 09:06:34','',''),(2228303,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 09:06:34','',''),(2228393,'1','198','1016',463,'Retail Sale Id 1309876',60000.00,0.00,0.00,0.00,0.00,'2021-12-10 09:11:43','',''),(2228394,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 09:11:43','',''),(2228493,'1','198','1016',463,'Retail Sale Id 1309926',270000.00,0.00,0.00,0.00,0.00,'2021-12-10 09:17:28','',''),(2228494,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,450.00,0.00,'2021-12-10 09:17:28','',''),(2228507,'1','198','1016',463,'Retail Sale Id 1309933',2003.04,0.00,0.00,0.00,77.04,'2021-12-10 09:18:21','',''),(2228508,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 09:18:21','',''),(2228664,'1','198','1016',463,'Retail Sale Id 1310011',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 09:28:51','',''),(2228665,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 09:28:51','',''),(2228666,'1','198','1016',463,'Retail Sale Id 1310011',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 09:28:51','',''),(2228667,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 09:28:51','',''),(2228692,'1','198','1016',463,'Retail Sale Id 1310025',15000.00,0.00,0.00,0.00,0.00,'2021-12-10 09:30:40','',''),(2228693,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 09:30:40','',''),(2228728,'1','198','1016',463,'Retail Sale Id 1310046',1397.76,0.00,0.00,0.00,53.76,'2021-12-10 09:33:07','',''),(2228729,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-10 09:33:07','',''),(2228817,'1','198','1016',463,'Retail Sale Id 1310081',3300.96,0.00,0.00,0.00,126.96,'2021-12-10 09:37:03','',''),(2228818,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.29,0.00,'2021-12-10 09:37:03','',''),(2228869,'1','198','1016',463,'Retail Sale Id 1310109',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 09:40:50','',''),(2228870,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 09:40:50','',''),(2228871,'1','198','1016',463,'Retail Sale Id 1310109',6240.00,0.00,0.00,0.00,240.00,'2021-12-10 09:40:50','',''),(2228872,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 09:40:50','',''),(2228873,'1','198','1016',463,'Retail Sale Id 1310109',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 09:40:50','',''),(2228874,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:40:50','',''),(2228875,'1','198','1016',463,'Retail Sale Id 1310109',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 09:40:50','',''),(2228876,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:40:50','',''),(2228951,'1','198','1016',463,'Retail Sale Id 1310149',3101.28,0.00,0.00,0.00,119.28,'2021-12-10 09:44:30','',''),(2228952,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.97,0.00,'2021-12-10 09:44:30','',''),(2229033,'1','198','1016',463,'Retail Sale Id 1310195',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 09:49:26','',''),(2229034,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:49:26','',''),(2229131,'1','198','1016',463,'Retail Sale Id 1310242',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 09:54:58','',''),(2229132,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 09:54:58','',''),(2229339,'1','198','1016',463,'Retail Sale Id 1310330',96000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:07:37','',''),(2229340,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-10 10:07:37','',''),(2229403,'1','198','1016',463,'Retail Sale Id 1310367',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 10:11:18','',''),(2229404,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:11:18','',''),(2229405,'1','198','1016',463,'Retail Sale Id 1310367',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 10:11:18','',''),(2229406,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:11:18','',''),(2229473,'1','198','1016',463,'Retail Sale Id 1310393',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 10:14:13','',''),(2229474,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:14:13','',''),(2229573,'1','198','1016',463,'Retail Sale Id 1310440',3500.64,0.00,0.00,0.00,134.64,'2021-12-10 10:19:21','',''),(2229574,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-10 10:19:21','',''),(2229615,'1','198','1016',463,'Retail Sale Id 1310461',28500.00,0.00,0.00,0.00,0.00,'2021-12-10 10:21:26','',''),(2229616,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,47.50,0.00,'2021-12-10 10:21:26','',''),(2229669,'1','198','1016',463,'Retail Sale Id 1310484',3500.64,0.00,0.00,0.00,134.64,'2021-12-10 10:24:23','',''),(2229670,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-10 10:24:23','',''),(2229713,'1','198','1016',463,'Retail Sale Id 1310507',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 10:26:47','',''),(2229714,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:26:47','',''),(2229715,'1','198','1016',463,'Retail Sale Id 1310507',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 10:26:47','',''),(2229716,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 10:26:47','',''),(2229852,'1','198','1016',463,'Retail Sale Id 1310569',90000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:35:24','',''),(2229853,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 10:35:24','',''),(2229875,'1','198','1016',463,'Retail Sale Id 1310576',3500.64,0.00,0.00,0.00,134.64,'2021-12-10 10:36:47','',''),(2229876,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-10 10:36:47','',''),(2229907,'1','198','1016',463,'Retail Sale Id 1310595',12000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:38:58','',''),(2229908,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 10:38:58','',''),(2229937,'1','198','1016',463,'Retail Sale Id 1310611',60000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:41:16','',''),(2229938,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 10:41:16','',''),(2230023,'1','198','1016',463,'Retail Sale Id 1310648',4992.00,0.00,0.00,0.00,192.00,'2021-12-10 10:45:50','',''),(2230024,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 10:45:50','',''),(2230049,'1','198','1016',463,'Retail Sale Id 1310659',1872.00,0.00,0.00,0.00,72.00,'2021-12-10 10:47:36','',''),(2230050,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:47:36','',''),(2230085,'1','198','1016',463,'Retail Sale Id 1310669',12000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:48:56','',''),(2230086,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 10:48:56','',''),(2230130,'1','198','1016',463,'Retail Sale Id 1310690',90000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:50:43','',''),(2230131,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 10:50:43','',''),(2230174,'1','198','1016',463,'Retail Sale Id 1310709',60000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:53:01','',''),(2230175,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 10:53:01','',''),(2230236,'1','198','1016',463,'Retail Sale Id 1310736',120000.00,0.00,0.00,0.00,0.00,'2021-12-10 10:56:55','',''),(2230237,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 10:56:55','',''),(2230514,'1','198','1016',463,'Retail Sale Id 1310856',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 11:12:39','',''),(2230515,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:12:39','',''),(2230532,'1','198','1016',463,'Retail Sale Id 1310866',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 11:14:13','',''),(2230533,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 11:14:13','',''),(2230560,'1','198','1016',463,'Retail Sale Id 1310883',119600.00,0.00,0.00,0.00,-400.00,'2021-12-10 11:15:55','',''),(2230561,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 11:15:55','',''),(2230572,'1','198','1016',463,'Retail Sale Id 1310892',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 11:17:04','',''),(2230573,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:17:04','',''),(2230609,'1','198','1016',463,'Retail Sale Id 1310908',450000.00,0.00,0.00,0.00,0.00,'2021-12-10 11:18:36','',''),(2230610,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-10 11:18:36','',''),(2230813,'1','198','1016',463,'Retail Sale Id 1310975',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 11:31:56','',''),(2230814,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:31:56','',''),(2230905,'1','198','1016',463,'Retail Sale Id 1311038',30000.00,0.00,0.00,0.00,0.00,'2021-12-10 11:37:18','',''),(2230906,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 11:37:18','',''),(2231021,'1','198','1016',463,'Retail Sale Id 1311098',29900.00,0.00,0.00,0.00,-100.00,'2021-12-10 11:47:11','',''),(2231022,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 11:47:11','',''),(2231049,'1','198','1016',463,'Retail Sale Id 1311114',3500.64,0.00,0.00,0.00,134.64,'2021-12-10 11:48:49','',''),(2231050,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-10 11:48:49','',''),(2231477,'1','198','1016',463,'Retail Sale Id 1311328',1560.00,0.00,0.00,0.00,60.00,'2021-12-10 12:21:20','',''),(2231478,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-10 12:21:20','',''),(2231726,'1','198','1016',463,'Retail Sale Id 1311471',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 12:45:22','',''),(2231727,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:45:22','',''),(2231761,'1','198','1016',463,'Retail Sale Id 1311483',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 12:47:33','',''),(2231762,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:47:33','',''),(2231922,'1','198','1016',463,'Retail Sale Id 1311564',3700.32,0.00,0.00,0.00,142.32,'2021-12-10 12:58:00','',''),(2231923,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.93,0.00,'2021-12-10 12:58:00','',''),(2231972,'1','198','1016',463,'Retail Sale Id 1311587',3600.00,0.00,0.00,0.00,0.00,'2021-12-10 13:01:25','',''),(2231973,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:01:25','',''),(2232044,'1','198','1016',463,'Retail Sale Id 1311628',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 13:07:01','',''),(2232045,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:07:01','',''),(2232270,'1','198','1016',463,'Retail Sale Id 1311718',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 13:19:08','',''),(2232271,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:19:08','',''),(2232312,'1','198','1016',463,'Retail Sale Id 1311733',1896.96,0.00,0.00,0.00,72.96,'2021-12-10 13:21:26','',''),(2232313,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-10 13:21:26','',''),(2232331,'1','198','1016',463,'Retail Sale Id 1311743',2003.04,0.00,0.00,0.00,77.04,'2021-12-10 13:22:36','',''),(2232332,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 13:22:36','',''),(2232424,'1','198','1016',463,'Retail Sale Id 1311799',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 13:30:05','',''),(2232425,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:30:05','',''),(2232457,'1','198','1016',463,'Retail Sale Id 1311816',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 13:32:08','',''),(2232458,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:32:08','',''),(2232523,'1','198','1016',463,'Retail Sale Id 1311850',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 13:35:26','',''),(2232524,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 13:35:26','',''),(2232607,'1','198','1016',463,'Retail Sale Id 1311883',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 13:39:05','',''),(2232608,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:39:05','',''),(2232713,'1','198','1016',463,'Retail Sale Id 1311927',7500.00,0.00,0.00,0.00,0.00,'2021-12-10 13:44:01','',''),(2232714,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:44:01','',''),(2232823,'1','198','1016',463,'Retail Sale Id 1311967',2502.24,0.00,0.00,0.00,96.24,'2021-12-10 13:48:22','',''),(2232824,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-10 13:48:22','',''),(2232959,'1','198','1016',463,'Retail Sale Id 1312033',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 13:56:00','',''),(2232960,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:56:00','',''),(2233211,'1','198','1016',463,'Retail Sale Id 1312125',60000.00,0.00,0.00,0.00,0.00,'2021-12-10 14:05:53','',''),(2233212,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 14:05:53','',''),(2233255,'1','198','1016',463,'Retail Sale Id 1312142',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 14:08:17','',''),(2233256,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 14:08:17','',''),(2233303,'1','198','1016',463,'Retail Sale Id 1312168',3001.44,0.00,0.00,0.00,115.44,'2021-12-10 14:12:32','',''),(2233304,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 14:12:32','',''),(2233321,'1','198','1016',463,'Retail Sale Id 1312180',998.40,0.00,0.00,0.00,38.40,'2021-12-10 14:13:33','',''),(2233322,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 14:13:33','',''),(2233781,'1','198','1016',463,'Retail Sale Id 1312380',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 14:33:36','',''),(2233782,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 14:33:36','',''),(2234119,'1','198','1016',463,'Retail Sale Id 1312518',20904.00,0.00,0.00,0.00,804.00,'2021-12-10 14:46:54','',''),(2234120,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,33.50,0.00,'2021-12-10 14:46:54','',''),(2234189,'1','198','1016',463,'Retail Sale Id 1312556',3600.00,0.00,0.00,0.00,0.00,'2021-12-10 14:49:35','',''),(2234190,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:49:35','',''),(2234246,'1','198','1016',463,'Retail Sale Id 1312580',1248.00,0.00,0.00,0.00,48.00,'2021-12-10 14:52:14','',''),(2234247,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 14:52:14','',''),(2234388,'1','198','1016',463,'Retail Sale Id 1312651',2003.04,0.00,0.00,0.00,77.04,'2021-12-10 15:00:23','',''),(2234389,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 15:00:23','',''),(2234420,'1','198','1016',463,'Retail Sale Id 1312668',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 15:02:46','',''),(2234421,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:02:46','',''),(2234448,'1','198','1016',463,'Retail Sale Id 1312682',624.00,0.00,0.00,0.00,24.00,'2021-12-10 15:04:13','',''),(2234449,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 15:04:13','',''),(2234476,'1','198','1016',463,'Retail Sale Id 1312698',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 15:05:58','',''),(2234477,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:05:58','',''),(2234512,'1','198','1016',463,'Retail Sale Id 1312710',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 15:07:14','',''),(2234513,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:07:14','',''),(2234552,'1','198','1016',463,'Retail Sale Id 1312732',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 15:09:29','',''),(2234553,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:09:29','',''),(2234641,'1','198','1016',463,'Retail Sale Id 1312768',7800.00,0.00,0.00,0.00,300.00,'2021-12-10 15:13:06','',''),(2234642,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:13:06','',''),(2234701,'1','198','1016',463,'Retail Sale Id 1312801',12000.00,0.00,0.00,0.00,0.00,'2021-12-10 15:15:26','',''),(2234702,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 15:15:26','',''),(2234775,'1','198','1016',463,'Retail Sale Id 1312841',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 15:18:45','',''),(2234776,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:18:45','',''),(2234946,'1','198','1016',463,'Retail Sale Id 1312936',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 15:25:11','',''),(2234947,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 15:25:11','',''),(2235419,'1','198','1016',463,'Retail Sale Id 1313145',698.88,0.00,0.00,0.00,26.88,'2021-12-10 15:43:43','',''),(2235420,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.12,0.00,'2021-12-10 15:43:43','',''),(2235515,'1','198','1016',463,'Retail Sale Id 1313205',1878.24,0.00,0.00,0.00,72.24,'2021-12-10 15:48:25','',''),(2235516,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-10 15:48:25','',''),(2235776,'1','198','1016',463,'Retail Sale Id 1313343',45000.00,0.00,0.00,0.00,0.00,'2021-12-10 16:00:26','',''),(2235777,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-10 16:00:26','',''),(2235796,'1','198','1016',463,'Retail Sale Id 1313354',998.40,0.00,0.00,0.00,38.40,'2021-12-10 16:01:44','',''),(2235797,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 16:01:44','',''),(2235904,'1','198','1016',463,'Retail Sale Id 1313401',59800.00,0.00,0.00,0.00,-200.00,'2021-12-10 16:06:49','',''),(2235905,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 16:06:49','',''),(2235932,'1','198','1016',463,'Retail Sale Id 1313408',3750.24,0.00,0.00,0.00,144.24,'2021-12-10 16:07:48','',''),(2235933,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:07:48','',''),(2236021,'1','198','1016',463,'Retail Sale Id 1313449',90000.00,0.00,0.00,0.00,0.00,'2021-12-10 16:11:39','',''),(2236022,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 16:11:39','',''),(2236095,'1','198','1016',463,'Retail Sale Id 1313495',3120.00,0.00,0.00,0.00,120.00,'2021-12-10 16:15:23','',''),(2236096,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:15:23','',''),(2239368,'1','198','1016',463,'Retail Sale Id 1314868',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 07:09:07','',''),(2239369,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:09:07','',''),(2239521,'1','198','1016',463,'Retail Sale Id 1314950',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 07:18:50','',''),(2239522,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 07:18:50','',''),(2239943,'1','198','1016',463,'Retail Sale Id 1315185',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 07:41:19','',''),(2239944,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:41:19','',''),(2240003,'1','198','1016',463,'Retail Sale Id 1315216',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 07:44:28','',''),(2240004,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 07:44:28','',''),(2240078,'1','198','1016',463,'Retail Sale Id 1315263',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 07:47:40','',''),(2240079,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 07:47:40','',''),(2240244,'1','198','1016',463,'Retail Sale Id 1315325',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 07:53:58','',''),(2240245,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 07:53:58','',''),(2240429,'1','198','1016',463,'Retail Sale Id 1315415',1753.44,0.00,0.00,0.00,67.44,'2021-12-11 08:02:23','',''),(2240430,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-11 08:02:23','',''),(2240580,'1','198','1016',463,'Retail Sale Id 1315460',36600.00,0.00,0.00,0.00,0.00,'2021-12-11 08:08:09','',''),(2240581,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,61.00,0.00,'2021-12-11 08:08:09','',''),(2240644,'1','198','1016',463,'Retail Sale Id 1315481',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 08:10:39','',''),(2240645,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:10:39','',''),(2240666,'1','198','1016',463,'Retail Sale Id 1315492',30000.00,0.00,0.00,0.00,0.00,'2021-12-11 08:11:48','',''),(2240667,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 08:11:48','',''),(2240691,'1','198','1016',463,'Retail Sale Id 1315505',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 08:12:54','',''),(2240692,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 08:12:54','',''),(2240880,'1','198','1016',463,'Retail Sale Id 1315610',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 08:21:52','',''),(2240881,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 08:21:52','',''),(2241003,'1','198','1016',463,'Retail Sale Id 1315678',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 08:29:18','',''),(2241004,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 08:29:18','',''),(2241098,'1','198','1016',463,'Retail Sale Id 1315717',78000.00,0.00,0.00,0.00,0.00,'2021-12-11 08:33:15','',''),(2241099,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-11 08:33:15','',''),(2241247,'1','198','1016',463,'Retail Sale Id 1315786',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 08:40:53','',''),(2241248,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 08:40:53','',''),(2241305,'1','198','1016',463,'Retail Sale Id 1315806',3001.44,0.00,0.00,0.00,115.44,'2021-12-11 08:43:12','',''),(2241306,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 08:43:12','',''),(2241427,'1','198','1016',463,'Retail Sale Id 1315838',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 08:48:41','',''),(2241428,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 08:48:41','',''),(2241507,'1','198','1016',463,'Retail Sale Id 1315900',3744.00,0.00,0.00,0.00,144.00,'2021-12-11 08:53:33','',''),(2241508,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:53:33','',''),(2241612,'1','198','1016',463,'Retail Sale Id 1315937',75000.00,0.00,0.00,0.00,0.00,'2021-12-11 08:57:09','',''),(2241613,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,125.00,0.00,'2021-12-11 08:57:09','',''),(2241642,'1','198','1016',463,'Retail Sale Id 1315953',1872.00,0.00,0.00,0.00,72.00,'2021-12-11 08:58:20','',''),(2241643,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 08:58:20','',''),(2241728,'1','198','1016',463,'Retail Sale Id 1315989',600.00,0.00,0.00,0.00,0.00,'2021-12-11 09:01:15','',''),(2241729,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 09:01:15','',''),(2241908,'1','198','1016',463,'Retail Sale Id 1316085',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 09:09:35','',''),(2241909,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 09:09:35','',''),(2241982,'1','198','1016',463,'Retail Sale Id 1316117',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 09:12:39','',''),(2241983,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 09:12:39','',''),(2241984,'1','198','1016',463,'Retail Sale Id 1316117',15600.00,0.00,0.00,0.00,600.00,'2021-12-11 09:12:39','',''),(2241985,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 09:12:39','',''),(2243231,'1','198','1016',463,'Retail Sale Id 1316714',28405.00,0.00,0.00,0.00,-95.00,'2021-12-11 10:13:13','',''),(2243232,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,47.50,0.00,'2021-12-11 10:13:13','',''),(2243299,'1','198','1016',463,'Retail Sale Id 1316738',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 10:15:40','',''),(2243300,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 10:15:40','',''),(2243389,'1','198','1016',463,'Retail Sale Id 1316774',15000.00,0.00,0.00,0.00,0.00,'2021-12-11 10:19:06','',''),(2243390,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 10:19:06','',''),(2243419,'1','198','1016',463,'Retail Sale Id 1316792',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 10:20:48','',''),(2243420,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:20:48','',''),(2243473,'1','198','1016',463,'Retail Sale Id 1316819',58604.00,0.00,0.00,0.00,-196.00,'2021-12-11 10:24:10','',''),(2243474,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-11 10:24:10','',''),(2243517,'1','198','1016',463,'Retail Sale Id 1316840',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 10:26:36','',''),(2243518,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 10:26:36','',''),(2243519,'1','198','1016',463,'Retail Sale Id 1316840',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 10:26:36','',''),(2243520,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 10:26:36','',''),(2243551,'1','198','1016',463,'Retail Sale Id 1316858',998.40,0.00,0.00,0.00,38.40,'2021-12-11 10:27:49','',''),(2243552,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 10:27:49','',''),(2243553,'1','198','1016',463,'Retail Sale Id 1316858',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 10:27:49','',''),(2243554,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 10:27:49','',''),(2243577,'1','198','1016',463,'Retail Sale Id 1316869',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 10:29:16','',''),(2243578,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:29:16','',''),(2243579,'1','198','1016',463,'Retail Sale Id 1316869',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 10:29:16','',''),(2243580,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 10:29:16','',''),(2243649,'1','198','1016',463,'Retail Sale Id 1316904',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 10:33:24','',''),(2243650,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 10:33:24','',''),(2243688,'1','198','1016',463,'Retail Sale Id 1316924',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 10:35:51','',''),(2243689,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:35:51','',''),(2243752,'1','198','1016',463,'Retail Sale Id 1316952',2502.24,0.00,0.00,0.00,96.24,'2021-12-11 10:39:14','',''),(2243753,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 10:39:14','',''),(2243802,'1','198','1016',463,'Retail Sale Id 1316979',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 10:41:51','',''),(2243803,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:41:51','',''),(2243842,'1','198','1016',463,'Retail Sale Id 1316999',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 10:43:41','',''),(2243843,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 10:43:41','',''),(2243912,'1','198','1016',463,'Retail Sale Id 1317034',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 10:47:31','',''),(2243913,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:47:31','',''),(2244082,'1','198','1016',463,'Retail Sale Id 1317123',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 10:57:56','',''),(2244083,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:57:56','',''),(2244134,'1','198','1016',463,'Retail Sale Id 1317139',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 10:59:40','',''),(2244135,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 10:59:40','',''),(2244170,'1','198','1016',463,'Retail Sale Id 1317154',630.24,0.00,0.00,0.00,24.24,'2021-12-11 11:01:11','',''),(2244171,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-11 11:01:11','',''),(2244323,'1','198','1016',463,'Retail Sale Id 1317226',998.40,0.00,0.00,0.00,38.40,'2021-12-11 11:08:17','',''),(2244324,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 11:08:17','',''),(2244458,'1','198','1016',463,'Retail Sale Id 1317288',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 11:15:29','',''),(2244459,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:15:29','',''),(2244591,'1','198','1016',463,'Retail Sale Id 1317357',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 11:22:02','',''),(2244592,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 11:22:02','',''),(2244640,'1','198','1016',463,'Retail Sale Id 1317384',31800.00,0.00,0.00,0.00,0.00,'2021-12-11 11:24:33','',''),(2244641,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-11 11:24:33','',''),(2244685,'1','198','1016',463,'Retail Sale Id 1317398',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 11:25:52','',''),(2244686,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:25:52','',''),(2244796,'1','198','1016',463,'Retail Sale Id 1317457',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 11:32:47','',''),(2244797,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:32:47','',''),(2244852,'1','198','1016',463,'Retail Sale Id 1317488',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 11:35:45','',''),(2244853,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:35:46','',''),(2244870,'1','198','1016',463,'Retail Sale Id 1317499',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 11:37:10','',''),(2244871,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:37:10','',''),(2244896,'1','198','1016',463,'Retail Sale Id 1317512',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 11:39:00','',''),(2244897,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 11:39:00','',''),(2244937,'1','198','1016',463,'Retail Sale Id 1317539',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 11:41:26','',''),(2244938,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 11:41:26','',''),(2244959,'1','198','1016',463,'Retail Sale Id 1317551',2003.04,0.00,0.00,0.00,77.04,'2021-12-11 11:42:27','',''),(2244960,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 11:42:27','',''),(2244979,'1','198','1016',463,'Retail Sale Id 1317560',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 11:43:27','',''),(2244980,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:43:27','',''),(2245001,'1','198','1016',463,'Retail Sale Id 1317574',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 11:45:46','',''),(2245002,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:45:46','',''),(2245043,'1','198','1016',463,'Retail Sale Id 1317588',15000.00,0.00,0.00,0.00,0.00,'2021-12-11 11:48:53','',''),(2245044,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 11:48:53','',''),(2245196,'1','198','1016',463,'Retail Sale Id 1317669',59800.00,0.00,0.00,0.00,-200.00,'2021-12-11 11:56:34','',''),(2245197,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 11:56:34','',''),(2245211,'1','198','1016',463,'Retail Sale Id 1317676',60000.00,0.00,0.00,0.00,0.00,'2021-12-11 11:57:26','',''),(2245212,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 11:57:26','',''),(2245238,'1','198','1016',463,'Retail Sale Id 1317690',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 11:58:58','',''),(2245239,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:58:58','',''),(2245255,'1','198','1016',463,'Retail Sale Id 1317698',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 12:00:01','',''),(2245256,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:00:01','',''),(2245270,'1','198','1016',463,'Retail Sale Id 1317708',3700.32,0.00,0.00,0.00,142.32,'2021-12-11 12:01:18','',''),(2245271,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.93,0.00,'2021-12-11 12:01:18','',''),(2245290,'1','198','1016',463,'Retail Sale Id 1317717',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 12:02:47','',''),(2245291,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:02:47','',''),(2245311,'1','198','1016',463,'Retail Sale Id 1317725',179400.00,0.00,0.00,0.00,-600.00,'2021-12-11 12:04:46','',''),(2245312,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-11 12:04:46','',''),(2245375,'1','198','1016',463,'Retail Sale Id 1317805',29900.00,0.00,0.00,0.00,-100.00,'2021-12-11 12:09:42','',''),(2245376,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 12:09:42','',''),(2245547,'1','198','1016',463,'Retail Sale Id 1317902',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 12:19:23','',''),(2245548,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:19:23','',''),(2245616,'1','198','1016',463,'Retail Sale Id 1317931',2502.24,0.00,0.00,0.00,96.24,'2021-12-11 12:23:34','',''),(2245617,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 12:23:34','',''),(2245618,'1','198','1016',463,'Retail Sale Id 1317931',2502.24,0.00,0.00,0.00,96.24,'2021-12-11 12:23:34','',''),(2245619,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 12:23:34','',''),(2245646,'1','198','1016',463,'Retail Sale Id 1317943',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 12:24:50','',''),(2245647,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:24:50','',''),(2245684,'1','198','1016',463,'Retail Sale Id 1317958',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 12:27:02','',''),(2245685,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 12:27:02','',''),(2245722,'1','198','1016',463,'Retail Sale Id 1317973',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 12:28:59','',''),(2245723,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 12:28:59','',''),(2245748,'1','198','1016',463,'Retail Sale Id 1317987',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 12:30:37','',''),(2245749,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 12:30:37','',''),(2245750,'1','198','1016',463,'Retail Sale Id 1317987',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 12:30:37','',''),(2245751,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:30:37','',''),(2245784,'1','198','1016',463,'Retail Sale Id 1318005',29900.00,0.00,0.00,0.00,-100.00,'2021-12-11 12:32:59','',''),(2245785,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 12:32:59','',''),(2245812,'1','198','1016',463,'Retail Sale Id 1318017',13002.00,0.00,0.00,0.00,0.00,'2021-12-11 12:34:47','',''),(2245813,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,21.67,0.00,'2021-12-11 12:34:47','',''),(2245834,'1','198','1016',463,'Retail Sale Id 1318040',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 12:36:19','',''),(2245835,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:36:19','',''),(2245896,'1','198','1016',463,'Retail Sale Id 1318069',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 12:40:24','',''),(2245897,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 12:40:24','',''),(2245991,'1','198','1016',463,'Retail Sale Id 1318113',12000.00,0.00,0.00,0.00,0.00,'2021-12-11 12:45:58','',''),(2245992,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-11 12:45:58','',''),(2246019,'1','198','1016',463,'Retail Sale Id 1318125',6240.00,0.00,0.00,0.00,240.00,'2021-12-11 12:48:58','',''),(2246020,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 12:48:58','',''),(2246106,'1','198','1016',463,'Retail Sale Id 1318172',1878.24,0.00,0.00,0.00,72.24,'2021-12-11 12:55:06','',''),(2246107,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-11 12:55:06','',''),(2246182,'1','198','1016',463,'Retail Sale Id 1318214',15600.00,0.00,0.00,0.00,600.00,'2021-12-11 13:00:45','',''),(2246183,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 13:00:45','',''),(2246336,'1','198','1016',463,'Retail Sale Id 1318298',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 13:13:19','',''),(2246337,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 13:13:19','',''),(2246369,'1','198','1016',463,'Retail Sale Id 1318313',15600.00,0.00,0.00,0.00,600.00,'2021-12-11 13:15:22','',''),(2246370,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-11 13:15:22','',''),(2246765,'1','198','1016',463,'Retail Sale Id 1318475',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 13:39:12','',''),(2246766,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 13:39:12','',''),(2246802,'1','198','1016',463,'Retail Sale Id 1318489',6240.00,0.00,0.00,0.00,240.00,'2021-12-11 13:42:16','',''),(2246803,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 13:42:16','',''),(2246846,'1','198','1016',463,'Retail Sale Id 1318515',8100.00,0.00,0.00,0.00,0.00,'2021-12-11 13:46:38','',''),(2246847,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,13.50,0.00,'2021-12-11 13:46:38','',''),(2247115,'1','198','1016',463,'Retail Sale Id 1318636',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 14:03:30','',''),(2247116,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:03:30','',''),(2247152,'1','198','1016',463,'Retail Sale Id 1318668',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 14:06:03','',''),(2247153,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:06:03','',''),(2247172,'1','198','1016',463,'Retail Sale Id 1318679',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 14:07:34','',''),(2247173,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 14:07:34','',''),(2247408,'1','198','1016',463,'Retail Sale Id 1318798',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 14:21:42','',''),(2247409,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:21:42','',''),(2247618,'1','198','1016',463,'Retail Sale Id 1318908',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 14:36:10','',''),(2247619,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 14:36:10','',''),(2247646,'1','198','1016',463,'Retail Sale Id 1318920',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 14:37:36','',''),(2247647,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 14:37:36','',''),(2247750,'1','198','1016',463,'Retail Sale Id 1318978',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 14:43:45','',''),(2247751,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:43:45','',''),(2247788,'1','198','1016',463,'Retail Sale Id 1318996',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 14:45:48','',''),(2247789,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:45:48','',''),(2247886,'1','198','1016',463,'Retail Sale Id 1319044',1800.00,0.00,0.00,0.00,0.00,'2021-12-11 14:51:51','',''),(2247887,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:51:51','',''),(2247930,'1','198','1016',463,'Retail Sale Id 1319070',7500.48,0.00,0.00,0.00,288.48,'2021-12-11 14:54:23','',''),(2247931,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-11 14:54:23','',''),(2247996,'1','198','1016',463,'Retail Sale Id 1319103',2003.04,0.00,0.00,0.00,77.04,'2021-12-11 14:57:14','',''),(2247997,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 14:57:14','',''),(2248021,'1','198','1016',463,'Retail Sale Id 1319117',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 14:59:00','',''),(2248022,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 14:59:00','',''),(2248055,'1','198','1016',463,'Retail Sale Id 1319134',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 15:00:56','',''),(2248056,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:00:56','',''),(2248105,'1','198','1016',463,'Retail Sale Id 1319159',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 15:04:56','',''),(2248106,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:04:56','',''),(2248280,'1','198','1016',463,'Retail Sale Id 1319212',998.40,0.00,0.00,0.00,38.40,'2021-12-11 15:11:08','',''),(2248281,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 15:11:08','',''),(2248282,'1','198','1016',463,'Retail Sale Id 1319212',2502.24,0.00,0.00,0.00,96.24,'2021-12-11 15:11:08','',''),(2248283,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 15:11:08','',''),(2248284,'1','198','1016',463,'Retail Sale Id 1319212',2502.24,0.00,0.00,0.00,96.24,'2021-12-11 15:11:08','',''),(2248285,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 15:11:08','',''),(2248286,'1','198','1016',463,'Retail Sale Id 1319212',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 15:11:08','',''),(2248287,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:11:08','',''),(2248328,'1','198','1016',463,'Retail Sale Id 1319234',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 15:13:18','',''),(2248329,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:13:18','',''),(2248360,'1','198','1016',463,'Retail Sale Id 1319248',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 15:15:01','',''),(2248361,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 15:15:01','',''),(2248564,'1','198','1016',463,'Retail Sale Id 1319359',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 15:25:53','',''),(2248565,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:25:53','',''),(2248634,'1','198','1016',463,'Retail Sale Id 1319401',45000.00,0.00,0.00,0.00,0.00,'2021-12-11 15:30:06','',''),(2248635,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-11 15:30:06','',''),(2248666,'1','198','1016',463,'Retail Sale Id 1319420',12600.00,0.00,0.00,0.00,0.00,'2021-12-11 15:32:04','',''),(2248667,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-11 15:32:04','',''),(2248716,'1','198','1016',463,'Retail Sale Id 1319446',29900.00,0.00,0.00,0.00,-100.00,'2021-12-11 15:34:29','',''),(2248717,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 15:34:29','',''),(2248818,'1','198','1016',463,'Retail Sale Id 1319501',1872.00,0.00,0.00,0.00,72.00,'2021-12-11 15:39:38','',''),(2248819,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:39:38','',''),(2249137,'1','198','1016',463,'Retail Sale Id 1319652',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 15:54:08','',''),(2249138,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:54:08','',''),(2249389,'1','198','1016',463,'Retail Sale Id 1319752',7800.00,0.00,0.00,0.00,300.00,'2021-12-11 16:03:16','',''),(2249390,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:03:16','',''),(2249423,'1','198','1016',463,'Retail Sale Id 1319770',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 16:04:51','',''),(2249424,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:04:51','',''),(2249445,'1','198','1016',463,'Retail Sale Id 1319781',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 16:05:55','',''),(2249446,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:05:55','',''),(2249654,'1','198','1016',463,'Retail Sale Id 1319932',37375.00,0.00,0.00,0.00,-125.00,'2021-12-11 16:16:45','',''),(2249655,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-11 16:16:45','',''),(2249713,'1','198','1016',463,'Retail Sale Id 1319962',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 16:20:34','',''),(2249714,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:20:34','',''),(2249798,'1','198','1016',463,'Retail Sale Id 1320006',24000.00,0.00,0.00,0.00,0.00,'2021-12-11 16:25:41','',''),(2249799,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-11 16:25:41','',''),(2250089,'1','198','1016',463,'Retail Sale Id 1320113',3120.00,0.00,0.00,0.00,120.00,'2021-12-11 16:39:04','',''),(2250090,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:39:04','',''),(2250121,'1','198','1016',463,'Retail Sale Id 1320129',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 16:41:16','',''),(2250122,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:41:16','',''),(2250208,'1','198','1016',463,'Retail Sale Id 1320166',7500.00,0.00,0.00,0.00,0.00,'2021-12-11 16:46:47','',''),(2250209,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:46:47','',''),(2250224,'1','198','1016',463,'Retail Sale Id 1320177',3001.44,0.00,0.00,0.00,115.44,'2021-12-11 16:47:50','',''),(2250225,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-11 16:47:50','',''),(2250235,'1','198','1016',463,'Retail Sale Id 1320182',998.40,0.00,0.00,0.00,38.40,'2021-12-11 16:48:48','',''),(2250236,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 16:48:48','',''),(2250422,'1','198','1016',463,'Retail Sale Id 1320256',3750.24,0.00,0.00,0.00,144.24,'2021-12-11 16:58:38','',''),(2250423,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 16:58:38','',''),(2252522,'1','198','1016',463,'Retail Sale Id 1321017',1878.24,0.00,0.00,0.00,72.24,'2021-12-12 06:47:12','',''),(2252523,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 06:47:12','',''),(2253040,'1','198','1016',463,'Retail Sale Id 1321259',12000.00,0.00,0.00,0.00,0.00,'2021-12-12 07:24:14','',''),(2253041,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-12 07:24:14','',''),(2253375,'1','198','1016',463,'Retail Sale Id 1321431',2003.04,0.00,0.00,0.00,77.04,'2021-12-12 07:45:53','',''),(2253376,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-12 07:45:53','',''),(2253519,'1','198','1016',463,'Retail Sale Id 1321529',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 07:55:39','',''),(2253520,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 07:55:39','',''),(2253521,'1','198','1016',463,'Retail Sale Id 1321529',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 07:55:39','',''),(2253522,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:55:39','',''),(2253555,'1','198','1016',463,'Retail Sale Id 1321540',33000.00,0.00,0.00,0.00,0.00,'2021-12-12 07:57:11','',''),(2253556,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-12 07:57:11','',''),(2253725,'1','198','1016',463,'Retail Sale Id 1321618',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 08:07:38','',''),(2253726,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:07:39','',''),(2253809,'1','198','1016',463,'Retail Sale Id 1321672',3120.00,0.00,0.00,0.00,120.00,'2021-12-12 08:13:36','',''),(2253810,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 08:13:36','',''),(2253811,'1','198','1016',463,'Retail Sale Id 1321672',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 08:13:36','',''),(2253812,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:13:36','',''),(2254146,'1','198','1016',463,'Retail Sale Id 1321844',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 08:37:15','',''),(2254147,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:37:15','',''),(2254261,'1','198','1016',463,'Retail Sale Id 1321892',3500.64,0.00,0.00,0.00,134.64,'2021-12-12 08:42:43','',''),(2254262,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-12 08:42:43','',''),(2254552,'1','198','1016',463,'Retail Sale Id 1322031',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 08:59:31','',''),(2254553,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:59:31','',''),(2254598,'1','198','1016',463,'Retail Sale Id 1322044',60000.00,0.00,0.00,0.00,0.00,'2021-12-12 09:02:04','',''),(2254599,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 09:02:04','',''),(2254626,'1','198','1016',463,'Retail Sale Id 1322069',1896.96,0.00,0.00,0.00,72.96,'2021-12-12 09:03:40','',''),(2254627,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-12 09:03:40','',''),(2254975,'1','198','1016',463,'Retail Sale Id 1322246',7500.00,0.00,0.00,0.00,0.00,'2021-12-12 09:22:10','',''),(2254976,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:22:10','',''),(2255114,'1','198','1016',463,'Retail Sale Id 1322314',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 09:30:56','',''),(2255115,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:30:56','',''),(2255146,'1','198','1016',463,'Retail Sale Id 1322325',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 09:32:37','',''),(2255147,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:32:37','',''),(2255229,'1','198','1016',463,'Retail Sale Id 1322359',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 09:37:08','',''),(2255230,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:37:08','',''),(2255231,'1','198','1016',463,'Retail Sale Id 1322359',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 09:37:08','',''),(2255232,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:37:08','',''),(2255327,'1','198','1016',463,'Retail Sale Id 1322421',9000.00,0.00,0.00,0.00,0.00,'2021-12-12 09:44:57','',''),(2255328,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 09:44:57','',''),(2255355,'1','198','1016',463,'Retail Sale Id 1322435',1248.00,0.00,0.00,0.00,48.00,'2021-12-12 09:46:17','',''),(2255356,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 09:46:17','',''),(2255473,'1','198','1016',463,'Retail Sale Id 1322484',998.40,0.00,0.00,0.00,38.40,'2021-12-12 09:52:02','',''),(2255474,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 09:52:02','',''),(2255512,'1','198','1016',463,'Retail Sale Id 1322501',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 09:53:34','',''),(2255513,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:53:34','',''),(2255551,'1','198','1016',463,'Retail Sale Id 1322517',3001.44,0.00,0.00,0.00,115.44,'2021-12-12 09:55:20','',''),(2255552,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-12 09:55:20','',''),(2255775,'1','198','1016',463,'Retail Sale Id 1322615',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 10:04:51','',''),(2255776,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:04:51','',''),(2255982,'1','198','1016',463,'Retail Sale Id 1322724',3120.00,0.00,0.00,0.00,120.00,'2021-12-12 10:14:50','',''),(2255983,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 10:14:50','',''),(2256205,'1','198','1016',463,'Retail Sale Id 1322850',1878.24,0.00,0.00,0.00,72.24,'2021-12-12 10:27:57','',''),(2256206,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:27:57','',''),(2256325,'1','198','1016',463,'Retail Sale Id 1322915',6240.00,0.00,0.00,0.00,240.00,'2021-12-12 10:34:27','',''),(2256326,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 10:34:27','',''),(2256351,'1','198','1016',463,'Retail Sale Id 1322929',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 10:35:38','',''),(2256352,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:35:38','',''),(2256371,'1','198','1016',463,'Retail Sale Id 1322942',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 10:36:48','',''),(2256372,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:36:48','',''),(2256393,'1','198','1016',463,'Retail Sale Id 1322951',7500.48,0.00,0.00,0.00,288.48,'2021-12-12 10:37:48','',''),(2256394,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-12 10:37:48','',''),(2256413,'1','198','1016',463,'Retail Sale Id 1322961',942.24,0.00,0.00,0.00,36.24,'2021-12-12 10:38:38','',''),(2256414,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.51,0.00,'2021-12-12 10:38:38','',''),(2256453,'1','198','1016',463,'Retail Sale Id 1322985',10800.00,0.00,0.00,0.00,0.00,'2021-12-12 10:40:57','',''),(2256454,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-12 10:40:57','',''),(2256483,'1','198','1016',463,'Retail Sale Id 1322999',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 10:41:58','',''),(2256484,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:41:58','',''),(2256606,'1','198','1016',463,'Retail Sale Id 1323051',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 10:47:37','',''),(2256607,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:47:37','',''),(2256705,'1','198','1016',463,'Retail Sale Id 1323111',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 10:52:23','',''),(2256706,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:52:23','',''),(2256806,'1','198','1016',463,'Retail Sale Id 1323155',1878.24,0.00,0.00,0.00,72.24,'2021-12-12 10:56:55','',''),(2256807,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 10:56:55','',''),(2256843,'1','198','1016',463,'Retail Sale Id 1323173',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 10:58:10','',''),(2256844,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:58:10','',''),(2256875,'1','198','1016',463,'Retail Sale Id 1323193',817.44,0.00,0.00,0.00,31.44,'2021-12-12 10:59:47','',''),(2256876,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.31,0.00,'2021-12-12 10:59:47','',''),(2257014,'1','198','1016',463,'Retail Sale Id 1323257',7681.44,0.00,0.00,0.00,295.44,'2021-12-12 11:04:57','',''),(2257015,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.31,0.00,'2021-12-12 11:04:57','',''),(2257184,'1','198','1016',463,'Retail Sale Id 1323344',6240.00,0.00,0.00,0.00,240.00,'2021-12-12 11:11:58','',''),(2257185,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 11:11:58','',''),(2257325,'1','198','1016',463,'Retail Sale Id 1323407',2502.24,0.00,0.00,0.00,96.24,'2021-12-12 11:17:01','',''),(2257326,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-12 11:17:01','',''),(2257590,'1','198','1016',463,'Retail Sale Id 1323562',3120.00,0.00,0.00,0.00,120.00,'2021-12-12 11:29:34','',''),(2257591,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 11:29:34','',''),(2257721,'1','198','1016',463,'Retail Sale Id 1323623',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 11:36:04','',''),(2257722,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:36:04','',''),(2257856,'1','198','1016',463,'Retail Sale Id 1323688',388700.00,0.00,0.00,0.00,-1300.00,'2021-12-12 11:42:05','',''),(2257857,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,650.00,0.00,'2021-12-12 11:42:05','',''),(2258010,'1','198','1016',463,'Retail Sale Id 1323760',2502.24,0.00,0.00,0.00,96.24,'2021-12-12 11:49:50','',''),(2258011,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-12 11:49:50','',''),(2258110,'1','198','1016',463,'Retail Sale Id 1323808',1878.24,0.00,0.00,0.00,72.24,'2021-12-12 11:53:52','',''),(2258111,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 11:53:52','',''),(2258144,'1','198','1016',463,'Retail Sale Id 1323824',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 11:55:21','',''),(2258145,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:55:21','',''),(2258184,'1','198','1016',463,'Retail Sale Id 1323844',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 11:57:34','',''),(2258185,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:57:34','',''),(2258216,'1','198','1016',463,'Retail Sale Id 1323862',7500.00,0.00,0.00,0.00,0.00,'2021-12-12 11:59:10','',''),(2258217,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:59:10','',''),(2258386,'1','198','1016',463,'Retail Sale Id 1323941',448500.00,0.00,0.00,0.00,-1500.00,'2021-12-12 12:09:23','',''),(2258387,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,750.00,0.00,'2021-12-12 12:09:23','',''),(2258414,'1','198','1016',463,'Retail Sale Id 1323955',624.00,0.00,0.00,0.00,24.00,'2021-12-12 12:11:15','',''),(2258415,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 12:11:15','',''),(2258444,'1','198','1016',463,'Retail Sale Id 1323971',2496.00,0.00,0.00,0.00,96.00,'2021-12-12 12:12:30','',''),(2258445,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 12:12:30','',''),(2258518,'1','198','1016',463,'Retail Sale Id 1324003',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 12:15:48','',''),(2258519,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:15:48','',''),(2258564,'1','198','1016',463,'Retail Sale Id 1324026',16800.00,0.00,0.00,0.00,0.00,'2021-12-12 12:17:48','',''),(2258565,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-12 12:17:48','',''),(2258698,'1','198','1016',463,'Retail Sale Id 1324092',6240.00,0.00,0.00,0.00,240.00,'2021-12-12 12:24:56','',''),(2258699,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 12:24:56','',''),(2258770,'1','198','1016',463,'Retail Sale Id 1324124',3120.00,0.00,0.00,0.00,120.00,'2021-12-12 12:27:30','',''),(2258771,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:27:30','',''),(2258809,'1','198','1016',463,'Retail Sale Id 1324140',2003.04,0.00,0.00,0.00,77.04,'2021-12-12 12:28:48','',''),(2258810,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-12 12:28:48','',''),(2259048,'1','198','1016',463,'Retail Sale Id 1324256',6240.00,0.00,0.00,0.00,240.00,'2021-12-12 12:38:56','',''),(2259049,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 12:38:56','',''),(2259083,'1','198','1016',463,'Retail Sale Id 1324273',3120.00,0.00,0.00,0.00,120.00,'2021-12-12 12:40:45','',''),(2259084,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:40:45','',''),(2259300,'1','198','1016',463,'Retail Sale Id 1324378',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 12:51:01','',''),(2259301,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 12:51:01','',''),(2259403,'1','198','1016',463,'Retail Sale Id 1324423',15000.00,0.00,0.00,0.00,0.00,'2021-12-12 12:55:40','',''),(2259404,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 12:55:40','',''),(2259796,'1','198','1016',463,'Retail Sale Id 1324626',2003.04,0.00,0.00,0.00,77.04,'2021-12-12 13:17:46','',''),(2259797,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-12 13:17:46','',''),(2260207,'1','198','1016',463,'Retail Sale Id 1324794',90000.00,0.00,0.00,0.00,0.00,'2021-12-12 13:36:59','',''),(2260208,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-12 13:36:59','',''),(2260400,'1','198','1016',463,'Retail Sale Id 1324881',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 13:46:36','',''),(2260401,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:46:36','',''),(2260548,'1','198','1016',463,'Retail Sale Id 1324943',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 13:52:36','',''),(2260549,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:52:36','',''),(2261888,'1','198','1016',463,'Return of Retail Sale Id 1323688',0.00,388700.00,650.00,0.00,1300.00,'2021-12-12 14:58:16','',''),(2261933,'1','198','1016',463,'Retail Sale Id 1325499',499.20,0.00,0.00,0.00,19.20,'2021-12-12 15:00:25','',''),(2261934,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-12 15:00:25','',''),(2261959,'1','198','1016',463,'Retail Sale Id 1325512',59800.00,0.00,0.00,0.00,-200.00,'2021-12-12 15:01:44','',''),(2261960,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 15:01:44','',''),(2261999,'1','198','1016',463,'Retail Sale Id 1325523',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 15:04:11','',''),(2262000,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:04:11','',''),(2262001,'1','198','1016',463,'Retail Sale Id 1325523',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 15:04:11','',''),(2262002,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:04:11','',''),(2262003,'1','198','1016',463,'Retail Sale Id 1325523',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 15:04:11','',''),(2262004,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:04:11','',''),(2262005,'1','198','1016',463,'Retail Sale Id 1325523',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 15:04:11','',''),(2262006,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:04:11','',''),(2262054,'1','198','1016',463,'Retail Sale Id 1325538',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 15:06:11','',''),(2262055,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:06:11','',''),(2262078,'1','198','1016',463,'Retail Sale Id 1325550',59800.00,0.00,0.00,0.00,-200.00,'2021-12-12 15:07:38','',''),(2262079,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 15:07:38','',''),(2262161,'1','198','1016',463,'Retail Sale Id 1325591',179400.00,0.00,0.00,0.00,-600.00,'2021-12-12 15:12:38','',''),(2262162,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-12 15:12:38','',''),(2262392,'1','198','1016',463,'Retail Sale Id 1325699',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 15:25:59','',''),(2262393,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:25:59','',''),(2262406,'1','198','1016',463,'Retail Sale Id 1325705',1878.24,0.00,0.00,0.00,72.24,'2021-12-12 15:26:48','',''),(2262407,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:26:48','',''),(2262510,'1','198','1016',463,'Retail Sale Id 1325757',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 15:32:33','',''),(2262511,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:32:33','',''),(2262736,'1','198','1016',463,'Retail Sale Id 1325853',3120.00,0.00,0.00,0.00,120.00,'2021-12-12 15:43:44','',''),(2262737,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 15:43:44','',''),(2262841,'1','198','1016',463,'Retail Sale Id 1325909',1497.60,0.00,0.00,0.00,57.60,'2021-12-12 15:50:39','',''),(2262842,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-12 15:50:39','',''),(2262867,'1','198','1016',463,'Retail Sale Id 1325922',3750.24,0.00,0.00,0.00,144.24,'2021-12-12 15:51:59','',''),(2262868,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 15:51:59','',''),(2262879,'1','198','1016',463,'Retail Sale Id 1325928',1878.24,0.00,0.00,0.00,72.24,'2021-12-12 15:53:12','',''),(2262880,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-12 15:53:12','',''),(2262923,'1','198','1016',463,'Retail Sale Id 1325950',1497.60,0.00,0.00,0.00,57.60,'2021-12-12 15:57:04','',''),(2262924,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-12 15:57:04','',''),(2263356,'1','198','1016',463,'Retail Sale Id 1326149',7800.00,0.00,0.00,0.00,300.00,'2021-12-12 16:24:56','',''),(2263357,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:24:56','',''),(2263388,'1','198','1016',463,'Retail Sale Id 1326156',1248.00,0.00,0.00,0.00,48.00,'2021-12-12 16:25:56','',''),(2263389,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 16:25:56','',''),(2263534,'1','198','1016',463,'Retail Sale Id 1326233',48000.00,0.00,0.00,0.00,0.00,'2021-12-12 16:35:10','',''),(2263535,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-12 16:35:10','',''),(2263632,'1','198','1016',463,'Retail Sale Id 1326279',2502.24,0.00,0.00,0.00,96.24,'2021-12-12 16:42:12','',''),(2263633,'1','198','1016',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-12 16:42:12','',''),(2265238,'1','198','1016',463,'Return of Retail Sale Id 1323941',0.00,448500.00,750.00,0.00,1500.00,'2021-12-13 05:26:46','',''),(2265245,'1','198','1016',463,'Return of Retail Sale Id 1322985',0.00,10800.00,18.00,0.00,0.00,'2021-12-13 05:29:07','',''),(2265464,'1','198','1016',463,'Distributed to OPERATIONAL LOSS for sales id:339173',478098.00,0.00,0.00,796.83,0.00,'2021-12-13 06:29:32','',''),(2265522,'1','198',NULL,463,'Purchased from AA RANO NIGERIA LIMITED',0.00,15019900.00,24950.00,0.00,0.00,'2021-12-13 06:35:54','',''),(2265539,'1','198',NULL,463,'Reception corrector for bridging 127210',0.00,0.00,0.00,24950.00,0.00,'2021-12-13 06:37:52','',''),(2265540,'1','198','1017',463,'Received from bridging 127210',0.00,0.00,24950.00,0.00,0.00,'2021-12-13 06:37:52','',''),(2265563,'1','198','1017',463,'Retail Sale Id 1326898',478098.00,0.00,0.00,0.00,-1593.66,'2021-12-13 06:40:55','',''),(2265564,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,796.83,0.00,'2021-12-13 06:40:55','',''),(2265758,'1','198','1017',463,'Retail Sale Id 1326990',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 06:58:48','',''),(2265759,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 06:58:48','',''),(2265935,'1','198','1017',463,'Retail Sale Id 1327095',3500.64,0.00,0.00,0.00,123.42,'2021-12-13 07:09:23','',''),(2265936,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-13 07:09:23','',''),(2265977,'1','198','1017',463,'Retail Sale Id 1327118',3120.00,0.00,0.00,0.00,110.00,'2021-12-13 07:12:37','',''),(2265978,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 07:12:37','',''),(2265979,'1','198','1017',463,'Retail Sale Id 1327118',3120.00,0.00,0.00,0.00,110.00,'2021-12-13 07:12:37','',''),(2265980,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 07:12:37','',''),(2266099,'1','198','1017',463,'Retail Sale Id 1327181',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 07:20:37','',''),(2266100,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:20:37','',''),(2266265,'1','198','1017',463,'Retail Sale Id 1327262',9000.00,0.00,0.00,0.00,-30.00,'2021-12-13 07:31:28','',''),(2266266,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-13 07:31:28','',''),(2266413,'1','198','1017',463,'Retail Sale Id 1327335',43500.00,0.00,0.00,0.00,-145.00,'2021-12-13 07:40:52','',''),(2266414,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,72.50,0.00,'2021-12-13 07:40:52','',''),(2266608,'1','198','1017',463,'Retail Sale Id 1327423',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 07:51:48','',''),(2266609,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:51:48','',''),(2266789,'1','198','1017',463,'Retail Sale Id 1327510',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 08:02:02','',''),(2266790,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:02:02','',''),(2266911,'1','198','1017',463,'Retail Sale Id 1327548',648.96,0.00,0.00,0.00,22.88,'2021-12-13 08:06:01','',''),(2266912,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.04,0.00,'2021-12-13 08:06:01','',''),(2266913,'1','198','1017',463,'Retail Sale Id 1327548',1497.60,0.00,0.00,0.00,52.80,'2021-12-13 08:06:01','',''),(2266914,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-13 08:06:01','',''),(2266931,'1','198','1017',463,'Retail Sale Id 1327556',1797.12,0.00,0.00,0.00,63.36,'2021-12-13 08:06:54','',''),(2266932,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-13 08:06:54','',''),(2266984,'1','198','1017',463,'Retail Sale Id 1327573',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 08:09:00','',''),(2266985,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:09:00','',''),(2267338,'1','198','1017',463,'Retail Sale Id 1327714',3001.44,0.00,0.00,0.00,105.82,'2021-12-13 08:26:57','',''),(2267339,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-13 08:26:57','',''),(2267350,'1','198','1017',463,'Retail Sale Id 1327717',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 08:27:40','',''),(2267351,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:27:40','',''),(2267364,'1','198','1017',463,'Retail Sale Id 1327724',3001.44,0.00,0.00,0.00,105.82,'2021-12-13 08:28:29','',''),(2267365,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-13 08:28:29','',''),(2267440,'1','198','1017',463,'Retail Sale Id 1327768',998.40,0.00,0.00,0.00,35.20,'2021-12-13 08:32:05','',''),(2267441,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-13 08:32:05','',''),(2267510,'1','198','1017',463,'Retail Sale Id 1327804',6240.00,0.00,0.00,0.00,220.00,'2021-12-13 08:35:33','',''),(2267511,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 08:35:33','',''),(2268177,'1','198','1017',463,'Retail Sale Id 1328067',7001.28,0.00,0.00,0.00,246.84,'2021-12-13 09:10:09','',''),(2268178,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-13 09:10:09','',''),(2268240,'1','198','1017',463,'Retail Sale Id 1328088',1248.00,0.00,0.00,0.00,44.00,'2021-12-13 09:12:44','',''),(2268241,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 09:12:44','',''),(2268242,'1','198','1017',463,'Retail Sale Id 1328088',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 09:12:44','',''),(2268243,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:12:44','',''),(2268250,'1','198','1017',463,'Retail Sale Id 1328097',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 09:13:21','',''),(2268251,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 09:13:21','',''),(2268272,'1','198','1017',463,'Retail Sale Id 1328107',30000.00,0.00,0.00,0.00,-100.00,'2021-12-13 09:15:17','',''),(2268273,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:15:17','',''),(2268294,'1','198','1017',463,'Retail Sale Id 1328122',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 09:16:22','',''),(2268295,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:16:22','',''),(2268624,'1','198','1017',463,'Retail Sale Id 1328288',6240.00,0.00,0.00,0.00,220.00,'2021-12-13 09:37:39','',''),(2268625,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 09:37:39','',''),(2268684,'1','198','1017',463,'Retail Sale Id 1328321',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 09:41:56','',''),(2268685,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:41:56','',''),(2268759,'1','198','1017',463,'Retail Sale Id 1328362',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 09:47:17','',''),(2268760,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:47:17','',''),(2268807,'1','198','1017',463,'Retail Sale Id 1328380',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 09:49:33','',''),(2268808,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 09:49:33','',''),(2268981,'1','198','1017',463,'Retail Sale Id 1328458',16200.00,0.00,0.00,0.00,-54.00,'2021-12-13 09:59:45','',''),(2268982,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-13 09:59:45','',''),(2269165,'1','198','1017',463,'Retail Sale Id 1328569',998.40,0.00,0.00,0.00,35.20,'2021-12-13 10:12:46','',''),(2269166,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-13 10:12:46','',''),(2269211,'1','198','1017',463,'Retail Sale Id 1328600',7500.00,0.00,0.00,0.00,-25.00,'2021-12-13 10:17:11','',''),(2269212,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:17:11','',''),(2269229,'1','198','1017',463,'Retail Sale Id 1328607',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 10:17:56','',''),(2269230,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:17:56','',''),(2269249,'1','198','1017',463,'Retail Sale Id 1328616',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 10:19:18','',''),(2269250,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:19:18','',''),(2269329,'1','198','1017',463,'Retail Sale Id 1328657',70863.00,0.00,0.00,0.00,-474.00,'2021-12-13 10:26:08','',''),(2269330,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,118.50,0.00,'2021-12-13 10:26:08','',''),(2269331,'1','198','1017',463,'Retail Sale Id 1328659',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 10:26:41','',''),(2269332,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:26:41','',''),(2269347,'1','198','1017',463,'Retail Sale Id 1328668',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 10:27:36','',''),(2269348,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 10:27:36','',''),(2269425,'1','198','1017',463,'Retail Sale Id 1328700',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 10:31:57','',''),(2269426,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:31:57','',''),(2269441,'1','198','1017',463,'Retail Sale Id 1328710',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 10:33:07','',''),(2269442,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:33:07','',''),(2269612,'1','198','1017',463,'Retail Sale Id 1328786',62400.00,0.00,0.00,0.00,2200.00,'2021-12-13 10:42:32','',''),(2269613,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 10:42:32','',''),(2269630,'1','198','1017',463,'Retail Sale Id 1328794',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 10:43:55','',''),(2269631,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 10:43:55','',''),(2269740,'1','198','1017',463,'Retail Sale Id 1328851',3120.00,0.00,0.00,0.00,110.00,'2021-12-13 10:50:09','',''),(2269741,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:50:09','',''),(2269957,'1','198','1017',463,'Retail Sale Id 1328949',5616.00,0.00,0.00,0.00,198.00,'2021-12-13 11:02:14','',''),(2269958,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-13 11:02:14','',''),(2269959,'1','198','1017',463,'Retail Sale Id 1328949',5616.00,0.00,0.00,0.00,198.00,'2021-12-13 11:02:14','',''),(2269960,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-13 11:02:14','',''),(2270155,'1','198','1017',463,'Retail Sale Id 1329050',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 11:17:20','',''),(2270156,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:17:20','',''),(2270201,'1','198','1017',463,'Retail Sale Id 1329073',1697.28,0.00,0.00,0.00,59.84,'2021-12-13 11:20:21','',''),(2270202,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-13 11:20:21','',''),(2270244,'1','198','1017',463,'Retail Sale Id 1329090',15600.00,0.00,0.00,0.00,550.00,'2021-12-13 11:24:14','',''),(2270245,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 11:24:14','',''),(2270302,'1','198','1017',463,'Retail Sale Id 1329112',61200.00,0.00,0.00,0.00,-204.00,'2021-12-13 11:28:13','',''),(2270303,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,102.00,0.00,'2021-12-13 11:28:13','',''),(2270350,'1','198','1017',463,'Retail Sale Id 1329138',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 11:31:37','',''),(2270351,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 11:31:37','',''),(2270538,'1','198','1017',463,'Retail Sale Id 1329232',120000.00,0.00,0.00,0.00,-400.00,'2021-12-13 11:47:56','',''),(2270539,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-13 11:47:56','',''),(2270619,'1','198','1017',463,'Retail Sale Id 1329273',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 11:56:18','',''),(2270620,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:56:18','',''),(2270653,'1','198','1017',463,'Retail Sale Id 1329291',936.00,0.00,0.00,0.00,33.00,'2021-12-13 11:59:57','',''),(2270654,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-13 11:59:57','',''),(2270711,'1','198','1017',463,'Retail Sale Id 1329321',59800.00,0.00,0.00,0.00,-400.00,'2021-12-13 12:03:50','',''),(2270712,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 12:03:50','',''),(2270765,'1','198','1017',463,'Retail Sale Id 1329352',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 12:09:45','',''),(2270766,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:09:45','',''),(2270921,'1','198','1017',463,'Retail Sale Id 1329439',630.24,0.00,0.00,0.00,22.22,'2021-12-13 12:20:20','',''),(2270922,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-13 12:20:20','',''),(2271014,'1','198','1017',463,'Retail Sale Id 1329487',150000.00,0.00,0.00,0.00,-500.00,'2021-12-13 12:28:02','',''),(2271015,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-13 12:28:02','',''),(2271336,'1','198','1017',463,'Retail Sale Id 1329501',150000.00,0.00,0.00,0.00,-500.00,'2021-12-13 12:51:10','',''),(2271337,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-13 12:51:10','',''),(2271370,'1','198','1017',463,'Retail Sale Id 1329687',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 12:53:02','',''),(2271371,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:53:02','',''),(2271372,'1','198','1017',463,'Retail Sale Id 1329687',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 12:53:02','',''),(2271373,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:53:02','',''),(2271392,'1','198','1017',463,'Retail Sale Id 1329697',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 12:53:55','',''),(2271393,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:53:55','',''),(2271394,'1','198','1017',463,'Retail Sale Id 1329697',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 12:53:55','',''),(2271395,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:53:55','',''),(2271425,'1','198','1017',463,'Retail Sale Id 1329712',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 12:55:29','',''),(2271426,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:55:29','',''),(2271427,'1','198','1017',463,'Retail Sale Id 1329712',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 12:55:29','',''),(2271428,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 12:55:29','',''),(2271433,'1','198','1017',463,'Retail Sale Id 1329715',150000.00,0.00,0.00,0.00,-500.00,'2021-12-13 12:56:18','',''),(2271434,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-13 12:56:18','',''),(2271485,'1','198','1017',463,'Retail Sale Id 1329744',48438.00,0.00,0.00,0.00,-324.00,'2021-12-13 12:59:07','',''),(2271486,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,81.00,0.00,'2021-12-13 12:59:07','',''),(2271505,'1','198','1017',463,'Retail Sale Id 1329753',22425.00,0.00,0.00,0.00,-150.00,'2021-12-13 13:00:09','',''),(2271506,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-13 13:00:09','',''),(2271527,'1','198','1017',463,'Retail Sale Id 1329762',2003.04,0.00,0.00,0.00,70.62,'2021-12-13 13:00:44','',''),(2271528,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-13 13:00:44','',''),(2271547,'1','198','1017',463,'Retail Sale Id 1329768',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 13:01:52','',''),(2271548,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:01:52','',''),(2271565,'1','198','1017',463,'Retail Sale Id 1329779',22087.50,0.00,0.00,0.00,-487.50,'2021-12-13 13:03:18','',''),(2271566,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-13 13:03:18','',''),(2271649,'1','198','1017',463,'Retail Sale Id 1329800',499.20,0.00,0.00,0.00,17.60,'2021-12-13 13:08:56','',''),(2271650,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-13 13:08:56','',''),(2271758,'1','198','1017',463,'Retail Sale Id 1329869',3001.44,0.00,0.00,0.00,105.82,'2021-12-13 13:15:58','',''),(2271759,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-13 13:15:58','',''),(2271858,'1','198','1017',463,'Retail Sale Id 1329911',29900.00,0.00,0.00,0.00,-200.00,'2021-12-13 13:21:45','',''),(2271859,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 13:21:45','',''),(2272053,'1','198','1017',463,'Retail Sale Id 1329980',12000.00,0.00,0.00,0.00,-40.00,'2021-12-13 13:30:56','',''),(2272054,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 13:30:56','',''),(2272250,'1','198','1017',463,'Retail Sale Id 1330061',2003.04,0.00,0.00,0.00,70.62,'2021-12-13 13:43:17','',''),(2272251,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-13 13:43:17','',''),(2272652,'1','198','1017',463,'Retail Sale Id 1330235',15000.00,0.00,0.00,0.00,-50.00,'2021-12-13 14:04:45','',''),(2272653,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 14:04:45','',''),(2273463,'1','198','1017',463,'Retail Sale Id 1330683',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 14:53:36','',''),(2273464,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:53:36','',''),(2273483,'1','198','1017',463,'Retail Sale Id 1330694',3120.00,0.00,0.00,0.00,110.00,'2021-12-13 14:54:53','',''),(2273484,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 14:54:53','',''),(2273503,'1','198','1017',463,'Retail Sale Id 1330704',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 14:56:11','',''),(2273504,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 14:56:11','',''),(2273533,'1','198','1017',463,'Retail Sale Id 1330719',2003.04,0.00,0.00,0.00,70.62,'2021-12-13 14:59:13','',''),(2273534,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-13 14:59:13','',''),(2273535,'1','198','1017',463,'Retail Sale Id 1330719',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 14:59:13','',''),(2273536,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 14:59:13','',''),(2273563,'1','198','1017',463,'Retail Sale Id 1330739',29900.00,0.00,0.00,0.00,-200.00,'2021-12-13 15:01:47','',''),(2273564,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 15:01:47','',''),(2273579,'1','198','1017',463,'Retail Sale Id 1330756',18000.00,0.00,0.00,0.00,-60.00,'2021-12-13 15:03:01','',''),(2273580,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-13 15:03:01','',''),(2273591,'1','198','1017',463,'Retail Sale Id 1330761',998.40,0.00,0.00,0.00,35.20,'2021-12-13 15:03:57','',''),(2273592,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-13 15:03:57','',''),(2273891,'1','198','1017',463,'Retail Sale Id 1330898',2502.24,0.00,0.00,0.00,88.22,'2021-12-13 15:21:11','',''),(2273892,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-13 15:21:11','',''),(2273934,'1','198','1017',463,'Retail Sale Id 1330920',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 15:23:16','',''),(2273935,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:23:16','',''),(2274047,'1','198','1017',463,'Retail Sale Id 1330964',12000.00,0.00,0.00,0.00,-40.00,'2021-12-13 15:27:24','',''),(2274048,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 15:27:24','',''),(2274109,'1','198','1017',463,'Retail Sale Id 1330989',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 15:29:54','',''),(2274110,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:29:54','',''),(2274171,'1','198','1017',463,'Retail Sale Id 1331011',3120.00,0.00,0.00,0.00,110.00,'2021-12-13 15:32:02','',''),(2274172,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 15:32:02','',''),(2274230,'1','198','1017',463,'Retail Sale Id 1331040',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 15:34:41','',''),(2274231,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:34:41','',''),(2274353,'1','198','1017',463,'Retail Sale Id 1331096',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 15:39:44','',''),(2274354,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:39:44','',''),(2274453,'1','198','1017',463,'Retail Sale Id 1331150',2003.04,0.00,0.00,0.00,70.62,'2021-12-13 15:44:32','',''),(2274454,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-13 15:44:32','',''),(2274545,'1','198','1017',463,'Retail Sale Id 1331197',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 15:49:04','',''),(2274546,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:49:04','',''),(2274746,'1','198','1017',463,'Retail Sale Id 1331304',1797.12,0.00,0.00,0.00,63.36,'2021-12-13 16:00:22','',''),(2274747,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-13 16:00:22','',''),(2274813,'1','198','1017',463,'Retail Sale Id 1331339',998.40,0.00,0.00,0.00,35.20,'2021-12-13 16:03:46','',''),(2274814,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-13 16:03:46','',''),(2274982,'1','198','1017',463,'Retail Sale Id 1331418',3600.00,0.00,0.00,0.00,-12.00,'2021-12-13 16:13:13','',''),(2274983,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:13:13','',''),(2275006,'1','198','1017',463,'Retail Sale Id 1331433',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 16:14:15','',''),(2275007,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:14:15','',''),(2275022,'1','198','1017',463,'Retail Sale Id 1331443',630.24,0.00,0.00,0.00,22.22,'2021-12-13 16:15:07','',''),(2275023,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-13 16:15:07','',''),(2275042,'1','198','1017',463,'Retail Sale Id 1331452',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 16:16:00','',''),(2275043,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:16:00','',''),(2275107,'1','198','1017',463,'Retail Sale Id 1331486',3750.24,0.00,0.00,0.00,132.22,'2021-12-13 16:19:27','',''),(2275108,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:19:27','',''),(2275204,'1','198','1017',463,'Retail Sale Id 1331535',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 16:24:20','',''),(2275205,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:24:20','',''),(2275271,'1','198','1017',463,'Retail Sale Id 1331567',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 16:28:15','',''),(2275272,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 16:28:15','',''),(2275291,'1','198','1017',463,'Retail Sale Id 1331579',499.20,0.00,0.00,0.00,17.60,'2021-12-13 16:29:02','',''),(2275292,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-13 16:29:02','',''),(2275305,'1','198','1017',463,'Retail Sale Id 1331586',16800.00,0.00,0.00,0.00,-56.00,'2021-12-13 16:29:54','',''),(2275306,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-13 16:29:54','',''),(2275336,'1','198','1017',463,'Retail Sale Id 1331598',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 16:31:45','',''),(2275337,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:31:45','',''),(2275368,'1','198','1017',463,'Retail Sale Id 1331616',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 16:33:39','',''),(2275369,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:33:39','',''),(2275431,'1','198','1017',463,'Retail Sale Id 1331650',7800.00,0.00,0.00,0.00,275.00,'2021-12-13 16:37:02','',''),(2275432,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:37:02','',''),(2275504,'1','198','1017',463,'Retail Sale Id 1331689',1878.24,0.00,0.00,0.00,66.22,'2021-12-13 16:41:33','',''),(2275505,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.01,0.00,'2021-12-13 16:41:33','',''),(2275686,'1','198','1017',463,'Retail Sale Id 1331784',7500.00,0.00,0.00,0.00,-25.00,'2021-12-13 16:54:01','',''),(2275687,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:54:01','',''),(2275725,'1','198','1017',463,'Retail Sale Id 1331802',630.24,0.00,0.00,0.00,22.22,'2021-12-13 16:56:01','',''),(2275726,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-13 16:56:01','',''),(2277343,'1','198','1017',463,'Retail Sale Id 1332255',14250.00,0.00,0.00,0.00,-800.00,'2021-12-14 06:34:51','',''),(2277344,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-14 06:34:51','',''),(2277367,'1','198','1017',463,'Retail Sale Id 1332264',6160.00,0.00,0.00,0.00,140.00,'2021-12-14 06:36:22','',''),(2277368,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-14 06:36:22','',''),(2277479,'1','198','1017',463,'Retail Sale Id 1332318',1848.00,0.00,0.00,0.00,42.00,'2021-12-14 06:43:19','',''),(2277480,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 06:43:19','',''),(2277498,'1','198','1017',463,'Retail Sale Id 1332328',1503.04,0.00,0.00,0.00,34.16,'2021-12-14 06:44:15','',''),(2277499,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 06:44:15','',''),(2277724,'1','198','1017',463,'Retail Sale Id 1332442',5001.92,0.00,0.00,0.00,113.68,'2021-12-14 06:58:34','',''),(2277725,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-14 06:58:34','',''),(2277796,'1','198','1017',463,'Retail Sale Id 1332479',3498.88,0.00,0.00,0.00,79.52,'2021-12-14 07:04:17','',''),(2277797,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.68,0.00,'2021-12-14 07:04:17','',''),(2277911,'1','198','1017',463,'Retail Sale Id 1332538',997.92,0.00,0.00,0.00,22.68,'2021-12-14 07:12:57','',''),(2277912,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 07:12:57','',''),(2278126,'1','198','1017',463,'Retail Sale Id 1332652',6160.00,0.00,0.00,0.00,140.00,'2021-12-14 07:25:32','',''),(2278127,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-14 07:25:32','',''),(2278275,'1','198','1017',463,'Retail Sale Id 1332724',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 07:35:03','',''),(2278276,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 07:35:03','',''),(2278293,'1','198','1017',463,'Retail Sale Id 1332733',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 07:35:57','',''),(2278294,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 07:35:57','',''),(2278566,'1','198','1017',463,'Retail Sale Id 1332986',7125.00,0.00,0.00,0.00,-400.00,'2021-12-14 07:52:17','',''),(2278567,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 07:52:17','',''),(2278952,'1','198','1017',463,'Retail Sale Id 1333167',1848.00,0.00,0.00,0.00,42.00,'2021-12-14 08:12:08','',''),(2278953,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:12:08','',''),(2278954,'1','198','1017',463,'Retail Sale Id 1333167',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 08:12:08','',''),(2278955,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:12:08','',''),(2279101,'1','198','1017',463,'Retail Sale Id 1333269',2470.16,0.00,0.00,0.00,56.14,'2021-12-14 08:19:53','',''),(2279102,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-14 08:19:53','',''),(2279125,'1','198','1017',463,'Retail Sale Id 1333276',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 08:21:01','',''),(2279126,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:21:01','',''),(2279161,'1','198','1017',463,'Retail Sale Id 1333302',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 08:23:35','',''),(2279162,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:23:35','',''),(2279251,'1','198','1017',463,'Retail Sale Id 1333344',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 08:29:02','',''),(2279252,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:29:02','',''),(2279303,'1','198','1017',463,'Retail Sale Id 1333374',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 08:32:05','',''),(2279304,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:32:05','',''),(2279379,'1','198','1017',463,'Retail Sale Id 1333410',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 08:35:43','',''),(2279380,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 08:35:43','',''),(2279391,'1','198','1017',463,'Retail Sale Id 1333420',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 08:36:50','',''),(2279392,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:36:50','',''),(2279418,'1','198','1017',463,'Retail Sale Id 1333433',2002.00,0.00,0.00,0.00,45.50,'2021-12-14 08:37:55','',''),(2279419,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 08:37:55','',''),(2279522,'1','198','1017',463,'Retail Sale Id 1333490',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 08:43:03','',''),(2279523,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:43:03','',''),(2279575,'1','198','1017',463,'Retail Sale Id 1333524',1848.00,0.00,0.00,0.00,42.00,'2021-12-14 08:45:59','',''),(2279576,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:45:59','',''),(2279643,'1','198','1017',463,'Retail Sale Id 1333561',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 08:50:03','',''),(2279644,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:50:03','',''),(2279659,'1','198','1017',463,'Retail Sale Id 1333568',1848.00,0.00,0.00,0.00,42.00,'2021-12-14 08:51:04','',''),(2279660,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 08:51:04','',''),(2279861,'1','198','1017',463,'Retail Sale Id 1333635',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 08:59:33','',''),(2279862,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 08:59:33','',''),(2279904,'1','198','1017',463,'Retail Sale Id 1333649',6160.00,0.00,0.00,0.00,140.00,'2021-12-14 09:01:10','',''),(2279905,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-14 09:01:10','',''),(2280185,'1','198','1017',463,'Retail Sale Id 1333774',3080.00,0.00,0.00,0.00,70.00,'2021-12-14 09:13:21','',''),(2280186,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 09:13:21','',''),(2280440,'1','198','1017',463,'Retail Sale Id 1333872',1848.00,0.00,0.00,0.00,42.00,'2021-12-14 09:25:15','',''),(2280441,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 09:25:15','',''),(2280520,'1','198','1017',463,'Retail Sale Id 1333917',56800.00,0.00,0.00,0.00,-3400.00,'2021-12-14 09:29:43','',''),(2280521,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-14 09:29:43','',''),(2280556,'1','198','1017',463,'Retail Sale Id 1333935',170400.00,0.00,0.00,0.00,-10200.00,'2021-12-14 09:31:28','',''),(2280557,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-14 09:31:28','',''),(2280588,'1','198','1017',463,'Retail Sale Id 1333954',28500.00,0.00,0.00,0.00,-1600.00,'2021-12-14 09:33:06','',''),(2280589,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 09:33:06','',''),(2280620,'1','198','1017',463,'Retail Sale Id 1333974',1232.00,0.00,0.00,0.00,28.00,'2021-12-14 09:35:18','',''),(2280621,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:35:18','',''),(2280714,'1','198','1017',463,'Retail Sale Id 1334016',28400.00,0.00,0.00,0.00,-1700.00,'2021-12-14 09:41:07','',''),(2280715,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-14 09:41:07','',''),(2280739,'1','198','1017',463,'Retail Sale Id 1334025',2002.00,0.00,0.00,0.00,45.50,'2021-12-14 09:42:03','',''),(2280740,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 09:42:03','',''),(2280764,'1','198','1017',463,'Retail Sale Id 1334037',622.16,0.00,0.00,0.00,14.14,'2021-12-14 09:43:35','',''),(2280765,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.01,0.00,'2021-12-14 09:43:35','',''),(2280782,'1','198','1017',463,'Retail Sale Id 1334045',56800.00,0.00,0.00,0.00,-3400.00,'2021-12-14 09:44:38','',''),(2280783,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-14 09:44:38','',''),(2280824,'1','198','1017',463,'Retail Sale Id 1334068',57000.00,0.00,0.00,0.00,-3200.00,'2021-12-14 09:46:53','',''),(2280825,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-14 09:46:53','',''),(2280868,'1','198','1017',463,'Retail Sale Id 1334089',57000.00,0.00,0.00,0.00,-3200.00,'2021-12-14 09:50:06','',''),(2280869,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-14 09:50:06','',''),(2281145,'1','198','1017',463,'Retail Sale Id 1334233',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 10:07:12','',''),(2281146,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 10:07:12','',''),(2281650,'1','198','1017',463,'Retail Sale Id 1334535',11400.00,0.00,0.00,0.00,-640.00,'2021-12-14 10:32:23','',''),(2281651,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-14 10:32:23','',''),(2281692,'1','198','1017',463,'Retail Sale Id 1334561',3702.16,0.00,0.00,0.00,84.14,'2021-12-14 10:34:25','',''),(2281693,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 10:34:25','',''),(2281945,'1','198','1017',463,'Retail Sale Id 1334691',1848.00,0.00,0.00,0.00,42.00,'2021-12-14 10:48:08','',''),(2281946,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:48:08','',''),(2281947,'1','198','1017',463,'Retail Sale Id 1334691',3080.00,0.00,0.00,0.00,70.00,'2021-12-14 10:48:08','',''),(2281948,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:48:08','',''),(2281949,'1','198','1017',463,'Retail Sale Id 1334691',3080.00,0.00,0.00,0.00,70.00,'2021-12-14 10:48:08','',''),(2281950,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:48:08','',''),(2281961,'1','198','1017',463,'Retail Sale Id 1334698',6997.76,0.00,0.00,0.00,159.04,'2021-12-14 10:49:15','',''),(2281962,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-14 10:49:15','',''),(2281996,'1','198','1017',463,'Retail Sale Id 1334717',2500.96,0.00,0.00,0.00,56.84,'2021-12-14 10:51:16','',''),(2281997,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-14 10:51:16','',''),(2282068,'1','198','1017',463,'Retail Sale Id 1334760',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 10:55:54','',''),(2282069,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:55:54','',''),(2282138,'1','198','1017',463,'Retail Sale Id 1334804',7125.00,0.00,0.00,0.00,-400.00,'2021-12-14 11:00:55','',''),(2282139,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:00:55','',''),(2282178,'1','198','1017',463,'Retail Sale Id 1334820',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 11:03:39','',''),(2282179,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:03:39','',''),(2282241,'1','198','1017',463,'Retail Sale Id 1334850',997.92,0.00,0.00,0.00,22.68,'2021-12-14 11:06:43','',''),(2282242,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 11:06:43','',''),(2282279,'1','198','1017',463,'Retail Sale Id 1334872',1710.00,0.00,0.00,0.00,-96.00,'2021-12-14 11:09:08','',''),(2282280,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 11:09:08','',''),(2282313,'1','198','1017',463,'Retail Sale Id 1334889',7700.00,0.00,0.00,0.00,175.00,'2021-12-14 11:10:48','',''),(2282314,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 11:10:48','',''),(2282347,'1','198','1017',463,'Retail Sale Id 1334903',24225.00,0.00,0.00,0.00,-1360.00,'2021-12-14 11:12:41','',''),(2282348,'1','198','1017',463,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-14 11:12:41','',''),(2282442,'1','198','1017',463,'Retail Sale Id 1335319',71250.00,0.00,0.00,125.00,-4000.00,'2021-12-14 12:15:22','',''),(2282445,'1','198','1017',463,'Retail Sale Id 1335322',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 12:17:18','',''),(2282446,'1','198','1017',463,'Retail Sale Id 1335324',5001.92,0.00,0.00,8.12,113.68,'2021-12-14 12:18:09','',''),(2282461,'1','198','1017',463,'Retail Sale Id 1335344',99750.00,0.00,0.00,175.00,-5600.00,'2021-12-14 12:22:08','',''),(2282469,'1','198','1017',463,'Retail Sale Id 1335351',3080.00,0.00,0.00,5.00,70.00,'2021-12-14 12:24:21','',''),(2282529,'1','198','1017',463,'Retail Sale Id 1335424',997.92,0.00,0.00,1.62,22.68,'2021-12-14 12:36:05','',''),(2282530,'1','198','1017',463,'Retail Sale Id 1335424',1848.00,0.00,0.00,3.00,42.00,'2021-12-14 12:36:05','',''),(2282531,'1','198','1017',463,'Retail Sale Id 1335424',1848.00,0.00,0.00,3.00,42.00,'2021-12-14 12:36:05','',''),(2282532,'1','198','1017',463,'Retail Sale Id 1335424',1848.00,0.00,0.00,3.00,42.00,'2021-12-14 12:36:05','',''),(2282533,'1','198','1017',463,'Retail Sale Id 1335424',2002.00,0.00,0.00,3.25,45.50,'2021-12-14 12:36:05','',''),(2282534,'1','198','1017',463,'Retail Sale Id 1335424',3080.00,0.00,0.00,5.00,70.00,'2021-12-14 12:36:05','',''),(2282535,'1','198','1017',463,'Retail Sale Id 1335424',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 12:36:05','',''),(2282536,'1','198','1017',463,'Retail Sale Id 1335424',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 12:36:05','',''),(2282537,'1','198','1017',463,'Retail Sale Id 1335424',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 12:36:05','',''),(2282538,'1','198','1017',463,'Retail Sale Id 1335424',6160.00,0.00,0.00,10.00,140.00,'2021-12-14 12:36:05','',''),(2282539,'1','198','1017',463,'Retail Sale Id 1335424',7348.88,0.00,0.00,11.93,167.02,'2021-12-14 12:36:05','',''),(2282540,'1','198','1017',463,'Retail Sale Id 1335424',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 12:36:05','',''),(2282541,'1','198','1017',463,'Retail Sale Id 1335424',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 12:36:05','',''),(2282542,'1','198','1017',463,'Retail Sale Id 1335424',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 12:36:05','',''),(2282555,'1','198','1017',463,'Retail Sale Id 1335436',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 12:37:36','',''),(2282561,'1','198','1017',463,'Retail Sale Id 1335443',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 12:38:34','',''),(2282584,'1','198','1017',463,'Retail Sale Id 1335466',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 12:42:09','',''),(2282591,'1','198','1017',463,'Retail Sale Id 1335473',184.80,0.00,0.00,0.30,4.20,'2021-12-14 12:43:02','',''),(2282606,'1','198','1017',463,'Retail Sale Id 1335483',14250.00,0.00,0.00,25.00,-800.00,'2021-12-14 12:44:28','',''),(2282631,'1','198','1017',463,'Retail Sale Id 1335500',6160.00,0.00,0.00,10.00,140.00,'2021-12-14 12:46:25','',''),(2282648,'1','198','1017',463,'Retail Sale Id 1335514',6160.00,0.00,0.00,10.00,140.00,'2021-12-14 12:49:03','',''),(2282674,'1','198','1017',463,'Retail Sale Id 1335528',28400.00,0.00,0.00,50.00,-1700.00,'2021-12-14 12:50:40','',''),(2282923,'1','198','1017',463,'Retail Sale Id 1335750',3080.00,0.00,0.00,5.00,70.00,'2021-12-14 13:24:15','',''),(2282996,'1','198','1017',463,'Retail Sale Id 1335806',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 13:32:50','',''),(2283009,'1','198','1017',463,'Retail Sale Id 1335821',5001.92,0.00,0.00,8.12,113.68,'2021-12-14 13:34:41','',''),(2283043,'1','198','1017',463,'Retail Sale Id 1335846',3080.00,0.00,0.00,5.00,70.00,'2021-12-14 13:39:14','',''),(2283264,'1','198','1017',463,'Retail Sale Id 1335977',7125.00,0.00,0.00,12.50,-400.00,'2021-12-14 14:01:18','',''),(2283312,'1','198','1017',463,'Retail Sale Id 1336015',7125.00,0.00,0.00,12.50,-400.00,'2021-12-14 14:06:07','',''),(2283372,'1','198','1017',463,'Retail Sale Id 1336038',3080.00,0.00,0.00,5.00,70.00,'2021-12-14 14:08:49','',''),(2283383,'1','198','1017',463,'Retail Sale Id 1336048',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 14:10:14','',''),(2283409,'1','198','1017',463,'Retail Sale Id 1336067',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 14:14:34','',''),(2283487,'1','198','1017',463,'Retail Sale Id 1336139',85500.00,0.00,0.00,150.00,-4800.00,'2021-12-14 14:23:39','',''),(2283645,'1','198','1017',463,'Retail Sale Id 1336251',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 14:39:42','',''),(2283726,'1','198','1017',463,'Retail Sale Id 1336314',3498.88,0.00,0.00,5.68,79.52,'2021-12-14 14:49:21','',''),(2283850,'1','198','1017',463,'Retail Sale Id 1336411',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 15:06:27','',''),(2283858,'1','198','1017',463,'Retail Sale Id 1336423',1848.00,0.00,0.00,3.00,42.00,'2021-12-14 15:08:00','',''),(2283926,'1','198','1017',463,'Retail Sale Id 1336490',9997.68,0.00,0.00,16.23,227.22,'2021-12-14 15:20:06','',''),(2284048,'1','198','1017',463,'Retail Sale Id 1336574',997.92,0.00,0.00,1.62,22.68,'2021-12-14 15:32:28','',''),(2284160,'1','198','1017',463,'Retail Sale Id 1336626',15960.00,0.00,0.00,28.00,-896.00,'2021-12-14 15:40:37','',''),(2284180,'1','198','1017',463,'Retail Sale Id 1336637',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 15:41:41','',''),(2284199,'1','198','1017',463,'Retail Sale Id 1336651',3997.84,0.00,0.00,6.49,90.86,'2021-12-14 15:43:27','',''),(2284210,'1','198','1017',463,'Retail Sale Id 1336663',1798.72,0.00,0.00,2.92,40.88,'2021-12-14 15:45:18','',''),(2284239,'1','198','1017',463,'Retail Sale Id 1336681',1897.28,0.00,0.00,3.08,43.12,'2021-12-14 15:47:33','',''),(2284240,'1','198','1017',463,'Retail Sale Id 1336681',2002.00,0.00,0.00,3.25,45.50,'2021-12-14 15:47:33','',''),(2284256,'1','198','1017',463,'Retail Sale Id 1336691',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 15:49:01','',''),(2284294,'1','198','1017',463,'Retail Sale Id 1336716',28500.00,0.00,0.00,50.00,-1600.00,'2021-12-14 15:51:11','',''),(2284407,'1','198','1017',463,'Retail Sale Id 1336799',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 16:02:05','',''),(2284496,'1','198','1017',463,'Retail Sale Id 1336887',3498.88,0.00,0.00,5.68,79.52,'2021-12-14 16:11:19','',''),(2284529,'1','198','1017',463,'Retail Sale Id 1336923',3080.00,0.00,0.00,5.00,70.00,'2021-12-14 16:16:07','',''),(2284549,'1','198','1017',463,'Retail Sale Id 1336943',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 16:18:28','',''),(2284575,'1','198','1017',463,'Retail Sale Id 1336970',2999.92,0.00,0.00,4.87,68.18,'2021-12-14 16:21:53','',''),(2284755,'1','198','1017',463,'Retail Sale Id 1337125',57000.00,0.00,0.00,100.00,-3200.00,'2021-12-14 16:35:22','',''),(2284763,'1','198','1017',463,'Retail Sale Id 1337133',3997.84,0.00,0.00,6.49,90.86,'2021-12-14 16:36:14','',''),(2284801,'1','198','1017',463,'Retail Sale Id 1337156',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 16:38:52','',''),(2284829,'1','198','1017',463,'Retail Sale Id 1337181',17040.00,0.00,0.00,30.00,-1020.00,'2021-12-14 16:42:14','',''),(2284882,'1','198','1017',463,'Retail Sale Id 1337202',7125.00,0.00,0.00,12.50,-400.00,'2021-12-14 16:44:07','',''),(2284981,'1','198','1017',463,'Retail Sale Id 1337267',7700.00,0.00,0.00,12.50,175.00,'2021-12-14 16:53:46','',''),(2285102,'1','198','1017',463,'Retail Sale Id 1337385',1848.00,0.00,0.00,3.00,42.00,'2021-12-14 17:08:30','',''),(2285109,'1','198','1017',463,'Retail Sale Id 1337394',3702.16,0.00,0.00,6.01,84.14,'2021-12-14 17:09:27','',''),(2286015,'1','198','1017',463,'Retail Sale Id 1337740',7700.00,0.00,0.00,12.50,175.00,'2021-12-15 06:18:34','',''),(2286330,'1','198','1017',463,'Retail Sale Id 1337988',6160.00,0.00,0.00,10.00,140.00,'2021-12-15 07:01:46','',''),(2286412,'1','198','1017',463,'Retail Sale Id 1338066',1848.00,0.00,0.00,3.00,42.00,'2021-12-15 07:09:23','',''),(2286635,'1','198','1017',463,'Retail Sale Id 1338285',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 07:36:33','',''),(2286661,'1','198','1017',463,'Retail Sale Id 1338312',6997.76,0.00,0.00,11.36,159.04,'2021-12-15 07:38:56','',''),(2286681,'1','198','1017',463,'Retail Sale Id 1338332',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 07:41:33','',''),(2286739,'1','198','1017',463,'Retail Sale Id 1338371',5500.88,0.00,0.00,8.93,125.02,'2021-12-15 07:47:14','',''),(2286823,'1','198','1017',463,'Retail Sale Id 1338416',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 07:52:17','',''),(2286845,'1','198','1017',463,'Retail Sale Id 1338441',8550.00,0.00,0.00,15.00,-480.00,'2021-12-15 07:56:32','',''),(2286857,'1','198','1017',463,'Retail Sale Id 1338454',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 07:57:56','',''),(2286877,'1','198','1017',463,'Retail Sale Id 1338470',4928.00,0.00,0.00,8.00,112.00,'2021-12-15 07:59:41','',''),(2286894,'1','198','1017',463,'Retail Sale Id 1338481',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 08:00:54','',''),(2286926,'1','198','1017',463,'Retail Sale Id 1338501',3080.00,0.00,0.00,5.00,70.00,'2021-12-15 08:03:17','',''),(2286954,'1','198','1017',463,'Retail Sale Id 1338526',1238.16,0.00,0.00,2.01,28.14,'2021-12-15 08:06:40','',''),(2287009,'1','198','1017',463,'Retail Sale Id 1338546',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 08:08:37','',''),(2287096,'1','198','1017',463,'Retail Sale Id 1338621',3080.00,0.00,0.00,5.00,70.00,'2021-12-15 08:17:38','',''),(2287126,'1','198','1017',463,'Retail Sale Id 1338642',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 08:19:24','',''),(2287163,'1','198','1017',463,'Retail Sale Id 1338667',2002.00,0.00,0.00,3.25,45.50,'2021-12-15 08:23:03','',''),(2287205,'1','198','1017',463,'Retail Sale Id 1338720',15400.00,0.00,0.00,25.00,350.00,'2021-12-15 08:28:34','',''),(2287214,'1','198','1017',463,'Retail Sale Id 1338733',2999.92,0.00,0.00,4.87,68.18,'2021-12-15 08:29:59','',''),(2287272,'1','198','1017',463,'Retail Sale Id 1338764',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 08:34:38','',''),(2287380,'1','198','1017',463,'Retail Sale Id 1338861',1848.00,0.00,0.00,3.00,42.00,'2021-12-15 08:46:25','',''),(2287392,'1','198','1017',463,'Retail Sale Id 1338875',6160.00,0.00,0.00,10.00,140.00,'2021-12-15 08:47:51','',''),(2287479,'1','198','1017',463,'Retail Sale Id 1338959',7700.00,0.00,0.00,12.50,175.00,'2021-12-15 08:59:24','',''),(2287502,'1','198','1017',463,'Retail Sale Id 1338979',3702.16,0.00,0.00,6.01,84.14,'2021-12-15 09:03:06','',''),(2287620,'1','198','1017',463,'Retail Sale Id 1339046',498.96,0.00,0.00,0.81,11.34,'2021-12-15 09:12:05','',''),(2287642,'1','198','1017',463,'Retail Sale Id 1339072',31498.20,0.00,0.00,55.26,-1768.32,'2021-12-15 09:15:49','',''),(2287654,'1','198','1017',463,'Retail Sale Id 1339084',1848.00,0.00,0.00,3.00,42.00,'2021-12-15 09:17:14','',''),(2287669,'1','198','1017',463,'Retail Sale Id 1339095',7700.00,0.00,0.00,12.50,175.00,'2021-12-15 09:18:45','',''),(2287697,'1','198','1017',463,'Retail Sale Id 1339117',3990.00,0.00,0.00,7.00,-224.00,'2021-12-15 09:22:24','',''),(2287714,'1','198','1017',463,'Retail Sale Id 1339130',1848.00,0.00,0.00,3.00,42.00,'2021-12-15 09:23:49','',''),(2287735,'1','198','1017',463,'Retail Sale Id 1339152',7700.00,0.00,0.00,12.50,175.00,'2021-12-15 09:26:04','',''),(2287780,'1','198','1017',463,'Retail Sale Id 1339193',78375.00,0.00,0.00,137.50,-4400.00,'2021-12-15 09:31:51','',''),(2287805,'1','198','1017',463,'Retail Sale Id 1339212',99750.00,