-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_197
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_197`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_197` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_197`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3833 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3820,400124,'',0,'22','1','197','PURCHASES','','2021-10-29 23:14:45',5,0.00,0.00,'','479','2021-10-29 23:14:45','479',0,1),(3821,20058,'',0,'20','1','197','SALES','','2021-10-29 23:15:03',5,0.00,0.00,'','479','2021-10-29 23:15:03','479',0,1),(3822,40058,'',0,'6.1','1','197','CASH','','2021-10-29 23:15:17',5,0.00,0.00,'','479','2021-10-29 23:15:17','479',0,1),(3823,400350,'',0,'24','1','197','SALARIES & WAGES','','2021-10-29 23:15:48',5,0.00,0.00,'','479','2021-10-29 23:15:48','479',0,1),(3824,400351,'',0,'24','1','197','PURCHASES','','2021-10-29 23:16:11',5,0.00,0.00,'','479','2021-10-29 23:16:11','479',0,1),(3825,400673,'',0,'2','1','197','ZB(LPG)1014471475','','2021-10-29 23:16:27',5,0.00,0.00,'','479','2021-10-29 23:16:27','479',0,1),(3826,400674,'',0,'2','1','197','FB(IBAL)2023855223','','2021-10-29 23:16:45',5,0.00,0.00,'','479','2021-10-29 23:16:45','479',0,1),(3827,400675,'',0,'2','1','197','E-BILLS 1015372548','','2021-10-29 23:17:01',5,0.00,0.00,'','479','2021-10-29 23:17:01','479',0,1),(3828,400676,'',0,'2','1','197','UNITY BANK-0024061656','','2021-10-29 23:17:26',5,0.00,0.00,'','479','2021-10-29 23:17:26','479',0,1),(3829,400677,'',0,'2','1','197','UBA YOLA-1021398099','','2021-10-29 23:17:38',5,0.00,0.00,'','479','2021-10-29 23:17:38','479',0,1),(3830,400678,'',0,'2','1','197','FID POS COLLECTION-5620141491','','2021-10-29 23:17:50',5,0.00,0.00,'','479','2021-10-29 23:17:50','479',0,1),(3831,400679,'',0,'2','1','197','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:03:45',5,0.00,0.00,'','792','2023-02-20 14:03:45','792',0,0),(3832,400680,'',0,'2','1','197','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:16:10',5,0.00,0.00,'2023-03-17','792','2023-03-17 12:21:47','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4270 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3636,'','1','197','ALL DEALER','DEALER','08130302862','@gmai.com','ABUJA','ABUJA','CITYGATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-30 18:21:43',5,'705','2021-10-30 18:21:43','705'),(3936,'','1','197','ANCLE PRTE','DEALER','08035893542','anclepete7@gmail.com','ABUJA','ABUJA','ZONE 6 CENTRALL AREA ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-02 11:58:56',5,'705','2021-12-02 11:58:56','705'),(3943,'','1','197','BRIGHT GAS','DEALER','08152674807','@gmai.com','ABUJA','ABUJA','KARMOJIJI BY CHATHOLIC CHORCH','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-03 10:46:46',5,'705','2021-12-03 10:46:46','705'),(3973,'','1','197','ASUK GAS','AREA 10 ','08130066995','@gmail.com','ABUJA','ABUJA','AREA 10','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-07 16:08:57',5,'705','2021-12-07 16:08:57','705'),(4006,'','1','197','BABAFRAYO GASD','WUYE','08059884283','wuye@gmail.com','ABUJA','ABUJA','WUYE INTERNA FILLING STATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-11 11:58:53',5,'705','2021-12-11 11:58:53','705'),(4007,'','1','197','WILLY GAS','KARMOJIJI','08035929405','@gmail.com','ABUJA','ABUJA','KARMOJIJI ALONG ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-11 12:57:10',5,'705','2021-12-11 12:57:10','705'),(4010,'','1','197','AMAZING GRASE','LUGBE','07034315405','@gmail.com','ABUJA','ABUJA','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-11 15:19:14',5,'705','2021-12-11 15:19:14','705'),(4018,'','1','197','EMINENT GAS','KARMOJIJI','07062099055','@gmail.com','ABUJA','ABUJA','KARMOJIJI BEHIND CANOPY CHURCH','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-12 17:42:58',5,'705','2021-12-12 17:42:58','705'),(4024,'','1','197','METRO GAS','BEN ','08036120277','@gmail.com','ABUJA','ABUJA','AREA 10','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-14 11:29:43',5,'705','2021-12-14 11:29:43','705'),(4035,'','1','197','NOBLE GAS','AREA 10 ','08037793016','judi4all2013@gmail.com','ABUJA','ABUJA','U T C AREA 10','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-16 10:22:53',5,'705','2021-12-16 10:22:53','705'),(4037,'','1','197','EMMERSON GAS','ZONE 1','07057999699','@gmail.com','ABUJA','ABUJA','AIRPORD ROAD PIWON','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-16 11:04:21',5,'705','2021-12-16 11:04:21','705'),(4038,'','1','197','BENOR GAS','BLESSING','07034750366','@gmail.com','ABUJA','ABUJA','ETERNA FILLING STATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-16 11:10:46',5,'705','2021-12-16 11:10:46','705'),(4042,'','1','197','LOLO GAS','PRINCE AND PRINCESS ESTATE','08035958700','@gmail.com','ABUJA','ABUJA','PRINCE AND PRINCESS ESTATE GAME VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-17 10:00:54',5,'705','2021-12-17 10:00:54','705'),(4051,'','1','197','EMMA BEST','GARKI','08068502811','@gmail.com','ABUJA','ABUJA','GARKI MODERN MARKET  ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-19 12:29:25',5,'705','2022-05-28 19:14:29','705'),(4056,'','1','197','U N J EXCELLENT','LUGBE','08063007118','@gmail.com','ABUJA','ABUJA','LUGBE ACROSS','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-19 14:29:30',5,'705','2021-12-19 14:29:30','705'),(4065,'','1','197','DE-GRASIOUS GAS','KUCHIGORO','09061962533','matthewedeaga@gmail.com','ABUJA','ABUJA','kuchigoro nepa office','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-21 11:16:37',5,'705','2021-12-21 11:16:37','705'),(4087,'','1','197','ZAKIOUS GAS','KWOI','07059277155','@gmail.com','KADUNA','KADUNA','KADUNA JABA LGA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-25 06:33:14',5,'705','2021-12-25 06:33:14','705'),(4093,'','1','197','MAN OF PEACE','AIRPORT','07039484816','@gmail.com','ABUJA','ABUJA','AIRPORT BEHIND IMMIGRATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-26 07:03:35',5,'705','2021-12-26 07:03:35','705'),(4096,'','1','197','MIC GAS','OSITA ','08036193874','@gmail.com','ABUJA','ABUJA','PIWOYI ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-26 15:31:04',5,'705','2021-12-26 15:31:04','705'),(4098,'','1','197','M B GAS','BEN ','07085857663','@gmail.com','ABUJA','ABUJA','MIYE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-27 08:42:34',5,'705','2021-12-27 08:42:34','705'),(4130,'','1','197','EVER BEST GAS','LUGBE','08035937780','@gmail.com','ABUJA','ABUJA','LUGBE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-02 09:24:46',5,'705','2022-01-02 09:24:46','705'),(4220,'','1','197','0LA WINNERS GAS','LUGBE','08038065178','@gmail.com','ABUJA','ABUJA','LUGBE PHASE 2','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-21 11:14:40',5,'705','2022-01-21 11:14:40','705'),(4251,'','1','197','Onyites','KARMOJIJI','08068502811','@gmail.com','ABUJA','ABUJA','Karmojiji along road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-01-30 18:37:31',5,'705','2022-01-30 18:37:31','705'),(4252,'','1','197','CHIKESON GAS','AIRPORT','08039577622','@gmail.com','ABUJA','ABUJA','AIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-11 16:03:02',5,'705','2022-02-11 16:03:02','705'),(4253,'','1','197','PARU POWER SOLUTION LTD','KWANTAGORA ROAD KATAMPE','09022222304','@gmail.com','ABUJA','ABUJA','MAMMAN ROAD KWANTAGORA KATAMPE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-13 15:10:59',5,'705','2022-02-13 15:10:59','705'),(4254,'','1','197','ZION GAS ','GWAGWALADA','08112889272','alexanderoni09@gmail.com','ABUJA','ABUJA','ZION PLAZA GWAKO GWAGWALADA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-13 15:17:37',5,'705','2022-02-13 15:17:37','705'),(4255,'','1','197','IK APO','APO','08033713967','nwatuikechukwu7@gmail.com','enugu','ABUJA','apo machenic village by  primary school junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-18 14:56:22',5,'705','2022-02-18 14:56:22','705'),(4256,'','1','197','PAM GAS','UTAKO','08037039527','@gmail.com','ABUJA','ABUJA','UTAKO OPP  OWAMDO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 12:07:29',5,'705','2022-02-26 12:07:29','705'),(4257,'','1','197','GAS RIGHT L T D','MOBILE','08065635593','@gmail.com','ABUJA','ABUJA','MOBILE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 14:07:02',5,'705','2022-02-26 14:07:02','705'),(4258,'','1','197','DE-GRALE GAS','AREA 10 ','08058825528','@gmail.com','ABUJA','ABUJA','ZONE 1','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-28 13:06:30',5,'705','2022-02-28 13:06:30','705'),(4259,'','1','197','SK GAS','ABDULRAZAK','09074595948','@gmail.com','ABUJA','ABUJA','MAITAMA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-01 13:00:14',5,'705','2022-03-01 13:00:14','705'),(4260,'','1','197','JAMES GAS','PIWOE','07032343959','@gmail.com','ABUJA','ABUJA','PIWUE BYFIELD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-05 17:02:05',5,'705','2022-03-05 17:02:05','705'),(4261,'','1','197','OBYNO GAS','LUGBE','08036108885','@gmail.com','ABUJA','ABUJA','LUGBE ZONE 9','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-06 10:55:47',5,'705','2022-03-06 10:55:47','705'),(4262,'','1','197','ANENTED GAS','SAUKA','08104707780','agbosolomon26@gmail.com','ABUJA','ABUJA','sauka airport road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-01 12:52:36',5,'705','2022-05-01 12:52:36','705'),(4263,'','1','197','TOTAL GRACE ','08134833391','0813433391','totalgrace@yahoo.com','ABUJA','ABUJA','karmajiji','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 10:51:52',5,'705','2022-05-28 10:51:52','705'),(4264,'','1','197','BUKASIA GAS','WUSE','08032895744','uchabopaul2004@gmail.com','ABUJA','ABUJA','wuse zone 5 junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-28 16:24:27',5,'705','2022-05-28 16:24:27','705'),(4265,'','1','197','SIIFT GAS','GWARINPA','08069604451','sales@swiftgas.com.ng','ABUJA','ABUJA','gwarinpa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-01 13:35:56',5,'705','2022-06-01 13:35:56','705'),(4266,'','1','197','ROCK  OIL AND GAS LIMETED','N N P C GHUZABE','08036390514','@gmail.com','ABUJA','ABUJA','NNPC OPPOSITE GHUZABE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-06 11:59:31',5,'705','2022-08-06 11:59:31','705'),(4267,'','1','197','AKPUGO','WUSE II','08036657389','@gmail.com','ABUJA','ABUJA','WUSEII','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-25 12:42:09',5,'705','2022-08-25 12:42:09','705'),(4268,'','1','197','SOK GAS','KWOI','08168881723','@gmail.com','ABUJA','ABUJA','KWALI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-15 14:17:18',5,'705','2022-12-15 14:17:18','705'),(4269,'','1','197','NAMSEC','ZONE 1','07034996497','@gmail.com','ABUJA','ABUJA','Z0NE 1 ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-22 12:41:57',5,'705','2022-12-22 12:41:57','705');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3005 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','197','1018',3004,'5','LPG NOZZLE ',565969.61,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258015 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','197',235481,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'705',0.00,0.00,'705','2021-10-30 18:30:32','705','2021-10-30 18:31:10',10,0),('1','197',235483,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'705',0.00,0.00,'705','2021-10-30 18:53:45','705','2021-10-30 18:54:04',10,0),('1','197',235484,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'705',0.00,0.00,'705','2021-10-30 18:59:14','705','2021-10-30 18:59:31',10,0),('1','197',235485,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'705',0.00,0.00,'705','2021-10-30 19:11:06','705','2021-10-30 19:11:25',10,0),('1','197',235700,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'705',0.00,0.00,'705','2021-10-31 18:57:39','705','2021-10-31 18:58:01',10,0),('1','197',235987,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-01 22:06:12','705','2021-11-01 22:06:35',10,0),('1','197',235992,'DAILY SHIFT SACOND SALES NEW PRICE','2021-11-01','2021-11-01 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-01 23:01:28','705','2021-11-01 23:02:35',10,0),('1','197',236452,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-03 18:54:24','705','2021-11-03 18:54:47',10,0),('1','197',236457,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-03 19:07:25','705','2021-11-03 19:07:49',10,0),('1','197',236460,'OPERATIONAL  LOST','2021-11-03','2021-11-03 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-03 22:08:53','705','2021-11-03 22:09:54',10,0),('1','197',236618,'DAILY SHIFT NEW STOCK','2021-11-04','2021-11-04 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-04 21:23:47','705','2021-11-04 21:24:09',10,0),('1','197',236770,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-05 21:44:39','705','2021-11-05 21:45:04',10,0),('1','197',237042,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-06 19:48:06','705','2021-11-06 19:49:10',10,0),('1','197',237231,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-07 18:48:54','705','2021-11-07 18:49:32',10,0),('1','197',237466,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-08 18:51:48','705','2021-11-08 18:52:11',10,0),('1','197',237648,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-09 21:51:35','705','2021-11-09 21:51:53',10,0),('1','197',237840,'OPERATIONAL LOSS','2021-11-09','2021-11-09 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-09 22:12:28','705','2021-11-09 22:12:45',10,0),('1','197',237976,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-10 21:17:41','705','2021-11-10 21:18:00',10,0),('1','197',238087,'DAILY SHIFT  NEW PRICE','2021-11-10','2021-11-10 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-10 21:24:29','705','2021-11-10 21:24:52',10,0),('1','197',238165,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-11 19:22:21','705','2021-11-11 19:22:45',10,0),('1','197',238453,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-12 21:51:39','705','2021-11-12 21:51:57',10,0),('1','197',238682,'0VERAGE','2021-11-13','2021-11-13 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-13 09:30:26','705','2021-11-13 09:30:48',10,0),('1','197',238706,'DAILY SHIFT 2ND SALES NEW STOCK','2021-11-13','2021-11-13 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-13 21:49:14','705','2021-11-13 21:50:05',10,0),('1','197',238916,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-14 19:20:53','705','2021-11-14 19:21:35',10,0),('1','197',239176,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-15 22:01:46','705','2021-11-15 22:02:04',10,0),('1','197',239270,'0PRATIONAL LOSS','2021-11-15','2021-11-15 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-15 22:08:13','705','2021-11-15 22:08:28',10,0),('1','197',239271,'DAILY SHIFT 2ND SALES NEW STOCK','2021-11-15','2021-11-15 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-15 22:18:25','705','2021-11-15 22:18:49',10,0),('1','197',239301,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-16 19:36:55','705','2021-11-16 19:37:12',10,0),('1','197',239574,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-17 19:34:57','705','2021-11-17 19:35:20',10,0),('1','197',239843,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-18 20:46:01','705','2021-11-18 20:46:20',10,0),('1','197',240040,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-19 15:13:48','705','2021-11-19 15:14:06',10,0),('1','197',240130,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-19 15:40:08','705','2021-11-19 15:40:33',10,0),('1','197',240131,'0VERAGE','2021-11-19','2021-11-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-19 15:42:10','705','2021-11-19 15:42:28',10,0),('1','197',240165,'DAILY SHIFT 2ND SALES NEW STOCK NEW PRICE','2021-11-19','2021-11-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-19 21:03:01','705','2021-11-19 21:03:16',10,0),('1','197',240241,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-20 21:18:37','705','2021-11-20 21:19:07',10,0),('1','197',240538,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-22 09:45:18','705','2021-11-22 09:45:53',10,0),('1','197',240779,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-22 19:06:05','705','2021-11-22 19:06:24',10,0),('1','197',241074,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-23 21:08:17','705','2021-11-23 21:08:32',10,0),('1','197',241188,'0VERAGE','2021-11-23','2021-11-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-23 21:14:32','705','2021-11-23 21:14:51',10,0),('1','197',241192,'DAILY SHIFT 2ND SALES NEW STOCK','2021-11-23','2021-11-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-23 21:47:44','705','2021-11-23 21:48:01',10,0),('1','197',241194,'DAILY SHIFT 3RD SALES NEW PRICE','2021-11-23','2021-11-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-23 22:02:10','705','2021-11-23 22:02:28',10,0),('1','197',241350,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-24 18:34:34','705','2021-11-24 18:34:52',10,0),('1','197',241675,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-25 18:29:27','705','2021-11-25 18:29:54',10,0),('1','197',241873,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-26 20:11:39','705','2021-11-26 20:12:09',10,0),('1','197',241999,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-27 11:09:57','705','2021-11-27 11:10:41',10,0),('1','197',242067,'0PRATIONAL LOSS','2021-11-27','2021-11-27 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-27 11:17:45','705','2021-11-27 11:18:04',10,0),('1','197',242068,'DAILY SHIFT 2ND SALES NEW STOCK','2021-11-27','2021-11-27 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-27 20:20:21','705','2021-11-27 20:20:43',10,0),('1','197',242238,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-28 19:43:42','705','2021-11-28 19:44:21',10,0),('1','197',242500,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-29 20:02:14','705','2021-11-29 20:03:32',10,0),('1','197',242744,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'705',0.00,0.00,'705','2021-11-30 20:33:15','705','2021-11-30 20:33:50',10,0),('1','197',242973,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-01 18:27:24','705','2021-12-01 18:27:46',10,0),('1','197',243076,'0VERAGE','2021-12-01','2021-12-01 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-01 18:34:30','705','2021-12-01 18:34:50',10,0),('1','197',243176,'DAILY SHIFT NEW STOCK','2021-12-02','2021-12-02 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-02 19:39:55','705','2021-12-02 19:40:42',10,0),('1','197',243392,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-03 19:24:57','705','2021-12-03 19:25:36',10,0),('1','197',243615,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-04 19:46:25','705','2021-12-04 19:47:58',10,0),('1','197',243847,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-05 10:53:54','705','2021-12-05 10:54:18',10,0),('1','197',243914,'0VERAGE','2021-12-05','2021-12-05 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-05 11:05:10','705','2021-12-05 11:05:36',10,0),('1','197',243918,'DAILY SHIFT 2ND SALES (NEW STOCK)','2021-12-05','2021-12-05 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-05 19:15:24','705','2021-12-05 19:15:49',10,0),('1','197',244050,'DAILY SALES','2021-12-06','2021-12-06 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-06 19:11:13','705','2021-12-06 19:11:48',10,0),('1','197',244317,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-07 18:45:10','705','2021-12-07 18:45:53',10,0),('1','197',244532,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-08 18:32:41','705','2021-12-08 18:33:29',10,0),('1','197',244765,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-09 19:02:35','705','2021-12-09 19:03:29',10,0),('1','197',245053,'0PERATIONAL LOSS','2021-12-10','2021-12-10 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-10 09:32:56','705','2021-12-10 09:33:30',10,0),('1','197',245057,'DAILY  SHIFT NEW STOCK NEW PRICE','2021-12-10','2021-12-10 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-10 19:00:27','705','2021-12-10 19:01:10',10,0),('1','197',245227,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-11 19:03:30','705','2021-12-11 19:04:01',10,0),('1','197',245447,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-12 18:54:48','705','2021-12-12 18:55:22',10,0),('1','197',245686,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-13 19:29:52','705','2021-12-13 19:30:28',10,0),('1','197',245997,'DAILY SHIFT NEW PRICE','2021-12-14','2021-12-14 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-14 16:16:25','705','2021-12-14 16:16:58',10,0),('1','197',246118,'0VERAGE','2021-12-14','2021-12-14 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-14 18:31:17','705','2021-12-14 18:31:49',10,0),('1','197',246151,' DAILY SHIFT 2ND SALES NEW STOCK','2021-12-14','2021-12-14 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-14 20:27:09','705','2021-12-14 20:27:34',10,0),('1','197',246212,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-15 18:28:44','705','2021-12-15 18:29:04',10,0),('1','197',246478,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-16 19:06:17','705','2021-12-16 19:07:33',10,0),('1','197',246750,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-17 18:37:03','705','2021-12-17 18:37:33',10,0),('1','197',246961,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-18 18:27:43','705','2021-12-18 18:29:32',10,0),('1','197',247167,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-19 09:17:12','705','2021-12-19 09:17:29',10,0),('1','197',247235,'0PERATIONAL LOSS','2021-12-19','2021-12-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-19 09:27:28','705','2021-12-19 09:27:46',10,0),('1','197',247238,' DAILY SHIFT 2ND SALES NEW STOCK','2021-12-19','2021-12-19 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-19 18:40:56','705','2021-12-19 18:41:20',10,0),('1','197',247413,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-20 19:41:29','705','2021-12-20 19:43:22',10,0),('1','197',247672,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-21 10:26:16','705','2021-12-21 10:26:53',10,0),('1','197',247747,'DAILY SHIFT NEW PRICE 2ND SALES','2021-12-21','2021-12-21 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-21 19:19:43','705','2021-12-21 19:20:20',10,0),('1','197',247922,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-22 19:40:41','705','2021-12-22 19:41:21',10,0),('1','197',248185,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-23 12:02:10','705','2021-12-23 12:02:40',10,0),('1','197',248266,'0PERATIONAL LOSS','2021-12-23','2021-12-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-23 12:08:34','705','2021-12-23 12:08:50',10,0),('1','197',248268,' DAILY SHIFT 2ND SALES NEW STOCK','2021-12-23','2021-12-23 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-23 20:26:03','705','2021-12-23 20:26:22',10,0),('1','197',248427,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-24 19:20:26','705','2021-12-24 19:21:34',10,0),('1','197',248652,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-25 18:40:45','705','2021-12-25 18:41:29',10,0),('1','197',248888,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-26 15:38:39','705','2021-12-26 15:39:31',10,0),('1','197',249023,'DAILY SHIFT 2ND SALES NEW PRICE','2021-12-26','2021-12-26 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-27 06:45:10','705','2021-12-27 06:45:31',10,0),('1','197',249135,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-27 18:22:30','705','2021-12-27 18:22:54',10,0),('1','197',249313,'0PERATIONAL LOSS','2021-12-27','2021-12-27 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-27 20:23:48','705','2021-12-27 20:24:47',10,0),('1','197',249372,'DAILY SHIFT NEW STOCK','2021-12-28','2021-12-28 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-28 18:44:29','705','2021-12-28 18:44:59',10,0),('1','197',249608,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-29 19:10:08','705','2021-12-29 19:10:56',10,0),('1','197',249855,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-31 03:35:45','705','2021-12-31 03:36:32',10,0),('1','197',250134,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'705',0.00,0.00,'705','2021-12-31 19:34:07','705','2021-12-31 19:34:57',10,0),('1','197',250358,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-01 19:32:51','705','2022-01-01 19:33:16',10,0),('1','197',250607,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-02 18:54:37','705','2022-01-02 18:55:34',10,0),('1','197',250751,'0PERATIONAL LOSS','2022-01-02','2022-01-02 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-02 19:26:08','705','2022-01-02 19:26:57',10,0),('1','197',250760,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-02 21:15:44','705','2022-01-02 21:16:20',10,0),('1','197',250840,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-03 19:56:10','705','2022-01-03 19:57:36',10,0),('1','197',251099,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-04 20:29:07','705','2022-01-04 20:29:44',10,0),('1','197',251313,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-05 20:21:49','705','2022-01-05 20:23:20',10,0),('1','197',251524,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-06 20:08:46','705','2022-01-06 20:09:34',10,0),('1','197',251767,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-07 22:23:36','705','2022-01-07 22:24:04',10,0),('1','197',252007,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-08 11:29:21','705','2022-01-08 11:34:23',10,0),('1','197',252084,'0PERATIONAL LOSS','2022-01-08','2022-01-08 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-08 12:08:13','705','2022-01-08 12:08:51',10,0),('1','197',252090,' DAILY SHIFT 2ND SALES NEW STOCK','2022-01-08','2022-01-08 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-08 21:12:13','705','2022-01-08 21:12:57',10,0),('1','197',252252,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-09 19:58:49','705','2022-01-09 19:59:16',10,0),('1','197',252505,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-10 20:41:01','705','2022-01-10 20:42:12',10,0),('1','197',252732,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-11 20:23:10','705','2022-01-11 20:23:57',10,0),('1','197',252980,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-12 20:16:35','705','2022-01-12 20:17:07',10,0),('1','197',253225,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-13 13:38:41','705','2022-01-13 13:39:10',10,0),('1','197',253349,'0PERATIONAL LOSS','2022-01-13','2022-01-13 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-13 13:44:14','705','2022-01-13 13:44:32',10,0),('1','197',253354,'DAILY  SHIFT NEW STOCK NEW PRICE','2022-01-13','2022-01-13 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-13 20:36:24','705','2022-01-13 20:37:17',10,0),('1','197',253489,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-14 19:46:49','705','2022-01-14 19:48:39',10,0),('1','197',253729,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-15 20:04:58','705','2022-01-15 20:05:23',10,0),('1','197',253976,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-16 19:49:16','705','2022-01-16 19:49:38',10,0),('1','197',254206,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-17 13:46:19','705','2022-01-17 13:46:35',10,0),('1','197',254327,'0PERATIONAL LOSS','2022-01-17','2022-01-17 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-17 13:55:26','705','2022-01-17 13:56:04',10,0),('1','197',254329,' DAILY SHIFT 2ND SALES NEW STOCK','2022-01-17','2022-01-17 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-17 20:41:42','705','2022-01-17 20:42:17',10,0),('1','197',254458,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-18 22:22:10','705','2022-01-18 22:22:56',10,0),('1','197',254719,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-19 19:53:16','705','2022-01-19 19:54:39',10,0),('1','197',254964,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-20 20:48:07','705','2022-01-20 20:49:15',10,0),('1','197',255200,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-21 11:24:22','705','2022-01-21 11:24:56',10,0),('1','197',255285,'0VERAGE','2022-01-21','2022-01-21 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-21 15:16:40','705','2022-01-21 15:17:12',10,0),('1','197',255342,' DAILY SHIFT 2ND SALES NEW STOCK','2022-01-21','2022-01-21 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-21 20:34:52','705','2022-01-21 20:35:34',10,0),('1','197',255472,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-22 21:20:02','705','2022-01-22 21:23:18',10,0),('1','197',255721,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-24 11:07:30','705','2022-01-24 11:07:49',10,0),('1','197',256049,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-24 20:22:50','705','2022-01-24 20:23:39',10,0),('1','197',256332,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-25 17:44:23','705','2022-01-25 17:44:42',10,0),('1','197',256409,'0PERATIONAL LOSS','2022-01-25','2022-01-25 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-25 18:00:47','705','2022-01-25 18:01:13',10,0),('1','197',256482,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-26 20:18:29','705','2022-01-26 20:19:04',10,0),('1','197',256741,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-27 21:46:30','705','2022-01-27 21:47:12',10,0),('1','197',257189,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-28 21:02:13','705','2022-01-28 21:03:36',10,0),('1','197',257249,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-29 20:25:35','705','2022-01-29 20:26:23',10,0),('1','197',257437,'0PERATIONAL LOSS','2022-01-29','2022-01-29 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-29 20:33:40','705','2022-01-29 20:34:11',10,0),('1','197',257444,' DAILY SHIFT 2ND SALES NEW STOCK','2022-01-29','2022-01-29 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-29 21:13:14','705','2022-01-29 21:13:42',10,0),('1','197',257492,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-30 18:59:30','705','2022-01-30 18:59:55',10,0),('1','197',257493,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'705',0.00,0.00,'705','2022-01-31 20:45:30','705','2022-01-31 20:45:51',10,0),('1','197',257494,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-01 23:11:00','705','2022-02-01 23:11:15',10,0),('1','197',257495,'0PERATIONAL LOSS','2022-02-01','2022-02-01 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-01 23:15:42','705','2022-02-01 23:16:00',10,0),('1','197',257496,' DAILY SHIFT 2ND SALES NEW STOCK','2022-02-01','2022-02-01 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-01 23:26:10','705','2022-02-01 23:26:26',10,0),('1','197',257497,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-02 20:08:57','705','2022-02-02 20:09:13',10,0),('1','197',257498,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-04 08:31:21','705','2022-02-04 08:31:39',10,0),('1','197',257499,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-04 20:49:50','705','2022-02-04 20:50:14',10,0),('1','197',257500,'0PERATIONAL LOSS','2022-02-04','2022-02-04 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-04 21:13:15','705','2022-02-04 21:13:45',10,0),('1','197',257501,' DAILY SHIFT 2ND SALES NEW STOCK','2022-02-04','2022-02-04 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-04 21:26:08','705','2022-02-04 21:27:10',10,0),('1','197',257502,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-05 20:24:19','705','2022-02-05 20:24:35',10,0),('1','197',257503,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-07 08:01:46','705','2022-02-07 08:02:13',10,0),('1','197',257504,'0PERATIONAL LOSS','2022-02-07','2022-02-07 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-07 08:13:30','705','2022-02-07 08:13:47',10,0),('1','197',257505,'DAILY SHIFT NEW STOCK','2022-02-07','2022-02-07 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-07 21:36:51','705','2022-02-07 21:38:06',10,0),('1','197',257506,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-08 20:49:09','705','2022-02-08 20:49:41',10,0),('1','197',257507,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-09 17:54:46','705','2022-02-09 17:55:03',10,0),('1','197',257508,'0PERATIONAL LOSS','2022-02-09','2022-02-09 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-09 18:24:10','705','2022-02-09 18:24:28',10,0),('1','197',257509,'DAILY SHIFT 2ND SALES NEW STOCK','2022-02-09','2022-02-09 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-09 22:10:27','705','2022-02-09 22:11:13',10,0),('1','197',257510,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-10 22:32:46','705','2022-02-10 22:33:10',10,0),('1','197',257511,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-11 22:50:53','705','2022-02-11 22:51:24',10,0),('1','197',257512,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-12 21:52:37','705','2022-02-12 21:53:41',10,0),('1','197',257513,'0PERATIONAL LOSS','2022-02-12','2022-02-12 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-13 07:29:55','705','2022-02-13 07:30:13',10,0),('1','197',257514,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-13 19:46:23','705','2022-02-13 19:46:50',10,0),('1','197',257515,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-14 21:17:49','705','2022-02-14 21:18:08',10,0),('1','197',257516,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-15 12:08:39','705','2022-02-15 12:08:55',10,0),('1','197',257517,'0PERATIONAL LOSS','2022-02-15','2022-02-15 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-15 12:13:08','705','2022-02-15 12:19:03',10,0),('1','197',257518,' DAILY SHIFT 2ND SALES NEW STOCK','2022-02-15','2022-02-15 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-16 08:40:54','705','2022-02-16 08:41:15',10,0),('1','197',257519,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-17 00:24:54','705','2022-02-17 00:25:19',10,0),('1','197',257520,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-17 20:12:13','705','2022-02-17 20:12:36',10,0),('1','197',257521,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-19 07:24:26','705','2022-02-19 07:24:42',10,0),('1','197',257522,'0VERAGE','2022-02-19','2022-02-19 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-19 07:36:19','705','2022-02-19 07:36:40',10,0),('1','197',257523,'DAILY SHIFT NEW STOCK','2022-02-19','2022-02-19 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-20 10:02:28','705','2022-02-20 10:02:49',10,0),('1','197',257524,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-20 19:55:35','705','2022-02-20 20:01:47',10,0),('1','197',257525,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-21 21:32:15','705','2022-02-21 21:32:57',10,0),('1','197',257526,'0VERAGE','2022-02-21','2022-02-21 00:00:00',NULL,'705',0.00,0.00,'705','2022-02-22 00:51:46','705','2022-02-22 00:54:03',10,0),('1','197',257527,'DAILY SHIFT NEW STOCK','2022-02-22','2022-02-22 08:03:40','2022-02-23 08:03:40','705',0.00,0.00,'705','2022-02-22 19:58:57','705','2022-02-22 19:59:15',10,0),('1','197',257528,'DAILY SHIFT','2022-02-23','2022-02-23 07:48:08','2022-02-24 07:48:08','705',0.00,0.00,'705','2022-02-24 00:48:00','705','2022-02-24 00:48:21',10,0),('1','197',257529,'DAILY SHIFT','2022-02-24','2022-02-24 07:18:07','2022-02-25 07:18:07','705',0.00,0.00,'705','2022-02-24 19:51:54','705','2022-02-24 19:52:09',10,0),('1','197',257530,'DAILY SHIFT','2022-02-25','2022-02-25 11:27:42','2022-02-26 11:27:42','705',0.00,0.00,'705','2022-02-25 17:04:16','705','2022-02-25 17:04:41',10,0),('1','197',257531,'0PERATIONAL LOSS','2022-02-25','2022-02-25 17:06:30','2022-02-26 17:06:30','705',0.00,0.00,'705','2022-02-25 17:11:15','705','2022-02-25 17:11:30',10,0),('1','197',257532,'DAILY SHIFT NEW STOCK','2022-02-26','2022-02-26 07:49:51','2022-02-27 07:49:51','705',0.00,0.00,'705','2022-02-26 20:17:14','705','2022-02-26 20:17:49',10,0),('1','197',257533,'DAILY SHIFT','2022-02-27','2022-02-27 11:24:12','2022-02-28 11:24:12','705',0.00,0.00,'705','2022-02-27 19:21:25','705','2022-02-27 19:21:46',10,0),('1','197',257534,'DAILY SHIFT','2022-02-28','2022-02-28 08:14:32','2022-03-01 08:14:32','705',0.00,0.00,'705','2022-02-28 17:28:34','705','2022-02-28 17:28:48',10,0),('1','197',257535,' DAILY SHIFT 2ND SALES NEW STOCK','2022-02-28','2022-02-28 17:30:17','2022-03-01 17:30:17','705',0.00,0.00,'705','2022-02-28 21:28:36','705','2022-02-28 21:28:54',10,0),('1','197',257536,'DAILY SHIFT','2022-03-01','2022-03-01 09:32:33','2022-03-02 09:32:33','705',0.00,0.00,'705','2022-03-01 20:50:45','705','2022-03-01 20:51:03',10,0),('1','197',257537,'DAILY SHIFT','2022-03-02','2022-03-02 09:02:01','2022-03-03 09:02:01','705',0.00,0.00,'705','2022-03-02 18:01:35','705','2022-03-02 18:02:38',10,0),('1','197',257538,'0PERATIONAL LOSS','2022-03-02','2022-03-02 18:04:21','2022-03-03 18:04:21','705',0.00,0.00,'705','2022-03-03 07:25:20','705','2022-03-03 07:25:43',10,0),('1','197',257539,'DAILY SHIFT NEW STOCK','2022-03-03','2022-03-03 07:32:16','2022-03-04 07:32:16','705',0.00,0.00,'705','2022-03-03 20:11:44','705','2022-03-03 20:12:01',10,0),('1','197',257540,'DAILY SHIFT','2022-03-04','2022-03-04 08:30:12','2022-03-05 08:30:12','705',0.00,0.00,'705','2022-03-04 20:26:50','705','2022-03-04 20:27:07',10,0),('1','197',257541,'DAILY SHIFT','2022-03-05','2022-03-05 09:25:56','2022-03-06 09:25:56','705',0.00,0.00,'705','2022-03-05 13:39:31','705','2022-03-05 13:39:48',10,0),('1','197',257542,'0PERATIONAL LOSS','2022-03-05','2022-03-05 13:42:33','2022-03-06 13:42:33','705',0.00,0.00,'705','2022-03-05 13:47:16','705','2022-03-05 13:47:31',10,0),('1','197',257543,' DAILY SHIFT 2ND SALES NEW STOCK','2022-03-05','2022-03-05 13:47:54','2022-03-06 13:47:54','705',0.00,0.00,'705','2022-03-05 21:03:38','705','2022-03-05 21:03:59',10,0),('1','197',257544,'DAILY SHIFT','2022-03-06','2022-03-06 08:25:15','2022-03-07 08:25:15','705',0.00,0.00,'705','2022-03-06 19:45:15','705','2022-03-06 19:45:36',10,0),('1','197',257545,'DAILY SHIFT','2022-03-07','2022-03-07 07:56:32','2022-03-08 07:56:32','705',0.00,0.00,'705','2022-03-07 20:09:48','705','2022-03-07 20:10:05',10,0),('1','197',257546,'DAILY SHIFT','2022-03-08','2022-03-08 07:58:05','2022-03-09 07:58:05','705',0.00,0.00,'705','2022-03-09 00:29:49','705','2022-03-09 00:31:39',10,0),('1','197',257547,'0PERATIONAL LOSS','2022-03-09','2022-03-09 00:34:19','2022-03-10 00:34:19','705',0.00,0.00,'705','2022-03-09 00:41:08','705','2022-03-09 00:41:38',10,0),('1','197',257548,'DAILY  SHIFT NEW STOCK NEW PRICE','2022-03-09','2022-03-09 10:33:00','2022-03-10 10:33:00','705',0.00,0.00,'705','2022-03-09 21:00:47','705','2022-03-09 21:01:21',10,0),('1','197',257549,'DAILY SHIFT','2022-03-10','2022-03-10 10:48:06','2022-03-11 10:48:06','705',0.00,0.00,'705','2022-03-10 19:53:10','705','2022-03-10 19:53:28',10,0),('1','197',257550,'DAILY SHIFT','2022-03-11','2022-03-11 09:51:23','2022-03-12 09:51:23','705',0.00,0.00,'705','2022-03-11 20:19:19','705','2022-03-11 20:19:35',10,0),('1','197',257551,'DAILY SHIFT','2022-03-12','2022-03-12 11:40:57','2022-03-13 11:40:57','705',0.00,0.00,'705','2022-03-13 12:24:51','705','2022-03-13 12:25:19',10,0),('1','197',257552,'DAILY SHIFT','2022-03-13','2022-03-13 12:26:03','2022-03-14 12:26:03','705',0.00,0.00,'705','2022-03-13 20:15:40','705','2022-03-13 20:17:07',10,0),('1','197',257553,'DAILY SHIFT','2022-03-14','2022-03-14 10:18:30','2022-03-15 10:18:30','705',0.00,0.00,'705','2022-03-14 23:55:35','705','2022-03-14 23:55:55',10,0),('1','197',257554,'DAILY SHIFT','2022-03-15','2022-03-15 00:41:07','2022-03-16 00:41:07','705',0.00,0.00,'705','2022-03-15 12:23:09','705','2022-03-15 12:23:31',10,0),('1','197',257555,'0VERAGE','2022-03-15','2022-03-15 20:59:38','2022-03-16 20:59:38','705',0.00,0.00,'705','2022-03-15 21:11:00','705','2022-03-15 21:11:17',10,0),('1','197',257556,' DAILY SHIFT 2ND SALES NEW STOCK','2022-03-15','2022-03-15 22:06:47','2022-03-16 22:06:47','705',0.00,0.00,'705','2022-03-15 22:27:29','705','2022-03-15 22:27:52',10,0),('1','197',257557,'DAILY SHIFT','2022-03-16','2022-03-16 08:45:34','2022-03-17 08:45:34','705',0.00,0.00,'705','2022-03-16 20:43:33','705','2022-03-16 20:43:49',10,0),('1','197',257558,'DAILY SHIFT','2022-03-17','2022-03-17 08:13:43','2022-03-18 08:13:43','705',0.00,0.00,'705','2022-03-17 19:43:56','705','2022-03-17 19:44:11',10,0),('1','197',257559,'DAILY SHIFT','2022-03-18','2022-03-18 08:15:26','2022-03-19 08:15:26','705',0.00,0.00,'705','2022-03-18 19:57:43','705','2022-03-18 19:58:06',10,0),('1','197',257560,'DAILY SHIFT','2022-03-19','2022-03-19 08:07:26','2022-03-20 08:07:26','705',0.00,0.00,'705','2022-03-19 20:15:07','705','2022-03-19 20:15:25',10,0),('1','197',257561,'DAILY SHIFT','2022-03-20','2022-03-20 08:40:11','2022-03-21 08:40:11','705',0.00,0.00,'705','2022-03-21 00:41:10','705','2022-03-21 00:41:28',10,0),('1','197',257562,'0VERAGE','2022-03-21','2022-03-21 00:46:42','2022-03-22 00:46:42','705',0.00,0.00,'705','2022-03-21 00:52:37','705','2022-03-21 00:52:54',10,0),('1','197',257563,'DAILY SHIFT NEW STOCK','2022-03-21','2022-03-21 12:01:51','2022-03-22 12:01:51','705',0.00,0.00,'705','2022-03-22 00:48:37','705','2022-03-22 00:48:54',10,0),('1','197',257564,'DAILY SHIFT','2022-03-22','2022-03-22 08:17:53','2022-03-23 08:17:53','705',0.00,0.00,'705','2022-03-22 23:55:41','705','2022-03-22 23:55:58',10,0),('1','197',257565,'DAILY SHIFT','2022-03-23','2022-03-23 07:57:10','2022-03-24 07:57:10','705',0.00,0.00,'705','2022-03-24 00:17:24','705','2022-03-24 00:18:07',10,0),('1','197',257566,'0PERATIONAL LOSS','2022-03-24','2022-03-24 07:54:48','2022-03-25 07:54:48','705',0.00,0.00,'705','2022-03-24 08:24:15','705','2022-03-24 08:24:35',10,0),('1','197',257567,'DAILY SHIFT NEW STOCK','2022-03-24','2022-03-24 08:29:29','2022-03-25 08:29:29','705',0.00,0.00,'705','2022-03-24 20:03:00','705','2022-03-24 20:03:26',10,0),('1','197',257568,'DAILY SHIFT','2022-03-25','2022-03-25 07:40:48','2022-03-26 07:40:48','705',0.00,0.00,'705','2022-03-25 20:21:00','705','2022-03-25 20:21:19',10,0),('1','197',257569,'DAILY SHIFT','2022-03-26','2022-03-26 07:35:24','2022-03-27 07:35:24','705',0.00,0.00,'705','2022-03-26 20:19:01','705','2022-03-26 20:20:34',10,0),('1','197',257570,'DAILY SHIFT','2022-03-27','2022-03-27 07:49:54','2022-03-28 07:49:54','705',0.00,0.00,'705','2022-03-27 10:14:24','705','2022-03-27 10:14:41',10,0),('1','197',257571,'DAILY SHIFT 2ND SALES NEW PRICE','2022-03-27','2022-03-27 10:16:45','2022-03-28 10:16:45','705',0.00,0.00,'705','2022-03-27 17:27:14','705','2022-03-27 17:27:47',10,0),('1','197',257572,'0VERAGE','2022-03-27','2022-03-27 17:51:26','2022-03-28 17:51:26','705',0.00,0.00,'705','2022-03-27 17:52:53','705','2022-03-27 17:53:09',10,0),('1','197',257573,'DAILY SHIFT 3RD SALES NEW STOCK','2022-03-27','2022-03-27 18:00:38','2022-03-28 18:00:38','705',0.00,0.00,'705','2022-03-28 01:37:04','705','2022-03-28 01:37:57',10,0),('1','197',257574,'DAILY SHIFT','2022-03-28','2022-03-28 08:03:51','2022-03-29 08:03:51','705',0.00,0.00,'705','2022-03-28 23:27:43','705','2022-03-28 23:28:00',10,0),('1','197',257575,'DAILY SHIFT','2022-03-29','2022-03-29 07:55:06','2022-03-30 07:55:06','705',0.00,0.00,'705','2022-03-29 19:56:06','705','2022-03-29 19:56:36',10,0),('1','197',257576,'DAILY SHIFT','2022-03-30','2022-03-30 08:03:31','2022-03-31 08:03:31','705',0.00,0.00,'705','2022-03-30 20:10:44','705','2022-03-30 20:11:06',10,0),('1','197',257577,'DAILY SHIFT','2022-03-31','2022-03-31 08:13:54','2022-04-01 08:13:54','705',0.00,0.00,'705','2022-03-31 19:48:13','705','2022-03-31 19:48:42',10,0),('1','197',257578,'DAILY SHIFT','2022-04-01','2022-04-01 10:37:32','2022-04-02 10:37:32','705',0.00,0.00,'705','2022-04-01 20:45:38','705','2022-04-01 20:45:54',10,0),('1','197',257579,'DAILY SHIFT','2022-04-02','2022-04-02 07:32:40','2022-04-03 07:32:40','705',0.00,0.00,'705','2022-04-02 14:54:40','705','2022-04-02 14:54:56',10,0),('1','197',257580,'0PERATIONAL LOSS','2022-04-02','2022-04-02 14:55:29','2022-04-03 14:55:29','705',0.00,0.00,'705','2022-04-02 14:59:48','705','2022-04-02 15:00:12',10,0),('1','197',257581,' DAILY SHIFT 2ND SALES NEW STOCK','2022-04-02','2022-04-02 15:01:00','2022-04-03 15:01:00','705',0.00,0.00,'705','2022-04-02 21:03:24','705','2022-04-02 21:03:45',10,0),('1','197',257582,'DAILY SHIFT','2022-04-03','2022-04-03 07:48:28','2022-04-04 07:48:28','705',0.00,0.00,'705','2022-04-03 23:59:49','705','2022-04-04 00:00:07',10,0),('1','197',257583,'DAILY SHIFT','2022-04-04','2022-04-04 09:17:10','2022-04-05 09:17:10','705',0.00,0.00,'705','2022-04-04 21:11:21','705','2022-04-04 21:11:36',10,0),('1','197',257584,'DAILY SHIFT','2022-04-05','2022-04-05 07:22:10','2022-04-06 07:22:10','705',0.00,0.00,'705','2022-04-05 17:23:05','705','2022-04-05 17:23:23',10,0),('1','197',257585,'0PERATIONAL LOSS','2022-04-05','2022-04-05 17:25:49','2022-04-06 17:25:49','705',0.00,0.00,'705','2022-04-05 17:29:44','705','2022-04-05 17:30:02',10,0),('1','197',257586,' DAILY SHIFT 2ND SALES NEW STOCK','2022-04-05','2022-04-05 17:30:20','2022-04-06 17:30:20','705',0.00,0.00,'705','2022-04-06 19:48:51','705','2022-04-06 19:49:06',10,0),('1','197',257587,'DAILY SHIFT','2022-04-07','2022-04-07 14:27:10','2022-04-08 14:27:10','705',0.00,0.00,'705','2022-04-07 14:35:36','705','2022-04-07 14:36:07',10,0),('1','197',257588,'DAILY SHIFT','2022-04-07','2022-04-07 14:36:36','2022-04-08 14:36:36','705',0.00,0.00,'705','2022-04-07 23:21:43','705','2022-04-07 23:22:05',10,0),('1','197',257589,'DAILY SHIFT','2022-04-08','2022-04-08 08:24:25','2022-04-09 08:24:25','705',0.00,0.00,'705','2022-04-08 20:08:31','705','2022-04-08 20:08:45',10,0),('1','197',257590,'DAILY SHIFT','2022-04-09','2022-04-09 08:34:54','2022-04-10 08:34:54','705',0.00,0.00,'705','2022-04-09 23:34:43','705','2022-04-09 23:35:01',10,0),('1','197',257591,'DAILY SHIFT','2022-04-10','2022-04-10 08:18:26','2022-04-11 08:18:26','705',0.00,0.00,'705','2022-04-10 13:48:11','705','2022-04-10 13:48:44',10,0),('1','197',257592,'0PERATIONAL LOSS','2022-04-10','2022-04-10 13:49:27','2022-04-11 13:49:27','705',0.00,0.00,'705','2022-04-10 13:58:27','705','2022-04-10 13:58:52',10,0),('1','197',257593,'DAILY SHIFT 2ND SALES NEW STOCK','2022-04-10','2022-04-10 15:53:18','2022-04-11 15:53:18','705',0.00,0.00,'705','2022-04-10 20:13:22','705','2022-04-10 20:13:44',10,0),('1','197',257594,'DAILY SHIFT','2022-04-11','2022-04-11 07:36:17','2022-04-12 07:36:17','705',0.00,0.00,'705','2022-04-11 23:29:58','705','2022-04-11 23:30:15',10,0),('1','197',257595,'DAILY SHIFT','2022-04-12','2022-04-12 09:55:40','2022-04-13 09:55:40','705',0.00,0.00,'705','2022-04-12 20:02:49','705','2022-04-12 20:03:07',10,0),('1','197',257596,'DAILY SHIFT','2022-04-13','2022-04-13 07:38:45','2022-04-14 07:38:45','705',0.00,0.00,'705','2022-04-13 21:48:27','705','2022-04-13 21:48:43',10,0),('1','197',257597,'DAILY SHIFT','2022-04-14','2022-04-14 09:26:41','2022-04-15 09:26:41','705',0.00,0.00,'705','2022-04-14 20:23:56','705','2022-04-14 20:24:16',10,0),('1','197',257598,'DAILY SHIFT','2022-04-15','2022-04-15 09:15:27','2022-04-16 09:15:27','705',0.00,0.00,'705','2022-04-15 23:40:04','705','2022-04-15 23:40:22',10,0),('1','197',257599,'0VERAGE','2022-04-16','2022-04-16 08:46:19','2022-04-17 08:46:19','705',0.00,0.00,'705','2022-04-16 08:53:41','705','2022-04-16 08:54:00',10,0),('1','197',257600,'DAILY SHIFT NEW STOCK','2022-04-17','2022-04-17 00:12:38','2022-04-18 00:12:38','705',0.00,0.00,'705','2022-04-17 00:14:39','705','2022-04-17 00:14:58',10,0),('1','197',257601,'DAILY SHIFT','2022-04-17','2022-04-17 11:06:40','2022-04-18 11:06:40','705',0.00,0.00,'705','2022-04-17 18:52:26','705','2022-04-17 18:52:48',10,0),('1','197',257602,'DAILY SHIFT','2022-04-18','2022-04-18 08:49:51','2022-04-19 08:49:51','705',0.00,0.00,'705','2022-04-18 21:44:45','705','2022-04-18 21:45:03',10,0),('1','197',257603,'DAILY SHIFT','2022-04-19','2022-04-19 07:47:20','2022-04-20 07:47:20','705',0.00,0.00,'705','2022-04-19 23:18:50','705','2022-04-19 23:19:30',10,0),('1','197',257604,'DAILY SHIFT','2022-04-20','2022-04-20 15:05:45','2022-04-21 15:05:45','705',0.00,0.00,'705','2022-04-20 22:00:22','705','2022-04-20 22:00:45',10,0),('1','197',257605,'DAILY SHIFT','2022-04-21','2022-04-21 09:30:18','2022-04-22 09:30:18','705',0.00,0.00,'705','2022-04-21 23:59:11','705','2022-04-21 23:59:25',10,0),('1','197',257606,'DAILY SHIFT','2022-04-22','2022-04-22 08:05:55','2022-04-23 08:05:55','705',0.00,0.00,'705','2022-04-22 18:08:00','705','2022-04-22 18:08:24',10,0),('1','197',257607,'0PERATIONAL LOSS','2022-04-22','2022-04-22 18:08:41','2022-04-23 18:08:41','705',0.00,0.00,'705','2022-04-22 18:20:26','705','2022-04-22 18:20:40',10,0),('1','197',257608,'DAILY SHIFT NEW STOCK','2022-04-23','2022-04-23 08:28:01','2022-04-24 08:28:01','705',0.00,0.00,'705','2022-04-23 22:22:15','705','2022-04-23 22:25:57',10,0),('1','197',257609,'DAILY SHIFT','2022-04-24','2022-04-24 09:24:21','2022-04-25 09:24:21','705',0.00,0.00,'705','2022-04-24 20:28:20','705','2022-04-24 20:29:06',10,0),('1','197',257610,'DAILY SHIFT','2022-04-25','2022-04-25 07:29:15','2022-04-26 07:29:15','705',0.00,0.00,'705','2022-04-26 00:13:00','705','2022-04-26 00:13:19',10,0),('1','197',257611,'DAILY SHIFT','2022-04-26','2022-04-26 07:52:56','2022-04-27 07:52:56','705',0.00,0.00,'705','2022-04-26 17:37:39','705','2022-04-26 17:37:55',10,0),('1','197',257612,'0PERATIONAL LOSS','2022-04-26','2022-04-26 17:38:56','2022-04-27 17:38:56','705',0.00,0.00,'705','2022-04-26 17:43:32','705','2022-04-26 17:43:54',10,0),('1','197',257613,'DAILY SHIFT NEW STOCK','2022-04-27','2022-04-27 09:25:14','2022-04-28 09:25:14','705',0.00,0.00,'705','2022-04-27 20:07:09','705','2022-04-27 20:07:44',10,0),('1','197',257614,'DAILY SHIFT','2022-04-28','2022-04-28 10:57:50','2022-04-29 10:57:50','705',0.00,0.00,'705','2022-04-28 20:13:21','705','2022-04-28 20:13:43',10,0),('1','197',257615,'DAILY SHIFT','2022-04-29','2022-04-29 12:23:14','2022-04-30 12:23:14','705',0.00,0.00,'705','2022-04-30 01:01:02','705','2022-04-30 01:01:20',10,0),('1','197',257616,'DAILY SHIFT','2022-04-30','2022-04-30 07:24:39','2022-05-01 07:24:39','705',0.00,0.00,'705','2022-04-30 15:16:57','705','2022-04-30 15:17:11',10,0),('1','197',257617,'0PERATIONAL LOSS','2022-04-30','2022-04-30 15:21:19','2022-05-01 15:21:19','705',0.00,0.00,'705','2022-04-30 15:30:58','705','2022-04-30 15:31:12',10,0),('1','197',257618,' DAILY SHIFT 2ND SALES NEW STOCK ','2022-04-30','2022-04-30 18:51:30','2022-05-01 18:51:30','705',0.00,0.00,'705','2022-04-30 19:53:23','705','2022-04-30 19:53:36',10,0),('1','197',257619,'DAILY SHIFT','2022-05-01','2022-05-01 08:00:58','2022-05-02 08:00:58','705',0.00,0.00,'705','2022-05-01 20:57:52','705','2022-05-01 20:58:15',10,0),('1','197',257620,'DAILY SHIFT','2022-05-02','2022-05-02 10:41:46','2022-05-03 10:41:46','705',0.00,0.00,'705','2022-05-02 21:04:24','705','2022-05-02 21:09:16',10,0),('1','197',257621,'DAILY SHIFT','2022-05-03','2022-05-03 08:42:40','2022-05-04 08:42:40','705',0.00,0.00,'705','2022-05-03 14:41:16','705','2022-05-03 14:41:32',10,0),('1','197',257622,'0PERATIONAL LOSS','2022-05-03','2022-05-03 14:42:02','2022-05-04 14:42:02','705',0.00,0.00,'705','2022-05-03 14:44:46','705','2022-05-03 14:45:05',10,0),('1','197',257623,' DAILY SHIFT 2ND SALES NEW STOCK','2022-05-03','2022-05-03 14:47:30','2022-05-04 14:47:30','705',0.00,0.00,'705','2022-05-03 20:08:33','705','2022-05-03 20:08:51',10,0),('1','197',257624,'DAILY SHIFT','2022-05-04','2022-05-04 11:49:54','2022-05-05 11:49:54','705',0.00,0.00,'705','2022-05-04 20:45:17','705','2022-05-04 20:45:34',10,0),('1','197',257625,'DAILY SHIFT','2022-05-05','2022-05-05 10:17:15','2022-05-06 10:17:15','705',0.00,0.00,'705','2022-05-05 20:52:15','705','2022-05-05 20:52:32',10,0),('1','197',257626,'DAILY SHIFT','2022-05-06','2022-05-06 09:21:59','2022-05-07 09:21:59','705',0.00,0.00,'705','2022-05-06 20:30:17','705','2022-05-06 20:30:31',10,0),('1','197',257627,'DAILY SHIFT','2022-05-07','2022-05-07 08:48:12','2022-05-08 08:48:12','705',0.00,0.00,'705','2022-05-07 11:24:42','705','2022-05-07 11:24:59',10,0),('1','197',257628,'0PERATIONAL LOSS','2022-05-07','2022-05-07 11:26:42','2022-05-08 11:26:42','705',0.00,0.00,'705','2022-05-07 11:38:19','705','2022-05-07 11:38:41',10,0),('1','197',257629,' DAILY SHIFT 2ND SALES NEW STOCK1','2022-05-07','2022-05-07 17:35:19','2022-05-08 17:35:19','705',0.00,0.00,'705','2022-05-07 20:08:28','705','2022-05-07 20:08:43',10,0),('1','197',257630,'DAILY SHIFT','2022-05-08','2022-05-08 07:55:47','2022-05-09 07:55:47','705',0.00,0.00,'705','2022-05-08 20:14:23','705','2022-05-08 20:14:49',10,0),('1','197',257631,'DAILY SHIFT','2022-05-09','2022-05-09 07:09:20','2022-05-10 07:09:20','705',0.00,0.00,'705','2022-05-09 22:38:27','705','2022-05-09 22:38:50',10,0),('1','197',257632,'DAILY SHIFT','2022-05-10','2022-05-10 06:48:33','2022-05-11 06:48:33','705',0.00,0.00,'705','2022-05-10 23:16:50','705','2022-05-10 23:17:27',10,0),('1','197',257633,'DAILY SHIFT','2022-05-11','2022-05-11 06:34:16','2022-05-12 06:34:16','705',0.00,0.00,'705','2022-05-12 06:48:25','705','2022-05-12 06:48:51',10,0),('1','197',257634,'DAILY SHIFT','2022-05-12','2022-05-12 06:49:19','2022-05-13 06:49:19','705',0.00,0.00,'705','2022-05-13 07:22:02','705','2022-05-13 07:22:28',10,0),('1','197',257635,'DAILY SHIFT','2022-05-13','2022-05-13 07:49:53','2022-05-14 07:49:53','705',0.00,0.00,'705','2022-05-13 20:37:23','705','2022-05-13 20:37:53',10,0),('1','197',257636,'DAILY SHIFT','2022-05-14','2022-05-14 06:32:07','2022-05-15 06:32:07','705',0.00,0.00,'705','2022-05-14 11:37:19','705','2022-05-14 11:37:57',10,0),('1','197',257637,' DAILY SHIFT 2ND SALES NEW STOCK','2022-05-14','2022-05-14 16:13:13','2022-05-15 16:13:13','705',0.00,0.00,'705','2022-05-14 16:15:22','705','2022-05-14 16:15:43',10,0),('1','197',257638,'0PERATIONAL LOSS','2022-05-14','2022-05-14 16:28:05','2022-05-15 16:28:05','705',0.00,0.00,'705','2022-05-14 16:31:11','705','2022-05-14 16:31:31',10,0),('1','197',257639,' DAILY SHIFT 2ND SALES NEW STOCK','2022-05-14','2022-05-14 16:35:08','2022-05-15 16:35:08','705',0.00,0.00,'705','2022-05-14 21:36:10','705','2022-05-14 21:36:31',10,0),('1','197',257640,'DAILY SHIFT','2022-05-15','2022-05-15 06:30:44','2022-05-16 06:30:44','705',0.00,0.00,'705','2022-05-15 23:47:02','705','2022-05-15 23:47:26',10,0),('1','197',257641,'DAILY SHIFT','2022-05-16','2022-05-16 06:27:24','2022-05-17 06:27:24','705',0.00,0.00,'705','2022-05-16 20:07:51','705','2022-05-16 20:08:13',10,0),('1','197',257642,'DAILY SHIFT ','2022-05-17','2022-05-17 07:00:51','2022-05-18 07:00:51','705',0.00,0.00,'705','2022-05-17 20:10:36','705','2022-05-17 20:10:50',10,0),('1','197',257643,'DAILY SHIFT','2022-05-18','2022-05-18 05:58:57','2022-05-19 05:58:57','705',0.00,0.00,'705','2022-05-18 20:58:54','705','2022-05-18 20:59:21',10,0),('1','197',257644,'DAILY SHIFT','2022-05-19','2022-05-19 06:33:06','2022-05-20 06:33:06','705',0.00,0.00,'705','2022-05-19 21:32:52','705','2022-05-19 21:33:12',10,0),('1','197',257645,'DAILY SHIFT','2022-05-20','2022-05-20 06:54:37','2022-05-21 06:54:37','705',0.00,0.00,'705','2022-05-20 14:46:47','705','2022-05-20 14:47:03',10,0),('1','197',257646,'0VERAGE','2022-05-20','2022-05-20 14:47:22','2022-05-21 14:47:22','705',0.00,0.00,'705','2022-05-20 14:54:38','705','2022-05-20 14:54:54',10,0),('1','197',257647,'DAILY SHIFT NEW STOCK','2022-05-21','2022-05-21 06:30:48','2022-05-22 06:30:48','705',0.00,0.00,'705','2022-05-21 21:06:36','705','2022-05-21 21:06:54',10,0),('1','197',257648,'DAILY SHIFT','2022-05-22','2022-05-22 06:39:34','2022-05-23 06:39:34','705',0.00,0.00,'705','2022-05-22 19:20:29','705','2022-05-22 19:20:47',10,0),('1','197',257649,'DAILY SHIFT','2022-05-23','2022-05-23 06:47:29','2022-05-24 06:47:29','705',0.00,0.00,'705','2022-05-24 05:58:19','705','2022-05-24 05:58:48',10,0),('1','197',257650,'DAILY SHIFT','2022-05-24','2022-05-24 05:59:13','2022-05-25 05:59:13','705',0.00,0.00,'705','2022-05-24 20:01:51','705','2022-05-24 20:02:13',10,0),('1','197',257651,'DAILY SHIFT','2022-05-25','2022-05-25 07:09:14','2022-05-26 07:09:14','705',0.00,0.00,'705','2022-05-26 05:32:07','705','2022-05-26 05:32:34',10,0),('1','197',257652,'DAILY SHIFT ','2022-05-26','2022-05-26 05:33:17','2022-05-27 05:33:17','705',0.00,0.00,'705','2022-05-26 20:06:25','705','2022-05-26 20:06:48',10,0),('1','197',257653,'DAILY SHIFT','2022-05-27','2022-05-27 05:24:47','2022-05-28 05:24:47','705',0.00,0.00,'705','2022-05-27 17:14:40','705','2022-05-27 17:14:58',10,0),('1','197',257654,'0PERATIONAL LOSS','2022-05-27','2022-05-27 17:15:17','2022-05-28 17:15:17','705',0.00,0.00,'705','2022-05-27 17:27:19','705','2022-05-27 17:27:34',10,0),('1','197',257655,' DAILY SHIFT 2ND SALES NEW STOCK','2022-05-27','2022-05-27 17:32:02','2022-05-28 17:32:02','705',0.00,0.00,'705','2022-05-27 20:45:32','705','2022-05-27 20:45:52',10,0),('1','197',257656,'DAILY SHIFT','2022-05-28','2022-05-28 06:25:40','2022-05-29 06:25:40','705',0.00,0.00,'705','2022-05-28 21:01:58','705','2022-05-28 21:02:13',10,0),('1','197',257657,'DAILY SHIFT','2022-05-29','2022-05-29 06:22:22','2022-05-30 06:22:22','705',0.00,0.00,'705','2022-05-29 20:18:21','705','2022-05-29 20:18:37',10,0),('1','197',257658,'DAILY SHIFT','2022-05-30','2022-05-30 05:15:38','2022-05-31 05:15:38','705',0.00,0.00,'705','2022-05-30 13:04:28','705','2022-05-30 13:04:44',10,0),('1','197',257659,'0PERATIONAL LOSS','2022-05-30','2022-05-30 13:05:07','2022-05-31 13:05:07','705',0.00,0.00,'705','2022-05-30 13:09:56','705','2022-05-30 13:10:18',10,0),('1','197',257660,' DAILY SHIFT 2ND SALES NEW STOCK','2022-05-30','2022-05-30 16:04:42','2022-05-31 16:04:42','705',0.00,0.00,'705','2022-05-30 22:14:39','705','2022-05-30 22:15:00',10,0),('1','197',257661,'DAILY SHIFT','2022-05-31','2022-05-31 06:08:32','2022-06-01 06:08:32','705',0.00,0.00,'705','2022-05-31 20:12:04','705','2022-05-31 20:12:18',10,0),('1','197',257662,'DAILY SHIFT','2022-06-01','2022-06-01 06:17:46','2022-06-02 06:17:46','705',0.00,0.00,'705','2022-06-01 16:50:21','705','2022-06-01 16:50:38',10,0),('1','197',257663,'0PERATIONAL LOSS','2022-06-01','2022-06-01 16:50:57','2022-06-02 16:50:57','705',0.00,0.00,'705','2022-06-01 16:53:52','705','2022-06-01 16:54:14',10,0),('1','197',257664,' DAILY SHIFT 2ND SALES NEW STOCK','2022-06-01','2022-06-01 17:57:46','2022-06-02 17:57:46','705',0.00,0.00,'705','2022-06-01 20:27:00','705','2022-06-01 20:27:45',10,0),('1','197',257665,'DAILY SHIFT','2022-06-02','2022-06-02 05:39:25','2022-06-03 05:39:25','705',0.00,0.00,'705','2022-06-02 20:29:49','705','2022-06-02 20:30:05',10,0),('1','197',257666,'DAILY SHIFT','2022-06-03','2022-06-03 06:07:45','2022-06-04 06:07:45','705',0.00,0.00,'705','2022-06-04 00:01:05','705','2022-06-04 00:01:25',10,0),('1','197',257667,'DAILY SHIFT','2022-06-04','2022-06-04 06:40:07','2022-06-05 06:40:07','705',0.00,0.00,'705','2022-06-04 18:10:22','705','2022-06-04 18:10:41',10,0),('1','197',257668,'0PERATIONAL LOSS','2022-06-04','2022-06-04 18:11:04','2022-06-05 18:11:04','705',0.00,0.00,'705','2022-06-04 18:14:53','705','2022-06-04 18:15:11',10,0),('1','197',257669,'DAILY SHIFT NEW STOCK','2022-06-05','2022-06-05 09:00:23','2022-06-06 09:00:23','705',0.00,0.00,'705','2022-06-05 20:05:56','705','2022-06-05 20:06:13',10,0),('1','197',257670,'DAILY SHIFT','2022-06-06','2022-06-06 07:37:36','2022-06-07 07:37:36','705',0.00,0.00,'705','2022-06-06 23:47:05','705','2022-06-06 23:47:23',10,0),('1','197',257671,'DAILY SHIFT','2022-06-07','2022-06-07 15:01:54','2022-06-08 15:01:54','705',0.00,0.00,'705','2022-06-07 20:03:38','705','2022-06-07 20:03:50',10,0),('1','197',257672,'DAILY SHIFT','2022-06-08','2022-06-08 07:29:14','2022-06-09 07:29:14','705',0.00,0.00,'705','2022-06-08 21:11:26','705','2022-06-08 21:11:41',10,0),('1','197',257673,'DAILY SHIFT','2022-06-09','2022-06-09 07:42:24','2022-06-10 07:42:24','705',0.00,0.00,'705','2022-06-09 20:02:28','705','2022-06-09 20:02:45',10,0),('1','197',257674,'DAILY SHIFT','2022-06-10','2022-06-10 06:08:14','2022-06-11 06:08:14','705',0.00,0.00,'705','2022-06-10 19:52:25','705','2022-06-10 19:52:58',10,0),('1','197',257675,'DAILY SHIFT','2022-06-11','2022-06-11 06:00:11','2022-06-12 06:00:11','705',0.00,0.00,'705','2022-06-11 18:14:24','705','2022-06-11 18:25:32',10,0),('1','197',257676,'0PERATIONAL LOSS','2022-06-11','2022-06-11 18:25:54','2022-06-12 18:25:54','705',0.00,0.00,'705','2022-06-11 18:32:02','705','2022-06-11 18:32:15',10,0),('1','197',257677,'DAILY SHIFT NEW STOCK','2022-06-12','2022-06-12 07:16:08','2022-06-13 07:16:08','705',0.00,0.00,'705','2022-06-12 19:58:02','705','2022-06-12 19:58:20',10,0),('1','197',257678,'DAILY SHIFT','2022-06-13','2022-06-13 06:14:02','2022-06-14 06:14:02','705',0.00,0.00,'705','2022-06-13 19:37:57','705','2022-06-13 19:38:27',10,0),('1','197',257679,'DAILY SHIFT','2022-06-14','2022-06-14 07:47:42','2022-06-15 07:47:42','705',0.00,0.00,'705','2022-06-14 20:29:01','705','2022-06-14 20:29:18',10,0),('1','197',257680,'DAILY SHIFT','2022-06-15','2022-06-15 07:19:03','2022-06-16 07:19:03','705',0.00,0.00,'705','2022-06-15 20:22:17','705','2022-06-15 20:22:31',10,0),('1','197',257681,'DAILY SHIFT','2022-06-16','2022-06-16 06:41:21','2022-06-17 06:41:21','705',0.00,0.00,'705','2022-06-16 20:43:54','705','2022-06-16 20:44:10',10,0),('1','197',257682,'DAILY SHIFT','2022-06-17','2022-06-17 07:01:39','2022-06-18 07:01:39','705',0.00,0.00,'705','2022-06-17 20:07:34','705','2022-06-17 20:07:52',10,0),('1','197',257683,'DAILY SHIFT','2022-06-18','2022-06-18 07:29:49','2022-06-19 07:29:49','705',0.00,0.00,'705','2022-06-18 12:56:27','705','2022-06-18 12:56:53',10,0),('1','197',257684,'0PERATIONAL LOSS','2022-06-18','2022-06-18 12:58:14','2022-06-19 12:58:14','705',0.00,0.00,'705','2022-06-18 13:02:20','705','2022-06-18 13:02:53',10,0),('1','197',257685,' DAILY SHIFT 2ND SALES NEW STOCK','2022-06-18','2022-06-18 14:24:10','2022-06-19 14:24:10','705',0.00,0.00,'705','2022-06-18 19:57:51','705','2022-06-18 19:58:07',10,0),('1','197',257686,'DAILY SHIFT','2022-06-19','2022-06-19 07:33:09','2022-06-20 07:33:09','705',0.00,0.00,'705','2022-06-19 21:06:13','705','2022-06-19 21:06:27',10,0),('1','197',257687,'DAILY SHIFT','2022-06-20','2022-06-20 06:39:16','2022-06-21 06:39:16','705',0.00,0.00,'705','2022-06-20 20:05:13','705','2022-06-20 20:05:35',10,0),('1','197',257688,'DAILY SHIFT','2022-06-21','2022-06-21 06:55:44','2022-06-22 06:55:44','705',0.00,0.00,'705','2022-06-21 23:12:59','705','2022-06-21 23:13:48',10,0),('1','197',257689,'DAILY SHIFT','2022-06-22','2022-06-22 07:07:32','2022-06-23 07:07:32','705',0.00,0.00,'705','2022-06-22 19:50:28','705','2022-06-22 19:50:48',10,0),('1','197',257690,'DAILY SHIFT ','2022-06-23','2022-06-23 06:13:20','2022-06-24 06:13:20','705',0.00,0.00,'705','2022-06-23 15:06:15','705','2022-06-23 15:06:34',10,0),('1','197',257691,'0PERATIONAL LOSS','2022-06-23','2022-06-23 15:06:55','2022-06-24 15:06:55','705',0.00,0.00,'705','2022-06-23 15:17:40','705','2022-06-23 15:17:58',10,0),('1','197',257692,'0PERATIONAL LOSS','2022-06-23','2022-06-23 17:13:26','2022-06-24 17:13:26','705',0.00,0.00,'705','2022-06-23 17:13:49','705','2022-06-23 17:14:39',10,0),('1','197',257693,' DAILY SHIFT 2ND SALES NEW STOCK','2022-06-23','2022-06-23 17:15:21','2022-06-24 17:15:21','705',0.00,0.00,'705','2022-06-23 20:11:06','705','2022-06-23 20:11:23',10,0),('1','197',257694,'DAILY SHIFT ','2022-06-24','2022-06-24 07:18:30','2022-06-25 07:18:30','705',0.00,0.00,'705','2022-06-24 20:43:36','705','2022-06-24 20:44:01',10,0),('1','197',257695,'DAILY SHIFT ','2022-06-25','2022-06-25 06:00:58','2022-06-26 06:00:58','705',0.00,0.00,'705','2022-06-25 19:54:44','705','2022-06-25 19:55:05',10,0),('1','197',257696,'DAILY SHIFT','2022-06-26','2022-06-26 06:31:47','2022-06-27 06:31:47','705',0.00,0.00,'705','2022-06-26 19:35:20','705','2022-06-26 19:36:57',10,0),('1','197',257697,'DAILY SHIFT','2022-06-27','2022-06-27 07:08:43','2022-06-28 07:08:43','705',0.00,0.00,'705','2022-06-27 18:36:23','705','2022-06-27 18:36:41',10,0),('1','197',257698,'DAILY SHIFT ','2022-06-28','2022-06-28 11:54:56','2022-06-29 11:54:56','705',0.00,0.00,'705','2022-06-28 20:34:59','705','2022-06-28 20:35:28',10,0),('1','197',257699,'DAILY SHIFT','2022-06-29','2022-06-29 07:11:42','2022-06-30 07:11:42','705',0.00,0.00,'705','2022-06-29 21:01:19','705','2022-06-29 21:01:32',10,0),('1','197',257700,'DAILY SHIFT ','2022-06-30','2022-06-30 06:04:23','2022-07-01 06:04:23','705',0.00,0.00,'705','2022-06-30 19:34:47','705','2022-06-30 19:35:01',10,0),('1','197',257701,'0PERATIONAL LOSS','2022-06-30','2022-06-30 19:35:34','2022-07-01 19:35:34','705',0.00,0.00,'705','2022-06-30 19:39:56','705','2022-06-30 19:40:50',10,0),('1','197',257702,'DAILY SHIFT  NEW STOCK ','2022-07-01','2022-07-01 06:10:47','2022-07-02 06:10:47','705',0.00,0.00,'705','2022-07-01 20:31:06','705','2022-07-01 20:31:21',10,0),('1','197',257703,'DAILY SHIFT ','2022-07-02','2022-07-02 06:15:33','2022-07-03 06:15:33','705',0.00,0.00,'705','2022-07-02 20:16:33','705','2022-07-02 20:16:50',10,0),('1','197',257704,'DAILY SHIFT ','2022-07-03','2022-07-03 06:17:52','2022-07-04 06:17:52','705',0.00,0.00,'705','2022-07-03 20:21:48','705','2022-07-03 20:24:15',10,0),('1','197',257705,'DAILY SHIFT','2022-07-04','2022-07-04 07:15:40','2022-07-05 07:15:40','705',0.00,0.00,'705','2022-07-04 17:44:22','705','2022-07-04 17:44:38',10,0),('1','197',257706,'DAILY SHIFT','2022-07-08','2022-07-08 11:31:29','2022-07-09 11:31:29','705',0.00,0.00,'705','2022-07-08 16:44:22','705','2022-07-08 16:44:38',10,0),('1','197',257707,'OPERATIONAL LOSS','2022-07-08','2022-07-08 16:45:12','2022-07-09 16:45:12','705',0.00,0.00,'705','2022-07-08 16:49:16','705','2022-07-08 16:49:31',10,0),('1','197',257708,'DAILY SHIFT NEW STOCK','2022-07-09','2022-07-09 09:16:14','2022-07-10 09:16:14','705',0.00,0.00,'705','2022-07-10 06:12:17','705','2022-07-10 06:12:33',10,0),('1','197',257709,'DAILY SHIFT ','2022-07-10','2022-07-10 06:13:02','2022-07-11 06:13:02','705',0.00,0.00,'705','2022-07-10 22:19:11','705','2022-07-10 22:19:39',10,0),('1','197',257710,'DAILY SHIFT ','2022-07-11','2022-07-11 06:32:38','2022-07-12 06:32:38','705',0.00,0.00,'705','2022-07-11 20:47:23','705','2022-07-11 20:47:57',10,0),('1','197',257711,'DAILY SHIFT ','2022-07-16','2022-07-16 13:35:18','2022-07-17 13:35:18','705',0.00,0.00,'705','2022-07-16 20:07:38','705','2022-07-16 20:07:53',10,0),('1','197',257712,'DAILY SHIFT ','2022-07-17','2022-07-17 06:19:47','2022-07-18 06:19:47','705',0.00,0.00,'705','2022-07-17 21:18:09','705','2022-07-17 21:18:45',10,0),('1','197',257713,'DAILY SHIFT ','2022-07-18','2022-07-18 05:45:03','2022-07-19 05:45:03','705',0.00,0.00,'705','2022-07-18 19:58:56','705','2022-07-18 19:59:12',10,0),('1','197',257714,'DAILY SHIFT','2022-07-19','2022-07-19 05:39:35','2022-07-20 05:39:35','705',0.00,0.00,'705','2022-07-19 19:55:53','705','2022-07-19 19:56:47',10,0),('1','197',257715,'DAILY SHIFT','2022-07-20','2022-07-20 06:05:46','2022-07-21 06:05:46','705',0.00,0.00,'705','2022-07-20 11:39:42','705','2022-07-20 11:40:36',10,0),('1','197',257716,'0VERAGE','2022-07-20','2022-07-20 11:41:39','2022-07-21 11:41:39','705',0.00,0.00,'705','2022-07-20 11:54:37','705','2022-07-20 11:56:00',10,0),('1','197',257717,'0PERATIONAL LOSS','2022-07-20','2022-07-20 14:08:16','2022-07-21 14:08:16','705',0.00,0.00,'705','2022-07-20 14:08:44','705','2022-07-20 14:09:11',10,0),('1','197',257718,' DAILY SHIFT 2ND SALES NEW STOCK','2022-07-20','2022-07-20 14:09:41','2022-07-21 14:09:41','705',0.00,0.00,'705','2022-07-20 20:13:37','705','2022-07-20 20:14:20',10,0),('1','197',257719,'DAILY SHIFT','2022-07-21','2022-07-21 05:29:11','2022-07-22 05:29:11','705',0.00,0.00,'705','2022-07-21 19:40:29','705','2022-07-21 19:40:52',10,0),('1','197',257720,'DAILY SHIFT','2022-07-22','2022-07-22 06:43:51','2022-07-23 06:43:51','705',0.00,0.00,'705','2022-07-22 19:43:39','705','2022-07-22 19:46:00',10,0),('1','197',257721,'DAILY SHIFT  NEW PRICE','2022-07-23','2022-07-23 05:35:44','2022-07-24 05:35:44','705',0.00,0.00,'705','2022-07-23 19:44:49','705','2022-07-23 19:45:18',10,0),('1','197',257722,'DAILY SHIFT ','2022-07-24','2022-07-24 05:43:03','2022-07-25 05:43:03','705',0.00,0.00,'705','2022-07-24 20:04:23','705','2022-07-24 20:04:47',10,0),('1','197',257723,'DAILY SHIFT','2022-07-25','2022-07-25 06:11:57','2022-07-26 06:11:57','705',0.00,0.00,'705','2022-07-25 12:57:20','705','2022-07-25 13:00:06',10,0),('1','197',257724,'0PERATIONAL LOSS','2022-07-25','2022-07-25 13:36:38','2022-07-26 13:36:38','705',0.00,0.00,'705','2022-07-25 13:42:47','705','2022-07-25 13:43:10',10,0),('1','197',257725,' DAILY SHIFT 2ND SALES NEW STOCK','2022-07-25','2022-07-25 13:44:22','2022-07-26 13:44:22','705',0.00,0.00,'705','2022-07-25 19:06:19','705','2022-07-25 19:06:34',10,0),('1','197',257726,'DAILY SHIFT','2022-07-26','2022-07-26 06:02:24','2022-07-27 06:02:24','705',0.00,0.00,'705','2022-07-26 19:25:50','705','2022-07-26 19:26:24',10,0),('1','197',257727,'DAILY SHIFT','2022-07-27','2022-07-27 05:58:45','2022-07-28 05:58:45','705',0.00,0.00,'705','2022-07-27 19:37:32','705','2022-07-27 19:37:55',10,0),('1','197',257728,'DAILY SHIFT','2022-07-28','2022-07-28 06:36:08','2022-07-29 06:36:08','705',0.00,0.00,'705','2022-07-28 19:27:01','705','2022-07-28 19:27:49',10,0),('1','197',257729,'DAILY SHIFT ','2022-07-29','2022-07-29 06:25:23','2022-07-30 06:25:23','705',0.00,0.00,'705','2022-07-29 09:18:41','705','2022-07-29 09:18:55',10,0),('1','197',257730,'0PERATIONAL LOSS','2022-07-29','2022-07-29 09:21:07','2022-07-30 09:21:07','705',0.00,0.00,'705','2022-07-29 09:27:06','705','2022-07-29 09:27:23',10,0),('1','197',257731,' DAILY SHIFT 2ND SALES NEW STOCK','2022-07-29','2022-07-29 09:27:57','2022-07-30 09:27:57','705',0.00,0.00,'705','2022-07-29 19:51:00','705','2022-07-29 19:51:15',10,0),('1','197',257732,'DAILY SHIFT','2022-07-30','2022-07-30 05:44:27','2022-07-31 05:44:27','705',0.00,0.00,'705','2022-07-30 19:32:39','705','2022-07-30 19:33:51',10,0),('1','197',257733,'DAILY SHIFT','2022-07-31','2022-07-31 06:25:27','2022-08-01 06:25:27','705',0.00,0.00,'705','2022-07-31 20:06:08','705','2022-07-31 20:06:46',10,0),('1','197',257734,'DAILY SHIFT ','2022-08-01','2022-08-01 06:19:10','2022-08-02 06:19:10','705',0.00,0.00,'705','2022-08-01 18:13:33','705','2022-08-01 18:13:49',10,0),('1','197',257735,'0PERATIONAL LOSS','2022-08-01','2022-08-01 18:14:14','2022-08-02 18:14:14','705',0.00,0.00,'705','2022-08-01 18:18:08','705','2022-08-01 18:18:24',10,0),('1','197',257736,'DAILY SHIFT NEW STOCK','2022-08-02','2022-08-02 06:14:19','2022-08-03 06:14:19','705',0.00,0.00,'705','2022-08-02 19:42:39','705','2022-08-02 19:54:44',10,0),('1','197',257737,'DAILY SHIFT ','2022-08-03','2022-08-03 06:10:38','2022-08-04 06:10:38','705',0.00,0.00,'705','2022-08-03 20:12:02','705','2022-08-03 20:12:20',10,0),('1','197',257738,'DAILY SHIFT ','2022-08-04','2022-08-04 06:20:34','2022-08-05 06:20:34','705',0.00,0.00,'705','2022-08-04 22:16:31','705','2022-08-04 22:17:56',10,0),('1','197',257739,'DAILY SHIFT ','2022-08-05','2022-08-05 05:57:53','2022-08-06 05:57:53','705',0.00,0.00,'705','2022-08-05 13:04:07','705','2022-08-05 13:05:00',10,0),('1','197',257740,'0PERATIONAL LOSS','2022-08-05','2022-08-05 13:05:18','2022-08-06 13:05:18','705',0.00,0.00,'705','2022-08-05 13:09:14','705','2022-08-05 13:09:57',10,0),('1','197',257741,'DAILY SHIFT 2ND SALES NEW STOCK','2022-08-05','2022-08-05 17:55:38','2022-08-06 17:55:38','705',0.00,0.00,'705','2022-08-05 19:59:35','705','2022-08-05 19:59:51',10,0),('1','197',257742,'DAILY SHIFT','2022-08-06','2022-08-06 06:20:39','2022-08-07 06:20:39','705',0.00,0.00,'705','2022-08-06 19:59:29','705','2022-08-06 20:00:16',10,0),('1','197',257743,'0PERATIONAL LOSS','2022-08-06','2022-08-06 20:05:21','2022-08-07 20:05:21','705',0.00,0.00,'705','2022-08-06 20:24:38','705','2022-08-06 20:25:34',10,0),('1','197',257744,'DAILY SHIFT NEW STOCK ','2022-08-07','2022-08-07 06:02:40','2022-08-08 06:02:40','705',0.00,0.00,'705','2022-08-07 19:46:24','705','2022-08-07 19:46:52',10,0),('1','197',257745,'DAILY SHIFT ','2022-08-08','2022-08-08 05:52:31','2022-08-09 05:52:31','705',0.00,0.00,'705','2022-08-08 23:22:37','705','2022-08-08 23:23:08',10,0),('1','197',257746,'DAILY SHIFT ','2022-08-09','2022-08-09 05:56:50','2022-08-10 05:56:50','705',0.00,0.00,'705','2022-08-09 20:08:49','705','2022-08-09 20:09:03',10,0),('1','197',257747,'DAILY SHIFT ','2022-08-10','2022-08-10 06:01:18','2022-08-11 06:01:18','705',0.00,0.00,'705','2022-08-10 20:11:57','705','2022-08-10 20:13:01',10,0),('1','197',257748,'DAILY SHIFT','2022-08-11','2022-08-11 06:11:53','2022-08-12 06:11:53','705',0.00,0.00,'705','2022-08-11 20:07:26','705','2022-08-11 20:09:38',10,0),('1','197',257749,'0VERAGE','2022-08-11','2022-08-11 23:52:36','2022-08-12 23:52:36','705',0.00,0.00,'705','2022-08-11 23:54:43','705','2022-08-11 23:55:06',10,0),('1','197',257750,'DAILY SHIFT NEW STOCK','2022-08-12','2022-08-12 12:32:08','2022-08-13 12:32:08','705',0.00,0.00,'705','2022-08-12 19:36:27','705','2022-08-12 19:36:45',10,0),('1','197',257751,'DAILY SHIFT','2022-08-13','2022-08-13 06:45:55','2022-08-14 06:45:55','705',0.00,0.00,'705','2022-08-13 19:28:07','705','2022-08-13 19:28:25',10,0),('1','197',257752,'DAILY SHIFT','2022-08-14','2022-08-14 07:11:56','2022-08-15 07:11:56','705',0.00,0.00,'705','2022-08-14 20:10:38','705','2022-08-14 20:13:12',10,0),('1','197',257753,'DAILY SHIFT','2022-08-15','2022-08-15 07:05:21','2022-08-16 07:05:21','705',0.00,0.00,'705','2022-08-15 20:12:08','705','2022-08-15 20:12:30',10,0),('1','197',257754,'DAILY SHIFT NEW PRICE','2022-08-16','2022-08-16 06:21:37','2022-08-17 06:21:37','705',0.00,0.00,'705','2022-08-16 21:17:04','705','2022-08-16 21:17:31',10,0),('1','197',257755,'DAILY SHIFT','2022-08-17','2022-08-17 06:46:50','2022-08-18 06:46:50','705',0.00,0.00,'705','2022-08-17 09:17:34','705','2022-08-17 09:18:20',10,0),('1','197',257756,'0PERATIONAL LOSS','2022-08-17','2022-08-17 09:43:11','2022-08-18 09:43:11','705',0.00,0.00,'705','2022-08-17 09:45:44','705','2022-08-17 09:46:07',10,0),('1','197',257757,' DAILY SHIFT 2ND SALES NEW STOCK','2022-08-17','2022-08-17 15:29:40','2022-08-18 15:29:40','705',0.00,0.00,'705','2022-08-18 00:02:06','705','2022-08-18 00:02:25',10,0),('1','197',257758,'DAILY SHIFT','2022-08-18','2022-08-18 06:08:54','2022-08-19 06:08:54','705',0.00,0.00,'705','2022-08-18 19:48:06','705','2022-08-18 19:48:29',10,0),('1','197',257759,'DAILY SHIFT','2022-08-19','2022-08-19 06:54:11','2022-08-20 06:54:11','705',0.00,0.00,'705','2022-08-19 19:48:12','705','2022-08-19 19:48:41',10,0),('1','197',257760,'DAILY SHIFT','2022-08-20','2022-08-20 12:06:43','2022-08-21 12:06:43','705',0.00,0.00,'705','2022-08-20 18:56:21','705','2022-08-20 18:56:39',10,0),('1','197',257761,'0PERATIONAL LOSS','2022-08-20','2022-08-20 19:11:21','2022-08-21 19:11:21','705',0.00,0.00,'705','2022-08-20 19:12:29','705','2022-08-20 19:12:45',10,0),('1','197',257762,'DAILY SHIFT','2022-08-21','2022-08-21 08:15:46','2022-08-22 08:15:46','705',0.00,0.00,'705','2022-08-21 19:25:01','705','2022-08-21 19:25:17',10,0),('1','197',257763,'DAILY SHIFT','2022-08-22','2022-08-22 07:09:47','2022-08-23 07:09:47','705',0.00,0.00,'705','2022-08-22 19:26:20','705','2022-08-22 19:26:54',10,0),('1','197',257764,'DAILY SHIFT','2022-08-23','2022-08-23 06:28:51','2022-08-24 06:28:51','705',0.00,0.00,'705','2022-08-23 23:16:27','705','2022-08-23 23:16:45',10,0),('1','197',257765,'DAILY SHIFT ','2022-08-24','2022-08-24 06:03:27','2022-08-25 06:03:27','705',0.00,0.00,'705','2022-08-24 19:56:46','705','2022-08-24 19:57:00',10,0),('1','197',257766,'DAILY SHIFT ','2022-08-25','2022-08-25 06:00:12','2022-08-26 06:00:12','705',0.00,0.00,'705','2022-08-25 13:39:51','705','2022-08-25 13:40:11',10,0),('1','197',257767,'0PERATIONAL LOSS','2022-08-25','2022-08-25 13:40:26','2022-08-26 13:40:26','705',0.00,0.00,'705','2022-08-25 13:46:21','705','2022-08-25 13:46:55',10,0),('1','197',257768,'DAILY SHIFT  NEW STOCK ','2022-08-26','2022-08-26 06:34:02','2022-08-27 06:34:02','705',0.00,0.00,'705','2022-08-27 05:51:34','705','2022-08-27 05:51:56',10,0),('1','197',257769,'DAILY SHIFT NEW STOCK ','2022-08-28','2022-08-28 11:18:16','2022-08-29 11:18:16','705',0.00,0.00,'705','2022-08-28 20:06:03','705','2022-08-28 20:06:16',10,0),('1','197',257770,'DAILY SHIFT ','2022-08-29','2022-08-29 05:47:52','2022-08-30 05:47:52','705',0.00,0.00,'705','2022-08-29 22:51:58','705','2022-08-29 22:52:14',10,0),('1','197',257771,'DAILY SHIFT ','2022-08-30','2022-08-30 06:11:52','2022-08-31 06:11:52','705',0.00,0.00,'705','2022-08-30 20:23:16','705','2022-08-30 20:23:31',10,0),('1','197',257772,'DAILY SHIFT ','2022-08-31','2022-08-31 05:32:56','2022-09-01 05:32:56','705',0.00,0.00,'705','2022-08-31 19:20:14','705','2022-08-31 19:20:32',10,0),('1','197',257773,'0PERATIONAL LOSS','2022-08-31','2022-08-31 19:21:23','2022-09-01 19:21:23','705',0.00,0.00,'705','2022-08-31 19:25:06','705','2022-08-31 19:25:22',10,0),('1','197',257774,'DAILY SHIFT NEW STOCK ','2022-09-01','2022-09-01 14:20:06','2022-09-02 14:20:06','705',0.00,0.00,'705','2022-09-02 06:08:26','705','2022-09-02 06:08:55',10,0),('1','197',257775,'DAILY SHIFT ','2022-09-02','2022-09-02 06:09:37','2022-09-03 06:09:37','705',0.00,0.00,'705','2022-09-02 21:14:42','705','2022-09-02 21:14:59',10,0),('1','197',257776,'DAILY SHIFT ','2022-09-03','2022-09-03 05:51:41','2022-09-04 05:51:41','705',0.00,0.00,'705','2022-09-03 19:40:53','705','2022-09-03 19:41:12',10,0),('1','197',257777,'0PERATIONAL LOSS','2022-09-03','2022-09-03 19:47:22','2022-09-04 19:47:22','705',0.00,0.00,'705','2022-09-03 19:53:39','705','2022-09-03 19:53:54',10,0),('1','197',257778,'DAILY SHIFT NEW STOCK ','2022-09-04','2022-09-04 11:50:57','2022-09-05 11:50:57','705',0.00,0.00,'705','2022-09-04 20:05:50','705','2022-09-04 20:06:06',10,0),('1','197',257779,'DAILY SHIFT ','2022-09-05','2022-09-05 06:08:06','2022-09-06 06:08:06','705',0.00,0.00,'705','2022-09-05 20:37:49','705','2022-09-05 20:38:05',10,0),('1','197',257780,'DAILY SHIFT ','2022-09-06','2022-09-06 05:43:12','2022-09-07 05:43:12','705',0.00,0.00,'705','2022-09-06 20:03:20','705','2022-09-06 20:03:35',10,0),('1','197',257781,'DAILY SHIFT ','2022-09-07','2022-09-07 05:44:08','2022-09-08 05:44:08','705',0.00,0.00,'705','2022-09-07 17:13:20','705','2022-09-07 17:13:36',10,0),('1','197',257782,'OPERATIONAL LOSS','2022-09-07','2022-09-07 17:14:04','2022-09-08 17:14:04','705',0.00,0.00,'705','2022-09-07 17:18:53','705','2022-09-07 17:19:12',10,0),('1','197',257783,'NEW SHIFT NEW STOCK','2022-09-08','2022-09-08 06:06:06','2022-09-09 06:06:06','705',0.00,0.00,'705','2022-09-08 20:20:18','705','2022-09-08 20:20:34',10,0),('1','197',257784,'DAILY SHIFT ','2022-09-09','2022-09-09 05:48:48','2022-09-10 05:48:48','705',0.00,0.00,'705','2022-09-09 19:36:41','705','2022-09-09 19:36:58',10,0),('1','197',257785,'DAILY SHIFT ','2022-09-10','2022-09-10 06:02:03','2022-09-11 06:02:03','705',0.00,0.00,'705','2022-09-10 19:16:10','705','2022-09-10 19:16:26',10,0),('1','197',257786,'DAILY SHIFT ','2022-09-11','2022-09-11 06:04:39','2022-09-12 06:04:39','705',0.00,0.00,'705','2022-09-11 13:13:41','705','2022-09-11 13:14:00',10,0),('1','197',257787,'0PERATIONAL LOSS','2022-09-11','2022-09-11 13:16:28','2022-09-12 13:16:28','705',0.00,0.00,'705','2022-09-11 13:23:33','705','2022-09-11 13:24:05',10,0),('1','197',257788,'DAILY SHIFT NEW STOCK ','2022-09-13','2022-09-13 12:27:30','2022-09-14 12:27:30','705',0.00,0.00,'705','2022-09-13 20:48:04','705','2022-09-13 20:48:18',10,0),('1','197',257789,'DAILY SALES','2022-09-14','2022-09-14 09:38:54','2022-09-15 09:38:54','705',0.00,0.00,'705','2022-09-14 20:30:09','705','2022-09-14 20:30:26',10,0),('1','197',257790,'DAILY SHIFT','2022-09-15','2022-09-15 06:21:38','2022-09-16 06:21:38','705',0.00,0.00,'705','2022-09-15 18:16:54','705','2022-09-15 18:17:07',10,0),('1','197',257791,'DAILY SHIFT','2022-09-17','2022-09-17 10:17:18','2022-09-18 10:17:18','705',0.00,0.00,'705','2022-09-17 19:29:28','705','2022-09-17 19:29:56',10,0),('1','197',257792,'DAILY SHIFT','2022-09-18','2022-09-18 06:26:50','2022-09-19 06:26:50','705',0.00,0.00,'705','2022-09-18 15:54:05','705','2022-09-18 15:54:29',10,0),('1','197',257793,'0PERATIONAL LOSS','2022-09-18','2022-09-18 15:55:40','2022-09-19 15:55:40','705',0.00,0.00,'705','2022-09-18 15:59:21','705','2022-09-18 15:59:37',10,0),('1','197',257794,'DAILY SHIFT NEW STOCK ','2022-09-20','2022-09-20 14:02:51','2022-09-21 14:02:51','705',0.00,0.00,'705','2022-09-20 19:47:58','705','2022-09-20 19:48:15',10,0),('1','197',257795,'DAILY SHIFT ','2022-09-21','2022-09-21 06:38:04','2022-09-22 06:38:04','705',0.00,0.00,'705','2022-09-21 23:53:42','705','2022-09-21 23:54:00',10,0),('1','197',257796,'DAILY SHIFT ','2022-09-22','2022-09-22 06:03:19','2022-09-23 06:03:19','705',0.00,0.00,'705','2022-09-22 19:57:39','705','2022-09-22 19:57:54',10,0),('1','197',257797,'DAILY SHIFT','2022-09-23','2022-09-23 06:13:08','2022-09-24 06:13:08','705',0.00,0.00,'705','2022-09-23 22:24:07','705','2022-09-23 22:24:26',10,0),('1','197',257798,'DAILY SHIFT ','2022-09-24','2022-09-24 05:48:00','2022-09-25 05:48:00','705',0.00,0.00,'705','2022-09-24 20:16:47','705','2022-09-24 20:17:05',10,0),('1','197',257799,'DAILY SHIFT','2022-09-25','2022-09-25 06:41:23','2022-09-26 06:41:23','705',0.00,0.00,'705','2022-09-25 21:22:11','705','2022-09-25 21:22:26',10,0),('1','197',257800,'OPERATIONAL LOSS','2022-09-25','2022-09-25 21:22:51','2022-09-26 21:22:51','705',0.00,0.00,'705','2022-09-25 21:36:54','705','2022-09-25 21:37:08',10,0),('1','197',257801,'DAILY SHIFT NEW STOCK ','2022-09-26','2022-09-26 08:31:26','2022-09-27 08:31:26','705',0.00,0.00,'705','2022-09-26 19:56:47','705','2022-09-26 19:57:06',10,0),('1','197',257802,'DAILY SHIFT','2022-09-27','2022-09-27 06:14:33','2022-09-28 06:14:33','705',0.00,0.00,'705','2022-09-27 20:39:10','705','2022-09-27 20:39:28',10,0),('1','197',257803,'DAILY SHIFT ','2022-09-28','2022-09-28 06:04:16','2022-09-29 06:04:16','705',0.00,0.00,'705','2022-09-28 22:46:03','705','2022-09-28 22:46:22',10,0),('1','197',257804,'DAILY SHIFT ','2022-09-29','2022-09-29 06:01:17','2022-09-30 06:01:17','705',0.00,0.00,'705','2022-09-29 16:44:33','705','2022-09-29 16:45:01',10,0),('1','197',257805,'0VERAGE','2022-09-29','2022-09-29 16:49:19','2022-09-30 16:49:19','705',0.00,0.00,'705','2022-09-29 16:59:36','705','2022-09-29 16:59:59',10,0),('1','197',257806,'DAILY SHIFT NEW STOCK ','2022-09-30','2022-09-30 07:09:04','2022-10-01 07:09:04','705',0.00,0.00,'705','2022-10-01 07:17:55','705','2022-10-01 07:18:17',10,0),('1','197',257807,'DAILY SHIFT','2022-10-01','2022-10-01 07:18:40','2022-10-02 07:18:40','705',0.00,0.00,'705','2022-10-01 19:48:07','705','2022-10-01 19:48:44',10,0),('1','197',257808,'DAILY SHIFT ','2022-10-02','2022-10-02 06:00:00','2022-10-03 06:00:00','705',0.00,0.00,'705','2022-10-02 21:24:30','705','2022-10-02 21:25:25',10,0),('1','197',257809,'DAILY SHIFT','2022-10-03','2022-10-03 07:41:30','2022-10-04 07:41:30','705',0.00,0.00,'705','2022-10-03 14:05:51','705','2022-10-03 14:06:51',10,0),('1','197',257810,'0PERATIONAL LOSS','2022-10-03','2022-10-03 14:17:11','2022-10-04 14:17:11','705',0.00,0.00,'705','2022-10-03 14:22:02','705','2022-10-03 14:22:29',10,0),('1','197',257811,'DAILY SHIFT NEW STOCK ','2022-10-04','2022-10-04 12:03:16','2022-10-05 12:03:16','705',0.00,0.00,'705','2022-10-04 21:19:50','705','2022-10-04 21:20:17',10,0),('1','197',257812,'DAILY SHIFT ','2022-10-05','2022-10-05 06:09:11','2022-10-06 06:09:11','705',0.00,0.00,'705','2022-10-05 19:36:36','705','2022-10-05 19:36:49',10,0),('1','197',257813,'DAILY SHIFT ','2022-10-06','2022-10-06 06:01:28','2022-10-07 06:01:28','705',0.00,0.00,'705','2022-10-06 19:04:18','705','2022-10-06 19:05:24',10,0),('1','197',257814,'DAILY SHIFT ','2022-10-07','2022-10-07 05:40:01','2022-10-08 05:40:01','705',0.00,0.00,'705','2022-10-07 19:23:43','705','2022-10-07 19:23:57',10,0),('1','197',257815,'DAILY SHIFT ','2022-10-08','2022-10-08 06:22:59','2022-10-09 06:22:59','705',0.00,0.00,'705','2022-10-08 14:27:55','705','2022-10-08 14:28:12',10,0),('1','197',257816,'0PERATIONAL LOSS','2022-10-08','2022-10-08 14:29:06','2022-10-09 14:29:06','705',0.00,0.00,'705','2022-10-08 14:32:55','705','2022-10-08 14:33:12',10,0),('1','197',257817,'DAILY  SHIFT NEW STOCK NEW PRICE','2022-10-12','2022-10-12 07:32:26','2022-10-13 07:32:26','705',0.00,0.00,'705','2022-10-12 19:11:35','705','2022-10-12 19:11:48',10,0),('1','197',257818,'DAILY SHIFT ','2022-10-13','2022-10-13 06:30:04','2022-10-14 06:30:04','705',0.00,0.00,'705','2022-10-13 19:31:51','705','2022-10-13 19:32:09',10,0),('1','197',257819,'DAILY SHIFT ','2022-10-14','2022-10-14 06:24:17','2022-10-15 06:24:17','705',0.00,0.00,'705','2022-10-14 19:17:13','705','2022-10-14 19:17:28',10,0),('1','197',257820,'DAILY SHIFT ','2022-10-15','2022-10-15 06:13:20','2022-10-16 06:13:20','705',0.00,0.00,'705','2022-10-15 08:58:59','705','2022-10-15 08:59:14',10,0),('1','197',257821,'0PERATIONAL LOSS','2022-10-15','2022-10-15 08:59:29','2022-10-16 08:59:29','705',0.00,0.00,'705','2022-10-15 09:03:04','705','2022-10-15 09:03:21',10,0),('1','197',257822,' DAILY SHIFT 2ND SALES NEW STOCK','2022-10-15','2022-10-15 16:27:44','2022-10-16 16:27:44','705',0.00,0.00,'705','2022-10-15 19:37:53','705','2022-10-15 19:38:53',10,0),('1','197',257823,'DAILY SHIFT ','2022-10-16','2022-10-16 05:58:14','2022-10-17 05:58:14','705',0.00,0.00,'705','2022-10-16 19:15:18','705','2022-10-16 19:15:36',10,0),('1','197',257824,'DAILY SHIFT','2022-10-17','2022-10-17 06:04:02','2022-10-18 06:04:02','705',0.00,0.00,'705','2022-10-17 19:22:27','705','2022-10-17 19:22:57',10,0),('1','197',257825,'DAILY SHIFT ','2022-10-18','2022-10-18 06:13:52','2022-10-19 06:13:52','705',0.00,0.00,'705','2022-10-18 19:15:36','705','2022-10-18 19:15:54',10,0),('1','197',257826,'DAILY SHIFT','2022-10-19','2022-10-19 06:12:08','2022-10-20 06:12:08','705',0.00,0.00,'705','2022-10-19 19:30:14','705','2022-10-19 19:30:33',10,0),('1','197',257827,'DAILY SHIFT ','2022-10-20','2022-10-20 05:42:38','2022-10-21 05:42:38','705',0.00,0.00,'705','2022-10-20 18:08:11','705','2022-10-20 18:09:00',10,0),('1','197',257828,'0PERATIONAL LOSS','2022-10-20','2022-10-20 18:11:38','2022-10-21 18:11:38','705',0.00,0.00,'705','2022-10-20 18:15:14','705','2022-10-20 18:15:27',10,0),('1','197',257829,'DAILY SHIFT NEW STOCK ','2022-10-21','2022-10-21 06:45:49','2022-10-22 06:45:49','705',0.00,0.00,'705','2022-10-21 19:19:30','705','2022-10-21 19:19:47',10,0),('1','197',257830,'DAILY SHIFT ','2022-10-22','2022-10-22 06:18:18','2022-10-23 06:18:18','705',0.00,0.00,'705','2022-10-22 18:54:48','705','2022-10-22 18:55:05',10,0),('1','197',257831,'DAILY SHIFT ','2022-10-23','2022-10-23 06:14:00','2022-10-24 06:14:00','705',0.00,0.00,'705','2022-10-23 19:05:24','705','2022-10-23 19:05:42',10,0),('1','197',257832,'DAILY SHIFT ','2022-10-24','2022-10-24 06:17:10','2022-10-25 06:17:10','705',0.00,0.00,'705','2022-10-24 19:52:19','705','2022-10-24 19:52:35',10,0),('1','197',257833,'0VERAGE','2022-10-24','2022-10-24 19:56:06','2022-10-25 19:56:06','705',0.00,0.00,'705','2022-10-24 19:59:18','705','2022-10-24 19:59:36',10,0),('1','197',257834,'DAILY SHIFT NEW STOCK ','2022-10-25','2022-10-25 13:13:57','2022-10-26 13:13:57','705',0.00,0.00,'705','2022-10-25 18:59:22','705','2022-10-25 18:59:51',10,0),('1','197',257835,'DAILY SHIFT NEW PRICE ','2022-10-26','2022-10-26 05:55:47','2022-10-27 05:55:47','705',0.00,0.00,'705','2022-10-26 18:45:13','705','2022-10-26 18:45:39',10,0),('1','197',257836,'DAILY SHIFT ','2022-10-27','2022-10-27 06:36:40','2022-10-28 06:36:40','705',0.00,0.00,'705','2022-10-27 19:03:50','705','2022-10-27 19:04:05',10,0),('1','197',257837,'DAILY SHIFT ','2022-10-28','2022-10-28 06:38:01','2022-10-29 06:38:01','705',0.00,0.00,'705','2022-10-28 19:02:30','705','2022-10-28 19:02:44',10,0),('1','197',257838,'DAILY SHIFT ','2022-10-29','2022-10-29 06:02:51','2022-10-30 06:02:51','705',0.00,0.00,'705','2022-10-29 19:30:02','705','2022-10-29 19:30:26',10,0),('1','197',257839,'DAILY SHIFT ','2022-10-30','2022-10-30 06:46:31','2022-10-31 06:46:31','705',0.00,0.00,'705','2022-10-30 17:51:30','705','2022-10-30 17:51:46',10,0),('1','197',257840,'0PERATIONAL LOSS','2022-10-30','2022-10-30 17:52:56','2022-10-31 17:52:56','705',0.00,0.00,'705','2022-10-30 17:56:35','705','2022-10-30 17:56:51',10,0),('1','197',257841,'DAILY SHIFT NEW STOCK','2022-11-04','2022-11-04 12:52:23','2022-11-05 12:52:23','705',0.00,0.00,'705','2022-11-04 19:22:47','705','2022-11-04 19:23:03',10,0),('1','197',257842,'DAILY SHIFT','2022-11-05','2022-11-05 07:56:33','2022-11-06 07:56:33','705',0.00,0.00,'705','2022-11-05 19:09:59','705','2022-11-05 19:13:04',10,0),('1','197',257843,'DAILY SHIFT','2022-11-06','2022-11-06 07:49:32','2022-11-07 07:49:32','705',0.00,0.00,'705','2022-11-06 18:40:48','705','2022-11-06 18:41:20',10,0),('1','197',257844,'DAILY SHIFT','2022-11-07','2022-11-07 06:56:55','2022-11-08 06:56:55','705',0.00,0.00,'705','2022-11-07 18:58:16','705','2022-11-07 18:58:59',10,0),('1','197',257845,'DAILY SHIFT ','2022-11-08','2022-11-08 06:27:48','2022-11-09 06:27:48','705',0.00,0.00,'705','2022-11-08 19:20:23','705','2022-11-08 19:20:42',10,0),('1','197',257846,'0VERAGE','2022-11-08','2022-11-08 19:21:48','2022-11-09 19:21:48','705',0.00,0.00,'705','2022-11-08 19:27:05','705','2022-11-08 19:27:21',10,0),('1','197',257847,' DAILY SHIFT 2ND SALES NEW STOCK','2022-11-08','2022-11-08 19:32:58','2022-11-09 19:32:58','705',0.00,0.00,'705','2022-11-08 19:41:08','705','2022-11-08 19:41:34',10,0),('1','197',257848,'DAILY SHIFT ','2022-11-09','2022-11-09 07:50:42','2022-11-10 07:50:42','705',0.00,0.00,'705','2022-11-09 18:57:14','705','2022-11-09 18:57:30',10,0),('1','197',257849,'DAILY SHIFT','2022-11-10','2022-11-10 07:46:28','2022-11-11 07:46:28','705',0.00,0.00,'705','2022-11-10 19:14:03','705','2022-11-10 19:14:31',10,0),('1','197',257850,'DAILY SHIFT ','2022-11-11','2022-11-11 06:14:38','2022-11-12 06:14:38','705',0.00,0.00,'705','2022-11-11 19:14:13','705','2022-11-11 19:17:51',10,0),('1','197',257851,'DAILY SHIFT ','2022-11-12','2022-11-12 06:29:08','2022-11-13 06:29:08','705',0.00,0.00,'705','2022-11-12 18:44:49','705','2022-11-12 18:45:17',10,0),('1','197',257852,'DAILY SHIFT ','2022-11-13','2022-11-13 06:15:44','2022-11-14 06:15:44','705',0.00,0.00,'705','2022-11-13 19:32:09','705','2022-11-13 19:32:25',10,0),('1','197',257853,'DAILY SHIFT ','2022-11-14','2022-11-14 07:15:54','2022-11-15 07:15:54','705',0.00,0.00,'705','2022-11-14 15:30:14','705','2022-11-14 15:30:28',10,0),('1','197',257854,'0VERAGE','2022-11-14','2022-11-14 15:31:15','2022-11-15 15:31:15','705',0.00,0.00,'705','2022-11-14 15:35:11','705','2022-11-14 15:35:24',10,0),('1','197',257855,' DAILY SHIFT 2ND SALES NEW STOCK','2022-11-14','2022-11-14 15:36:24','2022-11-15 15:36:24','705',0.00,0.00,'705','2022-11-14 19:14:11','705','2022-11-14 19:14:32',10,0),('1','197',257856,'DAILY SHIFT ','2022-11-15','2022-11-15 06:18:13','2022-11-16 06:18:13','705',0.00,0.00,'705','2022-11-15 19:04:06','705','2022-11-15 19:04:26',10,0),('1','197',257857,'DAILY SHIFT ','2022-11-16','2022-11-16 05:54:09','2022-11-17 05:54:09','705',0.00,0.00,'705','2022-11-16 18:50:51','705','2022-11-16 18:51:02',10,0),('1','197',257858,'DAILY SHIFT ','2022-11-17','2022-11-17 06:00:40','2022-11-18 06:00:40','705',0.00,0.00,'705','2022-11-17 19:26:52','705','2022-11-17 19:28:54',10,0),('1','197',257859,'DAILY SHIFT','2022-11-18','2022-11-18 08:57:11','2022-11-19 08:57:11','705',0.00,0.00,'705','2022-11-18 18:47:21','705','2022-11-18 18:47:33',10,0),('1','197',257860,'DAILY SHIFT','2022-11-19','2022-11-19 11:23:31','2022-11-20 11:23:31','705',0.00,0.00,'705','2022-11-19 21:37:24','705','2022-11-19 21:37:42',10,0),('1','197',257861,'DAILY SHIFT ','2022-11-20','2022-11-20 05:58:57','2022-11-21 05:58:57','705',0.00,0.00,'705','2022-11-20 14:31:12','705','2022-11-20 14:31:28',10,0),('1','197',257862,'0PERATIONAL LOSS','2022-11-20','2022-11-20 14:31:52','2022-11-21 14:31:52','705',0.00,0.00,'705','2022-11-20 14:34:07','705','2022-11-20 14:34:23',10,0),('1','197',257863,' DAILY SHIFT 2ND SALES NEW STOCK','2022-11-20','2022-11-20 14:35:01','2022-11-21 14:35:01','705',0.00,0.00,'705','2022-11-20 19:34:51','705','2022-11-20 19:35:20',10,0),('1','197',257864,'DAILY SHIFT','2022-11-21','2022-11-21 05:58:52','2022-11-22 05:58:52','705',0.00,0.00,'705','2022-11-21 19:34:50','705','2022-11-21 19:35:16',10,0),('1','197',257865,'DAILY SHIFT','2022-11-22','2022-11-22 07:16:03','2022-11-23 07:16:03','705',0.00,0.00,'705','2022-11-22 18:55:01','705','2022-11-22 18:55:33',10,0),('1','197',257866,'DAILY SHIFT ','2022-11-23','2022-11-23 06:33:51','2022-11-24 06:33:51','705',0.00,0.00,'705','2022-11-23 18:54:06','705','2022-11-23 18:54:38',10,0),('1','197',257867,'DAILY SHIFT ','2022-11-24','2022-11-24 06:29:40','2022-11-25 06:29:40','705',0.00,0.00,'705','2022-11-24 19:30:50','705','2022-11-24 19:31:09',10,0),('1','197',257868,'DAILY SHIFT ','2022-11-25','2022-11-25 06:34:34','2022-11-26 06:34:34','705',0.00,0.00,'705','2022-11-25 19:00:25','705','2022-11-25 19:00:49',10,0),('1','197',257869,'0PERATIONAL LOSS','2022-11-25','2022-11-25 19:07:05','2022-11-26 19:07:05','705',0.00,0.00,'705','2022-11-25 19:12:35','705','2022-11-25 19:13:13',10,0),('1','197',257870,'DAILY SHIFT NEW STOCK','2022-11-26','2022-11-26 10:36:22','2022-11-27 10:36:22','705',0.00,0.00,'705','2022-11-26 18:50:16','705','2022-11-26 18:51:10',10,0),('1','197',257871,'DAILY SHIFT ','2022-11-27','2022-11-27 05:58:37','2022-11-28 05:58:37','705',0.00,0.00,'705','2022-11-27 19:22:09','705','2022-11-27 19:22:36',10,0),('1','197',257872,'DAILY SHIFT','2022-11-28','2022-11-28 07:08:58','2022-11-29 07:08:58','705',0.00,0.00,'705','2022-11-28 19:59:21','705','2022-11-28 19:59:48',10,0),('1','197',257873,'DAILY SHIFT ','2022-11-29','2022-11-29 06:06:52','2022-11-30 06:06:52','705',0.00,0.00,'705','2022-11-29 19:43:38','705','2022-11-29 19:43:57',10,0),('1','197',257874,'DAILY SHIFT ','2022-11-30','2022-11-30 10:22:00','2022-12-01 10:22:00','705',0.00,0.00,'705','2022-11-30 12:57:56','705','2022-11-30 12:59:37',10,0),('1','197',257875,'0VERAGE','2022-11-30','2022-11-30 13:06:41','2022-12-01 13:06:41','705',0.00,0.00,'705','2022-11-30 13:08:51','705','2022-11-30 13:09:07',10,0),('1','197',257876,' DAILY SHIFT 2ND SALES NEW STOCK','2022-11-30','2022-11-30 13:14:48','2022-12-01 13:14:48','705',0.00,0.00,'705','2022-11-30 20:24:20','705','2022-11-30 20:24:57',10,0),('1','197',257877,'DAILY SHIFT','2022-12-01','2022-12-01 07:03:35','2022-12-02 07:03:35','705',0.00,0.00,'705','2022-12-01 19:19:42','705','2022-12-01 19:20:29',10,0),('1','197',257878,'DAILY SHIFT','2022-12-02','2022-12-02 08:47:23','2022-12-03 08:47:23','705',0.00,0.00,'705','2022-12-02 19:43:37','705','2022-12-02 19:43:50',10,0),('1','197',257879,'DAILY SHIFT','2022-12-03','2022-12-03 08:45:43','2022-12-04 08:45:43','705',0.00,0.00,'705','2022-12-03 20:31:59','705','2022-12-03 20:32:14',10,0),('1','197',257880,'DAILY SHIFT ','2022-12-04','2022-12-04 06:55:07','2022-12-05 06:55:07','705',0.00,0.00,'705','2022-12-04 17:00:00','705','2022-12-04 17:00:32',10,0),('1','197',257881,'0PERATIONAL LOSS','2022-12-04','2022-12-04 17:00:54','2022-12-05 17:00:54','705',0.00,0.00,'705','2022-12-04 17:03:44','705','2022-12-04 17:03:59',10,0),('1','197',257882,'DAILY SHIFT ','2022-12-05','2022-12-05 05:33:00','2022-12-06 05:33:00','705',0.00,0.00,'705','2022-12-05 10:57:32','705','2022-12-05 10:57:58',10,0),('1','197',257883,'DAILY SHIFT','2022-12-05','2022-12-05 10:59:31','2022-12-06 10:59:31','705',0.00,0.00,'705','2022-12-05 19:59:46','705','2022-12-05 20:00:04',10,0),('1','197',257884,'DAILY SHIFT','2022-12-06','2022-12-06 07:55:08','2022-12-07 07:55:08','705',0.00,0.00,'705','2022-12-06 19:52:14','705','2022-12-06 19:52:36',10,0),('1','197',257885,'DAILY SHIFT ','2022-12-07','2022-12-07 06:52:58','2022-12-08 06:52:58','705',0.00,0.00,'705','2022-12-07 19:03:24','705','2022-12-07 19:03:38',10,0),('1','197',257886,'DAILY SHIFT ','2022-12-08','2022-12-08 06:35:22','2022-12-09 06:35:22','705',0.00,0.00,'705','2022-12-08 18:48:22','705','2022-12-08 18:48:39',10,0),('1','197',257887,'0VERAGE','2022-12-08','2022-12-08 18:58:39','2022-12-09 18:58:39','705',0.00,0.00,'705','2022-12-08 19:00:47','705','2022-12-08 19:01:10',10,0),('1','197',257888,'DAILY SHIFT NEW STOCK','2022-12-09','2022-12-09 07:31:57','2022-12-10 07:31:57','705',0.00,0.00,'705','2022-12-09 18:24:34','705','2022-12-09 18:25:32',10,0),('1','197',257889,'DAILY SHIFT','2022-12-10','2022-12-10 11:39:17','2022-12-11 11:39:17','705',0.00,0.00,'705','2022-12-10 19:19:46','705','2022-12-10 19:20:01',10,0),('1','197',257890,'DAILY SHIFT','2022-12-11','2022-12-11 07:12:51','2022-12-12 07:12:51','705',0.00,0.00,'705','2022-12-11 19:15:15','705','2022-12-11 19:15:46',10,0),('1','197',257891,'DAILY SHIFT','2022-12-12','2022-12-12 07:49:49','2022-12-13 07:49:49','705',0.00,0.00,'705','2022-12-12 19:10:07','705','2022-12-12 19:10:24',10,0),('1','197',257892,'DAILY SHIFT','2022-12-13','2022-12-13 07:59:36','2022-12-14 07:59:36','705',0.00,0.00,'705','2022-12-13 18:45:34','705','2022-12-13 18:46:12',10,0),('1','197',257893,'0VERAGE','2022-12-13','2022-12-13 19:15:22','2022-12-14 19:15:22','705',0.00,0.00,'705','2022-12-13 19:16:27','705','2022-12-13 19:16:42',10,0),('1','197',257894,'DAILY SHIFT NEW STOCK','2022-12-14','2022-12-14 08:07:12','2022-12-15 08:07:12','705',0.00,0.00,'705','2022-12-14 19:18:24','705','2022-12-14 19:18:52',10,0),('1','197',257895,'DAILY SHIFT','2022-12-15','2022-12-15 06:50:38','2022-12-16 06:50:38','705',0.00,0.00,'705','2022-12-15 19:14:27','705','2022-12-15 19:15:01',10,0),('1','197',257896,'DAILY SHIFT','2022-12-16','2022-12-16 07:03:34','2022-12-17 07:03:34','705',0.00,0.00,'705','2022-12-16 19:31:19','705','2022-12-16 19:31:38',10,0),('1','197',257897,'DAILY SHIFT','2022-12-17','2022-12-17 07:48:28','2022-12-18 07:48:28','705',0.00,0.00,'705','2022-12-17 19:01:25','705','2022-12-17 19:01:49',10,0),('1','197',257898,'0VERAGE','2022-12-18','2022-12-18 11:03:18','2022-12-19 11:03:18','705',0.00,0.00,'705','2022-12-18 11:04:19','705','2022-12-18 11:04:39',10,0),('1','197',257899,'DAILY SHIFT NEW STOCK','2022-12-18','2022-12-18 11:06:28','2022-12-19 11:06:28','705',0.00,0.00,'705','2022-12-18 19:15:29','705','2022-12-18 19:15:45',10,0),('1','197',257900,'DAILY SHIFT','2022-12-19','2022-12-19 07:02:36','2022-12-20 07:02:36','705',0.00,0.00,'705','2022-12-19 19:01:14','705','2022-12-19 19:01:34',10,0),('1','197',257901,'DAILY SHIFT','2022-12-20','2022-12-20 06:59:19','2022-12-21 06:59:19','705',0.00,0.00,'705','2022-12-20 19:45:35','705','2022-12-20 19:45:56',10,0),('1','197',257902,'DAILY SHIFT','2022-12-21','2022-12-21 06:58:53','2022-12-22 06:58:53','705',0.00,0.00,'705','2022-12-21 14:58:56','705','2022-12-21 14:59:29',10,0),('1','197',257903,'0VERAGE','2022-12-21','2022-12-21 15:07:09','2022-12-22 15:07:09','705',0.00,0.00,'705','2022-12-21 15:08:48','705','2022-12-21 15:09:06',10,0),('1','197',257904,' DAILY SHIFT 2ND SALES NEW STOCK','2022-12-21','2022-12-21 15:13:42','2022-12-22 15:13:42','705',0.00,0.00,'705','2022-12-21 19:19:13','705','2022-12-21 19:19:31',10,0),('1','197',257905,'DAILY SHIFT','2022-12-22','2022-12-22 07:05:06','2022-12-23 07:05:06','705',0.00,0.00,'705','2022-12-22 19:15:23','705','2022-12-22 19:15:57',10,0),('1','197',257906,'DAILY SHIFT','2022-12-23','2022-12-23 07:17:05','2022-12-24 07:17:05','705',0.00,0.00,'705','2022-12-23 17:52:12','705','2022-12-23 17:52:31',10,0),('1','197',257907,'DAILY SHIFT NEW STOCK','2022-12-24','2022-12-24 07:13:37','2022-12-25 07:13:37','705',0.00,0.00,'705','2022-12-24 19:51:33','705','2022-12-24 19:52:06',10,0),('1','197',257908,'DAILY SHIFT','2022-12-25','2022-12-25 07:30:45','2022-12-26 07:30:45','705',0.00,0.00,'705','2022-12-25 19:58:35','705','2022-12-25 19:58:58',10,0),('1','197',257909,'DAILY SHIFT','2022-12-26','2022-12-26 07:40:52','2022-12-27 07:40:52','705',0.00,0.00,'705','2022-12-26 19:07:22','705','2022-12-26 19:08:28',10,0),('1','197',257910,'DAILY SHIFT','2022-12-27','2022-12-27 07:45:37','2022-12-28 07:45:37','705',0.00,0.00,'705','2022-12-27 17:30:08','705','2022-12-27 17:30:49',10,0),('1','197',257911,'0VERAGE','2022-12-27','2022-12-27 17:37:59','2022-12-28 17:37:59','705',0.00,0.00,'705','2022-12-27 17:40:49','705','2022-12-27 17:41:08',10,0),('1','197',257912,'DAILY SHIFT NEW STOCK','2022-12-28','2022-12-28 07:48:46','2022-12-29 07:48:46','705',0.00,0.00,'705','2022-12-28 19:08:15','705','2022-12-28 19:08:33',10,0),('1','197',257913,'DAILY SHIFT','2022-12-29','2022-12-29 07:09:59','2022-12-30 07:09:59','705',0.00,0.00,'705','2022-12-29 20:58:16','705','2022-12-29 20:58:38',10,0),('1','197',257914,'DAILY SHIFT ','2022-12-30','2022-12-30 07:47:34','2022-12-31 07:47:34','705',0.00,0.00,'705','2022-12-30 19:25:17','705','2022-12-30 19:25:34',10,0),('1','197',257915,'DAILY SHIFT ','2022-12-31','2022-12-31 07:15:14','2023-01-01 07:15:14','705',0.00,0.00,'705','2022-12-31 19:48:57','705','2022-12-31 19:49:12',10,0),('1','197',257916,'DAILY SHIFT ','2023-01-01','2023-01-01 05:43:32','2023-01-02 05:43:32','705',0.00,0.00,'705','2023-01-01 19:11:04','705','2023-01-01 19:11:19',10,0),('1','197',257917,'DAILY SHIFT ','2023-01-02','2023-01-02 05:50:31','2023-01-03 05:50:31','705',0.00,0.00,'705','2023-01-02 11:40:16','705','2023-01-02 11:40:31',10,0),('1','197',257918,'0VERAGE','2023-01-02','2023-01-02 11:40:50','2023-01-03 11:40:50','705',0.00,0.00,'705','2023-01-02 11:48:45','705','2023-01-02 11:49:03',10,0),('1','197',257919,' DAILY SHIFT 2ND SALES NEW STOCK','2023-01-02','2023-01-02 11:51:21','2023-01-03 11:51:21','705',0.00,0.00,'705','2023-01-02 19:51:03','705','2023-01-02 19:51:16',10,0),('1','197',257920,'DAILY SHIFT','2023-01-03','2023-01-03 07:26:38','2023-01-04 07:26:38','705',0.00,0.00,'705','2023-01-03 20:03:04','705','2023-01-03 20:03:19',10,0),('1','197',257921,'DAILY SHIFT','2023-01-04','2023-01-04 07:31:20','2023-01-05 07:31:20','705',0.00,0.00,'705','2023-01-04 19:18:51','705','2023-01-04 19:19:08',10,0),('1','197',257922,'DAILY SHIFT ','2023-01-05','2023-01-05 06:35:29','2023-01-06 06:35:29','705',0.00,0.00,'705','2023-01-05 19:30:47','705','2023-01-05 19:31:05',10,0),('1','197',257923,'DAILY SHIFT ','2023-01-06','2023-01-06 06:26:21','2023-01-07 06:26:21','705',0.00,0.00,'705','2023-01-06 19:12:25','705','2023-01-06 19:12:46',10,0),('1','197',257924,'0PERATIONAL LOSS','2023-01-06','2023-01-06 19:17:49','2023-01-07 19:17:49','705',0.00,0.00,'705','2023-01-06 19:23:16','705','2023-01-06 19:23:36',10,0),('1','197',257925,'DAILY SHIFT NEW STOCK ','2023-01-07','2023-01-07 07:19:09','2023-01-08 07:19:09','705',0.00,0.00,'705','2023-01-07 19:29:12','705','2023-01-07 19:29:26',10,0),('1','197',257926,'DAILY SHIFT','2023-01-08','2023-01-08 07:16:17','2023-01-09 07:16:17','705',0.00,0.00,'705','2023-01-08 19:01:28','705','2023-01-08 19:01:44',10,0),('1','197',257927,'DAILY SHIFT','2023-01-09','2023-01-09 07:13:01','2023-01-10 07:13:01','705',0.00,0.00,'705','2023-01-09 20:16:13','705','2023-01-09 20:16:35',10,0),('1','197',257928,'DAILY SHIFT ','2023-01-10','2023-01-10 06:02:22','2023-01-11 06:02:22','705',0.00,0.00,'705','2023-01-10 17:41:40','705','2023-01-10 17:42:17',10,0),('1','197',257929,'0PERATIONAL LOSS','2023-01-10','2023-01-10 17:42:38','2023-01-11 17:42:38','705',0.00,0.00,'705','2023-01-10 17:47:02','705','2023-01-10 17:47:26',10,0),('1','197',257930,'DAILY SHIFT NEW STOCK','2023-01-11','2023-01-11 07:42:54','2023-01-12 07:42:54','705',0.00,0.00,'705','2023-01-11 19:05:15','705','2023-01-11 19:05:41',10,0),('1','197',257931,'DAILY SHIFT ','2023-01-12','2023-01-12 06:04:07','2023-01-13 06:04:07','705',0.00,0.00,'705','2023-01-12 19:26:19','705','2023-01-12 19:26:42',10,0),('1','197',257932,'DAILY SHIFT ','2023-01-13','2023-01-13 07:20:24','2023-01-14 07:20:24','705',0.00,0.00,'705','2023-01-13 19:42:51','705','2023-01-13 19:43:07',10,0),('1','197',257933,'DAILY SHIFT ','2023-01-14','2023-01-14 06:07:53','2023-01-15 06:07:53','705',0.00,0.00,'705','2023-01-14 13:38:36','705','2023-01-14 13:38:53',10,0),('1','197',257934,'0PERATIONAL LOSS','2023-01-14','2023-01-14 13:45:00','2023-01-15 13:45:00','705',0.00,0.00,'705','2023-01-14 13:49:53','705','2023-01-14 13:50:07',10,0),('1','197',257935,' DAILY SHIFT 2ND SALES NEW STOCK','2023-01-14','2023-01-14 13:50:32','2023-01-15 13:50:32','705',0.00,0.00,'705','2023-01-14 19:33:02','705','2023-01-14 19:33:14',10,0),('1','197',257936,'DAILY SHIFT ','2023-01-15','2023-01-15 06:39:00','2023-01-16 06:39:00','705',0.00,0.00,'705','2023-01-15 19:19:06','705','2023-01-15 19:19:21',10,0),('1','197',257937,'DAILY SHIFT ','2023-01-16','2023-01-16 06:51:30','2023-01-17 06:51:30','705',0.00,0.00,'705','2023-01-16 19:56:20','705','2023-01-16 19:56:31',10,0),('1','197',257938,'DAILY SHIFT','2023-01-17','2023-01-17 07:14:31','2023-01-18 07:14:31','705',0.00,0.00,'705','2023-01-17 19:25:12','705','2023-01-17 19:25:26',10,0),('1','197',257939,'DAILY SHIFT ','2023-01-18','2023-01-18 06:39:51','2023-01-19 06:39:51','705',0.00,0.00,'705','2023-01-18 15:29:25','705','2023-01-18 15:29:46',10,0),('1','197',257940,'0VERAGE','2023-01-18','2023-01-18 15:34:18','2023-01-19 15:34:18','705',0.00,0.00,'705','2023-01-18 15:35:19','705','2023-01-18 15:35:39',10,0),('1','197',257941,'DAILY SHIFT NEW STOCK ','2023-01-19','2023-01-19 08:10:55','2023-01-20 08:10:55','705',0.00,0.00,'705','2023-01-19 19:39:51','705','2023-01-19 19:40:06',10,0),('1','197',257942,'DAILY SHIFT ','2023-01-20','2023-01-20 06:34:33','2023-01-21 06:34:33','705',0.00,0.00,'705','2023-01-20 19:38:25','705','2023-01-20 19:38:41',10,0),('1','197',257943,'DAILY SHIFT ','2023-01-21','2023-01-21 07:13:59','2023-01-22 07:13:59','705',0.00,0.00,'705','2023-01-21 18:25:45','705','2023-01-21 18:26:05',10,0),('1','197',257944,'0VERAGE','2023-01-21','2023-01-21 18:26:38','2023-01-22 18:26:38','705',0.00,0.00,'705','2023-01-21 18:33:46','705','2023-01-21 18:34:17',10,0),('1','197',257945,'DAILY SHIFT NEW STOCK ','2023-01-22','2023-01-22 06:53:29','2023-01-23 06:53:29','705',0.00,0.00,'705','2023-01-22 19:49:23','705','2023-01-22 19:49:36',10,0),('1','197',257946,'DAILY SHIFT','2023-01-23','2023-01-23 07:16:05','2023-01-24 07:16:05','705',0.00,0.00,'705','2023-01-23 19:44:17','705','2023-01-23 19:44:32',10,0),('1','197',257947,'DAILY SHIFT ','2023-01-24','2023-01-24 06:12:58','2023-01-25 06:12:58','705',0.00,0.00,'705','2023-01-24 19:44:08','705','2023-01-24 19:44:30',10,0),('1','197',257948,'DAILY SHIFT','2023-01-25','2023-01-25 07:28:14','2023-01-26 07:28:14','705',0.00,0.00,'705','2023-01-25 13:34:15','705','2023-01-25 13:34:35',10,0),('1','197',257949,'0VERAGE','2023-01-25','2023-01-25 14:13:06','2023-01-26 14:13:06','705',0.00,0.00,'705','2023-01-25 14:17:59','705','2023-01-25 14:18:22',10,0),('1','197',257950,' DAILY SHIFT 2ND SALES NEW STOCK','2023-01-25','2023-01-25 16:04:40','2023-01-26 16:04:40','705',0.00,0.00,'705','2023-01-25 19:51:15','705','2023-01-25 19:51:30',10,0),('1','197',257951,'DAILY SHIFT ','2023-01-26','2023-01-26 06:58:20','2023-01-27 06:58:20','705',0.00,0.00,'705','2023-01-26 19:29:18','705','2023-01-26 19:29:32',10,0),('1','197',257952,'DAILY SHIFT ','2023-01-27','2023-01-27 06:19:21','2023-01-28 06:19:21','705',0.00,0.00,'705','2023-01-27 20:06:26','705','2023-01-27 20:06:42',10,0),('1','197',257953,'DAILY SHIFT','2023-01-28','2023-01-28 07:34:36','2023-01-29 07:34:36','705',0.00,0.00,'705','2023-01-28 20:51:55','705','2023-01-28 20:52:10',10,0),('1','197',257954,'DAILY SHIFT ','2023-01-29','2023-01-29 06:21:45','2023-01-30 06:21:45','705',0.00,0.00,'705','2023-01-29 16:46:17','705','2023-01-29 16:46:32',10,0),('1','197',257955,'0PERATIONAL LOSS','2023-01-29','2023-01-29 16:46:49','2023-01-30 16:46:49','705',0.00,0.00,'705','2023-01-29 16:50:40','705','2023-01-29 16:50:59',10,0),('1','197',257956,' DAILY SHIFT 2ND SALES NEW STOCK','2023-01-29','2023-01-29 16:51:57','2023-01-30 16:51:57','705',0.00,0.00,'705','2023-01-29 19:50:22','705','2023-01-29 19:50:35',10,0),('1','197',257957,'DAILY SHIFT','2023-01-30','2023-01-30 09:31:56','2023-01-31 09:31:56','705',0.00,0.00,'705','2023-01-30 20:00:39','705','2023-01-30 20:00:58',10,0),('1','197',257958,'DAILY SHIFT ','2023-01-31','2023-01-31 06:36:04','2023-02-01 06:36:04','705',0.00,0.00,'705','2023-01-31 19:59:59','705','2023-01-31 20:00:13',10,0),('1','197',257959,'DAILY SHIFT ','2023-02-01','2023-02-01 06:12:35','2023-02-02 06:12:35','705',0.00,0.00,'705','2023-02-01 19:48:30','705','2023-02-01 19:48:50',10,0),('1','197',257960,'DAILY SHIFT ','2023-02-02','2023-02-02 06:14:13','2023-02-03 06:14:13','705',0.00,0.00,'705','2023-02-02 20:16:41','705','2023-02-02 20:16:56',10,0),('1','197',257961,'DAILY SHIFT','2023-02-03','2023-02-03 13:16:36','2023-02-04 13:16:36','705',0.00,0.00,'705','2023-02-03 20:44:49','705','2023-02-03 20:45:19',10,0),('1','197',257962,'0VERAGE','2023-02-03','2023-02-03 20:45:47','2023-02-04 20:45:47','705',0.00,0.00,'705','2023-02-03 21:24:37','705','2023-02-03 21:25:24',10,0),('1','197',257963,'DAILY SHIFT NEW STOCK ','2023-02-04','2023-02-04 06:45:04','2023-02-05 06:45:04','705',0.00,0.00,'705','2023-02-04 20:30:24','705','2023-02-04 20:30:40',10,0),('1','197',257964,'DAILY SHIFT ','2023-02-05','2023-02-05 06:28:52','2023-02-06 06:28:52','705',0.00,0.00,'705','2023-02-05 19:54:13','705','2023-02-05 19:54:33',10,0),('1','197',257965,'DAILY SHIFT ','2023-02-06','2023-02-06 06:17:00','2023-02-07 06:17:00','705',0.00,0.00,'705','2023-02-06 21:16:02','705','2023-02-06 21:16:17',10,0),('1','197',257966,'DAILY SHIFT','2023-02-07','2023-02-07 07:42:32','2023-02-08 07:42:32','705',0.00,0.00,'705','2023-02-07 21:16:32','705','2023-02-07 21:16:49',10,0),('1','197',257967,'0VERAGE','2023-02-07','2023-02-07 21:20:00','2023-02-08 21:20:00','705',0.00,0.00,'705','2023-02-07 21:21:20','705','2023-02-07 21:21:36',10,0),('1','197',257968,'DAILY SHIFT NEW STOCK ','2023-02-09','2023-02-09 06:28:06','2023-02-10 06:28:06','705',0.00,0.00,'705','2023-02-09 22:54:17','705','2023-02-09 22:54:48',10,0),('1','197',257969,'DAILY SHIFT ','2023-02-10','2023-02-10 06:48:07','2023-02-11 06:48:07','705',0.00,0.00,'705','2023-02-10 20:33:32','705','2023-02-10 20:33:46',10,0),('1','197',257970,'DAILY SHIFT ','2023-02-11','2023-02-11 06:51:34','2023-02-12 06:51:34','705',0.00,0.00,'705','2023-02-11 21:14:37','705','2023-02-11 21:14:53',10,0),('1','197',257971,'DAILY SHIFT ','2023-02-12','2023-02-12 06:49:52','2023-02-13 06:49:52','705',0.00,0.00,'705','2023-02-12 20:00:24','705','2023-02-12 20:00:40',10,0),('1','197',257972,'DAILY SHIFT ','2023-02-13','2023-02-13 05:34:49','2023-02-14 05:34:49','705',0.00,0.00,'705','2023-02-13 16:59:28','705','2023-02-13 16:59:42',10,0),('1','197',257973,'0VERAGE','2023-02-13','2023-02-13 17:00:03','2023-02-14 17:00:03','705',0.00,0.00,'705','2023-02-13 17:06:02','705','2023-02-13 17:06:16',10,0),('1','197',257974,'DAILY SHIFT NEW STOCK','2023-02-14','2023-02-14 07:04:25','2023-02-15 07:04:25','705',0.00,0.00,'705','2023-02-14 22:23:28','705','2023-02-14 22:23:43',10,0),('1','197',257975,'DAILY SHIFT ','2023-02-15','2023-02-15 06:46:25','2023-02-16 06:46:25','705',0.00,0.00,'705','2023-02-15 20:07:33','705','2023-02-15 20:07:50',10,0),('1','197',257976,'DAILY SHIFT','2023-02-16','2023-02-16 07:35:36','2023-02-17 07:35:36','705',0.00,0.00,'705','2023-02-16 19:38:54','705','2023-02-16 19:39:41',10,0),('1','197',257977,'DAILY SHIFT','2023-02-17','2023-02-17 07:30:44','2023-02-18 07:30:44','705',0.00,0.00,'705','2023-02-18 06:56:40','705','2023-02-18 06:57:11',10,0),('1','197',257978,'DAILY SHIFT ','2023-02-18','2023-02-18 06:57:31','2023-02-19 06:57:31','705',0.00,0.00,'705','2023-02-18 20:18:03','705','2023-02-18 20:19:07',10,0),('1','197',257979,'DAILY SHIFT','2023-02-19','2023-02-19 07:13:50','2023-02-20 07:13:50','705',0.00,0.00,'705','2023-02-19 20:04:01','705','2023-02-19 20:04:44',10,0),('1','197',257980,'DAILY SHIFT','2023-02-20','2023-02-20 10:46:14','2023-02-21 10:46:14','705',0.00,0.00,'705','2023-02-20 19:38:30','705','2023-02-20 19:38:51',10,0),('1','197',257981,'DAILY SHIFT','2023-02-21','2023-02-21 07:16:55','2023-02-22 07:16:55','705',0.00,0.00,'705','2023-02-21 14:16:05','705','2023-02-21 14:16:22',10,0),('1','197',257982,'0VERAGE','2023-02-21','2023-02-21 14:17:12','2023-02-22 14:17:12','705',0.00,0.00,'705','2023-02-21 14:24:37','705','2023-02-21 14:24:55',10,0),('1','197',257983,'DAILY SHIFT NEW STOCK','2023-02-22','2023-02-22 07:52:50','2023-02-23 07:52:50','705',0.00,0.00,'705','2023-02-22 21:49:30','705','2023-02-22 21:49:49',10,0),('1','197',257984,'DAILY SHIFT','2023-02-23','2023-02-23 07:02:18','2023-02-24 07:02:18','705',0.00,0.00,'705','2023-02-23 20:26:13','705','2023-02-23 20:26:55',10,0),('1','197',257985,'DAILY SHIFT','2023-02-24','2023-02-24 07:12:08','2023-02-25 07:12:08','705',0.00,0.00,'705','2023-02-24 20:28:18','705','2023-02-24 20:28:47',10,0),('1','197',257986,'0VERAGE','2023-02-24','2023-02-24 20:29:19','2023-02-25 20:29:19','705',0.00,0.00,'705','2023-02-24 20:36:59','705','2023-02-24 20:38:48',10,0),('1','197',257987,'DAILY SHIFT NEW STOCK','2023-02-26','2023-02-26 11:03:36','2023-02-27 11:03:36','705',0.00,0.00,'705','2023-02-26 19:50:53','705','2023-02-26 19:51:10',10,0),('1','197',257988,'DAILY SHIFT ','2023-02-27','2023-02-27 07:39:25','2023-02-28 07:39:25','705',0.00,0.00,'705','2023-02-27 19:44:52','705','2023-02-27 19:45:08',10,0),('1','197',257989,'DAILY SHIFT ','2023-02-28','2023-02-28 05:06:01','2023-03-01 05:06:01','705',0.00,0.00,'705','2023-02-28 17:33:17','705','2023-02-28 17:33:36',10,0),('1','197',257990,'0VERAGE','2023-02-28','2023-02-28 17:34:02','2023-03-01 17:34:02','705',0.00,0.00,'705','2023-02-28 17:38:48','705','2023-02-28 17:39:03',10,0),('1','197',257991,'DAILY SHIFT NEW STOCK','2023-03-01','2023-03-01 07:17:32','2023-03-02 07:17:32','705',0.00,0.00,'705','2023-03-01 19:47:08','705','2023-03-01 19:47:32',10,0),('1','197',257992,'DAILY SHIFT','2023-03-02','2023-03-02 07:14:03','2023-03-03 07:14:03','705',0.00,0.00,'705','2023-03-02 20:16:52','705','2023-03-02 20:17:10',10,0),('1','197',257993,'DAILY SHIFT','2023-03-03','2023-03-03 07:06:05','2023-03-04 07:06:05','705',0.00,0.00,'705','2023-03-03 19:25:47','705','2023-03-03 19:26:07',10,0),('1','197',257994,'DAILY SHIFT','2023-03-04','2023-03-04 07:09:16','2023-03-05 07:09:16','705',0.00,0.00,'705','2023-03-04 20:07:43','705','2023-03-04 20:08:05',10,0),('1','197',257995,'DAILY SHIFT NEW STOCK','2023-03-05','2023-03-05 07:43:32','2023-03-06 07:43:32','705',0.00,0.00,'705','2023-03-06 07:47:12','705','2023-03-06 07:47:31',10,0),('1','197',257996,'DAILY SHIFT','2023-03-06','2023-03-06 07:48:01','2023-03-07 07:48:01','705',0.00,0.00,'705','2023-03-06 19:52:04','705','2023-03-06 19:52:27',10,0),('1','197',257997,'DAILY SHIFT','2023-03-07','2023-03-07 07:28:04','2023-03-08 07:28:04','705',0.00,0.00,'705','2023-03-07 19:12:53','705','2023-03-07 19:13:16',10,0),('1','197',257998,'DAILY SHIFT','2023-03-08','2023-03-08 07:11:34','2023-03-09 07:11:34','705',0.00,0.00,'705','2023-03-08 11:46:11','705','2023-03-08 11:46:42',10,0),('1','197',257999,'DAILY SHIFT','2023-03-08','2023-03-08 11:57:19','2023-03-09 11:57:19','705',0.00,0.00,'705','2023-03-08 16:12:14','705','2023-03-08 16:16:27',10,0),('1','197',258000,'0VERAGE','2023-03-08','2023-03-08 16:29:42','2023-03-09 16:29:42','705',0.00,0.00,'705','2023-03-08 18:16:46','705','2023-03-08 18:17:10',10,0),('1','197',258001,'DAILY SHIFT NEW STOCK','2023-03-09','2023-03-09 09:43:36','2023-03-10 09:43:36','705',0.00,0.00,'705','2023-03-09 19:46:49','705','2023-03-09 19:47:20',10,0),('1','197',258002,'DAILY SHIFT','2023-03-10','2023-03-10 07:05:47','2023-03-11 07:05:47','705',0.00,0.00,'705','2023-03-10 21:05:56','705','2023-03-10 21:06:12',10,0),('1','197',258003,'DAILY SHIFT ','2023-03-11','2023-03-11 06:18:08','2023-03-12 06:18:08','705',0.00,0.00,'705','2023-03-11 19:33:44','705','2023-03-11 19:34:00',10,0),('1','197',258004,'DAILY SHIFT','2023-03-12','2023-03-12 07:14:54','2023-03-13 07:14:54','705',0.00,0.00,'705','2023-03-12 22:38:54','705','2023-03-12 22:39:20',10,0),('1','197',258005,'DAILY SHIFT','2023-03-13','2023-03-13 08:01:49','2023-03-14 08:01:49','705',0.00,0.00,'705','2023-03-13 10:55:08','705','2023-03-13 10:58:36',10,0),('1','197',258006,'0VERAGE','2023-03-13','2023-03-13 11:34:53','2023-03-14 11:34:53','705',0.00,0.00,'705','2023-03-13 11:45:19','705','2023-03-13 11:45:34',10,0),('1','197',258007,'DAILY SHIFT NEW STOCK','2023-03-13','2023-03-13 11:46:29','2023-03-14 11:46:29','705',0.00,0.00,'705','2023-03-13 23:11:40','705','2023-03-13 23:11:56',10,0),('1','197',258008,'DAILY SHIFT','2023-03-14','2023-03-14 07:04:29','2023-03-15 07:04:29','705',0.00,0.00,'705','2023-03-14 20:49:26','705','2023-03-14 20:49:48',10,0),('1','197',258009,'DAILY SHIFT ','2023-03-15','2023-03-15 05:18:12','2023-03-16 05:18:12','705',0.00,0.00,'705','2023-03-15 20:09:33','705','2023-03-15 20:09:50',10,0),('1','197',258010,'DAILY SHIFT','2023-03-16','2023-03-16 07:27:50','2023-03-17 07:27:50','705',0.00,0.00,'705','2023-03-16 20:05:43','705','2023-03-16 20:06:03',10,0),('1','197',258011,'0VERAGE','2023-03-16','2023-03-16 20:19:52','2023-03-17 20:19:52','705',0.00,0.00,'705','2023-03-16 20:30:01','705','2023-03-16 20:30:22',10,0),('1','197',258012,'DAILY  SHIFT NEW STOCK ','2023-03-17','2023-03-17 08:06:57','2023-03-18 08:06:57','705',0.00,0.00,'705','2023-03-17 18:36:11','705','2023-03-17 18:36:29',10,0),('1','197',258013,'DAILY SHIFT NEW PRICE','2023-03-19','2023-03-19 13:45:05','2023-03-20 13:45:05','705',0.00,0.00,'705','2023-03-19 19:55:07','705','2023-03-19 19:55:29',10,0),('1','197',258014,'DAILY SHIFT','2023-03-20','2023-03-20 11:05:07','2023-03-21 11:05:07','705',0.00,0.00,'705','2023-03-20 19:59:32','705','2023-03-20 19:59:56',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904060 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','197','1018','235481',4525475,'3004','464',0.00,1309.20,0.00,0.00,1309.20,752794.88,0.00,0.00,0.00),('1','197','1018','235483',4525488,'3004','464',1309.20,1449.01,0.00,0.00,139.81,81649.04,0.00,0.00,0.00),('1','197','1018','235484',4525489,'3004','464',1449.01,1636.76,0.00,0.00,187.75,108735.68,0.00,0.00,0.00),('1','197','1018','235485',4525490,'3004','464',1636.76,2326.97,0.00,0.00,690.21,400500.16,0.00,0.00,0.00),('1','197','1018','235700',4529252,'3004','464',2326.97,2648.74,0.00,0.00,321.77,187322.88,0.00,0.00,0.00),('1','197','1018','235987',4534289,'3004','464',2648.74,3296.63,0.00,0.00,647.89,374390.72,0.00,0.00,0.00),('1','197','1018','235992',4534403,'3004','464',3296.63,3636.73,0.00,0.00,340.10,203695.40,0.00,0.00,0.00),('1','197','1018','236452',4542528,'3004','464',3636.73,4148.23,0.00,0.00,511.50,305596.00,0.00,0.00,0.00),('1','197','1018','236457',4542592,'3004','464',4148.23,4692.30,0.00,0.00,544.07,325235.68,0.00,0.00,0.00),('1','197','1018','236460',4542623,'3004','464',4692.30,4692.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','236618',4545308,'3004','464',4692.30,5122.43,0.00,0.00,430.13,257762.16,0.00,0.00,0.00),('1','197','1018','236770',4547692,'3004','464',5122.43,7503.32,0.00,0.00,2380.89,1415921.96,0.00,0.00,0.00),('1','197','1018','237042',4552662,'3004','464',7503.32,8278.84,0.00,0.00,775.52,464108.00,0.00,0.00,0.00),('1','197','1018','237231',4555924,'3004','464',8278.84,8773.00,0.00,0.00,494.16,296496.00,0.00,0.00,0.00),('1','197','1018','237466',4560392,'3004','464',8773.00,9185.55,0.00,0.00,412.55,246867.76,0.00,0.00,0.00),('1','197','1018','237648',4563394,'3004','464',9185.55,9870.32,0.00,0.00,684.77,408718.52,0.00,0.00,0.00),('1','197','1018','237840',4566780,'3004','464',9870.32,9870.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','237976',4568852,'3004','464',9870.32,10219.86,0.00,0.00,349.54,208534.52,0.00,0.00,0.00),('1','197','1018','238087',4570752,'3004','464',10219.86,12079.82,0.00,0.00,1859.96,1115976.00,0.00,0.00,0.00),('1','197','1018','238165',4571816,'3004','464',12079.82,13538.24,0.00,0.00,1458.42,875052.00,0.00,0.00,0.00),('1','197','1018','238453',4576901,'3004','464',13538.24,15170.32,0.00,0.00,1632.08,979248.00,0.00,0.00,0.00),('1','197','1018','238682',4580830,'3004','464',15170.32,15269.06,0.00,0.00,98.74,59244.00,0.00,0.00,0.00),('1','197','1018','238706',4581229,'3004','464',15269.06,17399.26,0.00,0.00,2130.20,1278120.00,0.00,0.00,0.00),('1','197','1018','238916',4584965,'3004','464',17399.26,18729.64,0.00,0.00,1330.38,798228.00,0.00,0.00,0.00),('1','197','1018','239176',4589520,'3004','464',18729.64,20440.32,0.00,0.00,1710.68,1026408.00,0.00,0.00,0.00),('1','197','1018','239270',4591271,'3004','464',20440.32,20440.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','239271',4591272,'3004','464',20440.32,20960.66,0.00,0.00,520.34,312204.00,0.00,0.00,0.00),('1','197','1018','239301',4591594,'3004','464',20960.66,23011.25,0.00,0.00,2050.59,1230354.00,0.00,0.00,0.00),('1','197','1018','239574',4596281,'3004','464',23011.25,24606.88,0.00,0.00,1595.63,957378.00,0.00,0.00,0.00),('1','197','1018','239843',4601059,'3004','464',24606.88,25280.45,0.00,0.00,673.57,404142.00,0.00,0.00,0.00),('1','197','1018','240040',4604381,'3004','464',25280.45,25740.32,0.00,0.00,459.87,275922.00,0.00,0.00,0.00),('1','197','1018','240130',4606125,'3004','464',25740.32,25740.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','240131',4606126,'3004','464',25740.32,25772.54,0.00,0.00,32.22,19332.00,0.00,0.00,0.00),('1','197','1018','240165',4606782,'3004','464',25772.54,26102.46,0.00,0.00,329.92,201210.88,0.00,0.00,0.00),('1','197','1018','240241',4607917,'3004','464',26102.46,28514.51,0.00,0.00,2412.05,1470359.36,0.00,0.00,0.00),('1','197','1018','240538',4612780,'3004','464',28514.51,29683.52,0.00,0.00,1169.01,712190.00,0.00,0.00,0.00),('1','197','1018','240779',4616406,'3004','464',29683.52,30536.18,0.00,0.00,852.66,520489.52,0.00,0.00,0.00),('1','197','1018','241074',4621835,'3004','464',30536.18,30842.54,0.00,0.00,306.36,186636.96,0.00,0.00,0.00),('1','197','1018','241188',4624098,'3004','464',30842.54,30911.87,0.00,0.00,69.33,42152.64,0.00,0.00,0.00),('1','197','1018','241192',4624141,'3004','464',30911.87,31586.20,0.00,0.00,674.33,410374.40,0.00,0.00,0.00),('1','197','1018','241194',4624170,'3004','464',31586.20,31759.88,0.00,0.00,173.68,106031.18,0.00,0.00,0.00),('1','197','1018','241350',4626623,'3004','464',31759.88,32728.60,0.00,0.00,968.72,591609.52,0.00,0.00,0.00),('1','197','1018','241675',4632257,'3004','464',32728.60,33323.33,0.00,0.00,594.73,364372.38,0.00,0.00,0.00),('1','197','1018','241873',4635500,'3004','464',33323.33,35816.53,0.00,0.00,2493.20,1515328.40,0.00,0.00,0.00),('1','197','1018','241999',4637712,'3004','464',35816.53,36134.61,0.00,0.00,318.08,194579.18,0.00,0.00,0.00),('1','197','1018','242067',4639040,'3004','464',36134.61,36134.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','242068',4639041,'3004','464',36134.61,36892.20,0.00,0.00,757.59,462903.34,0.00,0.00,0.00),('1','197','1018','242238',4641997,'3004','464',36892.20,37590.16,0.00,0.00,697.96,429018.36,0.00,0.00,0.00),('1','197','1018','242500',4646629,'3004','464',37590.16,38819.92,0.00,0.00,1229.76,751396.86,0.00,0.00,0.00),('1','197','1018','242744',4650930,'3004','464',38819.92,39674.02,0.00,0.00,854.10,523439.10,0.00,0.00,0.00),('1','197','1018','242973',4654759,'3004','464',39674.02,41324.61,0.00,0.00,1650.59,995288.40,0.00,0.00,0.00),('1','197','1018','243076',4656826,'3004','464',41324.61,41337.97,0.00,0.00,13.36,8229.76,0.00,0.00,0.00),('1','197','1018','243176',4658254,'3004','464',41337.97,43177.57,0.00,0.00,1839.60,1111719.36,0.00,0.00,0.00),('1','197','1018','243392',4662161,'3004','464',43177.57,44524.72,0.00,0.00,1347.15,815690.00,0.00,0.00,0.00),('1','197','1018','243615',4665963,'3004','464',44524.72,46467.21,0.00,0.00,1942.49,1175341.68,0.00,0.00,0.00),('1','197','1018','243847',4670105,'3004','464',46467.21,46577.97,0.00,0.00,110.76,67202.72,0.00,0.00,0.00),('1','197','1018','243914',4671310,'3004','464',46577.97,46605.75,0.00,0.00,27.78,16668.00,0.00,0.00,0.00),('1','197','1018','243918',4671354,'3004','464',46605.75,48094.31,0.00,0.00,1488.56,896800.80,0.00,0.00,0.00),('1','197','1018','244050',4673642,'3004','464',48094.31,48934.72,0.00,0.00,840.41,512190.48,0.00,0.00,0.00),('1','197','1018','244317',4677974,'3004','464',48934.72,50070.81,0.00,0.00,1136.09,689279.44,0.00,0.00,0.00),('1','197','1018','244532',4681862,'3004','464',50070.81,50765.13,0.00,0.00,694.32,423172.80,0.00,0.00,0.00),('1','197','1018','244765',4685726,'3004','464',50765.13,51516.57,0.00,0.00,751.44,457516.80,0.00,0.00,0.00),('1','197','1018','245053',4690916,'3004','464',51516.57,51516.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','245057',4690997,'3004','464',51516.57,52430.68,0.00,0.00,914.11,551275.76,0.00,0.00,0.00),('1','197','1018','245227',4693937,'3004','464',52430.68,53886.17,0.00,0.00,1455.49,868253.12,0.00,0.00,0.00),('1','197','1018','245447',4697767,'3004','464',53886.17,54855.74,0.00,0.00,969.57,581897.12,0.00,0.00,0.00),('1','197','1018','245686',4701938,'3004','464',54855.74,55976.40,0.00,0.00,1120.66,673618.68,0.00,0.00,0.00),('1','197','1018','245997',4706744,'3004','464',55976.40,56486.56,0.00,0.00,510.16,294675.46,0.00,0.00,0.00),('1','197','1018','246118',4708985,'3004','464',56486.56,56893.54,0.00,0.00,406.98,229536.72,0.00,0.00,0.00),('1','197','1018','246151',4709653,'3004','464',56893.54,57228.22,0.00,0.00,334.68,198518.88,0.00,0.00,0.00),('1','197','1018','246212',4710379,'3004','464',57228.22,58080.43,0.00,0.00,852.21,501652.36,0.00,0.00,0.00),('1','197','1018','246478',4714931,'3004','464',58080.43,59505.97,0.00,0.00,1425.54,826192.44,0.00,0.00,0.00),('1','197','1018','246750',4719516,'3004','464',59505.97,60674.71,0.00,0.00,1168.74,678306.40,0.00,0.00,0.00),('1','197','1018','246961',4723277,'3004','464',60674.71,61826.07,0.00,0.00,1151.36,676215.68,0.00,0.00,0.00),('1','197','1018','247167',4726915,'3004','464',61826.07,61941.07,0.00,0.00,115.00,66472.00,0.00,0.00,0.00),('1','197','1018','247235',4728058,'3004','464',61941.07,61941.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','247238',4728078,'3004','464',61941.07,62902.24,0.00,0.00,961.17,562257.68,0.00,0.00,0.00),('1','197','1018','247413',4731169,'3004','464',62902.24,64038.78,0.00,0.00,1136.54,672055.16,0.00,0.00,0.00),('1','197','1018','247672',4735564,'3004','464',64038.78,64188.79,0.00,0.00,150.01,91790.48,0.00,0.00,0.00),('1','197','1018','247747',4736995,'3004','464',64188.79,65342.79,0.00,0.00,1154.00,656851.64,0.00,0.00,0.00),('1','197','1018','247922',4739762,'3004','464',65342.79,66993.38,0.00,0.00,1650.59,944227.28,0.00,0.00,0.00),('1','197','1018','248185',4744240,'3004','464',66993.38,67070.27,0.00,0.00,76.89,45518.88,0.00,0.00,0.00),('1','197','1018','248266',4745749,'3004','464',67070.27,67070.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','248268',4745757,'3004','464',67070.27,67640.19,0.00,0.00,569.92,337392.64,0.00,0.00,0.00),('1','197','1018','248427',4748264,'3004','464',67640.19,69082.77,0.00,0.00,1442.58,834853.20,0.00,0.00,0.00),('1','197','1018','248652',4752059,'3004','464',69082.77,70565.80,0.00,0.00,1483.03,847804.12,0.00,0.00,0.00),('1','197','1018','248888',4756188,'3004','464',70565.80,71129.90,0.00,0.00,564.10,325235.20,0.00,0.00,0.00),('1','197','1018','249023',4758543,'3004','464',71129.90,71701.60,0.00,0.00,571.70,310887.40,0.00,0.00,0.00),('1','197','1018','249135',4760140,'3004','464',71701.60,72434.14,0.00,0.00,732.54,414598.68,0.00,0.00,0.00),('1','197','1018','249313',4763553,'3004','464',72434.14,72434.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','249372',4764239,'3004','464',72434.14,72995.13,0.00,0.00,560.99,325386.52,0.00,0.00,0.00),('1','197','1018','249608',4768272,'3004','464',72995.13,73628.00,0.00,0.00,632.87,357206.04,0.00,0.00,0.00),('1','197','1018','249855',4772511,'3004','464',73628.00,75152.26,0.00,0.00,1524.26,840345.18,0.00,0.00,0.00),('1','197','1018','250134',4776961,'3004','464',75152.26,76241.16,0.00,0.00,1088.90,617154.74,0.00,0.00,0.00),('1','197','1018','250358',4780838,'3004','464',76241.16,77336.71,0.00,0.00,1095.55,603871.66,0.00,0.00,0.00),('1','197','1018','250607',4784964,'3004','464',77336.71,77753.98,0.00,0.00,417.27,231089.84,0.00,0.00,0.00),('1','197','1018','250751',4787746,'3004','464',77753.98,77753.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','250760',4787931,'3004','464',77753.98,77853.47,0.00,0.00,99.49,58898.08,0.00,0.00,0.00),('1','197','1018','250840',4789052,'3004','464',77853.47,78840.53,0.00,0.00,987.06,542007.78,0.00,0.00,0.00),('1','197','1018','251099',4793702,'3004','464',78840.53,79440.94,0.00,0.00,600.41,347597.86,0.00,0.00,0.00),('1','197','1018','251313',4797393,'3004','464',79440.94,80235.05,0.00,0.00,794.11,439330.12,0.00,0.00,0.00),('1','197','1018','251524',4801015,'3004','464',80235.05,81232.35,0.00,0.00,997.30,574246.26,0.00,0.00,0.00),('1','197','1018','251767',4805408,'3004','464',81232.35,82086.70,0.00,0.00,854.35,490006.12,0.00,0.00,0.00),('1','197','1018','252007',4809487,'3004','464',82086.70,82427.19,0.00,0.00,340.49,182596.22,0.00,0.00,0.00),('1','197','1018','252084',4811001,'3004','464',82427.19,82427.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','252090',4811061,'3004','464',82427.19,84120.69,0.00,0.00,1693.50,950256.86,0.00,0.00,0.00),('1','197','1018','252252',4813713,'3004','464',84120.69,84852.49,0.00,0.00,731.80,428296.60,0.00,0.00,0.00),('1','197','1018','252505',4818252,'3004','464',84852.49,85741.28,0.00,0.00,888.79,517173.68,0.00,0.00,0.00),('1','197','1018','252732',4822247,'3004','464',85741.28,86698.47,0.00,0.00,957.19,548583.48,0.00,0.00,0.00),('1','197','1018','252980',4826206,'3004','464',86698.47,87619.33,0.00,0.00,920.86,519063.86,0.00,0.00,0.00),('1','197','1018','253225',4830351,'3004','464',87619.33,87717.74,0.00,0.00,98.41,57194.18,0.00,0.00,0.00),('1','197','1018','253349',4832445,'3004','464',87717.74,87717.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','253354',4832500,'3004','464',87717.74,88299.84,0.00,0.00,582.10,324418.76,0.00,0.00,0.00),('1','197','1018','253489',4834898,'3004','464',88299.84,89401.25,0.00,0.00,1101.41,617124.20,0.00,0.00,0.00),('1','197','1018','253729',4838900,'3004','464',89401.25,91175.00,0.00,0.00,1773.75,973198.92,0.00,0.00,0.00),('1','197','1018','253976',4843233,'3004','464',91175.00,92099.59,0.00,0.00,924.59,518768.72,0.00,0.00,0.00),('1','197','1018','254206',4847485,'3004','464',92099.59,92987.00,0.00,0.00,887.41,474150.88,0.00,0.00,0.00),('1','197','1018','254327',4849593,'3004','464',92987.00,92987.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','254329',4849605,'3004','464',92987.00,94103.86,0.00,0.00,1116.86,610825.76,0.00,0.00,0.00),('1','197','1018','254458',4851781,'3004','464',94103.86,95438.50,0.00,0.00,1334.64,730435.52,0.00,0.00,0.00),('1','197','1018','254719',4856251,'3004','464',95438.50,96364.51,0.00,0.00,926.01,510714.28,0.00,0.00,0.00),('1','197','1018','254964',4860495,'3004','464',96364.51,97850.66,0.00,0.00,1486.15,827006.28,0.00,0.00,0.00),('1','197','1018','255200',4864550,'3004','464',97850.66,98196.99,0.00,0.00,346.33,184343.12,0.00,0.00,0.00),('1','197','1018','255285',4866276,'3004','464',98196.99,98237.72,0.00,0.00,40.73,24112.16,0.00,0.00,0.00),('1','197','1018','255342',4867257,'3004','464',98237.72,99192.40,0.00,0.00,954.68,520861.08,0.00,0.00,0.00),('1','197','1018','255472',4869215,'3004','464',99192.40,100912.03,0.00,0.00,1719.63,943215.52,0.00,0.00,0.00),('1','197','1018','255721',4873329,'3004','464',100912.03,101833.42,0.00,0.00,921.39,521126.36,0.00,0.00,0.00),('1','197','1018','256049',4878801,'3004','464',101833.42,103068.51,0.00,0.00,1235.09,683648.08,0.00,0.00,0.00),('1','197','1018','256332',4883296,'3004','464',103068.51,103691.15,0.00,0.00,622.64,347068.64,0.00,0.00,0.00),('1','197','1018','256409',4884841,'3004','464',103691.15,103691.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','256482',4885962,'3004','464',103691.15,104839.84,0.00,0.00,1148.69,651155.08,0.00,0.00,0.00),('1','197','1018','256741',4890119,'3004','464',104839.84,106320.30,0.00,0.00,1480.46,813732.92,0.00,0.00,0.00),('1','197','1018','257189',4898402,'3004','464',106320.30,107873.17,0.00,0.00,1552.87,855316.12,0.00,0.00,0.00),('1','197','1018','257249',4899239,'3004','464',107873.17,108540.54,0.00,0.00,667.37,378795.00,0.00,0.00,0.00),('1','197','1018','257437',4902861,'3004','464',108540.54,108540.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257444',4902945,'3004','464',108540.54,109126.93,0.00,0.00,586.39,328358.56,0.00,0.00,0.00),('1','197','1018','257492',4903537,'3004','464',109126.93,111078.38,0.00,0.00,1951.45,1042294.84,0.00,0.00,0.00),('1','197','1018','257493',4903538,'3004','464',111078.38,113275.24,0.00,0.00,2196.86,1174315.88,0.00,0.00,0.00),('1','197','1018','257494',4903539,'3004','464',113275.24,113847.16,0.00,0.00,571.92,298336.56,0.00,0.00,0.00),('1','197','1018','257495',4903540,'3004','464',113847.16,113847.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257496',4903541,'3004','464',113847.16,114663.12,0.00,0.00,815.96,443714.24,0.00,0.00,0.00),('1','197','1018','257497',4903542,'3004','464',114663.12,116780.72,0.00,0.00,2117.60,1124989.28,0.00,0.00,0.00),('1','197','1018','257498',4903543,'3004','464',116780.72,118581.11,0.00,0.00,1800.39,959906.08,0.00,0.00,0.00),('1','197','1018','257499',4903544,'3004','464',118581.11,119194.64,0.00,0.00,613.53,323565.66,0.00,0.00,0.00),('1','197','1018','257500',4903545,'3004','464',119194.64,119194.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257501',4903546,'3004','464',119194.64,120160.34,0.00,0.00,965.70,516590.64,0.00,0.00,0.00),('1','197','1018','257502',4903547,'3004','464',120160.34,122530.07,0.00,0.00,2369.73,1267462.02,0.00,0.00,0.00),('1','197','1018','257503',4903548,'3004','464',122530.07,124454.16,0.00,0.00,1924.09,1013342.56,0.00,0.00,0.00),('1','197','1018','257504',4903549,'3004','464',124454.16,124454.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257505',4903550,'3004','464',124454.16,126118.64,0.00,0.00,1664.48,894772.64,0.00,0.00,0.00),('1','197','1018','257506',4903551,'3004','464',126118.64,127354.95,0.00,0.00,1236.31,666648.34,0.00,0.00,0.00),('1','197','1018','257507',4903552,'3004','464',127354.95,129391.89,0.00,0.00,2036.94,1060335.08,0.00,0.00,0.00),('1','197','1018','257508',4903553,'3004','464',129391.89,129391.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257509',4903554,'3004','464',129391.89,129514.24,0.00,0.00,122.35,66119.80,0.00,0.00,0.00),('1','197','1018','257510',4903555,'3004','464',129514.24,130571.11,0.00,0.00,1056.87,565239.96,0.00,0.00,0.00),('1','197','1018','257511',4903556,'3004','464',130571.11,133609.89,0.00,0.00,3038.78,1593259.12,0.00,0.00,0.00),('1','197','1018','257512',4903557,'3004','464',133609.89,133978.72,0.00,0.00,368.83,193768.64,0.00,0.00,0.00),('1','197','1018','257513',4903558,'3004','464',133978.72,133978.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257514',4903559,'3004','464',133978.72,137187.03,0.00,0.00,3208.31,1687621.94,0.00,0.00,0.00),('1','197','1018','257515',4903560,'3004','464',137187.03,138433.08,0.00,0.00,1246.05,660882.78,0.00,0.00,0.00),('1','197','1018','257516',4903561,'3004','464',138433.08,138478.48,0.00,0.00,45.40,25112.20,0.00,0.00,0.00),('1','197','1018','257517',4903562,'3004','464',138478.48,138478.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257518',4903563,'3004','464',138478.48,140180.86,0.00,0.00,1702.38,899732.50,0.00,0.00,0.00),('1','197','1018','257519',4903564,'3004','464',140180.86,140845.66,0.00,0.00,664.80,359354.40,0.00,0.00,0.00),('1','197','1018','257520',4903565,'3004','464',140845.66,142331.93,0.00,0.00,1486.27,791557.30,0.00,0.00,0.00),('1','197','1018','257521',4903566,'3004','464',142331.93,143118.47,0.00,0.00,786.54,425361.54,0.00,0.00,0.00),('1','197','1018','257522',4903567,'3004','464',143118.47,143486.20,0.00,0.00,367.73,189013.22,0.00,0.00,0.00),('1','197','1018','257523',4903568,'3004','464',143486.20,146153.56,0.00,0.00,2667.36,1401284.38,0.00,0.00,0.00),('1','197','1018','257524',4903569,'3004','464',146153.56,147700.15,0.00,0.00,1546.59,826052.34,0.00,0.00,0.00),('1','197','1018','257525',4903570,'3004','464',147700.15,148286.20,0.00,0.00,586.05,320510.94,0.00,0.00,0.00),('1','197','1018','257526',4903571,'3004','464',148286.20,148557.46,0.00,0.00,271.26,139427.64,0.00,0.00,0.00),('1','197','1018','257527',4903572,'3004','464',148557.46,149804.07,0.00,0.00,1246.61,677752.94,0.00,0.00,0.00),('1','197','1018','257528',4903573,'3004','464',149804.07,151194.52,0.00,0.00,1390.45,741221.50,0.00,0.00,0.00),('1','197','1018','257529',4903574,'3004','464',151194.52,152329.50,0.00,0.00,1134.98,607640.30,0.00,0.00,0.00),('1','197','1018','257530',4903575,'3004','464',152329.50,153906.07,0.00,0.00,1576.57,835506.94,0.00,0.00,0.00),('1','197','1018','257531',4903576,'3004','464',153906.07,153906.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257532',4903577,'3004','464',153906.07,156756.36,0.00,0.00,2850.29,1497829.52,0.00,0.00,0.00),('1','197','1018','257533',4903578,'3004','464',156756.36,158081.26,0.00,0.00,1324.90,707967.30,0.00,0.00,0.00),('1','197','1018','257534',4903579,'3004','464',158081.26,158974.08,0.00,0.00,892.82,470232.20,0.00,0.00,0.00),('1','197','1018','257535',4903580,'3004','464',158974.08,160229.12,0.00,0.00,1255.04,671605.64,0.00,0.00,0.00),('1','197','1018','257536',4903581,'3004','464',160229.12,163372.37,0.00,0.00,3143.25,1648356.56,0.00,0.00,0.00),('1','197','1018','257537',4903582,'3004','464',163372.37,163862.89,0.00,0.00,490.52,264232.46,0.00,0.00,0.00),('1','197','1018','257538',4903583,'3004','464',163862.89,163862.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257539',4903584,'3004','464',163862.89,165395.45,0.00,0.00,1532.56,859916.00,0.00,0.00,0.00),('1','197','1018','257540',4903585,'3004','464',165395.45,167313.88,0.00,0.00,1918.43,1062585.80,0.00,0.00,0.00),('1','197','1018','257541',4903586,'3004','464',167313.88,168891.81,0.00,0.00,1577.93,861459.00,0.00,0.00,0.00),('1','197','1018','257542',4903587,'3004','464',168891.81,168891.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257543',4903588,'3004','464',168891.81,169972.14,0.00,0.00,1080.33,596431.00,0.00,0.00,0.00),('1','197','1018','257544',4903589,'3004','464',169972.14,171140.85,0.00,0.00,1168.71,655822.20,0.00,0.00,0.00),('1','197','1018','257545',4903590,'3004','464',171140.85,172482.51,0.00,0.00,1341.66,753599.60,0.00,0.00,0.00),('1','197','1018','257546',4903591,'3004','464',172482.51,174070.60,0.00,0.00,1588.09,870291.80,0.00,0.00,0.00),('1','197','1018','257547',4903592,'3004','464',174070.60,174070.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257548',4903593,'3004','464',174070.60,174758.17,0.00,0.00,687.57,440044.80,0.00,0.00,0.00),('1','197','1018','257549',4903594,'3004','464',174758.17,175447.53,0.00,0.00,689.36,441190.40,0.00,0.00,0.00),('1','197','1018','257550',4903595,'3004','464',175447.53,176080.49,0.00,0.00,632.96,405094.40,0.00,0.00,0.00),('1','197','1018','257551',4903596,'3004','464',176080.49,177159.24,0.00,0.00,1078.75,690400.00,0.00,0.00,0.00),('1','197','1018','257552',4903597,'3004','464',177159.24,178143.76,0.00,0.00,984.52,630092.80,0.00,0.00,0.00),('1','197','1018','257553',4903598,'3004','464',178143.76,179165.35,0.00,0.00,1021.59,653817.60,0.00,0.00,0.00),('1','197','1018','257554',4903599,'3004','464',179165.35,179220.60,0.00,0.00,55.25,37570.00,0.00,0.00,0.00),('1','197','1018','257555',4903600,'3004','464',179220.60,179241.27,0.00,0.00,20.67,14055.60,0.00,0.00,0.00),('1','197','1018','257556',4903601,'3004','464',179241.27,179623.07,0.00,0.00,381.80,257624.00,0.00,0.00,0.00),('1','197','1018','257557',4903602,'3004','464',179623.07,180301.06,0.00,0.00,677.99,456381.60,0.00,0.00,0.00),('1','197','1018','257558',4903603,'3004','464',180301.06,181094.56,0.00,0.00,793.50,533104.80,0.00,0.00,0.00),('1','197','1018','257559',4903604,'3004','464',181094.56,182321.23,0.00,0.00,1226.67,766684.80,0.00,0.00,0.00),('1','197','1018','257560',4903605,'3004','464',182321.23,183576.44,0.00,0.00,1255.21,786727.52,0.00,0.00,0.00),('1','197','1018','257561',4903606,'3004','464',183576.44,184341.27,0.00,0.00,764.83,481334.72,0.00,0.00,0.00),('1','197','1018','257562',4903607,'3004','464',184341.27,184414.71,0.00,0.00,73.44,44651.52,0.00,0.00,0.00),('1','197','1018','257563',4903608,'3004','464',184414.71,185249.81,0.00,0.00,835.10,533129.44,0.00,0.00,0.00),('1','197','1018','257564',4903609,'3004','464',185249.81,186965.46,0.00,0.00,1715.65,1064090.24,0.00,0.00,0.00),('1','197','1018','257565',4903610,'3004','464',186965.46,189224.06,0.00,0.00,2258.60,1385587.52,0.00,0.00,0.00),('1','197','1018','257566',4903611,'3004','464',189224.06,189224.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257567',4903612,'3004','464',189224.06,190369.62,0.00,0.00,1145.56,725062.40,0.00,0.00,0.00),('1','197','1018','257568',4903613,'3004','464',190369.62,192316.62,0.00,0.00,1947.00,1211982.72,0.00,0.00,0.00),('1','197','1018','257569',4903614,'3004','464',192316.62,193535.26,0.00,0.00,1218.64,765331.04,0.00,0.00,0.00),('1','197','1018','257570',4903615,'3004','464',193535.26,193665.25,0.00,0.00,129.99,82952.16,0.00,0.00,0.00),('1','197','1018','257571',4903616,'3004','464',193665.25,194164.05,0.00,0.00,498.80,331368.32,0.00,0.00,0.00),('1','197','1018','257572',4903617,'3004','464',194164.05,194321.74,0.00,0.00,157.69,98398.56,0.00,0.00,0.00),('1','197','1018','257573',4903618,'3004','464',194321.74,194895.39,0.00,0.00,573.65,374982.24,0.00,0.00,0.00),('1','197','1018','257574',4903619,'3004','464',194895.39,195657.79,0.00,0.00,762.40,506163.20,0.00,0.00,0.00),('1','197','1018','257575',4903620,'3004','464',195657.79,196285.34,0.00,0.00,627.55,421194.40,0.00,0.00,0.00),('1','197','1018','257576',4903621,'3004','464',196285.34,197259.44,0.00,0.00,974.10,640600.80,0.00,0.00,0.00),('1','197','1018','257577',4903622,'3004','464',197259.44,198299.66,0.00,0.00,1040.22,666779.32,0.00,0.00,0.00),('1','197','1018','257578',4903623,'3004','464',198299.66,199169.76,0.00,0.00,870.10,559965.52,0.00,0.00,0.00),('1','197','1018','257579',4903624,'3004','464',199169.76,199667.79,0.00,0.00,498.03,313859.00,0.00,0.00,0.00),('1','197','1018','257580',4903625,'3004','464',199667.79,199667.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257581',4903626,'3004','464',199667.79,200568.26,0.00,0.00,900.47,570588.68,0.00,0.00,0.00),('1','197','1018','257582',4903627,'3004','464',200568.26,202379.07,0.00,0.00,1810.81,1156469.12,0.00,0.00,0.00),('1','197','1018','257583',4903628,'3004','464',202379.07,203564.64,0.00,0.00,1185.57,763758.68,0.00,0.00,0.00),('1','197','1018','257584',4903629,'3004','464',203564.64,204441.72,0.00,0.00,877.08,556512.57,0.00,0.00,0.00),('1','197','1018','257585',4903630,'3004','464',204441.72,204441.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257586',4903631,'3004','464',204441.72,204939.72,0.00,0.00,498.00,301290.00,0.00,0.00,0.00),('1','197','1018','257587',4903632,'3004','464',204939.72,205727.09,0.00,0.00,787.37,518383.96,0.00,0.00,0.00),('1','197','1018','257588',4903633,'3004','464',205727.09,206937.40,0.00,0.00,1210.31,773691.54,0.00,0.00,0.00),('1','197','1018','257589',4903634,'3004','464',206937.40,208288.01,0.00,0.00,1350.61,862290.04,0.00,0.00,0.00),('1','197','1018','257590',4903635,'3004','464',208288.01,209309.73,0.00,0.00,1021.72,678422.08,0.00,0.00,0.00),('1','197','1018','257591',4903636,'3004','464',209309.73,209604.04,0.00,0.00,294.31,195421.84,0.00,0.00,0.00),('1','197','1018','257592',4903637,'3004','464',209604.04,209604.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257593',4903638,'3004','464',209604.04,210089.71,0.00,0.00,485.67,322484.88,0.00,0.00,0.00),('1','197','1018','257594',4903639,'3004','464',210089.71,210792.14,0.00,0.00,702.43,466413.52,0.00,0.00,0.00),('1','197','1018','257595',4903640,'3004','464',210792.14,211374.33,0.00,0.00,582.19,386574.16,0.00,0.00,0.00),('1','197','1018','257596',4903641,'3004','464',211374.33,212178.99,0.00,0.00,804.66,534294.24,0.00,0.00,0.00),('1','197','1018','257597',4903642,'3004','464',212178.99,213113.79,0.00,0.00,934.80,620707.20,0.00,0.00,0.00),('1','197','1018','257598',4903643,'3004','464',213113.79,213784.03,0.00,0.00,670.24,445039.36,0.00,0.00,0.00),('1','197','1018','257599',4903644,'3004','464',213784.03,213840.40,0.00,0.00,56.37,37429.68,0.00,0.00,0.00),('1','197','1018','257600',4903645,'3004','464',213840.40,214045.13,0.00,0.00,204.73,135940.72,0.00,0.00,0.00),('1','197','1018','257601',4903646,'3004','464',214045.13,214809.97,0.00,0.00,764.84,507853.76,0.00,0.00,0.00),('1','197','1018','257602',4903647,'3004','464',214809.97,215608.35,0.00,0.00,798.38,530124.32,0.00,0.00,0.00),('1','197','1018','257603',4903648,'3004','464',215608.35,215759.68,0.00,0.00,151.33,100483.12,0.00,0.00,0.00),('1','197','1018','257604',4903649,'3004','464',215759.68,216213.77,0.00,0.00,454.09,279398.50,0.00,0.00,0.00),('1','197','1018','257605',4903650,'3004','464',216213.77,217156.65,0.00,0.00,942.88,607698.58,0.00,0.00,0.00),('1','197','1018','257606',4903651,'3004','464',217156.65,218556.77,0.00,0.00,1400.12,880332.14,0.00,0.00,0.00),('1','197','1018','257607',4903652,'3004','464',218556.77,218556.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257608',4903653,'3004','464',218556.77,220319.36,0.00,0.00,1762.59,1115645.10,0.00,0.00,0.00),('1','197','1018','257609',4903654,'3004','464',220319.36,221877.90,0.00,0.00,1558.54,993602.08,0.00,0.00,0.00),('1','197','1018','257610',4903655,'3004','464',221877.90,222869.84,0.00,0.00,991.94,638980.16,0.00,0.00,0.00),('1','197','1018','257611',4903656,'3004','464',222869.84,223688.09,0.00,0.00,818.25,513519.66,0.00,0.00,0.00),('1','197','1018','257612',4903657,'3004','464',223688.09,223688.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257613',4903658,'3004','464',223688.09,225501.98,0.00,0.00,1813.89,1133071.02,0.00,0.00,0.00),('1','197','1018','257614',4903659,'3004','464',225501.98,226629.28,0.00,0.00,1127.30,724367.24,0.00,0.00,0.00),('1','197','1018','257615',4903660,'3004','464',226629.28,227771.05,0.00,0.00,1141.77,728699.28,0.00,0.00,0.00),('1','197','1018','257616',4903661,'3004','464',227771.05,228775.04,0.00,0.00,1003.99,631351.24,0.00,0.00,0.00),('1','197','1018','257617',4903662,'3004','464',228775.04,228775.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257618',4903663,'3004','464',228775.04,229497.07,0.00,0.00,722.03,459328.28,0.00,0.00,0.00),('1','197','1018','257619',4903664,'3004','464',229497.07,231862.16,0.00,0.00,2365.09,1477339.96,0.00,0.00,0.00),('1','197','1018','257620',4903665,'3004','464',231862.16,233012.99,0.00,0.00,1150.83,730960.38,0.00,0.00,0.00),('1','197','1018','257621',4903666,'3004','464',233012.99,233676.76,0.00,0.00,663.77,415809.80,0.00,0.00,0.00),('1','197','1018','257622',4903667,'3004','464',233676.76,233676.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257623',4903668,'3004','464',233676.76,234264.09,0.00,0.00,587.33,376007.00,0.00,0.00,0.00),('1','197','1018','257624',4903669,'3004','464',234264.09,235594.61,0.00,0.00,1330.52,849708.26,0.00,0.00,0.00),('1','197','1018','257625',4903670,'3004','464',235594.61,236805.77,0.00,0.00,1211.16,775038.24,0.00,0.00,0.00),('1','197','1018','257626',4903671,'3004','464',236805.77,238657.45,0.00,0.00,1851.68,1177801.88,0.00,0.00,0.00),('1','197','1018','257627',4903672,'3004','464',238657.45,238872.54,0.00,0.00,215.09,138344.30,0.00,0.00,0.00),('1','197','1018','257628',4903673,'3004','464',238872.54,238872.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257629',4903674,'3004','464',238872.54,239090.61,0.00,0.00,218.07,144798.48,0.00,0.00,0.00),('1','197','1018','257630',4903675,'3004','464',239090.61,239979.42,0.00,0.00,888.81,590169.84,0.00,0.00,0.00),('1','197','1018','257631',4903676,'3004','464',239979.42,240671.47,0.00,0.00,692.05,459521.20,0.00,0.00,0.00),('1','197','1018','257632',4903677,'3004','464',240671.47,241485.85,0.00,0.00,814.38,540748.32,0.00,0.00,0.00),('1','197','1018','257633',4903678,'3004','464',241485.85,242127.19,0.00,0.00,641.34,425849.76,0.00,0.00,0.00),('1','197','1018','257634',4903679,'3004','464',242127.19,242709.71,0.00,0.00,582.52,386793.28,0.00,0.00,0.00),('1','197','1018','257635',4903680,'3004','464',242709.71,243368.16,0.00,0.00,658.45,437210.80,0.00,0.00,0.00),('1','197','1018','257636',4903681,'3004','464',243368.16,243504.86,0.00,0.00,136.70,90768.80,0.00,0.00,0.00),('1','197','1018','257637',4903682,'3004','464',243504.86,243504.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257638',4903683,'3004','464',243504.86,243504.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257639',4903684,'3004','464',243504.86,243886.30,0.00,0.00,381.44,253276.16,0.00,0.00,0.00),('1','197','1018','257640',4903685,'3004','464',243886.30,244758.53,0.00,0.00,872.23,593116.40,0.00,0.00,0.00),('1','197','1018','257641',4903686,'3004','464',244758.53,245559.46,0.00,0.00,800.93,544632.40,0.00,0.00,0.00),('1','197','1018','257642',4903687,'3004','464',245559.46,246705.62,0.00,0.00,1146.16,779388.80,0.00,0.00,0.00),('1','197','1018','257643',4903688,'3004','464',246705.62,247429.56,0.00,0.00,723.94,492279.20,0.00,0.00,0.00),('1','197','1018','257644',4903689,'3004','464',247429.56,248346.82,0.00,0.00,917.26,623736.80,0.00,0.00,0.00),('1','197','1018','257645',4903690,'3004','464',248346.82,248464.84,0.00,0.00,118.02,80253.60,0.00,0.00,0.00),('1','197','1018','257646',4903691,'3004','464',248464.84,248500.60,0.00,0.00,35.76,24316.80,0.00,0.00,0.00),('1','197','1018','257647',4903692,'3004','464',248500.60,249001.56,0.00,0.00,500.96,340652.80,0.00,0.00,0.00),('1','197','1018','257648',4903693,'3004','464',249001.56,250036.34,0.00,0.00,1034.78,703650.40,0.00,0.00,0.00),('1','197','1018','257649',4903694,'3004','464',250036.34,250949.43,0.00,0.00,913.09,620901.20,0.00,0.00,0.00),('1','197','1018','257650',4903695,'3004','464',250949.43,251631.33,0.00,0.00,681.90,463692.00,0.00,0.00,0.00),('1','197','1018','257651',4903696,'3004','464',251631.33,252440.79,0.00,0.00,809.46,571459.00,0.00,0.00,0.00),('1','197','1018','257652',4903697,'3004','464',252440.79,253302.07,0.00,0.00,861.28,617799.60,0.00,0.00,0.00),('1','197','1018','257653',4903698,'3004','464',253302.07,253683.72,0.00,0.00,381.65,263647.13,0.00,0.00,0.00),('1','197','1018','257654',4903699,'3004','464',253683.72,253683.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257655',4903700,'3004','464',253683.72,254354.29,0.00,0.00,670.57,465313.27,0.00,0.00,0.00),('1','197','1018','257656',4903701,'3004','464',254354.29,257317.17,0.00,0.00,2962.88,2050970.74,0.00,0.00,0.00),('1','197','1018','257657',4903702,'3004','464',257317.17,258291.73,0.00,0.00,974.56,684849.13,0.00,0.00,0.00),('1','197','1018','257658',4903703,'3004','464',258291.73,258729.91,0.00,0.00,438.18,303863.69,0.00,0.00,0.00),('1','197','1018','257659',4903704,'3004','464',258729.91,258729.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257660',4903705,'3004','464',258729.91,259012.89,0.00,0.00,282.98,203745.60,0.00,0.00,0.00),('1','197','1018','257661',4903706,'3004','464',259012.89,261509.18,0.00,0.00,2496.29,1811589.20,0.00,0.00,0.00),('1','197','1018','257662',4903707,'3004','464',261509.18,262711.09,0.00,0.00,1201.91,869381.00,0.00,0.00,0.00),('1','197','1018','257663',4903708,'3004','464',262711.09,262711.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257664',4903709,'3004','464',262711.09,262937.89,0.00,0.00,226.80,169488.00,0.00,0.00,0.00),('1','197','1018','257665',4903710,'3004','464',262937.89,264583.91,0.00,0.00,1646.02,1217084.20,0.00,0.00,0.00),('1','197','1018','257666',4903711,'3004','464',264583.91,266375.59,0.00,0.00,1791.68,1306383.20,0.00,0.00,0.00),('1','197','1018','257667',4903712,'3004','464',266375.59,267879.44,0.00,0.00,1503.85,1108376.80,0.00,0.00,0.00),('1','197','1018','257668',4903713,'3004','464',267879.44,267879.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257669',4903714,'3004','464',267879.44,269374.18,0.00,0.00,1494.74,1091842.40,0.00,0.00,0.00),('1','197','1018','257670',4903715,'3004','464',269374.18,269515.03,0.00,0.00,140.85,107046.00,0.00,0.00,0.00),('1','197','1018','257671',4903716,'3004','464',269515.03,270165.43,0.00,0.00,650.40,494304.00,0.00,0.00,0.00),('1','197','1018','257672',4903717,'3004','464',270165.43,270779.39,0.00,0.00,613.96,466609.60,0.00,0.00,0.00),('1','197','1018','257673',4903718,'3004','464',270779.39,271719.36,0.00,0.00,939.97,714377.20,0.00,0.00,0.00),('1','197','1018','257674',4903719,'3004','464',271719.36,272605.33,0.00,0.00,885.97,673337.20,0.00,0.00,0.00),('1','197','1018','257675',4903720,'3004','464',272605.33,273037.85,0.00,0.00,432.52,328715.20,0.00,0.00,0.00),('1','197','1018','257676',4903721,'3004','464',273037.85,273037.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257677',4903722,'3004','464',273037.85,273944.51,0.00,0.00,906.66,689061.60,0.00,0.00,0.00),('1','197','1018','257678',4903723,'3004','464',273944.51,274623.89,0.00,0.00,679.38,516328.80,0.00,0.00,0.00),('1','197','1018','257679',4903724,'3004','464',274623.89,275571.03,0.00,0.00,947.14,719826.40,0.00,0.00,0.00),('1','197','1018','257680',4903725,'3004','464',275571.03,276122.38,0.00,0.00,551.35,419026.00,0.00,0.00,0.00),('1','197','1018','257681',4903726,'3004','464',276122.38,276847.06,0.00,0.00,724.68,550756.80,0.00,0.00,0.00),('1','197','1018','257682',4903727,'3004','464',276847.06,277731.85,0.00,0.00,884.79,672440.40,0.00,0.00,0.00),('1','197','1018','257683',4903728,'3004','464',277731.85,278123.39,0.00,0.00,391.54,298810.40,0.00,0.00,0.00),('1','197','1018','257684',4903729,'3004','464',278123.39,278123.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257685',4903730,'3004','464',278123.39,278673.30,0.00,0.00,549.91,417931.60,0.00,0.00,0.00),('1','197','1018','257686',4903731,'3004','464',278673.30,280014.82,0.00,0.00,1341.52,1019555.20,0.00,0.00,0.00),('1','197','1018','257687',4903732,'3004','464',280014.82,281046.45,0.00,0.00,1031.63,784038.80,0.00,0.00,0.00),('1','197','1018','257688',4903733,'3004','464',281046.45,282233.49,0.00,0.00,1187.04,902150.40,0.00,0.00,0.00),('1','197','1018','257689',4903734,'3004','464',282233.49,282905.32,0.00,0.00,671.83,510590.80,0.00,0.00,0.00),('1','197','1018','257690',4903735,'3004','464',282905.32,283256.10,0.00,0.00,350.78,266592.80,0.00,0.00,0.00),('1','197','1018','257691',4903736,'3004','464',283256.10,283256.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257692',4903737,'3004','464',283256.10,283256.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257693',4903738,'3004','464',283256.10,283518.72,0.00,0.00,262.62,199591.20,0.00,0.00,0.00),('1','197','1018','257694',4903739,'3004','464',283518.72,284220.00,0.00,0.00,701.28,532972.80,0.00,0.00,0.00),('1','197','1018','257695',4903740,'3004','464',284220.00,285499.96,0.00,0.00,1279.96,972769.60,0.00,0.00,0.00),('1','197','1018','257696',4903741,'3004','464',285499.96,286324.89,0.00,0.00,824.93,626946.80,0.00,0.00,0.00),('1','197','1018','257697',4903742,'3004','464',286324.89,286619.46,0.00,0.00,294.57,223873.20,0.00,0.00,0.00),('1','197','1018','257698',4903743,'3004','464',286619.46,287022.18,0.00,0.00,402.72,306067.20,0.00,0.00,0.00),('1','197','1018','257699',4903744,'3004','464',287022.18,287936.28,0.00,0.00,914.10,694716.00,0.00,0.00,0.00),('1','197','1018','257700',4903745,'3004','464',287936.28,288655.20,0.00,0.00,718.92,546379.20,0.00,0.00,0.00),('1','197','1018','257701',4903746,'3004','464',288655.20,288655.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257702',4903747,'3004','464',288655.20,289557.13,0.00,0.00,901.93,685466.80,0.00,0.00,0.00),('1','197','1018','257703',4903748,'3004','464',289557.13,290914.26,0.00,0.00,1357.13,1031418.80,0.00,0.00,0.00),('1','197','1018','257704',4903749,'3004','464',290914.26,292455.36,0.00,0.00,1541.10,1159636.00,0.00,0.00,0.00),('1','197','1018','257705',4903750,'3004','464',292455.36,293527.53,0.00,0.00,1072.17,801009.20,0.00,0.00,0.00),('1','197','1018','257706',4903751,'3004','464',293527.53,293824.35,0.00,0.00,296.82,225583.20,0.00,0.00,0.00),('1','197','1018','257707',4903752,'3004','464',293824.35,293824.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257708',4903753,'3004','464',293824.35,294316.35,0.00,0.00,492.00,373920.00,0.00,0.00,0.00),('1','197','1018','257709',4903754,'3004','464',294316.35,295093.82,0.00,0.00,777.47,590877.20,0.00,0.00,0.00),('1','197','1018','257710',4903755,'3004','464',295093.82,295934.43,0.00,0.00,840.61,638863.60,0.00,0.00,0.00),('1','197','1018','257711',4903756,'3004','464',295934.43,296461.95,0.00,0.00,527.52,400915.20,0.00,0.00,0.00),('1','197','1018','257712',4903757,'3004','464',296461.95,297238.62,0.00,0.00,776.67,590269.20,0.00,0.00,0.00),('1','197','1018','257713',4903758,'3004','464',297238.62,297950.53,0.00,0.00,711.91,541051.60,0.00,0.00,0.00),('1','197','1018','257714',4903759,'3004','464',297950.53,298642.48,0.00,0.00,691.95,521561.04,0.00,0.00,0.00),('1','197','1018','257715',4903760,'3004','464',298642.48,298774.33,0.00,0.00,131.85,98626.80,0.00,0.00,0.00),('1','197','1018','257716',4903761,'3004','464',298774.33,298785.09,0.00,0.00,10.76,7661.12,0.00,0.00,0.00),('1','197','1018','257717',4903762,'3004','464',298785.09,298785.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257718',4903763,'3004','464',298785.09,299515.39,0.00,0.00,730.30,551915.68,0.00,0.00,0.00),('1','197','1018','257719',4903764,'3004','464',299515.39,300533.04,0.00,0.00,1017.65,764942.00,0.00,0.00,0.00),('1','197','1018','257720',4903765,'3004','464',300533.04,301229.56,0.00,0.00,696.52,525943.84,0.00,0.00,0.00),('1','197','1018','257721',4903766,'3004','464',301229.56,302234.05,0.00,0.00,1004.49,740470.76,0.00,0.00,0.00),('1','197','1018','257722',4903767,'3004','464',302234.05,303448.35,0.00,0.00,1214.30,894178.20,0.00,0.00,0.00),('1','197','1018','257723',4903768,'3004','464',303448.35,304078.71,0.00,0.00,630.36,448494.57,0.00,0.00,0.00),('1','197','1018','257724',4903769,'3004','464',304078.71,304078.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257725',4903770,'3004','464',304078.71,304760.58,0.00,0.00,681.87,499580.55,0.00,0.00,0.00),('1','197','1018','257726',4903771,'3004','464',304760.58,306452.10,0.00,0.00,1691.52,1221596.82,0.00,0.00,0.00),('1','197','1018','257727',4903772,'3004','464',306452.10,307950.12,0.00,0.00,1498.02,1089144.88,0.00,0.00,0.00),('1','197','1018','257728',4903773,'3004','464',307950.12,309248.57,0.00,0.00,1298.45,946298.82,0.00,0.00,0.00),('1','197','1018','257729',4903774,'3004','464',309248.57,309259.98,0.00,0.00,11.41,8489.04,0.00,0.00,0.00),('1','197','1018','257730',4903775,'3004','464',309259.98,309259.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257731',4903776,'3004','464',309259.98,310038.68,0.00,0.00,778.70,574452.80,0.00,0.00,0.00),('1','197','1018','257732',4903777,'3004','464',310038.68,310831.58,0.00,0.00,792.90,578872.02,0.00,0.00,0.00),('1','197','1018','257733',4903778,'3004','464',310831.58,312568.47,0.00,0.00,1736.89,1271274.16,0.00,0.00,0.00),('1','197','1018','257734',4903779,'3004','464',312568.47,314342.37,0.00,0.00,1773.90,1266416.19,0.00,0.00,0.00),('1','197','1018','257735',4903780,'3004','464',314342.37,314342.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257736',4903781,'3004','464',314342.37,316184.03,0.00,0.00,1841.66,1336100.84,0.00,0.00,0.00),('1','197','1018','257737',4903782,'3004','464',316184.03,317599.66,0.00,0.00,1415.63,1037254.72,0.00,0.00,0.00),('1','197','1018','257738',4903783,'3004','464',317599.66,318616.64,0.00,0.00,1016.98,751096.12,0.00,0.00,0.00),('1','197','1018','257739',4903784,'3004','464',318616.64,319461.07,0.00,0.00,844.43,599743.51,0.00,0.00,0.00),('1','197','1018','257740',4903785,'3004','464',319461.07,319461.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257741',4903786,'3004','464',319461.07,320330.87,0.00,0.00,869.80,612673.25,0.00,0.00,0.00),('1','197','1018','257742',4903787,'3004','464',320330.87,324558.62,0.00,0.00,4227.75,2978922.83,0.00,0.00,0.00),('1','197','1018','257743',4903788,'3004','464',324558.62,324558.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257744',4903789,'3004','464',324558.62,326072.64,0.00,0.00,1514.02,1100308.98,0.00,0.00,0.00),('1','197','1018','257745',4903790,'3004','464',326072.64,326767.34,0.00,0.00,694.70,522414.40,0.00,0.00,0.00),('1','197','1018','257746',4903791,'3004','464',326767.34,327308.43,0.00,0.00,541.09,406899.68,0.00,0.00,0.00),('1','197','1018','257747',4903792,'3004','464',327308.43,328186.91,0.00,0.00,878.48,660616.96,0.00,0.00,0.00),('1','197','1018','257748',4903793,'3004','464',328186.91,328958.60,0.00,0.00,771.69,580310.88,0.00,0.00,0.00),('1','197','1018','257749',4903794,'3004','464',328958.60,328990.56,0.00,0.00,31.96,24033.92,0.00,0.00,0.00),('1','197','1018','257750',4903795,'3004','464',328990.56,329833.32,0.00,0.00,842.76,633755.52,0.00,0.00,0.00),('1','197','1018','257751',4903796,'3004','464',329833.32,330798.27,0.00,0.00,964.95,725642.40,0.00,0.00,0.00),('1','197','1018','257752',4903797,'3004','464',330798.27,331692.74,0.00,0.00,894.47,672641.44,0.00,0.00,0.00),('1','197','1018','257753',4903798,'3004','464',331692.74,332554.57,0.00,0.00,861.83,648096.16,0.00,0.00,0.00),('1','197','1018','257754',4903799,'3004','464',332554.57,333948.83,0.00,0.00,1394.26,1020601.44,0.00,0.00,0.00),('1','197','1018','257755',4903800,'3004','464',333948.83,334500.71,0.00,0.00,551.88,393292.72,0.00,0.00,0.00),('1','197','1018','257756',4903801,'3004','464',334500.71,334560.56,0.00,0.00,59.85,42493.50,0.00,0.00,0.00),('1','197','1018','257757',4903802,'3004','464',334560.56,335374.60,0.00,0.00,814.04,601990.76,0.00,0.00,0.00),('1','197','1018','257758',4903803,'3004','464',335374.60,336778.61,0.00,0.00,1404.01,1024200.44,0.00,0.00,0.00),('1','197','1018','257759',4903804,'3004','464',336778.61,338001.01,0.00,0.00,1222.40,888289.04,0.00,0.00,0.00),('1','197','1018','257760',4903805,'3004','464',338001.01,339363.31,0.00,0.00,1362.30,991334.58,0.00,0.00,0.00),('1','197','1018','257761',4903806,'3004','464',339363.31,339490.56,0.00,0.00,127.25,90347.50,0.00,0.00,0.00),('1','197','1018','257762',4903807,'3004','464',339490.56,340712.89,0.00,0.00,1222.33,903118.08,0.00,0.00,0.00),('1','197','1018','257763',4903808,'3004','464',340712.89,341828.45,0.00,0.00,1115.56,822275.64,0.00,0.00,0.00),('1','197','1018','257764',4903809,'3004','464',341828.45,343072.52,0.00,0.00,1244.07,908536.74,0.00,0.00,0.00),('1','197','1018','257765',4903810,'3004','464',343072.52,344238.43,0.00,0.00,1165.91,862915.04,0.00,0.00,0.00),('1','197','1018','257766',4903811,'3004','464',344238.43,344617.51,0.00,0.00,379.08,278299.94,0.00,0.00,0.00),('1','197','1018','257767',4903812,'3004','464',344617.51,344617.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257768',4903813,'3004','464',344617.51,344617.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257769',4903814,'3004','464',344617.51,346068.05,0.00,0.00,1450.54,1060552.42,0.00,0.00,0.00),('1','197','1018','257770',4903815,'3004','464',346068.05,347223.29,0.00,0.00,1155.24,854364.56,0.00,0.00,0.00),('1','197','1018','257771',4903816,'3004','464',347223.29,348332.63,0.00,0.00,1109.34,818278.66,0.00,0.00,0.00),('1','197','1018','257772',4903817,'3004','464',348332.63,349807.96,0.00,0.00,1475.33,1077542.34,0.00,0.00,0.00),('1','197','1018','257773',4903818,'3004','464',349807.96,349807.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257774',4903819,'3004','464',349807.96,351003.23,0.00,0.00,1195.27,876564.88,0.00,0.00,0.00),('1','197','1018','257775',4903820,'3004','464',351003.23,353034.56,0.00,0.00,2031.33,1477028.34,0.00,0.00,0.00),('1','197','1018','257776',4903821,'3004','464',353034.56,354795.27,0.00,0.00,1760.71,1296398.16,0.00,0.00,0.00),('1','197','1018','257777',4903822,'3004','464',354795.27,354795.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257778',4903823,'3004','464',354795.27,356145.47,0.00,0.00,1350.20,988444.70,0.00,0.00,0.00),('1','197','1018','257779',4903824,'3004','464',356145.47,358022.87,0.00,0.00,1877.40,1378737.38,0.00,0.00,0.00),('1','197','1018','257780',4903825,'3004','464',358022.87,359237.66,0.00,0.00,1214.79,884715.24,0.00,0.00,0.00),('1','197','1018','257781',4903826,'3004','464',359237.66,360126.80,0.00,0.00,889.14,641253.76,0.00,0.00,0.00),('1','197','1018','257782',4903827,'3004','464',360126.80,360126.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257783',4903828,'3004','464',360126.80,361959.10,0.00,0.00,1832.30,1320536.24,0.00,0.00,0.00),('1','197','1018','257784',4903829,'3004','464',361959.10,362851.44,0.00,0.00,892.34,663900.96,0.00,0.00,0.00),('1','197','1018','257785',4903830,'3004','464',362851.44,363813.33,0.00,0.00,961.89,715646.16,0.00,0.00,0.00),('1','197','1018','257786',4903831,'3004','464',363813.33,364250.39,0.00,0.00,437.06,325172.64,0.00,0.00,0.00),('1','197','1018','257787',4903832,'3004','464',364250.39,364250.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257788',4903833,'3004','464',364250.39,364890.58,0.00,0.00,640.19,476301.36,0.00,0.00,0.00),('1','197','1018','257789',4903834,'3004','464',364890.58,365604.47,0.00,0.00,713.89,531134.16,0.00,0.00,0.00),('1','197','1018','257790',4903835,'3004','464',365604.47,365988.50,0.00,0.00,384.03,285718.32,0.00,0.00,0.00),('1','197','1018','257791',4903836,'3004','464',365988.50,367102.42,0.00,0.00,1113.92,819845.12,0.00,0.00,0.00),('1','197','1018','257792',4903837,'3004','464',367102.42,367684.35,0.00,0.00,581.93,428300.48,0.00,0.00,0.00),('1','197','1018','257793',4903838,'3004','464',367684.35,367684.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257794',4903839,'3004','464',367684.35,368406.24,0.00,0.00,721.89,531311.04,0.00,0.00,0.00),('1','197','1018','257795',4903840,'3004','464',368406.24,369139.08,0.00,0.00,732.84,539370.24,0.00,0.00,0.00),('1','197','1018','257796',4903841,'3004','464',369139.08,370173.73,0.00,0.00,1034.65,761502.40,0.00,0.00,0.00),('1','197','1018','257797',4903842,'3004','464',370173.73,371000.72,0.00,0.00,826.99,608664.64,0.00,0.00,0.00),('1','197','1018','257798',4903843,'3004','464',371000.72,372054.69,0.00,0.00,1053.97,775721.92,0.00,0.00,0.00),('1','197','1018','257799',4903844,'3004','464',372054.69,372723.93,0.00,0.00,669.24,492560.64,0.00,0.00,0.00),('1','197','1018','257800',4903845,'3004','464',372723.93,372723.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257801',4903846,'3004','464',372723.93,373778.34,0.00,0.00,1054.41,776045.76,0.00,0.00,0.00),('1','197','1018','257802',4903847,'3004','464',373778.34,375061.63,0.00,0.00,1283.29,937451.20,0.00,0.00,0.00),('1','197','1018','257803',4903848,'3004','464',375061.63,376835.49,0.00,0.00,1773.86,1270892.96,0.00,0.00,0.00),('1','197','1018','257804',4903849,'3004','464',376835.49,377494.33,0.00,0.00,658.84,475726.24,0.00,0.00,0.00),('1','197','1018','257805',4903850,'3004','464',377494.33,377534.26,0.00,0.00,39.93,29388.48,0.00,0.00,0.00),('1','197','1018','257806',4903851,'3004','464',377534.26,379388.25,0.00,0.00,1853.99,1341447.68,0.00,0.00,0.00),('1','197','1018','257807',4903852,'3004','464',379388.25,380898.21,0.00,0.00,1509.96,1091942.76,0.00,0.00,0.00),('1','197','1018','257808',4903853,'3004','464',380898.21,382015.66,0.00,0.00,1117.45,817194.04,0.00,0.00,0.00),('1','197','1018','257809',4903854,'3004','464',382015.66,382543.26,0.00,0.00,527.60,388313.60,0.00,0.00,0.00),('1','197','1018','257810',4903855,'3004','464',382543.26,382543.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257811',4903856,'3004','464',382543.26,383301.95,0.00,0.00,758.69,558395.84,0.00,0.00,0.00),('1','197','1018','257812',4903857,'3004','464',383301.95,384060.67,0.00,0.00,758.72,558417.92,0.00,0.00,0.00),('1','197','1018','257813',4903858,'3004','464',384060.67,385080.77,0.00,0.00,1020.10,750793.60,0.00,0.00,0.00),('1','197','1018','257814',4903859,'3004','464',385080.77,385891.59,0.00,0.00,810.82,596763.52,0.00,0.00,0.00),('1','197','1018','257815',4903860,'3004','464',385891.59,386774.96,0.00,0.00,883.37,650160.32,0.00,0.00,0.00),('1','197','1018','257816',4903861,'3004','464',386774.96,386774.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257817',4903862,'3004','464',386774.96,388167.88,0.00,0.00,1392.92,1041904.16,0.00,0.00,0.00),('1','197','1018','257818',4903863,'3004','464',388167.88,389773.83,0.00,0.00,1605.95,1201250.60,0.00,0.00,0.00),('1','197','1018','257819',4903864,'3004','464',389773.83,390726.06,0.00,0.00,952.23,712268.04,0.00,0.00,0.00),('1','197','1018','257820',4903865,'3004','464',390726.06,390816.76,0.00,0.00,90.70,67843.60,0.00,0.00,0.00),('1','197','1018','257821',4903866,'3004','464',390816.76,390816.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257822',4903867,'3004','464',390816.76,391200.61,0.00,0.00,383.85,287119.80,0.00,0.00,0.00),('1','197','1018','257823',4903868,'3004','464',391200.61,392222.72,0.00,0.00,1022.11,764538.28,0.00,0.00,0.00),('1','197','1018','257824',4903869,'3004','464',392222.72,393119.65,0.00,0.00,896.93,670903.64,0.00,0.00,0.00),('1','197','1018','257825',4903870,'3004','464',393119.65,394007.30,0.00,0.00,887.65,663962.20,0.00,0.00,0.00),('1','197','1018','257826',4903871,'3004','464',394007.30,395068.68,0.00,0.00,1061.38,806648.80,0.00,0.00,0.00),('1','197','1018','257827',4903872,'3004','464',395068.68,395980.67,0.00,0.00,911.99,693112.40,0.00,0.00,0.00),('1','197','1018','257828',4903873,'3004','464',395980.67,395980.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257829',4903874,'3004','464',395980.67,397281.96,0.00,0.00,1301.29,988980.40,0.00,0.00,0.00),('1','197','1018','257830',4903875,'3004','464',397281.96,398785.23,0.00,0.00,1503.27,1142485.20,0.00,0.00,0.00),('1','197','1018','257831',4903876,'3004','464',398785.23,400242.93,0.00,0.00,1457.70,1107852.00,0.00,0.00,0.00),('1','197','1018','257832',4903877,'3004','464',400242.93,401410.65,0.00,0.00,1167.72,887467.20,0.00,0.00,0.00),('1','197','1018','257833',4903878,'3004','464',401410.65,401410.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257834',4903879,'3004','464',401410.65,402108.31,0.00,0.00,697.66,530221.60,0.00,0.00,0.00),('1','197','1018','257835',4903880,'3004','464',402108.31,402913.66,0.00,0.00,805.35,644280.00,0.00,0.00,0.00),('1','197','1018','257836',4903881,'3004','464',402913.66,404101.87,0.00,0.00,1188.21,950568.00,0.00,0.00,0.00),('1','197','1018','257837',4903882,'3004','464',404101.87,404917.30,0.00,0.00,815.43,652344.00,0.00,0.00,0.00),('1','197','1018','257838',4903883,'3004','464',404917.30,405932.76,0.00,0.00,1015.46,780362.00,0.00,0.00,0.00),('1','197','1018','257839',4903884,'3004','464',405932.76,406341.41,0.00,0.00,408.65,310574.00,0.00,0.00,0.00),('1','197','1018','257840',4903885,'3004','464',406341.41,406341.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257841',4903886,'3004','464',406341.41,406857.41,0.00,0.00,516.00,392160.00,0.00,0.00,0.00),('1','197','1018','257842',4903887,'3004','464',406857.41,407987.84,0.00,0.00,1130.43,859126.80,0.00,0.00,0.00),('1','197','1018','257843',4903888,'3004','464',407987.84,409117.86,0.00,0.00,1130.02,858815.20,0.00,0.00,0.00),('1','197','1018','257844',4903889,'3004','464',409117.86,409738.25,0.00,0.00,620.39,471496.40,0.00,0.00,0.00),('1','197','1018','257845',4903890,'3004','464',409738.25,409951.39,0.00,0.00,213.14,161986.40,0.00,0.00,0.00),('1','197','1018','257846',4903891,'3004','464',409951.39,409983.07,0.00,0.00,31.68,24076.80,0.00,0.00,0.00),('1','197','1018','257847',4903892,'3004','464',409983.07,410389.29,0.00,0.00,406.22,308727.20,0.00,0.00,0.00),('1','197','1018','257848',4903893,'3004','464',410389.29,411027.69,0.00,0.00,638.40,485184.00,0.00,0.00,0.00),('1','197','1018','257849',4903894,'3004','464',411027.69,411731.22,0.00,0.00,703.53,534682.80,0.00,0.00,0.00),('1','197','1018','257850',4903895,'3004','464',411731.22,412291.90,0.00,0.00,560.68,426116.80,0.00,0.00,0.00),('1','197','1018','257851',4903896,'3004','464',412291.90,413362.85,0.00,0.00,1070.95,813922.00,0.00,0.00,0.00),('1','197','1018','257852',4903897,'3004','464',413362.85,414383.07,0.00,0.00,1020.22,775367.20,0.00,0.00,0.00),('1','197','1018','257853',4903898,'3004','464',414383.07,414723.07,0.00,0.00,340.00,258400.00,0.00,0.00,0.00),('1','197','1018','257854',4903899,'3004','464',414723.07,414767.92,0.00,0.00,44.85,34086.00,0.00,0.00,0.00),('1','197','1018','257855',4903900,'3004','464',414767.92,415133.69,0.00,0.00,365.77,277985.20,0.00,0.00,0.00),('1','197','1018','257856',4903901,'3004','464',415133.69,415884.36,0.00,0.00,750.67,570509.20,0.00,0.00,0.00),('1','197','1018','257857',4903902,'3004','464',415884.36,416679.35,0.00,0.00,794.99,604192.40,0.00,0.00,0.00),('1','197','1018','257858',4903903,'3004','464',416679.35,417464.93,0.00,0.00,785.58,597040.80,0.00,0.00,0.00),('1','197','1018','257859',4903904,'3004','464',417464.93,418231.48,0.00,0.00,766.55,582578.00,0.00,0.00,0.00),('1','197','1018','257860',4903905,'3004','464',418231.48,419277.09,0.00,0.00,1045.61,789378.35,0.00,0.00,0.00),('1','197','1018','257861',4903906,'3004','464',419277.09,419929.05,0.00,0.00,651.96,488807.10,0.00,0.00,0.00),('1','197','1018','257862',4903907,'3004','464',419929.05,419929.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257863',4903908,'3004','464',419929.05,420309.10,0.00,0.00,380.05,286273.00,0.00,0.00,0.00),('1','197','1018','257864',4903909,'3004','464',420309.10,421329.13,0.00,0.00,1020.03,766511.25,0.00,0.00,0.00),('1','197','1018','257865',4903910,'3004','464',421329.13,422188.50,0.00,0.00,859.37,650106.20,0.00,0.00,0.00),('1','197','1018','257866',4903911,'3004','464',422188.50,423109.20,0.00,0.00,920.70,689851.80,0.00,0.00,0.00),('1','197','1018','257867',4903912,'3004','464',423109.20,424063.37,0.00,0.00,954.17,724179.20,0.00,0.00,0.00),('1','197','1018','257868',4903913,'3004','464',424063.37,425048.57,0.00,0.00,985.20,745394.00,0.00,0.00,0.00),('1','197','1018','257869',4903914,'3004','464',425048.57,425048.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257870',4903915,'3004','464',425048.57,426249.31,0.00,0.00,1200.74,896128.40,0.00,0.00,0.00),('1','197','1018','257871',4903916,'3004','464',426249.31,427592.86,0.00,0.00,1343.55,1008084.50,0.00,0.00,0.00),('1','197','1018','257872',4903917,'3004','464',427592.86,428694.70,0.00,0.00,1101.84,822887.90,0.00,0.00,0.00),('1','197','1018','257873',4903918,'3004','464',428694.70,429809.53,0.00,0.00,1114.83,834830.30,0.00,0.00,0.00),('1','197','1018','257874',4903919,'3004','464',429809.53,429838.55,0.00,0.00,29.02,22055.20,0.00,0.00,0.00),('1','197','1018','257875',4903920,'3004','464',429838.55,430010.01,0.00,0.00,171.46,130309.60,0.00,0.00,0.00),('1','197','1018','257876',4903921,'3004','464',430010.01,430811.67,0.00,0.00,801.66,592431.60,0.00,0.00,0.00),('1','197','1018','257877',4903922,'3004','464',430811.67,431337.01,0.00,0.00,525.34,387460.00,0.00,0.00,0.00),('1','197','1018','257878',4903923,'3004','464',431337.01,432324.19,0.00,0.00,987.18,729996.00,0.00,0.00,0.00),('1','197','1018','257879',4903924,'3004','464',432324.19,434226.13,0.00,0.00,1901.94,1392778.80,0.00,0.00,0.00),('1','197','1018','257880',4903925,'3004','464',434226.13,434897.96,0.00,0.00,671.83,509870.80,0.00,0.00,0.00),('1','197','1018','257881',4903926,'3004','464',434897.96,434897.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257882',4903927,'3004','464',434897.96,434897.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257883',4903928,'3004','464',434897.96,436345.67,0.00,0.00,1447.71,1064319.60,0.00,0.00,0.00),('1','197','1018','257884',4903929,'3004','464',436345.67,437555.10,0.00,0.00,1209.43,890368.00,0.00,0.00,0.00),('1','197','1018','257885',4903930,'3004','464',437555.10,438761.53,0.00,0.00,1206.43,881912.20,0.00,0.00,0.00),('1','197','1018','257886',4903931,'3004','464',438761.53,439887.94,0.00,0.00,1126.41,834660.60,0.00,0.00,0.00),('1','197','1018','257887',4903932,'3004','464',439887.94,439905.01,0.00,0.00,17.07,12973.20,0.00,0.00,0.00),('1','197','1018','257888',4903933,'3004','464',439905.01,440836.08,0.00,0.00,931.07,671991.32,0.00,0.00,0.00),('1','197','1018','257889',4903934,'3004','464',440836.08,441406.85,0.00,0.00,570.77,413801.84,0.00,0.00,0.00),('1','197','1018','257890',4903935,'3004','464',441406.85,442766.42,0.00,0.00,1359.57,995315.52,0.00,0.00,0.00),('1','197','1018','257891',4903936,'3004','464',442766.42,444058.24,0.00,0.00,1291.82,928067.84,0.00,0.00,0.00),('1','197','1018','257892',4903937,'3004','464',444058.24,444895.01,0.00,0.00,836.77,603226.72,0.00,0.00,0.00),('1','197','1018','257893',4903938,'3004','464',444895.01,444974.17,0.00,0.00,79.16,58261.76,0.00,0.00,0.00),('1','197','1018','257894',4903939,'3004','464',444974.17,446413.60,0.00,0.00,1439.43,1047378.48,0.00,0.00,0.00),('1','197','1018','257895',4903940,'3004','464',446413.60,447589.52,0.00,0.00,1175.92,849580.96,0.00,0.00,0.00),('1','197','1018','257896',4903941,'3004','464',447589.52,448384.51,0.00,0.00,794.99,576754.16,0.00,0.00,0.00),('1','197','1018','257897',4903942,'3004','464',448384.51,449884.17,0.00,0.00,1499.66,1081958.96,0.00,0.00,0.00),('1','197','1018','257898',4903943,'3004','464',449884.17,449972.55,0.00,0.00,88.38,65047.68,0.00,0.00,0.00),('1','197','1018','257899',4903944,'3004','464',449972.55,451514.37,0.00,0.00,1541.82,1106272.92,0.00,0.00,0.00),('1','197','1018','257900',4903945,'3004','464',451514.37,452722.34,0.00,0.00,1207.97,875128.88,0.00,0.00,0.00),('1','197','1018','257901',4903946,'3004','464',452722.34,454245.94,0.00,0.00,1523.60,1096194.44,0.00,0.00,0.00),('1','197','1018','257902',4903947,'3004','464',454245.94,455012.55,0.00,0.00,766.61,546008.96,0.00,0.00,0.00),('1','197','1018','257903',4903948,'3004','464',455012.55,455053.68,0.00,0.00,41.13,30271.68,0.00,0.00,0.00),('1','197','1018','257904',4903949,'3004','464',455053.68,456064.32,0.00,0.00,1010.64,736390.92,0.00,0.00,0.00),('1','197','1018','257905',4903950,'3004','464',456064.32,458805.92,0.00,0.00,2741.60,1962899.60,0.00,0.00,0.00),('1','197','1018','257906',4903951,'3004','464',458805.92,460093.68,0.00,0.00,1287.76,931767.76,0.00,0.00,0.00),('1','197','1018','257907',4903952,'3004','464',460093.68,462937.21,0.00,0.00,2843.53,2040549.52,0.00,0.00,0.00),('1','197','1018','257908',4903953,'3004','464',462937.21,464153.15,0.00,0.00,1215.94,881536.24,0.00,0.00,0.00),('1','197','1018','257909',4903954,'3004','464',464153.15,464863.81,0.00,0.00,710.66,520237.76,0.00,0.00,0.00),('1','197','1018','257910',4903955,'3004','464',464863.81,465303.13,0.00,0.00,439.32,318319.32,0.00,0.00,0.00),('1','197','1018','257911',4903956,'3004','464',465303.13,465324.91,0.00,0.00,21.78,16030.08,0.00,0.00,0.00),('1','197','1018','257912',4903957,'3004','464',465324.91,466459.95,0.00,0.00,1135.04,826533.44,0.00,0.00,0.00),('1','197','1018','257913',4903958,'3004','464',466459.95,467471.48,0.00,0.00,1011.53,736292.84,0.00,0.00,0.00),('1','197','1018','257914',4903959,'3004','464',467471.48,468204.22,0.00,0.00,732.74,538684.64,0.00,0.00,0.00),('1','197','1018','257915',4903960,'3004','464',468204.22,469413.04,0.00,0.00,1208.82,874642.80,0.00,0.00,0.00),('1','197','1018','257916',4903961,'3004','464',469413.04,470182.52,0.00,0.00,769.48,562737.28,0.00,0.00,0.00),('1','197','1018','257917',4903962,'3004','464',470182.52,470294.91,0.00,0.00,112.39,82503.04,0.00,0.00,0.00),('1','197','1018','257918',4903963,'3004','464',470294.91,470342.84,0.00,0.00,47.93,35276.48,0.00,0.00,0.00),('1','197','1018','257919',4903964,'3004','464',470342.84,470870.66,0.00,0.00,527.82,386495.16,0.00,0.00,0.00),('1','197','1018','257920',4903965,'3004','464',470870.66,472217.38,0.00,0.00,1346.72,979562.96,0.00,0.00,0.00),('1','197','1018','257921',4903966,'3004','464',472217.38,473208.46,0.00,0.00,991.08,723026.88,0.00,0.00,0.00),('1','197','1018','257922',4903967,'3004','464',473208.46,474413.44,0.00,0.00,1204.98,873060.72,0.00,0.00,0.00),('1','197','1018','257923',4903968,'3004','464',474413.44,475474.24,0.00,0.00,1060.80,757887.72,0.00,0.00,0.00),('1','197','1018','257924',4903969,'3004','464',475474.24,475474.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257925',4903970,'3004','464',475474.24,476863.43,0.00,0.00,1389.19,998915.30,0.00,0.00,0.00),('1','197','1018','257926',4903971,'3004','464',476863.43,478063.48,0.00,0.00,1200.05,866216.80,0.00,0.00,0.00),('1','197','1018','257927',4903972,'3004','464',478063.48,479511.39,0.00,0.00,1447.91,1049209.86,0.00,0.00,0.00),('1','197','1018','257928',4903973,'3004','464',479511.39,480576.41,0.00,0.00,1065.02,757065.70,0.00,0.00,0.00),('1','197','1018','257929',4903974,'3004','464',480576.41,480576.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257930',4903975,'3004','464',480576.41,482491.33,0.00,0.00,1914.92,1358509.26,0.00,0.00,0.00),('1','197','1018','257931',4903976,'3004','464',482491.33,484027.44,0.00,0.00,1536.11,1098597.30,0.00,0.00,0.00),('1','197','1018','257932',4903977,'3004','464',484027.44,485292.57,0.00,0.00,1265.13,906893.68,0.00,0.00,0.00),('1','197','1018','257933',4903978,'3004','464',485292.57,485716.82,0.00,0.00,424.25,306038.00,0.00,0.00,0.00),('1','197','1018','257934',4903979,'3004','464',485716.82,485716.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257935',4903980,'3004','464',485716.82,486510.30,0.00,0.00,793.48,570514.08,0.00,0.00,0.00),('1','197','1018','257936',4903981,'3004','464',486510.30,486858.44,0.00,0.00,348.14,254821.14,0.00,0.00,0.00),('1','197','1018','257937',4903982,'3004','464',486858.44,488183.14,0.00,0.00,1324.70,954063.00,0.00,0.00,0.00),('1','197','1018','257938',4903983,'3004','464',488183.14,490179.78,0.00,0.00,1996.64,1413444.76,0.00,0.00,0.00),('1','197','1018','257939',4903984,'3004','464',490179.78,490876.80,0.00,0.00,697.02,495565.82,0.00,0.00,0.00),('1','197','1018','257940',4903985,'3004','464',490876.80,490938.46,0.00,0.00,61.66,45381.76,0.00,0.00,0.00),('1','197','1018','257941',4903986,'3004','464',490938.46,492564.90,0.00,0.00,1626.44,1160439.24,0.00,0.00,0.00),('1','197','1018','257942',4903987,'3004','464',492564.90,494265.31,0.00,0.00,1700.41,1218034.46,0.00,0.00,0.00),('1','197','1018','257943',4903988,'3004','464',494265.31,495918.46,0.00,0.00,1653.15,1163237.28,0.00,0.00,0.00),('1','197','1018','257944',4903989,'3004','464',495918.46,495919.51,0.00,0.00,1.05,714.00,0.00,0.00,0.00),('1','197','1018','257945',4903990,'3004','464',495919.51,497738.42,0.00,0.00,1818.91,1307508.96,0.00,0.00,0.00),('1','197','1018','257946',4903991,'3004','464',497738.42,499379.52,0.00,0.00,1641.10,1165323.76,0.00,0.00,0.00),('1','197','1018','257947',4903992,'3004','464',499379.52,500072.93,0.00,0.00,693.41,491007.92,0.00,0.00,0.00),('1','197','1018','257948',4903993,'3004','464',500072.93,501159.51,0.00,0.00,1086.58,756392.32,0.00,0.00,0.00),('1','197','1018','257949',4903994,'3004','464',501159.51,501213.41,0.00,0.00,53.90,36652.00,0.00,0.00,0.00),('1','197','1018','257950',4903995,'3004','464',501213.41,502008.04,0.00,0.00,794.63,561831.68,0.00,0.00,0.00),('1','197','1018','257951',4903996,'3004','464',502008.04,503183.53,0.00,0.00,1175.49,837573.36,0.00,0.00,0.00),('1','197','1018','257952',4903997,'3004','464',503183.53,504306.43,0.00,0.00,1122.90,806519.52,0.00,0.00,0.00),('1','197','1018','257953',4903998,'3004','464',504306.43,505716.27,0.00,0.00,1409.84,1003314.24,0.00,0.00,0.00),('1','197','1018','257954',4903999,'3004','464',505716.27,506389.59,0.00,0.00,673.32,484020.24,0.00,0.00,0.00),('1','197','1018','257955',4904000,'3004','464',506389.59,506389.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257956',4904001,'3004','464',506389.59,507103.79,0.00,0.00,714.20,498097.52,0.00,0.00,0.00),('1','197','1018','257957',4904002,'3004','464',507103.79,508318.26,0.00,0.00,1214.47,868583.84,0.00,0.00,0.00),('1','197','1018','257958',4904003,'3004','464',508318.26,509586.83,0.00,0.00,1268.57,904278.72,0.00,0.00,0.00),('1','197','1018','257959',4904004,'3004','464',509586.83,510865.19,0.00,0.00,1278.36,913935.84,0.00,0.00,0.00),('1','197','1018','257960',4904005,'3004','464',510865.19,510865.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','257961',4904006,'3004','464',510865.19,511459.57,0.00,0.00,594.38,428456.64,0.00,0.00,0.00),('1','197','1018','257962',4904007,'3004','464',511459.57,511534.37,0.00,0.00,74.80,55052.80,0.00,0.00,0.00),('1','197','1018','257963',4904008,'3004','464',511534.37,513053.90,0.00,0.00,1519.53,1084657.60,0.00,0.00,0.00),('1','197','1018','257964',4904009,'3004','464',513053.90,514136.58,0.00,0.00,1082.68,786554.64,0.00,0.00,0.00),('1','197','1018','257965',4904010,'3004','464',514136.58,514934.51,0.00,0.00,797.93,575236.48,0.00,0.00,0.00),('1','197','1018','257966',4904011,'3004','464',514934.51,516514.37,0.00,0.00,1579.86,1114936.16,0.00,0.00,0.00),('1','197','1018','257967',4904012,'3004','464',516514.37,516658.70,0.00,0.00,144.33,106226.88,0.00,0.00,0.00),('1','197','1018','257968',4904013,'3004','464',516658.70,517808.15,0.00,0.00,1149.45,825609.00,0.00,0.00,0.00),('1','197','1018','257969',4904014,'3004','464',517808.15,519163.09,0.00,0.00,1354.94,959287.74,0.00,0.00,0.00),('1','197','1018','257970',4904015,'3004','464',519163.09,519960.61,0.00,0.00,797.52,568857.72,0.00,0.00,0.00),('1','197','1018','257971',4904016,'3004','464',519960.61,521228.23,0.00,0.00,1267.62,910026.83,0.00,0.00,0.00),('1','197','1018','257972',4904017,'3004','464',521228.23,522058.70,0.00,0.00,830.47,578012.64,0.00,0.00,0.00),('1','197','1018','257973',4904018,'3004','464',522058.70,522161.34,0.00,0.00,102.64,69282.00,0.00,0.00,0.00),('1','197','1018','257974',4904019,'3004','464',522161.34,524325.28,0.00,0.00,2163.94,1520510.26,0.00,0.00,0.00),('1','197','1018','257975',4904020,'3004','464',524325.28,525516.26,0.00,0.00,1190.98,863446.28,0.00,0.00,0.00),('1','197','1018','257976',4904021,'3004','464',525516.26,526368.47,0.00,0.00,852.21,613745.56,0.00,0.00,0.00),('1','197','1018','257977',4904022,'3004','464',526368.47,527248.34,0.00,0.00,879.87,635403.84,0.00,0.00,0.00),('1','197','1018','257978',4904023,'3004','464',527248.34,529565.11,0.00,0.00,2316.77,1637000.23,0.00,0.00,0.00),('1','197','1018','257979',4904024,'3004','464',529565.11,530841.41,0.00,0.00,1276.30,923916.48,0.00,0.00,0.00),('1','197','1018','257980',4904025,'3004','464',530841.41,531872.01,0.00,0.00,1030.60,744217.10,0.00,0.00,0.00),('1','197','1018','257981',4904026,'3004','464',531872.01,532721.34,0.00,0.00,849.33,591128.66,0.00,0.00,0.00),('1','197','1018','257982',4904027,'3004','464',532721.34,532794.09,0.00,0.00,72.75,53544.00,0.00,0.00,0.00),('1','197','1018','257983',4904028,'3004','464',532794.09,534337.82,0.00,0.00,1543.73,1122356.58,0.00,0.00,0.00),('1','197','1018','257984',4904029,'3004','464',534337.82,535900.37,0.00,0.00,1562.55,1118717.57,0.00,0.00,0.00),('1','197','1018','257985',4904030,'3004','464',535900.37,538214.09,0.00,0.00,2313.72,1649674.81,0.00,0.00,0.00),('1','197','1018','257986',4904031,'3004','464',538214.09,538260.03,0.00,0.00,45.94,33811.84,0.00,0.00,0.00),('1','197','1018','257987',4904032,'3004','464',538260.03,540340.52,0.00,0.00,2080.49,1481720.84,0.00,0.00,0.00),('1','197','1018','257988',4904033,'3004','464',540340.52,541997.07,0.00,0.00,1656.55,1177504.73,0.00,0.00,0.00),('1','197','1018','257989',4904034,'3004','464',541997.07,543450.03,0.00,0.00,1452.96,1019997.84,0.00,0.00,0.00),('1','197','1018','257990',4904035,'3004','464',543450.03,543483.83,0.00,0.00,33.80,24876.80,0.00,0.00,0.00),('1','197','1018','257991',4904036,'3004','464',543483.83,544186.76,0.00,0.00,702.93,507596.48,0.00,0.00,0.00),('1','197','1018','257992',4904037,'3004','464',544186.76,545312.94,0.00,0.00,1126.18,805500.60,0.00,0.00,0.00),('1','197','1018','257993',4904038,'3004','464',545312.94,546408.79,0.00,0.00,1095.85,803202.80,0.00,0.00,0.00),('1','197','1018','257994',4904039,'3004','464',546408.79,548077.38,0.00,0.00,1668.59,1184533.12,0.00,0.00,0.00),('1','197','1018','257995',4904040,'3004','464',548077.38,550021.48,0.00,0.00,1944.10,1374610.11,0.00,0.00,0.00),('1','197','1018','257996',4904041,'3004','464',550021.48,551344.34,0.00,0.00,1322.86,935987.35,0.00,0.00,0.00),('1','197','1018','257997',4904042,'3004','464',551344.34,552562.16,0.00,0.00,1217.82,858699.26,0.00,0.00,0.00),('1','197','1018','257998',4904043,'3004','464',552562.16,552727.51,0.00,0.00,165.35,113102.36,0.00,0.00,0.00),('1','197','1018','257999',4904044,'3004','464',552727.51,553063.83,0.00,0.00,336.32,221802.56,0.00,0.00,0.00),('1','197','1018','258000',4904045,'3004','464',553063.83,553195.39,0.00,0.00,131.56,87553.48,0.00,0.00,0.00),('1','197','1018','258001',4904046,'3004','464',553195.39,554657.59,0.00,0.00,1462.20,993903.96,0.00,0.00,0.00),('1','197','1018','258002',4904047,'3004','464',554657.59,555677.93,0.00,0.00,1020.34,707476.00,0.00,0.00,0.00),('1','197','1018','258003',4904048,'3004','464',555677.93,556836.88,0.00,0.00,1158.95,805897.40,0.00,0.00,0.00),('1','197','1018','258004',4904049,'3004','464',556836.88,558405.39,0.00,0.00,1568.51,1057721.00,0.00,0.00,0.00),('1','197','1018','258005',4904050,'3004','464',558405.39,558405.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','197','1018','258006',4904051,'3004','464',558405.39,558424.99,0.00,0.00,19.60,13720.00,0.00,0.00,0.00),('1','197','1018','258007',4904052,'3004','464',558424.99,559617.22,0.00,0.00,1192.23,807647.82,0.00,0.00,0.00),('1','197','1018','258008',4904053,'3004','464',559617.22,561361.87,0.00,0.00,1744.65,1183412.58,0.00,0.00,0.00),('1','197','1018','258009',4904054,'3004','464',561361.87,562327.77,0.00,0.00,965.90,674681.20,0.00,0.00,0.00),('1','197','1018','258010',4904055,'3004','464',562327.77,563454.99,0.00,0.00,1127.22,770538.30,0.00,0.00,0.00),('1','197','1018','258011',4904056,'3004','464',563454.99,563463.25,0.00,0.00,8.26,5782.00,0.00,0.00,0.00),('1','197','1018','258012',4904057,'3004','464',563463.25,563721.58,0.00,0.00,258.33,170906.82,0.00,0.00,0.00),('1','197','1018','258013',4904058,'3004','464',563721.58,564184.92,0.00,0.00,463.34,316247.00,0.00,0.00,0.00),('1','197','1018','258014',4904059,'3004','464',564184.92,565969.61,0.00,0.00,1784.69,1193583.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730155 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','197','235481','464',570.00,584.00,0.00,1309.20,746244.00,752794.88,6550.88,672662),('1','197','235483','464',570.00,584.00,0.00,139.81,79691.70,81649.04,1957.34,672666),('1','197','235484','464',570.00,584.00,0.00,187.75,107017.50,108735.68,1718.18,672667),('1','197','235485','464',570.00,584.00,0.00,690.21,393419.70,400500.16,7080.46,672668),('1','197','235700','464',570.00,584.00,0.00,321.77,183408.90,187322.88,3913.98,673227),('1','197','235987','464',570.00,584.00,0.00,647.89,369297.30,374390.72,5093.42,673989),('1','197','235992','464',570.00,584.00,0.00,340.10,193857.00,203695.40,9838.40,674001),('1','197','236452','464',570.00,600.00,0.00,511.50,291555.00,305596.00,14041.00,675216),('1','197','236457','464',570.00,600.00,0.00,544.07,310119.90,325235.68,15115.78,675225),('1','197','236460','464',570.00,600.00,0.00,0.00,0.00,0.00,0.00,675232),('1','197','236618','464',592.00,600.00,0.00,430.13,254636.96,257762.16,3125.20,675629),('1','197','236770','464',592.00,600.00,0.00,2380.89,1409486.88,1415921.96,6435.08,676011),('1','197','237042','464',592.00,600.00,0.00,775.52,459107.84,464108.00,5000.16,676727),('1','197','237231','464',592.00,600.00,0.00,494.16,292542.72,296496.00,3953.28,677206),('1','197','237466','464',592.00,600.00,0.00,412.55,244229.60,246867.76,2638.16,677819),('1','197','237648','464',592.00,600.00,0.00,684.77,405383.84,408718.52,3334.68,678283),('1','197','237840','464',592.00,600.00,0.00,0.00,0.00,0.00,0.00,678811),('1','197','237976','464',592.00,600.00,0.00,349.54,206927.68,208534.52,1606.84,679142),('1','197','238087','464',592.00,600.00,0.00,1859.96,1101096.32,1115976.00,14879.68,679447),('1','197','238165','464',592.00,600.00,0.00,1458.42,863384.64,875052.00,11667.36,679625),('1','197','238453','464',592.00,600.00,0.00,1632.08,966191.36,979248.00,13056.64,680376),('1','197','238682','464',592.00,600.00,0.00,98.74,58454.08,59244.00,789.92,680973),('1','197','238706','464',570.00,600.00,0.00,2130.20,1214214.00,1278120.00,63906.00,681034),('1','197','238916','464',570.00,600.00,0.00,1330.38,758316.60,798228.00,39911.40,681573),('1','197','239176','464',570.00,600.00,0.00,1710.68,975087.60,1026408.00,51320.40,682257),('1','197','239270','464',570.00,600.00,0.00,0.00,0.00,0.00,0.00,682518),('1','197','239271','464',570.00,600.00,0.00,520.34,296593.80,312204.00,15610.20,682519),('1','197','239301','464',570.00,600.00,0.00,2050.59,1168836.30,1230354.00,61517.70,682576),('1','197','239574','464',570.00,600.00,0.00,1595.63,909509.10,957378.00,47868.90,683287),('1','197','239843','464',570.00,600.00,0.00,673.57,383934.90,404142.00,20207.10,683993),('1','197','240040','464',570.00,600.00,0.00,459.87,262125.90,275922.00,13796.10,684493),('1','197','240130','464',570.00,600.00,0.00,0.00,0.00,0.00,0.00,684749),('1','197','240131','464',570.00,600.00,0.00,32.22,18365.40,19332.00,966.60,684750),('1','197','240165','464',570.00,616.00,0.00,329.92,188054.40,201210.88,13156.48,684841),('1','197','240241','464',570.00,616.00,0.00,2412.05,1374868.50,1470359.36,95490.86,685015),('1','197','240538','464',570.00,616.00,0.00,1169.01,666335.70,712190.00,45854.30,685791),('1','197','240779','464',570.00,616.00,0.00,852.66,486016.20,520489.52,34473.32,686374),('1','197','241074','464',570.00,616.00,0.00,306.36,174625.20,186636.96,12011.76,687172),('1','197','241188','464',570.00,616.00,0.00,69.33,39518.10,42152.64,2634.54,687488),('1','197','241192','464',570.00,616.00,0.00,674.33,384368.10,410374.40,26006.30,687498),('1','197','241194','464',570.00,616.00,0.00,173.68,98997.60,106031.18,7033.58,687502),('1','197','241350','464',570.00,616.00,0.00,968.72,552170.40,591609.52,39439.12,687892),('1','197','241675','464',570.00,616.00,0.00,594.73,338996.10,364372.38,25376.28,688770),('1','197','241873','464',570.00,616.00,0.00,2493.20,1421124.00,1515328.40,94204.40,689280),('1','197','241999','464',570.00,616.00,0.00,318.08,181305.60,194579.18,13273.58,689603),('1','197','242067','464',570.00,616.00,0.00,0.00,0.00,0.00,0.00,689776),('1','197','242068','464',570.00,616.00,0.00,757.59,431826.30,462903.34,31077.04,689777),('1','197','242238','464',570.00,616.00,0.00,697.96,397837.20,429018.36,31181.16,690224),('1','197','242500','464',570.00,616.00,0.00,1229.76,700963.20,751396.86,50433.66,690893),('1','197','242744','464',570.00,616.00,0.00,854.10,486837.00,523439.10,36602.10,691530),('1','197','242973','464',570.00,616.00,0.00,1650.59,940836.30,995288.40,54452.10,692125),('1','197','243076','464',570.00,616.00,0.00,13.36,7615.20,8229.76,614.56,692414),('1','197','243176','464',570.00,616.00,0.00,1839.60,1048572.00,1111719.36,63147.36,692658),('1','197','243392','464',570.00,616.00,0.00,1347.15,767875.50,815690.00,47814.50,693230),('1','197','243615','464',570.00,616.00,0.00,1942.49,1107219.30,1175341.68,68122.38,693804),('1','197','243847','464',570.00,616.00,0.00,110.76,63133.20,67202.72,4069.52,694410),('1','197','243914','464',570.00,616.00,0.00,27.78,15834.60,16668.00,833.40,694578),('1','197','243918','464',570.00,616.00,0.00,1488.56,848479.20,896800.80,48321.60,694588),('1','197','244050','464',570.00,616.00,0.00,840.41,479033.70,512190.48,33156.78,694926),('1','197','244317','464',570.00,616.00,0.00,1136.09,647571.30,689279.44,41708.14,695621),('1','197','244532','464',570.00,616.00,0.00,694.32,395762.40,423172.80,27410.40,696180),('1','197','244765','464',570.00,616.00,0.00,751.44,428320.80,457516.80,29196.00,696791),('1','197','245053','464',570.00,616.00,0.00,0.00,0.00,0.00,0.00,697531),('1','197','245057','464',570.00,616.00,0.00,914.11,516379.50,551275.76,34896.26,697541),('1','197','245227','464',562.00,616.00,0.00,1455.49,817985.38,868253.12,50267.74,697983),('1','197','245447','464',562.00,616.00,0.00,969.57,544898.34,581897.12,36998.78,698552),('1','197','245686','464',562.00,616.00,0.00,1120.66,629810.92,673618.68,43807.76,699167),('1','197','245997','464',562.00,616.00,0.00,510.16,286783.66,294675.46,7891.80,699978),('1','197','246118','464',564.00,616.00,0.00,406.98,229536.72,229536.72,0.00,700302),('1','197','246151','464',548.00,616.00,0.00,334.68,183404.64,198518.88,15114.24,700393),('1','197','246212','464',548.00,616.00,0.00,852.21,467011.08,501652.36,34641.28,700527),('1','197','246478','464',548.00,616.00,0.00,1425.54,781195.92,826192.44,44996.52,701237),('1','197','246750','464',548.00,616.00,0.00,1168.74,640469.52,678306.40,37836.88,701945),('1','197','246961','464',548.00,616.00,0.00,1151.36,630945.28,676215.68,45270.40,702483),('1','197','247167','464',548.00,616.00,0.00,115.00,63020.00,66472.00,3452.00,703035),('1','197','247235','464',548.00,616.00,0.00,0.00,0.00,0.00,0.00,703197),('1','197','247238','464',548.00,616.00,0.00,961.17,526721.16,562257.68,35536.52,703202),('1','197','247413','464',548.00,616.00,0.00,1136.54,622823.92,672055.16,49231.24,703642),('1','197','247672','464',548.00,616.00,0.00,150.01,82205.48,91790.48,9585.00,704333),('1','197','247747','464',548.00,592.00,0.00,1154.00,632392.00,656851.64,24459.64,704516),('1','197','247922','464',548.00,592.00,0.00,1650.59,904523.32,944227.28,39703.96,704976),('1','197','248185','464',548.00,592.00,0.00,76.89,42135.72,45518.88,3383.16,705653),('1','197','248266','464',548.00,592.00,0.00,0.00,0.00,0.00,0.00,705864),('1','197','248268','464',548.00,592.00,0.00,569.92,312316.16,337392.64,25076.48,705868),('1','197','248427','464',548.00,592.00,0.00,1442.58,790533.84,834853.20,44319.36,706275),('1','197','248652','464',548.00,592.00,0.00,1483.03,812700.44,847804.12,35103.68,706849),('1','197','248888','464',548.00,592.00,0.00,564.10,309126.80,325235.20,16108.40,707463),('1','197','249023','464',548.00,592.00,0.00,571.70,313291.60,310887.40,-2404.20,707822),('1','197','249135','464',548.00,592.00,0.00,732.54,401431.92,414598.68,13166.76,708084),('1','197','249313','464',548.00,592.00,0.00,0.00,0.00,0.00,0.00,708566),('1','197','249372','464',548.00,592.00,0.00,560.99,286104.90,325386.52,39281.62,708686),('1','197','249608','464',510.00,592.00,0.00,632.87,322763.70,357206.04,34442.34,709299),('1','197','249855','464',510.00,592.00,0.00,1524.26,777372.60,840345.18,62972.58,709937),('1','197','250134','464',510.00,592.00,0.00,1088.90,555339.00,617154.74,61815.74,710639),('1','197','250358','464',510.00,592.00,0.00,1095.55,558730.50,603871.66,45141.16,711209),('1','197','250607','464',510.00,592.00,0.00,417.27,212807.70,231089.84,18282.14,711848),('1','197','250751','464',510.00,592.00,0.00,0.00,0.00,0.00,0.00,712252),('1','197','250760','464',510.00,592.00,0.00,99.49,50739.90,58898.08,8158.18,712276),('1','197','250840','464',510.00,592.00,0.00,987.06,503400.60,542007.78,38607.18,712449),('1','197','251099','464',510.00,592.00,0.00,600.41,306209.10,347597.86,41388.76,713122),('1','197','251313','464',510.00,592.00,0.00,794.11,404996.10,439330.12,34334.02,713681),('1','197','251524','464',510.00,592.00,0.00,997.30,508623.00,574246.26,65623.26,714244),('1','197','251767','464',510.00,592.00,0.00,854.35,435718.50,490006.12,54287.62,714883),('1','197','252007','464',510.00,592.00,0.00,340.49,173649.90,182596.22,8946.32,715507),('1','197','252084','464',510.00,592.00,0.00,0.00,0.00,0.00,0.00,715706),('1','197','252090','464',510.00,592.00,0.00,1693.50,863685.00,950256.86,86571.86,715715),('1','197','252252','464',510.00,592.00,0.00,731.80,373218.00,428296.60,55078.60,716148),('1','197','252505','464',510.00,592.00,0.00,888.79,453282.90,517173.68,63890.78,716790),('1','197','252732','464',510.00,592.00,0.00,957.19,488166.90,548583.48,60416.58,717390),('1','197','252980','464',510.00,592.00,0.00,920.86,469638.60,519063.86,49425.26,718033),('1','197','253225','464',510.00,592.00,0.00,98.41,50189.10,57194.18,7005.08,718673),('1','197','253349','464',510.00,592.00,0.00,0.00,0.00,0.00,0.00,719003),('1','197','253354','464',510.00,592.00,0.00,582.10,296871.00,324418.76,27547.76,719015),('1','197','253489','464',510.00,592.00,0.00,1101.41,561719.10,617124.20,55405.10,719362),('1','197','253729','464',510.00,592.00,0.00,1773.75,904612.50,973198.92,68586.42,719972),('1','197','253976','464',510.00,592.00,0.00,924.59,471540.90,518768.72,47227.82,720620),('1','197','254206','464',510.00,592.00,0.00,887.41,452579.10,474150.88,21571.78,721219),('1','197','254327','464',510.00,592.00,0.00,0.00,0.00,0.00,0.00,721534),('1','197','254329','464',510.00,592.00,0.00,1116.86,569598.60,610825.76,41227.16,721538),('1','197','254458','464',510.00,592.00,0.00,1334.64,680666.40,730435.52,49769.12,721873),('1','197','254719','464',510.00,592.00,0.00,926.01,472265.10,510714.28,38449.18,722526),('1','197','254964','464',510.00,592.00,0.00,1486.15,757936.50,827006.28,69069.78,723156),('1','197','255200','464',510.00,592.00,0.00,346.33,176628.30,184343.12,7714.82,723767),('1','197','255285','464',510.00,592.00,0.00,40.73,20772.30,24112.16,3339.86,723977),('1','197','255342','464',510.00,592.00,0.00,954.68,486886.80,520861.08,33974.28,724134),('1','197','255472','464',510.00,592.00,0.00,1719.63,877011.30,943215.52,66204.22,724442),('1','197','255721','464',510.00,592.00,0.00,921.39,469908.90,521126.36,51217.46,725061),('1','197','256049','464',510.00,592.00,0.00,1235.09,629895.90,683648.08,53752.18,725888),('1','197','256332','464',510.00,592.00,0.00,622.64,317546.40,347068.64,29522.24,726593),('1','197','256409','464',510.00,592.00,0.00,0.00,0.00,0.00,0.00,726807),('1','197','256482','464',510.00,592.00,0.00,1148.69,585831.90,651155.08,65323.18,726997),('1','197','256741','464',510.00,592.00,0.00,1480.46,755034.60,813732.92,58698.32,727653),('1','197','257189','464',510.00,592.00,0.00,1552.87,791963.70,855316.12,63352.42,728842),('1','197','257249','464',510.00,592.00,0.00,667.37,340358.70,378795.00,38436.30,728984),('1','197','257437','464',510.00,592.00,0.00,0.00,0.00,0.00,0.00,729491),('1','197','257444','464',510.00,592.00,0.00,586.39,299058.90,328358.56,29299.66,729507),('1','197','257492','464',510.00,568.00,0.00,1951.45,995239.50,1042294.84,47055.34,729632),('1','197','257493','464',510.00,568.00,0.00,2196.86,1120398.60,1174315.88,53917.28,729633),('1','197','257494','464',510.00,568.00,0.00,571.92,291679.20,298336.56,6657.36,729634),('1','197','257495','464',510.00,568.00,0.00,0.00,0.00,0.00,0.00,729635),('1','197','257496','464',510.00,568.00,0.00,815.96,416139.60,443714.24,27574.64,729636),('1','197','257497','464',510.00,568.00,0.00,2117.60,1079976.00,1124989.28,45013.28,729637),('1','197','257498','464',510.00,568.00,0.00,1800.39,918198.90,959906.08,41707.18,729638),('1','197','257499','464',510.00,568.00,0.00,613.53,312900.30,323565.66,10665.36,729639),('1','197','257500','464',510.00,568.00,0.00,0.00,0.00,0.00,0.00,729640),('1','197','257501','464',500.00,568.00,0.00,965.70,482850.00,516590.64,33740.64,729641),('1','197','257502','464',500.00,568.00,0.00,2369.73,1184865.00,1267462.02,82597.02,729642),('1','197','257503','464',500.00,568.00,0.00,1924.09,962045.00,1013342.56,51297.56,729643),('1','197','257504','464',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729644),('1','197','257505','464',500.00,568.00,0.00,1664.48,832240.00,894772.64,62532.64,729645),('1','197','257506','464',500.00,568.00,0.00,1236.31,618155.00,666648.34,48493.34,729646),('1','197','257507','464',500.00,568.00,0.00,2036.94,1018470.00,1060335.08,41865.08,729647),('1','197','257508','464',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729648),('1','197','257509','464',500.00,568.00,0.00,122.35,61175.00,66119.80,4944.80,729649),('1','197','257510','464',500.00,568.00,0.00,1056.87,528435.00,565239.96,36804.96,729650),('1','197','257511','464',500.00,568.00,0.00,3038.78,1519390.00,1593259.12,73869.12,729651),('1','197','257512','464',500.00,568.00,0.00,368.83,184415.00,193768.64,9353.64,729652),('1','197','257513','464',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729653),('1','197','257514','464',500.00,568.00,0.00,3208.31,1604155.00,1687621.94,83466.94,729654),('1','197','257515','464',500.00,568.00,0.00,1246.05,623025.00,660882.78,37857.78,729655),('1','197','257516','464',500.00,568.00,0.00,45.40,22700.00,25112.20,2412.20,729656),('1','197','257517','464',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729657),('1','197','257518','464',500.00,568.00,0.00,1702.38,851190.00,899732.50,48542.50,729658),('1','197','257519','464',500.00,568.00,0.00,664.80,332400.00,359354.40,26954.40,729659),('1','197','257520','464',500.00,568.00,0.00,1486.27,743135.00,791557.30,48422.30,729660),('1','197','257521','464',500.00,568.00,0.00,786.54,393270.00,425361.54,32091.54,729661),('1','197','257522','464',500.00,568.00,0.00,367.73,189013.22,189013.22,0.00,729662),('1','197','257523','464',514.00,568.00,0.00,2667.36,1360353.60,1401284.38,40930.78,729663),('1','197','257524','464',510.00,568.00,0.00,1546.59,788760.90,826052.34,37291.44,729664),('1','197','257525','464',510.00,568.00,0.00,586.05,298885.50,320510.94,21625.44,729665),('1','197','257526','464',510.00,568.00,0.00,271.26,139427.64,139427.64,0.00,729666),('1','197','257527','464',514.00,568.00,0.00,1246.61,635771.10,677752.94,41981.84,729667),('1','197','257528','464',510.00,568.00,0.00,1390.45,709129.50,741221.50,32092.00,729668),('1','197','257529','464',510.00,568.00,0.00,1134.98,578839.80,607640.30,28800.50,729669),('1','197','257530','464',510.00,568.00,0.00,1576.57,804050.70,835506.94,31456.24,729670),('1','197','257531','464',510.00,568.00,0.00,0.00,0.00,0.00,0.00,729671),('1','197','257532','464',510.00,568.00,0.00,2850.29,1425145.00,1497829.52,72684.52,729672),('1','197','257533','464',500.00,568.00,0.00,1324.90,662450.00,707967.30,45517.30,729673),('1','197','257534','464',500.00,568.00,0.00,892.82,446410.00,470232.20,23822.20,729674),('1','197','257535','464',500.00,568.00,0.00,1255.04,627520.00,671605.64,44085.64,729675),('1','197','257536','464',500.00,568.00,0.00,3143.25,1571625.00,1648356.56,76731.56,729676),('1','197','257537','464',500.00,568.00,0.00,490.52,245260.00,264232.46,18972.46,729677),('1','197','257538','464',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729678),('1','197','257539','464',532.00,580.00,0.00,1532.56,815321.92,859916.00,44594.08,729679),('1','197','257540','464',532.00,580.00,0.00,1918.43,1020604.76,1062585.80,41981.04,729680),('1','197','257541','464',532.00,580.00,0.00,1577.93,839458.76,861459.00,22000.24,729681),('1','197','257542','464',532.00,580.00,0.00,0.00,0.00,0.00,0.00,729682),('1','197','257543','464',532.00,580.00,0.00,1080.33,574735.56,596431.00,21695.44,729683),('1','197','257544','464',532.00,580.00,0.00,1168.71,621753.72,655822.20,34068.48,729684),('1','197','257545','464',532.00,580.00,0.00,1341.66,713763.12,753599.60,39836.48,729685),('1','197','257546','464',532.00,580.00,0.00,1588.09,844863.88,870291.80,25427.92,729686),('1','197','257547','464',532.00,580.00,0.00,0.00,0.00,0.00,0.00,729687),('1','197','257548','464',582.00,640.00,0.00,687.57,400165.74,440044.80,39879.06,729688),('1','197','257549','464',582.00,640.00,0.00,689.36,401207.52,441190.40,39982.88,729689),('1','197','257550','464',582.00,640.00,0.00,632.96,368382.72,405094.40,36711.68,729690),('1','197','257551','464',582.00,640.00,0.00,1078.75,627832.50,690400.00,62567.50,729691),('1','197','257552','464',582.00,640.00,0.00,984.52,572990.64,630092.80,57102.16,729692),('1','197','257553','464',582.00,640.00,0.00,1021.59,594565.38,653817.60,59252.22,729693),('1','197','257554','464',606.00,680.00,0.00,55.25,33481.50,37570.00,4088.50,729694),('1','197','257555','464',606.00,680.00,0.00,20.67,10996.44,14055.60,3059.16,729695),('1','197','257556','464',532.00,680.00,0.00,381.80,231370.80,257624.00,26253.20,729696),('1','197','257557','464',606.00,680.00,0.00,677.99,410861.94,456381.60,45519.66,729697),('1','197','257558','464',606.00,680.00,0.00,793.50,480861.00,533104.80,52243.80,729698),('1','197','257559','464',606.00,656.00,0.00,1226.67,743362.02,766684.80,23322.78,729699),('1','197','257560','464',606.00,656.00,0.00,1255.21,760657.26,786727.52,26070.26,729700),('1','197','257561','464',606.00,656.00,0.00,764.83,463486.98,481334.72,17847.74,729701),('1','197','257562','464',606.00,656.00,0.00,73.44,44504.64,44651.52,146.88,729702),('1','197','257563','464',598.00,656.00,0.00,835.10,499389.80,533129.44,33739.64,729703),('1','197','257564','464',598.00,656.00,0.00,1715.65,1025958.70,1064090.24,38131.54,729704),('1','197','257565','464',598.00,656.00,0.00,2258.60,1350642.80,1385587.52,34944.72,729705),('1','197','257566','464',598.00,656.00,0.00,0.00,0.00,0.00,0.00,729706),('1','197','257567','464',598.00,656.00,0.00,1145.56,685044.88,725062.40,40017.52,729707),('1','197','257568','464',598.00,656.00,0.00,1947.00,1164306.00,1211982.72,47676.72,729708),('1','197','257569','464',598.00,656.00,0.00,1218.64,728746.72,765331.04,36584.32,729709),('1','197','257570','464',598.00,656.00,0.00,129.99,77734.02,82952.16,5218.14,729710),('1','197','257571','464',598.00,656.00,0.00,498.80,298282.40,331368.32,33085.92,729711),('1','197','257572','464',598.00,688.00,0.00,157.69,94298.62,98398.56,4099.94,729712),('1','197','257573','464',598.00,688.00,0.00,573.65,353942.05,374982.24,21040.19,729713),('1','197','257574','464',617.00,688.00,0.00,762.40,470400.80,506163.20,35762.40,729714),('1','197','257575','464',617.00,688.00,0.00,627.55,387198.35,421194.40,33996.05,729715),('1','197','257576','464',617.00,688.00,0.00,974.10,601019.70,640600.80,39581.10,729716),('1','197','257577','464',617.00,688.00,0.00,1040.22,641815.74,666779.32,24963.58,729717),('1','197','257578','464',617.00,664.00,0.00,870.10,536851.70,559965.52,23113.82,729718),('1','197','257579','464',617.00,664.00,0.00,498.03,307284.51,313859.00,6574.49,729719),('1','197','257580','464',617.00,664.00,0.00,0.00,0.00,0.00,0.00,729720),('1','197','257581','464',617.00,664.00,0.00,900.47,533078.24,570588.68,37510.44,729721),('1','197','257582','464',592.00,664.00,0.00,1810.81,1071999.52,1156469.12,84469.60,729722),('1','197','257583','464',592.00,664.00,0.00,1185.57,701857.44,763758.68,61901.24,729723),('1','197','257584','464',592.00,664.00,0.00,877.08,519231.36,556512.57,37281.21,729724),('1','197','257585','464',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729725),('1','197','257586','464',592.00,664.00,0.00,498.00,294816.00,301290.00,6474.00,729726),('1','197','257587','464',592.00,664.00,0.00,787.37,466123.04,518383.96,52260.92,729727),('1','197','257588','464',592.00,664.00,0.00,1210.31,716503.52,773691.54,57188.02,729728),('1','197','257589','464',592.00,664.00,0.00,1350.61,799561.12,862290.04,62728.92,729729),('1','197','257590','464',592.00,664.00,0.00,1021.72,604858.24,678422.08,73563.84,729730),('1','197','257591','464',592.00,664.00,0.00,294.31,174231.52,195421.84,21190.32,729731),('1','197','257592','464',592.00,664.00,0.00,0.00,0.00,0.00,0.00,729732),('1','197','257593','464',592.00,664.00,0.00,485.67,287516.64,322484.88,34968.24,729733),('1','197','257594','464',592.00,664.00,0.00,702.43,415838.56,466413.52,50574.96,729734),('1','197','257595','464',592.00,664.00,0.00,582.19,344656.48,386574.16,41917.68,729735),('1','197','257596','464',592.00,664.00,0.00,804.66,476358.72,534294.24,57935.52,729736),('1','197','257597','464',592.00,664.00,0.00,934.80,553401.60,620707.20,67305.60,729737),('1','197','257598','464',592.00,664.00,0.00,670.24,396782.08,445039.36,48257.28,729738),('1','197','257599','464',592.00,664.00,0.00,56.37,37429.68,37429.68,0.00,729739),('1','197','257600','464',592.00,664.00,0.00,204.73,121200.16,135940.72,14740.56,729740),('1','197','257601','464',592.00,664.00,0.00,764.84,452785.28,507853.76,55068.48,729741),('1','197','257602','464',592.00,664.00,0.00,798.38,472640.96,530124.32,57483.36,729742),('1','197','257603','464',592.00,664.00,0.00,151.33,89283.16,100483.12,11199.96,729743),('1','197','257604','464',582.00,664.00,0.00,454.09,264280.38,279398.50,15118.12,729744),('1','197','257605','464',582.00,664.00,0.00,942.88,548756.16,607698.58,58942.42,729745),('1','197','257606','464',582.00,664.00,0.00,1400.12,814869.84,880332.14,65462.30,729746),('1','197','257607','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729747),('1','197','257608','464',582.00,664.00,0.00,1762.59,1025827.38,1115645.10,89817.72,729748),('1','197','257609','464',582.00,664.00,0.00,1558.54,907070.28,993602.08,86531.80,729749),('1','197','257610','464',582.00,664.00,0.00,991.94,577309.08,638980.16,61671.08,729750),('1','197','257611','464',582.00,664.00,0.00,818.25,476221.50,513519.66,37298.16,729751),('1','197','257612','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729752),('1','197','257613','464',582.00,664.00,0.00,1813.89,1055683.98,1133071.02,77387.04,729753),('1','197','257614','464',582.00,664.00,0.00,1127.30,656088.60,724367.24,68278.64,729754),('1','197','257615','464',582.00,664.00,0.00,1141.77,664510.14,728699.28,64189.14,729755),('1','197','257616','464',582.00,664.00,0.00,1003.99,584322.18,631351.24,47029.06,729756),('1','197','257617','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729757),('1','197','257618','464',582.00,664.00,0.00,722.03,420221.46,459328.28,39106.82,729758),('1','197','257619','464',582.00,664.00,0.00,2365.09,1376482.38,1477339.96,100857.58,729759),('1','197','257620','464',582.00,664.00,0.00,1150.83,669783.06,730960.38,61177.32,729760),('1','197','257621','464',582.00,664.00,0.00,663.77,386314.14,415809.80,29495.66,729761),('1','197','257622','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729762),('1','197','257623','464',582.00,664.00,0.00,587.33,341826.06,376007.00,34180.94,729763),('1','197','257624','464',582.00,664.00,0.00,1330.52,774362.64,849708.26,75345.62,729764),('1','197','257625','464',582.00,664.00,0.00,1211.16,704895.12,775038.24,70143.12,729765),('1','197','257626','464',582.00,664.00,0.00,1851.68,1077677.76,1177801.88,100124.12,729766),('1','197','257627','464',582.00,664.00,0.00,215.09,125182.38,138344.30,13161.92,729767),('1','197','257628','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729768),('1','197','257629','464',582.00,664.00,0.00,218.07,126916.74,144798.48,17881.74,729769),('1','197','257630','464',582.00,664.00,0.00,888.81,517287.42,590169.84,72882.42,729770),('1','197','257631','464',582.00,664.00,0.00,692.05,402773.10,459521.20,56748.10,729771),('1','197','257632','464',582.00,664.00,0.00,814.38,473969.16,540748.32,66779.16,729772),('1','197','257633','464',582.00,664.00,0.00,641.34,373259.88,425849.76,52589.88,729773),('1','197','257634','464',582.00,664.00,0.00,582.52,339026.64,386793.28,47766.64,729774),('1','197','257635','464',582.00,664.00,0.00,658.45,383217.90,437210.80,53992.90,729775),('1','197','257636','464',582.00,664.00,0.00,136.70,79559.40,90768.80,11209.40,729776),('1','197','257637','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729777),('1','197','257638','464',582.00,664.00,0.00,0.00,0.00,0.00,0.00,729778),('1','197','257639','464',582.00,664.00,0.00,381.44,221998.08,253276.16,31278.08,729779),('1','197','257640','464',582.00,680.00,0.00,872.23,507637.86,593116.40,85478.54,729780),('1','197','257641','464',582.00,680.00,0.00,800.93,466141.26,544632.40,78491.14,729781),('1','197','257642','464',582.00,680.00,0.00,1146.16,667065.12,779388.80,112323.68,729782),('1','197','257643','464',582.00,680.00,0.00,723.94,421333.08,492279.20,70946.12,729783),('1','197','257644','464',582.00,680.00,0.00,917.26,533845.32,623736.80,89891.48,729784),('1','197','257645','464',582.00,680.00,0.00,118.02,68687.64,80253.60,11565.96,729785),('1','197','257646','464',582.00,680.00,0.00,35.76,20812.32,24316.80,3504.48,729786),('1','197','257647','464',582.00,680.00,0.00,500.96,296568.32,340652.80,44084.48,729787),('1','197','257648','464',592.00,680.00,0.00,1034.78,612589.76,703650.40,91060.64,729788),('1','197','257649','464',592.00,680.00,0.00,913.09,540549.28,620901.20,80351.92,729789),('1','197','257650','464',592.00,680.00,0.00,681.90,403684.80,463692.00,60007.20,729790),('1','197','257651','464',592.00,680.00,0.00,809.46,479200.32,571459.00,92258.68,729791),('1','197','257652','464',592.00,720.00,0.00,861.28,509877.76,617799.60,107921.84,729792),('1','197','257653','464',592.00,720.00,0.00,381.65,225936.80,263647.13,37710.33,729793),('1','197','257654','464',592.00,720.00,0.00,0.00,0.00,0.00,0.00,729794),('1','197','257655','464',652.00,720.00,0.00,670.57,437211.64,465313.27,28101.63,729795),('1','197','257656','464',652.00,720.00,0.00,2962.88,1931797.76,2050970.74,119172.98,729796),('1','197','257657','464',652.00,720.00,0.00,974.56,635413.12,684849.13,49436.01,729797),('1','197','257658','464',652.00,720.00,0.00,438.18,285693.36,303863.69,18170.33,729798),('1','197','257659','464',652.00,720.00,0.00,0.00,0.00,0.00,0.00,729799),('1','197','257660','464',652.00,720.00,0.00,282.98,184502.96,203745.60,19242.64,729800),('1','197','257661','464',652.00,760.00,0.00,2496.29,1627581.08,1811589.20,184008.12,729801),('1','197','257662','464',652.00,760.00,0.00,1201.91,783645.32,869381.00,85735.68,729802),('1','197','257663','464',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729803),('1','197','257664','464',652.00,760.00,0.00,226.80,147873.60,169488.00,21614.40,729804),('1','197','257665','464',652.00,760.00,0.00,1646.02,1073205.04,1217084.20,143879.16,729805),('1','197','257666','464',652.00,760.00,0.00,1791.68,1168175.36,1306383.20,138207.84,729806),('1','197','257667','464',652.00,760.00,0.00,1503.85,980510.20,1108376.80,127866.60,729807),('1','197','257668','464',652.00,760.00,0.00,0.00,0.00,0.00,0.00,729808),('1','197','257669','464',652.00,760.00,0.00,1494.74,1000070.48,1091842.40,91771.92,729809),('1','197','257670','464',672.00,760.00,0.00,140.85,94651.20,107046.00,12394.80,729810),('1','197','257671','464',672.00,760.00,0.00,650.40,437068.80,494304.00,57235.20,729811),('1','197','257672','464',672.00,760.00,0.00,613.96,412581.12,466609.60,54028.48,729812),('1','197','257673','464',672.00,760.00,0.00,939.97,631659.84,714377.20,82717.36,729813),('1','197','257674','464',672.00,760.00,0.00,885.97,595371.84,673337.20,77965.36,729814),('1','197','257675','464',672.00,760.00,0.00,432.52,290653.44,328715.20,38061.76,729815),('1','197','257676','464',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729816),('1','197','257677','464',672.00,760.00,0.00,906.66,609275.52,689061.60,79786.08,729817),('1','197','257678','464',672.00,760.00,0.00,679.38,456543.36,516328.80,59785.44,729818),('1','197','257679','464',672.00,760.00,0.00,947.14,636478.08,719826.40,83348.32,729819),('1','197','257680','464',672.00,760.00,0.00,551.35,370507.20,419026.00,48518.80,729820),('1','197','257681','464',672.00,760.00,0.00,724.68,486984.96,550756.80,63771.84,729821),('1','197','257682','464',672.00,760.00,0.00,884.79,594578.88,672440.40,77861.52,729822),('1','197','257683','464',672.00,760.00,0.00,391.54,263114.88,298810.40,35695.52,729823),('1','197','257684','464',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729824),('1','197','257685','464',672.00,760.00,0.00,549.91,369539.52,417931.60,48392.08,729825),('1','197','257686','464',672.00,760.00,0.00,1341.52,901501.44,1019555.20,118053.76,729826),('1','197','257687','464',672.00,760.00,0.00,1031.63,693255.36,784038.80,90783.44,729827),('1','197','257688','464',672.00,760.00,0.00,1187.04,797690.88,902150.40,104459.52,729828),('1','197','257689','464',672.00,760.00,0.00,671.83,451469.76,510590.80,59121.04,729829),('1','197','257690','464',672.00,760.00,0.00,350.78,235724.16,266592.80,30868.64,729830),('1','197','257691','464',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729831),('1','197','257692','464',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729832),('1','197','257693','464',672.00,760.00,0.00,262.62,176480.64,199591.20,23110.56,729833),('1','197','257694','464',672.00,760.00,0.00,701.28,471260.16,532972.80,61712.64,729834),('1','197','257695','464',672.00,760.00,0.00,1279.96,860133.12,972769.60,112636.48,729835),('1','197','257696','464',672.00,760.00,0.00,824.93,554352.96,626946.80,72593.84,729836),('1','197','257697','464',672.00,760.00,0.00,294.57,197951.04,223873.20,25922.16,729837),('1','197','257698','464',672.00,760.00,0.00,402.72,270627.84,306067.20,35439.36,729838),('1','197','257699','464',672.00,760.00,0.00,914.10,614275.20,694716.00,80440.80,729839),('1','197','257700','464',672.00,760.00,0.00,718.92,483114.24,546379.20,63264.96,729840),('1','197','257701','464',672.00,760.00,0.00,0.00,0.00,0.00,0.00,729841),('1','197','257702','464',672.00,760.00,0.00,901.93,615116.26,685466.80,70350.54,729842),('1','197','257703','464',682.00,760.00,0.00,1357.13,925562.66,1031418.80,105856.14,729843),('1','197','257704','464',682.00,760.00,0.00,1541.10,1051030.20,1159636.00,108605.80,729844),('1','197','257705','464',682.00,760.00,0.00,1072.17,731219.94,801009.20,69789.26,729845),('1','197','257706','464',682.00,760.00,0.00,296.82,202431.24,225583.20,23151.96,729846),('1','197','257707','464',682.00,760.00,0.00,0.00,0.00,0.00,0.00,729847),('1','197','257708','464',682.00,760.00,0.00,492.00,335544.00,373920.00,38376.00,729848),('1','197','257709','464',682.00,760.00,0.00,777.47,530234.54,590877.20,60642.66,729849),('1','197','257710','464',682.00,760.00,0.00,840.61,573296.02,638863.60,65567.58,729850),('1','197','257711','464',682.00,760.00,0.00,527.52,359768.64,400915.20,41146.56,729851),('1','197','257712','464',682.00,760.00,0.00,776.67,529688.94,590269.20,60580.26,729852),('1','197','257713','464',682.00,760.00,0.00,711.91,485522.62,541051.60,55528.98,729853),('1','197','257714','464',682.00,760.00,0.00,691.95,471909.90,521561.04,49651.14,729854),('1','197','257715','464',682.00,760.00,0.00,131.85,89921.70,98626.80,8705.10,729855),('1','197','257716','464',682.00,760.00,0.00,10.76,7661.12,7661.12,0.00,729856),('1','197','257717','464',712.00,760.00,0.00,0.00,0.00,0.00,0.00,729857),('1','197','257718','464',712.00,760.00,0.00,730.30,498064.60,551915.68,53851.08,729858),('1','197','257719','464',682.00,760.00,0.00,1017.65,694037.30,764942.00,70904.70,729859),('1','197','257720','464',682.00,760.00,0.00,696.52,475026.64,525943.84,50917.20,729860),('1','197','257721','464',682.00,760.00,0.00,1004.49,685062.18,740470.76,55408.58,729861),('1','197','257722','464',682.00,744.00,0.00,1214.30,828152.60,894178.20,66025.60,729862),('1','197','257723','464',682.00,744.00,0.00,630.36,429905.52,448494.57,18589.05,729863),('1','197','257724','464',682.00,744.00,0.00,0.00,0.00,0.00,0.00,729864),('1','197','257725','464',682.00,744.00,0.00,681.87,465035.34,499580.55,34545.21,729865),('1','197','257726','464',682.00,744.00,0.00,1691.52,1153616.64,1221596.82,67980.18,729866),('1','197','257727','464',682.00,744.00,0.00,1498.02,1021649.64,1089144.88,67495.24,729867),('1','197','257728','464',682.00,744.00,0.00,1298.45,885542.90,946298.82,60755.92,729868),('1','197','257729','464',682.00,744.00,0.00,11.41,7781.62,8489.04,707.42,729869),('1','197','257730','464',682.00,744.00,0.00,0.00,0.00,0.00,0.00,729870),('1','197','257731','464',682.00,744.00,0.00,778.70,517835.50,574452.80,56617.30,729871),('1','197','257732','464',665.00,744.00,0.00,792.90,527278.50,578872.02,51593.52,729872),('1','197','257733','464',665.00,744.00,0.00,1736.89,1155031.85,1271274.16,116242.31,729873),('1','197','257734','464',665.00,744.00,0.00,1773.90,1179643.50,1266416.19,86772.69,729874),('1','197','257735','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729875),('1','197','257736','464',665.00,744.00,0.00,1841.66,1224703.90,1336100.84,111396.94,729876),('1','197','257737','464',665.00,744.00,0.00,1415.63,941393.95,1037254.72,95860.77,729877),('1','197','257738','464',665.00,744.00,0.00,1016.98,676291.70,751096.12,74804.42,729878),('1','197','257739','464',665.00,744.00,0.00,844.43,561545.95,599743.51,38197.56,729879),('1','197','257740','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729880),('1','197','257741','464',665.00,744.00,0.00,869.80,578417.00,612673.25,34256.25,729881),('1','197','257742','464',665.00,744.00,0.00,4227.75,2811453.75,2978922.83,167469.08,729882),('1','197','257743','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729883),('1','197','257744','464',665.00,744.00,0.00,1514.02,1006823.30,1100308.98,93485.68,729884),('1','197','257745','464',665.00,744.00,0.00,694.70,461975.50,522414.40,60438.90,729885),('1','197','257746','464',665.00,752.00,0.00,541.09,359824.85,406899.68,47074.83,729886),('1','197','257747','464',665.00,752.00,0.00,878.48,584189.20,660616.96,76427.76,729887),('1','197','257748','464',665.00,752.00,0.00,771.69,513173.85,580310.88,67137.03,729888),('1','197','257749','464',665.00,752.00,0.00,31.96,21253.40,24033.92,2780.52,729889),('1','197','257750','464',665.00,752.00,0.00,842.76,560435.40,633755.52,73320.12,729890),('1','197','257751','464',665.00,752.00,0.00,964.95,641691.75,725642.40,83950.65,729891),('1','197','257752','464',665.00,752.00,0.00,894.47,594822.55,672641.44,77818.89,729892),('1','197','257753','464',665.00,752.00,0.00,861.83,573116.95,648096.16,74979.21,729893),('1','197','257754','464',665.00,744.00,0.00,1394.26,927182.90,1020601.44,93418.54,729894),('1','197','257755','464',665.00,744.00,0.00,551.88,367000.20,393292.72,26292.52,729895),('1','197','257756','464',665.00,744.00,0.00,59.85,39800.25,42493.50,2693.25,729896),('1','197','257757','464',665.00,744.00,0.00,814.04,541336.60,601990.76,60654.16,729897),('1','197','257758','464',665.00,744.00,0.00,1404.01,933666.65,1024200.44,90533.79,729898),('1','197','257759','464',665.00,744.00,0.00,1222.40,812896.00,888289.04,75393.04,729899),('1','197','257760','464',665.00,744.00,0.00,1362.30,905929.50,991334.58,85405.08,729900),('1','197','257761','464',665.00,744.00,0.00,127.25,84621.25,90347.50,5726.25,729901),('1','197','257762','464',665.00,744.00,0.00,1222.33,812849.45,903118.08,90268.63,729902),('1','197','257763','464',665.00,744.00,0.00,1115.56,741847.40,822275.64,80428.24,729903),('1','197','257764','464',665.00,744.00,0.00,1244.07,827306.55,908536.74,81230.19,729904),('1','197','257765','464',665.00,744.00,0.00,1165.91,775330.15,862915.04,87584.89,729905),('1','197','257766','464',665.00,744.00,0.00,379.08,252088.20,278299.94,26211.74,729906),('1','197','257767','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729907),('1','197','257768','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729908),('1','197','257769','464',665.00,744.00,0.00,1450.54,964609.10,1060552.42,95943.32,729909),('1','197','257770','464',665.00,744.00,0.00,1155.24,768234.60,854364.56,86129.96,729910),('1','197','257771','464',665.00,744.00,0.00,1109.34,737711.10,818278.66,80567.56,729911),('1','197','257772','464',665.00,744.00,0.00,1475.33,981094.45,1077542.34,96447.89,729912),('1','197','257773','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729913),('1','197','257774','464',665.00,744.00,0.00,1195.27,794854.55,876564.88,81710.33,729914),('1','197','257775','464',665.00,744.00,0.00,2031.33,1350834.45,1477028.34,126193.89,729915),('1','197','257776','464',665.00,744.00,0.00,1760.71,1170872.15,1296398.16,125526.01,729916),('1','197','257777','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729917),('1','197','257778','464',665.00,744.00,0.00,1350.20,897883.00,988444.70,90561.70,729918),('1','197','257779','464',665.00,744.00,0.00,1877.40,1248471.00,1378737.38,130266.38,729919),('1','197','257780','464',665.00,744.00,0.00,1214.79,807835.35,884715.24,76879.89,729920),('1','197','257781','464',665.00,744.00,0.00,889.14,591278.10,641253.76,49975.66,729921),('1','197','257782','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729922),('1','197','257783','464',665.00,744.00,0.00,1832.30,1218479.50,1320536.24,102056.74,729923),('1','197','257784','464',665.00,744.00,0.00,892.34,593406.10,663900.96,70494.86,729924),('1','197','257785','464',665.00,744.00,0.00,961.89,639656.85,715646.16,75989.31,729925),('1','197','257786','464',665.00,744.00,0.00,437.06,290644.90,325172.64,34527.74,729926),('1','197','257787','464',665.00,744.00,0.00,0.00,0.00,0.00,0.00,729927),('1','197','257788','464',665.00,744.00,0.00,640.19,425726.35,476301.36,50575.01,729928),('1','197','257789','464',665.00,744.00,0.00,713.89,474736.85,531134.16,56397.31,729929),('1','197','257790','464',665.00,744.00,0.00,384.03,255379.95,285718.32,30338.37,729930),('1','197','257791','464',665.00,744.00,0.00,1113.92,740756.80,819845.12,79088.32,729931),('1','197','257792','464',665.00,736.00,0.00,581.93,386983.45,428300.48,41317.03,729932),('1','197','257793','464',665.00,736.00,0.00,0.00,0.00,0.00,0.00,729933),('1','197','257794','464',665.00,736.00,0.00,721.89,476447.40,531311.04,54863.64,729934),('1','197','257795','464',660.00,736.00,0.00,732.84,483674.40,539370.24,55695.84,729935),('1','197','257796','464',660.00,736.00,0.00,1034.65,682869.00,761502.40,78633.40,729936),('1','197','257797','464',660.00,736.00,0.00,826.99,545813.40,608664.64,62851.24,729937),('1','197','257798','464',660.00,736.00,0.00,1053.97,695620.20,775721.92,80101.72,729938),('1','197','257799','464',660.00,736.00,0.00,669.24,441698.40,492560.64,50862.24,729939),('1','197','257800','464',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729940),('1','197','257801','464',660.00,736.00,0.00,1054.41,695910.60,776045.76,80135.16,729941),('1','197','257802','464',660.00,736.00,0.00,1283.29,846971.40,937451.20,90479.80,729942),('1','197','257803','464',660.00,736.00,0.00,1773.86,1170747.60,1270892.96,100145.36,729943),('1','197','257804','464',660.00,736.00,0.00,658.84,434834.40,475726.24,40891.84,729944),('1','197','257805','464',660.00,736.00,0.00,39.93,29388.48,29388.48,0.00,729945),('1','197','257806','464',736.00,736.00,0.00,1853.99,1223633.40,1341447.68,117814.28,729946),('1','197','257807','464',660.00,736.00,0.00,1509.96,996573.60,1091942.76,95369.16,729947),('1','197','257808','464',660.00,736.00,0.00,1117.45,737517.00,817194.04,79677.04,729948),('1','197','257809','464',660.00,736.00,0.00,527.60,348216.00,388313.60,40097.60,729949),('1','197','257810','464',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729950),('1','197','257811','464',660.00,736.00,0.00,758.69,500735.40,558395.84,57660.44,729951),('1','197','257812','464',660.00,736.00,0.00,758.72,500755.20,558417.92,57662.72,729952),('1','197','257813','464',660.00,736.00,0.00,1020.10,673266.00,750793.60,77527.60,729953),('1','197','257814','464',660.00,736.00,0.00,810.82,535141.20,596763.52,61622.32,729954),('1','197','257815','464',660.00,736.00,0.00,883.37,583024.20,650160.32,67136.12,729955),('1','197','257816','464',660.00,736.00,0.00,0.00,0.00,0.00,0.00,729956),('1','197','257817','464',660.00,748.00,0.00,1392.92,919327.20,1041904.16,122576.96,729957),('1','197','257818','464',660.00,748.00,0.00,1605.95,1059927.00,1201250.60,141323.60,729958),('1','197','257819','464',660.00,748.00,0.00,952.23,628471.80,712268.04,83796.24,729959),('1','197','257820','464',660.00,748.00,0.00,90.70,59862.00,67843.60,7981.60,729960),('1','197','257821','464',660.00,748.00,0.00,0.00,0.00,0.00,0.00,729961),('1','197','257822','464',660.00,748.00,0.00,383.85,253341.00,287119.80,33778.80,729962),('1','197','257823','464',660.00,748.00,0.00,1022.11,674592.60,764538.28,89945.68,729963),('1','197','257824','464',660.00,748.00,0.00,896.93,591973.80,670903.64,78929.84,729964),('1','197','257825','464',660.00,748.00,0.00,887.65,585849.00,663962.20,78113.20,729965),('1','197','257826','464',660.00,748.00,0.00,1061.38,700510.80,806648.80,106138.00,729966),('1','197','257827','464',660.00,760.00,0.00,911.99,601913.40,693112.40,91199.00,729967),('1','197','257828','464',660.00,760.00,0.00,0.00,0.00,0.00,0.00,729968),('1','197','257829','464',660.00,760.00,0.00,1301.29,858851.40,988980.40,130129.00,729969),('1','197','257830','464',660.00,760.00,0.00,1503.27,992158.20,1142485.20,150327.00,729970),('1','197','257831','464',660.00,760.00,0.00,1457.70,962082.00,1107852.00,145770.00,729971),('1','197','257832','464',660.00,760.00,0.00,1167.72,770695.20,887467.20,116772.00,729972),('1','197','257833','464',660.00,760.00,0.00,0.00,0.00,0.00,0.00,729973),('1','197','257834','464',660.00,760.00,0.00,697.66,460455.60,530221.60,69766.00,729974),('1','197','257835','464',660.00,760.00,0.00,805.35,531531.00,644280.00,112749.00,729975),('1','197','257836','464',660.00,800.00,0.00,1188.21,784218.60,950568.00,166349.40,729976),('1','197','257837','464',660.00,800.00,0.00,815.43,538183.80,652344.00,114160.20,729977),('1','197','257838','464',660.00,800.00,0.00,1015.46,670203.60,780362.00,110158.40,729978),('1','197','257839','464',660.00,760.00,0.00,408.65,269709.00,310574.00,40865.00,729979),('1','197','257840','464',660.00,760.00,0.00,0.00,0.00,0.00,0.00,729980),('1','197','257841','464',660.00,760.00,0.00,516.00,340560.00,392160.00,51600.00,729981),('1','197','257842','464',660.00,760.00,0.00,1130.43,746083.80,859126.80,113043.00,729982),('1','197','257843','464',660.00,760.00,0.00,1130.02,745813.20,858815.20,113002.00,729983),('1','197','257844','464',660.00,760.00,0.00,620.39,409457.40,471496.40,62039.00,729984),('1','197','257845','464',660.00,760.00,0.00,213.14,140672.40,161986.40,21314.00,729985),('1','197','257846','464',660.00,760.00,0.00,31.68,20908.80,24076.80,3168.00,729986),('1','197','257847','464',660.00,760.00,0.00,406.22,268105.20,308727.20,40622.00,729987),('1','197','257848','464',660.00,760.00,0.00,638.40,421344.00,485184.00,63840.00,729988),('1','197','257849','464',660.00,760.00,0.00,703.53,464329.80,534682.80,70353.00,729989),('1','197','257850','464',660.00,760.00,0.00,560.68,370048.80,426116.80,56068.00,729990),('1','197','257851','464',660.00,760.00,0.00,1070.95,706827.00,813922.00,107095.00,729991),('1','197','257852','464',660.00,760.00,0.00,1020.22,673345.20,775367.20,102022.00,729992),('1','197','257853','464',660.00,760.00,0.00,340.00,224400.00,258400.00,34000.00,729993),('1','197','257854','464',660.00,760.00,0.00,44.85,29601.00,34086.00,4485.00,729994),('1','197','257855','464',660.00,760.00,0.00,365.77,250552.45,277985.20,27432.75,729995),('1','197','257856','464',685.00,760.00,0.00,750.67,514208.95,570509.20,56300.25,729996),('1','197','257857','464',685.00,760.00,0.00,794.99,544568.15,604192.40,59624.25,729997),('1','197','257858','464',685.00,760.00,0.00,785.58,538122.30,597040.80,58918.50,729998),('1','197','257859','464',685.00,760.00,0.00,766.55,525086.75,582578.00,57491.25,729999),('1','197','257860','464',685.00,760.00,0.00,1045.61,716242.85,789378.35,73135.50,730000),('1','197','257861','464',685.00,760.00,0.00,651.96,446592.60,488807.10,42214.50,730001),('1','197','257862','464',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730002),('1','197','257863','464',685.00,760.00,0.00,380.05,260334.25,286273.00,25938.75,730003),('1','197','257864','464',685.00,760.00,0.00,1020.03,698720.55,766511.25,67790.70,730004),('1','197','257865','464',685.00,760.00,0.00,859.37,588668.45,650106.20,61437.75,730005),('1','197','257866','464',685.00,760.00,0.00,920.70,630679.50,689851.80,59172.30,730006),('1','197','257867','464',685.00,760.00,0.00,954.17,653606.45,724179.20,70572.75,730007),('1','197','257868','464',685.00,760.00,0.00,985.20,674862.00,745394.00,70532.00,730008),('1','197','257869','464',685.00,760.00,0.00,0.00,0.00,0.00,0.00,730009),('1','197','257870','464',685.00,760.00,0.00,1200.74,822506.90,896128.40,73621.50,730010),('1','197','257871','464',685.00,760.00,0.00,1343.55,920331.75,1008084.50,87752.75,730011),('1','197','257872','464',685.00,760.00,0.00,1101.84,754760.40,822887.90,68127.50,730012),('1','197','257873','464',685.00,760.00,0.00,1114.83,763658.55,834830.30,71171.75,730013),('1','197','257874','464',685.00,760.00,0.00,29.02,19878.70,22055.20,2176.50,730014),('1','197','257875','464',660.00,760.00,0.00,171.46,113163.60,130309.60,17146.00,730015),('1','197','257876','464',660.00,760.00,0.00,801.66,529095.60,592431.60,63336.00,730016),('1','197','257877','464',660.00,760.00,0.00,525.34,346724.40,387460.00,40735.60,730017),('1','197','257878','464',660.00,760.00,0.00,987.18,651538.80,729996.00,78457.20,730018),('1','197','257879','464',660.00,760.00,0.00,1901.94,1255280.40,1392778.80,137498.40,730019),('1','197','257880','464',660.00,760.00,0.00,671.83,443407.80,509870.80,66463.00,730020),('1','197','257881','464',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730021),('1','197','257882','464',660.00,760.00,0.00,0.00,0.00,0.00,0.00,730022),('1','197','257883','464',660.00,760.00,0.00,1447.71,955488.60,1064319.60,108831.00,730023),('1','197','257884','464',660.00,760.00,0.00,1209.43,798223.80,890368.00,92144.20,730024),('1','197','257885','464',660.00,760.00,0.00,1206.43,796243.80,881912.20,85668.40,730025),('1','197','257886','464',660.00,760.00,0.00,1126.41,743430.60,834660.60,91230.00,730026),('1','197','257887','464',660.00,760.00,0.00,17.07,11266.20,12973.20,1707.00,730027),('1','197','257888','464',660.00,760.00,0.00,931.07,614506.20,671991.32,57485.12,730028),('1','197','257889','464',660.00,736.00,0.00,570.77,376708.20,413801.84,37093.64,730029),('1','197','257890','464',660.00,736.00,0.00,1359.57,897316.20,995315.52,97999.32,730030),('1','197','257891','464',660.00,736.00,0.00,1291.82,852601.20,928067.84,75466.64,730031),('1','197','257892','464',660.00,736.00,0.00,836.77,552268.20,603226.72,50958.52,730032),('1','197','257893','464',660.00,736.00,0.00,79.16,52245.60,58261.76,6016.16,730033),('1','197','257894','464',660.00,736.00,0.00,1439.43,942973.14,1047378.48,104405.34,730034),('1','197','257895','464',654.00,736.00,0.00,1175.92,769051.68,849580.96,80529.28,730035),('1','197','257896','464',654.00,736.00,0.00,794.99,519923.46,576754.16,56830.70,730036),('1','197','257897','464',654.00,736.00,0.00,1499.66,980777.64,1081958.96,101181.32,730037),('1','197','257898','464',654.00,736.00,0.00,88.38,57800.52,65047.68,7247.16,730038),('1','197','257899','464',654.00,736.00,0.00,1541.82,1008350.28,1106272.92,97922.64,730039),('1','197','257900','464',654.00,736.00,0.00,1207.97,790012.38,875128.88,85116.50,730040),('1','197','257901','464',654.00,736.00,0.00,1523.60,996434.40,1096194.44,99760.04,730041),('1','197','257902','464',654.00,736.00,0.00,766.61,501362.94,546008.96,44646.02,730042),('1','197','257903','464',654.00,736.00,0.00,41.13,26899.02,30271.68,3372.66,730043),('1','197','257904','464',654.00,736.00,0.00,1010.64,660958.56,736390.92,75432.36,730044),('1','197','257905','464',654.00,736.00,0.00,2741.60,1793006.40,1962899.60,169893.20,730045),('1','197','257906','464',654.00,736.00,0.00,1287.76,842195.04,931767.76,89572.72,730046),('1','197','257907','464',654.00,736.00,0.00,2843.53,1859668.62,2040549.52,180880.90,730047),('1','197','257908','464',654.00,736.00,0.00,1215.94,795224.76,881536.24,86311.48,730048),('1','197','257909','464',654.00,736.00,0.00,710.66,464771.64,520237.76,55466.12,730049),('1','197','257910','464',654.00,736.00,0.00,439.32,287315.28,318319.32,31004.04,730050),('1','197','257911','464',654.00,736.00,0.00,21.78,14244.12,16030.08,1785.96,730051),('1','197','257912','464',654.00,736.00,0.00,1135.04,742316.16,826533.44,84217.28,730052),('1','197','257913','464',654.00,736.00,0.00,1011.53,661540.62,736292.84,74752.22,730053),('1','197','257914','464',654.00,736.00,0.00,732.74,479211.96,538684.64,59472.68,730054),('1','197','257915','464',654.00,736.00,0.00,1208.82,790568.28,874642.80,84074.52,730055),('1','197','257916','464',654.00,736.00,0.00,769.48,503239.92,562737.28,59497.36,730056),('1','197','257917','464',654.00,736.00,0.00,112.39,73503.06,82503.04,8999.98,730057),('1','197','257918','464',654.00,736.00,0.00,47.93,31346.22,35276.48,3930.26,730058),('1','197','257919','464',654.00,736.00,0.00,527.82,345194.28,386495.16,41300.88,730059),('1','197','257920','464',654.00,736.00,0.00,1346.72,880754.88,979562.96,98808.08,730060),('1','197','257921','464',654.00,736.00,0.00,991.08,648166.32,723026.88,74860.56,730061),('1','197','257922','464',654.00,736.00,0.00,1204.98,788056.92,873060.72,85003.80,730062),('1','197','257923','464',654.00,736.00,0.00,1060.80,693763.20,757887.72,64124.52,730063),('1','197','257924','464',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730064),('1','197','257925','464',654.00,736.00,0.00,1389.19,908530.26,998915.30,90385.04,730065),('1','197','257926','464',654.00,736.00,0.00,1200.05,784832.70,866216.80,81384.10,730066),('1','197','257927','464',654.00,736.00,0.00,1447.91,946933.14,1049209.86,102276.72,730067),('1','197','257928','464',654.00,736.00,0.00,1065.02,696523.08,757065.70,60542.62,730068),('1','197','257929','464',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730069),('1','197','257930','464',654.00,736.00,0.00,1914.92,1252357.68,1358509.26,106151.58,730070),('1','197','257931','464',654.00,736.00,0.00,1536.11,1004615.94,1098597.30,93981.36,730071),('1','197','257932','464',654.00,736.00,0.00,1265.13,827395.02,906893.68,79498.66,730072),('1','197','257933','464',654.00,736.00,0.00,424.25,277459.50,306038.00,28578.50,730073),('1','197','257934','464',654.00,736.00,0.00,0.00,0.00,0.00,0.00,730074),('1','197','257935','464',654.00,736.00,0.00,793.48,518935.92,570514.08,51578.16,730075),('1','197','257936','464',654.00,736.00,0.00,348.14,227683.56,254821.14,27137.58,730076),('1','197','257937','464',654.00,736.00,0.00,1324.70,866353.80,954063.00,87709.20,730077),('1','197','257938','464',654.00,736.00,0.00,1996.64,1305802.56,1413444.76,107642.20,730078),('1','197','257939','464',654.00,736.00,0.00,697.02,455851.08,495565.82,39714.74,730079),('1','197','257940','464',654.00,736.00,0.00,61.66,40325.64,45381.76,5056.12,730080),('1','197','257941','464',654.00,736.00,0.00,1626.44,1063691.76,1160439.24,96747.48,730081),('1','197','257942','464',654.00,736.00,0.00,1700.41,1112068.14,1218034.46,105966.32,730082),('1','197','257943','464',654.00,736.00,0.00,1653.15,1081160.10,1163237.28,82077.18,730083),('1','197','257944','464',654.00,736.00,0.00,1.05,686.70,714.00,27.30,730084),('1','197','257945','464',630.00,736.00,0.00,1818.91,1145913.30,1307508.96,161595.66,730085),('1','197','257946','464',630.00,736.00,0.00,1641.10,1033893.00,1165323.76,131430.76,730086),('1','197','257947','464',630.00,736.00,0.00,693.41,436848.30,491007.92,54159.62,730087),('1','197','257948','464',630.00,736.00,0.00,1086.58,684545.40,756392.32,71846.92,730088),('1','197','257949','464',630.00,736.00,0.00,53.90,33957.00,36652.00,2695.00,730089),('1','197','257950','464',630.00,736.00,0.00,794.63,500616.90,561831.68,61214.78,730090),('1','197','257951','464',630.00,736.00,0.00,1175.49,740558.70,837573.36,97014.66,730091),('1','197','257952','464',630.00,736.00,0.00,1122.90,707427.00,806519.52,99092.52,730092),('1','197','257953','464',630.00,736.00,0.00,1409.84,888199.20,1003314.24,115115.04,730093),('1','197','257954','464',630.00,736.00,0.00,673.32,424191.60,484020.24,59828.64,730094),('1','197','257955','464',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730095),('1','197','257956','464',630.00,736.00,0.00,714.20,449946.00,498097.52,48151.52,730096),('1','197','257957','464',630.00,736.00,0.00,1214.47,765116.10,868583.84,103467.74,730097),('1','197','257958','464',630.00,736.00,0.00,1268.57,799199.10,904278.72,105079.62,730098),('1','197','257959','464',630.00,736.00,0.00,1278.36,805366.80,913935.84,108569.04,730099),('1','197','257960','464',630.00,736.00,0.00,0.00,0.00,0.00,0.00,730100),('1','197','257961','464',630.00,736.00,0.00,594.38,374459.40,428456.64,53997.24,730101),('1','197','257962','464',630.00,736.00,0.00,74.80,47124.00,55052.80,7928.80,730102),('1','197','257963','464',630.00,736.00,0.00,1519.53,957303.90,1084657.60,127353.70,730103),('1','197','257964','464',630.00,736.00,0.00,1082.68,682088.40,786554.64,104466.24,730104),('1','197','257965','464',630.00,736.00,0.00,797.93,502695.90,575236.48,72540.58,730105),('1','197','257966','464',630.00,736.00,0.00,1579.86,995311.80,1114936.16,119624.36,730106),('1','197','257967','464',630.00,736.00,0.00,144.33,90927.90,106226.88,15298.98,730107),('1','197','257968','464',630.00,736.00,0.00,1149.45,724153.50,825609.00,101455.50,730108),('1','197','257969','464',630.00,736.00,0.00,1354.94,853612.20,959287.74,105675.54,730109),('1','197','257970','464',630.00,736.00,0.00,797.52,502437.60,568857.72,66420.12,730110),('1','197','257971','464',630.00,736.00,0.00,1267.62,798600.60,910026.83,111426.23,730111),('1','197','257972','464',630.00,736.00,0.00,830.47,523196.10,578012.64,54816.54,730112),('1','197','257973','464',630.00,736.00,0.00,102.64,64663.20,69282.00,4618.80,730113),('1','197','257974','464',630.00,736.00,0.00,2163.94,1363282.20,1520510.26,157228.06,730114),('1','197','257975','464',630.00,736.00,0.00,1190.98,750317.40,863446.28,113128.88,730115),('1','197','257976','464',630.00,736.00,0.00,852.21,536892.30,613745.56,76853.26,730116),('1','197','257977','464',630.00,736.00,0.00,879.87,554318.10,635403.84,81085.74,730117),('1','197','257978','464',630.00,736.00,0.00,2316.77,1459565.10,1637000.23,177435.13,730118),('1','197','257979','464',630.00,736.00,0.00,1276.30,804069.00,923916.48,119847.48,730119),('1','197','257980','464',630.00,736.00,0.00,1030.60,649278.00,744217.10,94939.10,730120),('1','197','257981','464',630.00,736.00,0.00,849.33,535077.90,591128.66,56050.76,730121),('1','197','257982','464',630.00,736.00,0.00,72.75,45832.50,53544.00,7711.50,730122),('1','197','257983','464',630.00,736.00,0.00,1543.73,972549.90,1122356.58,149806.68,730123),('1','197','257984','464',630.00,736.00,0.00,1562.55,984406.50,1118717.57,134311.07,730124),('1','197','257985','464',630.00,736.00,0.00,2313.72,1457643.60,1649674.81,192031.21,730125),('1','197','257986','464',630.00,736.00,0.00,45.94,28942.20,33811.84,4869.64,730126),('1','197','257987','464',630.00,736.00,0.00,2080.49,1310708.70,1481720.84,171012.14,730127),('1','197','257988','464',630.00,736.00,0.00,1656.55,1043626.50,1177504.73,133878.23,730128),('1','197','257989','464',630.00,736.00,0.00,1452.96,915364.80,1019997.84,104633.04,730129),('1','197','257990','464',630.00,736.00,0.00,33.80,21294.00,24876.80,3582.80,730130),('1','197','257991','464',630.00,736.00,0.00,702.93,442845.90,507596.48,64750.58,730131),('1','197','257992','464',630.00,736.00,0.00,1126.18,709493.40,805500.60,96007.20,730132),('1','197','257993','464',630.00,736.00,0.00,1095.85,690385.50,803202.80,112817.30,730133),('1','197','257994','464',630.00,736.00,0.00,1668.59,1051211.70,1184533.12,133321.42,730134),('1','197','257995','464',630.00,736.00,0.00,1944.10,1224783.00,1374610.11,149827.11,730135),('1','197','257996','464',630.00,736.00,0.00,1322.86,833401.80,935987.35,102585.55,730136),('1','197','257997','464',630.00,736.00,0.00,1217.82,767226.60,858699.26,91472.66,730137),('1','197','257998','464',630.00,736.00,0.00,165.35,104170.50,113102.36,8931.86,730138),('1','197','257999','464',630.00,700.00,0.00,336.32,211881.60,221802.56,9920.96,730139),('1','197','258000','464',624.00,700.00,0.00,131.56,82093.44,87553.48,5460.04,730140),('1','197','258001','464',624.00,700.00,0.00,1462.20,912412.80,993903.96,81491.16,730141),('1','197','258002','464',624.00,700.00,0.00,1020.34,636692.16,707476.00,70783.84,730142),('1','197','258003','464',624.00,700.00,0.00,1158.95,723184.80,805897.40,82712.60,730143),('1','197','258004','464',624.00,700.00,0.00,1568.51,978750.24,1057721.00,78970.76,730144),('1','197','258005','464',624.00,700.00,0.00,0.00,0.00,0.00,0.00,730145),('1','197','258006','464',624.00,700.00,0.00,19.60,12230.40,13720.00,1489.60,730146),('1','197','258007','464',624.00,700.00,0.00,1192.23,743951.52,807647.82,63696.30,730147),('1','197','258008','464',624.00,700.00,0.00,1744.65,1088661.60,1183412.58,94750.98,730148),('1','197','258009','464',624.00,700.00,0.00,965.90,602721.60,674681.20,71959.60,730149),('1','197','258010','464',624.00,700.00,0.00,1127.22,703385.28,770538.30,67153.02,730150),('1','197','258011','464',624.00,700.00,0.00,8.26,5154.24,5782.00,627.76,730151),('1','197','258012','464',624.00,700.00,0.00,258.33,161197.92,170906.82,9708.90,730152),('1','197','258013','464',624.00,700.00,0.00,463.34,289124.16,316247.00,27122.84,730153),('1','197','258014','464',624.00,700.00,0.00,1784.69,1113646.56,1193583.00,79936.44,730154);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=422 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',421,'197','LPG PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1019 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','197','421',1018,1,'464','LPG TANK ',6000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT','479','2021-10-29 23:13:47','2021-10-29 23:13:47','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','197',1018,2523.64,'2023-03-20 19:58:52');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2673184 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2109675,'1','197','1018',464,'Retail Sale Id 1254777',350400.00,0.00,0.00,0.00,17520.00,'2021-12-01 07:45:58','',''),(2109676,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,584.00,0.00,'2021-12-01 07:45:58','',''),(2109701,'1','197','1018',464,'Retail Sale Id 1254792',7502.88,0.00,0.00,0.00,560.28,'2021-12-01 07:47:04','',''),(2109702,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.18,0.00,'2021-12-01 07:47:04','',''),(2110270,'1','197','1018',464,'Retail Sale Id 1255072',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 08:17:24','',''),(2110271,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:17:24','',''),(2110457,'1','197','1018',464,'Retail Sale Id 1255167',174600.00,0.00,0.00,0.00,8730.00,'2021-12-01 08:28:59','',''),(2110458,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,291.00,0.00,'2021-12-01 08:28:59','',''),(2110560,'1','197','1018',464,'Retail Sale Id 1255212',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 08:34:23','',''),(2110561,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:34:23','',''),(2110647,'1','197','1018',464,'Retail Sale Id 1255252',42498.00,0.00,0.00,0.00,2124.90,'2021-12-01 08:39:46','',''),(2110648,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,70.83,0.00,'2021-12-01 08:39:46','',''),(2111182,'1','197','1018',464,'Retail Sale Id 1255528',21000.00,0.00,0.00,0.00,1050.00,'2021-12-01 09:11:18','',''),(2111183,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-01 09:11:18','',''),(2111442,'1','197','1018',464,'Retail Sale Id 1255555',80400.00,0.00,0.00,0.00,4020.00,'2021-12-01 09:26:22','',''),(2111443,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,134.00,0.00,'2021-12-01 09:26:22','',''),(2113290,'1','197','1018',464,'Retail Sale Id 1256588',28200.00,0.00,0.00,0.00,1410.00,'2021-12-01 11:37:12','',''),(2113291,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-01 11:37:12','',''),(2113333,'1','197','1018',464,'Retail Sale Id 1256607',23100.00,0.00,0.00,0.00,1725.00,'2021-12-01 11:40:01','',''),(2113334,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-01 11:40:01','',''),(2113349,'1','197','1018',464,'Retail Sale Id 1256619',3702.16,0.00,0.00,0.00,276.46,'2021-12-01 11:41:35','',''),(2113350,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 11:41:35','',''),(2113388,'1','197','1018',464,'Retail Sale Id 1256641',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 11:44:30','',''),(2113389,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:44:30','',''),(2113537,'1','197','1018',464,'Retail Sale Id 1256715',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 11:56:01','',''),(2113538,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:56:01','',''),(2113681,'1','197','1018',464,'Retail Sale Id 1256791',11402.16,0.00,0.00,0.00,851.46,'2021-12-01 12:11:51','',''),(2113682,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-01 12:11:51','',''),(2116281,'1','197','1018',464,'Retail Sale Id 1258056',2002.00,0.00,0.00,0.00,149.50,'2021-12-01 15:14:17','',''),(2116282,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-01 15:14:17','',''),(2116376,'1','197','1018',464,'Retail Sale Id 1258097',3702.16,0.00,0.00,0.00,276.46,'2021-12-01 15:19:26','',''),(2116377,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 15:19:26','',''),(2116402,'1','197','1018',464,'Retail Sale Id 1258109',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 15:21:09','',''),(2116403,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:21:09','',''),(2116424,'1','197','1018',464,'Retail Sale Id 1258121',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 15:22:14','',''),(2116425,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:22:14','',''),(2116503,'1','197','1018',464,'Retail Sale Id 1258148',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 15:26:51','',''),(2116504,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:26:51','',''),(2116632,'1','197','1018',464,'Retail Sale Id 1258220',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 15:35:42','',''),(2116633,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:35:42','',''),(2116714,'1','197','1018',464,'Retail Sale Id 1258260',3702.16,0.00,0.00,0.00,276.46,'2021-12-01 15:41:06','',''),(2116715,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-01 15:41:06','',''),(2116860,'1','197','1018',464,'Retail Sale Id 1258320',36960.00,0.00,0.00,0.00,2760.00,'2021-12-01 15:47:54','',''),(2116861,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 15:47:54','',''),(2117235,'1','197','1018',464,'Retail Sale Id 1258509',9240.00,0.00,0.00,0.00,690.00,'2021-12-01 16:04:25','',''),(2117236,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 16:04:25','',''),(2117277,'1','197','1018',464,'Retail Sale Id 1258522',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 16:05:45','',''),(2117278,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:05:45','',''),(2117314,'1','197','1018',464,'Retail Sale Id 1258539',7700.00,0.00,0.00,0.00,575.00,'2021-12-01 16:07:06','',''),(2117315,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:07:06','',''),(2119492,'1','197','1018',464,'Retail Sale Id 1259641',108216.00,0.00,0.00,0.00,5410.80,'2021-12-01 18:19:57','',''),(2119493,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,180.36,0.00,'2021-12-01 18:19:57','',''),(2119526,'1','197','1018',464,'Retail Sale Id 1259657',11660.88,0.00,0.00,0.00,870.78,'2021-12-01 18:23:27','',''),(2119527,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,18.93,0.00,'2021-12-01 18:23:27','',''),(2119569,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,7615.20,13.36,0.00,0.00,'2021-12-01 18:30:10','',''),(2119583,'1','197',NULL,464,'Reception corrector for bridging 125877',0.00,0.00,0.00,13.36,0.00,'2021-12-01 18:31:40','',''),(2119584,'1','197','1018',464,'Received from bridging 125877',0.00,0.00,13.36,0.00,0.00,'2021-12-01 18:31:40','',''),(2119591,'1','197','1018',464,'Retail Sale Id 1259679',8229.76,0.00,0.00,0.00,614.56,'2021-12-01 18:32:45','',''),(2119592,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,13.36,0.00,'2021-12-01 18:32:45','',''),(2121590,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2986800.00,5240.00,0.00,0.00,'2021-12-02 07:16:52','',''),(2121643,'1','197',NULL,464,'Reception corrector for bridging 125909',0.00,0.00,0.00,5240.00,0.00,'2021-12-02 07:18:48','',''),(2121644,'1','197','1018',464,'Received from bridging 125909',0.00,0.00,5240.00,0.00,0.00,'2021-12-02 07:18:48','',''),(2121692,'1','197','1018',464,'Retail Sale Id 1260420',3997.84,0.00,0.00,0.00,298.54,'2021-12-02 07:21:38','',''),(2121693,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-02 07:21:38','',''),(2121739,'1','197','1018',464,'Retail Sale Id 1260439',9997.68,0.00,0.00,0.00,746.58,'2021-12-02 07:24:04','',''),(2121740,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,16.23,0.00,'2021-12-02 07:24:04','',''),(2121775,'1','197','1018',464,'Retail Sale Id 1260457',1299.76,0.00,0.00,0.00,97.06,'2021-12-02 07:25:35','',''),(2121776,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-02 07:25:35','',''),(2121793,'1','197','1018',464,'Retail Sale Id 1260470',997.92,0.00,0.00,0.00,74.52,'2021-12-02 07:26:22','',''),(2121794,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-02 07:26:22','',''),(2121849,'1','197','1018',464,'Retail Sale Id 1260504',1897.28,0.00,0.00,0.00,141.68,'2021-12-02 07:29:08','',''),(2121850,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-02 07:29:08','',''),(2122395,'1','197','1018',464,'Retail Sale Id 1260785',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 07:54:21','',''),(2122396,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:54:21','',''),(2122653,'1','197','1018',464,'Retail Sale Id 1260897',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 08:04:24','',''),(2122654,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:04:24','',''),(2122671,'1','197','1018',464,'Retail Sale Id 1260909',3997.84,0.00,0.00,0.00,298.54,'2021-12-02 08:05:18','',''),(2122672,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-02 08:05:18','',''),(2122803,'1','197','1018',464,'Retail Sale Id 1260974',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 08:12:26','',''),(2122804,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 08:12:26','',''),(2122815,'1','197','1018',464,'Retail Sale Id 1260981',2002.00,0.00,0.00,0.00,149.50,'2021-12-02 08:13:13','',''),(2122816,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-02 08:13:13','',''),(2123153,'1','197','1018',464,'Retail Sale Id 1261154',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 08:30:17','',''),(2123154,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 08:30:17','',''),(2123707,'1','197','1018',464,'Retail Sale Id 1261412',24000.00,0.00,0.00,0.00,1200.00,'2021-12-02 08:59:33','',''),(2123708,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 08:59:33','',''),(2124222,'1','197','1018',464,'Retail Sale Id 1261659',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 09:24:05','',''),(2124223,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 09:24:05','',''),(2124286,'1','197','1018',464,'Retail Sale Id 1261693',3098.48,0.00,0.00,0.00,231.38,'2021-12-02 09:27:44','',''),(2124287,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-02 09:27:44','',''),(2124399,'1','197','1018',464,'Retail Sale Id 1261750',15400.00,0.00,0.00,0.00,1150.00,'2021-12-02 09:34:49','',''),(2124400,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 09:34:49','',''),(2124439,'1','197','1018',464,'Retail Sale Id 1261771',90000.00,0.00,0.00,0.00,4500.00,'2021-12-02 09:38:25','',''),(2124440,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 09:38:25','',''),(2125430,'1','197','1018',464,'Retail Sale Id 1262278',457500.00,0.00,0.00,0.00,22875.00,'2021-12-02 10:33:35','',''),(2125431,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,762.50,0.00,'2021-12-02 10:33:35','',''),(2125608,'1','197','1018',464,'Retail Sale Id 1262362',52002.00,0.00,0.00,0.00,2600.10,'2021-12-02 10:43:50','',''),(2125609,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,86.67,0.00,'2021-12-02 10:43:50','',''),(2125988,'1','197','1018',464,'Retail Sale Id 1262551',49200.00,0.00,0.00,0.00,2460.00,'2021-12-02 11:08:45','',''),(2125989,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,82.00,0.00,'2021-12-02 11:08:45','',''),(2126561,'1','197','1018',464,'Retail Sale Id 1262829',6196.96,0.00,0.00,0.00,462.76,'2021-12-02 11:38:33','',''),(2126562,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-02 11:38:33','',''),(2127026,'1','197','1018',464,'Retail Sale Id 1263063',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 12:16:59','',''),(2127027,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:16:59','',''),(2127098,'1','197','1018',464,'Retail Sale Id 1263104',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 12:22:52','',''),(2127099,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:22:52','',''),(2127268,'1','197','1018',464,'Retail Sale Id 1263208',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 12:35:21','',''),(2127269,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:35:21','',''),(2127558,'1','197','1018',464,'Retail Sale Id 1263339',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 12:57:56','',''),(2127559,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:57:56','',''),(2127582,'1','197','1018',464,'Retail Sale Id 1263350',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 12:59:25','',''),(2127583,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 12:59:25','',''),(2129491,'1','197','1018',464,'Retail Sale Id 1264168',3098.48,0.00,0.00,0.00,231.38,'2021-12-02 14:47:21','',''),(2129492,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-02 14:47:21','',''),(2129809,'1','197','1018',464,'Retail Sale Id 1264333',2002.00,0.00,0.00,0.00,149.50,'2021-12-02 15:07:28','',''),(2129810,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-02 15:07:28','',''),(2129833,'1','197','1018',464,'Retail Sale Id 1264344',40003.04,0.00,0.00,0.00,2987.24,'2021-12-02 15:08:55','',''),(2129834,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,64.94,0.00,'2021-12-02 15:08:55','',''),(2129864,'1','197','1018',464,'Retail Sale Id 1264357',30000.00,0.00,0.00,0.00,1500.00,'2021-12-02 15:11:04','',''),(2129866,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 15:11:04','',''),(2130219,'1','197','1018',464,'Retail Sale Id 1264527',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 15:28:19','',''),(2130220,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 15:28:19','',''),(2130374,'1','197','1018',464,'Retail Sale Id 1264607',2500.96,0.00,0.00,0.00,186.76,'2021-12-02 15:35:38','',''),(2130375,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-02 15:35:38','',''),(2130416,'1','197','1018',464,'Retail Sale Id 1264627',3098.48,0.00,0.00,0.00,231.38,'2021-12-02 15:37:09','',''),(2130417,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-02 15:37:09','',''),(2130442,'1','197','1018',464,'Retail Sale Id 1264641',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 15:38:44','',''),(2130443,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 15:38:44','',''),(2130466,'1','197','1018',464,'Retail Sale Id 1264651',6997.76,0.00,0.00,0.00,522.56,'2021-12-02 15:39:56','',''),(2130467,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-02 15:39:56','',''),(2130498,'1','197','1018',464,'Retail Sale Id 1264668',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 15:41:17','',''),(2130499,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:41:17','',''),(2130890,'1','197','1018',464,'Retail Sale Id 1264883',1897.28,0.00,0.00,0.00,141.68,'2021-12-02 15:58:26','',''),(2130891,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-02 15:58:26','',''),(2131100,'1','197','1018',464,'Retail Sale Id 1264976',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:07:38','',''),(2131101,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:07:38','',''),(2131160,'1','197','1018',464,'Retail Sale Id 1265003',3098.48,0.00,0.00,0.00,231.38,'2021-12-02 16:09:49','',''),(2131161,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-02 16:09:49','',''),(2131259,'1','197','1018',464,'Retail Sale Id 1265053',30800.00,0.00,0.00,0.00,2300.00,'2021-12-02 16:14:55','',''),(2131260,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 16:14:55','',''),(2131400,'1','197','1018',464,'Retail Sale Id 1265135',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:22:23','',''),(2131401,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:22:23','',''),(2131468,'1','197','1018',464,'Retail Sale Id 1265166',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:25:53','',''),(2131469,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:25:53','',''),(2131534,'1','197','1018',464,'Retail Sale Id 1265199',997.92,0.00,0.00,0.00,74.52,'2021-12-02 16:28:47','',''),(2131535,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-02 16:28:47','',''),(2131616,'1','197','1018',464,'Retail Sale Id 1265214',15400.00,0.00,0.00,0.00,1150.00,'2021-12-02 16:30:05','',''),(2131617,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-02 16:30:05','',''),(2131656,'1','197','1018',464,'Retail Sale Id 1265241',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 16:31:44','',''),(2131657,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:31:44','',''),(2131762,'1','197','1018',464,'Retail Sale Id 1265305',1897.28,0.00,0.00,0.00,141.68,'2021-12-02 16:37:55','',''),(2131763,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-02 16:37:55','',''),(2131911,'1','197','1018',464,'Retail Sale Id 1265373',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:44:54','',''),(2131912,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:44:54','',''),(2131944,'1','197','1018',464,'Retail Sale Id 1265391',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:46:17','',''),(2131945,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:46:17','',''),(2132014,'1','197','1018',464,'Retail Sale Id 1265433',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:50:41','',''),(2132015,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:50:41','',''),(2132036,'1','197','1018',464,'Retail Sale Id 1265444',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 16:52:03','',''),(2132037,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:52:03','',''),(2132060,'1','197','1018',464,'Retail Sale Id 1265456',997.92,0.00,0.00,0.00,74.52,'2021-12-02 16:53:25','',''),(2132061,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-02 16:53:25','',''),(2132082,'1','197','1018',464,'Retail Sale Id 1265464',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:54:49','',''),(2132083,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:54:49','',''),(2132103,'1','197','1018',464,'Retail Sale Id 1265476',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 16:56:04','',''),(2132104,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 16:56:04','',''),(2132142,'1','197','1018',464,'Retail Sale Id 1265487',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 16:58:39','',''),(2132143,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:58:39','',''),(2132165,'1','197','1018',464,'Retail Sale Id 1265507',1299.76,0.00,0.00,0.00,97.06,'2021-12-02 17:00:11','',''),(2132166,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-02 17:00:11','',''),(2132199,'1','197','1018',464,'Retail Sale Id 1265521',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 17:01:52','',''),(2132200,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:01:52','',''),(2132483,'1','197','1018',464,'Retail Sale Id 1265648',3098.48,0.00,0.00,0.00,231.38,'2021-12-02 17:19:00','',''),(2132484,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-02 17:19:00','',''),(2132747,'1','197','1018',464,'Retail Sale Id 1265771',7700.00,0.00,0.00,0.00,575.00,'2021-12-02 17:40:23','',''),(2132748,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:40:23','',''),(2132777,'1','197','1018',464,'Retail Sale Id 1265781',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 17:43:09','',''),(2132778,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 17:43:09','',''),(2132785,'1','197','1018',464,'Retail Sale Id 1265791',3098.48,0.00,0.00,0.00,231.38,'2021-12-02 17:45:18','',''),(2132786,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-02 17:45:18','',''),(2132810,'1','197','1018',464,'Retail Sale Id 1265803',3702.16,0.00,0.00,0.00,276.46,'2021-12-02 17:47:02','',''),(2132811,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-02 17:47:02','',''),(2133396,'1','197','1018',464,'Retail Sale Id 1266019',102582.00,0.00,0.00,0.00,5129.10,'2021-12-02 19:15:19','',''),(2133397,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,170.97,0.00,'2021-12-02 19:15:19','',''),(2133408,'1','197','1018',464,'Return of Retail Sale Id 1266019',0.00,102582.00,170.97,0.00,-5129.10,'2021-12-02 19:17:10','',''),(2133416,'1','197','1018',464,'Return of Retail Sale Id 1264344',0.00,40003.04,64.94,0.00,-2987.24,'2021-12-02 19:21:32','',''),(2133421,'1','197','1018',464,'Retail Sale Id 1266035',5642.56,0.00,0.00,0.00,421.36,'2021-12-02 19:23:39','',''),(2133422,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,9.16,0.00,'2021-12-02 19:23:39','',''),(2133427,'1','197','1018',464,'Retail Sale Id 1266038',102582.00,0.00,0.00,0.00,5129.10,'2021-12-02 19:27:43','',''),(2133428,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,170.97,0.00,'2021-12-02 19:27:43','',''),(2134853,'1','197','1018',464,'Retail Sale Id 1266520',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 07:07:51','',''),(2134854,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:07:51','',''),(2135439,'1','197','1018',464,'Retail Sale Id 1266794',997.92,0.00,0.00,0.00,74.52,'2021-12-03 07:40:11','',''),(2135440,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-03 07:40:11','',''),(2135629,'1','197','1018',464,'Retail Sale Id 1266883',2999.92,0.00,0.00,0.00,224.02,'2021-12-03 07:50:21','',''),(2135630,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-03 07:50:21','',''),(2136384,'1','197','1018',464,'Retail Sale Id 1267230',5500.88,0.00,0.00,0.00,410.78,'2021-12-03 08:27:24','',''),(2136385,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.93,0.00,'2021-12-03 08:27:24','',''),(2136396,'1','197','1018',464,'Retail Sale Id 1267237',1897.28,0.00,0.00,0.00,141.68,'2021-12-03 08:28:02','',''),(2136397,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-03 08:28:02','',''),(2136918,'1','197','1018',464,'Retail Sale Id 1267422',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 08:52:57','',''),(2136919,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:52:57','',''),(2137052,'1','197','1018',464,'Retail Sale Id 1267487',78000.00,0.00,0.00,0.00,3900.00,'2021-12-03 09:00:02','',''),(2137053,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-03 09:00:02','',''),(2137998,'1','197','1018',464,'Retail Sale Id 1268011',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 09:53:30','',''),(2137999,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 09:53:30','',''),(2138843,'1','197','1018',464,'Retail Sale Id 1268436',2002.00,0.00,0.00,0.00,149.50,'2021-12-03 10:43:53','',''),(2138844,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-03 10:43:53','',''),(2138903,'1','197','1018',464,'Retail Sale Id 1268464',100800.00,0.00,0.00,0.00,5040.00,'2021-12-03 10:48:59','',''),(2138904,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,168.00,0.00,'2021-12-03 10:48:59','',''),(2139036,'1','197','1018',464,'Retail Sale Id 1268532',2999.92,0.00,0.00,0.00,224.02,'2021-12-03 10:59:32','',''),(2139037,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-03 10:59:32','',''),(2139316,'1','197','1018',464,'Retail Sale Id 1268674',2002.00,0.00,0.00,0.00,149.50,'2021-12-03 11:18:40','',''),(2139317,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-03 11:18:40','',''),(2139366,'1','197','1018',464,'Retail Sale Id 1268697',3098.48,0.00,0.00,0.00,231.38,'2021-12-03 11:24:04','',''),(2139367,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-03 11:24:04','',''),(2139382,'1','197','1018',464,'Retail Sale Id 1268710',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 11:25:31','',''),(2139383,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:25:31','',''),(2140190,'1','197','1018',464,'Retail Sale Id 1269172',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 12:29:41','',''),(2140191,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:29:41','',''),(2140202,'1','197','1018',464,'Retail Sale Id 1269177',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 12:30:19','',''),(2140203,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:30:19','',''),(2140236,'1','197','1018',464,'Retail Sale Id 1269198',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 12:32:52','',''),(2140237,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 12:32:52','',''),(2140675,'1','197','1018',464,'Retail Sale Id 1269411',30000.00,0.00,0.00,0.00,1500.00,'2021-12-03 13:05:35','',''),(2140676,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:05:35','',''),(2140763,'1','197','1018',464,'Retail Sale Id 1269453',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 13:14:25','',''),(2140764,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:14:25','',''),(2142050,'1','197','1018',464,'Retail Sale Id 1269987',6997.76,0.00,0.00,0.00,522.56,'2021-12-03 14:29:12','',''),(2142051,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-03 14:29:12','',''),(2142168,'1','197','1018',464,'Retail Sale Id 1270028',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 14:35:31','',''),(2142169,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 14:35:31','',''),(2142403,'1','197','1018',464,'Retail Sale Id 1270117',42000.00,0.00,0.00,0.00,2100.00,'2021-12-03 14:45:58','',''),(2142404,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-03 14:45:58','',''),(2142779,'1','197','1018',464,'Retail Sale Id 1270294',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 15:05:26','',''),(2142780,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:05:26','',''),(2142854,'1','197','1018',464,'Retail Sale Id 1270339',1897.28,0.00,0.00,0.00,141.68,'2021-12-03 15:10:03','',''),(2142855,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-03 15:10:03','',''),(2142906,'1','197','1018',464,'Retail Sale Id 1270363',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 15:11:54','',''),(2142907,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:11:54','',''),(2142960,'1','197','1018',464,'Retail Sale Id 1270388',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 15:14:29','',''),(2142961,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:14:29','',''),(2143067,'1','197','1018',464,'Retail Sale Id 1270461',15000.00,0.00,0.00,0.00,750.00,'2021-12-03 15:19:42','',''),(2143068,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 15:19:42','',''),(2143103,'1','197','1018',464,'Retail Sale Id 1270478',3997.84,0.00,0.00,0.00,298.54,'2021-12-03 15:21:15','',''),(2143104,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-03 15:21:15','',''),(2143181,'1','197','1018',464,'Retail Sale Id 1270518',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 15:26:08','',''),(2143182,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 15:26:08','',''),(2143293,'1','197','1018',464,'Retail Sale Id 1270571',2999.92,0.00,0.00,0.00,224.02,'2021-12-03 15:31:15','',''),(2143294,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-03 15:31:15','',''),(2143301,'1','197','1018',464,'Retail Sale Id 1270578',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 15:31:56','',''),(2143302,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:31:56','',''),(2143456,'1','197','1018',464,'Retail Sale Id 1270651',1897.28,0.00,0.00,0.00,141.68,'2021-12-03 15:37:59','',''),(2143457,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-03 15:37:59','',''),(2143610,'1','197','1018',464,'Retail Sale Id 1270728',3098.48,0.00,0.00,0.00,231.38,'2021-12-03 15:44:26','',''),(2143611,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-03 15:44:26','',''),(2143656,'1','197','1018',464,'Retail Sale Id 1270748',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 15:46:02','',''),(2143657,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:46:02','',''),(2143703,'1','197','1018',464,'Retail Sale Id 1270766',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 15:47:36','',''),(2143704,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:47:36','',''),(2144037,'1','197','1018',464,'Retail Sale Id 1270935',3498.88,0.00,0.00,0.00,261.28,'2021-12-03 16:03:06','',''),(2144038,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.68,0.00,'2021-12-03 16:03:06','',''),(2144097,'1','197','1018',464,'Retail Sale Id 1270969',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:05:56','',''),(2144098,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:05:56','',''),(2144099,'1','197','1018',464,'Retail Sale Id 1270969',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:05:56','',''),(2144100,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:05:56','',''),(2144165,'1','197','1018',464,'Retail Sale Id 1270997',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:08:13','',''),(2144166,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:08:13','',''),(2144208,'1','197','1018',464,'Retail Sale Id 1271022',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:10:18','',''),(2144209,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:10:18','',''),(2144210,'1','197','1018',464,'Retail Sale Id 1271022',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:10:18','',''),(2144211,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:10:18','',''),(2144246,'1','197','1018',464,'Retail Sale Id 1271042',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 16:12:16','',''),(2144247,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 16:12:16','',''),(2144362,'1','197','1018',464,'Retail Sale Id 1271101',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:19:08','',''),(2144363,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:19:08','',''),(2144404,'1','197','1018',464,'Retail Sale Id 1271127',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:21:09','',''),(2144405,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:21:09','',''),(2144631,'1','197','1018',464,'Retail Sale Id 1271235',3098.48,0.00,0.00,0.00,231.38,'2021-12-03 16:32:54','',''),(2144632,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-03 16:32:54','',''),(2144931,'1','197','1018',464,'Retail Sale Id 1271384',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:47:38','',''),(2144932,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:47:38','',''),(2144947,'1','197','1018',464,'Retail Sale Id 1271395',1299.76,0.00,0.00,0.00,97.06,'2021-12-03 16:49:09','',''),(2144948,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-03 16:49:09','',''),(2144961,'1','197','1018',464,'Retail Sale Id 1271405',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 16:50:06','',''),(2144962,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 16:50:06','',''),(2145155,'1','197','1018',464,'Retail Sale Id 1271431',168000.00,0.00,0.00,0.00,8400.00,'2021-12-03 16:56:43','',''),(2145156,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,280.00,0.00,'2021-12-03 16:56:43','',''),(2145176,'1','197','1018',464,'Retail Sale Id 1271478',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 16:58:13','',''),(2145177,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:58:13','',''),(2145200,'1','197','1018',464,'Retail Sale Id 1271490',3098.48,0.00,0.00,0.00,231.38,'2021-12-03 16:59:47','',''),(2145201,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-03 16:59:47','',''),(2145214,'1','197','1018',464,'Retail Sale Id 1271498',3702.16,0.00,0.00,0.00,276.46,'2021-12-03 17:00:46','',''),(2145215,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-03 17:00:46','',''),(2145533,'1','197','1018',464,'Retail Sale Id 1271664',15400.00,0.00,0.00,0.00,1150.00,'2021-12-03 17:32:09','',''),(2145534,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 17:32:09','',''),(2145583,'1','197','1018',464,'Retail Sale Id 1271700',190.96,0.00,0.00,0.00,14.26,'2021-12-03 17:40:29','',''),(2145584,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,0.31,0.00,'2021-12-03 17:40:29','',''),(2145597,'1','197','1018',464,'Retail Sale Id 1271707',1712.48,0.00,0.00,0.00,127.88,'2021-12-03 17:42:03','',''),(2145598,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.78,0.00,'2021-12-03 17:42:03','',''),(2145613,'1','197','1018',464,'Retail Sale Id 1271715',1897.28,0.00,0.00,0.00,141.68,'2021-12-03 17:45:31','',''),(2145614,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-03 17:45:31','',''),(2145615,'1','197','1018',464,'Retail Sale Id 1271715',3098.48,0.00,0.00,0.00,231.38,'2021-12-03 17:45:31','',''),(2145616,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-03 17:45:31','',''),(2145617,'1','197','1018',464,'Retail Sale Id 1271715',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 17:45:31','',''),(2145618,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:45:31','',''),(2145627,'1','197','1018',464,'Retail Sale Id 1271720',7700.00,0.00,0.00,0.00,575.00,'2021-12-03 17:47:37','',''),(2145628,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:47:37','',''),(2145742,'1','197','1018',464,'Retail Sale Id 1271762',12320.00,0.00,0.00,0.00,920.00,'2021-12-03 18:02:17','',''),(2145743,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-03 18:02:17','',''),(2146027,'1','197','1018',464,'Return of Retail Sale Id 1271127',0.00,7700.00,12.50,0.00,-575.00,'2021-12-03 18:43:04','',''),(2146028,'1','197','1018',464,'Retail Sale Id 1271874',1583.12,0.00,0.00,0.00,118.22,'2021-12-03 18:43:48','',''),(2146029,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.57,0.00,'2021-12-03 18:43:48','',''),(2146064,'1','197','1018',464,'Retail Sale Id 1271878',96990.00,0.00,0.00,0.00,4849.50,'2021-12-03 18:58:48','',''),(2146065,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,161.65,0.00,'2021-12-03 18:58:48','',''),(2147659,'1','197','1018',464,'Retail Sale Id 1272410',6997.76,0.00,0.00,0.00,522.56,'2021-12-04 07:05:17','',''),(2147660,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-04 07:05:17','',''),(2147950,'1','197','1018',464,'Retail Sale Id 1272575',36000.00,0.00,0.00,0.00,1800.00,'2021-12-04 07:21:08','',''),(2147951,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-04 07:21:08','',''),(2149056,'1','197','1018',464,'Retail Sale Id 1273233',16151.52,0.00,0.00,0.00,1206.12,'2021-12-04 08:15:17','',''),(2149057,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,26.22,0.00,'2021-12-04 08:15:17','',''),(2149186,'1','197','1018',464,'Retail Sale Id 1273296',349500.00,0.00,0.00,0.00,17475.00,'2021-12-04 08:20:39','',''),(2149187,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,582.50,0.00,'2021-12-04 08:20:39','',''),(2149394,'1','197','1018',464,'Retail Sale Id 1273460',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 08:29:51','',''),(2149395,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:29:51','',''),(2149426,'1','197','1018',464,'Retail Sale Id 1273488',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 08:30:47','',''),(2149427,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:30:47','',''),(2149509,'1','197','1018',464,'Retail Sale Id 1273537',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 08:33:13','',''),(2149510,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:33:13','',''),(2149525,'1','197','1018',464,'Retail Sale Id 1273544',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 08:33:48','',''),(2149526,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:33:48','',''),(2149834,'1','197','1018',464,'Retail Sale Id 1273682',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 08:46:07','',''),(2149835,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:46:07','',''),(2150136,'1','197','1018',464,'Retail Sale Id 1273854',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 09:00:02','',''),(2150137,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:00:02','',''),(2150173,'1','197','1018',464,'Retail Sale Id 1273873',69000.00,0.00,0.00,0.00,3450.00,'2021-12-04 09:02:17','',''),(2150174,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,115.00,0.00,'2021-12-04 09:02:17','',''),(2150201,'1','197','1018',464,'Retail Sale Id 1273891',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 09:03:24','',''),(2150202,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:03:24','',''),(2150227,'1','197','1018',464,'Retail Sale Id 1273912',3702.16,0.00,0.00,0.00,276.46,'2021-12-04 09:04:30','',''),(2150228,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 09:04:30','',''),(2150245,'1','197','1018',464,'Retail Sale Id 1273919',3702.16,0.00,0.00,0.00,276.46,'2021-12-04 09:05:19','',''),(2150246,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 09:05:19','',''),(2150292,'1','197','1018',464,'Retail Sale Id 1273945',3702.16,0.00,0.00,0.00,276.46,'2021-12-04 09:07:56','',''),(2150293,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 09:07:56','',''),(2150752,'1','197','1018',464,'Retail Sale Id 1274175',997.92,0.00,0.00,0.00,74.52,'2021-12-04 09:30:29','',''),(2150753,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-04 09:30:29','',''),(2154980,'1','197','1018',464,'Retail Sale Id 1275513',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 12:55:47','',''),(2154981,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:55:47','',''),(2154993,'1','197','1018',464,'Retail Sale Id 1275721',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 13:04:13','',''),(2154994,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:04:13','',''),(2155047,'1','197','1018',464,'Retail Sale Id 1275753',3702.16,0.00,0.00,0.00,276.46,'2021-12-04 13:06:39','',''),(2155048,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 13:06:39','',''),(2155117,'1','197','1018',464,'Retail Sale Id 1275789',25200.00,0.00,0.00,0.00,1260.00,'2021-12-04 13:11:22','',''),(2155118,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-04 13:11:22','',''),(2155129,'1','197','1018',464,'Retail Sale Id 1275798',2999.92,0.00,0.00,0.00,224.02,'2021-12-04 13:12:01','',''),(2155130,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-04 13:12:01','',''),(2155174,'1','197','1018',464,'Retail Sale Id 1275807',45000.00,0.00,0.00,0.00,2250.00,'2021-12-04 13:14:38','',''),(2155175,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-04 13:14:38','',''),(2155212,'1','197','1018',464,'Retail Sale Id 1275831',81000.00,0.00,0.00,0.00,4050.00,'2021-12-04 13:17:17','',''),(2155213,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,135.00,0.00,'2021-12-04 13:17:17','',''),(2155490,'1','197','1018',464,'Retail Sale Id 1275932',15400.00,0.00,0.00,0.00,1150.00,'2021-12-04 13:30:18','',''),(2155491,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 13:30:18','',''),(2156007,'1','197','1018',464,'Retail Sale Id 1276169',6498.80,0.00,0.00,0.00,485.30,'2021-12-04 13:57:19','',''),(2156008,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.55,0.00,'2021-12-04 13:57:19','',''),(2156715,'1','197','1018',464,'Retail Sale Id 1276500',3702.16,0.00,0.00,0.00,276.46,'2021-12-04 14:30:52','',''),(2156716,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 14:30:52','',''),(2157028,'1','197','1018',464,'Retail Sale Id 1276624',15400.00,0.00,0.00,0.00,1150.00,'2021-12-04 14:46:10','',''),(2157029,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 14:46:10','',''),(2157118,'1','197','1018',464,'Retail Sale Id 1276656',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 14:50:13','',''),(2157119,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:50:13','',''),(2157494,'1','197','1018',464,'Retail Sale Id 1276822',997.92,0.00,0.00,0.00,74.52,'2021-12-04 15:11:31','',''),(2157495,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-04 15:11:31','',''),(2157520,'1','197','1018',464,'Retail Sale Id 1276835',3850.00,0.00,0.00,0.00,287.50,'2021-12-04 15:12:50','',''),(2157521,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 15:12:50','',''),(2157562,'1','197','1018',464,'Retail Sale Id 1276847',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 15:14:14','',''),(2157563,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:14:14','',''),(2157580,'1','197','1018',464,'Retail Sale Id 1276859',15400.00,0.00,0.00,0.00,1150.00,'2021-12-04 15:15:17','',''),(2157581,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 15:15:17','',''),(2158581,'1','197','1018',464,'Retail Sale Id 1277339',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 16:01:46','',''),(2158582,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:01:46','',''),(2158640,'1','197','1018',464,'Retail Sale Id 1277366',105000.00,0.00,0.00,0.00,5250.00,'2021-12-04 16:05:18','',''),(2158641,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,175.00,0.00,'2021-12-04 16:05:18','',''),(2158787,'1','197','1018',464,'Retail Sale Id 1277445',18600.00,0.00,0.00,0.00,930.00,'2021-12-04 16:12:14','',''),(2158788,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-04 16:12:14','',''),(2158995,'1','197','1018',464,'Retail Sale Id 1277551',1897.28,0.00,0.00,0.00,141.68,'2021-12-04 16:21:42','',''),(2158996,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-04 16:21:42','',''),(2159360,'1','197','1018',464,'Retail Sale Id 1277739',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 16:38:46','',''),(2159361,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:38:46','',''),(2159453,'1','197','1018',464,'Retail Sale Id 1277762',3098.48,0.00,0.00,0.00,231.38,'2021-12-04 16:41:09','',''),(2159454,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-04 16:41:09','',''),(2159455,'1','197','1018',464,'Retail Sale Id 1277762',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 16:41:09','',''),(2159456,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:41:09','',''),(2159509,'1','197','1018',464,'Retail Sale Id 1277833',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 16:44:38','',''),(2159510,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:44:38','',''),(2159562,'1','197','1018',464,'Retail Sale Id 1277860',3702.16,0.00,0.00,0.00,276.46,'2021-12-04 16:47:17','',''),(2159563,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-04 16:47:17','',''),(2159654,'1','197','1018',464,'Retail Sale Id 1277903',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 16:51:22','',''),(2159655,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:51:22','',''),(2159726,'1','197','1018',464,'Retail Sale Id 1277937',3098.48,0.00,0.00,0.00,231.38,'2021-12-04 16:55:23','',''),(2159727,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-04 16:55:23','',''),(2159769,'1','197','1018',464,'Retail Sale Id 1277961',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 16:58:23','',''),(2159770,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:58:23','',''),(2159855,'1','197','1018',464,'Retail Sale Id 1277994',2464.00,0.00,0.00,0.00,184.00,'2021-12-04 17:02:33','',''),(2159856,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 17:02:33','',''),(2160015,'1','197','1018',464,'Retail Sale Id 1278076',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 17:12:55','',''),(2160016,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:12:55','',''),(2160352,'1','197','1018',464,'Retail Sale Id 1278223',30000.00,0.00,0.00,0.00,1500.00,'2021-12-04 17:33:28','',''),(2160353,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 17:33:28','',''),(2160428,'1','197','1018',464,'Retail Sale Id 1278254',7700.00,0.00,0.00,0.00,575.00,'2021-12-04 17:39:02','',''),(2160429,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:39:02','',''),(2160678,'1','197','1018',464,'Retail Sale Id 1278326',6997.76,0.00,0.00,0.00,522.56,'2021-12-04 17:50:38','',''),(2160679,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-04 17:50:38','',''),(2160680,'1','197','1018',464,'Retail Sale Id 1278326',6997.76,0.00,0.00,0.00,522.56,'2021-12-04 17:50:38','',''),(2160681,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-04 17:50:38','',''),(2160835,'1','197','1018',464,'Retail Sale Id 1278405',3098.48,0.00,0.00,0.00,231.38,'2021-12-04 18:06:25','',''),(2160836,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-04 18:06:25','',''),(2160992,'1','197','1018',464,'Retail Sale Id 1278483',1897.28,0.00,0.00,0.00,141.68,'2021-12-04 18:31:28','',''),(2160993,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-04 18:31:28','',''),(2161170,'1','197','1018',464,'Retail Sale Id 1278548',36906.00,0.00,0.00,0.00,1845.30,'2021-12-04 19:09:00','',''),(2161171,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,61.51,0.00,'2021-12-04 19:09:00','',''),(2161190,'1','197','1018',464,'Retail Sale Id 1278552',96379.36,0.00,0.00,0.00,7197.16,'2021-12-04 19:14:35','',''),(2161191,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,156.46,0.00,'2021-12-04 19:14:35','',''),(2162823,'1','197','1018',464,'Retail Sale Id 1279030',0.00,0.00,0.00,0.00,0.00,'2021-12-05 07:06:11','',''),(2162824,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,0.00,0.00,'2021-12-05 07:06:11','',''),(2163542,'1','197','1018',464,'Retail Sale Id 1279461',997.92,0.00,0.00,0.00,74.52,'2021-12-05 07:48:11','',''),(2163543,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-05 07:48:11','',''),(2163722,'1','197','1018',464,'Retail Sale Id 1279536',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 07:57:54','',''),(2163723,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:57:54','',''),(2163746,'1','197','1018',464,'Retail Sale Id 1279558',3702.16,0.00,0.00,0.00,276.46,'2021-12-05 07:59:37','',''),(2163747,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 07:59:37','',''),(2163774,'1','197','1018',464,'Retail Sale Id 1279572',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 08:00:50','',''),(2163775,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:00:50','',''),(2164202,'1','197','1018',464,'Retail Sale Id 1279820',28998.00,0.00,0.00,0.00,1449.90,'2021-12-05 08:22:39','',''),(2164203,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,48.33,0.00,'2021-12-05 08:22:39','',''),(2165382,'1','197','1018',464,'Retail Sale Id 1280460',2002.00,0.00,0.00,0.00,149.50,'2021-12-05 09:25:14','',''),(2165383,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-05 09:25:14','',''),(2166335,'1','197','1018',464,'Retail Sale Id 1280930',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 10:15:07','',''),(2166336,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:15:07','',''),(2166810,'1','197','1018',464,'Return of Retail Sale Id 1280460',0.00,2002.00,3.25,0.00,-149.50,'2021-12-05 10:44:35','',''),(2166831,'1','197','1018',464,'Retail Sale Id 1281186',948.64,0.00,0.00,0.00,70.84,'2021-12-05 10:45:42','',''),(2166832,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.54,0.00,'2021-12-05 10:45:42','',''),(2166905,'1','197','1018',464,'Retail Sale Id 1281226',9456.00,0.00,0.00,0.00,472.80,'2021-12-05 10:49:02','',''),(2166906,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.76,0.00,'2021-12-05 10:49:02','',''),(2167081,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,15840.30,27.79,0.00,0.00,'2021-12-05 10:58:37','',''),(2167106,'1','197',NULL,464,'Reception corrector for bridging 126299',0.00,0.00,0.00,27.78,0.00,'2021-12-05 11:00:23','',''),(2167107,'1','197','1018',464,'Received from bridging 126299',0.00,0.00,27.78,0.00,0.00,'2021-12-05 11:00:23','',''),(2167140,'1','197','1018',464,'Retail Sale Id 1281343',16668.00,0.00,0.00,0.00,833.40,'2021-12-05 11:02:43','',''),(2167141,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,27.78,0.00,'2021-12-05 11:02:43','',''),(2168916,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1140000.00,2000.00,0.00,0.00,'2021-12-05 12:37:01','',''),(2168959,'1','197',NULL,464,'Reception corrector for bridging 126308',0.00,0.00,0.00,2000.00,0.00,'2021-12-05 12:39:03','',''),(2168960,'1','197','1018',464,'Received from bridging 126308',0.00,0.00,2000.00,0.00,0.00,'2021-12-05 12:39:03','',''),(2169135,'1','197','1018',464,'Retail Sale Id 1282427',71400.00,0.00,0.00,0.00,3570.00,'2021-12-05 12:49:20','',''),(2169136,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,119.00,0.00,'2021-12-05 12:49:20','',''),(2169185,'1','197','1018',464,'Retail Sale Id 1282444',3702.16,0.00,0.00,0.00,276.46,'2021-12-05 12:52:45','',''),(2169186,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 12:52:45','',''),(2169205,'1','197','1018',464,'Retail Sale Id 1282468',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 12:54:08','',''),(2169206,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:54:08','',''),(2169229,'1','197','1018',464,'Retail Sale Id 1282481',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 12:55:07','',''),(2169230,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:55:07','',''),(2169255,'1','197','1018',464,'Retail Sale Id 1282496',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 12:56:31','',''),(2169256,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:56:31','',''),(2169441,'1','197','1018',464,'Retail Sale Id 1282580',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 13:05:25','',''),(2169442,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:05:25','',''),(2169510,'1','197','1018',464,'Retail Sale Id 1282632',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 13:09:19','',''),(2169511,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:09:19','',''),(2169536,'1','197','1018',464,'Retail Sale Id 1282652',3702.16,0.00,0.00,0.00,276.46,'2021-12-05 13:10:48','',''),(2169537,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 13:10:48','',''),(2170263,'1','197','1018',464,'Retail Sale Id 1282973',997.92,0.00,0.00,0.00,74.52,'2021-12-05 13:50:24','',''),(2170264,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-05 13:50:24','',''),(2170330,'1','197','1018',464,'Retail Sale Id 1282994',3702.16,0.00,0.00,0.00,276.46,'2021-12-05 13:53:21','',''),(2170331,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 13:53:21','',''),(2170487,'1','197','1018',464,'Retail Sale Id 1283064',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 14:01:13','',''),(2170488,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:01:13','',''),(2170533,'1','197','1018',464,'Retail Sale Id 1283091',997.92,0.00,0.00,0.00,74.52,'2021-12-05 14:04:46','',''),(2170534,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-05 14:04:46','',''),(2170891,'1','197','1018',464,'Retail Sale Id 1283236',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 14:22:16','',''),(2170892,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:22:16','',''),(2171054,'1','197','1018',464,'Retail Sale Id 1283305',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 14:31:24','',''),(2171055,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:31:24','',''),(2171253,'1','197','1018',464,'Retail Sale Id 1283368',347400.00,0.00,0.00,0.00,17370.00,'2021-12-05 14:41:38','',''),(2171254,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,579.00,0.00,'2021-12-05 14:41:38','',''),(2171449,'1','197','1018',464,'Retail Sale Id 1283450',5001.92,0.00,0.00,0.00,373.52,'2021-12-05 14:52:25','',''),(2171450,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-05 14:52:25','',''),(2171521,'1','197','1018',464,'Retail Sale Id 1283488',5698.00,0.00,0.00,0.00,425.50,'2021-12-05 14:58:13','',''),(2171522,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,9.25,0.00,'2021-12-05 14:58:13','',''),(2171601,'1','197','1018',464,'Retail Sale Id 1283527',997.92,0.00,0.00,0.00,74.52,'2021-12-05 15:05:13','',''),(2171602,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-05 15:05:13','',''),(2172076,'1','197','1018',464,'Retail Sale Id 1283754',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 15:36:07','',''),(2172077,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:36:07','',''),(2172112,'1','197','1018',464,'Retail Sale Id 1283767',3702.16,0.00,0.00,0.00,276.46,'2021-12-05 15:38:00','',''),(2172113,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 15:38:00','',''),(2172401,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1920900.00,3370.00,0.00,0.00,'2021-12-05 15:52:13','',''),(2172428,'1','197',NULL,464,'Reception corrector for bridging 126331',0.00,0.00,0.00,3370.00,0.00,'2021-12-05 15:54:03','',''),(2172429,'1','197','1018',464,'Received from bridging 126331',0.00,0.00,3370.00,0.00,0.00,'2021-12-05 15:54:03','',''),(2172524,'1','197','1018',464,'Retail Sale Id 1283993',3702.16,0.00,0.00,0.00,276.46,'2021-12-05 15:59:30','',''),(2172525,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-05 15:59:30','',''),(2172556,'1','197','1018',464,'Retail Sale Id 1284012',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 16:01:25','',''),(2172557,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:01:25','',''),(2172712,'1','197','1018',464,'Retail Sale Id 1284093',19800.00,0.00,0.00,0.00,990.00,'2021-12-05 16:11:20','',''),(2172713,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-05 16:11:20','',''),(2172762,'1','197','1018',464,'Retail Sale Id 1284117',1897.28,0.00,0.00,0.00,141.68,'2021-12-05 16:14:24','',''),(2172763,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-05 16:14:24','',''),(2172836,'1','197','1018',464,'Retail Sale Id 1284156',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 16:19:46','',''),(2172837,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:19:46','',''),(2172940,'1','197','1018',464,'Retail Sale Id 1284216',187500.00,0.00,0.00,0.00,9375.00,'2021-12-05 16:25:39','',''),(2172941,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,312.50,0.00,'2021-12-05 16:25:39','',''),(2172951,'1','197','1018',464,'Retail Sale Id 1284223',1897.28,0.00,0.00,0.00,141.68,'2021-12-05 16:26:35','',''),(2172952,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-05 16:26:35','',''),(2173027,'1','197','1018',464,'Retail Sale Id 1284267',997.92,0.00,0.00,0.00,74.52,'2021-12-05 16:32:13','',''),(2173028,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-05 16:32:13','',''),(2173225,'1','197','1018',464,'Retail Sale Id 1284366',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 16:42:47','',''),(2173226,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:42:47','',''),(2173301,'1','197','1018',464,'Retail Sale Id 1284405',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 16:47:48','',''),(2173302,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:47:48','',''),(2173558,'1','197','1018',464,'Retail Sale Id 1284485',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 17:04:47','',''),(2173559,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:04:47','',''),(2173610,'1','197','1018',464,'Retail Sale Id 1284555',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 17:07:18','',''),(2173611,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:07:18','',''),(2173916,'1','197','1018',464,'Retail Sale Id 1284696',7700.00,0.00,0.00,0.00,575.00,'2021-12-05 17:32:29','',''),(2173917,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:32:29','',''),(2173998,'1','197','1018',464,'Retail Sale Id 1284741',60000.00,0.00,0.00,0.00,3000.00,'2021-12-05 17:41:02','',''),(2173999,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 17:41:02','',''),(2174272,'1','197','1018',464,'Return of Retail Sale Id 1284012',0.00,7700.00,12.50,0.00,-575.00,'2021-12-05 19:04:47','',''),(2174279,'1','197','1018',464,'Return of Retail Sale Id 1284405',0.00,7700.00,12.50,0.00,-575.00,'2021-12-05 19:06:08','',''),(2174310,'1','197','1018',464,'Return of Retail Sale Id 1283450',0.00,5001.92,8.12,0.00,-373.52,'2021-12-05 19:07:39','',''),(2174326,'1','197','1018',464,'Retail Sale Id 1284854',1299.76,0.00,0.00,0.00,97.06,'2021-12-05 19:09:35','',''),(2174327,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-05 19:09:35','',''),(2174335,'1','197','1018',464,'Retail Sale Id 1284856',69606.00,0.00,0.00,0.00,3480.30,'2021-12-05 19:11:51','',''),(2174336,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,116.01,0.00,'2021-12-05 19:11:51','',''),(2174794,'1','197','1018',464,'Retail Sale Id 1284904',2500.96,0.00,0.00,0.00,186.76,'2021-12-06 06:01:43','',''),(2174795,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 06:01:43','',''),(2174808,'1','197','1018',464,'Retail Sale Id 1284911',997.92,0.00,0.00,0.00,74.52,'2021-12-06 06:06:21','',''),(2174809,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-06 06:06:21','',''),(2174829,'1','197','1018',464,'Return of Retail Sale Id 1284904',0.00,2500.96,4.06,0.00,-186.76,'2021-12-06 06:11:01','',''),(2174832,'1','197','1018',464,'Return of Retail Sale Id 1284911',0.00,997.92,1.62,0.00,-74.52,'2021-12-06 06:11:19','',''),(2175125,'1','197','1018',464,'Retail Sale Id 1285039',5001.92,0.00,0.00,0.00,373.52,'2021-12-06 06:44:50','',''),(2175126,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-06 06:44:50','',''),(2175199,'1','197','1018',464,'Retail Sale Id 1285077',36000.00,0.00,0.00,0.00,1800.00,'2021-12-06 06:49:55','',''),(2175200,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 06:49:55','',''),(2175276,'1','197','1018',464,'Retail Sale Id 1285117',2002.00,0.00,0.00,0.00,149.50,'2021-12-06 06:56:25','',''),(2175277,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-06 06:56:25','',''),(2175322,'1','197','1018',464,'Retail Sale Id 1285132',3997.84,0.00,0.00,0.00,298.54,'2021-12-06 06:57:54','',''),(2175323,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-06 06:57:54','',''),(2175636,'1','197','1018',464,'Retail Sale Id 1285274',2500.96,0.00,0.00,0.00,186.76,'2021-12-06 07:17:51','',''),(2175637,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 07:17:51','',''),(2175854,'1','197','1018',464,'Retail Sale Id 1285385',1503.04,0.00,0.00,0.00,112.24,'2021-12-06 07:31:10','',''),(2175855,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-06 07:31:10','',''),(2176088,'1','197','1018',464,'Retail Sale Id 1285497',11402.16,0.00,0.00,0.00,851.46,'2021-12-06 07:43:07','',''),(2176089,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-06 07:43:07','',''),(2176280,'1','197','1018',464,'Retail Sale Id 1285592',3098.48,0.00,0.00,0.00,231.38,'2021-12-06 07:51:46','',''),(2176281,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-06 07:51:46','',''),(2176604,'1','197','1018',464,'Retail Sale Id 1285748',2500.96,0.00,0.00,0.00,186.76,'2021-12-06 08:07:09','',''),(2176605,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 08:07:09','',''),(2177899,'1','197','1018',464,'Retail Sale Id 1286359',1151.92,0.00,0.00,0.00,86.02,'2021-12-06 09:37:42','',''),(2177900,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.87,0.00,'2021-12-06 09:37:42','',''),(2177982,'1','197','1018',464,'Retail Sale Id 1286386',51000.00,0.00,0.00,0.00,2550.00,'2021-12-06 09:41:33','',''),(2177983,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,85.00,0.00,'2021-12-06 09:41:33','',''),(2178023,'1','197','1018',464,'Retail Sale Id 1286401',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 09:43:48','',''),(2178025,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:43:48','',''),(2178040,'1','197','1018',464,'Retail Sale Id 1286411',2999.92,0.00,0.00,0.00,224.02,'2021-12-06 09:45:05','',''),(2178041,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-06 09:45:05','',''),(2178226,'1','197','1018',464,'Retail Sale Id 1286513',6997.76,0.00,0.00,0.00,522.56,'2021-12-06 09:58:32','',''),(2178227,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-06 09:58:32','',''),(2178244,'1','197','1018',464,'Retail Sale Id 1286521',1897.28,0.00,0.00,0.00,141.68,'2021-12-06 10:00:16','',''),(2178245,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-06 10:00:16','',''),(2178425,'1','197','1018',464,'Retail Sale Id 1286594',3098.48,0.00,0.00,0.00,231.38,'2021-12-06 10:09:02','',''),(2178426,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-06 10:09:02','',''),(2178715,'1','197','1018',464,'Retail Sale Id 1286747',2002.00,0.00,0.00,0.00,149.50,'2021-12-06 10:28:57','',''),(2178716,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-06 10:28:57','',''),(2178778,'1','197','1018',464,'Retail Sale Id 1286778',2002.00,0.00,0.00,0.00,149.50,'2021-12-06 10:33:03','',''),(2178779,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-06 10:33:03','',''),(2179833,'1','197','1018',464,'Retail Sale Id 1287372',3702.16,0.00,0.00,0.00,276.46,'2021-12-06 11:43:02','',''),(2179834,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 11:43:02','',''),(2179902,'1','197','1018',464,'Retail Sale Id 1287466',3702.16,0.00,0.00,0.00,276.46,'2021-12-06 11:48:04','',''),(2179903,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-06 11:48:04','',''),(2180914,'1','197','1018',464,'Retail Sale Id 1288005',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 12:51:00','',''),(2180915,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:51:00','',''),(2181600,'1','197','1018',464,'Retail Sale Id 1288335',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 13:31:02','',''),(2181601,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:31:02','',''),(2181732,'1','197','1018',464,'Retail Sale Id 1288378',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 13:37:15','',''),(2181733,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:37:15','',''),(2181784,'1','197','1018',464,'Retail Sale Id 1288409',15400.00,0.00,0.00,0.00,1150.00,'2021-12-06 13:39:56','',''),(2181785,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 13:39:56','',''),(2181822,'1','197','1018',464,'Retail Sale Id 1288425',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 13:41:14','',''),(2181823,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:41:14','',''),(2182121,'1','197','1018',464,'Retail Sale Id 1288561',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 13:56:31','',''),(2182122,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:56:31','',''),(2182163,'1','197','1018',464,'Retail Sale Id 1288582',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 13:58:33','',''),(2182164,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:58:33','',''),(2183194,'1','197','1018',464,'Retail Sale Id 1289041',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 14:48:19','',''),(2183195,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:48:19','',''),(2183355,'1','197','1018',464,'Retail Sale Id 1289117',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 14:56:09','',''),(2183356,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:56:09','',''),(2183485,'1','197','1018',464,'Retail Sale Id 1289188',60000.00,0.00,0.00,0.00,3000.00,'2021-12-06 15:03:34','',''),(2183486,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 15:03:34','',''),(2183996,'1','197','1018',464,'Retail Sale Id 1289411',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 15:28:57','',''),(2183997,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:28:57','',''),(2184043,'1','197','1018',464,'Retail Sale Id 1289437',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 15:31:41','',''),(2184044,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:31:41','',''),(2184536,'1','197','1018',464,'Retail Sale Id 1289628',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 15:51:42','',''),(2184537,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:51:42','',''),(2184554,'1','197','1018',464,'Retail Sale Id 1289638',2999.92,0.00,0.00,0.00,224.02,'2021-12-06 15:52:48','',''),(2184555,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-06 15:52:48','',''),(2184584,'1','197','1018',464,'Retail Sale Id 1289654',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 15:54:20','',''),(2184585,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:54:20','',''),(2184666,'1','197','1018',464,'Retail Sale Id 1289694',2002.00,0.00,0.00,0.00,149.50,'2021-12-06 15:58:30','',''),(2184667,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-06 15:58:30','',''),(2184851,'1','197','1018',464,'Retail Sale Id 1289777',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:10:07','',''),(2184852,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:10:07','',''),(2184867,'1','197','1018',464,'Retail Sale Id 1289784',6196.96,0.00,0.00,0.00,462.76,'2021-12-06 16:11:18','',''),(2184868,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-06 16:11:18','',''),(2185085,'1','197','1018',464,'Retail Sale Id 1289888',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:23:14','',''),(2185086,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:23:14','',''),(2185281,'1','197','1018',464,'Retail Sale Id 1289988',6196.96,0.00,0.00,0.00,462.76,'2021-12-06 16:33:28','',''),(2185282,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-06 16:33:28','',''),(2185283,'1','197','1018',464,'Retail Sale Id 1289988',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:33:28','',''),(2185284,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:33:28','',''),(2185285,'1','197','1018',464,'Retail Sale Id 1289988',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:33:28','',''),(2185286,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:33:28','',''),(2185322,'1','197','1018',464,'Retail Sale Id 1290006',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:34:59','',''),(2185323,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:34:59','',''),(2185362,'1','197','1018',464,'Retail Sale Id 1290025',1897.28,0.00,0.00,0.00,141.68,'2021-12-06 16:37:34','',''),(2185363,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-06 16:37:34','',''),(2185444,'1','197','1018',464,'Retail Sale Id 1290060',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:41:56','',''),(2185445,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:41:56','',''),(2185482,'1','197','1018',464,'Retail Sale Id 1290078',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:45:03','',''),(2185483,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:45:03','',''),(2185511,'1','197','1018',464,'Retail Sale Id 1290091',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 16:46:47','',''),(2185512,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:46:47','',''),(2185569,'1','197','1018',464,'Retail Sale Id 1290119',1503.04,0.00,0.00,0.00,112.24,'2021-12-06 16:48:29','',''),(2185570,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-06 16:48:29','',''),(2185595,'1','197','1018',464,'Retail Sale Id 1290134',2002.00,0.00,0.00,0.00,149.50,'2021-12-06 16:49:56','',''),(2185596,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-06 16:49:56','',''),(2185768,'1','197','1018',464,'Retail Sale Id 1290230',1897.28,0.00,0.00,0.00,141.68,'2021-12-06 17:00:36','',''),(2185769,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-06 17:00:36','',''),(2185885,'1','197','1018',464,'Retail Sale Id 1290289',22800.00,0.00,0.00,0.00,1140.00,'2021-12-06 17:08:42','',''),(2185886,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-06 17:08:42','',''),(2185927,'1','197','1018',464,'Retail Sale Id 1290313',5001.92,0.00,0.00,0.00,373.52,'2021-12-06 17:11:22','',''),(2185928,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-06 17:11:22','',''),(2186170,'1','197','1018',464,'Retail Sale Id 1290432',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 17:32:15','',''),(2186171,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:32:15','',''),(2186215,'1','197','1018',464,'Retail Sale Id 1290451',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 17:37:59','',''),(2186216,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:37:59','',''),(2186261,'1','197','1018',464,'Retail Sale Id 1290485',7700.00,0.00,0.00,0.00,575.00,'2021-12-06 17:44:23','',''),(2186262,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:44:23','',''),(2186410,'1','197','1018',464,'Retail Sale Id 1290557',2500.96,0.00,0.00,0.00,186.76,'2021-12-06 18:04:13','',''),(2186411,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-06 18:04:13','',''),(2186542,'1','197','1018',464,'Retail Sale Id 1290580',36528.00,0.00,0.00,0.00,1826.40,'2021-12-06 18:56:06','',''),(2186543,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,60.88,0.00,'2021-12-06 18:56:06','',''),(2186548,'1','197','1018',464,'Retail Sale Id 1290582',13903.12,0.00,0.00,0.00,1038.22,'2021-12-06 19:00:13','',''),(2186549,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,22.57,0.00,'2021-12-06 19:00:13','',''),(2189117,'1','197','1018',464,'Retail Sale Id 1291653',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 07:59:12','',''),(2189118,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 07:59:12','',''),(2190445,'1','197','1018',464,'Retail Sale Id 1292263',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 09:12:27','',''),(2190446,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:12:27','',''),(2190523,'1','197','1018',464,'Retail Sale Id 1292306',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 09:16:41','',''),(2190524,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 09:16:41','',''),(2190525,'1','197','1018',464,'Retail Sale Id 1292306',2999.92,0.00,0.00,0.00,224.02,'2021-12-07 09:16:41','',''),(2190526,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-07 09:16:41','',''),(2190527,'1','197','1018',464,'Retail Sale Id 1292306',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 09:16:41','',''),(2190528,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:16:41','',''),(2190553,'1','197','1018',464,'Retail Sale Id 1292319',33600.00,0.00,0.00,0.00,1680.00,'2021-12-07 09:17:52','',''),(2190554,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,56.00,0.00,'2021-12-07 09:17:52','',''),(2190711,'1','197','1018',464,'Retail Sale Id 1292390',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 09:26:46','',''),(2190712,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 09:26:46','',''),(2190713,'1','197','1018',464,'Retail Sale Id 1292390',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 09:26:46','',''),(2190714,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 09:26:46','',''),(2190715,'1','197','1018',464,'Retail Sale Id 1292390',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 09:26:46','',''),(2190716,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 09:26:46','',''),(2190896,'1','197','1018',464,'Retail Sale Id 1292474',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 09:34:48','',''),(2190897,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:34:48','',''),(2190978,'1','197','1018',464,'Retail Sale Id 1292520',1503.04,0.00,0.00,0.00,112.24,'2021-12-07 09:39:46','',''),(2190979,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-07 09:39:46','',''),(2191272,'1','197','1018',464,'Retail Sale Id 1292678',997.92,0.00,0.00,0.00,74.52,'2021-12-07 09:59:48','',''),(2191273,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-07 09:59:48','',''),(2191521,'1','197','1018',464,'Retail Sale Id 1292807',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 10:16:06','',''),(2191522,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 10:16:06','',''),(2191619,'1','197','1018',464,'Retail Sale Id 1292858',144600.00,0.00,0.00,0.00,7230.00,'2021-12-07 10:23:37','',''),(2191620,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,241.00,0.00,'2021-12-07 10:23:37','',''),(2191825,'1','197','1018',464,'Retail Sale Id 1292924',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 10:39:26','',''),(2191826,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:39:26','',''),(2193027,'1','197','1018',464,'Retail Sale Id 1293568',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 11:51:28','',''),(2193028,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 11:51:28','',''),(2193997,'1','197','1018',464,'Retail Sale Id 1294095',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 13:09:26','',''),(2193998,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:09:26','',''),(2194047,'1','197','1018',464,'Retail Sale Id 1294116',2002.00,0.00,0.00,0.00,149.50,'2021-12-07 13:12:30','',''),(2194048,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-07 13:12:30','',''),(2194049,'1','197','1018',464,'Retail Sale Id 1294116',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 13:12:30','',''),(2194050,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 13:12:30','',''),(2194051,'1','197','1018',464,'Retail Sale Id 1294116',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 13:12:30','',''),(2194052,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:12:30','',''),(2194989,'1','197','1018',464,'Retail Sale Id 1294614',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 14:08:35','',''),(2194990,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:08:35','',''),(2195061,'1','197','1018',464,'Retail Sale Id 1294659',6997.76,0.00,0.00,0.00,522.56,'2021-12-07 14:11:28','',''),(2195062,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-07 14:11:28','',''),(2195525,'1','197','1018',464,'Retail Sale Id 1294878',7398.16,0.00,0.00,0.00,552.46,'2021-12-07 14:36:47','',''),(2195526,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.01,0.00,'2021-12-07 14:36:47','',''),(2195527,'1','197','1018',464,'Retail Sale Id 1294878',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 14:36:47','',''),(2195528,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:36:47','',''),(2195547,'1','197','1018',464,'Retail Sale Id 1294888',997.92,0.00,0.00,0.00,74.52,'2021-12-07 14:37:57','',''),(2195548,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-07 14:37:57','',''),(2195900,'1','197','1018',464,'Retail Sale Id 1295072',3098.48,0.00,0.00,0.00,231.38,'2021-12-07 14:56:25','',''),(2195901,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-07 14:56:25','',''),(2195918,'1','197','1018',464,'Retail Sale Id 1295081',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 14:57:21','',''),(2195919,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:57:21','',''),(2196394,'1','197','1018',464,'Retail Sale Id 1295315',2297.68,0.00,0.00,0.00,171.58,'2021-12-07 15:24:13','',''),(2196395,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.73,0.00,'2021-12-07 15:24:13','',''),(2196396,'1','197','1018',464,'Retail Sale Id 1295315',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 15:24:13','',''),(2196397,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:24:13','',''),(2196550,'1','197','1018',464,'Retail Sale Id 1295368',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 15:31:00','',''),(2196551,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:31:00','',''),(2196666,'1','197','1018',464,'Retail Sale Id 1295455',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 15:37:24','',''),(2196667,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:37:24','',''),(2196668,'1','197','1018',464,'Retail Sale Id 1295455',15400.00,0.00,0.00,0.00,1150.00,'2021-12-07 15:37:24','',''),(2196669,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 15:37:24','',''),(2196767,'1','197','1018',464,'Retail Sale Id 1295492',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 15:40:51','',''),(2196768,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:40:51','',''),(2196793,'1','197','1018',464,'Retail Sale Id 1295504',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 15:42:25','',''),(2196794,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:42:25','',''),(2196867,'1','197','1018',464,'Retail Sale Id 1295535',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 15:45:43','',''),(2196868,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:45:43','',''),(2196935,'1','197','1018',464,'Retail Sale Id 1295579',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 15:49:18','',''),(2196936,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 15:49:18','',''),(2197187,'1','197','1018',464,'Retail Sale Id 1295712',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 16:00:56','',''),(2197188,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:00:56','',''),(2197189,'1','197','1018',464,'Retail Sale Id 1295712',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 16:00:56','',''),(2197190,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:00:56','',''),(2197209,'1','197','1018',464,'Retail Sale Id 1295722',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 16:02:08','',''),(2197210,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 16:02:08','',''),(2197271,'1','197','1018',464,'Retail Sale Id 1295753',1897.28,0.00,0.00,0.00,141.68,'2021-12-07 16:05:15','',''),(2197272,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-07 16:05:15','',''),(2197273,'1','197','1018',464,'Retail Sale Id 1295753',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 16:05:15','',''),(2197274,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:05:15','',''),(2197406,'1','197','1018',464,'Retail Sale Id 1295816',195000.00,0.00,0.00,0.00,9750.00,'2021-12-07 16:11:58','',''),(2197407,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,325.00,0.00,'2021-12-07 16:11:58','',''),(2197458,'1','197','1018',464,'Retail Sale Id 1295848',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 16:14:50','',''),(2197459,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 16:14:50','',''),(2197769,'1','197','1018',464,'Retail Sale Id 1296021',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 16:28:30','',''),(2197770,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:28:30','',''),(2198008,'1','197','1018',464,'Retail Sale Id 1296147',7500.00,0.00,0.00,0.00,375.00,'2021-12-07 16:42:27','',''),(2198009,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:42:27','',''),(2198220,'1','197','1018',464,'Retail Sale Id 1296254',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 16:54:17','',''),(2198221,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:54:17','',''),(2198242,'1','197','1018',464,'Retail Sale Id 1296267',15400.00,0.00,0.00,0.00,1150.00,'2021-12-07 16:55:28','',''),(2198243,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:55:28','',''),(2198264,'1','197','1018',464,'Retail Sale Id 1296276',1299.76,0.00,0.00,0.00,97.06,'2021-12-07 16:56:20','',''),(2198265,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-07 16:56:20','',''),(2198282,'1','197','1018',464,'Retail Sale Id 1296287',2999.92,0.00,0.00,0.00,224.02,'2021-12-07 16:57:09','',''),(2198283,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-07 16:57:09','',''),(2198312,'1','197','1018',464,'Retail Sale Id 1296298',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 16:58:30','',''),(2198313,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:58:30','',''),(2198455,'1','197','1018',464,'Retail Sale Id 1296369',1503.04,0.00,0.00,0.00,112.24,'2021-12-07 17:06:39','',''),(2198456,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-07 17:06:39','',''),(2198490,'1','197','1018',464,'Retail Sale Id 1296387',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 17:09:13','',''),(2198491,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:09:13','',''),(2198561,'1','197','1018',464,'Retail Sale Id 1296422',3702.16,0.00,0.00,0.00,276.46,'2021-12-07 17:15:04','',''),(2198562,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-07 17:15:04','',''),(2198579,'1','197','1018',464,'Retail Sale Id 1296451',2500.96,0.00,0.00,0.00,186.76,'2021-12-07 17:16:18','',''),(2198580,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-07 17:16:18','',''),(2198601,'1','197','1018',464,'Retail Sale Id 1296461',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 17:17:44','',''),(2198602,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:17:44','',''),(2198813,'1','197','1018',464,'Retail Sale Id 1296566',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 17:37:55','',''),(2198814,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:37:55','',''),(2198942,'1','197','1018',464,'Retail Sale Id 1296613',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 17:49:27','',''),(2198943,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:49:27','',''),(2198975,'1','197','1018',464,'Retail Sale Id 1296629',7700.00,0.00,0.00,0.00,575.00,'2021-12-07 17:51:55','',''),(2198976,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:51:55','',''),(2199177,'1','197','1018',464,'Retail Sale Id 1296705',15000.00,0.00,0.00,0.00,750.00,'2021-12-07 18:35:14','',''),(2199178,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 18:35:14','',''),(2199187,'1','197','1018',464,'Return of Retail Sale Id 1296629',0.00,7700.00,12.50,0.00,-575.00,'2021-12-07 18:38:23','',''),(2199192,'1','197','1018',464,'Retail Sale Id 1296713',2186.80,0.00,0.00,0.00,163.30,'2021-12-07 18:40:29','',''),(2199193,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.55,0.00,'2021-12-07 18:40:29','',''),(2200083,'1','197','1018',464,'Retail Sale Id 1296932',2002.00,0.00,0.00,0.00,149.50,'2021-12-08 06:41:27','',''),(2200084,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-08 06:41:27','',''),(2200379,'1','197','1018',464,'Retail Sale Id 1297038',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 06:56:39','',''),(2200380,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 06:56:39','',''),(2201308,'1','197','1018',464,'Retail Sale Id 1297483',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 07:50:04','',''),(2201309,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:50:04','',''),(2201843,'1','197','1018',464,'Retail Sale Id 1297730',60000.00,0.00,0.00,0.00,3000.00,'2021-12-08 08:18:33','',''),(2201844,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 08:18:33','',''),(2202210,'1','197','1018',464,'Retail Sale Id 1297900',3800.72,0.00,0.00,0.00,283.82,'2021-12-08 08:40:51','',''),(2202211,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-08 08:40:51','',''),(2202746,'1','197','1018',464,'Retail Sale Id 1298119',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 09:07:08','',''),(2202747,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:07:08','',''),(2202942,'1','197','1018',464,'Retail Sale Id 1298207',2002.00,0.00,0.00,0.00,149.50,'2021-12-08 09:18:25','',''),(2202943,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-08 09:18:25','',''),(2204808,'1','197','1018',464,'Retail Sale Id 1299119',1798.72,0.00,0.00,0.00,134.32,'2021-12-08 11:34:45','',''),(2204809,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.92,0.00,'2021-12-08 11:34:45','',''),(2205096,'1','197','1018',464,'Retail Sale Id 1299263',1897.28,0.00,0.00,0.00,141.68,'2021-12-08 11:52:40','',''),(2205097,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-08 11:52:40','',''),(2205357,'1','197','1018',464,'Retail Sale Id 1299376',38100.00,0.00,0.00,0.00,1905.00,'2021-12-08 12:11:49','',''),(2205358,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,63.50,0.00,'2021-12-08 12:11:49','',''),(2205792,'1','197','1018',464,'Retail Sale Id 1299583',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 12:44:52','',''),(2205793,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 12:44:52','',''),(2205819,'1','197','1018',464,'Retail Sale Id 1299595',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 12:46:59','',''),(2205820,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:46:59','',''),(2206054,'1','197','1018',464,'Retail Sale Id 1299687',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 13:01:05','',''),(2206055,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:01:05','',''),(2206066,'1','197','1018',464,'Retail Sale Id 1299695',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 13:02:30','',''),(2206067,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:02:30','',''),(2206179,'1','197','1018',464,'Retail Sale Id 1299750',30000.00,0.00,0.00,0.00,1500.00,'2021-12-08 13:10:06','',''),(2206180,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:10:06','',''),(2207265,'1','197','1018',464,'Retail Sale Id 1300215',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 14:16:20','',''),(2207266,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:16:20','',''),(2207523,'1','197','1018',464,'Retail Sale Id 1300342',20712.00,0.00,0.00,0.00,1035.60,'2021-12-08 14:29:35','',''),(2207524,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,34.52,0.00,'2021-12-08 14:29:35','',''),(2207596,'1','197','1018',464,'Retail Sale Id 1300363',1004.08,0.00,0.00,0.00,74.98,'2021-12-08 14:31:44','',''),(2207597,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.63,0.00,'2021-12-08 14:31:44','',''),(2207853,'1','197','1018',464,'Retail Sale Id 1300498',6997.76,0.00,0.00,0.00,522.56,'2021-12-08 14:45:51','',''),(2207854,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-08 14:45:51','',''),(2208134,'1','197','1018',464,'Retail Sale Id 1300635',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 15:04:53','',''),(2208135,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:04:53','',''),(2208311,'1','197','1018',464,'Retail Sale Id 1300712',3098.48,0.00,0.00,0.00,231.38,'2021-12-08 15:14:53','',''),(2208312,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-08 15:14:53','',''),(2208625,'1','197','1018',464,'Retail Sale Id 1300861',6196.96,0.00,0.00,0.00,462.76,'2021-12-08 15:31:04','',''),(2208626,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-08 15:31:04','',''),(2208637,'1','197','1018',464,'Retail Sale Id 1300868',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 15:31:54','',''),(2208638,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:31:54','',''),(2208651,'1','197','1018',464,'Retail Sale Id 1300876',2500.96,0.00,0.00,0.00,186.76,'2021-12-08 15:32:35','',''),(2208652,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-08 15:32:35','',''),(2208677,'1','197','1018',464,'Retail Sale Id 1300887',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 15:33:19','',''),(2208678,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 15:33:19','',''),(2208723,'1','197','1018',464,'Retail Sale Id 1300918',5999.84,0.00,0.00,0.00,448.04,'2021-12-08 15:35:47','',''),(2208724,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,9.74,0.00,'2021-12-08 15:35:47','',''),(2208849,'1','197','1018',464,'Retail Sale Id 1300985',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 15:42:20','',''),(2208850,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:42:20','',''),(2209179,'1','197','1018',464,'Retail Sale Id 1301067',15400.00,0.00,0.00,0.00,1150.00,'2021-12-08 16:00:21','',''),(2209180,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 16:00:21','',''),(2209231,'1','197','1018',464,'Retail Sale Id 1301172',14402.08,0.00,0.00,0.00,1075.48,'2021-12-08 16:02:47','',''),(2209232,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,23.38,0.00,'2021-12-08 16:02:47','',''),(2209255,'1','197','1018',464,'Retail Sale Id 1301184',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:03:34','',''),(2209256,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:03:34','',''),(2209287,'1','197','1018',464,'Retail Sale Id 1301197',2002.00,0.00,0.00,0.00,149.50,'2021-12-08 16:05:12','',''),(2209288,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-08 16:05:12','',''),(2209414,'1','197','1018',464,'Retail Sale Id 1301255',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:10:45','',''),(2209415,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:10:45','',''),(2209470,'1','197','1018',464,'Retail Sale Id 1301282',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 16:12:38','',''),(2209471,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:12:38','',''),(2209492,'1','197','1018',464,'Retail Sale Id 1301294',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:13:50','',''),(2209493,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:13:50','',''),(2209530,'1','197','1018',464,'Retail Sale Id 1301309',1897.28,0.00,0.00,0.00,141.68,'2021-12-08 16:15:20','',''),(2209531,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-08 16:15:20','',''),(2209580,'1','197','1018',464,'Retail Sale Id 1301327',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:16:36','',''),(2209581,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:16:36','',''),(2209658,'1','197','1018',464,'Retail Sale Id 1301364',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 16:20:14','',''),(2209659,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:20:14','',''),(2209786,'1','197','1018',464,'Retail Sale Id 1301472',15600.00,0.00,0.00,0.00,780.00,'2021-12-08 16:28:29','',''),(2209787,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-08 16:28:29','',''),(2209815,'1','197','1018',464,'Retail Sale Id 1301564',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 16:29:21','',''),(2209816,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:29:21','',''),(2210115,'1','197','1018',464,'Retail Sale Id 1301707',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:43:10','',''),(2210116,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:43:10','',''),(2210183,'1','197','1018',464,'Retail Sale Id 1301743',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:46:52','',''),(2210184,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:46:52','',''),(2210251,'1','197','1018',464,'Retail Sale Id 1301779',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 16:49:58','',''),(2210252,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 16:49:58','',''),(2210290,'1','197','1018',464,'Retail Sale Id 1301798',1503.04,0.00,0.00,0.00,112.24,'2021-12-08 16:52:31','',''),(2210291,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-08 16:52:31','',''),(2210334,'1','197','1018',464,'Retail Sale Id 1301820',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 16:54:53','',''),(2210335,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:54:53','',''),(2210400,'1','197','1018',464,'Retail Sale Id 1301848',6196.96,0.00,0.00,0.00,462.76,'2021-12-08 16:59:47','',''),(2210401,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-08 16:59:47','',''),(2210430,'1','197','1018',464,'Retail Sale Id 1301874',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 17:01:39','',''),(2210431,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:01:39','',''),(2210454,'1','197','1018',464,'Retail Sale Id 1301889',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 17:03:54','',''),(2210455,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:03:54','',''),(2210545,'1','197','1018',464,'Retail Sale Id 1301940',2999.92,0.00,0.00,0.00,224.02,'2021-12-08 17:12:26','',''),(2210546,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-08 17:12:26','',''),(2210904,'1','197','1018',464,'Retail Sale Id 1302115',7700.00,0.00,0.00,0.00,575.00,'2021-12-08 17:47:51','',''),(2210905,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:47:51','',''),(2210918,'1','197','1018',464,'Retail Sale Id 1302117',3702.16,0.00,0.00,0.00,276.46,'2021-12-08 17:49:24','',''),(2210919,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-08 17:49:24','',''),(2211072,'1','197','1018',464,'Return of Retail Sale Id 1301707',0.00,7700.00,12.50,0.00,-575.00,'2021-12-08 18:25:53','',''),(2211082,'1','197','1018',464,'Retail Sale Id 1302181',5400.00,0.00,0.00,0.00,270.00,'2021-12-08 18:28:11','',''),(2211083,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 18:28:11','',''),(2211094,'1','197','1018',464,'Retail Sale Id 1302183',3443.44,0.00,0.00,0.00,257.14,'2021-12-08 18:30:04','',''),(2211095,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.59,0.00,'2021-12-08 18:30:04','',''),(2212567,'1','197','1018',464,'Retail Sale Id 1302618',28998.00,0.00,0.00,0.00,1449.90,'2021-12-09 06:45:18','',''),(2212568,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,48.33,0.00,'2021-12-09 06:45:18','',''),(2212605,'1','197','1018',464,'Retail Sale Id 1302638',1897.28,0.00,0.00,0.00,141.68,'2021-12-09 06:47:15','',''),(2212606,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-09 06:47:15','',''),(2212816,'1','197','1018',464,'Retail Sale Id 1302730',3894.00,0.00,0.00,0.00,194.70,'2021-12-09 06:58:52','',''),(2212817,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-09 06:58:52','',''),(2212824,'1','197','1018',464,'Retail Sale Id 1302735',98.56,0.00,0.00,0.00,7.36,'2021-12-09 06:59:34','',''),(2212825,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,0.16,0.00,'2021-12-09 06:59:34','',''),(2213842,'1','197','1018',464,'Retail Sale Id 1303220',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 07:48:31','',''),(2213843,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 07:48:31','',''),(2213934,'1','197','1018',464,'Retail Sale Id 1303262',800.80,0.00,0.00,0.00,59.80,'2021-12-09 07:52:43','',''),(2213935,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.30,0.00,'2021-12-09 07:52:43','',''),(2215252,'1','197','1018',464,'Retail Sale Id 1303885',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 09:01:20','',''),(2215253,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:01:20','',''),(2215412,'1','197','1018',464,'Retail Sale Id 1303972',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 09:11:02','',''),(2215413,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:11:02','',''),(2215452,'1','197','1018',464,'Retail Sale Id 1303992',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 09:13:44','',''),(2215453,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:13:44','',''),(2215624,'1','197','1018',464,'Retail Sale Id 1304077',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 09:23:16','',''),(2215625,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:23:16','',''),(2218880,'1','197','1018',464,'Retail Sale Id 1305672',11402.16,0.00,0.00,0.00,851.46,'2021-12-09 12:40:02','',''),(2218881,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-09 12:40:02','',''),(2218902,'1','197','1018',464,'Retail Sale Id 1305677',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 12:41:02','',''),(2218903,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:41:02','',''),(2219043,'1','197','1018',464,'Retail Sale Id 1305758',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 12:49:06','',''),(2219044,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 12:49:06','',''),(2220050,'1','197','1018',464,'Retail Sale Id 1306183',43380.00,0.00,0.00,0.00,2169.00,'2021-12-09 13:46:34','',''),(2220051,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,72.30,0.00,'2021-12-09 13:46:34','',''),(2220169,'1','197','1018',464,'Retail Sale Id 1306242',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 13:54:36','',''),(2220170,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 13:54:36','',''),(2220183,'1','197','1018',464,'Retail Sale Id 1306250',1897.28,0.00,0.00,0.00,141.68,'2021-12-09 13:55:18','',''),(2220184,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-09 13:55:18','',''),(2220478,'1','197','1018',464,'Retail Sale Id 1306416',6997.76,0.00,0.00,0.00,522.56,'2021-12-09 14:14:44','',''),(2220479,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-09 14:14:44','',''),(2220500,'1','197','1018',464,'Retail Sale Id 1306425',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 14:15:55','',''),(2220501,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:15:55','',''),(2220560,'1','197','1018',464,'Retail Sale Id 1306458',2999.92,0.00,0.00,0.00,224.02,'2021-12-09 14:20:28','',''),(2220561,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-09 14:20:28','',''),(2220671,'1','197','1018',464,'Retail Sale Id 1306515',2002.00,0.00,0.00,0.00,149.50,'2021-12-09 14:25:42','',''),(2220672,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-09 14:25:42','',''),(2220692,'1','197','1018',464,'Retail Sale Id 1306521',15400.00,0.00,0.00,0.00,1150.00,'2021-12-09 14:26:34','',''),(2220693,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 14:26:34','',''),(2220814,'1','197','1018',464,'Retail Sale Id 1306581',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 14:32:41','',''),(2220815,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 14:32:41','',''),(2221004,'1','197','1018',464,'Retail Sale Id 1306666',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 14:39:44','',''),(2221005,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:39:44','',''),(2221033,'1','197','1018',464,'Retail Sale Id 1306681',6498.80,0.00,0.00,0.00,485.30,'2021-12-09 14:41:04','',''),(2221034,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.55,0.00,'2021-12-09 14:41:04','',''),(2221194,'1','197','1018',464,'Retail Sale Id 1306752',5599.44,0.00,0.00,0.00,418.14,'2021-12-09 14:48:03','',''),(2221195,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,9.09,0.00,'2021-12-09 14:48:03','',''),(2221516,'1','197','1018',464,'Retail Sale Id 1306866',1299.76,0.00,0.00,0.00,97.06,'2021-12-09 15:01:59','',''),(2221517,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-09 15:01:59','',''),(2221542,'1','197','1018',464,'Retail Sale Id 1306879',15098.16,0.00,0.00,0.00,1127.46,'2021-12-09 15:03:25','',''),(2221543,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,24.51,0.00,'2021-12-09 15:03:25','',''),(2221566,'1','197','1018',464,'Retail Sale Id 1306891',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 15:04:26','',''),(2221567,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:04:26','',''),(2221606,'1','197','1018',464,'Retail Sale Id 1306915',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 15:06:15','',''),(2221607,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:06:15','',''),(2221640,'1','197','1018',464,'Retail Sale Id 1306932',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 15:07:57','',''),(2221641,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:07:57','',''),(2221759,'1','197','1018',464,'Retail Sale Id 1306992',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 15:13:36','',''),(2221760,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 15:13:36','',''),(2222969,'1','197','1018',464,'Retail Sale Id 1307596',997.92,0.00,0.00,0.00,74.52,'2021-12-09 16:16:45','',''),(2222970,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-09 16:16:45','',''),(2222971,'1','197','1018',464,'Retail Sale Id 1307596',1201.20,0.00,0.00,0.00,89.70,'2021-12-09 16:16:45','',''),(2222972,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.95,0.00,'2021-12-09 16:16:45','',''),(2222987,'1','197','1018',464,'Retail Sale Id 1307610',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 16:17:50','',''),(2222988,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:17:50','',''),(2223011,'1','197','1018',464,'Retail Sale Id 1307624',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 16:19:40','',''),(2223012,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 16:19:40','',''),(2223085,'1','197','1018',464,'Retail Sale Id 1307656',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 16:23:25','',''),(2223086,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:23:25','',''),(2223119,'1','197','1018',464,'Retail Sale Id 1307674',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 16:25:53','',''),(2223120,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:25:53','',''),(2223166,'1','197','1018',464,'Retail Sale Id 1307690',3702.16,0.00,0.00,0.00,276.46,'2021-12-09 16:27:28','',''),(2223167,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-09 16:27:28','',''),(2223200,'1','197','1018',464,'Retail Sale Id 1307706',997.92,0.00,0.00,0.00,74.52,'2021-12-09 16:28:54','',''),(2223201,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-09 16:28:54','',''),(2223249,'1','197','1018',464,'Retail Sale Id 1307729',3498.88,0.00,0.00,0.00,261.28,'2021-12-09 16:32:02','',''),(2223250,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.68,0.00,'2021-12-09 16:32:02','',''),(2223393,'1','197','1018',464,'Retail Sale Id 1307794',1897.28,0.00,0.00,0.00,141.68,'2021-12-09 16:40:00','',''),(2223394,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-09 16:40:00','',''),(2223468,'1','197','1018',464,'Retail Sale Id 1307816',3098.48,0.00,0.00,0.00,231.38,'2021-12-09 16:42:50','',''),(2223469,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-09 16:42:50','',''),(2223613,'1','197','1018',464,'Retail Sale Id 1307881',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 16:51:40','',''),(2223614,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:51:40','',''),(2223693,'1','197','1018',464,'Retail Sale Id 1307912',29001.28,0.00,0.00,0.00,2165.68,'2021-12-09 16:55:40','',''),(2223694,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,47.08,0.00,'2021-12-09 16:55:40','',''),(2223973,'1','197','1018',464,'Retail Sale Id 1308055',7700.00,0.00,0.00,0.00,575.00,'2021-12-09 17:15:32','',''),(2223974,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 17:15:32','',''),(2223994,'1','197','1018',464,'Retail Sale Id 1308066',12000.00,0.00,0.00,0.00,600.00,'2021-12-09 17:18:02','',''),(2223995,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 17:18:02','',''),(2224128,'1','197','1018',464,'Retail Sale Id 1308131',34002.00,0.00,0.00,0.00,1700.10,'2021-12-09 17:34:36','',''),(2224129,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,56.67,0.00,'2021-12-09 17:34:36','',''),(2224288,'1','197','1018',464,'Retail Sale Id 1308208',78000.00,0.00,0.00,0.00,3900.00,'2021-12-09 18:01:57','',''),(2224289,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-09 18:01:57','',''),(2224467,'1','197','1018',464,'Retail Sale Id 1308282',10028.48,0.00,0.00,0.00,748.88,'2021-12-09 18:36:00','',''),(2224468,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,16.28,0.00,'2021-12-09 18:36:00','',''),(2224518,'1','197','1018',464,'Retail Sale Id 1308293',1110.00,0.00,0.00,0.00,55.50,'2021-12-09 18:56:27','',''),(2224519,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.85,0.00,'2021-12-09 18:56:27','',''),(2228699,'1','197','1018',464,'Distributed to ALL DEALER for sales id:338473',261738.30,0.00,0.00,459.19,0.00,'2021-12-10 09:31:30','',''),(2229941,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,570000.00,1000.00,0.00,0.00,'2021-12-10 10:41:33','',''),(2229973,'1','197',NULL,464,'Reception corrector for bridging 126870',0.00,0.00,0.00,1000.00,0.00,'2021-12-10 10:43:30','',''),(2229974,'1','197','1018',464,'Received from bridging 126870',0.00,0.00,1000.00,0.00,0.00,'2021-12-10 10:43:30','',''),(2230041,'1','197','1018',464,'Retail Sale Id 1310657',21344.40,0.00,0.00,0.00,653.40,'2021-12-10 10:47:21','',''),(2230042,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,36.30,0.00,'2021-12-10 10:47:21','',''),(2230083,'1','197','1018',464,'Retail Sale Id 1310667',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 10:48:54','',''),(2230084,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:48:54','',''),(2230108,'1','197','1018',464,'Retail Sale Id 1310681',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 10:50:11','',''),(2230109,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:50:11','',''),(2231308,'1','197','1018',464,'Retail Sale Id 1311243',10798.48,0.00,0.00,0.00,806.38,'2021-12-10 12:07:32','',''),(2231309,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,17.53,0.00,'2021-12-10 12:07:32','',''),(2231491,'1','197','1018',464,'Retail Sale Id 1311337',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 12:22:11','',''),(2231492,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:22:11','',''),(2231538,'1','197','1018',464,'Retail Sale Id 1311362',3702.16,0.00,0.00,0.00,276.46,'2021-12-10 12:25:39','',''),(2231539,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 12:25:39','',''),(2231872,'1','197','1018',464,'Retail Sale Id 1311539',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 12:54:43','',''),(2231873,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:54:43','',''),(2231890,'1','197','1018',464,'Retail Sale Id 1311548',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 12:56:03','',''),(2231891,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:56:03','',''),(2231906,'1','197','1018',464,'Retail Sale Id 1311553',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 12:56:51','',''),(2231907,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:56:51','',''),(2231924,'1','197','1018',464,'Retail Sale Id 1311565',6997.76,0.00,0.00,0.00,522.56,'2021-12-10 12:58:01','',''),(2231925,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-10 12:58:01','',''),(2231994,'1','197','1018',464,'Retail Sale Id 1311600',3049.20,0.00,0.00,0.00,227.70,'2021-12-10 13:03:17','',''),(2231995,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.95,0.00,'2021-12-10 13:03:17','',''),(2232081,'1','197','1018',464,'Retail Sale Id 1311646',15400.00,0.00,0.00,0.00,1150.00,'2021-12-10 13:09:17','',''),(2232082,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 13:09:17','',''),(2232104,'1','197','1018',464,'Retail Sale Id 1311654',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 13:10:28','',''),(2232105,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:10:28','',''),(2232276,'1','197','1018',464,'Retail Sale Id 1311716',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 13:19:20','',''),(2232277,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:19:20','',''),(2232387,'1','197','1018',464,'Retail Sale Id 1311768',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 13:26:51','',''),(2232388,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:26:51','',''),(2232541,'1','197','1018',464,'Retail Sale Id 1311849',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 13:36:28','',''),(2232542,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:36:28','',''),(2232691,'1','197','1018',464,'Retail Sale Id 1311920',616.00,0.00,0.00,0.00,46.00,'2021-12-10 13:43:14','',''),(2232692,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 13:43:14','',''),(2232741,'1','197','1018',464,'Retail Sale Id 1311937',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 13:45:04','',''),(2232742,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:45:04','',''),(2232857,'1','197','1018',464,'Retail Sale Id 1311989',2500.96,0.00,0.00,0.00,186.76,'2021-12-10 13:50:42','',''),(2232858,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-10 13:50:42','',''),(2233860,'1','197','1018',464,'Retail Sale Id 1312409',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 14:37:03','',''),(2233861,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:37:03','',''),(2233933,'1','197','1018',464,'Retail Sale Id 1312442',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 14:40:04','',''),(2233934,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:40:04','',''),(2234019,'1','197','1018',464,'Retail Sale Id 1312452',15400.00,0.00,0.00,0.00,1150.00,'2021-12-10 14:43:18','',''),(2234020,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 14:43:18','',''),(2234103,'1','197','1018',464,'Retail Sale Id 1312510',15400.00,0.00,0.00,0.00,1150.00,'2021-12-10 14:45:54','',''),(2234104,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 14:45:54','',''),(2234145,'1','197','1018',464,'Retail Sale Id 1312531',7700.00,0.00,0.00,0.00,575.00,'2021-12-10 14:47:53','',''),(2234146,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:47:53','',''),(2234241,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2231140.00,3970.00,0.00,0.00,'2021-12-10 14:52:08','',''),(2234322,'1','197',NULL,464,'Reception corrector for bridging 126900',0.00,0.00,0.00,3970.00,0.00,'2021-12-10 14:56:07','',''),(2234323,'1','197','1018',464,'Received from bridging 126900',0.00,0.00,3970.00,0.00,0.00,'2021-12-10 14:56:07','',''),(2234458,'1','197','1018',464,'Retail Sale Id 1312685',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 15:05:01','',''),(2234459,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:05:01','',''),(2234627,'1','197','1018',464,'Retail Sale Id 1312753',1897.28,0.00,0.00,0.00,166.32,'2021-12-10 15:12:22','',''),(2234628,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-10 15:12:22','',''),(2234689,'1','197','1018',464,'Retail Sale Id 1312792',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 15:14:47','',''),(2234690,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:14:47','',''),(2234799,'1','197','1018',464,'Retail Sale Id 1312849',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 15:19:35','',''),(2234800,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:19:35','',''),(2234882,'1','197','1018',464,'Retail Sale Id 1312899',3098.48,0.00,0.00,0.00,271.62,'2021-12-10 15:22:47','',''),(2234883,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-10 15:22:47','',''),(2234972,'1','197','1018',464,'Retail Sale Id 1312947',2500.96,0.00,0.00,0.00,219.24,'2021-12-10 15:25:58','',''),(2234973,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-10 15:25:58','',''),(2235028,'1','197','1018',464,'Retail Sale Id 1312967',3997.84,0.00,0.00,0.00,350.46,'2021-12-10 15:27:39','',''),(2235029,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.49,0.00,'2021-12-10 15:27:39','',''),(2235109,'1','197','1018',464,'Retail Sale Id 1312990',15400.00,0.00,0.00,0.00,1350.00,'2021-12-10 15:30:10','',''),(2235110,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 15:30:10','',''),(2235377,'1','197','1018',464,'Retail Sale Id 1313119',2002.00,0.00,0.00,0.00,175.50,'2021-12-10 15:42:04','',''),(2235378,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 15:42:04','',''),(2235530,'1','197','1018',464,'Retail Sale Id 1313214',50209.32,0.00,0.00,0.00,2220.14,'2021-12-10 15:49:07','',''),(2235531,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,85.39,0.00,'2021-12-10 15:49:07','',''),(2235676,'1','197','1018',464,'Retail Sale Id 1313291',41501.04,0.00,0.00,0.00,1835.08,'2021-12-10 15:56:12','',''),(2235677,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,70.58,0.00,'2021-12-10 15:56:12','',''),(2235690,'1','197','1018',464,'Retail Sale Id 1313300',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 15:57:05','',''),(2235691,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:57:05','',''),(2236320,'1','197','1018',464,'Retail Sale Id 1313618',3098.48,0.00,0.00,0.00,271.62,'2021-12-10 16:25:18','',''),(2236321,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-10 16:25:18','',''),(2236322,'1','197','1018',464,'Retail Sale Id 1313618',11001.76,0.00,0.00,0.00,964.44,'2021-12-10 16:25:18','',''),(2236323,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,17.86,0.00,'2021-12-10 16:25:18','',''),(2236696,'1','197','1018',464,'Retail Sale Id 1313783',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 16:42:50','',''),(2236697,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:42:50','',''),(2236710,'1','197','1018',464,'Retail Sale Id 1313791',1503.04,0.00,0.00,0.00,131.76,'2021-12-10 16:43:42','',''),(2236711,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 16:43:42','',''),(2236892,'1','197','1018',464,'Retail Sale Id 1313879',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 16:54:18','',''),(2236893,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:54:18','',''),(2236900,'1','197','1018',464,'Retail Sale Id 1313884',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 16:54:57','',''),(2236901,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:54:57','',''),(2236957,'1','197','1018',464,'Retail Sale Id 1313926',3702.16,0.00,0.00,0.00,324.54,'2021-12-10 16:59:28','',''),(2236958,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-10 16:59:28','',''),(2237088,'1','197','1018',464,'Retail Sale Id 1313983',997.92,0.00,0.00,0.00,87.48,'2021-12-10 17:06:55','',''),(2237089,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 17:06:55','',''),(2237158,'1','197','1018',464,'Retail Sale Id 1314016',2999.92,0.00,0.00,0.00,262.98,'2021-12-10 17:13:04','',''),(2237159,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-10 17:13:04','',''),(2237413,'1','197','1018',464,'Retail Sale Id 1314116',88200.00,0.00,0.00,0.00,3900.00,'2021-12-10 17:35:56','',''),(2237414,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-10 17:35:56','',''),(2237420,'1','197','1018',464,'Retail Sale Id 1314120',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 17:36:27','',''),(2237421,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:36:27','',''),(2237432,'1','197','1018',464,'Retail Sale Id 1314124',7700.00,0.00,0.00,0.00,675.00,'2021-12-10 17:37:26','',''),(2237433,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:37:26','',''),(2237443,'1','197','1018',464,'Retail Sale Id 1314129',1503.04,0.00,0.00,0.00,131.76,'2021-12-10 17:38:22','',''),(2237444,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 17:38:22','',''),(2237471,'1','197','1018',464,'Retail Sale Id 1314139',5550.16,0.00,0.00,0.00,486.54,'2021-12-10 17:40:07','',''),(2237472,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,9.01,0.00,'2021-12-10 17:40:07','',''),(2237756,'1','197','1018',464,'Return of Retail Sale Id 1313618',0.00,3098.48,5.03,0.00,-271.62,'2021-12-10 18:33:29','',''),(2237757,'1','197','1018',464,'Return of Retail Sale Id 1313618',0.00,11001.76,17.86,0.00,-964.44,'2021-12-10 18:33:29','',''),(2237766,'1','197','1018',464,'Retail Sale Id 1314318',7022.40,0.00,0.00,0.00,615.60,'2021-12-10 18:36:55','',''),(2237767,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.40,0.00,'2021-12-10 18:36:55','',''),(2237778,'1','197','1018',464,'Retail Sale Id 1314324',46881.24,0.00,0.00,0.00,2072.98,'2021-12-10 18:39:04','',''),(2237779,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,79.73,0.00,'2021-12-10 18:39:04','',''),(2239527,'1','197','1018',464,'Retail Sale Id 1314954',57747.48,0.00,0.00,0.00,2553.46,'2021-12-11 07:19:16','',''),(2239528,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,98.21,0.00,'2021-12-11 07:19:16','',''),(2239650,'1','197','1018',464,'Retail Sale Id 1315035',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 07:26:07','',''),(2239651,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:26:07','',''),(2239674,'1','197','1018',464,'Retail Sale Id 1315044',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 07:27:09','',''),(2239675,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:27:09','',''),(2239955,'1','197','1018',464,'Retail Sale Id 1315191',2002.00,0.00,0.00,0.00,175.50,'2021-12-11 07:41:46','',''),(2239956,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-11 07:41:46','',''),(2241040,'1','197','1018',464,'Retail Sale Id 1315693',6196.96,0.00,0.00,0.00,543.24,'2021-12-11 08:30:20','',''),(2241041,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-11 08:30:20','',''),(2241862,'1','197','1018',464,'Retail Sale Id 1316063',159348.00,0.00,0.00,0.00,7046.00,'2021-12-11 09:07:27','',''),(2241863,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,271.00,0.00,'2021-12-11 09:07:27','',''),(2242253,'1','197','1018',464,'Retail Sale Id 1316244',30800.00,0.00,0.00,0.00,2700.00,'2021-12-11 09:25:08','',''),(2242254,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 09:25:08','',''),(2242400,'1','197','1018',464,'Retail Sale Id 1316322',3800.72,0.00,0.00,0.00,333.18,'2021-12-11 09:33:37','',''),(2242401,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 09:33:37','',''),(2242418,'1','197','1018',464,'Retail Sale Id 1316332',1250.48,0.00,0.00,0.00,109.62,'2021-12-11 09:34:25','',''),(2242419,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-11 09:34:25','',''),(2242570,'1','197','1018',464,'Retail Sale Id 1316415',26180.00,0.00,0.00,0.00,2295.00,'2021-12-11 09:41:33','',''),(2242573,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-11 09:41:33','',''),(2242920,'1','197','1018',464,'Retail Sale Id 1316579',14001.68,0.00,0.00,0.00,1227.42,'2021-12-11 09:58:32','',''),(2242921,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,22.73,0.00,'2021-12-11 09:58:32','',''),(2243507,'1','197','1018',464,'Retail Sale Id 1316838',57918.00,0.00,0.00,0.00,2561.00,'2021-12-11 10:26:13','',''),(2243508,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,98.50,0.00,'2021-12-11 10:26:13','',''),(2243659,'1','197','1018',464,'Retail Sale Id 1316913',3702.16,0.00,0.00,0.00,324.54,'2021-12-11 10:34:37','',''),(2243660,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 10:34:37','',''),(2244472,'1','197','1018',464,'Retail Sale Id 1317298',1897.28,0.00,0.00,0.00,166.32,'2021-12-11 11:16:13','',''),(2244473,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-11 11:16:13','',''),(2244599,'1','197','1018',464,'Retail Sale Id 1317362',8999.76,0.00,0.00,0.00,788.94,'2021-12-11 11:22:39','',''),(2244600,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,14.61,0.00,'2021-12-11 11:22:39','',''),(2244699,'1','197','1018',464,'Return of Retail Sale Id 1317362',0.00,8999.76,14.61,0.00,-788.94,'2021-12-11 11:26:26','',''),(2244774,'1','197','1018',464,'Retail Sale Id 1317447',55272.00,0.00,0.00,0.00,2444.00,'2021-12-11 11:31:28','',''),(2244776,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-11 11:31:28','',''),(2245257,'1','197','1018',464,'Retail Sale Id 1317701',41160.00,0.00,0.00,0.00,1820.00,'2021-12-11 12:00:08','',''),(2245258,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-11 12:00:08','',''),(2245417,'1','197','1018',464,'Retail Sale Id 1317824',702.24,0.00,0.00,0.00,61.56,'2021-12-11 12:12:31','',''),(2245418,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.14,0.00,'2021-12-11 12:12:31','',''),(2246150,'1','197','1018',464,'Retail Sale Id 1318192',32340.00,0.00,0.00,0.00,1430.00,'2021-12-11 12:57:48','',''),(2246151,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-11 12:57:48','',''),(2246214,'1','197','1018',464,'Retail Sale Id 1318233',10798.48,0.00,0.00,0.00,946.62,'2021-12-11 13:02:18','',''),(2246215,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,17.53,0.00,'2021-12-11 13:02:18','',''),(2246379,'1','197','1018',464,'Retail Sale Id 1318319',30800.00,0.00,0.00,0.00,2700.00,'2021-12-11 13:16:20','',''),(2246380,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 13:16:20','',''),(2246411,'1','197','1018',464,'Retail Sale Id 1318333',36750.00,0.00,0.00,0.00,1625.00,'2021-12-11 13:19:21','',''),(2246412,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-11 13:19:21','',''),(2247620,'1','197','1018',464,'Retail Sale Id 1318910',35280.00,0.00,0.00,0.00,1560.00,'2021-12-11 14:36:13','',''),(2247621,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 14:36:13','',''),(2247826,'1','197','1018',464,'Retail Sale Id 1319002',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 14:48:17','',''),(2247827,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:48:17','',''),(2248071,'1','197','1018',464,'Retail Sale Id 1319144',3702.16,0.00,0.00,0.00,324.54,'2021-12-11 15:02:31','',''),(2248072,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 15:02:31','',''),(2248225,'1','197','1018',464,'Retail Sale Id 1319189',49098.00,0.00,0.00,0.00,2171.00,'2021-12-11 15:08:37','',''),(2248226,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,83.50,0.00,'2021-12-11 15:08:37','',''),(2248628,'1','197','1018',464,'Retail Sale Id 1319398',6812.96,0.00,0.00,0.00,597.24,'2021-12-11 15:29:44','',''),(2248629,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.06,0.00,'2021-12-11 15:29:44','',''),(2248848,'1','197','1018',464,'Retail Sale Id 1319519',3498.88,0.00,0.00,0.00,306.72,'2021-12-11 15:42:13','',''),(2248849,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.68,0.00,'2021-12-11 15:42:13','',''),(2249049,'1','197','1018',464,'Retail Sale Id 1319617',16699.76,0.00,0.00,0.00,1463.94,'2021-12-11 15:50:50','',''),(2249050,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,27.11,0.00,'2021-12-11 15:50:50','',''),(2249335,'1','197','1018',464,'Retail Sale Id 1319729',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 16:01:24','',''),(2249336,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:01:24','',''),(2249351,'1','197','1018',464,'Retail Sale Id 1319736',6800.64,0.00,0.00,0.00,596.16,'2021-12-11 16:01:54','',''),(2249352,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.04,0.00,'2021-12-11 16:01:54','',''),(2249371,'1','197','1018',464,'Retail Sale Id 1319745',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 16:02:46','',''),(2249372,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:02:46','',''),(2249395,'1','197','1018',464,'Retail Sale Id 1319756',616.00,0.00,0.00,0.00,54.00,'2021-12-11 16:03:27','',''),(2249396,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 16:03:27','',''),(2249472,'1','197','1018',464,'Retail Sale Id 1319795',5001.92,0.00,0.00,0.00,438.48,'2021-12-11 16:07:32','',''),(2249473,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-11 16:07:32','',''),(2249577,'1','197','1018',464,'Retail Sale Id 1319847',1897.28,0.00,0.00,0.00,166.32,'2021-12-11 16:12:07','',''),(2249578,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-11 16:12:07','',''),(2250145,'1','197','1018',464,'Retail Sale Id 1320139',22050.00,0.00,0.00,0.00,975.00,'2021-12-11 16:42:12','',''),(2250146,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-11 16:42:12','',''),(2250358,'1','197','1018',464,'Retail Sale Id 1320219',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 16:54:57','',''),(2250359,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:54:57','',''),(2250418,'1','197','1018',464,'Retail Sale Id 1320253',1299.76,0.00,0.00,0.00,113.94,'2021-12-11 16:58:18','',''),(2250419,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.11,0.00,'2021-12-11 16:58:18','',''),(2250494,'1','197','1018',464,'Retail Sale Id 1320290',1897.28,0.00,0.00,0.00,166.32,'2021-12-11 17:02:43','',''),(2250495,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-11 17:02:43','',''),(2250524,'1','197','1018',464,'Retail Sale Id 1320303',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 17:03:59','',''),(2250527,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:03:59','',''),(2250578,'1','197','1018',464,'Retail Sale Id 1320330',997.92,0.00,0.00,0.00,87.48,'2021-12-11 17:07:55','',''),(2250579,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-11 17:07:55','',''),(2250592,'1','197','1018',464,'Retail Sale Id 1320336',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 17:09:10','',''),(2250593,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:09:10','',''),(2250654,'1','197','1018',464,'Retail Sale Id 1320377',3080.00,0.00,0.00,0.00,270.00,'2021-12-11 17:15:37','',''),(2250655,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 17:15:37','',''),(2250692,'1','197','1018',464,'Retail Sale Id 1320394',2002.00,0.00,0.00,0.00,175.50,'2021-12-11 17:19:16','',''),(2250693,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-11 17:19:16','',''),(2250776,'1','197','1018',464,'Retail Sale Id 1320436',7700.00,0.00,0.00,0.00,675.00,'2021-12-11 17:26:29','',''),(2250777,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 17:26:29','',''),(2250833,'1','197','1018',464,'Retail Sale Id 1320461',3702.16,0.00,0.00,0.00,324.54,'2021-12-11 17:29:57','',''),(2250834,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-11 17:29:57','',''),(2250848,'1','197','1018',464,'Retail Sale Id 1320467',3800.72,0.00,0.00,0.00,333.18,'2021-12-11 17:31:39','',''),(2250849,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-11 17:31:39','',''),(2250864,'1','197','1018',464,'Retail Sale Id 1320479',3098.48,0.00,0.00,0.00,271.62,'2021-12-11 17:32:44','',''),(2250865,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-11 17:32:44','',''),(2251127,'1','197','1018',464,'Retail Sale Id 1320585',40589.64,0.00,0.00,0.00,1794.78,'2021-12-11 17:55:34','',''),(2251128,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,69.03,0.00,'2021-12-11 17:55:34','',''),(2251491,'1','197','1018',464,'Retail Sale Id 1320740',7010.08,0.00,0.00,0.00,614.52,'2021-12-11 18:47:31','',''),(2251492,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.38,0.00,'2021-12-11 18:47:31','',''),(2251497,'1','197','1018',464,'Retail Sale Id 1320743',7350.00,0.00,0.00,0.00,325.00,'2021-12-11 18:50:31','',''),(2251498,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 18:50:31','',''),(2252829,'1','197','1018',464,'Retail Sale Id 1321150',29400.00,0.00,0.00,0.00,1300.00,'2021-12-12 07:08:53','',''),(2252830,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 07:08:53','',''),(2253385,'1','197','1018',464,'Retail Sale Id 1321443',4502.96,0.00,0.00,0.00,394.74,'2021-12-12 07:46:59','',''),(2253386,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,7.31,0.00,'2021-12-12 07:46:59','',''),(2253464,'1','197','1018',464,'Retail Sale Id 1321499',5001.92,0.00,0.00,0.00,438.48,'2021-12-12 07:52:08','',''),(2253465,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-12 07:52:08','',''),(2253480,'1','197','1018',464,'Retail Sale Id 1321508',3098.48,0.00,0.00,0.00,271.62,'2021-12-12 07:52:57','',''),(2253481,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-12 07:52:57','',''),(2253995,'1','197','1018',464,'Retail Sale Id 1321758',31164.00,0.00,0.00,0.00,1378.00,'2021-12-12 08:25:37','',''),(2253996,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-12 08:25:37','',''),(2254292,'1','197','1018',464,'Retail Sale Id 1321906',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 08:44:23','',''),(2254293,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 08:44:23','',''),(2254789,'1','197','1018',464,'Retail Sale Id 1322150',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 09:11:54','',''),(2254790,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:11:54','',''),(2255040,'1','197','1018',464,'Retail Sale Id 1322281',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 09:26:57','',''),(2255041,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:26:57','',''),(2255143,'1','197','1018',464,'Retail Sale Id 1322323',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 09:32:30','',''),(2255144,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 09:32:30','',''),(2255297,'1','197','1018',464,'Retail Sale Id 1322406',29400.00,0.00,0.00,0.00,1300.00,'2021-12-12 09:43:03','',''),(2255298,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 09:43:03','',''),(2255595,'1','197','1018',464,'Retail Sale Id 1322540',29400.00,0.00,0.00,0.00,1300.00,'2021-12-12 09:56:52','',''),(2255596,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 09:56:52','',''),(2255612,'1','197','1018',464,'Retail Sale Id 1322546',997.92,0.00,0.00,0.00,87.48,'2021-12-12 09:57:32','',''),(2255613,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-12 09:57:32','',''),(2255672,'1','197','1018',464,'Retail Sale Id 1322573',4502.96,0.00,0.00,0.00,394.74,'2021-12-12 10:00:25','',''),(2255673,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,7.31,0.00,'2021-12-12 10:00:25','',''),(2255813,'1','197','1018',464,'Retail Sale Id 1322641',11402.16,0.00,0.00,0.00,999.54,'2021-12-12 10:06:24','',''),(2255814,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,18.51,0.00,'2021-12-12 10:06:24','',''),(2255845,'1','197','1018',464,'Retail Sale Id 1322660',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 10:08:04','',''),(2255847,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:08:04','',''),(2256008,'1','197','1018',464,'Retail Sale Id 1322737',9597.28,0.00,0.00,0.00,841.32,'2021-12-12 10:16:15','',''),(2256009,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.58,0.00,'2021-12-12 10:16:15','',''),(2256383,'1','197','1018',464,'Retail Sale Id 1322947',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 10:37:04','',''),(2256384,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:37:04','',''),(2256421,'1','197','1018',464,'Retail Sale Id 1322963',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 10:39:00','',''),(2256422,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 10:39:00','',''),(2256576,'1','197','1018',464,'Retail Sale Id 1323036',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 10:46:04','',''),(2256577,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:46:04','',''),(2256788,'1','197','1018',464,'Retail Sale Id 1323142',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 10:56:18','',''),(2256789,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:56:18','',''),(2256889,'1','197','1018',464,'Retail Sale Id 1323192',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 11:00:12','',''),(2256890,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:00:12','',''),(2257688,'1','197','1018',464,'Retail Sale Id 1323608',39984.00,0.00,0.00,0.00,1768.00,'2021-12-12 11:34:28','',''),(2257689,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,68.00,0.00,'2021-12-12 11:34:28','',''),(2257713,'1','197','1018',464,'Retail Sale Id 1323619',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 11:35:30','',''),(2257714,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 11:35:30','',''),(2258003,'1','197','1018',464,'Retail Sale Id 1323758',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 11:49:24','',''),(2258004,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:49:24','',''),(2258090,'1','197','1018',464,'Retail Sale Id 1323799',997.92,0.00,0.00,0.00,87.48,'2021-12-12 11:52:50','',''),(2258091,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-12 11:52:50','',''),(2258560,'1','197','1018',464,'Retail Sale Id 1324023',14001.68,0.00,0.00,0.00,1227.42,'2021-12-12 12:17:34','',''),(2258561,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,22.73,0.00,'2021-12-12 12:17:34','',''),(2258686,'1','197','1018',464,'Retail Sale Id 1324087',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 12:24:17','',''),(2258687,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:24:17','',''),(2259000,'1','197','1018',464,'Retail Sale Id 1324233',1897.28,0.00,0.00,0.00,166.32,'2021-12-12 12:37:09','',''),(2259001,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-12 12:37:09','',''),(2259709,'1','197','1018',464,'Retail Sale Id 1324583',2002.00,0.00,0.00,0.00,175.50,'2021-12-12 13:13:37','',''),(2259710,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-12 13:13:37','',''),(2260181,'1','197','1018',464,'Retail Sale Id 1324782',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 13:35:13','',''),(2260182,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:35:13','',''),(2260977,'1','197','1018',464,'Retail Sale Id 1325104',41160.00,0.00,0.00,0.00,1820.00,'2021-12-12 14:11:20','',''),(2260978,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-12 14:11:20','',''),(2261112,'1','197','1018',464,'Retail Sale Id 1325166',2500.96,0.00,0.00,0.00,219.24,'2021-12-12 14:19:10','',''),(2261113,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-12 14:19:10','',''),(2261229,'1','197','1018',464,'Retail Sale Id 1325212',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 14:25:03','',''),(2261230,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 14:25:03','',''),(2261622,'1','197','1018',464,'Retail Sale Id 1325368',1503.04,0.00,0.00,0.00,131.76,'2021-12-12 14:45:08','',''),(2261623,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-12 14:45:08','',''),(2262666,'1','197','1018',464,'Retail Sale Id 1325827',2002.00,0.00,0.00,0.00,175.50,'2021-12-12 15:41:05','',''),(2262667,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-12 15:41:05','',''),(2262692,'1','197','1018',464,'Retail Sale Id 1325840',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 15:42:27','',''),(2262693,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:42:27','',''),(2262973,'1','197','1018',464,'Retail Sale Id 1325965',1897.28,0.00,0.00,0.00,166.32,'2021-12-12 16:00:24','',''),(2262974,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-12 16:00:24','',''),(2263468,'1','197','1018',464,'Retail Sale Id 1326199',80850.00,0.00,0.00,0.00,3575.00,'2021-12-12 16:31:36','',''),(2263469,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,137.50,0.00,'2021-12-12 16:31:36','',''),(2263528,'1','197','1018',464,'Retail Sale Id 1326230',50314.88,0.00,0.00,0.00,4410.72,'2021-12-12 16:34:57','',''),(2263529,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,81.68,0.00,'2021-12-12 16:34:57','',''),(2263598,'1','197','1018',464,'Retail Sale Id 1326262',3702.16,0.00,0.00,0.00,324.54,'2021-12-12 16:39:11','',''),(2263599,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-12 16:39:11','',''),(2263612,'1','197','1018',464,'Retail Sale Id 1326272',9702.00,0.00,0.00,0.00,850.50,'2021-12-12 16:40:43','',''),(2263613,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.75,0.00,'2021-12-12 16:40:43','',''),(2263745,'1','197','1018',464,'Retail Sale Id 1326326',1897.28,0.00,0.00,0.00,166.32,'2021-12-12 16:47:59','',''),(2263746,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-12 16:47:59','',''),(2263801,'1','197','1018',464,'Retail Sale Id 1326351',3098.48,0.00,0.00,0.00,271.62,'2021-12-12 16:50:21','',''),(2263802,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-12 16:50:21','',''),(2263913,'1','197','1018',464,'Retail Sale Id 1326407',2698.08,0.00,0.00,0.00,236.52,'2021-12-12 16:57:39','',''),(2263914,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.38,0.00,'2021-12-12 16:57:39','',''),(2264101,'1','197','1018',464,'Retail Sale Id 1326487',997.92,0.00,0.00,0.00,87.48,'2021-12-12 17:10:44','',''),(2264102,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-12 17:10:44','',''),(2264218,'1','197','1018',464,'Retail Sale Id 1326536',1897.28,0.00,0.00,0.00,166.32,'2021-12-12 17:24:00','',''),(2264219,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-12 17:24:00','',''),(2264220,'1','197','1018',464,'Retail Sale Id 1326539',2002.00,0.00,0.00,0.00,175.50,'2021-12-12 17:24:35','',''),(2264221,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-12 17:24:35','',''),(2264341,'1','197','1018',464,'Retail Sale Id 1326592',19110.00,0.00,0.00,0.00,845.00,'2021-12-12 17:39:33','',''),(2264342,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,32.50,0.00,'2021-12-12 17:39:33','',''),(2264379,'1','197','1018',464,'Retail Sale Id 1326610',14700.00,0.00,0.00,0.00,650.00,'2021-12-12 17:44:17','',''),(2264380,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-12 17:44:17','',''),(2264446,'1','197','1018',464,'Retail Sale Id 1326641',7700.00,0.00,0.00,0.00,675.00,'2021-12-12 17:52:49','',''),(2264447,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 17:52:49','',''),(2264469,'1','197','1018',464,'Retail Sale Id 1326645',4928.00,0.00,0.00,0.00,432.00,'2021-12-12 17:59:35','',''),(2264470,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 17:59:35','',''),(2264602,'1','197','1018',464,'Retail Sale Id 1326702',7350.00,0.00,0.00,0.00,325.00,'2021-12-12 18:33:32','',''),(2264603,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 18:33:32','',''),(2264611,'1','197','1018',464,'Retail Sale Id 1326708',9320.08,0.00,0.00,0.00,817.02,'2021-12-12 18:37:15','',''),(2264612,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.13,0.00,'2021-12-12 18:37:15','',''),(2266001,'1','197','1018',464,'Retail Sale Id 1327132',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 07:14:06','',''),(2266002,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:14:06','',''),(2266005,'1','197','1018',464,'Retail Sale Id 1327134',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 07:14:44','',''),(2266006,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 07:14:44','',''),(2266291,'1','197','1018',464,'Retail Sale Id 1327268',1897.28,0.00,0.00,0.00,166.32,'2021-12-13 07:33:10','',''),(2266292,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-13 07:33:10','',''),(2266496,'1','197','1018',464,'Retail Sale Id 1327372',10798.48,0.00,0.00,0.00,946.62,'2021-12-13 07:45:28','',''),(2266497,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,17.53,0.00,'2021-12-13 07:45:28','',''),(2266676,'1','197','1018',464,'Retail Sale Id 1327459',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 07:55:58','',''),(2266677,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:55:58','',''),(2266765,'1','197','1018',464,'Retail Sale Id 1327497',9597.28,0.00,0.00,0.00,841.32,'2021-12-13 08:00:32','',''),(2266766,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.58,0.00,'2021-12-13 08:00:32','',''),(2267330,'1','197','1018',464,'Retail Sale Id 1327708',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 08:26:24','',''),(2267331,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:26:24','',''),(2267680,'1','197','1018',464,'Retail Sale Id 1327878',17640.00,0.00,0.00,0.00,780.00,'2021-12-13 08:43:38','',''),(2267681,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-13 08:43:38','',''),(2267882,'1','197','1018',464,'Retail Sale Id 1327937',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 08:53:49','',''),(2267883,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 08:53:49','',''),(2268576,'1','197','1018',464,'Retail Sale Id 1328265',3800.72,0.00,0.00,0.00,333.18,'2021-12-13 09:33:58','',''),(2268577,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-13 09:33:58','',''),(2270957,'1','197','1018',464,'Retail Sale Id 1329457',54096.00,0.00,0.00,0.00,2392.00,'2021-12-13 12:23:07','',''),(2270958,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,92.00,0.00,'2021-12-13 12:23:07','',''),(2271138,'1','197','1018',464,'Retail Sale Id 1329565',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 12:37:27','',''),(2271139,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:37:27','',''),(2271150,'1','197','1018',464,'Retail Sale Id 1329574',3800.72,0.00,0.00,0.00,333.18,'2021-12-13 12:38:17','',''),(2271151,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.17,0.00,'2021-12-13 12:38:17','',''),(2271501,'1','197','1018',464,'Retail Sale Id 1329751',59682.00,0.00,0.00,0.00,2639.00,'2021-12-13 13:00:01','',''),(2271502,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,101.50,0.00,'2021-12-13 13:00:01','',''),(2271539,'1','197','1018',464,'Retail Sale Id 1329764',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 13:00:55','',''),(2271540,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 13:00:55','',''),(2271557,'1','197','1018',464,'Retail Sale Id 1329774',3597.44,0.00,0.00,0.00,315.36,'2021-12-13 13:02:34','',''),(2271558,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.84,0.00,'2021-12-13 13:02:34','',''),(2272236,'1','197','1018',464,'Retail Sale Id 1330054',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 13:41:58','',''),(2272237,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 13:41:58','',''),(2273018,'1','197','1018',464,'Retail Sale Id 1330475',3098.48,0.00,0.00,0.00,271.62,'2021-12-13 14:27:39','',''),(2273019,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-13 14:27:39','',''),(2274437,'1','197','1018',464,'Retail Sale Id 1331142',5001.92,0.00,0.00,0.00,438.48,'2021-12-13 15:43:40','',''),(2274438,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-13 15:43:40','',''),(2274457,'1','197','1018',464,'Retail Sale Id 1331151',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 15:44:36','',''),(2274458,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 15:44:36','',''),(2274539,'1','197','1018',464,'Retail Sale Id 1331189',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 15:48:39','',''),(2274540,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:48:39','',''),(2274562,'1','197','1018',464,'Retail Sale Id 1331207',997.92,0.00,0.00,0.00,87.48,'2021-12-13 15:50:06','',''),(2274563,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-13 15:50:06','',''),(2274785,'1','197','1018',464,'Retail Sale Id 1331327',1503.04,0.00,0.00,0.00,131.76,'2021-12-13 16:02:33','',''),(2274786,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-13 16:02:33','',''),(2274873,'1','197','1018',464,'Retail Sale Id 1331369',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 16:07:27','',''),(2274874,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:07:28','',''),(2274891,'1','197','1018',464,'Retail Sale Id 1331379',2002.00,0.00,0.00,0.00,175.50,'2021-12-13 16:08:39','',''),(2274892,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-13 16:08:39','',''),(2274907,'1','197','1018',464,'Retail Sale Id 1331386',3098.48,0.00,0.00,0.00,271.62,'2021-12-13 16:09:34','',''),(2274908,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-13 16:09:34','',''),(2274961,'1','197','1018',464,'Retail Sale Id 1331412',13896.96,0.00,0.00,0.00,1218.24,'2021-12-13 16:12:02','',''),(2274962,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,22.56,0.00,'2021-12-13 16:12:02','',''),(2274986,'1','197','1018',464,'Retail Sale Id 1331423',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 16:13:32','',''),(2274987,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:13:32','',''),(2275026,'1','197','1018',464,'Retail Sale Id 1331445',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 16:15:29','',''),(2275027,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:15:29','',''),(2275028,'1','197','1018',464,'Retail Sale Id 1331445',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 16:15:29','',''),(2275029,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:15:29','',''),(2275048,'1','197','1018',464,'Retail Sale Id 1331455',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 16:16:33','',''),(2275049,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:16:33','',''),(2275173,'1','197','1018',464,'Retail Sale Id 1331513',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 16:22:35','',''),(2275174,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:22:35','',''),(2275200,'1','197','1018',464,'Retail Sale Id 1331530',2999.92,0.00,0.00,0.00,262.98,'2021-12-13 16:23:52','',''),(2275201,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-13 16:23:52','',''),(2275229,'1','197','1018',464,'Retail Sale Id 1331545',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 16:25:38','',''),(2275230,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:25:38','',''),(2275348,'1','197','1018',464,'Retail Sale Id 1331606',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 16:32:22','',''),(2275349,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:32:22','',''),(2275413,'1','197','1018',464,'Retail Sale Id 1331636',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 16:35:59','',''),(2275414,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:35:59','',''),(2275470,'1','197','1018',464,'Retail Sale Id 1331671',6702.08,0.00,0.00,0.00,587.52,'2021-12-13 16:39:37','',''),(2275471,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.88,0.00,'2021-12-13 16:39:37','',''),(2275550,'1','197','1018',464,'Retail Sale Id 1331715',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 16:43:57','',''),(2275551,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 16:43:57','',''),(2275611,'1','197','1018',464,'Retail Sale Id 1331749',6196.96,0.00,0.00,0.00,543.24,'2021-12-13 16:49:38','',''),(2275612,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,10.06,0.00,'2021-12-13 16:49:38','',''),(2275625,'1','197','1018',464,'Retail Sale Id 1331757',5001.92,0.00,0.00,0.00,438.48,'2021-12-13 16:50:29','',''),(2275626,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-13 16:50:29','',''),(2275678,'1','197','1018',464,'Retail Sale Id 1331781',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 16:53:44','',''),(2275679,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 16:53:44','',''),(2276002,'1','197','1018',464,'Retail Sale Id 1331938',59136.00,0.00,0.00,0.00,5184.00,'2021-12-13 17:22:52','',''),(2276003,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,96.00,0.00,'2021-12-13 17:22:52','',''),(2276050,'1','197','1018',464,'Retail Sale Id 1331966',997.92,0.00,0.00,0.00,87.48,'2021-12-13 17:28:27','',''),(2276051,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-13 17:28:27','',''),(2276102,'1','197','1018',464,'Retail Sale Id 1331995',3098.48,0.00,0.00,0.00,271.62,'2021-12-13 17:35:19','',''),(2276103,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.03,0.00,'2021-12-13 17:35:19','',''),(2276149,'1','197','1018',464,'Retail Sale Id 1332014',3702.16,0.00,0.00,0.00,324.54,'2021-12-13 17:39:41','',''),(2276150,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-13 17:39:41','',''),(2276151,'1','197','1018',464,'Retail Sale Id 1332014',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 17:39:41','',''),(2276152,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 17:39:41','',''),(2276163,'1','197','1018',464,'Retail Sale Id 1332027',1897.28,0.00,0.00,0.00,166.32,'2021-12-13 17:42:15','',''),(2276164,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-13 17:42:15','',''),(2276176,'1','197','1018',464,'Retail Sale Id 1332033',7700.00,0.00,0.00,0.00,675.00,'2021-12-13 17:50:02','',''),(2276177,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 17:50:02','',''),(2276178,'1','197','1018',464,'Retail Sale Id 1332033',15400.00,0.00,0.00,0.00,1350.00,'2021-12-13 17:50:02','',''),(2276179,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 17:50:02','',''),(2276263,'1','197','1018',464,'Retail Sale Id 1332040',1897.28,0.00,0.00,0.00,166.32,'2021-12-13 18:00:29','',''),(2276264,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.08,0.00,'2021-12-13 18:00:29','',''),(2276418,'1','197','1018',464,'Retail Sale Id 1332068',11513.04,0.00,0.00,0.00,1009.26,'2021-12-13 18:31:40','',''),(2276419,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,18.69,0.00,'2021-12-13 18:31:40','',''),(2276437,'1','197','1018',464,'Retail Sale Id 1332073',58800.00,0.00,0.00,0.00,2600.00,'2021-12-13 18:40:52','',''),(2276438,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 18:40:52','',''),(2276439,'1','197','1018',464,'Retail Sale Id 1332074',58800.00,0.00,0.00,0.00,2600.00,'2021-12-13 18:41:56','',''),(2276440,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 18:41:56','',''),(2276441,'1','197','1018',464,'Retail Sale Id 1332075',43047.48,0.00,0.00,0.00,1903.46,'2021-12-13 18:43:28','',''),(2276442,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,73.21,0.00,'2021-12-13 18:43:28','',''),(2276443,'1','197','1018',464,'Retail Sale Id 1332076',58800.00,0.00,0.00,0.00,2600.00,'2021-12-13 18:44:35','',''),(2276444,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 18:44:35','',''),(2278854,'1','197','1018',464,'Retail Sale Id 1333120',6997.76,0.00,0.00,0.00,613.44,'2021-12-14 08:06:31','',''),(2278855,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,11.36,0.00,'2021-12-14 08:06:31','',''),(2279357,'1','197','1018',464,'Retail Sale Id 1333399',3498.88,0.00,0.00,0.00,306.72,'2021-12-14 08:34:42','',''),(2279358,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,5.68,0.00,'2021-12-14 08:34:42','',''),(2279930,'1','197','1018',464,'Retail Sale Id 1333664',1503.04,0.00,0.00,0.00,131.76,'2021-12-14 09:02:57','',''),(2279931,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 09:02:57','',''),(2279932,'1','197','1018',464,'Retail Sale Id 1333664',2002.00,0.00,0.00,0.00,175.50,'2021-12-14 09:02:57','',''),(2279933,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 09:02:57','',''),(2279934,'1','197','1018',464,'Retail Sale Id 1333664',7700.00,0.00,0.00,0.00,675.00,'2021-12-14 09:02:57','',''),(2279935,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:02:57','',''),(2279953,'1','197','1018',464,'Retail Sale Id 1333668',1503.04,0.00,0.00,0.00,131.76,'2021-12-14 09:03:31','',''),(2279954,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-14 09:03:31','',''),(2280015,'1','197','1018',464,'Retail Sale Id 1333707',9240.00,0.00,0.00,0.00,810.00,'2021-12-14 09:06:07','',''),(2280016,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-14 09:06:07','',''),(2280139,'1','197','1018',464,'Retail Sale Id 1333748',133756.00,0.00,0.00,0.00,0.00,'2021-12-14 09:10:47','',''),(2280140,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,238.00,0.00,'2021-12-14 09:10:47','',''),(2280301,'1','197','1018',464,'Retail Sale Id 1333820',3702.16,0.00,0.00,0.00,324.54,'2021-12-14 09:18:57','',''),(2280302,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 09:18:57','',''),(2280628,'1','197','1018',464,'Retail Sale Id 1333972',997.92,0.00,0.00,0.00,87.48,'2021-12-14 09:35:32','',''),(2280629,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 09:35:32','',''),(2280662,'1','197','1018',464,'Retail Sale Id 1333994',3702.16,0.00,0.00,0.00,324.54,'2021-12-14 09:38:26','',''),(2280663,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 09:38:26','',''),(2280814,'1','197','1018',464,'Retail Sale Id 1334059',4502.96,0.00,0.00,0.00,394.74,'2021-12-14 09:46:12','',''),(2280815,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,7.31,0.00,'2021-12-14 09:46:12','',''),(2280935,'1','197','1018',464,'Retail Sale Id 1334128',7700.00,0.00,0.00,0.00,675.00,'2021-12-14 09:54:36','',''),(2280936,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:54:36','',''),(2281061,'1','197','1018',464,'Retail Sale Id 1334192',16101.30,0.00,0.00,0.00,0.00,'2021-12-14 10:01:55','',''),(2281062,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,28.65,0.00,'2021-12-14 10:01:55','',''),(2281690,'1','197','1018',464,'Retail Sale Id 1334556',7700.00,0.00,0.00,0.00,675.00,'2021-12-14 10:34:22','',''),(2281691,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:34:22','',''),(2281842,'1','197','1018',464,'Retail Sale Id 1334641',53952.00,0.00,0.00,0.00,0.00,'2021-12-14 10:42:37','',''),(2281843,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,96.00,0.00,'2021-12-14 10:42:37','',''),(2282212,'1','197','1018',464,'Retail Sale Id 1334834',3702.16,0.00,0.00,0.00,324.54,'2021-12-14 11:04:48','',''),(2282213,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 11:04:48','',''),(2282273,'1','197','1018',464,'Retail Sale Id 1334873',3702.16,0.00,0.00,0.00,324.54,'2021-12-14 11:08:53','',''),(2282274,'1','197','1018',464,'Retail sales',0.00,0.00,0.00,6.01,0.00,'2021-12-14 11:08:53','',''),(2282728,'1','197','1018',464,'Retail Sale Id 1335572',3702.16,0.00,0.00,6.01,312.52,'2021-12-14 12:58:26','',''),(2282736,'1','197','1018',464,'Retail Sale Id 1335581',7700.00,0.00,0.00,12.50,650.00,'2021-12-14 12:59:57','',''),(2282939,'1','197','1018',464,'Retail Sale Id 1335769',7700.00,0.00,0.00,12.50,650.00,'2021-12-14 13:26:21','',''),(2284434,'1','197','1018',464,'Retail Sale Id 1336826',3609.76,0.00,0.00,5.86,304.72,'2021-12-14 16:04:49','',''),(2284641,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,229541189700.00,406987925.00,0.00,0.00,'2021-12-14 16:26:21','',''),(2284664,'1','197',NULL,464,'Reception corrector for bridging 127377',0.00,0.00,0.00,406.98,0.00,'2021-12-14 16:28:12','',''),(2284665,'1','197','1018',464,'Received from bridging 127377',0.00,0.00,406.98,0.00,0.00,'2021-12-14 16:28:12','',''),(2284721,'1','197','1018',464,'Retail Sale Id 1337085',229536.72,0.00,0.00,406.98,0.00,'2021-12-14 16:31:52','',''),(2285153,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,229536.72,406.98,0.00,0.00,'2021-12-14 17:17:38','',''),(2285169,'1','197',NULL,464,'Reception corrector for bridging 127388',0.00,0.00,0.00,406.98,0.00,'2021-12-14 17:18:53','',''),(2285170,'1','197','1018',464,'Received from bridging 127388',0.00,0.00,406.98,0.00,0.00,'2021-12-14 17:18:53','',''),(2285179,'1','197','1018',464,'Returned bridging 127377',0.00,0.00,0.00,406.98,0.00,'2021-12-14 17:20:41','',''),(2285180,'1','197',NULL,464,'Reception Return corrector for bridging 127377',0.00,0.00,406.98,0.00,0.00,'2021-12-14 17:20:41','',''),(2285182,'1','197',NULL,464,'Returned purchase #87184 to AA RANO NIGERIA LIMITED',229541189700.00,0.00,0.00,406987925.00,0.00,'2021-12-14 17:21:01','',''),(2285363,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2767400.00,5050.00,0.00,0.00,'2021-12-14 19:13:49','',''),(2285424,'1','197',NULL,464,'Reception corrector for bridging 127409',0.00,0.00,0.00,5050.00,0.00,'2021-12-14 20:21:47','',''),(2285425,'1','197','1018',464,'Received from bridging 127409',0.00,0.00,5050.00,0.00,0.00,'2021-12-14 20:21:47','',''),(2285427,'1','197','1018',464,'Retail Sale Id 1337616',115610.88,0.00,0.00,187.68,12762.24,'2021-12-14 20:24:33','',''),(2285428,'1','197','1018',464,'Retail Sale Id 1337617',82908.00,0.00,0.00,147.00,2352.00,'2021-12-14 20:25:14','',''),(2286452,'1','197','1018',464,'Retail Sale Id 1338116',2002.00,0.00,0.00,3.25,221.00,'2021-12-15 07:16:11','',''),(2286499,'1','197','1018',464,'Retail Sale Id 1338170',3702.16,0.00,0.00,6.01,408.68,'2021-12-15 07:22:33','',''),(2287745,'1','197','1018',464,'Retail Sale Id 1339148',95316.00,0.00,0.00,169.00,2704.00,'2021-12-15 09:27:26','',''),(2287759,'1','197','1018',464,'Retail Sale Id 1339174',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 09:28:58','',''),(2288402,'1','197','1018',464,'Retail Sale Id 1339710',1201.20,0.00,0.00,1.95,132.60,'2021-12-15 10:51:10','',''),(2288403,'1','197','1018',464,'Retail Sale Id 1339710',1201.20,0.00,0.00,1.95,132.60,'2021-12-15 10:51:10','',''),(2288416,'1','197','1018',464,'Retail Sale Id 1339720',2002.00,0.00,0.00,3.25,221.00,'2021-12-15 10:51:56','',''),(2288688,'1','197','1018',464,'Retail Sale Id 1339965',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 11:22:19','',''),(2289069,'1','197','1018',464,'Retail Sale Id 1340323',15400.00,0.00,0.00,25.00,1700.00,'2021-12-15 12:12:00','',''),(2289141,'1','197','1018',464,'Retail Sale Id 1340400',1503.04,0.00,0.00,2.44,165.92,'2021-12-15 12:22:20','',''),(2289202,'1','197','1018',464,'Retail Sale Id 1340461',11280.00,0.00,0.00,20.00,320.00,'2021-12-15 12:31:41','',''),(2289332,'1','197','1018',464,'Retail Sale Id 1340584',1897.28,0.00,0.00,3.08,209.44,'2021-12-15 12:49:28','',''),(2289489,'1','197','1018',464,'Retail Sale Id 1340709',2999.92,0.00,0.00,4.87,331.16,'2021-12-15 13:13:22','',''),(2289565,'1','197','1018',464,'Retail Sale Id 1340749',15400.00,0.00,0.00,25.00,1700.00,'2021-12-15 13:18:36','',''),(2289639,'1','197','1018',464,'Retail Sale Id 1340816',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 13:27:59','',''),(2290324,'1','197','1018',464,'Retail Sale Id 1341284',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 14:30:14','',''),(2290373,'1','197','1018',464,'Retail Sale Id 1341328',11402.16,0.00,0.00,18.51,1258.68,'2021-12-15 14:35:47','',''),(2290385,'1','197','1018',464,'Retail Sale Id 1341339',3800.72,0.00,0.00,6.17,419.56,'2021-12-15 14:36:53','',''),(2290404,'1','197','1018',464,'Retail Sale Id 1341355',3702.16,0.00,0.00,6.01,408.68,'2021-12-15 14:39:23','',''),(2290498,'1','197','1018',464,'Retail Sale Id 1341426',3098.48,0.00,0.00,5.03,342.04,'2021-12-15 14:48:39','',''),(2290622,'1','197','1018',464,'Retail Sale Id 1341525',1299.76,0.00,0.00,2.11,143.48,'2021-12-15 14:59:18','',''),(2290712,'1','197','1018',464,'Retail Sale Id 1341589',3702.16,0.00,0.00,6.01,408.68,'2021-12-15 15:06:22','',''),(2291045,'1','197','1018',464,'Retail Sale Id 1341794',84600.00,0.00,0.00,150.00,2400.00,'2021-12-15 15:29:27','',''),(2291102,'1','197','1018',464,'Retail Sale Id 1341843',2999.92,0.00,0.00,4.87,331.16,'2021-12-15 15:34:33','',''),(2291198,'1','197','1018',464,'Retail Sale Id 1341928',30584.40,0.00,0.00,49.65,3376.20,'2021-12-15 15:43:42','',''),(2291206,'1','197','1018',464,'Retail Sale Id 1341937',15400.00,0.00,0.00,25.00,1700.00,'2021-12-15 15:44:32','',''),(2291304,'1','197','1018',464,'Retail Sale Id 1342027',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 15:53:52','',''),(2291319,'1','197','1018',464,'Retail Sale Id 1342035',6498.80,0.00,0.00,10.55,717.40,'2021-12-15 15:54:56','',''),(2291351,'1','197','1018',464,'Retail Sale Id 1342061',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 15:56:47','',''),(2291385,'1','197','1018',464,'Retail Sale Id 1342083',1897.28,0.00,0.00,3.08,209.44,'2021-12-15 15:58:26','',''),(2291432,'1','197','1018',464,'Retail Sale Id 1342126',3098.48,0.00,0.00,5.03,342.04,'2021-12-15 16:03:45','',''),(2291472,'1','197','1018',464,'Retail Sale Id 1342173',3702.16,0.00,0.00,6.01,408.68,'2021-12-15 16:07:50','',''),(2291564,'1','197','1018',464,'Retail Sale Id 1342251',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 16:16:39','',''),(2291723,'1','197','1018',464,'Retail Sale Id 1342408',1897.28,0.00,0.00,3.08,209.44,'2021-12-15 16:30:59','',''),(2291740,'1','197','1018',464,'Retail Sale Id 1342424',11402.16,0.00,0.00,18.51,1258.68,'2021-12-15 16:32:52','',''),(2291749,'1','197','1018',464,'Retail Sale Id 1342432',6196.96,0.00,0.00,10.06,684.08,'2021-12-15 16:33:36','',''),(2291772,'1','197','1018',464,'Retail Sale Id 1342454',2002.00,0.00,0.00,3.25,221.00,'2021-12-15 16:35:35','',''),(2291808,'1','197','1018',464,'Retail Sale Id 1342480',33276.00,0.00,0.00,59.00,944.00,'2021-12-15 16:38:30','',''),(2292130,'1','197','1018',464,'Retail Sale Id 1342761',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 17:08:54','',''),(2292159,'1','197','1018',464,'Retail Sale Id 1342790',3098.48,0.00,0.00,5.03,342.04,'2021-12-15 17:13:16','',''),(2292171,'1','197','1018',464,'Retail Sale Id 1342801',3098.48,0.00,0.00,5.03,342.04,'2021-12-15 17:14:27','',''),(2292574,'1','197','1018',464,'Retail Sale Id 1343098',28341.00,0.00,0.00,50.25,804.00,'2021-12-15 18:23:06','',''),(2292575,'1','197','1018',464,'Retail Sale Id 1343099',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 18:23:56','',''),(2292586,'1','197','1018',464,'Retail Sale Id 1343103',1349.04,0.00,0.00,2.19,148.92,'2021-12-15 18:24:48','',''),(2292587,'1','197','1018',464,'Retail Sale Id 1343104',7700.00,0.00,0.00,12.50,850.00,'2021-12-15 18:25:12','',''),(2292589,'1','197','1018',464,'Retail Sale Id 1343107',4299.68,0.00,0.00,6.98,474.64,'2021-12-15 18:25:35','',''),(2294462,'1','197','1018',464,'Retail Sale Id 1344274',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 08:13:57','',''),(2294703,'1','197','1018',464,'Retail Sale Id 1344461',11402.16,0.00,0.00,18.51,1258.68,'2021-12-16 08:32:15','',''),(2295055,'1','197','1018',464,'Retail Sale Id 1344706',3702.16,0.00,0.00,6.01,408.68,'2021-12-16 08:59:03','',''),(2295144,'1','197','1018',464,'Retail Sale Id 1344785',6196.96,0.00,0.00,10.06,684.08,'2021-12-16 09:06:49','',''),(2295199,'1','197','1018',464,'Retail Sale Id 1344833',1897.28,0.00,0.00,3.08,209.44,'2021-12-16 09:11:10','',''),(2295371,'1','197','1018',464,'Retail Sale Id 1344989',57860.76,0.00,0.00,102.59,1641.44,'2021-12-16 09:27:57','',''),(2295403,'1','197','1018',464,'Retail Sale Id 1345017',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 09:30:45','',''),(2295669,'1','197','1018',464,'Retail Sale Id 1345231',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 09:54:26','',''),(2295771,'1','197','1018',464,'Retail Sale Id 1345280',3384.00,0.00,0.00,6.00,96.00,'2021-12-16 10:01:46','',''),(2295906,'1','197','1018',464,'Retail Sale Id 1345378',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 10:13:01','',''),(2295911,'1','197','1018',464,'Retail Sale Id 1345383',3702.16,0.00,0.00,6.01,408.68,'2021-12-16 10:13:44','',''),(2295995,'1','197','1018',464,'Retail Sale Id 1345475',93624.00,0.00,0.00,166.00,2656.00,'2021-12-16 10:23:35','',''),(2296270,'1','197','1018',464,'Retail Sale Id 1345747',125208.00,0.00,0.00,222.00,3552.00,'2021-12-16 10:56:35','',''),(2296345,'1','197','1018',464,'Retail Sale Id 1345820',56400.00,0.00,0.00,100.00,1600.00,'2021-12-16 11:05:18','',''),(2296439,'1','197','1018',464,'Retail Sale Id 1345900',79524.00,0.00,0.00,141.00,2256.00,'2021-12-16 11:14:42','',''),(2296626,'1','197','1018',464,'Retail Sale Id 1346069',997.92,0.00,0.00,1.62,110.16,'2021-12-16 11:36:54','',''),(2297252,'1','197','1018',464,'Retail Sale Id 1346611',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 12:47:51','',''),(2297524,'1','197','1018',464,'Retail Sale Id 1346855',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 13:21:10','',''),(2297537,'1','197','1018',464,'Retail Sale Id 1346872',1897.28,0.00,0.00,3.08,209.44,'2021-12-16 13:22:23','',''),(2297712,'1','197','1018',464,'Retail Sale Id 1347002',3702.16,0.00,0.00,6.01,408.68,'2021-12-16 13:37:20','',''),(2297713,'1','197','1018',464,'Retail Sale Id 1347002',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 13:37:20','',''),(2297906,'1','197','1018',464,'Retail Sale Id 1347141',29568.00,0.00,0.00,48.00,3264.00,'2021-12-16 13:54:01','',''),(2297907,'1','197','1018',464,'Retail Sale Id 1347141',29568.00,0.00,0.00,48.00,3264.00,'2021-12-16 13:54:01','',''),(2297936,'1','197','1018',464,'Retail Sale Id 1347181',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 13:57:37','',''),(2298131,'1','197','1018',464,'Retail Sale Id 1347322',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 14:14:23','',''),(2298141,'1','197','1018',464,'Retail Sale Id 1347331',3702.16,0.00,0.00,6.01,408.68,'2021-12-16 14:15:49','',''),(2298352,'1','197','1018',464,'Retail Sale Id 1347539',9240.00,0.00,0.00,15.00,1020.00,'2021-12-16 14:39:44','',''),(2298637,'1','197','1018',464,'Retail Sale Id 1347694',83054.64,0.00,0.00,147.26,2356.16,'2021-12-16 14:58:06','',''),(2298714,'1','197','1018',464,'Retail Sale Id 1347770',64296.00,0.00,0.00,114.00,1824.00,'2021-12-16 15:08:57','',''),(2299200,'1','197','1018',464,'Retail Sale Id 1348126',3098.48,0.00,0.00,5.03,342.04,'2021-12-16 15:44:28','',''),(2299264,'1','197','1018',464,'Retail Sale Id 1348172',2002.00,0.00,0.00,3.25,221.00,'2021-12-16 15:49:20','',''),(2299500,'1','197','1018',464,'Retail Sale Id 1348350',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:05:31','',''),(2299564,'1','197','1018',464,'Retail Sale Id 1348392',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:09:07','',''),(2299682,'1','197','1018',464,'Retail Sale Id 1348448',1299.76,0.00,0.00,2.11,143.48,'2021-12-16 16:13:45','',''),(2299683,'1','197','1018',464,'Retail Sale Id 1348448',3702.16,0.00,0.00,6.01,408.68,'2021-12-16 16:13:45','',''),(2299756,'1','197','1018',464,'Retail Sale Id 1348517',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:20:40','',''),(2299889,'1','197','1018',464,'Retail Sale Id 1348646',616.00,0.00,0.00,1.00,68.00,'2021-12-16 16:31:56','',''),(2299909,'1','197','1018',464,'Retail Sale Id 1348662',616.00,0.00,0.00,1.00,68.00,'2021-12-16 16:33:34','',''),(2299928,'1','197','1018',464,'Retail Sale Id 1348679',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:35:22','',''),(2299998,'1','197','1018',464,'Retail Sale Id 1348753',1897.28,0.00,0.00,3.08,209.44,'2021-12-16 16:43:44','',''),(2300044,'1','197','1018',464,'Retail Sale Id 1348796',3098.48,0.00,0.00,5.03,342.04,'2021-12-16 16:47:38','',''),(2300065,'1','197','1018',464,'Retail Sale Id 1348810',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:49:15','',''),(2300087,'1','197','1018',464,'Retail Sale Id 1348840',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:52:20','',''),(2300109,'1','197','1018',464,'Retail Sale Id 1348861',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 16:54:40','',''),(2300170,'1','197','1018',464,'Retail Sale Id 1348900',997.92,0.00,0.00,1.62,110.16,'2021-12-16 17:00:32','',''),(2300171,'1','197','1018',464,'Retail Sale Id 1348900',1503.04,0.00,0.00,2.44,165.92,'2021-12-16 17:00:32','',''),(2300281,'1','197','1018',464,'Retail Sale Id 1348990',5001.92,0.00,0.00,8.12,552.16,'2021-12-16 17:14:51','',''),(2300736,'1','197','1018',464,'Retail Sale Id 1349331',7700.00,0.00,0.00,12.50,850.00,'2021-12-16 18:58:36','',''),(2300739,'1','197','1018',464,'Retail Sale Id 1349333',2531.76,0.00,0.00,4.11,279.48,'2021-12-16 18:59:44','',''),(2302687,'1','197','1018',464,'Retail Sale Id 1350561',2002.00,0.00,0.00,3.25,221.00,'2021-12-17 08:32:28','',''),(2302719,'1','197','1018',464,'Retail Sale Id 1350588',2999.92,0.00,0.00,4.87,331.16,'2021-12-17 08:34:45','',''),(2302973,'1','197','1018',464,'Retail Sale Id 1350754',3702.16,0.00,0.00,6.01,408.68,'2021-12-17 08:54:28','',''),(2302987,'1','197','1018',464,'Retail Sale Id 1350771',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 08:56:36','',''),(2303112,'1','197','1018',464,'Retail Sale Id 1350870',15400.00,0.00,0.00,25.00,1700.00,'2021-12-17 09:07:36','',''),(2303280,'1','197','1018',464,'Retail Sale Id 1350960',2002.00,0.00,0.00,3.25,221.00,'2021-12-17 09:20:41','',''),(2303417,'1','197','1018',464,'Retail Sale Id 1351067',107724.00,0.00,0.00,191.00,3056.00,'2021-12-17 09:32:38','',''),(2303758,'1','197','1018',464,'Retail Sale Id 1351326',69372.00,0.00,0.00,123.00,1968.00,'2021-12-17 10:01:47','',''),(2304551,'1','197','1018',464,'Retail Sale Id 1352092',69654.00,0.00,0.00,123.50,1976.00,'2021-12-17 11:26:08','',''),(2304595,'1','197','1018',464,'Retail Sale Id 1352137',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:30:07','',''),(2304622,'1','197','1018',464,'Retail Sale Id 1352164',6498.80,0.00,0.00,10.55,717.40,'2021-12-17 11:32:50','',''),(2304644,'1','197','1018',464,'Retail Sale Id 1352184',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:35:11','',''),(2304645,'1','197','1018',464,'Retail Sale Id 1352184',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:35:11','',''),(2304646,'1','197','1018',464,'Retail Sale Id 1352184',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:35:11','',''),(2304647,'1','197','1018',464,'Retail Sale Id 1352184',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:35:11','',''),(2304682,'1','197','1018',464,'Retail Sale Id 1352222',3098.48,0.00,0.00,5.03,342.04,'2021-12-17 11:40:05','',''),(2304689,'1','197','1018',464,'Retail Sale Id 1352231',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:41:17','',''),(2304785,'1','197','1018',464,'Retail Sale Id 1352330',3702.16,0.00,0.00,6.01,408.68,'2021-12-17 11:53:09','',''),(2304838,'1','197','1018',464,'Retail Sale Id 1352368',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 11:59:05','',''),(2304885,'1','197','1018',464,'Retail Sale Id 1352403',2500.96,0.00,0.00,4.06,276.08,'2021-12-17 12:04:06','',''),(2304992,'1','197','1018',464,'Retail Sale Id 1352516',62040.00,0.00,0.00,110.00,1760.00,'2021-12-17 12:20:03','',''),(2305373,'1','197','1018',464,'Retail Sale Id 1352885',1299.76,0.00,0.00,2.11,143.48,'2021-12-17 13:18:23','',''),(2305575,'1','197','1018',464,'Retail Sale Id 1353070',5500.88,0.00,0.00,8.93,607.24,'2021-12-17 13:41:59','',''),(2305632,'1','197','1018',464,'Retail Sale Id 1353105',2100.56,0.00,0.00,3.41,231.88,'2021-12-17 13:47:29','',''),(2305640,'1','197','1018',464,'Retail Sale Id 1353112',66834.00,0.00,0.00,118.50,1896.00,'2021-12-17 13:48:25','',''),(2306538,'1','197','1018',464,'Retail Sale Id 1353814',2500.96,0.00,0.00,4.06,276.08,'2021-12-17 15:12:57','',''),(2306794,'1','197','1018',464,'Retail Sale Id 1354003',3098.48,0.00,0.00,5.03,342.04,'2021-12-17 15:31:18','',''),(2306994,'1','197','1018',464,'Retail Sale Id 1354147',5001.92,0.00,0.00,8.12,552.16,'2021-12-17 15:44:37','',''),(2307086,'1','197','1018',464,'Retail Sale Id 1354235',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 15:51:06','',''),(2307164,'1','197','1018',464,'Retail Sale Id 1354320',1897.28,0.00,0.00,3.08,209.44,'2021-12-17 15:58:11','',''),(2307322,'1','197','1018',464,'Retail Sale Id 1354482',3702.16,0.00,0.00,6.01,408.68,'2021-12-17 16:13:14','',''),(2307370,'1','197','1018',464,'Retail Sale Id 1354533',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 16:16:56','',''),(2307438,'1','197','1018',464,'Retail Sale Id 1354605',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 16:22:36','',''),(2307463,'1','197','1018',464,'Retail Sale Id 1354628',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 16:25:00','',''),(2307500,'1','197','1018',464,'Retail Sale Id 1354666',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 16:29:02','',''),(2307568,'1','197','1018',464,'Retail Sale Id 1354737',9252.32,0.00,0.00,15.02,1021.36,'2021-12-17 16:35:23','',''),(2307574,'1','197','1018',464,'Retail Sale Id 1354744',2500.96,0.00,0.00,4.06,276.08,'2021-12-17 16:36:17','',''),(2307633,'1','197','1018',464,'Retail Sale Id 1354803',1897.28,0.00,0.00,3.08,209.44,'2021-12-17 16:42:25','',''),(2307763,'1','197','1018',464,'Retail Sale Id 1354899',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 16:54:04','',''),(2307861,'1','197','1018',464,'Retail Sale Id 1354996',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 17:08:46','',''),(2307938,'1','197','1018',464,'Retail Sale Id 1355052',997.92,0.00,0.00,1.62,110.16,'2021-12-17 17:17:02','',''),(2308107,'1','197','1018',464,'Retail Sale Id 1355169',3702.16,0.00,0.00,6.01,408.68,'2021-12-17 17:40:36','',''),(2308355,'1','197','1018',464,'Retail Sale Id 1355331',28200.00,0.00,0.00,50.00,800.00,'2021-12-17 18:23:40','',''),(2308359,'1','197','1018',464,'Retail Sale Id 1355335',28200.00,0.00,0.00,50.00,800.00,'2021-12-17 18:24:17','',''),(2308363,'1','197','1018',464,'Retail Sale Id 1355338',19582.08,0.00,0.00,34.72,555.52,'2021-12-17 18:25:11','',''),(2308372,'1','197','1018',464,'Retail Sale Id 1355346',15400.00,0.00,0.00,25.00,1700.00,'2021-12-17 18:28:48','',''),(2308376,'1','197','1018',464,'Retail Sale Id 1355350',7700.00,0.00,0.00,12.50,850.00,'2021-12-17 18:29:35','',''),(2308378,'1','197','1018',464,'Retail Sale Id 1355352',2741.20,0.00,0.00,4.45,302.60,'2021-12-17 18:30:23','',''),(2309675,'1','197','1018',464,'Retail Sale Id 1355988',3702.16,0.00,0.00,6.01,408.68,'2021-12-18 07:16:37','',''),(2310290,'1','197','1018',464,'Retail Sale Id 1356478',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 08:07:44','',''),(2310312,'1','197','1018',464,'Retail Sale Id 1356493',5001.92,0.00,0.00,8.12,552.16,'2021-12-18 08:09:15','',''),(2310343,'1','197','1018',464,'Retail Sale Id 1356503',17202.00,0.00,0.00,30.50,488.00,'2021-12-18 08:11:01','',''),(2310473,'1','197','1018',464,'Retail Sale Id 1356620',3800.72,0.00,0.00,6.17,419.56,'2021-12-18 08:23:34','',''),(2310590,'1','197','1018',464,'Retail Sale Id 1356691',30800.00,0.00,0.00,50.00,3400.00,'2021-12-18 08:29:42','',''),(2310700,'1','197','1018',464,'Retail Sale Id 1356798',997.92,0.00,0.00,1.62,110.16,'2021-12-18 08:39:03','',''),(2310722,'1','197','1018',464,'Retail Sale Id 1356818',6997.76,0.00,0.00,11.36,772.48,'2021-12-18 08:40:44','',''),(2310737,'1','197','1018',464,'Retail Sale Id 1356832',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 08:42:14','',''),(2310752,'1','197','1018',464,'Retail Sale Id 1356847',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 08:43:17','',''),(2310874,'1','197','1018',464,'Retail Sale Id 1356967',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 08:54:23','',''),(2311476,'1','197','1018',464,'Retail Sale Id 1357485',1503.04,0.00,0.00,2.44,165.92,'2021-12-18 09:46:13','',''),(2311524,'1','197','1018',464,'Retail Sale Id 1357535',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 09:50:57','',''),(2311731,'1','197','1018',464,'Retail Sale Id 1357693',6997.76,0.00,0.00,11.36,772.48,'2021-12-18 10:07:37','',''),(2311732,'1','197','1018',464,'Retail Sale Id 1357693',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 10:07:37','',''),(2311908,'1','197','1018',464,'Retail Sale Id 1357824',24601.68,0.00,0.00,43.62,697.92,'2021-12-18 10:22:15','',''),(2311934,'1','197','1018',464,'Retail Sale Id 1357840',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 10:23:53','',''),(2311983,'1','197','1018',464,'Retail Sale Id 1357890',2002.00,0.00,0.00,3.25,221.00,'2021-12-18 10:28:32','',''),(2312378,'1','197','1018',464,'Retail Sale Id 1358256',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 11:00:12','',''),(2312429,'1','197','1018',464,'Retail Sale Id 1358297',3702.16,0.00,0.00,6.01,408.68,'2021-12-18 11:04:37','',''),(2312449,'1','197','1018',464,'Retail Sale Id 1358316',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 11:06:06','',''),(2312536,'1','197','1018',464,'Retail Sale Id 1358392',3997.84,0.00,0.00,6.49,441.32,'2021-12-18 11:12:00','',''),(2312710,'1','197','1018',464,'Retail Sale Id 1358524',29328.00,0.00,0.00,52.00,832.00,'2021-12-18 11:24:18','',''),(2312909,'1','197','1018',464,'Retail Sale Id 1358720',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 11:41:12','',''),(2312975,'1','197','1018',464,'Retail Sale Id 1358781',71346.00,0.00,0.00,126.50,2024.00,'2021-12-18 11:47:59','',''),(2313224,'1','197','1018',464,'Retail Sale Id 1359019',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 12:16:00','',''),(2313571,'1','197','1018',464,'Retail Sale Id 1359345',3098.48,0.00,0.00,5.03,342.04,'2021-12-18 12:51:10','',''),(2313829,'1','197','1018',464,'Retail Sale Id 1359570',40608.00,0.00,0.00,72.00,1152.00,'2021-12-18 13:14:00','',''),(2313842,'1','197','1018',464,'Retail Sale Id 1359581',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 13:14:55','',''),(2313874,'1','197','1018',464,'Retail Sale Id 1359616',597.52,0.00,0.00,0.97,65.96,'2021-12-18 13:18:18','',''),(2314066,'1','197','1018',464,'Retail Sale Id 1359784',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 13:37:25','',''),(2314072,'1','197','1018',464,'Retail Sale Id 1359789',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 13:37:56','',''),(2314383,'1','197','1018',464,'Retail Sale Id 1359978',113082.00,0.00,0.00,200.50,3208.00,'2021-12-18 13:55:53','',''),(2314474,'1','197','1018',464,'Retail Sale Id 1360057',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 14:03:59','',''),(2314754,'1','197','1018',464,'Retail Sale Id 1360308',3098.48,0.00,0.00,5.03,342.04,'2021-12-18 14:27:50','',''),(2314784,'1','197','1018',464,'Retail Sale Id 1360329',2999.92,0.00,0.00,4.87,331.16,'2021-12-18 14:29:26','',''),(2314815,'1','197','1018',464,'Retail Sale Id 1360358',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 14:33:00','',''),(2314862,'1','197','1018',464,'Retail Sale Id 1360393',597.52,0.00,0.00,0.97,65.96,'2021-12-18 14:35:05','',''),(2315158,'1','197','1018',464,'Retail Sale Id 1360638',3098.48,0.00,0.00,5.03,342.04,'2021-12-18 14:59:56','',''),(2315674,'1','197','1018',464,'Retail Sale Id 1361101',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 15:42:21','',''),(2315729,'1','197','1018',464,'Retail Sale Id 1361150',2500.96,0.00,0.00,4.06,276.08,'2021-12-18 15:46:18','',''),(2315856,'1','197','1018',464,'Retail Sale Id 1361224',4398.24,0.00,0.00,7.14,485.52,'2021-12-18 15:51:56','',''),(2315935,'1','197','1018',464,'Retail Sale Id 1361295',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 15:56:32','',''),(2315994,'1','197','1018',464,'Retail Sale Id 1361333',16000.68,0.00,0.00,28.37,453.92,'2021-12-18 15:59:41','',''),(2316259,'1','197','1018',464,'Retail Sale Id 1361563',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 16:16:04','',''),(2316268,'1','197','1018',464,'Retail Sale Id 1361571',3702.16,0.00,0.00,6.01,408.68,'2021-12-18 16:16:53','',''),(2316331,'1','197','1018',464,'Retail Sale Id 1361635',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 16:21:58','',''),(2316391,'1','197','1018',464,'Retail Sale Id 1361699',3702.16,0.00,0.00,6.01,408.68,'2021-12-18 16:26:25','',''),(2316534,'1','197','1018',464,'Retail Sale Id 1361843',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 16:37:42','',''),(2316543,'1','197','1018',464,'Retail Sale Id 1361857',4502.96,0.00,0.00,7.31,497.08,'2021-12-18 16:38:39','',''),(2316590,'1','197','1018',464,'Retail Sale Id 1361902',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 16:42:17','',''),(2316613,'1','197','1018',464,'Retail Sale Id 1361925',2002.00,0.00,0.00,3.25,221.00,'2021-12-18 16:43:55','',''),(2316637,'1','197','1018',464,'Retail Sale Id 1361934',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 16:44:43','',''),(2316692,'1','197','1018',464,'Retail Sale Id 1361988',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 16:50:06','',''),(2316949,'1','197','1018',464,'Retail Sale Id 1362239',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 17:13:20','',''),(2316955,'1','197','1018',464,'Retail Sale Id 1362247',3702.16,0.00,0.00,6.01,408.68,'2021-12-18 17:14:52','',''),(2316973,'1','197','1018',464,'Retail Sale Id 1362265',2500.96,0.00,0.00,4.06,276.08,'2021-12-18 17:17:24','',''),(2317015,'1','197','1018',464,'Retail Sale Id 1362302',42300.00,0.00,0.00,75.00,1200.00,'2021-12-18 17:21:53','',''),(2317023,'1','197','1018',464,'Retail Sale Id 1362309',5001.92,0.00,0.00,8.12,552.16,'2021-12-18 17:23:23','',''),(2317298,'1','197','1018',464,'Retail Sale Id 1362536',7700.00,0.00,0.00,12.50,850.00,'2021-12-18 18:03:21','',''),(2317303,'1','197','1018',464,'Retail Sale Id 1362541',2845.92,0.00,0.00,4.62,314.16,'2021-12-18 18:04:14','',''),(2317384,'1','197','1018',464,'Retail Sale Id 1362612',3694.20,0.00,0.00,6.55,104.80,'2021-12-18 18:19:15','',''),(2318563,'1','197','1018',464,'Retail Sale Id 1363333',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 07:26:22','',''),(2318645,'1','197','1018',464,'Retail Sale Id 1363395',7398.16,0.00,0.00,12.01,816.68,'2021-12-19 07:33:26','',''),(2318656,'1','197','1018',464,'Retail Sale Id 1363427',3997.84,0.00,0.00,6.49,441.32,'2021-12-19 07:34:13','',''),(2319285,'1','197','1018',464,'Retail Sale Id 1363919',47376.00,0.00,0.00,84.00,1344.00,'2021-12-19 08:27:28','',''),(2320104,'1','197','1018',464,'Distributed to AMAZING GRASE for sales id:340770',1359.04,0.00,0.00,2.48,0.00,'2021-12-19 09:26:22','',''),(2320833,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,548000.00,1000.00,0.00,0.00,'2021-12-19 10:23:37','',''),(2320846,'1','197',NULL,464,'Reception corrector for bridging 127951',0.00,0.00,0.00,1000.00,0.00,'2021-12-19 10:24:43','',''),(2320847,'1','197','1018',464,'Received from bridging 127951',0.00,0.00,1000.00,0.00,0.00,'2021-12-19 10:24:43','',''),(2320873,'1','197','1018',464,'Retail Sale Id 1365183',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 10:26:26','',''),(2320884,'1','197','1018',464,'Retail Sale Id 1365194',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 10:27:19','',''),(2320897,'1','197','1018',464,'Retail Sale Id 1365211',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 10:28:31','',''),(2320932,'1','197','1018',464,'Retail Sale Id 1365224',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 10:29:49','',''),(2320946,'1','197','1018',464,'Retail Sale Id 1365245',3850.00,0.00,0.00,6.25,425.00,'2021-12-19 10:31:42','',''),(2320963,'1','197','1018',464,'Retail Sale Id 1365259',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 10:32:33','',''),(2320981,'1','197','1018',464,'Retail Sale Id 1365281',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 10:34:49','',''),(2320991,'1','197','1018',464,'Retail Sale Id 1365295',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 10:36:02','',''),(2321317,'1','197','1018',464,'Retail Sale Id 1365628',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 11:04:51','',''),(2321434,'1','197','1018',464,'Retail Sale Id 1365725',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 11:12:46','',''),(2321651,'1','197','1018',464,'Retail Sale Id 1365934',5001.92,0.00,0.00,8.12,552.16,'2021-12-19 11:30:23','',''),(2321658,'1','197','1018',464,'Retail Sale Id 1365943',3098.48,0.00,0.00,5.03,342.04,'2021-12-19 11:31:09','',''),(2321674,'1','197','1018',464,'Retail Sale Id 1365957',9597.28,0.00,0.00,15.58,1059.44,'2021-12-19 11:32:31','',''),(2321852,'1','197','1018',464,'Retail Sale Id 1366108',2002.00,0.00,0.00,3.25,221.00,'2021-12-19 11:47:32','',''),(2321863,'1','197','1018',464,'Retail Sale Id 1366119',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 11:48:16','',''),(2321873,'1','197','1018',464,'Retail Sale Id 1366129',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 11:49:07','',''),(2322048,'1','197','1018',464,'Retail Sale Id 1366297',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 12:04:12','',''),(2322055,'1','197','1018',464,'Retail Sale Id 1366258',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 12:04:46','',''),(2322222,'1','197','1018',464,'Retail Sale Id 1366477',1897.28,0.00,0.00,3.08,209.44,'2021-12-19 12:19:24','',''),(2322242,'1','197','1018',464,'Retail Sale Id 1366494',31020.00,0.00,0.00,55.00,880.00,'2021-12-19 12:21:36','',''),(2322257,'1','197','1018',464,'Retail Sale Id 1366515',84600.00,0.00,0.00,150.00,2400.00,'2021-12-19 12:22:56','',''),(2322820,'1','197','1018',464,'Retail Sale Id 1367036',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 13:15:14','',''),(2322891,'1','197','1018',464,'Retail Sale Id 1367102',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 13:21:39','',''),(2322925,'1','197','1018',464,'Retail Sale Id 1367131',2002.00,0.00,0.00,3.25,221.00,'2021-12-19 13:24:17','',''),(2323007,'1','197','1018',464,'Retail Sale Id 1367195',3800.72,0.00,0.00,6.17,419.56,'2021-12-19 13:30:26','',''),(2323273,'1','197','1018',464,'Retail Sale Id 1367389',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 13:49:59','',''),(2323299,'1','197','1018',464,'Retail Sale Id 1367402',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 13:51:02','',''),(2323312,'1','197','1018',464,'Retail Sale Id 1367416',2002.00,0.00,0.00,3.25,221.00,'2021-12-19 13:52:23','',''),(2323323,'1','197','1018',464,'Retail Sale Id 1367425',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 13:53:12','',''),(2323327,'1','197','1018',464,'Retail Sale Id 1367430',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 13:53:54','',''),(2323462,'1','197','1018',464,'Retail Sale Id 1367545',1601.60,0.00,0.00,2.60,176.80,'2021-12-19 14:01:31','',''),(2323820,'1','197','1018',464,'Retail Sale Id 1367849',155100.00,0.00,0.00,275.00,4400.00,'2021-12-19 14:30:16','',''),(2323849,'1','197','1018',464,'Retail Sale Id 1367872',24534.00,0.00,0.00,43.50,696.00,'2021-12-19 14:32:28','',''),(2323904,'1','197','1018',464,'Retail Sale Id 1367911',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 14:37:10','',''),(2324071,'1','197','1018',464,'Retail Sale Id 1368084',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 14:53:40','',''),(2324368,'1','197','1018',464,'Retail Sale Id 1368349',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 15:25:47','',''),(2324394,'1','197','1018',464,'Retail Sale Id 1368367',3098.48,0.00,0.00,5.03,342.04,'2021-12-19 15:28:33','',''),(2324395,'1','197','1018',464,'Retail Sale Id 1368367',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 15:28:33','',''),(2324447,'1','197','1018',464,'Retail Sale Id 1368418',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 15:33:38','',''),(2324737,'1','197','1018',464,'Retail Sale Id 1368683',997.92,0.00,0.00,1.62,110.16,'2021-12-19 15:59:22','',''),(2324768,'1','197','1018',464,'Retail Sale Id 1368696',3702.16,0.00,0.00,6.01,408.68,'2021-12-19 16:00:39','',''),(2324845,'1','197','1018',464,'Retail Sale Id 1368778',2999.92,0.00,0.00,4.87,331.16,'2021-12-19 16:09:53','',''),(2325068,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2312560.00,4220.00,0.00,0.00,'2021-12-19 16:29:14','',''),(2325082,'1','197',NULL,464,'Reception corrector for bridging 128002',0.00,0.00,0.00,4220.00,0.00,'2021-12-19 16:30:37','',''),(2325083,'1','197','1018',464,'Received from bridging 128002',0.00,0.00,4220.00,0.00,0.00,'2021-12-19 16:30:37','',''),(2325142,'1','197','1018',464,'Retail Sale Id 1368990',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 16:35:18','',''),(2325149,'1','197','1018',464,'Retail Sale Id 1368999',2002.00,0.00,0.00,3.25,221.00,'2021-12-19 16:36:22','',''),(2325483,'1','197','1018',464,'Retail Sale Id 1369282',12418.56,0.00,0.00,20.16,1370.88,'2021-12-19 17:13:31','',''),(2325487,'1','197','1018',464,'Retail Sale Id 1369288',21161.28,0.00,0.00,37.52,600.32,'2021-12-19 17:14:33','',''),(2325519,'1','197','1018',464,'Retail Sale Id 1369301',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 17:16:33','',''),(2325548,'1','197','1018',464,'Retail Sale Id 1369323',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 17:20:28','',''),(2325594,'1','197','1018',464,'Retail Sale Id 1369365',7700.00,0.00,0.00,12.50,850.00,'2021-12-19 17:33:19','',''),(2325614,'1','197','1018',464,'Retail Sale Id 1369371',7050.00,0.00,0.00,12.50,200.00,'2021-12-19 17:35:23','',''),(2325709,'1','197','1018',464,'Retail Sale Id 1369499',3098.48,0.00,0.00,5.03,342.04,'2021-12-19 18:02:31','',''),(2326865,'1','197','1018',464,'Retail Sale Id 1370095',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 07:41:33','',''),(2326890,'1','197','1018',464,'Retail Sale Id 1370110',28200.00,0.00,0.00,50.00,800.00,'2021-12-20 07:43:17','',''),(2327441,'1','197','1018',464,'Retail Sale Id 1370581',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 08:47:04','',''),(2327446,'1','197','1018',464,'Retail Sale Id 1370587',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 08:47:33','',''),(2327522,'1','197','1018',464,'Retail Sale Id 1370648',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 08:56:24','',''),(2327618,'1','197','1018',464,'Retail Sale Id 1370716',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 09:10:18','',''),(2327672,'1','197','1018',464,'Retail Sale Id 1370766',34200.96,0.00,0.00,60.64,970.24,'2021-12-20 09:15:57','',''),(2327744,'1','197','1018',464,'Retail Sale Id 1370831',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 09:26:13','',''),(2327925,'1','197','1018',464,'Retail Sale Id 1370967',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 09:48:06','',''),(2328134,'1','197','1018',464,'Retail Sale Id 1371109',1897.28,0.00,0.00,3.08,209.44,'2021-12-20 10:12:00','',''),(2328883,'1','197','1018',464,'Retail Sale Id 1371806',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 11:32:02','',''),(2329372,'1','197','1018',464,'Retail Sale Id 1372266',10200.96,0.00,0.00,16.56,1126.08,'2021-12-20 12:25:47','',''),(2329570,'1','197','1018',464,'Retail Sale Id 1372403',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 12:41:47','',''),(2330217,'1','197','1018',464,'Retail Sale Id 1372841',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 13:39:07','',''),(2330532,'1','197','1018',464,'Retail Sale Id 1373035',107160.00,0.00,0.00,190.00,3040.00,'2021-12-20 14:04:55','',''),(2330548,'1','197','1018',464,'Retail Sale Id 1373045',1897.28,0.00,0.00,3.08,209.44,'2021-12-20 14:05:38','',''),(2330587,'1','197','1018',464,'Retail Sale Id 1373082',7398.16,0.00,0.00,12.01,816.68,'2021-12-20 14:09:52','',''),(2330617,'1','197','1018',464,'Retail Sale Id 1373116',36.96,0.00,0.00,0.06,4.08,'2021-12-20 14:13:49','',''),(2330633,'1','197','1018',464,'Retail Sale Id 1373130',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 14:15:13','',''),(2330956,'1','197','1018',464,'Retail Sale Id 1373332',11402.16,0.00,0.00,18.51,1258.68,'2021-12-20 14:42:44','',''),(2331041,'1','197','1018',464,'Retail Sale Id 1373387',6800.64,0.00,0.00,11.04,750.72,'2021-12-20 14:49:57','',''),(2331062,'1','197','1018',464,'Retail Sale Id 1373405',7102.48,0.00,0.00,11.53,784.04,'2021-12-20 14:51:54','',''),(2331217,'1','197','1018',464,'Retail Sale Id 1373538',69998.04,0.00,0.00,124.11,1985.76,'2021-12-20 15:06:53','',''),(2331228,'1','197','1018',464,'Retail Sale Id 1373549',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 15:08:33','',''),(2331276,'1','197','1018',464,'Retail Sale Id 1373594',997.92,0.00,0.00,1.62,110.16,'2021-12-20 15:15:05','',''),(2331305,'1','197','1018',464,'Retail Sale Id 1373622',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 15:18:28','',''),(2331378,'1','197','1018',464,'Retail Sale Id 1373636',38500.00,0.00,0.00,62.50,4250.00,'2021-12-20 15:25:53','',''),(2331385,'1','197','1018',464,'Retail Sale Id 1373694',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 15:26:28','',''),(2331550,'1','197','1018',464,'Retail Sale Id 1373831',67680.00,0.00,0.00,120.00,1920.00,'2021-12-20 15:39:06','',''),(2331773,'1','197','1018',464,'Retail Sale Id 1374015',616.00,0.00,0.00,1.00,68.00,'2021-12-20 16:00:09','',''),(2331786,'1','197','1018',464,'Retail Sale Id 1374033',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:01:22','',''),(2331792,'1','197','1018',464,'Retail Sale Id 1374040',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 16:02:30','',''),(2331800,'1','197','1018',464,'Retail Sale Id 1374048',9597.28,0.00,0.00,15.58,1059.44,'2021-12-20 16:03:34','',''),(2331820,'1','197','1018',464,'Retail Sale Id 1374066',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:05:21','',''),(2331844,'1','197','1018',464,'Retail Sale Id 1374087',3098.48,0.00,0.00,5.03,342.04,'2021-12-20 16:07:07','',''),(2331881,'1','197','1018',464,'Retail Sale Id 1374128',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:11:11','',''),(2331924,'1','197','1018',464,'Retail Sale Id 1374162',3080.00,0.00,0.00,5.00,340.00,'2021-12-20 16:16:13','',''),(2331993,'1','197','1018',464,'Retail Sale Id 1374228',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:23:51','',''),(2332004,'1','197','1018',464,'Retail Sale Id 1374240',5001.92,0.00,0.00,8.12,552.16,'2021-12-20 16:25:11','',''),(2332061,'1','197','1018',464,'Retail Sale Id 1374280',3498.88,0.00,0.00,5.68,386.24,'2021-12-20 16:30:33','',''),(2332071,'1','197','1018',464,'Retail Sale Id 1374290',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 16:31:36','',''),(2332160,'1','197','1018',464,'Retail Sale Id 1374382',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:40:45','',''),(2332185,'1','197','1018',464,'Retail Sale Id 1374397',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:42:15','',''),(2332216,'1','197','1018',464,'Retail Sale Id 1374426',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 16:45:11','',''),(2332387,'1','197','1018',464,'Retail Sale Id 1374583',6196.96,0.00,0.00,10.06,684.08,'2021-12-20 17:05:08','',''),(2332410,'1','197','1018',464,'Retail Sale Id 1374601',1503.04,0.00,0.00,2.44,165.92,'2021-12-20 17:08:05','',''),(2332411,'1','197','1018',464,'Retail Sale Id 1374601',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:08:05','',''),(2332412,'1','197','1018',464,'Retail Sale Id 1374601',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:08:05','',''),(2332427,'1','197','1018',464,'Retail Sale Id 1374612',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:09:36','',''),(2332454,'1','197','1018',464,'Retail Sale Id 1374631',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:12:10','',''),(2332487,'1','197','1018',464,'Retail Sale Id 1374660',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:17:50','',''),(2332558,'1','197','1018',464,'Retail Sale Id 1374719',2999.92,0.00,0.00,4.87,331.16,'2021-12-20 17:30:48','',''),(2332568,'1','197','1018',464,'Retail Sale Id 1374729',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:32:22','',''),(2332580,'1','197','1018',464,'Retail Sale Id 1374743',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 17:34:18','',''),(2332606,'1','197','1018',464,'Retail Sale Id 1374763',3702.16,0.00,0.00,6.01,408.68,'2021-12-20 17:38:34','',''),(2332614,'1','197','1018',464,'Retail Sale Id 1374769',5001.92,0.00,0.00,8.12,552.16,'2021-12-20 17:39:48','',''),(2332942,'1','197','1018',464,'Return of Retail Sale Id 1370110',0.00,28200.00,50.00,0.00,-800.00,'2021-12-20 18:49:29','',''),(2332956,'1','197','1018',464,'Retail Sale Id 1374912',25233.36,0.00,0.00,44.74,715.84,'2021-12-20 19:00:06','',''),(2332959,'1','197','1018',464,'Retail Sale Id 1374913',15400.00,0.00,0.00,25.00,1700.00,'2021-12-20 19:01:37','',''),(2332960,'1','197','1018',464,'Retail Sale Id 1374914',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 19:02:08','',''),(2332961,'1','197','1018',464,'Retail Sale Id 1374915',3098.48,0.00,0.00,5.03,342.04,'2021-12-20 19:02:31','',''),(2332969,'1','197','1018',464,'Retail Sale Id 1374919',7700.00,0.00,0.00,12.50,850.00,'2021-12-20 19:04:04','',''),(2332970,'1','197','1018',464,'Retail Sale Id 1374920',8334.48,0.00,0.00,13.53,920.04,'2021-12-20 19:04:44','',''),(2333466,'1','197','1018',464,'Retail Sale Id 1375075',7700.00,0.00,0.00,12.50,850.00,'2021-12-21 06:33:23','',''),(2334144,'1','197','1018',464,'Retail Sale Id 1375644',7700.00,0.00,0.00,12.50,850.00,'2021-12-21 07:48:48','',''),(2334364,'1','197','1018',464,'Retail Sale Id 1375830',7700.00,0.00,0.00,12.50,850.00,'2021-12-21 08:05:49','',''),(2334451,'1','197','1018',464,'Retail Sale Id 1375882',2002.00,0.00,0.00,3.25,221.00,'2021-12-21 08:11:05','',''),(2334476,'1','197','1018',464,'Retail Sale Id 1375905',23100.00,0.00,0.00,37.50,2550.00,'2021-12-21 08:14:23','',''),(2334497,'1','197','1018',464,'Retail Sale Id 1375927',3702.16,0.00,0.00,6.01,408.68,'2021-12-21 08:18:04','',''),(2334521,'1','197','1018',464,'Retail Sale Id 1375949',7700.00,0.00,0.00,12.50,850.00,'2021-12-21 08:21:59','',''),(2334870,'1','197','1018',464,'Retail Sale Id 1376245',2002.00,0.00,0.00,3.25,221.00,'2021-12-21 09:08:29','',''),(2334976,'1','197','1018',464,'Retail Sale Id 1376338',8999.76,0.00,0.00,14.61,993.48,'2021-12-21 09:20:35','',''),(2335069,'1','197','1018',464,'Retail Sale Id 1376393',3098.48,0.00,0.00,5.03,342.04,'2021-12-21 09:27:24','',''),(2335146,'1','197','1018',464,'Retail Sale Id 1376465',3702.16,0.00,0.00,6.01,408.68,'2021-12-21 09:37:07','',''),(2335396,'1','197','1018',464,'Retail Sale Id 1376697',6677.76,0.00,0.00,11.84,189.44,'2021-12-21 10:04:24','',''),(2335455,'1','197','1018',464,'Retail Sale Id 1376754',7706.16,0.00,0.00,12.51,850.68,'2021-12-21 10:12:39','',''),(2335642,'1','197','1018',464,'Retail Sale Id 1376886',6002.88,0.00,0.00,10.14,446.16,'2021-12-21 10:32:17','',''),(2335643,'1','197','1018',464,'Retail Sale Id 1376886',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 10:32:17','',''),(2335650,'1','197','1018',464,'Retail Sale Id 1376892',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 10:33:16','',''),(2335692,'1','197','1018',464,'Retail Sale Id 1376917',147896.00,0.00,0.00,266.00,2128.00,'2021-12-21 10:35:57','',''),(2336024,'1','197','1018',464,'Retail Sale Id 1377178',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 11:09:42','',''),(2336049,'1','197','1018',464,'Retail Sale Id 1377200',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 11:12:41','',''),(2336119,'1','197','1018',464,'Retail Sale Id 1377255',6950.00,0.00,0.00,12.50,100.00,'2021-12-21 11:18:02','',''),(2336255,'1','197','1018',464,'Retail Sale Id 1377374',3001.44,0.00,0.00,5.07,223.08,'2021-12-21 11:34:23','',''),(2336373,'1','197','1018',464,'Retail Sale Id 1377481',698.56,0.00,0.00,1.18,51.92,'2021-12-21 11:50:50','',''),(2336615,'1','197','1018',464,'Retail Sale Id 1377688',3498.72,0.00,0.00,5.91,260.04,'2021-12-21 12:19:29','',''),(2336645,'1','197','1018',464,'Retail Sale Id 1377716',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 12:22:25','',''),(2336818,'1','197','1018',464,'Retail Sale Id 1377872',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 12:42:07','',''),(2336999,'1','197','1018',464,'Retail Sale Id 1378033',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:01:57','',''),(2337110,'1','197','1018',464,'Retail Sale Id 1378129',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:11:56','',''),(2337222,'1','197','1018',464,'Retail Sale Id 1378220',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 13:22:54','',''),(2337223,'1','197','1018',464,'Retail Sale Id 1378220',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:22:54','',''),(2337299,'1','197','1018',464,'Retail Sale Id 1378301',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:32:12','',''),(2337553,'1','197','1018',464,'Retail Sale Id 1378462',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 13:49:45','',''),(2337662,'1','197','1018',464,'Retail Sale Id 1378547',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 13:59:46','',''),(2337895,'1','197','1018',464,'Retail Sale Id 1378723',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 14:19:21','',''),(2337941,'1','197','1018',464,'Retail Sale Id 1378761',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 14:23:36','',''),(2337971,'1','197','1018',464,'Retail Sale Id 1378794',3001.44,0.00,0.00,5.07,223.08,'2021-12-21 14:25:59','',''),(2338540,'1','197','1018',464,'Retail Sale Id 1379310',36140.00,0.00,0.00,65.00,520.00,'2021-12-21 15:13:03','',''),(2338932,'1','197','1018',464,'Retail Sale Id 1379603',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 15:40:37','',''),(2338966,'1','197','1018',464,'Retail Sale Id 1379647',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 15:43:07','',''),(2338967,'1','197','1018',464,'Retail Sale Id 1379647',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 15:43:07','',''),(2339021,'1','197','1018',464,'Retail Sale Id 1379672',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 15:46:40','',''),(2339091,'1','197','1018',464,'Retail Sale Id 1379756',64496.00,0.00,0.00,116.00,928.00,'2021-12-21 15:52:07','',''),(2339168,'1','197','1018',464,'Retail Sale Id 1379827',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 15:57:26','',''),(2339218,'1','197','1018',464,'Retail Sale Id 1379860',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 15:59:56','',''),(2339238,'1','197','1018',464,'Retail Sale Id 1379878',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 16:01:23','',''),(2339239,'1','197','1018',464,'Retail Sale Id 1379878',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 16:01:23','',''),(2339240,'1','197','1018',464,'Retail Sale Id 1379878',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 16:01:23','',''),(2339261,'1','197','1018',464,'Retail Sale Id 1379891',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 16:02:40','',''),(2339463,'1','197','1018',464,'Retail Sale Id 1380077',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 16:16:55','',''),(2339781,'1','197','1018',464,'Retail Sale Id 1380381',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 16:43:29','',''),(2339799,'1','197','1018',464,'Retail Sale Id 1380395',1201.76,0.00,0.00,2.03,89.32,'2021-12-21 16:44:45','',''),(2340052,'1','197','1018',464,'Retail Sale Id 1380638',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 17:08:36','',''),(2340083,'1','197','1018',464,'Retail Sale Id 1380667',1799.68,0.00,0.00,3.04,133.76,'2021-12-21 17:11:31','',''),(2340092,'1','197','1018',464,'Retail Sale Id 1380675',11840.00,0.00,0.00,20.00,880.00,'2021-12-21 17:12:24','',''),(2340103,'1','197','1018',464,'Retail Sale Id 1380687',4001.92,0.00,0.00,6.76,297.44,'2021-12-21 17:13:45','',''),(2340120,'1','197','1018',464,'Retail Sale Id 1380702',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 17:15:04','',''),(2340206,'1','197','1018',464,'Retail Sale Id 1380779',2000.96,0.00,0.00,3.38,148.72,'2021-12-21 17:27:05','',''),(2340234,'1','197','1018',464,'Retail Sale Id 1380804',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 17:30:43','',''),(2340280,'1','197','1018',464,'Retail Sale Id 1380846',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 17:37:55','',''),(2340328,'1','197','1018',464,'Retail Sale Id 1380889',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 17:46:14','',''),(2340369,'1','197','1018',464,'Retail Sale Id 1380917',15801.52,0.00,0.00,28.42,227.36,'2021-12-21 17:53:02','',''),(2340425,'1','197','1018',464,'Retail Sale Id 1380964',3599.36,0.00,0.00,6.08,267.52,'2021-12-21 18:01:53','',''),(2340461,'1','197','1018',464,'Retail Sale Id 1380993',6600.80,0.00,0.00,11.15,490.60,'2021-12-21 18:10:41','',''),(2340621,'1','197','1018',464,'Retail Sale Id 1381095',14800.00,0.00,0.00,25.00,1100.00,'2021-12-21 19:07:56','',''),(2340623,'1','197','1018',464,'Retail Sale Id 1381098',7400.00,0.00,0.00,12.50,550.00,'2021-12-21 19:08:43','',''),(2340626,'1','197','1018',464,'Retail Sale Id 1381099',4167.68,0.00,0.00,7.04,309.76,'2021-12-21 19:09:14','',''),(2340647,'1','197','1018',464,'Retail Sale Id 1381105',135158.04,0.00,0.00,243.09,1944.72,'2021-12-21 19:14:49','',''),(2341251,'1','197','1018',464,'Retail Sale Id 1381260',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 06:25:08','',''),(2341536,'1','197','1018',464,'Retail Sale Id 1381443',1497.76,0.00,0.00,2.53,111.32,'2021-12-22 06:51:39','',''),(2341582,'1','197','1018',464,'Retail Sale Id 1381481',22240.00,0.00,0.00,40.00,320.00,'2021-12-22 06:55:28','',''),(2341708,'1','197','1018',464,'Retail Sale Id 1381602',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 07:06:54','',''),(2341827,'1','197','1018',464,'Retail Sale Id 1381706',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 07:15:47','',''),(2342068,'1','197','1018',464,'Retail Sale Id 1381910',55600.00,0.00,0.00,100.00,800.00,'2021-12-22 07:37:24','',''),(2342184,'1','197','1018',464,'Retail Sale Id 1381987',5002.40,0.00,0.00,8.45,371.80,'2021-12-22 07:44:51','',''),(2342292,'1','197','1018',464,'Retail Sale Id 1382060',83956.00,0.00,0.00,151.00,1208.00,'2021-12-22 07:50:40','',''),(2342427,'1','197','1018',464,'Retail Sale Id 1382179',11840.00,0.00,0.00,20.00,880.00,'2021-12-22 08:00:01','',''),(2342497,'1','197','1018',464,'Retail Sale Id 1382234',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 08:03:25','',''),(2342585,'1','197','1018',464,'Retail Sale Id 1382290',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 08:08:37','',''),(2342601,'1','197','1018',464,'Retail Sale Id 1382314',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 08:09:56','',''),(2342872,'1','197','1018',464,'Retail Sale Id 1382538',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 08:28:18','',''),(2342939,'1','197','1018',464,'Retail Sale Id 1382571',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 08:30:42','',''),(2343137,'1','197','1018',464,'Retail Sale Id 1382745',7802.56,0.00,0.00,13.18,579.92,'2021-12-22 08:48:11','',''),(2343376,'1','197','1018',464,'Retail Sale Id 1383017',29600.00,0.00,0.00,50.00,2200.00,'2021-12-22 09:10:55','',''),(2343392,'1','197','1018',464,'Retail Sale Id 1383034',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 09:12:09','',''),(2343699,'1','197','1018',464,'Retail Sale Id 1383286',10999.36,0.00,0.00,18.58,817.52,'2021-12-22 09:37:54','',''),(2343705,'1','197','1018',464,'Retail Sale Id 1383293',1799.68,0.00,0.00,3.04,133.76,'2021-12-22 09:38:41','',''),(2343871,'1','197','1018',464,'Retail Sale Id 1383439',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 09:54:22','',''),(2343967,'1','197','1018',464,'Retail Sale Id 1383524',14800.00,0.00,0.00,25.00,1100.00,'2021-12-22 10:01:10','',''),(2344256,'1','197','1018',464,'Retail Sale Id 1383810',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 10:30:10','',''),(2344685,'1','197','1018',464,'Retail Sale Id 1384236',18070.00,0.00,0.00,32.50,260.00,'2021-12-22 11:12:06','',''),(2344703,'1','197','1018',464,'Retail Sale Id 1384254',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 11:14:11','',''),(2344717,'1','197','1018',464,'Retail Sale Id 1384263',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 11:14:52','',''),(2344849,'1','197','1018',464,'Retail Sale Id 1384399',76728.00,0.00,0.00,138.00,1104.00,'2021-12-22 11:28:17','',''),(2345079,'1','197','1018',464,'Retail Sale Id 1384607',67832.00,0.00,0.00,122.00,976.00,'2021-12-22 11:49:34','',''),(2345272,'1','197','1018',464,'Retail Sale Id 1384800',34750.00,0.00,0.00,62.50,500.00,'2021-12-22 12:10:24','',''),(2345392,'1','197','1018',464,'Retail Sale Id 1384892',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 12:22:08','',''),(2345412,'1','197','1018',464,'Retail Sale Id 1384900',4197.28,0.00,0.00,7.09,311.96,'2021-12-22 12:23:05','',''),(2345524,'1','197','1018',464,'Retail Sale Id 1385015',1497.76,0.00,0.00,2.53,111.32,'2021-12-22 12:37:05','',''),(2345723,'1','197','1018',464,'Retail Sale Id 1385169',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 12:55:14','',''),(2345810,'1','197','1018',464,'Retail Sale Id 1385259',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 13:06:30','',''),(2345922,'1','197','1018',464,'Retail Sale Id 1385360',3001.44,0.00,0.00,5.07,223.08,'2021-12-22 13:18:25','',''),(2345928,'1','197','1018',464,'Retail Sale Id 1385367',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 13:19:13','',''),(2345939,'1','197','1018',464,'Retail Sale Id 1385378',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 13:20:42','',''),(2346010,'1','197','1018',464,'Retail Sale Id 1385444',34750.00,0.00,0.00,62.50,500.00,'2021-12-22 13:28:29','',''),(2346579,'1','197','1018',464,'Retail Sale Id 1385776',22200.00,0.00,0.00,37.50,1650.00,'2021-12-22 14:12:05','',''),(2346607,'1','197','1018',464,'Retail Sale Id 1385805',11840.00,0.00,0.00,20.00,880.00,'2021-12-22 14:16:10','',''),(2346681,'1','197','1018',464,'Retail Sale Id 1385873',6002.88,0.00,0.00,10.14,446.16,'2021-12-22 14:23:28','',''),(2346922,'1','197','1018',464,'Retail Sale Id 1386052',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 14:47:44','',''),(2346932,'1','197','1018',464,'Retail Sale Id 1386062',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 14:48:48','',''),(2346941,'1','197','1018',464,'Retail Sale Id 1386069',2000.96,0.00,0.00,3.38,148.72,'2021-12-22 14:49:43','',''),(2346950,'1','197','1018',464,'Retail Sale Id 1386080',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 14:51:25','',''),(2346956,'1','197','1018',464,'Retail Sale Id 1386087',29600.00,0.00,0.00,50.00,2200.00,'2021-12-22 14:52:15','',''),(2347147,'1','197','1018',464,'Retail Sale Id 1386254',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 15:10:57','',''),(2347159,'1','197','1018',464,'Retail Sale Id 1386268',1799.68,0.00,0.00,3.04,133.76,'2021-12-22 15:12:25','',''),(2347218,'1','197','1018',464,'Retail Sale Id 1386307',11840.00,0.00,0.00,20.00,880.00,'2021-12-22 15:16:42','',''),(2347417,'1','197','1018',464,'Retail Sale Id 1386426',18070.00,0.00,0.00,32.50,260.00,'2021-12-22 15:30:31','',''),(2347759,'1','197','1018',464,'Retail Sale Id 1386714',1160.32,0.00,0.00,1.96,86.24,'2021-12-22 15:57:44','',''),(2347764,'1','197','1018',464,'Retail Sale Id 1386720',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 15:58:24','',''),(2347855,'1','197','1018',464,'Retail Sale Id 1386769',51152.00,0.00,0.00,92.00,736.00,'2021-12-22 16:04:35','',''),(2347871,'1','197','1018',464,'Retail Sale Id 1386799',14800.00,0.00,0.00,25.00,1100.00,'2021-12-22 16:06:53','',''),(2347901,'1','197','1018',464,'Retail Sale Id 1386832',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 16:09:13','',''),(2347915,'1','197','1018',464,'Retail Sale Id 1386846',6002.88,0.00,0.00,10.14,446.16,'2021-12-22 16:10:51','',''),(2347925,'1','197','1018',464,'Retail Sale Id 1386856',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 16:11:36','',''),(2347955,'1','197','1018',464,'Retail Sale Id 1386888',27800.00,0.00,0.00,50.00,400.00,'2021-12-22 16:15:49','',''),(2347961,'1','197','1018',464,'Retail Sale Id 1386897',1302.40,0.00,0.00,2.20,96.80,'2021-12-22 16:16:25','',''),(2347987,'1','197','1018',464,'Retail Sale Id 1386924',3700.00,0.00,0.00,6.25,275.00,'2021-12-22 16:19:49','',''),(2348041,'1','197','1018',464,'Retail Sale Id 1386946',2202.24,0.00,0.00,3.72,163.68,'2021-12-22 16:22:28','',''),(2348075,'1','197','1018',464,'Retail Sale Id 1386980',16402.00,0.00,0.00,29.50,236.00,'2021-12-22 16:28:00','',''),(2348163,'1','197','1018',464,'Retail Sale Id 1387061',1497.76,0.00,0.00,2.53,111.32,'2021-12-22 16:37:37','',''),(2348201,'1','197','1018',464,'Retail Sale Id 1387094',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 16:41:44','',''),(2348209,'1','197','1018',464,'Retail Sale Id 1387102',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 16:42:46','',''),(2348217,'1','197','1018',464,'Retail Sale Id 1387110',2000.96,0.00,0.00,3.38,148.72,'2021-12-22 16:43:38','',''),(2348272,'1','197','1018',464,'Retail Sale Id 1387161',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 16:48:53','',''),(2348308,'1','197','1018',464,'Retail Sale Id 1387196',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 16:52:38','',''),(2348370,'1','197','1018',464,'Retail Sale Id 1387258',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 16:58:25','',''),(2348395,'1','197','1018',464,'Retail Sale Id 1387282',10999.36,0.00,0.00,18.58,817.52,'2021-12-22 17:00:36','',''),(2348407,'1','197','1018',464,'Retail Sale Id 1387292',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 17:01:32','',''),(2348456,'1','197','1018',464,'Retail Sale Id 1387340',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 17:07:13','',''),(2348470,'1','197','1018',464,'Retail Sale Id 1387352',1000.48,0.00,0.00,1.69,74.36,'2021-12-22 17:08:27','',''),(2348651,'1','197','1018',464,'Retail Sale Id 1387468',1799.68,0.00,0.00,3.04,133.76,'2021-12-22 17:27:24','',''),(2348682,'1','197','1018',464,'Retail Sale Id 1387491',3599.36,0.00,0.00,6.08,267.52,'2021-12-22 17:34:30','',''),(2348875,'1','197','1018',464,'Retail Sale Id 1387644',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 18:20:58','',''),(2349066,'1','197','1018',464,'Retail Sale Id 1387741',1112.00,0.00,0.00,2.00,16.00,'2021-12-22 19:32:09','',''),(2349068,'1','197','1018',464,'Retail Sale Id 1387743',7400.00,0.00,0.00,12.50,550.00,'2021-12-22 19:34:00','',''),(2349070,'1','197','1018',464,'Retail Sale Id 1387745',5375.36,0.00,0.00,9.08,399.52,'2021-12-22 19:35:13','',''),(2349833,'1','197','1018',464,'Retail Sale Id 1388085',10999.36,0.00,0.00,18.58,817.52,'2021-12-23 06:57:56','',''),(2349928,'1','197','1018',464,'Retail Sale Id 1388159',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 07:06:08','',''),(2349936,'1','197','1018',464,'Retail Sale Id 1388167',1799.68,0.00,0.00,3.04,133.76,'2021-12-23 07:06:56','',''),(2350004,'1','197','1018',464,'Retail Sale Id 1388222',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 07:12:52','',''),(2350128,'1','197','1018',464,'Retail Sale Id 1388284',1000.48,0.00,0.00,1.69,74.36,'2021-12-23 07:20:20','',''),(2350943,'1','197','1018',464,'Retail Sale Id 1388897',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 08:22:09','',''),(2351170,'1','197','1018',464,'Retail Sale Id 1389105',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 08:43:43','',''),(2351298,'1','197','1018',464,'Retail Sale Id 1389224',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 08:55:40','',''),(2351347,'1','197','1018',464,'Retail Sale Id 1389273',2320.64,0.00,0.00,3.92,172.48,'2021-12-23 09:00:54','',''),(2353527,'1','197','1018',464,'Distributed to AMAZING GRASE for sales id:341771',49758.40,0.00,0.00,90.80,0.00,'2021-12-23 12:07:46','',''),(2353551,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,548000.00,1000.00,0.00,0.00,'2021-12-23 12:10:17','',''),(2353564,'1','197',NULL,464,'Reception corrector for bridging 128493',0.00,0.00,0.00,1000.00,0.00,'2021-12-23 12:11:18','',''),(2353565,'1','197','1018',464,'Received from bridging 128493',0.00,0.00,1000.00,0.00,0.00,'2021-12-23 12:11:18','',''),(2353584,'1','197','1018',464,'Retail Sale Id 1391292',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 12:12:39','',''),(2353673,'1','197','1018',464,'Retail Sale Id 1391381',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 12:22:24','',''),(2353701,'1','197','1018',464,'Retail Sale Id 1391393',1497.76,0.00,0.00,2.53,111.32,'2021-12-23 12:23:42','',''),(2353744,'1','197','1018',464,'Retail Sale Id 1391437',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 12:27:10','',''),(2353745,'1','197','1018',464,'Retail Sale Id 1391437',14800.00,0.00,0.00,25.00,1100.00,'2021-12-23 12:27:10','',''),(2353775,'1','197','1018',464,'Retail Sale Id 1391456',2900.80,0.00,0.00,4.90,215.60,'2021-12-23 12:29:22','',''),(2353893,'1','197','1018',464,'Retail Sale Id 1391558',1799.68,0.00,0.00,3.04,133.76,'2021-12-23 12:39:09','',''),(2353949,'1','197','1018',464,'Retail Sale Id 1391593',4801.12,0.00,0.00,8.11,356.84,'2021-12-23 12:43:19','',''),(2354685,'1','197','1018',464,'Retail Sale Id 1392298',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 13:49:01','',''),(2354865,'1','197','1018',464,'Retail Sale Id 1392416',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 14:01:41','',''),(2355577,'1','197','1018',464,'Retail Sale Id 1392908',28800.80,0.00,0.00,48.65,2140.60,'2021-12-23 14:53:47','',''),(2355618,'1','197','1018',464,'Retail Sale Id 1392949',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 14:58:24','',''),(2355868,'1','197','1018',464,'Retail Sale Id 1393182',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:20:31','',''),(2355878,'1','197','1018',464,'Retail Sale Id 1393193',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:21:04','',''),(2355889,'1','197','1018',464,'Retail Sale Id 1393205',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:22:07','',''),(2355978,'1','197','1018',464,'Retail Sale Id 1393287',1497.76,0.00,0.00,2.53,111.32,'2021-12-23 15:30:27','',''),(2355994,'1','197','1018',464,'Retail Sale Id 1393302',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 15:31:39','',''),(2356048,'1','197','1018',464,'Retail Sale Id 1393354',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:36:56','',''),(2356096,'1','197','1018',464,'Retail Sale Id 1393389',2598.88,0.00,0.00,4.39,193.16,'2021-12-23 15:40:10','',''),(2356109,'1','197','1018',464,'Retail Sale Id 1393403',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 15:41:15','',''),(2356118,'1','197','1018',464,'Retail Sale Id 1393410',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 15:42:01','',''),(2356160,'1','197','1018',464,'Retail Sale Id 1393451',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:46:34','',''),(2356190,'1','197','1018',464,'Retail Sale Id 1393484',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:49:03','',''),(2356206,'1','197','1018',464,'Retail Sale Id 1393501',7198.72,0.00,0.00,12.16,535.04,'2021-12-23 15:50:23','',''),(2356218,'1','197','1018',464,'Retail Sale Id 1393517',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 15:51:43','',''),(2356297,'1','197','1018',464,'Retail Sale Id 1393596',3001.44,0.00,0.00,5.07,223.08,'2021-12-23 15:59:09','',''),(2356304,'1','197','1018',464,'Retail Sale Id 1393604',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 15:59:59','',''),(2356320,'1','197','1018',464,'Retail Sale Id 1393617',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 16:00:55','',''),(2356337,'1','197','1018',464,'Retail Sale Id 1393636',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 16:02:15','',''),(2356395,'1','197','1018',464,'Retail Sale Id 1393689',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:07:06','',''),(2356418,'1','197','1018',464,'Retail Sale Id 1393712',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 16:08:44','',''),(2356540,'1','197','1018',464,'Retail Sale Id 1393832',6002.88,0.00,0.00,10.14,446.16,'2021-12-23 16:18:30','',''),(2356578,'1','197','1018',464,'Retail Sale Id 1393878',1799.68,0.00,0.00,3.04,133.76,'2021-12-23 16:22:54','',''),(2356671,'1','197','1018',464,'Retail Sale Id 1393959',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:29:34','',''),(2356748,'1','197','1018',464,'Retail Sale Id 1394045',3001.44,0.00,0.00,5.07,223.08,'2021-12-23 16:37:54','',''),(2356785,'1','197','1018',464,'Retail Sale Id 1394083',10999.36,0.00,0.00,18.58,817.52,'2021-12-23 16:41:51','',''),(2356820,'1','197','1018',464,'Retail Sale Id 1394117',6500.16,0.00,0.00,10.98,483.12,'2021-12-23 16:44:39','',''),(2356841,'1','197','1018',464,'Retail Sale Id 1394134',899.84,0.00,0.00,1.52,66.88,'2021-12-23 16:46:37','',''),(2356868,'1','197','1018',464,'Retail Sale Id 1394161',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:49:41','',''),(2356884,'1','197','1018',464,'Retail Sale Id 1394178',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:51:08','',''),(2356891,'1','197','1018',464,'Retail Sale Id 1394187',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:51:51','',''),(2356903,'1','197','1018',464,'Retail Sale Id 1394197',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:52:48','',''),(2356910,'1','197','1018',464,'Retail Sale Id 1394204',3001.44,0.00,0.00,5.07,223.08,'2021-12-23 16:53:26','',''),(2356917,'1','197','1018',464,'Retail Sale Id 1394213',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 16:53:55','',''),(2356973,'1','197','1018',464,'Retail Sale Id 1394274',1000.48,0.00,0.00,1.69,74.36,'2021-12-23 17:00:12','',''),(2357051,'1','197','1018',464,'Retail Sale Id 1394336',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 17:07:05','',''),(2357068,'1','197','1018',464,'Retail Sale Id 1394353',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 17:09:15','',''),(2357096,'1','197','1018',464,'Retail Sale Id 1394375',10401.44,0.00,0.00,17.57,773.08,'2021-12-23 17:11:16','',''),(2357128,'1','197','1018',464,'Retail Sale Id 1394406',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 17:14:55','',''),(2357300,'1','197','1018',464,'Retail Sale Id 1394509',3599.36,0.00,0.00,6.08,267.52,'2021-12-23 17:28:49','',''),(2357337,'1','197','1018',464,'Retail Sale Id 1394542',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 17:36:28','',''),(2357397,'1','197','1018',464,'Retail Sale Id 1394597',3001.44,0.00,0.00,5.07,223.08,'2021-12-23 17:44:24','',''),(2357401,'1','197','1018',464,'Retail Sale Id 1394601',2498.24,0.00,0.00,4.22,185.68,'2021-12-23 17:45:17','',''),(2357448,'1','197','1018',464,'Retail Sale Id 1394642',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 17:52:26','',''),(2357454,'1','197','1018',464,'Retail Sale Id 1394648',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 17:53:17','',''),(2357730,'1','197','1018',464,'Retail Sale Id 1394836',7400.00,0.00,0.00,12.50,550.00,'2021-12-23 18:34:06','',''),(2357731,'1','197','1018',464,'Retail Sale Id 1394837',2196.32,0.00,0.00,3.71,163.24,'2021-12-23 18:35:14','',''),(2358005,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2411200.00,4400.00,0.00,0.00,'2021-12-23 20:02:07','',''),(2358014,'1','197',NULL,464,'Reception corrector for bridging 128562',0.00,0.00,0.00,4400.00,0.00,'2021-12-23 20:18:38','',''),(2358015,'1','197','1018',464,'Received from bridging 128562',0.00,0.00,4400.00,0.00,0.00,'2021-12-23 20:18:38','',''),(2358897,'1','197','1018',464,'Retail Sale Id 1395397',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 07:05:41','',''),(2358934,'1','197','1018',464,'Retail Sale Id 1395433',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 07:09:26','',''),(2358957,'1','197','1018',464,'Retail Sale Id 1395447',17792.00,0.00,0.00,32.00,256.00,'2021-12-24 07:11:17','',''),(2359184,'1','197','1018',464,'Retail Sale Id 1395637',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 07:30:28','',''),(2359260,'1','197','1018',464,'Retail Sale Id 1395717',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 07:37:03','',''),(2359304,'1','197','1018',464,'Retail Sale Id 1395759',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 07:42:20','',''),(2359318,'1','197','1018',464,'Retail Sale Id 1395771',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 07:43:19','',''),(2359327,'1','197','1018',464,'Retail Sale Id 1395784',2000.96,0.00,0.00,3.38,148.72,'2021-12-24 07:44:15','',''),(2359352,'1','197','1018',464,'Retail Sale Id 1395809',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 07:46:30','',''),(2359513,'1','197','1018',464,'Retail Sale Id 1395951',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 07:58:29','',''),(2359806,'1','197','1018',464,'Retail Sale Id 1396162',2000.96,0.00,0.00,3.38,148.72,'2021-12-24 08:17:33','',''),(2360244,'1','197','1018',464,'Retail Sale Id 1396578',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 08:52:15','',''),(2360304,'1','197','1018',464,'Retail Sale Id 1396621',2000.96,0.00,0.00,3.38,148.72,'2021-12-24 08:55:01','',''),(2360457,'1','197','1018',464,'Retail Sale Id 1396741',22496.00,0.00,0.00,38.00,1672.00,'2021-12-24 09:04:58','',''),(2360535,'1','197','1018',464,'Retail Sale Id 1396830',53198.08,0.00,0.00,95.68,765.44,'2021-12-24 09:13:27','',''),(2360719,'1','197','1018',464,'Retail Sale Id 1396970',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 09:26:00','',''),(2360891,'1','197','1018',464,'Retail Sale Id 1397138',6997.44,0.00,0.00,11.82,520.08,'2021-12-24 09:37:55','',''),(2361143,'1','197','1018',464,'Retail Sale Id 1397306',5600.32,0.00,0.00,9.46,416.24,'2021-12-24 09:51:30','',''),(2361289,'1','197','1018',464,'Retail Sale Id 1397437',1799.68,0.00,0.00,3.04,133.76,'2021-12-24 10:00:25','',''),(2361327,'1','197','1018',464,'Retail Sale Id 1397472',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 10:02:45','',''),(2361880,'1','197','1018',464,'Retail Sale Id 1398033',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 10:49:14','',''),(2361898,'1','197','1018',464,'Retail Sale Id 1398052',12402.40,0.00,0.00,20.95,921.80,'2021-12-24 10:51:00','',''),(2361966,'1','197','1018',464,'Retail Sale Id 1398117',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 10:58:27','',''),(2362123,'1','197','1018',464,'Retail Sale Id 1398283',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 11:13:39','',''),(2362312,'1','197','1018',464,'Retail Sale Id 1398468',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 11:32:38','',''),(2362351,'1','197','1018',464,'Retail Sale Id 1398500',5920.00,0.00,0.00,10.00,440.00,'2021-12-24 11:36:02','',''),(2362441,'1','197','1018',464,'Retail Sale Id 1398579',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 11:41:31','',''),(2362560,'1','197','1018',464,'Retail Sale Id 1398684',14800.00,0.00,0.00,25.00,1100.00,'2021-12-24 11:51:18','',''),(2362706,'1','197','1018',464,'Retail Sale Id 1398827',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 12:06:19','',''),(2362787,'1','197','1018',464,'Retail Sale Id 1398906',1000.48,0.00,0.00,1.69,74.36,'2021-12-24 12:13:56','',''),(2362805,'1','197','1018',464,'Retail Sale Id 1398928',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 12:16:34','',''),(2362852,'1','197','1018',464,'Retail Sale Id 1398972',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 12:22:22','',''),(2362976,'1','197','1018',464,'Retail Sale Id 1399097',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 12:35:35','',''),(2363071,'1','197','1018',464,'Retail Sale Id 1399187',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 12:46:08','',''),(2363087,'1','197','1018',464,'Retail Sale Id 1399205',1799.68,0.00,0.00,3.04,133.76,'2021-12-24 12:47:54','',''),(2363289,'1','197','1018',464,'Retail Sale Id 1399403',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 13:08:28','',''),(2363307,'1','197','1018',464,'Retail Sale Id 1399426',3700.00,0.00,0.00,6.25,275.00,'2021-12-24 13:10:56','',''),(2363455,'1','197','1018',464,'Retail Sale Id 1399562',1799.68,0.00,0.00,3.04,133.76,'2021-12-24 13:25:23','',''),(2363506,'1','197','1018',464,'Retail Sale Id 1399604',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 13:29:32','',''),(2363633,'1','197','1018',464,'Retail Sale Id 1399696',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 13:37:50','',''),(2363641,'1','197','1018',464,'Retail Sale Id 1399704',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 13:38:44','',''),(2363955,'1','197','1018',464,'Retail Sale Id 1399923',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 13:59:19','',''),(2364149,'1','197','1018',464,'Retail Sale Id 1400081',1000.48,0.00,0.00,1.69,74.36,'2021-12-24 14:11:01','',''),(2364302,'1','197','1018',464,'Retail Sale Id 1400199',51800.00,0.00,0.00,87.50,3850.00,'2021-12-24 14:22:10','',''),(2364364,'1','197','1018',464,'Retail Sale Id 1400260',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 14:27:04','',''),(2364377,'1','197','1018',464,'Retail Sale Id 1400275',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 14:28:38','',''),(2364568,'1','197','1018',464,'Retail Sale Id 1400424',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 14:44:23','',''),(2364922,'1','197','1018',464,'Retail Sale Id 1400649',4801.12,0.00,0.00,8.11,356.84,'2021-12-24 15:04:54','',''),(2365039,'1','197','1018',464,'Retail Sale Id 1400755',121208.00,0.00,0.00,218.00,1744.00,'2021-12-24 15:15:12','',''),(2365060,'1','197','1018',464,'Retail Sale Id 1400763',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 15:16:12','',''),(2365261,'1','197','1018',464,'Retail Sale Id 1400944',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 15:31:51','',''),(2365442,'1','197','1018',464,'Retail Sale Id 1401148',8797.12,0.00,0.00,14.86,653.84,'2021-12-24 15:47:38','',''),(2365454,'1','197','1018',464,'Retail Sale Id 1401159',8447.84,0.00,0.00,14.27,627.88,'2021-12-24 15:48:44','',''),(2365533,'1','197','1018',464,'Retail Sale Id 1401224',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 15:54:44','',''),(2365597,'1','197','1018',464,'Retail Sale Id 1401284',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 16:01:35','',''),(2365669,'1','197','1018',464,'Retail Sale Id 1401337',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 16:06:44','',''),(2365787,'1','197','1018',464,'Retail Sale Id 1401379',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 16:10:19','',''),(2365847,'1','197','1018',464,'Retail Sale Id 1401413',4001.92,0.00,0.00,6.76,297.44,'2021-12-24 16:12:47','',''),(2365949,'1','197','1018',464,'Retail Sale Id 1401511',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 16:21:01','',''),(2365972,'1','197','1018',464,'Retail Sale Id 1401535',52708.80,0.00,0.00,94.80,758.40,'2021-12-24 16:22:54','',''),(2365996,'1','197','1018',464,'Retail Sale Id 1401558',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 16:24:47','',''),(2366027,'1','197','1018',464,'Retail Sale Id 1401589',4001.92,0.00,0.00,6.76,297.44,'2021-12-24 16:27:17','',''),(2366210,'1','197','1018',464,'Retail Sale Id 1401769',6002.88,0.00,0.00,10.14,446.16,'2021-12-24 16:40:41','',''),(2366226,'1','197','1018',464,'Retail Sale Id 1401789',1000.48,0.00,0.00,1.69,74.36,'2021-12-24 16:42:08','',''),(2366257,'1','197','1018',464,'Retail Sale Id 1401814',1000.48,0.00,0.00,1.69,74.36,'2021-12-24 16:44:17','',''),(2366282,'1','197','1018',464,'Retail Sale Id 1401828',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 16:45:33','',''),(2366322,'1','197','1018',464,'Retail Sale Id 1401867',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 16:48:07','',''),(2366338,'1','197','1018',464,'Retail Sale Id 1401880',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 16:49:11','',''),(2366518,'1','197','1018',464,'Retail Sale Id 1402051',17997.72,0.00,0.00,32.37,258.96,'2021-12-24 17:02:10','',''),(2366532,'1','197','1018',464,'Retail Sale Id 1402071',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 17:03:07','',''),(2366552,'1','197','1018',464,'Retail Sale Id 1402085',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 17:04:09','',''),(2366566,'1','197','1018',464,'Retail Sale Id 1402096',1799.68,0.00,0.00,3.04,133.76,'2021-12-24 17:05:06','',''),(2366578,'1','197','1018',464,'Retail Sale Id 1402107',2000.96,0.00,0.00,3.38,148.72,'2021-12-24 17:05:59','',''),(2366605,'1','197','1018',464,'Retail Sale Id 1402132',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:07:30','',''),(2366622,'1','197','1018',464,'Retail Sale Id 1402146',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 17:08:23','',''),(2366668,'1','197','1018',464,'Retail Sale Id 1402190',2000.96,0.00,0.00,3.38,148.72,'2021-12-24 17:11:34','',''),(2366691,'1','197','1018',464,'Retail Sale Id 1402214',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 17:13:21','',''),(2366707,'1','197','1018',464,'Retail Sale Id 1402228',11676.00,0.00,0.00,21.00,168.00,'2021-12-24 17:14:31','',''),(2366725,'1','197','1018',464,'Retail Sale Id 1402242',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 17:15:44','',''),(2366726,'1','197','1018',464,'Retail Sale Id 1402242',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 17:15:44','',''),(2366727,'1','197','1018',464,'Retail Sale Id 1402242',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:15:44','',''),(2366756,'1','197','1018',464,'Retail Sale Id 1402257',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 17:16:59','',''),(2366841,'1','197','1018',464,'Retail Sale Id 1402341',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 17:24:58','',''),(2366850,'1','197','1018',464,'Retail Sale Id 1402350',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:25:44','',''),(2366882,'1','197','1018',464,'Retail Sale Id 1402381',5002.40,0.00,0.00,8.45,371.80,'2021-12-24 17:29:29','',''),(2366893,'1','197','1018',464,'Retail Sale Id 1402391',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:31:01','',''),(2366912,'1','197','1018',464,'Retail Sale Id 1402403',3599.36,0.00,0.00,6.08,267.52,'2021-12-24 17:32:53','',''),(2367038,'1','197','1018',464,'Retail Sale Id 1402512',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:46:46','',''),(2367065,'1','197','1018',464,'Retail Sale Id 1402537',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:49:52','',''),(2367144,'1','197','1018',464,'Retail Sale Id 1402597',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 17:56:58','',''),(2367216,'1','197','1018',464,'Retail Sale Id 1402625',7400.00,0.00,0.00,12.50,550.00,'2021-12-24 18:02:53','',''),(2367274,'1','197','1018',464,'Retail Sale Id 1402681',1799.68,0.00,0.00,3.04,133.76,'2021-12-24 18:11:41','',''),(2367288,'1','197','1018',464,'Retail Sale Id 1402694',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 18:13:17','',''),(2367294,'1','197','1018',464,'Retail Sale Id 1402700',2000.96,0.00,0.00,3.38,148.72,'2021-12-24 18:14:28','',''),(2367303,'1','197','1018',464,'Retail Sale Id 1402706',3001.44,0.00,0.00,5.07,223.08,'2021-12-24 18:16:01','',''),(2367478,'1','197','1018',464,'Retail Sale Id 1402849',21244.76,0.00,0.00,38.21,305.68,'2021-12-24 18:49:52','',''),(2367485,'1','197','1018',464,'Retail Sale Id 1402857',14800.00,0.00,0.00,25.00,1100.00,'2021-12-24 18:51:12','',''),(2367489,'1','197','1018',464,'Retail Sale Id 1402862',3244.16,0.00,0.00,5.48,241.12,'2021-12-24 18:52:07','',''),(2368252,'1','197','1018',464,'Retail Sale Id 1403126',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 06:28:31','',''),(2368279,'1','197','1018',464,'Retail Sale Id 1403152',314140.00,0.00,0.00,565.00,4520.00,'2021-12-25 06:34:16','',''),(2368294,'1','197','1018',464,'Retail Sale Id 1403168',3498.72,0.00,0.00,5.91,260.04,'2021-12-25 06:36:31','',''),(2368520,'1','197','1018',464,'Retail Sale Id 1403410',1799.68,0.00,0.00,3.04,133.76,'2021-12-25 07:08:38','',''),(2368575,'1','197','1018',464,'Retail Sale Id 1403470',3001.44,0.00,0.00,5.07,223.08,'2021-12-25 07:15:30','',''),(2368576,'1','197','1018',464,'Retail Sale Id 1403470',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 07:15:30','',''),(2368577,'1','197','1018',464,'Retail Sale Id 1403470',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 07:15:30','',''),(2368603,'1','197','1018',464,'Retail Sale Id 1403484',3336.00,0.00,0.00,6.00,48.00,'2021-12-25 07:16:40','',''),(2368636,'1','197','1018',464,'Retail Sale Id 1403515',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 07:19:31','',''),(2368648,'1','197','1018',464,'Retail Sale Id 1403535',5920.00,0.00,0.00,10.00,440.00,'2021-12-25 07:21:04','',''),(2368712,'1','197','1018',464,'Retail Sale Id 1403577',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 07:24:31','',''),(2368877,'1','197','1018',464,'Retail Sale Id 1403713',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 07:38:01','',''),(2368898,'1','197','1018',464,'Retail Sale Id 1403734',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 07:40:46','',''),(2368936,'1','197','1018',464,'Retail Sale Id 1403781',1799.68,0.00,0.00,3.04,133.76,'2021-12-25 07:45:27','',''),(2368982,'1','197','1018',464,'Retail Sale Id 1403828',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 07:50:43','',''),(2369117,'1','197','1018',464,'Retail Sale Id 1403962',4001.92,0.00,0.00,6.76,297.44,'2021-12-25 08:02:43','',''),(2369165,'1','197','1018',464,'Retail Sale Id 1403995',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 08:05:54','',''),(2369223,'1','197','1018',464,'Retail Sale Id 1404059',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 08:11:11','',''),(2369386,'1','197','1018',464,'Retail Sale Id 1404223',2000.96,0.00,0.00,3.38,148.72,'2021-12-25 08:24:01','',''),(2369435,'1','197','1018',464,'Retail Sale Id 1404238',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 08:25:22','',''),(2369462,'1','197','1018',464,'Retail Sale Id 1404262',14800.00,0.00,0.00,25.00,1100.00,'2021-12-25 08:27:32','',''),(2369483,'1','197','1018',464,'Retail Sale Id 1404283',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 08:29:00','',''),(2369547,'1','197','1018',464,'Retail Sale Id 1404339',3001.44,0.00,0.00,5.07,223.08,'2021-12-25 08:33:50','',''),(2369597,'1','197','1018',464,'Retail Sale Id 1404392',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 08:38:21','',''),(2369612,'1','197','1018',464,'Retail Sale Id 1404410',3498.72,0.00,0.00,5.91,260.04,'2021-12-25 08:39:42','',''),(2369747,'1','197','1018',464,'Retail Sale Id 1404511',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 08:49:12','',''),(2369896,'1','197','1018',464,'Retail Sale Id 1404668',27800.00,0.00,0.00,50.00,400.00,'2021-12-25 09:01:30','',''),(2369935,'1','197','1018',464,'Retail Sale Id 1404708',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 09:05:30','',''),(2370528,'1','197','1018',464,'Retail Sale Id 1405213',16001.76,0.00,0.00,27.03,1189.32,'2021-12-25 09:55:15','',''),(2370545,'1','197','1018',464,'Retail Sale Id 1405231',4001.92,0.00,0.00,6.76,297.44,'2021-12-25 09:57:15','',''),(2370563,'1','197','1018',464,'Retail Sale Id 1405250',5002.40,0.00,0.00,8.45,371.80,'2021-12-25 09:58:16','',''),(2371127,'1','197','1018',464,'Retail Sale Id 1405767',3001.44,0.00,0.00,5.07,223.08,'2021-12-25 10:57:09','',''),(2371135,'1','197','1018',464,'Retail Sale Id 1405788',9199.68,0.00,0.00,15.54,683.76,'2021-12-25 10:57:48','',''),(2371161,'1','197','1018',464,'Retail Sale Id 1405811',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 11:00:14','',''),(2371180,'1','197','1018',464,'Retail Sale Id 1405827',3001.44,0.00,0.00,5.07,223.08,'2021-12-25 11:02:06','',''),(2371192,'1','197','1018',464,'Retail Sale Id 1405843',2000.96,0.00,0.00,3.38,148.72,'2021-12-25 11:03:25','',''),(2371213,'1','197','1018',464,'Retail Sale Id 1405853',1201.76,0.00,0.00,2.03,89.32,'2021-12-25 11:04:55','',''),(2371232,'1','197','1018',464,'Retail Sale Id 1405877',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 11:06:19','',''),(2371291,'1','197','1018',464,'Retail Sale Id 1405915',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 11:11:12','',''),(2371325,'1','197','1018',464,'Retail Sale Id 1405976',1799.68,0.00,0.00,3.04,133.76,'2021-12-25 11:14:35','',''),(2371344,'1','197','1018',464,'Retail Sale Id 1405995',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 11:16:47','',''),(2371434,'1','197','1018',464,'Retail Sale Id 1406150',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 11:27:12','',''),(2371634,'1','197','1018',464,'Retail Sale Id 1406349',25020.00,0.00,0.00,45.00,360.00,'2021-12-25 11:49:28','',''),(2371643,'1','197','1018',464,'Retail Sale Id 1406363',3498.72,0.00,0.00,5.91,260.04,'2021-12-25 11:50:36','',''),(2371725,'1','197','1018',464,'Retail Sale Id 1406434',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 12:01:18','',''),(2371890,'1','197','1018',464,'Retail Sale Id 1406598',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 12:21:01','',''),(2371928,'1','197','1018',464,'Retail Sale Id 1406636',6002.88,0.00,0.00,10.14,446.16,'2021-12-25 12:25:27','',''),(2372112,'1','197','1018',464,'Retail Sale Id 1406821',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 12:46:51','',''),(2372151,'1','197','1018',464,'Retail Sale Id 1406852',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 12:50:02','',''),(2372160,'1','197','1018',464,'Retail Sale Id 1406861',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 12:51:14','',''),(2372360,'1','197','1018',464,'Retail Sale Id 1407028',3001.44,0.00,0.00,5.07,223.08,'2021-12-25 13:11:35','',''),(2372376,'1','197','1018',464,'Retail Sale Id 1407033',1497.76,0.00,0.00,2.53,111.32,'2021-12-25 13:12:41','',''),(2372890,'1','197','1018',464,'Retail Sale Id 1407309',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 13:53:49','',''),(2373178,'1','197','1018',464,'Retail Sale Id 1407481',14800.00,0.00,0.00,25.00,1100.00,'2021-12-25 14:22:33','',''),(2373301,'1','197','1018',464,'Retail Sale Id 1407573',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 14:39:18','',''),(2373321,'1','197','1018',464,'Retail Sale Id 1407594',6002.88,0.00,0.00,10.14,446.16,'2021-12-25 14:42:22','',''),(2373637,'1','197','1018',464,'Retail Sale Id 1407859',1799.68,0.00,0.00,3.04,133.76,'2021-12-25 15:39:28','',''),(2373661,'1','197','1018',464,'Retail Sale Id 1407883',2000.96,0.00,0.00,3.38,148.72,'2021-12-25 15:43:37','',''),(2373669,'1','197','1018',464,'Retail Sale Id 1407893',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 15:44:46','',''),(2373932,'1','197','1018',464,'Retail Sale Id 1408082',14800.00,0.00,0.00,25.00,1100.00,'2021-12-25 16:12:57','',''),(2373956,'1','197','1018',464,'Retail Sale Id 1408105',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 16:17:09','',''),(2374063,'1','197','1018',464,'Retail Sale Id 1408208',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 16:41:19','',''),(2374101,'1','197','1018',464,'Retail Sale Id 1408243',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 16:52:35','',''),(2374128,'1','197','1018',464,'Retail Sale Id 1408260',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 16:59:30','',''),(2374135,'1','197','1018',464,'Retail Sale Id 1408268',95798.80,0.00,0.00,172.30,1378.40,'2021-12-25 17:01:16','',''),(2374149,'1','197','1018',464,'Retail Sale Id 1408283',1799.68,0.00,0.00,3.04,133.76,'2021-12-25 17:05:17','',''),(2374208,'1','197','1018',464,'Retail Sale Id 1408322',3599.36,0.00,0.00,6.08,267.52,'2021-12-25 17:19:47','',''),(2374215,'1','197','1018',464,'Retail Sale Id 1408326',1497.76,0.00,0.00,2.53,111.32,'2021-12-25 17:22:09','',''),(2374232,'1','197','1018',464,'Retail Sale Id 1408342',1201.76,0.00,0.00,2.03,89.32,'2021-12-25 17:29:19','',''),(2374237,'1','197','1018',464,'Retail Sale Id 1408347',7400.00,0.00,0.00,12.50,550.00,'2021-12-25 17:31:49','',''),(2374242,'1','197','1018',464,'Retail Sale Id 1408352',5920.00,0.00,0.00,10.00,440.00,'2021-12-25 17:33:48','',''),(2374294,'1','197','1018',464,'Return of Retail Sale Id 1403484',0.00,3336.00,6.00,0.00,-48.00,'2021-12-25 18:20:43','',''),(2374296,'1','197','1018',464,'Retail Sale Id 1408387',2885.64,0.00,0.00,5.19,41.52,'2021-12-25 18:22:44','',''),(2374309,'1','197','1018',464,'Retail Sale Id 1408389',27610.88,0.00,0.00,46.64,2052.16,'2021-12-25 18:29:49','',''),(2375049,'1','197','1018',464,'Retail Sale Id 1408585',25020.00,0.00,0.00,45.00,360.00,'2021-12-26 07:07:17','',''),(2375549,'1','197','1018',464,'Retail Sale Id 1408953',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 08:01:15','',''),(2375585,'1','197','1018',464,'Retail Sale Id 1408971',61160.00,0.00,0.00,110.00,880.00,'2021-12-26 08:05:28','',''),(2375632,'1','197','1018',464,'Retail Sale Id 1409036',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 08:12:39','',''),(2375901,'1','197','1018',464,'Retail Sale Id 1409225',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 08:37:14','',''),(2376365,'1','197','1018',464,'Retail Sale Id 1409570',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 09:22:15','',''),(2376607,'1','197','1018',464,'Retail Sale Id 1409787',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 09:53:16','',''),(2376704,'1','197','1018',464,'Retail Sale Id 1409884',5002.40,0.00,0.00,8.45,371.80,'2021-12-26 10:05:13','',''),(2376723,'1','197','1018',464,'Retail Sale Id 1409901',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 10:07:24','',''),(2376735,'1','197','1018',464,'Retail Sale Id 1409916',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 10:09:08','',''),(2376741,'1','197','1018',464,'Retail Sale Id 1409920',2397.60,0.00,0.00,4.05,178.20,'2021-12-26 10:10:03','',''),(2376843,'1','197','1018',464,'Retail Sale Id 1410018',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 10:26:11','',''),(2377044,'1','197','1018',464,'Retail Sale Id 1410193',14800.00,0.00,0.00,25.00,1100.00,'2021-12-26 10:46:28','',''),(2377084,'1','197','1018',464,'Retail Sale Id 1410231',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 10:52:29','',''),(2377091,'1','197','1018',464,'Retail Sale Id 1410238',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 10:53:19','',''),(2377155,'1','197','1018',464,'Retail Sale Id 1410293',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 11:00:02','',''),(2377162,'1','197','1018',464,'Retail Sale Id 1410300',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 11:01:03','',''),(2377199,'1','197','1018',464,'Retail Sale Id 1410329',1000.48,0.00,0.00,1.69,74.36,'2021-12-26 11:05:28','',''),(2377288,'1','197','1018',464,'Retail Sale Id 1410410',14800.00,0.00,0.00,25.00,1100.00,'2021-12-26 11:15:49','',''),(2377308,'1','197','1018',464,'Retail Sale Id 1410432',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 11:18:12','',''),(2377319,'1','197','1018',464,'Retail Sale Id 1410443',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 11:19:22','',''),(2377383,'1','197','1018',464,'Retail Sale Id 1410505',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 11:27:21','',''),(2377409,'1','197','1018',464,'Retail Sale Id 1410530',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 11:31:35','',''),(2377481,'1','197','1018',464,'Retail Sale Id 1410590',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 11:39:01','',''),(2377629,'1','197','1018',464,'Retail Sale Id 1410708',14800.00,0.00,0.00,25.00,1100.00,'2021-12-26 11:58:57','',''),(2377759,'1','197','1018',464,'Retail Sale Id 1410806',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 12:12:36','',''),(2378035,'1','197','1018',464,'Retail Sale Id 1411039',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 12:43:55','',''),(2378115,'1','197','1018',464,'Retail Sale Id 1411122',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 12:55:25','',''),(2378152,'1','197','1018',464,'Retail Sale Id 1411135',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 13:01:39','',''),(2378258,'1','197','1018',464,'Retail Sale Id 1411244',1000.48,0.00,0.00,1.69,74.36,'2021-12-26 13:18:36','',''),(2378308,'1','197','1018',464,'Retail Sale Id 1411293',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 13:28:05','',''),(2378461,'1','197','1018',464,'Retail Sale Id 1411404',1302.40,0.00,0.00,2.20,96.80,'2021-12-26 13:50:06','',''),(2378474,'1','197','1018',464,'Retail Sale Id 1411406',2498.24,0.00,0.00,4.22,185.68,'2021-12-26 13:51:09','',''),(2378486,'1','197','1018',464,'Retail Sale Id 1411418',36140.00,0.00,0.00,65.00,520.00,'2021-12-26 13:53:23','',''),(2378498,'1','197','1018',464,'Retail Sale Id 1411427',12232.00,0.00,0.00,22.00,176.00,'2021-12-26 13:55:16','',''),(2378502,'1','197','1018',464,'Retail Sale Id 1411432',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 13:55:53','',''),(2378672,'1','197','1018',464,'Retail Sale Id 1411518',11840.00,0.00,0.00,20.00,880.00,'2021-12-26 14:09:32','',''),(2378698,'1','197','1018',464,'Retail Sale Id 1411540',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 14:15:07','',''),(2378881,'1','197','1018',464,'Retail Sale Id 1411659',3700.00,0.00,0.00,6.25,275.00,'2021-12-26 14:35:30','',''),(2379020,'1','197','1018',464,'Retail Sale Id 1411733',2000.96,0.00,0.00,3.38,148.72,'2021-12-26 14:51:03','',''),(2379026,'1','197','1018',464,'Retail Sale Id 1411740',1000.48,0.00,0.00,1.69,74.36,'2021-12-26 14:52:04','',''),(2379044,'1','197','1018',464,'Retail Sale Id 1411749',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 14:53:22','',''),(2379284,'1','197','1018',464,'Retail Sale Id 1411932',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 15:20:38','',''),(2379430,'1','197','1018',464,'Return of Retail Sale Id 1410708',0.00,14800.00,25.00,0.00,-1100.00,'2021-12-26 15:35:18','',''),(2379433,'1','197','1018',464,'Return of Retail Sale Id 1411932',0.00,7400.00,12.50,0.00,-550.00,'2021-12-26 15:35:58','',''),(2379440,'1','197','1018',464,'Retail Sale Id 1412016',745.92,0.00,0.00,1.26,55.44,'2021-12-26 15:37:16','',''),(2379500,'1','197','1018',464,'Retail Sale Id 1412056',68635.00,0.00,0.00,129.50,-2331.00,'2021-12-26 15:44:16','',''),(2379513,'1','197','1018',464,'Retail Sale Id 1412068',153700.00,0.00,0.00,290.00,-5220.00,'2021-12-26 15:46:09','',''),(2379533,'1','197','1018',464,'Retail Sale Id 1412086',13250.00,0.00,0.00,25.00,-450.00,'2021-12-26 15:49:20','',''),(2379570,'1','197','1018',464,'Retail Sale Id 1412122',3001.44,0.00,0.00,5.07,223.08,'2021-12-26 15:54:47','',''),(2379581,'1','197','1018',464,'Retail Sale Id 1412133',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 15:57:36','',''),(2379681,'1','197','1018',464,'Retail Sale Id 1412245',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 16:12:42','',''),(2379708,'1','197','1018',464,'Retail Sale Id 1412269',5002.40,0.00,0.00,8.45,371.80,'2021-12-26 16:17:57','',''),(2379782,'1','197','1018',464,'Retail Sale Id 1412338',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 16:30:20','',''),(2379809,'1','197','1018',464,'Retail Sale Id 1412373',1799.68,0.00,0.00,3.04,133.76,'2021-12-26 16:38:44','',''),(2379955,'1','197','1018',464,'Retail Sale Id 1412516',14800.00,0.00,0.00,25.00,1100.00,'2021-12-26 17:35:56','',''),(2379957,'1','197','1018',464,'Retail Sale Id 1412517',3599.36,0.00,0.00,6.08,267.52,'2021-12-26 17:36:32','',''),(2379998,'1','197','1018',464,'Retail Sale Id 1412527',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 17:56:07','',''),(2380202,'1','197','1018',464,'Retail Sale Id 1412587',14800.00,0.00,0.00,25.00,1100.00,'2021-12-26 19:46:15','',''),(2380210,'1','197','1018',464,'Retail Sale Id 1412588',7400.00,0.00,0.00,12.50,550.00,'2021-12-26 19:46:42','',''),(2380211,'1','197','1018',464,'Retail Sale Id 1412589',6701.44,0.00,0.00,11.32,498.08,'2021-12-26 19:47:11','',''),(2381372,'1','197','1018',464,'Retail Sale Id 1413225',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 08:09:25','',''),(2381701,'1','197','1018',464,'Retail Sale Id 1413517',1799.68,0.00,0.00,3.04,133.76,'2021-12-27 08:40:27','',''),(2381740,'1','197','1018',464,'Retail Sale Id 1413553',26500.00,0.00,0.00,50.00,-900.00,'2021-12-27 08:43:08','',''),(2381910,'1','197','1018',464,'Retail Sale Id 1413715',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 08:58:55','',''),(2382249,'1','197','1018',464,'Retail Sale Id 1414042',111300.00,0.00,0.00,210.00,-3780.00,'2021-12-27 09:31:03','',''),(2382262,'1','197','1018',464,'Retail Sale Id 1414057',2498.24,0.00,0.00,4.22,185.68,'2021-12-27 09:32:04','',''),(2382320,'1','197','1018',464,'Retail Sale Id 1414103',8880.00,0.00,0.00,15.00,660.00,'2021-12-27 09:37:58','',''),(2382325,'1','197','1018',464,'Retail Sale Id 1414118',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 09:38:40','',''),(2382335,'1','197','1018',464,'Retail Sale Id 1414128',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 09:39:50','',''),(2382470,'1','197','1018',464,'Retail Sale Id 1414255',3599.36,0.00,0.00,6.08,267.52,'2021-12-27 09:53:45','',''),(2382885,'1','197','1018',464,'Retail Sale Id 1414590',9998.88,0.00,0.00,16.89,743.16,'2021-12-27 10:29:25','',''),(2382937,'1','197','1018',464,'Retail Sale Id 1414646',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 10:33:58','',''),(2383021,'1','197','1018',464,'Retail Sale Id 1414729',1799.68,0.00,0.00,3.04,133.76,'2021-12-27 10:41:20','',''),(2383045,'1','197','1018',464,'Retail Sale Id 1414753',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 10:43:36','',''),(2383187,'1','197','1018',464,'Retail Sale Id 1414891',2000.96,0.00,0.00,3.38,148.72,'2021-12-27 10:59:07','',''),(2383429,'1','197','1018',464,'Retail Sale Id 1415111',18399.36,0.00,0.00,31.08,1367.52,'2021-12-27 11:23:28','',''),(2383443,'1','197','1018',464,'Retail Sale Id 1415124',3599.36,0.00,0.00,6.08,267.52,'2021-12-27 11:24:37','',''),(2383558,'1','197','1018',464,'Retail Sale Id 1415248',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 11:39:08','',''),(2383674,'1','197','1018',464,'Retail Sale Id 1415344',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 11:51:31','',''),(2384251,'1','197','1018',464,'Retail Sale Id 1415802',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 13:10:36','',''),(2384275,'1','197','1018',464,'Retail Sale Id 1415828',2800.16,0.00,0.00,4.73,208.12,'2021-12-27 13:14:04','',''),(2384332,'1','197','1018',464,'Retail Sale Id 1415881',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 13:21:39','',''),(2384344,'1','197','1018',464,'Retail Sale Id 1415888',12201.12,0.00,0.00,20.61,906.84,'2021-12-27 13:22:12','',''),(2384411,'1','197','1018',464,'Retail Sale Id 1415937',6002.88,0.00,0.00,10.14,446.16,'2021-12-27 13:30:25','',''),(2384470,'1','197','1018',464,'Retail Sale Id 1415976',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 13:37:00','',''),(2384776,'1','197','1018',464,'Retail Sale Id 1416177',21998.72,0.00,0.00,37.16,1635.04,'2021-12-27 14:15:05','',''),(2384801,'1','197','1018',464,'Retail Sale Id 1416183',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 14:17:24','',''),(2385145,'1','197','1018',464,'Retail Sale Id 1416485',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 15:15:21','',''),(2385150,'1','197','1018',464,'Retail Sale Id 1416491',2699.52,0.00,0.00,4.56,200.64,'2021-12-27 15:16:34','',''),(2385240,'1','197','1018',464,'Retail Sale Id 1416559',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 15:29:22','',''),(2385419,'1','197','1018',464,'Retail Sale Id 1416685',1000.48,0.00,0.00,1.69,74.36,'2021-12-27 15:49:54','',''),(2385452,'1','197','1018',464,'Retail Sale Id 1416703',7400.00,0.00,0.00,12.50,550.00,'2021-12-27 15:52:34','',''),(2385469,'1','197','1018',464,'Retail Sale Id 1416729',2000.96,0.00,0.00,3.38,148.72,'2021-12-27 15:55:14','',''),(2385553,'1','197','1018',464,'Retail Sale Id 1416809',3599.36,0.00,0.00,6.08,267.52,'2021-12-27 16:05:31','',''),(2385575,'1','197','1018',464,'Retail Sale Id 1416833',20720.00,0.00,0.00,35.00,1540.00,'2021-12-27 16:10:06','',''),(2385691,'1','197','1018',464,'Retail Sale Id 1416929',2000.96,0.00,0.00,3.38,148.72,'2021-12-27 16:28:50','',''),(2385762,'1','197','1018',464,'Retail Sale Id 1416992',3001.44,0.00,0.00,5.07,223.08,'2021-12-27 16:42:38','',''),(2385872,'1','197','1018',464,'Retail Sale Id 1417090',25175.00,0.00,0.00,47.50,-855.00,'2021-12-27 17:01:39','',''),(2385889,'1','197','1018',464,'Retail Sale Id 1417107',1799.68,0.00,0.00,3.04,133.76,'2021-12-27 17:06:25','',''),(2385939,'1','197','1018',464,'Retail Sale Id 1417156',1000.48,0.00,0.00,1.69,74.36,'2021-12-27 17:15:50','',''),(2386146,'1','197','1018',464,'Retail Sale Id 1417260',7222.40,0.00,0.00,12.20,536.80,'2021-12-27 18:14:16','',''),(2386325,'1','197','1018',464,'Distributed to ASUK GAS for sales id:342626',19793.76,0.00,0.00,36.12,0.00,'2021-12-27 20:20:59','',''),(2387811,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,510000.00,1000.00,0.00,0.00,'2021-12-28 08:38:49','',''),(2387831,'1','197',NULL,464,'Reception corrector for bridging 128968',0.00,0.00,0.00,1000.00,0.00,'2021-12-28 08:39:56','',''),(2387832,'1','197','1018',464,'Received from bridging 128968',0.00,0.00,1000.00,0.00,0.00,'2021-12-28 08:39:56','',''),(2387836,'1','197','1018',464,'Retail Sale Id 1418278',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 08:40:35','',''),(2387863,'1','197','1018',464,'Retail Sale Id 1418296',6600.80,0.00,0.00,11.15,914.30,'2021-12-28 08:42:37','',''),(2387885,'1','197','1018',464,'Retail Sale Id 1418316',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 08:45:52','',''),(2387940,'1','197','1018',464,'Retail Sale Id 1418373',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 08:51:49','',''),(2387948,'1','197','1018',464,'Retail Sale Id 1418381',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 08:52:51','',''),(2387967,'1','197','1018',464,'Retail Sale Id 1418401',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 08:54:39','',''),(2387980,'1','197','1018',464,'Retail Sale Id 1418414',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 08:56:23','',''),(2388035,'1','197','1018',464,'Retail Sale Id 1418470',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 09:03:10','',''),(2389018,'1','197','1018',464,'Retail Sale Id 1419395',5499.68,0.00,0.00,9.29,761.78,'2021-12-28 10:49:45','',''),(2389025,'1','197','1018',464,'Retail Sale Id 1419404',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 10:50:50','',''),(2389033,'1','197','1018',464,'Retail Sale Id 1419411',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 10:51:30','',''),(2389043,'1','197','1018',464,'Retail Sale Id 1419419',1799.68,0.00,0.00,3.04,249.28,'2021-12-28 10:52:25','',''),(2389054,'1','197','1018',464,'Retail Sale Id 1419431',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 10:53:40','',''),(2389086,'1','197','1018',464,'Retail Sale Id 1419464',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 10:57:15','',''),(2389122,'1','197','1018',464,'Retail Sale Id 1419498',5002.40,0.00,0.00,8.45,692.90,'2021-12-28 11:01:40','',''),(2389193,'1','197','1018',464,'Retail Sale Id 1419547',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 11:07:15','',''),(2389401,'1','197','1018',464,'Retail Sale Id 1419750',5002.40,0.00,0.00,8.45,692.90,'2021-12-28 11:32:54','',''),(2389568,'1','197','1018',464,'Retail Sale Id 1419900',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 11:50:25','',''),(2389973,'1','197','1018',464,'Retail Sale Id 1420215',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 12:26:49','',''),(2390005,'1','197','1018',464,'Retail Sale Id 1420221',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 12:27:40','',''),(2390086,'1','197','1018',464,'Retail Sale Id 1420283',21400.80,0.00,0.00,36.15,2964.30,'2021-12-28 12:35:00','',''),(2390209,'1','197','1018',464,'Retail Sale Id 1420372',6002.88,0.00,0.00,10.14,831.48,'2021-12-28 12:45:58','',''),(2390241,'1','197','1018',464,'Retail Sale Id 1420403',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 12:49:52','',''),(2390412,'1','197','1018',464,'Retail Sale Id 1420535',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:04:35','',''),(2390670,'1','197','1018',464,'Retail Sale Id 1420660',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:30:22','',''),(2390744,'1','197','1018',464,'Retail Sale Id 1420744',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 13:35:21','',''),(2390804,'1','197','1018',464,'Retail Sale Id 1420790',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 13:42:26','',''),(2390922,'1','197','1018',464,'Retail Sale Id 1420886',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 13:55:53','',''),(2391020,'1','197','1018',464,'Retail Sale Id 1420962',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:04:47','',''),(2391389,'1','197','1018',464,'Retail Sale Id 1421238',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:44:41','',''),(2391437,'1','197','1018',464,'Retail Sale Id 1421286',6002.88,0.00,0.00,10.14,831.48,'2021-12-28 14:51:58','',''),(2391444,'1','197','1018',464,'Retail Sale Id 1421295',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 14:53:05','',''),(2391575,'1','197','1018',464,'Retail Sale Id 1421390',10401.44,0.00,0.00,17.57,1440.74,'2021-12-28 15:08:53','',''),(2391587,'1','197','1018',464,'Retail Sale Id 1421391',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 15:09:55','',''),(2391627,'1','197','1018',464,'Retail Sale Id 1421424',7400.00,0.00,0.00,12.50,1025.00,'2021-12-28 15:13:50','',''),(2391632,'1','197','1018',464,'Retail Sale Id 1421426',2498.24,0.00,0.00,4.22,346.04,'2021-12-28 15:14:46','',''),(2391645,'1','197','1018',464,'Retail Sale Id 1421440',1302.40,0.00,0.00,2.20,180.40,'2021-12-28 15:16:14','',''),(2391673,'1','197','1018',464,'Retail Sale Id 1421473',10999.36,0.00,0.00,18.58,1523.56,'2021-12-28 15:20:17','',''),(2391678,'1','197','1018',464,'Retail Sale Id 1421478',2000.96,0.00,0.00,3.38,277.16,'2021-12-28 15:21:09','',''),(2391928,'1','197','1018',464,'Retail Sale Id 1421707',14800.00,0.00,0.00,25.00,2050.00,'2021-12-28 15:51:10','',''),(2392029,'1','197','1018',464,'Retail Sale Id 1421793',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 15:59:32','',''),(2392148,'1','197','1018',464,'Retail Sale Id 1421852',2000.96,0.00,0.00,3.38,277.16,'2021-12-28 16:07:49','',''),(2392400,'1','197','1018',464,'Retail Sale Id 1422004',2000.96,0.00,0.00,3.38,277.16,'2021-12-28 16:29:45','',''),(2392421,'1','197','1018',464,'Retail Sale Id 1422019',15900.00,0.00,0.00,30.00,600.00,'2021-12-28 16:33:21','',''),(2392433,'1','197','1018',464,'Retail Sale Id 1422029',1201.76,0.00,0.00,2.03,166.46,'2021-12-28 16:34:43','',''),(2392476,'1','197','1018',464,'Retail Sale Id 1422066',6002.88,0.00,0.00,10.14,831.48,'2021-12-28 16:40:06','',''),(2392483,'1','197','1018',464,'Retail Sale Id 1422074',3599.36,0.00,0.00,6.08,498.56,'2021-12-28 16:41:31','',''),(2392519,'1','197','1018',464,'Retail Sale Id 1422107',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 16:46:04','',''),(2392629,'1','197','1018',464,'Retail Sale Id 1422206',3001.44,0.00,0.00,5.07,415.74,'2021-12-28 17:01:59','',''),(2392742,'1','197','1018',464,'Retail Sale Id 1422320',39750.00,0.00,0.00,75.00,1500.00,'2021-12-28 17:23:31','',''),(2392858,'1','197','1018',464,'Return of Retail Sale Id 1421707',0.00,14800.00,25.00,0.00,-2050.00,'2021-12-28 18:12:23','',''),(2392860,'1','197','1018',464,'Retail Sale Id 1422382',10401.44,0.00,0.00,17.57,1440.74,'2021-12-28 18:12:59','',''),(2392862,'1','197','1018',464,'Retail Sale Id 1422383',3180.00,0.00,0.00,6.00,120.00,'2021-12-28 18:14:03','',''),(2392878,'1','197','1018',464,'Retail Sale Id 1422392',6014.72,0.00,0.00,10.16,833.12,'2021-12-28 18:29:44','',''),(2392882,'1','197','1018',464,'Return of Retail Sale Id 1422383',0.00,3180.00,6.00,0.00,-120.00,'2021-12-28 18:36:42','',''),(2392884,'1','197','1018',464,'Retail Sale Id 1422394',1791.40,0.00,0.00,3.38,67.60,'2021-12-28 18:38:57','',''),(2392893,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2249100.00,4410.00,0.00,0.00,'2021-12-28 18:56:48','',''),(2392896,'1','197',NULL,464,'Reception corrector for bridging 129036',0.00,0.00,0.00,4410.00,0.00,'2021-12-28 18:58:14','',''),(2392897,'1','197','1018',464,'Received from bridging 129036',0.00,0.00,4410.00,0.00,0.00,'2021-12-28 18:58:14','',''),(2393556,'1','197','1018',464,'Retail Sale Id 1422567',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 06:50:39','',''),(2393562,'1','197','1018',464,'Retail Sale Id 1422582',26500.00,0.00,0.00,50.00,1000.00,'2021-12-29 06:51:34','',''),(2394574,'1','197','1018',464,'Retail Sale Id 1423381',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 08:36:32','',''),(2394740,'1','197','1018',464,'Retail Sale Id 1423526',1497.76,0.00,0.00,2.53,207.46,'2021-12-29 08:51:13','',''),(2394880,'1','197','1018',464,'Retail Sale Id 1423622',1201.76,0.00,0.00,2.03,166.46,'2021-12-29 09:07:52','',''),(2394983,'1','197','1018',464,'Retail Sale Id 1423677',39220.00,0.00,0.00,74.00,1480.00,'2021-12-29 09:15:29','',''),(2395314,'1','197','1018',464,'Retail Sale Id 1423974',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 09:50:40','',''),(2395906,'1','197','1018',464,'Retail Sale Id 1424492',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 10:54:35','',''),(2396078,'1','197','1018',464,'Retail Sale Id 1424649',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 11:11:23','',''),(2396137,'1','197','1018',464,'Retail Sale Id 1424701',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 11:17:26','',''),(2396324,'1','197','1018',464,'Retail Sale Id 1424854',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 11:36:53','',''),(2396331,'1','197','1018',464,'Retail Sale Id 1424859',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 11:38:03','',''),(2396674,'1','197','1018',464,'Retail Sale Id 1425171',11999.84,0.00,0.00,20.27,1662.14,'2021-12-29 12:26:33','',''),(2396765,'1','197','1018',464,'Retail Sale Id 1425250',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 12:36:59','',''),(2396836,'1','197','1018',464,'Retail Sale Id 1425310',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 12:45:24','',''),(2396961,'1','197','1018',464,'Retail Sale Id 1425409',2000.96,0.00,0.00,3.38,277.16,'2021-12-29 13:01:08','',''),(2397122,'1','197','1018',464,'Retail Sale Id 1425545',29150.00,0.00,0.00,55.00,1100.00,'2021-12-29 13:19:48','',''),(2397277,'1','197','1018',464,'Retail Sale Id 1425657',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 13:37:32','',''),(2397345,'1','197','1018',464,'Retail Sale Id 1425710',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 13:45:41','',''),(2397425,'1','197','1018',464,'Retail Sale Id 1425779',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 13:55:01','',''),(2397859,'1','197','1018',464,'Retail Sale Id 1426106',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 14:36:59','',''),(2397929,'1','197','1018',464,'Retail Sale Id 1426153',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 14:43:03','',''),(2398151,'1','197','1018',464,'Retail Sale Id 1426304',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 15:02:29','',''),(2398159,'1','197','1018',464,'Retail Sale Id 1426310',26500.00,0.00,0.00,50.00,1000.00,'2021-12-29 15:04:11','',''),(2398177,'1','197','1018',464,'Retail Sale Id 1426326',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 15:07:10','',''),(2398322,'1','197','1018',464,'Retail Sale Id 1426367',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:14:01','',''),(2398363,'1','197','1018',464,'Retail Sale Id 1426412',14800.00,0.00,0.00,25.00,2050.00,'2021-12-29 15:20:07','',''),(2398382,'1','197','1018',464,'Retail Sale Id 1426430',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:22:04','',''),(2398411,'1','197','1018',464,'Retail Sale Id 1426458',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 15:25:04','',''),(2398478,'1','197','1018',464,'Retail Sale Id 1426492',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:28:30','',''),(2398557,'1','197','1018',464,'Retail Sale Id 1426544',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:34:41','',''),(2398670,'1','197','1018',464,'Retail Sale Id 1426609',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 15:41:16','',''),(2398984,'1','197','1018',464,'Retail Sale Id 1426831',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:12:51','',''),(2398988,'1','197','1018',464,'Retail Sale Id 1426836',3599.36,0.00,0.00,6.08,498.56,'2021-12-29 16:13:28','',''),(2399001,'1','197','1018',464,'Retail Sale Id 1426847',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:15:01','',''),(2399027,'1','197','1018',464,'Retail Sale Id 1426869',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:18:13','',''),(2399053,'1','197','1018',464,'Retail Sale Id 1426894',1000.48,0.00,0.00,1.69,138.58,'2021-12-29 16:20:56','',''),(2399099,'1','197','1018',464,'Retail Sale Id 1426944',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:26:57','',''),(2399154,'1','197','1018',464,'Retail Sale Id 1427000',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:33:02','',''),(2399209,'1','197','1018',464,'Retail Sale Id 1427046',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:39:46','',''),(2399328,'1','197','1018',464,'Retail Sale Id 1427131',7400.00,0.00,0.00,12.50,1025.00,'2021-12-29 16:52:43','',''),(2399339,'1','197','1018',464,'Retail Sale Id 1427140',3001.44,0.00,0.00,5.07,415.74,'2021-12-29 16:53:52','',''),(2399346,'1','197','1018',464,'Retail Sale Id 1427146',1799.68,0.00,0.00,3.04,249.28,'2021-12-29 16:55:20','',''),(2399401,'1','197','1018',464,'Retail Sale Id 1427195',7950.00,0.00,0.00,15.00,300.00,'2021-12-29 17:02:20','',''),(2399574,'1','197','1018',464,'Return of Retail Sale Id 1426944',0.00,7400.00,12.50,0.00,-1025.00,'2021-12-29 18:14:14','',''),(2399577,'1','197','1018',464,'Return of Retail Sale Id 1426894',0.00,1000.48,1.69,0.00,-138.58,'2021-12-29 18:15:36','',''),(2399580,'1','197','1018',464,'Retail Sale Id 1427338',1314.24,0.00,0.00,2.22,182.04,'2021-12-29 18:17:20','',''),(2399606,'1','197','1018',464,'Retail Sale Id 1427354',19875.00,0.00,0.00,37.50,750.00,'2021-12-29 19:05:33','',''),(2400460,'1','197','1018',464,'Retail Sale Id 1427675',22790.00,0.00,0.00,43.00,860.00,'2021-12-30 07:07:11','',''),(2400506,'1','197','1018',464,'Retail Sale Id 1427716',3001.44,0.00,0.00,5.07,415.74,'2021-12-30 07:15:20','',''),(2400507,'1','197','1018',464,'Retail Sale Id 1427716',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 07:15:20','',''),(2401129,'1','197','1018',464,'Retail Sale Id 1428219',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 08:19:38','',''),(2401272,'1','197','1018',464,'Retail Sale Id 1428292',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 08:28:48','',''),(2401287,'1','197','1018',464,'Retail Sale Id 1428309',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 08:30:40','',''),(2401557,'1','197','1018',464,'Retail Sale Id 1428489',29600.00,0.00,0.00,50.00,4100.00,'2021-12-30 08:49:20','',''),(2402174,'1','197','1018',464,'Retail Sale Id 1428995',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 09:42:45','',''),(2402342,'1','197','1018',464,'Retail Sale Id 1429153',73140.00,0.00,0.00,138.00,2760.00,'2021-12-30 09:58:25','',''),(2402380,'1','197','1018',464,'Retail Sale Id 1429195',2498.24,0.00,0.00,4.22,346.04,'2021-12-30 10:02:12','',''),(2402667,'1','197','1018',464,'Retail Sale Id 1429478',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 10:32:17','',''),(2402934,'1','197','1018',464,'Retail Sale Id 1429660',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 10:53:42','',''),(2403053,'1','197','1018',464,'Retail Sale Id 1429790',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 11:08:15','',''),(2403150,'1','197','1018',464,'Retail Sale Id 1429872',144160.00,0.00,0.00,272.00,5440.00,'2021-12-30 11:18:35','',''),(2403160,'1','197','1018',464,'Retail Sale Id 1429881',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 11:19:50','',''),(2403439,'1','197','1018',464,'Retail Sale Id 1430159',6002.88,0.00,0.00,10.14,831.48,'2021-12-30 11:58:13','',''),(2403681,'1','197','1018',464,'Retail Sale Id 1430386',37100.00,0.00,0.00,70.00,1400.00,'2021-12-30 12:31:22','',''),(2403839,'1','197','1018',464,'Retail Sale Id 1430532',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 12:52:42','',''),(2403861,'1','197','1018',464,'Retail Sale Id 1430553',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 12:55:40','',''),(2404189,'1','197','1018',464,'Retail Sale Id 1430784',132500.00,0.00,0.00,250.00,5000.00,'2021-12-30 13:28:44','',''),(2404219,'1','197','1018',464,'Retail Sale Id 1430803',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 13:30:45','',''),(2404278,'1','197','1018',464,'Retail Sale Id 1430838',1799.68,0.00,0.00,3.04,249.28,'2021-12-30 13:35:00','',''),(2404279,'1','197','1018',464,'Retail Sale Id 1430838',5002.40,0.00,0.00,8.45,692.90,'2021-12-30 13:35:00','',''),(2404280,'1','197','1018',464,'Retail Sale Id 1430838',6002.88,0.00,0.00,10.14,831.48,'2021-12-30 13:35:00','',''),(2405089,'1','197','1018',464,'Retail Sale Id 1431491',14800.00,0.00,0.00,25.00,2050.00,'2021-12-30 14:57:11','',''),(2405103,'1','197','1018',464,'Retail Sale Id 1431501',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 14:58:21','',''),(2405104,'1','197','1018',464,'Retail Sale Id 1431501',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 14:58:21','',''),(2405160,'1','197','1018',464,'Retail Sale Id 1431554',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 15:06:28','',''),(2405161,'1','197','1018',464,'Retail Sale Id 1431554',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:06:28','',''),(2405220,'1','197','1018',464,'Retail Sale Id 1431617',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 15:12:14','',''),(2405287,'1','197','1018',464,'Retail Sale Id 1431681',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:18:51','',''),(2405501,'1','197','1018',464,'Retail Sale Id 1431856',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:41:01','',''),(2405534,'1','197','1018',464,'Retail Sale Id 1431885',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 15:43:47','',''),(2405565,'1','197','1018',464,'Retail Sale Id 1431905',3001.44,0.00,0.00,5.07,415.74,'2021-12-30 15:46:14','',''),(2405621,'1','197','1018',464,'Retail Sale Id 1431940',2000.96,0.00,0.00,3.38,277.16,'2021-12-30 15:50:11','',''),(2405622,'1','197','1018',464,'Retail Sale Id 1431940',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 15:50:11','',''),(2405652,'1','197','1018',464,'Retail Sale Id 1431961',34450.00,0.00,0.00,65.00,1300.00,'2021-12-30 15:53:35','',''),(2405720,'1','197','1018',464,'Retail Sale Id 1432032',48230.00,0.00,0.00,91.00,1820.00,'2021-12-30 15:59:37','',''),(2405893,'1','197','1018',464,'Retail Sale Id 1432204',29600.00,0.00,0.00,50.00,4100.00,'2021-12-30 16:14:42','',''),(2406046,'1','197','1018',464,'Retail Sale Id 1432354',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 16:29:51','',''),(2406067,'1','197','1018',464,'Retail Sale Id 1432375',3001.44,0.00,0.00,5.07,415.74,'2021-12-30 16:32:08','',''),(2406192,'1','197','1018',464,'Retail Sale Id 1432486',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 16:41:50','',''),(2406556,'1','197','1018',464,'Retail Sale Id 1432749',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 17:21:52','',''),(2406628,'1','197','1018',464,'Retail Sale Id 1432829',3599.36,0.00,0.00,6.08,498.56,'2021-12-30 17:49:58','',''),(2406637,'1','197','1018',464,'Retail Sale Id 1432833',5002.40,0.00,0.00,8.45,692.90,'2021-12-30 17:52:03','',''),(2406798,'1','197','1018',464,'Retail Sale Id 1432888',26500.00,0.00,0.00,50.00,1000.00,'2021-12-30 19:41:13','',''),(2406801,'1','197','1018',464,'Retail Sale Id 1432889',11273.10,0.00,0.00,21.27,425.40,'2021-12-30 19:42:03','',''),(2406804,'1','197','1018',464,'Retail Sale Id 1432890',14800.00,0.00,0.00,25.00,2050.00,'2021-12-30 19:44:59','',''),(2406805,'1','197','1018',464,'Retail Sale Id 1432891',7400.00,0.00,0.00,12.50,1025.00,'2021-12-30 19:46:02','',''),(2406806,'1','197','1018',464,'Retail Sale Id 1432892',14800.00,0.00,0.00,25.00,2050.00,'2021-12-30 19:46:40','',''),(2406807,'1','197','1018',464,'Retail Sale Id 1432893',2291.04,0.00,0.00,3.87,317.34,'2021-12-30 19:48:02','',''),(2406808,'1','197','1018',464,'Retail Sale Id 1432894',14800.00,0.00,0.00,25.00,2050.00,'2021-12-30 19:48:46','',''),(2406820,'1','197','1018',464,'Retail Sale Id 1432895',1201.76,0.00,0.00,2.03,166.46,'2021-12-30 19:49:58','',''),(2407838,'1','197','1018',464,'Retail Sale Id 1433370',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 07:22:44','',''),(2407863,'1','197','1018',464,'Retail Sale Id 1433389',28001.60,0.00,0.00,47.30,3878.60,'2021-12-31 07:24:57','',''),(2407929,'1','197','1018',464,'Retail Sale Id 1433425',1201.76,0.00,0.00,2.03,166.46,'2021-12-31 07:28:21','',''),(2408058,'1','197','1018',464,'Retail Sale Id 1433516',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 07:37:31','',''),(2408075,'1','197','1018',464,'Retail Sale Id 1433530',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 07:39:26','',''),(2408090,'1','197','1018',464,'Retail Sale Id 1433544',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 07:40:52','',''),(2408367,'1','197','1018',464,'Retail Sale Id 1433758',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:04:28','',''),(2408620,'1','197','1018',464,'Retail Sale Id 1433982',6997.44,0.00,0.00,11.82,969.24,'2021-12-31 08:25:16','',''),(2408672,'1','197','1018',464,'Retail Sale Id 1434037',799.20,0.00,0.00,1.35,110.70,'2021-12-31 08:30:05','',''),(2408718,'1','197','1018',464,'Retail Sale Id 1434093',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 08:34:45','',''),(2408827,'1','197','1018',464,'Retail Sale Id 1434180',14800.00,0.00,0.00,25.00,2050.00,'2021-12-31 08:42:14','',''),(2409058,'1','197','1018',464,'Retail Sale Id 1434380',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 09:00:35','',''),(2410647,'1','197','1018',464,'Retail Sale Id 1435789',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 11:47:17','',''),(2410660,'1','197','1018',464,'Retail Sale Id 1435808',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 11:48:57','',''),(2410675,'1','197','1018',464,'Retail Sale Id 1435824',53000.00,0.00,0.00,100.00,2000.00,'2021-12-31 11:50:22','',''),(2410687,'1','197','1018',464,'Retail Sale Id 1435837',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 11:52:04','',''),(2410744,'1','197','1018',464,'Retail Sale Id 1435886',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 11:58:45','',''),(2410764,'1','197','1018',464,'Retail Sale Id 1435906',95400.00,0.00,0.00,180.00,3600.00,'2021-12-31 12:01:21','',''),(2410774,'1','197','1018',464,'Retail Sale Id 1435915',8880.00,0.00,0.00,15.00,1230.00,'2021-12-31 12:03:30','',''),(2410844,'1','197','1018',464,'Retail Sale Id 1435986',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 12:14:12','',''),(2410864,'1','197','1018',464,'Retail Sale Id 1436006',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 12:17:02','',''),(2410869,'1','197','1018',464,'Retail Sale Id 1436013',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 12:18:28','',''),(2410884,'1','197','1018',464,'Retail Sale Id 1436029',3001.44,0.00,0.00,5.07,415.74,'2021-12-31 12:20:33','',''),(2410904,'1','197','1018',464,'Retail Sale Id 1436048',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 12:22:49','',''),(2410943,'1','197','1018',464,'Retail Sale Id 1436088',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 12:28:53','',''),(2410972,'1','197','1018',464,'Retail Sale Id 1436118',6500.16,0.00,0.00,10.98,900.36,'2021-12-31 12:34:09','',''),(2411084,'1','197','1018',464,'Retail Sale Id 1436221',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 12:58:03','',''),(2411113,'1','197','1018',464,'Retail Sale Id 1436247',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 13:02:39','',''),(2411195,'1','197','1018',464,'Retail Sale Id 1436337',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 13:17:20','',''),(2411342,'1','197','1018',464,'Retail Sale Id 1436473',34980.00,0.00,0.00,66.00,1320.00,'2021-12-31 13:35:26','',''),(2411382,'1','197','1018',464,'Retail Sale Id 1436521',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 13:40:57','',''),(2411398,'1','197','1018',464,'Retail Sale Id 1436535',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 13:42:27','',''),(2411453,'1','197','1018',464,'Retail Sale Id 1436598',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 13:48:48','',''),(2411479,'1','197','1018',464,'Retail Sale Id 1436630',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 13:51:18','',''),(2411545,'1','197','1018',464,'Retail Sale Id 1436692',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 13:56:55','',''),(2411738,'1','197','1018',464,'Retail Sale Id 1436813',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 14:10:24','',''),(2411798,'1','197','1018',464,'Retail Sale Id 1436869',1000.48,0.00,0.00,1.69,138.58,'2021-12-31 14:15:38','',''),(2412908,'1','197','1018',464,'Retail Sale Id 1437722',14800.00,0.00,0.00,25.00,2050.00,'2021-12-31 15:44:57','',''),(2412919,'1','197','1018',464,'Retail Sale Id 1437734',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 15:46:19','',''),(2412930,'1','197','1018',464,'Retail Sale Id 1437745',4001.92,0.00,0.00,6.76,554.32,'2021-12-31 15:47:07','',''),(2412940,'1','197','1018',464,'Retail Sale Id 1437757',3202.72,0.00,0.00,5.41,443.62,'2021-12-31 15:48:14','',''),(2412958,'1','197','1018',464,'Retail Sale Id 1437767',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 15:49:55','',''),(2412959,'1','197','1018',464,'Retail Sale Id 1437767',14800.00,0.00,0.00,25.00,2050.00,'2021-12-31 15:49:55','',''),(2412979,'1','197','1018',464,'Retail Sale Id 1437779',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 15:51:20','',''),(2413001,'1','197','1018',464,'Retail Sale Id 1437810',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 15:53:10','',''),(2413002,'1','197','1018',464,'Retail Sale Id 1437810',1799.68,0.00,0.00,3.04,249.28,'2021-12-31 15:53:10','',''),(2413037,'1','197','1018',464,'Retail Sale Id 1437845',14800.00,0.00,0.00,25.00,2050.00,'2021-12-31 15:56:32','',''),(2413111,'1','197','1018',464,'Retail Sale Id 1437890',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 16:01:02','',''),(2413264,'1','197','1018',464,'Retail Sale Id 1438037',1201.76,0.00,0.00,2.03,166.46,'2021-12-31 16:17:45','',''),(2413265,'1','197','1018',464,'Retail Sale Id 1438037',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 16:17:45','',''),(2413291,'1','197','1018',464,'Retail Sale Id 1438065',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 16:20:21','',''),(2413338,'1','197','1018',464,'Retail Sale Id 1438142',3498.72,0.00,0.00,5.91,484.62,'2021-12-31 16:25:53','',''),(2413674,'1','197','1018',464,'Retail Sale Id 1438427',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 16:54:35','',''),(2413731,'1','197','1018',464,'Retail Sale Id 1438560',1000.48,0.00,0.00,1.69,138.58,'2021-12-31 17:02:31','',''),(2413905,'1','197','1018',464,'Retail Sale Id 1438757',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 17:47:17','',''),(2413912,'1','197','1018',464,'Retail Sale Id 1438762',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 17:49:57','',''),(2413946,'1','197','1018',464,'Retail Sale Id 1438764',14800.00,0.00,0.00,25.00,2050.00,'2021-12-31 17:52:01','',''),(2413962,'1','197','1018',464,'Retail Sale Id 1438767',2000.96,0.00,0.00,3.38,277.16,'2021-12-31 17:53:07','',''),(2413963,'1','197','1018',464,'Retail Sale Id 1438767',3599.36,0.00,0.00,6.08,498.56,'2021-12-31 17:53:07','',''),(2414136,'1','197','1018',464,'Retail Sale Id 1438810',14800.00,0.00,0.00,25.00,2050.00,'2021-12-31 19:24:22','',''),(2414137,'1','197','1018',464,'Retail Sale Id 1438811',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 19:25:00','',''),(2414138,'1','197','1018',464,'Retail Sale Id 1438812',7400.00,0.00,0.00,12.50,1025.00,'2021-12-31 19:25:41','',''),(2414139,'1','197','1018',464,'Retail Sale Id 1438813',9406.88,0.00,0.00,15.89,1302.98,'2021-12-31 19:26:41','',''),(2414140,'1','197','1018',464,'Retail Sale Id 1438814',26500.00,0.00,0.00,50.00,1000.00,'2021-12-31 19:28:52','',''),(2414141,'1','197','1018',464,'Retail Sale Id 1438815',24978.90,0.00,0.00,47.13,942.60,'2021-12-31 19:30:07','',''),(2414759,'1','197','1018',464,'Retail Sale Id 1439091',3599.36,0.00,0.00,6.08,498.56,'2022-01-01 07:07:33','',''),(2416593,'1','197','1018',464,'Retail Sale Id 1440646',14800.00,0.00,0.00,25.00,2050.00,'2022-01-01 09:57:42','',''),(2416604,'1','197','1018',464,'Retail Sale Id 1440664',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 09:58:52','',''),(2416647,'1','197','1018',464,'Retail Sale Id 1440684',3001.44,0.00,0.00,5.07,415.74,'2022-01-01 10:01:41','',''),(2416669,'1','197','1018',464,'Retail Sale Id 1440695',14800.00,0.00,0.00,25.00,2050.00,'2022-01-01 10:04:31','',''),(2416736,'1','197','1018',464,'Retail Sale Id 1440738',3297.44,0.00,0.00,5.57,456.74,'2022-01-01 10:12:36','',''),(2416753,'1','197','1018',464,'Retail Sale Id 1440790',7198.72,0.00,0.00,12.16,997.12,'2022-01-01 10:14:14','',''),(2416773,'1','197','1018',464,'Retail Sale Id 1440807',14800.00,0.00,0.00,25.00,2050.00,'2022-01-01 10:16:35','',''),(2416785,'1','197','1018',464,'Retail Sale Id 1440822',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 10:18:10','',''),(2416821,'1','197','1018',464,'Retail Sale Id 1440852',7098.08,0.00,0.00,11.99,983.18,'2022-01-01 10:20:47','',''),(2416925,'1','197','1018',464,'Retail Sale Id 1440953',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 10:32:31','',''),(2416938,'1','197','1018',464,'Retail Sale Id 1440965',9998.88,0.00,0.00,16.89,1384.98,'2022-01-01 10:33:40','',''),(2416977,'1','197','1018',464,'Retail Sale Id 1440987',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 10:37:31','',''),(2416986,'1','197','1018',464,'Retail Sale Id 1440994',3599.36,0.00,0.00,6.08,498.56,'2022-01-01 10:39:00','',''),(2417019,'1','197','1018',464,'Retail Sale Id 1441032',20128.00,0.00,0.00,34.00,2788.00,'2022-01-01 10:42:34','',''),(2419060,'1','197','1018',464,'Retail Sale Id 1442803',3599.36,0.00,0.00,6.08,498.56,'2022-01-01 14:44:35','',''),(2419080,'1','197','1018',464,'Retail Sale Id 1442813',1799.68,0.00,0.00,3.04,249.28,'2022-01-01 14:46:45','',''),(2419081,'1','197','1018',464,'Retail Sale Id 1442813',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 14:46:45','',''),(2419103,'1','197','1018',464,'Retail Sale Id 1442820',3498.72,0.00,0.00,5.91,484.62,'2022-01-01 14:49:12','',''),(2419104,'1','197','1018',464,'Retail Sale Id 1442820',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 14:49:12','',''),(2419112,'1','197','1018',464,'Retail Sale Id 1442829',5002.40,0.00,0.00,8.45,692.90,'2022-01-01 14:50:29','',''),(2419113,'1','197','1018',464,'Retail Sale Id 1442829',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 14:50:29','',''),(2419118,'1','197','1018',464,'Retail Sale Id 1442835',34450.00,0.00,0.00,65.00,1300.00,'2022-01-01 14:51:54','',''),(2419181,'1','197','1018',464,'Retail Sale Id 1442901',3700.00,0.00,0.00,6.25,512.50,'2022-01-01 15:04:21','',''),(2419267,'1','197','1018',464,'Retail Sale Id 1442963',14800.00,0.00,0.00,25.00,2050.00,'2022-01-01 15:18:14','',''),(2419301,'1','197','1018',464,'Retail Sale Id 1443001',3001.44,0.00,0.00,5.07,415.74,'2022-01-01 15:23:55','',''),(2419999,'1','197','1018',464,'Retail Sale Id 1443553',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 16:59:52','',''),(2420077,'1','197','1018',464,'Retail Sale Id 1443641',799.20,0.00,0.00,1.35,110.70,'2022-01-01 17:16:16','',''),(2420078,'1','197','1018',464,'Retail Sale Id 1443641',2000.96,0.00,0.00,3.38,277.16,'2022-01-01 17:16:16','',''),(2420079,'1','197','1018',464,'Retail Sale Id 1443641',3599.36,0.00,0.00,6.08,498.56,'2022-01-01 17:16:16','',''),(2420086,'1','197','1018',464,'Retail Sale Id 1443647',3001.44,0.00,0.00,5.07,415.74,'2022-01-01 17:17:30','',''),(2420093,'1','197','1018',464,'Retail Sale Id 1443654',310050.00,0.00,0.00,585.00,11700.00,'2022-01-01 17:19:50','',''),(2420103,'1','197','1018',464,'Retail Sale Id 1443661',7400.00,0.00,0.00,12.50,1025.00,'2022-01-01 17:23:11','',''),(2420311,'1','197','1018',464,'Retail Sale Id 1443756',26500.00,0.00,0.00,50.00,1000.00,'2022-01-01 18:52:11','',''),(2420313,'1','197','1018',464,'Retail Sale Id 1443758',11061.10,0.00,0.00,20.87,417.40,'2022-01-01 18:54:23','',''),(2420316,'1','197','1018',464,'Retail Sale Id 1443759',8086.72,0.00,0.00,13.66,1120.12,'2022-01-01 18:57:12','',''),(2421915,'1','197','1018',464,'Retail Sale Id 1444808',64660.00,0.00,0.00,122.00,2440.00,'2022-01-02 09:12:18','',''),(2421957,'1','197','1018',464,'Retail Sale Id 1444860',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 09:18:09','',''),(2422148,'1','197','1018',464,'Retail Sale Id 1445023',3001.44,0.00,0.00,5.07,415.74,'2022-01-02 09:39:19','',''),(2422391,'1','197','1018',464,'Retail Sale Id 1445228',1799.68,0.00,0.00,3.04,249.28,'2022-01-02 10:07:34','',''),(2422427,'1','197','1018',464,'Retail Sale Id 1445266',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 10:11:46','',''),(2422504,'1','197','1018',464,'Retail Sale Id 1445317',3599.36,0.00,0.00,6.08,498.56,'2022-01-02 10:18:58','',''),(2422522,'1','197','1018',464,'Retail Sale Id 1445339',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 10:21:16','',''),(2423790,'1','197','1018',464,'Retail Sale Id 1446572',4700.48,0.00,0.00,7.94,651.08,'2022-01-02 12:45:18','',''),(2423807,'1','197','1018',464,'Retail Sale Id 1446588',14800.00,0.00,0.00,25.00,2050.00,'2022-01-02 12:46:56','',''),(2423823,'1','197','1018',464,'Retail Sale Id 1446604',3001.44,0.00,0.00,5.07,415.74,'2022-01-02 12:49:14','',''),(2423844,'1','197','1018',464,'Retail Sale Id 1446631',3001.44,0.00,0.00,5.07,415.74,'2022-01-02 12:51:58','',''),(2423860,'1','197','1018',464,'Retail Sale Id 1446641',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 12:53:40','',''),(2423874,'1','197','1018',464,'Retail Sale Id 1446664',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 12:55:21','',''),(2423891,'1','197','1018',464,'Retail Sale Id 1446683',14800.00,0.00,0.00,25.00,2050.00,'2022-01-02 12:56:59','',''),(2423904,'1','197','1018',464,'Retail Sale Id 1446694',1776.00,0.00,0.00,3.00,246.00,'2022-01-02 12:58:40','',''),(2423919,'1','197','1018',464,'Retail Sale Id 1446717',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 13:00:20','',''),(2424672,'1','197','1018',464,'Retail Sale Id 1447301',71550.00,0.00,0.00,135.00,2700.00,'2022-01-02 14:23:34','',''),(2426054,'1','197','1018',464,'Distributed to BABAFRAYO GASD for sales id:343765',45981.60,0.00,0.00,90.16,0.00,'2022-01-02 19:06:20','',''),(2426144,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2407200.00,4720.00,0.00,0.00,'2022-01-02 19:58:22','',''),(2426160,'1','197',NULL,464,'Reception corrector for bridging 129513',0.00,0.00,0.00,4720.00,0.00,'2022-01-02 20:01:32','',''),(2426161,'1','197','1018',464,'Received from bridging 129513',0.00,0.00,4720.00,0.00,0.00,'2022-01-02 20:01:32','',''),(2426189,'1','197','1018',464,'Retail Sale Id 1448503',6500.16,0.00,0.00,10.98,900.36,'2022-01-02 21:02:07','',''),(2426190,'1','197','1018',464,'Retail Sale Id 1448503',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 21:02:07','',''),(2426191,'1','197','1018',464,'Retail Sale Id 1448504',7198.72,0.00,0.00,12.16,997.12,'2022-01-02 21:03:04','',''),(2426192,'1','197','1018',464,'Retail Sale Id 1448507',1799.68,0.00,0.00,3.04,249.28,'2022-01-02 21:04:44','',''),(2426193,'1','197','1018',464,'Retail Sale Id 1448507',7400.00,0.00,0.00,12.50,1025.00,'2022-01-02 21:04:44','',''),(2426194,'1','197','1018',464,'Retail Sale Id 1448508',14800.00,0.00,0.00,25.00,2050.00,'2022-01-02 21:05:34','',''),(2426196,'1','197','1018',464,'Retail Sale Id 1448510',3001.44,0.00,0.00,5.07,415.74,'2022-01-02 21:06:46','',''),(2426197,'1','197','1018',464,'Retail Sale Id 1448510',6997.44,0.00,0.00,11.82,969.24,'2022-01-02 21:06:46','',''),(2426199,'1','197','1018',464,'Retail Sale Id 1448512',3800.64,0.00,0.00,6.42,526.44,'2022-01-02 21:09:23','',''),(2426817,'1','197','1018',464,'Retail Sale Id 1448923',2498.24,0.00,0.00,4.22,346.04,'2022-01-03 07:39:33','',''),(2426833,'1','197','1018',464,'Retail Sale Id 1448942',4001.92,0.00,0.00,6.76,554.32,'2022-01-03 07:41:47','',''),(2426853,'1','197','1018',464,'Retail Sale Id 1448960',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 07:44:18','',''),(2426874,'1','197','1018',464,'Retail Sale Id 1448975',3599.36,0.00,0.00,6.08,498.56,'2022-01-03 07:46:41','',''),(2427037,'1','197','1018',464,'Retail Sale Id 1449067',1799.68,0.00,0.00,3.04,249.28,'2022-01-03 07:59:32','',''),(2427217,'1','197','1018',464,'Retail Sale Id 1449242',3700.00,0.00,0.00,6.25,512.50,'2022-01-03 08:26:05','',''),(2427273,'1','197','1018',464,'Retail Sale Id 1449296',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 08:33:55','',''),(2427331,'1','197','1018',464,'Retail Sale Id 1449363',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 08:40:03','',''),(2427878,'1','197','1018',464,'Retail Sale Id 1449869',138860.00,0.00,0.00,262.00,5240.00,'2022-01-03 09:36:21','',''),(2427944,'1','197','1018',464,'Retail Sale Id 1449882',1497.76,0.00,0.00,2.53,207.46,'2022-01-03 09:45:40','',''),(2427983,'1','197','1018',464,'Retail Sale Id 1449967',1799.68,0.00,0.00,3.04,249.28,'2022-01-03 09:50:05','',''),(2428333,'1','197','1018',464,'Retail Sale Id 1450295',1497.76,0.00,0.00,2.53,207.46,'2022-01-03 10:30:09','',''),(2428516,'1','197','1018',464,'Retail Sale Id 1450474',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 10:52:54','',''),(2428545,'1','197','1018',464,'Retail Sale Id 1450502',2000.96,0.00,0.00,3.38,277.16,'2022-01-03 10:57:07','',''),(2429243,'1','197','1018',464,'Retail Sale Id 1451149',2960.00,0.00,0.00,5.00,410.00,'2022-01-03 12:23:37','',''),(2429256,'1','197','1018',464,'Retail Sale Id 1451164',1000.48,0.00,0.00,1.69,138.58,'2022-01-03 12:25:40','',''),(2429365,'1','197','1018',464,'Retail Sale Id 1451179',137800.00,0.00,0.00,260.00,5200.00,'2022-01-03 12:37:55','',''),(2429427,'1','197','1018',464,'Retail Sale Id 1451307',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 12:46:37','',''),(2429433,'1','197','1018',464,'Retail Sale Id 1451314',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 12:47:31','',''),(2429488,'1','197','1018',464,'Retail Sale Id 1451361',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 12:54:08','',''),(2429509,'1','197','1018',464,'Retail Sale Id 1451374',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 12:55:59','',''),(2429529,'1','197','1018',464,'Retail Sale Id 1451396',3001.44,0.00,0.00,5.07,415.74,'2022-01-03 12:59:31','',''),(2429624,'1','197','1018',464,'Retail Sale Id 1451490',5920.00,0.00,0.00,10.00,820.00,'2022-01-03 13:09:59','',''),(2429625,'1','197','1018',464,'Retail Sale Id 1451490',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 13:09:59','',''),(2429645,'1','197','1018',464,'Retail Sale Id 1451514',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 13:11:49','',''),(2431356,'1','197','1018',464,'Retail Sale Id 1452783',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 15:38:21','',''),(2431381,'1','197','1018',464,'Retail Sale Id 1452802',5499.68,0.00,0.00,9.29,761.78,'2022-01-03 15:40:11','',''),(2431441,'1','197','1018',464,'Retail Sale Id 1452861',8880.00,0.00,0.00,15.00,1230.00,'2022-01-03 15:44:51','',''),(2431486,'1','197','1018',464,'Retail Sale Id 1452887',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 15:50:07','',''),(2431565,'1','197','1018',464,'Retail Sale Id 1452983',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 15:56:59','',''),(2431627,'1','197','1018',464,'Retail Sale Id 1453049',3001.44,0.00,0.00,5.07,415.74,'2022-01-03 16:02:05','',''),(2431649,'1','197','1018',464,'Retail Sale Id 1453066',2000.96,0.00,0.00,3.38,277.16,'2022-01-03 16:04:30','',''),(2431701,'1','197','1018',464,'Retail Sale Id 1453120',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 16:09:34','',''),(2431716,'1','197','1018',464,'Retail Sale Id 1453139',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 16:10:52','',''),(2431821,'1','197','1018',464,'Retail Sale Id 1453238',3599.36,0.00,0.00,6.08,498.56,'2022-01-03 16:21:03','',''),(2432073,'1','197','1018',464,'Retail Sale Id 1453470',3599.36,0.00,0.00,6.08,498.56,'2022-01-03 16:45:53','',''),(2432183,'1','197','1018',464,'Retail Sale Id 1453560',2202.24,0.00,0.00,3.72,305.04,'2022-01-03 16:59:52','',''),(2432272,'1','197','1018',464,'Retail Sale Id 1453643',7400.00,0.00,0.00,12.50,1025.00,'2022-01-03 17:18:48','',''),(2432277,'1','197','1018',464,'Retail Sale Id 1453648',3001.44,0.00,0.00,5.07,415.74,'2022-01-03 17:20:31','',''),(2432486,'1','197','1018',464,'Return of Retail Sale Id 1453648',0.00,3001.44,5.07,0.00,-415.74,'2022-01-03 19:29:21','',''),(2432493,'1','197','1018',464,'Return of Retail Sale Id 1453470',0.00,3599.36,6.08,0.00,-498.56,'2022-01-03 19:31:19','',''),(2432494,'1','197','1018',464,'Retail Sale Id 1453737',1278.72,0.00,0.00,2.16,177.12,'2022-01-03 19:33:02','',''),(2432495,'1','197','1018',464,'Retail Sale Id 1453738',53000.00,0.00,0.00,100.00,2000.00,'2022-01-03 19:35:38','',''),(2432496,'1','197','1018',464,'Retail Sale Id 1453740',32208.10,0.00,0.00,60.77,1215.40,'2022-01-03 19:41:07','',''),(2435131,'1','197','1018',464,'Retail Sale Id 1455613',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 10:10:32','',''),(2435293,'1','197','1018',464,'Retail Sale Id 1455673',6997.44,0.00,0.00,11.82,969.24,'2022-01-04 10:25:38','',''),(2435343,'1','197','1018',464,'Retail Sale Id 1455766',2000.96,0.00,0.00,3.38,277.16,'2022-01-04 10:29:22','',''),(2435417,'1','197','1018',464,'Retail Sale Id 1455824',17002.40,0.00,0.00,32.08,641.60,'2022-01-04 10:35:07','',''),(2435682,'1','197','1018',464,'Retail Sale Id 1456081',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 10:59:08','',''),(2435924,'1','197','1018',464,'Retail Sale Id 1456312',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 11:21:22','',''),(2436840,'1','197','1018',464,'Retail Sale Id 1457201',14800.00,0.00,0.00,25.00,2050.00,'2022-01-04 12:58:26','',''),(2436852,'1','197','1018',464,'Retail Sale Id 1457216',2498.24,0.00,0.00,4.22,346.04,'2022-01-04 12:59:32','',''),(2436931,'1','197','1018',464,'Retail Sale Id 1457280',3498.72,0.00,0.00,5.91,484.62,'2022-01-04 13:06:58','',''),(2438137,'1','197','1018',464,'Retail Sale Id 1458259',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 14:47:37','',''),(2438160,'1','197','1018',464,'Retail Sale Id 1458287',3001.44,0.00,0.00,5.07,415.74,'2022-01-04 14:50:40','',''),(2438215,'1','197','1018',464,'Retail Sale Id 1458337',6500.16,0.00,0.00,10.98,900.36,'2022-01-04 14:56:24','',''),(2438242,'1','197','1018',464,'Retail Sale Id 1458367',8400.48,0.00,0.00,14.19,1163.58,'2022-01-04 14:59:08','',''),(2438339,'1','197','1018',464,'Retail Sale Id 1458416',6701.44,0.00,0.00,11.32,928.24,'2022-01-04 15:03:19','',''),(2438381,'1','197','1018',464,'Retail Sale Id 1458433',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:05:20','',''),(2438407,'1','197','1018',464,'Retail Sale Id 1458457',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:07:13','',''),(2438426,'1','197','1018',464,'Retail Sale Id 1458482',5920.00,0.00,0.00,10.00,820.00,'2022-01-04 15:09:36','',''),(2438447,'1','197','1018',464,'Retail Sale Id 1458489',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:10:55','',''),(2438473,'1','197','1018',464,'Retail Sale Id 1458508',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:12:44','',''),(2438498,'1','197','1018',464,'Retail Sale Id 1458527',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:15:02','',''),(2438619,'1','197','1018',464,'Retail Sale Id 1458662',9199.68,0.00,0.00,15.54,1274.28,'2022-01-04 15:24:15','',''),(2438659,'1','197','1018',464,'Retail Sale Id 1458694',26500.00,0.00,0.00,50.00,1000.00,'2022-01-04 15:27:35','',''),(2438730,'1','197','1018',464,'Retail Sale Id 1458765',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:36:44','',''),(2438851,'1','197','1018',464,'Retail Sale Id 1458891',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:47:29','',''),(2438906,'1','197','1018',464,'Retail Sale Id 1458925',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 15:50:36','',''),(2439553,'1','197','1018',464,'Retail Sale Id 1459547',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 16:56:09','',''),(2439566,'1','197','1018',464,'Retail Sale Id 1459557',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 16:57:41','',''),(2439579,'1','197','1018',464,'Retail Sale Id 1459570',8400.48,0.00,0.00,14.19,1163.58,'2022-01-04 17:00:06','',''),(2439606,'1','197','1018',464,'Retail Sale Id 1459605',14800.00,0.00,0.00,25.00,2050.00,'2022-01-04 17:02:46','',''),(2439616,'1','197','1018',464,'Retail Sale Id 1459620',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 17:04:51','',''),(2439634,'1','197','1018',464,'Retail Sale Id 1459639',2000.96,0.00,0.00,3.38,277.16,'2022-01-04 17:08:53','',''),(2439645,'1','197','1018',464,'Retail Sale Id 1459646',1799.68,0.00,0.00,3.04,249.28,'2022-01-04 17:11:06','',''),(2439656,'1','197','1018',464,'Retail Sale Id 1459659',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 17:14:28','',''),(2439682,'1','197','1018',464,'Retail Sale Id 1459672',1799.68,0.00,0.00,3.04,249.28,'2022-01-04 17:17:31','',''),(2439694,'1','197','1018',464,'Retail Sale Id 1459685',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 17:20:32','',''),(2439699,'1','197','1018',464,'Retail Sale Id 1459691',2302.88,0.00,0.00,3.89,318.98,'2022-01-04 17:21:50','',''),(2439705,'1','197','1018',464,'Retail Sale Id 1459696',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 17:22:56','',''),(2439718,'1','197','1018',464,'Retail Sale Id 1459708',5002.40,0.00,0.00,8.45,692.90,'2022-01-04 17:26:40','',''),(2439780,'1','197','1018',464,'Retail Sale Id 1459780',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 17:51:17','',''),(2439837,'1','197','1018',464,'Retail Sale Id 1459823',4001.92,0.00,0.00,6.76,554.32,'2022-01-04 18:04:58','',''),(2439972,'1','197','1018',464,'Retail Sale Id 1459855',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 19:18:05','',''),(2439973,'1','197','1018',464,'Retail Sale Id 1459855',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 19:18:05','',''),(2439974,'1','197','1018',464,'Retail Sale Id 1459855',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 19:18:05','',''),(2439976,'1','197','1018',464,'Retail Sale Id 1459857',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 19:19:04','',''),(2439977,'1','197','1018',464,'Retail Sale Id 1459858',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 19:20:21','',''),(2439978,'1','197','1018',464,'Retail Sale Id 1459858',3599.36,0.00,0.00,6.08,498.56,'2022-01-04 19:20:21','',''),(2439994,'1','197','1018',464,'Retail Sale Id 1459860',1314.24,0.00,0.00,2.22,182.04,'2022-01-04 19:22:19','',''),(2439995,'1','197','1018',464,'Retail Sale Id 1459860',7400.00,0.00,0.00,12.50,1025.00,'2022-01-04 19:22:19','',''),(2439997,'1','197','1018',464,'Retail Sale Id 1459862',10600.00,0.00,0.00,20.00,400.00,'2022-01-04 19:24:05','',''),(2440015,'1','197','1018',464,'Retail Sale Id 1459866',12958.50,0.00,0.00,24.45,489.00,'2022-01-04 19:27:19','',''),(2443612,'1','197','1018',464,'Retail Sale Id 1462546',132500.00,0.00,0.00,250.00,5000.00,'2022-01-05 12:27:28','',''),(2443657,'1','197','1018',464,'Retail Sale Id 1462606',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 12:31:04','',''),(2443842,'1','197','1018',464,'Retail Sale Id 1462778',124020.00,0.00,0.00,234.00,4680.00,'2022-01-05 12:50:01','',''),(2443906,'1','197','1018',464,'Retail Sale Id 1462843',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 12:57:04','',''),(2443958,'1','197','1018',464,'Retail Sale Id 1462891',5499.68,0.00,0.00,9.29,761.78,'2022-01-05 13:01:50','',''),(2443979,'1','197','1018',464,'Retail Sale Id 1462907',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 13:04:31','',''),(2444093,'1','197','1018',464,'Retail Sale Id 1463021',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 13:15:11','',''),(2445686,'1','197','1018',464,'Retail Sale Id 1464192',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 15:49:22','',''),(2445713,'1','197','1018',464,'Retail Sale Id 1464213',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 15:51:15','',''),(2446582,'1','197','1018',464,'Retail Sale Id 1464933',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 17:10:19','',''),(2446600,'1','197','1018',464,'Retail Sale Id 1464949',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:12:25','',''),(2446627,'1','197','1018',464,'Retail Sale Id 1464976',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:14:37','',''),(2446666,'1','197','1018',464,'Retail Sale Id 1465010',2498.24,0.00,0.00,4.22,346.04,'2022-01-05 17:17:32','',''),(2446683,'1','197','1018',464,'Retail Sale Id 1465024',5002.40,0.00,0.00,8.45,692.90,'2022-01-05 17:18:38','',''),(2446699,'1','197','1018',464,'Retail Sale Id 1465044',6997.44,0.00,0.00,11.82,969.24,'2022-01-05 17:20:06','',''),(2446700,'1','197','1018',464,'Retail Sale Id 1465044',6997.44,0.00,0.00,11.82,969.24,'2022-01-05 17:20:06','',''),(2446784,'1','197','1018',464,'Retail Sale Id 1465130',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:27:24','',''),(2446798,'1','197','1018',464,'Retail Sale Id 1465150',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:29:01','',''),(2446819,'1','197','1018',464,'Retail Sale Id 1465168',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:30:46','',''),(2446843,'1','197','1018',464,'Retail Sale Id 1465197',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:32:43','',''),(2446867,'1','197','1018',464,'Retail Sale Id 1465226',6997.44,0.00,0.00,11.82,969.24,'2022-01-05 17:35:04','',''),(2446905,'1','197','1018',464,'Retail Sale Id 1465248',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:36:56','',''),(2446963,'1','197','1018',464,'Retail Sale Id 1465268',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:39:16','',''),(2446984,'1','197','1018',464,'Retail Sale Id 1465284',4001.92,0.00,0.00,6.76,554.32,'2022-01-05 17:40:23','',''),(2447000,'1','197','1018',464,'Retail Sale Id 1465302',597.92,0.00,0.00,1.01,82.82,'2022-01-05 17:42:25','',''),(2447018,'1','197','1018',464,'Retail Sale Id 1465319',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:44:00','',''),(2447039,'1','197','1018',464,'Retail Sale Id 1465340',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:45:59','',''),(2447053,'1','197','1018',464,'Retail Sale Id 1465351',1000.48,0.00,0.00,1.69,138.58,'2022-01-05 17:47:18','',''),(2447065,'1','197','1018',464,'Retail Sale Id 1465365',3599.36,0.00,0.00,6.08,498.56,'2022-01-05 17:48:39','',''),(2447082,'1','197','1018',464,'Retail Sale Id 1465376',3001.44,0.00,0.00,5.07,415.74,'2022-01-05 17:49:53','',''),(2447125,'1','197','1018',464,'Retail Sale Id 1465413',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 17:55:14','',''),(2447137,'1','197','1018',464,'Retail Sale Id 1465435',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 17:56:44','',''),(2447212,'1','197','1018',464,'Retail Sale Id 1465495',2498.24,0.00,0.00,4.22,346.04,'2022-01-05 18:06:52','',''),(2447380,'1','197','1018',464,'Retail Sale Id 1465584',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 18:23:30','',''),(2447385,'1','197','1018',464,'Retail Sale Id 1465597',1799.68,0.00,0.00,3.04,249.28,'2022-01-05 18:24:35','',''),(2447421,'1','197','1018',464,'Retail Sale Id 1465634',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 18:31:34','',''),(2447666,'1','197','1018',464,'Retail Sale Id 1465807',7400.00,0.00,0.00,12.50,1025.00,'2022-01-05 20:06:42','',''),(2447668,'1','197','1018',464,'Retail Sale Id 1465808',5097.12,0.00,0.00,8.61,706.02,'2022-01-05 20:07:25','',''),(2447669,'1','197','1018',464,'Retail Sale Id 1465809',6625.00,0.00,0.00,12.50,250.00,'2022-01-05 20:09:41','',''),(2448381,'1','197','1018',464,'Retail Sale Id 1466001',17998.80,0.00,0.00,33.96,679.20,'2022-01-06 07:48:31','',''),(2449217,'1','197','1018',464,'Retail Sale Id 1466641',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 09:07:35','',''),(2449247,'1','197','1018',464,'Retail Sale Id 1466670',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 09:09:21','',''),(2449268,'1','197','1018',464,'Retail Sale Id 1466694',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 09:11:36','',''),(2449284,'1','197','1018',464,'Retail Sale Id 1466713',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 09:13:07','',''),(2449301,'1','197','1018',464,'Retail Sale Id 1466730',9199.68,0.00,0.00,15.54,1274.28,'2022-01-06 09:15:33','',''),(2449641,'1','197','1018',464,'Retail Sale Id 1467036',11200.64,0.00,0.00,18.92,1551.44,'2022-01-06 09:43:48','',''),(2449707,'1','197','1018',464,'Retail Sale Id 1467084',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 09:48:51','',''),(2449848,'1','197','1018',464,'Retail Sale Id 1467224',5002.40,0.00,0.00,8.45,692.90,'2022-01-06 10:05:47','',''),(2449918,'1','197','1018',464,'Retail Sale Id 1467327',45050.00,0.00,0.00,85.00,1700.00,'2022-01-06 10:14:29','',''),(2450023,'1','197','1018',464,'Retail Sale Id 1467422',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 10:23:53','',''),(2450053,'1','197','1018',464,'Retail Sale Id 1467435',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:25:27','',''),(2450134,'1','197','1018',464,'Retail Sale Id 1467471',20720.00,0.00,0.00,35.00,2870.00,'2022-01-06 10:28:46','',''),(2450347,'1','197','1018',464,'Retail Sale Id 1467628',31270.00,0.00,0.00,59.00,1180.00,'2022-01-06 10:45:06','',''),(2450371,'1','197','1018',464,'Retail Sale Id 1467655',592.00,0.00,0.00,1.00,82.00,'2022-01-06 10:48:39','',''),(2450389,'1','197','1018',464,'Retail Sale Id 1467674',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:51:29','',''),(2450390,'1','197','1018',464,'Retail Sale Id 1467674',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 10:51:29','',''),(2450474,'1','197','1018',464,'Retail Sale Id 1467752',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 11:02:54','',''),(2453726,'1','197','1018',464,'Retail Sale Id 1470664',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 16:27:34','',''),(2453753,'1','197','1018',464,'Retail Sale Id 1470689',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 16:30:21','',''),(2453842,'1','197','1018',464,'Retail Sale Id 1470774',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 16:39:38','',''),(2453850,'1','197','1018',464,'Retail Sale Id 1470786',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 16:41:09','',''),(2453872,'1','197','1018',464,'Retail Sale Id 1470812',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 16:43:15','',''),(2453873,'1','197','1018',464,'Retail Sale Id 1470812',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 16:43:15','',''),(2453896,'1','197','1018',464,'Retail Sale Id 1470840',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 16:46:11','',''),(2454168,'1','197','1018',464,'Retail Sale Id 1471125',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 17:09:27','',''),(2454192,'1','197','1018',464,'Retail Sale Id 1471150',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 17:11:09','',''),(2454225,'1','197','1018',464,'Retail Sale Id 1471171',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 17:12:19','',''),(2454241,'1','197','1018',464,'Retail Sale Id 1471186',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 17:13:48','',''),(2454250,'1','197','1018',464,'Retail Sale Id 1471194',31270.00,0.00,0.00,59.00,1180.00,'2022-01-06 17:15:20','',''),(2454291,'1','197','1018',464,'Retail Sale Id 1471238',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:19:37','',''),(2454347,'1','197','1018',464,'Retail Sale Id 1471296',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:25:46','',''),(2454373,'1','197','1018',464,'Retail Sale Id 1471318',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:27:57','',''),(2454412,'1','197','1018',464,'Retail Sale Id 1471362',2598.88,0.00,0.00,4.39,359.98,'2022-01-06 17:31:13','',''),(2454432,'1','197','1018',464,'Retail Sale Id 1471379',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:32:54','',''),(2454480,'1','197','1018',464,'Retail Sale Id 1471416',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:35:53','',''),(2454499,'1','197','1018',464,'Retail Sale Id 1471439',3498.72,0.00,0.00,5.91,484.62,'2022-01-06 17:37:44','',''),(2454517,'1','197','1018',464,'Retail Sale Id 1471456',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 17:38:43','',''),(2454536,'1','197','1018',464,'Retail Sale Id 1471479',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 17:40:37','',''),(2454550,'1','197','1018',464,'Retail Sale Id 1471490',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:41:51','',''),(2454566,'1','197','1018',464,'Retail Sale Id 1471506',4001.92,0.00,0.00,6.76,554.32,'2022-01-06 17:43:18','',''),(2454597,'1','197','1018',464,'Retail Sale Id 1471532',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:45:14','',''),(2454615,'1','197','1018',464,'Retail Sale Id 1471547',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:47:18','',''),(2454631,'1','197','1018',464,'Retail Sale Id 1471567',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 17:48:50','',''),(2454632,'1','197','1018',464,'Retail Sale Id 1471567',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:48:50','',''),(2454664,'1','197','1018',464,'Retail Sale Id 1471596',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:52:07','',''),(2454679,'1','197','1018',464,'Retail Sale Id 1471617',1000.48,0.00,0.00,1.69,138.58,'2022-01-06 17:53:35','',''),(2454695,'1','197','1018',464,'Retail Sale Id 1471631',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 17:55:16','',''),(2454704,'1','197','1018',464,'Retail Sale Id 1471641',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 17:56:21','',''),(2454713,'1','197','1018',464,'Retail Sale Id 1471651',5499.68,0.00,0.00,9.29,761.78,'2022-01-06 17:57:29','',''),(2454737,'1','197','1018',464,'Retail Sale Id 1471667',1799.68,0.00,0.00,3.04,249.28,'2022-01-06 17:59:12','',''),(2454757,'1','197','1018',464,'Retail Sale Id 1471695',5002.40,0.00,0.00,8.45,692.90,'2022-01-06 18:01:13','',''),(2454771,'1','197','1018',464,'Retail Sale Id 1471708',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:02:47','',''),(2454794,'1','197','1018',464,'Retail Sale Id 1471728',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:05:27','',''),(2454816,'1','197','1018',464,'Retail Sale Id 1471753',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:09:06','',''),(2454830,'1','197','1018',464,'Retail Sale Id 1471765',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:10:40','',''),(2454855,'1','197','1018',464,'Retail Sale Id 1471779',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:11:59','',''),(2454865,'1','197','1018',464,'Retail Sale Id 1471788',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:12:55','',''),(2454884,'1','197','1018',464,'Retail Sale Id 1471808',9998.88,0.00,0.00,16.89,1384.98,'2022-01-06 18:15:53','',''),(2454922,'1','197','1018',464,'Retail Sale Id 1471818',6600.80,0.00,0.00,11.15,914.30,'2022-01-06 18:17:16','',''),(2454944,'1','197','1018',464,'Retail Sale Id 1471824',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:18:09','',''),(2454954,'1','197','1018',464,'Retail Sale Id 1471836',11851.84,0.00,0.00,20.02,1641.64,'2022-01-06 18:19:43','',''),(2454956,'1','197','1018',464,'Retail Sale Id 1471838',6002.88,0.00,0.00,10.14,831.48,'2022-01-06 18:20:50','',''),(2454964,'1','197','1018',464,'Retail Sale Id 1471847',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 18:21:56','',''),(2454991,'1','197','1018',464,'Retail Sale Id 1471855',3599.36,0.00,0.00,6.08,498.56,'2022-01-06 18:24:00','',''),(2455001,'1','197','1018',464,'Retail Sale Id 1471864',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 18:25:25','',''),(2455013,'1','197','1018',464,'Retail Sale Id 1471877',2498.24,0.00,0.00,4.22,346.04,'2022-01-06 18:28:25','',''),(2455027,'1','197','1018',464,'Retail Sale Id 1471891',1497.76,0.00,0.00,2.53,207.46,'2022-01-06 18:31:50','',''),(2455039,'1','197','1018',464,'Retail Sale Id 1471902',3001.44,0.00,0.00,5.07,415.74,'2022-01-06 18:34:38','',''),(2455055,'1','197','1018',464,'Retail Sale Id 1471920',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:38:49','',''),(2455101,'1','197','1018',464,'Retail Sale Id 1471939',5920.00,0.00,0.00,10.00,820.00,'2022-01-06 18:46:47','',''),(2455146,'1','197','1018',464,'Retail Sale Id 1471957',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:50:24','',''),(2455147,'1','197','1018',464,'Retail Sale Id 1471957',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 18:50:24','',''),(2455325,'1','197','1018',464,'Retail Sale Id 1472094',29600.00,0.00,0.00,50.00,4100.00,'2022-01-06 19:45:58','',''),(2455326,'1','197','1018',464,'Retail Sale Id 1472095',7400.00,0.00,0.00,12.50,1025.00,'2022-01-06 19:46:57','',''),(2455327,'1','197','1018',464,'Retail Sale Id 1472096',4043.36,0.00,0.00,6.83,560.06,'2022-01-06 19:47:48','',''),(2455331,'1','197','1018',464,'Retail Sale Id 1472097',12513.30,0.00,0.00,23.61,472.20,'2022-01-06 19:55:59','',''),(2459793,'1','197','1018',464,'Retail Sale Id 1475640',2302.88,0.00,0.00,3.89,318.98,'2022-01-07 14:27:47','',''),(2459822,'1','197','1018',464,'Retail Sale Id 1475662',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:30:28','',''),(2459841,'1','197','1018',464,'Retail Sale Id 1475684',6997.44,0.00,0.00,11.82,969.24,'2022-01-07 14:33:01','',''),(2459853,'1','197','1018',464,'Retail Sale Id 1475696',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 14:34:24','',''),(2459865,'1','197','1018',464,'Retail Sale Id 1475709',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 14:36:14','',''),(2459889,'1','197','1018',464,'Retail Sale Id 1475723',6600.80,0.00,0.00,11.15,914.30,'2022-01-07 14:37:56','',''),(2459898,'1','197','1018',464,'Retail Sale Id 1475730',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:39:03','',''),(2459909,'1','197','1018',464,'Retail Sale Id 1475743',6002.88,0.00,0.00,10.14,831.48,'2022-01-07 14:40:59','',''),(2459934,'1','197','1018',464,'Retail Sale Id 1475775',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:44:24','',''),(2459953,'1','197','1018',464,'Retail Sale Id 1475794',6500.16,0.00,0.00,10.98,900.36,'2022-01-07 14:46:46','',''),(2459977,'1','197','1018',464,'Retail Sale Id 1475809',7601.28,0.00,0.00,12.84,1052.88,'2022-01-07 14:48:34','',''),(2460002,'1','197','1018',464,'Retail Sale Id 1475825',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:50:00','',''),(2460015,'1','197','1018',464,'Retail Sale Id 1475831',13024.00,0.00,0.00,22.00,1804.00,'2022-01-07 14:51:18','',''),(2460034,'1','197','1018',464,'Retail Sale Id 1475835',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:52:14','',''),(2460054,'1','197','1018',464,'Retail Sale Id 1475848',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 14:53:35','',''),(2460075,'1','197','1018',464,'Retail Sale Id 1475861',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 14:55:29','',''),(2460136,'1','197','1018',464,'Retail Sale Id 1475913',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:00:43','',''),(2460156,'1','197','1018',464,'Retail Sale Id 1475928',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:02:07','',''),(2460174,'1','197','1018',464,'Retail Sale Id 1475950',70490.00,0.00,0.00,133.00,2660.00,'2022-01-07 15:04:32','',''),(2460199,'1','197','1018',464,'Retail Sale Id 1475963',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:06:33','',''),(2460231,'1','197','1018',464,'Retail Sale Id 1475984',9199.68,0.00,0.00,15.54,1274.28,'2022-01-07 15:08:10','',''),(2460248,'1','197','1018',464,'Retail Sale Id 1475997',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:09:23','',''),(2460279,'1','197','1018',464,'Retail Sale Id 1476023',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:11:29','',''),(2460357,'1','197','1018',464,'Retail Sale Id 1476081',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 15:18:03','',''),(2460387,'1','197','1018',464,'Retail Sale Id 1476100',2000.96,0.00,0.00,3.38,277.16,'2022-01-07 15:20:15','',''),(2460399,'1','197','1018',464,'Retail Sale Id 1476111',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:21:35','',''),(2460414,'1','197','1018',464,'Retail Sale Id 1476125',6625.00,0.00,0.00,12.50,250.00,'2022-01-07 15:23:13','',''),(2460424,'1','197','1018',464,'Retail Sale Id 1476137',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:24:41','',''),(2460449,'1','197','1018',464,'Retail Sale Id 1476156',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:26:43','',''),(2460462,'1','197','1018',464,'Retail Sale Id 1476171',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:27:37','',''),(2460495,'1','197','1018',464,'Retail Sale Id 1476202',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 15:30:11','',''),(2460541,'1','197','1018',464,'Retail Sale Id 1476218',26500.00,0.00,0.00,50.00,1000.00,'2022-01-07 15:31:44','',''),(2460586,'1','197','1018',464,'Retail Sale Id 1476254',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 15:35:03','',''),(2461030,'1','197','1018',464,'Retail Sale Id 1476600',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 16:13:56','',''),(2461040,'1','197','1018',464,'Retail Sale Id 1476611',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 16:15:12','',''),(2461064,'1','197','1018',464,'Retail Sale Id 1476637',2397.60,0.00,0.00,4.05,332.10,'2022-01-07 16:17:32','',''),(2461078,'1','197','1018',464,'Retail Sale Id 1476647',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 16:19:39','',''),(2461092,'1','197','1018',464,'Retail Sale Id 1476663',49820.00,0.00,0.00,94.00,1880.00,'2022-01-07 16:21:57','',''),(2461103,'1','197','1018',464,'Retail Sale Id 1476672',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 16:23:20','',''),(2461139,'1','197','1018',464,'Retail Sale Id 1476699',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 16:27:21','',''),(2461240,'1','197','1018',464,'Retail Sale Id 1476765',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 16:33:53','',''),(2461463,'1','197','1018',464,'Retail Sale Id 1476955',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 16:56:11','',''),(2461514,'1','197','1018',464,'Retail Sale Id 1476997',32860.00,0.00,0.00,62.00,1240.00,'2022-01-07 17:00:06','',''),(2461562,'1','197','1018',464,'Retail Sale Id 1477044',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 17:04:57','',''),(2461585,'1','197','1018',464,'Retail Sale Id 1477064',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 17:07:35','',''),(2461644,'1','197','1018',464,'Retail Sale Id 1477132',2000.96,0.00,0.00,3.38,277.16,'2022-01-07 17:12:58','',''),(2461680,'1','197','1018',464,'Retail Sale Id 1477158',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 17:16:10','',''),(2461846,'1','197','1018',464,'Retail Sale Id 1477270',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 17:28:40','',''),(2461960,'1','197','1018',464,'Retail Sale Id 1477346',1000.48,0.00,0.00,1.69,138.58,'2022-01-07 17:37:35','',''),(2462017,'1','197','1018',464,'Retail Sale Id 1477392',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 17:43:27','',''),(2462143,'1','197','1018',464,'Retail Sale Id 1477507',3001.44,0.00,0.00,5.07,415.74,'2022-01-07 17:57:41','',''),(2462200,'1','197','1018',464,'Retail Sale Id 1477558',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 18:06:56','',''),(2462227,'1','197','1018',464,'Retail Sale Id 1477582',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 18:11:31','',''),(2462236,'1','197','1018',464,'Retail Sale Id 1477601',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 18:13:19','',''),(2462313,'1','197','1018',464,'Retail Sale Id 1477652',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 18:22:22','',''),(2462439,'1','197','1018',464,'Retail Sale Id 1477739',14800.00,0.00,0.00,25.00,2050.00,'2022-01-07 18:45:33','',''),(2462442,'1','197','1018',464,'Retail Sale Id 1477743',14800.00,0.00,0.00,25.00,2050.00,'2022-01-07 18:46:34','',''),(2462449,'1','197','1018',464,'Retail Sale Id 1477749',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 18:48:33','',''),(2462452,'1','197','1018',464,'Retail Sale Id 1477753',3599.36,0.00,0.00,6.08,498.56,'2022-01-07 18:49:41','',''),(2462468,'1','197','1018',464,'Retail Sale Id 1477770',1799.68,0.00,0.00,3.04,249.28,'2022-01-07 18:54:46','',''),(2462653,'1','197','1018',464,'Return of Retail Sale Id 1476218',0.00,26500.00,50.00,0.00,-1000.00,'2022-01-07 20:13:59','',''),(2462656,'1','197','1018',464,'Return of Retail Sale Id 1476997',0.00,32860.00,62.00,0.00,-1240.00,'2022-01-07 20:15:30','',''),(2462658,'1','197','1018',464,'Retail Sale Id 1477862',7865.20,0.00,0.00,14.84,296.80,'2022-01-07 20:17:31','',''),(2462667,'1','197','1018',464,'Retail Sale Id 1477863',7400.00,0.00,0.00,12.50,1025.00,'2022-01-07 20:20:52','',''),(2462668,'1','197','1018',464,'Retail Sale Id 1477864',14800.00,0.00,0.00,25.00,2050.00,'2022-01-07 20:21:36','',''),(2462683,'1','197','1018',464,'Retail Sale Id 1477865',6583.04,0.00,0.00,11.12,911.84,'2022-01-07 20:22:54','',''),(2463211,'1','197','1018',464,'Retail Sale Id 1477977',22790.00,0.00,0.00,43.00,860.00,'2022-01-08 07:35:11','',''),(2463324,'1','197','1018',464,'Retail Sale Id 1478077',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 07:51:00','',''),(2463358,'1','197','1018',464,'Retail Sale Id 1478091',6997.44,0.00,0.00,11.82,969.24,'2022-01-08 07:53:16','',''),(2463688,'1','197','1018',464,'Retail Sale Id 1478424',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 08:26:56','',''),(2464286,'1','197','1018',464,'Retail Sale Id 1479036',139405.90,0.00,0.00,263.03,5260.60,'2022-01-08 09:26:01','',''),(2465501,'1','197','1018',464,'Retail Sale Id 1480095',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 11:05:48','',''),(2465509,'1','197','1018',464,'Retail Sale Id 1480111',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 11:06:45','',''),(2465551,'1','197','1018',464,'Return of Retail Sale Id 1480111',0.00,7400.00,12.50,0.00,-1025.00,'2022-01-08 11:10:45','',''),(2465562,'1','197','1018',464,'Return of Retail Sale Id 1480095',0.00,7400.00,12.50,0.00,-1025.00,'2022-01-08 11:11:44','',''),(2465722,'1','197','1018',464,'Retail Sale Id 1480291',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 11:22:31','',''),(2465958,'1','197','1018',464,'Distributed to BABAFRAYO GASD for sales id:344839',23862.90,0.00,0.00,46.79,0.00,'2022-01-08 11:46:30','',''),(2466179,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2743800.00,5380.00,0.00,0.00,'2022-01-08 12:04:15','',''),(2466190,'1','197',NULL,464,'Reception corrector for bridging 130168',0.00,0.00,0.00,5380.00,0.00,'2022-01-08 12:06:11','',''),(2466191,'1','197','1018',464,'Received from bridging 130168',0.00,0.00,5380.00,0.00,0.00,'2022-01-08 12:06:11','',''),(2466270,'1','197','1018',464,'Retail Sale Id 1480806',34980.00,0.00,0.00,66.00,1320.00,'2022-01-08 12:12:18','',''),(2466299,'1','197','1018',464,'Retail Sale Id 1480839',88510.00,0.00,0.00,167.00,3340.00,'2022-01-08 12:15:35','',''),(2466350,'1','197','1018',464,'Retail Sale Id 1480862',21730.00,0.00,0.00,41.00,820.00,'2022-01-08 12:18:59','',''),(2466363,'1','197','1018',464,'Retail Sale Id 1480869',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 12:19:51','',''),(2467456,'1','197','1018',464,'Retail Sale Id 1481828',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 14:05:02','',''),(2467464,'1','197','1018',464,'Retail Sale Id 1481840',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 14:06:03','',''),(2467484,'1','197','1018',464,'Retail Sale Id 1481858',26500.00,0.00,0.00,50.00,1000.00,'2022-01-08 14:08:12','',''),(2467499,'1','197','1018',464,'Retail Sale Id 1481869',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:09:14','',''),(2467547,'1','197','1018',464,'Retail Sale Id 1481900',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:13:11','',''),(2467603,'1','197','1018',464,'Retail Sale Id 1481936',14800.00,0.00,0.00,25.00,2050.00,'2022-01-08 14:16:40','',''),(2467650,'1','197','1018',464,'Retail Sale Id 1481954',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:18:55','',''),(2467672,'1','197','1018',464,'Retail Sale Id 1481975',5399.04,0.00,0.00,9.12,747.84,'2022-01-08 14:21:14','',''),(2467690,'1','197','1018',464,'Retail Sale Id 1481996',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:23:35','',''),(2467732,'1','197','1018',464,'Retail Sale Id 1482023',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 14:26:38','',''),(2467754,'1','197','1018',464,'Retail Sale Id 1482039',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:28:20','',''),(2467770,'1','197','1018',464,'Retail Sale Id 1482056',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:29:30','',''),(2467808,'1','197','1018',464,'Retail Sale Id 1482070',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:32:52','',''),(2467830,'1','197','1018',464,'Retail Sale Id 1482104',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:35:19','',''),(2467859,'1','197','1018',464,'Retail Sale Id 1482137',5600.32,0.00,0.00,9.46,775.72,'2022-01-08 14:37:45','',''),(2467899,'1','197','1018',464,'Retail Sale Id 1482151',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:40:43','',''),(2467928,'1','197','1018',464,'Retail Sale Id 1482177',8880.00,0.00,0.00,15.00,1230.00,'2022-01-08 14:42:45','',''),(2467940,'1','197','1018',464,'Retail Sale Id 1482192',4499.20,0.00,0.00,7.60,623.20,'2022-01-08 14:44:02','',''),(2467952,'1','197','1018',464,'Retail Sale Id 1482204',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:45:04','',''),(2467971,'1','197','1018',464,'Retail Sale Id 1482215',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 14:46:45','',''),(2467989,'1','197','1018',464,'Retail Sale Id 1482234',7897.28,0.00,0.00,13.34,1093.88,'2022-01-08 14:48:16','',''),(2467999,'1','197','1018',464,'Retail Sale Id 1482248',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:49:20','',''),(2468006,'1','197','1018',464,'Retail Sale Id 1482257',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:50:23','',''),(2468028,'1','197','1018',464,'Retail Sale Id 1482270',5399.04,0.00,0.00,9.12,747.84,'2022-01-08 14:51:25','',''),(2468057,'1','197','1018',464,'Retail Sale Id 1482287',4297.92,0.00,0.00,7.26,595.32,'2022-01-08 14:53:09','',''),(2468073,'1','197','1018',464,'Retail Sale Id 1482302',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:54:21','',''),(2468092,'1','197','1018',464,'Retail Sale Id 1482311',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 14:55:20','',''),(2468118,'1','197','1018',464,'Retail Sale Id 1482334',10999.36,0.00,0.00,18.58,1523.56,'2022-01-08 14:57:48','',''),(2468145,'1','197','1018',464,'Retail Sale Id 1482360',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:00:45','',''),(2468150,'1','197','1018',464,'Retail Sale Id 1482367',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:01:51','',''),(2468187,'1','197','1018',464,'Retail Sale Id 1482376',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 15:03:16','',''),(2468261,'1','197','1018',464,'Retail Sale Id 1482451',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:11:50','',''),(2468290,'1','197','1018',464,'Retail Sale Id 1482479',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:15:47','',''),(2468321,'1','197','1018',464,'Retail Sale Id 1482511',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:19:41','',''),(2468332,'1','197','1018',464,'Retail Sale Id 1482520',1799.68,0.00,0.00,3.04,249.28,'2022-01-08 15:20:54','',''),(2468355,'1','197','1018',464,'Retail Sale Id 1482549',10401.44,0.00,0.00,17.57,1440.74,'2022-01-08 15:23:42','',''),(2468398,'1','197','1018',464,'Retail Sale Id 1482577',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 15:26:47','',''),(2468522,'1','197','1018',464,'Retail Sale Id 1482696',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:38:45','',''),(2468625,'1','197','1018',464,'Retail Sale Id 1482772',14000.80,0.00,0.00,23.65,1939.30,'2022-01-08 15:44:58','',''),(2468727,'1','197','1018',464,'Retail Sale Id 1482831',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:51:04','',''),(2468793,'1','197','1018',464,'Retail Sale Id 1482870',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 15:54:36','',''),(2468860,'1','197','1018',464,'Retail Sale Id 1482915',1497.76,0.00,0.00,2.53,207.46,'2022-01-08 15:57:54','',''),(2469216,'1','197','1018',464,'Retail Sale Id 1483268',36040.00,0.00,0.00,68.00,1360.00,'2022-01-08 16:25:17','',''),(2469233,'1','197','1018',464,'Retail Sale Id 1483281',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:26:33','',''),(2469251,'1','197','1018',464,'Retail Sale Id 1483295',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:27:50','',''),(2469284,'1','197','1018',464,'Retail Sale Id 1483330',3001.44,0.00,0.00,5.07,415.74,'2022-01-08 16:30:06','',''),(2469418,'1','197','1018',464,'Retail Sale Id 1483414',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 16:37:51','',''),(2469550,'1','197','1018',464,'Retail Sale Id 1483527',35245.00,0.00,0.00,66.50,1330.00,'2022-01-08 16:48:04','',''),(2469642,'1','197','1018',464,'Retail Sale Id 1483617',12720.00,0.00,0.00,24.00,480.00,'2022-01-08 16:56:07','',''),(2469708,'1','197','1018',464,'Retail Sale Id 1483691',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:01:47','',''),(2469726,'1','197','1018',464,'Retail Sale Id 1483708',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:03:18','',''),(2469816,'1','197','1018',464,'Retail Sale Id 1483786',4001.92,0.00,0.00,6.76,554.32,'2022-01-08 17:08:47','',''),(2469861,'1','197','1018',464,'Retail Sale Id 1483822',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:12:22','',''),(2469873,'1','197','1018',464,'Retail Sale Id 1483850',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:13:35','',''),(2470018,'1','197','1018',464,'Retail Sale Id 1483969',29600.00,0.00,0.00,50.00,4100.00,'2022-01-08 17:22:43','',''),(2470040,'1','197','1018',464,'Retail Sale Id 1483992',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:24:24','',''),(2470069,'1','197','1018',464,'Retail Sale Id 1484027',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 17:27:04','',''),(2470212,'1','197','1018',464,'Retail Sale Id 1484165',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 17:38:03','',''),(2470333,'1','197','1018',464,'Retail Sale Id 1484278',1201.76,0.00,0.00,2.03,166.46,'2022-01-08 17:48:55','',''),(2470405,'1','197','1018',464,'Retail Sale Id 1484388',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 17:56:59','',''),(2470417,'1','197','1018',464,'Retail Sale Id 1484462',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 17:58:16','',''),(2470559,'1','197','1018',464,'Retail Sale Id 1484603',2000.96,0.00,0.00,3.38,277.16,'2022-01-08 18:12:40','',''),(2470560,'1','197','1018',464,'Retail Sale Id 1484603',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:12:40','',''),(2470600,'1','197','1018',464,'Retail Sale Id 1484671',4001.92,0.00,0.00,6.76,554.32,'2022-01-08 18:19:50','',''),(2470608,'1','197','1018',464,'Retail Sale Id 1484681',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 18:20:48','',''),(2470675,'1','197','1018',464,'Retail Sale Id 1484735',3599.36,0.00,0.00,6.08,498.56,'2022-01-08 18:29:25','',''),(2470676,'1','197','1018',464,'Retail Sale Id 1484735',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 18:29:25','',''),(2470745,'1','197','1018',464,'Retail Sale Id 1484782',47170.00,0.00,0.00,89.00,1780.00,'2022-01-08 18:38:30','',''),(2470763,'1','197','1018',464,'Retail Sale Id 1484803',14800.00,0.00,0.00,25.00,2050.00,'2022-01-08 18:42:20','',''),(2470770,'1','197','1018',464,'Retail Sale Id 1484812',7400.00,0.00,0.00,12.50,1025.00,'2022-01-08 18:43:38','',''),(2470815,'1','197','1018',464,'Retail Sale Id 1484837',1000.48,0.00,0.00,1.69,138.58,'2022-01-08 18:49:57','',''),(2471051,'1','197','1018',464,'Retail Sale Id 1485176',132500.00,0.00,0.00,250.00,5000.00,'2022-01-08 19:59:38','',''),(2471056,'1','197','1018',464,'Retail Sale Id 1485182',11644.10,0.00,0.00,21.97,439.40,'2022-01-08 20:11:24','',''),(2471088,'1','197','1018',464,'Retail Sale Id 1485192',29600.00,0.00,0.00,50.00,4100.00,'2022-01-08 20:21:10','',''),(2471089,'1','197','1018',464,'Retail Sale Id 1485194',29600.00,0.00,0.00,50.00,4100.00,'2022-01-08 20:22:08','',''),(2471090,'1','197','1018',464,'Retail Sale Id 1485195',9839.04,0.00,0.00,16.62,1362.84,'2022-01-08 20:22:53','',''),(2474943,'1','197','1018',464,'Retail Sale Id 1488426',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:39:58','',''),(2475001,'1','197','1018',464,'Retail Sale Id 1488462',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:42:06','',''),(2475033,'1','197','1018',464,'Retail Sale Id 1488505',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:44:56','',''),(2475050,'1','197','1018',464,'Retail Sale Id 1488518',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:45:57','',''),(2475078,'1','197','1018',464,'Retail Sale Id 1488543',1397.12,0.00,0.00,2.36,193.52,'2022-01-09 12:48:01','',''),(2475112,'1','197','1018',464,'Retail Sale Id 1488573',7500.64,0.00,0.00,12.67,1038.94,'2022-01-09 12:51:17','',''),(2475126,'1','197','1018',464,'Retail Sale Id 1488595',5600.32,0.00,0.00,9.46,775.72,'2022-01-09 12:52:25','',''),(2475143,'1','197','1018',464,'Retail Sale Id 1488615',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:53:43','',''),(2475169,'1','197','1018',464,'Retail Sale Id 1488630',6002.88,0.00,0.00,10.14,831.48,'2022-01-09 12:54:55','',''),(2475177,'1','197','1018',464,'Retail Sale Id 1488643',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:56:01','',''),(2475189,'1','197','1018',464,'Retail Sale Id 1488653',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 12:56:59','',''),(2475207,'1','197','1018',464,'Retail Sale Id 1488669',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 12:58:32','',''),(2475215,'1','197','1018',464,'Retail Sale Id 1488679',8897.76,0.00,0.00,15.03,1232.46,'2022-01-09 12:59:36','',''),(2475228,'1','197','1018',464,'Retail Sale Id 1488694',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:00:58','',''),(2475243,'1','197','1018',464,'Retail Sale Id 1488708',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:01:55','',''),(2475247,'1','197','1018',464,'Retail Sale Id 1488712',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:02:43','',''),(2475259,'1','197','1018',464,'Retail Sale Id 1488724',4599.84,0.00,0.00,7.77,637.14,'2022-01-09 13:03:47','',''),(2475274,'1','197','1018',464,'Retail Sale Id 1488739',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 13:05:21','',''),(2475306,'1','197','1018',464,'Retail Sale Id 1488767',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:07:33','',''),(2475322,'1','197','1018',464,'Retail Sale Id 1488781',4801.12,0.00,0.00,8.11,665.02,'2022-01-09 13:09:47','',''),(2475346,'1','197','1018',464,'Retail Sale Id 1488806',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:12:43','',''),(2475367,'1','197','1018',464,'Retail Sale Id 1488828',6600.80,0.00,0.00,11.15,914.30,'2022-01-09 13:14:22','',''),(2475512,'1','197','1018',464,'Retail Sale Id 1488844',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 13:27:07','',''),(2475976,'1','197','1018',464,'Retail Sale Id 1489463',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 14:09:30','',''),(2475997,'1','197','1018',464,'Retail Sale Id 1489474',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 14:11:11','',''),(2476047,'1','197','1018',464,'Retail Sale Id 1489532',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 14:16:24','',''),(2476058,'1','197','1018',464,'Retail Sale Id 1489549',35510.00,0.00,0.00,67.00,1340.00,'2022-01-09 14:18:08','',''),(2476091,'1','197','1018',464,'Retail Sale Id 1489580',4297.92,0.00,0.00,7.26,595.32,'2022-01-09 14:22:09','',''),(2476190,'1','197','1018',464,'Retail Sale Id 1489659',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 14:31:16','',''),(2476273,'1','197','1018',464,'Retail Sale Id 1489724',6997.44,0.00,0.00,11.82,969.24,'2022-01-09 14:38:46','',''),(2476318,'1','197','1018',464,'Retail Sale Id 1489741',6997.44,0.00,0.00,11.82,969.24,'2022-01-09 14:40:30','',''),(2476595,'1','197','1018',464,'Retail Sale Id 1489946',6500.16,0.00,0.00,10.98,900.36,'2022-01-09 15:02:27','',''),(2476619,'1','197','1018',464,'Retail Sale Id 1489978',14598.72,0.00,0.00,24.66,2022.12,'2022-01-09 15:05:20','',''),(2476639,'1','197','1018',464,'Retail Sale Id 1489996',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 15:07:09','',''),(2476664,'1','197','1018',464,'Retail Sale Id 1490010',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 15:08:24','',''),(2476672,'1','197','1018',464,'Retail Sale Id 1490017',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 15:09:45','',''),(2476856,'1','197','1018',464,'Retail Sale Id 1490182',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 15:27:25','',''),(2476872,'1','197','1018',464,'Retail Sale Id 1490200',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 15:29:05','',''),(2476894,'1','197','1018',464,'Retail Sale Id 1490219',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 15:31:56','',''),(2476895,'1','197','1018',464,'Retail Sale Id 1490219',5920.00,0.00,0.00,10.00,820.00,'2022-01-09 15:31:56','',''),(2477043,'1','197','1018',464,'Retail Sale Id 1490351',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 15:46:20','',''),(2477044,'1','197','1018',464,'Retail Sale Id 1490351',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 15:46:20','',''),(2477137,'1','197','1018',464,'Retail Sale Id 1490422',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 15:56:36','',''),(2477204,'1','197','1018',464,'Retail Sale Id 1490467',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 15:59:50','',''),(2477304,'1','197','1018',464,'Retail Sale Id 1490546',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 16:09:54','',''),(2477333,'1','197','1018',464,'Retail Sale Id 1490579',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 16:13:07','',''),(2477555,'1','197','1018',464,'Retail Sale Id 1490764',1799.68,0.00,0.00,3.04,249.28,'2022-01-09 16:35:47','',''),(2477556,'1','197','1018',464,'Retail Sale Id 1490764',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 16:35:47','',''),(2477615,'1','197','1018',464,'Retail Sale Id 1491016',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 16:43:23','',''),(2477637,'1','197','1018',464,'Retail Sale Id 1491025',5002.40,0.00,0.00,8.45,692.90,'2022-01-09 16:44:26','',''),(2477795,'1','197','1018',464,'Retail Sale Id 1491182',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 16:57:09','',''),(2477954,'1','197','1018',464,'Retail Sale Id 1491380',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 17:11:26','',''),(2478045,'1','197','1018',464,'Retail Sale Id 1491451',3001.44,0.00,0.00,5.07,415.74,'2022-01-09 17:20:57','',''),(2478062,'1','197','1018',464,'Retail Sale Id 1491469',10999.36,0.00,0.00,18.58,1523.56,'2022-01-09 17:23:10','',''),(2478100,'1','197','1018',464,'Retail Sale Id 1491498',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 17:26:27','',''),(2478126,'1','197','1018',464,'Retail Sale Id 1491513',3599.36,0.00,0.00,6.08,498.56,'2022-01-09 17:28:12','',''),(2478180,'1','197','1018',464,'Retail Sale Id 1491556',8897.76,0.00,0.00,15.03,1232.46,'2022-01-09 17:32:36','',''),(2478751,'1','197','1018',464,'Retail Sale Id 1491988',3700.00,0.00,0.00,6.25,512.50,'2022-01-09 18:54:47','',''),(2478785,'1','197','1018',464,'Retail Sale Id 1491994',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 18:57:44','',''),(2478788,'1','197','1018',464,'Retail Sale Id 1491997',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 18:59:13','',''),(2478891,'1','197','1018',464,'Retail Sale Id 1492075',6625.00,0.00,0.00,12.50,250.00,'2022-01-09 19:45:19','',''),(2478897,'1','197','1018',464,'Retail Sale Id 1492078',7400.00,0.00,0.00,12.50,1025.00,'2022-01-09 19:46:59','',''),(2478898,'1','197','1018',464,'Retail Sale Id 1492079',6452.80,0.00,0.00,10.90,893.80,'2022-01-09 19:47:42','',''),(2479777,'1','197','1018',464,'Retail Sale Id 1492365',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 08:06:24','',''),(2479782,'1','197','1018',464,'Retail Sale Id 1492370',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 08:07:16','',''),(2479791,'1','197','1018',464,'Retail Sale Id 1492383',29600.00,0.00,0.00,50.00,4100.00,'2022-01-10 08:09:10','',''),(2479818,'1','197','1018',464,'Retail Sale Id 1492416',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 08:11:46','',''),(2479947,'1','197','1018',464,'Retail Sale Id 1492537',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 08:25:28','',''),(2480329,'1','197','1018',464,'Retail Sale Id 1492891',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 09:04:07','',''),(2480583,'1','197','1018',464,'Retail Sale Id 1493072',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 09:23:53','',''),(2480725,'1','197','1018',464,'Retail Sale Id 1493191',6997.44,0.00,0.00,11.82,969.24,'2022-01-10 09:36:35','',''),(2481486,'1','197','1018',464,'Retail Sale Id 1493887',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 11:00:03','',''),(2481500,'1','197','1018',464,'Retail Sale Id 1493896',4801.12,0.00,0.00,8.11,665.02,'2022-01-10 11:01:22','',''),(2481702,'1','197','1018',464,'Retail Sale Id 1494077',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 11:25:17','',''),(2481790,'1','197','1018',464,'Retail Sale Id 1494165',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 11:35:52','',''),(2482263,'1','197','1018',464,'Retail Sale Id 1494536',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 12:26:06','',''),(2482398,'1','197','1018',464,'Retail Sale Id 1494639',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 12:35:23','',''),(2482410,'1','197','1018',464,'Retail Sale Id 1494656',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 12:36:21','',''),(2482443,'1','197','1018',464,'Retail Sale Id 1494689',10600.00,0.00,0.00,20.00,400.00,'2022-01-10 12:40:53','',''),(2482504,'1','197','1018',464,'Retail Sale Id 1494752',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 12:48:25','',''),(2482523,'1','197','1018',464,'Retail Sale Id 1494782',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 12:49:29','',''),(2482586,'1','197','1018',464,'Retail Sale Id 1494852',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 12:56:58','',''),(2482606,'1','197','1018',464,'Retail Sale Id 1494874',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 12:59:58','',''),(2482695,'1','197','1018',464,'Retail Sale Id 1494970',1201.76,0.00,0.00,2.03,166.46,'2022-01-10 13:12:26','',''),(2482729,'1','197','1018',464,'Retail Sale Id 1495014',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 13:18:49','',''),(2482822,'1','197','1018',464,'Retail Sale Id 1495110',8880.00,0.00,0.00,15.00,1230.00,'2022-01-10 13:34:32','',''),(2482915,'1','197','1018',464,'Retail Sale Id 1495211',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 13:51:01','',''),(2484233,'1','197','1018',464,'Retail Sale Id 1496469',29600.00,0.00,0.00,50.00,4100.00,'2022-01-10 16:17:17','',''),(2484303,'1','197','1018',464,'Retail Sale Id 1496520',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 16:24:36','',''),(2484331,'1','197','1018',464,'Retail Sale Id 1496550',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 16:28:08','',''),(2484509,'1','197','1018',464,'Retail Sale Id 1496683',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 16:44:15','',''),(2484544,'1','197','1018',464,'Retail Sale Id 1496710',6600.80,0.00,0.00,11.15,914.30,'2022-01-10 16:47:24','',''),(2484560,'1','197','1018',464,'Retail Sale Id 1496728',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 16:48:49','',''),(2484576,'1','197','1018',464,'Retail Sale Id 1496739',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 16:50:19','',''),(2484603,'1','197','1018',464,'Retail Sale Id 1496751',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 16:52:14','',''),(2484638,'1','197','1018',464,'Retail Sale Id 1496773',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:54:41','',''),(2484653,'1','197','1018',464,'Retail Sale Id 1496794',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 16:56:23','',''),(2484676,'1','197','1018',464,'Retail Sale Id 1496820',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 16:58:53','',''),(2484695,'1','197','1018',464,'Retail Sale Id 1496839',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:01:04','',''),(2484724,'1','197','1018',464,'Retail Sale Id 1496852',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:02:20','',''),(2484771,'1','197','1018',464,'Retail Sale Id 1496875',7701.92,0.00,0.00,13.01,1066.82,'2022-01-10 17:05:00','',''),(2484839,'1','197','1018',464,'Retail Sale Id 1496927',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:09:21','',''),(2484883,'1','197','1018',464,'Retail Sale Id 1496975',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:13:59','',''),(2484929,'1','197','1018',464,'Retail Sale Id 1497010',14800.00,0.00,0.00,25.00,2050.00,'2022-01-10 17:18:03','',''),(2484955,'1','197','1018',464,'Retail Sale Id 1497029',1497.76,0.00,0.00,2.53,207.46,'2022-01-10 17:19:41','',''),(2484956,'1','197','1018',464,'Retail Sale Id 1497029',14800.00,0.00,0.00,25.00,2050.00,'2022-01-10 17:19:41','',''),(2485030,'1','197','1018',464,'Retail Sale Id 1497064',14800.00,0.00,0.00,25.00,2050.00,'2022-01-10 17:22:57','',''),(2485049,'1','197','1018',464,'Retail Sale Id 1497087',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:24:53','',''),(2485050,'1','197','1018',464,'Retail Sale Id 1497087',14800.00,0.00,0.00,25.00,2050.00,'2022-01-10 17:24:53','',''),(2485095,'1','197','1018',464,'Retail Sale Id 1497122',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 17:26:55','',''),(2485096,'1','197','1018',464,'Retail Sale Id 1497122',2498.24,0.00,0.00,4.22,346.04,'2022-01-10 17:26:55','',''),(2485097,'1','197','1018',464,'Retail Sale Id 1497122',4001.92,0.00,0.00,6.76,554.32,'2022-01-10 17:26:55','',''),(2485128,'1','197','1018',464,'Retail Sale Id 1497152',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:29:11','',''),(2485129,'1','197','1018',464,'Retail Sale Id 1497152',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 17:29:11','',''),(2485130,'1','197','1018',464,'Retail Sale Id 1497152',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:29:11','',''),(2485131,'1','197','1018',464,'Retail Sale Id 1497152',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:29:11','',''),(2485146,'1','197','1018',464,'Retail Sale Id 1497160',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:29:54','',''),(2485207,'1','197','1018',464,'Retail Sale Id 1497181',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:32:57','',''),(2485250,'1','197','1018',464,'Retail Sale Id 1497228',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 17:37:25','',''),(2485280,'1','197','1018',464,'Retail Sale Id 1497262',1000.48,0.00,0.00,1.69,138.58,'2022-01-10 17:39:59','',''),(2485317,'1','197','1018',464,'Retail Sale Id 1497300',5002.40,0.00,0.00,8.45,692.90,'2022-01-10 17:43:47','',''),(2485372,'1','197','1018',464,'Retail Sale Id 1497357',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 17:48:49','',''),(2485615,'1','197','1018',464,'Retail Sale Id 1497389',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 18:14:04','',''),(2485667,'1','197','1018',464,'Retail Sale Id 1497645',2000.96,0.00,0.00,3.38,277.16,'2022-01-10 18:21:00','',''),(2485718,'1','197','1018',464,'Retail Sale Id 1497702',3001.44,0.00,0.00,5.07,415.74,'2022-01-10 18:29:57','',''),(2485726,'1','197','1018',464,'Retail Sale Id 1497710',3297.44,0.00,0.00,5.57,456.74,'2022-01-10 18:30:58','',''),(2485883,'1','197','1018',464,'Retail Sale Id 1497890',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 18:55:45','',''),(2485888,'1','197','1018',464,'Retail Sale Id 1497896',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 18:57:08','',''),(2485889,'1','197','1018',464,'Retail Sale Id 1497896',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 18:57:08','',''),(2485909,'1','197','1018',464,'Retail Sale Id 1497912',14800.00,0.00,0.00,25.00,2050.00,'2022-01-10 19:04:59','',''),(2485921,'1','197','1018',464,'Retail Sale Id 1497915',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 19:05:57','',''),(2485958,'1','197','1018',464,'Retail Sale Id 1497962',1799.68,0.00,0.00,3.04,249.28,'2022-01-10 19:19:01','',''),(2485959,'1','197','1018',464,'Retail Sale Id 1497962',3599.36,0.00,0.00,6.08,498.56,'2022-01-10 19:19:01','',''),(2486005,'1','197','1018',464,'Retail Sale Id 1498014',53000.00,0.00,0.00,100.00,2000.00,'2022-01-10 19:53:09','',''),(2486007,'1','197','1018',464,'Retail Sale Id 1498016',13250.00,0.00,0.00,25.00,500.00,'2022-01-10 19:57:17','',''),(2486008,'1','197','1018',464,'Retail Sale Id 1498017',7400.00,0.00,0.00,12.50,1025.00,'2022-01-10 20:00:20','',''),(2486010,'1','197','1018',464,'Retail Sale Id 1498018',7838.08,0.00,0.00,13.24,1085.68,'2022-01-10 20:01:59','',''),(2486582,'1','197','1018',464,'Retail Sale Id 1498234',10401.44,0.00,0.00,17.57,1440.74,'2022-01-11 07:47:02','',''),(2486613,'1','197','1018',464,'Retail Sale Id 1498264',14999.00,0.00,0.00,28.30,566.00,'2022-01-11 07:50:15','',''),(2487355,'1','197','1018',464,'Retail Sale Id 1498861',2498.24,0.00,0.00,4.22,346.04,'2022-01-11 08:53:54','',''),(2487409,'1','197','1018',464,'Retail Sale Id 1498909',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 08:59:33','',''),(2487423,'1','197','1018',464,'Retail Sale Id 1498923',29600.00,0.00,0.00,50.00,4100.00,'2022-01-11 09:01:25','',''),(2487443,'1','197','1018',464,'Retail Sale Id 1498939',4499.20,0.00,0.00,7.60,623.20,'2022-01-11 09:03:21','',''),(2487479,'1','197','1018',464,'Retail Sale Id 1498980',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 09:07:32','',''),(2487839,'1','197','1018',464,'Retail Sale Id 1499261',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 09:41:40','',''),(2488008,'1','197','1018',464,'Retail Sale Id 1499412',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 09:58:15','',''),(2488416,'1','197','1018',464,'Retail Sale Id 1499742',3599.36,0.00,0.00,6.08,498.56,'2022-01-11 10:37:52','',''),(2489280,'1','197','1018',464,'Retail Sale Id 1500503',15096.00,0.00,0.00,25.50,2091.00,'2022-01-11 12:07:41','',''),(2489496,'1','197','1018',464,'Retail Sale Id 1500756',3001.44,0.00,0.00,5.07,415.74,'2022-01-11 12:43:37','',''),(2489538,'1','197','1018',464,'Retail Sale Id 1500789',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 12:49:33','',''),(2489651,'1','197','1018',464,'Retail Sale Id 1500910',1000.48,0.00,0.00,1.69,138.58,'2022-01-11 13:06:57','',''),(2489859,'1','197','1018',464,'Retail Sale Id 1501105',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 13:32:17','',''),(2489886,'1','197','1018',464,'Retail Sale Id 1501131',3498.72,0.00,0.00,5.91,484.62,'2022-01-11 13:35:25','',''),(2489943,'1','197','1018',464,'Retail Sale Id 1501183',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 13:41:29','',''),(2490141,'1','197','1018',464,'Retail Sale Id 1501362',2498.24,0.00,0.00,4.22,346.04,'2022-01-11 14:04:51','',''),(2490181,'1','197','1018',464,'Retail Sale Id 1501402',2000.96,0.00,0.00,3.38,277.16,'2022-01-11 14:10:21','',''),(2490492,'1','197','1018',464,'Retail Sale Id 1501640',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 14:35:11','',''),(2490513,'1','197','1018',464,'Retail Sale Id 1501649',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 14:36:06','',''),(2490558,'1','197','1018',464,'Retail Sale Id 1501684',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 14:41:34','',''),(2490952,'1','197','1018',464,'Retail Sale Id 1501930',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 15:13:52','',''),(2491152,'1','197','1018',464,'Retail Sale Id 1502069',3599.36,0.00,0.00,6.08,498.56,'2022-01-11 15:28:50','',''),(2491204,'1','197','1018',464,'Retail Sale Id 1502111',9602.24,0.00,0.00,16.22,1330.04,'2022-01-11 15:34:01','',''),(2491286,'1','197','1018',464,'Retail Sale Id 1502196',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 15:41:30','',''),(2491325,'1','197','1018',464,'Retail Sale Id 1502217',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 15:43:40','',''),(2491464,'1','197','1018',464,'Retail Sale Id 1502363',2000.96,0.00,0.00,3.38,277.16,'2022-01-11 16:01:23','',''),(2491554,'1','197','1018',464,'Retail Sale Id 1502442',3599.36,0.00,0.00,6.08,498.56,'2022-01-11 16:11:03','',''),(2491573,'1','197','1018',464,'Retail Sale Id 1502458',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 16:12:30','',''),(2491666,'1','197','1018',464,'Retail Sale Id 1502552',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 16:22:35','',''),(2491835,'1','197','1018',464,'Retail Sale Id 1502733',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 16:39:08','',''),(2491854,'1','197','1018',464,'Retail Sale Id 1502753',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 16:40:32','',''),(2491865,'1','197','1018',464,'Retail Sale Id 1502764',10401.44,0.00,0.00,17.57,1440.74,'2022-01-11 16:41:33','',''),(2491877,'1','197','1018',464,'Retail Sale Id 1502775',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 16:42:54','',''),(2491893,'1','197','1018',464,'Retail Sale Id 1502795',9998.88,0.00,0.00,16.89,1384.98,'2022-01-11 16:43:48','',''),(2491902,'1','197','1018',464,'Retail Sale Id 1502803',5002.40,0.00,0.00,8.45,692.90,'2022-01-11 16:44:28','',''),(2491935,'1','197','1018',464,'Retail Sale Id 1502834',1000.48,0.00,0.00,1.69,138.58,'2022-01-11 16:47:12','',''),(2491976,'1','197','1018',464,'Retail Sale Id 1502868',44400.00,0.00,0.00,75.00,6150.00,'2022-01-11 16:50:09','',''),(2492003,'1','197','1018',464,'Retail Sale Id 1502894',3001.44,0.00,0.00,5.07,415.74,'2022-01-11 16:52:11','',''),(2492116,'1','197','1018',464,'Retail Sale Id 1502983',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 16:59:59','',''),(2492164,'1','197','1018',464,'Retail Sale Id 1503014',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 17:03:04','',''),(2492197,'1','197','1018',464,'Retail Sale Id 1503041',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 17:05:11','',''),(2492264,'1','197','1018',464,'Retail Sale Id 1503104',1799.68,0.00,0.00,3.04,249.28,'2022-01-11 17:09:38','',''),(2492293,'1','197','1018',464,'Retail Sale Id 1503135',3599.36,0.00,0.00,6.08,498.56,'2022-01-11 17:11:51','',''),(2492315,'1','197','1018',464,'Retail Sale Id 1503159',26500.00,0.00,0.00,50.00,1000.00,'2022-01-11 17:13:24','',''),(2492333,'1','197','1018',464,'Retail Sale Id 1503171',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 17:14:15','',''),(2492360,'1','197','1018',464,'Retail Sale Id 1503195',58830.00,0.00,0.00,111.00,2220.00,'2022-01-11 17:16:10','',''),(2492452,'1','197','1018',464,'Retail Sale Id 1503286',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 17:23:57','',''),(2492577,'1','197','1018',464,'Retail Sale Id 1503410',1000.48,0.00,0.00,1.69,138.58,'2022-01-11 17:34:32','',''),(2492650,'1','197','1018',464,'Retail Sale Id 1503494',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 17:40:36','',''),(2492673,'1','197','1018',464,'Retail Sale Id 1503511',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 17:41:54','',''),(2492684,'1','197','1018',464,'Retail Sale Id 1503523',1497.76,0.00,0.00,2.53,207.46,'2022-01-11 17:42:58','',''),(2492746,'1','197','1018',464,'Retail Sale Id 1503584',3001.44,0.00,0.00,5.07,415.74,'2022-01-11 17:48:40','',''),(2492812,'1','197','1018',464,'Retail Sale Id 1503658',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 17:54:32','',''),(2492930,'1','197','1018',464,'Retail Sale Id 1503755',1000.48,0.00,0.00,1.69,138.58,'2022-01-11 18:03:25','',''),(2492942,'1','197','1018',464,'Retail Sale Id 1503769',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 18:04:58','',''),(2493020,'1','197','1018',464,'Retail Sale Id 1503847',12455.00,0.00,0.00,23.50,470.00,'2022-01-11 18:15:59','',''),(2493052,'1','197','1018',464,'Retail Sale Id 1503860',8880.00,0.00,0.00,15.00,1230.00,'2022-01-11 18:17:42','',''),(2493151,'1','197','1018',464,'Retail Sale Id 1503931',3202.72,0.00,0.00,5.41,443.62,'2022-01-11 18:32:34','',''),(2493156,'1','197','1018',464,'Retail Sale Id 1503936',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 18:33:17','',''),(2493183,'1','197','1018',464,'Retail Sale Id 1503963',7400.00,0.00,0.00,12.50,1025.00,'2022-01-11 18:39:05','',''),(2493392,'1','197','1018',464,'Retail Sale Id 1504130',3599.36,0.00,0.00,6.08,498.56,'2022-01-11 19:10:45','',''),(2493443,'1','197','1018',464,'Retail Sale Id 1504178',2498.24,0.00,0.00,4.22,346.04,'2022-01-11 19:24:33','',''),(2493560,'1','197','1018',464,'Retail Sale Id 1504244',14800.00,0.00,0.00,25.00,2050.00,'2022-01-11 20:13:54','',''),(2493562,'1','197','1018',464,'Retail Sale Id 1504246',9110.88,0.00,0.00,15.39,1261.98,'2022-01-11 20:14:40','',''),(2493566,'1','197','1018',464,'Retail Sale Id 1504249',41711.00,0.00,0.00,78.70,1574.00,'2022-01-11 20:18:04','',''),(2494291,'1','197','1018',464,'Retail Sale Id 1504482',4001.92,0.00,0.00,6.76,554.32,'2022-01-12 07:53:57','',''),(2494296,'1','197','1018',464,'Retail Sale Id 1504486',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 07:55:08','',''),(2494382,'1','197','1018',464,'Retail Sale Id 1504576',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 08:09:16','',''),(2495125,'1','197','1018',464,'Retail Sale Id 1505204',2000.96,0.00,0.00,3.38,277.16,'2022-01-12 09:12:55','',''),(2495156,'1','197','1018',464,'Retail Sale Id 1505219',9010.00,0.00,0.00,17.00,340.00,'2022-01-12 09:14:21','',''),(2495231,'1','197','1018',464,'Retail Sale Id 1505296',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 09:21:00','',''),(2495551,'1','197','1018',464,'Retail Sale Id 1505588',10401.44,0.00,0.00,17.57,1440.74,'2022-01-12 09:47:26','',''),(2495635,'1','197','1018',464,'Retail Sale Id 1505636',3700.00,0.00,0.00,6.25,512.50,'2022-01-12 09:52:48','',''),(2495785,'1','197','1018',464,'Retail Sale Id 1505741',1497.76,0.00,0.00,2.53,207.46,'2022-01-12 10:04:04','',''),(2495818,'1','197','1018',464,'Retail Sale Id 1505781',4197.28,0.00,0.00,7.09,581.38,'2022-01-12 10:06:11','',''),(2496070,'1','197','1018',464,'Retail Sale Id 1506070',1201.76,0.00,0.00,2.03,166.46,'2022-01-12 10:28:58','',''),(2496190,'1','197','1018',464,'Retail Sale Id 1506214',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 10:42:44','',''),(2496400,'1','197','1018',464,'Retail Sale Id 1506419',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 11:01:24','',''),(2496444,'1','197','1018',464,'Retail Sale Id 1506475',2000.96,0.00,0.00,3.38,277.16,'2022-01-12 11:06:01','',''),(2497134,'1','197','1018',464,'Retail Sale Id 1507103',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 12:15:54','',''),(2497235,'1','197','1018',464,'Retail Sale Id 1507211',1497.76,0.00,0.00,2.53,207.46,'2022-01-12 12:25:18','',''),(2497447,'1','197','1018',464,'Retail Sale Id 1507437',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 12:52:58','',''),(2497656,'1','197','1018',464,'Retail Sale Id 1507632',117660.00,0.00,0.00,222.00,4440.00,'2022-01-12 13:18:39','',''),(2497733,'1','197','1018',464,'Retail Sale Id 1507716',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 13:27:44','',''),(2497982,'1','197','1018',464,'Retail Sale Id 1507951',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 14:00:04','',''),(2498024,'1','197','1018',464,'Retail Sale Id 1507982',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 14:02:49','',''),(2498090,'1','197','1018',464,'Retail Sale Id 1508005',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 14:09:07','',''),(2498108,'1','197','1018',464,'Retail Sale Id 1508082',1799.68,0.00,0.00,3.04,249.28,'2022-01-12 14:11:27','',''),(2498334,'1','197','1018',464,'Retail Sale Id 1508278',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 14:29:23','',''),(2498593,'1','197','1018',464,'Retail Sale Id 1508522',14800.00,0.00,0.00,25.00,2050.00,'2022-01-12 14:55:46','',''),(2498683,'1','197','1018',464,'Retail Sale Id 1508583',2551.52,0.00,0.00,4.31,353.42,'2022-01-12 15:01:03','',''),(2498897,'1','197','1018',464,'Retail Sale Id 1508730',1799.68,0.00,0.00,3.04,249.28,'2022-01-12 15:13:49','',''),(2498998,'1','197','1018',464,'Retail Sale Id 1508820',14800.00,0.00,0.00,25.00,2050.00,'2022-01-12 15:24:00','',''),(2499299,'1','197','1018',464,'Retail Sale Id 1509079',26500.00,0.00,0.00,50.00,1000.00,'2022-01-12 15:52:13','',''),(2499589,'1','197','1018',464,'Retail Sale Id 1509373',3001.44,0.00,0.00,5.07,415.74,'2022-01-12 16:25:42','',''),(2499637,'1','197','1018',464,'Retail Sale Id 1509406',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 16:29:13','',''),(2499648,'1','197','1018',464,'Retail Sale Id 1509418',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 16:30:50','',''),(2499795,'1','197','1018',464,'Retail Sale Id 1509557',5399.04,0.00,0.00,9.12,747.84,'2022-01-12 16:43:11','',''),(2500018,'1','197','1018',464,'Retail Sale Id 1509747',9199.68,0.00,0.00,15.54,1274.28,'2022-01-12 16:59:25','',''),(2500063,'1','197','1018',464,'Retail Sale Id 1509795',2000.96,0.00,0.00,3.38,277.16,'2022-01-12 17:03:29','',''),(2500143,'1','197','1018',464,'Retail Sale Id 1509878',14800.00,0.00,0.00,25.00,2050.00,'2022-01-12 17:11:51','',''),(2500251,'1','197','1018',464,'Retail Sale Id 1509971',6997.44,0.00,0.00,11.82,969.24,'2022-01-12 17:21:28','',''),(2500301,'1','197','1018',464,'Retail Sale Id 1510022',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 17:26:24','',''),(2500337,'1','197','1018',464,'Retail Sale Id 1510053',3001.44,0.00,0.00,5.07,415.74,'2022-01-12 17:30:07','',''),(2500442,'1','197','1018',464,'Retail Sale Id 1510145',1799.68,0.00,0.00,3.04,249.28,'2022-01-12 17:38:35','',''),(2500457,'1','197','1018',464,'Retail Sale Id 1510159',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 17:40:03','',''),(2500478,'1','197','1018',464,'Retail Sale Id 1510188',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 17:42:25','',''),(2500500,'1','197','1018',464,'Retail Sale Id 1510207',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 17:44:34','',''),(2500516,'1','197','1018',464,'Retail Sale Id 1510221',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 17:46:06','',''),(2500537,'1','197','1018',464,'Retail Sale Id 1510239',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 17:47:40','',''),(2500559,'1','197','1018',464,'Retail Sale Id 1510263',37000.00,0.00,0.00,62.50,5125.00,'2022-01-12 17:49:52','',''),(2500573,'1','197','1018',464,'Retail Sale Id 1510277',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 17:51:03','',''),(2500835,'1','197','1018',464,'Retail Sale Id 1510567',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 18:14:16','',''),(2500854,'1','197','1018',464,'Retail Sale Id 1510587',597.92,0.00,0.00,1.01,82.82,'2022-01-12 18:16:26','',''),(2500886,'1','197','1018',464,'Retail Sale Id 1510616',6997.44,0.00,0.00,11.82,969.24,'2022-01-12 18:20:42','',''),(2500929,'1','197','1018',464,'Retail Sale Id 1510664',3599.36,0.00,0.00,6.08,498.56,'2022-01-12 18:27:26','',''),(2500936,'1','197','1018',464,'Retail Sale Id 1510671',7400.00,0.00,0.00,12.50,1025.00,'2022-01-12 18:28:21','',''),(2501048,'1','197','1018',464,'Retail Sale Id 1510816',3001.44,0.00,0.00,5.07,415.74,'2022-01-12 18:51:00','',''),(2501280,'1','197','1018',464,'Retail Sale Id 1511012',1799.68,0.00,0.00,3.04,249.28,'2022-01-12 19:29:25','',''),(2501360,'1','197','1018',464,'Retail Sale Id 1511048',8880.00,0.00,0.00,15.00,1230.00,'2022-01-12 19:43:33','',''),(2501413,'1','197','1018',464,'Return of Retail Sale Id 1510567',0.00,7400.00,12.50,0.00,-1025.00,'2022-01-12 20:06:54','',''),(2501414,'1','197','1018',464,'Return of Retail Sale Id 1510816',0.00,3001.44,5.07,0.00,-415.74,'2022-01-12 20:07:44','',''),(2501425,'1','197','1018',464,'Return of Retail Sale Id 1506070',0.00,1201.76,2.03,0.00,-166.46,'2022-01-12 20:10:14','',''),(2501430,'1','197','1018',464,'Retail Sale Id 1511075',1160.32,0.00,0.00,1.96,160.72,'2022-01-12 20:11:41','',''),(2501432,'1','197','1018',464,'Retail Sale Id 1511076',69816.90,0.00,0.00,131.73,2634.60,'2022-01-12 20:13:16','',''),(2501968,'1','197','1018',464,'Retail Sale Id 1511310',9010.00,0.00,0.00,17.00,340.00,'2022-01-13 07:57:42','',''),(2501981,'1','197','1018',464,'Retail Sale Id 1511321',4001.92,0.00,0.00,6.76,554.32,'2022-01-13 07:59:23','',''),(2501997,'1','197','1018',464,'Retail Sale Id 1511339',10798.08,0.00,0.00,18.24,1495.68,'2022-01-13 08:01:08','',''),(2502002,'1','197','1018',464,'Retail Sale Id 1511343',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 08:01:47','',''),(2503479,'1','197','1018',464,'Retail Sale Id 1511508',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 10:14:05','',''),(2503489,'1','197','1018',464,'Retail Sale Id 1512418',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 10:15:14','',''),(2505408,'1','197','1018',464,'Retail Sale Id 1514255',14894.72,0.00,0.00,25.16,2063.12,'2022-01-13 13:26:59','',''),(2505478,'1','197','1018',464,'Return of Retail Sale Id 1511310',0.00,9010.00,17.00,0.00,-340.00,'2022-01-13 13:35:49','',''),(2505483,'1','197','1018',464,'Retail Sale Id 1514334',9100.10,0.00,0.00,17.17,343.40,'2022-01-13 13:36:29','',''),(2505540,'1','197','1018',464,'Distributed to AMAZING GRASE for sales id:345983',45624.60,0.00,0.00,89.46,0.00,'2022-01-13 13:43:01','',''),(2505598,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,510000.00,1000.00,0.00,0.00,'2022-01-13 13:46:52','',''),(2505610,'1','197',NULL,464,'Reception corrector for bridging 130729',0.00,0.00,0.00,1000.00,0.00,'2022-01-13 13:48:28','',''),(2505611,'1','197','1018',464,'Received from bridging 130729',0.00,0.00,1000.00,0.00,0.00,'2022-01-13 13:48:28','',''),(2505623,'1','197','1018',464,'Retail Sale Id 1514432',40002.16,0.00,0.00,76.34,1068.76,'2022-01-13 13:50:52','',''),(2505632,'1','197','1018',464,'Retail Sale Id 1514440',2000.96,0.00,0.00,3.38,277.16,'2022-01-13 13:52:12','',''),(2505714,'1','197','1018',464,'Retail Sale Id 1514512',29600.00,0.00,0.00,50.00,4100.00,'2022-01-13 14:00:48','',''),(2505744,'1','197','1018',464,'Retail Sale Id 1514535',1799.68,0.00,0.00,3.04,249.28,'2022-01-13 14:03:27','',''),(2505751,'1','197','1018',464,'Retail Sale Id 1514543',2000.96,0.00,0.00,3.38,277.16,'2022-01-13 14:04:22','',''),(2505793,'1','197','1018',464,'Retail Sale Id 1514580',2000.96,0.00,0.00,3.38,277.16,'2022-01-13 14:09:05','',''),(2505847,'1','197','1018',464,'Retail Sale Id 1514618',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 14:15:08','',''),(2505962,'1','197','1018',464,'Retail Sale Id 1514728',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 14:30:28','',''),(2506091,'1','197','1018',464,'Retail Sale Id 1514800',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 14:42:10','',''),(2506312,'1','197','1018',464,'Retail Sale Id 1514898',2000.96,0.00,0.00,3.38,277.16,'2022-01-13 15:05:09','',''),(2506314,'1','197','1018',464,'Retail Sale Id 1514986',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 15:05:38','',''),(2506358,'1','197','1018',464,'Retail Sale Id 1515027',3001.44,0.00,0.00,5.07,415.74,'2022-01-13 15:11:03','',''),(2507033,'1','197','1018',464,'Retail Sale Id 1515486',1497.76,0.00,0.00,2.53,207.46,'2022-01-13 16:05:13','',''),(2507257,'1','197','1018',464,'Retail Sale Id 1515657',3001.44,0.00,0.00,5.07,415.74,'2022-01-13 16:24:45','',''),(2507264,'1','197','1018',464,'Retail Sale Id 1515664',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 16:25:21','',''),(2507363,'1','197','1018',464,'Retail Sale Id 1515766',1799.68,0.00,0.00,3.04,249.28,'2022-01-13 16:37:11','',''),(2507370,'1','197','1018',464,'Retail Sale Id 1515773',10999.36,0.00,0.00,18.58,1523.56,'2022-01-13 16:38:24','',''),(2507392,'1','197','1018',464,'Retail Sale Id 1515793',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 16:41:08','',''),(2507511,'1','197','1018',464,'Retail Sale Id 1515931',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 16:53:53','',''),(2507528,'1','197','1018',464,'Retail Sale Id 1515949',2498.24,0.00,0.00,4.22,346.04,'2022-01-13 16:55:24','',''),(2507641,'1','197','1018',464,'Retail Sale Id 1516087',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 17:06:22','',''),(2507651,'1','197','1018',464,'Retail Sale Id 1516097',6002.88,0.00,0.00,10.14,831.48,'2022-01-13 17:07:25','',''),(2507821,'1','197','1018',464,'Retail Sale Id 1516324',67150.60,0.00,0.00,128.15,1794.10,'2022-01-13 17:24:24','',''),(2508081,'1','197','1018',464,'Retail Sale Id 1516602',4540.64,0.00,0.00,7.67,628.94,'2022-01-13 17:51:36','',''),(2508278,'1','197','1018',464,'Retail Sale Id 1516746',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 18:06:20','',''),(2508296,'1','197','1018',464,'Retail Sale Id 1516757',13100.00,0.00,0.00,25.00,350.00,'2022-01-13 18:07:46','',''),(2508379,'1','197','1018',464,'Retail Sale Id 1516846',1799.68,0.00,0.00,3.04,249.28,'2022-01-13 18:22:33','',''),(2508412,'1','197','1018',464,'Retail Sale Id 1516887',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 18:29:21','',''),(2508417,'1','197','1018',464,'Retail Sale Id 1516894',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 18:30:19','',''),(2508468,'1','197','1018',464,'Retail Sale Id 1516981',2000.96,0.00,0.00,3.38,277.16,'2022-01-13 18:42:35','',''),(2508516,'1','197','1018',464,'Retail Sale Id 1517067',4001.92,0.00,0.00,6.76,554.32,'2022-01-13 18:48:17','',''),(2508531,'1','197','1018',464,'Retail Sale Id 1517077',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 18:50:48','',''),(2508559,'1','197','1018',464,'Retail Sale Id 1517086',3001.44,0.00,0.00,5.07,415.74,'2022-01-13 18:52:38','',''),(2508581,'1','197','1018',464,'Retail Sale Id 1517099',7400.00,0.00,0.00,12.50,1025.00,'2022-01-13 18:54:31','',''),(2508597,'1','197','1018',464,'Retail Sale Id 1517109',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 18:57:06','',''),(2508653,'1','197','1018',464,'Retail Sale Id 1517154',3599.36,0.00,0.00,6.08,498.56,'2022-01-13 19:06:45','',''),(2508870,'1','197','1018',464,'Return of Retail Sale Id 1516894',0.00,7400.00,12.50,0.00,-1025.00,'2022-01-13 19:52:45','',''),(2508960,'1','197','1018',464,'Retail Sale Id 1517314',4534.72,0.00,0.00,7.66,628.12,'2022-01-13 20:09:15','',''),(2508977,'1','197','1018',464,'Retail Sale Id 1517317',26200.00,0.00,0.00,50.00,700.00,'2022-01-13 20:13:02','',''),(2508979,'1','197','1018',464,'Retail Sale Id 1517319',9086.16,0.00,0.00,17.34,242.76,'2022-01-13 20:14:10','',''),(2508997,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2233800.00,4380.00,0.00,0.00,'2022-01-13 20:28:53','',''),(2509003,'1','197',NULL,464,'Reception corrector for bridging 130776',0.00,0.00,0.00,4380.00,0.00,'2022-01-13 20:34:46','',''),(2509004,'1','197','1018',464,'Received from bridging 130776',0.00,0.00,4380.00,0.00,0.00,'2022-01-13 20:34:46','',''),(2509446,'1','197','1018',464,'Retail Sale Id 1517472',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 07:38:14','',''),(2509636,'1','197','1018',464,'Retail Sale Id 1517586',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 07:53:53','',''),(2509740,'1','197','1018',464,'Retail Sale Id 1517699',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 08:07:04','',''),(2509771,'1','197','1018',464,'Retail Sale Id 1517731',3001.44,0.00,0.00,5.07,415.74,'2022-01-14 08:10:18','',''),(2509786,'1','197','1018',464,'Retail Sale Id 1517745',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 08:11:29','',''),(2509869,'1','197','1018',464,'Retail Sale Id 1517815',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 08:20:47','',''),(2509911,'1','197','1018',464,'Retail Sale Id 1517858',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 08:25:45','',''),(2509928,'1','197','1018',464,'Retail Sale Id 1517874',3001.44,0.00,0.00,5.07,415.74,'2022-01-14 08:27:22','',''),(2509945,'1','197','1018',464,'Retail Sale Id 1517892',8908.00,0.00,0.00,17.00,238.00,'2022-01-14 08:28:48','',''),(2509986,'1','197','1018',464,'Retail Sale Id 1517921',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 08:31:51','',''),(2510003,'1','197','1018',464,'Retail Sale Id 1517930',2000.96,0.00,0.00,3.38,277.16,'2022-01-14 08:32:51','',''),(2510023,'1','197','1018',464,'Retail Sale Id 1517944',6002.88,0.00,0.00,10.14,831.48,'2022-01-14 08:34:20','',''),(2510044,'1','197','1018',464,'Retail Sale Id 1517962',1799.68,0.00,0.00,3.04,249.28,'2022-01-14 08:35:14','',''),(2510057,'1','197','1018',464,'Retail Sale Id 1517973',2000.96,0.00,0.00,3.38,277.16,'2022-01-14 08:36:15','',''),(2510250,'1','197','1018',464,'Retail Sale Id 1518122',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 08:53:05','',''),(2510946,'1','197','1018',464,'Retail Sale Id 1518753',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 09:48:48','',''),(2511173,'1','197','1018',464,'Retail Sale Id 1518945',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 10:04:57','',''),(2511391,'1','197','1018',464,'Retail Sale Id 1519191',28712.00,0.00,0.00,48.50,3977.00,'2022-01-14 10:28:48','',''),(2512035,'1','197','1018',464,'Retail Sale Id 1519820',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 11:35:05','',''),(2512626,'1','197','1018',464,'Retail Sale Id 1520348',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 12:44:04','',''),(2512702,'1','197','1018',464,'Retail Sale Id 1520392',2000.96,0.00,0.00,3.38,277.16,'2022-01-14 12:56:42','',''),(2513225,'1','197','1018',464,'Retail Sale Id 1520865',10401.44,0.00,0.00,17.57,1440.74,'2022-01-14 14:18:58','',''),(2513232,'1','197','1018',464,'Retail Sale Id 1520868',1799.68,0.00,0.00,3.04,249.28,'2022-01-14 14:19:43','',''),(2513274,'1','197','1018',464,'Retail Sale Id 1520899',60784.00,0.00,0.00,116.00,1624.00,'2022-01-14 14:23:45','',''),(2513284,'1','197','1018',464,'Retail Sale Id 1520908',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 14:25:11','',''),(2513295,'1','197','1018',464,'Retail Sale Id 1520914',4001.92,0.00,0.00,6.76,554.32,'2022-01-14 14:26:37','',''),(2513472,'1','197','1018',464,'Retail Sale Id 1521030',14800.00,0.00,0.00,25.00,2050.00,'2022-01-14 14:40:51','',''),(2513487,'1','197','1018',464,'Retail Sale Id 1521046',5002.40,0.00,0.00,8.45,692.90,'2022-01-14 14:42:24','',''),(2513523,'1','197','1018',464,'Retail Sale Id 1521056',29600.00,0.00,0.00,50.00,4100.00,'2022-01-14 14:43:36','',''),(2513558,'1','197','1018',464,'Retail Sale Id 1521092',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 14:46:05','',''),(2513714,'1','197','1018',464,'Retail Sale Id 1521343',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 15:04:29','',''),(2513737,'1','197','1018',464,'Retail Sale Id 1521364',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 15:06:42','',''),(2513767,'1','197','1018',464,'Retail Sale Id 1521393',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 15:09:26','',''),(2513947,'1','197','1018',464,'Retail Sale Id 1521549',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 15:27:23','',''),(2514100,'1','197','1018',464,'Retail Sale Id 1521726',32750.00,0.00,0.00,62.50,875.00,'2022-01-14 15:42:09','',''),(2514110,'1','197','1018',464,'Retail Sale Id 1521740',15725.24,0.00,0.00,30.01,420.14,'2022-01-14 15:42:52','',''),(2514126,'1','197','1018',464,'Retail Sale Id 1521756',116364.68,0.00,0.00,222.07,3108.98,'2022-01-14 15:44:21','',''),(2514212,'1','197','1018',464,'Retail Sale Id 1521830',18227.68,0.00,0.00,30.79,2524.78,'2022-01-14 15:51:23','',''),(2514264,'1','197','1018',464,'Retail Sale Id 1521893',35999.52,0.00,0.00,60.81,4986.42,'2022-01-14 15:57:04','',''),(2514393,'1','197','1018',464,'Return of Retail Sale Id 1521893',0.00,35999.52,60.81,0.00,-4986.42,'2022-01-14 16:08:25','',''),(2514478,'1','197','1018',464,'Return of Retail Sale Id 1521549',0.00,3599.36,6.08,0.00,-498.56,'2022-01-14 16:14:21','',''),(2514517,'1','197','1018',464,'Return of Retail Sale Id 1521056',0.00,29600.00,50.00,0.00,-4100.00,'2022-01-14 16:18:15','',''),(2514675,'1','197','1018',464,'Retail Sale Id 1522242',3867.12,0.00,0.00,7.38,103.32,'2022-01-14 16:35:50','',''),(2514692,'1','197','1018',464,'Retail Sale Id 1522262',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 16:37:37','',''),(2514757,'1','197','1018',464,'Retail Sale Id 1522338',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 16:43:47','',''),(2514800,'1','197','1018',464,'Retail Sale Id 1522383',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 16:48:00','',''),(2514813,'1','197','1018',464,'Retail Sale Id 1522396',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 16:49:08','',''),(2514931,'1','197','1018',464,'Retail Sale Id 1522570',1799.68,0.00,0.00,3.04,249.28,'2022-01-14 17:00:02','',''),(2515121,'1','197','1018',464,'Retail Sale Id 1522770',4499.20,0.00,0.00,7.60,623.20,'2022-01-14 17:17:04','',''),(2515140,'1','197','1018',464,'Retail Sale Id 1522780',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 17:18:39','',''),(2515149,'1','197','1018',464,'Retail Sale Id 1522792',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 17:19:35','',''),(2515194,'1','197','1018',464,'Retail Sale Id 1522846',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 17:23:45','',''),(2515208,'1','197','1018',464,'Retail Sale Id 1522861',1497.76,0.00,0.00,2.53,207.46,'2022-01-14 17:24:44','',''),(2515216,'1','197','1018',464,'Retail Sale Id 1522869',14800.00,0.00,0.00,25.00,2050.00,'2022-01-14 17:25:31','',''),(2515335,'1','197','1018',464,'Retail Sale Id 1522998',1000.48,0.00,0.00,1.69,138.58,'2022-01-14 17:36:20','',''),(2515384,'1','197','1018',464,'Retail Sale Id 1523053',1201.76,0.00,0.00,2.03,166.46,'2022-01-14 17:40:24','',''),(2515398,'1','197','1018',464,'Retail Sale Id 1523065',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 17:41:45','',''),(2515432,'1','197','1018',464,'Retail Sale Id 1523098',1799.68,0.00,0.00,3.04,249.28,'2022-01-14 17:44:55','',''),(2515452,'1','197','1018',464,'Retail Sale Id 1523122',29600.00,0.00,0.00,50.00,4100.00,'2022-01-14 17:46:28','',''),(2515683,'1','197','1018',464,'Retail Sale Id 1523365',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 18:08:34','',''),(2515744,'1','197','1018',464,'Retail Sale Id 1523417',3001.44,0.00,0.00,5.07,415.74,'2022-01-14 18:14:46','',''),(2515961,'1','197','1018',464,'Retail Sale Id 1523735',7400.00,0.00,0.00,12.50,1025.00,'2022-01-14 18:59:15','',''),(2515971,'1','197','1018',464,'Retail Sale Id 1523744',3599.36,0.00,0.00,6.08,498.56,'2022-01-14 19:00:12','',''),(2515985,'1','197','1018',464,'Retail Sale Id 1523751',3001.44,0.00,0.00,5.07,415.74,'2022-01-14 19:02:58','',''),(2516251,'1','197','1018',464,'Retail Sale Id 1523881',13959.36,0.00,0.00,23.58,1933.56,'2022-01-14 19:33:41','',''),(2516265,'1','197','1018',464,'Retail Sale Id 1523890',30617.32,0.00,0.00,58.43,818.02,'2022-01-14 19:37:28','',''),(2517040,'1','197','1018',464,'Retail Sale Id 1524125',13402.88,0.00,0.00,22.64,1856.48,'2022-01-15 07:43:33','',''),(2517587,'1','197','1018',464,'Retail Sale Id 1524593',1000.48,0.00,0.00,1.69,138.58,'2022-01-15 08:37:40','',''),(2517693,'1','197','1018',464,'Retail Sale Id 1524706',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 08:49:12','',''),(2517799,'1','197','1018',464,'Retail Sale Id 1524805',3001.44,0.00,0.00,5.07,415.74,'2022-01-15 08:58:36','',''),(2517886,'1','197','1018',464,'Retail Sale Id 1524886',7198.72,0.00,0.00,12.16,997.12,'2022-01-15 09:07:36','',''),(2518233,'1','197','1018',464,'Retail Sale Id 1525178',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 09:30:27','',''),(2518250,'1','197','1018',464,'Retail Sale Id 1525193',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 09:31:33','',''),(2518277,'1','197','1018',464,'Retail Sale Id 1525204',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 09:32:22','',''),(2518461,'1','197','1018',464,'Retail Sale Id 1525355',3498.72,0.00,0.00,5.91,484.62,'2022-01-15 09:45:48','',''),(2518558,'1','197','1018',464,'Retail Sale Id 1525453',131000.00,0.00,0.00,250.00,3500.00,'2022-01-15 09:55:40','',''),(2518652,'1','197','1018',464,'Retail Sale Id 1525547',9500.12,0.00,0.00,18.13,253.82,'2022-01-15 10:03:43','',''),(2518669,'1','197','1018',464,'Retail Sale Id 1525571',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 10:05:15','',''),(2518839,'1','197','1018',464,'Retail Sale Id 1525769',13835.04,0.00,0.00,23.37,1916.34,'2022-01-15 10:20:06','',''),(2518845,'1','197','1018',464,'Retail Sale Id 1525777',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 10:20:38','',''),(2518856,'1','197','1018',464,'Retail Sale Id 1525788',1201.76,0.00,0.00,2.03,166.46,'2022-01-15 10:21:43','',''),(2518866,'1','197','1018',464,'Retail Sale Id 1525803',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 10:22:48','',''),(2519140,'1','197','1018',464,'Retail Sale Id 1526006',1000.48,0.00,0.00,1.69,138.58,'2022-01-15 10:40:21','',''),(2519184,'1','197','1018',464,'Retail Sale Id 1526049',39787.32,0.00,0.00,75.93,1063.02,'2022-01-15 10:43:33','',''),(2519197,'1','197','1018',464,'Retail Sale Id 1526062',1201.76,0.00,0.00,2.03,166.46,'2022-01-15 10:44:30','',''),(2519301,'1','197','1018',464,'Retail Sale Id 1526155',497.28,0.00,0.00,0.84,68.88,'2022-01-15 10:52:24','',''),(2519550,'1','197','1018',464,'Retail Sale Id 1526350',3001.44,0.00,0.00,5.07,415.74,'2022-01-15 11:11:34','',''),(2519696,'1','197','1018',464,'Retail Sale Id 1526489',146196.00,0.00,0.00,279.00,3906.00,'2022-01-15 11:22:58','',''),(2519711,'1','197','1018',464,'Retail Sale Id 1526504',6997.44,0.00,0.00,11.82,969.24,'2022-01-15 11:23:55','',''),(2519777,'1','197','1018',464,'Retail Sale Id 1526566',49780.00,0.00,0.00,95.00,1330.00,'2022-01-15 11:29:21','',''),(2519827,'1','197','1018',464,'Retail Sale Id 1526592',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 11:31:28','',''),(2519871,'1','197','1018',464,'Retail Sale Id 1526617',53972.00,0.00,0.00,103.00,1442.00,'2022-01-15 11:35:36','',''),(2519946,'1','197','1018',464,'Retail Sale Id 1526698',3001.44,0.00,0.00,5.07,415.74,'2022-01-15 11:42:41','',''),(2520144,'1','197','1018',464,'Retail Sale Id 1526921',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 12:01:53','',''),(2520273,'1','197','1018',464,'Retail Sale Id 1527040',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 12:10:05','',''),(2520309,'1','197','1018',464,'Retail Sale Id 1527087',2498.24,0.00,0.00,4.22,346.04,'2022-01-15 12:14:08','',''),(2520399,'1','197','1018',464,'Retail Sale Id 1527183',37000.00,0.00,0.00,62.50,5125.00,'2022-01-15 12:21:40','',''),(2520645,'1','197','1018',464,'Retail Sale Id 1527406',1799.68,0.00,0.00,3.04,249.28,'2022-01-15 12:42:10','',''),(2521446,'1','197','1018',464,'Retail Sale Id 1528073',14800.00,0.00,0.00,25.00,2050.00,'2022-01-15 13:50:16','',''),(2521468,'1','197','1018',464,'Retail Sale Id 1528095',4801.12,0.00,0.00,8.11,665.02,'2022-01-15 13:52:19','',''),(2521472,'1','197','1018',464,'Retail Sale Id 1528099',2960.00,0.00,0.00,5.00,410.00,'2022-01-15 13:52:52','',''),(2521494,'1','197','1018',464,'Retail Sale Id 1528132',22200.00,0.00,0.00,37.50,3075.00,'2022-01-15 13:55:22','',''),(2521674,'1','197','1018',464,'Retail Sale Id 1528310',58950.00,0.00,0.00,112.50,1575.00,'2022-01-15 14:11:52','',''),(2521888,'1','197','1018',464,'Retail Sale Id 1528483',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 14:31:09','',''),(2522003,'1','197','1018',464,'Retail Sale Id 1528591',14800.00,0.00,0.00,25.00,2050.00,'2022-01-15 14:42:58','',''),(2522048,'1','197','1018',464,'Retail Sale Id 1528639',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 14:47:06','',''),(2522074,'1','197','1018',464,'Retail Sale Id 1528660',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 14:49:02','',''),(2522079,'1','197','1018',464,'Retail Sale Id 1528665',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 14:49:36','',''),(2522087,'1','197','1018',464,'Retail Sale Id 1528676',3634.88,0.00,0.00,6.14,503.48,'2022-01-15 14:50:15','',''),(2522152,'1','197','1018',464,'Retail Sale Id 1528723',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 14:54:47','',''),(2522206,'1','197','1018',464,'Retail Sale Id 1528752',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 14:57:25','',''),(2522665,'1','197','1018',464,'Retail Sale Id 1529049',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 15:27:59','',''),(2523041,'1','197','1018',464,'Retail Sale Id 1529446',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 16:05:16','',''),(2523138,'1','197','1018',464,'Retail Sale Id 1529562',26200.00,0.00,0.00,50.00,700.00,'2022-01-15 16:17:54','',''),(2523198,'1','197','1018',464,'Retail Sale Id 1529622',3552.00,0.00,0.00,6.00,492.00,'2022-01-15 16:21:57','',''),(2523239,'1','197','1018',464,'Retail Sale Id 1529663',1799.68,0.00,0.00,3.04,249.28,'2022-01-15 16:25:50','',''),(2523328,'1','197','1018',464,'Retail Sale Id 1529739',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 16:32:20','',''),(2523589,'1','197','1018',464,'Retail Sale Id 1529944',5002.40,0.00,0.00,8.45,692.90,'2022-01-15 16:48:20','',''),(2523624,'1','197','1018',464,'Retail Sale Id 1529984',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 16:50:36','',''),(2523764,'1','197','1018',464,'Retail Sale Id 1530094',2397.60,0.00,0.00,4.05,332.10,'2022-01-15 16:58:38','',''),(2523870,'1','197','1018',464,'Retail Sale Id 1530158',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 17:03:10','',''),(2523959,'1','197','1018',464,'Retail Sale Id 1530219',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 17:08:21','',''),(2524022,'1','197','1018',464,'Retail Sale Id 1530284',2498.24,0.00,0.00,4.22,346.04,'2022-01-15 17:14:11','',''),(2524023,'1','197','1018',464,'Retail Sale Id 1530284',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 17:14:11','',''),(2524051,'1','197','1018',464,'Retail Sale Id 1530301',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 17:15:58','',''),(2524098,'1','197','1018',464,'Retail Sale Id 1530350',3599.36,0.00,0.00,6.08,498.56,'2022-01-15 17:19:44','',''),(2524484,'1','197','1018',464,'Retail Sale Id 1530739',3001.44,0.00,0.00,5.07,415.74,'2022-01-15 17:48:43','',''),(2524599,'1','197','1018',464,'Retail Sale Id 1530828',7400.00,0.00,0.00,12.50,1025.00,'2022-01-15 17:55:27','',''),(2524985,'1','197','1018',464,'Retail Sale Id 1531197',29600.00,0.00,0.00,50.00,4100.00,'2022-01-15 18:40:37','',''),(2525055,'1','197','1018',464,'Retail Sale Id 1531271',1799.68,0.00,0.00,3.04,249.28,'2022-01-15 18:52:58','',''),(2525344,'1','197','1018',464,'Retail Sale Id 1531478',5937.76,0.00,0.00,10.03,822.46,'2022-01-15 19:51:22','',''),(2525351,'1','197','1018',464,'Retail Sale Id 1531484',76897.00,0.00,0.00,146.75,2054.50,'2022-01-15 19:53:30','',''),(2526088,'1','197','1018',464,'Retail Sale Id 1531772',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 07:53:05','',''),(2526143,'1','197','1018',464,'Retail Sale Id 1531820',5399.04,0.00,0.00,9.12,747.84,'2022-01-16 08:01:13','',''),(2526299,'1','197','1018',464,'Retail Sale Id 1531959',1799.68,0.00,0.00,3.04,249.28,'2022-01-16 08:18:00','',''),(2526584,'1','197','1018',464,'Retail Sale Id 1532179',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 08:39:52','',''),(2526620,'1','197','1018',464,'Retail Sale Id 1532214',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 08:43:00','',''),(2526665,'1','197','1018',464,'Retail Sale Id 1532261',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 08:47:23','',''),(2526717,'1','197','1018',464,'Retail Sale Id 1532316',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 08:51:59','',''),(2527127,'1','197','1018',464,'Retail Sale Id 1532696',6997.44,0.00,0.00,11.82,969.24,'2022-01-16 09:26:39','',''),(2527172,'1','197','1018',464,'Retail Sale Id 1532727',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 09:29:22','',''),(2527337,'1','197','1018',464,'Retail Sale Id 1532874',2000.96,0.00,0.00,3.38,277.16,'2022-01-16 09:43:31','',''),(2527472,'1','197','1018',464,'Retail Sale Id 1533029',4001.92,0.00,0.00,6.76,554.32,'2022-01-16 09:55:17','',''),(2527527,'1','197','1018',464,'Retail Sale Id 1533105',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 09:59:55','',''),(2527616,'1','197','1018',464,'Retail Sale Id 1533176',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 10:06:34','',''),(2527893,'1','197','1018',464,'Retail Sale Id 1533408',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 10:25:31','',''),(2528237,'1','197','1018',464,'Retail Sale Id 1533718',4001.92,0.00,0.00,6.76,554.32,'2022-01-16 10:51:21','',''),(2528361,'1','197','1018',464,'Retail Sale Id 1533853',1799.68,0.00,0.00,3.04,249.28,'2022-01-16 11:02:57','',''),(2528379,'1','197','1018',464,'Retail Sale Id 1533871',4197.28,0.00,0.00,7.09,581.38,'2022-01-16 11:04:37','',''),(2528964,'1','197','1018',464,'Retail Sale Id 1534475',26200.00,0.00,0.00,50.00,700.00,'2022-01-16 11:54:15','',''),(2528981,'1','197','1018',464,'Retail Sale Id 1534490',14800.00,0.00,0.00,25.00,2050.00,'2022-01-16 11:55:24','',''),(2528986,'1','197','1018',464,'Retail Sale Id 1534501',6002.88,0.00,0.00,10.14,831.48,'2022-01-16 11:56:11','',''),(2529346,'1','197','1018',464,'Retail Sale Id 1534878',1497.76,0.00,0.00,2.53,207.46,'2022-01-16 12:30:09','',''),(2529394,'1','197','1018',464,'Retail Sale Id 1534926',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 12:35:30','',''),(2529423,'1','197','1018',464,'Retail Sale Id 1534945',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 12:38:14','',''),(2529511,'1','197','1018',464,'Retail Sale Id 1535053',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 12:46:53','',''),(2529907,'1','197','1018',464,'Retail Sale Id 1535434',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 13:23:59','',''),(2530577,'1','197','1018',464,'Retail Sale Id 1536156',1497.76,0.00,0.00,2.53,207.46,'2022-01-16 14:28:33','',''),(2530759,'1','197','1018',464,'Retail Sale Id 1536331',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 14:46:18','',''),(2530766,'1','197','1018',464,'Retail Sale Id 1536337',2000.96,0.00,0.00,3.38,277.16,'2022-01-16 14:47:00','',''),(2531063,'1','197','1018',464,'Retail Sale Id 1536535',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 15:09:47','',''),(2531172,'1','197','1018',464,'Retail Sale Id 1536582',1000.48,0.00,0.00,1.69,138.58,'2022-01-16 15:15:00','',''),(2531218,'1','197','1018',464,'Retail Sale Id 1536623',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 15:19:12','',''),(2531278,'1','197','1018',464,'Retail Sale Id 1536677',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 15:26:24','',''),(2531504,'1','197','1018',464,'Retail Sale Id 1536851',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 15:47:56','',''),(2531519,'1','197','1018',464,'Retail Sale Id 1536868',40306.08,0.00,0.00,76.92,1076.88,'2022-01-16 15:50:18','',''),(2531536,'1','197','1018',464,'Retail Sale Id 1536879',29600.00,0.00,0.00,50.00,4100.00,'2022-01-16 15:51:48','',''),(2531541,'1','197','1018',464,'Retail Sale Id 1536885',7429.60,0.00,0.00,12.55,1029.10,'2022-01-16 15:52:30','',''),(2531619,'1','197','1018',464,'Retail Sale Id 1536973',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 16:03:23','',''),(2531751,'1','197','1018',464,'Retail Sale Id 1537121',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 16:18:07','',''),(2532024,'1','197','1018',464,'Retail Sale Id 1537319',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 16:39:07','',''),(2532051,'1','197','1018',464,'Retail Sale Id 1537343',33012.00,0.00,0.00,63.00,882.00,'2022-01-16 16:41:11','',''),(2532214,'1','197','1018',464,'Retail Sale Id 1537469',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 16:52:24','',''),(2532222,'1','197','1018',464,'Retail Sale Id 1537479',14800.00,0.00,0.00,25.00,2050.00,'2022-01-16 16:53:04','',''),(2532232,'1','197','1018',464,'Retail Sale Id 1537487',2598.88,0.00,0.00,4.39,359.98,'2022-01-16 16:53:37','',''),(2532256,'1','197','1018',464,'Retail Sale Id 1537512',2000.96,0.00,0.00,3.38,277.16,'2022-01-16 16:55:16','',''),(2532270,'1','197','1018',464,'Retail Sale Id 1537527',1799.68,0.00,0.00,3.04,249.28,'2022-01-16 16:56:27','',''),(2532524,'1','197','1018',464,'Retail Sale Id 1537764',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 17:15:52','',''),(2532589,'1','197','1018',464,'Retail Sale Id 1537916',5002.40,0.00,0.00,8.45,692.90,'2022-01-16 17:23:44','',''),(2532801,'1','197','1018',464,'Retail Sale Id 1538132',2000.96,0.00,0.00,3.38,277.16,'2022-01-16 17:39:47','',''),(2532808,'1','197','1018',464,'Retail Sale Id 1538141',5002.40,0.00,0.00,8.45,692.90,'2022-01-16 17:40:23','',''),(2532844,'1','197','1018',464,'Retail Sale Id 1538179',19650.00,0.00,0.00,37.50,525.00,'2022-01-16 17:43:06','',''),(2532861,'1','197','1018',464,'Retail Sale Id 1538195',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 17:44:46','',''),(2532936,'1','197','1018',464,'Retail Sale Id 1538244',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 17:48:55','',''),(2533043,'1','197','1018',464,'Retail Sale Id 1538345',8074.88,0.00,0.00,13.64,1118.48,'2022-01-16 18:00:56','',''),(2533293,'1','197','1018',464,'Retail Sale Id 1538547',9432.00,0.00,0.00,18.00,252.00,'2022-01-16 18:23:31','',''),(2533306,'1','197','1018',464,'Retail Sale Id 1538551',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 18:24:15','',''),(2533322,'1','197','1018',464,'Retail Sale Id 1538556',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 18:24:48','',''),(2533339,'1','197','1018',464,'Retail Sale Id 1538565',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 18:25:44','',''),(2533368,'1','197','1018',464,'Retail Sale Id 1538573',3001.44,0.00,0.00,5.07,415.74,'2022-01-16 18:26:36','',''),(2533561,'1','197','1018',464,'Retail Sale Id 1538733',7400.00,0.00,0.00,12.50,1025.00,'2022-01-16 18:59:50','',''),(2533591,'1','197','1018',464,'Retail Sale Id 1538763',58950.00,0.00,0.00,112.50,1575.00,'2022-01-16 19:07:43','',''),(2533624,'1','197','1018',464,'Retail Sale Id 1538794',3599.36,0.00,0.00,6.08,498.56,'2022-01-16 19:14:33','',''),(2533660,'1','197','1018',464,'Retail Sale Id 1538803',26200.00,0.00,0.00,50.00,700.00,'2022-01-16 19:15:44','',''),(2533710,'1','197','1018',464,'Retail Sale Id 1538850',14800.00,0.00,0.00,25.00,2050.00,'2022-01-16 19:39:55','',''),(2533713,'1','197','1018',464,'Retail Sale Id 1538853',8554.40,0.00,0.00,14.45,1184.90,'2022-01-16 19:40:36','',''),(2533717,'1','197','1018',464,'Retail Sale Id 1538859',6550.00,0.00,0.00,12.50,175.00,'2022-01-16 19:43:41','',''),(2534317,'1','197','1018',464,'Retail Sale Id 1539085',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 07:40:49','',''),(2534523,'1','197','1018',464,'Retail Sale Id 1539232',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 08:08:22','',''),(2534598,'1','197','1018',464,'Retail Sale Id 1539305',1000.48,0.00,0.00,1.69,138.58,'2022-01-17 08:16:44','',''),(2534810,'1','197','1018',464,'Retail Sale Id 1539486',6600.80,0.00,0.00,11.15,914.30,'2022-01-17 08:39:09','',''),(2535103,'1','197','1018',464,'Retail Sale Id 1539773',4001.92,0.00,0.00,6.76,554.32,'2022-01-17 09:16:38','',''),(2535526,'1','197','1018',464,'Retail Sale Id 1540101',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 09:59:16','',''),(2535574,'1','197','1018',464,'Retail Sale Id 1540143',35999.52,0.00,0.00,60.81,4986.42,'2022-01-17 10:05:41','',''),(2535678,'1','197','1018',464,'Retail Sale Id 1540189',13100.00,0.00,0.00,25.00,350.00,'2022-01-17 10:11:56','',''),(2535772,'1','197','1018',464,'Retail Sale Id 1540267',5002.40,0.00,0.00,8.45,692.90,'2022-01-17 10:22:11','',''),(2535821,'1','197','1018',464,'Return of Retail Sale Id 1540143',0.00,35999.52,60.81,0.00,-4986.42,'2022-01-17 10:29:22','',''),(2536162,'1','197','1018',464,'Retail Sale Id 1540575',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 11:06:00','',''),(2536180,'1','197','1018',464,'Retail Sale Id 1540593',21998.72,0.00,0.00,37.16,3047.12,'2022-01-17 11:08:16','',''),(2536272,'1','197','1018',464,'Retail Sale Id 1540684',2000.96,0.00,0.00,3.38,277.16,'2022-01-17 11:20:19','',''),(2536505,'1','197','1018',464,'Retail Sale Id 1540894',2498.24,0.00,0.00,4.22,346.04,'2022-01-17 11:47:58','',''),(2537338,'1','197','1018',464,'Retail Sale Id 1541720',381409.12,0.00,0.00,727.88,10190.32,'2022-01-17 13:41:31','',''),(2537342,'1','197','1018',464,'Retail Sale Id 1541726',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 13:42:19','',''),(2537349,'1','197','1018',464,'Retail Sale Id 1541731',3338.88,0.00,0.00,5.64,462.48,'2022-01-17 13:42:51','',''),(2537442,'1','197','1018',464,'Distributed to AMAZING GRASE for sales id:346846',56477.40,0.00,0.00,110.74,0.00,'2022-01-17 13:54:20','',''),(2537490,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1020000.00,2000.00,0.00,0.00,'2022-01-17 13:59:34','',''),(2537525,'1','197',NULL,464,'Returned purchase #89769 to AA RANO NIGERIA LIMITED',1020000.00,0.00,0.00,2000.00,0.00,'2022-01-17 14:03:28','',''),(2537554,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1020000.00,2000.00,0.00,0.00,'2022-01-17 14:05:56','',''),(2537573,'1','197',NULL,464,'Reception corrector for bridging 131201',0.00,0.00,0.00,2000.00,0.00,'2022-01-17 14:07:06','',''),(2537574,'1','197','1018',464,'Received from bridging 131201',0.00,0.00,2000.00,0.00,0.00,'2022-01-17 14:07:06','',''),(2537768,'1','197','1018',464,'Retail Sale Id 1542068',14800.00,0.00,0.00,25.00,2050.00,'2022-01-17 14:27:32','',''),(2537780,'1','197','1018',464,'Retail Sale Id 1542080',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 14:28:55','',''),(2537790,'1','197','1018',464,'Retail Sale Id 1542088',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 14:29:57','',''),(2537813,'1','197','1018',464,'Retail Sale Id 1542102',1000.48,0.00,0.00,1.69,138.58,'2022-01-17 14:31:44','',''),(2537899,'1','197','1018',464,'Retail Sale Id 1542180',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 14:41:30','',''),(2537902,'1','197','1018',464,'Retail Sale Id 1542182',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 14:42:06','',''),(2537971,'1','197','1018',464,'Retail Sale Id 1542221',3001.44,0.00,0.00,5.07,415.74,'2022-01-17 14:47:14','',''),(2537984,'1','197','1018',464,'Retail Sale Id 1542229',3001.44,0.00,0.00,5.07,415.74,'2022-01-17 14:48:16','',''),(2538057,'1','197','1018',464,'Retail Sale Id 1542302',6997.44,0.00,0.00,11.82,969.24,'2022-01-17 14:56:38','',''),(2538077,'1','197','1018',464,'Retail Sale Id 1542323',37000.00,0.00,0.00,62.50,5125.00,'2022-01-17 14:59:02','',''),(2538229,'1','197','1018',464,'Retail Sale Id 1542426',3001.44,0.00,0.00,5.07,415.74,'2022-01-17 15:09:43','',''),(2538342,'1','197','1018',464,'Retail Sale Id 1542481',82268.00,0.00,0.00,157.00,2198.00,'2022-01-17 15:16:54','',''),(2538350,'1','197','1018',464,'Retail Sale Id 1542499',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 15:17:59','',''),(2538378,'1','197','1018',464,'Retail Sale Id 1542530',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 15:22:52','',''),(2538416,'1','197','1018',464,'Retail Sale Id 1542567',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 15:27:20','',''),(2538422,'1','197','1018',464,'Retail Sale Id 1542573',1497.76,0.00,0.00,2.53,207.46,'2022-01-17 15:28:04','',''),(2538440,'1','197','1018',464,'Retail Sale Id 1542592',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 15:30:00','',''),(2538450,'1','197','1018',464,'Retail Sale Id 1542605',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 15:31:01','',''),(2538456,'1','197','1018',464,'Retail Sale Id 1542609',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 15:31:38','',''),(2538476,'1','197','1018',464,'Retail Sale Id 1542628',16998.56,0.00,0.00,32.44,454.16,'2022-01-17 15:33:48','',''),(2538490,'1','197','1018',464,'Retail Sale Id 1542642',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 15:35:36','',''),(2538500,'1','197','1018',464,'Retail Sale Id 1542652',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 15:36:43','',''),(2538517,'1','197','1018',464,'Retail Sale Id 1542668',1699.04,0.00,0.00,2.87,235.34,'2022-01-17 15:38:19','',''),(2538524,'1','197','1018',464,'Retail Sale Id 1542675',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 15:39:06','',''),(2538576,'1','197','1018',464,'Retail Sale Id 1542720',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 15:43:36','',''),(2538598,'1','197','1018',464,'Retail Sale Id 1542736',14598.72,0.00,0.00,24.66,2022.12,'2022-01-17 15:45:47','',''),(2538657,'1','197','1018',464,'Retail Sale Id 1542775',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 15:50:04','',''),(2538735,'1','197','1018',464,'Retail Sale Id 1542834',6002.88,0.00,0.00,10.14,831.48,'2022-01-17 15:56:47','',''),(2538831,'1','197','1018',464,'Retail Sale Id 1542895',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 16:06:02','',''),(2538894,'1','197','1018',464,'Retail Sale Id 1542967',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 16:12:07','',''),(2538987,'1','197','1018',464,'Retail Sale Id 1543070',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 16:23:48','',''),(2539047,'1','197','1018',464,'Retail Sale Id 1543126',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 16:30:43','',''),(2539081,'1','197','1018',464,'Retail Sale Id 1543147',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 16:34:04','',''),(2539113,'1','197','1018',464,'Retail Sale Id 1543184',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 16:36:44','',''),(2539118,'1','197','1018',464,'Retail Sale Id 1543205',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 16:37:24','',''),(2539251,'1','197','1018',464,'Retail Sale Id 1543336',1799.68,0.00,0.00,3.04,249.28,'2022-01-17 16:47:52','',''),(2539333,'1','197','1018',464,'Retail Sale Id 1543424',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 16:53:58','',''),(2539600,'1','197','1018',464,'Retail Sale Id 1543704',3001.44,0.00,0.00,5.07,415.74,'2022-01-17 17:12:45','',''),(2539650,'1','197','1018',464,'Retail Sale Id 1543723',7400.00,0.00,0.00,12.50,1025.00,'2022-01-17 17:16:38','',''),(2539655,'1','197','1018',464,'Retail Sale Id 1543758',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 17:17:06','',''),(2539690,'1','197','1018',464,'Retail Sale Id 1543791',1000.48,0.00,0.00,1.69,138.58,'2022-01-17 17:19:32','',''),(2539796,'1','197','1018',464,'Retail Sale Id 1543902',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 17:27:21','',''),(2540000,'1','197','1018',464,'Retail Sale Id 1544105',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 17:42:28','',''),(2540017,'1','197','1018',464,'Retail Sale Id 1544127',6002.88,0.00,0.00,10.14,831.48,'2022-01-17 17:43:28','',''),(2540070,'1','197','1018',464,'Retail Sale Id 1544180',3001.44,0.00,0.00,5.07,415.74,'2022-01-17 17:48:22','',''),(2540080,'1','197','1018',464,'Retail Sale Id 1544191',3599.36,0.00,0.00,6.08,498.56,'2022-01-17 17:49:19','',''),(2540268,'1','197','1018',464,'Retail Sale Id 1544306',3001.44,0.00,0.00,5.07,415.74,'2022-01-17 18:00:18','',''),(2540630,'1','197','1018',464,'Return of Retail Sale Id 1542736',0.00,14598.72,24.66,0.00,-2022.12,'2022-01-17 19:50:29','',''),(2540631,'1','197','1018',464,'Return of Retail Sale Id 1542068',0.00,14800.00,25.00,0.00,-2050.00,'2022-01-17 19:52:13','',''),(2540632,'1','197','1018',464,'Retail Sale Id 1544872',6192.32,0.00,0.00,10.46,857.72,'2022-01-17 19:53:41','',''),(2540635,'1','197','1018',464,'Retail Sale Id 1544875',262000.00,0.00,0.00,500.00,7000.00,'2022-01-17 19:55:04','',''),(2540637,'1','197','1018',464,'Retail Sale Id 1544877',15720.00,0.00,0.00,30.00,420.00,'2022-01-17 19:57:12','',''),(2540642,'1','197','1018',464,'Retail Sale Id 1544881',11045.92,0.00,0.00,21.08,295.12,'2022-01-17 20:07:08','',''),(2540663,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1637100.00,3210.00,0.00,0.00,'2022-01-17 20:19:46','',''),(2540665,'1','197',NULL,464,'Reception corrector for bridging 131227',0.00,0.00,0.00,3210.00,0.00,'2022-01-17 20:21:20','',''),(2540666,'1','197','1018',464,'Received from bridging 131227',0.00,0.00,3210.00,0.00,0.00,'2022-01-17 20:21:20','',''),(2541104,'1','197','1018',464,'Retail Sale Id 1544953',3001.44,0.00,0.00,5.07,415.74,'2022-01-18 07:31:57','',''),(2541399,'1','197','1018',464,'Retail Sale Id 1545238',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 08:17:59','',''),(2541503,'1','197','1018',464,'Retail Sale Id 1545341',1000.48,0.00,0.00,1.69,138.58,'2022-01-18 08:30:49','',''),(2541866,'1','197','1018',464,'Retail Sale Id 1545629',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 09:09:39','',''),(2542253,'1','197','1018',464,'Retail Sale Id 1545864',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 09:43:10','',''),(2542532,'1','197','1018',464,'Retail Sale Id 1546067',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 10:08:23','',''),(2542831,'1','197','1018',464,'Retail Sale Id 1546289',6997.44,0.00,0.00,11.82,969.24,'2022-01-18 10:33:50','',''),(2542842,'1','197','1018',464,'Retail Sale Id 1546296',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 10:35:02','',''),(2542986,'1','197','1018',464,'Retail Sale Id 1546409',8998.40,0.00,0.00,15.20,1246.40,'2022-01-18 10:46:45','',''),(2543123,'1','197','1018',464,'Retail Sale Id 1546530',3498.72,0.00,0.00,5.91,484.62,'2022-01-18 11:00:27','',''),(2543269,'1','197','1018',464,'Retail Sale Id 1546665',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 11:16:53','',''),(2543414,'1','197','1018',464,'Retail Sale Id 1546791',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 11:32:58','',''),(2543451,'1','197','1018',464,'Retail Sale Id 1546817',3001.44,0.00,0.00,5.07,415.74,'2022-01-18 11:36:48','',''),(2543617,'1','197','1018',464,'Retail Sale Id 1546972',3800.64,0.00,0.00,6.42,526.44,'2022-01-18 11:58:33','',''),(2543621,'1','197','1018',464,'Retail Sale Id 1546975',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 11:59:10','',''),(2543950,'1','197','1018',464,'Retail Sale Id 1547304',73884.00,0.00,0.00,141.00,1974.00,'2022-01-18 12:38:56','',''),(2544024,'1','197','1018',464,'Retail Sale Id 1547373',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 12:46:52','',''),(2544167,'1','197','1018',464,'Retail Sale Id 1547491',22200.00,0.00,0.00,37.50,3075.00,'2022-01-18 13:07:25','',''),(2544176,'1','197','1018',464,'Retail Sale Id 1547533',28820.00,0.00,0.00,55.00,770.00,'2022-01-18 13:08:36','',''),(2544184,'1','197','1018',464,'Retail Sale Id 1547543',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 13:10:15','',''),(2544591,'1','197','1018',464,'Retail Sale Id 1547957',2498.24,0.00,0.00,4.22,346.04,'2022-01-18 13:58:03','',''),(2544604,'1','197','1018',464,'Retail Sale Id 1547966',18340.00,0.00,0.00,35.00,490.00,'2022-01-18 13:59:05','',''),(2544681,'1','197','1018',464,'Retail Sale Id 1548048',6002.88,0.00,0.00,10.14,831.48,'2022-01-18 14:06:58','',''),(2544822,'1','197','1018',464,'Retail Sale Id 1548166',7198.72,0.00,0.00,12.16,997.12,'2022-01-18 14:22:32','',''),(2544856,'1','197','1018',464,'Retail Sale Id 1548192',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 14:26:07','',''),(2545229,'1','197','1018',464,'Retail Sale Id 1548487',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 14:58:14','',''),(2545735,'1','197','1018',464,'Retail Sale Id 1548891',154580.00,0.00,0.00,295.00,4130.00,'2022-01-18 15:43:32','',''),(2545786,'1','197','1018',464,'Retail Sale Id 1548915',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 15:47:35','',''),(2545796,'1','197','1018',464,'Retail Sale Id 1548939',14800.00,0.00,0.00,25.00,2050.00,'2022-01-18 15:48:23','',''),(2546054,'1','197','1018',464,'Retail Sale Id 1549159',58688.00,0.00,0.00,112.00,1568.00,'2022-01-18 16:10:42','',''),(2546569,'1','197','1018',464,'Retail Sale Id 1549646',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 16:56:34','',''),(2546771,'1','197','1018',464,'Retail Sale Id 1549808',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 17:09:01','',''),(2546788,'1','197','1018',464,'Retail Sale Id 1549823',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 17:10:03','',''),(2546843,'1','197','1018',464,'Retail Sale Id 1549879',29600.00,0.00,0.00,50.00,4100.00,'2022-01-18 17:14:03','',''),(2546878,'1','197','1018',464,'Retail Sale Id 1549910',1799.68,0.00,0.00,3.04,249.28,'2022-01-18 17:16:39','',''),(2546892,'1','197','1018',464,'Retail Sale Id 1549923',1497.76,0.00,0.00,2.53,207.46,'2022-01-18 17:17:25','',''),(2547506,'1','197','1018',464,'Retail Sale Id 1550542',3001.44,0.00,0.00,5.07,415.74,'2022-01-18 18:10:39','',''),(2547523,'1','197','1018',464,'Retail Sale Id 1550557',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 18:12:07','',''),(2547542,'1','197','1018',464,'Retail Sale Id 1550575',3599.36,0.00,0.00,6.08,498.56,'2022-01-18 18:13:43','',''),(2547637,'1','197','1018',464,'Retail Sale Id 1550686',7400.00,0.00,0.00,12.50,1025.00,'2022-01-18 18:27:58','',''),(2547738,'1','197','1018',464,'Retail Sale Id 1550786',4001.92,0.00,0.00,6.76,554.32,'2022-01-18 18:47:29','',''),(2547751,'1','197','1018',464,'Retail Sale Id 1550803',1000.48,0.00,0.00,1.69,138.58,'2022-01-18 18:50:44','',''),(2547761,'1','197','1018',464,'Retail Sale Id 1550815',3001.44,0.00,0.00,5.07,415.74,'2022-01-18 18:52:11','',''),(2548048,'1','197','1018',464,'Retail Sale Id 1551052',29600.00,0.00,0.00,50.00,4100.00,'2022-01-18 22:16:21','',''),(2548049,'1','197','1018',464,'Retail Sale Id 1551054',7719.68,0.00,0.00,13.04,1069.28,'2022-01-18 22:17:00','',''),(2548052,'1','197','1018',464,'Retail Sale Id 1551055',125508.48,0.00,0.00,239.52,3353.28,'2022-01-18 22:18:20','',''),(2548611,'1','197','1018',464,'Retail Sale Id 1551259',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 07:47:33','',''),(2548806,'1','197','1018',464,'Retail Sale Id 1551401',1799.68,0.00,0.00,3.04,249.28,'2022-01-19 08:05:08','',''),(2548929,'1','197','1018',464,'Retail Sale Id 1551487',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 08:14:26','',''),(2548960,'1','197','1018',464,'Retail Sale Id 1551516',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 08:17:38','',''),(2548980,'1','197','1018',464,'Retail Sale Id 1551539',2000.96,0.00,0.00,3.38,277.16,'2022-01-19 08:19:45','',''),(2549199,'1','197','1018',464,'Retail Sale Id 1551754',32750.00,0.00,0.00,62.50,875.00,'2022-01-19 08:40:24','',''),(2549215,'1','197','1018',464,'Retail Sale Id 1551766',52400.00,0.00,0.00,100.00,1400.00,'2022-01-19 08:41:25','',''),(2549756,'1','197','1018',464,'Retail Sale Id 1552221',799.20,0.00,0.00,1.35,110.70,'2022-01-19 09:23:40','',''),(2549878,'1','197','1018',464,'Retail Sale Id 1552336',4801.12,0.00,0.00,8.11,665.02,'2022-01-19 09:33:44','',''),(2550952,'1','197','1018',464,'Retail Sale Id 1553388',14800.00,0.00,0.00,25.00,2050.00,'2022-01-19 11:20:28','',''),(2550961,'1','197','1018',464,'Retail Sale Id 1553395',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 11:21:08','',''),(2551016,'1','197','1018',464,'Retail Sale Id 1553445',10999.36,0.00,0.00,18.58,1523.56,'2022-01-19 11:27:36','',''),(2551036,'1','197','1018',464,'Retail Sale Id 1553481',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 11:30:24','',''),(2551360,'1','197','1018',464,'Retail Sale Id 1553796',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 12:03:38','',''),(2551390,'1','197','1018',464,'Retail Sale Id 1553813',1000.48,0.00,0.00,1.69,138.58,'2022-01-19 12:05:31','',''),(2551697,'1','197','1018',464,'Retail Sale Id 1554160',6002.88,0.00,0.00,10.14,831.48,'2022-01-19 12:44:54','',''),(2551713,'1','197','1018',464,'Retail Sale Id 1554174',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 12:46:53','',''),(2551892,'1','197','1018',464,'Retail Sale Id 1554335',29600.00,0.00,0.00,50.00,4100.00,'2022-01-19 13:10:14','',''),(2551911,'1','197','1018',464,'Retail Sale Id 1554358',7400.00,0.00,0.00,12.50,1025.00,'2022-01-19 13:12:23','',''),(2552646,'1','197','1018',464,'Retail Sale Id 1555038',127227.20,0.00,0.00,242.80,3399.20,'2022-01-19 14:34:42','',''),(2552912,'1','197','1018',464,'Retail Sale Id 1555282',11840.00,0.00,0.00,20.00,1640.00,'2022-01-19 15:00:05','',''),(2553319,'1','197','1018',464,'Retail Sale Id 1555646',10480.00,0.00,0.00,20.00,280.00,'2022-01-19 15:38:11','',''),(2554459,'1','197','1018',464,'Retail Sale Id 1556583',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 17:01:46','',''),(2554560,'1','197','1018',464,'Retail Sale Id 1556698',7400.00,0.00,0.00,12.50,1025.00,'2022-01-19 17:09:27','',''),(2554574,'1','197','1018',464,'Retail Sale Id 1556712',7198.72,0.00,0.00,12.16,997.12,'2022-01-19 17:10:25','',''),(2554878,'1','197','1018',464,'Retail Sale Id 1557008',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 17:34:05','',''),(2554891,'1','197','1018',464,'Retail Sale Id 1557019',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 17:35:02','',''),(2555021,'1','197','1018',464,'Retail Sale Id 1557150',1497.76,0.00,0.00,2.53,207.46,'2022-01-19 17:45:18','',''),(2555027,'1','197','1018',464,'Retail Sale Id 1557155',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 17:46:04','',''),(2555112,'1','197','1018',464,'Retail Sale Id 1557247',7400.00,0.00,0.00,12.50,1025.00,'2022-01-19 17:53:20','',''),(2555133,'1','197','1018',464,'Retail Sale Id 1557268',7400.00,0.00,0.00,12.50,1025.00,'2022-01-19 17:55:50','',''),(2555148,'1','197','1018',464,'Retail Sale Id 1557280',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 17:57:25','',''),(2555198,'1','197','1018',464,'Retail Sale Id 1557341',1799.68,0.00,0.00,3.04,249.28,'2022-01-19 18:02:11','',''),(2555525,'1','197','1018',464,'Retail Sale Id 1557624',7400.00,0.00,0.00,12.50,1025.00,'2022-01-19 18:47:26','',''),(2555531,'1','197','1018',464,'Retail Sale Id 1557630',3001.44,0.00,0.00,5.07,415.74,'2022-01-19 18:48:59','',''),(2555533,'1','197','1018',464,'Retail Sale Id 1557632',7400.00,0.00,0.00,12.50,1025.00,'2022-01-19 18:49:31','',''),(2555536,'1','197','1018',464,'Retail Sale Id 1557636',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 18:50:13','',''),(2555549,'1','197','1018',464,'Retail Sale Id 1557649',3599.36,0.00,0.00,6.08,498.56,'2022-01-19 18:52:54','',''),(2555613,'1','197','1018',464,'Retail Sale Id 1557681',31387.60,0.00,0.00,59.90,838.60,'2022-01-19 19:01:45','',''),(2555637,'1','197','1018',464,'Retail Sale Id 1557694',1799.68,0.00,0.00,3.04,249.28,'2022-01-19 19:05:33','',''),(2555731,'1','197','1018',464,'Retail Sale Id 1557822',29600.00,0.00,0.00,50.00,4100.00,'2022-01-19 19:46:21','',''),(2555733,'1','197','1018',464,'Retail Sale Id 1557825',2723.20,0.00,0.00,4.60,377.20,'2022-01-19 19:46:57','',''),(2555735,'1','197','1018',464,'Retail Sale Id 1557827',34599.72,0.00,0.00,66.03,924.42,'2022-01-19 19:49:20','',''),(2556294,'1','197','1018',464,'Retail Sale Id 1557992',29600.00,0.00,0.00,50.00,4100.00,'2022-01-20 07:36:13','',''),(2556301,'1','197','1018',464,'Retail Sale Id 1557997',34060.00,0.00,0.00,65.00,910.00,'2022-01-20 07:38:04','',''),(2556363,'1','197','1018',464,'Retail Sale Id 1558015',52253.28,0.00,0.00,99.72,1396.08,'2022-01-20 07:47:24','',''),(2556368,'1','197','1018',464,'Retail Sale Id 1558064',1799.68,0.00,0.00,3.04,249.28,'2022-01-20 07:47:49','',''),(2556531,'1','197','1018',464,'Retail Sale Id 1558199',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 08:06:13','',''),(2556644,'1','197','1018',464,'Retail Sale Id 1558293',5002.40,0.00,0.00,8.45,692.90,'2022-01-20 08:17:41','',''),(2556790,'1','197','1018',464,'Retail Sale Id 1558435',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 08:33:38','',''),(2556964,'1','197','1018',464,'Retail Sale Id 1558575',1397.12,0.00,0.00,2.36,193.52,'2022-01-20 08:48:43','',''),(2557069,'1','197','1018',464,'Retail Sale Id 1558657',49753.80,0.00,0.00,94.95,1329.30,'2022-01-20 08:55:41','',''),(2557079,'1','197','1018',464,'Retail Sale Id 1558672',1000.48,0.00,0.00,1.69,138.58,'2022-01-20 08:56:27','',''),(2557229,'1','197','1018',464,'Retail Sale Id 1558784',2000.96,0.00,0.00,3.38,277.16,'2022-01-20 09:06:31','',''),(2557386,'1','197','1018',464,'Retail Sale Id 1558882',6997.44,0.00,0.00,11.82,969.24,'2022-01-20 09:15:28','',''),(2557432,'1','197','1018',464,'Retail Sale Id 1558924',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 09:18:42','',''),(2557448,'1','197','1018',464,'Retail Sale Id 1558938',2196.32,0.00,0.00,3.71,304.22,'2022-01-20 09:20:24','',''),(2558380,'1','197','1018',464,'Retail Sale Id 1559759',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 10:35:31','',''),(2558498,'1','197','1018',464,'Retail Sale Id 1559857',3001.44,0.00,0.00,5.07,415.74,'2022-01-20 10:43:28','',''),(2558779,'1','197','1018',464,'Retail Sale Id 1560163',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 11:11:05','',''),(2558869,'1','197','1018',464,'Retail Sale Id 1560266',52400.00,0.00,0.00,100.00,1400.00,'2022-01-20 11:20:07','',''),(2558958,'1','197','1018',464,'Retail Sale Id 1560364',3498.72,0.00,0.00,5.91,484.62,'2022-01-20 11:29:32','',''),(2559151,'1','197','1018',464,'Retail Sale Id 1560550',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 11:48:15','',''),(2559432,'1','197','1018',464,'Retail Sale Id 1560863',11894.80,0.00,0.00,22.70,317.80,'2022-01-20 12:18:23','',''),(2559473,'1','197','1018',464,'Retail Sale Id 1560908',34997.96,0.00,0.00,66.79,935.06,'2022-01-20 12:21:45','',''),(2559512,'1','197','1018',464,'Retail Sale Id 1560949',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 12:25:22','',''),(2559701,'1','197','1018',464,'Retail Sale Id 1561127',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 12:45:27','',''),(2559761,'1','197','1018',464,'Retail Sale Id 1561188',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 12:51:07','',''),(2559881,'1','197','1018',464,'Retail Sale Id 1561371',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 13:04:53','',''),(2559890,'1','197','1018',464,'Retail Sale Id 1561380',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 13:05:48','',''),(2559990,'1','197','1018',464,'Retail Sale Id 1561485',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 13:15:59','',''),(2560052,'1','197','1018',464,'Retail Sale Id 1561554',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 13:21:51','',''),(2560185,'1','197','1018',464,'Retail Sale Id 1561695',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 13:36:26','',''),(2560245,'1','197','1018',464,'Retail Sale Id 1561736',6837.60,0.00,0.00,11.55,947.10,'2022-01-20 13:43:34','',''),(2560274,'1','197','1018',464,'Retail Sale Id 1561779',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 13:45:34','',''),(2560311,'1','197','1018',464,'Retail Sale Id 1561815',1799.68,0.00,0.00,3.04,249.28,'2022-01-20 13:49:38','',''),(2560373,'1','197','1018',464,'Retail Sale Id 1561868',3001.44,0.00,0.00,5.07,415.74,'2022-01-20 13:54:35','',''),(2560467,'1','197','1018',464,'Retail Sale Id 1561950',3001.44,0.00,0.00,5.07,415.74,'2022-01-20 14:03:22','',''),(2560496,'1','197','1018',464,'Retail Sale Id 1561974',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 14:06:33','',''),(2560531,'1','197','1018',464,'Retail Sale Id 1562011',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 14:10:27','',''),(2560644,'1','197','1018',464,'Retail Sale Id 1562165',14800.00,0.00,0.00,25.00,2050.00,'2022-01-20 14:22:55','',''),(2560710,'1','197','1018',464,'Retail Sale Id 1562219',14800.00,0.00,0.00,25.00,2050.00,'2022-01-20 14:28:36','',''),(2560866,'1','197','1018',464,'Retail Sale Id 1562376',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 14:42:55','',''),(2560921,'1','197','1018',464,'Retail Sale Id 1562391',2000.96,0.00,0.00,3.38,277.16,'2022-01-20 14:46:40','',''),(2560966,'1','197','1018',464,'Retail Sale Id 1562465',1302.40,0.00,0.00,2.20,180.40,'2022-01-20 14:51:07','',''),(2561045,'1','197','1018',464,'Retail Sale Id 1562518',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 14:55:24','',''),(2561117,'1','197','1018',464,'Retail Sale Id 1562584',2498.24,0.00,0.00,4.22,346.04,'2022-01-20 15:01:26','',''),(2561118,'1','197','1018',464,'Retail Sale Id 1562584',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 15:01:26','',''),(2561146,'1','197','1018',464,'Retail Sale Id 1562606',1000.48,0.00,0.00,1.69,138.58,'2022-01-20 15:02:56','',''),(2561234,'1','197','1018',464,'Retail Sale Id 1562701',2000.96,0.00,0.00,3.38,277.16,'2022-01-20 15:10:48','',''),(2561923,'1','197','1018',464,'Retail Sale Id 1563532',7198.72,0.00,0.00,12.16,997.12,'2022-01-20 16:13:48','',''),(2561955,'1','197','1018',464,'Retail Sale Id 1563546',1799.68,0.00,0.00,3.04,249.28,'2022-01-20 16:14:48','',''),(2562054,'1','197','1018',464,'Retail Sale Id 1563636',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 16:22:52','',''),(2562107,'1','197','1018',464,'Retail Sale Id 1563707',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 16:27:30','',''),(2562126,'1','197','1018',464,'Retail Sale Id 1563733',14800.00,0.00,0.00,25.00,2050.00,'2022-01-20 16:28:59','',''),(2562160,'1','197','1018',464,'Retail Sale Id 1563756',4736.00,0.00,0.00,8.00,656.00,'2022-01-20 16:30:59','',''),(2562211,'1','197','1018',464,'Retail Sale Id 1563804',1799.68,0.00,0.00,3.04,249.28,'2022-01-20 16:34:44','',''),(2562320,'1','197','1018',464,'Retail Sale Id 1563878',29600.00,0.00,0.00,50.00,4100.00,'2022-01-20 16:40:45','',''),(2562353,'1','197','1018',464,'Retail Sale Id 1563897',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 16:42:07','',''),(2562534,'1','197','1018',464,'Retail Sale Id 1564029',9602.24,0.00,0.00,16.22,1330.04,'2022-01-20 16:51:49','',''),(2562618,'1','197','1018',464,'Retail Sale Id 1564117',1201.76,0.00,0.00,2.03,166.46,'2022-01-20 16:57:56','',''),(2562637,'1','197','1018',464,'Retail Sale Id 1564137',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 16:59:18','',''),(2562683,'1','197','1018',464,'Retail Sale Id 1564216',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 17:03:08','',''),(2562691,'1','197','1018',464,'Retail Sale Id 1564242',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 17:03:47','',''),(2562714,'1','197','1018',464,'Retail Sale Id 1564262',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 17:05:40','',''),(2562854,'1','197','1018',464,'Retail Sale Id 1564413',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 17:14:10','',''),(2562871,'1','197','1018',464,'Retail Sale Id 1564438',3498.72,0.00,0.00,5.91,484.62,'2022-01-20 17:15:24','',''),(2562891,'1','197','1018',464,'Retail Sale Id 1564452',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 17:16:24','',''),(2562924,'1','197','1018',464,'Retail Sale Id 1564497',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 17:18:11','',''),(2562974,'1','197','1018',464,'Retail Sale Id 1564561',3001.44,0.00,0.00,5.07,415.74,'2022-01-20 17:22:33','',''),(2563095,'1','197','1018',464,'Retail Sale Id 1564721',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 17:32:43','',''),(2563330,'1','197','1018',464,'Retail Sale Id 1564984',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 17:51:43','',''),(2563356,'1','197','1018',464,'Retail Sale Id 1565022',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 17:54:10','',''),(2563498,'1','197','1018',464,'Retail Sale Id 1565186',26200.00,0.00,0.00,50.00,700.00,'2022-01-20 18:04:10','',''),(2563516,'1','197','1018',464,'Retail Sale Id 1565250',7400.00,0.00,0.00,12.50,1025.00,'2022-01-20 18:04:58','',''),(2563770,'1','197','1018',464,'Retail Sale Id 1565520',1000.48,0.00,0.00,1.69,138.58,'2022-01-20 18:30:19','',''),(2563845,'1','197','1018',464,'Retail Sale Id 1565662',1497.76,0.00,0.00,2.53,207.46,'2022-01-20 18:49:59','',''),(2563914,'1','197','1018',464,'Retail Sale Id 1565775',3599.36,0.00,0.00,6.08,498.56,'2022-01-20 19:06:49','',''),(2563921,'1','197','1018',464,'Retail Sale Id 1565780',1000.48,0.00,0.00,1.69,138.58,'2022-01-20 19:09:20','',''),(2564178,'1','197','1018',464,'Retail Sale Id 1565866',14800.00,0.00,0.00,25.00,2050.00,'2022-01-20 20:28:02','',''),(2564181,'1','197','1018',464,'Retail Sale Id 1565869',5511.52,0.00,0.00,9.31,763.42,'2022-01-20 20:30:11','',''),(2564187,'1','197','1018',464,'Retail Sale Id 1565872',145268.52,0.00,0.00,277.23,3881.22,'2022-01-20 20:41:51','',''),(2564821,'1','197','1018',464,'Retail Sale Id 1566135',7400.00,0.00,0.00,12.50,1025.00,'2022-01-21 07:51:12','',''),(2565394,'1','197','1018',464,'Retail Sale Id 1566664',7400.00,0.00,0.00,12.50,1025.00,'2022-01-21 08:44:26','',''),(2565404,'1','197','1018',464,'Retail Sale Id 1566675',19650.00,0.00,0.00,37.50,525.00,'2022-01-21 08:45:23','',''),(2565494,'1','197','1018',464,'Retail Sale Id 1566780',3599.36,0.00,0.00,6.08,498.56,'2022-01-21 08:54:42','',''),(2565747,'1','197','1018',464,'Retail Sale Id 1567035',7400.00,0.00,0.00,12.50,1025.00,'2022-01-21 09:18:52','',''),(2565830,'1','197','1018',464,'Retail Sale Id 1567095',4001.92,0.00,0.00,6.76,554.32,'2022-01-21 09:23:39','',''),(2566994,'1','197','1018',464,'Return of Retail Sale Id 1566664',0.00,7400.00,12.50,0.00,-1025.00,'2022-01-21 11:08:16','',''),(2567017,'1','197','1018',464,'Retail Sale Id 1568069',2551.52,0.00,0.00,4.31,353.42,'2022-01-21 11:10:25','',''),(2567101,'1','197','1018',464,'Retail Sale Id 1568146',139740.32,0.00,0.00,266.68,3733.52,'2022-01-21 11:19:47','',''),(2569327,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,20772.30,40.73,0.00,0.00,'2022-01-21 15:06:57','',''),(2569355,'1','197',NULL,464,'Reception corrector for bridging 131616',0.00,0.00,0.00,40.73,0.00,'2022-01-21 15:09:03','',''),(2569356,'1','197','1018',464,'Received from bridging 131616',0.00,0.00,40.73,0.00,0.00,'2022-01-21 15:09:03','',''),(2569509,'1','197','1018',464,'Retail Sale Id 1570310',24112.16,0.00,0.00,40.73,3339.86,'2022-01-21 15:16:06','',''),(2569536,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1020000.00,2000.00,0.00,0.00,'2022-01-21 15:18:25','',''),(2569550,'1','197',NULL,464,'Reception corrector for bridging 131618',0.00,0.00,0.00,2000.00,0.00,'2022-01-21 15:19:18','',''),(2569551,'1','197','1018',464,'Received from bridging 131618',0.00,0.00,2000.00,0.00,0.00,'2022-01-21 15:19:18','',''),(2569593,'1','197','1018',464,'Retail Sale Id 1570577',1799.68,0.00,0.00,3.04,249.28,'2022-01-21 15:28:34','',''),(2570471,'1','197','1018',464,'Retail Sale Id 1571380',3599.36,0.00,0.00,6.08,498.56,'2022-01-21 16:35:22','',''),(2571098,'1','197','1018',464,'Retail Sale Id 1571999',16800.96,0.00,0.00,28.38,2327.16,'2022-01-21 17:14:29','',''),(2571108,'1','197','1018',464,'Retail Sale Id 1572006',7400.00,0.00,0.00,12.50,1025.00,'2022-01-21 17:15:11','',''),(2571177,'1','197','1018',464,'Retail Sale Id 1572069',14800.00,0.00,0.00,25.00,2050.00,'2022-01-21 17:19:09','',''),(2571202,'1','197','1018',464,'Retail Sale Id 1572096',16001.76,0.00,0.00,27.03,2216.46,'2022-01-21 17:20:59','',''),(2572567,'1','197','1018',464,'Retail Sale Id 1573340',59200.00,0.00,0.00,100.00,8200.00,'2022-01-21 20:15:29','',''),(2572584,'1','197','1018',464,'Retail Sale Id 1573345',29600.00,0.00,0.00,50.00,4100.00,'2022-01-21 20:22:45','',''),(2572589,'1','197','1018',464,'Retail Sale Id 1573356',30215.68,0.00,0.00,51.04,4185.28,'2022-01-21 20:27:39','',''),(2572592,'1','197','1018',464,'Retail Sale Id 1573361',157200.00,0.00,0.00,300.00,4200.00,'2022-01-21 20:32:45','',''),(2572593,'1','197','1018',464,'Retail Sale Id 1573362',184243.64,0.00,0.00,351.61,4922.54,'2022-01-21 20:34:02','',''),(2572881,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,1774800.00,3480.00,0.00,0.00,'2022-01-21 23:32:03','',''),(2572882,'1','197',NULL,464,'Reception corrector for bridging 131673',0.00,0.00,0.00,3480.00,0.00,'2022-01-21 23:34:06','',''),(2572883,'1','197','1018',464,'Received from bridging 131673',0.00,0.00,3480.00,0.00,0.00,'2022-01-21 23:34:06','',''),(2573631,'1','197','1018',464,'Retail Sale Id 1574059',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 08:41:13','',''),(2573677,'1','197','1018',464,'Retail Sale Id 1574109',8897.76,0.00,0.00,15.03,1232.46,'2022-01-22 08:45:30','',''),(2573705,'1','197','1018',464,'Retail Sale Id 1574143',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 08:48:05','',''),(2573757,'1','197','1018',464,'Retail Sale Id 1574220',131000.00,0.00,0.00,250.00,3500.00,'2022-01-22 08:55:17','',''),(2581426,'1','197','1018',464,'Retail Sale Id 1581722',29600.00,0.00,0.00,50.00,4100.00,'2022-01-22 20:09:04','',''),(2581427,'1','197','1018',464,'Retail Sale Id 1581723',29600.00,0.00,0.00,50.00,4100.00,'2022-01-22 20:09:49','',''),(2581429,'1','197','1018',464,'Retail Sale Id 1581725',3599.36,0.00,0.00,6.08,498.56,'2022-01-22 20:10:42','',''),(2581430,'1','197','1018',464,'Retail Sale Id 1581725',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:10:42','',''),(2581431,'1','197','1018',464,'Retail Sale Id 1581726',1799.68,0.00,0.00,3.04,249.28,'2022-01-22 20:11:31','',''),(2581432,'1','197','1018',464,'Retail Sale Id 1581726',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:11:31','',''),(2581436,'1','197','1018',464,'Retail Sale Id 1581728',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:12:28','',''),(2581437,'1','197','1018',464,'Retail Sale Id 1581728',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:12:28','',''),(2581438,'1','197','1018',464,'Retail Sale Id 1581728',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:12:28','',''),(2581441,'1','197','1018',464,'Retail Sale Id 1581730',1799.68,0.00,0.00,3.04,249.28,'2022-01-22 20:13:00','',''),(2581442,'1','197','1018',464,'Retail Sale Id 1581731',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:13:44','',''),(2581444,'1','197','1018',464,'Retail Sale Id 1581733',29600.00,0.00,0.00,50.00,4100.00,'2022-01-22 20:14:30','',''),(2581446,'1','197','1018',464,'Retail Sale Id 1581734',59200.00,0.00,0.00,100.00,8200.00,'2022-01-22 20:15:26','',''),(2581473,'1','197','1018',464,'Retail Sale Id 1581763',5920.00,0.00,0.00,10.00,820.00,'2022-01-22 20:40:37','',''),(2581474,'1','197','1018',464,'Retail Sale Id 1581763',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:40:37','',''),(2581475,'1','197','1018',464,'Retail Sale Id 1581763',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:40:37','',''),(2581485,'1','197','1018',464,'Retail Sale Id 1581768',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:47:47','',''),(2581486,'1','197','1018',464,'Retail Sale Id 1581768',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:47:47','',''),(2581490,'1','197','1018',464,'Retail Sale Id 1581770',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:49:59','',''),(2581491,'1','197','1018',464,'Retail Sale Id 1581770',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:50:00','',''),(2581493,'1','197','1018',464,'Retail Sale Id 1581772',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:51:12','',''),(2581494,'1','197','1018',464,'Retail Sale Id 1581772',14800.00,0.00,0.00,25.00,2050.00,'2022-01-22 20:51:12','',''),(2581497,'1','197','1018',464,'Retail Sale Id 1581773',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:53:44','',''),(2581498,'1','197','1018',464,'Retail Sale Id 1581773',7400.00,0.00,0.00,12.50,1025.00,'2022-01-22 20:53:44','',''),(2581512,'1','197','1018',464,'Retail Sale Id 1581777',4357.12,0.00,0.00,7.36,603.52,'2022-01-22 20:57:38','',''),(2581514,'1','197','1018',464,'Retail Sale Id 1581793',52400.00,0.00,0.00,100.00,1400.00,'2022-01-22 21:01:13','',''),(2581524,'1','197','1018',464,'Retail Sale Id 1581794',78600.00,0.00,0.00,150.00,2100.00,'2022-01-22 21:02:43','',''),(2581527,'1','197','1018',464,'Retail Sale Id 1581796',104800.00,0.00,0.00,200.00,2800.00,'2022-01-22 21:05:12','',''),(2581530,'1','197','1018',464,'Retail Sale Id 1581797',104800.00,0.00,0.00,200.00,2800.00,'2022-01-22 21:06:21','',''),(2581535,'1','197','1018',464,'Retail Sale Id 1581798',104841.92,0.00,0.00,200.08,2801.12,'2022-01-22 21:09:53','',''),(2581958,'1','197','1018',464,'Retail Sale Id 1581901',52400.00,0.00,0.00,100.00,1400.00,'2022-01-23 07:37:52','',''),(2581975,'1','197','1018',464,'Retail Sale Id 1581912',1799.68,0.00,0.00,3.04,249.28,'2022-01-23 07:40:11','',''),(2582106,'1','197','1018',464,'Retail Sale Id 1582058',8400.48,0.00,0.00,14.19,1163.58,'2022-01-23 08:03:34','',''),(2583511,'1','197','1018',464,'Retail Sale Id 1583190',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 10:01:12','',''),(2583956,'1','197','1018',464,'Retail Sale Id 1583611',26200.00,0.00,0.00,50.00,700.00,'2022-01-23 10:39:39','',''),(2589621,'1','197','1018',464,'Retail Sale Id 1588681',104800.00,0.00,0.00,200.00,2800.00,'2022-01-23 20:06:46','',''),(2589622,'1','197','1018',464,'Retail Sale Id 1588682',78600.00,0.00,0.00,150.00,2100.00,'2022-01-23 20:07:36','',''),(2589623,'1','197','1018',464,'Return of Retail Sale Id 1581901',0.00,52400.00,100.00,0.00,-1400.00,'2022-01-23 20:08:42','',''),(2589625,'1','197','1018',464,'Return of Retail Sale Id 1583611',0.00,26200.00,50.00,0.00,-700.00,'2022-01-23 20:10:48','',''),(2589627,'1','197','1018',464,'Retail Sale Id 1588686',4134.36,0.00,0.00,7.89,110.46,'2022-01-23 20:13:54','',''),(2589631,'1','197','1018',464,'Retail Sale Id 1588688',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:18:33','',''),(2589632,'1','197','1018',464,'Retail Sale Id 1588688',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:18:33','',''),(2589633,'1','197','1018',464,'Retail Sale Id 1588689',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:19:48','',''),(2589634,'1','197','1018',464,'Retail Sale Id 1588689',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:19:48','',''),(2589637,'1','197','1018',464,'Retail Sale Id 1588690',7400.00,0.00,0.00,12.50,1025.00,'2022-01-23 20:21:31','',''),(2589638,'1','197','1018',464,'Retail Sale Id 1588690',7400.00,0.00,0.00,12.50,1025.00,'2022-01-23 20:21:31','',''),(2589648,'1','197','1018',464,'Retail Sale Id 1588691',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:25:23','',''),(2589649,'1','197','1018',464,'Retail Sale Id 1588691',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:25:23','',''),(2589650,'1','197','1018',464,'Retail Sale Id 1588691',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:25:23','',''),(2589651,'1','197','1018',464,'Retail Sale Id 1588692',3599.36,0.00,0.00,6.08,498.56,'2022-01-23 20:26:17','',''),(2589652,'1','197','1018',464,'Retail Sale Id 1588692',7400.00,0.00,0.00,12.50,1025.00,'2022-01-23 20:26:17','',''),(2589653,'1','197','1018',464,'Retail Sale Id 1588693',29600.00,0.00,0.00,50.00,4100.00,'2022-01-23 20:28:17','',''),(2589654,'1','197','1018',464,'Retail Sale Id 1588693',29600.00,0.00,0.00,50.00,4100.00,'2022-01-23 20:28:17','',''),(2589655,'1','197','1018',464,'Retail Sale Id 1588694',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:31:32','',''),(2589656,'1','197','1018',464,'Retail Sale Id 1588694',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:31:32','',''),(2589657,'1','197','1018',464,'Retail Sale Id 1588695',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:33:15','',''),(2589658,'1','197','1018',464,'Retail Sale Id 1588695',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:33:15','',''),(2589664,'1','197','1018',464,'Retail Sale Id 1588697',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:35:52','',''),(2589665,'1','197','1018',464,'Retail Sale Id 1588697',14800.00,0.00,0.00,25.00,2050.00,'2022-01-23 20:35:52','',''),(2589672,'1','197','1018',464,'Retail Sale Id 1588699',7400.00,0.00,0.00,12.50,1025.00,'2022-01-23 20:38:05','',''),(2589679,'1','197','1018',464,'Retail Sale Id 1588700',1592.48,0.00,0.00,2.69,220.58,'2022-01-23 20:39:34','',''),(2589680,'1','197','1018',464,'Retail Sale Id 1588700',7400.00,0.00,0.00,12.50,1025.00,'2022-01-23 20:39:34','',''),(2590224,'1','197','1018',464,'Retail Sale Id 1588893',7400.00,0.00,0.00,12.50,1025.00,'2022-01-24 07:55:42','',''),(2590225,'1','197','1018',464,'Retail Sale Id 1588893',7400.00,0.00,0.00,12.50,1025.00,'2022-01-24 07:55:42','',''),(2592002,'1','197','1018',464,'Retail Sale Id 1590398',7400.00,0.00,0.00,12.50,1025.00,'2022-01-24 11:09:22','',''),(2592020,'1','197','1018',464,'Retail Sale Id 1590412',3599.36,0.00,0.00,6.08,498.56,'2022-01-24 11:10:36','',''),(2592024,'1','197','1018',464,'Retail Sale Id 1590418',3001.44,0.00,0.00,5.07,415.74,'2022-01-24 11:11:28','',''),(2592187,'1','197','1018',464,'Retail Sale Id 1590522',8400.48,0.00,0.00,14.19,1163.58,'2022-01-24 11:23:23','',''),(2592320,'1','197','1018',464,'Retail Sale Id 1590656',7400.00,0.00,0.00,12.50,1025.00,'2022-01-24 11:37:45','',''),(2595029,'1','197','1018',464,'Retail Sale Id 1593139',65500.00,0.00,0.00,125.00,1750.00,'2022-01-24 16:18:16','',''),(2596592,'1','197','1018',464,'Retail Sale Id 1595032',88800.00,0.00,0.00,150.00,12300.00,'2022-01-24 19:22:44','',''),(2596594,'1','197','1018',464,'Retail Sale Id 1595034',59200.00,0.00,0.00,100.00,8200.00,'2022-01-24 19:23:13','',''),(2596596,'1','197','1018',464,'Retail Sale Id 1595035',88800.00,0.00,0.00,150.00,12300.00,'2022-01-24 19:23:38','',''),(2596606,'1','197','1018',464,'Retail Sale Id 1595041',29600.00,0.00,0.00,50.00,4100.00,'2022-01-24 19:25:09','',''),(2596609,'1','197','1018',464,'Retail Sale Id 1595045',21223.20,0.00,0.00,35.85,2939.70,'2022-01-24 19:25:42','',''),(2596616,'1','197','1018',464,'Retail Sale Id 1595049',104800.00,0.00,0.00,200.00,2800.00,'2022-01-24 19:27:01','',''),(2596621,'1','197','1018',464,'Retail Sale Id 1595054',144100.00,0.00,0.00,275.00,3850.00,'2022-01-24 19:27:45','',''),(2596625,'1','197','1018',464,'Retail Sale Id 1595058',63404.00,0.00,0.00,121.00,1694.00,'2022-01-24 19:28:38','',''),(2596630,'1','197','1018',464,'Return of Retail Sale Id 1595058',0.00,63404.00,121.00,0.00,-1694.00,'2022-01-24 19:31:17','',''),(2596631,'1','197','1018',464,'Retail Sale Id 1595065',51823.60,0.00,0.00,98.90,1384.60,'2022-01-24 19:33:03','',''),(2600701,'1','197','1018',464,'Retail Sale Id 1598696',97988.00,0.00,0.00,187.00,2618.00,'2022-01-25 13:15:21','',''),(2600828,'1','197','1018',464,'Retail Sale Id 1598760',28474.16,0.00,0.00,54.34,760.76,'2022-01-25 13:22:48','',''),(2600845,'1','197','1018',464,'Retail Sale Id 1598771',14800.00,0.00,0.00,25.00,2050.00,'2022-01-25 13:24:36','',''),(2603821,'1','197','1018',464,'Retail Sale Id 1601633',39478.16,0.00,0.00,75.34,1054.76,'2022-01-25 17:33:17','',''),(2603841,'1','197','1018',464,'Retail Sale Id 1601649',59200.00,0.00,0.00,100.00,8200.00,'2022-01-25 17:34:19','',''),(2603861,'1','197','1018',464,'Retail Sale Id 1601677',7400.00,0.00,0.00,12.50,1025.00,'2022-01-25 17:36:06','',''),(2603862,'1','197','1018',464,'Retail Sale Id 1601677',22200.00,0.00,0.00,37.50,3075.00,'2022-01-25 17:36:06','',''),(2603863,'1','197','1018',464,'Retail Sale Id 1601677',29600.00,0.00,0.00,50.00,4100.00,'2022-01-25 17:36:06','',''),(2603885,'1','197','1018',464,'Retail Sale Id 1601700',22200.00,0.00,0.00,37.50,3075.00,'2022-01-25 17:37:34','',''),(2603917,'1','197','1018',464,'Retail Sale Id 1601732',25728.32,0.00,0.00,43.46,3563.72,'2022-01-25 17:39:55','',''),(2604196,'1','197','1018',464,'Distributed to ASUK GAS for sales id:349016',13555.80,0.00,0.00,26.58,0.00,'2022-01-25 17:59:05','',''),(2606557,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2493900.00,4890.00,0.00,0.00,'2022-01-26 08:45:41','',''),(2606599,'1','197',NULL,464,'Reception corrector for bridging 132128',0.00,0.00,0.00,4890.00,0.00,'2022-01-26 08:51:27','',''),(2606600,'1','197','1018',464,'Received from bridging 132128',0.00,0.00,4890.00,0.00,0.00,'2022-01-26 08:51:27','',''),(2606664,'1','197','1018',464,'Retail Sale Id 1603856',63148.64,0.00,0.00,106.67,8746.94,'2022-01-26 08:59:33','',''),(2606777,'1','197','1018',464,'Retail Sale Id 1603934',7400.00,0.00,0.00,12.50,1025.00,'2022-01-26 09:07:21','',''),(2606981,'1','197','1018',464,'Retail Sale Id 1604118',6600.80,0.00,0.00,11.15,914.30,'2022-01-26 09:28:02','',''),(2608317,'1','197','1018',464,'Retail Sale Id 1605385',78398.56,0.00,0.00,132.43,10859.26,'2022-01-26 11:40:04','',''),(2610935,'1','197','1018',464,'Retail Sale Id 1608710',14800.00,0.00,0.00,25.00,2050.00,'2022-01-26 16:56:10','',''),(2610946,'1','197','1018',464,'Retail Sale Id 1608718',7400.00,0.00,0.00,12.50,1025.00,'2022-01-26 16:57:14','',''),(2610987,'1','197','1018',464,'Retail Sale Id 1608745',11840.00,0.00,0.00,20.00,1640.00,'2022-01-26 16:58:51','',''),(2611050,'1','197','1018',464,'Retail Sale Id 1608829',3599.36,0.00,0.00,6.08,498.56,'2022-01-26 17:04:16','',''),(2611085,'1','197','1018',464,'Retail Sale Id 1608865',62010.16,0.00,0.00,118.34,1656.76,'2022-01-26 17:06:46','',''),(2612342,'1','197','1018',464,'Retail Sale Id 1610292',160454.04,0.00,0.00,306.21,4286.94,'2022-01-26 19:48:21','',''),(2612347,'1','197','1018',464,'Retail Sale Id 1610295',7400.00,0.00,0.00,12.50,1025.00,'2022-01-26 19:50:41','',''),(2612348,'1','197','1018',464,'Retail Sale Id 1610295',14800.00,0.00,0.00,25.00,2050.00,'2022-01-26 19:50:41','',''),(2612349,'1','197','1018',464,'Retail Sale Id 1610295',22200.00,0.00,0.00,37.50,3075.00,'2022-01-26 19:50:41','',''),(2612350,'1','197','1018',464,'Retail Sale Id 1610295',59200.00,0.00,0.00,100.00,8200.00,'2022-01-26 19:50:41','',''),(2612354,'1','197','1018',464,'Retail Sale Id 1610298',7400.00,0.00,0.00,12.50,1025.00,'2022-01-26 19:53:12','',''),(2612355,'1','197','1018',464,'Retail Sale Id 1610298',14800.00,0.00,0.00,25.00,2050.00,'2022-01-26 19:53:12','',''),(2612356,'1','197','1018',464,'Retail Sale Id 1610298',88800.00,0.00,0.00,150.00,12300.00,'2022-01-26 19:53:12','',''),(2612357,'1','197','1018',464,'Retail Sale Id 1610303',2000.96,0.00,0.00,3.38,277.16,'2022-01-26 19:56:37','',''),(2612358,'1','197','1018',464,'Retail Sale Id 1610303',7400.00,0.00,0.00,12.50,1025.00,'2022-01-26 19:56:37','',''),(2612360,'1','197','1018',464,'Retail Sale Id 1610305',11502.56,0.00,0.00,19.43,1593.26,'2022-01-26 19:57:17','',''),(2612882,'1','197',NULL,464,'Balance from closing inventory values 2021-11-31 23:59:59',24300732.60,24236419.58,83620.58,81969.99,1005149.32,'2021-11-30 23:59:59','',''),(2613760,'1','197','1018',0,'Balance from closing inventory values 2021-11-31 23:59:59',24300732.60,170502.00,41810.29,40159.70,1005149.32,'2021-11-30 23:59:59','',''),(2614280,'1','197','1018',464,'Retail Sale Id 1610524',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 07:41:50','',''),(2614314,'1','197','1018',464,'Retail Sale Id 1610558',3599.36,0.00,0.00,6.08,498.56,'2022-01-27 07:47:12','',''),(2622486,'1','197','1018',464,'Retail Sale Id 1617438',14800.00,0.00,0.00,25.00,2050.00,'2022-01-27 20:36:23','',''),(2622487,'1','197','1018',464,'Retail Sale Id 1617438',14800.00,0.00,0.00,25.00,2050.00,'2022-01-27 20:36:23','',''),(2622491,'1','197','1018',464,'Retail Sale Id 1617439',14800.00,0.00,0.00,25.00,2050.00,'2022-01-27 20:39:18','',''),(2622492,'1','197','1018',464,'Retail Sale Id 1617439',14800.00,0.00,0.00,25.00,2050.00,'2022-01-27 20:39:18','',''),(2622493,'1','197','1018',464,'Retail Sale Id 1617441',3599.36,0.00,0.00,6.08,498.56,'2022-01-27 20:40:54','',''),(2622494,'1','197','1018',464,'Retail Sale Id 1617441',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:40:54','',''),(2622495,'1','197','1018',464,'Retail Sale Id 1617442',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:42:11','',''),(2622497,'1','197','1018',464,'Retail Sale Id 1617444',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:43:12','',''),(2622498,'1','197','1018',464,'Retail Sale Id 1617445',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:44:07','',''),(2622500,'1','197','1018',464,'Retail Sale Id 1617446',29600.00,0.00,0.00,50.00,4100.00,'2022-01-27 20:45:08','',''),(2622501,'1','197','1018',464,'Retail Sale Id 1617447',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:46:16','',''),(2622502,'1','197','1018',464,'Retail Sale Id 1617447',29600.00,0.00,0.00,50.00,4100.00,'2022-01-27 20:46:16','',''),(2622506,'1','197','1018',464,'Retail Sale Id 1617449',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:49:08','',''),(2622507,'1','197','1018',464,'Retail Sale Id 1617449',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:49:08','',''),(2622508,'1','197','1018',464,'Retail Sale Id 1617449',14800.00,0.00,0.00,25.00,2050.00,'2022-01-27 20:49:08','',''),(2622509,'1','197','1018',464,'Retail Sale Id 1617451',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:51:12','',''),(2622510,'1','197','1018',464,'Retail Sale Id 1617451',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:51:12','',''),(2622511,'1','197','1018',464,'Retail Sale Id 1617451',29600.00,0.00,0.00,50.00,4100.00,'2022-01-27 20:51:12','',''),(2622512,'1','197','1018',464,'Retail Sale Id 1617452',14800.00,0.00,0.00,25.00,2050.00,'2022-01-27 20:53:54','',''),(2622514,'1','197','1018',464,'Retail Sale Id 1617454',3599.36,0.00,0.00,6.08,498.56,'2022-01-27 20:56:02','',''),(2622515,'1','197','1018',464,'Retail Sale Id 1617454',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:56:02','',''),(2622516,'1','197','1018',464,'Retail Sale Id 1617454',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 20:56:02','',''),(2622527,'1','197','1018',464,'Retail Sale Id 1617456',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 21:02:52','',''),(2622528,'1','197','1018',464,'Retail Sale Id 1617456',7400.00,0.00,0.00,12.50,1025.00,'2022-01-27 21:02:52','',''),(2622530,'1','197','1018',464,'Retail Sale Id 1617457',29600.00,0.00,0.00,50.00,4100.00,'2022-01-27 21:04:32','',''),(2622532,'1','197','1018',464,'Retail Sale Id 1617459',8980.64,0.00,0.00,15.17,1243.94,'2022-01-27 21:05:57','',''),(2622547,'1','197','1018',464,'Retail Sale Id 1617460',157200.00,0.00,0.00,300.00,4200.00,'2022-01-27 21:07:20','',''),(2622551,'1','197','1018',464,'Retail Sale Id 1617461',164012.00,0.00,0.00,313.00,4382.00,'2022-01-27 21:21:20','',''),(2622552,'1','197','1018',464,'Retail Sale Id 1617462',131000.00,0.00,0.00,250.00,3500.00,'2022-01-27 21:23:11','',''),(2622553,'1','197','1018',464,'Retail Sale Id 1617463',30942.20,0.00,0.00,59.05,826.70,'2022-01-27 21:26:02','',''),(2630992,'1','197','1018',464,'Retail Sale Id 1624838',7400.00,0.00,0.00,12.50,1025.00,'2022-01-28 20:02:01','',''),(2630993,'1','197','1018',464,'Retail Sale Id 1624838',22200.00,0.00,0.00,37.50,3075.00,'2022-01-28 20:02:01','',''),(2630994,'1','197','1018',464,'Retail Sale Id 1624838',59200.00,0.00,0.00,100.00,8200.00,'2022-01-28 20:02:01','',''),(2630995,'1','197','1018',464,'Retail Sale Id 1624839',118400.00,0.00,0.00,200.00,16400.00,'2022-01-28 20:02:33','',''),(2630997,'1','197','1018',464,'Retail Sale Id 1624841',7400.00,0.00,0.00,12.50,1025.00,'2022-01-28 20:02:57','',''),(2630999,'1','197','1018',464,'Retail Sale Id 1624843',7400.00,0.00,0.00,12.50,1025.00,'2022-01-28 20:03:54','',''),(2631000,'1','197','1018',464,'Retail Sale Id 1624843',14800.00,0.00,0.00,25.00,2050.00,'2022-01-28 20:03:54','',''),(2631001,'1','197','1018',464,'Retail Sale Id 1624843',29600.00,0.00,0.00,50.00,4100.00,'2022-01-28 20:03:54','',''),(2631003,'1','197','1018',464,'Retail Sale Id 1624845',59200.00,0.00,0.00,100.00,8200.00,'2022-01-28 20:05:49','',''),(2631004,'1','197','1018',464,'Retail Sale Id 1624846',7400.00,0.00,0.00,12.50,1025.00,'2022-01-28 20:06:22','',''),(2631024,'1','197','1018',464,'Retail Sale Id 1624848',7400.00,0.00,0.00,12.50,1025.00,'2022-01-28 20:09:03','',''),(2631048,'1','197','1018',464,'Retail Sale Id 1624869',44506.56,0.00,0.00,75.18,6164.76,'2022-01-28 20:20:24','',''),(2631050,'1','197','1018',464,'Retail Sale Id 1624871',338000.00,0.00,0.00,650.00,6500.00,'2022-01-28 20:21:33','',''),(2631055,'1','197','1018',464,'Retail Sale Id 1624874',49780.00,0.00,0.00,95.00,1330.00,'2022-01-28 20:22:58','',''),(2631057,'1','197','1018',464,'Retail Sale Id 1624876',8384.00,0.00,0.00,16.00,224.00,'2022-01-28 20:24:30','',''),(2631061,'1','197','1018',464,'Retail Sale Id 1624878',74245.56,0.00,0.00,141.69,1983.66,'2022-01-28 20:25:33','',''),(2631558,'1','197','1018',464,'Retail Sale Id 1624983',7400.00,0.00,0.00,12.50,1025.00,'2022-01-29 07:43:58','',''),(2631561,'1','197','1018',464,'Retail Sale Id 1624987',3599.36,0.00,0.00,6.08,498.56,'2022-01-29 07:45:06','',''),(2631562,'1','197','1018',464,'Retail Sale Id 1624987',7400.00,0.00,0.00,12.50,1025.00,'2022-01-29 07:45:06','',''),(2631580,'1','197','1018',464,'Retail Sale Id 1624988',13100.00,0.00,0.00,25.00,350.00,'2022-01-29 07:46:14','',''),(2632120,'1','197','1018',464,'Retail Sale Id 1625417',14800.00,0.00,0.00,25.00,2050.00,'2022-01-29 09:12:28','',''),(2632130,'1','197','1018',464,'Retail Sale Id 1625428',6002.88,0.00,0.00,10.14,831.48,'2022-01-29 09:13:45','',''),(2632336,'1','197','1018',464,'Retail Sale Id 1625607',13000.32,0.00,0.00,21.96,1800.72,'2022-01-29 09:39:15','',''),(2632367,'1','197','1018',464,'Retail Sale Id 1625619',39300.00,0.00,0.00,75.00,1050.00,'2022-01-29 09:40:19','',''),(2640284,'1','197','1018',464,'Retail Sale Id 1632879',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 19:50:12','',''),(2640309,'1','197','1018',464,'Retail Sale Id 1632926',1799.68,0.00,0.00,3.04,249.28,'2022-01-29 20:01:34','',''),(2640310,'1','197','1018',464,'Retail Sale Id 1632926',14800.00,0.00,0.00,25.00,2050.00,'2022-01-29 20:01:34','',''),(2640317,'1','197','1018',464,'Retail Sale Id 1632948',1000.48,0.00,0.00,1.69,138.58,'2022-01-29 20:03:09','',''),(2640318,'1','197','1018',464,'Retail Sale Id 1632948',7400.00,0.00,0.00,12.50,1025.00,'2022-01-29 20:03:09','',''),(2640321,'1','197','1018',464,'Retail Sale Id 1632951',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 20:04:00','',''),(2640328,'1','197','1018',464,'Retail Sale Id 1632958',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 20:06:21','',''),(2640329,'1','197','1018',464,'Retail Sale Id 1632959',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 20:07:14','',''),(2640331,'1','197','1018',464,'Retail Sale Id 1632960',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 20:08:36','',''),(2640337,'1','197','1018',464,'Retail Sale Id 1632964',11840.00,0.00,0.00,20.00,1640.00,'2022-01-29 20:10:35','',''),(2640338,'1','197','1018',464,'Retail Sale Id 1632965',11840.00,0.00,0.00,20.00,1640.00,'2022-01-29 20:11:27','',''),(2640344,'1','197','1018',464,'Retail Sale Id 1632967',4398.56,0.00,0.00,7.43,609.26,'2022-01-29 20:13:13','',''),(2640345,'1','197','1018',464,'Retail Sale Id 1632968',52400.00,0.00,0.00,100.00,1400.00,'2022-01-29 20:15:52','',''),(2640354,'1','197','1018',464,'Retail Sale Id 1632979',20713.72,0.00,0.00,39.53,553.42,'2022-01-29 20:22:22','',''),(2640387,'1','197','1018',464,'Distributed to ZAKIOUS GAS for sales id:350272',20706.00,0.00,0.00,40.60,0.00,'2022-01-29 20:31:42','',''),(2640394,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2708100.00,5310.00,0.00,0.00,'2022-01-29 20:43:06','',''),(2640395,'1','197',NULL,464,'Reception corrector for bridging 132585',0.00,0.00,0.00,5310.00,0.00,'2022-01-29 20:44:36','',''),(2640396,'1','197','1018',464,'Received from bridging 132585',0.00,0.00,5310.00,0.00,0.00,'2022-01-29 20:44:36','',''),(2640397,'1','197','1018',464,'Retail Sale Id 1632996',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 20:46:41','',''),(2640414,'1','197','1018',464,'Retail Sale Id 1633006',7400.00,0.00,0.00,12.50,1025.00,'2022-01-29 20:59:32','',''),(2640417,'1','197','1018',464,'Retail Sale Id 1633007',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 21:01:20','',''),(2640418,'1','197','1018',464,'Retail Sale Id 1633008',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 21:02:15','',''),(2640419,'1','197','1018',464,'Retail Sale Id 1633009',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 21:03:45','',''),(2640424,'1','197','1018',464,'Retail Sale Id 1633011',29600.00,0.00,0.00,50.00,4100.00,'2022-01-29 21:05:11','',''),(2640429,'1','197','1018',464,'Retail Sale Id 1633013',14800.00,0.00,0.00,25.00,2050.00,'2022-01-29 21:07:27','',''),(2640430,'1','197','1018',464,'Retail Sale Id 1633014',13408.80,0.00,0.00,22.65,1857.30,'2022-01-29 21:08:33','',''),(2640435,'1','197','1018',464,'Retail Sale Id 1633015',104800.00,0.00,0.00,200.00,2800.00,'2022-01-29 21:09:28','',''),(2640437,'1','197','1018',464,'Retail Sale Id 1633017',26200.00,0.00,0.00,50.00,700.00,'2022-01-29 21:10:30','',''),(2640448,'1','197','1018',464,'Retail Sale Id 1633018',13749.76,0.00,0.00,26.24,367.36,'2022-01-29 21:12:19','',''),(2640720,'1','197','1018',464,'Retail Sale Id 1633039',7100.00,0.00,0.00,12.50,725.00,'2022-01-30 07:12:45','',''),(2641034,'1','197','1018',464,'Retail Sale Id 1633254',8849.44,0.00,0.00,15.58,903.64,'2022-01-30 08:01:17','',''),(2641528,'1','197','1018',464,'Retail Sale Id 1633730',6901.20,0.00,0.00,12.15,704.70,'2022-01-30 08:40:58','',''),(2643828,'1','197','1018',464,'Retail Sale Id 1635852',14200.00,0.00,0.00,25.00,1450.00,'2022-01-30 11:17:00','',''),(2643862,'1','197','1018',464,'Retail Sale Id 1635880',91700.00,0.00,0.00,175.00,2450.00,'2022-01-30 11:18:40','',''),(2643884,'1','197','1018',464,'Retail Sale Id 1635900',10002.48,0.00,0.00,17.61,1021.38,'2022-01-30 11:19:48','',''),(2650189,'1','197','1018',464,'Retail Sale Id 1641585',306333.76,0.00,0.00,539.32,31280.56,'2022-01-30 18:26:07','',''),(2650219,'1','197','1018',464,'Retail Sale Id 1641608',104427.96,0.00,0.00,199.29,2790.06,'2022-01-30 18:30:56','',''),(2650275,'1','197','1018',464,'Retail Sale Id 1641662',492780.00,0.00,0.00,955.00,5730.00,'2022-01-30 18:39:27','',''),(2650276,'1','197','1018',464,'Retail Sale Id 1641663',500500.00,0.00,0.00,962.50,9625.00,'2022-01-31 11:55:13','',''),(2650277,'1','197','1018',464,'Retail Sale Id 1641664',4498.56,0.00,0.00,7.92,459.36,'2022-01-31 11:56:19','',''),(2650278,'1','197','1018',464,'Retail Sale Id 1641666',110500.00,0.00,0.00,212.50,2125.00,'2022-01-31 17:40:22','',''),(2650279,'1','197','1018',464,'Retail Sale Id 1641667',104800.00,0.00,0.00,200.00,2800.00,'2022-01-31 20:37:47','',''),(2650280,'1','197','1018',464,'Retail Sale Id 1641668',98852.60,0.00,0.00,188.65,2641.10,'2022-01-31 20:38:37','',''),(2650281,'1','197','1018',464,'Retail Sale Id 1641669',113600.00,0.00,0.00,200.00,11600.00,'2022-01-31 20:39:02','',''),(2650282,'1','197','1018',464,'Retail Sale Id 1641670',78100.00,0.00,0.00,137.50,7975.00,'2022-01-31 20:39:24','',''),(2650283,'1','197','1018',464,'Retail Sale Id 1641671',163464.72,0.00,0.00,287.79,16691.82,'2022-01-31 20:40:32','',''),(2650284,'1','197','1018',464,'Retail Sale Id 1641672',7100.00,0.00,0.00,12.50,725.00,'2022-02-01 08:50:56','',''),(2650285,'1','197','1018',464,'Retail Sale Id 1641673',19275.00,0.00,0.00,37.50,150.00,'2022-02-01 08:56:33','',''),(2650286,'1','197','1018',464,'Retail Sale Id 1641674',154200.00,0.00,0.00,300.00,1200.00,'2022-02-01 23:06:59','',''),(2650287,'1','197','1018',464,'Retail Sale Id 1641675',78899.00,0.00,0.00,153.50,614.00,'2022-02-01 23:07:43','',''),(2650288,'1','197','1018',464,'Retail Sale Id 1641676',28400.00,0.00,0.00,50.00,2900.00,'2022-02-01 23:08:44','',''),(2650289,'1','197','1018',464,'Retail Sale Id 1641677',10462.56,0.00,0.00,18.42,1068.36,'2022-02-01 23:09:15','',''),(2650290,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350273',1728.90,0.00,0.00,3.39,0.00,'2022-02-01 23:15:09','',''),(2650291,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2764200.00,5420.00,0.00,0.00,'2022-02-01 23:17:50','',''),(2650292,'1','197',NULL,464,'Reception corrector for bridging 132586',0.00,0.00,0.00,5420.00,0.00,'2022-02-01 23:18:53','',''),(2650293,'1','197','1018',464,'Received from bridging 132586',0.00,0.00,5420.00,0.00,0.00,'2022-02-01 23:18:53','',''),(2650294,'1','197','1018',464,'Retail Sale Id 1641678',113600.00,0.00,0.00,200.00,11600.00,'2022-02-01 23:21:04','',''),(2650295,'1','197','1018',464,'Retail Sale Id 1641679',113600.00,0.00,0.00,200.00,11600.00,'2022-02-01 23:21:29','',''),(2650296,'1','197','1018',464,'Retail Sale Id 1641680',28513.60,0.00,0.00,50.20,2911.60,'2022-02-01 23:22:02','',''),(2650297,'1','197','1018',464,'Retail Sale Id 1641681',85200.64,0.00,0.00,165.76,663.04,'2022-02-01 23:22:57','',''),(2650298,'1','197','1018',464,'Retail Sale Id 1641682',102800.00,0.00,0.00,200.00,800.00,'2022-02-01 23:23:40','',''),(2650299,'1','197','1018',464,'Retail Sale Id 1641683',179900.00,0.00,0.00,350.00,1400.00,'2022-02-02 19:51:05','',''),(2650300,'1','197','1018',464,'Retail Sale Id 1641684',102800.00,0.00,0.00,200.00,800.00,'2022-02-02 19:52:10','',''),(2650301,'1','197','1018',464,'Retail Sale Id 1641685',179900.00,0.00,0.00,350.00,1400.00,'2022-02-02 19:53:30','',''),(2650302,'1','197','1018',464,'Retail Sale Id 1641686',175212.32,0.00,0.00,340.88,1363.52,'2022-02-02 19:54:54','',''),(2650303,'1','197','1018',464,'Retail Sale Id 1641687',102800.00,0.00,0.00,200.00,800.00,'2022-02-02 19:57:07','',''),(2650304,'1','197','1018',464,'Retail Sale Id 1641688',384376.96,0.00,0.00,676.72,39249.76,'2022-02-02 19:58:23','',''),(2650305,'1','197','1018',464,'Retail Sale Id 1641689',25700.00,0.00,0.00,50.00,200.00,'2022-02-03 08:10:10','',''),(2650306,'1','197','1018',464,'Retail Sale Id 1641690',10598.88,0.00,0.00,18.66,1082.28,'2022-02-03 08:11:47','',''),(2650307,'1','197','1018',464,'Retail Sale Id 1641691',7100.00,0.00,0.00,12.50,725.00,'2022-02-03 08:15:29','',''),(2650308,'1','197','1018',464,'Retail Sale Id 1641692',5799.28,0.00,0.00,10.21,592.18,'2022-02-03 08:25:56','',''),(2650309,'1','197','1018',464,'Retail Sale Id 1641693',3498.88,0.00,0.00,6.16,357.28,'2022-02-03 08:26:58','',''),(2650310,'1','197','1018',464,'Retail Sale Id 1641695',5998.08,0.00,0.00,10.56,612.48,'2022-02-03 08:35:18','',''),(2650311,'1','197','1018',464,'Retail Sale Id 1641696',10899.92,0.00,0.00,19.19,1113.02,'2022-02-03 08:54:41','',''),(2650312,'1','197','1018',464,'Retail Sale Id 1641697',1799.00,0.00,0.00,3.50,14.00,'2022-02-03 08:55:26','',''),(2650313,'1','197','1018',464,'Retail Sale Id 1641698',19275.00,0.00,0.00,37.50,150.00,'2022-02-03 08:57:02','',''),(2650314,'1','197','1018',464,'Retail Sale Id 1641699',7100.00,0.00,0.00,12.50,725.00,'2022-02-03 09:12:27','',''),(2650315,'1','197','1018',464,'Retail Sale Id 1641700',3498.88,0.00,0.00,6.16,357.28,'2022-02-03 09:12:56','',''),(2650316,'1','197','1018',464,'Retail Sale Id 1641701',14200.00,0.00,0.00,25.00,1450.00,'2022-02-03 09:42:30','',''),(2650317,'1','197','1018',464,'Retail Sale Id 1641702',21331.00,0.00,0.00,41.50,166.00,'2022-02-03 09:44:15','',''),(2650318,'1','197','1018',464,'Retail Sale Id 1641703',255000.00,0.00,0.00,500.00,0.00,'2022-02-03 10:49:01','',''),(2650319,'1','197','1018',464,'Retail Sale Id 1641704',10002.48,0.00,0.00,17.61,1021.38,'2022-02-03 10:49:30','',''),(2650320,'1','197','1018',464,'Retail Sale Id 1641705',14200.00,0.00,0.00,25.00,1450.00,'2022-02-03 12:51:50','',''),(2650321,'1','197','1018',464,'Retail Sale Id 1641706',154200.00,0.00,0.00,300.00,1200.00,'2022-02-03 12:52:33','',''),(2650322,'1','197','1018',464,'Retail Sale Id 1641707',999.68,0.00,0.00,1.76,102.08,'2022-02-03 12:53:25','',''),(2650323,'1','197','1018',464,'Retail Sale Id 1641709',7100.00,0.00,0.00,12.50,725.00,'2022-02-03 13:41:50','',''),(2650324,'1','197','1018',464,'Retail Sale Id 1641709',7100.00,0.00,0.00,12.50,725.00,'2022-02-03 13:41:50','',''),(2650325,'1','197','1018',464,'Retail Sale Id 1641710',98616.04,0.00,0.00,191.86,767.44,'2022-02-03 19:52:42','',''),(2650326,'1','197','1018',464,'Retail Sale Id 1641711',275888.96,0.00,0.00,485.72,28171.76,'2022-02-03 19:54:16','',''),(2650327,'1','197','1018',464,'Retail Sale Id 1641712',7100.00,0.00,0.00,12.50,725.00,'2022-02-04 08:34:03','',''),(2650328,'1','197','1018',464,'Retail Sale Id 1641712',10502.32,0.00,0.00,18.49,1072.42,'2022-02-04 08:34:03','',''),(2650329,'1','197','1018',464,'Retail Sale Id 1641713',68767.76,0.00,0.00,121.07,7022.06,'2022-02-04 18:45:44','',''),(2650330,'1','197','1018',464,'Retail Sale Id 1641714',102800.00,0.00,0.00,200.00,800.00,'2022-02-04 18:50:49','',''),(2650331,'1','197','1018',464,'Retail Sale Id 1641715',134395.58,0.00,0.00,261.47,1045.88,'2022-02-04 18:52:49','',''),(2650332,'1','197','1018',464,'Distributed to BENOR GAS for sales id:350274',36980.10,0.00,0.00,72.51,0.00,'2022-02-04 20:54:44','',''),(2650333,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2665000.00,5330.00,0.00,0.00,'2022-02-04 20:57:03','',''),(2650334,'1','197',NULL,464,'Reception corrector for bridging 132587',0.00,0.00,0.00,5330.00,0.00,'2022-02-04 20:59:32','',''),(2650335,'1','197','1018',464,'Received from bridging 132587',0.00,0.00,5330.00,0.00,0.00,'2022-02-04 20:59:32','',''),(2650336,'1','197','1018',464,'Retail Sale Id 1641716',212693.28,0.00,0.00,374.46,25463.28,'2022-02-04 21:15:21','',''),(2650337,'1','197','1018',464,'Retail Sale Id 1641717',303897.36,0.00,0.00,591.24,8277.36,'2022-02-04 21:16:14','',''),(2650338,'1','197','1018',464,'Retail Sale Id 1641718',284000.00,0.00,0.00,500.00,34000.00,'2022-02-05 20:15:59','',''),(2650339,'1','197','1018',464,'Retail Sale Id 1641719',235833.60,0.00,0.00,415.20,28233.60,'2022-02-05 20:16:36','',''),(2650340,'1','197','1018',464,'Retail Sale Id 1641720',257000.00,0.00,0.00,500.00,7000.00,'2022-02-05 20:17:13','',''),(2650341,'1','197','1018',464,'Retail Sale Id 1641721',154200.00,0.00,0.00,300.00,4200.00,'2022-02-05 20:17:39','',''),(2650342,'1','197','1018',464,'Retail Sale Id 1641722',181956.00,0.00,0.00,354.00,4956.00,'2022-02-05 20:18:39','',''),(2650343,'1','197','1018',464,'Retail Sale Id 1641726',154472.42,0.00,0.00,300.53,4207.42,'2022-02-05 20:19:31','',''),(2650344,'1','197','1018',464,'Retail Sale Id 1641728',275167.60,0.00,0.00,484.45,32942.60,'2022-02-07 07:45:02','',''),(2650345,'1','197','1018',464,'Retail Sale Id 1641729',460800.00,0.00,0.00,900.00,10800.00,'2022-02-07 07:46:02','',''),(2650346,'1','197','1018',464,'Retail Sale Id 1641730',44975.00,0.00,0.00,87.50,1225.00,'2022-02-07 07:46:49','',''),(2650347,'1','197','1018',464,'Retail Sale Id 1641731',86609.00,0.00,0.00,168.50,2359.00,'2022-02-07 07:48:33','',''),(2650348,'1','197','1018',464,'Retail Sale Id 1641732',30166.66,0.00,0.00,58.69,821.66,'2022-02-07 07:51:16','',''),(2650349,'1','197','1018',464,'Retail Sale Id 1641733',115881.30,0.00,0.00,225.45,3156.30,'2022-02-07 07:52:02','',''),(2650350,'1','197','1018',464,'Return of Retail Sale Id 1641732',0.00,30166.66,58.69,0.00,-821.66,'2022-02-07 07:53:32','',''),(2650351,'1','197','1018',464,'Retail Sale Id 1641734',29909.66,0.00,0.00,58.19,814.66,'2022-02-07 07:55:23','',''),(2650352,'1','197','1018',464,'Distributed to ANCLE PRTE for sales id:350275',35240.00,0.00,0.00,70.48,0.00,'2022-02-07 08:07:41','',''),(2650353,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2500000.00,5000.00,0.00,0.00,'2022-02-07 08:10:34','',''),(2650354,'1','197',NULL,464,'Reception corrector for bridging 132588',0.00,0.00,0.00,5000.00,0.00,'2022-02-07 08:12:26','',''),(2650355,'1','197','1018',464,'Received from bridging 132588',0.00,0.00,5000.00,0.00,0.00,'2022-02-07 08:12:26','',''),(2650356,'1','197','1018',464,'Retail Sale Id 1641735',412640.64,0.00,0.00,726.48,49400.64,'2022-02-07 21:25:33','',''),(2650357,'1','197','1018',464,'Retail Sale Id 1641736',128500.00,0.00,0.00,250.00,3500.00,'2022-02-07 21:26:58','',''),(2650358,'1','197','1018',464,'Retail Sale Id 1641737',154200.00,0.00,0.00,300.00,4200.00,'2022-02-07 21:29:02','',''),(2650359,'1','197','1018',464,'Retail Sale Id 1641738',199432.00,0.00,0.00,388.00,5432.00,'2022-02-07 21:31:33','',''),(2650360,'1','197','1018',464,'Retail Sale Id 1641739',5100.64,0.00,0.00,8.98,610.64,'2022-02-08 08:50:42','',''),(2650361,'1','197','1018',464,'Retail Sale Id 1641740',169620.00,0.00,0.00,330.00,4620.00,'2022-02-08 20:37:07','',''),(2650362,'1','197','1018',464,'Retail Sale Id 1641741',184428.34,0.00,0.00,358.81,5023.34,'2022-02-08 20:38:00','',''),(2650363,'1','197','1018',464,'Retail Sale Id 1641742',113600.00,0.00,0.00,200.00,13600.00,'2022-02-08 20:38:31','',''),(2650364,'1','197','1018',464,'Retail Sale Id 1641743',113600.00,0.00,0.00,200.00,13600.00,'2022-02-08 20:39:20','',''),(2650365,'1','197','1018',464,'Retail Sale Id 1641744',95719.36,0.00,0.00,168.52,11459.36,'2022-02-08 20:42:13','',''),(2650366,'1','197','1018',464,'Return of Retail Sale Id 1641741',0.00,184428.34,358.81,0.00,-5023.34,'2022-02-08 20:43:40','',''),(2650367,'1','197','1018',464,'Retail Sale Id 1641745',169008.34,0.00,0.00,328.81,4603.34,'2022-02-08 20:45:33','',''),(2650368,'1','197','1018',464,'Retail Sale Id 1641746',7100.00,0.00,0.00,12.50,850.00,'2022-02-09 12:55:03','',''),(2650369,'1','197','1018',464,'Retail Sale Id 1641747',142635.00,0.00,0.00,277.50,3885.00,'2022-02-09 12:56:33','',''),(2650370,'1','197','1018',464,'Retail Sale Id 1641748',7100.00,0.00,0.00,12.50,850.00,'2022-02-09 12:59:27','',''),(2650371,'1','197','1018',464,'Retail Sale Id 1641749',3498.88,0.00,0.00,6.16,418.88,'2022-02-09 13:17:44','',''),(2650372,'1','197','1018',464,'Retail Sale Id 1641750',7100.00,0.00,0.00,12.50,850.00,'2022-02-09 13:19:00','',''),(2650373,'1','197','1018',464,'Retail Sale Id 1641752',7100.00,0.00,0.00,12.50,850.00,'2022-02-09 13:58:46','',''),(2650374,'1','197','1018',464,'Retail Sale Id 1641754',467200.00,0.00,0.00,912.50,10950.00,'2022-02-09 15:01:02','',''),(2650375,'1','197','1018',464,'Retail Sale Id 1641755',154200.00,0.00,0.00,300.00,4200.00,'2022-02-09 15:04:50','',''),(2650376,'1','197','1018',464,'Retail Sale Id 1641756',136703.44,0.00,0.00,265.96,3723.44,'2022-02-09 15:06:10','',''),(2650377,'1','197','1018',464,'Retail Sale Id 1641757',127697.76,0.00,0.00,224.82,15287.76,'2022-02-09 15:09:27','',''),(2650378,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350276',31140.00,0.00,0.00,62.28,0.00,'2022-02-09 18:23:09','',''),(2650379,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2540000.00,5080.00,0.00,0.00,'2022-02-09 21:58:08','',''),(2650380,'1','197',NULL,464,'Reception corrector for bridging 132589',0.00,0.00,0.00,5080.00,0.00,'2022-02-09 22:00:55','',''),(2650381,'1','197','1018',464,'Received from bridging 132589',0.00,0.00,5080.00,0.00,0.00,'2022-02-09 22:00:55','',''),(2650382,'1','197','1018',464,'Retail Sale Id 1641758',33994.80,0.00,0.00,59.85,4069.80,'2022-02-09 22:05:28','',''),(2650383,'1','197','1018',464,'Retail Sale Id 1641759',32125.00,0.00,0.00,62.50,875.00,'2022-02-09 22:06:26','',''),(2650384,'1','197','1018',464,'Retail Sale Id 1641760',1499.52,0.00,0.00,2.64,179.52,'2022-02-10 09:37:19','',''),(2650385,'1','197','1018',464,'Retail Sale Id 1641761',230000.24,0.00,0.00,404.93,27535.24,'2022-02-10 22:25:39','',''),(2650386,'1','197','1018',464,'Retail Sale Id 1641763',154200.00,0.00,0.00,300.00,4200.00,'2022-02-10 22:27:10','',''),(2650387,'1','197','1018',464,'Retail Sale Id 1641764',179540.20,0.00,0.00,349.30,4890.20,'2022-02-10 22:28:33','',''),(2650388,'1','197','1018',464,'Retail Sale Id 1641765',3498.88,0.00,0.00,6.16,418.88,'2022-02-11 12:56:16','',''),(2650389,'1','197','1018',464,'Retail Sale Id 1641766',14200.00,0.00,0.00,25.00,1700.00,'2022-02-11 13:43:35','',''),(2650390,'1','197','1018',464,'Retail Sale Id 1641767',3498.88,0.00,0.00,6.16,418.88,'2022-02-11 15:20:54','',''),(2650391,'1','197','1018',464,'Retail Sale Id 1641768',51400.00,0.00,0.00,100.00,1400.00,'2022-02-11 15:52:31','',''),(2650392,'1','197','1018',464,'Retail Sale Id 1641769',7100.00,0.00,0.00,12.50,850.00,'2022-02-11 15:56:52','',''),(2650393,'1','197','1018',464,'Retail Sale Id 1641770',1800.56,0.00,0.00,3.17,215.56,'2022-02-11 16:01:03','',''),(2650394,'1','197','1018',464,'Retail Sale Id 1641771',573571.50,0.00,0.00,1124.65,11246.50,'2022-02-11 16:05:23','',''),(2650395,'1','197','1018',464,'Retail Sale Id 1641772',384000.00,0.00,0.00,750.00,9000.00,'2022-02-11 17:36:15','',''),(2650396,'1','197','1018',464,'Retail Sale Id 1641773',999.68,0.00,0.00,1.76,119.68,'2022-02-11 17:36:44','',''),(2650397,'1','197','1018',464,'Retail Sale Id 1641774',51400.00,0.00,0.00,100.00,1400.00,'2022-02-11 22:31:50','',''),(2650398,'1','197','1018',464,'Retail Sale Id 1641775',140286.02,0.00,0.00,272.93,3821.02,'2022-02-11 22:32:53','',''),(2650399,'1','197','1018',464,'Retail Sale Id 1641776',361503.60,0.00,0.00,636.45,43278.60,'2022-02-11 22:43:22','',''),(2650400,'1','197','1018',464,'Retail Sale Id 1641777',48865.04,0.00,0.00,86.03,5850.04,'2022-02-12 21:42:42','',''),(2650401,'1','197','1018',464,'Retail Sale Id 1641778',116633.60,0.00,0.00,227.80,2733.60,'2022-02-12 21:43:41','',''),(2650402,'1','197','1018',464,'Retail Sale Id 1641779',28270.00,0.00,0.00,55.00,770.00,'2022-02-12 21:44:33','',''),(2650403,'1','197','1018',464,'Distributed to ANCLE PRTE for sales id:350277',246580.00,0.00,0.00,493.16,0.00,'2022-02-12 22:02:47','',''),(2650404,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2390000.00,4780.00,0.00,0.00,'2022-02-12 22:06:02','',''),(2650405,'1','197',NULL,464,'Reception corrector for bridging 132590',0.00,0.00,0.00,4780.00,0.00,'2022-02-12 22:07:37','',''),(2650406,'1','197','1018',464,'Received from bridging 132590',0.00,0.00,4780.00,0.00,0.00,'2022-02-12 22:07:37','',''),(2650407,'1','197','1018',464,'Retail Sale Id 1641780',7100.00,0.00,0.00,12.50,850.00,'2022-02-13 08:02:37','',''),(2650408,'1','197','1018',464,'Retail Sale Id 1641781',0.00,0.00,0.00,0.00,0.00,'2022-02-13 08:09:15','',''),(2650409,'1','197','1018',464,'Retail Sale Id 1641782',51400.00,0.00,0.00,100.00,1400.00,'2022-02-13 08:12:27','',''),(2650410,'1','197','1018',464,'Retail Sale Id 1641783',2902.48,0.00,0.00,5.11,347.48,'2022-02-13 08:21:01','',''),(2650411,'1','197','1018',464,'Retail Sale Id 1641784',435456.00,0.00,0.00,850.50,10206.00,'2022-02-13 08:26:09','',''),(2650412,'1','197','1018',464,'Retail Sale Id 1641785',2902.48,0.00,0.00,5.11,347.48,'2022-02-13 09:40:15','',''),(2650413,'1','197','1018',464,'Retail Sale Id 1641786',5680.00,0.00,0.00,10.00,680.00,'2022-02-13 09:45:37','',''),(2650414,'1','197','1018',464,'Retail Sale Id 1641787',14200.00,0.00,0.00,25.00,1700.00,'2022-02-13 09:57:13','',''),(2650415,'1','197','1018',464,'Retail Sale Id 1641788',14200.00,0.00,0.00,25.00,1700.00,'2022-02-13 12:04:03','',''),(2650416,'1','197','1018',464,'Retail Sale Id 1641789',800.88,0.00,0.00,1.41,95.88,'2022-02-13 12:07:27','',''),(2650417,'1','197','1018',464,'Retail Sale Id 1641790',128500.00,0.00,0.00,250.00,3500.00,'2022-02-13 15:18:18','',''),(2650418,'1','197','1018',464,'Retail Sale Id 1641791',4498.56,0.00,0.00,7.92,538.56,'2022-02-13 17:17:45','',''),(2650419,'1','197','1018',464,'Retail Sale Id 1641792',2902.48,0.00,0.00,5.11,347.48,'2022-02-13 17:18:18','',''),(2650420,'1','197','1018',464,'Retail Sale Id 1641793',1999.36,0.00,0.00,3.52,239.36,'2022-02-13 17:26:32','',''),(2650421,'1','197','1018',464,'Retail Sale Id 1641794',2902.48,0.00,0.00,5.11,347.48,'2022-02-13 17:29:42','',''),(2650422,'1','197','1018',464,'Retail Sale Id 1641795',6600.16,0.00,0.00,11.62,790.16,'2022-02-13 18:11:17','',''),(2650423,'1','197','1018',464,'Retail Sale Id 1641796',7100.00,0.00,0.00,12.50,850.00,'2022-02-13 18:18:51','',''),(2650424,'1','197','1018',464,'Retail Sale Id 1641797',7100.00,0.00,0.00,12.50,850.00,'2022-02-13 18:19:43','',''),(2650425,'1','197','1018',464,'Retail Sale Id 1641798',5680.00,0.00,0.00,10.00,680.00,'2022-02-13 18:20:58','',''),(2650426,'1','197','1018',464,'Retail Sale Id 1641798',7100.00,0.00,0.00,12.50,850.00,'2022-02-13 18:20:58','',''),(2650427,'1','197','1018',464,'Retail Sale Id 1641798',14200.00,0.00,0.00,25.00,1700.00,'2022-02-13 18:20:58','',''),(2650428,'1','197','1018',464,'Retail Sale Id 1641799',257000.00,0.00,0.00,500.00,7000.00,'2022-02-13 19:22:59','',''),(2650429,'1','197','1018',464,'Retail Sale Id 1641800',257000.00,0.00,0.00,500.00,7000.00,'2022-02-13 19:24:10','',''),(2650430,'1','197','1018',464,'Return of Retail Sale Id 1641782',0.00,51400.00,100.00,0.00,-1400.00,'2022-02-13 19:26:53','',''),(2650431,'1','197','1018',464,'Retail Sale Id 1641801',186278.74,0.00,0.00,362.41,5073.74,'2022-02-13 19:29:15','',''),(2650432,'1','197','1018',464,'Retail Sale Id 1641802',315518.32,0.00,0.00,555.49,37773.32,'2022-02-13 19:31:10','',''),(2650433,'1','197','1018',464,'Retail Sale Id 1641803',214715.36,0.00,0.00,378.02,25705.36,'2022-02-14 21:05:31','',''),(2650434,'1','197','1018',464,'Retail Sale Id 1641804',77100.00,0.00,0.00,150.00,2100.00,'2022-02-14 21:06:28','',''),(2650435,'1','197','1018',464,'Retail Sale Id 1641805',128500.00,0.00,0.00,250.00,3500.00,'2022-02-14 21:08:17','',''),(2650436,'1','197','1018',464,'Retail Sale Id 1641806',240567.42,0.00,0.00,468.03,6552.42,'2022-02-14 21:09:38','',''),(2650437,'1','197','1018',464,'Retail Sale Id 1641807',7100.00,0.00,0.00,12.50,850.00,'2022-02-15 07:48:13','',''),(2650438,'1','197','1018',464,'Retail Sale Id 1641809',7100.00,0.00,0.00,12.50,850.00,'2022-02-15 07:50:44','',''),(2650439,'1','197','1018',464,'Retail Sale Id 1641810',999.68,0.00,0.00,1.76,119.68,'2022-02-15 07:51:21','',''),(2650440,'1','197','1018',464,'Retail Sale Id 1641811',11360.00,0.00,0.00,20.00,1360.00,'2022-02-15 08:02:57','',''),(2650441,'1','197','1018',464,'Return of Retail Sale Id 1641811',0.00,11360.00,20.00,0.00,-1360.00,'2022-02-15 12:05:40','',''),(2650442,'1','197','1018',464,'Retail Sale Id 1641812',6425.00,0.00,0.00,12.50,175.00,'2022-02-15 12:06:20','',''),(2650443,'1','197','1018',464,'Retail Sale Id 1641813',3487.52,0.00,0.00,6.14,417.52,'2022-02-15 12:07:41','',''),(2650444,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350278',140125.00,0.00,0.00,280.25,0.00,'2022-02-15 12:12:38','',''),(2650445,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2320000.00,4640.00,0.00,0.00,'2022-02-15 15:39:14','',''),(2650446,'1','197',NULL,464,'Reception corrector for bridging 132591',0.00,0.00,0.00,4640.00,0.00,'2022-02-15 15:40:59','',''),(2650447,'1','197','1018',464,'Received from bridging 132591',0.00,0.00,4640.00,0.00,0.00,'2022-02-15 15:40:59','',''),(2650448,'1','197','1018',464,'Retail Sale Id 1641814',416000.00,0.00,0.00,812.50,9750.00,'2022-02-15 15:46:46','',''),(2650449,'1','197','1018',464,'Retail Sale Id 1641816',276996.56,0.00,0.00,487.67,33161.56,'2022-02-15 23:02:28','',''),(2650450,'1','197','1018',464,'Retail Sale Id 1641817',102800.00,0.00,0.00,200.00,2800.00,'2022-02-15 23:03:46','',''),(2650451,'1','197','1018',464,'Retail Sale Id 1641818',103935.94,0.00,0.00,202.21,2830.94,'2022-02-15 23:05:01','',''),(2650452,'1','197','1018',464,'Retail Sale Id 1641819',28400.00,0.00,0.00,50.00,3400.00,'2022-02-16 13:31:36','',''),(2650453,'1','197','1018',464,'Retail Sale Id 1641820',157222.40,0.00,0.00,276.80,18822.40,'2022-02-17 00:15:21','',''),(2650454,'1','197','1018',464,'Retail Sale Id 1641821',173732.00,0.00,0.00,338.00,4732.00,'2022-02-17 00:16:52','',''),(2650455,'1','197','1018',464,'Retail Sale Id 1641822',128500.00,0.00,0.00,250.00,3500.00,'2022-02-17 09:31:16','',''),(2650456,'1','197','1018',464,'Retail Sale Id 1641823',0.00,0.00,0.00,0.00,0.00,'2022-02-17 09:32:43','',''),(2650457,'1','197','1018',464,'Retail Sale Id 1641824',7100.00,0.00,0.00,12.50,850.00,'2022-02-17 09:40:28','',''),(2650458,'1','197','1018',464,'Retail Sale Id 1641825',7100.00,0.00,0.00,12.50,850.00,'2022-02-17 09:55:37','',''),(2650459,'1','197','1018',464,'Retail Sale Id 1641825',7100.00,0.00,0.00,12.50,850.00,'2022-02-17 09:55:37','',''),(2650460,'1','197','1018',464,'Retail Sale Id 1641826',269163.84,0.00,0.00,473.88,32223.84,'2022-02-17 19:58:01','',''),(2650461,'1','197','1018',464,'Retail Sale Id 1641827',128500.00,0.00,0.00,250.00,3500.00,'2022-02-17 19:59:31','',''),(2650462,'1','197','1018',464,'Retail Sale Id 1641828',77100.00,0.00,0.00,150.00,2100.00,'2022-02-17 20:00:55','',''),(2650463,'1','197','1018',464,'Retail Sale Id 1641829',166993.46,0.00,0.00,324.89,4548.46,'2022-02-17 20:01:45','',''),(2650464,'1','197','1018',464,'Retail Sale Id 1641830',1800.56,0.00,0.00,3.17,215.56,'2022-02-18 08:35:19','',''),(2650465,'1','197','1018',464,'Retail Sale Id 1641830',3498.88,0.00,0.00,6.16,418.88,'2022-02-18 08:35:19','',''),(2650466,'1','197','1018',464,'Retail Sale Id 1641831',3498.88,0.00,0.00,6.16,418.88,'2022-02-18 10:01:43','',''),(2650467,'1','197','1018',464,'Retail Sale Id 1641831',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 10:01:43','',''),(2650468,'1','197','1018',464,'Retail Sale Id 1641832',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 10:02:18','',''),(2650469,'1','197','1018',464,'Retail Sale Id 1641833',1800.56,0.00,0.00,3.17,215.56,'2022-02-18 10:03:43','',''),(2650470,'1','197','1018',464,'Retail Sale Id 1641833',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 10:03:43','',''),(2650471,'1','197','1018',464,'Retail Sale Id 1641834',2999.04,0.00,0.00,5.28,359.04,'2022-02-18 10:14:04','',''),(2650472,'1','197','1018',464,'Retail Sale Id 1641835',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 11:06:46','',''),(2650473,'1','197','1018',464,'Retail Sale Id 1641836',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 11:08:01','',''),(2650474,'1','197','1018',464,'Retail Sale Id 1641837',52001.38,0.00,0.00,101.17,1416.38,'2022-02-18 11:11:53','',''),(2650475,'1','197','1018',464,'Retail Sale Id 1641838',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 11:13:21','',''),(2650476,'1','197','1018',464,'Retail Sale Id 1641839',21300.00,0.00,0.00,37.50,2550.00,'2022-02-18 11:14:55','',''),(2650477,'1','197','1018',464,'Retail Sale Id 1641840',3498.88,0.00,0.00,6.16,418.88,'2022-02-18 11:38:46','',''),(2650478,'1','197','1018',464,'Retail Sale Id 1641840',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 11:38:46','',''),(2650479,'1','197','1018',464,'Retail Sale Id 1641841',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 11:43:48','',''),(2650480,'1','197','1018',464,'Retail Sale Id 1641842',3498.88,0.00,0.00,6.16,418.88,'2022-02-18 11:50:33','',''),(2650481,'1','197','1018',464,'Retail Sale Id 1641843',3498.88,0.00,0.00,6.16,418.88,'2022-02-18 12:09:42','',''),(2650482,'1','197','1018',464,'Retail Sale Id 1641845',1800.56,0.00,0.00,3.17,215.56,'2022-02-18 12:42:03','',''),(2650483,'1','197','1018',464,'Retail Sale Id 1641846',1999.36,0.00,0.00,3.52,239.36,'2022-02-18 12:56:20','',''),(2650484,'1','197','1018',464,'Retail Sale Id 1641847',28270.00,0.00,0.00,55.00,770.00,'2022-02-18 12:57:07','',''),(2650485,'1','197','1018',464,'Retail Sale Id 1641848',7100.00,0.00,0.00,12.50,850.00,'2022-02-18 13:39:17','',''),(2650486,'1','197','1018',464,'Retail Sale Id 1641849',1800.56,0.00,0.00,3.17,215.56,'2022-02-18 14:02:48','',''),(2650487,'1','197','1018',464,'Retail Sale Id 1641850',1800.56,0.00,0.00,3.17,215.56,'2022-02-18 14:05:18','',''),(2650488,'1','197','1018',464,'Retail Sale Id 1641851',2999.04,0.00,0.00,5.28,359.04,'2022-02-18 14:18:59','',''),(2650489,'1','197','1018',464,'Retail Sale Id 1641852',46260.00,0.00,0.00,90.00,1260.00,'2022-02-18 14:50:10','',''),(2650490,'1','197','1018',464,'Retail Sale Id 1641853',2999.04,0.00,0.00,5.28,359.04,'2022-02-18 15:07:18','',''),(2650491,'1','197','1018',464,'Retail Sale Id 1641854',14200.00,0.00,0.00,25.00,1700.00,'2022-02-18 15:42:35','',''),(2650492,'1','197','1018',464,'Retail Sale Id 1641855',77100.00,0.00,0.00,150.00,2100.00,'2022-02-18 15:50:04','',''),(2650493,'1','197','1018',464,'Retail Sale Id 1641856',56800.00,0.00,0.00,100.00,6800.00,'2022-02-19 00:28:19','',''),(2650494,'1','197','1018',464,'Retail Sale Id 1641857',28036.48,0.00,0.00,49.36,3356.48,'2022-02-19 00:29:55','',''),(2650495,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,189013.22,367.73,0.00,0.00,'2022-02-19 07:28:52','',''),(2650496,'1','197',NULL,464,'Reception corrector for bridging 132592',0.00,0.00,0.00,367.73,0.00,'2022-02-19 07:33:07','',''),(2650497,'1','197','1018',464,'Received from bridging 132592',0.00,0.00,367.73,0.00,0.00,'2022-02-19 07:33:07','',''),(2650498,'1','197','1018',464,'Retail Sale Id 1641858',189013.22,0.00,0.00,367.73,0.00,'2022-02-19 07:35:42','',''),(2650499,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2448000.00,4800.00,0.00,0.00,'2022-02-19 09:22:05','',''),(2650500,'1','197',NULL,464,'Reception corrector for bridging 132593',0.00,0.00,0.00,4800.00,0.00,'2022-02-19 09:23:45','',''),(2650501,'1','197','1018',464,'Received from bridging 132593',0.00,0.00,4800.00,0.00,0.00,'2022-02-19 09:23:45','',''),(2650502,'1','197','1018',464,'Retail Sale Id 1641859',7100.00,0.00,0.00,12.50,725.00,'2022-02-19 09:25:34','',''),(2650503,'1','197','1018',464,'Retail Sale Id 1641860',1800.56,0.00,0.00,3.17,183.86,'2022-02-19 09:35:08','',''),(2650504,'1','197','1018',464,'Retail Sale Id 1641861',21300.00,0.00,0.00,37.50,2175.00,'2022-02-19 09:36:52','',''),(2650505,'1','197','1018',464,'Retail Sale Id 1641862',51400.00,0.00,0.00,100.00,400.00,'2022-02-19 09:39:37','',''),(2650506,'1','197','1018',464,'Retail Sale Id 1641863',4498.56,0.00,0.00,7.92,459.36,'2022-02-19 11:04:33','',''),(2650507,'1','197','1018',464,'Retail Sale Id 1641864',625260.00,0.00,0.00,1226.00,0.00,'2022-02-19 12:35:22','',''),(2650508,'1','197','1018',464,'Retail Sale Id 1641865',335188.16,0.00,0.00,590.12,34226.96,'2022-02-19 22:54:16','',''),(2650509,'1','197','1018',464,'Retail Sale Id 1641866',128500.00,0.00,0.00,250.00,1000.00,'2022-02-19 22:58:12','',''),(2650510,'1','197','1018',464,'Retail Sale Id 1641867',128500.00,0.00,0.00,250.00,1000.00,'2022-02-19 22:59:26','',''),(2650511,'1','197','1018',464,'Retail Sale Id 1641868',97737.10,0.00,0.00,190.15,760.60,'2022-02-19 23:00:13','',''),(2650512,'1','197','1018',464,'Retail Sale Id 1641869',14200.00,0.00,0.00,25.00,1450.00,'2022-02-20 12:35:03','',''),(2650513,'1','197','1018',464,'Retail Sale Id 1641870',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 12:35:43','',''),(2650514,'1','197','1018',464,'Retail Sale Id 1641871',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 12:37:10','',''),(2650515,'1','197','1018',464,'Retail Sale Id 1641872',77100.00,0.00,0.00,150.00,600.00,'2022-02-20 12:41:02','',''),(2650516,'1','197','1018',464,'Retail Sale Id 1641873',28400.00,0.00,0.00,50.00,2900.00,'2022-02-20 12:44:02','',''),(2650517,'1','197','1018',464,'Retail Sale Id 1641874',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 12:49:28','',''),(2650518,'1','197','1018',464,'Retail Sale Id 1641874',21300.00,0.00,0.00,37.50,2175.00,'2022-02-20 12:49:28','',''),(2650519,'1','197','1018',464,'Retail Sale Id 1641875',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 12:51:06','',''),(2650520,'1','197','1018',464,'Retail Sale Id 1641876',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 12:57:44','',''),(2650521,'1','197','1018',464,'Retail Sale Id 1641877',2999.04,0.00,0.00,5.28,306.24,'2022-02-20 12:58:26','',''),(2650522,'1','197','1018',464,'Retail Sale Id 1641878',3498.88,0.00,0.00,6.16,357.28,'2022-02-20 13:06:26','',''),(2650523,'1','197','1018',464,'Retail Sale Id 1641879',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 13:18:43','',''),(2650524,'1','197','1018',464,'Retail Sale Id 1641880',3498.88,0.00,0.00,6.16,357.28,'2022-02-20 13:22:12','',''),(2650525,'1','197','1018',464,'Retail Sale Id 1641881',147775.00,0.00,0.00,287.50,1150.00,'2022-02-20 13:35:03','',''),(2650526,'1','197','1018',464,'Retail Sale Id 1641882',568.00,0.00,0.00,1.00,58.00,'2022-02-20 13:41:09','',''),(2650527,'1','197','1018',464,'Retail Sale Id 1641883',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 13:42:08','',''),(2650528,'1','197','1018',464,'Retail Sale Id 1641885',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 13:42:54','',''),(2650529,'1','197','1018',464,'Retail Sale Id 1641886',5702.72,0.00,0.00,10.04,582.32,'2022-02-20 13:47:33','',''),(2650530,'1','197','1018',464,'Retail Sale Id 1641887',4901.84,0.00,0.00,8.63,500.54,'2022-02-20 14:17:33','',''),(2650531,'1','197','1018',464,'Retail Sale Id 1641888',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 14:28:52','',''),(2650532,'1','197','1018',464,'Retail Sale Id 1641889',134925.00,0.00,0.00,262.50,1050.00,'2022-02-20 14:52:23','',''),(2650533,'1','197','1018',464,'Retail Sale Id 1641890',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 15:09:23','',''),(2650534,'1','197','1018',464,'Retail Sale Id 1641891',10598.88,0.00,0.00,18.66,1082.28,'2022-02-20 15:16:14','',''),(2650535,'1','197','1018',464,'Retail Sale Id 1641892',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 15:28:41','',''),(2650536,'1','197','1018',464,'Retail Sale Id 1641893',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 15:57:47','',''),(2650537,'1','197','1018',464,'Retail Sale Id 1641894',1499.52,0.00,0.00,2.64,153.12,'2022-02-20 15:59:28','',''),(2650538,'1','197','1018',464,'Retail Sale Id 1641895',3498.88,0.00,0.00,6.16,357.28,'2022-02-20 16:00:09','',''),(2650539,'1','197','1018',464,'Retail Sale Id 1641896',1800.56,0.00,0.00,3.17,183.86,'2022-02-20 16:18:57','',''),(2650540,'1','197','1018',464,'Retail Sale Id 1641897',7100.00,0.00,0.00,12.50,725.00,'2022-02-20 16:23:08','',''),(2650541,'1','197','1018',464,'Retail Sale Id 1641898',139072.98,0.00,0.00,270.57,1082.28,'2022-02-20 19:44:14','',''),(2650542,'1','197','1018',464,'Retail Sale Id 1641899',132412.16,0.00,0.00,233.12,13520.96,'2022-02-20 19:47:21','',''),(2650543,'1','197','1018',464,'Retail Sale Id 1641900',999.68,0.00,0.00,1.76,102.08,'2022-02-21 08:17:29','',''),(2650544,'1','197','1018',464,'Retail Sale Id 1641901',14200.00,0.00,0.00,25.00,1450.00,'2022-02-21 08:18:10','',''),(2650545,'1','197','1018',464,'Retail Sale Id 1641902',2300.40,0.00,0.00,4.05,234.90,'2022-02-21 09:31:22','',''),(2650546,'1','197','1018',464,'Retail Sale Id 1641903',7100.00,0.00,0.00,12.50,725.00,'2022-02-21 09:32:20','',''),(2650547,'1','197','1018',464,'Retail Sale Id 1641904',4498.56,0.00,0.00,7.92,459.36,'2022-02-21 09:47:59','',''),(2650548,'1','197','1018',464,'Retail Sale Id 1641905',7100.00,0.00,0.00,12.50,725.00,'2022-02-21 09:51:11','',''),(2650549,'1','197','1018',464,'Retail Sale Id 1641906',4600.80,0.00,0.00,8.10,469.80,'2022-02-21 09:55:08','',''),(2650550,'1','197','1018',464,'Retail Sale Id 1641907',162010.64,0.00,0.00,285.23,16543.34,'2022-02-21 21:20:35','',''),(2650551,'1','197','1018',464,'Retail Sale Id 1641908',117700.86,0.00,0.00,228.99,915.96,'2022-02-21 21:23:12','',''),(2650552,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,139427.64,271.26,0.00,0.00,'2022-02-21 21:36:42','',''),(2650553,'1','197',NULL,464,'Reception corrector for bridging 132594',0.00,0.00,0.00,271.26,0.00,'2022-02-21 21:43:23','',''),(2650554,'1','197','1018',464,'Received from bridging 132594',0.00,0.00,271.26,0.00,0.00,'2022-02-21 21:43:23','',''),(2650555,'1','197','1018',464,'Retail Sale Id 1641909',139427.64,0.00,0.00,271.26,0.00,'2022-02-22 00:50:48','',''),(2650556,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2759100.00,5410.00,0.00,0.00,'2022-02-22 08:22:28','',''),(2650557,'1','197',NULL,464,'Reception corrector for bridging 132595',0.00,0.00,0.00,5410.00,0.00,'2022-02-22 08:24:38','',''),(2650558,'1','197','1018',464,'Received from bridging 132595',0.00,0.00,5410.00,0.00,0.00,'2022-02-22 08:24:38','',''),(2650559,'1','197','1018',464,'Retail Sale Id 1641910',14200.00,0.00,0.00,25.00,1450.00,'2022-02-22 08:26:52','',''),(2650560,'1','197','1018',464,'Retail Sale Id 1641911',3498.88,0.00,0.00,6.16,357.28,'2022-02-22 08:27:29','',''),(2650561,'1','197','1018',464,'Retail Sale Id 1641912',4998.40,0.00,0.00,8.80,510.40,'2022-02-22 08:28:01','',''),(2650562,'1','197','1018',464,'Retail Sale Id 1641913',7100.00,0.00,0.00,12.50,725.00,'2022-02-22 08:28:30','',''),(2650563,'1','197','1018',464,'Retail Sale Id 1641914',7100.00,0.00,0.00,12.50,725.00,'2022-02-22 10:05:54','',''),(2650564,'1','197','1018',464,'Retail Sale Id 1641915',3498.88,0.00,0.00,6.16,357.28,'2022-02-22 10:06:57','',''),(2650565,'1','197','1018',464,'Retail Sale Id 1641916',25700.00,0.00,0.00,50.00,200.00,'2022-02-22 10:07:36','',''),(2650566,'1','197','1018',464,'Retail Sale Id 1641917',1198.48,0.00,0.00,2.11,122.38,'2022-02-22 11:25:43','',''),(2650567,'1','197','1018',464,'Retail Sale Id 1641918',1198.48,0.00,0.00,2.11,122.38,'2022-02-22 11:26:58','',''),(2650568,'1','197','1018',464,'Retail Sale Id 1641919',7100.00,0.00,0.00,12.50,725.00,'2022-02-22 11:34:08','',''),(2650569,'1','197','1018',464,'Retail Sale Id 1641920',6532.00,0.00,0.00,11.50,667.00,'2022-02-22 11:38:08','',''),(2650570,'1','197','1018',464,'Retail Sale Id 1641921',0.00,0.00,0.00,0.00,0.00,'2022-02-22 11:44:45','',''),(2650571,'1','197','1018',464,'Retail Sale Id 1641923',7100.00,0.00,0.00,12.50,725.00,'2022-02-22 13:03:26','',''),(2650572,'1','197','1018',464,'Retail Sale Id 1641924',7100.00,0.00,0.00,12.50,725.00,'2022-02-22 18:02:35','',''),(2650573,'1','197','1018',464,'Retail Sale Id 1641925',28400.00,0.00,0.00,50.00,2900.00,'2022-02-22 18:13:29','',''),(2650574,'1','197','1018',464,'Retail Sale Id 1641926',3498.88,0.00,0.00,6.16,357.28,'2022-02-22 18:14:28','',''),(2650575,'1','197','1018',464,'Retail Sale Id 1641927',3498.88,0.00,0.00,6.16,357.28,'2022-02-22 18:17:30','',''),(2650576,'1','197','1018',464,'Retail Sale Id 1641928',1800.56,0.00,0.00,3.17,183.86,'2022-02-22 18:18:29','',''),(2650577,'1','197','1018',464,'Retail Sale Id 1641929',7100.00,0.00,0.00,12.50,725.00,'2022-02-22 18:27:19','',''),(2650578,'1','197','1018',464,'Retail Sale Id 1641930',274213.36,0.00,0.00,482.77,28000.66,'2022-02-22 19:49:37','',''),(2650579,'1','197','1018',464,'Retail Sale Id 1641931',102800.00,0.00,0.00,200.00,800.00,'2022-02-22 19:51:30','',''),(2650580,'1','197','1018',464,'Retail Sale Id 1641932',160116.14,0.00,0.00,311.51,1246.04,'2022-02-22 19:52:37','',''),(2650581,'1','197','1018',464,'Retail Sale Id 1641933',5680.00,0.00,0.00,10.00,580.00,'2022-02-23 07:48:55','',''),(2650582,'1','197','1018',464,'Retail Sale Id 1641934',102800.00,0.00,0.00,200.00,800.00,'2022-02-23 07:50:10','',''),(2650583,'1','197','1018',464,'Retail Sale Id 1641935',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 08:12:21','',''),(2650584,'1','197','1018',464,'Retail Sale Id 1641936',1499.52,0.00,0.00,2.64,153.12,'2022-02-23 08:13:44','',''),(2650585,'1','197','1018',464,'Retail Sale Id 1641937',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 08:14:56','',''),(2650586,'1','197','1018',464,'Retail Sale Id 1641938',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 08:20:26','',''),(2650587,'1','197','1018',464,'Retail Sale Id 1641939',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 09:31:00','',''),(2650588,'1','197','1018',464,'Retail Sale Id 1641940',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 09:52:50','',''),(2650589,'1','197','1018',464,'Retail Sale Id 1641941',2902.48,0.00,0.00,5.11,296.38,'2022-02-23 10:01:00','',''),(2650590,'1','197','1018',464,'Retail Sale Id 1641941',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 10:01:00','',''),(2650591,'1','197','1018',464,'Retail Sale Id 1641942',2902.48,0.00,0.00,5.11,296.38,'2022-02-23 10:03:50','',''),(2650592,'1','197','1018',464,'Retail Sale Id 1641943',7100.00,0.00,0.00,12.50,725.00,'2022-02-23 10:16:50','',''),(2650593,'1','197','1018',464,'Retail Sale Id 1641944',25700.00,0.00,0.00,50.00,200.00,'2022-02-23 10:17:52','',''),(2650594,'1','197','1018',464,'Retail Sale Id 1641945',3498.88,0.00,0.00,6.16,357.28,'2022-02-23 11:38:02','',''),(2650595,'1','197','1018',464,'Retail Sale Id 1641946',212875.04,0.00,0.00,374.78,21737.24,'2022-02-24 00:27:37','',''),(2650596,'1','197','1018',464,'Retail Sale Id 1641947',102800.00,0.00,0.00,200.00,800.00,'2022-02-24 00:29:11','',''),(2650597,'1','197','1018',464,'Retail Sale Id 1641948',102800.00,0.00,0.00,200.00,800.00,'2022-02-24 00:32:31','',''),(2650598,'1','197','1018',464,'Retail Sale Id 1641949',128063.10,0.00,0.00,249.15,996.60,'2022-02-24 00:34:19','',''),(2650599,'1','197','1018',464,'Retail Sale Id 1641950',255185.36,0.00,0.00,449.27,26057.66,'2022-02-24 19:42:32','',''),(2650600,'1','197','1018',464,'Retail Sale Id 1641951',154200.00,0.00,0.00,300.00,1200.00,'2022-02-24 19:43:57','',''),(2650601,'1','197','1018',464,'Retail Sale Id 1641952',198254.94,0.00,0.00,385.71,1542.84,'2022-02-24 19:45:20','',''),(2650602,'1','197','1018',464,'Retail Sale Id 1641953',128500.00,0.00,0.00,250.00,1000.00,'2022-02-25 11:33:33','',''),(2650603,'1','197','1018',464,'Retail Sale Id 1641954',208684.00,0.00,0.00,406.00,1624.00,'2022-02-25 11:35:02','',''),(2650604,'1','197','1018',464,'Retail Sale Id 1641955',45489.00,0.00,0.00,88.50,354.00,'2022-02-25 11:36:07','',''),(2650605,'1','197','1018',464,'Retail Sale Id 1641956',49416.00,0.00,0.00,87.00,5046.00,'2022-02-25 11:37:25','',''),(2650606,'1','197','1018',464,'Retail Sale Id 1641957',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 11:38:11','',''),(2650607,'1','197','1018',464,'Retail Sale Id 1641957',14200.00,0.00,0.00,25.00,1450.00,'2022-02-25 11:38:11','',''),(2650608,'1','197','1018',464,'Retail Sale Id 1641958',3498.88,0.00,0.00,6.16,357.28,'2022-02-25 11:43:26','',''),(2650609,'1','197','1018',464,'Retail Sale Id 1641959',10400.08,0.00,0.00,18.31,1061.98,'2022-02-25 11:45:10','',''),(2650610,'1','197','1018',464,'Retail Sale Id 1641960',3498.88,0.00,0.00,6.16,357.28,'2022-02-25 11:46:08','',''),(2650611,'1','197','1018',464,'Retail Sale Id 1641961',77100.00,0.00,0.00,150.00,600.00,'2022-02-25 11:52:04','',''),(2650612,'1','197','1018',464,'Retail Sale Id 1641962',100744.00,0.00,0.00,196.00,784.00,'2022-02-25 12:12:21','',''),(2650613,'1','197','1018',464,'Retail Sale Id 1641963',2902.48,0.00,0.00,5.11,296.38,'2022-02-25 12:16:37','',''),(2650614,'1','197','1018',464,'Retail Sale Id 1641964',3498.88,0.00,0.00,6.16,357.28,'2022-02-25 12:29:09','',''),(2650615,'1','197','1018',464,'Retail Sale Id 1641965',2902.48,0.00,0.00,5.11,296.38,'2022-02-25 12:42:11','',''),(2650616,'1','197','1018',464,'Retail Sale Id 1641966',1499.52,0.00,0.00,2.64,153.12,'2022-02-25 13:54:05','',''),(2650617,'1','197','1018',464,'Retail Sale Id 1641966',1499.52,0.00,0.00,2.64,153.12,'2022-02-25 13:54:05','',''),(2650618,'1','197','1018',464,'Retail Sale Id 1641966',1800.56,0.00,0.00,3.17,183.86,'2022-02-25 13:54:05','',''),(2650619,'1','197','1018',464,'Retail Sale Id 1641967',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 13:57:45','',''),(2650620,'1','197','1018',464,'Retail Sale Id 1641968',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 13:58:40','',''),(2650621,'1','197','1018',464,'Retail Sale Id 1641969',3498.88,0.00,0.00,6.16,357.28,'2022-02-25 14:13:30','',''),(2650622,'1','197','1018',464,'Retail Sale Id 1641970',3498.88,0.00,0.00,6.16,357.28,'2022-02-25 14:14:37','',''),(2650623,'1','197','1018',464,'Retail Sale Id 1641971',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 14:15:51','',''),(2650624,'1','197','1018',464,'Retail Sale Id 1641974',4998.40,0.00,0.00,8.80,510.40,'2022-02-25 14:17:06','',''),(2650625,'1','197','1018',464,'Retail Sale Id 1641975',27002.72,0.00,0.00,47.54,2757.32,'2022-02-25 14:25:01','',''),(2650626,'1','197','1018',464,'Retail Sale Id 1641976',4998.40,0.00,0.00,8.80,510.40,'2022-02-25 14:31:34','',''),(2650627,'1','197','1018',464,'Retail Sale Id 1641977',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 14:48:24','',''),(2650628,'1','197','1018',464,'Retail Sale Id 1641978',1499.52,0.00,0.00,2.64,153.12,'2022-02-25 14:49:31','',''),(2650629,'1','197','1018',464,'Retail Sale Id 1641979',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 14:55:38','',''),(2650630,'1','197','1018',464,'Retail Sale Id 1641980',7100.00,0.00,0.00,12.50,725.00,'2022-02-25 15:11:23','',''),(2650631,'1','197','1018',464,'Retail Sale Id 1641981',74226.24,0.00,0.00,130.68,7579.44,'2022-02-25 17:00:43','',''),(2650632,'1','197','1018',464,'Retail Sale Id 1641982',10449.62,0.00,0.00,20.33,81.32,'2022-02-25 17:02:33','',''),(2650633,'1','197','1018',464,'Distributed to NOBLE GAS for sales id:350279',31308.90,0.00,0.00,61.39,0.00,'2022-02-25 17:10:12','',''),(2650634,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2555000.00,5110.00,0.00,0.00,'2022-02-26 11:40:45','',''),(2650635,'1','197',NULL,464,'Reception corrector for bridging 132596',0.00,0.00,0.00,5110.00,0.00,'2022-02-26 11:42:08','',''),(2650636,'1','197','1018',464,'Received from bridging 132596',0.00,0.00,5110.00,0.00,0.00,'2022-02-26 11:42:08','',''),(2650637,'1','197','1018',464,'Retail Sale Id 1641983',51400.00,0.00,0.00,100.00,1400.00,'2022-02-26 11:44:16','',''),(2650638,'1','197','1018',464,'Retail Sale Id 1641984',53970.00,0.00,0.00,105.00,1470.00,'2022-02-26 11:45:37','',''),(2650639,'1','197','1018',464,'Retail Sale Id 1641985',3498.88,0.00,0.00,6.16,418.88,'2022-02-26 11:47:15','',''),(2650640,'1','197','1018',464,'Retail Sale Id 1641986',2902.48,0.00,0.00,5.11,347.48,'2022-02-26 12:00:52','',''),(2650641,'1','197','1018',464,'Retail Sale Id 1641987',3498.88,0.00,0.00,6.16,418.88,'2022-02-26 12:02:49','',''),(2650642,'1','197','1018',464,'Retail Sale Id 1641988',45440.00,0.00,0.00,80.00,5440.00,'2022-02-26 12:03:57','',''),(2650643,'1','197','1018',464,'Retail Sale Id 1641989',28989.60,0.00,0.00,56.40,789.60,'2022-02-26 12:04:54','',''),(2650644,'1','197','1018',464,'Retail Sale Id 1641990',14200.00,0.00,0.00,25.00,1700.00,'2022-02-26 12:05:28','',''),(2650645,'1','197','1018',464,'Retail Sale Id 1641991',35980.00,0.00,0.00,70.00,980.00,'2022-02-26 12:08:01','',''),(2650646,'1','197','1018',464,'Retail Sale Id 1641992',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 12:52:34','',''),(2650647,'1','197','1018',464,'Retail Sale Id 1641993',2902.48,0.00,0.00,5.11,347.48,'2022-02-26 13:07:02','',''),(2650648,'1','197','1018',464,'Retail Sale Id 1641994',2902.48,0.00,0.00,5.11,347.48,'2022-02-26 13:22:19','',''),(2650649,'1','197','1018',464,'Retail Sale Id 1641994',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 13:22:19','',''),(2650650,'1','197','1018',464,'Retail Sale Id 1641995',10002.48,0.00,0.00,17.61,1197.48,'2022-02-26 13:23:40','',''),(2650651,'1','197','1018',464,'Retail Sale Id 1641996',1499.52,0.00,0.00,2.64,179.52,'2022-02-26 13:28:05','',''),(2650652,'1','197','1018',464,'Retail Sale Id 1641997',2902.48,0.00,0.00,5.11,347.48,'2022-02-26 13:34:24','',''),(2650653,'1','197','1018',464,'Retail Sale Id 1641998',5140.00,0.00,0.00,10.00,140.00,'2022-02-26 13:43:22','',''),(2650654,'1','197','1018',464,'Retail Sale Id 1641999',498780.00,0.00,0.00,978.00,9780.00,'2022-02-26 13:44:51','',''),(2650655,'1','197','1018',464,'Retail Sale Id 1642000',3498.88,0.00,0.00,6.16,418.88,'2022-02-26 13:51:47','',''),(2650656,'1','197','1018',464,'Retail Sale Id 1642001',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 13:52:20','',''),(2650657,'1','197','1018',464,'Retail Sale Id 1642002',14200.00,0.00,0.00,25.00,1700.00,'2022-02-26 14:00:06','',''),(2650658,'1','197','1018',464,'Retail Sale Id 1642003',154200.00,0.00,0.00,300.00,4200.00,'2022-02-26 14:07:51','',''),(2650659,'1','197','1018',464,'Retail Sale Id 1642004',5140.00,0.00,0.00,10.00,140.00,'2022-02-26 14:09:21','',''),(2650660,'1','197','1018',464,'Retail Sale Id 1642005',14200.00,0.00,0.00,25.00,1700.00,'2022-02-26 15:08:40','',''),(2650661,'1','197','1018',464,'Retail Sale Id 1642006',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 16:34:00','',''),(2650662,'1','197','1018',464,'Retail Sale Id 1642007',125930.00,0.00,0.00,245.00,3430.00,'2022-02-26 17:00:52','',''),(2650663,'1','197','1018',464,'Retail Sale Id 1642008',108204.00,0.00,0.00,190.50,12954.00,'2022-02-26 17:01:41','',''),(2650664,'1','197','1018',464,'Retail Sale Id 1642009',1800.56,0.00,0.00,3.17,215.56,'2022-02-26 17:02:48','',''),(2650665,'1','197','1018',464,'Retail Sale Id 1642009',21300.00,0.00,0.00,37.50,2550.00,'2022-02-26 17:02:48','',''),(2650666,'1','197','1018',464,'Retail Sale Id 1642010',3498.88,0.00,0.00,6.16,418.88,'2022-02-26 17:08:28','',''),(2650667,'1','197','1018',464,'Retail Sale Id 1642011',1800.56,0.00,0.00,3.17,215.56,'2022-02-26 17:14:42','',''),(2650668,'1','197','1018',464,'Retail Sale Id 1642012',3498.88,0.00,0.00,6.16,418.88,'2022-02-26 17:36:39','',''),(2650669,'1','197','1018',464,'Retail Sale Id 1642012',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 17:36:39','',''),(2650670,'1','197','1018',464,'Retail Sale Id 1642013',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 17:37:17','',''),(2650671,'1','197','1018',464,'Retail Sale Id 1642014',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 17:40:49','',''),(2650672,'1','197','1018',464,'Retail Sale Id 1642015',2902.48,0.00,0.00,5.11,347.48,'2022-02-26 17:41:49','',''),(2650673,'1','197','1018',464,'Retail Sale Id 1642016',1499.52,0.00,0.00,2.64,179.52,'2022-02-26 17:57:12','',''),(2650674,'1','197','1018',464,'Retail Sale Id 1642017',2902.48,0.00,0.00,5.11,347.48,'2022-02-26 18:02:52','',''),(2650675,'1','197','1018',464,'Retail Sale Id 1642018',1800.56,0.00,0.00,3.17,215.56,'2022-02-26 18:03:38','',''),(2650676,'1','197','1018',464,'Retail Sale Id 1642019',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 18:12:32','',''),(2650677,'1','197','1018',464,'Retail Sale Id 1642020',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 18:17:23','',''),(2650678,'1','197','1018',464,'Retail Sale Id 1642022',568.00,0.00,0.00,1.00,68.00,'2022-02-26 18:34:08','',''),(2650679,'1','197','1018',464,'Retail Sale Id 1642022',3498.88,0.00,0.00,6.16,418.88,'2022-02-26 18:34:08','',''),(2650680,'1','197','1018',464,'Retail Sale Id 1642023',152349.60,0.00,0.00,296.40,4149.60,'2022-02-26 19:58:24','',''),(2650681,'1','197','1018',464,'Retail Sale Id 1642024',21300.00,0.00,0.00,37.50,2550.00,'2022-02-26 19:59:57','',''),(2650682,'1','197','1018',464,'Retail Sale Id 1642025',14200.00,0.00,0.00,25.00,1700.00,'2022-02-26 20:00:34','',''),(2650683,'1','197','1018',464,'Retail Sale Id 1642026',7100.00,0.00,0.00,12.50,850.00,'2022-02-26 20:00:55','',''),(2650684,'1','197','1018',464,'Retail Sale Id 1642027',4526.96,0.00,0.00,7.97,541.96,'2022-02-26 20:01:44','',''),(2650685,'1','197','1018',464,'Retail Sale Id 1642028',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 11:29:22','',''),(2650686,'1','197','1018',464,'Retail Sale Id 1642029',21300.00,0.00,0.00,37.50,2550.00,'2022-02-27 11:46:45','',''),(2650687,'1','197','1018',464,'Retail Sale Id 1642030',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 11:48:42','',''),(2650688,'1','197','1018',464,'Retail Sale Id 1642031',1800.56,0.00,0.00,3.17,215.56,'2022-02-27 12:06:34','',''),(2650689,'1','197','1018',464,'Retail Sale Id 1642032',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 12:23:20','',''),(2650690,'1','197','1018',464,'Retail Sale Id 1642033',6816.00,0.00,0.00,12.00,816.00,'2022-02-27 12:43:12','',''),(2650691,'1','197','1018',464,'Retail Sale Id 1642034',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 12:52:20','',''),(2650692,'1','197','1018',464,'Retail Sale Id 1642035',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 12:53:51','',''),(2650693,'1','197','1018',464,'Retail Sale Id 1642036',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 12:56:00','',''),(2650694,'1','197','1018',464,'Retail Sale Id 1642037',9099.36,0.00,0.00,16.02,1089.36,'2022-02-27 13:43:26','',''),(2650695,'1','197','1018',464,'Retail Sale Id 1642038',5680.00,0.00,0.00,10.00,680.00,'2022-02-27 13:44:36','',''),(2650696,'1','197','1018',464,'Retail Sale Id 1642039',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 13:54:32','',''),(2650697,'1','197','1018',464,'Retail Sale Id 1642040',1800.56,0.00,0.00,3.17,215.56,'2022-02-27 13:55:17','',''),(2650698,'1','197','1018',464,'Retail Sale Id 1642041',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 13:56:19','',''),(2650699,'1','197','1018',464,'Retail Sale Id 1642042',6997.76,0.00,0.00,12.32,837.76,'2022-02-27 14:19:53','',''),(2650700,'1','197','1018',464,'Retail Sale Id 1642043',602.08,0.00,0.00,1.06,72.08,'2022-02-27 14:41:08','',''),(2650701,'1','197','1018',464,'Retail Sale Id 1642044',2902.48,0.00,0.00,5.11,347.48,'2022-02-27 14:42:02','',''),(2650702,'1','197','1018',464,'Retail Sale Id 1642045',3498.88,0.00,0.00,6.16,418.88,'2022-02-27 14:52:13','',''),(2650703,'1','197','1018',464,'Retail Sale Id 1642046',3498.88,0.00,0.00,6.16,418.88,'2022-02-27 17:56:12','',''),(2650704,'1','197','1018',464,'Retail Sale Id 1642047',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 17:57:14','',''),(2650705,'1','197','1018',464,'Retail Sale Id 1642048',7100.00,0.00,0.00,12.50,850.00,'2022-02-27 17:57:54','',''),(2650706,'1','197','1018',464,'Retail Sale Id 1642049',361216.00,0.00,0.00,705.50,8466.00,'2022-02-27 17:59:00','',''),(2650707,'1','197','1018',464,'Retail Sale Id 1642050',14001.36,0.00,0.00,27.24,381.36,'2022-02-27 18:14:45','',''),(2650708,'1','197','1018',464,'Retail Sale Id 1642053',34237.54,0.00,0.00,66.61,932.54,'2022-02-27 19:14:38','',''),(2650709,'1','197','1018',464,'Retail Sale Id 1642054',163515.84,0.00,0.00,287.88,19575.84,'2022-02-27 19:16:45','',''),(2650710,'1','197','1018',464,'Retail Sale Id 1642055',138780.00,0.00,0.00,270.00,3780.00,'2022-02-28 08:15:17','',''),(2650711,'1','197','1018',464,'Retail Sale Id 1642056',1499.52,0.00,0.00,2.64,179.52,'2022-02-28 08:36:35','',''),(2650712,'1','197','1018',464,'Retail Sale Id 1642057',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 08:48:00','',''),(2650713,'1','197','1018',464,'Retail Sale Id 1642058',33502.52,0.00,0.00,65.18,912.52,'2022-02-28 09:35:08','',''),(2650714,'1','197','1018',464,'Retail Sale Id 1642059',2902.48,0.00,0.00,5.11,347.48,'2022-02-28 09:38:15','',''),(2650715,'1','197','1018',464,'Retail Sale Id 1642060',23299.36,0.00,0.00,41.02,2789.36,'2022-02-28 11:00:57','',''),(2650716,'1','197','1018',464,'Retail Sale Id 1642061',115650.00,0.00,0.00,225.00,3150.00,'2022-02-28 11:02:14','',''),(2650717,'1','197','1018',464,'Retail Sale Id 1642062',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 11:02:50','',''),(2650718,'1','197','1018',464,'Retail Sale Id 1642063',3498.88,0.00,0.00,6.16,418.88,'2022-02-28 11:10:34','',''),(2650719,'1','197','1018',464,'Retail Sale Id 1642064',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 11:48:06','',''),(2650720,'1','197','1018',464,'Retail Sale Id 1642065',38550.00,0.00,0.00,75.00,1050.00,'2022-02-28 11:54:03','',''),(2650721,'1','197','1018',464,'Retail Sale Id 1642066',28400.00,0.00,0.00,50.00,3400.00,'2022-02-28 12:58:05','',''),(2650722,'1','197','1018',464,'Retail Sale Id 1642067',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 12:59:05','',''),(2650723,'1','197','1018',464,'Retail Sale Id 1642068',2902.48,0.00,0.00,5.11,347.48,'2022-02-28 13:00:07','',''),(2650724,'1','197','1018',464,'Retail Sale Id 1642069',38550.00,0.00,0.00,75.00,1050.00,'2022-02-28 13:08:00','',''),(2650725,'1','197','1018',464,'Return of Retail Sale Id 1642058',0.00,33502.52,65.18,0.00,-912.52,'2022-02-28 16:49:44','',''),(2650726,'1','197','1018',464,'Retail Sale Id 1642070',19603.96,0.00,0.00,38.14,533.96,'2022-02-28 16:51:12','',''),(2650727,'1','197','1018',464,'Retail Sale Id 1642071',28195.52,0.00,0.00,49.64,3375.52,'2022-02-28 16:52:43','',''),(2650728,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350280',20995.00,0.00,0.00,41.99,0.00,'2022-02-28 16:58:59','',''),(2650729,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2485000.00,4970.00,0.00,0.00,'2022-02-28 17:00:54','',''),(2650730,'1','197',NULL,464,'Reception corrector for bridging 132597',0.00,0.00,0.00,4970.00,0.00,'2022-02-28 17:02:10','',''),(2650731,'1','197','1018',464,'Received from bridging 132597',0.00,0.00,4970.00,0.00,0.00,'2022-02-28 17:02:10','',''),(2650732,'1','197','1018',464,'Retail Sale Id 1642072',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 17:43:24','',''),(2650733,'1','197','1018',464,'Retail Sale Id 1642073',84296.00,0.00,0.00,164.00,2296.00,'2022-02-28 17:49:59','',''),(2650734,'1','197','1018',464,'Retail Sale Id 1642074',51400.00,0.00,0.00,100.00,1400.00,'2022-02-28 17:50:41','',''),(2650735,'1','197','1018',464,'Retail Sale Id 1642077',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 18:07:04','',''),(2650736,'1','197','1018',464,'Retail Sale Id 1642078',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 18:09:21','',''),(2650737,'1','197','1018',464,'Retail Sale Id 1642079',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 18:11:40','',''),(2650738,'1','197','1018',464,'Retail Sale Id 1642080',7100.00,0.00,0.00,12.50,850.00,'2022-02-28 18:17:12','',''),(2650739,'1','197','1018',464,'Retail Sale Id 1642081',28400.00,0.00,0.00,50.00,3400.00,'2022-02-28 19:23:21','',''),(2650740,'1','197','1018',464,'Retail Sale Id 1642082',28400.00,0.00,0.00,50.00,3400.00,'2022-02-28 19:24:11','',''),(2650741,'1','197','1018',464,'Retail Sale Id 1642083',186599.36,0.00,0.00,328.52,22339.36,'2022-02-28 19:34:42','',''),(2650742,'1','197','1018',464,'Retail Sale Id 1642084',128500.00,0.00,0.00,250.00,3500.00,'2022-02-28 19:37:42','',''),(2650743,'1','197','1018',464,'Retail Sale Id 1642085',128510.28,0.00,0.00,250.02,3500.28,'2022-02-28 19:38:59','',''),(2650744,'1','197','1018',464,'Retail Sale Id 1642086',11360.00,0.00,0.00,20.00,1360.00,'2022-03-01 09:33:46','',''),(2650745,'1','197','1018',464,'Retail Sale Id 1642087',20288.96,0.00,0.00,35.72,2428.96,'2022-03-01 09:35:27','',''),(2650746,'1','197','1018',464,'Retail Sale Id 1642088',24158.00,0.00,0.00,47.00,658.00,'2022-03-01 09:52:23','',''),(2650747,'1','197','1018',464,'Retail Sale Id 1642090',14200.00,0.00,0.00,25.00,1700.00,'2022-03-01 09:57:15','',''),(2650748,'1','197','1018',464,'Retail Sale Id 1642091',7100.00,0.00,0.00,12.50,850.00,'2022-03-01 10:35:31','',''),(2650749,'1','197','1018',464,'Retail Sale Id 1642093',0.00,0.00,0.00,0.00,0.00,'2022-03-01 10:55:03','',''),(2650750,'1','197','1018',464,'Retail Sale Id 1642094',7100.00,0.00,0.00,12.50,850.00,'2022-03-01 11:10:47','',''),(2650751,'1','197','1018',464,'Retail Sale Id 1642095',2800.24,0.00,0.00,4.93,335.24,'2022-03-01 11:12:16','',''),(2650752,'1','197','1018',464,'Retail Sale Id 1642092',14200.00,0.00,0.00,25.00,1700.00,'2022-03-01 11:15:28','',''),(2650753,'1','197','1018',464,'Retail Sale Id 1642096',160368.00,0.00,0.00,312.00,4368.00,'2022-03-01 11:17:42','',''),(2650754,'1','197','1018',464,'Retail Sale Id 1642097',151630.00,0.00,0.00,295.00,4130.00,'2022-03-01 11:33:40','',''),(2650755,'1','197','1018',464,'Retail Sale Id 1642098',22497.78,0.00,0.00,43.77,612.78,'2022-03-01 12:05:44','',''),(2650756,'1','197','1018',464,'Retail Sale Id 1642099',113080.00,0.00,0.00,220.00,3080.00,'2022-03-01 12:18:03','',''),(2650757,'1','197','1018',464,'Retail Sale Id 1642100',23130.00,0.00,0.00,45.00,630.00,'2022-03-01 12:19:18','',''),(2650758,'1','197','1018',464,'Retail Sale Id 1642101',66820.00,0.00,0.00,130.00,1820.00,'2022-03-01 12:33:47','',''),(2650759,'1','197','1018',464,'Retail Sale Id 1642102',7100.00,0.00,0.00,12.50,850.00,'2022-03-01 12:49:32','',''),(2650760,'1','197','1018',464,'Retail Sale Id 1642103',1800.56,0.00,0.00,3.17,215.56,'2022-03-01 12:51:32','',''),(2650761,'1','197','1018',464,'Retail Sale Id 1642104',12850.00,0.00,0.00,25.00,350.00,'2022-03-01 13:01:24','',''),(2650762,'1','197','1018',464,'Retail Sale Id 1642105',3498.88,0.00,0.00,6.16,418.88,'2022-03-01 15:04:12','',''),(2650763,'1','197','1018',464,'Retail Sale Id 1642105',7100.00,0.00,0.00,12.50,850.00,'2022-03-01 15:04:12','',''),(2650764,'1','197','1018',464,'Retail Sale Id 1642106',3498.88,0.00,0.00,6.16,418.88,'2022-03-01 15:46:47','',''),(2650765,'1','197','1018',464,'Retail Sale Id 1642106',7100.00,0.00,0.00,12.50,850.00,'2022-03-01 15:46:47','',''),(2650766,'1','197','1018',464,'Retail Sale Id 1642107',266534.00,0.00,0.00,469.25,31909.00,'2022-03-01 20:36:06','',''),(2650767,'1','197','1018',464,'Retail Sale Id 1642108',357000.00,0.00,0.00,700.00,7000.00,'2022-03-01 20:37:12','',''),(2650768,'1','197','1018',464,'Retail Sale Id 1642109',128500.00,0.00,0.00,250.00,3500.00,'2022-03-01 20:38:55','',''),(2650769,'1','197','1018',464,'Retail Sale Id 1642110',214641.26,0.00,0.00,417.59,5846.26,'2022-03-01 20:40:26','',''),(2650770,'1','197','1018',464,'Retail Sale Id 1642111',3498.88,0.00,0.00,6.16,418.88,'2022-03-02 09:02:39','',''),(2650771,'1','197','1018',464,'Retail Sale Id 1642112',7100.00,0.00,0.00,12.50,850.00,'2022-03-02 09:11:34','',''),(2650772,'1','197','1018',464,'Retail Sale Id 1642113',10002.48,0.00,0.00,17.61,1197.48,'2022-03-02 09:13:00','',''),(2650773,'1','197','1018',464,'Retail Sale Id 1642114',5140.00,0.00,0.00,10.00,140.00,'2022-03-02 09:13:41','',''),(2650774,'1','197','1018',464,'Retail Sale Id 1642115',7100.00,0.00,0.00,12.50,850.00,'2022-03-02 09:35:04','',''),(2650775,'1','197','1018',464,'Retail Sale Id 1642116',5680.00,0.00,0.00,10.00,680.00,'2022-03-02 09:50:15','',''),(2650776,'1','197','1018',464,'Retail Sale Id 1642117',2499.20,0.00,0.00,4.40,299.20,'2022-03-02 10:08:28','',''),(2650777,'1','197','1018',464,'Retail Sale Id 1642119',5998.08,0.00,0.00,10.56,718.08,'2022-03-02 11:13:20','',''),(2650778,'1','197','1018',464,'Retail Sale Id 1642120',2902.48,0.00,0.00,5.11,347.48,'2022-03-02 11:15:22','',''),(2650779,'1','197','1018',464,'Retail Sale Id 1642120',2902.48,0.00,0.00,5.11,347.48,'2022-03-02 11:15:22','',''),(2650780,'1','197','1018',464,'Retail Sale Id 1642120',7100.00,0.00,0.00,12.50,850.00,'2022-03-02 11:15:22','',''),(2650781,'1','197','1018',464,'Retail Sale Id 1642121',3998.72,0.00,0.00,7.04,478.72,'2022-03-02 11:38:36','',''),(2650782,'1','197','1018',464,'Retail Sale Id 1642122',7100.00,0.00,0.00,12.50,850.00,'2022-03-02 12:09:30','',''),(2650783,'1','197','1018',464,'Retail Sale Id 1642123',35500.00,0.00,0.00,62.50,4250.00,'2022-03-02 12:36:25','',''),(2650784,'1','197','1018',464,'Retail Sale Id 1642124',7100.00,0.00,0.00,12.50,850.00,'2022-03-02 15:41:20','',''),(2650785,'1','197','1018',464,'Retail Sale Id 1642125',30840.00,0.00,0.00,60.00,840.00,'2022-03-02 17:45:14','',''),(2650786,'1','197','1018',464,'Retail Sale Id 1642126',100923.90,0.00,0.00,196.35,2748.90,'2022-03-02 17:46:22','',''),(2650787,'1','197','1018',464,'Retail Sale Id 1642127',18749.68,0.00,0.00,33.01,2244.68,'2022-03-02 17:51:54','',''),(2650788,'1','197','1018',464,'Retail Sale Id 1642128',96.56,0.00,0.00,0.17,11.56,'2022-03-02 17:55:11','',''),(2650789,'1','197','1018',464,'Distributed to MAN OF PEACE for sales id:350281',40595.00,0.00,0.00,81.19,0.00,'2022-03-02 18:07:30','',''),(2650790,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2675960.00,5030.00,0.00,0.00,'2022-03-03 07:40:05','',''),(2650791,'1','197',NULL,464,'Reception corrector for bridging 132598',0.00,0.00,0.00,5030.00,0.00,'2022-03-03 07:41:20','',''),(2650792,'1','197','1018',464,'Received from bridging 132598',0.00,0.00,5030.00,0.00,0.00,'2022-03-03 07:41:20','',''),(2650793,'1','197','1018',464,'Retail Sale Id 1642129',172800.00,0.00,0.00,320.00,2560.00,'2022-03-03 10:59:27','',''),(2650794,'1','197','1018',464,'Retail Sale Id 1642130',7250.00,0.00,0.00,12.50,600.00,'2022-03-03 11:18:01','',''),(2650795,'1','197','1018',464,'Retail Sale Id 1642131',90480.00,0.00,0.00,156.00,7488.00,'2022-03-03 11:18:50','',''),(2650796,'1','197','1018',464,'Retail Sale Id 1642132',75600.00,0.00,0.00,140.00,1120.00,'2022-03-03 11:22:05','',''),(2650797,'1','197','1018',464,'Retail Sale Id 1642134',7250.00,0.00,0.00,12.50,600.00,'2022-03-03 11:39:12','',''),(2650798,'1','197','1018',464,'Retail Sale Id 1642135',1798.00,0.00,0.00,3.10,148.80,'2022-03-03 11:45:53','',''),(2650799,'1','197','1018',464,'Retail Sale Id 1642136',70200.00,0.00,0.00,130.00,1040.00,'2022-03-03 12:18:08','',''),(2650800,'1','197','1018',464,'Retail Sale Id 1642137',19720.00,0.00,0.00,34.00,1632.00,'2022-03-03 12:20:43','',''),(2650801,'1','197','1018',464,'Retail Sale Id 1642138',7250.00,0.00,0.00,12.50,600.00,'2022-03-03 12:21:34','',''),(2650802,'1','197','1018',464,'Retail Sale Id 1642139',18270.00,0.00,0.00,31.50,1512.00,'2022-03-03 12:51:23','',''),(2650803,'1','197','1018',464,'Retail Sale Id 1642140',580.00,0.00,0.00,1.00,48.00,'2022-03-03 13:21:59','',''),(2650804,'1','197','1018',464,'Retail Sale Id 1642141',7250.00,0.00,0.00,12.50,600.00,'2022-03-03 13:23:58','',''),(2650805,'1','197','1018',464,'Retail Sale Id 1642142',7250.00,0.00,0.00,12.50,600.00,'2022-03-03 14:30:59','',''),(2650806,'1','197','1018',464,'Retail Sale Id 1642143',14500.00,0.00,0.00,25.00,1200.00,'2022-03-03 14:38:24','',''),(2650807,'1','197','1018',464,'Retail Sale Id 1642144',7250.00,0.00,0.00,12.50,600.00,'2022-03-03 14:42:50','',''),(2650808,'1','197','1018',464,'Retail Sale Id 1642146',279989.20,0.00,0.00,482.74,23171.52,'2022-03-03 20:07:40','',''),(2650809,'1','197','1018',464,'Retail Sale Id 1642147',72478.80,0.00,0.00,134.22,1073.76,'2022-03-03 20:08:56','',''),(2650810,'1','197','1018',464,'Retail Sale Id 1642148',14500.00,0.00,0.00,25.00,1200.00,'2022-03-04 08:30:44','',''),(2650811,'1','197','1018',464,'Retail Sale Id 1642149',6902.00,0.00,0.00,11.90,571.20,'2022-03-04 08:31:09','',''),(2650812,'1','197','1018',464,'Retail Sale Id 1642150',1798.00,0.00,0.00,3.10,148.80,'2022-03-04 08:38:57','',''),(2650813,'1','197','1018',464,'Retail Sale Id 1642151',5997.20,0.00,0.00,10.34,496.32,'2022-03-04 08:48:24','',''),(2650814,'1','197','1018',464,'Retail Sale Id 1642152',14500.00,0.00,0.00,25.00,1200.00,'2022-03-04 08:58:09','',''),(2650815,'1','197','1018',464,'Retail Sale Id 1642153',2900.00,0.00,0.00,5.00,240.00,'2022-03-04 08:58:57','',''),(2650816,'1','197','1018',464,'Retail Sale Id 1642154',3497.40,0.00,0.00,6.03,289.44,'2022-03-04 08:59:40','',''),(2650817,'1','197','1018',464,'Retail Sale Id 1642155',3497.40,0.00,0.00,6.03,289.44,'2022-03-04 09:00:22','',''),(2650818,'1','197','1018',464,'Retail Sale Id 1642156',3497.40,0.00,0.00,6.03,289.44,'2022-03-04 09:00:54','',''),(2650819,'1','197','1018',464,'Retail Sale Id 1642157',7000.60,0.00,0.00,12.07,579.36,'2022-03-04 09:01:32','',''),(2650820,'1','197','1018',464,'Retail Sale Id 1642158',3497.40,0.00,0.00,6.03,289.44,'2022-03-04 09:10:53','',''),(2650821,'1','197','1018',464,'Retail Sale Id 1642159',21750.00,0.00,0.00,37.50,1800.00,'2022-03-04 09:49:18','',''),(2650822,'1','197','1018',464,'Retail Sale Id 1642160',3497.40,0.00,0.00,6.03,289.44,'2022-03-04 10:25:30','',''),(2650823,'1','197','1018',464,'Retail Sale Id 1642161',2001.00,0.00,0.00,3.45,165.60,'2022-03-04 10:26:11','',''),(2650824,'1','197','1018',464,'Retail Sale Id 1642162',2001.00,0.00,0.00,3.45,165.60,'2022-03-04 10:27:00','',''),(2650825,'1','197','1018',464,'Retail Sale Id 1642163',14500.00,0.00,0.00,25.00,1200.00,'2022-03-04 12:47:28','',''),(2650826,'1','197','1018',464,'Retail Sale Id 1642164',7250.00,0.00,0.00,12.50,600.00,'2022-03-04 12:48:02','',''),(2650827,'1','197','1018',464,'Retail Sale Id 1642165',0.00,0.00,0.00,0.00,0.00,'2022-03-04 12:50:01','',''),(2650828,'1','197','1018',464,'Retail Sale Id 1642166',7250.00,0.00,0.00,12.50,600.00,'2022-03-04 13:07:17','',''),(2650829,'1','197','1018',464,'Retail Sale Id 1642167',33350.00,0.00,0.00,57.50,2760.00,'2022-03-04 13:09:35','',''),(2650830,'1','197','1018',464,'Retail Sale Id 1642168',227000.40,0.00,0.00,391.38,18786.24,'2022-03-04 20:17:19','',''),(2650831,'1','197','1018',464,'Retail Sale Id 1642169',180360.00,0.00,0.00,334.00,2672.00,'2022-03-04 20:18:28','',''),(2650832,'1','197','1018',464,'Retail Sale Id 1642170',64800.00,0.00,0.00,120.00,960.00,'2022-03-04 20:19:08','',''),(2650833,'1','197','1018',464,'Retail Sale Id 1642171',135000.00,0.00,0.00,250.00,2000.00,'2022-03-04 20:19:43','',''),(2650834,'1','197','1018',464,'Retail Sale Id 1642172',188238.60,0.00,0.00,348.59,2788.72,'2022-03-04 20:21:52','',''),(2650835,'1','197','1018',464,'Retail Sale Id 1642173',108000.00,0.00,0.00,200.00,1600.00,'2022-03-04 20:22:36','',''),(2650836,'1','197','1018',464,'Retail Sale Id 1642176',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 09:26:40','',''),(2650837,'1','197','1018',464,'Retail Sale Id 1642177',14500.00,0.00,0.00,25.00,1200.00,'2022-03-05 09:27:08','',''),(2650838,'1','197','1018',464,'Retail Sale Id 1642178',29000.00,0.00,0.00,50.00,2400.00,'2022-03-05 10:58:33','',''),(2650839,'1','197','1018',464,'Retail Sale Id 1642179',612648.00,0.00,0.00,1143.00,4572.00,'2022-03-05 13:34:51','',''),(2650840,'1','197','1018',464,'Retail Sale Id 1642180',46553.40,0.00,0.00,86.21,689.68,'2022-03-05 13:35:37','',''),(2650841,'1','197','1018',464,'Retail Sale Id 1642181',58000.00,0.00,0.00,100.00,4800.00,'2022-03-05 13:36:53','',''),(2650842,'1','197','1018',464,'Retail Sale Id 1642182',21750.00,0.00,0.00,37.50,1800.00,'2022-03-05 13:37:19','',''),(2650843,'1','197','1018',464,'Retail Sale Id 1642183',13757.60,0.00,0.00,23.72,1138.56,'2022-03-05 13:37:40','',''),(2650844,'1','197','1018',464,'Retail Sale Id 1642184',58000.00,0.00,0.00,100.00,4800.00,'2022-03-05 13:38:00','',''),(2650845,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350282',579.88,0.00,0.00,1.09,0.00,'2022-03-05 13:46:44','',''),(2650846,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2803640.00,5270.00,0.00,0.00,'2022-03-05 15:46:37','',''),(2650847,'1','197',NULL,464,'Reception corrector for bridging 132599',0.00,0.00,0.00,5270.00,0.00,'2022-03-05 15:48:18','',''),(2650848,'1','197','1018',464,'Received from bridging 132599',0.00,0.00,5270.00,0.00,0.00,'2022-03-05 15:48:18','',''),(2650849,'1','197','1018',464,'Retail Sale Id 1642185',14500.00,0.00,0.00,25.00,1200.00,'2022-03-05 15:50:35','',''),(2650850,'1','197','1018',464,'Retail Sale Id 1642186',108000.00,0.00,0.00,200.00,1600.00,'2022-03-05 15:53:29','',''),(2650851,'1','197','1018',464,'Retail Sale Id 1642187',23220.00,0.00,0.00,43.00,344.00,'2022-03-05 15:54:07','',''),(2650852,'1','197','1018',464,'Retail Sale Id 1642188',39690.00,0.00,0.00,73.50,588.00,'2022-03-05 15:54:59','',''),(2650853,'1','197','1018',464,'Retail Sale Id 1642189',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 15:55:43','',''),(2650854,'1','197','1018',464,'Retail Sale Id 1642190',12997.80,0.00,0.00,22.41,1075.68,'2022-03-05 15:56:15','',''),(2650855,'1','197','1018',464,'Retail Sale Id 1642191',14500.00,0.00,0.00,25.00,1200.00,'2022-03-05 15:56:39','',''),(2650856,'1','197','1018',464,'Retail Sale Id 1642192',3601.80,0.00,0.00,6.21,298.08,'2022-03-05 15:57:10','',''),(2650857,'1','197','1018',464,'Retail Sale Id 1642193',3497.40,0.00,0.00,6.03,289.44,'2022-03-05 15:59:12','',''),(2650858,'1','197','1018',464,'Retail Sale Id 1642194',1798.00,0.00,0.00,3.10,148.80,'2022-03-05 16:00:26','',''),(2650859,'1','197','1018',464,'Retail Sale Id 1642194',2900.00,0.00,0.00,5.00,240.00,'2022-03-05 16:00:26','',''),(2650860,'1','197','1018',464,'Retail Sale Id 1642195',3497.40,0.00,0.00,6.03,289.44,'2022-03-05 16:51:52','',''),(2650861,'1','197','1018',464,'Retail Sale Id 1642196',4698.00,0.00,0.00,8.10,388.80,'2022-03-05 16:52:35','',''),(2650862,'1','197','1018',464,'Retail Sale Id 1642197',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 16:56:45','',''),(2650863,'1','197','1018',464,'Retail Sale Id 1642198',108000.00,0.00,0.00,200.00,1600.00,'2022-03-05 17:02:37','',''),(2650864,'1','197','1018',464,'Retail Sale Id 1642199',3497.40,0.00,0.00,6.03,289.44,'2022-03-05 18:17:39','',''),(2650865,'1','197','1018',464,'Retail Sale Id 1642200',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 18:21:13','',''),(2650866,'1','197','1018',464,'Retail Sale Id 1642201',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 18:21:58','',''),(2650867,'1','197','1018',464,'Retail Sale Id 1642202',108000.00,0.00,0.00,200.00,1600.00,'2022-03-05 18:25:17','',''),(2650868,'1','197','1018',464,'Retail Sale Id 1642203',597.40,0.00,0.00,1.03,49.44,'2022-03-05 18:30:35','',''),(2650869,'1','197','1018',464,'Retail Sale Id 1642204',3497.40,0.00,0.00,6.03,289.44,'2022-03-05 18:36:25','',''),(2650870,'1','197','1018',464,'Retail Sale Id 1642205',27000.00,0.00,0.00,50.00,400.00,'2022-03-05 18:38:31','',''),(2650871,'1','197','1018',464,'Retail Sale Id 1642206',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 18:40:28','',''),(2650872,'1','197','1018',464,'Retail Sale Id 1642207',3497.40,0.00,0.00,6.03,289.44,'2022-03-05 18:42:28','',''),(2650873,'1','197','1018',464,'Retail Sale Id 1642208',6670.00,0.00,0.00,11.50,552.00,'2022-03-05 18:45:31','',''),(2650874,'1','197','1018',464,'Retail Sale Id 1642209',7250.00,0.00,0.00,12.50,600.00,'2022-03-05 18:46:23','',''),(2650875,'1','197','1018',464,'Retail Sale Id 1642210',66015.60,0.00,0.00,113.82,5463.36,'2022-03-05 20:57:11','',''),(2650876,'1','197','1018',464,'Return of Retail Sale Id 1642202',0.00,108000.00,200.00,0.00,-1600.00,'2022-03-05 20:59:27','',''),(2650877,'1','197','1018',464,'Retail Sale Id 1642211',101255.40,0.00,0.00,187.51,1500.08,'2022-03-05 21:01:00','',''),(2650878,'1','197','1018',464,'Retail Sale Id 1642212',21750.00,0.00,0.00,37.50,1800.00,'2022-03-06 08:28:29','',''),(2650879,'1','197','1018',464,'Retail Sale Id 1642213',16999.80,0.00,0.00,29.31,1406.88,'2022-03-06 08:30:47','',''),(2650880,'1','197','1018',464,'Retail Sale Id 1642214',4002.00,0.00,0.00,6.90,331.20,'2022-03-06 08:31:27','',''),(2650881,'1','197','1018',464,'Retail Sale Id 1642215',27000.00,0.00,0.00,50.00,400.00,'2022-03-06 08:55:30','',''),(2650882,'1','197','1018',464,'Retail Sale Id 1642216',1502.20,0.00,0.00,2.59,124.32,'2022-03-06 09:52:02','',''),(2650883,'1','197','1018',464,'Retail Sale Id 1642217',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 09:53:07','',''),(2650884,'1','197','1018',464,'Retail Sale Id 1642218',3497.40,0.00,0.00,6.03,289.44,'2022-03-06 10:17:34','',''),(2650885,'1','197','1018',464,'Retail Sale Id 1642219',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 10:18:28','',''),(2650886,'1','197','1018',464,'Retail Sale Id 1642220',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 10:53:22','',''),(2650887,'1','197','1018',464,'Retail Sale Id 1642221',102681.00,0.00,0.00,190.15,1521.20,'2022-03-06 10:56:16','',''),(2650888,'1','197','1018',464,'Retail Sale Id 1642222',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 10:57:20','',''),(2650889,'1','197','1018',464,'Retail Sale Id 1642223',5800.00,0.00,0.00,10.00,480.00,'2022-03-06 11:09:31','',''),(2650890,'1','197','1018',464,'Retail Sale Id 1642223',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 11:09:31','',''),(2650891,'1','197','1018',464,'Retail Sale Id 1642224',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 11:10:48','',''),(2650892,'1','197','1018',464,'Retail Sale Id 1642226',2900.00,0.00,0.00,5.00,240.00,'2022-03-06 11:24:33','',''),(2650893,'1','197','1018',464,'Retail Sale Id 1642227',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 11:30:45','',''),(2650894,'1','197','1018',464,'Retail Sale Id 1642228',2998.60,0.00,0.00,5.17,248.16,'2022-03-06 11:39:27','',''),(2650895,'1','197','1018',464,'Retail Sale Id 1642229',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:11:32','',''),(2650896,'1','197','1018',464,'Retail Sale Id 1642231',2998.60,0.00,0.00,5.17,248.16,'2022-03-06 12:24:39','',''),(2650897,'1','197','1018',464,'Retail Sale Id 1642232',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:25:18','',''),(2650898,'1','197','1018',464,'Retail Sale Id 1642233',1798.00,0.00,0.00,3.10,148.80,'2022-03-06 12:33:19','',''),(2650899,'1','197','1018',464,'Retail Sale Id 1642234',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:33:57','',''),(2650900,'1','197','1018',464,'Retail Sale Id 1642235',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:46:40','',''),(2650901,'1','197','1018',464,'Retail Sale Id 1642236',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:47:28','',''),(2650902,'1','197','1018',464,'Retail Sale Id 1642237',3497.40,0.00,0.00,6.03,289.44,'2022-03-06 12:48:01','',''),(2650903,'1','197','1018',464,'Retail Sale Id 1642238',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:51:22','',''),(2650904,'1','197','1018',464,'Retail Sale Id 1642239',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 12:52:57','',''),(2650905,'1','197','1018',464,'Retail Sale Id 1642240',2900.00,0.00,0.00,5.00,240.00,'2022-03-06 13:17:55','',''),(2650906,'1','197','1018',464,'Retail Sale Id 1642241',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 13:39:09','',''),(2650907,'1','197','1018',464,'Retail Sale Id 1642242',24300.00,0.00,0.00,45.00,360.00,'2022-03-06 13:43:40','',''),(2650908,'1','197','1018',464,'Retail Sale Id 1642243',4802.40,0.00,0.00,8.28,397.44,'2022-03-06 13:51:45','',''),(2650909,'1','197','1018',464,'Retail Sale Id 1642244',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 14:03:57','',''),(2650910,'1','197','1018',464,'Retail Sale Id 1642245',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 14:08:38','',''),(2650911,'1','197','1018',464,'Retail Sale Id 1642246',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 14:10:43','',''),(2650912,'1','197','1018',464,'Retail Sale Id 1642247',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 14:42:17','',''),(2650913,'1','197','1018',464,'Retail Sale Id 1642248',29000.00,0.00,0.00,50.00,2400.00,'2022-03-06 14:56:53','',''),(2650914,'1','197','1018',464,'Retail Sale Id 1642249',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 14:57:50','',''),(2650915,'1','197','1018',464,'Retail Sale Id 1642250',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 15:32:28','',''),(2650916,'1','197','1018',464,'Retail Sale Id 1642251',1798.00,0.00,0.00,3.10,148.80,'2022-03-06 15:45:58','',''),(2650917,'1','197','1018',464,'Retail Sale Id 1642252',997.60,0.00,0.00,1.72,82.56,'2022-03-06 18:10:34','',''),(2650918,'1','197','1018',464,'Retail Sale Id 1642253',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 18:13:42','',''),(2650919,'1','197','1018',464,'Retail Sale Id 1642254',7250.00,0.00,0.00,12.50,600.00,'2022-03-06 18:15:48','',''),(2650920,'1','197','1018',464,'Retail Sale Id 1642255',1798.00,0.00,0.00,3.10,148.80,'2022-03-06 18:20:25','',''),(2650921,'1','197','1018',464,'Retail Sale Id 1642256',14500.00,0.00,0.00,25.00,1200.00,'2022-03-06 18:24:59','',''),(2650922,'1','197','1018',464,'Retail Sale Id 1642257',5800.00,0.00,0.00,10.00,480.00,'2022-03-06 18:48:22','',''),(2650923,'1','197','1018',464,'Retail Sale Id 1642259',29000.00,0.00,0.00,50.00,2400.00,'2022-03-06 19:40:43','',''),(2650924,'1','197','1018',464,'Retail Sale Id 1642260',21750.00,0.00,0.00,37.50,1800.00,'2022-03-06 19:41:20','',''),(2650925,'1','197','1018',464,'Retail Sale Id 1642262',11582.60,0.00,0.00,19.97,958.56,'2022-03-06 19:41:49','',''),(2650926,'1','197','1018',464,'Retail Sale Id 1642263',143418.60,0.00,0.00,265.59,2124.72,'2022-03-06 19:43:15','',''),(2650927,'1','197','1018',464,'Retail Sale Id 1642264',3497.40,0.00,0.00,6.03,289.44,'2022-03-07 07:57:14','',''),(2650928,'1','197','1018',464,'Retail Sale Id 1642265',7250.00,0.00,0.00,12.50,600.00,'2022-03-07 08:19:16','',''),(2650929,'1','197','1018',464,'Retail Sale Id 1642266',29000.00,0.00,0.00,50.00,2400.00,'2022-03-07 08:59:16','',''),(2650930,'1','197','1018',464,'Retail Sale Id 1642267',2001.00,0.00,0.00,3.45,165.60,'2022-03-07 09:16:06','',''),(2650931,'1','197','1018',464,'Retail Sale Id 1642268',7250.00,0.00,0.00,12.50,600.00,'2022-03-07 09:20:03','',''),(2650932,'1','197','1018',464,'Retail Sale Id 1642269',9999.20,0.00,0.00,17.24,827.52,'2022-03-07 09:28:53','',''),(2650933,'1','197','1018',464,'Retail Sale Id 1642270',7250.00,0.00,0.00,12.50,600.00,'2022-03-07 10:04:15','',''),(2650934,'1','197','1018',464,'Retail Sale Id 1642271',997.60,0.00,0.00,1.72,82.56,'2022-03-07 10:07:10','',''),(2650935,'1','197','1018',464,'Retail Sale Id 1642272',7250.00,0.00,0.00,12.50,600.00,'2022-03-07 10:08:15','',''),(2650936,'1','197','1018',464,'Retail Sale Id 1642273',997.60,0.00,0.00,1.72,82.56,'2022-03-07 10:31:52','',''),(2650937,'1','197','1018',464,'Retail Sale Id 1642274',10747.40,0.00,0.00,18.53,889.44,'2022-03-07 13:18:07','',''),(2650938,'1','197','1018',464,'Retail Sale Id 1642275',3497.40,0.00,0.00,6.03,289.44,'2022-03-07 13:18:56','',''),(2650939,'1','197','1018',464,'Retail Sale Id 1642275',7250.00,0.00,0.00,12.50,600.00,'2022-03-07 13:18:56','',''),(2650940,'1','197','1018',464,'Retail Sale Id 1642276',189000.00,0.00,0.00,350.00,2800.00,'2022-03-07 20:00:44','',''),(2650941,'1','197','1018',464,'Retail Sale Id 1642277',108000.00,0.00,0.00,200.00,1600.00,'2022-03-07 20:01:28','',''),(2650942,'1','197','1018',464,'Retail Sale Id 1642278',34603.20,0.00,0.00,64.08,512.64,'2022-03-07 20:01:59','',''),(2650943,'1','197','1018',464,'Retail Sale Id 1642279',87000.00,0.00,0.00,150.00,7200.00,'2022-03-07 20:03:12','',''),(2650944,'1','197','1018',464,'Retail Sale Id 1642281',21750.00,0.00,0.00,37.50,1800.00,'2022-03-07 20:03:47','',''),(2650945,'1','197','1018',464,'Retail Sale Id 1642282',7250.00,0.00,0.00,12.50,600.00,'2022-03-07 20:04:11','',''),(2650946,'1','197','1018',464,'Retail Sale Id 1642283',58000.00,0.00,0.00,100.00,4800.00,'2022-03-07 20:04:39','',''),(2650947,'1','197','1018',464,'Retail Sale Id 1642284',87000.00,0.00,0.00,150.00,7200.00,'2022-03-07 20:05:54','',''),(2650948,'1','197','1018',464,'Retail Sale Id 1642286',64008.80,0.00,0.00,110.36,5297.28,'2022-03-07 20:07:26','',''),(2650949,'1','197','1018',464,'Retail Sale Id 1642287',2900.00,0.00,0.00,5.00,240.00,'2022-03-08 07:58:57','',''),(2650950,'1','197','1018',464,'Retail Sale Id 1642288',5800.00,0.00,0.00,10.00,480.00,'2022-03-08 08:01:02','',''),(2650951,'1','197','1018',464,'Retail Sale Id 1642289',0.00,0.00,0.00,0.00,0.00,'2022-03-08 08:04:05','',''),(2650952,'1','197','1018',464,'Retail Sale Id 1642290',172800.00,0.00,0.00,320.00,2560.00,'2022-03-08 08:58:09','',''),(2650953,'1','197','1018',464,'Retail Sale Id 1642291',1798.00,0.00,0.00,3.10,148.80,'2022-03-08 09:07:20','',''),(2650954,'1','197','1018',464,'Retail Sale Id 1642292',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 09:12:17','',''),(2650955,'1','197','1018',464,'Retail Sale Id 1642293',3497.40,0.00,0.00,6.03,289.44,'2022-03-08 09:35:03','',''),(2650956,'1','197','1018',464,'Retail Sale Id 1642295',5800.00,0.00,0.00,10.00,480.00,'2022-03-08 10:17:04','',''),(2650957,'1','197','1018',464,'Retail Sale Id 1642296',4402.20,0.00,0.00,7.59,364.32,'2022-03-08 10:20:09','',''),(2650958,'1','197','1018',464,'Retail Sale Id 1642297',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 11:03:22','',''),(2650959,'1','197','1018',464,'Retail Sale Id 1642298',33480.00,0.00,0.00,62.00,496.00,'2022-03-08 11:04:01','',''),(2650960,'1','197','1018',464,'Retail Sale Id 1642299',54000.00,0.00,0.00,100.00,800.00,'2022-03-08 11:05:09','',''),(2650961,'1','197','1018',464,'Retail Sale Id 1642300',1502.20,0.00,0.00,2.59,124.32,'2022-03-08 11:07:48','',''),(2650962,'1','197','1018',464,'Retail Sale Id 1642301',72900.00,0.00,0.00,135.00,1080.00,'2022-03-08 11:14:08','',''),(2650963,'1','197','1018',464,'Retail Sale Id 1642302',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 11:22:48','',''),(2650964,'1','197','1018',464,'Retail Sale Id 1642303',1798.00,0.00,0.00,3.10,148.80,'2022-03-08 12:17:28','',''),(2650965,'1','197','1018',464,'Retail Sale Id 1642304',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 12:47:54','',''),(2650966,'1','197','1018',464,'Retail Sale Id 1642305',105840.00,0.00,0.00,196.00,1568.00,'2022-03-08 13:12:00','',''),(2650967,'1','197','1018',464,'Retail Sale Id 1642306',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 13:13:45','',''),(2650968,'1','197','1018',464,'Retail Sale Id 1642307',2499.80,0.00,0.00,4.31,206.88,'2022-03-08 14:07:55','',''),(2650969,'1','197','1018',464,'Retail Sale Id 1642308',137160.00,0.00,0.00,254.00,2032.00,'2022-03-08 14:10:47','',''),(2650970,'1','197','1018',464,'Retail Sale Id 1642309',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 14:12:13','',''),(2650971,'1','197','1018',464,'Retail Sale Id 1642310',7250.00,0.00,0.00,12.50,600.00,'2022-03-08 14:20:05','',''),(2650972,'1','197','1018',464,'Retail Sale Id 1642311',6670.00,0.00,0.00,11.50,552.00,'2022-03-08 14:36:45','',''),(2650973,'1','197','1018',464,'Retail Sale Id 1642312',2900.00,0.00,0.00,5.00,240.00,'2022-03-08 14:42:44','',''),(2650974,'1','197','1018',464,'Retail Sale Id 1642313',5399.80,0.00,0.00,9.31,446.88,'2022-03-08 14:47:18','',''),(2650975,'1','197','1018',464,'Retail Sale Id 1642314',1798.00,0.00,0.00,3.10,148.80,'2022-03-08 14:47:56','',''),(2650976,'1','197','1018',464,'Retail Sale Id 1642315',86971.00,0.00,0.00,149.95,7197.60,'2022-03-09 00:15:47','',''),(2650977,'1','197','1018',464,'Retail Sale Id 1642316',109625.40,0.00,0.00,203.01,1624.08,'2022-03-09 00:18:44','',''),(2650978,'1','197','1018',464,'Distributed to DE-GRASIOUS GAS for sales id:350283',48518.40,0.00,0.00,91.20,0.00,'2022-03-09 00:40:32','',''),(2650979,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2997300.00,5150.00,0.00,0.00,'2022-03-09 10:28:51','',''),(2650980,'1','197',NULL,464,'Reception corrector for bridging 132600',0.00,0.00,0.00,5150.00,0.00,'2022-03-09 10:31:07','',''),(2650981,'1','197','1018',464,'Received from bridging 132600',0.00,0.00,5150.00,0.00,0.00,'2022-03-09 10:31:07','',''),(2650982,'1','197','1018',464,'Retail Sale Id 1642317',8000.00,0.00,0.00,12.50,725.00,'2022-03-09 10:33:40','',''),(2650983,'1','197','1018',464,'Retail Sale Id 1642318',7001.60,0.00,0.00,10.94,634.52,'2022-03-09 10:34:16','',''),(2650984,'1','197','1018',464,'Retail Sale Id 1642319',3200.00,0.00,0.00,5.00,290.00,'2022-03-09 10:35:23','',''),(2650985,'1','197','1018',464,'Retail Sale Id 1642319',8000.00,0.00,0.00,12.50,725.00,'2022-03-09 10:35:23','',''),(2650986,'1','197','1018',464,'Retail Sale Id 1642320',8000.00,0.00,0.00,12.50,725.00,'2022-03-09 10:51:22','',''),(2650987,'1','197','1018',464,'Retail Sale Id 1642321',5798.40,0.00,0.00,9.06,525.48,'2022-03-09 10:59:02','',''),(2650988,'1','197','1018',464,'Retail Sale Id 1642322',1920.00,0.00,0.00,3.00,174.00,'2022-03-09 11:03:53','',''),(2650989,'1','197','1018',464,'Retail Sale Id 1642323',0.00,0.00,0.00,0.00,0.00,'2022-03-09 11:08:11','',''),(2650990,'1','197','1018',464,'Retail Sale Id 1642324',32000.00,0.00,0.00,50.00,2900.00,'2022-03-09 11:13:15','',''),(2650991,'1','197','1018',464,'Retail Sale Id 1642325',8000.00,0.00,0.00,12.50,725.00,'2022-03-09 14:14:43','',''),(2650992,'1','197','1018',464,'Retail Sale Id 1642326',8000.00,0.00,0.00,12.50,725.00,'2022-03-09 14:18:58','',''),(2650993,'1','197','1018',464,'Retail Sale Id 1642327',8000.00,0.00,0.00,12.50,725.00,'2022-03-09 14:20:29','',''),(2650994,'1','197','1018',464,'Retail Sale Id 1642328',2003.20,0.00,0.00,3.13,181.54,'2022-03-09 14:26:19','',''),(2650995,'1','197','1018',464,'Retail Sale Id 1642329',340121.60,0.00,0.00,531.44,30823.52,'2022-03-09 20:57:03','',''),(2650996,'1','197','1018',464,'Retail Sale Id 1642330',3897.60,0.00,0.00,6.09,353.22,'2022-03-10 10:50:59','',''),(2650997,'1','197','1018',464,'Retail Sale Id 1642330',8000.00,0.00,0.00,12.50,725.00,'2022-03-10 10:50:59','',''),(2650998,'1','197','1018',464,'Retail Sale Id 1642331',8000.00,0.00,0.00,12.50,725.00,'2022-03-10 10:52:14','',''),(2650999,'1','197','1018',464,'Retail Sale Id 1642332',4000.00,0.00,0.00,6.25,362.50,'2022-03-10 10:55:10','',''),(2651000,'1','197','1018',464,'Retail Sale Id 1642333',1952.00,0.00,0.00,3.05,176.90,'2022-03-10 12:19:01','',''),(2651001,'1','197','1018',464,'Retail Sale Id 1642334',16000.00,0.00,0.00,25.00,1450.00,'2022-03-10 12:21:35','',''),(2651002,'1','197','1018',464,'Retail Sale Id 1642335',8000.00,0.00,0.00,12.50,725.00,'2022-03-10 12:41:39','',''),(2651003,'1','197','1018',464,'Retail Sale Id 1642336',1497.60,0.00,0.00,2.34,135.72,'2022-03-10 13:21:58','',''),(2651004,'1','197','1018',464,'Retail Sale Id 1642337',0.00,0.00,0.00,0.00,0.00,'2022-03-10 13:36:17','',''),(2651005,'1','197','1018',464,'Retail Sale Id 1642338',8000.00,0.00,0.00,12.50,725.00,'2022-03-10 17:33:46','',''),(2651006,'1','197','1018',464,'Retail Sale Id 1642339',8000.00,0.00,0.00,12.50,725.00,'2022-03-10 17:35:55','',''),(2651007,'1','197','1018',464,'Retail Sale Id 1642340',32000.00,0.00,0.00,50.00,2900.00,'2022-03-10 17:38:01','',''),(2651008,'1','197','1018',464,'Retail Sale Id 1642341',2502.40,0.00,0.00,3.91,226.78,'2022-03-10 17:42:01','',''),(2651009,'1','197','1018',464,'Retail Sale Id 1642342',8742.40,0.00,0.00,13.66,792.28,'2022-03-10 17:43:15','',''),(2651010,'1','197','1018',464,'Retail Sale Id 1642343',16000.00,0.00,0.00,25.00,1450.00,'2022-03-10 17:44:21','',''),(2651011,'1','197','1018',464,'Retail Sale Id 1642344',2003.20,0.00,0.00,3.13,181.54,'2022-03-10 17:54:20','',''),(2651012,'1','197','1018',464,'Retail Sale Id 1642345',1952.00,0.00,0.00,3.05,176.90,'2022-03-10 17:57:24','',''),(2651013,'1','197','1018',464,'Retail Sale Id 1642346',8000.00,0.00,0.00,12.50,725.00,'2022-03-10 18:01:47','',''),(2651014,'1','197','1018',464,'Retail Sale Id 1642348',6502.40,0.00,0.00,10.16,589.28,'2022-03-10 18:02:36','',''),(2651015,'1','197','1018',464,'Retail Sale Id 1642349',7500.80,0.00,0.00,11.72,679.76,'2022-03-10 18:32:24','',''),(2651016,'1','197','1018',464,'Retail Sale Id 1642350',1920.00,0.00,0.00,3.00,174.00,'2022-03-10 18:35:16','',''),(2651017,'1','197','1018',464,'Retail Sale Id 1642351',4000.00,0.00,0.00,6.25,362.50,'2022-03-10 18:42:51','',''),(2651018,'1','197','1018',464,'Retail Sale Id 1642352',3001.60,0.00,0.00,4.69,272.02,'2022-03-10 18:46:35','',''),(2651019,'1','197','1018',464,'Retail Sale Id 1642353',279718.40,0.00,0.00,437.06,25349.48,'2022-03-10 19:48:24','',''),(2651020,'1','197','1018',464,'Retail Sale Id 1642354',20800.00,0.00,0.00,32.50,1885.00,'2022-03-11 10:01:03','',''),(2651021,'1','197','1018',464,'Retail Sale Id 1642355',16000.00,0.00,0.00,25.00,1450.00,'2022-03-11 10:10:29','',''),(2651022,'1','197','1018',464,'Retail Sale Id 1642356',16000.00,0.00,0.00,25.00,1450.00,'2022-03-11 10:16:05','',''),(2651023,'1','197','1018',464,'Retail Sale Id 1642357',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 11:33:31','',''),(2651024,'1','197','1018',464,'Retail Sale Id 1642358',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 11:37:29','',''),(2651025,'1','197','1018',464,'Retail Sale Id 1642359',6003.20,0.00,0.00,9.38,544.04,'2022-03-11 11:38:30','',''),(2651026,'1','197','1018',464,'Retail Sale Id 1642360',3897.60,0.00,0.00,6.09,353.22,'2022-03-11 11:39:35','',''),(2651027,'1','197','1018',464,'Retail Sale Id 1642361',3200.00,0.00,0.00,5.00,290.00,'2022-03-11 11:41:02','',''),(2651028,'1','197','1018',464,'Retail Sale Id 1642362',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 12:11:39','',''),(2651029,'1','197','1018',464,'Retail Sale Id 1642363',1497.60,0.00,0.00,2.34,135.72,'2022-03-11 12:18:21','',''),(2651030,'1','197','1018',464,'Retail Sale Id 1642364',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 12:19:31','',''),(2651031,'1','197','1018',464,'Retail Sale Id 1642365',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 12:31:20','',''),(2651032,'1','197','1018',464,'Retail Sale Id 1642366',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 12:43:06','',''),(2651033,'1','197','1018',464,'Retail Sale Id 1642367',11897.60,0.00,0.00,18.59,1078.22,'2022-03-11 12:48:49','',''),(2651034,'1','197','1018',464,'Retail Sale Id 1642368',6003.20,0.00,0.00,9.38,544.04,'2022-03-11 18:35:38','',''),(2651035,'1','197','1018',464,'Retail Sale Id 1642369',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 18:36:47','',''),(2651036,'1','197','1018',464,'Retail Sale Id 1642370',3200.00,0.00,0.00,5.00,290.00,'2022-03-11 18:38:45','',''),(2651037,'1','197','1018',464,'Retail Sale Id 1642371',8000.00,0.00,0.00,12.50,725.00,'2022-03-11 18:41:38','',''),(2651038,'1','197','1018',464,'Retail Sale Id 1642372',6400.00,0.00,0.00,10.00,580.00,'2022-03-11 18:43:01','',''),(2651039,'1','197','1018',464,'Retail Sale Id 1642373',4998.40,0.00,0.00,7.81,452.98,'2022-03-11 18:49:31','',''),(2651040,'1','197','1018',464,'Retail Sale Id 1642374',241196.80,0.00,0.00,376.87,21858.46,'2022-03-11 20:13:32','',''),(2651041,'1','197','1018',464,'Retail Sale Id 1642376',8000.00,0.00,0.00,12.50,725.00,'2022-03-12 12:36:35','',''),(2651042,'1','197','1018',464,'Retail Sale Id 1642377',32000.00,0.00,0.00,50.00,2900.00,'2022-03-12 12:37:37','',''),(2651043,'1','197','1018',464,'Retail Sale Id 1642378',32000.00,0.00,0.00,50.00,2900.00,'2022-03-12 12:38:38','',''),(2651044,'1','197','1018',464,'Retail Sale Id 1642379',3001.60,0.00,0.00,4.69,272.02,'2022-03-12 12:39:44','',''),(2651045,'1','197','1018',464,'Retail Sale Id 1642381',1952.00,0.00,0.00,3.05,176.90,'2022-03-12 12:51:23','',''),(2651046,'1','197','1018',464,'Retail Sale Id 1642381',1952.00,0.00,0.00,3.05,176.90,'2022-03-12 12:51:23','',''),(2651047,'1','197','1018',464,'Retail Sale Id 1642382',6400.00,0.00,0.00,10.00,580.00,'2022-03-12 12:54:38','',''),(2651048,'1','197','1018',464,'Retail Sale Id 1642382',8000.00,0.00,0.00,12.50,725.00,'2022-03-12 12:54:38','',''),(2651049,'1','197','1018',464,'Retail Sale Id 1642383',8000.00,0.00,0.00,12.50,725.00,'2022-03-12 13:25:46','',''),(2651050,'1','197','1018',464,'Retail Sale Id 1642384',28800.00,0.00,0.00,45.00,2610.00,'2022-03-12 13:30:54','',''),(2651051,'1','197','1018',464,'Retail Sale Id 1642385',3001.60,0.00,0.00,4.69,272.02,'2022-03-12 13:33:17','',''),(2651052,'1','197','1018',464,'Retail Sale Id 1642386',3200.00,0.00,0.00,5.00,290.00,'2022-03-12 13:37:57','',''),(2651053,'1','197','1018',464,'Retail Sale Id 1642388',9600.00,0.00,0.00,15.00,870.00,'2022-03-12 13:41:20','',''),(2651054,'1','197','1018',464,'Retail Sale Id 1642389',8000.00,0.00,0.00,12.50,725.00,'2022-03-12 13:45:00','',''),(2651055,'1','197','1018',464,'Retail Sale Id 1642390',8000.00,0.00,0.00,12.50,725.00,'2022-03-12 14:26:37','',''),(2651056,'1','197','1018',464,'Retail Sale Id 1642391',2598.40,0.00,0.00,4.06,235.48,'2022-03-12 15:29:02','',''),(2651057,'1','197','1018',464,'Retail Sale Id 1642392',8000.00,0.00,0.00,12.50,725.00,'2022-03-12 15:30:50','',''),(2651058,'1','197','1018',464,'Retail Sale Id 1642393',9747.20,0.00,0.00,15.23,883.34,'2022-03-12 15:32:42','',''),(2651059,'1','197','1018',464,'Retail Sale Id 1642394',508147.20,0.00,0.00,793.98,46050.84,'2022-03-13 00:10:12','',''),(2651060,'1','197','1018',464,'Retail Sale Id 1642395',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 12:27:59','',''),(2651061,'1','197','1018',464,'Retail Sale Id 1642396',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 12:29:17','',''),(2651062,'1','197','1018',464,'Retail Sale Id 1642396',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 12:29:17','',''),(2651063,'1','197','1018',464,'Retail Sale Id 1642397',64000.00,0.00,0.00,100.00,5800.00,'2022-03-13 12:30:23','',''),(2651064,'1','197','1018',464,'Retail Sale Id 1642398',172697.60,0.00,0.00,269.84,15650.72,'2022-03-13 12:34:27','',''),(2651065,'1','197','1018',464,'Retail Sale Id 1642399',0.00,0.00,0.00,0.00,0.00,'2022-03-13 12:44:26','',''),(2651066,'1','197','1018',464,'Retail Sale Id 1642400',1497.60,0.00,0.00,2.34,135.72,'2022-03-13 12:50:10','',''),(2651067,'1','197','1018',464,'Retail Sale Id 1642401',7801.60,0.00,0.00,12.19,707.02,'2022-03-13 13:12:27','',''),(2651068,'1','197','1018',464,'Retail Sale Id 1642402',3200.00,0.00,0.00,5.00,290.00,'2022-03-13 13:18:58','',''),(2651069,'1','197','1018',464,'Retail Sale Id 1642403',3200.00,0.00,0.00,5.00,290.00,'2022-03-13 13:23:48','',''),(2651070,'1','197','1018',464,'Retail Sale Id 1642404',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 13:46:26','',''),(2651071,'1','197','1018',464,'Retail Sale Id 1642405',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 13:52:11','',''),(2651072,'1','197','1018',464,'Retail Sale Id 1642406',3897.60,0.00,0.00,6.09,353.22,'2022-03-13 14:14:10','',''),(2651073,'1','197','1018',464,'Retail Sale Id 1642407',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 14:32:30','',''),(2651074,'1','197','1018',464,'Retail Sale Id 1642408',2003.20,0.00,0.00,3.13,181.54,'2022-03-13 14:37:05','',''),(2651075,'1','197','1018',464,'Retail Sale Id 1642409',1952.00,0.00,0.00,3.05,176.90,'2022-03-13 14:39:17','',''),(2651076,'1','197','1018',464,'Retail Sale Id 1642410',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 14:44:33','',''),(2651077,'1','197','1018',464,'Retail Sale Id 1642411',3200.00,0.00,0.00,5.00,290.00,'2022-03-13 14:47:24','',''),(2651078,'1','197','1018',464,'Retail Sale Id 1642412',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 14:58:51','',''),(2651079,'1','197','1018',464,'Retail Sale Id 1642413',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 15:09:04','',''),(2651080,'1','197','1018',464,'Retail Sale Id 1642414',998.40,0.00,0.00,1.56,90.48,'2022-03-13 15:35:29','',''),(2651081,'1','197','1018',464,'Retail Sale Id 1642415',8000.00,0.00,0.00,12.50,725.00,'2022-03-13 15:45:35','',''),(2651082,'1','197','1018',464,'Retail Sale Id 1642416',640.00,0.00,0.00,1.00,58.00,'2022-03-13 17:39:08','',''),(2651083,'1','197','1018',464,'Retail Sale Id 1642417',285004.80,0.00,0.00,445.32,25828.56,'2022-03-13 20:11:18','',''),(2651084,'1','197','1018',464,'Retail Sale Id 1642418',85100.80,0.00,0.00,132.97,7712.26,'2022-03-14 10:22:25','',''),(2651085,'1','197','1018',464,'Retail Sale Id 1642419',0.00,0.00,0.00,0.00,0.00,'2022-03-14 10:23:52','',''),(2651086,'1','197','1018',464,'Retail Sale Id 1642420',3897.60,0.00,0.00,6.09,353.22,'2022-03-14 10:27:42','',''),(2651087,'1','197','1018',464,'Retail Sale Id 1642421',18502.40,0.00,0.00,28.91,1676.78,'2022-03-14 10:28:36','',''),(2651088,'1','197','1018',464,'Retail Sale Id 1642422',28000.00,0.00,0.00,43.75,2537.50,'2022-03-14 10:29:22','',''),(2651089,'1','197','1018',464,'Retail Sale Id 1642423',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 10:36:43','',''),(2651090,'1','197','1018',464,'Retail Sale Id 1642424',3897.60,0.00,0.00,6.09,353.22,'2022-03-14 10:45:56','',''),(2651091,'1','197','1018',464,'Retail Sale Id 1642425',3897.60,0.00,0.00,6.09,353.22,'2022-03-14 14:16:57','',''),(2651092,'1','197','1018',464,'Retail Sale Id 1642426',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 14:23:26','',''),(2651093,'1','197','1018',464,'Retail Sale Id 1642427',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 14:28:42','',''),(2651094,'1','197','1018',464,'Retail Sale Id 1642428',30003.20,0.00,0.00,46.88,2719.04,'2022-03-14 14:49:33','',''),(2651095,'1','197','1018',464,'Retail Sale Id 1642429',2502.40,0.00,0.00,3.91,226.78,'2022-03-14 14:58:59','',''),(2651096,'1','197','1018',464,'Retail Sale Id 1642430',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 15:03:35','',''),(2651097,'1','197','1018',464,'Retail Sale Id 1642431',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 15:41:05','',''),(2651098,'1','197','1018',464,'Retail Sale Id 1642433',32000.00,0.00,0.00,50.00,2900.00,'2022-03-14 15:54:09','',''),(2651099,'1','197','1018',464,'Retail Sale Id 1642434',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 15:58:23','',''),(2651100,'1','197','1018',464,'Retail Sale Id 1642435',8000.00,0.00,0.00,12.50,725.00,'2022-03-14 16:05:37','',''),(2651101,'1','197','1018',464,'Retail Sale Id 1642436',3001.60,0.00,0.00,4.69,272.02,'2022-03-14 16:08:24','',''),(2651102,'1','197','1018',464,'Retail Sale Id 1642437',0.00,0.00,0.00,0.00,0.00,'2022-03-14 16:25:14','',''),(2651103,'1','197','1018',464,'Retail Sale Id 1642438',0.00,0.00,0.00,0.00,0.00,'2022-03-14 17:08:25','',''),(2651104,'1','197','1018',464,'Retail Sale Id 1642439',387014.40,0.00,0.00,604.71,35073.18,'2022-03-14 23:54:43','',''),(2651105,'1','197','1018',464,'Retail Sale Id 1642441',3502.00,0.00,0.00,5.15,381.10,'2022-03-15 08:38:30','',''),(2651106,'1','197','1018',464,'Retail Sale Id 1642442',4100.40,0.00,0.00,6.03,446.22,'2022-03-15 08:41:11','',''),(2651107,'1','197','1018',464,'Retail Sale Id 1642443',12600.40,0.00,0.00,18.53,1371.22,'2022-03-15 08:43:32','',''),(2651108,'1','197','1018',464,'Retail Sale Id 1642444',0.00,0.00,0.00,0.00,0.00,'2022-03-15 08:45:42','',''),(2651109,'1','197','1018',464,'Retail Sale Id 1642445',8500.00,0.00,0.00,12.50,925.00,'2022-03-15 08:55:26','',''),(2651110,'1','197','1018',464,'Retail Sale Id 1642446',5440.00,0.00,0.00,8.00,592.00,'2022-03-15 09:03:43','',''),(2651111,'1','197','1018',464,'Retail Sale Id 1642447',3427.20,0.00,0.00,5.04,372.96,'2022-03-15 10:37:19','',''),(2651112,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,10996.44,20.67,0.00,0.00,'2022-03-15 21:03:04','',''),(2651113,'1','197',NULL,464,'Reception corrector for bridging 132601',0.00,0.00,0.00,20.67,0.00,'2022-03-15 21:07:06','',''),(2651114,'1','197','1018',464,'Received from bridging 132601',0.00,0.00,20.67,0.00,0.00,'2022-03-15 21:07:06','',''),(2651115,'1','197','1018',464,'Retail Sale Id 1642448',14055.60,0.00,0.00,20.67,3059.16,'2022-03-15 21:10:27','',''),(2651116,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,3090600.00,5100.00,0.00,0.00,'2022-03-15 22:10:07','',''),(2651117,'1','197',NULL,464,'Reception corrector for bridging 132602',0.00,0.00,0.00,5100.00,0.00,'2022-03-15 22:12:47','',''),(2651118,'1','197','1018',464,'Received from bridging 132602',0.00,0.00,5100.00,0.00,0.00,'2022-03-15 22:12:47','',''),(2651119,'1','197','1018',464,'Retail Sale Id 1642449',225624.00,0.00,0.00,331.80,24553.20,'2022-03-15 22:14:33','',''),(2651120,'1','197','1018',464,'Retail Sale Id 1642450',32000.00,0.00,0.00,50.00,1700.00,'2022-03-15 22:15:22','',''),(2651121,'1','197','1018',464,'Retail Sale Id 1642451',0.00,0.00,0.00,0.00,0.00,'2022-03-16 08:47:44','',''),(2651122,'1','197','1018',464,'Retail Sale Id 1642452',8500.00,0.00,0.00,12.50,925.00,'2022-03-16 12:29:38','',''),(2651123,'1','197','1018',464,'Retail Sale Id 1642453',16000.40,0.00,0.00,23.53,1741.22,'2022-03-16 12:30:46','',''),(2651124,'1','197','1018',464,'Retail Sale Id 1642454',68000.00,0.00,0.00,100.00,7400.00,'2022-03-16 12:31:44','',''),(2651125,'1','197','1018',464,'Retail Sale Id 1642455',0.00,0.00,0.00,0.00,0.00,'2022-03-16 14:26:37','',''),(2651126,'1','197','1018',464,'Retail Sale Id 1642456',74425.60,0.00,0.00,116.29,3953.86,'2022-03-16 20:36:53','',''),(2651127,'1','197','1018',464,'Retail Sale Id 1642457',289455.60,0.00,0.00,425.67,31499.58,'2022-03-16 20:37:58','',''),(2651128,'1','197','1018',464,'Retail Sale Id 1642458',0.00,0.00,0.00,0.00,0.00,'2022-03-17 08:17:24','',''),(2651129,'1','197','1018',464,'Retail Sale Id 1642459',0.00,0.00,0.00,0.00,0.00,'2022-03-17 08:33:31','',''),(2651130,'1','197','1018',464,'Retail Sale Id 1642460',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 13:15:49','',''),(2651131,'1','197','1018',464,'Retail Sale Id 1642461',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 13:16:40','',''),(2651132,'1','197','1018',464,'Retail Sale Id 1642462',6800.00,0.00,0.00,10.00,740.00,'2022-03-17 13:17:38','',''),(2651133,'1','197','1018',464,'Retail Sale Id 1642463',6800.00,0.00,0.00,10.00,740.00,'2022-03-17 13:18:31','',''),(2651134,'1','197','1018',464,'Retail Sale Id 1642464',4100.40,0.00,0.00,6.03,446.22,'2022-03-17 13:20:33','',''),(2651135,'1','197','1018',464,'Retail Sale Id 1642464',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 13:20:33','',''),(2651136,'1','197','1018',464,'Retail Sale Id 1642465',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 14:07:53','',''),(2651137,'1','197','1018',464,'Retail Sale Id 1642466',4100.40,0.00,0.00,6.03,446.22,'2022-03-17 14:37:12','',''),(2651138,'1','197','1018',464,'Retail Sale Id 1642467',2040.00,0.00,0.00,3.00,222.00,'2022-03-17 14:43:30','',''),(2651139,'1','197','1018',464,'Retail Sale Id 1642468',4100.40,0.00,0.00,6.03,446.22,'2022-03-17 15:05:01','',''),(2651140,'1','197','1018',464,'Retail Sale Id 1642469',2040.00,0.00,0.00,3.00,222.00,'2022-03-17 15:14:59','',''),(2651141,'1','197','1018',464,'Retail Sale Id 1642470',1999.20,0.00,0.00,2.94,217.56,'2022-03-17 15:16:15','',''),(2651142,'1','197','1018',464,'Retail Sale Id 1642471',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 15:19:26','',''),(2651143,'1','197','1018',464,'Retail Sale Id 1642472',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 15:37:56','',''),(2651144,'1','197','1018',464,'Retail Sale Id 1642473',2046.80,0.00,0.00,3.01,222.74,'2022-03-17 15:40:38','',''),(2651145,'1','197','1018',464,'Retail Sale Id 1642474',2747.20,0.00,0.00,4.04,298.96,'2022-03-17 15:47:33','',''),(2651146,'1','197','1018',464,'Retail Sale Id 1642475',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 15:50:03','',''),(2651147,'1','197','1018',464,'Retail Sale Id 1642476',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 15:52:22','',''),(2651148,'1','197','1018',464,'Retail Sale Id 1642477',34000.00,0.00,0.00,50.00,3700.00,'2022-03-17 16:14:28','',''),(2651149,'1','197','1018',464,'Retail Sale Id 1642478',4100.40,0.00,0.00,6.03,446.22,'2022-03-17 16:15:55','',''),(2651150,'1','197','1018',464,'Retail Sale Id 1642479',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 16:24:41','',''),(2651151,'1','197','1018',464,'Retail Sale Id 1642480',17000.00,0.00,0.00,25.00,1850.00,'2022-03-17 17:13:10','',''),(2651152,'1','197','1018',464,'Retail Sale Id 1642481',8500.00,0.00,0.00,12.50,925.00,'2022-03-17 17:14:17','',''),(2651153,'1','197','1018',464,'Retail Sale Id 1642482',1502.80,0.00,0.00,2.21,163.54,'2022-03-17 17:16:29','',''),(2651154,'1','197','1018',464,'Retail Sale Id 1642483',251124.00,0.00,0.00,369.30,27328.20,'2022-03-17 19:41:35','',''),(2651155,'1','197','1018',464,'Retail Sale Id 1642484',103603.20,0.00,0.00,161.88,5503.92,'2022-03-17 19:42:22','',''),(2651156,'1','197','1018',464,'Retail Sale Id 1642485',0.00,0.00,0.00,0.00,0.00,'2022-03-18 08:19:01','',''),(2651157,'1','197','1018',464,'Retail Sale Id 1642486',103360.00,0.00,0.00,170.00,340.00,'2022-03-18 12:38:22','',''),(2651158,'1','197','1018',464,'Retail Sale Id 1642487',0.00,0.00,0.00,0.00,0.00,'2022-03-18 12:39:08','',''),(2651159,'1','197','1018',464,'Retail Sale Id 1642488',74176.00,0.00,0.00,122.00,244.00,'2022-03-18 15:51:58','',''),(2651160,'1','197','1018',464,'Retail Sale Id 1642489',182400.00,0.00,0.00,300.00,600.00,'2022-03-18 15:53:07','',''),(2651161,'1','197','1018',464,'Retail Sale Id 1642490',8200.00,0.00,0.00,12.50,625.00,'2022-03-18 16:17:35','',''),(2651162,'1','197','1018',464,'Retail Sale Id 1642491',4001.60,0.00,0.00,6.10,305.00,'2022-03-18 16:19:36','',''),(2651163,'1','197','1018',464,'Retail Sale Id 1642492',16400.00,0.00,0.00,25.00,1250.00,'2022-03-18 16:21:10','',''),(2651164,'1','197','1018',464,'Retail Sale Id 1642493',8200.00,0.00,0.00,12.50,625.00,'2022-03-18 16:33:09','',''),(2651165,'1','197','1018',464,'Retail Sale Id 1642494',4001.60,0.00,0.00,6.10,305.00,'2022-03-18 16:55:23','',''),(2651166,'1','197','1018',464,'Retail Sale Id 1642495',8200.00,0.00,0.00,12.50,625.00,'2022-03-18 17:50:02','',''),(2651167,'1','197','1018',464,'Retail Sale Id 1642496',236212.48,0.00,0.00,360.08,18004.00,'2022-03-18 19:41:46','',''),(2651168,'1','197','1018',464,'Retail Sale Id 1642497',121533.12,0.00,0.00,199.89,399.78,'2022-03-18 19:43:41','',''),(2651169,'1','197','1018',464,'Retail Sale Id 1642498',0.00,0.00,0.00,0.00,0.00,'2022-03-19 08:09:58','',''),(2651170,'1','197','1018',464,'Retail Sale Id 1642499',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 08:12:47','',''),(2651171,'1','197','1018',464,'Retail Sale Id 1642500',4001.60,0.00,0.00,6.10,305.00,'2022-03-19 08:14:06','',''),(2651172,'1','197','1018',464,'Retail Sale Id 1642501',4001.60,0.00,0.00,6.10,305.00,'2022-03-19 08:15:45','',''),(2651173,'1','197','1018',464,'Retail Sale Id 1642502',6199.20,0.00,0.00,9.45,472.50,'2022-03-19 08:18:13','',''),(2651174,'1','197','1018',464,'Retail Sale Id 1642504',997.12,0.00,0.00,1.52,76.00,'2022-03-19 08:31:46','',''),(2651175,'1','197','1018',464,'Retail Sale Id 1642505',997.12,0.00,0.00,1.52,76.00,'2022-03-19 08:33:23','',''),(2651176,'1','197','1018',464,'Retail Sale Id 1642506',4998.72,0.00,0.00,7.62,381.00,'2022-03-19 08:41:42','',''),(2651177,'1','197','1018',464,'Retail Sale Id 1642507',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 08:46:11','',''),(2651178,'1','197','1018',464,'Retail Sale Id 1642508',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 08:48:11','',''),(2651179,'1','197','1018',464,'Retail Sale Id 1642509',7498.08,0.00,0.00,11.43,571.50,'2022-03-19 09:24:19','',''),(2651180,'1','197','1018',464,'Retail Sale Id 1642510',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 09:28:41','',''),(2651181,'1','197','1018',464,'Retail Sale Id 1642511',4001.60,0.00,0.00,6.10,305.00,'2022-03-19 09:41:27','',''),(2651182,'1','197','1018',464,'Retail Sale Id 1642512',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 09:45:50','',''),(2651183,'1','197','1018',464,'Retail Sale Id 1642513',4001.60,0.00,0.00,6.10,305.00,'2022-03-19 10:10:43','',''),(2651184,'1','197','1018',464,'Retail Sale Id 1642514',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 10:25:53','',''),(2651185,'1','197','1018',464,'Retail Sale Id 1642515',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 10:29:00','',''),(2651186,'1','197','1018',464,'Retail Sale Id 1642516',2801.12,0.00,0.00,4.27,213.50,'2022-03-19 10:40:53','',''),(2651187,'1','197','1018',464,'Retail Sale Id 1642517',2000.80,0.00,0.00,3.05,152.50,'2022-03-19 10:45:19','',''),(2651188,'1','197','1018',464,'Retail Sale Id 1642518',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 10:50:23','',''),(2651189,'1','197','1018',464,'Retail Sale Id 1642519',7544.00,0.00,0.00,11.50,575.00,'2022-03-19 10:51:43','',''),(2651190,'1','197','1018',464,'Retail Sale Id 1642520',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 10:57:21','',''),(2651191,'1','197','1018',464,'Retail Sale Id 1642521',158686.40,0.00,0.00,241.90,12095.00,'2022-03-19 11:14:10','',''),(2651192,'1','197','1018',464,'Retail Sale Id 1642522',9840.00,0.00,0.00,15.00,750.00,'2022-03-19 11:24:04','',''),(2651193,'1','197','1018',464,'Retail Sale Id 1642523',17397.12,0.00,0.00,26.52,1326.00,'2022-03-19 12:31:26','',''),(2651194,'1','197','1018',464,'Retail Sale Id 1642524',1902.40,0.00,0.00,2.90,145.00,'2022-03-19 12:42:13','',''),(2651195,'1','197','1018',464,'Retail Sale Id 1642525',6999.52,0.00,0.00,10.67,533.50,'2022-03-19 12:49:46','',''),(2651196,'1','197','1018',464,'Retail Sale Id 1642526',32800.00,0.00,0.00,50.00,2500.00,'2022-03-19 13:07:43','',''),(2651197,'1','197','1018',464,'Retail Sale Id 1642527',148957.92,0.00,0.00,227.07,11353.50,'2022-03-19 13:23:24','',''),(2651198,'1','197','1018',464,'Retail Sale Id 1642528',148960.00,0.00,0.00,245.00,490.00,'2022-03-19 13:26:44','',''),(2651199,'1','197','1018',464,'Retail Sale Id 1642529',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 17:02:48','',''),(2651200,'1','197','1018',464,'Retail Sale Id 1642530',4998.72,0.00,0.00,7.62,381.00,'2022-03-19 17:04:15','',''),(2651201,'1','197','1018',464,'Retail Sale Id 1642531',2000.80,0.00,0.00,3.05,152.50,'2022-03-19 17:05:56','',''),(2651202,'1','197','1018',464,'Retail Sale Id 1642532',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 17:10:37','',''),(2651203,'1','197','1018',464,'Retail Sale Id 1642533',8200.00,0.00,0.00,12.50,625.00,'2022-03-19 17:21:22','',''),(2651204,'1','197','1018',464,'Retail Sale Id 1642534',4001.60,0.00,0.00,6.10,305.00,'2022-03-19 17:33:29','',''),(2651205,'1','197','1018',464,'Return of Retail Sale Id 1642527',0.00,148957.92,227.07,0.00,-11353.50,'2022-03-19 19:58:03','',''),(2651206,'1','197','1018',464,'Return of Retail Sale Id 1642521',0.00,158686.40,241.90,0.00,-12095.00,'2022-03-19 19:59:10','',''),(2651207,'1','197','1018',464,'Return of Retail Sale Id 1642526',0.00,32800.00,50.00,0.00,-2500.00,'2022-03-19 20:00:18','',''),(2651208,'1','197','1018',464,'Retail Sale Id 1642535',127401.76,0.00,0.00,194.21,9710.50,'2022-03-19 20:04:36','',''),(2651209,'1','197','1018',464,'Retail Sale Id 1642536',182400.00,0.00,0.00,300.00,600.00,'2022-03-19 20:05:57','',''),(2651210,'1','197','1018',464,'Retail Sale Id 1642537',133383.04,0.00,0.00,219.38,438.76,'2022-03-19 20:06:37','',''),(2651211,'1','197','1018',464,'Retail Sale Id 1642538',12201.60,0.00,0.00,18.60,930.00,'2022-03-20 08:42:01','',''),(2651212,'1','197','1018',464,'Retail Sale Id 1642539',0.00,0.00,0.00,0.00,0.00,'2022-03-20 08:42:59','',''),(2651213,'1','197','1018',464,'Retail Sale Id 1642540',16400.00,0.00,0.00,25.00,1250.00,'2022-03-20 09:32:31','',''),(2651214,'1','197','1018',464,'Retail Sale Id 1642541',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 09:49:14','',''),(2651215,'1','197','1018',464,'Retail Sale Id 1642542',997.12,0.00,0.00,1.52,76.00,'2022-03-20 09:52:06','',''),(2651216,'1','197','1018',464,'Retail Sale Id 1642543',57152.00,0.00,0.00,94.00,188.00,'2022-03-20 10:09:21','',''),(2651217,'1','197','1018',464,'Retail Sale Id 1642544',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 10:16:38','',''),(2651218,'1','197','1018',464,'Retail Sale Id 1642545',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 10:30:22','',''),(2651219,'1','197','1018',464,'Retail Sale Id 1642546',9840.00,0.00,0.00,15.00,750.00,'2022-03-20 10:41:59','',''),(2651220,'1','197','1018',464,'Retail Sale Id 1642547',32800.00,0.00,0.00,50.00,2500.00,'2022-03-20 11:02:05','',''),(2651221,'1','197','1018',464,'Retail Sale Id 1642548',26752.00,0.00,0.00,44.00,88.00,'2022-03-20 11:22:47','',''),(2651222,'1','197','1018',464,'Retail Sale Id 1642549',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 11:27:58','',''),(2651223,'1','197','1018',464,'Retail Sale Id 1642550',2000.80,0.00,0.00,3.05,152.50,'2022-03-20 11:31:03','',''),(2651224,'1','197','1018',464,'Retail Sale Id 1642551',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 11:36:58','',''),(2651225,'1','197','1018',464,'Retail Sale Id 1642552',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 11:56:17','',''),(2651226,'1','197','1018',464,'Retail Sale Id 1642553',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 12:02:46','',''),(2651227,'1','197','1018',464,'Retail Sale Id 1642554',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 12:05:54','',''),(2651228,'1','197','1018',464,'Retail Sale Id 1642555',4001.60,0.00,0.00,6.10,305.00,'2022-03-20 12:14:22','',''),(2651229,'1','197','1018',464,'Retail Sale Id 1642556',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 12:19:12','',''),(2651230,'1','197','1018',464,'Retail Sale Id 1642557',2000.80,0.00,0.00,3.05,152.50,'2022-03-20 14:39:32','',''),(2651231,'1','197','1018',464,'Retail Sale Id 1642558',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 14:41:15','',''),(2651232,'1','197','1018',464,'Retail Sale Id 1642559',3503.04,0.00,0.00,5.34,267.00,'2022-03-20 14:52:40','',''),(2651233,'1','197','1018',464,'Retail Sale Id 1642560',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 15:06:44','',''),(2651234,'1','197','1018',464,'Retail Sale Id 1642561',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 15:08:04','',''),(2651235,'1','197','1018',464,'Retail Sale Id 1642562',63232.00,0.00,0.00,104.00,208.00,'2022-03-20 15:10:25','',''),(2651236,'1','197','1018',464,'Retail Sale Id 1642563',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 15:29:28','',''),(2651237,'1','197','1018',464,'Retail Sale Id 1642564',3280.00,0.00,0.00,5.00,250.00,'2022-03-20 15:31:08','',''),(2651238,'1','197','1018',464,'Retail Sale Id 1642565',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 15:46:48','',''),(2651239,'1','197','1018',464,'Retail Sale Id 1642566',8200.00,0.00,0.00,12.50,625.00,'2022-03-20 16:25:39','',''),(2651240,'1','197','1018',464,'Retail Sale Id 1642567',7786.72,0.00,0.00,11.87,593.50,'2022-03-20 16:48:17','',''),(2651241,'1','197','1018',464,'Retail Sale Id 1642569',4001.60,0.00,0.00,6.10,305.00,'2022-03-20 16:52:37','',''),(2651242,'1','197','1018',464,'Retail Sale Id 1642571',1200.48,0.00,0.00,1.83,91.50,'2022-03-21 00:32:10','',''),(2651243,'1','197','1018',464,'Retail Sale Id 1642572',111184.96,0.00,0.00,182.87,365.74,'2022-03-21 00:39:57','',''),(2651244,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,44504.64,73.44,0.00,0.00,'2022-03-21 00:49:20','',''),(2651245,'1','197',NULL,464,'Reception corrector for bridging 132603',0.00,0.00,0.00,73.44,0.00,'2022-03-21 00:51:16','',''),(2651246,'1','197','1018',464,'Received from bridging 132603',0.00,0.00,73.44,0.00,0.00,'2022-03-21 00:51:16','',''),(2651247,'1','197','1018',464,'Retail Sale Id 1642573',44651.52,0.00,0.00,73.44,146.88,'2022-03-21 00:52:09','',''),(2651248,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2995980.00,5010.00,0.00,0.00,'2022-03-21 11:55:22','',''),(2651249,'1','197',NULL,464,'Reception corrector for bridging 132604',0.00,0.00,0.00,5010.00,0.00,'2022-03-21 11:58:22','',''),(2651250,'1','197','1018',464,'Received from bridging 132604',0.00,0.00,5010.00,0.00,0.00,'2022-03-21 11:58:22','',''),(2651251,'1','197','1018',464,'Retail Sale Id 1642574',8200.00,0.00,0.00,12.50,725.00,'2022-03-21 12:09:15','',''),(2651252,'1','197','1018',464,'Retail Sale Id 1642575',8200.00,0.00,0.00,12.50,725.00,'2022-03-21 12:10:38','',''),(2651253,'1','197','1018',464,'Retail Sale Id 1642576',8200.00,0.00,0.00,12.50,725.00,'2022-03-21 12:12:18','',''),(2651254,'1','197','1018',464,'Retail Sale Id 1642577',91200.00,0.00,0.00,150.00,1500.00,'2022-03-21 12:13:17','',''),(2651255,'1','197','1018',464,'Retail Sale Id 1642578',4001.60,0.00,0.00,6.10,353.80,'2022-03-21 12:20:57','',''),(2651256,'1','197','1018',464,'Retail Sale Id 1642579',16400.00,0.00,0.00,25.00,1450.00,'2022-03-21 12:48:12','',''),(2651257,'1','197','1018',464,'Retail Sale Id 1642580',11001.12,0.00,0.00,16.77,972.66,'2022-03-21 12:52:24','',''),(2651258,'1','197','1018',464,'Retail Sale Id 1642581',8200.00,0.00,0.00,12.50,725.00,'2022-03-21 13:09:14','',''),(2651259,'1','197','1018',464,'Retail Sale Id 1642582',4001.60,0.00,0.00,6.10,353.80,'2022-03-21 13:33:19','',''),(2651260,'1','197','1018',464,'Retail Sale Id 1642583',701.92,0.00,0.00,1.07,62.06,'2022-03-21 13:49:33','',''),(2651261,'1','197','1018',464,'Retail Sale Id 1642584',32800.00,0.00,0.00,50.00,2900.00,'2022-03-21 14:03:23','',''),(2651262,'1','197','1018',464,'Retail Sale Id 1642585',20998.56,0.00,0.00,32.01,1856.58,'2022-03-21 14:49:46','',''),(2651263,'1','197','1018',464,'Retail Sale Id 1642586',8003.20,0.00,0.00,12.20,707.60,'2022-03-21 15:03:45','',''),(2651264,'1','197','1018',464,'Retail Sale Id 1642587',2997.92,0.00,0.00,4.57,265.06,'2022-03-21 15:22:19','',''),(2651265,'1','197','1018',464,'Retail Sale Id 1642588',35264.00,0.00,0.00,58.00,580.00,'2022-03-21 15:30:16','',''),(2651266,'1','197','1018',464,'Retail Sale Id 1642589',2997.92,0.00,0.00,4.57,265.06,'2022-03-21 15:50:53','',''),(2651267,'1','197','1018',464,'Retail Sale Id 1642590',4001.60,0.00,0.00,6.10,353.80,'2022-03-21 16:19:52','',''),(2651268,'1','197','1018',464,'Retail Sale Id 1642591',4500.16,0.00,0.00,6.86,397.88,'2022-03-21 16:51:52','',''),(2651269,'1','197','1018',464,'Retail Sale Id 1642592',4500.16,0.00,0.00,6.86,397.88,'2022-03-21 16:53:04','',''),(2651270,'1','197','1018',464,'Retail Sale Id 1642593',3201.28,0.00,0.00,4.88,283.04,'2022-03-21 17:06:56','',''),(2651271,'1','197','1018',464,'Retail Sale Id 1642594',4001.60,0.00,0.00,6.10,353.80,'2022-03-21 17:15:09','',''),(2651272,'1','197','1018',464,'Retail Sale Id 1642595',8200.00,0.00,0.00,12.50,725.00,'2022-03-21 17:18:24','',''),(2651273,'1','197','1018',464,'Retail Sale Id 1642596',4001.60,0.00,0.00,6.10,353.80,'2022-03-21 17:29:34','',''),(2651274,'1','197','1018',464,'Retail Sale Id 1642597',4001.60,0.00,0.00,6.10,353.80,'2022-03-21 17:32:34','',''),(2651275,'1','197','1018',464,'Retail Sale Id 1642598',12201.60,0.00,0.00,18.60,1078.80,'2022-03-21 17:37:09','',''),(2651276,'1','197','1018',464,'Retail Sale Id 1642599',3299.68,0.00,0.00,5.03,291.74,'2022-03-21 17:47:11','',''),(2651277,'1','197','1018',464,'Retail Sale Id 1642600',16400.00,0.00,0.00,25.00,1450.00,'2022-03-21 17:55:17','',''),(2651278,'1','197','1018',464,'Retail Sale Id 1642601',4100.00,0.00,0.00,6.25,362.50,'2022-03-21 17:57:54','',''),(2651279,'1','197','1018',464,'Retail Sale Id 1642602',8200.00,0.00,0.00,12.50,725.00,'2022-03-21 18:00:53','',''),(2651280,'1','197','1018',464,'Retail Sale Id 1642603',0.00,0.00,0.00,0.00,0.00,'2022-03-21 18:02:36','',''),(2651281,'1','197','1018',464,'Retail Sale Id 1642604',2997.92,0.00,0.00,4.57,265.06,'2022-03-21 18:05:52','',''),(2651282,'1','197','1018',464,'Retail Sale Id 1642605',126667.04,0.00,0.00,193.09,11199.22,'2022-03-22 00:42:27','',''),(2651283,'1','197','1018',464,'Retail Sale Id 1642606',59687.36,0.00,0.00,98.17,981.70,'2022-03-22 00:44:03','',''),(2651284,'1','197','1018',464,'Retail Sale Id 1642607',0.00,0.00,0.00,0.00,0.00,'2022-03-22 08:21:23','',''),(2651285,'1','197','1018',464,'Retail Sale Id 1642608',170848.00,0.00,0.00,281.00,2810.00,'2022-03-22 11:09:09','',''),(2651286,'1','197','1018',464,'Retail Sale Id 1642609',3299.68,0.00,0.00,5.03,291.74,'2022-03-22 11:12:25','',''),(2651287,'1','197','1018',464,'Retail Sale Id 1642610',8200.00,0.00,0.00,12.50,725.00,'2022-03-22 11:13:52','',''),(2651288,'1','197','1018',464,'Retail Sale Id 1642612',275159.20,0.00,0.00,419.45,24328.10,'2022-03-22 23:52:06','',''),(2651289,'1','197','1018',464,'Retail Sale Id 1642613',243200.00,0.00,0.00,400.00,4000.00,'2022-03-22 23:53:22','',''),(2651290,'1','197','1018',464,'Retail Sale Id 1642614',241783.36,0.00,0.00,397.67,3976.70,'2022-03-22 23:54:02','',''),(2651291,'1','197','1018',464,'Retail Sale Id 1642615',121600.00,0.00,0.00,200.00,2000.00,'2022-03-22 23:54:44','',''),(2651292,'1','197','1018',464,'Retail Sale Id 1642616',2000.80,0.00,0.00,3.05,176.90,'2022-03-23 10:12:17','',''),(2651293,'1','197','1018',464,'Retail Sale Id 1642616',2000.80,0.00,0.00,3.05,176.90,'2022-03-23 10:12:17','',''),(2651294,'1','197','1018',464,'Retail Sale Id 1642616',2000.80,0.00,0.00,3.05,176.90,'2022-03-23 10:12:17','',''),(2651295,'1','197','1018',464,'Retail Sale Id 1642617',0.00,0.00,0.00,0.00,0.00,'2022-03-23 10:13:15','',''),(2651296,'1','197','1018',464,'Retail Sale Id 1642618',8200.00,0.00,0.00,12.50,725.00,'2022-03-23 10:18:33','',''),(2651297,'1','197','1018',464,'Retail Sale Id 1642619',8200.00,0.00,0.00,12.50,725.00,'2022-03-23 10:45:13','',''),(2651298,'1','197','1018',464,'Retail Sale Id 1642620',4001.60,0.00,0.00,6.10,353.80,'2022-03-23 11:34:29','',''),(2651299,'1','197','1018',464,'Retail Sale Id 1642621',3299.68,0.00,0.00,5.03,291.74,'2022-03-23 11:37:10','',''),(2651300,'1','197','1018',464,'Retail Sale Id 1642623',4001.60,0.00,0.00,6.10,353.80,'2022-03-23 12:35:21','',''),(2651301,'1','197','1018',464,'Retail Sale Id 1642623',4001.60,0.00,0.00,6.10,353.80,'2022-03-23 12:35:21','',''),(2651302,'1','197','1018',464,'Retail Sale Id 1642624',125856.00,0.00,0.00,207.00,2070.00,'2022-03-23 12:38:31','',''),(2651303,'1','197','1018',464,'Retail Sale Id 1642625',2000.80,0.00,0.00,3.05,176.90,'2022-03-23 13:07:36','',''),(2651304,'1','197','1018',464,'Retail Sale Id 1642626',8200.00,0.00,0.00,12.50,725.00,'2022-03-23 13:20:55','',''),(2651305,'1','197','1018',464,'Retail Sale Id 1642627',35264.00,0.00,0.00,58.00,580.00,'2022-03-23 13:29:39','',''),(2651306,'1','197','1018',464,'Retail Sale Id 1642628',148960.00,0.00,0.00,245.00,2450.00,'2022-03-23 13:54:29','',''),(2651307,'1','197','1018',464,'Retail Sale Id 1642629',3280.00,0.00,0.00,5.00,290.00,'2022-03-23 14:00:38','',''),(2651308,'1','197','1018',464,'Retail Sale Id 1642630',3280.00,0.00,0.00,5.00,290.00,'2022-03-23 14:13:58','',''),(2651309,'1','197','1018',464,'Retail Sale Id 1642631',8200.00,0.00,0.00,12.50,725.00,'2022-03-23 14:43:01','',''),(2651310,'1','197','1018',464,'Retail Sale Id 1642632',4001.60,0.00,0.00,6.10,353.80,'2022-03-23 15:02:18','',''),(2651311,'1','197','1018',464,'Retail Sale Id 1642633',107616.00,0.00,0.00,177.00,1770.00,'2022-03-23 15:04:14','',''),(2651312,'1','197','1018',464,'Retail Sale Id 1642634',2997.92,0.00,0.00,4.57,265.06,'2022-03-23 15:06:00','',''),(2651313,'1','197','1018',464,'Retail Sale Id 1642635',725988.00,0.00,0.00,1198.00,9584.00,'2022-03-23 16:36:43','',''),(2651314,'1','197','1018',464,'Retail Sale Id 1642636',2702.72,0.00,0.00,4.12,238.96,'2022-03-23 16:45:58','',''),(2651315,'1','197','1018',464,'Retail Sale Id 1642637',8200.00,0.00,0.00,12.50,725.00,'2022-03-23 16:52:53','',''),(2651316,'1','197','1018',464,'Retail Sale Id 1642638',4001.60,0.00,0.00,6.10,353.80,'2022-03-23 16:53:25','',''),(2651317,'1','197','1018',464,'Retail Sale Id 1642639',3299.68,0.00,0.00,5.03,291.74,'2022-03-23 17:14:33','',''),(2651318,'1','197','1018',464,'Retail Sale Id 1642640',4001.60,0.00,0.00,6.10,353.80,'2022-03-23 17:33:04','',''),(2651319,'1','197','1018',464,'Retail Sale Id 1642641',8200.00,0.00,0.00,12.50,725.00,'2022-03-23 17:35:10','',''),(2651320,'1','197','1018',464,'Retail Sale Id 1642642',101575.04,0.00,0.00,154.84,8980.72,'2022-03-23 19:07:17','',''),(2651321,'1','197','1018',464,'Retail Sale Id 1642643',40255.68,0.00,0.00,66.21,662.10,'2022-03-23 19:09:45','',''),(2651322,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350284',119994.68,0.00,0.00,200.66,0.00,'2022-03-24 08:21:22','',''),(2651323,'1','197',NULL,464,'Purchased from EVER BEST GAS',0.00,2954120.00,4940.00,0.00,0.00,'2022-03-24 08:26:19','',''),(2651324,'1','197',NULL,464,'Reception corrector for bridging 132605',0.00,0.00,0.00,4940.00,0.00,'2022-03-24 08:28:21','',''),(2651325,'1','197','1018',464,'Received from bridging 132605',0.00,0.00,4940.00,0.00,0.00,'2022-03-24 08:28:21','',''),(2651326,'1','197','1018',464,'Retail Sale Id 1642644',2997.92,0.00,0.00,4.57,265.06,'2022-03-24 08:30:00','',''),(2651327,'1','197','1018',464,'Retail Sale Id 1642645',4998.72,0.00,0.00,7.62,441.96,'2022-03-24 08:31:02','',''),(2651328,'1','197','1018',464,'Retail Sale Id 1642646',16400.00,0.00,0.00,25.00,1450.00,'2022-03-24 08:31:37','',''),(2651329,'1','197','1018',464,'Retail Sale Id 1642647',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 08:32:53','',''),(2651330,'1','197','1018',464,'Retail Sale Id 1642648',22800.00,0.00,0.00,37.50,375.00,'2022-03-24 08:33:44','',''),(2651331,'1','197','1018',464,'Retail Sale Id 1642649',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 08:34:20','',''),(2651332,'1','197','1018',464,'Retail Sale Id 1642650',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 08:53:34','',''),(2651333,'1','197','1018',464,'Retail Sale Id 1642651',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 08:59:55','',''),(2651334,'1','197','1018',464,'Retail Sale Id 1642652',13120.00,0.00,0.00,20.00,1160.00,'2022-03-24 10:04:29','',''),(2651335,'1','197','1018',464,'Retail Sale Id 1642653',2000.80,0.00,0.00,3.05,176.90,'2022-03-24 10:12:28','',''),(2651336,'1','197','1018',464,'Retail Sale Id 1642654',2000.80,0.00,0.00,3.05,176.90,'2022-03-24 10:50:51','',''),(2651337,'1','197','1018',464,'Retail Sale Id 1642655',2000.80,0.00,0.00,3.05,176.90,'2022-03-24 10:51:46','',''),(2651338,'1','197','1018',464,'Retail Sale Id 1642656',16400.00,0.00,0.00,25.00,1450.00,'2022-03-24 10:57:13','',''),(2651339,'1','197','1018',464,'Retail Sale Id 1642657',7498.08,0.00,0.00,11.43,662.94,'2022-03-24 11:06:34','',''),(2651340,'1','197','1018',464,'Retail Sale Id 1642659',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 11:54:37','',''),(2651341,'1','197','1018',464,'Retail Sale Id 1642660',1502.24,0.00,0.00,2.29,132.82,'2022-03-24 11:56:27','',''),(2651342,'1','197','1018',464,'Retail Sale Id 1642661',1502.24,0.00,0.00,2.29,132.82,'2022-03-24 11:59:03','',''),(2651343,'1','197','1018',464,'Retail Sale Id 1642662',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 12:25:00','',''),(2651344,'1','197','1018',464,'Retail Sale Id 1642663',4998.72,0.00,0.00,7.62,441.96,'2022-03-24 12:25:42','',''),(2651345,'1','197','1018',464,'Retail Sale Id 1642664',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 12:35:55','',''),(2651346,'1','197','1018',464,'Retail Sale Id 1642665',32800.00,0.00,0.00,50.00,2900.00,'2022-03-24 13:04:01','',''),(2651347,'1','197','1018',464,'Retail Sale Id 1642666',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 13:04:36','',''),(2651348,'1','197','1018',464,'Retail Sale Id 1642667',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 13:07:27','',''),(2651349,'1','197','1018',464,'Retail Sale Id 1642668',27360.00,0.00,0.00,45.00,450.00,'2022-03-24 13:54:47','',''),(2651350,'1','197','1018',464,'Retail Sale Id 1642669',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 13:57:00','',''),(2651351,'1','197','1018',464,'Retail Sale Id 1642670',91200.00,0.00,0.00,150.00,1500.00,'2022-03-24 13:57:49','',''),(2651352,'1','197','1018',464,'Retail Sale Id 1642671',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 14:00:05','',''),(2651353,'1','197','1018',464,'Retail Sale Id 1642672',15101.12,0.00,0.00,23.02,1335.16,'2022-03-24 14:06:17','',''),(2651354,'1','197','1018',464,'Retail Sale Id 1642673',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 14:14:16','',''),(2651355,'1','197','1018',464,'Retail Sale Id 1642674',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 14:29:35','',''),(2651356,'1','197','1018',464,'Retail Sale Id 1642675',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 14:43:55','',''),(2651357,'1','197','1018',464,'Retail Sale Id 1642676',6999.52,0.00,0.00,10.67,618.86,'2022-03-24 14:45:57','',''),(2651358,'1','197','1018',464,'Retail Sale Id 1642677',88160.00,0.00,0.00,145.00,1450.00,'2022-03-24 15:07:33','',''),(2651359,'1','197','1018',464,'Retail Sale Id 1642678',4998.72,0.00,0.00,7.62,441.96,'2022-03-24 15:11:15','',''),(2651360,'1','197','1018',464,'Retail Sale Id 1642679',12201.60,0.00,0.00,18.60,1078.80,'2022-03-24 15:35:37','',''),(2651361,'1','197','1018',464,'Retail Sale Id 1642680',4998.72,0.00,0.00,7.62,441.96,'2022-03-24 15:50:48','',''),(2651362,'1','197','1018',464,'Retail Sale Id 1642682',3299.68,0.00,0.00,5.03,291.74,'2022-03-24 15:53:32','',''),(2651363,'1','197','1018',464,'Retail Sale Id 1642683',1502.24,0.00,0.00,2.29,132.82,'2022-03-24 16:14:17','',''),(2651364,'1','197','1018',464,'Retail Sale Id 1642684',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 16:45:08','',''),(2651365,'1','197','1018',464,'Retail Sale Id 1642685',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 16:49:38','',''),(2651366,'1','197','1018',464,'Retail Sale Id 1642686',2000.80,0.00,0.00,3.05,176.90,'2022-03-24 17:04:17','',''),(2651367,'1','197','1018',464,'Retail Sale Id 1642687',13120.00,0.00,0.00,20.00,1160.00,'2022-03-24 17:11:21','',''),(2651368,'1','197','1018',464,'Retail Sale Id 1642688',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 17:14:58','',''),(2651369,'1','197','1018',464,'Retail Sale Id 1642689',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 17:23:11','',''),(2651370,'1','197','1018',464,'Retail Sale Id 1642690',2997.92,0.00,0.00,4.57,265.06,'2022-03-24 17:32:45','',''),(2651371,'1','197','1018',464,'Retail Sale Id 1642691',1502.24,0.00,0.00,2.29,132.82,'2022-03-24 17:34:16','',''),(2651372,'1','197','1018',464,'Retail Sale Id 1642692',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 17:44:29','',''),(2651373,'1','197','1018',464,'Retail Sale Id 1642693',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 18:05:32','',''),(2651374,'1','197','1018',464,'Retail Sale Id 1642694',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 18:07:15','',''),(2651375,'1','197','1018',464,'Retail Sale Id 1642695',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 18:10:31','',''),(2651376,'1','197','1018',464,'Retail Sale Id 1642696',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 18:19:30','',''),(2651377,'1','197','1018',464,'Retail Sale Id 1642697',1502.24,0.00,0.00,2.29,132.82,'2022-03-24 18:24:11','',''),(2651378,'1','197','1018',464,'Retail Sale Id 1642698',3299.68,0.00,0.00,5.03,291.74,'2022-03-24 18:24:38','',''),(2651379,'1','197','1018',464,'Retail Sale Id 1642699',8200.00,0.00,0.00,12.50,725.00,'2022-03-24 18:33:33','',''),(2651380,'1','197','1018',464,'Retail Sale Id 1642700',2000.80,0.00,0.00,3.05,176.90,'2022-03-24 18:34:49','',''),(2651381,'1','197','1018',464,'Retail Sale Id 1642701',4001.60,0.00,0.00,6.10,353.80,'2022-03-24 18:37:07','',''),(2651382,'1','197','1018',464,'Retail Sale Id 1642701',16400.00,0.00,0.00,25.00,1450.00,'2022-03-24 18:37:07','',''),(2651383,'1','197','1018',464,'Retail Sale Id 1642702',997.12,0.00,0.00,1.52,88.16,'2022-03-24 18:56:50','',''),(2651384,'1','197','1018',464,'Retail Sale Id 1642703',13592.32,0.00,0.00,20.72,1201.76,'2022-03-24 19:58:15','',''),(2651385,'1','197','1018',464,'Retail Sale Id 1642704',105196.16,0.00,0.00,173.02,1730.20,'2022-03-24 20:00:33','',''),(2651386,'1','197','1018',464,'Retail Sale Id 1642705',6999.52,0.00,0.00,10.67,618.86,'2022-03-25 07:41:19','',''),(2651387,'1','197','1018',464,'Retail Sale Id 1642706',121600.00,0.00,0.00,200.00,2000.00,'2022-03-25 07:43:33','',''),(2651388,'1','197','1018',464,'Retail Sale Id 1642707',2000.80,0.00,0.00,3.05,176.90,'2022-03-25 07:45:01','',''),(2651389,'1','197','1018',464,'Retail Sale Id 1642708',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 07:45:35','',''),(2651390,'1','197','1018',464,'Retail Sale Id 1642709',3599.36,0.00,0.00,5.92,59.20,'2022-03-25 07:49:13','',''),(2651391,'1','197','1018',464,'Retail Sale Id 1642710',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 07:57:07','',''),(2651392,'1','197','1018',464,'Retail Sale Id 1642711',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 08:14:40','',''),(2651393,'1','197','1018',464,'Retail Sale Id 1642712',6560.00,0.00,0.00,10.00,580.00,'2022-03-25 08:25:34','',''),(2651394,'1','197','1018',464,'Retail Sale Id 1642713',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 08:27:38','',''),(2651395,'1','197','1018',464,'Retail Sale Id 1642714',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 08:31:37','',''),(2651396,'1','197','1018',464,'Retail Sale Id 1642714',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 08:31:37','',''),(2651397,'1','197','1018',464,'Retail Sale Id 1642715',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 08:34:55','',''),(2651398,'1','197','1018',464,'Retail Sale Id 1642716',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 08:38:04','',''),(2651399,'1','197','1018',464,'Retail Sale Id 1642717',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 09:42:01','',''),(2651400,'1','197','1018',464,'Retail Sale Id 1642718',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 09:48:38','',''),(2651401,'1','197','1018',464,'Retail Sale Id 1642719',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 09:49:18','',''),(2651402,'1','197','1018',464,'Retail Sale Id 1642720',166592.00,0.00,0.00,274.00,2740.00,'2022-03-25 10:20:04','',''),(2651403,'1','197','1018',464,'Retail Sale Id 1642721',3319.36,0.00,0.00,5.06,293.48,'2022-03-25 10:21:46','',''),(2651404,'1','197','1018',464,'Retail Sale Id 1642722',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 10:35:34','',''),(2651405,'1','197','1018',464,'Retail Sale Id 1642723',12201.60,0.00,0.00,18.60,1078.80,'2022-03-25 10:45:44','',''),(2651406,'1','197','1018',464,'Retail Sale Id 1642724',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 11:03:20','',''),(2651407,'1','197','1018',464,'Retail Sale Id 1642725',2000.80,0.00,0.00,3.05,176.90,'2022-03-25 11:15:59','',''),(2651408,'1','197','1018',464,'Retail Sale Id 1642726',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 11:21:48','',''),(2651409,'1','197','1018',464,'Retail Sale Id 1642727',2000.80,0.00,0.00,3.05,176.90,'2022-03-25 11:43:21','',''),(2651410,'1','197','1018',464,'Retail Sale Id 1642728',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 11:56:23','',''),(2651411,'1','197','1018',464,'Retail Sale Id 1642729',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 12:57:09','',''),(2651412,'1','197','1018',464,'Retail Sale Id 1642730',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 13:01:53','',''),(2651413,'1','197','1018',464,'Retail Sale Id 1642731',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 14:10:44','',''),(2651414,'1','197','1018',464,'Retail Sale Id 1642732',16400.00,0.00,0.00,25.00,1450.00,'2022-03-25 15:09:37','',''),(2651415,'1','197','1018',464,'Retail Sale Id 1642733',2000.80,0.00,0.00,3.05,176.90,'2022-03-25 15:18:36','',''),(2651416,'1','197','1018',464,'Retail Sale Id 1642734',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 15:33:27','',''),(2651417,'1','197','1018',464,'Retail Sale Id 1642735',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 15:34:43','',''),(2651418,'1','197','1018',464,'Retail Sale Id 1642736',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 15:50:46','',''),(2651419,'1','197','1018',464,'Retail Sale Id 1642737',997.12,0.00,0.00,1.52,88.16,'2022-03-25 16:15:09','',''),(2651420,'1','197','1018',464,'Retail Sale Id 1642738',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 16:18:55','',''),(2651421,'1','197','1018',464,'Retail Sale Id 1642739',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 16:27:27','',''),(2651422,'1','197','1018',464,'Retail Sale Id 1642740',2000.80,0.00,0.00,3.05,176.90,'2022-03-25 16:55:43','',''),(2651423,'1','197','1018',464,'Retail Sale Id 1642741',2499.36,0.00,0.00,3.81,220.98,'2022-03-25 17:07:53','',''),(2651424,'1','197','1018',464,'Retail Sale Id 1642742',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 17:10:23','',''),(2651425,'1','197','1018',464,'Retail Sale Id 1642743',4998.72,0.00,0.00,7.62,441.96,'2022-03-25 17:10:52','',''),(2651426,'1','197','1018',464,'Retail Sale Id 1642744',6999.52,0.00,0.00,10.67,618.86,'2022-03-25 17:11:21','',''),(2651427,'1','197','1018',464,'Retail Sale Id 1642745',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 17:21:29','',''),(2651428,'1','197','1018',464,'Retail Sale Id 1642746',2997.92,0.00,0.00,4.57,265.06,'2022-03-25 17:26:56','',''),(2651429,'1','197','1018',464,'Retail Sale Id 1642747',997.12,0.00,0.00,1.52,88.16,'2022-03-25 17:31:24','',''),(2651430,'1','197','1018',464,'Retail Sale Id 1642748',31002.56,0.00,0.00,47.26,2741.08,'2022-03-25 17:33:22','',''),(2651431,'1','197','1018',464,'Retail Sale Id 1642749',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 17:36:44','',''),(2651432,'1','197','1018',464,'Retail Sale Id 1642750',4998.72,0.00,0.00,7.62,441.96,'2022-03-25 17:38:07','',''),(2651433,'1','197','1018',464,'Retail Sale Id 1642751',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 17:38:52','',''),(2651434,'1','197','1018',464,'Retail Sale Id 1642752',57400.00,0.00,0.00,87.50,5075.00,'2022-03-25 17:50:27','',''),(2651435,'1','197','1018',464,'Retail Sale Id 1642753',4001.60,0.00,0.00,6.10,353.80,'2022-03-25 17:50:57','',''),(2651436,'1','197','1018',464,'Retail Sale Id 1642754',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 17:54:11','',''),(2651437,'1','197','1018',464,'Return of Retail Sale Id 1642752',0.00,57400.00,87.50,0.00,-5075.00,'2022-03-25 17:55:15','',''),(2651438,'1','197','1018',464,'Retail Sale Id 1642755',344128.00,0.00,0.00,566.00,5660.00,'2022-03-25 17:58:05','',''),(2651439,'1','197','1018',464,'Retail Sale Id 1642756',8003.20,0.00,0.00,12.20,707.60,'2022-03-25 18:09:25','',''),(2651440,'1','197','1018',464,'Retail Sale Id 1642757',30832.00,0.00,0.00,47.00,2726.00,'2022-03-25 18:37:39','',''),(2651441,'1','197','1018',464,'Retail Sale Id 1642758',8200.00,0.00,0.00,12.50,725.00,'2022-03-25 18:38:01','',''),(2651442,'1','197','1018',464,'Retail Sale Id 1642759',41000.00,0.00,0.00,62.50,3625.00,'2022-03-25 18:39:32','',''),(2651443,'1','197','1018',464,'Retail Sale Id 1642760',2997.92,0.00,0.00,4.57,265.06,'2022-03-25 18:44:57','',''),(2651444,'1','197','1018',464,'Retail Sale Id 1642761',2499.36,0.00,0.00,3.81,220.98,'2022-03-25 18:51:11','',''),(2651445,'1','197','1018',464,'Retail Sale Id 1642763',2000.80,0.00,0.00,3.05,176.90,'2022-03-25 19:01:46','',''),(2651446,'1','197','1018',464,'Return of Retail Sale Id 1642757',0.00,30832.00,47.00,0.00,-2726.00,'2022-03-25 20:16:42','',''),(2651447,'1','197','1018',464,'Retail Sale Id 1642764',9800.64,0.00,0.00,14.94,866.52,'2022-03-25 20:18:19','',''),(2651448,'1','197','1018',464,'Retail Sale Id 1642765',190571.52,0.00,0.00,313.44,3134.40,'2022-03-25 20:20:09','',''),(2651449,'1','197','1018',464,'Retail Sale Id 1642766',4001.60,0.00,0.00,6.10,353.80,'2022-03-26 07:36:03','',''),(2651450,'1','197','1018',464,'Retail Sale Id 1642767',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 07:37:03','',''),(2651451,'1','197','1018',464,'Retail Sale Id 1642768',7498.08,0.00,0.00,11.43,662.94,'2022-03-26 07:48:33','',''),(2651452,'1','197','1018',464,'Retail Sale Id 1642769',4001.60,0.00,0.00,6.10,353.80,'2022-03-26 08:14:57','',''),(2651453,'1','197','1018',464,'Retail Sale Id 1642769',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 08:14:57','',''),(2651454,'1','197','1018',464,'Retail Sale Id 1642770',997.12,0.00,0.00,1.52,88.16,'2022-03-26 08:23:22','',''),(2651455,'1','197','1018',464,'Retail Sale Id 1642771',0.00,0.00,0.00,0.00,0.00,'2022-03-26 08:24:09','',''),(2651456,'1','197','1018',464,'Retail Sale Id 1642772',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 10:27:56','',''),(2651457,'1','197','1018',464,'Retail Sale Id 1642774',1502.24,0.00,0.00,2.29,132.82,'2022-03-26 10:28:57','',''),(2651458,'1','197','1018',464,'Retail Sale Id 1642775',5904.00,0.00,0.00,9.00,522.00,'2022-03-26 10:34:18','',''),(2651459,'1','197','1018',464,'Retail Sale Id 1642778',2000.80,0.00,0.00,3.05,176.90,'2022-03-26 11:05:20','',''),(2651460,'1','197','1018',464,'Retail Sale Id 1642779',13120.00,0.00,0.00,20.00,1160.00,'2022-03-26 12:46:24','',''),(2651461,'1','197','1018',464,'Retail Sale Id 1642780',4001.60,0.00,0.00,6.10,353.80,'2022-03-26 12:48:28','',''),(2651462,'1','197','1018',464,'Retail Sale Id 1642781',4001.60,0.00,0.00,6.10,353.80,'2022-03-26 13:14:24','',''),(2651463,'1','197','1018',464,'Retail Sale Id 1642782',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 14:07:34','',''),(2651464,'1','197','1018',464,'Retail Sale Id 1642784',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 15:10:43','',''),(2651465,'1','197','1018',464,'Retail Sale Id 1642785',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 15:18:43','',''),(2651466,'1','197','1018',464,'Retail Sale Id 1642786',2997.92,0.00,0.00,4.57,265.06,'2022-03-26 16:18:53','',''),(2651467,'1','197','1018',464,'Retail Sale Id 1642787',4001.60,0.00,0.00,6.10,353.80,'2022-03-26 16:23:43','',''),(2651468,'1','197','1018',464,'Retail Sale Id 1642788',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 16:27:54','',''),(2651469,'1','197','1018',464,'Retail Sale Id 1642789',13120.00,0.00,0.00,20.00,1160.00,'2022-03-26 16:37:44','',''),(2651470,'1','197','1018',464,'Retail Sale Id 1642790',3299.68,0.00,0.00,5.03,291.74,'2022-03-26 17:43:17','',''),(2651471,'1','197','1018',464,'Retail Sale Id 1642791',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 17:44:25','',''),(2651472,'1','197','1018',464,'Retail Sale Id 1642792',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 17:53:27','',''),(2651473,'1','197','1018',464,'Retail Sale Id 1642793',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 17:54:36','',''),(2651474,'1','197','1018',464,'Retail Sale Id 1642795',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 17:56:51','',''),(2651475,'1','197','1018',464,'Retail Sale Id 1642796',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 18:44:17','',''),(2651476,'1','197','1018',464,'Retail Sale Id 1642797',2000.80,0.00,0.00,3.05,176.90,'2022-03-26 18:45:10','',''),(2651477,'1','197','1018',464,'Retail Sale Id 1642798',4001.60,0.00,0.00,6.10,353.80,'2022-03-26 18:46:00','',''),(2651478,'1','197','1018',464,'Retail Sale Id 1642799',8200.00,0.00,0.00,12.50,725.00,'2022-03-26 18:48:47','',''),(2651479,'1','197','1018',464,'Retail Sale Id 1642800',997.12,0.00,0.00,1.52,88.16,'2022-03-26 18:59:24','',''),(2651480,'1','197','1018',464,'Retail Sale Id 1642801',149390.88,0.00,0.00,227.73,13208.34,'2022-03-26 20:07:59','',''),(2651481,'1','197','1018',464,'Retail Sale Id 1642802',182400.00,0.00,0.00,300.00,3000.00,'2022-03-26 20:14:20','',''),(2651482,'1','197','1018',464,'Retail Sale Id 1642803',249492.80,0.00,0.00,410.35,4103.50,'2022-03-26 20:17:04','',''),(2651483,'1','197','1018',464,'Retail Sale Id 1642805',8200.00,0.00,0.00,12.50,725.00,'2022-03-27 07:50:29','',''),(2651484,'1','197','1018',464,'Retail Sale Id 1642806',8200.00,0.00,0.00,12.50,725.00,'2022-03-27 07:51:24','',''),(2651485,'1','197','1018',464,'Retail Sale Id 1642807',2997.92,0.00,0.00,4.57,265.06,'2022-03-27 07:51:47','',''),(2651486,'1','197','1018',464,'Retail Sale Id 1642808',15200.00,0.00,0.00,25.00,250.00,'2022-03-27 07:55:59','',''),(2651487,'1','197','1018',464,'Retail Sale Id 1642809',8200.00,0.00,0.00,12.50,725.00,'2022-03-27 07:56:31','',''),(2651488,'1','197','1018',464,'Retail Sale Id 1642810',2000.80,0.00,0.00,3.05,176.90,'2022-03-27 08:18:07','',''),(2651489,'1','197','1018',464,'Retail Sale Id 1642811',8003.20,0.00,0.00,12.20,707.60,'2022-03-27 08:40:25','',''),(2651490,'1','197','1018',464,'Retail Sale Id 1642812',2000.80,0.00,0.00,3.05,176.90,'2022-03-27 08:46:40','',''),(2651491,'1','197','1018',464,'Retail Sale Id 1642813',1797.44,0.00,0.00,2.74,158.92,'2022-03-27 08:47:07','',''),(2651492,'1','197','1018',464,'Retail Sale Id 1642814',24600.00,0.00,0.00,37.50,2175.00,'2022-03-27 09:03:21','',''),(2651493,'1','197','1018',464,'Return of Retail Sale Id 1642814',0.00,24600.00,37.50,0.00,-2175.00,'2022-03-27 10:05:27','',''),(2651494,'1','197','1018',464,'Return of Retail Sale Id 1642809',0.00,8200.00,12.50,0.00,-725.00,'2022-03-27 10:06:39','',''),(2651495,'1','197','1018',464,'Return of Retail Sale Id 1642811',0.00,8003.20,12.20,0.00,-707.60,'2022-03-27 10:07:49','',''),(2651496,'1','197','1018',464,'Retail Sale Id 1642815',24600.00,0.00,0.00,37.50,2175.00,'2022-03-27 10:09:46','',''),(2651497,'1','197','1018',464,'Retail Sale Id 1642816',16203.20,0.00,0.00,24.70,1432.60,'2022-03-27 10:10:14','',''),(2651498,'1','197','1018',464,'Return of Retail Sale Id 1642816',0.00,16203.20,24.70,0.00,-1432.60,'2022-03-27 10:11:03','',''),(2651499,'1','197','1018',464,'Retail Sale Id 1642817',3752.32,0.00,0.00,5.72,331.76,'2022-03-27 10:12:20','',''),(2651500,'1','197','1018',464,'Retail Sale Id 1642818',14202.88,0.00,0.00,23.36,233.60,'2022-03-27 10:13:38','',''),(2651501,'1','197','1018',464,'Retail Sale Id 1642819',2997.92,0.00,0.00,4.57,265.06,'2022-03-27 10:17:32','',''),(2651502,'1','197','1018',464,'Retail Sale Id 1642820',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 10:20:04','',''),(2651503,'1','197','1018',464,'Retail Sale Id 1642821',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 10:20:48','',''),(2651504,'1','197','1018',464,'Return of Retail Sale Id 1642819',0.00,2997.92,4.57,0.00,-265.06,'2022-03-27 10:21:35','',''),(2651505,'1','197','1018',464,'Retail Sale Id 1642822',2999.68,0.00,0.00,4.36,392.40,'2022-03-27 10:22:23','',''),(2651506,'1','197','1018',464,'Retail Sale Id 1642823',62400.00,0.00,0.00,100.00,2600.00,'2022-03-27 10:23:23','',''),(2651507,'1','197','1018',464,'Retail Sale Id 1642824',34400.00,0.00,0.00,50.00,4500.00,'2022-03-27 10:41:15','',''),(2651508,'1','197','1018',464,'Retail Sale Id 1642825',0.00,0.00,0.00,0.00,0.00,'2022-03-27 10:46:04','',''),(2651509,'1','197','1018',464,'Retail Sale Id 1642826',43000.00,0.00,0.00,62.50,5625.00,'2022-03-27 11:14:04','',''),(2651510,'1','197','1018',464,'Retail Sale Id 1642827',997.60,0.00,0.00,1.45,130.50,'2022-03-27 11:17:32','',''),(2651511,'1','197','1018',464,'Retail Sale Id 1642828',4196.80,0.00,0.00,6.10,549.00,'2022-03-27 11:19:51','',''),(2651512,'1','197','1018',464,'Retail Sale Id 1642829',22360.00,0.00,0.00,32.50,2925.00,'2022-03-27 11:22:18','',''),(2651513,'1','197','1018',464,'Retail Sale Id 1642830',8496.80,0.00,0.00,12.35,1111.50,'2022-03-27 11:43:04','',''),(2651514,'1','197','1018',464,'Retail Sale Id 1642831',17200.00,0.00,0.00,25.00,2250.00,'2022-03-27 11:46:09','',''),(2651515,'1','197','1018',464,'Retail Sale Id 1642832',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 12:01:57','',''),(2651516,'1','197','1018',464,'Retail Sale Id 1642833',4128.00,0.00,0.00,6.00,540.00,'2022-03-27 12:13:29','',''),(2651517,'1','197','1018',464,'Retail Sale Id 1642834',4128.00,0.00,0.00,6.00,540.00,'2022-03-27 12:17:16','',''),(2651518,'1','197','1018',464,'Retail Sale Id 1642835',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 12:21:28','',''),(2651519,'1','197','1018',464,'Retail Sale Id 1642836',2999.68,0.00,0.00,4.36,392.40,'2022-03-27 12:36:43','',''),(2651520,'1','197','1018',464,'Retail Sale Id 1642838',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 12:37:47','',''),(2651521,'1','197','1018',464,'Retail Sale Id 1642839',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 12:44:03','',''),(2651522,'1','197','1018',464,'Retail Sale Id 1642840',8600.00,0.00,0.00,12.50,1125.00,'2022-03-27 12:51:44','',''),(2651523,'1','197','1018',464,'Retail Sale Id 1642841',4128.00,0.00,0.00,6.00,540.00,'2022-03-27 12:58:03','',''),(2651524,'1','197','1018',464,'Retail Sale Id 1642842',0.00,0.00,0.00,0.00,0.00,'2022-03-27 16:04:39','',''),(2651525,'1','197','1018',464,'Retail Sale Id 1642843',7024.48,0.00,0.00,10.21,918.90,'2022-03-27 17:06:01','',''),(2651526,'1','197','1018',464,'Retail Sale Id 1642846',52709.28,0.00,0.00,84.47,2196.22,'2022-03-27 17:13:25','',''),(2651527,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,94298.62,157.69,0.00,0.00,'2022-03-27 17:49:12','',''),(2651528,'1','197',NULL,464,'Reception corrector for bridging 132606',0.00,0.00,0.00,157.69,0.00,'2022-03-27 17:50:40','',''),(2651529,'1','197','1018',464,'Received from bridging 132606',0.00,0.00,157.69,0.00,0.00,'2022-03-27 17:50:40','',''),(2651530,'1','197','1018',464,'Retail Sale Id 1642847',98398.56,0.00,0.00,157.69,4099.94,'2022-03-27 17:52:25','',''),(2651531,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,3307120.00,5360.00,0.00,0.00,'2022-03-27 18:03:09','',''),(2651532,'1','197',NULL,464,'Reception corrector for bridging 132607',0.00,0.00,0.00,5360.00,0.00,'2022-03-27 18:04:12','',''),(2651533,'1','197','1018',464,'Received from bridging 132607',0.00,0.00,5360.00,0.00,0.00,'2022-03-27 18:04:12','',''),(2651534,'1','197','1018',464,'Retail Sale Id 1642848',152880.00,0.00,0.00,245.00,1715.00,'2022-03-27 18:08:00','',''),(2651535,'1','197','1018',464,'Retail Sale Id 1642849',8600.00,0.00,0.00,12.50,887.50,'2022-03-27 18:08:32','',''),(2651536,'1','197','1018',464,'Retail Sale Id 1642850',17200.00,0.00,0.00,25.00,1775.00,'2022-03-27 18:08:57','',''),(2651537,'1','197','1018',464,'Retail Sale Id 1642851',4128.00,0.00,0.00,6.00,426.00,'2022-03-27 18:09:19','',''),(2651538,'1','197','1018',464,'Retail Sale Id 1642852',8600.00,0.00,0.00,12.50,887.50,'2022-03-27 18:09:54','',''),(2651539,'1','197','1018',464,'Retail Sale Id 1642853',997.60,0.00,0.00,1.45,102.95,'2022-03-27 18:23:14','',''),(2651540,'1','197','1018',464,'Retail Sale Id 1642854',2999.68,0.00,0.00,4.36,309.56,'2022-03-27 18:53:31','',''),(2651541,'1','197','1018',464,'Retail Sale Id 1642855',332455.36,0.00,0.00,483.22,34308.62,'2022-03-28 01:31:27','',''),(2651542,'1','197','1018',464,'Return of Retail Sale Id 1642855',0.00,332455.36,483.22,0.00,-34308.62,'2022-03-28 01:32:04','',''),(2651543,'1','197','1018',464,'Retail Sale Id 1642856',140489.60,0.00,0.00,204.20,14498.20,'2022-03-28 01:34:58','',''),(2651544,'1','197','1018',464,'Retail Sale Id 1642857',39087.36,0.00,0.00,62.64,438.48,'2022-03-28 01:36:34','',''),(2651545,'1','197','1018',464,'Retail Sale Id 1642858',17200.00,0.00,0.00,25.00,1775.00,'2022-03-28 08:04:24','',''),(2651546,'1','197','1018',464,'Retail Sale Id 1642859',2002.08,0.00,0.00,2.91,206.61,'2022-03-28 08:05:11','',''),(2651547,'1','197','1018',464,'Retail Sale Id 1642860',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 08:20:18','',''),(2651548,'1','197','1018',464,'Retail Sale Id 1642861',4300.00,0.00,0.00,6.25,443.75,'2022-03-28 08:32:56','',''),(2651549,'1','197','1018',464,'Retail Sale Id 1642862',5001.76,0.00,0.00,7.27,516.17,'2022-03-28 10:56:41','',''),(2651550,'1','197','1018',464,'Retail Sale Id 1642863',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 11:20:31','',''),(2651551,'1','197','1018',464,'Retail Sale Id 1642864',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 11:43:37','',''),(2651552,'1','197','1018',464,'Retail Sale Id 1642865',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 11:45:15','',''),(2651553,'1','197','1018',464,'Retail Sale Id 1642866',34320.00,0.00,0.00,55.00,385.00,'2022-03-28 12:54:36','',''),(2651554,'1','197','1018',464,'Retail Sale Id 1642867',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 13:54:10','',''),(2651555,'1','197','1018',464,'Retail Sale Id 1642868',0.00,0.00,0.00,0.00,0.00,'2022-03-28 13:57:57','',''),(2651556,'1','197','1018',464,'Retail Sale Id 1642869',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 14:01:58','',''),(2651557,'1','197','1018',464,'Retail Sale Id 1642870',2098.40,0.00,0.00,3.05,216.55,'2022-03-28 14:14:19','',''),(2651558,'1','197','1018',464,'Retail Sale Id 1642871',2002.08,0.00,0.00,2.91,206.61,'2022-03-28 14:18:06','',''),(2651559,'1','197','1018',464,'Retail Sale Id 1642872',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 15:06:45','',''),(2651560,'1','197','1018',464,'Retail Sale Id 1642873',4148.64,0.00,0.00,6.03,428.13,'2022-03-28 17:14:13','',''),(2651561,'1','197','1018',464,'Retail Sale Id 1642874',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 17:18:13','',''),(2651562,'1','197','1018',464,'Retail Sale Id 1642875',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 17:28:47','',''),(2651563,'1','197','1018',464,'Retail Sale Id 1642877',2098.40,0.00,0.00,3.05,216.55,'2022-03-28 17:30:52','',''),(2651564,'1','197','1018',464,'Retail Sale Id 1642877',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 17:30:52','',''),(2651565,'1','197','1018',464,'Retail Sale Id 1642879',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 17:38:14','',''),(2651566,'1','197','1018',464,'Retail Sale Id 1642880',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 17:39:12','',''),(2651567,'1','197','1018',464,'Retail Sale Id 1642881',3501.92,0.00,0.00,5.09,361.39,'2022-03-28 17:41:51','',''),(2651568,'1','197','1018',464,'Retail Sale Id 1642882',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 17:43:47','',''),(2651569,'1','197','1018',464,'Retail Sale Id 1642883',19999.20,0.00,0.00,32.05,224.35,'2022-03-28 17:50:08','',''),(2651570,'1','197','1018',464,'Retail Sale Id 1642884',2002.08,0.00,0.00,2.91,206.61,'2022-03-28 18:00:52','',''),(2651571,'1','197','1018',464,'Retail Sale Id 1642884',2999.68,0.00,0.00,4.36,309.56,'2022-03-28 18:00:52','',''),(2651572,'1','197','1018',464,'Retail Sale Id 1642885',3501.92,0.00,0.00,5.09,361.39,'2022-03-28 18:08:33','',''),(2651573,'1','197','1018',464,'Retail Sale Id 1642885',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 18:08:33','',''),(2651574,'1','197','1018',464,'Retail Sale Id 1642886',2002.08,0.00,0.00,2.91,206.61,'2022-03-28 18:13:09','',''),(2651575,'1','197','1018',464,'Retail Sale Id 1642889',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 18:17:54','',''),(2651576,'1','197','1018',464,'Retail Sale Id 1642890',8600.00,0.00,0.00,12.50,887.50,'2022-03-28 18:43:18','',''),(2651577,'1','197','1018',464,'Retail Sale Id 1642891',997.60,0.00,0.00,1.45,102.95,'2022-03-28 18:59:13','',''),(2651578,'1','197','1018',464,'Retail Sale Id 1642891',2002.08,0.00,0.00,2.91,206.61,'2022-03-28 18:59:13','',''),(2651579,'1','197','1018',464,'Retail Sale Id 1642892',133616.48,0.00,0.00,194.21,13788.91,'2022-03-28 20:03:28','',''),(2651580,'1','197','1018',464,'Retail Sale Id 1642893',124768.80,0.00,0.00,199.95,1399.65,'2022-03-28 20:06:10','',''),(2651581,'1','197','1018',464,'Retail Sale Id 1642894',17200.00,0.00,0.00,25.00,1775.00,'2022-03-29 07:56:44','',''),(2651582,'1','197','1018',464,'Retail Sale Id 1642896',5999.36,0.00,0.00,8.72,619.12,'2022-03-29 08:03:27','',''),(2651583,'1','197','1018',464,'Retail Sale Id 1642897',17200.00,0.00,0.00,25.00,1775.00,'2022-03-29 08:10:06','',''),(2651584,'1','197','1018',464,'Retail Sale Id 1642899',46800.00,0.00,0.00,75.00,525.00,'2022-03-29 08:14:30','',''),(2651585,'1','197','1018',464,'Retail Sale Id 1642900',8600.00,0.00,0.00,12.50,887.50,'2022-03-29 08:15:06','',''),(2651586,'1','197','1018',464,'Retail Sale Id 1642901',0.00,0.00,0.00,0.00,0.00,'2022-03-29 08:16:28','',''),(2651587,'1','197','1018',464,'Retail Sale Id 1642902',8600.00,0.00,0.00,12.50,887.50,'2022-03-29 14:26:50','',''),(2651588,'1','197','1018',464,'Retail Sale Id 1642903',1499.84,0.00,0.00,2.18,154.78,'2022-03-29 14:28:55','',''),(2651589,'1','197','1018',464,'Retail Sale Id 1642904',6192.00,0.00,0.00,9.00,639.00,'2022-03-29 14:29:32','',''),(2651590,'1','197','1018',464,'Retail Sale Id 1642905',4148.64,0.00,0.00,6.03,428.13,'2022-03-29 14:30:31','',''),(2651591,'1','197','1018',464,'Retail Sale Id 1642906',1499.84,0.00,0.00,2.18,154.78,'2022-03-29 14:31:22','',''),(2651592,'1','197','1018',464,'Retail Sale Id 1642907',0.00,0.00,0.00,0.00,0.00,'2022-03-29 14:34:44','',''),(2651593,'1','197','1018',464,'Retail Sale Id 1642908',2098.40,0.00,0.00,3.05,216.55,'2022-03-29 14:37:01','',''),(2651594,'1','197','1018',464,'Retail Sale Id 1642909',56160.00,0.00,0.00,90.00,630.00,'2022-03-29 19:50:52','',''),(2651595,'1','197','1018',464,'Retail Sale Id 1642910',245196.32,0.00,0.00,356.39,25303.69,'2022-03-29 19:52:49','',''),(2651596,'1','197','1018',464,'Retail Sale Id 1642911',3501.92,0.00,0.00,5.09,361.39,'2022-03-30 08:03:59','',''),(2651597,'1','197','1018',464,'Retail Sale Id 1642912',2098.40,0.00,0.00,3.05,216.55,'2022-03-30 08:06:28','',''),(2651598,'1','197','1018',464,'Retail Sale Id 1642920',2098.40,0.00,0.00,3.05,216.55,'2022-03-30 10:03:57','',''),(2651599,'1','197','1018',464,'Retail Sale Id 1642921',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 10:56:28','',''),(2651600,'1','197','1018',464,'Retail Sale Id 1642924',6996.96,0.00,0.00,10.17,722.07,'2022-03-30 11:00:26','',''),(2651601,'1','197','1018',464,'Retail Sale Id 1642925',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 11:04:00','',''),(2651602,'1','197','1018',464,'Retail Sale Id 1642926',0.00,0.00,0.00,0.00,0.00,'2022-03-30 11:05:41','',''),(2651603,'1','197','1018',464,'Retail Sale Id 1642927',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 11:48:02','',''),(2651604,'1','197','1018',464,'Retail Sale Id 1642928',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 12:22:47','',''),(2651605,'1','197','1018',464,'Retail Sale Id 1642929',2002.08,0.00,0.00,2.91,206.61,'2022-03-30 12:25:49','',''),(2651606,'1','197','1018',464,'Retail Sale Id 1642930',3501.92,0.00,0.00,5.09,361.39,'2022-03-30 12:26:53','',''),(2651607,'1','197','1018',464,'Retail Sale Id 1642931',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 12:48:04','',''),(2651608,'1','197','1018',464,'Retail Sale Id 1642932',151900.00,0.00,0.00,245.00,735.00,'2022-03-30 13:22:31','',''),(2651609,'1','197','1018',464,'Retail Sale Id 1642933',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 13:23:37','',''),(2651610,'1','197','1018',464,'Retail Sale Id 1642934',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 13:24:13','',''),(2651611,'1','197','1018',464,'Retail Sale Id 1642935',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 13:29:17','',''),(2651612,'1','197','1018',464,'Retail Sale Id 1642936',3501.92,0.00,0.00,5.09,361.39,'2022-03-30 13:38:31','',''),(2651613,'1','197','1018',464,'Retail Sale Id 1642937',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 13:44:18','',''),(2651614,'1','197','1018',464,'Retail Sale Id 1642938',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 13:48:58','',''),(2651615,'1','197','1018',464,'Retail Sale Id 1642939',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 14:00:33','',''),(2651616,'1','197','1018',464,'Retail Sale Id 1642940',7224.00,0.00,0.00,10.50,745.50,'2022-03-30 14:38:52','',''),(2651617,'1','197','1018',464,'Retail Sale Id 1642941',3501.92,0.00,0.00,5.09,361.39,'2022-03-30 14:50:27','',''),(2651618,'1','197','1018',464,'Retail Sale Id 1642942',17200.00,0.00,0.00,25.00,1775.00,'2022-03-30 14:57:59','',''),(2651619,'1','197','1018',464,'Retail Sale Id 1642943',4148.64,0.00,0.00,6.03,428.13,'2022-03-30 15:17:42','',''),(2651620,'1','197','1018',464,'Retail Sale Id 1642944',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 15:38:25','',''),(2651621,'1','197','1018',464,'Retail Sale Id 1642945',3501.92,0.00,0.00,5.09,361.39,'2022-03-30 15:40:56','',''),(2651622,'1','197','1018',464,'Retail Sale Id 1642946',3501.92,0.00,0.00,5.09,361.39,'2022-03-30 15:59:14','',''),(2651623,'1','197','1018',464,'Retail Sale Id 1642947',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 16:32:07','',''),(2651624,'1','197','1018',464,'Retail Sale Id 1642948',8600.00,0.00,0.00,12.50,887.50,'2022-03-30 16:54:26','',''),(2651625,'1','197','1018',464,'Retail Sale Id 1642949',17200.00,0.00,0.00,25.00,1775.00,'2022-03-30 16:55:44','',''),(2651626,'1','197','1018',464,'Retail Sale Id 1642950',197228.96,0.00,0.00,286.67,20353.57,'2022-03-30 20:01:58','',''),(2651627,'1','197','1018',464,'Retail Sale Id 1642951',117800.00,0.00,0.00,190.00,570.00,'2022-03-30 20:06:31','',''),(2651628,'1','197','1018',464,'Retail Sale Id 1642952',8600.00,0.00,0.00,12.50,887.50,'2022-03-31 08:16:26','',''),(2651629,'1','197','1018',464,'Retail Sale Id 1642953',8600.00,0.00,0.00,12.50,887.50,'2022-03-31 08:19:35','',''),(2651630,'1','197','1018',464,'Retail Sale Id 1642954',5001.76,0.00,0.00,7.27,516.17,'2022-03-31 08:27:16','',''),(2651631,'1','197','1018',464,'Retail Sale Id 1642955',24080.00,0.00,0.00,35.00,2485.00,'2022-03-31 08:39:25','',''),(2651632,'1','197','1018',464,'Retail Sale Id 1642956',8600.00,0.00,0.00,12.50,887.50,'2022-03-31 09:16:00','',''),(2651633,'1','197','1018',464,'Return of Retail Sale Id 1642956',0.00,8600.00,12.50,0.00,-887.50,'2022-03-31 09:23:09','',''),(2651634,'1','197','1018',464,'Return of Retail Sale Id 1642955',0.00,24080.00,35.00,0.00,-2485.00,'2022-03-31 09:24:01','',''),(2651635,'1','197','1018',464,'Return of Retail Sale Id 1642954',0.00,5001.76,7.27,0.00,-516.17,'2022-03-31 09:24:23','',''),(2651636,'1','197','1018',464,'Return of Retail Sale Id 1642953',0.00,8600.00,12.50,0.00,-887.50,'2022-03-31 09:25:59','',''),(2651637,'1','197','1018',464,'Return of Retail Sale Id 1642952',0.00,8600.00,12.50,0.00,-887.50,'2022-03-31 09:26:50','',''),(2651638,'1','197','1018',464,'Retail Sale Id 1642957',3353.20,0.00,0.00,5.05,237.35,'2022-03-31 09:29:10','',''),(2651639,'1','197','1018',464,'Retail Sale Id 1642958',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 09:40:40','',''),(2651640,'1','197','1018',464,'Retail Sale Id 1642959',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 09:41:25','',''),(2651641,'1','197','1018',464,'Retail Sale Id 1642960',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 09:42:04','',''),(2651642,'1','197','1018',464,'Retail Sale Id 1642961',3997.28,0.00,0.00,6.02,282.94,'2022-03-31 10:06:25','',''),(2651643,'1','197','1018',464,'Retail Sale Id 1642962',1002.64,0.00,0.00,1.51,70.97,'2022-03-31 10:07:30','',''),(2651644,'1','197','1018',464,'Retail Sale Id 1642963',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 11:43:31','',''),(2651645,'1','197','1018',464,'Retail Sale Id 1642964',3997.28,0.00,0.00,6.02,282.94,'2022-03-31 11:54:00','',''),(2651646,'1','197','1018',464,'Retail Sale Id 1642965',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 12:29:50','',''),(2651647,'1','197','1018',464,'Retail Sale Id 1642966',16600.00,0.00,0.00,25.00,1175.00,'2022-03-31 12:44:55','',''),(2651648,'1','197','1018',464,'Retail Sale Id 1642968',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 13:06:40','',''),(2651649,'1','197','1018',464,'Retail Sale Id 1642969',29880.00,0.00,0.00,45.00,2115.00,'2022-03-31 13:38:58','',''),(2651650,'1','197','1018',464,'Retail Sale Id 1642970',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 13:44:18','',''),(2651651,'1','197','1018',464,'Retail Sale Id 1642971',13280.00,0.00,0.00,20.00,940.00,'2022-03-31 14:22:09','',''),(2651652,'1','197','1018',464,'Retail Sale Id 1642972',6002.56,0.00,0.00,9.04,424.88,'2022-03-31 14:47:00','',''),(2651653,'1','197','1018',464,'Retail Sale Id 1642973',3997.28,0.00,0.00,6.02,282.94,'2022-03-31 14:48:03','',''),(2651654,'1','197','1018',464,'Retail Sale Id 1642974',1998.64,0.00,0.00,3.01,141.47,'2022-03-31 14:52:19','',''),(2651655,'1','197','1018',464,'Retail Sale Id 1642975',1998.64,0.00,0.00,3.01,141.47,'2022-03-31 15:33:25','',''),(2651656,'1','197','1018',464,'Retail Sale Id 1642976',30600.00,0.00,0.00,50.00,-250.00,'2022-03-31 16:15:18','',''),(2651657,'1','197','1018',464,'Retail Sale Id 1642977',61200.00,0.00,0.00,100.00,-500.00,'2022-03-31 16:16:33','',''),(2651658,'1','197','1018',464,'Retail Sale Id 1642978',1002.64,0.00,0.00,1.51,70.97,'2022-03-31 16:21:14','',''),(2651659,'1','197','1018',464,'Retail Sale Id 1642979',3353.20,0.00,0.00,5.05,237.35,'2022-03-31 16:23:23','',''),(2651660,'1','197','1018',464,'Retail Sale Id 1642980',4150.00,0.00,0.00,6.25,293.75,'2022-03-31 16:26:37','',''),(2651661,'1','197','1018',464,'Retail Sale Id 1642981',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 16:28:59','',''),(2651662,'1','197','1018',464,'Retail Sale Id 1642982',1998.64,0.00,0.00,3.01,141.47,'2022-03-31 16:30:43','',''),(2651663,'1','197','1018',464,'Retail Sale Id 1642983',24900.00,0.00,0.00,37.50,1762.50,'2022-03-31 16:39:32','',''),(2651664,'1','197','1018',464,'Retail Sale Id 1642984',33200.00,0.00,0.00,50.00,2350.00,'2022-03-31 16:47:55','',''),(2651665,'1','197','1018',464,'Retail Sale Id 1642985',3997.28,0.00,0.00,6.02,282.94,'2022-03-31 16:59:31','',''),(2651666,'1','197','1018',464,'Retail Sale Id 1642986',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 17:03:57','',''),(2651667,'1','197','1018',464,'Retail Sale Id 1642987',73440.00,0.00,0.00,120.00,-600.00,'2022-03-31 17:06:49','',''),(2651668,'1','197','1018',464,'Retail Sale Id 1642988',3997.28,0.00,0.00,6.02,282.94,'2022-03-31 17:07:27','',''),(2651669,'1','197','1018',464,'Retail Sale Id 1642989',7350.48,0.00,0.00,11.07,520.29,'2022-03-31 17:18:18','',''),(2651670,'1','197','1018',464,'Retail Sale Id 1642990',3001.28,0.00,0.00,4.52,212.44,'2022-03-31 17:26:39','',''),(2651671,'1','197','1018',464,'Retail Sale Id 1642991',1998.64,0.00,0.00,3.01,141.47,'2022-03-31 17:31:32','',''),(2651672,'1','197','1018',464,'Retail Sale Id 1642992',8300.00,0.00,0.00,12.50,587.50,'2022-03-31 17:38:20','',''),(2651673,'1','197','1018',464,'Retail Sale Id 1642993',3353.20,0.00,0.00,5.05,237.35,'2022-03-31 17:44:50','',''),(2651674,'1','197','1018',464,'Retail Sale Id 1642994',68484.96,0.00,0.00,103.14,4847.58,'2022-03-31 17:52:18','',''),(2651675,'1','197','1018',464,'Retail Sale Id 1642995',85728.96,0.00,0.00,140.08,-700.40,'2022-03-31 18:03:06','',''),(2651676,'1','197','1018',464,'Retail Sale Id 1642996',30630.60,0.00,0.00,50.05,-250.25,'2022-03-31 19:40:38','',''),(2651677,'1','197','1018',464,'Retail Sale Id 1642997',55284.64,0.00,0.00,83.26,3913.22,'2022-03-31 19:42:36','',''),(2651678,'1','197','1018',464,'Retail Sale Id 1642998',3499.28,0.00,0.00,5.27,247.69,'2022-04-01 10:38:08','',''),(2651679,'1','197','1018',464,'Retail Sale Id 1642999',8300.00,0.00,0.00,12.50,587.50,'2022-04-01 10:44:17','',''),(2651680,'1','197','1018',464,'Retail Sale Id 1643000',0.00,0.00,0.00,0.00,0.00,'2022-04-01 11:01:41','',''),(2651681,'1','197','1018',464,'Retail Sale Id 1643001',3997.28,0.00,0.00,6.02,282.94,'2022-04-01 11:25:22','',''),(2651682,'1','197','1018',464,'Retail Sale Id 1643002',8001.20,0.00,0.00,12.05,566.35,'2022-04-01 11:39:05','',''),(2651683,'1','197','1018',464,'Retail Sale Id 1643003',30212.00,0.00,0.00,45.50,2138.50,'2022-04-01 12:04:13','',''),(2651684,'1','197','1018',464,'Retail Sale Id 1643004',20012.40,0.00,0.00,32.70,-163.50,'2022-04-01 12:51:54','',''),(2651685,'1','197','1018',464,'Retail Sale Id 1643005',1002.64,0.00,0.00,1.51,70.97,'2022-04-01 13:26:32','',''),(2651686,'1','197','1018',464,'Retail Sale Id 1643006',6998.56,0.00,0.00,10.54,495.38,'2022-04-01 13:39:23','',''),(2651687,'1','197','1018',464,'Retail Sale Id 1643007',6640.00,0.00,0.00,10.00,470.00,'2022-04-01 13:57:27','',''),(2651688,'1','197','1018',464,'Retail Sale Id 1643008',4999.92,0.00,0.00,7.53,353.91,'2022-04-01 14:05:53','',''),(2651689,'1','197','1018',464,'Retail Sale Id 1643009',3997.28,0.00,0.00,6.02,282.94,'2022-04-01 14:13:19','',''),(2651690,'1','197','1018',464,'Retail Sale Id 1643010',8300.00,0.00,0.00,12.50,587.50,'2022-04-01 14:14:24','',''),(2651691,'1','197','1018',464,'Retail Sale Id 1643011',8300.00,0.00,0.00,12.50,587.50,'2022-04-01 14:18:39','',''),(2651692,'1','197','1018',464,'Retail Sale Id 1643012',16600.00,0.00,0.00,25.00,1175.00,'2022-04-01 14:19:23','',''),(2651693,'1','197','1018',464,'Retail Sale Id 1643013',1998.64,0.00,0.00,3.01,141.47,'2022-04-01 14:31:27','',''),(2651694,'1','197','1018',464,'Retail Sale Id 1643014',8300.00,0.00,0.00,12.50,587.50,'2022-04-01 15:29:24','',''),(2651695,'1','197','1018',464,'Retail Sale Id 1643015',3353.20,0.00,0.00,5.05,237.35,'2022-04-01 15:41:42','',''),(2651696,'1','197','1018',464,'Retail Sale Id 1643016',5976.00,0.00,0.00,9.00,423.00,'2022-04-01 15:43:32','',''),(2651697,'1','197','1018',464,'Retail Sale Id 1643016',31872.00,0.00,0.00,48.00,2256.00,'2022-04-01 15:43:32','',''),(2651698,'1','197','1018',464,'Retail Sale Id 1643018',3353.20,0.00,0.00,5.05,237.35,'2022-04-01 17:06:14','',''),(2651699,'1','197','1018',464,'Retail Sale Id 1643019',16600.00,0.00,0.00,25.00,1175.00,'2022-04-01 17:08:18','',''),(2651700,'1','197','1018',464,'Retail Sale Id 1643020',8300.00,0.00,0.00,12.50,587.50,'2022-04-01 17:10:46','',''),(2651701,'1','197','1018',464,'Retail Sale Id 1643021',4999.92,0.00,0.00,7.53,353.91,'2022-04-01 17:15:07','',''),(2651702,'1','197','1018',464,'Retail Sale Id 1643022',8001.20,0.00,0.00,12.05,566.35,'2022-04-01 17:31:10','',''),(2651703,'1','197','1018',464,'Retail Sale Id 1643023',4999.92,0.00,0.00,7.53,353.91,'2022-04-01 17:49:41','',''),(2651704,'1','197','1018',464,'Retail Sale Id 1643024',3997.28,0.00,0.00,6.02,282.94,'2022-04-01 17:51:37','',''),(2651705,'1','197','1018',464,'Retail Sale Id 1643024',16600.00,0.00,0.00,25.00,1175.00,'2022-04-01 17:51:37','',''),(2651706,'1','197','1018',464,'Return of Retail Sale Id 1643016',0.00,5976.00,9.00,0.00,-423.00,'2022-04-01 17:52:51','',''),(2651707,'1','197','1018',464,'Return of Retail Sale Id 1643016',0.00,31872.00,48.00,0.00,-2256.00,'2022-04-01 17:52:51','',''),(2651708,'1','197','1018',464,'Retail Sale Id 1643025',33200.00,0.00,0.00,50.00,2350.00,'2022-04-01 17:53:18','',''),(2651709,'1','197','1018',464,'Retail Sale Id 1643026',1002.64,0.00,0.00,1.51,70.97,'2022-04-01 17:57:14','',''),(2651710,'1','197','1018',464,'Retail Sale Id 1643026',1500.64,0.00,0.00,2.26,106.22,'2022-04-01 17:57:14','',''),(2651711,'1','197','1018',464,'Retail Sale Id 1643027',0.00,0.00,0.00,0.00,0.00,'2022-04-01 18:00:18','',''),(2651712,'1','197','1018',464,'Retail Sale Id 1643028',3499.28,0.00,0.00,5.27,247.69,'2022-04-01 18:03:37','',''),(2651713,'1','197','1018',464,'Retail Sale Id 1643029',8300.00,0.00,0.00,12.50,587.50,'2022-04-01 18:32:03','',''),(2651714,'1','197','1018',464,'Retail Sale Id 1643030',45444.16,0.00,0.00,68.44,3216.68,'2022-04-01 20:38:09','',''),(2651715,'1','197','1018',464,'Retail Sale Id 1643031',33200.00,0.00,0.00,50.00,2350.00,'2022-04-01 20:38:34','',''),(2651716,'1','197','1018',464,'Retail Sale Id 1643032',33200.00,0.00,0.00,50.00,2350.00,'2022-04-01 20:39:48','',''),(2651717,'1','197','1018',464,'Retail Sale Id 1643033',91800.00,0.00,0.00,150.00,-750.00,'2022-04-01 20:40:53','',''),(2651718,'1','197','1018',464,'Retail Sale Id 1643034',36254.88,0.00,0.00,59.24,-296.20,'2022-04-01 20:42:14','',''),(2651719,'1','197','1018',464,'Retail Sale Id 1643035',61200.00,0.00,0.00,100.00,-500.00,'2022-04-01 20:43:05','',''),(2651720,'1','197','1018',464,'Retail Sale Id 1643036',20196.00,0.00,0.00,33.00,-165.00,'2022-04-02 07:39:48','',''),(2651721,'1','197','1018',464,'Retail Sale Id 1643037',8632.00,0.00,0.00,13.00,611.00,'2022-04-02 08:08:21','',''),(2651722,'1','197','1018',464,'Retail Sale Id 1643038',3997.28,0.00,0.00,6.02,282.94,'2022-04-02 08:10:12','',''),(2651723,'1','197','1018',464,'Retail Sale Id 1643039',1002.64,0.00,0.00,1.51,70.97,'2022-04-02 08:19:09','',''),(2651724,'1','197','1018',464,'Retail Sale Id 1643040',39168.00,0.00,0.00,64.00,-320.00,'2022-04-02 08:36:32','',''),(2651725,'1','197','1018',464,'Retail Sale Id 1643043',6972.00,0.00,0.00,10.50,493.50,'2022-04-02 08:49:00','',''),(2651726,'1','197','1018',464,'Retail Sale Id 1643044',8300.00,0.00,0.00,12.50,587.50,'2022-04-02 09:01:35','',''),(2651727,'1','197','1018',464,'Retail Sale Id 1643045',8300.00,0.00,0.00,12.50,587.50,'2022-04-02 10:50:19','',''),(2651728,'1','197','1018',464,'Retail Sale Id 1643046',1998.64,0.00,0.00,3.01,141.47,'2022-04-02 10:50:55','',''),(2651729,'1','197','1018',464,'Retail Sale Id 1643047',8300.00,0.00,0.00,12.50,587.50,'2022-04-02 10:53:21','',''),(2651730,'1','197','1018',464,'Retail Sale Id 1643048',6640.00,0.00,0.00,10.00,470.00,'2022-04-02 11:13:16','',''),(2651731,'1','197','1018',464,'Retail Sale Id 1643049',1998.64,0.00,0.00,3.01,141.47,'2022-04-02 11:28:38','',''),(2651732,'1','197','1018',464,'Retail Sale Id 1643050',6002.56,0.00,0.00,9.04,424.88,'2022-04-02 11:31:12','',''),(2651733,'1','197','1018',464,'Retail Sale Id 1643051',3320.00,0.00,0.00,5.00,235.00,'2022-04-02 12:04:03','',''),(2651734,'1','197','1018',464,'Retail Sale Id 1643052',8300.00,0.00,0.00,12.50,587.50,'2022-04-02 12:12:20','',''),(2651735,'1','197','1018',464,'Retail Sale Id 1643053',3997.28,0.00,0.00,6.02,282.94,'2022-04-02 12:17:01','',''),(2651736,'1','197','1018',464,'Retail Sale Id 1643054',91800.00,0.00,0.00,150.00,-750.00,'2022-04-02 13:00:26','',''),(2651737,'1','197','1018',464,'Retail Sale Id 1643055',6998.56,0.00,0.00,10.54,495.38,'2022-04-02 13:04:11','',''),(2651738,'1','197','1018',464,'Retail Sale Id 1643056',1998.64,0.00,0.00,3.01,141.47,'2022-04-02 13:05:28','',''),(2651739,'1','197','1018',464,'Retail Sale Id 1643057',3997.28,0.00,0.00,6.02,282.94,'2022-04-02 13:11:39','',''),(2651740,'1','197','1018',464,'Retail Sale Id 1643058',24992.96,0.00,0.00,37.64,1769.08,'2022-04-02 14:51:31','',''),(2651741,'1','197','1018',464,'Retail Sale Id 1643059',46946.52,0.00,0.00,76.71,-383.55,'2022-04-02 14:53:07','',''),(2651742,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350285',8613.32,0.00,0.00,13.96,0.00,'2022-04-02 14:58:36','',''),(2651743,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2871200.00,4850.00,0.00,0.00,'2022-04-02 17:28:53','',''),(2651744,'1','197',NULL,464,'Reception corrector for bridging 132608',0.00,0.00,0.00,4850.00,0.00,'2022-04-02 17:30:56','',''),(2651745,'1','197','1018',464,'Received from bridging 132608',0.00,0.00,4850.00,0.00,0.00,'2022-04-02 17:30:56','',''),(2651746,'1','197','1018',464,'Retail Sale Id 1643061',8300.00,0.00,0.00,12.50,900.00,'2022-04-02 17:32:26','',''),(2651747,'1','197','1018',464,'Retail Sale Id 1643062',41500.00,0.00,0.00,62.50,4500.00,'2022-04-02 17:34:27','',''),(2651748,'1','197','1018',464,'Retail Sale Id 1643063',8300.00,0.00,0.00,12.50,900.00,'2022-04-02 17:35:16','',''),(2651749,'1','197','1018',464,'Retail Sale Id 1643064',8300.00,0.00,0.00,12.50,900.00,'2022-04-02 17:36:18','',''),(2651750,'1','197','1018',464,'Retail Sale Id 1643065',3997.28,0.00,0.00,6.02,433.44,'2022-04-02 17:36:59','',''),(2651751,'1','197','1018',464,'Retail Sale Id 1643066',3001.28,0.00,0.00,4.52,325.44,'2022-04-02 17:40:39','',''),(2651752,'1','197','1018',464,'Retail Sale Id 1643067',3353.20,0.00,0.00,5.05,363.60,'2022-04-02 18:31:38','',''),(2651753,'1','197','1018',464,'Retail Sale Id 1643068',3200.48,0.00,0.00,4.82,347.04,'2022-04-02 18:33:42','',''),(2651754,'1','197','1018',464,'Retail Sale Id 1643069',3997.28,0.00,0.00,6.02,433.44,'2022-04-02 18:34:52','',''),(2651755,'1','197','1018',464,'Retail Sale Id 1643070',6640.00,0.00,0.00,10.00,720.00,'2022-04-02 18:45:21','',''),(2651756,'1','197','1018',464,'Retail Sale Id 1643071',8300.00,0.00,0.00,12.50,900.00,'2022-04-02 18:46:28','',''),(2651757,'1','197','1018',464,'Retail Sale Id 1643072',3997.28,0.00,0.00,6.02,433.44,'2022-04-02 18:47:26','',''),(2651758,'1','197','1018',464,'Retail Sale Id 1643073',8300.00,0.00,0.00,12.50,900.00,'2022-04-02 18:50:52','',''),(2651759,'1','197','1018',464,'Retail Sale Id 1643074',9960.00,0.00,0.00,15.00,1080.00,'2022-04-02 18:54:42','',''),(2651760,'1','197','1018',464,'Retail Sale Id 1643075',127866.48,0.00,0.00,192.57,13865.04,'2022-04-02 20:40:50','',''),(2651761,'1','197','1018',464,'Retail Sale Id 1643076',244800.00,0.00,0.00,400.00,8000.00,'2022-04-02 20:41:40','',''),(2651762,'1','197','1018',464,'Retail Sale Id 1643077',76163.40,0.00,0.00,124.45,2489.00,'2022-04-02 20:42:43','',''),(2651763,'1','197','1018',464,'Retail Sale Id 1643078',612.00,0.00,0.00,1.00,20.00,'2022-04-02 20:44:28','',''),(2651764,'1','197','1018',464,'Retail Sale Id 1643079',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 07:49:36','',''),(2651765,'1','197','1018',464,'Retail Sale Id 1643080',5318.64,0.00,0.00,8.01,576.72,'2022-04-03 07:52:01','',''),(2651766,'1','197','1018',464,'Retail Sale Id 1643081',3997.28,0.00,0.00,6.02,433.44,'2022-04-03 07:53:12','',''),(2651767,'1','197','1018',464,'Retail Sale Id 1643082',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 07:54:34','',''),(2651768,'1','197','1018',464,'Retail Sale Id 1643083',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 07:56:01','',''),(2651769,'1','197','1018',464,'Retail Sale Id 1643084',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 08:02:44','',''),(2651770,'1','197','1018',464,'Retail Sale Id 1643085',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 08:09:51','',''),(2651771,'1','197','1018',464,'Retail Sale Id 1643086',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 08:21:30','',''),(2651772,'1','197','1018',464,'Retail Sale Id 1643087',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 09:34:49','',''),(2651773,'1','197','1018',464,'Retail Sale Id 1643088',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 09:46:09','',''),(2651774,'1','197','1018',464,'Retail Sale Id 1643089',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 09:47:02','',''),(2651775,'1','197','1018',464,'Retail Sale Id 1643090',30600.00,0.00,0.00,50.00,1000.00,'2022-04-03 10:02:47','',''),(2651776,'1','197','1018',464,'Retail Sale Id 1643091',33660.00,0.00,0.00,55.00,1100.00,'2022-04-03 10:03:20','',''),(2651777,'1','197','1018',464,'Retail Sale Id 1643092',3997.28,0.00,0.00,6.02,433.44,'2022-04-03 10:10:47','',''),(2651778,'1','197','1018',464,'Retail Sale Id 1643093',1500.64,0.00,0.00,2.26,162.72,'2022-04-03 10:11:48','',''),(2651779,'1','197','1018',464,'Retail Sale Id 1643094',3997.28,0.00,0.00,6.02,433.44,'2022-04-03 10:49:16','',''),(2651780,'1','197','1018',464,'Retail Sale Id 1643095',33200.00,0.00,0.00,50.00,3600.00,'2022-04-03 11:16:02','',''),(2651781,'1','197','1018',464,'Retail Sale Id 1643096',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 11:24:37','',''),(2651782,'1','197','1018',464,'Retail Sale Id 1643097',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 11:45:18','',''),(2651783,'1','197','1018',464,'Retail Sale Id 1643098',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 12:06:11','',''),(2651784,'1','197','1018',464,'Retail Sale Id 1643099',4999.92,0.00,0.00,7.53,542.16,'2022-04-03 12:28:12','',''),(2651785,'1','197','1018',464,'Retail Sale Id 1643100',33660.00,0.00,0.00,55.00,1100.00,'2022-04-03 12:30:16','',''),(2651786,'1','197','1018',464,'Retail Sale Id 1643101',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 12:31:52','',''),(2651787,'1','197','1018',464,'Retail Sale Id 1643102',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 12:33:59','',''),(2651788,'1','197','1018',464,'Retail Sale Id 1643104',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 12:49:21','',''),(2651789,'1','197','1018',464,'Retail Sale Id 1643103',16600.00,0.00,0.00,25.00,1800.00,'2022-04-03 13:22:17','',''),(2651790,'1','197','1018',464,'Retail Sale Id 1643105',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 13:23:08','',''),(2651791,'1','197','1018',464,'Retail Sale Id 1643106',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 13:36:05','',''),(2651792,'1','197','1018',464,'Retail Sale Id 1643107',3997.28,0.00,0.00,6.02,433.44,'2022-04-03 13:44:42','',''),(2651793,'1','197','1018',464,'Retail Sale Id 1643108',2656.00,0.00,0.00,4.00,288.00,'2022-04-03 13:48:45','',''),(2651794,'1','197','1018',464,'Retail Sale Id 1643109',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 13:51:42','',''),(2651795,'1','197','1018',464,'Retail Sale Id 1643110',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 13:53:23','',''),(2651796,'1','197','1018',464,'Retail Sale Id 1643111',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 13:58:28','',''),(2651797,'1','197','1018',464,'Retail Sale Id 1643112',2702.48,0.00,0.00,4.07,293.04,'2022-04-03 13:59:56','',''),(2651798,'1','197','1018',464,'Retail Sale Id 1643113',3353.20,0.00,0.00,5.05,363.60,'2022-04-03 14:00:36','',''),(2651799,'1','197','1018',464,'Retail Sale Id 1643114',9960.00,0.00,0.00,15.00,1080.00,'2022-04-03 14:08:35','',''),(2651800,'1','197','1018',464,'Retail Sale Id 1643116',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 14:16:57','',''),(2651801,'1','197','1018',464,'Retail Sale Id 1643117',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 14:25:10','',''),(2651802,'1','197','1018',464,'Retail Sale Id 1643118',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 14:25:53','',''),(2651803,'1','197','1018',464,'Retail Sale Id 1643119',3300.08,0.00,0.00,4.97,357.84,'2022-04-03 14:27:21','',''),(2651804,'1','197','1018',464,'Retail Sale Id 1643120',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 14:31:11','',''),(2651805,'1','197','1018',464,'Retail Sale Id 1643121',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 14:32:08','',''),(2651806,'1','197','1018',464,'Retail Sale Id 1643122',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 14:42:11','',''),(2651807,'1','197','1018',464,'Retail Sale Id 1643123',291924.00,0.00,0.00,477.00,9540.00,'2022-04-03 14:44:34','',''),(2651808,'1','197','1018',464,'Retail Sale Id 1643124',3353.20,0.00,0.00,5.05,363.60,'2022-04-03 14:47:52','',''),(2651809,'1','197','1018',464,'Retail Sale Id 1643125',13944.00,0.00,0.00,21.00,1512.00,'2022-04-03 14:50:27','',''),(2651810,'1','197','1018',464,'Retail Sale Id 1643126',12240.00,0.00,0.00,20.00,400.00,'2022-04-03 14:52:14','',''),(2651811,'1','197','1018',464,'Retail Sale Id 1643127',3399.68,0.00,0.00,5.12,368.64,'2022-04-03 14:53:09','',''),(2651812,'1','197','1018',464,'Retail Sale Id 1643128',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 14:54:36','',''),(2651813,'1','197','1018',464,'Retail Sale Id 1643129',3997.28,0.00,0.00,6.02,433.44,'2022-04-03 14:55:39','',''),(2651814,'1','197','1018',464,'Retail Sale Id 1643130',3300.08,0.00,0.00,4.97,357.84,'2022-04-03 15:07:47','',''),(2651815,'1','197','1018',464,'Retail Sale Id 1643131',3300.08,0.00,0.00,4.97,357.84,'2022-04-03 15:08:45','',''),(2651816,'1','197','1018',464,'Retail Sale Id 1643132',1992.00,0.00,0.00,3.00,216.00,'2022-04-03 15:10:06','',''),(2651817,'1','197','1018',464,'Retail Sale Id 1643132',4316.00,0.00,0.00,6.50,468.00,'2022-04-03 15:10:06','',''),(2651818,'1','197','1018',464,'Retail Sale Id 1643132',16600.00,0.00,0.00,25.00,1800.00,'2022-04-03 15:10:06','',''),(2651819,'1','197','1018',464,'Retail Sale Id 1643133',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 15:11:26','',''),(2651820,'1','197','1018',464,'Retail Sale Id 1643134',5199.12,0.00,0.00,7.83,563.76,'2022-04-03 15:21:41','',''),(2651821,'1','197','1018',464,'Retail Sale Id 1643135',10292.00,0.00,0.00,15.50,1116.00,'2022-04-03 15:23:49','',''),(2651822,'1','197','1018',464,'Retail Sale Id 1643136',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 15:26:19','',''),(2651823,'1','197','1018',464,'Retail Sale Id 1643137',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 15:27:25','',''),(2651824,'1','197','1018',464,'Retail Sale Id 1643138',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 15:28:36','',''),(2651825,'1','197','1018',464,'Retail Sale Id 1643139',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 15:29:28','',''),(2651826,'1','197','1018',464,'Retail Sale Id 1643140',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 15:30:27','',''),(2651827,'1','197','1018',464,'Retail Sale Id 1643142',36108.00,0.00,0.00,59.00,1180.00,'2022-04-03 15:45:55','',''),(2651828,'1','197','1018',464,'Retail Sale Id 1643143',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 15:49:28','',''),(2651829,'1','197','1018',464,'Retail Sale Id 1643144',6640.00,0.00,0.00,10.00,720.00,'2022-04-03 16:03:55','',''),(2651830,'1','197','1018',464,'Retail Sale Id 1643145',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 16:19:25','',''),(2651831,'1','197','1018',464,'Retail Sale Id 1643146',10298.64,0.00,0.00,15.51,1116.72,'2022-04-03 16:23:03','',''),(2651832,'1','197','1018',464,'Retail Sale Id 1643147',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 16:42:15','',''),(2651833,'1','197','1018',464,'Retail Sale Id 1643148',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 16:45:56','',''),(2651834,'1','197','1018',464,'Retail Sale Id 1643149',3320.00,0.00,0.00,5.00,360.00,'2022-04-03 16:47:46','',''),(2651835,'1','197','1018',464,'Retail Sale Id 1643150',6640.00,0.00,0.00,10.00,720.00,'2022-04-03 16:57:11','',''),(2651836,'1','197','1018',464,'Retail Sale Id 1643151',3997.28,0.00,0.00,6.02,433.44,'2022-04-03 17:12:10','',''),(2651837,'1','197','1018',464,'Retail Sale Id 1643152',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 17:24:51','',''),(2651838,'1','197','1018',464,'Retail Sale Id 1643153',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 17:30:52','',''),(2651839,'1','197','1018',464,'Retail Sale Id 1643154',6998.56,0.00,0.00,10.54,758.88,'2022-04-03 17:55:32','',''),(2651840,'1','197','1018',464,'Retail Sale Id 1643155',3001.28,0.00,0.00,4.52,325.44,'2022-04-03 18:02:20','',''),(2651841,'1','197','1018',464,'Retail Sale Id 1643156',1500.64,0.00,0.00,2.26,162.72,'2022-04-03 18:06:33','',''),(2651842,'1','197','1018',464,'Retail Sale Id 1643157',3300.08,0.00,0.00,4.97,357.84,'2022-04-03 18:33:20','',''),(2651843,'1','197','1018',464,'Retail Sale Id 1643158',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 18:39:52','',''),(2651844,'1','197','1018',464,'Retail Sale Id 1643159',1998.64,0.00,0.00,3.01,216.72,'2022-04-03 18:40:58','',''),(2651845,'1','197','1018',464,'Retail Sale Id 1643160',8300.00,0.00,0.00,12.50,900.00,'2022-04-03 18:52:22','',''),(2651846,'1','197','1018',464,'Retail Sale Id 1643161',115602.40,0.00,0.00,174.10,12535.20,'2022-04-03 19:30:10','',''),(2651847,'1','197','1018',464,'Retail Sale Id 1643162',102118.32,0.00,0.00,166.86,3337.20,'2022-04-03 19:31:52','',''),(2651848,'1','197','1018',464,'Retail Sale Id 1643163',8001.20,0.00,0.00,12.05,867.60,'2022-04-04 09:18:06','',''),(2651849,'1','197','1018',464,'Retail Sale Id 1643164',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 09:19:13','',''),(2651850,'1','197','1018',464,'Retail Sale Id 1643165',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 09:42:29','',''),(2651851,'1','197','1018',464,'Retail Sale Id 1643166',3001.28,0.00,0.00,4.52,325.44,'2022-04-04 09:45:37','',''),(2651852,'1','197','1018',464,'Retail Sale Id 1643168',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 09:56:53','',''),(2651853,'1','197','1018',464,'Retail Sale Id 1643169',4999.92,0.00,0.00,7.53,542.16,'2022-04-04 10:12:02','',''),(2651854,'1','197','1018',464,'Retail Sale Id 1643170',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 10:50:37','',''),(2651855,'1','197','1018',464,'Retail Sale Id 1643171',61200.00,0.00,0.00,100.00,2000.00,'2022-04-04 11:10:29','',''),(2651856,'1','197','1018',464,'Retail Sale Id 1643172',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 11:52:31','',''),(2651857,'1','197','1018',464,'Retail Sale Id 1643173',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 11:58:05','',''),(2651858,'1','197','1018',464,'Retail Sale Id 1643174',3499.28,0.00,0.00,5.27,379.44,'2022-04-04 12:09:27','',''),(2651859,'1','197','1018',464,'Retail Sale Id 1643175',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 13:39:23','',''),(2651860,'1','197','1018',464,'Retail Sale Id 1643176',10298.64,0.00,0.00,15.51,1116.72,'2022-04-04 13:41:14','',''),(2651861,'1','197','1018',464,'Retail Sale Id 1643177',12297.28,0.00,0.00,18.52,1333.44,'2022-04-04 14:06:55','',''),(2651862,'1','197','1018',464,'Retail Sale Id 1643178',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 14:07:53','',''),(2651863,'1','197','1018',464,'Retail Sale Id 1643179',16600.00,0.00,0.00,25.00,1800.00,'2022-04-04 15:10:19','',''),(2651864,'1','197','1018',464,'Retail Sale Id 1643180',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 15:14:00','',''),(2651865,'1','197','1018',464,'Retail Sale Id 1643181',3353.20,0.00,0.00,5.05,363.60,'2022-04-04 15:31:58','',''),(2651866,'1','197','1018',464,'Retail Sale Id 1643182',1500.64,0.00,0.00,2.26,162.72,'2022-04-04 15:38:46','',''),(2651867,'1','197','1018',464,'Retail Sale Id 1643183',3997.28,0.00,0.00,6.02,433.44,'2022-04-04 15:42:16','',''),(2651868,'1','197','1018',464,'Retail Sale Id 1643184',1998.64,0.00,0.00,3.01,216.72,'2022-04-04 16:09:50','',''),(2651869,'1','197','1018',464,'Retail Sale Id 1643185',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 16:38:22','',''),(2651870,'1','197','1018',464,'Retail Sale Id 1643186',16600.00,0.00,0.00,25.00,1800.00,'2022-04-04 16:39:47','',''),(2651871,'1','197','1018',464,'Retail Sale Id 1643187',3997.28,0.00,0.00,6.02,433.44,'2022-04-04 16:44:58','',''),(2651872,'1','197','1018',464,'Retail Sale Id 1643188',8001.20,0.00,0.00,12.05,867.60,'2022-04-04 16:55:55','',''),(2651873,'1','197','1018',464,'Retail Sale Id 1643189',5650.64,0.00,0.00,8.51,612.72,'2022-04-04 16:59:03','',''),(2651874,'1','197','1018',464,'Retail Sale Id 1643190',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 17:05:48','',''),(2651875,'1','197','1018',464,'Retail Sale Id 1643191',3997.28,0.00,0.00,6.02,433.44,'2022-04-04 17:06:31','',''),(2651876,'1','197','1018',464,'Retail Sale Id 1643192',9960.00,0.00,0.00,15.00,1080.00,'2022-04-04 17:11:29','',''),(2651877,'1','197','1018',464,'Retail Sale Id 1643193',1998.64,0.00,0.00,3.01,216.72,'2022-04-04 17:24:01','',''),(2651878,'1','197','1018',464,'Retail Sale Id 1643194',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 17:25:47','',''),(2651879,'1','197','1018',464,'Retail Sale Id 1643195',49800.00,0.00,0.00,75.00,5400.00,'2022-04-04 17:26:58','',''),(2651880,'1','197','1018',464,'Retail Sale Id 1643196',6640.00,0.00,0.00,10.00,720.00,'2022-04-04 17:32:02','',''),(2651881,'1','197','1018',464,'Retail Sale Id 1643198',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 17:36:27','',''),(2651882,'1','197','1018',464,'Retail Sale Id 1643199',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 18:03:38','',''),(2651883,'1','197','1018',464,'Retail Sale Id 1643200',1998.64,0.00,0.00,3.01,216.72,'2022-04-04 18:06:14','',''),(2651884,'1','197','1018',464,'Retail Sale Id 1643200',3997.28,0.00,0.00,6.02,433.44,'2022-04-04 18:06:14','',''),(2651885,'1','197','1018',464,'Retail Sale Id 1643200',3997.28,0.00,0.00,6.02,433.44,'2022-04-04 18:06:14','',''),(2651886,'1','197','1018',464,'Retail Sale Id 1643201',33200.00,0.00,0.00,50.00,3600.00,'2022-04-04 18:28:34','',''),(2651887,'1','197','1018',464,'Retail Sale Id 1643202',66400.00,0.00,0.00,100.00,7200.00,'2022-04-04 18:29:00','',''),(2651888,'1','197','1018',464,'Retail Sale Id 1643203',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 18:31:01','',''),(2651889,'1','197','1018',464,'Retail Sale Id 1643204',27224.00,0.00,0.00,41.00,2952.00,'2022-04-04 18:33:09','',''),(2651890,'1','197','1018',464,'Retail Sale Id 1643205',61200.00,0.00,0.00,100.00,2000.00,'2022-04-04 18:45:12','',''),(2651891,'1','197','1018',464,'Retail Sale Id 1643206',91800.00,0.00,0.00,150.00,3000.00,'2022-04-04 18:45:46','',''),(2651892,'1','197','1018',464,'Retail Sale Id 1643207',38953.80,0.00,0.00,63.65,1273.00,'2022-04-04 18:47:12','',''),(2651893,'1','197','1018',464,'Retail Sale Id 1643208',3997.28,0.00,0.00,6.02,433.44,'2022-04-04 18:48:23','',''),(2651894,'1','197','1018',464,'Retail Sale Id 1643209',8300.00,0.00,0.00,12.50,900.00,'2022-04-04 18:51:23','',''),(2651895,'1','197','1018',464,'Retail Sale Id 1643210',2503.28,0.00,0.00,3.77,271.44,'2022-04-04 19:04:22','',''),(2651896,'1','197','1018',464,'Retail Sale Id 1643211',35344.72,0.00,0.00,53.23,3832.56,'2022-04-04 21:01:33','',''),(2651897,'1','197','1018',464,'Retail Sale Id 1643212',22950.00,0.00,0.00,37.50,750.00,'2022-04-04 21:03:26','',''),(2651898,'1','197','1018',464,'Retail Sale Id 1643213',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 07:26:11','',''),(2651899,'1','197','1018',464,'Retail Sale Id 1643214',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 08:01:33','',''),(2651900,'1','197','1018',464,'Retail Sale Id 1643215',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 08:39:21','',''),(2651901,'1','197','1018',464,'Retail Sale Id 1643216',3399.68,0.00,0.00,5.12,368.64,'2022-04-05 08:46:16','',''),(2651902,'1','197','1018',464,'Retail Sale Id 1643217',6998.56,0.00,0.00,10.54,758.88,'2022-04-05 08:48:28','',''),(2651903,'1','197','1018',464,'Retail Sale Id 1643219',3997.28,0.00,0.00,6.02,433.44,'2022-04-05 09:11:42','',''),(2651904,'1','197','1018',464,'Retail Sale Id 1643220',3997.28,0.00,0.00,6.02,433.44,'2022-04-05 09:21:47','',''),(2651905,'1','197','1018',464,'Retail Sale Id 1643221',3001.28,0.00,0.00,4.52,325.44,'2022-04-05 09:24:42','',''),(2651906,'1','197','1018',464,'Retail Sale Id 1643223',1998.64,0.00,0.00,3.01,216.72,'2022-04-05 09:47:30','',''),(2651907,'1','197','1018',464,'Retail Sale Id 1643226',1699.84,0.00,0.00,2.56,184.32,'2022-04-05 09:52:41','',''),(2651908,'1','197','1018',464,'Retail Sale Id 1643229',1699.84,0.00,0.00,2.56,184.32,'2022-04-05 09:54:36','',''),(2651909,'1','197','1018',464,'Retail Sale Id 1643230',6002.56,0.00,0.00,9.04,650.88,'2022-04-05 10:24:14','',''),(2651910,'1','197','1018',464,'Retail Sale Id 1643231',16600.00,0.00,0.00,25.00,1800.00,'2022-04-05 10:31:54','',''),(2651911,'1','197','1018',464,'Retail Sale Id 1643232',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 10:34:55','',''),(2651912,'1','197','1018',464,'Retail Sale Id 1643235',3300.08,0.00,0.00,4.97,357.84,'2022-04-05 10:42:32','',''),(2651913,'1','197','1018',464,'Retail Sale Id 1643236',3997.28,0.00,0.00,6.02,433.44,'2022-04-05 11:08:20','',''),(2651914,'1','197','1018',464,'Retail Sale Id 1643237',3997.28,0.00,0.00,6.02,433.44,'2022-04-05 11:12:32','',''),(2651915,'1','197','1018',464,'Retail Sale Id 1643238',3320.00,0.00,0.00,5.00,360.00,'2022-04-05 11:13:54','',''),(2651916,'1','197','1018',464,'Retail Sale Id 1643239',30250.00,0.00,0.00,50.00,650.00,'2022-04-05 11:18:37','',''),(2651917,'1','197','1018',464,'Retail Sale Id 1643240',87495.10,0.00,0.00,144.62,1880.06,'2022-04-05 11:32:29','',''),(2651918,'1','197','1018',464,'Retail Sale Id 1643241',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 12:01:02','',''),(2651919,'1','197','1018',464,'Retail Sale Id 1643242',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 12:47:13','',''),(2651920,'1','197','1018',464,'Retail Sale Id 1643243',1998.64,0.00,0.00,3.01,216.72,'2022-04-05 13:48:12','',''),(2651921,'1','197','1018',464,'Retail Sale Id 1643244',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 14:02:41','',''),(2651922,'1','197','1018',464,'Retail Sale Id 1643245',8300.00,0.00,0.00,12.50,900.00,'2022-04-05 15:29:29','',''),(2651923,'1','197','1018',464,'Retail Sale Id 1643246',92867.50,0.00,0.00,153.50,1995.50,'2022-04-05 15:35:30','',''),(2651924,'1','197','1018',464,'Retail Sale Id 1643247',66400.00,0.00,0.00,100.00,7200.00,'2022-04-05 17:18:15','',''),(2651925,'1','197','1018',464,'Retail Sale Id 1643248',33200.00,0.00,0.00,50.00,3600.00,'2022-04-05 17:18:45','',''),(2651926,'1','197','1018',464,'Retail Sale Id 1643249',33200.00,0.00,0.00,50.00,3600.00,'2022-04-05 17:19:07','',''),(2651927,'1','197','1018',464,'Retail Sale Id 1643250',16600.00,0.00,0.00,25.00,1800.00,'2022-04-05 17:19:30','',''),(2651928,'1','197','1018',464,'Retail Sale Id 1643251',9442.08,0.00,0.00,14.22,1023.84,'2022-04-05 17:20:36','',''),(2651929,'1','197','1018',464,'Retail Sale Id 1643252',54649.65,0.00,0.00,90.33,1174.29,'2022-04-05 17:22:18','',''),(2651930,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350286',45033.44,0.00,0.00,76.07,0.00,'2022-04-05 17:29:09','',''),(2651931,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,3084320.00,5210.00,0.00,0.00,'2022-04-06 13:03:16','',''),(2651932,'1','197',NULL,464,'Reception corrector for bridging 132609',0.00,0.00,0.00,5210.00,0.00,'2022-04-06 13:04:50','',''),(2651933,'1','197','1018',464,'Received from bridging 132609',0.00,0.00,5210.00,0.00,0.00,'2022-04-06 13:04:50','',''),(2651934,'1','197','1018',464,'Retail Sale Id 1643253',58080.00,0.00,0.00,96.00,1248.00,'2022-04-06 17:17:38','',''),(2651935,'1','197','1018',464,'Retail Sale Id 1643254',188760.00,0.00,0.00,312.00,4056.00,'2022-04-06 17:18:50','',''),(2651936,'1','197','1018',464,'Retail Sale Id 1643255',54450.00,0.00,0.00,90.00,1170.00,'2022-04-06 17:20:04','',''),(2651937,'1','197','1018',464,'Retail Sale Id 1643256',45423.40,0.00,0.00,75.08,976.04,'2022-04-07 14:28:45','',''),(2651938,'1','197','1018',464,'Retail Sale Id 1643257',472960.56,0.00,0.00,712.29,51284.88,'2022-04-07 14:29:38','',''),(2651939,'1','197','1018',464,'Retail Sale Id 1643258',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 14:41:04','',''),(2651940,'1','197','1018',464,'Retail Sale Id 1643259',12297.28,0.00,0.00,18.52,1333.44,'2022-04-07 14:54:29','',''),(2651941,'1','197','1018',464,'Retail Sale Id 1643260',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 15:46:37','',''),(2651942,'1','197','1018',464,'Retail Sale Id 1643261',115555.00,0.00,0.00,191.00,2483.00,'2022-04-07 15:50:48','',''),(2651943,'1','197','1018',464,'Retail Sale Id 1643262',3320.00,0.00,0.00,5.00,360.00,'2022-04-07 16:05:05','',''),(2651944,'1','197','1018',464,'Retail Sale Id 1643263',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 16:09:03','',''),(2651945,'1','197','1018',464,'Retail Sale Id 1643264',3997.28,0.00,0.00,6.02,433.44,'2022-04-07 16:16:57','',''),(2651946,'1','197','1018',464,'Retail Sale Id 1643265',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 16:22:47','',''),(2651947,'1','197','1018',464,'Retail Sale Id 1643266',91476.00,0.00,0.00,151.20,1965.60,'2022-04-07 16:54:50','',''),(2651948,'1','197','1018',464,'Retail Sale Id 1643267',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 16:59:45','',''),(2651949,'1','197','1018',464,'Retail Sale Id 1643268',24900.00,0.00,0.00,37.50,2700.00,'2022-04-07 17:00:45','',''),(2651950,'1','197','1018',464,'Retail Sale Id 1643269',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 17:01:49','',''),(2651951,'1','197','1018',464,'Retail Sale Id 1643270',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 17:11:10','',''),(2651952,'1','197','1018',464,'Retail Sale Id 1643271',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 17:13:24','',''),(2651953,'1','197','1018',464,'Retail Sale Id 1643272',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 17:41:29','',''),(2651954,'1','197','1018',464,'Retail Sale Id 1643273',24900.00,0.00,0.00,37.50,2700.00,'2022-04-07 17:52:46','',''),(2651955,'1','197','1018',464,'Retail Sale Id 1643274',3997.28,0.00,0.00,6.02,433.44,'2022-04-07 17:54:05','',''),(2651956,'1','197','1018',464,'Retail Sale Id 1643275',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 18:00:54','',''),(2651957,'1','197','1018',464,'Retail Sale Id 1643276',3353.20,0.00,0.00,5.05,363.60,'2022-04-07 18:27:14','',''),(2651958,'1','197','1018',464,'Retail Sale Id 1643277',1998.64,0.00,0.00,3.01,216.72,'2022-04-07 18:28:47','',''),(2651959,'1','197','1018',464,'Retail Sale Id 1643279',8300.00,0.00,0.00,12.50,900.00,'2022-04-07 18:30:14','',''),(2651960,'1','197','1018',464,'Retail Sale Id 1643280',54450.00,0.00,0.00,90.00,1170.00,'2022-04-07 23:14:00','',''),(2651961,'1','197','1018',464,'Retail Sale Id 1643281',45677.50,0.00,0.00,75.50,981.50,'2022-04-07 23:14:44','',''),(2651962,'1','197','1018',464,'Retail Sale Id 1643282',296469.36,0.00,0.00,446.49,32147.28,'2022-04-07 23:20:03','',''),(2651963,'1','197','1018',464,'Retail Sale Id 1643283',30250.00,0.00,0.00,50.00,650.00,'2022-04-08 08:34:00','',''),(2651964,'1','197','1018',464,'Retail Sale Id 1643284',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 10:03:31','',''),(2651965,'1','197','1018',464,'Retail Sale Id 1643285',1401.04,0.00,0.00,2.11,151.92,'2022-04-08 10:05:35','',''),(2651966,'1','197','1018',464,'Retail Sale Id 1643286',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 10:13:01','',''),(2651967,'1','197','1018',464,'Retail Sale Id 1643287',16600.00,0.00,0.00,25.00,1800.00,'2022-04-08 10:41:15','',''),(2651968,'1','197','1018',464,'Retail Sale Id 1643288',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 11:12:37','',''),(2651969,'1','197','1018',464,'Retail Sale Id 1643289',3353.20,0.00,0.00,5.05,363.60,'2022-04-08 11:14:07','',''),(2651970,'1','197','1018',464,'Retail Sale Id 1643290',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 12:07:49','',''),(2651971,'1','197','1018',464,'Retail Sale Id 1643291',9999.84,0.00,0.00,15.06,1084.32,'2022-04-08 12:54:09','',''),(2651972,'1','197','1018',464,'Retail Sale Id 1643292',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 12:55:25','',''),(2651973,'1','197','1018',464,'Retail Sale Id 1643293',4999.92,0.00,0.00,7.53,542.16,'2022-04-08 12:56:22','',''),(2651974,'1','197','1018',464,'Retail Sale Id 1643294',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 13:06:47','',''),(2651975,'1','197','1018',464,'Retail Sale Id 1643295',3997.28,0.00,0.00,6.02,433.44,'2022-04-08 13:22:48','',''),(2651976,'1','197','1018',464,'Retail Sale Id 1643296',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 13:27:31','',''),(2651977,'1','197','1018',464,'Retail Sale Id 1643297',3001.28,0.00,0.00,4.52,325.44,'2022-04-08 13:34:30','',''),(2651978,'1','197','1018',464,'Retail Sale Id 1643298',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 14:18:07','',''),(2651979,'1','197','1018',464,'Retail Sale Id 1643299',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 14:18:58','',''),(2651980,'1','197','1018',464,'Retail Sale Id 1643300',3353.20,0.00,0.00,5.05,363.60,'2022-04-08 14:19:53','',''),(2651981,'1','197','1018',464,'Retail Sale Id 1643301',12297.28,0.00,0.00,18.52,1333.44,'2022-04-08 14:23:13','',''),(2651982,'1','197','1018',464,'Retail Sale Id 1643302',15125.00,0.00,0.00,25.00,325.00,'2022-04-08 14:30:02','',''),(2651983,'1','197','1018',464,'Retail Sale Id 1643303',5298.72,0.00,0.00,7.98,574.56,'2022-04-08 14:42:42','',''),(2651984,'1','197','1018',464,'Retail Sale Id 1643304',3353.20,0.00,0.00,5.05,363.60,'2022-04-08 14:54:17','',''),(2651985,'1','197','1018',464,'Retail Sale Id 1643305',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 14:55:06','',''),(2651986,'1','197','1018',464,'Retail Sale Id 1643306',6640.00,0.00,0.00,10.00,720.00,'2022-04-08 14:57:06','',''),(2651987,'1','197','1018',464,'Retail Sale Id 1643307',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 15:00:49','',''),(2651988,'1','197','1018',464,'Retail Sale Id 1643308',13651.84,0.00,0.00,20.56,1480.32,'2022-04-08 15:02:26','',''),(2651989,'1','197','1018',464,'Retail Sale Id 1643309',1002.64,0.00,0.00,1.51,108.72,'2022-04-08 15:10:09','',''),(2651990,'1','197','1018',464,'Retail Sale Id 1643310',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 15:30:30','',''),(2651991,'1','197','1018',464,'Retail Sale Id 1643310',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 15:30:30','',''),(2651992,'1','197','1018',464,'Retail Sale Id 1643310',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 15:30:30','',''),(2651993,'1','197','1018',464,'Retail Sale Id 1643311',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 15:31:40','',''),(2651994,'1','197','1018',464,'Retail Sale Id 1643312',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 15:32:34','',''),(2651995,'1','197','1018',464,'Retail Sale Id 1643314',4999.92,0.00,0.00,7.53,542.16,'2022-04-08 15:35:26','',''),(2651996,'1','197','1018',464,'Retail Sale Id 1643315',3499.28,0.00,0.00,5.27,379.44,'2022-04-08 15:36:10','',''),(2651997,'1','197','1018',464,'Retail Sale Id 1643316',3997.28,0.00,0.00,6.02,433.44,'2022-04-08 15:46:33','',''),(2651998,'1','197','1018',464,'Retail Sale Id 1643318',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 15:48:10','',''),(2651999,'1','197','1018',464,'Retail Sale Id 1643319',9960.00,0.00,0.00,15.00,1080.00,'2022-04-08 16:15:59','',''),(2652000,'1','197','1018',464,'Retail Sale Id 1643320',3353.20,0.00,0.00,5.05,363.60,'2022-04-08 16:26:20','',''),(2652001,'1','197','1018',464,'Retail Sale Id 1643321',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 16:27:57','',''),(2652002,'1','197','1018',464,'Retail Sale Id 1643321',33200.00,0.00,0.00,50.00,3600.00,'2022-04-08 16:27:57','',''),(2652003,'1','197','1018',464,'Retail Sale Id 1643322',37510.00,0.00,0.00,62.00,806.00,'2022-04-08 16:30:52','',''),(2652004,'1','197','1018',464,'Retail Sale Id 1643323',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 16:39:48','',''),(2652005,'1','197','1018',464,'Retail Sale Id 1643324',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 16:44:28','',''),(2652006,'1','197','1018',464,'Retail Sale Id 1643324',3001.28,0.00,0.00,4.52,325.44,'2022-04-08 16:44:28','',''),(2652007,'1','197','1018',464,'Retail Sale Id 1643325',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 16:45:24','',''),(2652008,'1','197','1018',464,'Retail Sale Id 1643326',1002.64,0.00,0.00,1.51,108.72,'2022-04-08 16:55:17','',''),(2652009,'1','197','1018',464,'Retail Sale Id 1643327',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 16:57:35','',''),(2652010,'1','197','1018',464,'Retail Sale Id 1643328',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 17:04:04','',''),(2652011,'1','197','1018',464,'Retail Sale Id 1643329',3001.28,0.00,0.00,4.52,325.44,'2022-04-08 17:20:16','',''),(2652012,'1','197','1018',464,'Retail Sale Id 1643330',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 17:21:46','',''),(2652013,'1','197','1018',464,'Retail Sale Id 1643331',3499.28,0.00,0.00,5.27,379.44,'2022-04-08 17:25:34','',''),(2652014,'1','197','1018',464,'Retail Sale Id 1643332',3997.28,0.00,0.00,6.02,433.44,'2022-04-08 17:26:14','',''),(2652015,'1','197','1018',464,'Retail Sale Id 1643333',9960.00,0.00,0.00,15.00,1080.00,'2022-04-08 17:27:38','',''),(2652016,'1','197','1018',464,'Retail Sale Id 1643334',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 17:35:19','',''),(2652017,'1','197','1018',464,'Retail Sale Id 1643335',3997.28,0.00,0.00,6.02,433.44,'2022-04-08 17:37:07','',''),(2652018,'1','197','1018',464,'Retail Sale Id 1643336',6002.56,0.00,0.00,9.04,650.88,'2022-04-08 17:44:29','',''),(2652019,'1','197','1018',464,'Retail Sale Id 1643337',98010.00,0.00,0.00,162.00,2106.00,'2022-04-08 17:50:52','',''),(2652020,'1','197','1018',464,'Retail Sale Id 1643338',3320.00,0.00,0.00,5.00,360.00,'2022-04-08 18:09:25','',''),(2652021,'1','197','1018',464,'Retail Sale Id 1643339',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 18:16:01','',''),(2652022,'1','197','1018',464,'Retail Sale Id 1643340',15272.00,0.00,0.00,23.00,1656.00,'2022-04-08 18:21:30','',''),(2652023,'1','197','1018',464,'Retail Sale Id 1643341',697.20,0.00,0.00,1.05,75.60,'2022-04-08 18:32:02','',''),(2652024,'1','197','1018',464,'Retail Sale Id 1643342',15272.00,0.00,0.00,23.00,1656.00,'2022-04-08 18:36:12','',''),(2652025,'1','197','1018',464,'Retail Sale Id 1643343',3997.28,0.00,0.00,6.02,433.44,'2022-04-08 18:40:10','',''),(2652026,'1','197','1018',464,'Retail Sale Id 1643344',8300.00,0.00,0.00,12.50,900.00,'2022-04-08 18:42:23','',''),(2652027,'1','197','1018',464,'Retail Sale Id 1643345',1998.64,0.00,0.00,3.01,216.72,'2022-04-08 18:48:24','',''),(2652028,'1','197','1018',464,'Retail Sale Id 1643346',66400.00,0.00,0.00,100.00,7200.00,'2022-04-08 20:00:38','',''),(2652029,'1','197','1018',464,'Retail Sale Id 1643347',24700.80,0.00,0.00,37.20,2678.40,'2022-04-08 20:01:07','',''),(2652030,'1','197','1018',464,'Retail Sale Id 1643348',16600.00,0.00,0.00,25.00,1800.00,'2022-04-08 20:01:37','',''),(2652031,'1','197','1018',464,'Retail Sale Id 1643349',10298.64,0.00,0.00,15.51,1116.72,'2022-04-08 20:03:24','',''),(2652032,'1','197','1018',464,'Retail Sale Id 1643350',52030.00,0.00,0.00,86.00,1118.00,'2022-04-08 20:04:53','',''),(2652033,'1','197','1018',464,'Retail Sale Id 1643351',121000.00,0.00,0.00,200.00,2600.00,'2022-04-08 20:05:26','',''),(2652034,'1','197','1018',464,'Retail Sale Id 1643352',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 08:37:44','',''),(2652035,'1','197','1018',464,'Retail Sale Id 1643353',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 08:38:34','',''),(2652036,'1','197','1018',464,'Retail Sale Id 1643354',3499.28,0.00,0.00,5.27,379.44,'2022-04-09 08:39:35','',''),(2652037,'1','197','1018',464,'Retail Sale Id 1643355',3001.28,0.00,0.00,4.52,325.44,'2022-04-09 08:41:06','',''),(2652038,'1','197','1018',464,'Retail Sale Id 1643356',9960.00,0.00,0.00,15.00,1080.00,'2022-04-09 08:50:21','',''),(2652039,'1','197','1018',464,'Retail Sale Id 1643357',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 08:51:32','',''),(2652040,'1','197','1018',464,'Retail Sale Id 1643358',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 09:51:29','',''),(2652041,'1','197','1018',464,'Retail Sale Id 1643359',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 09:52:12','',''),(2652042,'1','197','1018',464,'Retail Sale Id 1643360',3499.28,0.00,0.00,5.27,379.44,'2022-04-09 09:54:02','',''),(2652043,'1','197','1018',464,'Retail Sale Id 1643361',10956.00,0.00,0.00,16.50,1188.00,'2022-04-09 10:02:02','',''),(2652044,'1','197','1018',464,'Retail Sale Id 1643362',14302.56,0.00,0.00,21.54,1550.88,'2022-04-09 10:14:32','',''),(2652045,'1','197','1018',464,'Retail Sale Id 1643363',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 10:18:42','',''),(2652046,'1','197','1018',464,'Retail Sale Id 1643364',1500.64,0.00,0.00,2.26,162.72,'2022-04-09 10:32:37','',''),(2652047,'1','197','1018',464,'Retail Sale Id 1643365',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 10:39:18','',''),(2652048,'1','197','1018',464,'Retail Sale Id 1643366',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 10:40:48','',''),(2652049,'1','197','1018',464,'Retail Sale Id 1643367',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 10:54:50','',''),(2652050,'1','197','1018',464,'Retail Sale Id 1643368',6998.56,0.00,0.00,10.54,758.88,'2022-04-09 10:55:44','',''),(2652051,'1','197','1018',464,'Retail Sale Id 1643369',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 11:00:41','',''),(2652052,'1','197','1018',464,'Retail Sale Id 1643370',24900.00,0.00,0.00,37.50,2700.00,'2022-04-09 11:01:37','',''),(2652053,'1','197','1018',464,'Retail Sale Id 1643371',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 11:04:15','',''),(2652054,'1','197','1018',464,'Retail Sale Id 1643372',1500.64,0.00,0.00,2.26,162.72,'2022-04-09 11:10:59','',''),(2652055,'1','197','1018',464,'Retail Sale Id 1643373',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 11:21:45','',''),(2652056,'1','197','1018',464,'Retail Sale Id 1643374',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 11:29:44','',''),(2652057,'1','197','1018',464,'Retail Sale Id 1643375',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 11:35:08','',''),(2652058,'1','197','1018',464,'Retail Sale Id 1643376',33200.00,0.00,0.00,50.00,3600.00,'2022-04-09 12:18:30','',''),(2652059,'1','197','1018',464,'Retail Sale Id 1643377',3353.20,0.00,0.00,5.05,363.60,'2022-04-09 12:41:12','',''),(2652060,'1','197','1018',464,'Retail Sale Id 1643378',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 12:41:54','',''),(2652061,'1','197','1018',464,'Retail Sale Id 1643379',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 12:57:55','',''),(2652062,'1','197','1018',464,'Retail Sale Id 1643380',16600.00,0.00,0.00,25.00,1800.00,'2022-04-09 13:02:49','',''),(2652063,'1','197','1018',464,'Retail Sale Id 1643381',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 13:17:15','',''),(2652064,'1','197','1018',464,'Retail Sale Id 1643382',12297.28,0.00,0.00,18.52,1333.44,'2022-04-09 13:19:00','',''),(2652065,'1','197','1018',464,'Retail Sale Id 1643383',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 13:30:38','',''),(2652066,'1','197','1018',464,'Retail Sale Id 1643384',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 13:55:18','',''),(2652067,'1','197','1018',464,'Retail Sale Id 1643385',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 13:56:20','',''),(2652068,'1','197','1018',464,'Retail Sale Id 1643386',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 14:02:02','',''),(2652069,'1','197','1018',464,'Retail Sale Id 1643387',11620.00,0.00,0.00,17.50,1260.00,'2022-04-09 14:11:42','',''),(2652070,'1','197','1018',464,'Retail Sale Id 1643388',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 14:15:31','',''),(2652071,'1','197','1018',464,'Retail Sale Id 1643389',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 14:24:56','',''),(2652072,'1','197','1018',464,'Retail Sale Id 1643390',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 14:34:37','',''),(2652073,'1','197','1018',464,'Retail Sale Id 1643391',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 14:45:55','',''),(2652074,'1','197','1018',464,'Retail Sale Id 1643392',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 14:46:59','',''),(2652075,'1','197','1018',464,'Retail Sale Id 1643393',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 14:48:56','',''),(2652076,'1','197','1018',464,'Retail Sale Id 1643394',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 14:51:13','',''),(2652077,'1','197','1018',464,'Retail Sale Id 1643395',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 14:55:19','',''),(2652078,'1','197','1018',464,'Retail Sale Id 1643396',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 15:04:14','',''),(2652079,'1','197','1018',464,'Retail Sale Id 1643397',3001.28,0.00,0.00,4.52,325.44,'2022-04-09 15:20:10','',''),(2652080,'1','197','1018',464,'Retail Sale Id 1643398',4999.92,0.00,0.00,7.53,542.16,'2022-04-09 15:22:22','',''),(2652081,'1','197','1018',464,'Retail Sale Id 1643399',16600.00,0.00,0.00,25.00,1800.00,'2022-04-09 15:22:58','',''),(2652082,'1','197','1018',464,'Retail Sale Id 1643400',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 15:25:28','',''),(2652083,'1','197','1018',464,'Retail Sale Id 1643401',3997.28,0.00,0.00,6.02,433.44,'2022-04-09 15:27:46','',''),(2652084,'1','197','1018',464,'Retail Sale Id 1643402',7636.00,0.00,0.00,11.50,828.00,'2022-04-09 15:30:00','',''),(2652085,'1','197','1018',464,'Retail Sale Id 1643403',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 16:00:49','',''),(2652086,'1','197','1018',464,'Retail Sale Id 1643405',3001.28,0.00,0.00,4.52,325.44,'2022-04-09 16:26:48','',''),(2652087,'1','197','1018',464,'Retail Sale Id 1643406',1998.64,0.00,0.00,3.01,216.72,'2022-04-09 16:30:30','',''),(2652088,'1','197','1018',464,'Retail Sale Id 1643408',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 16:39:10','',''),(2652089,'1','197','1018',464,'Retail Sale Id 1643409',8300.00,0.00,0.00,12.50,900.00,'2022-04-09 16:44:08','',''),(2652090,'1','197','1018',464,'Retail Sale Id 1643410',4999.92,0.00,0.00,7.53,542.16,'2022-04-09 18:21:49','',''),(2652091,'1','197','1018',464,'Retail Sale Id 1643411',6640.00,0.00,0.00,10.00,720.00,'2022-04-09 18:22:31','',''),(2652092,'1','197','1018',464,'Retail Sale Id 1643412',3001.28,0.00,0.00,4.52,325.44,'2022-04-09 18:35:38','',''),(2652093,'1','197','1018',464,'Retail Sale Id 1643413',253083.60,0.00,0.00,381.15,27442.80,'2022-04-09 23:33:33','',''),(2652094,'1','197','1018',464,'Retail Sale Id 1643414',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 08:19:32','',''),(2652095,'1','197','1018',464,'Retail Sale Id 1643415',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 09:16:47','',''),(2652096,'1','197','1018',464,'Retail Sale Id 1643416',1998.64,0.00,0.00,3.01,216.72,'2022-04-10 09:17:43','',''),(2652097,'1','197','1018',464,'Retail Sale Id 1643417',3399.68,0.00,0.00,5.12,368.64,'2022-04-10 09:34:34','',''),(2652098,'1','197','1018',464,'Retail Sale Id 1643418',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 09:38:58','',''),(2652099,'1','197','1018',464,'Retail Sale Id 1643419',24900.00,0.00,0.00,37.50,2700.00,'2022-04-10 10:18:13','',''),(2652100,'1','197','1018',464,'Retail Sale Id 1643420',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 10:19:10','',''),(2652101,'1','197','1018',464,'Retail Sale Id 1643421',6640.00,0.00,0.00,10.00,720.00,'2022-04-10 10:24:31','',''),(2652102,'1','197','1018',464,'Retail Sale Id 1643422',3997.28,0.00,0.00,6.02,433.44,'2022-04-10 10:25:57','',''),(2652103,'1','197','1018',464,'Retail Sale Id 1643423',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 10:36:28','',''),(2652104,'1','197','1018',464,'Retail Sale Id 1643424',1500.64,0.00,0.00,2.26,162.72,'2022-04-10 10:37:30','',''),(2652105,'1','197','1018',464,'Retail Sale Id 1643425',1998.64,0.00,0.00,3.01,216.72,'2022-04-10 10:47:02','',''),(2652106,'1','197','1018',464,'Retail Sale Id 1643426',3300.08,0.00,0.00,4.97,357.84,'2022-04-10 11:41:49','',''),(2652107,'1','197','1018',464,'Retail Sale Id 1643427',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 11:49:28','',''),(2652108,'1','197','1018',464,'Retail Sale Id 1643428',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 11:58:00','',''),(2652109,'1','197','1018',464,'Retail Sale Id 1643429',9960.00,0.00,0.00,15.00,1080.00,'2022-04-10 12:27:35','',''),(2652110,'1','197','1018',464,'Retail Sale Id 1643430',3997.28,0.00,0.00,6.02,433.44,'2022-04-10 12:30:42','',''),(2652111,'1','197','1018',464,'Retail Sale Id 1643431',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 12:32:01','',''),(2652112,'1','197','1018',464,'Retail Sale Id 1643432',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 12:38:24','',''),(2652113,'1','197','1018',464,'Retail Sale Id 1643433',33200.00,0.00,0.00,50.00,3600.00,'2022-04-10 13:44:59','',''),(2652114,'1','197','1018',464,'Retail Sale Id 1643434',25829.60,0.00,0.00,38.90,2800.80,'2022-04-10 13:46:45','',''),(2652115,'1','197','1018',464,'Distributed to ALL DEALER for sales id:350287',28226.56,0.00,0.00,47.68,0.00,'2022-04-10 13:57:50','',''),(2652116,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2474560.00,4180.00,0.00,0.00,'2022-04-10 17:48:08','',''),(2652117,'1','197',NULL,464,'Reception corrector for bridging 132610',0.00,0.00,0.00,4180.00,0.00,'2022-04-10 17:49:57','',''),(2652118,'1','197','1018',464,'Received from bridging 132610',0.00,0.00,4180.00,0.00,0.00,'2022-04-10 17:49:57','',''),(2652119,'1','197','1018',464,'Retail Sale Id 1643435',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 17:52:49','',''),(2652120,'1','197','1018',464,'Retail Sale Id 1643436',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 17:54:18','',''),(2652121,'1','197','1018',464,'Retail Sale Id 1643436',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 17:54:18','',''),(2652122,'1','197','1018',464,'Retail Sale Id 1643436',8300.00,0.00,0.00,12.50,900.00,'2022-04-10 17:54:18','',''),(2652123,'1','197','1018',464,'Retail Sale Id 1643437',3984.00,0.00,0.00,6.00,432.00,'2022-04-10 18:00:52','',''),(2652124,'1','197','1018',464,'Retail Sale Id 1643438',1998.64,0.00,0.00,3.01,216.72,'2022-04-10 18:05:54','',''),(2652125,'1','197','1018',464,'Retail Sale Id 1643439',664.00,0.00,0.00,1.00,72.00,'2022-04-10 18:27:55','',''),(2652126,'1','197','1018',464,'Retail Sale Id 1643440',282638.24,0.00,0.00,425.66,30647.52,'2022-04-10 20:12:48','',''),(2652127,'1','197','1018',464,'Retail Sale Id 1643441',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 07:37:40','',''),(2652128,'1','197','1018',464,'Retail Sale Id 1643442',4999.92,0.00,0.00,7.53,542.16,'2022-04-11 08:23:14','',''),(2652129,'1','197','1018',464,'Retail Sale Id 1643443',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 09:33:38','',''),(2652130,'1','197','1018',464,'Retail Sale Id 1643444',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 10:07:19','',''),(2652131,'1','197','1018',464,'Retail Sale Id 1643445',16600.00,0.00,0.00,25.00,1800.00,'2022-04-11 11:40:40','',''),(2652132,'1','197','1018',464,'Retail Sale Id 1643446',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 11:41:38','',''),(2652133,'1','197','1018',464,'Retail Sale Id 1643447',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 11:43:23','',''),(2652134,'1','197','1018',464,'Retail Sale Id 1643448',6998.56,0.00,0.00,10.54,758.88,'2022-04-11 11:51:13','',''),(2652135,'1','197','1018',464,'Retail Sale Id 1643449',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 11:52:47','',''),(2652136,'1','197','1018',464,'Retail Sale Id 1643450',0.00,0.00,0.00,0.00,0.00,'2022-04-11 14:02:29','',''),(2652137,'1','197','1018',464,'Retail Sale Id 1643451',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 14:10:57','',''),(2652138,'1','197','1018',464,'Retail Sale Id 1643452',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 14:50:12','',''),(2652139,'1','197','1018',464,'Retail Sale Id 1643454',3997.28,0.00,0.00,6.02,433.44,'2022-04-11 14:56:04','',''),(2652140,'1','197','1018',464,'Retail Sale Id 1643455',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 15:04:13','',''),(2652141,'1','197','1018',464,'Retail Sale Id 1643457',19920.00,0.00,0.00,30.00,2160.00,'2022-04-11 15:23:47','',''),(2652142,'1','197','1018',464,'Retail Sale Id 1643461',1998.64,0.00,0.00,3.01,216.72,'2022-04-11 15:26:28','',''),(2652143,'1','197','1018',464,'Retail Sale Id 1643462',3997.28,0.00,0.00,6.02,433.44,'2022-04-11 15:43:53','',''),(2652144,'1','197','1018',464,'Retail Sale Id 1643463',14999.76,0.00,0.00,22.59,1626.48,'2022-04-11 16:17:12','',''),(2652145,'1','197','1018',464,'Retail Sale Id 1643464',15936.00,0.00,0.00,24.00,1728.00,'2022-04-11 16:25:36','',''),(2652146,'1','197','1018',464,'Retail Sale Id 1643465',3997.28,0.00,0.00,6.02,433.44,'2022-04-11 16:59:10','',''),(2652147,'1','197','1018',464,'Retail Sale Id 1643466',3997.28,0.00,0.00,6.02,433.44,'2022-04-11 17:02:13','',''),(2652148,'1','197','1018',464,'Retail Sale Id 1643467',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 17:03:41','',''),(2652149,'1','197','1018',464,'Retail Sale Id 1643468',8300.00,0.00,0.00,12.50,900.00,'2022-04-11 17:07:38','',''),(2652150,'1','197','1018',464,'Retail Sale Id 1643469',3997.28,0.00,0.00,6.02,433.44,'2022-04-11 17:18:09','',''),(2652151,'1','197','1018',464,'Retail Sale Id 1643470',273674.24,0.00,0.00,412.16,29675.52,'2022-04-11 23:29:28','',''),(2652152,'1','197','1018',464,'Retail Sale Id 1643471',7503.20,0.00,0.00,11.30,813.60,'2022-04-12 09:57:23','',''),(2652153,'1','197','1018',464,'Retail Sale Id 1643472',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 10:17:52','',''),(2652154,'1','197','1018',464,'Retail Sale Id 1643473',32197.36,0.00,0.00,48.49,3491.28,'2022-04-12 14:50:15','',''),(2652155,'1','197','1018',464,'Retail Sale Id 1643474',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 14:53:08','',''),(2652156,'1','197','1018',464,'Retail Sale Id 1643475',4999.92,0.00,0.00,7.53,542.16,'2022-04-12 15:00:21','',''),(2652157,'1','197','1018',464,'Retail Sale Id 1643476',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 15:06:51','',''),(2652158,'1','197','1018',464,'Retail Sale Id 1643477',3353.20,0.00,0.00,5.05,363.60,'2022-04-12 15:15:42','',''),(2652159,'1','197','1018',464,'Retail Sale Id 1643478',1998.64,0.00,0.00,3.01,216.72,'2022-04-12 15:16:40','',''),(2652160,'1','197','1018',464,'Retail Sale Id 1643479',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 15:24:57','',''),(2652161,'1','197','1018',464,'Retail Sale Id 1643480',1002.64,0.00,0.00,1.51,108.72,'2022-04-12 15:26:37','',''),(2652162,'1','197','1018',464,'Retail Sale Id 1643481',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 15:44:09','',''),(2652163,'1','197','1018',464,'Retail Sale Id 1643482',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 16:21:48','',''),(2652164,'1','197','1018',464,'Retail Sale Id 1643483',1002.64,0.00,0.00,1.51,108.72,'2022-04-12 16:32:02','',''),(2652165,'1','197','1018',464,'Retail Sale Id 1643484',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 16:33:31','',''),(2652166,'1','197','1018',464,'Retail Sale Id 1643485',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 16:56:49','',''),(2652167,'1','197','1018',464,'Retail Sale Id 1643486',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 17:06:41','',''),(2652168,'1','197','1018',464,'Retail Sale Id 1643487',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 17:17:07','',''),(2652169,'1','197','1018',464,'Retail Sale Id 1643488',66400.00,0.00,0.00,100.00,7200.00,'2022-04-12 17:18:24','',''),(2652170,'1','197','1018',464,'Retail Sale Id 1643489',24900.00,0.00,0.00,37.50,2700.00,'2022-04-12 17:18:51','',''),(2652171,'1','197','1018',464,'Retail Sale Id 1643490',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 17:19:09','',''),(2652172,'1','197','1018',464,'Retail Sale Id 1643491',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 17:19:36','',''),(2652173,'1','197','1018',464,'Retail Sale Id 1643492',6640.00,0.00,0.00,10.00,720.00,'2022-04-12 17:19:59','',''),(2652174,'1','197','1018',464,'Retail Sale Id 1643493',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 17:20:21','',''),(2652175,'1','197','1018',464,'Retail Sale Id 1643494',6301.36,0.00,0.00,9.49,683.28,'2022-04-12 17:20:51','',''),(2652176,'1','197','1018',464,'Retail Sale Id 1643495',1998.64,0.00,0.00,3.01,216.72,'2022-04-12 17:22:45','',''),(2652177,'1','197','1018',464,'Retail Sale Id 1643496',1998.64,0.00,0.00,3.01,216.72,'2022-04-12 17:24:31','',''),(2652178,'1','197','1018',464,'Retail Sale Id 1643497',1998.64,0.00,0.00,3.01,216.72,'2022-04-12 17:37:27','',''),(2652179,'1','197','1018',464,'Retail Sale Id 1643498',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 17:38:07','',''),(2652180,'1','197','1018',464,'Retail Sale Id 1643499',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 17:47:33','',''),(2652181,'1','197','1018',464,'Retail Sale Id 1643500',3320.00,0.00,0.00,5.00,360.00,'2022-04-12 17:48:40','',''),(2652182,'1','197','1018',464,'Retail Sale Id 1643501',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 17:49:19','',''),(2652183,'1','197','1018',464,'Retail Sale Id 1643502',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 18:07:01','',''),(2652184,'1','197','1018',464,'Retail Sale Id 1643503',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 18:07:29','',''),(2652185,'1','197','1018',464,'Retail Sale Id 1643504',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 18:14:13','',''),(2652186,'1','197','1018',464,'Retail Sale Id 1643505',0.00,0.00,0.00,0.00,0.00,'2022-04-12 18:40:09','',''),(2652187,'1','197','1018',464,'Retail Sale Id 1643506',3997.28,0.00,0.00,6.02,433.44,'2022-04-12 18:46:07','',''),(2652188,'1','197','1018',464,'Retail Sale Id 1643507',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 18:46:45','',''),(2652189,'1','197','1018',464,'Retail Sale Id 1643508',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 18:48:50','',''),(2652190,'1','197','1018',464,'Retail Sale Id 1643509',8300.00,0.00,0.00,12.50,900.00,'2022-04-12 18:51:17','',''),(2652191,'1','197','1018',464,'Retail Sale Id 1643510',64481.04,0.00,0.00,97.11,6991.92,'2022-04-12 19:46:05','',''),(2652192,'1','197','1018',464,'Retail Sale Id 1643511',3001.28,0.00,0.00,4.52,325.44,'2022-04-13 09:50:38','',''),(2652193,'1','197','1018',464,'Retail Sale Id 1643512',3300.08,0.00,0.00,4.97,357.84,'2022-04-13 10:13:43','',''),(2652194,'1','197','1018',464,'Retail Sale Id 1643513',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 10:22:10','',''),(2652195,'1','197','1018',464,'Retail Sale Id 1643514',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 10:51:23','',''),(2652196,'1','197','1018',464,'Retail Sale Id 1643515',41500.00,0.00,0.00,62.50,4500.00,'2022-04-13 11:10:01','',''),(2652197,'1','197','1018',464,'Retail Sale Id 1643516',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 11:46:31','',''),(2652198,'1','197','1018',464,'Retail Sale Id 1643518',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 12:17:12','',''),(2652199,'1','197','1018',464,'Retail Sale Id 1643519',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 12:43:46','',''),(2652200,'1','197','1018',464,'Retail Sale Id 1643520',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 12:44:33','',''),(2652201,'1','197','1018',464,'Retail Sale Id 1643521',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 12:45:26','',''),(2652202,'1','197','1018',464,'Retail Sale Id 1643522',16613.28,0.00,0.00,25.02,1801.44,'2022-04-13 13:44:22','',''),(2652203,'1','197','1018',464,'Retail Sale Id 1643523',3001.28,0.00,0.00,4.52,325.44,'2022-04-13 13:49:45','',''),(2652204,'1','197','1018',464,'Retail Sale Id 1643524',6640.00,0.00,0.00,10.00,720.00,'2022-04-13 13:53:05','',''),(2652205,'1','197','1018',464,'Retail Sale Id 1643525',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 14:02:39','',''),(2652206,'1','197','1018',464,'Retail Sale Id 1643526',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 14:04:13','',''),(2652207,'1','197','1018',464,'Retail Sale Id 1643527',4999.92,0.00,0.00,7.53,542.16,'2022-04-13 17:04:17','',''),(2652208,'1','197','1018',464,'Retail Sale Id 1643528',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 17:05:16','',''),(2652209,'1','197','1018',464,'Retail Sale Id 1643529',3499.28,0.00,0.00,5.27,379.44,'2022-04-13 17:06:37','',''),(2652210,'1','197','1018',464,'Retail Sale Id 1643530',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 17:14:08','',''),(2652211,'1','197','1018',464,'Retail Sale Id 1643531',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 17:15:00','',''),(2652212,'1','197','1018',464,'Retail Sale Id 1643532',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 17:33:43','',''),(2652213,'1','197','1018',464,'Retail Sale Id 1643533',1998.64,0.00,0.00,3.01,216.72,'2022-04-13 17:39:15','',''),(2652214,'1','197','1018',464,'Retail Sale Id 1643534',3001.28,0.00,0.00,4.52,325.44,'2022-04-13 17:40:51','',''),(2652215,'1','197','1018',464,'Retail Sale Id 1643535',6640.00,0.00,0.00,10.00,720.00,'2022-04-13 17:50:18','',''),(2652216,'1','197','1018',464,'Retail Sale Id 1643536',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 17:50:58','',''),(2652217,'1','197','1018',464,'Retail Sale Id 1643537',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 17:51:42','',''),(2652218,'1','197','1018',464,'Retail Sale Id 1643538',8300.00,0.00,0.00,12.50,900.00,'2022-04-13 17:54:35','',''),(2652219,'1','197','1018',464,'Retail Sale Id 1643539',3353.20,0.00,0.00,5.05,363.60,'2022-04-13 18:02:07','',''),(2652220,'1','197','1018',464,'Retail Sale Id 1643540',13299.92,0.00,0.00,20.03,1442.16,'2022-04-13 18:08:40','',''),(2652221,'1','197','1018',464,'Retail Sale Id 1643541',16600.00,0.00,0.00,25.00,1800.00,'2022-04-13 18:22:07','',''),(2652222,'1','197','1018',464,'Retail Sale Id 1643542',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 18:26:26','',''),(2652223,'1','197','1018',464,'Retail Sale Id 1643543',1998.64,0.00,0.00,3.01,216.72,'2022-04-13 18:28:59','',''),(2652224,'1','197','1018',464,'Retail Sale Id 1643544',3997.28,0.00,0.00,6.02,433.44,'2022-04-13 18:38:04','',''),(2652225,'1','197','1018',464,'Retail Sale Id 1643545',1998.64,0.00,0.00,3.01,216.72,'2022-04-13 18:43:34','',''),(2652226,'1','197','1018',464,'Retail Sale Id 1643546',8001.20,0.00,0.00,12.05,867.60,'2022-04-13 18:49:38','',''),(2652227,'1','197','1018',464,'Retail Sale Id 1643547',288474.80,0.00,0.00,434.45,31280.40,'2022-04-13 21:47:05','',''),(2652228,'1','197','1018',464,'Retail Sale Id 1643548',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 09:27:17','',''),(2652229,'1','197','1018',464,'Retail Sale Id 1643549',16600.00,0.00,0.00,25.00,1800.00,'2022-04-14 09:28:17','',''),(2652230,'1','197','1018',464,'Retail Sale Id 1643550',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 09:49:03','',''),(2652231,'1','197','1018',464,'Retail Sale Id 1643552',6002.56,0.00,0.00,9.04,650.88,'2022-04-14 10:15:32','',''),(2652232,'1','197','1018',464,'Retail Sale Id 1643554',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 10:17:51','',''),(2652233,'1','197','1018',464,'Retail Sale Id 1643555',7503.20,0.00,0.00,11.30,813.60,'2022-04-14 10:57:06','',''),(2652234,'1','197','1018',464,'Retail Sale Id 1643556',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 10:58:51','',''),(2652235,'1','197','1018',464,'Retail Sale Id 1643557',1998.64,0.00,0.00,3.01,216.72,'2022-04-14 10:59:41','',''),(2652236,'1','197','1018',464,'Retail Sale Id 1643558',13280.00,0.00,0.00,20.00,1440.00,'2022-04-14 11:03:18','',''),(2652237,'1','197','1018',464,'Retail Sale Id 1643559',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 11:25:32','',''),(2652238,'1','197','1018',464,'Retail Sale Id 1643560',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 11:48:47','',''),(2652239,'1','197','1018',464,'Retail Sale Id 1643561',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 11:57:47','',''),(2652240,'1','197','1018',464,'Retail Sale Id 1643562',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 12:36:21','',''),(2652241,'1','197','1018',464,'Retail Sale Id 1643563',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 12:46:10','',''),(2652242,'1','197','1018',464,'Retail Sale Id 1643564',4999.92,0.00,0.00,7.53,542.16,'2022-04-14 13:18:08','',''),(2652243,'1','197','1018',464,'Retail Sale Id 1643565',6640.00,0.00,0.00,10.00,720.00,'2022-04-14 13:25:35','',''),(2652244,'1','197','1018',464,'Retail Sale Id 1643566',6998.56,0.00,0.00,10.54,758.88,'2022-04-14 13:34:16','',''),(2652245,'1','197','1018',464,'Retail Sale Id 1643567',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 13:37:30','',''),(2652246,'1','197','1018',464,'Retail Sale Id 1643568',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 13:43:00','',''),(2652247,'1','197','1018',464,'Retail Sale Id 1643569',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 13:45:48','',''),(2652248,'1','197','1018',464,'Retail Sale Id 1643570',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 13:49:53','',''),(2652249,'1','197','1018',464,'Retail Sale Id 1643571',1998.64,0.00,0.00,3.01,216.72,'2022-04-14 13:54:04','',''),(2652250,'1','197','1018',464,'Retail Sale Id 1643572',4999.92,0.00,0.00,7.53,542.16,'2022-04-14 14:25:34','',''),(2652251,'1','197','1018',464,'Retail Sale Id 1643573',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 14:30:54','',''),(2652252,'1','197','1018',464,'Retail Sale Id 1643574',1500.64,0.00,0.00,2.26,162.72,'2022-04-14 14:31:42','',''),(2652253,'1','197','1018',464,'Retail Sale Id 1643575',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 14:34:13','',''),(2652254,'1','197','1018',464,'Retail Sale Id 1643576',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 14:41:45','',''),(2652255,'1','197','1018',464,'Retail Sale Id 1643577',16600.00,0.00,0.00,25.00,1800.00,'2022-04-14 15:01:16','',''),(2652256,'1','197','1018',464,'Retail Sale Id 1643578',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 15:02:21','',''),(2652257,'1','197','1018',464,'Retail Sale Id 1643579',10298.64,0.00,0.00,15.51,1116.72,'2022-04-14 15:07:57','',''),(2652258,'1','197','1018',464,'Retail Sale Id 1643580',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 15:09:24','',''),(2652259,'1','197','1018',464,'Retail Sale Id 1643581',3353.20,0.00,0.00,5.05,363.60,'2022-04-14 15:20:51','',''),(2652260,'1','197','1018',464,'Retail Sale Id 1643582',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 15:22:15','',''),(2652261,'1','197','1018',464,'Retail Sale Id 1643583',16600.00,0.00,0.00,25.00,1800.00,'2022-04-14 15:33:47','',''),(2652262,'1','197','1018',464,'Retail Sale Id 1643584',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 15:36:47','',''),(2652263,'1','197','1018',464,'Retail Sale Id 1643585',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 15:49:30','',''),(2652264,'1','197','1018',464,'Retail Sale Id 1643586',9999.84,0.00,0.00,15.06,1084.32,'2022-04-14 15:59:40','',''),(2652265,'1','197','1018',464,'Retail Sale Id 1643587',7503.20,0.00,0.00,11.30,813.60,'2022-04-14 16:01:07','',''),(2652266,'1','197','1018',464,'Retail Sale Id 1643588',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 16:25:08','',''),(2652267,'1','197','1018',464,'Retail Sale Id 1643589',12616.00,0.00,0.00,19.00,1368.00,'2022-04-14 16:31:22','',''),(2652268,'1','197','1018',464,'Retail Sale Id 1643590',3353.20,0.00,0.00,5.05,363.60,'2022-04-14 16:32:13','',''),(2652269,'1','197','1018',464,'Retail Sale Id 1643591',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 16:33:02','',''),(2652270,'1','197','1018',464,'Retail Sale Id 1643592',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 16:41:17','',''),(2652271,'1','197','1018',464,'Retail Sale Id 1643593',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 16:53:42','',''),(2652272,'1','197','1018',464,'Retail Sale Id 1643594',1998.64,0.00,0.00,3.01,216.72,'2022-04-14 16:57:23','',''),(2652273,'1','197','1018',464,'Retail Sale Id 1643595',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 16:59:38','',''),(2652274,'1','197','1018',464,'Retail Sale Id 1643596',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 17:03:18','',''),(2652275,'1','197','1018',464,'Retail Sale Id 1643597',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 17:11:12','',''),(2652276,'1','197','1018',464,'Retail Sale Id 1643598',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 17:13:14','',''),(2652277,'1','197','1018',464,'Retail Sale Id 1643599',3001.28,0.00,0.00,4.52,325.44,'2022-04-14 17:21:06','',''),(2652278,'1','197','1018',464,'Retail Sale Id 1643600',6640.00,0.00,0.00,10.00,720.00,'2022-04-14 17:28:08','',''),(2652279,'1','197','1018',464,'Retail Sale Id 1643601',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 17:40:48','',''),(2652280,'1','197','1018',464,'Retail Sale Id 1643602',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 17:44:38','',''),(2652281,'1','197','1018',464,'Retail Sale Id 1643603',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 17:56:02','',''),(2652282,'1','197','1018',464,'Retail Sale Id 1643604',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 18:03:15','',''),(2652283,'1','197','1018',464,'Retail Sale Id 1643605',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 18:09:00','',''),(2652284,'1','197','1018',464,'Retail Sale Id 1643606',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 18:10:28','',''),(2652285,'1','197','1018',464,'Retail Sale Id 1643607',3399.68,0.00,0.00,5.12,368.64,'2022-04-14 18:11:03','',''),(2652286,'1','197','1018',464,'Retail Sale Id 1643608',11002.48,0.00,0.00,16.57,1193.04,'2022-04-14 18:15:05','',''),(2652287,'1','197','1018',464,'Retail Sale Id 1643609',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 18:16:20','',''),(2652288,'1','197','1018',464,'Retail Sale Id 1643610',16600.00,0.00,0.00,25.00,1800.00,'2022-04-14 18:18:28','',''),(2652289,'1','197','1018',464,'Retail Sale Id 1643611',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 18:25:48','',''),(2652290,'1','197','1018',464,'Retail Sale Id 1643612',3997.28,0.00,0.00,6.02,433.44,'2022-04-14 18:30:27','',''),(2652291,'1','197','1018',464,'Retail Sale Id 1643613',8300.00,0.00,0.00,12.50,900.00,'2022-04-14 18:32:05','',''),(2652292,'1','197','1018',464,'Retail Sale Id 1643614',66400.00,0.00,0.00,100.00,7200.00,'2022-04-14 18:42:48','',''),(2652293,'1','197','1018',464,'Retail Sale Id 1643615',24900.00,0.00,0.00,37.50,2700.00,'2022-04-14 18:43:26','',''),(2652294,'1','197','1018',464,'Retail Sale Id 1643616',4017.20,0.00,0.00,6.05,435.60,'2022-04-14 18:44:24','',''),(2652295,'1','197','1018',464,'Retail Sale Id 1643617',16600.00,0.00,0.00,25.00,1800.00,'2022-04-14 18:45:07','',''),(2652296,'1','197','1018',464,'Retail Sale Id 1643618',19720.80,0.00,0.00,29.70,2138.40,'2022-04-14 20:23:16','',''),(2652297,'1','197','1018',464,'Retail Sale Id 1643619',1500.64,0.00,0.00,2.26,162.72,'2022-04-15 09:17:37','',''),(2652298,'1','197','1018',464,'Retail Sale Id 1643620',16600.00,0.00,0.00,25.00,1800.00,'2022-04-15 09:22:36','',''),(2652299,'1','197','1018',464,'Retail Sale Id 1643622',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 10:36:02','',''),(2652300,'1','197','1018',464,'Retail Sale Id 1643624',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 11:09:13','',''),(2652301,'1','197','1018',464,'Retail Sale Id 1643625',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 11:10:23','',''),(2652302,'1','197','1018',464,'Retail Sale Id 1643626',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 11:10:56','',''),(2652303,'1','197','1018',464,'Retail Sale Id 1643627',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 11:30:11','',''),(2652304,'1','197','1018',464,'Retail Sale Id 1643628',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 11:36:10','',''),(2652305,'1','197','1018',464,'Retail Sale Id 1643629',1500.64,0.00,0.00,2.26,162.72,'2022-04-15 11:38:55','',''),(2652306,'1','197','1018',464,'Retail Sale Id 1643630',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 11:41:26','',''),(2652307,'1','197','1018',464,'Retail Sale Id 1643631',7503.20,0.00,0.00,11.30,813.60,'2022-04-15 12:06:28','',''),(2652308,'1','197','1018',464,'Retail Sale Id 1643632',3001.28,0.00,0.00,4.52,325.44,'2022-04-15 12:21:55','',''),(2652309,'1','197','1018',464,'Retail Sale Id 1643633',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 12:38:05','',''),(2652310,'1','197','1018',464,'Retail Sale Id 1643634',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 12:48:31','',''),(2652311,'1','197','1018',464,'Retail Sale Id 1643635',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 12:50:29','',''),(2652312,'1','197','1018',464,'Retail Sale Id 1643636',13944.00,0.00,0.00,21.00,1512.00,'2022-04-15 13:12:01','',''),(2652313,'1','197','1018',464,'Retail Sale Id 1643637',3499.28,0.00,0.00,5.27,379.44,'2022-04-15 13:13:25','',''),(2652314,'1','197','1018',464,'Retail Sale Id 1643638',12297.28,0.00,0.00,18.52,1333.44,'2022-04-15 13:36:10','',''),(2652315,'1','197','1018',464,'Retail Sale Id 1643639',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 13:52:04','',''),(2652316,'1','197','1018',464,'Retail Sale Id 1643640',16600.00,0.00,0.00,25.00,1800.00,'2022-04-15 13:52:40','',''),(2652317,'1','197','1018',464,'Retail Sale Id 1643641',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 13:58:34','',''),(2652318,'1','197','1018',464,'Retail Sale Id 1643642',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 14:04:07','',''),(2652319,'1','197','1018',464,'Retail Sale Id 1643643',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 14:09:04','',''),(2652320,'1','197','1018',464,'Retail Sale Id 1643644',1500.64,0.00,0.00,2.26,162.72,'2022-04-15 14:27:13','',''),(2652321,'1','197','1018',464,'Retail Sale Id 1643645',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 14:28:07','',''),(2652322,'1','197','1018',464,'Retail Sale Id 1643646',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 14:48:50','',''),(2652323,'1','197','1018',464,'Retail Sale Id 1643647',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 14:55:49','',''),(2652324,'1','197','1018',464,'Retail Sale Id 1643648',3001.28,0.00,0.00,4.52,325.44,'2022-04-15 15:00:48','',''),(2652325,'1','197','1018',464,'Retail Sale Id 1643648',33200.00,0.00,0.00,50.00,3600.00,'2022-04-15 15:00:48','',''),(2652326,'1','197','1018',464,'Retail Sale Id 1643649',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 15:02:19','',''),(2652327,'1','197','1018',464,'Retail Sale Id 1643650',24900.00,0.00,0.00,37.50,2700.00,'2022-04-15 15:03:15','',''),(2652328,'1','197','1018',464,'Retail Sale Id 1643651',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 15:03:56','',''),(2652329,'1','197','1018',464,'Retail Sale Id 1643652',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 15:16:49','',''),(2652330,'1','197','1018',464,'Retail Sale Id 1643653',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 15:18:45','',''),(2652331,'1','197','1018',464,'Retail Sale Id 1643654',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 15:20:56','',''),(2652332,'1','197','1018',464,'Retail Sale Id 1643655',3499.28,0.00,0.00,5.27,379.44,'2022-04-15 15:22:58','',''),(2652333,'1','197','1018',464,'Retail Sale Id 1643656',12297.28,0.00,0.00,18.52,1333.44,'2022-04-15 15:24:08','',''),(2652334,'1','197','1018',464,'Retail Sale Id 1643657',6998.56,0.00,0.00,10.54,758.88,'2022-04-15 15:29:20','',''),(2652335,'1','197','1018',464,'Retail Sale Id 1643658',1998.64,0.00,0.00,3.01,216.72,'2022-04-15 15:31:57','',''),(2652336,'1','197','1018',464,'Retail Sale Id 1643659',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 15:35:49','',''),(2652337,'1','197','1018',464,'Retail Sale Id 1643660',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 15:38:08','',''),(2652338,'1','197','1018',464,'Retail Sale Id 1643661',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 16:12:49','',''),(2652339,'1','197','1018',464,'Retail Sale Id 1643662',8300.00,0.00,0.00,12.50,900.00,'2022-04-15 16:16:03','',''),(2652340,'1','197','1018',464,'Retail Sale Id 1643663',3499.28,0.00,0.00,5.27,379.44,'2022-04-15 16:16:45','',''),(2652341,'1','197','1018',464,'Retail Sale Id 1643664',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 16:24:58','',''),(2652342,'1','197','1018',464,'Retail Sale Id 1643665',3997.28,0.00,0.00,6.02,433.44,'2022-04-15 16:29:53','',''),(2652343,'1','197','1018',464,'Retail Sale Id 1643666',66400.00,0.00,0.00,100.00,7200.00,'2022-04-15 18:31:23','',''),(2652344,'1','197','1018',464,'Retail Sale Id 1643667',24900.00,0.00,0.00,37.50,2700.00,'2022-04-15 18:32:21','',''),(2652345,'1','197','1018',464,'Retail Sale Id 1643669',30530.72,0.00,0.00,45.98,3310.56,'2022-04-15 18:33:49','',''),(2652346,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,37436.32,56.38,0.00,0.00,'2022-04-16 08:49:17','',''),(2652347,'1','197',NULL,464,'Reception corrector for bridging 132611',0.00,0.00,0.00,56.37,0.00,'2022-04-16 08:51:04','',''),(2652348,'1','197','1018',464,'Received from bridging 132611',0.00,0.00,56.37,0.00,0.00,'2022-04-16 08:51:04','',''),(2652349,'1','197','1018',464,'Retail Sale Id 1643671',37429.68,0.00,0.00,56.37,0.00,'2022-04-16 08:53:04','',''),(2652350,'1','197',NULL,464,'Purchased from AA RANO NIGERIA LIMITED',0.00,2794240.00,4720.00,0.00,0.00,'2022-04-17 00:07:49','',''),(2652351,'1','197',NULL,464,'Reception corrector for bridging 132612',0.00,0.00,0.00,4720.00,0.00,'2022-04-17 00:11:04','',''),(2652352,'1','197','1018',464,'Received from bridging 132612',0.00,0.00,4720.00,0.00,0.00,'2022-04-17 00:11:04','',''),(2652353,'1','197','1018',464,'Retail Sale Id 1643672',135940.72,0.00,0.00,204.73,14740.56,'2022-04-17 00:14:16','',''),(2652354,'1','197','1018',464,'Retail Sale Id 1643673',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 11:07:32','',''),(2652355,'1','197','1018',464,'Retail Sale Id 1643674',33200.00,0.00,0.00,50.00,3600.00,'2022-04-17 11:07:57','',''),(2652356,'1','197','1018',464,'Retail Sale Id 1643675',66400.00,0.00,0.00,100.00,7200.00,'2022-04-17 11:08:19','',''),(2652357,'1','197','1018',464,'Retail Sale Id 1643676',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 11:08:59','',''),(2652358,'1','197','1018',464,'Retail Sale Id 1643677',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 11:09:22','',''),(2652359,'1','197','1018',464,'Retail Sale Id 1643678',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 11:15:35','',''),(2652360,'1','197','1018',464,'Retail Sale Id 1643679',41500.00,0.00,0.00,62.50,4500.00,'2022-04-17 11:25:25','',''),(2652361,'1','197','1018',464,'Retail Sale Id 1643680',2602.88,0.00,0.00,3.92,282.24,'2022-04-17 11:37:37','',''),(2652362,'1','197','1018',464,'Retail Sale Id 1643681',1998.64,0.00,0.00,3.01,216.72,'2022-04-17 11:39:37','',''),(2652363,'1','197','1018',464,'Retail Sale Id 1643682',13280.00,0.00,0.00,20.00,1440.00,'2022-04-17 11:46:59','',''),(2652364,'1','197','1018',464,'Retail Sale Id 1643683',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 11:57:03','',''),(2652365,'1','197','1018',464,'Retail Sale Id 1643684',1998.64,0.00,0.00,3.01,216.72,'2022-04-17 11:59:46','',''),(2652366,'1','197','1018',464,'Retail Sale Id 1643685',21580.00,0.00,0.00,32.50,2340.00,'2022-04-17 12:06:24','',''),(2652367,'1','197','1018',464,'Retail Sale Id 1643686',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 12:08:13','',''),(2652368,'1','197','1018',464,'Retail Sale Id 1643688',5312.00,0.00,0.00,8.00,576.00,'2022-04-17 12:11:04','',''),(2652369,'1','197','1018',464,'Retail Sale Id 1643690',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 12:12:08','',''),(2652370,'1','197','1018',464,'Retail Sale Id 1643691',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 12:15:24','',''),(2652371,'1','197','1018',464,'Retail Sale Id 1643692',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 12:19:29','',''),(2652372,'1','197','1018',464,'Retail Sale Id 1643693',2802.08,0.00,0.00,4.22,303.84,'2022-04-17 12:32:14','',''),(2652373,'1','197','1018',464,'Retail Sale Id 1643694',2503.28,0.00,0.00,3.77,271.44,'2022-04-17 12:36:44','',''),(2652374,'1','197','1018',464,'Retail Sale Id 1643695',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 12:37:36','',''),(2652375,'1','197','1018',464,'Retail Sale Id 1643696',1998.64,0.00,0.00,3.01,216.72,'2022-04-17 12:41:31','',''),(2652376,'1','197','1018',464,'Retail Sale Id 1643697',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 12:43:25','',''),(2652377,'1','197','1018',464,'Retail Sale Id 1643698',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 12:51:24','',''),(2652378,'1','197','1018',464,'Retail Sale Id 1643699',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 12:55:55','',''),(2652379,'1','197','1018',464,'Retail Sale Id 1643700',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 12:59:50','',''),(2652380,'1','197','1018',464,'Retail Sale Id 1643701',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 13:05:39','',''),(2652381,'1','197','1018',464,'Retail Sale Id 1643702',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 13:08:50','',''),(2652382,'1','197','1018',464,'Retail Sale Id 1643703',3499.28,0.00,0.00,5.27,379.44,'2022-04-17 13:11:03','',''),(2652383,'1','197','1018',464,'Retail Sale Id 1643703',16600.00,0.00,0.00,25.00,1800.00,'2022-04-17 13:11:03','',''),(2652384,'1','197','1018',464,'Retail Sale Id 1643704',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 13:13:02','',''),(2652385,'1','197','1018',464,'Retail Sale Id 1643705',1500.64,0.00,0.00,2.26,162.72,'2022-04-17 13:23:39','',''),(2652386,'1','197','1018',464,'Retail Sale Id 1643705',4999.92,0.00,0.00,7.53,542.16,'2022-04-17 13:23:39','',''),(2652387,'1','197','1018',464,'Retail Sale Id 1643706',1998.64,0.00,0.00,3.01,216.72,'2022-04-17 13:28:01','',''),(2652388,'1','197','1018',464,'Retail Sale Id 1643707',1998.64,0.00,0.00,3.01,216.72,'2022-04-17 13:33:22','',''),(2652389,'1','197','1018',464,'Retail Sale Id 1643708',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 13:43:19','',''),(2652390,'1','197','1018',464,'Retail Sale Id 1643709',23240.00,0.00,0.00,35.00,2520.00,'2022-04-17 13:47:00','',''),(2652391,'1','197','1018',464,'Retail Sale Id 1643710',1500.64,0.00,0.00,2.26,162.72,'2022-04-17 14:01:33','',''),(2652392,'1','197','1018',464,'Retail Sale Id 1643711',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 14:06:51','',''),(2652393,'1','197','1018',464,'Retail Sale Id 1643712',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 14:08:10','',''),(2652394,'1','197','1018',464,'Retail Sale Id 1643713',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 14:57:20','',''),(2652395,'1','197','1018',464,'Retail Sale Id 1643714',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 15:02:50','',''),(2652396,'1','197','1018',464,'Retail Sale Id 1643715',6002.56,0.00,0.00,9.04,650.88,'2022-04-17 15:25:51','',''),(2652397,'1','197','1018',464,'Retail Sale Id 1643716',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 15:43:35','',''),(2652398,'1','197','1018',464,'Retail Sale Id 1643717',4999.92,0.00,0.00,7.53,542.16,'2022-04-17 16:02:15','',''),(2652399,'1','197','1018',464,'Retail Sale Id 1643718',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 16:22:13','',''),(2652400,'1','197','1018',464,'Retail Sale Id 1643719',12297.28,0.00,0.00,18.52,1333.44,'2022-04-17 16:57:23','',''),(2652401,'1','197','1018',464,'Retail Sale Id 1643720',3997.28,0.00,0.00,6.02,433.44,'2022-04-17 16:58:20','',''),(2652402,'1','197','1018',464,'Retail Sale Id 1643721',3320.00,0.00,0.00,5.00,360.00,'2022-04-17 17:31:20','',''),(2652403,'1','197','1018',464,'Retail Sale Id 1643722',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 17:36:43','',''),(2652404,'1','197','1018',464,'Retail Sale Id 1643723',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 17:44:25','',''),(2652405,'1','197','1018',464,'Retail Sale Id 1643724',1998.64,0.00,0.00,3.01,216.72,'2022-04-17 17:45:04','',''),(2652406,'1','197','1018',464,'Retail Sale Id 1643725',8300.00,0.00,0.00,12.50,900.00,'2022-04-17 17:50:21','',''),(2652407,'1','197','1018',464,'Retail Sale Id 1643726',43651.36,0.00,0.00,65.74,4733.28,'2022-04-17 18:47:29','',''),(2652408,'1','197','1018',464,'Retail Sale Id 1643727',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 08:51:07','',''),(2652409,'1','197','1018',464,'Retail Sale Id 1643728',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 09:03:55','',''),(2652410,'1','197','1018',464,'Retail Sale Id 1643729',1500.64,0.00,0.00,2.26,162.72,'2022-04-18 09:09:29','',''),(2652411,'1','197','1018',464,'Retail Sale Id 1643730',21580.00,0.00,0.00,32.50,2340.00,'2022-04-18 09:24:53','',''),(2652412,'1','197','1018',464,'Retail Sale Id 1643731',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 09:26:21','',''),(2652413,'1','197','1018',464,'Retail Sale Id 1643732',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 09:27:51','',''),(2652414,'1','197','1018',464,'Retail Sale Id 1643733',8300.00,0.00,0.00,12.50,900.00,'2022-04-18 09:30:33','',''),(2652415,'1','197','1018',464,'Retail Sale Id 1643734',8300.00,0.00,0.00,12.50,900.00,'2022-04-18 10:09:37','',''),(2652416,'1','197','1018',464,'Retail Sale Id 1643735',8300.00,0.00,0.00,12.50,900.00,'2022-04-18 10:36:40','',''),(2652417,'1','197','1018',464,'Retail Sale Id 1643736',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 10:37:58','',''),(2652418,'1','197','1018',464,'Retail Sale Id 1643737',16600.00,0.00,0.00,25.00,1800.00,'2022-04-18 10:44:25','',''),(2652419,'1','197','1018',464,'Retail Sale Id 1643738',16600.00,0.00,0.00,25.00,1800.00,'2022-04-18 11:19:23','',''),(2652420,'1','197','1018',464,'Retail Sale Id 1643739',16600.00,0.00,0.00,25.00,1800.00,'2022-04-18 11:21:43','',''),(2652421,'1','197','1018',464,'Retail Sale Id 1643740',1500.64,0.00,0.00,2.26,162.72,'2022-04-18 11:27:22','',''),(2652422,'1','197','1018',464,'Retail Sale Id 1643741',8300.00,0.00,0.00,12.50,900.00,'2022-04-18 11:37:31','',''),(2652423,'1','197','1018',464,'Retail Sale Id 1643742',8300.00,0.00,0.00,12.50,900.00,'2022-04-18 11:38:33','',''),(2652424,'1','197','1018',464,'Retail Sale Id 1643743',8300.00,0.00,0.00,12.50,900.00,'2022-04-18 11:43:45','',''),(2652425,'1','197','1018',464,'Retail Sale Id 1643744',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 12:00:36','',''),(2652426,'1','197','1018',464,'Retail Sale Id 1643745',3997.28,0.00,0.00,6.02,433.44,'2022-04-18 12:27:57','',