-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_195
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_195`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_195` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_195`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4102 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3834,20059,'',0,'20','1','195','SALES','','2021-11-01 14:34:00',5,0.00,0.00,'','178','2021-11-01 14:34:00','178',0,1),(3835,400353,'',0,'24','1','195','PURCHASES','','2021-11-01 14:34:13',5,0.00,0.00,'','178','2021-11-01 14:34:13','178',0,1),(3836,400354,'',0,'24','1','195','SALARIES','','2021-11-01 14:34:24',5,0.00,0.00,'','178','2021-11-01 14:34:24','178',0,1),(3837,40059,'',0,'6.1','1','195','CASH','','2021-11-01 14:34:37',5,0.00,0.00,'','178','2021-11-01 14:34:37','178',0,1),(4095,400744,'',0,'2','1','195','ZNB 1014717261','','2022-01-20 09:45:36',5,0.00,0.00,'','426','2022-01-20 09:45:36','426',0,0),(4096,400745,'',0,'2','1','195','POS FIDELITY','','2022-01-20 09:46:06',5,0.00,0.00,'','426','2022-01-20 09:46:06','426',0,0),(4097,400746,'',0,'2','1','195','ZNB TRNS 1213974315','','2022-05-11 09:10:29',5,0.00,0.00,'','426','2022-05-11 09:10:29','426',0,0),(4098,400747,'',0,'2','1','195','SUPLUS ACCT 1000300152','','2022-05-26 11:06:38',5,0.00,0.00,'','426','2022-05-26 11:06:38','426',0,0),(4099,400748,'',0,'2','1','195','DRIVER SHORT','','2022-05-30 10:35:33',5,0.00,0.00,'','426','2022-05-30 10:35:33','426',0,0),(4100,400749,'',0,'2','1','195','ECO POS','','2022-07-27 12:45:01',5,0.00,0.00,'','426','2022-07-27 12:45:01','426',0,0),(4101,400750,'',0,'2','1','195','GTB POS 0430454432','','2022-07-27 12:47:38',5,0.00,0.00,'','426','2022-07-27 12:47:38','426',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (3,'1','195','2022-07-03','','3835',0.00,'2022-07-05 18:07:50',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(6,'1','195','2022-07-15','','3835',0.00,'2022-07-19 11:53:21',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(7,'1','195','2022-07-24','','3835',0.00,'2022-07-25 13:27:21',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(8,'1','195','2022-08-01','','3835',0.00,'2022-08-02 13:12:47',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(9,'1','195','2022-08-08','','3835',0.00,'2022-08-08 14:01:39',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(10,'1','195','2022-08-14','','3835',0.00,'2022-08-14 20:49:59',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(11,'1','195','2022-08-22','','3835',0.00,'2022-08-22 13:31:15',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(12,'1','195','2022-08-29','','3835',0.00,'2022-08-29 21:43:33',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(13,'1','195','2022-09-01','','3835',0.00,'2022-09-01 19:01:52',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(14,'1','195','2022-09-07','','3835',0.00,'2022-09-07 19:55:35',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(15,'1','195','2022-09-13','','3835',0.00,'2022-09-13 14:04:51',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(17,'1','195','2022-09-21','','3835',0.00,'2022-09-21 15:36:04',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(18,'1','195','2022-09-29','','3835',0.00,'2022-09-29 15:51:37',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(19,'1','195','2022-10-01','','3835',0.00,'2022-10-01 13:43:31',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(21,'1','195','2022-10-08','','3835',0.00,'2022-10-10 12:50:45',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(22,'1','195','2022-10-18','','3835',0.00,'2022-10-18 14:51:29',0,'745','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (1,'1','195',3,3835,'Ago for Generator,280 liters,@780 per liter',218400.00),(2,'1','195',6,3835,'Ago for Generator,280 liters,@780 per liter',218400.00),(3,'1','195',7,3835,'Ago for Generator,280 liters,@7720 per liter',215600.00),(4,'1','195',8,3835,'Ago for Generator,280 liters,@770 per liter',215600.00),(5,'1','195',9,3835,'Ago for Generator,280 liters,@770 per liter',215600.00),(6,'1','195',10,3835,'Ago for Generator,280 liters,@770 per liter',215600.00),(7,'1','195',11,3835,'Ago for Generator,280 liters,@760 per liter',212800.00),(8,'1','195',12,3835,'80 LITERS@760 PER LITERS',60800.00),(9,'1','195',13,3835,'Ago for Generator,280 liters,@760 per liter',212800.00),(10,'1','195',14,3835,'Ago for Generator,280 liters,@760 per liter',212800.00),(11,'1','195',15,3835,'Ago for Generator,280 liters,@760 per liter',212800.00),(12,'1','195',17,3835,'Ago for Generator,280 liters,@760 per liter',212800.00),(13,'1','195',18,3835,'Ago for Generator,80 liters,@770 per liter',61600.00),(14,'1','195',19,3835,'Ago for Generator,280 liters,@770 per liter',215600.00),(15,'1','195',21,3835,'AGO FOR GENERATO 280 LITERS @780',218400.00),(16,'1','195',22,3835,'AGO FOR GENERATO 280 LITERS @800',224000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','1','195','DRIVER SHORT','DRIVER','080*****123','drivershort@gmail.com','OGOBMOSHO','OGUN','DRIVER','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 10:36:47',5,'426','2022-05-30 10:36:47','426'),(2,'','1','195','DIRECTOR ZAKARI','DR ZAKARI','08030625908','drzakari@gmail.com','KANO','KANO','Head Office Kano','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-12 13:51:38',5,'975','2022-12-12 13:51:38','975'),(3,'','1','195','NIGERIA POLICE FORCE (ELECTION','SP RAJI AFOLABI','08067488162','dopstransport@gmail.com','IBADAN','OYO STATE','IBADAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-21 17:23:33',5,'975','2023-02-21 17:23:33','975');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','195',1,'1021',239.31,17001.00,'2022-05-23','','2022-05-23 17:00:18','614','614',2022,'614','2022-05-23 17:00:18',5),('1','195',2,'1021',193.54,195.00,'2022-05-23','','2022-05-23 22:01:18','614','614',2022,'614','2022-05-23 22:01:18',5),('1','195',3,'1021',0.51,48466.00,'2022-05-24','','2022-05-24 09:39:20','426','426',2022,'426','2022-05-24 09:39:20',5),('1','195',4,'1019',6048.72,43508.00,'2022-05-25','','2022-05-25 14:57:36','426','426',2022,'426','2022-05-25 14:57:36',5),('1','195',5,'1021',1287.97,6117.00,'2022-05-25','','2022-05-25 16:30:22','426','426',2022,'426','2022-05-25 16:30:22',5),('1','195',6,'1019',17851.32,83596.00,'2022-05-25','','2022-05-25 17:32:44','426','426',2022,'426','2022-05-25 17:32:44',5),('1','195',7,'1019',15737.11,3700.00,'2022-05-26','','2022-05-26 16:29:07','426','426',2022,'426','2022-05-26 16:29:07',5),('1','195',8,'1020',18559.28,8300.00,'2022-05-26','','2022-05-26 16:29:45','426','426',2022,'426','2022-05-26 16:29:45',5),('1','195',9,'1021',4828.29,500.00,'2022-05-26','','2022-05-26 16:30:12','426','426',2022,'426','2022-05-26 16:30:12',5),('1','195',10,'1019',3700.00,700.00,'2022-05-26','','2022-05-26 18:03:24','614','614',2022,'614','2022-05-26 18:03:24',5),('1','195',11,'1021',3158.92,3221.00,'2022-06-07','','2022-06-07 16:51:24','614','614',2022,'614','2022-06-07 16:51:24',5),('1','195',12,'1019',45726.54,104300.00,'2022-06-09','','2022-06-09 11:50:34','426','426',2022,'426','2022-06-09 11:50:34',5),('1','195',13,'1020',33262.55,32700.00,'2022-06-09','','2022-06-09 11:51:05','426','426',2022,'426','2022-06-09 11:51:05',5),('1','195',14,'1021',0.12,500.00,'2022-06-09','','2022-06-09 11:51:20','426','426',2022,'426','2022-06-09 11:51:20',5),('1','195',15,'1019',59042.73,700.00,'2022-06-16','','2022-06-16 11:31:28','426','426',2022,'426','2022-06-16 11:31:28',5),('1','195',16,'1020',7172.07,7750.00,'2022-06-16','','2022-06-16 11:33:04','426','426',2022,'426','2022-06-16 11:33:04',5),('1','195',17,'1021',41876.55,41400.00,'2022-06-16','','2022-06-16 11:33:36','426','426',2022,'426','2022-06-16 11:33:36',5),('1','195',18,'1019',700.00,7950.00,'2022-06-19','','2022-06-19 12:49:20','426','426',2022,'426','2022-06-19 12:49:20',5),('1','195',19,'1020',7750.00,1050.00,'2022-06-19','','2022-06-19 12:52:05','426','426',2022,'426','2022-06-19 12:52:05',5),('1','195',20,'1021',16716.42,17216.00,'2022-06-19','','2022-06-19 12:52:46','426','426',2022,'426','2022-06-19 12:52:46',5),('1','195',21,'1021',4532.15,5140.00,'2022-06-30','','2022-06-30 14:17:08','614','614',2022,'614','2022-06-30 14:17:08',5),('1','195',22,'1021',0.01,49.00,'2022-07-04','','2022-07-04 14:23:27','614','614',2022,'614','2022-07-04 14:23:27',5),('1','195',23,'1021',3858.76,4013.00,'2022-07-18','','2022-07-18 15:12:34','614','614',2022,'614','2022-07-18 15:12:34',5),('1','195',24,'1021',657.94,1076.00,'2022-07-24','Add dipping of Ago','2022-07-24 21:27:23','614','614',2022,'614','2022-07-24 21:27:23',5),('1','195',25,'1021',3414.90,3946.00,'2022-08-01','','2022-08-01 21:26:33','614','614',2022,'614','2022-08-01 21:26:33',5),('1','195',26,'1021',416.50,575.00,'2022-08-10','','2022-08-10 22:02:47','614','614',2022,'614','2022-08-10 22:02:47',5),('1','195',27,'1021',1254.52,2352.00,'2022-08-22','','2022-08-22 21:32:03','614','614',2022,'614','2022-08-22 21:32:03',5),('1','195',28,'1021',2015.06,3474.00,'2022-09-05','','2022-09-05 21:37:03','614','614',2022,'614','2022-09-05 21:37:03',5),('1','195',29,'1021',49.79,1731.00,'2022-09-22','','2022-09-22 18:30:29','614','614',2022,'614','2022-09-22 18:30:29',5),('1','195',30,'1021',316.07,797.00,'2022-10-13','','2022-10-13 21:47:32','614','614',2022,'614','2022-10-13 21:47:32',5),('1','195',31,'1021',6771.65,6910.00,'2022-11-02','','2022-11-02 15:27:29','614','614',2022,'614','2022-11-02 15:27:29',5),('1','195',32,'1021',1024.99,2092.00,'2022-11-12','','2022-11-12 13:52:01','614','614',2022,'614','2022-11-12 13:52:01',5),('1','195',33,'1021',0.13,170.00,'2022-11-12','','2022-11-12 20:14:29','614','614',2022,'614','2022-11-12 20:14:29',5),('1','195',34,'1021',0.00,322.00,'2022-11-13','','2022-11-13 20:41:13','614','614',2022,'614','2022-11-13 20:41:13',5),('1','195',35,'1021',217.54,871.00,'2022-11-23','','2022-11-23 23:28:48','614','614',2022,'614','2022-11-23 23:28:48',5),('1','195',36,'1021',381.00,533.00,'2022-12-03','','2022-12-03 14:41:07','975','975',2022,'975','2022-12-03 14:41:07',5),('1','195',37,'1021',2907.07,3130.00,'2022-12-22','','2022-12-22 15:20:15','975','975',2022,'975','2022-12-22 15:20:15',5),('1','195',38,'1021',3819.61,4400.00,'2022-12-27','','2022-12-27 14:33:15','975','975',2022,'975','2022-12-27 14:33:15',5),('1','195',39,'1021',39.56,1103.00,'2022-12-28','','2022-12-28 09:56:13','975','975',2022,'975','2022-12-28 09:56:13',5),('1','195',40,'1021',1990.75,3500.00,'2023-01-24','','2023-01-24 12:38:25','734','734',2023,'734','2023-01-24 12:38:25',5),('1','195',41,'1021',201.04,500.00,'2023-01-24','','2023-01-24 21:04:12','734','734',2023,'734','2023-01-24 21:04:12',5),('1','195',42,'1021',3191.99,3300.00,'2023-02-02','','2023-02-02 15:14:58','734','734',2023,'734','2023-02-02 15:14:58',5),('1','195',43,'1021',448.30,1500.00,'2023-02-07','','2023-02-07 14:54:34','734','734',2023,'734','2023-02-07 14:54:34',5),('1','195',44,'1021',2810.45,5000.00,'2023-02-19','','2023-02-19 13:46:45','734','734',2023,'734','2023-02-19 13:46:45',5),('1','195',45,'1021',2033.64,2700.00,'2023-03-01','','2023-03-01 19:19:48','734','734',2023,'734','2023-03-01 19:19:48',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3025 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','195','1019',3005,'5','PUMP 3',637363.76,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:55:07','426'),('1','195','1019',3006,'5','PUMP 4',930610.77,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:55:51','426'),('1','195','1019',3007,'5','PUMP 7',537459.70,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:58:37','426'),('1','195','1019',3008,'5','PUMP 8',653377.31,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:59:42','426'),('1','195','1019',3009,'5','PUMP 11',341545.56,'DISPENSING PMS','',NULL,NULL,'',5,'2022-02-07 15:03:28','426'),('1','195','1019',3010,'5','PUMP 12',580283.59,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 13:16:13','426'),('1','195','1019',3011,'5','PUMP 15',865181.28,'DISPENSING PMS','',NULL,NULL,'',5,'2022-02-16 15:48:38','426'),('1','195','1019',3012,'5','PUMP 16',348848.25,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 13:18:43','426'),('1','195','1020',3013,'5','PUMP 1',366767.36,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:53:40','426'),('1','195','1020',3014,'5','PUMP 2',532721.90,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:54:17','426'),('1','195','1020',3015,'5','PUMP 5',263662.87,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 10:57:25','426'),('1','195','1020',3016,'5','PUMP 6',437495.11,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-21 14:35:19','426'),('1','195','1020',3017,'5','PUMP 9',211503.31,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 11:00:20','426'),('1','195','1020',3018,'5','PUMP 10',432035.32,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 11:01:06','426'),('1','195','1020',3019,'5','PUMP 13',280006.16,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-15 13:16:46','426'),('1','195','1020',3020,'5','PUMP 14',282201.40,'DISPENSING PMS','',NULL,NULL,'',5,'2022-04-14 11:03:00','426'),('1','195','1021',3021,'5','AGO PUMP 1',326848.85,'DISPENSING AGO','',NULL,NULL,'',5,'2023-03-04 13:33:24','178'),('1','195','1021',3022,'5','AGO PUMP 2',318340.55,'DISPENSING AGO','',NULL,NULL,'',5,'2023-03-04 13:33:44','178'),('1','195','1021',3023,'5','AGO PUMP 3',0.00,'DISPENSING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','195','1021',3024,'5','AGO PUMP 4',0.00,'DISPENSING AGO',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257962 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','195',254885,'Morning','2022-01-19','2022-01-19 00:00:00',NULL,'745',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','195',254886,'Morning','2022-01-01','2022-01-01 00:00:00',NULL,'745',1013671.10,1008894.20,'745','2022-01-19 18:18:13','426','2022-01-20 06:36:14',10,0),('1','195',254975,'Afternoon','2022-01-01','2022-01-01 00:00:00',NULL,'745',2173699.31,2132074.01,'745','2022-01-20 08:03:44','426','2022-01-20 08:09:24',10,0),('1','195',254993,'Morning','2022-01-02','2022-01-02 00:00:00',NULL,'745',1093042.74,1086981.24,'745','2022-01-20 08:41:05','426','2022-01-20 08:43:05',10,0),('1','195',254996,'Afternoon','2022-01-02','2022-01-02 00:00:00',NULL,'745',1562639.03,1550171.78,'745','2022-01-20 08:49:01','426','2022-01-20 08:53:00',10,0),('1','195',255005,'Morning','2022-01-03','2022-01-03 00:00:00',NULL,'745',2172449.45,2139329.90,'745','2022-01-20 09:09:50','426','2022-01-20 09:28:28',10,0),('1','195',255016,'Afternoon','2022-01-03','2022-01-03 00:00:00',NULL,'745',2948899.77,2899187.82,'745','2022-01-20 10:09:09','426','2022-01-20 10:18:36',10,0),('1','195',255073,'Morning','2022-01-04','2022-01-04 00:00:00',NULL,'745',2923424.72,2874839.87,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','195',255120,'Morning','2022-01-04','2022-01-04 00:00:00',NULL,'745',2868943.60,2820358.75,'745','2022-01-20 17:06:39','426','2022-01-20 17:09:37',10,0),('1','195',255124,'Afternoon','2022-01-04','2022-01-04 00:00:00',NULL,'745',2842858.56,2809542.21,'745','2022-01-20 17:42:01','426','2022-01-20 17:57:02',10,0),('1','195',255132,'Morning','2022-01-05','2022-01-05 00:00:00',NULL,'745',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','195',255328,'Morning','2022-01-05','2022-01-05 00:00:00',NULL,'745',2986944.32,2932510.67,'745','2022-01-21 14:50:21','426','2022-01-21 16:38:53',10,0),('1','195',255367,'Afternoon','2022-01-05','2022-01-05 00:00:00',NULL,'745',4097456.91,4006618.41,'745','2022-01-21 16:47:42','426','2022-01-21 17:11:07',10,0),('1','195',255375,'Morning','2022-01-06','2022-01-06 00:00:00',NULL,'745',3463311.60,3369731.10,'745','2022-01-21 17:16:43','426','2022-01-21 17:19:08',10,0),('1','195',255377,'Afternoon','2022-01-06','2022-01-06 00:00:00',NULL,'745',2759034.37,2708676.22,'745','2022-01-21 17:26:12','426','2022-01-21 17:33:35',10,0),('1','195',255382,'Morning','2022-01-07','2022-01-07 00:00:00',NULL,'745',1703040.48,1685671.83,'745','2022-01-21 17:40:52','426','2022-01-21 17:42:56',10,0),('1','195',255384,'Afternoon','2022-01-07','2022-01-07 00:00:00',NULL,'745',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','195',255394,'Afternoon','2022-01-07','2022-01-07 00:00:00',NULL,'745',2856625.03,2800869.13,'745','2022-01-21 18:47:40','426','2022-01-21 19:00:07',10,0),('1','195',255413,'Morning','2022-01-08','2022-01-08 00:00:00',NULL,'745',2944516.92,2879232.72,'745','2022-01-22 07:28:18','426','2022-01-22 13:33:43',10,0),('1','195',255588,'Afternoon','2022-01-08','2022-01-08 00:00:00',NULL,'745',2757191.96,2717499.56,'745','2022-01-22 13:50:24','426','2022-01-24 17:26:55',10,0),('1','195',256506,'Morning','2022-01-09','2022-01-09 00:00:00',NULL,'745',1888660.41,1860667.26,'745','2022-01-26 07:45:59','426','2022-01-26 16:50:39',10,0),('1','195',256650,'Afternoon','2022-01-09','2022-01-09 00:00:00',NULL,'745',1937650.36,1915550.71,'745','2022-01-26 17:37:44','426','2022-01-27 11:36:10',10,0),('1','195',256841,'Morning','2022-01-10','2022-01-10 00:00:00',NULL,'745',2446792.72,2384841.72,'745','2022-01-27 13:50:27','426','2022-01-28 14:44:14',10,0),('1','195',257131,'Afternoon','2022-01-10','2022-01-10 00:00:00',NULL,'745',2883488.42,2808242.42,'745','2022-02-04 14:56:04','426','2022-02-04 14:57:49',10,0),('1','195',257132,'Morning Shift','2022-01-11','2022-01-11 00:00:00',NULL,'745',2955267.00,2955267.00,'426','2022-02-04 15:18:12','426','2022-02-04 15:20:47',10,0),('1','195',257133,'Afternoon Shift','2022-01-11','2022-01-11 00:00:00',NULL,'745',2744195.90,2744195.90,'745','2022-02-04 15:26:21','426','2022-02-04 15:27:31',10,0),('1','195',257134,'Morning Shift','2022-01-12','2022-01-12 00:00:00',NULL,'745',2517627.33,2517627.33,'745','2022-02-04 15:35:49','426','2022-02-04 15:37:24',10,0),('1','195',257135,'Afternoon Shift','2022-01-12','2022-01-12 00:00:00',NULL,'745',2864665.27,2864665.27,'745','2022-02-07 13:14:03','426','2022-02-07 13:23:26',10,0),('1','195',257136,'Morning','2022-01-13','2022-01-13 00:00:00',NULL,'745',1507065.99,1507065.99,'745','2022-02-07 14:26:04','426','2022-02-07 14:33:16',10,0),('1','195',257137,'Afternoon','2022-01-13','2022-01-13 00:00:00',NULL,'745',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','195',257138,'Afternoon Shift','2022-01-13','2022-01-13 00:00:00',NULL,'745',3391471.62,3391471.62,'745','2022-02-16 10:28:23','426','2022-02-16 10:33:39',10,0),('1','195',257139,'Morning Shift','2022-01-14','2022-01-14 00:00:00',NULL,'745',2577208.31,2577208.31,'745','2022-02-16 10:43:06','426','2022-02-16 10:46:59',10,0),('1','195',257140,'Afternoon Shift','2022-01-14','2022-01-14 00:00:00',NULL,'745',2443237.75,2443237.75,'745','2022-02-16 10:50:08','426','2022-02-16 10:58:07',10,0),('1','195',257141,'Morning Shift','2022-01-15','2022-01-15 00:00:00',NULL,'745',3176776.07,3176776.07,'745','2022-02-16 11:01:18','426','2022-02-16 11:03:42',10,0),('1','195',257142,'Afternoon Shift','2022-01-15','2022-01-15 00:00:00',NULL,'745',3816630.06,3816630.06,'745','2022-02-16 11:06:58','426','2022-02-16 11:09:19',10,0),('1','195',257143,'Morning Shift','2022-01-16','2022-01-16 00:00:00',NULL,'745',2400323.13,2400323.13,'745','2022-02-16 11:21:20','426','2022-02-16 11:24:19',10,0),('1','195',257144,'Afternoon Shift','2022-01-16','2022-01-16 00:00:00',NULL,'745',3135144.78,3135144.78,'745','2022-02-16 11:30:33','426','2022-02-16 11:37:34',10,0),('1','195',257145,'Morning Shift','2022-01-17','2022-01-17 00:00:00',NULL,'745',3540964.76,3540964.76,'745','2022-02-16 11:41:53','426','2022-02-16 11:47:40',10,0),('1','195',257146,'Afternoon Shift','2022-01-17','2022-01-17 00:00:00',NULL,'745',2760153.31,2760153.31,'745','2022-02-16 11:51:35','426','2022-02-16 15:26:46',10,0),('1','195',257147,'Morning Shift','2022-01-18','2022-01-18 00:00:00',NULL,'745',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','195',257148,'Morning Shift','2022-01-18','2022-01-18 00:00:00',NULL,'745',1761079.77,1761079.77,'745','2022-02-16 15:52:49','426','2022-02-16 15:57:16',10,0),('1','195',257149,'Afternoon Shift','2022-01-18','2022-01-18 00:00:00',NULL,'745',3282112.67,3282112.67,'745','2022-02-16 15:59:34','426','2022-02-16 16:02:25',10,0),('1','195',257150,'MORNING','2022-01-19','2022-03-08 14:27:20','2022-03-09 14:27:20','745',2124413.29,2124413.29,'745','2022-03-08 14:39:21','426','2022-03-14 18:35:05',10,0),('1','195',257151,'AFTERNOON','2022-01-19','2022-03-15 09:25:49','2022-03-16 09:25:49','745',3780980.71,3491025.91,'745','2022-03-15 09:33:11','426','2022-03-15 10:07:57',10,0),('1','195',257152,'MORNING','2022-01-20','2022-03-15 17:59:38','2022-03-16 17:59:38','745',2822256.94,2629120.54,'745','2022-03-15 18:04:20','426','2022-03-16 09:38:57',10,0),('1','195',257153,'AFTERNOON','2022-01-20','2022-03-16 10:08:24','2022-03-17 10:08:24','745',3019855.12,2788963.12,'745','2022-03-16 10:12:58','426','2022-03-16 10:15:06',10,0),('1','195',257154,'MORNING','2022-01-21','2022-03-16 10:20:24','2022-03-17 10:20:24','745',2106046.52,1910486.87,'745','2022-03-16 10:23:24','426','2022-03-16 10:26:04',10,0),('1','195',257155,'AFTERNOON','2022-01-21','2022-03-16 11:23:25','2022-03-17 11:23:25','745',1120327.20,968184.00,'745','2022-03-16 11:24:22','426','2022-03-16 11:31:18',10,0),('1','195',257156,'MORNING','2022-01-22','2022-03-16 11:38:49','2022-03-17 11:38:49','745',3701449.49,3376554.59,'745','2022-03-16 11:47:41','426','2022-03-16 11:53:22',10,0),('1','195',257157,'AFTERNOON','2022-01-22','2022-03-16 12:52:04','2022-03-17 12:52:04','745',3882755.64,3584872.89,'745','2022-03-16 12:55:51','426','2022-03-16 13:23:19',10,0),('1','195',257158,'MORNING','2022-01-23','2022-03-16 14:33:02','2022-03-17 14:33:02','745',1808853.63,1717505.78,'745','2022-03-16 14:36:32','426','2022-03-16 15:58:32',10,0),('1','195',257159,'AFTERNOON','2022-01-23','2022-03-16 18:05:23','2022-03-17 18:05:23','745',2588331.88,2428581.63,'745','2022-03-16 18:08:29','426','2022-03-18 10:05:57',10,0),('1','195',257160,'MORNING','2022-01-24','2022-03-18 12:32:22','2022-03-19 12:32:22','745',2899130.58,2722581.68,'745','2022-03-18 12:35:18','426','2022-03-19 13:58:34',10,0),('1','195',257161,'AFTERNOON','2022-01-24','2022-03-19 15:31:59','2022-03-20 15:31:59','745',2317967.29,2260939.99,'745','2022-03-19 15:35:50','426','2022-03-21 14:04:12',10,0),('1','195',257162,'Morning','2022-01-25','2022-03-21 15:53:51','2022-03-22 15:53:51','745',1639899.96,1633736.20,'745','2022-03-22 09:34:27','426','2022-03-22 17:05:07',10,0),('1','195',257163,'AFTERNOON','2022-01-25','2022-03-22 17:17:13','2022-03-23 17:17:13','745',0.00,0.00,'745','2022-03-23 13:54:36','426','2022-03-24 10:41:46',10,0),('1','195',257164,'Afternoon','2022-01-25','2022-03-24 11:03:00','2022-03-25 11:03:00','745',4026787.24,3767164.74,'745','2022-03-24 11:10:24','426','2022-03-24 12:22:52',10,0),('1','195',257165,'Morning','2022-01-26','2022-03-24 12:31:16','2022-03-25 12:31:16','745',1857124.60,1792258.60,'745','2022-03-24 12:39:11','426','2022-03-24 16:48:47',10,0),('1','195',257166,'Afternoon','2022-01-26','2022-03-24 17:10:36','2022-03-25 17:10:36','745',4198886.45,3913683.95,'745','2022-03-24 17:15:31','426','2022-03-24 17:16:53',10,0),('1','195',257167,'Morning','2022-01-27','2022-03-24 17:21:35','2022-03-25 17:21:35','745',2417522.43,2417522.43,'745','2022-03-24 17:24:40','426','2022-03-24 17:26:01',10,0),('1','195',257168,'Afternoon','2022-01-27','2022-03-24 17:27:38','2022-03-25 17:27:38','745',3422574.25,3422574.25,'745','2022-03-24 17:31:09','426','2022-03-24 17:31:55',10,0),('1','195',257169,'Morning','2022-01-28','2022-03-24 17:35:28','2022-03-25 17:35:28','745',1625520.30,1625520.30,'745','2022-03-24 17:41:15','426','2022-03-24 17:42:09',10,0),('1','195',257170,'Afternoon','2022-01-28','2022-03-24 17:45:59','2022-03-25 17:45:59','745',3851508.89,3851508.89,'745','2022-03-24 17:53:47','426','2022-03-24 17:54:42',10,0),('1','195',257171,'Morning','2022-01-29','2022-03-24 18:04:03','2022-03-25 18:04:03','745',2891058.78,2891058.78,'745','2022-03-24 18:07:22','426','2022-03-24 18:08:21',10,0),('1','195',257172,'Afternoon','2022-01-29','2022-03-24 18:09:42','2022-03-25 18:09:42','745',3752696.12,3752696.12,'745','2022-03-24 18:12:56','426','2022-03-24 18:13:44',10,0),('1','195',257173,'Morning','2022-01-30','2022-03-24 18:20:18','2022-03-25 18:20:18','745',2559114.30,2559114.30,'745','2022-03-24 18:24:43','426','2022-03-24 18:25:21',10,0),('1','195',257174,'Afternoon','2022-01-30','2022-03-24 18:27:12','2022-03-25 18:27:12','745',1939200.21,1939200.21,'745','2022-03-24 18:29:41','426','2022-03-24 18:30:19',10,0),('1','195',257175,'Morning','2022-01-31','2022-03-24 18:34:55','2022-03-25 18:34:55','745',2032701.58,2032701.58,'745','2022-03-24 18:37:26','426','2022-03-24 18:39:04',10,0),('1','195',257176,'Afternoon','2022-01-31','2022-03-24 18:40:26','2022-03-25 18:40:26','745',2963163.84,2963163.84,'745','2022-03-24 18:43:16','426','2022-03-24 18:43:54',10,0),('1','195',257177,'Morning','2022-02-01','2022-03-25 09:35:04','2022-03-26 09:35:04','745',2365186.08,2365186.08,'745','2022-03-25 09:37:35','426','2022-03-25 11:36:01',10,0),('1','195',257178,'Afternoon','2022-02-01','2022-03-25 12:32:53','2022-03-26 12:32:53','745',3095481.97,3095481.97,'745','2022-03-25 12:39:27','426','2022-03-25 16:46:27',10,0),('1','195',257179,'Morning','2022-02-02','2022-03-25 17:37:10','2022-03-26 17:37:10','745',3766666.48,3766666.48,'745','2022-03-25 17:39:59','426','2022-03-26 13:31:21',10,0),('1','195',257180,'Afternoon','2022-02-02','2022-03-26 15:57:10','2022-03-27 15:57:10','745',3263556.75,3263556.75,'745','2022-03-26 16:02:02','426','2022-03-29 10:36:04',10,0),('1','195',257181,'Morning','2022-02-03','2022-03-29 10:49:57','2022-03-30 10:49:57','745',3200099.96,3200099.96,'745','2022-03-29 10:54:51','426','2022-04-07 16:23:12',10,0),('1','195',257182,'Afternoon','2022-02-03','2022-04-12 12:21:42','2022-04-13 12:21:42','745',5109449.00,3829474.62,'745','2022-04-12 12:27:56','426','2022-04-12 12:33:59',10,0),('1','195',257183,'Morning','2022-02-04','2022-04-12 12:38:27','2022-04-13 12:38:27','745',6019180.20,3969958.88,'745','2022-04-12 12:44:25','426','2022-04-12 14:26:59',10,0),('1','195',257184,'Afternoon','2022-02-04','2022-04-12 14:49:32','2022-04-13 14:49:32','745',0.00,0.00,'426','2022-04-14 11:00:35','426','2022-04-14 11:02:17',10,0),('1','195',257185,'Afternoon','2022-02-04','2022-04-14 11:22:11','2022-04-15 11:22:11','745',4210399.05,3288882.75,'745','2022-04-14 11:29:15','426','2022-04-14 14:55:22',10,0),('1','195',257186,'Morning','2022-02-05','2022-04-15 10:00:13','2022-04-16 10:00:13','745',4787192.70,3374194.52,'745','2022-04-15 10:06:18','426','2022-04-15 10:10:43',10,0),('1','195',257187,'Afternoon','2022-02-05','2022-04-15 10:13:19','2022-04-16 10:13:19','745',3777713.50,2959515.96,'745','2022-04-15 10:17:57','426','2022-04-15 10:38:06',10,0),('1','195',257188,'Morning','2022-02-06','2022-04-15 10:54:18','2022-04-16 10:54:18','745',3041918.90,2330967.86,'745','2022-04-15 10:57:17','426','2022-04-15 11:06:55',10,0),('1','195',257189,'Afternoon','2022-02-06','2022-04-15 11:17:01','2022-04-16 11:17:01','745',4260791.15,3252589.53,'745','2022-04-15 11:20:12','426','2022-04-15 11:21:29',10,0),('1','195',257190,'Morning','2022-02-07','2022-04-15 11:27:53','2022-04-16 11:27:53','745',2959537.95,2549242.35,'745','2022-04-15 11:30:21','426','2022-04-15 11:31:02',10,0),('1','195',257191,'Afternoon','2022-02-07','2022-04-15 11:33:35','2022-04-16 11:33:35','745',5361671.40,4079802.26,'745','2022-04-15 11:47:29','426','2022-04-15 15:23:23',10,0),('1','195',257192,'Morning','2022-02-08','2022-04-15 15:26:45','2022-04-16 15:26:45','745',11749890.00,7571633.72,'745','2022-04-15 15:29:16','426','2022-04-15 15:30:49',10,0),('1','195',257193,'Afternoon','2022-02-08','2022-04-15 15:36:28','2022-04-16 15:36:28','745',3233650.00,2881334.79,'745','2022-04-15 15:39:00','426','2022-04-15 15:40:54',10,0),('1','195',257194,'Morning','2022-02-09','2022-04-15 15:50:23','2022-04-16 15:50:23','745',4529330.75,4245916.17,'745','2022-04-15 15:57:13','426','2022-04-15 16:43:05',10,0),('1','195',257195,'Afternoon','2022-02-09','2022-04-15 16:45:40','2022-04-16 16:45:40','745',2108766.00,2083205.20,'745','2022-04-15 16:48:08','426','2022-04-15 17:03:37',10,0),('1','195',257196,'Morning','2022-02-10','2022-04-16 11:20:52','2022-04-17 11:20:52','745',3084807.35,2152848.07,'745','2022-04-19 12:36:53','426','2022-04-20 11:45:08',10,0),('1','195',257197,'Afternoon','2022-02-10','2022-04-20 11:53:33','2022-04-21 11:53:33','745',5591428.05,3552835.49,'745','2022-04-20 11:59:15','426','2022-04-20 12:02:58',10,0),('1','195',257198,'Morning','2022-01-11','2022-04-20 12:14:38','2022-04-21 12:14:38','745',5513237.80,3606573.28,'745','2022-04-20 12:19:13','426','2022-04-20 12:20:39',10,0),('1','195',257199,'Afternoon','2022-02-11','2022-04-20 12:30:49','2022-04-21 12:30:49','745',5260473.80,3852751.92,'745','2022-04-20 12:34:31','426','2022-04-21 09:35:55',10,0),('1','195',257200,'Morning','2022-02-12','2022-04-21 09:52:48','2022-04-22 09:52:48','745',11020220.10,7410503.25,'745','2022-04-21 09:56:06','426','2022-04-21 10:06:07',10,0),('1','195',257201,'Afternoon','2022-02-12','2022-04-21 10:44:52','2022-04-22 10:44:52','745',2577709.20,2546464.24,'745','2022-04-21 10:50:46','426','2022-04-21 10:52:21',10,0),('1','195',257202,'Afternoon','2022-02-12','2022-04-21 11:20:23','2022-04-22 11:20:23','745',2683785.50,1602260.00,'745','2022-04-21 11:25:44','426','2022-04-21 12:08:35',10,0),('1','195',257203,'Morning','2022-02-13','2022-04-21 12:12:54','2022-04-22 12:12:54','745',7763634.15,5953581.83,'745','2022-04-21 12:19:37','426','2022-04-22 10:13:06',10,0),('1','195',257204,'Afternoon','2022-02-13','2022-04-22 10:23:17','2022-04-23 10:23:17','745',6023319.70,4838655.26,'745','2022-04-22 10:26:16','426','2022-04-22 11:06:50',10,0),('1','195',257205,'Morning','2022-02-14','2022-04-22 11:13:08','2022-04-23 11:13:08','745',5418727.80,5382001.16,'745','2022-04-22 11:16:14','426','2022-04-22 11:18:22',10,0),('1','195',257206,'Afternoon','2022-02-14','2022-04-22 11:21:24','2022-04-23 11:21:24','745',2712816.00,2712816.00,'745','2022-04-22 11:22:15','426','2022-04-22 11:23:31',10,0),('1','195',257207,'Morning','2022-02-15','2022-04-22 11:33:39','2022-04-23 11:33:39','745',2321518.40,2318809.28,'745','2022-04-22 11:35:42','426','2022-04-22 12:05:49',10,0),('1','195',257208,'Afternoon','2022-02-15','2022-04-22 12:36:40','2022-04-23 12:36:40','745',5093782.65,5032039.83,'745','2022-04-22 12:40:53','426','2022-04-22 14:13:22',10,0),('1','195',257209,'Morning','2022-02-16','2022-04-22 16:12:01','2022-04-23 16:12:01','745',3486532.50,3444271.50,'745','2022-04-22 16:16:24','426','2022-04-25 13:23:07',10,0),('1','195',257210,'Afternoon','2022-04-25','2022-04-25 15:19:15','2022-04-26 15:19:15','745',6548735.45,6548735.45,'745','2022-04-25 15:22:23','426','2022-04-25 15:47:05',10,0),('1','195',257211,'Morning','2022-02-17','2022-04-25 16:27:08','2022-04-26 16:27:08','745',4159100.35,4159100.35,'745','2022-04-25 16:30:12','426','2022-04-26 10:09:53',10,0),('1','195',257212,'Afternoon','2022-02-17','2022-04-26 11:44:48','2022-04-27 11:44:48','745',4072396.50,4072396.50,'745','2022-04-26 11:46:59','426','2022-04-26 12:43:59',10,0),('1','195',257213,'Morning','2022-02-18','2022-04-26 12:59:30','2022-04-27 12:59:30','745',2945629.20,2945629.20,'745','2022-04-26 13:12:37','426','2022-04-26 14:57:29',10,0),('1','195',257214,'Afternoon','2022-02-18','2022-04-27 13:13:46','2022-04-28 13:13:46','745',2300398.05,2300398.05,'745','2022-04-27 13:16:21','426','2022-04-27 16:33:18',10,0),('1','195',257215,'Morning','2022-02-19','2022-04-28 11:49:12','2022-04-29 11:49:12','745',1720247.25,1720247.25,'745','2022-04-28 11:51:35','426','2022-04-28 11:52:59',10,0),('1','195',257216,'Afternoon','2022-02-19','2022-04-28 12:27:51','2022-04-29 12:27:51','745',2373048.90,2373048.90,'745','2022-04-28 12:28:54','426','2022-04-28 17:21:27',10,0),('1','195',257217,'Morning','2022-02-20','2022-04-29 13:10:57','2022-04-30 13:10:57','745',2000489.40,2000489.40,'745','2022-04-29 13:11:51','426','2022-04-29 16:34:18',10,0),('1','195',257218,'Afternoon','2022-02-20','2022-04-29 16:36:59','2022-04-30 16:36:59','745',2432029.05,2432029.05,'745','2022-04-29 16:38:25','426','2022-04-29 16:39:17',10,0),('1','195',257219,'Morning','2022-02-21','2022-04-29 16:44:25','2022-04-30 16:44:25','745',2465972.10,2465972.10,'745','2022-04-29 16:45:20','426','2022-04-30 14:22:15',10,0),('1','195',257220,'Afternoon','2022-02-21','2022-04-30 14:36:42','2022-05-01 14:36:42','745',3313912.50,3313912.50,'745','2022-04-30 14:37:56','426','2022-05-04 14:58:02',10,0),('1','195',257221,'Morning','2022-02-22','2022-05-04 17:33:43','2022-05-05 17:33:43','745',3422092.05,3422092.05,'745','2022-05-04 17:34:40','426','2022-05-05 13:54:05',10,0),('1','195',257222,'Afternoon','2022-02-22','2022-05-05 14:02:49','2022-05-06 14:02:49','745',1996876.30,1996876.30,'745','2022-05-05 14:11:18','426','2022-05-05 14:12:39',10,0),('1','195',257223,'Morning','2022-02-23','2022-05-05 14:18:29','2022-05-06 14:18:29','745',2751450.70,2751450.70,'745','2022-05-05 14:21:34','426','2022-05-05 14:35:24',10,0),('1','195',257224,'Afternoon','2022-02-23','2022-05-05 14:37:22','2022-05-06 14:37:22','745',4233340.63,4233340.63,'745','2022-05-05 14:39:59','426','2022-05-05 14:50:38',10,0),('1','195',257225,'Morning','2022-02-24','2022-05-05 15:18:53','2022-05-06 15:18:53','745',3985413.20,3985413.20,'745','2022-05-05 16:16:20','426','2022-05-05 16:19:03',10,0),('1','195',257226,'Afternoon','2022-02-24','2022-05-05 16:23:46','2022-05-06 16:23:46','745',4556996.85,4556996.85,'745','2022-05-05 16:26:50','426','2022-05-05 16:28:16',10,0),('1','195',257227,'Morning','2022-02-25','2022-05-05 16:34:39','2022-05-06 16:34:39','745',4267904.15,4267904.15,'745','2022-05-05 16:36:37','426','2022-05-05 16:44:30',10,0),('1','195',257228,'Afternoon','2022-02-25','2022-05-05 16:45:32','2022-05-06 16:45:32','745',2814638.60,2814638.60,'745','2022-05-05 16:48:21','426','2022-05-05 16:49:13',10,0),('1','195',257229,'Morning','2022-02-26','2022-05-05 16:56:14','2022-05-06 16:56:14','745',1349840.25,1349840.25,'745','2022-05-05 16:59:03','426','2022-05-05 17:00:09',10,0),('1','195',257230,'Afternoon','2022-02-26','2022-05-05 17:07:23','2022-05-06 17:07:23','745',2159917.65,2159917.65,'745','2022-05-05 17:10:36','426','2022-05-06 09:02:10',10,0),('1','195',257231,'Morning','2022-02-27','2022-05-06 11:17:21','2022-05-07 11:17:21','745',2029437.30,2029437.30,'745','2022-05-06 11:19:51','426','2022-05-06 11:20:33',10,0),('1','195',257232,'Afternoon','2022-02-27','2022-05-06 11:21:49','2022-05-07 11:21:49','745',1739953.05,1739953.05,'745','2022-05-06 11:25:43','426','2022-05-06 11:26:37',10,0),('1','195',257233,'Morning','2022-02-28','2022-05-06 11:33:13','2022-05-07 11:33:13','745',2076612.45,2076612.45,'745','2022-05-06 11:37:03','426','2022-05-06 11:40:41',10,0),('1','195',257234,'Afternoon','2022-02-28','2022-05-06 11:54:57','2022-05-07 11:54:57','745',1563002.10,1563002.10,'745','2022-05-06 11:57:12','426','2022-05-06 14:58:36',10,0),('1','195',257235,'Morning','2022-03-01','2022-05-06 15:47:58','2022-05-07 15:47:58','745',1810358.55,1810358.55,'745','2022-05-06 16:08:47','426','2022-05-06 16:59:41',10,0),('1','195',257236,'Afternoon','2022-03-01','2022-05-06 17:06:23','2022-05-07 17:06:23','745',534487.80,534487.80,'745','2022-05-06 17:07:36','426','2022-05-06 17:09:49',10,0),('1','195',257237,'Morning','2022-03-02','2022-05-06 17:20:43','2022-05-07 17:20:43','745',2423641.65,2423641.65,'745','2022-05-06 17:23:07','426','2022-05-06 18:43:56',10,0),('1','195',257238,'Afternoon','2022-03-02','2022-05-06 18:53:17','2022-05-07 18:53:17','745',2838374.90,2838374.90,'745','2022-05-06 18:56:21','426','2022-05-06 19:07:26',10,0),('1','195',257239,'Morning','2022-03-03','2022-05-06 19:12:18','2022-05-07 19:12:18','745',1649093.00,1649093.00,'745','2022-05-06 19:13:03','426','2022-05-06 21:45:46',10,0),('1','195',257240,'Afternoon','2022-03-03','2022-05-07 10:39:48','2022-05-08 10:39:48','745',2177133.00,2177133.00,'745','2022-05-07 10:50:58','426','2022-05-07 11:18:20',10,0),('1','195',257241,'Morning','2022-03-04','2022-05-07 11:37:04','2022-05-08 11:37:04','745',6803133.20,6803133.20,'745','2022-05-07 11:37:51','426','2022-05-07 12:16:31',10,0),('1','195',257242,'Afternoon','2022-03-04','2022-05-07 12:39:38','2022-05-08 12:39:38','745',7878663.80,7878663.80,'745','2022-05-07 12:40:21','426','2022-05-07 12:41:17',10,0),('1','195',257243,'Morning','2022-03-05','2022-05-07 12:48:21','2022-05-08 12:48:21','745',6891798.20,6891798.20,'745','2022-05-07 12:58:52','426','2022-05-07 17:15:41',10,0),('1','195',257244,'Afternoon','2022-03-05','2022-05-07 17:58:14','2022-05-08 17:58:14','745',6677535.00,6677535.00,'745','2022-05-07 17:59:03','426','2022-05-08 09:13:27',10,0),('1','195',257245,'Morning','2022-03-06','2022-05-08 11:28:20','2022-05-09 11:28:20','745',6163210.00,6163210.00,'745','2022-05-08 11:29:05','426','2022-05-09 10:48:44',10,0),('1','195',257246,'Afternoon','2022-03-06','2022-05-09 10:59:47','2022-05-10 10:59:47','745',1442900.00,1442900.00,'745','2022-05-09 11:00:56','426','2022-05-09 11:03:02',10,0),('1','195',257247,'Morning','2022-03-07','2022-05-09 11:12:01','2022-05-10 11:12:01','745',3911814.70,3911814.70,'745','2022-05-09 11:15:06','426','2022-05-09 11:16:21',10,0),('1','195',257248,'Afternoon','2022-03-07','2022-05-09 11:20:53','2022-05-10 11:20:53','745',1084188.60,1084188.60,'745','2022-05-09 11:23:14','426','2022-05-09 13:43:21',10,0),('1','195',257249,'Morning','2022-03-08','2022-05-09 15:14:34','2022-05-10 15:14:34','745',798905.25,798905.25,'745','2022-05-09 15:17:55','426','2022-05-09 15:19:51',10,0),('1','195',257250,'Afternoon','2022-03-08','2022-05-09 15:25:11','2022-05-10 15:25:11','745',711483.30,711483.30,'745','2022-05-09 15:27:09','426','2022-05-09 15:50:11',10,0),('1','195',257251,'Morning','2022-03-09','2022-05-09 16:09:15','2022-05-10 16:09:15','745',470754.90,470754.90,'745','2022-05-09 16:10:25','426','2022-05-09 16:15:09',10,0),('1','195',257252,'Afternoon','2022-03-09','2022-05-09 17:03:57','2022-05-10 17:03:57','745',872597.55,872597.55,'745','2022-05-09 17:06:58','426','2022-05-10 10:03:27',10,0),('1','195',257253,'Morning','2022-03-10','2022-05-10 10:46:43','2022-05-11 10:46:43','745',504131.10,504131.10,'745','2022-05-10 10:48:41','426','2022-05-10 11:00:13',10,0),('1','195',257254,'Afternoon','2022-03-10','2022-05-10 11:35:29','2022-05-11 11:35:29','745',590143.95,590143.95,'745','2022-05-10 11:36:52','426','2022-05-10 12:08:14',10,0),('1','195',257255,'Morning','2022-03-11','2022-05-10 12:19:50','2022-05-11 12:19:50','745',947599.95,947599.95,'745','2022-05-10 12:22:17','426','2022-05-10 12:24:31',10,0),('1','195',257256,'Afternoon','2022-03-12','2022-05-10 12:26:00','2022-05-11 12:26:00','745',1118747.85,1118747.85,'745','2022-05-10 12:27:58','426','2022-05-10 12:38:33',10,0),('1','195',257257,'Morning','2022-03-13','2022-05-10 12:54:46','2022-05-11 12:54:46','745',1430020.35,1430020.35,'745','2022-05-10 12:56:40','426','2022-05-10 13:11:44',10,0),('1','195',257258,'Afternoon','2022-03-13','2022-05-10 13:36:11','2022-05-11 13:36:11','745',1522644.75,1522644.75,'745','2022-05-10 13:38:22','426','2022-05-10 13:42:12',10,0),('1','195',257259,'Morning','2022-03-14','2022-05-10 13:49:34','2022-05-11 13:49:34','745',1629518.55,1629518.55,'745','2022-05-10 13:51:06','426','2022-05-10 13:51:51',10,0),('1','195',257260,'Afternoon','2022-03-14','2022-05-10 14:57:45','2022-05-11 14:57:45','745',2030569.20,2030569.20,'745','2022-05-10 15:02:06','426','2022-05-10 15:03:03',10,0),('1','195',257261,'Morning','2022-03-15','2022-05-10 15:25:39','2022-05-11 15:25:39','745',2417281.35,2417281.35,'745','2022-05-10 15:47:26','426','2022-05-10 16:34:11',10,0),('1','195',257262,'Afternoon','2022-03-15','2022-05-10 17:18:17','2022-05-11 17:18:17','745',1710546.75,1710546.75,'745','2022-05-10 17:24:02','426','2022-05-11 09:05:40',10,0),('1','195',257263,'Morning','2022-03-16','2022-05-11 10:46:42','2022-05-12 10:46:42','745',4413145.25,4413145.25,'745','2022-05-11 11:08:18','426','2022-05-11 14:21:18',10,0),('1','195',257264,'Afternoon','2022-03-16','2022-05-11 14:31:13','2022-05-12 14:31:13','745',5384242.30,5384242.30,'745','2022-05-11 15:05:27','426','2022-05-11 16:14:37',10,0),('1','195',257265,'Morning','2022-03-17','2022-05-11 17:15:27','2022-05-12 17:15:27','745',7315419.20,7315419.20,'745','2022-05-11 17:19:34','426','2022-05-11 17:43:45',10,0),('1','195',257266,'Afternoon','2022-03-17','2022-05-11 17:50:21','2022-05-12 17:50:21','745',2785510.00,2785510.00,'745','2022-05-11 17:51:10','426','2022-05-12 10:48:57',10,0),('1','195',257267,'Morning','2022-03-18','2022-05-12 11:02:16','2022-05-13 11:02:16','745',4014796.50,4014796.50,'745','2022-05-12 11:04:12','426','2022-05-12 11:08:05',10,0),('1','195',257268,'Afternoon','2022-03-18','2022-05-12 11:18:07','2022-05-13 11:18:07','745',4911536.50,4911536.50,'745','2022-05-12 11:19:13','426','2022-05-12 11:35:03',10,0),('1','195',257269,'Morning','2022-03-19','2022-05-12 12:47:54','2022-05-13 12:47:54','745',1287512.20,1287512.20,'745','2022-05-12 12:48:40','426','2022-05-13 09:57:06',10,0),('1','195',257270,'Morning','2022-03-19','2022-05-13 10:07:43','2022-05-14 10:07:43','745',1701585.60,1701585.60,'745','2022-05-13 10:09:03','426','2022-05-13 10:20:11',10,0),('1','195',257271,'Afternoon','2022-03-19','2022-05-13 10:21:04','2022-05-14 10:21:04','745',5852339.30,5852339.30,'745','2022-05-13 10:24:45','426','2022-05-13 11:14:05',10,0),('1','195',257272,'Afternoon','2022-03-20','2022-05-13 11:14:41','2022-05-14 11:14:41','745',5063336.65,5063336.65,'745','2022-05-13 11:17:10','426','2022-05-13 11:19:03',10,0),('1','195',257273,'Morning','2022-03-21','2022-05-13 11:29:40','2022-05-14 11:29:40','745',4299813.00,4299813.00,'745','2022-05-13 11:31:35','426','2022-05-13 11:32:26',10,0),('1','195',257274,'Afternoon','2022-03-21','2022-05-13 11:38:37','2022-05-14 11:38:37','745',3750137.40,3750137.40,'745','2022-05-13 11:39:40','426','2022-05-13 12:31:39',10,0),('1','195',257275,'Morning','2022-03-22','2022-05-13 14:19:14','2022-05-14 14:19:14','745',2768440.00,2768440.00,'745','2022-05-13 14:21:08','426','2022-05-13 14:22:10',10,0),('1','195',257276,'Afternoon','2022-03-22','2022-05-13 14:35:28','2022-05-14 14:35:28','745',3292053.05,3292053.05,'745','2022-05-13 14:38:12','426','2022-05-13 14:39:34',10,0),('1','195',257277,'Morning','2022-03-23','2022-05-13 14:56:28','2022-05-14 14:56:28','745',5641604.10,5734334.10,'745','2022-05-13 14:58:34','426','2022-05-13 14:59:41',10,0),('1','195',257278,'Afternoon','2022-03-23','2022-05-13 15:02:21','2022-05-14 15:02:21','745',5380971.15,5472600.15,'745','2022-05-13 15:04:42','426','2022-05-13 15:10:10',10,0),('1','195',257279,'Morning','2022-03-24','2022-05-13 15:13:55','2022-05-14 15:13:55','745',4001993.70,4085045.70,'745','2022-05-13 15:17:10','426','2022-05-13 15:19:55',10,0),('1','195',257280,'Morning','2022-03-24','2022-05-13 16:23:10','2022-05-14 16:23:10','745',2272725.00,2342655.00,'745','2022-05-13 16:24:35','426','2022-05-13 17:14:43',10,0),('1','195',257281,'Morning','2022-03-25','2022-05-13 17:21:47','2022-05-14 17:21:47','745',3112005.00,3207759.00,'745','2022-05-13 17:22:32','426','2022-05-13 17:23:14',10,0),('1','195',257282,'Afternoon','2022-03-25','2022-05-13 17:25:34','2022-05-14 17:25:34','745',1772615.00,1827157.00,'745','2022-05-13 17:26:31','426','2022-05-16 08:50:29',10,0),('1','195',257283,'Morning','2022-03-26','2022-05-16 10:08:48','2022-05-17 10:08:48','745',1785283.50,1840215.30,'745','2022-05-16 10:09:41','426','2022-05-16 10:12:23',10,0),('1','195',257284,'Afternoon','2022-03-26','2022-05-16 10:16:38','2022-05-17 10:16:38','745',2368093.00,2440957.40,'745','2022-05-16 10:17:28','426','2022-05-16 10:18:50',10,0),('1','195',257285,'Morning','2022-03-27','2022-05-16 10:23:56','2022-05-17 10:23:56','745',3267867.90,3267867.90,'745','2022-05-16 10:26:19','426','2022-05-16 10:30:27',10,0),('1','195',257286,'Afternoon','2022-03-28','2022-05-16 10:32:34','2022-05-17 10:32:34','745',1948407.45,1948407.45,'745','2022-05-16 10:38:32','426','2022-05-16 10:44:21',10,0),('1','195',257287,'Morning','2022-03-29','2022-05-16 10:54:45','2022-05-17 10:54:45','745',2180021.25,2180021.25,'745','2022-05-16 10:56:53','426','2022-05-16 10:58:17',10,0),('1','195',257288,'Afternoon','2022-03-29','2022-05-16 11:01:58','2022-05-17 11:01:58','745',990061.05,990061.05,'745','2022-05-16 11:04:54','426','2022-05-16 11:05:51',10,0),('1','195',257289,'Morning','2022-03-30','2022-05-16 11:18:28','2022-05-17 11:18:28','745',1944397.00,2004224.60,'745','2022-05-16 11:19:27','426','2022-05-16 11:28:48',10,0),('1','195',257290,'Afternoon','2022-03-30','2022-05-16 12:07:46','2022-05-17 12:07:46','745',3573326.50,3629345.90,'745','2022-05-16 12:13:15','426','2022-05-16 12:14:28',10,0),('1','195',257291,'Morning','2022-03-31','2022-05-16 12:21:34','2022-05-17 12:21:34','745',5877448.35,5970742.95,'745','2022-05-16 12:23:53','426','2022-05-16 13:15:16',10,0),('1','195',257292,'Afternoon','2022-03-31','2022-05-16 13:27:55','2022-05-17 13:27:55','745',4172224.60,4231971.20,'745','2022-05-16 13:30:20','426','2022-05-16 13:48:17',10,0),('1','195',257293,'Morning','2022-04-01','2022-05-16 17:35:35','2022-05-17 17:35:35','745',3100345.25,3179247.85,'745','2022-05-16 17:37:53','426','2022-05-16 19:40:04',10,0),('1','195',257294,'Afternoon','2022-04-01','2022-05-16 19:43:40','2022-05-17 19:43:40','745',5532407.80,5673917.00,'745','2022-05-16 19:48:36','426','2022-05-16 19:54:39',10,0),('1','195',257295,'Morning','2022-04-02','2022-05-16 20:03:16','2022-05-17 20:03:16','745',1720056.00,1772980.80,'745','2022-05-16 20:04:07','426','2022-05-16 20:13:00',10,0),('1','195',257296,'Afternoon','2022-04-02','2022-05-16 20:38:12','2022-05-17 20:38:12','745',1856003.50,1913111.30,'745','2022-05-16 20:40:05','426','2022-05-16 20:49:05',10,0),('1','195',257297,'Morning','2022-04-03','2022-05-16 20:54:13','2022-05-17 20:54:13','745',779642.50,803631.50,'745','2022-05-16 20:55:23','426','2022-05-16 21:44:20',10,0),('1','195',257298,'Afternoon','2022-04-03','2022-05-16 21:52:16','2022-05-17 21:52:16','745',1179691.50,1215989.70,'745','2022-05-16 21:53:42','426','2022-05-17 10:16:34',10,0),('1','195',257299,'Morning','2022-04-04','2022-05-17 10:26:33','2022-05-18 10:26:33','745',2685949.50,2768594.10,'745','2022-05-17 10:27:24','426','2022-05-17 10:29:51',10,0),('1','195',257300,'Afternoon','2022-04-04','2022-05-17 10:34:00','2022-05-18 10:34:00','745',1228558.50,1266360.30,'745','2022-05-17 10:34:51','426','2022-05-17 10:47:23',10,0),('1','195',257301,'Morning','2022-04-05','2022-05-17 10:48:11','2022-05-18 10:48:11','745',847834.00,873921.20,'745','2022-05-17 10:49:01','426','2022-05-18 09:51:29',10,0),('1','195',257302,'Afternoon','2022-04-05','2022-05-18 10:10:16','2022-05-19 10:10:16','745',3704241.05,3755874.25,'745','2022-05-18 10:13:54','426','2022-05-18 10:16:07',10,0),('1','195',257303,'Morning','2022-04-06','2022-05-18 10:18:30','2022-05-19 10:18:30','745',4857743.30,4911193.90,'745','2022-05-18 10:22:03','426','2022-05-18 10:27:16',10,0),('1','195',257304,'Afternoon','2022-04-06','2022-05-18 10:57:39','2022-05-19 10:57:39','745',3951373.27,3980539.07,'745','2022-05-18 11:03:17','426','2022-05-18 11:35:01',10,0),('1','195',257305,'Morning','2022-04-07','2022-05-18 11:50:14','2022-05-19 11:50:14','745',2801770.10,2808447.70,'745','2022-05-18 11:54:12','426','2022-05-18 11:55:07',10,0),('1','195',257306,'Afternoon','2022-04-07','2022-05-18 12:03:16','2022-05-19 12:03:16','745',2456998.50,2456998.50,'745','2022-05-18 12:06:57','426','2022-05-18 12:10:46',10,0),('1','195',257307,'Morning','2022-04-08','2022-05-18 12:13:18','2022-05-19 12:13:18','745',3191584.30,3208066.10,'745','2022-05-18 12:16:50','426','2022-05-18 12:19:30',10,0),('1','195',257308,'Afternoon','2022-04-08','2022-05-18 12:33:04','2022-05-19 12:33:04','745',2687235.35,2696143.75,'745','2022-05-18 12:37:29','426','2022-05-18 12:42:25',10,0),('1','195',257309,'Morning','2022-04-09','2022-05-18 13:41:44','2022-05-19 13:41:44','745',3658455.30,3694749.90,'745','2022-05-18 13:44:40','426','2022-05-18 14:20:54',10,0),('1','195',257310,'Afternoon','2022-04-09','2022-05-18 15:52:44','2022-05-19 15:52:44','745',3092063.60,3116206.60,'745','2022-05-18 16:38:24','426','2022-05-18 16:39:58',10,0),('1','195',257311,'Morning','2022-04-10','2022-05-18 17:53:15','2022-05-19 17:53:15','745',2731066.40,2759209.60,'745','2022-05-18 17:56:01','426','2022-05-18 17:59:31',10,0),('1','195',257312,'Afternoon','2022-04-10','2022-05-18 18:03:13','2022-05-19 18:03:13','745',2030644.25,2036199.85,'745','2022-05-18 18:05:55','426','2022-05-18 18:06:53',10,0),('1','195',257313,'Morning','2022-04-11','2022-05-18 18:08:07','2022-05-19 18:08:07','745',3298970.35,3329736.35,'745','2022-05-18 18:10:25','426','2022-05-18 18:18:02',10,0),('1','195',257314,'Afternoon','2022-04-11','2022-05-18 18:32:02','2022-05-19 18:32:02','745',2698909.30,2738368.70,'745','2022-05-18 18:33:47','426','2022-05-18 18:35:58',10,0),('1','195',257315,'Morning','2022-04-12','2022-05-18 18:43:38','2022-05-19 18:43:38','745',2274714.00,2344705.20,'745','2022-05-18 18:44:24','426','2022-05-18 18:45:29',10,0),('1','195',257316,'Afternoon','2022-04-12','2022-05-18 18:51:29','2022-05-19 18:51:29','745',1396005.00,1438959.00,'745','2022-05-18 18:52:16','426','2022-05-18 18:55:16',10,0),('1','195',257317,'Morning','2022-04-13','2022-05-18 19:10:21','2022-05-19 19:10:21','745',752843.00,776007.40,'745','2022-05-18 19:11:24','426','2022-05-18 19:12:50',10,0),('1','195',257318,'Afternoon','2022-04-13','2022-05-18 19:14:22','2022-05-19 19:14:22','745',990060.50,1020523.90,'745','2022-05-18 19:15:06','426','2022-05-18 19:15:55',10,0),('1','195',257319,'Morning','2022-04-14','2022-05-18 19:28:08','2022-05-19 19:28:08','745',1266154.50,1305113.10,'745','2022-05-18 19:31:03','426','2022-05-18 19:44:50',10,0),('1','195',257320,'Afternoon','2022-04-14','2022-05-19 09:08:04','2022-05-20 09:08:04','745',3360017.95,3385541.75,'745','2022-05-19 09:14:14','426','2022-05-19 09:43:54',10,0),('1','195',257321,'Morning','2022-04-15','2022-05-19 10:03:20','2022-05-20 10:03:20','745',4354179.05,4412175.25,'745','2022-05-19 10:05:49','426','2022-05-19 10:08:40',10,0),('1','195',257322,'Afternoon','2022-04-15','2022-05-19 10:10:03','2022-05-20 10:10:03','745',2935453.60,2955000.20,'745','2022-05-19 10:13:08','426','2022-05-19 10:21:10',10,0),('1','195',257323,'Morning','2022-04-16','2022-05-19 10:48:23','2022-05-20 10:48:23','745',2147150.00,2196402.40,'745','2022-05-19 10:52:21','426','2022-05-19 11:23:12',10,0),('1','195',257324,'Afternoon','2022-04-16','2022-05-19 11:26:58','2022-05-20 11:26:58','745',1098584.50,1132387.10,'745','2022-05-19 11:28:03','426','2022-05-19 11:28:45',10,0),('1','195',257325,'Morning','2022-04-17','2022-05-19 11:35:00','2022-05-20 11:35:00','745',914244.50,942375.10,'745','2022-05-19 11:36:14','426','2022-05-19 11:41:32',10,0),('1','195',257326,'Afternoon','2022-04-17','2022-05-19 12:15:54','2022-05-20 12:15:54','745',2525431.30,2545988.90,'745','2022-05-19 12:21:19','426','2022-05-19 13:29:13',10,0),('1','195',257327,'Morning','2022-04-18','2022-05-19 13:29:50','2022-05-20 13:29:50','745',1981451.80,1996025.00,'745','2022-05-19 13:32:41','426','2022-05-19 13:33:18',10,0),('1','195',257328,'Afternoon','2022-04-18','2022-05-19 13:40:12','2022-05-20 13:40:12','745',3196173.20,3227501.20,'745','2022-05-19 13:42:30','426','2022-05-19 13:50:57',10,0),('1','195',257329,'Morning','2022-04-19','2022-05-19 14:53:46','2022-05-20 14:53:46','745',3152152.95,3194377.35,'745','2022-05-19 14:58:38','426','2022-05-19 14:59:59',10,0),('1','195',257330,'Afternoon','2022-04-19','2022-05-19 15:07:04','2022-05-20 15:07:04','745',1219575.50,1257100.90,'745','2022-05-19 15:08:10','426','2022-05-19 15:08:43',10,0),('1','195',257331,'Morning','2022-04-20','2022-05-19 15:10:41','2022-05-20 15:10:41','745',2736773.00,2820981.40,'745','2022-05-19 15:40:45','426','2022-05-19 15:41:30',10,0),('1','195',257332,'Afternoon','2022-04-20','2022-05-19 15:49:19','2022-05-20 15:49:19','745',1961056.50,1961056.50,'745','2022-05-19 15:50:17','426','2022-05-19 16:06:32',10,0),('1','195',257333,'Morning','2022-04-21','2022-05-19 16:11:46','2022-05-20 16:11:46','745',3760329.90,3760329.90,'745','2022-05-19 16:15:33','426','2022-05-19 16:35:53',10,0),('1','195',257334,'Afternoon','2022-04-21','2022-05-19 16:48:34','2022-05-20 16:48:34','745',4301498.20,4301498.20,'745','2022-05-19 16:51:37','426','2022-05-19 16:53:14',10,0),('1','195',257335,'Morning','2022-04-22','2022-05-19 16:54:28','2022-05-20 16:54:28','745',3365147.35,3365147.35,'745','2022-05-19 16:57:36','426','2022-05-19 16:58:31',10,0),('1','195',257336,'Afternoon','2022-04-22','2022-05-19 16:58:58','2022-05-20 16:58:58','745',4153827.60,4153827.60,'745','2022-05-19 17:03:43','426','2022-05-19 17:04:44',10,0),('1','195',257337,'Morning','2022-04-23','2022-05-19 17:28:29','2022-05-20 17:28:29','745',4480274.85,4480274.85,'745','2022-05-20 17:54:51','614','2022-05-20 18:04:38',10,0),('1','195',257338,'Afternoon','2022-04-23','2022-05-20 18:07:19','2022-05-21 18:07:19','745',2978066.70,3439323.30,'745','2022-05-20 18:11:43','614','2022-05-20 18:12:44',10,0),('1','195',257339,'Morning','2022-04-24','2022-05-20 18:14:09','2022-05-21 18:14:09','745',1902663.00,2105054.00,'745','2022-05-20 18:27:13','614','2022-05-20 18:28:09',10,0),('1','195',257340,'Afternoon','2022-04-24','2022-05-20 18:28:51','2022-05-21 18:28:51','745',2593634.25,3227783.05,'745','2022-05-20 18:32:07','614','2022-05-20 18:34:28',10,0),('1','195',257341,'Morning','2022-04-25','2022-05-20 18:36:23','2022-05-21 18:36:23','745',2569357.95,2939424.05,'745','2022-05-20 18:42:18','614','2022-05-20 18:44:19',10,0),('1','195',257342,'Afternoon','2022-04-25','2022-05-20 18:45:09','2022-05-21 18:45:09','745',3206044.35,4328544.45,'745','2022-05-20 18:47:44','614','2022-05-20 19:05:17',10,0),('1','195',257343,'Morning','2022-04-26','2022-05-20 19:55:00','2022-05-21 19:55:00','745',1621782.30,2147181.10,'745','2022-05-20 19:58:18','614','2022-05-20 20:01:05',10,0),('1','195',257344,'Afternoon','2022-04-26','2022-05-20 20:02:05','2022-05-21 20:02:05','745',957942.00,1729617.50,'745','2022-05-20 20:03:16','614','2022-05-20 20:03:54',10,0),('1','195',257345,'Morning','2022-04-27','2022-05-20 20:04:48','2022-05-21 20:04:48','745',3225872.25,4240309.65,'745','2022-05-20 20:08:52','614','2022-05-20 20:09:35',10,0),('1','195',257346,'Afternoon','2022-04-27','2022-05-20 20:10:12','2022-05-21 20:10:12','745',3449498.55,4580356.45,'745','2022-05-20 20:12:50','614','2022-05-20 20:25:50',10,0),('1','195',257347,'Morning','2022-04-28','2022-05-20 20:39:22','2022-05-21 20:39:22','745',2794838.25,3467136.55,'745','2022-05-20 20:42:06','614','2022-05-20 20:43:09',10,0),('1','195',257348,'Afternoon','2022-04-28','2022-05-20 20:50:25','2022-05-21 20:50:25','745',2571004.80,2985652.60,'745','2022-05-20 20:54:39','614','2022-05-20 21:00:08',10,0),('1','195',257349,'Morning','2022-04-29','2022-05-20 21:03:08','2022-05-21 21:03:08','745',3280041.90,3970520.30,'745','2022-05-20 21:07:17','614','2022-05-20 21:22:32',10,0),('1','195',257350,'Afternoon','2022-04-29','2022-05-20 21:35:40','2022-05-21 21:35:40','745',2714647.83,3340470.15,'745','2022-05-20 21:41:30','614','2022-05-20 21:44:15',10,0),('1','195',257351,'Morning','2022-04-30','2022-05-20 21:46:31','2022-05-21 21:46:31','745',3247133.25,3727109.35,'745','2022-05-20 21:53:09','614','2022-05-20 22:00:27',10,0),('1','195',257352,'Afternoon','2022-04-30','2022-05-20 22:01:48','2022-05-21 22:01:48','745',2360837.25,2900512.75,'745','2022-05-21 11:00:34','614','2022-05-21 14:56:32',10,0),('1','195',257353,'Morning','2022-05-01','2022-05-21 17:37:05','2022-05-22 17:37:05','745',2448949.80,3310728.30,'745','2022-05-21 17:39:27','614','2022-05-21 20:21:09',10,0),('1','195',257354,'Afternoon','2022-05-01','2022-05-21 21:18:28','2022-05-22 21:18:28','745',2117218.20,2580574.40,'745','2022-05-21 21:20:55','614','2022-05-21 21:25:59',10,0),('1','195',257355,'Morning','2022-05-02','2022-05-21 21:28:35','2022-05-22 21:28:35','745',1148008.65,1454883.75,'745','2022-05-23 17:34:19','614','2022-05-23 21:02:36',10,0),('1','195',257356,'Afternoon','2022-05-02','2022-05-23 21:10:04','2022-05-24 21:10:04','745',1758909.45,2270182.35,'745','2022-05-23 21:12:51','614','2022-05-23 21:13:41',10,0),('1','195',257357,'Morning','2022-05-03','2022-05-23 21:14:16','2022-05-24 21:14:16','745',3251701.20,4541450.10,'745','2022-05-23 21:17:08','614','2022-05-23 21:19:56',10,0),('1','195',257358,'Afternoon','2022-05-03','2022-05-23 21:21:09','2022-05-24 21:21:09','745',2232225.00,2715695.60,'745','2022-05-23 21:28:21','614','2022-05-23 21:30:30',10,0),('1','195',257359,'Morning','2022-05-04','2022-05-23 21:31:07','2022-05-24 21:31:07','745',3318031.95,4327434.95,'745','2022-05-23 21:35:07','614','2022-05-23 21:36:05',10,0),('1','195',257360,'Afternoon','2022-05-04','2022-05-23 21:37:12','2022-05-24 21:37:12','745',3378606.90,4651999.80,'745','2022-05-23 21:41:31','614','2022-05-23 21:42:23',10,0),('1','195',257361,'Morning','2022-05-05','2022-05-23 21:43:42','2022-05-24 21:43:42','745',2391031.50,2391031.50,'745','2022-05-23 21:46:52','614','2022-05-23 21:48:37',10,0),('1','195',257362,'Afternoon','2022-05-05','2022-05-23 21:49:11','2022-05-24 21:49:11','745',2312580.90,2368983.00,'745','2022-05-23 22:09:13','614','2022-05-23 22:14:12',10,0),('1','195',257363,'Morning','2022-05-06','2022-05-23 22:15:14','2022-05-24 22:15:14','745',2548291.35,2548291.35,'745','2022-05-23 22:21:46','614','2022-05-23 22:22:53',10,0),('1','195',257364,'Afternoon','2022-05-06','2022-05-23 22:24:27','2022-05-24 22:24:27','745',2796136.20,2796136.20,'745','2022-05-23 22:32:46','614','2022-05-23 22:45:53',10,0),('1','195',257365,'Morning','2022-05-07','2022-05-24 10:31:07','2022-05-25 10:31:07','745',2281388.40,4119173.50,'745','2022-05-24 10:32:14','614','2022-05-24 16:47:07',10,0),('1','195',257366,'Afternoon','2022-05-07','2022-05-24 17:45:23','2022-05-25 17:45:23','745',1600935.15,2171031.65,'745','2022-05-24 17:47:47','614','2022-05-25 10:21:13',10,0),('1','195',257367,'Morning','2022-05-08','2022-05-25 11:56:50','2022-05-26 11:56:50','745',1275109.20,2296474.70,'745','2022-05-25 11:59:22','614','2022-05-25 12:01:30',10,0),('1','195',257368,'Afternoon','2022-05-08','2022-05-25 12:04:14','2022-05-26 12:04:14','745',345088.80,623077.00,'745','2022-05-25 12:05:23','614','2022-05-25 12:06:43',10,0),('1','195',257369,'Morning','2022-05-09','2022-05-25 12:08:02','2022-05-26 12:08:02','745',1414317.60,2553629.00,'745','2022-05-25 12:08:52','614','2022-05-25 12:09:39',10,0),('1','195',257370,'Afternoon','2022-05-09','2022-05-25 12:10:42','2022-05-26 12:10:42','745',1016236.80,1834872.00,'745','2022-05-25 12:12:06','614','2022-05-25 12:12:53',10,0),('1','195',257371,'Morning','2022-05-10','2022-05-25 12:13:45','2022-05-26 12:13:45','745',1668049.20,3011755.50,'745','2022-05-25 12:14:44','614','2022-05-25 12:15:43',10,0),('1','195',257372,'Afternoon','2022-05-10','2022-05-25 12:17:22','2022-05-26 12:17:22','745',986092.80,986092.80,'745','2022-05-25 12:18:05','614','2022-05-25 12:18:43',10,0),('1','195',257373,'Morning','2022-05-11','2022-05-25 12:21:40','2022-05-26 12:21:40','745',6231332.25,6231332.25,'745','2022-05-25 12:23:31','614','2022-05-25 12:25:09',10,0),('1','195',257374,'Afternoon','2022-05-11','2022-05-25 12:34:40','2022-05-26 12:34:40','745',4637150.10,4637150.10,'745','2022-05-25 12:37:02','614','2022-05-25 12:44:40',10,0),('1','195',257375,'Morning','2022-05-12','2022-05-25 12:48:54','2022-05-26 12:48:54','745',4435119.15,4435119.15,'745','2022-05-25 12:52:12','614','2022-05-25 12:54:27',10,0),('1','195',257376,'Afternoon','2022-05-12','2022-05-25 12:56:15','2022-05-26 12:56:15','745',3104640.00,3104640.00,'745','2022-05-25 12:58:56','614','2022-05-25 13:02:20',10,0),('1','195',257377,'Morning','2022-05-13','2022-05-25 13:05:17','2022-05-26 13:05:17','745',5404840.65,5404840.65,'745','2022-05-25 15:21:10','614','2022-05-25 15:42:21',10,0),('1','195',257378,'Afternoon','2022-05-13','2022-05-25 15:45:57','2022-05-26 15:45:57','745',2876962.05,2876962.05,'745','2022-05-25 16:34:05','614','2022-05-25 16:35:39',10,0),('1','195',257379,'Morning','2022-05-14','2022-05-25 16:40:01','2022-05-26 16:40:01','745',2199644.70,2199644.70,'745','2022-05-25 16:42:26','614','2022-05-25 18:01:30',10,0),('1','195',257380,'Afternoon','2022-05-14','2022-05-25 19:59:39','2022-05-26 19:59:39','745',1252255.95,1252255.95,'745','2022-05-25 20:02:28','614','2022-05-25 20:05:44',10,0),('1','195',257381,'Morning','2022-05-15','2022-05-25 20:06:23','2022-05-26 20:06:23','745',491572.95,491572.95,'745','2022-05-25 20:08:23','614','2022-05-25 20:11:54',10,0),('1','195',257382,'Morning','2022-05-16','2022-05-25 20:13:08','2022-05-26 20:13:08','745',598643.10,598643.10,'745','2022-05-25 20:16:04','614','2022-05-25 20:21:55',10,0),('1','195',257383,'Afternoon','2022-05-16','2022-05-25 20:32:05','2022-05-26 20:32:05','745',1604357.70,1604357.70,'745','2022-05-25 20:33:53','614','2022-05-25 20:37:54',10,0),('1','195',257384,'Morning','2022-05-17','2022-05-25 20:38:39','2022-05-26 20:38:39','745',2298331.20,2298331.20,'745','2022-05-25 20:43:04','614','2022-05-25 20:49:40',10,0),('1','195',257385,'Afternoon','2022-05-17','2022-05-25 20:51:52','2022-05-26 20:51:52','745',1537804.95,1537804.95,'745','2022-05-25 20:54:30','614','2022-05-25 20:55:55',10,0),('1','195',257386,'Morning','2022-05-18','2022-05-25 20:59:01','2022-05-26 20:59:01','745',1927043.25,1927043.25,'745','2022-05-25 21:01:27','614','2022-05-25 21:02:23',10,0),('1','195',257387,'Afternoon','2022-05-18','2022-05-25 21:02:57','2022-05-26 21:02:57','745',1752725.70,1752725.70,'745','2022-05-25 21:09:02','614','2022-05-25 21:12:11',10,0),('1','195',257388,'Morning','2022-05-19','2022-05-25 21:14:01','2022-05-26 21:14:01','745',1792343.85,1792343.85,'745','2022-05-25 21:18:44','614','2022-05-25 21:19:38',10,0),('1','195',257389,'Afternoon','2022-05-19','2022-05-25 21:21:25','2022-05-26 21:21:25','745',2061907.65,2061907.65,'745','2022-05-25 21:23:34','614','2022-05-25 21:24:47',10,0),('1','195',257390,'Morning','2022-05-20','2022-05-25 21:27:29','2022-05-26 21:27:29','745',1869885.60,1869885.60,'745','2022-05-25 21:30:17','614','2022-05-25 21:32:31',10,0),('1','195',257391,'Afternoon','2022-05-20','2022-05-25 21:37:12','2022-05-26 21:37:12','745',1948462.07,1948462.07,'745','2022-05-25 21:43:27','614','2022-05-25 21:46:40',10,0),('1','195',257392,'Morning','2022-05-21','2022-05-26 07:55:32','2022-05-27 07:55:32','745',1343434.95,1343434.95,'745','2022-05-26 07:58:42','614','2022-05-26 08:04:53',10,0),('1','195',257393,'Afternoon','2022-05-21','2022-05-26 08:05:41','2022-05-27 08:05:41','745',1588963.20,1588963.20,'745','2022-05-26 08:08:47','614','2022-05-26 08:09:45',10,0),('1','195',257394,'Morning','2022-05-22','2022-05-26 08:10:21','2022-05-27 08:10:21','745',1345730.10,1345730.10,'745','2022-05-26 08:15:59','614','2022-05-26 08:16:16',10,0),('1','195',257395,'Afternoon','2022-05-22','2022-05-26 08:19:06','2022-05-27 08:19:06','745',1795614.15,1795614.15,'745','2022-05-26 08:21:26','614','2022-05-26 08:22:29',10,0),('1','195',257396,'Morning','2022-05-23','2022-05-26 08:23:06','2022-05-27 08:23:06','745',2129260.65,2129260.65,'745','2022-05-26 08:26:46','614','2022-05-26 08:27:49',10,0),('1','195',257397,'Afternoon','2022-05-23','2022-05-26 08:28:12','2022-05-27 08:28:12','745',2119286.40,2119286.40,'745','2022-05-26 08:30:18','614','2022-05-26 08:32:12',10,0),('1','195',257398,'Morning','2022-05-24','2022-05-26 08:32:36','2022-05-27 08:32:36','745',1931617.05,1931617.05,'745','2022-05-26 08:34:53','614','2022-05-26 08:37:38',10,0),('1','195',257399,'Afternoon','2022-05-24','2022-05-26 08:38:05','2022-05-27 08:38:05','745',1443335.85,1443335.85,'745','2022-05-26 08:40:16','614','2022-05-26 08:41:55',10,0),('1','195',257400,'Morning','2022-05-25','2022-05-26 08:43:18','2022-05-27 08:43:18','745',845186.10,845186.10,'745','2022-05-26 08:45:12','614','2022-05-26 08:47:29',10,0),('1','195',257401,'Afternoon','2022-05-26','2022-05-26 21:01:06','2022-05-27 21:01:06','745',1691964.80,1691964.80,'745','2022-05-26 21:02:15','614','2022-05-26 21:20:00',10,0),('1','195',257402,'Morning','2022-05-27','2022-05-27 12:23:40','2022-05-28 12:23:40','745',3564469.30,3564469.30,'745','2022-05-27 14:21:53','614','2022-05-27 15:04:49',10,0),('1','195',257403,'Afternoon','2022-05-27','2022-05-27 21:32:19','2022-05-28 21:32:19','745',3660169.60,3660169.60,'745','2022-05-27 21:36:59','614','2022-05-28 06:37:05',10,0),('1','195',257404,'Morning','2022-05-28','2022-05-28 14:13:30','2022-05-29 14:13:30','745',2512648.45,2512648.45,'745','2022-05-28 14:15:58','614','2022-05-28 15:25:04',10,0),('1','195',257405,'Afternoon','2022-05-28','2022-05-28 22:51:32','2022-05-29 22:51:32','745',2673373.10,2673373.10,'745','2022-05-28 22:55:11','614','2022-05-28 23:38:52',10,0),('1','195',257406,'Morning','2022-05-29','2022-05-29 12:55:05','2022-05-30 12:55:05','745',1111144.50,1111144.50,'745','2022-05-29 12:57:51','614','2022-05-29 15:55:20',10,0),('1','195',257407,'Afternoon','2022-05-29','2022-05-29 21:44:24','2022-05-30 21:44:24','745',1785952.30,1785952.30,'745','2022-05-29 21:45:18','614','2022-05-30 10:31:55',10,0),('1','195',257408,'Morning','2022-05-30','2022-05-30 14:23:37','2022-05-31 14:23:37','745',2525723.90,2525723.90,'745','2022-05-30 14:26:16','614','2022-05-30 15:32:25',10,0),('1','195',257409,'Afternoon','2022-05-30','2022-05-30 17:18:02','2022-05-31 17:18:02','745',0.00,0.00,'745','2022-05-30 21:35:45','614','2022-05-30 21:41:28',10,0),('1','195',257410,'Afternoon','2022-05-30','2022-05-30 21:42:29','2022-05-31 21:42:29','745',2433675.85,2433675.85,'745','2022-05-31 12:22:00','614','2022-05-31 14:14:10',10,0),('1','195',257411,'Morning','2022-05-31','2022-05-31 15:43:06','2022-06-01 15:43:06','745',3733368.20,3733368.20,'745','2022-05-31 15:47:45','614','2022-05-31 20:49:43',10,0),('1','195',257412,'Afternoon','2022-05-31','2022-05-31 22:26:27','2022-06-01 22:26:27','745',2770342.30,2770342.30,'745','2022-05-31 22:32:38','614','2022-05-31 22:35:40',10,0),('1','195',257413,'Morning','2022-06-01','2022-06-01 14:20:02','2022-06-02 14:20:02','745',3935726.35,3935726.35,'745','2022-06-01 14:29:28','614','2022-06-01 19:55:16',10,0),('1','195',257414,'Afternoon','2022-06-01','2022-06-01 21:26:18','2022-06-02 21:26:18','745',2590522.35,2590522.35,'745','2022-06-01 21:31:34','614','2022-06-01 22:56:47',10,0),('1','195',257415,'Morning','2022-06-02','2022-06-02 14:34:05','2022-06-03 14:34:05','745',2563116.10,2563116.10,'745','2022-06-02 14:37:29','614','2022-06-02 18:26:09',10,0),('1','195',257416,'Afternoon','2022-06-02','2022-06-02 20:59:17','2022-06-03 20:59:17','745',2307268.45,2307268.45,'745','2022-06-02 21:07:09','614','2022-06-03 06:37:43',10,0),('1','195',257417,'Morning','2022-06-03','2022-06-03 14:29:44','2022-06-04 14:29:44','745',2874477.60,2874477.60,'745','2022-06-03 14:42:59','614','2022-06-03 15:20:26',10,0),('1','195',257418,'Afternoon','2022-06-03','2022-06-03 20:57:18','2022-06-04 20:57:18','745',2600154.80,2600154.80,'745','2022-06-03 21:22:55','614','2022-06-03 22:21:44',10,0),('1','195',257419,'Morning','2022-06-04','2022-06-04 10:07:47','2022-06-05 10:07:47','745',1737845.60,1737845.60,'745','2022-06-04 13:50:14','614','2022-06-04 15:20:21',10,0),('1','195',257420,'Afternoon','2022-06-04','2022-06-04 21:05:32','2022-06-05 21:05:32','745',1668722.20,1668722.20,'745','2022-06-04 21:09:26','614','2022-06-04 21:55:46',10,0),('1','195',257421,'Morning','2022-06-05','2022-06-05 13:07:14','2022-06-06 13:07:14','745',4366525.40,4366525.40,'745','2022-06-05 13:10:07','614','2022-06-05 13:56:33',10,0),('1','195',257422,'Afternoon','2022-06-05','2022-06-05 19:15:23','2022-06-06 19:15:23','745',1231064.00,1231064.00,'745','2022-06-05 21:15:54','614','2022-06-06 11:47:31',10,0),('1','195',257423,'Morning','2022-06-06','2022-06-06 13:12:33','2022-06-07 13:12:33','745',4303166.60,4303166.60,'745','2022-06-06 15:09:13','735','2022-06-06 16:37:31',10,0),('1','195',257424,'Afternoon','2022-06-06','2022-06-06 17:28:33','2022-06-07 17:28:33','745',3540737.60,3540737.60,'745','2022-06-06 21:22:43','614','2022-06-06 22:44:53',10,0),('1','195',257425,'Morning','2022-06-07','2022-06-07 11:58:40','2022-06-08 11:58:40','745',4320881.20,4320881.20,'745','2022-06-07 17:46:13','614','2022-06-07 23:10:41',10,0),('1','195',257426,'Afternoon','2022-06-07','2022-06-08 05:07:07','2022-06-09 05:07:07','745',1577411.55,1577411.55,'745','2022-06-08 05:21:01','614','2022-06-08 08:29:33',10,0),('1','195',257427,'Morning','2022-06-08','2022-06-08 09:57:50','2022-06-09 09:57:50','745',1867506.30,1867506.30,'745','2022-06-08 14:58:20','614','2022-06-08 14:59:26',10,0),('1','195',257428,'Afternoon','2022-06-08','2022-06-08 21:28:14','2022-06-09 21:28:14','745',1782975.15,1782975.15,'745','2022-06-08 21:33:44','614','2022-06-08 23:39:58',10,0),('1','195',257429,'Morning','2022-06-09','2022-06-09 08:53:30','2022-06-10 08:53:30','745',1899836.40,1899836.40,'745','2022-06-09 15:12:55','614','2022-06-09 15:16:09',10,0),('1','195',257430,'Afternoon','2022-06-09','2022-06-09 21:23:39','2022-06-10 21:23:39','745',1924579.80,1924579.80,'745','2022-06-09 21:44:24','614','2022-06-09 22:42:41',10,0),('1','195',257431,'Morning','2022-06-10','2022-06-10 10:23:36','2022-06-11 10:23:36','745',2001379.05,2001379.05,'745','2022-06-10 14:17:47','614','2022-06-10 15:00:09',10,0),('1','195',257432,'Afternoon','2022-06-10','2022-06-10 20:48:42','2022-06-11 20:48:42','745',2368241.70,2368241.70,'745','2022-06-10 20:53:40','614','2022-06-10 22:40:53',10,0),('1','195',257433,'Morning','2022-06-11','2022-06-11 11:39:51','2022-06-12 11:39:51','745',2185964.55,2185964.55,'745','2022-06-11 14:13:32','614','2022-06-11 14:44:13',10,0),('1','195',257434,'Afternoon','2022-06-11','2022-06-11 14:51:51','2022-06-12 14:51:51','745',1825619.40,1825619.40,'745','2022-06-11 20:43:05','614','2022-06-11 21:09:46',10,0),('1','195',257435,'Morning','2022-06-12','2022-06-12 08:32:12','2022-06-13 08:32:12','745',1798313.55,1798313.55,'745','2022-06-12 14:07:20','614','2022-06-12 16:27:39',10,0),('1','195',257436,'Afternoon','2022-06-12','2022-06-12 20:59:59','2022-06-13 20:59:59','745',1929325.20,1929325.20,'745','2022-06-12 21:03:21','614','2022-06-12 23:11:35',10,0),('1','195',257437,'Morning','2022-06-13','2022-06-13 10:30:44','2022-06-14 10:30:44','745',2552795.85,2552795.85,'745','2022-06-13 13:11:44','614','2022-06-13 14:41:38',10,0),('1','195',257438,'Afternoon','2022-06-13','2022-06-13 20:52:49','2022-06-14 20:52:49','745',2466898.50,2466898.50,'745','2022-06-13 20:56:19','614','2022-06-13 22:09:05',10,0),('1','195',257439,'Morning','2022-06-14','2022-06-14 08:29:13','2022-06-15 08:29:13','745',2735145.60,2735145.60,'745','2022-06-14 13:05:28','614','2022-06-14 14:40:40',10,0),('1','195',257440,'Afternoon','2022-06-14','2022-06-14 20:51:50','2022-06-15 20:51:50','745',1996239.30,1996239.30,'745','2022-06-14 20:56:46','614','2022-06-14 22:12:02',10,0),('1','195',257441,'Morning','2022-06-15','2022-06-15 08:39:29','2022-06-16 08:39:29','745',4251193.80,4251193.80,'745','2022-06-15 14:00:10','614','2022-06-15 15:10:21',10,0),('1','195',257442,'Afternoon','2022-06-15','2022-06-15 20:36:35','2022-06-16 20:36:35','745',6367041.30,6367041.30,'745','2022-06-15 21:38:18','614','2022-06-15 23:32:20',10,0),('1','195',257443,'Morning','2022-06-16','2022-06-16 11:22:40','2022-06-17 11:22:40','745',4173819.00,4173819.00,'745','2022-06-16 14:10:03','614','2022-06-16 15:52:44',10,0),('1','195',257444,'Afternoon','2022-06-16','2022-06-16 21:09:10','2022-06-17 21:09:10','745',2671422.00,2671422.00,'745','2022-06-16 21:10:57','614','2022-06-16 22:32:33',10,0),('1','195',257445,'Morning','2022-06-17','2022-06-17 12:24:29','2022-06-18 12:24:29','745',2655681.60,2655681.60,'745','2022-06-17 14:18:26','614','2022-06-17 14:51:23',10,0),('1','195',257446,'Afternoon','2022-06-17','2022-06-17 20:50:16','2022-06-18 20:50:16','745',4114016.40,4114016.40,'745','2022-06-17 21:04:59','614','2022-06-18 12:38:38',10,0),('1','195',257447,'Morning','2022-06-18','2022-06-18 13:54:12','2022-06-19 13:54:12','745',4109086.80,4109086.80,'745','2022-06-18 13:55:37','614','2022-06-18 14:50:58',10,0),('1','195',257448,'Afternoon','2022-06-18','2022-06-18 20:46:18','2022-06-19 20:46:18','745',1529166.60,1529166.60,'745','2022-06-18 20:49:36','614','2022-06-18 23:59:15',10,0),('1','195',257449,'Morning','2022-06-19','2022-06-19 09:22:12','2022-06-20 09:22:12','745',5019867.90,5019867.90,'745','2022-06-19 13:53:40','614','2022-06-19 15:54:20',10,0),('1','195',257450,'Afternoon','2022-06-19','2022-06-19 20:50:41','2022-06-20 20:50:41','745',2157877.80,2157877.80,'745','2022-06-19 20:52:30','614','2022-06-20 11:05:47',10,0),('1','195',257451,'Morning','2022-06-20','2022-06-20 12:06:12','2022-06-21 12:06:12','745',2321755.80,2321755.80,'745','2022-06-20 13:05:55','614','2022-06-20 14:00:50',10,0),('1','195',257452,'Afternoon','2022-06-20','2022-06-20 20:49:57','2022-06-21 20:49:57','745',1842687.60,1842687.60,'745','2022-06-20 20:51:48','614','2022-06-20 23:07:28',10,0),('1','195',257453,'Morning','2022-06-21','2022-06-21 09:31:54','2022-06-22 09:31:54','745',3089884.20,3089884.20,'745','2022-06-21 13:29:13','614','2022-06-21 19:01:43',10,0),('1','195',257454,'Afternoon','2022-06-22','2022-06-22 20:50:23','2022-06-23 20:50:23','745',2346754.80,2346754.80,'745','2022-06-22 21:01:19','614','2022-06-22 23:52:20',10,0),('1','195',257455,'Morning','2022-06-23','2022-06-23 07:43:02','2022-06-24 07:43:02','745',4188951.00,4188951.00,'745','2022-06-23 13:16:36','614','2022-06-23 14:33:44',10,0),('1','195',257456,'Afternoon','2022-06-23','2022-06-23 21:29:19','2022-06-24 21:29:19','745',5153924.10,5153924.10,'745','2022-06-23 21:36:58','614','2022-06-23 21:40:23',10,0),('1','195',257457,'Morning','2022-06-24','2022-06-24 09:34:24','2022-06-25 09:34:24','745',3814886.25,3814886.25,'745','2022-06-24 14:52:02','614','2022-06-24 15:16:54',10,0),('1','195',257458,'Afternoon','2022-06-24','2022-06-24 20:54:14','2022-06-25 20:54:14','745',6441381.90,6441381.90,'745','2022-06-24 21:05:49','614','2022-06-24 23:36:39',10,0),('1','195',257459,'Morning','2022-06-25','2022-06-25 13:35:16','2022-06-26 13:35:16','745',7293472.50,7293472.50,'745','2022-06-25 14:07:11','614','2022-06-25 14:41:26',10,0),('1','195',257460,'Afternoon','2022-06-25','2022-06-25 14:50:03','2022-06-26 14:50:03','745',4175269.50,4175269.50,'745','2022-06-25 20:52:08','614','2022-06-26 11:59:52',10,0),('1','195',257461,'Morning','2022-06-26','2022-06-26 13:52:51','2022-06-27 13:52:51','745',4321769.55,4321769.55,'745','2022-06-26 14:58:14','614','2022-06-26 15:20:10',10,0),('1','195',257462,'Afternoon','2022-06-26','2022-06-26 20:43:54','2022-06-27 20:43:54','745',2456854.50,2456854.50,'745','2022-06-26 20:48:58','614','2022-06-27 05:22:39',10,0),('1','195',257463,'Morning','2022-06-27','2022-06-27 13:22:25','2022-06-28 13:22:25','745',6279804.30,6279804.30,'745','2022-06-27 13:28:54','614','2022-06-27 19:56:04',10,0),('1','195',257464,'Afternoon','2022-06-27','2022-06-27 20:37:56','2022-06-28 20:37:56','745',3023628.60,3023628.60,'745','2022-06-27 20:43:50','614','2022-06-27 23:57:32',10,0),('1','195',257465,'Morning','2022-06-28','2022-06-28 08:27:38','2022-06-29 08:27:38','745',5581095.00,5581095.00,'745','2022-06-28 13:02:51','614','2022-06-28 15:19:15',10,0),('1','195',257466,'Afternoon','2022-06-28','2022-06-28 20:59:58','2022-06-29 20:59:58','745',1109994.60,1109994.60,'745','2022-06-28 21:00:41','614','2022-06-28 21:59:04',10,0),('1','195',257467,'Morning','2022-06-29','2022-06-29 13:02:31','2022-06-30 13:02:31','745',3376167.60,3376167.60,'745','2022-06-29 13:10:04','614','2022-06-29 14:53:06',10,0),('1','195',257468,'Afternoon','2022-06-29','2022-06-29 20:36:18','2022-06-30 20:36:18','745',1582955.40,1582955.40,'745','2022-06-29 20:37:55','614','2022-06-29 22:16:31',10,0),('1','195',257469,'Morning','2022-06-30','2022-06-30 13:55:40','2022-07-01 13:55:40','745',4009192.20,4009192.20,'745','2022-06-30 14:18:11','614','2022-06-30 17:50:47',10,0),('1','195',257470,'Afternoon','2022-07-03','2022-07-04 00:21:27','2022-07-05 00:21:27','745',2775255.45,2775255.45,'745','2022-07-04 07:22:47','614','2022-07-04 07:43:51',10,0),('1','195',257471,'Morning','2022-07-04','2022-07-04 13:53:48','2022-07-05 13:53:48','745',3209783.10,3209783.10,'745','2022-07-04 14:38:49','614','2022-07-04 15:01:13',10,0),('1','195',257472,'Afternoon','2022-07-04','2022-07-04 20:34:29','2022-07-05 20:34:29','745',814687.50,814687.50,'745','2022-07-04 20:37:32','614','2022-07-04 22:47:45',10,0),('1','195',257473,'Afternoon','2022-07-05','2022-07-05 13:43:33','2022-07-06 13:43:33','745',630106.95,630106.95,'745','2022-07-05 13:49:17','614','2022-07-05 19:05:02',10,0),('1','195',257474,'Morning','2022-07-09','2022-07-09 14:48:08','2022-07-10 14:48:08','745',575359.20,575359.20,'745','2022-07-09 14:50:04','614','2022-07-09 17:20:31',10,0),('1','195',257475,'Afternoon','2022-07-09','2022-07-09 20:26:03','2022-07-10 20:26:03','745',605404.80,605404.80,'745','2022-07-09 20:27:16','614','2022-07-09 23:07:53',10,0),('1','195',257476,'Morning','2022-07-10','2022-07-10 14:13:41','2022-07-11 14:13:41','745',1494737.40,1494737.40,'745','2022-07-10 14:15:29','614','2022-07-10 17:22:49',10,0),('1','195',257477,'Afternoon','2022-07-10','2022-07-10 21:30:48','2022-07-11 21:30:48','745',1020201.00,1020201.00,'745','2022-07-10 21:32:06','614','2022-07-10 23:26:09',10,0),('1','195',257478,'Morning','2022-07-11','2022-07-11 12:00:57','2022-07-12 12:00:57','745',2149368.00,2149368.00,'745','2022-07-11 14:18:22','614','2022-07-11 15:17:03',10,0),('1','195',257479,'Afternoon','2022-07-11','2022-07-11 20:41:53','2022-07-12 20:41:53','745',1827103.20,1827103.20,'745','2022-07-11 20:43:43','614','2022-07-11 23:31:35',10,0),('1','195',257480,'Morning','2022-07-12','2022-07-12 09:34:21','2022-07-13 09:34:21','745',2999201.40,2999201.40,'745','2022-07-12 13:36:16','614','2022-07-12 14:54:21',10,0),('1','195',257481,'Afternoon','2022-07-12','2022-07-12 20:57:28','2022-07-13 20:57:28','745',1627236.00,1627236.00,'745','2022-07-12 20:58:33','614','2022-07-12 23:59:31',10,0),('1','195',257482,'Morning','2022-07-13','2022-07-13 13:15:32','2022-07-14 13:15:32','745',1458576.60,1458576.60,'745','2022-07-13 13:19:07','614','2022-07-13 15:21:14',10,0),('1','195',257483,'Afternoon','2022-07-13','2022-07-13 20:43:41','2022-07-14 20:43:41','745',4858467.75,4858467.75,'745','2022-07-13 20:49:05','614','2022-07-13 23:43:23',10,0),('1','195',257484,'Morning','2022-07-14','2022-07-14 13:24:41','2022-07-15 13:24:41','745',3327202.15,3327202.15,'745','2022-07-14 13:44:19','614','2022-07-14 21:11:23',10,0),('1','195',257485,'Afternoon','2022-07-14','2022-07-14 21:14:55','2022-07-15 21:14:55','745',4239871.50,4239871.50,'745','2022-07-14 21:26:47','614','2022-07-15 06:56:39',10,0),('1','195',257486,'Morning','2022-07-15','2022-07-15 10:04:59','2022-07-16 10:04:59','745',3973352.50,3973352.50,'745','2022-07-15 14:40:25','614','2022-07-15 15:18:41',10,0),('1','195',257487,'Afternoon','2022-07-15','2022-07-15 20:58:24','2022-07-16 20:58:24','745',3998223.15,3998223.15,'745','2022-07-15 21:06:01','614','2022-07-15 22:01:00',10,0),('1','195',257488,'Morning','2022-07-16','2022-07-16 14:01:47','2022-07-17 14:01:47','745',5651620.35,5651620.35,'745','2022-07-16 14:07:21','614','2022-07-16 16:17:51',10,0),('1','195',257489,'Afternoon','2022-07-16','2022-07-16 23:46:05','2022-07-17 23:46:05','745',4086145.70,4086145.70,'745','2022-07-16 23:49:37','614','2022-07-17 12:28:42',10,0),('1','195',257490,'Morning','2022-07-17','2022-07-17 13:29:34','2022-07-18 13:29:34','745',2713316.15,2713316.15,'745','2022-07-17 13:31:43','614','2022-07-17 18:52:48',10,0),('1','195',257491,'Afternoon','2022-07-17','2022-07-17 21:09:08','2022-07-18 21:09:08','745',3466262.50,3466262.50,'745','2022-07-17 21:12:10','614','2022-07-17 23:01:10',10,0),('1','195',257492,'Morning','2022-07-18','2022-07-18 15:13:56','2022-07-19 15:13:56','745',4122293.15,4122293.15,'745','2022-07-18 15:18:18','614','2022-07-18 17:22:29',10,0),('1','195',257493,'Afternoon','2022-07-18','2022-07-18 21:00:52','2022-07-19 21:00:52','745',621027.75,621027.75,'745','2022-07-18 21:05:03','614','2022-07-18 23:00:29',10,0),('1','195',257494,'Afternoon','2022-07-20','2022-07-20 20:55:22','2022-07-21 20:55:22','745',2573095.20,2573095.20,'745','2022-07-20 20:56:58','614','2022-07-20 22:41:31',10,0),('1','195',257495,'Morning','2022-07-21','2022-07-21 13:06:22','2022-07-22 13:06:22','745',2180076.60,2180076.60,'745','2022-07-21 13:15:55','614','2022-07-21 13:22:24',10,0),('1','195',257496,'Afternoon','2022-07-21','2022-07-21 20:48:46','2022-07-22 20:48:46','745',854412.00,854412.00,'745','2022-07-21 20:49:53','614','2022-07-21 22:56:34',10,0),('1','195',257497,'Morning','2022-07-22','2022-07-22 09:11:27','2022-07-23 09:11:27','745',2656453.80,2656453.80,'745','2022-07-22 12:46:49','614','2022-07-22 14:40:08',10,0),('1','195',257498,'Afternoon','2022-07-22','2022-07-22 20:55:35','2022-07-23 20:55:35','745',1894456.20,1894456.20,'745','2022-07-22 20:59:11','614','2022-07-22 23:06:11',10,0),('1','195',257499,'Afternoon','2022-07-22','2022-07-23 07:27:51','2022-07-24 07:27:51','745',620427.50,620427.50,'745','2022-07-23 07:28:55','614','2022-07-23 08:00:19',10,0),('1','195',257500,'Morning','2022-07-23','2022-07-23 13:11:53','2022-07-24 13:11:53','745',4575594.10,4575594.10,'745','2022-07-23 13:15:34','614','2022-07-23 14:55:35',10,0),('1','195',257501,'Afternoon','2022-07-23','2022-07-23 20:56:13','2022-07-24 20:56:13','745',3459225.77,3459225.77,'745','2022-07-23 21:17:40','614','2022-07-24 11:43:50',10,0),('1','195',257502,'Morning','2022-07-24','2022-07-24 14:12:58','2022-07-25 14:12:58','745',3910090.80,3910090.80,'745','2022-07-24 21:18:24','614','2022-07-24 21:22:01',10,0),('1','195',257503,'Afternoon','2022-07-24','2022-07-24 21:26:24','2022-07-25 21:26:24','745',828496.90,828496.90,'745','2022-07-24 21:28:13','614','2022-07-24 21:40:03',10,0),('1','195',257504,'Morning','2022-07-26','2022-07-26 13:27:24','2022-07-27 13:27:24','745',1393931.00,1393931.00,'745','2022-07-26 13:28:13','614','2022-07-26 17:05:57',10,0),('1','195',257505,'Afternoon','2022-07-26','2022-07-26 20:45:59','2022-07-27 20:45:59','745',2348407.60,2348407.60,'745','2022-07-26 20:49:41','614','2022-07-26 22:19:04',10,0),('1','195',257506,'Morning','2022-07-27','2022-07-27 10:51:22','2022-07-28 10:51:22','745',4347774.20,4347774.20,'745','2022-07-27 14:45:39','614','2022-07-27 15:14:06',10,0),('1','195',257507,'Afternoon','2022-07-27','2022-07-27 21:18:16','2022-07-28 21:18:16','745',3060565.20,3060565.20,'745','2022-07-27 21:19:25','614','2022-07-27 21:51:20',10,0),('1','195',257508,'Morning','2022-07-28','2022-07-28 09:11:42','2022-07-29 09:11:42','745',5519085.50,5519085.50,'745','2022-07-28 12:59:59','614','2022-07-28 15:12:34',10,0),('1','195',257509,'Afternoon','2022-07-28','2022-07-28 20:41:30','2022-07-29 20:41:30','745',3368440.90,3368440.90,'745','2022-07-28 20:45:22','614','2022-07-28 22:41:53',10,0),('1','195',257510,'Morning','2022-07-29','2022-07-29 14:49:34','2022-07-30 14:49:34','745',5427572.00,5427572.00,'745','2022-07-29 14:53:36','614','2022-07-29 17:16:18',10,0),('1','195',257511,'Afternoon','2022-07-29','2022-07-29 20:54:46','2022-07-30 20:54:46','745',4248834.40,4248834.40,'745','2022-07-29 20:59:01','614','2022-07-30 06:55:23',10,0),('1','195',257512,'Morning','2022-07-30','2022-07-30 09:49:11','2022-07-31 09:49:11','745',4801563.00,4801563.00,'745','2022-07-30 13:13:09','614','2022-07-30 15:15:27',10,0),('1','195',257513,'Afternoon','2022-07-30','2022-07-30 19:54:30','2022-07-31 19:54:30','745',3462146.70,3462146.70,'745','2022-07-30 19:58:57','614','2022-07-30 23:23:27',10,0),('1','195',257514,'Morning','2022-07-31','2022-07-31 13:03:21','2022-08-01 13:03:21','745',1563862.30,1563862.30,'745','2022-07-31 13:08:13','614','2022-07-31 14:56:50',10,0),('1','195',257515,'Afternoon','2022-07-31','2022-07-31 20:22:14','2022-08-01 20:22:14','745',3576449.80,3576449.80,'745','2022-07-31 20:23:38','614','2022-07-31 21:44:47',10,0),('1','195',257516,'Morning','2022-08-01','2022-08-01 12:54:16','2022-08-02 12:54:16','745',3502907.10,3502907.10,'745','2022-08-01 12:57:47','614','2022-08-01 18:08:01',10,0),('1','195',257517,'Afternoon','2022-08-01','2022-08-01 21:57:40','2022-08-02 21:57:40','745',3037657.70,3037657.70,'745','2022-08-01 21:58:45','614','2022-08-01 22:00:18',10,0),('1','195',257518,'Morning','2022-08-02','2022-08-02 12:46:30','2022-08-03 12:46:30','745',2012508.00,2012508.00,'745','2022-08-02 14:10:21','614','2022-08-02 14:29:45',10,0),('1','195',257519,'Afternoon','2022-08-02','2022-08-02 21:03:32','2022-08-03 21:03:32','745',2627330.40,2627330.40,'745','2022-08-02 21:06:14','614','2022-08-02 22:11:42',10,0),('1','195',257520,'Morning','2022-08-03','2022-08-03 13:05:14','2022-08-04 13:05:14','745',967336.20,967336.20,'745','2022-08-03 13:12:51','614','2022-08-03 15:04:06',10,0),('1','195',257521,'Afternoon','2022-08-03','2022-08-03 20:16:21','2022-08-04 20:16:21','745',1793093.40,1793093.40,'745','2022-08-03 20:18:52','614','2022-08-03 22:17:11',10,0),('1','195',257522,'Morning','2022-08-04','2022-08-04 16:43:53','2022-08-05 16:43:53','745',3977951.80,3977951.80,'745','2022-08-04 16:56:46','614','2022-08-04 18:25:36',10,0),('1','195',257523,'Afternoon','2022-08-04','2022-08-04 20:57:39','2022-08-05 20:57:39','745',2920563.80,2920563.80,'745','2022-08-04 20:58:50','614','2022-08-04 22:19:43',10,0),('1','195',257524,'Morning','2022-08-05','2022-08-05 14:20:35','2022-08-06 14:20:35','745',3928362.90,3928362.90,'745','2022-08-05 14:21:35','614','2022-08-05 15:30:21',10,0),('1','195',257525,'Afternoon','2022-08-05','2022-08-05 20:47:11','2022-08-06 20:47:11','745',2651826.10,2651826.10,'745','2022-08-05 20:48:02','614','2022-08-05 22:38:53',10,0),('1','195',257526,'Morning','2022-08-06','2022-08-06 12:54:09','2022-08-07 12:54:09','745',2732714.60,2732714.60,'745','2022-08-06 12:59:12','614','2022-08-06 14:43:27',10,0),('1','195',257527,'Afternoon','2022-08-06','2022-08-06 21:37:13','2022-08-07 21:37:13','745',3816291.40,3816291.40,'745','2022-08-06 21:42:32','614','2022-08-06 22:13:04',10,0),('1','195',257528,'Morning','2022-08-07','2022-08-07 13:23:43','2022-08-08 13:23:43','745',2765121.20,2765121.20,'745','2022-08-07 13:43:34','614','2022-08-07 14:48:36',10,0),('1','195',257529,'Afternoon','2022-08-07','2022-08-07 21:16:56','2022-08-08 21:16:56','745',4220717.70,4220717.70,'745','2022-08-07 21:20:30','614','2022-08-07 23:14:38',10,0),('1','195',257530,'Morning','2022-08-08','2022-08-08 13:38:40','2022-08-09 13:38:40','745',4025436.30,4025436.30,'745','2022-08-08 13:47:01','614','2022-08-08 14:02:38',10,0),('1','195',257531,'Afternoon','2022-08-08','2022-08-08 21:07:35','2022-08-09 21:07:35','745',6740523.60,6740523.60,'745','2022-08-08 21:12:17','614','2022-08-08 22:48:06',10,0),('1','195',257532,'Morning','2022-08-09','2022-08-09 13:39:56','2022-08-10 13:39:56','745',5519251.50,5519251.50,'745','2022-08-09 13:49:48','614','2022-08-09 14:58:51',10,0),('1','195',257533,'Afternoon','2022-08-09','2022-08-09 21:35:32','2022-08-10 21:35:32','745',5742603.70,5742603.70,'745','2022-08-09 21:51:59','614','2022-08-10 09:43:52',10,0),('1','195',257534,'Morning','2022-08-10','2022-08-10 13:32:11','2022-08-11 13:32:11','745',5764797.70,5764797.70,'745','2022-08-10 13:39:18','614','2022-08-10 16:10:07',10,0),('1','195',257535,'Afternoon','2022-08-10','2022-08-10 21:53:41','2022-08-11 21:53:41','745',2403166.00,2403166.00,'745','2022-08-10 22:06:46','614','2022-08-11 07:32:54',10,0),('1','195',257536,'Morning','2022-08-11','2022-08-11 13:32:38','2022-08-12 13:32:38','745',1920715.20,1920715.20,'745','2022-08-11 13:37:44','614','2022-08-11 15:11:29',10,0),('1','195',257537,'Afternoon','2022-08-11','2022-08-11 20:50:03','2022-08-12 20:50:03','745',1891949.40,1891949.40,'745','2022-08-11 20:53:40','614','2022-08-11 21:09:53',10,0),('1','195',257538,'Morning','2022-08-12','2022-08-12 14:46:40','2022-08-13 14:46:40','745',2977817.40,2977817.40,'745','2022-08-12 21:12:40','614','2022-08-12 21:35:57',10,0),('1','195',257539,'Afternoon','2022-08-12','2022-08-12 21:38:29','2022-08-13 21:38:29','745',6630514.40,6630514.40,'745','2022-08-12 21:41:42','614','2022-08-12 22:47:59',10,0),('1','195',257540,'Morning','2022-08-13','2022-08-13 13:42:21','2022-08-14 13:42:21','745',3461399.12,3461399.12,'745','2022-08-13 13:47:30','614','2022-08-13 18:01:41',10,0),('1','195',257541,'Afternoon','2022-08-13','2022-08-13 21:07:17','2022-08-14 21:07:17','745',5224186.50,5224186.50,'745','2022-08-13 21:13:52','614','2022-08-13 22:01:29',10,0),('1','195',257542,'Morning','2022-08-14','2022-08-14 16:14:15','2022-08-15 16:14:15','745',2759017.80,2759017.80,'745','2022-08-14 16:24:54','614','2022-08-14 20:32:26',10,0),('1','195',257543,'Afternoon','2022-08-14','2022-08-14 20:42:05','2022-08-15 20:42:05','745',2796098.20,2796098.20,'745','2022-08-14 20:45:30','614','2022-08-14 22:48:46',10,0),('1','195',257544,'Morning','2022-08-15','2022-08-15 13:54:14','2022-08-16 13:54:14','745',3528662.50,3528662.50,'745','2022-08-15 14:02:39','614','2022-08-15 14:58:54',10,0),('1','195',257545,'Afternoon','2022-08-15','2022-08-15 20:53:47','2022-08-16 20:53:47','745',5134452.00,5134452.00,'745','2022-08-15 20:56:25','614','2022-08-15 22:17:33',10,0),('1','195',257546,'Morning','2022-08-16','2022-08-16 14:26:10','2022-08-17 14:26:10','745',3895962.40,3895962.40,'745','2022-08-16 15:33:19','614','2022-08-16 15:54:41',10,0),('1','195',257547,'Afternoon','2022-08-16','2022-08-16 20:59:05','2022-08-17 20:59:05','745',5352830.50,5352830.50,'745','2022-08-16 21:05:30','614','2022-08-16 21:55:47',10,0),('1','195',257548,'Morning','2022-08-17','2022-08-17 13:31:00','2022-08-18 13:31:00','745',5399342.40,5399342.40,'745','2022-08-17 13:38:08','614','2022-08-17 20:04:42',10,0),('1','195',257549,'Afternoon','2022-08-17','2022-08-17 21:10:28','2022-08-18 21:10:28','745',5186039.00,5186039.00,'745','2022-08-17 21:15:19','614','2022-08-17 22:59:06',10,0),('1','195',257550,'Morning','2022-08-18','2022-08-18 09:10:04','2022-08-19 09:10:04','745',5834900.40,5834900.40,'745','2022-08-18 14:08:48','614','2022-08-18 17:31:04',10,0),('1','195',257551,'Afternoon','2022-08-18','2022-08-18 21:15:00','2022-08-19 21:15:00','745',3610760.00,3610760.00,'745','2022-08-18 21:22:41','614','2022-08-19 00:00:39',10,0),('1','195',257552,'Morning','2022-08-19','2022-08-19 10:37:28','2022-08-20 10:37:28','745',1714705.60,1714705.60,'745','2022-08-19 13:15:37','614','2022-08-19 14:33:36',10,0),('1','195',257553,'Afternoon','2022-08-19','2022-08-19 20:39:28','2022-08-20 20:39:28','745',2888866.40,2888866.40,'745','2022-08-19 20:40:46','614','2022-08-19 22:04:36',10,0),('1','195',257554,'Morning','2022-08-20','2022-08-20 12:46:48','2022-08-21 12:46:48','745',2493332.00,2493332.00,'745','2022-08-20 13:16:04','614','2022-08-20 14:24:20',10,0),('1','195',257555,'Afternoon','2022-08-20','2022-08-20 20:43:18','2022-08-21 20:43:18','745',1356584.80,1356584.80,'745','2022-08-20 20:46:04','614','2022-08-21 06:53:30',10,0),('1','195',257556,'Morning','2022-08-21','2022-08-21 12:59:49','2022-08-22 12:59:49','745',3775353.20,3775353.20,'745','2022-08-21 13:00:44','614','2022-08-21 18:46:31',10,0),('1','195',257557,'Afternoon','2022-08-21','2022-08-21 20:47:04','2022-08-22 20:47:04','745',2122915.60,2122915.60,'745','2022-08-21 20:47:48','614','2022-08-21 22:45:21',10,0),('1','195',257558,'Morning','2022-08-22','2022-08-22 11:34:15','2022-08-23 11:34:15','745',3217086.08,3217086.08,'745','2022-08-22 13:27:23','614','2022-08-22 16:18:48',10,0),('1','195',257559,'Afternoon','2022-08-22','2022-08-22 21:33:35','2022-08-23 21:33:35','745',1787474.40,1787474.40,'745','2022-08-22 21:35:18','614','2022-08-22 22:02:58',10,0),('1','195',257560,'Morning','2022-08-23','2022-08-23 09:58:15','2022-08-24 09:58:15','745',4237152.00,4237152.00,'745','2022-08-23 12:53:25','614','2022-08-23 14:39:34',10,0),('1','195',257561,'Afternoon','2022-08-23','2022-08-23 20:00:05','2022-08-24 20:00:05','745',4473983.20,4473983.20,'745','2022-08-23 20:01:22','614','2022-08-23 20:59:31',10,0),('1','195',257562,'Morning','2022-08-24','2022-08-24 11:01:28','2022-08-25 11:01:28','745',3364155.20,3364155.20,'745','2022-08-24 12:45:47','614','2022-08-24 14:57:56',10,0),('1','195',257563,'Afternoon','2022-08-24','2022-08-24 21:14:44','2022-08-25 21:14:44','745',3082484.00,3082484.00,'745','2022-08-24 22:05:02','614','2022-08-24 22:37:32',10,0),('1','195',257564,'Morning','2022-08-25','2022-08-25 13:29:30','2022-08-26 13:29:30','745',4371578.40,4371578.40,'745','2022-08-25 13:36:11','614','2022-08-25 15:25:04',10,0),('1','195',257565,'Afternoon','2022-08-25','2022-08-25 20:53:17','2022-08-26 20:53:17','745',3825854.60,3825854.60,'745','2022-08-25 20:57:03','614','2022-08-25 22:45:17',10,0),('1','195',257566,'Morning','2022-08-26','2022-08-26 11:44:10','2022-08-27 11:44:10','745',4691467.60,4691467.60,'745','2022-08-26 14:01:38','614','2022-08-26 20:07:54',10,0),('1','195',257567,'Afternoon','2022-08-26','2022-08-26 20:33:25','2022-08-27 20:33:25','745',5677037.60,5677037.60,'745','2022-08-26 20:36:54','614','2022-08-26 22:25:00',10,0),('1','195',257568,'Morning','2022-08-27','2022-08-27 13:24:59','2022-08-28 13:24:59','745',5736179.80,5736179.80,'745','2022-08-27 13:32:00','614','2022-08-27 19:14:47',10,0),('1','195',257569,'Afternoon','2022-08-27','2022-08-27 20:32:07','2022-08-28 20:32:07','745',6236435.60,6236435.60,'745','2022-08-27 20:34:57','614','2022-08-27 22:13:02',10,0),('1','195',257570,'Morning','2022-08-28','2022-08-28 09:42:58','2022-08-29 09:42:58','745',2309002.20,2309002.20,'745','2022-08-28 13:30:48','614','2022-08-28 14:54:40',10,0),('1','195',257571,'Afternoon','2022-08-28','2022-08-28 20:01:48','2022-08-29 20:01:48','745',3853052.20,3853052.20,'745','2022-08-28 20:07:19','614','2022-08-29 07:28:06',10,0),('1','195',257572,'Morning','2022-08-29','2022-08-29 10:19:21','2022-08-30 10:19:21','745',1565002.20,1565002.20,'745','2022-08-29 13:48:24','614','2022-08-29 15:39:32',10,0),('1','195',257573,'Afternoon','2022-08-29','2022-08-29 21:07:59','2022-08-30 21:07:59','745',3815694.40,3815694.40,'745','2022-08-29 21:21:02','614','2022-08-30 08:41:29',10,0),('1','195',257574,'Morning','2022-08-30','2022-08-30 11:40:10','2022-08-31 11:40:10','745',4584757.20,4584757.20,'745','2022-08-30 14:03:32','614','2022-08-30 14:28:01',10,0),('1','195',257575,'Afternoon','2022-08-30','2022-08-30 20:48:23','2022-08-31 20:48:23','745',4931661.00,4931661.00,'745','2022-08-30 20:51:04','614','2022-08-30 23:42:05',10,0),('1','195',257576,'Morning','2022-08-31','2022-08-31 08:56:06','2022-09-01 08:56:06','745',5132338.40,5132338.40,'745','2022-08-31 13:29:43','614','2022-08-31 14:40:43',10,0),('1','195',257577,'Afternoon','2022-08-31','2022-08-31 21:29:03','2022-09-01 21:29:03','745',4402880.40,4402880.40,'745','2022-08-31 21:35:13','614','2022-08-31 22:55:37',10,0),('1','195',257578,'Morning','2022-09-01','2022-09-01 09:48:26','2022-09-02 09:48:26','745',5963194.60,5963194.60,'745','2022-09-01 13:56:28','614','2022-09-01 14:30:50',10,0),('1','195',257579,'Afternoon','2022-09-01','2022-09-01 21:34:04','2022-09-02 21:34:04','745',4468411.20,4468411.20,'745','2022-09-01 21:37:14','614','2022-09-01 22:29:48',10,0),('1','195',257580,'Morning','2022-09-02','2022-09-02 09:51:19','2022-09-03 09:51:19','745',4308168.00,4308168.00,'745','2022-09-02 14:15:26','614','2022-09-02 15:22:52',10,0),('1','195',257581,'Afternoon','2022-09-02','2022-09-02 21:11:18','2022-09-03 21:11:18','745',3980244.40,3980244.40,'745','2022-09-02 21:13:50','614','2022-09-02 21:17:14',10,0),('1','195',257582,'Morning','2022-09-03','2022-09-03 13:17:01','2022-09-04 13:17:01','745',5867322.40,5867322.40,'745','2022-09-03 13:21:29','614','2022-09-03 20:51:26',10,0),('1','195',257583,'Afternoon','2022-09-03','2022-09-03 20:53:43','2022-09-04 20:53:43','745',5741013.80,5741013.80,'745','2022-09-03 20:57:30','614','2022-09-04 00:09:38',10,0),('1','195',257584,'Morning','2022-09-04','2022-09-04 13:16:04','2022-09-05 13:16:04','745',5262656.00,5262656.00,'745','2022-09-04 13:19:43','614','2022-09-04 14:38:46',10,0),('1','195',257585,'Afternoon','2022-09-04','2022-09-04 18:16:14','2022-09-05 18:16:14','745',3329592.40,3329592.40,'745','2022-09-04 21:03:13','614','2022-09-04 22:34:12',10,0),('1','195',257586,'Morning','2022-09-05','2022-09-05 12:14:16','2022-09-06 12:14:16','745',4174800.20,4174800.20,'745','2022-09-05 14:48:22','614','2022-09-05 14:51:49',10,0),('1','195',257587,'Afternoon','2022-09-05','2022-09-05 21:42:42','2022-09-06 21:42:42','745',4660798.20,4660798.20,'745','2022-09-05 21:46:22','614','2022-09-05 21:50:49',10,0),('1','195',257588,'Morning','2022-09-06','2022-09-06 10:26:48','2022-09-07 10:26:48','745',1730327.40,1730327.40,'745','2022-09-06 16:58:51','614','2022-09-06 19:56:38',10,0),('1','195',257589,'Afternoon','2022-09-06','2022-09-06 21:50:49','2022-09-07 21:50:49','745',5033418.00,5033418.00,'745','2022-09-06 21:53:57','614','2022-09-06 22:49:54',10,0),('1','195',257590,'Morning','2022-09-07','2022-09-07 13:08:30','2022-09-08 13:08:30','745',5603284.00,5603284.00,'745','2022-09-07 14:29:55','614','2022-09-07 16:21:02',10,0),('1','195',257591,'Afternoon','2022-09-07','2022-09-07 21:26:58','2022-09-08 21:26:58','745',3141303.60,3141303.60,'745','2022-09-07 21:29:53','614','2022-09-07 23:32:30',10,0),('1','195',257592,'Morning','2022-09-08','2022-09-08 11:30:24','2022-09-09 11:30:24','745',1028538.40,1028538.40,'745','2022-09-08 13:02:14','614','2022-09-08 17:59:51',10,0),('1','195',257593,'Afternoon','2022-09-08','2022-09-08 20:51:57','2022-09-09 20:51:57','745',1997401.60,1997401.60,'745','2022-09-08 20:55:47','614','2022-09-08 23:07:55',10,0),('1','195',257594,'Morning','2022-09-09','2022-09-09 15:10:06','2022-09-10 15:10:06','745',6434433.60,6434433.60,'745','2022-09-09 15:13:01','614','2022-09-09 15:52:15',10,0),('1','195',257595,'Afternoon','2022-09-09','2022-09-10 06:02:54','2022-09-11 06:02:54','745',2712660.80,2712660.80,'745','2022-09-10 06:07:55','614','2022-09-10 15:25:37',10,0),('1','195',257596,'Morning','2022-09-10','2022-09-10 16:01:30','2022-09-11 16:01:30','745',4340093.00,4340093.00,'745','2022-09-10 16:07:35','614','2022-09-10 21:56:02',10,0),('1','195',257597,'Afternoon','2022-09-10','2022-09-10 22:03:43','2022-09-11 22:03:43','745',5405091.20,5405091.20,'745','2022-09-10 22:06:44','614','2022-09-10 22:13:54',10,0),('1','195',257598,'Morning','2022-09-11','2022-09-11 10:19:26','2022-09-12 10:19:26','745',2511527.00,2511527.00,'745','2022-09-11 13:56:43','614','2022-09-11 14:42:09',10,0),('1','195',257599,'Afternoon','2022-09-11','2022-09-11 19:27:33','2022-09-12 19:27:33','745',3223359.20,3223359.20,'745','2022-09-11 21:29:07','614','2022-09-11 21:53:18',10,0),('1','195',257600,'Morning','2022-09-12','2022-09-12 13:14:09','2022-09-13 13:14:09','745',2863912.80,2863912.80,'745','2022-09-12 13:17:12','614','2022-09-12 17:36:24',10,0),('1','195',257601,'Afternoon','2022-09-12','2022-09-12 21:04:52','2022-09-13 21:04:52','745',4753195.20,4753195.20,'745','2022-09-12 21:07:04','614','2022-09-12 22:43:47',10,0),('1','195',257602,'Morning','2022-09-13','2022-09-13 11:06:44','2022-09-14 11:06:44','745',3582516.40,3582516.40,'745','2022-09-13 14:03:19','614','2022-09-13 14:42:01',10,0),('1','195',257603,'Afternoon','2022-09-13','2022-09-13 20:46:34','2022-09-14 20:46:34','745',3607795.00,3607795.00,'745','2022-09-13 20:49:38','614','2022-09-13 23:46:52',10,0),('1','195',257604,'Morning','2022-09-14','2022-09-14 09:32:07','2022-09-15 09:32:07','745',2009690.80,2009690.80,'745','2022-09-14 13:55:12','614','2022-09-14 15:56:36',10,0),('1','195',257605,'Afternoon','2022-09-14','2022-09-14 20:54:57','2022-09-15 20:54:57','745',2660684.00,2660684.00,'745','2022-09-14 20:55:47','614','2022-09-15 07:05:31',10,0),('1','195',257606,'Morning','2022-09-15','2022-09-15 11:53:04','2022-09-16 11:53:04','745',4901431.20,4901431.20,'745','2022-09-15 13:39:15','614','2022-09-15 15:06:27',10,0),('1','195',257607,'Afternoon','2022-09-15','2022-09-15 20:50:08','2022-09-16 20:50:08','745',4630641.00,4630641.00,'745','2022-09-15 20:52:32','614','2022-09-15 23:27:05',10,0),('1','195',257608,'Morning','2022-09-16','2022-09-16 10:37:14','2022-09-17 10:37:14','745',2423741.60,2423741.60,'745','2022-09-16 13:46:20','614','2022-09-16 14:27:31',10,0),('1','195',257609,'Afternoon','2022-09-16','2022-09-16 20:53:29','2022-09-17 20:53:29','745',4288729.20,4288729.20,'745','2022-09-16 20:58:20','614','2022-09-16 21:47:12',10,0),('1','195',257610,'Morning','2022-09-17','2022-09-17 10:46:26','2022-09-18 10:46:26','745',3302169.40,3302169.40,'745','2022-09-17 13:14:12','614','2022-09-17 14:25:26',10,0),('1','195',257611,'Afternoon','2022-09-17','2022-09-17 20:47:04','2022-09-18 20:47:04','745',2411024.00,2411024.00,'745','2022-09-17 20:49:59','614','2022-09-17 23:07:57',10,0),('1','195',257612,'Morning','2022-09-18','2022-09-18 13:14:02','2022-09-19 13:14:02','745',1388603.60,1388603.60,'745','2022-09-18 13:15:54','614','2022-09-18 15:07:05',10,0),('1','195',257613,'Afternoon','2022-09-18','2022-09-18 20:37:26','2022-09-19 20:37:26','745',3136641.60,3136641.60,'745','2022-09-18 20:38:05','614','2022-09-18 23:27:02',10,0),('1','195',257614,'Morning','2022-09-19','2022-09-19 13:16:44','2022-09-20 13:16:44','745',2658054.40,2658054.40,'745','2022-09-19 13:21:53','614','2022-09-19 20:17:02',10,0),('1','195',257615,'Afternoon','2022-09-19','2022-09-19 20:40:52','2022-09-20 20:40:52','745',3483650.00,3483650.00,'745','2022-09-19 20:43:54','614','2022-09-20 07:49:09',10,0),('1','195',257616,'Morning','2022-09-20','2022-09-20 13:12:34','2022-09-21 13:12:34','745',826804.00,826804.00,'745','2022-09-20 13:14:03','614','2022-09-20 14:47:05',10,0),('1','195',257617,'Afternoon','2022-09-20','2022-09-20 20:46:00','2022-09-21 20:46:00','745',4097654.00,4097654.00,'745','2022-09-20 20:48:33','614','2022-09-20 21:42:25',10,0),('1','195',257618,'Morning','2022-09-21','2022-09-21 14:05:43','2022-09-22 14:05:43','745',2722441.60,2722441.60,'745','2022-09-21 14:06:19','614','2022-09-21 14:53:36',10,0),('1','195',257619,'Afternoon','2022-09-21','2022-09-21 20:55:31','2022-09-22 20:55:31','745',4471251.20,4471251.20,'745','2022-09-21 21:08:40','614','2022-09-21 22:50:09',10,0),('1','195',257620,'Morning','2022-09-22','2022-09-22 09:20:10','2022-09-23 09:20:10','745',5383326.64,5383326.64,'745','2022-09-22 13:43:03','614','2022-09-22 13:55:22',10,0),('1','195',257621,'Afternoon','2022-09-22','2022-09-22 20:59:50','2022-09-23 20:59:50','745',3082212.60,3082212.60,'745','2022-09-22 21:06:42','614','2022-09-22 22:30:55',10,0),('1','195',257622,'Morning','2022-09-23','2022-09-23 14:21:24','2022-09-24 14:21:24','745',1854907.20,1854907.20,'745','2022-09-23 14:23:26','614','2022-09-23 14:58:44',10,0),('1','195',257623,'Afternoon','2022-09-23','2022-09-23 21:10:58','2022-09-24 21:10:58','745',2100328.20,2100328.20,'745','2022-09-23 21:13:03','614','2022-09-24 07:10:46',10,0),('1','195',257624,'Morning','2022-09-24','2022-09-24 13:40:03','2022-09-25 13:40:03','745',1267290.00,1267290.00,'745','2022-09-24 15:05:40','614','2022-09-24 19:28:00',10,0),('1','195',257625,'Afternoon','2022-09-27','2022-09-27 15:39:16','2022-09-28 15:39:16','745',1842051.60,1842051.60,'745','2022-09-27 20:50:45','614','2022-09-27 22:06:29',10,0),('1','195',257626,'Morning','2022-09-28','2022-09-28 11:36:13','2022-09-29 11:36:13','745',1890394.20,1890394.20,'745','2022-09-28 13:15:40','614','2022-09-28 13:54:38',10,0),('1','195',257627,'Afternoon','2022-09-28','2022-09-28 20:35:09','2022-09-29 20:35:09','745',1969196.40,1969196.40,'745','2022-09-28 20:38:09','614','2022-09-28 23:14:08',10,0),('1','195',257628,'Morning','2022-09-29','2022-09-29 12:38:03','2022-09-30 12:38:03','745',1757754.00,1757754.00,'745','2022-09-29 13:45:26','614','2022-09-29 14:38:20',10,0),('1','195',257629,'Afternoon','2022-09-29','2022-09-29 21:01:26','2022-09-30 21:01:26','745',2074984.20,2074984.20,'745','2022-09-29 21:03:11','614','2022-09-29 21:54:00',10,0),('1','195',257630,'Morning','2022-09-30','2022-09-30 08:54:07','2022-10-01 08:54:07','745',1715281.20,1715281.20,'745','2022-09-30 14:23:09','614','2022-09-30 15:04:17',10,0),('1','195',257631,'Afternoon','2022-09-30','2022-09-30 16:28:31','2022-10-01 16:28:31','745',2237407.20,2237407.20,'745','2022-09-30 20:57:44','614','2022-09-30 22:32:09',10,0),('1','195',257632,'Morning','2022-10-01','2022-10-01 09:19:17','2022-10-02 09:19:17','745',1691386.20,1691386.20,'745','2022-10-01 13:50:37','614','2022-10-01 15:49:08',10,0),('1','195',257633,'Afternoon','2022-10-01','2022-10-01 20:26:39','2022-10-02 20:26:39','745',1697986.80,1697986.80,'745','2022-10-01 20:40:54','614','2022-10-01 22:37:30',10,0),('1','195',257634,'Morning','2022-10-02','2022-10-02 20:35:05','2022-10-03 20:35:05','745',4674306.30,4674306.30,'745','2022-10-02 20:38:29','614','2022-10-02 22:20:10',10,0),('1','195',257635,'Afternoon','2022-10-02','2022-10-03 04:36:34','2022-10-04 04:36:34','745',3187298.70,3187298.70,'745','2022-10-03 04:39:40','614','2022-10-03 07:05:04',10,0),('1','195',257636,'Morning','2022-10-03','2022-10-03 09:34:56','2022-10-04 09:34:56','745',7839843.80,7839843.80,'745','2022-10-03 13:36:10','614','2022-10-03 15:03:21',10,0),('1','195',257637,'Afternoon','2022-10-03','2022-10-03 19:47:53','2022-10-04 19:47:53','745',4842868.70,4842868.70,'745','2022-10-03 19:49:59','614','2022-10-03 22:36:39',10,0),('1','195',257638,'Morning','2022-10-04','2022-10-04 14:37:14','2022-10-05 14:37:14','745',4935698.40,4935698.40,'745','2022-10-04 14:39:34','614','2022-10-04 23:11:39',10,0),('1','195',257639,'Afternoon','2022-10-04','2022-10-05 05:55:33','2022-10-06 05:55:33','745',4852398.60,4852398.60,'745','2022-10-05 05:58:25','614','2022-10-05 07:43:47',10,0),('1','195',257640,'Morning','2022-10-05','2022-10-05 09:08:42','2022-10-06 09:08:42','745',0.00,0.00,'426','2022-10-05 13:29:10','426','2022-10-05 13:29:25',10,0),('1','195',257641,'Morning','2022-10-05','2022-10-05 13:30:42','2022-10-06 13:30:42','745',340340.00,340340.00,'745','2022-10-05 13:32:14','614','2022-10-05 14:12:22',10,0),('1','195',257642,'Morning','2022-10-05','2022-10-05 18:52:41','2022-10-06 18:52:41','745',3431857.20,3431857.20,'745','2022-10-05 19:14:34','614','2022-10-05 22:40:26',10,0),('1','195',257643,'Afternoon','2022-10-05','2022-10-06 09:07:23','2022-10-07 09:07:23','745',4931758.20,4931758.20,'745','2022-10-06 09:13:28','614','2022-10-06 16:52:42',10,0),('1','195',257644,'Morning','2022-10-06','2022-10-06 19:18:14','2022-10-07 19:18:14','745',5083084.80,5083084.80,'745','2022-10-06 19:22:22','614','2022-10-06 19:42:53',10,0),('1','195',257645,'Afternoon','2022-10-06','2022-10-06 20:28:42','2022-10-07 20:28:42','745',3399037.80,3399037.80,'745','2022-10-06 20:33:11','614','2022-10-06 22:47:24',10,0),('1','195',257646,'Morning','2022-10-07','2022-10-07 09:20:23','2022-10-08 09:20:23','745',2399124.00,2399124.00,'745','2022-10-07 14:13:47','614','2022-10-07 16:02:03',10,0),('1','195',257647,'Afternoon','2022-10-07','2022-10-07 20:50:12','2022-10-08 20:50:12','745',2893722.00,2893722.00,'745','2022-10-07 20:52:50','614','2022-10-07 22:53:55',10,0),('1','195',257648,'Morning','2022-10-08','2022-10-08 17:51:56','2022-10-09 17:51:56','745',3330912.00,3330912.00,'745','2022-10-08 17:53:19','614','2022-10-08 23:53:36',10,0),('1','195',257649,'Afternoon','2022-10-08','2022-10-09 07:18:08','2022-10-10 07:18:08','745',1738292.40,1738292.40,'745','2022-10-09 07:19:52','614','2022-10-09 14:05:50',10,0),('1','195',257650,'Afternoon','2022-10-09','2022-10-10 07:59:40','2022-10-11 07:59:40','745',1092000.00,1092000.00,'745','2022-10-10 08:01:35','614','2022-10-10 13:08:34',10,0),('1','195',257651,'Afternoon','2022-10-10','2022-10-10 20:55:11','2022-10-11 20:55:11','745',682500.00,682500.00,'745','2022-10-10 20:56:47','614','2022-10-10 22:22:45',10,0),('1','195',257652,'AFTERNOON SHIFT','2022-10-11','2022-10-11 16:13:49','2022-10-12 16:13:49','745',1365000.00,1365000.00,'745','2022-10-11 19:06:37','614','2022-10-11 21:54:09',10,0),('1','195',257653,'MORNING SHIFT','2022-10-13','2022-10-13 12:22:04','2022-10-14 12:22:04','745',0.00,0.00,'745','2022-10-13 13:15:10','614','2022-10-13 13:23:57',10,0),('1','195',257654,'MORNING SHIFT','2022-10-13','2022-10-13 13:52:18','2022-10-14 13:52:18','745',845008.00,845008.00,'745','2022-10-13 13:53:19','614','2022-10-13 14:26:48',10,0),('1','195',257655,'Afternoon','2022-10-13','2022-10-14 06:41:50','2022-10-15 06:41:50','745',636920.00,636920.00,'745','2022-10-14 06:46:51','614','2022-10-14 06:49:56',10,0),('1','195',257656,'MORNING SHIFT','2022-10-14','2022-10-14 11:50:48','2022-10-15 11:50:48','745',1593648.00,1593648.00,'745','2022-10-14 13:08:11','614','2022-10-14 16:04:19',10,0),('1','195',257657,'AFTERNOON SHIFT','2022-10-14','2022-10-14 20:51:40','2022-10-15 20:51:40','745',2299608.00,2299608.00,'745','2022-10-14 20:53:20','614','2022-10-14 22:37:07',10,0),('1','195',257658,'MORNING SHIFT','2022-10-15','2022-10-15 12:12:19','2022-10-16 12:12:19','745',3000080.00,3000080.00,'745','2022-10-15 13:18:33','614','2022-10-15 16:38:44',10,0),('1','195',257659,'AFTERNOON SHIFT','2022-10-15','2022-10-15 20:55:33','2022-10-16 20:55:33','745',1738776.00,1738776.00,'745','2022-10-15 21:03:54','614','2022-10-15 22:47:35',10,0),('1','195',257660,'MORNING SHIFT','2022-10-16','2022-10-16 14:02:44','2022-10-17 14:02:44','745',2156896.00,2156896.00,'745','2022-10-16 14:03:47','614','2022-10-16 16:58:14',10,0),('1','195',257661,'AFTERNOON SHIFT','2022-10-16','2022-10-16 20:29:07','2022-10-17 20:29:07','745',1603584.00,1603584.00,'745','2022-10-16 20:30:43','614','2022-10-16 21:26:34',10,0),('1','195',257662,'MORNING SHIFT','2022-10-17','2022-10-17 11:14:43','2022-10-18 11:14:43','745',1714168.00,1714168.00,'745','2022-10-17 14:18:43','614','2022-10-17 15:23:20',10,0),('1','195',257663,'AFTERNOON SHIFT','2022-10-17','2022-10-17 20:37:12','2022-10-18 20:37:12','745',1810720.00,1810720.00,'745','2022-10-17 20:38:37','614','2022-10-18 04:56:54',10,0),('1','195',257664,'MORNING SHIFT','2022-10-18','2022-10-18 13:04:17','2022-10-19 13:04:17','745',3196480.00,3196480.00,'745','2022-10-18 13:05:05','614','2022-10-18 15:41:23',10,0),('1','195',257665,'AFTERNOON SHIFT','2022-10-18','2022-10-18 21:01:52','2022-10-19 21:01:52','745',1434312.00,1434312.00,'745','2022-10-18 21:03:08','614','2022-10-18 23:43:40',10,0),('1','195',257666,'MORNING SHIFT','2022-10-19','2022-10-19 10:09:07','2022-10-20 10:09:07','745',4494142.20,4494142.20,'745','2022-10-19 15:00:41','614','2022-10-19 15:01:44',10,0),('1','195',257667,'AFTERNOON SHIFT','2022-10-19','2022-10-19 20:35:14','2022-10-20 20:35:14','745',2974220.60,2974220.60,'745','2022-10-19 20:38:07','614','2022-10-19 22:00:00',10,0),('1','195',257668,'MORNING SHIFT','2022-10-20','2022-10-20 10:06:47','2022-10-21 10:06:47','745',3161430.80,3161430.80,'745','2022-10-20 13:28:07','614','2022-10-20 16:02:10',10,0),('1','195',257669,'AFTERNOON SHIFT','2022-10-20','2022-10-20 20:36:42','2022-10-21 20:36:42','745',3985976.20,3985976.20,'745','2022-10-20 20:54:09','614','2022-10-20 22:45:35',10,0),('1','195',257670,'MORNING SHIFT','2022-10-21','2022-10-21 14:09:54','2022-10-22 14:09:54','745',3598466.80,3598466.80,'745','2022-10-21 14:14:30','614','2022-10-21 14:29:34',10,0),('1','195',257671,'AFTERNOON SHIFT','2022-10-21','2022-10-21 20:59:43','2022-10-22 20:59:43','745',2787785.60,2787785.60,'745','2022-10-21 21:02:14','614','2022-10-21 23:23:06',10,0),('1','195',257672,'MORNING SHIFT','2022-10-22','2022-10-22 12:52:40','2022-10-23 12:52:40','745',1382008.00,1382008.00,'745','2022-10-22 12:54:44','614','2022-10-22 14:39:19',10,0),('1','195',257673,'AFTERNOON SHIFT','2022-10-22','2022-10-22 21:10:09','2022-10-23 21:10:09','745',1575200.00,1575200.00,'745','2022-10-22 21:10:59','614','2022-10-22 22:28:04',10,0),('1','195',257674,'AFTERNOON SHIFT','2022-10-23','2022-10-23 20:44:19','2022-10-24 20:44:19','745',1289216.00,1289216.00,'745','2022-10-23 20:45:13','614','2022-10-23 21:45:38',10,0),('1','195',257675,'MORNING SHIFT','2022-10-24','2022-10-24 13:34:05','2022-10-25 13:34:05','745',548912.00,548912.00,'745','2022-10-24 13:34:52','614','2022-10-24 14:16:03',10,0),('1','195',257676,'AFTERNOON SHIFT','2022-10-24','2022-10-24 14:58:36','2022-10-25 14:58:36','745',1450720.00,1450720.00,'745','2022-10-24 18:45:20','614','2022-10-24 20:50:25',10,0),('1','195',257677,'Morning','2022-10-25','2022-10-25 14:57:48','2022-10-26 14:57:48','745',1647056.30,1647056.30,'745','2022-10-25 15:02:54','614','2022-10-25 15:04:14',10,0),('1','195',257678,'AFTERNOON SHIFT','2022-10-25','2022-10-25 18:35:50','2022-10-26 18:35:50','745',1486392.00,1486392.00,'745','2022-10-25 18:48:51','614','2022-10-25 21:37:53',10,0),('1','195',257679,'MORNING SHIFT','2022-10-26','2022-10-26 09:06:50','2022-10-27 09:06:50','745',1797712.00,1797712.00,'745','2022-10-26 13:15:16','614','2022-10-26 14:53:20',10,0),('1','195',257680,'AFTERNOON SHIFT','2022-10-26','2022-10-26 19:02:41','2022-10-27 19:02:41','745',2301248.00,2301248.00,'745','2022-10-26 19:03:27','614','2022-10-27 02:01:10',10,0),('1','195',257681,'MORNING SHIFT','2022-10-27','2022-10-27 09:22:51','2022-10-28 09:22:51','745',2499112.00,2499112.00,'745','2022-10-27 13:07:31','614','2022-10-27 14:51:34',10,0),('1','195',257682,'AFTERNOON SHIFT','2022-10-27','2022-10-27 20:24:28','2022-10-28 20:24:28','745',1390528.00,1390528.00,'745','2022-10-27 20:25:39','614','2022-10-27 22:04:10',10,0),('1','195',257683,'MORNING SHIFT','2022-10-28','2022-10-28 10:36:08','2022-10-29 10:36:08','745',1595736.00,1595736.00,'745','2022-10-28 13:07:49','614','2022-10-28 16:56:08',10,0),('1','195',257684,'AFTERNOON SHIFT','2022-10-28','2022-10-28 20:41:31','2022-10-29 20:41:31','745',2432784.00,2432784.00,'745','2022-10-28 20:42:46','614','2022-10-28 20:45:38',10,0),('1','195',257685,'MORNING SHIFT','2022-10-29','2022-10-29 10:27:54','2022-10-30 10:27:54','745',1960584.00,1960584.00,'745','2022-10-29 13:06:16','614','2022-10-29 14:52:33',10,0),('1','195',257686,'AFTERNOON SHIFT','2022-10-29','2022-10-29 20:37:53','2022-10-30 20:37:53','745',4205288.00,4205288.00,'745','2022-10-29 20:40:06','614','2022-10-29 22:15:22',10,0),('1','195',257687,'MORNING SHIFT','2022-10-30','2022-10-30 12:55:22','2022-10-31 12:55:22','745',3089328.00,3089328.00,'745','2022-10-30 12:57:39','614','2022-10-30 14:29:57',10,0),('1','195',257688,'AFTERNOON SHIFT','2022-10-30','2022-10-30 20:37:00','2022-10-31 20:37:00','745',831400.00,831400.00,'745','2022-10-30 20:39:15','614','2022-10-30 21:12:39',10,0),('1','195',257689,'MORNING SHIFT','2022-10-31','2022-10-31 12:49:15','2022-11-01 12:49:15','745',2828272.00,2828272.00,'745','2022-10-31 12:51:43','614','2022-10-31 15:02:16',10,0),('1','195',257690,'AFTERNOON SHIFT','2022-10-31','2022-10-31 20:31:29','2022-11-01 20:31:29','745',3008912.00,3008912.00,'745','2022-10-31 20:33:19','614','2022-10-31 22:35:16',10,0),('1','195',257691,'MORNING SHIFT','2022-11-01','2022-11-01 13:14:12','2022-11-02 13:14:12','745',2228440.00,2228440.00,'745','2022-11-01 13:24:41','614','2022-11-01 13:38:20',10,0),('1','195',257692,'AFTERNOON SHIFT','2022-11-01','2022-11-01 20:38:52','2022-11-02 20:38:52','745',1877816.00,1877816.00,'745','2022-11-01 20:41:32','614','2022-11-01 21:35:24',10,0),('1','195',257693,'MORNING SHIFT','2022-11-02','2022-11-02 12:35:37','2022-11-03 12:35:37','745',5528032.00,5528032.00,'745','2022-11-02 16:32:36','614','2022-11-02 18:19:14',10,0),('1','195',257694,'AFTERNOON SHIFT','2022-11-02','2022-11-02 19:56:36','2022-11-03 19:56:36','745',2385704.00,2385704.00,'745','2022-11-02 19:57:29','614','2022-11-03 07:13:30',10,0),('1','195',257695,'MORNING SHIFT','2022-11-03','2022-11-03 13:04:19','2022-11-04 13:04:19','745',2198704.00,2198704.00,'745','2022-11-03 13:06:20','614','2022-11-03 15:29:06',10,0),('1','195',257696,'AFTERNOON SHIFT','2022-11-03','2022-11-03 17:30:53','2022-11-04 17:30:53','745',1914096.00,1914096.00,'745','2022-11-03 21:22:50','614','2022-11-04 01:28:45',10,0),('1','195',257697,'Morning','2022-11-04','2022-11-04 13:17:23','2022-11-05 13:17:23','745',2940656.00,2940656.00,'745','2022-11-04 13:19:37','614','2022-11-04 16:53:26',10,0),('1','195',257698,'Afternoon','2022-11-04','2022-11-04 19:05:48','2022-11-05 19:05:48','745',2099672.00,2099672.00,'745','2022-11-04 20:23:15','614','2022-11-05 00:08:36',10,0),('1','195',257699,'AFTERNOON SHIFT','2022-11-05','2022-11-05 09:22:23','2022-11-06 09:22:23','745',2078104.00,2078104.00,'745','2022-11-05 12:49:11','614','2022-11-05 15:34:45',10,0),('1','195',257700,'AFTERNOON SHIFT','2022-11-05','2022-11-05 18:56:54','2022-11-06 18:56:54','745',2247816.00,2247816.00,'745','2022-11-05 18:58:30','614','2022-11-05 23:27:35',10,0),('1','195',257701,'MORNING SHIFT','2022-11-06','2022-11-06 13:09:45','2022-11-07 13:09:45','745',2952456.00,2952456.00,'745','2022-11-06 13:13:19','614','2022-11-06 17:30:43',10,0),('1','195',257702,'AFTERNOON SHIFT','2022-11-06','2022-11-06 19:53:10','2022-11-07 19:53:10','745',842120.00,842120.00,'745','2022-11-06 19:54:00','614','2022-11-06 23:51:21',10,0),('1','195',257703,'MORNING SHIFT','2022-11-07','2022-11-07 13:07:17','2022-11-08 13:07:17','745',2298288.00,2298288.00,'745','2022-11-07 13:08:04','614','2022-11-07 17:27:14',10,0),('1','195',257704,'AFTERNOON SHIFT','2022-11-07','2022-11-07 19:47:02','2022-11-08 19:47:02','745',1395920.00,1395920.00,'745','2022-11-07 19:48:39','614','2022-11-07 23:14:17',10,0),('1','195',257705,'Morning','2022-11-08','2022-11-08 12:55:21','2022-11-09 12:55:21','745',2162616.00,2162616.00,'745','2022-11-08 12:58:29','614','2022-11-08 16:30:54',10,0),('1','195',257706,'AFTERNOON SHIFT','2022-11-08','2022-11-08 21:02:55','2022-11-09 21:02:55','745',1539176.00,1539176.00,'745','2022-11-08 21:03:57','614','2022-11-09 13:10:22',10,0),('1','195',257707,'MORNING SHIFT','2022-11-09','2022-11-09 13:13:07','2022-11-10 13:13:07','745',3022064.00,3022064.00,'745','2022-11-09 13:19:48','614','2022-11-09 17:52:12',10,0),('1','195',257708,'AFTERNOON SHIFT','2022-11-09','2022-11-09 20:23:37','2022-11-10 20:23:37','745',5703088.10,5703088.10,'745','2022-11-09 20:25:53','614','2022-11-09 20:39:08',10,0),('1','195',257709,'MORNING SHIFT','2022-11-10','2022-11-10 09:03:45','2022-11-11 09:03:45','745',3498380.95,3498380.95,'745','2022-11-10 13:25:40','614','2022-11-10 13:39:08',10,0),('1','195',257710,'AFTERNOON SHIFT','2022-11-10','2022-11-10 19:57:18','2022-11-11 19:57:18','745',3133153.05,3133153.05,'745','2022-11-10 20:00:27','614','2022-11-10 20:11:18',10,0),('1','195',257711,'MORNING SHIFT','2022-11-11','2022-11-11 12:32:42','2022-11-12 12:32:42','745',1686460.20,1686460.20,'745','2022-11-11 12:35:33','614','2022-11-11 16:47:18',10,0),('1','195',257712,'AFTERNOON SHIFT','2022-11-11','2022-11-11 19:50:21','2022-11-12 19:50:21','745',2090938.95,2090938.95,'745','2022-11-12 09:48:48','614','2022-11-12 09:50:26',10,0),('1','195',257713,'MORNING SHIFT','2022-11-12','2022-11-12 09:58:14','2022-11-13 09:58:14','745',2702624.05,2702624.05,'745','2022-11-12 13:54:05','614','2022-11-12 14:22:18',10,0),('1','195',257714,'AFTERNOON SHIFT','2022-11-12','2022-11-12 20:25:36','2022-11-13 20:25:36','745',1054418.65,1054418.65,'745','2022-11-12 20:27:35','614','2022-11-13 07:50:34',10,0),('1','195',257715,'MORNING SHIFT','2022-11-13','2022-11-13 13:39:25','2022-11-14 13:39:25','745',366707.00,366707.00,'745','2022-11-13 13:42:29','614','2022-11-13 15:04:19',10,0),('1','195',257716,'AFTERNOON SHIFT','2022-11-13','2022-11-13 20:43:07','2022-11-14 20:43:07','745',290593.50,290593.50,'745','2022-11-13 20:44:53','614','2022-11-13 23:43:38',10,0),('1','195',257717,'AFTERNOON SHIFT','2022-11-14','2022-11-14 20:11:41','2022-11-15 20:11:41','745',2294351.00,2294351.00,'745','2022-11-14 20:12:29','614','2022-11-15 06:25:02',10,0),('1','195',257718,'Morning','2022-11-15','2022-11-15 13:04:58','2022-11-16 13:04:58','745',3730361.80,3730361.80,'745','2022-11-15 13:08:20','614','2022-11-15 18:55:51',10,0),('1','195',257719,'AFTERNOON SHIFT','2022-11-15','2022-11-15 20:08:02','2022-11-16 20:08:02','745',1056931.40,1056931.40,'745','2022-11-15 20:09:17','614','2022-11-15 20:51:09',10,0),('1','195',257720,'MORNING SHIFT','2022-11-16','2022-11-16 09:26:17','2022-11-17 09:26:17','745',2196702.75,2196702.75,'745','2022-11-16 13:01:22','614','2022-11-16 17:07:03',10,0),('1','195',257721,'AFTERNOON SHIFT','2022-11-16','2022-11-16 20:03:06','2022-11-17 20:03:06','745',1584948.75,1584948.75,'745','2022-11-16 20:04:06','614','2022-11-17 06:05:49',10,0),('1','195',257722,'Morning','2022-11-17','2022-11-17 13:13:58','2022-11-18 13:13:58','745',2792592.00,2792592.00,'745','2022-11-17 13:15:18','975','2022-11-17 17:21:12',10,0),('1','195',257723,'AFTERNOON SHIFT','2022-11-17','2022-11-17 19:55:44','2022-11-18 19:55:44','745',2581383.75,2581383.75,'745','2022-11-17 19:57:56','614','2022-11-17 20:45:35',10,0),('1','195',257724,'MORNING SHIFT','2022-11-18','2022-11-18 12:36:12','2022-11-19 12:36:12','745',2250946.50,2250946.50,'745','2022-11-18 12:37:17','614','2022-11-18 15:50:40',10,0),('1','195',257725,'AFTERNOON SHIFT','2022-11-18','2022-11-18 19:12:06','2022-11-19 19:12:06','745',1779822.00,1779822.00,'745','2022-11-18 20:02:03','614','2022-11-18 21:33:55',10,0),('1','195',257726,'MORNING SHIFT','2022-11-19','2022-11-19 13:21:52','2022-11-20 13:21:52','745',2755494.00,2755494.00,'745','2022-11-19 13:22:32','975','2022-11-19 13:27:44',10,0),('1','195',257727,'AFTERNOON SHIFT','2022-11-19','2022-11-19 20:23:38','2022-11-20 20:23:38','745',1262528.40,1262528.40,'745','2022-11-19 20:36:59','614','2022-11-19 23:43:39',10,0),('1','195',257728,'Morning','2022-11-20','2022-11-20 13:16:04','2022-11-21 13:16:04','745',3364183.20,3364183.20,'745','2022-11-20 13:18:55','614','2022-11-20 15:45:55',10,0),('1','195',257729,'Afternoon','2022-11-20','2022-11-20 19:31:25','2022-11-21 19:31:25','745',3752229.60,3752229.60,'745','2022-11-20 19:33:12','614','2022-11-20 23:05:20',10,0),('1','195',257730,'MORNING SHIFT','2022-11-21','2022-11-21 14:07:58','2022-11-22 14:07:58','745',2803264.80,2803264.80,'745','2022-11-21 14:09:53','614','2022-11-21 15:52:27',10,0),('1','195',257731,'AFTERNOON SHIFT','2022-11-21','2022-11-21 19:54:21','2022-11-22 19:54:21','745',4115311.20,4115311.20,'745','2022-11-21 19:55:23','614','2022-11-21 21:45:16',10,0),('1','195',257732,'MORNING SHIFT','2022-11-22','2022-11-22 10:42:26','2022-11-23 10:42:26','745',3579702.00,3579702.00,'745','2022-11-22 13:11:48','614','2022-11-22 16:38:44',10,0),('1','195',257733,'AFTERNOON SHIFT','2022-11-22','2022-11-22 20:19:38','2022-11-23 20:19:38','745',2632291.20,2632291.20,'745','2022-11-22 20:24:39','614','2022-11-23 12:32:56',10,0),('1','195',257734,'MORNING SHIFT','2022-11-23','2022-11-23 12:34:12','2022-11-24 12:34:12','745',5609662.80,5609662.80,'745','2022-11-23 12:39:21','614','2022-11-23 14:38:54',10,0),('1','195',257735,'AFTERNOON SHIFT','2022-11-23','2022-11-23 20:37:45','2022-11-24 20:37:45','745',730984.80,730984.80,'745','2022-11-24 08:01:04','614','2022-11-24 09:49:45',10,0),('1','195',257736,'MORNING SHIFT','2022-11-24','2022-11-24 12:51:00','2022-11-25 12:51:00','745',2145133.20,2145133.20,'745','2022-11-24 15:58:22','614','2022-11-24 17:26:35',10,0),('1','195',257737,'AFTERNOON SHIFT','2022-11-24','2022-11-24 17:41:18','2022-11-25 17:41:18','745',2579465.70,2579465.70,'745','2022-11-24 20:18:44','614','2022-11-24 23:27:39',10,0),('1','195',257738,'MORNING SHIFT','2022-11-25','2022-11-25 09:03:20','2022-11-26 09:03:20','745',3385702.80,3385702.80,'745','2022-11-25 14:31:37','614','2022-11-25 15:08:41',10,0),('1','195',257739,'AFTERNOON SHIFT','2022-11-25','2022-11-25 19:07:37','2022-11-26 19:07:37','745',2102033.10,2102033.10,'745','2022-11-25 19:38:02','614','2022-11-25 19:45:04',10,0),('1','195',257740,'MORNING SHIFT','2022-11-26','2022-11-26 11:07:06','2022-11-27 11:07:06','745',3356105.00,3356105.00,'745','2022-11-26 13:07:37','614','2022-11-26 16:30:39',10,0),('1','195',257741,'AFTERNOON SHIFT','2022-11-26','2022-11-26 21:18:06','2022-11-27 21:18:06','745',1979550.00,1979550.00,'745','2022-11-26 21:19:56','614','2022-11-27 13:28:26',10,0),('1','195',257742,'MORNING SHIFT','2022-11-27','2022-11-27 15:20:40','2022-11-28 15:20:40','745',488928.10,488928.10,'745','2022-11-27 15:22:02','614','2022-11-27 21:57:29',10,0),('1','195',257743,'AFTERNOON SHIFT','2022-11-27','2022-11-27 22:01:57','2022-11-28 22:01:57','745',1394449.80,1394449.80,'745','2022-11-27 22:03:45','614','2022-11-28 07:07:31',10,0),('1','195',257744,'MORNING SHIFT','2022-11-28','2022-11-28 12:13:35','2022-11-29 12:13:35','745',2151725.20,2151725.20,'745','2022-11-28 15:39:32','614','2022-11-28 18:00:58',10,0),('1','195',257745,'AFTERNOON SHIFT','2022-11-28','2022-11-28 19:06:20','2022-11-29 19:06:20','745',976827.00,976827.00,'745','2022-11-28 19:07:45','614','2022-11-29 12:15:43',10,0),('1','195',257746,'MORNING SHIFT','2022-11-29','2022-11-29 14:57:25','2022-11-30 14:57:25','745',1864769.30,1864769.30,'745','2022-11-29 14:59:00','975','2022-11-29 15:01:37',10,0),('1','195',257747,'MORNING SHIFT','2022-11-29','2022-11-29 15:14:00','2022-11-30 15:14:00','745',186992.40,186992.40,'745','2022-11-29 15:15:38','614','2022-11-29 16:34:29',10,0),('1','195',257748,'Afternoon','2022-11-29','2022-11-29 21:08:56','2022-11-30 21:08:56','745',3060934.80,3060934.80,'745','2022-11-29 21:10:42','614','2022-11-29 22:33:37',10,0),('1','195',257749,'MORNING SHIFT','2022-11-30','2022-11-30 12:47:12','2022-12-01 12:47:12','745',1690680.75,1690680.75,'745','2022-11-30 12:53:36','614','2022-11-30 15:37:36',10,0),('1','195',257750,'AFTERNOON SHIFT','2022-11-30','2022-11-30 21:28:04','2022-12-01 21:28:04','745',3966740.40,3966740.40,'745','2022-11-30 21:31:05','975','2022-12-01 13:44:44',10,0),('1','195',257751,'MORNING SHIFT','2022-12-01','2022-12-01 14:15:09','2022-12-02 14:15:09','745',1477014.00,1477014.00,'745','2022-12-01 14:16:38','975','2022-12-02 10:38:40',10,0),('1','195',257752,'AFTERNOON SHIFT','2022-12-01','2022-12-02 12:45:57','2022-12-03 12:45:57','745',2249872.80,2249872.80,'745','2022-12-02 12:47:22','975','2022-12-02 15:39:47',10,0),('1','195',257753,'MORNING SHIFT','2022-12-02','2022-12-02 21:48:55','2022-12-03 21:48:55','745',2207158.80,2207158.80,'745','2022-12-02 21:51:55','975','2022-12-03 13:44:55',10,0),('1','195',257754,'AFTERNOON SHIFT','2022-12-02','2022-12-03 14:12:09','2022-12-04 14:12:09','745',447409.20,447409.20,'745','2022-12-03 14:43:11','975','2022-12-03 16:41:44',10,0),('1','195',257755,'MORNING SHIFT','2022-12-03','2022-12-03 16:49:12','2022-12-04 16:49:12','745',2048608.80,2048608.80,'745','2022-12-03 17:01:12','975','2022-12-03 21:14:46',10,0),('1','195',257756,'AFTERNOON SHIFT','2022-12-03','2022-12-03 21:22:41','2022-12-04 21:22:41','745',790592.00,790592.00,'745','2022-12-03 21:27:33','975','2022-12-04 08:42:06',10,0),('1','195',257757,'MORNING SHIFT','2022-12-04','2022-12-04 12:31:34','2022-12-05 12:31:34','745',426342.40,426342.40,'745','2022-12-04 12:34:46','975','2022-12-05 05:54:45',10,0),('1','195',257758,'AFTERNOON SHIFT','2022-12-04','2022-12-05 09:43:50','2022-12-06 09:43:50','745',660000.00,660000.00,'745','2022-12-05 09:47:06','975','2022-12-05 09:54:14',10,0),('1','195',257759,'MORNING SHIFT','2022-12-05','2022-12-05 13:19:41','2022-12-06 13:19:41','745',2563580.80,2563580.80,'745','2022-12-05 13:21:16','975','2022-12-05 18:00:30',10,0),('1','195',257760,'AFTERNOON SHIFT','2022-12-05','2022-12-05 19:11:52','2022-12-06 19:11:52','745',3158883.20,3158883.20,'745','2022-12-05 19:12:54','975','2022-12-06 11:52:47',10,0),('1','195',257761,'MORNING SHIFT','2022-12-06','2022-12-06 13:25:11','2022-12-07 13:25:11','745',2346537.60,2346537.60,'745','2022-12-06 13:26:36','975','2022-12-06 15:22:18',10,0),('1','195',257762,'AFTERNOON SHIFT','2022-12-06','2022-12-06 15:34:36','2022-12-07 15:34:36','745',825880.00,825880.00,'745','2022-12-06 15:38:13','975','2022-12-06 16:56:59',10,0),('1','195',257763,'AFTERNOON SHIFT','2022-12-06','2022-12-06 18:21:06','2022-12-07 18:21:06','745',848794.80,848794.80,'745','2022-12-06 21:05:12','975','2022-12-07 11:11:44',10,0),('1','195',257764,'MORNING SHIFT','2022-12-07','2022-12-07 13:30:39','2022-12-08 13:30:39','745',2418276.80,2418276.80,'745','2022-12-07 14:18:21','975','2022-12-07 15:40:04',10,0),('1','195',257765,'AFTERNOON SHIFT','2022-12-07','2022-12-07 17:25:02','2022-12-08 17:25:02','745',3020266.00,3020266.00,'745','2022-12-07 20:27:42','975','2022-12-08 10:24:38',10,0),('1','195',257766,'MORNING SHIFT','2022-12-08','2022-12-08 10:53:26','2022-12-09 10:53:26','745',3809903.20,3809903.20,'745','2022-12-08 14:46:44','975','2022-12-08 15:32:37',10,0),('1','195',257767,'AFTERNOON SHIFT','2022-12-08','2022-12-08 20:47:06','2022-12-09 20:47:06','745',3863520.60,3863520.60,'745','2022-12-08 20:52:29','975','2022-12-09 09:13:21',10,0),('1','195',257768,'MORNING SHIFT','2022-12-09','2022-12-09 14:24:57','2022-12-10 14:24:57','745',3208433.80,3208433.80,'745','2022-12-09 14:27:06','975','2022-12-09 18:02:09',10,0),('1','195',257769,'AFTERNOON SHIFT','2022-12-09','2022-12-09 19:23:05','2022-12-10 19:23:05','745',2224917.00,2224917.00,'745','2022-12-10 09:44:53','975','2022-12-10 14:05:37',10,0),('1','195',257770,'MORNING SHIFT','2022-12-10','2022-12-10 14:49:15','2022-12-11 14:49:15','745',1588893.60,1588893.60,'745','2022-12-10 14:53:29','975','2022-12-11 07:55:16',10,0),('1','195',257771,'AFTERNOON SHIFT','2022-12-10','2022-12-11 10:48:32','2022-12-12 10:48:32','745',1302050.40,1302050.40,'745','2022-12-11 10:50:09','975','2022-12-11 12:07:16',10,0),('1','195',257772,'MORNING SHIFT','2022-12-11','2022-12-11 12:14:34','2022-12-12 12:14:34','745',2147846.40,2147846.40,'745','2022-12-11 13:35:13','975','2022-12-11 15:40:41',10,0),('1','195',257773,'AFTERNOON SHIFT','2022-12-11','2022-12-11 15:51:47','2022-12-12 15:51:47','745',567562.80,567562.80,'745','2022-12-11 15:53:02','975','2022-12-12 08:34:38',10,0),('1','195',257774,'AFTERNOON SHIFT','2022-12-12','2022-12-12 09:09:42','2022-12-13 09:09:42','745',0.00,0.00,'975','2022-12-12 09:19:18','975','2022-12-12 09:19:37',10,0),('1','195',257775,'AFTERNOON SHIFT','2022-12-11','2022-12-12 09:22:27','2022-12-13 09:22:27','745',1391810.40,1391810.40,'745','2022-12-12 09:23:19','975','2022-12-12 13:17:00',10,0),('1','195',257776,'MORNING SHIFT','2022-12-12','2022-12-12 13:50:51','2022-12-13 13:50:51','745',3364205.80,3364205.80,'745','2022-12-12 13:54:39','975','2022-12-12 20:26:28',10,0),('1','195',257777,'AFTERNOON SHIFT','2022-12-12','2022-12-12 20:27:00','2022-12-13 20:27:00','745',2128626.30,2128626.30,'745','2022-12-12 20:28:32','975','2022-12-13 10:24:23',10,0),('1','195',257778,'MORNING SHIFT','2022-12-13','2022-12-13 12:37:17','2022-12-14 12:37:17','745',2674608.60,2674608.60,'745','2022-12-13 12:39:02','975','2022-12-13 15:35:27',10,0),('1','195',257779,'AFTERNOON SHIFT','2022-12-13','2022-12-13 16:36:40','2022-12-14 16:36:40','745',3258986.70,3258986.70,'745','2022-12-14 09:23:19','975','2022-12-14 12:44:35',10,0),('1','195',257780,'MORNING SHIFT','2022-12-14','2022-12-14 12:54:27','2022-12-15 12:54:27','745',2596829.30,2596829.30,'745','2022-12-14 12:59:08','975','2022-12-14 16:37:40',10,0),('1','195',257781,'Afternoon','2022-12-14','2022-12-14 21:18:58','2022-12-15 21:18:58','745',2955591.60,2955591.60,'745','2022-12-14 21:22:38','975','2022-12-15 11:00:24',10,0),('1','195',257782,'MORNING SHIFT','2022-12-15','2022-12-15 13:02:55','2022-12-16 13:02:55','745',2670969.60,2670969.60,'745','2022-12-15 13:04:11','975','2022-12-15 17:30:17',10,0),('1','195',257783,'AFTERNOON SHIFT','2022-12-15','2022-12-15 20:46:59','2022-12-16 20:46:59','745',1531522.20,1531522.20,'745','2022-12-15 20:48:02','975','2022-12-16 14:08:24',10,0),('1','195',257784,'MORNING SHIFT','2022-12-16','2022-12-16 14:19:57','2022-12-17 14:19:57','745',3697109.40,3697109.40,'745','2022-12-16 14:41:29','975','2022-12-16 20:22:20',10,0),('1','195',257785,'AFTERNOON SHIFT','2022-12-16','2022-12-17 08:47:23','2022-12-18 08:47:23','745',4885428.80,4885428.80,'745','2022-12-17 08:48:51','975','2022-12-17 13:43:01',10,0),('1','195',257786,'MORNING SHIFT','2022-12-17','2022-12-17 13:56:39','2022-12-18 13:56:39','745',1742180.20,1742180.20,'745','2022-12-17 13:58:45','975','2022-12-17 19:17:52',10,0),('1','195',257787,'AFTERNOON SHIFT','2022-12-17','2022-12-17 20:54:14','2022-12-18 20:54:14','745',4576592.20,4576592.20,'745','2022-12-18 10:28:58','975','2022-12-19 07:28:24',10,0),('1','195',257788,'AFTERNOON SHIFT','2022-12-18','2022-12-19 09:44:06','2022-12-20 09:44:06','745',3494635.00,3494635.00,'745','2022-12-19 09:52:00','975','2022-12-19 10:50:05',10,0),('1','195',257789,'AFTERNOON SHIFT','2022-12-18','2022-12-19 10:51:59','2022-12-20 10:51:59','745',1632923.40,1632923.40,'745','2022-12-19 11:17:10','975','2022-12-19 13:22:55',10,0),('1','195',257790,'MORNING SHIFT','2022-12-19','2022-12-19 14:04:39','2022-12-20 14:04:39','745',3134359.80,3134359.80,'745','2022-12-19 14:19:41','975','2022-12-19 18:35:31',10,0),('1','195',257791,'AFTERNOON SHIFT','2022-12-19','2022-12-19 19:23:25','2022-12-20 19:23:25','745',1991992.00,1991992.00,'745','2022-12-19 19:28:52','975','2022-12-19 20:13:53',10,0),('1','195',257792,'MORNING SHIFT','2022-12-20','2022-12-20 11:41:41','2022-12-21 11:41:41','745',4450112.20,4450112.20,'745','2022-12-20 15:28:34','975','2022-12-20 17:29:30',10,0),('1','195',257793,'Afternoon','2022-12-20','2022-12-20 20:50:44','2022-12-21 20:50:44','745',5276534.00,5276534.00,'745','2022-12-21 07:10:16','975','2022-12-21 10:23:04',10,0),('1','195',257794,'MORNING SHIFT','2022-12-21','2022-12-21 15:12:00','2022-12-22 15:12:00','745',4903459.10,4903459.10,'745','2022-12-21 15:13:39','975','2022-12-21 19:10:25',10,0),('1','195',257795,'AFTERNOON SHIFT','2022-12-21','2022-12-22 17:17:28','2022-12-23 17:17:28','745',4370115.90,4370115.90,'745','2022-12-22 17:19:27','975','2022-12-22 19:53:09',10,0),('1','195',257796,'AFTERNOON SHIFT','2022-12-22','2022-12-22 20:29:08','2022-12-23 20:29:08','745',5547060.40,5547060.40,'745','2022-12-22 21:01:21','735','2022-12-23 10:17:51',10,0),('1','195',257797,'AFTERNOON SHIFT','2022-12-22','2022-12-23 10:30:37','2022-12-24 10:30:37','745',5694196.20,5694196.20,'745','2022-12-23 10:58:21','975','2022-12-23 11:54:00',10,0),('1','195',257798,'MORNING SHIFT','2022-12-23','2022-12-23 14:00:14','2022-12-24 14:00:14','745',3114379.70,3114379.70,'745','2022-12-23 14:10:35','975','2022-12-23 16:36:53',10,0),('1','195',257799,'AFTERNOON SHIFT','2022-12-23','2022-12-23 20:15:32','2022-12-24 20:15:32','745',5464947.40,5464947.40,'745','2022-12-23 20:16:31','975','2022-12-24 09:57:47',10,0),('1','195',257800,'MORNING SHIFT','2022-12-24','2022-12-24 12:19:21','2022-12-25 12:19:21','745',3839887.80,3839887.80,'745','2022-12-24 13:16:15','975','2022-12-24 15:36:43',10,0),('1','195',257801,'Afternoon','2022-12-24','2022-12-24 17:53:02','2022-12-25 17:53:02','745',2606804.60,2606804.60,'745','2022-12-24 19:56:10','975','2022-12-25 07:00:50',10,0),('1','195',257802,'MORNING SHIFT','2022-12-25','2022-12-25 13:41:01','2022-12-26 13:41:01','745',2885235.60,2885235.60,'745','2022-12-25 13:50:18','975','2022-12-26 08:18:19',10,0),('1','195',257803,'MORNING SHIFT','2022-12-26','2022-12-26 14:28:40','2022-12-27 14:28:40','745',0.00,0.00,'975','2022-12-26 15:09:32','975','2022-12-26 15:09:56',10,0),('1','195',257804,'Afternoon','2022-12-25','2022-12-26 18:01:15','2022-12-27 18:01:15','745',2527240.00,2527240.00,'745','2022-12-26 19:12:29','975','2022-12-27 10:11:10',10,0),('1','195',257805,'MORNING SHIFT','2022-12-26','2022-12-27 12:51:38','2022-12-28 12:51:38','745',7466127.40,7466127.40,'745','2022-12-27 12:58:28','975','2022-12-27 13:08:44',10,0),('1','195',257806,'AFTERNOON SHIFT','2022-12-26','2022-12-27 13:18:03','2022-12-28 13:18:03','745',8471201.60,8471201.60,'745','2022-12-27 13:23:33','975','2022-12-27 14:02:48',10,0),('1','195',257807,'MORNING SHIFT','2022-12-27','2022-12-27 14:18:44','2022-12-28 14:18:44','745',4719496.15,4719496.15,'745','2022-12-27 14:37:15','975','2022-12-28 09:54:59',10,0),('1','195',257808,'AFTERNOON SHIFT','2022-12-27','2022-12-28 10:03:48','2022-12-29 10:03:48','745',2248188.95,2248188.95,'745','2022-12-28 10:33:55','975','2022-12-28 11:35:28',10,0),('1','195',257809,'MORNING SHIFT','2022-12-28','2022-12-28 11:51:10','2022-12-29 11:51:10','745',3637643.00,3637643.00,'745','2022-12-28 12:43:39','975','2022-12-28 15:46:25',10,0),('1','195',257810,'AFTERNOON SHIFT','2022-12-28','2022-12-28 17:31:19','2022-12-29 17:31:19','745',4691075.85,4691075.85,'745','2022-12-28 20:20:42','975','2022-12-29 12:30:15',10,0),('1','195',257811,'MORNING SHIFT','2022-12-29','2022-12-29 15:12:23','2022-12-30 15:12:23','745',3210464.00,3210464.00,'745','2022-12-29 15:14:49','975','2022-12-29 16:35:22',10,0),('1','195',257812,'AFTERNOON SHIFT','2022-12-29','2022-12-29 19:49:23','2022-12-30 19:49:23','745',3903290.20,3903290.20,'745','2022-12-29 20:53:00','975','2022-12-30 11:43:09',10,0),('1','195',257813,'MORNING SHIFT','2022-12-30','2022-12-30 14:49:44','2022-12-31 14:49:44','745',2782907.80,2782907.80,'745','2022-12-30 14:51:10','975','2022-12-30 19:36:19',10,0),('1','195',257814,'AFTERNOON SHIFT','2022-12-30','2022-12-30 20:22:35','2022-12-31 20:22:35','745',5043000.00,5043000.00,'745','2022-12-30 20:26:23','975','2022-12-31 10:48:57',10,0),('1','195',257815,'MORNING SHIFT','2022-12-31','2022-12-31 11:04:52','2023-01-01 11:04:52','745',6906047.95,6906047.95,'745','2022-12-31 15:22:02','975','2022-12-31 16:57:44',10,0),('1','195',257816,'AFTERNOON SHIFT','2022-12-31','2022-12-31 20:44:52','2023-01-01 20:44:52','745',4052538.40,4052538.40,'745','2022-12-31 21:14:20','975','2023-01-01 12:35:12',10,0),('1','195',257817,'MORNING SHIFT','2023-01-01','2023-01-01 13:05:46','2023-01-02 13:05:46','745',4638778.25,4638778.25,'745','2023-01-01 16:57:19','975','2023-01-02 10:49:40',10,0),('1','195',257818,'AFTERNOON SHIFT','2023-01-01','2023-01-02 12:21:35','2023-01-03 12:21:35','745',2884031.55,2884031.55,'745','2023-01-02 15:11:34','975','2023-01-02 15:14:02',10,0),('1','195',257819,'MORNING SHIFT','2023-01-02','2023-01-02 15:16:01','2023-01-03 15:16:01','745',5442830.25,5442830.25,'745','2023-01-02 15:25:45','975','2023-01-02 16:28:37',10,0),('1','195',257820,'AFTERNOON SHIFT','2023-01-02','2023-01-02 18:34:53','2023-01-03 18:34:53','745',5893477.30,5893477.30,'745','2023-01-02 20:33:03','975','2023-01-03 13:19:37',10,0),('1','195',257821,'MORNING SHIFT','2023-01-03','2023-01-03 13:31:28','2023-01-04 13:31:28','745',3569530.25,3569530.25,'745','2023-01-03 13:34:16','975','2023-01-03 14:40:13',10,0),('1','195',257822,'AFTERNOON SHIFT','2023-01-03','2023-01-03 19:34:10','2023-01-04 19:34:10','745',5780378.25,5780378.25,'745','2023-01-03 19:38:07','975','2023-01-04 10:33:49',10,0),('1','195',257823,'MORNING SHIFT','2023-01-04','2023-01-04 11:42:21','2023-01-05 11:42:21','745',5373182.00,5373182.00,'745','2023-01-04 14:25:03','975','2023-01-05 09:07:22',10,0),('1','195',257824,'AFTERNOON SHIFT','2023-01-04','2023-01-05 10:51:14','2023-01-06 10:51:14','745',5127603.25,5127603.25,'745','2023-01-05 10:53:31','975','2023-01-05 11:47:32',10,0),('1','195',257825,'MORNING SHIFT','2023-01-05','2023-01-05 13:04:03','2023-01-06 13:04:03','745',9284310.10,9284310.10,'745','2023-01-05 14:15:25','975','2023-01-05 20:25:13',10,0),('1','195',257826,'Afternoon','2023-01-05','2023-01-05 21:54:11','2023-01-06 21:54:11','745',3405433.15,3405433.15,'745','2023-01-05 22:00:51','975','2023-01-06 10:38:54',10,0),('1','195',257827,'MORNING SHIFT','2023-01-06','2023-01-07 11:51:00','2023-01-08 11:51:00','745',6030577.75,6030577.75,'745','2023-01-07 12:00:04','975','2023-01-07 12:07:49',10,0),('1','195',257828,'AFTERNOON SHIFT','2023-01-06','2023-01-07 12:09:30','2023-01-08 12:09:30','745',5666536.20,5666536.20,'745','2023-01-07 12:16:27','975','2023-01-07 14:40:59',10,0),('1','195',257829,'MORNING SHIFT','2023-01-07','2023-01-07 19:26:23','2023-01-08 19:26:23','745',6514474.15,6514474.15,'745','2023-01-07 19:33:43','975','2023-01-08 10:02:03',10,0),('1','195',257830,'AFTERNOON SHIFT','2023-01-07','2023-01-08 10:17:52','2023-01-09 10:17:52','745',7514109.30,7514109.30,'745','2023-01-08 10:35:15','975','2023-01-09 09:38:37',10,0),('1','195',257831,'MORNING SHIFT','2023-01-08','2023-01-09 10:10:23','2023-01-10 10:10:23','745',5576795.30,5576795.30,'745','2023-01-09 11:14:26','975','2023-01-09 11:31:19',10,0),('1','195',257832,'AFTERNOON SHIFT','2023-01-08','2023-01-09 18:23:38','2023-01-10 18:23:38','745',4864449.15,4864449.15,'745','2023-01-09 18:28:14','975','2023-01-10 09:48:24',10,0),('1','195',257833,'MORNING SHIFT','2023-01-09','2023-01-10 11:54:59','2023-01-11 11:54:59','745',3737059.80,3737059.80,'745','2023-01-10 11:58:09','975','2023-01-10 14:38:53',10,0),('1','195',257834,'Afternoon','2023-01-09','2023-01-10 17:59:47','2023-01-11 17:59:47','745',3809173.05,3809173.05,'745','2023-01-10 18:03:59','975','2023-01-11 10:12:39',10,0),('1','195',257835,'MORNING SHIFT','2023-01-10','2023-01-11 10:15:28','2023-01-12 10:15:28','745',3868497.60,3868497.60,'745','2023-01-11 10:17:19','975','2023-01-11 10:18:39',10,0),('1','195',257836,'AFTERNOON SHIFT','2023-01-10','2023-01-11 10:32:50','2023-01-12 10:32:50','745',5653233.10,5653233.10,'745','2023-01-11 10:54:42','975','2023-01-11 13:40:08',10,0),('1','195',257837,'Morning','2023-01-11','2023-01-11 14:47:43','2023-01-12 14:47:43','745',3954081.00,3954081.00,'745','2023-01-11 14:48:56','975','2023-01-11 18:29:12',10,0),('1','195',257838,'AFTERNOON SHIFT','2023-01-11','2023-01-11 21:41:45','2023-01-12 21:41:45','745',3916057.60,3916057.60,'745','2023-01-11 21:48:56','975','2023-01-12 12:23:52',10,0),('1','195',257839,'MORNING SHIFT','2023-01-12','2023-01-12 16:54:10','2023-01-13 16:54:10','745',5587342.60,5587342.60,'745','2023-01-12 16:57:00','975','2023-01-13 11:19:49',10,0),('1','195',257840,'AFTERNOON SHIFT','2023-01-13','2023-01-13 11:22:51','2023-01-14 11:22:51','745',7684511.30,7684511.30,'745','2023-01-13 11:28:37','975','2023-01-13 23:06:08',10,0),('1','195',257841,'MORNING SHIFT','2023-01-13','2023-01-14 09:52:26','2023-01-15 09:52:26','745',4193784.85,4193784.85,'745','2023-01-14 10:37:26','975','2023-01-14 10:53:37',10,0),('1','195',257842,'AFTERNOON SHIFT','2023-01-13','2023-01-14 11:09:38','2023-01-15 11:09:38','745',5652222.75,5652222.75,'745','2023-01-14 11:12:59','975','2023-01-14 13:39:57',10,0),('1','195',257843,'MORNING SHIFT','2023-01-14','2023-01-14 15:13:56','2023-01-15 15:13:56','745',5535445.50,5535445.50,'745','2023-01-14 16:10:00','975','2023-01-14 17:40:41',10,0),('1','195',257844,'AFTERNOON SHIFT','2023-01-14','2023-01-14 20:36:44','2023-01-15 20:36:44','745',3486792.75,3486792.75,'745','2023-01-14 21:38:39','975','2023-01-15 12:34:30',10,0),('1','195',257845,'Morning','2023-01-15','2023-01-15 17:44:43','2023-01-16 17:44:43','745',3135343.80,3135343.80,'745','2023-01-15 18:30:22','975','2023-01-16 09:21:59',10,0),('1','195',257846,'AFTERNOON SHIFT','2023-01-15','2023-01-16 09:52:04','2023-01-17 09:52:04','745',2040348.60,2040348.60,'745','2023-01-16 10:12:59','734','2023-01-16 12:57:18',10,0),('1','195',257847,'MORNING SHIFT','2023-01-16','2023-01-16 14:32:55','2023-01-17 14:32:55','745',5137792.00,5137792.00,'745','2023-01-16 14:40:07','734','2023-01-16 15:02:48',10,0),('1','195',257848,'AFTERNOON SHIFT','2023-01-16','2023-01-16 19:43:38','2023-01-17 19:43:38','745',2124398.60,2124398.60,'745','2023-01-16 19:44:45','734','2023-01-16 19:46:14',10,0),('1','195',257849,'Morning','2023-01-17','2023-01-17 13:44:59','2023-01-18 13:44:59','745',4458938.60,4458938.60,'745','2023-01-17 13:45:47','734','2023-01-17 14:46:23',10,0),('1','195',257850,'Afternoon','2023-01-17','2023-01-17 18:17:56','2023-01-18 18:17:56','745',2913197.60,2913197.60,'745','2023-01-17 18:19:33','734','2023-01-17 18:27:35',10,0),('1','195',257851,'Afternoon','2023-01-17','2023-01-17 18:49:34','2023-01-18 18:49:34','745',0.00,0.00,'745','2023-01-17 19:21:04','734','2023-01-17 19:22:07',10,0),('1','195',257852,'Afternoon','2023-01-17','2023-01-17 19:27:55','2023-01-18 19:27:55','745',808884.80,808884.80,'745','2023-01-17 19:28:48','734','2023-01-17 19:38:02',10,0),('1','195',257853,'Morning','2023-01-18','2023-01-18 12:43:34','2023-01-19 12:43:34','745',4979790.90,4979790.90,'745','2023-01-18 12:45:06','734','2023-01-18 14:25:40',10,0),('1','195',257854,'Afternoon','2023-01-18','2023-01-18 19:23:40','2023-01-19 19:23:40','745',3562234.20,3562234.20,'745','2023-01-18 19:24:42','734','2023-01-18 19:31:56',10,0),('1','195',257855,'Morning','2023-01-19','2023-01-19 11:38:22','2023-01-20 11:38:22','745',7346897.75,7346897.75,'745','2023-01-19 12:58:47','734','2023-01-19 14:33:52',10,0),('1','195',257856,'AFTERNOON SHIFT','2023-01-19','2023-01-19 20:27:38','2023-01-20 20:27:38','745',7035109.10,7035109.10,'745','2023-01-19 20:31:49','734','2023-01-19 21:19:40',10,0),('1','195',257857,'MORNING SHIFT','2023-01-20','2023-01-20 12:13:50','2023-01-21 12:13:50','745',7261320.25,7261320.25,'745','2023-01-20 12:28:53','734','2023-01-20 12:47:08',10,0),('1','195',257858,'AFTERNOON SHIFT','2023-01-20','2023-01-20 13:00:06','2023-01-21 13:00:06','745',6261340.50,6261340.50,'745','2023-01-20 20:23:27','734','2023-01-21 03:45:01',10,0),('1','195',257859,'Morning','2023-01-21','2023-01-21 14:59:48','2023-01-22 14:59:48','745',1418285.70,1418285.70,'745','2023-01-21 15:01:23','734','2023-01-21 16:44:26',10,0),('1','195',257860,'Afternoon','2023-01-21','2023-01-21 20:26:01','2023-01-22 20:26:01','745',3783202.20,3783202.20,'745','2023-01-21 20:27:17','734','2023-01-22 16:40:06',10,0),('1','195',257861,'Morning','2023-01-22','2023-01-22 17:33:21','2023-01-23 17:33:21','745',2932127.10,2932127.10,'745','2023-01-22 17:35:15','734','2023-01-22 17:49:09',10,0),('1','195',257862,'AFTERNOON SHIFT','2023-01-22','2023-01-22 21:22:27','2023-01-23 21:22:27','745',3274992.00,3274992.00,'745','2023-01-22 21:23:39','734','2023-01-22 21:51:19',10,0),('1','195',257863,'Morning','2023-01-23','2023-01-23 12:37:44','2023-01-24 12:37:44','745',1306351.80,1306351.80,'745','2023-01-23 12:38:54','734','2023-01-23 13:07:46',10,0),('1','195',257864,'AFTERNOON SHIFT','2023-01-23','2023-01-23 20:37:13','2023-01-24 20:37:13','745',2799319.50,2799319.50,'745','2023-01-23 20:38:35','734','2023-01-23 22:19:08',10,0),('1','195',257865,'Morning','2023-01-24','2023-01-24 12:49:19','2023-01-25 12:49:19','745',2672157.60,2672157.60,'745','2023-01-24 12:50:24','734','2023-01-24 14:54:43',10,0),('1','195',257866,'Afternoon','2023-01-24','2023-01-24 19:46:09','2023-01-25 19:46:09','745',230526.00,230526.00,'745','2023-01-24 21:29:09','734','2023-01-24 21:42:27',10,0),('1','195',257867,'MORNING SHIFT','2023-01-26','2023-01-26 11:31:28','2023-01-27 11:31:28','745',1082065.60,1082065.60,'745','2023-01-26 15:06:08','734','2023-01-26 15:52:58',10,0),('1','195',257868,'Afternoon','2023-01-26','2023-01-26 21:07:58','2023-01-27 21:07:58','745',1919082.00,1919082.00,'745','2023-01-26 21:10:23','734','2023-01-26 22:07:23',10,0),('1','195',257869,'MORNING SHIFT','2023-01-27','2023-01-27 15:10:16','2023-01-28 15:10:16','745',2613314.00,2613314.00,'745','2023-01-27 15:12:30','734','2023-01-27 18:05:02',10,0),('1','195',257870,'AFTERNOON SHIFT','2023-01-27','2023-01-27 20:19:12','2023-01-28 20:19:12','745',3380968.80,3380968.80,'745','2023-01-27 20:22:57','734','2023-01-28 06:39:42',10,0),('1','195',257871,'Morning','2023-01-28','2023-01-28 14:22:11','2023-01-29 14:22:11','745',1966822.00,1966822.00,'745','2023-01-28 14:25:31','734','2023-01-28 15:00:26',10,0),('1','195',257872,'AFTERNOON SHIFT','2023-01-28','2023-01-28 21:40:07','2023-01-29 21:40:07','745',2004948.90,2004948.90,'745','2023-01-28 21:41:48','734','2023-01-29 09:38:10',10,0),('1','195',257873,'Morning','2023-01-29','2023-01-29 13:03:44','2023-01-30 13:03:44','745',4706030.00,4706030.00,'745','2023-01-29 13:04:46','734','2023-01-29 14:35:08',10,0),('1','195',257874,'Afternoon','2023-01-29','2023-01-29 21:17:11','2023-01-30 21:17:11','745',3119023.30,3119023.30,'745','2023-01-29 21:19:06','734','2023-01-29 22:20:00',10,0),('1','195',257875,'Morning','2023-01-30','2023-01-30 14:51:01','2023-01-31 14:51:01','745',1972683.60,1972683.60,'745','2023-01-30 14:55:28','734','2023-01-30 14:59:30',10,0),('1','195',257876,'Afternoon','2023-01-30','2023-01-30 19:46:41','2023-01-31 19:46:41','745',8527957.70,8527957.70,'745','2023-01-30 19:49:57','734','2023-01-31 00:14:32',10,0),('1','195',257877,'Morning','2023-01-31','2023-01-31 15:54:17','2023-02-01 15:54:17','745',6349662.40,6349662.40,'745','2023-01-31 15:58:22','734','2023-01-31 16:05:36',10,0),('1','195',257878,'Afternoon','2023-01-31','2023-01-31 21:26:31','2023-02-01 21:26:31','745',5193694.70,5193694.70,'745','2023-01-31 21:30:40','734','2023-01-31 22:32:47',10,0),('1','195',257879,'Morning','2023-02-01','2023-02-01 15:44:19','2023-02-02 15:44:19','745',7102760.60,7102760.60,'745','2023-02-01 15:50:45','734','2023-02-01 19:33:26',10,0),('1','195',257880,'Afternoon','2023-02-01','2023-02-01 22:06:22','2023-02-02 22:06:22','745',5334955.70,5334955.70,'745','2023-02-01 22:09:47','734','2023-02-01 23:50:38',10,0),('1','195',257881,'Morning','2023-02-02','2023-02-02 16:39:41','2023-02-03 16:39:41','745',2599510.80,2599510.80,'745','2023-02-02 16:40:42','734','2023-02-02 17:22:53',10,0),('1','195',257882,'Afternoon','2023-02-02','2023-02-02 22:10:42','2023-02-03 22:10:42','745',3730561.70,3730561.70,'745','2023-02-02 22:11:39','734','2023-02-03 04:31:31',10,0),('1','195',257883,'Morning','2023-02-03','2023-02-03 15:07:36','2023-02-04 15:07:36','745',3781674.70,3781674.70,'745','2023-02-03 15:08:42','734','2023-02-03 17:10:10',10,0),('1','195',257884,'AFTERNOON SHIFT','2023-02-03','2023-02-03 21:30:41','2023-02-04 21:30:41','745',4316686.40,4316686.40,'745','2023-02-03 21:32:05','734','2023-02-03 23:06:00',10,0),('1','195',257885,'Morning','2023-02-04','2023-02-04 12:59:00','2023-02-05 12:59:00','745',4414843.90,4414843.90,'745','2023-02-04 12:59:51','734','2023-02-04 13:54:39',10,0),('1','195',257886,'AFTERNOON SHIFT','2023-02-04','2023-02-04 21:24:53','2023-02-05 21:24:53','745',5979541.60,5979541.60,'745','2023-02-04 21:26:13','734','2023-02-04 21:35:24',10,0),('1','195',257887,'Morning','2023-02-05','2023-02-05 12:24:22','2023-02-06 12:24:22','745',4158694.30,4158694.30,'745','2023-02-05 12:25:21','734','2023-02-05 13:31:05',10,0),('1','195',257888,'AFTERNOON SHIFT','2023-02-05','2023-02-05 21:24:31','2023-02-06 21:24:31','745',6529800.00,6529800.00,'745','2023-02-05 21:26:39','734','2023-02-05 22:51:22',10,0),('1','195',257889,'MORNING SHIFT','2023-02-06','2023-02-06 13:04:21','2023-02-07 13:04:21','745',2455904.00,2455904.00,'745','2023-02-06 13:33:11','734','2023-02-06 15:22:54',10,0),('1','195',257890,'Afternoon','2023-02-06','2023-02-06 21:05:58','2023-02-07 21:05:58','745',3947288.00,3947288.00,'745','2023-02-06 21:06:54','734','2023-02-06 21:24:48',10,0),('1','195',257891,'Morning','2023-02-07','2023-02-07 15:26:58','2023-02-08 15:26:58','745',2501340.00,2501340.00,'745','2023-02-07 15:31:53','734','2023-02-07 17:07:36',10,0),('1','195',257892,'AFTERNOON SHIFT','2023-02-07','2023-02-07 20:41:10','2023-02-08 20:41:10','745',1711258.00,1711258.00,'745','2023-02-07 20:45:58','734','2023-02-07 21:14:28',10,0),('1','195',257893,'MORNING SHIFT','2023-02-08','2023-02-08 13:05:12','2023-02-09 13:05:12','745',6623512.00,6623512.00,'745','2023-02-08 13:13:05','734','2023-02-08 14:34:02',10,0),('1','195',257894,'Afternoon','2023-02-08','2023-02-08 22:58:19','2023-02-09 22:58:19','745',7572716.00,7572716.00,'745','2023-02-08 23:02:30','734','2023-02-09 07:36:17',10,0),('1','195',257895,'MORNING SHIFT','2023-02-09','2023-02-09 12:57:52','2023-02-10 12:57:52','745',9308920.00,9308920.00,'745','2023-02-09 13:04:50','734','2023-02-09 14:06:53',10,0),('1','195',257896,'AFTERNOON SHIFT','2023-02-09','2023-02-09 21:06:50','2023-02-10 21:06:50','745',10814038.00,10814038.00,'745','2023-02-09 21:13:53','734','2023-02-09 22:05:23',10,0),('1','195',257897,'MORNING SHIFT','2023-02-10','2023-02-10 14:04:48','2023-02-11 14:04:48','745',9206438.00,9206438.00,'745','2023-02-10 14:09:19','734','2023-02-10 15:23:29',10,0),('1','195',257898,'Afternoon','2023-02-10','2023-02-10 22:51:57','2023-02-11 22:51:57','745',3691118.00,3691118.00,'745','2023-02-10 22:56:09','734','2023-02-11 07:26:37',10,0),('1','195',257899,'Morning','2023-02-11','2023-02-11 15:57:06','2023-02-12 15:57:06','745',8977592.00,8977592.00,'745','2023-02-11 15:59:05','734','2023-02-11 21:18:49',10,0),('1','195',257900,'AFTERNOON SHIFT','2023-02-11','2023-02-11 22:19:58','2023-02-12 22:19:58','745',2009000.00,2009000.00,'745','2023-02-11 22:21:50','734','2023-02-11 22:32:13',10,0),('1','195',257901,'Morning','2023-02-12','2023-02-12 13:28:14','2023-02-13 13:28:14','745',4417872.00,4417872.00,'745','2023-02-12 13:29:07','734','2023-02-12 14:03:25',10,0),('1','195',257902,'AFTERNOON SHIFT','2023-02-12','2023-02-12 21:30:35','2023-02-13 21:30:35','745',1833304.00,1833304.00,'745','2023-02-12 21:32:14','734','2023-02-12 21:41:58',10,0),('1','195',257903,'MORNING SHIFT','2023-02-13','2023-02-13 15:01:59','2023-02-14 15:01:59','745',4636808.00,4636808.00,'745','2023-02-13 15:04:14','734','2023-02-13 15:35:10',10,0),('1','195',257904,'AFTERNOON SHIFT','2023-02-13','2023-02-13 18:39:29','2023-02-14 18:39:29','745',4610432.00,4610432.00,'745','2023-02-13 18:40:52','734','2023-02-13 19:19:43',10,0),('1','195',257905,'MORNING SHIFT','2023-02-14','2023-02-14 12:57:11','2023-02-15 12:57:11','745',4183864.00,4183864.00,'745','2023-02-14 13:01:09','734','2023-02-14 15:32:12',10,0),('1','195',257906,'AFTERNOON SHIFT','2023-02-14','2023-02-14 20:26:39','2023-02-15 20:26:39','745',3054968.00,3054968.00,'745','2023-02-14 20:28:03','734','2023-02-14 21:14:57',10,0),('1','195',257907,'Morning','2023-02-15','2023-02-15 13:24:18','2023-02-16 13:24:18','745',1678992.00,1678992.00,'745','2023-02-15 13:25:21','734','2023-02-15 14:37:40',10,0),('1','195',257908,'MORNING SHIFT','2023-02-16','2023-02-16 13:06:25','2023-02-17 13:06:25','745',5564904.00,5564904.00,'745','2023-02-16 13:12:38','734','2023-02-16 15:52:42',10,0),('1','195',257909,'Afternoon','2023-02-16','2023-02-16 20:38:24','2023-02-17 20:38:24','745',1215320.00,1215320.00,'745','2023-02-16 20:39:30','734','2023-02-17 08:21:15',10,0),('1','195',257910,'MORNING SHIFT','2023-02-17','2023-02-17 13:40:37','2023-02-18 13:40:37','745',1890512.00,1890512.00,'745','2023-02-17 13:46:05','734','2023-02-17 15:31:37',10,0),('1','195',257911,'AFTERNOON SHIFT','2023-02-17','2023-02-17 19:19:13','2023-02-18 19:19:13','745',5682412.00,5682412.00,'745','2023-02-17 20:16:50','734','2023-02-17 21:52:18',10,0),('1','195',257912,'Morning','2023-02-18','2023-02-18 15:00:28','2023-02-19 15:00:28','745',6283826.00,6283826.00,'745','2023-02-18 15:08:39','734','2023-02-18 15:28:49',10,0),('1','195',257913,'AFTERNOON SHIFT','2023-02-18','2023-02-18 20:23:02','2023-02-19 20:23:02','745',2917592.00,2917592.00,'745','2023-02-18 20:25:23','734','2023-02-18 21:49:48',10,0),('1','195',257914,'Morning','2023-02-19','2023-02-19 13:51:35','2023-02-20 13:51:35','745',4589042.00,4589042.00,'745','2023-02-19 13:54:56','734','2023-02-19 15:23:57',10,0),('1','195',257915,'AFTERNOON SHIFT','2023-02-19','2023-02-19 20:39:11','2023-02-20 20:39:11','745',3529186.00,3529186.00,'745','2023-02-19 21:37:25','734','2023-02-20 15:51:54',10,0),('1','195',257916,'Morning','2023-02-20','2023-02-20 16:30:00','2023-02-21 16:30:00','745',3510116.00,3510116.00,'745','2023-02-20 16:32:53','734','2023-02-20 17:55:42',10,0),('1','195',257917,'AFTERNOON SHIFT','2023-02-20','2023-02-20 20:51:30','2023-02-21 20:51:30','745',2004704.00,2004704.00,'745','2023-02-20 20:55:16','734','2023-02-20 21:31:39',10,0),('1','195',257918,'Morning','2023-02-21','2023-02-21 14:06:33','2023-02-22 14:06:33','745',2032330.00,2032330.00,'745','2023-02-21 14:09:34','734','2023-02-21 15:39:34',10,0),('1','195',257919,'AFTERNOON SHIFT','2023-02-22','2023-02-22 09:09:15','2023-02-23 09:09:15','745',3350998.00,3350998.00,'745','2023-02-22 09:15:06','734','2023-02-22 14:12:37',10,0),('1','195',257920,'MORNING SHIFT','2023-02-22','2023-02-22 15:50:05','2023-02-23 15:50:05','745',7187904.00,7187904.00,'745','2023-02-22 16:00:54','734','2023-02-22 17:25:48',10,0),('1','195',257921,'Afternoon','2023-02-22','2023-02-22 21:34:38','2023-02-23 21:34:38','745',1385048.00,1385048.00,'745','2023-02-22 21:37:51','734','2023-02-22 22:41:45',10,0),('1','195',257922,'MORNING SHIFT','2023-02-23','2023-02-23 13:44:47','2023-02-24 13:44:47','745',7764428.00,7764428.00,'745','2023-02-23 13:48:58','734','2023-02-23 16:14:44',10,0),('1','195',257923,'AFTERNOON SHIFT','2023-02-23','2023-02-23 19:42:44','2023-02-24 19:42:44','745',3851888.00,3851888.00,'745','2023-02-23 19:45:10','734','2023-02-23 22:05:29',10,0),('1','195',257924,'MORNING SHIFT','2023-02-24','2023-02-24 15:58:11','2023-02-25 15:58:11','745',4575046.00,4575046.00,'745','2023-02-24 16:45:40','734','2023-02-24 18:56:42',10,0),('1','195',257925,'AFTERNOON SHIFT','2023-02-24','2023-02-24 20:34:43','2023-02-25 20:34:43','745',2802590.00,2802590.00,'745','2023-02-24 20:37:41','734','2023-02-24 21:16:30',10,0),('1','195',257926,'MORNING SHIFT','2023-02-27','2023-02-27 13:15:33','2023-02-28 13:15:33','745',4525598.00,4525598.00,'745','2023-02-27 13:28:19','734','2023-02-27 15:54:43',10,0),('1','195',257927,'AFTERNOON SHIFT','2023-02-27','2023-02-27 20:12:14','2023-02-28 20:12:14','745',3882598.00,3882598.00,'745','2023-02-27 20:15:15','734','2023-02-27 20:20:30',10,0),('1','195',257928,'MORNING SHIFT','2023-02-28','2023-02-28 13:20:08','2023-03-01 13:20:08','745',4736084.00,4736084.00,'745','2023-02-28 13:22:48','734','2023-02-28 15:19:33',10,0),('1','195',257929,'AFTERNOON SHIFT','2023-02-28','2023-02-28 21:32:48','2023-03-01 21:32:48','745',5042864.00,5042864.00,'745','2023-02-28 21:35:58','734','2023-02-28 23:36:21',10,0),('1','195',257930,'AFTERNOON SHIFT','2023-03-01','2023-03-01 15:26:09','2023-03-02 15:26:09','745',4846442.00,4846442.00,'745','2023-03-01 19:48:35','734','2023-03-01 20:16:42',10,0),('1','195',257931,'AFTERNOON SHIFT','2023-03-01','2023-03-01 20:50:17','2023-03-02 20:50:17','745',2364404.00,2364404.00,'745','2023-03-01 20:54:14','734','2023-03-01 21:18:02',10,0),('1','195',257932,'MORNING SHIFT','2023-03-02','2023-03-02 14:27:30','2023-03-03 14:27:30','745',4247482.00,4247482.00,'745','2023-03-02 14:30:18','734','2023-03-02 15:22:11',10,0),('1','195',257933,'AFTERNOON SHIFT','2023-03-02','2023-03-02 21:30:51','2023-03-03 21:30:51','745',3800150.00,3800150.00,'745','2023-03-02 21:32:43','734','2023-03-03 07:12:13',10,0),('1','195',257934,'MORNING SHIFT','2023-03-03','2023-03-04 14:38:26','2023-03-05 14:38:26','745',3960418.00,3960418.00,'745','2023-03-04 14:43:42','734','2023-03-04 15:05:50',10,0),('1','195',257935,'AFTERNOON SHIFT','2023-03-03','2023-03-04 15:08:03','2023-03-05 15:08:03','745',1073824.00,1073824.00,'745','2023-03-04 15:10:23','734','2023-03-04 15:11:41',10,0),('1','195',257936,'MORNING SHIFT','2023-03-04','2023-03-04 15:16:02','2023-03-05 15:16:02','745',1218800.00,1218800.00,'745','2023-03-04 15:17:50','734','2023-03-04 17:57:09',10,0),('1','195',257937,'AFTERNOON SHIFT','2023-03-04','2023-03-04 19:17:00','2023-03-05 19:17:00','745',4419304.00,4419304.00,'745','2023-03-04 19:18:58','734','2023-03-04 20:45:43',10,0),('1','195',257938,'Morning','2023-03-05','2023-03-05 22:41:28','2023-03-06 22:41:28','745',3427216.00,3427216.00,'745','2023-03-05 22:48:18','734','2023-03-06 08:54:15',10,0),('1','195',257939,'MORNING SHIFT','2023-03-06','2023-03-06 19:37:43','2023-03-07 19:37:43','745',3704312.00,3704312.00,'745','2023-03-06 19:38:57','734','2023-03-06 20:10:47',10,0),('1','195',257940,'AFTERNOON SHIFT','2023-03-06','2023-03-07 07:43:03','2023-03-08 07:43:03','745',3667840.00,3667840.00,'745','2023-03-07 07:45:06','734','2023-03-07 08:07:23',10,0),('1','195',257941,'AFTERNOON SHIFT','2023-03-08','2023-03-08 20:41:59','2023-03-09 20:41:59','745',507908.00,507908.00,'745','2023-03-08 23:09:11','734','2023-03-09 02:13:28',10,0),('1','195',257942,'MORNING SHIFT','2023-03-09','2023-03-09 12:02:04','2023-03-10 12:02:04','745',4217768.00,4217768.00,'745','2023-03-09 15:46:23','734','2023-03-09 16:01:19',10,0),('1','195',257943,'AFTERNOON SHIFT','2023-03-09','2023-03-09 20:32:38','2023-03-10 20:32:38','745',4251298.00,4251298.00,'745','2023-03-09 20:39:25','734','2023-03-09 23:18:11',10,0),('1','195',257944,'Morning','2023-03-10','2023-03-10 17:23:25','2023-03-11 17:23:25','745',6376702.00,6376702.00,'745','2023-03-10 17:26:51','734','2023-03-10 18:36:51',10,0),('1','195',257945,'AFTERNOON SHIFT','2023-03-10','2023-03-10 21:20:23','2023-03-11 21:20:23','745',3169784.00,3169784.00,'745','2023-03-10 21:25:45','734','2023-03-10 21:51:52',10,0),('1','195',257946,'MORNING SHIFT','2023-03-11','2023-03-11 12:30:27','2023-03-12 12:30:27','745',5802338.00,5802338.00,'745','2023-03-11 12:50:57','734','2023-03-11 15:34:04',10,0),('1','195',257947,'AFTERNOON SHIFT','2023-03-11','2023-03-11 22:04:38','2023-03-12 22:04:38','745',4173854.00,4173854.00,'745','2023-03-11 22:08:35','734','2023-03-12 11:12:03',10,0),('1','195',257948,'Morning','2023-03-12','2023-03-12 14:02:35','2023-03-13 14:02:35','745',2550200.00,2550200.00,'745','2023-03-12 14:07:19','734','2023-03-12 15:10:00',10,0),('1','195',257949,'Afternoon','2023-03-12','2023-03-12 21:51:10','2023-03-13 21:51:10','745',3339760.00,3339760.00,'745','2023-03-12 21:54:28','734','2023-03-12 22:51:04',10,0),('1','195',257950,'Morning','2023-03-13','2023-03-13 14:28:58','2023-03-14 14:28:58','745',4280362.00,4280362.00,'745','2023-03-13 14:42:08','734','2023-03-13 15:22:17',10,0),('1','195',257951,'Afternoon','2023-03-13','2023-03-13 21:19:09','2023-03-14 21:19:09','745',3617452.00,3617452.00,'745','2023-03-13 21:22:01','734','2023-03-13 22:58:18',10,0),('1','195',257952,'MORNING SHIFT','2023-03-14','2023-03-14 15:31:08','2023-03-15 15:31:08','745',4793356.00,4793356.00,'745','2023-03-14 15:36:06','734','2023-03-14 15:43:05',10,0),('1','195',257953,'AFTERNOON SHIFT','2023-03-14','2023-03-14 21:42:46','2023-03-15 21:42:46','745',3599690.00,3599690.00,'745','2023-03-14 21:58:00','734','2023-03-14 22:13:17',10,0),('1','195',257954,'Morning','2023-03-15','2023-03-15 15:56:44','2023-03-16 15:56:44','745',8623068.00,8623068.00,'745','2023-03-15 16:01:11','734','2023-03-15 16:30:25',10,0),('1','195',257955,'AFTERNOON SHIFT','2023-03-15','2023-03-15 21:29:43','2023-03-16 21:29:43','745',3691830.00,3691830.00,'745','2023-03-15 21:32:10','734','2023-03-15 22:02:05',10,0),('1','195',257956,'Morning','2023-03-16','2023-03-16 15:33:50','2023-03-17 15:33:50','745',3695412.00,3695412.00,'745','2023-03-16 15:40:41','734','2023-03-16 17:06:15',10,0),('1','195',257957,'AFTERNOON SHIFT','2023-03-16','2023-03-16 21:27:46','2023-03-17 21:27:46','745',4461696.00,4461696.00,'745','2023-03-16 21:45:38','734','2023-03-17 12:59:16',10,0),('1','195',257958,'Morning','2023-03-17','2023-03-17 15:19:23','2023-03-18 15:19:23','745',4310296.00,4310296.00,'745','2023-03-17 15:27:09','734','2023-03-17 16:19:43',10,0),('1','195',257959,'AFTERNOON SHIFT','2023-03-17','2023-03-17 21:43:53','2023-03-18 21:43:53','745',3226900.00,3226900.00,'745','2023-03-17 21:54:47','734','2023-03-18 08:45:53',10,0),('1','195',257960,'MORNING SHIFT','2023-03-20','2023-03-20 13:41:52','2023-03-21 13:41:52','745',4598834.00,4598834.00,'745','2023-03-20 14:02:13','734','2023-03-20 15:19:41',10,0),('1','195',257961,'AFTERNOON SHIFT','2023-03-20','2023-03-20 22:46:25','2023-03-21 22:46:25','745',4517380.60,4517380.60,'745','2023-03-20 23:18:50','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4913909 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','195','1019','254885',4859289,'3005','465',174314.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859290,'3006','465',269185.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859291,'3007','465',123287.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859292,'3008','465',181238.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859293,'3009','465',85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859294,'3010','465',158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859295,'3011','465',219434.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254885',4859296,'3012','465',73058.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859297,'3013','465',110278.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859298,'3014','465',312047.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859299,'3015','465',113874.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859300,'3016','465',221777.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859301,'3017','465',67517.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859302,'3018','465',180321.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859303,'3019','465',215228.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254885',4859304,'3020','465',107760.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254885',4859305,'3021','466',289643.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254885',4859306,'3022','466',359545.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254885',4859307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254885',4859308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859309,'3005','465',174314.62,175470.66,1156.04,188434.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859310,'3006','465',269185.67,269185.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859311,'3007','465',123287.43,123287.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859312,'3008','465',181238.23,181238.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859313,'3009','465',85078.90,85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859314,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859315,'3011','465',219434.72,220419.28,984.56,160483.28,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254886',4859316,'3012','465',73058.27,73058.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859317,'3013','465',110278.05,110278.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859318,'3014','465',312047.16,313542.35,1495.19,243715.97,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859319,'3015','465',113874.21,113874.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859320,'3016','465',221777.00,222462.71,685.71,111770.73,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859321,'3017','465',67517.98,67517.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859322,'3018','465',180321.89,180321.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859323,'3019','465',215228.22,216451.52,1223.30,199397.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254886',4859324,'3020','465',107760.98,107760.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254886',4859325,'3021','466',289643.35,289643.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254886',4859326,'3022','466',359545.69,359864.15,318.46,105091.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254886',4859327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254886',4859328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860615,'3005','465',175470.66,175470.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860616,'3006','465',269185.67,270856.58,1670.91,272358.33,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860617,'3007','465',123287.43,123287.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860618,'3008','465',181238.23,181479.62,241.39,39346.57,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860619,'3009','465',85078.90,85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860620,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860621,'3011','465',220419.28,220419.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254975',4860622,'3012','465',73058.27,75122.33,2064.06,336441.78,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860623,'3013','465',110278.05,111668.55,1390.50,226651.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860624,'3014','465',313542.35,313542.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860625,'3015','465',113874.21,114643.81,769.60,125444.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860626,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860627,'3017','465',67517.98,67517.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860628,'3018','465',180321.89,180321.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860629,'3019','465',216451.52,216451.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254975',4860630,'3020','465',107760.98,109086.59,1325.61,216074.43,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254975',4860631,'3021','466',289643.35,289811.53,168.18,55499.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254975',4860632,'3022','466',359864.15,362470.99,2606.84,860257.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254975',4860633,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254975',4860634,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860866,'3005','465',175470.66,175470.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860867,'3006','465',270856.58,270856.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860868,'3007','465',123287.43,123287.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860869,'3008','465',181479.62,182297.43,817.81,133303.03,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860870,'3009','465',85078.90,85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860871,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860872,'3011','465',220419.28,221620.78,1201.50,195844.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254993',4860873,'3012','465',75122.33,75122.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860874,'3013','465',111668.55,111668.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860875,'3014','465',313542.35,315297.40,1755.05,286073.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860876,'3015','465',114643.81,116151.83,1508.02,245807.26,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860877,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860878,'3017','465',67517.98,67517.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860879,'3018','465',180321.89,180321.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860880,'3019','465',216451.52,216451.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254993',4860881,'3020','465',109086.59,109654.69,568.10,92600.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254993',4860882,'3021','466',289811.53,290215.63,404.10,133353.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254993',4860883,'3022','466',362470.99,362470.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254993',4860884,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254993',4860885,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860908,'3005','465',175470.66,175470.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860909,'3006','465',270856.58,271421.24,564.66,92039.58,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860910,'3007','465',123287.43,123287.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860911,'3008','465',182297.43,184047.71,1750.28,285295.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860912,'3009','465',85078.90,85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860913,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860914,'3011','465',221620.78,221620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','254996',4860915,'3012','465',75122.33,76488.97,1366.64,222762.32,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860916,'3013','465',111668.55,111750.44,81.89,13348.07,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860917,'3014','465',315297.40,317517.69,2220.29,361907.27,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860918,'3015','465',116151.83,116151.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860919,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860920,'3017','465',67517.98,69361.78,1843.80,300539.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860921,'3018','465',180321.89,180321.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860922,'3019','465',216451.52,216451.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','254996',4860923,'3020','465',109654.69,109654.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254996',4860924,'3021','466',290215.63,290718.98,503.35,166105.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254996',4860925,'3022','466',362470.99,362798.79,327.80,108174.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254996',4860926,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','254996',4860927,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861038,'3005','465',175470.66,175470.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861039,'3006','465',271421.24,272881.63,1460.39,238043.57,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861040,'3007','465',123287.43,123287.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861041,'3008','465',184047.71,185340.83,1293.12,210778.56,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861042,'3009','465',85078.90,85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861043,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861044,'3011','465',221620.78,221620.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255005',4861045,'3012','465',76488.97,77571.70,1082.73,176484.99,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861046,'3013','465',111750.44,111750.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861047,'3014','465',317517.69,319533.52,2015.83,328580.29,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861048,'3015','465',116151.83,117812.67,1660.84,270716.92,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861049,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861050,'3017','465',69361.78,69361.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861051,'3018','465',180321.89,180321.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861052,'3019','465',216451.52,217593.21,1141.69,186095.47,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255005',4861053,'3020','465',109654.69,109654.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255005',4861054,'3021','466',290718.98,291790.40,1071.42,353568.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255005',4861055,'3022','466',362798.79,363935.34,1136.55,375061.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255005',4861056,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255005',4861057,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861367,'3005','465',175470.66,178448.73,2978.07,485425.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861368,'3006','465',272881.63,272881.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861369,'3007','465',123287.43,124869.65,1582.22,257901.86,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861370,'3008','465',185340.83,185340.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861371,'3009','465',85078.90,85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861372,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861373,'3011','465',221620.78,223269.75,1648.97,268782.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255016',4861374,'3012','465',77571.70,77571.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861375,'3013','465',111750.44,113994.98,2244.54,365860.02,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861376,'3014','465',319533.52,319546.74,13.22,2154.86,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861377,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861378,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861379,'3017','465',69361.78,70323.13,961.35,156700.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861380,'3018','465',180321.89,180343.36,21.47,3499.61,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861381,'3019','465',217593.21,217688.27,95.06,15494.78,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255016',4861382,'3020','465',109654.69,111186.63,1531.94,249706.22,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255016',4861383,'3021','466',291790.40,292161.80,371.40,122562.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255016',4861384,'3022','466',363935.34,366878.07,2942.73,971100.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255016',4861385,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255016',4861386,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862481,'3005','465',178448.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862482,'3006','465',272881.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862483,'3007','465',124869.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862484,'3008','465',185340.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862485,'3009','465',85078.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862486,'3010','465',158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862487,'3011','465',223269.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255073',4862488,'3012','465',77571.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862489,'3013','465',113994.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862490,'3014','465',319546.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862491,'3015','465',117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862492,'3016','465',222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862493,'3017','465',70323.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862494,'3018','465',180343.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862495,'3019','465',217688.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255073',4862496,'3020','465',111186.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255073',4862497,'3021','466',292161.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255073',4862498,'3022','466',366878.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255073',4862499,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255073',4862500,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863323,'3005','465',178448.73,178448.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863324,'3006','465',272881.63,275194.07,2312.44,376927.72,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863325,'3007','465',124869.65,126442.79,1573.14,256421.82,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863326,'3008','465',185340.83,186761.29,1420.46,231534.98,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863327,'3009','465',85413.14,87937.45,2524.31,411462.53,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863328,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863329,'3011','465',223269.75,225027.07,1757.32,286443.16,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255120',4863330,'3012','465',77571.70,78649.82,1078.12,175733.56,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863331,'3013','465',113994.98,113994.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863332,'3014','465',319546.74,319618.32,71.58,11667.54,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863333,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863334,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863335,'3017','465',70323.13,70323.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863336,'3018','465',180343.36,180343.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863337,'3019','465',217688.27,217688.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255120',4863338,'3020','465',111186.63,111194.61,7.98,1300.74,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255120',4863339,'3021','466',292161.80,293222.90,1061.10,350163.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255120',4863340,'3022','466',366878.07,369055.96,2177.89,718703.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255120',4863341,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255120',4863342,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863380,'3005','465',178448.73,178559.45,110.72,18047.36,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863381,'3006','465',275194.07,277976.32,2782.25,453506.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863382,'3007','465',126442.79,130353.69,3910.90,637476.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863383,'3008','465',186761.29,186869.57,108.28,17649.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863384,'3009','465',87937.45,91227.21,3289.76,536230.88,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863385,'3010','465',158278.14,158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863386,'3011','465',225027.07,225677.41,650.34,106005.42,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255124',4863387,'3012','465',78649.82,80557.34,1887.52,307665.76,0.00,0.00,20.00,0.00,0.00),('1','195','1020','255124',4863388,'3013','465',113994.98,113994.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863389,'3014','465',319618.32,319618.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863390,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863391,'3016','465',222462.71,222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863392,'3017','465',70323.13,70323.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863393,'3018','465',180343.36,180343.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863394,'3019','465',217688.27,217688.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255124',4863395,'3020','465',111194.61,111194.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255124',4863396,'3021','466',293222.90,294295.35,1072.45,353908.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255124',4863397,'3022','466',369055.96,370204.60,1148.64,379051.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255124',4863398,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255124',4863399,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863508,'3005','465',178559.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863509,'3006','465',277976.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863510,'3007','465',130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863511,'3008','465',186869.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863512,'3009','465',91227.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863513,'3010','465',158278.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863514,'3011','465',225677.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255132',4863515,'3012','465',80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863516,'3013','465',113994.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863517,'3014','465',319618.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863518,'3015','465',117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863519,'3016','465',222462.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863520,'3017','465',70323.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863521,'3018','465',180343.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863522,'3019','465',217688.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255132',4863523,'3020','465',111194.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255132',4863524,'3021','466',294295.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255132',4863525,'3022','466',370204.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255132',4863526,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255132',4863527,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866981,'3005','465',178559.45,179447.88,868.43,141554.09,0.00,0.00,20.00,0.00,0.00),('1','195','1019','255328',4866982,'3006','465',277976.32,278767.32,791.00,128933.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866983,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866984,'3008','465',186869.57,187874.11,1004.54,163740.02,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866985,'3009','465',91227.21,91972.77,745.56,121526.28,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866986,'3010','465',158278.14,159013.18,735.04,119811.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866987,'3011','465',225677.41,226300.71,623.30,101597.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255328',4866988,'3012','465',80557.34,80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866989,'3013','465',113994.98,114538.78,543.80,88639.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866990,'3014','465',319618.32,321025.96,1407.64,229445.32,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866991,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866992,'3016','465',224374.96,225468.52,1093.56,178250.28,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866993,'3017','465',70323.13,71293.13,970.00,158110.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866994,'3018','465',180343.36,181343.74,1000.38,163061.94,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866995,'3019','465',217688.27,218549.01,860.74,140300.62,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255328',4866996,'3020','465',111194.61,111194.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255328',4866997,'3021','466',294295.35,296082.19,1786.84,589657.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255328',4866998,'3022','466',370204.60,372046.67,1842.07,607883.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255328',4866999,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255328',4867000,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867678,'3005','465',179447.88,179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867679,'3006','465',278767.32,278767.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867680,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867681,'3008','465',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867682,'3009','465',91972.77,91972.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867683,'3010','465',159013.18,159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867684,'3011','465',226300.71,226300.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255367',4867685,'3012','465',80557.34,80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867686,'3013','465',114538.78,114538.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867687,'3014','465',321025.96,323943.79,2917.83,475606.29,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867688,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867689,'3016','465',225468.52,228527.07,3058.55,498543.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867690,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867691,'3018','465',181343.74,184465.00,3121.26,508765.38,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867692,'3019','465',218549.01,218549.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255367',4867693,'3020','465',111194.61,114417.04,3222.43,525256.09,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255367',4867694,'3021','466',296082.19,298905.76,2823.57,931778.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255367',4867695,'3022','466',372046.67,375279.00,3232.33,1066668.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255367',4867696,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255367',4867697,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867771,'3005','465',179447.88,179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867772,'3006','465',278767.32,278767.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867773,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867774,'3008','465',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867775,'3009','465',91972.77,91972.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867776,'3010','465',159013.18,159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867777,'3011','465',226300.71,226300.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255375',4867778,'3012','465',80557.34,80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867779,'3013','465',114538.78,116120.22,1581.44,257774.72,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867780,'3014','465',323943.79,325684.21,1740.42,283688.46,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867781,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867782,'3016','465',228527.07,230479.49,1952.42,318244.46,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867783,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867784,'3018','465',184465.00,185571.19,1106.19,180308.97,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867785,'3019','465',218549.01,220211.24,1662.23,270943.49,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255375',4867786,'3020','465',114417.04,114417.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255375',4867787,'3021','466',298905.76,301479.69,2573.93,849396.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255375',4867788,'3022','466',375279.00,378943.77,3664.77,1209374.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255375',4867789,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255375',4867790,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867817,'3005','465',179447.88,179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867818,'3006','465',278767.32,280682.54,1915.22,312180.86,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867819,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867820,'3008','465',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867821,'3009','465',91972.77,91972.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867822,'3010','465',159013.18,159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867823,'3011','465',226300.71,228719.50,2418.79,394262.77,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255377',4867824,'3012','465',80557.34,80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867825,'3013','465',116120.22,118411.57,2291.35,373490.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867826,'3014','465',325684.21,325684.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867827,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867828,'3016','465',230479.49,230479.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867829,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867830,'3018','465',185571.19,185571.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867831,'3019','465',220211.24,220211.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255377',4867832,'3020','465',114417.04,117612.52,3195.48,520863.24,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255377',4867833,'3021','466',301479.69,301844.05,364.36,120238.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255377',4867834,'3022','466',378943.77,381936.62,2992.85,987640.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255377',4867835,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255377',4867836,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867929,'3005','465',179447.88,179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867930,'3006','465',280682.54,282598.89,1916.35,312365.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867931,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867932,'3008','465',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867933,'3009','465',91972.77,91972.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867934,'3010','465',159013.18,159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867935,'3011','465',228719.50,230172.29,1452.79,236804.77,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255382',4867936,'3012','465',80557.34,80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867937,'3013','465',118411.57,118411.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867938,'3014','465',325684.21,327479.80,1795.59,292681.17,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867939,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867940,'3016','465',230479.49,231785.10,1305.61,212814.43,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867941,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867942,'3018','465',185571.19,185571.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867943,'3019','465',220211.24,220211.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255382',4867944,'3020','465',117612.52,119139.49,1526.97,248896.11,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255382',4867945,'3021','466',301844.05,302677.02,832.97,274880.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255382',4867946,'3022','466',381936.62,382261.56,324.94,107230.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255382',4867947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255382',4867948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867951,'3005','465',179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867952,'3006','465',282598.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867953,'3007','465',130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867954,'3008','465',187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867955,'3009','465',91972.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867956,'3010','465',159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867957,'3011','465',230172.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255384',4867958,'3012','465',80557.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867959,'3013','465',118411.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867960,'3014','465',327479.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867961,'3015','465',117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867962,'3016','465',231785.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867963,'3017','465',71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867964,'3018','465',185571.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867965,'3019','465',220211.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255384',4867966,'3020','465',119139.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255384',4867967,'3021','466',302677.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255384',4867968,'3022','466',382261.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255384',4867969,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255384',4867970,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868106,'3005','465',179447.88,179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868107,'3006','465',282598.89,284006.02,1407.13,229362.19,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868108,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868109,'3008','465',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868110,'3009','465',91972.77,91972.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868111,'3010','465',159013.18,159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868112,'3011','465',230172.29,230172.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255394',4868113,'3012','465',80557.34,83523.23,2965.89,483440.07,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868114,'3013','465',118411.57,120903.27,2491.70,406147.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868115,'3014','465',327479.80,327479.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868116,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868117,'3016','465',231785.10,231885.09,99.99,16298.37,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868118,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868119,'3018','465',185571.19,186646.99,1075.80,175355.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868120,'3019','465',220211.24,220211.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255394',4868121,'3020','465',119139.49,120756.89,1617.40,263636.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255394',4868122,'3021','466',302677.02,304359.37,1682.35,555175.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255394',4868123,'3022','466',382867.56,384902.27,2034.71,671454.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255394',4868124,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255394',4868125,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868548,'3005','465',179447.88,179447.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868549,'3006','465',284006.02,285827.07,1821.05,296831.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868550,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868551,'3008','465',187874.11,187874.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868552,'3009','465',91972.77,93446.06,1473.29,240146.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868553,'3010','465',159013.18,159013.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868554,'3011','465',230172.29,230172.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255413',4868555,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868556,'3013','465',120903.27,120903.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868557,'3014','465',327479.80,329223.08,1743.28,284154.64,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868558,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868559,'3016','465',231885.09,233570.53,1685.44,274726.72,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868560,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868561,'3018','465',186646.99,188776.57,2129.58,347121.54,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868562,'3019','465',220211.24,220211.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255413',4868563,'3020','465',120756.89,120756.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255413',4868564,'3021','466',304359.37,305136.62,777.25,256492.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255413',4868565,'3022','466',384902.27,388477.30,3575.03,1179759.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255413',4868566,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255413',4868567,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871063,'3005','465',179447.88,182522.76,3074.88,501205.44,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871064,'3006','465',285827.07,286945.42,1118.35,182291.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871065,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871066,'3008','465',187874.11,189361.16,1487.05,242389.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871067,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871068,'3010','465',159013.18,160310.93,1297.75,211533.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871069,'3011','465',230172.29,231669.66,1497.37,244071.31,0.00,0.00,0.00,0.00,0.00),('1','195','1019','255588',4871070,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871071,'3013','465',120903.27,120903.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871072,'3014','465',329223.08,330567.04,1343.96,219065.48,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871073,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871074,'3016','465',233570.53,233964.08,393.55,64148.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871075,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871076,'3018','465',188776.57,188776.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871077,'3019','465',220211.24,221312.85,1101.61,179562.43,0.00,0.00,0.00,0.00,0.00),('1','195','1020','255588',4871078,'3020','465',120756.89,120756.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255588',4871079,'3021','466',305136.62,306658.16,1521.54,502108.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255588',4871080,'3022','466',388477.30,389601.92,1124.62,371124.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255588',4871081,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','255588',4871082,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886286,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886287,'3006','465',286945.42,288509.24,1563.82,254902.66,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886288,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886289,'3008','465',189361.16,189361.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886290,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886291,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886292,'3011','465',231669.66,232929.12,1259.46,205291.98,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256506',4886293,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886294,'3013','465',120903.27,120903.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886295,'3014','465',330567.04,332393.89,1826.85,297776.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886296,'3015','465',117812.67,117812.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886297,'3016','465',233964.08,235592.92,1628.84,265500.92,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886298,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886299,'3018','465',188776.57,188776.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886300,'3019','465',221312.85,221312.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256506',4886301,'3020','465',120756.89,122114.84,1357.95,221345.85,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256506',4886302,'3021','466',306658.16,306739.67,81.51,26898.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256506',4886303,'3022','466',389601.92,391386.62,1784.70,588951.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256506',4886304,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256506',4886305,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888865,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888866,'3006','465',288509.24,288509.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888867,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888868,'3008','465',189361.16,190286.31,925.15,150799.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888869,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888870,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888871,'3011','465',232929.12,235164.84,2235.72,364422.36,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256650',4888872,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888873,'3013','465',120903.27,123758.03,2854.76,465325.88,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888874,'3014','465',332393.89,332393.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888875,'3015','465',117812.67,119980.20,2167.53,353307.39,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888876,'3016','465',235592.92,235592.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888877,'3017','465',71293.13,71293.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888878,'3018','465',188776.57,188776.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888879,'3019','465',221312.85,221898.76,585.91,95503.33,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256650',4888880,'3020','465',122114.84,122114.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256650',4888881,'3021','466',306739.67,307689.95,950.28,313592.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256650',4888882,'3022','466',391386.62,391909.65,523.03,172599.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256650',4888883,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256650',4888884,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891984,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891985,'3006','465',288509.24,291126.54,2617.30,426619.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891986,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891987,'3008','465',190286.31,191450.09,1163.78,189696.14,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891988,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891989,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891990,'3011','465',235164.84,236294.50,1129.66,184134.58,0.00,0.00,0.00,0.00,0.00),('1','195','1019','256841',4891991,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891992,'3013','465',123758.03,125807.35,2049.32,334039.16,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891993,'3014','465',332393.89,332393.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891994,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891995,'3016','465',235592.92,236006.00,413.08,67332.04,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891996,'3017','465',71293.13,73534.03,2240.90,365266.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891997,'3018','465',188776.57,188776.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891998,'3019','465',221898.76,221898.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','256841',4891999,'3020','465',122114.84,122114.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256841',4892000,'3021','466',307689.95,307808.76,118.81,39207.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256841',4892001,'3022','466',391909.65,394268.88,2359.23,778545.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256841',4892002,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','256841',4892003,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897289,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897290,'3006','465',291126.54,293702.61,2576.07,419899.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897291,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897292,'3008','465',191450.09,191450.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897293,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897294,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897295,'3011','465',236294.50,238804.90,2510.40,409195.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257131',4897296,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897297,'3013','465',125807.35,125807.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897298,'3014','465',332393.89,334271.14,1877.25,305991.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897299,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897300,'3016','465',236006.00,238250.88,2244.88,365915.44,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897301,'3017','465',73534.03,73534.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897302,'3018','465',188776.57,190702.91,1926.34,313993.42,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897303,'3019','465',221898.76,221898.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257131',4897304,'3020','465',122114.84,122114.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257131',4897305,'3021','466',307808.76,309075.39,1266.63,417987.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257131',4897306,'3022','466',394268.88,396012.09,1743.21,575259.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257131',4897307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257131',4897308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897309,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897310,'3006','465',293702.61,295067.55,1364.94,222485.22,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897311,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897312,'3008','465',191450.09,192855.85,1405.76,229138.88,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897313,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897314,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897315,'3011','465',238804.90,239897.75,1092.85,178134.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257132',4897316,'3012','465',83523.23,83523.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897317,'3013','465',125807.35,125807.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897318,'3014','465',334271.14,335981.31,1710.17,278757.71,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897319,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897320,'3016','465',238250.88,240057.59,1806.71,294493.73,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897321,'3017','465',73534.03,73534.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897322,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897323,'3019','465',221898.76,221898.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257132',4897324,'3020','465',122114.84,122797.21,682.37,111226.31,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257132',4897325,'3021','466',309075.39,311033.95,1958.56,646324.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257132',4897326,'3022','466',396012.09,399026.35,3014.26,994705.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257132',4897327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257132',4897328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897329,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897330,'3006','465',295067.55,297018.24,1950.69,317962.47,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897331,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897332,'3008','465',192855.85,192855.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897333,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897334,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897335,'3011','465',239897.75,239897.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257133',4897336,'3012','465',83523.23,85395.86,1872.63,305238.69,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897337,'3013','465',125807.35,125807.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897338,'3014','465',335981.31,338698.91,2717.60,442968.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897339,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897340,'3016','465',240057.59,240057.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897341,'3017','465',73534.03,75708.78,2174.75,354484.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897342,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897343,'3019','465',221898.76,223747.19,1848.43,301294.09,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257133',4897344,'3020','465',122797.21,122797.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257133',4897345,'3021','466',311033.95,311294.72,260.77,86054.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257133',4897346,'3022','466',399026.35,401863.30,2836.95,936193.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257133',4897347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257133',4897348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897349,'3005','465',182522.76,182522.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897350,'3006','465',297018.24,298445.00,1426.76,232561.88,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897351,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897352,'3008','465',192855.85,194870.48,2014.63,328384.69,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897353,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897354,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897355,'3011','465',239897.75,240877.91,980.16,159766.08,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257134',4897356,'3012','465',85395.86,85395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897357,'3013','465',125807.35,125807.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897358,'3014','465',338698.91,339888.36,1189.45,193880.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897359,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897360,'3016','465',240057.59,241701.17,1643.58,267903.54,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897361,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897362,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897363,'3019','465',223747.19,223747.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257134',4897364,'3020','465',122797.21,123872.04,1074.83,175197.29,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257134',4897365,'3021','466',311294.72,312744.27,1449.55,478351.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257134',4897366,'3022','466',401863.30,403928.70,2065.40,681582.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257134',4897367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257134',4897368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897369,'3005','465',182522.76,184644.15,2121.39,345786.57,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897370,'3006','465',298445.00,298445.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897371,'3007','465',130353.69,130353.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897372,'3008','465',194870.48,196481.35,1610.87,262571.81,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897373,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897374,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897375,'3011','465',240877.91,242538.67,1660.76,270703.88,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257135',4897376,'3012','465',85395.86,85395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897377,'3013','465',125807.35,127602.21,1794.86,292562.18,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897378,'3014','465',339888.36,339888.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897379,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897380,'3016','465',241701.17,242817.27,1116.10,181924.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897381,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897382,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897383,'3019','465',223747.19,225086.00,1338.81,218226.03,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257135',4897384,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257135',4897385,'3021','466',312744.27,314614.27,1870.00,617100.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257135',4897386,'3022','466',403928.70,405976.55,2047.85,675790.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257135',4897387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257135',4897388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897389,'3005','465',184644.15,184669.50,25.35,4132.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897390,'3006','465',298445.00,299323.68,878.68,143224.84,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897391,'3007','465',130353.69,130462.26,108.57,17696.91,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897392,'3008','465',196481.35,197586.94,1105.59,180211.17,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897393,'3009','465',93446.06,93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897394,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897395,'3011','465',242538.67,242538.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257136',4897396,'3012','465',85395.86,85395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897397,'3013','465',127602.21,128977.32,1375.11,224142.93,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897398,'3014','465',339888.36,340391.93,503.57,82081.91,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897399,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897400,'3016','465',242817.27,244459.83,1642.56,267737.28,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897401,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897402,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897403,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257136',4897404,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257136',4897405,'3021','466',314614.27,315155.48,541.21,178599.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257136',4897406,'3022','466',405976.55,407216.67,1240.12,409239.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257136',4897407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257136',4897408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897409,'3005','465',184669.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897410,'3006','465',299323.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897411,'3007','465',130462.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897412,'3008','465',197586.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897413,'3009','465',93446.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897414,'3010','465',160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897415,'3011','465',242538.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257137',4897416,'3012','465',85395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897417,'3013','465',128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897418,'3014','465',340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897419,'3015','465',119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897420,'3016','465',244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897421,'3017','465',75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897422,'3018','465',190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897423,'3019','465',225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257137',4897424,'3020','465',123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257137',4897425,'3021','466',315155.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257137',4897426,'3022','466',407216.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257137',4897427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257137',4897428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897429,'3005','465',184669.50,187176.20,2506.70,408592.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897430,'3006','465',299323.68,299323.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897431,'3007','465',130462.26,132769.88,2307.62,376142.06,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897432,'3008','465',197586.94,198908.41,1321.47,215399.61,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897433,'3009','465',93585.67,95676.71,2091.04,340839.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897434,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897435,'3011','465',242538.67,245967.98,3429.31,558977.53,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257138',4897436,'3012','465',85395.86,85395.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897437,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897438,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897439,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897440,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897441,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897442,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897443,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257138',4897444,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257138',4897445,'3021','466',315155.48,316320.61,1165.13,384492.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257138',4897446,'3022','466',407216.67,410571.30,3354.63,1107027.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257138',4897447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257138',4897448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897449,'3005','465',187176.20,187654.34,478.14,77936.82,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897450,'3006','465',299323.68,301088.85,1765.17,287722.71,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897451,'3007','465',132769.88,134415.70,1645.82,268268.66,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897452,'3008','465',198908.41,199591.06,682.65,111271.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897453,'3009','465',95676.71,97213.32,1536.61,250467.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897454,'3010','465',160310.93,160310.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897455,'3011','465',245967.98,247590.55,1622.57,264478.91,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257139',4897456,'3012','465',85395.86,86007.77,611.91,99741.33,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897457,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897458,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897459,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897460,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897461,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897462,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897463,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257139',4897464,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257139',4897465,'3021','466',316320.61,318126.97,1806.36,596098.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257139',4897466,'3022','466',410571.30,412453.79,1882.49,621221.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257139',4897467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257139',4897468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897469,'3005','465',187654.34,189164.03,1509.69,246079.47,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897470,'3006','465',301088.85,303328.75,2239.90,365103.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897471,'3007','465',134415.70,137050.54,2634.84,429478.92,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897472,'3008','465',199591.06,199890.10,299.04,48743.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897473,'3009','465',97213.32,97213.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897474,'3010','465',160310.93,162286.65,1975.72,322042.36,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897475,'3011','465',247590.55,249942.51,2351.96,383369.48,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257140',4897476,'3012','465',86007.77,86007.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897477,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897478,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897479,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897480,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897481,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897482,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897483,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257140',4897484,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257140',4897485,'3021','466',318126.97,319189.40,1062.43,350601.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257140',4897486,'3022','466',412453.79,413356.27,902.48,297818.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257140',4897487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257140',4897488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897489,'3005','465',189164.03,190552.33,1388.30,226292.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897490,'3006','465',303328.75,304653.35,1324.60,215909.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897491,'3007','465',137050.54,137050.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897492,'3008','465',199890.10,201882.66,1992.56,324787.28,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897493,'3009','465',97213.32,98027.43,814.11,132699.93,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897494,'3010','465',162286.65,163043.72,757.07,123402.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897495,'3011','465',249942.51,250935.50,992.99,161857.37,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257141',4897496,'3012','465',86007.77,86534.53,526.76,85861.88,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897497,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897498,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897499,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897500,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897501,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897502,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897503,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257141',4897504,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257141',4897505,'3021','466',319189.40,321173.84,1984.44,654865.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257141',4897506,'3022','466',413356.27,417147.48,3791.21,1251099.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257141',4897507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257141',4897508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897509,'3005','465',190552.33,190552.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897510,'3006','465',304653.35,307353.74,2700.39,440163.57,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897511,'3007','465',137050.54,137050.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897512,'3008','465',201882.66,204300.13,2417.47,394047.61,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897513,'3009','465',98027.43,98027.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897514,'3010','465',163043.72,165695.63,2651.91,432261.33,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897515,'3011','465',250935.50,250935.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257142',4897516,'3012','465',86534.53,88289.28,1754.75,286024.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897517,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897518,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897519,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897520,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897521,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897522,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897523,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257142',4897524,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257142',4897525,'3021','466',321173.84,324698.26,3524.42,1163058.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257142',4897526,'3022','466',417147.48,420484.07,3336.59,1101074.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257142',4897527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257142',4897528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897529,'3005','465',190552.33,192475.95,1923.62,313550.06,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897530,'3006','465',307353.74,307999.08,645.34,105190.42,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897531,'3007','465',137050.54,137050.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897532,'3008','465',204300.13,205109.16,809.03,131871.89,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897533,'3009','465',98027.43,99001.39,973.96,158755.48,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897534,'3010','465',165695.63,166787.78,1092.15,178020.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897535,'3011','465',250935.50,251970.71,1035.21,168739.23,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257143',4897536,'3012','465',88289.28,88289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897537,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897538,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897539,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897540,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897541,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897542,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897543,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257143',4897544,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257143',4897545,'3021','466',324698.26,326997.37,2299.11,758706.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257143',4897546,'3022','466',420484.07,422258.28,1774.21,585489.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257143',4897547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257143',4897548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897549,'3005','465',192475.95,193809.49,1333.54,217367.02,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897550,'3006','465',307999.08,309866.97,1867.89,304466.07,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897551,'3007','465',137050.54,137050.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897552,'3008','465',205109.16,206738.43,1629.27,265571.01,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897553,'3009','465',99001.39,100314.40,1313.01,214020.63,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897554,'3010','465',166787.78,168062.78,1275.00,207825.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897555,'3011','465',251970.71,253447.36,1476.65,240693.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257144',4897556,'3012','465',88289.28,88289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897557,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897558,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897559,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897560,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897561,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897562,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897563,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257144',4897564,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257144',4897565,'3021','466',326997.37,331208.96,4211.59,1389824.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257144',4897566,'3022','466',422258.28,423153.36,895.08,295376.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257144',4897567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257144',4897568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897569,'3005','465',193809.49,194938.57,1129.08,184040.04,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897570,'3006','465',309866.97,311674.72,1807.75,294663.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897571,'3007','465',137050.54,137053.61,3.07,500.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897572,'3008','465',206738.43,208693.92,1955.49,318744.87,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897573,'3009','465',100314.40,102066.43,1752.03,285580.89,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897574,'3010','465',168062.78,168062.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897575,'3011','465',253447.36,255166.06,1718.70,280148.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257145',4897576,'3012','465',88289.28,88289.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897577,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897578,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897579,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897580,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897581,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897582,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897583,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257145',4897584,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257145',4897585,'3021','466',331208.96,335232.58,4023.62,1327794.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257145',4897586,'3022','466',423153.36,425727.58,2574.22,849492.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257145',4897587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257145',4897588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897589,'3005','465',194938.57,195476.61,538.04,87700.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897590,'3006','465',311674.72,313327.42,1652.70,269390.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897591,'3007','465',137053.61,138037.44,983.83,160364.29,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897592,'3008','465',208693.92,208829.35,135.43,22075.09,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897593,'3009','465',102066.43,102066.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897594,'3010','465',168062.78,169625.42,1562.64,254710.32,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897595,'3011','465',255166.06,265444.49,10278.43,1675384.09,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257146',4897596,'3012','465',88289.28,88464.08,174.80,28492.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897597,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897598,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897599,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897600,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897601,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897602,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897603,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257146',4897604,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257146',4897605,'3021','466',335232.58,335920.63,688.05,227056.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257146',4897606,'3022','466',425727.58,425833.58,106.00,34980.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257146',4897607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257146',4897608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897609,'3005','465',195476.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897610,'3006','465',313327.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897611,'3007','465',138037.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897612,'3008','465',208829.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897613,'3009','465',102066.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897614,'3010','465',169625.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897615,'3011','465',265444.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257147',4897616,'3012','465',88464.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897617,'3013','465',128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897618,'3014','465',340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897619,'3015','465',119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897620,'3016','465',244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897621,'3017','465',75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897622,'3018','465',190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897623,'3019','465',225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257147',4897624,'3020','465',123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257147',4897625,'3021','466',335920.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257147',4897626,'3022','466',425833.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257147',4897627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257147',4897628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897629,'3005','465',195476.61,195476.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897630,'3006','465',313327.42,315564.36,2236.94,364621.22,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897631,'3007','465',138037.44,138037.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897632,'3008','465',208829.35,210823.32,1993.97,325017.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897633,'3009','465',102066.43,102066.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897634,'3010','465',169625.42,170989.16,1363.74,222289.62,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897635,'3011','465',256444.49,257966.53,1522.04,248092.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257148',4897636,'3012','465',88464.08,88805.78,341.70,55697.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897637,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897638,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897639,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897640,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897641,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897642,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897643,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257148',4897644,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257148',4897645,'3021','466',335920.63,336470.01,549.38,189536.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257148',4897646,'3022','466',425833.58,426864.96,1031.38,355826.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257148',4897647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257148',4897648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897649,'3005','465',195476.61,195476.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897650,'3006','465',315564.36,318459.49,2895.13,471906.19,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897651,'3007','465',138037.44,141109.12,3071.68,500683.84,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897652,'3008','465',210823.32,210823.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897653,'3009','465',102066.43,102066.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897654,'3010','465',170989.16,172400.94,1411.78,230120.14,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897655,'3011','465',257966.53,259806.66,1840.13,299941.19,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257149',4897656,'3012','465',88805.78,90232.85,1427.07,232612.41,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897657,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897658,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897659,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897660,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897661,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897662,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897663,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257149',4897664,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257149',4897665,'3021','466',336470.01,338420.43,1950.42,672894.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257149',4897666,'3022','466',426864.96,429398.16,2533.20,873954.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257149',4897667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257149',4897668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897669,'3005','465',195476.61,197546.68,2070.07,337421.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897670,'3006','465',318459.49,318459.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897671,'3007','465',141109.12,142485.82,1376.70,224402.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897672,'3008','465',210823.32,212165.30,1341.98,218742.74,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897673,'3009','465',102066.43,103825.44,1759.01,286718.63,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897674,'3010','465',172400.94,172400.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897675,'3011','465',259806.66,260791.96,985.30,160603.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257150',4897676,'3012','465',90232.85,91310.82,1077.97,175709.11,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897677,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897678,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897679,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897680,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897681,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897682,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897683,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257150',4897684,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257150',4897685,'3021','466',338420.43,338539.13,118.70,40951.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257150',4897686,'3022','466',429398.16,431368.78,1970.62,679863.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257150',4897687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257150',4897688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897689,'3005','465',197546.68,198720.64,1173.96,191355.48,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897690,'3006','465',318459.49,320368.01,1908.52,311088.76,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897691,'3007','465',142485.82,144210.10,1724.28,281057.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897692,'3008','465',212165.30,214600.41,2435.11,396922.93,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897693,'3009','465',103825.44,103825.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897694,'3010','465',172400.94,175090.98,2690.04,438476.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897695,'3011','465',260791.96,261950.78,1158.82,188887.66,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257151',4897696,'3012','465',91310.82,91408.96,98.14,15996.82,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897697,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897698,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897699,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897700,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897701,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897702,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897703,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257151',4897704,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257151',4897705,'3021','466',338539.13,341016.68,2477.55,854754.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257151',4897706,'3022','466',431368.78,433723.81,2355.03,812485.35,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257151',4897707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257151',4897708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897709,'3005','465',198720.64,198720.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897710,'3006','465',320368.01,322523.02,2155.01,351266.63,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897711,'3007','465',144210.10,146308.93,2098.83,342109.29,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897712,'3008','465',214600.41,215792.09,1181.46,192577.98,0.00,0.00,10.22,0.00,0.00),('1','195','1019','257152',4897713,'3009','465',103825.44,104813.68,988.24,161083.12,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897714,'3010','465',175090.98,176577.63,1486.65,242323.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897715,'3011','465',261950.78,263357.07,1406.29,229225.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257152',4897716,'3012','465',91408.96,91408.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897717,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897718,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897719,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897720,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897721,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897722,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897723,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257152',4897724,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257152',4897725,'3021','466',341016.68,341853.16,836.48,288585.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257152',4897726,'3022','466',433723.81,436106.27,2382.46,821948.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257152',4897727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257152',4897728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897729,'3005','465',198720.64,198720.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897730,'3006','465',322523.02,325206.56,2683.54,437417.02,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897731,'3007','465',146308.93,146308.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897732,'3008','465',215792.09,217634.37,1842.28,300291.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897733,'3009','465',104813.68,106421.08,1607.40,262006.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897734,'3010','465',176577.63,177178.65,601.02,97966.26,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897735,'3011','465',263357.07,265588.07,2231.00,363653.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257153',4897736,'3012','465',91408.96,91408.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897737,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897738,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897739,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897740,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897741,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897742,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897743,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257153',4897744,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257153',4897745,'3021','466',341853.16,345384.76,3531.60,1218402.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257153',4897746,'3022','466',436106.27,436422.87,316.60,109227.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257153',4897747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257153',4897748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897749,'3005','465',198720.64,199604.25,883.61,144028.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897750,'3006','465',325206.56,325943.50,736.94,120121.22,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897751,'3007','465',146308.93,146308.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897752,'3008','465',217634.37,218161.56,527.19,85931.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897753,'3009','465',106421.08,107246.33,825.25,134515.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897754,'3010','465',177178.65,177444.95,266.30,43406.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897755,'3011','465',265588.07,266434.77,846.70,138012.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257154',4897756,'3012','465',91408.96,91408.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897757,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897758,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897759,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897760,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897761,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897762,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897763,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257154',4897764,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257154',4897765,'3021','466',345384.76,347349.08,1964.32,687512.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257154',4897766,'3022','466',436422.87,438014.18,1591.31,556958.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257154',4897767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257154',4897768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897769,'3005','465',199604.25,199604.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897770,'3006','465',325943.50,325943.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897771,'3007','465',146308.93,146308.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897772,'3008','465',218161.56,218161.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897773,'3009','465',107246.33,107246.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897774,'3010','465',177444.95,177444.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897775,'3011','465',266434.77,266434.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257155',4897776,'3012','465',91408.96,91408.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897777,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897778,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897779,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897780,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897781,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897782,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897783,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257155',4897784,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257155',4897785,'3021','466',347349.08,349015.41,1666.33,583215.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257155',4897786,'3022','466',438014.18,439114.09,1099.91,384968.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257155',4897787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257155',4897788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897789,'3005','465',199604.25,200837.81,1233.56,201070.28,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897790,'3006','465',325943.50,327698.44,1754.94,286055.22,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897791,'3007','465',146308.93,147538.18,1229.25,200367.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897792,'3008','465',218161.56,218161.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897793,'3009','465',107246.33,107246.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897794,'3010','465',177444.95,179173.75,1728.80,281794.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897795,'3011','465',266434.77,267635.05,1200.28,195645.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257156',4897796,'3012','465',91408.96,92293.06,884.10,144108.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897797,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897798,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897799,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897800,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897801,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897802,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897803,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257156',4897804,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257156',4897805,'3021','466',349015.41,352226.06,3210.65,1123727.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257156',4897806,'3022','466',439114.09,441810.62,2696.53,943785.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257156',4897807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257156',4897808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897809,'3005','465',200837.81,203822.97,2985.16,486581.08,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897810,'3006','465',327698.44,327698.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897811,'3007','465',147538.18,149067.76,1529.58,249321.54,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897812,'3008','465',218161.56,220525.59,2364.03,385336.89,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897813,'3009','465',107246.33,107252.46,6.13,999.19,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897814,'3010','465',179173.75,181090.33,1916.58,312402.54,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897815,'3011','465',267635.05,269127.17,1492.12,243215.56,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257157',4897816,'3012','465',92293.06,92362.99,69.93,11398.59,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897817,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897818,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897819,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897820,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897821,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897822,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897823,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257157',4897824,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257157',4897825,'3021','466',352226.06,354212.85,1986.79,695376.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257157',4897826,'3022','466',441810.62,445239.88,3429.26,1200241.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257157',4897827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257157',4897828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897829,'3005','465',203822.97,204941.27,1118.30,182282.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897830,'3006','465',327698.44,328742.73,1044.29,170219.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897831,'3007','465',149067.76,149067.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897832,'3008','465',220525.59,222167.14,1641.55,267572.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897833,'3009','465',107252.46,108176.64,924.18,150641.34,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897834,'3010','465',181090.33,182016.00,925.67,150884.21,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897835,'3011','465',269127.17,270443.74,1316.57,214600.91,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257158',4897836,'3012','465',92362.99,92362.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897837,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897838,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897839,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897840,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897841,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897842,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897843,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257158',4897844,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257158',4897845,'3021','466',354212.85,355648.71,1435.86,502551.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257158',4897846,'3022','466',445239.88,445464.89,225.01,78753.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257158',4897847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257158',4897848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897849,'3005','465',204941.27,204941.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897850,'3006','465',328742.73,330788.88,2046.15,333522.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897851,'3007','465',149067.76,150046.25,978.49,159493.87,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897852,'3008','465',222167.14,223965.30,1798.16,293100.08,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897853,'3009','465',108176.64,109794.77,1618.13,263755.19,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897854,'3010','465',182016.00,182943.07,927.07,151112.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897855,'3011','465',270443.74,270443.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257159',4897856,'3012','465',92362.99,93657.50,1294.51,211005.13,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897857,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897858,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897859,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897860,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897861,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897862,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897863,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257159',4897864,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257159',4897865,'3021','466',355648.71,356525.85,877.14,306999.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257159',4897866,'3022','466',445464.89,447492.30,2027.41,709593.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257159',4897867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257159',4897868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897869,'3005','465',204941.27,205675.57,734.30,119690.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897870,'3006','465',330788.88,333147.92,2359.04,384523.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897871,'3007','465',150046.25,151832.03,1785.78,291082.14,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897872,'3008','465',223965.30,225375.75,1410.45,229903.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897873,'3009','465',109794.77,112003.13,2208.36,359962.68,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897874,'3010','465',182943.07,182943.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897875,'3011','465',270443.74,271756.17,1312.43,213926.09,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257160',4897876,'3012','465',93657.50,93657.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897877,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897878,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897879,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897880,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897881,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897882,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897883,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257160',4897884,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257160',4897885,'3021','466',356525.85,358695.68,2169.83,759440.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257160',4897886,'3022','466',447492.30,448532.45,1040.15,364052.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257160',4897887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257160',4897888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897889,'3005','465',205675.57,206838.47,1162.90,189552.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897890,'3006','465',333147.92,335053.89,1905.97,310673.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897891,'3007','465',151832.03,153436.10,1604.07,261463.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897892,'3008','465',225375.75,227267.00,1891.25,308273.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897893,'3009','465',112003.13,114058.10,2054.97,334960.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897894,'3010','465',182943.07,182943.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897895,'3011','465',271756.17,273845.70,2089.53,340593.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257161',4897896,'3012','465',93657.50,94593.22,935.72,152522.36,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897897,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897898,'3014','465',340391.93,340391.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897899,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897900,'3016','465',244459.83,244459.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897901,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897902,'3018','465',190702.91,190702.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897903,'3019','465',225086.00,225086.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257161',4897904,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257161',4897905,'3021','466',358695.68,359162.54,466.86,163401.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257161',4897906,'3022','466',448532.45,449102.45,570.00,199500.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257161',4897907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257161',4897908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897909,'3005','465',206838.47,207418.54,580.07,95711.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897910,'3006','465',335053.89,336798.68,1744.79,287890.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897911,'3007','465',153436.10,155205.63,1769.53,291972.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897912,'3008','465',227267.00,228615.99,1348.99,222583.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897913,'3009','465',114058.10,115646.38,1588.28,262066.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897914,'3010','465',182943.07,183680.96,737.89,121751.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897915,'3011','465',273845.70,274846.28,1000.58,165095.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257162',4897916,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897917,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897918,'3014','465',340391.93,340407.50,15.57,2569.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897919,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897920,'3016','465',244459.83,244496.13,36.30,5989.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897921,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897922,'3018','465',190702.91,190753.00,50.09,8264.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897923,'3019','465',225086.00,225086.53,0.53,87.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257162',4897924,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257162',4897925,'3021','466',359162.54,359462.54,300.00,106500.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257162',4897926,'3022','466',449102.45,449280.63,178.18,63253.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257162',4897927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257162',4897928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897929,'3005','465',207418.54,207418.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897930,'3006','465',336798.68,336798.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897931,'3007','465',155205.63,155205.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897932,'3008','465',228615.99,228615.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897933,'3009','465',115646.38,115646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897934,'3010','465',183680.96,183680.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897935,'3011','465',274846.28,274846.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257163',4897936,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897937,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897938,'3014','465',340407.50,340407.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897939,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897940,'3016','465',244496.13,244496.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897941,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897942,'3018','465',190753.00,190753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897943,'3019','465',225086.53,225086.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257163',4897944,'3020','465',123872.04,123872.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257163',4897945,'3021','466',359462.54,359462.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257163',4897946,'3022','466',449280.63,449280.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257163',4897947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257163',4897948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897949,'3005','465',207418.54,209629.80,2211.26,360435.38,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897950,'3006','465',336798.68,337291.29,492.61,80295.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897951,'3007','465',155205.63,155205.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897952,'3008','465',228615.99,228921.03,305.04,49721.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897953,'3009','465',115646.38,115646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897954,'3010','465',183680.96,184260.62,579.66,94484.58,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897955,'3011','465',274846.28,277691.30,2845.02,463738.26,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257164',4897956,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897957,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897958,'3014','465',340407.50,341920.95,1513.45,246692.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897959,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897960,'3016','465',244496.13,246426.16,1930.03,314594.89,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897961,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897962,'3018','465',190753.00,190753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897963,'3019','465',225086.53,225086.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257164',4897964,'3020','465',125199.77,127125.43,1925.66,313882.58,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257164',4897965,'3021','466',359462.54,361044.75,1582.21,561684.55,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257164',4897966,'3022','466',449280.63,452890.87,3610.24,1281635.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257164',4897967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257164',4897968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897969,'3005','465',209629.80,209629.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897970,'3006','465',337291.29,338833.55,1531.93,249704.59,0.00,0.00,10.33,0.00,0.00),('1','195','1019','257165',4897971,'3007','465',155205.63,155205.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897972,'3008','465',228921.03,229502.27,581.24,94742.12,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897973,'3009','465',115646.38,115646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897974,'3010','465',184260.62,184260.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897975,'3011','465',277691.30,278905.17,1213.87,197860.81,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257165',4897976,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257165',4897977,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257165',4897978,'3014','465',341920.95,343979.61,2048.20,333856.60,0.00,0.00,10.46,0.00,0.00),('1','195','1020','257165',4897979,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257165',4897980,'3016','465',246426.16,248057.28,1620.83,264195.29,0.00,0.00,10.29,0.00,0.00),('1','195','1020','257165',4897981,'3017','465',75708.78,75708.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257165',4897982,'3018','465',190753.00,190753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257165',4897983,'3019','465',225086.53,225236.20,149.67,24396.21,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257165',4897984,'3020','465',127125.43,128160.00,1024.26,166954.38,0.00,0.00,10.31,0.00,0.00),('1','195','1021','257165',4897985,'3021','466',361044.75,361272.36,227.61,80801.55,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257165',4897986,'3022','466',452890.87,453960.58,1069.71,379747.05,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257165',4897987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257165',4897988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897989,'3005','465',209629.80,211982.85,2353.05,383547.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897990,'3006','465',338833.55,338833.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897991,'3007','465',155205.63,157187.83,1982.20,323098.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897992,'3008','465',229502.27,229502.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897993,'3009','465',115646.38,115646.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897994,'3010','465',184260.62,184260.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897995,'3011','465',278905.17,280767.82,1862.65,303611.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257166',4897996,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4897997,'3013','465',128977.32,128977.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4897998,'3014','465',343979.61,346292.04,2312.43,376926.09,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4897999,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4898000,'3016','465',248057.28,248057.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4898001,'3017','465',75708.78,76921.30,1212.52,197640.76,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4898002,'3018','465',190753.00,190753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4898003,'3019','465',225236.20,227100.75,1864.55,303921.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257166',4898004,'3020','465',128160.00,128160.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257166',4898005,'3021','466',361272.36,363549.04,2276.68,808221.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257166',4898006,'3022','466',453960.58,457387.95,3427.37,1216716.35,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257166',4898007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257166',4898008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898009,'3005','465',211982.85,211982.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898010,'3006','465',338833.55,338833.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898011,'3007','465',157187.83,157187.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898012,'3008','465',229502.27,229523.74,21.47,3499.61,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898013,'3009','465',115646.38,116675.97,1029.59,167823.17,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898014,'3010','465',184260.62,184260.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898015,'3011','465',280767.82,282156.07,1388.25,226284.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257167',4898016,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898017,'3013','465',128977.32,130848.70,1871.38,305034.94,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898018,'3014','465',346292.04,346292.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898019,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898020,'3016','465',248057.28,250317.65,2260.37,368440.31,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898021,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898022,'3018','465',190753.00,190753.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898023,'3019','465',227100.75,227100.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257167',4898024,'3020','465',128160.00,130048.90,1888.90,307890.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257167',4898025,'3021','466',363549.04,366139.94,2590.90,919769.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257167',4898026,'3022','466',457387.95,457722.54,334.59,118779.45,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257167',4898027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257167',4898028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898029,'3005','465',211982.85,211982.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898030,'3006','465',338833.55,341068.73,2235.18,364334.34,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898031,'3007','465',157187.83,159968.65,2780.82,453273.66,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898032,'3008','465',229523.74,229523.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898033,'3009','465',116675.97,116675.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898034,'3010','465',184260.62,185611.37,1350.75,220172.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898035,'3011','465',282156.07,284009.92,1853.85,302177.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257168',4898036,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898037,'3013','465',130848.70,133474.27,2625.57,427967.91,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898038,'3014','465',346292.04,346305.06,13.02,2122.26,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898039,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898040,'3016','465',250317.65,250317.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898041,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898042,'3018','465',190753.00,192974.11,2221.11,362040.93,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898043,'3019','465',227100.75,227100.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257168',4898044,'3020','465',130048.90,130048.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257168',4898045,'3021','466',366139.94,367541.24,1401.30,497461.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257168',4898046,'3022','466',457722.54,459956.41,2233.87,793023.85,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257168',4898047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257168',4898048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898049,'3005','465',211982.85,213880.03,1897.18,309240.34,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898050,'3006','465',341068.73,341068.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898051,'3007','465',159968.65,159968.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898052,'3008','465',229523.74,230134.44,610.70,99544.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898053,'3009','465',116675.97,116675.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898054,'3010','465',185611.37,185611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898055,'3011','465',284009.92,286065.82,2055.90,335111.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257169',4898056,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898057,'3013','465',133474.27,133474.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898058,'3014','465',346305.06,347432.69,1127.63,183803.69,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898059,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898060,'3016','465',250317.65,252571.75,2254.10,367418.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898061,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898062,'3018','465',192974.11,194414.30,1440.19,234750.97,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898063,'3019','465',227100.75,227100.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257169',4898064,'3020','465',130048.90,130048.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257169',4898065,'3021','466',367541.24,367626.18,84.94,30153.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257169',4898066,'3022','466',459956.41,460140.91,184.50,65497.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257169',4898067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257169',4898068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898069,'3005','465',213880.03,213880.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898070,'3006','465',341068.73,343786.78,2718.05,443042.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898071,'3007','465',159968.65,159968.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898072,'3008','465',230134.44,232406.74,2272.30,370384.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898073,'3009','465',116675.97,116675.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898074,'3010','465',185611.37,185611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898075,'3011','465',286065.82,288170.33,2104.51,343035.13,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257170',4898076,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898077,'3013','465',133474.27,133474.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898078,'3014','465',347432.69,350662.91,3230.22,526525.86,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898079,'3015','465',119980.20,119980.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898080,'3016','465',252571.75,252571.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898081,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898082,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898083,'3019','465',227100.75,229012.50,1911.75,311615.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257170',4898084,'3020','465',130048.90,130048.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257170',4898085,'3021','466',367626.18,370640.11,3013.93,1069945.15,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257170',4898086,'3022','466',460140.91,462357.70,2216.79,786960.45,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257170',4898087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257170',4898088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898089,'3005','465',213880.03,213880.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898090,'3006','465',343786.78,345330.19,1543.41,251575.83,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898091,'3007','465',159968.65,159968.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898092,'3008','465',232406.74,232425.14,18.40,2999.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898093,'3009','465',116675.97,116675.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898094,'3010','465',185611.37,185611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898095,'3011','465',288170.33,289640.03,1469.70,239561.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257171',4898096,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898097,'3013','465',133474.27,133474.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898098,'3014','465',350662.91,352642.23,1979.32,322629.16,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898099,'3015','465',119980.20,121741.83,1761.63,287145.69,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898100,'3016','465',252571.75,252571.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898101,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898102,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898103,'3019','465',229012.50,229012.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257171',4898104,'3020','465',130048.90,131675.90,1627.00,265201.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257171',4898105,'3021','466',370640.11,373253.06,2612.95,940662.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257171',4898106,'3022','466',462357.70,463972.38,1614.68,581284.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257171',4898107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257171',4898108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898109,'3005','465',213880.03,213880.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898110,'3006','465',345330.19,347385.99,2055.80,335095.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898111,'3007','465',159968.65,159968.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898112,'3008','465',232425.14,234957.11,2531.97,412711.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898113,'3009','465',116675.97,116675.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898114,'3010','465',185611.37,185611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898115,'3011','465',289640.03,290537.05,897.02,146214.26,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257172',4898116,'3012','465',94593.22,94593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898117,'3013','465',133474.27,133474.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898118,'3014','465',352642.23,352764.66,122.43,19956.09,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898119,'3015','465',121741.83,121741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898120,'3016','465',252571.75,255075.51,2503.76,408112.88,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898121,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898122,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898123,'3019','465',229012.50,231067.16,2054.66,334909.58,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257172',4898124,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257172',4898125,'3021','466',373253.06,376917.31,3664.25,1319130.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257172',4898126,'3022','466',463972.38,466129.51,2157.13,776566.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257172',4898127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257172',4898128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898129,'3005','465',213880.03,213880.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898130,'3006','465',347385.99,348925.02,1539.03,250861.89,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898131,'3007','465',159968.65,160991.76,1023.11,166766.93,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898132,'3008','465',234957.11,234957.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898133,'3009','465',116675.97,116764.34,88.37,14404.31,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898134,'3010','465',185611.37,185611.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898135,'3011','465',290537.05,291718.79,1181.74,192623.62,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257173',4898136,'3012','465',94593.22,94787.37,194.15,31646.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898137,'3013','465',133474.27,135206.10,1731.83,282288.29,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898138,'3014','465',352764.66,352764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898139,'3015','465',121741.83,121741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898140,'3016','465',255075.51,256109.37,1033.86,168519.18,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898141,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898142,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898143,'3019','465',231067.16,231919.97,852.81,139008.03,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257173',4898144,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257173',4898145,'3021','466',376917.31,379249.62,2332.31,839631.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257173',4898146,'3022','466',466129.51,467444.41,1314.90,473364.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257173',4898147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257173',4898148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898149,'3005','465',213880.03,215635.24,1755.21,286099.23,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898150,'3006','465',348925.02,348925.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898151,'3007','465',160991.76,160991.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898152,'3008','465',234957.11,237168.19,2211.08,360406.04,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898153,'3009','465',116764.34,118370.25,1605.91,261763.33,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898154,'3010','465',185611.37,185711.25,99.88,16280.44,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898155,'3011','465',291718.79,293289.48,1570.69,256022.47,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257174',4898156,'3012','465',94787.37,96294.67,1507.30,245689.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898157,'3013','465',135206.10,135206.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898158,'3014','465',352764.66,352764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898159,'3015','465',121741.83,121741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898160,'3016','465',256109.37,256109.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898161,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898162,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898163,'3019','465',231919.97,231919.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257174',4898164,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257174',4898165,'3021','466',379249.62,380674.45,1424.83,512938.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257174',4898166,'3022','466',467444.41,467444.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257174',4898167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257174',4898168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898169,'3005','465',215635.24,217273.31,1638.07,267005.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898170,'3006','465',348925.02,350846.77,1921.75,313245.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898171,'3007','465',160991.76,163101.93,2110.17,343957.71,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898172,'3008','465',237168.19,237168.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898173,'3009','465',118370.25,118370.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898174,'3010','465',185711.25,187505.50,1794.25,292462.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898175,'3011','465',293289.48,294835.37,1545.89,251980.07,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257175',4898176,'3012','465',96294.67,96319.20,24.53,3998.39,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898177,'3013','465',135206.10,135206.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898178,'3014','465',352764.66,352764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898179,'3015','465',121741.83,121741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898180,'3016','465',256109.37,256109.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898181,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898182,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898183,'3019','465',231919.97,231919.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257175',4898184,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257175',4898185,'3021','466',380674.45,381150.40,475.95,171342.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257175',4898186,'3022','466',467444.41,468524.16,1079.75,388710.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257175',4898187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257175',4898188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898189,'3005','465',217273.31,219855.10,2581.79,420831.77,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898190,'3006','465',350846.77,352315.48,1468.71,239399.73,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898191,'3007','465',163101.93,164615.19,1513.26,246661.38,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898192,'3008','465',237168.19,238920.26,1752.07,285587.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898193,'3009','465',118370.25,118370.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898194,'3010','465',187505.50,189153.23,1647.73,268579.99,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898195,'3011','465',294835.37,297260.29,2424.92,395261.96,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257176',4898196,'3012','465',96319.20,96319.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898197,'3013','465',135206.10,135206.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898198,'3014','465',352764.66,352764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898199,'3015','465',121741.83,121741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898200,'3016','465',256109.37,256109.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898201,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898202,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898203,'3019','465',231919.97,231919.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257176',4898204,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257176',4898205,'3021','466',381150.40,382822.44,1672.04,601934.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257176',4898206,'3022','466',468524.16,469926.68,1402.52,504907.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257176',4898207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257176',4898208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898209,'3005','465',219855.10,221797.71,1942.61,316645.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898210,'3006','465',352315.48,352315.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898211,'3007','465',164615.19,166369.38,1754.19,285932.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898212,'3008','465',238920.26,239922.45,1002.19,163356.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898213,'3009','465',118370.25,119868.47,1498.22,244209.86,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898214,'3010','465',189153.23,189153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898215,'3011','465',297260.29,298631.61,1371.32,223525.16,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257177',4898216,'3012','465',96319.20,97451.63,1132.43,184586.09,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898217,'3013','465',135206.10,135206.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898218,'3014','465',352764.66,352764.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898219,'3015','465',121741.83,121741.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898220,'3016','465',256109.37,256109.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898221,'3017','465',76921.30,76921.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898222,'3018','465',194414.30,194414.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898223,'3019','465',231919.97,231919.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257177',4898224,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257177',4898225,'3021','466',382822.44,384358.47,1536.03,552970.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257177',4898226,'3022','466',469926.68,471021.01,1094.33,393958.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257177',4898227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257177',4898228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898229,'3005','465',221797.71,221797.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898230,'3006','465',352315.48,352958.26,642.78,104773.14,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898231,'3007','465',166369.38,166369.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898232,'3008','465',239922.45,241007.30,1084.85,176830.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898233,'3009','465',119868.47,119868.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898234,'3010','465',189153.23,189153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898235,'3011','465',298631.61,299546.09,914.48,149060.24,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257178',4898236,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898237,'3013','465',135206.10,137141.64,1935.54,315493.02,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898238,'3014','465',352764.66,353426.45,661.79,107871.77,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898239,'3015','465',121741.83,121935.21,193.38,31520.94,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898240,'3016','465',256109.37,257467.55,1358.18,221383.34,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898241,'3017','465',76921.30,77215.13,293.83,47894.29,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898242,'3018','465',194414.30,196572.35,2158.05,351762.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898243,'3019','465',231919.97,233461.08,1541.11,251200.93,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257178',4898244,'3020','465',131675.90,131675.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257178',4898245,'3021','466',384358.47,386126.47,1768.00,636480.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257178',4898246,'3022','466',471021.01,472968.82,1947.81,701211.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257178',4898247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257178',4898248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898249,'3005','465',221797.71,221797.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898250,'3006','465',352958.26,354770.36,1812.10,295372.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898251,'3007','465',166369.38,167779.14,1409.76,229790.88,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898252,'3008','465',241007.30,241007.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898253,'3009','465',119868.47,119868.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898254,'3010','465',189153.23,189153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898255,'3011','465',299546.09,301421.51,1875.42,305693.46,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257179',4898256,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898257,'3013','465',137141.64,137141.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898258,'3014','465',353426.45,355626.11,2199.66,358544.58,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898259,'3015','465',121935.21,121935.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898260,'3016','465',257467.55,257467.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898261,'3017','465',77215.13,77215.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898262,'3018','465',196572.35,198395.22,1822.87,297127.81,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898263,'3019','465',233461.08,233461.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257179',4898264,'3020','465',131675.90,133557.85,1881.95,306757.85,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257179',4898265,'3021','466',386126.47,388864.12,2737.65,985554.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257179',4898266,'3022','466',472968.82,475712.78,2743.96,987825.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257179',4898267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257179',4898268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898269,'3005','465',221797.71,224668.21,2870.50,467891.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898270,'3006','465',354770.36,354776.50,6.14,1000.82,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898271,'3007','465',167779.14,170353.63,2574.49,419641.87,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898272,'3008','465',241007.30,241007.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898273,'3009','465',119868.47,120349.02,480.55,78329.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898274,'3010','465',189153.23,189153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898275,'3011','465',301421.51,304459.92,3038.41,495260.83,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257180',4898276,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898277,'3013','465',137141.64,139314.14,2172.50,354117.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898278,'3014','465',355626.11,355626.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898279,'3015','465',121935.21,123588.25,1653.04,269445.52,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898280,'3016','465',257467.55,257467.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898281,'3017','465',77215.13,77215.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898282,'3018','465',198395.22,199442.82,1047.60,170758.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898283,'3019','465',233461.08,233590.50,129.42,21095.46,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257180',4898284,'3020','465',133557.85,133557.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257180',4898285,'3021','466',388864.12,389608.23,744.11,267879.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257180',4898286,'3022','466',475712.78,477707.60,1994.82,718135.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257180',4898287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257180',4898288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898289,'3005','465',224668.21,226749.43,2081.22,339238.86,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898290,'3006','465',354776.50,354776.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898291,'3007','465',170353.63,172271.38,1917.75,312593.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898292,'3008','465',241007.30,241087.06,79.76,13000.88,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898293,'3009','465',120349.02,120349.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898294,'3010','465',189153.23,189153.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257181',4898295,'3011','465',304459.92,306374.74,1904.82,310485.66,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257181',4898296,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898297,'3013','465',139314.14,141405.47,2091.33,340886.79,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898298,'3014','465',355626.11,355626.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898299,'3015','465',123588.25,123588.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898300,'3016','465',257467.55,257467.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898301,'3017','465',77215.13,77215.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898302,'3018','465',199442.82,201764.86,2312.04,376862.52,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257181',4898303,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257181',4898304,'3020','465',133557.85,133557.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257181',4898305,'3021','466',389608.23,390720.81,1112.58,400528.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257181',4898306,'3022','466',477707.60,480781.22,3073.62,1106503.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257181',4898307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257181',4898308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898309,'3005','465',226749.43,227422.53,673.10,109715.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898310,'3006','465',354776.50,358108.30,3331.80,543083.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898311,'3007','465',172271.38,172271.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898312,'3008','465',241087.06,244176.18,3089.12,503526.56,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898313,'3009','465',120349.02,121601.39,1252.37,204136.31,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898314,'3010','465',189153.23,189595.61,442.38,72107.94,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898315,'3011','465',306374.74,309279.37,2904.63,473454.69,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257182',4898316,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898317,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898318,'3014','465',355626.11,356569.27,943.16,153735.08,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898319,'3015','465',123588.25,123588.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898320,'3016','465',257467.55,259008.23,1540.68,251130.84,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898321,'3017','465',77215.13,77215.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898322,'3018','465',201764.86,202169.96,405.10,66031.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898323,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257182',4898324,'3020','465',133557.85,133557.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257182',4898325,'3021','466',390720.81,392129.66,1408.85,507186.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257182',4898326,'3022','466',480781.22,483407.24,2626.02,945367.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257182',4898327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257182',4898328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257183',4898329,'3005','465',227422.53,228728.52,1295.99,211246.37,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257183',4898330,'3006','465',358108.30,359829.72,1721.42,280591.46,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257183',4898331,'3007','465',172271.38,174243.97,1972.59,321532.17,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257183',4898332,'3008','465',244176.18,244176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257183',4898333,'3009','465',121601.39,123319.17,1717.78,279998.14,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257183',4898334,'3010','465',189595.61,189595.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257183',4898335,'3011','465',309279.37,310652.00,1362.63,222108.69,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257183',4898336,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898337,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898338,'3014','465',356569.27,356569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898339,'3015','465',123588.25,123684.48,96.23,15685.49,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898340,'3016','465',259008.23,260738.55,1730.32,282042.16,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898341,'3017','465',77215.13,77215.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898342,'3018','465',202169.96,202169.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898343,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257183',4898344,'3020','465',133557.85,133557.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257183',4898345,'3021','466',392129.66,395191.07,3061.41,1102107.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257183',4898346,'3022','466',483407.24,486892.37,3485.13,1254646.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257183',4898347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257183',4898348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898349,'3005','465',228728.52,228728.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898350,'3006','465',359829.72,359829.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898351,'3007','465',174243.97,174243.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898352,'3008','465',244176.18,244176.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898353,'3009','465',123319.17,123319.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898354,'3010','465',189595.61,189595.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898355,'3011','465',310652.00,310652.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257184',4898356,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898357,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898358,'3014','465',356569.27,356569.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898359,'3015','465',123684.48,123684.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898360,'3016','465',260738.55,260738.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898361,'3017','465',77215.13,77215.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898362,'3018','465',202169.96,202169.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898363,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257184',4898364,'3020','465',133557.85,133557.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257184',4898365,'3021','466',395191.07,395191.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257184',4898366,'3022','466',486892.37,486892.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257184',4898367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257184',4898368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898369,'3005','465',228728.52,228728.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898370,'3006','465',359829.72,360915.97,1086.25,177058.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898371,'3007','465',174243.97,175795.09,1551.12,252832.56,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898372,'3008','465',244176.18,244566.53,390.35,63627.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898373,'3009','465',123319.17,124189.64,870.47,141886.61,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898374,'3010','465',189595.61,189595.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898375,'3011','465',310652.00,312391.42,1739.42,283525.46,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257185',4898376,'3012','465',97451.63,97451.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898377,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898378,'3014','465',356569.27,357746.97,1177.70,191965.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898379,'3015','465',123684.48,126000.01,2315.53,377431.39,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898380,'3016','465',260738.55,261583.95,845.40,137800.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898381,'3017','465',77215.13,77447.79,232.66,37923.58,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898382,'3018','465',202169.96,203244.39,1074.43,175132.09,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898383,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257185',4898384,'3020','465',134924.09,136618.61,1694.52,276206.76,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257185',4898385,'3021','466',395191.07,396443.43,1252.36,475896.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257185',4898386,'3022','466',486892.37,488728.15,1835.78,697596.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257185',4898387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257185',4898388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898389,'3005','465',228728.52,230022.81,1294.29,210969.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898390,'3006','465',360915.97,362294.26,1378.29,224661.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898391,'3007','465',175795.09,177276.47,1481.38,241464.94,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898392,'3008','465',244566.53,244566.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898393,'3009','465',124189.64,125145.85,956.21,155862.23,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898394,'3010','465',189595.61,191028.58,1432.97,233574.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898395,'3011','465',312391.42,313628.28,1236.86,201608.18,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257186',4898396,'3012','465',97451.63,98933.19,1481.56,241494.28,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898397,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898398,'3014','465',357746.97,357841.44,94.47,15398.61,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898399,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898400,'3016','465',261583.95,261622.71,38.76,6317.88,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898401,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898402,'3018','465',203244.39,203343.84,99.45,16210.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898403,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257186',4898404,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257186',4898405,'3021','466',396443.43,398591.27,2147.84,816179.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257186',4898406,'3022','466',488728.15,491387.24,2659.09,1010454.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257186',4898407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257186',4898408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898409,'3005','465',230022.81,230022.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898410,'3006','465',362294.26,365319.87,3025.61,493174.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898411,'3007','465',177276.47,180144.97,2868.50,467565.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898412,'3008','465',244566.53,244831.54,265.01,43196.63,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898413,'3009','465',125145.85,127754.72,2608.87,425245.81,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898414,'3010','465',191028.58,191028.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898415,'3011','465',313628.28,316332.32,2704.04,440758.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257187',4898416,'3012','465',98933.19,99158.32,225.13,36696.19,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898417,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898418,'3014','465',357841.44,357841.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898419,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898420,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898421,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898422,'3018','465',203343.84,203415.00,71.16,11599.08,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898423,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257187',4898424,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257187',4898425,'3021','466',398591.27,399905.55,1314.28,499426.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257187',4898426,'3022','466',491387.24,492813.17,1425.93,541853.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257187',4898427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257187',4898428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898429,'3005','465',230022.81,231522.48,1499.67,244446.21,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898430,'3006','465',365319.87,366649.90,1330.03,216794.89,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898431,'3007','465',180144.97,181224.58,1079.61,175976.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898432,'3008','465',244831.54,245870.39,1038.85,169332.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898433,'3009','465',127754.72,128765.85,1011.13,164814.19,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898434,'3010','465',191028.58,192284.55,1255.97,204723.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898435,'3011','465',316332.32,317842.48,1510.16,246156.08,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257188',4898436,'3012','465',99158.32,99158.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898437,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898438,'3014','465',357841.44,357841.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898439,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898440,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898441,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898442,'3018','465',203415.00,203415.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898443,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257188',4898444,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257188',4898445,'3021','466',399905.55,400313.44,407.89,154998.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257188',4898446,'3022','466',492813.17,494796.66,1983.49,753726.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257188',4898447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257188',4898448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898449,'3005','465',231522.48,231522.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898450,'3006','465',366649.90,370152.69,3502.79,570954.77,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898451,'3007','465',181224.58,183125.27,1900.69,309812.47,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898452,'3008','465',245870.39,247919.58,2049.19,334017.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898453,'3009','465',128765.85,129813.26,1047.41,170727.83,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898454,'3010','465',192284.55,192284.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898455,'3011','465',317842.48,321075.03,3232.55,526905.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257189',4898456,'3012','465',99158.32,99158.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898457,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898458,'3014','465',357841.44,358053.42,211.98,34552.74,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898459,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898460,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898461,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898462,'3018','465',203415.00,203513.70,98.70,16088.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898463,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257189',4898464,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257189',4898465,'3021','466',400313.44,401983.49,1670.05,634619.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257189',4898466,'3022','466',494796.66,496520.11,1723.45,654911.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257189',4898467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257189',4898468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898469,'3005','465',231522.48,231522.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898470,'3006','465',370152.69,372921.87,2769.18,451376.34,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898471,'3007','465',183125.27,186581.46,3456.19,563358.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898472,'3008','465',247919.58,247919.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898473,'3009','465',129813.26,131185.36,1372.10,223652.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898474,'3010','465',192284.55,194422.58,2138.03,348498.89,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898475,'3011','465',321075.03,323882.38,2807.35,457598.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257190',4898476,'3012','465',99158.32,99158.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898477,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898478,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898479,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898480,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898481,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898482,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898483,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257190',4898484,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257190',4898485,'3021','466',401983.49,402444.50,461.01,175183.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257190',4898486,'3022','466',496520.11,497387.41,867.30,329574.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257190',4898487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257190',4898488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898489,'3005','465',231522.48,233523.44,2000.96,326156.48,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898490,'3006','465',372921.87,375545.82,2623.95,427703.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898491,'3007','465',186581.46,188943.76,2362.30,385054.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898492,'3008','465',247919.58,248034.19,114.61,18681.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898493,'3009','465',131185.36,133113.71,1928.35,314321.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898494,'3010','465',194422.58,196370.53,1947.95,317515.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898495,'3011','465',323882.38,325899.97,2017.59,328867.17,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257191',4898496,'3012','465',99158.32,101127.83,1969.51,321030.13,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898497,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898498,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898499,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898500,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898501,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898502,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898503,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257191',4898504,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257191',4898505,'3021','466',402444.50,404151.08,1706.58,648500.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257191',4898506,'3022','466',497387.41,499997.86,2610.45,991971.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257191',4898507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257191',4898508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898509,'3005','465',233523.44,234035.42,511.98,83452.74,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898510,'3006','465',375545.82,380147.65,4601.83,750098.29,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898511,'3007','465',188943.76,192190.47,3246.71,529213.73,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898512,'3008','465',248034.19,248034.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898513,'3009','465',133113.71,133113.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898514,'3010','465',196370.53,199029.39,2658.86,433394.18,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898515,'3011','465',325899.97,327109.85,1209.88,197210.44,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257192',4898516,'3012','465',101127.83,101971.81,843.98,137568.74,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898517,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898518,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898519,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898520,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898521,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898522,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898523,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257192',4898524,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257192',4898525,'3021','466',404151.08,410991.12,6840.04,2599215.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257192',4898526,'3022','466',499997.86,507475.44,7477.58,2841480.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257192',4898527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257192',4898528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898529,'3005','465',234035.42,237028.61,2993.19,487889.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898530,'3006','465',380147.65,382128.96,1981.31,322953.53,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898531,'3007','465',192190.47,195027.05,2836.58,462362.54,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898532,'3008','465',248034.19,249986.48,1952.29,318223.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898533,'3009','465',133113.71,133253.58,139.87,22798.81,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898534,'3010','465',199029.39,202062.69,3033.30,494427.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898535,'3011','465',327109.85,327109.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257193',4898536,'3012','465',101971.81,104041.05,2069.24,337286.12,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898537,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898538,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898539,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898540,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898541,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898542,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898543,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257193',4898544,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257193',4898545,'3021','466',410991.12,412122.01,1130.89,435392.65,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257193',4898546,'3022','466',507475.44,507475.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257193',4898547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257193',4898548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898549,'3005','465',237028.61,240171.50,3142.89,512291.07,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898550,'3006','465',382128.96,385980.00,3851.04,627719.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898551,'3007','465',195027.05,198613.98,3586.93,584669.59,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898552,'3008','465',249986.48,253504.93,3518.45,573507.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898553,'3009','465',133253.58,133843.62,590.04,96176.52,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898554,'3010','465',202062.69,204942.24,2879.55,469366.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898555,'3011','465',327109.85,331255.91,4146.06,675807.78,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257194',4898556,'3012','465',104041.05,106425.28,2384.23,388629.49,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898557,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898558,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898559,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898560,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898561,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898562,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898563,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257194',4898564,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257194',4898565,'3021','466',412122.01,412122.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257194',4898566,'3022','466',507475.44,508300.76,825.32,317748.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257194',4898567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257194',4898568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898569,'3005','465',240171.50,243729.66,3558.16,579980.08,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898570,'3006','465',385980.00,385980.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898571,'3007','465',198613.98,202412.38,3798.40,619139.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898572,'3008','465',253504.93,253950.75,445.82,72668.66,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898573,'3009','465',133843.62,134511.57,667.95,108875.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898574,'3010','465',204942.24,204942.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898575,'3011','465',331255.91,335304.62,4048.71,659939.73,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257195',4898576,'3012','465',106425.28,106686.64,261.36,42601.68,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898577,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898578,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898579,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898580,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898581,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898582,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898583,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257195',4898584,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257195',4898585,'3021','466',412122.01,412122.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257195',4898586,'3022','466',508300.76,508300.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257195',4898587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257195',4898588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898589,'3005','465',243729.66,243729.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898590,'3006','465',385980.00,388584.70,2604.70,424566.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898591,'3007','465',202412.38,202412.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898592,'3008','465',253950.75,253950.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898593,'3009','465',134511.57,134511.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898594,'3010','465',204942.24,204942.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898595,'3011','465',335304.62,338240.71,2936.09,478582.67,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257196',4898596,'3012','465',106686.64,106722.24,35.60,5802.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898597,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898598,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898599,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898600,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898601,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898602,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898603,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257196',4898604,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257196',4898605,'3021','466',412122.01,413505.25,1383.24,532547.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257196',4898606,'3022','466',508300.76,510148.42,1847.66,711349.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257196',4898607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257196',4898608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257197',4898609,'3005','465',243729.66,243729.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257197',4898610,'3006','465',388584.70,390789.66,2184.96,356148.48,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257197',4898611,'3007','465',202412.38,202448.58,36.20,5900.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257197',4898612,'3008','465',253950.75,254100.75,150.00,24450.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257197',4898613,'3009','465',134511.57,134587.97,76.40,12453.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257197',4898614,'3010','465',204942.24,205121.43,164.19,26762.97,0.00,0.00,15.00,0.00,0.00),('1','195','1019','257197',4898615,'3011','465',338240.71,340633.09,2372.38,386697.94,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257197',4898616,'3012','465',106722.24,106722.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898617,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898618,'3014','465',358053.42,358053.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898619,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898620,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898621,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898622,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898623,'3019','465',233590.50,233590.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257197',4898624,'3020','465',136618.61,136618.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257197',4898625,'3021','466',413505.25,416552.33,3047.08,1173125.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257197',4898626,'3022','466',510148.42,514219.32,4070.90,1567296.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257197',4898627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257197',4898628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257198',4898629,'3005','465',243729.66,243759.84,30.18,4919.34,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257198',4898630,'3006','465',390789.66,393046.90,2247.24,366300.12,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257198',4898631,'3007','465',202448.58,202448.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257198',4898632,'3008','465',254100.75,254130.19,29.44,4798.72,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257198',4898633,'3009','465',134587.97,134587.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257198',4898634,'3010','465',205121.43,205121.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257198',4898635,'3011','465',340633.09,343618.69,2975.60,485022.80,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257198',4898636,'3012','465',106722.24,106722.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898637,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898638,'3014','465',358053.42,358771.27,707.85,115379.55,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257198',4898639,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898640,'3016','465',261622.71,261622.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898641,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898642,'3018','465',203513.70,203513.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898643,'3019','465',233590.50,234030.92,440.42,71788.46,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257198',4898644,'3020','465',136618.61,136619.04,0.43,70.09,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257198',4898645,'3021','466',416552.33,419711.58,3159.25,1216311.25,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257198',4898646,'3022','466',514219.32,517704.99,3485.67,1341982.95,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257198',4898647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257198',4898648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898649,'3005','465',243759.84,243759.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898650,'3006','465',393046.90,394299.77,1252.87,204217.81,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898651,'3007','465',202448.58,202448.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898652,'3008','465',254130.19,254130.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898653,'3009','465',134587.97,134587.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898654,'3010','465',205121.43,205121.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898655,'3011','465',343618.69,344748.84,1130.15,184214.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257199',4898656,'3012','465',106722.24,106722.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898657,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898658,'3014','465',358771.27,362091.10,3319.83,541132.29,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898659,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898660,'3016','465',261622.71,263464.02,1841.31,300133.53,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898661,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898662,'3018','465',203513.70,205368.42,1854.72,302319.36,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898663,'3019','465',234030.92,236803.68,2772.76,451959.88,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257199',4898664,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257199',4898665,'3021','466',419711.58,421529.04,1817.46,699722.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257199',4898666,'3022','466',517704.99,520741.49,3036.50,1169052.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257199',4898667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257199',4898668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898669,'3005','465',243759.84,244800.02,1040.18,169549.34,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898670,'3006','465',394299.77,396739.12,2439.35,397614.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898671,'3007','465',202448.58,204670.51,2221.93,362174.59,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898672,'3008','465',254130.19,256595.93,2465.74,401915.62,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898673,'3009','465',134587.97,138284.89,3696.92,602597.96,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898674,'3010','465',205121.43,205121.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898675,'3011','465',344748.84,348667.79,3918.95,638788.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257200',4898676,'3012','465',106722.24,106748.57,26.33,4291.79,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898677,'3013','465',141405.47,141405.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898678,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898679,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898680,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898681,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898682,'3018','465',205368.42,205368.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898683,'3019','465',236803.68,236803.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257200',4898684,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257200',4898685,'3021','466',421529.04,426945.83,5416.79,2085464.15,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257200',4898686,'3022','466',520741.49,527879.43,7137.94,2748106.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257200',4898687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257200',4898688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898689,'3005','465',244800.02,247625.59,2825.57,460567.91,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898690,'3006','465',396739.12,399275.98,2536.86,413508.18,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898691,'3007','465',204670.51,208513.50,3842.99,626407.37,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898692,'3008','465',256595.93,256972.29,356.36,58086.68,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257201',4898693,'3009','465',138284.89,138284.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898694,'3010','465',205121.43,207640.51,2519.08,410610.04,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898695,'3011','465',348667.79,352136.45,3468.66,565391.58,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257201',4898696,'3012','465',106748.57,106748.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898697,'3013','465',141405.47,141416.29,10.82,1763.66,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898698,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898699,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898700,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898701,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898702,'3018','465',205368.42,205413.69,45.27,7379.01,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898703,'3019','465',236803.68,236820.55,16.87,2749.81,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257201',4898704,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257201',4898705,'3021','466',426945.83,426945.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257201',4898706,'3022','466',527879.43,527879.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257201',4898707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257201',4898708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898709,'3005','465',247625.59,247625.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898710,'3006','465',399275.98,399275.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898711,'3007','465',208513.50,208513.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898712,'3008','465',256972.29,256972.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898713,'3009','465',138284.89,138284.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898714,'3010','465',207640.51,207640.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898715,'3011','465',352136.45,352136.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257202',4898716,'3012','465',106748.57,106748.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898717,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898718,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898719,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898720,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898721,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898722,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898723,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257202',4898724,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257202',4898725,'3021','466',426945.83,428927.23,1981.40,792560.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257202',4898726,'3022','466',527879.43,529903.68,2024.25,809700.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257202',4898727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257202',4898728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898729,'3005','465',247625.59,249726.46,2100.87,342441.81,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898730,'3006','465',399275.98,402232.91,2956.93,481979.59,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898731,'3007','465',208513.50,211325.79,2812.29,458403.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898732,'3008','465',256972.29,259840.48,2868.19,467514.97,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898733,'3009','465',138284.89,141581.54,3296.65,537353.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898734,'3010','465',207640.51,207640.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898735,'3011','465',352136.45,355901.33,3764.88,613675.44,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257203',4898736,'3012','465',106748.57,109394.17,2645.60,431232.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898737,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898738,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898739,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898740,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898741,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898742,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898743,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257203',4898744,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257203',4898745,'3021','466',428927.23,431895.09,2967.86,1187144.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257203',4898746,'3022','466',529903.68,533488.27,3584.59,1433836.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257203',4898747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257203',4898748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898749,'3005','465',249726.46,252810.68,3084.22,502727.86,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898750,'3006','465',402232.91,405626.19,3393.28,553104.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898751,'3007','465',211325.79,215317.69,3991.90,650679.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898752,'3008','465',259840.48,259840.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898753,'3009','465',141581.54,141581.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898754,'3010','465',207640.51,210529.83,2889.32,470959.16,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898755,'3011','465',355901.33,359356.89,3455.56,563256.28,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257204',4898756,'3012','465',109394.17,111847.91,2453.74,399959.62,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898757,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898758,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898759,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898760,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898761,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898762,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898763,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257204',4898764,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257204',4898765,'3021','466',431895.09,434283.09,2388.00,955200.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257204',4898766,'3022','466',533488.27,535345.19,1856.92,742768.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257204',4898767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257204',4898768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898769,'3005','465',252810.68,255189.82,2379.14,387799.82,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898770,'3006','465',405626.19,408634.16,3007.97,490299.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898771,'3007','465',215317.69,218526.49,3208.80,523034.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898772,'3008','465',259840.48,260261.44,420.96,68616.48,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898773,'3009','465',141581.54,144619.61,3038.07,495205.41,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898774,'3010','465',210529.83,212827.42,2297.59,374507.17,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898775,'3011','465',359356.89,363367.68,4010.79,653758.77,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257205',4898776,'3012','465',111847.91,111847.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898777,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898778,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898779,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898780,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898781,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898782,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898783,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257205',4898784,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257205',4898785,'3021','466',434283.09,437624.61,3341.52,1336608.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257205',4898786,'3022','466',535345.19,537975.62,2630.43,1052172.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257205',4898787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257205',4898788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898789,'3005','465',255189.82,255189.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898790,'3006','465',408634.16,408634.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898791,'3007','465',218526.49,218526.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898792,'3008','465',260261.44,260261.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898793,'3009','465',144619.61,144619.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898794,'3010','465',212827.42,212827.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898795,'3011','465',363367.68,363367.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257206',4898796,'3012','465',111847.91,111847.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898797,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898798,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898799,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898800,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898801,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898802,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898803,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257206',4898804,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257206',4898805,'3021','466',437624.61,441481.56,3856.95,1542780.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257206',4898806,'3022','466',537975.62,540900.71,2925.09,1170036.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257206',4898807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257206',4898808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898809,'3005','465',255189.82,255468.72,278.90,45460.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898810,'3006','465',408634.16,408890.36,256.20,41760.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898811,'3007','465',218526.49,218796.16,269.67,43956.21,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898812,'3008','465',260261.44,260261.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898813,'3009','465',144619.61,144619.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898814,'3010','465',212827.42,213044.91,217.49,35450.87,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898815,'3011','465',363367.68,363530.27,162.59,26502.17,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257207',4898816,'3012','465',111847.91,112017.62,169.71,27662.73,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898817,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898818,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898819,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898820,'3016','465',263464.02,263464.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898821,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898822,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898823,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257207',4898824,'3020','465',136619.04,136619.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257207',4898825,'3021','466',441481.56,444223.72,2742.16,1096864.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257207',4898826,'3022','466',540900.71,543403.59,2502.88,1001152.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257207',4898827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257207',4898828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898829,'3005','465',255468.72,259344.82,3876.10,631804.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898830,'3006','465',408890.36,412333.65,3443.29,561256.27,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898831,'3007','465',218796.16,223692.42,4896.26,798090.38,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898832,'3008','465',260261.44,263628.54,3367.10,548837.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898833,'3009','465',144619.61,145471.36,851.75,138835.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898834,'3010','465',213044.91,218122.52,5077.61,827650.43,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898835,'3011','465',363530.27,368070.38,4540.11,740037.93,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257208',4898836,'3012','465',112017.62,116794.57,4776.95,778642.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898837,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898838,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898839,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898840,'3016','465',263464.02,263505.99,41.97,6841.11,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898841,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898842,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898843,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257208',4898844,'3020','465',136619.04,136619.31,0.27,44.01,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257208',4898845,'3021','466',444223.72,444223.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257208',4898846,'3022','466',543403.59,543403.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257208',4898847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257208',4898848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257209',4898849,'3005','465',259344.82,262269.45,2914.63,475084.69,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257209',4898850,'3006','465',412333.65,414967.77,2624.12,427731.56,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257209',4898851,'3007','465',223692.42,226323.25,2620.83,427195.29,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257209',4898852,'3008','465',263628.54,265306.69,1678.15,273538.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257209',4898853,'3009','465',145471.36,146882.71,1411.35,230050.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257209',4898854,'3010','465',218122.52,221717.80,3595.28,586030.64,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257209',4898855,'3011','465',368070.38,371379.35,3308.97,539362.11,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257209',4898856,'3012','465',116794.57,119771.74,2977.17,485278.71,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898857,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898858,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898859,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898860,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898861,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898862,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898863,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257209',4898864,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257209',4898865,'3021','466',444223.72,444223.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257209',4898866,'3022','466',543403.59,543403.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257209',4898867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257209',4898868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898869,'3005','465',262269.45,264549.31,2279.86,376176.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898870,'3006','465',414967.77,416742.66,1774.89,292856.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898871,'3007','465',226323.25,228310.68,1987.43,327925.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898872,'3008','465',265306.69,265416.54,109.85,18125.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898873,'3009','465',146882.71,148888.19,2005.48,330904.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898874,'3010','465',221717.80,223636.31,1918.51,316554.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898875,'3011','465',371379.35,374436.70,3057.35,504462.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257210',4898876,'3012','465',119771.74,123517.30,3745.56,618017.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898877,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898878,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898879,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898880,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898881,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898882,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898883,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257210',4898884,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257210',4898885,'3021','466',444223.72,447737.85,3514.13,1405652.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257210',4898886,'3022','466',543403.59,549298.74,5895.15,2358060.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257210',4898887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257210',4898888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898889,'3005','465',264549.31,266215.87,1666.56,274982.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898890,'3006','465',416742.66,416985.73,243.07,40106.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898891,'3007','465',228310.68,231204.26,2893.58,477440.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898892,'3008','465',265416.54,265583.66,167.12,27574.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898893,'3009','465',148888.19,150154.39,1266.20,208923.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898894,'3010','465',223636.31,224444.41,808.10,133336.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898895,'3011','465',374436.70,377169.08,2732.38,450842.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257211',4898896,'3012','465',123517.30,126729.48,3212.18,530009.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898897,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898898,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898899,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898900,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898901,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898902,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898903,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257211',4898904,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257211',4898905,'3021','466',447737.85,449463.39,1725.54,690216.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257211',4898906,'3022','466',549298.74,552612.91,3314.17,1325668.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257211',4898907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257211',4898908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898909,'3005','465',266215.87,266215.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898910,'3006','465',416985.73,419522.97,2537.24,418644.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898911,'3007','465',231204.26,232234.00,1029.74,169907.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898912,'3008','465',265583.66,267445.50,1861.84,307203.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898913,'3009','465',150154.39,150154.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898914,'3010','465',224444.41,225881.45,1437.04,237111.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898915,'3011','465',377169.08,378776.36,1607.28,265201.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257212',4898916,'3012','465',126729.48,126729.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898917,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898918,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898919,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898920,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898921,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898922,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898923,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257212',4898924,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257212',4898925,'3021','466',449463.39,452587.59,3124.20,1265301.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257212',4898926,'3022','466',552612.91,556091.99,3479.08,1409027.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257212',4898927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257212',4898928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898929,'3005','465',266215.87,266215.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898930,'3006','465',419522.97,422465.84,2942.87,485573.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898931,'3007','465',232234.00,232234.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898932,'3008','465',267445.50,267475.50,30.00,4950.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898933,'3009','465',150154.39,150154.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898934,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898935,'3011','465',378776.36,381005.65,2229.29,367832.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257213',4898936,'3012','465',126729.48,126729.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898937,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898938,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898939,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898940,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898941,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898942,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898943,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257213',4898944,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257213',4898945,'3021','466',452587.59,454959.77,2372.18,960732.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257213',4898946,'3022','466',556091.99,558873.57,2781.58,1126539.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257213',4898947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257213',4898948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898949,'3005','465',266215.87,267451.34,1235.47,203852.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898950,'3006','465',422465.84,424034.82,1568.98,258881.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898951,'3007','465',232234.00,232234.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898952,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898953,'3009','465',150154.39,150154.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898954,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898955,'3011','465',381005.65,381936.42,930.77,153577.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257214',4898956,'3012','465',126729.48,128117.40,1387.92,229006.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898957,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898958,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898959,'3015','465',126000.01,126000.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898960,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898961,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898962,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898963,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257214',4898964,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257214',4898965,'3021','466',454959.77,456290.03,1330.26,538755.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257214',4898966,'3022','466',558873.57,561136.10,2262.53,916324.65,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257214',4898967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257214',4898968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898969,'3005','465',267451.34,267866.51,415.17,68503.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898970,'3006','465',424034.82,424479.12,444.30,73309.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898971,'3007','465',232234.00,232908.03,674.03,111214.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898972,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898973,'3009','465',150154.39,150879.30,724.91,119610.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898974,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898975,'3011','465',381936.42,382711.80,775.38,127937.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257215',4898976,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898977,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898978,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898979,'3015','465',126000.01,126005.62,5.61,925.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898980,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898981,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898982,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898983,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257215',4898984,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257215',4898985,'3021','466',456290.03,458318.01,2027.98,821331.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257215',4898986,'3022','466',561136.10,562117.37,981.27,397414.35,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257215',4898987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257215',4898988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898989,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898990,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898991,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898992,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898993,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898994,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898995,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257216',4898996,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4898997,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4898998,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4898999,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4899000,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4899001,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4899002,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4899003,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257216',4899004,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257216',4899005,'3021','466',458318.01,460712.68,2394.67,969841.35,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257216',4899006,'3022','466',562117.37,565582.08,3464.71,1403207.55,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257216',4899007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257216',4899008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899009,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899010,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899011,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899012,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899013,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899014,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899015,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257217',4899016,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899017,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899018,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899019,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899020,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899021,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899022,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899023,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257217',4899024,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257217',4899025,'3021','466',460712.68,462383.97,1671.29,676872.45,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257217',4899026,'3022','466',565582.08,568850.27,3268.19,1323616.95,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257217',4899027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257217',4899028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899029,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899030,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899031,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899032,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899033,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899034,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899035,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257218',4899036,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899037,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899038,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899039,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899040,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899041,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899042,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899043,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257218',4899044,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257218',4899045,'3021','466',462383.97,465381.77,2997.80,1214109.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257218',4899046,'3022','466',568850.27,571857.48,3007.21,1217920.05,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257218',4899047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257218',4899048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899049,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899050,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899051,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899052,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899053,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899054,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899055,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257219',4899056,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899057,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899058,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899059,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899060,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899061,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899062,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899063,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257219',4899064,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257219',4899065,'3021','466',465381.77,467354.68,1972.91,799028.55,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257219',4899066,'3022','466',571857.48,575973.39,4115.91,1666943.55,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257219',4899067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257219',4899068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899069,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899070,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899071,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899072,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899073,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899074,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899075,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257220',4899076,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899077,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899078,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899079,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899080,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899081,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899082,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899083,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257220',4899084,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257220',4899085,'3021','466',467354.68,470753.25,3398.57,1376420.85,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257220',4899086,'3022','466',575973.39,580757.32,4783.93,1937491.65,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257220',4899087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257220',4899088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899089,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899090,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899091,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899092,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899093,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899094,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899095,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257221',4899096,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899097,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899098,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899099,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899100,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899101,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899102,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899103,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257221',4899104,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257221',4899105,'3021','466',470753.25,474044.98,3291.73,1333150.65,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257221',4899106,'3022','466',580757.32,585915.20,5157.88,2088941.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257221',4899107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257221',4899108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899109,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899110,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899111,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899112,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899113,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899114,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899115,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257222',4899116,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899117,'3013','465',141416.29,141416.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899118,'3014','465',362091.10,362091.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899119,'3015','465',126005.62,126005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899120,'3016','465',263505.99,263505.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899121,'3017','465',77447.79,77447.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899122,'3018','465',205413.69,205413.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899123,'3019','465',236820.55,236820.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257222',4899124,'3020','465',136619.31,136619.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257222',4899125,'3021','466',474044.98,475600.15,1555.17,637619.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257222',4899126,'3022','466',585915.20,589230.46,3315.26,1359256.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257222',4899127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257222',4899128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899129,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899130,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899131,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899132,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899133,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899134,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899135,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257223',4899136,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257223',4899137,'3013','465',141416.29,141420.42,4.13,681.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257223',4899138,'3014','465',362091.10,363761.85,1660.75,274023.75,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257223',4899139,'3015','465',126005.62,126009.68,-5.94,-980.10,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257223',4899140,'3016','465',263505.99,263533.55,17.56,2897.40,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257223',4899141,'3017','465',77447.79,77724.30,276.51,45624.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257223',4899142,'3018','465',205413.69,207274.00,1860.31,306951.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257223',4899143,'3019','465',236820.55,236830.39,9.84,1623.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257223',4899144,'3020','465',136619.31,136622.83,3.52,580.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257223',4899145,'3021','466',475600.15,477217.40,1617.25,663072.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257223',4899146,'3022','466',589230.46,592784.06,3553.60,1456976.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257223',4899147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257223',4899148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899149,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899150,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899151,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899152,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899153,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899154,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899155,'3011','465',382711.80,382711.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257224',4899156,'3012','465',128117.40,128117.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899157,'3013','465',141420.42,143753.31,2332.89,384926.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899158,'3014','465',363761.85,364152.22,390.37,64411.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899159,'3015','465',126009.68,126009.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899160,'3016','465',263533.55,264417.93,884.38,145923.03,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899161,'3017','465',77724.30,80498.04,2773.74,457667.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899162,'3018','465',207274.00,207758.58,484.58,79955.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899163,'3019','465',236830.39,236830.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257224',4899164,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257224',4899165,'3021','466',477217.40,480141.61,2924.21,1198926.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257224',4899166,'3022','466',592784.06,597421.94,4637.88,1901530.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257224',4899167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257224',4899168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899169,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899170,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899171,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899172,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899173,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899174,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899175,'3011','465',382711.80,386087.80,3376.00,557040.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257225',4899176,'3012','465',128117.40,131701.39,3583.99,591358.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899177,'3013','465',143753.31,145012.19,1258.88,207715.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899178,'3014','465',364152.22,366540.87,2388.65,394127.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899179,'3015','465',126009.68,126009.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899180,'3016','465',264417.93,264417.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899181,'3017','465',80498.04,80498.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899182,'3018','465',207758.58,207758.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899183,'3019','465',236830.39,236830.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257225',4899184,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257225',4899185,'3021','466',480141.61,482745.52,2603.91,1067603.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257225',4899186,'3022','466',597421.94,600269.67,2847.73,1167569.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257225',4899187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257225',4899188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899189,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899190,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899191,'3007','465',232908.03,232908.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899192,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899193,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899194,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899195,'3011','465',386087.80,386087.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257226',4899196,'3012','465',131701.39,131701.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899197,'3013','465',145012.19,147280.75,2268.56,374312.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899198,'3014','465',366540.87,368332.77,1791.90,295663.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899199,'3015','465',126009.68,126009.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899200,'3016','465',264417.93,264417.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899201,'3017','465',80498.04,82719.98,2221.94,366620.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899202,'3018','465',207758.58,211008.87,3250.29,536297.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899203,'3019','465',236830.39,236830.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257226',4899204,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257226',4899205,'3021','466',482745.52,485677.58,2932.06,1202144.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257226',4899206,'3022','466',600269.67,604615.91,4346.24,1781958.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257226',4899207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257226',4899208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899209,'3005','465',267866.51,267866.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899210,'3006','465',424479.12,424479.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899211,'3007','465',232908.03,235452.96,2544.93,419913.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899212,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899213,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899214,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899215,'3011','465',386087.80,386087.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257227',4899216,'3012','465',131701.39,131701.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899217,'3013','465',147280.75,147280.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899218,'3014','465',368332.77,368332.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899219,'3015','465',126009.68,129385.59,3375.91,557025.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899220,'3016','465',264417.93,267852.60,3434.67,566720.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899221,'3017','465',82719.98,82719.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899222,'3018','465',211008.87,211008.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899223,'3019','465',236830.39,236830.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257227',4899224,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257227',4899225,'3021','466',485677.58,488882.56,3204.98,1314041.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257227',4899226,'3022','466',604615.91,608055.43,3439.52,1410203.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257227',4899227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257227',4899228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899229,'3005','465',267866.51,269062.05,1195.54,197264.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899230,'3006','465',424479.12,425690.24,1211.12,199834.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899231,'3007','465',235452.96,235452.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899232,'3008','465',267475.50,267475.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899233,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899234,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899235,'3011','465',386087.80,387406.57,1318.77,217597.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257228',4899236,'3012','465',131701.39,132942.24,1240.85,204740.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899237,'3013','465',147280.75,148173.08,892.33,147234.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899238,'3014','465',368332.77,369445.46,1112.69,183593.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899239,'3015','465',129385.59,129385.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899240,'3016','465',267852.60,267885.82,33.22,5481.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899241,'3017','465',82719.98,82719.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899242,'3018','465',211008.87,211008.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899243,'3019','465',236830.39,236830.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257228',4899244,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257228',4899245,'3021','466',488882.56,489910.61,1028.05,421500.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257228',4899246,'3022','466',608055.43,611073.46,3018.03,1237392.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257228',4899247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257228',4899248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899249,'3005','465',269062.05,269062.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899250,'3006','465',425690.24,428062.09,2371.85,391355.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899251,'3007','465',235452.96,236209.09,756.13,124761.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899252,'3008','465',267475.50,267952.78,477.28,78751.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899253,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899254,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899255,'3011','465',387406.57,387667.22,260.65,43007.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257229',4899256,'3012','465',132942.24,135484.97,2542.73,419550.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899257,'3013','465',148173.08,148707.26,534.18,88139.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899258,'3014','465',369445.46,370683.49,1238.03,204274.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899259,'3015','465',129385.59,129385.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899260,'3016','465',267885.82,267885.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899261,'3017','465',82719.98,82719.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899262,'3018','465',211008.87,211008.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899263,'3019','465',236830.39,236830.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257229',4899264,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257229',4899265,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257229',4899266,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257229',4899267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257229',4899268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899269,'3005','465',269062.05,269062.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899270,'3006','465',428062.09,430403.72,2341.63,386368.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899271,'3007','465',236209.09,238135.18,1926.09,317804.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899272,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899273,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899274,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899275,'3011','465',387667.22,389770.80,2103.58,347090.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257230',4899276,'3012','465',135484.97,135484.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899277,'3013','465',148707.26,150842.47,2135.21,352309.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899278,'3014','465',370683.49,370683.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899279,'3015','465',129385.59,129385.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899280,'3016','465',267885.82,270565.74,2679.92,442186.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899281,'3017','465',82719.98,82719.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899282,'3018','465',211008.87,211008.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899283,'3019','465',236830.39,238734.37,1903.98,314156.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257230',4899284,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257230',4899285,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257230',4899286,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257230',4899287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257230',4899288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899289,'3005','465',269062.05,269062.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899290,'3006','465',430403.72,433354.73,2951.01,486916.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899291,'3007','465',238135.18,238135.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899292,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899293,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899294,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899295,'3011','465',389770.80,392940.98,3170.18,523079.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257231',4899296,'3012','465',135484.97,135772.94,287.97,47515.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899297,'3013','465',150842.47,150842.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899298,'3014','465',370683.49,370683.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899299,'3015','465',129385.59,132627.74,3242.15,534954.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899300,'3016','465',270565.74,270565.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899301,'3017','465',82719.98,82719.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899302,'3018','465',211008.87,213657.18,2648.31,436971.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899303,'3019','465',238734.37,238734.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257231',4899304,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257231',4899305,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257231',4899306,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257231',4899307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257231',4899308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899309,'3005','465',269062.05,269177.69,115.64,19080.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899310,'3006','465',433354.73,434920.08,1565.35,258282.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899311,'3007','465',238135.18,239667.69,1532.51,252864.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899312,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899313,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899314,'3010','465',225881.45,225881.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899315,'3011','465',392940.98,394824.86,1883.88,310840.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257232',4899316,'3012','465',135772.94,135832.34,59.40,9801.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899317,'3013','465',150842.47,150842.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899318,'3014','465',370683.49,372635.08,1951.59,322012.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899319,'3015','465',132627.74,132627.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899320,'3016','465',270565.74,272288.13,1722.39,284194.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899321,'3017','465',82719.98,82719.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899322,'3018','465',213657.18,215371.59,1714.41,282877.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899323,'3019','465',238734.37,238734.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257232',4899324,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257232',4899325,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257232',4899326,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257232',4899327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257232',4899328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899329,'3005','465',269177.69,269177.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899330,'3006','465',434920.08,436913.67,1993.59,328942.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899331,'3007','465',239667.69,241717.67,2049.98,338246.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899332,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899333,'3009','465',150879.30,150879.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899334,'3010','465',225881.45,225926.90,45.45,7499.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899335,'3011','465',394824.86,396929.49,2104.63,347263.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257233',4899336,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899337,'3013','465',150842.47,150842.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899338,'3014','465',372635.08,374870.15,2235.07,368786.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899339,'3015','465',132627.74,132627.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899340,'3016','465',272288.13,274203.86,1915.73,316095.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899341,'3017','465',82719.98,84668.40,1948.42,321489.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899342,'3018','465',215371.59,215371.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899343,'3019','465',238734.37,239027.03,292.66,48288.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257233',4899344,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257233',4899345,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257233',4899346,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257233',4899347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257233',4899348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899349,'3005','465',269177.69,271558.06,2380.37,392761.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899350,'3006','465',436913.67,436913.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899351,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899352,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899353,'3009','465',150879.30,153557.63,2678.33,441924.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899354,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899355,'3011','465',396929.49,396929.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257234',4899356,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899357,'3013','465',150842.47,153127.37,2284.90,377008.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899358,'3014','465',374870.15,374870.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899359,'3015','465',132627.74,132627.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899360,'3016','465',274203.86,274203.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899361,'3017','465',84668.40,86667.44,1999.04,329841.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899362,'3018','465',215371.59,215371.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899363,'3019','465',239027.03,239157.13,130.10,21466.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257234',4899364,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257234',4899365,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257234',4899366,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257234',4899367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257234',4899368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899369,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899370,'3006','465',436913.67,440725.53,3811.86,628956.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899371,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899372,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899373,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899374,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899375,'3011','465',396929.49,400688.47,3758.98,620231.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257235',4899376,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899377,'3013','465',153127.37,153127.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899378,'3014','465',374870.15,374870.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899379,'3015','465',132627.74,132627.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899380,'3016','465',274203.86,276927.07,2723.21,449329.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899381,'3017','465',86667.44,86667.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899382,'3018','465',215371.59,216049.41,677.82,111840.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899383,'3019','465',239157.13,239157.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257235',4899384,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257235',4899385,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257235',4899386,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257235',4899387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257235',4899388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899389,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899390,'3006','465',440725.53,441816.53,1091.00,180015.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899391,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899392,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899393,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899394,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899395,'3011','465',400688.47,401680.95,992.48,163759.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257236',4899396,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899397,'3013','465',153127.37,153127.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899398,'3014','465',374870.15,374870.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899399,'3015','465',132627.74,132627.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899400,'3016','465',276927.07,276927.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899401,'3017','465',86667.44,86667.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899402,'3018','465',216049.41,217205.25,1155.84,190713.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899403,'3019','465',239157.13,239157.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257236',4899404,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257236',4899405,'3021','466',489910.61,489910.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257236',4899406,'3022','466',611073.46,611073.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257236',4899407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257236',4899408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899409,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899410,'3006','465',441816.53,442250.43,433.90,71593.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899411,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899412,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899413,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899414,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899415,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257237',4899416,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899417,'3013','465',153127.37,153127.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899418,'3014','465',374870.15,376625.34,1755.19,289606.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899419,'3015','465',132627.74,134564.25,1936.51,319524.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899420,'3016','465',276927.07,276945.25,18.18,2999.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899421,'3017','465',86667.44,86667.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899422,'3018','465',217205.25,219307.05,2101.80,346797.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899423,'3019','465',239157.13,240520.92,1363.79,225025.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257237',4899424,'3020','465',136622.83,136622.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257237',4899425,'3021','466',489910.61,491292.41,1381.80,580356.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257237',4899426,'3022','466',611073.46,612472.84,1399.38,587739.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257237',4899427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257237',4899428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899429,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899430,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899431,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899432,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899433,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899434,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899435,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257238',4899436,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899437,'3013','465',153127.37,155685.66,2558.29,422117.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899438,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899439,'3015','465',134564.25,135499.79,925.54,152714.10,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257238',4899440,'3016','465',276945.25,277501.73,556.48,91819.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899441,'3017','465',86667.44,88352.91,1685.47,278102.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899442,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899443,'3019','465',240520.92,242475.38,1954.46,322485.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257238',4899444,'3020','465',136622.83,136934.21,311.38,51377.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257238',4899445,'3021','466',491292.41,492358.81,1066.40,458552.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257238',4899446,'3022','466',612472.84,614940.76,2467.92,1061205.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257238',4899447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257238',4899448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899449,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899450,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899451,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899452,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899453,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899454,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899455,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257239',4899456,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899457,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899458,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899459,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899460,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899461,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899462,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899463,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257239',4899464,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257239',4899465,'3021','466',492358.81,494600.40,2241.59,963883.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257239',4899466,'3022','466',614940.76,616534.27,1593.51,685209.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257239',4899467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257239',4899468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899469,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899470,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899471,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899472,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899473,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899474,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899475,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257240',4899476,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899477,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899478,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899479,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899480,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899481,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899482,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899483,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257240',4899484,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257240',4899485,'3021','466',494600.40,497283.48,2683.08,1153724.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257240',4899486,'3022','466',616534.27,618914.29,2380.02,1023408.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257240',4899487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257240',4899488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899489,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899490,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899491,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899492,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899493,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899494,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899495,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257241',4899496,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899497,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899498,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899499,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899500,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899501,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899502,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899503,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257241',4899504,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257241',4899505,'3021','466',497283.48,505011.78,7728.30,3323169.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257241',4899506,'3022','466',618914.29,627007.23,8092.94,3479964.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257241',4899507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257241',4899508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899509,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899510,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899511,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899512,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899513,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899514,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899515,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257242',4899516,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899517,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899518,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899519,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899520,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899521,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899522,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899523,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257242',4899524,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257242',4899525,'3021','466',505011.78,513305.12,8293.34,3814936.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257242',4899526,'3022','466',627007.23,635841.42,8834.19,4063727.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257242',4899527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257242',4899528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899529,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899530,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899531,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899532,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899533,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899534,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899535,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257243',4899536,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899537,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899538,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899539,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899540,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899541,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899542,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899543,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257243',4899544,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257243',4899545,'3021','466',513305.12,520270.19,6965.07,3203932.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257243',4899546,'3022','466',635841.42,643858.52,8017.10,3687866.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257243',4899547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257243',4899548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899549,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899550,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899551,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899552,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899553,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899554,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899555,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257244',4899556,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899557,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899558,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899559,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899560,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899561,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899562,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899563,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257244',4899564,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257244',4899565,'3021','466',520270.19,527425.22,7155.03,3577515.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257244',4899566,'3022','466',643858.52,650058.56,6200.04,3100020.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257244',4899567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257244',4899568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899569,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899570,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899571,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899572,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899573,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899574,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899575,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257245',4899576,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899577,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899578,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899579,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899580,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899581,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899582,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899583,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257245',4899584,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257245',4899585,'3021','466',527425.22,532445.24,5020.02,2510010.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257245',4899586,'3022','466',650058.56,657364.96,7306.40,3653200.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257245',4899587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257245',4899588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899589,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899590,'3006','465',442250.43,442250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899591,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899592,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899593,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899594,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899595,'3011','465',401680.95,401680.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257246',4899596,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899597,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899598,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899599,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899600,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899601,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899602,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899603,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257246',4899604,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257246',4899605,'3021','466',532445.24,533312.23,866.99,433495.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257246',4899606,'3022','466',657364.96,659383.77,2018.81,1009405.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257246',4899607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257246',4899608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899609,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899610,'3006','465',442250.43,446537.81,4287.38,707417.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899611,'3007','465',241717.67,241717.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899612,'3008','465',267952.78,267952.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899613,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899614,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899615,'3011','465',401680.95,405875.75,4194.80,692142.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257247',4899616,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899617,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899618,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899619,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899620,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899621,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899622,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899623,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257247',4899624,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257247',4899625,'3021','466',533312.23,534796.56,1484.33,742165.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257247',4899626,'3022','466',659383.77,662923.95,3540.18,1770090.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257247',4899627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257247',4899628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899629,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899630,'3006','465',446537.81,448511.65,1973.84,325683.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899631,'3007','465',241717.67,243951.98,2234.31,368661.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899632,'3008','465',267952.78,268113.92,161.14,26588.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899633,'3009','465',153557.63,153557.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899634,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899635,'3011','465',405875.75,408077.30,2201.55,363255.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257248',4899636,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899637,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899638,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899639,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899640,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899641,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899642,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899643,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257248',4899644,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257248',4899645,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257248',4899646,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257248',4899647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257248',4899648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899649,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899650,'3006','465',448511.65,450253.44,1741.79,287395.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899651,'3007','465',243951.98,243951.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899652,'3008','465',268113.92,268113.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899653,'3009','465',153557.63,155083.14,1525.51,251709.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899654,'3010','465',225926.90,225926.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899655,'3011','465',408077.30,409651.85,1574.55,259800.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257249',4899656,'3012','465',135832.34,135832.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899657,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899658,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899659,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899660,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899661,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899662,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899663,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257249',4899664,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257249',4899665,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257249',4899666,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257249',4899667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257249',4899668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899669,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899670,'3006','465',450253.44,451730.44,1477.00,243705.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899671,'3007','465',243951.98,243951.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899672,'3008','465',268113.92,268156.34,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899673,'3009','465',155083.14,155083.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899674,'3010','465',225926.90,227253.43,1326.53,218877.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899675,'3011','465',409651.85,409651.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257250',4899676,'3012','465',135832.34,137298.41,1466.07,241901.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899677,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899678,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899679,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899680,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899681,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899682,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899683,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257250',4899684,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257250',4899685,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257250',4899686,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257250',4899687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257250',4899688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899689,'3005','465',271558.06,271558.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899690,'3006','465',451730.44,453112.20,1381.76,227990.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899691,'3007','465',243951.98,243951.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899692,'3008','465',268156.34,268156.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899693,'3009','465',155083.14,155083.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899694,'3010','465',227253.43,227253.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899695,'3011','465',409651.85,411123.15,1471.30,242764.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257251',4899696,'3012','465',137298.41,137298.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899697,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899698,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899699,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899700,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899701,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899702,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899703,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257251',4899704,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257251',4899705,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257251',4899706,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257251',4899707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257251',4899708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899709,'3005','465',271558.06,273240.17,1682.11,277548.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899710,'3006','465',453112.20,453112.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899711,'3007','465',243951.98,245571.84,1619.86,267276.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899712,'3008','465',268156.34,268156.46,0.12,19.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899713,'3009','465',155083.14,155083.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899714,'3010','465',227253.43,227253.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899715,'3011','465',411123.15,411123.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257252',4899716,'3012','465',137298.41,139284.79,1986.38,327752.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899717,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899718,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899719,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899720,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899721,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899722,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899723,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257252',4899724,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257252',4899725,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257252',4899726,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257252',4899727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257252',4899728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899729,'3005','465',273240.17,273240.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899730,'3006','465',453112.20,454641.03,1528.83,252256.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899731,'3007','465',245571.84,245726.66,154.82,25545.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899732,'3008','465',268156.46,268156.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899733,'3009','465',155083.14,155083.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899734,'3010','465',227253.43,227253.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899735,'3011','465',411123.15,411123.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257253',4899736,'3012','465',139284.79,140656.48,1371.69,226328.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899737,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899738,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899739,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899740,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899741,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899742,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899743,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257253',4899744,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257253',4899745,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257253',4899746,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257253',4899747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257253',4899748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899749,'3005','465',273240.17,275045.95,1805.78,297953.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899750,'3006','465',454641.03,454641.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899751,'3007','465',245726.66,245726.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899752,'3008','465',268156.46,268156.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899753,'3009','465',155083.14,155083.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899754,'3010','465',227253.43,227253.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899755,'3011','465',411123.15,412894.00,1770.85,292190.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257254',4899756,'3012','465',140656.48,140656.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899757,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899758,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899759,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899760,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899761,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899762,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899763,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257254',4899764,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257254',4899765,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257254',4899766,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257254',4899767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257254',4899768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899769,'3005','465',275045.95,275830.18,784.23,129397.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899770,'3006','465',454641.03,455402.33,761.30,125614.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899771,'3007','465',245726.66,246611.58,884.92,146011.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899772,'3008','465',268156.46,268869.86,713.40,117711.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899773,'3009','465',155083.14,155958.69,875.55,144465.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899774,'3010','465',227253.43,227692.84,439.41,72502.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899775,'3011','465',412894.00,413585.20,691.20,114048.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257255',4899776,'3012','465',140656.48,141249.50,593.02,97848.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899777,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899778,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899779,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899780,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899781,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899782,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899783,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257255',4899784,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257255',4899785,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257255',4899786,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257255',4899787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257255',4899788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899789,'3005','465',275830.18,276939.19,1109.01,182986.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899790,'3006','465',455402.33,456719.03,1316.70,217255.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899791,'3007','465',246611.58,247919.69,1308.11,215838.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899792,'3008','465',268869.86,268869.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899793,'3009','465',155958.69,155958.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899794,'3010','465',227692.84,229211.99,1519.15,250659.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899795,'3011','465',413585.20,415112.52,1527.32,252007.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257256',4899796,'3012','465',141249.50,141249.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899797,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899798,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899799,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899800,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899801,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899802,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899803,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257256',4899804,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257256',4899805,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257256',4899806,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257256',4899807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257256',4899808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899809,'3005','465',276939.19,276939.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899810,'3006','465',456719.03,458863.60,2144.57,353854.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899811,'3007','465',247919.69,247919.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899812,'3008','465',268869.86,270808.39,1938.53,319857.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899813,'3009','465',155958.69,157457.41,1498.72,247288.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899814,'3010','465',229211.99,230377.85,1165.86,192366.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899815,'3011','465',415112.52,417031.63,1919.11,316653.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257257',4899816,'3012','465',141249.50,141249.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899817,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899818,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899819,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899820,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899821,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899822,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899823,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257257',4899824,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257257',4899825,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257257',4899826,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257257',4899827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257257',4899828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899829,'3005','465',276939.19,279212.03,2272.84,375018.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899830,'3006','465',458863.60,459040.86,177.26,29247.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899831,'3007','465',247919.69,248287.64,367.95,60711.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899832,'3008','465',270808.39,272770.50,1962.11,323748.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899833,'3009','465',157457.41,159422.37,1964.96,324218.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899834,'3010','465',230377.85,230569.76,191.91,31665.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899835,'3011','465',417031.63,419296.18,2264.55,373650.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257258',4899836,'3012','465',141249.50,141276.07,26.57,4384.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899837,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899838,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899839,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899840,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899841,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899842,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899843,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257258',4899844,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257258',4899845,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257258',4899846,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257258',4899847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257258',4899848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899849,'3005','465',279212.03,279212.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899850,'3006','465',459040.86,461846.75,2805.89,462971.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899851,'3007','465',248287.64,251446.75,3159.11,521253.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899852,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899853,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899854,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899855,'3011','465',419296.18,423207.05,3910.87,645293.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257259',4899856,'3012','465',141276.07,141276.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899857,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899858,'3014','465',376625.34,376625.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899859,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899860,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899861,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899862,'3018','465',219307.05,219307.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899863,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257259',4899864,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257259',4899865,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257259',4899866,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257259',4899867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257259',4899868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257260',4899869,'3005','465',279212.03,281899.35,2687.32,443407.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257260',4899870,'3006','465',461846.75,461886.75,0.00,0.00,0.00,0.00,40.00,0.00,0.00),('1','195','1019','257260',4899871,'3007','465',251446.75,251456.26,-0.49,-80.85,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257260',4899872,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257260',4899873,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257260',4899874,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257260',4899875,'3011','465',423207.05,423207.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257260',4899876,'3012','465',141276.07,144917.38,3631.31,599166.15,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257260',4899877,'3013','465',155685.66,155685.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257260',4899878,'3014','465',376625.34,379386.85,2751.51,453999.15,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257260',4899879,'3015','465',135499.79,135499.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257260',4899880,'3016','465',277501.73,277501.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257260',4899881,'3017','465',88352.91,88352.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257260',4899882,'3018','465',219307.05,222553.88,3236.83,534076.95,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257260',4899883,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257260',4899884,'3020','465',136934.21,136934.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257260',4899885,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257260',4899886,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257260',4899887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257260',4899888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899889,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899890,'3006','465',461886.75,463328.07,1441.32,237817.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899891,'3007','465',251456.26,252722.99,1266.73,209010.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899892,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899893,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899894,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899895,'3011','465',423207.05,424541.06,1334.01,220111.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257261',4899896,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899897,'3013','465',155685.66,158055.80,2370.14,391073.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899898,'3014','465',379386.85,380360.67,973.82,160680.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899899,'3015','465',135499.79,138300.13,2800.34,462056.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899900,'3016','465',277501.73,277522.81,21.08,3478.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899901,'3017','465',88352.91,88924.84,571.93,94368.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899902,'3018','465',222553.88,225118.32,2564.44,423132.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899903,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257261',4899904,'3020','465',136934.21,138240.59,1306.38,215552.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257261',4899905,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257261',4899906,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257261',4899907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257261',4899908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899909,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899910,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899911,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899912,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899913,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899914,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899915,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257262',4899916,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899917,'3013','465',158055.80,158055.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899918,'3014','465',380360.67,383348.80,2988.13,493041.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899919,'3015','465',138300.13,140669.89,2369.76,391010.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899920,'3016','465',277522.81,277522.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899921,'3017','465',88924.84,90715.50,1790.66,295458.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899922,'3018','465',225118.32,226334.02,1215.70,200590.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899923,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257262',4899924,'3020','465',138240.59,140243.29,2002.70,330445.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257262',4899925,'3021','466',534796.56,534796.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257262',4899926,'3022','466',662923.95,662923.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257262',4899927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257262',4899928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899929,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899930,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899931,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899932,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899933,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899934,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899935,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257263',4899936,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899937,'3013','465',158055.80,160018.02,1962.22,323766.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899938,'3014','465',383348.80,385202.95,1854.15,305934.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899939,'3015','465',140669.89,143143.06,2473.17,408073.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899940,'3016','465',277522.81,277522.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899941,'3017','465',90715.50,92703.80,1988.30,328069.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899942,'3018','465',226334.02,228213.31,1879.29,310082.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899943,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257263',4899944,'3020','465',140243.29,142362.51,2119.22,349671.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257263',4899945,'3021','466',534796.56,536020.90,1224.34,795821.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257263',4899946,'3022','466',662923.95,665372.76,2448.81,1591726.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257263',4899947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257263',4899948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899949,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899950,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899951,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899952,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899953,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899954,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899955,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257264',4899956,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899957,'3013','465',160018.02,161470.44,1452.42,239649.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899958,'3014','465',385202.95,385202.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899959,'3015','465',143143.06,144315.60,1172.54,193469.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899960,'3016','465',277522.81,277537.97,15.16,2501.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899961,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899962,'3018','465',228213.31,229730.78,1517.47,250382.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899963,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257264',4899964,'3020','465',142362.51,143521.84,1159.33,191289.45,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257264',4899965,'3021','466',536020.90,539563.35,3542.45,2302592.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257264',4899966,'3022','466',665372.76,668764.08,3391.32,2204358.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257264',4899967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257264',4899968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899969,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899970,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899971,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899972,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899973,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899974,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899975,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257265',4899976,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899977,'3013','465',161470.44,162710.43,1239.99,204598.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899978,'3014','465',385202.95,386189.75,986.80,162822.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899979,'3015','465',144315.60,145308.29,992.69,163793.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899980,'3016','465',277537.97,277571.32,33.35,5502.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899981,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899982,'3018','465',229730.78,231250.91,1499.65,247442.25,0.00,0.00,20.48,0.00,0.00),('1','195','1020','257265',4899983,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257265',4899984,'3020','465',143521.84,144392.14,870.30,143599.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257265',4899985,'3021','466',539563.35,543870.04,4306.69,2799348.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257265',4899986,'3022','466',668764.08,674284.56,5520.48,3588312.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257265',4899987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257265',4899988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899989,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899990,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899991,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899992,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899993,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899994,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899995,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257266',4899996,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4899997,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4899998,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4899999,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4900000,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4900001,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4900002,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4900003,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257266',4900004,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257266',4900005,'3021','466',543870.04,546346.14,2476.10,1609465.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257266',4900006,'3022','466',674284.56,676093.86,1809.30,1176045.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257266',4900007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257266',4900008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900009,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900010,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900011,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900012,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900013,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900014,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900015,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257267',4900016,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900017,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900018,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900019,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900020,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900021,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900022,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900023,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257267',4900024,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257267',4900025,'3021','466',546346.14,549727.34,3381.20,2197780.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257267',4900026,'3022','466',676093.86,678889.27,2795.41,1817016.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257267',4900027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257267',4900028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900029,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900030,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900031,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900032,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900033,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900034,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900035,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257268',4900036,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900037,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900038,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900039,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900040,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900041,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900042,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900043,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257268',4900044,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257268',4900045,'3021','466',549727.34,553280.50,3553.16,2309554.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257268',4900046,'3022','466',678889.27,682892.32,4003.05,2601982.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257268',4900047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257268',4900048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900049,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900050,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900051,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900052,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900053,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900054,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900055,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257269',4900056,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900057,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900058,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900059,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900060,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900061,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900062,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900063,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257269',4900064,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257269',4900065,'3021','466',553280.50,554419.50,1139.00,763130.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257269',4900066,'3022','466',682892.32,683674.98,782.66,524382.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257269',4900067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257269',4900068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900069,'3005','465',281899.35,281899.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900070,'3006','465',463328.07,463328.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900071,'3007','465',252722.99,252722.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900072,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900073,'3009','465',159422.37,159422.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900074,'3010','465',230569.76,230569.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900075,'3011','465',424541.06,424541.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257270',4900076,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900077,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900078,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900079,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900080,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900081,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900082,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900083,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257270',4900084,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257270',4900085,'3021','466',554419.50,555383.67,964.17,645993.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257270',4900086,'3022','466',683674.98,685250.49,1575.51,1055591.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257270',4900087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257270',4900088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900089,'3005','465',281899.35,285887.82,3988.47,658097.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900090,'3006','465',463328.07,466367.25,3039.18,501464.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900091,'3007','465',252722.99,256205.49,3482.50,574612.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900092,'3008','465',272770.50,272770.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900093,'3009','465',159422.37,162643.43,3221.06,531474.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900094,'3010','465',230569.76,234308.16,3738.40,616836.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900095,'3011','465',424541.06,428766.11,4225.05,697133.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257271',4900096,'3012','465',144917.38,144917.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900097,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900098,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900099,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900100,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900101,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900102,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900103,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257271',4900104,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257271',4900105,'3021','466',555383.67,557368.47,1984.80,1329816.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257271',4900106,'3022','466',685250.49,686657.81,1407.32,942904.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257271',4900107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257271',4900108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900109,'3005','465',285887.82,289237.37,3349.55,552675.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900110,'3006','465',466367.25,467987.79,1620.54,267389.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900111,'3007','465',256205.49,256291.21,85.72,14143.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900112,'3008','465',272770.50,276531.55,3761.05,620573.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900113,'3009','465',162643.43,162643.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900114,'3010','465',234308.16,237439.76,3131.60,516714.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900115,'3011','465',428766.11,428766.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257272',4900116,'3012','465',144917.38,148960.11,4042.73,667050.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900117,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900118,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900119,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900120,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900121,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900122,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900123,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257272',4900124,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257272',4900125,'3021','466',557368.47,558969.56,1601.09,1072730.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257272',4900126,'3022','466',686657.81,688675.81,2018.00,1352060.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257272',4900127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257272',4900128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900129,'3005','465',289237.37,292081.10,2843.73,469215.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900130,'3006','465',467987.79,467987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900131,'3007','465',256291.21,258318.68,2027.47,334532.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900132,'3008','465',276531.55,278507.22,1975.67,325985.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900133,'3009','465',162643.43,162643.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900134,'3010','465',237439.76,239922.09,2482.33,409584.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900135,'3011','465',428766.11,431597.05,2830.94,467105.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257273',4900136,'3012','465',148960.11,148960.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900137,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900138,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900139,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900140,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900141,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900142,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900143,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257273',4900144,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257273',4900145,'3021','466',558969.56,560242.00,1272.44,852534.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257273',4900146,'3022','466',688675.81,690826.34,2150.53,1440855.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257273',4900147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257273',4900148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900149,'3005','465',292081.10,292081.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900150,'3006','465',467987.79,467987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900151,'3007','465',258318.68,258318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900152,'3008','465',278507.22,278507.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900153,'3009','465',162643.43,162643.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900154,'3010','465',239922.09,239922.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900155,'3011','465',431597.05,431597.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257274',4900156,'3012','465',148960.11,148960.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900157,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900158,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900159,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900160,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900161,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900162,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900163,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257274',4900164,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257274',4900165,'3021','466',560242.00,561956.91,1714.91,1148989.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257274',4900166,'3022','466',690826.34,694708.65,3882.31,2601147.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257274',4900167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257274',4900168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900169,'3005','465',292081.10,292081.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900170,'3006','465',467987.79,467987.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900171,'3007','465',258318.68,258318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900172,'3008','465',278507.22,278507.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900173,'3009','465',162643.43,162643.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900174,'3010','465',239922.09,239922.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900175,'3011','465',431597.05,431597.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257275',4900176,'3012','465',148960.11,148960.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900177,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900178,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900179,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900180,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900181,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900182,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900183,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257275',4900184,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257275',4900185,'3021','466',561956.91,563649.71,1692.80,1134176.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257275',4900186,'3022','466',694708.65,697147.85,2439.20,1634264.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257275',4900187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257275',4900188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900189,'3005','465',292081.10,293725.41,1644.31,271311.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900190,'3006','465',467987.79,469946.18,1958.39,323134.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900191,'3007','465',258318.68,258318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900192,'3008','465',278507.22,281008.75,2501.53,412752.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900193,'3009','465',162643.43,162643.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900194,'3010','465',239922.09,242460.49,2538.40,418836.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900195,'3011','465',431597.05,431597.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257276',4900196,'3012','465',148960.11,151392.71,2432.60,401379.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900197,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900198,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900199,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900200,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900201,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900202,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900203,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257276',4900204,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257276',4900205,'3021','466',563649.71,564013.91,364.20,244014.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257276',4900206,'3022','466',697147.85,698969.68,1821.83,1220626.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257276',4900207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257276',4900208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900209,'3005','465',293725.41,295639.49,1914.08,315823.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900210,'3006','465',469946.18,472977.94,3031.76,500240.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900211,'3007','465',258318.68,258318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900212,'3008','465',281008.75,284413.56,3404.81,561793.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900213,'3009','465',162643.43,163896.06,1252.63,206683.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900214,'3010','465',242460.49,245364.56,2904.07,479171.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900215,'3011','465',431597.05,435016.24,3419.19,564166.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257277',4900216,'3012','465',151392.71,151392.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900217,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900218,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900219,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900220,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900221,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900222,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900223,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257277',4900224,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257277',4900225,'3021','466',564013.91,565829.64,1815.73,1216539.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257277',4900226,'3022','466',698969.68,701790.45,2820.77,1889915.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257277',4900227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257277',4900228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900229,'3005','465',295639.49,298038.61,2399.12,395854.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900230,'3006','465',472977.94,475253.10,2275.16,375401.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900231,'3007','465',258318.68,260485.72,2167.04,357561.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900232,'3008','465',284413.56,286665.16,2251.60,371514.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900233,'3009','465',163896.06,166922.94,3026.88,499435.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900234,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900235,'3011','465',435016.24,435016.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257278',4900236,'3012','465',151392.71,153836.72,2444.01,403261.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900237,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900238,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900239,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900240,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900241,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900242,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900243,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257278',4900244,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257278',4900245,'3021','466',565829.64,569088.36,3258.72,2183342.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257278',4900246,'3022','466',701790.45,703113.18,1322.73,886229.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257278',4900247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257278',4900248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900249,'3005','465',298038.61,299229.28,1190.67,196460.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900250,'3006','465',475253.10,476465.46,1212.36,200039.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900251,'3007','465',260485.72,262097.28,1611.56,265907.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900252,'3008','465',286665.16,286665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900253,'3009','465',166922.94,168182.74,1259.80,207867.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900254,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900255,'3011','465',435016.24,436340.13,1323.89,218441.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257279',4900256,'3012','465',153836.72,155134.22,1297.50,214087.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900257,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900258,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900259,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900260,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900261,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900262,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900263,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257279',4900264,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257279',4900265,'3021','466',569088.36,571639.98,2551.62,1709585.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257279',4900266,'3022','466',703113.18,704714.16,1600.98,1072656.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257279',4900267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257279',4900268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900269,'3005','465',299229.28,299229.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900270,'3006','465',476465.46,476465.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900271,'3007','465',262097.28,262097.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900272,'3008','465',286665.16,286665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900273,'3009','465',168182.74,168182.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900274,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900275,'3011','465',436340.13,436340.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257280',4900276,'3012','465',155134.22,155134.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900277,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900278,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900279,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900280,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900281,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900282,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900283,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257280',4900284,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257280',4900285,'3021','466',571639.98,573122.58,1482.60,993342.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257280',4900286,'3022','466',704714.16,706728.06,2013.90,1349313.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257280',4900287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257280',4900288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900289,'3005','465',299229.28,299229.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900290,'3006','465',476465.46,476465.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900291,'3007','465',262097.28,262097.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900292,'3008','465',286665.16,286665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900293,'3009','465',168182.74,168182.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900294,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900295,'3011','465',436340.13,436340.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257281',4900296,'3012','465',155134.22,155134.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900297,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900298,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900299,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900300,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900301,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900302,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900303,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257281',4900304,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257281',4900305,'3021','466',573122.58,575001.92,1879.34,1259157.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257281',4900306,'3022','466',706728.06,709636.42,2908.36,1948601.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257281',4900307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257281',4900308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900309,'3005','465',299229.28,299229.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900310,'3006','465',476465.46,476465.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900311,'3007','465',262097.28,262097.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900312,'3008','465',286665.16,286665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900313,'3009','465',168182.74,168182.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900314,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900315,'3011','465',436340.13,436340.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257282',4900316,'3012','465',155134.22,155134.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900317,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900318,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900319,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900320,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900321,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900322,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900323,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257282',4900324,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257282',4900325,'3021','466',575001.92,576513.07,1511.15,1012470.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257282',4900326,'3022','466',709636.42,710852.37,1215.95,814686.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257282',4900327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257282',4900328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900329,'3005','465',299229.28,299229.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900330,'3006','465',476465.46,476465.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900331,'3007','465',262097.28,262097.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900332,'3008','465',286665.16,286665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900333,'3009','465',168182.74,168182.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900334,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900335,'3011','465',436340.13,436340.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257283',4900336,'3012','465',155134.22,155134.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900337,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900338,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900339,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900340,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900341,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900342,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900343,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257283',4900344,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257283',4900345,'3021','466',576513.07,577610.40,1097.33,735211.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257283',4900346,'3022','466',710852.37,712501.63,1649.26,1105004.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257283',4900347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257283',4900348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900349,'3005','465',299229.28,299229.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900350,'3006','465',476465.46,476465.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900351,'3007','465',262097.28,262097.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900352,'3008','465',286665.16,286665.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900353,'3009','465',168182.74,168182.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900354,'3010','465',245364.56,245364.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900355,'3011','465',436340.13,436340.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257284',4900356,'3012','465',155134.22,155134.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900357,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900358,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900359,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900360,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900361,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900362,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900363,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257284',4900364,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257284',4900365,'3021','466',577610.40,579708.33,2097.93,1405613.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257284',4900366,'3022','466',712501.63,714046.92,1545.29,1035344.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257284',4900367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257284',4900368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257285',4900369,'3005','465',299229.28,302220.38,2981.10,491881.50,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257285',4900370,'3006','465',476465.46,478902.08,2426.62,400392.30,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257285',4900371,'3007','465',262097.28,264680.63,2583.35,426252.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257285',4900372,'3008','465',286665.16,289253.93,2578.77,425497.05,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257285',4900373,'3009','465',168182.74,170153.33,1970.59,325147.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257285',4900374,'3010','465',245364.56,248166.27,2801.71,462282.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257285',4900375,'3011','465',436340.13,438724.41,2384.28,393406.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257285',4900376,'3012','465',155134.22,157213.06,2078.84,343008.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900377,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900378,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900379,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900380,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900381,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900382,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900383,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257285',4900384,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257285',4900385,'3021','466',579708.33,579708.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257285',4900386,'3022','466',714046.92,714046.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257285',4900387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257285',4900388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900389,'3005','465',302220.38,303824.25,1603.87,264638.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900390,'3006','465',478902.08,480536.43,1634.35,269667.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900391,'3007','465',264680.63,265933.69,1253.06,206754.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900392,'3008','465',289253.93,291032.28,1778.35,293427.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900393,'3009','465',170153.33,171410.35,1257.02,207408.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900394,'3010','465',248166.27,249554.45,1388.18,229049.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900395,'3011','465',438724.41,440221.08,1496.67,246950.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257286',4900396,'3012','465',157213.06,158610.09,1397.03,230509.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900397,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900398,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900399,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900400,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900401,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900402,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900403,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257286',4900404,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257286',4900405,'3021','466',579708.33,579708.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257286',4900406,'3022','466',714046.92,714046.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257286',4900407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257286',4900408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900409,'3005','465',303824.25,305687.57,1863.32,307447.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900410,'3006','465',480536.43,482383.57,1847.14,304778.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900411,'3007','465',265933.69,267685.83,1752.14,289103.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900412,'3008','465',291032.28,292867.07,1834.79,302740.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900413,'3009','465',171410.35,171410.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900414,'3010','465',249554.45,251863.95,2309.50,381067.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900415,'3011','465',440221.08,442149.72,1928.64,318225.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257287',4900416,'3012','465',158610.09,160286.81,1676.72,276658.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900417,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900418,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900419,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900420,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900421,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900422,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900423,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257287',4900424,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257287',4900425,'3021','466',579708.33,579708.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257287',4900426,'3022','466',714046.92,714046.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257287',4900427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257287',4900428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900429,'3005','465',305687.57,307095.10,1407.53,232242.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900430,'3006','465',482383.57,482991.97,608.40,100386.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900431,'3007','465',267685.83,268266.36,580.53,95787.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900432,'3008','465',292867.07,293755.07,888.00,146520.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900433,'3009','465',171410.35,172174.40,764.05,126068.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900434,'3010','465',251863.95,252281.96,418.01,68971.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900435,'3011','465',442149.72,442869.76,720.04,118806.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257288',4900436,'3012','465',160286.81,160900.62,613.81,101278.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900437,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900438,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900439,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900440,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900441,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900442,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900443,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257288',4900444,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257288',4900445,'3021','466',579708.33,579708.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257288',4900446,'3022','466',714046.92,714046.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257288',4900447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257288',4900448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900449,'3005','465',307095.10,307095.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900450,'3006','465',482991.97,482991.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900451,'3007','465',268266.36,268266.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900452,'3008','465',293755.07,293755.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900453,'3009','465',172174.40,172174.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900454,'3010','465',252281.96,252281.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900455,'3011','465',442869.76,442869.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257289',4900456,'3012','465',160900.62,160900.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900457,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900458,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900459,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900460,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900461,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900462,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900463,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257289',4900464,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257289',4900465,'3021','466',579708.33,581160.83,1452.50,973175.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257289',4900466,'3022','466',714046.92,715585.80,1538.88,1031049.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257289',4900467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257289',4900468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900469,'3005','465',307095.10,308846.01,1750.91,288900.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900470,'3006','465',482991.97,484325.73,1333.76,220070.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900471,'3007','465',268266.36,269481.74,1215.38,200537.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900472,'3008','465',293755.07,295481.80,1726.73,284910.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900473,'3009','465',172174.40,173351.49,1177.09,194219.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900474,'3010','465',252281.96,253397.31,1115.35,184032.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900475,'3011','465',442869.76,444240.86,1371.10,226231.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257290',4900476,'3012','465',160900.62,161832.70,932.08,153793.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900477,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900478,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900479,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900480,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900481,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900482,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900483,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257290',4900484,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257290',4900485,'3021','466',581160.83,582171.07,1010.24,676860.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257290',4900486,'3022','466',715585.80,717376.53,1790.73,1199789.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257290',4900487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257290',4900488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900489,'3005','465',308846.01,311339.97,2493.96,411503.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900490,'3006','465',484325.73,486759.10,2433.37,401506.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900491,'3007','465',269481.74,272090.13,2608.39,430384.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900492,'3008','465',295481.80,297990.58,2508.78,413948.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900493,'3009','465',173351.49,173351.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900494,'3010','465',253397.31,257146.82,3749.51,618669.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900495,'3011','465',444240.86,447691.54,3450.68,569362.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257291',4900496,'3012','465',161832.70,161832.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900497,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900498,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900499,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900500,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900501,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900502,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900503,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257291',4900504,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257291',4900505,'3021','466',582171.07,584027.90,1856.83,1244076.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257291',4900506,'3022','466',717376.53,720184.43,2807.90,1881293.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257291',4900507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257291',4900508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900509,'3005','465',311339.97,312870.52,1530.55,252540.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900510,'3006','465',486759.10,488611.34,1852.24,305619.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900511,'3007','465',272090.13,273981.13,1891.00,312015.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900512,'3008','465',297990.58,299847.04,1856.46,306315.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900513,'3009','465',173351.49,175079.83,1728.34,285176.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900514,'3010','465',257146.82,258965.12,1818.30,300019.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900515,'3011','465',447691.54,449377.64,1686.10,278206.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257292',4900516,'3012','465',161832.70,162987.65,1154.95,190566.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900517,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900518,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900519,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900520,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900521,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900522,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900523,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257292',4900524,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257292',4900525,'3021','466',584027.90,585119.65,1091.75,731472.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257292',4900526,'3022','466',720184.43,722080.01,1895.58,1270038.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257292',4900527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257292',4900528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900529,'3005','465',312870.52,313500.73,630.21,103984.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900530,'3006','465',488611.34,489065.73,454.39,74974.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900531,'3007','465',273981.13,274414.56,433.43,71515.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900532,'3008','465',299847.04,300420.69,573.65,94652.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900533,'3009','465',175079.83,175079.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900534,'3010','465',258965.12,259525.78,560.66,92508.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900535,'3011','465',449377.64,449973.85,596.21,98374.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257293',4900536,'3012','465',162987.65,162987.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900537,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900538,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900539,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900540,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900541,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900542,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900543,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257293',4900544,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257293',4900545,'3021','466',585119.65,587478.28,2358.63,1580282.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257293',4900546,'3022','466',722080.01,723666.51,1586.50,1062955.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257293',4900547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257293',4900548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900549,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900550,'3006','465',489065.73,490719.24,1653.51,272829.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900551,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900552,'3008','465',300420.69,301532.65,1111.96,183473.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900553,'3009','465',175079.83,176530.41,1450.58,239345.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900554,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900555,'3011','465',449973.85,451335.72,1361.87,224708.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257294',4900556,'3012','465',162987.65,163066.45,78.80,13002.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900557,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900558,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900559,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900560,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900561,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900562,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900563,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257294',4900564,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257294',4900565,'3021','466',587478.28,590425.43,2947.15,1974590.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257294',4900566,'3022','466',723666.51,727794.82,4128.31,2765967.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257294',4900567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257294',4900568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900569,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900570,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900571,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900572,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900573,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900574,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900575,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257295',4900576,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900577,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900578,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900579,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900580,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900581,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900582,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900583,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257295',4900584,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257295',4900585,'3021','466',590425.43,591970.13,1544.70,1034949.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257295',4900586,'3022','466',727794.82,728896.36,1101.54,738031.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257295',4900587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257295',4900588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900589,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900590,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900591,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900592,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900593,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900594,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900595,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257296',4900596,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900597,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900598,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900599,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900600,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900601,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900602,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900603,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257296',4900604,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257296',4900605,'3021','466',591970.13,593068.69,1098.56,736035.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257296',4900606,'3022','466',728896.36,730653.19,1756.83,1177076.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257296',4900607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257296',4900608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900609,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900610,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900611,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900612,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900613,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900614,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900615,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257297',4900616,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900617,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900618,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900619,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900620,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900621,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900622,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900623,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257297',4900624,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257297',4900625,'3021','466',593068.69,593260.43,191.74,128465.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257297',4900626,'3022','466',730653.19,731660.90,1007.71,675165.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257297',4900627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257297',4900628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900629,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900630,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900631,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900632,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900633,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900634,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900635,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257298',4900636,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900637,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900638,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900639,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900640,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900641,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900642,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900643,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257298',4900644,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257298',4900645,'3021','466',593260.43,593507.00,246.57,165201.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257298',4900646,'3022','466',731660.90,733229.24,1568.34,1050787.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257298',4900647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257298',4900648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900649,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900650,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900651,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900652,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900653,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900654,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900655,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257299',4900656,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900657,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900658,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900659,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900660,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900661,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900662,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900663,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257299',4900664,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257299',4900665,'3021','466',593507.00,595491.65,1984.65,1329715.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257299',4900666,'3022','466',733229.24,735376.82,2147.58,1438878.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257299',4900667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257299',4900668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900669,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900670,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900671,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900672,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900673,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900674,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900675,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257300',4900676,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900677,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900678,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900679,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900680,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900681,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900682,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900683,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257300',4900684,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257300',4900685,'3021','466',595491.65,595889.99,398.34,266887.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257300',4900686,'3022','466',735376.82,736868.57,1491.75,999472.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257300',4900687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257300',4900688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900689,'3005','465',313500.73,313500.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900690,'3006','465',490719.24,490719.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900691,'3007','465',274414.56,274414.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900692,'3008','465',301532.65,301532.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900693,'3009','465',176530.41,176530.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900694,'3010','465',259525.78,259525.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900695,'3011','465',451335.72,451335.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257301',4900696,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900697,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900698,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900699,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900700,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900701,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900702,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900703,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257301',4900704,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257301',4900705,'3021','466',595889.99,595903.43,13.44,9004.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257301',4900706,'3022','466',736868.57,738159.49,1290.92,864916.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257301',4900707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257301',4900708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900709,'3005','465',313500.73,315197.58,1696.85,279980.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900710,'3006','465',490719.24,492758.71,2039.47,336512.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900711,'3007','465',274414.56,275861.94,1447.38,238817.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900712,'3008','465',301532.65,303282.40,1749.75,288708.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900713,'3009','465',176530.41,177277.46,747.05,123263.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900714,'3010','465',259525.78,261780.85,2255.07,372086.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900715,'3011','465',451335.72,453679.92,2344.20,386793.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257302',4900716,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900717,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900718,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900719,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900720,'3016','465',277571.32,277571.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900721,'3017','465',92703.80,92703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900722,'3018','465',231250.91,231250.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900723,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257302',4900724,'3020','465',144392.14,144392.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257302',4900725,'3021','466',595903.43,596131.05,227.62,152505.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257302',4900726,'3022','466',738159.49,740513.53,2354.04,1577206.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257302',4900727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257302',4900728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900729,'3005','465',315197.58,315197.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900730,'3006','465',492758.71,496549.68,3790.97,625510.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900731,'3007','465',275861.94,275861.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900732,'3008','465',303282.40,303282.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900733,'3009','465',177277.46,177277.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900734,'3010','465',261780.85,265823.12,4042.27,666974.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900735,'3011','465',453679.92,456832.43,3152.51,520164.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257303',4900736,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900737,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900738,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900739,'3015','465',145308.29,145308.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900740,'3016','465',277571.32,277608.89,37.57,6199.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900741,'3017','465',92703.80,95823.24,3119.44,514707.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900742,'3018','465',231250.91,233761.29,2510.38,414212.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900743,'3019','465',242475.38,242475.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257303',4900744,'3020','465',144392.14,146651.72,2259.58,372830.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257303',4900745,'3021','466',596131.05,596992.28,861.23,577024.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257303',4900746,'3022','466',740513.53,742324.83,1811.30,1213571.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257303',4900747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257303',4900748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900749,'3005','465',315197.58,318215.50,3017.92,497956.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900750,'3006','465',496549.68,496549.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900751,'3007','465',275861.94,277718.42,1856.48,306319.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900752,'3008','465',303282.40,305671.69,2389.29,394232.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900753,'3009','465',177277.46,179896.36,2618.90,432118.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900754,'3010','465',265823.12,265823.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900755,'3011','465',456832.43,458526.95,1694.52,279595.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257304',4900756,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900757,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900758,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900759,'3015','465',145308.29,147917.13,2608.84,430458.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900760,'3016','465',277608.89,277664.50,55.61,9175.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900761,'3017','465',95823.24,95823.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900762,'3018','465',233761.29,236141.15,2379.86,392676.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900763,'3019','465',242475.38,242499.76,24.38,4022.37,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257304',4900764,'3020','465',146651.72,148208.86,1557.14,256928.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257304',4900765,'3021','466',596992.28,597745.27,752.99,504503.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257304',4900766,'3022','466',742324.83,743030.13,705.30,472551.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257304',4900767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257304',4900768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900769,'3005','465',318215.50,318218.53,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900770,'3006','465',496549.68,499721.75,3172.07,523391.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900771,'3007','465',277718.42,277718.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900772,'3008','465',305671.69,307552.89,1881.20,310398.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900773,'3009','465',179896.36,179896.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900774,'3010','465',265823.12,268396.55,2573.43,424615.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900775,'3011','465',458526.95,460956.80,2429.85,400925.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257305',4900776,'3012','465',163066.45,163066.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900777,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900778,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900779,'3015','465',147917.13,150108.78,2191.65,361622.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900780,'3016','465',277664.50,278129.76,465.26,76767.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900781,'3017','465',95823.24,95823.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900782,'3018','465',236141.15,238451.48,2310.33,381204.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900783,'3019','465',242499.76,242499.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257305',4900784,'3020','465',148208.86,148847.18,638.32,105322.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257305',4900785,'3021','466',597745.27,597745.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257305',4900786,'3022','466',743030.13,743364.01,333.88,223699.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257305',4900787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257305',4900788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900789,'3005','465',318218.53,320701.89,2483.36,409754.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900790,'3006','465',499721.75,501670.22,1948.47,321497.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900791,'3007','465',277718.42,277718.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900792,'3008','465',307552.89,309618.55,2065.66,340833.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900793,'3009','465',179896.36,179896.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900794,'3010','465',268396.55,268396.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900795,'3011','465',460956.80,462537.75,1580.95,260856.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257306',4900796,'3012','465',163066.45,165472.94,2406.49,397070.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900797,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900798,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900799,'3015','465',150108.78,152674.98,2566.20,423423.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900800,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900801,'3017','465',95823.24,97604.24,1781.00,293865.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900802,'3018','465',238451.48,238499.35,47.87,7898.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900803,'3019','465',242499.76,242499.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257306',4900804,'3020','465',148847.18,148858.08,10.90,1798.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257306',4900805,'3021','466',597745.27,597745.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257306',4900806,'3022','466',743364.01,743364.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257306',4900807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257306',4900808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900809,'3005','465',320701.89,320701.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900810,'3006','465',501670.22,504928.11,3257.89,537551.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900811,'3007','465',277718.42,277718.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900812,'3008','465',309618.55,312164.81,2546.26,420132.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900813,'3009','465',179896.36,179896.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900814,'3010','465',268396.55,269715.52,1318.97,217630.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900815,'3011','465',462537.75,465357.82,2820.07,465311.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257307',4900816,'3012','465',165472.94,165472.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900817,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900818,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900819,'3015','465',152674.98,155712.41,3037.43,501175.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900820,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900821,'3017','465',97604.24,99467.39,1863.15,307419.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900822,'3018','465',238499.35,239752.10,1252.75,206703.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900823,'3019','465',242499.76,242499.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257307',4900824,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257307',4900825,'3021','466',597745.27,597925.27,180.00,120600.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257307',4900826,'3022','466',743364.01,744008.10,644.09,431540.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257307',4900827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257307',4900828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900829,'3005','465',320701.89,323902.59,3200.70,528115.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900830,'3006','465',504928.11,504928.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900831,'3007','465',277718.42,280270.30,2551.88,421060.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900832,'3008','465',312164.81,312164.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900833,'3009','465',179896.36,181794.57,1898.21,313204.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900834,'3010','465',269715.52,269715.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900835,'3011','465',465357.82,465357.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257308',4900836,'3012','465',165472.94,167831.97,2359.03,389239.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900837,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900838,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900839,'3015','465',155712.41,158582.26,2869.85,473525.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900840,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900841,'3017','465',99467.39,99467.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900842,'3018','465',239752.10,241404.02,1651.92,272566.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900843,'3019','465',242499.76,242499.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257308',4900844,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257308',4900845,'3021','466',597925.27,597925.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257308',4900846,'3022','466',744008.10,744453.52,445.42,298431.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257308',4900847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257308',4900848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900849,'3005','465',323902.59,323902.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900850,'3006','465',504928.11,508311.28,3383.17,558223.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900851,'3007','465',280270.30,280270.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900852,'3008','465',312164.81,315134.60,2969.79,490015.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900853,'3009','465',181794.57,181794.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900854,'3010','465',269715.52,269715.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900855,'3011','465',465357.82,468913.47,3555.65,586682.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257309',4900856,'3012','465',167831.97,167831.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900857,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900858,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900859,'3015','465',158582.26,161831.31,3249.05,536093.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900860,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900861,'3017','465',99467.39,99467.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900862,'3018','465',241404.02,243269.88,1865.86,307866.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900863,'3019','465',242499.76,242499.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257309',4900864,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257309',4900865,'3021','466',597925.27,598493.94,568.67,381008.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257309',4900866,'3022','466',744453.52,745699.58,1246.06,834860.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257309',4900867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257309',4900868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900869,'3005','465',323902.59,323902.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900870,'3006','465',508311.28,511251.41,2940.13,485121.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900871,'3007','465',280270.30,282529.41,2259.11,372753.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900872,'3008','465',315134.60,315134.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900873,'3009','465',181794.57,182133.37,338.80,55902.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900874,'3010','465',269715.52,271356.75,1641.23,270802.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900875,'3011','465',468913.47,469283.34,369.87,61028.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257310',4900876,'3012','465',167831.97,169860.94,2028.97,334780.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900877,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900878,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900879,'3015','465',161831.31,164408.38,2577.07,425216.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900880,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900881,'3017','465',99467.39,101294.98,1827.59,301552.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900882,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900883,'3019','465',242499.76,242501.33,1.57,259.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257310',4900884,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257310',4900885,'3021','466',598493.94,599456.41,962.47,644854.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257310',4900886,'3022','466',745699.58,745944.26,244.68,163935.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257310',4900887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257310',4900888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900889,'3005','465',323902.59,323902.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900890,'3006','465',511251.41,514164.39,2912.98,480641.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900891,'3007','465',282529.41,282529.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900892,'3008','465',315134.60,317281.39,2146.79,354220.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900893,'3009','465',182133.37,183094.63,961.26,158607.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900894,'3010','465',271356.75,272840.73,1483.98,244856.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900895,'3011','465',469283.34,470997.04,1713.70,282760.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257311',4900896,'3012','465',169860.94,171650.79,1789.85,295325.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900897,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900898,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900899,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900900,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900901,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900902,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900903,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257311',4900904,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257311',4900905,'3021','466',599456.41,600049.55,593.14,397403.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257311',4900906,'3022','466',745944.26,746758.28,814.02,545393.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257311',4900907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257311',4900908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900909,'3005','465',323902.59,323960.16,57.57,9499.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900910,'3006','465',514164.39,516756.51,2592.12,427699.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900911,'3007','465',282529.41,283774.38,1244.97,205420.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900912,'3008','465',317281.39,318985.20,1703.81,281128.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900913,'3009','465',183094.63,184896.13,1801.50,297247.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900914,'3010','465',272840.73,274734.01,1893.28,312391.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900915,'3011','465',470997.04,470997.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257312',4900916,'3012','465',171650.79,173570.19,1919.40,316701.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900917,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900918,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900919,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900920,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900921,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900922,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900923,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257312',4900924,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257312',4900925,'3021','466',600049.55,600049.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257312',4900926,'3022','466',746758.28,747036.06,277.78,186112.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257312',4900927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257312',4900928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900929,'3005','465',323960.16,324000.37,40.21,6634.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900930,'3006','465',516756.51,519750.37,2993.86,493986.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900931,'3007','465',283774.38,286249.12,2474.74,408332.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900932,'3008','465',318985.20,320985.54,2000.34,330056.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900933,'3009','465',184896.13,184906.13,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900934,'3010','465',274734.01,276696.73,1962.72,323848.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900935,'3011','465',470997.04,473053.02,2055.98,339236.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257313',4900936,'3012','465',173570.19,175966.13,2395.94,395330.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900937,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900938,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900939,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900940,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900941,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900942,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900943,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257313',4900944,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257313',4900945,'3021','466',600049.55,600379.79,330.24,221260.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257313',4900946,'3022','466',747036.06,748244.12,1208.06,809400.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257313',4900947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257313',4900948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900949,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900950,'3006','465',519750.37,521852.80,2102.43,346900.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900951,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900952,'3008','465',320985.54,323330.98,2345.44,386997.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900953,'3009','465',184906.13,186419.70,1513.57,249739.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900954,'3010','465',276696.73,278198.71,1501.98,247826.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900955,'3011','465',473053.02,474174.32,1121.30,185014.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257314',4900956,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900957,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900958,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900959,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900960,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900961,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900962,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900963,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257314',4900964,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257314',4900965,'3021','466',600379.79,600888.48,508.69,340822.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257314',4900966,'3022','466',748244.12,749708.40,1464.28,981067.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257314',4900967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257314',4900968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900969,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900970,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900971,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900972,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900973,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900974,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900975,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257315',4900976,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900977,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900978,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900979,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900980,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900981,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900982,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900983,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257315',4900984,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257315',4900985,'3021','466',600888.48,602251.59,1363.11,913283.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257315',4900986,'3022','466',749708.40,751844.85,2136.45,1431421.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257315',4900987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257315',4900988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900989,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900990,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900991,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900992,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900993,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900994,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900995,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257316',4900996,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4900997,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4900998,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4900999,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4901000,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4901001,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4901002,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4901003,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257316',4901004,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257316',4901005,'3021','466',602251.59,602339.00,87.41,58564.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257316',4901006,'3022','466',751844.85,753905.14,2060.29,1380394.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257316',4901007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257316',4901008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901009,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901010,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901011,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901012,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901013,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901014,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901015,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257317',4901016,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901017,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901018,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901019,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901020,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901021,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901022,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901023,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257317',4901024,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257317',4901025,'3021','466',602339.00,603068.76,729.76,488939.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257317',4901026,'3022','466',753905.14,754333.60,428.46,287068.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257317',4901027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257317',4901028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901029,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901030,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901031,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901032,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901033,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901034,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901035,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257318',4901036,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901037,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901038,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901039,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901040,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901041,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901042,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901043,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257318',4901044,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257318',4901045,'3021','466',603068.76,603358.31,289.55,193998.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257318',4901046,'3022','466',754333.60,755567.22,1233.62,826525.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257318',4901047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257318',4901048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901049,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901050,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901051,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901052,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901053,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901054,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901055,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257319',4901056,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901057,'3013','465',162710.43,162710.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901058,'3014','465',386189.75,386189.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901059,'3015','465',164408.38,164408.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901060,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901061,'3017','465',101294.98,101294.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901062,'3018','465',243269.88,243269.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901063,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257319',4901064,'3020','465',148858.08,148858.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257319',4901065,'3021','466',603358.31,603736.31,378.00,253260.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257319',4901066,'3022','466',755567.22,757137.15,1569.93,1051853.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257319',4901067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257319',4901068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901069,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901070,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901071,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901072,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901073,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901074,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901075,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257320',4901076,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901077,'3013','465',162710.43,165690.39,2979.96,491693.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901078,'3014','465',386189.75,387820.65,1630.90,269098.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901079,'3015','465',164408.38,167824.54,3416.16,563666.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901080,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901081,'3017','465',101294.98,103637.28,2342.30,386479.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901082,'3018','465',243269.88,245668.97,2399.09,395849.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901083,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257320',4901084,'3020','465',148858.08,151426.00,2567.92,423706.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257320',4901085,'3021','466',603736.31,604167.55,431.24,288930.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257320',4901086,'3022','466',757137.15,757982.10,844.95,566116.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257320',4901087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257320',4901088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901089,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901090,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901091,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901092,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901093,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901094,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901095,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257321',4901096,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901097,'3013','465',165690.39,168776.37,3085.98,509186.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901098,'3014','465',387820.65,390684.46,2863.81,472528.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901099,'3015','465',167824.54,170480.94,2656.40,438306.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901100,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901101,'3017','465',103637.28,104784.30,1147.02,189258.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901102,'3018','465',245668.97,248364.54,2695.57,444769.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901103,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257321',4901104,'3020','465',151426.00,153942.69,2516.69,415253.85,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257321',4901105,'3021','466',604167.55,605460.81,1293.26,866484.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257321',4901106,'3022','466',757982.10,759588.65,1606.55,1076388.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257321',4901107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257321',4901108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901109,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901110,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901111,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901112,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901113,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901114,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901115,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257322',4901116,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257322',4901117,'3013','465',168776.37,171089.49,2303.12,380014.80,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257322',4901118,'3014','465',390684.46,393248.19,2553.73,421365.45,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257322',4901119,'3015','465',170480.94,173631.49,3140.55,518190.75,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257322',4901120,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257322',4901121,'3017','465',104784.30,107022.95,2238.65,369377.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257322',4901122,'3018','465',248364.54,250426.65,2062.11,340248.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257322',4901123,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257322',4901124,'3020','465',153942.69,155585.07,1642.38,270992.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257322',4901125,'3021','466',605460.81,605575.72,114.91,76989.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257322',4901126,'3022','466',759588.65,760451.07,862.42,577821.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257322',4901127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257322',4901128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901129,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901130,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901131,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901132,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901133,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901134,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901135,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257323',4901136,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901137,'3013','465',171089.49,172022.44,932.95,153936.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901138,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901139,'3015','465',173631.49,174405.50,774.01,127711.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901140,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901141,'3017','465',107022.95,107499.98,477.03,78709.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901142,'3018','465',250426.65,251017.88,591.23,97552.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901143,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257323',4901144,'3020','465',155585.07,156121.65,536.58,88535.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257323',4901145,'3021','466',605575.72,606505.71,929.99,623093.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257323',4901146,'3022','466',760451.07,761983.70,1532.63,1026862.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257323',4901147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257323',4901148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901149,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901150,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901151,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901152,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901153,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901154,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901155,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257324',4901156,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901157,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901158,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901159,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901160,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901161,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901162,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901163,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257324',4901164,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257324',4901165,'3021','466',606505.71,607081.49,575.78,385772.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257324',4901166,'3022','466',761983.70,763098.05,1114.35,746614.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257324',4901167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257324',4901168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901169,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901170,'3006','465',521852.80,521852.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901171,'3007','465',286249.12,286249.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901172,'3008','465',323330.98,323330.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901173,'3009','465',186419.70,186419.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901174,'3010','465',278198.71,278198.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901175,'3011','465',474174.32,474174.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257325',4901176,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901177,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901178,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901179,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901180,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901181,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901182,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901183,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257325',4901184,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257325',4901185,'3021','466',607081.49,607190.45,108.96,73003.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257325',4901186,'3022','466',763098.05,764395.62,1297.57,869371.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257325',4901187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257325',4901188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257326',4901189,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257326',4901190,'3006','465',521852.80,524256.20,2403.40,396561.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257326',4901191,'3007','465',286249.12,287959.27,1710.15,282174.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257326',4901192,'3008','465',323330.98,325015.65,1664.67,274670.55,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257326',4901193,'3009','465',186419.70,188151.22,1701.52,280750.80,0.00,0.00,30.00,0.00,0.00),('1','195','1019','257326',4901194,'3010','465',278198.71,280087.06,1858.35,306627.75,0.00,0.00,30.00,0.00,0.00),('1','195','1019','257326',4901195,'3011','465',474174.32,476092.65,1918.33,316524.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257326',4901196,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901197,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901198,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901199,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901200,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901201,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901202,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901203,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257326',4901204,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257326',4901205,'3021','466',607190.45,607190.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257326',4901206,'3022','466',764395.62,765423.50,1027.88,688679.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257326',4901207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257326',4901208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901209,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901210,'3006','465',524256.20,526702.99,2446.79,403720.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901211,'3007','465',287959.27,288367.99,408.72,67438.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901212,'3008','465',325015.65,327042.09,2026.44,334362.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901213,'3009','465',188151.22,189403.30,1252.08,206593.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901214,'3010','465',280087.06,281549.87,1462.81,241363.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901215,'3011','465',476092.65,477634.13,1541.48,254344.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257327',4901216,'3012','465',175966.13,175966.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901217,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901218,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901219,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901220,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901221,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901222,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901223,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257327',4901224,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257327',4901225,'3021','466',607190.45,607393.39,202.94,135969.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257327',4901226,'3022','466',765423.50,765949.22,525.72,352232.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257327',4901227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257327',4901228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901229,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901230,'3006','465',526702.99,529588.29,2885.30,476074.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901231,'3007','465',288367.99,290712.05,2344.06,386769.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901232,'3008','465',327042.09,328834.95,1792.86,295821.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901233,'3009','465',189403.30,191067.74,1664.44,274632.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901234,'3010','465',281549.87,282730.24,1180.37,194761.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901235,'3011','465',477634.13,479225.77,1591.64,262620.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257328',4901236,'3012','465',175966.13,177707.54,1741.41,287332.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901237,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901238,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901239,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901240,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901241,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901242,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901243,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257328',4901244,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257328',4901245,'3021','466',607393.39,608146.97,753.58,504898.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257328',4901246,'3022','466',765949.22,766762.04,812.82,544589.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257328',4901247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257328',4901248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901249,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901250,'3006','465',529588.29,531688.12,2099.83,346471.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901251,'3007','465',290712.05,292814.49,2102.44,346902.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901252,'3008','465',328834.95,330175.69,1340.74,221222.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901253,'3009','465',191067.74,191067.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901254,'3010','465',282730.24,284940.17,2209.93,364638.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901255,'3011','465',479225.77,481245.44,2019.67,333245.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257329',4901256,'3012','465',177707.54,178721.96,1014.42,167379.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901257,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901258,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901259,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901260,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901261,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901262,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901263,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257329',4901264,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257329',4901265,'3021','466',608146.97,609596.94,1449.97,971479.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257329',4901266,'3022','466',766762.04,767423.29,661.25,443037.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257329',4901267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257329',4901268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901269,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901270,'3006','465',531688.12,531688.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901271,'3007','465',292814.49,292814.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901272,'3008','465',330175.69,330175.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901273,'3009','465',191067.74,191067.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901274,'3010','465',284940.17,284940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901275,'3011','465',481245.44,481245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257330',4901276,'3012','465',178721.96,178721.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901277,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901278,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901279,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901280,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901281,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901282,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901283,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257330',4901284,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257330',4901285,'3021','466',609596.94,609596.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257330',4901286,'3022','466',767423.29,769299.56,1876.27,1257100.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257330',4901287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257330',4901288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901289,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901290,'3006','465',531688.12,531688.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901291,'3007','465',292814.49,292814.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901292,'3008','465',330175.69,330175.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901293,'3009','465',191067.74,191067.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901294,'3010','465',284940.17,284940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901295,'3011','465',481245.44,481245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257331',4901296,'3012','465',178721.96,178721.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901297,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901298,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901299,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901300,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901301,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901302,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901303,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257331',4901304,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257331',4901305,'3021','466',609596.94,610780.31,1183.37,792857.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257331',4901306,'3022','466',769299.56,772326.61,3027.05,2028123.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257331',4901307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257331',4901308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901309,'3005','465',324000.37,324000.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901310,'3006','465',531688.12,531688.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901311,'3007','465',292814.49,292814.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901312,'3008','465',330175.69,330175.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901313,'3009','465',191067.74,191067.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901314,'3010','465',284940.17,284940.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901315,'3011','465',481245.44,481245.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257332',4901316,'3012','465',178721.96,178721.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901317,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901318,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901319,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901320,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901321,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901322,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901323,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257332',4901324,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257332',4901325,'3021','466',610780.31,611931.26,1150.95,748117.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257332',4901326,'3022','466',772326.61,774192.67,1866.06,1212939.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257332',4901327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257332',4901328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901329,'3005','465',324000.37,325267.90,1267.53,209142.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901330,'3006','465',531688.12,534715.12,3027.00,499455.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901331,'3007','465',292814.49,295031.33,2216.84,365778.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901332,'3008','465',330175.69,331937.17,1761.48,290644.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901333,'3009','465',191067.74,191067.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901334,'3010','465',284940.17,287635.25,2695.08,444688.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901335,'3011','465',481245.44,484111.57,2866.13,472911.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257333',4901336,'3012','465',178721.96,178721.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901337,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901338,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901339,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901340,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901341,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901342,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901343,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257333',4901344,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257333',4901345,'3021','466',611931.26,612892.25,960.99,624643.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257333',4901346,'3022','466',774192.67,775505.08,1312.41,853066.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257333',4901347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257333',4901348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901349,'3005','465',325267.90,325267.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901350,'3006','465',534715.12,538667.45,3952.33,652134.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901351,'3007','465',295031.33,298381.98,3350.65,552857.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901352,'3008','465',331937.17,332609.15,671.98,110876.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901353,'3009','465',191067.74,191140.47,72.73,12000.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901354,'3010','465',287635.25,290569.16,2933.91,484095.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901355,'3011','465',484111.57,486325.73,2214.16,365336.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257334',4901356,'3012','465',178721.96,181886.58,3164.62,522162.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901357,'3013','465',172022.44,172022.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901358,'3014','465',393248.19,393248.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901359,'3015','465',174405.50,174405.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901360,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901361,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901362,'3018','465',251017.88,251017.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901363,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257334',4901364,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257334',4901365,'3021','466',612892.25,613316.81,424.56,275964.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257334',4901366,'3022','466',775505.08,777545.19,2040.11,1326071.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257334',4901367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257334',4901368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901369,'3005','465',325267.90,325267.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901370,'3006','465',538667.45,541515.01,2847.56,469847.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901371,'3007','465',298381.98,298381.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901372,'3008','465',332609.15,335606.54,2997.39,494569.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901373,'3009','465',191140.47,191140.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901374,'3010','465',290569.16,290569.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901375,'3011','465',486325.73,489118.74,2793.01,460846.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257335',4901376,'3012','465',181886.58,181886.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901377,'3013','465',172022.44,175404.48,3382.04,558036.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901378,'3014','465',393248.19,393390.90,142.71,23547.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901379,'3015','465',174405.50,177117.72,2712.22,447516.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901380,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901381,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901382,'3018','465',251017.88,252527.44,1509.56,249077.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901383,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257335',4901384,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257335',4901385,'3021','466',613316.81,613541.12,224.31,145801.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257335',4901386,'3022','466',777545.19,778338.89,793.70,515905.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257335',4901387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257335',4901388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901389,'3005','465',325267.90,325267.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901390,'3006','465',541515.01,545058.57,3543.56,584687.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901391,'3007','465',298381.98,300483.23,2101.25,346706.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901392,'3008','465',335606.54,335606.55,0.01,1.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901393,'3009','465',191140.47,191140.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901394,'3010','465',290569.16,290569.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901395,'3011','465',489118.74,489118.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257336',4901396,'3012','465',181886.58,185149.23,3262.65,538337.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901397,'3013','465',175404.48,176302.27,897.79,148135.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901398,'3014','465',393390.90,395499.28,2108.38,347882.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901399,'3015','465',177117.72,180089.92,2972.20,490413.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901400,'3016','465',278129.76,278129.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901401,'3017','465',107499.98,107499.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901402,'3018','465',252527.44,256552.44,4025.00,664125.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901403,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257336',4901404,'3020','465',156121.65,156121.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257336',4901405,'3021','466',613541.12,614090.20,549.08,356902.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257336',4901406,'3022','466',778338.89,779379.87,1040.98,676637.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257336',4901407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257336',4901408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901409,'3005','465',325267.90,325267.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901410,'3006','465',545058.57,545058.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901411,'3007','465',300483.23,300483.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901412,'3008','465',335606.55,335606.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901413,'3009','465',191140.47,191140.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901414,'3010','465',290569.16,290569.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901415,'3011','465',489118.74,489118.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257337',4901416,'3012','465',185149.23,185149.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901417,'3013','465',176302.27,179570.45,3268.18,539249.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901418,'3014','465',395499.28,398240.26,2740.98,452261.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901419,'3015','465',180089.92,182918.03,2828.11,466638.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901420,'3016','465',278129.76,278227.07,97.31,16056.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901421,'3017','465',107499.98,109307.55,1807.57,298249.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901422,'3018','465',256552.44,259060.80,2508.36,413879.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901423,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257337',4901424,'3020','465',156121.65,157335.73,1214.08,200323.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257337',4901425,'3021','466',614090.20,615037.09,946.89,615478.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257337',4901426,'3022','466',779379.87,781653.93,2274.06,1478139.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257337',4901427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257337',4901428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901429,'3005','465',325267.90,325272.94,5.04,831.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901430,'3006','465',545058.57,547703.97,2645.40,436491.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901431,'3007','465',300483.23,300483.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901432,'3008','465',335606.55,338480.03,2873.48,474124.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901433,'3009','465',191140.47,191140.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901434,'3010','465',290569.16,292270.32,1701.16,280691.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901435,'3011','465',489118.74,489118.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257338',4901436,'3012','465',185149.23,187354.96,2205.73,363945.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901437,'3013','465',179570.45,181813.77,2243.32,370147.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901438,'3014','465',398240.26,398240.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901439,'3015','465',182918.03,185822.52,2904.49,479240.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901440,'3016','465',278227.07,278227.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901441,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901442,'3018','465',259060.80,259060.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901443,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257338',4901444,'3020','465',157335.73,157335.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257338',4901445,'3021','466',615037.09,615793.64,756.55,491757.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257338',4901446,'3022','466',781653.93,782487.92,833.99,542093.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257338',4901447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257338',4901448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901449,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901450,'3006','465',547703.97,549821.10,2117.13,349326.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901451,'3007','465',300483.23,300483.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901452,'3008','465',338480.03,340203.89,1723.86,284436.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901453,'3009','465',191140.47,191140.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901454,'3010','465',292270.32,292270.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901455,'3011','465',489118.74,490919.10,1800.36,297059.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257339',4901456,'3012','465',187354.96,187354.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901457,'3013','465',181813.77,184032.32,2218.55,366060.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901458,'3014','465',398240.26,398240.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901459,'3015','465',185822.52,187549.58,1727.06,284964.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901460,'3016','465',278227.07,278227.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901461,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901462,'3018','465',259060.80,259060.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901463,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257339',4901464,'3020','465',157335.73,157757.37,421.64,69570.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257339',4901465,'3021','466',615793.64,616070.06,276.42,179673.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257339',4901466,'3022','466',782487.92,782909.40,421.48,273962.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257339',4901467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257339',4901468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901469,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901470,'3006','465',549821.10,552289.55,2468.45,407294.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901471,'3007','465',300483.23,300483.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901472,'3008','465',340203.89,341776.49,1572.60,259479.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901473,'3009','465',191140.47,191140.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901474,'3010','465',292270.32,292381.52,111.20,18348.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901475,'3011','465',490919.10,492985.60,2066.50,340972.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257340',4901476,'3012','465',187354.96,187354.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901477,'3013','465',184032.32,184032.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901478,'3014','465',398240.26,400723.34,2483.08,409708.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901479,'3015','465',187549.58,187549.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901480,'3016','465',278227.07,278267.67,40.60,6699.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901481,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901482,'3018','465',259060.80,261266.34,2205.54,363914.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901483,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257340',4901484,'3020','465',157757.37,157757.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257340',4901485,'3021','466',616070.06,616070.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257340',4901486,'3022','466',782909.40,785096.12,2186.72,1421368.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257340',4901487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257340',4901488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901489,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901490,'3006','465',552289.55,554950.17,2660.62,439002.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901491,'3007','465',300483.23,302100.11,1616.88,266785.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901492,'3008','465',341776.49,342154.63,378.14,62393.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901493,'3009','465',191140.47,192295.62,1145.15,188949.75,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257341',4901494,'3010','465',292381.52,292692.97,311.45,51389.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901495,'3011','465',492985.60,494723.04,1737.44,286677.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257341',4901496,'3012','465',187354.96,188820.47,1465.51,241809.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901497,'3013','465',184032.32,184032.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901498,'3014','465',400723.34,401986.92,1243.58,205190.70,0.00,0.00,20.00,0.00,0.00),('1','195','1020','257341',4901499,'3015','465',187549.58,188734.20,1184.62,195462.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901500,'3016','465',278267.67,278267.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901501,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901502,'3018','465',261266.34,262310.62,1044.28,172306.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901503,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257341',4901504,'3020','465',157757.37,157757.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257341',4901505,'3021','466',616070.06,616200.84,130.78,85007.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257341',4901506,'3022','466',785096.12,786241.43,1145.31,744451.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257341',4901507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257341',4901508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901509,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901510,'3006','465',554950.17,557495.89,2545.72,420043.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901511,'3007','465',302100.11,302100.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901512,'3008','465',342154.63,344865.43,2710.80,447282.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901513,'3009','465',192295.62,193628.78,1333.16,219971.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901514,'3010','465',292692.97,293966.48,1273.51,210129.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901515,'3011','465',494723.04,497207.42,2484.38,409922.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257342',4901516,'3012','465',188820.47,189458.33,637.86,105246.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901517,'3013','465',184032.32,184032.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901518,'3014','465',401986.92,401986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901519,'3015','465',188734.20,188734.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901520,'3016','465',278267.67,278267.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901521,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901522,'3018','465',262310.62,262310.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901523,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257342',4901524,'3020','465',157757.37,157757.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257342',4901525,'3021','466',616200.84,617647.23,1446.39,940153.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257342',4901526,'3022','466',786241.43,788665.73,2424.30,1575795.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257342',4901527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257342',4901528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901529,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901530,'3006','465',557495.89,558932.14,1436.25,236981.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901531,'3007','465',302100.11,303351.56,1251.45,206489.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901532,'3008','465',344865.43,344865.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901533,'3009','465',193628.78,194603.45,974.67,160820.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901534,'3010','465',293966.48,295018.59,1052.11,173598.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901535,'3011','465',497207.42,497207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257343',4901536,'3012','465',189458.33,190619.99,1161.66,191673.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901537,'3013','465',184032.32,184032.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901538,'3014','465',401986.92,401986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901539,'3015','465',188734.20,188734.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901540,'3016','465',278267.67,278267.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901541,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901542,'3018','465',262310.62,262310.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901543,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257343',4901544,'3020','465',157757.37,157757.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257343',4901545,'3021','466',617647.23,618647.22,999.99,649993.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257343',4901546,'3022','466',788665.73,789477.46,811.73,527624.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257343',4901547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257343',4901548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901549,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901550,'3006','465',558932.14,558932.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901551,'3007','465',303351.56,303351.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901552,'3008','465',344865.43,344865.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901553,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901554,'3010','465',295018.59,295018.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901555,'3011','465',497207.42,497207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257344',4901556,'3012','465',190619.99,190619.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901557,'3013','465',184032.32,184032.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901558,'3014','465',401986.92,401986.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901559,'3015','465',188734.20,188734.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901560,'3016','465',278267.67,278267.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901561,'3017','465',109307.55,109307.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901562,'3018','465',262310.62,262310.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901563,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257344',4901564,'3020','465',157757.37,157757.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257344',4901565,'3021','466',618647.22,620375.91,1728.69,1123648.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257344',4901566,'3022','466',789477.46,790409.72,932.26,605969.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257344',4901567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257344',4901568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901569,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901570,'3006','465',558932.14,558932.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901571,'3007','465',303351.56,303351.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901572,'3008','465',344865.43,344865.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901573,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901574,'3010','465',295018.59,295018.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901575,'3011','465',497207.42,497207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257345',4901576,'3012','465',190619.99,190619.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901577,'3013','465',184032.32,185128.64,1096.32,180892.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901578,'3014','465',401986.92,404741.32,2754.40,454476.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901579,'3015','465',188734.20,190215.94,1481.74,244487.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901580,'3016','465',278267.67,278310.81,43.14,7118.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901581,'3017','465',109307.55,111579.21,2271.66,374823.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901582,'3018','465',262310.62,264291.54,1980.92,326851.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901583,'3019','465',242501.33,242501.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257345',4901584,'3020','465',157757.37,160047.80,2290.43,377920.95,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257345',4901585,'3021','466',620375.91,623064.35,2688.44,1747486.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257345',4901586,'3022','466',790409.72,791219.34,809.62,526253.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257345',4901587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257345',4901588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901589,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901590,'3006','465',558932.14,558932.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901591,'3007','465',303351.56,303351.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901592,'3008','465',344865.43,344865.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901593,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901594,'3010','465',295018.59,295018.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901595,'3011','465',497207.42,497207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257346',4901596,'3012','465',190619.99,190619.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901597,'3013','465',185128.64,187856.02,2727.38,450017.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901598,'3014','465',404741.32,407636.40,2895.08,477688.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901599,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901600,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901601,'3017','465',111579.21,112821.74,1242.53,205017.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901602,'3018','465',264291.54,267234.12,2942.58,485525.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901603,'3019','465',242501.33,242502.55,1.22,201.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257346',4901604,'3020','465',160047.80,162637.04,2589.24,427224.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257346',4901605,'3021','466',623064.35,624058.21,993.86,646009.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257346',4901606,'3022','466',791219.34,794124.99,2905.65,1888672.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257346',4901607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257346',4901608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901609,'3005','465',325272.94,325272.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901610,'3006','465',558932.14,561605.58,2673.44,441117.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901611,'3007','465',303351.56,303351.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901612,'3008','465',344865.43,347234.45,2369.02,390888.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901613,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901614,'3010','465',295018.59,295018.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901615,'3011','465',497207.42,497207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257347',4901616,'3012','465',190619.99,192925.58,2305.59,380422.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901617,'3013','465',187856.02,190402.42,2546.40,420156.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901618,'3014','465',407636.40,407636.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901619,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901620,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901621,'3017','465',112821.74,112821.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901622,'3018','465',267234.12,269220.04,1985.92,327676.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901623,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257347',4901624,'3020','465',162637.04,162637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257347',4901625,'3021','466',624058.21,625236.14,1177.93,765654.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257347',4901626,'3022','466',794124.99,795265.33,1140.34,741221.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257347',4901627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257347',4901628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901629,'3005','465',325272.94,325291.68,18.74,3092.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901630,'3006','465',561605.58,564045.51,2439.93,402588.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901631,'3007','465',303351.56,305835.35,2483.79,409825.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901632,'3008','465',347234.45,347234.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901633,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901634,'3010','465',295018.59,297586.19,2567.60,423654.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901635,'3011','465',497207.42,497207.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257348',4901636,'3012','465',192925.58,192925.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901637,'3013','465',190402.42,190402.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901638,'3014','465',407636.40,410824.81,3188.41,526087.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901639,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901640,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901641,'3017','465',112821.74,114573.39,1751.65,289022.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901642,'3018','465',269220.04,269232.16,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901643,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257348',4901644,'3020','465',162637.04,162637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257348',4901645,'3021','466',625236.14,626409.90,1173.76,762944.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257348',4901646,'3022','466',795265.33,795521.39,256.06,166439.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257348',4901647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257348',4901648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901649,'3005','465',325291.68,325291.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901650,'3006','465',564045.51,566917.35,2871.84,473853.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901651,'3007','465',305835.35,305835.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901652,'3008','465',347234.45,349624.59,2390.14,394373.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901653,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901654,'3010','465',297586.19,297586.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901655,'3011','465',497207.42,500435.20,3227.78,532583.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257349',4901656,'3012','465',192925.58,192925.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901657,'3013','465',190402.42,190402.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901658,'3014','465',410824.81,414336.75,3511.94,579470.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901659,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901660,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901661,'3017','465',114573.39,114573.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901662,'3018','465',269232.16,271914.68,2682.52,442615.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901663,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257349',4901664,'3020','465',162637.04,162637.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257349',4901665,'3021','466',626409.90,627734.06,1324.16,860704.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257349',4901666,'3022','466',795521.39,796578.19,1056.80,686920.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257349',4901667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257349',4901668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901669,'3005','465',325291.68,325291.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901670,'3006','465',566917.35,569868.06,2950.71,486867.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901671,'3007','465',305835.35,305835.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901672,'3008','465',349624.59,349624.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901673,'3009','465',194603.45,194603.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901674,'3010','465',297586.19,297586.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901675,'3011','465',500435.20,503050.72,2615.52,431560.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257350',4901676,'3012','465',192925.58,192925.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901677,'3013','465',190402.42,192623.92,2221.50,366547.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901678,'3014','465',414336.75,414336.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901679,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901680,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901681,'3017','465',114573.39,115103.26,529.87,87428.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901682,'3018','465',271914.68,273464.78,1550.10,255766.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901683,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257350',4901684,'3020','465',162637.04,164513.37,1876.33,309594.45,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257350',4901685,'3021','466',627734.06,628672.96,938.90,610285.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257350',4901686,'3022','466',796578.19,797797.30,1219.11,792420.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257350',4901687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257350',4901688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901689,'3005','465',325291.68,325738.45,446.77,73717.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901690,'3006','465',569868.06,573327.46,3459.40,570801.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901691,'3007','465',305835.35,309108.54,3273.19,540076.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901692,'3008','465',349624.59,349624.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901693,'3009','465',194603.45,197480.88,2877.43,474775.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901694,'3010','465',297586.19,297586.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901695,'3011','465',503050.72,504382.54,1331.82,219750.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257351',4901696,'3012','465',192925.58,194008.91,1083.33,178749.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901697,'3013','465',192623.92,193356.37,732.45,120854.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901698,'3014','465',414336.75,415617.35,1280.60,211299.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901699,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901700,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901701,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901702,'3018','465',273464.78,275048.28,1583.50,261277.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901703,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257351',4901704,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257351',4901705,'3021','466',628672.96,629475.19,802.23,521449.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257351',4901706,'3022','466',797797.30,798650.16,852.86,554359.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257351',4901707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257351',4901708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257352',4901709,'3005','465',325738.45,325738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257352',4901710,'3006','465',573327.46,575700.47,2373.01,391546.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257352',4901711,'3007','465',309108.54,309108.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257352',4901712,'3008','465',349624.59,352332.34,2707.75,446778.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257352',4901713,'3009','465',197480.88,198158.55,667.67,110165.55,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257352',4901714,'3010','465',297586.19,300092.28,2496.09,411854.85,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257352',4901715,'3011','465',504382.54,504382.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257352',4901716,'3012','465',194008.91,196012.24,2003.33,330549.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901717,'3013','465',193356.37,193356.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901718,'3014','465',415617.35,415617.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901719,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901720,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901721,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901722,'3018','465',275048.28,275048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901723,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257352',4901724,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257352',4901725,'3021','466',629475.19,629924.45,449.26,292019.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257352',4901726,'3022','466',798650.16,800061.85,1411.69,917598.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257352',4901727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257352',4901728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901729,'3005','465',325738.45,325738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901730,'3006','465',575700.47,577250.70,1550.23,255787.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901731,'3007','465',309108.54,310900.86,1792.32,295732.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901732,'3008','465',352332.34,353567.61,1235.27,203819.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901733,'3009','465',198158.55,198158.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901734,'3010','465',300092.28,301800.60,1708.32,281872.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901735,'3011','465',504382.54,506454.92,2072.38,341942.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257353',4901736,'3012','465',196012.24,196012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901737,'3013','465',193356.37,193356.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901738,'3014','465',415617.35,415617.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901739,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901740,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901741,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901742,'3018','465',275048.28,275048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901743,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257353',4901744,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257353',4901745,'3021','466',629924.45,631081.39,1156.94,752011.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257353',4901746,'3022','466',800061.85,801876.56,1814.71,1179561.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257353',4901747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257353',4901748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901749,'3005','465',325738.45,325738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901750,'3006','465',577250.70,580137.80,2887.10,476371.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901751,'3007','465',310900.86,310900.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901752,'3008','465',353567.61,355805.09,2237.48,369184.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901753,'3009','465',198158.55,198158.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901754,'3010','465',301800.60,303377.22,1576.62,260142.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901755,'3011','465',506454.92,509099.28,2644.36,436319.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257354',4901756,'3012','465',196012.24,196012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901757,'3013','465',193356.37,193356.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901758,'3014','465',415617.35,415617.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901759,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901760,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901761,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901762,'3018','465',275048.28,275048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901763,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257354',4901764,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257354',4901765,'3021','466',631081.39,631264.51,183.12,119028.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257354',4901766,'3022','466',801876.56,803291.22,1414.66,919529.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257354',4901767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257354',4901768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901769,'3005','465',325738.45,325738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901770,'3006','465',580137.80,581495.28,1357.48,223984.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901771,'3007','465',310900.86,310900.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901772,'3008','465',355805.09,357086.09,1281.00,211365.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901773,'3009','465',198158.55,198158.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901774,'3010','465',303377.22,304499.76,1122.54,185219.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901775,'3011','465',509099.28,509987.11,887.83,146491.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257355',4901776,'3012','465',196012.24,196012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901777,'3013','465',193356.37,193356.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901778,'3014','465',415617.35,415617.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901779,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901780,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901781,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901782,'3018','465',275048.28,275048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901783,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257355',4901784,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257355',4901785,'3021','466',631264.51,631814.50,549.99,357493.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257355',4901786,'3022','466',803291.22,803799.42,508.20,330330.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257355',4901787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257355',4901788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901789,'3005','465',325738.45,325738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901790,'3006','465',581495.28,583517.84,2022.56,333722.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901791,'3007','465',310900.86,310932.08,31.22,5151.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901792,'3008','465',357086.09,358967.51,1881.42,310434.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901793,'3009','465',198158.55,198158.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901794,'3010','465',304499.76,305916.54,1416.78,233768.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901795,'3011','465',509987.11,511448.62,1461.51,241149.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257356',4901796,'3012','465',196012.24,196012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901797,'3013','465',193356.37,193356.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901798,'3014','465',415617.35,415617.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901799,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901800,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901801,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901802,'3018','465',275048.28,275048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901803,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257356',4901804,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257356',4901805,'3021','466',631814.50,632480.53,666.03,432919.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257356',4901806,'3022','466',803799.42,804896.40,1096.98,713037.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257356',4901807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257356',4901808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901809,'3005','465',325738.45,327431.24,1692.79,279310.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901810,'3006','465',583517.84,585175.24,1657.40,273471.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901811,'3007','465',310932.08,313330.48,2398.40,395736.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901812,'3008','465',358967.51,358967.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901813,'3009','465',198158.55,198158.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901814,'3010','465',305916.54,308062.10,2145.56,354017.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901815,'3011','465',511448.62,513558.31,2109.69,348098.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257357',4901816,'3012','465',196012.24,196012.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901817,'3013','465',193356.37,193356.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901818,'3014','465',415617.35,415617.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901819,'3015','465',190215.94,190215.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901820,'3016','465',278310.81,278310.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901821,'3017','465',115103.26,115103.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901822,'3018','465',275048.28,275048.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901823,'3019','465',242502.55,242502.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257357',4901824,'3020','465',164513.37,164513.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257357',4901825,'3021','466',632480.53,635140.53,2660.00,1729000.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257357',4901826,'3022','466',804896.40,806683.81,1787.41,1161816.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257357',4901827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257357',4901828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901829,'3005','465',327431.24,327431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901830,'3006','465',585175.24,586297.49,1122.25,185171.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901831,'3007','465',313330.48,313726.08,395.60,65274.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901832,'3008','465',358967.51,359700.39,732.88,120925.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901833,'3009','465',198158.55,198445.12,286.57,47284.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901834,'3010','465',308062.10,308975.00,912.90,150628.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901835,'3011','465',513558.31,513558.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257358',4901836,'3012','465',196012.24,196971.68,959.44,158307.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901837,'3013','465',193356.37,194207.31,850.94,140405.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901838,'3014','465',415617.35,416732.68,1115.33,184029.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901839,'3015','465',190215.94,190229.99,14.05,2318.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901840,'3016','465',278310.81,278310.99,0.18,29.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901841,'3017','465',115103.26,116269.89,1166.63,192493.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901842,'3018','465',275048.28,276131.42,1083.14,178718.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901843,'3019','465',242502.55,242503.50,0.95,156.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257358',4901844,'3020','465',164513.37,165763.75,1250.38,206312.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257358',4901845,'3021','466',635140.53,636263.00,1122.47,729605.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257358',4901846,'3022','466',806683.81,807228.48,544.67,354035.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257358',4901847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257358',4901848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901849,'3005','465',327431.24,327431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901850,'3006','465',586297.49,586297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901851,'3007','465',313726.08,313726.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901852,'3008','465',359700.39,359700.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901853,'3009','465',198445.12,198445.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901854,'3010','465',308975.00,308975.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901855,'3011','465',513558.31,513558.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257359',4901856,'3012','465',196971.68,196971.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901857,'3013','465',194207.31,197627.23,3419.92,564286.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901858,'3014','465',416732.68,419766.67,3033.99,500608.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901859,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901860,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901861,'3017','465',116269.89,116766.46,496.57,81934.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901862,'3018','465',276131.42,279010.67,2879.25,475076.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901863,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257359',4901864,'3020','465',165763.75,168449.05,2685.30,443074.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257359',4901865,'3021','466',636263.00,638009.15,1746.15,1134997.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257359',4901866,'3022','466',807228.48,808963.03,1734.55,1127457.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257359',4901867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257359',4901868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901869,'3005','465',327431.24,327431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901870,'3006','465',586297.49,586297.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901871,'3007','465',313726.08,313726.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901872,'3008','465',359700.39,359896.99,196.60,32439.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901873,'3009','465',198445.12,198445.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901874,'3010','465',308975.00,308975.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901875,'3011','465',513558.31,513830.38,272.07,44891.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257360',4901876,'3012','465',196971.68,196971.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901877,'3013','465',197627.23,199820.63,2193.40,361911.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901878,'3014','465',419766.67,422455.55,2688.88,443665.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901879,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901880,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901881,'3017','465',116766.46,117450.98,684.52,112945.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901882,'3018','465',279010.67,281925.12,2914.45,480884.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901883,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257360',4901884,'3020','465',168449.05,170395.15,1946.10,321106.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257360',4901885,'3021','466',638009.15,640970.30,2961.15,1924747.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257360',4901886,'3022','466',808963.03,810392.89,1429.86,929409.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257360',4901887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257360',4901888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901889,'3005','465',327431.24,327431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901890,'3006','465',586297.49,589507.24,3209.75,529608.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901891,'3007','465',313726.08,313726.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901892,'3008','465',359896.99,359896.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901893,'3009','465',198445.12,198445.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901894,'3010','465',308975.00,308975.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901895,'3011','465',513830.38,517024.10,3193.72,526963.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257361',4901896,'3012','465',196971.68,196971.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901897,'3013','465',199820.63,200701.21,880.58,145295.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901898,'3014','465',422455.55,425253.45,2797.90,461653.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901899,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901900,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901901,'3017','465',117450.98,119148.70,1697.72,280123.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901902,'3018','465',281925.12,284636.55,2711.43,447385.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901903,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257361',4901904,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257361',4901905,'3021','466',640970.30,640970.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257361',4901906,'3022','466',810392.89,810392.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257361',4901907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257361',4901908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901909,'3005','465',327431.24,327431.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901910,'3006','465',589507.24,592821.79,3314.55,546900.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901911,'3007','465',313726.08,313726.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901912,'3008','465',359896.99,362372.15,2475.16,408401.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901913,'3009','465',198445.12,198445.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901914,'3010','465',308975.00,310415.06,1440.06,237609.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901915,'3011','465',517024.10,519665.86,2641.76,435890.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257362',4901916,'3012','465',196971.68,196971.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901917,'3013','465',200701.21,200701.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901918,'3014','465',425253.45,427855.64,2602.19,429361.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901919,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901920,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901921,'3017','465',119148.70,119148.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901922,'3018','465',284636.55,285754.13,1117.58,184400.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901923,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257362',4901924,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257362',4901925,'3021','466',640970.30,641028.30,58.00,37700.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257362',4901926,'3022','466',810392.89,810529.38,136.49,88718.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257362',4901927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257362',4901928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901929,'3005','465',327431.24,327876.85,445.61,73525.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901930,'3006','465',592821.79,596668.80,3847.01,634756.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901931,'3007','465',313726.08,313726.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901932,'3008','465',362372.15,362372.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901933,'3009','465',198445.12,198445.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901934,'3010','465',310415.06,310415.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901935,'3011','465',519665.86,522057.74,2391.88,394660.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257363',4901936,'3012','465',196971.68,198894.60,1922.92,317281.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901937,'3013','465',200701.21,202697.78,1996.57,329434.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901938,'3014','465',427855.64,430685.78,2830.14,466973.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901939,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901940,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901941,'3017','465',119148.70,120662.43,1513.73,249765.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901942,'3018','465',285754.13,286250.46,496.33,81894.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901943,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257363',4901944,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257363',4901945,'3021','466',641028.30,641028.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257363',4901946,'3022','466',810529.38,810529.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257363',4901947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257363',4901948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901949,'3005','465',327876.85,329651.60,1774.75,292833.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901950,'3006','465',596668.80,599795.97,3127.17,515983.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901951,'3007','465',313726.08,314244.02,517.94,85460.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901952,'3008','465',362372.15,364962.02,2589.87,427328.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901953,'3009','465',198445.12,199801.85,1356.73,223860.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901954,'3010','465',310415.06,312211.67,1796.61,296440.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901955,'3011','465',522057.74,524891.00,2833.26,467487.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257364',4901956,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901957,'3013','465',202697.78,203758.95,1061.17,175093.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901958,'3014','465',430685.78,431075.08,389.30,64234.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901959,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901960,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901961,'3017','465',120662.43,121319.67,657.24,108444.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901962,'3018','465',286250.46,287092.70,842.24,138969.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901963,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257364',4901964,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257364',4901965,'3021','466',641028.30,641028.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257364',4901966,'3022','466',810529.38,810529.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257364',4901967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257364',4901968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901969,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901970,'3006','465',599795.97,599795.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901971,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901972,'3008','465',364962.02,364962.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901973,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901974,'3010','465',312211.67,312211.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901975,'3011','465',524891.00,524891.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257365',4901976,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901977,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901978,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901979,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901980,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901981,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901982,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901983,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257365',4901984,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257365',4901985,'3021','466',641028.30,643704.76,2676.46,1739699.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257365',4901986,'3022','466',810529.38,814190.11,3660.73,2379474.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257365',4901987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257365',4901988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257366',4901989,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257366',4901990,'3006','465',599795.97,601250.30,1444.33,238314.45,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257366',4901991,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257366',4901992,'3008','465',364962.02,366461.94,1499.92,247486.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257366',4901993,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257366',4901994,'3010','465',312211.67,313385.71,1174.04,193716.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257366',4901995,'3011','465',524891.00,526196.22,1295.22,213711.30,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257366',4901996,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4901997,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4901998,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4901999,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4902000,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4902001,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4902002,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4902003,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257366',4902004,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257366',4902005,'3021','466',643704.76,645120.59,1415.83,920289.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257366',4902006,'3022','466',814190.11,814740.13,550.02,357513.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257366',4902007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257366',4902008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902009,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902010,'3006','465',601250.30,601278.83,28.53,4707.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902011,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902012,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902013,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902014,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902015,'3011','465',526196.22,526211.37,15.15,2499.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257367',4902016,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902017,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902018,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902019,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902020,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902021,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902022,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902023,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257367',4902024,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257367',4902025,'3021','466',645120.59,646100.67,980.08,637052.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257367',4902026,'3022','466',814740.13,817282.00,2541.87,1652215.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257367',4902027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257367',4902028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902029,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902030,'3006','465',601278.83,601278.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902031,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902032,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902033,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902034,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902035,'3011','465',526211.37,526211.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257368',4902036,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902037,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902038,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902039,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902040,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902041,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902042,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902043,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257368',4902044,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257368',4902045,'3021','466',646100.67,646344.90,244.23,158749.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257368',4902046,'3022','466',817282.00,817996.35,714.35,464327.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257368',4902047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257368',4902048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902049,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902050,'3006','465',601278.83,601278.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902051,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902052,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902053,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902054,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902055,'3011','465',526211.37,526211.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257369',4902056,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902057,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902058,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902059,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902060,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902061,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902062,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902063,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257369',4902064,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257369',4902065,'3021','466',646344.90,647760.50,1415.60,920140.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257369',4902066,'3022','466',817996.35,820509.41,2513.06,1633489.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257369',4902067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257369',4902068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902069,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902070,'3006','465',601278.83,601278.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902071,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902072,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902073,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902074,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902075,'3011','465',526211.37,526211.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257370',4902076,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902077,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902078,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902079,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902080,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902081,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902082,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902083,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257370',4902084,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257370',4902085,'3021','466',647760.50,649041.60,1281.10,832715.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257370',4902086,'3022','466',820509.41,822051.19,1541.78,1002157.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257370',4902087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257370',4902088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902089,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902090,'3006','465',601278.83,601278.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902091,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902092,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902093,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902094,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902095,'3011','465',526211.37,526211.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257371',4902096,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902097,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902098,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902099,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902100,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902101,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902102,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902103,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257371',4902104,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257371',4902105,'3021','466',649041.60,650653.12,1611.52,1047488.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257371',4902106,'3022','466',822051.19,825073.14,3021.95,1964267.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257371',4902107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257371',4902108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902109,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902110,'3006','465',601278.83,601278.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902111,'3007','465',314244.02,314244.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902112,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902113,'3009','465',199801.85,199801.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902114,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902115,'3011','465',526211.37,526211.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257372',4902116,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902117,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902118,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902119,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902120,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902121,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902122,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902123,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257372',4902124,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257372',4902125,'3021','466',650653.12,650910.99,257.87,170194.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257372',4902126,'3022','466',825073.14,826309.35,1236.21,815898.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257372',4902127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257372',4902128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902129,'3005','465',329651.60,329651.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902130,'3006','465',601278.83,603504.07,2225.24,367164.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902131,'3007','465',314244.02,317303.04,3059.02,504738.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902132,'3008','465',366461.94,366461.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902133,'3009','465',199801.85,201908.92,2107.07,347666.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902134,'3010','465',313385.71,313385.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902135,'3011','465',526211.37,528658.73,2447.36,403814.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257373',4902136,'3012','465',198894.60,198894.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902137,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902138,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902139,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902140,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902141,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902142,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902143,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257373',4902144,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257373',4902145,'3021','466',650910.99,655336.66,4425.67,2920942.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257373',4902146,'3022','466',826309.35,828865.42,2556.07,1687006.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257373',4902147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257373',4902148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902149,'3005','465',329651.60,333394.11,3742.51,617514.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902150,'3006','465',603504.07,606034.44,2530.37,417511.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902151,'3007','465',317303.04,317303.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902152,'3008','465',366461.94,369636.94,3175.00,523875.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902153,'3009','465',201908.92,201908.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902154,'3010','465',313385.71,316497.17,3111.46,513390.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902155,'3011','465',528658.73,528658.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257374',4902156,'3012','465',198894.60,201923.44,3028.84,499758.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902157,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902158,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902159,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902160,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902161,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902162,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902163,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257374',4902164,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257374',4902165,'3021','466',655336.66,656649.57,1312.91,866520.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257374',4902166,'3022','466',828865.42,830681.45,1816.03,1198579.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257374',4902167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257374',4902168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902169,'3005','465',333394.11,333394.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902170,'3006','465',606034.44,609320.50,3286.06,542199.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902171,'3007','465',317303.04,320910.89,3607.85,595295.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902172,'3008','465',369636.94,369636.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902173,'3009','465',201908.92,203832.34,1923.42,317364.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902174,'3010','465',316497.17,318783.05,2255.13,372096.45,0.00,0.00,30.75,0.00,0.00),('1','195','1019','257375',4902175,'3011','465',528658.73,530792.72,2133.99,352108.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257375',4902176,'3012','465',201923.44,203632.98,1709.54,282074.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902177,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902178,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902179,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902180,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902181,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902182,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902183,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257375',4902184,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257375',4902185,'3021','466',656649.57,658658.70,2009.13,1326025.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257375',4902186,'3022','466',830681.45,831663.20,981.75,647955.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257375',4902187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257375',4902188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902189,'3005','465',333394.11,333811.22,417.11,68823.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902190,'3006','465',609320.50,610168.73,848.23,139957.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902191,'3007','465',320910.89,320910.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902192,'3008','465',369636.94,370893.72,1256.78,207368.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902193,'3009','465',203832.34,203973.53,141.19,23296.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902194,'3010','465',318783.05,319694.84,911.79,150445.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902195,'3011','465',530792.72,531681.50,888.78,146648.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257376',4902196,'3012','465',203632.98,203632.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902197,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902198,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902199,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902200,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902201,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902202,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902203,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257376',4902204,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257376',4902205,'3021','466',658658.70,660566.94,1908.24,1259438.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257376',4902206,'3022','466',831663.20,833342.99,1679.79,1108661.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257376',4902207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257376',4902208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902209,'3005','465',333811.22,335035.88,1214.66,200418.90,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257377',4902210,'3006','465',610168.73,612205.29,2036.56,336032.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902211,'3007','465',320910.89,323452.81,2541.92,419416.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902212,'3008','465',370893.72,373079.05,2185.33,360579.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902213,'3009','465',203973.53,203973.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902214,'3010','465',319694.84,321694.13,1999.29,329882.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902215,'3011','465',531681.50,533823.79,2142.29,353477.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257377',4902216,'3012','465',203632.98,204966.42,1333.44,220017.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902217,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902218,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902219,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902220,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902221,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902222,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902223,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257377',4902224,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257377',4902225,'3021','466',660566.94,662701.68,2134.74,1408928.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257377',4902226,'3022','466',833342.99,836034.03,2691.04,1776086.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257377',4902227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257377',4902228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902229,'3005','465',335035.88,335632.87,596.99,98503.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902230,'3006','465',612205.29,615315.77,3110.48,513229.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902231,'3007','465',323452.81,326488.69,3035.88,500920.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902232,'3008','465',373079.05,373079.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902233,'3009','465',203973.53,205184.67,1211.14,199838.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902234,'3010','465',321694.13,323059.96,1365.83,225361.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902235,'3011','465',533823.79,536123.29,2299.50,379417.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257378',4902236,'3012','465',204966.42,205549.79,583.37,96256.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902237,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902238,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902239,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902240,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902241,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902242,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902243,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257378',4902244,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257378',4902245,'3021','466',662701.68,663396.69,695.01,465656.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257378',4902246,'3022','466',836034.03,836627.73,593.70,397779.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257378',4902247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257378',4902248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902249,'3005','465',335632.87,337441.85,1808.98,298481.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902250,'3006','465',615315.77,617786.23,2470.46,407625.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902251,'3007','465',326488.69,326488.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902252,'3008','465',373079.05,375364.73,2285.68,377137.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902253,'3009','465',205184.67,206815.84,1631.17,269143.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902254,'3010','465',323059.96,324930.46,1870.50,308632.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902255,'3011','465',536123.29,538216.40,2093.11,345363.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257379',4902256,'3012','465',205549.79,206721.07,1171.28,193261.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902257,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902258,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902259,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902260,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902261,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902262,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902263,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257379',4902264,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257379',4902265,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257379',4902266,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257379',4902267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257379',4902268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902269,'3005','465',337441.85,338882.13,1440.28,237646.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902270,'3006','465',617786.23,619201.35,1415.12,233494.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902271,'3007','465',326488.69,326488.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902272,'3008','465',375364.73,377056.83,1692.10,279196.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902273,'3009','465',206815.84,206815.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902274,'3010','465',324930.46,325867.46,937.00,154605.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902275,'3011','465',538216.40,539497.73,1281.33,211419.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257380',4902276,'3012','465',206721.07,207544.67,823.60,135894.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902277,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902278,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902279,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902280,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902281,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902282,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902283,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257380',4902284,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257380',4902285,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257380',4902286,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257380',4902287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257380',4902288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902289,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902290,'3006','465',619201.35,619201.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902291,'3007','465',326488.69,327175.52,686.83,113326.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902292,'3008','465',377056.83,377667.14,610.31,100701.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902293,'3009','465',206815.84,207118.59,302.75,49953.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902294,'3010','465',325867.46,326250.65,383.19,63226.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902295,'3011','465',539497.73,540046.88,549.15,90609.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257381',4902296,'3012','465',207544.67,207991.67,447.00,73755.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902297,'3013','465',203758.95,203758.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902298,'3014','465',431075.08,431075.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902299,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902300,'3016','465',278310.99,278310.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902301,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902302,'3018','465',287092.70,287092.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902303,'3019','465',242503.50,242503.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257381',4902304,'3020','465',170395.15,170395.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257381',4902305,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257381',4902306,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257381',4902307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257381',4902308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902309,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902310,'3006','465',619201.35,619201.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902311,'3007','465',327175.52,327175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902312,'3008','465',377667.14,377667.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902313,'3009','465',207118.59,207118.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902314,'3010','465',326250.65,326250.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902315,'3011','465',540046.88,540046.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257382',4902316,'3012','465',207991.67,207991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902317,'3013','465',203758.95,204823.91,1064.96,175718.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902318,'3014','465',431075.08,431969.89,894.81,147643.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902319,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902320,'3016','465',278310.99,278543.10,232.11,38298.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902321,'3017','465',121319.67,121319.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902322,'3018','465',287092.70,287809.71,717.01,118306.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902323,'3019','465',242503.50,242504.32,0.82,135.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257382',4902324,'3020','465',170395.15,171113.58,718.43,118540.95,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257382',4902325,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257382',4902326,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257382',4902327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257382',4902328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902329,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902330,'3006','465',619201.35,619201.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902331,'3007','465',327175.52,327175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902332,'3008','465',377667.14,377667.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902333,'3009','465',207118.59,207118.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902334,'3010','465',326250.65,326250.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902335,'3011','465',540046.88,540046.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257383',4902336,'3012','465',207991.67,207991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902337,'3013','465',204823.91,206889.83,2065.92,340876.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902338,'3014','465',431969.89,433893.73,1923.84,317433.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902339,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902340,'3016','465',278543.10,278543.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902341,'3017','465',121319.67,123041.70,1722.03,284134.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902342,'3018','465',287809.71,290110.55,2300.84,379638.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902343,'3019','465',242504.32,242504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257383',4902344,'3020','465',171113.58,172824.33,1710.75,282273.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257383',4902345,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257383',4902346,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257383',4902347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257383',4902348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902349,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902350,'3006','465',619201.35,621848.97,2647.62,436857.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902351,'3007','465',327175.52,327175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902352,'3008','465',377667.14,379207.03,1539.89,254081.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902353,'3009','465',207118.59,207118.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902354,'3010','465',326250.65,326807.11,556.46,91815.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902355,'3011','465',540046.88,541767.92,1721.04,283971.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257384',4902356,'3012','465',207991.67,207991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902357,'3013','465',206889.83,207001.94,112.11,18498.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902358,'3014','465',433893.73,436487.68,2593.95,428001.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902359,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902360,'3016','465',278543.10,279073.33,530.23,87487.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902361,'3017','465',123041.70,123532.97,491.27,81059.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902362,'3018','465',290110.55,291956.41,1845.86,304566.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902363,'3019','465',242504.32,242504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257384',4902364,'3020','465',172824.33,174715.18,1890.85,311990.25,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257384',4902365,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257384',4902366,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257384',4902367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257384',4902368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902369,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902370,'3006','465',621848.97,623826.75,1977.78,326333.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902371,'3007','465',327175.52,327175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902372,'3008','465',379207.03,379207.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902373,'3009','465',207118.59,207118.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902374,'3010','465',326807.11,326807.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902375,'3011','465',541767.92,541767.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257385',4902376,'3012','465',207991.67,207991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902377,'3013','465',207001.94,209099.39,2097.45,346079.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902378,'3014','465',436487.68,436487.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902379,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902380,'3016','465',279073.33,280346.00,1272.67,209990.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902381,'3017','465',123532.97,125162.41,1629.44,268857.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902382,'3018','465',291956.41,292910.78,954.37,157471.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902383,'3019','465',242504.32,242504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257385',4902384,'3020','465',174715.18,176103.50,1388.32,229072.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257385',4902385,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257385',4902386,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257385',4902387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257385',4902388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902389,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902390,'3006','465',623826.75,623826.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902391,'3007','465',327175.52,327175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902392,'3008','465',379207.03,379207.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902393,'3009','465',207118.59,207118.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902394,'3010','465',326807.11,326807.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902395,'3011','465',541767.92,541767.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257386',4902396,'3012','465',207991.67,207991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902397,'3013','465',209099.39,211876.28,2776.89,458186.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902398,'3014','465',436487.68,437813.40,1325.72,218743.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902399,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902400,'3016','465',280346.00,282947.42,2601.42,429234.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902401,'3017','465',125162.41,127004.08,1841.67,303875.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902402,'3018','465',292910.78,294629.05,1718.27,283514.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902403,'3019','465',242504.32,242504.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257386',4902404,'3020','465',176103.50,177518.58,1415.08,233488.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257386',4902405,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257386',4902406,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257386',4902407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257386',4902408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902409,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902410,'3006','465',623826.75,626308.00,2471.25,407756.25,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257387',4902411,'3007','465',327175.52,327175.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902412,'3008','465',379207.03,379207.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902413,'3009','465',207118.59,207118.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902414,'3010','465',326807.11,326807.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902415,'3011','465',541767.92,541767.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257387',4902416,'3012','465',207991.67,207991.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902417,'3013','465',211876.28,213227.51,1351.23,222952.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902418,'3014','465',437813.40,439658.77,1845.37,304486.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902419,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902420,'3016','465',282947.42,282982.87,35.45,5849.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902421,'3017','465',127004.08,128501.55,1497.47,247082.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902422,'3018','465',294629.05,296278.55,1649.50,272167.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902423,'3019','465',242504.32,242507.71,3.39,559.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257387',4902424,'3020','465',177518.58,179287.50,1768.92,291871.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257387',4902425,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257387',4902426,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257387',4902427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257387',4902428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902429,'3005','465',338882.13,338882.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902430,'3006','465',626308.00,628650.16,2342.16,386456.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902431,'3007','465',327175.52,327276.93,101.41,16732.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902432,'3008','465',379207.03,381212.11,2005.08,330838.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902433,'3009','465',207118.59,208428.82,1310.23,216187.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902434,'3010','465',326807.11,327447.67,640.56,105692.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902435,'3011','465',541767.92,543167.19,1399.27,230879.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257388',4902436,'3012','465',207991.67,209503.35,1511.68,249427.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902437,'3013','465',213227.51,213640.89,413.38,68207.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902438,'3014','465',439658.77,440047.76,388.99,64183.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902439,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902440,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902441,'3017','465',128501.55,128731.22,229.67,37895.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902442,'3018','465',296278.55,296661.87,383.32,63247.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902443,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257388',4902444,'3020','465',179287.50,179424.44,136.94,22595.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257388',4902445,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257388',4902446,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257388',4902447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257388',4902448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902449,'3005','465',338882.13,339811.93,929.80,153417.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902450,'3006','465',628650.16,630425.73,1775.57,292969.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902451,'3007','465',327276.93,329190.70,1913.77,315772.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902452,'3008','465',381212.11,383021.80,1809.69,298598.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902453,'3009','465',208428.82,208428.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902454,'3010','465',327447.67,329750.56,2302.89,379976.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902455,'3011','465',543167.19,545159.50,1992.31,328731.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257389',4902456,'3012','465',209503.35,211275.73,1772.38,292442.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902457,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902458,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902459,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902460,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902461,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902462,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902463,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257389',4902464,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257389',4902465,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257389',4902466,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257389',4902467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257389',4902468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257390',4902469,'3005','465',339811.93,341809.42,1997.49,329585.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257390',4902470,'3006','465',630425.73,632456.94,2021.21,333499.65,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257390',4902471,'3007','465',329190.70,329190.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257390',4902472,'3008','465',383021.80,385757.73,2725.93,449778.45,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257390',4902473,'3009','465',208428.82,209048.79,619.97,102295.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257390',4902474,'3010','465',329750.56,331705.01,1954.45,322484.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257390',4902475,'3011','465',545159.50,547173.09,2013.59,332242.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257390',4902476,'3012','465',211275.73,211275.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902477,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902478,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902479,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902480,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902481,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902482,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902483,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257390',4902484,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257390',4902485,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257390',4902486,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257390',4902487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257390',4902488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257391',4902489,'3005','465',341809.42,344249.56,2420.14,399323.10,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257391',4902490,'3006','465',632456.94,634288.32,1811.38,298877.87,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257391',4902491,'3007','465',329190.70,329190.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257391',4902492,'3008','465',385757.73,388449.55,2691.82,444150.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257391',4902493,'3009','465',209048.79,209880.52,811.73,133935.45,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257391',4902494,'3010','465',331705.01,333013.53,1288.52,212605.80,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257391',4902495,'3011','465',547173.09,548849.68,1666.59,274987.35,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257391',4902496,'3012','465',211275.73,212404.41,1118.68,184582.20,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257391',4902497,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902498,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902499,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902500,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902501,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902502,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902503,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257391',4902504,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257391',4902505,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257391',4902506,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257391',4902507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257391',4902508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902509,'3005','465',344249.56,344987.82,738.26,121812.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902510,'3006','465',634288.32,636091.67,1803.35,297552.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902511,'3007','465',329190.70,329962.04,771.34,127271.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902512,'3008','465',388449.55,389389.18,939.63,155038.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902513,'3009','465',209880.52,210524.74,644.22,106296.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902514,'3010','465',333013.53,334475.26,1461.73,241185.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902515,'3011','465',548849.68,550328.90,1479.22,244071.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257392',4902516,'3012','465',212404.41,212708.69,304.28,50206.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902517,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902518,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902519,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902520,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902521,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902522,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902523,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257392',4902524,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257392',4902525,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257392',4902526,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257392',4902527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257392',4902528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902529,'3005','465',344987.82,345537.82,550.00,90750.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902530,'3006','465',636091.67,638291.05,2199.38,362897.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902531,'3007','465',329962.04,331127.26,1165.22,192261.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902532,'3008','465',389389.18,391008.82,1619.64,267240.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902533,'3009','465',210524.74,212119.79,1595.05,263183.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902534,'3010','465',334475.26,335210.86,735.60,121374.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902535,'3011','465',550328.90,552094.09,1765.19,291256.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257393',4902536,'3012','465',212708.69,212708.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902537,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902538,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902539,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902540,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902541,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902542,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902543,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257393',4902544,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257393',4902545,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257393',4902546,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257393',4902547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257393',4902548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902549,'3005','465',345537.82,346471.10,933.28,153991.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902550,'3006','465',638291.05,639194.78,903.73,149115.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902551,'3007','465',331127.26,331807.12,679.86,112176.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902552,'3008','465',391008.82,392622.25,1613.43,266215.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902553,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902554,'3010','465',335210.86,336770.88,1560.02,257403.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902555,'3011','465',552094.09,553519.74,1425.65,235232.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257394',4902556,'3012','465',212708.69,213748.66,1039.97,171595.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902557,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902558,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902559,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902560,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902561,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902562,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902563,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257394',4902564,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257394',4902565,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257394',4902566,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257394',4902567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257394',4902568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902569,'3005','465',346471.10,348227.89,1756.79,289870.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902570,'3006','465',639194.78,641275.32,2080.54,343289.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902571,'3007','465',331807.12,333445.41,1638.29,270317.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902572,'3008','465',392622.25,393614.69,992.44,163752.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902573,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902574,'3010','465',336770.88,338792.01,2021.13,333486.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902575,'3011','465',553519.74,555264.36,1744.62,287862.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257395',4902576,'3012','465',213748.66,214397.36,648.70,107035.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902577,'3013','465',213640.89,213640.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902578,'3014','465',440047.76,440047.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902579,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902580,'3016','465',282982.87,282982.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902581,'3017','465',128731.22,128731.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902582,'3018','465',296661.87,296661.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902583,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257395',4902584,'3020','465',179424.44,179424.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257395',4902585,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257395',4902586,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257395',4902587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257395',4902588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902589,'3005','465',348227.89,348227.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902590,'3006','465',641275.32,641275.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902591,'3007','465',333445.41,333445.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902592,'3008','465',393614.69,394162.04,547.35,90312.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902593,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902594,'3010','465',338792.01,338792.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902595,'3011','465',555264.36,555718.35,453.99,74908.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257396',4902596,'3012','465',214397.36,214682.17,284.81,46993.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902597,'3013','465',213640.89,216082.21,2441.32,402817.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902598,'3014','465',440047.76,441558.42,1510.66,249258.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902599,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902600,'3016','465',282982.87,285104.29,2121.42,350034.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902601,'3017','465',128731.22,130162.97,1431.75,236238.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902602,'3018','465',296661.87,298886.61,2224.74,367082.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902603,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257396',4902604,'3020','465',179424.44,181313.01,1888.57,311614.05,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257396',4902605,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257396',4902606,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257396',4902607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257396',4902608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902609,'3005','465',348227.89,348227.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902610,'3006','465',641275.32,641275.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902611,'3007','465',333445.41,333445.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902612,'3008','465',394162.04,394162.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902613,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902614,'3010','465',338792.01,338792.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902615,'3011','465',555718.35,555718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257397',4902616,'3012','465',214682.17,214682.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902617,'3013','465',216082.21,218035.50,1953.29,322292.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902618,'3014','465',441558.42,443203.19,1644.77,271387.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902619,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902620,'3016','465',285104.29,288004.97,2900.68,478612.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902621,'3017','465',130162.97,131365.89,1202.92,198481.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902622,'3018','465',298886.61,301612.89,2726.28,449836.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902623,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257397',4902624,'3020','465',181313.01,183729.23,2416.22,398676.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257397',4902625,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257397',4902626,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257397',4902627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257397',4902628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902629,'3005','465',348227.89,348227.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902630,'3006','465',641275.32,641275.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902631,'3007','465',333445.41,333445.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902632,'3008','465',394162.04,394162.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902633,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902634,'3010','465',338792.01,338792.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902635,'3011','465',555718.35,555718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257398',4902636,'3012','465',214682.17,214682.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902637,'3013','465',218035.50,220575.06,2539.56,419027.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902638,'3014','465',443203.19,445315.60,2112.41,348547.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902639,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902640,'3016','465',288004.97,290056.29,2051.32,338467.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902641,'3017','465',131365.89,133300.47,1934.58,319205.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902642,'3018','465',301612.89,302827.04,1214.15,200334.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902643,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257398',4902644,'3020','465',183729.23,185583.98,1854.75,306033.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257398',4902645,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257398',4902646,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257398',4902647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257398',4902648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902649,'3005','465',348227.89,348227.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902650,'3006','465',641275.32,641275.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902651,'3007','465',333445.41,333445.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902652,'3008','465',394162.04,394162.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902653,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902654,'3010','465',338792.01,338792.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902655,'3011','465',555718.35,555718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257399',4902656,'3012','465',214682.17,214682.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902657,'3013','465',220575.06,222232.75,1657.69,273518.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902658,'3014','465',445315.60,447147.30,1831.70,302230.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902659,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902660,'3016','465',290056.29,292103.47,2047.18,337784.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902661,'3017','465',133300.47,133754.97,454.50,74992.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902662,'3018','465',302827.04,304105.42,1278.38,210932.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902663,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257399',4902664,'3020','465',185583.98,187062.02,1478.04,243876.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257399',4902665,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257399',4902666,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257399',4902667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257399',4902668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902669,'3005','465',348227.89,348227.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902670,'3006','465',641275.32,641275.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902671,'3007','465',333445.41,333445.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902672,'3008','465',394162.04,394162.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902673,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902674,'3010','465',338792.01,338792.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902675,'3011','465',555718.35,555718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257400',4902676,'3012','465',214682.17,214682.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902677,'3013','465',222232.75,222892.63,659.88,108880.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902678,'3014','465',447147.30,448199.08,1051.78,173543.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902679,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902680,'3016','465',292103.47,293527.46,1423.99,234958.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902681,'3017','465',133754.97,133795.56,40.59,6697.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902682,'3018','465',304105.42,305070.75,965.33,159279.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902683,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257400',4902684,'3020','465',187062.02,188042.79,980.77,161827.05,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257400',4902685,'3021','466',663396.69,663396.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257400',4902686,'3022','466',836627.73,836627.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257400',4902687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257400',4902688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902689,'3005','465',348227.89,348227.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902690,'3006','465',641275.32,641275.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902691,'3007','465',333445.41,333445.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902692,'3008','465',394162.04,394162.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902693,'3009','465',212119.79,212119.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902694,'3010','465',338792.01,338792.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902695,'3011','465',555718.35,555718.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257401',4902696,'3012','465',214682.17,214682.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902697,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902698,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902699,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902700,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902701,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902702,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902703,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257401',4902704,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257401',4902705,'3021','466',663396.69,664022.99,626.30,457199.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257401',4902706,'3022','466',836627.73,838319.19,1691.46,1234765.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257401',4902707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257401',4902708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902709,'3005','465',348227.89,348817.99,590.10,97366.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902710,'3006','465',641275.32,644863.66,3588.34,592076.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902711,'3007','465',333445.41,334640.61,1195.20,197208.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902712,'3008','465',394162.04,396483.61,2321.57,383059.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902713,'3009','465',212119.79,213539.15,1419.36,234194.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902714,'3010','465',338792.01,339070.32,278.31,45921.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902715,'3011','465',555718.35,559150.75,3432.40,566346.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257402',4902716,'3012','465',214682.17,214682.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902717,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902718,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902719,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902720,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902721,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902722,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902723,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257402',4902724,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257402',4902725,'3021','466',664022.99,664634.21,611.22,446190.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257402',4902726,'3022','466',838319.19,839691.94,1372.75,1002107.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257402',4902727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257402',4902728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902729,'3005','465',348817.99,350433.04,1615.05,266483.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902730,'3006','465',644863.66,646046.03,1182.37,195091.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902731,'3007','465',334640.61,335095.51,454.90,75058.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902732,'3008','465',396483.61,399824.36,3340.75,551223.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902733,'3009','465',213539.15,213803.27,264.12,43579.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902734,'3010','465',339070.32,341768.54,2698.22,445206.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902735,'3011','465',559150.75,562147.85,2997.10,494521.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257403',4902736,'3012','465',214682.17,215195.16,512.99,84643.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902737,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902738,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902739,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902740,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902741,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902742,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902743,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257403',4902744,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257403',4902745,'3021','466',664634.21,664802.09,167.88,122552.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257403',4902746,'3022','466',839691.94,841584.83,1892.89,1381809.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257403',4902747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257403',4902748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902749,'3005','465',350433.04,350433.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902750,'3006','465',646046.03,649365.98,3319.95,547791.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902751,'3007','465',335095.51,335095.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902752,'3008','465',399824.36,402660.73,2836.37,468001.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902753,'3009','465',213803.27,215931.42,2128.15,351144.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902754,'3010','465',341768.54,343147.67,1379.13,227556.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902755,'3011','465',562147.85,564923.38,2775.53,457962.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257404',4902756,'3012','465',215195.16,215195.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902757,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902758,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902759,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902760,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902761,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902762,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902763,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257404',4902764,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257404',4902765,'3021','466',664802.09,665338.78,536.69,391783.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257404',4902766,'3022','466',841584.83,841678.54,93.71,68408.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257404',4902767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257404',4902768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902769,'3005','465',350433.04,352952.54,2519.50,415717.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902770,'3006','465',649365.98,649365.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902771,'3007','465',335095.51,337321.96,2226.45,367364.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902772,'3008','465',402660.73,402660.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902773,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902774,'3010','465',343147.67,345112.25,1964.58,324155.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902775,'3011','465',564923.38,565925.30,1001.92,165316.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257405',4902776,'3012','465',215195.16,216215.39,1020.23,168337.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902777,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902778,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902779,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902780,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902781,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902782,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902783,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257405',4902784,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257405',4902785,'3021','466',665338.78,666475.32,1136.54,829674.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257405',4902786,'3022','466',841678.54,842230.33,551.79,402806.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257405',4902787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257405',4902788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902789,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902790,'3006','465',649365.98,650254.96,888.98,146681.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902791,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902792,'3008','465',402660.73,402941.28,280.55,46290.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902793,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902794,'3010','465',345112.25,345860.19,747.94,123410.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902795,'3011','465',565925.30,566861.68,936.38,154502.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257406',4902796,'3012','465',216215.39,216221.44,6.05,998.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902797,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902798,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902799,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902800,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902801,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902802,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902803,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257406',4902804,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257406',4902805,'3021','466',666475.32,666731.68,256.36,187142.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257406',4902806,'3022','466',842230.33,842849.67,619.34,452118.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257406',4902807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257406',4902808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902809,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902810,'3006','465',650254.96,650254.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902811,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902812,'3008','465',402941.28,402941.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902813,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902814,'3010','465',345860.19,345860.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902815,'3011','465',566861.68,566861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257407',4902816,'3012','465',216221.44,216221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902817,'3013','465',222892.63,222892.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902818,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902819,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902820,'3016','465',293527.46,293527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902821,'3017','465',133795.56,133795.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902822,'3018','465',305070.75,305070.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902823,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257407',4902824,'3020','465',188042.79,188042.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257407',4902825,'3021','466',666731.68,667641.68,910.00,664300.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257407',4902826,'3022','466',842849.67,844386.18,1536.51,1121652.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257407',4902827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257407',4902828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902829,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902830,'3006','465',650254.96,650254.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902831,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902832,'3008','465',402941.28,402941.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902833,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902834,'3010','465',345860.19,345860.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902835,'3011','465',566861.68,566861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257408',4902836,'3012','465',216221.44,216221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902837,'3013','465',222892.63,226179.96,3287.33,542409.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902838,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902839,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902840,'3016','465',293527.46,296021.21,2493.75,411468.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902841,'3017','465',133795.56,135732.67,1937.11,319623.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902842,'3018','465',305070.75,307276.41,2205.66,363933.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902843,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257408',4902844,'3020','465',188042.79,189497.94,1455.15,240099.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257408',4902845,'3021','466',667641.68,668084.15,442.47,323003.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257408',4902846,'3022','466',844386.18,844831.64,445.46,325185.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257408',4902847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257408',4902848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902849,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902850,'3006','465',650254.96,650254.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902851,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902852,'3008','465',402941.28,402941.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902853,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902854,'3010','465',345860.19,345860.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902855,'3011','465',566861.68,566861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257409',4902856,'3012','465',216221.44,216221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902857,'3013','465',226179.96,226179.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902858,'3014','465',448199.08,448199.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902859,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902860,'3016','465',296021.21,296021.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902861,'3017','465',135732.67,135732.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902862,'3018','465',307276.41,307276.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902863,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257409',4902864,'3020','465',189497.94,189497.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257409',4902865,'3021','466',668084.15,668084.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257409',4902866,'3022','466',844831.64,844831.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257409',4902867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257409',4902868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902869,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902870,'3006','465',650254.96,650254.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902871,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902872,'3008','465',402941.28,402941.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902873,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902874,'3010','465',345860.19,345860.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902875,'3011','465',566861.68,566861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257410',4902876,'3012','465',216221.44,216221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902877,'3013','465',226179.96,228193.23,2013.27,332189.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902878,'3014','465',448199.08,450661.06,2461.98,406226.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902879,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902880,'3016','465',296021.21,299183.99,3162.78,521858.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902881,'3017','465',135732.67,135732.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902882,'3018','465',307276.41,308710.25,1433.84,236583.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902883,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257410',4902884,'3020','465',189497.94,191565.66,2067.72,341173.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257410',4902885,'3021','466',668084.15,668257.98,173.83,126895.90,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257410',4902886,'3022','466',844831.64,845473.76,642.12,468747.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257410',4902887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257410',4902888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902889,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902890,'3006','465',650254.96,650254.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902891,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902892,'3008','465',402941.28,402941.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902893,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902894,'3010','465',345860.19,345860.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902895,'3011','465',566861.68,566861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257411',4902896,'3012','465',216221.44,216221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902897,'3013','465',228193.23,230069.40,1876.17,309568.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902898,'3014','465',450661.06,452403.20,1742.14,287453.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902899,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902900,'3016','465',299183.99,302110.35,2926.36,482849.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902901,'3017','465',135732.67,138142.11,2409.44,397557.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902902,'3018','465',308710.25,309180.01,469.76,77510.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902903,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257411',4902904,'3020','465',191565.66,193030.97,1465.31,241776.15,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257411',4902905,'3021','466',668257.98,669760.86,1502.88,1097102.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257411',4902906,'3022','466',845473.76,846623.83,1150.07,839551.10,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257411',4902907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257411',4902908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902909,'3005','465',352952.54,352952.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902910,'3006','465',650254.96,650254.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902911,'3007','465',337321.96,337321.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902912,'3008','465',402941.28,402941.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902913,'3009','465',215931.42,215931.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902914,'3010','465',345860.19,345860.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902915,'3011','465',566861.68,566861.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257412',4902916,'3012','465',216221.44,216221.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902917,'3013','465',230069.40,232607.60,2538.20,418803.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902918,'3014','465',452403.20,453161.09,757.89,125051.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902919,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902920,'3016','465',302110.35,304625.59,2515.24,415014.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902921,'3017','465',138142.11,138977.61,835.50,137857.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902922,'3018','465',309180.01,309563.69,383.68,63307.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902923,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257412',4902924,'3020','465',193030.97,195572.66,2541.69,419378.85,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257412',4902925,'3021','466',669760.86,670755.26,994.40,725912.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257412',4902926,'3022','466',846623.83,847260.84,637.01,465017.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257412',4902927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257412',4902928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902929,'3005','465',352952.54,353635.56,683.02,112698.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902930,'3006','465',650254.96,651297.14,1042.18,171959.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902931,'3007','465',337321.96,338190.42,868.46,143295.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902932,'3008','465',402941.28,403137.97,196.69,32453.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902933,'3009','465',215931.42,216518.02,586.60,96789.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902934,'3010','465',345860.19,346844.78,984.59,162457.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902935,'3011','465',566861.68,567842.89,981.21,161899.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257413',4902936,'3012','465',216221.44,216376.49,155.05,25583.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902937,'3013','465',232607.60,233910.78,1303.18,215024.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902938,'3014','465',453161.09,454246.80,1085.71,179142.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902939,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902940,'3016','465',304625.59,305878.85,1253.26,206787.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902941,'3017','465',138977.61,139943.11,965.50,159307.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902942,'3018','465',309563.69,310217.05,653.36,107804.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902943,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257413',4902944,'3020','465',195572.66,196823.04,1250.38,206312.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257413',4902945,'3021','466',670755.26,671986.41,1231.15,898739.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257413',4902946,'3022','466',847260.84,848706.69,1445.85,1055470.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257413',4902947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257413',4902948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902949,'3005','465',353635.56,355257.73,1622.17,267658.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902950,'3006','465',651297.14,653722.65,2425.51,400209.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902951,'3007','465',338190.42,339626.17,1435.75,236898.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902952,'3008','465',403137.97,403313.88,175.91,29025.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902953,'3009','465',216518.02,217221.12,703.10,116011.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902954,'3010','465',346844.78,348396.69,1551.91,256065.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902955,'3011','465',567842.89,570046.46,2203.57,363589.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257414',4902956,'3012','465',216376.49,216752.08,375.59,61972.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902957,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902958,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902959,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902960,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902961,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902962,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902963,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257414',4902964,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257414',4902965,'3021','466',671986.41,672727.16,740.75,540747.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257414',4902966,'3022','466',848706.69,849142.78,436.09,318345.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257414',4902967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257414',4902968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902969,'3005','465',355257.73,356208.60,940.87,155243.55,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257415',4902970,'3006','465',653722.65,655899.81,2177.16,359231.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902971,'3007','465',339626.17,340800.17,1174.00,193710.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902972,'3008','465',403313.88,403870.06,556.18,91769.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902973,'3009','465',217221.12,218673.59,1452.47,239657.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902974,'3010','465',348396.69,350627.16,2230.47,368027.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902975,'3011','465',570046.46,570664.14,617.68,101917.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257415',4902976,'3012','465',216752.08,218806.53,2044.45,337334.25,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257415',4902977,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902978,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902979,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902980,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902981,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902982,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902983,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257415',4902984,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257415',4902985,'3021','466',672727.16,673233.55,506.39,369664.70,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257415',4902986,'3022','466',849142.78,849617.52,474.74,346560.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257415',4902987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257415',4902988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902989,'3005','465',356208.60,358354.96,2146.36,354149.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902990,'3006','465',655899.81,656826.84,927.03,152959.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902991,'3007','465',340800.17,343192.89,2392.72,394798.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902992,'3008','465',403870.06,403870.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902993,'3009','465',218673.59,218753.58,79.99,13198.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902994,'3010','465',350627.16,352896.23,2269.07,374396.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902995,'3011','465',570664.14,571621.10,956.96,157898.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257416',4902996,'3012','465',218806.53,218806.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4902997,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4902998,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4902999,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4903000,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4903001,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4903002,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4903003,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257416',4903004,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257416',4903005,'3021','466',673233.55,674036.71,803.16,586306.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257416',4903006,'3022','466',849617.52,849992.26,374.74,273560.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257416',4903007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257416',4903008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903009,'3005','465',358354.96,359849.03,1494.07,246521.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903010,'3006','465',656826.84,658332.23,1505.39,248389.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903011,'3007','465',343192.89,345097.36,1904.47,314237.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903012,'3008','465',403870.06,404145.78,275.72,45493.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903013,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903014,'3010','465',352896.23,354729.88,1833.65,302552.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903015,'3011','465',571621.10,573085.29,1464.19,241591.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257417',4903016,'3012','465',218806.53,219268.18,461.65,76172.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903017,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903018,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903019,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903020,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903021,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903022,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903023,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257417',4903024,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257417',4903025,'3021','466',674036.71,674659.86,623.15,454899.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257417',4903026,'3022','466',849992.26,851286.26,1294.00,944620.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257417',4903027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257417',4903028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903029,'3005','465',359849.03,360889.89,1040.86,171741.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903030,'3006','465',658332.23,659098.62,766.39,126454.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903031,'3007','465',345097.36,345097.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903032,'3008','465',404145.78,405163.88,1018.10,167986.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903033,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903034,'3010','465',354729.88,355686.10,956.22,157776.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903035,'3011','465',573085.29,574323.04,1237.75,204228.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257418',4903036,'3012','465',219268.18,219268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903037,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903038,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903039,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903040,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903041,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903042,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903043,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257418',4903044,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257418',4903045,'3021','466',674659.86,676710.48,2050.62,1517458.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257418',4903046,'3022','466',851286.26,851630.19,343.93,254508.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257418',4903047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257418',4903048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903049,'3005','465',360889.89,360889.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903050,'3006','465',659098.62,659098.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903051,'3007','465',345097.36,345097.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903052,'3008','465',405163.88,405163.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903053,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903054,'3010','465',355686.10,355686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903055,'3011','465',574323.04,574323.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257419',4903056,'3012','465',219268.18,219268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903057,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903058,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903059,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903060,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903061,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903062,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903063,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257419',4903064,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257419',4903065,'3021','466',676710.48,678231.16,1520.68,1125303.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257419',4903066,'3022','466',851630.19,852457.95,827.76,612542.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257419',4903067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257419',4903068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903069,'3005','465',360889.89,360889.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903070,'3006','465',659098.62,659098.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903071,'3007','465',345097.36,345097.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903072,'3008','465',405163.88,405163.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903073,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903074,'3010','465',355686.10,355686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903075,'3011','465',574323.04,574323.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257420',4903076,'3012','465',219268.18,219268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903077,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903078,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903079,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903080,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903081,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903082,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903083,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257420',4903084,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257420',4903085,'3021','466',678231.16,679171.02,939.86,695496.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257420',4903086,'3022','466',852457.95,853773.12,1315.17,973225.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257420',4903087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257420',4903088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903089,'3005','465',360889.89,360889.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903090,'3006','465',659098.62,659098.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903091,'3007','465',345097.36,345097.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903092,'3008','465',405163.88,405163.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903093,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903094,'3010','465',355686.10,355686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903095,'3011','465',574323.04,574323.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257421',4903096,'3012','465',219268.18,219268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903097,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903098,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903099,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903100,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903101,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903102,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903103,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257421',4903104,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257421',4903105,'3021','466',679171.02,682173.00,3001.98,2221465.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257421',4903106,'3022','466',853773.12,856671.85,2898.73,2145060.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257421',4903107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257421',4903108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903109,'3005','465',360889.89,360889.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903110,'3006','465',659098.62,659098.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903111,'3007','465',345097.36,345097.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903112,'3008','465',405163.88,405163.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903113,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903114,'3010','465',355686.10,355686.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903115,'3011','465',574323.04,574323.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257422',4903116,'3012','465',219268.18,219268.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903117,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903118,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903119,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903120,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903121,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903122,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903123,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257422',4903124,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257422',4903125,'3021','466',682173.00,683545.12,1372.12,1015368.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257422',4903126,'3022','466',856671.85,856963.33,291.48,215695.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257422',4903127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257422',4903128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903129,'3005','465',360889.89,362634.48,1744.59,287857.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903130,'3006','465',659098.62,660824.01,1725.39,284689.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903131,'3007','465',345097.36,348423.25,3325.89,548771.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903132,'3008','465',405163.88,405163.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903133,'3009','465',218753.58,218753.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903134,'3010','465',355686.10,358569.18,2883.08,475708.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903135,'3011','465',574323.04,576323.36,2000.32,330052.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257423',4903136,'3012','465',219268.18,220889.67,1621.49,267545.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903137,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903138,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903139,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903140,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903141,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903142,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903143,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257423',4903144,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257423',4903145,'3021','466',683545.12,685108.97,1563.85,1157249.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257423',4903146,'3022','466',856963.33,858248.86,1285.53,951292.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257423',4903147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257423',4903148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903149,'3005','465',362634.48,363645.43,1010.95,166806.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903150,'3006','465',660824.01,663322.03,2498.02,412173.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903151,'3007','465',348423.25,349919.14,1495.89,246821.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903152,'3008','465',405163.88,407107.84,1943.96,320753.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903153,'3009','465',218753.58,219178.06,424.48,70039.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903154,'3010','465',358569.18,361132.66,2563.48,422974.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903155,'3011','465',576323.36,578838.47,2515.11,414993.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257424',4903156,'3012','465',220889.67,220892.70,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903157,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903158,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903159,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903160,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903161,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903162,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903163,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257424',4903164,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257424',4903165,'3021','466',685108.97,685951.12,842.15,623191.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257424',4903166,'3022','466',858248.86,859414.38,1165.52,862484.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257424',4903167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257424',4903168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903169,'3005','465',363645.43,365267.73,1622.30,267679.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903170,'3006','465',663322.03,665023.85,1701.82,280800.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903171,'3007','465',349919.14,351488.56,1569.42,258954.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903172,'3008','465',407107.84,408800.48,1692.64,279285.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903173,'3009','465',219178.06,219178.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903174,'3010','465',361132.66,363512.05,2379.39,392599.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903175,'3011','465',578838.47,580081.20,1242.73,205050.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257425',4903176,'3012','465',220892.70,222426.40,1533.70,253060.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903177,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903178,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903179,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903180,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903181,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903182,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903183,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257425',4903184,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257425',4903185,'3021','466',685951.12,687807.84,1856.72,1373972.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257425',4903186,'3022','466',859414.38,860778.54,1364.16,1009478.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257425',4903187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257425',4903188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903189,'3005','465',365267.73,366832.14,1564.41,258127.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903190,'3006','465',665023.85,667018.26,1994.41,329077.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903191,'3007','465',351488.56,351783.99,295.43,48745.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903192,'3008','465',408800.48,410916.03,2115.55,349065.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903193,'3009','465',219178.06,219858.27,680.21,112234.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903194,'3010','465',363512.05,364096.86,584.81,96493.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903195,'3011','465',580081.20,582406.45,2325.25,383666.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257426',4903196,'3012','465',222426.40,222426.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903197,'3013','465',233910.78,233910.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903198,'3014','465',454246.80,454246.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903199,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903200,'3016','465',305878.85,305878.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903201,'3017','465',139943.11,139943.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903202,'3018','465',310217.05,310217.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903203,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257426',4903204,'3020','465',196823.04,196823.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257426',4903205,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257426',4903206,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257426',4903207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257426',4903208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903209,'3005','465',366832.14,367276.82,444.68,73372.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903210,'3006','465',667018.26,667527.85,509.59,84082.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903211,'3007','465',351783.99,351783.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903212,'3008','465',410916.03,411358.14,442.11,72948.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903213,'3009','465',219858.27,220155.79,297.52,49090.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903214,'3010','465',364096.86,364330.33,233.47,38522.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903215,'3011','465',582406.45,582528.24,121.79,20095.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257427',4903216,'3012','465',222426.40,222755.28,328.88,54265.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903217,'3013','465',233910.78,235889.60,1978.82,326505.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903218,'3014','465',454246.80,455506.44,1259.64,207840.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903219,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903220,'3016','465',305878.85,307267.79,1388.94,229175.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903221,'3017','465',139943.11,141504.41,1561.30,257614.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903222,'3018','465',310217.05,311716.29,1499.24,247374.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903223,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257427',4903224,'3020','465',196823.04,198095.28,1252.24,206619.60,0.00,0.00,20.00,0.00,0.00),('1','195','1021','257427',4903225,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257427',4903226,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257427',4903227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257427',4903228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903229,'3005','465',367276.82,367276.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903230,'3006','465',667527.85,667527.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903231,'3007','465',351783.99,351783.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903232,'3008','465',411358.14,411358.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903233,'3009','465',220155.79,220155.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903234,'3010','465',364330.33,364330.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903235,'3011','465',582528.24,582528.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257428',4903236,'3012','465',222755.28,222755.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903237,'3013','465',235889.60,239121.99,3232.39,533344.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903238,'3014','465',455506.44,455506.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903239,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903240,'3016','465',307267.79,310572.73,3304.94,545315.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903241,'3017','465',141504.41,143378.67,1874.26,309252.90,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903242,'3018','465',311716.29,312447.46,731.17,120643.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903243,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257428',4903244,'3020','465',198095.28,199758.43,1663.15,274419.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257428',4903245,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257428',4903246,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257428',4903247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257428',4903248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903249,'3005','465',367276.82,369198.51,1921.69,317078.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903250,'3006','465',667527.85,669220.08,1692.23,279217.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903251,'3007','465',351783.99,353749.14,1965.15,324249.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903252,'3008','465',411358.14,411358.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903253,'3009','465',220155.79,220155.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903254,'3010','465',364330.33,365910.65,1580.32,260752.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903255,'3011','465',582528.24,584634.76,2106.52,347575.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257429',4903256,'3012','465',222755.28,222755.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903257,'3013','465',239121.99,239506.58,384.59,63457.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903258,'3014','465',455506.44,455506.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903259,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903260,'3016','465',310572.73,311201.45,628.72,103738.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903261,'3017','465',143378.67,143378.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903262,'3018','465',312447.46,313079.60,632.14,104303.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903263,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257429',4903264,'3020','465',199758.43,200361.23,602.80,99462.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257429',4903265,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257429',4903266,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257429',4903267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257429',4903268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257430',4903269,'3005','465',369198.51,369673.93,465.42,76794.30,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257430',4903270,'3006','465',669220.08,671584.08,2354.00,388410.00,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257430',4903271,'3007','465',353749.14,354785.52,1016.38,167702.70,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257430',4903272,'3008','465',411358.14,413197.96,1829.82,301920.30,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257430',4903273,'3009','465',220155.79,221820.02,1664.23,274597.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257430',4903274,'3010','465',365910.65,366626.86,706.21,116524.65,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257430',4903275,'3011','465',584634.76,585615.21,970.45,160124.25,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257430',4903276,'3012','465',222755.28,224096.44,1341.16,221291.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903277,'3013','465',239506.58,239944.46,437.88,72250.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903278,'3014','465',455506.44,455506.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903279,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903280,'3016','465',311201.45,311631.92,430.47,71027.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903281,'3017','465',143378.67,143378.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903282,'3018','465',313079.60,313527.70,448.10,73936.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903283,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257430',4903284,'3020','465',200361.23,200361.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257430',4903285,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257430',4903286,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257430',4903287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257430',4903288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903289,'3005','465',369673.93,371772.12,2098.19,346201.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903290,'3006','465',671584.08,673524.92,1940.84,320238.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903291,'3007','465',354785.52,354845.93,60.41,9967.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903292,'3008','465',413197.96,415613.45,2415.49,398555.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903293,'3009','465',221820.02,222847.68,1027.66,169563.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903294,'3010','465',366626.86,368877.16,2250.30,371299.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903295,'3011','465',585615.21,587400.97,1785.76,294650.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257431',4903296,'3012','465',224096.44,224647.36,550.92,90901.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903297,'3013','465',239944.46,239944.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903298,'3014','465',455506.44,455506.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903299,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903300,'3016','465',311631.92,311631.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903301,'3017','465',143378.67,143378.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903302,'3018','465',313527.70,313527.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903303,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257431',4903304,'3020','465',200361.23,200361.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257431',4903305,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257431',4903306,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257431',4903307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257431',4903308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903309,'3005','465',371772.12,374069.17,2297.05,379013.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903310,'3006','465',673524.92,676210.24,2685.32,443077.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903311,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903312,'3008','465',415613.45,418401.09,2787.64,459960.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903313,'3009','465',222847.68,224160.26,1312.58,216575.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903314,'3010','465',368877.16,370279.24,1402.08,231343.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903315,'3011','465',587400.97,589966.78,2565.81,423358.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257432',4903316,'3012','465',224647.36,225949.86,1302.50,214912.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903317,'3013','465',239944.46,239944.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903318,'3014','465',455506.44,455506.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903319,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903320,'3016','465',311631.92,311631.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903321,'3017','465',143378.67,143378.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903322,'3018','465',313527.70,313527.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903323,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257432',4903324,'3020','465',200361.23,200361.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257432',4903325,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257432',4903326,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257432',4903327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257432',4903328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903329,'3005','465',374069.17,376629.18,2560.01,422401.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903330,'3006','465',676210.24,678448.71,2238.47,369347.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903331,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903332,'3008','465',418401.09,420877.62,2476.53,408627.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903333,'3009','465',224160.26,225042.33,882.07,145541.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903334,'3010','465',370279.24,372148.73,1869.49,308465.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903335,'3011','465',589966.78,591533.59,1566.81,258523.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257433',4903336,'3012','465',225949.86,227604.75,1654.89,273056.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903337,'3013','465',239944.46,239944.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903338,'3014','465',455506.44,455506.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903339,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903340,'3016','465',311631.92,311631.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903341,'3017','465',143378.67,143378.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903342,'3018','465',313527.70,313527.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903343,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257433',4903344,'3020','465',200361.23,200361.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257433',4903345,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257433',4903346,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257433',4903347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257433',4903348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903349,'3005','465',376629.18,376629.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903350,'3006','465',678448.71,678448.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903351,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903352,'3008','465',420877.62,420877.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903353,'3009','465',225042.33,225042.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903354,'3010','465',372148.73,372148.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903355,'3011','465',591533.59,591533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257434',4903356,'3012','465',227604.75,227604.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903357,'3013','465',239944.46,242135.14,2190.68,361462.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903358,'3014','465',455506.44,457460.03,1953.59,322342.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903359,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903360,'3016','465',311631.92,314730.86,3098.94,511325.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903361,'3017','465',143378.67,143398.06,19.39,3199.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903362,'3018','465',313527.70,315434.23,1906.53,314577.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903363,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257434',4903364,'3020','465',200361.23,202256.46,1895.23,312712.95,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257434',4903365,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257434',4903366,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257434',4903367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257434',4903368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903369,'3005','465',376629.18,376629.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903370,'3006','465',678448.71,678448.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903371,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903372,'3008','465',420877.62,420877.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903373,'3009','465',225042.33,225042.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903374,'3010','465',372148.73,372148.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903375,'3011','465',591533.59,591533.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257435',4903376,'3012','465',227604.75,227604.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903377,'3013','465',242135.14,244429.87,2294.73,378630.45,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903378,'3014','465',457460.03,459356.15,1896.12,312859.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903379,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903380,'3016','465',314730.86,316718.43,1987.57,327949.05,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903381,'3017','465',143398.06,144822.15,1424.09,234974.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903382,'3018','465',315434.23,317279.37,1845.14,304448.10,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903383,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257435',4903384,'3020','465',202256.46,203707.68,1451.22,239451.30,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257435',4903385,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257435',4903386,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257435',4903387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257435',4903388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903389,'3005','465',376629.18,378790.05,2160.87,356543.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903390,'3006','465',678448.71,680181.55,1732.84,285918.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903391,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903392,'3008','465',420877.62,423390.46,2512.84,414618.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903393,'3009','465',225042.33,225042.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903394,'3010','465',372148.73,374645.89,2497.16,412031.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903395,'3011','465',591533.59,593807.66,2274.07,375221.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257436',4903396,'3012','465',227604.75,228119.85,515.10,84991.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903397,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903398,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903399,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903400,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903401,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903402,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903403,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257436',4903404,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257436',4903405,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257436',4903406,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257436',4903407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257436',4903408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903409,'3005','465',378790.05,381676.53,2886.48,476269.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903410,'3006','465',680181.55,682380.73,2199.18,362864.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903411,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903412,'3008','465',423390.46,426514.36,3123.90,515443.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903413,'3009','465',225042.33,226471.69,1429.36,235844.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903414,'3010','465',374645.89,376991.70,2345.81,387058.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903415,'3011','465',593807.66,595643.95,1836.29,302987.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257437',4903416,'3012','465',228119.85,229770.32,1650.47,272327.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903417,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903418,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903419,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903420,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903421,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903422,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903423,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257437',4903424,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257437',4903425,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257437',4903426,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257437',4903427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257437',4903428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903429,'3005','465',381676.53,382036.61,360.08,59413.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903430,'3006','465',682380.73,685427.68,3046.95,502746.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903431,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903432,'3008','465',426514.36,429875.66,3361.30,554614.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903433,'3009','465',226471.69,228218.12,1746.43,288160.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903434,'3010','465',376991.70,378746.73,1755.03,289579.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903435,'3011','465',595643.95,597971.50,2327.55,384045.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257438',4903436,'3012','465',229770.32,232123.88,2353.56,388337.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903437,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903438,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903439,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903440,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903441,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903442,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903443,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257438',4903444,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257438',4903445,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257438',4903446,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257438',4903447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257438',4903448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903449,'3005','465',382036.61,383125.40,1088.79,179650.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903450,'3006','465',685427.68,687961.78,2534.10,418126.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903451,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903452,'3008','465',429875.66,433313.66,3438.00,567270.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903453,'3009','465',228218.12,230143.27,1925.15,317649.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903454,'3010','465',378746.73,381671.28,2924.55,482550.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903455,'3011','465',597971.50,600797.65,2826.15,466314.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257439',4903456,'3012','465',232123.88,233963.78,1839.90,303583.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903457,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903458,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903459,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903460,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903461,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903462,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903463,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257439',4903464,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257439',4903465,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257439',4903466,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257439',4903467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257439',4903468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903469,'3005','465',383125.40,384835.03,1709.63,282088.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903470,'3006','465',687961.78,690338.32,2376.54,392129.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903471,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903472,'3008','465',433313.66,435467.95,2154.29,355457.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903473,'3009','465',230143.27,231451.67,1308.40,215886.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903474,'3010','465',381671.28,383197.09,1525.81,251758.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903475,'3011','465',600797.65,602892.75,2095.10,345691.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257440',4903476,'3012','465',233963.78,234892.43,928.65,153227.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903477,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903478,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903479,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903480,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903481,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903482,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903483,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257440',4903484,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257440',4903485,'3021','466',687807.84,687807.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257440',4903486,'3022','466',860778.54,860778.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257440',4903487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257440',4903488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903489,'3005','465',384835.03,385668.97,833.94,137600.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903490,'3006','465',690338.32,691440.31,1101.99,181828.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903491,'3007','465',354845.93,354845.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903492,'3008','465',435467.95,436996.06,1528.11,252138.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903493,'3009','465',231451.67,231451.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903494,'3010','465',383197.09,384540.72,1343.63,221698.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903495,'3011','465',602892.75,603958.40,1065.65,175832.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257441',4903496,'3012','465',234892.43,235618.99,726.56,119882.40,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903497,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903498,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903499,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903500,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903501,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903502,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903503,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257441',4903504,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257441',4903505,'3021','466',687807.84,689551.87,1744.03,1360343.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257441',4903506,'3022','466',860778.54,863088.63,2310.09,1801870.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257441',4903507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257441',4903508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903509,'3005','465',385668.97,388183.53,2514.56,414902.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903510,'3006','465',691440.31,694003.42,2563.11,422913.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903511,'3007','465',354845.93,355168.16,322.23,53167.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903512,'3008','465',436996.06,440301.75,3305.69,545438.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903513,'3009','465',231451.67,233431.81,1980.14,326723.10,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903514,'3010','465',384540.72,387125.95,2585.23,426562.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257442',4903515,'3011','465',603958.40,605948.29,1969.89,325031.85,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257442',4903516,'3012','465',235618.99,237365.80,1746.81,288223.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903517,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903518,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903519,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903520,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903521,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903522,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903523,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257442',4903524,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257442',4903525,'3021','466',689551.87,691836.73,2284.86,1782190.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257442',4903526,'3022','466',863088.63,865373.10,2284.47,1781886.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257442',4903527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257442',4903528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903529,'3005','465',388183.53,388183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903530,'3006','465',694003.42,694003.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903531,'3007','465',355168.16,355168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903532,'3008','465',440301.75,440301.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903533,'3009','465',233431.81,233431.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903534,'3010','465',387125.95,387125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903535,'3011','465',605948.29,605948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257443',4903536,'3012','465',237365.80,237365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903537,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903538,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903539,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903540,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903541,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903542,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903543,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257443',4903544,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257443',4903545,'3021','466',691836.73,694568.66,2731.93,2130905.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257443',4903546,'3022','466',865373.10,867992.22,2619.12,2042913.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257443',4903547,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257443',4903548,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903549,'3005','465',388183.53,388183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903550,'3006','465',694003.42,694003.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903551,'3007','465',355168.16,355168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903552,'3008','465',440301.75,440301.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903553,'3009','465',233431.81,233431.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903554,'3010','465',387125.95,387125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903555,'3011','465',605948.29,605948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257444',4903556,'3012','465',237365.80,237365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903557,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903558,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903559,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903560,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903561,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903562,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903563,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257444',4903564,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257444',4903565,'3021','466',694568.66,695984.97,1416.31,1104721.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257444',4903566,'3022','466',867992.22,870000.81,2008.59,1566700.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257444',4903567,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257444',4903568,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903569,'3005','465',388183.53,388183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903570,'3006','465',694003.42,694003.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903571,'3007','465',355168.16,355168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903572,'3008','465',440301.75,440301.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903573,'3009','465',233431.81,233431.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903574,'3010','465',387125.95,387125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903575,'3011','465',605948.29,605948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257445',4903576,'3012','465',237365.80,237365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903577,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903578,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903579,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903580,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903581,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903582,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903583,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257445',4903584,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257445',4903585,'3021','466',695984.97,697661.05,1676.08,1307342.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257445',4903586,'3022','466',870000.81,871729.45,1728.64,1348339.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257445',4903587,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257445',4903588,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903589,'3005','465',388183.53,388183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903590,'3006','465',694003.42,694003.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903591,'3007','465',355168.16,355168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903592,'3008','465',440301.75,440301.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903593,'3009','465',233431.81,233431.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903594,'3010','465',387125.95,387125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903595,'3011','465',605948.29,605948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257446',4903596,'3012','465',237365.80,237365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903597,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903598,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903599,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903600,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903601,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903602,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903603,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257446',4903604,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257446',4903605,'3021','466',697661.05,699794.32,2133.27,1663950.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257446',4903606,'3022','466',871729.45,874870.56,3141.11,2450065.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257446',4903607,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257446',4903608,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903609,'3005','465',388183.53,388183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903610,'3006','465',694003.42,694003.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903611,'3007','465',355168.16,355168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903612,'3008','465',440301.75,440301.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903613,'3009','465',233431.81,233431.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903614,'3010','465',387125.95,387125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903615,'3011','465',605948.29,605948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257447',4903616,'3012','465',237365.80,237365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903617,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903618,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903619,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903620,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903621,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903622,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903623,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257447',4903624,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257447',4903625,'3021','466',699794.32,703136.65,3342.33,2607017.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257447',4903626,'3022','466',874870.56,876796.29,1925.73,1502069.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257447',4903627,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257447',4903628,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903629,'3005','465',388183.53,388183.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903630,'3006','465',694003.42,694003.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903631,'3007','465',355168.16,355168.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903632,'3008','465',440301.75,440301.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903633,'3009','465',233431.81,233431.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903634,'3010','465',387125.95,387125.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903635,'3011','465',605948.29,605948.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257448',4903636,'3012','465',237365.80,237365.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903637,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903638,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903639,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903640,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903641,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903642,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903643,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257448',4903644,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257448',4903645,'3021','466',703136.65,704089.12,952.47,742926.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257448',4903646,'3022','466',876796.29,877804.29,1008.00,786240.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257448',4903647,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257448',4903648,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903649,'3005','465',388183.53,389005.34,821.81,135598.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903650,'3006','465',694003.42,694983.21,979.79,161665.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903651,'3007','465',355168.16,356093.02,924.86,152601.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903652,'3008','465',440301.75,441282.37,980.62,161802.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903653,'3009','465',233431.81,233997.33,565.52,93310.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903654,'3010','465',387125.95,387979.58,853.63,140848.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257449',4903655,'3011','465',605948.29,607147.95,578.32,95422.80,0.00,0.00,621.34,0.00,0.00),('1','195','1019','257449',4903656,'3012','465',237365.80,238245.31,779.51,128619.15,0.00,0.00,100.00,0.00,0.00),('1','195','1020','257449',4903657,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903658,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903659,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903660,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903661,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903662,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903663,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257449',4903664,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257449',4903665,'3021','466',704089.12,706341.47,2252.35,1756833.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257449',4903666,'3022','466',877804.29,880616.04,2811.75,2193165.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257449',4903667,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257449',4903668,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903669,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903670,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903671,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903672,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903673,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903674,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903675,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257450',4903676,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903677,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903678,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903679,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903680,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903681,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903682,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903683,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257450',4903684,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257450',4903685,'3021','466',706341.47,708511.85,2170.38,1692896.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257450',4903686,'3022','466',880616.04,881212.17,596.13,464981.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257450',4903687,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257450',4903688,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903689,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903690,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903691,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903692,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903693,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903694,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903695,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257451',4903696,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903697,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903698,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903699,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903700,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903701,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903702,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903703,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257451',4903704,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257451',4903705,'3021','466',708511.85,709739.94,1228.09,957910.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257451',4903706,'3022','466',881212.17,882960.69,1748.52,1363845.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257451',4903707,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257451',4903708,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903709,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903710,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903711,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903712,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903713,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903714,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903715,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257452',4903716,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903717,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903718,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903719,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903720,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903721,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903722,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903723,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257452',4903724,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257452',4903725,'3021','466',709739.94,710841.61,1101.67,859302.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257452',4903726,'3022','466',882960.69,884221.44,1260.75,983385.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257452',4903727,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257452',4903728,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903729,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903730,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903731,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903732,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903733,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903734,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903735,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257453',4903736,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903737,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903738,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903739,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903740,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903741,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903742,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903743,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257453',4903744,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257453',4903745,'3021','466',710841.61,712936.86,2095.25,1634295.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257453',4903746,'3022','466',884221.44,886087.58,1866.14,1455589.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257453',4903747,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257453',4903748,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903749,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903750,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903751,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903752,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903753,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903754,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903755,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257454',4903756,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903757,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903758,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903759,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903760,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903761,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903762,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903763,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257454',4903764,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257454',4903765,'3021','466',712936.86,714120.00,1183.14,922849.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257454',4903766,'3022','466',886087.58,887913.10,1825.52,1423905.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257454',4903767,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257454',4903768,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903769,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903770,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903771,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903772,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903773,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903774,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903775,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257455',4903776,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903777,'3013','465',244429.87,244429.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903778,'3014','465',459356.15,459356.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903779,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903780,'3016','465',316718.43,316718.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903781,'3017','465',144822.15,144822.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903782,'3018','465',317279.37,317279.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903783,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257455',4903784,'3020','465',203707.68,203707.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257455',4903785,'3021','466',714120.00,716001.54,1881.54,1467601.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257455',4903786,'3022','466',887913.10,891402.01,3488.91,2721349.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257455',4903787,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257455',4903788,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903789,'3005','465',389005.34,389005.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903790,'3006','465',694983.21,694983.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903791,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903792,'3008','465',441282.37,441282.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903793,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903794,'3010','465',387979.58,387979.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903795,'3011','465',607147.95,607147.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257456',4903796,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903797,'3013','465',244429.87,246328.86,1898.99,313333.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903798,'3014','465',459356.15,461190.82,1834.67,302720.55,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903799,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903800,'3016','465',316718.43,319338.74,2620.31,432351.15,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903801,'3017','465',144822.15,146712.95,1890.80,311982.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903802,'3018','465',317279.37,319094.26,1814.89,299456.85,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903803,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257456',4903804,'3020','465',203707.68,203727.68,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','195','1021','257456',4903805,'3021','466',716001.54,717521.91,1520.37,1185888.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257456',4903806,'3022','466',891402.01,894361.23,2959.22,2308191.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257456',4903807,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257456',4903808,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903809,'3005','465',389005.34,390470.53,1465.19,241756.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903810,'3006','465',694983.21,696088.54,1105.33,182379.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903811,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903812,'3008','465',441282.37,442649.33,1366.96,225548.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903813,'3009','465',233997.33,233997.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903814,'3010','465',387979.58,389512.38,1532.80,252912.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903815,'3011','465',607147.95,608605.47,1457.52,240490.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257457',4903816,'3012','465',238245.31,238245.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903817,'3013','465',246328.86,247314.64,985.78,162653.70,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903818,'3014','465',461190.82,462109.61,918.79,151600.35,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903819,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903820,'3016','465',319338.74,320279.74,941.00,155265.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903821,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903822,'3018','465',319094.26,320115.11,1020.85,168440.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903823,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257457',4903824,'3020','465',203727.68,204765.87,1038.19,171301.35,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257457',4903825,'3021','466',717521.91,718265.88,743.97,580296.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257457',4903826,'3022','466',894361.23,896005.13,1643.90,1282242.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257457',4903827,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257457',4903828,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903829,'3005','465',390470.53,393641.32,3170.79,523180.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903830,'3006','465',696088.54,698944.17,2855.63,471178.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903831,'3007','465',356093.02,356093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903832,'3008','465',442649.33,446562.65,3913.32,645697.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903833,'3009','465',233997.33,234569.35,572.02,94383.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903834,'3010','465',389512.38,392524.33,3011.95,496971.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903835,'3011','465',608605.47,610844.22,2238.75,369393.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257458',4903836,'3012','465',238245.31,238458.63,213.32,35197.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903837,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903838,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903839,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903840,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903841,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903842,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903843,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257458',4903844,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257458',4903845,'3021','466',718265.88,720067.31,1801.43,1405115.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257458',4903846,'3022','466',896005.13,899082.39,3077.26,2400262.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257458',4903847,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257458',4903848,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903849,'3005','465',393641.32,396514.51,2873.19,474076.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903850,'3006','465',698944.17,699669.22,725.05,119633.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903851,'3007','465',356093.02,359960.34,3867.32,638107.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903852,'3008','465',446562.65,446562.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903853,'3009','465',234569.35,237206.17,2636.82,435075.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903854,'3010','465',392524.33,395253.51,2729.18,450314.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903855,'3011','465',610844.22,613747.48,2903.26,479037.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257459',4903856,'3012','465',238458.63,239911.87,1453.24,239784.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903857,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903858,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903859,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903860,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903861,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903862,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903863,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257459',4903864,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257459',4903865,'3021','466',720067.31,723040.01,2972.70,2318706.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257459',4903866,'3022','466',899082.39,901824.36,2741.97,2138736.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257459',4903867,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257459',4903868,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903869,'3005','465',396514.51,398328.34,1813.83,299281.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903870,'3006','465',699669.22,702010.31,2341.09,386279.85,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903871,'3007','465',359960.34,360249.55,289.21,47719.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903872,'3008','465',446562.65,449879.66,3317.01,547306.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903873,'3009','465',237206.17,238364.02,1157.85,191045.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903874,'3010','465',395253.51,397645.73,2392.22,394716.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903875,'3011','465',613747.48,616325.52,2578.04,425376.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257460',4903876,'3012','465',239911.87,241054.92,1143.05,188603.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903877,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903878,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903879,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903880,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903881,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903882,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903883,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257460',4903884,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257460',4903885,'3021','466',723040.01,723552.41,512.40,399672.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257460',4903886,'3022','466',901824.36,903484.96,1660.60,1295268.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257460',4903887,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257460',4903888,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903889,'3005','465',398328.34,399308.49,980.15,161724.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903890,'3006','465',702010.31,703014.30,1003.99,165658.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903891,'3007','465',360249.55,360997.87,748.32,123472.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903892,'3008','465',449879.66,449879.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903893,'3009','465',238364.02,238636.30,272.28,44926.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903894,'3010','465',397645.73,398273.10,627.37,103516.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903895,'3011','465',616325.52,617202.88,877.36,144764.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257461',4903896,'3012','465',241054.92,241664.00,609.08,100498.20,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903897,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903898,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903899,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903900,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903901,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903902,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903903,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257461',4903904,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257461',4903905,'3021','466',723552.41,725280.00,1727.59,1347520.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257461',4903906,'3022','466',903484.96,906215.33,2730.37,2129688.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257461',4903907,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257461',4903908,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903909,'3005','465',399308.49,399968.75,660.26,108942.90,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903910,'3006','465',703014.30,704168.38,1154.08,190423.20,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903911,'3007','465',360997.87,360997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903912,'3008','465',449879.66,451490.53,1610.87,265793.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903913,'3009','465',238636.30,238636.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903914,'3010','465',398273.10,399249.90,976.80,161172.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903915,'3011','465',617202.88,618928.20,1725.32,284677.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257462',4903916,'3012','465',241664.00,241980.81,316.81,52273.65,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903917,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903918,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903919,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903920,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903921,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903922,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903923,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257462',4903924,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257462',4903925,'3021','466',725280.00,725606.74,326.74,254857.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257462',4903926,'3022','466',906215.33,907675.22,1459.89,1138714.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257462',4903927,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257462',4903928,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903929,'3005','465',399968.75,402524.58,2555.83,421711.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903930,'3006','465',704168.38,707299.05,3130.67,516560.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903931,'3007','465',360997.87,362678.44,1680.57,277294.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903932,'3008','465',451490.53,454133.86,2643.33,436149.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903933,'3009','465',238636.30,239682.73,1046.43,172660.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903934,'3010','465',399249.90,401764.14,2514.24,414849.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903935,'3011','465',618928.20,621385.31,2457.11,405423.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257463',4903936,'3012','465',241980.81,244984.21,3003.40,495561.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903937,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903938,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903939,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903940,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903941,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903942,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903943,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257463',4903944,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257463',4903945,'3021','466',725606.74,727295.73,1688.99,1317412.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257463',4903946,'3022','466',907675.22,910011.35,2336.13,1822181.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257463',4903947,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257463',4903948,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903949,'3005','465',402524.58,404012.59,1488.01,245521.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903950,'3006','465',707299.05,708391.04,1091.99,180178.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903951,'3007','465',362678.44,364101.17,1422.73,234750.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903952,'3008','465',454133.86,454133.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903953,'3009','465',239682.73,239682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903954,'3010','465',401764.14,403050.74,1286.60,212289.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903955,'3011','465',621385.31,622258.06,872.75,144003.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257464',4903956,'3012','465',244984.21,246113.65,1129.44,186357.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903957,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903958,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903959,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903960,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903961,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903962,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903963,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257464',4903964,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257464',4903965,'3021','466',727295.73,727879.49,583.76,455332.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257464',4903966,'3022','466',910011.35,911761.60,1750.25,1365195.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257464',4903967,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257464',4903968,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903969,'3005','465',404012.59,404012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903970,'3006','465',708391.04,708391.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903971,'3007','465',364101.17,364101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903972,'3008','465',454133.86,454133.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903973,'3009','465',239682.73,239682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903974,'3010','465',403050.74,403050.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903975,'3011','465',622258.06,622258.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257465',4903976,'3012','465',246113.65,246113.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903977,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903978,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903979,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903980,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903981,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903982,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903983,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257465',4903984,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257465',4903985,'3021','466',727879.49,730611.69,2732.20,2131116.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257465',4903986,'3022','466',911761.60,916184.65,4423.05,3449979.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257465',4903987,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257465',4903988,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903989,'3005','465',404012.59,404012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903990,'3006','465',708391.04,708391.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903991,'3007','465',364101.17,364101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903992,'3008','465',454133.86,454133.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903993,'3009','465',239682.73,239682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903994,'3010','465',403050.74,403050.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903995,'3011','465',622258.06,622258.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257466',4903996,'3012','465',246113.65,246113.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4903997,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4903998,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4903999,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4904000,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4904001,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4904002,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4904003,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257466',4904004,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257466',4904005,'3021','466',730611.69,731219.23,607.54,473881.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257466',4904006,'3022','466',916184.65,917000.18,815.53,636113.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257466',4904007,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257466',4904008,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904009,'3005','465',404012.59,404012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904010,'3006','465',708391.04,708391.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904011,'3007','465',364101.17,364101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904012,'3008','465',454133.86,454133.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904013,'3009','465',239682.73,239682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904014,'3010','465',403050.74,403050.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904015,'3011','465',622258.06,622258.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257467',4904016,'3012','465',246113.65,246113.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904017,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904018,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904019,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904020,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904021,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904022,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904023,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257467',4904024,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257467',4904025,'3021','466',731219.23,733019.24,1800.01,1404007.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257467',4904026,'3022','466',917000.18,919528.59,2528.41,1972159.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257467',4904027,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257467',4904028,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904029,'3005','465',404012.59,404012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904030,'3006','465',708391.04,708391.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904031,'3007','465',364101.17,364101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904032,'3008','465',454133.86,454133.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904033,'3009','465',239682.73,239682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904034,'3010','465',403050.74,403050.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904035,'3011','465',622258.06,622258.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257468',4904036,'3012','465',246113.65,246113.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904037,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904038,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904039,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904040,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904041,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904042,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904043,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257468',4904044,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257468',4904045,'3021','466',733019.24,734098.17,1078.93,841565.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257468',4904046,'3022','466',919528.59,920479.09,950.50,741390.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257468',4904047,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257468',4904048,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904049,'3005','465',404012.59,404012.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904050,'3006','465',708391.04,708391.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904051,'3007','465',364101.17,364101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904052,'3008','465',454133.86,454133.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904053,'3009','465',239682.73,239682.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904054,'3010','465',403050.74,403050.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904055,'3011','465',622258.06,622258.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257469',4904056,'3012','465',246113.65,246113.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904057,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904058,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904059,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904060,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904061,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904062,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904063,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257469',4904064,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257469',4904065,'3021','466',734098.17,735927.47,1829.30,1426854.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257469',4904066,'3022','466',920479.09,923789.78,3310.69,2582338.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257469',4904067,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257469',4904068,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904069,'3005','465',404012.59,406675.42,2662.83,439366.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904070,'3006','465',708391.04,711016.35,2625.31,433176.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904071,'3007','465',364101.17,365560.69,1459.52,240820.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904072,'3008','465',454133.86,456656.64,2522.78,416258.70,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904073,'3009','465',239682.73,241133.83,1451.10,239431.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904074,'3010','465',403050.74,404943.77,1893.03,312349.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904075,'3011','465',622258.06,624629.30,2371.24,391254.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257470',4904076,'3012','465',246113.65,247947.57,1833.92,302596.80,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904077,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904078,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904079,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904080,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904081,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904082,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904083,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257470',4904084,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257470',4904085,'3021','466',735927.47,735927.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257470',4904086,'3022','466',923789.78,923789.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257470',4904087,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257470',4904088,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904089,'3005','465',406675.42,409328.93,2653.51,437829.15,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904090,'3006','465',711016.35,713976.31,2959.96,488393.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904091,'3007','465',365560.69,366995.61,1434.92,236761.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904092,'3008','465',456656.64,458400.61,1743.97,287755.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904093,'3009','465',241133.83,243588.98,2455.15,405099.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904094,'3010','465',404943.77,407963.70,3019.93,498288.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904095,'3011','465',624629.30,627197.34,2568.04,423726.60,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257471',4904096,'3012','465',247947.57,250336.19,2388.62,394122.30,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904097,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904098,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904099,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904100,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904101,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904102,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904103,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257471',4904104,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257471',4904105,'3021','466',735927.47,735927.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257471',4904106,'3022','466',923789.78,923838.25,48.47,37806.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257471',4904107,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257471',4904108,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904109,'3005','465',409328.93,409718.40,389.47,64262.55,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904110,'3006','465',713976.31,714812.61,836.30,137989.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904111,'3007','465',366995.61,367636.60,640.99,105763.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904112,'3008','465',458400.61,459344.60,943.99,155758.35,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904113,'3009','465',243588.98,243648.10,59.12,9754.80,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904114,'3010','465',407963.70,408809.52,845.82,139560.30,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904115,'3011','465',627197.34,628264.75,1067.41,176122.65,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257472',4904116,'3012','465',250336.19,250490.59,154.40,25476.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904117,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904118,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904119,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904120,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904121,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904122,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904123,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257472',4904124,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257472',4904125,'3021','466',735927.47,735927.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257472',4904126,'3022','466',923838.25,923838.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257472',4904127,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257472',4904128,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904129,'3005','465',409718.40,410311.55,593.15,97869.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904130,'3006','465',714812.61,715405.37,592.76,97805.40,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904131,'3007','465',367636.60,367994.80,358.20,59103.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904132,'3008','465',459344.60,459779.13,434.53,71697.45,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904133,'3009','465',243648.10,243961.13,313.03,51649.95,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904134,'3010','465',408809.52,409338.09,528.57,87214.05,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904135,'3011','465',628264.75,628772.50,507.75,83778.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257473',4904136,'3012','465',250490.59,250981.43,490.84,80988.60,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904137,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904138,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904139,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904140,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904141,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904142,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904143,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257473',4904144,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257473',4904145,'3021','466',735927.47,735927.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257473',4904146,'3022','466',923838.25,923838.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257473',4904147,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257473',4904148,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904149,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904150,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904151,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904152,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904153,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904154,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904155,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257474',4904156,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904157,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904158,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904159,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904160,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904161,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904162,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904163,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257474',4904164,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257474',4904165,'3021','466',735927.47,736157.93,230.46,179758.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257474',4904166,'3022','466',923838.25,924345.43,507.18,395600.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257474',4904167,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257474',4904168,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904169,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904170,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904171,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904172,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904173,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904174,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904175,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257475',4904176,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904177,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904178,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904179,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904180,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904181,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904182,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904183,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257475',4904184,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257475',4904185,'3021','466',736157.93,736657.93,500.00,390000.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257475',4904186,'3022','466',924345.43,924621.59,276.16,215404.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257475',4904187,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257475',4904188,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904189,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904190,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904191,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904192,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904193,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904194,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904195,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257476',4904196,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904197,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904198,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904199,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904200,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904201,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904202,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904203,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257476',4904204,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257476',4904205,'3021','466',736657.93,737808.96,1151.03,897803.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257476',4904206,'3022','466',924621.59,925386.89,765.30,596934.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257476',4904207,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257476',4904208,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904209,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904210,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904211,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904212,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904213,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904214,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904215,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257477',4904216,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904217,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904218,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904219,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904220,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904221,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904222,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904223,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257477',4904224,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257477',4904225,'3021','466',737808.96,738552.42,743.46,579898.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257477',4904226,'3022','466',925386.89,925951.38,564.49,440302.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257477',4904227,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257477',4904228,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904229,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904230,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904231,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904232,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904233,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904234,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904235,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257478',4904236,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904237,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904238,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904239,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904240,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904241,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904242,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904243,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257478',4904244,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257478',4904245,'3021','466',738552.42,740257.29,1704.87,1329798.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257478',4904246,'3022','466',925951.38,927002.11,1050.73,819569.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257478',4904247,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257478',4904248,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904249,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904250,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904251,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904252,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904253,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904254,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904255,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257479',4904256,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904257,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904258,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904259,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904260,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904261,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904262,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904263,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257479',4904264,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257479',4904265,'3021','466',740257.29,741179.86,922.57,719604.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257479',4904266,'3022','466',927002.11,928421.98,1419.87,1107498.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257479',4904267,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257479',4904268,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904269,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904270,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904271,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904272,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904273,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904274,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904275,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257480',4904276,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904277,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904278,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904279,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904280,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904281,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904282,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904283,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257480',4904284,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257480',4904285,'3021','466',741179.86,743130.80,1950.94,1521733.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257480',4904286,'3022','466',928421.98,930316.17,1894.19,1477468.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257480',4904287,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257480',4904288,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904289,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904290,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904291,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904292,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904293,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904294,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904295,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257481',4904296,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904297,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904298,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904299,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904300,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904301,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904302,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904303,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257481',4904304,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257481',4904305,'3021','466',743130.80,743665.69,534.89,417214.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257481',4904306,'3022','466',930316.17,931867.48,1551.31,1210021.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257481',4904307,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257481',4904308,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904309,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904310,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904311,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904312,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904313,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904314,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904315,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257482',4904316,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904317,'3013','465',247314.64,247314.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904318,'3014','465',462109.61,462109.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904319,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904320,'3016','465',320279.74,320279.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904321,'3017','465',146712.95,146712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904322,'3018','465',320115.11,320115.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904323,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257482',4904324,'3020','465',204765.87,204765.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257482',4904325,'3021','466',743665.69,744530.68,864.99,674692.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257482',4904326,'3022','466',931867.48,932872.46,1004.98,783884.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257482',4904327,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257482',4904328,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904329,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904330,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904331,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904332,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904333,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904334,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904335,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257483',4904336,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257483',4904337,'3013','465',247314.64,250328.07,3003.43,525600.25,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257483',4904338,'3014','465',462109.61,464921.08,2801.47,490257.25,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257483',4904339,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257483',4904340,'3016','465',320279.74,324221.36,3941.62,689783.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257483',4904341,'3017','465',146712.95,148921.08,2208.13,386422.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257483',4904342,'3018','465',320115.11,323228.11,3113.00,544775.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257483',4904343,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257483',4904344,'3020','465',204765.87,208072.59,3306.72,578676.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257483',4904345,'3021','466',744530.68,745359.93,829.25,646815.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257483',4904346,'3022','466',932872.46,934149.56,1277.10,996138.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257483',4904347,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257483',4904348,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904349,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904350,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904351,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904352,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904353,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904354,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904355,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257484',4904356,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904357,'3013','465',250328.07,251010.58,682.51,119439.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904358,'3014','465',464921.08,466555.94,1634.86,286100.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904359,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904360,'3016','465',324221.36,326687.37,2466.01,431551.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904361,'3017','465',148921.08,150187.87,1266.79,221688.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904362,'3018','465',323228.11,325166.14,1938.03,339155.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904363,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257484',4904364,'3020','465',208072.59,210262.56,2189.97,383244.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257484',4904365,'3021','466',745359.93,746128.01,768.08,599102.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257484',4904366,'3022','466',934149.56,935363.56,1214.00,946920.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257484',4904367,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257484',4904368,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904369,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904370,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904371,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904372,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904373,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904374,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904375,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257485',4904376,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904377,'3013','465',251010.58,252262.75,1252.17,219129.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904378,'3014','465',466555.94,467776.07,1220.13,213522.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904379,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904380,'3016','465',326687.37,328270.26,1582.89,277005.75,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904381,'3017','465',150187.87,151485.55,1297.68,227094.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904382,'3018','465',325166.14,326288.36,1122.22,196388.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904383,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257485',4904384,'3020','465',210262.56,211623.05,1360.49,238085.75,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257485',4904385,'3021','466',746128.01,747220.95,1092.94,852493.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257485',4904386,'3022','466',935363.56,937948.37,2584.81,2016151.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257485',4904387,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257485',4904388,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904389,'3005','465',410311.55,410311.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904390,'3006','465',715405.37,715405.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904391,'3007','465',367994.80,367994.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904392,'3008','465',459779.13,459779.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904393,'3009','465',243961.13,243961.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904394,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904395,'3011','465',628772.50,628772.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257486',4904396,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904397,'3013','465',252262.75,253855.90,1593.15,278801.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904398,'3014','465',467776.07,469167.25,1391.18,243456.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904399,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904400,'3016','465',328270.26,330390.73,2120.47,371082.25,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904401,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904402,'3018','465',326288.36,327983.84,1695.48,296709.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904403,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257486',4904404,'3020','465',211623.05,213321.39,1698.34,297209.50,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257486',4904405,'3021','466',747220.95,748511.45,1290.50,1006590.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257486',4904406,'3022','466',937948.37,939845.17,1896.80,1479504.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257486',4904407,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257486',4904408,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904409,'3005','465',410311.55,411739.75,1428.20,249935.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904410,'3006','465',715405.37,717219.91,1814.54,317544.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904411,'3007','465',367994.80,369587.84,1593.04,278782.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904412,'3008','465',459779.13,461341.00,1561.87,273327.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904413,'3009','465',243961.13,245348.16,1387.03,242730.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904414,'3010','465',409338.09,409338.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904415,'3011','465',628772.50,630415.11,1642.61,287456.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257487',4904416,'3012','465',250981.43,250981.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904417,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904418,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904419,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904420,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904421,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904422,'3018','465',327983.84,327983.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904423,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257487',4904424,'3020','465',213321.39,213321.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257487',4904425,'3021','466',748511.45,749992.90,1481.45,1155531.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257487',4904426,'3022','466',939845.17,941374.55,1529.38,1192916.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257487',4904427,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257487',4904428,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904429,'3005','465',411739.75,413164.75,1415.00,247625.00,0.00,0.00,10.00,0.00,0.00),('1','195','1019','257488',4904430,'3006','465',717219.91,718496.05,1276.14,223324.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904431,'3007','465',369587.84,370526.08,938.24,164192.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904432,'3008','465',461341.00,462502.29,1161.29,203225.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904433,'3009','465',245348.16,246331.32,983.16,172053.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904434,'3010','465',409338.09,409606.63,268.54,46994.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904435,'3011','465',630415.11,630956.20,541.09,94690.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257488',4904436,'3012','465',250981.43,252058.42,1066.99,186723.25,0.00,0.00,10.00,0.00,0.00),('1','195','1020','257488',4904437,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904438,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904439,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904440,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904441,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904442,'3018','465',327983.84,327983.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904443,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257488',4904444,'3020','465',213321.39,213321.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257488',4904445,'3021','466',749992.90,752468.71,2475.81,1931131.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257488',4904446,'3022','466',941374.55,944427.96,3053.41,2381659.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257488',4904447,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257488',4904448,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904449,'3005','465',413164.75,414551.84,1387.09,242740.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904450,'3006','465',718496.05,719774.08,1278.03,223655.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904451,'3007','465',370526.08,371914.06,1387.98,242896.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904452,'3008','465',462502.29,463515.74,1013.45,177353.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904453,'3009','465',246331.32,247768.45,1437.13,251497.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904454,'3010','465',409606.63,409606.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904455,'3011','465',630956.20,631439.32,483.12,84546.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257489',4904456,'3012','465',252058.42,253564.52,1506.10,263567.50,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904457,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904458,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904459,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904460,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904461,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904462,'3018','465',327983.84,327983.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904463,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257489',4904464,'3020','465',213321.39,213321.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257489',4904465,'3021','466',752468.71,754106.03,1637.32,1277109.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257489',4904466,'3022','466',944427.96,946123.83,1695.87,1322778.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257489',4904467,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257489',4904468,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904469,'3005','465',414551.84,415168.03,616.19,107833.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904470,'3006','465',719774.08,720802.98,1028.90,180057.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904471,'3007','465',371914.06,372355.42,441.36,77238.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904472,'3008','465',463515.74,464195.15,679.41,118896.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904473,'3009','465',247768.45,248436.78,668.33,116957.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904474,'3010','465',409606.63,410371.79,765.16,133903.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904475,'3011','465',631439.32,632222.18,782.86,137000.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257490',4904476,'3012','465',253564.52,254121.56,557.04,97482.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904477,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904478,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904479,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904480,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904481,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904482,'3018','465',327983.84,327983.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904483,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257490',4904484,'3020','465',213321.39,213321.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257490',4904485,'3021','466',754106.03,754636.79,530.76,413992.80,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257490',4904486,'3022','466',946123.83,947828.90,1705.07,1329954.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257490',4904487,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257490',4904488,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904489,'3005','465',415168.03,415593.08,425.05,74383.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904490,'3006','465',720802.98,721558.70,755.72,132251.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904491,'3007','465',372355.42,373019.78,664.36,116263.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904492,'3008','465',464195.15,465123.78,928.63,162510.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904493,'3009','465',248436.78,248436.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904494,'3010','465',410371.79,411271.01,899.22,157363.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904495,'3011','465',632222.18,633015.82,793.64,138887.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257491',4904496,'3012','465',254121.56,254121.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904497,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904498,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904499,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904500,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904501,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904502,'3018','465',327983.84,327983.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904503,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257491',4904504,'3020','465',213321.39,213321.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257491',4904505,'3021','466',754636.79,755903.42,1266.63,987971.40,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257491',4904506,'3022','466',947828.90,950004.07,2175.17,1696632.60,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257491',4904507,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257491',4904508,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904509,'3005','465',415593.08,416560.96,967.88,169379.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904510,'3006','465',721558.70,722646.35,1087.65,190338.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904511,'3007','465',373019.78,373783.87,764.09,133715.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904512,'3008','465',465123.78,465456.38,332.60,58205.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904513,'3009','465',248436.78,249707.94,1271.16,222453.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904514,'3010','465',411271.01,411271.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904515,'3011','465',633015.82,634263.09,1247.27,218272.25,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257492',4904516,'3012','465',254121.56,254121.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904517,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904518,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904519,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904520,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904521,'3017','465',151485.55,151485.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904522,'3018','465',327983.84,327983.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904523,'3019','465',242507.71,242507.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257492',4904524,'3020','465',213321.39,213321.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257492',4904525,'3021','466',755903.42,757304.01,1400.59,1092460.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257492',4904526,'3022','466',950004.07,952616.21,2612.14,2037469.20,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257492',4904527,'3023','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1021','257492',4904528,'3024','466',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904529,'3005','465',416560.96,417319.70,758.74,132779.50,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904530,'3006','465',722646.35,723186.48,540.13,94522.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904531,'3007','465',373783.87,373783.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904532,'3008','465',465456.38,466230.62,774.24,135492.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904533,'3009','465',249707.94,249707.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904534,'3010','465',411271.01,411956.90,685.89,120030.75,0.00,0.00,0.00,0.00,0.00),('1','195','1019','257493',4904535,'3011','465',634263.09,635072.82,789.73,138202.75,0.00,0.00,20.00,0.00,0.00),('1','195','1019','257493',4904536,'3012','465',254121.56,254121.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257493',4904537,'3013','465',253855.90,253855.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257493',4904538,'3014','465',469167.25,469167.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257493',4904539,'3015','465',190229.99,190229.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257493',4904540,'3016','465',330390.73,330390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','195','1020','257493',490454