-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_194
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_194`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_194` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_194`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3771 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3759,400122,'',0,'22','1','194','PURCHASES','','2021-10-16 01:04:13',5,0.00,0.00,'','479','2021-10-16 01:04:13','479',0,1),(3760,20056,'',0,'20','1','194','SALES','','2021-10-16 01:04:35',5,0.00,0.00,'','479','2021-10-16 01:04:35','479',0,1),(3761,400346,'',0,'24','1','194','SALARIES & WAGES','','2021-10-16 01:05:12',5,0.00,0.00,'','479','2021-10-16 01:05:12','479',0,1),(3762,400347,'',0,'24','1','194','PURCHASES','','2021-10-16 01:05:39',5,0.00,0.00,'','479','2021-10-16 01:05:39','479',0,1),(3763,400660,'',0,'2','1','194','ZB(LPG)2014471475','','2021-10-16 01:06:56',5,0.00,0.00,'','479','2021-10-16 01:06:56','479',0,1),(3764,400661,'',0,'2','1','194','E-BILLS 1015372548','','2021-10-16 01:08:02',5,0.00,0.00,'','479','2021-10-16 01:08:02','479',0,1),(3765,400662,'',0,'2','1','194','DANKANO-EBILLS(ZNB:1014717618)','','2021-10-16 01:10:04',5,0.00,0.00,'','479','2021-10-16 01:10:04','479',0,1),(3766,400663,'',0,'2','1','194','FID POS COLLECTION-5620141491','','2021-10-16 01:11:02',5,0.00,0.00,'','479','2021-10-16 01:11:02','479',0,1),(3767,40056,'',0,'6.1','1','194','CASH','','2021-10-16 01:11:51',5,0.00,0.00,'','479','2021-10-16 01:11:51','479',0,1),(3768,400664,'',0,'2','1','194','UBA COLLECTION ACCT:1020811140','','2022-07-07 14:31:22',5,0.00,0.00,'2022-07-07','792','2022-07-07 14:32:21','792',0,0),(3769,400665,'',0,'2','1','194','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:39:47',5,0.00,0.00,'','792','2023-02-20 14:39:47','792',0,0),(3770,400666,'',0,'2','1','194','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:43:10',5,0.00,0.00,'2023-03-15','792','2023-03-17 13:59:23','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4171 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3478,'','1','194','NKEM  GAS','NKEM','07049251700','nkem@gmail,com','ASABA','DELTE','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-17 14:17:53',5,'698','2021-10-17 14:17:53','698'),(3479,'','1','194','ALL DEALER','DEALER','09121307508','jmabdullahi@yahoo.com','kano','kano','kano','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-17 14:25:56',5,'698','2021-10-17 14:25:56','698'),(3550,'','1','194','pures oil &gas','asaba','08038586467','asaba@gmail.c0m','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-20 13:39:40',5,'698','2021-10-20 13:39:40','698'),(3552,'','1','194','unstoppabedable gas','n02 ketem','08060408899','asaba@gmail.c0m','ASABA','delta','asaba ketem','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-20 13:44:36',5,'698','2021-10-20 13:44:36','698'),(3555,'','1','194','ohm ster','asaba','08032958912','asaba@gmail.c0m','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-20 13:46:46',5,'698','2021-10-20 13:46:46','698'),(3592,'','1','194','jan jay','ezeme avenue asaba','08037714770','janjay@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:01:33',5,'698','2021-10-23 11:01:33','698'),(3593,'','1','194','vtx gas ','asaba','08091952210','vtxgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:03:49',5,'698','2021-10-23 11:03:49','698'),(3594,'','1','194','uche gas','asaba','09096531333','uchegas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:06:16',5,'698','2021-10-23 11:06:16','698'),(3595,'','1','194','bishop gas','asaba','08167976447','bishop@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:09:30',5,'698','2021-10-23 11:09:30','698'),(3596,'','1','194','christian gas','asaba','08090830803','christian@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:11:33',5,'698','2021-10-23 11:11:33','698'),(3597,'','1','194','elchina gas','asaba','08052800503','elchina@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:13:40',5,'698','2021-10-23 11:13:40','698'),(3598,'','1','194','vinu gads','asaba','08081977372','vinu@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:18:19',5,'698','2021-10-23 11:18:19','698'),(3599,'','1','194','seed gas','asaba','08038676268','seed@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:20:01',5,'698','2021-10-23 11:20:01','698'),(3600,'','1','194','hfam gas','asaba','0813624636365','hfam@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:22:06',5,'698','2021-10-23 11:22:06','698'),(3601,'','1','194','anderson gas','asaba','07065704046','anderson@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:24:45',5,'698','2021-10-23 11:24:45','698'),(3602,'','1','194','ben gas','asaba','08067490804','ben@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:26:52',5,'698','2022-11-04 16:08:39','698'),(3603,'','1','194','treasuce gas','asaba','08177855129','teasure@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:28:57',5,'698','2021-10-23 11:28:57','698'),(3604,'','1','194','dominion gas','asaba','08032422660','dominion@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-23 11:30:44',5,'698','2021-10-23 11:30:44','698'),(3609,'','1','194','favor gas','asaba','07038083029','favor@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 11:28:56',5,'698','2021-10-27 11:28:56','698'),(3610,'','1','194','turity gas','08063830568','08063830568','turity@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 11:35:39',5,'698','2021-10-27 11:35:39','698'),(3611,'','1','194','frank gas','asaba','07065246642','frank@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 12:02:36',5,'698','2021-10-27 12:02:36','698'),(3612,'','1','194','anyi baba gas','asaba','07031678111','baba@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 12:17:04',5,'698','2021-10-27 12:17:04','698'),(3614,'','1','194','hutu gas','asaba','08033896087','hutugas@gmail,com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 13:22:55',5,'698','2021-10-27 13:22:55','698'),(3615,'','1','194','chinedu gas','asaba','07060501387','chinedugas@gmail,com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 13:45:30',5,'698','2021-10-27 13:45:30','698'),(3616,'','1','194','MAC FLO GAS','asaba','08166600070','macflow@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-27 14:49:50',5,'698','2021-10-27 14:49:50','698'),(3627,'','1','194','ANYI GAS','asaba','08166352557','anyigas@gmai,com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-30 10:09:46',5,'698','2021-10-30 10:09:46','698'),(3633,'','1','194','UNJ GAS','asaba','09137422135','unjgas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-30 13:02:04',5,'698','2021-11-18 08:04:23','698'),(3634,'','1','194','BOBI GAS','asaba','07032096301','bobigas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-30 14:07:08',5,'698','2021-10-30 14:07:08','698'),(3635,'','1','194','AGB GAS','asaba','08164185067','agbgas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-30 14:42:04',5,'698','2021-10-30 14:42:04','698'),(3639,'','1','194','FRAYO GAS','asaba','07030325582','frayogas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-31 10:42:20',5,'698','2021-10-31 10:42:20','698'),(3640,'','1','194','TUNNY GAS','asaba','08036833898','tunnygas@gmail.co','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-31 16:30:13',5,'698','2021-10-31 16:30:13','698'),(3641,'','1','194','STAR GAS','asaba','08060552203','stargas@mail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-31 16:50:46',5,'698','2021-10-31 16:50:46','698'),(3642,'','1','194','ALIYU GAS','asaba','07035385604','aliyugas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 07:02:38',5,'698','2021-11-01 07:02:38','698'),(3644,'','1','194','GOD WITH US GAS','asaba','08136298596','godwithusgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 07:42:16',5,'698','2021-11-01 07:42:16','698'),(3645,'','1','194','ATCON GAS','asaba','08038174671','atcongas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 07:46:17',5,'698','2021-11-01 07:46:17','698'),(3646,'','1','194','CHINEDU C','asaba','08167565059','chinedu@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 08:21:49',5,'698','2021-11-01 08:21:49','698'),(3647,'','1','194','ANAS GAS','asaba','07084322115','anasgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 08:51:15',5,'698','2022-11-03 09:17:33','698'),(3648,'','1','194','CHIDI GAS','asaba','09065211701','chidigas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 09:11:25',5,'698','2021-11-01 09:11:25','698'),(3650,'','1','194','PUREDE GAS','asaba','08038586467','puredegas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-01 12:18:40',5,'698','2021-11-01 12:18:40','698'),(3651,'','1','194','IBEH GAS','asaba','08149658336','ibehgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-02 08:44:43',5,'698','2021-11-02 08:44:43','698'),(3652,'','1','194','CHIKA GAS','asaba','08130512147','chikagas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-02 10:30:35',5,'698','2021-11-02 10:30:35','698'),(3653,'','1','194','HELIN GAS','asaba','08041516622','helingas@gmail,com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-02 13:11:35',5,'698','2021-11-02 13:11:35','698'),(3655,'','1','194','AKBOS GAS','asaba','08066612708','akbosgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-02 14:50:43',5,'698','2021-11-02 14:50:43','698'),(3656,'','1','194','AKPOS GAS','asaba','08066612708','akposgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-02 14:52:59',5,'698','2021-11-02 14:52:59','698'),(3657,'','1','194','GOCEE GAS','asaba','08131328411','goceegas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-03 08:49:49',5,'698','2021-11-03 08:49:49','698'),(3658,'','1','194','DE MORE GAS','asaba','07065389038','demoregas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-03 09:25:18',5,'698','2021-11-03 09:25:18','698'),(3660,'','1','194','U S GAS','asaba','07033008830','usgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-03 10:26:38',5,'698','2021-11-03 10:26:38','698'),(3716,'','1','194','confidense gas','asaba','08063227598','confidencegas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 14:19:37',5,'698','2021-11-22 08:10:13','698'),(3719,'','1','194','THANK GOD GAS','asaba','08130018938','thankgodgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-10 14:44:03',5,'698','2021-11-10 14:44:03','698'),(3735,'','1','194','ROMEO GAS','asaba','08037584686','romeogas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-12 06:35:48',5,'698','2021-11-12 06:35:48','698'),(3823,'','1','194','IGWE GAS','asaba','08130013938','igwegas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-21 14:28:55',5,'698','2021-11-21 14:28:55','698'),(3877,'','1','194','BLESS DE MORE GAS','asaba','08038738817','blessdemoregas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-28 06:55:53',5,'698','2021-11-28 06:55:53','698'),(3881,'','1','194','OIL$GAS','asaba','09074122628','oil$gas@gmail.co','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-28 11:44:34',5,'698','2021-11-28 11:44:34','698'),(3885,'','1','194','BIG GAS','asaba','09122513292','bigga@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-28 15:50:08',5,'698','2021-11-28 15:50:08','698'),(3886,'','1','194','HUMBLE GAS','asaba','08162669905','humblegas@gmail.com','ASABA','delta','Asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-29 07:20:09',5,'698','2021-11-29 07:20:09','698'),(3924,'','1','194','ACERO OIL&GAS','asaba','09021991557','acerooilgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-30 14:06:12',5,'698','2021-11-30 14:06:12','698'),(3925,'','1','194','EMMA GAS','asaba','08064908467','emmgas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-30 14:45:16',5,'698','2021-11-30 14:45:16','698'),(3933,'','1','194','S%F LPG GAS','asaba','08090830803','sflpggas@gmail.com','ASABA','delta','ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-02 09:23:45',5,'698','2021-12-02 09:23:45','698'),(3942,'','1','194','RACHAEL','CHICHI BAKERY','09068641180','rachilgas@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-03 08:47:12',5,'698','2021-12-03 08:47:12','698'),(4019,'','1','194','OGA EMMA','asaba','07064902689','ogaemma@gmail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-13 08:38:41',5,'698','2021-12-13 08:38:41','698'),(4020,'','1','194','CHIMTEX','asaba','08136187499','chimtex@gail.com','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-13 10:28:19',5,'698','2021-12-13 10:28:19','698'),(4067,'','1','194','EL-SHA GAS','CHRISTIAN EZUGWU','00000000000000','@rano','ASABA','DELTA','BISI, ASABA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-21 15:19:40',5,'698','2021-12-21 15:19:40','698'),(4072,'','1','194','LAUGHTER GAS','PASTOR ISAAC ','0000000000000','@rano','ASABA','DELTA','CENT BRIDGES ROAD, ASABA NIGERIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-22 10:55:26',5,'698','2021-12-22 10:55:26','698'),(4075,'','1','194','A A RANO NIG LTD','AA RASNO NIG LTD','0000000000000',' @aa rano','kano','kano','@AA RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-22 15:25:28',5,'698','2021-12-22 15:25:28','698'),(4078,'','1','194','STOMACH CARE KITCHEN GAS','MR STOMACH KITCHEN','07068422611','@rano','ASABA','delta','NO 4 STOMACH CARE GRA ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-23 08:36:17',5,'698','2021-12-23 08:36:17','698'),(4079,'','1','194','JUDE GAS','JUDE GAS','08060048853','@rano','ASABA','delta','MARINE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-05 14:26:13',5,'698','2022-02-05 14:26:13','698'),(4080,'','1','194','MARY GAS CONCEPT','MARY GAS','09069028819','@rano','ASABA','delta','IBUSA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-08 10:02:09',5,'698','2022-02-08 10:02:09','698'),(4081,'','1','194','marvellous','marvel','09041459457','@rano','ASABA','delta','ogbeiw market','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 12:20:53',5,'698','2022-02-21 12:20:53','698'),(4082,'','1','194','superemacy  gas','supre','08162693217','@rano','ASABA','delta','chief abiola esaete road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 12:25:18',5,'698','2022-02-21 12:25:18','698'),(4083,'','1','194','chike  great gas','chike  great','08068119547','@rano','ASABA','delta','federal housing esate','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 12:29:34',5,'698','2022-02-21 12:29:34','698'),(4084,'','1','194','U CHUKU GAS','U CHUKU','08039484429','@rano','ASABA','delta','COURT ROAD ONISHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 15:29:53',5,'698','2022-02-21 15:29:53','698'),(4085,'','1','194','BADMUS ALI GAS','BADMUS','07035385604','@rano','ASABA','delta','OIL AND GAS ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 16:15:24',5,'698','2022-02-21 16:15:24','698'),(4086,'','1','194','D D Z GAS','DDZ','08032072253','@rano','ASABA','delta','ASABA AIR PORT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-24 11:16:37',5,'698','2022-02-24 11:16:37','698'),(4087,'','1','194','german gas','asaba','07068570943','@rano','ASABA','delta','umuehea bye pass junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-25 15:41:42',5,'698','2022-02-25 15:41:42','698'),(4088,'','1','194','prosper gas','prosper','07050990372','@rano','ASABA','delta','evil court','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 12:13:38',5,'698','2022-02-26 12:13:38','698'),(4089,'','1','194','martins gas','martins','08143188982','@rano','ASABA','delta','cabl point','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-26 12:15:14',5,'698','2022-02-26 12:15:14','698'),(4090,'','1','194','GARMAN FIDELIY','GARMAN','08130512147','@rano','ASABA','delta','ASABA COURT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-05 13:54:39',5,'698','2022-05-05 13:54:39','698'),(4091,'','1','194','osas gas','osas gas','08035460222','@rano','kano','delta','juju road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-06 18:08:29',5,'698','2022-05-06 18:08:29','698'),(4092,'','1','194','operational loss','asaba','09121307508','jmabdullahi@yahoo.com','ASABA','DELTA','ALONG ONITSHA EXPRESS WAY ASABA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-16 16:20:43',5,'698','2022-05-16 16:20:43','698'),(4093,'','1','194','dobri  gas','dobri gas','07065262227','dobrigas@gmail.com','ASABA','delta','asaba ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-30 18:33:38',5,'698','2022-05-30 18:33:38','698'),(4094,'','1','194','DOMINION FATE','DOMINION  FATE','08051939008','dominionfate@gmail.com','ASABA','DELTA','ONITSHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-03 11:16:13',5,'698','2022-06-03 11:16:13','698'),(4095,'','1','194','JERRY GAS','JARRY GAS','08083363372','jarrygas@gmail.com','ASABA','DELTA','ONISTHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-05 13:04:07',5,'698','2022-06-05 13:04:07','698'),(4096,'','1','194','DON GAS','OGWASHI  UKU','07066014682','asaba@gmail.c0m','ASABA','DELTA','OGWASHI  UKU  STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-25 12:32:08',5,'698','2022-06-25 12:32:08','698'),(4097,'','1','194','kato chukwu gas','kato','08033909552','@rano','ASABA','delta','jesus st asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-29 10:56:40',5,'698','2022-06-29 10:56:40','698'),(4098,'','1','194','chixander global','chixander','07033925695','@rano','ASABA','delta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-12 11:53:08',5,'698','2022-07-12 11:53:08','698'),(4099,'','1','194','PEARL GAS','PEARL','08032714700','@rano','ASABA','delta','COURT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-14 10:03:58',5,'698','2022-07-14 10:03:58','698'),(4100,'','1','194','thank god g','thank god g','08130013938','@rano','ASABA','delta','kantan','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-14 15:47:45',5,'698','2022-07-14 15:47:45','698'),(4101,'','1','194','AUSTINPEN GAS','AUSTINPEN GAS ','08066831985','@rano','ASABA','delta','OFF JUNIUC ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-15 15:44:21',5,'698','2022-07-15 15:44:21','698'),(4102,'','1','194','GLAD GAS','GLAD GAS','09063296020','@rano','ASABA','delta','ONITSHA ANAMBRA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-16 18:16:45',5,'698','2022-07-16 18:16:45','698'),(4103,'','1','194','RAY D GAS','RAY D GAS','07037400439','@rano','ASABA','delta','COURT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-18 07:59:50',5,'698','2022-07-18 07:59:50','698'),(4104,'','1','194','EMAKA GAS','EMAKA GAS','07066814887','@rano','ASABA','delta','OFFICER MESS OKWE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-18 13:30:37',5,'698','2022-07-18 13:30:37','698'),(4105,'','1','194','STEPHEN GAS','STEPHEN GAS','0803188656','@rano','ASABA','delta','ISSELE ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-20 08:13:53',5,'698','2022-07-20 08:13:53','698'),(4106,'','1','194','cedar gas','cedar gas','08035005301','@rano','ASABA','delta','nebisi road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-20 09:26:50',5,'698','2022-07-20 09:26:50','698'),(4107,'','1','194','OCEANIC GAS','OCEANIC GAS','09056821261','@rano','ASABA','delta','OGBOTOBC','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 10:26:04',5,'698','2022-07-21 10:26:04','698'),(4108,'','1','194','BLESSED GAS','asaba','08098562509','@rano','ASABA','DELTA','2 EMMA AGU STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-31 18:55:35',5,'698','2022-07-31 18:55:35','698'),(4109,'','1','194','choice gas','choice gas','08135666320','@rano','ASABA','delta','nkop ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-06 16:20:12',5,'698','2022-08-06 16:20:12','698'),(4110,'','1','194','PAULARGE  OIL & GAS','IBUSOR  ROAD','07062494503','paularge@gmail.com','ASABA','DELTA','NO 6 JACSON CLOSE ADALA IBUSOR ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-05 08:37:20',5,'698','2022-09-05 08:37:20','698'),(4111,'','1','194','EXCEL GLOBAL GAS','NO 19 OMIRE STREET','08025920302','excelglobal@gmail.com','ASABA','DELTA','NO 19 OMIRE STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-10 07:40:51',5,'698','2022-09-10 07:40:51','698'),(4112,'','1','194','IKE GOD','07038456010','07038456010','ikechukwuigwe@31gmail.com','ASABA','DELTA','71 ACHA ONITSHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-12 14:15:18',5,'698','2022-09-14 14:10:11','698'),(4113,'','1','194','O LITE M.CO.LTD','PLOT 26 OKOLOSI','08033870990','clite @gmail.com','ASABA','DELTA','okolosi layout off acalia ibusa raod asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-14 13:44:42',5,'698','2022-09-14 14:09:32','698'),(4114,'','1','194','JACK GAS','OSHIMILI NORTH','07039119259','agetuesimon@gmail.com','ASABA','DELTA','oshili northe l g a delter','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-15 08:16:16',5,'698','2022-09-15 08:16:16','698'),(4115,'','1','194','MAYOR GAS','NO 2 ONUANAKU STREET','09039577236','obiorahkenneth86@gmail.com','ONISTHA','ANAMBRA','ONUANAKWU ONITSHA ANAMBRA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-15 12:03:49',5,'698','2022-09-15 12:03:49','698'),(4116,'','1','194','chiprochi','chiprochi gas','0901765323','ikechukwuigwe@31gmail.com','ASABA','DELTA','illah','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-16 14:31:03',5,'698','2022-09-16 14:31:03','698'),(4117,'','1','194','olinya emma gas','olinya emma gas','08113041224','agetuesimon@gmail.com','ASABA','DELTA','ishiekpe issele','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-19 11:35:23',5,'698','2022-09-19 11:35:23','698'),(4118,'','1','194','success gas','success gas','076110029','clite @gmail.com','ASABA','DELTA','ilinco street','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-19 12:06:11',5,'698','2022-09-19 12:06:11','698'),(4119,'','1','194','chidi banks','chidi banks','09035380698','ikechukwuigwe@31gmail.com','ASABA','DELTA','opposite daggers plaza','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-20 12:45:20',5,'698','2022-09-20 12:45:20','698'),(4120,'','1','194','chilese','chilese','08034117734','clite @gmail.com','ASABA','DELTA','akwo koka','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-20 12:47:12',5,'698','2022-09-20 12:47:12','698'),(4121,'','1','194','RI GAS','IBUSA JUNCTION','08064390227','victoroduma3@gmail.com','ASABA','DELTA','ibusa junction ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-20 14:42:14',5,'698','2022-09-20 14:42:14','698'),(4122,'','1','194','best quality gas','NO 2 ONUANAKU STREET','09013515572','ikechukwuigwe@31gmail.com','ASABA','ANAMBRA','onisha ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-24 14:13:52',5,'698','2022-09-24 14:13:52','698'),(4123,'','1','194','CONSIDER GAS','35 MUOBIKE STREET','09022351822','destinyjideofor28@gmail.com','ONISTHA','ANAMBRA','35 MUOBIKE STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-26 13:33:49',5,'698','2022-09-26 13:33:49','698'),(4124,'','1','194','NEW EMMA GAS','NNEWI OKPUNO STREET','07068160907','obinali kenneth 86@gmail.com','ANAMBRA','ANAMBRA','BE FORE WINNERS CHURCHE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 14:39:35',5,'698','2022-10-01 14:39:35','698'),(4125,'','1','194','AMACO GAS','URU GET','UMUDIM NEW','ikechukwuigwe@31gmail.com','ANAMBRA','ANAMBRA','UMUDIM NEW','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 14:41:34',5,'698','2022-10-01 14:41:34','698'),(4126,'','1','194','NEW FAITH GAS','08100647707','08100647707','faithgas@com','ASABA','DELTA','redbond asaba street','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-02 14:44:42',5,'698','2022-10-02 14:44:42','698'),(4127,'','1','194','DESTINEY  GAS','4.ADR0WI STREET','08161643781','ikechukwuigwe@31gmail.com','ONISTHA','ANAMBRA','ADROWI STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-03 14:41:38',5,'698','2022-10-03 14:41:38','698'),(4128,'','1','194','MD GAS','MD GAS','08086434559','ikechukwuigwe@31gmail.com','ASABA','DELTA','REDEME OKPAM ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-06 09:49:08',5,'698','2022-10-06 09:49:08','698'),(4129,'','1','194','D.V GAS','D.V GAS','09028584262','clite @gmail.com','ASABA','DELTA','AIRPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-06 12:04:07',5,'698','2022-10-06 12:04:07','698'),(4130,'','1','194','CHIDEX','CHIDEX','08064775508','ikechukwuigwe@31gmail.com','ASABA','DELTA','INBIUSE ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-06 12:06:12',5,'698','2022-10-06 12:06:12','698'),(4131,'','1','194','EJIME GAS','EJIME GAS','09017608483','agetuesimon@gmail.com','ASABA','DELTA','AGS SIDE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-06 12:18:13',5,'698','2022-10-06 12:18:13','698'),(4132,'','1','194','BRIGHT GAS','BRIGHT GAS','08137798507','ikechukwuigwe@31gmail.com','ASABA','DELTA','UMDERFER ISBOISE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-06 12:43:48',5,'698','2022-10-06 12:43:48','698'),(4133,'','1','194','Haritage gas','21 quaters asaba','08036238796','haritage@gmail.com','ASABA','DELTA','21 quarters asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-07 17:02:22',5,'698','2022-10-07 17:02:22','698'),(4134,'','1','194','EZE SUNDAY','5 ALUKA STREET','80835475945','victoroduma3@gmail.com','ASABA','DELTA','5 ALUKE STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-10 12:47:47',5,'698','2022-10-10 12:47:47','698'),(4135,'','1','194','BLESSING GAS','BLESSING','07046200337','ikechukwuigwe@31gmail.com','ASABA','DELTA','OPPOSITE KANAGO HOSPITAL','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-18 18:20:22',5,'698','2022-10-18 18:20:22','698'),(4136,'','1','194','god win jame','08038814995','08038814995','godwin@gail.com','ASABA','DELTA','asaba stresst','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-23 13:33:53',5,'698','2022-10-23 13:33:53','698'),(4137,'','1','194','DE GREAT','DE GREAT','08037593477','clite @gmail.com','ASABA','DELTA','IBUSA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-29 17:30:58',5,'698','2022-10-29 17:30:58','698'),(4138,'','1','194','POSSIBLE GAS','USONIA','09019790943','agetuesimon@gmail.com','ASABA','DELTA','USONIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-01 14:24:49',5,'698','2022-11-01 14:24:49','698'),(4139,'','1','194','miracle gas','miracle gas','08035424124','emiracle 024@gmail.com','ASABA','DELTA','no 5 off suimite road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-04 16:28:53',5,'698','2022-11-04 16:28:53','698'),(4140,'','1','194','BUCHI GAS','FIRST TRANSFORMR BONSAC','09036189685','amoslati@gmail.com','asaba','dalta','bonsac','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-06 15:03:26',5,'698','2022-11-06 15:03:26','698'),(4141,'','1','194','NONSO NOBLE GAS','OKWE','08149449678','paulinunonso@gmail.com','asaba','dalta','okwe road','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-09 08:55:37',5,'698','2022-11-09 08:55:37','698'),(4142,'','1','194','NAZA GAS','OPM JUNCTION','09025267543','angelic@gmail.com','asaba','dalta','opm junction','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-09 08:58:27',5,'698','2022-11-09 08:58:27','698'),(4143,'','1','194','KELECHI GAS','KABU POINT','08143374121','angelic@gmail.com','asaba','dalta','KABU POINT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-09 09:04:25',5,'698','2022-11-09 09:04:25','698'),(4144,'','1','194','GODS TIME','NOB.21 SCHOOL ROAD ONISHA','07031925945','amoslati@gmail.com','ONISHA','ANAMBRA','NOB 21 SCHOOL ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-09 12:23:02',5,'698','2022-11-09 12:23:02','698'),(4145,'','1','194','GODWIN GAS','PAWO SHOP','08038814995','amoslati@gmail.com','asaba','dalta','PAWO SHOP','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-10 12:03:03',5,'698','2022-11-10 12:03:03','698'),(4146,'','1','194','MADAM ROYAL GAS','MINISTRY OF TRANSPORT ROAD','07067886584','paulinunonso@gmail.com','asaba','dalta','MINISTY OF TRANSPORT ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-10 12:31:01',5,'698','2022-11-10 12:31:01','698'),(4147,'','1','194','SOM TEX','SOM TEX','09039513093','amoslati@gmail.com','asaba','dalta','NO ABAGAMA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-14 11:29:14',5,'698','2022-11-14 11:29:14','698'),(4148,'','1','194','D BELLO ENTERPRICE','D BELLO','08066034365','amoslati@gmail.com','asaba','dalta','EZENIE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 09:24:23',5,'698','2022-11-30 09:24:23','698'),(4149,'','1','194','kester gas','kester gas','08160076425','amoslati@gmail.com','asaba','dalta','slot','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-01 11:39:25',5,'698','2022-12-01 11:39:25','698'),(4150,'','1','194','GLORY  GAS','ODUKE','08108193761','angelic@gmail.com','asaba','dalta','ODUKE MARKET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-10 10:37:03',5,'698','2022-12-10 10:37:03','698'),(4151,'','1','194','EMMATEX GAS','ONISHA NKPOR','08064772992','amoslati@gmail.com','ONISHA','ANAMBRA','ONISHA NKPOR','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-10 11:05:24',5,'698','2022-12-10 11:05:24','698'),(4152,'','1','194','ST ANTONIE','ST ANTONIE','08141799978','amoslati@gmail.com','asaba','ANAMBRA','FOKO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-10 14:41:31',5,'698','2022-12-10 14:41:31','698'),(4153,'','1','194','TONIYA GAS','DLA ROAD','07034400057','paulinunonso@gmail.com','asaba','dalta','DLA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-11 10:43:28',5,'698','2022-12-11 10:43:28','698'),(4154,'','1','194','TONERO GAS','NO.9 SENTCRISTOBER','0815331850','angelic@gmail.com','ONISHA','ANAMBRA','NO.9SENTCRITOBER','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-18 10:56:43',5,'698','2022-12-18 10:56:43','698'),(4155,'','1','194','ABDUL GAS','OTUOGU','07069725169','amoslati@gmail.com','asaba','dalta','OTUOGU','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-21 07:54:17',5,'698','2022-12-21 07:54:17','698'),(4156,'','1','194','EMERLIE GAS','UMUNYA','08139546015','paulinunonso@gmail.com','ONISHA','ANAMBRA','UMUNYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-21 08:02:52',5,'698','2022-12-21 08:02:52','698'),(4157,'','1','194','DANIEL GAS','STOP ABOTION','09037125114','angelic@gmail.com','asaba','dalta','STOP ABOTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-22 12:44:32',5,'698','2022-12-22 12:44:32','698'),(4158,'','1','194','bless nelly','hostel 24pineaple','07033949427','amoslati@gmail.com','asaba','dalta','hostel 24 pineaple farm azagba ogwuashi','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-12-27 14:09:13',5,'698','2022-12-27 14:09:13','698'),(4159,'','1','194','ikolomi christian','ikolomi gas','07033751981','amoslati@gmail.com','asaba','dalta','33 nwn eze para stree','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-03 17:47:38',5,'698','2023-01-03 17:47:38','698'),(4160,'','1','194','chiemerie gas','mission road onisha','08172360662','angelic@gmail.com','ONISHA','ANAMBRA','mission road onisha','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-08 17:56:26',5,'698','2023-01-08 17:56:26','698'),(4161,'','1','194','SARAH GAS','SARAH','09034583078','angelic@gmail.com','asaba','dalta','AKWUKWU IGBO DGBIESE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-12 12:02:34',5,'698','2023-01-12 12:02:34','698'),(4162,'','1','194','BC GAS','BC GAS','07031062549','amoslati@gmail.com','asaba','dalta','OLD ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-13 08:08:26',5,'698','2023-01-13 08:08:26','698'),(4163,'','1','194','able god','ahwuhwu','07018379744','angelic@gmail.com','asaba','dalta','ahwuhwu','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-30 09:58:59',5,'698','2023-01-30 09:58:59','698'),(4164,'','1','194','LINUS GAS','NOB.1.EKWELE STREAT','08133352334','paulinunonso@gmail.com','ONISHA','ANAMBRA','EKWELE STEAT','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-01 08:57:57',5,'698','2023-02-01 08:57:57','698'),(4165,'','1','194','IKE GLOBAL','UMUNYA','08030822833','paulinunonso@gmail.com','ONISHA','ANAMBRA','ONICHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-14 08:46:56',5,'698','2023-02-14 08:46:56','698'),(4166,'','1','194','NELSON GAS','OGISZI','09167494217','angelic@gmail.com','ONISHA','ANAMBRA','ONISHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-19 11:02:37',5,'698','2023-02-19 11:02:37','698'),(4167,'','1','194','EZE GAS','EZE GAS','09094767509','amoslati@gmail.com','asaba','ANAMBRA','OSHINE','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-28 14:24:57',5,'698','2023-02-28 14:24:57','698'),(4168,'','1','194','vic gas','vic gas','09030522372','angelic@gmail.com','asaba','dalta','asaba','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-03 08:23:11',5,'698','2023-03-03 08:23:11','698'),(4169,'','1','194','STAN GAS','STAN GAS','08167202043','amoslati@gmail.com','asaba','ANAMBRA','ONSTER','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-15 14:25:11',5,'698','2023-03-15 14:25:11','698'),(4170,'','1','194','YOYO GAS','ONISHA','08035471117','angelic@gmail.com','ONISHA','ANAMBRA','ONISHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-19 15:29:06',5,'698','2023-03-19 15:29:06','698');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3001 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','194','1012',2993,'5','LPG NOZZLE',3511292.09,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',2994,'5','LPG NOZZLE 2',6232.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',2995,'5','LPG NOZZLE 3',3.00,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',2996,'5','LPG NOZZLE 4',27.00,'',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',2997,'5','LPG NOZZLE 5',2697.57,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',2998,'5','LPG NOZZLE 6',30029.21,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',2999,'5','LPG NOZZLE 7',90800.29,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','194','1012',3000,'5','LPG NOZZLE 8',83754.67,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258128 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','194',232225,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-17 14:29:03','698','2021-10-17 14:29:55',10,0),('1','194',232246,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-20 12:47:11','698','2021-10-20 12:47:58',10,0),('1','194',232987,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-20 13:01:42','698','2021-10-20 13:02:15',10,0),('1','194',232999,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-20 13:50:30','698','2021-10-20 13:53:03',10,0),('1','194',233013,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-21 08:22:19','698','2021-10-21 08:22:57',10,0),('1','194',233164,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-22 14:04:23','698','2021-10-22 14:05:01',10,0),('1','194',233518,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-23 06:32:50','698','2021-10-23 06:33:30',10,0),('1','194',233622,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-26 06:02:37','698','2021-10-26 06:03:49',10,0),('1','194',234314,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-27 06:36:55','698','2021-10-27 06:38:33',10,0),('1','194',234579,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-27 18:22:07','698','2021-10-27 18:23:25',10,0),('1','194',234851,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-28 19:22:06','698','2021-10-28 19:24:20',10,0),('1','194',235082,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-30 09:04:01','698','2021-10-30 09:05:24',10,0),('1','194',235366,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-30 09:32:10','698','2021-10-30 09:32:57',10,0),('1','194',235379,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-30 09:37:39','698','2021-10-30 09:38:06',10,0),('1','194',235380,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-30 17:58:04','698','2021-10-30 17:59:47',10,0),('1','194',235546,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'698',0.00,0.00,'698','2021-10-31 17:56:26','698','2021-10-31 17:57:38',10,0),('1','194',235762,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-02 06:11:18','698','2021-11-02 06:12:45',10,0),('1','194',236031,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-02 18:29:30','698','2021-11-02 18:31:47',10,0),('1','194',236240,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-03 19:28:36','698','2021-11-03 19:29:10',10,0),('1','194',236517,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-04 08:14:56','698','2021-11-04 08:15:36',10,0),('1','194',236575,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-04 08:51:00','698','2021-11-04 08:51:26',10,0),('1','194',237716,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-09 12:32:01','698','2021-11-09 12:33:03',10,0),('1','194',237720,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-09 12:39:36','698','2021-11-09 12:42:05',10,0),('1','194',237724,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-09 13:02:46','698','2021-11-09 13:03:27',10,0),('1','194',237734,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-09 13:09:42','698','2021-11-09 13:10:16',10,0),('1','194',237738,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-09 13:30:37','698','2021-11-09 13:32:20',10,0),('1','194',237876,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-10 10:15:28','698','2021-11-10 10:16:42',10,0),('1','194',237996,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-10 20:31:41','698','2021-11-10 20:32:26',10,0),('1','194',238126,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-11 18:24:52','698','2021-11-11 18:25:47',10,0),('1','194',238356,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-12 19:33:30','698','2021-11-12 19:34:17',10,0),('1','194',238603,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-13 10:09:28','698','2021-11-13 10:10:09',10,0),('1','194',238692,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-13 19:08:21','698','2021-11-13 19:09:32',10,0),('1','194',238841,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-14 17:16:58','698','2021-11-14 17:17:32',10,0),('1','194',239064,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-15 19:13:01','698','2021-11-15 19:13:44',10,0),('1','194',239293,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-16 19:32:36','698','2021-11-16 19:33:17',10,0),('1','194',239535,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-17 08:28:25','698','2021-11-17 08:29:46',10,0),('1','194',239596,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-17 18:05:08','698','2021-11-17 18:06:16',10,0),('1','194',239773,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-18 18:52:04','698','2021-11-18 18:52:40',10,0),('1','194',240003,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-19 18:23:48','698','2021-11-19 18:27:26',10,0),('1','194',240202,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-20 10:16:20','698','2021-11-20 10:16:48',10,0),('1','194',240274,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-20 18:25:43','698','2021-11-20 18:26:34',10,0),('1','194',240461,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-21 17:15:06','698','2021-11-21 17:15:45',10,0),('1','194',240700,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-22 18:29:11','698','2021-11-22 18:30:01',10,0),('1','194',240978,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-23 16:13:53','698','2021-11-23 16:14:24',10,0),('1','194',241802,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-26 18:27:40','698','2021-11-26 18:28:52',10,0),('1','194',242004,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-27 18:06:39','698','2021-11-27 18:07:25',10,0),('1','194',242216,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-28 18:07:52','698','2021-11-28 18:08:30',10,0),('1','194',242445,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-29 18:24:11','698','2021-11-29 18:25:33',10,0),('1','194',242687,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'698',0.00,0.00,'698','2021-11-30 17:54:25','698','2021-11-30 17:55:09',10,0),('1','194',242932,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-01 18:12:45','698','2021-12-01 18:13:34',10,0),('1','194',243148,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-02 18:37:19','698','2021-12-02 18:39:22',10,0),('1','194',243374,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-03 10:08:43','698','2021-12-03 10:09:41',10,0),('1','194',243453,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-03 19:07:01','698','2021-12-03 19:07:48',10,0),('1','194',243604,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-04 18:39:43','698','2021-12-04 18:41:49',10,0),('1','194',243838,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-05 19:01:45','698','2021-12-05 19:04:27',10,0),('1','194',244059,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-06 17:42:42','698','2021-12-06 17:44:40',10,0),('1','194',244300,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-07 17:46:51','698','2021-12-07 17:49:25',10,0),('1','194',244523,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-08 18:52:13','698','2021-12-08 18:54:46',10,0),('1','194',244756,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-09 17:49:24','698','2021-12-09 17:50:48',10,0),('1','194',245001,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-10 07:38:25','698','2021-12-10 07:39:04',10,0),('1','194',245026,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-10 19:04:06','698','2021-12-10 19:14:43',10,0),('1','194',245224,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-11 18:35:58','698','2021-12-11 18:38:23',10,0),('1','194',245449,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-12 18:17:08','698','2021-12-12 18:18:45',10,0),('1','194',245684,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-13 20:53:59','698','2021-12-13 20:55:38',10,0),('1','194',246859,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-17 18:55:17','698','2021-12-17 19:03:01',10,0),('1','194',246948,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-18 19:18:53','698','2021-12-18 19:22:25',10,0),('1','194',247183,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-19 17:08:29','698','2021-12-19 17:13:05',10,0),('1','194',247750,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-21 19:20:29','698','2021-12-21 19:23:08',10,0),('1','194',247916,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-22 18:00:36','698','2021-12-22 18:02:55',10,0),('1','194',248162,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-23 17:31:25','698','2021-12-23 17:32:48',10,0),('1','194',248409,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-24 20:37:33','698','2021-12-24 20:41:24',10,0),('1','194',248647,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-25 18:45:58','698','2021-12-25 18:47:01',10,0),('1','194',248950,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-26 16:22:31','698','2021-12-26 16:22:57',10,0),('1','194',249137,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-27 19:14:11','698','2021-12-27 19:16:42',10,0),('1','194',249350,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-28 17:15:47','698','2021-12-28 17:17:55',10,0),('1','194',249605,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-29 17:26:44','698','2021-12-29 18:46:25',10,0),('1','194',249875,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-30 17:24:11','698','2021-12-30 17:26:07',10,0),('1','194',250127,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'698',0.00,0.00,'698','2021-12-31 18:22:25','698','2021-12-31 18:23:37',10,0),('1','194',250353,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-01 20:20:32','698','2022-01-01 20:23:26',10,0),('1','194',250598,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-02 16:10:03','698','2022-01-02 16:11:28',10,0),('1','194',250814,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-03 15:01:04','698','2022-01-03 15:05:27',10,0),('1','194',251047,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-04 17:34:43','698','2022-01-04 17:36:32',10,0),('1','194',251290,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-05 18:53:53','698','2022-01-05 18:56:07',10,0),('1','194',251533,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-06 19:24:59','698','2022-01-06 19:29:50',10,0),('1','194',251778,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-07 19:13:17','698','2022-01-07 19:16:00',10,0),('1','194',252020,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-08 18:39:21','698','2022-01-08 18:43:03',10,0),('1','194',252294,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-09 16:35:11','698','2022-01-09 16:37:44',10,0),('1','194',252496,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-10 18:33:43','698','2022-01-10 18:37:01',10,0),('1','194',252756,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-11 19:14:44','698','2022-01-11 19:15:58',10,0),('1','194',253008,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-12 18:32:04','698','2022-01-12 18:34:16',10,0),('1','194',253221,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-13 18:38:18','698','2022-01-13 19:06:56',10,0),('1','194',253486,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-14 17:50:49','698','2022-01-14 17:57:23',10,0),('1','194',253725,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-15 20:24:35','698','2022-01-15 20:29:03',10,0),('1','194',254008,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-16 17:18:14','698','2022-01-16 17:21:37',10,0),('1','194',254220,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-17 18:45:39','698','2022-01-17 18:49:12',10,0),('1','194',254459,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-18 18:40:37','698','2022-01-18 18:45:19',10,0),('1','194',254702,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-19 19:09:39','698','2022-01-19 19:13:54',10,0),('1','194',254966,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-20 19:09:51','698','2022-01-20 19:14:00',10,0),('1','194',255198,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-21 16:01:01','698','2022-01-21 16:03:00',10,0),('1','194',255508,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-22 19:23:15','698','2022-01-22 19:25:24',10,0),('1','194',255751,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-23 17:43:00','698','2022-01-23 17:44:38',10,0),('1','194',255964,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 08:08:30','698','2022-01-24 08:24:38',10,0),('1','194',256047,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 19:44:52','698','2022-01-24 19:48:18',10,0),('1','194',256157,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:22:41','698','2022-01-24 21:24:15',10,0),('1','194',256163,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:33:14','698','2022-01-24 21:34:44',10,0),('1','194',256170,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:39:47','698','2022-01-24 21:40:46',10,0),('1','194',256171,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:44:47','698','2022-01-24 21:45:05',10,0),('1','194',256172,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:48:55','698','2022-01-24 21:49:14',10,0),('1','194',256175,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:53:22','698','2022-01-24 21:53:44',10,0),('1','194',256176,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 21:57:13','698','2022-01-24 21:57:41',10,0),('1','194',256177,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:01:22','698','2022-01-24 22:01:47',10,0),('1','194',256178,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:07:00','698','2022-01-24 22:07:24',10,0),('1','194',256180,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:14:08','698','2022-01-24 22:14:35',10,0),('1','194',256181,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:19:30','698','2022-01-24 22:20:25',10,0),('1','194',256182,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:27:24','698','2022-01-24 22:27:51',10,0),('1','194',256184,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:31:40','698','2022-01-24 22:32:46',10,0),('1','194',256186,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:38:26','698','2022-01-24 22:40:30',10,0),('1','194',256187,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-24 22:50:04','698','2022-01-24 22:50:42',10,0),('1','194',256228,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-25 18:48:24','698','2022-01-25 18:51:19',10,0),('1','194',256493,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-26 19:32:26','698','2022-01-26 19:36:35',10,0),('1','194',256669,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-26 19:43:54','698','2022-01-26 19:44:16',10,0),('1','194',256986,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-28 20:10:27','698','2022-01-28 20:13:13',10,0),('1','194',257309,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-29 19:39:44','698','2022-01-29 20:07:18',10,0),('1','194',257542,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-30 16:36:38','698','2022-01-30 16:42:03',10,0),('1','194',257543,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'698',0.00,0.00,'698','2022-01-31 20:28:10','698','2022-01-31 20:28:38',10,0),('1','194',257544,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-01 19:03:26','698','2022-02-01 19:04:42',10,0),('1','194',257545,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-02 18:56:15','698','2022-02-02 18:56:43',10,0),('1','194',257546,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-02 19:24:16','698','2022-02-02 19:24:47',10,0),('1','194',257547,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-03 19:25:31','698','2022-02-03 19:30:22',10,0),('1','194',257548,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-04 18:49:32','698','2022-02-04 18:50:04',10,0),('1','194',257549,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-05 20:02:34','698','2022-02-05 20:02:53',10,0),('1','194',257550,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-06 17:11:58','698','2022-02-06 17:15:03',10,0),('1','194',257551,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-07 19:31:39','698','2022-02-07 19:32:40',10,0),('1','194',257552,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-08 18:43:45','698','2022-02-08 18:44:28',10,0),('1','194',257553,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-11 19:09:09','698','2022-02-11 19:09:36',10,0),('1','194',257554,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-12 11:03:11','698','2022-02-12 11:03:40',10,0),('1','194',257555,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-12 11:35:26','698','2022-02-12 11:36:03',10,0),('1','194',257556,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-12 19:21:25','698','2022-02-12 19:21:56',10,0),('1','194',257557,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-13 16:55:38','698','2022-02-13 16:56:04',10,0),('1','194',257558,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-14 19:00:22','698','2022-02-14 19:01:17',10,0),('1','194',257559,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-15 19:01:23','698','2022-02-15 19:02:53',10,0),('1','194',257560,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-16 20:03:04','698','2022-02-16 20:03:28',10,0),('1','194',257561,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-17 16:55:35','698','2022-02-17 16:56:02',10,0),('1','194',257562,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-18 15:56:24','698','2022-02-18 15:56:49',10,0),('1','194',257563,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-18 16:26:28','698','2022-02-18 16:26:57',10,0),('1','194',257564,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-18 19:01:12','698','2022-02-18 19:01:40',10,0),('1','194',257565,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-19 19:05:49','698','2022-02-19 19:06:20',10,0),('1','194',257566,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-20 17:05:37','698','2022-02-20 17:06:25',10,0),('1','194',257567,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'698',0.00,0.00,'698','2022-02-21 17:48:08','698','2022-02-21 17:48:38',10,0),('1','194',257568,'DAILY SHIFT','2022-02-23','2022-02-23 10:21:57','2022-02-24 10:21:57','698',0.00,0.00,'698','2022-02-23 11:28:19','698','2022-02-23 11:28:39',10,0),('1','194',257569,'DAILY SHIFT','2022-02-23','2022-02-23 11:30:19','2022-02-24 11:30:19','698',0.00,0.00,'698','2022-02-23 11:35:36','698','2022-02-23 11:35:58',10,0),('1','194',257570,'DAILY SHIFT','2022-02-23','2022-02-23 18:11:17','2022-02-24 18:11:17','698',0.00,0.00,'698','2022-02-23 19:18:43','698','2022-02-23 19:19:11',10,0),('1','194',257571,'DAILY SHIFT','2022-02-24','2022-02-24 07:51:40','2022-02-25 07:51:40','698',0.00,0.00,'698','2022-02-24 19:06:46','698','2022-02-24 19:07:09',10,0),('1','194',257572,'DAILY SHIFT','2022-02-25','2022-02-25 07:44:17','2022-02-26 07:44:17','698',0.00,0.00,'698','2022-02-25 19:11:28','698','2022-02-25 19:11:52',10,0),('1','194',257573,'DAILY SHIFT','2022-02-26','2022-02-26 10:10:19','2022-02-27 10:10:19','698',0.00,0.00,'698','2022-02-26 18:37:45','698','2022-02-26 18:38:18',10,0),('1','194',257574,'DAILY SHIFT','2022-02-27','2022-02-27 10:26:48','2022-02-28 10:26:48','698',0.00,0.00,'698','2022-02-27 17:51:48','698','2022-02-27 17:52:20',10,0),('1','194',257575,'DAILY SHIFT','2022-02-28','2022-02-28 07:21:42','2022-03-01 07:21:42','698',0.00,0.00,'698','2022-02-28 17:30:16','698','2022-02-28 17:30:44',10,0),('1','194',257576,'DAILY SHIFT','2022-02-28','2022-02-28 17:36:11','2022-03-01 17:36:11','698',0.00,0.00,'698','2022-02-28 17:39:28','698','2022-02-28 17:39:47',10,0),('1','194',257577,'DAILY SHIFT','2022-02-28','2022-02-28 17:53:38','2022-03-01 17:53:38','698',0.00,0.00,'698','2022-02-28 19:30:09','698','2022-02-28 19:30:36',10,0),('1','194',257578,'DAILY SHIFT','2022-03-01','2022-03-01 08:01:46','2022-03-02 08:01:46','698',0.00,0.00,'698','2022-03-01 20:03:55','698','2022-03-01 20:04:18',10,0),('1','194',257579,'DAILY SHIFT','2022-03-02','2022-03-02 07:50:57','2022-03-03 07:50:57','698',0.00,0.00,'698','2022-03-02 19:08:20','698','2022-03-02 19:09:27',10,0),('1','194',257580,'DAILY SHIFT','2022-03-03','2022-03-03 07:49:16','2022-03-04 07:49:16','698',0.00,0.00,'698','2022-03-03 19:42:23','698','2022-03-03 19:42:49',10,0),('1','194',257581,'DAILY SHIFT','2022-03-04','2022-03-04 07:53:24','2022-03-05 07:53:24','698',0.00,0.00,'698','2022-03-04 17:14:29','698','2022-03-04 17:15:02',10,0),('1','194',257582,'DAILY SHIFT','2022-03-04','2022-03-04 17:15:47','2022-03-05 17:15:47','698',0.00,0.00,'698','2022-03-04 17:21:48','698','2022-03-04 17:22:18',10,0),('1','194',257583,'DAILY SHIFT','2022-03-04','2022-03-04 17:22:47','2022-03-05 17:22:47','698',0.00,0.00,'698','2022-03-04 19:06:42','698','2022-03-04 19:07:06',10,0),('1','194',257584,'DAILY SHIFT','2022-03-05','2022-03-05 07:57:12','2022-03-06 07:57:12','698',0.00,0.00,'698','2022-03-05 18:58:51','698','2022-03-05 18:59:20',10,0),('1','194',257585,'DAILY SHIFT','2022-03-06','2022-03-06 10:09:28','2022-03-07 10:09:28','698',0.00,0.00,'698','2022-03-06 17:30:50','698','2022-03-06 17:31:13',10,0),('1','194',257586,'DAILY SHIFT','2022-03-07','2022-03-07 07:48:31','2022-03-08 07:48:31','698',0.00,0.00,'698','2022-03-07 17:33:11','698','2022-03-07 17:33:47',10,0),('1','194',257587,'DAILY SHIFT','2022-03-11','2022-03-11 07:49:16','2022-03-12 07:49:16','698',0.00,0.00,'698','2022-03-11 12:50:14','698','2022-03-11 12:50:36',10,0),('1','194',257588,'DAILY SHIFT','2022-03-11','2022-03-11 12:50:58','2022-03-12 12:50:58','698',0.00,0.00,'698','2022-03-11 12:56:33','698','2022-03-11 12:57:03',10,0),('1','194',257589,'DAILY SHIFT','2022-03-11','2022-03-11 14:10:56','2022-03-12 14:10:56','698',0.00,0.00,'698','2022-03-11 18:38:28','698','2022-03-11 18:38:51',10,0),('1','194',257590,'DAILY SHIFT','2022-03-12','2022-03-12 08:50:26','2022-03-13 08:50:26','698',0.00,0.00,'698','2022-03-12 19:14:05','698','2022-03-12 19:14:26',10,0),('1','194',257591,'DAILY SHIFT','2022-03-13','2022-03-13 10:15:28','2022-03-14 10:15:28','698',0.00,0.00,'698','2022-03-13 18:02:16','698','2022-03-13 18:03:03',10,0),('1','194',257592,'DAILY SHIFT','2022-03-14','2022-03-14 09:18:00','2022-03-15 09:18:00','698',0.00,0.00,'698','2022-03-14 14:28:10','698','2022-03-14 14:28:29',10,0),('1','194',257593,'DAILY SHIFT','2022-03-14','2022-03-14 14:29:01','2022-03-15 14:29:01','698',0.00,0.00,'698','2022-03-14 14:38:02','698','2022-03-14 14:38:19',10,0),('1','194',257594,'DAILY SHIFT','2022-03-14','2022-03-14 14:38:38','2022-03-15 14:38:38','698',0.00,0.00,'698','2022-03-14 19:07:28','698','2022-03-14 19:08:05',10,0),('1','194',257595,'DAILY SHIFT','2022-03-15','2022-03-15 07:55:10','2022-03-16 07:55:10','698',0.00,0.00,'698','2022-03-15 19:12:27','698','2022-03-15 19:12:54',10,0),('1','194',257596,'DAILY SHIFT','2022-03-16','2022-03-16 08:14:47','2022-03-17 08:14:47','698',0.00,0.00,'698','2022-03-16 18:35:31','698','2022-03-16 18:36:02',10,0),('1','194',257597,'DAILY SHIFT','2022-03-17','2022-03-17 07:45:08','2022-03-18 07:45:08','698',0.00,0.00,'698','2022-03-17 19:39:40','698','2022-03-17 19:40:09',10,0),('1','194',257598,'DAILY SHIFT','2022-03-18','2022-03-18 07:57:12','2022-03-19 07:57:12','698',0.00,0.00,'698','2022-03-18 18:32:21','698','2022-03-18 18:32:43',10,0),('1','194',257599,'DAILY SHIFT','2022-03-19','2022-03-19 07:42:29','2022-03-20 07:42:29','698',0.00,0.00,'698','2022-03-19 19:22:11','698','2022-03-19 19:22:37',10,0),('1','194',257600,'DAILY SHIFT','2022-03-20','2022-03-20 10:53:45','2022-03-21 10:53:45','698',0.00,0.00,'698','2022-03-20 17:00:15','698','2022-03-20 17:00:58',10,0),('1','194',257601,'DAILY SHIFT','2022-03-20','2022-03-20 17:02:36','2022-03-21 17:02:36','698',0.00,0.00,'698','2022-03-20 17:11:28','698','2022-03-20 17:11:54',10,0),('1','194',257602,'DAILY SHIFT','2022-03-21','2022-03-21 08:00:01','2022-03-22 08:00:01','698',0.00,0.00,'698','2022-03-21 19:09:15','698','2022-03-21 19:09:35',10,0),('1','194',257603,'DAILY SHIFT','2022-03-22','2022-03-22 07:49:11','2022-03-23 07:49:11','698',0.00,0.00,'698','2022-03-22 20:15:06','698','2022-03-22 20:16:02',10,0),('1','194',257604,'DAILY SHIFT','2022-03-23','2022-03-23 07:42:51','2022-03-24 07:42:51','698',0.00,0.00,'698','2022-03-23 18:57:19','698','2022-03-23 18:57:48',10,0),('1','194',257605,'DAILY SHIFT','2022-03-24','2022-03-24 07:32:52','2022-03-25 07:32:52','698',0.00,0.00,'698','2022-03-24 17:04:27','698','2022-03-24 17:04:53',10,0),('1','194',257606,'DAILY SHIFT','2022-03-24','2022-03-24 17:05:28','2022-03-25 17:05:28','698',0.00,0.00,'698','2022-03-25 08:21:29','698','2022-03-25 08:21:51',10,0),('1','194',257607,'DAILY SHIFT','2022-03-25','2022-03-25 08:22:18','2022-03-26 08:22:18','698',0.00,0.00,'698','2022-03-25 19:24:31','698','2022-03-25 19:24:55',10,0),('1','194',257608,'DAILY SHIFT','2022-03-26','2022-03-26 10:38:35','2022-03-27 10:38:35','698',0.00,0.00,'698','2022-03-26 20:34:31','698','2022-03-26 20:34:55',10,0),('1','194',257609,'DAILY SHIFT','2022-03-27','2022-03-27 10:29:05','2022-03-28 10:29:05','698',0.00,0.00,'698','2022-03-27 19:37:58','698','2022-03-27 19:38:20',10,0),('1','194',257610,'DAILY SHIFT','2022-03-28','2022-03-28 08:02:51','2022-03-29 08:02:51','698',0.00,0.00,'698','2022-03-28 08:57:57','698','2022-03-28 08:58:27',10,0),('1','194',257611,'DAILY SHIFT','2022-03-28','2022-03-28 08:59:05','2022-03-29 08:59:05','698',0.00,0.00,'698','2022-03-28 09:10:40','698','2022-03-28 09:11:01',10,0),('1','194',257612,'DAILY SHIFT','2022-03-28','2022-03-28 09:12:01','2022-03-29 09:12:01','698',0.00,0.00,'698','2022-03-28 19:27:13','698','2022-03-28 19:27:43',10,0),('1','194',257613,'DAILY SHIFT','2022-03-29','2022-03-29 08:00:11','2022-03-30 08:00:11','698',0.00,0.00,'698','2022-03-29 19:30:21','698','2022-03-29 19:30:50',10,0),('1','194',257614,'DAILY SHIFT','2022-03-30','2022-03-30 07:54:41','2022-03-31 07:54:41','698',0.00,0.00,'698','2022-03-30 19:15:13','698','2022-03-30 19:15:43',10,0),('1','194',257615,'DAILY SHIFT','2022-03-31','2022-03-31 07:40:51','2022-04-01 07:40:51','698',0.00,0.00,'698','2022-03-31 19:14:24','698','2022-03-31 19:15:52',10,0),('1','194',257616,'DAILY SHIFT','2022-04-01','2022-04-01 07:44:17','2022-04-02 07:44:17','698',0.00,0.00,'698','2022-04-01 18:21:21','698','2022-04-01 18:21:54',10,0),('1','194',257617,'DAILY SHIFT','2022-04-02','2022-04-02 07:42:33','2022-04-03 07:42:33','698',0.00,0.00,'698','2022-04-02 14:53:38','698','2022-04-02 14:53:57',10,0),('1','194',257618,'DAILY SHIFT','2022-04-02','2022-04-02 14:54:18','2022-04-03 14:54:18','698',0.00,0.00,'698','2022-04-02 14:58:31','698','2022-04-02 14:58:48',10,0),('1','194',257619,'DAILY SHIFT','2022-04-02','2022-04-02 17:14:19','2022-04-03 17:14:19','698',0.00,0.00,'698','2022-04-02 20:47:05','698','2022-04-02 20:47:26',10,0),('1','194',257620,'DAILY SHIFT','2022-04-03','2022-04-03 11:04:25','2022-04-04 11:04:25','698',0.00,0.00,'698','2022-04-03 17:04:19','698','2022-04-03 17:04:49',10,0),('1','194',257621,'DAILY SHIFT','2022-04-04','2022-04-04 08:01:59','2022-04-05 08:01:59','698',0.00,0.00,'698','2022-04-04 18:48:06','698','2022-04-04 18:48:26',10,0),('1','194',257622,'DAILY SHIFT','2022-04-05','2022-04-05 08:20:00','2022-04-06 08:20:00','698',0.00,0.00,'698','2022-04-05 19:12:26','698','2022-04-05 19:13:08',10,0),('1','194',257623,'DAILY SHIFT','2022-04-06','2022-04-06 07:47:51','2022-04-07 07:47:51','698',0.00,0.00,'698','2022-04-06 18:29:37','698','2022-04-06 18:29:59',10,0),('1','194',257624,'DAILY SHIFT','2022-04-07','2022-04-07 08:18:44','2022-04-08 08:18:44','698',0.00,0.00,'698','2022-04-07 18:34:10','698','2022-04-07 18:40:16',10,0),('1','194',257625,'DAILY SHIFT','2022-04-08','2022-04-08 07:51:34','2022-04-09 07:51:34','698',0.00,0.00,'698','2022-04-08 12:05:26','698','2022-04-08 12:05:45',10,0),('1','194',257626,'DAILY SHIFT','2022-04-10','2022-04-10 10:51:08','2022-04-11 10:51:08','698',0.00,0.00,'698','2022-04-10 18:05:31','698','2022-04-10 18:05:58',10,0),('1','194',257627,'DAILY SHIFT','2022-04-10','2022-04-10 18:24:38','2022-04-11 18:24:38','698',0.00,0.00,'698','2022-04-10 18:28:43','698','2022-04-10 18:29:05',10,0),('1','194',257628,'DAILY SHIFT','2022-04-11','2022-04-11 08:36:24','2022-04-12 08:36:24','698',0.00,0.00,'698','2022-04-11 18:38:51','698','2022-04-11 18:39:12',10,0),('1','194',257629,'DAILY SHIFT','2022-04-12','2022-04-12 08:06:55','2022-04-13 08:06:55','698',0.00,0.00,'698','2022-04-12 18:38:02','698','2022-04-12 18:38:28',10,0),('1','194',257630,'DAILY SHIFT','2022-04-13','2022-04-13 07:39:19','2022-04-14 07:39:19','698',0.00,0.00,'698','2022-04-13 18:46:29','698','2022-04-13 18:46:48',10,0),('1','194',257631,'DAILY SHIFT','2022-04-14','2022-04-14 08:13:41','2022-04-15 08:13:41','698',0.00,0.00,'698','2022-04-14 18:27:47','698','2022-04-14 18:28:18',10,0),('1','194',257632,'DAILY SHIFT','2022-04-15','2022-04-15 07:44:08','2022-04-16 07:44:08','698',0.00,0.00,'698','2022-04-15 20:44:24','698','2022-04-15 20:44:47',10,0),('1','194',257633,'DAILY SHIFT','2022-04-16','2022-04-16 07:43:25','2022-04-17 07:43:25','698',0.00,0.00,'698','2022-04-16 18:38:18','698','2022-04-16 18:38:46',10,0),('1','194',257634,'DAILY SHIFT','2022-04-16','2022-04-16 18:39:07','2022-04-17 18:39:07','698',0.00,0.00,'698','2022-04-16 18:43:02','698','2022-04-16 18:43:21',10,0),('1','194',257635,'DAILY SHIFT','2022-04-16','2022-04-16 18:43:43','2022-04-17 18:43:43','698',0.00,0.00,'698','2022-04-16 18:50:32','698','2022-04-16 18:51:06',10,0),('1','194',257636,'DAILY SHIFT','2022-04-17','2022-04-17 10:24:58','2022-04-18 10:24:58','698',0.00,0.00,'698','2022-04-17 17:35:25','698','2022-04-17 17:35:52',10,0),('1','194',257637,'DAILY SHIFT','2022-04-18','2022-04-18 07:58:55','2022-04-19 07:58:55','698',0.00,0.00,'698','2022-04-18 19:25:40','698','2022-04-18 19:26:12',10,0),('1','194',257638,'DAILY SHIFT','2022-04-19','2022-04-19 07:59:00','2022-04-20 07:59:00','698',0.00,0.00,'698','2022-04-19 19:37:23','698','2022-04-19 19:38:54',10,0),('1','194',257639,'DAILY SHIFT','2022-04-20','2022-04-20 07:40:23','2022-04-21 07:40:23','698',0.00,0.00,'698','2022-04-20 21:20:19','698','2022-04-20 21:20:42',10,0),('1','194',257640,'DAILY SHIFT','2022-04-21','2022-04-21 12:47:32','2022-04-22 12:47:32','698',0.00,0.00,'698','2022-04-21 18:15:28','698','2022-04-21 18:15:47',10,0),('1','194',257641,'DAILY SHIFT','2022-04-21','2022-04-21 18:16:06','2022-04-22 18:16:06','698',0.00,0.00,'698','2022-04-21 19:16:13','698','2022-04-21 19:16:42',10,0),('1','194',257642,'DAILY SHIFT','2022-04-22','2022-04-22 07:41:21','2022-04-23 07:41:21','698',0.00,0.00,'698','2022-04-22 20:08:55','698','2022-04-22 20:09:43',10,0),('1','194',257643,'DAILY SHIFT','2022-04-23','2022-04-23 08:27:21','2022-04-24 08:27:21','698',0.00,0.00,'698','2022-04-23 19:51:49','698','2022-04-23 19:52:10',10,0),('1','194',257644,'DAILY SHIFT','2022-04-24','2022-04-24 10:24:26','2022-04-25 10:24:26','698',0.00,0.00,'698','2022-04-24 18:06:19','698','2022-04-24 18:07:34',10,0),('1','194',257645,'DAILY SHIFT','2022-04-25','2022-04-25 08:24:54','2022-04-26 08:24:54','698',0.00,0.00,'698','2022-04-25 16:09:30','698','2022-04-25 16:09:56',10,0),('1','194',257646,'DAILY SHIFT','2022-04-25','2022-04-25 16:10:44','2022-04-26 16:10:44','698',0.00,0.00,'698','2022-04-25 16:17:27','698','2022-04-25 16:17:54',10,0),('1','194',257647,'DAILY SHIFT','2022-04-25','2022-04-25 16:32:10','2022-04-26 16:32:10','698',0.00,0.00,'698','2022-04-25 21:50:00','698','2022-04-25 21:50:20',10,0),('1','194',257648,'DAILY SHIFT','2022-04-26','2022-04-26 10:38:07','2022-04-27 10:38:07','698',0.00,0.00,'698','2022-04-26 19:29:46','698','2022-04-26 19:31:34',10,0),('1','194',257649,'DAILY SHIFT','2022-04-27','2022-04-27 09:46:17','2022-04-28 09:46:17','698',0.00,0.00,'698','2022-04-27 17:37:20','698','2022-04-27 17:37:53',10,0),('1','194',257650,'DAILY SHIFT','2022-04-28','2022-04-29 21:36:21','2022-04-30 21:36:21','698',0.00,0.00,'698','2022-04-29 21:40:39','698','2022-04-29 21:41:25',10,0),('1','194',257651,'DAILY SHIFT','2022-04-30','2022-04-30 10:40:57','2022-05-01 10:40:57','698',0.00,0.00,'698','2022-04-30 13:36:23','698','2022-04-30 13:37:13',10,0),('1','194',257652,'DAILY SHIFT','2022-04-30','2022-04-30 13:37:53','2022-05-01 13:37:53','698',0.00,0.00,'698','2022-04-30 13:45:11','698','2022-04-30 13:45:41',10,0),('1','194',257653,'DAILY SHIFT','2022-04-30','2022-04-30 13:46:36','2022-05-01 13:46:36','698',0.00,0.00,'698','2022-04-30 21:07:54','698','2022-04-30 21:09:37',10,0),('1','194',257654,'DAILY SHIFT','2022-05-01','2022-05-01 11:06:52','2022-05-02 11:06:52','698',0.00,0.00,'698','2022-05-01 20:12:19','698','2022-05-01 20:15:04',10,0),('1','194',257655,'DAILY SHIFT','2022-05-02','2022-05-02 11:23:47','2022-05-03 11:23:47','698',0.00,0.00,'698','2022-05-02 17:37:06','698','2022-05-02 17:37:37',10,0),('1','194',257656,'DAILY SHIFT','2022-05-04','2022-05-04 07:54:07','2022-05-05 07:54:07','698',0.00,0.00,'698','2022-05-04 13:46:16','698','2022-05-04 13:46:39',10,0),('1','194',257657,'DAILY SHIFT','2022-05-04','2022-05-04 13:47:05','2022-05-05 13:47:05','698',0.00,0.00,'698','2022-05-04 14:10:30','698','2022-05-04 14:10:48',10,0),('1','194',257658,'DAILY SHIFT','2022-05-04','2022-05-04 15:20:00','2022-05-05 15:20:00','698',0.00,0.00,'698','2022-05-04 20:17:17','698','2022-05-04 20:17:39',10,0),('1','194',257659,'DAILY SHIFT','2022-05-05','2022-05-05 08:33:25','2022-05-06 08:33:25','698',0.00,0.00,'698','2022-05-05 19:17:41','698','2022-05-05 19:18:06',10,0),('1','194',257660,'DAILY SHIFT','2022-05-06','2022-05-06 08:03:00','2022-05-07 08:03:00','698',0.00,0.00,'698','2022-05-06 20:44:39','698','2022-05-06 20:46:51',10,0),('1','194',257661,'DAILY SHIFT','2022-05-07','2022-05-07 07:55:09','2022-05-08 07:55:09','698',0.00,0.00,'698','2022-05-07 17:33:13','698','2022-05-07 17:33:37',10,0),('1','194',257662,'DAILY SHIFT','2022-05-10','2022-05-10 11:25:55','2022-05-11 11:25:55','698',0.00,0.00,'698','2022-05-10 14:22:26','698','2022-05-10 14:22:53',10,0),('1','194',257663,'DAILY SHIFT','2022-05-10','2022-05-10 14:23:38','2022-05-11 14:23:38','698',0.00,0.00,'698','2022-05-10 14:27:31','698','2022-05-10 14:27:56',10,0),('1','194',257664,'DAILY SHIFT','2022-05-10','2022-05-10 14:33:48','2022-05-11 14:33:48','698',0.00,0.00,'698','2022-05-10 20:32:16','698','2022-05-10 20:33:03',10,0),('1','194',257665,'DAILY SHIFT','2022-05-11','2022-05-11 07:41:08','2022-05-12 07:41:08','698',0.00,0.00,'698','2022-05-11 20:21:01','698','2022-05-11 20:21:26',10,0),('1','194',257666,'DAILY SHIFT','2022-05-12','2022-05-12 08:06:49','2022-05-13 08:06:49','698',0.00,0.00,'698','2022-05-12 20:29:47','698','2022-05-12 20:30:20',10,0),('1','194',257667,'DAILY SHIFT','2022-05-13','2022-05-13 07:34:37','2022-05-14 07:34:37','698',0.00,0.00,'698','2022-05-13 20:01:14','698','2022-05-13 20:01:44',10,0),('1','194',257668,'DAILY SHIFT','2022-05-14','2022-05-14 07:46:39','2022-05-15 07:46:39','698',0.00,0.00,'698','2022-05-14 16:57:08','698','2022-05-14 16:57:39',10,0),('1','194',257669,'DAILY SHIFT','2022-05-16','2022-05-16 07:32:06','2022-05-17 07:32:06','698',0.00,0.00,'698','2022-05-16 16:11:49','698','2022-05-16 16:14:38',10,0),('1','194',257670,'DAILY SHIFT','2022-05-16','2022-05-16 16:16:13','2022-05-17 16:16:13','698',0.00,0.00,'698','2022-05-16 16:26:18','698','2022-05-16 16:26:38',10,0),('1','194',257671,'DAILY SHIFT','2022-05-16','2022-05-16 16:39:09','2022-05-17 16:39:09','698',0.00,0.00,'698','2022-05-16 21:06:42','698','2022-05-16 21:07:10',10,0),('1','194',257672,'DAILY SHIFT','2022-05-17','2022-05-17 10:28:41','2022-05-18 10:28:41','698',0.00,0.00,'698','2022-05-17 20:48:23','698','2022-05-17 20:48:49',10,0),('1','194',257673,'DAILY SHIFT','2022-05-18','2022-05-18 07:49:18','2022-05-19 07:49:18','698',0.00,0.00,'698','2022-05-18 19:00:36','698','2022-05-18 19:01:20',10,0),('1','194',257674,'DAILY SHIFT','2022-05-18','2022-05-18 19:18:42','2022-05-19 19:18:42','698',0.00,0.00,'698','2022-05-18 19:24:23','698','2022-05-18 19:27:38',10,0),('1','194',257675,'DAILY SHIFT','2022-05-19','2022-05-19 07:47:05','2022-05-20 07:47:05','698',0.00,0.00,'698','2022-05-19 13:54:18','698','2022-05-19 13:54:46',10,0),('1','194',257676,'DAILY SHIFT','2022-05-25','2022-05-25 15:20:08','2022-05-26 15:20:08','698',0.00,0.00,'698','2022-05-25 17:38:07','698','2022-05-25 17:38:45',10,0),('1','194',257677,'DAILY SHIFT','2022-05-25','2022-05-25 17:47:05','2022-05-26 17:47:05','698',0.00,0.00,'698','2022-05-26 07:34:50','698','2022-05-26 07:35:09',10,0),('1','194',257678,'DAILY SHIFT','2022-05-26','2022-05-26 07:35:38','2022-05-27 07:35:38','698',0.00,0.00,'698','2022-05-26 19:34:06','698','2022-05-26 19:34:35',10,0),('1','194',257679,'DAILY SHIFT','2022-05-29','2022-05-29 13:05:41','2022-05-30 13:05:41','698',0.00,0.00,'698','2022-05-29 13:15:08','698','2022-05-29 13:15:38',10,0),('1','194',257680,'DAILY SHIFT','2022-05-29','2022-05-29 13:16:03','2022-05-30 13:16:03','698',0.00,0.00,'698','2022-05-29 15:24:51','698','2022-05-29 15:25:16',10,0),('1','194',257681,'DAILY SHIFT','2022-05-29','2022-05-29 15:30:26','2022-05-30 15:30:26','698',0.00,0.00,'698','2022-05-29 21:09:57','698','2022-05-29 21:10:22',10,0),('1','194',257682,'DAILY SHIFT','2022-05-30','2022-05-30 07:33:33','2022-05-31 07:33:33','698',0.00,0.00,'698','2022-05-30 18:21:03','698','2022-05-30 18:21:38',10,0),('1','194',257683,'DAILY SHIFT','2022-05-30','2022-05-30 18:22:40','2022-05-31 18:22:40','698',0.00,0.00,'698','2022-05-30 18:37:41','698','2022-05-30 18:38:03',10,0),('1','194',257684,'DAILY SHIFT','2022-06-01','2022-06-01 10:09:16','2022-06-02 10:09:16','698',0.00,0.00,'698','2022-06-01 12:48:18','698','2022-06-01 12:48:40',10,0),('1','194',257685,'DAILY SHIFT','2022-06-01','2022-06-01 12:49:24','2022-06-02 12:49:24','698',0.00,0.00,'698','2022-06-01 12:59:21','698','2022-06-01 12:59:44',10,0),('1','194',257686,'DAILY SHIFT','2022-06-01','2022-06-01 13:08:56','2022-06-02 13:08:56','698',0.00,0.00,'698','2022-06-02 07:26:14','698','2022-06-02 07:26:35',10,0),('1','194',257687,'DAILY SHIFT','2022-06-02','2022-06-02 07:27:13','2022-06-03 07:27:13','698',0.00,0.00,'698','2022-06-02 19:25:43','698','2022-06-02 19:26:12',10,0),('1','194',257688,'DAILY SHIFT','2022-06-03','2022-06-03 08:27:47','2022-06-04 08:27:47','698',0.00,0.00,'698','2022-06-03 11:19:30','698','2022-06-03 11:19:51',10,0),('1','194',257689,'DAILY SHIFT','2022-06-03','2022-06-03 11:20:19','2022-06-04 11:20:19','698',0.00,0.00,'698','2022-06-03 11:26:01','698','2022-06-03 11:26:21',10,0),('1','194',257690,'DAILY SHIFT','2022-06-03','2022-06-03 11:27:21','2022-06-04 11:27:21','698',0.00,0.00,'698','2022-06-03 19:11:37','698','2022-06-03 19:12:16',10,0),('1','194',257691,'DAILY SHIFT','2022-06-04','2022-06-04 16:21:35','2022-06-05 16:21:35','698',0.00,0.00,'698','2022-06-04 17:03:03','698','2022-06-04 17:03:29',10,0),('1','194',257692,'DAILY SHIFT','2022-06-04','2022-06-04 17:04:12','2022-06-05 17:04:12','698',0.00,0.00,'698','2022-06-04 17:08:38','698','2022-06-04 17:09:00',10,0),('1','194',257693,'DAILY SHIFT','2022-06-04','2022-06-04 17:28:41','2022-06-05 17:28:41','698',0.00,0.00,'698','2022-06-04 21:13:54','698','2022-06-04 21:14:13',10,0),('1','194',257694,'DAILY SHIFT','2022-06-05','2022-06-05 10:34:18','2022-06-06 10:34:18','698',0.00,0.00,'698','2022-06-05 18:12:33','698','2022-06-05 18:12:56',10,0),('1','194',257695,'DAILY SHIFT','2022-06-06','2022-06-06 07:53:05','2022-06-07 07:53:05','698',0.00,0.00,'698','2022-06-06 17:38:30','698','2022-06-06 17:39:28',10,0),('1','194',257696,'DAILY SHIFT','2022-06-08','2022-06-08 13:19:24','2022-06-09 13:19:24','698',0.00,0.00,'698','2022-06-08 15:45:13','698','2022-06-08 15:46:08',10,0),('1','194',257697,'DAILY SHIFT','2022-06-08','2022-06-08 15:46:37','2022-06-09 15:46:37','698',0.00,0.00,'698','2022-06-08 15:51:30','698','2022-06-08 15:52:24',10,0),('1','194',257698,'DAILY SHIFT','2022-06-08','2022-06-08 15:59:51','2022-06-09 15:59:51','698',0.00,0.00,'698','2022-06-08 19:40:37','698','2022-06-08 19:43:23',10,0),('1','194',257699,'DAILY SHIFT','2022-06-09','2022-06-09 07:49:56','2022-06-10 07:49:56','698',0.00,0.00,'698','2022-06-09 20:01:20','698','2022-06-09 20:01:45',10,0),('1','194',257700,'DAILY SHIFT','2022-06-10','2022-06-10 14:39:28','2022-06-11 14:39:28','698',0.00,0.00,'698','2022-06-10 20:18:26','698','2022-06-10 20:18:52',10,0),('1','194',257701,'DAILY SHIFT','2022-06-11','2022-06-11 13:27:17','2022-06-12 13:27:17','698',0.00,0.00,'698','2022-06-11 15:44:16','698','2022-06-11 15:44:51',10,0),('1','194',257702,'DAILY SHIFT','2022-06-11','2022-06-11 15:45:51','2022-06-12 15:45:51','698',0.00,0.00,'698','2022-06-11 15:52:26','698','2022-06-11 15:52:48',10,0),('1','194',257703,'DAILY SHIFT','2022-06-11','2022-06-11 16:05:57','2022-06-12 16:05:57','698',0.00,0.00,'698','2022-06-11 19:17:08','698','2022-06-11 19:17:34',10,0),('1','194',257704,'DAILY SHIFT','2022-06-12','2022-06-12 10:18:18','2022-06-13 10:18:18','698',0.00,0.00,'698','2022-06-12 17:38:54','698','2022-06-12 17:39:16',10,0),('1','194',257705,'DAILY SHIFT','2022-06-13','2022-06-13 08:03:04','2022-06-14 08:03:04','698',0.00,0.00,'698','2022-06-13 15:05:31','698','2022-06-13 15:05:51',10,0),('1','194',257706,'DAILY SHIFT','2022-06-15','2022-06-15 08:11:33','2022-06-16 08:11:33','698',0.00,0.00,'698','2022-06-15 08:32:07','698','2022-06-15 08:32:24',10,0),('1','194',257707,'DAILY SHIFT','2022-06-15','2022-06-15 08:32:42','2022-06-16 08:32:42','698',0.00,0.00,'698','2022-06-15 08:35:09','698','2022-06-15 08:35:25',10,0),('1','194',257708,'DAILY SHIFT','2022-06-15','2022-06-15 08:47:38','2022-06-16 08:47:38','698',0.00,0.00,'698','2022-06-15 19:30:44','698','2022-06-15 19:31:09',10,0),('1','194',257709,'DAILY SHIFT','2022-06-16','2022-06-16 07:58:50','2022-06-17 07:58:50','698',0.00,0.00,'698','2022-06-16 14:02:23','698','2022-06-16 14:02:42',10,0),('1','194',257710,'DAILY SHIFT','2022-06-16','2022-06-16 14:03:01','2022-06-17 14:03:01','698',0.00,0.00,'698','2022-06-16 14:05:33','698','2022-06-16 14:05:52',10,0),('1','194',257711,'DAILY SHIFT','2022-06-16','2022-06-16 14:11:36','2022-06-17 14:11:36','698',0.00,0.00,'698','2022-06-16 20:20:29','698','2022-06-16 20:22:35',10,0),('1','194',257712,'DAILY SHIFT','2022-06-17','2022-06-17 07:54:20','2022-06-18 07:54:20','698',0.00,0.00,'698','2022-06-17 19:19:23','698','2022-06-17 19:19:44',10,0),('1','194',257713,'DAILY SHIFT','2022-06-18','2022-06-18 07:55:32','2022-06-19 07:55:32','698',0.00,0.00,'698','2022-06-18 14:33:02','698','2022-06-18 14:33:22',10,0),('1','194',257714,'DAILY SHIFT','2022-06-18','2022-06-18 14:34:04','2022-06-19 14:34:04','698',0.00,0.00,'698','2022-06-18 14:36:45','698','2022-06-18 14:37:25',10,0),('1','194',257715,'DAILY SHIFT','2022-06-18','2022-06-18 14:42:17','2022-06-19 14:42:17','698',0.00,0.00,'698','2022-06-18 19:41:24','698','2022-06-19 10:52:13',10,0),('1','194',257716,'DAILY SHIFT','2022-06-19','2022-06-19 10:52:38','2022-06-20 10:52:38','698',0.00,0.00,'698','2022-06-19 17:14:26','698','2022-06-19 17:14:56',10,0),('1','194',257717,'DAILY SHIFT','2022-06-20','2022-06-20 07:52:29','2022-06-21 07:52:29','698',0.00,0.00,'698','2022-06-20 13:11:15','698','2022-06-20 13:11:42',10,0),('1','194',257718,'DAILY SHIFT','2022-06-20','2022-06-20 13:12:29','2022-06-21 13:12:29','698',0.00,0.00,'698','2022-06-20 13:20:58','698','2022-06-20 13:21:27',10,0),('1','194',257719,'DAILY SHIFT','2022-06-20','2022-06-20 13:22:03','2022-06-21 13:22:03','698',0.00,0.00,'698','2022-06-20 20:27:26','698','2022-06-20 20:27:51',10,0),('1','194',257720,'DAILY SHIFT','2022-06-21','2022-06-21 07:33:03','2022-06-22 07:33:03','698',0.00,0.00,'698','2022-06-21 19:10:34','698','2022-06-21 19:10:54',10,0),('1','194',257721,'DAILY SHIFT','2022-06-22','2022-06-22 07:29:42','2022-06-23 07:29:42','698',0.00,0.00,'698','2022-06-22 17:36:59','698','2022-06-22 17:37:33',10,0),('1','194',257722,'DAILY SHIFT','2022-06-22','2022-06-22 17:42:49','2022-06-23 17:42:49','698',0.00,0.00,'698','2022-06-22 17:58:40','698','2022-06-22 17:59:02',10,0),('1','194',257723,'DAILY SHIFT','2022-06-23','2022-06-23 09:19:12','2022-06-24 09:19:12','698',0.00,0.00,'698','2022-06-23 19:42:05','698','2022-06-23 19:42:37',10,0),('1','194',257724,'DAILY SHIFT','2022-06-24','2022-06-24 07:56:59','2022-06-25 07:56:59','698',0.00,0.00,'698','2022-06-24 19:36:26','698','2022-06-24 19:36:45',10,0),('1','194',257725,'DAILY SHIFT','2022-06-25','2022-06-25 11:18:31','2022-06-26 11:18:31','698',0.00,0.00,'698','2022-06-25 13:34:18','698','2022-06-25 13:34:40',10,0),('1','194',257726,'DAILY SHIFT','2022-06-25','2022-06-25 15:30:30','2022-06-26 15:30:30','698',0.00,0.00,'698','2022-06-25 15:35:45','698','2022-06-25 15:36:41',10,0),('1','194',257727,'DAILY SHIFT','2022-06-27','2022-06-27 08:52:21','2022-06-28 08:52:21','698',0.00,0.00,'698','2022-06-27 22:02:09','698','2022-06-27 22:02:39',10,0),('1','194',257728,'DAILY SHIFT','2022-06-28','2022-06-28 07:45:35','2022-06-29 07:45:35','698',0.00,0.00,'698','2022-06-28 10:12:43','698','2022-06-28 10:13:06',10,0),('1','194',257729,'DAILY SHIFT','2022-06-28','2022-06-28 10:13:41','2022-06-29 10:13:41','698',0.00,0.00,'698','2022-06-28 10:18:08','698','2022-06-28 10:18:32',10,0),('1','194',257730,'DAILY SHIFT','2022-06-28','2022-06-28 12:31:52','2022-06-29 12:31:52','698',0.00,0.00,'698','2022-06-28 19:29:00','698','2022-06-28 19:29:21',10,0),('1','194',257731,'DAILY SHIFT','2022-06-29','2022-06-29 07:53:07','2022-06-30 07:53:07','698',0.00,0.00,'698','2022-06-29 20:00:29','698','2022-06-29 20:00:51',10,0),('1','194',257732,'DAILY SHIFT','2022-06-30','2022-06-30 07:47:03','2022-07-01 07:47:03','698',0.00,0.00,'698','2022-06-30 11:54:51','698','2022-06-30 11:55:08',10,0),('1','194',257733,'DAILY SHIFT','2022-06-30','2022-06-30 11:56:21','2022-07-01 11:56:21','698',0.00,0.00,'698','2022-06-30 11:58:27','698','2022-06-30 11:58:43',10,0),('1','194',257734,'DAILY SHIFT','2022-06-30','2022-06-30 13:42:49','2022-07-01 13:42:49','698',0.00,0.00,'698','2022-06-30 18:35:14','698','2022-06-30 18:35:42',10,0),('1','194',257735,'DAILY SHIFT','2022-07-01','2022-07-01 07:50:03','2022-07-02 07:50:03','698',0.00,0.00,'698','2022-07-01 18:53:04','698','2022-07-01 18:56:01',10,0),('1','194',257736,'DAILY SHIFT','2022-07-02','2022-07-02 07:43:14','2022-07-03 07:43:14','698',0.00,0.00,'698','2022-07-02 13:57:30','698','2022-07-02 13:57:53',10,0),('1','194',257737,'DAILY SHIFT','2022-07-02','2022-07-02 13:58:20','2022-07-03 13:58:20','698',0.00,0.00,'698','2022-07-02 14:02:34','698','2022-07-02 14:03:05',10,0),('1','194',257738,'DAILY SHIFT','2022-07-02','2022-07-02 14:28:44','2022-07-03 14:28:44','698',0.00,0.00,'698','2022-07-02 21:44:13','698','2022-07-02 21:45:08',10,0),('1','194',257739,'DAILY SHIFT','2022-07-03','2022-07-03 09:54:36','2022-07-04 09:54:36','698',0.00,0.00,'698','2022-07-03 17:52:20','698','2022-07-03 17:52:41',10,0),('1','194',257740,'DAILY SHIFT','2022-07-04','2022-07-04 07:36:23','2022-07-05 07:36:23','698',0.00,0.00,'698','2022-07-04 14:28:43','698','2022-07-04 14:29:06',10,0),('1','194',257741,'DAILY SHIFT','2022-07-04','2022-07-04 14:47:42','2022-07-05 14:47:42','698',0.00,0.00,'698','2022-07-06 14:13:26','698','2022-07-06 14:13:46',10,0),('1','194',257742,'DAILY SHIFT','2022-07-06','2022-07-06 14:19:20','2022-07-07 14:19:20','698',0.00,0.00,'698','2022-07-06 21:35:44','698','2022-07-06 21:37:01',10,0),('1','194',257743,'DAILY SHIFT','2022-07-07','2022-07-07 07:48:08','2022-07-08 07:48:08','698',0.00,0.00,'698','2022-07-07 18:26:14','698','2022-07-07 18:26:33',10,0),('1','194',257744,'DAILY SHIFT','2022-07-07','2022-07-07 18:26:59','2022-07-08 18:26:59','698',0.00,0.00,'698','2022-07-07 18:29:59','698','2022-07-07 18:30:24',10,0),('1','194',257745,'DAILY SHIFT','2022-07-11','2022-07-11 13:20:29','2022-07-12 13:20:29','698',0.00,0.00,'698','2022-07-11 20:23:14','698','2022-07-11 20:23:38',10,0),('1','194',257746,'DAILY SHIFT','2022-07-12','2022-07-12 07:23:25','2022-07-13 07:23:25','698',0.00,0.00,'698','2022-07-12 22:17:18','698','2022-07-12 22:18:18',10,0),('1','194',257747,'DAILY SHIFT','2022-07-13','2022-07-13 07:39:38','2022-07-14 07:39:38','698',0.00,0.00,'698','2022-07-13 14:06:24','698','2022-07-13 14:06:43',10,0),('1','194',257748,'DAILY SHIFT','2022-07-13','2022-07-13 14:07:53','2022-07-14 14:07:53','698',0.00,0.00,'698','2022-07-13 14:11:17','698','2022-07-13 14:11:36',10,0),('1','194',257749,'DAILY SHIFT','2022-07-14','2022-07-14 07:32:38','2022-07-15 07:32:38','698',0.00,0.00,'698','2022-07-14 20:41:03','698','2022-07-14 20:41:39',10,0),('1','194',257750,'DAILY SHIFT','2022-07-15','2022-07-15 07:33:02','2022-07-16 07:33:02','698',0.00,0.00,'698','2022-07-15 11:58:02','698','2022-07-15 11:58:20',10,0),('1','194',257751,'DAILY SHIFT','2022-07-15','2022-07-15 12:07:13','2022-07-16 12:07:13','698',0.00,0.00,'698','2022-07-15 12:09:17','698','2022-07-15 12:09:38',10,0),('1','194',257752,'DAILY SHIFT','2022-07-15','2022-07-15 14:37:53','2022-07-16 14:37:53','698',0.00,0.00,'698','2022-07-15 18:53:58','698','2022-07-15 18:54:23',10,0),('1','194',257753,'DAILY SHIFT','2022-07-16','2022-07-16 07:35:06','2022-07-17 07:35:06','698',0.00,0.00,'698','2022-07-16 19:04:40','698','2022-07-16 19:05:18',10,0),('1','194',257754,'DAILY SHIFT','2022-07-17','2022-07-17 12:05:01','2022-07-18 12:05:01','698',0.00,0.00,'698','2022-07-17 12:48:09','698','2022-07-17 12:48:29',10,0),('1','194',257755,'DAILY SHIFT','2022-07-17','2022-07-17 12:50:32','2022-07-18 12:50:32','698',0.00,0.00,'698','2022-07-17 12:56:11','698','2022-07-17 12:56:57',10,0),('1','194',257756,'DAILY SHIFT','2022-07-17','2022-07-17 13:14:56','2022-07-18 13:14:56','698',0.00,0.00,'698','2022-07-17 16:38:04','698','2022-07-17 16:38:42',10,0),('1','194',257757,'DAILY SHIFT','2022-07-18','2022-07-18 07:27:51','2022-07-19 07:27:51','698',0.00,0.00,'698','2022-07-18 18:52:37','698','2022-07-18 18:52:55',10,0),('1','194',257758,'DAILY SHIFT','2022-07-19','2022-07-19 07:36:56','2022-07-20 07:36:56','698',0.00,0.00,'698','2022-07-19 13:50:41','698','2022-07-19 13:51:01',10,0),('1','194',257759,'DAILY SHIFT','2022-07-19','2022-07-19 13:51:43','2022-07-20 13:51:43','698',0.00,0.00,'698','2022-07-19 13:53:49','698','2022-07-19 13:54:08',10,0),('1','194',257760,'DAILY SHIFT','2022-07-19','2022-07-19 15:18:26','2022-07-20 15:18:26','698',0.00,0.00,'698','2022-07-19 19:01:58','698','2022-07-19 19:02:16',10,0),('1','194',257761,'DAILY SHIFT','2022-07-20','2022-07-20 07:34:20','2022-07-21 07:34:20','698',0.00,0.00,'698','2022-07-20 19:48:41','698','2022-07-20 19:49:01',10,0),('1','194',257762,'DAILY SHIFT','2022-07-20','2022-07-20 19:50:29','2022-07-21 19:50:29','698',0.00,0.00,'698','2022-07-20 19:54:44','698','2022-07-20 19:55:04',10,0),('1','194',257763,'DAILY SHIFT','2022-07-21','2022-07-21 07:46:05','2022-07-22 07:46:05','698',0.00,0.00,'698','2022-07-21 19:32:31','698','2022-07-21 19:32:48',10,0),('1','194',257764,'DAILY SHIFT','2022-07-22','2022-07-22 07:40:40','2022-07-23 07:40:40','698',0.00,0.00,'698','2022-07-22 18:42:56','698','2022-07-22 18:43:36',10,0),('1','194',257765,'DAILY SHIFT','2022-07-23','2022-07-23 07:43:23','2022-07-24 07:43:23','698',0.00,0.00,'698','2022-07-23 13:12:30','698','2022-07-23 13:13:00',10,0),('1','194',257766,'DAILY SHIFT','2022-07-23','2022-07-23 13:19:15','2022-07-24 13:19:15','698',0.00,0.00,'698','2022-07-23 13:22:02','698','2022-07-23 13:22:59',10,0),('1','194',257767,'DAILY SHIFT','2022-07-23','2022-07-23 14:27:55','2022-07-24 14:27:55','698',0.00,0.00,'698','2022-07-23 19:35:03','698','2022-07-23 19:35:26',10,0),('1','194',257768,'DAILY SHIFT','2022-07-24','2022-07-24 10:03:31','2022-07-25 10:03:31','698',0.00,0.00,'698','2022-07-24 16:55:30','698','2022-07-24 16:55:51',10,0),('1','194',257769,'DAILY SHIFT','2022-07-25','2022-07-25 07:50:38','2022-07-26 07:50:38','698',0.00,0.00,'698','2022-07-25 19:02:24','698','2022-07-25 19:02:43',10,0),('1','194',257770,'DAILY SHIFT','2022-07-26','2022-07-26 07:44:31','2022-07-27 07:44:31','698',0.00,0.00,'698','2022-07-26 09:31:46','698','2022-07-26 09:32:09',10,0),('1','194',257771,'DAILY SHIFT','2022-07-26','2022-07-26 09:32:38','2022-07-27 09:32:38','698',0.00,0.00,'698','2022-07-26 09:36:49','698','2022-07-26 09:37:11',10,0),('1','194',257772,'DAILY SHIFT','2022-07-26','2022-07-26 09:38:09','2022-07-27 09:38:09','698',0.00,0.00,'698','2022-07-26 19:02:19','698','2022-07-26 19:03:04',10,0),('1','194',257773,'DAILY SHIFT','2022-07-27','2022-07-27 07:44:43','2022-07-28 07:44:43','698',0.00,0.00,'698','2022-07-27 18:21:41','698','2022-07-27 18:22:01',10,0),('1','194',257774,'DAILY SHIFT','2022-07-27','2022-07-27 18:39:30','2022-07-28 18:39:30','698',0.00,0.00,'698','2022-07-27 18:44:14','698','2022-07-27 18:44:41',10,0),('1','194',257775,'DAILY SHIFT','2022-07-28','2022-07-28 07:42:46','2022-07-29 07:42:46','698',0.00,0.00,'698','2022-07-28 19:11:04','698','2022-07-28 19:11:28',10,0),('1','194',257776,'DAILY SHIFT','2022-07-29','2022-07-29 07:46:17','2022-07-30 07:46:17','698',0.00,0.00,'698','2022-07-29 19:55:02','698','2022-07-29 19:55:26',10,0),('1','194',257777,'DAILY SHIFT','2022-07-29','2022-07-29 20:25:52','2022-07-30 20:25:52','698',0.00,0.00,'698','2022-07-29 20:28:14','698','2022-07-29 20:28:37',10,0),('1','194',257778,'DAILY SHIFT','2022-07-30','2022-07-30 10:21:13','2022-07-31 10:21:13','698',0.00,0.00,'698','2022-07-30 18:51:59','698','2022-07-30 18:52:23',10,0),('1','194',257779,'DAILY SHIFT','2022-07-31','2022-07-31 09:34:09','2022-08-01 09:34:09','698',0.00,0.00,'698','2022-07-31 19:14:59','698','2022-07-31 19:16:00',10,0),('1','194',257780,'DAILY SHIFT','2022-07-31','2022-07-31 19:17:13','2022-08-01 19:17:13','698',0.00,0.00,'698','2022-07-31 19:50:06','698','2022-07-31 19:50:27',10,0),('1','194',257781,'DAILY SHIFT','2022-08-01','2022-08-01 07:29:42','2022-08-02 07:29:42','698',0.00,0.00,'698','2022-08-01 19:16:21','698','2022-08-01 19:17:19',10,0),('1','194',257782,'DAILY SHIFT','2022-08-02','2022-08-02 07:44:06','2022-08-03 07:44:06','698',0.00,0.00,'698','2022-08-02 12:22:40','698','2022-08-02 12:23:05',10,0),('1','194',257783,'DAILY SHIFT','2022-08-02','2022-08-02 12:24:04','2022-08-03 12:24:04','698',0.00,0.00,'698','2022-08-02 12:28:06','698','2022-08-02 12:28:40',10,0),('1','194',257784,'DAILY SHIFT','2022-08-02','2022-08-02 12:33:34','2022-08-03 12:33:34','698',0.00,0.00,'698','2022-08-02 20:01:27','698','2022-08-02 20:02:19',10,0),('1','194',257785,'DAILY SHIFT','2022-08-03','2022-08-03 07:56:26','2022-08-04 07:56:26','698',0.00,0.00,'698','2022-08-03 20:31:22','698','2022-08-03 20:31:39',10,0),('1','194',257786,'DAILY SHIFT','2022-08-05','2022-08-05 19:40:01','2022-08-06 19:40:01','698',0.00,0.00,'698','2022-08-05 19:46:12','698','2022-08-05 19:46:44',10,0),('1','194',257787,'DAILY SHIFT','2022-08-06','2022-08-06 08:10:19','2022-08-07 08:10:19','698',0.00,0.00,'698','2022-08-06 19:00:09','698','2022-08-06 19:00:35',10,0),('1','194',257788,'DAILY SHIFT','2022-08-07','2022-08-07 09:49:08','2022-08-08 09:49:08','698',0.00,0.00,'698','2022-08-07 15:36:44','698','2022-08-07 15:37:11',10,0),('1','194',257789,'DAILY SHIFT','2022-08-07','2022-08-07 18:04:30','2022-08-08 18:04:30','698',0.00,0.00,'698','2022-08-07 18:08:46','698','2022-08-07 18:09:06',10,0),('1','194',257790,'DAILY SHIFT','2022-08-09','2022-08-09 14:23:08','2022-08-10 14:23:08','698',0.00,0.00,'698','2022-08-09 18:46:42','698','2022-08-09 18:47:17',10,0),('1','194',257791,'DAILY SHIFT','2022-08-10','2022-08-10 07:41:06','2022-08-11 07:41:06','698',0.00,0.00,'698','2022-08-10 19:39:55','698','2022-08-10 19:40:21',10,0),('1','194',257792,'DAILY SHIFT','2022-08-11','2022-08-11 07:36:11','2022-08-12 07:36:11','698',0.00,0.00,'698','2022-08-11 16:42:08','698','2022-08-11 16:42:31',10,0),('1','194',257793,'DAILY SHIFT','2022-08-11','2022-08-11 16:49:30','2022-08-12 16:49:30','698',0.00,0.00,'698','2022-08-11 17:02:29','698','2022-08-11 17:02:54',10,0),('1','194',257794,'DAILY SHIFT','2022-08-12','2022-08-12 08:17:30','2022-08-13 08:17:30','698',0.00,0.00,'698','2022-08-12 20:41:24','698','2022-08-12 20:42:02',10,0),('1','194',257795,'DAILY SHIFT','2022-08-13','2022-08-13 07:51:40','2022-08-14 07:51:40','698',0.00,0.00,'698','2022-08-13 19:19:56','698','2022-08-13 19:20:22',10,0),('1','194',257796,'DAILY SHIFT','2022-08-13','2022-08-13 19:21:24','2022-08-14 19:21:24','698',0.00,0.00,'698','2022-08-13 19:29:24','698','2022-08-13 19:33:44',10,0),('1','194',257797,'DAILY SHIFT','2022-08-15','2022-08-15 07:46:47','2022-08-16 07:46:47','698',0.00,0.00,'698','2022-08-15 21:12:13','698','2022-08-15 21:12:39',10,0),('1','194',257798,'DAILY SHIFT','2022-08-16','2022-08-16 07:55:54','2022-08-17 07:55:54','698',0.00,0.00,'698','2022-08-16 11:43:25','698','2022-08-16 11:43:58',10,0),('1','194',257799,'DAILY SHIFT','2022-08-16','2022-08-16 11:44:22','2022-08-17 11:44:22','698',0.00,0.00,'698','2022-08-16 11:57:47','698','2022-08-16 11:58:07',10,0),('1','194',257800,'DAILY SHIFT','2022-08-17','2022-08-17 08:13:32','2022-08-18 08:13:32','698',0.00,0.00,'698','2022-08-17 21:03:50','698','2022-08-17 21:04:18',10,0),('1','194',257801,'DAILY SHIFT','2022-08-18','2022-08-18 07:35:27','2022-08-19 07:35:27','698',0.00,0.00,'698','2022-08-18 17:16:26','698','2022-08-18 17:17:17',10,0),('1','194',257802,'DAILY SHIFT','2022-08-19','2022-08-19 08:04:47','2022-08-20 08:04:47','698',0.00,0.00,'698','2022-08-19 19:47:58','698','2022-08-19 19:48:29',10,0),('1','194',257803,'DAILY SHIFT','2022-08-20','2022-08-20 07:24:54','2022-08-21 07:24:54','698',0.00,0.00,'698','2022-08-20 16:28:17','698','2022-08-20 16:29:12',10,0),('1','194',257804,'DAILY SHIFT','2022-08-20','2022-08-20 16:30:30','2022-08-21 16:30:30','698',0.00,0.00,'698','2022-08-20 20:40:03','698','2022-08-20 20:56:30',10,0),('1','194',257805,'DAILY SHIFT','2022-08-21','2022-08-21 08:46:57','2022-08-22 08:46:57','698',0.00,0.00,'698','2022-08-21 17:42:15','698','2022-08-21 17:43:00',10,0),('1','194',257806,'DAILY SHIFT','2022-08-22','2022-08-22 07:29:40','2022-08-23 07:29:40','698',0.00,0.00,'698','2022-08-22 16:15:18','698','2022-08-22 16:15:36',10,0),('1','194',257807,'DAILY SHIFT','2022-08-22','2022-08-22 16:16:00','2022-08-23 16:16:00','698',0.00,0.00,'698','2022-08-22 16:19:08','698','2022-08-22 16:19:23',10,0),('1','194',257808,'DAILY SHIFT','2022-08-24','2022-08-24 09:36:43','2022-08-25 09:36:43','698',0.00,0.00,'698','2022-08-24 21:10:41','698','2022-08-24 21:11:19',10,0),('1','194',257809,'DAILY SHIFT','2022-08-25','2022-08-25 07:48:07','2022-08-26 07:48:07','698',0.00,0.00,'698','2022-08-25 19:48:18','698','2022-08-25 19:51:03',10,0),('1','194',257810,'DAILY SHIFT','2022-08-25','2022-08-25 19:56:27','2022-08-26 19:56:27','698',0.00,0.00,'698','2022-08-25 20:23:51','698','2022-08-25 20:24:59',10,0),('1','194',257811,'DAILY SHIFT','2022-08-26','2022-08-26 15:13:25','2022-08-27 15:13:25','698',0.00,0.00,'698','2022-08-26 20:43:14','698','2022-08-26 20:44:00',10,0),('1','194',257812,'DAILY SHIFT','2022-08-27','2022-08-27 09:51:36','2022-08-28 09:51:36','698',0.00,0.00,'698','2022-08-27 20:46:41','698','2022-08-27 20:47:27',10,0),('1','194',257813,'DAILY SHIFT','2022-08-27','2022-08-27 20:48:11','2022-08-28 20:48:11','698',0.00,0.00,'698','2022-08-27 20:57:30','698','2022-08-27 20:58:12',10,0),('1','194',257814,'DAILY SHIFT','2022-08-28','2022-08-28 10:12:19','2022-08-29 10:12:19','698',0.00,0.00,'698','2022-08-28 19:47:29','698','2022-08-28 19:47:59',10,0),('1','194',257815,'DAILY SHIFT','2022-08-29','2022-08-29 07:43:09','2022-08-30 07:43:09','698',0.00,0.00,'698','2022-08-29 18:05:44','698','2022-08-29 18:06:15',10,0),('1','194',257816,'DAILY SHIFT','2022-08-30','2022-08-30 07:47:47','2022-08-31 07:47:47','698',0.00,0.00,'698','2022-08-30 11:21:34','698','2022-08-30 11:21:59',10,0),('1','194',257817,'DAILY SHIFT','2022-08-30','2022-08-30 11:23:31','2022-08-31 11:23:31','698',0.00,0.00,'698','2022-08-30 11:29:59','698','2022-08-30 11:30:21',10,0),('1','194',257818,'DAILY SHIFT','2022-08-30','2022-08-30 12:02:44','2022-08-31 12:02:44','698',0.00,0.00,'698','2022-08-30 20:30:24','698','2022-08-30 20:33:36',10,0),('1','194',257819,'DAILY SHIFT','2022-08-31','2022-08-31 07:45:56','2022-09-01 07:45:56','698',0.00,0.00,'698','2022-08-31 20:16:25','698','2022-08-31 20:18:52',10,0),('1','194',257820,'DAILY SHIFT','2022-09-01','2022-09-01 07:35:36','2022-09-02 07:35:36','698',0.00,0.00,'698','2022-09-01 11:57:26','698','2022-09-01 11:57:45',10,0),('1','194',257821,'DAILY SHIFT','2022-09-01','2022-09-01 11:58:53','2022-09-02 11:58:53','698',0.00,0.00,'698','2022-09-01 12:03:26','698','2022-09-01 12:04:15',10,0),('1','194',257822,'DAILY SHIFT','2022-09-01','2022-09-01 12:13:16','2022-09-02 12:13:16','698',0.00,0.00,'698','2022-09-01 20:07:56','698','2022-09-01 20:08:25',10,0),('1','194',257823,'DAILY SHIFT','2022-09-02','2022-09-02 07:37:55','2022-09-03 07:37:55','698',0.00,0.00,'698','2022-09-02 19:48:42','698','2022-09-02 19:50:28',10,0),('1','194',257824,'DAILY SHIFT','2022-09-02','2022-09-02 19:52:17','2022-09-03 19:52:17','698',0.00,0.00,'698','2022-09-02 19:56:49','698','2022-09-02 19:57:22',10,0),('1','194',257825,'DAILY SHIFT','2022-09-03','2022-09-03 07:38:55','2022-09-04 07:38:55','698',0.00,0.00,'698','2022-09-03 19:29:54','698','2022-09-03 19:36:17',10,0),('1','194',257826,'DAILY SHIFT','2022-09-04','2022-09-04 10:14:00','2022-09-05 10:14:00','698',0.00,0.00,'698','2022-09-04 17:34:06','698','2022-09-04 17:34:39',10,0),('1','194',257827,'DAILY SHIFT','2022-09-04','2022-09-04 17:53:02','2022-09-05 17:53:02','698',0.00,0.00,'698','2022-09-04 17:56:26','698','2022-09-04 17:56:48',10,0),('1','194',257828,'DAILY SHIFT','2022-09-05','2022-09-05 07:29:31','2022-09-06 07:29:31','698',0.00,0.00,'698','2022-09-05 20:45:54','698','2022-09-05 20:48:56',10,0),('1','194',257829,'DAILY SHIFT','2022-09-06','2022-09-06 07:28:57','2022-09-07 07:28:57','698',0.00,0.00,'698','2022-09-06 11:45:38','698','2022-09-06 11:45:57',10,0),('1','194',257830,'DAILY SHIFT','2022-09-06','2022-09-06 11:46:16','2022-09-07 11:46:16','698',0.00,0.00,'698','2022-09-06 11:48:05','698','2022-09-06 11:48:21',10,0),('1','194',257831,'DAILY SHIFT','2022-09-06','2022-09-06 12:13:53','2022-09-07 12:13:53','698',0.00,0.00,'698','2022-09-06 19:45:34','698','2022-09-06 19:46:00',10,0),('1','194',257832,'DAILY SHIFT','2022-09-07','2022-09-07 07:26:26','2022-09-08 07:26:26','698',0.00,0.00,'698','2022-09-07 19:58:44','698','2022-09-07 19:59:59',10,0),('1','194',257833,'DAILY SHIFT','2022-09-07','2022-09-07 20:02:02','2022-09-08 20:02:02','698',0.00,0.00,'698','2022-09-07 20:05:58','698','2022-09-07 20:06:17',10,0),('1','194',257834,'DAILY SHIFT','2022-09-08','2022-09-08 07:43:43','2022-09-09 07:43:43','698',0.00,0.00,'698','2022-09-08 20:46:07','698','2022-09-08 20:46:53',10,0),('1','194',257835,'DAILY SHIFT','2022-09-09','2022-09-09 07:40:24','2022-09-10 07:40:24','698',0.00,0.00,'698','2022-09-09 20:36:57','698','2022-09-09 20:37:25',10,0),('1','194',257836,'DAILY SHIFT','2022-09-10','2022-09-10 07:36:28','2022-09-11 07:36:28','698',0.00,0.00,'698','2022-09-10 14:13:47','698','2022-09-10 14:14:10',10,0),('1','194',257837,'DAILY SHIFT','2022-09-10','2022-09-10 14:15:06','2022-09-11 14:15:06','698',0.00,0.00,'698','2022-09-10 14:19:09','698','2022-09-10 14:19:26',10,0),('1','194',257838,'DAILY SHIFT','2022-09-10','2022-09-10 14:30:00','2022-09-11 14:30:00','698',0.00,0.00,'698','2022-09-10 19:43:50','698','2022-09-10 19:44:39',10,0),('1','194',257839,'DAILY SHIFT','2022-09-11','2022-09-11 10:02:15','2022-09-12 10:02:15','698',0.00,0.00,'698','2022-09-11 17:21:07','698','2022-09-11 17:21:31',10,0),('1','194',257840,'DAILY SHIFT','2022-09-12','2022-09-12 07:34:19','2022-09-13 07:34:19','698',0.00,0.00,'698','2022-09-12 13:01:38','698','2022-09-12 13:02:06',10,0),('1','194',257841,'DAILY SHIFT','2022-09-12','2022-09-12 13:03:14','2022-09-13 13:03:14','698',0.00,0.00,'698','2022-09-12 13:15:02','698','2022-09-12 13:15:26',10,0),('1','194',257842,'DAILY SHIFT','2022-09-12','2022-09-12 13:54:45','2022-09-13 13:54:45','698',0.00,0.00,'698','2022-09-12 19:44:25','698','2022-09-12 19:45:06',10,0),('1','194',257843,'DAILY SHIFT','2022-09-13','2022-09-13 07:42:51','2022-09-14 07:42:51','698',0.00,0.00,'698','2022-09-13 19:23:06','698','2022-09-13 19:23:31',10,0),('1','194',257844,'DAILY SHIFT','2022-09-14','2022-09-14 07:36:05','2022-09-15 07:36:05','698',0.00,0.00,'698','2022-09-14 17:38:07','698','2022-09-14 17:38:52',10,0),('1','194',257845,'DAILY SHIFT','2022-09-14','2022-09-14 17:40:32','2022-09-15 17:40:32','698',0.00,0.00,'698','2022-09-14 17:43:55','698','2022-09-14 17:44:34',10,0),('1','194',257846,'DAILY SHIFT','2022-09-15','2022-09-15 07:41:06','2022-09-16 07:41:06','698',0.00,0.00,'698','2022-09-15 18:36:02','698','2022-09-15 18:36:25',10,0),('1','194',257847,'DAILY SHIFT','2022-09-16','2022-09-16 07:29:09','2022-09-17 07:29:09','698',0.00,0.00,'698','2022-09-16 18:35:35','698','2022-09-16 18:35:51',10,0),('1','194',257848,'DAILY SHIFT','2022-09-17','2022-09-17 07:40:03','2022-09-18 07:40:03','698',0.00,0.00,'698','2022-09-17 11:34:24','698','2022-09-17 11:34:48',10,0),('1','194',257849,'DAILY SHIFT','2022-09-17','2022-09-17 11:35:18','2022-09-18 11:35:18','698',0.00,0.00,'698','2022-09-17 11:39:16','698','2022-09-17 11:39:38',10,0),('1','194',257850,'DAILY SHIFT','2022-09-17','2022-09-17 13:12:07','2022-09-18 13:12:07','698',0.00,0.00,'698','2022-09-17 19:09:46','698','2022-09-17 19:10:03',10,0),('1','194',257851,'DAILY SHIFT','2022-09-18','2022-09-18 09:57:49','2022-09-19 09:57:49','698',0.00,0.00,'698','2022-09-18 17:20:36','698','2022-09-18 17:21:09',10,0),('1','194',257852,'DAILY SHIFT','2022-09-19','2022-09-19 07:31:22','2022-09-20 07:31:22','698',0.00,0.00,'698','2022-09-19 15:48:49','698','2022-09-19 15:49:14',10,0),('1','194',257853,'DAILY SHIFT','2022-09-19','2022-09-19 16:43:06','2022-09-20 16:43:06','698',0.00,0.00,'698','2022-09-19 16:46:19','698','2022-09-19 16:46:46',10,0),('1','194',257854,'DAILY SHIFT','2022-09-19','2022-09-19 16:52:07','2022-09-20 16:52:07','698',0.00,0.00,'698','2022-09-19 19:33:55','698','2022-09-19 19:34:17',10,0),('1','194',257855,'DAILY SHIFT','2022-09-20','2022-09-20 07:35:41','2022-09-21 07:35:41','698',0.00,0.00,'698','2022-09-20 18:55:30','698','2022-09-20 18:56:00',10,0),('1','194',257856,'DAILY SHIFT','2022-09-21','2022-09-21 07:31:57','2022-09-22 07:31:57','698',0.00,0.00,'698','2022-09-21 12:57:55','698','2022-09-21 12:58:14',10,0),('1','194',257857,'DAILY SHIFT','2022-09-21','2022-09-21 12:58:41','2022-09-22 12:58:41','698',0.00,0.00,'698','2022-09-21 13:00:40','698','2022-09-21 13:00:56',10,0),('1','194',257858,'DAILY SHIFT','2022-09-21','2022-09-21 13:17:11','2022-09-22 13:17:11','698',0.00,0.00,'698','2022-09-21 19:51:14','698','2022-09-21 19:51:47',10,0),('1','194',257859,'DAILY SHIFT','2022-09-22','2022-09-22 07:31:11','2022-09-23 07:31:11','698',0.00,0.00,'698','2022-09-22 20:05:53','698','2022-09-22 20:06:19',10,0),('1','194',257860,'DAILY SHIFT','2022-09-23','2022-09-23 07:46:18','2022-09-24 07:46:18','698',0.00,0.00,'698','2022-09-23 11:55:04','698','2022-09-23 11:55:29',10,0),('1','194',257861,'DAILY SHIFT','2022-09-23','2022-09-23 11:56:19','2022-09-24 11:56:19','698',0.00,0.00,'698','2022-09-23 12:02:20','698','2022-09-23 12:03:04',10,0),('1','194',257862,'DAILY SHIFT','2022-09-23','2022-09-23 12:16:10','2022-09-24 12:16:10','698',0.00,0.00,'698','2022-09-23 19:00:55','698','2022-09-23 19:01:14',10,0),('1','194',257863,'DAILY SHIFT','2022-09-24','2022-09-24 10:01:21','2022-09-25 10:01:21','698',0.00,0.00,'698','2022-09-24 19:12:47','698','2022-09-24 19:13:12',10,0),('1','194',257864,'DAILY SHIFT','2022-09-25','2022-09-25 09:54:16','2022-09-26 09:54:16','698',0.00,0.00,'698','2022-09-25 14:11:45','698','2022-09-25 14:12:21',10,0),('1','194',257865,'DAILY SHIFT','2022-09-25','2022-09-25 14:13:22','2022-09-26 14:13:22','698',0.00,0.00,'698','2022-09-25 14:20:20','698','2022-09-25 14:20:42',10,0),('1','194',257866,'DAILY SHIFT','2022-09-25','2022-09-25 14:52:44','2022-09-26 14:52:44','698',0.00,0.00,'698','2022-09-25 18:13:26','698','2022-09-25 18:14:02',10,0),('1','194',257867,'DAILY SHIFT','2022-09-26','2022-09-26 07:40:29','2022-09-27 07:40:29','698',0.00,0.00,'698','2022-09-26 18:57:14','698','2022-09-26 18:58:01',10,0),('1','194',257868,'DAILY SHIFT','2022-09-27','2022-09-27 08:00:15','2022-09-28 08:00:15','698',0.00,0.00,'698','2022-09-27 11:21:12','698','2022-09-27 11:22:21',10,0),('1','194',257869,'DAILY SHIFT','2022-09-27','2022-09-27 11:23:47','2022-09-28 11:23:47','698',0.00,0.00,'698','2022-09-27 11:27:01','698','2022-09-27 11:27:25',10,0),('1','194',257870,'DAILY SHIFT','2022-09-27','2022-09-27 16:07:46','2022-09-28 16:07:46','698',0.00,0.00,'698','2022-09-27 20:24:15','698','2022-09-27 20:24:50',10,0),('1','194',257871,'DAILY SHIFT','2022-09-28','2022-09-28 07:45:54','2022-09-29 07:45:54','698',0.00,0.00,'698','2022-09-28 19:17:54','698','2022-09-28 19:18:12',10,0),('1','194',257872,'DAILY SHIFT','2022-09-29','2022-09-29 07:44:04','2022-09-30 07:44:04','698',0.00,0.00,'698','2022-09-29 14:14:09','698','2022-09-29 14:14:30',10,0),('1','194',257873,'DAILY SHIFT','2022-09-29','2022-09-29 14:15:08','2022-09-30 14:15:08','698',0.00,0.00,'698','2022-09-29 14:16:39','698','2022-09-29 14:16:57',10,0),('1','194',257874,'DAILY SHIFT','2022-09-29','2022-09-29 14:21:00','2022-09-30 14:21:00','698',0.00,0.00,'698','2022-09-29 18:43:44','698','2022-09-29 18:44:01',10,0),('1','194',257875,'DAILY SHIFT','2022-09-30','2022-09-30 07:39:59','2022-10-01 07:39:59','698',0.00,0.00,'698','2022-09-30 19:27:00','698','2022-09-30 19:27:19',10,0),('1','194',257876,'DAILY SHIFT','2022-10-01','2022-10-01 07:48:58','2022-10-02 07:48:58','698',0.00,0.00,'698','2022-10-01 14:28:59','698','2022-10-01 14:29:22',10,0),('1','194',257877,'DAILY SHIFT','2022-10-01','2022-10-01 14:31:31','2022-10-02 14:31:31','698',0.00,0.00,'698','2022-10-01 14:35:29','698','2022-10-01 14:35:50',10,0),('1','194',257878,'DAILY SHIFT','2022-10-02','2022-10-02 11:25:30','2022-10-03 11:25:30','698',0.00,0.00,'698','2022-10-02 17:52:36','698','2022-10-02 17:53:18',10,0),('1','194',257879,'DAILY SHIFT','2022-10-03','2022-10-03 07:36:30','2022-10-04 07:36:30','698',0.00,0.00,'698','2022-10-03 19:31:12','698','2022-10-03 19:31:34',10,0),('1','194',257880,'DAILY SHIFT','2022-10-04','2022-10-04 07:28:53','2022-10-05 07:28:53','698',0.00,0.00,'698','2022-10-04 10:45:52','698','2022-10-04 10:46:28',10,0),('1','194',257881,'DAILY SHIFT','2022-10-04','2022-10-04 10:46:58','2022-10-05 10:46:58','698',0.00,0.00,'698','2022-10-04 10:48:32','698','2022-10-04 10:49:10',10,0),('1','194',257882,'DAILY SHIFT','2022-10-04','2022-10-04 15:25:55','2022-10-05 15:25:55','698',0.00,0.00,'698','2022-10-04 19:26:18','698','2022-10-04 19:26:45',10,0),('1','194',257883,'DAILY SHIFT','2022-10-05','2022-10-05 07:36:29','2022-10-06 07:36:29','698',0.00,0.00,'698','2022-10-05 18:38:07','698','2022-10-05 18:38:36',10,0),('1','194',257884,'DAILY SHIFT','2022-10-06','2022-10-06 07:34:08','2022-10-07 07:34:08','698',0.00,0.00,'698','2022-10-06 18:36:43','698','2022-10-06 18:37:09',10,0),('1','194',257885,'DAILY SHIFT','2022-10-07','2022-10-07 07:38:30','2022-10-08 07:38:30','698',0.00,0.00,'698','2022-10-07 11:20:10','698','2022-10-07 11:20:31',10,0),('1','194',257886,'DAILY SHIFT','2022-10-07','2022-10-07 11:21:02','2022-10-08 11:21:02','698',0.00,0.00,'698','2022-10-07 11:24:15','698','2022-10-07 11:24:33',10,0),('1','194',257887,'DAILY SHIFT','2022-10-07','2022-10-07 11:45:28','2022-10-08 11:45:28','698',0.00,0.00,'698','2022-10-07 19:10:34','698','2022-10-07 19:11:11',10,0),('1','194',257888,'DAILY SHIFT','2022-10-08','2022-10-08 07:43:53','2022-10-09 07:43:53','698',0.00,0.00,'698','2022-10-08 19:26:27','698','2022-10-08 19:26:45',10,0),('1','194',257889,'DAILY SHIFT','2022-10-09','2022-10-09 10:12:33','2022-10-10 10:12:33','698',0.00,0.00,'698','2022-10-09 16:00:10','698','2022-10-09 16:00:34',10,0),('1','194',257890,'DAILY SHIFT','2022-10-09','2022-10-09 17:45:26','2022-10-10 17:45:26','698',0.00,0.00,'698','2022-10-09 17:49:35','698','2022-10-09 17:50:04',10,0),('1','194',257891,'DAILY SHIFT','2022-10-12','2022-10-12 09:28:30','2022-10-13 09:28:30','698',0.00,0.00,'698','2022-10-12 19:15:02','698','2022-10-12 19:15:20',10,0),('1','194',257892,'DAILY SHIFT','2022-10-13','2022-10-13 07:48:47','2022-10-14 07:48:47','698',0.00,0.00,'698','2022-10-13 18:13:41','698','2022-10-13 18:14:00',10,0),('1','194',257893,'DAILY SHIFT','2022-10-13','2022-10-13 18:14:56','2022-10-14 18:14:56','698',0.00,0.00,'698','2022-10-13 18:16:42','698','2022-10-13 18:17:00',10,0),('1','194',257894,'DAILY SHIFT','2022-10-14','2022-10-14 07:39:10','2022-10-15 07:39:10','698',0.00,0.00,'698','2022-10-14 18:56:10','698','2022-10-14 18:56:28',10,0),('1','194',257895,'DAILY SHIFT','2022-10-15','2022-10-15 07:45:10','2022-10-16 07:45:10','698',0.00,0.00,'698','2022-10-15 17:25:45','698','2022-10-15 17:26:11',10,0),('1','194',257896,'DAILY SHIFT','2022-10-15','2022-10-15 17:26:56','2022-10-16 17:26:56','698',0.00,0.00,'698','2022-10-15 17:30:03','698','2022-10-15 17:30:28',10,0),('1','194',257897,'DAILY SHIFT','2022-10-18','2022-10-18 10:21:06','2022-10-19 10:21:06','698',0.00,0.00,'698','2022-10-18 19:25:33','698','2022-10-18 19:25:53',10,0),('1','194',257898,'DAILY SHIFT','2022-10-19','2022-10-19 07:41:43','2022-10-20 07:41:43','698',0.00,0.00,'698','2022-10-19 19:26:31','698','2022-10-19 19:27:21',10,0),('1','194',257899,'DAILY SHIFT','2022-10-19','2022-10-19 19:31:37','2022-10-20 19:31:37','698',0.00,0.00,'698','2022-10-19 19:41:18','698','2022-10-19 19:48:21',10,0),('1','194',257900,'DAILY SHIFT','2022-10-20','2022-10-20 15:16:26','2022-10-21 15:16:26','698',0.00,0.00,'698','2022-10-20 18:49:56','698','2022-10-20 18:50:19',10,0),('1','194',257901,'DAILY SHIFT','2022-10-21','2022-10-21 07:44:04','2022-10-22 07:44:04','698',0.00,0.00,'698','2022-10-21 19:24:11','698','2022-10-21 19:24:30',10,0),('1','194',257902,'DAILY SHIFT','2022-10-22','2022-10-22 07:42:31','2022-10-23 07:42:31','698',0.00,0.00,'698','2022-10-22 17:06:24','698','2022-10-22 17:07:31',10,0),('1','194',257903,'DAILY SHIFT','2022-10-22','2022-10-22 18:01:17','2022-10-23 18:01:17','698',0.00,0.00,'698','2022-10-22 18:04:25','698','2022-10-22 18:04:47',10,0),('1','194',257904,'DAILY SHIFT','2022-10-23','2022-10-23 10:05:06','2022-10-24 10:05:06','698',0.00,0.00,'698','2022-10-23 16:50:29','698','2022-10-23 16:50:51',10,0),('1','194',257905,'DAILY SHIFT','2022-10-24','2022-10-24 07:34:31','2022-10-25 07:34:31','698',0.00,0.00,'698','2022-10-24 18:45:07','698','2022-10-24 18:45:27',10,0),('1','194',257906,'DAILY SHIFT','2022-10-25','2022-10-25 07:42:37','2022-10-26 07:42:37','698',0.00,0.00,'698','2022-10-25 15:34:56','698','2022-10-25 15:35:16',10,0),('1','194',257907,'DAILY SHIFT','2022-10-25','2022-10-25 15:35:51','2022-10-26 15:35:51','698',0.00,0.00,'698','2022-10-25 15:38:03','698','2022-10-25 15:38:19',10,0),('1','194',257908,'DAILY SHIFT','2022-10-27','2022-10-27 11:55:13','2022-10-28 11:55:13','698',0.00,0.00,'698','2022-10-27 21:15:02','698','2022-10-27 21:15:30',10,0),('1','194',257909,'DAILY SHIFT','2022-10-28','2022-10-28 07:37:46','2022-10-29 07:37:46','698',0.00,0.00,'698','2022-10-28 18:53:32','698','2022-10-28 18:54:01',10,0),('1','194',257910,'DAILY SHIFT','2022-10-29','2022-10-29 08:14:38','2022-10-30 08:14:38','698',0.00,0.00,'698','2022-10-29 18:44:40','698','2022-10-29 18:45:01',10,0),('1','194',257911,'DAILY SHIFT','2022-10-30','2022-10-30 10:13:03','2022-10-31 10:13:03','698',0.00,0.00,'698','2022-10-30 17:58:44','698','2022-10-30 17:59:13',10,0),('1','194',257912,'DAILY SHIFT','2022-10-31','2022-10-31 07:45:57','2022-11-01 07:45:57','698',0.00,0.00,'698','2022-10-31 09:57:40','698','2022-10-31 09:58:07',10,0),('1','194',257913,'DAILY SHIFT','2022-10-31','2022-10-31 09:58:38','2022-11-01 09:58:38','698',0.00,0.00,'698','2022-10-31 10:00:54','698','2022-10-31 10:01:15',10,0),('1','194',257914,'DAILY SHIFT','2022-10-31','2022-10-31 11:38:41','2022-11-01 11:38:41','698',0.00,0.00,'698','2022-11-01 07:34:19','698','2022-11-01 07:34:47',10,0),('1','194',257915,'DAILY SHIFT','2022-11-01','2022-11-01 07:35:13','2022-11-02 07:35:13','698',0.00,0.00,'698','2022-11-01 17:41:46','698','2022-11-01 17:42:13',10,0),('1','194',257916,'DAILY SHIFT','2022-11-02','2022-11-02 07:34:45','2022-11-03 07:34:45','698',0.00,0.00,'698','2022-11-02 13:03:32','698','2022-11-02 13:03:59',10,0),('1','194',257917,'DAILY SHIFT','2022-11-02','2022-11-02 13:04:38','2022-11-03 13:04:38','698',0.00,0.00,'698','2022-11-02 13:08:18','698','2022-11-02 13:08:39',10,0),('1','194',257918,'DAILY SHIFT','2022-11-03','2022-11-03 07:28:28','2022-11-04 07:28:28','698',0.00,0.00,'698','2022-11-03 19:50:18','698','2022-11-03 19:51:55',10,0),('1','194',257919,'DAILY SHIFT','2022-11-04','2022-11-04 07:18:10','2022-11-05 07:18:10','698',0.00,0.00,'698','2022-11-04 18:33:38','698','2022-11-04 18:34:03',10,0),('1','194',257920,'DAILY SHIFT','2022-11-05','2022-11-05 07:59:44','2022-11-06 07:59:44','698',0.00,0.00,'698','2022-11-05 22:17:29','698','2022-11-05 22:18:02',10,0),('1','194',257921,'DAILY SHIFT','2022-11-05','2022-11-05 22:18:41','2022-11-06 22:18:41','698',0.00,0.00,'698','2022-11-05 22:23:08','698','2022-11-05 22:23:33',10,0),('1','194',257922,'DAILY SHIFT','2022-11-05','2022-11-05 22:24:00','2022-11-06 22:24:00','698',0.00,0.00,'698','2022-11-05 23:26:55','698','2022-11-05 23:27:55',10,0),('1','194',257923,'DAILY SHIFT','2022-11-06','2022-11-06 09:42:10','2022-11-07 09:42:10','698',0.00,0.00,'698','2022-11-06 17:53:36','698','2022-11-06 17:54:03',10,0),('1','194',257924,'DAILY SHIFT','2022-11-07','2022-11-07 07:39:37','2022-11-08 07:39:37','698',0.00,0.00,'698','2022-11-07 18:58:49','698','2022-11-07 18:59:10',10,0),('1','194',257925,'DAILY SHIFT','2022-11-08','2022-11-08 07:53:20','2022-11-09 07:53:20','698',0.00,0.00,'698','2022-11-08 11:55:58','698','2022-11-08 11:56:43',10,0),('1','194',257926,'DAILY SHIFT','2022-11-08','2022-11-08 11:58:37','2022-11-09 11:58:37','698',0.00,0.00,'698','2022-11-08 12:05:39','698','2022-11-08 12:06:13',10,0),('1','194',257927,'DAILY SHIFT','2022-11-09','2022-11-09 07:55:29','2022-11-10 07:55:29','698',0.00,0.00,'698','2022-11-09 19:59:41','698','2022-11-09 20:02:38',10,0),('1','194',257928,'DAILY SHIFT','2022-11-10','2022-11-10 07:32:37','2022-11-11 07:32:37','698',0.00,0.00,'698','2022-11-10 19:11:00','698','2022-11-10 19:11:25',10,0),('1','194',257929,'DAILY SHIFT','2022-11-11','2022-11-11 07:46:58','2022-11-12 07:46:58','698',0.00,0.00,'698','2022-11-11 12:27:17','698','2022-11-11 12:27:55',10,0),('1','194',257930,'DAILY SHIFT','2022-11-11','2022-11-11 12:28:26','2022-11-12 12:28:26','698',0.00,0.00,'698','2022-11-11 12:35:29','698','2022-11-11 12:42:21',10,0),('1','194',257931,'DAILY SHIFT','2022-11-13','2022-11-13 09:01:07','2022-11-14 09:01:07','698',0.00,0.00,'698','2022-11-13 19:21:01','698','2022-11-13 19:21:34',10,0),('1','194',257932,'DAILY SHIFT','2022-11-14','2022-11-14 07:36:35','2022-11-15 07:36:35','698',0.00,0.00,'698','2022-11-14 16:24:49','698','2022-11-14 16:25:15',10,0),('1','194',257933,'DAILY SHIFT','2022-11-14','2022-11-14 16:25:46','2022-11-15 16:25:46','698',0.00,0.00,'698','2022-11-14 16:27:14','698','2022-11-14 16:27:40',10,0),('1','194',257934,'DAILY SHIFT','2022-11-15','2022-11-15 08:11:08','2022-11-16 08:11:08','698',0.00,0.00,'698','2022-11-15 19:13:34','698','2022-11-15 19:14:01',10,0),('1','194',257935,'DAILY SHIFT','2022-11-16','2022-11-16 07:36:08','2022-11-17 07:36:08','698',0.00,0.00,'698','2022-11-16 19:14:28','698','2022-11-16 19:14:58',10,0),('1','194',257936,'DAILY SHIFT','2022-11-16','2022-11-16 19:16:07','2022-11-17 19:16:07','698',0.00,0.00,'698','2022-11-16 19:19:57','698','2022-11-16 19:20:26',10,0),('1','194',257937,'DAILY SHIFT','2022-11-17','2022-11-17 08:19:49','2022-11-18 08:19:49','698',0.00,0.00,'698','2022-11-17 18:59:57','698','2022-11-17 19:00:27',10,0),('1','194',257938,'DAILY SHIFT','2022-11-18','2022-11-18 08:54:53','2022-11-19 08:54:53','698',0.00,0.00,'698','2022-11-18 18:50:49','698','2022-11-18 18:51:14',10,0),('1','194',257939,'DAILY SHIFT','2022-11-18','2022-11-18 20:45:19','2022-11-19 20:45:19','698',0.00,0.00,'698','2022-11-18 20:48:54','698','2022-11-18 20:49:18',10,0),('1','194',257940,'DAILY SHIFT','2022-11-19','2022-11-19 07:29:38','2022-11-20 07:29:38','698',0.00,0.00,'698','2022-11-19 20:15:01','698','2022-11-19 20:15:36',10,0),('1','194',257941,'DAILY SHIFT','2022-11-20','2022-11-20 09:34:34','2022-11-21 09:34:34','698',0.00,0.00,'698','2022-11-20 17:45:12','698','2022-11-20 17:45:43',10,0),('1','194',257942,'DAILY SHIFT','2022-11-21','2022-11-21 07:39:53','2022-11-22 07:39:53','698',0.00,0.00,'698','2022-11-21 18:09:56','698','2022-11-21 18:10:30',10,0),('1','194',257943,'DAILY SHIFT','2022-11-21','2022-11-21 18:11:53','2022-11-22 18:11:53','698',0.00,0.00,'698','2022-11-21 18:16:45','698','2022-11-21 18:17:12',10,0),('1','194',257944,'DAILY SHIFT','2022-11-22','2022-11-22 07:29:44','2022-11-23 07:29:44','698',0.00,0.00,'698','2022-11-22 19:03:33','698','2022-11-22 19:04:01',10,0),('1','194',257945,'DAILY SHIFT','2022-11-23','2022-11-23 07:49:12','2022-11-24 07:49:12','698',0.00,0.00,'698','2022-11-23 19:21:16','698','2022-11-23 19:22:01',10,0),('1','194',257946,'DAILY SHIFT','2022-11-24','2022-11-24 07:34:54','2022-11-25 07:34:54','698',0.00,0.00,'698','2022-11-24 19:00:06','698','2022-11-24 19:00:55',10,0),('1','194',257947,'DAILY SHIFT','2022-11-25','2022-11-25 07:33:09','2022-11-26 07:33:09','698',0.00,0.00,'698','2022-11-25 11:42:01','698','2022-11-25 11:42:25',10,0),('1','194',257948,'DAILY SHIFT','2022-11-25','2022-11-25 11:58:54','2022-11-26 11:58:54','698',0.00,0.00,'698','2022-11-25 12:03:44','698','2022-11-25 12:04:19',10,0),('1','194',257949,'DAILY SHIFT','2022-11-25','2022-11-25 12:13:00','2022-11-26 12:13:00','698',0.00,0.00,'698','2022-11-25 19:39:14','698','2022-11-25 19:39:36',10,0),('1','194',257950,'DAILY SHIFT','2022-11-26','2022-11-26 09:56:36','2022-11-27 09:56:36','698',0.00,0.00,'698','2022-11-26 19:00:26','698','2022-11-26 19:00:54',10,0),('1','194',257951,'DAILY SHIFT','2022-11-27','2022-11-27 09:42:08','2022-11-28 09:42:08','698',0.00,0.00,'698','2022-11-27 19:17:35','698','2022-11-27 19:18:17',10,0),('1','194',257952,'DAILY SHIFT','2022-11-27','2022-11-27 19:19:23','2022-11-28 19:19:23','698',0.00,0.00,'698','2022-11-27 19:24:34','698','2022-11-27 19:25:28',10,0),('1','194',257953,'DAILY SHIFT','2022-11-28','2022-11-28 09:30:09','2022-11-29 09:30:09','698',0.00,0.00,'698','2022-11-28 19:49:26','698','2022-11-28 19:50:19',10,0),('1','194',257954,'DAILY SHIFT','2022-11-29','2022-11-29 07:45:47','2022-11-30 07:45:47','698',0.00,0.00,'698','2022-11-29 18:46:08','698','2022-11-29 18:47:21',10,0),('1','194',257955,'DAILY SHIFT','2022-11-30','2022-11-30 07:37:37','2022-12-01 07:37:37','698',0.00,0.00,'698','2022-11-30 15:50:29','698','2022-11-30 15:51:46',10,0),('1','194',257956,'DAILY SHIFT','2022-11-30','2022-11-30 16:29:39','2022-12-01 16:29:39','698',0.00,0.00,'698','2022-11-30 16:56:52','698','2022-11-30 16:57:24',10,0),('1','194',257957,'DAILY SHIFT','2022-12-01','2022-12-01 07:04:06','2022-12-02 07:04:06','698',0.00,0.00,'698','2022-12-01 19:34:44','698','2022-12-01 19:35:14',10,0),('1','194',257958,'DAILY SHIFT','2022-12-02','2022-12-02 07:25:40','2022-12-03 07:25:40','698',0.00,0.00,'698','2022-12-02 19:13:41','698','2022-12-02 19:14:24',10,0),('1','194',257959,'DAILY SHIFT','2022-12-03','2022-12-03 07:44:13','2022-12-04 07:44:13','698',0.00,0.00,'698','2022-12-03 15:32:46','698','2022-12-03 15:33:17',10,0),('1','194',257960,'DAILY SHIFT','2022-12-03','2022-12-03 16:53:04','2022-12-04 16:53:04','698',0.00,0.00,'698','2022-12-03 16:58:01','698','2022-12-03 16:58:48',10,0),('1','194',257961,'DAILY SHIFT','2022-12-04','2022-12-04 10:07:57','2022-12-05 10:07:57','698',0.00,0.00,'698','2022-12-04 18:45:16','698','2022-12-04 18:52:51',10,0),('1','194',257962,'DAILY SHIFT','2022-12-05','2022-12-05 07:45:56','2022-12-06 07:45:56','698',0.00,0.00,'698','2022-12-05 18:30:22','698','2022-12-05 18:30:49',10,0),('1','194',257963,'DAILY SHIFT','2022-12-06','2022-12-06 07:38:25','2022-12-07 07:38:25','698',0.00,0.00,'698','2022-12-06 11:55:03','698','2022-12-06 11:55:44',10,0),('1','194',257964,'DAILY SHIFT','2022-12-06','2022-12-06 12:30:20','2022-12-07 12:30:20','698',0.00,0.00,'698','2022-12-06 12:33:32','698','2022-12-06 12:34:06',10,0),('1','194',257965,'DAILY SHIFT','2022-12-06','2022-12-06 13:01:57','2022-12-07 13:01:57','698',0.00,0.00,'698','2022-12-06 18:37:47','698','2022-12-06 18:38:16',10,0),('1','194',257966,'DAILY SHIFT','2022-12-07','2022-12-07 07:54:05','2022-12-08 07:54:05','698',0.00,0.00,'698','2022-12-07 18:36:52','698','2022-12-07 18:38:04',10,0),('1','194',257967,'DAILY SHIFT','2022-12-08','2022-12-08 07:56:06','2022-12-09 07:56:06','698',0.00,0.00,'698','2022-12-08 18:43:25','698','2022-12-08 18:44:18',10,0),('1','194',257968,'DAILY SHIFT','2022-12-09','2022-12-09 07:31:48','2022-12-10 07:31:48','698',0.00,0.00,'698','2022-12-09 09:58:18','698','2022-12-09 09:58:37',10,0),('1','194',257969,'DAILY SHIFT','2022-12-09','2022-12-09 10:11:08','2022-12-10 10:11:08','698',0.00,0.00,'698','2022-12-09 10:15:23','698','2022-12-09 10:16:06',10,0),('1','194',257970,'DAILY SHIFT','2022-12-09','2022-12-09 10:17:05','2022-12-10 10:17:05','698',0.00,0.00,'698','2022-12-09 18:50:58','698','2022-12-09 18:51:47',10,0),('1','194',257971,'DAILY SHIFT','2022-12-10','2022-12-10 07:37:06','2022-12-11 07:37:06','698',0.00,0.00,'698','2022-12-10 19:17:01','698','2022-12-10 19:17:55',10,0),('1','194',257972,'DAILY SHIFT','2022-12-11','2022-12-11 09:35:16','2022-12-12 09:35:16','698',0.00,0.00,'698','2022-12-11 17:02:04','698','2022-12-11 17:02:37',10,0),('1','194',257973,'DAILY SHIFT','2022-12-11','2022-12-11 17:03:51','2022-12-12 17:03:51','698',0.00,0.00,'698','2022-12-11 17:07:43','698','2022-12-11 17:08:13',10,0),('1','194',257974,'DAILY SHIFT','2022-12-12','2022-12-12 07:43:54','2022-12-13 07:43:54','698',0.00,0.00,'698','2022-12-12 19:16:56','698','2022-12-12 19:19:25',10,0),('1','194',257975,'DAILY SHIFT','2022-12-13','2022-12-13 07:35:02','2022-12-14 07:35:02','698',0.00,0.00,'698','2022-12-13 19:35:29','698','2022-12-13 19:36:18',10,0),('1','194',257976,'DAILY SHIFT','2022-12-14','2022-12-14 07:49:15','2022-12-15 07:49:15','698',0.00,0.00,'698','2022-12-14 10:10:55','698','2022-12-14 10:11:21',10,0),('1','194',257977,'DAILY SHIFT','2022-12-14','2022-12-14 10:12:34','2022-12-15 10:12:34','698',0.00,0.00,'698','2022-12-14 10:14:59','698','2022-12-14 10:15:24',10,0),('1','194',257978,'DAILY SHIFT','2022-12-16','2022-12-16 17:44:55','2022-12-17 17:44:55','698',0.00,0.00,'698','2022-12-16 19:15:56','698','2022-12-16 19:16:16',10,0),('1','194',257979,'DAILY SHIFT','2022-12-17','2022-12-17 09:07:49','2022-12-18 09:07:49','698',0.00,0.00,'698','2022-12-17 19:37:34','698','2022-12-17 19:40:20',10,0),('1','194',257980,'DAILY SHIFT','2022-12-18','2022-12-18 09:41:48','2022-12-19 09:41:48','698',0.00,0.00,'698','2022-12-18 16:56:56','698','2022-12-18 16:57:35',10,0),('1','194',257981,'DAILY SHIFT','2022-12-18','2022-12-18 19:29:43','2022-12-19 19:29:43','698',0.00,0.00,'698','2022-12-18 19:33:48','698','2022-12-18 19:34:10',10,0),('1','194',257982,'DAILY SHIFT','2022-12-19','2022-12-19 07:33:05','2022-12-20 07:33:05','698',0.00,0.00,'698','2022-12-19 19:08:18','698','2022-12-19 19:08:43',10,0),('1','194',257983,'DAILY SHIFT','2022-12-20','2022-12-20 08:35:55','2022-12-21 08:35:55','698',0.00,0.00,'698','2022-12-20 18:57:52','698','2022-12-20 18:58:39',10,0),('1','194',257984,'DAILY SHIFT','2022-12-21','2022-12-21 07:35:44','2022-12-22 07:35:44','698',0.00,0.00,'698','2022-12-21 10:48:33','698','2022-12-21 10:49:45',10,0),('1','194',257985,'DAILY SHIFT','2022-12-21','2022-12-21 10:52:17','2022-12-22 10:52:17','698',0.00,0.00,'698','2022-12-21 10:56:51','698','2022-12-21 10:57:32',10,0),('1','194',257986,'DAILY SHIFT','2022-12-21','2022-12-21 12:06:57','2022-12-22 12:06:57','698',0.00,0.00,'698','2022-12-21 18:44:04','698','2022-12-21 18:44:33',10,0),('1','194',257987,'DAILY SHIFT','2022-12-22','2022-12-22 08:10:03','2022-12-23 08:10:03','698',0.00,0.00,'698','2022-12-22 19:16:25','698','2022-12-22 19:17:06',10,0),('1','194',257988,'DAILY SHIFT','2022-12-23','2022-12-23 07:42:20','2022-12-24 07:42:20','698',0.00,0.00,'698','2022-12-23 11:27:16','698','2022-12-23 11:27:51',10,0),('1','194',257989,'DAILY SHIFT','2022-12-23','2022-12-23 11:31:09','2022-12-24 11:31:09','698',0.00,0.00,'698','2022-12-23 11:33:08','698','2022-12-23 11:33:31',10,0),('1','194',257990,'DAILY SHIFT','2022-12-24','2022-12-24 09:25:38','2022-12-25 09:25:38','698',0.00,0.00,'698','2022-12-24 19:30:46','698','2022-12-24 19:31:51',10,0),('1','194',257991,'DAILY SHIFT','2022-12-25','2022-12-25 09:46:02','2022-12-26 09:46:02','698',0.00,0.00,'698','2022-12-25 13:47:58','698','2022-12-25 13:48:26',10,0),('1','194',257992,'DAILY SHIFT','2022-12-25','2022-12-25 16:47:47','2022-12-26 16:47:47','698',0.00,0.00,'698','2022-12-25 16:50:40','698','2022-12-25 16:51:08',10,0),('1','194',257993,'DAILY SHIFT','2022-12-26','2022-12-26 07:10:21','2022-12-27 07:10:21','698',0.00,0.00,'698','2022-12-26 19:03:01','698','2022-12-26 19:03:28',10,0),('1','194',257994,'DAILY SHIFT','2022-12-27','2022-12-27 07:38:41','2022-12-28 07:38:41','698',0.00,0.00,'698','2022-12-27 21:09:34','698','2022-12-27 21:10:04',10,0),('1','194',257995,'DAILY SHIFT','2022-12-27','2022-12-27 21:33:08','2022-12-28 21:33:08','698',0.00,0.00,'698','2022-12-27 21:38:19','698','2022-12-27 21:38:51',10,0),('1','194',257996,'DAILY SHIFT','2022-12-28','2022-12-28 07:50:29','2022-12-29 07:50:29','698',0.00,0.00,'698','2022-12-28 19:22:02','698','2022-12-28 19:22:34',10,0),('1','194',257997,'DAILY SHIFT','2022-12-29','2022-12-29 07:47:39','2022-12-30 07:47:39','698',0.00,0.00,'698','2022-12-29 19:06:16','698','2022-12-29 19:06:47',10,0),('1','194',257998,'DAILY SHIFT','2022-12-30','2022-12-30 07:44:10','2022-12-31 07:44:10','698',0.00,0.00,'698','2022-12-30 19:50:00','698','2022-12-30 19:50:40',10,0),('1','194',257999,'DAILY SHIFT','2022-12-30','2022-12-30 19:51:18','2022-12-31 19:51:18','698',0.00,0.00,'698','2022-12-30 19:55:03','698','2022-12-30 19:55:30',10,0),('1','194',258000,'DAILY SHIFT','2022-12-31','2022-12-31 09:24:31','2023-01-01 09:24:31','698',0.00,0.00,'698','2022-12-31 20:35:25','698','2022-12-31 20:36:03',10,0),('1','194',258001,'DAILY SHIFT','2023-01-01','2023-01-01 09:51:28','2023-01-02 09:51:28','698',0.00,0.00,'698','2023-01-01 20:56:02','698','2023-01-01 20:56:27',10,0),('1','194',258002,'DAILY SHIFT','2023-01-02','2023-01-02 07:48:55','2023-01-03 07:48:55','698',0.00,0.00,'698','2023-01-02 13:08:37','698','2023-01-02 13:09:09',10,0),('1','194',258003,'DAILY SHIFT','2023-01-02','2023-01-02 13:09:47','2023-01-03 13:09:47','698',0.00,0.00,'698','2023-01-02 13:16:47','698','2023-01-02 13:18:03',10,0),('1','194',258004,'DAILY SHIFT','2023-01-02','2023-01-02 13:30:50','2023-01-03 13:30:50','698',0.00,0.00,'698','2023-01-02 18:36:56','698','2023-01-02 18:37:21',10,0),('1','194',258005,'DAILY SHIFT','2023-01-03','2023-01-03 07:48:50','2023-01-04 07:48:50','698',0.00,0.00,'698','2023-01-03 19:43:49','698','2023-01-03 19:44:24',10,0),('1','194',258006,'DAILY SHIFT','2023-01-04','2023-01-04 07:51:52','2023-01-05 07:51:52','698',0.00,0.00,'698','2023-01-04 20:31:11','698','2023-01-04 20:31:52',10,0),('1','194',258007,'DAILY SHIFT','2023-01-05','2023-01-05 07:34:15','2023-01-06 07:34:15','698',0.00,0.00,'698','2023-01-05 19:13:03','698','2023-01-05 19:13:30',10,0),('1','194',258008,'DAILY SHIFT','2023-01-06','2023-01-06 07:39:14','2023-01-07 07:39:14','698',0.00,0.00,'698','2023-01-06 12:16:47','698','2023-01-06 12:19:55',10,0),('1','194',258009,'DAILY SHIFT','2023-01-06','2023-01-06 12:20:47','2023-01-07 12:20:47','698',0.00,0.00,'698','2023-01-06 12:27:29','698','2023-01-06 12:28:08',10,0),('1','194',258010,'DAILY SHIFT','2023-01-06','2023-01-06 12:40:14','2023-01-07 12:40:14','698',0.00,0.00,'698','2023-01-06 20:36:25','698','2023-01-06 20:36:46',10,0),('1','194',258011,'DAILY SHIFT','2023-01-07','2023-01-07 07:36:54','2023-01-08 07:36:54','698',0.00,0.00,'698','2023-01-07 21:00:23','698','2023-01-07 21:00:49',10,0),('1','194',258012,'DAILY SHIFT','2023-01-08','2023-01-08 10:04:07','2023-01-09 10:04:07','698',0.00,0.00,'698','2023-01-08 19:18:15','698','2023-01-08 19:25:12',10,0),('1','194',258013,'DAILY SHIFT','2023-01-09','2023-01-09 07:44:10','2023-01-10 07:44:10','698',0.00,0.00,'698','2023-01-09 12:45:52','698','2023-01-09 12:46:17',10,0),('1','194',258014,'DAILY SHIFT','2023-01-09','2023-01-09 12:46:43','2023-01-10 12:46:43','698',0.00,0.00,'698','2023-01-09 12:52:34','698','2023-01-09 12:52:59',10,0),('1','194',258015,'DAILY SHIFT','2023-01-09','2023-01-09 12:53:47','2023-01-10 12:53:47','698',0.00,0.00,'698','2023-01-09 20:52:45','698','2023-01-09 20:53:50',10,0),('1','194',258016,'DAILY SHIFT','2023-01-10','2023-01-10 07:42:55','2023-01-11 07:42:55','698',0.00,0.00,'698','2023-01-10 19:31:42','698','2023-01-10 19:32:24',10,0),('1','194',258017,'DAILY SHIFT','2023-01-11','2023-01-11 07:33:32','2023-01-12 07:33:32','698',0.00,0.00,'698','2023-01-11 15:27:24','698','2023-01-11 15:28:12',10,0),('1','194',258018,'DAILY SHIFT','2023-01-11','2023-01-11 15:37:09','2023-01-12 15:37:09','698',0.00,0.00,'698','2023-01-11 15:40:50','698','2023-01-11 15:41:22',10,0),('1','194',258019,'DAILY SHIFT','2023-01-11','2023-01-11 15:56:57','2023-01-12 15:56:57','698',0.00,0.00,'698','2023-01-11 20:05:21','698','2023-01-11 20:05:47',10,0),('1','194',258020,'DAILY SHIFT','2023-01-12','2023-01-12 07:52:33','2023-01-13 07:52:33','698',0.00,0.00,'698','2023-01-12 20:37:17','698','2023-01-12 20:37:45',10,0),('1','194',258021,'DAILY SHIFT','2023-01-13','2023-01-13 07:39:30','2023-01-14 07:39:30','698',0.00,0.00,'698','2023-01-13 15:20:19','698','2023-01-13 15:20:48',10,0),('1','194',258022,'DAILY SHIFT','2023-01-13','2023-01-13 15:21:36','2023-01-14 15:21:36','698',0.00,0.00,'698','2023-01-13 15:25:49','698','2023-01-13 15:26:20',10,0),('1','194',258023,'DAILY SHIFT','2023-01-13','2023-01-13 15:29:43','2023-01-14 15:29:43','698',0.00,0.00,'698','2023-01-13 22:19:36','698','2023-01-13 22:20:08',10,0),('1','194',258024,'DAILY SHIFT','2023-01-14','2023-01-14 07:46:42','2023-01-15 07:46:42','698',0.00,0.00,'698','2023-01-14 20:30:50','698','2023-01-14 20:31:20',10,0),('1','194',258025,'DAILY SHIFT','2023-01-15','2023-01-15 10:02:27','2023-01-16 10:02:27','698',0.00,0.00,'698','2023-01-15 19:36:05','698','2023-01-15 19:36:45',10,0),('1','194',258026,'DAILY SHIFT','2023-01-16','2023-01-16 07:42:31','2023-01-17 07:42:31','698',0.00,0.00,'698','2023-01-16 10:52:09','698','2023-01-16 10:52:39',10,0),('1','194',258027,'DAILY SHIFT','2023-01-16','2023-01-16 10:53:20','2023-01-17 10:53:20','698',0.00,0.00,'698','2023-01-16 10:56:15','698','2023-01-16 10:57:15',10,0),('1','194',258028,'DAILY SHIFT','2023-01-16','2023-01-16 10:57:40','2023-01-17 10:57:40','698',0.00,0.00,'698','2023-01-16 20:00:20','698','2023-01-16 20:00:43',10,0),('1','194',258029,'DAILY SHIFT','2023-01-17','2023-01-17 07:43:49','2023-01-18 07:43:49','698',0.00,0.00,'698','2023-01-17 20:03:21','698','2023-01-17 20:03:50',10,0),('1','194',258030,'DAILY SHIFT','2023-01-18','2023-01-18 07:46:04','2023-01-19 07:46:04','698',0.00,0.00,'698','2023-01-18 19:35:48','698','2023-01-18 19:36:21',10,0),('1','194',258031,'DAILY SHIFT','2023-01-18','2023-01-18 19:37:43','2023-01-19 19:37:43','698',0.00,0.00,'698','2023-01-18 19:41:14','698','2023-01-18 19:41:40',10,0),('1','194',258032,'DAILY SHIFT','2023-01-19','2023-01-19 07:37:17','2023-01-20 07:37:17','698',0.00,0.00,'698','2023-01-19 20:29:06','698','2023-01-19 20:29:40',10,0),('1','194',258033,'DAILY SHIFT','2023-01-20','2023-01-20 07:45:57','2023-01-21 07:45:57','698',0.00,0.00,'698','2023-01-20 19:40:25','698','2023-01-20 19:41:29',10,0),('1','194',258034,'DAILY SHIFT','2023-01-20','2023-01-20 19:42:07','2023-01-21 19:42:07','698',0.00,0.00,'698','2023-01-20 19:44:47','698','2023-01-20 19:45:15',10,0),('1','194',258035,'DAILY SHIFT','2023-01-21','2023-01-21 07:29:33','2023-01-22 07:29:33','698',0.00,0.00,'698','2023-01-21 20:26:51','698','2023-01-21 20:27:33',10,0),('1','194',258036,'DAILY SHIFT','2023-01-22','2023-01-22 09:20:44','2023-01-23 09:20:44','698',0.00,0.00,'698','2023-01-22 18:01:14','698','2023-01-22 18:01:50',10,0),('1','194',258037,'DAILY SHIFT','2023-01-23','2023-01-23 07:18:15','2023-01-24 07:18:15','698',0.00,0.00,'698','2023-01-23 10:22:03','698','2023-01-23 10:22:35',10,0),('1','194',258038,'DAILY SHIFT','2023-01-23','2023-01-23 10:23:29','2023-01-24 10:23:29','698',0.00,0.00,'698','2023-01-23 10:28:30','698','2023-01-23 10:28:52',10,0),('1','194',258039,'DAILY SHIFT','2023-01-23','2023-01-23 11:34:55','2023-01-24 11:34:55','698',0.00,0.00,'698','2023-01-23 20:19:46','698','2023-01-23 20:20:20',10,0),('1','194',258040,'DAILY SHIFT','2023-01-24','2023-01-24 07:14:27','2023-01-25 07:14:27','698',0.00,0.00,'698','2023-01-24 20:18:59','698','2023-01-24 20:19:33',10,0),('1','194',258041,'DAILY SHIFT','2023-01-25','2023-01-25 06:52:23','2023-01-26 06:52:23','698',0.00,0.00,'698','2023-01-25 10:56:49','698','2023-01-25 10:57:32',10,0),('1','194',258042,'DAILY SHIFT','2023-01-25','2023-01-25 10:58:57','2023-01-26 10:58:57','698',0.00,0.00,'698','2023-01-25 11:04:12','698','2023-01-25 11:04:55',10,0),('1','194',258043,'DAILY SHIFT','2023-01-25','2023-01-25 11:32:22','2023-01-26 11:32:22','698',0.00,0.00,'698','2023-01-25 19:51:41','698','2023-01-25 19:52:36',10,0),('1','194',258044,'DAILY SHIFT','2023-01-26','2023-01-26 07:22:40','2023-01-27 07:22:40','698',0.00,0.00,'698','2023-01-26 21:39:35','698','2023-01-26 21:40:13',10,0),('1','194',258045,'DAILY SHIFT','2023-01-27','2023-01-27 07:22:38','2023-01-28 07:22:38','698',0.00,0.00,'698','2023-01-27 17:39:28','698','2023-01-27 17:40:24',10,0),('1','194',258046,'DAILY SHIFT','2023-01-27','2023-01-27 17:42:56','2023-01-28 17:42:56','698',0.00,0.00,'698','2023-01-27 17:46:44','698','2023-01-27 17:47:45',10,0),('1','194',258047,'DAILY SHIFT','2023-01-28','2023-01-28 10:02:30','2023-01-29 10:02:30','698',0.00,0.00,'698','2023-01-28 21:45:24','698','2023-01-28 21:47:08',10,0),('1','194',258048,'DAILY SHIFT','2023-01-29','2023-01-29 09:21:49','2023-01-30 09:21:49','698',0.00,0.00,'698','2023-01-29 19:32:08','698','2023-01-29 19:32:33',10,0),('1','194',258049,'DAILY SHIFT','2023-01-30','2023-01-30 07:34:00','2023-01-31 07:34:00','698',0.00,0.00,'698','2023-01-30 10:37:01','698','2023-01-30 10:38:19',10,0),('1','194',258050,'DAILY SHIFT','2023-01-30','2023-01-30 10:38:45','2023-01-31 10:38:45','698',0.00,0.00,'698','2023-01-30 10:44:56','698','2023-01-30 10:45:29',10,0),('1','194',258051,'DAILY SHIFT','2023-01-30','2023-01-30 11:03:07','2023-01-31 11:03:07','698',0.00,0.00,'698','2023-01-30 20:56:56','698','2023-01-30 20:57:24',10,0),('1','194',258052,'DAILY SHIFT','2023-01-31','2023-01-31 07:38:57','2023-02-01 07:38:57','698',0.00,0.00,'698','2023-01-31 21:18:17','698','2023-01-31 21:19:43',10,0),('1','194',258053,'DAILY SHIFT','2023-02-01','2023-02-01 07:44:27','2023-02-02 07:44:27','698',0.00,0.00,'698','2023-02-01 12:49:35','698','2023-02-01 12:50:31',10,0),('1','194',258054,'DAILY SHIFT','2023-02-01','2023-02-01 12:53:36','2023-02-02 12:53:36','698',0.00,0.00,'698','2023-02-01 12:59:07','698','2023-02-01 12:59:46',10,0),('1','194',258055,'DAILY SHIFT','2023-02-01','2023-02-01 13:09:44','2023-02-02 13:09:44','698',0.00,0.00,'698','2023-02-01 20:47:21','698','2023-02-01 20:49:02',10,0),('1','194',258056,'DAILY SHIFT','2023-02-02','2023-02-02 07:34:29','2023-02-03 07:34:29','698',0.00,0.00,'698','2023-02-02 20:04:17','698','2023-02-02 20:04:51',10,0),('1','194',258057,'DAILY SHIFT','2023-02-03','2023-02-03 07:47:12','2023-02-04 07:47:12','698',0.00,0.00,'698','2023-02-03 21:04:41','698','2023-02-03 21:05:09',10,0),('1','194',258058,'DAILY SHIFT','2023-02-04','2023-02-04 07:09:44','2023-02-05 07:09:44','698',0.00,0.00,'698','2023-02-04 11:01:50','698','2023-02-04 11:03:00',10,0),('1','194',258059,'DAILY SHIFT','2023-02-04','2023-02-04 11:05:11','2023-02-05 11:05:11','698',0.00,0.00,'698','2023-02-04 11:12:36','698','2023-02-04 11:13:03',10,0),('1','194',258060,'DAILY SHIFT','2023-02-04','2023-02-04 11:19:12','2023-02-05 11:19:12','698',0.00,0.00,'698','2023-02-05 04:11:24','698','2023-02-05 04:11:45',10,0),('1','194',258061,'DAILY SHIFT','2023-02-05','2023-02-05 09:08:35','2023-02-06 09:08:35','698',0.00,0.00,'698','2023-02-05 23:05:24','698','2023-02-05 23:06:16',10,0),('1','194',258062,'DAILY SHIFT','2023-02-06','2023-02-06 07:10:18','2023-02-07 07:10:18','698',0.00,0.00,'698','2023-02-06 14:21:30','698','2023-02-06 14:27:50',10,0),('1','194',258063,'DAILY SHIFT','2023-02-06','2023-02-06 15:11:33','2023-02-07 15:11:33','698',0.00,0.00,'698','2023-02-06 15:17:07','698','2023-02-06 15:17:36',10,0),('1','194',258064,'DAILY SHIFT','2023-02-06','2023-02-06 15:23:54','2023-02-07 15:23:54','698',0.00,0.00,'698','2023-02-06 21:38:35','698','2023-02-06 21:39:18',10,0),('1','194',258065,'DAILY SHIFT','2023-02-07','2023-02-07 07:46:48','2023-02-08 07:46:48','698',0.00,0.00,'698','2023-02-07 19:34:23','698','2023-02-07 19:37:23',10,0),('1','194',258066,'DAILY SHIFT','2023-02-08','2023-02-08 07:44:34','2023-02-09 07:44:34','698',0.00,0.00,'698','2023-02-08 20:32:22','698','2023-02-08 20:33:15',10,0),('1','194',258067,'DAILY SHIFT','2023-02-09','2023-02-09 07:34:11','2023-02-10 07:34:11','698',0.00,0.00,'698','2023-02-09 11:30:02','698','2023-02-09 11:31:07',10,0),('1','194',258068,'DAILY SHIFT','2023-02-09','2023-02-09 11:31:43','2023-02-10 11:31:43','698',0.00,0.00,'698','2023-02-09 11:34:11','698','2023-02-09 11:34:39',10,0),('1','194',258069,'DAILY SHIFT','2023-02-09','2023-02-09 12:19:38','2023-02-10 12:19:38','698',0.00,0.00,'698','2023-02-09 19:11:22','698','2023-02-09 19:15:25',10,0),('1','194',258070,'DAILY SHIFT','2023-02-10','2023-02-10 07:12:12','2023-02-11 07:12:12','698',0.00,0.00,'698','2023-02-10 20:20:54','698','2023-02-10 20:21:29',10,0),('1','194',258071,'DAILY SHIFT','2023-02-11','2023-02-11 07:39:00','2023-02-12 07:39:00','698',0.00,0.00,'698','2023-02-11 19:29:55','698','2023-02-11 19:31:08',10,0),('1','194',258072,'DAILY SHIFT','2023-02-12','2023-02-12 09:53:28','2023-02-13 09:53:28','698',0.00,0.00,'698','2023-02-12 13:40:22','698','2023-02-12 13:41:01',10,0),('1','194',258073,'DAILY SHIFT','2023-02-12','2023-02-12 13:42:16','2023-02-13 13:42:16','698',0.00,0.00,'698','2023-02-12 14:47:15','698','2023-02-12 14:47:55',10,0),('1','194',258074,'DAILY SHIFT','2023-02-12','2023-02-12 14:48:51','2023-02-13 14:48:51','698',0.00,0.00,'698','2023-02-12 19:09:03','698','2023-02-12 19:09:38',10,0),('1','194',258075,'DAILY SHIFT','2023-02-13','2023-02-13 08:48:18','2023-02-14 08:48:18','698',0.00,0.00,'698','2023-02-13 19:24:23','698','2023-02-13 19:25:25',10,0),('1','194',258076,'DAILY SHIFT','2023-02-14','2023-02-14 06:40:12','2023-02-15 06:40:12','698',0.00,0.00,'698','2023-02-14 10:49:31','698','2023-02-14 10:49:57',10,0),('1','194',258077,'DAILY SHIFT','2023-02-14','2023-02-14 10:51:38','2023-02-15 10:51:38','698',0.00,0.00,'698','2023-02-14 10:55:38','698','2023-02-14 10:56:08',10,0),('1','194',258078,'DAILY SHIFT','2023-02-15','2023-02-15 07:53:32','2023-02-16 07:53:32','698',0.00,0.00,'698','2023-02-15 19:38:19','698','2023-02-15 19:38:53',10,0),('1','194',258079,'DAILY SHIFT','2023-02-16','2023-02-16 07:52:07','2023-02-17 07:52:07','698',0.00,0.00,'698','2023-02-16 19:30:01','698','2023-02-16 19:31:17',10,0),('1','194',258080,'DAILY SHIFT','2023-02-17','2023-02-17 07:49:32','2023-02-18 07:49:32','698',0.00,0.00,'698','2023-02-17 19:38:07','698','2023-02-17 19:40:18',10,0),('1','194',258081,'DAILY SHIFT','2023-02-17','2023-02-17 19:57:48','2023-02-18 19:57:48','698',0.00,0.00,'698','2023-02-17 20:00:52','698','2023-02-17 20:01:22',10,0),('1','194',258082,'DAILY SHIFT','2023-02-18','2023-02-18 08:05:04','2023-02-19 08:05:04','698',0.00,0.00,'698','2023-02-18 19:54:25','698','2023-02-18 19:55:18',10,0),('1','194',258083,'DAILY SHIFT','2023-02-19','2023-02-19 09:57:53','2023-02-20 09:57:53','698',0.00,0.00,'698','2023-02-19 17:35:13','698','2023-02-19 17:35:53',10,0),('1','194',258084,'DAILY SHIFT','2023-02-20','2023-02-20 07:46:20','2023-02-21 07:46:20','698',0.00,0.00,'698','2023-02-20 09:36:48','698','2023-02-20 09:37:16',10,0),('1','194',258085,'DAILY SHIFT','2023-02-20','2023-02-20 09:38:04','2023-02-21 09:38:04','698',0.00,0.00,'698','2023-02-20 09:39:51','698','2023-02-20 09:40:15',10,0),('1','194',258086,'DAILY SHIFT','2023-02-20','2023-02-20 10:45:19','2023-02-21 10:45:19','698',0.00,0.00,'698','2023-02-20 20:31:37','698','2023-02-20 20:32:46',10,0),('1','194',258087,'DAILY SHIFT','2023-02-21','2023-02-21 07:33:00','2023-02-22 07:33:00','698',0.00,0.00,'698','2023-02-21 19:52:02','698','2023-02-21 19:53:13',10,0),('1','194',258088,'DAILY SHIFT','2023-02-22','2023-02-22 07:38:31','2023-02-23 07:38:31','698',0.00,0.00,'698','2023-02-22 10:05:59','698','2023-02-22 10:06:32',10,0),('1','194',258089,'DAILY SHIFT','2023-02-22','2023-02-22 10:08:09','2023-02-23 10:08:09','698',0.00,0.00,'698','2023-02-22 10:12:47','698','2023-02-22 10:13:32',10,0),('1','194',258090,'DAILY SHIFT','2023-02-22','2023-02-22 11:24:11','2023-02-23 11:24:11','698',0.00,0.00,'698','2023-02-22 20:38:29','698','2023-02-22 20:39:02',10,0),('1','194',258091,'DAILY SHIFT','2023-02-23','2023-02-23 07:44:45','2023-02-24 07:44:45','698',0.00,0.00,'698','2023-02-23 21:18:13','698','2023-02-23 21:18:39',10,0),('1','194',258092,'DAILY SHIFT','2023-02-24','2023-02-24 08:15:46','2023-02-25 08:15:46','698',0.00,0.00,'698','2023-02-24 09:33:39','698','2023-02-24 09:34:09',10,0),('1','194',258093,'DAILY SHIFT','2023-02-24','2023-02-24 09:34:52','2023-02-25 09:34:52','698',0.00,0.00,'698','2023-02-24 09:38:11','698','2023-02-24 09:38:33',10,0),('1','194',258094,'DAILY SHIFT','2023-02-24','2023-02-24 10:41:52','2023-02-25 10:41:52','698',0.00,0.00,'698','2023-02-24 22:22:49','698','2023-02-24 22:23:21',10,0),('1','194',258095,'DAILY SHIFT','2023-02-26','2023-02-26 09:57:41','2023-02-27 09:57:41','698',0.00,0.00,'698','2023-02-26 16:10:33','698','2023-02-26 16:11:53',10,0),('1','194',258096,'DAILY SHIFT','2023-02-26','2023-02-26 17:09:24','2023-02-27 17:09:24','698',0.00,0.00,'698','2023-02-26 17:13:26','698','2023-02-26 17:13:56',10,0),('1','194',258097,'DAILY SHIFT','2023-02-28','2023-02-28 07:40:31','2023-03-01 07:40:31','698',0.00,0.00,'698','2023-02-28 20:19:55','698','2023-02-28 20:20:29',10,0),('1','194',258098,'DAILY SHIFT','2023-03-01','2023-03-01 06:58:20','2023-03-02 06:58:20','698',0.00,0.00,'698','2023-03-01 19:50:48','698','2023-03-01 19:51:35',10,0),('1','194',258099,'DAILY SHIFT','2023-03-02','2023-03-02 09:09:20','2023-03-03 09:09:20','698',0.00,0.00,'698','2023-03-02 10:03:32','698','2023-03-02 10:04:04',10,0),('1','194',258100,'DAILY SHIFT','2023-03-02','2023-03-02 10:04:35','2023-03-03 10:04:35','698',0.00,0.00,'698','2023-03-02 10:07:59','698','2023-03-02 10:08:37',10,0),('1','194',258101,'DAILY SHIFT','2023-03-02','2023-03-02 15:12:01','2023-03-03 15:12:01','698',0.00,0.00,'698','2023-03-02 20:17:00','698','2023-03-02 20:17:26',10,0),('1','194',258102,'DAILY SHIFT','2023-03-03','2023-03-03 07:37:06','2023-03-04 07:37:06','698',0.00,0.00,'698','2023-03-03 20:04:31','698','2023-03-03 20:08:03',10,0),('1','194',258103,'DAILY SHIFT','2023-03-04','2023-03-04 07:46:07','2023-03-05 07:46:07','698',0.00,0.00,'698','2023-03-04 17:18:16','698','2023-03-04 17:19:39',10,0),('1','194',258104,'DAILY SHIFT','2023-03-04','2023-03-04 17:23:30','2023-03-05 17:23:30','698',0.00,0.00,'698','2023-03-04 17:38:51','698','2023-03-04 17:39:31',10,0),('1','194',258105,'DAILY SHIFT','2023-03-05','2023-03-05 12:12:23','2023-03-06 12:12:23','698',0.00,0.00,'698','2023-03-05 18:01:57','698','2023-03-05 18:02:29',10,0),('1','194',258106,'DAILY SHIFT','2023-03-06','2023-03-06 06:58:32','2023-03-07 06:58:32','698',0.00,0.00,'698','2023-03-06 21:09:26','698','2023-03-06 21:09:59',10,0),('1','194',258107,'DAILY SHIFT','2023-03-07','2023-03-07 07:05:13','2023-03-08 07:05:13','698',0.00,0.00,'698','2023-03-07 11:31:40','698','2023-03-07 11:32:08',10,0),('1','194',258108,'DAILY SHIFT','2023-03-07','2023-03-07 11:32:39','2023-03-08 11:32:39','698',0.00,0.00,'698','2023-03-07 11:39:49','698','2023-03-07 11:40:17',10,0),('1','194',258109,'DAILY SHIFT','2023-03-08','2023-03-08 12:53:04','2023-03-09 12:53:04','698',0.00,0.00,'698','2023-03-08 19:33:40','698','2023-03-08 19:37:48',10,0),('1','194',258110,'DAILY SHIFT','2023-03-09','2023-03-09 07:26:57','2023-03-10 07:26:57','698',0.00,0.00,'698','2023-03-09 19:25:59','698','2023-03-09 19:26:57',10,0),('1','194',258111,'DAILY SHIFT','2023-03-10','2023-03-10 07:35:32','2023-03-11 07:35:32','698',0.00,0.00,'698','2023-03-10 12:51:52','698','2023-03-10 12:52:27',10,0),('1','194',258112,'DAILY SHIFT','2023-03-10','2023-03-10 12:53:36','2023-03-11 12:53:36','698',0.00,0.00,'698','2023-03-10 12:57:50','698','2023-03-10 12:58:12',10,0),('1','194',258113,'DAILY SHIFT','2023-03-10','2023-03-10 13:01:12','2023-03-11 13:01:12','698',0.00,0.00,'698','2023-03-10 19:51:36','698','2023-03-10 19:52:01',10,0),('1','194',258114,'DAILY SHIFT','2023-03-11','2023-03-11 07:43:55','2023-03-12 07:43:55','698',0.00,0.00,'698','2023-03-11 19:31:04','698','2023-03-11 19:36:10',10,0),('1','194',258115,'DAILY SHIFT','2023-03-12','2023-03-12 09:43:57','2023-03-13 09:43:57','698',0.00,0.00,'698','2023-03-12 15:28:19','698','2023-03-12 15:28:46',10,0),('1','194',258116,'DAILY SHIFT','2023-03-12','2023-03-12 15:33:47','2023-03-13 15:33:47','698',0.00,0.00,'698','2023-03-12 15:37:48','698','2023-03-12 15:38:19',10,0),('1','194',258117,'DAILY SHIFT','2023-03-13','2023-03-13 07:18:26','2023-03-14 07:18:26','698',0.00,0.00,'698','2023-03-13 20:59:27','698','2023-03-13 21:00:44',10,0),('1','194',258118,'DAILY SHIFT','2023-03-14','2023-03-14 07:45:01','2023-03-15 07:45:01','698',0.00,0.00,'698','2023-03-14 19:29:58','698','2023-03-14 19:30:30',10,0),('1','194',258119,'DAILY SHIFT','2023-03-15','2023-03-15 07:19:48','2023-03-16 07:19:48','698',0.00,0.00,'698','2023-03-15 08:36:57','698','2023-03-15 08:38:30',10,0),('1','194',258120,'DAILY SHIFT','2023-03-15','2023-03-15 08:40:38','2023-03-16 08:40:38','698',0.00,0.00,'698','2023-03-15 08:43:59','698','2023-03-15 08:44:32',10,0),('1','194',258121,'DAILY SHIFT','2023-03-15','2023-03-15 10:08:27','2023-03-16 10:08:27','698',0.00,0.00,'698','2023-03-15 20:33:05','698','2023-03-15 20:58:11',10,0),('1','194',258122,'DAILY SHIFT','2023-03-16','2023-03-16 07:46:54','2023-03-17 07:46:54','698',0.00,0.00,'698','2023-03-16 20:03:27','698','2023-03-16 20:04:03',10,0),('1','194',258123,'DAILY SHIFT','2023-03-17','2023-03-17 07:47:12','2023-03-18 07:47:12','698',0.00,0.00,'698','2023-03-17 20:40:00','698','2023-03-17 20:40:35',10,0),('1','194',258124,'DAILY SHIFT','2023-03-17','2023-03-17 20:44:53','2023-03-18 20:44:53','698',0.00,0.00,'698','2023-03-17 20:55:01','698','2023-03-17 20:55:35',10,0),('1','194',258125,'DAILY SHIFT','2023-03-19','2023-03-19 09:30:50','2023-03-20 09:30:50','698',0.00,0.00,'698','2023-03-19 22:31:15','698','2023-03-19 22:31:50',10,0),('1','194',258126,'DAILY SHIFT','2023-03-20','2023-03-20 07:46:14','2023-03-21 07:46:14','698',0.00,0.00,'698','2023-03-20 15:23:19','698','2023-03-20 15:23:56',10,0),('1','194',258127,'DAILY SHIFT','2023-03-20','2023-03-20 15:31:48','2023-03-21 15:31:48','698',0.00,0.00,'698','2023-03-20 15:36:37','698','2023-03-20 15:37:08',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906309 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','194','1012','232225',4467131,'2993','460',0.00,465.90,0.00,0.00,465.90,258517.00,0.00,0.00,0.00),('1','194','1012','232246',4467447,'2993','460',465.90,1046.90,0.00,0.00,581.00,326230.00,0.00,0.00,0.00),('1','194','1012','232987',4480787,'2993','460',1046.90,3330.30,0.00,0.00,2283.40,1266654.00,0.00,0.00,0.00),('1','194','1012','232999',4480958,'2993','460',3330.30,6002.40,0.00,0.00,2672.10,1470203.00,0.00,0.00,0.00),('1','194','1012','233013',4481242,'2993','460',6002.40,8295.93,0.00,0.00,2293.53,1269373.90,0.00,0.00,0.00),('1','194','1012','233164',4483917,'2993','460',8295.93,14328.83,0.00,0.00,6032.90,3333897.00,0.00,0.00,0.00),('1','194','1012','233518',4490248,'2993','460',14328.83,19511.63,0.00,0.00,5182.80,2864004.00,0.00,0.00,0.00),('1','194','1012','233622',4492184,'2993','460',19511.63,24999.13,0.00,0.00,5487.50,3042805.00,0.00,0.00,0.00),('1','194','1012','234314',4504725,'2993','460',24999.13,29182.13,0.00,0.00,4183.00,2319930.00,0.00,0.00,0.00),('1','194','1012','234579',4509376,'2993','460',29182.13,34084.11,0.00,0.00,4901.98,2724847.40,0.00,0.00,0.00),('1','194','1012','234851',4514217,'2993','460',34084.11,37039.94,0.00,0.00,2955.83,1641852.90,0.00,0.00,0.00),('1','194','1012','235082',4518337,'2993','460',37039.94,41637.01,0.00,0.00,4597.07,2548154.10,0.00,0.00,0.00),('1','194','1012','235366',4523221,'2993','460',41637.01,42509.01,0.00,0.00,872.00,489440.00,0.00,0.00,0.00),('1','194','1012','235379',4523529,'2993','460',42509.01,42509.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','235380',4523530,'2993','460',42509.01,45969.66,0.00,0.00,3460.65,1929409.50,0.00,0.00,0.00),('1','194','1012','235546',4526404,'2993','460',45969.66,47687.62,0.00,0.00,1717.96,968474.80,0.00,0.00,0.00),('1','194','1012','235762',4530248,'2993','460',47687.62,56425.52,0.00,0.00,8737.90,4836156.00,0.00,0.00,0.00),('1','194','1012','236031',4534876,'2993','460',56425.52,61142.17,0.00,0.00,4716.65,2627809.50,0.00,0.00,0.00),('1','194','1012','236240',4538746,'2993','460',61142.17,66767.73,0.00,0.00,5625.56,3130382.80,0.00,0.00,0.00),('1','194','1012','236517',4543602,'2993','460',66767.73,67508.32,0.00,0.00,740.59,413771.70,0.00,0.00,0.00),('1','194','1012','236575',4544510,'2993','460',67508.32,67508.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','237716',4564763,'2993','460',67508.32,71737.53,0.00,0.00,4229.21,2472994.40,0.00,0.00,0.00),('1','194','1012','237720',4564874,'2993','460',71737.53,75495.83,0.00,0.00,3758.30,2213960.00,0.00,0.00,0.00),('1','194','1012','237724',4564900,'2993','460',75495.83,83311.73,0.00,0.00,7815.90,4565406.00,0.00,0.00,0.00),('1','194','1012','237734',4565011,'2993','460',83311.73,85692.25,0.00,0.00,2380.52,1408992.80,0.00,0.00,0.00),('1','194','1012','237738',4565068,'2993','460',85692.25,89705.04,0.00,0.00,4012.79,2330973.20,0.00,0.00,0.00),('1','194','1012','237876',4567197,'2993','460',89705.04,92505.36,0.00,0.00,2800.32,1642474.80,0.00,0.00,0.00),('1','194','1012','237996',4569108,'2993','460',92505.36,103682.89,0.00,0.00,11177.53,6608211.20,0.00,0.00,0.00),('1','194','1012','238126',4571161,'2993','460',103682.89,107885.98,0.00,0.00,4203.09,2496641.60,0.00,0.00,0.00),('1','194','1012','238356',4575258,'2993','460',107885.98,115384.96,0.00,0.00,7498.98,4434755.20,0.00,0.00,0.00),('1','194','1012','238603',4579340,'2993','460',115384.96,117507.33,0.00,0.00,2122.37,1259048.80,0.00,0.00,0.00),('1','194','1012','238692',4580995,'2993','460',117507.33,122792.34,0.00,0.00,5285.01,3129400.40,0.00,0.00,0.00),('1','194','1012','238841',4583518,'2993','460',122792.34,126874.18,0.00,0.00,4081.84,2422081.60,0.00,0.00,0.00),('1','194','1012','239064',4587577,'2993','460',126874.18,136336.53,0.00,0.00,9462.35,5603868.00,0.00,0.00,0.00),('1','194','1012','239293',4591516,'2993','460',136336.53,140669.88,0.00,0.00,4333.35,2569400.00,0.00,0.00,0.00),('1','194','1012','239535',4595591,'2993','460',140669.88,142507.33,0.00,0.00,1837.45,1088853.45,0.00,0.00,0.00),('1','194','1012','239596',4596736,'2993','460',142507.33,149039.45,0.00,0.00,6532.12,3863772.80,0.00,0.00,0.00),('1','194','1012','239773',4599714,'2993','460',149039.45,156544.73,0.00,0.00,7505.28,4450746.40,0.00,0.00,0.00),('1','194','1012','240003',4603676,'2993','460',156544.73,164626.11,0.00,0.00,8081.38,4784839.20,0.00,0.00,0.00),('1','194','1012','240202',4607296,'2993','460',164626.11,167507.33,0.00,0.00,2881.22,1703268.80,0.00,0.00,0.00),('1','194','1012','240274',4608624,'2993','460',167507.33,173407.43,0.00,0.00,5900.10,3498477.60,0.00,0.00,0.00),('1','194','1012','240461',4611390,'2993','460',173407.43,177330.36,0.00,0.00,3922.93,2335331.20,0.00,0.00,0.00),('1','194','1012','240700',4615110,'2993','460',177330.36,186681.46,0.00,0.00,9351.10,5546318.00,0.00,0.00,0.00),('1','194','1012','240978',4620022,'2993','460',186681.46,189996.12,0.00,0.00,3314.66,1965918.00,0.00,0.00,0.00),('1','194','1012','241802',4634409,'2993','460',189996.12,192507.33,0.00,0.00,2511.21,1504398.64,0.00,0.00,0.00),('1','194','1012','242004',4637767,'2993','460',192507.33,195676.63,0.00,0.00,3169.30,1907571.52,0.00,0.00,0.00),('1','194','1012','242216',4641688,'2993','460',195676.63,197714.48,0.00,0.00,2037.85,1229685.76,0.00,0.00,0.00),('1','194','1012','242445',4645614,'2993','460',197714.48,202572.24,0.00,0.00,4857.76,2913383.20,0.00,0.00,0.00),('1','194','1012','242687',4649913,'2993','460',202572.24,207454.90,0.00,0.00,4882.66,2926086.40,0.00,0.00,0.00),('1','194','1012','242932',4654029,'2993','460',207454.90,211646.54,0.00,0.00,4191.64,2511577.60,0.00,0.00,0.00),('1','194','1012','243148',4657790,'2993','460',211646.54,215029.12,0.00,0.00,3382.58,2031027.20,0.00,0.00,0.00),('1','194','1012','243374',4661926,'2993','460',215029.12,217507.33,0.00,0.00,2478.21,1476809.76,0.00,0.00,0.00),('1','194','1012','243453',4663354,'2993','460',217507.33,220808.45,0.00,0.00,3301.12,1963400.36,0.00,0.00,0.00),('1','194','1012','243604',4665818,'2993','460',220808.45,225889.42,0.00,0.00,5080.97,3042523.40,0.00,0.00,0.00),('1','194','1012','243838',4669948,'2993','460',225889.42,228817.43,0.00,0.00,2928.01,1760384.40,0.00,0.00,0.00),('1','194','1012','244059',4673768,'2993','460',228817.43,232852.08,0.00,0.00,4034.65,2425497.10,0.00,0.00,0.00),('1','194','1012','244300',4677822,'2993','460',232852.08,236030.77,0.00,0.00,3178.69,1903968.70,0.00,0.00,0.00),('1','194','1012','244523',4681742,'2993','460',236030.77,239087.36,0.00,0.00,3056.59,1852984.60,0.00,0.00,0.00),('1','194','1012','244756',4685611,'2993','460',239087.36,242051.51,0.00,0.00,2964.15,1758148.00,0.00,0.00,0.00),('1','194','1012','245001',4689924,'2993','460',242051.51,242507.33,0.00,0.00,455.82,271284.80,0.00,0.00,0.00),('1','194','1012','245026',4690286,'2993','460',242507.33,245242.07,0.00,0.00,2734.74,1616877.80,0.00,0.00,0.00),('1','194','1012','245224',4693907,'2993','460',245242.07,250011.92,0.00,0.00,4769.85,2832604.00,0.00,0.00,0.00),('1','194','1012','245449',4697785,'2993','460',250011.92,252921.84,0.00,0.00,2909.92,1726483.86,0.00,0.00,0.00),('1','194','1012','245684',4701933,'2993','460',252921.84,256489.60,0.00,0.00,3567.76,2130619.40,0.00,0.00,0.00),('1','194','1012','246859',4721741,'2993','460',256489.60,257596.15,0.00,0.00,1106.55,678962.10,0.00,0.00,0.00),('1','194','1012','246948',4723133,'2993','460',257596.15,261367.69,0.00,0.00,3771.54,2196435.60,0.00,0.00,0.00),('1','194','1012','247183',4727044,'2993','460',261367.69,263086.36,0.00,0.00,1718.67,1000996.80,0.00,0.00,0.00),('1','194','1012','247750',4736998,'2993','460',263086.36,265498.09,0.00,0.00,2411.73,1372405.20,0.00,0.00,0.00),('1','194','1012','247916',4739679,'2993','460',265498.09,268324.94,0.00,0.00,2826.85,1674448.00,0.00,0.00,0.00),('1','194','1012','248162',4743881,'2993','460',268324.94,271507.98,0.00,0.00,3183.04,1872799.60,0.00,0.00,0.00),('1','194','1012','248409',4748068,'2993','460',271507.98,276458.29,0.00,0.00,4950.31,2886638.80,0.00,0.00,0.00),('1','194','1012','248647',4752039,'2993','460',276458.29,287846.11,0.00,0.00,11387.82,6447398.40,0.00,0.00,0.00),('1','194','1012','248950',4757098,'2993','460',287846.11,292487.33,0.00,0.00,4641.22,2493163.54,0.00,0.00,0.00),('1','194','1012','249137',4760143,'2993','460',292487.33,296844.89,0.00,0.00,4357.56,2364960.22,0.00,0.00,0.00),('1','194','1012','249350',4763997,'2993','460',296844.89,298638.34,0.00,0.00,1793.45,977832.68,0.00,0.00,0.00),('1','194','1012','249605',4768249,'2993','460',298638.34,301174.42,0.00,0.00,2536.08,1373515.36,0.00,0.00,0.00),('1','194','1012','249875',4772752,'2993','460',301174.42,303668.57,0.00,0.00,2494.15,1359418.80,0.00,0.00,0.00),('1','194','1012','250127',4776880,'2993','460',303668.57,306573.59,0.00,0.00,2905.02,1593229.84,0.00,0.00,0.00),('1','194','1012','250353',4780830,'2993','460',306573.59,312438.05,0.00,0.00,5864.46,3148166.32,0.00,0.00,0.00),('1','194','1012','250598',4784836,'2993','460',312438.05,314460.20,0.00,0.00,2022.15,1099834.80,0.00,0.00,0.00),('1','194','1012','250814',4788650,'2993','460',314460.20,317407.33,0.00,0.00,2947.13,1598987.60,0.00,0.00,0.00),('1','194','1012','251047',4792839,'2993','460',317407.33,319623.41,0.00,0.00,2216.08,1208333.68,0.00,0.00,0.00),('1','194','1012','251290',4796982,'2993','460',319623.41,322053.89,0.00,0.00,2430.48,1306292.16,0.00,0.00,0.00),('1','194','1012','251533',4801089,'2993','460',322053.89,324169.52,0.00,0.00,2115.63,1148916.96,0.00,0.00,0.00),('1','194','1012','251778',4805532,'2993','460',324169.52,327001.89,0.00,0.00,2832.37,1525319.68,0.00,0.00,0.00),('1','194','1012','252020',4809641,'2993','460',327001.89,329255.30,0.00,0.00,2253.41,1231634.72,0.00,0.00,0.00),('1','194','1012','252294',4814327,'2993','460',329255.30,330947.76,0.00,0.00,1692.46,917964.16,0.00,0.00,0.00),('1','194','1012','252496',4818124,'2993','460',330947.76,334549.72,0.00,0.00,3601.96,1951460.32,0.00,0.00,0.00),('1','194','1012','252756',4822515,'2993','460',334549.72,336748.20,0.00,0.00,2198.48,1205596.16,0.00,0.00,0.00),('1','194','1012','253008',4826570,'2993','460',336748.20,338550.09,0.00,0.00,1801.89,984998.88,0.00,0.00,0.00),('1','194','1012','253221',4830344,'2993','460',338550.09,340876.43,0.00,0.00,2326.34,1263325.28,0.00,0.00,0.00),('1','194','1012','253486',4834864,'2993','460',340876.43,342347.33,0.00,0.00,1470.90,812752.80,0.00,0.00,0.00),('1','194','1012','253725',4838840,'2993','460',342347.33,346433.50,0.00,0.00,4086.17,2215066.88,0.00,0.00,0.00),('1','194','1012','254008',4843741,'2993','460',346433.50,348474.72,0.00,0.00,2041.22,1126449.68,0.00,0.00,0.00),('1','194','1012','254220',4847664,'2993','460',348474.72,351862.54,0.00,0.00,3387.82,1855671.04,0.00,0.00,0.00),('1','194','1012','254459',4851782,'2993','460',351862.54,354385.66,0.00,0.00,2523.12,1389215.04,0.00,0.00,0.00),('1','194','1012','254702',4856115,'2993','460',354385.66,357068.94,0.00,0.00,2683.28,1481761.76,0.00,0.00,0.00),('1','194','1012','254966',4860512,'2993','460',357068.94,359210.35,0.00,0.00,2141.41,1188514.72,0.00,0.00,0.00),('1','194','1012','255198',4864547,'2993','460',359210.35,361528.47,0.00,0.00,2318.12,1223439.68,0.00,0.00,0.00),('1','194','1012','255508',4869654,'2993','460',361528.47,365024.68,0.00,0.00,3496.21,1906010.32,0.00,0.00,0.00),('1','194','1012','255751',4873720,'2993','460',365024.68,367182.60,0.00,0.00,2157.92,1167931.64,0.00,0.00,0.00),('1','194','1012','255964',4877239,'2993','460',367182.60,367347.33,0.00,0.00,164.73,90120.16,0.00,0.00,0.00),('1','194','1012','256047',4878798,'2993','460',367347.33,376569.59,0.00,0.00,9222.26,4843485.78,0.00,0.00,0.00),('1','194','1012','256157',4880683,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256163',4880778,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256170',4880892,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256171',4880893,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256172',4880894,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256175',4880929,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256176',4880930,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256177',4880931,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256178',4880932,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256180',4880939,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256181',4880940,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256182',4880941,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256184',4880966,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256186',4880990,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256187',4880991,'2993','460',376569.59,376569.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256228',4881434,'2993','460',376569.59,380543.74,0.00,0.00,3974.15,2132324.80,0.00,0.00,0.00),('1','194','1012','256493',4886101,'2993','460',380543.74,385997.34,0.00,0.00,5453.60,2874083.00,0.00,0.00,0.00),('1','194','1012','256669',4889222,'2993','460',385997.34,385997.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','256986',4894379,'2993','460',385997.34,394223.02,0.00,0.00,8225.68,4289676.20,0.00,0.00,0.00),('1','194','1012','257309',4900253,'2993','460',394223.02,398744.93,0.00,0.00,4521.91,2403990.72,0.00,0.00,0.00),('1','194','1012','257542',4904183,'2993','460',398744.93,401870.10,0.00,0.00,3125.17,1681528.64,0.00,0.00,0.00),('1','194','1012','257543',4904184,'2993','460',401870.10,407105.07,0.00,0.00,5234.97,2820377.24,0.00,0.00,0.00),('1','194','1012','257544',4904185,'2993','460',407105.07,408597.95,0.00,0.00,1492.88,828950.96,0.00,0.00,0.00),('1','194','1012','257545',4904186,'2993','460',408597.95,410603.91,0.00,0.00,2005.96,1064318.32,0.00,0.00,0.00),('1','194','1012','257546',4904187,'2993','460',410603.91,410603.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257547',4904188,'2993','460',410603.91,414782.55,0.00,0.00,4178.64,2220988.90,0.00,0.00,0.00),('1','194','1012','257548',4904189,'2993','460',414782.55,416910.70,0.00,0.00,2128.15,1172507.80,0.00,0.00,0.00),('1','194','1012','257549',4904190,'2993','460',416910.70,421155.99,0.00,0.00,4245.29,2270619.68,0.00,0.00,0.00),('1','194','1012','257550',4904191,'2993','460',421155.99,423765.06,0.00,0.00,2609.07,1424488.68,0.00,0.00,0.00),('1','194','1012','257551',4904192,'2993','460',423765.06,428253.68,0.00,0.00,4488.62,2409351.04,0.00,0.00,0.00),('1','194','1012','257552',4904193,'2993','460',428253.68,431351.11,0.00,0.00,3097.43,1675370.56,0.00,0.00,0.00),('1','194','1012','257553',4904194,'2993','460',431351.11,434301.97,0.00,0.00,2950.86,1560712.16,0.00,0.00,0.00),('1','194','1012','257554',4904195,'2993','460',434301.97,435237.05,0.00,0.00,935.08,488587.36,0.00,0.00,0.00),('1','194','1012','257555',4904196,'2993','460',435237.05,435237.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257556',4904197,'2993','460',435237.05,438698.63,0.00,0.00,3461.58,1826871.36,0.00,0.00,0.00),('1','194','1012','257557',4904198,'2993','460',438698.63,441216.43,0.00,0.00,2517.80,1333096.78,0.00,0.00,0.00),('1','194','1012','257558',4904199,'2993','460',441216.43,447665.13,0.00,0.00,6448.70,3369976.00,0.00,0.00,0.00),('1','194','1012','257559',4904200,'2993','460',447665.13,452081.21,0.00,0.00,4416.08,2324683.06,0.00,0.00,0.00),('1','194','1012','257560',4904201,'2993','460',452081.21,457347.81,0.00,0.00,5266.60,2761493.74,0.00,0.00,0.00),('1','194','1012','257561',4904202,'2993','460',457347.81,458650.48,0.00,0.00,1302.67,670730.64,0.00,0.00,0.00),('1','194','1012','257562',4904203,'2993','460',458650.48,459806.48,0.00,0.00,1156.00,602352.00,0.00,0.00,0.00),('1','194','1012','257563',4904204,'2993','460',459806.48,459806.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257564',4904205,'2993','460',459806.48,460416.61,0.00,0.00,610.13,320688.96,0.00,0.00,0.00),('1','194','1012','257565',4904206,'2993','460',460416.61,467168.11,0.00,0.00,6751.50,3520960.00,0.00,0.00,0.00),('1','194','1012','257566',4904207,'2993','460',467168.11,472294.17,0.00,0.00,5126.06,2659731.72,0.00,0.00,0.00),('1','194','1012','257567',4904208,'2993','460',472294.17,482792.13,0.00,0.00,10497.96,5416604.32,0.00,0.00,0.00),('1','194','1012','257568',4904209,'2993','460',482792.13,484278.74,0.00,0.00,1486.61,782575.12,0.00,0.00,0.00),('1','194','1012','257569',4904210,'2993','460',484278.74,484278.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257570',4904211,'2993','460',484278.74,486545.79,0.00,0.00,2267.05,1195785.80,0.00,0.00,0.00),('1','194','1012','257571',4904212,'2993','460',486545.79,489328.66,0.00,0.00,2782.87,1500970.92,0.00,0.00,0.00),('1','194','1012','257572',4904213,'2993','460',489328.66,494484.71,0.00,0.00,5156.05,2709198.98,0.00,0.00,0.00),('1','194','1012','257573',4904214,'2993','460',494484.71,499339.02,0.00,0.00,4854.31,2567214.76,0.00,0.00,0.00),('1','194','1012','257574',4904215,'2993','460',499339.02,503141.46,0.00,0.00,3802.44,2014942.24,0.00,0.00,0.00),('1','194','1012','257575',4904216,'2993','460',503141.46,508773.24,0.00,0.00,5631.78,2943543.88,0.00,0.00,0.00),('1','194','1012','257576',4904217,'2993','460',508773.24,508773.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257577',4904218,'2993','460',508773.24,510605.16,0.00,0.00,1831.92,973355.32,0.00,0.00,0.00),('1','194','1012','257578',4904219,'2993','460',510605.16,519868.95,0.00,0.00,9263.79,4856921.84,0.00,0.00,0.00),('1','194','1012','257579',4904220,'2993','460',519868.95,524900.24,0.00,0.00,5031.29,2710431.84,0.00,0.00,0.00),('1','194','1012','257580',4904221,'2993','460',524900.24,530830.17,0.00,0.00,5929.93,3189121.74,0.00,0.00,0.00),('1','194','1012','257581',4904222,'2993','460',530830.17,533386.54,0.00,0.00,2556.37,1371136.52,0.00,0.00,0.00),('1','194','1012','257582',4904223,'2993','460',533386.54,533386.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257583',4904224,'2993','460',533386.54,536736.65,0.00,0.00,3350.11,1800213.56,0.00,0.00,0.00),('1','194','1012','257584',4904225,'2993','460',536736.65,545743.68,0.00,0.00,9007.03,4842337.88,0.00,0.00,0.00),('1','194','1012','257585',4904226,'2993','460',545743.68,549799.60,0.00,0.00,4055.92,2200451.00,0.00,0.00,0.00),('1','194','1012','257586',4904227,'2993','460',549799.60,555065.03,0.00,0.00,5265.43,2837886.28,0.00,0.00,0.00),('1','194','1012','257587',4904228,'2993','460',555065.03,557713.38,0.00,0.00,2648.35,1417460.60,0.00,0.00,0.00),('1','194','1012','257588',4904229,'2993','460',557713.38,557713.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257589',4904230,'2993','460',557713.38,562554.19,0.00,0.00,4840.81,2812442.20,0.00,0.00,0.00),('1','194','1012','257590',4904231,'2993','460',562554.19,572360.97,0.00,0.00,9806.78,5726827.60,0.00,0.00,0.00),('1','194','1012','257591',4904232,'2993','460',572360.97,576596.76,0.00,0.00,4235.79,2488053.80,0.00,0.00,0.00),('1','194','1012','257592',4904233,'2993','460',576596.76,582019.54,0.00,0.00,5422.78,3159603.60,0.00,0.00,0.00),('1','194','1012','257593',4904234,'2993','460',582019.54,582019.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257594',4904235,'2993','460',582019.54,583328.06,0.00,0.00,1308.52,818113.00,0.00,0.00,0.00),('1','194','1012','257595',4904236,'2993','460',583328.06,587161.38,0.00,0.00,3833.32,2351078.00,0.00,0.00,0.00),('1','194','1012','257596',4904237,'2993','460',587161.38,589630.76,0.00,0.00,2469.38,1518967.00,0.00,0.00,0.00),('1','194','1012','257597',4904238,'2993','460',589630.76,593560.51,0.00,0.00,3929.75,2384682.50,0.00,0.00,0.00),('1','194','1012','257598',4904239,'2993','460',593560.51,597498.77,0.00,0.00,3938.26,2353680.40,0.00,0.00,0.00),('1','194','1012','257599',4904240,'2993','460',597498.77,603024.17,0.00,0.00,5525.40,3296783.82,0.00,0.00,0.00),('1','194','1012','257600',4904241,'2993','460',603024.17,606544.78,0.00,0.00,3520.61,2091039.20,0.00,0.00,0.00),('1','194','1012','257601',4904242,'2993','460',606544.78,606544.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257602',4904243,'2993','460',606544.78,613826.89,0.00,0.00,7282.11,4334724.66,0.00,0.00,0.00),('1','194','1012','257603',4904244,'2993','460',613826.89,619632.67,0.00,0.00,5805.78,3445737.00,0.00,0.00,0.00),('1','194','1012','257604',4904245,'2993','460',619632.67,626115.03,0.00,0.00,6482.36,3830311.82,0.00,0.00,0.00),('1','194','1012','257605',4904246,'2993','460',626115.03,631197.08,0.00,0.00,5082.05,2990288.00,0.00,0.00,0.00),('1','194','1012','257606',4904247,'2993','460',631197.08,631197.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257607',4904248,'2993','460',631197.08,638526.08,0.00,0.00,7329.00,4337785.02,0.00,0.00,0.00),('1','194','1012','257608',4904249,'2993','460',638526.08,650410.49,0.00,0.00,11884.41,6996053.34,0.00,0.00,0.00),('1','194','1012','257609',4904250,'2993','460',650410.49,653377.60,0.00,0.00,2967.11,1757659.40,0.00,0.00,0.00),('1','194','1012','257610',4904251,'2993','460',653377.60,655847.56,0.00,0.00,2469.96,1454954.40,0.00,0.00,0.00),('1','194','1012','257611',4904252,'2993','460',655847.56,655847.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257612',4904253,'2993','460',655847.56,658816.47,0.00,0.00,2968.91,1868630.60,0.00,0.00,0.00),('1','194','1012','257613',4904254,'2993','460',658816.47,664418.43,0.00,0.00,5601.96,3449620.10,0.00,0.00,0.00),('1','194','1012','257614',4904255,'2993','460',664418.43,670448.28,0.00,0.00,6029.85,3709973.00,0.00,0.00,0.00),('1','194','1012','257615',4904256,'2993','460',670448.28,674338.20,0.00,0.00,3889.92,2411122.20,0.00,0.00,0.00),('1','194','1012','257616',4904257,'2993','460',674338.20,676793.40,0.00,0.00,2455.20,1542618.00,0.00,0.00,0.00),('1','194','1012','257617',4904258,'2993','460',676793.40,680461.40,0.00,0.00,3668.00,2279299.00,0.00,0.00,0.00),('1','194','1012','257618',4904259,'2993','460',680461.40,680461.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257619',4904260,'2993','460',680461.40,682426.06,0.00,0.00,1964.66,1188285.60,0.00,0.00,0.00),('1','194','1012','257620',4904261,'2993','460',682426.06,684950.28,0.00,0.00,2524.22,1550914.20,0.00,0.00,0.00),('1','194','1012','257621',4904262,'2993','460',684950.28,689976.25,0.00,0.00,5025.97,3096470.40,0.00,0.00,0.00),('1','194','1012','257622',4904263,'2993','460',689976.25,693385.65,0.00,0.00,3409.40,2091894.00,0.00,0.00,0.00),('1','194','1012','257623',4904264,'2993','460',693385.65,696144.81,0.00,0.00,2759.16,1705219.80,0.00,0.00,0.00),('1','194','1012','257624',4904265,'2993','460',696144.81,700178.22,0.00,0.00,4033.41,2477070.60,0.00,0.00,0.00),('1','194','1012','257625',4904266,'2993','460',700178.22,701865.29,0.00,0.00,1687.07,1030906.20,0.00,0.00,0.00),('1','194','1012','257626',4904267,'2993','460',701865.29,705073.61,0.00,0.00,3208.32,1963321.20,0.00,0.00,0.00),('1','194','1012','257627',4904268,'2993','460',705073.61,705073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257628',4904269,'2993','460',705073.61,711779.39,0.00,0.00,6705.78,4084294.80,0.00,0.00,0.00),('1','194','1012','257629',4904270,'2993','460',711779.39,714507.52,0.00,0.00,2728.13,1675735.80,0.00,0.00,0.00),('1','194','1012','257630',4904271,'2993','460',714507.52,718272.21,0.00,0.00,3764.69,2310905.40,0.00,0.00,0.00),('1','194','1012','257631',4904272,'2993','460',718272.21,721478.71,0.00,0.00,3206.50,1959540.00,0.00,0.00,0.00),('1','194','1012','257632',4904273,'2993','460',721478.71,725533.98,0.00,0.00,4055.27,2518738.20,0.00,0.00,0.00),('1','194','1012','257633',4904274,'2993','460',725533.98,729307.86,0.00,0.00,3773.88,2338401.00,0.00,0.00,0.00),('1','194','1012','257634',4904275,'2993','460',729307.86,729307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257635',4904276,'2993','460',729307.86,729307.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257636',4904277,'2993','460',729307.86,733174.77,0.00,0.00,3866.91,2370210.60,0.00,0.00,0.00),('1','194','1012','257637',4904278,'2993','460',733174.77,737276.53,0.00,0.00,4101.76,2507741.60,0.00,0.00,0.00),('1','194','1012','257638',4904279,'2993','460',737276.53,743417.06,0.00,0.00,6140.53,3677724.80,0.00,0.00,0.00),('1','194','1012','257639',4904280,'2993','460',743417.06,750965.70,0.00,0.00,7548.64,4511024.80,0.00,0.00,0.00),('1','194','1012','257640',4904281,'2993','460',750965.70,753962.85,0.00,0.00,2997.15,1803329.00,0.00,0.00,0.00),('1','194','1012','257641',4904282,'2993','460',753962.85,753962.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257642',4904283,'2993','460',753962.85,760603.01,0.00,0.00,6640.16,3959895.60,0.00,0.00,0.00),('1','194','1012','257643',4904284,'2993','460',760603.01,767267.19,0.00,0.00,6664.18,3993538.80,0.00,0.00,0.00),('1','194','1012','257644',4904285,'2993','460',767267.19,771290.77,0.00,0.00,4023.58,2433102.80,0.00,0.00,0.00),('1','194','1012','257645',4904286,'2993','460',771290.77,778609.97,0.00,0.00,7319.20,4374377.00,0.00,0.00,0.00),('1','194','1012','257646',4904287,'2993','460',778609.97,778609.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257647',4904288,'2993','460',778609.97,780520.65,0.00,0.00,1910.68,1141882.80,0.00,0.00,0.00),('1','194','1012','257648',4904289,'2993','460',780520.65,791696.95,0.00,0.00,11176.30,6632703.00,0.00,0.00,0.00),('1','194','1012','257649',4904290,'2993','460',791696.95,799423.46,0.00,0.00,7726.51,4586251.60,0.00,0.00,0.00),('1','194','1012','257650',4904291,'2993','460',799423.46,799977.24,0.00,0.00,553.78,338054.80,0.00,0.00,0.00),('1','194','1012','257651',4904292,'2993','460',799977.24,803225.28,0.00,0.00,3248.04,1953271.40,0.00,0.00,0.00),('1','194','1012','257652',4904293,'2993','460',803225.28,803225.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257653',4904294,'2993','460',803225.28,810423.77,0.00,0.00,7198.49,4270197.40,0.00,0.00,0.00),('1','194','1012','257654',4904295,'2993','460',810423.77,821587.82,0.00,0.00,11164.05,6629868.00,0.00,0.00,0.00),('1','194','1012','257655',4904296,'2993','460',821587.82,825112.96,0.00,0.00,3525.14,2103397.40,0.00,0.00,0.00),('1','194','1012','257656',4904297,'2993','460',825112.96,827802.81,0.00,0.00,2689.85,1625256.00,0.00,0.00,0.00),('1','194','1012','257657',4904298,'2993','460',827802.81,827802.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257658',4904299,'2993','460',827802.81,831472.28,0.00,0.00,3669.47,2205133.20,0.00,0.00,0.00),('1','194','1012','257659',4904300,'2993','460',831472.28,837764.48,0.00,0.00,6292.20,3782237.00,0.00,0.00,0.00),('1','194','1012','257660',4904301,'2993','460',837764.48,843133.38,0.00,0.00,5368.90,3249797.00,0.00,0.00,0.00),('1','194','1012','257661',4904302,'2993','460',843133.38,848912.44,0.00,0.00,5779.06,3466953.60,0.00,0.00,0.00),('1','194','1012','257662',4904303,'2993','460',848912.44,852168.27,0.00,0.00,3255.83,1934542.80,0.00,0.00,0.00),('1','194','1012','257663',4904304,'2993','460',852168.27,852168.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257664',4904305,'2993','460',852168.27,853637.22,0.00,0.00,1468.95,911897.00,0.00,0.00,0.00),('1','194','1012','257665',4904306,'2993','460',853637.22,858955.07,0.00,0.00,5317.85,3201866.00,0.00,0.00,0.00),('1','194','1012','257666',4904307,'2993','460',858955.07,865111.07,0.00,0.00,6156.00,3698744.40,0.00,0.00,0.00),('1','194','1012','257667',4904308,'2993','460',865111.07,870093.62,0.00,0.00,4982.55,3003688.00,0.00,0.00,0.00),('1','194','1012','257668',4904309,'2993','460',870093.62,873744.24,0.00,0.00,3650.62,2197869.20,0.00,0.00,0.00),('1','194','1012','257669',4904310,'2993','460',873744.24,876679.78,0.00,0.00,2935.54,1847942.10,0.00,0.00,0.00),('1','194','1012','257670',4904311,'2993','460',876679.78,876679.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257671',4904312,'2993','460',876679.78,881495.96,0.00,0.00,4816.18,3025232.38,0.00,0.00,0.00),('1','194','1012','257672',4904313,'2993','460',881495.96,889059.31,0.00,0.00,7563.35,4752633.35,0.00,0.00,0.00),('1','194','1012','257673',4904314,'2993','460',889059.31,894065.75,0.00,0.00,5006.44,3172059.80,0.00,0.00,0.00),('1','194','1012','257674',4904315,'2993','460',894065.75,896565.75,0.00,0.00,2500.00,1552500.00,0.00,0.00,0.00),('1','194','1012','257675',4904316,'2993','460',896565.75,898577.18,0.00,0.00,2011.43,1261036.95,0.00,0.00,0.00),('1','194','1012','257676',4904317,'2993','460',898577.18,901280.64,0.00,0.00,2703.46,1740892.80,0.00,0.00,0.00),('1','194','1012','257677',4904318,'2993','460',901280.64,909229.15,0.00,0.00,7948.51,5106166.80,0.00,0.00,0.00),('1','194','1012','257678',4904319,'2993','460',909229.15,922902.11,0.00,0.00,13672.96,8766432.00,0.00,0.00,0.00),('1','194','1012','257679',4904320,'2993','460',922902.11,922902.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257680',4904321,'2993','460',922902.11,925220.64,0.00,0.00,2318.53,1521937.46,0.00,0.00,0.00),('1','194','1012','257681',4904322,'2993','460',925220.64,936602.68,0.00,0.00,11382.04,7392176.26,0.00,0.00,0.00),('1','194','1012','257682',4904323,'2993','460',936602.68,946058.18,0.00,0.00,9455.50,6176804.00,0.00,0.00,0.00),('1','194','1012','257683',4904324,'2993','460',946058.18,946058.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257684',4904325,'2993','460',946058.18,948012.07,0.00,0.00,1953.89,1339174.14,0.00,0.00,0.00),('1','194','1012','257685',4904326,'2993','460',948012.07,948012.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257686',4904327,'2993','460',948012.07,957598.05,0.00,0.00,9585.98,6563032.12,0.00,0.00,0.00),('1','194','1012','257687',4904328,'2993','460',957598.05,971129.23,0.00,0.00,13531.18,9231477.10,0.00,0.00,0.00),('1','194','1012','257688',4904329,'2993','460',971129.23,972586.90,0.00,0.00,1457.67,1002723.42,0.00,0.00,0.00),('1','194','1012','257689',4904330,'2993','460',972586.90,972586.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257690',4904331,'2993','460',972586.90,981242.38,0.00,0.00,8655.48,5922670.96,0.00,0.00,0.00),('1','194','1012','257691',4904332,'2993','460',981242.38,982686.89,0.00,0.00,1444.51,1013344.50,0.00,0.00,0.00),('1','194','1012','257692',4904333,'2993','460',982686.89,982686.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257693',4904334,'2993','460',982686.89,986700.45,0.00,0.00,4013.56,2798361.82,0.00,0.00,0.00),('1','194','1012','257694',4904335,'2993','460',986700.45,995414.30,0.00,0.00,8713.85,6122280.48,0.00,0.00,0.00),('1','194','1012','257695',4904336,'2993','460',995414.30,1006087.96,0.00,0.00,10673.66,7464050.66,0.00,0.00,0.00),('1','194','1012','257696',4904337,'2993','460',1006087.96,1007229.18,0.00,0.00,1141.22,829739.40,0.00,0.00,0.00),('1','194','1012','257697',4904338,'2993','460',1007229.18,1007229.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257698',4904339,'2993','460',1007229.18,1009877.77,0.00,0.00,2648.59,1933531.30,0.00,0.00,0.00),('1','194','1012','257699',4904340,'2993','460',1009877.77,1022805.82,0.00,0.00,12928.05,9362313.00,0.00,0.00,0.00),('1','194','1012','257700',4904341,'2993','460',1022805.82,1030649.23,0.00,0.00,7843.41,5678355.70,0.00,0.00,0.00),('1','194','1012','257701',4904342,'2993','460',1030649.23,1031778.34,0.00,0.00,1129.11,823664.70,0.00,0.00,0.00),('1','194','1012','257702',4904343,'2993','460',1031778.34,1031778.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257703',4904344,'2993','460',1031778.34,1036876.48,0.00,0.00,5098.14,3722501.30,0.00,0.00,0.00),('1','194','1012','257704',4904345,'2993','460',1036876.48,1044846.06,0.00,0.00,7969.58,5782776.60,0.00,0.00,0.00),('1','194','1012','257705',4904346,'2993','460',1044846.06,1055772.44,0.00,0.00,10926.38,7919912.60,0.00,0.00,0.00),('1','194','1012','257706',4904347,'2993','460',1055772.44,1056359.49,0.00,0.00,587.05,427028.50,0.00,0.00,0.00),('1','194','1012','257707',4904348,'2993','460',1056359.49,1056359.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257708',4904349,'2993','460',1056359.49,1074444.50,0.00,0.00,18085.01,13083967.70,0.00,0.00,0.00),('1','194','1012','257709',4904350,'2993','460',1074444.50,1080563.71,0.00,0.00,6119.21,4435109.20,0.00,0.00,0.00),('1','194','1012','257710',4904351,'2993','460',1080563.71,1080563.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257711',4904352,'2993','460',1080563.71,1084687.17,0.00,0.00,4123.46,3011314.20,0.00,0.00,0.00),('1','194','1012','257712',4904353,'2993','460',1084687.17,1097286.53,0.00,0.00,12599.36,9128701.20,0.00,0.00,0.00),('1','194','1012','257713',4904354,'2993','460',1097286.53,1105104.39,0.00,0.00,7817.86,5670202.20,0.00,0.00,0.00),('1','194','1012','257714',4904355,'2993','460',1105104.39,1105104.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257715',4904356,'2993','460',1105104.39,1112890.90,0.00,0.00,7786.51,5655151.20,0.00,0.00,0.00),('1','194','1012','257716',4904357,'2993','460',1112890.90,1120860.20,0.00,0.00,7969.30,5793236.00,0.00,0.00,0.00),('1','194','1012','257717',4904358,'2993','460',1120860.20,1129684.97,0.00,0.00,8824.77,6385422.90,0.00,0.00,0.00),('1','194','1012','257718',4904359,'2993','460',1129684.97,1129684.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257719',4904360,'2993','460',1129684.97,1139533.45,0.00,0.00,9848.48,7143594.10,0.00,0.00,0.00),('1','194','1012','257720',4904361,'2993','460',1139533.45,1147565.42,0.00,0.00,8031.97,5843716.90,0.00,0.00,0.00),('1','194','1012','257721',4904362,'2993','460',1147565.42,1154242.74,0.00,0.00,6677.32,4863805.40,0.00,0.00,0.00),('1','194','1012','257722',4904363,'2993','460',1154242.74,1154242.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257723',4904364,'2993','460',1154242.74,1166166.38,0.00,0.00,11923.64,8536252.80,0.00,0.00,0.00),('1','194','1012','257724',4904365,'2993','460',1166166.38,1176203.66,0.00,0.00,10037.28,7193055.60,0.00,0.00,0.00),('1','194','1012','257725',4904366,'2993','460',1176203.66,1179222.36,0.00,0.00,3018.70,2168459.00,0.00,0.00,0.00),('1','194','1012','257726',4904367,'2993','460',1179222.36,1179222.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257727',4904368,'2993','460',1179222.36,1200469.63,0.00,0.00,21247.27,14531540.60,0.00,0.00,0.00),('1','194','1012','257728',4904369,'2993','460',1200469.63,1201939.65,0.00,0.00,1470.02,1013027.20,0.00,0.00,0.00),('1','194','1012','257729',4904370,'2993','460',1201939.65,1201939.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257730',4904371,'2993','460',1201939.65,1210790.34,0.00,0.00,8850.69,6088542.00,0.00,0.00,0.00),('1','194','1012','257731',4904372,'2993','460',1210790.34,1223403.35,0.00,0.00,12613.01,8647761.80,0.00,0.00,0.00),('1','194','1012','257732',4904373,'2993','460',1223403.35,1226606.48,0.00,0.00,3203.13,2203305.60,0.00,0.00,0.00),('1','194','1012','257733',4904374,'2993','460',1226606.48,1226606.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257734',4904375,'2993','460',1226606.48,1230110.99,0.00,0.00,3504.51,2422859.40,0.00,0.00,0.00),('1','194','1012','257735',4904376,'2993','460',1230110.99,1242402.67,0.00,0.00,12291.68,8450861.80,0.00,0.00,0.00),('1','194','1012','257736',4904377,'2993','460',1242402.67,1251052.84,0.00,0.00,8650.17,5936635.80,0.00,0.00,0.00),('1','194','1012','257737',4904378,'2993','460',1251052.84,1251052.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257738',4904379,'2993','460',1251052.84,1262603.21,0.00,0.00,11550.37,7896313.80,0.00,0.00,0.00),('1','194','1012','257739',4904380,'2993','460',1262603.21,1268250.44,0.00,0.00,5647.23,3916570.20,0.00,0.00,0.00),('1','194','1012','257740',4904381,'2993','460',1268250.44,1275704.98,0.00,0.00,7454.54,5110999.60,0.00,0.00,0.00),('1','194','1012','257741',4904382,'2993','460',1275704.98,1275704.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257742',4904383,'2993','460',1275704.98,1286067.54,0.00,0.00,10362.56,7118394.40,0.00,0.00,0.00),('1','194','1012','257743',4904384,'2993','460',1286067.54,1296829.11,0.00,0.00,10761.57,7380757.20,0.00,0.00,0.00),('1','194','1012','257744',4904385,'2993','460',1296829.11,1296829.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257745',4904386,'2993','460',1296829.11,1305558.30,0.00,0.00,8729.19,6001020.60,0.00,0.00,0.00),('1','194','1012','257746',4904387,'2993','460',1305558.30,1319821.41,0.00,0.00,14263.11,9797220.20,0.00,0.00,0.00),('1','194','1012','257747',4904388,'2993','460',1319821.41,1321504.53,0.00,0.00,1683.12,1180888.80,0.00,0.00,0.00),('1','194','1012','257748',4904389,'2993','460',1321504.53,1321504.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257749',4904390,'2993','460',1321504.53,1338428.05,0.00,0.00,16923.52,11590251.80,0.00,0.00,0.00),('1','194','1012','257750',4904391,'2993','460',1338428.05,1342127.87,0.00,0.00,3699.82,2542155.20,0.00,0.00,0.00),('1','194','1012','257751',4904392,'2993','460',1342127.87,1342127.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257752',4904393,'2993','460',1342127.87,1349478.61,0.00,0.00,7350.74,5024847.60,0.00,0.00,0.00),('1','194','1012','257753',4904394,'2993','460',1349478.61,1366065.22,0.00,0.00,16586.61,11385641.40,0.00,0.00,0.00),('1','194','1012','257754',4904395,'2993','460',1366065.22,1366339.97,0.00,0.00,274.75,196145.00,0.00,0.00,0.00),('1','194','1012','257755',4904396,'2993','460',1366339.97,1366339.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257756',4904397,'2993','460',1366339.97,1371496.92,0.00,0.00,5156.95,3539093.00,0.00,0.00,0.00),('1','194','1012','257757',4904398,'2993','460',1371496.92,1387507.40,0.00,0.00,16010.48,10997585.20,0.00,0.00,0.00),('1','194','1012','257758',4904399,'2993','460',1387507.40,1390972.67,0.00,0.00,3465.27,2392729.80,0.00,0.00,0.00),('1','194','1012','257759',4904400,'2993','460',1390972.67,1390972.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257760',4904401,'2993','460',1390972.67,1395830.83,0.00,0.00,4858.16,3346998.40,0.00,0.00,0.00),('1','194','1012','257761',4904402,'2993','460',1395830.83,1409618.01,0.00,0.00,13787.18,9476638.60,0.00,0.00,0.00),('1','194','1012','257762',4904403,'2993','460',1409618.01,1409618.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257763',4904404,'2993','460',1409618.01,1420446.79,0.00,0.00,10828.78,7422263.20,0.00,0.00,0.00),('1','194','1012','257764',4904405,'2993','460',1420446.79,1428504.68,0.00,0.00,8057.89,5558933.00,0.00,0.00,0.00),('1','194','1012','257765',4904406,'2993','460',1428504.68,1434128.95,0.00,0.00,5624.27,3856319.60,0.00,0.00,0.00),('1','194','1012','257766',4904407,'2993','460',1434128.95,1434128.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257767',4904408,'2993','460',1434128.95,1440482.33,0.00,0.00,6353.38,4354713.40,0.00,0.00,0.00),('1','194','1012','257768',4904409,'2993','460',1440482.33,1444563.84,0.00,0.00,4081.51,2845136.60,0.00,0.00,0.00),('1','194','1012','257769',4904410,'2993','460',1444563.84,1458305.79,0.00,0.00,13741.95,9438779.80,0.00,0.00,0.00),('1','194','1012','257770',4904411,'2993','460',1458305.79,1458646.40,0.00,0.00,340.61,240111.40,0.00,0.00,0.00),('1','194','1012','257771',4904412,'2993','460',1458646.40,1458646.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257772',4904413,'2993','460',1458646.40,1472304.38,0.00,0.00,13657.98,9331845.20,0.00,0.00,0.00),('1','194','1012','257773',4904414,'2993','460',1472304.38,1482972.69,0.00,0.00,10668.31,7316319.20,0.00,0.00,0.00),('1','194','1012','257774',4904415,'2993','460',1482972.69,1482972.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257775',4904416,'2993','460',1482972.69,1492867.14,0.00,0.00,9894.45,6799414.80,0.00,0.00,0.00),('1','194','1012','257776',4904417,'2993','460',1492867.14,1507539.68,0.00,0.00,14672.54,10055712.00,0.00,0.00,0.00),('1','194','1012','257777',4904418,'2993','460',1507539.68,1507539.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257778',4904419,'2993','460',1507539.68,1524771.93,0.00,0.00,17232.25,11793989.20,0.00,0.00,0.00),('1','194','1012','257779',4904420,'2993','460',1524771.93,1532162.22,0.00,0.00,7390.29,5101944.60,0.00,0.00,0.00),('1','194','1012','257780',4904421,'2993','460',1532162.22,1532162.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257781',4904422,'2993','460',1532162.22,1551317.96,0.00,0.00,19155.74,13170079.00,0.00,0.00,0.00),('1','194','1012','257782',4904423,'2993','460',1551317.96,1556857.26,0.00,0.00,5539.30,3795392.00,0.00,0.00,0.00),('1','194','1012','257783',4904424,'2993','460',1556857.26,1556857.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257784',4904425,'2993','460',1556857.26,1567287.41,0.00,0.00,10430.15,7157601.40,0.00,0.00,0.00),('1','194','1012','257785',4904426,'2993','460',1567287.41,1581402.93,0.00,0.00,14115.52,9699084.80,0.00,0.00,0.00),('1','194','1012','257786',4904427,'2993','460',1581402.93,1581402.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257787',4904428,'2993','460',1581402.93,1599463.57,0.00,0.00,18060.64,12418137.80,0.00,0.00,0.00),('1','194','1012','257788',4904429,'2993','460',1599463.57,1605807.95,0.00,0.00,6344.38,4375424.00,0.00,0.00,0.00),('1','194','1012','257789',4904430,'2993','460',1605807.95,1605807.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257790',4904431,'2993','460',1605807.95,1613781.04,0.00,0.00,7973.09,5462930.60,0.00,0.00,0.00),('1','194','1012','257791',4904432,'2993','460',1613781.04,1629252.19,0.00,0.00,15471.15,10591556.40,0.00,0.00,0.00),('1','194','1012','257792',4904433,'2993','460',1629252.19,1630501.96,0.00,0.00,1249.77,891179.80,0.00,0.00,0.00),('1','194','1012','257793',4904434,'2993','460',1630501.96,1630501.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257794',4904435,'2993','460',1630501.96,1641108.34,0.00,0.00,10606.38,7303874.60,0.00,0.00,0.00),('1','194','1012','257795',4904436,'2993','460',1641108.34,1655004.34,0.00,0.00,13896.00,9547370.00,0.00,0.00,0.00),('1','194','1012','257796',4904437,'2993','460',1655004.34,1655004.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257797',4904438,'2993','460',1655004.34,1676694.79,0.00,0.00,21690.45,14878524.80,0.00,0.00,0.00),('1','194','1012','257798',4904439,'2993','460',1676694.79,1679726.03,0.00,0.00,3031.24,2082453.80,0.00,0.00,0.00),('1','194','1012','257799',4904440,'2993','460',1679726.03,1679726.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257800',4904441,'2993','460',1679726.03,1698755.51,0.00,0.00,19029.48,13022867.20,0.00,0.00,0.00),('1','194','1012','257801',4904442,'2993','460',1698755.51,1704726.03,0.00,0.00,5970.52,4086155.92,0.00,0.00,0.00),('1','194','1012','257802',4904443,'2993','460',1704726.03,1720526.73,0.00,0.00,15800.70,10807716.80,0.00,0.00,0.00),('1','194','1012','257803',4904444,'2993','460',1720526.73,1729553.74,0.00,0.00,9027.01,6191072.20,0.00,0.00,0.00),('1','194','1012','257804',4904445,'2993','460',1729553.74,1735564.53,0.00,0.00,6010.79,4123424.60,0.00,0.00,0.00),('1','194','1012','257805',4904446,'2993','460',1735564.53,1743198.97,0.00,0.00,7634.44,5271135.20,0.00,0.00,0.00),('1','194','1012','257806',4904447,'2993','460',1743198.97,1754268.44,0.00,0.00,11069.47,7596107.80,0.00,0.00,0.00),('1','194','1012','257807',4904448,'2993','460',1754268.44,1754268.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257808',4904449,'2993','460',1754268.44,1775620.36,0.00,0.00,21351.92,14586560.80,0.00,0.00,0.00),('1','194','1012','257809',4904450,'2993','460',1775620.36,1778974.28,0.00,0.00,3353.92,2304590.80,0.00,0.00,0.00),('1','194','1012','257810',4904451,'2993','460',1778974.28,1778974.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257811',4904452,'2993','460',1778974.28,1788257.37,0.00,0.00,9283.09,6328436.60,0.00,0.00,0.00),('1','194','1012','257812',4904453,'2993','460',1788257.37,1803634.73,0.00,0.00,15377.36,10515134.40,0.00,0.00,0.00),('1','194','1012','257813',4904454,'2993','460',1803634.73,1803634.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257814',4904455,'2993','460',1803634.73,1809721.96,0.00,0.00,6087.23,4201148.20,0.00,0.00,0.00),('1','194','1012','257815',4904456,'2993','460',1809721.96,1824513.82,0.00,0.00,14791.86,10129911.80,0.00,0.00,0.00),('1','194','1012','257816',4904457,'2993','460',1824513.82,1827978.00,0.00,0.00,3464.18,2375813.20,0.00,0.00,0.00),('1','194','1012','257817',4904458,'2993','460',1827978.00,1827978.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257818',4904459,'2993','460',1827978.00,1839192.49,0.00,0.00,11214.49,7643360.60,0.00,0.00,0.00),('1','194','1012','257819',4904460,'2993','460',1839192.49,1850355.85,0.00,0.00,11163.36,7659043.60,0.00,0.00,0.00),('1','194','1012','257820',4904461,'2993','460',1850355.85,1852338.13,0.00,0.00,1982.28,1357207.20,0.00,0.00,0.00),('1','194','1012','257821',4904462,'2993','460',1852338.13,1852338.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257822',4904463,'2993','460',1852338.13,1863689.60,0.00,0.00,11351.47,7758937.80,0.00,0.00,0.00),('1','194','1012','257823',4904464,'2993','460',1863689.60,1876854.80,0.00,0.00,13165.20,9031354.00,0.00,0.00,0.00),('1','194','1012','257824',4904465,'2993','460',1876854.80,1876854.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257825',4904466,'2993','460',1876854.80,1896496.27,0.00,0.00,19641.47,13461419.80,0.00,0.00,0.00),('1','194','1012','257826',4904467,'2993','460',1896496.27,1901531.87,0.00,0.00,5035.60,3482612.00,0.00,0.00,0.00),('1','194','1012','257827',4904468,'2993','460',1901531.87,1901531.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257828',4904469,'2993','460',1901531.87,1919999.56,0.00,0.00,18467.69,12648710.60,0.00,0.00,0.00),('1','194','1012','257829',4904470,'2993','460',1919999.56,1925838.02,0.00,0.00,5838.46,3992210.40,0.00,0.00,0.00),('1','194','1012','257830',4904471,'2993','460',1925838.02,1925838.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257831',4904472,'2993','460',1925838.02,1932088.44,0.00,0.00,6250.42,4286718.48,0.00,0.00,0.00),('1','194','1012','257832',4904473,'2993','460',1932088.44,1950369.49,0.00,0.00,18281.05,12475537.00,0.00,0.00,0.00),('1','194','1012','257833',4904474,'2993','460',1950369.49,1950369.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257834',4904475,'2993','460',1950369.49,1957858.82,0.00,0.00,7489.33,5202764.20,0.00,0.00,0.00),('1','194','1012','257835',4904476,'2993','460',1957858.82,1973051.92,0.00,0.00,15193.10,10394686.00,0.00,0.00,0.00),('1','194','1012','257836',4904477,'2993','460',1973051.92,1975112.69,0.00,0.00,2060.77,1405501.80,0.00,0.00,0.00),('1','194','1012','257837',4904478,'2993','460',1975112.69,1975112.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257838',4904479,'2993','460',1975112.69,1983390.67,0.00,0.00,8277.98,5697785.20,0.00,0.00,0.00),('1','194','1012','257839',4904480,'2993','460',1983390.67,1992832.73,0.00,0.00,9442.06,6479162.40,0.00,0.00,0.00),('1','194','1012','257840',4904481,'2993','460',1992832.73,1999802.28,0.00,0.00,6969.55,4788033.00,0.00,0.00,0.00),('1','194','1012','257841',4904482,'2993','460',1999802.28,1999802.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257842',4904483,'2993','460',1999802.28,2007269.77,0.00,0.00,7467.49,5146922.60,0.00,0.00,0.00),('1','194','1012','257843',4904484,'2993','460',2007269.77,2017317.72,0.00,0.00,10047.95,6926471.00,0.00,0.00,0.00),('1','194','1012','257844',4904485,'2993','460',2017317.72,2024495.13,0.00,0.00,7177.41,4933549.40,0.00,0.00,0.00),('1','194','1012','257845',4904486,'2993','460',2024495.13,2024495.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257846',4904487,'2993','460',2024495.13,2036909.89,0.00,0.00,12414.76,8516228.40,0.00,0.00,0.00),('1','194','1012','257847',4904488,'2993','460',2036909.89,2045670.84,0.00,0.00,8760.95,6025205.00,0.00,0.00,0.00),('1','194','1012','257848',4904489,'2993','460',2045670.84,2049151.26,0.00,0.00,3480.42,2386400.60,0.00,0.00,0.00),('1','194','1012','257849',4904490,'2993','460',2049151.26,2049151.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257850',4904491,'2993','460',2049151.26,2053139.43,0.00,0.00,3988.17,2769786.90,0.00,0.00,0.00),('1','194','1012','257851',4904492,'2993','460',2053139.43,2059852.38,0.00,0.00,6712.95,4590983.00,0.00,0.00,0.00),('1','194','1012','257852',4904493,'2993','460',2059852.38,2073921.89,0.00,0.00,14069.51,9501530.30,0.00,0.00,0.00),('1','194','1012','257853',4904494,'2993','460',2073921.89,2073921.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257854',4904495,'2993','460',2073921.89,2078200.11,0.00,0.00,4278.22,2898637.50,0.00,0.00,0.00),('1','194','1012','257855',4904496,'2993','460',2078200.11,2091647.06,0.00,0.00,13446.95,9097128.00,0.00,0.00,0.00),('1','194','1012','257856',4904497,'2993','460',2091647.06,2098268.62,0.00,0.00,6621.56,4450921.80,0.00,0.00,0.00),('1','194','1012','257857',4904498,'2993','460',2098268.62,2098268.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257858',4904499,'2993','460',2098268.62,2103387.37,0.00,0.00,5118.75,3495654.40,0.00,0.00,0.00),('1','194','1012','257859',4904500,'2993','460',2103387.37,2119109.06,0.00,0.00,15721.69,10609004.00,0.00,0.00,0.00),('1','194','1012','257860',4904501,'2993','460',2119109.06,2122778.63,0.00,0.00,3669.57,2482703.10,0.00,0.00,0.00),('1','194','1012','257861',4904502,'2993','460',2122778.63,2122778.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257862',4904503,'2993','460',2122778.63,2130292.17,0.00,0.00,7513.54,5078238.30,0.00,0.00,0.00),('1','194','1012','257863',4904504,'2993','460',2130292.17,2143170.94,0.00,0.00,12878.77,8755963.80,0.00,0.00,0.00),('1','194','1012','257864',4904505,'2993','460',2143170.94,2147154.09,0.00,0.00,3983.15,2719926.00,0.00,0.00,0.00),('1','194','1012','257865',4904506,'2993','460',2147154.09,2147154.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257866',4904507,'2993','460',2147154.09,2151072.89,0.00,0.00,3918.80,2657957.00,0.00,0.00,0.00),('1','194','1012','257867',4904508,'2993','460',2151072.89,2168553.15,0.00,0.00,17480.26,11814592.40,0.00,0.00,0.00),('1','194','1012','257868',4904509,'2993','460',2168553.15,2171831.52,0.00,0.00,3278.37,2224438.60,0.00,0.00,0.00),('1','194','1012','257869',4904510,'2993','460',2171831.52,2171831.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257870',4904511,'2993','460',2171831.52,2176740.58,0.00,0.00,4909.06,3301337.40,0.00,0.00,0.00),('1','194','1012','257871',4904512,'2993','460',2176740.58,2189017.87,0.00,0.00,12277.29,8331870.60,0.00,0.00,0.00),('1','194','1012','257872',4904513,'2993','460',2189017.87,2196580.35,0.00,0.00,7562.48,5101071.20,0.00,0.00,0.00),('1','194','1012','257873',4904514,'2993','460',2196580.35,2196580.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257874',4904515,'2993','460',2196580.35,2202242.16,0.00,0.00,5661.81,3842329.40,0.00,0.00,0.00),('1','194','1012','257875',4904516,'2993','460',2202242.16,2212897.60,0.00,0.00,10655.44,7226685.60,0.00,0.00,0.00),('1','194','1012','257876',4904517,'2993','460',2212897.60,2220925.37,0.00,0.00,8027.77,5435403.10,0.00,0.00,0.00),('1','194','1012','257877',4904518,'2993','460',2220925.37,2220925.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257878',4904519,'2993','460',2220925.37,2227108.58,0.00,0.00,6183.21,4212065.40,0.00,0.00,0.00),('1','194','1012','257879',4904520,'2993','460',2227108.58,2243111.39,0.00,0.00,16002.81,10886401.50,0.00,0.00,0.00),('1','194','1012','257880',4904521,'2993','460',2243111.39,2245254.93,0.00,0.00,2143.54,1461829.60,0.00,0.00,0.00),('1','194','1012','257881',4904522,'2993','460',2245254.93,2245254.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257882',4904523,'2993','460',2245254.93,2247538.34,0.00,0.00,2283.41,1561329.40,0.00,0.00,0.00),('1','194','1012','257883',4904524,'2993','460',2247538.34,2257719.51,0.00,0.00,10181.17,6931708.40,0.00,0.00,0.00),('1','194','1012','257884',4904525,'2993','460',2257719.51,2266806.98,0.00,0.00,9087.47,6166179.60,0.00,0.00,0.00),('1','194','1012','257885',4904526,'2993','460',2266806.98,2269995.99,0.00,0.00,3189.01,2160117.40,0.00,0.00,0.00),('1','194','1012','257886',4904527,'2993','460',2269995.99,2269995.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257887',4904528,'2993','460',2269995.99,2276431.36,0.00,0.00,6435.37,4289399.00,0.00,0.00,0.00),('1','194','1012','257888',4904529,'2993','460',2276431.36,2291814.53,0.00,0.00,15383.17,10243839.00,0.00,0.00,0.00),('1','194','1012','257889',4904530,'2993','460',2291814.53,2294790.16,0.00,0.00,2975.63,2003053.80,0.00,0.00,0.00),('1','194','1012','257890',4904531,'2993','460',2294790.16,2294790.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257891',4904532,'2993','460',2294790.16,2308716.88,0.00,0.00,13926.72,9252324.00,0.00,0.00,0.00),('1','194','1012','257892',4904533,'2993','460',2308716.88,2319232.33,0.00,0.00,10515.45,6984775.00,0.00,0.00,0.00),('1','194','1012','257893',4904534,'2993','460',2319232.33,2319232.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257894',4904535,'2993','460',2319232.33,2332295.04,0.00,0.00,13062.71,8679153.80,0.00,0.00,0.00),('1','194','1012','257895',4904536,'2993','460',2332295.04,2343948.52,0.00,0.00,11653.48,7749831.60,0.00,0.00,0.00),('1','194','1012','257896',4904537,'2993','460',2343948.52,2343948.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257897',4904538,'2993','460',2343948.52,2355342.54,0.00,0.00,11394.02,7568174.00,0.00,0.00,0.00),('1','194','1012','257898',4904539,'2993','460',2355342.54,2368473.44,0.00,0.00,13130.90,8736109.60,0.00,0.00,0.00),('1','194','1012','257899',4904540,'2993','460',2368473.44,2368473.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257900',4904541,'2993','460',2368473.44,2372700.16,0.00,0.00,4226.72,2864563.40,0.00,0.00,0.00),('1','194','1012','257901',4904542,'2993','460',2372700.16,2385671.44,0.00,0.00,12971.28,8766946.60,0.00,0.00,0.00),('1','194','1012','257902',4904543,'2993','460',2385671.44,2392978.98,0.00,0.00,7307.54,4978328.80,0.00,0.00,0.00),('1','194','1012','257903',4904544,'2993','460',2392978.98,2392978.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257904',4904545,'2993','460',2392978.98,2399036.92,0.00,0.00,6057.94,4112231.80,0.00,0.00,0.00),('1','194','1012','257905',4904546,'2993','460',2399036.92,2412122.45,0.00,0.00,13085.53,8871685.60,0.00,0.00,0.00),('1','194','1012','257906',4904547,'2993','460',2412122.45,2417591.51,0.00,0.00,5469.06,3688183.20,0.00,0.00,0.00),('1','194','1012','257907',4904548,'2993','460',2417591.51,2417591.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257908',4904549,'2993','460',2417591.51,2421174.51,0.00,0.00,3583.00,2479436.00,0.00,0.00,0.00),('1','194','1012','257908',4904550,'2994','460',0.00,49.00,0.00,0.00,49.00,33908.00,0.00,0.00,0.00),('1','194','1012','257908',4904551,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257908',4904552,'2996','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257908',4904553,'2997','460',0.00,412.93,0.00,0.00,412.93,302832.20,0.00,0.00,0.00),('1','194','1012','257908',4904554,'2998','460',0.00,572.45,0.00,0.00,572.45,423613.00,0.00,0.00,0.00),('1','194','1012','257908',4904555,'2999','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257908',4904556,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257909',4904557,'2993','460',2421174.51,2423277.51,0.00,0.00,2103.00,1455276.00,0.00,0.00,0.00),('1','194','1012','257909',4904558,'2994','460',49.00,116.00,0.00,0.00,67.00,46364.00,0.00,0.00,0.00),('1','194','1012','257909',4904559,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257909',4904560,'2996','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257909',4904561,'2997','460',412.93,1083.92,0.00,0.00,670.99,496532.60,0.00,0.00,0.00),('1','194','1012','257909',4904562,'2998','460',572.45,1245.96,0.00,0.00,673.51,498397.40,0.00,0.00,0.00),('1','194','1012','257909',4904563,'2999','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257909',4904564,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257910',4904565,'2993','460',2423277.51,2430274.51,0.00,0.00,6997.00,4618020.00,0.00,0.00,0.00),('1','194','1012','257910',4904566,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257910',4904567,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257910',4904568,'2996','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257910',4904569,'2997','460',1083.92,1918.22,0.00,0.00,834.30,584010.00,0.00,0.00,0.00),('1','194','1012','257910',4904570,'2998','460',1245.96,2062.84,0.00,0.00,816.88,571816.00,0.00,0.00,0.00),('1','194','1012','257910',4904571,'2999','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257910',4904572,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257911',4904573,'2993','460',2430274.51,2436126.01,0.00,0.00,5851.50,3862150.00,0.00,0.00,0.00),('1','194','1012','257911',4904574,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257911',4904575,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257911',4904576,'2996','460',0.00,14.50,0.00,0.00,14.50,10150.00,0.00,0.00,0.00),('1','194','1012','257911',4904577,'2997','460',1918.22,2611.85,0.00,0.00,693.63,485541.00,0.00,0.00,0.00),('1','194','1012','257911',4904578,'2998','460',2062.84,2606.18,0.00,0.00,543.34,380338.00,0.00,0.00,0.00),('1','194','1012','257911',4904579,'2999','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257911',4904580,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257912',4904581,'2993','460',2436126.01,2436626.01,0.00,0.00,500.00,330000.00,0.00,0.00,0.00),('1','194','1012','257912',4904582,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257912',4904583,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257912',4904584,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257912',4904585,'2997','460',2611.85,2683.57,0.00,0.00,71.72,50204.00,0.00,0.00,0.00),('1','194','1012','257912',4904586,'2998','460',2606.18,2656.57,0.00,0.00,50.39,35273.00,0.00,0.00,0.00),('1','194','1012','257912',4904587,'2999','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257912',4904588,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904589,'2993','460',2436626.01,2436626.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904590,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904591,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904592,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904593,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904594,'2998','460',2656.57,2656.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904595,'2999','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257913',4904596,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257914',4904597,'2993','460',2436626.01,2445204.51,0.00,0.00,8578.50,5661810.00,0.00,0.00,0.00),('1','194','1012','257914',4904598,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257914',4904599,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257914',4904600,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257914',4904601,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257914',4904602,'2998','460',2656.57,3405.92,0.00,0.00,749.35,524545.00,0.00,0.00,0.00),('1','194','1012','257914',4904603,'2999','460',0.00,655.30,0.00,0.00,655.30,458710.00,0.00,0.00,0.00),('1','194','1012','257914',4904604,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257915',4904605,'2993','460',2445204.51,2455208.78,0.00,0.00,10004.27,6602858.20,0.00,0.00,0.00),('1','194','1012','257915',4904606,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257915',4904607,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257915',4904608,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257915',4904609,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257915',4904610,'2998','460',3405.92,3994.57,0.00,0.00,588.65,412055.00,0.00,0.00,0.00),('1','194','1012','257915',4904611,'2999','460',655.30,1201.19,0.00,0.00,545.89,382123.00,0.00,0.00,0.00),('1','194','1012','257915',4904612,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257916',4904613,'2993','460',2455208.78,2457775.68,0.00,0.00,2566.90,1694154.00,0.00,0.00,0.00),('1','194','1012','257916',4904614,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257916',4904615,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257916',4904616,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257916',4904617,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257916',4904618,'2998','460',3994.57,4215.62,0.00,0.00,221.05,154735.00,0.00,0.00,0.00),('1','194','1012','257916',4904619,'2999','460',1201.19,1512.68,0.00,0.00,311.49,218043.00,0.00,0.00,0.00),('1','194','1012','257916',4904620,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904621,'2993','460',2457775.68,2457775.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904622,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904623,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904624,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904625,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904626,'2998','460',4215.62,4215.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904627,'2999','460',1512.68,1512.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257917',4904628,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257918',4904629,'2993','460',2457775.68,2466125.23,0.00,0.00,8349.55,5510703.00,0.00,0.00,0.00),('1','194','1012','257918',4904630,'2994','460',116.00,116.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257918',4904631,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257918',4904632,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257918',4904633,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257918',4904634,'2998','460',4215.62,4956.93,0.00,0.00,741.31,518917.00,0.00,0.00,0.00),('1','194','1012','257918',4904635,'2999','460',1512.68,2313.61,0.00,0.00,800.93,560651.00,0.00,0.00,0.00),('1','194','1012','257918',4904636,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257919',4904637,'2993','460',2466125.23,2476330.23,0.00,0.00,10205.00,6735300.00,0.00,0.00,0.00),('1','194','1012','257919',4904638,'2994','460',116.00,196.00,0.00,0.00,80.00,52800.00,0.00,0.00,0.00),('1','194','1012','257919',4904639,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257919',4904640,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257919',4904641,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257919',4904642,'2998','460',4956.93,5629.06,0.00,0.00,672.13,470491.00,0.00,0.00,0.00),('1','194','1012','257919',4904643,'2999','460',2313.61,2961.93,0.00,0.00,648.32,453824.00,0.00,0.00,0.00),('1','194','1012','257919',4904644,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257920',4904645,'2993','460',2476330.23,2478531.94,0.00,0.00,2201.71,1453128.60,0.00,0.00,0.00),('1','194','1012','257920',4904646,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257920',4904647,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257920',4904648,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257920',4904649,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257920',4904650,'2998','460',5629.06,5837.78,0.00,0.00,208.72,146104.00,0.00,0.00,0.00),('1','194','1012','257920',4904651,'2999','460',2961.93,3139.83,0.00,0.00,177.90,124530.00,0.00,0.00,0.00),('1','194','1012','257920',4904652,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904653,'2993','460',2478531.94,2478531.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904654,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904655,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904656,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904657,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904658,'2998','460',5837.78,5837.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904659,'2999','460',3139.83,3139.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257921',4904660,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257922',4904661,'2993','460',2478531.94,2481128.80,0.00,0.00,2596.86,1713927.60,0.00,0.00,0.00),('1','194','1012','257922',4904662,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257922',4904663,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257922',4904664,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257922',4904665,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257922',4904666,'2998','460',5837.78,6288.32,0.00,0.00,450.54,315378.00,0.00,0.00,0.00),('1','194','1012','257922',4904667,'2999','460',3139.83,3586.06,0.00,0.00,446.23,312361.00,0.00,0.00,0.00),('1','194','1012','257922',4904668,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257923',4904669,'2993','460',2481128.80,2487489.30,0.00,0.00,6360.50,4197930.00,0.00,0.00,0.00),('1','194','1012','257923',4904670,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257923',4904671,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257923',4904672,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257923',4904673,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257923',4904674,'2998','460',6288.32,7016.66,0.00,0.00,728.34,509838.00,0.00,0.00,0.00),('1','194','1012','257923',4904675,'2999','460',3586.06,4183.02,0.00,0.00,596.96,417872.00,0.00,0.00,0.00),('1','194','1012','257923',4904676,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257924',4904677,'2993','460',2487489.30,2497833.80,0.00,0.00,10344.50,6827370.00,0.00,0.00,0.00),('1','194','1012','257924',4904678,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257924',4904679,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257924',4904680,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257924',4904681,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257924',4904682,'2998','460',7016.66,7893.31,0.00,0.00,876.65,613655.00,0.00,0.00,0.00),('1','194','1012','257924',4904683,'2999','460',4183.02,4993.43,0.00,0.00,810.41,567287.00,0.00,0.00,0.00),('1','194','1012','257924',4904684,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257925',4904685,'2993','460',2497833.80,2498703.80,0.00,0.00,870.00,574200.00,0.00,0.00,0.00),('1','194','1012','257925',4904686,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257925',4904687,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257925',4904688,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257925',4904689,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257925',4904690,'2998','460',7893.31,8001.30,0.00,0.00,107.99,75593.00,0.00,0.00,0.00),('1','194','1012','257925',4904691,'2999','460',4993.43,5112.39,0.00,0.00,118.96,83272.00,0.00,0.00,0.00),('1','194','1012','257925',4904692,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904693,'2993','460',2498703.80,2498703.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904694,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904695,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904696,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904697,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904698,'2998','460',8001.30,8001.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904699,'2999','460',5112.39,5112.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257926',4904700,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257927',4904701,'2993','460',2498703.80,2507277.06,0.00,0.00,8573.26,5648176.56,0.00,0.00,0.00),('1','194','1012','257927',4904702,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257927',4904703,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257927',4904704,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257927',4904705,'2997','460',2683.57,2683.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257927',4904706,'2998','460',8001.30,8736.15,0.00,0.00,734.85,514395.00,0.00,0.00,0.00),('1','194','1012','257927',4904707,'2999','460',5112.39,5722.94,0.00,0.00,610.55,427385.00,0.00,0.00,0.00),('1','194','1012','257927',4904708,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257928',4904709,'2993','460',2507277.06,2516813.16,0.00,0.00,9536.10,6276972.00,0.00,0.00,0.00),('1','194','1012','257928',4904710,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257928',4904711,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257928',4904712,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257928',4904713,'2997','460',2683.57,2689.57,0.00,0.00,6.00,4200.00,0.00,0.00,0.00),('1','194','1012','257928',4904714,'2998','460',8736.15,9620.31,0.00,0.00,884.16,618912.00,0.00,0.00,0.00),('1','194','1012','257928',4904715,'2999','460',5722.94,6419.08,0.00,0.00,696.14,487298.00,0.00,0.00,0.00),('1','194','1012','257928',4904716,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257929',4904717,'2993','460',2516813.16,2519661.09,0.00,0.00,2847.93,1879633.80,0.00,0.00,0.00),('1','194','1012','257929',4904718,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257929',4904719,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257929',4904720,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257929',4904721,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257929',4904722,'2998','460',9620.31,9836.44,0.00,0.00,216.13,151291.00,0.00,0.00,0.00),('1','194','1012','257929',4904723,'2999','460',6419.08,6587.58,0.00,0.00,168.50,117950.00,0.00,0.00,0.00),('1','194','1012','257929',4904724,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904725,'2993','460',2519661.09,2519661.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904726,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904727,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904728,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904729,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904730,'2998','460',9836.44,9836.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904731,'2999','460',6587.58,6587.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257930',4904732,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257931',4904733,'2993','460',2519661.09,2533198.34,0.00,0.00,13537.25,8934585.00,0.00,0.00,0.00),('1','194','1012','257931',4904734,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257931',4904735,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257931',4904736,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257931',4904737,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257931',4904738,'2998','460',9836.44,10430.89,0.00,0.00,594.45,416115.00,0.00,0.00,0.00),('1','194','1012','257931',4904739,'2999','460',6587.58,7356.03,0.00,0.00,768.45,537915.00,0.00,0.00,0.00),('1','194','1012','257931',4904740,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257932',4904741,'2993','460',2533198.34,2541739.54,0.00,0.00,8541.20,5637192.00,0.00,0.00,0.00),('1','194','1012','257932',4904742,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257932',4904743,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257932',4904744,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257932',4904745,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257932',4904746,'2998','460',10430.89,11151.79,0.00,0.00,720.90,504630.00,0.00,0.00,0.00),('1','194','1012','257932',4904747,'2999','460',7356.03,7828.35,0.00,0.00,472.32,330624.00,0.00,0.00,0.00),('1','194','1012','257932',4904748,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904749,'2993','460',2541739.54,2541739.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904750,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904751,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904752,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904753,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904754,'2998','460',11151.79,11151.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904755,'2999','460',7828.35,7828.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257933',4904756,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257934',4904757,'2993','460',2541739.54,2553103.44,0.00,0.00,11363.90,7545629.60,0.00,0.00,0.00),('1','194','1012','257934',4904758,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257934',4904759,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257934',4904760,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257934',4904761,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257934',4904762,'2998','460',11151.79,11820.77,0.00,0.00,668.98,468286.00,0.00,0.00,0.00),('1','194','1012','257934',4904763,'2999','460',7828.35,8508.42,0.00,0.00,680.07,476049.00,0.00,0.00,0.00),('1','194','1012','257934',4904764,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257935',4904765,'2993','460',2553103.44,2563687.38,0.00,0.00,10583.94,7027736.16,0.00,0.00,0.00),('1','194','1012','257935',4904766,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257935',4904767,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257935',4904768,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257935',4904769,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257935',4904770,'2998','460',11820.77,12532.38,0.00,0.00,711.61,498127.00,0.00,0.00,0.00),('1','194','1012','257935',4904771,'2999','460',8508.42,8841.38,0.00,0.00,332.96,233072.00,0.00,0.00,0.00),('1','194','1012','257935',4904772,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904773,'2993','460',2563687.38,2563687.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904774,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904775,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904776,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904777,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904778,'2998','460',12532.38,12532.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904779,'2999','460',8841.38,8841.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257936',4904780,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257937',4904781,'2993','460',2563687.38,2575348.21,0.00,0.00,11660.83,7742791.12,0.00,0.00,0.00),('1','194','1012','257937',4904782,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257937',4904783,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257937',4904784,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257937',4904785,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257937',4904786,'2998','460',12532.38,13203.76,0.00,0.00,671.38,469966.00,0.00,0.00,0.00),('1','194','1012','257937',4904787,'2999','460',8841.38,9445.45,0.00,0.00,604.07,422849.00,0.00,0.00,0.00),('1','194','1012','257937',4904788,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257938',4904789,'2993','460',2575348.21,2586167.44,0.00,0.00,10819.23,7183968.72,0.00,0.00,0.00),('1','194','1012','257938',4904790,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257938',4904791,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257938',4904792,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257938',4904793,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257938',4904794,'2998','460',13203.76,13774.09,0.00,0.00,570.33,399231.00,0.00,0.00,0.00),('1','194','1012','257938',4904795,'2999','460',9445.45,9893.58,0.00,0.00,448.13,313691.00,0.00,0.00,0.00),('1','194','1012','257938',4904796,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904797,'2993','460',2586167.44,2586167.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904798,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904799,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904800,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904801,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904802,'2998','460',13774.09,13774.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904803,'2999','460',9893.58,9893.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257939',4904804,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257940',4904805,'2993','460',2586167.44,2593542.10,0.00,0.00,7374.66,4896774.24,0.00,0.00,0.00),('1','194','1012','257940',4904806,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257940',4904807,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257940',4904808,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257940',4904809,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257940',4904810,'2998','460',13774.09,14715.46,0.00,0.00,941.37,658959.00,0.00,0.00,0.00),('1','194','1012','257940',4904811,'2999','460',9893.58,10698.56,0.00,0.00,804.98,563486.00,0.00,0.00,0.00),('1','194','1012','257940',4904812,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257941',4904813,'2993','460',2593542.10,2599415.08,0.00,0.00,5872.98,3899658.72,0.00,0.00,0.00),('1','194','1012','257941',4904814,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257941',4904815,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257941',4904816,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257941',4904817,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257941',4904818,'2998','460',14715.46,15347.39,0.00,0.00,631.93,442351.00,0.00,0.00,0.00),('1','194','1012','257941',4904819,'2999','460',10698.56,11224.55,0.00,0.00,525.99,368193.00,0.00,0.00,0.00),('1','194','1012','257941',4904820,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257942',4904821,'2993','460',2599415.08,2606349.58,0.00,0.00,6934.50,4604508.00,0.00,0.00,0.00),('1','194','1012','257942',4904822,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257942',4904823,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257942',4904824,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257942',4904825,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257942',4904826,'2998','460',15347.39,16389.28,0.00,0.00,1041.89,729323.00,0.00,0.00,0.00),('1','194','1012','257942',4904827,'2999','460',11224.55,11911.51,0.00,0.00,686.96,480872.00,0.00,0.00,0.00),('1','194','1012','257942',4904828,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904829,'2993','460',2606349.58,2606349.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904830,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904831,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904832,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904833,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904834,'2998','460',16389.28,16389.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904835,'2999','460',11911.51,11911.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257943',4904836,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257944',4904837,'2993','460',2606349.58,2612698.43,0.00,0.00,6348.85,4215636.40,0.00,0.00,0.00),('1','194','1012','257944',4904838,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257944',4904839,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257944',4904840,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257944',4904841,'2997','460',2689.57,2689.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257944',4904842,'2998','460',16389.28,17325.11,0.00,0.00,935.83,655081.00,0.00,0.00,0.00),('1','194','1012','257944',4904843,'2999','460',11911.51,12494.04,0.00,0.00,582.53,407771.00,0.00,0.00,0.00),('1','194','1012','257944',4904844,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257945',4904845,'2993','460',2612698.43,2620266.67,0.00,0.00,7568.24,5025311.36,0.00,0.00,0.00),('1','194','1012','257945',4904846,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257945',4904847,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257945',4904848,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257945',4904849,'2997','460',2689.57,2692.57,0.00,0.00,3.00,2100.00,0.00,0.00,0.00),('1','194','1012','257945',4904850,'2998','460',17325.11,17892.81,0.00,0.00,567.70,397390.00,0.00,0.00,0.00),('1','194','1012','257945',4904851,'2999','460',12494.04,13012.24,0.00,0.00,518.20,362740.00,0.00,0.00,0.00),('1','194','1012','257945',4904852,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257946',4904853,'2993','460',2620266.67,2625494.37,0.00,0.00,5227.70,3471192.80,0.00,0.00,0.00),('1','194','1012','257946',4904854,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257946',4904855,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257946',4904856,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257946',4904857,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257946',4904858,'2998','460',17892.81,18627.31,0.00,0.00,734.50,514150.00,0.00,0.00,0.00),('1','194','1012','257946',4904859,'2999','460',13012.24,13592.96,0.00,0.00,580.72,406504.00,0.00,0.00,0.00),('1','194','1012','257946',4904860,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257947',4904861,'2993','460',2625494.37,2626844.37,0.00,0.00,1350.00,896400.00,0.00,0.00,0.00),('1','194','1012','257947',4904862,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257947',4904863,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257947',4904864,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257947',4904865,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257947',4904866,'2998','460',18627.31,18787.40,0.00,0.00,160.09,112063.00,0.00,0.00,0.00),('1','194','1012','257947',4904867,'2999','460',13592.96,13681.71,0.00,0.00,88.75,62125.00,0.00,0.00,0.00),('1','194','1012','257947',4904868,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904869,'2993','460',2626844.37,2626844.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904870,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904871,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904872,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904873,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904874,'2998','460',18787.40,18787.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904875,'2999','460',13681.71,13681.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257948',4904876,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257949',4904877,'2993','460',2626844.37,2631994.39,0.00,0.00,5150.02,3419613.28,0.00,0.00,0.00),('1','194','1012','257949',4904878,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257949',4904879,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257949',4904880,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257949',4904881,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257949',4904882,'2998','460',18787.40,19211.27,0.00,0.00,423.87,296709.00,0.00,0.00,0.00),('1','194','1012','257949',4904883,'2999','460',13681.71,13993.62,0.00,0.00,311.91,218337.00,0.00,0.00,0.00),('1','194','1012','257949',4904884,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257950',4904885,'2993','460',2631994.39,2641019.97,0.00,0.00,9025.58,5992985.12,0.00,0.00,0.00),('1','194','1012','257950',4904886,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257950',4904887,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257950',4904888,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257950',4904889,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257950',4904890,'2998','460',19211.27,20365.20,0.00,0.00,1153.93,807751.00,0.00,0.00,0.00),('1','194','1012','257950',4904891,'2999','460',13993.62,14973.62,0.00,0.00,980.00,686000.00,0.00,0.00,0.00),('1','194','1012','257950',4904892,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257951',4904893,'2993','460',2641019.97,2646979.43,0.00,0.00,5959.46,3957081.44,0.00,0.00,0.00),('1','194','1012','257951',4904894,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257951',4904895,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257951',4904896,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257951',4904897,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257951',4904898,'2998','460',20365.20,20914.13,0.00,0.00,548.93,384251.00,0.00,0.00,0.00),('1','194','1012','257951',4904899,'2999','460',14973.62,15441.90,0.00,0.00,468.28,327796.00,0.00,0.00,0.00),('1','194','1012','257951',4904900,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904901,'2993','460',2646979.43,2646979.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904902,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904903,'2995','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904904,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904905,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904906,'2998','460',20914.13,20914.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904907,'2999','460',15441.90,15441.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257952',4904908,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257953',4904909,'2993','460',2646979.43,2655665.57,0.00,0.00,8686.14,5732852.40,0.00,0.00,0.00),('1','194','1012','257953',4904910,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257953',4904911,'2995','460',0.00,3.00,0.00,0.00,3.00,2100.00,0.00,0.00,0.00),('1','194','1012','257953',4904912,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257953',4904913,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257953',4904914,'2998','460',20914.13,22113.85,0.00,0.00,1199.72,839804.00,0.00,0.00,0.00),('1','194','1012','257953',4904915,'2999','460',15441.90,16428.82,0.00,0.00,986.92,690844.00,0.00,0.00,0.00),('1','194','1012','257953',4904916,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257954',4904917,'2993','460',2655665.57,2659814.57,0.00,0.00,4149.00,2738340.00,0.00,0.00,0.00),('1','194','1012','257954',4904918,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257954',4904919,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257954',4904920,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257954',4904921,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257954',4904922,'2998','460',22113.85,23047.19,0.00,0.00,933.34,653338.00,0.00,0.00,0.00),('1','194','1012','257954',4904923,'2999','460',16428.82,17116.31,0.00,0.00,687.49,481243.00,0.00,0.00,0.00),('1','194','1012','257954',4904924,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257955',4904925,'2993','460',2659814.57,2666717.94,0.00,0.00,6903.37,4556224.20,0.00,0.00,0.00),('1','194','1012','257955',4904926,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257955',4904927,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257955',4904928,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257955',4904929,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257955',4904930,'2998','460',23047.19,23470.77,0.00,0.00,423.58,296506.00,0.00,0.00,0.00),('1','194','1012','257955',4904931,'2999','460',17116.31,17724.63,0.00,0.00,608.32,425824.00,0.00,0.00,0.00),('1','194','1012','257955',4904932,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904933,'2993','460',2666717.94,2666717.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904934,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904935,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904936,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904937,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904938,'2998','460',23470.77,23470.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904939,'2999','460',17724.63,17724.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257956',4904940,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257957',4904941,'2993','460',2666717.94,2673162.07,0.00,0.00,6444.13,4253125.80,0.00,0.00,0.00),('1','194','1012','257957',4904942,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257957',4904943,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257957',4904944,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257957',4904945,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257957',4904946,'2998','460',23470.77,24509.60,0.00,0.00,1038.83,719981.00,0.00,0.00,0.00),('1','194','1012','257957',4904947,'2999','460',17724.63,18758.73,0.00,0.00,1034.10,717870.00,0.00,0.00,0.00),('1','194','1012','257957',4904948,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257958',4904949,'2993','460',2673162.07,2680112.55,0.00,0.00,6950.48,4587316.80,0.00,0.00,0.00),('1','194','1012','257958',4904950,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257958',4904951,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257958',4904952,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257958',4904953,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257958',4904954,'2998','460',24509.60,25367.61,0.00,0.00,858.01,600607.00,0.00,0.00,0.00),('1','194','1012','257958',4904955,'2999','460',18758.73,19436.23,0.00,0.00,677.50,474250.00,0.00,0.00,0.00),('1','194','1012','257958',4904956,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257959',4904957,'2993','460',2680112.55,2686774.05,0.00,0.00,6661.50,4396590.00,0.00,0.00,0.00),('1','194','1012','257959',4904958,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257959',4904959,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257959',4904960,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257959',4904961,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257959',4904962,'2998','460',25367.61,25980.68,0.00,0.00,613.07,429149.00,0.00,0.00,0.00),('1','194','1012','257959',4904963,'2999','460',19436.23,19963.52,0.00,0.00,527.29,369103.00,0.00,0.00,0.00),('1','194','1012','257959',4904964,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904965,'2993','460',2686774.05,2686774.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904966,'2994','460',196.00,196.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904967,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904968,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904969,'2997','460',2692.57,2692.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904970,'2998','460',25980.68,25980.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904971,'2999','460',19963.52,19963.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257960',4904972,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257961',4904973,'2993','460',2686774.05,2694506.58,0.00,0.00,7732.53,5105509.80,0.00,0.00,0.00),('1','194','1012','257961',4904974,'2994','460',196.00,268.50,0.00,0.00,72.50,48350.00,0.00,0.00,0.00),('1','194','1012','257961',4904975,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257961',4904976,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257961',4904977,'2997','460',2692.57,2697.57,0.00,0.00,5.00,3500.00,0.00,0.00,0.00),('1','194','1012','257961',4904978,'2998','460',25980.68,26630.39,0.00,0.00,649.71,454797.00,0.00,0.00,0.00),('1','194','1012','257961',4904979,'2999','460',19963.52,20511.85,0.00,0.00,548.33,383831.00,0.00,0.00,0.00),('1','194','1012','257961',4904980,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257962',4904981,'2993','460',2694506.58,2702827.58,0.00,0.00,8321.00,5487708.00,0.00,0.00,0.00),('1','194','1012','257962',4904982,'2994','460',268.50,488.50,0.00,0.00,220.00,145200.00,0.00,0.00,0.00),('1','194','1012','257962',4904983,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257962',4904984,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257962',4904985,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257962',4904986,'2998','460',26630.39,27796.52,0.00,0.00,1166.13,816291.00,0.00,0.00,0.00),('1','194','1012','257962',4904987,'2999','460',20511.85,21664.84,0.00,0.00,1152.99,807093.00,0.00,0.00,0.00),('1','194','1012','257962',4904988,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257963',4904989,'2993','460',2702827.58,2706281.58,0.00,0.00,3454.00,2274208.00,0.00,0.00,0.00),('1','194','1012','257963',4904990,'2994','460',488.50,638.50,0.00,0.00,150.00,99000.00,0.00,0.00,0.00),('1','194','1012','257963',4904991,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257963',4904992,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257963',4904993,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257963',4904994,'2998','460',27796.52,27995.45,0.00,0.00,198.93,139251.00,0.00,0.00,0.00),('1','194','1012','257963',4904995,'2999','460',21664.84,21851.62,0.00,0.00,186.78,130746.00,0.00,0.00,0.00),('1','194','1012','257963',4904996,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4904997,'2993','460',2706281.58,2706281.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4904998,'2994','460',638.50,638.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4904999,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4905000,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4905001,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4905002,'2998','460',27995.45,27995.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4905003,'2999','460',21851.62,21851.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257964',4905004,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257965',4905005,'2993','460',2706281.58,2710968.59,0.00,0.00,4687.01,3089382.60,0.00,0.00,0.00),('1','194','1012','257965',4905006,'2994','460',638.50,638.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257965',4905007,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257965',4905008,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257965',4905009,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257965',4905010,'2998','460',27995.45,28495.63,0.00,0.00,500.18,350126.00,0.00,0.00,0.00),('1','194','1012','257965',4905011,'2999','460',21851.62,22229.62,0.00,0.00,378.00,264600.00,0.00,0.00,0.00),('1','194','1012','257965',4905012,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257966',4905013,'2993','460',2710968.59,2717083.74,0.00,0.00,6115.15,4030053.00,0.00,0.00,0.00),('1','194','1012','257966',4905014,'2994','460',638.50,638.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257966',4905015,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257966',4905016,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257966',4905017,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257966',4905018,'2998','460',28495.63,29310.40,0.00,0.00,814.77,570339.00,0.00,0.00,0.00),('1','194','1012','257966',4905019,'2999','460',22229.62,22974.05,0.00,0.00,744.43,521101.00,0.00,0.00,0.00),('1','194','1012','257966',4905020,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257967',4905021,'2993','460',2717083.74,2726105.24,0.00,0.00,9021.50,5946328.00,0.00,0.00,0.00),('1','194','1012','257967',4905022,'2994','460',638.50,738.50,0.00,0.00,100.00,66000.00,0.00,0.00,0.00),('1','194','1012','257967',4905023,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257967',4905024,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257967',4905025,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257967',4905026,'2998','460',29310.40,29963.90,0.00,0.00,653.50,457450.00,0.00,0.00,0.00),('1','194','1012','257967',4905027,'2999','460',22974.05,23605.40,0.00,0.00,631.35,441945.00,0.00,0.00,0.00),('1','194','1012','257967',4905028,'3000','460',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257968',4905029,'2993','460',2726105.24,2726754.99,0.00,0.00,649.75,428835.00,0.00,0.00,0.00),('1','194','1012','257968',4905030,'2994','460',738.50,738.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257968',4905031,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257968',4905032,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257968',4905033,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257968',4905034,'2998','460',29963.90,29963.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257968',4905035,'2999','460',23605.40,23703.76,0.00,0.00,98.36,68852.00,0.00,0.00,0.00),('1','194','1012','257968',4905036,'3000','460',0.00,84.64,0.00,0.00,84.64,59248.00,0.00,0.00,0.00),('1','194','1012','257969',4905037,'2993','460',2726754.99,2726754.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905038,'2994','460',738.50,738.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905039,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905040,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905041,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905042,'2998','460',29963.90,29963.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905043,'2999','460',23703.76,23703.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257969',4905044,'3000','460',84.64,84.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257970',4905045,'2993','460',2726754.99,2731310.74,0.00,0.00,4555.75,3000407.00,0.00,0.00,0.00),('1','194','1012','257970',4905046,'2994','460',738.50,763.50,0.00,0.00,25.00,16500.00,0.00,0.00,0.00),('1','194','1012','257970',4905047,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257970',4905048,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257970',4905049,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257970',4905050,'2998','460',29963.90,29970.90,0.00,0.00,7.00,4900.00,0.00,0.00,0.00),('1','194','1012','257970',4905051,'2999','460',23703.76,24317.84,0.00,0.00,614.08,429856.00,0.00,0.00,0.00),('1','194','1012','257970',4905052,'3000','460',84.64,609.77,0.00,0.00,525.13,367591.00,0.00,0.00,0.00),('1','194','1012','257971',4905053,'2993','460',2731310.74,2741035.74,0.00,0.00,9725.00,6418500.00,0.00,0.00,0.00),('1','194','1012','257971',4905054,'2994','460',763.50,863.50,0.00,0.00,100.00,66000.00,0.00,0.00,0.00),('1','194','1012','257971',4905055,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257971',4905056,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257971',4905057,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257971',4905058,'2998','460',29970.90,29975.90,0.00,0.00,5.00,3500.00,0.00,0.00,0.00),('1','194','1012','257971',4905059,'2999','460',24317.84,25346.40,0.00,0.00,1028.56,719992.00,0.00,0.00,0.00),('1','194','1012','257971',4905060,'3000','460',609.77,1648.68,0.00,0.00,1038.91,727237.00,0.00,0.00,0.00),('1','194','1012','257972',4905061,'2993','460',2741035.74,2746249.74,0.00,0.00,5214.00,3432420.00,0.00,0.00,0.00),('1','194','1012','257972',4905062,'2994','460',863.50,1033.50,0.00,0.00,170.00,112200.00,0.00,0.00,0.00),('1','194','1012','257972',4905063,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257972',4905064,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257972',4905065,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257972',4905066,'2998','460',29975.90,29975.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257972',4905067,'2999','460',25346.40,25948.77,0.00,0.00,602.37,421659.00,0.00,0.00,0.00),('1','194','1012','257972',4905068,'3000','460',1648.68,2324.53,0.00,0.00,675.85,473095.00,0.00,0.00,0.00),('1','194','1012','257973',4905069,'2993','460',2746249.74,2746249.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905070,'2994','460',1033.50,1033.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905071,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905072,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905073,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905074,'2998','460',29975.90,29975.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905075,'2999','460',25948.77,25948.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257973',4905076,'3000','460',2324.53,2324.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257974',4905077,'2993','460',2746249.74,2757600.24,0.00,0.00,11350.50,7482928.00,0.00,0.00,0.00),('1','194','1012','257974',4905078,'2994','460',1033.50,1133.50,0.00,0.00,100.00,66000.00,0.00,0.00,0.00),('1','194','1012','257974',4905079,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257974',4905080,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257974',4905081,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257974',4905082,'2998','460',29975.90,29975.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257974',4905083,'2999','460',25948.77,27093.71,0.00,0.00,1144.94,801458.00,0.00,0.00,0.00),('1','194','1012','257974',4905084,'3000','460',2324.53,3504.55,0.00,0.00,1180.02,826014.00,0.00,0.00,0.00),('1','194','1012','257975',4905085,'2993','460',2757600.24,2764081.24,0.00,0.00,6481.00,4271018.00,0.00,0.00,0.00),('1','194','1012','257975',4905086,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257975',4905087,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257975',4905088,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257975',4905089,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257975',4905090,'2998','460',29975.90,29978.90,0.00,0.00,3.00,2100.00,0.00,0.00,0.00),('1','194','1012','257975',4905091,'2999','460',27093.71,27782.37,0.00,0.00,688.66,482062.00,0.00,0.00,0.00),('1','194','1012','257975',4905092,'3000','460',3504.55,4454.20,0.00,0.00,949.65,664755.00,0.00,0.00,0.00),('1','194','1012','257976',4905093,'2993','460',2764081.24,2765889.73,0.00,0.00,1808.49,1193603.40,0.00,0.00,0.00),('1','194','1012','257976',4905094,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257976',4905095,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257976',4905096,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257976',4905097,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257976',4905098,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257976',4905099,'2999','460',27782.37,27920.87,0.00,0.00,138.50,96950.00,0.00,0.00,0.00),('1','194','1012','257976',4905100,'3000','460',4454.20,4622.76,0.00,0.00,168.56,117992.00,0.00,0.00,0.00),('1','194','1012','257977',4905101,'2993','460',2765889.73,2765889.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905102,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905103,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905104,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905105,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905106,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905107,'2999','460',27920.87,27920.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257977',4905108,'3000','460',4622.76,4622.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257978',4905109,'2993','460',2765889.73,2766813.73,0.00,0.00,924.00,609840.00,0.00,0.00,0.00),('1','194','1012','257978',4905110,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257978',4905111,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257978',4905112,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257978',4905113,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257978',4905114,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257978',4905115,'2999','460',27920.87,28114.66,0.00,0.00,193.79,135653.00,0.00,0.00,0.00),('1','194','1012','257978',4905116,'3000','460',4622.76,4705.26,0.00,0.00,82.50,57750.00,0.00,0.00,0.00),('1','194','1012','257979',4905117,'2993','460',2766813.73,2779369.23,0.00,0.00,12555.50,8274160.00,0.00,0.00,0.00),('1','194','1012','257979',4905118,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257979',4905119,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257979',4905120,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257979',4905121,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257979',4905122,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257979',4905123,'2999','460',28114.66,29205.26,0.00,0.00,1090.60,763420.00,0.00,0.00,0.00),('1','194','1012','257979',4905124,'3000','460',4705.26,5728.82,0.00,0.00,1023.56,716492.00,0.00,0.00,0.00),('1','194','1012','257980',4905125,'2993','460',2779369.23,2786478.23,0.00,0.00,7109.00,4681464.00,0.00,0.00,0.00),('1','194','1012','257980',4905126,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257980',4905127,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257980',4905128,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257980',4905129,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257980',4905130,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257980',4905131,'2999','460',29205.26,29728.65,0.00,0.00,523.39,366373.00,0.00,0.00,0.00),('1','194','1012','257980',4905132,'3000','460',5728.82,6444.69,0.00,0.00,715.87,501109.00,0.00,0.00,0.00),('1','194','1012','257981',4905133,'2993','460',2786478.23,2786478.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905134,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905135,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905136,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905137,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905138,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905139,'2999','460',29728.65,29728.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257981',4905140,'3000','460',6444.69,6444.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257982',4905141,'2993','460',2786478.23,2797142.73,0.00,0.00,10664.50,7030062.00,0.00,0.00,0.00),('1','194','1012','257982',4905142,'2994','460',1133.50,1133.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257982',4905143,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257982',4905144,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257982',4905145,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257982',4905146,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257982',4905147,'2999','460',29728.65,31181.21,0.00,0.00,1452.56,1016792.00,0.00,0.00,0.00),('1','194','1012','257982',4905148,'3000','460',6444.69,7910.00,0.00,0.00,1465.31,1025717.00,0.00,0.00,0.00),('1','194','1012','257983',4905149,'2993','460',2797142.73,2803800.73,0.00,0.00,6658.00,4386332.00,0.00,0.00,0.00),('1','194','1012','257983',4905150,'2994','460',1133.50,1183.50,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','194','1012','257983',4905151,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257983',4905152,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257983',4905153,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257983',4905154,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257983',4905155,'2999','460',31181.21,32057.42,0.00,0.00,876.21,613347.00,0.00,0.00,0.00),('1','194','1012','257983',4905156,'3000','460',7910.00,8981.00,0.00,0.00,1071.00,749700.00,0.00,0.00,0.00),('1','194','1012','257984',4905157,'2993','460',2803800.73,2805686.23,0.00,0.00,1885.50,1244430.00,0.00,0.00,0.00),('1','194','1012','257984',4905158,'2994','460',1183.50,1183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257984',4905159,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257984',4905160,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257984',4905161,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257984',4905162,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257984',4905163,'2999','460',32057.42,32307.51,0.00,0.00,250.09,175063.00,0.00,0.00,0.00),('1','194','1012','257984',4905164,'3000','460',8981.00,9184.36,0.00,0.00,203.36,142352.00,0.00,0.00,0.00),('1','194','1012','257985',4905165,'2993','460',2805686.23,2805686.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905166,'2994','460',1183.50,1183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905167,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905168,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905169,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905170,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905171,'2999','460',32307.51,32307.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257985',4905172,'3000','460',9184.36,9184.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257986',4905173,'2993','460',2805686.23,2810157.23,0.00,0.00,4471.00,2950860.00,0.00,0.00,0.00),('1','194','1012','257986',4905174,'2994','460',1183.50,1183.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257986',4905175,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257986',4905176,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257986',4905177,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257986',4905178,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257986',4905179,'2999','460',32307.51,32882.31,0.00,0.00,574.80,402360.00,0.00,0.00,0.00),('1','194','1012','257986',4905180,'3000','460',9184.36,9804.93,0.00,0.00,620.57,434399.00,0.00,0.00,0.00),('1','194','1012','257987',4905181,'2993','460',2810157.23,2821462.30,0.00,0.00,11305.07,7455240.20,0.00,0.00,0.00),('1','194','1012','257987',4905182,'2994','460',1183.50,1333.50,0.00,0.00,150.00,99000.00,0.00,0.00,0.00),('1','194','1012','257987',4905183,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257987',4905184,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257987',4905185,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257987',4905186,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257987',4905187,'2999','460',32882.31,34066.66,0.00,0.00,1184.35,829045.00,0.00,0.00,0.00),('1','194','1012','257987',4905188,'3000','460',9804.93,10943.59,0.00,0.00,1138.66,797062.00,0.00,0.00,0.00),('1','194','1012','257988',4905189,'2993','460',2821462.30,2825669.80,0.00,0.00,4207.50,2771776.00,0.00,0.00,0.00),('1','194','1012','257988',4905190,'2994','460',1333.50,1333.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257988',4905191,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257988',4905192,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257988',4905193,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257988',4905194,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257988',4905195,'2999','460',34066.66,34368.45,0.00,0.00,301.79,211253.00,0.00,0.00,0.00),('1','194','1012','257988',4905196,'3000','460',10943.59,11476.44,0.00,0.00,532.85,372995.00,0.00,0.00,0.00),('1','194','1012','257989',4905197,'2993','460',2825669.80,2825669.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905198,'2994','460',1333.50,1333.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905199,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905200,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905201,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905202,'2998','460',29978.90,29978.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905203,'2999','460',34368.45,34368.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257989',4905204,'3000','460',11476.44,11476.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257990',4905205,'2993','460',2825669.80,2838880.76,0.00,0.00,13210.96,8713709.60,0.00,0.00,0.00),('1','194','1012','257990',4905206,'2994','460',1333.50,1333.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257990',4905207,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257990',4905208,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257990',4905209,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257990',4905210,'2998','460',29978.90,29980.90,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','194','1012','257990',4905211,'2999','460',34368.45,36423.46,0.00,0.00,2055.01,1438507.00,0.00,0.00,0.00),('1','194','1012','257990',4905212,'3000','460',11476.44,13638.01,0.00,0.00,2161.57,1513099.00,0.00,0.00,0.00),('1','194','1012','257991',4905213,'2993','460',2838880.76,2845326.26,0.00,0.00,6445.50,4254030.00,0.00,0.00,0.00),('1','194','1012','257991',4905214,'2994','460',1333.50,1333.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257991',4905215,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257991',4905216,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257991',4905217,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257991',4905218,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257991',4905219,'2999','460',36423.46,36734.96,0.00,0.00,311.50,218050.00,0.00,0.00,0.00),('1','194','1012','257991',4905220,'3000','460',13638.01,14056.79,0.00,0.00,418.78,293146.00,0.00,0.00,0.00),('1','194','1012','257992',4905221,'2993','460',2845326.26,2845326.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905222,'2994','460',1333.50,1333.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905223,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905224,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905225,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905226,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905227,'2999','460',36734.96,36734.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257992',4905228,'3000','460',14056.79,14056.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257993',4905229,'2993','460',2845326.26,2860344.42,0.00,0.00,15018.16,9899049.60,0.00,0.00,0.00),('1','194','1012','257993',4905230,'2994','460',1333.50,1757.50,0.00,0.00,424.00,279840.00,0.00,0.00,0.00),('1','194','1012','257993',4905231,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257993',4905232,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257993',4905233,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257993',4905234,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257993',4905235,'2999','460',36734.96,37563.06,0.00,0.00,828.10,579670.00,0.00,0.00,0.00),('1','194','1012','257993',4905236,'3000','460',14056.79,15030.22,0.00,0.00,973.43,681401.00,0.00,0.00,0.00),('1','194','1012','257994',4905237,'2993','460',2860344.42,2866150.42,0.00,0.00,5806.00,3820296.00,0.00,0.00,0.00),('1','194','1012','257994',4905238,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257994',4905239,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257994',4905240,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257994',4905241,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257994',4905242,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257994',4905243,'2999','460',37563.06,38100.91,0.00,0.00,537.85,376495.00,0.00,0.00,0.00),('1','194','1012','257994',4905244,'3000','460',15030.22,15653.99,0.00,0.00,623.77,436639.00,0.00,0.00,0.00),('1','194','1012','257995',4905245,'2993','460',2866150.42,2866150.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905246,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905247,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905248,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905249,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905250,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905251,'2999','460',38100.91,38100.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257995',4905252,'3000','460',15653.99,15653.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257996',4905253,'2993','460',2866150.42,2873104.57,0.00,0.00,6954.15,4575627.00,0.00,0.00,0.00),('1','194','1012','257996',4905254,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257996',4905255,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257996',4905256,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257996',4905257,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257996',4905258,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257996',4905259,'2999','460',38100.91,38947.53,0.00,0.00,846.62,592634.00,0.00,0.00,0.00),('1','194','1012','257996',4905260,'3000','460',15653.99,16390.29,0.00,0.00,736.30,515410.00,0.00,0.00,0.00),('1','194','1012','257997',4905261,'2993','460',2873104.57,2881149.57,0.00,0.00,8045.00,5299998.00,0.00,0.00,0.00),('1','194','1012','257997',4905262,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257997',4905263,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257997',4905264,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257997',4905265,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257997',4905266,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257997',4905267,'2999','460',38947.53,39543.33,0.00,0.00,595.80,417060.00,0.00,0.00,0.00),('1','194','1012','257997',4905268,'3000','460',16390.29,16979.26,0.00,0.00,588.97,412279.00,0.00,0.00,0.00),('1','194','1012','257998',4905269,'2993','460',2881149.57,2887028.57,0.00,0.00,5879.00,3866102.00,0.00,0.00,0.00),('1','194','1012','257998',4905270,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257998',4905271,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257998',4905272,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257998',4905273,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257998',4905274,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257998',4905275,'2999','460',39543.33,40222.14,0.00,0.00,678.81,475167.00,0.00,0.00,0.00),('1','194','1012','257998',4905276,'3000','460',16979.26,17386.89,0.00,0.00,407.63,285341.00,0.00,0.00,0.00),('1','194','1012','257999',4905277,'2993','460',2887028.57,2887028.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905278,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905279,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905280,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905281,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905282,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905283,'2999','460',40222.14,40222.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','257999',4905284,'3000','460',17386.89,17386.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258000',4905285,'2993','460',2887028.57,2897568.73,0.00,0.00,10540.16,6938921.60,0.00,0.00,0.00),('1','194','1012','258000',4905286,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258000',4905287,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258000',4905288,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258000',4905289,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258000',4905290,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258000',4905291,'2999','460',40222.14,41127.42,0.00,0.00,905.28,633696.00,0.00,0.00,0.00),('1','194','1012','258000',4905292,'3000','460',17386.89,18434.57,0.00,0.00,1047.68,733376.00,0.00,0.00,0.00),('1','194','1012','258001',4905293,'2993','460',2897568.73,2902833.71,0.00,0.00,5264.98,3474886.80,0.00,0.00,0.00),('1','194','1012','258001',4905294,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258001',4905295,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258001',4905296,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258001',4905297,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258001',4905298,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258001',4905299,'2999','460',41127.42,41607.59,0.00,0.00,480.17,336119.00,0.00,0.00,0.00),('1','194','1012','258001',4905300,'3000','460',18434.57,18967.26,0.00,0.00,532.69,372883.00,0.00,0.00,0.00),('1','194','1012','258002',4905301,'2993','460',2902833.71,2908087.71,0.00,0.00,5254.00,3455004.00,0.00,0.00,0.00),('1','194','1012','258002',4905302,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258002',4905303,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258002',4905304,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258002',4905305,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258002',4905306,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258002',4905307,'2999','460',41607.59,41812.73,0.00,0.00,205.14,143598.00,0.00,0.00,0.00),('1','194','1012','258002',4905308,'3000','460',18967.26,19413.97,0.00,0.00,446.71,312697.00,0.00,0.00,0.00),('1','194','1012','258003',4905309,'2993','460',2908087.71,2908087.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905310,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905311,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905312,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905313,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905314,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905315,'2999','460',41812.73,41812.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258003',4905316,'3000','460',19413.97,19413.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258004',4905317,'2993','460',2908087.71,2912012.08,0.00,0.00,3924.37,2590084.20,0.00,0.00,0.00),('1','194','1012','258004',4905318,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258004',4905319,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258004',4905320,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258004',4905321,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258004',4905322,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258004',4905323,'2999','460',41812.73,42080.94,0.00,0.00,268.21,187747.00,0.00,0.00,0.00),('1','194','1012','258004',4905324,'3000','460',19413.97,19661.61,0.00,0.00,247.64,173348.00,0.00,0.00,0.00),('1','194','1012','258005',4905325,'2993','460',2912012.08,2914811.08,0.00,0.00,2799.00,1847340.00,0.00,0.00,0.00),('1','194','1012','258005',4905326,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258005',4905327,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258005',4905328,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258005',4905329,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258005',4905330,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258005',4905331,'2999','460',42080.94,42476.44,0.00,0.00,395.50,276850.00,0.00,0.00,0.00),('1','194','1012','258005',4905332,'3000','460',19661.61,20226.12,0.00,0.00,564.51,395157.00,0.00,0.00,0.00),('1','194','1012','258006',4905333,'2993','460',2914811.08,2921502.38,0.00,0.00,6691.30,4408222.00,0.00,0.00,0.00),('1','194','1012','258006',4905334,'2994','460',1757.50,1757.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258006',4905335,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258006',4905336,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258006',4905337,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258006',4905338,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258006',4905339,'2999','460',42476.44,42953.07,0.00,0.00,476.63,333641.00,0.00,0.00,0.00),('1','194','1012','258006',4905340,'3000','460',20226.12,20892.60,0.00,0.00,666.48,466536.00,0.00,0.00,0.00),('1','194','1012','258007',4905341,'2993','460',2921502.38,2926051.08,0.00,0.00,4548.70,2994962.00,0.00,0.00,0.00),('1','194','1012','258007',4905342,'2994','460',1757.50,1795.50,0.00,0.00,38.00,25080.00,0.00,0.00,0.00),('1','194','1012','258007',4905343,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258007',4905344,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258007',4905345,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258007',4905346,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258007',4905347,'2999','460',42953.07,43534.28,0.00,0.00,581.21,406847.00,0.00,0.00,0.00),('1','194','1012','258007',4905348,'3000','460',20892.60,21618.80,0.00,0.00,726.20,508340.00,0.00,0.00,0.00),('1','194','1012','258008',4905349,'2993','460',2926051.08,2928371.58,0.00,0.00,2320.50,1531530.00,0.00,0.00,0.00),('1','194','1012','258008',4905350,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258008',4905351,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258008',4905352,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258008',4905353,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258008',4905354,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258008',4905355,'2999','460',43534.28,43758.78,0.00,0.00,224.50,157150.00,0.00,0.00,0.00),('1','194','1012','258008',4905356,'3000','460',21618.80,21878.22,0.00,0.00,259.42,181594.00,0.00,0.00,0.00),('1','194','1012','258009',4905357,'2993','460',2928371.58,2928371.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905358,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905359,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905360,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905361,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905362,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905363,'2999','460',43758.78,43758.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258009',4905364,'3000','460',21878.22,21878.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258010',4905365,'2993','460',2928371.58,2929633.08,0.00,0.00,1261.50,832590.00,0.00,0.00,0.00),('1','194','1012','258010',4905366,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258010',4905367,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258010',4905368,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258010',4905369,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258010',4905370,'2998','460',29980.90,29980.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258010',4905371,'2999','460',43758.78,44233.39,0.00,0.00,474.61,332227.00,0.00,0.00,0.00),('1','194','1012','258010',4905372,'3000','460',21878.22,22369.08,0.00,0.00,490.86,343602.00,0.00,0.00,0.00),('1','194','1012','258011',4905373,'2993','460',2929633.08,2938241.21,0.00,0.00,8608.13,5665367.80,0.00,0.00,0.00),('1','194','1012','258011',4905374,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258011',4905375,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258011',4905376,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258011',4905377,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258011',4905378,'2998','460',29980.90,29982.90,0.00,0.00,2.00,1400.00,0.00,0.00,0.00),('1','194','1012','258011',4905379,'2999','460',44233.39,45084.31,0.00,0.00,850.92,595644.00,0.00,0.00,0.00),('1','194','1012','258011',4905380,'3000','460',22369.08,23164.30,0.00,0.00,795.22,556654.00,0.00,0.00,0.00),('1','194','1012','258012',4905381,'2993','460',2938241.21,2944179.71,0.00,0.00,5938.50,3914758.00,0.00,0.00,0.00),('1','194','1012','258012',4905382,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258012',4905383,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258012',4905384,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258012',4905385,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258012',4905386,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258012',4905387,'2999','460',45084.31,45464.73,0.00,0.00,380.42,266294.00,0.00,0.00,0.00),('1','194','1012','258012',4905388,'3000','460',23164.30,23900.65,0.00,0.00,736.35,515445.00,0.00,0.00,0.00),('1','194','1012','258013',4905389,'2993','460',2944179.71,2948707.71,0.00,0.00,4528.00,2988480.00,0.00,0.00,0.00),('1','194','1012','258013',4905390,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258013',4905391,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258013',4905392,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258013',4905393,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258013',4905394,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258013',4905395,'2999','460',45464.73,45805.44,0.00,0.00,340.71,238497.00,0.00,0.00,0.00),('1','194','1012','258013',4905396,'3000','460',23900.65,24139.30,0.00,0.00,238.65,167055.00,0.00,0.00,0.00),('1','194','1012','258014',4905397,'2993','460',2948707.71,2948707.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905398,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905399,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905400,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905401,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905402,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905403,'2999','460',45805.44,45805.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258014',4905404,'3000','460',24139.30,24139.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258015',4905405,'2993','460',2948707.71,2953029.71,0.00,0.00,4322.00,2843364.00,0.00,0.00,0.00),('1','194','1012','258015',4905406,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258015',4905407,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258015',4905408,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258015',4905409,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258015',4905410,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258015',4905411,'2999','460',45805.44,46430.37,0.00,0.00,624.93,437451.00,0.00,0.00,0.00),('1','194','1012','258015',4905412,'3000','460',24139.30,24905.70,0.00,0.00,766.40,536480.00,0.00,0.00,0.00),('1','194','1012','258016',4905413,'2993','460',2953029.71,2960330.21,0.00,0.00,7300.50,4801972.00,0.00,0.00,0.00),('1','194','1012','258016',4905414,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258016',4905415,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258016',4905416,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258016',4905417,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258016',4905418,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258016',4905419,'2999','460',46430.37,47129.59,0.00,0.00,699.22,489454.00,0.00,0.00,0.00),('1','194','1012','258016',4905420,'3000','460',24905.70,25566.33,0.00,0.00,660.63,462441.00,0.00,0.00,0.00),('1','194','1012','258017',4905421,'2993','460',2960330.21,2969223.71,0.00,0.00,8893.50,5851542.00,0.00,0.00,0.00),('1','194','1012','258017',4905422,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258017',4905423,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258017',4905424,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258017',4905425,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258017',4905426,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258017',4905427,'2999','460',47129.59,47591.92,0.00,0.00,462.33,323631.00,0.00,0.00,0.00),('1','194','1012','258017',4905428,'3000','460',25566.33,25974.62,0.00,0.00,408.29,285803.00,0.00,0.00,0.00),('1','194','1012','258018',4905429,'2993','460',2969223.71,2969223.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905430,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905431,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905432,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905433,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905434,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905435,'2999','460',47591.92,47591.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258018',4905436,'3000','460',25974.62,25974.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258019',4905437,'2993','460',2969223.71,2971645.71,0.00,0.00,2422.00,1598520.00,0.00,0.00,0.00),('1','194','1012','258019',4905438,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258019',4905439,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258019',4905440,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258019',4905441,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258019',4905442,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258019',4905443,'2999','460',47591.92,47802.08,0.00,0.00,210.16,147112.00,0.00,0.00,0.00),('1','194','1012','258019',4905444,'3000','460',25974.62,26262.69,0.00,0.00,288.07,201649.00,0.00,0.00,0.00),('1','194','1012','258020',4905445,'2993','460',2971645.71,2983262.71,0.00,0.00,11617.00,7643164.00,0.00,0.00,0.00),('1','194','1012','258020',4905446,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258020',4905447,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258020',4905448,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258020',4905449,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258020',4905450,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258020',4905451,'2999','460',47802.08,48594.12,0.00,0.00,792.04,554428.00,0.00,0.00,0.00),('1','194','1012','258020',4905452,'3000','460',26262.69,27058.39,0.00,0.00,795.70,556990.00,0.00,0.00,0.00),('1','194','1012','258021',4905453,'2993','460',2983262.71,2990858.71,0.00,0.00,7596.00,4993124.00,0.00,0.00,0.00),('1','194','1012','258021',4905454,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258021',4905455,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258021',4905456,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258021',4905457,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258021',4905458,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258021',4905459,'2999','460',48594.12,48920.10,0.00,0.00,325.98,228186.00,0.00,0.00,0.00),('1','194','1012','258021',4905460,'3000','460',27058.39,27339.46,0.00,0.00,281.07,196749.00,0.00,0.00,0.00),('1','194','1012','258022',4905461,'2993','460',2990858.71,2990858.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905462,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905463,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905464,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905465,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905466,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905467,'2999','460',48920.10,48920.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258022',4905468,'3000','460',27339.46,27339.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258023',4905469,'2993','460',2990858.71,2992164.71,0.00,0.00,1306.00,861960.00,0.00,0.00,0.00),('1','194','1012','258023',4905470,'2994','460',1795.50,1795.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258023',4905471,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258023',4905472,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258023',4905473,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258023',4905474,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258023',4905475,'2999','460',48920.10,49311.88,0.00,0.00,391.78,274246.00,0.00,0.00,0.00),('1','194','1012','258023',4905476,'3000','460',27339.46,27589.67,0.00,0.00,250.21,175147.00,0.00,0.00,0.00),('1','194','1012','258024',4905477,'2993','460',2992164.71,3003476.21,0.00,0.00,11311.50,7449616.00,0.00,0.00,0.00),('1','194','1012','258024',4905478,'2994','460',1795.50,1849.50,0.00,0.00,54.00,35640.00,0.00,0.00,0.00),('1','194','1012','258024',4905479,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258024',4905480,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258024',4905481,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258024',4905482,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258024',4905483,'2999','460',49311.88,50558.75,0.00,0.00,1246.87,872809.00,0.00,0.00,0.00),('1','194','1012','258024',4905484,'3000','460',27589.67,28489.89,0.00,0.00,900.22,630154.00,0.00,0.00,0.00),('1','194','1012','258025',4905485,'2993','460',3003476.21,3007497.55,0.00,0.00,4021.34,2654084.40,0.00,0.00,0.00),('1','194','1012','258025',4905486,'2994','460',1849.50,2213.50,0.00,0.00,364.00,240240.00,0.00,0.00,0.00),('1','194','1012','258025',4905487,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258025',4905488,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258025',4905489,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258025',4905490,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258025',4905491,'2999','460',50558.75,51274.45,0.00,0.00,715.70,500990.00,0.00,0.00,0.00),('1','194','1012','258025',4905492,'3000','460',28489.89,29188.43,0.00,0.00,698.54,488978.00,0.00,0.00,0.00),('1','194','1012','258026',4905493,'2993','460',3007497.55,3009688.45,0.00,0.00,2190.90,1445994.00,0.00,0.00,0.00),('1','194','1012','258026',4905494,'2994','460',2213.50,2213.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258026',4905495,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258026',4905496,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258026',4905497,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258026',4905498,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258026',4905499,'2999','460',51274.45,51374.09,0.00,0.00,99.64,69748.00,0.00,0.00,0.00),('1','194','1012','258026',4905500,'3000','460',29188.43,29308.71,0.00,0.00,120.28,84196.00,0.00,0.00,0.00),('1','194','1012','258027',4905501,'2993','460',3009688.45,3009688.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905502,'2994','460',2213.50,2213.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905503,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905504,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905505,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905506,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905507,'2999','460',51374.09,51374.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258027',4905508,'3000','460',29308.71,29308.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258028',4905509,'2993','460',3009688.45,3018898.66,0.00,0.00,9210.21,6066438.60,0.00,0.00,0.00),('1','194','1012','258028',4905510,'2994','460',2213.50,2263.50,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','194','1012','258028',4905511,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258028',4905512,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258028',4905513,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258028',4905514,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258028',4905515,'2999','460',51374.09,52115.72,0.00,0.00,741.63,519141.00,0.00,0.00,0.00),('1','194','1012','258028',4905516,'3000','460',29308.71,30509.35,0.00,0.00,1200.64,840448.00,0.00,0.00,0.00),('1','194','1012','258029',4905517,'2993','460',3018898.66,3026389.16,0.00,0.00,7490.50,4928704.00,0.00,0.00,0.00),('1','194','1012','258029',4905518,'2994','460',2263.50,2313.50,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','194','1012','258029',4905519,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258029',4905520,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258029',4905521,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258029',4905522,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258029',4905523,'2999','460',52115.72,52923.52,0.00,0.00,807.80,565460.00,0.00,0.00,0.00),('1','194','1012','258029',4905524,'3000','460',30509.35,31269.61,0.00,0.00,760.26,532182.00,0.00,0.00,0.00),('1','194','1012','258030',4905525,'2993','460',3026389.16,3030006.66,0.00,0.00,3617.50,2378672.00,0.00,0.00,0.00),('1','194','1012','258030',4905526,'2994','460',2313.50,2510.50,0.00,0.00,197.00,130020.00,0.00,0.00,0.00),('1','194','1012','258030',4905527,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258030',4905528,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258030',4905529,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258030',4905530,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258030',4905531,'2999','460',52923.52,53196.39,0.00,0.00,272.87,191009.00,0.00,0.00,0.00),('1','194','1012','258030',4905532,'3000','460',31269.61,31554.25,0.00,0.00,284.64,199248.00,0.00,0.00,0.00),('1','194','1012','258031',4905533,'2993','460',3030006.66,3030006.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905534,'2994','460',2510.50,2510.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905535,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905536,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905537,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905538,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905539,'2999','460',53196.39,53196.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258031',4905540,'3000','460',31554.25,31554.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258032',4905541,'2993','460',3030006.66,3045086.16,0.00,0.00,15079.50,9925018.00,0.00,0.00,0.00),('1','194','1012','258032',4905542,'2994','460',2510.50,2786.00,0.00,0.00,275.50,181830.00,0.00,0.00,0.00),('1','194','1012','258032',4905543,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258032',4905544,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258032',4905545,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258032',4905546,'2998','460',29982.90,29982.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258032',4905547,'2999','460',53196.39,54183.87,0.00,0.00,987.48,691236.00,0.00,0.00,0.00),('1','194','1012','258032',4905548,'3000','460',31554.25,32421.10,0.00,0.00,866.85,606795.00,0.00,0.00,0.00),('1','194','1012','258033',4905549,'2993','460',3045086.16,3051133.66,0.00,0.00,6047.50,3980534.00,0.00,0.00,0.00),('1','194','1012','258033',4905550,'2994','460',2786.00,2786.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258033',4905551,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258033',4905552,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258033',4905553,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258033',4905554,'2998','460',29982.90,29992.90,0.00,0.00,10.00,7000.00,0.00,0.00,0.00),('1','194','1012','258033',4905555,'2999','460',54183.87,55041.45,0.00,0.00,857.58,600306.00,0.00,0.00,0.00),('1','194','1012','258033',4905556,'3000','460',32421.10,32943.42,0.00,0.00,522.32,365624.00,0.00,0.00,0.00),('1','194','1012','258034',4905557,'2993','460',3051133.66,3051133.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905558,'2994','460',2786.00,2786.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905559,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905560,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905561,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905562,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905563,'2999','460',55041.45,55041.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258034',4905564,'3000','460',32943.42,32943.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258035',4905565,'2993','460',3051133.66,3061416.16,0.00,0.00,10282.50,6765898.00,0.00,0.00,0.00),('1','194','1012','258035',4905566,'2994','460',2786.00,3130.00,0.00,0.00,344.00,227040.00,0.00,0.00,0.00),('1','194','1012','258035',4905567,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258035',4905568,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258035',4905569,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258035',4905570,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258035',4905571,'2999','460',55041.45,56191.44,0.00,0.00,1149.99,804993.00,0.00,0.00,0.00),('1','194','1012','258035',4905572,'3000','460',32943.42,34047.62,0.00,0.00,1104.20,772940.00,0.00,0.00,0.00),('1','194','1012','258036',4905573,'2993','460',3061416.16,3067897.16,0.00,0.00,6481.00,4264622.00,0.00,0.00,0.00),('1','194','1012','258036',4905574,'2994','460',3130.00,4229.00,0.00,0.00,1099.00,725340.00,0.00,0.00,0.00),('1','194','1012','258036',4905575,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258036',4905576,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258036',4905577,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258036',4905578,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258036',4905579,'2999','460',56191.44,56929.23,0.00,0.00,737.79,516453.00,0.00,0.00,0.00),('1','194','1012','258036',4905580,'3000','460',34047.62,34722.27,0.00,0.00,674.65,472255.00,0.00,0.00,0.00),('1','194','1012','258037',4905581,'2993','460',3067897.16,3070387.37,0.00,0.00,2490.21,1643538.60,0.00,0.00,0.00),('1','194','1012','258037',4905582,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258037',4905583,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258037',4905584,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258037',4905585,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258037',4905586,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258037',4905587,'2999','460',56929.23,57137.57,0.00,0.00,208.34,145838.00,0.00,0.00,0.00),('1','194','1012','258037',4905588,'3000','460',34722.27,34784.84,0.00,0.00,62.57,43799.00,0.00,0.00,0.00),('1','194','1012','258038',4905589,'2993','460',3070387.37,3070387.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905590,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905591,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905592,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905593,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905594,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905595,'2999','460',57137.57,57137.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258038',4905596,'3000','460',34784.84,34784.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258039',4905597,'2993','460',3070387.37,3079385.16,0.00,0.00,8997.79,5668607.70,0.00,0.00,0.00),('1','194','1012','258039',4905598,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258039',4905599,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258039',4905600,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258039',4905601,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258039',4905602,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258039',4905603,'2999','460',57137.57,57929.85,0.00,0.00,792.28,554596.00,0.00,0.00,0.00),('1','194','1012','258039',4905604,'3000','460',34784.84,35420.89,0.00,0.00,636.05,445235.00,0.00,0.00,0.00),('1','194','1012','258040',4905605,'2993','460',3079385.16,3088278.16,0.00,0.00,8893.00,5602590.00,0.00,0.00,0.00),('1','194','1012','258040',4905606,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258040',4905607,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258040',4905608,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258040',4905609,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258040',4905610,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258040',4905611,'2999','460',57929.85,58892.49,0.00,0.00,962.64,673848.00,0.00,0.00,0.00),('1','194','1012','258040',4905612,'3000','460',35420.89,36173.97,0.00,0.00,753.08,527156.00,0.00,0.00,0.00),('1','194','1012','258041',4905613,'2993','460',3088278.16,3091492.66,0.00,0.00,3214.50,2025135.00,0.00,0.00,0.00),('1','194','1012','258041',4905614,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258041',4905615,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258041',4905616,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258041',4905617,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258041',4905618,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258041',4905619,'2999','460',58892.49,59083.58,0.00,0.00,191.09,133763.00,0.00,0.00,0.00),('1','194','1012','258041',4905620,'3000','460',36173.97,36290.62,0.00,0.00,116.65,81655.00,0.00,0.00,0.00),('1','194','1012','258042',4905621,'2993','460',3091492.66,3091492.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905622,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905623,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905624,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905625,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905626,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905627,'2999','460',59083.58,59083.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258042',4905628,'3000','460',36290.62,36290.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258043',4905629,'2993','460',3091492.66,3096286.66,0.00,0.00,4794.00,3020220.00,0.00,0.00,0.00),('1','194','1012','258043',4905630,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258043',4905631,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258043',4905632,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258043',4905633,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258043',4905634,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258043',4905635,'2999','460',59083.58,59619.31,0.00,0.00,535.73,375011.00,0.00,0.00,0.00),('1','194','1012','258043',4905636,'3000','460',36290.62,36784.58,0.00,0.00,493.96,345772.00,0.00,0.00,0.00),('1','194','1012','258044',4905637,'2993','460',3096286.66,3105790.66,0.00,0.00,9504.00,5987520.00,0.00,0.00,0.00),('1','194','1012','258044',4905638,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258044',4905639,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258044',4905640,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258044',4905641,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258044',4905642,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258044',4905643,'2999','460',59619.31,60595.59,0.00,0.00,976.28,683396.00,0.00,0.00,0.00),('1','194','1012','258044',4905644,'3000','460',36784.58,37537.02,0.00,0.00,752.44,526708.00,0.00,0.00,0.00),('1','194','1012','258045',4905645,'2993','460',3105790.66,3112391.16,0.00,0.00,6600.50,4158315.00,0.00,0.00,0.00),('1','194','1012','258045',4905646,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258045',4905647,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258045',4905648,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258045',4905649,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258045',4905650,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258045',4905651,'2999','460',60595.59,61079.59,0.00,0.00,484.00,338800.00,0.00,0.00,0.00),('1','194','1012','258045',4905652,'3000','460',37537.02,38048.43,0.00,0.00,511.41,357987.00,0.00,0.00,0.00),('1','194','1012','258046',4905653,'2993','460',3112391.16,3112391.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905654,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905655,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905656,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905657,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905658,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905659,'2999','460',61079.59,61079.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258046',4905660,'3000','460',38048.43,38048.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258047',4905661,'2993','460',3112391.16,3122972.66,0.00,0.00,10581.50,6772160.00,0.00,0.00,0.00),('1','194','1012','258047',4905662,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258047',4905663,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258047',4905664,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258047',4905665,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258047',4905666,'2998','460',29992.90,29992.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258047',4905667,'2999','460',61079.59,62053.44,0.00,0.00,973.85,681695.00,0.00,0.00,0.00),('1','194','1012','258047',4905668,'3000','460',38048.43,39189.10,0.00,0.00,1140.67,798469.00,0.00,0.00,0.00),('1','194','1012','258048',4905669,'2993','460',3122972.66,3132354.28,0.00,0.00,9381.62,6004236.80,0.00,0.00,0.00),('1','194','1012','258048',4905670,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258048',4905671,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258048',4905672,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258048',4905673,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258048',4905674,'2998','460',29992.90,29996.90,0.00,0.00,4.00,2800.00,0.00,0.00,0.00),('1','194','1012','258048',4905675,'2999','460',62053.44,62884.41,0.00,0.00,830.97,581679.00,0.00,0.00,0.00),('1','194','1012','258048',4905676,'3000','460',39189.10,40029.62,0.00,0.00,840.52,588364.00,0.00,0.00,0.00),('1','194','1012','258049',4905677,'2993','460',3132354.28,3133079.28,0.00,0.00,725.00,464000.00,0.00,0.00,0.00),('1','194','1012','258049',4905678,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258049',4905679,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258049',4905680,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258049',4905681,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258049',4905682,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258049',4905683,'2999','460',62884.41,62928.98,0.00,0.00,44.57,31199.00,0.00,0.00,0.00),('1','194','1012','258049',4905684,'3000','460',40029.62,40196.59,0.00,0.00,166.97,116879.00,0.00,0.00,0.00),('1','194','1012','258050',4905685,'2993','460',3133079.28,3133079.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905686,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905687,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905688,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905689,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905690,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905691,'2999','460',62928.98,62928.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258050',4905692,'3000','460',40196.59,40196.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258051',4905693,'2993','460',3133079.28,3141375.09,0.00,0.00,8295.81,5312318.40,0.00,0.00,0.00),('1','194','1012','258051',4905694,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258051',4905695,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258051',4905696,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258051',4905697,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258051',4905698,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258051',4905699,'2999','460',62928.98,64058.01,0.00,0.00,1129.03,790321.00,0.00,0.00,0.00),('1','194','1012','258051',4905700,'3000','460',40196.59,40862.14,0.00,0.00,665.55,465885.00,0.00,0.00,0.00),('1','194','1012','258052',4905701,'2993','460',3141375.09,3148590.09,0.00,0.00,7215.00,4617600.00,0.00,0.00,0.00),('1','194','1012','258052',4905702,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258052',4905703,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258052',4905704,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258052',4905705,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258052',4905706,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258052',4905707,'2999','460',64058.01,64795.44,0.00,0.00,737.43,516201.00,0.00,0.00,0.00),('1','194','1012','258052',4905708,'3000','460',40862.14,41614.69,0.00,0.00,752.55,526785.00,0.00,0.00,0.00),('1','194','1012','258053',4905709,'2993','460',3148590.09,3154093.92,0.00,0.00,5503.83,3522451.20,0.00,0.00,0.00),('1','194','1012','258053',4905710,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258053',4905711,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258053',4905712,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258053',4905713,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258053',4905714,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258053',4905715,'2999','460',64795.44,64933.65,0.00,0.00,138.21,96747.00,0.00,0.00,0.00),('1','194','1012','258053',4905716,'3000','460',41614.69,41829.97,0.00,0.00,215.28,150696.00,0.00,0.00,0.00),('1','194','1012','258054',4905717,'2993','460',3154093.92,3154093.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905718,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905719,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905720,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905721,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905722,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905723,'2999','460',64933.65,64933.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258054',4905724,'3000','460',41829.97,41829.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258055',4905725,'2993','460',3154093.92,3157833.94,0.00,0.00,3740.02,2393612.80,0.00,0.00,0.00),('1','194','1012','258055',4905726,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258055',4905727,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258055',4905728,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258055',4905729,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258055',4905730,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258055',4905731,'2999','460',64933.65,65370.93,0.00,0.00,437.28,306096.00,0.00,0.00,0.00),('1','194','1012','258055',4905732,'3000','460',41829.97,42374.26,0.00,0.00,544.29,381003.00,0.00,0.00,0.00),('1','194','1012','258056',4905733,'2993','460',3157833.94,3164518.44,0.00,0.00,6684.50,4278080.00,0.00,0.00,0.00),('1','194','1012','258056',4905734,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258056',4905735,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258056',4905736,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258056',4905737,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258056',4905738,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258056',4905739,'2999','460',65370.93,66114.15,0.00,0.00,743.22,520254.00,0.00,0.00,0.00),('1','194','1012','258056',4905740,'3000','460',42374.26,43409.05,0.00,0.00,1034.79,724353.00,0.00,0.00,0.00),('1','194','1012','258057',4905741,'2993','460',3164518.44,3171059.76,0.00,0.00,6541.32,4186444.80,0.00,0.00,0.00),('1','194','1012','258057',4905742,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258057',4905743,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258057',4905744,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258057',4905745,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258057',4905746,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258057',4905747,'2999','460',66114.15,66606.51,0.00,0.00,492.36,344652.00,0.00,0.00,0.00),('1','194','1012','258057',4905748,'3000','460',43409.05,44192.74,0.00,0.00,783.69,548583.00,0.00,0.00,0.00),('1','194','1012','258058',4905749,'2993','460',3171059.76,3173271.26,0.00,0.00,2211.50,1415360.00,0.00,0.00,0.00),('1','194','1012','258058',4905750,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258058',4905751,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258058',4905752,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258058',4905753,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258058',4905754,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258058',4905755,'2999','460',66606.51,66718.94,0.00,0.00,112.43,78701.00,0.00,0.00,0.00),('1','194','1012','258058',4905756,'3000','460',44192.74,44389.88,0.00,0.00,197.14,137998.00,0.00,0.00,0.00),('1','194','1012','258059',4905757,'2993','460',3173271.26,3173271.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905758,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905759,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905760,'2996','460',14.50,14.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905761,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905762,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905763,'2999','460',66718.94,66718.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258059',4905764,'3000','460',44389.88,44389.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258060',4905765,'2993','460',3173271.26,3180391.26,0.00,0.00,7120.00,4556800.00,0.00,0.00,0.00),('1','194','1012','258060',4905766,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258060',4905767,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258060',4905768,'2996','460',14.50,27.00,0.00,0.00,12.50,8750.00,0.00,0.00,0.00),('1','194','1012','258060',4905769,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258060',4905770,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258060',4905771,'2999','460',66718.94,67349.36,0.00,0.00,630.42,441294.00,0.00,0.00,0.00),('1','194','1012','258060',4905772,'3000','460',44389.88,45110.25,0.00,0.00,720.37,504259.00,0.00,0.00,0.00),('1','194','1012','258061',4905773,'2993','460',3180391.26,3184361.76,0.00,0.00,3970.50,2541120.00,0.00,0.00,0.00),('1','194','1012','258061',4905774,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258061',4905775,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258061',4905776,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258061',4905777,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258061',4905778,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258061',4905779,'2999','460',67349.36,67860.15,0.00,0.00,510.79,357553.00,0.00,0.00,0.00),('1','194','1012','258061',4905780,'3000','460',45110.25,45857.68,0.00,0.00,747.43,523201.00,0.00,0.00,0.00),('1','194','1012','258062',4905781,'2993','460',3184361.76,3194157.05,0.00,0.00,9795.29,6268985.60,0.00,0.00,0.00),('1','194','1012','258062',4905782,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258062',4905783,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258062',4905784,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258062',4905785,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258062',4905786,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258062',4905787,'2999','460',67860.15,68290.38,0.00,0.00,430.23,301161.00,0.00,0.00,0.00),('1','194','1012','258062',4905788,'3000','460',45857.68,46686.83,0.00,0.00,829.15,580405.00,0.00,0.00,0.00),('1','194','1012','258063',4905789,'2993','460',3194157.05,3194157.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905790,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905791,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905792,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905793,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905794,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905795,'2999','460',68290.38,68290.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258063',4905796,'3000','460',46686.83,46686.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258064',4905797,'2993','460',3194157.05,3196914.05,0.00,0.00,2757.00,1764480.00,0.00,0.00,0.00),('1','194','1012','258064',4905798,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258064',4905799,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258064',4905800,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258064',4905801,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258064',4905802,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258064',4905803,'2999','460',68290.38,68629.09,0.00,0.00,338.71,237097.00,0.00,0.00,0.00),('1','194','1012','258064',4905804,'3000','460',46686.83,46993.34,0.00,0.00,306.51,214557.00,0.00,0.00,0.00),('1','194','1012','258065',4905805,'2993','460',3196914.05,3205063.00,0.00,0.00,8148.95,5215328.00,0.00,0.00,0.00),('1','194','1012','258065',4905806,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258065',4905807,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258065',4905808,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258065',4905809,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258065',4905810,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258065',4905811,'2999','460',68629.09,69313.23,0.00,0.00,684.14,478898.00,0.00,0.00,0.00),('1','194','1012','258065',4905812,'3000','460',46993.34,47783.67,0.00,0.00,790.33,553231.00,0.00,0.00,0.00),('1','194','1012','258066',4905813,'2993','460',3205063.00,3211010.00,0.00,0.00,5947.00,3806080.00,0.00,0.00,0.00),('1','194','1012','258066',4905814,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258066',4905815,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258066',4905816,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258066',4905817,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258066',4905818,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258066',4905819,'2999','460',69313.23,70117.95,0.00,0.00,804.72,563304.00,0.00,0.00,0.00),('1','194','1012','258066',4905820,'3000','460',47783.67,48639.12,0.00,0.00,855.45,598815.00,0.00,0.00,0.00),('1','194','1012','258067',4905821,'2993','460',3211010.00,3214568.00,0.00,0.00,3558.00,2277120.00,0.00,0.00,0.00),('1','194','1012','258067',4905822,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258067',4905823,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258067',4905824,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258067',4905825,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258067',4905826,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258067',4905827,'2999','460',70117.95,70266.30,0.00,0.00,148.35,103845.00,0.00,0.00,0.00),('1','194','1012','258067',4905828,'3000','460',48639.12,48952.62,0.00,0.00,313.50,219450.00,0.00,0.00,0.00),('1','194','1012','258068',4905829,'2993','460',3214568.00,3214568.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905830,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905831,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905832,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905833,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905834,'2998','460',29996.90,29996.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905835,'2999','460',70266.30,70266.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258068',4905836,'3000','460',48952.62,48952.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258069',4905837,'2993','460',3214568.00,3216982.50,0.00,0.00,2414.50,1545280.00,0.00,0.00,0.00),('1','194','1012','258069',4905838,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258069',4905839,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258069',4905840,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258069',4905841,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258069',4905842,'2998','460',29996.90,30006.90,0.00,0.00,10.00,7000.00,0.00,0.00,0.00),('1','194','1012','258069',4905843,'2999','460',70266.30,70776.95,0.00,0.00,510.65,357455.00,0.00,0.00,0.00),('1','194','1012','258069',4905844,'3000','460',48952.62,49733.13,0.00,0.00,780.51,546357.00,0.00,0.00,0.00),('1','194','1012','258070',4905845,'2993','460',3216982.50,3222676.00,0.00,0.00,5693.50,3643840.00,0.00,0.00,0.00),('1','194','1012','258070',4905846,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258070',4905847,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258070',4905848,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258070',4905849,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258070',4905850,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258070',4905851,'2999','460',70776.95,71253.17,0.00,0.00,476.22,333354.00,0.00,0.00,0.00),('1','194','1012','258070',4905852,'3000','460',49733.13,50569.22,0.00,0.00,836.09,585263.00,0.00,0.00,0.00),('1','194','1012','258071',4905853,'2993','460',3222676.00,3233959.00,0.00,0.00,11283.00,7221120.00,0.00,0.00,0.00),('1','194','1012','258071',4905854,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258071',4905855,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258071',4905856,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258071',4905857,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258071',4905858,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258071',4905859,'2999','460',71253.17,71807.32,0.00,0.00,554.15,387905.00,0.00,0.00,0.00),('1','194','1012','258071',4905860,'3000','460',50569.22,51725.49,0.00,0.00,1156.27,809389.00,0.00,0.00,0.00),('1','194','1012','258072',4905861,'2993','460',3233959.00,3234159.00,0.00,0.00,200.00,128000.00,0.00,0.00,0.00),('1','194','1012','258072',4905862,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258072',4905863,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258072',4905864,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258072',4905865,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258072',4905866,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258072',4905867,'2999','460',71807.32,72073.64,0.00,0.00,266.32,186424.00,0.00,0.00,0.00),('1','194','1012','258072',4905868,'3000','460',51725.49,51927.49,0.00,0.00,202.00,141400.00,0.00,0.00,0.00),('1','194','1012','258073',4905869,'2993','460',3234159.00,3234159.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905870,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905871,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905872,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905873,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905874,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905875,'2999','460',72073.64,72073.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258073',4905876,'3000','460',51927.49,51927.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258074',4905877,'2993','460',3234159.00,3239548.00,0.00,0.00,5389.00,3448960.00,0.00,0.00,0.00),('1','194','1012','258074',4905878,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258074',4905879,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258074',4905880,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258074',4905881,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258074',4905882,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258074',4905883,'2999','460',72073.64,72357.64,0.00,0.00,284.00,198800.00,0.00,0.00,0.00),('1','194','1012','258074',4905884,'3000','460',51927.49,52396.11,0.00,0.00,468.62,328034.00,0.00,0.00,0.00),('1','194','1012','258075',4905885,'2993','460',3239548.00,3251838.94,0.00,0.00,12290.94,7866201.60,0.00,0.00,0.00),('1','194','1012','258075',4905886,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258075',4905887,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258075',4905888,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258075',4905889,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258075',4905890,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258075',4905891,'2999','460',72357.64,72784.64,0.00,0.00,427.00,298900.00,0.00,0.00,0.00),('1','194','1012','258075',4905892,'3000','460',52396.11,54092.68,0.00,0.00,1696.57,1187599.00,0.00,0.00,0.00),('1','194','1012','258076',4905893,'2993','460',3251838.94,3255265.94,0.00,0.00,3427.00,2193280.00,0.00,0.00,0.00),('1','194','1012','258076',4905894,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258076',4905895,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258076',4905896,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258076',4905897,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258076',4905898,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258076',4905899,'2999','460',72784.64,72856.62,0.00,0.00,71.98,50386.00,0.00,0.00,0.00),('1','194','1012','258076',4905900,'3000','460',54092.68,54214.12,0.00,0.00,121.44,85008.00,0.00,0.00,0.00),('1','194','1012','258077',4905901,'2993','460',3255265.94,3255265.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905902,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905903,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905904,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905905,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905906,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905907,'2999','460',72856.62,72856.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258077',4905908,'3000','460',54214.12,54214.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258078',4905909,'2993','460',3255265.94,3263492.44,0.00,0.00,8226.50,5264960.00,0.00,0.00,0.00),('1','194','1012','258078',4905910,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258078',4905911,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258078',4905912,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258078',4905913,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258078',4905914,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258078',4905915,'2999','460',72856.62,73331.70,0.00,0.00,475.08,332556.00,0.00,0.00,0.00),('1','194','1012','258078',4905916,'3000','460',54214.12,55324.29,0.00,0.00,1110.17,777119.00,0.00,0.00,0.00),('1','194','1012','258079',4905917,'2993','460',3263492.44,3270218.94,0.00,0.00,6726.50,4304960.00,0.00,0.00,0.00),('1','194','1012','258079',4905918,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258079',4905919,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258079',4905920,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258079',4905921,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258079',4905922,'2998','460',30006.90,30006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258079',4905923,'2999','460',73331.70,74013.85,0.00,0.00,682.15,477505.00,0.00,0.00,0.00),('1','194','1012','258079',4905924,'3000','460',55324.29,56060.08,0.00,0.00,735.79,515053.00,0.00,0.00,0.00),('1','194','1012','258080',4905925,'2993','460',3270218.94,3274926.44,0.00,0.00,4707.50,3012800.00,0.00,0.00,0.00),('1','194','1012','258080',4905926,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258080',4905927,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258080',4905928,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258080',4905929,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258080',4905930,'2998','460',30006.90,30017.19,0.00,0.00,10.29,7203.00,0.00,0.00,0.00),('1','194','1012','258080',4905931,'2999','460',74013.85,74740.71,0.00,0.00,726.86,508802.00,0.00,0.00,0.00),('1','194','1012','258080',4905932,'3000','460',56060.08,56929.23,0.00,0.00,869.15,608405.00,0.00,0.00,0.00),('1','194','1012','258081',4905933,'2993','460',3274926.44,3274926.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905934,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905935,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905936,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905937,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905938,'2998','460',30017.19,30017.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905939,'2999','460',74740.71,74740.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258081',4905940,'3000','460',56929.23,56929.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258082',4905941,'2993','460',3274926.44,3287581.69,0.00,0.00,12655.25,7972807.50,0.00,0.00,0.00),('1','194','1012','258082',4905942,'2994','460',4229.00,4229.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258082',4905943,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258082',4905944,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258082',4905945,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258082',4905946,'2998','460',30017.19,30022.19,0.00,0.00,5.00,3440.00,0.00,0.00,0.00),('1','194','1012','258082',4905947,'2999','460',74740.71,75460.69,0.00,0.00,719.98,495346.24,0.00,0.00,0.00),('1','194','1012','258082',4905948,'3000','460',56929.23,58256.46,0.00,0.00,1327.23,913134.24,0.00,0.00,0.00),('1','194','1012','258083',4905949,'2993','460',3287581.69,3294061.69,0.00,0.00,6480.00,4082400.00,0.00,0.00,0.00),('1','194','1012','258083',4905950,'2994','460',4229.00,4329.00,0.00,0.00,100.00,63000.00,0.00,0.00,0.00),('1','194','1012','258083',4905951,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258083',4905952,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258083',4905953,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258083',4905954,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258083',4905955,'2999','460',75460.69,76319.33,0.00,0.00,858.64,590744.32,0.00,0.00,0.00),('1','194','1012','258083',4905956,'3000','460',58256.46,59028.42,0.00,0.00,771.96,531108.48,0.00,0.00,0.00),('1','194','1012','258084',4905957,'2993','460',3294061.69,3295168.69,0.00,0.00,1107.00,697410.00,0.00,0.00,0.00),('1','194','1012','258084',4905958,'2994','460',4329.00,4329.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258084',4905959,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258084',4905960,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258084',4905961,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258084',4905962,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258084',4905963,'2999','460',76319.33,76335.53,0.00,0.00,16.20,11145.60,0.00,0.00,0.00),('1','194','1012','258084',4905964,'3000','460',59028.42,59181.98,0.00,0.00,153.56,105649.28,0.00,0.00,0.00),('1','194','1012','258085',4905965,'2993','460',3295168.69,3295168.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905966,'2994','460',4329.00,4329.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905967,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905968,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905969,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905970,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905971,'2999','460',76335.53,76335.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258085',4905972,'3000','460',59181.98,59181.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258086',4905973,'2993','460',3295168.69,3305707.96,0.00,0.00,10539.27,6626922.10,0.00,0.00,0.00),('1','194','1012','258086',4905974,'2994','460',4329.00,4389.00,0.00,0.00,60.00,37800.00,0.00,0.00,0.00),('1','194','1012','258086',4905975,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258086',4905976,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258086',4905977,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258086',4905978,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258086',4905979,'2999','460',76335.53,77004.70,0.00,0.00,669.17,460388.96,0.00,0.00,0.00),('1','194','1012','258086',4905980,'3000','460',59181.98,60297.36,0.00,0.00,1115.38,767381.44,0.00,0.00,0.00),('1','194','1012','258087',4905981,'2993','460',3305707.96,3313250.46,0.00,0.00,7542.50,4738427.00,0.00,0.00,0.00),('1','194','1012','258087',4905982,'2994','460',4389.00,4389.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258087',4905983,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258087',4905984,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258087',4905985,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258087',4905986,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258087',4905987,'2999','460',77004.70,77858.14,0.00,0.00,853.44,587166.72,0.00,0.00,0.00),('1','194','1012','258087',4905988,'3000','460',60297.36,61284.91,0.00,0.00,987.55,679434.40,0.00,0.00,0.00),('1','194','1012','258088',4905989,'2993','460',3313250.46,3315063.96,0.00,0.00,1813.50,1142505.00,0.00,0.00,0.00),('1','194','1012','258088',4905990,'2994','460',4389.00,5089.00,0.00,0.00,700.00,441000.00,0.00,0.00,0.00),('1','194','1012','258088',4905991,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258088',4905992,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258088',4905993,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258088',4905994,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258088',4905995,'2999','460',77858.14,78065.89,0.00,0.00,207.75,142932.00,0.00,0.00,0.00),('1','194','1012','258088',4905996,'3000','460',61284.91,61418.30,0.00,0.00,133.39,91772.32,0.00,0.00,0.00),('1','194','1012','258089',4905997,'2993','460',3315063.96,3315063.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4905998,'2994','460',5089.00,5089.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4905999,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4906000,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4906001,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4906002,'2998','460',30022.19,30022.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4906003,'2999','460',78065.89,78065.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258089',4906004,'3000','460',61418.30,61418.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258090',4906005,'2993','460',3315063.96,3322229.46,0.00,0.00,7165.50,4499343.00,0.00,0.00,0.00),('1','194','1012','258090',4906006,'2994','460',5089.00,5199.00,0.00,0.00,110.00,69300.00,0.00,0.00,0.00),('1','194','1012','258090',4906007,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258090',4906008,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258090',4906009,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258090',4906010,'2998','460',30022.19,30028.19,0.00,0.00,6.00,4128.00,0.00,0.00,0.00),('1','194','1012','258090',4906011,'2999','460',78065.89,78715.71,0.00,0.00,649.82,447076.16,0.00,0.00,0.00),('1','194','1012','258090',4906012,'3000','460',61418.30,61935.42,0.00,0.00,517.12,355778.56,0.00,0.00,0.00),('1','194','1012','258091',4906013,'2993','460',3322229.46,3334921.14,0.00,0.00,12691.68,7976700.40,0.00,0.00,0.00),('1','194','1012','258091',4906014,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258091',4906015,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258091',4906016,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258091',4906017,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258091',4906018,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258091',4906019,'2999','460',78715.71,79950.52,0.00,0.00,1234.81,849549.28,0.00,0.00,0.00),('1','194','1012','258091',4906020,'3000','460',61935.42,63344.62,0.00,0.00,1409.20,969529.60,0.00,0.00,0.00),('1','194','1012','258092',4906021,'2993','460',3334921.14,3335590.85,0.00,0.00,669.71,421917.30,0.00,0.00,0.00),('1','194','1012','258092',4906022,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258092',4906023,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258092',4906024,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258092',4906025,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258092',4906026,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258092',4906027,'2999','460',79950.52,79967.67,0.00,0.00,17.15,11799.20,0.00,0.00,0.00),('1','194','1012','258092',4906028,'3000','460',63344.62,63414.62,0.00,0.00,70.00,48160.00,0.00,0.00,0.00),('1','194','1012','258093',4906029,'2993','460',3335590.85,3335590.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906030,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906031,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906032,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906033,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906034,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906035,'2999','460',79967.67,79967.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258093',4906036,'3000','460',63414.62,63414.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258094',4906037,'2993','460',3335590.85,3344231.14,0.00,0.00,8640.29,5426045.54,0.00,0.00,0.00),('1','194','1012','258094',4906038,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258094',4906039,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258094',4906040,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258094',4906041,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258094',4906042,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258094',4906043,'2999','460',79967.67,80616.85,0.00,0.00,649.18,446635.84,0.00,0.00,0.00),('1','194','1012','258094',4906044,'3000','460',63414.62,64827.11,0.00,0.00,1412.49,971793.12,0.00,0.00,0.00),('1','194','1012','258095',4906045,'2993','460',3344231.14,3351730.64,0.00,0.00,7499.50,4711923.00,0.00,0.00,0.00),('1','194','1012','258095',4906046,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258095',4906047,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258095',4906048,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258095',4906049,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258095',4906050,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258095',4906051,'2999','460',80616.85,80769.50,0.00,0.00,152.65,105023.20,0.00,0.00,0.00),('1','194','1012','258095',4906052,'3000','460',64827.11,65428.80,0.00,0.00,601.69,413962.72,0.00,0.00,0.00),('1','194','1012','258096',4906053,'2993','460',3351730.64,3351730.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906054,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906055,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906056,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906057,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906058,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906059,'2999','460',80769.50,80769.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258096',4906060,'3000','460',65428.80,65428.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258097',4906061,'2993','460',3351730.64,3370120.68,0.00,0.00,18390.04,11553877.04,0.00,0.00,0.00),('1','194','1012','258097',4906062,'2994','460',5199.00,5199.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258097',4906063,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258097',4906064,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258097',4906065,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258097',4906066,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258097',4906067,'2999','460',80769.50,81125.88,0.00,0.00,356.38,245189.44,0.00,0.00,0.00),('1','194','1012','258097',4906068,'3000','460',65428.80,66286.35,0.00,0.00,857.55,589994.40,0.00,0.00,0.00),('1','194','1012','258098',4906069,'2993','460',3370120.68,3373219.10,0.00,0.00,3098.42,1952004.60,0.00,0.00,0.00),('1','194','1012','258098',4906070,'2994','460',5199.00,5661.00,0.00,0.00,462.00,291060.00,0.00,0.00,0.00),('1','194','1012','258098',4906071,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258098',4906072,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258098',4906073,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258098',4906074,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258098',4906075,'2999','460',81125.88,81464.57,0.00,0.00,338.69,233018.72,0.00,0.00,0.00),('1','194','1012','258098',4906076,'3000','460',66286.35,67022.41,0.00,0.00,736.06,506409.28,0.00,0.00,0.00),('1','194','1012','258099',4906077,'2993','460',3373219.10,3373519.10,0.00,0.00,300.00,189000.00,0.00,0.00,0.00),('1','194','1012','258099',4906078,'2994','460',5661.00,5661.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258099',4906079,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258099',4906080,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258099',4906081,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258099',4906082,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258099',4906083,'2999','460',81464.57,81489.07,0.00,0.00,24.50,16856.00,0.00,0.00,0.00),('1','194','1012','258099',4906084,'3000','460',67022.41,67093.54,0.00,0.00,71.13,48937.44,0.00,0.00,0.00),('1','194','1012','258100',4906085,'2993','460',3373519.10,3373519.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906086,'2994','460',5661.00,5661.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906087,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906088,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906089,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906090,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906091,'2999','460',81489.07,81489.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258100',4906092,'3000','460',67093.54,67093.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258101',4906093,'2993','460',3373519.10,3377997.50,0.00,0.00,4478.40,2808438.00,0.00,0.00,0.00),('1','194','1012','258101',4906094,'2994','460',5661.00,5661.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258101',4906095,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258101',4906096,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258101',4906097,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258101',4906098,'2998','460',30028.19,30028.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258101',4906099,'2999','460',81489.07,81597.72,0.00,0.00,108.65,74751.20,0.00,0.00,0.00),('1','194','1012','258101',4906100,'3000','460',67093.54,67371.05,0.00,0.00,277.51,190926.88,0.00,0.00,0.00),('1','194','1012','258102',4906101,'2993','460',3377997.50,3388360.50,0.00,0.00,10363.00,6509264.00,0.00,0.00,0.00),('1','194','1012','258102',4906102,'2994','460',5661.00,5661.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258102',4906103,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258102',4906104,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258102',4906105,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258102',4906106,'2998','460',30028.19,30029.21,0.00,0.00,1.02,701.76,0.00,0.00,0.00),('1','194','1012','258102',4906107,'2999','460',81597.72,82134.39,0.00,0.00,536.67,369228.96,0.00,0.00,0.00),('1','194','1012','258102',4906108,'3000','460',67371.05,68489.28,0.00,0.00,1118.23,769342.24,0.00,0.00,0.00),('1','194','1012','258103',4906109,'2993','460',3388360.50,3394376.50,0.00,0.00,6016.00,3780960.00,0.00,0.00,0.00),('1','194','1012','258103',4906110,'2994','460',5661.00,5701.00,0.00,0.00,40.00,25200.00,0.00,0.00,0.00),('1','194','1012','258103',4906111,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258103',4906112,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258103',4906113,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258103',4906114,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258103',4906115,'2999','460',82134.39,82667.59,0.00,0.00,533.20,366841.60,0.00,0.00,0.00),('1','194','1012','258103',4906116,'3000','460',68489.28,69262.37,0.00,0.00,773.09,531885.92,0.00,0.00,0.00),('1','194','1012','258104',4906117,'2993','460',3394376.50,3394376.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906118,'2994','460',5701.00,5701.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906119,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906120,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906121,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906122,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906123,'2999','460',82667.59,82667.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258104',4906124,'3000','460',69262.37,69262.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258105',4906125,'2993','460',3394376.50,3401223.00,0.00,0.00,6846.50,4299905.00,0.00,0.00,0.00),('1','194','1012','258105',4906126,'2994','460',5701.00,5701.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258105',4906127,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258105',4906128,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258105',4906129,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258105',4906130,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258105',4906131,'2999','460',82667.59,83051.68,0.00,0.00,384.09,264253.92,0.00,0.00,0.00),('1','194','1012','258105',4906132,'3000','460',69262.37,69883.92,0.00,0.00,621.55,427626.40,0.00,0.00,0.00),('1','194','1012','258106',4906133,'2993','460',3401223.00,3412430.96,0.00,0.00,11207.96,7040644.80,0.00,0.00,0.00),('1','194','1012','258106',4906134,'2994','460',5701.00,5771.00,0.00,0.00,70.00,44100.00,0.00,0.00,0.00),('1','194','1012','258106',4906135,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258106',4906136,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258106',4906137,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258106',4906138,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258106',4906139,'2999','460',83051.68,84088.03,0.00,0.00,1036.35,713008.80,0.00,0.00,0.00),('1','194','1012','258106',4906140,'3000','460',69883.92,71628.24,0.00,0.00,1744.32,1200092.16,0.00,0.00,0.00),('1','194','1012','258107',4906141,'2993','460',3412430.96,3414521.96,0.00,0.00,2091.00,1317330.00,0.00,0.00,0.00),('1','194','1012','258107',4906142,'2994','460',5771.00,5826.00,0.00,0.00,55.00,34650.00,0.00,0.00,0.00),('1','194','1012','258107',4906143,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258107',4906144,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258107',4906145,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258107',4906146,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258107',4906147,'2999','460',84088.03,84153.74,0.00,0.00,65.71,45208.48,0.00,0.00,0.00),('1','194','1012','258107',4906148,'3000','460',71628.24,71792.00,0.00,0.00,163.76,112666.88,0.00,0.00,0.00),('1','194','1012','258108',4906149,'2993','460',3414521.96,3414521.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906150,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906151,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906152,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906153,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906154,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906155,'2999','460',84153.74,84153.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258108',4906156,'3000','460',71792.00,71792.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258109',4906157,'2993','460',3414521.96,3418335.12,0.00,0.00,3813.16,2393994.16,0.00,0.00,0.00),('1','194','1012','258109',4906158,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258109',4906159,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258109',4906160,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258109',4906161,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258109',4906162,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258109',4906163,'2999','460',84153.74,84566.48,0.00,0.00,412.74,283965.12,0.00,0.00,0.00),('1','194','1012','258109',4906164,'3000','460',71792.00,72371.16,0.00,0.00,579.16,398462.08,0.00,0.00,0.00),('1','194','1012','258110',4906165,'2993','460',3418335.12,3430611.12,0.00,0.00,12276.00,7712538.00,0.00,0.00,0.00),('1','194','1012','258110',4906166,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258110',4906167,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258110',4906168,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258110',4906169,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258110',4906170,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258110',4906171,'2999','460',84566.48,85255.57,0.00,0.00,689.09,474093.92,0.00,0.00,0.00),('1','194','1012','258110',4906172,'3000','460',72371.16,73327.05,0.00,0.00,955.89,657652.32,0.00,0.00,0.00),('1','194','1012','258111',4906173,'2993','460',3430611.12,3435502.12,0.00,0.00,4891.00,3068558.00,0.00,0.00,0.00),('1','194','1012','258111',4906174,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258111',4906175,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258111',4906176,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258111',4906177,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258111',4906178,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258111',4906179,'2999','460',85255.57,85568.25,0.00,0.00,312.68,215123.84,0.00,0.00,0.00),('1','194','1012','258111',4906180,'3000','460',73327.05,73780.94,0.00,0.00,453.89,312276.32,0.00,0.00,0.00),('1','194','1012','258112',4906181,'2993','460',3435502.12,3435502.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906182,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906183,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906184,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906185,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906186,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906187,'2999','460',85568.25,85568.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258112',4906188,'3000','460',73780.94,73780.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258113',4906189,'2993','460',3435502.12,3439661.49,0.00,0.00,4159.37,2608091.62,0.00,0.00,0.00),('1','194','1012','258113',4906190,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258113',4906191,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258113',4906192,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258113',4906193,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258113',4906194,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258113',4906195,'2999','460',85568.25,85766.04,0.00,0.00,197.79,136079.52,0.00,0.00,0.00),('1','194','1012','258113',4906196,'3000','460',73780.94,74019.57,0.00,0.00,238.63,164177.44,0.00,0.00,0.00),('1','194','1012','258114',4906197,'2993','460',3439661.49,3447194.59,0.00,0.00,7533.10,4731734.60,0.00,0.00,0.00),('1','194','1012','258114',4906198,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258114',4906199,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258114',4906200,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258114',4906201,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258114',4906202,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258114',4906203,'2999','460',85766.04,86681.02,0.00,0.00,914.98,629506.24,0.00,0.00,0.00),('1','194','1012','258114',4906204,'3000','460',74019.57,75359.54,0.00,0.00,1339.97,921899.36,0.00,0.00,0.00),('1','194','1012','258115',4906205,'2993','460',3447194.59,3450419.59,0.00,0.00,3225.00,2025390.00,0.00,0.00,0.00),('1','194','1012','258115',4906206,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258115',4906207,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258115',4906208,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258115',4906209,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258115',4906210,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258115',4906211,'2999','460',86681.02,86987.46,0.00,0.00,306.44,210830.72,0.00,0.00,0.00),('1','194','1012','258115',4906212,'3000','460',75359.54,75828.23,0.00,0.00,468.69,322458.72,0.00,0.00,0.00),('1','194','1012','258116',4906213,'2993','460',3450419.59,3450419.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906214,'2994','460',5826.00,5826.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906215,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906216,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906217,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906218,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906219,'2999','460',86987.46,86987.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258116',4906220,'3000','460',75828.23,75828.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258117',4906221,'2993','460',3450419.59,3467740.59,0.00,0.00,17321.00,10878652.00,0.00,0.00,0.00),('1','194','1012','258117',4906222,'2994','460',5826.00,5866.00,0.00,0.00,40.00,25200.00,0.00,0.00,0.00),('1','194','1012','258117',4906223,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258117',4906224,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258117',4906225,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258117',4906226,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258117',4906227,'2999','460',86987.46,87799.70,0.00,0.00,812.24,558821.12,0.00,0.00,0.00),('1','194','1012','258117',4906228,'3000','460',75828.23,77351.91,0.00,0.00,1523.68,1048291.84,0.00,0.00,0.00),('1','194','1012','258118',4906229,'2993','460',3467740.59,3470454.59,0.00,0.00,2714.00,1709820.00,0.00,0.00,0.00),('1','194','1012','258118',4906230,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258118',4906231,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258118',4906232,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258118',4906233,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258118',4906234,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258118',4906235,'2999','460',87799.70,88218.37,0.00,0.00,418.67,288044.96,0.00,0.00,0.00),('1','194','1012','258118',4906236,'3000','460',77351.91,78327.62,0.00,0.00,975.71,671288.48,0.00,0.00,0.00),('1','194','1012','258119',4906237,'2993','460',3470454.59,3470825.59,0.00,0.00,371.00,233730.00,0.00,0.00,0.00),('1','194','1012','258119',4906238,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258119',4906239,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258119',4906240,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258119',4906241,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258119',4906242,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258119',4906243,'2999','460',88218.37,88223.46,0.00,0.00,5.09,3501.92,0.00,0.00,0.00),('1','194','1012','258119',4906244,'3000','460',78327.62,78327.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906245,'2993','460',3470825.59,3470825.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906246,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906247,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906248,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906249,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906250,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906251,'2999','460',88223.46,88223.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258120',4906252,'3000','460',78327.62,78327.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258121',4906253,'2993','460',3470825.59,3475830.91,0.00,0.00,5005.32,3144262.48,0.00,0.00,0.00),('1','194','1012','258121',4906254,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258121',4906255,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258121',4906256,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258121',4906257,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258121',4906258,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258121',4906259,'2999','460',88223.46,88581.61,0.00,0.00,358.15,246407.20,0.00,0.00,0.00),('1','194','1012','258121',4906260,'3000','460',78327.62,78999.95,0.00,0.00,672.33,462563.04,0.00,0.00,0.00),('1','194','1012','258122',4906261,'2993','460',3475830.91,3480946.91,0.00,0.00,5116.00,3213596.00,0.00,0.00,0.00),('1','194','1012','258122',4906262,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258122',4906263,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258122',4906264,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258122',4906265,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258122',4906266,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258122',4906267,'2999','460',88581.61,89138.99,0.00,0.00,557.38,383477.44,0.00,0.00,0.00),('1','194','1012','258122',4906268,'3000','460',78999.95,80088.80,0.00,0.00,1088.85,749128.80,0.00,0.00,0.00),('1','194','1012','258123',4906269,'2993','460',3480946.91,3490690.64,0.00,0.00,9743.73,6122533.90,0.00,0.00,0.00),('1','194','1012','258123',4906270,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258123',4906271,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258123',4906272,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258123',4906273,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258123',4906274,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258123',4906275,'2999','460',89138.99,89728.59,0.00,0.00,589.60,405644.80,0.00,0.00,0.00),('1','194','1012','258123',4906276,'3000','460',80088.80,81499.47,0.00,0.00,1410.67,970540.96,0.00,0.00,0.00),('1','194','1012','258124',4906277,'2993','460',3490690.64,3490690.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906278,'2994','460',5866.00,5866.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906279,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906280,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906281,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906282,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906283,'2999','460',89728.59,89728.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258124',4906284,'3000','460',81499.47,81499.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258125',4906285,'2993','460',3490690.64,3504286.09,0.00,0.00,13595.45,8538549.60,0.00,0.00,0.00),('1','194','1012','258125',4906286,'2994','460',5866.00,6082.00,0.00,0.00,216.00,136080.00,0.00,0.00,0.00),('1','194','1012','258125',4906287,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258125',4906288,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258125',4906289,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258125',4906290,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258125',4906291,'2999','460',89728.59,90345.85,0.00,0.00,617.26,424674.88,0.00,0.00,0.00),('1','194','1012','258125',4906292,'3000','460',81499.47,82619.74,0.00,0.00,1120.27,770745.76,0.00,0.00,0.00),('1','194','1012','258126',4906293,'2993','460',3504286.09,3511292.09,0.00,0.00,7006.00,4400284.00,0.00,0.00,0.00),('1','194','1012','258126',4906294,'2994','460',6082.00,6232.00,0.00,0.00,150.00,94500.00,0.00,0.00,0.00),('1','194','1012','258126',4906295,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258126',4906296,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258126',4906297,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258126',4906298,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258126',4906299,'2999','460',90345.85,90800.29,0.00,0.00,454.44,312654.72,0.00,0.00,0.00),('1','194','1012','258126',4906300,'3000','460',82619.74,83754.67,0.00,0.00,1134.93,780831.84,0.00,0.00,0.00),('1','194','1012','258127',4906301,'2993','460',3511292.09,3511292.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906302,'2994','460',6232.00,6232.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906303,'2995','460',3.00,3.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906304,'2996','460',27.00,27.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906305,'2997','460',2697.57,2697.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906306,'2998','460',30029.21,30029.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906307,'2999','460',90800.29,90800.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','194','1012','258127',4906308,'3000','460',83754.67,83754.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730327 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','194','232225','460',530.00,630.00,0.00,465.90,246927.00,258517.00,11590.00,664085),('1','194','232246','460',530.00,630.00,0.00,581.00,307930.00,326230.00,18300.00,664139),('1','194','232987','460',530.00,630.00,0.00,2283.40,1210202.00,1266654.00,56452.00,666098),('1','194','232999','460',530.00,630.00,0.00,2672.10,1416213.00,1470203.00,53990.00,666130),('1','194','233013','460',530.00,630.00,0.00,2293.53,1215570.90,1269373.90,53803.00,666165),('1','194','233164','460',530.00,630.00,0.00,6032.90,3197437.00,3333897.00,136460.00,666540),('1','194','233518','460',530.00,630.00,0.00,5182.80,2746884.00,2864004.00,117120.00,667482),('1','194','233622','460',530.00,630.00,0.00,5487.50,2908375.00,3042805.00,134430.00,667741),('1','194','234314','460',530.00,630.00,0.00,4183.00,2216990.00,2319930.00,102940.00,669572),('1','194','234579','460',530.00,630.00,0.00,4901.98,2598049.40,2724847.40,126798.00,670273),('1','194','234851','460',530.00,630.00,0.00,2955.83,1566589.90,1641852.90,75263.00,670987),('1','194','235082','460',530.00,630.00,0.00,4597.07,2436447.10,2548154.10,111707.00,671622),('1','194','235366','460',530.00,630.00,0.00,872.00,462160.00,489440.00,27280.00,672353),('1','194','235379','460',530.00,530.00,0.00,0.00,0.00,0.00,0.00,672384),('1','194','235380','460',530.00,630.00,0.00,3460.65,1834144.50,1929409.50,95265.00,672385),('1','194','235546','460',530.00,630.00,0.00,1717.96,910518.80,968474.80,57956.00,672811),('1','194','235762','460',530.00,630.00,0.00,8737.90,4631087.00,4836156.00,205069.00,673374),('1','194','236031','460',530.00,630.00,0.00,4716.65,2499824.50,2627809.50,127985.00,674085),('1','194','236240','460',530.00,630.00,0.00,5625.56,2981546.80,3130382.80,148836.00,674641),('1','194','236517','460',530.00,630.00,0.00,740.59,392512.70,413771.70,21259.00,675371),('1','194','236575','460',530.00,630.00,0.00,0.00,0.00,0.00,0.00,675511),('1','194','237716','460',566.00,0.00,0.00,4229.21,2393732.86,2472994.40,79261.54,678468),('1','194','237720','460',566.00,0.00,0.00,3758.30,2127197.80,2213960.00,86762.20,678478),('1','194','237724','460',566.00,0.00,0.00,7815.90,4423799.40,4565406.00,141606.60,678488),('1','194','237734','460',566.00,0.00,0.00,2380.52,1347374.32,1408992.80,61618.48,678517),('1','194','237738','460',566.00,0.00,0.00,4012.79,2271239.14,2330973.20,59734.06,678527),('1','194','237876','460',566.00,0.00,0.00,2800.32,1584981.12,1642474.80,57493.68,678887),('1','194','237996','460',567.00,0.00,0.00,11177.53,6337659.51,6608211.20,270551.69,679190),('1','194','238126','460',567.00,640.00,0.00,4203.09,2383152.03,2496641.60,113489.57,679533),('1','194','238356','460',567.00,640.00,0.00,7498.98,4251921.66,4434755.20,182833.54,680117),('1','194','238603','460',567.00,640.00,0.00,2122.37,1203383.79,1259048.80,55665.01,680772),('1','194','238692','460',567.00,640.00,0.00,5285.01,2996600.67,3129400.40,132799.73,680999),('1','194','238841','460',567.00,640.00,0.00,4081.84,2314403.28,2422081.60,107678.32,681382),('1','194','239064','460',567.00,640.00,0.00,9462.35,5365152.45,5603868.00,238715.55,681959),('1','194','239293','460',567.00,640.00,0.00,4333.35,2457009.45,2569400.00,112390.55,682563),('1','194','239535','460',567.00,640.00,0.00,1837.45,1041834.15,1088853.45,47019.30,683189),('1','194','239596','460',567.00,640.00,0.00,6532.12,3703712.04,3863772.80,160060.76,683348),('1','194','239773','460',567.00,640.00,0.00,7505.28,4255493.76,4450746.40,195252.64,683809),('1','194','240003','460',567.00,640.00,0.00,8081.38,4582142.46,4784839.20,202696.74,684399),('1','194','240202','460',567.00,640.00,0.00,2881.22,1633651.74,1703268.80,69617.06,684923),('1','194','240274','460',567.00,640.00,0.00,5900.10,3345356.70,3498477.60,153120.90,685102),('1','194','240461','460',567.00,640.00,0.00,3922.93,2224301.31,2335331.20,111029.89,685595),('1','194','240700','460',567.00,640.00,0.00,9351.10,5302073.70,5546318.00,244244.30,686172),('1','194','240978','460',567.00,640.00,0.00,3314.66,1879412.22,1965918.00,86505.78,686918),('1','194','241802','460',567.00,640.00,0.00,2511.21,1423856.07,1504398.64,80542.57,689094),('1','194','242004','460',578.00,640.00,0.00,3169.30,1831855.40,1907571.52,75716.12,689613),('1','194','242216','460',578.00,640.00,0.00,2037.85,1177877.30,1229685.76,51808.46,690172),('1','194','242445','460',578.00,640.00,0.00,4857.76,2807785.28,2913383.20,105597.92,690750),('1','194','242687','460',578.00,640.00,0.00,4882.66,2822177.48,2926086.40,103908.92,691381),('1','194','242932','460',578.00,640.00,0.00,4191.64,2422767.92,2511577.60,88809.68,692027),('1','194','243148','460',578.00,640.00,0.00,3382.58,1955131.24,2031027.20,75895.96,692590),('1','194','243374','460',578.00,640.00,0.00,2478.21,1432405.38,1476809.76,44404.38,693193),('1','194','243453','460',568.00,640.00,0.00,3301.12,1875036.16,1963400.36,88364.20,693386),('1','194','243604','460',568.00,640.00,0.00,5080.97,2885990.96,3042523.40,156532.44,693780),('1','194','243838','460',568.00,640.00,0.00,2928.01,1663109.68,1760384.40,97274.72,694385),('1','194','244059','460',568.00,640.00,0.00,4034.65,2291681.20,2425497.10,133815.90,694946),('1','194','244300','460',568.00,640.00,0.00,3178.69,1805495.92,1903968.70,98472.78,695587),('1','194','244523','460',568.00,640.00,0.00,3056.59,1736143.12,1852984.60,116841.48,696158),('1','194','244756','460',568.00,640.00,0.00,2964.15,1683637.20,1758148.00,74510.80,696772),('1','194','245001','460',568.00,640.00,0.00,455.82,258905.76,271284.80,12379.04,697402),('1','194','245026','460',568.00,640.00,0.00,2734.74,1553332.32,1616877.80,63545.48,697458),('1','194','245224','460',568.00,640.00,0.00,4769.85,2709274.80,2832604.00,123329.20,697976),('1','194','245449','460',568.00,640.00,0.00,2909.92,1652834.56,1726483.86,73649.30,698556),('1','194','245684','460',568.00,640.00,0.00,3567.76,2026487.68,2130619.40,104131.72,699165),('1','194','246859','460',568.00,640.00,0.00,1106.55,628520.40,678962.10,50441.70,702241),('1','194','246948','460',568.00,640.00,0.00,3771.54,2142234.72,2196435.60,54200.88,702456),('1','194','247183','460',568.00,640.00,0.00,1718.67,976204.56,1000996.80,24792.24,703066),('1','194','247750','460',568.00,640.00,0.00,2411.73,1369862.64,1372405.20,2542.56,704519),('1','194','247916','460',568.00,640.00,0.00,2826.85,1572146.40,1674448.00,102301.60,704962),('1','194','248162','460',528.00,640.00,0.00,3183.04,1680645.12,1872799.60,192154.48,705597),('1','194','248409','460',528.00,640.00,0.00,4950.31,2613763.68,2886638.80,272875.12,706236),('1','194','248647','460',528.00,640.00,0.00,11387.82,6012768.96,6447398.40,434629.44,706842),('1','194','248950','460',528.00,640.00,0.00,4641.22,2450564.16,2493163.54,42599.38,707616),('1','194','249137','460',504.00,592.00,0.00,4357.56,2196210.24,2364960.22,168749.98,708086),('1','194','249350','460',504.00,592.00,0.00,1793.45,903898.80,977832.68,73933.88,708642),('1','194','249605','460',504.00,592.00,0.00,2536.08,1278184.32,1373515.36,95331.04,709295),('1','194','249875','460',504.00,592.00,0.00,2494.15,1257051.60,1359418.80,102367.20,709984),('1','194','250127','460',504.00,592.00,0.00,2905.02,1464130.08,1593229.84,129099.76,710622),('1','194','250353','460',504.00,592.00,0.00,5864.46,2955687.84,3148166.32,192478.48,711204),('1','194','250598','460',504.00,592.00,0.00,2022.15,1019163.60,1099834.80,80671.20,711822),('1','194','250814','460',504.00,592.00,0.00,2947.13,1485353.52,1598987.60,113634.08,712392),('1','194','251047','460',507.00,592.00,0.00,2216.08,1123552.56,1208333.68,84781.12,712992),('1','194','251290','460',507.00,592.00,0.00,2430.48,1232253.36,1306292.16,74038.80,713624),('1','194','251533','460',507.00,592.00,0.00,2115.63,1072624.41,1148916.96,76292.55,714260),('1','194','251778','460',507.00,592.00,0.00,2832.37,1436011.59,1525319.68,89308.09,714903),('1','194','252020','460',507.00,592.00,0.00,2253.41,1142478.87,1231634.72,89155.85,715534),('1','194','252294','460',507.00,592.00,0.00,1692.46,858077.22,917964.16,59886.94,716246),('1','194','252496','460',507.00,592.00,0.00,3601.96,1826193.72,1951460.32,125266.60,716771),('1','194','252756','460',507.00,592.00,0.00,2198.48,1114629.36,1205596.16,90966.80,717437),('1','194','253008','460',507.00,592.00,0.00,1801.89,913558.23,984998.88,71440.65,718093),('1','194','253221','460',507.00,592.00,0.00,2326.34,1179454.38,1263325.28,83870.90,718669),('1','194','253486','460',507.00,592.00,0.00,1470.90,745746.30,812752.80,67006.50,719355),('1','194','253725','460',507.00,592.00,0.00,4086.17,2071688.19,2215066.88,143378.69,719963),('1','194','254008','460',507.00,592.00,0.00,2041.22,1034898.54,1126449.68,91551.14,720701),('1','194','254220','460',507.00,592.00,0.00,3387.82,1717624.74,1855671.04,138046.30,721253),('1','194','254459','460',507.00,592.00,0.00,2523.12,1279221.84,1389215.04,109993.20,721874),('1','194','254702','460',507.00,592.00,0.00,2683.28,1360422.96,1481761.76,121338.80,722497),('1','194','254966','460',507.00,592.00,0.00,2141.41,1085694.87,1188514.72,102819.85,723160),('1','194','255198','460',507.00,592.00,0.00,2318.12,1175286.84,1223439.68,48152.84,723765),('1','194','255508','460',507.00,592.00,0.00,3496.21,1772578.47,1906010.32,133431.85,724516),('1','194','255751','460',507.00,592.00,0.00,2157.92,1094065.44,1167931.64,73866.20,725130),('1','194','255964','460',507.00,592.00,0.00,164.73,83518.11,90120.16,6602.05,725676),('1','194','256047','460',493.00,592.00,0.00,9222.26,4546574.18,4843485.78,296911.60,725886),('1','194','256157','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726178),('1','194','256163','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726195),('1','194','256170','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726211),('1','194','256171','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726212),('1','194','256172','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726213),('1','194','256175','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726220),('1','194','256176','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726221),('1','194','256177','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726222),('1','194','256178','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726223),('1','194','256180','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726227),('1','194','256181','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726228),('1','194','256182','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726229),('1','194','256184','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726232),('1','194','256186','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726236),('1','194','256187','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,726237),('1','194','256228','460',493.00,592.00,0.00,3974.15,1959255.95,2132324.80,173068.85,726323),('1','194','256493','460',493.00,592.00,0.00,5453.60,2688624.80,2874083.00,185458.20,727022),('1','194','256669','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,727483),('1','194','256986','460',493.00,592.00,0.00,8225.68,4055260.24,4289676.20,234415.96,728295),('1','194','257309','460',493.00,592.00,0.00,4521.91,2229301.63,2403990.72,174689.09,729129),('1','194','257542','460',493.00,592.00,0.00,3125.17,1540708.81,1681528.64,140819.83,729741),('1','194','257543','460',493.00,592.00,0.00,5234.97,2580840.21,2820377.24,239537.03,729742),('1','194','257544','460',493.00,592.00,0.00,1492.88,735989.84,828950.96,92961.12,729743),('1','194','257545','460',493.00,592.00,0.00,2005.96,988938.28,1064318.32,75380.04,729744),('1','194','257546','460',493.00,592.00,0.00,0.00,0.00,0.00,0.00,729745),('1','194','257547','460',483.00,592.00,0.00,4178.64,2018283.12,2220988.90,202705.78,729746),('1','194','257548','460',483.00,592.00,0.00,2128.15,1027896.45,1172507.80,144611.35,729747),('1','194','257549','460',483.00,592.00,0.00,4245.29,2050475.07,2270619.68,220144.61,729748),('1','194','257550','460',483.00,592.00,0.00,2609.07,1260180.81,1424488.68,164307.87,729749),('1','194','257551','460',483.00,592.00,0.00,4488.62,2168003.46,2409351.04,241347.58,729750),('1','194','257552','460',483.00,592.00,0.00,3097.43,1496058.69,1675370.56,179311.87,729751),('1','194','257553','460',483.00,592.00,0.00,2950.86,1425265.38,1560712.16,135446.78,729752),('1','194','257554','460',483.00,592.00,0.00,935.08,451643.64,488587.36,36943.72,729753),('1','194','257555','460',483.00,592.00,0.00,0.00,0.00,0.00,0.00,729754),('1','194','257556','460',483.00,592.00,0.00,3461.58,1671943.14,1826871.36,154928.22,729755),('1','194','257557','460',483.00,592.00,0.00,2517.80,1216097.40,1333096.78,116999.38,729756),('1','194','257558','460',483.00,592.00,0.00,6448.70,3114722.10,3369976.00,255253.90,729757),('1','194','257559','460',483.00,592.00,0.00,4416.08,2132966.64,2324683.06,191716.42,729758),('1','194','257560','460',483.00,592.00,0.00,5266.60,2836257.31,2761493.74,-74763.57,729759),('1','194','257561','460',592.00,592.00,0.00,1302.67,771180.64,670730.64,-100450.00,729760),('1','194','257562','460',592.00,592.00,0.00,1156.00,684352.00,602352.00,-82000.00,729761),('1','194','257563','460',592.00,592.00,0.00,0.00,0.00,0.00,0.00,729762),('1','194','257564','460',483.00,592.00,0.00,610.13,294692.79,320688.96,25996.17,729763),('1','194','257565','460',483.00,592.00,0.00,6751.50,3260974.50,3520960.00,259985.50,729764),('1','194','257566','460',483.00,592.00,0.00,5126.06,2475886.98,2659731.72,183844.74,729765),('1','194','257567','460',483.00,592.00,0.00,10497.96,5070514.68,5416604.32,346089.64,729766),('1','194','257568','460',483.00,592.00,0.00,1486.61,718032.63,782575.12,64542.49,729767),('1','194','257569','460',483.00,592.00,0.00,0.00,0.00,0.00,0.00,729768),('1','194','257570','460',596.00,596.00,0.00,2267.05,1351161.80,1195785.80,-155376.00,729769),('1','194','257571','460',596.00,596.00,0.00,2782.87,1658590.52,1500970.92,-157619.60,729770),('1','194','257572','460',596.00,596.00,0.00,5156.05,3073005.80,2709198.98,-363806.82,729771),('1','194','257573','460',596.00,596.00,0.00,4854.31,2893168.76,2567214.76,-325954.00,729772),('1','194','257574','460',596.00,596.00,0.00,3802.44,2266254.24,2014942.24,-251312.00,729773),('1','194','257575','460',596.00,596.00,0.00,5631.78,3356540.88,2943543.88,-412997.00,729774),('1','194','257576','460',596.00,596.00,0.00,0.00,0.00,0.00,0.00,729775),('1','194','257577','460',508.00,596.00,0.00,1831.92,930615.36,973355.32,42739.96,729776),('1','194','257578','460',508.00,596.00,0.00,9263.79,4706005.32,4856921.84,150916.52,729777),('1','194','257579','460',508.00,596.00,0.00,5031.29,2641905.64,2710431.84,68526.20,729778),('1','194','257580','460',596.00,596.00,0.00,5929.93,3534238.28,3189121.74,-345116.54,729779),('1','194','257581','460',596.00,596.00,0.00,2556.37,1523596.52,1371136.52,-152460.00,729780),('1','194','257582','460',596.00,596.00,0.00,0.00,0.00,0.00,0.00,729781),('1','194','257583','460',596.00,596.00,0.00,3350.11,1701855.88,1800213.56,98357.68,729782),('1','194','257584','460',508.00,596.00,0.00,9007.03,4575571.24,4842337.88,266766.64,729783),('1','194','257585','460',508.00,596.00,0.00,4055.92,2060407.36,2200451.00,140043.64,729784),('1','194','257586','460',508.00,596.00,0.00,5265.43,2674838.44,2837886.28,163047.84,729785),('1','194','257587','460',508.00,596.00,0.00,2648.35,1345361.80,1417460.60,72098.80,729786),('1','194','257588','460',508.00,596.00,0.00,0.00,0.00,0.00,0.00,729787),('1','194','257589','460',540.00,596.00,0.00,4840.81,3001302.20,2812442.20,-188860.00,729788),('1','194','257590','460',620.00,620.00,0.00,9806.78,6080203.60,5726827.60,-353376.00,729789),('1','194','257591','460',620.00,620.00,0.00,4235.79,2626189.80,2488053.80,-138136.00,729790),('1','194','257592','460',620.00,620.00,0.00,5422.78,3362123.60,3159603.60,-202520.00,729791),('1','194','257593','460',620.00,620.00,0.00,0.00,0.00,0.00,0.00,729792),('1','194','257594','460',574.00,620.00,0.00,1308.52,850538.00,818113.00,-32425.00,729793),('1','194','257595','460',650.00,650.00,0.00,3833.32,2491658.00,2351078.00,-140580.00,729794),('1','194','257596','460',650.00,650.00,0.00,2469.38,1605097.00,1518967.00,-86130.00,729795),('1','194','257597','460',650.00,650.00,0.00,3929.75,2554337.50,2384682.50,-169655.00,729796),('1','194','257598','460',640.00,640.00,0.00,3938.26,2520486.40,2353680.40,-166806.00,729797),('1','194','257599','460',640.00,640.00,0.00,5525.40,3536256.00,3296783.82,-239472.18,729798),('1','194','257600','460',640.00,640.00,0.00,3520.61,2253190.40,2091039.20,-162151.20,729799),('1','194','257601','460',640.00,640.00,0.00,0.00,0.00,0.00,0.00,729800),('1','194','257602','460',562.00,640.00,0.00,7282.11,4092545.82,4334724.66,242178.84,729801),('1','194','257603','460',562.00,640.00,0.00,5805.78,3262848.36,3445737.00,182888.64,729802),('1','194','257604','460',562.00,640.00,0.00,6482.36,3643086.32,3830311.82,187225.50,729803),('1','194','257605','460',562.00,640.00,0.00,5082.05,2856112.10,2990288.00,134175.90,729804),('1','194','257606','460',562.00,640.00,0.00,0.00,0.00,0.00,0.00,729805),('1','194','257607','460',562.00,640.00,0.00,7329.00,4118898.00,4337785.02,218887.02,729806),('1','194','257608','460',562.00,640.00,0.00,11884.41,6679038.42,6996053.34,317014.92,729807),('1','194','257609','460',562.00,640.00,0.00,2967.11,1667515.82,1757659.40,90143.58,729808),('1','194','257610','460',562.00,640.00,0.00,2469.96,1388117.52,1454954.40,66836.88,729809),('1','194','257611','460',562.00,640.00,0.00,0.00,0.00,0.00,0.00,729810),('1','194','257612','460',587.00,660.00,0.00,2968.91,1742750.17,1868630.60,125880.43,729811),('1','194','257613','460',587.00,660.00,0.00,5601.96,3288350.52,3449620.10,161269.58,729812),('1','194','257614','460',587.00,660.00,0.00,6029.85,3539521.95,3709973.00,170451.05,729813),('1','194','257615','460',587.00,660.00,0.00,3889.92,2283383.04,2411122.20,127739.16,729814),('1','194','257616','460',587.00,660.00,0.00,2455.20,1441202.40,1542618.00,101415.60,729815),('1','194','257617','460',587.00,660.00,0.00,3668.00,2153116.00,2279299.00,126183.00,729816),('1','194','257618','460',587.00,660.00,0.00,0.00,0.00,0.00,0.00,729817),('1','194','257619','460',572.00,660.00,0.00,1964.66,1123785.52,1188285.60,64500.08,729818),('1','194','257620','460',572.00,660.00,0.00,2524.22,1443853.84,1550914.20,107060.36,729819),('1','194','257621','460',572.00,660.00,0.00,5025.97,2874854.84,3096470.40,221615.56,729820),('1','194','257622','460',572.00,660.00,0.00,3409.40,1950176.80,2091894.00,141717.20,729821),('1','194','257623','460',572.00,660.00,0.00,2759.16,1578239.52,1705219.80,126980.28,729822),('1','194','257624','460',572.00,660.00,0.00,4033.41,2307110.52,2477070.60,169960.08,729823),('1','194','257625','460',572.00,660.00,0.00,1687.07,965004.04,1030906.20,65902.16,729824),('1','194','257626','460',572.00,660.00,0.00,3208.32,1835159.04,1963321.20,128162.16,729825),('1','194','257627','460',572.00,660.00,0.00,0.00,0.00,0.00,0.00,729826),('1','194','257628','460',572.00,660.00,0.00,6705.78,3835706.16,4084294.80,248588.64,729827),('1','194','257629','460',572.00,660.00,0.00,2728.13,1560490.36,1675735.80,115245.44,729828),('1','194','257630','460',572.00,660.00,0.00,3764.69,2153402.68,2310905.40,157502.72,729829),('1','194','257631','460',572.00,660.00,0.00,3206.50,1834118.00,1959540.00,125422.00,729830),('1','194','257632','460',572.00,660.00,0.00,4055.27,2319614.44,2518738.20,199123.76,729831),('1','194','257633','460',572.00,660.00,0.00,3773.88,2158659.36,2338401.00,179741.64,729832),('1','194','257634','460',572.00,660.00,0.00,0.00,0.00,0.00,0.00,729833),('1','194','257635','460',572.00,660.00,0.00,0.00,0.00,0.00,0.00,729834),('1','194','257636','460',570.00,660.00,0.00,3866.91,2204138.70,2370210.60,166071.90,729835),('1','194','257637','460',570.00,660.00,0.00,4101.76,2338003.20,2507741.60,169738.40,729836),('1','194','257638','460',570.00,660.00,0.00,6140.53,3500102.10,3677724.80,177622.70,729837),('1','194','257639','460',570.00,660.00,0.00,7548.64,4302724.80,4511024.80,208300.00,729838),('1','194','257640','460',570.00,660.00,0.00,2997.15,1708375.50,1803329.00,94953.50,729839),('1','194','257641','460',570.00,660.00,0.00,0.00,0.00,0.00,0.00,729840),('1','194','257642','460',570.00,660.00,0.00,6640.16,3784891.20,3959895.60,175004.40,729841),('1','194','257643','460',570.00,660.00,0.00,6664.18,3798582.60,3993538.80,194956.20,729842),('1','194','257644','460',570.00,660.00,0.00,4023.58,2293440.60,2433102.80,139662.20,729843),('1','194','257645','460',570.00,660.00,0.00,7319.20,4171944.00,4374377.00,202433.00,729844),('1','194','257646','460',570.00,660.00,0.00,0.00,0.00,0.00,0.00,729845),('1','194','257647','460',570.00,660.00,0.00,1910.68,1089087.60,1141882.80,52795.20,729846),('1','194','257648','460',570.00,660.00,0.00,11176.30,6370491.00,6632703.00,262212.00,729847),('1','194','257649','460',570.00,660.00,0.00,7726.51,4404110.70,4586251.60,182140.90,729848),('1','194','257650','460',570.00,660.00,0.00,553.78,315654.60,338054.80,22400.20,729849),('1','194','257651','460',570.00,660.00,0.00,3248.04,1851382.80,1953271.40,101888.60,729850),('1','194','257652','460',570.00,660.00,0.00,0.00,0.00,0.00,0.00,729851),('1','194','257653','460',570.00,660.00,0.00,7198.49,4103139.30,4270197.40,167058.10,729852),('1','194','257654','460',570.00,660.00,0.00,11164.05,6363508.50,6629868.00,266359.50,729853),('1','194','257655','460',570.00,660.00,0.00,3525.14,2009329.80,2103397.40,94067.60,729854),('1','194','257656','460',570.00,660.00,0.00,2689.85,1533214.50,1625256.00,92041.50,729855),('1','194','257657','460',570.00,660.00,0.00,0.00,0.00,0.00,0.00,729856),('1','194','257658','460',570.00,660.00,0.00,3669.47,2091597.90,2205133.20,113535.30,729857),('1','194','257659','460',570.00,660.00,0.00,6292.20,3586554.00,3782237.00,195683.00,729858),('1','194','257660','460',570.00,660.00,0.00,5368.90,3060273.00,3249797.00,189524.00,729859),('1','194','257661','460',570.00,660.00,0.00,5779.06,3294064.20,3466953.60,172889.40,729860),('1','194','257662','460',570.00,660.00,0.00,3255.83,1855823.10,1934542.80,78719.70,729861),('1','194','257663','460',570.00,660.00,0.00,0.00,0.00,0.00,0.00,729862),('1','194','257664','460',570.00,660.00,0.00,1468.95,837301.50,911897.00,74595.50,729863),('1','194','257665','460',570.00,660.00,0.00,5317.85,3031174.50,3201866.00,170691.50,729864),('1','194','257666','460',570.00,660.00,0.00,6156.00,3508920.00,3698744.40,189824.40,729865),('1','194','257667','460',570.00,660.00,0.00,4982.55,2840053.50,3003688.00,163634.50,729866),('1','194','257668','460',570.00,660.00,0.00,3650.62,2080853.40,2197869.20,117015.80,729867),('1','194','257669','460',570.00,660.00,0.00,2935.54,1952134.10,1847942.10,-104192.00,729868),('1','194','257670','460',665.00,665.00,0.00,0.00,0.00,0.00,0.00,729869),('1','194','257671','460',593.00,665.00,0.00,4816.18,2855994.74,3025232.38,169237.64,729870),('1','194','257672','460',593.00,665.00,0.00,7563.35,4485066.55,4752633.35,267566.80,729871),('1','194','257673','460',593.00,665.00,0.00,5006.44,2968818.92,3172059.80,203240.88,729872),('1','194','257674','460',593.00,665.00,0.00,2500.00,1482500.00,1552500.00,70000.00,729873),('1','194','257675','460',593.00,665.00,0.00,2011.43,1192777.99,1261036.95,68258.96,729874),('1','194','257676','460',680.00,680.00,0.00,2703.46,1838352.80,1740892.80,-97460.00,729875),('1','194','257677','460',616.00,680.00,0.00,7948.51,4896282.16,5106166.80,209884.64,729876),('1','194','257678','460',616.00,680.00,0.00,13672.96,8422543.36,8766432.00,343888.64,729877),('1','194','257679','460',616.00,680.00,0.00,0.00,0.00,0.00,0.00,729878),('1','194','257680','460',616.00,680.00,0.00,2318.53,1428214.48,1521937.46,93722.98,729879),('1','194','257681','460',632.00,696.00,0.00,11382.04,7193449.28,7392176.26,198726.98,729880),('1','194','257682','460',632.00,696.00,0.00,9455.50,5975876.00,6176804.00,200928.00,729881),('1','194','257683','460',632.00,696.00,0.00,0.00,0.00,0.00,0.00,729882),('1','194','257684','460',632.00,726.00,0.00,1953.89,1234858.48,1339174.14,104315.66,729883),('1','194','257685','460',632.00,726.00,0.00,0.00,0.00,0.00,0.00,729884),('1','194','257686','460',632.00,726.00,0.00,9585.98,6058339.36,6563032.12,504692.76,729885),('1','194','257687','460',632.00,726.00,0.00,13531.18,8551705.76,9231477.10,679771.34,729886),('1','194','257688','460',632.00,726.00,0.00,1457.67,921247.44,1002723.42,81475.98,729887),('1','194','257689','460',632.00,726.00,0.00,0.00,0.00,0.00,0.00,729888),('1','194','257690','460',632.00,726.00,0.00,8655.48,5470263.36,5922670.96,452407.60,729889),('1','194','257691','460',632.00,750.00,0.00,1444.51,912930.32,1013344.50,100414.18,729890),('1','194','257692','460',632.00,750.00,0.00,0.00,0.00,0.00,0.00,729891),('1','194','257693','460',654.00,750.00,0.00,4013.56,2624868.24,2798361.82,173493.58,729892),('1','194','257694','460',654.00,750.00,0.00,8713.85,5698857.90,6122280.48,423422.58,729893),('1','194','257695','460',654.00,750.00,0.00,10673.66,6980573.64,7464050.66,483477.02,729894),('1','194','257696','460',654.00,750.00,0.00,1141.22,746357.88,829739.40,83381.52,729895),('1','194','257697','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729896),('1','194','257698','460',654.00,770.00,0.00,2648.59,1732177.86,1933531.30,201353.44,729897),('1','194','257699','460',654.00,770.00,0.00,12928.05,8454944.70,9362313.00,907368.30,729898),('1','194','257700','460',654.00,770.00,0.00,7843.41,5129590.14,5678355.70,548765.56,729899),('1','194','257701','460',654.00,770.00,0.00,1129.11,738437.94,823664.70,85226.76,729900),('1','194','257702','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729901),('1','194','257703','460',654.00,770.00,0.00,5098.14,3334183.56,3722501.30,388317.74,729902),('1','194','257704','460',654.00,770.00,0.00,7969.58,5212105.32,5782776.60,570671.28,729903),('1','194','257705','460',654.00,770.00,0.00,10926.38,7145852.52,7919912.60,774060.08,729904),('1','194','257706','460',654.00,770.00,0.00,587.05,383930.70,427028.50,43097.80,729905),('1','194','257707','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729906),('1','194','257708','460',654.00,770.00,0.00,18085.01,11827596.54,13083967.70,1256371.16,729907),('1','194','257709','460',654.00,770.00,0.00,6119.21,4001963.34,4435109.20,433145.86,729908),('1','194','257710','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729909),('1','194','257711','460',654.00,770.00,0.00,4123.46,2696742.84,3011314.20,314571.36,729910),('1','194','257712','460',654.00,770.00,0.00,12599.36,8239981.44,9128701.20,888719.76,729911),('1','194','257713','460',654.00,770.00,0.00,7817.86,5112880.44,5670202.20,557321.76,729912),('1','194','257714','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729913),('1','194','257715','460',654.00,770.00,0.00,7786.51,5092377.54,5655151.20,562773.66,729914),('1','194','257716','460',654.00,770.00,0.00,7969.30,5211922.20,5793236.00,581313.80,729915),('1','194','257717','460',654.00,770.00,0.00,8824.77,5771399.58,6385422.90,614023.32,729916),('1','194','257718','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729917),('1','194','257719','460',654.00,770.00,0.00,9848.48,6440905.92,7143594.10,702688.18,729918),('1','194','257720','460',654.00,770.00,0.00,8031.97,5252908.38,5843716.90,590808.52,729919),('1','194','257721','460',654.00,770.00,0.00,6677.32,4366967.28,4863805.40,496838.12,729920),('1','194','257722','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729921),('1','194','257723','460',654.00,770.00,0.00,11923.64,7798060.56,8536252.80,738192.24,729922),('1','194','257724','460',654.00,770.00,0.00,10037.28,6564381.12,7193055.60,628674.48,729923),('1','194','257725','460',654.00,770.00,0.00,3018.70,1974229.80,2168459.00,194229.20,729924),('1','194','257726','460',654.00,770.00,0.00,0.00,0.00,0.00,0.00,729925),('1','194','257727','460',654.00,740.00,0.00,21247.27,13895714.58,14531540.60,635826.02,729926),('1','194','257728','460',654.00,740.00,0.00,1470.02,961393.08,1013027.20,51634.12,729927),('1','194','257729','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729928),('1','194','257730','460',654.00,740.00,0.00,8850.69,5788351.26,6088542.00,300190.74,729929),('1','194','257731','460',654.00,740.00,0.00,12613.01,8248908.54,8647761.80,398853.26,729930),('1','194','257732','460',654.00,740.00,0.00,3203.13,2094847.02,2203305.60,108458.58,729931),('1','194','257733','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729932),('1','194','257734','460',654.00,740.00,0.00,3504.51,2291949.54,2422859.40,130909.86,729933),('1','194','257735','460',654.00,740.00,0.00,12291.68,8038758.72,8450861.80,412103.08,729934),('1','194','257736','460',654.00,740.00,0.00,8650.17,5657211.18,5936635.80,279424.62,729935),('1','194','257737','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729936),('1','194','257738','460',654.00,740.00,0.00,11550.37,7553941.98,7896313.80,342371.82,729937),('1','194','257739','460',654.00,740.00,0.00,5647.23,3693288.42,3916570.20,223281.78,729938),('1','194','257740','460',654.00,740.00,0.00,7454.54,4875269.16,5110999.60,235730.44,729939),('1','194','257741','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729940),('1','194','257742','460',654.00,740.00,0.00,10362.56,6777114.24,7118394.40,341280.16,729941),('1','194','257743','460',654.00,740.00,0.00,10761.57,7038066.78,7380757.20,342690.42,729942),('1','194','257744','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729943),('1','194','257745','460',654.00,740.00,0.00,8729.19,5708890.26,6001020.60,292130.34,729944),('1','194','257746','460',654.00,740.00,0.00,14263.11,9328073.94,9797220.20,469146.26,729945),('1','194','257747','460',654.00,740.00,0.00,1683.12,1100760.48,1180888.80,80128.32,729946),('1','194','257748','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729947),('1','194','257749','460',654.00,740.00,0.00,16923.52,11067982.08,11590251.80,522269.72,729948),('1','194','257750','460',654.00,740.00,0.00,3699.82,2419682.28,2542155.20,122472.92,729949),('1','194','257751','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729950),('1','194','257752','460',654.00,740.00,0.00,7350.74,4807383.96,5024847.60,217463.64,729951),('1','194','257753','460',654.00,740.00,0.00,16586.61,10847642.94,11385641.40,537998.46,729952),('1','194','257754','460',654.00,740.00,0.00,274.75,179686.50,196145.00,16458.50,729953),('1','194','257755','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729954),('1','194','257756','460',654.00,740.00,0.00,5156.95,3372645.30,3539093.00,166447.70,729955),('1','194','257757','460',654.00,740.00,0.00,16010.48,10470853.92,10997585.20,526731.28,729956),('1','194','257758','460',654.00,740.00,0.00,3465.27,2266286.58,2392729.80,126443.22,729957),('1','194','257759','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729958),('1','194','257760','460',654.00,740.00,0.00,4858.16,3177236.64,3346998.40,169761.76,729959),('1','194','257761','460',654.00,740.00,0.00,13787.18,9016815.72,9476638.60,459822.88,729960),('1','194','257762','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729961),('1','194','257763','460',654.00,740.00,0.00,10828.78,7082022.12,7422263.20,340241.08,729962),('1','194','257764','460',654.00,740.00,0.00,8057.89,5269860.06,5558933.00,289072.94,729963),('1','194','257765','460',654.00,740.00,0.00,5624.27,3678272.58,3856319.60,178047.02,729964),('1','194','257766','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729965),('1','194','257767','460',654.00,740.00,0.00,6353.38,4155110.52,4354713.40,199602.88,729966),('1','194','257768','460',654.00,740.00,0.00,4081.51,2669307.54,2845136.60,175829.06,729967),('1','194','257769','460',654.00,740.00,0.00,13741.95,8987235.30,9438779.80,451544.50,729968),('1','194','257770','460',654.00,740.00,0.00,340.61,222758.94,240111.40,17352.46,729969),('1','194','257771','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729970),('1','194','257772','460',654.00,740.00,0.00,13657.98,8932318.92,9331845.20,399526.28,729971),('1','194','257773','460',654.00,740.00,0.00,10668.31,6977074.74,7316319.20,339244.46,729972),('1','194','257774','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729973),('1','194','257775','460',654.00,740.00,0.00,9894.45,6470970.30,6799414.80,328444.50,729974),('1','194','257776','460',654.00,740.00,0.00,14672.54,9595841.16,10055712.00,459870.84,729975),('1','194','257777','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729976),('1','194','257778','460',654.00,740.00,0.00,17232.25,11269891.50,11793989.20,524097.70,729977),('1','194','257779','460',654.00,740.00,0.00,7390.29,4833249.66,5101944.60,268694.94,729978),('1','194','257780','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729979),('1','194','257781','460',654.00,740.00,0.00,19155.74,12527853.96,13170079.00,642225.04,729980),('1','194','257782','460',654.00,740.00,0.00,5539.30,3622702.20,3795392.00,172689.80,729981),('1','194','257783','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729982),('1','194','257784','460',654.00,740.00,0.00,10430.15,6821318.10,7157601.40,336283.30,729983),('1','194','257785','460',654.00,740.00,0.00,14115.52,9231550.08,9699084.80,467534.72,729984),('1','194','257786','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729985),('1','194','257787','460',654.00,740.00,0.00,18060.64,11811658.56,12418137.80,606479.24,729986),('1','194','257788','460',654.00,740.00,0.00,6344.38,4149224.52,4375424.00,226199.48,729987),('1','194','257789','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729988),('1','194','257790','460',654.00,740.00,0.00,7973.09,5214400.86,5462930.60,248529.74,729989),('1','194','257791','460',654.00,740.00,0.00,15471.15,10118132.10,10591556.40,473424.30,729990),('1','194','257792','460',654.00,740.00,0.00,1249.77,817349.58,891179.80,73830.22,729991),('1','194','257793','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729992),('1','194','257794','460',654.00,740.00,0.00,10606.38,6936572.52,7303874.60,367302.08,729993),('1','194','257795','460',654.00,740.00,0.00,13896.00,9087984.00,9547370.00,459386.00,729994),('1','194','257796','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729995),('1','194','257797','460',654.00,740.00,0.00,21690.45,14185554.30,14878524.80,692970.50,729996),('1','194','257798','460',654.00,740.00,0.00,3031.24,1982430.96,2082453.80,100022.84,729997),('1','194','257799','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,729998),('1','194','257800','460',654.00,740.00,0.00,19029.48,12445279.92,13022867.20,577587.28,729999),('1','194','257801','460',654.00,740.00,0.00,5970.52,3904720.08,4086155.92,181435.84,730000),('1','194','257802','460',654.00,740.00,0.00,15800.70,10333657.80,10807716.80,474059.00,730001),('1','194','257803','460',654.00,740.00,0.00,9027.01,5903664.54,6191072.20,287407.66,730002),('1','194','257804','460',654.00,740.00,0.00,6010.79,3931056.66,4123424.60,192367.94,730003),('1','194','257805','460',654.00,740.00,0.00,7634.44,4992923.76,5271135.20,278211.44,730004),('1','194','257806','460',654.00,740.00,0.00,11069.47,7239433.38,7596107.80,356674.42,730005),('1','194','257807','460',654.00,740.00,0.00,0.00,0.00,0.00,0.00,730006),('1','194','257808','460',640.00,740.00,0.00,21351.92,13665228.80,14586560.80,921332.00,730007),('1','194','257809','460',640.00,740.00,0.00,3353.92,2146508.80,2304590.80,158082.00,730008),('1','194','257810','460',640.00,740.00,0.00,0.00,0.00,0.00,0.00,730009),('1','194','257811','460',640.00,740.00,0.00,9283.09,5941177.60,6328436.60,387259.00,730010),('1','194','257812','460',640.00,740.00,0.00,15377.36,9841510.40,10515134.40,673624.00,730011),('1','194','257813','460',640.00,740.00,0.00,0.00,0.00,0.00,0.00,730012),('1','194','257814','460',640.00,740.00,0.00,6087.23,3895827.20,4201148.20,305321.00,730013),('1','194','257815','460',640.00,740.00,0.00,14791.86,9466790.40,10129911.80,663121.40,730014),('1','194','257816','460',640.00,740.00,0.00,3464.18,2217075.20,2375813.20,158738.00,730015),('1','194','257817','460',640.00,740.00,0.00,0.00,0.00,0.00,0.00,730016),('1','194','257818','460',649.00,740.00,0.00,11214.49,7278204.01,7643360.60,365156.59,730017),('1','194','257819','460',649.00,740.00,0.00,11163.36,7245020.64,7659043.60,414022.96,730018),('1','194','257820','460',649.00,740.00,0.00,1982.28,1286499.72,1357207.20,70707.48,730019),('1','194','257821','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730020),('1','194','257822','460',649.00,740.00,0.00,11351.47,7367104.03,7758937.80,391833.77,730021),('1','194','257823','460',649.00,740.00,0.00,13165.20,8544214.80,9031354.00,487139.20,730022),('1','194','257824','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730023),('1','194','257825','460',649.00,740.00,0.00,19641.47,12747314.03,13461419.80,714105.77,730024),('1','194','257826','460',649.00,740.00,0.00,5035.60,3268104.40,3482612.00,214507.60,730025),('1','194','257827','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730026),('1','194','257828','460',649.00,740.00,0.00,18467.69,11985530.81,12648710.60,663179.79,730027),('1','194','257829','460',649.00,740.00,0.00,5838.46,3789160.54,3992210.40,203049.86,730028),('1','194','257830','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730029),('1','194','257831','460',649.00,740.00,0.00,6250.42,4056522.58,4286718.48,230195.90,730030),('1','194','257832','460',649.00,740.00,0.00,18281.05,11864401.45,12475537.00,611135.55,730031),('1','194','257833','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730032),('1','194','257834','460',649.00,740.00,0.00,7489.33,4860575.17,5202764.20,342189.03,730033),('1','194','257835','460',649.00,740.00,0.00,15193.10,9860321.90,10394686.00,534364.10,730034),('1','194','257836','460',649.00,740.00,0.00,2060.77,1337439.73,1405501.80,68062.07,730035),('1','194','257837','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730036),('1','194','257838','460',649.00,740.00,0.00,8277.98,5372409.02,5697785.20,325376.18,730037),('1','194','257839','460',649.00,740.00,0.00,9442.06,6127896.94,6479162.40,351265.46,730038),('1','194','257840','460',649.00,740.00,0.00,6969.55,4523237.95,4788033.00,264795.05,730039),('1','194','257841','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730040),('1','194','257842','460',649.00,740.00,0.00,7467.49,4846401.01,5146922.60,300521.59,730041),('1','194','257843','460',649.00,740.00,0.00,10047.95,6521119.55,6926471.00,405351.45,730042),('1','194','257844','460',649.00,740.00,0.00,7177.41,4658139.09,4933549.40,275410.31,730043),('1','194','257845','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730044),('1','194','257846','460',649.00,740.00,0.00,12414.76,8057179.24,8516228.40,459049.16,730045),('1','194','257847','460',649.00,740.00,0.00,8760.95,5685856.55,6025205.00,339348.45,730046),('1','194','257848','460',649.00,740.00,0.00,3480.42,2258792.58,2386400.60,127608.02,730047),('1','194','257849','460',649.00,740.00,0.00,0.00,0.00,0.00,0.00,730048),('1','194','257850','460',637.00,740.00,0.00,3988.17,2540464.29,2769786.90,229322.61,730049),('1','194','257851','460',637.00,740.00,0.00,6712.95,4276149.15,4590983.00,314833.85,730050),('1','194','257852','460',637.00,740.00,0.00,14069.51,8962277.87,9501530.30,539252.43,730051),('1','194','257853','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730052),('1','194','257854','460',637.00,740.00,0.00,4278.22,2725226.14,2898637.50,173411.36,730053),('1','194','257855','460',637.00,740.00,0.00,13446.95,8565707.15,9097128.00,531420.85,730054),('1','194','257856','460',637.00,740.00,0.00,6621.56,4217933.72,4450921.80,232988.08,730055),('1','194','257857','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730056),('1','194','257858','460',637.00,740.00,0.00,5118.75,3260643.75,3495654.40,235010.65,730057),('1','194','257859','460',637.00,740.00,0.00,15721.69,10014716.53,10609004.00,594287.47,730058),('1','194','257860','460',637.00,740.00,0.00,3669.57,2337516.09,2482703.10,145187.01,730059),('1','194','257861','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730060),('1','194','257862','460',637.00,740.00,0.00,7513.54,4786124.98,5078238.30,292113.32,730061),('1','194','257863','460',637.00,740.00,0.00,12878.77,8203776.49,8755963.80,552187.31,730062),('1','194','257864','460',637.00,740.00,0.00,3983.15,2537266.55,2719926.00,182659.45,730063),('1','194','257865','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730064),('1','194','257866','460',637.00,740.00,0.00,3918.80,2496275.60,2657957.00,161681.40,730065),('1','194','257867','460',637.00,740.00,0.00,17480.26,11134925.62,11814592.40,679666.78,730066),('1','194','257868','460',637.00,740.00,0.00,3278.37,2088321.69,2224438.60,136116.91,730067),('1','194','257869','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730068),('1','194','257870','460',637.00,740.00,0.00,4909.06,3127071.22,3301337.40,174266.18,730069),('1','194','257871','460',637.00,740.00,0.00,12277.29,7820633.73,8331870.60,511236.87,730070),('1','194','257872','460',637.00,740.00,0.00,7562.48,4817299.76,5101071.20,283771.44,730071),('1','194','257873','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730072),('1','194','257874','460',637.00,740.00,0.00,5661.81,3606572.97,3842329.40,235756.43,730073),('1','194','257875','460',637.00,740.00,0.00,10655.44,6787515.28,7226685.60,439170.32,730074),('1','194','257876','460',637.00,740.00,0.00,8027.77,5113689.49,5435403.10,321713.61,730075),('1','194','257877','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730076),('1','194','257878','460',637.00,740.00,0.00,6183.21,3938704.77,4212065.40,273360.63,730077),('1','194','257879','460',637.00,740.00,0.00,16002.81,10193789.97,10886401.50,692611.53,730078),('1','194','257880','460',637.00,740.00,0.00,2143.54,1365434.98,1461829.60,96394.62,730079),('1','194','257881','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730080),('1','194','257882','460',637.00,740.00,0.00,2283.41,1454532.17,1561329.40,106797.23,730081),('1','194','257883','460',637.00,740.00,0.00,10181.17,6485405.29,6931708.40,446303.11,730082),('1','194','257884','460',637.00,740.00,0.00,9087.47,5788718.39,6166179.60,377461.21,730083),('1','194','257885','460',637.00,740.00,0.00,3189.01,2031399.37,2160117.40,128718.03,730084),('1','194','257886','460',637.00,740.00,0.00,0.00,0.00,0.00,0.00,730085),('1','194','257887','460',625.00,700.00,0.00,6435.37,4022106.25,4289399.00,267292.75,730086),('1','194','257888','460',625.00,700.00,0.00,15383.17,9614481.25,10243839.00,629357.75,730087),('1','194','257889','460',625.00,700.00,0.00,2975.63,1859768.75,2003053.80,143285.05,730088),('1','194','257890','460',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730089),('1','194','257891','460',629.00,700.00,0.00,13926.72,8759906.88,9252324.00,492417.12,730090),('1','194','257892','460',629.00,700.00,0.00,10515.45,6614218.05,6984775.00,370556.95,730091),('1','194','257893','460',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730092),('1','194','257894','460',629.00,700.00,0.00,13062.71,8216444.59,8679153.80,462709.21,730093),('1','194','257895','460',629.00,700.00,0.00,11653.48,7330038.92,7749831.60,419792.68,730094),('1','194','257896','460',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730095),('1','194','257897','460',629.00,700.00,0.00,11394.02,7166838.58,7568174.00,401335.42,730096),('1','194','257898','460',629.00,700.00,0.00,13130.90,8259336.10,8736109.60,476773.50,730097),('1','194','257899','460',629.00,700.00,0.00,0.00,0.00,0.00,0.00,730098),('1','194','257900','460',629.00,720.00,0.00,4226.72,2658606.88,2864563.40,205956.52,730099),('1','194','257901','460',629.00,720.00,0.00,12971.28,8158935.12,8766946.60,608011.48,730100),('1','194','257902','460',629.00,720.00,0.00,7307.54,4596442.66,4978328.80,381886.14,730101),('1','194','257903','460',629.00,720.00,0.00,0.00,0.00,0.00,0.00,730102),('1','194','257904','460',629.00,720.00,0.00,6057.94,3810444.26,4112231.80,301787.54,730103),('1','194','257905','460',629.00,720.00,0.00,13085.53,8230798.37,8871685.60,640887.23,730104),('1','194','257906','460',629.00,720.00,0.00,5469.06,3440038.74,3688183.20,248144.46,730105),('1','194','257907','460',629.00,720.00,0.00,0.00,0.00,0.00,0.00,730106),('1','194','257908','460',642.00,740.00,0.00,4617.38,2964357.96,3239789.20,275431.24,730107),('1','194','257909','460',642.00,740.00,0.00,3514.50,2256309.00,2496570.00,240261.00,730108),('1','194','257910','460',642.00,700.00,0.00,8648.18,5552131.56,5773846.00,221714.44,730109),('1','194','257911','460',642.00,700.00,0.00,7102.97,4560106.74,4738179.00,178072.26,730110),('1','194','257912','460',642.00,700.00,0.00,622.11,399394.62,415477.00,16082.38,730111),('1','194','257913','460',642.00,700.00,0.00,0.00,0.00,0.00,0.00,730112),('1','194','257914','460',634.00,700.00,0.00,9983.15,6329317.10,6645065.00,315747.90,730113),('1','194','257915','460',634.00,700.00,0.00,11138.81,7062005.54,7397036.20,335030.66,730114),('1','194','257916','460',634.00,700.00,0.00,3099.44,1965044.96,2066932.00,101887.04,730115),('1','194','257917','460',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730116),('1','194','257918','460',634.00,700.00,0.00,9891.79,6271394.86,6590271.00,318876.14,730117),('1','194','257919','460',634.00,700.00,0.00,11605.45,7357855.30,7712415.00,354559.70,730118),('1','194','257920','460',634.00,700.00,0.00,2588.33,1641001.22,1723762.60,82761.38,730119),('1','194','257921','460',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730120),('1','194','257922','460',634.00,700.00,0.00,3493.63,2214961.42,2341666.60,126705.18,730121),('1','194','257923','460',634.00,700.00,0.00,7685.80,4872797.20,5125640.00,252842.80,730122),('1','194','257924','460',634.00,700.00,0.00,12031.56,7628009.04,8008312.00,380302.96,730123),('1','194','257925','460',634.00,700.00,0.00,1096.95,695466.30,733065.00,37598.70,730124),('1','194','257926','460',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730125),('1','194','257927','460',634.00,700.00,0.00,9918.66,6288430.44,6589956.56,301526.12,730126),('1','194','257928','460',634.00,700.00,0.00,11122.40,7051601.60,7387382.00,335780.40,730127),('1','194','257929','460',634.00,700.00,0.00,3232.56,2049443.04,2148874.80,99431.76,730128),('1','194','257930','460',634.00,700.00,0.00,0.00,0.00,0.00,0.00,730129),('1','194','257931','460',649.00,700.00,0.00,14900.15,9670197.35,9888615.00,218417.65,730130),('1','194','257932','460',649.00,700.00,0.00,9734.42,6317638.58,6472446.00,154807.42,730131),('1','194','257933','460',649.00,700.00,0.00,0.00,0.00,0.00,0.00,730132),('1','194','257934','460',640.00,700.00,0.00,12712.95,8136288.00,8489964.60,353676.60,730133),('1','194','257935','460',640.00,700.00,0.00,11628.51,7442246.40,7758935.16,316688.76,730134),('1','194','257936','460',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730135),('1','194','257937','460',640.00,700.00,0.00,12936.28,8279219.20,8635606.12,356386.92,730136),('1','194','257938','460',640.00,700.00,0.00,11837.69,7576121.60,7896890.72,320769.12,730137),('1','194','257939','460',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730138),('1','194','257940','460',640.00,700.00,0.00,9121.01,5837446.40,6119219.24,281772.84,730139),('1','194','257941','460',640.00,700.00,0.00,7030.90,4499776.00,4710202.72,210426.72,730140),('1','194','257942','460',640.00,700.00,0.00,8663.35,5544544.00,5814703.00,270159.00,730141),('1','194','257943','460',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730142),('1','194','257944','460',640.00,700.00,0.00,7867.21,5035014.40,5278488.40,243474.00,730143),('1','194','257945','460',640.00,700.00,0.00,8657.14,5540569.60,5787541.36,246971.76,730144),('1','194','257946','460',640.00,700.00,0.00,6542.92,4187468.80,4391846.80,204378.00,730145),('1','194','257947','460',640.00,700.00,0.00,1598.84,1023257.60,1070588.00,47330.40,730146),('1','194','257948','460',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730147),('1','194','257949','460',630.00,700.00,0.00,5885.80,3708054.00,3934659.28,226605.28,730148),('1','194','257950','460',630.00,700.00,0.00,11159.51,7030491.30,7486736.12,456244.82,730149),('1','194','257951','460',630.00,700.00,0.00,6976.67,4395302.10,4669128.44,273826.34,730150),('1','194','257952','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730151),('1','194','257953','460',630.00,700.00,0.00,10875.78,6851741.40,7265600.40,413859.00,730152),('1','194','257954','460',630.00,700.00,0.00,5769.83,3634992.90,3872921.00,237928.10,730153),('1','194','257955','460',630.00,700.00,0.00,7935.27,4999220.10,5278554.20,279334.10,730154),('1','194','257956','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730155),('1','194','257957','460',630.00,700.00,0.00,8517.06,5365747.80,5690976.80,325229.00,730156),('1','194','257958','460',630.00,700.00,0.00,8485.99,5346173.70,5662173.80,316000.10,730157),('1','194','257959','460',630.00,700.00,0.00,7801.86,4915171.80,5194842.00,279670.20,730158),('1','194','257960','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730159),('1','194','257961','460',630.00,700.00,0.00,9008.07,5675084.10,5995987.80,320903.70,730160),('1','194','257962','460',630.00,700.00,0.00,10860.12,6841875.60,7256292.00,414416.40,730161),('1','194','257963','460',630.00,700.00,0.00,3989.71,2513517.30,2643205.00,129687.70,730162),('1','194','257964','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730163),('1','194','257965','460',630.00,700.00,0.00,5565.19,3506069.70,3704108.60,198038.90,730164),('1','194','257966','460',630.00,700.00,0.00,7674.35,4834840.50,5121493.00,286652.50,730165),('1','194','257967','460',630.00,700.00,0.00,10406.35,6556000.50,6911723.00,355722.50,730166),('1','194','257968','460',630.00,700.00,0.00,832.75,524632.50,556935.00,32302.50,730167),('1','194','257969','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730168),('1','194','257970','460',630.00,700.00,0.00,5726.96,3607984.80,3819254.00,211269.20,730169),('1','194','257971','460',630.00,700.00,0.00,11897.47,7495406.10,7935229.00,439822.90,730170),('1','194','257972','460',630.00,700.00,0.00,6662.22,4197198.60,4439374.00,242175.40,730171),('1','194','257973','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730172),('1','194','257974','460',630.00,700.00,0.00,13775.46,8678539.80,9176400.00,497860.20,730173),('1','194','257975','460',630.00,700.00,0.00,8122.31,5117055.30,5419935.00,302879.70,730174),('1','194','257976','460',630.00,700.00,0.00,2115.55,1332796.50,1408545.40,75748.90,730175),('1','194','257977','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730176),('1','194','257978','460',630.00,700.00,0.00,1200.29,756182.70,803243.00,47060.30,730177),('1','194','257979','460',630.00,700.00,0.00,14669.66,9241885.80,9754072.00,512186.20,730178),('1','194','257980','460',630.00,700.00,0.00,8348.26,5259403.80,5548946.00,289542.20,730179),('1','194','257981','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730180),('1','194','257982','460',630.00,700.00,0.00,13582.37,8556893.10,9072571.00,515677.90,730181),('1','194','257983','460',630.00,700.00,0.00,8655.21,5452782.30,5782379.00,329596.70,730182),('1','194','257984','460',630.00,700.00,0.00,2338.95,1473538.50,1561845.00,88306.50,730183),('1','194','257985','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730184),('1','194','257986','460',630.00,700.00,0.00,5666.37,3569813.10,3787619.00,217805.90,730185),('1','194','257987','460',630.00,700.00,0.00,13778.08,8680190.40,9180347.20,500156.80,730186),('1','194','257988','460',630.00,700.00,0.00,5042.14,3176548.20,3356024.00,179475.80,730187),('1','194','257989','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730188),('1','194','257990','460',630.00,700.00,0.00,17429.54,10980610.20,11666715.60,686105.40,730189),('1','194','257991','460',630.00,700.00,0.00,7175.78,4520741.40,4765226.00,244484.60,730190),('1','194','257992','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730191),('1','194','257993','460',630.00,700.00,0.00,17243.69,10863524.70,11439960.60,576435.90,730192),('1','194','257994','460',630.00,700.00,0.00,6967.62,4389600.60,4633430.00,243829.40,730193),('1','194','257995','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730194),('1','194','257996','460',630.00,700.00,0.00,8537.07,5378354.10,5683671.00,305316.90,730195),('1','194','257997','460',630.00,700.00,0.00,9229.77,5814755.10,6129337.00,314581.90,730196),('1','194','257998','460',630.00,700.00,0.00,6965.44,4388227.20,4626610.00,238382.80,730197),('1','194','257999','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730198),('1','194','258000','460',630.00,700.00,0.00,12493.12,7870665.60,8305993.60,435328.00,730199),('1','194','258001','460',630.00,700.00,0.00,6277.84,3955039.20,4183888.80,228849.60,730200),('1','194','258002','460',630.00,700.00,0.00,5905.85,3720685.50,3911299.00,190613.50,730201),('1','194','258003','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730202),('1','194','258004','460',630.00,700.00,0.00,4440.22,2797338.60,2951179.20,153840.60,730203),('1','194','258005','460',630.00,700.00,0.00,3759.01,2368176.30,2519347.00,151170.70,730204),('1','194','258006','460',630.00,700.00,0.00,7834.41,4935678.30,5208399.00,272720.70,730205),('1','194','258007','460',630.00,700.00,0.00,5894.11,3713289.30,3935229.00,221939.70,730206),('1','194','258008','460',630.00,700.00,0.00,2804.42,1766784.60,1870274.00,103489.40,730207),('1','194','258009','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730208),('1','194','258010','460',630.00,700.00,0.00,2226.97,1402991.10,1508419.00,105427.90,730209),('1','194','258011','460',630.00,700.00,0.00,10256.27,6461450.10,6819065.80,357615.70,730210),('1','194','258012','460',630.00,700.00,0.00,7055.27,4444820.10,4696497.00,251676.90,730211),('1','194','258013','460',630.00,700.00,0.00,5107.36,3217636.80,3394032.00,176395.20,730212),('1','194','258014','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730213),('1','194','258015','460',630.00,700.00,0.00,5713.33,3599397.90,3817295.00,217897.10,730214),('1','194','258016','460',630.00,700.00,0.00,8660.35,5456020.50,5753867.00,297846.50,730215),('1','194','258017','460',630.00,700.00,0.00,9764.12,6151395.60,6460976.00,309580.40,730216),('1','194','258018','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730217),('1','194','258019','460',630.00,700.00,0.00,2920.23,1839744.90,1947281.00,107536.10,730218),('1','194','258020','460',630.00,700.00,0.00,13204.74,8318986.20,8754582.00,435595.80,730219),('1','194','258021','460',630.00,700.00,0.00,8203.05,5167921.50,5418059.00,250137.50,730220),('1','194','258022','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730221),('1','194','258023','460',630.00,700.00,0.00,1947.99,1227233.70,1311353.00,84119.30,730222),('1','194','258024','460',630.00,700.00,0.00,13512.59,8512931.70,8988219.00,475287.30,730223),('1','194','258025','460',630.00,700.00,0.00,5799.58,3653735.40,3884292.40,230557.00,730224),('1','194','258026','460',630.00,700.00,0.00,2410.82,1518816.60,1599938.00,81121.40,730225),('1','194','258027','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730226),('1','194','258028','460',630.00,700.00,0.00,11202.48,7057562.40,7459027.60,401465.20,730227),('1','194','258029','460',630.00,700.00,0.00,9108.56,5738392.80,6059346.00,320953.20,730228),('1','194','258030','460',630.00,700.00,0.00,4372.01,2754366.30,2898949.00,144582.70,730229),('1','194','258031','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730230),('1','194','258032','460',630.00,700.00,0.00,17209.33,10841877.90,11404879.00,563001.10,730231),('1','194','258033','460',630.00,700.00,0.00,7437.40,4685562.00,4953464.00,267902.00,730232),('1','194','258034','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730233),('1','194','258035','460',630.00,700.00,0.00,12880.69,8114834.70,8570871.00,456036.30,730234),('1','194','258036','460',630.00,700.00,0.00,8992.44,5665237.20,5978670.00,313432.80,730235),('1','194','258037','460',630.00,700.00,0.00,2761.12,1739505.60,1833175.60,93670.00,730236),('1','194','258038','460',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730237),('1','194','258039','460',601.00,700.00,0.00,10426.12,6266098.12,6668438.70,402340.58,730238),('1','194','258040','460',601.00,700.00,0.00,10608.72,6375840.72,6803594.00,427753.28,730239),('1','194','258041','460',601.00,700.00,0.00,3522.24,2116866.24,2240553.00,123686.76,730240),('1','194','258042','460',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730241),('1','194','258043','460',601.00,700.00,0.00,5823.69,3500037.69,3741003.00,240965.31,730242),('1','194','258044','460',601.00,700.00,0.00,11232.72,6750864.72,7197624.00,446759.28,730243),('1','194','258045','460',601.00,700.00,0.00,7595.91,4565141.91,4855102.00,289960.09,730244),('1','194','258046','460',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730245),('1','194','258047','460',617.00,700.00,0.00,12696.02,7833444.34,8252324.00,418879.66,730246),('1','194','258048','460',617.00,700.00,0.00,11057.11,6822236.87,7177079.80,354842.93,730247),('1','194','258049','460',617.00,700.00,0.00,936.54,577845.18,612078.00,34232.82,730248),('1','194','258050','460',617.00,700.00,0.00,0.00,0.00,0.00,0.00,730249),('1','194','258051','460',617.00,700.00,0.00,10090.39,6225770.63,6568524.40,342753.77,730250),('1','194','258052','460',617.00,700.00,0.00,8704.98,5370972.66,5660586.00,289613.34,730251),('1','194','258053','460',617.00,700.00,0.00,5857.32,3613966.44,3769894.20,155927.76,730252),('1','194','258054','460',617.00,700.00,0.00,0.00,0.00,0.00,0.00,730253),('1','194','258055','460',617.00,700.00,0.00,4721.59,2913221.03,3080711.80,167490.77,730254),('1','194','258056','460',617.00,700.00,0.00,8462.51,5221368.67,5522687.00,301318.33,730255),('1','194','258057','460',617.00,700.00,0.00,7817.37,4823317.29,5079679.80,256362.51,730256),('1','194','258058','460',617.00,700.00,0.00,2521.07,1555500.19,1632059.00,76558.81,730257),('1','194','258059','460',617.00,700.00,0.00,0.00,0.00,0.00,0.00,730258),('1','194','258060','460',601.00,700.00,0.00,8483.29,5098457.29,5511103.00,412645.71,730259),('1','194','258061','460',601.00,700.00,0.00,5228.72,3142460.72,3421874.00,279413.28,730260),('1','194','258062','460',601.00,700.00,0.00,11054.67,6643856.67,7150551.60,506694.93,730261),('1','194','258063','460',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730262),('1','194','258064','460',601.00,700.00,0.00,3402.22,2044734.22,2216134.00,171399.78,730263),('1','194','258065','460',601.00,700.00,0.00,9623.42,5783675.42,6247457.00,463781.58,730264),('1','194','258066','460',601.00,700.00,0.00,7607.17,4571909.17,4968199.00,396289.83,730265),('1','194','258067','460',601.00,700.00,0.00,4019.85,2415929.85,2600415.00,184485.15,730266),('1','194','258068','460',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730267),('1','194','258069','460',617.00,700.00,0.00,3715.66,2292562.22,2456092.00,163529.78,730268),('1','194','258070','460',617.00,700.00,0.00,7005.81,4322584.77,4562457.00,239872.23,730269),('1','194','258071','460',617.00,700.00,0.00,12993.42,8016940.14,8418414.00,401473.86,730270),('1','194','258072','460',617.00,700.00,0.00,668.32,412353.44,455824.00,43470.56,730271),('1','194','258073','460',617.00,700.00,0.00,0.00,0.00,0.00,0.00,730272),('1','194','258074','460',601.00,700.00,0.00,6141.62,3691113.62,3975794.00,284680.38,730273),('1','194','258075','460',601.00,700.00,0.00,14414.51,8663120.51,9352700.60,689580.09,730274),('1','194','258076','460',601.00,700.00,0.00,3620.42,2175872.42,2328674.00,152801.58,730275),('1','194','258077','460',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730276),('1','194','258078','460',601.00,700.00,0.00,9811.75,5896861.75,6374635.00,477773.25,730277),('1','194','258079','460',601.00,700.00,0.00,8144.44,4894808.44,5297518.00,402709.56,730278),('1','194','258080','460',601.00,700.00,0.00,6313.80,3794593.80,4137210.00,342616.20,730279),('1','194','258081','460',601.00,700.00,0.00,0.00,0.00,0.00,0.00,730280),('1','194','258082','460',601.00,688.00,0.00,14707.46,8839183.46,9384727.98,545544.52,730281),('1','194','258083','460',601.00,688.00,0.00,8210.60,4934570.60,5267252.80,332682.20,730282),('1','194','258084','460',601.00,688.00,0.00,1276.76,767332.76,814204.88,46872.12,730283),('1','194','258085','460',601.00,688.00,0.00,0.00,0.00,0.00,0.00,730284),('1','194','258086','460',601.00,688.00,0.00,12383.82,7442675.82,7892492.50,449816.68,730285),('1','194','258087','460',601.00,688.00,0.00,9383.49,5639477.49,6005028.12,365550.63,730286),('1','194','258088','460',601.00,688.00,0.00,2854.64,1715638.64,1818209.32,102570.68,730287),('1','194','258089','460',601.00,688.00,0.00,0.00,0.00,0.00,0.00,730288),('1','194','258090','460',601.00,688.00,0.00,8448.44,5077512.44,5375625.72,298113.28,730289),('1','194','258091','460',601.00,688.00,0.00,15335.69,9216749.69,9795779.28,579029.59,730290),('1','194','258092','460',601.00,688.00,0.00,756.86,454872.86,481876.50,27003.64,730291),('1','194','258093','460',601.00,688.00,0.00,0.00,0.00,0.00,0.00,730292),('1','194','258094','460',601.00,688.00,0.00,10701.96,6431877.96,6844474.50,412596.54,730293),('1','194','258095','460',601.00,688.00,0.00,8253.84,4960557.84,5230908.92,270351.08,730294),('1','194','258096','460',601.00,688.00,0.00,0.00,0.00,0.00,0.00,730295),('1','194','258097','460',601.00,688.00,0.00,19603.97,11781985.97,12389060.88,607074.91,730296),('1','194','258098','460',601.00,688.00,0.00,4635.17,2785737.17,2982492.60,196755.43,730297),('1','194','258099','460',601.00,688.00,0.00,395.63,237773.63,254793.44,17019.81,730298),('1','194','258100','460',601.00,688.00,0.00,0.00,0.00,0.00,0.00,730299),('1','194','258101','460',609.00,688.00,0.00,4864.56,2962517.04,3074116.08,111599.04,730300),('1','194','258102','460',609.00,688.00,0.00,12018.92,7319522.28,7648536.96,329014.68,730301),('1','194','258103','460',609.00,688.00,0.00,7362.29,4483634.61,4704887.52,221252.91,730302),('1','194','258104','460',609.00,688.00,0.00,0.00,0.00,0.00,0.00,730303),('1','194','258105','460',609.00,688.00,0.00,7852.14,4781953.26,4991785.32,209832.06,730304),('1','194','258106','460',609.00,688.00,0.00,14058.63,8561705.67,8997845.76,436140.09,730305),('1','194','258107','460',609.00,688.00,0.00,2375.47,1446661.23,1509855.36,63194.13,730306),('1','194','258108','460',609.00,688.00,0.00,0.00,0.00,0.00,0.00,730307),('1','194','258109','460',600.00,688.00,0.00,4805.06,2883036.00,3076421.36,193385.36,730308),('1','194','258110','460',600.00,688.00,0.00,13920.98,8352588.00,8844284.24,491696.24,730309),('1','194','258111','460',600.00,688.00,0.00,5657.57,3394542.00,3595958.16,201416.16,730310),('1','194','258112','460',600.00,688.00,0.00,0.00,0.00,0.00,0.00,730311),('1','194','258113','460',600.00,688.00,0.00,4595.79,2757474.00,2908348.58,150874.58,730312),('1','194','258114','460',600.00,688.00,0.00,9788.05,5872830.00,6283140.20,410310.20,730313),('1','194','258115','460',600.00,688.00,0.00,4000.13,2400078.00,2558679.44,158601.44,730314),('1','194','258116','460',600.00,688.00,0.00,0.00,0.00,0.00,0.00,730315),('1','194','258117','460',600.00,688.00,0.00,19696.92,11818152.00,12510964.96,692812.96,730316),('1','194','258118','460',600.00,688.00,0.00,4108.38,2465028.00,2669153.44,204125.44,730317),('1','194','258119','460',600.00,688.00,0.00,376.09,225654.00,237231.92,11577.92,730318),('1','194','258120','460',600.00,688.00,0.00,0.00,0.00,0.00,0.00,730319),('1','194','258121','460',596.00,688.00,0.00,6035.80,3597336.80,3853232.72,255895.92,730320),('1','194','258122','460',596.00,688.00,0.00,6762.23,4030289.08,4346202.24,315913.16,730321),('1','194','258123','460',596.00,688.00,0.00,11744.00,6999424.00,7498719.66,499295.66,730322),('1','194','258124','460',596.00,688.00,0.00,0.00,0.00,0.00,0.00,730323),('1','194','258125','460',600.00,688.00,0.00,15548.98,9329388.00,9870050.24,540662.24,730324),('1','194','258126','460',600.00,688.00,0.00,8745.37,5247222.00,5588270.56,341048.56,730325),('1','194','258127','460',600.00,688.00,0.00,0.00,0.00,0.00,0.00,730326);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=418 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',417,'194','PRODUCT TANKS','TANK CONTAINING LPG PRODUCTS.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=1013 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','194','417',1012,1,'460','LPG TANK',25000.00,0.00,NULL,'TANK CONTAINING LPG PRODUCT.','479','2021-10-16 00:48:26','2021-10-16 00:48:26','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','194',1012,0.00,'2023-03-20 15:34:50');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2735125 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2110870,'1','194','1012',460,'Retail Sale Id 1255373',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 08:52:31','',''),(2110871,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:52:31','',''),(2110908,'1','194','1012',460,'Retail Sale Id 1255395',5120.00,0.00,0.00,0.00,496.00,'2021-12-01 08:54:45','',''),(2110909,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 08:54:45','',''),(2110938,'1','194','1012',460,'Retail Sale Id 1255411',25456.00,0.00,0.00,0.00,602.00,'2021-12-01 08:56:37','',''),(2110939,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,43.00,0.00,'2021-12-01 08:56:37','',''),(2110967,'1','194','1012',460,'Retail Sale Id 1255426',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 08:58:24','',''),(2110968,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:58:24','',''),(2110993,'1','194','1012',460,'Retail Sale Id 1255440',9920.00,0.00,0.00,0.00,961.00,'2021-12-01 08:59:46','',''),(2110994,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-01 08:59:46','',''),(2111016,'1','194','1012',460,'Retail Sale Id 1255451',8320.00,0.00,0.00,0.00,806.00,'2021-12-01 09:01:08','',''),(2111017,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-01 09:01:08','',''),(2111038,'1','194','1012',460,'Retail Sale Id 1255459',7680.00,0.00,0.00,0.00,744.00,'2021-12-01 09:02:15','',''),(2111039,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 09:02:15','',''),(2111066,'1','194','1012',460,'Retail Sale Id 1255473',640.00,0.00,0.00,0.00,62.00,'2021-12-01 09:03:37','',''),(2111067,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 09:03:37','',''),(2111086,'1','194','1012',460,'Retail Sale Id 1255483',1299.20,0.00,0.00,0.00,125.86,'2021-12-01 09:04:41','',''),(2111087,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-01 09:04:41','',''),(2111110,'1','194','1012',460,'Retail Sale Id 1255494',16000.00,0.00,0.00,0.00,1550.00,'2021-12-01 09:05:59','',''),(2111111,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 09:05:59','',''),(2111118,'1','194','1012',460,'Retail Sale Id 1255499',7040.00,0.00,0.00,0.00,682.00,'2021-12-01 09:07:05','',''),(2111119,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 09:07:05','',''),(2111140,'1','194','1012',460,'Retail Sale Id 1255509',97680.00,0.00,0.00,0.00,2310.00,'2021-12-01 09:08:54','',''),(2111141,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-01 09:08:54','',''),(2111166,'1','194','1012',460,'Retail Sale Id 1255520',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 09:10:08','',''),(2111167,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:10:08','',''),(2111180,'1','194','1012',460,'Retail Sale Id 1255529',182040.00,0.00,0.00,0.00,4305.00,'2021-12-01 09:11:18','',''),(2111181,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,307.50,0.00,'2021-12-01 09:11:18','',''),(2111202,'1','194','1012',460,'Retail Sale Id 1255540',2560.00,0.00,0.00,0.00,248.00,'2021-12-01 09:12:23','',''),(2111203,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:12:23','',''),(2111214,'1','194','1012',460,'Retail Sale Id 1255546',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 09:13:17','',''),(2111215,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:13:17','',''),(2111248,'1','194','1012',460,'Retail Sale Id 1255566',12352.00,0.00,0.00,0.00,1196.60,'2021-12-01 09:15:17','',''),(2111249,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,19.30,0.00,'2021-12-01 09:15:17','',''),(2111278,'1','194','1012',460,'Retail Sale Id 1255585',118400.00,0.00,0.00,0.00,2800.00,'2021-12-01 09:16:28','',''),(2111279,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-01 09:16:28','',''),(2111294,'1','194','1012',460,'Retail Sale Id 1255596',8960.00,0.00,0.00,0.00,868.00,'2021-12-01 09:17:59','',''),(2111295,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-01 09:17:59','',''),(2111314,'1','194','1012',460,'Retail Sale Id 1255606',5760.00,0.00,0.00,0.00,558.00,'2021-12-01 09:19:02','',''),(2111315,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 09:19:02','',''),(2111332,'1','194','1012',460,'Retail Sale Id 1255618',88800.00,0.00,0.00,0.00,2100.00,'2021-12-01 09:20:05','',''),(2111333,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 09:20:05','',''),(2111354,'1','194','1012',460,'Retail Sale Id 1255628',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 09:21:37','',''),(2111355,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:21:37','',''),(2111374,'1','194','1012',460,'Retail Sale Id 1255639',6400.00,0.00,0.00,0.00,620.00,'2021-12-01 09:23:00','',''),(2111375,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 09:23:00','',''),(2111434,'1','194','1012',460,'Retail Sale Id 1255666',100640.00,0.00,0.00,0.00,2380.00,'2021-12-01 09:26:09','',''),(2111435,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,170.00,0.00,'2021-12-01 09:26:09','',''),(2111456,'1','194','1012',460,'Retail Sale Id 1255674',22496.00,0.00,0.00,0.00,532.00,'2021-12-01 09:27:20','',''),(2111457,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-01 09:27:20','',''),(2111476,'1','194','1012',460,'Retail Sale Id 1255688',88800.00,0.00,0.00,0.00,2100.00,'2021-12-01 09:28:31','',''),(2111477,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-01 09:28:31','',''),(2111541,'1','194','1012',460,'Retail Sale Id 1255724',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 09:33:42','',''),(2111542,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:33:42','',''),(2111567,'1','194','1012',460,'Retail Sale Id 1255735',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 09:35:30','',''),(2111568,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:35:30','',''),(2111698,'1','194','1012',460,'Retail Sale Id 1255805',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 09:43:48','',''),(2111699,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 09:43:48','',''),(2111776,'1','194','1012',460,'Retail Sale Id 1255852',4480.00,0.00,0.00,0.00,434.00,'2021-12-01 09:48:52','',''),(2111777,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 09:48:52','',''),(2111804,'1','194','1012',460,'Retail Sale Id 1255866',124320.00,0.00,0.00,0.00,2940.00,'2021-12-01 09:51:56','',''),(2111805,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,210.00,0.00,'2021-12-01 09:51:56','',''),(2111831,'1','194','1012',460,'Retail Sale Id 1255872',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 09:53:48','',''),(2111832,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 09:53:48','',''),(2112086,'1','194','1012',460,'Retail Sale Id 1255991',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 10:11:01','',''),(2112087,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:11:01','',''),(2112148,'1','194','1012',460,'Retail Sale Id 1256030',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 10:14:49','',''),(2112149,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:14:49','',''),(2112263,'1','194','1012',460,'Retail Sale Id 1256085',35520.00,0.00,0.00,0.00,840.00,'2021-12-01 10:22:13','',''),(2112264,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-01 10:22:13','',''),(2112289,'1','194','1012',460,'Retail Sale Id 1256093',7040.00,0.00,0.00,0.00,682.00,'2021-12-01 10:25:20','',''),(2112290,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 10:25:20','',''),(2112313,'1','194','1012',460,'Retail Sale Id 1256102',59200.00,0.00,0.00,0.00,1400.00,'2021-12-01 10:26:29','',''),(2112314,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 10:26:29','',''),(2112327,'1','194','1012',460,'Retail Sale Id 1256109',29008.00,0.00,0.00,0.00,686.00,'2021-12-01 10:28:02','',''),(2112328,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-01 10:28:02','',''),(2112576,'1','194','1012',460,'Retail Sale Id 1256234',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 10:47:28','',''),(2112577,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:47:28','',''),(2112696,'1','194','1012',460,'Retail Sale Id 1256302',6400.00,0.00,0.00,0.00,620.00,'2021-12-01 10:58:55','',''),(2112697,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 10:58:55','',''),(2112716,'1','194','1012',460,'Retail Sale Id 1256311',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 10:59:58','',''),(2112717,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 10:59:58','',''),(2112810,'1','194','1012',460,'Retail Sale Id 1256361',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 11:07:27','',''),(2112811,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:07:27','',''),(2113082,'1','194','1012',460,'Retail Sale Id 1256480',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 11:22:57','',''),(2113083,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:22:57','',''),(2113138,'1','194','1012',460,'Retail Sale Id 1256502',31080.00,0.00,0.00,0.00,735.00,'2021-12-01 11:26:03','',''),(2113139,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,52.50,0.00,'2021-12-01 11:26:03','',''),(2113427,'1','194','1012',460,'Retail Sale Id 1256661',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 11:48:18','',''),(2113428,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:48:18','',''),(2113757,'1','194','1012',460,'Retail Sale Id 1256834',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 12:16:28','',''),(2113758,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:16:28','',''),(2113825,'1','194','1012',460,'Retail Sale Id 1256869',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 12:20:45','',''),(2113826,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:20:45','',''),(2113975,'1','194','1012',460,'Retail Sale Id 1256944',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 12:31:58','',''),(2113976,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:31:58','',''),(2114017,'1','194','1012',460,'Retail Sale Id 1256964',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 12:35:07','',''),(2114018,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 12:35:07','',''),(2114075,'1','194','1012',460,'Retail Sale Id 1256994',4998.40,0.00,0.00,0.00,484.22,'2021-12-01 12:42:02','',''),(2114076,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 12:42:02','',''),(2114162,'1','194','1012',460,'Retail Sale Id 1257031',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 12:50:50','',''),(2114163,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:50:50','',''),(2114410,'1','194','1012',460,'Retail Sale Id 1257195',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 13:12:04','',''),(2114411,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 13:12:04','',''),(2114438,'1','194','1012',460,'Retail Sale Id 1257209',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 13:13:43','',''),(2114439,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:13:43','',''),(2114617,'1','194','1012',460,'Retail Sale Id 1257299',5120.00,0.00,0.00,0.00,496.00,'2021-12-01 13:27:02','',''),(2114618,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 13:27:02','',''),(2114679,'1','194','1012',460,'Retail Sale Id 1257330',42624.00,0.00,0.00,0.00,1008.00,'2021-12-01 13:32:53','',''),(2114680,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-01 13:32:53','',''),(2114723,'1','194','1012',460,'Retail Sale Id 1257353',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 13:35:50','',''),(2114724,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:35:50','',''),(2114952,'1','194','1012',460,'Retail Sale Id 1257417',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 13:47:10','',''),(2114953,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:47:10','',''),(2115009,'1','194','1012',460,'Retail Sale Id 1257438',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 13:50:36','',''),(2115010,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:50:36','',''),(2115104,'1','194','1012',460,'Retail Sale Id 1257482',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 13:55:44','',''),(2115105,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:55:44','',''),(2115226,'1','194','1012',460,'Retail Sale Id 1257541',4480.00,0.00,0.00,0.00,434.00,'2021-12-01 14:01:42','',''),(2115227,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 14:01:42','',''),(2115245,'1','194','1012',460,'Retail Sale Id 1257553',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 14:03:06','',''),(2115246,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:03:06','',''),(2115331,'1','194','1012',460,'Retail Sale Id 1257593',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 14:08:20','',''),(2115332,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:08:20','',''),(2115403,'1','194','1012',460,'Retail Sale Id 1257640',2201.60,0.00,0.00,0.00,213.28,'2021-12-01 14:13:16','',''),(2115404,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.44,0.00,'2021-12-01 14:13:16','',''),(2115439,'1','194','1012',460,'Retail Sale Id 1257660',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 14:15:45','',''),(2115440,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:15:45','',''),(2115453,'1','194','1012',460,'Retail Sale Id 1257667',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 14:16:44','',''),(2115454,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:16:44','',''),(2115500,'1','194','1012',460,'Retail Sale Id 1257687',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 14:19:40','',''),(2115501,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:19:40','',''),(2115530,'1','194','1012',460,'Retail Sale Id 1257699',91760.00,0.00,0.00,0.00,2170.00,'2021-12-01 14:21:54','',''),(2115531,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,155.00,0.00,'2021-12-01 14:21:54','',''),(2115546,'1','194','1012',460,'Retail Sale Id 1257708',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 14:23:01','',''),(2115547,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:23:01','',''),(2115652,'1','194','1012',460,'Retail Sale Id 1257771',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 14:31:04','',''),(2115653,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 14:31:04','',''),(2115670,'1','194','1012',460,'Retail Sale Id 1257777',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 14:32:17','',''),(2115671,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:32:17','',''),(2115740,'1','194','1012',460,'Retail Sale Id 1257812',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 14:37:04','',''),(2115741,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:37:04','',''),(2115871,'1','194','1012',460,'Retail Sale Id 1257874',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 14:48:05','',''),(2115872,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:48:05','',''),(2115895,'1','194','1012',460,'Retail Sale Id 1257890',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 14:49:24','',''),(2115896,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:49:24','',''),(2115922,'1','194','1012',460,'Retail Sale Id 1257899',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 14:50:50','',''),(2115923,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 14:50:50','',''),(2116028,'1','194','1012',460,'Retail Sale Id 1257919',17760.00,0.00,0.00,0.00,420.00,'2021-12-01 14:53:53','',''),(2116029,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 14:53:53','',''),(2116052,'1','194','1012',460,'Retail Sale Id 1257933',1798.40,0.00,0.00,0.00,174.22,'2021-12-01 14:55:57','',''),(2116053,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-01 14:55:57','',''),(2116066,'1','194','1012',460,'Retail Sale Id 1257942',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 14:57:03','',''),(2116067,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:57:03','',''),(2116160,'1','194','1012',460,'Retail Sale Id 1257988',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 15:03:46','',''),(2116161,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:03:46','',''),(2116178,'1','194','1012',460,'Retail Sale Id 1257996',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 15:05:21','',''),(2116179,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:05:21','',''),(2116219,'1','194','1012',460,'Retail Sale Id 1258020',17760.00,0.00,0.00,0.00,420.00,'2021-12-01 15:09:39','',''),(2116220,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-01 15:09:39','',''),(2116237,'1','194','1012',460,'Retail Sale Id 1258030',2560.00,0.00,0.00,0.00,248.00,'2021-12-01 15:10:58','',''),(2116238,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:10:58','',''),(2116251,'1','194','1012',460,'Retail Sale Id 1258037',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 15:12:15','',''),(2116252,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:12:15','',''),(2116277,'1','194','1012',460,'Retail Sale Id 1258050',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 15:14:09','',''),(2116278,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 15:14:09','',''),(2116308,'1','194','1012',460,'Retail Sale Id 1258062',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 15:15:06','',''),(2116309,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:15:06','',''),(2116336,'1','194','1012',460,'Retail Sale Id 1258079',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 15:17:05','',''),(2116337,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:17:05','',''),(2116400,'1','194','1012',460,'Retail Sale Id 1258108',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 15:20:36','',''),(2116401,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:20:36','',''),(2116422,'1','194','1012',460,'Retail Sale Id 1258119',998.40,0.00,0.00,0.00,96.72,'2021-12-01 15:22:09','',''),(2116423,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 15:22:09','',''),(2116448,'1','194','1012',460,'Retail Sale Id 1258128',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 15:23:34','',''),(2116449,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:23:34','',''),(2116656,'1','194','1012',460,'Retail Sale Id 1258231',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 15:37:10','',''),(2116657,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:37:10','',''),(2116668,'1','194','1012',460,'Retail Sale Id 1258239',2560.00,0.00,0.00,0.00,248.00,'2021-12-01 15:38:13','',''),(2116669,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:38:13','',''),(2116692,'1','194','1012',460,'Retail Sale Id 1258249',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 15:39:39','',''),(2116693,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 15:39:39','',''),(2116730,'1','194','1012',460,'Retail Sale Id 1258266',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 15:42:15','',''),(2116731,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 15:42:15','',''),(2116764,'1','194','1012',460,'Retail Sale Id 1258281',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 15:43:58','',''),(2116765,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:43:58','',''),(2116802,'1','194','1012',460,'Retail Sale Id 1258293',87024.00,0.00,0.00,0.00,2058.00,'2021-12-01 15:45:30','',''),(2116803,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,147.00,0.00,'2021-12-01 15:45:30','',''),(2116822,'1','194','1012',460,'Retail Sale Id 1258304',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 15:46:30','',''),(2116823,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:46:30','',''),(2116858,'1','194','1012',460,'Retail Sale Id 1258323',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 15:47:50','',''),(2116859,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 15:47:50','',''),(2116919,'1','194','1012',460,'Retail Sale Id 1258352',29600.00,0.00,0.00,0.00,700.00,'2021-12-01 15:50:30','',''),(2116920,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 15:50:30','',''),(2116956,'1','194','1012',460,'Retail Sale Id 1258371',59200.00,0.00,0.00,0.00,1400.00,'2021-12-01 15:51:35','',''),(2116957,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-01 15:51:35','',''),(2117000,'1','194','1012',460,'Retail Sale Id 1258391',2560.00,0.00,0.00,0.00,248.00,'2021-12-01 15:53:23','',''),(2117001,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 15:53:23','',''),(2117035,'1','194','1012',460,'Retail Sale Id 1258407',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 15:55:14','',''),(2117036,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:55:14','',''),(2117068,'1','194','1012',460,'Retail Sale Id 1258422',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 15:56:25','',''),(2117069,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:56:25','',''),(2117092,'1','194','1012',460,'Retail Sale Id 1258435',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 15:57:41','',''),(2117093,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:57:41','',''),(2117215,'1','194','1012',460,'Retail Sale Id 1258497',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 16:03:16','',''),(2117216,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:03:16','',''),(2117253,'1','194','1012',460,'Retail Sale Id 1258516',23680.00,0.00,0.00,0.00,560.00,'2021-12-01 16:04:52','',''),(2117254,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 16:04:52','',''),(2117351,'1','194','1012',460,'Retail Sale Id 1258552',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 16:08:28','',''),(2117352,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:08:28','',''),(2117380,'1','194','1012',460,'Retail Sale Id 1258564',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 16:09:36','',''),(2117381,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:09:36','',''),(2117515,'1','194','1012',460,'Retail Sale Id 1258616',6400.00,0.00,0.00,0.00,620.00,'2021-12-01 16:14:44','',''),(2117516,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:14:44','',''),(2117555,'1','194','1012',460,'Retail Sale Id 1258639',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 16:16:23','',''),(2117556,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:16:23','',''),(2117589,'1','194','1012',460,'Retail Sale Id 1258659',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 16:18:13','',''),(2117590,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:18:13','',''),(2117617,'1','194','1012',460,'Retail Sale Id 1258675',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 16:19:24','',''),(2117618,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:19:24','',''),(2117664,'1','194','1012',460,'Retail Sale Id 1258695',2598.40,0.00,0.00,0.00,251.72,'2021-12-01 16:20:58','',''),(2117665,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-01 16:20:58','',''),(2117690,'1','194','1012',460,'Retail Sale Id 1258710',998.40,0.00,0.00,0.00,96.72,'2021-12-01 16:22:00','',''),(2117691,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-01 16:22:00','',''),(2117766,'1','194','1012',460,'Retail Sale Id 1258753',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 16:25:44','',''),(2117767,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:25:44','',''),(2117878,'1','194','1012',460,'Retail Sale Id 1258823',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 16:30:57','',''),(2117879,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:30:57','',''),(2117900,'1','194','1012',460,'Retail Sale Id 1258836',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 16:31:52','',''),(2117901,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:31:52','',''),(2117914,'1','194','1012',460,'Retail Sale Id 1258843',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 16:32:43','',''),(2117915,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:32:43','',''),(2117942,'1','194','1012',460,'Retail Sale Id 1258857',2003.20,0.00,0.00,0.00,194.06,'2021-12-01 16:33:53','',''),(2117943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:33:53','',''),(2117956,'1','194','1012',460,'Retail Sale Id 1258867',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 16:34:46','',''),(2117957,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:34:46','',''),(2117976,'1','194','1012',460,'Retail Sale Id 1258875',5120.00,0.00,0.00,0.00,496.00,'2021-12-01 16:35:44','',''),(2117977,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 16:35:44','',''),(2118006,'1','194','1012',460,'Retail Sale Id 1258890',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 16:37:11','',''),(2118007,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:37:11','',''),(2118032,'1','194','1012',460,'Retail Sale Id 1258905',800.00,0.00,0.00,0.00,77.50,'2021-12-01 16:38:24','',''),(2118033,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-01 16:38:24','',''),(2118052,'1','194','1012',460,'Retail Sale Id 1258915',8000.00,0.00,0.00,0.00,775.00,'2021-12-01 16:39:26','',''),(2118053,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:39:26','',''),(2118096,'1','194','1012',460,'Retail Sale Id 1258941',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 16:41:17','',''),(2118097,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:41:17','',''),(2118146,'1','194','1012',460,'Retail Sale Id 1258966',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 16:44:10','',''),(2118147,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:44:10','',''),(2118180,'1','194','1012',460,'Retail Sale Id 1258984',3840.00,0.00,0.00,0.00,372.00,'2021-12-01 16:45:42','',''),(2118181,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:45:42','',''),(2118206,'1','194','1012',460,'Retail Sale Id 1258999',2560000.00,0.00,0.00,0.00,248000.00,'2021-12-01 16:47:34','',''),(2118207,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4000.00,0.00,'2021-12-01 16:47:34','',''),(2118284,'1','194','1012',460,'Retail Sale Id 1259038',4998.40,0.00,0.00,0.00,484.22,'2021-12-01 16:51:08','',''),(2118285,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-01 16:51:08','',''),(2118389,'1','194','1012',460,'Retail Sale Id 1259084',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 16:55:20','',''),(2118390,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:55:20','',''),(2118411,'1','194','1012',460,'Return of Retail Sale Id 1258999',0.00,2560000.00,4000.00,0.00,-248000.00,'2021-12-01 16:56:01','',''),(2118438,'1','194','1012',460,'Retail Sale Id 1259109',4000.00,0.00,0.00,0.00,387.50,'2021-12-01 16:57:24','',''),(2118439,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:57:24','',''),(2118460,'1','194','1012',460,'Retail Sale Id 1259122',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 16:58:26','',''),(2118461,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:58:26','',''),(2118490,'1','194','1012',460,'Retail Sale Id 1259138',2003.20,0.00,0.00,0.00,194.06,'2021-12-01 16:59:29','',''),(2118491,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-01 16:59:29','',''),(2118512,'1','194','1012',460,'Retail Sale Id 1259148',26640.00,0.00,0.00,0.00,630.00,'2021-12-01 17:00:20','',''),(2118513,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-01 17:00:20','',''),(2118532,'1','194','1012',460,'Retail Sale Id 1259158',1280.00,0.00,0.00,0.00,124.00,'2021-12-01 17:01:33','',''),(2118533,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:01:33','',''),(2118560,'1','194','1012',460,'Retail Sale Id 1259177',1920.00,0.00,0.00,0.00,186.00,'2021-12-01 17:02:42','',''),(2118561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 17:02:42','',''),(2118730,'1','194','1012',460,'Retail Sale Id 1259256',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 17:11:45','',''),(2118731,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:11:45','',''),(2118750,'1','194','1012',460,'Retail Sale Id 1259268',3200.00,0.00,0.00,0.00,310.00,'2021-12-01 17:12:41','',''),(2118751,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:12:41','',''),(2118792,'1','194','1012',460,'Retail Sale Id 1259290',473600.00,0.00,0.00,0.00,11200.00,'2021-12-01 17:15:01','',''),(2118793,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,800.00,0.00,'2021-12-01 17:15:01','',''),(2118956,'1','194','1012',460,'Return of Retail Sale Id 1259177',0.00,1920.00,3.00,0.00,-186.00,'2021-12-01 17:25:45','',''),(2120538,'1','194','1012',460,'Retail Sale Id 1259923',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 06:17:28','',''),(2120539,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 06:17:28','',''),(2120565,'1','194','1012',460,'Retail Sale Id 1259932',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 06:18:08','',''),(2120566,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:18:08','',''),(2120736,'1','194','1012',460,'Retail Sale Id 1260017',998.40,0.00,0.00,0.00,96.72,'2021-12-02 06:31:49','',''),(2120737,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 06:31:49','',''),(2120766,'1','194','1012',460,'Retail Sale Id 1260033',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 06:33:48','',''),(2120767,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 06:33:48','',''),(2120806,'1','194','1012',460,'Retail Sale Id 1260053',5120.00,0.00,0.00,0.00,496.00,'2021-12-02 06:36:33','',''),(2120807,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 06:36:33','',''),(2120873,'1','194','1012',460,'Retail Sale Id 1260068',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 06:38:56','',''),(2120874,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 06:38:56','',''),(2121068,'1','194','1012',460,'Retail Sale Id 1260137',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 06:48:33','',''),(2121069,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 06:48:33','',''),(2121270,'1','194','1012',460,'Retail Sale Id 1260229',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 07:00:18','',''),(2121271,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:00:18','',''),(2121344,'1','194','1012',460,'Retail Sale Id 1260268',6400.00,0.00,0.00,0.00,620.00,'2021-12-02 07:05:11','',''),(2121345,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:05:11','',''),(2121418,'1','194','1012',460,'Retail Sale Id 1260307',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 07:08:40','',''),(2121419,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:08:40','',''),(2121504,'1','194','1012',460,'Retail Sale Id 1260330',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 07:11:45','',''),(2121505,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:11:45','',''),(2121560,'1','194','1012',460,'Retail Sale Id 1260361',6400.00,0.00,0.00,0.00,620.00,'2021-12-02 07:14:53','',''),(2121561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:14:53','',''),(2121696,'1','194','1012',460,'Retail Sale Id 1260423',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 07:21:43','',''),(2121697,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:21:43','',''),(2121751,'1','194','1012',460,'Retail Sale Id 1260452',59200.00,0.00,0.00,0.00,1400.00,'2021-12-02 07:24:39','',''),(2121752,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 07:24:39','',''),(2121779,'1','194','1012',460,'Retail Sale Id 1260466',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 07:25:42','',''),(2121780,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:25:42','',''),(2121809,'1','194','1012',460,'Retail Sale Id 1260484',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 07:27:26','',''),(2121810,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:27:26','',''),(2121975,'1','194','1012',460,'Retail Sale Id 1260586',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 07:37:10','',''),(2121976,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:37:10','',''),(2121997,'1','194','1012',460,'Retail Sale Id 1260598',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 07:38:03','',''),(2121998,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:38:03','',''),(2122080,'1','194','1012',460,'Retail Sale Id 1260637',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 07:41:10','',''),(2122081,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 07:41:10','',''),(2122187,'1','194','1012',460,'Retail Sale Id 1260694',2560.00,0.00,0.00,0.00,248.00,'2021-12-02 07:46:43','',''),(2122188,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 07:46:43','',''),(2122297,'1','194','1012',460,'Retail Sale Id 1260735',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 07:50:17','',''),(2122298,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:50:17','',''),(2122365,'1','194','1012',460,'Retail Sale Id 1260771',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 07:52:50','',''),(2122366,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:52:50','',''),(2122391,'1','194','1012',460,'Retail Sale Id 1260783',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 07:54:02','',''),(2122392,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:54:02','',''),(2122426,'1','194','1012',460,'Retail Sale Id 1260798',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 07:55:26','',''),(2122427,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:55:26','',''),(2122456,'1','194','1012',460,'Retail Sale Id 1260811',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 07:56:33','',''),(2122457,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:56:33','',''),(2122526,'1','194','1012',460,'Retail Sale Id 1260843',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 07:59:02','',''),(2122527,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:59:02','',''),(2122711,'1','194','1012',460,'Retail Sale Id 1260924',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 08:07:14','',''),(2122712,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:07:14','',''),(2122733,'1','194','1012',460,'Retail Sale Id 1260937',2502.40,0.00,0.00,0.00,242.42,'2021-12-02 08:08:13','',''),(2122734,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-02 08:08:13','',''),(2122775,'1','194','1012',460,'Retail Sale Id 1260962',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 08:10:47','',''),(2122776,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:10:47','',''),(2122876,'1','194','1012',460,'Retail Sale Id 1261016',998.40,0.00,0.00,0.00,96.72,'2021-12-02 08:16:49','',''),(2122877,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 08:16:49','',''),(2122958,'1','194','1012',460,'Retail Sale Id 1261058',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 08:20:25','',''),(2122959,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:20:25','',''),(2122990,'1','194','1012',460,'Retail Sale Id 1261074',17760.00,0.00,0.00,0.00,420.00,'2021-12-02 08:22:10','',''),(2122991,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-02 08:22:10','',''),(2123027,'1','194','1012',460,'Retail Sale Id 1261094',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 08:23:40','',''),(2123028,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:23:40','',''),(2123191,'1','194','1012',460,'Retail Sale Id 1261175',8320.00,0.00,0.00,0.00,806.00,'2021-12-02 08:32:52','',''),(2123192,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-02 08:32:52','',''),(2123229,'1','194','1012',460,'Retail Sale Id 1261194',59200.00,0.00,0.00,0.00,1400.00,'2021-12-02 08:35:01','',''),(2123230,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-02 08:35:01','',''),(2123295,'1','194','1012',460,'Retail Sale Id 1261219',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 08:37:51','',''),(2123296,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:37:51','',''),(2123449,'1','194','1012',460,'Retail Sale Id 1261286',640.00,0.00,0.00,0.00,62.00,'2021-12-02 08:44:28','',''),(2123450,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 08:44:28','',''),(2123481,'1','194','1012',460,'Retail Sale Id 1261300',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 08:46:17','',''),(2123482,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:46:17','',''),(2123533,'1','194','1012',460,'Retail Sale Id 1261326',13760.00,0.00,0.00,0.00,1333.00,'2021-12-02 08:50:21','',''),(2123534,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,21.50,0.00,'2021-12-02 08:50:21','',''),(2123561,'1','194','1012',460,'Retail Sale Id 1261340',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 08:52:15','',''),(2123562,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 08:52:15','',''),(2123597,'1','194','1012',460,'Retail Sale Id 1261359',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 08:54:02','',''),(2123598,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 08:54:02','',''),(2123753,'1','194','1012',460,'Retail Sale Id 1261433',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 09:01:40','',''),(2123754,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:01:40','',''),(2123819,'1','194','1012',460,'Retail Sale Id 1261481',998.40,0.00,0.00,0.00,96.72,'2021-12-02 09:05:26','',''),(2123820,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 09:05:26','',''),(2123877,'1','194','1012',460,'Retail Sale Id 1261514',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 09:08:00','',''),(2123878,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:08:00','',''),(2124160,'1','194','1012',460,'Retail Sale Id 1261627',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 09:20:18','',''),(2124161,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:20:18','',''),(2124238,'1','194','1012',460,'Retail Sale Id 1261672',296000.00,0.00,0.00,0.00,7000.00,'2021-12-02 09:24:43','',''),(2124239,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-02 09:24:43','',''),(2124326,'1','194','1012',460,'Retail Sale Id 1261712',36704.00,0.00,0.00,0.00,868.00,'2021-12-02 09:29:59','',''),(2124327,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-02 09:29:59','',''),(2124342,'1','194','1012',460,'Retail Sale Id 1261720',2560.00,0.00,0.00,0.00,248.00,'2021-12-02 09:31:01','',''),(2124343,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 09:31:01','',''),(2124497,'1','194','1012',460,'Retail Sale Id 1261800',87024.00,0.00,0.00,0.00,2058.00,'2021-12-02 09:42:12','',''),(2124498,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,147.00,0.00,'2021-12-02 09:42:12','',''),(2124707,'1','194','1012',460,'Retail Sale Id 1261910',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 09:52:30','',''),(2124708,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:52:30','',''),(2124847,'1','194','1012',460,'Retail Sale Id 1261986',189440.00,0.00,0.00,0.00,4480.00,'2021-12-02 09:59:21','',''),(2124848,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,320.00,0.00,'2021-12-02 09:59:21','',''),(2124881,'1','194','1012',460,'Retail Sale Id 1262002',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 10:01:28','',''),(2124882,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:01:28','',''),(2124916,'1','194','1012',460,'Retail Sale Id 1262017',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 10:02:57','',''),(2124917,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:02:57','',''),(2124955,'1','194','1012',460,'Retail Sale Id 1262037',6400.00,0.00,0.00,0.00,620.00,'2021-12-02 10:05:10','',''),(2124956,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 10:05:10','',''),(2124975,'1','194','1012',460,'Retail Sale Id 1262046',800.00,0.00,0.00,0.00,77.50,'2021-12-02 10:06:35','',''),(2124976,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-02 10:06:35','',''),(2125027,'1','194','1012',460,'Retail Sale Id 1262080',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 10:10:33','',''),(2125028,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:10:33','',''),(2125059,'1','194','1012',460,'Retail Sale Id 1262093',7040.00,0.00,0.00,0.00,682.00,'2021-12-02 10:12:13','',''),(2125060,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 10:12:13','',''),(2125398,'1','194','1012',460,'Retail Sale Id 1262260',15984.00,0.00,0.00,0.00,378.00,'2021-12-02 10:31:04','',''),(2125399,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-02 10:31:04','',''),(2125562,'1','194','1012',460,'Retail Sale Id 1262339',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 10:41:28','',''),(2125563,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 10:41:28','',''),(2125612,'1','194','1012',460,'Retail Sale Id 1262364',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 10:44:07','',''),(2125613,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:44:07','',''),(2126322,'1','194','1012',460,'Retail Sale Id 1262736',23680.00,0.00,0.00,0.00,560.00,'2021-12-02 11:27:57','',''),(2126323,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 11:27:57','',''),(2126407,'1','194','1012',460,'Retail Sale Id 1262775',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 11:31:36','',''),(2126408,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:31:36','',''),(2126468,'1','194','1012',460,'Retail Sale Id 1262796',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 11:34:27','',''),(2126469,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:34:27','',''),(2126548,'1','194','1012',460,'Retail Sale Id 1262825',2560.00,0.00,0.00,0.00,248.00,'2021-12-02 11:37:42','',''),(2126549,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 11:37:42','',''),(2126579,'1','194','1012',460,'Retail Sale Id 1262839',998.40,0.00,0.00,0.00,96.72,'2021-12-02 11:39:35','',''),(2126580,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-02 11:39:35','',''),(2126970,'1','194','1012',460,'Retail Sale Id 1263038',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 12:11:28','',''),(2126971,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:11:28','',''),(2127028,'1','194','1012',460,'Retail Sale Id 1263066',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 12:17:09','',''),(2127029,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:17:09','',''),(2127088,'1','194','1012',460,'Retail Sale Id 1263098',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 12:22:20','',''),(2127089,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 12:22:20','',''),(2127146,'1','194','1012',460,'Retail Sale Id 1263126',29008.00,0.00,0.00,0.00,686.00,'2021-12-02 12:25:51','',''),(2127147,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-02 12:25:51','',''),(2127463,'1','194','1012',460,'Retail Sale Id 1263296',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 12:49:53','',''),(2127464,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:49:53','',''),(2127487,'1','194','1012',460,'Retail Sale Id 1263309',640.00,0.00,0.00,0.00,62.00,'2021-12-02 12:51:39','',''),(2127488,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 12:51:39','',''),(2127536,'1','194','1012',460,'Retail Sale Id 1263332',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 12:56:12','',''),(2127537,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 12:56:12','',''),(2127714,'1','194','1012',460,'Retail Sale Id 1263421',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 13:08:34','',''),(2127715,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:08:34','',''),(2127750,'1','194','1012',460,'Retail Sale Id 1263439',55056.00,0.00,0.00,0.00,1302.00,'2021-12-02 13:11:38','',''),(2127751,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,93.00,0.00,'2021-12-02 13:11:38','',''),(2127935,'1','194','1012',460,'Retail Sale Id 1263512',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 13:22:56','',''),(2127936,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:22:56','',''),(2128242,'1','194','1012',460,'Retail Sale Id 1263638',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 13:43:43','',''),(2128243,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:43:43','',''),(2128308,'1','194','1012',460,'Retail Sale Id 1263672',1900.80,0.00,0.00,0.00,184.14,'2021-12-02 13:47:36','',''),(2128309,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-02 13:47:36','',''),(2128370,'1','194','1012',460,'Retail Sale Id 1263700',4480.00,0.00,0.00,0.00,434.00,'2021-12-02 13:50:47','',''),(2128371,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 13:50:47','',''),(2128457,'1','194','1012',460,'Retail Sale Id 1263741',2560.00,0.00,0.00,0.00,248.00,'2021-12-02 13:55:45','',''),(2128458,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 13:55:45','',''),(2128600,'1','194','1012',460,'Retail Sale Id 1263801',2560.00,0.00,0.00,0.00,248.00,'2021-12-02 14:03:47','',''),(2128601,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 14:03:47','',''),(2128656,'1','194','1012',460,'Retail Sale Id 1263827',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 14:07:01','',''),(2128657,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:07:01','',''),(2128792,'1','194','1012',460,'Retail Sale Id 1263881',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 14:15:42','',''),(2128793,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:15:42','',''),(2128853,'1','194','1012',460,'Retail Sale Id 1263916',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 14:18:26','',''),(2128854,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:18:26','',''),(2129007,'1','194','1012',460,'Retail Sale Id 1263977',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 14:25:16','',''),(2129008,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:25:16','',''),(2129329,'1','194','1012',460,'Retail Sale Id 1264096',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 14:38:59','',''),(2129330,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:38:59','',''),(2129495,'1','194','1012',460,'Retail Sale Id 1264169',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 14:47:24','',''),(2129496,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:47:25','',''),(2129561,'1','194','1012',460,'Retail Sale Id 1264204',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 14:50:33','',''),(2129562,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:50:33','',''),(2129579,'1','194','1012',460,'Retail Sale Id 1264214',4480.00,0.00,0.00,0.00,434.00,'2021-12-02 14:51:51','',''),(2129580,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 14:51:51','',''),(2129596,'1','194','1012',460,'Retail Sale Id 1264221',1952.00,0.00,0.00,0.00,189.10,'2021-12-02 14:53:07','',''),(2129597,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 14:53:07','',''),(2129647,'1','194','1012',460,'Retail Sale Id 1264247',6400.00,0.00,0.00,0.00,620.00,'2021-12-02 14:55:59','',''),(2129648,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 14:55:59','',''),(2129675,'1','194','1012',460,'Retail Sale Id 1264266',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 14:57:06','',''),(2129676,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:57:06','',''),(2129729,'1','194','1012',460,'Retail Sale Id 1264291',5760.00,0.00,0.00,0.00,558.00,'2021-12-02 14:59:48','',''),(2129730,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 14:59:48','',''),(2129791,'1','194','1012',460,'Retail Sale Id 1264322',118400.00,0.00,0.00,0.00,2800.00,'2021-12-02 15:05:58','',''),(2129792,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-02 15:05:58','',''),(2130068,'1','194','1012',460,'Retail Sale Id 1264462',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 15:21:58','',''),(2130069,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:21:58','',''),(2130084,'1','194','1012',460,'Retail Sale Id 1264473',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 15:23:12','',''),(2130085,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:23:12','',''),(2130124,'1','194','1012',460,'Retail Sale Id 1264490',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 15:24:35','',''),(2130125,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 15:24:35','',''),(2130160,'1','194','1012',460,'Retail Sale Id 1264508',23680.00,0.00,0.00,0.00,560.00,'2021-12-02 15:26:04','',''),(2130161,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 15:26:04','',''),(2130196,'1','194','1012',460,'Retail Sale Id 1264526',87024.00,0.00,0.00,0.00,2058.00,'2021-12-02 15:27:35','',''),(2130197,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,147.00,0.00,'2021-12-02 15:27:35','',''),(2130253,'1','194','1012',460,'Retail Sale Id 1264550',22496.00,0.00,0.00,0.00,532.00,'2021-12-02 15:29:52','',''),(2130254,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-02 15:29:52','',''),(2130289,'1','194','1012',460,'Retail Sale Id 1264567',88800.00,0.00,0.00,0.00,2100.00,'2021-12-02 15:31:28','',''),(2130290,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-02 15:31:28','',''),(2130313,'1','194','1012',460,'Retail Sale Id 1264577',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 15:32:49','',''),(2130314,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:32:49','',''),(2130426,'1','194','1012',460,'Retail Sale Id 1264632',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 15:37:30','',''),(2130427,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:37:30','',''),(2130462,'1','194','1012',460,'Retail Sale Id 1264650',2560.00,0.00,0.00,0.00,248.00,'2021-12-02 15:39:39','',''),(2130463,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-02 15:39:39','',''),(2130486,'1','194','1012',460,'Retail Sale Id 1264664',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 15:40:53','',''),(2130487,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:40:53','',''),(2130518,'1','194','1012',460,'Retail Sale Id 1264678',8000.00,0.00,0.00,0.00,775.00,'2021-12-02 15:42:01','',''),(2130519,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:42:01','',''),(2130554,'1','194','1012',460,'Retail Sale Id 1264706',1920.00,0.00,0.00,0.00,186.00,'2021-12-02 15:43:53','',''),(2130555,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:43:53','',''),(2130750,'1','194','1012',460,'Retail Sale Id 1264813',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 15:52:37','',''),(2130751,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:52:37','',''),(2130784,'1','194','1012',460,'Retail Sale Id 1264830',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 15:54:06','',''),(2130785,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 15:54:06','',''),(2132150,'1','194','1012',460,'Retail Sale Id 1265503',4480.00,0.00,0.00,0.00,434.00,'2021-12-02 16:59:02','',''),(2132151,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 16:59:02','',''),(2132211,'1','194','1012',460,'Retail Sale Id 1265522',24864.00,0.00,0.00,0.00,588.00,'2021-12-02 17:02:13','',''),(2132212,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,42.00,0.00,'2021-12-02 17:02:13','',''),(2132247,'1','194','1012',460,'Retail Sale Id 1265538',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 17:04:53','',''),(2132248,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:04:53','',''),(2132270,'1','194','1012',460,'Retail Sale Id 1265552',2003.20,0.00,0.00,0.00,194.06,'2021-12-02 17:06:18','',''),(2132271,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:06:18','',''),(2132288,'1','194','1012',460,'Retail Sale Id 1265560',3840.00,0.00,0.00,0.00,372.00,'2021-12-02 17:07:21','',''),(2132289,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:07:21','',''),(2132305,'1','194','1012',460,'Retail Sale Id 1265571',3200.00,0.00,0.00,0.00,310.00,'2021-12-02 17:08:48','',''),(2132306,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:08:48','',''),(2132336,'1','194','1012',460,'Retail Sale Id 1265585',29600.00,0.00,0.00,0.00,700.00,'2021-12-02 17:10:53','',''),(2132337,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 17:10:53','',''),(2132350,'1','194','1012',460,'Retail Sale Id 1265593',2003.20,0.00,0.00,0.00,194.06,'2021-12-02 17:11:54','',''),(2132351,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-02 17:11:54','',''),(2132385,'1','194','1012',460,'Retail Sale Id 1265611',72256.00,0.00,0.00,0.00,6999.80,'2021-12-02 17:14:14','',''),(2132386,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,112.90,0.00,'2021-12-02 17:14:14','',''),(2132408,'1','194','1012',460,'Retail Sale Id 1265625',1280.00,0.00,0.00,0.00,124.00,'2021-12-02 17:15:40','',''),(2132409,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:15:40','',''),(2132460,'1','194','1012',460,'Retail Sale Id 1265639',90576.00,0.00,0.00,0.00,2142.00,'2021-12-02 17:17:56','',''),(2132461,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,153.00,0.00,'2021-12-02 17:17:56','',''),(2134240,'1','194','1012',460,'Retail Sale Id 1266211',8000.00,0.00,0.00,0.00,775.00,'2021-12-03 06:33:57','',''),(2134241,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:33:57','',''),(2134268,'1','194','1012',460,'Retail Sale Id 1266221',6400.00,0.00,0.00,0.00,620.00,'2021-12-03 06:35:03','',''),(2134269,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 06:35:03','',''),(2134455,'1','194','1012',460,'Retail Sale Id 1266317',207200.00,0.00,0.00,0.00,4900.00,'2021-12-03 06:45:18','',''),(2134456,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-03 06:45:18','',''),(2134637,'1','194','1012',460,'Retail Sale Id 1266405',62160.00,0.00,0.00,0.00,1470.00,'2021-12-03 06:55:06','',''),(2134638,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-03 06:55:06','',''),(2134719,'1','194','1012',460,'Retail Sale Id 1266443',47360.00,0.00,0.00,0.00,1120.00,'2021-12-03 06:59:32','',''),(2134720,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-03 06:59:32','',''),(2134751,'1','194','1012',460,'Retail Sale Id 1266461',2560.00,0.00,0.00,0.00,248.00,'2021-12-03 07:01:21','',''),(2134752,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 07:01:21','',''),(2134905,'1','194','1012',460,'Retail Sale Id 1266546',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 07:11:40','',''),(2134906,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:11:40','',''),(2135010,'1','194','1012',460,'Retail Sale Id 1266590',2003.20,0.00,0.00,0.00,194.06,'2021-12-03 07:16:08','',''),(2135011,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 07:16:08','',''),(2135036,'1','194','1012',460,'Retail Sale Id 1266601',5760.00,0.00,0.00,0.00,558.00,'2021-12-03 07:17:39','',''),(2135037,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 07:17:39','',''),(2135087,'1','194','1012',460,'Retail Sale Id 1266623',7001.60,0.00,0.00,0.00,678.28,'2021-12-03 07:20:08','',''),(2135088,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-03 07:20:08','',''),(2135119,'1','194','1012',460,'Retail Sale Id 1266638',59200.00,0.00,0.00,0.00,1400.00,'2021-12-03 07:22:00','',''),(2135120,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 07:22:00','',''),(2135170,'1','194','1012',460,'Retail Sale Id 1266665',8000.00,0.00,0.00,0.00,775.00,'2021-12-03 07:25:23','',''),(2135171,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:25:23','',''),(2135268,'1','194','1012',460,'Retail Sale Id 1266714',1280.00,0.00,0.00,0.00,124.00,'2021-12-03 07:31:19','',''),(2135269,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 07:31:19','',''),(2135447,'1','194','1012',460,'Retail Sale Id 1266798',29600.00,0.00,0.00,0.00,700.00,'2021-12-03 07:40:40','',''),(2135448,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:40:40','',''),(2135465,'1','194','1012',460,'Retail Sale Id 1266806',6400.00,0.00,0.00,0.00,620.00,'2021-12-03 07:41:59','',''),(2135466,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:41:59','',''),(2135487,'1','194','1012',460,'Retail Sale Id 1266816',8000.00,0.00,0.00,0.00,775.00,'2021-12-03 07:43:29','',''),(2135488,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:43:29','',''),(2135520,'1','194','1012',460,'Retail Sale Id 1266831',29600.00,0.00,0.00,0.00,700.00,'2021-12-03 07:44:47','',''),(2135521,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:44:47','',''),(2135556,'1','194','1012',460,'Retail Sale Id 1266849',2560.00,0.00,0.00,0.00,248.00,'2021-12-03 07:46:48','',''),(2135557,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 07:46:48','',''),(2135578,'1','194','1012',460,'Retail Sale Id 1266860',29600.00,0.00,0.00,0.00,700.00,'2021-12-03 07:47:56','',''),(2135579,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:47:56','',''),(2135635,'1','194','1012',460,'Retail Sale Id 1266885',5920.00,0.00,0.00,0.00,140.00,'2021-12-03 07:50:33','',''),(2135636,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 07:50:33','',''),(2135655,'1','194','1012',460,'Retail Sale Id 1266898',11840.00,0.00,0.00,0.00,280.00,'2021-12-03 07:51:40','',''),(2135656,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-03 07:51:40','',''),(2135690,'1','194','1012',460,'Retail Sale Id 1266913',9472.00,0.00,0.00,0.00,224.00,'2021-12-03 07:53:32','',''),(2135691,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-03 07:53:32','',''),(2135727,'1','194','1012',460,'Retail Sale Id 1266930',640.00,0.00,0.00,0.00,62.00,'2021-12-03 07:56:02','',''),(2135728,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 07:56:02','',''),(2135748,'1','194','1012',460,'Retail Sale Id 1266936',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 07:57:00','',''),(2135749,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:57:00','',''),(2135765,'1','194','1012',460,'Retail Sale Id 1266945',1280.00,0.00,0.00,0.00,124.00,'2021-12-03 07:57:56','',''),(2135766,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 07:57:56','',''),(2135783,'1','194','1012',460,'Retail Sale Id 1266954',29600.00,0.00,0.00,0.00,700.00,'2021-12-03 07:58:59','',''),(2135784,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 07:58:59','',''),(2135913,'1','194','1012',460,'Retail Sale Id 1266990',8000.00,0.00,0.00,0.00,775.00,'2021-12-03 08:02:51','',''),(2135914,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:02:51','',''),(2135956,'1','194','1012',460,'Retail Sale Id 1267012',118400.00,0.00,0.00,0.00,2800.00,'2021-12-03 08:04:49','',''),(2135957,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 08:04:49','',''),(2136084,'1','194','1012',460,'Retail Sale Id 1267077',130240.00,0.00,0.00,0.00,3080.00,'2021-12-03 08:10:36','',''),(2136085,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-03 08:10:36','',''),(2136120,'1','194','1012',460,'Retail Sale Id 1267098',29600.00,0.00,0.00,0.00,700.00,'2021-12-03 08:12:37','',''),(2136121,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 08:12:37','',''),(2136310,'1','194','1012',460,'Retail Sale Id 1267195',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 08:23:13','',''),(2136311,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:23:13','',''),(2136342,'1','194','1012',460,'Retail Sale Id 1267208',10952.00,0.00,0.00,0.00,259.00,'2021-12-03 08:24:55','',''),(2136343,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-03 08:24:55','',''),(2136380,'1','194','1012',460,'Retail Sale Id 1267226',88800.00,0.00,0.00,0.00,2100.00,'2021-12-03 08:26:53','',''),(2136381,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 08:26:53','',''),(2136424,'1','194','1012',460,'Retail Sale Id 1267250',79328.00,0.00,0.00,0.00,1876.00,'2021-12-03 08:30:50','',''),(2136425,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,134.00,0.00,'2021-12-03 08:30:50','',''),(2136441,'1','194','1012',460,'Retail Sale Id 1267257',1280.00,0.00,0.00,0.00,124.00,'2021-12-03 08:31:49','',''),(2136442,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 08:31:49','',''),(2136459,'1','194','1012',460,'Retail Sale Id 1267265',88800.00,0.00,0.00,0.00,2100.00,'2021-12-03 08:33:38','',''),(2136460,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-03 08:33:38','',''),(2136596,'1','194','1012',460,'Retail Sale Id 1267291',1920.00,0.00,0.00,0.00,186.00,'2021-12-03 08:37:36','',''),(2136597,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:37:36','',''),(2136647,'1','194','1012',460,'Retail Sale Id 1267307',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 08:39:19','',''),(2136648,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:39:19','',''),(2136726,'1','194','1012',460,'Retail Sale Id 1267320',1920.00,0.00,0.00,0.00,186.00,'2021-12-03 08:41:26','',''),(2136727,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:41:26','',''),(2136850,'1','194','1012',460,'Retail Sale Id 1267384',4998.40,0.00,0.00,0.00,484.22,'2021-12-03 08:48:19','',''),(2136851,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-03 08:48:19','',''),(2136916,'1','194','1012',460,'Retail Sale Id 1267420',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 08:52:51','',''),(2136917,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:52:51','',''),(2136942,'1','194','1012',460,'Retail Sale Id 1267433',7040.00,0.00,0.00,0.00,682.00,'2021-12-03 08:54:06','',''),(2136943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-03 08:54:06','',''),(2137122,'1','194','1012',460,'Retail Sale Id 1267525',3200.00,0.00,0.00,0.00,310.00,'2021-12-03 09:03:27','',''),(2137123,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:03:27','',''),(2137358,'1','194','1012',460,'Retail Sale Id 1267671',8000.00,0.00,0.00,0.00,775.00,'2021-12-03 09:14:52','',''),(2137359,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:14:52','',''),(2137463,'1','194','1012',460,'Retail Sale Id 1267723',1280.00,0.00,0.00,0.00,124.00,'2021-12-03 09:20:01','',''),(2137464,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:20:01','',''),(2137485,'1','194','1012',460,'Retail Sale Id 1267737',1280.00,0.00,0.00,0.00,124.00,'2021-12-03 09:21:40','',''),(2137486,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:21:40','',''),(2137535,'1','194','1012',460,'Retail Sale Id 1267760',17760.00,0.00,0.00,0.00,420.00,'2021-12-03 09:24:58','',''),(2137536,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 09:24:58','',''),(2137609,'1','194','1012',460,'Retail Sale Id 1267812',29600.00,0.00,0.00,0.00,700.00,'2021-12-03 09:29:56','',''),(2137610,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 09:29:56','',''),(2137635,'1','194','1012',460,'Retail Sale Id 1267825',130240.00,0.00,0.00,0.00,3080.00,'2021-12-03 09:31:24','',''),(2137636,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,220.00,0.00,'2021-12-03 09:31:24','',''),(2137685,'1','194','1012',460,'Retail Sale Id 1267849',23680.00,0.00,0.00,0.00,560.00,'2021-12-03 09:34:10','',''),(2137686,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 09:34:10','',''),(2137703,'1','194','1012',460,'Retail Sale Id 1267859',998.40,0.00,0.00,0.00,96.72,'2021-12-03 09:35:21','',''),(2137704,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 09:35:21','',''),(2137721,'1','194','1012',460,'Retail Sale Id 1267871',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 09:36:40','',''),(2137722,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:36:40','',''),(2137739,'1','194','1012',460,'Retail Sale Id 1267877',1280.00,0.00,0.00,0.00,124.00,'2021-12-03 09:37:49','',''),(2137740,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 09:37:49','',''),(2137781,'1','194','1012',460,'Retail Sale Id 1267904',59200.00,0.00,0.00,0.00,1400.00,'2021-12-03 09:40:35','',''),(2137782,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 09:40:35','',''),(2137793,'1','194','1012',460,'Retail Sale Id 1267912',3840.00,0.00,0.00,0.00,372.00,'2021-12-03 09:41:32','',''),(2137794,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:41:32','',''),(2137817,'1','194','1012',460,'Retail Sale Id 1267923',1497.60,0.00,0.00,0.00,145.08,'2021-12-03 09:42:48','',''),(2137818,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 09:42:48','',''),(2138084,'1','194','1012',460,'Retail Sale Id 1268053',19198.56,0.00,0.00,0.00,454.02,'2021-12-03 09:59:11','',''),(2138085,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,32.43,0.00,'2021-12-03 09:59:11','',''),(2138158,'1','194',NULL,460,'Purchased from AA RANO NIGERIA LIMITED',0.00,14200000.00,25000.00,0.00,0.00,'2021-12-03 10:03:03','',''),(2138193,'1','194',NULL,460,'Reception corrector for bridging 126047',0.00,0.00,0.00,25000.00,0.00,'2021-12-03 10:05:37','',''),(2138194,'1','194','1012',460,'Received from bridging 126047',0.00,0.00,25000.00,0.00,0.00,'2021-12-03 10:05:37','',''),(2138373,'1','194','1012',460,'Retail Sale Id 1268199',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 10:14:53','',''),(2138374,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:14:53','',''),(2138395,'1','194','1012',460,'Retail Sale Id 1268209',35280.00,0.00,0.00,0.00,1200.00,'2021-12-03 10:16:22','',''),(2138396,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 10:16:22','',''),(2138482,'1','194','1012',460,'Retail Sale Id 1268246',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 10:21:04','',''),(2138483,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:21:04','',''),(2138494,'1','194','1012',460,'Retail Sale Id 1268252',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 10:22:04','',''),(2138495,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:22:04','',''),(2138542,'1','194','1012',460,'Retail Sale Id 1268277',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 10:24:38','',''),(2138543,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:24:38','',''),(2138614,'1','194','1012',460,'Retail Sale Id 1268315',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 10:29:14','',''),(2138615,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 10:29:14','',''),(2138803,'1','194','1012',460,'Retail Sale Id 1268406',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 10:40:31','',''),(2138804,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 10:40:31','',''),(2138837,'1','194','1012',460,'Retail Sale Id 1268420',7680.00,0.00,0.00,0.00,864.00,'2021-12-03 10:43:05','',''),(2138838,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 10:43:05','',''),(2138863,'1','194','1012',460,'Retail Sale Id 1268445',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 10:45:06','',''),(2138864,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 10:45:06','',''),(2138869,'1','194','1012',460,'Retail Sale Id 1268448',6400.00,0.00,0.00,0.00,720.00,'2021-12-03 10:45:56','',''),(2138870,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 10:45:56','',''),(2138887,'1','194','1012',460,'Retail Sale Id 1268457',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 10:47:29','',''),(2138888,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:47:29','',''),(2138927,'1','194','1012',460,'Retail Sale Id 1268477',117600.00,0.00,0.00,0.00,4000.00,'2021-12-03 10:50:26','',''),(2138928,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-03 10:50:26','',''),(2139003,'1','194','1012',460,'Retail Sale Id 1268514',55272.00,0.00,0.00,0.00,1880.00,'2021-12-03 10:56:57','',''),(2139004,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,94.00,0.00,'2021-12-03 10:56:57','',''),(2139015,'1','194','1012',460,'Retail Sale Id 1268520',32340.00,0.00,0.00,0.00,1100.00,'2021-12-03 10:58:10','',''),(2139016,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 10:58:10','',''),(2139032,'1','194','1012',460,'Retail Sale Id 1268527',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 10:59:07','',''),(2139033,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 10:59:07','',''),(2139042,'1','194','1012',460,'Retail Sale Id 1268536',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 10:59:53','',''),(2139043,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:59:53','',''),(2139078,'1','194','1012',460,'Retail Sale Id 1268551',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 11:02:40','',''),(2139079,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 11:02:40','',''),(2139095,'1','194','1012',460,'Retail Sale Id 1268560',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 11:03:53','',''),(2139096,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:03:53','',''),(2139175,'1','194','1012',460,'Retail Sale Id 1268606',58800.00,0.00,0.00,0.00,2000.00,'2021-12-03 11:10:11','',''),(2139176,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 11:10:11','',''),(2139199,'1','194','1012',460,'Retail Sale Id 1268618',28812.00,0.00,0.00,0.00,980.00,'2021-12-03 11:12:02','',''),(2139200,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-03 11:12:02','',''),(2139289,'1','194','1012',460,'Retail Sale Id 1268666',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 11:18:02','',''),(2139290,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 11:18:02','',''),(2139368,'1','194','1012',460,'Retail Sale Id 1268699',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 11:24:10','',''),(2139369,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:24:10','',''),(2139388,'1','194','1012',460,'Retail Sale Id 1268711',35280.00,0.00,0.00,0.00,1200.00,'2021-12-03 11:25:48','',''),(2139389,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-03 11:25:48','',''),(2139506,'1','194','1012',460,'Retail Sale Id 1268780',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 11:35:26','',''),(2139507,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 11:35:26','',''),(2139578,'1','194','1012',460,'Retail Sale Id 1268827',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 11:41:43','',''),(2139579,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 11:41:43','',''),(2139620,'1','194','1012',460,'Retail Sale Id 1268845',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 11:44:43','',''),(2139621,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:44:43','',''),(2139648,'1','194','1012',460,'Retail Sale Id 1268862',273755.16,0.00,0.00,0.00,9311.40,'2021-12-03 11:46:47','',''),(2139649,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,465.57,0.00,'2021-12-03 11:46:47','',''),(2139682,'1','194','1012',460,'Retail Sale Id 1268882',17640.00,0.00,0.00,0.00,600.00,'2021-12-03 11:49:03','',''),(2139683,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 11:49:03','',''),(2139705,'1','194','1012',460,'Retail Sale Id 1268896',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 11:50:44','',''),(2139706,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 11:50:44','',''),(2139741,'1','194','1012',460,'Retail Sale Id 1268917',58800.00,0.00,0.00,0.00,2000.00,'2021-12-03 11:54:10','',''),(2139742,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 11:54:10','',''),(2139905,'1','194','1012',460,'Retail Sale Id 1269006',4000.00,0.00,0.00,0.00,450.00,'2021-12-03 12:04:54','',''),(2139906,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 12:04:54','',''),(2140102,'1','194','1012',460,'Retail Sale Id 1269125',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 12:23:00','',''),(2140103,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:23:00','',''),(2140134,'1','194','1012',460,'Retail Sale Id 1269137',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 12:24:57','',''),(2140135,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:24:57','',''),(2140206,'1','194','1012',460,'Retail Sale Id 1269178',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 12:30:37','',''),(2140207,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 12:30:37','',''),(2140355,'1','194','1012',460,'Retail Sale Id 1269237',86436.00,0.00,0.00,0.00,2940.00,'2021-12-03 12:41:51','',''),(2140356,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,147.00,0.00,'2021-12-03 12:41:51','',''),(2140363,'1','194','1012',460,'Retail Sale Id 1269262',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 12:42:59','',''),(2140364,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 12:42:59','',''),(2140479,'1','194','1012',460,'Retail Sale Id 1269313',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 12:50:51','',''),(2140480,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:50:51','',''),(2141061,'1','194','1012',460,'Retail Sale Id 1269591',32340.00,0.00,0.00,0.00,1100.00,'2021-12-03 13:35:49','',''),(2141062,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-03 13:35:49','',''),(2141092,'1','194','1012',460,'Retail Sale Id 1269608',2560.00,0.00,0.00,0.00,288.00,'2021-12-03 13:37:38','',''),(2141093,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 13:37:38','',''),(2141108,'1','194','1012',460,'Retail Sale Id 1269618',7680.00,0.00,0.00,0.00,864.00,'2021-12-03 13:38:45','',''),(2141109,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-03 13:38:45','',''),(2141140,'1','194','1012',460,'Retail Sale Id 1269634',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 13:40:43','',''),(2141141,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:40:43','',''),(2141240,'1','194','1012',460,'Retail Sale Id 1269668',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 13:45:04','',''),(2141241,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:45:04','',''),(2141260,'1','194','1012',460,'Retail Sale Id 1269684',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 13:46:26','',''),(2141261,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:46:26','',''),(2141703,'1','194','1012',460,'Retail Sale Id 1269843',27636.00,0.00,0.00,0.00,940.00,'2021-12-03 14:07:45','',''),(2141704,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-03 14:07:45','',''),(2141906,'1','194','1012',460,'Retail Sale Id 1269929',2560.00,0.00,0.00,0.00,288.00,'2021-12-03 14:21:07','',''),(2141907,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:21:07','',''),(2141973,'1','194','1012',460,'Retail Sale Id 1269949',36750.00,0.00,0.00,0.00,1250.00,'2021-12-03 14:24:24','',''),(2141974,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-03 14:24:24','',''),(2142062,'1','194','1012',460,'Retail Sale Id 1269988',25872.00,0.00,0.00,0.00,880.00,'2021-12-03 14:30:07','',''),(2142063,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-03 14:30:07','',''),(2142297,'1','194','1012',460,'Retail Sale Id 1270074',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 14:41:58','',''),(2142298,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:41:58','',''),(2142321,'1','194','1012',460,'Retail Sale Id 1270081',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 14:42:54','',''),(2142322,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:42:54','',''),(2142359,'1','194','1012',460,'Retail Sale Id 1270096',1497.60,0.00,0.00,0.00,168.48,'2021-12-03 14:43:58','',''),(2142360,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-03 14:43:58','',''),(2142385,'1','194','1012',460,'Retail Sale Id 1270107',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 14:45:10','',''),(2142386,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:45:10','',''),(2142411,'1','194','1012',460,'Retail Sale Id 1270120',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 14:46:15','',''),(2142412,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:46:15','',''),(2142445,'1','194','1012',460,'Retail Sale Id 1270141',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 14:47:41','',''),(2142446,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:47:41','',''),(2142476,'1','194','1012',460,'Retail Sale Id 1270155',640.00,0.00,0.00,0.00,72.00,'2021-12-03 14:48:44','',''),(2142477,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 14:48:44','',''),(2142496,'1','194','1012',460,'Retail Sale Id 1270169',2560.00,0.00,0.00,0.00,288.00,'2021-12-03 14:49:53','',''),(2142497,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 14:49:53','',''),(2142521,'1','194','1012',460,'Retail Sale Id 1270178',1900.80,0.00,0.00,0.00,213.84,'2021-12-03 14:51:12','',''),(2142522,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 14:51:12','',''),(2142642,'1','194','1012',460,'Retail Sale Id 1270226',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 14:56:08','',''),(2142643,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:56:08','',''),(2142761,'1','194','1012',460,'Retail Sale Id 1270288',2560.00,0.00,0.00,0.00,288.00,'2021-12-03 15:04:20','',''),(2142762,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 15:04:20','',''),(2142824,'1','194','1012',460,'Retail Sale Id 1270318',28812.00,0.00,0.00,0.00,980.00,'2021-12-03 15:08:41','',''),(2142825,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-03 15:08:41','',''),(2142852,'1','194','1012',460,'Retail Sale Id 1270334',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 15:09:57','',''),(2142853,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:09:57','',''),(2142880,'1','194','1012',460,'Retail Sale Id 1270353',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 15:11:09','',''),(2142881,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:11:09','',''),(2142916,'1','194','1012',460,'Retail Sale Id 1270365',588.00,0.00,0.00,0.00,20.00,'2021-12-03 15:12:54','',''),(2142917,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 15:12:54','',''),(2142950,'1','194','1012',460,'Retail Sale Id 1270383',23520.00,0.00,0.00,0.00,800.00,'2021-12-03 15:14:12','',''),(2142951,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 15:14:12','',''),(2142990,'1','194','1012',460,'Retail Sale Id 1270412',1999.20,0.00,0.00,0.00,68.00,'2021-12-03 15:15:48','',''),(2142991,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.40,0.00,'2021-12-03 15:15:48','',''),(2143082,'1','194','1012',460,'Retail Sale Id 1270468',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 15:20:18','',''),(2143083,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:20:18','',''),(2143105,'1','194','1012',460,'Retail Sale Id 1270480',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 15:21:17','',''),(2143106,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:21:17','',''),(2143121,'1','194','1012',460,'Retail Sale Id 1270488',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 15:22:24','',''),(2143122,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:22:24','',''),(2143143,'1','194','1012',460,'Retail Sale Id 1270500',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 15:23:35','',''),(2143144,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:23:35','',''),(2143415,'1','194','1012',460,'Retail Sale Id 1270629',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 15:36:19','',''),(2143416,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:36:19','',''),(2143450,'1','194','1012',460,'Retail Sale Id 1270648',31360.00,0.00,0.00,0.00,3528.00,'2021-12-03 15:37:49','',''),(2143451,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-03 15:37:49','',''),(2143664,'1','194','1012',460,'Retail Sale Id 1270751',104076.00,0.00,0.00,0.00,3540.00,'2021-12-03 15:46:18','',''),(2143665,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,177.00,0.00,'2021-12-03 15:46:18','',''),(2143686,'1','194','1012',460,'Retail Sale Id 1270771',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 15:47:31','',''),(2143687,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:47:31','',''),(2143740,'1','194','1012',460,'Retail Sale Id 1270787',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 15:48:53','',''),(2143741,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:48:53','',''),(2143772,'1','194','1012',460,'Retail Sale Id 1270807',1900.80,0.00,0.00,0.00,213.84,'2021-12-03 15:50:51','',''),(2143773,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-03 15:50:51','',''),(2143806,'1','194','1012',460,'Retail Sale Id 1270825',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 15:52:20','',''),(2143807,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:52:20','',''),(2143853,'1','194','1012',460,'Retail Sale Id 1270848',2003.20,0.00,0.00,0.00,225.36,'2021-12-03 15:54:42','',''),(2143854,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-03 15:54:42','',''),(2143871,'1','194','1012',460,'Retail Sale Id 1270858',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 15:55:37','',''),(2143872,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:55:37','',''),(2143887,'1','194','1012',460,'Retail Sale Id 1270866',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 15:56:26','',''),(2143888,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:56:26','',''),(2143903,'1','194','1012',460,'Retail Sale Id 1270875',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 15:57:15','',''),(2143904,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:57:15','',''),(2143921,'1','194','1012',460,'Retail Sale Id 1270886',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 15:58:15','',''),(2143922,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:58:15','',''),(2143944,'1','194','1012',460,'Retail Sale Id 1270893',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 15:59:07','',''),(2143945,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:59:07','',''),(2143960,'1','194','1012',460,'Retail Sale Id 1270901',6400.00,0.00,0.00,0.00,720.00,'2021-12-03 16:00:08','',''),(2143961,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:00:08','',''),(2143991,'1','194','1012',460,'Retail Sale Id 1270915',2560.00,0.00,0.00,0.00,288.00,'2021-12-03 16:01:19','',''),(2143992,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:01:19','',''),(2144023,'1','194','1012',460,'Retail Sale Id 1270928',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 16:02:40','',''),(2144024,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:02:40','',''),(2144049,'1','194','1012',460,'Retail Sale Id 1270945',998.40,0.00,0.00,0.00,112.32,'2021-12-03 16:03:43','',''),(2144050,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:03:43','',''),(2144073,'1','194','1012',460,'Retail Sale Id 1270958',998.40,0.00,0.00,0.00,112.32,'2021-12-03 16:04:43','',''),(2144074,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-03 16:04:43','',''),(2144089,'1','194','1012',460,'Retail Sale Id 1270970',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 16:05:43','',''),(2144090,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:05:43','',''),(2144238,'1','194','1012',460,'Retail Sale Id 1271037',28812.00,0.00,0.00,0.00,980.00,'2021-12-03 16:11:42','',''),(2144239,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-03 16:11:42','',''),(2144302,'1','194','1012',460,'Retail Sale Id 1271067',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 16:16:09','',''),(2144303,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:16:09','',''),(2144338,'1','194','1012',460,'Retail Sale Id 1271085',245784.00,0.00,0.00,0.00,8360.00,'2021-12-03 16:17:57','',''),(2144339,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,418.00,0.00,'2021-12-03 16:17:57','',''),(2144370,'1','194','1012',460,'Retail Sale Id 1271103',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 16:19:20','',''),(2144371,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:19:20','',''),(2144406,'1','194','1012',460,'Retail Sale Id 1271120',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 16:21:11','',''),(2144407,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:21:11','',''),(2144462,'1','194','1012',460,'Retail Sale Id 1271150',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 16:23:51','',''),(2144463,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:23:51','',''),(2144482,'1','194','1012',460,'Retail Sale Id 1271163',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 16:25:07','',''),(2144483,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:25:07','',''),(2144510,'1','194','1012',460,'Retail Sale Id 1271173',3840.00,0.00,0.00,0.00,432.00,'2021-12-03 16:26:41','',''),(2144511,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:26:41','',''),(2144532,'1','194','1012',460,'Retail Sale Id 1271185',6400.00,0.00,0.00,0.00,720.00,'2021-12-03 16:27:54','',''),(2144533,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 16:27:54','',''),(2144548,'1','194','1012',460,'Retail Sale Id 1271198',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 16:28:57','',''),(2144549,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:28:57','',''),(2144584,'1','194','1012',460,'Retail Sale Id 1271215',14700.00,0.00,0.00,0.00,500.00,'2021-12-03 16:30:37','',''),(2144585,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 16:30:37','',''),(2144624,'1','194','1012',460,'Retail Sale Id 1271233',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 16:32:38','',''),(2144625,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:32:38','',''),(2144785,'1','194','1012',460,'Retail Sale Id 1271314',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 16:40:30','',''),(2144786,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:40:30','',''),(2144848,'1','194','1012',460,'Retail Sale Id 1271344',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 16:43:08','',''),(2144849,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:43:08','',''),(2144866,'1','194','1012',460,'Retail Sale Id 1271355',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 16:44:18','',''),(2144867,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:44:18','',''),(2144891,'1','194','1012',460,'Retail Sale Id 1271367',8000.00,0.00,0.00,0.00,900.00,'2021-12-03 16:45:31','',''),(2144892,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:45:31','',''),(2144911,'1','194','1012',460,'Retail Sale Id 1271378',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 16:46:54','',''),(2144912,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:46:54','',''),(2145027,'1','194','1012',460,'Retail Sale Id 1271422',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 16:52:55','',''),(2145028,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:52:55','',''),(2145068,'1','194','1012',460,'Retail Sale Id 1271438',23520.00,0.00,0.00,0.00,800.00,'2021-12-03 16:53:56','',''),(2145069,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-03 16:53:56','',''),(2145088,'1','194','1012',460,'Retail Sale Id 1271449',1920.00,0.00,0.00,0.00,216.00,'2021-12-03 16:54:50','',''),(2145089,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:54:50','',''),(2145172,'1','194','1012',460,'Retail Sale Id 1271475',29400.00,0.00,0.00,0.00,1000.00,'2021-12-03 16:57:48','',''),(2145173,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 16:57:48','',''),(2145192,'1','194','1012',460,'Retail Sale Id 1271486',697.60,0.00,0.00,0.00,78.48,'2021-12-03 16:59:21','',''),(2145193,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-03 16:59:21','',''),(2145216,'1','194','1012',460,'Retail Sale Id 1271495',3200.00,0.00,0.00,0.00,360.00,'2021-12-03 17:00:46','',''),(2145217,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:00:46','',''),(2145308,'1','194','1012',460,'Retail Sale Id 1271549',1280.00,0.00,0.00,0.00,144.00,'2021-12-03 17:07:26','',''),(2145309,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 17:07:26','',''),(2147034,'1','194','1012',460,'Retail Sale Id 1272133',17280.00,0.00,0.00,0.00,1944.00,'2021-12-04 06:32:20','',''),(2147035,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-04 06:32:20','',''),(2147072,'1','194','1012',460,'Retail Sale Id 1272151',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 06:34:57','',''),(2147073,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 06:34:57','',''),(2147114,'1','194','1012',460,'Retail Sale Id 1272167',2003.20,0.00,0.00,0.00,225.36,'2021-12-04 06:36:35','',''),(2147115,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 06:36:35','',''),(2147168,'1','194','1012',460,'Retail Sale Id 1272194',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 06:39:38','',''),(2147169,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:39:38','',''),(2147272,'1','194','1012',460,'Retail Sale Id 1272235',58800.00,0.00,0.00,0.00,2000.00,'2021-12-04 06:45:18','',''),(2147273,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 06:45:18','',''),(2147318,'1','194','1012',460,'Retail Sale Id 1272258',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 06:47:46','',''),(2147319,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 06:47:46','',''),(2147396,'1','194','1012',460,'Retail Sale Id 1272289',57624.00,0.00,0.00,0.00,1960.00,'2021-12-04 06:51:36','',''),(2147397,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-04 06:51:36','',''),(2147416,'1','194','1012',460,'Retail Sale Id 1272302',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 06:53:18','',''),(2147417,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:53:18','',''),(2147471,'1','194','1012',460,'Retail Sale Id 1272321',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 06:55:17','',''),(2147472,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:55:17','',''),(2147568,'1','194','1012',460,'Retail Sale Id 1272374',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 07:00:28','',''),(2147569,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:00:28','',''),(2147758,'1','194','1012',460,'Retail Sale Id 1272470',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 07:11:30','',''),(2147759,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 07:11:30','',''),(2147789,'1','194','1012',460,'Retail Sale Id 1272485',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 07:13:04','',''),(2147790,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:13:04','',''),(2147960,'1','194','1012',460,'Retail Sale Id 1272578',58800.00,0.00,0.00,0.00,2000.00,'2021-12-04 07:21:28','',''),(2147961,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 07:21:28','',''),(2147992,'1','194','1012',460,'Retail Sale Id 1272590',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 07:23:27','',''),(2147993,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:23:27','',''),(2148048,'1','194','1012',460,'Retail Sale Id 1272622',19840.00,0.00,0.00,0.00,2232.00,'2021-12-04 07:26:08','',''),(2148049,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-04 07:26:08','',''),(2148170,'1','194','1012',460,'Retail Sale Id 1272677',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 07:32:14','',''),(2148171,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:32:14','',''),(2148208,'1','194','1012',460,'Retail Sale Id 1272710',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 07:33:48','',''),(2148209,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:33:48','',''),(2148242,'1','194','1012',460,'Retail Sale Id 1272731',1900.80,0.00,0.00,0.00,213.84,'2021-12-04 07:35:07','',''),(2148243,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 07:35:07','',''),(2148311,'1','194','1012',460,'Retail Sale Id 1272763',2560.00,0.00,0.00,0.00,288.00,'2021-12-04 07:38:21','',''),(2148312,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 07:38:21','',''),(2148396,'1','194','1012',460,'Retail Sale Id 1272837',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 07:42:34','',''),(2148397,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:42:34','',''),(2148414,'1','194','1012',460,'Retail Sale Id 1272861',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 07:43:40','',''),(2148415,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:43:40','',''),(2148450,'1','194','1012',460,'Retail Sale Id 1272887',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 07:45:51','',''),(2148451,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:45:51','',''),(2148468,'1','194','1012',460,'Retail Sale Id 1272904',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 07:47:19','',''),(2148469,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:47:19','',''),(2148498,'1','194','1012',460,'Retail Sale Id 1272924',19840.00,0.00,0.00,0.00,2232.00,'2021-12-04 07:48:59','',''),(2148499,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-04 07:48:59','',''),(2148547,'1','194','1012',460,'Retail Sale Id 1272944',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 07:51:57','',''),(2148548,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:51:57','',''),(2148902,'1','194','1012',460,'Retail Sale Id 1273157',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 08:09:12','',''),(2148903,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 08:09:12','',''),(2149030,'1','194','1012',460,'Retail Sale Id 1273222',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 08:14:12','',''),(2149031,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:14:12','',''),(2149096,'1','194','1012',460,'Retail Sale Id 1273246',88200.00,0.00,0.00,0.00,3000.00,'2021-12-04 08:16:49','',''),(2149097,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 08:16:49','',''),(2149192,'1','194','1012',460,'Retail Sale Id 1273297',205800.00,0.00,0.00,0.00,7000.00,'2021-12-04 08:21:00','',''),(2149193,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-04 08:21:00','',''),(2149243,'1','194','1012',460,'Retail Sale Id 1273380',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 08:23:32','',''),(2149244,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:23:32','',''),(2149274,'1','194','1012',460,'Retail Sale Id 1273398',2003.20,0.00,0.00,0.00,225.36,'2021-12-04 08:24:36','',''),(2149275,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 08:24:36','',''),(2149290,'1','194','1012',460,'Retail Sale Id 1273407',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:25:27','',''),(2149291,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:25:27','',''),(2149324,'1','194','1012',460,'Retail Sale Id 1273425',1900.80,0.00,0.00,0.00,213.84,'2021-12-04 08:27:14','',''),(2149325,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 08:27:14','',''),(2149594,'1','194','1012',460,'Retail Sale Id 1273578',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 08:36:50','',''),(2149595,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:36:50','',''),(2149770,'1','194','1012',460,'Retail Sale Id 1273657',1299.20,0.00,0.00,0.00,146.16,'2021-12-04 08:43:47','',''),(2149771,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 08:43:47','',''),(2149880,'1','194','1012',460,'Retail Sale Id 1273716',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 08:48:04','',''),(2149881,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 08:48:04','',''),(2150079,'1','194','1012',460,'Retail Sale Id 1273823',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 08:57:34','',''),(2150080,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:57:34','',''),(2150125,'1','194','1012',460,'Retail Sale Id 1273851',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 08:59:29','',''),(2150126,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 08:59:29','',''),(2150203,'1','194','1012',460,'Retail Sale Id 1273885',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 09:03:40','',''),(2150204,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 09:03:40','',''),(2150235,'1','194','1012',460,'Retail Sale Id 1273915',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 09:04:50','',''),(2150236,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 09:04:50','',''),(2150263,'1','194','1012',460,'Retail Sale Id 1273929',1900.80,0.00,0.00,0.00,213.84,'2021-12-04 09:06:04','',''),(2150264,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 09:06:04','',''),(2150286,'1','194','1012',460,'Retail Sale Id 1273943',3852.80,0.00,0.00,0.00,433.44,'2021-12-04 09:07:22','',''),(2150287,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.02,0.00,'2021-12-04 09:07:22','',''),(2150357,'1','194','1012',460,'Retail Sale Id 1273978',998.40,0.00,0.00,0.00,112.32,'2021-12-04 09:11:36','',''),(2150358,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 09:11:36','',''),(2150387,'1','194','1012',460,'Retail Sale Id 1273991',2003.20,0.00,0.00,0.00,225.36,'2021-12-04 09:12:52','',''),(2150388,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 09:12:52','',''),(2150419,'1','194','1012',460,'Retail Sale Id 1274005',2502.40,0.00,0.00,0.00,281.52,'2021-12-04 09:14:28','',''),(2150420,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-04 09:14:28','',''),(2150451,'1','194','1012',460,'Retail Sale Id 1274027',27048.00,0.00,0.00,0.00,920.00,'2021-12-04 09:16:26','',''),(2150452,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-04 09:16:26','',''),(2150481,'1','194','1012',460,'Retail Sale Id 1274041',6400.00,0.00,0.00,0.00,720.00,'2021-12-04 09:17:43','',''),(2150484,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 09:17:43','',''),(2150517,'1','194','1012',460,'Retail Sale Id 1274060',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 09:19:18','',''),(2150518,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:19:18','',''),(2150581,'1','194','1012',460,'Retail Sale Id 1274081',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 09:21:57','',''),(2150582,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 09:21:57','',''),(2150603,'1','194','1012',460,'Retail Sale Id 1274106',6400.00,0.00,0.00,0.00,720.00,'2021-12-04 09:23:00','',''),(2150604,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 09:23:00','',''),(2152395,'1','194','1012',460,'Retail Sale Id 1274371',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 10:29:12','',''),(2152396,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 10:29:12','',''),(2152469,'1','194','1012',460,'Retail Sale Id 1274388',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 10:33:56','',''),(2152470,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:33:56','',''),(2152482,'1','194','1012',460,'Retail Sale Id 1274398',49664.00,0.00,0.00,0.00,5587.20,'2021-12-04 10:34:51','',''),(2152483,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,77.60,0.00,'2021-12-04 10:34:51','',''),(2152496,'1','194','1012',460,'Retail Sale Id 1274404',38808.00,0.00,0.00,0.00,1320.00,'2021-12-04 10:36:11','',''),(2152497,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,66.00,0.00,'2021-12-04 10:36:11','',''),(2152606,'1','194','1012',460,'Retail Sale Id 1274446',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 10:44:29','',''),(2152607,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:44:29','',''),(2152710,'1','194','1012',460,'Retail Sale Id 1274481',26460.00,0.00,0.00,0.00,900.00,'2021-12-04 10:50:46','',''),(2152711,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-04 10:50:46','',''),(2152747,'1','194','1012',460,'Retail Sale Id 1274503',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 10:52:32','',''),(2152748,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:52:32','',''),(2152821,'1','194','1012',460,'Retail Sale Id 1274533',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 10:56:24','',''),(2152822,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:56:24','',''),(2152980,'1','194','1012',460,'Retail Sale Id 1274600',1299.20,0.00,0.00,0.00,146.16,'2021-12-04 11:05:01','',''),(2152981,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-04 11:05:01','',''),(2153016,'1','194','1012',460,'Retail Sale Id 1274618',28812.00,0.00,0.00,0.00,980.00,'2021-12-04 11:07:09','',''),(2153017,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-04 11:07:09','',''),(2153062,'1','194','1012',460,'Retail Sale Id 1274641',17640.00,0.00,0.00,0.00,600.00,'2021-12-04 11:08:55','',''),(2153063,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-04 11:08:55','',''),(2153199,'1','194','1012',460,'Retail Sale Id 1274717',17640.00,0.00,0.00,0.00,600.00,'2021-12-04 11:15:44','',''),(2153200,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-04 11:15:44','',''),(2153307,'1','194','1012',460,'Retail Sale Id 1274761',7040.00,0.00,0.00,0.00,792.00,'2021-12-04 11:20:53','',''),(2153308,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 11:20:53','',''),(2153560,'1','194','1012',460,'Retail Sale Id 1274902',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 11:35:03','',''),(2153561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 11:35:03','',''),(2153725,'1','194','1012',460,'Retail Sale Id 1274973',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 11:43:31','',''),(2153726,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 11:43:31','',''),(2154077,'1','194','1012',460,'Retail Sale Id 1275102',141120.00,0.00,0.00,0.00,4800.00,'2021-12-04 12:01:54','',''),(2154078,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,240.00,0.00,'2021-12-04 12:01:54','',''),(2154224,'1','194','1012',460,'Retail Sale Id 1275138',88200.00,0.00,0.00,0.00,3000.00,'2021-12-04 12:07:23','',''),(2154225,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 12:07:23','',''),(2154242,'1','194','1012',460,'Retail Sale Id 1275151',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 12:08:56','',''),(2154243,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:08:56','',''),(2154297,'1','194','1012',460,'Retail Sale Id 1275177',27048.00,0.00,0.00,0.00,920.00,'2021-12-04 12:11:35','',''),(2154298,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-04 12:11:35','',''),(2154331,'1','194','1012',460,'Retail Sale Id 1275197',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 12:13:51','',''),(2154332,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:13:51','',''),(2154347,'1','194','1012',460,'Retail Sale Id 1275207',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 12:14:51','',''),(2154348,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:14:51','',''),(2154409,'1','194','1012',460,'Retail Sale Id 1275238',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 12:19:56','',''),(2154410,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 12:19:56','',''),(2154425,'1','194','1012',460,'Retail Sale Id 1275246',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 12:21:15','',''),(2154426,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:21:15','',''),(2154517,'1','194','1012',460,'Retail Sale Id 1275293',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 12:26:38','',''),(2154518,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 12:26:38','',''),(2154557,'1','194','1012',460,'Retail Sale Id 1275311',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 12:28:23','',''),(2154558,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:28:23','',''),(2154599,'1','194','1012',460,'Retail Sale Id 1275332',17610.60,0.00,0.00,0.00,599.00,'2021-12-04 12:30:47','',''),(2154600,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,29.95,0.00,'2021-12-04 12:30:47','',''),(2154649,'1','194','1012',460,'Retail Sale Id 1275357',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 12:33:16','',''),(2154650,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:33:16','',''),(2154683,'1','194','1012',460,'Retail Sale Id 1275374',58800.00,0.00,0.00,0.00,2000.00,'2021-12-04 12:35:56','',''),(2154684,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 12:35:56','',''),(2154733,'1','194','1012',460,'Retail Sale Id 1275399',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 12:38:47','',''),(2154734,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:38:47','',''),(2154812,'1','194','1012',460,'Retail Sale Id 1275437',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 12:45:03','',''),(2154813,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 12:45:03','',''),(2154866,'1','194','1012',460,'Retail Sale Id 1275463',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 12:49:00','',''),(2154867,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:49:00','',''),(2154940,'1','194','1012',460,'Retail Sale Id 1275486',4480.00,0.00,0.00,0.00,504.00,'2021-12-04 12:53:04','',''),(2154941,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 12:53:04','',''),(2155035,'1','194','1012',460,'Retail Sale Id 1275743',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 13:05:58','',''),(2155036,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:05:58','',''),(2155096,'1','194','1012',460,'Retail Sale Id 1275782',38220.00,0.00,0.00,0.00,1300.00,'2021-12-04 13:10:13','',''),(2155097,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-04 13:10:13','',''),(2155159,'1','194','1012',460,'Retail Sale Id 1275809',63504.00,0.00,0.00,0.00,2160.00,'2021-12-04 13:13:56','',''),(2155160,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,108.00,0.00,'2021-12-04 13:13:56','',''),(2155186,'1','194','1012',460,'Retail Sale Id 1275825',88200.00,0.00,0.00,0.00,3000.00,'2021-12-04 13:15:18','',''),(2155187,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-04 13:15:18','',''),(2155345,'1','194','1012',460,'Retail Sale Id 1275883',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 13:24:48','',''),(2155346,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:24:48','',''),(2155482,'1','194','1012',460,'Retail Sale Id 1275927',10560.00,0.00,0.00,0.00,1188.00,'2021-12-04 13:29:59','',''),(2155483,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-04 13:29:59','',''),(2155600,'1','194','1012',460,'Retail Sale Id 1275984',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 13:36:48','',''),(2155601,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:36:48','',''),(2155746,'1','194','1012',460,'Retail Sale Id 1276056',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 13:44:54','',''),(2155747,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 13:44:54','',''),(2155778,'1','194','1012',460,'Retail Sale Id 1276073',6400.00,0.00,0.00,0.00,720.00,'2021-12-04 13:46:43','',''),(2155779,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:46:43','',''),(2155820,'1','194','1012',460,'Retail Sale Id 1276090',998.40,0.00,0.00,0.00,112.32,'2021-12-04 13:48:25','',''),(2155821,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-04 13:48:25','',''),(2155874,'1','194','1012',460,'Retail Sale Id 1276105',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 13:49:52','',''),(2155875,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:49:52','',''),(2155894,'1','194','1012',460,'Retail Sale Id 1276117',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 13:51:07','',''),(2155895,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:51:07','',''),(2155910,'1','194','1012',460,'Retail Sale Id 1276124',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 13:52:28','',''),(2155911,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 13:52:28','',''),(2155944,'1','194','1012',460,'Retail Sale Id 1276141',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 13:54:28','',''),(2155945,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:54:28','',''),(2156053,'1','194','1012',460,'Retail Sale Id 1276190',27636.00,0.00,0.00,0.00,940.00,'2021-12-04 13:59:40','',''),(2156054,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-04 13:59:40','',''),(2156120,'1','194','1012',460,'Retail Sale Id 1276216',11760.00,0.00,0.00,0.00,400.00,'2021-12-04 14:02:18','',''),(2156121,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-04 14:02:18','',''),(2156150,'1','194','1012',460,'Retail Sale Id 1276229',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 14:03:42','',''),(2156151,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:03:42','',''),(2156206,'1','194','1012',460,'Retail Sale Id 1276246',58800.00,0.00,0.00,0.00,2000.00,'2021-12-04 14:04:54','',''),(2156207,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 14:04:54','',''),(2156249,'1','194','1012',460,'Retail Sale Id 1276266',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 14:06:54','',''),(2156250,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:06:54','',''),(2156285,'1','194','1012',460,'Retail Sale Id 1276290',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 14:08:24','',''),(2156286,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:08:24','',''),(2156311,'1','194','1012',460,'Retail Sale Id 1276304',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 14:09:57','',''),(2156312,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:09:57','',''),(2156381,'1','194','1012',460,'Retail Sale Id 1276340',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 14:13:42','',''),(2156382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 14:13:42','',''),(2156442,'1','194','1012',460,'Retail Sale Id 1276362',1900.80,0.00,0.00,0.00,213.84,'2021-12-04 14:15:33','',''),(2156443,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-04 14:15:33','',''),(2156470,'1','194','1012',460,'Retail Sale Id 1276377',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 14:16:53','',''),(2156471,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:16:53','',''),(2156500,'1','194','1012',460,'Retail Sale Id 1276394',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 14:18:22','',''),(2156501,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:18:22','',''),(2156528,'1','194','1012',460,'Retail Sale Id 1276409',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 14:19:44','',''),(2156529,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:19:44','',''),(2156560,'1','194','1012',460,'Retail Sale Id 1276424',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 14:21:38','',''),(2156561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:21:38','',''),(2156594,'1','194','1012',460,'Retail Sale Id 1276445',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 14:23:13','',''),(2156595,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:23:13','',''),(2156635,'1','194','1012',460,'Retail Sale Id 1276459',1497.60,0.00,0.00,0.00,168.48,'2021-12-04 14:25:17','',''),(2156636,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-04 14:25:17','',''),(2156860,'1','194','1012',460,'Retail Sale Id 1276571',9600.00,0.00,0.00,0.00,1080.00,'2021-12-04 14:38:27','',''),(2156861,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 14:38:27','',''),(2156884,'1','194','1012',460,'Retail Sale Id 1276579',2560.00,0.00,0.00,0.00,288.00,'2021-12-04 14:39:55','',''),(2156885,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 14:39:55','',''),(2156904,'1','194','1012',460,'Retail Sale Id 1276594',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 14:42:01','',''),(2156905,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:42:01','',''),(2157015,'1','194','1012',460,'Retail Sale Id 1276614',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 14:45:43','',''),(2157016,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:45:43','',''),(2157279,'1','194','1012',460,'Retail Sale Id 1276715',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 14:58:04','',''),(2157280,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:58:04','',''),(2157361,'1','194','1012',460,'Retail Sale Id 1276753',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 15:02:28','',''),(2157362,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:02:28','',''),(2157408,'1','194','1012',460,'Retail Sale Id 1276771',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 15:04:50','',''),(2157409,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:04:50','',''),(2157436,'1','194','1012',460,'Retail Sale Id 1276786',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 15:06:42','',''),(2157437,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:06:42','',''),(2157462,'1','194','1012',460,'Retail Sale Id 1276801',24000.00,0.00,0.00,0.00,2700.00,'2021-12-04 15:08:57','',''),(2157463,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-04 15:08:57','',''),(2157578,'1','194','1012',460,'Retail Sale Id 1276858',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 15:15:17','',''),(2157579,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:15:17','',''),(2157604,'1','194','1012',460,'Retail Sale Id 1276869',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 15:16:31','',''),(2157605,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:16:31','',''),(2157634,'1','194','1012',460,'Retail Sale Id 1276882',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 15:18:12','',''),(2157635,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 15:18:12','',''),(2157686,'1','194','1012',460,'Retail Sale Id 1276901',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 15:19:54','',''),(2157687,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:19:54','',''),(2157716,'1','194','1012',460,'Retail Sale Id 1276909',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 15:21:03','',''),(2157717,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:21:03','',''),(2157730,'1','194','1012',460,'Retail Sale Id 1276917',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 15:22:08','',''),(2157731,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:22:08','',''),(2157754,'1','194','1012',460,'Retail Sale Id 1276928',25872.00,0.00,0.00,0.00,880.00,'2021-12-04 15:23:27','',''),(2157755,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-04 15:23:27','',''),(2157804,'1','194','1012',460,'Retail Sale Id 1276944',16000.00,0.00,0.00,0.00,1800.00,'2021-12-04 15:25:21','',''),(2157805,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 15:25:21','',''),(2157830,'1','194','1012',460,'Retail Sale Id 1276959',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 15:26:33','',''),(2157831,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:26:33','',''),(2157881,'1','194','1012',460,'Retail Sale Id 1276981',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 15:28:13','',''),(2157882,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:28:13','',''),(2157941,'1','194','1012',460,'Retail Sale Id 1277015',32928.00,0.00,0.00,0.00,1120.00,'2021-12-04 15:31:18','',''),(2157942,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,56.00,0.00,'2021-12-04 15:31:18','',''),(2157997,'1','194','1012',460,'Retail Sale Id 1277038',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 15:33:29','',''),(2157998,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 15:33:29','',''),(2158016,'1','194','1012',460,'Retail Sale Id 1277047',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 15:34:41','',''),(2158017,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:34:41','',''),(2158050,'1','194','1012',460,'Retail Sale Id 1277065',6400.00,0.00,0.00,0.00,720.00,'2021-12-04 15:36:11','',''),(2158051,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 15:36:11','',''),(2158128,'1','194','1012',460,'Retail Sale Id 1277102',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 15:40:34','',''),(2158129,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:40:34','',''),(2158305,'1','194','1012',460,'Retail Sale Id 1277178',9600.00,0.00,0.00,0.00,1080.00,'2021-12-04 15:48:10','',''),(2158306,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-04 15:48:10','',''),(2158396,'1','194','1012',460,'Retail Sale Id 1277221',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 15:52:57','',''),(2158397,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:52:57','',''),(2158488,'1','194','1012',460,'Retail Sale Id 1277284',57624.00,0.00,0.00,0.00,1960.00,'2021-12-04 15:57:22','',''),(2158489,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-04 15:57:22','',''),(2158531,'1','194','1012',460,'Retail Sale Id 1277308',5760.00,0.00,0.00,0.00,648.00,'2021-12-04 15:59:35','',''),(2158532,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 15:59:35','',''),(2158565,'1','194','1012',460,'Retail Sale Id 1277332',5120.00,0.00,0.00,0.00,576.00,'2021-12-04 16:01:03','',''),(2158566,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 16:01:03','',''),(2158602,'1','194','1012',460,'Retail Sale Id 1277348',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 16:02:25','',''),(2158603,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:02:25','',''),(2158628,'1','194','1012',460,'Retail Sale Id 1277360',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 16:04:24','',''),(2158629,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:04:24','',''),(2158686,'1','194','1012',460,'Retail Sale Id 1277390',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 16:07:36','',''),(2158687,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:07:36','',''),(2158710,'1','194','1012',460,'Retail Sale Id 1277403',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 16:08:37','',''),(2158711,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:08:37','',''),(2158763,'1','194','1012',460,'Retail Sale Id 1277430',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 16:10:57','',''),(2158764,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:10:57','',''),(2158809,'1','194','1012',460,'Retail Sale Id 1277454',7040.00,0.00,0.00,0.00,792.00,'2021-12-04 16:13:06','',''),(2158810,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-04 16:13:06','',''),(2158849,'1','194','1012',460,'Retail Sale Id 1277477',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 16:14:37','',''),(2158850,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:14:37','',''),(2158877,'1','194','1012',460,'Retail Sale Id 1277492',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 16:15:44','',''),(2158878,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:15:44','',''),(2158961,'1','194','1012',460,'Retail Sale Id 1277535',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:20:24','',''),(2158962,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:20:24','',''),(2158999,'1','194','1012',460,'Retail Sale Id 1277553',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:21:51','',''),(2159000,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:21:51','',''),(2159053,'1','194','1012',460,'Retail Sale Id 1277578',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 16:24:21','',''),(2159054,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:24:21','',''),(2159085,'1','194','1012',460,'Retail Sale Id 1277603',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 16:25:50','',''),(2159086,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:25:50','',''),(2159117,'1','194','1012',460,'Retail Sale Id 1277621',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 16:27:10','',''),(2159118,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:27:10','',''),(2159155,'1','194','1012',460,'Retail Sale Id 1277638',3001.60,0.00,0.00,0.00,337.68,'2021-12-04 16:28:27','',''),(2159156,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-04 16:28:27','',''),(2159177,'1','194','1012',460,'Retail Sale Id 1277650',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 16:29:28','',''),(2159178,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:29:28','',''),(2159205,'1','194','1012',460,'Retail Sale Id 1277665',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 16:30:47','',''),(2159206,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:30:47','',''),(2159251,'1','194','1012',460,'Retail Sale Id 1277678',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 16:32:51','',''),(2159252,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:32:51','',''),(2159269,'1','194','1012',460,'Retail Sale Id 1277693',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 16:34:28','',''),(2159270,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:34:28','',''),(2159303,'1','194','1012',460,'Retail Sale Id 1277708',2560.00,0.00,0.00,0.00,288.00,'2021-12-04 16:36:20','',''),(2159304,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 16:36:20','',''),(2159317,'1','194','1012',460,'Retail Sale Id 1277720',640.00,0.00,0.00,0.00,72.00,'2021-12-04 16:37:12','',''),(2159318,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 16:37:12','',''),(2159358,'1','194','1012',460,'Retail Sale Id 1277738',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 16:38:44','',''),(2159359,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:38:44','',''),(2159425,'1','194','1012',460,'Retail Sale Id 1277751',6400.00,0.00,0.00,0.00,720.00,'2021-12-04 16:40:07','',''),(2159426,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:40:07','',''),(2159469,'1','194','1012',460,'Retail Sale Id 1277770',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 16:41:39','',''),(2159470,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:41:39','',''),(2159507,'1','194','1012',460,'Retail Sale Id 1277810',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 16:44:30','',''),(2159508,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:44:30','',''),(2159583,'1','194','1012',460,'Retail Sale Id 1277870',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 16:48:19','',''),(2159584,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:48:19','',''),(2159620,'1','194','1012',460,'Retail Sale Id 1277884',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 16:49:53','',''),(2159621,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:49:53','',''),(2159656,'1','194','1012',460,'Retail Sale Id 1277904',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 16:51:28','',''),(2159657,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:51:28','',''),(2159686,'1','194','1012',460,'Retail Sale Id 1277916',29400.00,0.00,0.00,0.00,1000.00,'2021-12-04 16:52:47','',''),(2159687,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 16:52:47','',''),(2159704,'1','194','1012',460,'Retail Sale Id 1277925',12800.00,0.00,0.00,0.00,1440.00,'2021-12-04 16:54:03','',''),(2159705,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-04 16:54:03','',''),(2159734,'1','194','1012',460,'Retail Sale Id 1277940',1280.00,0.00,0.00,0.00,144.00,'2021-12-04 16:55:46','',''),(2159735,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:55:46','',''),(2159751,'1','194','1012',460,'Retail Sale Id 1277947',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 16:56:47','',''),(2159752,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:56:47','',''),(2159765,'1','194','1012',460,'Retail Sale Id 1277959',5760.00,0.00,0.00,0.00,648.00,'2021-12-04 16:58:14','',''),(2159766,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-04 16:58:14','',''),(2159803,'1','194','1012',460,'Retail Sale Id 1277975',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 16:59:56','',''),(2159804,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:59:56','',''),(2159845,'1','194','1012',460,'Retail Sale Id 1277991',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 17:02:00','',''),(2159846,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:02:00','',''),(2159869,'1','194','1012',460,'Retail Sale Id 1278006',3200.00,0.00,0.00,0.00,360.00,'2021-12-04 17:03:15','',''),(2159870,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:03:15','',''),(2159901,'1','194','1012',460,'Retail Sale Id 1278025',2003.20,0.00,0.00,0.00,225.36,'2021-12-04 17:05:44','',''),(2159902,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-04 17:05:44','',''),(2159919,'1','194','1012',460,'Retail Sale Id 1278034',7360.00,0.00,0.00,0.00,828.00,'2021-12-04 17:06:54','',''),(2159920,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-04 17:06:54','',''),(2160049,'1','194','1012',460,'Retail Sale Id 1278096',235200.00,0.00,0.00,0.00,8000.00,'2021-12-04 17:15:29','',''),(2160050,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-04 17:15:29','',''),(2160083,'1','194','1012',460,'Retail Sale Id 1278111',124656.00,0.00,0.00,0.00,4240.00,'2021-12-04 17:17:42','',''),(2160084,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,212.00,0.00,'2021-12-04 17:17:42','',''),(2160127,'1','194','1012',460,'Retail Sale Id 1278136',2560.00,0.00,0.00,0.00,288.00,'2021-12-04 17:20:39','',''),(2160128,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 17:20:39','',''),(2160167,'1','194','1012',460,'Retail Sale Id 1278151',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 17:22:07','',''),(2160168,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:22:07','',''),(2160203,'1','194','1012',460,'Retail Sale Id 1278170',26460.00,0.00,0.00,0.00,900.00,'2021-12-04 17:24:09','',''),(2160204,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-04 17:24:09','',''),(2160231,'1','194','1012',460,'Retail Sale Id 1278180',1203.20,0.00,0.00,0.00,135.36,'2021-12-04 17:25:30','',''),(2160232,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-04 17:25:30','',''),(2160266,'1','194','1012',460,'Retail Sale Id 1278185',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 17:26:30','',''),(2160267,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:26:30','',''),(2160385,'1','194','1012',460,'Retail Sale Id 1278236',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 17:35:58','',''),(2160386,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:35:58','',''),(2160409,'1','194','1012',460,'Retail Sale Id 1278250',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 17:38:07','',''),(2160410,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:38:07','',''),(2160565,'1','194','1012',460,'Retail Sale Id 1278289',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 17:43:51','',''),(2160566,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:43:51','',''),(2160602,'1','194','1012',460,'Retail Sale Id 1278302',5120.00,0.00,0.00,0.00,576.00,'2021-12-04 17:45:23','',''),(2160603,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-04 17:45:23','',''),(2160642,'1','194','1012',460,'Retail Sale Id 1278312',1920.00,0.00,0.00,0.00,216.00,'2021-12-04 17:46:56','',''),(2160643,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:46:56','',''),(2160719,'1','194','1012',460,'Retail Sale Id 1278348',3840.00,0.00,0.00,0.00,432.00,'2021-12-04 17:54:06','',''),(2160720,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:54:06','',''),(2160735,'1','194','1012',460,'Retail Sale Id 1278356',8000.00,0.00,0.00,0.00,900.00,'2021-12-04 17:55:25','',''),(2160736,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:55:25','',''),(2160792,'1','194','1012',460,'Retail Sale Id 1278385',640.00,0.00,0.00,0.00,72.00,'2021-12-04 18:02:50','',''),(2160793,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-04 18:02:50','',''),(2162178,'1','194','1012',460,'Retail Sale Id 1278725',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 06:25:56','',''),(2162179,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 06:25:56','',''),(2162193,'1','194','1012',460,'Retail Sale Id 1278731',28812.00,0.00,0.00,0.00,980.00,'2021-12-05 06:27:29','',''),(2162194,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-05 06:27:29','',''),(2162209,'1','194','1012',460,'Retail Sale Id 1278740',1497.60,0.00,0.00,0.00,168.48,'2021-12-05 06:29:17','',''),(2162210,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 06:29:17','',''),(2162223,'1','194','1012',460,'Retail Sale Id 1278747',5760.00,0.00,0.00,0.00,648.00,'2021-12-05 06:30:41','',''),(2162224,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 06:30:41','',''),(2162310,'1','194','1012',460,'Retail Sale Id 1278782',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 06:37:29','',''),(2162311,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 06:37:29','',''),(2162326,'1','194','1012',460,'Retail Sale Id 1278787',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 06:38:36','',''),(2162327,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 06:38:36','',''),(2162454,'1','194','1012',460,'Retail Sale Id 1278840',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 06:45:13','',''),(2162455,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 06:45:13','',''),(2162512,'1','194','1012',460,'Retail Sale Id 1278866',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 06:49:31','',''),(2162513,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 06:49:31','',''),(2162559,'1','194','1012',460,'Retail Sale Id 1278889',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 06:51:05','',''),(2162560,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 06:51:05','',''),(2162587,'1','194','1012',460,'Retail Sale Id 1278903',58800.00,0.00,0.00,0.00,2000.00,'2021-12-05 06:53:01','',''),(2162588,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 06:53:01','',''),(2162635,'1','194','1012',460,'Retail Sale Id 1278934',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 06:55:46','',''),(2162636,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 06:55:46','',''),(2162748,'1','194','1012',460,'Retail Sale Id 1278995',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 07:02:44','',''),(2162749,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:02:44','',''),(2162867,'1','194','1012',460,'Retail Sale Id 1279053',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 07:08:58','',''),(2162868,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 07:08:58','',''),(2162917,'1','194','1012',460,'Retail Sale Id 1279081',88200.00,0.00,0.00,0.00,3000.00,'2021-12-05 07:11:24','',''),(2162918,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 07:11:24','',''),(2162941,'1','194','1012',460,'Retail Sale Id 1279096',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 07:13:00','',''),(2162942,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:13:00','',''),(2162971,'1','194','1012',460,'Retail Sale Id 1279112',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 07:14:38','',''),(2162972,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 07:14:38','',''),(2163034,'1','194','1012',460,'Retail Sale Id 1279147',26460.00,0.00,0.00,0.00,900.00,'2021-12-05 07:18:00','',''),(2163035,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 07:18:00','',''),(2163078,'1','194','1012',460,'Retail Sale Id 1279166',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 07:20:40','',''),(2163079,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 07:20:40','',''),(2163090,'1','194','1012',460,'Retail Sale Id 1279173',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 07:21:55','',''),(2163091,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 07:21:55','',''),(2163136,'1','194','1012',460,'Retail Sale Id 1279222',28812.00,0.00,0.00,0.00,980.00,'2021-12-05 07:24:57','',''),(2163137,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-05 07:24:57','',''),(2163179,'1','194','1012',460,'Retail Sale Id 1279251',3001.60,0.00,0.00,0.00,337.68,'2021-12-05 07:26:50','',''),(2163180,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-05 07:26:50','',''),(2163211,'1','194','1012',460,'Retail Sale Id 1279273',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 07:28:25','',''),(2163212,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 07:28:25','',''),(2163270,'1','194','1012',460,'Retail Sale Id 1279300',1497.60,0.00,0.00,0.00,168.48,'2021-12-05 07:33:24','',''),(2163271,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 07:33:24','',''),(2163292,'1','194','1012',460,'Retail Sale Id 1279318',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 07:34:30','',''),(2163293,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:34:30','',''),(2163471,'1','194','1012',460,'Retail Sale Id 1279420',10899.20,0.00,0.00,0.00,1226.16,'2021-12-05 07:44:01','',''),(2163472,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,17.03,0.00,'2021-12-05 07:44:01','',''),(2163516,'1','194','1012',460,'Retail Sale Id 1279448',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 07:46:55','',''),(2163517,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 07:46:55','',''),(2163633,'1','194','1012',460,'Retail Sale Id 1279496',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 07:52:14','',''),(2163634,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 07:52:14','',''),(2163667,'1','194','1012',460,'Retail Sale Id 1279509',16742.40,0.00,0.00,0.00,1883.52,'2021-12-05 07:54:15','',''),(2163668,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,26.16,0.00,'2021-12-05 07:54:15','',''),(2163724,'1','194','1012',460,'Retail Sale Id 1279543',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 07:58:03','',''),(2163725,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 07:58:03','',''),(2163768,'1','194','1012',460,'Retail Sale Id 1279569',1497.60,0.00,0.00,0.00,168.48,'2021-12-05 08:00:23','',''),(2163769,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:00:23','',''),(2163862,'1','194','1012',460,'Retail Sale Id 1279621',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 08:05:32','',''),(2163863,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 08:05:32','',''),(2163896,'1','194','1012',460,'Retail Sale Id 1279647',640.00,0.00,0.00,0.00,72.00,'2021-12-05 08:07:10','',''),(2163897,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 08:07:10','',''),(2163932,'1','194','1012',460,'Retail Sale Id 1279670',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 08:08:40','',''),(2163933,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 08:08:40','',''),(2163976,'1','194','1012',460,'Retail Sale Id 1279691',1497.60,0.00,0.00,0.00,168.48,'2021-12-05 08:10:32','',''),(2163977,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 08:10:32','',''),(2164002,'1','194','1012',460,'Retail Sale Id 1279713',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 08:12:06','',''),(2164003,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:12:06','',''),(2164030,'1','194','1012',460,'Retail Sale Id 1279730',1900.80,0.00,0.00,0.00,213.84,'2021-12-05 08:13:47','',''),(2164031,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 08:13:47','',''),(2164114,'1','194','1012',460,'Retail Sale Id 1279772',7040.00,0.00,0.00,0.00,792.00,'2021-12-05 08:18:22','',''),(2164115,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 08:18:22','',''),(2164178,'1','194','1012',460,'Retail Sale Id 1279809',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 08:21:33','',''),(2164179,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 08:21:33','',''),(2164320,'1','194','1012',460,'Retail Sale Id 1279864',7040.00,0.00,0.00,0.00,792.00,'2021-12-05 08:27:16','',''),(2164321,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-05 08:27:16','',''),(2164634,'1','194','1012',460,'Retail Sale Id 1280036',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 08:43:29','',''),(2164635,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 08:43:29','',''),(2164683,'1','194','1012',460,'Retail Sale Id 1280055',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 08:46:05','',''),(2164684,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 08:46:05','',''),(2164835,'1','194','1012',460,'Retail Sale Id 1280138',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 08:54:30','',''),(2164836,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 08:54:30','',''),(2165166,'1','194','1012',460,'Retail Sale Id 1280315',998.40,0.00,0.00,0.00,112.32,'2021-12-05 09:11:48','',''),(2165167,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 09:11:48','',''),(2165195,'1','194','1012',460,'Retail Sale Id 1280330',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 09:13:15','',''),(2165196,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 09:13:15','',''),(2165234,'1','194','1012',460,'Retail Sale Id 1280351',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 09:15:50','',''),(2165235,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:15:50','',''),(2165302,'1','194','1012',460,'Retail Sale Id 1280418',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 09:20:14','',''),(2165303,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 09:20:14','',''),(2165337,'1','194','1012',460,'Retail Sale Id 1280438',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 09:22:13','',''),(2165338,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:22:13','',''),(2165350,'1','194','1012',460,'Retail Sale Id 1280443',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 09:23:36','',''),(2165351,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:23:36','',''),(2165414,'1','194','1012',460,'Retail Sale Id 1280480',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 09:26:42','',''),(2165415,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 09:26:42','',''),(2165880,'1','194','1012',460,'Retail Sale Id 1280697',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 09:47:05','',''),(2165881,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 09:47:05','',''),(2165925,'1','194','1012',460,'Retail Sale Id 1280717',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 09:49:01','',''),(2165926,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 09:49:01','',''),(2166061,'1','194','1012',460,'Retail Sale Id 1280788',11840.00,0.00,0.00,0.00,1332.00,'2021-12-05 09:57:05','',''),(2166062,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-05 09:57:05','',''),(2166091,'1','194','1012',460,'Retail Sale Id 1280805',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 09:59:04','',''),(2166092,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:59:04','',''),(2166171,'1','194','1012',460,'Retail Sale Id 1280847',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 10:03:54','',''),(2166172,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:03:54','',''),(2166193,'1','194','1012',460,'Retail Sale Id 1280858',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 10:05:27','',''),(2166194,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 10:05:27','',''),(2166225,'1','194','1012',460,'Retail Sale Id 1280874',58800.00,0.00,0.00,0.00,2000.00,'2021-12-05 10:07:59','',''),(2166226,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 10:07:59','',''),(2166239,'1','194','1012',460,'Retail Sale Id 1280884',5120.00,0.00,0.00,0.00,576.00,'2021-12-05 10:09:02','',''),(2166240,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 10:09:02','',''),(2166257,'1','194','1012',460,'Retail Sale Id 1280889',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 10:10:16','',''),(2166258,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:10:16','',''),(2166415,'1','194','1012',460,'Retail Sale Id 1280973',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 10:20:31','',''),(2166416,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:20:31','',''),(2166546,'1','194','1012',460,'Retail Sale Id 1281037',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 10:28:46','',''),(2166549,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 10:28:46','',''),(2166572,'1','194','1012',460,'Retail Sale Id 1281051',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 10:30:12','',''),(2166573,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:30:12','',''),(2166634,'1','194','1012',460,'Retail Sale Id 1281083',27048.00,0.00,0.00,0.00,920.00,'2021-12-05 10:34:50','',''),(2166635,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-05 10:34:50','',''),(2166676,'1','194','1012',460,'Retail Sale Id 1281102',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 10:36:28','',''),(2166677,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:36:28','',''),(2166746,'1','194','1012',460,'Retail Sale Id 1281138',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 10:40:57','',''),(2166747,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 10:40:57','',''),(2166794,'1','194','1012',460,'Retail Sale Id 1281155',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 10:43:52','',''),(2166795,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:43:52','',''),(2166917,'1','194','1012',460,'Retail Sale Id 1281225',13875.20,0.00,0.00,0.00,1560.96,'2021-12-05 10:49:31','',''),(2166918,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,21.68,0.00,'2021-12-05 10:49:31','',''),(2167025,'1','194','1012',460,'Retail Sale Id 1281291',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 10:56:22','',''),(2167026,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 10:56:22','',''),(2167128,'1','194','1012',460,'Retail Sale Id 1281328',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 11:01:18','',''),(2167129,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 11:01:18','',''),(2167148,'1','194','1012',460,'Retail Sale Id 1281347',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 11:03:03','',''),(2167149,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:03:03','',''),(2167178,'1','194','1012',460,'Retail Sale Id 1281357',26460.00,0.00,0.00,0.00,900.00,'2021-12-05 11:05:21','',''),(2167179,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 11:05:21','',''),(2167206,'1','194','1012',460,'Retail Sale Id 1281381',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 11:07:12','',''),(2167207,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:07:12','',''),(2167260,'1','194','1012',460,'Retail Sale Id 1281413',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 11:09:54','',''),(2167261,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:09:54','',''),(2167328,'1','194','1012',460,'Retail Sale Id 1281453',46746.00,0.00,0.00,0.00,1590.00,'2021-12-05 11:14:11','',''),(2167329,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,79.50,0.00,'2021-12-05 11:14:11','',''),(2167372,'1','194','1012',460,'Retail Sale Id 1281481',1900.80,0.00,0.00,0.00,213.84,'2021-12-05 11:17:19','',''),(2167373,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-05 11:17:19','',''),(2167413,'1','194','1012',460,'Retail Sale Id 1281494',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 11:18:56','',''),(2167414,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:18:56','',''),(2167449,'1','194','1012',460,'Retail Sale Id 1281509',27048.00,0.00,0.00,0.00,920.00,'2021-12-05 11:21:02','',''),(2167450,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-05 11:21:02','',''),(2167461,'1','194','1012',460,'Retail Sale Id 1281514',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 11:22:05','',''),(2167462,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:22:05','',''),(2167494,'1','194','1012',460,'Retail Sale Id 1281530',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 11:24:19','',''),(2167495,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:24:19','',''),(2167520,'1','194','1012',460,'Retail Sale Id 1281545',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 11:25:29','',''),(2167521,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:25:29','',''),(2167561,'1','194','1012',460,'Retail Sale Id 1281565',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 11:27:53','',''),(2167562,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 11:27:53','',''),(2167639,'1','194','1012',460,'Retail Sale Id 1281605',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 11:31:37','',''),(2167640,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:31:37','',''),(2167792,'1','194','1012',460,'Retail Sale Id 1281675',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 11:40:44','',''),(2167793,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:40:44','',''),(2167846,'1','194','1012',460,'Retail Sale Id 1281749',640.00,0.00,0.00,0.00,72.00,'2021-12-05 11:44:31','',''),(2167847,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 11:44:31','',''),(2167909,'1','194','1012',460,'Retail Sale Id 1281773',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 11:47:46','',''),(2167910,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 11:47:46','',''),(2168110,'1','194','1012',460,'Retail Sale Id 1281893',27048.00,0.00,0.00,0.00,920.00,'2021-12-05 11:59:24','',''),(2168111,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-05 11:59:24','',''),(2168148,'1','194','1012',460,'Retail Sale Id 1281913',5880.00,0.00,0.00,0.00,200.00,'2021-12-05 12:01:42','',''),(2168149,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 12:01:42','',''),(2168204,'1','194','1012',460,'Retail Sale Id 1281945',640.00,0.00,0.00,0.00,72.00,'2021-12-05 12:05:06','',''),(2168205,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 12:05:06','',''),(2168269,'1','194','1012',460,'Retail Sale Id 1281976',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 12:08:12','',''),(2168270,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:08:12','',''),(2168303,'1','194','1012',460,'Retail Sale Id 1281994',1497.60,0.00,0.00,0.00,168.48,'2021-12-05 12:09:40','',''),(2168304,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 12:09:40','',''),(2168330,'1','194','1012',460,'Retail Sale Id 1282003',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 12:11:13','',''),(2168331,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:11:13','',''),(2168356,'1','194','1012',460,'Retail Sale Id 1282020',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 12:12:38','',''),(2168357,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:12:38','',''),(2168405,'1','194','1012',460,'Retail Sale Id 1282046',58800.00,0.00,0.00,0.00,2000.00,'2021-12-05 12:14:28','',''),(2168406,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 12:14:28','',''),(2168436,'1','194','1012',460,'Retail Sale Id 1282055',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 12:15:16','',''),(2168437,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:15:16','',''),(2168470,'1','194','1012',460,'Retail Sale Id 1282071',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 12:16:57','',''),(2168471,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 12:16:57','',''),(2168514,'1','194','1012',460,'Retail Sale Id 1282093',7680.00,0.00,0.00,0.00,864.00,'2021-12-05 12:18:49','',''),(2168515,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-05 12:18:49','',''),(2168538,'1','194','1012',460,'Retail Sale Id 1282107',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 12:19:49','',''),(2168539,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:19:49','',''),(2168569,'1','194','1012',460,'Retail Sale Id 1282118',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 12:20:56','',''),(2168570,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 12:20:56','',''),(2168595,'1','194','1012',460,'Retail Sale Id 1282133',35280.00,0.00,0.00,0.00,1200.00,'2021-12-05 12:22:02','',''),(2168596,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 12:22:02','',''),(2168639,'1','194','1012',460,'Retail Sale Id 1282157',640.00,0.00,0.00,0.00,72.00,'2021-12-05 12:23:58','',''),(2168640,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 12:23:58','',''),(2168718,'1','194','1012',460,'Retail Sale Id 1282186',58800.00,0.00,0.00,0.00,2000.00,'2021-12-05 12:26:39','',''),(2168719,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-05 12:26:39','',''),(2168776,'1','194','1012',460,'Retail Sale Id 1282224',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 12:29:18','',''),(2168777,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:29:18','',''),(2168812,'1','194','1012',460,'Retail Sale Id 1282246',800.00,0.00,0.00,0.00,90.00,'2021-12-05 12:31:14','',''),(2168813,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-05 12:31:14','',''),(2168882,'1','194','1012',460,'Retail Sale Id 1282278',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 12:34:46','',''),(2168883,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:34:46','',''),(2169021,'1','194','1012',460,'Retail Sale Id 1282355',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 12:42:19','',''),(2169022,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 12:42:19','',''),(2169339,'1','194','1012',460,'Retail Sale Id 1282528',5120.00,0.00,0.00,0.00,576.00,'2021-12-05 13:00:28','',''),(2169340,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 13:00:28','',''),(2169480,'1','194','1012',460,'Retail Sale Id 1282628',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 13:08:03','',''),(2169481,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:08:03','',''),(2169588,'1','194','1012',460,'Retail Sale Id 1282682',640.00,0.00,0.00,0.00,72.00,'2021-12-05 13:14:03','',''),(2169589,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 13:14:03','',''),(2169686,'1','194','1012',460,'Retail Sale Id 1282725',35280.00,0.00,0.00,0.00,1200.00,'2021-12-05 13:20:24','',''),(2169687,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-05 13:20:24','',''),(2169810,'1','194','1012',460,'Retail Sale Id 1282793',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 13:27:45','',''),(2169811,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 13:27:45','',''),(2169989,'1','194','1012',460,'Retail Sale Id 1282871',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 13:36:24','',''),(2169990,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:36:24','',''),(2170118,'1','194','1012',460,'Retail Sale Id 1282914',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 13:42:20','',''),(2170119,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:42:20','',''),(2170169,'1','194','1012',460,'Retail Sale Id 1282927',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 13:44:19','',''),(2170170,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 13:44:19','',''),(2170302,'1','194','1012',460,'Retail Sale Id 1282989',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 13:51:51','',''),(2170303,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:51:51','',''),(2170346,'1','194','1012',460,'Retail Sale Id 1283008',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 13:54:22','',''),(2170347,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:54:22','',''),(2170372,'1','194','1012',460,'Retail Sale Id 1283019',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 13:55:37','',''),(2170373,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:55:37','',''),(2170453,'1','194','1012',460,'Retail Sale Id 1283048',998.40,0.00,0.00,0.00,112.32,'2021-12-05 13:59:08','',''),(2170454,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 13:59:08','',''),(2170501,'1','194','1012',460,'Retail Sale Id 1283071',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 14:02:29','',''),(2170502,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:02:29','',''),(2170669,'1','194','1012',460,'Retail Sale Id 1283155',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 14:12:53','',''),(2170670,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:12:53','',''),(2170921,'1','194','1012',460,'Retail Sale Id 1283243',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 14:24:19','',''),(2170922,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 14:24:19','',''),(2170947,'1','194','1012',460,'Retail Sale Id 1283262',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 14:25:45','',''),(2170948,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:25:45','',''),(2171017,'1','194','1012',460,'Retail Sale Id 1283295',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 14:30:14','',''),(2171018,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:30:14','',''),(2171108,'1','194','1012',460,'Retail Sale Id 1283320',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 14:33:22','',''),(2171109,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:33:22','',''),(2171229,'1','194','1012',460,'Retail Sale Id 1283360',998.40,0.00,0.00,0.00,112.32,'2021-12-05 14:39:40','',''),(2171230,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-05 14:39:40','',''),(2171277,'1','194','1012',460,'Retail Sale Id 1283381',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 14:42:36','',''),(2171278,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:42:36','',''),(2171316,'1','194','1012',460,'Retail Sale Id 1283389',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 14:44:23','',''),(2171317,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 14:44:23','',''),(2171371,'1','194','1012',460,'Retail Sale Id 1283410',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 14:47:47','',''),(2171372,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:47:47','',''),(2171427,'1','194','1012',460,'Retail Sale Id 1283435',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 14:51:27','',''),(2171428,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:51:27','',''),(2171499,'1','194','1012',460,'Retail Sale Id 1283474',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 14:56:19','',''),(2171500,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:56:19','',''),(2171541,'1','194','1012',460,'Retail Sale Id 1283487',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 14:59:29','',''),(2171542,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 14:59:29','',''),(2171571,'1','194','1012',460,'Retail Sale Id 1283512',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 15:02:30','',''),(2171572,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 15:02:30','',''),(2171697,'1','194','1012',460,'Retail Sale Id 1283574',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 15:12:47','',''),(2171698,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 15:12:47','',''),(2171774,'1','194','1012',460,'Retail Sale Id 1283613',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 15:18:06','',''),(2171775,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 15:18:06','',''),(2171834,'1','194','1012',460,'Retail Sale Id 1283644',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 15:22:27','',''),(2171835,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:22:27','',''),(2172054,'1','194','1012',460,'Retail Sale Id 1283746',147000.00,0.00,0.00,0.00,5000.00,'2021-12-05 15:34:53','',''),(2172055,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-05 15:34:53','',''),(2172110,'1','194','1012',460,'Retail Sale Id 1283775',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 15:37:56','',''),(2172111,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:37:56','',''),(2172199,'1','194','1012',460,'Retail Sale Id 1283821',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 15:42:08','',''),(2172200,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:42:08','',''),(2172514,'1','194','1012',460,'Retail Sale Id 1283994',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 15:59:05','',''),(2172515,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:59:05','',''),(2172530,'1','194','1012',460,'Retail Sale Id 1284003',2560.00,0.00,0.00,0.00,288.00,'2021-12-05 16:00:15','',''),(2172531,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 16:00:15','',''),(2172600,'1','194','1012',460,'Retail Sale Id 1284035',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 16:04:28','',''),(2172601,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 16:04:28','',''),(2172618,'1','194','1012',460,'Retail Sale Id 1284043',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 16:05:25','',''),(2172619,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 16:05:25','',''),(2172638,'1','194','1012',460,'Retail Sale Id 1284058',5760.00,0.00,0.00,0.00,648.00,'2021-12-05 16:06:43','',''),(2172639,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-05 16:06:43','',''),(2172656,'1','194','1012',460,'Retail Sale Id 1284066',3840.00,0.00,0.00,0.00,432.00,'2021-12-05 16:07:58','',''),(2172657,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:07:58','',''),(2172820,'1','194','1012',460,'Retail Sale Id 1284147',28224.00,0.00,0.00,0.00,960.00,'2021-12-05 16:18:51','',''),(2172821,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-05 16:18:51','',''),(2172838,'1','194','1012',460,'Retail Sale Id 1284158',2003.20,0.00,0.00,0.00,225.36,'2021-12-05 16:19:47','',''),(2172839,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-05 16:19:47','',''),(2172856,'1','194','1012',460,'Retail Sale Id 1284172',5120.00,0.00,0.00,0.00,576.00,'2021-12-05 16:20:58','',''),(2172857,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 16:20:58','',''),(2172876,'1','194','1012',460,'Retail Sale Id 1284183',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 16:21:55','',''),(2172877,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:21:55','',''),(2172888,'1','194','1012',460,'Retail Sale Id 1284191',1920.00,0.00,0.00,0.00,216.00,'2021-12-05 16:22:50','',''),(2172889,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:22:50','',''),(2172908,'1','194','1012',460,'Retail Sale Id 1284198',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 16:23:42','',''),(2172909,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:23:42','',''),(2173021,'1','194','1012',460,'Retail Sale Id 1284265',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 16:32:03','',''),(2173022,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:32:03','',''),(2173061,'1','194','1012',460,'Retail Sale Id 1284283',4000.00,0.00,0.00,0.00,450.00,'2021-12-05 16:33:46','',''),(2173062,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 16:33:46','',''),(2173081,'1','194','1012',460,'Retail Sale Id 1284292',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 16:34:46','',''),(2173082,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:34:46','',''),(2173101,'1','194','1012',460,'Retail Sale Id 1284301',1280.00,0.00,0.00,0.00,144.00,'2021-12-05 16:36:03','',''),(2173102,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 16:36:03','',''),(2173127,'1','194','1012',460,'Retail Sale Id 1284315',1497.60,0.00,0.00,0.00,168.48,'2021-12-05 16:37:16','',''),(2173128,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-05 16:37:16','',''),(2173257,'1','194','1012',460,'Retail Sale Id 1284383',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 16:45:11','',''),(2173258,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 16:45:11','',''),(2173303,'1','194','1012',460,'Retail Sale Id 1284406',28800.00,0.00,0.00,0.00,3240.00,'2021-12-05 16:47:57','',''),(2173304,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-05 16:47:57','',''),(2173317,'1','194','1012',460,'Retail Sale Id 1284414',8000.00,0.00,0.00,0.00,900.00,'2021-12-05 16:49:01','',''),(2173318,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:49:01','',''),(2173339,'1','194','1012',460,'Retail Sale Id 1284425',3200.00,0.00,0.00,0.00,360.00,'2021-12-05 16:49:56','',''),(2173340,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:49:56','',''),(2173355,'1','194','1012',460,'Retail Sale Id 1284434',6400.00,0.00,0.00,0.00,720.00,'2021-12-05 16:50:46','',''),(2173356,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 16:50:46','',''),(2173375,'1','194','1012',460,'Retail Sale Id 1284443',4000.00,0.00,0.00,0.00,450.00,'2021-12-05 16:52:25','',''),(2173376,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 16:52:25','',''),(2173389,'1','194','1012',460,'Retail Sale Id 1284451',29400.00,0.00,0.00,0.00,1000.00,'2021-12-05 16:53:19','',''),(2173390,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 16:53:19','',''),(2174866,'1','194','1012',460,'Retail Sale Id 1284937',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 06:17:35','',''),(2174867,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 06:17:35','',''),(2174876,'1','194','1012',460,'Retail Sale Id 1284952',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 06:19:01','',''),(2174877,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 06:19:01','',''),(2174884,'1','194','1012',460,'Retail Sale Id 1284956',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 06:20:58','',''),(2174885,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 06:20:58','',''),(2174911,'1','194','1012',460,'Retail Sale Id 1284968',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 06:25:22','',''),(2174912,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 06:25:22','',''),(2174933,'1','194','1012',460,'Retail Sale Id 1284975',5760.00,0.00,0.00,0.00,648.00,'2021-12-06 06:27:03','',''),(2174934,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 06:27:03','',''),(2175042,'1','194','1012',460,'Retail Sale Id 1284999',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 06:34:15','',''),(2175043,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:34:15','',''),(2175073,'1','194','1012',460,'Retail Sale Id 1285011',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 06:37:49','',''),(2175074,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:37:49','',''),(2175107,'1','194','1012',460,'Retail Sale Id 1285028',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 06:42:37','',''),(2175108,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 06:42:37','',''),(2175175,'1','194','1012',460,'Retail Sale Id 1285066',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 06:48:10','',''),(2175176,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 06:48:10','',''),(2175185,'1','194','1012',460,'Retail Sale Id 1285072',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 06:49:08','',''),(2175186,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:49:08','',''),(2175225,'1','194','1012',460,'Retail Sale Id 1285093',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 06:52:28','',''),(2175226,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:52:28','',''),(2175250,'1','194','1012',460,'Retail Sale Id 1285106',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 06:53:48','',''),(2175251,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:53:48','',''),(2175301,'1','194','1012',460,'Retail Sale Id 1285126',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 06:57:14','',''),(2175302,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 06:57:14','',''),(2175355,'1','194','1012',460,'Retail Sale Id 1285146',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 06:59:21','',''),(2175356,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 06:59:21','',''),(2175373,'1','194','1012',460,'Retail Sale Id 1285157',11840.00,0.00,0.00,0.00,1332.00,'2021-12-06 07:00:53','',''),(2175374,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-06 07:00:53','',''),(2175389,'1','194','1012',460,'Retail Sale Id 1285163',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 07:01:43','',''),(2175391,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:01:43','',''),(2175433,'1','194','1012',460,'Retail Sale Id 1285169',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 07:03:08','',''),(2175434,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:03:08','',''),(2175457,'1','194','1012',460,'Retail Sale Id 1285179',2502.40,0.00,0.00,0.00,281.52,'2021-12-06 07:04:24','',''),(2175458,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 07:04:24','',''),(2175479,'1','194','1012',460,'Retail Sale Id 1285193',8320.00,0.00,0.00,0.00,936.00,'2021-12-06 07:06:19','',''),(2175480,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-06 07:06:19','',''),(2175505,'1','194','1012',460,'Retail Sale Id 1285205',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 07:09:28','',''),(2175506,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 07:09:28','',''),(2175519,'1','194','1012',460,'Retail Sale Id 1285213',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 07:11:10','',''),(2175520,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:11:10','',''),(2175527,'1','194','1012',460,'Retail Sale Id 1285216',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 07:11:52','',''),(2175528,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:11:52','',''),(2175576,'1','194','1012',460,'Retail Sale Id 1285240',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 07:14:35','',''),(2175577,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 07:14:35','',''),(2175592,'1','194','1012',460,'Retail Sale Id 1285248',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 07:15:36','',''),(2175593,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 07:15:36','',''),(2175608,'1','194','1012',460,'Retail Sale Id 1285261',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 07:16:31','',''),(2175609,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:16:31','',''),(2175640,'1','194','1012',460,'Retail Sale Id 1285276',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 07:17:55','',''),(2175641,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 07:17:55','',''),(2175658,'1','194','1012',460,'Retail Sale Id 1285284',4480.00,0.00,0.00,0.00,504.00,'2021-12-06 07:19:01','',''),(2175659,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 07:19:01','',''),(2175746,'1','194','1012',460,'Retail Sale Id 1285330',35868.00,0.00,0.00,0.00,1220.00,'2021-12-06 07:24:04','',''),(2175747,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,61.00,0.00,'2021-12-06 07:24:04','',''),(2175760,'1','194','1012',460,'Retail Sale Id 1285339',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 07:25:04','',''),(2175761,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:25:04','',''),(2175780,'1','194','1012',460,'Retail Sale Id 1285349',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 07:25:59','',''),(2175781,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 07:25:59','',''),(2175796,'1','194','1012',460,'Retail Sale Id 1285357',9600.00,0.00,0.00,0.00,1080.00,'2021-12-06 07:26:59','',''),(2175797,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 07:26:59','',''),(2175810,'1','194','1012',460,'Retail Sale Id 1285363',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 07:27:56','',''),(2175811,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:27:56','',''),(2175840,'1','194','1012',460,'Retail Sale Id 1285377',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 07:30:23','',''),(2175841,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:30:23','',''),(2175873,'1','194','1012',460,'Retail Sale Id 1285392',1299.20,0.00,0.00,0.00,146.16,'2021-12-06 07:32:13','',''),(2175874,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 07:32:13','',''),(2175899,'1','194','1012',460,'Retail Sale Id 1285405',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 07:33:32','',''),(2175900,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:33:32','',''),(2175917,'1','194','1012',460,'Retail Sale Id 1285415',998.40,0.00,0.00,0.00,112.32,'2021-12-06 07:34:50','',''),(2175918,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:34:50','',''),(2176086,'1','194','1012',460,'Retail Sale Id 1285494',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 07:43:06','',''),(2176087,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:43:06','',''),(2176129,'1','194','1012',460,'Retail Sale Id 1285518',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 07:45:03','',''),(2176130,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:45:03','',''),(2176151,'1','194','1012',460,'Retail Sale Id 1285537',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 07:46:12','',''),(2176152,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:46:12','',''),(2176188,'1','194','1012',460,'Retail Sale Id 1285550',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 07:47:23','',''),(2176189,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:47:23','',''),(2176245,'1','194','1012',460,'Retail Sale Id 1285575',998.40,0.00,0.00,0.00,112.32,'2021-12-06 07:50:11','',''),(2176246,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 07:50:11','',''),(2176274,'1','194','1012',460,'Retail Sale Id 1285588',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 07:51:35','',''),(2176275,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:51:35','',''),(2176302,'1','194','1012',460,'Retail Sale Id 1285599',57624.00,0.00,0.00,0.00,1960.00,'2021-12-06 07:52:40','',''),(2176303,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-06 07:52:40','',''),(2176351,'1','194','1012',460,'Retail Sale Id 1285613',16000.00,0.00,0.00,0.00,1800.00,'2021-12-06 07:54:30','',''),(2176352,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 07:54:30','',''),(2176381,'1','194','1012',460,'Retail Sale Id 1285626',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 07:55:25','',''),(2176382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 07:55:25','',''),(2176406,'1','194','1012',460,'Retail Sale Id 1285639',76440.00,0.00,0.00,0.00,2600.00,'2021-12-06 07:56:47','',''),(2176407,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,130.00,0.00,'2021-12-06 07:56:47','',''),(2176435,'1','194','1012',460,'Retail Sale Id 1285652',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 07:57:54','',''),(2176436,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:57:54','',''),(2176465,'1','194','1012',460,'Retail Sale Id 1285663',6400.00,0.00,0.00,0.00,720.00,'2021-12-06 07:59:12','',''),(2176466,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 07:59:12','',''),(2176477,'1','194','1012',460,'Retail Sale Id 1285672',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 08:00:13','',''),(2176478,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:00:13','',''),(2176497,'1','194','1012',460,'Retail Sale Id 1285686',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 08:01:14','',''),(2176498,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:01:14','',''),(2176523,'1','194','1012',460,'Retail Sale Id 1285702',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 08:03:05','',''),(2176524,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 08:03:05','',''),(2176552,'1','194','1012',460,'Retail Sale Id 1285721',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 08:04:43','',''),(2176553,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:04:43','',''),(2176648,'1','194','1012',460,'Retail Sale Id 1285762',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 08:09:26','',''),(2176649,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:09:26','',''),(2176678,'1','194','1012',460,'Retail Sale Id 1285782',23520.00,0.00,0.00,0.00,800.00,'2021-12-06 08:11:37','',''),(2176679,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-06 08:11:37','',''),(2176694,'1','194','1012',460,'Retail Sale Id 1285788',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 08:12:29','',''),(2176695,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:12:29','',''),(2176708,'1','194','1012',460,'Retail Sale Id 1285799',998.40,0.00,0.00,0.00,112.32,'2021-12-06 08:13:47','',''),(2176709,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 08:13:47','',''),(2176726,'1','194','1012',460,'Retail Sale Id 1285810',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 08:14:51','',''),(2176727,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 08:14:51','',''),(2176770,'1','194','1012',460,'Retail Sale Id 1285830',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 08:18:25','',''),(2176771,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:18:25','',''),(2176792,'1','194','1012',460,'Retail Sale Id 1285842',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 08:19:45','',''),(2176793,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:19:45','',''),(2176905,'1','194','1012',460,'Retail Sale Id 1285905',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 08:31:25','',''),(2176906,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:31:25','',''),(2176917,'1','194','1012',460,'Retail Sale Id 1285911',6400.00,0.00,0.00,0.00,720.00,'2021-12-06 08:32:27','',''),(2176918,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 08:32:27','',''),(2176935,'1','194','1012',460,'Retail Sale Id 1285920',5120.00,0.00,0.00,0.00,576.00,'2021-12-06 08:33:30','',''),(2176936,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 08:33:30','',''),(2176953,'1','194','1012',460,'Retail Sale Id 1285927',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 08:34:43','',''),(2176954,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 08:34:43','',''),(2177001,'1','194','1012',460,'Retail Sale Id 1285942',57624.00,0.00,0.00,0.00,1960.00,'2021-12-06 08:38:09','',''),(2177002,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-06 08:38:09','',''),(2177056,'1','194','1012',460,'Retail Sale Id 1285972',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 08:42:27','',''),(2177057,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 08:42:27','',''),(2177078,'1','194','1012',460,'Retail Sale Id 1285981',4480.00,0.00,0.00,0.00,504.00,'2021-12-06 08:44:01','',''),(2177079,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 08:44:01','',''),(2177488,'1','194','1012',460,'Retail Sale Id 1286179',9280.00,0.00,0.00,0.00,1044.00,'2021-12-06 09:13:31','',''),(2177489,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-06 09:13:31','',''),(2177514,'1','194','1012',460,'Retail Sale Id 1286189',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 09:14:44','',''),(2177515,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:14:44','',''),(2177526,'1','194','1012',460,'Retail Sale Id 1286195',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 09:15:49','',''),(2177527,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:15:49','',''),(2177560,'1','194','1012',460,'Retail Sale Id 1286207',12800.00,0.00,0.00,0.00,1440.00,'2021-12-06 09:18:02','',''),(2177561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 09:18:02','',''),(2177592,'1','194','1012',460,'Retail Sale Id 1286222',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 09:19:59','',''),(2177593,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:19:59','',''),(2177612,'1','194','1012',460,'Retail Sale Id 1286231',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 09:21:21','',''),(2177613,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:21:21','',''),(2177630,'1','194','1012',460,'Retail Sale Id 1286246',640.00,0.00,0.00,0.00,72.00,'2021-12-06 09:22:49','',''),(2177631,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 09:22:49','',''),(2177682,'1','194','1012',460,'Retail Sale Id 1286269',10240.00,0.00,0.00,0.00,1152.00,'2021-12-06 09:25:39','',''),(2177683,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-06 09:25:39','',''),(2177698,'1','194','1012',460,'Retail Sale Id 1286276',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 09:26:31','',''),(2177699,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:26:31','',''),(2177731,'1','194','1012',460,'Retail Sale Id 1286291',5203.20,0.00,0.00,0.00,585.36,'2021-12-06 09:28:14','',''),(2177732,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.13,0.00,'2021-12-06 09:28:14','',''),(2177742,'1','194','1012',460,'Retail Sale Id 1286296',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 09:29:12','',''),(2177743,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:29:12','',''),(2177762,'1','194','1012',460,'Retail Sale Id 1286306',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 09:30:08','',''),(2177763,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 09:30:08','',''),(2177772,'1','194','1012',460,'Retail Sale Id 1286315',85260.00,0.00,0.00,0.00,2900.00,'2021-12-06 09:31:00','',''),(2177773,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,145.00,0.00,'2021-12-06 09:31:00','',''),(2177823,'1','194','1012',460,'Retail Sale Id 1286332',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 09:33:22','',''),(2177824,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:33:22','',''),(2177839,'1','194','1012',460,'Retail Sale Id 1286339',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 09:34:40','',''),(2177840,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 09:34:40','',''),(2177845,'1','194','1012',460,'Retail Sale Id 1286343',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 09:35:52','',''),(2177846,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 09:35:52','',''),(2177893,'1','194','1012',460,'Retail Sale Id 1286355',998.40,0.00,0.00,0.00,112.32,'2021-12-06 09:37:16','',''),(2177894,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 09:37:16','',''),(2177914,'1','194','1012',460,'Retail Sale Id 1286362',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 09:38:01','',''),(2177915,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:38:01','',''),(2178028,'1','194','1012',460,'Retail Sale Id 1286406',1299.20,0.00,0.00,0.00,146.16,'2021-12-06 09:44:23','',''),(2178029,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-06 09:44:23','',''),(2178054,'1','194','1012',460,'Retail Sale Id 1286418',1501.50,0.00,0.00,0.00,189.42,'2021-12-06 09:45:49','',''),(2178055,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.31,0.00,'2021-12-06 09:45:49','',''),(2178076,'1','194','1012',460,'Retail Sale Id 1286431',28812.00,0.00,0.00,0.00,980.00,'2021-12-06 09:47:33','',''),(2178077,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-06 09:47:33','',''),(2178098,'1','194','1012',460,'Retail Sale Id 1286441',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 09:49:03','',''),(2178099,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:49:03','',''),(2178151,'1','194','1012',460,'Retail Sale Id 1286469',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 09:53:01','',''),(2178152,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:53:01','',''),(2178171,'1','194','1012',460,'Retail Sale Id 1286479',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 09:54:07','',''),(2178172,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:54:07','',''),(2178242,'1','194','1012',460,'Retail Sale Id 1286520',9920.00,0.00,0.00,0.00,1116.00,'2021-12-06 10:00:16','',''),(2178243,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-06 10:00:16','',''),(2178266,'1','194','1012',460,'Retail Sale Id 1286529',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 10:01:42','',''),(2178267,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 10:01:42','',''),(2178354,'1','194','1012',460,'Retail Sale Id 1286566',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 10:05:39','',''),(2178355,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:05:39','',''),(2178380,'1','194','1012',460,'Retail Sale Id 1286579',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 10:07:21','',''),(2178381,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:07:21','',''),(2178423,'1','194','1012',460,'Retail Sale Id 1286593',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 10:08:50','',''),(2178424,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:08:50','',''),(2178513,'1','194','1012',460,'Retail Sale Id 1286643',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 10:14:56','',''),(2178514,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 10:14:56','',''),(2178545,'1','194','1012',460,'Retail Sale Id 1286659',2502.40,0.00,0.00,0.00,281.52,'2021-12-06 10:16:41','',''),(2178546,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 10:16:41','',''),(2178617,'1','194','1012',460,'Retail Sale Id 1286702',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 10:22:17','',''),(2178618,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:22:17','',''),(2178657,'1','194','1012',460,'Retail Sale Id 1286722',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 10:25:44','',''),(2178658,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:25:44','',''),(2178788,'1','194','1012',460,'Retail Sale Id 1286784',2502.40,0.00,0.00,0.00,281.52,'2021-12-06 10:33:39','',''),(2178789,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-06 10:33:39','',''),(2178800,'1','194','1012',460,'Retail Sale Id 1286791',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 10:34:46','',''),(2178801,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:34:46','',''),(2178828,'1','194','1012',460,'Retail Sale Id 1286813',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 10:37:04','',''),(2178829,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:37:04','',''),(2179078,'1','194','1012',460,'Retail Sale Id 1286954',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 10:52:15','',''),(2179079,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:52:15','',''),(2179102,'1','194','1012',460,'Retail Sale Id 1286966',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 10:53:49','',''),(2179103,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:53:49','',''),(2179126,'1','194','1012',460,'Retail Sale Id 1286979',11520.00,0.00,0.00,0.00,1296.00,'2021-12-06 10:55:02','',''),(2179127,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-06 10:55:02','',''),(2179149,'1','194','1012',460,'Retail Sale Id 1286994',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 10:56:38','',''),(2179150,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 10:56:38','',''),(2179207,'1','194','1012',460,'Retail Sale Id 1287032',4480.00,0.00,0.00,0.00,504.00,'2021-12-06 11:00:04','',''),(2179208,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 11:00:04','',''),(2179259,'1','194','1012',460,'Retail Sale Id 1287053',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 11:03:51','',''),(2179260,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:03:51','',''),(2179449,'1','194','1012',460,'Retail Sale Id 1287157',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 11:14:42','',''),(2179450,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:14:42','',''),(2179521,'1','194','1012',460,'Retail Sale Id 1287203',7350.00,0.00,0.00,0.00,250.00,'2021-12-06 11:19:01','',''),(2179522,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:19:01','',''),(2179673,'1','194','1012',460,'Retail Sale Id 1287289',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 11:29:17','',''),(2179674,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:29:17','',''),(2179740,'1','194','1012',460,'Retail Sale Id 1287326',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 11:34:53','',''),(2179741,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 11:34:53','',''),(2179772,'1','194','1012',460,'Retail Sale Id 1287343',6400.00,0.00,0.00,0.00,720.00,'2021-12-06 11:37:47','',''),(2179773,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 11:37:47','',''),(2179800,'1','194','1012',460,'Retail Sale Id 1287356',1900.80,0.00,0.00,0.00,213.84,'2021-12-06 11:40:03','',''),(2179801,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-06 11:40:03','',''),(2179884,'1','194','1012',460,'Retail Sale Id 1287440',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 11:47:24','',''),(2179885,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 11:47:24','',''),(2179964,'1','194','1012',460,'Retail Sale Id 1287502',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 11:52:35','',''),(2179965,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:52:35','',''),(2179976,'1','194','1012',460,'Retail Sale Id 1287507',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 11:53:40','',''),(2179977,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 11:53:40','',''),(2179992,'1','194','1012',460,'Retail Sale Id 1287516',6400.00,0.00,0.00,0.00,720.00,'2021-12-06 11:54:45','',''),(2179993,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 11:54:45','',''),(2180030,'1','194','1012',460,'Retail Sale Id 1287532',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 11:56:05','',''),(2180031,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 11:56:05','',''),(2180046,'1','194','1012',460,'Retail Sale Id 1287543',5120.00,0.00,0.00,0.00,576.00,'2021-12-06 11:57:48','',''),(2180047,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 11:57:48','',''),(2180074,'1','194','1012',460,'Retail Sale Id 1287556',28812.00,0.00,0.00,0.00,980.00,'2021-12-06 11:58:56','',''),(2180075,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-06 11:58:56','',''),(2180150,'1','194','1012',460,'Retail Sale Id 1287594',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 12:04:06','',''),(2180151,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:04:06','',''),(2180274,'1','194','1012',460,'Retail Sale Id 1287657',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 12:11:32','',''),(2180275,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 12:11:32','',''),(2180300,'1','194','1012',460,'Retail Sale Id 1287679',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 12:13:05','',''),(2180301,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:13:05','',''),(2180326,'1','194','1012',460,'Retail Sale Id 1287695',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 12:14:20','',''),(2180327,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 12:14:20','',''),(2180498,'1','194','1012',460,'Retail Sale Id 1287790',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 12:25:38','',''),(2180499,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 12:25:38','',''),(2180516,'1','194','1012',460,'Retail Sale Id 1287798',7350.00,0.00,0.00,0.00,250.00,'2021-12-06 12:26:40','',''),(2180517,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:26:40','',''),(2180572,'1','194','1012',460,'Retail Sale Id 1287830',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 12:30:10','',''),(2180573,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:30:10','',''),(2180606,'1','194','1012',460,'Retail Sale Id 1287846',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 12:32:35','',''),(2180607,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:32:35','',''),(2180647,'1','194','1012',460,'Return of Retail Sale Id 1287798',0.00,7350.00,12.50,0.00,-250.00,'2021-12-06 12:34:27','',''),(2180674,'1','194','1012',460,'Retail Sale Id 1287878',3001.60,0.00,0.00,0.00,337.68,'2021-12-06 12:35:58','',''),(2180675,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-06 12:35:58','',''),(2180774,'1','194','1012',460,'Retail Sale Id 1287931',35280.00,0.00,0.00,0.00,1200.00,'2021-12-06 12:42:34','',''),(2180775,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 12:42:34','',''),(2180892,'1','194','1012',460,'Retail Sale Id 1287990',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 12:49:53','',''),(2180893,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 12:49:53','',''),(2181108,'1','194','1012',460,'Retail Sale Id 1288101',5120.00,0.00,0.00,0.00,576.00,'2021-12-06 13:01:23','',''),(2181109,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 13:01:23','',''),(2181296,'1','194','1012',460,'Retail Sale Id 1288203',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 13:12:40','',''),(2181297,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 13:12:40','',''),(2181814,'1','194','1012',460,'Retail Sale Id 1288421',88200.00,0.00,0.00,0.00,3000.00,'2021-12-06 13:41:08','',''),(2181815,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-06 13:41:08','',''),(2181899,'1','194','1012',460,'Retail Sale Id 1288455',20580.00,0.00,0.00,0.00,700.00,'2021-12-06 13:45:02','',''),(2181900,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-06 13:45:02','',''),(2181923,'1','194','1012',460,'Retail Sale Id 1288466',27048.00,0.00,0.00,0.00,920.00,'2021-12-06 13:46:23','',''),(2181924,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-06 13:46:23','',''),(2181953,'1','194','1012',460,'Retail Sale Id 1288480',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 13:47:57','',''),(2181954,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 13:47:57','',''),(2181983,'1','194','1012',460,'Retail Sale Id 1288497',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 13:49:15','',''),(2181984,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 13:49:15','',''),(2182013,'1','194','1012',460,'Retail Sale Id 1288507',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 13:51:05','',''),(2182014,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 13:51:05','',''),(2182041,'1','194','1012',460,'Retail Sale Id 1288528',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 13:52:27','',''),(2182042,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:52:27','',''),(2182241,'1','194','1012',460,'Retail Sale Id 1288613',14080.00,0.00,0.00,0.00,1584.00,'2021-12-06 14:01:14','',''),(2182242,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-06 14:01:14','',''),(2182277,'1','194','1012',460,'Retail Sale Id 1288633',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 14:03:14','',''),(2182278,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:03:14','',''),(2182367,'1','194','1012',460,'Retail Sale Id 1288673',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 14:07:25','',''),(2182368,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:07:25','',''),(2182410,'1','194','1012',460,'Retail Sale Id 1288690',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 14:09:22','',''),(2182411,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 14:09:22','',''),(2182443,'1','194','1012',460,'Retail Sale Id 1288702',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 14:10:30','',''),(2182444,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:10:30','',''),(2182486,'1','194','1012',460,'Retail Sale Id 1288716',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 14:12:04','',''),(2182487,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:12:04','',''),(2182523,'1','194','1012',460,'Retail Sale Id 1288736',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 14:14:10','',''),(2182524,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:14:10','',''),(2182624,'1','194','1012',460,'Retail Sale Id 1288783',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 14:18:45','',''),(2182625,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:18:45','',''),(2183281,'1','194','1012',460,'Retail Sale Id 1289082',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 14:52:45','',''),(2183282,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:52:45','',''),(2183315,'1','194','1012',460,'Retail Sale Id 1289099',2003.20,0.00,0.00,0.00,225.36,'2021-12-06 14:54:31','',''),(2183316,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-06 14:54:31','',''),(2183343,'1','194','1012',460,'Retail Sale Id 1289111',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 14:55:38','',''),(2183344,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:55:38','',''),(2183367,'1','194','1012',460,'Retail Sale Id 1289122',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 14:56:38','',''),(2183368,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 14:56:38','',''),(2183381,'1','194','1012',460,'Retail Sale Id 1289130',9600.00,0.00,0.00,0.00,1080.00,'2021-12-06 14:57:44','',''),(2183382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 14:57:44','',''),(2183449,'1','194','1012',460,'Retail Sale Id 1289167',4480.00,0.00,0.00,0.00,504.00,'2021-12-06 15:01:30','',''),(2183450,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 15:01:30','',''),(2183477,'1','194','1012',460,'Retail Sale Id 1289184',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 15:03:13','',''),(2183478,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:03:13','',''),(2183501,'1','194','1012',460,'Retail Sale Id 1289196',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 15:04:35','',''),(2183502,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 15:04:35','',''),(2183537,'1','194','1012',460,'Retail Sale Id 1289211',37888.00,0.00,0.00,0.00,4262.40,'2021-12-06 15:06:33','',''),(2183538,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,59.20,0.00,'2021-12-06 15:06:33','',''),(2183617,'1','194','1012',460,'Retail Sale Id 1289245',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 15:11:02','',''),(2183618,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:11:02','',''),(2183655,'1','194','1012',460,'Retail Sale Id 1289261',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 15:13:08','',''),(2183656,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:13:08','',''),(2183675,'1','194','1012',460,'Retail Sale Id 1289269',35280.00,0.00,0.00,0.00,1200.00,'2021-12-06 15:14:24','',''),(2183676,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-06 15:14:24','',''),(2183701,'1','194','1012',460,'Retail Sale Id 1289279',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 15:15:29','',''),(2183702,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:15:29','',''),(2183726,'1','194','1012',460,'Retail Sale Id 1289292',58800.00,0.00,0.00,0.00,2000.00,'2021-12-06 15:16:47','',''),(2183727,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-06 15:16:47','',''),(2183816,'1','194','1012',460,'Retail Sale Id 1289331',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 15:20:47','',''),(2183817,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:20:47','',''),(2183889,'1','194','1012',460,'Retail Sale Id 1289363',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 15:23:40','',''),(2183890,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:23:40','',''),(2183974,'1','194','1012',460,'Retail Sale Id 1289405',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 15:27:29','',''),(2183975,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:27:29','',''),(2184069,'1','194','1012',460,'Retail Sale Id 1289454',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 15:32:38','',''),(2184070,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:32:38','',''),(2184194,'1','194','1012',460,'Retail Sale Id 1289512',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 15:39:06','',''),(2184195,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:39:06','',''),(2184243,'1','194','1012',460,'Retail Sale Id 1289523',17640.00,0.00,0.00,0.00,600.00,'2021-12-06 15:40:21','',''),(2184244,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-06 15:40:21','',''),(2184288,'1','194','1012',460,'Retail Sale Id 1289537',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 15:42:08','',''),(2184289,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 15:42:08','',''),(2184339,'1','194','1012',460,'Retail Sale Id 1289549',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 15:43:22','',''),(2184340,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:43:22','',''),(2184371,'1','194','1012',460,'Retail Sale Id 1289562',697.60,0.00,0.00,0.00,78.48,'2021-12-06 15:44:28','',''),(2184372,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-06 15:44:28','',''),(2184406,'1','194','1012',460,'Retail Sale Id 1289574',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 15:45:36','',''),(2184407,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 15:45:36','',''),(2184441,'1','194','1012',460,'Retail Sale Id 1289585',998.40,0.00,0.00,0.00,112.32,'2021-12-06 15:46:34','',''),(2184442,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-06 15:46:34','',''),(2184456,'1','194','1012',460,'Retail Sale Id 1289591',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 15:47:40','',''),(2184457,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:47:40','',''),(2184472,'1','194','1012',460,'Retail Sale Id 1289601',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 15:48:35','',''),(2184473,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:48:35','',''),(2184490,'1','194','1012',460,'Retail Sale Id 1289607',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 15:49:26','',''),(2184491,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:49:26','',''),(2184508,'1','194','1012',460,'Retail Sale Id 1289618',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 15:50:19','',''),(2184509,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:50:19','',''),(2184628,'1','194','1012',460,'Retail Sale Id 1289673',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 15:56:45','',''),(2184629,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:56:45','',''),(2184655,'1','194','1012',460,'Retail Sale Id 1289689',3200.00,0.00,0.00,0.00,360.00,'2021-12-06 15:57:55','',''),(2184656,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:57:55','',''),(2184803,'1','194','1012',460,'Retail Sale Id 1289754',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 16:06:24','',''),(2184804,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:06:24','',''),(2184865,'1','194','1012',460,'Retail Sale Id 1289783',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 16:11:15','',''),(2184866,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:11:15','',''),(2184924,'1','194','1012',460,'Retail Sale Id 1289810',6400.00,0.00,0.00,0.00,720.00,'2021-12-06 16:15:19','',''),(2184925,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 16:15:19','',''),(2184964,'1','194','1012',460,'Retail Sale Id 1289828',14720.00,0.00,0.00,0.00,1656.00,'2021-12-06 16:17:23','',''),(2184965,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,23.00,0.00,'2021-12-06 16:17:23','',''),(2185058,'1','194','1012',460,'Retail Sale Id 1289878',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 16:22:07','',''),(2185059,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:22:07','',''),(2185089,'1','194','1012',460,'Retail Sale Id 1289890',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 16:23:21','',''),(2185090,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:23:21','',''),(2185114,'1','194','1012',460,'Retail Sale Id 1289903',4480.00,0.00,0.00,0.00,504.00,'2021-12-06 16:24:39','',''),(2185115,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 16:24:39','',''),(2185131,'1','194','1012',460,'Retail Sale Id 1289911',640.00,0.00,0.00,0.00,72.00,'2021-12-06 16:25:42','',''),(2185132,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 16:25:42','',''),(2185161,'1','194','1012',460,'Retail Sale Id 1289924',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 16:27:35','',''),(2185162,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:27:35','',''),(2185236,'1','194','1012',460,'Retail Sale Id 1289967',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 16:31:14','',''),(2185237,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:31:14','',''),(2185266,'1','194','1012',460,'Retail Sale Id 1289981',1920.00,0.00,0.00,0.00,216.00,'2021-12-06 16:32:40','',''),(2185267,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:32:40','',''),(2185295,'1','194','1012',460,'Retail Sale Id 1289994',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 16:33:41','',''),(2185296,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:33:41','',''),(2185390,'1','194','1012',460,'Retail Sale Id 1290038',2560.00,0.00,0.00,0.00,288.00,'2021-12-06 16:39:05','',''),(2185391,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 16:39:05','',''),(2185430,'1','194','1012',460,'Retail Sale Id 1290053',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 16:40:38','',''),(2185431,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:40:38','',''),(2185458,'1','194','1012',460,'Retail Sale Id 1290068',8000.00,0.00,0.00,0.00,900.00,'2021-12-06 16:42:54','',''),(2185459,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:42:54','',''),(2185529,'1','194','1012',460,'Retail Sale Id 1290101',29400.00,0.00,0.00,0.00,1000.00,'2021-12-06 16:47:18','',''),(2185530,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 16:47:18','',''),(2185567,'1','194','1012',460,'Retail Sale Id 1290120',640.00,0.00,0.00,0.00,72.00,'2021-12-06 16:48:27','',''),(2185568,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 16:48:27','',''),(2185612,'1','194','1012',460,'Retail Sale Id 1290143',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 16:50:46','',''),(2185613,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:50:46','',''),(2185700,'1','194','1012',460,'Retail Sale Id 1290189',1280.00,0.00,0.00,0.00,144.00,'2021-12-06 16:55:41','',''),(2185701,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 16:55:41','',''),(2185744,'1','194','1012',460,'Retail Sale Id 1290216',3840.00,0.00,0.00,0.00,432.00,'2021-12-06 16:58:59','',''),(2185745,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:58:59','',''),(2187344,'1','194','1012',460,'Retail Sale Id 1290755',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 06:19:14','',''),(2187345,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:19:14','',''),(2187366,'1','194','1012',460,'Retail Sale Id 1290766',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 06:21:21','',''),(2187367,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:21:21','',''),(2187426,'1','194','1012',460,'Retail Sale Id 1290795',58800.00,0.00,0.00,0.00,2000.00,'2021-12-07 06:25:30','',''),(2187427,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 06:25:31','',''),(2187503,'1','194','1012',460,'Retail Sale Id 1290835',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 06:33:06','',''),(2187504,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 06:33:06','',''),(2187537,'1','194','1012',460,'Retail Sale Id 1290852',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 06:35:12','',''),(2187538,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:35:12','',''),(2187571,'1','194','1012',460,'Retail Sale Id 1290871',26460.00,0.00,0.00,0.00,900.00,'2021-12-07 06:37:29','',''),(2187572,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 06:37:29','',''),(2187607,'1','194','1012',460,'Retail Sale Id 1290889',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 06:39:47','',''),(2187608,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 06:39:48','',''),(2187651,'1','194','1012',460,'Retail Sale Id 1290912',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 06:42:33','',''),(2187652,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 06:42:33','',''),(2187669,'1','194','1012',460,'Retail Sale Id 1290926',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 06:44:04','',''),(2187670,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:44:04','',''),(2187714,'1','194','1012',460,'Retail Sale Id 1290945',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 06:47:33','',''),(2187715,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:47:33','',''),(2187819,'1','194','1012',460,'Retail Sale Id 1290987',4480.00,0.00,0.00,0.00,504.00,'2021-12-07 06:52:54','',''),(2187820,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 06:52:54','',''),(2187848,'1','194','1012',460,'Retail Sale Id 1290998',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 06:55:11','',''),(2187849,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 06:55:11','',''),(2187904,'1','194','1012',460,'Retail Sale Id 1291023',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 06:58:38','',''),(2187905,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 06:58:38','',''),(2187946,'1','194','1012',460,'Retail Sale Id 1291046',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 07:00:59','',''),(2187947,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:00:59','',''),(2187990,'1','194','1012',460,'Retail Sale Id 1291070',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 07:02:58','',''),(2187991,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:02:58','',''),(2188056,'1','194','1012',460,'Retail Sale Id 1291103',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 07:06:16','',''),(2188057,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 07:06:16','',''),(2188202,'1','194','1012',460,'Retail Sale Id 1291173',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 07:13:16','',''),(2188203,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:13:16','',''),(2188340,'1','194','1012',460,'Retail Sale Id 1291234',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 07:19:22','',''),(2188341,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:19:22','',''),(2188426,'1','194','1012',460,'Retail Sale Id 1291284',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 07:23:44','',''),(2188427,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:23:44','',''),(2188502,'1','194','1012',460,'Retail Sale Id 1291324',9920.00,0.00,0.00,0.00,1116.00,'2021-12-07 07:27:13','',''),(2188503,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-07 07:27:13','',''),(2188528,'1','194','1012',460,'Retail Sale Id 1291334',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 07:28:16','',''),(2188529,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:28:16','',''),(2188604,'1','194','1012',460,'Retail Sale Id 1291371',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 07:31:21','',''),(2188605,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:31:21','',''),(2188626,'1','194','1012',460,'Retail Sale Id 1291388',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 07:32:29','',''),(2188627,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:32:29','',''),(2188726,'1','194','1012',460,'Retail Sale Id 1291442',23520.00,0.00,0.00,0.00,800.00,'2021-12-07 07:37:49','',''),(2188727,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 07:37:49','',''),(2188844,'1','194','1012',460,'Retail Sale Id 1291518',47040.00,0.00,0.00,0.00,1600.00,'2021-12-07 07:43:44','',''),(2188845,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,80.00,0.00,'2021-12-07 07:43:44','',''),(2188868,'1','194','1012',460,'Retail Sale Id 1291528',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 07:45:09','',''),(2188869,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 07:45:09','',''),(2189139,'1','194','1012',460,'Retail Sale Id 1291660',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 07:59:37','',''),(2189140,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 07:59:37','',''),(2189207,'1','194','1012',460,'Retail Sale Id 1291701',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 08:04:28','',''),(2189208,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 08:04:28','',''),(2189241,'1','194','1012',460,'Retail Sale Id 1291720',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 08:06:31','',''),(2189242,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:06:31','',''),(2189369,'1','194','1012',460,'Retail Sale Id 1291771',3897.60,0.00,0.00,0.00,438.48,'2021-12-07 08:12:46','',''),(2189370,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-07 08:12:46','',''),(2189389,'1','194','1012',460,'Retail Sale Id 1291781',3897.60,0.00,0.00,0.00,438.48,'2021-12-07 08:13:53','',''),(2189390,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.09,0.00,'2021-12-07 08:13:53','',''),(2189432,'1','194','1012',460,'Retail Sale Id 1291802',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 08:16:18','',''),(2189433,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:16:18','',''),(2189673,'1','194','1012',460,'Retail Sale Id 1291922',6400.00,0.00,0.00,0.00,720.00,'2021-12-07 08:32:14','',''),(2189674,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 08:32:14','',''),(2189701,'1','194','1012',460,'Retail Sale Id 1291938',57624.00,0.00,0.00,0.00,1960.00,'2021-12-07 08:33:49','',''),(2189702,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-07 08:33:49','',''),(2189760,'1','194','1012',460,'Retail Sale Id 1291955',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 08:35:32','',''),(2189761,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 08:35:32','',''),(2189799,'1','194','1012',460,'Retail Sale Id 1291964',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 08:36:44','',''),(2189800,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 08:36:44','',''),(2189912,'1','194','1012',460,'Retail Sale Id 1292008',18228.00,0.00,0.00,0.00,620.00,'2021-12-07 08:42:59','',''),(2189913,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-07 08:42:59','',''),(2189942,'1','194','1012',460,'Retail Sale Id 1292026',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 08:44:44','',''),(2189943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 08:44:44','',''),(2189985,'1','194','1012',460,'Retail Sale Id 1292038',800.00,0.00,0.00,0.00,90.00,'2021-12-07 08:45:54','',''),(2189986,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-07 08:45:54','',''),(2189999,'1','194','1012',460,'Retail Sale Id 1292046',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 08:46:52','',''),(2190000,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:46:52','',''),(2190041,'1','194','1012',460,'Retail Sale Id 1292069',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 08:49:02','',''),(2190042,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 08:49:03','',''),(2190168,'1','194','1012',460,'Retail Sale Id 1292127',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 08:55:32','',''),(2190169,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 08:55:32','',''),(2190309,'1','194','1012',460,'Retail Sale Id 1292198',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 09:06:03','',''),(2190310,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 09:06:03','',''),(2190721,'1','194','1012',460,'Retail Sale Id 1292387',88200.00,0.00,0.00,0.00,3000.00,'2021-12-07 09:27:02','',''),(2190722,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 09:27:02','',''),(2190814,'1','194','1012',460,'Retail Sale Id 1292439',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 09:30:31','',''),(2190815,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 09:30:31','',''),(2190848,'1','194','1012',460,'Retail Sale Id 1292455',34104.00,0.00,0.00,0.00,1160.00,'2021-12-07 09:32:16','',''),(2190849,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-07 09:32:16','',''),(2190868,'1','194','1012',460,'Retail Sale Id 1292465',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 09:33:20','',''),(2190869,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 09:33:20','',''),(2190934,'1','194','1012',460,'Retail Sale Id 1292499',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 09:36:49','',''),(2190935,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:36:49','',''),(2191214,'1','194','1012',460,'Retail Sale Id 1292648',6400.00,0.00,0.00,0.00,720.00,'2021-12-07 09:55:50','',''),(2191215,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 09:55:50','',''),(2191240,'1','194','1012',460,'Retail Sale Id 1292656',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 09:56:55','',''),(2191241,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 09:56:55','',''),(2191483,'1','194','1012',460,'Retail Sale Id 1292791',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 10:14:31','',''),(2191484,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:14:31','',''),(2191517,'1','194','1012',460,'Retail Sale Id 1292803',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 10:15:50','',''),(2191518,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:15:50','',''),(2191537,'1','194','1012',460,'Retail Sale Id 1292816',7001.60,0.00,0.00,0.00,787.68,'2021-12-07 10:17:11','',''),(2191538,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.94,0.00,'2021-12-07 10:17:11','',''),(2191751,'1','194','1012',460,'Retail Sale Id 1292918',998.40,0.00,0.00,0.00,112.32,'2021-12-07 10:34:28','',''),(2191752,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 10:34:28','',''),(2191893,'1','194','1012',460,'Retail Sale Id 1292996',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 10:43:29','',''),(2191894,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:43:29','',''),(2191961,'1','194','1012',460,'Retail Sale Id 1293020',43512.00,0.00,0.00,0.00,1480.00,'2021-12-07 10:46:20','',''),(2191962,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,74.00,0.00,'2021-12-07 10:46:20','',''),(2192024,'1','194','1012',460,'Retail Sale Id 1293052',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 10:49:14','',''),(2192025,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:49:14','',''),(2192066,'1','194','1012',460,'Retail Sale Id 1293071',58800.00,0.00,0.00,0.00,2000.00,'2021-12-07 10:51:36','',''),(2192067,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 10:51:36','',''),(2192131,'1','194','1012',460,'Retail Sale Id 1293104',31164.00,0.00,0.00,0.00,1060.00,'2021-12-07 10:54:55','',''),(2192132,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-07 10:54:55','',''),(2192152,'1','194','1012',460,'Retail Sale Id 1293118',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 10:56:19','',''),(2192153,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 10:56:19','',''),(2192386,'1','194','1012',460,'Retail Sale Id 1293214',28812.00,0.00,0.00,0.00,980.00,'2021-12-07 11:07:52','',''),(2192387,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-07 11:07:52','',''),(2192490,'1','194','1012',460,'Retail Sale Id 1293279',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 11:13:19','',''),(2192491,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 11:13:19','',''),(2192546,'1','194','1012',460,'Retail Sale Id 1293310',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 11:17:09','',''),(2192547,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 11:17:09','',''),(2192616,'1','194','1012',460,'Retail Sale Id 1293364',88200.00,0.00,0.00,0.00,3000.00,'2021-12-07 11:22:16','',''),(2192617,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-07 11:22:16','',''),(2192660,'1','194','1012',460,'Retail Sale Id 1293394',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 11:25:48','',''),(2192661,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:25:48','',''),(2192728,'1','194','1012',460,'Retail Sale Id 1293426',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 11:30:09','',''),(2192729,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:30:09','',''),(2192813,'1','194','1012',460,'Retail Sale Id 1293469',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 11:37:00','',''),(2192814,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:37:00','',''),(2193277,'1','194','1012',460,'Retail Sale Id 1293710',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 12:14:05','',''),(2193278,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:14:05','',''),(2193299,'1','194','1012',460,'Retail Sale Id 1293723',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 12:16:25','',''),(2193300,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:16:25','',''),(2193353,'1','194','1012',460,'Retail Sale Id 1293756',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 12:20:40','',''),(2193354,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 12:20:40','',''),(2193387,'1','194','1012',460,'Retail Sale Id 1293777',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 12:25:21','',''),(2193388,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:25:21','',''),(2193531,'1','194','1012',460,'Retail Sale Id 1293848',16000.00,0.00,0.00,0.00,1800.00,'2021-12-07 12:36:58','',''),(2193532,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 12:36:58','',''),(2193565,'1','194','1012',460,'Retail Sale Id 1293865',58800.00,0.00,0.00,0.00,2000.00,'2021-12-07 12:39:30','',''),(2193566,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 12:39:30','',''),(2193697,'1','194','1012',460,'Retail Sale Id 1293947',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 12:49:33','',''),(2193698,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 12:49:33','',''),(2193720,'1','194','1012',460,'Retail Sale Id 1293959',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 12:51:03','',''),(2193721,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:51:03','',''),(2193751,'1','194','1012',460,'Retail Sale Id 1293975',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 12:52:28','',''),(2193752,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:52:28','',''),(2193787,'1','194','1012',460,'Retail Sale Id 1293993',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 12:55:03','',''),(2193788,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:55:03','',''),(2193802,'1','194','1012',460,'Retail Sale Id 1293999',58800.00,0.00,0.00,0.00,2000.00,'2021-12-07 12:56:33','',''),(2193803,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 12:56:33','',''),(2193839,'1','194','1012',460,'Retail Sale Id 1294015',1702.40,0.00,0.00,0.00,191.52,'2021-12-07 12:58:55','',''),(2193840,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 12:58:55','',''),(2193866,'1','194','1012',460,'Retail Sale Id 1294037',1702.40,0.00,0.00,0.00,191.52,'2021-12-07 13:00:07','',''),(2193867,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.66,0.00,'2021-12-07 13:00:07','',''),(2193952,'1','194','1012',460,'Retail Sale Id 1294071',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 13:05:38','',''),(2193953,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 13:05:38','',''),(2193968,'1','194','1012',460,'Retail Sale Id 1294079',23520.00,0.00,0.00,0.00,800.00,'2021-12-07 13:06:56','',''),(2193969,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 13:06:56','',''),(2194071,'1','194','1012',460,'Retail Sale Id 1294130',5760.00,0.00,0.00,0.00,648.00,'2021-12-07 13:13:30','',''),(2194072,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 13:13:30','',''),(2194129,'1','194','1012',460,'Retail Sale Id 1294165',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 13:17:40','',''),(2194130,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:17:40','',''),(2194194,'1','194','1012',460,'Retail Sale Id 1294223',640.00,0.00,0.00,0.00,72.00,'2021-12-07 13:23:39','',''),(2194195,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 13:23:39','',''),(2194439,'1','194','1012',460,'Retail Sale Id 1294375',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 13:33:35','',''),(2194440,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 13:33:35','',''),(2194741,'1','194','1012',460,'Retail Sale Id 1294502',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 13:51:34','',''),(2194742,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 13:51:34','',''),(2194762,'1','194','1012',460,'Retail Sale Id 1294512',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 13:52:44','',''),(2194763,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:52:44','',''),(2194780,'1','194','1012',460,'Retail Sale Id 1294523',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 13:54:04','',''),(2194781,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:54:04','',''),(2194883,'1','194','1012',460,'Retail Sale Id 1294576',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 14:01:22','',''),(2194884,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:01:22','',''),(2194963,'1','194','1012',460,'Retail Sale Id 1294619',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 14:07:09','',''),(2194964,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:07:09','',''),(2194993,'1','194','1012',460,'Retail Sale Id 1294635',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 14:08:48','',''),(2194994,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:08:48','',''),(2195197,'1','194','1012',460,'Retail Sale Id 1294704',57624.00,0.00,0.00,0.00,1960.00,'2021-12-07 14:18:06','',''),(2195198,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-07 14:18:06','',''),(2195240,'1','194','1012',460,'Retail Sale Id 1294722',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 14:20:30','',''),(2195241,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 14:20:30','',''),(2195288,'1','194','1012',460,'Retail Sale Id 1294747',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 14:23:15','',''),(2195289,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 14:23:15','',''),(2195314,'1','194','1012',460,'Retail Sale Id 1294762',1501.50,0.00,0.00,0.00,189.42,'2021-12-07 14:24:47','',''),(2195315,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.31,0.00,'2021-12-07 14:24:47','',''),(2195342,'1','194','1012',460,'Retail Sale Id 1294776',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 14:26:11','',''),(2195343,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:26:11','',''),(2195390,'1','194','1012',460,'Retail Sale Id 1294800',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 14:28:24','',''),(2195391,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:28:24','',''),(2195418,'1','194','1012',460,'Retail Sale Id 1294807',5120.00,0.00,0.00,0.00,576.00,'2021-12-07 14:29:42','',''),(2195419,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 14:29:42','',''),(2195438,'1','194','1012',460,'Retail Sale Id 1294818',58800.00,0.00,0.00,0.00,2000.00,'2021-12-07 14:31:20','',''),(2195439,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-07 14:31:20','',''),(2195450,'1','194','1012',460,'Retail Sale Id 1294823',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 14:32:20','',''),(2195451,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:32:20','',''),(2195473,'1','194','1012',460,'Retail Sale Id 1294834',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 14:33:31','',''),(2195474,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:33:31','',''),(2195581,'1','194','1012',460,'Retail Sale Id 1294906',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 14:40:19','',''),(2195582,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 14:40:19','',''),(2195657,'1','194','1012',460,'Retail Sale Id 1294944',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 14:44:01','',''),(2195658,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:44:01','',''),(2195688,'1','194','1012',460,'Retail Sale Id 1294956',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 14:45:07','',''),(2195689,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:45:07','',''),(2195722,'1','194','1012',460,'Retail Sale Id 1294974',23520.00,0.00,0.00,0.00,800.00,'2021-12-07 14:47:04','',''),(2195723,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 14:47:04','',''),(2195754,'1','194','1012',460,'Retail Sale Id 1294988',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 14:48:45','',''),(2195755,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:48:45','',''),(2195860,'1','194','1012',460,'Retail Sale Id 1295050',6468.00,0.00,0.00,0.00,220.00,'2021-12-07 14:53:25','',''),(2195861,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 14:53:25','',''),(2195962,'1','194','1012',460,'Retail Sale Id 1295102',7040.00,0.00,0.00,0.00,792.00,'2021-12-07 15:00:45','',''),(2195963,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 15:00:45','',''),(2195978,'1','194','1012',460,'Retail Sale Id 1295110',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 15:01:47','',''),(2195979,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:01:47','',''),(2196011,'1','194','1012',460,'Retail Sale Id 1295116',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:02:59','',''),(2196012,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:02:59','',''),(2196058,'1','194','1012',460,'Retail Sale Id 1295142',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:06:21','',''),(2196059,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:06:21','',''),(2196128,'1','194','1012',460,'Retail Sale Id 1295165',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 15:09:43','',''),(2196129,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:09:43','',''),(2196166,'1','194','1012',460,'Retail Sale Id 1295197',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 15:11:21','',''),(2196167,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:11:21','',''),(2196220,'1','194','1012',460,'Retail Sale Id 1295219',6400.00,0.00,0.00,0.00,720.00,'2021-12-07 15:13:58','',''),(2196221,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:13:58','',''),(2196234,'1','194','1012',460,'Retail Sale Id 1295233',4998.40,0.00,0.00,0.00,562.32,'2021-12-07 15:15:06','',''),(2196235,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-07 15:15:06','',''),(2196296,'1','194','1012',460,'Retail Sale Id 1295258',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:18:11','',''),(2196297,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:18:11','',''),(2196382,'1','194','1012',460,'Retail Sale Id 1295309',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 15:23:16','',''),(2196383,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:23:16','',''),(2196408,'1','194','1012',460,'Retail Sale Id 1295323',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 15:24:37','',''),(2196409,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:24:37','',''),(2196456,'1','194','1012',460,'Retail Sale Id 1295346',11760.00,0.00,0.00,0.00,400.00,'2021-12-07 15:26:14','',''),(2196457,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-07 15:26:14','',''),(2196482,'1','194','1012',460,'Retail Sale Id 1295359',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:27:44','',''),(2196483,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:27:44','',''),(2196514,'1','194','1012',460,'Retail Sale Id 1295376',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:29:19','',''),(2196515,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:29:19','',''),(2196534,'1','194','1012',460,'Retail Sale Id 1295386',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 15:30:39','',''),(2196535,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:30:39','',''),(2196562,'1','194','1012',460,'Retail Sale Id 1295399',998.40,0.00,0.00,0.00,112.32,'2021-12-07 15:31:37','',''),(2196563,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 15:31:37','',''),(2196586,'1','194','1012',460,'Retail Sale Id 1295410',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:32:46','',''),(2196587,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:32:46','',''),(2196624,'1','194','1012',460,'Retail Sale Id 1295430',998.40,0.00,0.00,0.00,112.32,'2021-12-07 15:35:06','',''),(2196625,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-07 15:35:06','',''),(2196726,'1','194','1012',460,'Retail Sale Id 1295479',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 15:39:19','',''),(2196727,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:39:19','',''),(2196773,'1','194','1012',460,'Retail Sale Id 1295496',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 15:41:06','',''),(2196774,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:41:06','',''),(2196795,'1','194','1012',460,'Retail Sale Id 1295508',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 15:42:42','',''),(2196796,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:42:42','',''),(2196821,'1','194','1012',460,'Retail Sale Id 1295520',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 15:43:44','',''),(2196822,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:43:44','',''),(2196847,'1','194','1012',460,'Retail Sale Id 1295534',2502.40,0.00,0.00,0.00,281.52,'2021-12-07 15:44:51','',''),(2196848,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-07 15:44:51','',''),(2196893,'1','194','1012',460,'Retail Sale Id 1295557',57624.00,0.00,0.00,0.00,1960.00,'2021-12-07 15:46:58','',''),(2196894,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-07 15:46:58','',''),(2196921,'1','194','1012',460,'Retail Sale Id 1295574',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 15:48:50','',''),(2196922,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:48:50','',''),(2196941,'1','194','1012',460,'Retail Sale Id 1295585',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 15:49:38','',''),(2196942,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:49:38','',''),(2196976,'1','194','1012',460,'Retail Sale Id 1295600',9920.00,0.00,0.00,0.00,1116.00,'2021-12-07 15:51:17','',''),(2196977,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-07 15:51:17','',''),(2197002,'1','194','1012',460,'Retail Sale Id 1295617',23520.00,0.00,0.00,0.00,800.00,'2021-12-07 15:52:25','',''),(2197003,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 15:52:25','',''),(2197050,'1','194','1012',460,'Retail Sale Id 1295641',35280.00,0.00,0.00,0.00,1200.00,'2021-12-07 15:54:32','',''),(2197051,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-07 15:54:32','',''),(2197185,'1','194','1012',460,'Retail Sale Id 1295710',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 16:00:51','',''),(2197186,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:00:51','',''),(2197330,'1','194','1012',460,'Retail Sale Id 1295785',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 16:08:13','',''),(2197331,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:08:14','',''),(2197478,'1','194','1012',460,'Retail Sale Id 1295866',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 16:15:34','',''),(2197479,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:15:34','',''),(2197679,'1','194','1012',460,'Retail Sale Id 1295969',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 16:24:11','',''),(2197680,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 16:24:11','',''),(2197703,'1','194','1012',460,'Retail Sale Id 1295988',3200.00,0.00,0.00,0.00,360.00,'2021-12-07 16:25:42','',''),(2197704,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:25:42','',''),(2197725,'1','194','1012',460,'Retail Sale Id 1295997',1920.00,0.00,0.00,0.00,216.00,'2021-12-07 16:26:51','',''),(2197726,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:26:51','',''),(2197775,'1','194','1012',460,'Retail Sale Id 1296023',1900.80,0.00,0.00,0.00,213.84,'2021-12-07 16:28:46','',''),(2197776,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-07 16:28:46','',''),(2197797,'1','194','1012',460,'Retail Sale Id 1296033',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 16:29:44','',''),(2197798,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 16:29:44','',''),(2197848,'1','194','1012',460,'Retail Sale Id 1296059',2003.20,0.00,0.00,0.00,225.36,'2021-12-07 16:32:03','',''),(2197849,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-07 16:32:03','',''),(2197881,'1','194','1012',460,'Retail Sale Id 1296077',6400.00,0.00,0.00,0.00,720.00,'2021-12-07 16:34:01','',''),(2197882,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 16:34:01','',''),(2198049,'1','194','1012',460,'Retail Sale Id 1296171',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 16:44:40','',''),(2198050,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 16:44:41','',''),(2198089,'1','194','1012',460,'Retail Sale Id 1296189',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 16:47:05','',''),(2198090,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:47:06','',''),(2198114,'1','194','1012',460,'Retail Sale Id 1296203',2560.00,0.00,0.00,0.00,288.00,'2021-12-07 16:48:26','',''),(2198115,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 16:48:26','',''),(2198150,'1','194','1012',460,'Retail Sale Id 1296220',7040.00,0.00,0.00,0.00,792.00,'2021-12-07 16:51:05','',''),(2198151,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-07 16:51:05','',''),(2198190,'1','194','1012',460,'Retail Sale Id 1296236',27048.00,0.00,0.00,0.00,920.00,'2021-12-07 16:53:05','',''),(2198191,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-07 16:53:05','',''),(2198228,'1','194','1012',460,'Retail Sale Id 1296258',15876.00,0.00,0.00,0.00,540.00,'2021-12-07 16:54:53','',''),(2198229,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-07 16:54:53','',''),(2198258,'1','194','1012',460,'Retail Sale Id 1296274',3001.60,0.00,0.00,0.00,337.68,'2021-12-07 16:56:10','',''),(2198259,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-07 16:56:10','',''),(2198292,'1','194','1012',460,'Retail Sale Id 1296294',3840.00,0.00,0.00,0.00,432.00,'2021-12-07 16:57:31','',''),(2198293,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:57:31','',''),(2198323,'1','194','1012',460,'Retail Sale Id 1296307',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 16:59:06','',''),(2198324,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 16:59:06','',''),(2198425,'1','194','1012',460,'Retail Sale Id 1296355',8000.00,0.00,0.00,0.00,900.00,'2021-12-07 17:05:02','',''),(2198426,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:05:02','',''),(2198470,'1','194','1012',460,'Retail Sale Id 1296371',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 17:07:41','',''),(2198471,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 17:07:41','',''),(2198521,'1','194','1012',460,'Retail Sale Id 1296403',29400.00,0.00,0.00,0.00,1000.00,'2021-12-07 17:11:37','',''),(2198522,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 17:11:37','',''),(2198653,'1','194','1012',460,'Retail Sale Id 1296492',1280.00,0.00,0.00,0.00,144.00,'2021-12-07 17:21:45','',''),(2198654,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 17:21:45','',''),(2199854,'1','194','1012',460,'Retail Sale Id 1296827',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 06:20:23','',''),(2199855,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:20:23','',''),(2199890,'1','194','1012',460,'Retail Sale Id 1296846',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 06:24:32','',''),(2199891,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:24:32','',''),(2199918,'1','194','1012',460,'Retail Sale Id 1296860',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 06:27:51','',''),(2199919,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:27:51','',''),(2199946,'1','194','1012',460,'Retail Sale Id 1296873',26460.00,0.00,0.00,0.00,900.00,'2021-12-08 06:32:15','',''),(2199947,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-08 06:32:15','',''),(2199968,'1','194','1012',460,'Retail Sale Id 1296884',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 06:34:23','',''),(2199969,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 06:34:23','',''),(2199998,'1','194','1012',460,'Retail Sale Id 1296900',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 06:36:42','',''),(2199999,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 06:36:42','',''),(2200030,'1','194','1012',460,'Retail Sale Id 1296915',29400.00,0.00,0.00,0.00,1000.00,'2021-12-08 06:38:50','',''),(2200031,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 06:38:51','',''),(2200139,'1','194','1012',460,'Retail Sale Id 1296960',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 06:45:27','',''),(2200140,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 06:45:27','',''),(2200196,'1','194','1012',460,'Retail Sale Id 1296975',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 06:47:24','',''),(2200197,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 06:47:24','',''),(2200264,'1','194','1012',460,'Retail Sale Id 1296992',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 06:49:53','',''),(2200265,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:49:53','',''),(2200347,'1','194','1012',460,'Retail Sale Id 1297028',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 06:55:34','',''),(2200348,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 06:55:34','',''),(2200391,'1','194','1012',460,'Retail Sale Id 1297050',640.00,0.00,0.00,0.00,72.00,'2021-12-08 06:57:24','',''),(2200392,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 06:57:24','',''),(2200405,'1','194','1012',460,'Retail Sale Id 1297058',32340.00,0.00,0.00,0.00,1100.00,'2021-12-08 06:58:23','',''),(2200406,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-08 06:58:23','',''),(2200421,'1','194','1012',460,'Retail Sale Id 1297065',17640.00,0.00,0.00,0.00,600.00,'2021-12-08 06:59:12','',''),(2200422,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-08 06:59:12','',''),(2200445,'1','194','1012',460,'Retail Sale Id 1297074',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 07:00:17','',''),(2200446,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:00:17','',''),(2200467,'1','194','1012',460,'Retail Sale Id 1297087',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 07:02:04','',''),(2200468,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:02:04','',''),(2200485,'1','194','1012',460,'Retail Sale Id 1297096',6400.00,0.00,0.00,0.00,720.00,'2021-12-08 07:03:14','',''),(2200486,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 07:03:14','',''),(2200505,'1','194','1012',460,'Retail Sale Id 1297106',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 07:04:13','',''),(2200506,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:04:13','',''),(2200517,'1','194','1012',460,'Retail Sale Id 1297113',6400.00,0.00,0.00,0.00,720.00,'2021-12-08 07:05:02','',''),(2200518,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 07:05:02','',''),(2200583,'1','194','1012',460,'Retail Sale Id 1297141',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 07:09:56','',''),(2200584,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:09:56','',''),(2200617,'1','194','1012',460,'Retail Sale Id 1297160',1497.60,0.00,0.00,0.00,168.48,'2021-12-08 07:12:24','',''),(2200618,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 07:12:24','',''),(2200625,'1','194','1012',460,'Retail Sale Id 1297164',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 07:13:13','',''),(2200626,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:13:13','',''),(2200647,'1','194','1012',460,'Retail Sale Id 1297176',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 07:14:33','',''),(2200648,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:14:33','',''),(2200708,'1','194','1012',460,'Retail Sale Id 1297206',41160.00,0.00,0.00,0.00,1400.00,'2021-12-08 07:17:49','',''),(2200709,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-08 07:17:49','',''),(2200820,'1','194','1012',460,'Retail Sale Id 1297250',58800.00,0.00,0.00,0.00,2000.00,'2021-12-08 07:22:16','',''),(2200821,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 07:22:16','',''),(2200865,'1','194','1012',460,'Retail Sale Id 1297277',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 07:25:11','',''),(2200866,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:25:11','',''),(2200930,'1','194','1012',460,'Retail Sale Id 1297308',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 07:29:33','',''),(2200931,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 07:29:33','',''),(2201003,'1','194','1012',460,'Retail Sale Id 1297337',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 07:32:56','',''),(2201004,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 07:32:56','',''),(2201078,'1','194','1012',460,'Retail Sale Id 1297366',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 07:35:17','',''),(2201079,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:35:17','',''),(2201110,'1','194','1012',460,'Retail Sale Id 1297379',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 07:37:21','',''),(2201111,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:37:21','',''),(2201146,'1','194','1012',460,'Retail Sale Id 1297397',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 07:39:27','',''),(2201147,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:39:27','',''),(2201238,'1','194','1012',460,'Retail Sale Id 1297446',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 07:45:35','',''),(2201239,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:45:35','',''),(2201286,'1','194','1012',460,'Retail Sale Id 1297470',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 07:48:29','',''),(2201287,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:48:29','',''),(2201379,'1','194','1012',460,'Retail Sale Id 1297514',11200.00,0.00,0.00,0.00,1260.00,'2021-12-08 07:52:49','',''),(2201380,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-08 07:52:49','',''),(2201595,'1','194','1012',460,'Retail Sale Id 1297603',4480.00,0.00,0.00,0.00,504.00,'2021-12-08 08:02:25','',''),(2201596,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 08:02:25','',''),(2201637,'1','194','1012',460,'Retail Sale Id 1297620',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:04:28','',''),(2201638,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:04:28','',''),(2201687,'1','194','1012',460,'Retail Sale Id 1297645',17600.00,0.00,0.00,0.00,1980.00,'2021-12-08 08:07:03','',''),(2201688,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,27.50,0.00,'2021-12-08 08:07:03','',''),(2201693,'1','194','1012',460,'Retail Sale Id 1297650',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 08:08:04','',''),(2201694,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 08:08:04','',''),(2201764,'1','194','1012',460,'Retail Sale Id 1297684',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 08:13:31','',''),(2201765,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:13:31','',''),(2201917,'1','194','1012',460,'Retail Sale Id 1297771',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 08:23:05','',''),(2201918,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:23:05','',''),(2201941,'1','194','1012',460,'Retail Sale Id 1297781',998.40,0.00,0.00,0.00,112.32,'2021-12-08 08:25:03','',''),(2201942,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 08:25:03','',''),(2202006,'1','194','1012',460,'Retail Sale Id 1297804',87600.00,0.00,0.00,0.00,2400.00,'2021-12-08 08:28:41','',''),(2202007,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-08 08:28:41','',''),(2202068,'1','194','1012',460,'Retail Sale Id 1297831',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:33:03','',''),(2202069,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:33:03','',''),(2202182,'1','194','1012',460,'Retail Sale Id 1297887',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 08:39:53','',''),(2202183,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 08:39:53','',''),(2202532,'1','194','1012',460,'Retail Sale Id 1298006',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 08:54:22','',''),(2202533,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 08:54:22','',''),(2202666,'1','194','1012',460,'Retail Sale Id 1298070',6003.20,0.00,0.00,0.00,675.36,'2021-12-08 09:02:59','',''),(2202667,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.38,0.00,'2021-12-08 09:02:59','',''),(2202702,'1','194','1012',460,'Retail Sale Id 1298086',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 09:04:40','',''),(2202703,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:04:40','',''),(2202799,'1','194','1012',460,'Retail Sale Id 1298148',5120.00,0.00,0.00,0.00,576.00,'2021-12-08 09:10:43','',''),(2202800,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 09:10:43','',''),(2202890,'1','194','1012',460,'Retail Sale Id 1298184',28616.00,0.00,0.00,0.00,784.00,'2021-12-08 09:15:41','',''),(2202891,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-08 09:15:41','',''),(2203133,'1','194','1012',460,'Retail Sale Id 1298302',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 09:34:24','',''),(2203134,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:34:24','',''),(2203179,'1','194','1012',460,'Retail Sale Id 1298323',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 09:38:00','',''),(2203180,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:38:00','',''),(2203193,'1','194','1012',460,'Retail Sale Id 1298332',2003.20,0.00,0.00,0.00,225.36,'2021-12-08 09:38:57','',''),(2203194,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 09:38:57','',''),(2203231,'1','194','1012',460,'Retail Sale Id 1298353',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 09:42:44','',''),(2203232,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:42:44','',''),(2203243,'1','194','1012',460,'Retail Sale Id 1298358',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 09:43:50','',''),(2203244,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 09:43:50','',''),(2203301,'1','194','1012',460,'Retail Sale Id 1298388',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 09:47:58','',''),(2203302,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 09:47:58','',''),(2203406,'1','194','1012',460,'Retail Sale Id 1298436',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 09:55:23','',''),(2203407,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 09:55:23','',''),(2203548,'1','194','1012',460,'Retail Sale Id 1298493',175200.00,0.00,0.00,0.00,4800.00,'2021-12-08 10:04:48','',''),(2203549,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-08 10:04:48','',''),(2203582,'1','194','1012',460,'Retail Sale Id 1298511',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 10:07:51','',''),(2203583,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 10:07:51','',''),(2203661,'1','194','1012',460,'Retail Sale Id 1298547',57232.00,0.00,0.00,0.00,1568.00,'2021-12-08 10:12:30','',''),(2203662,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-08 10:12:30','',''),(2203831,'1','194','1012',460,'Retail Sale Id 1298634',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 10:23:09','',''),(2203832,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 10:23:09','',''),(2203925,'1','194','1012',460,'Retail Sale Id 1298666',58400.00,0.00,0.00,0.00,1600.00,'2021-12-08 10:27:56','',''),(2203926,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-08 10:27:56','',''),(2204001,'1','194','1012',460,'Retail Sale Id 1298702',7680.00,0.00,0.00,0.00,864.00,'2021-12-08 10:33:03','',''),(2204002,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 10:33:03','',''),(2204095,'1','194','1012',460,'Retail Sale Id 1298753',16000.00,0.00,0.00,0.00,1800.00,'2021-12-08 10:40:41','',''),(2204096,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 10:40:41','',''),(2204170,'1','194','1012',460,'Retail Sale Id 1298790',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 10:47:30','',''),(2204171,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:47:30','',''),(2204325,'1','194','1012',460,'Retail Sale Id 1298865',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 11:00:20','',''),(2204326,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:00:20','',''),(2204472,'1','194','1012',460,'Retail Sale Id 1298946',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 11:10:17','',''),(2204473,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 11:10:17','',''),(2204584,'1','194','1012',460,'Retail Sale Id 1299004',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 11:18:29','',''),(2204585,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 11:18:29','',''),(2204684,'1','194','1012',460,'Retail Sale Id 1299053',7680.00,0.00,0.00,0.00,864.00,'2021-12-08 11:25:27','',''),(2204685,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-08 11:25:27','',''),(2204756,'1','194','1012',460,'Retail Sale Id 1299091',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 11:31:25','',''),(2204757,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:31:25','',''),(2204774,'1','194','1012',460,'Retail Sale Id 1299101',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 11:32:38','',''),(2204775,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:32:38','',''),(2204840,'1','194','1012',460,'Retail Sale Id 1299134',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 11:36:16','',''),(2204841,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 11:36:16','',''),(2204866,'1','194','1012',460,'Retail Sale Id 1299151',19200.00,0.00,0.00,0.00,2160.00,'2021-12-08 11:38:12','',''),(2204867,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-08 11:38:12','',''),(2204934,'1','194','1012',460,'Retail Sale Id 1299186',4480.00,0.00,0.00,0.00,504.00,'2021-12-08 11:41:04','',''),(2204935,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 11:41:04','',''),(2205038,'1','194','1012',460,'Retail Sale Id 1299236',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 11:47:43','',''),(2205039,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:47:43','',''),(2205116,'1','194','1012',460,'Retail Sale Id 1299272',7300.00,0.00,0.00,0.00,200.00,'2021-12-08 11:54:11','',''),(2205117,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:54:11','',''),(2205317,'1','194','1012',460,'Retail Sale Id 1299358',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 12:09:14','',''),(2205318,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 12:09:14','',''),(2205798,'1','194','1012',460,'Retail Sale Id 1299586',640.00,0.00,0.00,0.00,72.00,'2021-12-08 12:45:24','',''),(2205799,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 12:45:24','',''),(2206001,'1','194','1012',460,'Retail Sale Id 1299659',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 12:56:59','',''),(2206002,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 12:56:59','',''),(2206058,'1','194','1012',460,'Retail Sale Id 1299689',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 13:01:37','',''),(2206059,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:01:37','',''),(2206150,'1','194','1012',460,'Retail Sale Id 1299735',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 13:07:55','',''),(2206151,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 13:07:55','',''),(2206225,'1','194','1012',460,'Retail Sale Id 1299770',1497.60,0.00,0.00,0.00,168.48,'2021-12-08 13:13:13','',''),(2206226,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-08 13:13:13','',''),(2206275,'1','194','1012',460,'Retail Sale Id 1299792',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 13:15:26','',''),(2206276,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:15:26','',''),(2206333,'1','194','1012',460,'Retail Sale Id 1299820',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 13:19:03','',''),(2206334,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:19:03','',''),(2206361,'1','194','1012',460,'Retail Sale Id 1299839',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 13:22:07','',''),(2206362,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:22:07','',''),(2206411,'1','194','1012',460,'Retail Sale Id 1299862',17520.00,0.00,0.00,0.00,480.00,'2021-12-08 13:26:01','',''),(2206412,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-08 13:26:01','',''),(2206566,'1','194','1012',460,'Retail Sale Id 1299914',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 13:34:07','',''),(2206567,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:34:07','',''),(2206591,'1','194','1012',460,'Retail Sale Id 1299930',19227.00,0.00,0.00,0.00,17523.00,'2021-12-08 13:35:49','',''),(2206593,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 13:35:49','',''),(2206622,'1','194','1012',460,'Retail Sale Id 1299941',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 13:38:06','',''),(2206623,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 13:38:06','',''),(2206702,'1','194','1012',460,'Retail Sale Id 1299977',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 13:42:01','',''),(2206703,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 13:42:01','',''),(2206747,'1','194','1012',460,'Retail Sale Id 1299993',640.00,0.00,0.00,0.00,72.00,'2021-12-08 13:43:40','',''),(2206748,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 13:43:40','',''),(2206799,'1','194','1012',460,'Retail Sale Id 1300013',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 13:46:03','',''),(2206800,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 13:46:03','',''),(2206961,'1','194','1012',460,'Retail Sale Id 1300075',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 13:55:39','',''),(2206962,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 13:55:39','',''),(2207173,'1','194','1012',460,'Retail Sale Id 1300167',5760.00,0.00,0.00,0.00,648.00,'2021-12-08 14:09:37','',''),(2207174,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-08 14:09:37','',''),(2207199,'1','194','1012',460,'Retail Sale Id 1300176',4998.40,0.00,0.00,0.00,562.32,'2021-12-08 14:11:03','',''),(2207200,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-08 14:11:03','',''),(2207295,'1','194','1012',460,'Retail Sale Id 1300210',37960.00,0.00,0.00,0.00,1040.00,'2021-12-08 14:17:35','',''),(2207296,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-08 14:17:35','',''),(2207357,'1','194','1012',460,'Retail Sale Id 1300273',57232.00,0.00,0.00,0.00,1568.00,'2021-12-08 14:21:11','',''),(2207358,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-08 14:21:11','',''),(2207389,'1','194','1012',460,'Retail Sale Id 1300289',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 14:23:46','',''),(2207390,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 14:23:46','',''),(2207510,'1','194','1012',460,'Retail Sale Id 1300339',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 14:29:08','',''),(2207511,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 14:29:08','',''),(2207754,'1','194','1012',460,'Retail Sale Id 1300441',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 14:40:20','',''),(2207755,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:40:20','',''),(2207798,'1','194','1012',460,'Retail Sale Id 1300456',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 14:42:43','',''),(2207799,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:42:43','',''),(2207810,'1','194','1012',460,'Retail Sale Id 1300475',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 14:43:26','',''),(2207811,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:43:26','',''),(2207845,'1','194','1012',460,'Retail Sale Id 1300494',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 14:45:24','',''),(2207846,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:45:24','',''),(2207981,'1','194','1012',460,'Retail Sale Id 1300569',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 14:53:51','',''),(2207982,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 14:53:51','',''),(2208017,'1','194','1012',460,'Retail Sale Id 1300582',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 14:55:58','',''),(2208018,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:55:58','',''),(2208112,'1','194','1012',460,'Retail Sale Id 1300629',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 15:04:03','',''),(2208113,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:04:03','',''),(2208160,'1','194','1012',460,'Retail Sale Id 1300645',1299.20,0.00,0.00,0.00,146.16,'2021-12-08 15:07:22','',''),(2208161,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-08 15:07:22','',''),(2208199,'1','194','1012',460,'Retail Sale Id 1300657',998.40,0.00,0.00,0.00,112.32,'2021-12-08 15:08:23','',''),(2208200,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 15:08:23','',''),(2208211,'1','194','1012',460,'Retail Sale Id 1300661',998.40,0.00,0.00,0.00,112.32,'2021-12-08 15:09:28','',''),(2208212,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-08 15:09:28','',''),(2208253,'1','194','1012',460,'Retail Sale Id 1300680',5120.00,0.00,0.00,0.00,576.00,'2021-12-08 15:11:49','',''),(2208254,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 15:11:49','',''),(2208279,'1','194','1012',460,'Retail Sale Id 1300699',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 15:13:14','',''),(2208280,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:13:14','',''),(2208297,'1','194','1012',460,'Retail Sale Id 1300705',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 15:14:04','',''),(2208298,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:14:04','',''),(2208319,'1','194','1012',460,'Retail Sale Id 1300713',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 15:15:16','',''),(2208320,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:15:16','',''),(2208341,'1','194','1012',460,'Retail Sale Id 1300728',640.00,0.00,0.00,0.00,72.00,'2021-12-08 15:17:13','',''),(2208342,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 15:17:13','',''),(2208474,'1','194','1012',460,'Retail Sale Id 1300789',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 15:23:05','',''),(2208475,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 15:23:05','',''),(2208493,'1','194','1012',460,'Retail Sale Id 1300796',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 15:24:14','',''),(2208494,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 15:24:14','',''),(2208560,'1','194','1012',460,'Retail Sale Id 1300830',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 15:27:52','',''),(2208561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:27:52','',''),(2208580,'1','194','1012',460,'Retail Sale Id 1300842',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 15:28:43','',''),(2208581,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:28:43','',''),(2208602,'1','194','1012',460,'Retail Sale Id 1300853',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 15:29:58','',''),(2208603,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 15:29:58','',''),(2208661,'1','194','1012',460,'Retail Sale Id 1300877',35040.00,0.00,0.00,0.00,960.00,'2021-12-08 15:32:55','',''),(2208662,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 15:32:55','',''),(2208699,'1','194','1012',460,'Retail Sale Id 1300908',2003.20,0.00,0.00,0.00,225.36,'2021-12-08 15:34:54','',''),(2208700,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 15:34:54','',''),(2208733,'1','194','1012',460,'Retail Sale Id 1300920',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 15:36:17','',''),(2208734,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:36:17','',''),(2208763,'1','194','1012',460,'Retail Sale Id 1300938',902.40,0.00,0.00,0.00,101.52,'2021-12-08 15:37:44','',''),(2208764,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.41,0.00,'2021-12-08 15:37:44','',''),(2208781,'1','194','1012',460,'Retail Sale Id 1300949',1900.80,0.00,0.00,0.00,213.84,'2021-12-08 15:38:46','',''),(2208782,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-08 15:38:46','',''),(2208805,'1','194','1012',460,'Retail Sale Id 1300961',7763.20,0.00,0.00,0.00,873.36,'2021-12-08 15:39:56','',''),(2208806,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.13,0.00,'2021-12-08 15:39:56','',''),(2208817,'1','194','1012',460,'Retail Sale Id 1300967',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 15:40:49','',''),(2208818,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:40:49','',''),(2208845,'1','194','1012',460,'Retail Sale Id 1300980',4000.00,0.00,0.00,0.00,450.00,'2021-12-08 15:42:03','',''),(2208846,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 15:42:03','',''),(2208869,'1','194','1012',460,'Retail Sale Id 1300994',2502.40,0.00,0.00,0.00,281.52,'2021-12-08 15:43:04','',''),(2208870,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-08 15:43:04','',''),(2208887,'1','194','1012',460,'Retail Sale Id 1301005',1203.20,0.00,0.00,0.00,135.36,'2021-12-08 15:44:01','',''),(2208888,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-08 15:44:01','',''),(2208911,'1','194','1012',460,'Retail Sale Id 1301015',6400.00,0.00,0.00,0.00,720.00,'2021-12-08 15:45:30','',''),(2208912,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 15:45:30','',''),(2208947,'1','194','1012',460,'Retail Sale Id 1301036',640.00,0.00,0.00,0.00,72.00,'2021-12-08 15:47:17','',''),(2208948,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 15:47:17','',''),(2208967,'1','194','1012',460,'Retail Sale Id 1301043',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 15:48:31','',''),(2208968,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:48:31','',''),(2208985,'1','194','1012',460,'Retail Sale Id 1301053',4480.00,0.00,0.00,0.00,504.00,'2021-12-08 15:49:55','',''),(2208986,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 15:49:55','',''),(2209001,'1','194','1012',460,'Retail Sale Id 1301061',35040.00,0.00,0.00,0.00,960.00,'2021-12-08 15:51:00','',''),(2209002,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-08 15:51:00','',''),(2209017,'1','194','1012',460,'Retail Sale Id 1301066',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 15:51:53','',''),(2209018,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 15:51:53','',''),(2209049,'1','194','1012',460,'Retail Sale Id 1301071',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 15:53:01','',''),(2209050,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:53:01','',''),(2209071,'1','194','1012',460,'Retail Sale Id 1301086',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 15:54:31','',''),(2209072,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:54:31','',''),(2209085,'1','194','1012',460,'Retail Sale Id 1301094',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 15:55:26','',''),(2209086,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:55:26','',''),(2209097,'1','194','1012',460,'Retail Sale Id 1301102',1798.40,0.00,0.00,0.00,202.32,'2021-12-08 15:56:13','',''),(2209098,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.81,0.00,'2021-12-08 15:56:13','',''),(2209117,'1','194','1012',460,'Retail Sale Id 1301110',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 15:57:08','',''),(2209118,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 15:57:08','',''),(2209145,'1','194','1012',460,'Retail Sale Id 1301127',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 15:59:00','',''),(2209146,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 15:59:00','',''),(2209177,'1','194','1012',460,'Retail Sale Id 1301145',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:00:19','',''),(2209178,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:00:19','',''),(2209203,'1','194','1012',460,'Retail Sale Id 1301156',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 16:01:16','',''),(2209204,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 16:01:16','',''),(2209223,'1','194','1012',460,'Retail Sale Id 1301168',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 16:02:17','',''),(2209224,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 16:02:17','',''),(2209249,'1','194','1012',460,'Retail Sale Id 1301181',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:03:28','',''),(2209250,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:03:28','',''),(2209259,'1','194','1012',460,'Retail Sale Id 1301187',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 16:04:16','',''),(2209260,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:04:16','',''),(2209285,'1','194','1012',460,'Retail Sale Id 1301199',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 16:05:12','',''),(2209286,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:05:12','',''),(2209299,'1','194','1012',460,'Retail Sale Id 1301206',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:05:49','',''),(2209300,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:05:49','',''),(2209318,'1','194','1012',460,'Retail Sale Id 1301214',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:06:44','',''),(2209319,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:06:44','',''),(2209329,'1','194','1012',460,'Retail Sale Id 1301219',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 16:07:20','',''),(2209330,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:07:20','',''),(2209367,'1','194','1012',460,'Retail Sale Id 1301234',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 16:08:56','',''),(2209368,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:08:56','',''),(2209416,'1','194','1012',460,'Retail Sale Id 1301257',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:10:51','',''),(2209417,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:10:51','',''),(2209446,'1','194','1012',460,'Retail Sale Id 1301268',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 16:11:56','',''),(2209447,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 16:11:56','',''),(2209472,'1','194','1012',460,'Retail Sale Id 1301283',640.00,0.00,0.00,0.00,72.00,'2021-12-08 16:12:44','',''),(2209473,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 16:12:44','',''),(2209494,'1','194','1012',460,'Retail Sale Id 1301296',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 16:14:05','',''),(2209495,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:14:05','',''),(2209536,'1','194','1012',460,'Retail Sale Id 1301313',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 16:15:45','',''),(2209537,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 16:15:45','',''),(2209582,'1','194','1012',460,'Retail Sale Id 1301326',2003.20,0.00,0.00,0.00,225.36,'2021-12-08 16:16:37','',''),(2209583,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:16:37','',''),(2209610,'1','194','1012',460,'Retail Sale Id 1301339',2003.20,0.00,0.00,0.00,225.36,'2021-12-08 16:17:53','',''),(2209611,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 16:17:53','',''),(2209644,'1','194','1012',460,'Retail Sale Id 1301351',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 16:19:19','',''),(2209645,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 16:19:19','',''),(2209690,'1','194','1012',460,'Retail Sale Id 1301380',23360.00,0.00,0.00,0.00,640.00,'2021-12-08 16:21:52','',''),(2209691,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 16:21:52','',''),(2209716,'1','194','1012',460,'Retail Sale Id 1301396',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 16:23:20','',''),(2209717,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:23:20','',''),(2209784,'1','194','1012',460,'Retail Sale Id 1301489',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:28:28','',''),(2209785,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:28:28','',''),(2209957,'1','194','1012',460,'Retail Sale Id 1301624',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:36:03','',''),(2209958,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:36:03','',''),(2209993,'1','194','1012',460,'Retail Sale Id 1301642',4480.00,0.00,0.00,0.00,504.00,'2021-12-08 16:37:53','',''),(2209994,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 16:37:53','',''),(2210039,'1','194','1012',460,'Retail Sale Id 1301670',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:39:43','',''),(2210040,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:39:43','',''),(2210067,'1','194','1012',460,'Retail Sale Id 1301682',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 16:40:51','',''),(2210068,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:40:51','',''),(2210089,'1','194','1012',460,'Retail Sale Id 1301695',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 16:41:59','',''),(2210090,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:41:59','',''),(2210125,'1','194','1012',460,'Retail Sale Id 1301714',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 16:43:37','',''),(2210126,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:43:37','',''),(2210143,'1','194','1012',460,'Retail Sale Id 1301728',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 16:44:43','',''),(2210144,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:44:43','',''),(2210281,'1','194','1012',460,'Retail Sale Id 1301794',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 16:51:51','',''),(2210282,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:51:51','',''),(2210330,'1','194','1012',460,'Retail Sale Id 1301811',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 16:54:42','',''),(2210331,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:54:42','',''),(2210370,'1','194','1012',460,'Retail Sale Id 1301841',29200.00,0.00,0.00,0.00,800.00,'2021-12-08 16:57:33','',''),(2210371,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 16:57:33','',''),(2210392,'1','194','1012',460,'Retail Sale Id 1301856',4480.00,0.00,0.00,0.00,504.00,'2021-12-08 16:59:12','',''),(2210393,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-08 16:59:12','',''),(2210404,'1','194','1012',460,'Retail Sale Id 1301861',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 17:00:12','',''),(2210405,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:00:12','',''),(2210424,'1','194','1012',460,'Retail Sale Id 1301873',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 17:01:33','',''),(2210425,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:01:33','',''),(2210483,'1','194','1012',460,'Retail Sale Id 1301902',3200.00,0.00,0.00,0.00,360.00,'2021-12-08 17:06:38','',''),(2210484,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 17:06:38','',''),(2210531,'1','194','1012',460,'Retail Sale Id 1301931',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 17:11:08','',''),(2210532,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:11:08','',''),(2210561,'1','194','1012',460,'Retail Sale Id 1301945',24000.00,0.00,0.00,0.00,2700.00,'2021-12-08 17:13:22','',''),(2210562,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-08 17:13:22','',''),(2210583,'1','194','1012',460,'Retail Sale Id 1301962',2003.20,0.00,0.00,0.00,225.36,'2021-12-08 17:15:18','',''),(2210584,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-08 17:15:18','',''),(2210611,'1','194','1012',460,'Retail Sale Id 1301982',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 17:18:12','',''),(2210612,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:18:12','',''),(2210627,'1','194','1012',460,'Retail Sale Id 1301989',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 17:19:17','',''),(2210628,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 17:19:17','',''),(2210688,'1','194','1012',460,'Retail Sale Id 1302023',3840.00,0.00,0.00,0.00,432.00,'2021-12-08 17:27:28','',''),(2210689,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:27:28','',''),(2210702,'1','194','1012',460,'Retail Sale Id 1302033',1920.00,0.00,0.00,0.00,216.00,'2021-12-08 17:28:24','',''),(2210703,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:28:24','',''),(2210728,'1','194','1012',460,'Retail Sale Id 1302045',11520.00,0.00,0.00,0.00,1296.00,'2021-12-08 17:30:22','',''),(2210729,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-08 17:30:22','',''),(2210742,'1','194','1012',460,'Retail Sale Id 1302052',37960.00,0.00,0.00,0.00,1040.00,'2021-12-08 17:32:01','',''),(2210743,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-08 17:32:01','',''),(2210759,'1','194','1012',460,'Retail Sale Id 1302061',8000.00,0.00,0.00,0.00,900.00,'2021-12-08 17:34:39','',''),(2210760,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:34:39','',''),(2210771,'1','194','1012',460,'Retail Sale Id 1302070',2560.00,0.00,0.00,0.00,288.00,'2021-12-08 17:36:06','',''),(2210772,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 17:36:06','',''),(2210799,'1','194','1012',460,'Retail Sale Id 1302085',1280.00,0.00,0.00,0.00,144.00,'2021-12-08 17:39:28','',''),(2210800,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 17:39:28','',''),(2212147,'1','194','1012',460,'Retail Sale Id 1302435',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 06:21:21','',''),(2212148,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:21:21','',''),(2212169,'1','194','1012',460,'Retail Sale Id 1302444',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 06:22:37','',''),(2212170,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 06:22:37','',''),(2212220,'1','194','1012',460,'Retail Sale Id 1302462',6400.00,0.00,0.00,0.00,720.00,'2021-12-09 06:25:01','',''),(2212221,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 06:25:01','',''),(2212302,'1','194','1012',460,'Retail Sale Id 1302506',697.60,0.00,0.00,0.00,78.48,'2021-12-09 06:31:39','',''),(2212303,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-09 06:31:39','',''),(2212338,'1','194','1012',460,'Retail Sale Id 1302522',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 06:33:35','',''),(2212339,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:33:35','',''),(2212762,'1','194','1012',460,'Retail Sale Id 1302707',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 06:56:37','',''),(2212763,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:56:37','',''),(2212802,'1','194','1012',460,'Retail Sale Id 1302725',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 06:58:22','',''),(2212803,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:58:22','',''),(2212826,'1','194','1012',460,'Retail Sale Id 1302736',9600.00,0.00,0.00,0.00,1080.00,'2021-12-09 06:59:39','',''),(2212827,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-09 06:59:39','',''),(2212860,'1','194','1012',460,'Retail Sale Id 1302754',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 07:01:32','',''),(2212861,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:01:32','',''),(2213030,'1','194','1012',460,'Retail Sale Id 1302826',5760.00,0.00,0.00,0.00,648.00,'2021-12-09 07:11:03','',''),(2213031,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 07:11:03','',''),(2213085,'1','194','1012',460,'Retail Sale Id 1302856',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 07:14:04','',''),(2213086,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:14:04','',''),(2213114,'1','194','1012',460,'Retail Sale Id 1302873',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 07:15:15','',''),(2213115,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:15:15','',''),(2213165,'1','194','1012',460,'Retail Sale Id 1302893',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 07:16:41','',''),(2213166,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:16:41','',''),(2213192,'1','194','1012',460,'Retail Sale Id 1302905',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 07:17:48','',''),(2213193,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:17:48','',''),(2213218,'1','194','1012',460,'Retail Sale Id 1302921',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 07:19:03','',''),(2213219,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:19:03','',''),(2213376,'1','194','1012',460,'Retail Sale Id 1302996',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 07:25:52','',''),(2213377,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:25:52','',''),(2213410,'1','194','1012',460,'Retail Sale Id 1303013',998.40,0.00,0.00,0.00,112.32,'2021-12-09 07:27:34','',''),(2213411,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 07:27:34','',''),(2213558,'1','194','1012',460,'Retail Sale Id 1303083',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 07:34:11','',''),(2213559,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 07:34:11','',''),(2213594,'1','194','1012',460,'Retail Sale Id 1303104',1900.80,0.00,0.00,0.00,213.84,'2021-12-09 07:36:13','',''),(2213595,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-09 07:36:13','',''),(2213727,'1','194','1012',460,'Retail Sale Id 1303167',2003.20,0.00,0.00,0.00,225.36,'2021-12-09 07:43:03','',''),(2213728,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:43:03','',''),(2213782,'1','194','1012',460,'Retail Sale Id 1303191',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 07:45:30','',''),(2213783,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 07:45:30','',''),(2213810,'1','194','1012',460,'Retail Sale Id 1303203',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 07:46:35','',''),(2213811,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:46:35','',''),(2213896,'1','194','1012',460,'Retail Sale Id 1303245',2003.20,0.00,0.00,0.00,225.36,'2021-12-09 07:51:25','',''),(2213897,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 07:51:25','',''),(2214084,'1','194','1012',460,'Retail Sale Id 1303342',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 08:02:26','',''),(2214085,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 08:02:26','',''),(2214312,'1','194','1012',460,'Retail Sale Id 1303464',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 08:14:39','',''),(2214313,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:14:39','',''),(2214338,'1','194','1012',460,'Retail Sale Id 1303477',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 08:15:54','',''),(2214339,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 08:15:54','',''),(2214389,'1','194','1012',460,'Retail Sale Id 1303496',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 08:17:58','',''),(2214390,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:17:58','',''),(2214408,'1','194','1012',460,'Retail Sale Id 1303505',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 08:18:59','',''),(2214409,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 08:18:59','',''),(2214549,'1','194','1012',460,'Retail Sale Id 1303555',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 08:25:16','',''),(2214550,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:25:16','',''),(2214673,'1','194','1012',460,'Retail Sale Id 1303600',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 08:30:06','',''),(2214674,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:30:06','',''),(2214708,'1','194','1012',460,'Retail Sale Id 1303617',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 08:31:50','',''),(2214709,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 08:31:50','',''),(2214829,'1','194','1012',460,'Retail Sale Id 1303687',12800.00,0.00,0.00,0.00,1440.00,'2021-12-09 08:38:23','',''),(2214830,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 08:38:23','',''),(2214913,'1','194','1012',460,'Retail Sale Id 1303727',71540.00,0.00,0.00,0.00,1960.00,'2021-12-09 08:41:42','',''),(2214914,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,122.50,0.00,'2021-12-09 08:41:42','',''),(2215026,'1','194','1012',460,'Retail Sale Id 1303770',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 08:47:06','',''),(2215027,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 08:47:06','',''),(2215084,'1','194','1012',460,'Retail Sale Id 1303801',23360.00,0.00,0.00,0.00,640.00,'2021-12-09 08:50:57','',''),(2215085,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 08:50:57','',''),(2215216,'1','194','1012',460,'Retail Sale Id 1303873',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 08:59:36','',''),(2215217,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:59:36','',''),(2215250,'1','194','1012',460,'Retail Sale Id 1303890',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 09:01:15','',''),(2215251,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 09:01:15','',''),(2215388,'1','194','1012',460,'Retail Sale Id 1303961',26864.00,0.00,0.00,0.00,736.00,'2021-12-09 09:09:22','',''),(2215389,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-09 09:09:22','',''),(2215573,'1','194','1012',460,'Retail Sale Id 1304055',70080.00,0.00,0.00,0.00,1920.00,'2021-12-09 09:21:09','',''),(2215574,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,120.00,0.00,'2021-12-09 09:21:09','',''),(2215744,'1','194','1012',460,'Retail Sale Id 1304139',6400.00,0.00,0.00,0.00,720.00,'2021-12-09 09:29:34','',''),(2215745,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 09:29:34','',''),(2215833,'1','194','1012',460,'Retail Sale Id 1304177',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 09:34:06','',''),(2215834,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 09:34:06','',''),(2215927,'1','194','1012',460,'Retail Sale Id 1304217',35040.00,0.00,0.00,0.00,960.00,'2021-12-09 09:37:52','',''),(2215928,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 09:37:52','',''),(2215960,'1','194','1012',460,'Retail Sale Id 1304235',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 09:40:12','',''),(2215961,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 09:40:12','',''),(2216070,'1','194','1012',460,'Retail Sale Id 1304269',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 09:44:43','',''),(2216071,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 09:44:43','',''),(2216344,'1','194','1012',460,'Retail Sale Id 1304387',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 09:57:46','',''),(2216345,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:57:46','',''),(2216443,'1','194','1012',460,'Retail Sale Id 1304427',58400.00,0.00,0.00,0.00,1600.00,'2021-12-09 10:02:30','',''),(2216444,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 10:02:30','',''),(2216483,'1','194','1012',460,'Retail Sale Id 1304446',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 10:05:09','',''),(2216484,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:05:09','',''),(2216508,'1','194','1012',460,'Retail Sale Id 1304461',87600.00,0.00,0.00,0.00,2400.00,'2021-12-09 10:06:01','',''),(2216509,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-09 10:06:01','',''),(2216527,'1','194','1012',460,'Retail Sale Id 1304471',90520.00,0.00,0.00,0.00,2480.00,'2021-12-09 10:07:04','',''),(2216528,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,155.00,0.00,'2021-12-09 10:07:04','',''),(2216547,'1','194','1012',460,'Retail Sale Id 1304482',35040.00,0.00,0.00,0.00,960.00,'2021-12-09 10:08:09','',''),(2216548,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-09 10:08:09','',''),(2216567,'1','194','1012',460,'Retail Sale Id 1304491',50808.00,0.00,0.00,0.00,1392.00,'2021-12-09 10:09:25','',''),(2216568,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,87.00,0.00,'2021-12-09 10:09:25','',''),(2216613,'1','194','1012',460,'Retail Sale Id 1304519',7040.00,0.00,0.00,0.00,792.00,'2021-12-09 10:13:17','',''),(2216614,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 10:13:17','',''),(2216671,'1','194','1012',460,'Retail Sale Id 1304552',800.00,0.00,0.00,0.00,90.00,'2021-12-09 10:17:48','',''),(2216672,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 10:17:48','',''),(2216691,'1','194','1012',460,'Retail Sale Id 1304560',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 10:18:54','',''),(2216692,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:18:54','',''),(2216765,'1','194','1012',460,'Retail Sale Id 1304600',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 10:23:30','',''),(2216766,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:23:30','',''),(2216849,'1','194','1012',460,'Retail Sale Id 1304646',2003.20,0.00,0.00,0.00,225.36,'2021-12-09 10:28:42','',''),(2216850,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 10:28:42','',''),(2216961,'1','194','1012',460,'Retail Sale Id 1304705',16000.00,0.00,0.00,0.00,1800.00,'2021-12-09 10:36:22','',''),(2216962,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 10:36:22','',''),(2217024,'1','194','1012',460,'Retail Sale Id 1304734',3001.60,0.00,0.00,0.00,337.68,'2021-12-09 10:41:18','',''),(2217025,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-09 10:41:18','',''),(2217512,'1','194','1012',460,'Retail Sale Id 1304982',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 11:14:16','',''),(2217513,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:14:16','',''),(2217530,'1','194','1012',460,'Retail Sale Id 1304990',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 11:16:03','',''),(2217531,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 11:16:03','',''),(2217849,'1','194','1012',460,'Retail Sale Id 1305142',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 11:33:17','',''),(2217850,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:33:17','',''),(2217878,'1','194','1012',460,'Retail Sale Id 1305156',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 11:35:26','',''),(2217879,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:35:26','',''),(2217913,'1','194','1012',460,'Retail Sale Id 1305174',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 11:37:55','',''),(2217914,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 11:37:55','',''),(2217988,'1','194','1012',460,'Retail Sale Id 1305209',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 11:43:51','',''),(2217989,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:43:51','',''),(2218852,'1','194','1012',460,'Retail Sale Id 1305662',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 12:38:29','',''),(2218853,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 12:38:29','',''),(2218888,'1','194','1012',460,'Retail Sale Id 1305676',58400.00,0.00,0.00,0.00,1600.00,'2021-12-09 12:40:29','',''),(2218889,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 12:40:29','',''),(2218942,'1','194','1012',460,'Retail Sale Id 1305695',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 12:43:04','',''),(2218943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 12:43:04','',''),(2218956,'1','194','1012',460,'Retail Sale Id 1305711',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 12:44:03','',''),(2218957,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:44:03','',''),(2219007,'1','194','1012',460,'Retail Sale Id 1305739',113296.00,0.00,0.00,0.00,3104.00,'2021-12-09 12:46:37','',''),(2219008,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,194.00,0.00,'2021-12-09 12:46:37','',''),(2219029,'1','194','1012',460,'Retail Sale Id 1305748',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 12:47:44','',''),(2219030,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 12:47:44','',''),(2219059,'1','194','1012',460,'Retail Sale Id 1305763',17856.00,0.00,0.00,0.00,2008.80,'2021-12-09 12:49:30','',''),(2219060,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,27.90,0.00,'2021-12-09 12:49:30','',''),(2219111,'1','194','1012',460,'Retail Sale Id 1305784',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 12:51:29','',''),(2219112,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 12:51:29','',''),(2219170,'1','194','1012',460,'Retail Sale Id 1305821',39128.00,0.00,0.00,0.00,1072.00,'2021-12-09 12:55:38','',''),(2219171,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,67.00,0.00,'2021-12-09 12:55:38','',''),(2219196,'1','194','1012',460,'Retail Sale Id 1305834',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 12:56:45','',''),(2219197,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 12:56:45','',''),(2219259,'1','194','1012',460,'Retail Sale Id 1305853',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 12:59:13','',''),(2219260,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 12:59:13','',''),(2219307,'1','194','1012',460,'Retail Sale Id 1305878',27200.00,0.00,0.00,0.00,3060.00,'2021-12-09 13:02:33','',''),(2219308,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,42.50,0.00,'2021-12-09 13:02:33','',''),(2219446,'1','194','1012',460,'Retail Sale Id 1305951',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 13:12:13','',''),(2219447,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 13:12:13','',''),(2219746,'1','194','1012',460,'Retail Sale Id 1306073',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 13:31:34','',''),(2219747,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:31:34','',''),(2219912,'1','194','1012',460,'Retail Sale Id 1306115',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 13:38:00','',''),(2219913,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:38:00','',''),(2219940,'1','194','1012',460,'Retail Sale Id 1306129',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 13:40:14','',''),(2219941,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 13:40:14','',''),(2219968,'1','194','1012',460,'Retail Sale Id 1306140',2560.00,0.00,0.00,0.00,288.00,'2021-12-09 13:41:09','',''),(2219969,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 13:41:09','',''),(2219978,'1','194','1012',460,'Retail Sale Id 1306146',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 13:42:10','',''),(2219979,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 13:42:10','',''),(2220010,'1','194','1012',460,'Retail Sale Id 1306163',23360.00,0.00,0.00,0.00,640.00,'2021-12-09 13:44:11','',''),(2220011,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 13:44:11','',''),(2220060,'1','194','1012',460,'Retail Sale Id 1306185',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 13:47:21','',''),(2220061,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:47:21','',''),(2220490,'1','194','1012',460,'Retail Sale Id 1306408',57232.00,0.00,0.00,0.00,1568.00,'2021-12-09 14:15:07','',''),(2220491,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-09 14:15:07','',''),(2220510,'1','194','1012',460,'Retail Sale Id 1306431',9600.00,0.00,0.00,0.00,1080.00,'2021-12-09 14:16:27','',''),(2220511,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-09 14:16:27','',''),(2220524,'1','194','1012',460,'Retail Sale Id 1306437',58400.00,0.00,0.00,0.00,1600.00,'2021-12-09 14:17:36','',''),(2220525,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-09 14:17:36','',''),(2220584,'1','194','1012',460,'Retail Sale Id 1306468',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 14:21:52','',''),(2220585,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:21:52','',''),(2220774,'1','194','1012',460,'Retail Sale Id 1306562',5760.00,0.00,0.00,0.00,648.00,'2021-12-09 14:30:38','',''),(2220775,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 14:30:38','',''),(2220794,'1','194','1012',460,'Retail Sale Id 1306568',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 14:31:38','',''),(2220795,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:31:38','',''),(2220881,'1','194','1012',460,'Retail Sale Id 1306601',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 14:35:11','',''),(2220882,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:35:11','',''),(2220931,'1','194','1012',460,'Retail Sale Id 1306619',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 14:36:36','',''),(2220932,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 14:36:36','',''),(2221056,'1','194','1012',460,'Retail Sale Id 1306690',33872.00,0.00,0.00,0.00,928.00,'2021-12-09 14:41:50','',''),(2221057,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,58.00,0.00,'2021-12-09 14:41:50','',''),(2221096,'1','194','1012',460,'Retail Sale Id 1306707',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 14:43:38','',''),(2221097,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 14:43:38','',''),(2221129,'1','194','1012',460,'Retail Sale Id 1306718',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 14:44:55','',''),(2221130,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 14:44:55','',''),(2222517,'1','194','1012',460,'Retail Sale Id 1307377',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 15:53:42','',''),(2222518,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:53:42','',''),(2222543,'1','194','1012',460,'Retail Sale Id 1307388',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 15:54:46','',''),(2222544,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:54:46','',''),(2222580,'1','194','1012',460,'Retail Sale Id 1307406',1497.60,0.00,0.00,0.00,168.48,'2021-12-09 15:56:09','',''),(2222581,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-09 15:56:09','',''),(2222642,'1','194','1012',460,'Retail Sale Id 1307435',39128.00,0.00,0.00,0.00,1072.00,'2021-12-09 15:59:48','',''),(2222643,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,67.00,0.00,'2021-12-09 15:59:48','',''),(2222666,'1','194','1012',460,'Retail Sale Id 1307447',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 16:01:13','',''),(2222667,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:01:13','',''),(2222753,'1','194','1012',460,'Retail Sale Id 1307489',320.00,0.00,0.00,0.00,-2520.00,'2021-12-09 16:05:42','',''),(2222754,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:05:42','',''),(2222775,'1','194','1012',460,'Retail Sale Id 1307503',800.00,0.00,0.00,0.00,-6300.00,'2021-12-09 16:06:54','',''),(2222776,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:06:54','',''),(2222795,'1','194','1012',460,'Retail Sale Id 1307511',5760.00,0.00,0.00,0.00,648.00,'2021-12-09 16:08:04','',''),(2222796,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 16:08:04','',''),(2222821,'1','194','1012',460,'Retail Sale Id 1307525',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 16:09:07','',''),(2222822,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:09:07','',''),(2222839,'1','194','1012',460,'Retail Sale Id 1307534',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 16:10:01','',''),(2222840,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:10:01','',''),(2222915,'1','194','1012',460,'Retail Sale Id 1307572',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 16:13:59','',''),(2222916,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:13:59','',''),(2222943,'1','194','1012',460,'Retail Sale Id 1307586',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 16:15:30','',''),(2222944,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:15:30','',''),(2223009,'1','194','1012',460,'Retail Sale Id 1307622',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 16:19:15','',''),(2223010,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:19:15','',''),(2223021,'1','194','1012',460,'Retail Sale Id 1307630',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 16:20:04','',''),(2223022,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:20:04','',''),(2223053,'1','194','1012',460,'Retail Sale Id 1307640',8000.00,0.00,0.00,0.00,900.00,'2021-12-09 16:21:14','',''),(2223054,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:21:14','',''),(2223071,'1','194','1012',460,'Retail Sale Id 1307648',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 16:22:34','',''),(2223072,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:22:34','',''),(2223089,'1','194','1012',460,'Retail Sale Id 1307657',1280.00,0.00,0.00,0.00,144.00,'2021-12-09 16:23:37','',''),(2223090,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:23:37','',''),(2223109,'1','194','1012',460,'Retail Sale Id 1307668',28616.00,0.00,0.00,0.00,784.00,'2021-12-09 16:25:16','',''),(2223110,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-09 16:25:16','',''),(2223160,'1','194','1012',460,'Retail Sale Id 1307685',6400.00,0.00,0.00,0.00,720.00,'2021-12-09 16:27:08','',''),(2223161,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-09 16:27:08','',''),(2223182,'1','194','1012',460,'Retail Sale Id 1307698',998.40,0.00,0.00,0.00,112.32,'2021-12-09 16:28:15','',''),(2223183,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-09 16:28:15','',''),(2223210,'1','194','1012',460,'Retail Sale Id 1307712',29200.00,0.00,0.00,0.00,800.00,'2021-12-09 16:29:35','',''),(2223211,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 16:29:35','',''),(2223226,'1','194','1012',460,'Retail Sale Id 1307718',800.00,0.00,0.00,0.00,90.00,'2021-12-09 16:30:43','',''),(2223227,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-09 16:30:43','',''),(2223236,'1','194','1012',460,'Retail Sale Id 1307724',2003.20,0.00,0.00,0.00,225.36,'2021-12-09 16:31:33','',''),(2223237,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-09 16:31:33','',''),(2223256,'1','194','1012',460,'Retail Sale Id 1307731',3840.00,0.00,0.00,0.00,432.00,'2021-12-09 16:32:31','',''),(2223257,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:32:31','',''),(2223280,'1','194','1012',460,'Retail Sale Id 1307745',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 16:33:46','',''),(2223281,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:33:46','',''),(2223300,'1','194','1012',460,'Retail Sale Id 1307753',85848.00,0.00,0.00,0.00,2352.00,'2021-12-09 16:34:46','',''),(2223301,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,147.00,0.00,'2021-12-09 16:34:46','',''),(2223328,'1','194','1012',460,'Retail Sale Id 1307766',29260.80,0.00,0.00,0.00,3291.84,'2021-12-09 16:36:16','',''),(2223329,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.72,0.00,'2021-12-09 16:36:16','',''),(2223447,'1','194','1012',460,'Retail Sale Id 1307810',3200.00,0.00,0.00,0.00,360.00,'2021-12-09 16:41:52','',''),(2223448,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:41:52','',''),(2223536,'1','194','1012',460,'Retail Sale Id 1307843',7040.00,0.00,0.00,0.00,792.00,'2021-12-09 16:46:32','',''),(2223537,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-09 16:46:32','',''),(2223590,'1','194','1012',460,'Retail Sale Id 1307866',1920.00,0.00,0.00,0.00,216.00,'2021-12-09 16:49:40','',''),(2223591,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:49:40','',''),(2223653,'1','194','1012',460,'Retail Sale Id 1307899',23360.00,0.00,0.00,0.00,640.00,'2021-12-09 16:54:03','',''),(2223654,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-09 16:54:03','',''),(2224138,'1','194','1012',460,'Retail Sale Id 1308136',13952.00,0.00,0.00,0.00,1569.60,'2021-12-09 17:36:17','',''),(2224139,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,21.80,0.00,'2021-12-09 17:36:17','',''),(2225405,'1','194','1012',460,'Retail Sale Id 1308504',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 06:35:28','',''),(2225406,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 06:35:28','',''),(2225436,'1','194','1012',460,'Retail Sale Id 1308515',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 06:36:43','',''),(2225437,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:36:43','',''),(2225452,'1','194','1012',460,'Retail Sale Id 1308522',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 06:38:07','',''),(2225453,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 06:38:07','',''),(2225483,'1','194','1012',460,'Retail Sale Id 1308530',32120.00,0.00,0.00,0.00,880.00,'2021-12-10 06:39:58','',''),(2225484,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 06:39:58','',''),(2225497,'1','194','1012',460,'Retail Sale Id 1308539',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 06:41:25','',''),(2225498,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 06:41:25','',''),(2225560,'1','194','1012',460,'Retail Sale Id 1308572',116800.00,0.00,0.00,0.00,3200.00,'2021-12-10 06:46:28','',''),(2225561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 06:46:29','',''),(2225600,'1','194','1012',460,'Retail Sale Id 1308593',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 06:49:16','',''),(2225601,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:49:16','',''),(2225636,'1','194','1012',460,'Retail Sale Id 1308611',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 06:51:00','',''),(2225637,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:51:00','',''),(2225743,'1','194','1012',460,'Retail Sale Id 1308666',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 06:57:53','',''),(2225744,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 06:57:53','',''),(2225788,'1','194','1012',460,'Retail Sale Id 1308687',5120.00,0.00,0.00,0.00,576.00,'2021-12-10 07:02:14','',''),(2225789,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 07:02:14','',''),(2225812,'1','194','1012',460,'Retail Sale Id 1308700',35040.00,0.00,0.00,0.00,960.00,'2021-12-10 07:03:24','',''),(2225813,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-10 07:03:24','',''),(2225844,'1','194','1012',460,'Retail Sale Id 1308716',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 07:05:35','',''),(2225845,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 07:05:35','',''),(2225868,'1','194','1012',460,'Retail Sale Id 1308729',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 07:07:14','',''),(2225869,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 07:07:14','',''),(2225886,'1','194','1012',460,'Retail Sale Id 1308737',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 07:08:40','',''),(2225887,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 07:08:40','',''),(2225912,'1','194','1012',460,'Retail Sale Id 1308750',2003.20,0.00,0.00,0.00,225.36,'2021-12-10 07:09:44','',''),(2225913,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-10 07:09:44','',''),(2225932,'1','194','1012',460,'Retail Sale Id 1308766',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 07:11:02','',''),(2225933,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 07:11:02','',''),(2225940,'1','194','1012',460,'Retail Sale Id 1308773',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 07:11:48','',''),(2225941,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 07:11:48','',''),(2225964,'1','194','1012',460,'Retail Sale Id 1308784',29200.00,0.00,0.00,0.00,800.00,'2021-12-10 07:13:20','',''),(2225965,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 07:13:20','',''),(2226210,'1','194','1012',460,'Retail Sale Id 1308907',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 07:26:20','',''),(2226211,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:26:20','',''),(2226285,'1','194','1012',460,'Retail Sale Id 1308941',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 07:29:55','',''),(2226286,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:29:55','',''),(2226409,'1','194','1012',460,'Retail Sale Id 1308995',4281.60,0.00,0.00,0.00,481.68,'2021-12-10 07:36:54','',''),(2226410,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.69,0.00,'2021-12-10 07:36:54','',''),(2226712,'1','194',NULL,460,'Purchased from AA RANO NIGERIA LIMITED',0.00,14188640.00,24980.00,0.00,0.00,'2021-12-10 07:52:35','',''),(2226775,'1','194',NULL,460,'Reception corrector for bridging 126834',0.00,0.00,0.00,24980.00,0.00,'2021-12-10 07:56:59','',''),(2226776,'1','194','1012',460,'Received from bridging 126834',0.00,0.00,24980.00,0.00,0.00,'2021-12-10 07:56:59','',''),(2226947,'1','194','1012',460,'Retail Sale Id 1309220',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:03:35','',''),(2226948,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:03:35','',''),(2226970,'1','194','1012',460,'Retail Sale Id 1309233',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 08:04:39','',''),(2226971,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 08:04:39','',''),(2227015,'1','194','1012',460,'Retail Sale Id 1309253',2003.20,0.00,0.00,0.00,225.36,'2021-12-10 08:06:30','',''),(2227016,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-10 08:06:30','',''),(2227044,'1','194','1012',460,'Retail Sale Id 1309264',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 08:07:43','',''),(2227045,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:07:43','',''),(2227128,'1','194','1012',460,'Retail Sale Id 1309294',31790.00,0.00,0.00,0.00,550.00,'2021-12-10 08:12:25','',''),(2227129,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 08:12:25','',''),(2227154,'1','194','1012',460,'Retail Sale Id 1309306',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:13:51','',''),(2227155,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:13:51','',''),(2227183,'1','194','1012',460,'Retail Sale Id 1309316',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 08:14:41','',''),(2227184,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:14:41','',''),(2227203,'1','194','1012',460,'Retail Sale Id 1309325',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 08:15:56','',''),(2227204,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:15:56','',''),(2227241,'1','194','1012',460,'Retail Sale Id 1309341',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 08:18:04','',''),(2227242,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:18:04','',''),(2227267,'1','194','1012',460,'Retail Sale Id 1309366',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 08:19:27','',''),(2227268,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 08:19:27','',''),(2227283,'1','194','1012',460,'Retail Sale Id 1309371',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 08:20:14','',''),(2227284,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:20:14','',''),(2227489,'1','194','1012',460,'Retail Sale Id 1309449',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 08:29:09','',''),(2227490,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:29:09','',''),(2227643,'1','194','1012',460,'Retail Sale Id 1309535',57800.00,0.00,0.00,0.00,1000.00,'2021-12-10 08:36:56','',''),(2227644,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 08:36:56','',''),(2227716,'1','194','1012',460,'Retail Sale Id 1309569',5600.00,0.00,0.00,0.00,630.00,'2021-12-10 08:41:02','',''),(2227717,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.75,0.00,'2021-12-10 08:41:02','',''),(2227762,'1','194','1012',460,'Retail Sale Id 1309589',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 08:43:31','',''),(2227763,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:43:31','',''),(2227918,'1','194','1012',460,'Retail Sale Id 1309653',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 08:48:49','',''),(2227919,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 08:48:49','',''),(2227942,'1','194','1012',460,'Retail Sale Id 1309667',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 08:50:19','',''),(2227943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 08:50:19','',''),(2228166,'1','194','1012',460,'Retail Sale Id 1309775',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 08:59:59','',''),(2228167,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:59:59','',''),(2228312,'1','194','1012',460,'Retail Sale Id 1309846',9920.00,0.00,0.00,0.00,1116.00,'2021-12-10 09:07:14','',''),(2228313,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-10 09:07:14','',''),(2228332,'1','194','1012',460,'Retail Sale Id 1309857',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 09:08:32','',''),(2228333,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:08:32','',''),(2228354,'1','194','1012',460,'Retail Sale Id 1309867',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 09:09:44','',''),(2228355,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 09:09:44','',''),(2228385,'1','194','1012',460,'Retail Sale Id 1309875',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 09:11:13','',''),(2228386,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 09:11:13','',''),(2228483,'1','194','1012',460,'Retail Sale Id 1309924',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 09:16:29','',''),(2228484,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:16:29','',''),(2228634,'1','194','1012',460,'Retail Sale Id 1309995',34102.00,0.00,0.00,0.00,590.00,'2021-12-10 09:27:09','',''),(2228635,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,59.00,0.00,'2021-12-10 09:27:09','',''),(2228678,'1','194','1012',460,'Retail Sale Id 1310017',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 09:29:36','',''),(2228679,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:29:36','',''),(2228732,'1','194','1012',460,'Retail Sale Id 1310047',5120.00,0.00,0.00,0.00,576.00,'2021-12-10 09:33:18','',''),(2228733,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 09:33:18','',''),(2228825,'1','194','1012',460,'Retail Sale Id 1310084',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 09:37:45','',''),(2228826,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:37:45','',''),(2229097,'1','194','1012',460,'Retail Sale Id 1310211',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 09:53:07','',''),(2229098,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 09:53:07','',''),(2229143,'1','194','1012',460,'Retail Sale Id 1310245',150280.00,0.00,0.00,0.00,2600.00,'2021-12-10 09:55:55','',''),(2229144,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,260.00,0.00,'2021-12-10 09:55:55','',''),(2229178,'1','194','1012',460,'Retail Sale Id 1310258',7680.00,0.00,0.00,0.00,864.00,'2021-12-10 09:58:27','',''),(2229179,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-10 09:58:27','',''),(2229202,'1','194','1012',460,'Retail Sale Id 1310273',16000.00,0.00,0.00,0.00,1800.00,'2021-12-10 09:59:46','',''),(2229203,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 09:59:46','',''),(2229233,'1','194','1012',460,'Retail Sale Id 1310289',7040.00,0.00,0.00,0.00,792.00,'2021-12-10 10:01:37','',''),(2229234,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 10:01:37','',''),(2229270,'1','194','1012',460,'Retail Sale Id 1310303',998.40,0.00,0.00,0.00,112.32,'2021-12-10 10:03:51','',''),(2229271,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-10 10:03:51','',''),(2229961,'1','194','1012',460,'Retail Sale Id 1310620',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 10:42:46','',''),(2229962,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:42:46','',''),(2229995,'1','194','1012',460,'Retail Sale Id 1310635',17340.00,0.00,0.00,0.00,300.00,'2021-12-10 10:44:46','',''),(2229996,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-10 10:44:46','',''),(2230021,'1','194','1012',460,'Retail Sale Id 1310647',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 10:45:47','',''),(2230022,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:45:47','',''),(2230037,'1','194','1012',460,'Retail Sale Id 1310654',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 10:46:45','',''),(2230038,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:46:45','',''),(2230097,'1','194','1012',460,'Retail Sale Id 1310676',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 10:49:32','',''),(2230098,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:49:32','',''),(2230293,'1','194','1012',460,'Retail Sale Id 1310768',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 11:00:41','',''),(2230294,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 11:00:41','',''),(2230635,'1','194','1012',460,'Retail Sale Id 1310906',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 11:19:15','',''),(2230636,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:19:15','',''),(2230797,'1','194','1012',460,'Retail Sale Id 1310974',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 11:30:45','',''),(2230798,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 11:30:45','',''),(2230846,'1','194','1012',460,'Retail Sale Id 1311005',6848.00,0.00,0.00,0.00,770.40,'2021-12-10 11:33:24','',''),(2230847,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.70,0.00,'2021-12-10 11:33:24','',''),(2230883,'1','194','1012',460,'Retail Sale Id 1311023',3801.60,0.00,0.00,0.00,427.68,'2021-12-10 11:35:29','',''),(2230884,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.94,0.00,'2021-12-10 11:35:29','',''),(2230925,'1','194','1012',460,'Retail Sale Id 1311043',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 11:38:18','',''),(2230926,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:38:19','',''),(2230945,'1','194','1012',460,'Retail Sale Id 1311054',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 11:39:43','',''),(2230946,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 11:39:43','',''),(2230983,'1','194','1012',460,'Retail Sale Id 1311077',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 11:43:41','',''),(2230984,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 11:43:41','',''),(2231003,'1','194','1012',460,'Retail Sale Id 1311088',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 11:45:08','',''),(2231004,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:45:08','',''),(2231029,'1','194','1012',460,'Retail Sale Id 1311102',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 11:47:24','',''),(2231030,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:47:24','',''),(2231047,'1','194','1012',460,'Retail Sale Id 1311113',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 11:48:49','',''),(2231048,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:48:49','',''),(2231232,'1','194','1012',460,'Retail Sale Id 1311207',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 12:02:23','',''),(2231233,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:02:23','',''),(2231318,'1','194','1012',460,'Retail Sale Id 1311237',57800.00,0.00,0.00,0.00,1000.00,'2021-12-10 12:07:48','',''),(2231319,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 12:07:48','',''),(2231369,'1','194','1012',460,'Retail Sale Id 1311265',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 12:11:13','',''),(2231370,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:11:13','',''),(2231405,'1','194','1012',460,'Retail Sale Id 1311287',202300.00,0.00,0.00,0.00,3500.00,'2021-12-10 12:15:07','',''),(2231406,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,350.00,0.00,'2021-12-10 12:15:07','',''),(2231425,'1','194','1012',460,'Retail Sale Id 1311296',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 12:16:18','',''),(2231426,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:16:18','',''),(2231445,'1','194','1012',460,'Retail Sale Id 1311310',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 12:17:56','',''),(2231446,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 12:17:56','',''),(2231479,'1','194','1012',460,'Retail Sale Id 1311330',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 12:21:32','',''),(2231480,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:21:32','',''),(2231501,'1','194','1012',460,'Retail Sale Id 1311342',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 12:23:15','',''),(2231502,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:23:15','',''),(2231658,'1','194','1012',460,'Retail Sale Id 1311437',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 12:38:59','',''),(2231659,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:38:59','',''),(2231672,'1','194','1012',460,'Retail Sale Id 1311445',640.00,0.00,0.00,0.00,72.00,'2021-12-10 12:40:23','',''),(2231673,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 12:40:23','',''),(2232487,'1','194','1012',460,'Retail Sale Id 1311828',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 13:33:46','',''),(2232488,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:33:46','',''),(2232521,'1','194','1012',460,'Retail Sale Id 1311848',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 13:35:10','',''),(2232522,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 13:35:10','',''),(2232550,'1','194','1012',460,'Retail Sale Id 1311861',57800.00,0.00,0.00,0.00,1000.00,'2021-12-10 13:36:43','',''),(2232551,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-10 13:36:43','',''),(2232669,'1','194','1012',460,'Retail Sale Id 1311902',20230.00,0.00,0.00,0.00,350.00,'2021-12-10 13:41:41','',''),(2232670,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-10 13:41:41','',''),(2232697,'1','194','1012',460,'Retail Sale Id 1311922',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 13:43:31','',''),(2232698,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 13:43:31','',''),(2232725,'1','194','1012',460,'Retail Sale Id 1311929',56644.00,0.00,0.00,0.00,980.00,'2021-12-10 13:44:24','',''),(2232726,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-10 13:44:24','',''),(2232791,'1','194','1012',460,'Retail Sale Id 1311958',640.00,0.00,0.00,0.00,72.00,'2021-12-10 13:47:10','',''),(2232792,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 13:47:10','',''),(2232927,'1','194','1012',460,'Retail Sale Id 1312015',1299.20,0.00,0.00,0.00,146.16,'2021-12-10 13:54:07','',''),(2232928,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-10 13:54:07','',''),(2233011,'1','194','1012',460,'Retail Sale Id 1312057',40460.00,0.00,0.00,0.00,700.00,'2021-12-10 13:58:11','',''),(2233012,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-10 13:58:11','',''),(2233144,'1','194','1012',460,'Retail Sale Id 1312088',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 14:02:39','',''),(2233145,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:02:39','',''),(2233189,'1','194','1012',460,'Retail Sale Id 1312111',13440.00,0.00,0.00,0.00,1512.00,'2021-12-10 14:04:04','',''),(2233190,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-10 14:04:04','',''),(2233197,'1','194','1012',460,'Retail Sale Id 1312119',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 14:04:54','',''),(2233198,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 14:04:54','',''),(2233209,'1','194','1012',460,'Retail Sale Id 1312124',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 14:05:49','',''),(2233210,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 14:05:49','',''),(2233237,'1','194','1012',460,'Return of Retail Sale Id 1312111',0.00,13440.00,21.00,0.00,-1512.00,'2021-12-10 14:07:32','',''),(2233251,'1','194','1012',460,'Retail Sale Id 1312140',7040.00,0.00,0.00,0.00,792.00,'2021-12-10 14:08:08','',''),(2233252,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 14:08:08','',''),(2233269,'1','194','1012',460,'Retail Sale Id 1312148',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 14:09:45','',''),(2233270,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:09:45','',''),(2233365,'1','194','1012',460,'Retail Sale Id 1312201',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 14:15:45','',''),(2233366,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:15:45','',''),(2233457,'1','194','1012',460,'Retail Sale Id 1312244',26010.00,0.00,0.00,0.00,450.00,'2021-12-10 14:20:23','',''),(2233458,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-10 14:20:23','',''),(2233765,'1','194','1012',460,'Retail Sale Id 1312369',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 14:32:57','',''),(2233766,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 14:32:57','',''),(2233845,'1','194','1012',460,'Retail Sale Id 1312407',640.00,0.00,0.00,0.00,72.00,'2021-12-10 14:36:32','',''),(2233846,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 14:36:32','',''),(2233892,'1','194','1012',460,'Retail Sale Id 1312424',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 14:38:15','',''),(2233893,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:38:15','',''),(2234009,'1','194','1012',460,'Retail Sale Id 1312471',2003.20,0.00,0.00,0.00,225.36,'2021-12-10 14:42:42','',''),(2234010,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-10 14:42:42','',''),(2234165,'1','194','1012',460,'Retail Sale Id 1312543',5120.00,0.00,0.00,0.00,576.00,'2021-12-10 14:48:38','',''),(2234166,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 14:48:38','',''),(2234221,'1','194','1012',460,'Retail Sale Id 1312571',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 14:50:54','',''),(2234222,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:50:54','',''),(2234272,'1','194','1012',460,'Retail Sale Id 1312592',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 14:53:45','',''),(2234273,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 14:53:45','',''),(2234314,'1','194','1012',460,'Retail Sale Id 1312611',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 14:55:29','',''),(2234315,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:55:29','',''),(2234430,'1','194','1012',460,'Retail Sale Id 1312673',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 15:02:59','',''),(2234431,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:02:59','',''),(2234560,'1','194','1012',460,'Retail Sale Id 1312736',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 15:09:45','',''),(2234561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:09:45','',''),(2234583,'1','194','1012',460,'Retail Sale Id 1312743',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 15:10:41','',''),(2234584,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:10:41','',''),(2234607,'1','194','1012',460,'Retail Sale Id 1312754',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 15:11:55','',''),(2234608,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:11:55','',''),(2234649,'1','194','1012',460,'Retail Sale Id 1312770',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 15:13:14','',''),(2234650,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:13:14','',''),(2234675,'1','194','1012',460,'Retail Sale Id 1312786',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 15:14:16','',''),(2234676,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:14:16','',''),(2234705,'1','194','1012',460,'Retail Sale Id 1312800',4480.00,0.00,0.00,0.00,504.00,'2021-12-10 15:15:33','',''),(2234706,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 15:15:33','',''),(2234791,'1','194','1012',460,'Retail Sale Id 1312824',115600.00,0.00,0.00,0.00,2000.00,'2021-12-10 15:19:16','',''),(2234792,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,200.00,0.00,'2021-12-10 15:19:16','',''),(2234942,'1','194','1012',460,'Retail Sale Id 1312906',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 15:25:02','',''),(2234943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 15:25:02','',''),(2234984,'1','194','1012',460,'Retail Sale Id 1312954',1203.20,0.00,0.00,0.00,135.36,'2021-12-10 15:26:34','',''),(2234985,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-10 15:26:34','',''),(2235032,'1','194','1012',460,'Retail Sale Id 1312970',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 15:27:47','',''),(2235033,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:27:47','',''),(2235081,'1','194','1012',460,'Retail Sale Id 1312978',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 15:28:52','',''),(2235082,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:28:52','',''),(2235101,'1','194','1012',460,'Retail Sale Id 1312992',1280.00,0.00,0.00,0.00,144.00,'2021-12-10 15:29:50','',''),(2235102,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 15:29:50','',''),(2235117,'1','194','1012',460,'Retail Sale Id 1312998',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 15:30:42','',''),(2235118,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:30:42','',''),(2235148,'1','194','1012',460,'Retail Sale Id 1313008',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 15:32:18','',''),(2235149,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:32:18','',''),(2235191,'1','194','1012',460,'Retail Sale Id 1313038',4499.20,0.00,0.00,0.00,506.16,'2021-12-10 15:33:55','',''),(2235192,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.03,0.00,'2021-12-10 15:33:55','',''),(2235311,'1','194','1012',460,'Retail Sale Id 1313093',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 15:39:29','',''),(2235312,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:39:29','',''),(2235349,'1','194','1012',460,'Retail Sale Id 1313106',1900.80,0.00,0.00,0.00,213.84,'2021-12-10 15:40:53','',''),(2235350,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.97,0.00,'2021-12-10 15:40:53','',''),(2235381,'1','194','1012',460,'Retail Sale Id 1313121',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 15:42:08','',''),(2235382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 15:42:08','',''),(2235771,'1','194','1012',460,'Retail Sale Id 1313341',34044.20,0.00,0.00,0.00,589.00,'2021-12-10 16:00:11','',''),(2235772,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,58.90,0.00,'2021-12-10 16:00:11','',''),(2235857,'1','194','1012',460,'Retail Sale Id 1313369',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 16:05:08','',''),(2235858,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:05:08','',''),(2236013,'1','194','1012',460,'Retail Sale Id 1313444',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 16:11:10','',''),(2236014,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 16:11:10','',''),(2236067,'1','194','1012',460,'Retail Sale Id 1313482',28900.00,0.00,0.00,0.00,500.00,'2021-12-10 16:14:06','',''),(2236068,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 16:14:06','',''),(2236093,'1','194','1012',460,'Retail Sale Id 1313493',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 16:15:16','',''),(2236094,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:15:16','',''),(2236154,'1','194','1012',460,'Retail Sale Id 1313529',3001.60,0.00,0.00,0.00,337.68,'2021-12-10 16:18:31','',''),(2236155,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.69,0.00,'2021-12-10 16:18:31','',''),(2236233,'1','194','1012',460,'Retail Sale Id 1313571',697.60,0.00,0.00,0.00,78.48,'2021-12-10 16:21:19','',''),(2236234,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.09,0.00,'2021-12-10 16:21:19','',''),(2236298,'1','194','1012',460,'Retail Sale Id 1313610',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 16:24:03','',''),(2236299,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:24:03','',''),(2236330,'1','194','1012',460,'Retail Sale Id 1313623',43928.00,0.00,0.00,0.00,760.00,'2021-12-10 16:25:48','',''),(2236331,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,76.00,0.00,'2021-12-10 16:25:48','',''),(2236373,'1','194','1012',460,'Retail Sale Id 1313646',2003.20,0.00,0.00,0.00,225.36,'2021-12-10 16:27:26','',''),(2236374,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-10 16:27:26','',''),(2236429,'1','194','1012',460,'Retail Sale Id 1313668',2560.00,0.00,0.00,0.00,288.00,'2021-12-10 16:29:49','',''),(2236430,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:29:49','',''),(2236443,'1','194','1012',460,'Retail Sale Id 1313675',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 16:30:37','',''),(2236444,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:30:37','',''),(2236473,'1','194','1012',460,'Retail Sale Id 1313688',27166.00,0.00,0.00,0.00,470.00,'2021-12-10 16:31:48','',''),(2236474,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,47.00,0.00,'2021-12-10 16:31:48','',''),(2236505,'1','194','1012',460,'Retail Sale Id 1313701',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 16:33:20','',''),(2236506,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:33:20','',''),(2236536,'1','194','1012',460,'Retail Sale Id 1313719',31790.00,0.00,0.00,0.00,550.00,'2021-12-10 16:35:05','',''),(2236537,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-10 16:35:05','',''),(2236692,'1','194','1012',460,'Retail Sale Id 1313782',35836.00,0.00,0.00,0.00,620.00,'2021-12-10 16:42:40','',''),(2236693,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,62.00,0.00,'2021-12-10 16:42:40','',''),(2236724,'1','194','1012',460,'Retail Sale Id 1313800',4998.40,0.00,0.00,0.00,562.32,'2021-12-10 16:44:35','',''),(2236725,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-10 16:44:35','',''),(2236740,'1','194','1012',460,'Retail Sale Id 1313808',3200.00,0.00,0.00,0.00,360.00,'2021-12-10 16:45:41','',''),(2236741,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 16:45:41','',''),(2236830,'1','194','1012',460,'Retail Sale Id 1313855',4480.00,0.00,0.00,0.00,504.00,'2021-12-10 16:51:24','',''),(2236831,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 16:51:24','',''),(2236858,'1','194','1012',460,'Retail Sale Id 1313873',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 16:53:14','',''),(2236859,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:53:14','',''),(2236959,'1','194','1012',460,'Retail Sale Id 1313927',1920.00,0.00,0.00,0.00,216.00,'2021-12-10 16:59:38','',''),(2236960,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:59:38','',''),(2236998,'1','194','1012',460,'Retail Sale Id 1313938',6400.00,0.00,0.00,0.00,720.00,'2021-12-10 17:01:03','',''),(2236999,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 17:01:03','',''),(2237094,'1','194','1012',460,'Retail Sale Id 1313985',8000.00,0.00,0.00,0.00,900.00,'2021-12-10 17:07:23','',''),(2237095,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:07:23','',''),(2237182,'1','194','1012',460,'Retail Sale Id 1314029',3840.00,0.00,0.00,0.00,432.00,'2021-12-10 17:15:26','',''),(2237183,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 17:15:26','',''),(2238753,'1','194','1012',460,'Retail Sale Id 1314526',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 06:29:09','',''),(2238754,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 06:29:09','',''),(2238896,'1','194','1012',460,'Retail Sale Id 1314616',9984.00,0.00,0.00,0.00,1123.20,'2021-12-11 06:38:12','',''),(2238897,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.60,0.00,'2021-12-11 06:38:12','',''),(2238918,'1','194','1012',460,'Retail Sale Id 1314631',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 06:40:15','',''),(2238919,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:40:15','',''),(2238958,'1','194','1012',460,'Retail Sale Id 1314654',86700.00,0.00,0.00,0.00,1500.00,'2021-12-11 06:43:38','',''),(2238959,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-11 06:43:38','',''),(2238984,'1','194','1012',460,'Retail Sale Id 1314667',10560.00,0.00,0.00,0.00,1188.00,'2021-12-11 06:45:40','',''),(2238985,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-11 06:45:40','',''),(2239084,'1','194','1012',460,'Retail Sale Id 1314718',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 06:52:46','',''),(2239085,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 06:52:46','',''),(2241848,'1','194','1012',460,'Retail Sale Id 1316023',13440.00,0.00,0.00,0.00,1512.00,'2021-12-11 09:06:53','',''),(2241849,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-11 09:06:53','',''),(2242571,'1','194','1012',460,'Retail Sale Id 1316306',107508.00,0.00,0.00,0.00,1860.00,'2021-12-11 09:41:33','',''),(2242572,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,186.00,0.00,'2021-12-11 09:41:33','',''),(2243788,'1','194','1012',460,'Retail Sale Id 1316967',5120.00,0.00,0.00,0.00,576.00,'2021-12-11 10:40:56','',''),(2243789,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 10:40:56','',''),(2243810,'1','194','1012',460,'Retail Sale Id 1316984',9600.00,0.00,0.00,0.00,1080.00,'2021-12-11 10:42:19','',''),(2243811,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-11 10:42:19','',''),(2243846,'1','194','1012',460,'Retail Sale Id 1317001',79764.00,0.00,0.00,0.00,1380.00,'2021-12-11 10:43:57','',''),(2243847,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,138.00,0.00,'2021-12-11 10:43:57','',''),(2243886,'1','194','1012',460,'Retail Sale Id 1317021',10880.00,0.00,0.00,0.00,1224.00,'2021-12-11 10:45:56','',''),(2243887,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-11 10:45:56','',''),(2243916,'1','194','1012',460,'Retail Sale Id 1317033',16640.00,0.00,0.00,0.00,1872.00,'2021-12-11 10:47:38','',''),(2243917,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,26.00,0.00,'2021-12-11 10:47:38','',''),(2243938,'1','194','1012',460,'Retail Sale Id 1317050',82076.00,0.00,0.00,0.00,1420.00,'2021-12-11 10:48:58','',''),(2243939,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,142.00,0.00,'2021-12-11 10:48:58','',''),(2243960,'1','194','1012',460,'Retail Sale Id 1317061',10240.00,0.00,0.00,0.00,1152.00,'2021-12-11 10:50:41','',''),(2243961,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-11 10:50:41','',''),(2243986,'1','194','1012',460,'Retail Sale Id 1317072',95370.00,0.00,0.00,0.00,1650.00,'2021-12-11 10:52:10','',''),(2243987,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-11 10:52:10','',''),(2244032,'1','194','1012',460,'Retail Sale Id 1317083',16320.00,0.00,0.00,0.00,1836.00,'2021-12-11 10:55:06','',''),(2244033,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.50,0.00,'2021-12-11 10:55:06','',''),(2244096,'1','194','1012',460,'Retail Sale Id 1317126',95370.00,0.00,0.00,0.00,1650.00,'2021-12-11 10:58:21','',''),(2244097,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,165.00,0.00,'2021-12-11 10:58:21','',''),(2244166,'1','194','1012',460,'Retail Sale Id 1317149',10707.20,0.00,0.00,0.00,1204.56,'2021-12-11 11:00:48','',''),(2244167,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,16.73,0.00,'2021-12-11 11:00:48','',''),(2244225,'1','194','1012',460,'Retail Sale Id 1317172',92480.00,0.00,0.00,0.00,1600.00,'2021-12-11 11:03:26','',''),(2244226,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-11 11:03:26','',''),(2244253,'1','194','1012',460,'Retail Sale Id 1317189',16998.40,0.00,0.00,0.00,1912.32,'2021-12-11 11:04:43','',''),(2244254,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,26.56,0.00,'2021-12-11 11:04:43','',''),(2244289,'1','194','1012',460,'Retail Sale Id 1317208',119068.00,0.00,0.00,0.00,2060.00,'2021-12-11 11:06:41','',''),(2244290,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,206.00,0.00,'2021-12-11 11:06:41','',''),(2244337,'1','194','1012',460,'Retail Sale Id 1317224',8320.00,0.00,0.00,0.00,936.00,'2021-12-11 11:09:06','',''),(2244338,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-11 11:09:06','',''),(2244449,'1','194','1012',460,'Retail Sale Id 1317282',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 11:15:02','',''),(2244450,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:15:02','',''),(2244476,'1','194','1012',460,'Retail Sale Id 1317296',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 11:16:15','',''),(2244477,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:16:15','',''),(2244499,'1','194','1012',460,'Retail Sale Id 1317309',1299.20,0.00,0.00,0.00,146.16,'2021-12-11 11:17:40','',''),(2244500,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-11 11:17:40','',''),(2244609,'1','194','1012',460,'Retail Sale Id 1317358',29440.00,0.00,0.00,0.00,3312.00,'2021-12-11 11:22:59','',''),(2244610,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-11 11:22:59','',''),(2244656,'1','194','1012',460,'Retail Sale Id 1317385',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 11:24:57','',''),(2244657,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 11:24:57','',''),(2244888,'1','194','1012',460,'Retail Sale Id 1317507',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 11:38:36','',''),(2244889,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:38:36','',''),(2244961,'1','194','1012',460,'Retail Sale Id 1317546',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 11:42:28','',''),(2244962,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 11:42:29','',''),(2245138,'1','194','1012',460,'Retail Sale Id 1317631',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 11:53:47','',''),(2245139,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:53:47','',''),(2245174,'1','194','1012',460,'Retail Sale Id 1317657',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 11:55:47','',''),(2245175,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:55:47','',''),(2245327,'1','194','1012',460,'Retail Sale Id 1317730',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 12:05:56','',''),(2245328,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:05:56','',''),(2245399,'1','194','1012',460,'Retail Sale Id 1317815',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 12:11:17','',''),(2245400,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 12:11:17','',''),(2245556,'1','194','1012',460,'Retail Sale Id 1317854',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 12:20:03','',''),(2245557,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 12:20:03','',''),(2245643,'1','194','1012',460,'Retail Sale Id 1317939',7040.00,0.00,0.00,0.00,792.00,'2021-12-11 12:24:31','',''),(2245644,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-11 12:24:31','',''),(2246844,'1','194','1012',460,'Retail Sale Id 1318511',29120.00,0.00,0.00,0.00,3276.00,'2021-12-11 13:46:17','',''),(2246845,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.50,0.00,'2021-12-11 13:46:17','',''),(2246861,'1','194','1012',460,'Retail Sale Id 1318522',22848.00,0.00,0.00,0.00,2570.40,'2021-12-11 13:48:07','',''),(2246862,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,35.70,0.00,'2021-12-11 13:48:07','',''),(2246890,'1','194','1012',460,'Retail Sale Id 1318534',132362.00,0.00,0.00,0.00,2290.00,'2021-12-11 13:49:46','',''),(2246891,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,229.00,0.00,'2021-12-11 13:49:46','',''),(2246937,'1','194','1012',460,'Retail Sale Id 1318552',36819.20,0.00,0.00,0.00,4142.16,'2021-12-11 13:51:57','',''),(2246938,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,57.53,0.00,'2021-12-11 13:51:57','',''),(2246960,'1','194','1012',460,'Retail Sale Id 1318562',268192.00,0.00,0.00,0.00,4640.00,'2021-12-11 13:53:54','',''),(2246961,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,464.00,0.00,'2021-12-11 13:53:54','',''),(2246990,'1','194','1012',460,'Retail Sale Id 1318587',51520.00,0.00,0.00,0.00,5796.00,'2021-12-11 13:55:34','',''),(2246991,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,80.50,0.00,'2021-12-11 13:55:34','',''),(2247014,'1','194','1012',460,'Retail Sale Id 1318597',113288.00,0.00,0.00,0.00,1960.00,'2021-12-11 13:56:45','',''),(2247015,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,196.00,0.00,'2021-12-11 13:56:45','',''),(2247044,'1','194','1012',460,'Retail Sale Id 1318609',35731.20,0.00,0.00,0.00,4019.76,'2021-12-11 13:58:41','',''),(2247045,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.83,0.00,'2021-12-11 13:58:41','',''),(2247063,'1','194','1012',460,'Retail Sale Id 1318624',190162.00,0.00,0.00,0.00,3290.00,'2021-12-11 14:00:10','',''),(2247064,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,329.00,0.00,'2021-12-11 14:00:10','',''),(2247123,'1','194','1012',460,'Retail Sale Id 1318653',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 14:04:08','',''),(2247124,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:04:08','',''),(2247137,'1','194','1012',460,'Retail Sale Id 1318661',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 14:05:07','',''),(2247138,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:05:07','',''),(2247154,'1','194','1012',460,'Retail Sale Id 1318670',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 14:06:11','',''),(2247155,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:06:11','',''),(2247232,'1','194','1012',460,'Retail Sale Id 1318695',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 14:09:38','',''),(2247233,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:09:38','',''),(2247254,'1','194','1012',460,'Retail Sale Id 1318708',14400.00,0.00,0.00,0.00,1620.00,'2021-12-11 14:11:14','',''),(2247255,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-11 14:11:14','',''),(2247282,'1','194','1012',460,'Retail Sale Id 1318729',4480.00,0.00,0.00,0.00,504.00,'2021-12-11 14:12:20','',''),(2247283,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 14:12:20','',''),(2247412,'1','194','1012',460,'Retail Sale Id 1318796',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 14:21:46','',''),(2247413,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:21:46','',''),(2247435,'1','194','1012',460,'Retail Sale Id 1318806',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 14:23:02','',''),(2247436,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:23:02','',''),(2247464,'1','194','1012',460,'Retail Sale Id 1318817',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 14:24:41','',''),(2247465,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:24:41','',''),(2247510,'1','194','1012',460,'Retail Sale Id 1318834',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 14:27:27','',''),(2247511,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:27:27','',''),(2247560,'1','194','1012',460,'Retail Sale Id 1318862',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 14:31:47','',''),(2247561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:31:47','',''),(2247636,'1','194','1012',460,'Retail Sale Id 1318916',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 14:36:49','',''),(2247637,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 14:36:49','',''),(2247722,'1','194','1012',460,'Retail Sale Id 1318964',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 14:42:05','',''),(2247723,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:42:05','',''),(2247730,'1','194','1012',460,'Retail Sale Id 1318968',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 14:42:49','',''),(2247731,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:42:49','',''),(2247764,'1','194','1012',460,'Retail Sale Id 1318983',57800.00,0.00,0.00,0.00,1000.00,'2021-12-11 14:44:27','',''),(2247765,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 14:44:27','',''),(2247784,'1','194','1012',460,'Retail Sale Id 1318993',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 14:45:35','',''),(2247785,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:45:35','',''),(2247802,'1','194','1012',460,'Retail Sale Id 1319004',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 14:47:02','',''),(2247803,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 14:47:02','',''),(2247828,'1','194','1012',460,'Retail Sale Id 1319016',6400.00,0.00,0.00,0.00,720.00,'2021-12-11 14:48:17','',''),(2247829,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 14:48:17','',''),(2247842,'1','194','1012',460,'Retail Sale Id 1319026',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 14:49:04','',''),(2247843,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:49:04','',''),(2247858,'1','194','1012',460,'Retail Sale Id 1319031',4000.00,0.00,0.00,0.00,450.00,'2021-12-11 14:49:52','',''),(2247859,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-11 14:49:52','',''),(2247924,'1','194','1012',460,'Retail Sale Id 1319063',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 14:53:54','',''),(2247925,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:53:54','',''),(2247966,'1','194','1012',460,'Retail Sale Id 1319082',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 14:56:02','',''),(2247967,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:56:02','',''),(2248041,'1','194','1012',460,'Retail Sale Id 1319129',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 14:59:50','',''),(2248042,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 14:59:50','',''),(2248113,'1','194','1012',460,'Retail Sale Id 1319164',43350.00,0.00,0.00,0.00,750.00,'2021-12-11 15:05:39','',''),(2248114,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,75.00,0.00,'2021-12-11 15:05:39','',''),(2248206,'1','194','1012',460,'Retail Sale Id 1319185',5760.00,0.00,0.00,0.00,648.00,'2021-12-11 15:08:04','',''),(2248207,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-11 15:08:04','',''),(2248392,'1','194','1012',460,'Retail Sale Id 1319268',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 15:16:28','',''),(2248393,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:16:28','',''),(2248458,'1','194','1012',460,'Retail Sale Id 1319303',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 15:20:01','',''),(2248459,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 15:20:01','',''),(2248474,'1','194','1012',460,'Retail Sale Id 1319309',26010.00,0.00,0.00,0.00,450.00,'2021-12-11 15:21:17','',''),(2248475,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-11 15:21:17','',''),(2248536,'1','194','1012',460,'Retail Sale Id 1319346',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 15:24:22','',''),(2248537,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:24:22','',''),(2248584,'1','194','1012',460,'Retail Sale Id 1319375',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 15:27:09','',''),(2248585,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 15:27:09','',''),(2248630,'1','194','1012',460,'Retail Sale Id 1319399',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 15:30:02','',''),(2248631,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:30:02','',''),(2248648,'1','194','1012',460,'Retail Sale Id 1319410',5120.00,0.00,0.00,0.00,576.00,'2021-12-11 15:30:51','',''),(2248649,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 15:30:51','',''),(2248710,'1','194','1012',460,'Retail Sale Id 1319442',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 15:34:01','',''),(2248711,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:34:01','',''),(2248768,'1','194','1012',460,'Retail Sale Id 1319456',34680.00,0.00,0.00,0.00,600.00,'2021-12-11 15:36:47','',''),(2248769,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-11 15:36:47','',''),(2248794,'1','194','1012',460,'Retail Sale Id 1319486',1299.20,0.00,0.00,0.00,146.16,'2021-12-11 15:38:17','',''),(2248795,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-11 15:38:17','',''),(2248814,'1','194','1012',460,'Retail Sale Id 1319497',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 15:39:26','',''),(2248815,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:39:26','',''),(2248836,'1','194','1012',460,'Retail Sale Id 1319509',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 15:41:02','',''),(2248837,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:41:02','',''),(2248846,'1','194','1012',460,'Retail Sale Id 1319514',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 15:42:03','',''),(2248847,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 15:42:03','',''),(2248908,'1','194','1012',460,'Retail Sale Id 1319555',21964.00,0.00,0.00,0.00,380.00,'2021-12-11 15:45:07','',''),(2248909,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,38.00,0.00,'2021-12-11 15:45:07','',''),(2248940,'1','194','1012',460,'Retail Sale Id 1319569',8960.00,0.00,0.00,0.00,1008.00,'2021-12-11 15:47:14','',''),(2248941,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-11 15:47:14','',''),(2249009,'1','194','1012',460,'Retail Sale Id 1319594',6400.00,0.00,0.00,0.00,720.00,'2021-12-11 15:49:17','',''),(2249010,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 15:49:17','',''),(2249033,'1','194','1012',460,'Retail Sale Id 1319607',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 15:50:22','',''),(2249034,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 15:50:22','',''),(2249053,'1','194','1012',460,'Retail Sale Id 1319619',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 15:51:00','',''),(2249054,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:51:00','',''),(2249067,'1','194','1012',460,'Retail Sale Id 1319627',1299.20,0.00,0.00,0.00,146.16,'2021-12-11 15:51:56','',''),(2249068,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-11 15:51:56','',''),(2249088,'1','194','1012',460,'Retail Sale Id 1319634',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 15:52:46','',''),(2249089,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 15:52:46','',''),(2249121,'1','194','1012',460,'Retail Sale Id 1319647',7680.00,0.00,0.00,0.00,864.00,'2021-12-11 15:53:39','',''),(2249122,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-11 15:53:40','',''),(2249145,'1','194','1012',460,'Retail Sale Id 1319657',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 15:54:28','',''),(2249146,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:54:28','',''),(2249167,'1','194','1012',460,'Retail Sale Id 1319660',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 15:55:09','',''),(2249168,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:55:09','',''),(2249195,'1','194','1012',460,'Retail Sale Id 1319671',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 15:55:53','',''),(2249196,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 15:55:53','',''),(2249212,'1','194','1012',460,'Retail Sale Id 1319681',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 15:56:31','',''),(2249213,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 15:56:31','',''),(2249233,'1','194','1012',460,'Retail Sale Id 1319686',5120.00,0.00,0.00,0.00,576.00,'2021-12-11 15:57:10','',''),(2249234,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 15:57:10','',''),(2249267,'1','194','1012',460,'Retail Sale Id 1319697',17920.00,0.00,0.00,0.00,2016.00,'2021-12-11 15:58:27','',''),(2249268,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-11 15:58:27','',''),(2249280,'1','194','1012',460,'Retail Sale Id 1319703',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 15:59:09','',''),(2249281,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 15:59:09','',''),(2249302,'1','194','1012',460,'Retail Sale Id 1319713',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 16:00:00','',''),(2249303,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:00:00','',''),(2249321,'1','194','1012',460,'Retail Sale Id 1319721',2003.20,0.00,0.00,0.00,225.36,'2021-12-11 16:00:54','',''),(2249322,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-11 16:00:54','',''),(2249337,'1','194','1012',460,'Retail Sale Id 1319731',640.00,0.00,0.00,0.00,72.00,'2021-12-11 16:01:33','',''),(2249338,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 16:01:33','',''),(2249367,'1','194','1012',460,'Retail Sale Id 1319743',1299.20,0.00,0.00,0.00,146.16,'2021-12-11 16:02:35','',''),(2249368,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-11 16:02:35','',''),(2249387,'1','194','1012',460,'Retail Sale Id 1319751',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 16:03:15','',''),(2249388,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:03:15','',''),(2249401,'1','194','1012',460,'Retail Sale Id 1319760',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 16:03:54','',''),(2249402,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:03:54','',''),(2249417,'1','194','1012',460,'Retail Sale Id 1319767',5120.00,0.00,0.00,0.00,576.00,'2021-12-11 16:04:36','',''),(2249418,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 16:04:36','',''),(2249431,'1','194','1012',460,'Retail Sale Id 1319774',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:05:13','',''),(2249432,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:05:13','',''),(2249443,'1','194','1012',460,'Retail Sale Id 1319780',1497.60,0.00,0.00,0.00,168.48,'2021-12-11 16:05:52','',''),(2249444,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-11 16:05:52','',''),(2249450,'1','194','1012',460,'Retail Sale Id 1319784',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 16:06:31','',''),(2249451,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:06:31','',''),(2249466,'1','194','1012',460,'Retail Sale Id 1319791',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:07:10','',''),(2249467,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:07:10','',''),(2249476,'1','194','1012',460,'Retail Sale Id 1319799',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 16:07:46','',''),(2249477,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:07:46','',''),(2249518,'1','194','1012',460,'Retail Sale Id 1319814',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 16:09:01','',''),(2249519,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:09:01','',''),(2249546,'1','194','1012',460,'Retail Sale Id 1319832',14080.00,0.00,0.00,0.00,1584.00,'2021-12-11 16:10:42','',''),(2249547,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-11 16:10:42','',''),(2249565,'1','194','1012',460,'Retail Sale Id 1319840',14080.00,0.00,0.00,0.00,1584.00,'2021-12-11 16:11:38','',''),(2249566,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-11 16:11:38','',''),(2249591,'1','194','1012',460,'Retail Sale Id 1319901',23120.00,0.00,0.00,0.00,400.00,'2021-12-11 16:13:35','',''),(2249592,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-11 16:13:35','',''),(2249609,'1','194','1012',460,'Retail Sale Id 1319907',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:14:22','',''),(2249610,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:14:22','',''),(2249625,'1','194','1012',460,'Retail Sale Id 1319920',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 16:15:03','',''),(2249626,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:15:03','',''),(2249641,'1','194','1012',460,'Retail Sale Id 1319926',3200.00,0.00,0.00,0.00,360.00,'2021-12-11 16:15:49','',''),(2249642,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 16:15:49','',''),(2249658,'1','194','1012',460,'Retail Sale Id 1319934',15606.00,0.00,0.00,0.00,270.00,'2021-12-11 16:17:08','',''),(2249659,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,27.00,0.00,'2021-12-11 16:17:08','',''),(2249673,'1','194','1012',460,'Retail Sale Id 1319940',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 16:17:49','',''),(2249674,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:17:49','',''),(2249685,'1','194','1012',460,'Retail Sale Id 1319947',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 16:19:03','',''),(2249686,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:19:03','',''),(2249697,'1','194','1012',460,'Retail Sale Id 1319955',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 16:19:39','',''),(2249698,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:19:39','',''),(2249709,'1','194','1012',460,'Retail Sale Id 1319960',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 16:20:28','',''),(2249710,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:20:28','',''),(2249719,'1','194','1012',460,'Retail Sale Id 1319965',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:21:25','',''),(2249720,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:21:25','',''),(2249737,'1','194','1012',460,'Retail Sale Id 1319974',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:22:12','',''),(2249738,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:22:12','',''),(2249760,'1','194','1012',460,'Retail Sale Id 1319983',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:23:04','',''),(2249761,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:23:04','',''),(2249784,'1','194','1012',460,'Retail Sale Id 1319994',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 16:24:38','',''),(2249785,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:24:38','',''),(2249905,'1','194','1012',460,'Retail Sale Id 1320047',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 16:31:39','',''),(2249906,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:31:39','',''),(2249923,'1','194','1012',460,'Retail Sale Id 1320054',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 16:32:37','',''),(2249924,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:32:37','',''),(2249957,'1','194','1012',460,'Retail Sale Id 1320073',57800.00,0.00,0.00,0.00,1000.00,'2021-12-11 16:33:51','',''),(2249958,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 16:33:51','',''),(2249996,'1','194','1012',460,'Retail Sale Id 1320084',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 16:35:08','',''),(2249997,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:35:08','',''),(2250008,'1','194','1012',460,'Retail Sale Id 1320089',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 16:35:59','',''),(2250009,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:35:59','',''),(2250029,'1','194','1012',460,'Retail Sale Id 1320099',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:36:43','',''),(2250030,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:36:43','',''),(2250077,'1','194','1012',460,'Retail Sale Id 1320108',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 16:38:13','',''),(2250078,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:38:13','',''),(2250156,'1','194','1012',460,'Retail Sale Id 1320141',57800.00,0.00,0.00,0.00,1000.00,'2021-12-11 16:42:30','',''),(2250157,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-11 16:42:30','',''),(2250176,'1','194','1012',460,'Retail Sale Id 1320151',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 16:44:14','',''),(2250177,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:44:14','',''),(2250194,'1','194','1012',460,'Retail Sale Id 1320160',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 16:45:59','',''),(2250195,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 16:45:59','',''),(2250210,'1','194','1012',460,'Retail Sale Id 1320168',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 16:47:34','',''),(2250211,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:47:34','',''),(2250233,'1','194','1012',460,'Retail Sale Id 1320180',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:48:35','',''),(2250234,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:48:35','',''),(2250258,'1','194','1012',460,'Retail Sale Id 1320188',8000.00,0.00,0.00,0.00,900.00,'2021-12-11 16:49:29','',''),(2250259,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 16:49:29','',''),(2250266,'1','194','1012',460,'Retail Sale Id 1320192',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 16:50:24','',''),(2250267,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:50:24','',''),(2250280,'1','194','1012',460,'Retail Sale Id 1320196',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 16:51:18','',''),(2250281,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 16:51:18','',''),(2250296,'1','194','1012',460,'Retail Sale Id 1320203',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 16:52:26','',''),(2250297,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:52:26','',''),(2250324,'1','194','1012',460,'Retail Sale Id 1320214',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 16:53:29','',''),(2250325,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:53:29','',''),(2250378,'1','194','1012',460,'Retail Sale Id 1320229',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:56:08','',''),(2250379,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:56:08','',''),(2250396,'1','194','1012',460,'Retail Sale Id 1320241',1920.00,0.00,0.00,0.00,216.00,'2021-12-11 16:57:07','',''),(2250397,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:57:07','',''),(2250414,'1','194','1012',460,'Retail Sale Id 1320250',998.40,0.00,0.00,0.00,112.32,'2021-12-11 16:57:59','',''),(2250415,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-11 16:57:59','',''),(2250427,'1','194','1012',460,'Retail Sale Id 1320257',640.00,0.00,0.00,0.00,72.00,'2021-12-11 16:58:45','',''),(2250428,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 16:58:45','',''),(2250439,'1','194','1012',460,'Retail Sale Id 1320264',1280.00,0.00,0.00,0.00,144.00,'2021-12-11 16:59:53','',''),(2250440,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:59:53','',''),(2250498,'1','194','1012',460,'Retail Sale Id 1320278',20230.00,0.00,0.00,0.00,350.00,'2021-12-11 17:02:49','',''),(2250499,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-11 17:02:49','',''),(2250636,'1','194','1012',460,'Retail Sale Id 1320365',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 17:13:37','',''),(2250637,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 17:13:37','',''),(2250706,'1','194','1012',460,'Retail Sale Id 1320400',2560.00,0.00,0.00,0.00,288.00,'2021-12-11 17:20:19','',''),(2250707,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 17:20:19','',''),(2250734,'1','194','1012',460,'Retail Sale Id 1320413',3840.00,0.00,0.00,0.00,432.00,'2021-12-11 17:23:23','',''),(2250735,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 17:23:23','',''),(2250754,'1','194','1012',460,'Retail Sale Id 1320424',6400.00,0.00,0.00,0.00,720.00,'2021-12-11 17:25:00','',''),(2250755,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 17:25:00','',''),(2250788,'1','194','1012',460,'Retail Sale Id 1320440',4480.00,0.00,0.00,0.00,504.00,'2021-12-11 17:27:10','',''),(2250789,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-11 17:27:10','',''),(2251110,'1','194','1012',460,'Return of Retail Sale Id 1317358',0.00,29440.00,46.00,0.00,-3312.00,'2021-12-11 17:54:05','',''),(2251131,'1','194','1012',460,'Retail Sale Id 1320587',29440.00,0.00,0.00,0.00,3312.00,'2021-12-11 17:55:55','',''),(2251132,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-11 17:55:56','',''),(2251176,'1','194','1012',460,'Retail Sale Id 1320608',28900.00,0.00,0.00,0.00,500.00,'2021-12-11 18:00:47','',''),(2251177,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-11 18:00:47','',''),(2252228,'1','194','1012',460,'Retail Sale Id 1320906',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 06:31:12','',''),(2252229,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 06:31:12','',''),(2252262,'1','194','1012',460,'Retail Sale Id 1320925',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 06:33:17','',''),(2252263,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 06:33:17','',''),(2252276,'1','194','1012',460,'Retail Sale Id 1320930',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 06:34:07','',''),(2252277,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 06:34:07','',''),(2252297,'1','194','1012',460,'Retail Sale Id 1320935',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 06:34:55','',''),(2252298,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 06:34:55','',''),(2252323,'1','194','1012',460,'Retail Sale Id 1320939',57800.00,0.00,0.00,0.00,1000.00,'2021-12-12 06:36:13','',''),(2252324,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-12 06:36:13','',''),(2252358,'1','194','1012',460,'Retail Sale Id 1320953',998.40,0.00,0.00,0.00,112.32,'2021-12-12 06:37:41','',''),(2252359,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 06:37:41','',''),(2252385,'1','194','1012',460,'Retail Sale Id 1320962',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 06:38:32','',''),(2252386,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 06:38:32','',''),(2252416,'1','194','1012',460,'Retail Sale Id 1320971',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 06:40:54','',''),(2252417,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 06:40:54','',''),(2252430,'1','194','1012',460,'Retail Sale Id 1320983',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 06:41:44','',''),(2252431,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 06:41:44','',''),(2252436,'1','194','1012',460,'Retail Sale Id 1320987',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 06:42:37','',''),(2252437,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 06:42:37','',''),(2252534,'1','194','1012',460,'Retail Sale Id 1321024',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 06:48:11','',''),(2252535,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 06:48:11','',''),(2252560,'1','194','1012',460,'Retail Sale Id 1321029',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 06:49:09','',''),(2252561,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 06:49:09','',''),(2252596,'1','194','1012',460,'Retail Sale Id 1321035',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 06:50:20','',''),(2252597,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 06:50:20','',''),(2252631,'1','194','1012',460,'Retail Sale Id 1321050',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 06:51:52','',''),(2252632,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 06:51:52','',''),(2252643,'1','194','1012',460,'Retail Sale Id 1321055',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 06:52:39','',''),(2252644,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 06:52:39','',''),(2252649,'1','194','1012',460,'Retail Sale Id 1321058',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 06:53:25','',''),(2252650,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 06:53:25','',''),(2252727,'1','194','1012',460,'Retail Sale Id 1321095',2560.00,0.00,0.00,0.00,288.00,'2021-12-12 07:01:21','',''),(2252728,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 07:01:21','',''),(2252747,'1','194','1012',460,'Retail Sale Id 1321106',2560.00,0.00,0.00,0.00,288.00,'2021-12-12 07:02:20','',''),(2252748,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 07:02:20','',''),(2252799,'1','194','1012',460,'Retail Sale Id 1321136',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 07:07:08','',''),(2252800,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 07:07:08','',''),(2252892,'1','194','1012',460,'Retail Sale Id 1321180',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 07:13:45','',''),(2252893,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 07:13:45','',''),(2252904,'1','194','1012',460,'Retail Sale Id 1321186',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 07:14:33','',''),(2252905,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 07:14:33','',''),(2252928,'1','194','1012',460,'Retail Sale Id 1321195',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 07:16:01','',''),(2252929,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 07:16:01','',''),(2252942,'1','194','1012',460,'Retail Sale Id 1321209',104040.00,0.00,0.00,0.00,1800.00,'2021-12-12 07:17:40','',''),(2252943,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,180.00,0.00,'2021-12-12 07:17:40','',''),(2252968,'1','194','1012',460,'Retail Sale Id 1321219',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 07:19:17','',''),(2252969,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 07:19:17','',''),(2252998,'1','194','1012',460,'Retail Sale Id 1321232',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 07:21:28','',''),(2252999,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 07:21:28','',''),(2253072,'1','194','1012',460,'Retail Sale Id 1321271',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 07:25:27','',''),(2253073,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 07:25:27','',''),(2253094,'1','194','1012',460,'Retail Sale Id 1321286',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 07:27:10','',''),(2253095,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 07:27:10','',''),(2253134,'1','194','1012',460,'Retail Sale Id 1321299',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 07:29:35','',''),(2253135,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:29:35','',''),(2253901,'1','194','1012',460,'Retail Sale Id 1321712',8960.00,0.00,0.00,0.00,1008.00,'2021-12-12 08:20:04','',''),(2253902,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-12 08:20:04','',''),(2253917,'1','194','1012',460,'Retail Sale Id 1321725',11200.00,0.00,0.00,0.00,1260.00,'2021-12-12 08:21:27','',''),(2253918,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-12 08:21:27','',''),(2253959,'1','194','1012',460,'Retail Sale Id 1321738',13504.00,0.00,0.00,0.00,1519.20,'2021-12-12 08:23:29','',''),(2253960,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,21.10,0.00,'2021-12-12 08:23:29','',''),(2253989,'1','194','1012',460,'Retail Sale Id 1321752',6400.00,0.00,0.00,0.00,720.00,'2021-12-12 08:25:13','',''),(2253990,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 08:25:13','',''),(2254009,'1','194','1012',460,'Retail Sale Id 1321767',2003.20,0.00,0.00,0.00,225.36,'2021-12-12 08:27:11','',''),(2254010,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-12 08:27:11','',''),(2254104,'1','194','1012',460,'Retail Sale Id 1321816',23120.00,0.00,0.00,0.00,400.00,'2021-12-12 08:34:28','',''),(2254105,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 08:34:28','',''),(2254138,'1','194','1012',460,'Retail Sale Id 1321828',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 08:36:23','',''),(2254139,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:36:23','',''),(2254156,'1','194','1012',460,'Retail Sale Id 1321849',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 08:37:44','',''),(2254157,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 08:37:44','',''),(2254241,'1','194','1012',460,'Retail Sale Id 1321886',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 08:42:20','',''),(2254242,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:42:20','',''),(2254354,'1','194','1012',460,'Retail Sale Id 1321938',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 08:48:03','',''),(2254355,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 08:48:03','',''),(2254381,'1','194','1012',460,'Retail Sale Id 1321950',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 08:49:21','',''),(2254382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:49:21','',''),(2254440,'1','194','1012',460,'Retail Sale Id 1321971',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 08:52:23','',''),(2254441,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:52:23','',''),(2254462,'1','194','1012',460,'Retail Sale Id 1321986',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 08:54:05','',''),(2254463,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 08:54:05','',''),(2254508,'1','194','1012',460,'Retail Sale Id 1322007',7680.00,0.00,0.00,0.00,864.00,'2021-12-12 08:56:48','',''),(2254509,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 08:56:48','',''),(2254532,'1','194','1012',460,'Retail Sale Id 1322018',12800.00,0.00,0.00,0.00,1440.00,'2021-12-12 08:58:10','',''),(2254533,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-12 08:58:10','',''),(2254590,'1','194','1012',460,'Retail Sale Id 1322050',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:01:39','',''),(2254591,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 09:01:39','',''),(2254628,'1','194','1012',460,'Retail Sale Id 1322067',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 09:03:47','',''),(2254629,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:03:47','',''),(2254655,'1','194','1012',460,'Retail Sale Id 1322082',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 09:05:11','',''),(2254656,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 09:05:11','',''),(2254701,'1','194','1012',460,'Retail Sale Id 1322108',8320.00,0.00,0.00,0.00,936.00,'2021-12-12 09:07:39','',''),(2254702,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-12 09:07:39','',''),(2254811,'1','194','1012',460,'Retail Sale Id 1322154',12800.00,0.00,0.00,0.00,1440.00,'2021-12-12 09:12:47','',''),(2254812,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-12 09:12:47','',''),(2254835,'1','194','1012',460,'Retail Sale Id 1322171',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 09:14:17','',''),(2254836,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:14:17','',''),(2254913,'1','194','1012',460,'Retail Sale Id 1322217',998.40,0.00,0.00,0.00,112.32,'2021-12-12 09:18:45','',''),(2254914,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-12 09:18:45','',''),(2254955,'1','194','1012',460,'Retail Sale Id 1322233',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 09:20:55','',''),(2254956,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:20:55','',''),(2254979,'1','194','1012',460,'Retail Sale Id 1322249',2003.20,0.00,0.00,0.00,225.36,'2021-12-12 09:22:26','',''),(2254980,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-12 09:22:26','',''),(2255469,'1','194','1012',460,'Retail Sale Id 1322481',5440.00,0.00,0.00,0.00,612.00,'2021-12-12 09:51:44','',''),(2255470,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.50,0.00,'2021-12-12 09:51:44','',''),(2255518,'1','194','1012',460,'Retail Sale Id 1322502',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 09:53:50','',''),(2255519,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:53:50','',''),(2255542,'1','194','1012',460,'Retail Sale Id 1322515',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 09:55:11','',''),(2255543,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 09:55:11','',''),(2255817,'1','194','1012',460,'Retail Sale Id 1322642',34680.00,0.00,0.00,0.00,600.00,'2021-12-12 10:06:50','',''),(2255818,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-12 10:06:50','',''),(2255857,'1','194','1012',460,'Retail Sale Id 1322664',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:08:22','',''),(2255858,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 10:08:22','',''),(2255896,'1','194','1012',460,'Retail Sale Id 1322683',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 10:11:03','',''),(2255897,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 10:11:03','',''),(2256249,'1','194','1012',460,'Retail Sale Id 1322873',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 10:30:24','',''),(2256250,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:30:24','',''),(2256319,'1','194','1012',460,'Retail Sale Id 1322908',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 10:34:16','',''),(2256320,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 10:34:16','',''),(2256381,'1','194','1012',460,'Retail Sale Id 1322936',39882.00,0.00,0.00,0.00,690.00,'2021-12-12 10:37:01','',''),(2256382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,69.00,0.00,'2021-12-12 10:37:01','',''),(2256411,'1','194','1012',460,'Retail Sale Id 1322955',5120.00,0.00,0.00,0.00,576.00,'2021-12-12 10:38:35','',''),(2256412,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-12 10:38:35','',''),(2256455,'1','194','1012',460,'Retail Sale Id 1322984',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 10:40:58','',''),(2256456,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 10:40:58','',''),(2256512,'1','194','1012',460,'Retail Sale Id 1323007',12800.00,0.00,0.00,0.00,1440.00,'2021-12-12 10:43:10','',''),(2256513,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-12 10:43:10','',''),(2256753,'1','194','1012',460,'Retail Sale Id 1323126',2560.00,0.00,0.00,0.00,288.00,'2021-12-12 10:54:45','',''),(2256754,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 10:54:45','',''),(2256804,'1','194','1012',460,'Retail Sale Id 1323154',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 10:56:36','',''),(2256805,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 10:56:36','',''),(2256828,'1','194','1012',460,'Retail Sale Id 1323165',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 10:57:41','',''),(2256829,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 10:57:41','',''),(2256861,'1','194','1012',460,'Retail Sale Id 1323183',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 10:59:09','',''),(2256862,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 10:59:09','',''),(2256897,'1','194','1012',460,'Retail Sale Id 1323204',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 11:00:41','',''),(2256898,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 11:00:41','',''),(2256936,'1','194','1012',460,'Retail Sale Id 1323218',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 11:01:48','',''),(2256937,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:01:48','',''),(2256962,'1','194','1012',460,'Retail Sale Id 1323234',9600.00,0.00,0.00,0.00,1080.00,'2021-12-12 11:03:00','',''),(2256963,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 11:03:00','',''),(2257022,'1','194','1012',460,'Retail Sale Id 1323260',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 11:05:29','',''),(2257023,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 11:05:29','',''),(2257074,'1','194','1012',460,'Retail Sale Id 1323288',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 11:07:34','',''),(2257075,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:07:34','',''),(2257120,'1','194','1012',460,'Retail Sale Id 1323306',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 11:09:10','',''),(2257121,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:09:10','',''),(2257251,'1','194','1012',460,'Retail Sale Id 1323365',7680.00,0.00,0.00,0.00,864.00,'2021-12-12 11:15:14','',''),(2257252,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 11:15:14','',''),(2257413,'1','194','1012',460,'Retail Sale Id 1323457',6400.00,0.00,0.00,0.00,720.00,'2021-12-12 11:21:11','',''),(2257414,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 11:21:11','',''),(2257471,'1','194','1012',460,'Retail Sale Id 1323485',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 11:23:52','',''),(2257472,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 11:23:52','',''),(2257616,'1','194','1012',460,'Retail Sale Id 1323570',52020.00,0.00,0.00,0.00,900.00,'2021-12-12 11:31:05','',''),(2257617,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,90.00,0.00,'2021-12-12 11:31:05','',''),(2257707,'1','194','1012',460,'Retail Sale Id 1323617',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 11:35:14','',''),(2257708,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:35:14','',''),(2257765,'1','194','1012',460,'Retail Sale Id 1323642',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 11:38:10','',''),(2257766,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 11:38:10','',''),(2257820,'1','194','1012',460,'Retail Sale Id 1323670',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 11:40:36','',''),(2257821,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:40:36','',''),(2257875,'1','194','1012',460,'Retail Sale Id 1323693',26010.00,0.00,0.00,0.00,450.00,'2021-12-12 11:43:08','',''),(2257876,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-12 11:43:08','',''),(2257935,'1','194','1012',460,'Retail Sale Id 1323723',28322.00,0.00,0.00,0.00,490.00,'2021-12-12 11:45:51','',''),(2257936,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-12 11:45:51','',''),(2258024,'1','194','1012',460,'Retail Sale Id 1323756',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 11:50:18','',''),(2258025,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 11:50:18','',''),(2258236,'1','194','1012',460,'Retail Sale Id 1323870',2003.20,0.00,0.00,0.00,225.36,'2021-12-12 12:00:13','',''),(2258237,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-12 12:00:13','',''),(2258286,'1','194','1012',460,'Retail Sale Id 1323889',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 12:02:52','',''),(2258287,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:02:52','',''),(2258318,'1','194','1012',460,'Retail Sale Id 1323907',2502.40,0.00,0.00,0.00,281.52,'2021-12-12 12:04:55','',''),(2258319,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.91,0.00,'2021-12-12 12:04:55','',''),(2258458,'1','194','1012',460,'Retail Sale Id 1323973',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 12:13:20','',''),(2258459,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:13:20','',''),(2258484,'1','194','1012',460,'Retail Sale Id 1323987',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 12:14:13','',''),(2258485,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:14:13','',''),(2258498,'1','194','1012',460,'Retail Sale Id 1323992',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 12:14:58','',''),(2258499,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 12:14:58','',''),(2258516,'1','194','1012',460,'Retail Sale Id 1324001',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 12:15:45','',''),(2258517,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:15:45','',''),(2258538,'1','194','1012',460,'Retail Sale Id 1324011',2560.00,0.00,0.00,0.00,288.00,'2021-12-12 12:16:40','',''),(2258539,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 12:16:40','',''),(2258562,'1','194','1012',460,'Retail Sale Id 1324024',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 12:17:41','',''),(2258563,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 12:17:41','',''),(2258596,'1','194','1012',460,'Retail Sale Id 1324041',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 12:19:02','',''),(2258597,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:19:02','',''),(2258704,'1','194','1012',460,'Retail Sale Id 1324097',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 12:25:04','',''),(2258705,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:25:04','',''),(2258726,'1','194','1012',460,'Retail Sale Id 1324108',1600.00,0.00,0.00,0.00,180.00,'2021-12-12 12:25:52','',''),(2258727,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 12:25:52','',''),(2258760,'1','194','1012',460,'Retail Sale Id 1324118',9600.00,0.00,0.00,0.00,1080.00,'2021-12-12 12:27:13','',''),(2258761,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 12:27:13','',''),(2258903,'1','194','1012',460,'Retail Sale Id 1324166',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 12:32:52','',''),(2258904,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:32:52','',''),(2258988,'1','194','1012',460,'Retail Sale Id 1324226',35471.86,0.00,0.00,0.00,613.70,'2021-12-12 12:36:53','',''),(2258989,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,61.37,0.00,'2021-12-12 12:36:53','',''),(2259032,'1','194','1012',460,'Retail Sale Id 1324246',7500.80,0.00,0.00,0.00,843.84,'2021-12-12 12:38:22','',''),(2259033,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,11.72,0.00,'2021-12-12 12:38:22','',''),(2259099,'1','194','1012',460,'Retail Sale Id 1324281',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 12:41:32','',''),(2259100,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:41:32','',''),(2259113,'1','194','1012',460,'Retail Sale Id 1324290',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 12:42:41','',''),(2259114,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:42:41','',''),(2259240,'1','194','1012',460,'Retail Sale Id 1324342',219640.00,0.00,0.00,0.00,3800.00,'2021-12-12 12:48:04','',''),(2259241,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,380.00,0.00,'2021-12-12 12:48:04','',''),(2259497,'1','194','1012',460,'Retail Sale Id 1324462',42194.00,0.00,0.00,0.00,730.00,'2021-12-12 13:00:39','',''),(2259498,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,73.00,0.00,'2021-12-12 13:00:39','',''),(2259511,'1','194','1012',460,'Retail Sale Id 1324474',1497.60,0.00,0.00,0.00,168.48,'2021-12-12 13:01:45','',''),(2259512,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-12 13:01:45','',''),(2259535,'1','194','1012',460,'Retail Sale Id 1324491',23120.00,0.00,0.00,0.00,400.00,'2021-12-12 13:03:40','',''),(2259536,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-12 13:03:40','',''),(2259559,'1','194','1012',460,'Retail Sale Id 1324503',2003.20,0.00,0.00,0.00,225.36,'2021-12-12 13:04:50','',''),(2259560,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-12 13:04:50','',''),(2259577,'1','194','1012',460,'Retail Sale Id 1324512',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 13:06:04','',''),(2259578,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 13:06:04','',''),(2259649,'1','194','1012',460,'Retail Sale Id 1324551',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 13:10:33','',''),(2259650,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 13:10:33','',''),(2259803,'1','194','1012',460,'Retail Sale Id 1324630',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 13:17:58','',''),(2259804,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 13:17:58','',''),(2259922,'1','194','1012',460,'Retail Sale Id 1324678',34680.00,0.00,0.00,0.00,600.00,'2021-12-12 13:23:58','',''),(2259923,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-12 13:23:58','',''),(2260091,'1','194','1012',460,'Retail Sale Id 1324738',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 13:30:21','',''),(2260092,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 13:30:21','',''),(2260242,'1','194','1012',460,'Retail Sale Id 1324807',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 13:38:44','',''),(2260243,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:38:44','',''),(2260295,'1','194','1012',460,'Retail Sale Id 1324826',2880.00,0.00,0.00,0.00,324.00,'2021-12-12 13:40:25','',''),(2260296,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.50,0.00,'2021-12-12 13:40:25','',''),(2260601,'1','194','1012',460,'Retail Sale Id 1324969',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 13:56:06','',''),(2260602,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 13:56:06','',''),(2260668,'1','194','1012',460,'Retail Sale Id 1324998',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 13:58:42','',''),(2260669,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:58:42','',''),(2260698,'1','194','1012',460,'Retail Sale Id 1325005',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 13:59:33','',''),(2260699,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 13:59:33','',''),(2260738,'1','194','1012',460,'Retail Sale Id 1325013',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 14:01:07','',''),(2260739,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 14:01:07','',''),(2260959,'1','194','1012',460,'Retail Sale Id 1325099',25432.00,0.00,0.00,0.00,440.00,'2021-12-12 14:10:28','',''),(2260961,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,44.00,0.00,'2021-12-12 14:10:28','',''),(2261231,'1','194','1012',460,'Retail Sale Id 1325210',7680.00,0.00,0.00,0.00,864.00,'2021-12-12 14:25:03','',''),(2261232,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-12 14:25:03','',''),(2261285,'1','194','1012',460,'Retail Sale Id 1325222',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 14:26:37','',''),(2261286,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:26:37','',''),(2261504,'1','194','1012',460,'Retail Sale Id 1325310',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 14:36:45','',''),(2261505,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 14:36:45','',''),(2261878,'1','194','1012',460,'Retail Sale Id 1325468',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 14:57:40','',''),(2261879,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:57:40','',''),(2261905,'1','194','1012',460,'Retail Sale Id 1325484',1920.00,0.00,0.00,0.00,216.00,'2021-12-12 14:58:57','',''),(2261906,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:58:57','',''),(2261929,'1','194','1012',460,'Retail Sale Id 1325496',2560.00,0.00,0.00,0.00,288.00,'2021-12-12 15:00:20','',''),(2261930,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 15:00:20','',''),(2262127,'1','194','1012',460,'Retail Sale Id 1325572',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 15:10:13','',''),(2262128,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:10:13','',''),(2262199,'1','194','1012',460,'Retail Sale Id 1325609',6400.00,0.00,0.00,0.00,720.00,'2021-12-12 15:14:59','',''),(2262200,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 15:14:59','',''),(2262297,'1','194','1012',460,'Retail Sale Id 1325647',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 15:20:03','',''),(2262298,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 15:20:03','',''),(2262339,'1','194','1012',460,'Retail Sale Id 1325675',3200.00,0.00,0.00,0.00,360.00,'2021-12-12 15:23:17','',''),(2262340,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 15:23:17','',''),(2262719,'1','194','1012',460,'Retail Sale Id 1325849',173400.00,0.00,0.00,0.00,3000.00,'2021-12-12 15:43:17','',''),(2262720,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,300.00,0.00,'2021-12-12 15:43:17','',''),(2262814,'1','194','1012',460,'Retail Sale Id 1325894',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 15:49:01','',''),(2262815,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 15:49:01','',''),(2262887,'1','194','1012',460,'Retail Sale Id 1325933',1497.60,0.00,0.00,0.00,168.48,'2021-12-12 15:54:06','',''),(2262888,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.34,0.00,'2021-12-12 15:54:06','',''),(2262935,'1','194','1012',460,'Retail Sale Id 1325955',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 15:57:51','',''),(2262936,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:57:51','',''),(2263067,'1','194','1012',460,'Retail Sale Id 1326026',8000.00,0.00,0.00,0.00,900.00,'2021-12-12 16:07:51','',''),(2263068,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 16:07:51','',''),(2263081,'1','194','1012',460,'Retail Sale Id 1326034',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 16:08:59','',''),(2263082,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 16:08:59','',''),(2263138,'1','194','1012',460,'Retail Sale Id 1326060',28900.00,0.00,0.00,0.00,500.00,'2021-12-12 16:12:41','',''),(2263139,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 16:12:41','',''),(2263280,'1','194','1012',460,'Retail Sale Id 1326125',3840.00,0.00,0.00,0.00,432.00,'2021-12-12 16:21:11','',''),(2263281,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 16:21:11','',''),(2263900,'1','194','1012',460,'Return of Retail Sale Id 1325609',0.00,6400.00,10.00,0.00,-720.00,'2021-12-12 16:56:29','',''),(2264204,'1','194','1012',460,'Retail Sale Id 1326529',1280.00,0.00,0.00,0.00,144.00,'2021-12-12 17:22:59','',''),(2264205,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 17:22:59','',''),(2265355,'1','194','1012',460,'Retail Sale Id 1326806',19227.00,0.00,0.00,0.00,17523.00,'2021-12-13 06:13:15','',''),(2265356,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:13:15','',''),(2265365,'1','194','1012',460,'Retail Sale Id 1326809',998.40,0.00,0.00,0.00,112.32,'2021-12-13 06:14:36','',''),(2265366,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-13 06:14:36','',''),(2265381,'1','194','1012',460,'Retail Sale Id 1326813',57800.00,0.00,0.00,0.00,1000.00,'2021-12-13 06:17:34','',''),(2265382,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 06:17:34','',''),(2265389,'1','194','1012',460,'Retail Sale Id 1326821',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 06:19:07','',''),(2265390,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:19:07','',''),(2265411,'1','194','1012',460,'Retail Sale Id 1326828',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 06:20:17','',''),(2265412,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 06:20:17','',''),(2265421,'1','194','1012',460,'Retail Sale Id 1326834',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 06:21:22','',''),(2265422,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 06:21:22','',''),(2265431,'1','194','1012',460,'Retail Sale Id 1326838',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 06:22:44','',''),(2265432,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 06:22:44','',''),(2265435,'1','194','1012',460,'Retail Sale Id 1326841',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 06:23:32','',''),(2265436,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 06:23:32','',''),(2265451,'1','194','1012',460,'Retail Sale Id 1326846',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 06:27:00','',''),(2265452,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 06:27:00','',''),(2265506,'1','194','1012',460,'Retail Sale Id 1326873',30345.00,0.00,0.00,0.00,525.00,'2021-12-13 06:34:45','',''),(2265507,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,52.50,0.00,'2021-12-13 06:34:45','',''),(2265525,'1','194','1012',460,'Retail Sale Id 1326881',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 06:36:12','',''),(2265526,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 06:36:12','',''),(2265541,'1','194','1012',460,'Retail Sale Id 1326888',41616.00,0.00,0.00,0.00,720.00,'2021-12-13 06:38:07','',''),(2265542,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,72.00,0.00,'2021-12-13 06:38:07','',''),(2265570,'1','194','1012',460,'Retail Sale Id 1326901',4000.00,0.00,0.00,0.00,450.00,'2021-12-13 06:41:21','',''),(2265571,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-13 06:41:21','',''),(2265611,'1','194','1012',460,'Retail Sale Id 1326915',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 06:43:42','',''),(2265612,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 06:43:42','',''),(2265674,'1','194','1012',460,'Retail Sale Id 1326942',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 06:50:41','',''),(2265675,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 06:50:41','',''),(2265690,'1','194','1012',460,'Retail Sale Id 1326950',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 06:52:17','',''),(2265691,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 06:52:17','',''),(2265712,'1','194','1012',460,'Retail Sale Id 1326961',26588.00,0.00,0.00,0.00,460.00,'2021-12-13 06:54:11','',''),(2265713,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-13 06:54:11','',''),(2265728,'1','194','1012',460,'Retail Sale Id 1326971',16000.00,0.00,0.00,0.00,1800.00,'2021-12-13 06:55:52','',''),(2265729,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-13 06:55:52','',''),(2265738,'1','194','1012',460,'Retail Sale Id 1326976',2003.20,0.00,0.00,0.00,225.36,'2021-12-13 06:57:10','',''),(2265739,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-13 06:57:10','',''),(2265779,'1','194','1012',460,'Retail Sale Id 1327003',28861.00,0.00,0.00,0.00,1029.00,'2021-12-13 07:00:13','',''),(2265780,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-13 07:00:13','',''),(2265801,'1','194','1012',460,'Retail Sale Id 1327020',28322.00,0.00,0.00,0.00,490.00,'2021-12-13 07:01:31','',''),(2265802,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-13 07:01:31','',''),(2265813,'1','194','1012',460,'Retail Sale Id 1327028',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 07:02:41','',''),(2265814,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:02:41','',''),(2265827,'1','194','1012',460,'Retail Sale Id 1327040',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 07:03:33','',''),(2265828,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 07:03:33','',''),(2265859,'1','194','1012',460,'Retail Sale Id 1327055',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 07:05:20','',''),(2265860,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 07:05:20','',''),(2265869,'1','194','1012',460,'Retail Sale Id 1327060',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 07:06:20','',''),(2265870,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 07:06:20','',''),(2265893,'1','194','1012',460,'Retail Sale Id 1327075',28322.00,0.00,0.00,0.00,490.00,'2021-12-13 07:07:05','',''),(2265894,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,49.00,0.00,'2021-12-13 07:07:05','',''),(2265923,'1','194','1012',460,'Retail Sale Id 1327091',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 07:08:52','',''),(2265924,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 07:08:52','',''),(2265943,'1','194','1012',460,'Retail Sale Id 1327098',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 07:10:34','',''),(2265944,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 07:10:34','',''),(2265963,'1','194','1012',460,'Retail Sale Id 1327111',998.40,0.00,0.00,0.00,112.32,'2021-12-13 07:11:46','',''),(2265964,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-13 07:11:46','',''),(2265993,'1','194','1012',460,'Retail Sale Id 1327128',800.00,0.00,0.00,0.00,90.00,'2021-12-13 07:13:35','',''),(2265994,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-13 07:13:35','',''),(2266037,'1','194','1012',460,'Retail Sale Id 1327149',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 07:16:44','',''),(2266038,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 07:16:44','',''),(2266087,'1','194','1012',460,'Retail Sale Id 1327173',57800.00,0.00,0.00,0.00,1000.00,'2021-12-13 07:19:57','',''),(2266088,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 07:19:57','',''),(2266131,'1','194','1012',460,'Retail Sale Id 1327189',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 07:22:52','',''),(2266132,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:22:52','',''),(2266149,'1','194','1012',460,'Retail Sale Id 1327210',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 07:24:22','',''),(2266150,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 07:24:22','',''),(2266201,'1','194','1012',460,'Retail Sale Id 1327230',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 07:28:06','',''),(2266202,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:28:06','',''),(2266323,'1','194','1012',460,'Retail Sale Id 1327290',26588.00,0.00,0.00,0.00,460.00,'2021-12-13 07:35:36','',''),(2266324,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-13 07:35:36','',''),(2266339,'1','194','1012',460,'Retail Sale Id 1327298',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 07:36:40','',''),(2266340,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 07:36:40','',''),(2266423,'1','194','1012',460,'Retail Sale Id 1327341',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 07:41:44','',''),(2266424,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:41:44','',''),(2266450,'1','194','1012',460,'Retail Sale Id 1327352',5760.00,0.00,0.00,0.00,648.00,'2021-12-13 07:42:37','',''),(2266451,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-13 07:42:37','',''),(2266478,'1','194','1012',460,'Retail Sale Id 1327363',11840.00,0.00,0.00,0.00,1332.00,'2021-12-13 07:44:25','',''),(2266479,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-13 07:44:25','',''),(2266510,'1','194','1012',460,'Retail Sale Id 1327377',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 07:46:15','',''),(2266511,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:46:15','',''),(2266546,'1','194','1012',460,'Retail Sale Id 1327395',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 07:48:18','',''),(2266547,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:48:18','',''),(2266564,'1','194','1012',460,'Retail Sale Id 1327402',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 07:49:17','',''),(2266565,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:49:17','',''),(2266596,'1','194','1012',460,'Retail Sale Id 1327416',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 07:50:59','',''),(2266597,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:50:59','',''),(2266610,'1','194','1012',460,'Retail Sale Id 1327424',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 07:51:56','',''),(2266611,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:51:56','',''),(2266626,'1','194','1012',460,'Retail Sale Id 1327433',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 07:53:00','',''),(2266627,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 07:53:00','',''),(2266680,'1','194','1012',460,'Retail Sale Id 1327458',144500.00,0.00,0.00,0.00,2500.00,'2021-12-13 07:55:59','',''),(2266681,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,250.00,0.00,'2021-12-13 07:55:59','',''),(2266692,'1','194','1012',460,'Retail Sale Id 1327466',26010.00,0.00,0.00,0.00,450.00,'2021-12-13 07:56:48','',''),(2266693,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-13 07:56:48','',''),(2266704,'1','194','1012',460,'Retail Sale Id 1327471',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 07:58:14','',''),(2266705,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 07:58:14','',''),(2266741,'1','194','1012',460,'Retail Sale Id 1327484',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 07:59:16','',''),(2266742,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 07:59:16','',''),(2266781,'1','194','1012',460,'Retail Sale Id 1327506',54910.00,0.00,0.00,0.00,950.00,'2021-12-13 08:01:28','',''),(2266782,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,95.00,0.00,'2021-12-13 08:01:28','',''),(2266801,'1','194','1012',460,'Retail Sale Id 1327514',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 08:02:25','',''),(2266802,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:02:25','',''),(2266862,'1','194','1012',460,'Retail Sale Id 1327526',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 08:03:28','',''),(2266863,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:03:28','',''),(2266882,'1','194','1012',460,'Retail Sale Id 1327534',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 08:04:28','',''),(2266883,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:04:28','',''),(2266949,'1','194','1012',460,'Retail Sale Id 1327561',2003.20,0.00,0.00,0.00,225.36,'2021-12-13 08:07:13','',''),(2266950,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-13 08:07:13','',''),(2267005,'1','194','1012',460,'Retail Sale Id 1327585',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 08:10:39','',''),(2267006,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:10:39','',''),(2267025,'1','194','1012',460,'Retail Sale Id 1327591',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 08:11:28','',''),(2267026,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:11:28','',''),(2267058,'1','194','1012',460,'Retail Sale Id 1327602',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 08:12:41','',''),(2267059,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:12:41','',''),(2267190,'1','194','1012',460,'Retail Sale Id 1327631',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 08:16:01','',''),(2267191,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:16:01','',''),(2267224,'1','194','1012',460,'Retail Sale Id 1327648',2003.20,0.00,0.00,0.00,225.36,'2021-12-13 08:18:51','',''),(2267225,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-13 08:18:51','',''),(2267246,'1','194','1012',460,'Retail Sale Id 1327659',800.00,0.00,0.00,0.00,90.00,'2021-12-13 08:20:26','',''),(2267247,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.25,0.00,'2021-12-13 08:20:26','',''),(2267262,'1','194','1012',460,'Retail Sale Id 1327669',11840.00,0.00,0.00,0.00,1332.00,'2021-12-13 08:21:29','',''),(2267263,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-13 08:21:29','',''),(2267300,'1','194','1012',460,'Retail Sale Id 1327688',1299.20,0.00,0.00,0.00,146.16,'2021-12-13 08:24:31','',''),(2267301,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-13 08:24:31','',''),(2267448,'1','194','1012',460,'Retail Sale Id 1327763',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 08:32:20','',''),(2267449,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:32:20','',''),(2267476,'1','194','1012',460,'Retail Sale Id 1327782',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 08:33:50','',''),(2267477,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 08:33:50','',''),(2267506,'1','194','1012',460,'Retail Sale Id 1327796',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 08:35:25','',''),(2267507,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:35:25','',''),(2267617,'1','194','1012',460,'Retail Sale Id 1327847',231200.00,0.00,0.00,0.00,4000.00,'2021-12-13 08:39:40','',''),(2267618,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-13 08:39:40','',''),(2267686,'1','194','1012',460,'Retail Sale Id 1327876',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 08:43:48','',''),(2267687,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 08:43:48','',''),(2267700,'1','194','1012',460,'Retail Sale Id 1327886',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 08:44:39','',''),(2267701,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:44:39','',''),(2267760,'1','194','1012',460,'Retail Sale Id 1327901',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 08:46:29','',''),(2267761,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:46:29','',''),(2267777,'1','194','1012',460,'Retail Sale Id 1327905',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 08:47:33','',''),(2267778,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 08:47:33','',''),(2267809,'1','194','1012',460,'Retail Sale Id 1327921',2598.40,0.00,0.00,0.00,292.32,'2021-12-13 08:50:22','',''),(2267810,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-13 08:50:22','',''),(2267858,'1','194','1012',460,'Retail Sale Id 1327926',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 08:51:34','',''),(2267859,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:51:34','',''),(2267876,'1','194','1012',460,'Retail Sale Id 1327931',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 08:52:43','',''),(2267877,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 08:52:43','',''),(2267884,'1','194','1012',460,'Retail Sale Id 1327939',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 08:53:56','',''),(2267885,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 08:53:56','',''),(2267922,'1','194','1012',460,'Retail Sale Id 1327957',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 08:56:14','',''),(2267923,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 08:56:14','',''),(2267959,'1','194','1012',460,'Retail Sale Id 1327973',26588.00,0.00,0.00,0.00,460.00,'2021-12-13 08:58:12','',''),(2267960,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-13 08:58:12','',''),(2267996,'1','194','1012',460,'Retail Sale Id 1327979',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 08:59:49','',''),(2267997,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:59:49','',''),(2268019,'1','194','1012',460,'Retail Sale Id 1327988',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:01:15','',''),(2268020,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:01:15','',''),(2268051,'1','194','1012',460,'Retail Sale Id 1328014',1299.20,0.00,0.00,0.00,146.16,'2021-12-13 09:03:15','',''),(2268052,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.03,0.00,'2021-12-13 09:03:15','',''),(2268067,'1','194','1012',460,'Retail Sale Id 1328022',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:04:02','',''),(2268068,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:04:02','',''),(2268090,'1','194','1012',460,'Retail Sale Id 1328029',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:05:17','',''),(2268091,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:05:17','',''),(2268114,'1','194','1012',460,'Retail Sale Id 1328047',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:06:39','',''),(2268115,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:06:39','',''),(2268161,'1','194','1012',460,'Retail Sale Id 1328057',8320.00,0.00,0.00,0.00,936.00,'2021-12-13 09:08:45','',''),(2268162,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-13 09:08:45','',''),(2268175,'1','194','1012',460,'Retail Sale Id 1328066',8320.00,0.00,0.00,0.00,936.00,'2021-12-13 09:10:02','',''),(2268176,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-13 09:10:02','',''),(2268226,'1','194','1012',460,'Retail Sale Id 1328079',56644.00,0.00,0.00,0.00,980.00,'2021-12-13 09:11:53','',''),(2268227,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,98.00,0.00,'2021-12-13 09:11:53','',''),(2268254,'1','194','1012',460,'Retail Sale Id 1328094',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 09:13:31','',''),(2268255,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 09:13:31','',''),(2268266,'1','194','1012',460,'Retail Sale Id 1328104',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 09:14:34','',''),(2268267,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:14:34','',''),(2268276,'1','194','1012',460,'Retail Sale Id 1328110',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 09:15:33','',''),(2268277,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 09:15:33','',''),(2268292,'1','194','1012',460,'Retail Sale Id 1328121',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 09:16:19','',''),(2268293,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 09:16:19','',''),(2268346,'1','194','1012',460,'Retail Sale Id 1328136',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 09:19:12','',''),(2268347,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:19:12','',''),(2268372,'1','194','1012',460,'Retail Sale Id 1328147',6400.00,0.00,0.00,0.00,720.00,'2021-12-13 09:21:23','',''),(2268373,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 09:21:23','',''),(2268386,'1','194','1012',460,'Retail Sale Id 1328162',34680.00,0.00,0.00,0.00,600.00,'2021-12-13 09:22:35','',''),(2268387,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,60.00,0.00,'2021-12-13 09:22:35','',''),(2268412,'1','194','1012',460,'Retail Sale Id 1328177',6400.00,0.00,0.00,0.00,720.00,'2021-12-13 09:23:33','',''),(2268413,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-13 09:23:33','',''),(2268462,'1','194','1012',460,'Retail Sale Id 1328196',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 09:26:02','',''),(2268463,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 09:26:02','',''),(2268480,'1','194','1012',460,'Retail Sale Id 1328215',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 09:27:27','',''),(2268481,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 09:27:27','',''),(2268512,'1','194','1012',460,'Retail Sale Id 1328230',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 09:28:29','',''),(2268513,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 09:28:29','',''),(2268622,'1','194','1012',460,'Retail Sale Id 1328286',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:37:35','',''),(2268623,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:37:35','',''),(2268644,'1','194','1012',460,'Retail Sale Id 1328299',2003.20,0.00,0.00,0.00,225.36,'2021-12-13 09:38:57','',''),(2268645,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.13,0.00,'2021-12-13 09:38:57','',''),(2268656,'1','194','1012',460,'Retail Sale Id 1328304',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:40:08','',''),(2268657,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:40:08','',''),(2268670,'1','194','1012',460,'Retail Sale Id 1328314',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 09:41:07','',''),(2268671,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 09:41:07','',''),(2268722,'1','194','1012',460,'Retail Sale Id 1328339',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 09:44:52','',''),(2268723,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:44:52','',''),(2268732,'1','194','1012',460,'Retail Sale Id 1328345',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:45:52','',''),(2268733,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:45:52','',''),(2268747,'1','194','1012',460,'Retail Sale Id 1328353',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:46:48','',''),(2268748,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:46:48','',''),(2268789,'1','194','1012',460,'Retail Sale Id 1328375',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 09:48:34','',''),(2268790,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 09:48:34','',''),(2268835,'1','194','1012',460,'Retail Sale Id 1328396',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 09:51:22','',''),(2268836,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:51:22','',''),(2268847,'1','194','1012',460,'Retail Sale Id 1328405',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 09:52:01','',''),(2268848,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:52:01','',''),(2268865,'1','194','1012',460,'Retail Sale Id 1328410',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 09:53:28','',''),(2268866,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 09:53:28','',''),(2268941,'1','194','1012',460,'Retail Sale Id 1328444',1734.00,0.00,0.00,0.00,30.00,'2021-12-13 09:57:32','',''),(2268942,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:57:32','',''),(2268999,'1','194','1012',460,'Retail Sale Id 1328468',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:00:19','',''),(2269000,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 10:00:19','',''),(2269033,'1','194','1012',460,'Retail Sale Id 1328485',57800.00,0.00,0.00,0.00,1000.00,'2021-12-13 10:03:06','',''),(2269034,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 10:03:06','',''),(2269053,'1','194','1012',460,'Retail Sale Id 1328499',4480.00,0.00,0.00,0.00,504.00,'2021-12-13 10:05:05','',''),(2269056,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-13 10:05:05','',''),(2269073,'1','194','1012',460,'Retail Sale Id 1328510',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 10:06:14','',''),(2269074,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:06:14','',''),(2269085,'1','194','1012',460,'Retail Sale Id 1328520',20230.00,0.00,0.00,0.00,350.00,'2021-12-13 10:07:13','',''),(2269086,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-13 10:07:13','',''),(2269093,'1','194','1012',460,'Retail Sale Id 1328525',11840.00,0.00,0.00,0.00,1332.00,'2021-12-13 10:08:15','',''),(2269094,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-13 10:08:15','',''),(2269117,'1','194','1012',460,'Retail Sale Id 1328538',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 10:09:25','',''),(2269118,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:09:25','',''),(2269131,'1','194','1012',460,'Retail Sale Id 1328552',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:10:28','',''),(2269132,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 10:10:28','',''),(2269175,'1','194','1012',460,'Retail Sale Id 1328574',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 10:13:26','',''),(2269176,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:13:26','',''),(2269325,'1','194','1012',460,'Retail Sale Id 1328652',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 10:25:45','',''),(2269326,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:25:45','',''),(2269373,'1','194','1012',460,'Retail Sale Id 1328676',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:29:21','',''),(2269374,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 10:29:21','',''),(2269443,'1','194','1012',460,'Retail Sale Id 1328706',28900.00,0.00,0.00,0.00,500.00,'2021-12-13 10:33:08','',''),(2269444,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 10:33:08','',''),(2269489,'1','194','1012',460,'Retail Sale Id 1328723',57800.00,0.00,0.00,0.00,1000.00,'2021-12-13 10:35:09','',''),(2269490,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-13 10:35:09','',''),(2269580,'1','194','1012',460,'Retail Sale Id 1328762',26588.00,0.00,0.00,0.00,460.00,'2021-12-13 10:40:57','',''),(2269581,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,46.00,0.00,'2021-12-13 10:40:57','',''),(2269684,'1','194','1012',460,'Retail Sale Id 1328813',31790.00,0.00,0.00,0.00,550.00,'2021-12-13 10:46:53','',''),(2269685,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,55.00,0.00,'2021-12-13 10:46:53','',''),(2269706,'1','194','1012',460,'Retail Sale Id 1328828',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 10:48:12','',''),(2269707,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 10:48:12','',''),(2269728,'1','194','1012',460,'Retail Sale Id 1328840',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 10:49:11','',''),(2269729,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:49:11','',''),(2269752,'1','194','1012',460,'Retail Sale Id 1328861',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 10:50:32','',''),(2269753,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:50:32','',''),(2269794,'1','194','1012',460,'Retail Sale Id 1328875',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 10:52:08','',''),(2269795,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:52:08','',''),(2269838,'1','194','1012',460,'Retail Sale Id 1328900',12800.00,0.00,0.00,0.00,1440.00,'2021-12-13 10:55:00','',''),(2269839,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-13 10:55:00','',''),(2269880,'1','194','1012',460,'Retail Sale Id 1328918',5120.00,0.00,0.00,0.00,576.00,'2021-12-13 10:58:33','',''),(2269881,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-13 10:58:33','',''),(2269900,'1','194','1012',460,'Retail Sale Id 1328930',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 10:59:36','',''),(2269901,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 10:59:36','',''),(2269985,'1','194','1012',460,'Retail Sale Id 1328960',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 11:04:25','',''),(2269986,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 11:04:25','',''),(2270002,'1','194','1012',460,'Retail Sale Id 1328974',60690.00,0.00,0.00,0.00,1050.00,'2021-12-13 11:06:02','',''),(2270003,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,105.00,0.00,'2021-12-13 11:06:02','',''),(2270018,'1','194','1012',460,'Retail Sale Id 1328983',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 11:07:24','',''),(2270019,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 11:07:24','',''),(2270033,'1','194','1012',460,'Retail Sale Id 1328989',3200.00,0.00,0.00,0.00,360.00,'2021-12-13 11:08:23','',''),(2270034,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 11:08:23','',''),(2270050,'1','194','1012',460,'Retail Sale Id 1328998',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 11:09:41','',''),(2270051,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 11:09:41','',''),(2270075,'1','194','1012',460,'Retail Sale Id 1329008',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 11:11:52','',''),(2270076,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:11:52','',''),(2270100,'1','194','1012',460,'Retail Sale Id 1329020',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 11:13:41','',''),(2270101,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 11:13:41','',''),(2270159,'1','194','1012',460,'Retail Sale Id 1329052',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 11:17:40','',''),(2270160,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 11:17:40','',''),(2270262,'1','194','1012',460,'Retail Sale Id 1329101',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 11:26:01','',''),(2270263,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:26:01','',''),(2270402,'1','194','1012',460,'Retail Sale Id 1329161',9600.00,0.00,0.00,0.00,1080.00,'2021-12-13 11:37:08','',''),(2270403,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-13 11:37:08','',''),(2270433,'1','194','1012',460,'Retail Sale Id 1329174',3840.00,0.00,0.00,0.00,432.00,'2021-12-13 11:38:48','',''),(2270434,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 11:38:48','',''),(2270522,'1','194','1012',460,'Retail Sale Id 1329225',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 11:46:38','',''),(2270523,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 11:46:38','',''),(2270544,'1','194','1012',460,'Retail Sale Id 1329235',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 11:48:26','',''),(2270545,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 11:48:26','',''),(2270665,'1','194','1012',460,'Retail Sale Id 1329296',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 12:00:49','',''),(2270666,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:00:49','',''),(2270697,'1','194','1012',460,'Retail Sale Id 1329314',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 12:03:26','',''),(2270698,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:03:26','',''),(2270725,'1','194','1012',460,'Retail Sale Id 1329329',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 12:05:34','',''),(2270726,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:05:34','',''),(2270733,'1','194','1012',460,'Retail Sale Id 1329333',4998.40,0.00,0.00,0.00,562.32,'2021-12-13 12:06:48','',''),(2270734,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,7.81,0.00,'2021-12-13 12:06:48','',''),(2270913,'1','194','1012',460,'Retail Sale Id 1329434',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 12:19:58','',''),(2270914,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:19:58','',''),(2271012,'1','194','1012',460,'Retail Sale Id 1329488',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 12:28:01','',''),(2271013,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 12:28:01','',''),(2271068,'1','194','1012',460,'Retail Sale Id 1329526',998.40,0.00,0.00,0.00,112.32,'2021-12-13 12:32:34','',''),(2271069,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.56,0.00,'2021-12-13 12:32:34','',''),(2271076,'1','194','1012',460,'Retail Sale Id 1329531',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 12:33:20','',''),(2271077,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:33:20','',''),(2271110,'1','194','1012',460,'Retail Sale Id 1329549',1920.00,0.00,0.00,0.00,216.00,'2021-12-13 12:35:04','',''),(2271111,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 12:35:04','',''),(2271140,'1','194','1012',460,'Retail Sale Id 1329567',2560.00,0.00,0.00,0.00,288.00,'2021-12-13 12:37:33','',''),(2271141,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 12:37:33','',''),(2271194,'1','194','1012',460,'Retail Sale Id 1329590',86700.00,0.00,0.00,0.00,1500.00,'2021-12-13 12:41:24','',''),(2271195,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-13 12:41:24','',''),(2271227,'1','194','1012',460,'Retail Sale Id 1329611',14400.00,0.00,0.00,0.00,1620.00,'2021-12-13 12:43:13','',''),(2271228,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,22.50,0.00,'2021-12-13 12:43:13','',''),(2271243,'1','194','1012',460,'Retail Sale Id 1329623',1203.20,0.00,0.00,0.00,135.36,'2021-12-13 12:44:30','',''),(2271244,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,1.88,0.00,'2021-12-13 12:44:30','',''),(2271360,'1','194','1012',460,'Retail Sale Id 1329681',1280.00,0.00,0.00,0.00,144.00,'2021-12-13 12:52:30','',''),(2271361,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 12:52:30','',''),(2271390,'1','194','1012',460,'Retail Sale Id 1329699',8000.00,0.00,0.00,0.00,900.00,'2021-12-13 12:53:55','',''),(2271391,'1','194','1012',460,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 12:53:55','',''),(2276655,'1','194','1012',460,'Return of Retail Sale Id 1329590',0.00,86700.00,150.00,0.00,-1500.00,'2021-12-13 20:40:12','',''),(2306722,'1','194','1012',460,'Retail Sale Id 1353900',8000.00,0.00,0.00,12.50,900.00,'2021-12-17 15:26:39','',''),(2306791,'1','194','1012',460,'Retail Sale Id 1353990',2560.00,0.00,0.00,4.00,288.00,'2021-12-17 15:31:04','',''),(2306807,'1','194','1012',460,'Retail Sale Id 1354015',3840.00,0.00,0.00,6.00,432.00,'2021-12-17 15:33:09','',''),(2307045,'1','194','1012',460,'Retail Sale Id 1354178',3840.00,0.00,0.00,6.00,432.00,'2021-12-17 15:47:29','',''),(2307239,'1','194','1012',460,'Retail Sale Id 1354385',998.40,0.00,0.00,1.56,112.32,'2021-12-17 16:04:57','',''),(2307279,'1','194','1012',460,'Retail Sale Id 1354434',24000.00,0.00,0.00,37.50,2700.00,'2021-12-17 16:09:04','',''),(2307298,'1','194','1012',460,'Retail Sale Id 1354453',1920.00,0.00,0.00,3.00,216.00,'2021-12-17 16:11:10','',''),(2307345,'1','194','1012',460,'Retail Sale Id 1354498',2003.20,0.00,0.00,3.13,225.36,'2021-12-17 16:15:04','',''),(2307549,'1','194','1012',460,'Retail Sale Id 1354715',8000.00,0.00,0.00,12.50,900.00,'2021-12-17 16:33:22','',''),(2307589,'1','194','1012',460,'Retail Sale Id 1354746',2003.20,0.00,0.00,3.13,225.36,'2021-12-17 16:38:20','',''),(2307625,'1','194','1012',460,'Retail Sale Id 1354784',8000.00,0.00,0.00,12.50,900.00,'2021-12-17 16:41:45','',''),(2307646,'1','194','1012',460,'Retail Sale Id 1354813',3840.00,0.00,0.00,6.00,432.00,'2021-12-17 16:44:01','',''),(2307655,'1','194','1012',460,'Retail Sale Id 1354827',8000.00,0.00,0.00,12.50,900.00,'2021-12-17 16:45:28','',''),(2307689,'1','194','1012',460,'Retail Sale Id 1354837',1299.20,0.00,0.00,2.03,146.16,'2021-12-17 16:48:05','',''),(2307733,'1','194','1012',460,'Retail Sale Id 1354872',3840.00,0.00,0.00,6.00,432.00,'2021-12-17 16:50:47','',''),(2307762,'1','194','1012',460,'Retail Sale Id 1354896',3200.00,0.00,0.00,5.00,360.00,'2021-12-17 16:53:58','',''),(2308082,'1','194','1012',460,'Retail Sale Id 1355147',10240.00,0.00,0.00,16.00,1152.00,'2021-12-17 17:35:36','',''),(2308088,'1','194','1012',460,'Retail Sale Id 1355153',57800.00,0.00,0.00,100.00,1000.00,'2021-12-17 17:37:31','',''),(2308100,'1','194','1012',460,'Retail Sale Id 1355162',11200.00,0.00,0.00,17.50,1260.00,'2021-12-17 17:39:15','',''),(2308109,'1','194','1012',460,'Retail Sale Id 1355171',12243.20,0.00,0.00,19.13,1377.36,'2021-12-17 17:40:55','',''),(2308127,'1','194','1012',460,'Retail Sale Id 1355184',23040.00,0.00,0.00,36.00,2592.00,'2021-12-17 17:44:11','',''),(2308133,'1','194','1012',460,'Retail Sale Id 1355190',27426.10,0.00,0.00,47.45,474.50,'2021-12-17 17:45:29','',''),(2308148,'1','194','1012',460,'Retail Sale Id 1355201',26327.90,0.00,0.00,45.55,455.50,'2021-12-17 17:48:02','',''),(2308156,'1','194','1012',460,'Retail Sale Id 1355214',19308.80,0.00,0.00,30.17,2172.24,'2021-12-17 17:49:35','',''),(2308159,'1','194','1012',460,'Retail Sale Id 1355217',5120.00,0.00,0.00,8.00,576.00,'2021-12-17 17:50:45','',''),(2308164,'1','194','1012',460,'Retail Sale Id 1355223',3840.00,0.00,0.00,6.00,432.00,'2021-12-17 17:52:05','',''),(2308212,'1','194','1012',460,'Retail Sale Id 1355238',4000.00,0.00,0.00,6.25,450.00,'2021-12-17 17:55:19','',''),(2308219,'1','194','1012',460,'Retail Sale Id 1355242',3801.60,0.00,0.00,5.94,427.68,'2021-12-17 17:56:22','',''),(2308250,'1','194','1012',460,'Retail Sale Id 1355266',134934.10,0.00,0.00,233.45,2334.50,'2021-12-17 18:02:14','',''),(2308309,'1','194','1012',460,'Retail Sale Id 1355297',222630.40,0.00,0.00,347.86,25045.92,'2021-12-17 18:10:36','',''),(2308465,'1','194','1012',460,'Retail Sale Id 1355387',5696.00,0.00,0.00,8.90,640.80,'2021-12-17 18:50:20','',''),(2308467,'1','194','1012',460,'Retail Sale Id 1355389',26010.00,0.00,0.00,45.00,450.00,'2021-12-17 18:52:22','',''),(2309152,'1','194','1012',460,'Retail Sale Id 1355554',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 06:28:06','',''),(2309155,'1','194','1012',460,'Retail Sale Id 1355557',5120.00,0.00,0.00,8.00,576.00,'2021-12-18 06:29:20','',''),(2309163,'1','194','1012',460,'Retail Sale Id 1355565',8320.00,0.00,0.00,13.00,936.00,'2021-12-18 06:31:08','',''),(2309171,'1','194','1012',460,'Retail Sale Id 1355572',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 06:32:36','',''),(2309239,'1','194','1012',460,'Retail Sale Id 1355637',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 06:40:35','',''),(2309250,'1','194','1012',460,'Retail Sale Id 1355647',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 06:41:31','',''),(2309261,'1','194','1012',460,'Retail Sale Id 1355659',30056.00,0.00,0.00,52.00,520.00,'2021-12-18 06:42:47','',''),(2309385,'1','194','1012',460,'Retail Sale Id 1355761',11840.00,0.00,0.00,18.50,1332.00,'2021-12-18 06:54:04','',''),(2309413,'1','194','1012',460,'Retail Sale Id 1355788',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 06:56:01','',''),(2309478,'1','194','1012',460,'Retail Sale Id 1355839',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 07:00:57','',''),(2309488,'1','194','1012',460,'Retail Sale Id 1355845',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 07:01:56','',''),(2309515,'1','194','1012',460,'Retail Sale Id 1355865',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 07:03:19','',''),(2309532,'1','194','1012',460,'Retail Sale Id 1355876',26010.00,0.00,0.00,45.00,450.00,'2021-12-18 07:04:39','',''),(2309560,'1','194','1012',460,'Retail Sale Id 1355889',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 07:05:37','',''),(2309613,'1','194','1012',460,'Retail Sale Id 1355918',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 07:11:07','',''),(2309639,'1','194','1012',460,'Retail Sale Id 1355960',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 07:13:11','',''),(2309662,'1','194','1012',460,'Retail Sale Id 1355974',57222.00,0.00,0.00,99.00,990.00,'2021-12-18 07:15:01','',''),(2309727,'1','194','1012',460,'Retail Sale Id 1356029',28900.00,0.00,0.00,50.00,500.00,'2021-12-18 07:20:56','',''),(2309773,'1','194','1012',460,'Retail Sale Id 1356053',3852.80,0.00,0.00,6.02,433.44,'2021-12-18 07:23:33','',''),(2309808,'1','194','1012',460,'Retail Sale Id 1356087',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 07:26:12','',''),(2309848,'1','194','1012',460,'Retail Sale Id 1356116',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 07:30:34','',''),(2309871,'1','194','1012',460,'Retail Sale Id 1356136',9920.00,0.00,0.00,15.50,1116.00,'2021-12-18 07:33:21','',''),(2309918,'1','194','1012',460,'Retail Sale Id 1356172',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 07:37:50','',''),(2309930,'1','194','1012',460,'Retail Sale Id 1356184',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 07:39:07','',''),(2309943,'1','194','1012',460,'Retail Sale Id 1356197',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 07:40:12','',''),(2309992,'1','194','1012',460,'Retail Sale Id 1356245',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 07:44:09','',''),(2310059,'1','194','1012',460,'Retail Sale Id 1356279',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 07:47:00','',''),(2310085,'1','194','1012',460,'Retail Sale Id 1356300',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 07:48:41','',''),(2310103,'1','194','1012',460,'Retail Sale Id 1356315',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 07:50:41','',''),(2310111,'1','194','1012',460,'Retail Sale Id 1356322',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 07:51:44','',''),(2310128,'1','194','1012',460,'Retail Sale Id 1356339',9600.00,0.00,0.00,15.00,1080.00,'2021-12-18 07:53:13','',''),(2310131,'1','194','1012',460,'Return of Retail Sale Id 1356339',0.00,9600.00,15.00,0.00,-1080.00,'2021-12-18 07:53:38','',''),(2310253,'1','194','1012',460,'Retail Sale Id 1356455',22400.00,0.00,0.00,35.00,2520.00,'2021-12-18 08:05:37','',''),(2310260,'1','194','1012',460,'Retail Sale Id 1356464',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 08:06:29','',''),(2310291,'1','194','1012',460,'Retail Sale Id 1356480',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 08:08:01','',''),(2310311,'1','194','1012',460,'Retail Sale Id 1356492',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 08:09:14','',''),(2310344,'1','194','1012',460,'Retail Sale Id 1356505',55600.00,0.00,0.00,100.00,-1200.00,'2021-12-18 08:11:08','',''),(2310370,'1','194','1012',460,'Retail Sale Id 1356515',30580.00,0.00,0.00,55.00,-660.00,'2021-12-18 08:12:56','',''),(2310415,'1','194','1012',460,'Retail Sale Id 1356555',24000.00,0.00,0.00,37.50,2700.00,'2021-12-18 08:18:00','',''),(2310534,'1','194','1012',460,'Retail Sale Id 1356650',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 08:25:48','',''),(2310570,'1','194','1012',460,'Retail Sale Id 1356681',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 08:28:30','',''),(2310600,'1','194','1012',460,'Retail Sale Id 1356706',9920.00,0.00,0.00,15.50,1116.00,'2021-12-18 08:30:43','',''),(2310609,'1','194','1012',460,'Retail Sale Id 1356717',640.00,0.00,0.00,1.00,72.00,'2021-12-18 08:31:59','',''),(2310639,'1','194','1012',460,'Retail Sale Id 1356732',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 08:33:11','',''),(2310655,'1','194','1012',460,'Retail Sale Id 1356747',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 08:34:46','',''),(2310671,'1','194','1012',460,'Retail Sale Id 1356764',6400.00,0.00,0.00,10.00,720.00,'2021-12-18 08:36:22','',''),(2310703,'1','194','1012',460,'Retail Sale Id 1356797',55044.00,0.00,0.00,99.00,-1188.00,'2021-12-18 08:39:18','',''),(2310724,'1','194','1012',460,'Retail Sale Id 1356821',61160.00,0.00,0.00,110.00,-1320.00,'2021-12-18 08:41:03','',''),(2310746,'1','194','1012',460,'Retail Sale Id 1356841',6400.00,0.00,0.00,10.00,720.00,'2021-12-18 08:42:46','',''),(2310787,'1','194','1012',460,'Retail Sale Id 1356878',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 08:47:31','',''),(2310802,'1','194','1012',460,'Retail Sale Id 1356895',3001.60,0.00,0.00,4.69,337.68,'2021-12-18 08:48:52','',''),(2311002,'1','194','1012',460,'Retail Sale Id 1357018',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 09:03:55','',''),(2311019,'1','194','1012',460,'Retail Sale Id 1357086',289120.00,0.00,0.00,520.00,-6240.00,'2021-12-18 09:05:59','',''),(2311183,'1','194','1012',460,'Retail Sale Id 1357193',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 09:16:23','',''),(2311195,'1','194','1012',460,'Retail Sale Id 1357204',6400.00,0.00,0.00,10.00,720.00,'2021-12-18 09:17:47','',''),(2311208,'1','194','1012',460,'Retail Sale Id 1357214',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 09:19:37','',''),(2311298,'1','194','1012',460,'Retail Sale Id 1357313',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 09:29:09','',''),(2311508,'1','194','1012',460,'Retail Sale Id 1357518',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 09:49:40','',''),(2311545,'1','194','1012',460,'Retail Sale Id 1357554',640.00,0.00,0.00,1.00,72.00,'2021-12-18 09:52:41','',''),(2311634,'1','194','1012',460,'Retail Sale Id 1357604',3001.60,0.00,0.00,4.69,337.68,'2021-12-18 09:57:32','',''),(2311693,'1','194','1012',460,'Retail Sale Id 1357655',640.00,0.00,0.00,1.00,72.00,'2021-12-18 10:04:09','',''),(2311726,'1','194','1012',460,'Retail Sale Id 1357688',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 10:07:22','',''),(2311754,'1','194','1012',460,'Retail Sale Id 1357712',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 10:09:47','',''),(2311834,'1','194','1012',460,'Retail Sale Id 1357771',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 10:17:22','',''),(2311880,'1','194','1012',460,'Retail Sale Id 1357799',5760.00,0.00,0.00,9.00,648.00,'2021-12-18 10:20:24','',''),(2311898,'1','194','1012',460,'Retail Sale Id 1357807',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 10:21:39','',''),(2311962,'1','194','1012',460,'Retail Sale Id 1357868',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 10:26:00','',''),(2312001,'1','194','1012',460,'Retail Sale Id 1357908',11200.00,0.00,0.00,17.50,1260.00,'2021-12-18 10:30:13','',''),(2312022,'1','194','1012',460,'Retail Sale Id 1357930',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 10:31:37','',''),(2312032,'1','194','1012',460,'Retail Sale Id 1357938',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 10:32:39','',''),(2312052,'1','194','1012',460,'Retail Sale Id 1357949',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 10:33:43','',''),(2312087,'1','194','1012',460,'Retail Sale Id 1357979',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 10:36:06','',''),(2312119,'1','194','1012',460,'Retail Sale Id 1358015',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 10:38:39','',''),(2312136,'1','194','1012',460,'Retail Sale Id 1358033',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 10:40:07','',''),(2312157,'1','194','1012',460,'Retail Sale Id 1358054',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 10:41:40','',''),(2312308,'1','194','1012',460,'Retail Sale Id 1358192',91740.00,0.00,0.00,165.00,-1980.00,'2021-12-18 10:54:42','',''),(2312328,'1','194','1012',460,'Retail Sale Id 1358213',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 10:56:12','',''),(2312440,'1','194','1012',460,'Retail Sale Id 1358307',3801.60,0.00,0.00,5.94,427.68,'2021-12-18 11:05:27','',''),(2312470,'1','194','1012',460,'Retail Sale Id 1358333',3302.40,0.00,0.00,5.16,371.52,'2021-12-18 11:07:28','',''),(2312490,'1','194','1012',460,'Retail Sale Id 1358353',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 11:09:04','',''),(2312524,'1','194','1012',460,'Retail Sale Id 1358380',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 11:11:10','',''),(2312610,'1','194','1012',460,'Retail Sale Id 1358430',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 11:16:31','',''),(2312635,'1','194','1012',460,'Retail Sale Id 1358448',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 11:18:08','',''),(2312779,'1','194','1012',460,'Retail Sale Id 1358589',55600.00,0.00,0.00,100.00,-1200.00,'2021-12-18 11:30:16','',''),(2312801,'1','194','1012',460,'Retail Sale Id 1358611',5203.20,0.00,0.00,8.13,585.36,'2021-12-18 11:31:31','',''),(2312850,'1','194','1012',460,'Retail Sale Id 1358667',3801.60,0.00,0.00,5.94,427.68,'2021-12-18 11:36:21','',''),(2312901,'1','194','1012',460,'Retail Sale Id 1358712',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 11:40:32','',''),(2312914,'1','194','1012',460,'Retail Sale Id 1358724',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 11:41:33','',''),(2312962,'1','194','1012',460,'Retail Sale Id 1358773',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 11:47:16','',''),(2312997,'1','194','1012',460,'Retail Sale Id 1358801',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 11:51:28','',''),(2313011,'1','194','1012',460,'Retail Sale Id 1358818',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 11:52:54','',''),(2313076,'1','194','1012',460,'Retail Sale Id 1358879',10003.20,0.00,0.00,15.63,1125.36,'2021-12-18 12:01:57','',''),(2313151,'1','194','1012',460,'Retail Sale Id 1358942',1299.20,0.00,0.00,2.03,146.16,'2021-12-18 12:09:36','',''),(2313290,'1','194','1012',460,'Retail Sale Id 1359088',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 12:23:48','',''),(2313317,'1','194','1012',460,'Retail Sale Id 1359109',640.00,0.00,0.00,1.00,72.00,'2021-12-18 12:26:38','',''),(2313328,'1','194','1012',460,'Retail Sale Id 1359121',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 12:28:14','',''),(2313426,'1','194','1012',460,'Retail Sale Id 1359208',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 12:38:14','',''),(2313485,'1','194','1012',460,'Retail Sale Id 1359252',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 12:42:17','',''),(2313502,'1','194','1012',460,'Retail Sale Id 1359271',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 12:44:06','',''),(2313542,'1','194','1012',460,'Retail Sale Id 1359314',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 12:47:51','',''),(2313562,'1','194','1012',460,'Retail Sale Id 1359334',25020.00,0.00,0.00,45.00,-540.00,'2021-12-18 12:50:11','',''),(2313602,'1','194','1012',460,'Retail Sale Id 1359375',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 12:53:27','',''),(2313618,'1','194','1012',460,'Retail Sale Id 1359384',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 12:54:46','',''),(2313637,'1','194','1012',460,'Retail Sale Id 1359407',1497.60,0.00,0.00,2.34,168.48,'2021-12-18 12:56:32','',''),(2313649,'1','194','1012',460,'Retail Sale Id 1359421',4499.20,0.00,0.00,7.03,506.16,'2021-12-18 12:57:27','',''),(2313673,'1','194','1012',460,'Retail Sale Id 1359439',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 12:59:30','',''),(2313748,'1','194','1012',460,'Retail Sale Id 1359513',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 13:06:28','',''),(2313764,'1','194','1012',460,'Retail Sale Id 1359516',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 13:07:32','',''),(2313798,'1','194','1012',460,'Retail Sale Id 1359538',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 13:10:38','',''),(2313885,'1','194','1012',460,'Retail Sale Id 1359619',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 13:19:05','',''),(2313901,'1','194','1012',460,'Retail Sale Id 1359643',81732.00,0.00,0.00,147.00,-1764.00,'2021-12-18 13:20:57','',''),(2313963,'1','194','1012',460,'Retail Sale Id 1359670',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 13:24:47','',''),(2313990,'1','194','1012',460,'Retail Sale Id 1359695',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 13:27:45','',''),(2314020,'1','194','1012',460,'Retail Sale Id 1359731',15040.00,0.00,0.00,23.50,1692.00,'2021-12-18 13:32:21','',''),(2314028,'1','194','1012',460,'Retail Sale Id 1359742',7680.00,0.00,0.00,12.00,864.00,'2021-12-18 13:33:37','',''),(2314050,'1','194','1012',460,'Retail Sale Id 1359767',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 13:35:41','',''),(2314061,'1','194','1012',460,'Retail Sale Id 1359779',2598.40,0.00,0.00,4.06,292.32,'2021-12-18 13:36:51','',''),(2314098,'1','194','1012',460,'Retail Sale Id 1359793',55600.00,0.00,0.00,100.00,-1200.00,'2021-12-18 13:40:35','',''),(2314119,'1','194','1012',460,'Retail Sale Id 1359835',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 13:42:17','',''),(2314344,'1','194','1012',460,'Retail Sale Id 1359938',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 13:52:52','',''),(2314367,'1','194','1012',460,'Retail Sale Id 1359970',32248.00,0.00,0.00,58.00,-696.00,'2021-12-18 13:55:15','',''),(2314409,'1','194','1012',460,'Retail Sale Id 1360000',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 13:58:02','',''),(2314427,'1','194','1012',460,'Retail Sale Id 1360010',11520.00,0.00,0.00,18.00,1296.00,'2021-12-18 14:00:02','',''),(2314447,'1','194','1012',460,'Retail Sale Id 1360041',640.00,0.00,0.00,1.00,72.00,'2021-12-18 14:02:31','',''),(2315489,'1','194','1012',460,'Retail Sale Id 1360918',998.40,0.00,0.00,1.56,112.32,'2021-12-18 15:27:34','',''),(2315529,'1','194','1012',460,'Retail Sale Id 1360960',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 15:30:44','',''),(2315545,'1','194','1012',460,'Retail Sale Id 1360976',1299.20,0.00,0.00,2.03,146.16,'2021-12-18 15:32:21','',''),(2315582,'1','194','1012',460,'Retail Sale Id 1361009',5120.00,0.00,0.00,8.00,576.00,'2021-12-18 15:35:09','',''),(2315620,'1','194','1012',460,'Retail Sale Id 1361050',2502.40,0.00,0.00,3.91,281.52,'2021-12-18 15:38:00','',''),(2315633,'1','194','1012',460,'Retail Sale Id 1361061',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 15:39:07','',''),(2315664,'1','194','1012',460,'Retail Sale Id 1361093',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 15:41:20','',''),(2315678,'1','194','1012',460,'Retail Sale Id 1361108',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 15:42:36','',''),(2315719,'1','194','1012',460,'Retail Sale Id 1361134',1299.20,0.00,0.00,2.03,146.16,'2021-12-18 15:45:31','',''),(2315730,'1','194','1012',460,'Retail Sale Id 1361151',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 15:46:28','',''),(2315752,'1','194','1012',460,'Retail Sale Id 1361164',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 15:47:17','',''),(2315768,'1','194','1012',460,'Retail Sale Id 1361181',998.40,0.00,0.00,1.56,112.32,'2021-12-18 15:48:16','',''),(2315789,'1','194','1012',460,'Retail Sale Id 1361191',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 15:49:16','',''),(2315812,'1','194','1012',460,'Retail Sale Id 1361203',16640.00,0.00,0.00,26.00,1872.00,'2021-12-18 15:50:10','',''),(2315844,'1','194','1012',460,'Retail Sale Id 1361216',74504.00,0.00,0.00,134.00,-1608.00,'2021-12-18 15:51:02','',''),(2315878,'1','194','1012',460,'Retail Sale Id 1361243',8768.00,0.00,0.00,13.70,986.40,'2021-12-18 15:52:54','',''),(2315911,'1','194','1012',460,'Retail Sale Id 1361254',7040.00,0.00,0.00,11.00,792.00,'2021-12-18 15:54:59','',''),(2315927,'1','194','1012',460,'Retail Sale Id 1361285',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 15:55:51','',''),(2315965,'1','194','1012',460,'Retail Sale Id 1361308',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 15:57:55','',''),(2316016,'1','194','1012',460,'Retail Sale Id 1361348',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:00:20','',''),(2316041,'1','194','1012',460,'Retail Sale Id 1361363',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:01:30','',''),(2316055,'1','194','1012',460,'Retail Sale Id 1361378',3001.60,0.00,0.00,4.69,337.68,'2021-12-18 16:02:28','',''),(2316067,'1','194','1012',460,'Retail Sale Id 1361390',1900.80,0.00,0.00,2.97,213.84,'2021-12-18 16:03:36','',''),(2316088,'1','194','1012',460,'Retail Sale Id 1361412',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 16:05:01','',''),(2316105,'1','194','1012',460,'Retail Sale Id 1361429',998.40,0.00,0.00,1.56,112.32,'2021-12-18 16:06:14','',''),(2316117,'1','194','1012',460,'Retail Sale Id 1361442',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 16:07:10','',''),(2316136,'1','194','1012',460,'Retail Sale Id 1361461',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:08:30','',''),(2316163,'1','194','1012',460,'Retail Sale Id 1361487',5760.00,0.00,0.00,9.00,648.00,'2021-12-18 16:10:26','',''),(2316176,'1','194','1012',460,'Retail Sale Id 1361498',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 16:11:20','',''),(2316201,'1','194','1012',460,'Retail Sale Id 1361519',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 16:13:13','',''),(2316221,'1','194','1012',460,'Retail Sale Id 1361539',11840.00,0.00,0.00,18.50,1332.00,'2021-12-18 16:14:23','',''),(2316265,'1','194','1012',460,'Retail Sale Id 1361567',113980.00,0.00,0.00,205.00,-2460.00,'2021-12-18 16:16:31','',''),(2316273,'1','194','1012',460,'Retail Sale Id 1361576',10816.00,0.00,0.00,16.90,1216.80,'2021-12-18 16:17:35','',''),(2316287,'1','194','1012',460,'Retail Sale Id 1361591',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 16:18:36','',''),(2316299,'1','194','1012',460,'Retail Sale Id 1361603',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:19:41','',''),(2316318,'1','194','1012',460,'Retail Sale Id 1361619',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 16:21:05','',''),(2316352,'1','194','1012',460,'Retail Sale Id 1361655',10240.00,0.00,0.00,16.00,1152.00,'2021-12-18 16:23:39','',''),(2316365,'1','194','1012',460,'Retail Sale Id 1361667',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 16:24:36','',''),(2316379,'1','194','1012',460,'Retail Sale Id 1361683',640.00,0.00,0.00,1.00,72.00,'2021-12-18 16:25:32','',''),(2316395,'1','194','1012',460,'Retail Sale Id 1361701',8960.00,0.00,0.00,14.00,1008.00,'2021-12-18 16:26:35','',''),(2316405,'1','194','1012',460,'Retail Sale Id 1361709',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 16:27:34','',''),(2316423,'1','194','1012',460,'Retail Sale Id 1361721',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 16:28:54','',''),(2316440,'1','194','1012',460,'Retail Sale Id 1361743',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:29:51','',''),(2316454,'1','194','1012',460,'Retail Sale Id 1361756',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 16:31:11','',''),(2316465,'1','194','1012',460,'Retail Sale Id 1361770',11200.00,0.00,0.00,17.50,1260.00,'2021-12-18 16:32:13','',''),(2316489,'1','194','1012',460,'Retail Sale Id 1361788',27244.00,0.00,0.00,49.00,-588.00,'2021-12-18 16:33:50','',''),(2316499,'1','194','1012',460,'Retail Sale Id 1361805',10880.00,0.00,0.00,17.00,1224.00,'2021-12-18 16:34:50','',''),(2316523,'1','194','1012',460,'Retail Sale Id 1361833',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 16:36:35','',''),(2316544,'1','194','1012',460,'Retail Sale Id 1361855',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 16:38:41','',''),(2316556,'1','194','1012',460,'Retail Sale Id 1361870',1280.00,0.00,0.00,2.00,144.00,'2021-12-18 16:39:43','',''),(2316581,'1','194','1012',460,'Retail Sale Id 1361893',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 16:41:38','',''),(2316592,'1','194','1012',460,'Retail Sale Id 1361904',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:42:24','',''),(2316599,'1','194','1012',460,'Retail Sale Id 1361913',640.00,0.00,0.00,1.00,72.00,'2021-12-18 16:43:12','',''),(2316618,'1','194','1012',460,'Retail Sale Id 1361928',6400.00,0.00,0.00,10.00,720.00,'2021-12-18 16:44:20','',''),(2316644,'1','194','1012',460,'Retail Sale Id 1361940',998.40,0.00,0.00,1.56,112.32,'2021-12-18 16:45:27','',''),(2316656,'1','194','1012',460,'Retail Sale Id 1361951',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 16:46:31','',''),(2316671,'1','194','1012',460,'Retail Sale Id 1361962',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 16:48:13','',''),(2316686,'1','194','1012',460,'Retail Sale Id 1361981',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 16:49:26','',''),(2316704,'1','194','1012',460,'Retail Sale Id 1361998',17792.00,0.00,0.00,32.00,-384.00,'2021-12-18 16:51:04','',''),(2316712,'1','194','1012',460,'Retail Sale Id 1362006',6400.00,0.00,0.00,10.00,720.00,'2021-12-18 16:51:52','',''),(2316741,'1','194','1012',460,'Retail Sale Id 1362030',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:53:49','',''),(2316752,'1','194','1012',460,'Retail Sale Id 1362043',16680.00,0.00,0.00,30.00,-360.00,'2021-12-18 16:54:36','',''),(2316781,'1','194','1012',460,'Retail Sale Id 1362055',16680.00,0.00,0.00,30.00,-360.00,'2021-12-18 16:56:25','',''),(2316797,'1','194','1012',460,'Retail Sale Id 1362077',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 16:57:34','',''),(2316810,'1','194','1012',460,'Retail Sale Id 1362093',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 16:58:29','',''),(2316826,'1','194','1012',460,'Retail Sale Id 1362110',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 16:59:48','',''),(2316835,'1','194','1012',460,'Retail Sale Id 1362119',8000.00,0.00,0.00,12.50,900.00,'2021-12-18 17:00:40','',''),(2316851,'1','194','1012',460,'Retail Sale Id 1362135',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 17:01:47','',''),(2316893,'1','194','1012',460,'Retail Sale Id 1362179',2003.20,0.00,0.00,3.13,225.36,'2021-12-18 17:06:18','',''),(2316904,'1','194','1012',460,'Retail Sale Id 1362192',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 17:07:44','',''),(2316911,'1','194','1012',460,'Retail Sale Id 1362202',2598.40,0.00,0.00,4.06,292.32,'2021-12-18 17:09:05','',''),(2316935,'1','194','1012',460,'Retail Sale Id 1362224',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 17:11:40','',''),(2317003,'1','194','1012',460,'Retail Sale Id 1362285',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 17:20:21','',''),(2317029,'1','194','1012',460,'Retail Sale Id 1362318',2560.00,0.00,0.00,4.00,288.00,'2021-12-18 17:24:02','',''),(2317066,'1','194','1012',460,'Retail Sale Id 1362355',27800.00,0.00,0.00,50.00,-600.00,'2021-12-18 17:30:21','',''),(2317078,'1','194','1012',460,'Retail Sale Id 1362360',3840.00,0.00,0.00,6.00,432.00,'2021-12-18 17:31:45','',''),(2317084,'1','194','1012',460,'Retail Sale Id 1362370',998.40,0.00,0.00,1.56,112.32,'2021-12-18 17:33:01','',''),(2317090,'1','194','1012',460,'Retail Sale Id 1362376',640.00,0.00,0.00,1.00,72.00,'2021-12-18 17:34:05','',''),(2317099,'1','194','1012',460,'Retail Sale Id 1362383',998.40,0.00,0.00,1.56,112.32,'2021-12-18 17:34:55','',''),(2317106,'1','194','1012',460,'Retail Sale Id 1362390',12800.00,0.00,0.00,20.00,1440.00,'2021-12-18 17:36:17','',''),(2317116,'1','194','1012',460,'Retail Sale Id 1362399',1920.00,0.00,0.00,3.00,216.00,'2021-12-18 17:37:55','',''),(2317124,'1','194','1012',460,'Retail Sale Id 1362407',3200.00,0.00,0.00,5.00,360.00,'2021-12-18 17:39:01','',''),(2317386,'1','194','1012',460,'Return of Retail Sale Id 1355974',0.00,57222.00,99.00,0.00,-990.00,'2021-12-18 18:19:42','',''),(2317557,'1','194','1012',460,'Retail Sale Id 1362717',5120.00,0.00,0.00,8.00,576.00,'2021-12-18 19:10:06','',''),(2318018,'1','194','1012',460,'Retail Sale Id 1362848',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 06:27:17','',''),(2318042,'1','194','1012',460,'Retail Sale Id 1362851',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 06:29:13','',''),(2318048,'1','194','1012',460,'Retail Sale Id 1362857',4480.00,0.00,0.00,7.00,504.00,'2021-12-19 06:31:04','',''),(2318052,'1','194','1012',460,'Retail Sale Id 1362861',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 06:32:37','',''),(2318078,'1','194','1012',460,'Retail Sale Id 1362870',27244.00,0.00,0.00,49.00,-588.00,'2021-12-19 06:37:23','',''),(2318088,'1','194','1012',460,'Retail Sale Id 1362893',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 06:39:01','',''),(2318098,'1','194','1012',460,'Retail Sale Id 1362899',11200.00,0.00,0.00,17.50,1260.00,'2021-12-19 06:40:31','',''),(2318137,'1','194','1012',460,'Retail Sale Id 1362936',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 06:45:03','',''),(2318215,'1','194','1012',460,'Retail Sale Id 1363006',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 06:53:26','',''),(2318242,'1','194','1012',460,'Retail Sale Id 1363031',33360.00,0.00,0.00,60.00,-720.00,'2021-12-19 06:55:48','',''),(2318259,'1','194','1012',460,'Retail Sale Id 1363048',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 06:58:01','',''),(2318305,'1','194','1012',460,'Retail Sale Id 1363096',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 07:03:34','',''),(2318455,'1','194','1012',460,'Retail Sale Id 1363219',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 07:16:45','',''),(2318470,'1','194','1012',460,'Retail Sale Id 1363231',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 07:17:57','',''),(2318551,'1','194','1012',460,'Retail Sale Id 1363319',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 07:25:34','',''),(2318597,'1','194','1012',460,'Retail Sale Id 1363365',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 07:29:45','',''),(2318620,'1','194','1012',460,'Retail Sale Id 1363384',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 07:31:08','',''),(2318640,'1','194','1012',460,'Retail Sale Id 1363408',83400.00,0.00,0.00,150.00,-1800.00,'2021-12-19 07:32:51','',''),(2318683,'1','194','1012',460,'Retail Sale Id 1363454',11840.00,0.00,0.00,18.50,1332.00,'2021-12-19 07:37:27','',''),(2318705,'1','194','1012',460,'Retail Sale Id 1363464',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 07:38:17','',''),(2318712,'1','194','1012',460,'Retail Sale Id 1363472',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 07:39:10','',''),(2318721,'1','194','1012',460,'Retail Sale Id 1363481',41700.00,0.00,0.00,75.00,-900.00,'2021-12-19 07:40:21','',''),(2318749,'1','194','1012',460,'Retail Sale Id 1363507',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 07:42:30','',''),(2318759,'1','194','1012',460,'Retail Sale Id 1363516',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 07:43:26','',''),(2318771,'1','194','1012',460,'Retail Sale Id 1363526',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 07:44:17','',''),(2318820,'1','194','1012',460,'Retail Sale Id 1363573',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 07:49:50','',''),(2318863,'1','194','1012',460,'Retail Sale Id 1363588',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 07:51:13','',''),(2318928,'1','194','1012',460,'Retail Sale Id 1363618',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 07:55:27','',''),(2318944,'1','194','1012',460,'Retail Sale Id 1363638',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 07:57:19','',''),(2319107,'1','194','1012',460,'Retail Sale Id 1363781',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 08:13:13','',''),(2319149,'1','194','1012',460,'Retail Sale Id 1363822',25020.00,0.00,0.00,45.00,-540.00,'2021-12-19 08:18:43','',''),(2319229,'1','194','1012',460,'Retail Sale Id 1363870',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 08:24:06','',''),(2319274,'1','194','1012',460,'Retail Sale Id 1363910',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 08:26:44','',''),(2319282,'1','194','1012',460,'Return of Retail Sale Id 1363910',0.00,3840.00,6.00,0.00,-432.00,'2021-12-19 08:27:07','',''),(2319357,'1','194','1012',460,'Retail Sale Id 1363992',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 08:33:25','',''),(2319447,'1','194','1012',460,'Retail Sale Id 1364022',2560.00,0.00,0.00,4.00,288.00,'2021-12-19 08:36:34','',''),(2319559,'1','194','1012',460,'Retail Sale Id 1364099',800.00,0.00,0.00,1.25,90.00,'2021-12-19 08:45:40','',''),(2319597,'1','194','1012',460,'Retail Sale Id 1364119',6400.00,0.00,0.00,10.00,720.00,'2021-12-19 08:49:35','',''),(2319685,'1','194','1012',460,'Retail Sale Id 1364213',2560.00,0.00,0.00,4.00,288.00,'2021-12-19 09:01:19','',''),(2319697,'1','194','1012',460,'Retail Sale Id 1364221',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 09:02:58','',''),(2319715,'1','194','1012',460,'Retail Sale Id 1364245',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 09:06:11','',''),(2319745,'1','194','1012',460,'Retail Sale Id 1364262',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 09:08:02','',''),(2319753,'1','194','1012',460,'Retail Sale Id 1364272',998.40,0.00,0.00,1.56,112.32,'2021-12-19 09:09:28','',''),(2319833,'1','194','1012',460,'Retail Sale Id 1364316',6400.00,0.00,0.00,10.00,720.00,'2021-12-19 09:14:51','',''),(2320025,'1','194','1012',460,'Retail Sale Id 1364413',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 09:23:24','',''),(2320218,'1','194','1012',460,'Retail Sale Id 1364539',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 09:33:05','',''),(2320262,'1','194','1012',460,'Retail Sale Id 1364583',998.40,0.00,0.00,1.56,112.32,'2021-12-19 09:36:53','',''),(2320350,'1','194','1012',460,'Retail Sale Id 1364672',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 09:43:28','',''),(2320360,'1','194','1012',460,'Retail Sale Id 1364681',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 09:44:14','',''),(2320522,'1','194','1012',460,'Retail Sale Id 1364832',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 09:59:08','',''),(2320533,'1','194','1012',460,'Retail Sale Id 1364856',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 10:00:12','',''),(2320544,'1','194','1012',460,'Retail Sale Id 1364869',2003.20,0.00,0.00,3.13,225.36,'2021-12-19 10:01:26','',''),(2320574,'1','194','1012',460,'Retail Sale Id 1364896',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 10:03:39','',''),(2320600,'1','194','1012',460,'Retail Sale Id 1364914',33360.00,0.00,0.00,60.00,-720.00,'2021-12-19 10:05:35','',''),(2320621,'1','194','1012',460,'Retail Sale Id 1364941',1401.60,0.00,0.00,2.19,157.68,'2021-12-19 10:07:13','',''),(2320680,'1','194','1012',460,'Retail Sale Id 1364988',22240.00,0.00,0.00,40.00,-480.00,'2021-12-19 10:11:15','',''),(2320717,'1','194','1012',460,'Retail Sale Id 1365022',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 10:13:17','',''),(2320732,'1','194','1012',460,'Retail Sale Id 1365043',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 10:14:46','',''),(2320751,'1','194','1012',460,'Retail Sale Id 1365065',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 10:16:23','',''),(2320799,'1','194','1012',460,'Retail Sale Id 1365115',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 10:20:41','',''),(2320842,'1','194','1012',460,'Retail Sale Id 1365158',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 10:24:34','',''),(2320893,'1','194','1012',460,'Retail Sale Id 1365205',640.00,0.00,0.00,1.00,72.00,'2021-12-19 10:28:18','',''),(2320927,'1','194','1012',460,'Retail Sale Id 1365227',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 10:29:40','',''),(2320964,'1','194','1012',460,'Retail Sale Id 1365252',9920.00,0.00,0.00,15.50,1116.00,'2021-12-19 10:32:35','',''),(2321001,'1','194','1012',460,'Retail Sale Id 1365307',1299.20,0.00,0.00,2.03,146.16,'2021-12-19 10:36:53','',''),(2321009,'1','194','1012',460,'Retail Sale Id 1365318',640.00,0.00,0.00,1.00,72.00,'2021-12-19 10:37:58','',''),(2321020,'1','194','1012',460,'Retail Sale Id 1365328',26132.00,0.00,0.00,47.00,-564.00,'2021-12-19 10:38:57','',''),(2321036,'1','194','1012',460,'Retail Sale Id 1365347',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 10:41:00','',''),(2321053,'1','194','1012',460,'Retail Sale Id 1365359',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 10:41:53','',''),(2321100,'1','194','1012',460,'Retail Sale Id 1365407',5760.00,0.00,0.00,9.00,648.00,'2021-12-19 10:46:53','',''),(2321139,'1','194','1012',460,'Retail Sale Id 1365443',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 10:49:42','',''),(2321270,'1','194','1012',460,'Retail Sale Id 1365582',2003.20,0.00,0.00,3.13,225.36,'2021-12-19 11:00:59','',''),(2321284,'1','194','1012',460,'Retail Sale Id 1365591',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 11:02:08','',''),(2321313,'1','194','1012',460,'Retail Sale Id 1365626',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 11:04:43','',''),(2321360,'1','194','1012',460,'Retail Sale Id 1365670',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 11:08:20','',''),(2321378,'1','194','1012',460,'Retail Sale Id 1365686',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 11:09:30','',''),(2321390,'1','194','1012',460,'Retail Sale Id 1365701',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 11:10:22','',''),(2321443,'1','194','1012',460,'Retail Sale Id 1365735',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 11:13:43','',''),(2321605,'1','194','1012',460,'Retail Sale Id 1365879',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 11:26:18','',''),(2321683,'1','194','1012',460,'Retail Sale Id 1365964',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 11:33:28','',''),(2321932,'1','194','1012',460,'Retail Sale Id 1366189',61160.00,0.00,0.00,110.00,-1320.00,'2021-12-19 11:54:02','',''),(2321941,'1','194','1012',460,'Retail Sale Id 1366198',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 11:54:49','',''),(2321982,'1','194','1012',460,'Retail Sale Id 1366240',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 11:58:41','',''),(2321995,'1','194','1012',460,'Retail Sale Id 1366250',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 11:59:44','',''),(2322010,'1','194','1012',460,'Retail Sale Id 1366266',2003.20,0.00,0.00,3.13,225.36,'2021-12-19 12:00:57','',''),(2322069,'1','194','1012',460,'Retail Sale Id 1366329',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 12:06:04','',''),(2322090,'1','194','1012',460,'Return of Retail Sale Id 1366189',0.00,61160.00,110.00,0.00,1320.00,'2021-12-19 12:08:00','',''),(2322158,'1','194','1012',460,'Retail Sale Id 1366415',4480.00,0.00,0.00,7.00,504.00,'2021-12-19 12:14:25','',''),(2322179,'1','194','1012',460,'Retail Sale Id 1366439',6400.00,0.00,0.00,10.00,720.00,'2021-12-19 12:15:55','',''),(2322196,'1','194','1012',460,'Retail Sale Id 1366456',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 12:17:23','',''),(2322244,'1','194','1012',460,'Retail Sale Id 1366504',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 12:21:39','',''),(2322276,'1','194','1012',460,'Retail Sale Id 1366533',28912.00,0.00,0.00,52.00,-624.00,'2021-12-19 12:25:09','',''),(2322400,'1','194','1012',460,'Retail Sale Id 1366654',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 12:39:19','',''),(2322499,'1','194','1012',460,'Retail Sale Id 1366722',139000.00,0.00,0.00,250.00,-3000.00,'2021-12-19 12:46:13','',''),(2322541,'1','194','1012',460,'Retail Sale Id 1366764',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 12:49:33','',''),(2322594,'1','194','1012',460,'Retail Sale Id 1366816',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 12:53:59','',''),(2322642,'1','194','1012',460,'Retail Sale Id 1366860',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 12:58:21','',''),(2322818,'1','194','1012',460,'Retail Sale Id 1367033',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 13:14:54','',''),(2322901,'1','194','1012',460,'Retail Sale Id 1367113',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 13:22:46','',''),(2322919,'1','194','1012',460,'Retail Sale Id 1367126',640.00,0.00,0.00,1.00,72.00,'2021-12-19 13:23:47','',''),(2322979,'1','194','1012',460,'Retail Sale Id 1367173',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 13:28:06','',''),(2323021,'1','194','1012',460,'Retail Sale Id 1367201',1299.20,0.00,0.00,2.03,146.16,'2021-12-19 13:31:15','',''),(2323091,'1','194','1012',460,'Retail Sale Id 1367248',4480.00,0.00,0.00,7.00,504.00,'2021-12-19 13:35:35','',''),(2323111,'1','194','1012',460,'Retail Sale Id 1367268',5203.20,0.00,0.00,8.13,585.36,'2021-12-19 13:37:10','',''),(2323130,'1','194','1012',460,'Retail Sale Id 1367284',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 13:39:03','',''),(2323141,'1','194','1012',460,'Retail Sale Id 1367295',3200.00,0.00,0.00,5.00,360.00,'2021-12-19 13:40:02','',''),(2323210,'1','194','1012',460,'Retail Sale Id 1367337',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 13:43:56','',''),(2323345,'1','194','1012',460,'Retail Sale Id 1367450',3840.00,0.00,0.00,6.00,432.00,'2021-12-19 13:55:04','',''),(2323434,'1','194','1012',460,'Retail Sale Id 1367528',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 14:00:08','',''),(2323511,'1','194','1012',460,'Retail Sale Id 1367593',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 14:05:30','',''),(2323641,'1','194','1012',460,'Retail Sale Id 1367694',27800.00,0.00,0.00,50.00,-600.00,'2021-12-19 14:13:59','',''),(2323853,'1','194','1012',460,'Retail Sale Id 1367873',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 14:32:35','',''),(2323901,'1','194','1012',460,'Retail Sale Id 1367898',7040.00,0.00,0.00,11.00,792.00,'2021-12-19 14:37:02','',''),(2323925,'1','194','1012',460,'Retail Sale Id 1367934',3001.60,0.00,0.00,4.69,337.68,'2021-12-19 14:39:10','',''),(2323936,'1','194','1012',460,'Retail Sale Id 1367944',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 14:40:12','',''),(2323947,'1','194','1012',460,'Retail Sale Id 1367956',2560.00,0.00,0.00,4.00,288.00,'2021-12-19 14:41:40','',''),(2324006,'1','194','1012',460,'Retail Sale Id 1368012',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 14:47:02','',''),(2324032,'1','194','1012',460,'Retail Sale Id 1368040',8000.00,0.00,0.00,12.50,900.00,'2021-12-19 14:49:21','',''),(2324043,'1','194','1012',460,'Retail Sale Id 1368052',1497.60,0.00,0.00,2.34,168.48,'2021-12-19 14:50:22','',''),(2324059,'1','194','1012',460,'Retail Sale Id 1368071',1280.00,0.00,0.00,2.00,144.00,'2021-12-19 14:52:05','',''),(2324135,'1','194','1012',460,'Retail Sale Id 1368144',1920.00,0.00,0.00,3.00,216.00,'2021-12-19 15:01:56','',''),(2324227,'1','194','1012',460,'Return of Retail Sale Id 1368040',0.00,8000.00,12.50,0.00,-900.00,'2021-12-19 15:12:17','',''),(2324251,'1','194','1012',460,'Return of Retail Sale Id 1368071',0.00,1280.00,2.00,0.00,-144.00,'2021-12-19 15:13:38','',''),(2324253,'1','194','1012',460,'Return of Retail Sale Id 1368144',0.00,1920.00,3.00,0.00,-216.00,'2021-12-19 15:14:19','',''),(2324265,'1','194','1012',460,'Retail Sale Id 1368260',7040.00,0.00,0.00,11.00,792.00,'2021-12-19 15:15:27','',''),(2324347,'1','194','1012',460,'Return of Retail Sale Id 1367934',0.00,3001.60,4.69,0.00,-337.68,'2021-12-19 15:23:50','',''),(2324384,'1','194','1012',460,'Return of Retail Sale Id 1367173',0.00,3840.00,6.00,0.00,-432.00,'2021-12-19 15:28:18','',''),(2324422,'1','194','1012',460,'Retail Sale Id 1368387',3001.60,0.00,0.00,4.69,337.68,'2021-12-19 15:31:10','',''),(2325349,'1','194','1012',460,'Return of Retail Sale Id 1367528',0.00,1280.00,2.00,0.00,-144.00,'2021-12-19 16:57:20','',''),(2335825,'1','194','1012',460,'Retail Sale Id 1377008',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 10:49:06','',''),(2335888,'1','194','1012',460,'Retail Sale Id 1377050',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 10:55:01','',''),(2335896,'1','194','1012',460,'Retail Sale Id 1377061',0.00,0.00,0.00,27.50,-15620.00,'2021-12-21 10:55:47','',''),(2335906,'1','194','1012',460,'Retail Sale Id 1377068',0.00,0.00,0.00,10.00,-5680.00,'2021-12-21 10:56:41','',''),(2335942,'1','194','1012',460,'Retail Sale Id 1377088',0.00,0.00,0.00,6.00,-3408.00,'2021-12-21 11:00:41','',''),(2335946,'1','194','1012',460,'Retail Sale Id 1377107',0.00,0.00,0.00,10.00,-5680.00,'2021-12-21 11:01:14','',''),(2335953,'1','194','1012',460,'Retail Sale Id 1377112',0.00,0.00,0.00,6.00,-3408.00,'2021-12-21 11:01:49','',''),(2335959,'1','194','1012',460,'Retail Sale Id 1377120',0.00,0.00,0.00,5.00,-2840.00,'2021-12-21 11:02:31','',''),(2335969,'1','194','1012',460,'Retail Sale Id 1377126',0.00,0.00,0.00,15.00,-8520.00,'2021-12-21 11:03:27','',''),(2336078,'1','194','1012',460,'Retail Sale Id 1377217',145950.00,0.00,0.00,262.50,-3150.00,'2021-12-21 11:14:11','',''),(2336091,'1','194','1012',460,'Retail Sale Id 1377232',5120.00,0.00,0.00,8.00,576.00,'2021-12-21 11:15:36','',''),(2336101,'1','194','1012',460,'Retail Sale Id 1377243',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 11:16:29','',''),(2336112,'1','194','1012',460,'Retail Sale Id 1377250',30580.00,0.00,0.00,55.00,-660.00,'2021-12-21 11:17:21','',''),(2336120,'1','194','1012',460,'Retail Sale Id 1377256',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 11:18:05','',''),(2336124,'1','194','1012',460,'Retail Sale Id 1377261',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 11:18:43','',''),(2336136,'1','194','1012',460,'Retail Sale Id 1377271',14003.20,0.00,0.00,21.88,1575.36,'2021-12-21 11:20:01','',''),(2336152,'1','194','1012',460,'Retail Sale Id 1377286',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 11:22:08','',''),(2336159,'1','194','1012',460,'Retail Sale Id 1377295',3001.60,0.00,0.00,4.69,337.68,'2021-12-21 11:22:54','',''),(2336177,'1','194','1012',460,'Retail Sale Id 1377307',55600.00,0.00,0.00,100.00,-1200.00,'2021-12-21 11:24:09','',''),(2336192,'1','194','1012',460,'Retail Sale Id 1377311',4998.40,0.00,0.00,7.81,562.32,'2021-12-21 11:25:18','',''),(2336201,'1','194','1012',460,'Retail Sale Id 1377324',27800.00,0.00,0.00,50.00,-600.00,'2021-12-21 11:26:46','',''),(2336210,'1','194','1012',460,'Retail Sale Id 1377330',3283.20,0.00,0.00,5.13,369.36,'2021-12-21 11:27:50','',''),(2336218,'1','194','1012',460,'Retail Sale Id 1377338',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 11:28:41','',''),(2336222,'1','194','1012',460,'Retail Sale Id 1377342',16000.00,0.00,0.00,25.00,1800.00,'2021-12-21 11:29:16','',''),(2336225,'1','194','1012',460,'Retail Sale Id 1377345',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 11:30:06','',''),(2336235,'1','194','1012',460,'Retail Sale Id 1377356',10240.00,0.00,0.00,16.00,1152.00,'2021-12-21 11:31:35','',''),(2336242,'1','194','1012',460,'Retail Sale Id 1377361',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 11:32:13','',''),(2336249,'1','194','1012',460,'Retail Sale Id 1377368',14400.00,0.00,0.00,22.50,1620.00,'2021-12-21 11:33:11','',''),(2336257,'1','194','1012',460,'Retail Sale Id 1377376',83400.00,0.00,0.00,150.00,-1800.00,'2021-12-21 11:34:53','',''),(2336282,'1','194','1012',460,'Retail Sale Id 1377396',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 11:38:14','',''),(2336288,'1','194','1012',460,'Retail Sale Id 1377406',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 11:39:16','',''),(2336304,'1','194','1012',460,'Retail Sale Id 1377416',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 11:40:50','',''),(2336316,'1','194','1012',460,'Retail Sale Id 1377429',25020.00,0.00,0.00,45.00,-540.00,'2021-12-21 11:42:42','',''),(2336340,'1','194','1012',460,'Retail Sale Id 1377452',2003.20,0.00,0.00,3.13,225.36,'2021-12-21 11:46:30','',''),(2336346,'1','194','1012',460,'Retail Sale Id 1377459',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 11:47:24','',''),(2336446,'1','194','1012',460,'Retail Sale Id 1377539',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 11:58:46','',''),(2336454,'1','194','1012',460,'Retail Sale Id 1377543',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 11:59:30','',''),(2336463,'1','194','1012',460,'Retail Sale Id 1377550',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 12:00:37','',''),(2336469,'1','194','1012',460,'Retail Sale Id 1377557',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 12:01:22','',''),(2336535,'1','194','1012',460,'Retail Sale Id 1377609',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 12:09:04','',''),(2336538,'1','194','1012',460,'Retail Sale Id 1377614',60048.00,0.00,0.00,108.00,-1296.00,'2021-12-21 12:09:58','',''),(2336603,'1','194','1012',460,'Retail Sale Id 1377675',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 12:18:29','',''),(2336621,'1','194','1012',460,'Retail Sale Id 1377690',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 12:19:57','',''),(2336751,'1','194','1012',460,'Retail Sale Id 1377802',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 12:35:10','',''),(2336783,'1','194','1012',460,'Retail Sale Id 1377834',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 12:37:17','',''),(2336789,'1','194','1012',460,'Retail Sale Id 1377843',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 12:38:21','',''),(2336804,'1','194','1012',460,'Retail Sale Id 1377857',6720.00,0.00,0.00,10.50,756.00,'2021-12-21 12:40:03','',''),(2336817,'1','194','1012',460,'Retail Sale Id 1377870',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 12:42:04','',''),(2336825,'1','194','1012',460,'Retail Sale Id 1377879',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 12:43:19','',''),(2336837,'1','194','1012',460,'Retail Sale Id 1377887',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 12:44:24','',''),(2336862,'1','194','1012',460,'Retail Sale Id 1377910',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 12:47:58','',''),(2336882,'1','194','1012',460,'Retail Sale Id 1377942',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 12:50:28','',''),(2336890,'1','194','1012',460,'Retail Sale Id 1377954',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 12:51:59','',''),(2336904,'1','194','1012',460,'Retail Sale Id 1377970',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 12:53:31','',''),(2336962,'1','194','1012',460,'Retail Sale Id 1378008',25020.00,0.00,0.00,45.00,-540.00,'2021-12-21 12:59:03','',''),(2336970,'1','194','1012',460,'Retail Sale Id 1378017',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 13:00:11','',''),(2337046,'1','194','1012',460,'Retail Sale Id 1378084',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 13:07:26','',''),(2337064,'1','194','1012',460,'Retail Sale Id 1378097',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 13:08:37','',''),(2337074,'1','194','1012',460,'Retail Sale Id 1378108',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 13:09:56','',''),(2337098,'1','194','1012',460,'Retail Sale Id 1378122',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 13:11:26','',''),(2337109,'1','194','1012',460,'Return of Retail Sale Id 1378122',0.00,8000.00,12.50,0.00,-900.00,'2021-12-21 13:11:51','',''),(2337170,'1','194','1012',460,'Retail Sale Id 1378177',222400.00,0.00,0.00,400.00,-4800.00,'2021-12-21 13:17:17','',''),(2337185,'1','194','1012',460,'Retail Sale Id 1378196',8320.00,0.00,0.00,13.00,936.00,'2021-12-21 13:19:06','',''),(2337198,'1','194','1012',460,'Retail Sale Id 1378208',640.00,0.00,0.00,1.00,72.00,'2021-12-21 13:20:53','',''),(2337258,'1','194','1012',460,'Retail Sale Id 1378265',998.40,0.00,0.00,1.56,112.32,'2021-12-21 13:27:17','',''),(2337275,'1','194','1012',460,'Retail Sale Id 1378282',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 13:29:31','',''),(2337326,'1','194','1012',460,'Retail Sale Id 1378332',55600.00,0.00,0.00,100.00,-1200.00,'2021-12-21 13:34:36','',''),(2337411,'1','194','1012',460,'Retail Sale Id 1378371',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 13:40:35','',''),(2337481,'1','194','1012',460,'Retail Sale Id 1378390',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 13:43:58','',''),(2337516,'1','194','1012',460,'Retail Sale Id 1378418',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 13:46:09','',''),(2337537,'1','194','1012',460,'Retail Sale Id 1378432',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 13:47:53','',''),(2337557,'1','194','1012',460,'Retail Sale Id 1378445',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 13:50:00','',''),(2337650,'1','194','1012',460,'Retail Sale Id 1378535',5120.00,0.00,0.00,8.00,576.00,'2021-12-21 13:57:53','',''),(2337684,'1','194','1012',460,'Retail Sale Id 1378573',9600.00,0.00,0.00,15.00,1080.00,'2021-12-21 14:02:25','',''),(2337868,'1','194','1012',460,'Retail Sale Id 1378720',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 14:18:08','',''),(2337891,'1','194','1012',460,'Retail Sale Id 1378724',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 14:19:05','',''),(2337911,'1','194','1012',460,'Retail Sale Id 1378734',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 14:20:23','',''),(2337953,'1','194','1012',460,'Retail Sale Id 1378769',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 14:24:49','',''),(2337985,'1','194','1012',460,'Retail Sale Id 1378797',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 14:26:15','',''),(2338020,'1','194','1012',460,'Retail Sale Id 1378838',55600.00,0.00,0.00,100.00,-1200.00,'2021-12-21 14:29:02','',''),(2338125,'1','194','1012',460,'Retail Sale Id 1378939',18348.00,0.00,0.00,33.00,-396.00,'2021-12-21 14:39:20','',''),(2338179,'1','194','1012',460,'Retail Sale Id 1379004',2003.20,0.00,0.00,3.13,225.36,'2021-12-21 14:44:36','',''),(2338193,'1','194','1012',460,'Retail Sale Id 1379016',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 14:45:28','',''),(2338219,'1','194','1012',460,'Retail Sale Id 1379033',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 14:48:05','',''),(2338279,'1','194','1012',460,'Retail Sale Id 1379098',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 14:53:02','',''),(2338330,'1','194','1012',460,'Retail Sale Id 1379120',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 14:54:55','',''),(2338344,'1','194','1012',460,'Retail Sale Id 1379127',7040.00,0.00,0.00,11.00,792.00,'2021-12-21 14:55:58','',''),(2338368,'1','194','1012',460,'Retail Sale Id 1379147',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 14:57:40','',''),(2338399,'1','194','1012',460,'Retail Sale Id 1379171',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 15:00:18','',''),(2338416,'1','194','1012',460,'Retail Sale Id 1379195',4998.40,0.00,0.00,7.81,562.32,'2021-12-21 15:02:27','',''),(2338429,'1','194','1012',460,'Retail Sale Id 1379201',2003.20,0.00,0.00,3.13,225.36,'2021-12-21 15:03:13','',''),(2338457,'1','194','1012',460,'Retail Sale Id 1379228',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 15:06:02','',''),(2338506,'1','194','1012',460,'Retail Sale Id 1379275',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 15:09:40','',''),(2338605,'1','194','1012',460,'Retail Sale Id 1379352',28912.00,0.00,0.00,52.00,-624.00,'2021-12-21 15:17:44','',''),(2338641,'1','194','1012',460,'Retail Sale Id 1379387',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 15:21:08','',''),(2338646,'1','194','1012',460,'Retail Sale Id 1379391',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 15:22:30','',''),(2338678,'1','194','1012',460,'Retail Sale Id 1379422',25020.00,0.00,0.00,45.00,-540.00,'2021-12-21 15:26:06','',''),(2338704,'1','194','1012',460,'Retail Sale Id 1379452',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 15:28:28','',''),(2338717,'1','194','1012',460,'Retail Sale Id 1379467',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 15:29:53','',''),(2338791,'1','194','1012',460,'Retail Sale Id 1379481',7040.00,0.00,0.00,11.00,792.00,'2021-12-21 15:34:59','',''),(2338825,'1','194','1012',460,'Retail Sale Id 1379548',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 15:36:12','',''),(2338846,'1','194','1012',460,'Retail Sale Id 1379563',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 15:37:09','',''),(2338868,'1','194','1012',460,'Retail Sale Id 1379573',2003.20,0.00,0.00,3.13,225.36,'2021-12-21 15:38:04','',''),(2338965,'1','194','1012',460,'Retail Sale Id 1379637',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 15:42:57','',''),(2338988,'1','194','1012',460,'Retail Sale Id 1379661',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 15:44:34','',''),(2339078,'1','194','1012',460,'Retail Sale Id 1379733',5120.00,0.00,0.00,8.00,576.00,'2021-12-21 15:51:20','',''),(2339183,'1','194','1012',460,'Retail Sale Id 1379833',2003.20,0.00,0.00,3.13,225.36,'2021-12-21 15:58:00','',''),(2339192,'1','194','1012',460,'Retail Sale Id 1379844',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 15:58:45','',''),(2339280,'1','194','1012',460,'Retail Sale Id 1379917',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 16:04:15','',''),(2339311,'1','194','1012',460,'Retail Sale Id 1379949',640.00,0.00,0.00,1.00,72.00,'2021-12-21 16:06:44','',''),(2339338,'1','194','1012',460,'Retail Sale Id 1379960',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 16:07:53','',''),(2339369,'1','194','1012',460,'Retail Sale Id 1379978',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 16:09:33','',''),(2339381,'1','194','1012',460,'Retail Sale Id 1379991',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 16:10:24','',''),(2339415,'1','194','1012',460,'Retail Sale Id 1380033',1203.20,0.00,0.00,1.88,135.36,'2021-12-21 16:13:42','',''),(2339431,'1','194','1012',460,'Retail Sale Id 1380046',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 16:14:27','',''),(2339440,'1','194','1012',460,'Retail Sale Id 1380053',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 16:15:25','',''),(2339452,'1','194','1012',460,'Retail Sale Id 1380067',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 16:16:15','',''),(2339486,'1','194','1012',460,'Retail Sale Id 1380100',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 16:18:56','',''),(2339501,'1','194','1012',460,'Retail Sale Id 1380112',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 16:19:49','',''),(2339507,'1','194','1012',460,'Retail Sale Id 1380120',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 16:20:30','',''),(2339603,'1','194','1012',460,'Retail Sale Id 1380210',1280.00,0.00,0.00,2.00,144.00,'2021-12-21 16:28:36','',''),(2339643,'1','194','1012',460,'Retail Sale Id 1380239',6400.00,0.00,0.00,10.00,720.00,'2021-12-21 16:30:46','',''),(2339652,'1','194','1012',460,'Retail Sale Id 1380249',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 16:31:50','',''),(2339662,'1','194','1012',460,'Retail Sale Id 1380258',640.00,0.00,0.00,1.00,72.00,'2021-12-21 16:32:52','',''),(2339671,'1','194','1012',460,'Retail Sale Id 1380269',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 16:33:30','',''),(2339688,'1','194','1012',460,'Retail Sale Id 1380283',8000.00,0.00,0.00,12.50,900.00,'2021-12-21 16:34:44','',''),(2339816,'1','194','1012',460,'Retail Sale Id 1380415',5120.00,0.00,0.00,8.00,576.00,'2021-12-21 16:46:09','',''),(2339843,'1','194','1012',460,'Retail Sale Id 1380445',1920.00,0.00,0.00,3.00,216.00,'2021-12-21 16:48:29','',''),(2339897,'1','194','1012',460,'Retail Sale Id 1380489',3001.60,0.00,0.00,4.69,337.68,'2021-12-21 16:53:34','',''),(2339914,'1','194','1012',460,'Retail Sale Id 1380510',3200.00,0.00,0.00,5.00,360.00,'2021-12-21 16:54:54','',''),(2339930,'1','194','1012',460,'Retail Sale Id 1380526',3840.00,0.00,0.00,6.00,432.00,'2021-12-21 16:56:26','',''),(2340021,'1','194','1012',460,'Retail Sale Id 1380610',2560.00,0.00,0.00,4.00,288.00,'2021-12-21 17:05:37','',''),(2340032,'1','194','1012',460,'Retail Sale Id 1380624',5120.00,0.00,0.00,8.00,576.00,'2021-12-21 17:06:53',''