-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_187
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_187`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_187` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_187`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3399 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3389,400120,'',0,'22','1','187','PURCHASES','','2021-06-16 09:27:31',5,0.00,0.00,'','479','2021-06-16 09:27:31','479',0,1),(3390,20052,'',0,'20','1','187','SALES','','2021-06-16 09:27:52',5,0.00,0.00,'','479','2021-06-16 09:27:52','479',0,1),(3391,40052,'',0,'6.1','1','187','CASH','','2021-06-16 09:28:07',5,0.00,0.00,'','479','2021-06-16 09:28:07','479',0,1),(3392,400320,'',0,'24','1','187','SALARIES & WAGES','','2021-06-16 09:28:37',5,0.00,0.00,'','479','2021-06-16 09:28:37','479',0,1),(3393,400321,'',0,'24','1','187','PURCHASES','','2021-06-16 09:29:03',5,0.00,0.00,'','479','2021-06-16 09:29:03','479',0,1),(3394,400601,'',0,'2','1','187','DANKANO-EBILLS(ZNB:1014717618)','','2021-06-16 09:30:55',5,0.00,0.00,'','479','2021-06-16 09:30:55','479',0,1),(3395,400602,'',0,'2','1','187','FID POS COLLECTION-5620141491','','2021-06-16 09:32:02',5,0.00,0.00,'','479','2021-06-16 09:32:02','479',0,1),(3396,400603,'',0,'2','1','187','POS COLLECTION (ZNB:1015965368','','2022-03-29 17:05:03',5,0.00,0.00,'','792','2022-03-29 17:05:03','792',0,0),(3397,400604,'',0,'2','1','187','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 15:34:02',5,0.00,0.00,'','792','2023-02-20 15:34:02','792',0,0),(3398,400605,'',0,'2','1','187','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:54:03',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:13:19','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3802 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2748,'','1','187','END USER','ABDULLAHI','08066777188','aaranoilorinlpg@gmail.com','ilorin','kwara','ilorin','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-16 10:39:43',5,'635','2021-06-16 10:39:43','635'),(2750,'','1','187','ALL DEALERS','ABDULLAHI','08066777188','aaranoilorinlpg@gmail.com','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-16 10:53:52',5,'635','2021-06-16 10:53:52','635'),(2753,'','1','187','ALLAHUNOR GAS','JIMOR IBRAHIM','07064304577','@','ilorin','kwara','OGIDI AREA ILLORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-17 12:33:31',5,'635','2021-06-17 12:33:31','635'),(2756,'','1','187','AL DABIY GAS','YUNUS MUHAMMAD','07035018586','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 10:27:21',5,'635','2021-06-18 10:27:21','635'),(2757,'','1','187','ALLAHUNOOR','ALLAHU NOOR','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 10:31:08',5,'635','2021-06-18 10:31:08','635'),(2759,'','1','187','AL HAQ GAS','AL HAQ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:21:00',5,'635','2021-06-18 11:21:00','635'),(2760,'','1','187','ABUMUTMAYINA GAS','ABUMUTMAYINA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:21:51',5,'635','2021-06-18 11:21:51','635'),(2761,'','1','187','FARI YARO GAS','FARIN YARO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:22:35',5,'635','2021-06-18 11:22:35','635'),(2762,'','1','187','NIMORE GAS','ALH MUSHUD BALOGUN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:32:18',5,'635','2021-06-18 11:32:18','635'),(2763,'','1','187','ALATEKO GAS','YUSUF ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:35:46',5,'635','2021-06-18 11:35:46','635'),(2764,'','1','187','HAMDAN GAS','HAMDAN NIG LTD','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:51:06',5,'635','2021-06-18 11:51:06','635'),(2765,'','1','187','FOLANIYO GAS','FOLANIYO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 11:52:06',5,'635','2021-06-18 11:52:06','635'),(2769,'','1','187','TRUST GAS','JAJI AHMAD','0000000000','@ilorin','ilorin','kwara','ILLORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-18 17:11:00',5,'635','2021-06-18 17:11:00','635'),(2770,'','1','187','ADETUNZ GAS','ABIB ADEOYE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 07:07:58',5,'635','2021-06-19 07:07:58','635'),(2771,'','1','187','ADE GAS','AHMED ADEDAYO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 09:01:24',5,'635','2021-06-19 09:01:24','635'),(2772,'','1','187','AL IMAN GAS','ISMAELA MIKAILA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 09:08:20',5,'635','2021-06-19 09:08:20','635'),(2774,'','1','187','EASY WORLD GAS','ISIAKA WASIU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 10:47:33',5,'635','2021-06-19 10:47:33','635'),(2776,'','1','187','A.A RANO NIG. LTD.','0PRETIONAL LOSS','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 11:18:44',5,'635','2021-06-19 11:18:44','635'),(2777,'','1','187','AL AMEEN GAS NIG LTD','KAMALUDEEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 11:56:19',5,'635','2021-06-19 11:56:19','635'),(2778,'','1','187','ADIO GAS','ALH ADIO','0000000000','@ilorin','ilorin','kwara','ILLORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 13:13:20',5,'635','2021-06-19 13:13:20','635'),(2780,'','1','187','ALBARKA GAS','HUSSAIN ISIAK IBRAHIM','0000000000','@ilorin','ilorin','kwara','ILLORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-19 13:41:03',5,'635','2021-06-19 13:41:03','635'),(2782,'','1','187','ALHAJI MUSHOOD GAS {SUPPLYER}','ALHAJI MUSHUOD','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-20 08:07:48',5,'635','2021-06-20 08:07:48','635'),(2783,'','1','187','SONNY GAS NIG LTD','SUNDAY AUGUSTINE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-20 09:31:05',5,'635','2021-06-20 09:31:05','635'),(2785,'','1','187','AL HALAL GAS NIG LTD','YUSUF OLALUWAJU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-20 17:52:42',5,'635','2021-06-20 17:52:42','635'),(2786,'','1','187','ATTAWAKKUN GAS','AKIM MASHUD','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-20 17:56:03',5,'635','2021-06-20 17:56:03','635'),(2788,'','1','187','MANYMORE GAS','CHIKODI MGDEMEMA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 08:17:16',5,'635','2021-06-21 08:17:16','635'),(2789,'','1','187','AJERE GAS NIG LTD','BABATUNDE YUSUF','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 09:51:11',5,'635','2021-06-21 09:51:11','635'),(2790,'','1','187','KENNIZ GAS NIG LTD','HASSAN OLAWORE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 11:17:30',5,'635','2021-06-21 11:17:30','635'),(2791,'','1','187','FILL-JUSTICE GAS','SADIQ JIMOH','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 11:57:53',5,'635','2021-06-21 11:57:53','635'),(2792,'','1','187','ADEDAMS GAS NIG LTD','OYEKANMI ALIMI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 12:14:31',5,'635','2021-06-21 12:14:31','635'),(2794,'','1','187','ABDULKADIR GAS NIG LTD','ABDULKADIR','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 14:52:15',5,'635','2021-06-21 14:52:15','635'),(2795,'','1','187','BIODUN GAS','ABIODUN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 08:54:07',5,'635','2021-06-22 08:54:07','635'),(2796,'','1','187','BEST OPTION GAS','MASHUD ABDULKARIM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 08:57:40',5,'635','2021-06-22 08:57:40','635'),(2797,'','1','187','JAMALULLAH GAS','SADIQ ABDULRAUF','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 09:02:29',5,'635','2021-06-29 08:47:50','635'),(2798,'','1','187','MASTER GAS NIG LTD','MASTER','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 09:18:00',5,'635','2021-06-22 09:18:00','635'),(2799,'','1','187','AL GANEEY GAS NIG LTD','ABDULRASHEED','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 09:37:20',5,'635','2021-06-22 09:37:20','635'),(2801,'','1','187','KWULERE GAS NIG LTD','ABDULHAKIM ABDULGANIYU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-22 10:50:49',5,'635','2021-06-22 10:50:49','635'),(2806,'','1','187','ALHAJI SADIQ AREMU','AREMU SADIQ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-23 07:52:54',5,'635','2021-06-23 07:52:54','635'),(2807,'','1','187','AKINSCO GAS NIG LTD','AKINSCO INTERNATIONAL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-23 07:59:51',5,'635','2021-06-23 07:59:51','635'),(2808,'','1','187','TOLA GAS NIG LTG','ABUBAKAR ABDULGANIYU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-23 09:53:46',5,'635','2021-06-23 09:53:46','635'),(2830,'','1','187','MOZULA GAS','ABDULRAUF RISIKAT','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-23 15:05:33',5,'635','2021-06-23 15:05:33','635'),(2833,'','1','187','MERIT ANTOMENT GAS','EZEWAN ANTHONY','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 08:46:00',5,'635','2021-06-25 08:46:00','635'),(2836,'','1','187','OPERATIONAL LOSS','AA RANO LPG','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 14:46:01',5,'635','2021-06-25 14:46:01','635'),(2837,'','1','187','MODUPE OLUWA GAS','MODUPE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 15:09:11',5,'635','2021-06-25 15:09:11','635'),(2839,'','1','187','Alli Alajanibon NIG LTD','ABDULLAHI Alli','0000000000','@ilorin','ilorin','kwara','OYO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 17:43:44',5,'635','2021-06-25 17:43:44','635'),(2840,'','1','187','GREEN GREEN GAS','GREEN GREEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 19:44:32',5,'635','2021-06-25 19:44:32','635'),(2841,'','1','187','APEX GAS','APEX GAS','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 19:46:28',5,'635','2021-06-25 19:46:28','635'),(2842,'','1','187','AL JALILU GAS','ALJALIL GAS','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 19:47:33',5,'635','2021-06-25 19:47:33','635'),(2843,'','1','187','AL-TAWAKUL GAS ','TAWAKUL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-26 08:31:52',5,'635','2021-06-26 08:31:52','635'),(2844,'','1','187','KASEEM GAS NIG LTD','ALAO KASEEM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-26 09:22:46',5,'635','2021-06-26 09:22:46','635'),(2846,'','1','187','HART GAS NIG LTD','ABDULRASHEED','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-26 12:26:57',5,'635','2021-06-26 12:26:57','635'),(2847,'','1','187','RIDONLAHI GAS','RIDONLAHI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-26 17:02:47',5,'635','2021-06-26 17:02:47','635'),(2849,'','1','187','abdulrazaq gas','abdulrazaq ilorin','0000000000','@ilorin','ilorin','kwara','ilorin','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-27 09:16:23',5,'635','2021-06-27 09:16:23','635'),(2850,'','1','187','SURAFAB OIL AND GAS','MOHAMMED KUDU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-27 09:17:54',5,'635','2021-06-27 09:17:54','635'),(2854,'','1','187','MARYAM GAS','MARYAM MARYAM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-28 07:57:13',5,'635','2021-06-28 07:57:13','635'),(2856,'','1','187','ALAPA GAS NIG LTD','ISMAIL ALAPA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-28 12:15:10',5,'635','2021-06-28 12:15:10','635'),(2857,'','1','187','WHITE CAP GAS ','ABDULLAHI FAOZ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-28 12:31:57',5,'635','2021-06-28 12:31:57','635'),(2860,'','1','187','WABILLAHI TAOFEEQ','WABILLAH TAOFEEQ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 06:36:02',5,'635','2021-06-29 06:36:02','635'),(2861,'','1','187','IJOBA GAS','YUSUF IJOIBA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 08:12:40',5,'635','2021-06-29 08:12:40','635'),(2862,'','1','187','RISKCUT GAS','RISKCUT AJAWO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 11:54:02',5,'635','2021-06-29 11:54:02','635'),(2863,'','1','187','WASMUS GAS NIG LTD','WASIU MUSLIMAT','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 12:16:27',5,'635','2021-06-29 12:16:27','635'),(2869,'','1','187','AL-IMAM GAS (BASIRU)','BASHIRU AL IMAM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 17:06:42',5,'635','2021-06-29 17:06:42','635'),(2870,'','1','187','AL HALAL GAS (UZTAZ)','AL HALAL USTAZ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 17:07:45',5,'635','2021-06-29 17:07:45','635'),(2871,'','1','187','KEMO GAS NIG LTD','AISHA NURUDEEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-29 18:10:40',5,'635','2021-06-29 18:10:40','635'),(2872,'','1','187','DANKA GAS NIG LTD','ABDULKADIR ISMAIL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 07:39:28',5,'635','2021-06-30 07:39:28','635'),(2874,'','1','187','YAFATAH GAS NIG LTD','IBRAHIM ISIAKU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 10:11:24',5,'635','2021-06-30 10:11:24','635'),(2875,'','1','187','SHOLA GAS','TOPE ADEMOLA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 10:39:09',5,'635','2021-06-30 10:39:09','635'),(2876,'','1','187','CENT GAS NIG LTD','OSHI AMOBI REUBEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 11:41:06',5,'635','2021-06-30 11:41:06','635'),(2877,'','1','187','ZUBEK GAS NIG LTD','JUDE UDWU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 12:11:01',5,'635','2021-06-30 12:11:01','635'),(2878,'','1','187','E AND M GAS LTD','MR JUSTIM ANTHONY','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 12:56:23',5,'635','2021-06-30 12:56:23','635'),(2880,'','1','187','ELODAN GAS NIG LTD','DANIEL ELODAN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-30 16:22:53',5,'635','2021-06-30 16:22:53','635'),(2882,'','1','187','OLA GAS NIG LTD','OLA DEWAJU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-01 09:22:02',5,'635','2021-07-01 09:22:02','635'),(2883,'','1','187','ALFIRDAUS GAS NIG LTD','ALFIRDAUSI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-01 12:48:41',5,'635','2021-07-01 12:48:41','635'),(2885,'','1','187','ALIMAM GAS ','IMAM GAS','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-01 14:31:17',5,'635','2021-07-01 14:31:17','635'),(2886,'','1','187','HAYBEE GAS NIG LTD','ABUBAKAR ADEBOYE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-01 15:13:00',5,'635','2021-07-01 15:13:00','635'),(2887,'','1','187','MY CHOICE GAS','SALIHU BALOGUN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-01 15:42:03',5,'635','2021-07-26 08:30:43','635'),(2891,'','1','187','AL LUTIFAH GAS ','AL LUTIFAH','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 06:56:11',5,'635','2021-07-05 06:56:11','635'),(2892,'','1','187','MAMA KAOSARAT GAS','IYA KAOSARAT','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 06:57:13',5,'635','2021-07-05 06:57:13','635'),(2893,'','1','187','SALAHUDEEN GAS','SALAHUDEEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 06:58:26',5,'635','2021-07-05 06:58:26','635'),(2894,'','1','187','M SQUARE GAS','MSQUARE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 06:59:19',5,'635','2021-07-05 06:59:19','635'),(2895,'','1','187','GIWA GAS','GIWA ALBARKA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 07:00:05',5,'635','2021-07-05 07:00:05','635'),(2896,'','1','187','IKE OLUWA GAS NIG LTD','RASHEEDAH ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 11:13:35',5,'635','2021-07-05 11:13:35','635'),(2897,'','1','187','ONALAPO GAS NIG LTD','MADINAT ABDULLATIF','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 11:45:33',5,'635','2021-07-05 11:45:33','635'),(2899,'','1','187','UMMASCO GAS NIG LTD','UMMASCO ILORIN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 13:20:45',5,'635','2021-07-05 13:20:45','635'),(2900,'','1','187','SHABA GAS NIG LTD','SHABA SHABA','0000000000','@ilorin','ilorin','kwara','ILOORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-05 16:33:39',5,'635','2021-07-05 16:33:39','635'),(2907,'','1','187','TEKKY GAS NIG LTD','HAFIZ  JIMOH','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-07 10:36:18',5,'635','2021-07-07 10:36:18','635'),(2919,'','1','187','IYA OLA GAS NIG LTD','MAMA DAVID','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-08 12:55:58',5,'635','2021-07-08 12:55:58','635'),(2924,'','1','187','CHIAMA GAS NIG LTD','CHIMA ONOVO','0000000000','@ilorin','ilorin','kwara','ILORIN ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-09 19:33:02',5,'635','2021-07-09 19:33:02','635'),(2925,'','1','187','UNIQUE GAS','UNIQUE GAS LTD','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-10 09:59:13',5,'635','2021-07-10 09:59:13','635'),(2927,'','1','187','KANNIKE GAS NIG LTD','BASHIR RIDWAN','0000000000','@ilorin','ilorin','kwara','ILOREIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-10 14:26:20',5,'635','2021-07-10 14:26:20','635'),(2929,'','1','187','BOBJAY GAS NIG LTD','OLAFIMIHAN JAMIEU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-11 09:57:51',5,'635','2021-07-11 09:57:51','635'),(2930,'','1','187','ORILONISE GAS NIG LTD','ALHAJI IBRAHIM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-11 10:08:17',5,'635','2021-07-11 10:08:17','635'),(2931,'','1','187','AL ABROOR GAS NIG LTD','IMAM ATERE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-11 12:50:49',5,'635','2021-07-11 12:50:49','635'),(2934,'','1','187','SIR CHINO GAS NIG LTD','RAPHAEL CHINONYE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 06:45:52',5,'635','2021-07-12 06:45:52','635'),(2935,'','1','187','ADE AIRPORT GAS NIG LTD','AZZAN HAFIZ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 10:39:10',5,'635','2021-07-12 10:39:10','635'),(2937,'','1','187','A20 GAS NIG LTD','AHMED ABDULWAHED','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 11:35:10',5,'635','2021-07-12 11:35:10','635'),(2938,'','1','187','ULTIMATE GAS ','JAMIU AKINOLA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 14:07:35',5,'635','2021-07-12 14:07:35','635'),(2940,'','1','187','SAL COMPUTER GAS','DR MUSTAPHA ISA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 16:19:17',5,'635','2021-07-12 16:19:17','635'),(2941,'','1','187','JAMAL GAS','JAMAL JAMAL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-12 16:57:13',5,'635','2021-07-12 16:57:13','635'),(2942,'','1','187','EASY GAS NIG LTD','ABDULRASHEED UMAR','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-13 08:08:28',5,'635','2021-07-13 08:08:28','635'),(2944,'','1','187','AT-TAQAWA GAS','AHMED AHMED','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-13 14:51:01',5,'635','2021-07-13 14:51:01','635'),(2945,'','1','187','EMMA GAS NIG LTD','EMMANUEL ADEBAYO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-14 09:50:40',5,'635','2021-07-14 09:50:40','635'),(2946,'','1','187','G.O.U. GAS NIG LTD','OBIOMA GODWIN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-14 12:17:37',5,'635','2021-07-14 12:17:37','635'),(2947,'','1','187','ARIKEWUYO GAS VENTURES','ALHAJI ABDULGAFAR ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-14 16:07:52',5,'635','2021-07-14 16:07:52','635'),(2948,'','1','187','CLEMENT GAS NIG LTD','CLEMENT MIKEL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-15 13:44:35',5,'635','2021-07-15 13:44:35','635'),(2949,'','1','187','SAMREAL GAS NIG LTD','SAMREAL ILORIN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-16 15:40:08',5,'635','2021-07-16 15:40:08','635'),(2950,'','1','187','TUNJI GAS ','TUNJI TUNJI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-16 15:42:20',5,'635','2021-07-16 15:42:20','635'),(2951,'','1','187','SAINT STEPHEN  GAS','STEPHEN SAINT','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-16 15:43:03',5,'635','2021-07-16 15:43:03','635'),(2953,'','1','187','M.M.J GAS','MOHAMMAD JIMOH MURTALA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-18 12:40:13',5,'635','2021-07-18 12:40:13','635'),(2955,'','1','187','J KENNIKE GAS NIG LTD','JIMOH KANNIKE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-18 13:26:47',5,'635','2021-07-18 13:26:47','635'),(2956,'','1','187','DEVINE FAVOUR GAS','ADU OLUEA FEMI','0000000000008110585819','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-18 15:49:50',5,'635','2021-07-18 15:49:50','635'),(2957,'','1','187','ADEYEMI GAS',' MR ADEYAMI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-19 07:13:18',5,'635','2021-07-19 07:13:18','635'),(2958,'','1','187','ISHOLA GAS ','ISHOLA ISHOLA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-19 07:19:09',5,'635','2021-07-19 07:19:09','635'),(2983,'','1','187','XEE GAS ','BELLO ABDULLAHI OLARIWAJU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-27 07:40:06',5,'635','2021-07-27 07:40:06','635'),(2984,'','1','187','BLESSING GAS NIG LTD','BLESSING ILORIN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-27 08:49:42',5,'635','2021-07-27 08:49:42','635'),(2985,'','1','187','EXCERLLENCY GAS','ALHAJA EXCERLLENCY','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-27 13:54:29',5,'635','2021-07-27 13:54:29','635'),(2987,'','1','187','WHITE CAR','ALHAJI WHITE CAR','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-28 06:57:39',5,'635','2021-07-28 06:57:39','635'),(2988,'','1','187','WASIU GAS SUUPLIER','MALLAM WASIU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-28 09:20:58',5,'635','2021-07-28 09:20:58','635'),(2995,'','1','187','CHIMA GAS','CHIMA CHIMA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-30 11:24:24',5,'635','2021-07-30 11:24:24','635'),(2998,'','1','187','JAYTECH GAS','JUWON ENOCK','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 12:00:49',5,'635','2021-07-31 12:00:49','635'),(2999,'','1','187','HONOURABLE LUKMAN GAS','ALHAJI LUKMAN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 12:14:49',5,'635','2021-07-31 12:14:49','635'),(3001,'','1','187','BAYINAH GAS LTD','MOHAMMAD SHARIFFDEEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 13:03:32',5,'635','2021-07-31 13:03:32','635'),(3002,'','1','187','ALNOOR GAS SULPPLIER','NOORUDEEN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-31 14:14:16',5,'635','2021-07-31 14:14:16','635'),(3007,'','1','187','ACACHOKWU GAS NIG LTD','ECHE OKAFOR','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-02 08:04:47',5,'635','2021-08-02 08:04:47','635'),(3008,'','1','187','SOLOMON GAS LTD','MR SOLOMON IDOKO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-02 10:12:48',5,'635','2021-08-02 10:12:48','635'),(3011,'','1','187','GOOD2ME GAS LTD','OLAYEMI JACOB','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-03 10:29:33',5,'635','2021-08-03 10:29:33','635'),(3014,'','1','187','ADEPATE GAS LTD','HALIMATU SADIYA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-04 11:50:28',5,'635','2021-08-04 11:50:28','635'),(3015,'','1','187','ADEYEMI GAS LTD','ADEBAYO ADE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-05 11:12:32',5,'635','2021-08-05 11:12:32','635'),(3023,'','1','187','MEGA GAS LTD','IZUCHUKWU OKONKWO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 10:28:29',5,'635','2021-08-06 10:28:29','635'),(3025,'','1','187','TRIPLE A GAS LTD','TAYE SULEIMAN','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-06 11:07:48',5,'635','2021-08-06 11:07:48','635'),(3036,'','1','187','SUPREME GAS','TOLA OJO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 08:20:04',5,'635','2021-08-08 08:20:04','635'),(3037,'','1','187','AL HAAQU GAS','SAEED SHUAIBU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 09:45:13',5,'635','2021-08-08 09:45:13','635'),(3038,'','1','187','ALASINRIN GAS','ABUBAKAR JIMOH','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 10:55:10',5,'635','2021-08-08 10:55:10','635'),(3040,'','1','187','IBN ABBASS GAS','ABBASS ONIKEKE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-08 11:38:15',5,'635','2021-08-08 11:38:15','635'),(3041,'','1','187','WAHAB IGBETTI GAS','ALHAJI DEBO IGETTI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 08:50:58',5,'635','2021-08-09 08:50:58','635'),(3045,'','1','187','T AND K GAS ','YUSUF BOLAKALE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 11:18:59',5,'635','2021-08-09 11:18:59','635'),(3047,'','1','187','AL LATEEF GAS','RIDWAN KAZEEM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 14:47:00',5,'635','2021-08-09 14:47:00','635'),(3049,'','1','187','WASMAK GAS','ABDULWASIU ABDULRAHEEM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-09 15:12:20',5,'635','2021-08-09 15:12:20','635'),(3051,'','1','187','IBRO GAS','SAKA IBRAHIM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-10 16:08:16',5,'635','2021-08-10 16:08:16','635'),(3056,'','1','187','SUNNY GAS','SUNDAY SUNNY','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-11 06:51:28',5,'635','2021-08-11 06:51:28','635'),(3060,'','1','187','YASKAM VENTURES GAS','ABDULLAHI QAZEEM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-11 15:14:56',5,'635','2021-08-11 15:14:56','635'),(3061,'','1','187','ROYAL GAS','EMMANUEL IYABUZE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-12 08:48:23',5,'635','2021-08-12 08:48:23','635'),(3080,'','1','187','O-MUSTY GAS','OBIAJULU EPUECHI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-16 07:34:58',5,'635','2021-08-16 07:34:58','635'),(3123,'','1','187','OLOMODA GAS','ABDULRAZAQ OLOMODA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-20 07:50:50',5,'635','2021-08-20 07:50:50','635'),(3143,'','1','187','M & M BLIIZZ GAS','MUBARAK ZAKARIYA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-23 11:58:02',5,'635','2021-08-23 11:58:02','635'),(3146,'','1','187','ZEE- GAS','BELLO ABDULLAHI OLARIWAJU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-24 06:57:08',5,'635','2021-08-24 06:57:08','635'),(3148,'','1','187','SAM GAS','SAMUEL SAM','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-24 10:53:00',5,'635','2021-08-24 10:53:00','635'),(3149,'','1','187','OLOWO GAS','BASHIR OLOWO','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-26 08:33:40',5,'635','2021-08-26 08:33:40','635'),(3160,'','1','187','T.J ADABS GAS','TAJUDEEN ALABI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-29 10:19:28',5,'635','2021-08-29 10:19:28','635'),(3161,'','1','187','BOLA GAS','SAKA BOLAKALE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-29 11:06:10',5,'635','2021-08-29 11:06:10','635'),(3163,'','1','187','OLAPEX GAS','OLARIWAJU TIMOTHY','0000000000','@ilorin','ilorin','kwara','IGHOHO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 09:31:08',5,'635','2021-08-30 09:31:08','635'),(3165,'','1','187','AZ GAS','AZZEZ AMINU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 10:56:20',5,'635','2021-08-30 10:56:20','635'),(3166,'','1','187','BABA IGBETTI GAS','BABA IGBETTI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-30 11:28:06',5,'635','2021-08-30 11:28:06','635'),(3175,'','1','187','M.O.E GAS','IJEOMA EZEANI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-31 06:44:47',5,'635','2021-08-31 06:44:47','635'),(3176,'','1','187','MM GAS','MURTALA MOHAMMED','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-31 06:56:12',5,'635','2021-08-31 06:56:12','635'),(3178,'','1','187','BLESSED CHIBOY GAS','UCHE CHUKWU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-08-31 15:53:36',5,'635','2021-08-31 15:53:36','635'),(3188,'','1','187','SUCCESS GAS','MUKTAR AYODELE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-04 12:19:56',5,'635','2021-09-04 12:19:56','635'),(3190,'','1','187','MR PAUL GAS','ARO PAUL DESMOND','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-06 09:42:27',5,'635','2021-09-06 09:42:27','635'),(3203,'','1','187','AGLOW GAS NIG LTD','MR AGBOLA ISMAIL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-08 13:29:51',5,'635','2021-09-08 13:29:51','635'),(3204,'','1','187','DARUSALAM GAS','IBRAHIM MOHAMMED','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-09 06:56:31',5,'635','2021-09-09 06:56:31','635'),(3205,'','1','187','BODE SADU GAS','SAADU BODE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-09 07:57:04',5,'635','2021-09-09 07:57:04','635'),(3206,'','1','187','TAOLAT GAS','TAOLAT SANI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-09 08:43:47',5,'635','2021-09-09 08:43:47','635'),(3294,'','1','187','HASBUNALLAHU GAS','ALAJA HASBUNALLAH','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-17 07:34:53',5,'635','2021-09-17 07:34:53','635'),(3337,'','1','187','GLORY GAS','ABDULKADIR ISHIAQ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-21 14:45:33',5,'635','2021-09-21 14:45:33','635'),(3339,'','1','187','FRIENDLY GAS','IYA JAMAL','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-22 09:25:53',5,'635','2021-09-22 09:25:53','635'),(3342,'','1','187','FATAI GAS','MR FATAI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-22 16:41:02',5,'635','2021-09-22 16:41:02','635'),(3349,'','1','187','HOSTAJ GAS','HAMBALI ADISA','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-23 16:39:41',5,'635','2021-09-23 16:39:41','635'),(3372,'','1','187','WISDOM IGBETI GAS','LUKMAN IGHETI','0000000000','@igbeti','ilorin','kwara','IGBETI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-28 07:25:11',5,'635','2021-09-28 07:25:11','635'),(3378,'','1','187','OLUWANISOLA GAS','OLAYINKA BABATUNDE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-30 08:39:37',5,'635','2021-09-30 08:39:37','635'),(3384,'','1','187','OLAMUMMY GAS','YUSUF ADEKOMI','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-02 08:07:45',5,'635','2021-10-02 08:07:45','635'),(3420,'','1','187','OLA OLUWA GAS','YAKINI MUSBAU','0000000000','@ilorin','OYO STATE','kwara','SAKI EAST','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-08 10:06:17',5,'635','2021-10-08 10:06:17','635'),(3429,'','1','187','HONESTY GAS','AZZEZ OLAWALE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-09 12:00:42',5,'635','2021-10-09 12:00:42','635'),(3430,'','1','187','HABIBAT GAS','NURUDEEN ISAH','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-09 14:54:27',5,'635','2021-10-09 14:54:27','635'),(3491,'','1','187','OLARIWAJU  GAS','AHMAD ISHIAQ','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-19 09:51:27',5,'635','2021-10-19 09:51:27','635'),(3624,'','1','187','ADIGUN GAS','WASIU JAMIU','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-29 10:27:44',5,'635','2021-10-29 10:27:44','635'),(3737,'','1','187','MUPHIEX GAS','MURTALA','08066777188','@ilorin','ILORIN','KWARA','GAMBARI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-12 12:06:37',5,'635','2021-11-12 12:06:37','635'),(3756,'','1','187','MANAGER','ABDULLAHI','08066777188','@ilorin','ILORIN','KWARA','OKO-OLOWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-15 10:40:45',5,'635','2021-11-15 10:40:45','635'),(3757,'','1','187','HAJIVIC GAS LIMITED','MUHAMMAD','08037638298','@ilorin','ILORIN','KWARA','ILORIN ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-21 16:50:17',5,'635','2022-04-21 16:50:17','635'),(3758,'','1','187','BAAQHO ROLEZ','BAAKHO','0000000000','@ilorin','ILORIN','kwara','IGBETI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-22 15:37:12',5,'635','2022-04-22 15:37:12','635'),(3759,'','1','187','SAWO GAS','NIGERIAN ARMY','0000000000','@ilorin','ILORIN','KWARA','SAWO BARRACK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-22 15:40:02',5,'635','2022-04-22 15:40:02','635'),(3760,'','1','187','OLOJE SUPPLYER','OLOJE','0000000000','@ilorin','ilorin','kwara','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-23 18:08:20',5,'635','2022-04-23 18:08:20','635'),(3761,'','1','187','ALADIE GAS','ISMAIL','0000000000','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-29 17:07:19',5,'635','2022-04-29 17:07:19','635'),(3762,'','1','187','GANIYU GANIYAT','GANIYAT','0000000000','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-30 14:56:15',5,'635','2022-04-30 14:56:15','635'),(3763,'','1','187','BYZ GAS','ADE OSUN','0000000000','@ilorin','ILORIN','KWARA','SOBE BARAK','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-30 15:43:08',5,'635','2022-04-30 15:43:08','635'),(3764,'','1','187','MAVELOURS','EMMANUEL MICAH','08061352431','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-04-30 17:33:57',5,'635','2022-04-30 17:33:57','635'),(3765,'','1','187','ABIYODON GAS','ABIYODON','08105155498','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-01 08:27:26',5,'635','2022-05-01 08:27:26','635'),(3766,'','1','187','COOK GAS','OMUTULA','07038347557','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-01 12:29:47',5,'635','2022-05-01 12:29:47','635'),(3767,'','1','187','B$B GAS','MUNIRAT ','07037512716','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-03 10:58:23',5,'635','2022-05-03 10:58:23','635'),(3768,'','1','187','ANNUR GAS','NURUDEEN ','08076564089','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-03 13:34:59',5,'635','2022-05-03 13:34:59','635'),(3769,'','1','187','yemlog gas','ABDULLAHI R IDRIS','08068397144','@ilorin','ILORIN','KWARA','ONIKUNKEWU STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-05 13:42:36',5,'635','2022-05-05 13:42:36','635'),(3770,'','1','187','M$S','ABDURAZAQ SHEHU','08035225502','@ilorin','ILORIN','KWARA','2 POPO GIWA STREET ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-05 17:43:17',5,'635','2022-05-05 17:43:17','635'),(3771,'','1','187','BABA GAS','MUSA MUHAMMED BALE','08034800728','@ilorin','ILORIN','KWARA','FEDERAL HOUSING ESTATE OLOJE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-06 10:39:59',5,'635','2022-05-06 10:39:59','635'),(3772,'','1','187','ENJAY GAS','EANEST ENJAY','08053591455','@kainji niger','KAINJI','NIGER','KAINJI NIGER STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-08 21:11:54',5,'635','2022-05-08 21:11:54','635'),(3773,'','1','187','MOREMAS','IBRAHIM BOLA KALE','07069415157','@ilorin','ILORIN','KWARA','24 ORIRE STREET OKLUWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-10 17:51:55',5,'635','2022-05-10 17:51:55','635'),(3774,'','1','187','AMAZING GAS','MR ANDERO','08033026941','@ilorin','ILORIN','KWARA','EYENKORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-26 10:39:57',5,'635','2022-05-26 10:39:57','635'),(3775,'','1','187','BOLAJI ABDULL GAS','IDRIS BOLAJI ABDULLAHI','09066941829','@ilorin','ILORIN','KWARA','NO 8 IMAM CONFOUOND ADAKA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 08:09:06',5,'635','2022-05-27 08:09:06','635'),(3776,'','1','187','AJIDAGBA GAS','ABDUAZIZ','09133277732','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-27 10:58:31',5,'635','2022-05-27 10:58:31','635'),(3777,'','1','187','DANJUMA','ABDULAFIZ TIJJANI','0000000000','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-29 11:12:06',5,'635','2022-05-29 11:12:06','635'),(3778,'','1','187','AKACHUKWU OIL AND GAS','HAECHE','08069518180','@ilorin','ILORIN','KWARA','AYOKORI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-12 15:25:16',5,'635','2022-06-12 15:25:16','635'),(3779,'','1','187','BIBIRE AND SON INTERPRISE','MARYAM BIBIRE','08173120687','@ilorin','ILORIN','KWARA','DAA-OSIBI ALABADO ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-13 11:22:26',5,'635','2022-06-13 11:22:26','635'),(3780,'','1','187','AROWOLO GAS','USMAN','07064947951','@ilorin','ILORIN','KWARA','MADI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-01 15:07:16',5,'635','2022-07-01 15:07:16','635'),(3781,'','1','187','BANI GAS','BAYO','0000000000','@ilorin','ILORIN','KWARA','BANI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-02 10:14:54',5,'635','2022-07-02 10:14:54','635'),(3782,'','1','187','FUMILAYO  GAS','FUMILAYO','09038051483','@ilorin','ILORIN','KWARA','ALERIBIYATA ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-04 10:49:12',5,'635','2022-08-04 10:49:12','635'),(3783,'','1','187','AA RANO NIGERIA LIMITED','ABDULLAHI ','07035278112','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-06 12:24:07',5,'635','2022-08-06 12:24:07','635'),(3784,'','1','187','SAWPH\"S CREED GAS','DOLAPO ABDULWAHAB','08104005341','@ilorin','ILORIN','KWARA','18 AJALA STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-07 14:18:24',5,'635','2022-08-07 14:18:24','635'),(3785,'','1','187','AL MABROOK GAS','MUSA ALIYU','07082981045','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-18 16:19:47',5,'635','2022-08-18 16:19:47','635'),(3786,'','1','187','GG GAS','GG God GRACE','08061618856','@ilorin','ILORIN','KWARA','ARODE BABUKO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-24 09:44:08',5,'635','2022-08-24 09:44:08','635'),(3787,'','1','187','PAKOYI GAS','ABDULLAHI KADIR','08169449522','@ilorin','ILORIN','KWARA','NO 34 POPO IGBONNA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-24 16:18:12',5,'635','2022-08-24 16:18:12','635'),(3788,'','1','187','ANHTONY GAP GAS','TONI ADEKEYI','07065772717','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-29 08:19:44',5,'635','2022-08-29 08:19:44','635'),(3789,'','1','187','TOP GAS','OJO TUMITOBE ','09075378552','@ilorin','ilorin','KWARA','MALETE BESIDE AYOKA FILLING STATION','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-28 11:02:27',5,'635','2022-09-28 11:02:27','635'),(3790,'','1','187','SBJ GAS','ISA AHMED','08114886829','@ilorin','ILORIN','KWARA','BANI ZANGO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-01 12:24:42',5,'635','2022-10-01 12:24:42','635'),(3791,'','1','187','FLOURISH GAS','SUIBU ABDULHAFIZ','07063274419','@ilorin','ILORIN','KWARA','EDISEN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-18 13:11:46',5,'635','2022-10-18 13:11:46','635'),(3792,'','1','187','OPEYEMI GAS OYUN','AJOKE','08036514017','@ilorin','ILORIN','KWARA','OPP 1 G4 ALONG TEPANTAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 12:10:37',5,'635','2022-10-22 12:10:37','635'),(3793,'','1','187','LABBAIKA GAS','NULKMAN','07066934612','@ilorin','ILORIN','KWARA','OJA LABBAIKA HOUSE ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-22 17:30:11',5,'635','2022-10-22 17:30:11','635'),(3794,'','1','187','BALUGUN GAS','ABDULLAHI R IDRIS','08068397144','@ilorin','ILORIN','KWARA','ILORIN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-24 11:04:07',5,'635','2022-10-24 11:04:07','635'),(3795,'','1','187','YAH SALLAM','ABDULRASHID','09077716257','abdullahirano2015@gmail.com','ILORIN','KWARA','NO 32 OLOJE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-04 10:36:19',5,'635','2022-11-04 10:36:19','635'),(3796,'','1','187','OCEE TECH','BADMUS OPEYEMI','08169013833','amurillahi@gmai,com','ILORIN','KWARA','GAASAKA AREA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-26 09:00:59',5,'635','2022-11-26 09:00:59','635'),(3797,'','1','187','GB GAS','JIMOH MONSURU GBOLAHANI','08032076630','sunkyminaht50@gmail,com','ILORIN','KWARA STATE','OGELE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-30 12:35:30',5,'635','2022-11-30 12:35:30','635'),(3798,'','1','187','OLAS GAS','ABDULLATI','07068701989','amurillahi@gmai,com','ILORIN','KWARA STATE','FGC','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-03 12:10:42',5,'635','2023-03-03 12:10:42','635'),(3799,'','1','187','AL LATEE GAS','ABDULLATEEF BELLO','08060977896','bellolateef64@gmail,com','ILORIN','KWARA STATE','ALABADO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-15 16:42:09',5,'635','2023-03-15 16:42:09','635'),(3800,'','1','187','ABU HASSAN','ABDULLGANIYU ABUBAKAR','08120811946','abubakaromotosho39@gmail,com','ILORIN','KWARA STATE','IDIAPE AKO DAN BUTE JECTION','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-19 09:39:39',5,'635','2023-03-19 09:39:39','635'),(3801,'','1','187','OMOTOSHO GAS','ABDULLWASIYU','07033085821','omotosho20@gmail,com','ILORIN','KWARA STATE','ARAROMI FACE 2 OKOLOWO','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-03-19 12:31:45',5,'635','2023-03-19 12:31:45','635');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16347 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','187',16344,'939',4381.91,1634.00,'2021-09-08','new dipping','2021-09-08 11:43:28','483','483',2021,'483','2021-09-08 11:43:28',5),('1','187',16345,'939',4381.91,1634.00,'2021-09-08','new dipping','2021-09-08 11:46:20','483','483',2021,'483','2021-09-08 11:46:20',5),('1','187',16346,'939',57.18,1.00,'2022-02-12','','2022-02-12 00:07:20','483','483',2022,'483','2022-02-12 00:07:20',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2766 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','187','939',2760,'5','LPG NOZZLE',679339.59,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','187','939',2761,'5','LPG NOZZLE 2',399592.93,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','187','939',2762,'5','LPG NOZZLE 3',221897.65,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','187','939',2763,'5','LPG NOZZLE 4',213915.79,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','187','939',2764,'5','LPG NOZZLE 5',199173.42,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','187','939',2765,'5','LPG NOZZLE 6',143938.34,'LPG DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=240074 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','187',204280,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-16 10:56:19','635','2021-06-16 10:56:35',10,0),('1','187',204283,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-16 18:46:25','635','2021-06-16 18:47:20',10,0),('1','187',204398,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-17 06:24:16','635','2021-06-17 06:24:37',10,0),('1','187',204402,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-17 19:12:11','635','2021-06-17 19:12:45',10,0),('1','187',204615,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-18 18:41:16','635','2021-06-18 18:41:38',10,0),('1','187',204836,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-19 11:04:08','635','2021-06-19 11:05:29',10,0),('1','187',204925,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-19 11:30:03','635','2021-06-19 11:30:31',10,0),('1','187',204931,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-19 19:01:41','635','2021-06-19 19:03:49',10,0),('1','187',205053,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-20 19:12:37','635','2021-06-20 19:13:02',10,0),('1','187',205241,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-21 19:42:49','635','2021-06-21 19:43:12',10,0),('1','187',205478,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-22 17:41:59','635','2021-06-22 17:42:24',10,0),('1','187',205691,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-22 19:26:28','635','2021-06-22 19:26:55',10,0),('1','187',205753,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-24 18:50:23','635','2021-06-24 18:50:54',10,0),('1','187',206119,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-25 07:38:44','635','2021-06-25 07:39:05',10,0),('1','187',206181,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-25 14:38:07','635','2021-06-25 14:38:27',10,0),('1','187',206289,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-25 14:51:12','635','2021-06-25 14:51:37',10,0),('1','187',206328,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-25 20:16:59','635','2021-06-25 20:17:27',10,0),('1','187',206393,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-26 20:17:14','635','2021-06-26 20:18:28',10,0),('1','187',206754,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-27 18:24:47','635','2021-06-27 18:25:07',10,0),('1','187',206803,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-28 18:14:14','635','2021-06-28 18:15:06',10,0),('1','187',207025,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-29 20:07:41','635','2021-06-29 20:08:20',10,0),('1','187',207252,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'635',0.00,0.00,'635','2021-06-30 18:43:20','635','2021-06-30 18:44:14',10,0),('1','187',207486,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-01 19:01:58','635','2021-07-01 19:02:30',10,0),('1','187',207709,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-02 15:17:14','635','2021-07-02 15:17:35',10,0),('1','187',207847,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-02 15:59:27','635','2021-07-02 15:59:44',10,0),('1','187',208325,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-05 20:11:27','635','2021-07-05 20:12:03',10,0),('1','187',208539,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-06 18:58:35','635','2021-07-06 18:59:16',10,0),('1','187',208763,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-07 09:57:46','635','2021-07-07 09:58:05',10,0),('1','187',208845,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-07 10:06:12','635','2021-07-07 10:06:38',10,0),('1','187',208856,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-07 19:21:49','635','2021-07-07 19:22:33',10,0),('1','187',209005,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-08 18:53:04','635','2021-07-08 18:53:37',10,0),('1','187',209221,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-09 20:19:52','635','2021-07-09 20:20:49',10,0),('1','187',209414,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-09 20:42:33','635','2021-07-09 20:43:12',10,0),('1','187',209505,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-10 18:54:28','635','2021-07-10 18:55:19',10,0),('1','187',209687,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-11 18:45:37','635','2021-07-11 18:45:58',10,0),('1','187',209871,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-12 18:26:06','635','2021-07-12 18:26:48',10,0),('1','187',210112,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-13 18:53:07','635','2021-07-13 18:53:42',10,0),('1','187',210319,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-14 19:29:10','635','2021-07-14 19:29:46',10,0),('1','187',210560,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-15 17:02:32','635','2021-07-15 17:02:54',10,0),('1','187',210690,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-15 17:08:06','635','2021-07-15 17:08:45',10,0),('1','187',210763,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-16 20:59:12','635','2021-07-16 21:00:20',10,0),('1','187',210962,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-17 18:57:27','635','2021-07-17 18:57:49',10,0),('1','187',211197,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-18 17:48:50','635','2021-07-18 17:49:18',10,0),('1','187',211390,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-19 22:51:38','635','2021-07-19 22:52:28',10,0),('1','187',211586,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-19 23:31:51','635','2021-07-19 23:32:13',10,0),('1','187',211683,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-20 15:08:28','635','2021-07-20 15:08:58',10,0),('1','187',211872,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-21 14:33:42','635','2021-07-21 14:34:13',10,0),('1','187',211912,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-21 14:40:35','635','2021-07-21 14:40:54',10,0),('1','187',212700,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-25 19:18:10','635','2021-07-25 19:18:37',10,0),('1','187',212879,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-26 19:22:31','635','2021-07-26 19:23:03',10,0),('1','187',213147,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-27 19:03:33','635','2021-07-27 19:03:56',10,0),('1','187',213402,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-28 16:37:47','635','2021-07-28 16:38:29',10,0),('1','187',213745,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-29 12:45:20','635','2021-07-29 12:45:49',10,0),('1','187',213750,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-29 18:59:13','635','2021-07-29 18:59:55',10,0),('1','187',213900,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-30 19:22:41','635','2021-07-30 19:23:28',10,0),('1','187',214105,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'635',0.00,0.00,'635','2021-07-31 18:06:15','635','2021-07-31 18:07:29',10,0),('1','187',214369,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-01 18:30:33','635','2021-08-01 18:32:16',10,0),('1','187',214546,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-02 18:12:06','635','2021-08-02 18:13:57',10,0),('1','187',214793,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-03 17:50:02','635','2021-08-03 17:50:34',10,0),('1','187',214972,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-03 18:56:45','635','2021-08-03 18:58:43',10,0),('1','187',214996,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-04 19:07:06','635','2021-08-04 19:08:07',10,0),('1','187',215224,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-05 18:05:15','635','2021-08-05 18:06:03',10,0),('1','187',215438,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-06 19:30:28','635','2021-08-06 19:31:15',10,0),('1','187',215684,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-07 09:55:16','635','2021-08-07 09:55:54',10,0),('1','187',215735,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-07 10:13:39','635','2021-08-07 10:14:14',10,0),('1','187',215915,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-08 18:26:03','635','2021-08-08 18:30:51',10,0),('1','187',216102,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-09 18:44:40','635','2021-08-09 18:53:50',10,0),('1','187',216321,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-10 19:17:11','635','2021-08-10 19:17:40',10,0),('1','187',216558,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-11 18:48:31','635','2021-08-11 18:49:34',10,0),('1','187',216791,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-12 14:01:12','635','2021-08-12 14:01:47',10,0),('1','187',216926,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-12 14:07:43','635','2021-08-12 14:08:18',10,0),('1','187',217022,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-13 18:50:44','635','2021-08-13 18:52:02',10,0),('1','187',217291,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-14 18:10:31','635','2021-08-14 18:11:02',10,0),('1','187',217520,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-15 18:16:26','635','2021-08-15 18:16:47',10,0),('1','187',217712,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-16 18:21:53','635','2021-08-16 18:22:20',10,0),('1','187',217992,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-17 18:53:52','635','2021-08-17 18:54:23',10,0),('1','187',218229,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-18 18:43:50','635','2021-08-18 18:44:15',10,0),('1','187',218452,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-19 18:37:51','635','2021-08-19 18:38:35',10,0),('1','187',218687,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-20 18:47:40','635','2021-08-20 18:48:37',10,0),('1','187',218904,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-21 10:39:33','635','2021-08-21 10:40:35',10,0),('1','187',218972,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-21 10:56:26','635','2021-08-21 10:57:10',10,0),('1','187',219411,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-23 21:19:34','635','2021-08-23 21:21:56',10,0),('1','187',219609,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-24 18:16:56','635','2021-08-24 18:17:34',10,0),('1','187',219813,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-25 18:26:05','635','2021-08-25 18:27:14',10,0),('1','187',220043,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-26 19:01:36','635','2021-08-26 19:02:36',10,0),('1','187',220212,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-26 19:07:38','635','2021-08-26 19:08:00',10,0),('1','187',220718,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-29 18:39:34','635','2021-08-29 18:40:10',10,0),('1','187',220914,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-30 18:40:53','635','2021-08-30 18:42:21',10,0),('1','187',221152,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'635',0.00,0.00,'635','2021-08-31 21:36:33','635','2021-08-31 21:36:59',10,0),('1','187',221534,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-01 14:29:02','635','2021-09-01 14:29:35',10,0),('1','187',222126,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-04 21:57:33','635','2021-09-04 21:58:12',10,0),('1','187',222274,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-05 16:53:55','635','2021-09-05 16:54:17',10,0),('1','187',222515,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-07 15:22:55','635','2021-09-07 15:23:36',10,0),('1','187',223041,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-08 20:11:13','635','2021-09-08 20:11:50',10,0),('1','187',223189,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-09 22:02:18','635','2021-09-09 22:02:52',10,0),('1','187',223432,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-10 19:04:10','635','2021-09-10 19:04:49',10,0),('1','187',223647,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-11 13:02:38','635','2021-09-11 13:03:49',10,0),('1','187',223783,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-11 13:30:45','635','2021-09-11 13:31:10',10,0),('1','187',224125,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-13 08:49:21','635','2021-09-13 08:50:31',10,0),('1','187',224127,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-13 08:56:35','635','2021-09-13 08:57:20',10,0),('1','187',224419,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-14 19:36:54','635','2021-09-14 19:37:39',10,0),('1','187',224563,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-15 19:30:44','635','2021-09-15 19:31:17',10,0),('1','187',224785,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-16 19:46:53','635','2021-09-16 19:47:38',10,0),('1','187',225033,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-17 18:26:09','635','2021-09-17 18:26:46',10,0),('1','187',225267,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-18 18:33:24','635','2021-09-18 18:34:05',10,0),('1','187',225487,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-19 17:16:40','635','2021-09-19 17:24:03',10,0),('1','187',225711,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-20 18:16:03','635','2021-09-20 18:16:38',10,0),('1','187',226047,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-21 09:59:30','635','2021-09-21 10:01:22',10,0),('1','187',226061,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-21 18:24:53','635','2021-09-21 18:25:26',10,0),('1','187',226280,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-22 18:21:01','635','2021-09-22 18:21:37',10,0),('1','187',226482,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-23 17:56:33','635','2021-09-23 17:57:21',10,0),('1','187',226737,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-24 18:31:05','635','2021-09-24 18:32:13',10,0),('1','187',226968,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-25 19:39:44','635','2021-09-25 19:40:31',10,0),('1','187',227166,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-25 19:55:26','635','2021-09-25 19:55:48',10,0),('1','187',227383,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-27 18:03:40','635','2021-09-27 18:04:16',10,0),('1','187',227619,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-28 18:26:48','635','2021-09-28 18:36:36',10,0),('1','187',227859,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-29 18:16:16','635','2021-09-29 18:16:58',10,0),('1','187',228116,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'635',0.00,0.00,'635','2021-09-30 18:39:16','635','2021-09-30 18:40:05',10,0),('1','187',228403,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-01 10:37:38','635','2021-10-01 10:39:02',10,0),('1','187',228420,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-01 10:45:43','635','2021-10-01 10:46:17',10,0),('1','187',228545,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-02 18:28:21','635','2021-10-02 18:29:11',10,0),('1','187',228781,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-03 18:10:00','635','2021-10-03 18:11:15',10,0),('1','187',228954,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-04 19:56:35','635','2021-10-04 19:57:11',10,0),('1','187',229172,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-05 19:52:59','635','2021-10-05 19:53:43',10,0),('1','187',229450,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-06 18:47:19','635','2021-10-06 18:47:38',10,0),('1','187',229632,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-06 19:02:08','635','2021-10-06 19:02:24',10,0),('1','187',229678,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-07 18:36:02','635','2021-10-07 18:36:27',10,0),('1','187',229897,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-08 18:12:20','635','2021-10-08 18:13:14',10,0),('1','187',230096,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-09 18:09:40','635','2021-10-09 18:11:18',10,0),('1','187',230320,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-10 18:17:19','635','2021-10-10 18:17:55',10,0),('1','187',230534,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-11 18:15:43','635','2021-10-11 18:16:25',10,0),('1','187',230793,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-12 18:08:29','635','2021-10-12 18:10:26',10,0),('1','187',231073,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-13 18:04:34','635','2021-10-13 18:05:02',10,0),('1','187',231396,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-14 14:17:20','635','2021-10-14 14:17:44',10,0),('1','187',231548,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-14 14:28:03','635','2021-10-14 14:28:44',10,0),('1','187',232181,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-17 19:43:50','635','2021-10-17 19:44:22',10,0),('1','187',232353,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-18 18:59:00','635','2021-10-18 18:59:54',10,0),('1','187',232590,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-19 18:22:53','635','2021-10-19 18:23:21',10,0),('1','187',232854,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-20 18:11:41','635','2021-10-20 18:12:39',10,0),('1','187',233129,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-21 18:33:05','635','2021-10-21 18:34:53',10,0),('1','187',233403,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-22 19:14:33','635','2021-10-22 19:15:13',10,0),('1','187',233620,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-23 17:25:39','635','2021-10-23 17:27:04',10,0),('1','187',233891,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-24 18:17:53','635','2021-10-24 18:19:22',10,0),('1','187',234046,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-25 15:24:06','635','2021-10-25 15:24:39',10,0),('1','187',234239,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-25 15:50:23','635','2021-10-25 15:52:25',10,0),('1','187',234588,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-27 18:14:20','635','2021-10-27 18:15:46',10,0),('1','187',234837,'DAILY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-28 18:02:27','635','2021-10-28 18:08:34',10,0),('1','187',235102,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-29 18:00:08','635','2021-10-29 18:03:23',10,0),('1','187',235316,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-30 18:17:42','635','2021-10-30 18:18:35',10,0),('1','187',235583,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'635',0.00,0.00,'635','2021-10-31 19:06:05','635','2021-10-31 19:07:05',10,0),('1','187',235765,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-01 19:15:42','635','2021-11-01 19:17:49',10,0),('1','187',236085,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-02 15:19:12','635','2021-11-02 15:24:13',10,0),('1','187',236167,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-02 15:28:48','635','2021-11-02 15:29:27',10,0),('1','187',236255,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-03 18:08:57','635','2021-11-03 18:09:43',10,0),('1','187',236535,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-04 18:03:39','635','2021-11-04 18:04:31',10,0),('1','187',236753,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-05 18:09:41','635','2021-11-05 18:10:02',10,0),('1','187',236984,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-06 18:36:40','635','2021-11-06 18:37:16',10,0),('1','187',237172,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-07 16:48:23','635','2021-11-07 16:48:50',10,0),('1','187',237409,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-08 14:07:44','635','2021-11-08 14:08:06',10,0),('1','187',237521,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-08 14:20:16','635','2021-11-08 14:20:41',10,0),('1','187',237539,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-08 18:52:06','635','2021-11-08 18:52:34',10,0),('1','187',237643,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-09 18:32:57','635','2021-11-09 18:34:56',10,0),('1','187',237886,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-10 18:04:37','635','2021-11-10 18:05:11',10,0),('1','187',238144,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-11 20:04:47','635','2021-11-11 20:05:10',10,0),('1','187',238391,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-12 18:41:59','635','2021-11-12 18:42:22',10,0),('1','187',238640,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-13 18:29:30','635','2021-11-13 18:29:54',10,0),('1','187',238889,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-14 09:01:48','635','2021-11-14 09:02:05',10,0),('1','187',239166,'DAILY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-15 10:44:26','635','2021-11-15 10:44:46',10,0),('1','187',239642,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'635',0.00,0.00,'635','2021-11-17 12:15:31','635','2021-11-17 12:15:52',10,0),('1','187',239643,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-12 12:26:45','635','2022-02-12 12:27:35',10,0),('1','187',239644,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-12 22:06:42','635','2022-02-12 22:07:17',10,0),('1','187',239645,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-13 21:32:00','635','2022-02-13 21:32:21',10,0),('1','187',239646,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-14 19:19:58','635','2022-02-14 20:00:00',10,0),('1','187',239647,'DAILY SALES SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-15 19:33:16','635','2022-02-15 19:33:34',10,0),('1','187',239648,'DAILY SALES SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-16 18:59:21','635','2022-02-16 18:59:44',10,0),('1','187',239649,'DAILY SALES SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-17 19:13:07','635','2022-02-17 19:13:43',10,0),('1','187',239650,'DAILY SHIFT SALE','2022-02-18','2022-02-18 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-18 19:32:12','635','2022-02-18 19:32:42',10,0),('1','187',239651,'DAILY SHIFT SALE','2022-02-19','2022-02-19 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-19 20:27:23','635','2022-02-19 20:27:44',10,0),('1','187',239652,'DAILY SALES SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-20 17:25:42','635','2022-02-20 17:26:06',10,0),('1','187',239653,'DAILY SALES SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'635',0.00,0.00,'635','2022-02-22 08:34:36','635','2022-02-22 08:34:56',10,0),('1','187',239654,'DAILY SALES SHIFT','2022-02-22','2022-02-22 08:35:23','2022-02-23 08:35:23','635',0.00,0.00,'635','2022-02-22 19:41:45','635','2022-02-22 19:42:09',10,0),('1','187',239655,'DAILY SHIFT SALE','2022-02-23','2022-02-23 09:06:19','2022-02-24 09:06:19','635',0.00,0.00,'635','2022-02-23 09:33:06','635','2022-02-23 09:33:28',10,0),('1','187',239656,'DAILY SALES SHIFT','2022-02-23','2022-02-23 12:03:22','2022-02-24 12:03:22','635',0.00,0.00,'635','2022-02-23 19:41:36','635','2022-02-23 19:41:56',10,0),('1','187',239657,'DAILY SALES SHIFT','2022-02-24','2022-02-24 08:17:01','2022-02-25 08:17:01','635',0.00,0.00,'635','2022-02-24 18:54:17','635','2022-02-24 18:54:43',10,0),('1','187',239658,'DAILY SALES SHIFT','2022-02-25','2022-02-25 08:50:26','2022-02-26 08:50:26','635',0.00,0.00,'635','2022-02-25 18:49:06','635','2022-02-25 18:49:28',10,0),('1','187',239659,'DAILY SALES SHIFT','2022-02-26','2022-02-26 08:25:57','2022-02-27 08:25:57','635',0.00,0.00,'635','2022-02-26 19:05:28','635','2022-02-26 19:06:05',10,0),('1','187',239660,'DAILY SHIFT SALE','2022-02-27','2022-02-27 08:47:24','2022-02-28 08:47:24','635',0.00,0.00,'635','2022-02-27 18:29:05','635','2022-02-27 18:29:24',10,0),('1','187',239661,'DAILY SALES SHIFT','2022-02-28','2022-02-28 08:23:41','2022-03-01 08:23:41','635',0.00,0.00,'635','2022-02-28 18:55:58','635','2022-02-28 18:56:23',10,0),('1','187',239662,'DAILY SHIFT SALE','2022-03-01','2022-03-01 07:35:16','2022-03-02 07:35:16','635',0.00,0.00,'635','2022-03-01 18:45:04','635','2022-03-01 18:45:20',10,0),('1','187',239663,'DAILY SHIFT SALE','2022-03-02','2022-03-02 07:16:35','2022-03-03 07:16:35','635',0.00,0.00,'635','2022-03-02 20:55:37','635','2022-03-02 20:55:57',10,0),('1','187',239664,'DAILY SHIFT SALE','2022-03-03','2022-03-03 07:44:59','2022-03-04 07:44:59','635',0.00,0.00,'635','2022-03-03 19:52:15','635','2022-03-03 19:52:37',10,0),('1','187',239665,'OPERATIONAL LOSS','2022-03-03','2022-03-03 19:54:18','2022-03-04 19:54:18','635',0.00,0.00,'635','2022-03-03 20:01:28','635','2022-03-03 20:01:48',10,0),('1','187',239666,'DAILY SALES SHIFT','2022-03-04','2022-03-04 08:50:33','2022-03-05 08:50:33','635',0.00,0.00,'635','2022-03-04 20:00:59','635','2022-03-04 20:01:21',10,0),('1','187',239667,'DAILY SALES SHIFT','2022-03-05','2022-03-05 08:41:49','2022-03-06 08:41:49','635',0.00,0.00,'635','2022-03-05 18:40:01','635','2022-03-05 18:40:21',10,0),('1','187',239668,'DAILY SHIFT SALE','2022-03-06','2022-03-06 09:04:19','2022-03-07 09:04:19','635',0.00,0.00,'635','2022-03-06 16:46:39','635','2022-03-06 16:46:55',10,0),('1','187',239669,'DAILY SALES SHIFT','2022-03-07','2022-03-07 08:43:14','2022-03-08 08:43:14','635',0.00,0.00,'635','2022-03-07 18:35:40','635','2022-03-07 18:35:59',10,0),('1','187',239670,'DAILY SHIFT SALE','2022-03-08','2022-03-08 08:03:17','2022-03-09 08:03:17','635',0.00,0.00,'635','2022-03-08 20:10:17','635','2022-03-08 20:10:44',10,0),('1','187',239671,'DAILY SHIFT SALE','2022-03-09','2022-03-09 07:59:37','2022-03-10 07:59:37','635',0.00,0.00,'635','2022-03-09 17:31:23','635','2022-03-09 17:31:45',10,0),('1','187',239672,'DAILY SHIFT SALE','2022-03-10','2022-03-10 08:17:44','2022-03-11 08:17:44','635',0.00,0.00,'635','2022-03-10 20:30:43','635','2022-03-10 20:31:34',10,0),('1','187',239673,'DAILY SHIFT','2022-03-11','2022-03-11 08:24:26','2022-03-12 08:24:26','635',0.00,0.00,'635','2022-03-11 21:27:52','635','2022-03-11 21:28:56',10,0),('1','187',239674,'DAILY SHIFT','2022-03-12','2022-03-12 07:27:45','2022-03-13 07:27:45','635',0.00,0.00,'635','2022-03-12 20:44:45','635','2022-03-12 20:45:23',10,0),('1','187',239675,'DAILY SHIFT','2022-03-13','2022-03-13 12:32:24','2022-03-14 12:32:24','635',0.00,0.00,'635','2022-03-13 21:29:44','635','2022-03-13 21:30:29',10,0),('1','187',239676,'DAILY SHIFT','2022-03-13','2022-03-13 21:46:44','2022-03-14 21:46:44','635',0.00,0.00,'635','2022-03-13 21:58:50','635','2022-03-13 21:59:30',10,0),('1','187',239677,'DAILY SHIFT','2022-03-13','2022-03-13 22:01:09','2022-03-14 22:01:09','635',0.00,0.00,'635','2022-03-13 22:32:07','635','2022-03-13 22:32:39',10,0),('1','187',239678,'DAILY SHIFT','2022-03-14','2022-03-14 08:44:31','2022-03-15 08:44:31','635',0.00,0.00,'635','2022-03-14 19:22:59','635','2022-03-14 19:23:20',10,0),('1','187',239679,'DAILY SHIFT','2022-03-15','2022-03-15 07:13:52','2022-03-16 07:13:52','635',0.00,0.00,'635','2022-03-15 18:31:50','635','2022-03-15 18:32:04',10,0),('1','187',239680,'DAILY SHIFT SALE','2022-03-16','2022-03-16 09:10:49','2022-03-17 09:10:49','635',0.00,0.00,'635','2022-03-16 20:16:55','635','2022-03-16 20:17:20',10,0),('1','187',239681,'DAILY SHIFT','2022-03-17','2022-03-17 07:37:00','2022-03-18 07:37:00','635',0.00,0.00,'635','2022-03-17 18:59:02','635','2022-03-17 18:59:22',10,0),('1','187',239682,'DAILY SHIFT','2022-03-18','2022-03-18 08:29:30','2022-03-19 08:29:30','635',0.00,0.00,'635','2022-03-18 19:40:06','635','2022-03-18 19:40:39',10,0),('1','187',239683,'DAILY SHIFT','2022-03-19','2022-03-19 08:18:27','2022-03-20 08:18:27','635',0.00,0.00,'635','2022-03-19 18:26:06','635','2022-03-19 18:26:21',10,0),('1','187',239684,'DAILY SHIFT','2022-03-20','2022-03-20 10:15:13','2022-03-21 10:15:13','635',0.00,0.00,'635','2022-03-20 16:51:52','635','2022-03-20 16:52:09',10,0),('1','187',239685,'DAILY SHIFT ','2022-03-21','2022-03-21 08:23:15','2022-03-22 08:23:15','635',0.00,0.00,'635','2022-03-21 20:54:54','635','2022-03-21 20:55:14',10,0),('1','187',239686,'DAILY SHIFT','2022-03-22','2022-03-22 08:22:17','2022-03-23 08:22:17','635',0.00,0.00,'635','2022-03-22 18:44:33','635','2022-03-22 18:44:50',10,0),('1','187',239687,'DAILY SHIFT ','2022-03-23','2022-03-23 07:36:48','2022-03-24 07:36:48','635',0.00,0.00,'635','2022-03-23 19:34:18','635','2022-03-23 19:34:37',10,0),('1','187',239688,'Daily shift ','2022-03-23','2022-03-23 23:00:39','2022-03-24 23:00:39','635',0.00,0.00,'635','2022-03-24 14:30:34','635','2022-03-24 14:30:52',10,0),('1','187',239689,'DAILY SHIFT','2022-03-25','2022-03-25 10:01:36','2022-03-26 10:01:36','635',0.00,0.00,'635','2022-03-25 21:42:06','635','2022-03-25 21:42:25',10,0),('1','187',239690,'DAILY SHIFT','2022-03-26','2022-03-26 07:26:46','2022-03-27 07:26:46','635',0.00,0.00,'635','2022-03-26 19:27:14','635','2022-03-26 19:27:37',10,0),('1','187',239691,'DAILY SHIFT','2022-03-27','2022-03-27 09:05:43','2022-03-28 09:05:43','635',0.00,0.00,'635','2022-03-27 18:14:19','635','2022-03-27 18:15:50',10,0),('1','187',239692,'DAILY SHIFT','2022-03-28','2022-03-28 06:57:56','2022-03-29 06:57:56','635',0.00,0.00,'635','2022-03-28 20:37:30','635','2022-03-28 20:37:51',10,0),('1','187',239693,'DAILY SHIFT','2022-03-29','2022-03-29 07:33:56','2022-03-30 07:33:56','635',0.00,0.00,'635','2022-03-29 19:30:36','635','2022-03-29 19:32:15',10,0),('1','187',239694,'DAILY SHIFT','2022-03-30','2022-03-30 07:24:02','2022-03-31 07:24:02','635',0.00,0.00,'635','2022-03-30 20:55:25','635','2022-03-30 20:55:47',10,0),('1','187',239695,'DAILY SHIFT','2022-03-31','2022-03-31 07:13:25','2022-04-01 07:13:25','635',0.00,0.00,'635','2022-03-31 19:07:07','635','2022-03-31 19:07:22',10,0),('1','187',239696,'DAILY SHIFT','2022-04-01','2022-04-01 08:36:44','2022-04-02 08:36:44','635',0.00,0.00,'635','2022-04-01 19:22:33','635','2022-04-01 19:22:51',10,0),('1','187',239697,'DAILY SHIFT                     ','2022-04-01','2022-04-01 21:40:27','2022-04-02 21:40:27','635',0.00,0.00,'635','2022-04-01 21:45:47','635','2022-04-01 21:46:03',10,0),('1','187',239698,'DAILY SHIFT','2022-04-03','2022-04-03 10:42:57','2022-04-04 10:42:57','635',0.00,0.00,'635','2022-04-03 19:21:20','635','2022-04-03 19:21:39',10,0),('1','187',239699,'DAILY SHIFT ','2022-04-04','2022-04-04 08:32:25','2022-04-05 08:32:25','635',0.00,0.00,'635','2022-04-04 19:27:24','635','2022-04-04 19:27:47',10,0),('1','187',239700,'DAILY SHIFT ','2022-04-05','2022-04-05 08:36:40','2022-04-06 08:36:40','635',0.00,0.00,'635','2022-04-06 09:16:26','635','2022-04-06 09:16:42',10,0),('1','187',239701,'DAILY SHIFT ','2022-04-06','2022-04-06 09:17:11','2022-04-07 09:17:11','635',0.00,0.00,'635','2022-04-06 21:43:42','635','2022-04-06 21:44:14',10,0),('1','187',239702,'DAILY SHIFT','2022-04-06','2022-04-06 21:53:54','2022-04-07 21:53:54','635',0.00,0.00,'635','2022-04-06 21:58:25','635','2022-04-06 21:58:43',10,0),('1','187',239703,'DAILY SHIFT ','2022-04-07','2022-04-07 07:35:03','2022-04-08 07:35:03','635',0.00,0.00,'635','2022-04-08 08:45:48','635','2022-04-08 08:46:31',10,0),('1','187',239704,'DAILY SHIFT','2022-04-08','2022-04-08 08:46:50','2022-04-09 08:46:50','635',0.00,0.00,'635','2022-04-08 19:06:27','635','2022-04-08 19:06:44',10,0),('1','187',239705,'DAILY SHIFT','2022-04-09','2022-04-09 07:57:42','2022-04-10 07:57:42','635',0.00,0.00,'635','2022-04-09 18:31:07','635','2022-04-09 18:31:25',10,0),('1','187',239706,'DAILY SHIFT ','2022-04-10','2022-04-10 09:23:33','2022-04-11 09:23:33','635',0.00,0.00,'635','2022-04-10 16:45:46','635','2022-04-10 16:46:02',10,0),('1','187',239707,'DAILY SHIFT ','2022-04-11','2022-04-11 08:00:54','2022-04-12 08:00:54','635',0.00,0.00,'635','2022-04-11 18:45:29','635','2022-04-11 18:45:44',10,0),('1','187',239708,'DAILY SHIFT ','2022-04-12','2022-04-12 07:19:43','2022-04-13 07:19:43','635',0.00,0.00,'635','2022-04-12 22:33:52','635','2022-04-12 22:41:27',10,0),('1','187',239709,'DAILY SHIFT ','2022-04-13','2022-04-13 06:37:23','2022-04-14 06:37:23','635',0.00,0.00,'635','2022-04-13 18:52:47','635','2022-04-13 18:53:25',10,0),('1','187',239710,'DAILY SHIFT ','2022-04-14','2022-04-14 08:07:25','2022-04-15 08:07:25','635',0.00,0.00,'635','2022-04-14 19:59:45','635','2022-04-14 20:00:09',10,0),('1','187',239711,'DAILY SHIFT ','2022-04-15','2022-04-15 07:06:39','2022-04-16 07:06:39','635',0.00,0.00,'635','2022-04-15 18:33:24','635','2022-04-15 18:33:43',10,0),('1','187',239712,'DAILY SHIFT ','2022-04-16','2022-04-16 07:49:55','2022-04-17 07:49:55','635',0.00,0.00,'635','2022-04-16 18:29:28','635','2022-04-16 18:30:14',10,0),('1','187',239713,'DAILY SHIFT                     ','2022-04-17','2022-04-17 10:13:42','2022-04-18 10:13:42','635',0.00,0.00,'635','2022-04-17 15:10:09','635','2022-04-17 15:10:29',10,0),('1','187',239714,'DAILY SHIFT','2022-04-17','2022-04-17 15:15:54','2022-04-18 15:15:54','635',0.00,0.00,'635','2022-04-17 15:20:36','635','2022-04-17 15:20:58',10,0),('1','187',239715,'DAILY SHIFT','2022-04-17','2022-04-17 15:29:23','2022-04-18 15:29:23','635',0.00,0.00,'635','2022-04-17 15:43:27','635','2022-04-17 15:43:53',10,0),('1','187',239716,'Daily shift ','2022-04-18','2022-04-18 08:39:08','2022-04-19 08:39:08','635',0.00,0.00,'635','2022-04-18 19:40:17','635','2022-04-18 19:40:48',10,0),('1','187',239717,'Daily shift ','2022-04-19','2022-04-19 08:25:23','2022-04-20 08:25:23','635',0.00,0.00,'635','2022-04-19 20:06:29','635','2022-04-19 20:06:53',10,0),('1','187',239718,'DAILY SHIFT ','2022-04-20','2022-04-20 07:07:37','2022-04-21 07:07:37','635',0.00,0.00,'635','2022-04-20 19:59:21','635','2022-04-20 19:59:39',10,0),('1','187',239719,'DAILY SHIFT','2022-04-21','2022-04-21 07:42:54','2022-04-22 07:42:54','635',0.00,0.00,'635','2022-04-21 20:29:59','635','2022-04-21 20:30:22',10,0),('1','187',239720,'DAILY SHIFT','2022-04-22','2022-04-22 07:32:52','2022-04-23 07:32:52','635',0.00,0.00,'635','2022-04-22 20:21:57','635','2022-04-22 20:22:25',10,0),('1','187',239721,'DAILY SHIFT','2022-04-23','2022-04-23 07:45:55','2022-04-24 07:45:55','635',0.00,0.00,'635','2022-04-23 21:14:29','635','2022-04-23 21:14:50',10,0),('1','187',239722,'DAILY SHIFT','2022-04-24','2022-04-24 07:57:59','2022-04-25 07:57:59','635',0.00,0.00,'635','2022-04-24 18:00:37','635','2022-04-24 18:00:56',10,0),('1','187',239723,'DAILY SHIFT ','2022-04-25','2022-04-25 07:20:41','2022-04-26 07:20:41','635',0.00,0.00,'635','2022-04-25 20:37:41','635','2022-04-25 20:38:00',10,0),('1','187',239724,'DAILY SHIFT                     ','2022-04-25','2022-04-25 21:00:33','2022-04-26 21:00:33','635',0.00,0.00,'635','2022-04-25 21:04:57','635','2022-04-25 21:05:22',10,0),('1','187',239725,'DAILY SHIFT ','2022-04-26','2022-04-26 08:09:17','2022-04-27 08:09:17','635',0.00,0.00,'635','2022-04-26 18:35:49','635','2022-04-26 18:36:07',10,0),('1','187',239726,'Daily shift ','2022-04-27','2022-04-27 08:00:57','2022-04-28 08:00:57','635',0.00,0.00,'635','2022-04-27 18:33:35','635','2022-04-27 18:34:05',10,0),('1','187',239727,'Daily shift ','2022-04-28','2022-04-28 07:26:35','2022-04-29 07:26:35','635',0.00,0.00,'635','2022-04-28 18:33:32','635','2022-04-28 18:33:49',10,0),('1','187',239728,'Daily shift ','2022-04-29','2022-04-29 07:55:17','2022-04-30 07:55:17','635',0.00,0.00,'635','2022-04-29 18:49:41','635','2022-04-29 18:49:59',10,0),('1','187',239729,'Daily shift ','2022-04-30','2022-04-30 07:18:04','2022-05-01 07:18:04','635',0.00,0.00,'635','2022-04-30 18:51:10','635','2022-04-30 18:51:33',10,0),('1','187',239730,'DAILY SHIFT','2022-05-01','2022-05-01 08:20:20','2022-05-02 08:20:20','635',0.00,0.00,'635','2022-05-01 21:25:52','635','2022-05-01 21:26:12',10,0),('1','187',239731,'DAILY SHIFT  ','2022-05-03','2022-05-03 08:44:30','2022-05-04 08:44:30','635',0.00,0.00,'635','2022-05-03 08:47:09','635','2022-05-03 09:03:36',10,0),('1','187',239732,'DAILY SHIFT','2022-05-03','2022-05-03 09:04:18','2022-05-04 09:04:18','635',0.00,0.00,'635','2022-05-03 09:09:32','635','2022-05-03 09:09:50',10,0),('1','187',239733,'DAILY SHIFT','2022-05-03','2022-05-03 09:11:13','2022-05-04 09:11:13','635',0.00,0.00,'635','2022-05-03 20:35:45','635','2022-05-03 20:36:50',10,0),('1','187',239734,'DAILY SHIFT','2022-05-04','2022-05-04 12:46:27','2022-05-05 12:46:27','635',0.00,0.00,'635','2022-05-04 20:30:01','635','2022-05-04 20:30:59',10,0),('1','187',239735,'DAILY SHIFT','2022-05-05','2022-05-05 07:42:13','2022-05-06 07:42:13','635',0.00,0.00,'635','2022-05-05 19:19:24','635','2022-05-05 19:19:40',10,0),('1','187',239736,'DAILY SHIFT','2022-05-06','2022-05-06 08:07:59','2022-05-07 08:07:59','635',0.00,0.00,'635','2022-05-06 18:58:52','635','2022-05-06 18:59:08',10,0),('1','187',239737,'DAILY SHIFT','2022-05-07','2022-05-07 08:02:49','2022-05-08 08:02:49','635',0.00,0.00,'635','2022-05-07 19:21:40','635','2022-05-07 19:21:57',10,0),('1','187',239738,'DAILY SHIFT','2022-05-08','2022-05-08 09:38:19','2022-05-09 09:38:19','635',0.00,0.00,'635','2022-05-08 18:19:25','635','2022-05-08 18:19:45',10,0),('1','187',239739,'DAILY SHIFT ','2022-05-08','2022-05-08 21:04:46','2022-05-09 21:04:46','635',0.00,0.00,'635','2022-05-08 21:18:59','635','2022-05-08 21:19:38',10,0),('1','187',239740,'DAILY SHIFT','2022-05-09','2022-05-09 17:18:13','2022-05-10 17:18:13','635',0.00,0.00,'635','2022-05-09 17:26:08','635','2022-05-09 17:26:34',10,0),('1','187',239741,'DAILY SHIFT','2022-05-10','2022-05-10 15:27:34','2022-05-11 15:27:34','635',0.00,0.00,'635','2022-05-11 08:11:31','635','2022-05-11 08:11:57',10,0),('1','187',239742,'DAILY SHIFT','2022-05-11','2022-05-11 08:12:41','2022-05-12 08:12:41','635',0.00,0.00,'635','2022-05-11 18:34:35','635','2022-05-11 18:34:49',10,0),('1','187',239743,'DAILY SHIFT','2022-05-12','2022-05-12 08:26:27','2022-05-13 08:26:27','635',0.00,0.00,'635','2022-05-12 18:32:19','635','2022-05-12 18:32:42',10,0),('1','187',239744,'DAILY SHIFT ','2022-05-13','2022-05-13 07:42:56','2022-05-14 07:42:56','635',0.00,0.00,'635','2022-05-13 18:57:26','635','2022-05-13 18:57:51',10,0),('1','187',239745,'DAILY SHIFT ','2022-05-14','2022-05-14 07:39:59','2022-05-15 07:39:59','635',0.00,0.00,'635','2022-05-14 18:38:54','635','2022-05-14 18:39:19',10,0),('1','187',239746,'Daily shift ','2022-05-15','2022-05-15 08:07:14','2022-05-16 08:07:14','635',0.00,0.00,'635','2022-05-15 17:46:36','635','2022-05-15 17:47:41',10,0),('1','187',239747,'DAILY SHIFT','2022-05-16','2022-05-16 08:01:00','2022-05-17 08:01:00','635',0.00,0.00,'635','2022-05-16 15:14:47','635','2022-05-16 15:15:05',10,0),('1','187',239748,'DAILY SHIFT','2022-05-19','2022-05-19 11:34:11','2022-05-20 11:34:11','635',0.00,0.00,'635','2022-05-19 18:36:41','635','2022-05-19 18:36:58',10,0),('1','187',239749,'DAILY SHIFT','2022-05-20','2022-05-20 08:06:34','2022-05-21 08:06:34','635',0.00,0.00,'635','2022-05-20 18:39:23','635','2022-05-20 18:40:06',10,0),('1','187',239750,'DAILY SHIFT','2022-05-21','2022-05-21 08:25:08','2022-05-22 08:25:08','635',0.00,0.00,'635','2022-05-22 10:27:08','635','2022-05-22 10:27:23',10,0),('1','187',239751,'DAILY SHIFT','2022-05-22','2022-05-22 10:28:00','2022-05-23 10:28:00','635',0.00,0.00,'635','2022-05-22 19:41:49','635','2022-05-22 19:42:10',10,0),('1','187',239752,'DAILY SHIFT','2022-05-23','2022-05-23 08:34:12','2022-05-24 08:34:12','635',0.00,0.00,'635','2022-05-23 18:05:05','635','2022-05-23 18:13:45',10,0),('1','187',239753,'DAILY SHIFT','2022-05-24','2022-05-24 06:42:02','2022-05-25 06:42:02','635',0.00,0.00,'635','2022-05-24 06:47:01','635','2022-05-24 06:47:19',10,0),('1','187',239754,'DAILY SHIFT ','2022-05-24','2022-05-24 09:07:23','2022-05-25 09:07:23','635',0.00,0.00,'635','2022-05-24 19:12:03','635','2022-05-24 19:12:34',10,0),('1','187',239755,'DAILY SHIFT','2022-05-25','2022-05-25 08:58:26','2022-05-26 08:58:26','635',0.00,0.00,'635','2022-05-25 18:28:54','635','2022-05-25 18:29:08',10,0),('1','187',239756,'DAILY SHIFT','2022-05-26','2022-05-26 08:59:17','2022-05-27 08:59:17','635',0.00,0.00,'635','2022-05-26 19:23:32','635','2022-05-26 19:23:53',10,0),('1','187',239757,'DAILY SHIFT','2022-05-27','2022-05-27 08:00:52','2022-05-28 08:00:52','635',0.00,0.00,'635','2022-05-27 15:56:53','635','2022-05-27 15:57:12',10,0),('1','187',239758,'DAILY SHIFT                     ','2022-05-28','2022-05-28 16:52:03','2022-05-29 16:52:03','635',0.00,0.00,'635','2022-05-28 17:01:55','635','2022-05-28 17:02:21',10,0),('1','187',239759,'DAILY SHIFT','2022-05-29','2022-05-29 07:59:15','2022-05-30 07:59:15','635',0.00,0.00,'635','2022-05-29 20:05:19','635','2022-05-29 20:05:39',10,0),('1','187',239760,'DAILY SHIFT','2022-05-30','2022-05-30 08:18:27','2022-05-31 08:18:27','635',0.00,0.00,'635','2022-05-30 21:00:37','635','2022-05-30 21:00:53',10,0),('1','187',239761,'DAILY SHIFT','2022-05-31','2022-05-31 08:11:14','2022-06-01 08:11:14','635',0.00,0.00,'635','2022-05-31 13:21:01','635','2022-05-31 13:21:18',10,0),('1','187',239762,'DAILY SHIFT','2022-06-01','2022-06-01 08:10:13','2022-06-02 08:10:13','635',0.00,0.00,'635','2022-06-01 08:14:57','635','2022-06-01 08:15:58',10,0),('1','187',239763,'DAILY SHIFT','2022-06-01','2022-06-01 11:36:28','2022-06-02 11:36:28','635',0.00,0.00,'635','2022-06-01 22:19:50','635','2022-06-01 22:20:12',10,0),('1','187',239764,'DAILY SHIFT','2022-06-02','2022-06-02 09:00:13','2022-06-03 09:00:13','635',0.00,0.00,'635','2022-06-02 19:13:34','635','2022-06-02 19:15:37',10,0),('1','187',239765,'DAILY SHIFT','2022-06-07','2022-06-07 10:32:41','2022-06-08 10:32:41','635',0.00,0.00,'635','2022-06-07 10:35:33','635','2022-06-07 10:35:51',10,0),('1','187',239766,'DAILY SHIFT','2022-06-07','2022-06-07 11:55:17','2022-06-08 11:55:17','635',0.00,0.00,'635','2022-06-07 20:07:09','635','2022-06-07 20:07:27',10,0),('1','187',239767,'DAILY SHIFT ','2022-06-08','2022-06-08 07:01:50','2022-06-09 07:01:50','635',0.00,0.00,'635','2022-06-08 19:46:47','635','2022-06-08 19:47:05',10,0),('1','187',239768,'DAILY SHIFT','2022-06-09','2022-06-09 17:48:13','2022-06-10 17:48:13','635',0.00,0.00,'635','2022-06-09 17:50:55','635','2022-06-09 17:51:17',10,0),('1','187',239769,'DAILY SHIFT','2022-06-11','2022-06-11 07:37:09','2022-06-12 07:37:09','635',0.00,0.00,'635','2022-06-11 20:06:40','635','2022-06-11 20:06:59',10,0),('1','187',239770,'DAILY SHIFT','2022-06-12','2022-06-12 09:36:37','2022-06-13 09:36:37','635',0.00,0.00,'635','2022-06-12 17:14:13','635','2022-06-12 17:14:33',10,0),('1','187',239771,'DAILY SHIFT','2022-06-13','2022-06-13 08:06:01','2022-06-14 08:06:01','635',0.00,0.00,'635','2022-06-13 18:01:01','635','2022-06-13 18:01:56',10,0),('1','187',239772,'DAILY SHIFT','2022-06-13','2022-06-13 20:37:27','2022-06-14 20:37:27','635',0.00,0.00,'635','2022-06-13 20:40:39','635','2022-06-13 20:40:57',10,0),('1','187',239773,'DAILY SHIFT ','2022-06-14','2022-06-14 09:09:20','2022-06-15 09:09:20','635',0.00,0.00,'635','2022-06-14 19:15:37','635','2022-06-14 19:15:53',10,0),('1','187',239774,'DAILY SHIFT','2022-06-15','2022-06-15 08:34:34','2022-06-16 08:34:34','635',0.00,0.00,'635','2022-06-15 18:56:47','635','2022-06-15 18:57:05',10,0),('1','187',239775,'DAILY SHIFT ','2022-06-16','2022-06-16 07:43:42','2022-06-17 07:43:42','635',0.00,0.00,'635','2022-06-16 18:39:51','635','2022-06-16 18:40:08',10,0),('1','187',239776,'DAILY SHIFT ','2022-06-17','2022-06-17 08:30:25','2022-06-18 08:30:25','635',0.00,0.00,'635','2022-06-17 18:56:06','635','2022-06-17 18:56:39',10,0),('1','187',239777,'DAILY SHIFT ','2022-06-18','2022-06-18 08:16:44','2022-06-19 08:16:44','635',0.00,0.00,'635','2022-06-18 18:59:54','635','2022-06-18 19:00:12',10,0),('1','187',239778,'DAILY SHIFT ','2022-06-19','2022-06-19 10:09:21','2022-06-20 10:09:21','635',0.00,0.00,'635','2022-06-19 17:04:19','635','2022-06-19 17:04:35',10,0),('1','187',239779,'DAILY SHIFT ','2022-06-20','2022-06-20 07:50:57','2022-06-21 07:50:57','635',0.00,0.00,'635','2022-06-20 18:27:13','635','2022-06-20 18:27:33',10,0),('1','187',239780,'DAILY SHIFT ','2022-06-21','2022-06-21 08:12:25','2022-06-22 08:12:25','635',0.00,0.00,'635','2022-06-21 17:18:40','635','2022-06-21 17:19:05',10,0),('1','187',239781,'DAILY SHIFT','2022-06-21','2022-06-21 17:54:21','2022-06-22 17:54:21','635',0.00,0.00,'635','2022-06-21 18:01:52','635','2022-06-21 18:02:10',10,0),('1','187',239782,'DAILY SHIFT','2022-06-21','2022-06-21 18:11:43','2022-06-22 18:11:43','635',0.00,0.00,'635','2022-06-21 18:38:13','635','2022-06-21 18:38:28',10,0),('1','187',239783,'DAILY SHIFT','2022-06-26','2022-06-26 08:48:03','2022-06-27 08:48:03','635',0.00,0.00,'635','2022-06-26 16:48:57','635','2022-06-26 16:49:23',10,0),('1','187',239784,'DAILY SHIFT','2022-06-27','2022-06-27 08:14:43','2022-06-28 08:14:43','635',0.00,0.00,'635','2022-06-27 19:15:29','635','2022-06-27 19:15:48',10,0),('1','187',239785,'DAILY SHIFT','2022-06-28','2022-06-28 08:59:24','2022-06-29 08:59:24','635',0.00,0.00,'635','2022-06-28 21:28:31','635','2022-06-28 21:29:30',10,0),('1','187',239786,'DAILY SHIFT ','2022-06-29','2022-06-29 08:41:47','2022-06-30 08:41:47','635',0.00,0.00,'635','2022-06-29 18:21:28','635','2022-06-29 18:21:50',10,0),('1','187',239787,'Daily shift ','2022-06-30','2022-06-30 09:06:13','2022-07-01 09:06:13','635',0.00,0.00,'635','2022-06-30 19:23:21','635','2022-06-30 19:23:39',10,0),('1','187',239788,'DAILY SHIFT','2022-07-01','2022-07-01 08:07:56','2022-07-02 08:07:56','635',0.00,0.00,'635','2022-07-01 21:03:58','635','2022-07-01 21:04:23',10,0),('1','187',239789,'DAILY SHIFT','2022-07-02','2022-07-02 08:16:36','2022-07-03 08:16:36','635',0.00,0.00,'635','2022-07-02 18:02:03','635','2022-07-02 18:02:19',10,0),('1','187',239790,'DAILY SHIFT','2022-07-02','2022-07-02 18:02:41','2022-07-03 18:02:41','635',0.00,0.00,'635','2022-07-02 18:06:27','635','2022-07-02 18:06:42',10,0),('1','187',239791,'DAILY SHIFT ','2022-07-07','2022-07-07 07:32:04','2022-07-08 07:32:04','635',0.00,0.00,'635','2022-07-07 23:08:12','635','2022-07-07 23:08:39',10,0),('1','187',239792,'DAILY SHIFT ','2022-07-08','2022-07-08 08:52:55','2022-07-09 08:52:55','635',0.00,0.00,'635','2022-07-08 22:13:36','635','2022-07-08 22:14:17',10,0),('1','187',239793,'DAILY SHIFT ','2022-07-09','2022-07-09 11:01:59','2022-07-10 11:01:59','635',0.00,0.00,'635','2022-07-10 07:25:55','635','2022-07-10 07:26:10',10,0),('1','187',239794,'DAILY SHIFT','2022-07-10','2022-07-10 08:30:28','2022-07-11 08:30:28','635',0.00,0.00,'635','2022-07-11 00:38:23','635','2022-07-11 00:38:46',10,0),('1','187',239795,'DAILY SHIFT ','2022-07-11','2022-07-11 07:51:53','2022-07-12 07:51:53','635',0.00,0.00,'635','2022-07-11 19:38:11','635','2022-07-11 19:38:25',10,0),('1','187',239796,'DAILY SHIFT ','2022-07-12','2022-07-12 08:01:39','2022-07-13 08:01:39','635',0.00,0.00,'635','2022-07-12 16:35:29','635','2022-07-12 16:35:50',10,0),('1','187',239797,'OPERATIONAL LOSS','2022-07-12','2022-07-12 16:36:57','2022-07-13 16:36:57','635',0.00,0.00,'635','2022-07-12 17:03:27','635','2022-07-12 17:03:49',10,0),('1','187',239798,'DAILY SHIFT','2022-07-13','2022-07-13 08:18:21','2022-07-14 08:18:21','635',0.00,0.00,'635','2022-07-13 19:16:45','635','2022-07-13 19:16:59',10,0),('1','187',239799,'DAILY SHIFT ','2022-07-14','2022-07-14 08:08:54','2022-07-15 08:08:54','635',0.00,0.00,'635','2022-07-14 19:13:51','635','2022-07-14 19:14:28',10,0),('1','187',239800,'DAILY SHIFT ','2022-07-15','2022-07-15 07:12:22','2022-07-16 07:12:22','635',0.00,0.00,'635','2022-07-15 19:07:24','635','2022-07-15 19:07:40',10,0),('1','187',239801,'DAILY SHIFT ','2022-07-16','2022-07-16 06:51:25','2022-07-17 06:51:25','635',0.00,0.00,'635','2022-07-16 19:38:52','635','2022-07-16 19:39:20',10,0),('1','187',239802,'DAILY SHIFT ','2022-07-17','2022-07-17 09:16:06','2022-07-18 09:16:06','635',0.00,0.00,'635','2022-07-17 20:09:38','635','2022-07-17 20:10:01',10,0),('1','187',239803,'DAILY SHIFT ','2022-07-18','2022-07-18 07:08:18','2022-07-19 07:08:18','635',0.00,0.00,'635','2022-07-18 18:43:09','635','2022-07-18 18:43:27',10,0),('1','187',239804,'DAILY SHIFT ','2022-07-19','2022-07-19 07:22:47','2022-07-20 07:22:47','635',0.00,0.00,'635','2022-07-19 18:19:07','635','2022-07-19 18:19:24',10,0),('1','187',239805,'DAILY SHIFT ','2022-07-20','2022-07-20 07:48:23','2022-07-21 07:48:23','635',0.00,0.00,'635','2022-07-20 18:20:36','635','2022-07-20 18:20:56',10,0),('1','187',239806,'DAILY SHIFT ','2022-07-21','2022-07-21 07:10:18','2022-07-22 07:10:18','635',0.00,0.00,'635','2022-07-21 18:16:02','635','2022-07-21 18:16:22',10,0),('1','187',239807,'DAILY SHIFT ','2022-07-22','2022-07-22 07:46:16','2022-07-23 07:46:16','635',0.00,0.00,'635','2022-07-22 18:19:17','635','2022-07-22 18:19:34',10,0),('1','187',239808,'DAILY SHIFT ','2022-07-23','2022-07-23 08:04:06','2022-07-24 08:04:06','635',0.00,0.00,'635','2022-07-23 18:12:44','635','2022-07-23 18:12:59',10,0),('1','187',239809,'OPRETIONAL LOSS','2022-07-23','2022-07-23 20:16:24','2022-07-24 20:16:24','635',0.00,0.00,'635','2022-07-23 21:16:30','635','2022-07-23 21:16:52',10,0),('1','187',239810,'DAILY SHIFT ','2022-07-24','2022-07-24 08:19:00','2022-07-25 08:19:00','635',0.00,0.00,'635','2022-07-24 17:34:21','635','2022-07-24 17:34:44',10,0),('1','187',239811,'Daily shift','2022-07-25','2022-07-25 07:08:29','2022-07-26 07:08:29','635',0.00,0.00,'635','2022-07-25 19:56:55','635','2022-07-25 19:57:17',10,0),('1','187',239812,'DAILY SHIFT','2022-07-26','2022-07-26 08:25:16','2022-07-27 08:25:16','635',0.00,0.00,'635','2022-07-26 18:46:32','635','2022-07-26 18:46:52',10,0),('1','187',239813,'Daily shift','2022-07-27','2022-07-27 07:05:21','2022-07-28 07:05:21','635',0.00,0.00,'635','2022-07-27 20:41:01','635','2022-07-27 20:41:24',10,0),('1','187',239814,'DAILY SHIFT','2022-07-28','2022-07-28 08:24:52','2022-07-29 08:24:52','635',0.00,0.00,'635','2022-07-28 19:51:36','635','2022-07-28 19:51:58',10,0),('1','187',239815,'DAILY SHIFT ','2022-07-29','2022-07-29 08:24:01','2022-07-30 08:24:01','635',0.00,0.00,'635','2022-07-29 20:50:04','635','2022-07-29 20:50:28',10,0),('1','187',239816,'DAILY SHIFT ','2022-07-30','2022-07-30 07:39:30','2022-07-31 07:39:30','635',0.00,0.00,'635','2022-07-30 18:38:52','635','2022-07-30 18:39:09',10,0),('1','187',239817,'DAILY SHIFT ','2022-07-31','2022-07-31 07:44:03','2022-08-01 07:44:03','635',0.00,0.00,'635','2022-07-31 18:40:32','635','2022-07-31 18:40:52',10,0),('1','187',239818,'DAILY SHIFT ','2022-08-01','2022-08-01 08:23:39','2022-08-02 08:23:39','635',0.00,0.00,'635','2022-08-01 19:46:13','635','2022-08-01 19:46:33',10,0),('1','187',239819,'DAILY SHIFT ','2022-08-02','2022-08-02 07:54:02','2022-08-03 07:54:02','635',0.00,0.00,'635','2022-08-02 21:22:58','635','2022-08-02 21:23:25',10,0),('1','187',239820,'OPERATIONAL LOSS','2022-08-02','2022-08-02 21:31:08','2022-08-03 21:31:08','635',0.00,0.00,'635','2022-08-02 21:39:09','635','2022-08-02 21:39:36',10,0),('1','187',239821,'DAILY SHIFT ','2022-08-03','2022-08-03 08:49:28','2022-08-04 08:49:28','635',0.00,0.00,'635','2022-08-03 18:51:26','635','2022-08-03 18:51:47',10,0),('1','187',239822,'DAILY SHIFT','2022-08-04','2022-08-04 07:43:00','2022-08-05 07:43:00','635',0.00,0.00,'635','2022-08-04 21:03:36','635','2022-08-04 21:04:08',10,0),('1','187',239823,'DAILY SHIFT','2022-08-05','2022-08-05 07:53:33','2022-08-06 07:53:33','635',0.00,0.00,'635','2022-08-05 18:51:39','635','2022-08-05 18:51:58',10,0),('1','187',239824,'DAILY SHIFT','2022-08-06','2022-08-06 08:06:02','2022-08-07 08:06:02','635',0.00,0.00,'635','2022-08-06 19:35:01','635','2022-08-06 19:35:23',10,0),('1','187',239825,'DAILY SHIFT','2022-08-07','2022-08-07 09:11:32','2022-08-08 09:11:32','635',0.00,0.00,'635','2022-08-07 18:48:20','635','2022-08-07 18:48:45',10,0),('1','187',239826,'DAILY SHIFT','2022-08-08','2022-08-08 08:09:09','2022-08-09 08:09:09','635',0.00,0.00,'635','2022-08-08 18:21:58','635','2022-08-08 18:22:22',10,0),('1','187',239827,'DAILY SHIFT','2022-08-10','2022-08-10 07:54:20','2022-08-11 07:54:20','635',0.00,0.00,'635','2022-08-10 08:15:06','635','2022-08-10 08:15:31',10,0),('1','187',239828,'OPRETIONAL LOSS ','2022-08-10','2022-08-10 08:16:31','2022-08-11 08:16:31','635',0.00,0.00,'635','2022-08-10 08:23:47','635','2022-08-10 08:24:07',10,0),('1','187',239829,'DAILY SHIFT','2022-08-10','2022-08-10 10:25:11','2022-08-11 10:25:11','635',0.00,0.00,'635','2022-08-10 18:47:03','635','2022-08-10 18:47:29',10,0),('1','187',239830,'DAILY SHIFT','2022-08-11','2022-08-11 08:02:01','2022-08-12 08:02:01','635',0.00,0.00,'635','2022-08-11 19:06:24','635','2022-08-11 19:06:47',10,0),('1','187',239831,'DAILY SHIFT','2022-08-12','2022-08-12 08:09:33','2022-08-13 08:09:33','635',0.00,0.00,'635','2022-08-12 20:49:34','635','2022-08-12 20:49:58',10,0),('1','187',239832,'DAILY SHIFT','2022-08-13','2022-08-13 08:05:00','2022-08-14 08:05:00','635',0.00,0.00,'635','2022-08-14 08:59:58','635','2022-08-14 09:00:37',10,0),('1','187',239833,'DAILY SHIFT','2022-08-14','2022-08-14 09:01:58','2022-08-15 09:01:58','635',0.00,0.00,'635','2022-08-14 18:42:14','635','2022-08-14 18:42:32',10,0),('1','187',239834,'DAILY SHIFT','2022-08-15','2022-08-15 08:08:35','2022-08-16 08:08:35','635',0.00,0.00,'635','2022-08-15 20:33:49','635','2022-08-15 20:34:16',10,0),('1','187',239835,'DAILY SHIFT','2022-08-16','2022-08-16 08:24:23','2022-08-17 08:24:23','635',0.00,0.00,'635','2022-08-16 20:31:46','635','2022-08-16 20:32:13',10,0),('1','187',239836,'DAILY SHIFT','2022-08-17','2022-08-17 08:06:40','2022-08-18 08:06:40','635',0.00,0.00,'635','2022-08-17 14:47:06','635','2022-08-17 14:47:25',10,0),('1','187',239837,'OPRETIONAL LOSS  ','2022-08-17','2022-08-17 14:48:14','2022-08-18 14:48:14','635',0.00,0.00,'635','2022-08-17 14:51:54','635','2022-08-17 14:52:15',10,0),('1','187',239838,'DAILY SHIFT','2022-08-17','2022-08-17 15:13:31','2022-08-18 15:13:31','635',0.00,0.00,'635','2022-08-17 21:25:14','635','2022-08-17 21:25:40',10,0),('1','187',239839,'DAILY SHIFT','2022-08-18','2022-08-18 08:07:11','2022-08-19 08:07:11','635',0.00,0.00,'635','2022-08-18 19:55:40','635','2022-08-18 19:55:58',10,0),('1','187',239840,'DAILY SHIFT ','2022-08-19','2022-08-19 07:07:05','2022-08-20 07:07:05','635',0.00,0.00,'635','2022-08-19 18:39:53','635','2022-08-19 18:40:16',10,0),('1','187',239841,'DAILY SHIFT','2022-08-20','2022-08-20 08:03:53','2022-08-21 08:03:53','635',0.00,0.00,'635','2022-08-20 21:51:34','635','2022-08-20 21:52:01',10,0),('1','187',239842,'DAILY SHIFT','2022-08-21','2022-08-21 09:29:13','2022-08-22 09:29:13','635',0.00,0.00,'635','2022-08-21 20:51:01','635','2022-08-21 20:51:22',10,0),('1','187',239843,'DAILY SHIFT','2022-08-22','2022-08-22 08:12:23','2022-08-23 08:12:23','635',0.00,0.00,'635','2022-08-22 20:21:47','635','2022-08-22 20:22:09',10,0),('1','187',239844,'DAILY SHIFT ','2022-08-23','2022-08-23 08:09:33','2022-08-24 08:09:33','635',0.00,0.00,'635','2022-08-23 21:15:48','635','2022-08-23 21:16:17',10,0),('1','187',239845,'DAILY SHIFT','2022-08-24','2022-08-24 07:37:38','2022-08-25 07:37:38','635',0.00,0.00,'635','2022-08-24 22:18:08','635','2022-08-24 22:18:37',10,0),('1','187',239846,'DAILY SHIFT','2022-08-25','2022-08-25 08:12:51','2022-08-26 08:12:51','635',0.00,0.00,'635','2022-08-25 21:03:51','635','2022-08-25 21:09:09',10,0),('1','187',239847,'DAILY SHIFT','2022-08-26','2022-08-26 08:37:08','2022-08-27 08:37:08','635',0.00,0.00,'635','2022-08-26 19:56:15','635','2022-08-26 19:56:57',10,0),('1','187',239848,'OPRETIONAL LOSS   ','2022-08-28','2022-08-28 09:35:17','2022-08-29 09:35:17','635',0.00,0.00,'635','2022-08-28 09:38:15','635','2022-08-28 09:38:38',10,0),('1','187',239849,'DAILY SHIFT','2022-08-28','2022-08-28 09:57:37','2022-08-29 09:57:37','635',0.00,0.00,'635','2022-08-28 22:26:23','635','2022-08-28 22:26:45',10,0),('1','187',239850,'DAILY SHIFT','2022-08-29','2022-08-29 08:08:02','2022-08-30 08:08:02','635',0.00,0.00,'635','2022-08-29 21:08:29','635','2022-08-29 21:09:03',10,0),('1','187',239851,'DAILY SHIFT','2022-08-30','2022-08-30 08:08:50','2022-08-31 08:08:50','635',0.00,0.00,'635','2022-08-30 18:37:26','635','2022-08-30 18:37:45',10,0),('1','187',239852,'DAILY SHIFT','2022-08-31','2022-08-31 07:39:04','2022-09-01 07:39:04','635',0.00,0.00,'635','2022-08-31 19:38:13','635','2022-08-31 19:38:37',10,0),('1','187',239853,'DAILY SHIFT','2022-09-01','2022-09-01 08:06:39','2022-09-02 08:06:39','635',0.00,0.00,'635','2022-09-01 21:12:46','635','2022-09-01 21:13:10',10,0),('1','187',239854,'DAILY SHIFT','2022-09-02','2022-09-02 08:13:32','2022-09-03 08:13:32','635',0.00,0.00,'635','2022-09-02 19:57:00','635','2022-09-02 19:57:27',10,0),('1','187',239855,'DAILY SHIFT','2022-09-03','2022-09-03 07:39:33','2022-09-04 07:39:33','635',0.00,0.00,'635','2022-09-03 20:46:52','635','2022-09-03 20:47:18',10,0),('1','187',239856,'DAILY SHIFT','2022-09-04','2022-09-04 08:02:04','2022-09-05 08:02:04','635',0.00,0.00,'635','2022-09-04 21:43:14','635','2022-09-04 21:43:36',10,0),('1','187',239857,'DAILY SHIFT ','2022-09-05','2022-09-05 17:16:42','2022-09-06 17:16:42','635',0.00,0.00,'635','2022-09-05 22:11:38','635','2022-09-05 22:12:04',10,0),('1','187',239858,'OPRETIONAL LOSS','2022-09-06','2022-09-06 21:42:19','2022-09-07 21:42:19','635',0.00,0.00,'635','2022-09-06 22:07:40','635','2022-09-06 22:08:02',10,0),('1','187',239859,'DAILY SHIFT','2022-09-07','2022-09-07 08:33:46','2022-09-08 08:33:46','635',0.00,0.00,'635','2022-09-07 18:45:24','635','2022-09-07 18:45:42',10,0),('1','187',239860,'DAILY SHIFT','2022-09-08','2022-09-08 08:29:52','2022-09-09 08:29:52','635',0.00,0.00,'635','2022-09-08 19:11:49','635','2022-09-08 19:12:09',10,0),('1','187',239861,'DAILY SHIFT','2022-09-09','2022-09-09 08:06:49','2022-09-10 08:06:49','635',0.00,0.00,'635','2022-09-09 20:22:46','635','2022-09-09 20:23:08',10,0),('1','187',239862,'DAILY SHIFT','2022-09-10','2022-09-10 08:07:56','2022-09-11 08:07:56','635',0.00,0.00,'635','2022-09-10 21:23:32','635','2022-09-10 21:24:00',10,0),('1','187',239863,'DAILY SHIFT ','2022-09-11','2022-09-11 07:15:23','2022-09-12 07:15:23','635',0.00,0.00,'635','2022-09-11 21:18:10','635','2022-09-11 21:18:30',10,0),('1','187',239864,'DAILY SHIFT','2022-09-12','2022-09-12 08:20:50','2022-09-13 08:20:50','635',0.00,0.00,'635','2022-09-12 21:42:27','635','2022-09-12 21:42:50',10,0),('1','187',239865,'DAILY SHIFT','2022-09-13','2022-09-13 08:23:18','2022-09-14 08:23:18','635',0.00,0.00,'635','2022-09-13 20:17:30','635','2022-09-13 20:17:52',10,0),('1','187',239866,'DAILY SHIFT','2022-09-14','2022-09-14 07:38:05','2022-09-15 07:38:05','635',0.00,0.00,'635','2022-09-14 18:45:40','635','2022-09-14 18:45:57',10,0),('1','187',239867,'DAILY SHIFT ','2022-09-15','2022-09-15 08:06:26','2022-09-16 08:06:26','635',0.00,0.00,'635','2022-09-15 10:51:35','635','2022-09-15 10:51:52',10,0),('1','187',239868,'DAILY SHIFT','2022-09-15','2022-09-15 10:52:58','2022-09-16 10:52:58','635',0.00,0.00,'635','2022-09-15 10:56:32','635','2022-09-15 10:56:47',10,0),('1','187',239869,'DAILY SHIFT ','2022-09-15','2022-09-15 13:36:08','2022-09-16 13:36:08','635',0.00,0.00,'635','2022-09-15 20:53:22','635','2022-09-15 20:58:04',10,0),('1','187',239870,'DAILY SHIFT','2022-09-16','2022-09-16 08:35:29','2022-09-17 08:35:29','635',0.00,0.00,'635','2022-09-16 18:24:05','635','2022-09-16 18:24:24',10,0),('1','187',239871,'DAILY SHIFT','2022-09-17','2022-09-17 08:41:36','2022-09-18 08:41:36','635',0.00,0.00,'635','2022-09-17 20:44:10','635','2022-09-17 20:44:38',10,0),('1','187',239872,'DAILY SHIFT ','2022-09-18','2022-09-18 08:52:21','2022-09-19 08:52:21','635',0.00,0.00,'635','2022-09-18 19:38:16','635','2022-09-18 19:38:50',10,0),('1','187',239873,'DAILY SHIFT','2022-09-19','2022-09-19 09:06:30','2022-09-20 09:06:30','635',0.00,0.00,'635','2022-09-19 20:23:24','635','2022-09-19 20:23:43',10,0),('1','187',239874,'DAILY SHIFT','2022-09-20','2022-09-20 07:56:04','2022-09-21 07:56:04','635',0.00,0.00,'635','2022-09-20 18:47:17','635','2022-09-20 18:47:36',10,0),('1','187',239875,'DAILY SHIFT','2022-09-21','2022-09-21 08:03:28','2022-09-22 08:03:28','635',0.00,0.00,'635','2022-09-21 20:27:16','635','2022-09-21 20:27:35',10,0),('1','187',239876,'DAILY SHIFT','2022-09-22','2022-09-22 08:12:41','2022-09-23 08:12:41','635',0.00,0.00,'635','2022-09-22 21:37:41','635','2022-09-22 21:38:08',10,0),('1','187',239877,'DAILY SHIFT','2022-09-23','2022-09-23 07:34:15','2022-09-24 07:34:15','635',0.00,0.00,'635','2022-09-24 11:34:08','635','2022-09-24 11:34:37',10,0),('1','187',239878,'DAILY SHIFT ','2022-09-25','2022-09-25 08:07:48','2022-09-26 08:07:48','635',0.00,0.00,'635','2022-09-25 15:54:56','635','2022-09-26 00:14:49',10,0),('1','187',239879,'DAILY SHIFT','2022-09-26','2022-09-26 09:11:55','2022-09-27 09:11:55','635',0.00,0.00,'635','2022-09-26 09:24:22','635','2022-09-26 09:26:32',10,0),('1','187',239880,'DAILY SHIFT','2022-09-26','2022-09-26 09:26:57','2022-09-27 09:26:57','635',0.00,0.00,'635','2022-09-26 18:51:31','635','2022-09-26 18:51:50',10,0),('1','187',239881,'DAILY SHIFT','2022-09-27','2022-09-27 09:16:24','2022-09-28 09:16:24','635',0.00,0.00,'635','2022-09-27 18:58:46','635','2022-09-27 18:59:02',10,0),('1','187',239882,'DAILY SHIFT','2022-09-28','2022-09-28 08:15:32','2022-09-29 08:15:32','635',0.00,0.00,'635','2022-09-28 18:32:27','635','2022-09-28 18:32:58',10,0),('1','187',239883,'DAILY SHIFT','2022-09-29','2022-09-29 08:08:52','2022-09-30 08:08:52','635',0.00,0.00,'635','2022-09-30 08:34:24','635','2022-09-30 08:35:01',10,0),('1','187',239884,'DAILY SHIFT','2022-09-30','2022-09-30 08:36:24','2022-10-01 08:36:24','635',0.00,0.00,'635','2022-09-30 18:27:30','635','2022-09-30 18:27:52',10,0),('1','187',239885,'DAILY SHIFT','2022-10-01','2022-10-01 07:58:08','2022-10-02 07:58:08','635',0.00,0.00,'635','2022-10-01 19:21:31','635','2022-10-01 19:40:29',10,0),('1','187',239886,'DAILY SHIFT ','2022-10-02','2022-10-02 09:50:41','2022-10-03 09:50:41','635',0.00,0.00,'635','2022-10-02 19:48:11','635','2022-10-02 19:48:34',10,0),('1','187',239887,'DAILY SHIFT','2022-10-03','2022-10-03 07:51:13','2022-10-04 07:51:13','635',0.00,0.00,'635','2022-10-03 22:22:29','635','2022-10-03 22:23:17',10,0),('1','187',239888,'DAILY SHIFT','2022-10-04','2022-10-04 15:22:19','2022-10-05 15:22:19','635',0.00,0.00,'635','2022-10-04 15:30:41','635','2022-10-04 15:31:13',10,0),('1','187',239889,'DAILY SHIFT','2022-10-04','2022-10-04 15:31:42','2022-10-05 15:31:42','635',0.00,0.00,'635','2022-10-04 15:39:54','635','2022-10-04 15:40:11',10,0),('1','187',239890,'DAILY SHIFT','2022-10-04','2022-10-04 15:40:33','2022-10-05 15:40:33','635',0.00,0.00,'635','2022-10-04 19:28:00','635','2022-10-04 19:28:16',10,0),('1','187',239891,'DAILY SHIFT','2022-10-05','2022-10-05 08:00:12','2022-10-06 08:00:12','635',0.00,0.00,'635','2022-10-05 19:01:59','635','2022-10-05 19:02:16',10,0),('1','187',239892,'DAILY SHIFT','2022-10-06','2022-10-06 08:22:12','2022-10-07 08:22:12','635',0.00,0.00,'635','2022-10-06 20:50:54','635','2022-10-06 20:51:17',10,0),('1','187',239893,'DAILY SHIFT','2022-10-07','2022-10-07 08:00:09','2022-10-08 08:00:09','635',0.00,0.00,'635','2022-10-07 19:40:46','635','2022-10-07 19:41:02',10,0),('1','187',239894,'DAILY SHIFT','2022-10-08','2022-10-08 08:06:56','2022-10-09 08:06:56','635',0.00,0.00,'635','2022-10-08 18:33:11','635','2022-10-08 18:35:27',10,0),('1','187',239895,'DAILY SHIFT ','2022-10-09','2022-10-09 08:59:02','2022-10-10 08:59:02','635',0.00,0.00,'635','2022-10-10 00:05:29','635','2022-10-10 00:05:46',10,0),('1','187',239896,'DAILY SHIFT','2022-10-10','2022-10-10 08:51:10','2022-10-11 08:51:10','635',0.00,0.00,'635','2022-10-10 18:42:18','635','2022-10-10 18:42:32',10,0),('1','187',239897,'DAILY SHIFT','2022-10-11','2022-10-11 09:04:08','2022-10-12 09:04:08','635',0.00,0.00,'635','2022-10-11 21:38:19','635','2022-10-11 21:38:48',10,0),('1','187',239898,'DAILY SHIFT','2022-10-13','2022-10-13 09:59:06','2022-10-14 09:59:06','635',0.00,0.00,'635','2022-10-13 11:11:13','635','2022-10-13 11:14:27',10,0),('1','187',239899,'DAILY SHIFT    ','2022-10-13','2022-10-13 11:15:06','2022-10-14 11:15:06','635',0.00,0.00,'635','2022-10-13 11:18:33','635','2022-10-13 11:18:50',10,0),('1','187',239900,'DAILY SHIFT    ','2022-10-13','2022-10-13 11:23:30','2022-10-14 11:23:30','635',0.00,0.00,'635','2022-10-13 19:04:15','635','2022-10-13 19:04:39',10,0),('1','187',239901,'DAILY SHIFT','2022-10-14','2022-10-14 07:37:34','2022-10-15 07:37:34','635',0.00,0.00,'635','2022-10-14 19:42:47','635','2022-10-14 19:43:12',10,0),('1','187',239902,'DAILY SHIFT','2022-10-15','2022-10-15 08:22:04','2022-10-16 08:22:04','635',0.00,0.00,'635','2022-10-15 20:18:10','635','2022-10-15 20:18:58',10,0),('1','187',239903,'DAILY SHIFT','2022-10-16','2022-10-16 10:14:52','2022-10-17 10:14:52','635',0.00,0.00,'635','2022-10-16 21:10:05','635','2022-10-16 21:11:02',10,0),('1','187',239904,'DAILY SHIFT','2022-10-17','2022-10-17 08:12:42','2022-10-18 08:12:42','635',0.00,0.00,'635','2022-10-17 19:20:04','635','2022-10-17 19:20:29',10,0),('1','187',239905,'DAILY SHIFT','2022-10-18','2022-10-18 08:07:27','2022-10-19 08:07:27','635',0.00,0.00,'635','2022-10-18 18:58:46','635','2022-10-18 18:59:06',10,0),('1','187',239906,'OPRETIONAL LOSS ','2022-10-18','2022-10-18 19:03:48','2022-10-19 19:03:48','635',0.00,0.00,'635','2022-10-18 19:06:58','635','2022-10-18 19:07:20',10,0),('1','187',239907,'DAILY SHIFT','2022-10-19','2022-10-19 08:07:39','2022-10-20 08:07:39','635',0.00,0.00,'635','2022-10-19 21:08:52','635','2022-10-19 21:09:24',10,0),('1','187',239908,'DAILY SHIFT','2022-10-20','2022-10-20 07:57:39','2022-10-21 07:57:39','635',0.00,0.00,'635','2022-10-20 20:12:58','635','2022-10-20 20:13:22',10,0),('1','187',239909,'DAILY SHIFT','2022-10-21','2022-10-21 07:09:06','2022-10-22 07:09:06','635',0.00,0.00,'635','2022-10-21 19:03:50','635','2022-10-21 19:04:08',10,0),('1','187',239910,'DAILY SHIFT','2022-10-22','2022-10-22 07:58:18','2022-10-23 07:58:18','635',0.00,0.00,'635','2022-10-22 20:05:42','635','2022-10-22 20:06:04',10,0),('1','187',239911,'DAILY SHIFT','2022-10-23','2022-10-23 09:04:28','2022-10-24 09:04:28','635',0.00,0.00,'635','2022-10-23 20:37:52','635','2022-10-23 20:38:14',10,0),('1','187',239912,'DAILY SHIFT','2022-10-24','2022-10-24 08:08:03','2022-10-25 08:08:03','635',0.00,0.00,'635','2022-10-24 20:25:27','635','2022-10-24 20:25:51',10,0),('1','187',239913,'OPRETIONAL LOSS','2022-10-25','2022-10-25 12:06:10','2022-10-26 12:06:10','635',0.00,0.00,'635','2022-10-25 12:08:56','635','2022-10-25 12:09:15',10,0),('1','187',239914,'DAILY SHIFT','2022-10-26','2022-10-26 08:02:01','2022-10-27 08:02:01','635',0.00,0.00,'635','2022-10-26 19:18:26','635','2022-10-26 19:18:45',10,0),('1','187',239915,'DAILY SHIFT','2022-10-27','2022-10-27 08:06:05','2022-10-28 08:06:05','635',0.00,0.00,'635','2022-10-27 18:54:44','635','2022-10-27 18:55:07',10,0),('1','187',239916,'DAILY SHIFT','2022-10-28','2022-10-28 08:08:59','2022-10-29 08:08:59','635',0.00,0.00,'635','2022-10-28 18:55:49','635','2022-10-28 18:56:34',10,0),('1','187',239917,'DAILY SHIFT','2022-10-29','2022-10-29 08:04:48','2022-10-30 08:04:48','635',0.00,0.00,'635','2022-10-29 18:51:54','635','2022-10-29 18:52:13',10,0),('1','187',239918,'DAILY SHIFT','2022-10-30','2022-10-30 08:42:21','2022-10-31 08:42:21','635',0.00,0.00,'635','2022-10-30 21:25:48','635','2022-10-30 21:26:08',10,0),('1','187',239919,'DAILY SHIFT','2022-10-31','2022-10-31 08:02:57','2022-11-01 08:02:57','635',0.00,0.00,'635','2022-10-31 20:10:40','635','2022-10-31 20:11:04',10,0),('1','187',239920,'OPRETIONAL LOSS','2022-11-01','2022-11-01 10:03:14','2022-11-02 10:03:14','635',0.00,0.00,'635','2022-11-01 10:06:35','635','2022-11-01 10:06:53',10,0),('1','187',239921,'DAILY SHIFT','2022-11-04','2022-11-04 09:21:52','2022-11-05 09:21:52','635',0.00,0.00,'635','2022-11-04 19:20:10','635','2022-11-04 19:20:30',10,0),('1','187',239922,'DAILY SHIFT','2022-11-05','2022-11-05 08:05:49','2022-11-06 08:05:49','635',0.00,0.00,'635','2022-11-05 19:15:40','635','2022-11-05 19:16:00',10,0),('1','187',239923,'DAILY SHIFT','2022-11-06','2022-11-06 08:16:29','2022-11-07 08:16:29','635',0.00,0.00,'635','2022-11-06 17:39:25','635','2022-11-06 17:39:44',10,0),('1','187',239924,'DAILY SHIFT','2022-11-07','2022-11-07 08:03:03','2022-11-08 08:03:03','635',0.00,0.00,'635','2022-11-07 18:51:07','635','2022-11-07 18:51:27',10,0),('1','187',239925,'DAILY SHIFT','2022-11-08','2022-11-08 08:06:37','2022-11-09 08:06:37','635',0.00,0.00,'635','2022-11-08 13:21:15','635','2022-11-08 13:21:37',10,0),('1','187',239926,'OPRETIONAL LOSS ','2022-11-08','2022-11-08 16:04:05','2022-11-09 16:04:05','635',0.00,0.00,'635','2022-11-08 16:07:29','635','2022-11-08 16:07:52',10,0),('1','187',239927,'DAILY SHIFT','2022-11-09','2022-11-09 08:12:00','2022-11-10 08:12:00','635',0.00,0.00,'635','2022-11-09 18:46:16','635','2022-11-09 18:46:35',10,0),('1','187',239928,'DAILY SHIFT','2022-11-10','2022-11-10 07:36:47','2022-11-11 07:36:47','635',0.00,0.00,'635','2022-11-10 18:58:29','635','2022-11-10 18:58:49',10,0),('1','187',239929,'DAILY SHIFT','2022-11-11','2022-11-11 08:01:14','2022-11-12 08:01:14','635',0.00,0.00,'635','2022-11-11 21:14:02','635','2022-11-11 21:14:24',10,0),('1','187',239930,'DAILY SHIFT','2022-11-12','2022-11-12 10:39:37','2022-11-13 10:39:37','635',0.00,0.00,'635','2022-11-12 21:06:15','635','2022-11-12 21:06:43',10,0),('1','187',239931,'DAILY SHIFT','2022-11-13','2022-11-13 08:38:15','2022-11-14 08:38:15','635',0.00,0.00,'635','2022-11-13 19:51:23','635','2022-11-13 19:51:48',10,0),('1','187',239932,'DAILY SHIFT','2022-11-14','2022-11-14 07:53:13','2022-11-15 07:53:13','635',0.00,0.00,'635','2022-11-14 17:42:14','635','2022-11-14 17:42:34',10,0),('1','187',239933,'OPRETIONAL LOSS  ','2022-11-14','2022-11-14 17:53:38','2022-11-15 17:53:38','635',0.00,0.00,'635','2022-11-14 17:56:54','635','2022-11-14 17:57:17',10,0),('1','187',239934,'DAILY SHIFT','2022-11-16','2022-11-16 07:32:15','2022-11-17 07:32:15','635',0.00,0.00,'635','2022-11-16 19:36:42','635','2022-11-16 19:37:10',10,0),('1','187',239935,'DAILY SHIFT','2022-11-17','2022-11-17 07:53:57','2022-11-18 07:53:57','635',0.00,0.00,'635','2022-11-17 18:51:52','635','2022-11-17 18:52:16',10,0),('1','187',239936,'DAILY SHIFT','2022-11-18','2022-11-18 07:57:48','2022-11-19 07:57:48','635',0.00,0.00,'635','2022-11-18 18:14:35','635','2022-11-18 18:14:54',10,0),('1','187',239937,'DAILY SHIFT','2022-11-19','2022-11-19 08:15:17','2022-11-20 08:15:17','635',0.00,0.00,'635','2022-11-19 18:39:32','635','2022-11-19 18:39:51',10,0),('1','187',239938,'DAILY SHIFT','2022-11-20','2022-11-20 08:12:51','2022-11-21 08:12:51','635',0.00,0.00,'635','2022-11-20 20:50:50','635','2022-11-20 20:51:50',10,0),('1','187',239939,'DAILY SHIFT','2022-11-21','2022-11-21 08:12:13','2022-11-22 08:12:13','635',0.00,0.00,'635','2022-11-21 16:36:38','635','2022-11-21 16:36:58',10,0),('1','187',239940,'OPRETIONAL LOSS  ','2022-11-21','2022-11-21 16:48:24','2022-11-22 16:48:24','635',0.00,0.00,'635','2022-11-21 16:53:02','635','2022-11-21 16:53:27',10,0),('1','187',239941,'DAILY SHIFT','2022-11-22','2022-11-22 09:35:22','2022-11-23 09:35:22','635',0.00,0.00,'635','2022-11-22 19:14:17','635','2022-11-22 19:14:39',10,0),('1','187',239942,'DAILY SHIFT','2022-11-23','2022-11-23 09:54:59','2022-11-24 09:54:59','635',0.00,0.00,'635','2022-11-23 17:59:52','635','2022-11-23 18:00:12',10,0),('1','187',239943,'DAILY SHIFT','2022-11-24','2022-11-24 13:18:27','2022-11-25 13:18:27','635',0.00,0.00,'635','2022-11-24 20:11:34','635','2022-11-24 20:12:13',10,0),('1','187',239944,'DAILY SHIFT','2022-11-25','2022-11-25 08:09:49','2022-11-26 08:09:49','635',0.00,0.00,'635','2022-11-25 20:13:48','635','2022-11-25 20:14:07',10,0),('1','187',239945,'DAILY SHIFT','2022-11-26','2022-11-26 08:10:07','2022-11-27 08:10:07','635',0.00,0.00,'635','2022-11-26 18:41:32','635','2022-11-26 18:41:50',10,0),('1','187',239946,'DAILY SHIFT','2022-11-27','2022-11-27 08:55:41','2022-11-28 08:55:41','635',0.00,0.00,'635','2022-11-27 18:51:20','635','2022-11-27 18:51:39',10,0),('1','187',239947,'OPRETIONAL LOSS','2022-11-27','2022-11-27 20:33:17','2022-11-28 20:33:17','635',0.00,0.00,'635','2022-11-27 20:45:10','635','2022-11-27 20:45:33',10,0),('1','187',239948,'DAILY SHIFT','2022-11-28','2022-11-28 11:10:26','2022-11-29 11:10:26','635',0.00,0.00,'635','2022-11-28 19:44:17','635','2022-11-28 19:44:38',10,0),('1','187',239949,'DAILY SHIFT','2022-11-29','2022-11-29 08:23:48','2022-11-30 08:23:48','635',0.00,0.00,'635','2022-11-29 19:10:31','635','2022-11-29 19:10:54',10,0),('1','187',239950,'DAILY SHIFT','2022-11-30','2022-11-30 08:25:33','2022-12-01 08:25:33','635',0.00,0.00,'635','2022-11-30 20:29:38','635','2022-11-30 20:29:58',10,0),('1','187',239951,'DAILY SHIFT','2022-12-01','2022-12-01 08:19:58','2022-12-02 08:19:58','635',0.00,0.00,'635','2022-12-01 20:03:30','635','2022-12-01 20:03:52',10,0),('1','187',239952,'DAILY SHIFT','2022-12-02','2022-12-02 08:46:57','2022-12-03 08:46:57','635',0.00,0.00,'635','2022-12-02 21:13:37','635','2022-12-02 21:14:10',10,0),('1','187',239953,'OPRETIONAL LOSS','2022-12-04','2022-12-04 10:53:01','2022-12-05 10:53:01','635',0.00,0.00,'635','2022-12-04 10:57:36','635','2022-12-04 10:57:59',10,0),('1','187',239954,'DAILY SHIFT','2022-12-04','2022-12-04 14:01:09','2022-12-05 14:01:09','635',0.00,0.00,'635','2022-12-04 18:51:03','635','2022-12-04 18:51:23',10,0),('1','187',239955,'DAILY SHIFT','2022-12-05','2022-12-05 08:03:00','2022-12-06 08:03:00','635',0.00,0.00,'635','2022-12-05 19:25:02','635','2022-12-05 19:25:22',10,0),('1','187',239956,'DAILY SHIFT','2022-12-06','2022-12-06 08:04:13','2022-12-07 08:04:13','635',0.00,0.00,'635','2022-12-06 19:27:41','635','2022-12-06 19:27:58',10,0),('1','187',239957,'DAILY SHIFT','2022-12-07','2022-12-07 08:11:10','2022-12-08 08:11:10','635',0.00,0.00,'635','2022-12-08 08:11:21','635','2022-12-08 08:11:42',10,0),('1','187',239958,'DAILY SHIFT','2022-12-08','2022-12-08 08:12:09','2022-12-09 08:12:09','635',0.00,0.00,'635','2022-12-08 16:12:23','635','2022-12-08 16:12:46',10,0),('1','187',239959,'OPRETIONAL LOSS  ','2022-12-08','2022-12-08 21:56:02','2022-12-09 21:56:02','635',0.00,0.00,'635','2022-12-08 22:05:21','635','2022-12-08 22:06:23',10,0),('1','187',239960,'DAILY SHIFT','2022-12-09','2022-12-09 09:26:27','2022-12-10 09:26:27','635',0.00,0.00,'635','2022-12-09 23:23:15','635','2022-12-09 23:23:52',10,0),('1','187',239961,'DAILY SHIFT','2022-12-10','2022-12-10 07:35:56','2022-12-11 07:35:56','635',0.00,0.00,'635','2022-12-10 22:40:22','635','2022-12-10 22:53:42',10,0),('1','187',239962,'DAILY SHIFT','2022-12-11','2022-12-11 10:03:31','2022-12-12 10:03:31','635',0.00,0.00,'635','2022-12-11 21:17:09','635','2022-12-11 21:17:38',10,0),('1','187',239963,'DAILY SHIFT','2022-12-12','2022-12-12 07:59:49','2022-12-13 07:59:49','635',0.00,0.00,'635','2022-12-12 18:51:55','635','2022-12-12 18:52:18',10,0),('1','187',239964,'DAILY SHIFT','2022-12-13','2022-12-13 08:13:58','2022-12-14 08:13:58','635',0.00,0.00,'635','2022-12-13 19:38:35','635','2022-12-13 19:38:54',10,0),('1','187',239965,'OPRETIONAL LOSS ','2022-12-13','2022-12-13 19:48:01','2022-12-14 19:48:01','635',0.00,0.00,'635','2022-12-13 19:50:26','635','2022-12-13 19:50:43',10,0),('1','187',239966,'DAILY SHIFT','2022-12-14','2022-12-14 08:12:53','2022-12-15 08:12:53','635',0.00,0.00,'635','2022-12-14 22:55:20','635','2022-12-14 22:56:01',10,0),('1','187',239967,'DAILY SHIFT','2022-12-15','2022-12-15 08:06:17','2022-12-16 08:06:17','635',0.00,0.00,'635','2022-12-15 19:58:39','635','2022-12-15 19:58:57',10,0),('1','187',239968,'DAILY SHIFT','2022-12-16','2022-12-16 08:32:46','2022-12-17 08:32:46','635',0.00,0.00,'635','2022-12-17 08:10:58','635','2022-12-17 08:11:28',10,0),('1','187',239969,'DAILY SHIFT','2022-12-17','2022-12-17 08:11:44','2022-12-18 08:11:44','635',0.00,0.00,'635','2022-12-17 14:03:22','635','2022-12-17 14:07:29',10,0),('1','187',239970,'OPRETIONAL LOSS','2022-12-17','2022-12-17 14:30:03','2022-12-18 14:30:03','635',0.00,0.00,'635','2022-12-17 14:37:52','635','2022-12-17 14:38:13',10,0),('1','187',239971,'DAILY SHIFT','2022-12-17','2022-12-17 14:46:53','2022-12-18 14:46:53','635',0.00,0.00,'635','2022-12-17 20:59:32','635','2022-12-17 20:59:57',10,0),('1','187',239972,'DAILY SHIFT','2022-12-18','2022-12-18 09:13:40','2022-12-19 09:13:40','635',0.00,0.00,'635','2022-12-19 08:47:17','635','2022-12-19 08:47:40',10,0),('1','187',239973,'DAILY SHIFT','2022-12-19','2022-12-19 08:47:52','2022-12-20 08:47:52','635',0.00,0.00,'635','2022-12-19 21:59:15','635','2022-12-19 22:03:53',10,0),('1','187',239974,'DAILY SHIFT','2022-12-20','2022-12-20 08:03:23','2022-12-21 08:03:23','635',0.00,0.00,'635','2022-12-20 19:23:53','635','2022-12-20 19:24:14',10,0),('1','187',239975,'DAILY SHIFT','2022-12-21','2022-12-21 08:02:54','2022-12-22 08:02:54','635',0.00,0.00,'635','2022-12-21 17:01:20','635','2022-12-21 17:01:48',10,0),('1','187',239976,'OPRETIONAL LOSS','2022-12-21','2022-12-21 17:31:08','2022-12-22 17:31:08','635',0.00,0.00,'635','2022-12-21 17:34:09','635','2022-12-21 17:34:28',10,0),('1','187',239977,'DAILY SHIFT','2022-12-22','2022-12-22 08:13:03','2022-12-23 08:13:03','635',0.00,0.00,'635','2022-12-22 21:16:47','635','2022-12-22 21:17:37',10,0),('1','187',239978,'DAILY SHIFT','2022-12-23','2022-12-23 09:21:54','2022-12-24 09:21:54','635',0.00,0.00,'635','2022-12-23 18:23:46','635','2022-12-23 18:24:10',10,0),('1','187',239979,'DAILY SHIFT','2022-12-24','2022-12-24 08:21:57','2022-12-25 08:21:57','635',0.00,0.00,'635','2022-12-24 19:57:53','635','2022-12-24 19:58:21',10,0),('1','187',239980,'DAILY SHIFT','2022-12-25','2022-12-25 08:57:58','2022-12-26 08:57:58','635',0.00,0.00,'635','2022-12-25 20:37:09','635','2022-12-25 20:37:35',10,0),('1','187',239981,'OPRETIONAL LOSS','2022-12-25','2022-12-25 20:41:40','2022-12-26 20:41:40','635',0.00,0.00,'635','2022-12-25 20:45:20','635','2022-12-25 20:45:53',10,0),('1','187',239982,'DAILY SHIFT','2022-12-26','2022-12-26 14:17:02','2022-12-27 14:17:02','635',0.00,0.00,'635','2022-12-26 19:46:08','635','2022-12-26 19:46:42',10,0),('1','187',239983,'DAILY SHIFT','2022-12-27','2022-12-27 08:11:09','2022-12-28 08:11:09','635',0.00,0.00,'635','2022-12-27 18:50:00','635','2022-12-27 18:50:18',10,0),('1','187',239984,'DAILY SHIFT','2022-12-28','2022-12-28 08:26:34','2022-12-29 08:26:34','635',0.00,0.00,'635','2022-12-28 20:27:18','635','2022-12-28 20:27:47',10,0),('1','187',239985,'DAILY SHIFT','2022-12-29','2022-12-29 08:26:20','2022-12-30 08:26:20','635',0.00,0.00,'635','2022-12-29 17:37:30','635','2022-12-29 17:37:48',10,0),('1','187',239986,'OPRETIONAL LOSS','2022-12-29','2022-12-29 17:41:02','2022-12-30 17:41:02','635',0.00,0.00,'635','2022-12-29 17:45:33','635','2022-12-29 17:45:52',10,0),('1','187',239987,'DAILY SHIFT','2022-12-30','2022-12-30 12:07:19','2022-12-31 12:07:19','635',0.00,0.00,'635','2022-12-30 21:14:25','635','2022-12-30 21:15:03',10,0),('1','187',239988,'DAILY SHIFT','2022-12-31','2022-12-31 08:37:40','2023-01-01 08:37:40','635',0.00,0.00,'635','2022-12-31 20:40:43','635','2022-12-31 20:41:03',10,0),('1','187',239989,'DAILY SHIFT','2023-01-01','2023-01-01 10:00:25','2023-01-02 10:00:25','635',0.00,0.00,'635','2023-01-01 20:32:09','635','2023-01-01 20:32:27',10,0),('1','187',239990,'DAILY SHIFT','2023-01-02','2023-01-02 08:44:23','2023-01-03 08:44:23','635',0.00,0.00,'635','2023-01-02 20:23:49','635','2023-01-02 20:24:45',10,0),('1','187',239991,'DAILY SHIFT','2023-01-03','2023-01-03 08:13:07','2023-01-04 08:13:07','635',0.00,0.00,'635','2023-01-03 18:58:38','635','2023-01-03 19:00:08',10,0),('1','187',239992,'DAILY SHIFT','2023-01-04','2023-01-04 08:18:21','2023-01-05 08:18:21','635',0.00,0.00,'635','2023-01-04 16:21:49','635','2023-01-04 16:22:08',10,0),('1','187',239993,'DAILY SHIFT','2023-01-04','2023-01-04 16:22:26','2023-01-05 16:22:26','635',0.00,0.00,'635','2023-01-04 17:01:08','635','2023-01-04 17:01:48',10,0),('1','187',239994,'DAILY SHIFT','2023-01-04','2023-01-04 17:02:02','2023-01-05 17:02:02','635',0.00,0.00,'635','2023-01-04 18:57:20','635','2023-01-04 18:57:43',10,0),('1','187',239995,'DAILY SHIFT','2023-01-05','2023-01-05 08:20:23','2023-01-06 08:20:23','635',0.00,0.00,'635','2023-01-05 20:14:51','635','2023-01-05 20:15:11',10,0),('1','187',239996,'DAILY SHIFT','2023-01-06','2023-01-06 08:16:49','2023-01-07 08:16:49','635',0.00,0.00,'635','2023-01-06 18:44:45','635','2023-01-06 18:45:02',10,0),('1','187',239997,'DAILY SHIFT','2023-01-07','2023-01-07 08:14:51','2023-01-08 08:14:51','635',0.00,0.00,'635','2023-01-07 18:22:47','635','2023-01-07 18:23:06',10,0),('1','187',239998,'DAILY SHIFT','2023-01-08','2023-01-08 09:04:48','2023-01-09 09:04:48','635',0.00,0.00,'635','2023-01-08 16:33:05','635','2023-01-08 16:33:27',10,0),('1','187',239999,'DAILY SHIFT','2023-01-09','2023-01-09 08:10:00','2023-01-10 08:10:00','635',0.00,0.00,'635','2023-01-09 22:02:27','635','2023-01-09 22:04:20',10,0),('1','187',240000,'DAILY SHIFT','2023-01-10','2023-01-10 08:12:34','2023-01-11 08:12:34','635',0.00,0.00,'635','2023-01-10 15:08:29','635','2023-01-10 15:08:47',10,0),('1','187',240001,'DAILY SHIFT','2023-01-10','2023-01-10 15:09:08','2023-01-11 15:09:08','635',0.00,0.00,'635','2023-01-10 15:13:37','635','2023-01-10 15:14:46',10,0),('1','187',240002,'DAILY SHIFT','2023-01-10','2023-01-10 16:15:16','2023-01-11 16:15:16','635',0.00,0.00,'635','2023-01-10 18:29:07','635','2023-01-10 18:32:27',10,0),('1','187',240003,'DAILY SHIFT','2023-01-11','2023-01-11 08:30:38','2023-01-12 08:30:38','635',0.00,0.00,'635','2023-01-11 18:28:01','635','2023-01-11 18:28:18',10,0),('1','187',240004,'DAILY SHIFT','2023-01-12','2023-01-12 08:14:28','2023-01-13 08:14:28','635',0.00,0.00,'635','2023-01-12 21:19:07','635','2023-01-12 21:19:50',10,0),('1','187',240005,'DAILY SHIFT','2023-01-13','2023-01-13 08:04:13','2023-01-14 08:04:13','635',0.00,0.00,'635','2023-01-13 20:24:37','635','2023-01-13 20:25:03',10,0),('1','187',240006,'DAILY SHIFT','2023-01-14','2023-01-14 08:15:17','2023-01-15 08:15:17','635',0.00,0.00,'635','2023-01-14 19:45:34','635','2023-01-14 19:45:58',10,0),('1','187',240007,'DAILY SHIFT','2023-01-15','2023-01-15 09:34:14','2023-01-16 09:34:14','635',0.00,0.00,'635','2023-01-15 20:12:55','635','2023-01-15 20:13:26',10,0),('1','187',240008,'DAILY SHIFT','2023-01-16','2023-01-16 08:11:12','2023-01-17 08:11:12','635',0.00,0.00,'635','2023-01-16 22:04:23','635','2023-01-16 22:05:22',10,0),('1','187',240009,'DAILY SHIFT','2023-01-17','2023-01-17 10:48:31','2023-01-18 10:48:31','635',0.00,0.00,'635','2023-01-17 10:50:48','635','2023-01-17 10:51:06',10,0),('1','187',240010,'DAILY SHIFT','2023-01-17','2023-01-17 10:59:44','2023-01-18 10:59:44','635',0.00,0.00,'635','2023-01-17 18:52:23','635','2023-01-17 18:52:39',10,0),('1','187',240011,'DAILY SHIFT','2023-01-18','2023-01-18 08:38:44','2023-01-19 08:38:44','635',0.00,0.00,'635','2023-01-19 08:26:14','635','2023-01-19 08:26:43',10,0),('1','187',240012,'DAILY SHIFT','2023-01-19','2023-01-19 08:27:02','2023-01-20 08:27:02','635',0.00,0.00,'635','2023-01-19 23:51:11','635','2023-01-19 23:52:23',10,0),('1','187',240013,'DAILY SHIFT','2023-01-20','2023-01-20 08:39:41','2023-01-21 08:39:41','635',0.00,0.00,'635','2023-01-20 22:07:19','635','2023-01-20 22:08:05',10,0),('1','187',240014,'DAILY SHIFT','2023-01-21','2023-01-21 08:15:49','2023-01-22 08:15:49','635',0.00,0.00,'635','2023-01-21 23:55:28','635','2023-01-21 23:55:59',10,0),('1','187',240015,'DAILY SHIFT','2023-01-22','2023-01-22 09:49:06','2023-01-23 09:49:06','635',0.00,0.00,'635','2023-01-22 23:11:48','635','2023-01-22 23:12:28',10,0),('1','187',240016,'DAILY SHIFT','2023-01-23','2023-01-23 08:17:59','2023-01-24 08:17:59','635',0.00,0.00,'635','2023-01-23 19:06:44','635','2023-01-23 19:07:07',10,0),('1','187',240017,'DAILY SHIFT','2023-01-24','2023-01-24 08:26:32','2023-01-25 08:26:32','635',0.00,0.00,'635','2023-01-24 18:44:58','635','2023-01-24 18:45:37',10,0),('1','187',240018,'DAILY SHIFT','2023-01-25','2023-01-25 08:08:36','2023-01-26 08:08:36','635',0.00,0.00,'635','2023-01-25 15:25:18','635','2023-01-25 15:25:37',10,0),('1','187',240019,'OPRETIONAL LOSS','2023-01-25','2023-01-25 15:52:37','2023-01-26 15:52:37','635',0.00,0.00,'635','2023-01-25 15:58:35','635','2023-01-25 15:59:27',10,0),('1','187',240020,'DAILY SHIFT','2023-01-26','2023-01-26 08:32:15','2023-01-27 08:32:15','635',0.00,0.00,'635','2023-01-26 21:53:35','635','2023-01-26 21:54:16',10,0),('1','187',240021,'DAILY SHIFT','2023-01-27','2023-01-27 08:06:11','2023-01-28 08:06:11','635',0.00,0.00,'635','2023-01-27 23:59:16','635','2023-01-27 23:59:37',10,0),('1','187',240022,'DAILY SHIFT','2023-01-28','2023-01-28 08:38:40','2023-01-29 08:38:40','635',0.00,0.00,'635','2023-01-28 22:05:46','635','2023-01-28 22:06:11',10,0),('1','187',240023,'DAILY SHIFT','2023-01-29','2023-01-29 09:38:11','2023-01-30 09:38:11','635',0.00,0.00,'635','2023-01-29 18:33:08','635','2023-01-29 18:33:27',10,0),('1','187',240024,'DAILY SHIFT','2023-01-30','2023-01-30 08:19:25','2023-01-31 08:19:25','635',0.00,0.00,'635','2023-01-30 18:38:08','635','2023-01-30 18:38:30',10,0),('1','187',240025,'DAILY SHIFT','2023-01-31','2023-01-31 08:04:42','2023-02-01 08:04:42','635',0.00,0.00,'635','2023-01-31 21:09:02','635','2023-01-31 21:09:29',10,0),('1','187',240026,'DAILY SHIFT','2023-02-01','2023-02-01 08:20:22','2023-02-02 08:20:22','635',0.00,0.00,'635','2023-02-01 19:24:44','635','2023-02-01 19:25:06',10,0),('1','187',240027,'DAILY SHIFT','2023-02-02','2023-02-02 08:08:23','2023-02-03 08:08:23','635',0.00,0.00,'635','2023-02-02 21:27:45','635','2023-02-02 21:28:08',10,0),('1','187',240028,'DAILY SHIFT','2023-02-03','2023-02-03 08:09:05','2023-02-04 08:09:05','635',0.00,0.00,'635','2023-02-04 00:01:04','635','2023-02-04 00:03:36',10,0),('1','187',240029,'DAILY SHIFT','2023-02-04','2023-02-04 08:14:07','2023-02-05 08:14:07','635',0.00,0.00,'635','2023-02-04 20:57:42','635','2023-02-04 20:58:17',10,0),('1','187',240030,'DAILY SHIFT','2023-02-05','2023-02-05 09:27:35','2023-02-06 09:27:35','635',0.00,0.00,'635','2023-02-05 19:38:02','635','2023-02-05 19:38:21',10,0),('1','187',240031,'OPRETIONAL LOSS','2023-02-05','2023-02-05 19:45:45','2023-02-06 19:45:45','635',0.00,0.00,'635','2023-02-05 19:49:05','635','2023-02-05 19:49:23',10,0),('1','187',240032,'DAILY SHIFT','2023-02-06','2023-02-06 08:16:21','2023-02-07 08:16:21','635',0.00,0.00,'635','2023-02-06 21:24:53','635','2023-02-06 21:25:26',10,0),('1','187',240033,'DAILY SHIFT','2023-02-07','2023-02-07 08:28:05','2023-02-08 08:28:05','635',0.00,0.00,'635','2023-02-07 20:37:20','635','2023-02-07 20:38:06',10,0),('1','187',240034,'DAILY SHIFT','2023-02-08','2023-02-08 08:11:14','2023-02-09 08:11:14','635',0.00,0.00,'635','2023-02-08 20:51:14','635','2023-02-08 20:51:33',10,0),('1','187',240035,'DAILY SHIFT','2023-02-09','2023-02-09 08:32:43','2023-02-10 08:32:43','635',0.00,0.00,'635','2023-02-09 22:04:49','635','2023-02-09 22:06:49',10,0),('1','187',240036,'DAILY SHIFT','2023-02-10','2023-02-10 08:24:11','2023-02-11 08:24:11','635',0.00,0.00,'635','2023-02-10 22:13:04','635','2023-02-10 22:14:00',10,0),('1','187',240037,'DAILY SHIFT','2023-02-11','2023-02-11 08:09:29','2023-02-12 08:09:29','635',0.00,0.00,'635','2023-02-11 22:11:34','635','2023-02-11 22:13:49',10,0),('1','187',240038,'DAILY SHIFT','2023-02-12','2023-02-12 09:50:30','2023-02-13 09:50:30','635',0.00,0.00,'635','2023-02-12 20:04:30','635','2023-02-12 20:04:49',10,0),('1','187',240039,'DAILY SHIFT','2023-02-13','2023-02-13 08:06:12','2023-02-14 08:06:12','635',0.00,0.00,'635','2023-02-13 19:46:00','635','2023-02-13 19:46:22',10,0),('1','187',240040,'DAILY SHIFT','2023-02-14','2023-02-14 08:09:00','2023-02-15 08:09:00','635',0.00,0.00,'635','2023-02-14 20:52:16','635','2023-02-14 20:52:46',10,0),('1','187',240041,'DAILY SHIFT','2023-02-15','2023-02-15 08:07:35','2023-02-16 08:07:35','635',0.00,0.00,'635','2023-02-15 21:51:16','635','2023-02-15 21:51:44',10,0),('1','187',240042,'DAILY SHIFT','2023-02-16','2023-02-16 08:06:57','2023-02-17 08:06:57','635',0.00,0.00,'635','2023-02-16 22:37:29','635','2023-02-16 22:37:58',10,0),('1','187',240043,'OPRETIONAL LOSS','2023-02-16','2023-02-16 23:24:38','2023-02-17 23:24:38','635',0.00,0.00,'635','2023-02-16 23:27:16','635','2023-02-16 23:27:37',10,0),('1','187',240044,'DAILY SHIFT','2023-02-19','2023-02-19 09:05:25','2023-02-20 09:05:25','635',0.00,0.00,'635','2023-02-19 23:59:11','635','2023-02-19 23:59:35',10,0),('1','187',240045,'DAILY SHIFT','2023-02-20','2023-02-20 08:12:05','2023-02-21 08:12:05','635',0.00,0.00,'635','2023-02-20 23:00:48','635','2023-02-20 23:01:32',10,0),('1','187',240046,'DAILY SHIFT','2023-02-21','2023-02-21 08:21:56','2023-02-22 08:21:56','635',0.00,0.00,'635','2023-02-22 08:09:53','635','2023-02-22 08:10:10',10,0),('1','187',240047,'DAILY SHIFT','2023-02-22','2023-02-22 08:10:26','2023-02-23 08:10:26','635',0.00,0.00,'635','2023-02-23 08:30:19','635','2023-02-23 08:30:43',10,0),('1','187',240048,'DAILY SHIFT','2023-02-23','2023-02-23 08:31:21','2023-02-24 08:31:21','635',0.00,0.00,'635','2023-02-23 19:38:16','635','2023-02-23 19:38:41',10,0),('1','187',240049,'DAILY SHIFT','2023-02-24','2023-02-24 08:09:51','2023-02-25 08:09:51','635',0.00,0.00,'635','2023-02-24 21:59:00','635','2023-02-24 21:59:45',10,0),('1','187',240050,'DAILY SHIFT','2023-02-26','2023-02-26 09:57:27','2023-02-27 09:57:27','635',0.00,0.00,'635','2023-02-26 20:44:25','635','2023-02-26 20:44:53',10,0),('1','187',240051,'DAILY SHIFT','2023-02-27','2023-02-27 08:27:55','2023-02-28 08:27:55','635',0.00,0.00,'635','2023-02-27 19:50:16','635','2023-02-27 19:50:39',10,0),('1','187',240052,'DAILY SHIFT','2023-02-28','2023-02-28 08:46:30','2023-03-01 08:46:30','635',0.00,0.00,'635','2023-03-01 06:36:25','635','2023-03-01 06:36:50',10,0),('1','187',240053,'DAILY SHIFT','2023-03-01','2023-03-01 08:06:45','2023-03-02 08:06:45','635',0.00,0.00,'635','2023-03-02 08:18:40','635','2023-03-02 08:19:00',10,0),('1','187',240054,'DAILY SHIFT','2023-03-02','2023-03-02 08:19:28','2023-03-03 08:19:28','635',0.00,0.00,'635','2023-03-02 14:36:12','635','2023-03-02 14:36:33',10,0),('1','187',240055,'OPRETIONAL LOSS','2023-03-02','2023-03-02 14:41:41','2023-03-03 14:41:41','635',0.00,0.00,'635','2023-03-02 14:44:29','635','2023-03-02 14:45:01',10,0),('1','187',240056,'DAILY SHIFT','2023-03-03','2023-03-03 08:14:21','2023-03-04 08:14:21','635',0.00,0.00,'635','2023-03-03 23:10:20','635','2023-03-03 23:10:49',10,0),('1','187',240057,'DAILY SHIFT','2023-03-04','2023-03-04 08:17:32','2023-03-05 08:17:32','635',0.00,0.00,'635','2023-03-05 01:55:01','635','2023-03-05 01:56:00',10,0),('1','187',240058,'DAILY SHIFT','2023-03-05','2023-03-05 09:37:11','2023-03-06 09:37:11','635',0.00,0.00,'635','2023-03-05 22:17:09','635','2023-03-05 22:26:02',10,0),('1','187',240059,'DAILY SHIFT','2023-03-06','2023-03-06 08:16:27','2023-03-07 08:16:27','635',0.00,0.00,'635','2023-03-06 22:00:54','635','2023-03-06 22:02:28',10,0),('1','187',240060,'DAILY SHIFT','2023-03-07','2023-03-07 08:27:52','2023-03-08 08:27:52','635',0.00,0.00,'635','2023-03-07 21:51:11','635','2023-03-07 21:51:52',10,0),('1','187',240061,'DAILY SHIFT','2023-03-08','2023-03-08 08:26:21','2023-03-09 08:26:21','635',0.00,0.00,'635','2023-03-08 23:34:13','635','2023-03-08 23:34:41',10,0),('1','187',240062,'DAILY SHIFT','2023-03-09','2023-03-09 08:21:24','2023-03-10 08:21:24','635',0.00,0.00,'635','2023-03-10 00:06:39','635','2023-03-10 00:07:04',10,0),('1','187',240063,'DAILY SHIFT','2023-03-10','2023-03-10 08:15:19','2023-03-11 08:15:19','635',0.00,0.00,'635','2023-03-10 23:18:11','635','2023-03-10 23:18:41',10,0),('1','187',240064,'DAILY SHIFT','2023-03-11','2023-03-11 08:33:39','2023-03-12 08:33:39','635',0.00,0.00,'635','2023-03-11 21:26:34','635','2023-03-11 21:27:20',10,0),('1','187',240065,'DAILY SHIFT','2023-03-12','2023-03-12 09:27:29','2023-03-13 09:27:29','635',0.00,0.00,'635','2023-03-12 18:07:43','635','2023-03-12 18:08:15',10,0),('1','187',240066,'DAILY SHIFT','2023-03-13','2023-03-13 08:44:40','2023-03-14 08:44:40','635',0.00,0.00,'635','2023-03-13 15:50:01','635','2023-03-13 15:50:49',10,0),('1','187',240067,'OPRETIONAL LOSS','2023-03-13','2023-03-13 15:51:56','2023-03-14 15:51:56','635',0.00,0.00,'635','2023-03-13 15:56:20','635','2023-03-13 15:56:41',10,0),('1','187',240068,'DAILY SHIFT','2023-03-14','2023-03-14 08:06:27','2023-03-15 08:06:27','635',0.00,0.00,'635','2023-03-14 21:42:58','635','2023-03-14 21:43:27',10,0),('1','187',240069,'DAILY SHIFT','2023-03-15','2023-03-15 08:05:42','2023-03-16 08:05:42','635',0.00,0.00,'635','2023-03-16 08:07:44','635','2023-03-16 08:08:19',10,0),('1','187',240070,'DAILY SHIFT','2023-03-16','2023-03-16 08:08:40','2023-03-17 08:08:40','635',0.00,0.00,'635','2023-03-16 21:36:56','635','2023-03-16 21:37:45',10,0),('1','187',240071,'DAILY SHIFT','2023-03-17','2023-03-17 08:08:11','2023-03-18 08:08:11','635',0.00,0.00,'635','2023-03-17 22:44:04','635','2023-03-17 22:44:46',10,0),('1','187',240072,'DAILY SHIFT','2023-03-19','2023-03-19 09:11:07','2023-03-20 09:11:07','635',0.00,0.00,'635','2023-03-19 23:59:17','635','2023-03-20 00:16:39',10,0),('1','187',240073,'DAILY SHIFT','2023-03-20','2023-03-20 07:50:33','2023-03-21 07:50:33','635',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',0,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4600113 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','187','939','204280',3971881,'2760','418',0.00,1247.60,0.00,0.00,1247.60,398697.60,0.00,0.00,0.00),('1','187','939','204283',3971900,'2760','418',1247.60,1742.78,0.00,0.00,495.18,168587.68,0.00,0.00,0.00),('1','187','939','204398',3974013,'2760','418',1742.78,1742.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','204402',3974048,'2760','418',1742.78,2626.56,0.00,0.00,883.78,296461.28,0.00,0.00,0.00),('1','187','939','204615',3978029,'2760','418',2626.56,4304.23,0.00,0.00,1677.67,528147.92,0.00,0.00,0.00),('1','187','939','204836',3981588,'2760','418',4304.23,4812.01,0.00,0.00,507.78,161242.08,0.00,0.00,0.00),('1','187','939','204925',3983078,'2760','418',4812.01,4812.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','204931',3983142,'2760','418',4812.01,5524.18,0.00,0.00,712.17,227251.12,0.00,0.00,0.00),('1','187','939','205053',3985301,'2760','418',5524.18,6614.83,0.00,0.00,1090.65,353764.40,0.00,0.00,0.00),('1','187','939','205241',3988825,'2760','418',6614.83,8537.21,0.00,0.00,1922.38,609662.88,0.00,0.00,0.00),('1','187','939','205478',3993130,'2760','418',8537.21,9613.67,0.00,0.00,1076.46,337676.96,0.00,0.00,0.00),('1','187','939','205691',3997253,'2760','418',9613.67,9613.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','205753',3998012,'2760','418',9613.67,14367.81,0.00,0.00,4754.14,1487861.04,0.00,0.00,0.00),('1','187','939','206119',4004783,'2760','418',14367.81,18875.06,0.00,0.00,4507.25,1437186.00,0.00,0.00,0.00),('1','187','939','206181',4005716,'2760','418',18875.06,19268.57,0.00,0.00,393.51,127239.76,0.00,0.00,0.00),('1','187','939','206289',4007689,'2760','418',19268.57,19268.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','206328',4008431,'2760','418',19268.57,22678.00,0.00,0.00,3409.43,1096585.68,0.00,0.00,0.00),('1','187','939','206393',4009280,'2760','418',22678.00,26245.03,0.00,0.00,3567.03,1154835.28,0.00,0.00,0.00),('1','187','939','206754',4015864,'2760','418',26245.03,27694.42,0.00,0.00,1449.39,469034.64,0.00,0.00,0.00),('1','187','939','206803',4016568,'2760','418',27694.42,30540.92,0.00,0.00,2846.50,922416.00,0.00,0.00,0.00),('1','187','939','207025',4020654,'2760','418',30540.92,34181.24,0.00,0.00,3640.32,1182952.32,0.00,0.00,0.00),('1','187','939','207252',4024707,'2760','418',34181.24,38731.37,0.00,0.00,4550.13,1467696.88,0.00,0.00,0.00),('1','187','939','207486',4028895,'2760','418',38731.37,42714.56,0.00,0.00,3983.19,1289583.44,0.00,0.00,0.00),('1','187','939','207709',4032666,'2760','418',42714.56,43511.14,0.00,0.00,796.58,261901.58,0.00,0.00,0.00),('1','187','939','207847',4035077,'2760','418',43511.14,43511.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','208325',4043499,'2760','418',43511.14,56793.06,0.00,0.00,13281.92,4328018.42,0.00,0.00,0.00),('1','187','939','208539',4047375,'2760','418',56793.06,61966.19,0.00,0.00,5173.13,1731790.88,0.00,0.00,0.00),('1','187','939','208763',4051127,'2760','418',61966.19,62727.04,0.00,0.00,760.85,257219.60,0.00,0.00,0.00),('1','187','939','208845',4052395,'2760','418',62727.04,62727.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','208856',4052543,'2760','418',62727.04,65972.10,0.00,0.00,3245.06,1099457.06,0.00,0.00,0.00),('1','187','939','209005',4055211,'2760','418',65972.10,70304.45,0.00,0.00,4332.35,1464812.60,0.00,0.00,0.00),('1','187','939','209221',4059036,'2760','418',70304.45,79467.43,0.00,0.00,9162.98,3091353.48,0.00,0.00,0.00),('1','187','939','209414',4062596,'2760','418',79467.43,79467.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','209505',4064045,'2760','418',79467.43,85997.03,0.00,0.00,6529.60,2309245.40,0.00,0.00,0.00),('1','187','939','209687',4067219,'2760','418',85997.03,88535.55,0.00,0.00,2538.52,901631.68,0.00,0.00,0.00),('1','187','939','209871',4070559,'2760','418',88535.55,92609.65,0.00,0.00,4074.10,1481432.40,0.00,0.00,0.00),('1','187','939','210112',4074858,'2760','418',92609.65,97271.15,0.00,0.00,4661.50,1694189.00,0.00,0.00,0.00),('1','187','939','210319',4078495,'2760','418',97271.15,100193.40,0.00,0.00,2922.25,1062804.00,0.00,0.00,0.00),('1','187','939','210560',4082765,'2760','418',100193.40,103862.10,0.00,0.00,3668.70,1312305.90,0.00,0.00,0.00),('1','187','939','210690',4085380,'2760','418',103862.10,103862.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','210763',4086398,'2760','418',103862.10,113347.40,0.00,0.00,9485.30,3398124.40,0.00,0.00,0.00),('1','187','939','210962',4089762,'2760','418',113347.40,120224.35,0.00,0.00,6876.95,2442844.40,0.00,0.00,0.00),('1','187','939','211197',4093902,'2760','418',120224.35,124580.80,0.00,0.00,4356.45,1565871.50,0.00,0.00,0.00),('1','187','939','211390',4097470,'2760','418',124580.80,128446.70,0.00,0.00,3865.90,1387217.00,0.00,0.00,0.00),('1','187','939','211586',4101031,'2760','418',128446.70,128446.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','211683',4102505,'2760','418',128446.70,131677.10,0.00,0.00,3230.40,1186148.00,0.00,0.00,0.00),('1','187','939','211872',4105756,'2760','418',131677.10,133313.10,0.00,0.00,1636.00,599490.00,0.00,0.00,0.00),('1','187','939','211912',4106548,'2760','418',133313.10,133313.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','212700',4120579,'2760','418',133313.10,135692.95,0.00,0.00,2379.85,895338.00,0.00,0.00,0.00),('1','187','939','212879',4123738,'2760','418',135692.95,139678.70,0.00,0.00,3985.75,1489670.00,0.00,0.00,0.00),('1','187','939','213147',4128324,'2760','418',139678.70,156252.95,0.00,0.00,16574.25,6155134.00,0.00,0.00,0.00),('1','187','939','213402',4132514,'2760','418',156252.95,157856.83,0.00,0.00,1603.88,602314.62,0.00,0.00,0.00),('1','187','939','213745',4138299,'2760','418',157856.83,157856.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','213750',4138360,'2760','418',157856.83,160686.33,0.00,0.00,2829.50,1060196.00,0.00,0.00,0.00),('1','187','939','213900',4140773,'2760','418',160686.33,165036.43,0.00,0.00,4350.10,1632234.90,0.00,0.00,0.00),('1','187','939','214105',4144213,'2760','418',165036.43,169597.18,0.00,0.00,4560.75,1712474.00,0.00,0.00,0.00),('1','187','939','214369',4148759,'2760','418',169597.18,171272.43,0.00,0.00,1675.25,631698.00,0.00,0.00,0.00),('1','187','939','214546',4151731,'2760','418',171272.43,176885.43,0.00,0.00,5613.00,2104631.00,0.00,0.00,0.00),('1','187','939','214793',4156043,'2760','418',176885.43,182217.33,0.00,0.00,5331.90,1997523.60,0.00,0.00,0.00),('1','187','939','214972',4159225,'2760','418',182217.33,182217.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','214996',4159518,'2760','418',182217.33,192457.28,0.00,0.00,10239.95,3834076.80,0.00,0.00,0.00),('1','187','939','215224',4163500,'2760','418',192457.28,198106.03,0.00,0.00,5648.75,2118008.00,0.00,0.00,0.00),('1','187','939','215438',4167075,'2760','418',198106.03,205806.28,0.00,0.00,7700.25,2885054.50,0.00,0.00,0.00),('1','187','939','215684',4171181,'2760','418',205806.28,206722.53,0.00,0.00,916.25,343243.00,0.00,0.00,0.00),('1','187','939','215735',4171989,'2760','418',206722.53,206722.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','215915',4175204,'2760','418',206722.53,210078.25,0.00,0.00,3355.72,1321554.00,0.00,0.00,0.00),('1','187','939','216102',4178479,'2760','418',210078.25,216971.27,0.00,0.00,6893.02,2700715.80,0.00,0.00,0.00),('1','187','939','216321',4182269,'2760','418',216971.27,222301.71,0.00,0.00,5330.44,2088234.00,0.00,0.00,0.00),('1','187','939','216558',4186311,'2760','418',222301.71,229138.50,0.00,0.00,6836.79,2679025.50,0.00,0.00,0.00),('1','187','939','216791',4190532,'2760','418',229138.50,231172.97,0.00,0.00,2034.47,798031.50,0.00,0.00,0.00),('1','187','939','216926',4192826,'2760','418',231172.97,231172.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','217022',4194495,'2760','418',231172.97,231776.51,0.00,0.00,603.54,262189.20,0.00,0.00,0.00),('1','187','939','217291',4199528,'2760','418',231776.51,234381.98,0.00,0.00,2605.47,1108725.60,0.00,0.00,0.00),('1','187','939','217520',4203409,'2760','418',234381.98,237879.44,0.00,0.00,3497.46,1475907.00,0.00,0.00,0.00),('1','187','939','217712',4206706,'2760','418',237879.44,241667.54,0.00,0.00,3788.10,1600368.00,0.00,0.00,0.00),('1','187','939','217992',4211806,'2760','418',241667.54,244362.91,0.00,0.00,2695.37,1144197.60,0.00,0.00,0.00),('1','187','939','218229',4215915,'2760','418',244362.91,248301.34,0.00,0.00,3938.43,1663466.40,0.00,0.00,0.00),('1','187','939','218452',4219862,'2760','418',248301.34,250701.84,0.00,0.00,2400.50,1020420.00,0.00,0.00,0.00),('1','187','939','218687',4224072,'2760','418',250701.84,253535.12,0.00,0.00,2833.28,1205234.40,0.00,0.00,0.00),('1','187','939','218904',4227992,'2760','418',253535.12,255313.29,0.00,0.00,1778.17,751341.60,0.00,0.00,0.00),('1','187','939','218972',4228881,'2760','418',255313.29,255313.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','219411',4236472,'2760','418',255313.29,263793.07,0.00,0.00,8479.78,3516094.40,0.00,0.00,0.00),('1','187','939','219609',4239901,'2760','418',263793.07,266763.55,0.00,0.00,2970.48,1233798.40,0.00,0.00,0.00),('1','187','939','219813',4243744,'2760','418',266763.55,273401.96,0.00,0.00,6638.41,2750080.80,0.00,0.00,0.00),('1','187','939','220043',4247900,'2760','418',273401.96,279780.81,0.00,0.00,6378.85,2636440.00,0.00,0.00,0.00),('1','187','939','220212',4251004,'2760','418',279780.81,279780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','220718',4259637,'2760','418',279780.81,285845.20,0.00,0.00,6064.39,2512019.20,0.00,0.00,0.00),('1','187','939','220914',4263319,'2760','418',285845.20,295055.66,0.00,0.00,9210.46,3812352.80,0.00,0.00,0.00),('1','187','939','221152',4267445,'2760','418',295055.66,304066.80,0.00,0.00,9011.14,3729123.20,0.00,0.00,0.00),('1','187','939','221534',4274527,'2760','418',304066.80,304066.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','222126',4285077,'2760','418',304066.80,312594.13,0.00,0.00,8527.33,3525085.16,0.00,0.00,0.00),('1','187','939','222274',4287557,'2760','418',312594.13,320403.51,0.00,0.00,7809.38,3227486.40,0.00,0.00,0.00),('1','187','939','222515',4291585,'2760','418',320403.51,327180.55,0.00,0.00,6777.04,2793469.20,0.00,0.00,0.00),('1','187','939','223041',4301508,'2760','418',327180.55,329644.55,0.00,0.00,2464.00,1054790.00,0.00,0.00,0.00),('1','187','939','223189',4303824,'2760','418',329644.55,345426.41,0.00,0.00,15781.86,6672503.30,0.00,0.00,0.00),('1','187','939','223432',4308068,'2760','418',345426.41,349081.51,0.00,0.00,3655.10,1631335.20,0.00,0.00,0.00),('1','187','939','223647',4312105,'2760','418',349081.51,351730.91,0.00,0.00,2649.40,1179588.00,0.00,0.00,0.00),('1','187','939','223783',4314643,'2760','418',351730.91,351730.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','224125',4320557,'2760','418',351730.91,352330.91,0.00,0.00,600.00,238200.00,0.00,0.00,0.00),('1','187','939','224127',4320581,'2760','418',352330.91,352330.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','224419',4325976,'2760','418',352330.91,352894.49,0.00,0.00,563.58,273925.80,0.00,0.00,0.00),('1','187','939','224563',4328340,'2760','418',352894.49,354045.52,0.00,0.00,1151.03,559455.30,0.00,0.00,0.00),('1','187','939','224785',4332261,'2760','418',354045.52,362104.60,0.00,0.00,8059.08,3810550.80,0.00,0.00,0.00),('1','187','939','225033',4336678,'2760','418',362104.60,364812.23,0.00,0.00,2707.63,1272036.30,0.00,0.00,0.00),('1','187','939','225267',4341102,'2760','418',364812.23,369337.41,0.00,0.00,4525.18,2115961.80,0.00,0.00,0.00),('1','187','939','225487',4345134,'2760','418',369337.41,371176.33,0.00,0.00,1838.92,870349.20,0.00,0.00,0.00),('1','187','939','225711',4348825,'2760','418',371176.33,376890.84,0.00,0.00,5714.51,2660825.10,0.00,0.00,0.00),('1','187','939','226047',4354706,'2760','418',376890.84,376890.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','226061',4354941,'2760','418',376890.84,379916.72,0.00,0.00,3025.88,1457248.80,0.00,0.00,0.00),('1','187','939','226280',4358971,'2760','418',379916.72,384023.33,0.00,0.00,4106.61,1978811.10,0.00,0.00,0.00),('1','187','939','226482',4362630,'2760','418',384023.33,389416.17,0.00,0.00,5392.84,2594228.40,0.00,0.00,0.00),('1','187','939','226737',4367302,'2760','418',389416.17,393565.27,0.00,0.00,4149.10,1997601.00,0.00,0.00,0.00),('1','187','939','226968',4371390,'2760','418',393565.27,401227.03,0.00,0.00,7661.76,3685107.60,0.00,0.00,0.00),('1','187','939','227166',4375071,'2760','418',401227.03,401227.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','227383',4378667,'2760','418',401227.03,409417.08,0.00,0.00,8190.05,3938065.50,0.00,0.00,0.00),('1','187','939','227619',4382672,'2760','418',409417.08,413903.21,0.00,0.00,4486.13,2160825.30,0.00,0.00,0.00),('1','187','939','227859',4387008,'2760','418',413903.21,419925.78,0.00,0.00,6022.57,2897840.70,0.00,0.00,0.00),('1','187','939','228116',4391977,'2760','418',419925.78,424611.70,0.00,0.00,4685.92,2257939.20,0.00,0.00,0.00),('1','187','939','228403',4397440,'2760','418',424611.70,425673.87,0.00,0.00,1062.17,510746.70,0.00,0.00,0.00),('1','187','939','228420',4397810,'2760','418',425673.87,425673.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','228545',4399978,'2760','418',425673.87,429817.69,0.00,0.00,4143.82,2080062.80,0.00,0.00,0.00),('1','187','939','228781',4404378,'2760','418',429817.69,435679.02,0.00,0.00,5861.33,2930892.20,0.00,0.00,0.00),('1','187','939','228954',4407571,'2760','418',435679.02,441198.20,0.00,0.00,5519.18,2764523.20,0.00,0.00,0.00),('1','187','939','229172',4412012,'2760','418',441198.20,448259.21,0.00,0.00,7061.01,3532093.40,0.00,0.00,0.00),('1','187','939','229450',4416783,'2760','418',448259.21,450241.06,0.00,0.00,1981.85,992879.00,0.00,0.00,0.00),('1','187','939','229632',4420821,'2760','418',450241.06,450241.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','229678',4421375,'2760','418',450241.06,452741.06,0.00,0.00,2500.00,1317211.00,0.00,0.00,0.00),('1','187','939','229897',4425734,'2760','418',452741.06,457104.62,0.00,0.00,4363.56,2287766.21,0.00,0.00,0.00),('1','187','939','230096',4429425,'2760','418',457104.62,461446.92,0.00,0.00,4342.30,2272480.90,0.00,0.00,0.00),('1','187','939','230320',4433531,'2760','418',461446.92,464882.55,0.00,0.00,3435.63,1805831.84,0.00,0.00,0.00),('1','187','939','230534',4437643,'2760','418',464882.55,468817.91,0.00,0.00,3935.36,2061243.48,0.00,0.00,0.00),('1','187','939','230793',4442183,'2760','418',468817.91,471010.89,0.00,0.00,2192.98,1155231.64,0.00,0.00,0.00),('1','187','939','231073',4447041,'2760','418',471010.89,472980.65,0.00,0.00,1969.76,1037090.68,0.00,0.00,0.00),('1','187','939','231396',4452110,'2760','418',472980.65,474859.30,0.00,0.00,1878.65,984259.20,0.00,0.00,0.00),('1','187','939','231548',4454902,'2760','418',474859.30,474859.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','232181',4466247,'2760','418',474859.30,476608.20,0.00,0.00,1748.90,957253.20,0.00,0.00,0.00),('1','187','939','232353',4469200,'2760','418',476608.20,481809.76,0.00,0.00,5201.56,2835677.28,0.00,0.00,0.00),('1','187','939','232590',4473612,'2760','418',481809.76,484351.73,0.00,0.00,2541.97,1393293.36,0.00,0.00,0.00),('1','187','939','232854',4478277,'2760','418',484351.73,486927.74,0.00,0.00,2576.01,1407953.88,0.00,0.00,0.00),('1','187','939','233129',4483179,'2760','418',486927.74,491465.50,0.00,0.00,4537.76,2475591.18,0.00,0.00,0.00),('1','187','939','233403',4488180,'2760','418',491465.50,492849.96,0.00,0.00,1384.46,787933.84,0.00,0.00,0.00),('1','187','939','233620',4492181,'2760','418',492849.96,494539.56,0.00,0.00,1689.60,960958.40,0.00,0.00,0.00),('1','187','939','233891',4497055,'2760','418',494539.56,497857.46,0.00,0.00,3317.90,1881451.60,0.00,0.00,0.00),('1','187','939','234046',4499814,'2760','418',497857.46,499463.66,0.00,0.00,1606.20,908104.80,0.00,0.00,0.00),('1','187','939','234239',4503456,'2760','418',499463.66,499463.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','234588',4509514,'2760','418',499463.66,501713.56,0.00,0.00,2249.90,1278719.60,0.00,0.00,0.00),('1','187','939','234837',4513950,'2760','418',501713.56,504960.06,0.00,0.00,3246.50,1837606.00,0.00,0.00,0.00),('1','187','939','235102',4518651,'2760','418',504960.06,506795.72,0.00,0.00,1835.66,1042698.64,0.00,0.00,0.00),('1','187','939','235316',4522330,'2760','418',506795.72,510298.02,0.00,0.00,3502.30,1982589.20,0.00,0.00,0.00),('1','187','939','235583',4527006,'2760','418',510298.02,513931.94,0.00,0.00,3633.92,2060442.88,0.00,0.00,0.00),('1','187','939','235765',4530293,'2760','418',513931.94,522268.34,0.00,0.00,8336.40,4709345.60,0.00,0.00,0.00),('1','187','939','236085',4535879,'2760','418',522268.34,524073.84,0.00,0.00,1805.50,1020442.00,0.00,0.00,0.00),('1','187','939','236167',4537576,'2760','418',524073.84,524073.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','236255',4538866,'2760','418',524073.84,526624.17,0.00,0.00,2550.33,1472779.32,0.00,0.00,0.00),('1','187','939','236535',4543813,'2760','418',526624.17,530015.05,0.00,0.00,3390.88,1954884.52,0.00,0.00,0.00),('1','187','939','236753',4547443,'2760','418',530015.05,539343.85,0.00,0.00,9328.80,5363530.20,0.00,0.00,0.00),('1','187','939','236984',4551618,'2760','418',539343.85,545035.35,0.00,0.00,5691.50,3273656.00,0.00,0.00,0.00),('1','187','939','237172',4554914,'2760','418',545035.35,547337.55,0.00,0.00,2302.20,1330537.80,0.00,0.00,0.00),('1','187','939','237409',4559267,'2760','418',547337.55,548702.15,0.00,0.00,1364.60,783898.40,0.00,0.00,0.00),('1','187','939','237521',4561343,'2760','418',548702.15,548702.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','237539',4561649,'2760','418',548702.15,553330.35,0.00,0.00,4628.20,2745814.40,0.00,0.00,0.00),('1','187','939','237643',4563306,'2760','418',553330.35,556892.41,0.00,0.00,3562.06,2127865.90,0.00,0.00,0.00),('1','187','939','237886',4567342,'2760','418',556892.41,561025.46,0.00,0.00,4133.05,2475819.70,0.00,0.00,0.00),('1','187','939','238144',4571396,'2760','418',561025.46,564080.86,0.00,0.00,3055.40,1826929.10,0.00,0.00,0.00),('1','187','939','238391',4575791,'2760','418',564080.86,567047.85,0.00,0.00,2966.99,1774933.16,0.00,0.00,0.00),('1','187','939','238640',4579926,'2760','418',567047.85,572928.85,0.00,0.00,5881.00,3507911.50,0.00,0.00,0.00),('1','187','939','238889',4584485,'2760','418',572928.85,572928.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239166',4589388,'2760','418',572928.85,573328.85,0.00,0.00,400.00,158800.00,0.00,0.00,0.00),('1','187','939','239642',4597526,'2760','418',573328.85,573528.85,0.00,0.00,200.00,79400.00,0.00,0.00,0.00),('1','187','939','239643',4597527,'2760','418',573528.85,573596.15,0.00,0.00,67.30,37688.00,0.00,0.00,0.00),('1','187','939','239643',4597528,'2761','418',0.00,500.00,0.00,0.00,500.00,260000.00,0.00,0.00,0.00),('1','187','939','239643',4597529,'2762','418',0.00,200.00,0.00,0.00,200.00,104000.00,0.00,0.00,0.00),('1','187','939','239643',4597530,'2763','418',0.00,500.00,0.00,0.00,500.00,260000.00,0.00,0.00,0.00),('1','187','939','239643',4597531,'2764','418',0.00,400.00,0.00,0.00,400.00,208000.00,0.00,0.00,0.00),('1','187','939','239643',4597532,'2765','418',0.00,120.00,0.00,0.00,120.00,62400.00,0.00,0.00,0.00),('1','187','939','239644',4597533,'2760','418',573596.15,573764.75,0.00,0.00,168.60,94416.00,0.00,0.00,0.00),('1','187','939','239644',4597534,'2761','418',500.00,1322.15,0.00,0.00,822.15,427518.00,0.00,0.00,0.00),('1','187','939','239644',4597535,'2762','418',200.00,900.05,0.00,0.00,700.05,364026.00,0.00,0.00,0.00),('1','187','939','239644',4597536,'2763','418',500.00,950.04,0.00,0.00,450.04,234020.80,0.00,0.00,0.00),('1','187','939','239644',4597537,'2764','418',400.00,400.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239644',4597538,'2765','418',120.00,120.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239645',4597539,'2760','418',573764.75,573898.75,0.00,0.00,134.00,75040.00,0.00,0.00,0.00),('1','187','939','239645',4597540,'2761','418',1322.15,1381.15,0.00,0.00,59.00,30680.00,0.00,0.00,0.00),('1','187','939','239645',4597541,'2762','418',900.05,1050.05,0.00,0.00,150.00,78000.00,0.00,0.00,0.00),('1','187','939','239645',4597542,'2763','418',950.04,1150.04,0.00,0.00,200.00,104000.00,0.00,0.00,0.00),('1','187','939','239645',4597543,'2764','418',400.00,500.00,0.00,0.00,100.00,52000.00,0.00,0.00,0.00),('1','187','939','239645',4597544,'2765','418',120.00,120.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239646',4597545,'2760','418',573898.75,574123.66,0.00,0.00,224.91,125949.60,0.00,0.00,0.00),('1','187','939','239646',4597546,'2761','418',1381.15,1731.15,0.00,0.00,350.00,182000.00,0.00,0.00,0.00),('1','187','939','239646',4597547,'2762','418',1050.05,1729.15,0.00,0.00,679.10,353132.00,0.00,0.00,0.00),('1','187','939','239646',4597548,'2763','418',1150.04,1707.24,0.00,0.00,557.20,289744.00,0.00,0.00,0.00),('1','187','939','239646',4597549,'2764','418',500.00,1030.00,0.00,0.00,530.00,275600.00,0.00,0.00,0.00),('1','187','939','239646',4597550,'2765','418',120.00,120.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239647',4597551,'2760','418',574123.66,574268.44,0.00,0.00,144.78,81076.80,0.00,0.00,0.00),('1','187','939','239647',4597552,'2761','418',1731.15,1981.15,0.00,0.00,250.00,130000.00,0.00,0.00,0.00),('1','187','939','239647',4597553,'2762','418',1729.15,2129.15,0.00,0.00,400.00,208000.00,0.00,0.00,0.00),('1','187','939','239647',4597554,'2763','418',1707.24,2157.24,0.00,0.00,450.00,234000.00,0.00,0.00,0.00),('1','187','939','239647',4597555,'2764','418',1030.00,1615.00,0.00,0.00,585.00,304200.00,0.00,0.00,0.00),('1','187','939','239647',4597556,'2765','418',120.00,120.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239648',4597557,'2760','418',574268.44,574395.65,0.00,0.00,127.21,71237.60,0.00,0.00,0.00),('1','187','939','239648',4597558,'2761','418',1981.15,2171.15,0.00,0.00,190.00,98800.00,0.00,0.00,0.00),('1','187','939','239648',4597559,'2762','418',2129.15,2628.15,0.00,0.00,499.00,259480.00,0.00,0.00,0.00),('1','187','939','239648',4597560,'2763','418',2157.24,2409.83,0.00,0.00,252.59,131346.80,0.00,0.00,0.00),('1','187','939','239648',4597561,'2764','418',1615.00,2458.00,0.00,0.00,843.00,438360.00,0.00,0.00,0.00),('1','187','939','239648',4597562,'2765','418',120.00,120.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239649',4597563,'2760','418',574395.65,574488.60,0.00,0.00,92.95,52052.00,0.00,0.00,0.00),('1','187','939','239649',4597564,'2761','418',2171.15,2749.94,0.00,0.00,578.79,300970.80,0.00,0.00,0.00),('1','187','939','239649',4597565,'2762','418',2628.15,3238.15,0.00,0.00,610.00,317200.00,0.00,0.00,0.00),('1','187','939','239649',4597566,'2763','418',2409.83,2727.40,0.00,0.00,317.57,165136.40,0.00,0.00,0.00),('1','187','939','239649',4597567,'2764','418',2458.00,3224.00,0.00,0.00,766.00,397744.00,0.00,0.00,0.00),('1','187','939','239649',4597568,'2765','418',120.00,120.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239650',4597569,'2760','418',574488.60,574679.12,0.00,0.00,190.52,106691.20,0.00,0.00,0.00),('1','187','939','239650',4597570,'2761','418',2749.94,3273.94,0.00,0.00,524.00,272480.00,0.00,0.00,0.00),('1','187','939','239650',4597571,'2762','418',3238.15,3628.15,0.00,0.00,390.00,202800.00,0.00,0.00,0.00),('1','187','939','239650',4597572,'2763','418',2727.40,3788.01,0.00,0.00,1060.61,547917.20,0.00,0.00,0.00),('1','187','939','239650',4597573,'2764','418',3224.00,3433.35,0.00,0.00,209.35,108862.00,0.00,0.00,0.00),('1','187','939','239650',4597574,'2765','418',120.00,222.56,0.00,0.00,102.56,53331.20,0.00,0.00,0.00),('1','187','939','239651',4597575,'2760','418',574679.12,574838.40,0.00,0.00,159.28,89196.80,0.00,0.00,0.00),('1','187','939','239651',4597576,'2761','418',3273.94,3523.94,0.00,0.00,250.00,130000.00,0.00,0.00,0.00),('1','187','939','239651',4597577,'2762','418',3628.15,4485.27,0.00,0.00,857.12,445702.40,0.00,0.00,0.00),('1','187','939','239651',4597578,'2763','418',3788.01,3959.17,0.00,0.00,171.16,89003.20,0.00,0.00,0.00),('1','187','939','239651',4597579,'2764','418',3433.35,4635.29,0.00,0.00,1201.94,625008.80,0.00,0.00,0.00),('1','187','939','239651',4597580,'2765','418',222.56,762.56,0.00,0.00,540.00,280800.00,0.00,0.00,0.00),('1','187','939','239652',4597581,'2760','418',574838.40,574961.98,0.00,0.00,123.58,69204.80,0.00,0.00,0.00),('1','187','939','239652',4597582,'2761','418',3523.94,3623.94,0.00,0.00,100.00,52000.00,0.00,0.00,0.00),('1','187','939','239652',4597583,'2762','418',4485.27,4710.27,0.00,0.00,225.00,117000.00,0.00,0.00,0.00),('1','187','939','239652',4597584,'2763','418',3959.17,4157.17,0.00,0.00,198.00,102960.00,0.00,0.00,0.00),('1','187','939','239652',4597585,'2764','418',4635.29,4744.68,0.00,0.00,109.39,56882.80,0.00,0.00,0.00),('1','187','939','239652',4597586,'2765','418',762.56,902.56,0.00,0.00,140.00,72800.00,0.00,0.00,0.00),('1','187','939','239653',4597587,'2760','418',574961.98,575156.19,0.00,0.00,194.21,108757.60,0.00,0.00,0.00),('1','187','939','239653',4597588,'2761','418',3623.94,4340.94,0.00,0.00,717.00,372840.00,0.00,0.00,0.00),('1','187','939','239653',4597589,'2762','418',4710.27,5385.27,0.00,0.00,675.00,351000.00,0.00,0.00,0.00),('1','187','939','239653',4597590,'2763','418',4157.17,4627.32,0.00,0.00,470.15,244478.00,0.00,0.00,0.00),('1','187','939','239653',4597591,'2764','418',4744.68,6103.58,0.00,0.00,1358.90,702608.00,0.00,0.00,0.00),('1','187','939','239653',4597592,'2765','418',902.56,902.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239654',4597593,'2760','418',575156.19,575169.74,0.00,0.00,13.55,7588.00,0.00,0.00,0.00),('1','187','939','239654',4597594,'2761','418',4340.94,4440.94,0.00,0.00,100.00,52000.00,0.00,0.00,0.00),('1','187','939','239654',4597595,'2762','418',5385.27,5412.55,0.00,0.00,27.28,14185.60,0.00,0.00,0.00),('1','187','939','239654',4597596,'2763','418',4627.32,4627.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239654',4597597,'2764','418',6103.58,6303.58,0.00,0.00,200.00,104000.00,0.00,0.00,0.00),('1','187','939','239654',4597598,'2765','418',902.56,1152.85,0.00,0.00,250.29,130150.80,0.00,0.00,0.00),('1','187','939','239655',4597599,'2760','418',575169.74,575169.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239655',4597600,'2761','418',4440.94,4440.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239655',4597601,'2762','418',5412.55,5412.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239655',4597602,'2763','418',4627.32,4627.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239655',4597603,'2764','418',6303.58,6303.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239655',4597604,'2765','418',1152.85,1152.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239656',4597605,'2760','418',575169.74,575299.37,0.00,0.00,129.63,72592.80,0.00,0.00,0.00),('1','187','939','239656',4597606,'2761','418',4440.94,5477.94,0.00,0.00,1037.00,545462.00,0.00,0.00,0.00),('1','187','939','239656',4597607,'2762','418',5412.55,6524.55,0.00,0.00,1112.00,584912.00,0.00,0.00,0.00),('1','187','939','239656',4597608,'2763','418',4627.32,5207.14,0.00,0.00,579.82,304985.32,0.00,0.00,0.00),('1','187','939','239656',4597609,'2764','418',6303.58,7732.08,0.00,0.00,1428.50,749345.00,0.00,0.00,0.00),('1','187','939','239656',4597610,'2765','418',1152.85,1437.85,0.00,0.00,285.00,149910.00,0.00,0.00,0.00),('1','187','939','239657',4597611,'2760','418',575299.37,575459.58,0.00,0.00,160.21,89717.60,0.00,0.00,0.00),('1','187','939','239657',4597612,'2761','418',5477.94,6015.94,0.00,0.00,538.00,282988.00,0.00,0.00,0.00),('1','187','939','239657',4597613,'2762','418',6524.55,7426.85,0.00,0.00,902.30,474609.80,0.00,0.00,0.00),('1','187','939','239657',4597614,'2763','418',5207.14,5945.15,0.00,0.00,738.01,388193.26,0.00,0.00,0.00),('1','187','939','239657',4597615,'2764','418',7732.08,8582.08,0.00,0.00,850.00,447100.00,0.00,0.00,0.00),('1','187','939','239657',4597616,'2765','418',1437.85,1437.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239658',4597617,'2760','418',575459.58,575597.50,0.00,0.00,137.92,77235.20,0.00,0.00,0.00),('1','187','939','239658',4597618,'2761','418',6015.94,6415.94,0.00,0.00,400.00,210400.00,0.00,0.00,0.00),('1','187','939','239658',4597619,'2762','418',7426.85,7806.85,0.00,0.00,380.00,199880.00,0.00,0.00,0.00),('1','187','939','239658',4597620,'2763','418',5945.15,6057.65,0.00,0.00,112.50,59175.00,0.00,0.00,0.00),('1','187','939','239658',4597621,'2764','418',8582.08,8897.08,0.00,0.00,315.00,165690.00,0.00,0.00,0.00),('1','187','939','239658',4597622,'2765','418',1437.85,1437.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239659',4597623,'2760','418',575597.50,575801.59,0.00,0.00,204.09,114290.40,0.00,0.00,0.00),('1','187','939','239659',4597624,'2761','418',6415.94,6964.36,0.00,0.00,548.42,288468.92,0.00,0.00,0.00),('1','187','939','239659',4597625,'2762','418',7806.85,8133.85,0.00,0.00,327.00,172002.00,0.00,0.00,0.00),('1','187','939','239659',4597626,'2763','418',6057.65,6407.65,0.00,0.00,350.00,184419.26,0.00,0.00,0.00),('1','187','939','239659',4597627,'2764','418',8897.08,9357.51,0.00,0.00,460.43,242250.10,0.00,0.00,0.00),('1','187','939','239659',4597628,'2765','418',1437.85,1437.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239660',4597629,'2760','418',575801.59,575985.51,0.00,0.00,183.92,102995.20,0.00,0.00,0.00),('1','187','939','239660',4597630,'2761','418',6964.36,7684.36,0.00,0.00,720.00,378720.00,0.00,0.00,0.00),('1','187','939','239660',4597631,'2762','418',8133.85,8555.42,0.00,0.00,421.57,221745.82,0.00,0.00,0.00),('1','187','939','239660',4597632,'2763','418',6407.65,6699.69,0.00,0.00,292.04,153613.04,0.00,0.00,0.00),('1','187','939','239660',4597633,'2764','418',9357.51,10155.48,0.00,0.00,797.97,419732.22,0.00,0.00,0.00),('1','187','939','239660',4597634,'2765','418',1437.85,1563.80,0.00,0.00,125.95,66249.70,0.00,0.00,0.00),('1','187','939','239661',4597635,'2760','418',575985.51,576211.96,0.00,0.00,226.45,126812.00,0.00,0.00,0.00),('1','187','939','239661',4597636,'2761','418',7684.36,8414.36,0.00,0.00,730.00,383980.00,0.00,0.00,0.00),('1','187','939','239661',4597637,'2762','418',8555.42,9122.42,0.00,0.00,567.00,298242.00,0.00,0.00,0.00),('1','187','939','239661',4597638,'2763','418',6699.69,7057.69,0.00,0.00,358.00,188308.00,0.00,0.00,0.00),('1','187','939','239661',4597639,'2764','418',10155.48,11051.48,0.00,0.00,896.00,471296.00,0.00,0.00,0.00),('1','187','939','239661',4597640,'2765','418',1563.80,1763.80,0.00,0.00,200.00,105200.00,0.00,0.00,0.00),('1','187','939','239662',4597641,'2760','418',576211.96,576335.22,0.00,0.00,123.26,69025.60,0.00,0.00,0.00),('1','187','939','239662',4597642,'2761','418',8414.36,8799.36,0.00,0.00,385.00,202510.00,0.00,0.00,0.00),('1','187','939','239662',4597643,'2762','418',9122.42,9772.42,0.00,0.00,650.00,341900.00,0.00,0.00,0.00),('1','187','939','239662',4597644,'2763','418',7057.69,7580.69,0.00,0.00,523.00,275098.00,0.00,0.00,0.00),('1','187','939','239662',4597645,'2764','418',11051.48,11901.48,0.00,0.00,850.00,447100.00,0.00,0.00,0.00),('1','187','939','239662',4597646,'2765','418',1763.80,2241.80,0.00,0.00,478.00,251428.00,0.00,0.00,0.00),('1','187','939','239663',4597647,'2760','418',576335.22,576526.20,0.00,0.00,190.98,106504.08,0.00,0.00,0.00),('1','187','939','239663',4597648,'2761','418',8799.36,9225.55,0.00,0.00,426.19,224175.94,0.00,0.00,0.00),('1','187','939','239663',4597649,'2762','418',9772.42,10057.42,0.00,0.00,285.00,149910.00,0.00,0.00,0.00),('1','187','939','239663',4597650,'2763','418',7580.69,7864.00,0.00,0.00,283.31,149021.06,0.00,0.00,0.00),('1','187','939','239663',4597651,'2764','418',11901.48,12213.98,0.00,0.00,312.50,164375.00,0.00,0.00,0.00),('1','187','939','239663',4597652,'2765','418',2241.80,2610.80,0.00,0.00,369.00,194094.00,0.00,0.00,0.00),('1','187','939','239664',4597653,'2760','418',576526.20,576622.03,0.00,0.00,95.83,53664.80,0.00,0.00,0.00),('1','187','939','239664',4597654,'2761','418',9225.55,9883.55,0.00,0.00,658.00,346108.00,0.00,0.00,0.00),('1','187','939','239664',4597655,'2762','418',10057.42,10759.42,0.00,0.00,702.00,369252.00,0.00,0.00,0.00),('1','187','939','239664',4597656,'2763','418',7864.00,8320.50,0.00,0.00,456.50,240119.00,0.00,0.00,0.00),('1','187','939','239664',4597657,'2764','418',12213.98,13045.98,0.00,0.00,832.00,437632.00,0.00,0.00,0.00),('1','187','939','239664',4597658,'2765','418',2610.80,2960.80,0.00,0.00,350.00,184100.00,0.00,0.00,0.00),('1','187','939','239665',4597659,'2760','418',576622.03,576622.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239665',4597660,'2761','418',9883.55,9883.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239665',4597661,'2762','418',10759.42,10759.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239665',4597662,'2763','418',8320.50,8320.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239665',4597663,'2764','418',13045.98,13045.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239665',4597664,'2765','418',2960.80,2960.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239666',4597665,'2760','418',576622.03,576965.76,0.00,0.00,343.73,192488.80,0.00,0.00,0.00),('1','187','939','239666',4597666,'2761','418',9883.55,10902.05,0.00,0.00,1018.50,535731.00,0.00,0.00,0.00),('1','187','939','239666',4597667,'2762','418',10759.42,11059.42,0.00,0.00,300.00,157800.00,0.00,0.00,0.00),('1','187','939','239666',4597668,'2763','418',8320.50,8686.77,0.00,0.00,366.27,192658.02,0.00,0.00,0.00),('1','187','939','239666',4597669,'2764','418',13045.98,13745.98,0.00,0.00,700.00,368200.00,0.00,0.00,0.00),('1','187','939','239666',4597670,'2765','418',2960.80,3853.13,0.00,0.00,892.33,469365.58,0.00,0.00,0.00),('1','187','939','239667',4597671,'2760','418',576965.76,577105.45,0.00,0.00,139.69,78226.40,0.00,0.00,0.00),('1','187','939','239667',4597672,'2761','418',10902.05,11389.62,0.00,0.00,487.57,256461.82,0.00,0.00,0.00),('1','187','939','239667',4597673,'2762','418',11059.42,11933.56,0.00,0.00,874.14,459797.64,0.00,0.00,0.00),('1','187','939','239667',4597674,'2763','418',8686.77,9009.40,0.00,0.00,322.63,169703.38,0.00,0.00,0.00),('1','187','939','239667',4597675,'2764','418',13745.98,14495.98,0.00,0.00,750.00,394500.00,0.00,0.00,0.00),('1','187','939','239667',4597676,'2765','418',3853.13,4103.13,0.00,0.00,250.00,131500.00,0.00,0.00,0.00),('1','187','939','239668',4597677,'2760','418',577105.45,577219.22,0.00,0.00,113.77,63711.20,0.00,0.00,0.00),('1','187','939','239668',4597678,'2761','418',11389.62,11432.03,0.00,0.00,42.41,22307.66,0.00,0.00,0.00),('1','187','939','239668',4597679,'2762','418',11933.56,12273.56,0.00,0.00,340.00,178840.00,0.00,0.00,0.00),('1','187','939','239668',4597680,'2763','418',9009.40,9414.70,0.00,0.00,405.30,213187.80,0.00,0.00,0.00),('1','187','939','239668',4597681,'2764','418',14495.98,15019.98,0.00,0.00,524.00,275624.00,0.00,0.00,0.00),('1','187','939','239668',4597682,'2765','418',4103.13,4269.13,0.00,0.00,166.00,87316.00,0.00,0.00,0.00),('1','187','939','239669',4597683,'2760','418',577219.22,577415.14,0.00,0.00,195.92,109715.20,0.00,0.00,0.00),('1','187','939','239669',4597684,'2761','418',11432.03,12025.55,0.00,0.00,593.52,312191.52,0.00,0.00,0.00),('1','187','939','239669',4597685,'2762','418',12273.56,12872.56,0.00,0.00,599.00,315074.00,0.00,0.00,0.00),('1','187','939','239669',4597686,'2763','418',9414.70,10599.98,0.00,0.00,1185.28,623457.28,0.00,0.00,0.00),('1','187','939','239669',4597687,'2764','418',15019.98,15609.98,0.00,0.00,590.00,310340.00,0.00,0.00,0.00),('1','187','939','239669',4597688,'2765','418',4269.13,5938.13,0.00,0.00,1669.00,877894.00,0.00,0.00,0.00),('1','187','939','239670',4597689,'2760','418',577415.14,577562.17,0.00,0.00,147.03,82336.80,0.00,0.00,0.00),('1','187','939','239670',4597690,'2761','418',12025.55,13115.55,0.00,0.00,1090.00,573340.00,0.00,0.00,0.00),('1','187','939','239670',4597691,'2762','418',12872.56,14106.63,0.00,0.00,1234.07,649120.82,0.00,0.00,0.00),('1','187','939','239670',4597692,'2763','418',10599.98,11492.16,0.00,0.00,892.18,469286.68,0.00,0.00,0.00),('1','187','939','239670',4597693,'2764','418',15609.98,16984.41,0.00,0.00,1374.43,722950.18,0.00,0.00,0.00),('1','187','939','239670',4597694,'2765','418',5938.13,6254.14,0.00,0.00,316.01,166221.26,0.00,0.00,0.00),('1','187','939','239671',4597695,'2760','418',577562.17,577661.98,0.00,0.00,99.81,62755.00,0.00,0.00,0.00),('1','187','939','239671',4597696,'2761','418',13115.55,13222.55,0.00,0.00,107.00,64200.00,0.00,0.00,0.00),('1','187','939','239671',4597697,'2762','418',14106.63,14555.25,0.00,0.00,448.62,269172.00,0.00,0.00,0.00),('1','187','939','239671',4597698,'2763','418',11492.16,11806.30,0.00,0.00,314.14,188484.00,0.00,0.00,0.00),('1','187','939','239671',4597699,'2764','418',16984.41,17634.41,0.00,0.00,650.00,390000.00,0.00,0.00,0.00),('1','187','939','239671',4597700,'2765','418',6254.14,6254.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239672',4597701,'2760','418',577661.98,577898.27,0.00,0.00,236.29,148862.70,0.00,0.00,0.00),('1','187','939','239672',4597702,'2761','418',13222.55,13372.55,0.00,0.00,150.00,90000.00,0.00,0.00,0.00),('1','187','939','239672',4597703,'2762','418',14555.25,14901.17,0.00,0.00,345.92,207552.00,0.00,0.00,0.00),('1','187','939','239672',4597704,'2763','418',11806.30,11996.30,0.00,0.00,190.00,114000.00,0.00,0.00,0.00),('1','187','939','239672',4597705,'2764','418',17634.41,17874.41,0.00,0.00,240.00,144000.00,0.00,0.00,0.00),('1','187','939','239672',4597706,'2765','418',6254.14,6472.14,0.00,0.00,218.00,130800.00,0.00,0.00,0.00),('1','187','939','239673',4597707,'2760','418',577898.27,578164.51,0.00,0.00,266.24,167731.20,0.00,0.00,0.00),('1','187','939','239673',4597708,'2761','418',13372.55,13485.05,0.00,0.00,112.50,67500.00,0.00,0.00,0.00),('1','187','939','239673',4597709,'2762','418',14901.17,15141.17,0.00,0.00,240.00,144000.00,0.00,0.00,0.00),('1','187','939','239673',4597710,'2763','418',11996.30,12176.30,0.00,0.00,180.00,108000.00,0.00,0.00,0.00),('1','187','939','239673',4597711,'2764','418',17874.41,18224.41,0.00,0.00,350.00,210000.00,0.00,0.00,0.00),('1','187','939','239673',4597712,'2765','418',6472.14,6522.14,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','187','939','239674',4597713,'2760','418',578164.51,578411.30,0.00,0.00,246.79,155477.70,0.00,0.00,0.00),('1','187','939','239674',4597714,'2761','418',13485.05,13525.05,0.00,0.00,40.00,24000.00,0.00,0.00,0.00),('1','187','939','239674',4597715,'2762','418',15141.17,15496.17,0.00,0.00,355.00,213000.00,0.00,0.00,0.00),('1','187','939','239674',4597716,'2763','418',12176.30,12342.47,0.00,0.00,166.17,99702.00,0.00,0.00,0.00),('1','187','939','239674',4597717,'2764','418',18224.41,18824.41,0.00,0.00,600.00,360000.00,0.00,0.00,0.00),('1','187','939','239674',4597718,'2765','418',6522.14,6722.14,0.00,0.00,200.00,120000.00,0.00,0.00,0.00),('1','187','939','239675',4597719,'2760','418',578411.30,578461.31,0.00,0.00,50.01,31506.30,0.00,0.00,0.00),('1','187','939','239675',4597720,'2761','418',13525.05,13654.05,0.00,0.00,129.00,77400.00,0.00,0.00,0.00),('1','187','939','239675',4597721,'2762','418',15496.17,15554.55,0.00,0.00,58.38,35028.00,0.00,0.00,0.00),('1','187','939','239675',4597722,'2763','418',12342.47,12522.47,0.00,0.00,180.00,108000.00,0.00,0.00,0.00),('1','187','939','239675',4597723,'2764','418',18824.41,19005.11,0.00,0.00,180.70,108420.00,0.00,0.00,0.00),('1','187','939','239675',4597724,'2765','418',6722.14,6846.62,0.00,0.00,124.48,74688.00,0.00,0.00,0.00),('1','187','939','239676',4597725,'2760','418',578461.31,578461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239676',4597726,'2761','418',13654.05,13654.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239676',4597727,'2762','418',15554.55,15554.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239676',4597728,'2763','418',12522.47,12522.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239676',4597729,'2764','418',19005.11,19005.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239676',4597730,'2765','418',6846.62,6846.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239677',4597731,'2760','418',578461.31,578461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239677',4597732,'2761','418',13654.05,13654.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239677',4597733,'2762','418',15554.55,15554.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239677',4597734,'2763','418',12522.47,12522.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239677',4597735,'2764','418',19005.11,19005.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239677',4597736,'2765','418',6846.62,6846.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239678',4597737,'2760','418',578461.31,578675.89,0.00,0.00,214.58,135185.40,0.00,0.00,0.00),('1','187','939','239678',4597738,'2761','418',13654.05,14156.05,0.00,0.00,502.00,301200.00,0.00,0.00,0.00),('1','187','939','239678',4597739,'2762','418',15554.55,15954.55,0.00,0.00,400.00,240000.00,0.00,0.00,0.00),('1','187','939','239678',4597740,'2763','418',12522.47,13155.47,0.00,0.00,633.00,379800.00,0.00,0.00,0.00),('1','187','939','239678',4597741,'2764','418',19005.11,19389.11,0.00,0.00,384.00,230400.00,0.00,0.00,0.00),('1','187','939','239678',4597742,'2765','418',6846.62,6946.62,0.00,0.00,100.00,60000.00,0.00,0.00,0.00),('1','187','939','239679',4597743,'2760','418',578675.89,578872.66,0.00,0.00,196.77,123965.10,0.00,0.00,0.00),('1','187','939','239679',4597744,'2761','418',14156.05,14983.05,0.00,0.00,827.00,496200.00,0.00,0.00,0.00),('1','187','939','239679',4597745,'2762','418',15954.55,16404.55,0.00,0.00,450.00,270000.00,0.00,0.00,0.00),('1','187','939','239679',4597746,'2763','418',13155.47,13680.47,0.00,0.00,525.00,315000.00,0.00,0.00,0.00),('1','187','939','239679',4597747,'2764','418',19389.11,19720.11,0.00,0.00,331.00,198600.00,0.00,0.00,0.00),('1','187','939','239679',4597748,'2765','418',6946.62,7361.62,0.00,0.00,415.00,249000.00,0.00,0.00,0.00),('1','187','939','239680',4597749,'2760','418',578872.66,579051.40,0.00,0.00,178.74,112606.20,0.00,0.00,0.00),('1','187','939','239680',4597750,'2761','418',14983.05,15133.05,0.00,0.00,150.00,90000.00,0.00,0.00,0.00),('1','187','939','239680',4597751,'2762','418',16404.55,16638.77,0.00,0.00,234.22,140532.00,0.00,0.00,0.00),('1','187','939','239680',4597752,'2763','418',13680.47,13814.47,0.00,0.00,134.00,80400.00,0.00,0.00,0.00),('1','187','939','239680',4597753,'2764','418',19720.11,20320.11,0.00,0.00,600.00,360000.00,0.00,0.00,0.00),('1','187','939','239680',4597754,'2765','418',7361.62,7361.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239681',4597755,'2760','418',579051.40,579215.37,0.00,0.00,163.97,103301.10,0.00,0.00,0.00),('1','187','939','239681',4597756,'2761','418',15133.05,15442.05,0.00,0.00,309.00,185400.00,0.00,0.00,0.00),('1','187','939','239681',4597757,'2762','418',16638.77,16663.77,0.00,0.00,25.00,15000.00,0.00,0.00,0.00),('1','187','939','239681',4597758,'2763','418',13814.47,14011.47,0.00,0.00,197.00,118200.00,0.00,0.00,0.00),('1','187','939','239681',4597759,'2764','418',20320.11,20676.11,0.00,0.00,356.00,213600.00,0.00,0.00,0.00),('1','187','939','239681',4597760,'2765','418',7361.62,7561.62,0.00,0.00,200.00,120000.00,0.00,0.00,0.00),('1','187','939','239682',4597761,'2760','418',579215.37,579340.39,0.00,0.00,125.02,76012.16,0.00,0.00,0.00),('1','187','939','239682',4597762,'2761','418',15442.05,16520.55,0.00,0.00,1078.50,625530.00,0.00,0.00,0.00),('1','187','939','239682',4597763,'2762','418',16663.77,17340.77,0.00,0.00,677.00,392660.00,0.00,0.00,0.00),('1','187','939','239682',4597764,'2763','418',14011.47,14210.92,0.00,0.00,199.45,115681.00,0.00,0.00,0.00),('1','187','939','239682',4597765,'2764','418',20676.11,20816.72,0.00,0.00,140.61,81553.80,0.00,0.00,0.00),('1','187','939','239682',4597766,'2765','418',7561.62,7780.62,0.00,0.00,219.00,127020.00,0.00,0.00,0.00),('1','187','939','239683',4597767,'2760','418',579340.39,579532.96,0.00,0.00,192.57,117082.56,0.00,0.00,0.00),('1','187','939','239683',4597768,'2761','418',16520.55,17219.55,0.00,0.00,699.00,405420.00,0.00,0.00,0.00),('1','187','939','239683',4597769,'2762','418',17340.77,17893.77,0.00,0.00,553.00,320740.00,0.00,0.00,0.00),('1','187','939','239683',4597770,'2763','418',14210.92,14818.92,0.00,0.00,608.00,352640.00,0.00,0.00,0.00),('1','187','939','239683',4597771,'2764','418',20816.72,21211.72,0.00,0.00,395.00,229100.00,0.00,0.00,0.00),('1','187','939','239683',4597772,'2765','418',7780.62,8080.62,0.00,0.00,300.00,174000.00,0.00,0.00,0.00),('1','187','939','239684',4597773,'2760','418',579532.96,579693.62,0.00,0.00,160.66,97681.28,0.00,0.00,0.00),('1','187','939','239684',4597774,'2761','418',17219.55,17680.55,0.00,0.00,461.00,267380.00,0.00,0.00,0.00),('1','187','939','239684',4597775,'2762','418',17893.77,18163.77,0.00,0.00,270.00,156600.00,0.00,0.00,0.00),('1','187','939','239684',4597776,'2763','418',14818.92,15042.88,0.00,0.00,223.96,129896.80,0.00,0.00,0.00),('1','187','939','239684',4597777,'2764','418',21211.72,21411.72,0.00,0.00,200.00,116000.00,0.00,0.00,0.00),('1','187','939','239684',4597778,'2765','418',8080.62,8180.62,0.00,0.00,100.00,58000.00,0.00,0.00,0.00),('1','187','939','239685',4597779,'2760','418',579693.62,579996.70,0.00,0.00,303.08,184272.64,0.00,0.00,0.00),('1','187','939','239685',4597780,'2761','418',17680.55,18186.66,0.00,0.00,506.11,293543.80,0.00,0.00,0.00),('1','187','939','239685',4597781,'2762','418',18163.77,18664.28,0.00,0.00,500.51,290295.80,0.00,0.00,0.00),('1','187','939','239685',4597782,'2763','418',15042.88,15761.09,0.00,0.00,718.21,416561.80,0.00,0.00,0.00),('1','187','939','239685',4597783,'2764','418',21411.72,22009.72,0.00,0.00,598.00,346840.00,0.00,0.00,0.00),('1','187','939','239685',4597784,'2765','418',8180.62,8495.62,0.00,0.00,315.00,182700.00,0.00,0.00,0.00),('1','187','939','239686',4597785,'2760','418',579996.70,580161.85,0.00,0.00,165.15,100411.20,0.00,0.00,0.00),('1','187','939','239686',4597786,'2761','418',18186.66,20494.66,0.00,0.00,2308.00,1338640.00,0.00,0.00,0.00),('1','187','939','239686',4597787,'2762','418',18664.28,19417.28,0.00,0.00,753.00,436740.00,0.00,0.00,0.00),('1','187','939','239686',4597788,'2763','418',15761.09,16666.09,0.00,0.00,905.00,524900.00,0.00,0.00,0.00),('1','187','939','239686',4597789,'2764','418',22009.72,22359.72,0.00,0.00,350.00,203000.00,0.00,0.00,0.00),('1','187','939','239686',4597790,'2765','418',8495.62,8955.62,0.00,0.00,460.00,266800.00,0.00,0.00,0.00),('1','187','939','239687',4597791,'2760','418',580161.85,580161.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239687',4597792,'2761','418',20494.66,21595.55,0.00,0.00,1100.89,634112.64,0.00,0.00,0.00),('1','187','939','239687',4597793,'2762','418',19417.28,19998.33,0.00,0.00,581.05,334684.80,0.00,0.00,0.00),('1','187','939','239687',4597794,'2763','418',16666.09,17216.09,0.00,0.00,550.00,316800.00,0.00,0.00,0.00),('1','187','939','239687',4597795,'2764','418',22359.72,22826.47,0.00,0.00,466.75,268848.00,0.00,0.00,0.00),('1','187','939','239687',4597796,'2765','418',8955.62,9005.62,0.00,0.00,50.00,28800.00,0.00,0.00,0.00),('1','187','939','239688',4597797,'2760','418',580161.85,580161.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239688',4597798,'2761','418',21595.55,21595.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239688',4597799,'2762','418',19998.33,19998.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239688',4597800,'2763','418',17216.09,17216.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239688',4597801,'2764','418',22826.47,22826.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239688',4597802,'2765','418',9005.62,9005.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239689',4597803,'2760','418',580161.85,580373.19,0.00,0.00,211.34,131018.56,0.00,0.00,0.00),('1','187','939','239689',4597804,'2761','418',21595.55,23481.54,0.00,0.00,1885.99,1095444.20,0.00,0.00,0.00),('1','187','939','239689',4597805,'2762','418',19998.33,20719.33,0.00,0.00,721.00,425390.00,0.00,0.00,0.00),('1','187','939','239689',4597806,'2763','418',17216.09,18241.10,0.00,0.00,1025.01,604255.80,0.00,0.00,0.00),('1','187','939','239689',4597807,'2764','418',22826.47,23378.38,0.00,0.00,551.91,325626.90,0.00,0.00,0.00),('1','187','939','239689',4597808,'2765','418',9005.62,9055.62,0.00,0.00,50.00,29500.00,0.00,0.00,0.00),('1','187','939','239690',4597809,'2760','418',580373.19,580670.52,0.00,0.00,297.33,184344.60,0.00,0.00,0.00),('1','187','939','239690',4597810,'2761','418',23481.54,24346.54,0.00,0.00,865.00,510350.00,0.00,0.00,0.00),('1','187','939','239690',4597811,'2762','418',20719.33,21054.33,0.00,0.00,335.00,197650.00,0.00,0.00,0.00),('1','187','939','239690',4597812,'2763','418',18241.10,18652.10,0.00,0.00,411.00,242490.00,0.00,0.00,0.00),('1','187','939','239690',4597813,'2764','418',23378.38,23678.38,0.00,0.00,300.00,177000.00,0.00,0.00,0.00),('1','187','939','239690',4597814,'2765','418',9055.62,9243.62,0.00,0.00,188.00,110920.00,0.00,0.00,0.00),('1','187','939','239691',4597815,'2760','418',580670.52,580845.13,0.00,0.00,174.61,111610.40,0.00,0.00,0.00),('1','187','939','239691',4597816,'2761','418',24346.54,24757.23,0.00,0.00,410.69,250520.90,0.00,0.00,0.00),('1','187','939','239691',4597817,'2762','418',21054.33,21204.33,0.00,0.00,150.00,91500.00,0.00,0.00,0.00),('1','187','939','239691',4597818,'2763','418',18652.10,18777.10,0.00,0.00,125.00,76250.00,0.00,0.00,0.00),('1','187','939','239691',4597819,'2764','418',23678.38,23788.38,0.00,0.00,110.00,67100.00,0.00,0.00,0.00),('1','187','939','239691',4597820,'2765','418',9243.62,9584.90,0.00,0.00,341.28,208180.80,0.00,0.00,0.00),('1','187','939','239692',4597821,'2760','418',580845.13,581166.76,0.00,0.00,321.63,199410.60,0.00,0.00,0.00),('1','187','939','239692',4597822,'2761','418',24757.23,25252.47,0.00,0.00,495.24,302096.40,0.00,0.00,0.00),('1','187','939','239692',4597823,'2762','418',21204.33,21827.33,0.00,0.00,623.00,380030.00,0.00,0.00,0.00),('1','187','939','239692',4597824,'2763','418',18777.10,19666.74,0.00,0.00,889.64,542680.40,0.00,0.00,0.00),('1','187','939','239692',4597825,'2764','418',23788.38,24292.08,0.00,0.00,503.70,307257.00,0.00,0.00,0.00),('1','187','939','239692',4597826,'2765','418',9584.90,9984.90,0.00,0.00,400.00,244000.00,0.00,0.00,0.00),('1','187','939','239693',4597827,'2760','418',581166.76,581572.81,0.00,0.00,406.05,259872.00,0.00,0.00,0.00),('1','187','939','239693',4597828,'2761','418',25252.47,26902.47,0.00,0.00,1650.00,1006500.00,0.00,0.00,0.00),('1','187','939','239693',4597829,'2762','418',21827.33,22623.33,0.00,0.00,796.00,485560.00,0.00,0.00,0.00),('1','187','939','239693',4597830,'2763','418',19666.74,20043.74,0.00,0.00,377.00,229970.00,0.00,0.00,0.00),('1','187','939','239693',4597831,'2764','418',24292.08,24897.94,0.00,0.00,605.86,369574.60,0.00,0.00,0.00),('1','187','939','239693',4597832,'2765','418',9984.90,10084.90,0.00,0.00,100.00,61000.00,0.00,0.00,0.00),('1','187','939','239694',4597833,'2760','418',581572.81,581817.23,0.00,0.00,244.42,156428.80,0.00,0.00,0.00),('1','187','939','239694',4597834,'2761','418',26902.47,27489.39,0.00,0.00,586.92,358021.20,0.00,0.00,0.00),('1','187','939','239694',4597835,'2762','418',22623.33,23452.63,0.00,0.00,829.30,505873.00,0.00,0.00,0.00),('1','187','939','239694',4597836,'2763','418',20043.74,20501.74,0.00,0.00,458.00,279380.00,0.00,0.00,0.00),('1','187','939','239694',4597837,'2764','418',24897.94,25337.94,0.00,0.00,440.00,268400.00,0.00,0.00,0.00),('1','187','939','239694',4597838,'2765','418',10084.90,10294.90,0.00,0.00,210.00,128100.00,0.00,0.00,0.00),('1','187','939','239695',4597839,'2760','418',581817.23,582187.66,0.00,0.00,370.43,237075.20,0.00,0.00,0.00),('1','187','939','239695',4597840,'2761','418',27489.39,28339.45,0.00,0.00,850.06,518536.60,0.00,0.00,0.00),('1','187','939','239695',4597841,'2762','418',23452.63,23949.99,0.00,0.00,497.36,303389.60,0.00,0.00,0.00),('1','187','939','239695',4597842,'2763','418',20501.74,20972.74,0.00,0.00,471.00,287310.00,0.00,0.00,0.00),('1','187','939','239695',4597843,'2764','418',25337.94,25606.94,0.00,0.00,269.00,164090.00,0.00,0.00,0.00),('1','187','939','239695',4597844,'2765','418',10294.90,10744.90,0.00,0.00,450.00,274500.00,0.00,0.00,0.00),('1','187','939','239696',4597845,'2760','418',582187.66,582491.81,0.00,0.00,304.15,194656.00,0.00,0.00,0.00),('1','187','939','239696',4597846,'2761','418',28339.45,29014.47,0.00,0.00,675.02,411973.10,0.00,0.00,0.00),('1','187','939','239696',4597847,'2762','418',23949.99,24819.61,0.00,0.00,869.62,530468.20,0.00,0.00,0.00),('1','187','939','239696',4597848,'2763','418',20972.74,21885.97,0.00,0.00,913.23,557070.30,0.00,0.00,0.00),('1','187','939','239696',4597849,'2764','418',25606.94,25951.94,0.00,0.00,345.00,210450.00,0.00,0.00,0.00),('1','187','939','239696',4597850,'2765','418',10744.90,10994.90,0.00,0.00,250.00,152500.00,0.00,0.00,0.00),('1','187','939','239697',4597851,'2760','418',582491.81,582491.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239697',4597852,'2761','418',29014.47,29014.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239697',4597853,'2762','418',24819.61,24819.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239697',4597854,'2763','418',21885.97,21885.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239697',4597855,'2764','418',25951.94,25951.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239697',4597856,'2765','418',10994.90,10994.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239698',4597857,'2760','418',582491.81,582955.99,0.00,0.00,464.18,297075.20,0.00,0.00,0.00),('1','187','939','239698',4597858,'2761','418',29014.47,31618.57,0.00,0.00,2604.10,1536419.00,0.00,0.00,0.00),('1','187','939','239698',4597859,'2762','418',24819.61,26289.12,0.00,0.00,1469.51,867010.90,0.00,0.00,0.00),('1','187','939','239698',4597860,'2763','418',21885.97,23627.78,0.00,0.00,1741.81,1027667.90,0.00,0.00,0.00),('1','187','939','239698',4597861,'2764','418',25951.94,27544.37,0.00,0.00,1592.43,939533.70,0.00,0.00,0.00),('1','187','939','239698',4597862,'2765','418',10994.90,11247.90,0.00,0.00,253.00,149270.00,0.00,0.00,0.00),('1','187','939','239699',4597863,'2760','418',582955.99,583266.75,0.00,0.00,310.76,198886.40,0.00,0.00,0.00),('1','187','939','239699',4597864,'2761','418',31618.57,33942.81,0.00,0.00,2324.24,1371301.60,0.00,0.00,0.00),('1','187','939','239699',4597865,'2762','418',26289.12,28214.83,0.00,0.00,1925.71,1136168.90,0.00,0.00,0.00),('1','187','939','239699',4597866,'2763','418',23627.78,25348.77,0.00,0.00,1720.99,1015384.10,0.00,0.00,0.00),('1','187','939','239699',4597867,'2764','418',27544.37,29266.05,0.00,0.00,1721.68,1015791.20,0.00,0.00,0.00),('1','187','939','239699',4597868,'2765','418',11247.90,11307.90,0.00,0.00,60.00,35400.00,0.00,0.00,0.00),('1','187','939','239700',4597869,'2760','418',583266.75,583530.41,0.00,0.00,263.66,168102.40,0.00,0.00,0.00),('1','187','939','239700',4597870,'2761','418',33942.81,35906.97,0.00,0.00,1964.16,1158854.40,0.00,0.00,0.00),('1','187','939','239700',4597871,'2762','418',28214.83,29165.02,0.00,0.00,950.19,560612.10,0.00,0.00,0.00),('1','187','939','239700',4597872,'2763','418',25348.77,26609.67,0.00,0.00,1260.90,743931.00,0.00,0.00,0.00),('1','187','939','239700',4597873,'2764','418',29266.05,29766.05,0.00,0.00,500.00,295000.00,0.00,0.00,0.00),('1','187','939','239700',4597874,'2765','418',11307.90,11715.90,0.00,0.00,408.00,240720.00,0.00,0.00,0.00),('1','187','939','239701',4597875,'2760','418',583530.41,583653.98,0.00,0.00,123.57,79084.80,0.00,0.00,0.00),('1','187','939','239701',4597876,'2761','418',35906.97,37238.12,0.00,0.00,1331.15,785378.50,0.00,0.00,0.00),('1','187','939','239701',4597877,'2762','418',29165.02,29522.91,0.00,0.00,357.89,211155.10,0.00,0.00,0.00),('1','187','939','239701',4597878,'2763','418',26609.67,27512.13,0.00,0.00,902.46,532451.40,0.00,0.00,0.00),('1','187','939','239701',4597879,'2764','418',29766.05,29975.92,0.00,0.00,209.87,123823.30,0.00,0.00,0.00),('1','187','939','239701',4597880,'2765','418',11715.90,11767.26,0.00,0.00,51.36,30302.40,0.00,0.00,0.00),('1','187','939','239702',4597881,'2760','418',583653.98,583653.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239702',4597882,'2761','418',37238.12,37238.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239702',4597883,'2762','418',29522.91,29522.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239702',4597884,'2763','418',27512.13,27512.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239702',4597885,'2764','418',29975.92,29975.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239702',4597886,'2765','418',11767.26,11767.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239703',4597887,'2760','418',583653.98,583876.39,0.00,0.00,222.41,142342.40,0.00,0.00,0.00),('1','187','939','239703',4597888,'2761','418',37238.12,37708.11,0.00,0.00,469.99,277544.10,0.00,0.00,0.00),('1','187','939','239703',4597889,'2762','418',29522.91,29931.27,0.00,0.00,408.36,240932.40,0.00,0.00,0.00),('1','187','939','239703',4597890,'2763','418',27512.13,28113.13,0.00,0.00,601.00,354590.00,0.00,0.00,0.00),('1','187','939','239703',4597891,'2764','418',29975.92,30325.92,0.00,0.00,350.00,206500.00,0.00,0.00,0.00),('1','187','939','239703',4597892,'2765','418',11767.26,12017.26,0.00,0.00,250.00,147500.00,0.00,0.00,0.00),('1','187','939','239704',4597893,'2760','418',583876.39,584108.94,0.00,0.00,232.55,148832.00,0.00,0.00,0.00),('1','187','939','239704',4597894,'2761','418',37708.11,38522.94,0.00,0.00,814.83,480749.70,0.00,0.00,0.00),('1','187','939','239704',4597895,'2762','418',29931.27,30488.53,0.00,0.00,557.26,328783.40,0.00,0.00,0.00),('1','187','939','239704',4597896,'2763','418',28113.13,28371.13,0.00,0.00,258.00,152220.00,0.00,0.00,0.00),('1','187','939','239704',4597897,'2764','418',30325.92,30430.07,0.00,0.00,104.15,61448.50,0.00,0.00,0.00),('1','187','939','239704',4597898,'2765','418',12017.26,12517.26,0.00,0.00,500.00,295000.00,0.00,0.00,0.00),('1','187','939','239705',4597899,'2760','418',584108.94,584285.99,0.00,0.00,177.05,113312.00,0.00,0.00,0.00),('1','187','939','239705',4597900,'2761','418',38522.94,39348.62,0.00,0.00,825.68,487151.20,0.00,0.00,0.00),('1','187','939','239705',4597901,'2762','418',30488.53,31495.91,0.00,0.00,1007.38,594354.20,0.00,0.00,0.00),('1','187','939','239705',4597902,'2763','418',28371.13,28824.10,0.00,0.00,452.97,267252.30,0.00,0.00,0.00),('1','187','939','239705',4597903,'2764','418',30430.07,30731.60,0.00,0.00,301.53,177902.70,0.00,0.00,0.00),('1','187','939','239705',4597904,'2765','418',12517.26,12952.26,0.00,0.00,435.00,256650.00,0.00,0.00,0.00),('1','187','939','239706',4597905,'2760','418',584285.99,584424.93,0.00,0.00,138.94,88921.60,0.00,0.00,0.00),('1','187','939','239706',4597906,'2761','418',39348.62,39827.97,0.00,0.00,479.35,282816.50,0.00,0.00,0.00),('1','187','939','239706',4597907,'2762','418',31495.91,31985.91,0.00,0.00,490.00,289100.00,0.00,0.00,0.00),('1','187','939','239706',4597908,'2763','418',28824.10,29023.81,0.00,0.00,199.71,117828.90,0.00,0.00,0.00),('1','187','939','239706',4597909,'2764','418',30731.60,31108.24,0.00,0.00,376.64,222217.60,0.00,0.00,0.00),('1','187','939','239706',4597910,'2765','418',12952.26,13251.61,0.00,0.00,299.35,176616.50,0.00,0.00,0.00),('1','187','939','239707',4597911,'2760','418',584424.93,584617.17,0.00,0.00,192.24,123033.60,0.00,0.00,0.00),('1','187','939','239707',4597912,'2761','418',39827.97,40724.23,0.00,0.00,896.26,528793.40,0.00,0.00,0.00),('1','187','939','239707',4597913,'2762','418',31985.91,32515.91,0.00,0.00,530.00,312700.00,0.00,0.00,0.00),('1','187','939','239707',4597914,'2763','418',29023.81,29485.94,0.00,0.00,462.13,272656.70,0.00,0.00,0.00),('1','187','939','239707',4597915,'2764','418',31108.24,31423.24,0.00,0.00,315.00,185850.00,0.00,0.00,0.00),('1','187','939','239707',4597916,'2765','418',13251.61,13755.61,0.00,0.00,504.00,297360.00,0.00,0.00,0.00),('1','187','939','239708',4597917,'2760','418',584617.17,584718.72,0.00,0.00,101.55,64992.00,0.00,0.00,0.00),('1','187','939','239708',4597918,'2761','418',40724.23,41460.02,0.00,0.00,735.79,434116.10,0.00,0.00,0.00),('1','187','939','239708',4597919,'2762','418',32515.91,33173.91,0.00,0.00,658.00,388220.00,0.00,0.01,0.00),('1','187','939','239708',4597920,'2763','418',29485.94,29895.98,0.00,0.00,410.04,241923.60,0.00,0.00,0.00),('1','187','939','239708',4597921,'2764','418',31423.24,31653.24,0.00,0.00,230.00,135700.00,0.00,0.00,0.00),('1','187','939','239708',4597922,'2765','418',13755.61,14020.61,0.00,0.00,265.00,156350.00,0.00,0.00,0.00),('1','187','939','239709',4597923,'2760','418',584718.72,584870.39,0.00,0.00,151.67,97068.80,0.00,0.00,0.00),('1','187','939','239709',4597924,'2761','418',41460.02,41823.02,0.00,0.00,363.00,214170.00,0.00,0.00,0.00),('1','187','939','239709',4597925,'2762','418',33173.91,33543.92,0.00,0.00,370.01,218305.90,0.00,0.00,0.00),('1','187','939','239709',4597926,'2763','418',29895.98,29975.98,0.00,0.00,80.00,47200.00,0.00,0.00,0.00),('1','187','939','239709',4597927,'2764','418',31653.24,31803.24,0.00,0.00,150.00,88500.00,0.00,0.00,0.00),('1','187','939','239709',4597928,'2765','418',14020.61,14170.61,0.00,0.00,150.00,88500.00,0.00,0.00,0.00),('1','187','939','239710',4597929,'2760','418',584870.39,585033.56,0.00,0.00,163.17,104428.80,0.00,0.00,0.00),('1','187','939','239710',4597930,'2761','418',41823.02,42151.28,0.00,0.00,328.26,193673.40,0.00,0.00,0.00),('1','187','939','239710',4597931,'2762','418',33543.92,34279.92,0.00,0.00,736.00,434240.00,0.00,0.00,0.00),('1','187','939','239710',4597932,'2763','418',29975.98,30488.96,0.00,0.00,512.98,302658.20,0.00,0.00,0.00),('1','187','939','239710',4597933,'2764','418',31803.24,32053.24,0.00,0.00,250.00,147500.00,0.00,0.00,0.00),('1','187','939','239710',4597934,'2765','418',14170.61,14696.61,0.00,0.00,526.00,310340.00,0.00,0.00,0.00),('1','187','939','239711',4597935,'2760','418',585033.56,585227.76,0.00,0.00,194.20,124288.00,0.00,0.00,0.00),('1','187','939','239711',4597936,'2761','418',42151.28,42836.15,0.00,0.00,684.87,404073.30,0.00,0.00,0.00),('1','187','939','239711',4597937,'2762','418',34279.92,34556.92,0.00,0.00,277.00,163430.00,0.00,0.00,0.00),('1','187','939','239711',4597938,'2763','418',30488.96,30788.96,0.00,0.00,300.00,177000.00,0.00,0.00,0.00),('1','187','939','239711',4597939,'2764','418',32053.24,32253.24,0.00,0.00,200.00,118000.00,0.00,0.00,0.00),('1','187','939','239711',4597940,'2765','418',14696.61,15002.61,0.00,0.00,306.00,180540.00,0.00,0.00,0.00),('1','187','939','239712',4597941,'2760','418',585227.76,585499.22,0.00,0.00,271.46,173734.40,0.00,0.00,0.00),('1','187','939','239712',4597942,'2761','418',42836.15,43361.24,0.00,0.00,525.09,309803.10,0.00,0.00,0.00),('1','187','939','239712',4597943,'2762','418',34556.92,34956.92,0.00,0.00,400.00,236000.00,0.00,0.00,0.00),('1','187','939','239712',4597944,'2763','418',30788.96,31188.96,0.00,0.00,400.00,236000.00,0.00,0.00,0.00),('1','187','939','239712',4597945,'2764','418',32253.24,32763.24,0.00,0.00,510.00,300900.00,0.00,0.00,0.00),('1','187','939','239712',4597946,'2765','418',15002.61,15602.61,0.00,0.00,600.00,354000.00,0.00,0.00,0.00),('1','187','939','239713',4597947,'2760','418',585499.22,585586.72,0.00,0.00,87.50,56000.00,0.00,0.00,0.00),('1','187','939','239713',4597948,'2761','418',43361.24,43665.24,0.00,0.00,304.00,179360.00,0.00,0.00,0.00),('1','187','939','239713',4597949,'2762','418',34956.92,35080.94,0.00,0.00,124.02,73171.80,0.00,0.00,0.00),('1','187','939','239713',4597950,'2763','418',31188.96,31248.67,0.00,0.00,59.71,35228.90,0.00,0.00,0.00),('1','187','939','239713',4597951,'2764','418',32763.24,32863.24,0.00,0.00,100.00,59000.00,0.00,0.00,0.00),('1','187','939','239713',4597952,'2765','418',15602.61,15629.19,0.00,0.00,26.58,15682.20,0.00,0.00,0.00),('1','187','939','239714',4597953,'2760','418',585586.72,585586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239714',4597954,'2761','418',43665.24,43665.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239714',4597955,'2762','418',35080.94,35080.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239714',4597956,'2763','418',31248.67,31248.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239714',4597957,'2764','418',32863.24,32863.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239714',4597958,'2765','418',15629.19,15629.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239715',4597959,'2760','418',585586.72,585586.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239715',4597960,'2761','418',43665.24,43665.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239715',4597961,'2762','418',35080.94,35080.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239715',4597962,'2763','418',31248.67,31248.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239715',4597963,'2764','418',32863.24,32863.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239715',4597964,'2765','418',15629.19,15629.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239716',4597965,'2760','418',585586.72,586096.66,0.00,0.00,509.94,326361.60,0.00,0.00,0.00),('1','187','939','239716',4597966,'2761','418',43665.24,45207.24,0.00,0.00,1542.00,894360.00,0.00,0.00,0.00),('1','187','939','239716',4597967,'2762','418',35080.94,36113.38,0.00,0.00,1032.44,598815.20,0.00,0.00,0.00),('1','187','939','239716',4597968,'2763','418',31248.67,32174.96,0.00,0.00,926.29,537248.20,0.00,0.00,0.00),('1','187','939','239716',4597969,'2764','418',32863.24,33329.02,0.00,0.00,465.78,270152.40,0.00,0.00,0.00),('1','187','939','239716',4597970,'2765','418',15629.19,16094.29,0.00,0.00,465.10,269758.00,0.00,0.00,0.00),('1','187','939','239717',4597971,'2760','418',586096.66,586320.20,0.00,0.00,223.54,143065.60,0.00,0.00,0.00),('1','187','939','239717',4597972,'2761','418',45207.24,45747.24,0.00,0.00,540.00,313200.00,0.00,0.00,0.00),('1','187','939','239717',4597973,'2762','418',36113.38,36401.38,0.00,0.00,288.00,167040.00,0.00,0.00,0.00),('1','187','939','239717',4597974,'2763','418',32174.96,32572.96,0.00,0.00,398.00,230840.00,0.00,0.00,0.00),('1','187','939','239717',4597975,'2764','418',33329.02,33769.42,0.00,0.00,440.40,255432.00,0.00,0.00,0.00),('1','187','939','239717',4597976,'2765','418',16094.29,16194.29,0.00,0.00,100.00,58000.00,0.00,0.00,0.00),('1','187','939','239718',4597977,'2760','418',586320.20,586667.42,0.00,0.00,347.22,222220.80,0.00,0.00,0.00),('1','187','939','239718',4597978,'2761','418',45747.24,46403.24,0.00,0.00,656.00,380480.00,0.00,0.00,0.00),('1','187','939','239718',4597979,'2762','418',36401.38,36986.38,0.00,0.00,585.00,339300.00,0.00,0.00,0.00),('1','187','939','239718',4597980,'2763','418',32572.96,33122.96,0.00,0.00,550.00,319000.00,0.00,0.00,0.00),('1','187','939','239718',4597981,'2764','418',33769.42,34269.32,0.00,0.00,499.90,289942.00,0.00,0.00,0.00),('1','187','939','239718',4597982,'2765','418',16194.29,16552.29,0.00,0.00,358.00,207640.00,0.00,0.00,0.00),('1','187','939','239719',4597983,'2760','418',586667.42,586890.30,0.00,0.00,222.88,142643.20,0.00,0.00,0.00),('1','187','939','239719',4597984,'2761','418',46403.24,47584.60,0.00,0.00,1181.36,685188.80,0.00,0.00,0.00),('1','187','939','239719',4597985,'2762','418',36986.38,37624.38,0.00,0.00,638.00,370040.00,0.00,0.00,0.00),('1','187','939','239719',4597986,'2763','418',33122.96,33743.63,0.00,0.00,620.67,359988.60,0.00,0.00,0.00),('1','187','939','239719',4597987,'2764','418',34269.32,34820.17,0.00,0.00,550.85,319493.00,0.00,0.00,0.00),('1','187','939','239719',4597988,'2765','418',16552.29,16902.29,0.00,0.00,350.00,203000.00,0.00,0.00,0.00),('1','187','939','239720',4597989,'2760','418',586890.30,587033.31,0.00,0.00,143.01,91526.40,0.00,0.00,0.00),('1','187','939','239720',4597990,'2761','418',47584.60,48071.63,0.00,0.00,487.03,282477.40,0.00,0.00,0.00),('1','187','939','239720',4597991,'2762','418',37624.38,37824.38,0.00,0.00,200.00,116000.00,0.00,0.00,0.00),('1','187','939','239720',4597992,'2763','418',33743.63,33975.63,0.00,0.00,232.00,134560.00,0.00,0.00,0.00),('1','187','939','239720',4597993,'2764','418',34820.17,35160.17,0.00,0.00,340.00,197200.00,0.00,0.00,0.00),('1','187','939','239720',4597994,'2765','418',16902.29,17128.67,0.00,0.00,226.38,131300.40,0.00,0.00,0.00),('1','187','939','239721',4597995,'2760','418',587033.31,587328.82,0.00,0.00,295.51,189126.40,0.00,0.00,0.00),('1','187','939','239721',4597996,'2761','418',48071.63,49106.65,0.00,0.00,1035.02,600311.60,0.00,0.00,0.00),('1','187','939','239721',4597997,'2762','418',37824.38,38727.38,0.00,0.00,903.00,523740.00,0.00,0.00,0.00),('1','187','939','239721',4597998,'2763','418',33975.63,34780.61,0.00,0.00,804.98,466888.40,0.00,0.00,0.00),('1','187','939','239721',4597999,'2764','418',35160.17,35860.17,0.00,0.00,700.00,406000.00,0.00,0.00,0.00),('1','187','939','239721',4598000,'2765','418',17128.67,17498.65,0.00,0.00,369.98,214588.40,0.00,0.00,0.00),('1','187','939','239722',4598001,'2760','418',587328.82,587477.74,0.00,0.00,148.92,95308.80,0.00,0.00,0.00),('1','187','939','239722',4598002,'2761','418',49106.65,49605.24,0.00,0.00,498.59,289182.20,0.00,0.00,0.00),('1','187','939','239722',4598003,'2762','418',38727.38,39233.11,0.00,0.00,505.73,293323.40,0.00,0.00,0.00),('1','187','939','239722',4598004,'2763','418',34780.61,35130.44,0.00,0.00,349.83,202901.40,0.00,0.00,0.00),('1','187','939','239722',4598005,'2764','418',35860.17,36448.26,0.00,0.00,588.09,341092.20,0.00,0.00,0.00),('1','187','939','239722',4598006,'2765','418',17498.65,17598.65,0.00,0.00,100.00,58000.00,0.00,0.00,0.00),('1','187','939','239723',4598007,'2760','418',587477.74,587747.04,0.00,0.00,269.30,172352.00,0.00,0.00,0.00),('1','187','939','239723',4598008,'2761','418',49605.24,50855.94,0.00,0.00,1250.70,725406.00,0.00,0.00,0.00),('1','187','939','239723',4598009,'2762','418',39233.11,39733.11,0.00,0.00,500.00,290000.00,0.00,0.00,0.00),('1','187','939','239723',4598010,'2763','418',35130.44,35566.16,0.00,0.00,435.72,252717.60,0.00,0.00,0.00),('1','187','939','239723',4598011,'2764','418',36448.26,36813.26,0.00,0.00,365.00,211700.00,0.00,0.00,0.00),('1','187','939','239723',4598012,'2765','418',17598.65,17906.65,0.00,0.00,308.00,178640.00,0.00,0.00,0.00),('1','187','939','239724',4598013,'2760','418',587747.04,587747.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239724',4598014,'2761','418',50855.94,50855.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239724',4598015,'2762','418',39733.11,39733.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239724',4598016,'2763','418',35566.16,35566.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239724',4598017,'2764','418',36813.26,36813.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239724',4598018,'2765','418',17906.65,17906.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239725',4598019,'2760','418',587747.04,588044.57,0.00,0.00,297.53,190419.20,0.00,0.00,0.00),('1','187','939','239725',4598020,'2761','418',50855.94,51488.92,0.00,0.00,632.98,367128.40,0.00,0.00,0.00),('1','187','939','239725',4598021,'2762','418',39733.11,40495.61,0.00,0.00,762.50,442250.00,0.00,0.00,0.00),('1','187','939','239725',4598022,'2763','418',35566.16,36066.16,0.00,0.00,500.00,290000.00,0.00,0.00,0.00),('1','187','939','239725',4598023,'2764','418',36813.26,37279.26,0.00,0.00,466.00,270280.00,0.00,0.00,0.00),('1','187','939','239725',4598024,'2765','418',17906.65,18118.65,0.00,0.00,212.00,122960.00,0.00,0.00,0.00),('1','187','939','239726',4598025,'2760','418',588044.57,588358.76,0.00,0.00,314.19,201081.60,0.00,0.00,0.00),('1','187','939','239726',4598026,'2761','418',51488.92,52030.92,0.00,0.00,542.00,314360.00,0.00,0.00,0.00),('1','187','939','239726',4598027,'2762','418',40495.61,41065.34,0.00,0.00,569.73,330443.40,0.00,0.00,0.00),('1','187','939','239726',4598028,'2763','418',36066.16,36501.16,0.00,0.00,435.00,252300.00,0.00,0.00,0.00),('1','187','939','239726',4598029,'2764','418',37279.26,37629.26,0.00,0.00,350.00,203000.00,0.00,0.00,0.00),('1','187','939','239726',4598030,'2765','418',18118.65,18433.65,0.00,0.00,315.00,182700.00,0.00,0.00,0.00),('1','187','939','239727',4598031,'2760','418',588358.76,588682.73,0.00,0.00,323.97,207340.80,0.00,0.00,0.00),('1','187','939','239727',4598032,'2761','418',52030.92,53472.78,0.00,0.00,1441.86,836278.80,0.00,0.00,0.00),('1','187','939','239727',4598033,'2762','418',41065.34,42251.34,0.00,0.00,1186.00,687880.00,0.00,0.00,0.00),('1','187','939','239727',4598034,'2763','418',36501.16,37313.16,0.00,0.00,812.00,470960.00,0.00,0.00,0.00),('1','187','939','239727',4598035,'2764','418',37629.26,38591.35,0.00,0.00,962.09,558012.20,0.00,0.00,0.00),('1','187','939','239727',4598036,'2765','418',18433.65,18938.65,0.00,0.00,505.00,292900.00,0.00,0.00,0.00),('1','187','939','239728',4598037,'2760','418',588682.73,589067.37,0.00,0.00,384.64,246169.60,0.00,0.00,0.00),('1','187','939','239728',4598038,'2761','418',53472.78,54899.88,0.00,0.00,1427.10,827718.00,0.00,0.00,0.00),('1','187','939','239728',4598039,'2762','418',42251.34,43404.34,0.00,0.00,1153.00,668740.00,0.00,0.00,0.00),('1','187','939','239728',4598040,'2763','418',37313.16,38581.16,0.00,0.00,1268.00,735440.00,0.00,0.00,0.00),('1','187','939','239728',4598041,'2764','418',38591.35,39114.33,0.00,0.00,522.98,303328.40,0.00,0.00,0.00),('1','187','939','239728',4598042,'2765','418',18938.65,19587.74,0.00,0.00,649.09,376472.20,0.00,0.00,0.00),('1','187','939','239729',4598043,'2760','418',589067.37,589502.85,0.00,0.00,435.48,278707.20,0.00,0.00,0.00),('1','187','939','239729',4598044,'2761','418',54899.88,55691.88,0.00,0.00,792.00,459360.00,0.00,0.00,0.00),('1','187','939','239729',4598045,'2762','418',43404.34,44376.03,0.00,0.00,971.69,563580.20,0.00,0.00,0.00),('1','187','939','239729',4598046,'2763','418',38581.16,39721.16,0.00,0.00,1140.00,661200.00,0.00,0.00,0.00),('1','187','939','239729',4598047,'2764','418',39114.33,39964.33,0.00,0.00,850.00,493000.00,0.00,0.00,0.00),('1','187','939','239729',4598048,'2765','418',19587.74,20335.74,0.00,0.00,748.00,433840.00,0.00,0.00,0.00),('1','187','939','239730',4598049,'2760','418',589502.85,589889.19,0.00,0.00,386.34,247257.60,0.00,0.00,0.00),('1','187','939','239730',4598050,'2761','418',55691.88,56486.88,0.00,0.00,795.00,461100.00,0.00,0.00,0.00),('1','187','939','239730',4598051,'2762','418',44376.03,45176.03,0.00,0.00,800.00,464000.00,0.00,0.00,0.00),('1','187','939','239730',4598052,'2763','418',39721.16,40178.41,0.00,0.00,457.25,265205.00,0.00,0.00,0.00),('1','187','939','239730',4598053,'2764','418',39964.33,40169.33,0.00,0.00,205.00,118900.00,0.00,0.00,0.00),('1','187','939','239730',4598054,'2765','418',20335.74,20935.74,0.00,0.00,600.00,348000.00,0.00,0.00,0.00),('1','187','939','239731',4598055,'2760','418',589889.19,589889.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239731',4598056,'2761','418',56486.88,56568.61,0.00,0.00,81.73,47403.40,0.00,0.00,0.00),('1','187','939','239731',4598057,'2762','418',45176.03,45276.14,0.00,0.00,100.11,58063.80,0.00,0.00,0.00),('1','187','939','239731',4598058,'2763','418',40178.41,40178.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239731',4598059,'2764','418',40169.33,40169.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239731',4598060,'2765','418',20935.74,20935.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239732',4598061,'2760','418',589889.19,589889.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239732',4598062,'2761','418',56568.61,56568.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239732',4598063,'2762','418',45276.14,45276.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239732',4598064,'2763','418',40178.41,40178.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239732',4598065,'2764','418',40169.33,40169.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239732',4598066,'2765','418',20935.74,20935.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239733',4598067,'2760','418',589889.19,590087.94,0.00,0.00,198.75,127200.00,0.00,0.00,0.00),('1','187','939','239733',4598068,'2761','418',56568.61,57765.90,0.00,0.00,1197.29,694428.20,0.00,0.00,0.00),('1','187','939','239733',4598069,'2762','418',45276.14,46090.97,0.00,0.00,814.83,472601.40,0.00,0.00,0.00),('1','187','939','239733',4598070,'2763','418',40178.41,41170.11,0.00,0.00,991.70,575186.00,0.00,0.00,0.00),('1','187','939','239733',4598071,'2764','418',40169.33,40594.04,0.00,0.00,424.71,246331.80,0.00,0.00,0.00),('1','187','939','239733',4598072,'2765','418',20935.74,21485.18,0.00,0.00,549.44,318675.20,0.00,0.00,0.00),('1','187','939','239734',4598073,'2760','418',590087.94,590442.48,0.00,0.00,354.54,226905.60,0.00,0.00,0.00),('1','187','939','239734',4598074,'2761','418',57765.90,59253.40,0.00,0.00,1487.50,862750.00,0.00,0.00,0.00),('1','187','939','239734',4598075,'2762','418',46090.97,46740.97,0.00,0.00,650.00,377000.00,0.00,0.00,0.00),('1','187','939','239734',4598076,'2763','418',41170.11,42005.10,0.00,0.00,834.99,484294.20,0.00,0.00,0.00),('1','187','939','239734',4598077,'2764','418',40594.04,41089.04,0.00,0.00,495.00,287100.00,0.00,0.00,0.00),('1','187','939','239734',4598078,'2765','418',21485.18,21870.18,0.00,0.00,385.00,223300.00,0.00,0.00,0.00),('1','187','939','239735',4598079,'2760','418',590442.48,590776.00,0.00,0.00,333.52,213452.80,0.00,0.00,0.00),('1','187','939','239735',4598080,'2761','418',59253.40,60514.79,0.00,0.00,1261.39,731606.20,0.00,0.00,0.00),('1','187','939','239735',4598081,'2762','418',46740.97,47766.25,0.00,0.00,1025.28,594662.40,0.00,0.00,0.00),('1','187','939','239735',4598082,'2763','418',42005.10,43023.09,0.00,0.00,1017.99,590434.20,0.00,0.00,0.00),('1','187','939','239735',4598083,'2764','418',41089.04,41539.04,0.00,0.00,450.00,261000.00,0.00,0.00,0.00),('1','187','939','239735',4598084,'2765','418',21870.18,22470.18,0.00,0.00,600.00,348000.00,0.00,0.00,0.00),('1','187','939','239736',4598085,'2760','418',590776.00,591197.20,0.00,0.00,421.20,269568.00,0.00,0.00,0.00),('1','187','939','239736',4598086,'2761','418',60514.79,61830.79,0.00,0.00,1316.00,763280.00,0.00,0.00,0.00),('1','187','939','239736',4598087,'2762','418',47766.25,48461.25,0.00,0.00,695.00,403100.00,0.00,0.00,0.00),('1','187','939','239736',4598088,'2763','418',43023.09,43956.09,0.00,0.00,933.00,541140.00,0.00,0.00,0.00),('1','187','939','239736',4598089,'2764','418',41539.04,42064.04,0.00,0.00,525.00,304500.00,0.00,0.00,0.00),('1','187','939','239736',4598090,'2765','418',22470.18,22870.18,0.00,0.00,400.00,232000.00,0.00,0.00,0.00),('1','187','939','239737',4598091,'2760','418',591197.20,591576.38,0.00,0.00,379.18,242675.20,0.00,0.00,0.00),('1','187','939','239737',4598092,'2761','418',61830.79,63080.79,0.00,0.00,1250.00,725000.00,0.00,0.00,0.00),('1','187','939','239737',4598093,'2762','418',48461.25,49424.25,0.00,0.00,963.00,558540.00,0.00,0.00,0.00),('1','187','939','239737',4598094,'2763','418',43956.09,44756.09,0.00,0.00,800.00,464000.00,0.00,0.00,0.00),('1','187','939','239737',4598095,'2764','418',42064.04,42514.04,0.00,0.00,450.00,261000.00,0.00,0.00,0.00),('1','187','939','239737',4598096,'2765','418',22870.18,23420.18,0.00,0.00,550.00,319000.00,0.00,0.00,0.00),('1','187','939','239738',4598097,'2760','418',591576.38,591850.78,0.00,0.00,274.40,175616.00,0.00,0.00,0.00),('1','187','939','239738',4598098,'2761','418',63080.79,63586.79,0.00,0.00,506.00,293480.00,0.00,0.00,0.00),('1','187','939','239738',4598099,'2762','418',49424.25,49869.89,0.00,0.00,445.64,258471.20,0.00,0.00,0.00),('1','187','939','239738',4598100,'2763','418',44756.09,45056.09,0.00,0.00,300.00,174000.00,0.00,0.00,0.00),('1','187','939','239738',4598101,'2764','418',42514.04,42839.04,0.00,0.00,325.00,188500.00,0.00,0.00,0.00),('1','187','939','239738',4598102,'2765','418',23420.18,23520.18,0.00,0.00,100.00,58000.00,0.00,0.00,0.00),('1','187','939','239739',4598103,'2760','418',591850.78,591850.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239739',4598104,'2761','418',63586.79,63900.29,0.00,0.00,313.50,181830.00,0.00,0.00,0.00),('1','187','939','239739',4598105,'2762','418',49869.89,50047.29,0.00,0.00,177.40,102892.00,0.00,0.00,0.00),('1','187','939','239739',4598106,'2763','418',45056.09,45227.09,0.00,0.00,171.00,99180.00,0.00,0.00,0.00),('1','187','939','239739',4598107,'2764','418',42839.04,42901.96,0.00,0.00,62.92,36493.60,0.00,0.00,0.00),('1','187','939','239739',4598108,'2765','418',23520.18,23622.30,0.00,0.00,102.12,59229.60,0.00,0.00,0.00),('1','187','939','239740',4598109,'2760','418',591850.78,591850.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239740',4598110,'2761','418',63900.29,63900.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239740',4598111,'2762','418',50047.29,50047.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239740',4598112,'2763','418',45227.09,45227.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239740',4598113,'2764','418',42901.96,42901.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239740',4598114,'2765','418',23622.30,23622.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239741',4598115,'2760','418',591850.78,592045.97,0.00,0.00,195.19,124921.60,0.00,0.00,0.00),('1','187','939','239741',4598116,'2761','418',63900.29,64419.29,0.00,0.00,519.00,301020.00,0.00,0.00,0.00),('1','187','939','239741',4598117,'2762','418',50047.29,50432.29,0.00,0.00,385.00,223300.00,0.00,0.00,0.00),('1','187','939','239741',4598118,'2763','418',45227.09,45527.09,0.00,0.00,300.00,174000.00,0.00,0.00,0.00),('1','187','939','239741',4598119,'2764','418',42901.96,43151.96,0.00,0.00,250.00,145000.00,0.00,0.00,0.00),('1','187','939','239741',4598120,'2765','418',23622.30,23822.30,0.00,0.00,200.00,116000.00,0.00,0.00,0.00),('1','187','939','239742',4598121,'2760','418',592045.97,592326.16,0.00,0.00,280.19,179321.60,0.00,0.00,0.00),('1','187','939','239742',4598122,'2761','418',64419.29,66077.79,0.00,0.00,1658.50,961930.00,0.00,0.00,0.00),('1','187','939','239742',4598123,'2762','418',50432.29,51797.29,0.00,0.00,1365.00,791700.00,0.00,0.00,0.00),('1','187','939','239742',4598124,'2763','418',45527.09,46655.59,0.00,0.00,1128.50,654530.00,0.00,0.00,0.00),('1','187','939','239742',4598125,'2764','418',43151.96,43502.35,0.00,0.00,350.39,203226.20,0.00,0.00,0.00),('1','187','939','239742',4598126,'2765','418',23822.30,24912.30,0.00,0.00,1090.00,632200.00,0.00,0.00,0.00),('1','187','939','239743',4598127,'2760','418',592326.16,592667.95,0.00,0.00,341.79,218745.60,0.00,0.00,0.00),('1','187','939','239743',4598128,'2761','418',66077.79,67876.81,0.00,0.00,1799.02,1043431.60,0.00,0.00,0.00),('1','187','939','239743',4598129,'2762','418',51797.29,53131.29,0.00,0.00,1334.00,773720.00,0.00,0.00,0.00),('1','187','939','239743',4598130,'2763','418',46655.59,48109.69,0.00,0.00,1454.10,843378.00,0.00,0.00,0.00),('1','187','939','239743',4598131,'2764','418',43502.35,44469.49,0.00,0.00,967.14,560941.20,0.00,0.00,0.00),('1','187','939','239743',4598132,'2765','418',24912.30,25324.30,0.00,0.00,412.00,238960.00,0.00,0.00,0.00),('1','187','939','239744',4598133,'2760','418',592667.95,593017.46,0.00,0.00,349.51,223686.40,0.00,0.00,0.00),('1','187','939','239744',4598134,'2761','418',67876.81,68976.81,0.00,0.00,1100.00,638000.00,0.00,0.00,0.00),('1','187','939','239744',4598135,'2762','418',53131.29,53727.29,0.00,0.00,596.00,345680.00,0.00,0.00,0.00),('1','187','939','239744',4598136,'2763','418',48109.69,48854.69,0.00,0.00,745.00,432100.00,0.00,0.00,0.00),('1','187','939','239744',4598137,'2764','418',44469.49,44919.49,0.00,0.00,450.00,261000.00,0.00,0.00,0.00),('1','187','939','239744',4598138,'2765','418',25324.30,25502.30,0.00,0.00,178.00,103240.00,0.00,0.00,0.00),('1','187','939','239745',4598139,'2760','418',593017.46,593204.13,0.00,0.00,186.67,119468.80,0.00,0.00,0.00),('1','187','939','239745',4598140,'2761','418',68976.81,70626.81,0.00,0.00,1650.00,957000.00,0.00,0.00,0.00),('1','187','939','239745',4598141,'2762','418',53727.29,55326.29,0.00,0.00,1599.00,927420.00,0.00,0.00,0.00),('1','187','939','239745',4598142,'2763','418',48854.69,49919.82,0.00,0.00,1065.13,617775.40,0.00,0.00,0.00),('1','187','939','239745',4598143,'2764','418',44919.49,45542.49,0.00,0.00,623.00,361340.00,0.00,0.00,0.00),('1','187','939','239745',4598144,'2765','418',25502.30,25955.30,0.00,0.00,453.00,262740.00,0.00,0.00,0.00),('1','187','939','239746',4598145,'2760','418',593204.13,593433.04,0.00,0.00,228.91,150164.96,0.00,0.00,0.00),('1','187','939','239746',4598146,'2761','418',70626.81,70884.29,0.00,0.00,257.48,157577.76,0.00,0.00,0.00),('1','187','939','239746',4598147,'2762','418',55326.29,55521.81,0.00,0.00,195.52,119658.24,0.00,0.00,0.00),('1','187','939','239746',4598148,'2763','418',49919.82,50167.21,0.00,0.00,247.39,151402.68,0.00,0.00,0.00),('1','187','939','239746',4598149,'2764','418',45542.49,45742.49,0.00,0.00,200.00,122400.00,0.00,0.00,0.00),('1','187','939','239746',4598150,'2765','418',25955.30,26005.30,0.00,0.00,50.00,30600.00,0.00,0.00,0.00),('1','187','939','239747',4598151,'2760','418',593433.04,593505.17,0.00,0.00,72.13,47317.28,0.00,0.00,0.00),('1','187','939','239747',4598152,'2761','418',70884.29,70976.87,0.00,0.00,92.58,56658.96,0.00,0.00,0.00),('1','187','939','239747',4598153,'2762','418',55521.81,55771.81,0.00,0.00,250.00,153000.00,0.00,0.00,0.00),('1','187','939','239747',4598154,'2763','418',50167.21,50217.21,0.00,0.00,50.00,30600.00,0.00,0.00,0.00),('1','187','939','239747',4598155,'2764','418',45742.49,45742.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239747',4598156,'2765','418',26005.30,26005.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239748',4598157,'2760','418',593505.17,593716.18,0.00,0.00,211.01,139266.60,0.00,0.00,0.00),('1','187','939','239748',4598158,'2761','418',70976.87,71690.87,0.00,0.00,714.00,436968.00,0.00,0.00,0.00),('1','187','939','239748',4598159,'2762','418',55771.81,56871.81,0.00,0.00,1100.00,673200.00,0.00,0.00,0.00),('1','187','939','239748',4598160,'2763','418',50217.21,50565.89,0.00,0.00,348.68,213392.16,0.00,0.00,0.00),('1','187','939','239748',4598161,'2764','418',45742.49,45987.49,0.00,0.00,245.00,149940.00,0.00,0.00,0.00),('1','187','939','239748',4598162,'2765','418',26005.30,26178.30,0.00,0.00,173.00,105876.00,0.00,0.00,0.00),('1','187','939','239749',4598163,'2760','418',593716.18,593969.98,0.00,0.00,253.80,167508.00,0.00,0.00,0.00),('1','187','939','239749',4598164,'2761','418',71690.87,72350.42,0.00,0.00,659.55,403644.60,0.00,0.00,0.00),('1','187','939','239749',4598165,'2762','418',56871.81,57676.81,0.00,0.00,805.00,492660.00,0.00,0.00,0.00),('1','187','939','239749',4598166,'2763','418',50565.89,51110.89,0.00,0.00,545.00,333540.00,0.00,0.00,0.00),('1','187','939','239749',4598167,'2764','418',45987.49,46637.49,0.00,0.00,650.00,397800.00,0.00,0.00,0.00),('1','187','939','239749',4598168,'2765','418',26178.30,26328.30,0.00,0.00,150.00,91800.00,0.00,0.00,0.00),('1','187','939','239750',4598169,'2760','418',593969.98,594363.11,0.00,0.00,393.13,259465.80,0.00,0.00,0.00),('1','187','939','239750',4598170,'2761','418',72350.42,73822.76,0.00,0.00,1472.34,899972.08,0.00,0.00,0.00),('1','187','939','239750',4598171,'2762','418',57676.81,59631.58,0.00,0.00,1954.77,1196319.24,0.00,0.00,0.00),('1','187','939','239750',4598172,'2763','418',51110.89,52416.87,0.00,0.00,1305.98,798489.76,0.00,0.00,0.00),('1','187','939','239750',4598173,'2764','418',46637.49,47530.49,0.00,0.00,893.00,545746.00,0.00,0.00,0.00),('1','187','939','239750',4598174,'2765','418',26328.30,26658.30,0.00,0.00,330.00,201960.00,0.00,0.00,0.00),('1','187','939','239751',4598175,'2760','418',594363.11,594647.36,0.00,0.00,284.25,187605.00,0.00,0.00,0.00),('1','187','939','239751',4598176,'2761','418',73822.76,75599.46,0.00,0.00,1776.70,1083954.40,0.00,0.00,0.00),('1','187','939','239751',4598177,'2762','418',59631.58,60953.77,0.00,0.00,1322.19,806960.90,0.00,0.00,0.00),('1','187','939','239751',4598178,'2763','418',52416.87,53893.25,0.00,0.00,1476.38,901441.80,0.00,0.00,0.00),('1','187','939','239751',4598179,'2764','418',47530.49,48182.49,0.00,0.00,652.00,398374.00,0.00,0.00,0.00),('1','187','939','239751',4598180,'2765','418',26658.30,27033.30,0.00,0.00,375.00,228850.00,0.00,0.00,0.00),('1','187','939','239752',4598181,'2760','418',594647.36,594858.54,0.00,0.00,211.18,139378.80,0.00,0.00,0.00),('1','187','939','239752',4598182,'2761','418',75599.46,77845.22,0.00,0.00,2245.76,1373039.12,0.00,0.00,0.00),('1','187','939','239752',4598183,'2762','418',60953.77,62205.00,0.00,0.00,1251.23,765752.76,0.00,0.00,0.00),('1','187','939','239752',4598184,'2763','418',53893.25,55178.25,0.00,0.00,1285.00,785620.00,0.00,0.00,0.00),('1','187','939','239752',4598185,'2764','418',48182.49,49506.49,0.00,0.00,1324.00,807940.00,0.00,0.00,0.00),('1','187','939','239752',4598186,'2765','418',27033.30,27333.30,0.00,0.00,300.00,183600.00,0.00,0.00,0.00),('1','187','939','239753',4598187,'2760','418',594858.54,594858.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239753',4598188,'2761','418',77845.22,77845.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239753',4598189,'2762','418',62205.00,62205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239753',4598190,'2763','418',55178.25,55178.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239753',4598191,'2764','418',49506.49,49506.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239753',4598192,'2765','418',27333.30,27333.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239754',4598193,'2760','418',594858.54,595061.46,0.00,0.00,202.92,133927.20,0.00,0.00,0.00),('1','187','939','239754',4598194,'2761','418',77845.22,79757.81,0.00,0.00,1912.59,1202710.52,0.00,0.00,0.00),('1','187','939','239754',4598195,'2762','418',62205.00,63859.97,0.00,0.00,1654.97,1041385.10,0.00,0.00,0.00),('1','187','939','239754',4598196,'2763','418',55178.25,56274.25,0.00,0.00,1096.00,690030.00,0.00,0.00,0.00),('1','187','939','239754',4598197,'2764','418',49506.49,50031.89,0.00,0.00,525.40,330602.00,0.00,0.00,0.00),('1','187','939','239754',4598198,'2765','418',27333.30,27654.73,0.00,0.00,321.43,202500.90,0.00,0.00,0.00),('1','187','939','239755',4598199,'2760','418',595061.46,595335.06,0.00,0.00,273.60,180576.00,0.00,0.00,0.00),('1','187','939','239755',4598200,'2761','418',79757.81,81306.05,0.00,0.00,1548.24,975391.20,0.00,0.00,0.00),('1','187','939','239755',4598201,'2762','418',63859.97,65155.47,0.00,0.00,1295.50,816165.00,0.00,0.00,0.00),('1','187','939','239755',4598202,'2763','418',56274.25,57719.23,0.00,0.00,1444.98,910337.40,0.00,0.00,0.00),('1','187','939','239755',4598203,'2764','418',50031.89,51076.53,0.00,0.00,1044.64,658123.20,0.00,0.00,0.00),('1','187','939','239755',4598204,'2765','418',27654.73,27951.73,0.00,0.00,297.00,187110.00,0.00,0.00,0.00),('1','187','939','239756',4598205,'2760','418',595335.06,595616.04,0.00,0.00,280.98,185446.80,0.00,0.00,0.00),('1','187','939','239756',4598206,'2761','418',81306.05,83236.05,0.00,0.00,1930.00,1214300.00,0.00,0.00,0.00),('1','187','939','239756',4598207,'2762','418',65155.47,66547.47,0.00,0.00,1392.00,876060.00,0.00,0.00,0.00),('1','187','939','239756',4598208,'2763','418',57719.23,58933.23,0.00,0.00,1214.00,763920.00,0.00,0.00,0.00),('1','187','939','239756',4598209,'2764','418',51076.53,51786.53,0.00,0.00,710.00,446800.00,0.00,0.00,0.00),('1','187','939','239756',4598210,'2765','418',27951.73,28862.73,0.00,0.00,911.00,573630.00,0.00,0.00,0.00),('1','187','939','239757',4598211,'2760','418',595616.04,595742.09,0.00,0.00,126.05,83193.00,0.00,0.00,0.00),('1','187','939','239757',4598212,'2761','418',83236.05,85108.44,0.00,0.00,1872.39,1177860.92,0.00,0.00,0.00),('1','187','939','239757',4598213,'2762','418',66547.47,67884.68,0.00,0.00,1337.21,840767.88,0.00,0.00,0.00),('1','187','939','239757',4598214,'2763','418',58933.23,60023.97,0.00,0.00,1090.74,685594.72,0.00,0.00,0.00),('1','187','939','239757',4598215,'2764','418',51786.53,52545.42,0.00,0.00,758.89,477082.92,0.00,0.00,0.00),('1','187','939','239757',4598216,'2765','418',28862.73,29204.73,0.00,0.00,342.00,215460.00,0.00,0.00,0.00),('1','187','939','239758',4598217,'2760','418',595742.09,595742.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239758',4598218,'2761','418',85108.44,85108.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239758',4598219,'2762','418',67884.68,67884.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239758',4598220,'2763','418',60023.97,60023.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239758',4598221,'2764','418',52545.42,52545.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239758',4598222,'2765','418',29204.73,29204.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239759',4598223,'2760','418',595742.09,596057.55,0.00,0.00,315.46,214512.80,0.00,0.00,0.00),('1','187','939','239759',4598224,'2761','418',85108.44,87888.95,0.00,0.00,2780.51,1779526.40,0.00,0.00,0.00),('1','187','939','239759',4598225,'2762','418',67884.68,69662.58,0.00,0.00,1777.90,1137856.00,0.00,0.00,0.00),('1','187','939','239759',4598226,'2763','418',60023.97,61807.51,0.00,0.00,1783.54,1141465.60,0.00,0.00,0.00),('1','187','939','239759',4598227,'2764','418',52545.42,53620.42,0.00,0.00,1075.00,688000.00,0.00,0.00,0.00),('1','187','939','239759',4598228,'2765','418',29204.73,29857.73,0.00,0.00,653.00,417920.00,0.00,0.00,0.00),('1','187','939','239760',4598229,'2760','418',596057.55,596244.92,0.00,0.00,187.37,127411.60,0.00,0.00,0.00),('1','187','939','239760',4598230,'2761','418',87888.95,92312.97,0.00,0.00,4424.02,2831372.80,0.00,0.00,0.00),('1','187','939','239760',4598231,'2762','418',69662.58,72659.58,0.00,0.00,2997.00,1918080.00,0.00,0.00,0.00),('1','187','939','239760',4598232,'2763','418',61807.51,64892.53,0.00,0.00,3085.02,1974412.80,0.00,0.00,0.00),('1','187','939','239760',4598233,'2764','418',53620.42,55273.42,0.00,0.00,1653.00,1057920.00,0.00,0.00,0.00),('1','187','939','239760',4598234,'2765','418',29857.73,30912.73,0.00,0.00,1055.00,675200.00,0.00,0.00,0.00),('1','187','939','239761',4598235,'2760','418',596244.92,596347.78,0.00,0.00,102.86,69944.80,0.00,0.00,0.00),('1','187','939','239761',4598236,'2761','418',92312.97,93321.76,0.00,0.00,1008.79,645625.60,0.00,0.00,0.00),('1','187','939','239761',4598237,'2762','418',72659.58,73268.19,0.00,0.00,608.61,389510.40,0.00,0.00,0.00),('1','187','939','239761',4598238,'2763','418',64892.53,65373.08,0.00,0.00,480.55,310779.70,0.00,0.00,0.00),('1','187','939','239761',4598239,'2764','418',55273.42,55523.42,0.00,0.00,250.00,160000.00,0.00,0.00,0.00),('1','187','939','239761',4598240,'2765','418',30912.73,31012.73,0.00,0.00,100.00,64000.00,0.00,0.00,0.00),('1','187','939','239762',4598241,'2760','418',596347.78,596347.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239762',4598242,'2761','418',93321.76,93321.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239762',4598243,'2762','418',73268.19,73268.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239762',4598244,'2763','418',65373.08,65373.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239762',4598245,'2764','418',55523.42,55523.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239762',4598246,'2765','418',31012.73,31012.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239763',4598247,'2760','418',596347.78,596661.43,0.00,0.00,313.65,219555.00,0.00,0.00,0.00),('1','187','939','239763',4598248,'2761','418',93321.76,96937.37,0.00,0.00,3615.61,2407996.26,0.00,0.00,0.00),('1','187','939','239763',4598249,'2762','418',73268.19,75607.31,0.00,0.00,2339.12,1557853.92,0.00,0.00,0.00),('1','187','939','239763',4598250,'2763','418',65373.08,67697.08,0.00,0.00,2324.00,1547784.00,0.00,0.00,0.00),('1','187','939','239763',4598251,'2764','418',55523.42,56777.04,0.00,0.00,1253.62,834910.92,0.00,0.00,0.00),('1','187','939','239763',4598252,'2765','418',31012.73,31910.44,0.00,0.00,897.71,597874.86,0.00,0.00,0.00),('1','187','939','239764',4598253,'2760','418',596661.43,597031.80,0.00,0.00,370.37,259259.00,0.00,0.00,0.00),('1','187','939','239764',4598254,'2761','418',96937.37,101697.48,0.00,0.00,4760.11,3170233.26,0.00,0.00,0.00),('1','187','939','239764',4598255,'2762','418',75607.31,78471.35,0.00,0.00,2864.04,1907450.64,0.00,0.00,0.00),('1','187','939','239764',4598256,'2763','418',67697.08,70593.05,0.00,0.00,2895.97,1928716.02,0.00,0.00,0.00),('1','187','939','239764',4598257,'2764','418',56777.04,58297.37,0.00,0.00,1520.33,1012539.78,0.00,0.00,0.00),('1','187','939','239764',4598258,'2765','418',31910.44,33277.70,0.00,0.00,1367.26,910595.16,0.00,0.00,0.00),('1','187','939','239765',4598259,'2760','418',597031.80,597031.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239765',4598260,'2761','418',101697.48,101697.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239765',4598261,'2762','418',78471.35,78471.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239765',4598262,'2763','418',70593.05,70593.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239765',4598263,'2764','418',58297.37,58297.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239765',4598264,'2765','418',33277.70,33277.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239766',4598265,'2760','418',597031.80,597345.63,0.00,0.00,313.83,229095.90,0.00,0.00,0.00),('1','187','939','239766',4598266,'2761','418',101697.48,105679.08,0.00,0.00,3981.60,2691561.60,0.00,0.00,0.00),('1','187','939','239766',4598267,'2762','418',78471.35,80874.09,0.00,0.00,2402.74,1624252.24,0.00,0.00,0.00),('1','187','939','239766',4598268,'2763','418',70593.05,73145.21,0.00,0.00,2552.16,1725260.16,0.00,0.00,0.00),('1','187','939','239766',4598269,'2764','418',58297.37,59375.37,0.00,0.00,1078.00,728728.00,0.00,0.00,0.00),('1','187','939','239766',4598270,'2765','418',33277.70,34414.20,0.00,0.00,1136.50,768274.00,0.00,0.00,0.00),('1','187','939','239767',4598271,'2760','418',597345.63,597557.30,0.00,0.00,211.67,154519.10,0.00,0.00,0.00),('1','187','939','239767',4598272,'2761','418',105679.08,108439.47,0.00,0.00,2760.39,1866023.64,0.00,0.00,0.00),('1','187','939','239767',4598273,'2762','418',80874.09,82718.75,0.00,0.00,1844.66,1246990.16,0.00,0.00,0.00),('1','187','939','239767',4598274,'2763','418',73145.21,74813.92,0.00,0.00,1668.71,1128047.96,0.00,0.00,0.00),('1','187','939','239767',4598275,'2764','418',59375.37,60236.66,0.00,0.00,861.29,582232.04,0.00,0.00,0.00),('1','187','939','239767',4598276,'2765','418',34414.20,35272.32,0.00,0.00,858.12,580089.12,0.00,0.00,0.00),('1','187','939','239768',4598277,'2760','418',597557.30,597557.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239768',4598278,'2761','418',108439.47,108439.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239768',4598279,'2762','418',82718.75,82718.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239768',4598280,'2763','418',74813.92,74813.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239768',4598281,'2764','418',60236.66,60236.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239768',4598282,'2765','418',35272.32,35272.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239769',4598283,'2760','418',597557.30,598074.95,0.00,0.00,517.65,377884.50,0.00,0.00,0.00),('1','187','939','239769',4598284,'2761','418',108439.47,114187.89,0.00,0.00,5748.42,4017594.00,0.00,0.00,0.00),('1','187','939','239769',4598285,'2762','418',82718.75,85397.52,0.00,0.00,2678.77,1871545.00,0.00,0.00,0.00),('1','187','939','239769',4598286,'2763','418',74813.92,77765.72,0.00,0.00,2951.80,2061154.00,0.00,0.00,0.00),('1','187','939','239769',4598287,'2764','418',60236.66,61630.28,0.00,0.00,1393.62,974034.00,0.00,0.00,0.00),('1','187','939','239769',4598288,'2765','418',35272.32,36614.22,0.00,0.00,1341.90,937230.60,0.00,0.00,0.00),('1','187','939','239770',4598289,'2760','418',598074.95,598271.84,0.00,0.00,196.89,151605.30,0.00,0.00,0.00),('1','187','939','239770',4598290,'2761','418',114187.89,115587.89,0.00,0.00,1400.00,978800.00,0.00,0.00,0.00),('1','187','939','239770',4598291,'2762','418',85397.52,86423.54,0.00,0.00,1026.02,716713.88,0.00,0.00,0.00),('1','187','939','239770',4598292,'2763','418',77765.72,78415.52,0.00,0.00,649.80,454261.20,0.00,0.00,0.00),('1','187','939','239770',4598293,'2764','418',61630.28,62035.28,0.00,0.00,405.00,282300.00,0.00,0.00,0.00),('1','187','939','239770',4598294,'2765','418',36614.22,36809.42,0.00,0.00,195.20,135738.80,0.00,0.00,0.00),('1','187','939','239771',4598295,'2760','418',598271.84,598570.10,0.00,0.00,298.26,229660.20,0.00,0.00,0.00),('1','187','939','239771',4598296,'2761','418',115587.89,117921.16,0.00,0.00,2333.27,1626267.38,0.00,0.00,0.00),('1','187','939','239771',4598297,'2762','418',86423.54,87728.54,0.00,0.00,1305.00,908970.00,0.00,0.00,0.00),('1','187','939','239771',4598298,'2763','418',78415.52,79509.18,0.00,0.00,1093.66,762810.04,0.00,0.00,0.00),('1','187','939','239771',4598299,'2764','418',62035.28,62860.28,0.00,0.00,825.00,575100.00,0.00,0.00,0.00),('1','187','939','239771',4598300,'2765','418',36809.42,37119.42,0.00,0.00,310.00,217000.00,0.00,0.00,0.00),('1','187','939','239772',4598301,'2760','418',598570.10,598570.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239772',4598302,'2761','418',117921.16,117921.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239772',4598303,'2762','418',87728.54,87728.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239772',4598304,'2763','418',79509.18,79509.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239772',4598305,'2764','418',62860.28,62860.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239772',4598306,'2765','418',37119.42,37119.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239773',4598307,'2760','418',598570.10,598806.17,0.00,0.00,236.07,181773.90,0.00,0.00,0.00),('1','187','939','239773',4598308,'2761','418',117921.16,119844.73,0.00,0.00,1923.57,1335157.58,0.00,0.00,0.00),('1','187','939','239773',4598309,'2762','418',87728.54,88872.54,0.00,0.00,1144.00,794987.00,0.00,0.00,0.00),('1','187','939','239773',4598310,'2763','418',79509.18,80460.52,0.00,0.00,951.34,661181.30,0.00,0.00,0.00),('1','187','939','239773',4598311,'2764','418',62860.28,63610.28,0.00,0.00,750.00,521250.00,0.00,0.00,0.00),('1','187','939','239773',4598312,'2765','418',37119.42,37479.42,0.00,0.00,360.00,250200.00,0.00,0.00,0.00),('1','187','939','239774',4598313,'2760','418',598806.17,598990.69,0.00,0.00,184.52,142080.40,0.00,0.00,0.00),('1','187','939','239774',4598314,'2761','418',119844.73,120869.28,0.00,0.00,1024.55,712062.25,0.00,0.00,0.00),('1','187','939','239774',4598315,'2762','418',88872.54,89686.54,0.00,0.00,814.00,565730.00,0.00,0.00,0.00),('1','187','939','239774',4598316,'2763','418',80460.52,81022.25,0.00,0.00,561.73,390402.35,0.00,0.00,0.00),('1','187','939','239774',4598317,'2764','418',63610.28,63841.28,0.00,0.00,231.00,160545.00,0.00,0.00,0.00),('1','187','939','239774',4598318,'2765','418',37479.42,37743.42,0.00,0.00,264.00,183480.00,0.00,0.00,0.00),('1','187','939','239775',4598319,'2760','418',598990.69,599162.47,0.00,0.00,171.78,132270.60,0.00,0.00,0.00),('1','187','939','239775',4598320,'2761','418',120869.28,121866.59,0.00,0.00,997.31,693130.45,0.00,0.00,0.00),('1','187','939','239775',4598321,'2762','418',89686.54,90578.22,0.00,0.00,891.68,619717.60,0.00,0.00,0.00),('1','187','939','239775',4598322,'2763','418',81022.25,81502.25,0.00,0.00,480.00,333600.00,0.00,0.00,0.00),('1','187','939','239775',4598323,'2764','418',63841.28,64041.28,0.00,0.00,200.00,139000.00,0.00,0.00,0.00),('1','187','939','239775',4598324,'2765','418',37743.42,37793.42,0.00,0.00,50.00,34750.00,0.00,0.00,0.00),('1','187','939','239776',4598325,'2760','418',599162.47,599502.56,0.00,0.00,340.09,261869.30,0.00,0.00,0.00),('1','187','939','239776',4598326,'2761','418',121866.59,123228.35,0.00,0.00,1361.76,939614.40,0.00,0.00,0.00),('1','187','939','239776',4598327,'2762','418',90578.22,91300.22,0.00,0.00,722.00,498930.00,0.00,0.00,0.00),('1','187','939','239776',4598328,'2763','418',81502.25,81882.25,0.00,0.00,380.00,262200.00,0.00,0.00,0.00),('1','187','939','239776',4598329,'2764','418',64041.28,64426.28,0.00,0.00,385.00,265650.00,0.00,0.00,0.00),('1','187','939','239776',4598330,'2765','418',37793.42,37843.42,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239777',4598331,'2760','418',599502.56,599834.75,0.00,0.00,332.19,255786.30,0.00,0.00,0.00),('1','187','939','239777',4598332,'2761','418',123228.35,124764.41,0.00,0.00,1536.06,1059881.40,0.00,0.00,0.00),('1','187','939','239777',4598333,'2762','418',91300.22,92254.22,0.00,0.00,954.00,658260.00,0.00,0.00,0.00),('1','187','939','239777',4598334,'2763','418',81882.25,82482.25,0.00,0.00,600.00,414000.00,0.00,0.00,0.00),('1','187','939','239777',4598335,'2764','418',64426.28,64661.30,0.00,0.00,235.02,162163.80,0.00,0.00,0.00),('1','187','939','239777',4598336,'2765','418',37843.42,38131.94,0.00,0.00,288.52,199078.80,0.00,0.00,0.00),('1','187','939','239778',4598337,'2760','418',599834.75,599995.03,0.00,0.00,160.28,123415.60,0.00,0.00,0.00),('1','187','939','239778',4598338,'2761','418',124764.41,125214.41,0.00,0.00,450.00,310500.00,0.00,0.00,0.00),('1','187','939','239778',4598339,'2762','418',92254.22,92644.27,0.00,0.00,390.05,269134.50,0.00,0.00,0.00),('1','187','939','239778',4598340,'2763','418',82482.25,82610.16,0.00,0.00,127.91,88257.90,0.00,0.00,0.00),('1','187','939','239778',4598341,'2764','418',64661.30,64713.18,0.00,0.00,51.88,35797.20,0.00,0.00,0.00),('1','187','939','239778',4598342,'2765','418',38131.94,38181.94,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239779',4598343,'2760','418',599995.03,600245.00,0.00,0.00,249.97,192476.90,0.00,0.00,0.00),('1','187','939','239779',4598344,'2761','418',125214.41,127042.91,0.00,0.00,1828.50,1259926.00,0.00,0.00,0.00),('1','187','939','239779',4598345,'2762','418',92644.27,93561.31,0.00,0.00,917.04,631657.84,0.00,0.00,0.00),('1','187','939','239779',4598346,'2763','418',82610.16,83210.16,0.00,0.00,600.00,413100.00,0.00,0.00,0.00),('1','187','939','239779',4598347,'2764','418',64713.18,65204.18,0.00,0.00,491.00,338190.00,0.00,0.00,0.00),('1','187','939','239779',4598348,'2765','418',38181.94,38381.94,0.00,0.00,200.00,137600.00,0.00,0.00,0.00),('1','187','939','239780',4598349,'2760','418',600245.00,600288.09,0.00,0.00,43.09,33179.30,0.00,0.00,0.00),('1','187','939','239780',4598350,'2761','418',127042.91,127344.93,0.00,0.00,302.02,208393.80,0.00,0.00,0.00),('1','187','939','239780',4598351,'2762','418',93561.31,93723.84,0.00,0.00,162.53,112145.70,0.00,0.00,0.00),('1','187','939','239780',4598352,'2763','418',83210.16,83309.62,0.00,0.00,99.46,68627.40,0.00,0.00,0.00),('1','187','939','239780',4598353,'2764','418',65204.18,65254.18,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239780',4598354,'2765','418',38381.94,38381.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239781',4598355,'2760','418',600288.09,600288.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239781',4598356,'2761','418',127344.93,127344.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239781',4598357,'2762','418',93723.84,93723.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239781',4598358,'2763','418',83309.62,83309.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239781',4598359,'2764','418',65254.18,65254.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239781',4598360,'2765','418',38381.94,38381.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239782',4598361,'2760','418',600288.09,600320.52,0.00,0.00,32.43,24971.10,0.00,0.00,0.00),('1','187','939','239782',4598362,'2761','418',127344.93,127555.29,0.00,0.00,210.36,145148.40,0.00,0.00,0.00),('1','187','939','239782',4598363,'2762','418',93723.84,93973.84,0.00,0.00,250.00,172500.00,0.00,0.00,0.00),('1','187','939','239782',4598364,'2763','418',83309.62,83659.62,0.00,0.00,350.00,241500.00,0.00,0.00,0.00),('1','187','939','239782',4598365,'2764','418',65254.18,65354.96,0.00,0.00,100.78,69538.20,0.00,0.00,0.00),('1','187','939','239782',4598366,'2765','418',38381.94,38432.02,0.00,0.00,50.08,34555.20,0.00,0.00,0.00),('1','187','939','239783',4598367,'2760','418',600320.52,600694.34,0.00,0.00,373.82,287841.40,0.00,0.00,0.00),('1','187','939','239783',4598368,'2761','418',127555.29,129311.29,0.00,0.00,1756.00,1211640.00,0.00,0.00,0.00),('1','187','939','239783',4598369,'2762','418',93973.84,94959.88,0.00,0.00,986.04,680367.60,0.00,0.00,0.00),('1','187','939','239783',4598370,'2763','418',83659.62,84538.14,0.00,0.00,878.52,606178.80,0.00,0.00,0.00),('1','187','939','239783',4598371,'2764','418',65354.96,65684.18,0.00,0.00,329.22,227161.80,0.00,0.00,0.00),('1','187','939','239783',4598372,'2765','418',38432.02,38607.39,0.00,0.00,175.37,121005.30,0.00,0.00,0.00),('1','187','939','239784',4598373,'2760','418',600694.34,601117.73,0.00,0.00,423.39,326010.30,0.00,0.00,0.00),('1','187','939','239784',4598374,'2761','418',129311.29,131061.29,0.00,0.00,1750.00,1207500.00,0.00,0.00,0.00),('1','187','939','239784',4598375,'2762','418',94959.88,95920.95,0.00,0.00,961.07,663138.30,0.00,0.00,0.00),('1','187','939','239784',4598376,'2763','418',84538.14,85737.92,0.00,0.00,1199.78,827848.20,0.00,0.00,0.00),('1','187','939','239784',4598377,'2764','418',65684.18,66019.18,0.00,0.00,335.00,231150.00,0.00,0.00,0.00),('1','187','939','239784',4598378,'2765','418',38607.39,38636.13,0.00,0.00,28.74,19830.60,0.00,0.00,0.00),('1','187','939','239785',4598379,'2760','418',601117.73,601475.47,0.00,0.00,357.74,275459.80,0.00,0.00,0.00),('1','187','939','239785',4598380,'2761','418',131061.29,131576.29,0.00,0.00,515.00,355350.00,0.00,0.00,0.00),('1','187','939','239785',4598381,'2762','418',95920.95,96300.95,0.00,0.00,380.00,262200.00,0.00,0.00,0.00),('1','187','939','239785',4598382,'2763','418',85737.92,86187.92,0.00,0.00,450.00,310500.00,0.00,0.00,0.00),('1','187','939','239785',4598383,'2764','418',66019.18,66169.18,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','187','939','239785',4598384,'2765','418',38636.13,38736.13,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','187','939','239786',4598385,'2760','418',601475.47,601728.17,0.00,0.00,252.70,194579.00,0.00,0.00,0.00),('1','187','939','239786',4598386,'2761','418',131576.29,132175.37,0.00,0.00,599.08,413365.20,0.00,0.00,0.00),('1','187','939','239786',4598387,'2762','418',96300.95,96713.45,0.00,0.00,412.50,284625.00,0.00,0.00,0.00),('1','187','939','239786',4598388,'2763','418',86187.92,86437.92,0.00,0.00,250.00,172500.00,0.00,0.00,0.00),('1','187','939','239786',4598389,'2764','418',66169.18,66219.18,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239786',4598390,'2765','418',38736.13,38736.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239787',4598391,'2760','418',601728.17,602040.68,0.00,0.00,312.51,232632.70,0.00,0.00,0.00),('1','187','939','239787',4598392,'2761','418',132175.37,133383.37,0.00,0.00,1208.00,833520.00,0.00,0.00,0.00),('1','187','939','239787',4598393,'2762','418',96713.45,97263.45,0.00,0.00,550.00,379500.00,0.00,0.00,0.00),('1','187','939','239787',4598394,'2763','418',86437.92,87045.92,0.00,0.00,608.00,419520.00,0.00,0.00,0.00),('1','187','939','239787',4598395,'2764','418',66219.18,66532.68,0.00,0.00,313.50,216315.00,0.00,0.00,0.00),('1','187','939','239787',4598396,'2765','418',38736.13,38860.13,0.00,0.00,124.00,85560.00,0.00,0.00,0.00),('1','187','939','239788',4598397,'2760','418',602040.68,602259.27,0.00,0.00,218.59,168314.30,0.00,0.00,0.00),('1','187','939','239788',4598398,'2761','418',133383.37,134414.53,0.00,0.00,1031.16,711417.15,0.00,0.00,0.00),('1','187','939','239788',4598399,'2762','418',97263.45,98336.55,0.00,0.00,1073.10,739437.90,0.00,0.00,0.00),('1','187','939','239788',4598400,'2763','418',87045.92,87991.87,0.00,0.00,945.95,650205.75,0.00,0.00,0.00),('1','187','939','239788',4598401,'2764','418',66532.68,67129.94,0.00,0.00,597.26,410858.10,0.00,0.00,0.00),('1','187','939','239788',4598402,'2765','418',38860.13,39260.13,0.00,0.00,400.00,274750.00,0.00,0.00,0.00),('1','187','939','239789',4598403,'2760','418',602259.27,602493.19,0.00,0.00,233.92,180118.40,0.00,0.00,0.00),('1','187','939','239789',4598404,'2761','418',134414.53,135883.52,0.00,0.00,1468.99,1013603.10,0.00,0.00,0.00),('1','187','939','239789',4598405,'2762','418',98336.55,99461.25,0.00,0.00,1124.70,776043.00,0.00,0.00,0.00),('1','187','939','239789',4598406,'2763','418',87991.87,88377.87,0.00,0.00,386.00,266340.00,0.00,0.00,0.00),('1','187','939','239789',4598407,'2764','418',67129.94,67382.94,0.00,0.00,253.00,174570.00,0.00,0.00,0.00),('1','187','939','239789',4598408,'2765','418',39260.13,39478.13,0.00,0.00,218.00,150420.00,0.00,0.00,0.00),('1','187','939','239790',4598409,'2760','418',602493.19,602493.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239790',4598410,'2761','418',135883.52,135883.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239790',4598411,'2762','418',99461.25,99461.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239790',4598412,'2763','418',88377.87,88377.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239790',4598413,'2764','418',67382.94,67382.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239790',4598414,'2765','418',39478.13,39478.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239791',4598415,'2760','418',602493.19,602886.41,0.00,0.00,393.22,302779.40,0.00,0.00,0.00),('1','187','939','239791',4598416,'2761','418',135883.52,140084.31,0.00,0.00,4200.79,2898545.10,0.00,0.00,0.00),('1','187','939','239791',4598417,'2762','418',99461.25,101595.18,0.00,0.00,2133.93,1472411.70,0.00,0.00,0.00),('1','187','939','239791',4598418,'2763','418',88377.87,89961.69,0.00,0.00,1583.82,1092835.80,0.00,0.00,0.00),('1','187','939','239791',4598419,'2764','418',67382.94,67968.58,0.00,0.00,585.64,404091.60,0.00,0.00,0.00),('1','187','939','239791',4598420,'2765','418',39478.13,40427.32,0.00,0.00,949.19,654941.10,0.00,0.00,0.00),('1','187','939','239792',4598421,'2760','418',602886.41,603605.87,0.00,0.00,719.46,552944.20,0.00,0.00,0.00),('1','187','939','239792',4598422,'2761','418',140084.31,142947.24,0.00,0.00,2862.93,1976045.70,0.00,0.00,0.00),('1','187','939','239792',4598423,'2762','418',101595.18,102830.30,0.00,0.00,1235.12,852232.80,0.00,0.00,0.00),('1','187','939','239792',4598424,'2763','418',89961.69,91255.34,0.00,0.00,1293.65,892618.50,0.00,0.00,0.00),('1','187','939','239792',4598425,'2764','418',67968.58,68198.58,0.00,0.00,230.00,158700.00,0.00,0.00,0.00),('1','187','939','239792',4598426,'2765','418',40427.32,40861.38,0.00,0.00,434.06,299501.40,0.00,0.00,0.00),('1','187','939','239793',4598427,'2760','418',603605.87,603836.36,0.00,0.00,230.49,177477.30,0.00,0.00,0.00),('1','187','939','239793',4598428,'2761','418',142947.24,143334.33,0.00,0.00,387.09,267092.10,0.00,0.00,0.00),('1','187','939','239793',4598429,'2762','418',102830.30,103535.11,0.00,0.00,704.81,486318.90,0.00,0.00,0.00),('1','187','939','239793',4598430,'2763','418',91255.34,91960.68,0.00,0.00,705.34,486684.60,0.00,0.00,0.00),('1','187','939','239793',4598431,'2764','418',68198.58,68373.58,0.00,0.00,175.00,120750.00,0.00,0.00,0.00),('1','187','939','239793',4598432,'2765','418',40861.38,41128.01,0.00,0.00,266.63,183974.70,0.00,0.00,0.00),('1','187','939','239794',4598433,'2760','418',603836.36,603947.69,0.00,0.00,111.33,85724.10,0.00,0.00,0.00),('1','187','939','239794',4598434,'2761','418',143334.33,143666.61,0.00,0.00,332.28,229273.20,0.00,0.00,0.00),('1','187','939','239794',4598435,'2762','418',103535.11,104135.11,0.00,0.00,600.00,414000.00,0.00,0.00,0.00),('1','187','939','239794',4598436,'2763','418',91960.68,92560.98,0.00,0.00,600.30,414207.00,0.00,0.00,0.00),('1','187','939','239794',4598437,'2764','418',68373.58,68523.58,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','187','939','239794',4598438,'2765','418',41128.01,41178.01,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239795',4598439,'2760','418',603947.69,604205.99,0.00,0.00,258.30,198891.00,0.00,0.00,0.00),('1','187','939','239795',4598440,'2761','418',143666.61,144574.43,0.00,0.00,907.82,626395.80,0.00,0.00,0.00),('1','187','939','239795',4598441,'2762','418',104135.11,105011.27,0.00,0.00,876.16,604550.40,0.00,0.00,0.00),('1','187','939','239795',4598442,'2763','418',92560.98,92860.98,0.00,0.00,300.00,207000.00,0.00,0.00,0.00),('1','187','939','239795',4598443,'2764','418',68523.58,68563.58,0.00,0.00,40.00,27600.00,0.00,0.00,0.00),('1','187','939','239795',4598444,'2765','418',41178.01,41228.01,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239796',4598445,'2760','418',604205.99,604304.99,0.00,0.00,99.00,76230.00,0.00,0.00,0.00),('1','187','939','239796',4598446,'2761','418',144574.43,145112.55,0.00,0.00,538.12,371302.80,0.00,0.00,0.00),('1','187','939','239796',4598447,'2762','418',105011.27,105273.27,0.00,0.00,262.00,180780.00,0.00,0.00,0.00),('1','187','939','239796',4598448,'2763','418',92860.98,93274.33,0.00,0.00,413.35,285211.50,0.00,0.00,0.00),('1','187','939','239796',4598449,'2764','418',68563.58,68763.91,0.00,0.00,200.33,138227.70,0.00,0.00,0.00),('1','187','939','239796',4598450,'2765','418',41228.01,41278.01,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239797',4598451,'2760','418',604304.99,604304.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239797',4598452,'2761','418',145112.55,145112.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239797',4598453,'2762','418',105273.27,105273.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239797',4598454,'2763','418',93274.33,93274.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239797',4598455,'2764','418',68763.91,68763.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239797',4598456,'2765','418',41278.01,41278.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239798',4598457,'2760','418',604304.99,604644.34,0.00,0.00,339.35,261299.50,0.00,0.00,0.00),('1','187','939','239798',4598458,'2761','418',145112.55,145612.55,0.00,0.00,500.00,345000.00,0.00,0.00,0.00),('1','187','939','239798',4598459,'2762','418',105273.27,105623.27,0.00,0.00,350.00,241500.00,0.00,0.00,0.00),('1','187','939','239798',4598460,'2763','418',93274.33,93385.33,0.00,0.00,111.00,76590.00,0.00,0.00,0.00),('1','187','939','239798',4598461,'2764','418',68763.91,68913.91,0.00,0.00,150.00,103500.00,0.00,0.00,0.00),('1','187','939','239798',4598462,'2765','418',41278.01,41378.01,0.00,0.00,100.00,69000.00,0.00,0.00,0.00),('1','187','939','239799',4598463,'2760','418',604644.34,605013.66,0.00,0.00,369.32,284376.40,0.00,0.00,0.00),('1','187','939','239799',4598464,'2761','418',145612.55,147085.55,0.00,0.00,1473.00,1016370.00,0.00,0.00,0.00),('1','187','939','239799',4598465,'2762','418',105623.27,106573.10,0.00,0.00,949.83,655382.70,0.00,0.00,0.00),('1','187','939','239799',4598466,'2763','418',93385.33,93755.34,0.00,0.00,370.01,255306.90,0.00,0.00,0.00),('1','187','939','239799',4598467,'2764','418',68913.91,69026.41,0.00,0.00,112.50,77625.00,0.00,0.00,0.00),('1','187','939','239799',4598468,'2765','418',41378.01,41428.01,0.00,0.00,50.00,34500.00,0.00,0.00,0.00),('1','187','939','239800',4598469,'2760','418',605013.66,605257.41,0.00,0.00,243.75,187687.50,0.00,0.00,0.00),('1','187','939','239800',4598470,'2761','418',147085.55,148429.34,0.00,0.00,1343.79,916777.20,0.00,0.00,0.00),('1','187','939','239800',4598471,'2762','418',106573.10,107805.23,0.00,0.00,1232.13,840473.40,0.00,0.00,0.00),('1','187','939','239800',4598472,'2763','418',93755.34,94657.76,0.00,0.00,902.42,615645.60,0.00,0.00,0.00),('1','187','939','239800',4598473,'2764','418',69026.41,69185.45,0.00,0.00,159.04,108147.20,0.00,0.00,0.00),('1','187','939','239800',4598474,'2765','418',41428.01,42017.22,0.00,0.00,589.21,400662.80,0.00,0.00,0.00),('1','187','939','239801',4598475,'2760','418',605257.41,605502.52,0.00,0.00,245.11,188734.70,0.00,0.00,0.00),('1','187','939','239801',4598476,'2761','418',148429.34,149312.34,0.00,0.00,883.00,600440.00,0.00,0.00,0.00),('1','187','939','239801',4598477,'2762','418',107805.23,108155.23,0.00,0.00,350.00,238000.00,0.00,0.00,0.00),('1','187','939','239801',4598478,'2763','418',94657.76,94907.76,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','187','939','239801',4598479,'2764','418',69185.45,69435.45,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','187','939','239801',4598480,'2765','418',42017.22,42117.12,0.00,0.00,99.90,67932.00,0.00,0.00,0.00),('1','187','939','239802',4598481,'2760','418',605502.52,605693.71,0.00,0.00,191.19,147216.30,0.00,0.00,0.00),('1','187','939','239802',4598482,'2761','418',149312.34,149367.82,0.00,0.00,55.48,37726.40,0.00,0.00,0.00),('1','187','939','239802',4598483,'2762','418',108155.23,108533.01,0.00,0.00,377.78,256890.40,0.00,0.00,0.00),('1','187','939','239802',4598484,'2763','418',94907.76,95044.76,0.00,0.00,137.00,93160.00,0.00,0.00,0.00),('1','187','939','239802',4598485,'2764','418',69435.45,69493.45,0.00,0.00,58.00,39440.00,0.00,0.00,0.00),('1','187','939','239802',4598486,'2765','418',42117.12,42117.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239803',4598487,'2760','418',605693.71,605904.38,0.00,0.00,210.67,162215.90,0.00,0.00,0.00),('1','187','939','239803',4598488,'2761','418',149367.82,149649.76,0.00,0.00,281.94,191719.20,0.00,0.00,0.00),('1','187','939','239803',4598489,'2762','418',108533.01,109163.01,0.00,0.00,630.00,428400.00,0.00,0.00,0.00),('1','187','939','239803',4598490,'2763','418',95044.76,95619.76,0.00,0.00,575.00,391000.00,0.00,0.00,0.00),('1','187','939','239803',4598491,'2764','418',69493.45,69936.45,0.00,0.00,443.00,301240.00,0.00,0.00,0.00),('1','187','939','239803',4598492,'2765','418',42117.12,42167.12,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','187','939','239804',4598493,'2760','418',605904.38,606088.82,0.00,0.00,184.44,142018.80,0.00,0.00,0.00),('1','187','939','239804',4598494,'2761','418',149649.76,150006.93,0.00,0.00,357.17,243004.30,0.00,0.00,0.00),('1','187','939','239804',4598495,'2762','418',109163.01,109820.12,0.00,0.00,657.11,446834.80,0.00,0.00,0.00),('1','187','939','239804',4598496,'2763','418',95619.76,96019.75,0.00,0.00,399.99,271993.20,0.00,0.00,0.00),('1','187','939','239804',4598497,'2764','418',69936.45,70186.45,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','187','939','239804',4598498,'2765','418',42167.12,42517.08,0.00,0.00,349.96,237972.80,0.00,0.00,0.00),('1','187','939','239805',4598499,'2760','418',606088.82,606326.90,0.00,0.00,238.08,183321.60,0.00,0.00,0.00),('1','187','939','239805',4598500,'2761','418',150006.93,150471.53,0.00,0.00,464.60,315928.00,0.00,0.00,0.00),('1','187','939','239805',4598501,'2762','418',109820.12,110385.98,0.00,0.00,565.86,384784.80,0.00,0.00,0.00),('1','187','939','239805',4598502,'2763','418',96019.75,96477.75,0.00,0.00,458.00,311440.00,0.00,0.00,0.00),('1','187','939','239805',4598503,'2764','418',70186.45,70431.45,0.00,0.00,245.00,166600.00,0.00,0.00,0.00),('1','187','939','239805',4598504,'2765','418',42517.08,42617.08,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','187','939','239806',4598505,'2760','418',606326.90,606544.47,0.00,0.00,217.57,167528.90,0.00,0.00,0.00),('1','187','939','239806',4598506,'2761','418',150471.53,151606.68,0.00,0.00,1135.15,771902.00,0.00,0.00,0.00),('1','187','939','239806',4598507,'2762','418',110385.98,111178.98,0.00,0.00,793.00,539240.00,0.00,0.00,0.00),('1','187','939','239806',4598508,'2763','418',96477.75,97039.56,0.00,0.00,561.81,382030.80,0.00,0.00,0.00),('1','187','939','239806',4598509,'2764','418',70431.45,70843.45,0.00,0.00,412.00,280160.00,0.00,0.00,0.00),('1','187','939','239806',4598510,'2765','418',42617.08,42717.08,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','187','939','239807',4598511,'2760','418',606544.47,606755.79,0.00,0.00,211.32,162716.40,0.00,0.00,0.00),('1','187','939','239807',4598512,'2761','418',151606.68,151760.44,0.00,0.00,153.76,104556.80,0.00,0.00,0.00),('1','187','939','239807',4598513,'2762','418',111178.98,111519.40,0.00,0.00,340.42,231485.60,0.00,0.00,0.00),('1','187','939','239807',4598514,'2763','418',97039.56,97354.55,0.00,0.00,314.99,214193.20,0.00,0.00,0.00),('1','187','939','239807',4598515,'2764','418',70843.45,70943.45,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','187','939','239807',4598516,'2765','418',42717.08,42867.10,0.00,0.00,150.02,102013.60,0.00,0.00,0.00),('1','187','939','239808',4598517,'2760','418',606755.79,606969.63,0.00,0.00,213.84,164656.80,0.00,0.00,0.00),('1','187','939','239808',4598518,'2761','418',151760.44,152116.04,0.00,0.00,355.60,241808.00,0.00,0.00,0.00),('1','187','939','239808',4598519,'2762','418',111519.40,111819.40,0.00,0.00,300.00,204000.00,0.00,0.00,0.00),('1','187','939','239808',4598520,'2763','418',97354.55,97604.55,0.00,0.00,250.00,170000.00,0.00,0.00,0.00),('1','187','939','239808',4598521,'2764','418',70943.45,71102.01,0.00,0.00,158.56,107820.80,0.00,0.00,0.00),('1','187','939','239808',4598522,'2765','418',42867.10,42960.72,0.00,0.00,93.62,63661.60,0.00,0.00,0.00),('1','187','939','239809',4598523,'2760','418',606969.63,606969.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239809',4598524,'2761','418',152116.04,152116.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239809',4598525,'2762','418',111819.40,111819.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239809',4598526,'2763','418',97604.55,97604.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239809',4598527,'2764','418',71102.01,71102.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239809',4598528,'2765','418',42960.72,42960.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239810',4598529,'2760','418',606969.63,607076.37,0.00,0.00,106.74,82189.80,0.00,0.00,0.00),('1','187','939','239810',4598530,'2761','418',152116.04,152583.04,0.00,0.00,467.00,317560.00,0.00,0.00,0.00),('1','187','939','239810',4598531,'2762','418',111819.40,112091.40,0.00,0.00,272.00,184960.00,0.00,0.00,0.00),('1','187','939','239810',4598532,'2763','418',97604.55,97654.55,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','187','939','239810',4598533,'2764','418',71102.01,71152.01,0.00,0.00,50.00,34000.00,0.00,0.00,0.00),('1','187','939','239810',4598534,'2765','418',42960.72,43088.63,0.00,0.00,127.91,86978.80,0.00,0.00,0.00),('1','187','939','239811',4598535,'2760','418',607076.37,607313.01,0.00,0.00,236.64,182212.80,0.00,0.00,0.00),('1','187','939','239811',4598536,'2761','418',152583.04,153526.01,0.00,0.00,942.97,641219.60,0.00,0.00,0.00),('1','187','939','239811',4598537,'2762','418',112091.40,112841.40,0.00,0.00,750.00,510000.00,0.00,0.00,0.00),('1','187','939','239811',4598538,'2763','418',97654.55,98098.10,0.00,0.00,443.55,301614.00,0.00,0.00,0.00),('1','187','939','239811',4598539,'2764','418',71152.01,71352.22,0.00,0.00,200.21,136142.80,0.00,0.00,0.00),('1','187','939','239811',4598540,'2765','418',43088.63,43188.63,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','187','939','239812',4598541,'2760','418',607313.01,607667.08,0.00,0.00,354.07,272633.90,0.00,0.00,0.00),('1','187','939','239812',4598542,'2761','418',153526.01,154172.51,0.00,0.00,646.50,439620.00,0.00,0.00,0.00),('1','187','939','239812',4598543,'2762','418',112841.40,113234.40,0.00,0.00,393.00,267240.00,0.00,0.00,0.00),('1','187','939','239812',4598544,'2763','418',98098.10,98253.10,0.00,0.00,155.00,105400.00,0.00,0.00,0.00),('1','187','939','239812',4598545,'2764','418',71352.22,71452.22,0.00,0.00,100.00,68000.00,0.00,0.00,0.00),('1','187','939','239812',4598546,'2765','418',43188.63,43188.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239813',4598547,'2760','418',607667.08,607979.27,0.00,0.00,312.19,240386.30,0.00,0.00,0.00),('1','187','939','239813',4598548,'2761','418',154172.51,154907.20,0.00,0.00,734.69,492103.54,0.00,0.00,0.00),('1','187','939','239813',4598549,'2762','418',113234.40,113834.40,0.00,0.00,600.00,401700.00,0.00,0.00,0.00),('1','187','939','239813',4598550,'2763','418',98253.10,98553.10,0.00,0.00,300.00,201900.00,0.00,0.00,0.00),('1','187','939','239813',4598551,'2764','418',71452.22,71732.22,0.00,0.00,280.00,186480.00,0.00,0.00,0.00),('1','187','939','239813',4598552,'2765','418',43188.63,43251.13,0.00,0.00,62.50,41625.00,0.00,0.00,0.00),('1','187','939','239814',4598553,'2760','418',607979.27,608293.26,0.00,0.00,313.99,227911.30,0.00,0.00,0.00),('1','187','939','239814',4598554,'2761','418',154907.20,155475.52,0.00,0.00,568.32,378501.12,0.00,0.00,0.00),('1','187','939','239814',4598555,'2762','418',113834.40,114112.40,0.00,0.00,278.00,185148.00,0.00,0.00,0.00),('1','187','939','239814',4598556,'2763','418',98553.10,98898.10,0.00,0.00,345.00,229770.00,0.00,0.00,0.00),('1','187','939','239814',4598557,'2764','418',71732.22,71932.22,0.00,0.00,200.00,133200.00,0.00,0.00,0.00),('1','187','939','239814',4598558,'2765','418',43251.13,43251.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239815',4598559,'2760','418',608293.26,608530.39,0.00,0.00,237.13,170733.60,0.00,0.00,0.00),('1','187','939','239815',4598560,'2761','418',155475.52,155900.52,0.00,0.00,425.00,283050.00,0.00,0.00,0.00),('1','187','939','239815',4598561,'2762','418',114112.40,114403.15,0.00,0.00,290.75,193639.50,0.00,0.00,0.00),('1','187','939','239815',4598562,'2763','418',98898.10,99048.10,0.00,0.00,150.00,99900.00,0.00,0.00,0.00),('1','187','939','239815',4598563,'2764','418',71932.22,72022.22,0.00,0.00,90.00,59940.00,0.00,0.00,0.00),('1','187','939','239815',4598564,'2765','418',43251.13,43259.87,0.00,0.00,8.74,5820.84,0.00,0.00,0.00),('1','187','939','239816',4598565,'2760','418',608530.39,608952.04,0.00,0.00,421.65,303588.00,0.00,0.00,0.00),('1','187','939','239816',4598566,'2761','418',155900.52,156827.52,0.00,0.00,927.00,617382.00,0.00,0.00,0.00),('1','187','939','239816',4598567,'2762','418',114403.15,115094.91,0.00,0.00,691.76,460712.16,0.00,0.00,0.00),('1','187','939','239816',4598568,'2763','418',99048.10,99573.10,0.00,0.00,525.00,349650.00,0.00,0.00,0.00),('1','187','939','239816',4598569,'2764','418',72022.22,72332.22,0.00,0.00,310.00,206460.00,0.00,0.00,0.00),('1','187','939','239816',4598570,'2765','418',43259.87,43424.87,0.00,0.00,165.00,109890.00,0.00,0.00,0.00),('1','187','939','239817',4598571,'2760','418',608952.04,609202.23,0.00,0.00,250.19,180136.80,0.00,0.00,0.00),('1','187','939','239817',4598572,'2761','418',156827.52,157463.44,0.00,0.00,635.92,423522.72,0.00,0.00,0.00),('1','187','939','239817',4598573,'2762','418',115094.91,115483.99,0.00,0.00,389.08,259127.28,0.00,0.00,0.00),('1','187','939','239817',4598574,'2763','418',99573.10,100033.10,0.00,0.00,460.00,306360.00,0.00,0.00,0.00),('1','187','939','239817',4598575,'2764','418',72332.22,72666.22,0.00,0.00,334.00,222444.00,0.00,0.00,0.00),('1','187','939','239817',4598576,'2765','418',43424.87,43574.87,0.00,0.00,150.00,99900.00,0.00,0.00,0.00),('1','187','939','239818',4598577,'2760','418',609202.23,609570.64,0.00,0.00,368.41,265255.20,0.00,0.00,0.00),('1','187','939','239818',4598578,'2761','418',157463.44,158426.44,0.00,0.00,963.00,641358.00,0.00,0.00,0.00),('1','187','939','239818',4598579,'2762','418',115483.99,116386.53,0.00,0.00,902.54,601091.64,0.00,0.00,0.00),('1','187','939','239818',4598580,'2763','418',100033.10,100918.30,0.00,0.00,885.20,589543.20,0.00,0.00,0.00),('1','187','939','239818',4598581,'2764','418',72666.22,73297.22,0.00,0.00,631.00,420246.00,0.00,0.00,0.00),('1','187','939','239818',4598582,'2765','418',43574.87,43734.87,0.00,0.00,160.00,106560.00,0.00,0.00,0.00),('1','187','939','239819',4598583,'2760','418',609570.64,609927.41,0.00,0.00,356.77,256874.40,0.00,0.00,0.00),('1','187','939','239819',4598584,'2761','418',158426.44,160422.44,0.00,0.00,1996.00,1329336.00,0.00,0.00,0.00),('1','187','939','239819',4598585,'2762','418',116386.53,117251.46,0.00,0.00,864.93,576043.38,0.00,0.00,0.00),('1','187','939','239819',4598586,'2763','418',100918.30,101853.30,0.00,0.00,935.00,622710.00,0.00,0.00,0.00),('1','187','939','239819',4598587,'2764','418',73297.22,73627.22,0.00,0.00,330.00,219780.00,0.00,0.00,0.00),('1','187','939','239819',4598588,'2765','418',43734.87,44004.87,0.00,0.00,270.00,179820.00,0.00,0.00,0.00),('1','187','939','239820',4598589,'2760','418',609927.41,609927.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239820',4598590,'2761','418',160422.44,160422.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239820',4598591,'2762','418',117251.46,117251.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239820',4598592,'2763','418',101853.30,101853.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239820',4598593,'2764','418',73627.22,73627.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239820',4598594,'2765','418',44004.87,44004.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239821',4598595,'2760','418',609927.41,610285.98,0.00,0.00,358.57,258170.40,0.00,0.00,0.00),('1','187','939','239821',4598596,'2761','418',160422.44,161437.44,0.00,0.00,1015.00,675990.00,0.00,0.00,0.00),('1','187','939','239821',4598597,'2762','418',117251.46,118101.46,0.00,0.00,850.00,566100.00,0.00,0.00,0.00),('1','187','939','239821',4598598,'2763','418',101853.30,102553.30,0.00,0.00,700.00,466200.00,0.00,0.00,0.00),('1','187','939','239821',4598599,'2764','418',73627.22,74057.22,0.00,0.00,430.00,286380.00,0.00,0.00,0.00),('1','187','939','239821',4598600,'2765','418',44004.87,44569.92,0.00,0.00,565.05,376323.30,0.00,0.00,0.00),('1','187','939','239822',4598601,'2760','418',610285.98,610771.42,0.00,0.00,485.44,349516.80,0.00,0.00,0.00),('1','187','939','239822',4598602,'2761','418',161437.44,162917.44,0.00,0.00,1480.00,985680.00,0.00,0.00,0.00),('1','187','939','239822',4598603,'2762','418',118101.46,118708.46,0.00,0.00,607.00,404262.00,0.00,0.00,0.00),('1','187','939','239822',4598604,'2763','418',102553.30,103403.30,0.00,0.00,850.00,566100.00,0.00,0.00,0.00),('1','187','939','239822',4598605,'2764','418',74057.22,74752.22,0.00,0.00,695.00,462870.00,0.00,0.00,0.00),('1','187','939','239822',4598606,'2765','418',44569.92,45319.92,0.00,0.00,750.00,499500.00,0.00,0.00,0.00),('1','187','939','239823',4598607,'2760','418',610771.42,611221.00,0.00,0.00,449.58,323697.60,0.00,0.00,0.00),('1','187','939','239823',4598608,'2761','418',162917.44,164515.44,0.00,0.00,1598.00,1064268.00,0.00,0.00,0.00),('1','187','939','239823',4598609,'2762','418',118708.46,119518.46,0.00,0.00,810.00,539460.00,0.00,0.00,0.00),('1','187','939','239823',4598610,'2763','418',103403.30,104537.30,0.00,0.00,1134.00,755244.00,0.00,0.00,0.00),('1','187','939','239823',4598611,'2764','418',74752.22,75298.22,0.00,0.00,546.00,363636.00,0.00,0.00,0.00),('1','187','939','239823',4598612,'2765','418',45319.92,45781.92,0.00,0.00,462.00,307692.00,0.00,0.00,0.00),('1','187','939','239824',4598613,'2760','418',611221.00,611556.21,0.00,0.00,335.21,241351.20,0.00,0.00,0.00),('1','187','939','239824',4598614,'2761','418',164515.44,166345.44,0.00,0.00,1830.00,1218780.00,0.00,0.00,0.00),('1','187','939','239824',4598615,'2762','418',119518.46,120838.46,0.00,0.00,1320.00,879120.00,0.00,0.00,0.00),('1','187','939','239824',4598616,'2763','418',104537.30,105710.80,0.00,0.00,1173.50,781551.00,0.00,0.00,0.00),('1','187','939','239824',4598617,'2764','418',75298.22,75914.99,0.00,0.00,616.77,410768.82,0.00,0.00,0.00),('1','187','939','239824',4598618,'2765','418',45781.92,46521.92,0.00,0.00,740.00,492840.00,0.00,0.00,0.00),('1','187','939','239825',4598619,'2760','418',611556.21,611922.60,0.00,0.00,366.39,263800.80,0.00,0.00,0.00),('1','187','939','239825',4598620,'2761','418',166345.44,167295.53,0.00,0.00,950.09,632759.94,0.00,0.00,0.00),('1','187','939','239825',4598621,'2762','418',120838.46,121328.46,0.00,0.00,490.00,326340.00,0.00,0.00,0.00),('1','187','939','239825',4598622,'2763','418',105710.80,106246.88,0.00,0.00,536.08,357029.28,0.00,0.00,0.00),('1','187','939','239825',4598623,'2764','418',75914.99,76502.99,0.00,0.00,588.00,391608.00,0.00,0.00,0.00),('1','187','939','239825',4598624,'2765','418',46521.92,46871.92,0.00,0.00,350.00,233100.00,0.00,0.00,0.00),('1','187','939','239826',4598625,'2760','418',611922.60,611986.74,0.00,0.00,64.14,46180.80,0.00,0.00,0.00),('1','187','939','239826',4598626,'2761','418',167295.53,167859.36,0.00,0.00,563.83,375510.78,0.00,0.00,0.00),('1','187','939','239826',4598627,'2762','418',121328.46,121494.46,0.00,0.00,166.00,110556.00,0.00,0.00,0.00),('1','187','939','239826',4598628,'2763','418',106246.88,106511.63,0.00,0.00,264.75,176323.50,0.00,0.00,0.00),('1','187','939','239826',4598629,'2764','418',76502.99,76752.99,0.00,0.00,250.00,166500.00,0.00,0.00,0.00),('1','187','939','239826',4598630,'2765','418',46871.92,46916.92,0.00,0.00,45.00,29970.00,0.00,0.00,0.00),('1','187','939','239827',4598631,'2760','418',611986.74,611986.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239827',4598632,'2761','418',167859.36,167909.36,0.00,0.00,50.00,33300.00,0.00,0.00,0.00),('1','187','939','239827',4598633,'2762','418',121494.46,121544.46,0.00,0.00,50.00,33300.00,0.00,0.00,0.00),('1','187','939','239827',4598634,'2763','418',106511.63,106511.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239827',4598635,'2764','418',76752.99,76802.99,0.00,0.00,50.00,33300.00,0.00,0.00,0.00),('1','187','939','239827',4598636,'2765','418',46916.92,46916.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239828',4598637,'2760','418',611986.74,611986.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239828',4598638,'2761','418',167909.36,167909.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239828',4598639,'2762','418',121544.46,121544.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239828',4598640,'2763','418',106511.63,106511.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239828',4598641,'2764','418',76802.99,76802.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239828',4598642,'2765','418',46916.92,46916.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239829',4598643,'2760','418',611986.74,612346.79,0.00,0.00,360.05,259236.00,0.00,0.00,0.00),('1','187','939','239829',4598644,'2761','418',167909.36,169726.44,0.00,0.00,1817.08,1217547.60,0.00,0.00,0.00),('1','187','939','239829',4598645,'2762','418',121544.46,122785.84,0.00,0.00,1241.38,831724.60,0.00,0.00,0.00),('1','187','939','239829',4598646,'2763','418',106511.63,107461.63,0.00,0.00,950.00,636500.00,0.00,0.00,0.00),('1','187','939','239829',4598647,'2764','418',76802.99,77548.50,0.00,0.00,745.51,499491.70,0.00,0.00,0.00),('1','187','939','239829',4598648,'2765','418',46916.92,47546.92,0.00,0.00,630.00,422100.00,0.00,0.00,0.00),('1','187','939','239830',4598649,'2760','418',612346.79,612707.95,0.00,0.00,361.16,260035.20,0.00,0.00,0.00),('1','187','939','239830',4598650,'2761','418',169726.44,171684.44,0.00,0.00,1958.00,1311860.00,0.00,0.00,0.00),('1','187','939','239830',4598651,'2762','418',122785.84,123636.28,0.00,0.00,850.44,569794.80,0.00,0.00,0.00),('1','187','939','239830',4598652,'2763','418',107461.63,107861.78,0.00,0.00,400.15,268100.50,0.00,0.00,0.00),('1','187','939','239830',4598653,'2764','418',77548.50,77974.02,0.00,0.00,425.52,285098.40,0.00,0.00,0.00),('1','187','939','239830',4598654,'2765','418',47546.92,48021.92,0.00,0.00,475.00,318250.00,0.00,0.00,0.00),('1','187','939','239831',4598655,'2760','418',612707.95,613142.72,0.00,0.00,434.77,313034.40,0.00,0.00,0.00),('1','187','939','239831',4598656,'2761','418',171684.44,173203.64,0.00,0.00,1519.20,1017864.00,0.00,0.00,0.00),('1','187','939','239831',4598657,'2762','418',123636.28,124083.78,0.00,0.00,447.50,299825.00,0.00,0.00,0.00),('1','187','939','239831',4598658,'2763','418',107861.78,108311.78,0.00,0.00,450.00,301500.00,0.00,0.00,0.00),('1','187','939','239831',4598659,'2764','418',77974.02,78574.02,0.00,0.00,600.00,402000.00,0.00,0.00,0.00),('1','187','939','239831',4598660,'2765','418',48021.92,48121.92,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','187','939','239832',4598661,'2760','418',613142.72,613526.95,0.00,0.00,384.23,276645.60,0.00,0.00,0.00),('1','187','939','239832',4598662,'2761','418',173203.64,173821.14,0.00,0.00,617.50,413725.00,0.00,0.00,0.00),('1','187','939','239832',4598663,'2762','418',124083.78,124283.78,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239832',4598664,'2763','418',108311.78,109079.78,0.00,0.00,768.00,514560.00,0.00,0.00,0.00),('1','187','939','239832',4598665,'2764','418',78574.02,79563.02,0.00,0.00,989.00,662630.00,0.00,0.00,0.00),('1','187','939','239832',4598666,'2765','418',48121.92,48421.92,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','187','939','239833',4598667,'2760','418',613526.95,613733.47,0.00,0.00,206.52,148694.40,0.00,0.00,0.00),('1','187','939','239833',4598668,'2761','418',173821.14,174478.14,0.00,0.00,657.00,440190.00,0.00,0.00,0.00),('1','187','939','239833',4598669,'2762','418',124283.78,124807.78,0.00,0.00,524.00,351080.00,0.00,0.00,0.00),('1','187','939','239833',4598670,'2763','418',109079.78,109225.78,0.00,0.00,146.00,97820.00,0.00,0.00,0.00),('1','187','939','239833',4598671,'2764','418',79563.02,79777.02,0.00,0.00,214.00,143380.00,0.00,0.00,0.00),('1','187','939','239833',4598672,'2765','418',48421.92,48716.92,0.00,0.00,295.00,197650.00,0.00,0.00,0.00),('1','187','939','239834',4598673,'2760','418',613733.47,614175.81,0.00,0.00,442.34,318484.80,0.00,0.00,0.00),('1','187','939','239834',4598674,'2761','418',174478.14,175326.19,0.00,0.00,848.05,568193.50,0.00,0.00,0.00),('1','187','939','239834',4598675,'2762','418',124807.78,125307.28,0.00,0.00,499.50,334665.00,0.00,0.00,0.00),('1','187','939','239834',4598676,'2763','418',109225.78,109775.78,0.00,0.00,550.00,368500.00,0.00,0.00,0.00),('1','187','939','239834',4598677,'2764','418',79777.02,80393.02,0.00,0.00,616.00,412720.00,0.00,0.00,0.00),('1','187','939','239834',4598678,'2765','418',48716.92,49166.92,0.00,0.00,450.00,301500.00,0.00,0.00,0.00),('1','187','939','239835',4598679,'2760','418',614175.81,614608.11,0.00,0.00,432.30,311256.00,0.00,0.00,0.00),('1','187','939','239835',4598680,'2761','418',175326.19,175470.19,0.00,0.00,144.00,96480.00,0.00,0.00,0.00),('1','187','939','239835',4598681,'2762','418',125307.28,125357.28,0.00,0.00,50.00,33500.00,0.00,0.00,0.00),('1','187','939','239835',4598682,'2763','418',109775.78,109840.78,0.00,0.00,65.00,43550.00,0.00,0.00,0.00),('1','187','939','239835',4598683,'2764','418',80393.02,80443.02,0.00,0.00,50.00,33500.00,0.00,0.00,0.00),('1','187','939','239835',4598684,'2765','418',49166.92,49166.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239836',4598685,'2760','418',614608.11,614726.76,0.00,0.00,118.65,85428.00,0.00,0.00,0.00),('1','187','939','239836',4598686,'2761','418',175470.19,175861.19,0.00,0.00,391.00,261970.00,0.00,0.00,0.00),('1','187','939','239836',4598687,'2762','418',125357.28,125727.28,0.00,0.00,370.00,247900.00,0.00,0.00,0.00),('1','187','939','239836',4598688,'2763','418',109840.78,110040.78,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239836',4598689,'2764','418',80443.02,80473.02,0.00,0.00,30.00,20100.00,0.00,0.00,0.00),('1','187','939','239836',4598690,'2765','418',49166.92,49201.92,0.00,0.00,35.00,23450.00,0.00,0.00,0.00),('1','187','939','239837',4598691,'2760','418',614726.76,614726.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239837',4598692,'2761','418',175861.19,175861.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239837',4598693,'2762','418',125727.28,125727.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239837',4598694,'2763','418',110040.78,110040.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239837',4598695,'2764','418',80473.02,80473.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239837',4598696,'2765','418',49201.92,49201.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239838',4598697,'2760','418',614726.76,615015.95,0.00,0.00,289.19,208216.80,0.00,0.00,0.00),('1','187','939','239838',4598698,'2761','418',175861.19,176011.19,0.00,0.00,150.00,100500.00,0.00,0.00,0.00),('1','187','939','239838',4598699,'2762','418',125727.28,125877.28,0.00,0.00,150.00,100500.00,0.00,0.00,0.00),('1','187','939','239838',4598700,'2763','418',110040.78,110078.78,0.00,0.00,38.00,25460.00,0.00,0.00,0.00),('1','187','939','239838',4598701,'2764','418',80473.02,80523.02,0.00,0.00,50.00,33500.00,0.00,0.00,0.00),('1','187','939','239838',4598702,'2765','418',49201.92,49201.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239839',4598703,'2760','418',615015.95,615412.29,0.00,0.00,396.34,285364.80,0.00,0.00,0.00),('1','187','939','239839',4598704,'2761','418',176011.19,176931.19,0.00,0.00,920.00,616400.00,0.00,0.00,0.00),('1','187','939','239839',4598705,'2762','418',125877.28,126290.98,0.00,0.00,413.70,277179.00,0.00,0.00,0.00),('1','187','939','239839',4598706,'2763','418',110078.78,110241.28,0.00,0.00,162.50,108875.00,0.00,0.00,0.00),('1','187','939','239839',4598707,'2764','418',80523.02,80850.02,0.00,0.00,327.00,219090.00,0.00,0.00,0.00),('1','187','939','239839',4598708,'2765','418',49201.92,49451.92,0.00,0.00,250.00,167500.00,0.00,0.00,0.00),('1','187','939','239840',4598709,'2760','418',615412.29,615799.26,0.00,0.00,386.97,278618.40,0.00,0.00,0.00),('1','187','939','239840',4598710,'2761','418',176931.19,178243.69,0.00,0.00,1312.50,879375.00,0.00,0.00,0.00),('1','187','939','239840',4598711,'2762','418',126290.98,127290.98,0.00,0.00,1000.00,670000.00,0.00,0.00,0.00),('1','187','939','239840',4598712,'2763','418',110241.28,110569.28,0.00,0.00,328.00,219760.00,0.00,0.00,0.00),('1','187','939','239840',4598713,'2764','418',80850.02,81050.02,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239840',4598714,'2765','418',49451.92,49651.92,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239841',4598715,'2760','418',615799.26,616097.97,0.00,0.00,298.71,215071.20,0.00,0.00,0.00),('1','187','939','239841',4598716,'2761','418',178243.69,179543.69,0.00,0.00,1300.00,871000.00,0.00,0.00,0.00),('1','187','939','239841',4598717,'2762','418',127290.98,128573.98,0.00,0.00,1283.00,859610.00,0.00,0.00,0.00),('1','187','939','239841',4598718,'2763','418',110569.28,110978.28,0.00,0.00,409.00,274030.00,0.00,0.00,0.00),('1','187','939','239841',4598719,'2764','418',81050.02,81553.10,0.00,0.00,503.08,337063.60,0.00,0.00,0.00),('1','187','939','239841',4598720,'2765','418',49651.92,49851.92,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239842',4598721,'2760','418',616097.97,616339.82,0.00,0.00,241.85,174132.00,0.00,0.00,0.00),('1','187','939','239842',4598722,'2761','418',179543.69,179999.12,0.00,0.00,455.43,305138.10,0.00,0.00,0.00),('1','187','939','239842',4598723,'2762','418',128573.98,128986.98,0.00,0.00,413.00,276710.00,0.00,0.00,0.00),('1','187','939','239842',4598724,'2763','418',110978.28,111228.28,0.00,0.00,250.00,167500.00,0.00,0.00,0.00),('1','187','939','239842',4598725,'2764','418',81553.10,81553.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239842',4598726,'2765','418',49851.92,49851.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239843',4598727,'2760','418',616339.82,616648.39,0.00,0.00,308.57,222170.40,0.00,0.00,0.00),('1','187','939','239843',4598728,'2761','418',179999.12,182096.51,0.00,0.00,2097.39,1405251.30,0.00,0.00,0.00),('1','187','939','239843',4598729,'2762','418',128986.98,130362.45,0.00,0.00,1375.47,921564.90,0.00,0.00,0.00),('1','187','939','239843',4598730,'2763','418',111228.28,111626.16,0.00,0.00,397.88,266579.60,0.00,0.00,0.00),('1','187','939','239843',4598731,'2764','418',81553.10,81843.97,0.00,0.00,290.87,194882.90,0.00,0.00,0.00),('1','187','939','239843',4598732,'2765','418',49851.92,50067.03,0.00,0.00,215.11,144123.70,0.00,0.00,0.00),('1','187','939','239844',4598733,'2760','418',616648.39,617011.99,0.00,0.00,363.60,261792.00,0.00,0.00,0.00),('1','187','939','239844',4598734,'2761','418',182096.51,183234.71,0.00,0.00,1138.20,762594.00,0.00,0.00,0.00),('1','187','939','239844',4598735,'2762','418',130362.45,130960.45,0.00,0.00,598.00,400660.00,0.00,0.00,0.00),('1','187','939','239844',4598736,'2763','418',111626.16,111784.16,0.00,0.00,158.00,105860.00,0.00,0.00,0.00),('1','187','939','239844',4598737,'2764','418',81843.97,82041.97,0.00,0.00,198.00,132660.00,0.00,0.00,0.00),('1','187','939','239844',4598738,'2765','418',50067.03,50067.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239845',4598739,'2760','418',617011.99,617265.74,0.00,0.00,253.75,182700.00,0.00,0.00,0.00),('1','187','939','239845',4598740,'2761','418',183234.71,183999.94,0.00,0.00,765.23,512704.10,0.00,0.00,0.00),('1','187','939','239845',4598741,'2762','418',130960.45,131335.45,0.00,0.00,375.00,251250.00,0.00,0.00,0.00),('1','187','939','239845',4598742,'2763','418',111784.16,112120.16,0.00,0.00,336.00,225120.00,0.00,0.00,0.00),('1','187','939','239845',4598743,'2764','418',82041.97,82311.97,0.00,0.00,270.00,180900.00,0.00,0.00,0.00),('1','187','939','239845',4598744,'2765','418',50067.03,50083.45,0.00,0.00,16.42,11001.40,0.00,0.00,0.00),('1','187','939','239846',4598745,'2760','418',617265.74,617552.26,0.00,0.00,286.52,206294.40,0.00,0.00,0.00),('1','187','939','239846',4598746,'2761','418',183999.94,184810.94,0.00,0.00,811.00,543370.00,0.00,0.00,0.00),('1','187','939','239846',4598747,'2762','418',131335.45,132085.45,0.00,0.00,750.00,502500.00,0.00,0.00,0.00),('1','187','939','239846',4598748,'2763','418',112120.16,112560.16,0.00,0.00,440.00,294800.00,0.00,0.00,0.00),('1','187','939','239846',4598749,'2764','418',82311.97,82511.97,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239846',4598750,'2765','418',50083.45,50183.45,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','187','939','239847',4598751,'2760','418',617552.26,617742.75,0.00,0.00,190.49,137152.80,0.00,0.00,0.00),('1','187','939','239847',4598752,'2761','418',184810.94,185126.81,0.00,0.00,315.87,211632.90,0.00,0.00,0.00),('1','187','939','239847',4598753,'2762','418',132085.45,132259.55,0.00,0.00,174.10,116647.00,0.00,0.00,0.00),('1','187','939','239847',4598754,'2763','418',112560.16,112710.16,0.00,0.00,150.00,100500.00,0.00,0.00,0.00),('1','187','939','239847',4598755,'2764','418',82511.97,82511.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239847',4598756,'2765','418',50183.45,50283.45,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','187','939','239848',4598757,'2760','418',617742.75,617742.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239848',4598758,'2761','418',185126.81,185126.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239848',4598759,'2762','418',132259.55,132259.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239848',4598760,'2763','418',112710.16,112710.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239848',4598761,'2764','418',82511.97,82511.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239848',4598762,'2765','418',50283.45,50283.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239849',4598763,'2760','418',617742.75,617978.51,0.00,0.00,235.76,169747.20,0.00,0.00,0.00),('1','187','939','239849',4598764,'2761','418',185126.81,186396.79,0.00,0.00,1269.98,850886.60,0.00,0.00,0.00),('1','187','939','239849',4598765,'2762','418',132259.55,133054.38,0.00,0.00,794.83,532536.10,0.00,0.00,0.00),('1','187','939','239849',4598766,'2763','418',112710.16,113230.16,0.00,0.00,520.00,348400.00,0.00,0.00,0.00),('1','187','939','239849',4598767,'2764','418',82511.97,82811.97,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','187','939','239849',4598768,'2765','418',50283.45,50572.35,0.00,0.00,288.90,193563.00,0.00,0.00,0.00),('1','187','939','239850',4598769,'2760','418',617978.51,618228.60,0.00,0.00,250.09,180064.80,0.00,0.00,0.00),('1','187','939','239850',4598770,'2761','418',186396.79,187472.05,0.00,0.00,1075.26,720424.20,0.00,0.00,0.00),('1','187','939','239850',4598771,'2762','418',133054.38,133751.79,0.00,0.00,697.41,467264.70,0.00,0.00,0.00),('1','187','939','239850',4598772,'2763','418',113230.16,113880.16,0.00,0.00,650.00,435500.00,0.00,0.00,0.00),('1','187','939','239850',4598773,'2764','418',82811.97,83175.97,0.00,0.00,364.00,243880.00,0.00,0.00,0.00),('1','187','939','239850',4598774,'2765','418',50572.35,50941.35,0.00,0.00,369.00,247230.00,0.00,0.00,0.00),('1','187','939','239851',4598775,'2760','418',618228.60,618628.01,0.00,0.00,399.41,287575.20,0.00,0.00,0.00),('1','187','939','239851',4598776,'2761','418',187472.05,189071.19,0.00,0.00,1599.14,1067893.10,0.00,0.00,0.00),('1','187','939','239851',4598777,'2762','418',133751.79,134679.79,0.00,0.00,928.00,619010.00,0.00,0.00,0.00),('1','187','939','239851',4598778,'2763','418',113880.16,114738.16,0.00,0.00,858.00,572360.00,0.00,0.00,0.00),('1','187','939','239851',4598779,'2764','418',83175.97,83920.47,0.00,0.00,744.50,496565.00,0.00,0.00,0.00),('1','187','939','239851',4598780,'2765','418',50941.35,52041.35,0.00,0.00,1100.00,732525.00,0.00,0.00,0.00),('1','187','939','239852',4598781,'2760','418',618628.01,618946.28,0.00,0.00,318.27,229154.40,0.00,0.00,0.00),('1','187','939','239852',4598782,'2761','418',189071.19,189671.19,0.00,0.00,600.00,402000.00,0.00,0.00,0.00),('1','187','939','239852',4598783,'2762','418',134679.79,135350.67,0.00,0.00,670.88,449489.60,0.00,0.00,0.00),('1','187','939','239852',4598784,'2763','418',114738.16,115254.83,0.00,0.00,516.67,346168.90,0.00,0.00,0.00),('1','187','939','239852',4598785,'2764','418',83920.47,84283.27,0.00,0.00,362.80,243076.00,0.00,0.00,0.00),('1','187','939','239852',4598786,'2765','418',52041.35,52695.35,0.00,0.00,654.00,438180.00,0.00,0.00,0.00),('1','187','939','239853',4598787,'2760','418',618946.28,619391.73,0.00,0.00,445.45,320724.00,0.00,0.00,0.00),('1','187','939','239853',4598788,'2761','418',189671.19,190577.69,0.00,0.00,906.50,607355.00,0.00,0.00,0.00),('1','187','939','239853',4598789,'2762','418',135350.67,135692.54,0.00,0.00,341.87,229052.90,0.00,0.00,0.00),('1','187','939','239853',4598790,'2763','418',115254.83,115529.83,0.00,0.00,275.00,184250.00,0.00,0.00,0.00),('1','187','939','239853',4598791,'2764','418',84283.27,84751.27,0.00,0.00,468.00,313560.00,0.00,0.00,0.00),('1','187','939','239853',4598792,'2765','418',52695.35,53064.35,0.00,0.00,369.00,247230.00,0.00,0.00,0.00),('1','187','939','239854',4598793,'2760','418',619391.73,619712.66,0.00,0.00,320.93,231069.60,0.00,0.00,0.00),('1','187','939','239854',4598794,'2761','418',190577.69,191346.80,0.00,0.00,769.11,515303.70,0.00,0.00,0.00),('1','187','939','239854',4598795,'2762','418',135692.54,136247.54,0.00,0.00,555.00,371850.00,0.00,0.00,0.00),('1','187','939','239854',4598796,'2763','418',115529.83,115734.62,0.00,0.00,204.79,137209.30,0.00,0.00,0.00),('1','187','939','239854',4598797,'2764','418',84751.27,85151.27,0.00,0.00,400.00,268000.00,0.00,0.00,0.00),('1','187','939','239854',4598798,'2765','418',53064.35,53365.40,0.00,0.00,301.05,201703.50,0.00,0.00,0.00),('1','187','939','239855',4598799,'2760','418',619712.66,620361.26,0.00,0.00,648.60,466992.00,0.00,0.00,0.00),('1','187','939','239855',4598800,'2761','418',191346.80,191897.80,0.00,0.00,551.00,369170.00,0.00,0.00,0.00),('1','187','939','239855',4598801,'2762','418',136247.54,136596.54,0.00,0.00,349.00,233830.00,0.00,0.00,0.00),('1','187','939','239855',4598802,'2763','418',115734.62,116066.62,0.00,0.00,332.00,222440.00,0.00,0.00,0.00),('1','187','939','239855',4598803,'2764','418',85151.27,85342.27,0.00,0.00,191.00,127970.00,0.00,0.00,0.00),('1','187','939','239855',4598804,'2765','418',53365.40,53892.90,0.00,0.00,527.50,353425.00,0.00,0.00,0.00),('1','187','939','239856',4598805,'2760','418',620361.26,620440.67,0.00,0.00,79.41,57175.20,0.00,0.00,0.00),('1','187','939','239856',4598806,'2761','418',191897.80,192135.21,0.00,0.00,237.41,159064.70,0.00,0.00,0.00),('1','187','939','239856',4598807,'2762','418',136596.54,136780.39,0.00,0.00,183.85,123179.50,0.00,0.00,0.00),('1','187','939','239856',4598808,'2763','418',116066.62,116281.94,0.00,0.00,215.32,144264.40,0.00,0.00,0.00),('1','187','939','239856',4598809,'2764','418',85342.27,85512.88,0.00,0.00,170.61,114308.70,0.00,0.00,0.00),('1','187','939','239856',4598810,'2765','418',53892.90,53892.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239857',4598811,'2760','418',620440.67,620646.03,0.00,0.00,205.36,147859.20,0.00,0.00,0.00),('1','187','939','239857',4598812,'2761','418',192135.21,192135.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239857',4598813,'2762','418',136780.39,136780.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239857',4598814,'2763','418',116281.94,116281.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239857',4598815,'2764','418',85512.88,85512.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239857',4598816,'2765','418',53892.90,53892.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239858',4598817,'2760','418',620646.03,620646.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239858',4598818,'2761','418',192135.21,192135.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239858',4598819,'2762','418',136780.39,136780.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239858',4598820,'2763','418',116281.94,116281.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239858',4598821,'2764','418',85512.88,85512.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239858',4598822,'2765','418',53892.90,53892.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239859',4598823,'2760','418',620646.03,621070.30,0.00,0.00,424.27,305474.40,0.00,0.00,0.00),('1','187','939','239859',4598824,'2761','418',192135.21,193789.21,0.00,0.00,1654.00,1108180.00,0.00,0.00,0.00),('1','187','939','239859',4598825,'2762','418',136780.39,137863.93,0.00,0.00,1083.54,725971.80,0.00,0.00,0.00),('1','187','939','239859',4598826,'2763','418',116281.94,116631.94,0.00,0.00,350.00,234500.00,0.00,0.00,0.00),('1','187','939','239859',4598827,'2764','418',85512.88,85897.88,0.00,0.00,385.00,257950.00,0.00,0.00,0.00),('1','187','939','239859',4598828,'2765','418',53892.90,54088.90,0.00,0.00,196.00,131320.00,0.00,0.00,0.00),('1','187','939','239860',4598829,'2760','418',621070.30,621429.61,0.00,0.00,359.31,258703.20,0.00,0.00,0.00),('1','187','939','239860',4598830,'2761','418',193789.21,194778.21,0.00,0.00,989.00,662630.00,0.00,0.00,0.00),('1','187','939','239860',4598831,'2762','418',137863.93,138623.54,0.00,0.00,759.61,508938.70,0.00,0.00,0.00),('1','187','939','239860',4598832,'2763','418',116631.94,117065.94,0.00,0.00,434.00,290780.00,0.00,0.00,0.00),('1','187','939','239860',4598833,'2764','418',85897.88,86213.88,0.00,0.00,316.00,211720.00,0.00,0.00,0.00),('1','187','939','239860',4598834,'2765','418',54088.90,54146.90,0.00,0.00,58.00,38860.00,0.00,0.00,0.00),('1','187','939','239861',4598835,'2760','418',621429.61,621804.44,0.00,0.00,374.83,269877.60,0.00,0.00,0.00),('1','187','939','239861',4598836,'2761','418',194778.21,195853.21,0.00,0.00,1075.00,720250.00,0.00,0.00,0.00),('1','187','939','239861',4598837,'2762','418',138623.54,139154.14,0.00,0.00,530.60,355502.00,0.00,0.00,0.00),('1','187','939','239861',4598838,'2763','418',117065.94,117465.94,0.00,0.00,400.00,268000.00,0.00,0.00,0.00),('1','187','939','239861',4598839,'2764','418',86213.88,86588.88,0.00,0.00,375.00,251250.00,0.00,0.00,0.00),('1','187','939','239861',4598840,'2765','418',54146.90,54421.90,0.00,0.00,275.00,184250.00,0.00,0.00,0.00),('1','187','939','239862',4598841,'2760','418',621804.44,622116.01,0.00,0.00,311.57,224330.40,0.00,0.00,0.00),('1','187','939','239862',4598842,'2761','418',195853.21,196743.21,0.00,0.00,890.00,596300.00,0.00,0.00,0.00),('1','187','939','239862',4598843,'2762','418',139154.14,139979.14,0.00,0.00,825.00,552750.00,0.00,0.00,0.00),('1','187','939','239862',4598844,'2763','418',117465.94,117865.94,0.00,0.00,400.00,268000.00,0.00,0.00,0.00),('1','187','939','239862',4598845,'2764','418',86588.88,87167.24,0.00,0.00,578.36,387501.20,0.00,0.00,0.00),('1','187','939','239862',4598846,'2765','418',54421.90,54831.90,0.00,0.00,410.00,274700.00,0.00,0.00,0.00),('1','187','939','239863',4598847,'2760','418',622116.01,622314.91,0.00,0.00,198.90,143208.00,0.00,0.00,0.00),('1','187','939','239863',4598848,'2761','418',196743.21,197803.21,0.00,0.00,1060.00,710200.00,0.00,0.00,0.00),('1','187','939','239863',4598849,'2762','418',139979.14,140929.14,0.00,0.00,950.00,636500.00,0.00,0.00,0.00),('1','187','939','239863',4598850,'2763','418',117865.94,118440.94,0.00,0.00,575.00,385250.00,0.00,0.00,0.00),('1','187','939','239863',4598851,'2764','418',87167.24,87676.24,0.00,0.00,509.00,341030.00,0.00,0.00,0.00),('1','187','939','239863',4598852,'2765','418',54831.90,55181.90,0.00,0.00,350.00,234500.00,0.00,0.00,0.00),('1','187','939','239864',4598853,'2760','418',622314.91,622804.39,0.00,0.00,489.48,352425.60,0.00,0.00,0.00),('1','187','939','239864',4598854,'2761','418',197803.21,198630.21,0.00,0.00,827.00,554090.00,0.00,0.00,0.00),('1','187','939','239864',4598855,'2762','418',140929.14,141411.37,0.00,0.00,482.23,323094.10,0.00,0.00,0.00),('1','187','939','239864',4598856,'2763','418',118440.94,118525.87,0.00,0.00,84.93,56903.10,0.00,0.00,0.00),('1','187','939','239864',4598857,'2764','418',87676.24,87676.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239864',4598858,'2765','418',55181.90,55181.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239865',4598859,'2760','418',622804.39,623211.57,0.00,0.00,407.18,293169.60,0.00,0.00,0.00),('1','187','939','239865',4598860,'2761','418',198630.21,199340.21,0.00,0.00,710.00,475700.00,0.00,0.00,0.00),('1','187','939','239865',4598861,'2762','418',141411.37,141785.22,0.00,0.00,373.85,250479.50,0.00,0.00,0.00),('1','187','939','239865',4598862,'2763','418',118525.87,118994.87,0.00,0.00,469.00,314230.00,0.00,0.00,0.00),('1','187','939','239865',4598863,'2764','418',87676.24,88300.24,0.00,0.00,624.00,418080.00,0.00,0.00,0.00),('1','187','939','239865',4598864,'2765','418',55181.90,55563.90,0.00,0.00,382.00,255940.00,0.00,0.00,0.00),('1','187','939','239866',4598865,'2760','418',623211.57,623428.94,0.00,0.00,217.37,156506.40,0.00,0.00,0.00),('1','187','939','239866',4598866,'2761','418',199340.21,200180.21,0.00,0.00,840.00,562800.00,0.00,0.00,0.00),('1','187','939','239866',4598867,'2762','418',141785.22,141986.71,0.00,0.00,201.49,134998.30,0.00,0.00,0.00),('1','187','939','239866',4598868,'2763','418',118994.87,119044.87,0.00,0.00,50.00,33500.00,0.00,0.00,0.00),('1','187','939','239866',4598869,'2764','418',88300.24,88403.24,0.00,0.00,103.00,69010.00,0.00,0.00,0.00),('1','187','939','239866',4598870,'2765','418',55563.90,55863.90,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','187','939','239867',4598871,'2760','418',623428.94,623473.32,0.00,0.00,44.38,31953.60,0.00,0.00,0.00),('1','187','939','239867',4598872,'2761','418',200180.21,200529.21,0.00,0.00,349.00,233830.00,0.00,0.00,0.00),('1','187','939','239867',4598873,'2762','418',141986.71,142186.71,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239867',4598874,'2763','418',119044.87,119121.11,0.00,0.00,76.24,51080.80,0.00,0.00,0.00),('1','187','939','239867',4598875,'2764','418',88403.24,88703.24,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','187','939','239867',4598876,'2765','418',55863.90,55863.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239868',4598877,'2760','418',623473.32,623473.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239868',4598878,'2761','418',200529.21,200529.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239868',4598879,'2762','418',142186.71,142186.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239868',4598880,'2763','418',119121.11,119121.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239868',4598881,'2764','418',88703.24,88703.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239868',4598882,'2765','418',55863.90,55863.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239869',4598883,'2760','418',623473.32,623755.79,0.00,0.00,282.47,203378.40,0.00,0.00,0.00),('1','187','939','239869',4598884,'2761','418',200529.21,201546.13,0.00,0.00,1016.92,671167.20,0.00,0.00,0.00),('1','187','939','239869',4598885,'2762','418',142186.71,142386.71,0.00,0.00,200.00,132000.00,0.00,0.00,0.00),('1','187','939','239869',4598886,'2763','418',119121.11,119497.11,0.00,0.00,376.00,248160.00,0.00,0.00,0.00),('1','187','939','239869',4598887,'2764','418',88703.24,88978.24,0.00,0.00,275.00,181500.00,0.00,0.00,0.00),('1','187','939','239869',4598888,'2765','418',55863.90,56013.90,0.00,0.00,150.00,99000.00,0.00,0.00,0.00),('1','187','939','239870',4598889,'2760','418',623755.79,624077.82,0.00,0.00,322.03,231861.60,0.00,0.00,0.00),('1','187','939','239870',4598890,'2761','418',201546.13,201871.13,0.00,0.00,325.00,214500.00,0.00,0.00,0.00),('1','187','939','239870',4598891,'2762','418',142386.71,142601.81,0.00,0.00,215.10,141966.00,0.00,0.00,0.00),('1','187','939','239870',4598892,'2763','418',119497.11,119744.11,0.00,0.00,247.00,163020.00,0.00,0.00,0.00),('1','187','939','239870',4598893,'2764','418',88978.24,89053.24,0.00,0.00,75.00,49500.00,0.00,0.00,0.00),('1','187','939','239870',4598894,'2765','418',56013.90,56063.90,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','187','939','239871',4598895,'2760','418',624077.82,624479.88,0.00,0.00,402.06,289483.20,0.00,0.00,0.00),('1','187','939','239871',4598896,'2761','418',201871.13,202602.13,0.00,0.00,731.00,482460.00,0.00,0.00,0.00),('1','187','939','239871',4598897,'2762','418',142601.81,143286.81,0.00,0.00,685.00,452100.00,0.00,0.00,0.00),('1','187','939','239871',4598898,'2763','418',119744.11,120150.11,0.00,0.00,406.00,267960.00,0.00,0.00,0.00),('1','187','939','239871',4598899,'2764','418',89053.24,89348.84,0.00,0.00,295.60,195096.00,0.00,0.00,0.00),('1','187','939','239871',4598900,'2765','418',56063.90,56113.90,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','187','939','239872',4598901,'2760','418',624479.88,624824.51,0.00,0.00,344.63,248133.60,0.00,0.00,0.00),('1','187','939','239872',4598902,'2761','418',202602.13,203145.13,0.00,0.00,543.00,358380.00,0.00,0.00,0.00),('1','187','939','239872',4598903,'2762','418',143286.81,143569.84,0.00,0.00,283.03,186799.80,0.00,0.00,0.00),('1','187','939','239872',4598904,'2763','418',120150.11,120202.11,0.00,0.00,52.00,34320.00,0.00,0.00,0.00),('1','187','939','239872',4598905,'2764','418',89348.84,89448.84,0.00,0.00,100.00,66000.00,0.00,0.00,0.00),('1','187','939','239872',4598906,'2765','418',56113.90,56113.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239873',4598907,'2760','418',624824.51,625368.84,0.00,0.00,544.33,391917.60,0.00,0.00,0.00),('1','187','939','239873',4598908,'2761','418',203145.13,203548.64,0.00,0.00,403.51,266316.60,0.00,0.00,0.00),('1','187','939','239873',4598909,'2762','418',143569.84,144046.84,0.00,0.00,477.00,314820.00,0.00,0.00,0.00),('1','187','939','239873',4598910,'2763','418',120202.11,120532.11,0.00,0.00,330.00,217800.00,0.00,0.00,0.00),('1','187','939','239873',4598911,'2764','418',89448.84,89808.84,0.00,0.00,360.00,237600.00,0.00,0.00,0.00),('1','187','939','239873',4598912,'2765','418',56113.90,56464.90,0.00,0.00,351.00,231660.00,0.00,0.00,0.00),('1','187','939','239874',4598913,'2760','418',625368.84,625767.31,0.00,0.00,398.47,286898.40,0.00,0.00,0.00),('1','187','939','239874',4598914,'2761','418',203548.64,204148.64,0.00,0.00,600.00,396000.00,0.00,0.00,0.00),('1','187','939','239874',4598915,'2762','418',144046.84,144780.84,0.00,0.00,734.00,484440.00,0.00,0.00,0.00),('1','187','939','239874',4598916,'2763','418',120532.11,120880.88,0.00,0.00,348.77,230188.20,0.00,0.00,0.00),('1','187','939','239874',4598917,'2764','418',89808.84,90437.84,0.00,0.00,629.00,415140.00,0.00,0.00,0.00),('1','187','939','239874',4598918,'2765','418',56464.90,56914.90,0.00,0.00,450.00,297000.00,0.00,0.00,0.00),('1','187','939','239875',4598919,'2760','418',625767.31,626306.38,0.00,0.00,539.07,388130.40,0.00,0.00,0.00),('1','187','939','239875',4598920,'2761','418',204148.64,205281.64,0.00,0.00,1133.00,745617.00,0.00,0.00,0.00),('1','187','939','239875',4598921,'2762','418',144780.84,145645.18,0.00,0.00,864.34,570464.40,0.00,0.00,0.00),('1','187','939','239875',4598922,'2763','418',120880.88,121601.88,0.00,0.00,721.00,475860.00,0.00,0.00,0.00),('1','187','939','239875',4598923,'2764','418',90437.84,91347.84,0.00,0.00,910.00,599025.00,0.00,0.00,0.00),('1','187','939','239875',4598924,'2765','418',56914.90,57684.90,0.00,0.00,770.00,506790.00,0.00,0.00,0.00),('1','187','939','239876',4598925,'2760','418',626306.38,626617.86,0.00,0.00,311.48,224265.60,0.00,0.00,0.00),('1','187','939','239876',4598926,'2761','418',205281.64,206343.64,0.00,0.00,1062.00,700920.00,0.00,0.00,0.00),('1','187','939','239876',4598927,'2762','418',145645.18,146070.18,0.00,0.00,425.00,280500.00,0.00,0.00,0.00),('1','187','939','239876',4598928,'2763','418',121601.88,121951.88,0.00,0.00,350.00,231000.00,0.00,0.00,0.00),('1','187','939','239876',4598929,'2764','418',91347.84,91622.84,0.00,0.00,275.00,181500.00,0.00,0.00,0.00),('1','187','939','239876',4598930,'2765','418',57684.90,58204.90,0.00,0.00,520.00,343200.00,0.00,0.00,0.00),('1','187','939','239877',4598931,'2760','418',626617.86,626800.36,0.00,0.00,182.50,131400.00,0.00,0.00,0.00),('1','187','939','239877',4598932,'2761','418',206343.64,207112.14,0.00,0.00,768.50,507210.00,0.00,0.00,0.00),('1','187','939','239877',4598933,'2762','418',146070.18,146365.79,0.00,0.00,295.61,195102.60,0.00,0.00,0.00),('1','187','939','239877',4598934,'2763','418',121951.88,122201.88,0.00,0.00,250.00,165000.00,0.00,0.00,0.00),('1','187','939','239877',4598935,'2764','418',91622.84,91722.84,0.00,0.00,100.00,66600.00,0.00,0.00,0.00),('1','187','939','239877',4598936,'2765','418',58204.90,58254.90,0.00,0.00,50.00,33000.00,0.00,0.00,0.00),('1','187','939','239878',4598937,'2760','418',626800.36,627001.83,0.00,0.00,201.47,145058.40,0.00,0.00,0.00),('1','187','939','239878',4598938,'2761','418',207112.14,207628.58,0.00,0.00,516.44,340850.40,0.00,0.00,0.00),('1','187','939','239878',4598939,'2762','418',146365.79,146666.79,0.00,0.00,301.00,198660.00,0.00,0.00,0.00),('1','187','939','239878',4598940,'2763','418',122201.88,122426.88,0.00,0.00,225.00,148500.00,0.00,0.00,0.00),('1','187','939','239878',4598941,'2764','418',91722.84,92276.24,0.00,0.00,553.40,365244.00,0.00,0.00,0.00),('1','187','939','239878',4598942,'2765','418',58254.90,58464.90,0.00,0.00,210.00,138600.00,0.00,0.00,0.00),('1','187','939','239879',4598943,'2760','418',627001.83,627001.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239879',4598944,'2761','418',207628.58,207628.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239879',4598945,'2762','418',146666.79,146666.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239879',4598946,'2763','418',122426.88,122426.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239879',4598947,'2764','418',92276.24,92276.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239879',4598948,'2765','418',58464.90,58464.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239880',4598949,'2760','418',627001.83,627515.83,0.00,0.00,514.00,370080.00,0.00,0.00,0.00),('1','187','939','239880',4598950,'2761','418',207628.58,208302.58,0.00,0.00,674.00,444840.00,0.00,0.00,0.00),('1','187','939','239880',4598951,'2762','418',146666.79,147231.79,0.00,0.00,565.00,372900.00,0.00,0.00,0.00),('1','187','939','239880',4598952,'2763','418',122426.88,122853.88,0.00,0.00,427.00,281820.00,0.00,0.00,0.00),('1','187','939','239880',4598953,'2764','418',92276.24,92726.24,0.00,0.00,450.00,297000.00,0.00,0.00,0.00),('1','187','939','239880',4598954,'2765','418',58464.90,58764.90,0.00,0.00,300.00,198000.00,0.00,0.00,0.00),('1','187','939','239881',4598955,'2760','418',627515.83,627908.21,0.00,0.00,392.38,282513.60,0.00,0.00,0.00),('1','187','939','239881',4598956,'2761','418',208302.58,208810.64,0.00,0.00,508.06,335319.60,0.00,0.00,0.00),('1','187','939','239881',4598957,'2762','418',147231.79,147306.79,0.00,0.00,75.00,49500.00,0.00,0.00,0.00),('1','187','939','239881',4598958,'2763','418',122853.88,123195.88,0.00,0.00,342.00,225720.00,0.00,0.00,0.00),('1','187','939','239881',4598959,'2764','418',92726.24,92861.24,0.00,0.00,135.00,89100.00,0.00,0.00,0.00),('1','187','939','239881',4598960,'2765','418',58764.90,58864.90,0.00,0.00,100.00,66000.00,0.00,0.00,0.00),('1','187','939','239882',4598961,'2760','418',627908.21,628345.60,0.00,0.00,437.39,314920.80,0.00,0.00,0.00),('1','187','939','239882',4598962,'2761','418',208810.64,209916.64,0.00,0.00,1106.00,729960.00,0.00,0.00,0.00),('1','187','939','239882',4598963,'2762','418',147306.79,147709.89,0.00,0.00,403.10,266046.00,0.00,0.00,0.00),('1','187','939','239882',4598964,'2763','418',123195.88,123553.88,0.00,0.00,358.00,236280.00,0.00,0.00,0.00),('1','187','939','239882',4598965,'2764','418',92861.24,93061.24,0.00,0.00,200.00,132000.00,0.00,0.00,0.00),('1','187','939','239882',4598966,'2765','418',58864.90,59289.90,0.00,0.00,425.00,280500.00,0.00,0.00,0.00),('1','187','939','239883',4598967,'2760','418',628345.60,628709.40,0.00,0.00,363.80,261936.00,0.00,0.00,0.00),('1','187','939','239883',4598968,'2761','418',209916.64,211024.51,0.00,0.00,1107.87,731194.20,0.00,0.00,0.00),('1','187','939','239883',4598969,'2762','418',147709.89,149009.89,0.00,0.00,1300.00,858000.00,0.00,0.00,0.00),('1','187','939','239883',4598970,'2763','418',123553.88,124043.88,0.00,0.00,490.00,323400.00,0.00,0.00,0.00),('1','187','939','239883',4598971,'2764','418',93061.24,93607.24,0.00,0.00,546.00,360360.00,0.00,0.00,0.00),('1','187','939','239883',4598972,'2765','418',59289.90,59639.90,0.00,0.00,350.00,231000.00,0.00,0.00,0.00),('1','187','939','239884',4598973,'2760','418',628709.40,629198.96,0.00,0.00,489.56,352483.20,0.00,0.00,0.00),('1','187','939','239884',4598974,'2761','418',211024.51,211724.51,0.00,0.00,700.00,462000.00,0.00,0.00,0.00),('1','187','939','239884',4598975,'2762','418',149009.89,149374.89,0.00,0.00,365.00,240900.00,0.00,0.00,0.00),('1','187','939','239884',4598976,'2763','418',124043.88,124398.88,0.00,0.00,355.00,234300.00,0.00,0.00,0.00),('1','187','939','239884',4598977,'2764','418',93607.24,94067.24,0.00,0.00,460.00,303600.00,0.00,0.00,0.00),('1','187','939','239884',4598978,'2765','418',59639.90,59989.90,0.00,0.00,350.00,231000.00,0.00,0.00,0.00),('1','187','939','239885',4598979,'2760','418',629198.96,629835.02,0.00,0.00,636.06,457963.20,0.00,0.00,0.00),('1','187','939','239885',4598980,'2761','418',211724.51,212843.51,0.00,0.00,1119.00,738540.00,0.00,0.00,0.00),('1','187','939','239885',4598981,'2762','418',149374.89,150013.89,0.00,0.00,639.00,421740.00,0.00,0.00,0.00),('1','187','939','239885',4598982,'2763','418',124398.88,125110.88,0.00,0.00,712.00,469920.00,0.00,0.00,0.00),('1','187','939','239885',4598983,'2764','418',94067.24,94599.24,0.00,0.00,532.00,351120.00,0.00,0.00,0.00),('1','187','939','239885',4598984,'2765','418',59989.90,60763.90,0.00,0.00,774.00,510840.00,0.00,0.00,0.00),('1','187','939','239886',4598985,'2760','418',629835.02,630241.32,0.00,0.00,406.30,292536.00,0.00,0.00,0.00),('1','187','939','239886',4598986,'2761','418',212843.51,213134.51,0.00,0.00,291.00,192060.00,0.00,0.00,0.00),('1','187','939','239886',4598987,'2762','418',150013.89,150293.89,0.00,0.00,280.00,184800.00,0.00,0.00,0.00),('1','187','939','239886',4598988,'2763','418',125110.88,125355.88,0.00,0.00,245.00,161700.00,0.00,0.00,0.00),('1','187','939','239886',4598989,'2764','418',94599.24,94719.24,0.00,0.00,120.00,79200.00,0.00,0.00,0.00),('1','187','939','239886',4598990,'2765','418',60763.90,61013.90,0.00,0.00,250.00,165000.00,0.00,0.00,0.00),('1','187','939','239887',4598991,'2760','418',630241.32,630724.19,0.00,0.00,482.87,347666.40,0.00,0.00,0.00),('1','187','939','239887',4598992,'2761','418',213134.51,214140.51,0.00,0.00,1006.00,663960.00,0.00,0.00,0.00),('1','187','939','239887',4598993,'2762','418',150293.89,150708.89,0.00,0.00,415.00,273900.00,0.00,0.00,0.00),('1','187','939','239887',4598994,'2763','418',125355.88,126055.88,0.00,0.00,700.00,462000.00,0.00,0.00,0.00),('1','187','939','239887',4598995,'2764','418',94719.24,95164.24,0.00,0.00,445.00,293700.00,0.00,0.00,0.00),('1','187','939','239887',4598996,'2765','418',61013.90,61363.90,0.00,0.00,350.00,231000.00,0.00,0.00,0.00),('1','187','939','239888',4598997,'2760','418',630724.19,630727.87,0.00,0.00,3.68,2649.60,0.00,0.00,0.00),('1','187','939','239888',4598998,'2761','418',214140.51,214206.54,0.00,0.00,66.03,43579.80,0.00,0.00,0.00),('1','187','939','239888',4598999,'2762','418',150708.89,150710.61,0.00,0.00,1.72,1135.20,0.00,0.00,0.00),('1','187','939','239888',4599000,'2763','418',126055.88,126055.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239888',4599001,'2764','418',95164.24,95164.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239888',4599002,'2765','418',61363.90,61363.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239889',4599003,'2760','418',630727.87,630727.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239889',4599004,'2761','418',214206.54,214206.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239889',4599005,'2762','418',150710.61,150710.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239889',4599006,'2763','418',126055.88,126055.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239889',4599007,'2764','418',95164.24,95164.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239889',4599008,'2765','418',61363.90,61363.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239890',4599009,'2760','418',630727.87,630941.37,0.00,0.00,213.50,153720.00,0.00,0.00,0.00),('1','187','939','239890',4599010,'2761','418',214206.54,214483.54,0.00,0.00,277.00,181435.00,0.00,0.00,0.00),('1','187','939','239890',4599011,'2762','418',150710.61,150825.61,0.00,0.00,115.00,75325.00,0.00,0.00,0.00),('1','187','939','239890',4599012,'2763','418',126055.88,126155.88,0.00,0.00,100.00,65500.00,0.00,0.00,0.00),('1','187','939','239890',4599013,'2764','418',95164.24,95164.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239890',4599014,'2765','418',61363.90,61363.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239891',4599015,'2760','418',630941.37,631495.12,0.00,0.00,553.75,398700.00,0.00,0.00,0.00),('1','187','939','239891',4599016,'2761','418',214483.54,215727.54,0.00,0.00,1244.00,814820.00,0.00,0.00,0.00),('1','187','939','239891',4599017,'2762','418',150825.61,151895.92,0.00,0.00,1070.31,701053.05,0.00,0.00,0.00),('1','187','939','239891',4599018,'2763','418',126155.88,126655.88,0.00,0.00,500.00,327500.00,0.00,0.00,0.00),('1','187','939','239891',4599019,'2764','418',95164.24,95639.24,0.00,0.00,475.00,311125.00,0.00,0.00,0.00),('1','187','939','239891',4599020,'2765','418',61363.90,61698.90,0.00,0.00,335.00,219425.00,0.00,0.00,0.00),('1','187','939','239892',4599021,'2760','418',631495.12,631885.49,0.00,0.00,390.37,281066.40,0.00,0.00,0.00),('1','187','939','239892',4599022,'2761','418',215727.54,216823.02,0.00,0.00,1095.48,717539.40,0.00,0.00,0.00),('1','187','939','239892',4599023,'2762','418',151895.92,152797.85,0.00,0.00,901.93,590764.15,0.00,0.00,0.00),('1','187','939','239892',4599024,'2763','418',126655.88,127236.48,0.00,0.00,580.60,380293.00,0.00,0.00,0.00),('1','187','939','239892',4599025,'2764','418',95639.24,96344.24,0.00,0.00,705.00,461775.00,0.00,0.00,0.00),('1','187','939','239892',4599026,'2765','418',61698.90,62336.90,0.00,0.00,638.00,417890.00,0.00,0.00,0.00),('1','187','939','239893',4599027,'2760','418',631885.49,632137.66,0.00,0.00,252.17,181562.40,0.00,0.00,0.00),('1','187','939','239893',4599028,'2761','418',216823.02,218078.39,0.00,0.00,1255.37,822267.35,0.00,0.00,0.00),('1','187','939','239893',4599029,'2762','418',152797.85,153747.85,0.00,0.00,950.00,622250.00,0.00,0.00,0.00),('1','187','939','239893',4599030,'2763','418',127236.48,127957.48,0.00,0.00,721.00,472255.00,0.00,0.00,0.00),('1','187','939','239893',4599031,'2764','418',96344.24,97077.24,0.00,0.00,733.00,480115.00,0.00,0.00,0.00),('1','187','939','239893',4599032,'2765','418',62336.90,62836.90,0.00,0.00,500.00,327500.00,0.00,0.00,0.00),('1','187','939','239894',4599033,'2760','418',632137.66,632649.42,0.00,0.00,511.76,368467.20,0.00,0.00,0.00),('1','187','939','239894',4599034,'2761','418',218078.39,218868.02,0.00,0.00,789.63,517207.65,0.00,0.00,0.00),('1','187','939','239894',4599035,'2762','418',153747.85,154408.85,0.00,0.00,661.00,432955.00,0.00,0.00,0.00),('1','187','939','239894',4599036,'2763','418',127957.48,128642.48,0.00,0.00,685.00,448675.00,0.00,0.00,0.00),('1','187','939','239894',4599037,'2764','418',97077.24,97636.24,0.00,0.00,559.00,366145.00,0.00,0.00,0.00),('1','187','939','239894',4599038,'2765','418',62836.90,63491.07,0.00,0.00,654.17,428481.35,0.00,0.00,0.00),('1','187','939','239895',4599039,'2760','418',632649.42,632973.15,0.00,0.00,323.73,233085.60,0.00,0.00,0.00),('1','187','939','239895',4599040,'2761','418',218868.02,219446.02,0.00,0.00,578.00,378590.00,0.00,0.00,0.00),('1','187','939','239895',4599041,'2762','418',154408.85,155006.64,0.00,0.00,597.79,391552.45,0.00,0.00,0.00),('1','187','939','239895',4599042,'2763','418',128642.48,128642.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239895',4599043,'2764','418',97636.24,97786.24,0.00,0.00,150.00,98250.00,0.00,0.00,0.00),('1','187','939','239895',4599044,'2765','418',63491.07,63491.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239896',4599045,'2760','418',632973.15,633303.72,0.00,0.00,330.57,238010.40,0.00,0.00,0.00),('1','187','939','239896',4599046,'2761','418',219446.02,220353.09,0.00,0.00,907.07,594130.85,0.00,0.00,0.00),('1','187','939','239896',4599047,'2762','418',155006.64,155597.64,0.00,0.00,591.00,387105.00,0.00,0.00,0.00),('1','187','939','239896',4599048,'2763','418',128642.48,129233.48,0.00,0.00,591.00,387105.00,0.00,0.00,0.00),('1','187','939','239896',4599049,'2764','418',97786.24,98502.24,0.00,0.00,716.00,468980.00,0.00,0.00,0.00),('1','187','939','239896',4599050,'2765','418',63491.07,63716.07,0.00,0.00,225.00,147375.00,0.00,0.00,0.00),('1','187','939','239897',4599051,'2760','418',633303.72,633396.87,0.00,0.00,93.15,67068.00,0.00,0.00,0.00),('1','187','939','239897',4599052,'2761','418',220353.09,220752.92,0.00,0.00,399.83,261888.65,0.00,0.00,0.00),('1','187','939','239897',4599053,'2762','418',155597.64,156007.64,0.00,0.00,410.00,268550.00,0.00,0.00,0.00),('1','187','939','239897',4599054,'2763','418',129233.48,129533.48,0.00,0.00,300.00,196500.00,0.00,0.00,0.00),('1','187','939','239897',4599055,'2764','418',98502.24,98779.24,0.00,0.00,277.00,181435.00,0.00,0.00,0.00),('1','187','939','239897',4599056,'2765','418',63716.07,64077.07,0.00,0.00,361.00,236455.00,0.00,0.00,0.00),('1','187','939','239898',4599057,'2760','418',633396.87,633398.95,0.00,0.00,2.08,1497.60,0.00,0.00,0.00),('1','187','939','239898',4599058,'2761','418',220752.92,220770.80,0.00,0.00,17.88,11711.40,0.00,0.00,0.00),('1','187','939','239898',4599059,'2762','418',156007.64,156012.14,0.00,0.00,4.50,2947.50,0.00,0.00,0.00),('1','187','939','239898',4599060,'2763','418',129533.48,129533.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239898',4599061,'2764','418',98779.24,98779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239898',4599062,'2765','418',64077.07,64077.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239899',4599063,'2760','418',633398.95,633398.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239899',4599064,'2761','418',220770.80,220770.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239899',4599065,'2762','418',156012.14,156012.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239899',4599066,'2763','418',129533.48,129533.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239899',4599067,'2764','418',98779.24,98779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239899',4599068,'2765','418',64077.07,64077.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239900',4599069,'2760','418',633398.95,633779.47,0.00,0.00,380.52,273974.40,0.00,0.00,0.00),('1','187','939','239900',4599070,'2761','418',220770.80,221522.30,0.00,0.00,751.50,492232.50,0.00,0.00,0.00),('1','187','939','239900',4599071,'2762','418',156012.14,156498.14,0.00,0.00,486.00,318330.00,0.00,0.00,0.00),('1','187','939','239900',4599072,'2763','418',129533.48,130126.48,0.00,0.00,593.00,388415.00,0.00,0.00,0.00),('1','187','939','239900',4599073,'2764','418',98779.24,99134.24,0.00,0.00,355.00,232525.00,0.00,0.00,0.00),('1','187','939','239900',4599074,'2765','418',64077.07,64895.57,0.00,0.00,818.50,536117.50,0.00,0.00,0.00),('1','187','939','239901',4599075,'2760','418',633779.47,634079.25,0.00,0.00,299.78,215841.60,0.00,0.00,0.00),('1','187','939','239901',4599076,'2761','418',221522.30,223136.30,0.00,0.00,1614.00,1057170.00,0.00,0.00,0.00),('1','187','939','239901',4599077,'2762','418',156498.14,157501.14,0.00,0.00,1003.00,656965.00,0.00,0.00,0.00),('1','187','939','239901',4599078,'2763','418',130126.48,130801.48,0.00,0.00,675.00,442125.00,0.00,0.00,0.00),('1','187','939','239901',4599079,'2764','418',99134.24,99749.24,0.00,0.00,615.00,402825.00,0.00,0.00,0.00),('1','187','939','239901',4599080,'2765','418',64895.57,65728.57,0.00,0.00,833.00,545615.00,0.00,0.00,0.00),('1','187','939','239902',4599081,'2760','418',634079.25,634377.85,0.00,0.00,298.60,214992.00,0.00,0.00,0.00),('1','187','939','239902',4599082,'2761','418',223136.30,223903.19,0.00,0.00,766.89,502312.95,0.00,0.00,0.00),('1','187','939','239902',4599083,'2762','418',157501.14,158180.14,0.00,0.00,679.00,444745.00,0.00,0.00,0.00),('1','187','939','239902',4599084,'2763','418',130801.48,131531.48,0.00,0.00,730.00,478150.00,0.00,0.00,0.00),('1','187','939','239902',4599085,'2764','418',99749.24,100531.24,0.00,0.00,782.00,512210.00,0.00,0.00,0.00),('1','187','939','239902',4599086,'2765','418',65728.57,66378.57,0.00,0.00,650.00,425750.00,0.00,0.00,0.00),('1','187','939','239903',4599087,'2760','418',634377.85,634595.89,0.00,0.00,218.04,156988.80,0.00,0.00,0.00),('1','187','939','239903',4599088,'2761','418',223903.19,224500.00,0.00,0.00,596.81,390910.55,0.00,0.00,0.00),('1','187','939','239903',4599089,'2762','418',158180.14,158593.00,0.00,0.00,412.86,270423.30,0.00,0.00,0.00),('1','187','939','239903',4599090,'2763','418',131531.48,131931.48,0.00,0.00,400.00,262000.00,0.00,0.00,0.00),('1','187','939','239903',4599091,'2764','418',100531.24,100901.24,0.00,0.00,370.00,242350.00,0.00,0.00,0.00),('1','187','939','239903',4599092,'2765','418',66378.57,66796.57,0.00,0.00,418.00,273790.00,0.00,0.00,0.00),('1','187','939','239904',4599093,'2760','418',634595.89,634941.16,0.00,0.00,345.27,248594.40,0.00,0.00,0.00),('1','187','939','239904',4599094,'2761','418',224500.00,225213.59,0.00,0.00,713.59,467401.45,0.00,0.00,0.00),('1','187','939','239904',4599095,'2762','418',158593.00,159371.50,0.00,0.00,778.50,509917.50,0.00,0.00,0.00),('1','187','939','239904',4599096,'2763','418',131931.48,132436.60,0.00,0.00,505.12,330853.60,0.00,0.00,0.00),('1','187','939','239904',4599097,'2764','418',100901.24,101501.24,0.00,0.00,600.00,393000.00,0.00,0.00,0.00),('1','187','939','239904',4599098,'2765','418',66796.57,67265.57,0.00,0.00,469.00,307195.00,0.00,0.00,0.00),('1','187','939','239905',4599099,'2760','418',634941.16,635186.07,0.00,0.00,244.91,176335.20,0.00,0.00,0.00),('1','187','939','239905',4599100,'2761','418',225213.59,226986.72,0.00,0.00,1773.13,1161400.15,0.00,0.00,0.00),('1','187','939','239905',4599101,'2762','418',159371.50,160537.08,0.00,0.00,1165.58,763454.90,0.00,0.00,0.00),('1','187','939','239905',4599102,'2763','418',132436.60,133646.60,0.00,0.00,1210.00,792550.00,0.00,0.00,0.00),('1','187','939','239905',4599103,'2764','418',101501.24,102566.24,0.00,0.00,1065.00,697575.00,0.00,0.00,0.00),('1','187','939','239905',4599104,'2765','418',67265.57,68414.57,0.00,0.00,1149.00,752595.00,0.00,0.00,0.00),('1','187','939','239906',4599105,'2760','418',635186.07,635186.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239906',4599106,'2761','418',226986.72,226986.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239906',4599107,'2762','418',160537.08,160537.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239906',4599108,'2763','418',133646.60,133646.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239906',4599109,'2764','418',102566.24,102566.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239906',4599110,'2765','418',68414.57,68414.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239907',4599111,'2760','418',635186.07,635533.97,0.00,0.00,347.90,250488.00,0.00,0.00,0.00),('1','187','939','239907',4599112,'2761','418',226986.72,228639.72,0.00,0.00,1653.00,1099245.00,0.00,0.00,0.00),('1','187','939','239907',4599113,'2762','418',160537.08,161859.04,0.00,0.00,1321.96,879103.40,0.00,0.00,0.00),('1','187','939','239907',4599114,'2763','418',133646.60,134376.60,0.00,0.00,730.00,485450.00,0.00,0.00,0.00),('1','187','939','239907',4599115,'2764','418',102566.24,103696.24,0.00,0.00,1130.00,751450.00,0.00,0.00,0.00),('1','187','939','239907',4599116,'2765','418',68414.57,69192.57,0.00,0.00,778.00,517370.00,0.00,0.00,0.00),('1','187','939','239908',4599117,'2760','418',635533.97,635841.00,0.00,0.00,307.03,221061.60,0.00,0.00,0.00),('1','187','939','239908',4599118,'2761','418',228639.72,229728.27,0.00,0.00,1088.55,723885.75,0.00,0.00,0.00),('1','187','939','239908',4599119,'2762','418',161859.04,162694.04,0.00,0.00,835.00,555275.00,0.00,0.00,0.00),('1','187','939','239908',4599120,'2763','418',134376.60,135063.60,0.00,0.00,687.00,456855.00,0.00,0.00,0.00),('1','187','939','239908',4599121,'2764','418',103696.24,104336.24,0.00,0.00,640.00,425600.00,0.00,0.00,0.00),('1','187','939','239908',4599122,'2765','418',69192.57,69752.57,0.00,0.00,560.00,372400.00,0.00,0.00,0.00),('1','187','939','239909',4599123,'2760','418',635841.00,636220.02,0.00,0.00,379.02,272894.40,0.00,0.00,0.00),('1','187','939','239909',4599124,'2761','418',229728.27,230744.27,0.00,0.00,1016.00,675640.00,0.00,0.00,0.00),('1','187','939','239909',4599125,'2762','418',162694.04,163391.04,0.00,0.00,697.00,463505.00,0.00,0.00,0.00),('1','187','939','239909',4599126,'2763','418',135063.60,135618.60,0.00,0.00,555.00,369075.00,0.00,0.00,0.00),('1','187','939','239909',4599127,'2764','418',104336.24,105008.24,0.00,0.00,672.00,446880.00,0.00,0.00,0.00),('1','187','939','239909',4599128,'2765','418',69752.57,70253.07,0.00,0.00,500.50,332832.50,0.00,0.00,0.00),('1','187','939','239910',4599129,'2760','418',636220.02,636561.00,0.00,0.00,340.98,245505.60,0.00,0.00,0.00),('1','187','939','239910',4599130,'2761','418',230744.27,231274.27,0.00,0.00,530.00,352450.00,0.00,0.00,0.00),('1','187','939','239910',4599131,'2762','418',163391.04,163834.04,0.00,0.00,443.00,294595.00,0.00,0.00,0.00),('1','187','939','239910',4599132,'2763','418',135618.60,136143.60,0.00,0.00,525.00,349125.00,0.00,0.00,0.00),('1','187','939','239910',4599133,'2764','418',105008.24,105358.24,0.00,0.00,350.00,232750.00,0.00,0.00,0.00),('1','187','939','239910',4599134,'2765','418',70253.07,70453.07,0.00,0.00,200.00,133000.00,0.00,0.00,0.00),('1','187','939','239911',4599135,'2760','418',636561.00,636685.21,0.00,0.00,124.21,89431.20,0.00,0.00,0.00),('1','187','939','239911',4599136,'2761','418',231274.27,232177.91,0.00,0.00,903.64,600920.60,0.00,0.00,0.00),('1','187','939','239911',4599137,'2762','418',163834.04,164514.04,0.00,0.00,680.00,452200.00,0.00,0.00,0.00),('1','187','939','239911',4599138,'2763','418',136143.60,136539.60,0.00,0.00,396.00,263340.00,0.00,0.00,0.00),('1','187','939','239911',4599139,'2764','418',105358.24,106223.24,0.00,0.00,865.00,575225.00,0.00,0.00,0.00),('1','187','939','239911',4599140,'2765','418',70453.07,71044.08,0.00,0.00,591.01,393021.65,0.00,0.00,0.00),('1','187','939','239912',4599141,'2760','418',636685.21,636787.92,0.00,0.00,102.71,73951.20,0.00,0.00,0.00),('1','187','939','239912',4599142,'2761','418',232177.91,233679.05,0.00,0.00,1501.14,998258.10,0.00,0.00,0.00),('1','187','939','239912',4599143,'2762','418',164514.04,165225.04,0.00,0.00,711.00,472815.00,0.00,0.00,0.00),('1','187','939','239912',4599144,'2763','418',136539.60,137081.60,0.00,0.00,542.00,360430.00,0.00,0.00,0.00),('1','187','939','239912',4599145,'2764','418',106223.24,106986.24,0.00,0.00,763.00,507395.00,0.00,0.00,0.00),('1','187','939','239912',4599146,'2765','418',71044.08,72124.08,0.00,0.00,1080.00,718200.00,0.00,0.00,0.00),('1','187','939','239913',4599147,'2760','418',636787.92,636787.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239913',4599148,'2761','418',233679.05,233679.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239913',4599149,'2762','418',165225.04,165225.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239913',4599150,'2763','418',137081.60,137081.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239913',4599151,'2764','418',106986.24,106986.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239913',4599152,'2765','418',72124.08,72124.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239914',4599153,'2760','418',636787.92,637023.50,0.00,0.00,235.58,169617.60,0.00,0.00,0.00),('1','187','939','239914',4599154,'2761','418',233679.05,235621.05,0.00,0.00,1942.00,1301140.00,0.00,0.00,0.00),('1','187','939','239914',4599155,'2762','418',165225.04,167103.17,0.00,0.00,1878.13,1258347.10,0.00,0.00,0.00),('1','187','939','239914',4599156,'2763','418',137081.60,137939.36,0.00,0.00,857.76,574699.20,0.00,0.00,0.00),('1','187','939','239914',4599157,'2764','418',106986.24,107828.24,0.00,0.00,842.00,564140.00,0.00,0.00,0.00),('1','187','939','239914',4599158,'2765','418',72124.08,72359.28,0.00,0.00,235.20,157584.00,0.00,0.00,0.00),('1','187','939','239915',4599159,'2760','418',637023.50,637377.47,0.00,0.00,353.97,254858.40,0.00,0.00,0.00),('1','187','939','239915',4599160,'2761','418',235621.05,237135.05,0.00,0.00,1514.00,1012380.00,0.00,0.00,0.00),('1','187','939','239915',4599161,'2762','418',167103.17,167962.12,0.00,0.00,858.95,575246.50,0.00,0.00,0.00),('1','187','939','239915',4599162,'2763','418',137939.36,138589.36,0.00,0.00,650.00,434000.00,0.00,0.00,0.00),('1','187','939','239915',4599163,'2764','418',107828.24,108438.24,0.00,0.00,610.00,406950.00,0.00,0.00,0.00),('1','187','939','239915',4599164,'2765','418',72359.28,72620.60,0.00,0.00,261.32,174084.40,0.00,0.00,0.00),('1','187','939','239916',4599165,'2760','418',637377.47,637662.54,0.00,0.00,285.07,205250.40,0.00,0.00,0.00),('1','187','939','239916',4599166,'2761','418',237135.05,238497.06,0.00,0.00,1362.01,912546.70,0.00,0.00,0.00),('1','187','939','239916',4599167,'2762','418',167962.12,168882.03,0.00,0.00,919.91,616339.70,0.00,0.00,0.00),('1','187','939','239916',4599168,'2763','418',138589.36,138877.21,0.00,0.00,287.85,192859.50,0.00,0.00,0.00),('1','187','939','239916',4599169,'2764','418',108438.24,108823.24,0.00,0.00,385.00,257950.00,0.00,0.00,0.00),('1','187','939','239916',4599170,'2765','418',72620.60,72945.60,0.00,0.00,325.00,217750.00,0.00,0.00,0.00),('1','187','939','239917',4599171,'2760','418',637662.54,637982.06,0.00,0.00,319.52,230054.40,0.00,0.00,0.00),('1','187','939','239917',4599172,'2761','418',238497.06,240314.56,0.00,0.00,1817.50,1217725.00,0.00,0.00,0.00),('1','187','939','239917',4599173,'2762','418',168882.03,169837.03,0.00,0.00,955.00,639850.00,0.00,0.00,0.00),('1','187','939','239917',4599174,'2763','418',138877.21,139677.21,0.00,0.00,800.00,536000.00,0.00,0.00,0.00),('1','187','939','239917',4599175,'2764','418',108823.24,109213.24,0.00,0.00,390.00,261300.00,0.00,0.00,0.00),('1','187','939','239917',4599176,'2765','418',72945.60,73175.60,0.00,0.00,230.00,154100.00,0.00,0.00,0.00),('1','187','939','239918',4599177,'2760','418',637982.06,638374.31,0.00,0.00,392.25,282420.00,0.00,0.00,0.00),('1','187','939','239918',4599178,'2761','418',240314.56,241132.59,0.00,0.00,818.03,546080.10,0.00,0.00,0.00),('1','187','939','239918',4599179,'2762','418',169837.03,170167.07,0.00,0.00,330.04,220126.60,0.00,0.00,0.00),('1','187','939','239918',4599180,'2763','418',139677.21,140163.21,0.00,0.00,486.00,324620.50,0.00,0.00,0.00),('1','187','939','239918',4599181,'2764','418',109213.24,109538.24,0.00,0.00,325.00,216375.00,0.00,0.00,0.00),('1','187','939','239918',4599182,'2765','418',73175.60,73580.60,0.00,0.00,405.00,270100.00,0.00,0.00,0.00),('1','187','939','239919',4599183,'2760','418',638374.31,638575.59,0.00,0.00,201.28,144921.60,0.00,0.00,0.00),('1','187','939','239919',4599184,'2761','418',241132.59,242109.16,0.00,0.00,976.57,654301.90,0.00,0.00,0.00),('1','187','939','239919',4599185,'2762','418',170167.07,170930.10,0.00,0.00,763.03,511230.10,0.00,0.00,0.00),('1','187','939','239919',4599186,'2763','418',140163.21,140731.21,0.00,0.00,568.00,380560.00,0.00,0.00,0.00),('1','187','939','239919',4599187,'2764','418',109538.24,110104.24,0.00,0.00,566.00,379220.00,0.00,0.00,0.00),('1','187','939','239919',4599188,'2765','418',73580.60,73954.60,0.00,0.00,374.00,250580.00,0.00,0.00,0.00),('1','187','939','239920',4599189,'2760','418',638575.59,638575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239920',4599190,'2761','418',242109.16,242109.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239920',4599191,'2762','418',170930.10,170930.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239920',4599192,'2763','418',140731.21,140731.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239920',4599193,'2764','418',110104.24,110104.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239920',4599194,'2765','418',73954.60,73954.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239921',4599195,'2760','418',638575.59,639067.88,0.00,0.00,492.29,368967.30,0.00,0.00,0.00),('1','187','939','239921',4599196,'2761','418',242109.16,243859.16,0.00,0.00,1750.00,1181250.00,0.00,0.00,0.00),('1','187','939','239921',4599197,'2762','418',170930.10,171778.10,0.00,0.00,848.00,572400.00,0.00,0.00,0.00),('1','187','939','239921',4599198,'2763','418',140731.21,141791.21,0.00,0.00,1060.00,715500.00,0.00,0.00,0.00),('1','187','939','239921',4599199,'2764','418',110104.24,111099.24,0.00,0.00,995.00,671625.00,0.00,0.00,0.00),('1','187','939','239921',4599200,'2765','418',73954.60,74974.60,0.00,0.00,1020.00,688500.00,0.00,0.00,0.00),('1','187','939','239922',4599201,'2760','418',639067.88,639553.45,0.00,0.00,485.57,364177.50,0.00,0.00,0.00),('1','187','939','239922',4599202,'2761','418',243859.16,245609.16,0.00,0.00,1750.00,1175750.00,0.00,0.00,0.00),('1','187','939','239922',4599203,'2762','418',171778.10,173807.85,0.00,0.00,2029.75,1366581.25,0.00,0.00,0.00),('1','187','939','239922',4599204,'2763','418',141791.21,142756.36,0.00,0.00,965.15,649226.25,0.00,0.00,0.00),('1','187','939','239922',4599205,'2764','418',111099.24,112539.24,0.00,0.00,1440.00,970750.00,0.00,0.00,0.00),('1','187','939','239922',4599206,'2765','418',74974.60,75884.60,0.00,0.00,910.00,610250.00,0.00,0.00,0.00),('1','187','939','239923',4599207,'2760','418',639553.45,639971.27,0.00,0.00,417.82,313365.00,0.00,0.00,0.00),('1','187','939','239923',4599208,'2761','418',245609.16,246009.16,0.00,0.00,400.00,270000.00,0.00,0.00,0.00),('1','187','939','239923',4599209,'2762','418',173807.85,174273.04,0.00,0.00,465.19,314003.25,0.00,0.00,0.00),('1','187','939','239923',4599210,'2763','418',142756.36,143088.58,0.00,0.00,332.22,224248.50,0.00,0.00,0.00),('1','187','939','239923',4599211,'2764','418',112539.24,112840.24,0.00,0.00,301.00,203175.00,0.00,0.00,0.00),('1','187','939','239923',4599212,'2765','418',75884.60,76224.60,0.00,0.00,340.00,229500.00,0.00,0.00,0.00),('1','187','939','239924',4599213,'2760','418',639971.27,640373.87,0.00,0.00,402.60,301950.00,0.00,0.00,0.00),('1','187','939','239924',4599214,'2761','418',246009.16,247343.31,0.00,0.00,1334.15,900551.25,0.00,0.00,0.00),('1','187','939','239924',4599215,'2762','418',174273.04,175391.04,0.00,0.00,1118.00,754650.00,0.00,0.00,0.00),('1','187','939','239924',4599216,'2763','418',143088.58,144128.58,0.00,0.00,1040.00,702000.00,0.00,0.00,0.00),('1','187','939','239924',4599217,'2764','418',112840.24,114190.24,0.00,0.00,1350.00,911250.00,0.00,0.00,0.00),('1','187','939','239924',4599218,'2765','418',76224.60,76724.60,0.00,0.00,500.00,337500.00,0.00,0.00,0.00),('1','187','939','239925',4599219,'2760','418',640373.87,640464.97,0.00,0.00,91.10,68325.00,0.00,0.00,0.00),('1','187','939','239925',4599220,'2761','418',247343.31,248451.27,0.00,0.00,1107.96,747873.00,0.00,0.00,0.00),('1','187','939','239925',4599221,'2762','418',175391.04,175715.04,0.00,0.00,324.00,218700.00,0.00,0.00,0.00),('1','187','939','239925',4599222,'2763','418',144128.58,144705.08,0.00,0.00,576.50,389137.50,0.00,0.00,0.00),('1','187','939','239925',4599223,'2764','418',114190.24,114683.24,0.00,0.00,493.00,332775.00,0.00,0.00,0.00),('1','187','939','239925',4599224,'2765','418',76724.60,76928.60,0.00,0.00,204.00,137700.00,0.00,0.00,0.00),('1','187','939','239926',4599225,'2760','418',640464.97,640464.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239926',4599226,'2761','418',248451.27,248451.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239926',4599227,'2762','418',175715.04,175715.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239926',4599228,'2763','418',144705.08,144705.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239926',4599229,'2764','418',114683.24,114683.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239926',4599230,'2765','418',76928.60,76928.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239927',4599231,'2760','418',640464.97,640763.89,0.00,0.00,298.92,224190.00,0.00,0.00,0.00),('1','187','939','239927',4599232,'2761','418',248451.27,249600.77,0.00,0.00,1149.50,775912.50,0.00,0.00,0.00),('1','187','939','239927',4599233,'2762','418',175715.04,176220.04,0.00,0.00,505.00,340875.00,0.00,0.00,0.00),('1','187','939','239927',4599234,'2763','418',144705.08,145297.08,0.00,0.00,592.00,399600.00,0.00,0.00,0.00),('1','187','939','239927',4599235,'2764','418',114683.24,115119.24,0.00,0.00,436.00,294300.00,0.00,0.00,0.00),('1','187','939','239927',4599236,'2765','418',76928.60,77432.60,0.00,0.00,504.00,340200.00,0.00,0.00,0.00),('1','187','939','239928',4599237,'2760','418',640763.89,640986.47,0.00,0.00,222.58,166935.00,0.00,0.00,0.00),('1','187','939','239928',4599238,'2761','418',249600.77,251033.29,0.00,0.00,1432.52,965451.00,0.00,0.00,0.00),('1','187','939','239928',4599239,'2762','418',176220.04,176955.04,0.00,0.00,735.00,494875.00,0.00,0.00,0.00),('1','187','939','239928',4599240,'2763','418',145297.08,146001.71,0.00,0.00,704.63,475625.25,0.00,0.00,0.00),('1','187','939','239928',4599241,'2764','418',115119.24,116069.24,0.00,0.00,950.00,640250.00,0.00,0.00,0.00),('1','187','939','239928',4599242,'2765','418',77432.60,78127.60,0.00,0.00,695.00,467875.00,0.00,0.00,0.00),('1','187','939','239929',4599243,'2760','418',640986.47,641173.06,0.00,0.00,186.59,139942.50,0.00,0.00,0.00),('1','187','939','239929',4599244,'2761','418',251033.29,252549.29,0.00,0.00,1516.00,1023300.00,0.00,0.00,0.00),('1','187','939','239929',4599245,'2762','418',176955.04,177295.32,0.00,0.00,340.28,229689.00,0.00,0.00,0.00),('1','187','939','239929',4599246,'2763','418',146001.71,147040.71,0.00,0.00,1039.00,701325.00,0.00,0.00,0.00),('1','187','939','239929',4599247,'2764','418',116069.24,116884.74,0.00,0.00,815.50,550462.50,0.00,0.00,0.00),('1','187','939','239929',4599248,'2765','418',78127.60,78482.60,0.00,0.00,355.00,239625.00,0.00,0.00,0.00),('1','187','939','239930',4599249,'2760','418',641173.06,641535.14,0.00,0.00,362.08,271560.00,0.00,0.00,0.00),('1','187','939','239930',4599250,'2761','418',252549.29,253503.29,0.00,0.00,954.00,643950.00,0.00,0.00,0.00),('1','187','939','239930',4599251,'2762','418',177295.32,177875.32,0.00,0.00,580.00,391500.00,0.00,0.00,0.00),('1','187','939','239930',4599252,'2763','418',147040.71,147749.90,0.00,0.00,709.19,478703.25,0.00,0.00,0.00),('1','187','939','239930',4599253,'2764','418',116884.74,117274.74,0.00,0.00,390.00,263250.00,0.00,0.00,0.00),('1','187','939','239930',4599254,'2765','418',78482.60,78896.60,0.00,0.00,414.00,279450.00,0.00,0.00,0.00),('1','187','939','239931',4599255,'2760','418',641535.14,641887.88,0.00,0.00,352.74,264555.00,0.00,0.00,0.00),('1','187','939','239931',4599256,'2761','418',253503.29,255273.29,0.00,0.00,1770.00,1191800.00,0.00,0.00,0.00),('1','187','939','239931',4599257,'2762','418',177875.32,178347.13,0.00,0.00,471.81,316902.70,0.00,0.00,0.00),('1','187','939','239931',4599258,'2763','418',147749.90,148674.92,0.00,0.00,925.02,622788.20,0.00,0.00,0.00),('1','187','939','239931',4599259,'2764','418',117274.74,118264.59,0.00,0.00,989.85,665778.75,0.00,0.00,0.00),('1','187','939','239931',4599260,'2765','418',78896.60,79372.60,0.00,0.00,476.00,319220.00,0.00,0.00,0.00),('1','187','939','239932',4599261,'2760','418',641887.88,642014.33,0.00,0.00,126.45,94837.50,0.00,0.00,0.00),('1','187','939','239932',4599262,'2761','418',255273.29,256598.29,0.00,0.00,1325.00,894375.00,0.00,0.00,0.00),('1','187','939','239932',4599263,'2762','418',178347.13,178742.13,0.00,0.00,395.00,266625.00,0.00,0.00,0.00),('1','187','939','239932',4599264,'2763','418',148674.92,149124.92,0.00,0.00,450.00,303750.00,0.00,0.00,0.00),('1','187','939','239932',4599265,'2764','418',118264.59,119239.59,0.00,0.00,975.00,658125.00,0.00,0.00,0.00),('1','187','939','239932',4599266,'2765','418',79372.60,79975.60,0.00,0.00,603.00,407025.00,0.00,0.00,0.00),('1','187','939','239933',4599267,'2760','418',642014.33,642014.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239933',4599268,'2761','418',256598.29,256598.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239933',4599269,'2762','418',178742.13,178742.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239933',4599270,'2763','418',149124.92,149124.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239933',4599271,'2764','418',119239.59,119239.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239933',4599272,'2765','418',79975.60,79975.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239934',4599273,'2760','418',642014.33,642391.54,0.00,0.00,377.21,282907.50,0.00,0.00,0.00),('1','187','939','239934',4599274,'2761','418',256598.29,259280.77,0.00,0.00,2682.48,1809974.00,0.00,0.00,0.00),('1','187','939','239934',4599275,'2762','418',178742.13,180417.48,0.00,0.00,1675.35,1130261.25,0.00,0.00,0.00),('1','187','939','239934',4599276,'2763','418',149124.92,150968.92,0.00,0.00,1844.00,1243900.00,0.00,0.00,0.00),('1','187','939','239934',4599277,'2764','418',119239.59,120836.59,0.00,0.00,1597.00,1077375.00,0.00,0.00,0.00),('1','187','939','239934',4599278,'2765','418',79975.60,81640.60,0.00,0.00,1665.00,1123275.00,0.00,0.00,0.00),('1','187','939','239935',4599279,'2760','418',642391.54,642684.34,0.00,0.00,292.80,219600.00,0.00,0.00,0.00),('1','187','939','239935',4599280,'2761','418',259280.77,260185.27,0.00,0.00,904.50,610537.50,0.00,0.00,0.00),('1','187','939','239935',4599281,'2762','418',180417.48,180973.48,0.00,0.00,556.00,375300.00,0.00,0.00,0.00),('1','187','939','239935',4599282,'2763','418',150968.92,151625.92,0.00,0.00,657.00,443475.00,0.00,0.00,0.00),('1','187','939','239935',4599283,'2764','418',120836.59,121461.59,0.00,0.00,625.00,421875.00,0.00,0.00,0.00),('1','187','939','239935',4599284,'2765','418',81640.60,82100.60,0.00,0.00,460.00,310500.00,0.00,0.00,0.00),('1','187','939','239936',4599285,'2760','418',642684.34,642987.40,0.00,0.00,303.06,227295.00,0.00,0.00,0.00),('1','187','939','239936',4599286,'2761','418',260185.27,260992.77,0.00,0.00,807.50,545062.50,0.00,0.00,0.00),('1','187','939','239936',4599287,'2762','418',180973.48,181263.48,0.00,0.00,290.00,195750.00,0.00,0.00,0.00),('1','187','939','239936',4599288,'2763','418',151625.92,152035.92,0.00,0.00,410.00,276750.00,0.00,0.00,0.00),('1','187','939','239936',4599289,'2764','418',121461.59,121940.59,0.00,0.00,479.00,323325.00,0.00,0.00,0.00),('1','187','939','239936',4599290,'2765','418',82100.60,82383.60,0.00,0.00,283.00,191025.00,0.00,0.00,0.00),('1','187','939','239937',4599291,'2760','418',642987.40,643255.61,0.00,0.00,268.21,201157.50,0.00,0.00,0.00),('1','187','939','239937',4599292,'2761','418',260992.77,262122.77,0.00,0.00,1130.00,762750.00,0.00,0.00,0.00),('1','187','939','239937',4599293,'2762','418',181263.48,181855.48,0.00,0.00,592.00,399600.00,0.00,0.00,0.00),('1','187','939','239937',4599294,'2763','418',152035.92,152655.92,0.00,0.00,620.00,418500.00,0.00,0.00,0.00),('1','187','939','239937',4599295,'2764','418',121940.59,122721.59,0.00,0.00,781.00,527175.00,0.00,0.00,0.00),('1','187','939','239937',4599296,'2765','418',82383.60,82962.34,0.00,0.00,578.74,390649.50,0.00,0.00,0.00),('1','187','939','239938',4599297,'2760','418',643255.61,643491.38,0.00,0.00,235.77,176827.50,0.00,0.00,0.00),('1','187','939','239938',4599298,'2761','418',262122.77,262752.77,0.00,0.00,630.00,425250.00,0.00,0.00,0.00),('1','187','939','239938',4599299,'2762','418',181855.48,182720.48,0.00,0.00,865.00,583875.00,0.00,0.00,0.00),('1','187','939','239938',4599300,'2763','418',152655.92,153170.92,0.00,0.00,515.00,347625.00,0.00,0.00,0.00),('1','187','939','239938',4599301,'2764','418',122721.59,123298.59,0.00,0.00,577.00,389475.00,0.00,0.00,0.00),('1','187','939','239938',4599302,'2765','418',82962.34,83587.34,0.00,0.00,625.00,421875.00,0.00,0.00,0.00),('1','187','939','239939',4599303,'2760','418',643491.38,643549.58,0.00,0.00,58.20,43650.00,0.00,0.00,0.00),('1','187','939','239939',4599304,'2761','418',262752.77,263402.77,0.00,0.00,650.00,437300.00,0.00,0.00,0.00),('1','187','939','239939',4599305,'2762','418',182720.48,182770.48,0.00,0.00,50.00,33750.00,0.00,0.00,0.00),('1','187','939','239939',4599306,'2763','418',153170.92,153344.92,0.00,0.00,174.00,116580.00,0.00,0.00,0.00),('1','187','939','239939',4599307,'2764','418',123298.59,123522.59,0.00,0.00,224.00,150330.00,0.00,0.00,0.00),('1','187','939','239939',4599308,'2765','418',83587.34,83811.34,0.00,0.00,224.00,150330.00,0.00,0.00,0.00),('1','187','939','239940',4599309,'2760','418',643549.58,643549.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239940',4599310,'2761','418',263402.77,263402.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239940',4599311,'2762','418',182770.48,182770.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239940',4599312,'2763','418',153344.92,153344.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239940',4599313,'2764','418',123522.59,123522.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239940',4599314,'2765','418',83811.34,83811.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239941',4599315,'2760','418',643549.58,643836.46,0.00,0.00,286.88,215160.00,0.00,0.00,0.00),('1','187','939','239941',4599316,'2761','418',263402.77,265717.67,0.00,0.00,2314.90,1561307.50,0.00,0.00,0.00),('1','187','939','239941',4599317,'2762','418',182770.48,183671.15,0.00,0.00,900.67,605953.90,0.00,0.00,0.00),('1','187','939','239941',4599318,'2763','418',153344.92,154956.92,0.00,0.00,1612.00,1088100.00,0.00,0.00,0.00),('1','187','939','239941',4599319,'2764','418',123522.59,125006.59,0.00,0.00,1484.00,998700.00,0.00,0.00,0.00),('1','187','939','239941',4599320,'2765','418',83811.34,85203.34,0.00,0.00,1392.00,937600.00,0.00,0.00,0.00),('1','187','939','239942',4599321,'2760','418',643836.46,643931.04,0.00,0.00,94.58,70935.00,0.00,0.00,0.00),('1','187','939','239942',4599322,'2761','418',265717.67,266396.67,0.00,0.00,679.00,458325.00,0.00,0.00,0.00),('1','187','939','239942',4599323,'2762','418',183671.15,184015.15,0.00,0.00,344.00,232200.00,0.00,0.00,0.00),('1','187','939','239942',4599324,'2763','418',154956.92,155251.92,0.00,0.00,295.00,199125.00,0.00,0.00,0.00),('1','187','939','239942',4599325,'2764','418',125006.59,125463.59,0.00,0.00,457.00,308475.00,0.00,0.00,0.00),('1','187','939','239942',4599326,'2765','418',85203.34,85423.06,0.00,0.00,219.72,148311.00,0.00,0.00,0.00),('1','187','939','239943',4599327,'2760','418',643931.04,644121.33,0.00,0.00,190.29,142717.50,0.00,0.00,0.00),('1','187','939','239943',4599328,'2761','418',266396.67,267396.04,0.00,0.00,999.37,674574.75,0.00,0.00,0.00),('1','187','939','239943',4599329,'2762','418',184015.15,184643.71,0.00,0.00,628.56,424278.00,0.00,0.00,0.00),('1','187','939','239943',4599330,'2763','418',155251.92,155803.52,0.00,0.00,551.60,372330.00,0.00,0.00,0.00),('1','187','939','239943',4599331,'2764','418',125463.59,126134.59,0.00,0.00,671.00,452925.00,0.00,0.00,0.00),('1','187','939','239943',4599332,'2765','418',85423.06,86073.06,0.00,0.00,650.00,438750.00,0.00,0.00,0.00),('1','187','939','239944',4599333,'2760','418',644121.33,644236.12,0.00,0.00,114.79,86092.50,0.00,0.00,0.00),('1','187','939','239944',4599334,'2761','418',267396.04,267861.04,0.00,0.00,465.00,313875.00,0.00,0.00,0.00),('1','187','939','239944',4599335,'2762','418',184643.71,184963.71,0.00,0.00,320.00,216000.00,0.00,0.00,0.00),('1','187','939','239944',4599336,'2763','418',155803.52,156176.52,0.00,0.00,373.00,251775.00,0.00,0.00,0.00),('1','187','939','239944',4599337,'2764','418',126134.59,126734.59,0.00,0.00,600.00,405000.00,0.00,0.00,0.00),('1','187','939','239944',4599338,'2765','418',86073.06,86482.06,0.00,0.00,409.00,276075.00,0.00,0.00,0.00),('1','187','939','239945',4599339,'2760','418',644236.12,644546.70,0.00,0.00,310.58,232935.00,0.00,0.00,0.00),('1','187','939','239945',4599340,'2761','418',267861.04,269790.04,0.00,0.00,1929.00,1302075.00,0.00,0.00,0.00),('1','187','939','239945',4599341,'2762','418',184963.71,185163.71,0.00,0.00,200.00,135000.00,0.00,0.00,0.00),('1','187','939','239945',4599342,'2763','418',156176.52,157057.52,0.00,0.00,881.00,594675.00,0.00,0.00,0.00),('1','187','939','239945',4599343,'2764','418',126734.59,128199.59,0.00,0.00,1465.00,988875.00,0.00,0.00,0.00),('1','187','939','239945',4599344,'2765','418',86482.06,87132.06,0.00,0.00,650.00,438750.00,0.00,0.00,0.00),('1','187','939','239946',4599345,'2760','418',644546.70,644707.35,0.00,0.00,160.65,120487.50,0.00,0.00,0.00),('1','187','939','239946',4599346,'2761','418',269790.04,270777.04,0.00,0.00,987.00,663895.00,0.00,0.00,0.00),('1','187','939','239946',4599347,'2762','418',185163.71,185343.71,0.00,0.00,180.00,121500.00,0.00,0.00,0.00),('1','187','939','239946',4599348,'2763','418',157057.52,157639.52,0.00,0.00,582.00,391440.00,0.00,0.00,0.00),('1','187','939','239946',4599349,'2764','418',128199.59,128947.59,0.00,0.00,748.00,502240.00,0.00,0.00,0.00),('1','187','939','239946',4599350,'2765','418',87132.06,87699.06,0.00,0.00,567.00,380265.00,0.00,0.00,0.00),('1','187','939','239947',4599351,'2760','418',644707.35,644707.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239947',4599352,'2761','418',270777.04,270777.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239947',4599353,'2762','418',185343.71,185343.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239947',4599354,'2763','418',157639.52,157639.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239947',4599355,'2764','418',128947.59,128947.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239947',4599356,'2765','418',87699.06,87699.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239948',4599357,'2760','418',644707.35,644957.05,0.00,0.00,249.70,187275.00,0.00,0.00,0.00),('1','187','939','239948',4599358,'2761','418',270777.04,272364.04,0.00,0.00,1587.00,1068725.00,0.00,0.00,0.00),('1','187','939','239948',4599359,'2762','418',185343.71,185979.71,0.00,0.00,636.00,429300.00,0.00,0.00,0.00),('1','187','939','239948',4599360,'2763','418',157639.52,158639.52,0.00,0.00,1000.00,675000.00,0.00,0.00,0.00),('1','187','939','239948',4599361,'2764','418',128947.59,129979.59,0.00,0.00,1032.00,695100.00,0.00,0.00,0.00),('1','187','939','239948',4599362,'2765','418',87699.06,88838.00,0.00,0.00,1138.94,767785.90,0.00,0.00,0.00),('1','187','939','239949',4599363,'2760','418',644957.05,645406.27,0.00,0.00,449.22,336915.00,0.00,0.00,0.00),('1','187','939','239949',4599364,'2761','418',272364.04,274125.21,0.00,0.00,1761.17,1188789.75,0.00,0.00,0.00),('1','187','939','239949',4599365,'2762','418',185979.71,186509.71,0.00,0.00,530.00,357750.00,0.00,0.00,0.00),('1','187','939','239949',4599366,'2763','418',158639.52,159590.52,0.00,0.00,951.00,641925.00,0.00,0.00,0.00),('1','187','939','239949',4599367,'2764','418',129979.59,131104.59,0.00,0.00,1125.00,759375.00,0.00,0.00,0.00),('1','187','939','239949',4599368,'2765','418',88838.00,89446.00,0.00,0.00,608.00,410400.00,0.00,0.00,0.00),('1','187','939','239950',4599369,'2760','418',645406.27,645764.52,0.00,0.00,358.25,268687.50,0.00,0.00,0.00),('1','187','939','239950',4599370,'2761','418',274125.21,275133.21,0.00,0.00,1008.00,680400.00,0.00,0.00,0.00),('1','187','939','239950',4599371,'2762','418',186509.71,187210.52,0.00,0.00,700.81,473046.75,0.00,0.00,0.00),('1','187','939','239950',4599372,'2763','418',159590.52,160028.52,0.00,0.00,438.00,295650.00,0.00,0.00,0.00),('1','187','939','239950',4599373,'2764','418',131104.59,131994.59,0.00,0.00,890.00,600750.00,0.00,0.00,0.00),('1','187','939','239950',4599374,'2765','418',89446.00,90196.00,0.00,0.00,750.00,506250.00,0.00,0.00,0.00),('1','187','939','239951',4599375,'2760','418',645764.52,646065.23,0.00,0.00,300.71,225532.50,0.00,0.00,0.00),('1','187','939','239951',4599376,'2761','418',275133.21,276543.21,0.00,0.00,1410.00,951750.00,0.00,0.00,0.00),('1','187','939','239951',4599377,'2762','418',187210.52,187706.52,0.00,0.00,496.00,334800.00,0.00,0.00,0.00),('1','187','939','239951',4599378,'2763','418',160028.52,160608.52,0.00,0.00,580.00,391500.00,0.00,0.00,0.00),('1','187','939','239951',4599379,'2764','418',131994.59,133294.59,0.00,0.00,1300.00,877500.00,0.00,0.00,0.00),('1','187','939','239951',4599380,'2765','418',90196.00,90696.00,0.00,0.00,500.00,337500.00,0.00,0.00,0.00),('1','187','939','239952',4599381,'2760','418',646065.23,646212.89,0.00,0.00,147.66,110745.00,0.00,0.00,0.00),('1','187','939','239952',4599382,'2761','418',276543.21,278288.21,0.00,0.00,1745.00,1175375.00,0.00,0.00,0.00),('1','187','939','239952',4599383,'2762','418',187706.52,187769.52,0.00,0.00,63.00,42525.00,0.00,0.00,0.00),('1','187','939','239952',4599384,'2763','418',160608.52,161935.52,0.00,0.00,1327.00,895725.00,0.00,0.00,0.00),('1','187','939','239952',4599385,'2764','418',133294.59,134044.59,0.00,0.00,750.00,503750.00,0.00,0.00,0.00),('1','187','939','239952',4599386,'2765','418',90696.00,91416.00,0.00,0.00,720.00,484500.00,0.00,0.00,0.00),('1','187','939','239953',4599387,'2760','418',646212.89,646212.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239953',4599388,'2761','418',278288.21,278288.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239953',4599389,'2762','418',187769.52,187769.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239953',4599390,'2763','418',161935.52,161935.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239953',4599391,'2764','418',134044.59,134044.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239953',4599392,'2765','418',91416.00,91416.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239954',4599393,'2760','418',646212.89,646381.61,0.00,0.00,168.72,126540.00,0.00,0.00,0.00),('1','187','939','239954',4599394,'2761','418',278288.21,278925.21,0.00,0.00,637.00,429975.00,0.00,0.00,0.00),('1','187','939','239954',4599395,'2762','418',187769.52,188325.52,0.00,0.00,556.00,375300.00,0.00,0.00,0.00),('1','187','939','239954',4599396,'2763','418',161935.52,162460.52,0.00,0.00,525.00,354375.00,0.00,0.00,0.00),('1','187','939','239954',4599397,'2764','418',134044.59,134644.59,0.00,0.00,600.00,405000.00,0.00,0.00,0.00),('1','187','939','239954',4599398,'2765','418',91416.00,92121.00,0.00,0.00,705.00,475875.00,0.00,0.00,0.00),('1','187','939','239955',4599399,'2760','418',646381.61,646809.34,0.00,0.00,427.73,320797.50,0.00,0.00,0.00),('1','187','939','239955',4599400,'2761','418',278925.21,280782.21,0.00,0.00,1857.00,1251475.00,0.00,0.00,0.00),('1','187','939','239955',4599401,'2762','418',188325.52,189710.52,0.00,0.00,1385.00,934625.00,0.00,0.00,0.00),('1','187','939','239955',4599402,'2763','418',162460.52,163594.52,0.00,0.00,1134.00,765200.00,0.00,0.00,0.00),('1','187','939','239955',4599403,'2764','418',134644.59,136012.09,0.00,0.00,1367.50,922562.50,0.00,0.00,0.00),('1','187','939','239955',4599404,'2765','418',92121.00,93328.50,0.00,0.00,1207.50,813562.50,0.00,0.00,0.00),('1','187','939','239956',4599405,'2760','418',646809.34,647160.80,0.00,0.00,351.46,263595.00,0.00,0.00,0.00),('1','187','939','239956',4599406,'2761','418',280782.21,283169.21,0.00,0.00,2387.00,1609755.00,0.00,0.00,0.00),('1','187','939','239956',4599407,'2762','418',189710.52,190331.52,0.00,0.00,621.00,418435.00,0.00,0.00,0.00),('1','187','939','239956',4599408,'2763','418',163594.52,164514.52,0.00,0.00,920.00,620265.00,0.00,0.00,0.00),('1','187','939','239956',4599409,'2764','418',136012.09,137592.09,0.00,0.00,1580.00,1064390.00,0.00,0.00,0.00),('1','187','939','239956',4599410,'2765','418',93328.50,94368.50,0.00,0.00,1040.00,699550.00,0.00,0.00,0.00),('1','187','939','239957',4599411,'2760','418',647160.80,647461.38,0.00,0.00,300.58,225435.00,0.00,0.00,0.00),('1','187','939','239957',4599412,'2761','418',283169.21,283954.21,0.00,0.00,785.00,529875.00,0.00,0.00,0.00),('1','187','939','239957',4599413,'2762','418',190331.52,191091.52,0.00,0.00,760.00,513000.00,0.00,0.00,0.00),('1','187','939','239957',4599414,'2763','418',164514.52,165094.52,0.00,0.00,580.00,391500.00,0.00,0.00,0.00),('1','187','939','239957',4599415,'2764','418',137592.09,138646.09,0.00,0.00,1054.00,711450.00,0.00,0.00,0.00),('1','187','939','239957',4599416,'2765','418',94368.50,95018.50,0.00,0.00,650.00,438750.00,0.00,0.00,0.00),('1','187','939','239958',4599417,'2760','418',647461.38,647563.44,0.00,0.00,102.06,76545.00,0.00,0.00,0.00),('1','187','939','239958',4599418,'2761','418',283954.21,284826.21,0.00,0.00,872.00,587440.00,0.00,0.00,0.00),('1','187','939','239958',4599419,'2762','418',191091.52,191712.52,0.00,0.00,621.00,418595.00,0.00,0.00,0.00),('1','187','939','239958',4599420,'2763','418',165094.52,165544.52,0.00,0.00,450.00,303750.00,0.00,0.00,0.00),('1','187','939','239958',4599421,'2764','418',138646.09,139178.09,0.00,0.00,532.00,357940.00,0.00,0.00,0.00),('1','187','939','239958',4599422,'2765','418',95018.50,95700.50,0.00,0.00,682.00,459190.00,0.00,0.00,0.00),('1','187','939','239959',4599423,'2760','418',647563.44,647563.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239959',4599424,'2761','418',284826.21,284826.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239959',4599425,'2762','418',191712.52,191712.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239959',4599426,'2763','418',165544.52,165544.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239959',4599427,'2764','418',139178.09,139178.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239959',4599428,'2765','418',95700.50,95700.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239960',4599429,'2760','418',647563.44,647991.23,0.00,0.00,427.79,320842.50,0.00,0.00,0.00),('1','187','939','239960',4599430,'2761','418',284826.21,286790.49,0.00,0.00,1964.28,1322063.00,0.00,0.00,0.00),('1','187','939','239960',4599431,'2762','418',191712.52,192178.37,0.00,0.00,465.85,313572.10,0.00,0.00,0.00),('1','187','939','239960',4599432,'2763','418',165544.52,167145.59,0.00,0.00,1601.07,1078641.90,0.00,0.00,0.00),('1','187','939','239960',4599433,'2764','418',139178.09,140938.09,0.00,0.00,1760.00,1184800.00,0.00,0.00,0.00),('1','187','939','239960',4599434,'2765','418',95700.50,96864.89,0.00,0.00,1164.39,782641.30,0.00,0.00,0.00),('1','187','939','239961',4599435,'2760','418',647991.23,648377.45,0.00,0.00,386.22,289665.00,0.00,0.00,0.00),('1','187','939','239961',4599436,'2761','418',286790.49,287424.49,0.00,0.00,634.00,427950.00,0.00,0.00,0.00),('1','187','939','239961',4599437,'2762','418',192178.37,192801.37,0.00,0.00,623.00,420525.00,0.00,0.00,0.00),('1','187','939','239961',4599438,'2763','418',167145.59,167789.59,0.00,0.00,644.00,434700.00,0.00,0.00,0.00),('1','187','939','239961',4599439,'2764','418',140938.09,141628.09,0.00,0.00,690.00,465750.00,0.00,0.00,0.00),('1','187','939','239961',4599440,'2765','418',96864.89,97489.89,0.00,0.00,625.00,421875.00,0.00,0.00,0.00),('1','187','939','239962',4599441,'2760','418',648377.45,648620.01,0.00,0.00,242.56,181920.00,0.00,0.00,0.00),('1','187','939','239962',4599442,'2761','418',287424.49,288550.42,0.00,0.00,1125.93,756602.75,0.00,0.00,0.00),('1','187','939','239962',4599443,'2762','418',192801.37,193101.37,0.00,0.00,300.00,202500.00,0.00,0.00,0.00),('1','187','939','239962',4599444,'2763','418',167789.59,168514.24,0.00,0.00,724.65,487715.50,0.00,0.00,0.00),('1','187','939','239962',4599445,'2764','418',141628.09,142217.96,0.00,0.00,589.87,396062.90,0.00,0.00,0.00),('1','187','939','239962',4599446,'2765','418',97489.89,98149.88,0.00,0.00,659.99,443443.30,0.00,0.00,0.00),('1','187','939','239963',4599447,'2760','418',648620.01,649004.19,0.00,0.00,384.18,288135.00,0.00,0.00,0.00),('1','187','939','239963',4599448,'2761','418',288550.42,290782.42,0.00,0.00,2232.00,1504850.00,0.00,0.00,0.00),('1','187','939','239963',4599449,'2762','418',193101.37,193661.37,0.00,0.00,560.00,378000.00,0.00,0.00,0.00),('1','187','939','239963',4599450,'2763','418',168514.24,169768.24,0.00,0.00,1254.00,845200.00,0.00,0.00,0.00),('1','187','939','239963',4599451,'2764','418',142217.96,143475.96,0.00,0.00,1258.00,848150.00,0.00,0.00,0.00),('1','187','939','239963',4599452,'2765','418',98149.88,98799.88,0.00,0.00,650.00,437750.00,0.00,0.00,0.00),('1','187','939','239964',4599453,'2760','418',649004.19,649079.10,0.00,0.00,74.91,56182.50,0.00,0.00,0.00),('1','187','939','239964',4599454,'2761','418',290782.42,291817.42,0.00,0.00,1035.00,698375.00,0.00,0.00,0.00),('1','187','939','239964',4599455,'2762','418',193661.37,194391.37,0.00,0.00,730.00,492750.00,0.00,0.00,0.00),('1','187','939','239964',4599456,'2763','418',169768.24,170224.24,0.00,0.00,456.00,307800.00,0.00,0.00,0.00),('1','187','939','239964',4599457,'2764','418',143475.96,144235.96,0.00,0.00,760.00,513000.00,0.00,0.00,0.00),('1','187','939','239964',4599458,'2765','418',98799.88,99399.88,0.00,0.00,600.00,405000.00,0.00,0.00,0.00),('1','187','939','239965',4599459,'2760','418',649079.10,649079.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239965',4599460,'2761','418',291817.42,291817.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239965',4599461,'2762','418',194391.37,194391.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239965',4599462,'2763','418',170224.24,170224.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239965',4599463,'2764','418',144235.96,144235.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239965',4599464,'2765','418',99399.88,99399.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239966',4599465,'2760','418',649079.10,649554.09,0.00,0.00,474.99,356242.50,0.00,0.00,0.00),('1','187','939','239966',4599466,'2761','418',291817.42,294234.42,0.00,0.00,2417.00,1607305.00,0.00,0.00,0.00),('1','187','939','239966',4599467,'2762','418',194391.37,195016.37,0.00,0.00,625.00,415625.00,0.00,0.00,0.00),('1','187','939','239966',4599468,'2763','418',170224.24,171817.42,0.00,0.00,1593.18,1059464.70,0.00,0.00,0.00),('1','187','939','239966',4599469,'2764','418',144235.96,146001.00,0.00,0.00,1765.04,1173751.60,0.00,0.00,0.00),('1','187','939','239966',4599470,'2765','418',99399.88,100718.22,0.00,0.00,1318.34,876696.10,0.00,0.00,0.00),('1','187','939','239967',4599471,'2760','418',649554.09,649938.02,0.00,0.00,383.93,287947.50,0.00,0.00,0.00),('1','187','939','239967',4599472,'2761','418',294234.42,297209.42,0.00,0.00,2975.00,1978375.00,0.00,0.00,0.00),('1','187','939','239967',4599473,'2762','418',195016.37,196116.37,0.00,0.00,1100.00,731500.00,0.00,0.00,0.00),('1','187','939','239967',4599474,'2763','418',171817.42,173534.20,0.00,0.00,1716.78,1141658.70,0.00,0.00,0.00),('1','187','939','239967',4599475,'2764','418',146001.00,147986.00,0.00,0.00,1985.00,1320025.00,0.00,0.00,0.00),('1','187','939','239967',4599476,'2765','418',100718.22,102218.17,0.00,0.00,1499.95,997466.75,0.00,0.00,0.00),('1','187','939','239968',4599477,'2760','418',649938.02,650307.10,0.00,0.00,369.08,276810.00,0.00,0.00,0.00),('1','187','939','239968',4599478,'2761','418',297209.42,298980.55,0.00,0.00,1771.13,1177801.45,0.00,0.00,0.00),('1','187','939','239968',4599479,'2762','418',196116.37,196167.97,0.00,0.00,51.60,34314.00,0.00,0.00,0.00),('1','187','939','239968',4599480,'2763','418',173534.20,174734.20,0.00,0.00,1200.00,798000.00,0.00,0.00,0.00),('1','187','939','239968',4599481,'2764','418',147986.00,149161.00,0.00,0.00,1175.00,781375.00,0.00,0.00,0.00),('1','187','939','239968',4599482,'2765','418',102218.17,102418.34,0.00,0.00,200.17,133113.05,0.00,0.00,0.00),('1','187','939','239969',4599483,'2760','418',650307.10,650411.11,0.00,0.00,104.01,78007.50,0.00,0.00,0.00),('1','187','939','239969',4599484,'2761','418',298980.55,299740.53,0.00,0.00,759.98,505386.70,0.00,0.00,0.00),('1','187','939','239969',4599485,'2762','418',196167.97,196222.97,0.00,0.00,55.00,36575.00,0.00,0.00,0.00),('1','187','939','239969',4599486,'2763','418',174734.20,175186.20,0.00,0.00,452.00,300580.00,0.00,0.00,0.00),('1','187','939','239969',4599487,'2764','418',149161.00,149586.00,0.00,0.00,425.00,282625.00,0.00,0.00,0.00),('1','187','939','239969',4599488,'2765','418',102418.34,102843.34,0.00,0.00,425.00,282625.00,0.00,0.00,0.00),('1','187','939','239970',4599489,'2760','418',650411.11,650411.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239970',4599490,'2761','418',299740.53,299740.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239970',4599491,'2762','418',196222.97,196222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239970',4599492,'2763','418',175186.20,175186.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239970',4599493,'2764','418',149586.00,149586.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239970',4599494,'2765','418',102843.34,102843.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239971',4599495,'2760','418',650411.11,650579.49,0.00,0.00,168.38,126285.00,0.00,0.00,0.00),('1','187','939','239971',4599496,'2761','418',299740.53,300787.53,0.00,0.00,1047.00,697005.00,0.00,0.00,0.00),('1','187','939','239971',4599497,'2762','418',196222.97,196747.97,0.00,0.00,525.00,351250.00,0.00,0.00,0.00),('1','187','939','239971',4599498,'2763','418',175186.20,175671.20,0.00,0.00,485.00,322525.00,0.00,0.00,0.00),('1','187','939','239971',4599499,'2764','418',149586.00,150476.00,0.00,0.00,890.00,593800.00,0.00,0.00,0.00),('1','187','939','239971',4599500,'2765','418',102843.34,103463.34,0.00,0.00,620.00,415400.00,0.00,0.00,0.00),('1','187','939','239972',4599501,'2760','418',650579.49,650756.00,0.00,0.00,176.51,132382.50,0.00,0.00,0.00),('1','187','939','239972',4599502,'2761','418',300787.53,301041.53,0.00,0.00,254.00,170180.00,0.00,0.00,0.00),('1','187','939','239972',4599503,'2762','418',196747.97,196894.97,0.00,0.00,147.00,98490.00,0.00,0.00,0.00),('1','187','939','239972',4599504,'2763','418',175671.20,175923.70,0.00,0.00,252.50,169175.00,0.00,0.00,0.00),('1','187','939','239972',4599505,'2764','418',150476.00,150576.00,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','187','939','239972',4599506,'2765','418',103463.34,103563.34,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','187','939','239973',4599507,'2760','418',650756.00,651105.33,0.00,0.00,349.33,261997.50,0.00,0.00,0.00),('1','187','939','239973',4599508,'2761','418',301041.53,303698.53,0.00,0.00,2657.00,1780190.00,0.00,0.00,0.00),('1','187','939','239973',4599509,'2762','418',196894.97,197256.82,0.00,0.00,361.85,242439.50,0.00,0.00,0.00),('1','187','939','239973',4599510,'2763','418',175923.70,177544.20,0.00,0.00,1620.50,1085735.00,0.00,0.00,0.00),('1','187','939','239973',4599511,'2764','418',150576.00,152461.00,0.00,0.00,1885.00,1262950.00,0.00,0.00,0.00),('1','187','939','239973',4599512,'2765','418',103563.34,104941.42,0.00,0.00,1378.08,923313.60,0.00,0.00,0.00),('1','187','939','239974',4599513,'2760','418',651105.33,651521.98,0.00,0.00,416.65,312487.50,0.00,0.00,0.00),('1','187','939','239974',4599514,'2761','418',303698.53,306176.53,0.00,0.00,2478.00,1660260.00,0.00,0.00,0.00),('1','187','939','239974',4599515,'2762','418',197256.82,197290.10,0.00,0.00,33.28,22297.60,0.00,0.00,0.00),('1','187','939','239974',4599516,'2763','418',177544.20,178838.20,0.00,0.00,1294.00,866980.00,0.00,0.00,0.00),('1','187','939','239974',4599517,'2764','418',152461.00,153497.00,0.00,0.00,1036.00,694120.00,0.00,0.00,0.00),('1','187','939','239974',4599518,'2765','418',104941.42,105641.42,0.00,0.00,700.00,469000.00,0.00,0.00,0.00),('1','187','939','239975',4599519,'2760','418',651521.98,651672.09,0.00,0.00,150.11,112582.50,0.00,0.00,0.00),('1','187','939','239975',4599520,'2761','418',306176.53,307906.62,0.00,0.00,1730.09,1159160.30,0.00,0.00,0.00),('1','187','939','239975',4599521,'2762','418',197290.10,197436.10,0.00,0.00,146.00,97820.00,0.00,0.00,0.00),('1','187','939','239975',4599522,'2763','418',178838.20,180023.20,0.00,0.00,1185.00,793950.00,0.00,0.00,0.00),('1','187','939','239975',4599523,'2764','418',153497.00,154801.80,0.00,0.00,1304.80,874216.00,0.00,0.00,0.00),('1','187','939','239975',4599524,'2765','418',105641.42,106651.50,0.00,0.00,1010.08,676753.60,0.00,0.00,0.00),('1','187','939','239976',4599525,'2760','418',651672.09,651672.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239976',4599526,'2761','418',307906.62,307906.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239976',4599527,'2762','418',197436.10,197436.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239976',4599528,'2763','418',180023.20,180023.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239976',4599529,'2764','418',154801.80,154801.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239976',4599530,'2765','418',106651.50,106651.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239977',4599531,'2760','418',651672.09,652071.53,0.00,0.00,399.44,299580.00,0.00,0.00,0.00),('1','187','939','239977',4599532,'2761','418',307906.62,311823.97,0.00,0.00,3917.35,2617420.21,0.00,0.00,0.00),('1','187','939','239977',4599533,'2762','418',197436.10,199008.29,0.00,0.00,1572.19,1048950.73,0.00,0.00,0.00),('1','187','939','239977',4599534,'2763','418',180023.20,182192.20,0.00,0.00,2169.00,1449273.00,0.00,0.00,0.00),('1','187','939','239977',4599535,'2764','418',154801.80,157618.80,0.00,0.00,2817.00,1882776.00,0.00,0.00,0.00),('1','187','939','239977',4599536,'2765','418',106651.50,109323.77,0.00,0.00,2672.27,1783952.09,0.00,0.00,0.00),('1','187','939','239978',4599537,'2760','418',652071.53,652572.43,0.00,0.00,500.90,375675.00,0.00,0.00,0.00),('1','187','939','239978',4599538,'2761','418',311823.97,313629.97,0.00,0.00,1806.00,1210020.00,0.00,0.00,0.00),('1','187','939','239978',4599539,'2762','418',199008.29,199352.39,0.00,0.00,344.10,230547.00,0.00,0.00,0.00),('1','187','939','239978',4599540,'2763','418',182192.20,183018.20,0.00,0.00,826.00,553420.00,0.00,0.00,0.00),('1','187','939','239978',4599541,'2764','418',157618.80,158273.80,0.00,0.00,655.00,438850.00,0.00,0.00,0.00),('1','187','939','239978',4599542,'2765','418',109323.77,109810.77,0.00,0.00,487.00,326290.00,0.00,0.00,0.00),('1','187','939','239979',4599543,'2760','418',652572.43,653074.04,0.00,0.00,501.61,376207.50,0.00,0.00,0.00),('1','187','939','239979',4599544,'2761','418',313629.97,315852.67,0.00,0.00,2222.70,1489315.40,0.00,0.00,0.00),('1','187','939','239979',4599545,'2762','418',199352.39,199651.44,0.00,0.00,299.05,200363.50,0.00,0.00,0.00),('1','187','939','239979',4599546,'2763','418',183018.20,183435.20,0.00,0.00,417.00,279390.00,0.00,0.00,0.00),('1','187','939','239979',4599547,'2764','418',158273.80,158783.80,0.00,0.00,510.00,341700.00,0.00,0.00,0.00),('1','187','939','239979',4599548,'2765','418',109810.77,110110.77,0.00,0.00,300.00,201000.00,0.00,0.00,0.00),('1','187','939','239980',4599549,'2760','418',653074.04,653216.70,0.00,0.00,142.66,106995.00,0.00,0.00,0.00),('1','187','939','239980',4599550,'2761','418',315852.67,316920.67,0.00,0.00,1068.00,715666.40,0.00,0.00,0.00),('1','187','939','239980',4599551,'2762','418',199651.44,199651.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239980',4599552,'2763','418',183435.20,183977.20,0.00,0.00,542.00,363140.00,0.00,0.00,0.00),('1','187','939','239980',4599553,'2764','418',158783.80,159037.80,0.00,0.00,254.00,170180.00,0.00,0.00,0.00),('1','187','939','239980',4599554,'2765','418',110110.77,110374.77,0.00,0.00,264.00,176880.00,0.00,0.00,0.00),('1','187','939','239981',4599555,'2760','418',653216.70,653216.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239981',4599556,'2761','418',316920.67,316920.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239981',4599557,'2762','418',199651.44,199651.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239981',4599558,'2763','418',183977.20,183977.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239981',4599559,'2764','418',159037.80,159037.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239981',4599560,'2765','418',110374.77,110374.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239982',4599561,'2760','418',653216.70,653487.77,0.00,0.00,271.07,203302.50,0.00,0.00,0.00),('1','187','939','239982',4599562,'2761','418',316920.67,317935.67,0.00,0.00,1015.00,680050.00,0.00,0.00,0.00),('1','187','939','239982',4599563,'2762','418',199651.44,199911.18,0.00,0.00,259.74,174025.80,0.00,0.00,0.00),('1','187','939','239982',4599564,'2763','418',183977.20,184177.20,0.00,0.00,200.00,134000.00,0.00,0.00,0.00),('1','187','939','239982',4599565,'2764','418',159037.80,159389.80,0.00,0.00,352.00,235840.00,0.00,0.00,0.00),('1','187','939','239982',4599566,'2765','418',110374.77,110809.77,0.00,0.00,435.00,291450.00,0.00,0.00,0.00),('1','187','939','239983',4599567,'2760','418',653487.77,653953.42,0.00,0.00,465.65,349237.50,0.00,0.00,0.00),('1','187','939','239983',4599568,'2761','418',317935.67,322345.29,0.00,0.00,4409.62,2949839.26,0.00,0.00,0.00),('1','187','939','239983',4599569,'2762','418',199911.18,201602.02,0.00,0.00,1690.84,1128960.28,0.00,0.00,0.00),('1','187','939','239983',4599570,'2763','418',184177.20,186793.56,0.00,0.00,2616.36,1748166.12,0.00,0.00,0.00),('1','187','939','239983',4599571,'2764','418',159389.80,163043.80,0.00,0.00,3654.00,2441121.00,0.00,0.00,0.00),('1','187','939','239983',4599572,'2765','418',110809.77,114022.19,0.00,0.00,3212.42,2145684.14,0.00,0.00,0.00),('1','187','939','239984',4599573,'2760','418',653953.42,654321.69,0.00,0.00,368.27,276202.50,0.00,0.00,0.00),('1','187','939','239984',4599574,'2761','418',322345.29,323128.29,0.00,0.00,783.00,524610.00,0.00,0.00,0.00),('1','187','939','239984',4599575,'2762','418',201602.02,201852.02,0.00,0.00,250.00,167500.00,0.00,0.00,0.00),('1','187','939','239984',4599576,'2763','418',186793.56,187048.86,0.00,0.00,255.30,171051.00,0.00,0.00,0.00),('1','187','939','239984',4599577,'2764','418',163043.80,163514.80,0.00,0.00,471.00,315570.00,0.00,0.00,0.00),('1','187','939','239984',4599578,'2765','418',114022.19,114622.19,0.00,0.00,600.00,402000.00,0.00,0.00,0.00),('1','187','939','239985',4599579,'2760','418',654321.69,654475.03,0.00,0.00,153.34,115005.00,0.00,0.00,0.00),('1','187','939','239985',4599580,'2761','418',323128.29,323963.29,0.00,0.00,835.00,559450.00,0.00,0.00,0.00),('1','187','939','239985',4599581,'2762','418',201852.02,202252.02,0.00,0.00,400.00,268000.00,0.00,0.00,0.00),('1','187','939','239985',4599582,'2763','418',187048.86,187628.86,0.00,0.00,580.00,388600.00,0.00,0.00,0.00),('1','187','939','239985',4599583,'2764','418',163514.80,164209.80,0.00,0.00,695.00,465650.00,0.00,0.00,0.00),('1','187','939','239985',4599584,'2765','418',114622.19,115347.87,0.00,0.00,725.68,486205.60,0.00,0.00,0.00),('1','187','939','239986',4599585,'2760','418',654475.03,654475.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239986',4599586,'2761','418',323963.29,323963.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239986',4599587,'2762','418',202252.02,202252.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239986',4599588,'2763','418',187628.86,187628.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239986',4599589,'2764','418',164209.80,164209.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239986',4599590,'2765','418',115347.87,115347.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239987',4599591,'2760','418',654475.03,654889.99,0.00,0.00,414.96,311220.00,0.00,0.00,0.00),('1','187','939','239987',4599592,'2761','418',323963.29,326327.63,0.00,0.00,2364.34,1580957.80,0.00,0.00,0.00),('1','187','939','239987',4599593,'2762','418',202252.02,202752.02,0.00,0.00,500.00,334100.00,0.00,0.00,0.00),('1','187','939','239987',4599594,'2763','418',187628.86,188839.86,0.00,0.00,1211.00,810470.00,0.00,0.00,0.00),('1','187','939','239987',4599595,'2764','418',164209.80,165453.80,0.00,0.00,1244.00,830930.00,0.00,0.00,0.00),('1','187','939','239987',4599596,'2765','418',115347.87,116983.27,0.00,0.00,1635.40,1093918.00,0.00,0.00,0.00),('1','187','939','239988',4599597,'2760','418',654889.99,655313.07,0.00,0.00,423.08,317310.00,0.00,0.00,0.00),('1','187','939','239988',4599598,'2761','418',326327.63,327791.63,0.00,0.00,1464.00,980880.00,0.00,0.00,0.00),('1','187','939','239988',4599599,'2762','418',202752.02,203129.58,0.00,0.00,377.56,252965.20,0.00,0.00,0.00),('1','187','939','239988',4599600,'2763','418',188839.86,189321.99,0.00,0.00,482.13,323027.10,0.00,0.00,0.00),('1','187','939','239988',4599601,'2764','418',165453.80,165901.80,0.00,0.00,448.00,300160.00,0.00,0.00,0.00),('1','187','939','239988',4599602,'2765','418',116983.27,117762.27,0.00,0.00,779.00,521930.00,0.00,0.00,0.00),('1','187','939','239989',4599603,'2760','418',655313.07,655533.65,0.00,0.00,220.58,165435.00,0.00,0.00,0.00),('1','187','939','239989',4599604,'2761','418',327791.63,328523.31,0.00,0.00,731.68,490225.60,0.00,0.00,0.00),('1','187','939','239989',4599605,'2762','418',203129.58,203329.67,0.00,0.00,200.09,134060.30,0.00,0.00,0.00),('1','187','939','239989',4599606,'2763','418',189321.99,189492.99,0.00,0.00,171.00,114570.00,0.00,0.00,0.00),('1','187','939','239989',4599607,'2764','418',165901.80,166176.80,0.00,0.00,275.00,184250.00,0.00,0.00,0.00),('1','187','939','239989',4599608,'2765','418',117762.27,118067.27,0.00,0.00,305.00,204350.00,0.00,0.00,0.00),('1','187','939','239990',4599609,'2760','418',655533.65,655988.60,0.00,0.00,454.95,341212.50,0.00,0.00,0.00),('1','187','939','239990',4599610,'2761','418',328523.31,330776.31,0.00,0.00,2253.00,1509510.00,0.00,0.00,0.00),('1','187','939','239990',4599611,'2762','418',203329.67,203717.67,0.00,0.00,388.00,259960.00,0.00,0.00,0.00),('1','187','939','239990',4599612,'2763','418',189492.99,190122.99,0.00,0.00,630.00,422100.00,0.00,0.00,0.00),('1','187','939','239990',4599613,'2764','418',166176.80,167438.80,0.00,0.00,1262.00,845540.00,0.00,0.00,0.00),('1','187','939','239990',4599614,'2765','418',118067.27,118814.97,0.00,0.00,747.70,500959.00,0.00,0.00,0.00),('1','187','939','239991',4599615,'2760','418',655988.60,656417.95,0.00,0.00,429.35,322012.50,0.00,0.00,0.00),('1','187','939','239991',4599616,'2761','418',330776.31,332483.31,0.00,0.00,1707.00,1143690.00,0.00,0.00,0.00),('1','187','939','239991',4599617,'2762','418',203717.67,204031.66,0.00,0.00,313.99,210373.30,0.00,0.00,0.00),('1','187','939','239991',4599618,'2763','418',190122.99,190672.99,0.00,0.00,550.00,368500.00,0.00,0.00,0.00),('1','187','939','239991',4599619,'2764','418',167438.80,168421.80,0.00,0.00,983.00,658610.00,0.00,0.00,0.00),('1','187','939','239991',4599620,'2765','418',118814.97,119614.97,0.00,0.00,800.00,536000.00,0.00,0.00,0.00),('1','187','939','239992',4599621,'2760','418',656417.95,656566.58,0.00,0.00,148.63,111472.50,0.00,0.00,0.00),('1','187','939','239992',4599622,'2761','418',332483.31,332813.31,0.00,0.00,330.00,221100.00,0.00,0.00,0.00),('1','187','939','239992',4599623,'2762','418',204031.66,204049.66,0.00,0.00,18.00,12060.00,0.00,0.00,0.00),('1','187','939','239992',4599624,'2763','418',190672.99,190897.99,0.00,0.00,225.00,150750.00,0.00,0.00,0.00),('1','187','939','239992',4599625,'2764','418',168421.80,168521.80,0.00,0.00,100.00,67000.00,0.00,0.00,0.00),('1','187','939','239992',4599626,'2765','418',119614.97,119614.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239993',4599627,'2760','418',656566.58,656566.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239993',4599628,'2761','418',332813.31,332813.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239993',4599629,'2762','418',204049.66,204049.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239993',4599630,'2763','418',190897.99,190897.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239993',4599631,'2764','418',168521.80,168521.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239993',4599632,'2765','418',119614.97,119614.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','239994',4599633,'2760','418',656566.58,656738.19,0.00,0.00,171.61,128707.50,0.00,0.00,0.00),('1','187','939','239994',4599634,'2761','418',332813.31,333227.31,0.00,0.00,414.00,277380.00,0.00,0.00,0.00),('1','187','939','239994',4599635,'2762','418',204049.66,204199.66,0.00,0.00,150.00,100500.00,0.00,0.00,0.00),('1','187','939','239994',4599636,'2763','418',190897.99,191293.99,0.00,0.00,396.00,265320.00,0.00,0.00,0.00),('1','187','939','239994',4599637,'2764','418',168521.80,169021.80,0.00,0.00,500.00,335000.00,0.00,0.00,0.00),('1','187','939','239994',4599638,'2765','418',119614.97,119864.97,0.00,0.00,250.00,167500.00,0.00,0.00,0.00),('1','187','939','239995',4599639,'2760','418',656738.19,657104.62,0.00,0.00,366.43,274822.50,0.00,0.00,0.00),('1','187','939','239995',4599640,'2761','418',333227.31,335297.31,0.00,0.00,2070.00,1376550.00,0.00,0.00,0.00),('1','187','939','239995',4599641,'2762','418',204199.66,204704.66,0.00,0.00,505.00,335825.00,0.00,0.00,0.00),('1','187','939','239995',4599642,'2763','418',191293.99,191793.99,0.00,0.00,500.00,332500.00,0.00,0.00,0.00),('1','187','939','239995',4599643,'2764','418',169021.80,169888.80,0.00,0.00,867.00,576555.00,0.00,0.00,0.00),('1','187','939','239995',4599644,'2765','418',119864.97,120969.00,0.00,0.00,1104.03,734179.95,0.00,0.00,0.00),('1','187','939','239996',4599645,'2760','418',657104.62,657494.74,0.00,0.00,390.12,292590.00,0.00,0.00,0.00),('1','187','939','239996',4599646,'2761','418',335297.31,336629.11,0.00,0.00,1331.80,885647.00,0.00,0.00,0.00),('1','187','939','239996',4599647,'2762','418',204704.66,205056.66,0.00,0.00,352.00,234080.00,0.00,0.00,0.00),('1','187','939','239996',4599648,'2763','418',191793.99,192118.99,0.00,0.00,325.00,216125.00,0.00,0.00,0.00),('1','187','939','239996',4599649,'2764','418',169888.80,170654.80,0.00,0.00,766.00,509390.00,0.00,0.00,0.00),('1','187','939','239996',4599650,'2765','418',120969.00,121271.00,0.00,0.00,302.00,200830.00,0.00,0.00,0.00),('1','187','939','239997',4599651,'2760','418',657494.74,657835.16,0.00,0.00,340.42,255315.00,0.00,0.00,0.00),('1','187','939','239997',4599652,'2761','418',336629.11,338333.11,0.00,0.00,1704.00,1133160.00,0.00,0.00,0.00),('1','187','939','239997',4599653,'2762','418',205056.66,205425.16,0.00,0.00,368.50,245052.50,0.00,0.00,0.00),('1','187','939','239997',4599654,'2763','418',192118.99,192569.01,0.00,0.00,450.02,299263.30,0.00,0.00,0.00),('1','187','939','239997',4599655,'2764','418',170654.80,171604.80,0.00,0.00,950.00,631750.00,0.00,0.00,0.00),('1','187','939','239997',4599656,'2765','418',121271.00,122173.90,0.00,0.00,902.90,600428.50,0.00,0.00,0.00),('1','187','939','239998',4599657,'2760','418',657835.16,658056.80,0.00,0.00,221.64,166230.00,0.00,0.00,0.00),('1','187','939','239998',4599658,'2761','418',338333.11,339508.87,0.00,0.00,1175.76,781880.40,0.00,0.00,0.00),('1','187','939','239998',4599659,'2762','418',205425.16,205615.16,0.00,0.00,190.00,126350.00,0.00,0.00,0.00),('1','187','939','239998',4599660,'2763','418',192569.01,192619.01,0.00,0.00,50.00,33250.00,0.00,0.00,0.00),('1','187','939','239998',4599661,'2764','418',171604.80,172167.80,0.00,0.00,563.00,374395.00,0.00,0.00,0.00),('1','187','939','239998',4599662,'2765','418',122173.90,122373.90,0.00,0.00,200.00,133000.00,0.00,0.00,0.00),('1','187','939','239999',4599663,'2760','418',658056.80,658439.89,0.00,0.00,383.09,287317.50,0.00,0.00,0.00),('1','187','939','239999',4599664,'2761','418',339508.87,341627.71,0.00,0.00,2118.84,1409028.60,0.00,0.00,0.00),('1','187','939','239999',4599665,'2762','418',205615.16,205983.16,0.00,0.00,368.00,244720.00,0.00,0.00,0.00),('1','187','939','239999',4599666,'2763','418',192619.01,193419.98,0.00,0.00,800.97,532645.05,0.00,0.00,0.00),('1','187','939','239999',4599667,'2764','418',172167.80,173456.08,0.00,0.00,1288.28,856706.20,0.00,0.00,0.00),('1','187','939','239999',4599668,'2765','418',122373.90,123249.08,0.00,0.00,875.18,581994.70,0.00,0.00,0.00),('1','187','939','240000',4599669,'2760','418',658439.89,658473.21,0.00,0.00,33.32,24990.00,0.00,0.00,0.00),('1','187','939','240000',4599670,'2761','418',341627.71,342012.71,0.00,0.00,385.00,256025.00,0.00,0.00,0.00),('1','187','939','240000',4599671,'2762','418',205983.16,206128.64,0.00,0.00,145.48,96744.20,0.00,0.00,0.00),('1','187','939','240000',4599672,'2763','418',193419.98,193469.98,0.00,0.00,50.00,33250.00,0.00,0.00,0.00),('1','187','939','240000',4599673,'2764','418',173456.08,173582.44,0.00,0.00,126.36,84029.40,0.00,0.00,0.00),('1','187','939','240000',4599674,'2765','418',123249.08,123349.08,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','187','939','240001',4599675,'2760','418',658473.21,658473.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240001',4599676,'2761','418',342012.71,342012.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240001',4599677,'2762','418',206128.64,206128.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240001',4599678,'2763','418',193469.98,193469.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240001',4599679,'2764','418',173582.44,173582.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240001',4599680,'2765','418',123349.08,123349.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240002',4599681,'2760','418',658473.21,658642.82,0.00,0.00,169.61,127207.50,0.00,0.00,0.00),('1','187','939','240002',4599682,'2761','418',342012.71,342809.71,0.00,0.00,797.00,530005.00,0.00,0.00,0.00),('1','187','939','240002',4599683,'2762','418',206128.64,206281.64,0.00,0.00,153.00,101745.00,0.00,0.00,0.00),('1','187','939','240002',4599684,'2763','418',193469.98,193737.94,0.00,0.00,267.96,178193.40,0.00,0.00,0.00),('1','187','939','240002',4599685,'2764','418',173582.44,174142.44,0.00,0.00,560.00,372400.00,0.00,0.00,0.00),('1','187','939','240002',4599686,'2765','418',123349.08,123830.08,0.00,0.00,481.00,319865.00,0.00,0.00,0.00),('1','187','939','240003',4599687,'2760','418',658642.82,659057.49,0.00,0.00,414.67,311002.50,0.00,0.00,0.00),('1','187','939','240003',4599688,'2761','418',342809.71,344667.53,0.00,0.00,1857.82,1235450.30,0.00,0.00,0.00),('1','187','939','240003',4599689,'2762','418',206281.64,206633.31,0.00,0.00,351.67,233860.55,0.00,0.00,0.00),('1','187','939','240003',4599690,'2763','418',193737.94,194462.64,0.00,0.00,724.70,481925.50,0.00,0.00,0.00),('1','187','939','240003',4599691,'2764','418',174142.44,175115.43,0.00,0.00,972.99,647038.35,0.00,0.00,0.00),('1','187','939','240003',4599692,'2765','418',123830.08,124779.78,0.00,0.00,949.70,631550.50,0.00,0.00,0.00),('1','187','939','240004',4599693,'2760','418',659057.49,659384.94,0.00,0.00,327.45,245587.50,0.00,0.00,0.00),('1','187','939','240004',4599694,'2761','418',344667.53,345618.33,0.00,0.00,950.80,632282.00,0.00,0.00,0.00),('1','187','939','240004',4599695,'2762','418',206633.31,206833.31,0.00,0.00,200.00,133000.00,0.00,0.00,0.00),('1','187','939','240004',4599696,'2763','418',194462.64,194662.64,0.00,0.00,200.00,133000.00,0.00,0.00,0.00),('1','187','939','240004',4599697,'2764','418',175115.43,175395.43,0.00,0.00,280.00,186200.00,0.00,0.00,0.00),('1','187','939','240004',4599698,'2765','418',124779.78,125032.78,0.00,0.00,253.00,168245.00,0.00,0.00,0.00),('1','187','939','240005',4599699,'2760','418',659384.94,659739.68,0.00,0.00,354.74,266055.00,0.00,0.00,0.00),('1','187','939','240005',4599700,'2761','418',345618.33,346781.85,0.00,0.00,1163.52,773740.80,0.00,0.00,0.00),('1','187','939','240005',4599701,'2762','418',206833.31,207215.81,0.00,0.00,382.50,254362.50,0.00,0.00,0.00),('1','187','939','240005',4599702,'2763','418',194662.64,194812.64,0.00,0.00,150.00,99750.00,0.00,0.00,0.00),('1','187','939','240005',4599703,'2764','418',175395.43,176097.43,0.00,0.00,702.00,466830.00,0.00,0.00,0.00),('1','187','939','240005',4599704,'2765','418',125032.78,125692.78,0.00,0.00,660.00,438900.00,0.00,0.00,0.00),('1','187','939','240006',4599705,'2760','418',659739.68,660109.67,0.00,0.00,369.99,277492.50,0.00,0.00,0.00),('1','187','939','240006',4599706,'2761','418',346781.85,348099.85,0.00,0.00,1318.00,876470.00,0.00,0.00,0.00),('1','187','939','240006',4599707,'2762','418',207215.81,208071.81,0.00,0.00,856.00,569240.00,0.00,0.00,0.00),('1','187','939','240006',4599708,'2763','418',194812.64,195066.64,0.00,0.00,254.00,168910.00,0.00,0.00,0.00),('1','187','939','240006',4599709,'2764','418',176097.43,177760.43,0.00,0.00,1663.00,1105895.00,0.00,0.00,0.00),('1','187','939','240006',4599710,'2765','418',125692.78,126287.16,0.00,0.00,594.38,395262.70,0.00,0.00,0.00),('1','187','939','240007',4599711,'2760','418',660109.67,660422.15,0.00,0.00,312.48,234360.00,0.00,0.00,0.00),('1','187','939','240007',4599712,'2761','418',348099.85,348645.85,0.00,0.00,546.00,363090.00,0.00,0.00,0.00),('1','187','939','240007',4599713,'2762','418',208071.81,208521.81,0.00,0.00,450.00,299250.00,0.00,0.00,0.00),('1','187','939','240007',4599714,'2763','418',195066.64,195191.64,0.00,0.00,125.00,83125.00,0.00,0.00,0.00),('1','187','939','240007',4599715,'2764','418',177760.43,178414.43,0.00,0.00,654.00,434910.00,0.00,0.00,0.00),('1','187','939','240007',4599716,'2765','418',126287.16,126537.16,0.00,0.00,250.00,166250.00,0.00,0.00,0.00),('1','187','939','240008',4599717,'2760','418',660422.15,660769.34,0.00,0.00,347.19,260392.50,0.00,0.00,0.00),('1','187','939','240008',4599718,'2761','418',348645.85,350109.81,0.00,0.00,1463.96,973533.40,0.00,0.00,0.00),('1','187','939','240008',4599719,'2762','418',208521.81,208608.68,0.00,0.00,86.87,57768.55,0.00,0.00,0.00),('1','187','939','240008',4599720,'2763','418',195191.64,195688.64,0.00,0.00,497.00,330505.00,0.00,0.00,0.00),('1','187','939','240008',4599721,'2764','418',178414.43,178984.43,0.00,0.00,570.00,379050.00,0.00,0.00,0.00),('1','187','939','240008',4599722,'2765','418',126537.16,127142.14,0.00,0.00,604.98,402311.70,0.00,0.00,0.00),('1','187','939','240009',4599723,'2760','418',660769.34,660769.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240009',4599724,'2761','418',350109.81,350109.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240009',4599725,'2762','418',208608.68,208608.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240009',4599726,'2763','418',195688.64,195688.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240009',4599727,'2764','418',178984.43,178984.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240009',4599728,'2765','418',127142.14,127142.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240010',4599729,'2760','418',660769.34,661033.19,0.00,0.00,263.85,197887.50,0.00,0.00,0.00),('1','187','939','240010',4599730,'2761','418',350109.81,351627.81,0.00,0.00,1518.00,1009470.00,0.00,0.00,0.00),('1','187','939','240010',4599731,'2762','418',208608.68,209115.68,0.00,0.00,507.00,337155.00,0.00,0.00,0.00),('1','187','939','240010',4599732,'2763','418',195688.64,196341.00,0.00,0.00,652.36,433819.40,0.00,0.00,0.00),('1','187','939','240010',4599733,'2764','418',178984.43,180002.57,0.00,0.00,1018.14,677063.10,0.00,0.00,0.00),('1','187','939','240010',4599734,'2765','418',127142.14,128027.28,0.00,0.00,885.14,588618.10,0.00,0.00,0.00),('1','187','939','240011',4599735,'2760','418',661033.19,661400.20,0.00,0.00,367.01,275257.50,0.00,0.00,0.00),('1','187','939','240011',4599736,'2761','418',351627.81,352932.81,0.00,0.00,1305.00,867825.00,0.00,0.00,0.00),('1','187','939','240011',4599737,'2762','418',209115.68,209368.68,0.00,0.00,253.00,168245.00,0.00,0.00,0.00),('1','187','939','240011',4599738,'2763','418',196341.00,196801.00,0.00,0.00,460.00,305900.00,0.00,0.00,0.00),('1','187','939','240011',4599739,'2764','418',180002.57,180535.37,0.00,0.00,532.80,354312.00,0.00,0.00,0.00),('1','187','939','240011',4599740,'2765','418',128027.28,128362.28,0.00,0.00,335.00,222775.00,0.00,0.00,0.00),('1','187','939','240012',4599741,'2760','418',661400.20,661671.51,0.00,0.00,271.31,203482.50,0.00,0.00,0.00),('1','187','939','240012',4599742,'2761','418',352932.81,353725.39,0.00,0.00,792.58,527065.70,0.00,0.00,0.00),('1','187','939','240012',4599743,'2762','418',209368.68,209701.68,0.00,0.00,333.00,221445.00,0.00,0.00,0.00),('1','187','939','240012',4599744,'2763','418',196801.00,196951.00,0.00,0.00,150.00,99750.00,0.00,0.00,0.00),('1','187','939','240012',4599745,'2764','418',180535.37,181124.37,0.00,0.00,589.00,391685.00,0.00,0.00,0.00),('1','187','939','240012',4599746,'2765','418',128362.28,128667.28,0.00,0.00,305.00,202825.00,0.00,0.00,0.00),('1','187','939','240013',4599747,'2760','418',661671.51,661996.28,0.00,0.00,324.77,243577.50,0.00,0.00,0.00),('1','187','939','240013',4599748,'2761','418',353725.39,354981.39,0.00,0.00,1256.00,835410.00,0.00,0.00,0.00),('1','187','939','240013',4599749,'2762','418',209701.68,209909.68,0.00,0.00,208.00,138320.00,0.00,0.00,0.00),('1','187','939','240013',4599750,'2763','418',196951.00,197422.00,0.00,0.00,471.00,313215.00,0.00,0.00,0.00),('1','187','939','240013',4599751,'2764','418',181124.37,181964.37,0.00,0.00,840.00,558600.00,0.00,0.00,0.00),('1','187','939','240013',4599752,'2765','418',128667.28,129429.28,0.00,0.00,762.00,506730.00,0.00,0.00,0.00),('1','187','939','240014',4599753,'2760','418',661996.28,662356.92,0.00,0.00,360.64,270480.00,0.00,0.00,0.00),('1','187','939','240014',4599754,'2761','418',354981.39,355889.39,0.00,0.00,908.00,603820.00,0.00,0.00,0.00),('1','187','939','240014',4599755,'2762','418',209909.68,210071.79,0.00,0.00,162.11,107803.15,0.00,0.00,0.00),('1','187','939','240014',4599756,'2763','418',197422.00,197694.00,0.00,0.00,272.00,180880.00,0.00,0.00,0.00),('1','187','939','240014',4599757,'2764','418',181964.37,182404.37,0.00,0.00,440.00,292600.00,0.00,0.00,0.00),('1','187','939','240014',4599758,'2765','418',129429.28,129719.28,0.00,0.00,290.00,192850.00,0.00,0.00,0.00),('1','187','939','240015',4599759,'2760','418',662356.92,662686.56,0.00,0.00,329.64,247230.00,0.00,0.00,0.00),('1','187','939','240015',4599760,'2761','418',355889.39,356438.39,0.00,0.00,549.00,365085.00,0.00,0.00,0.00),('1','187','939','240015',4599761,'2762','418',210071.79,210071.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240015',4599762,'2763','418',197694.00,197694.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240015',4599763,'2764','418',182404.37,182404.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240015',4599764,'2765','418',129719.28,129719.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240016',4599765,'2760','418',662686.56,663026.15,0.00,0.00,339.59,254692.50,0.00,0.00,0.00),('1','187','939','240016',4599766,'2761','418',356438.39,357073.39,0.00,0.00,635.00,422275.00,0.00,0.00,0.00),('1','187','939','240016',4599767,'2762','418',210071.79,210501.79,0.00,0.00,430.00,285950.00,0.00,0.00,0.00),('1','187','939','240016',4599768,'2763','418',197694.00,197964.55,0.00,0.00,270.55,179915.75,0.00,0.00,0.00),('1','187','939','240016',4599769,'2764','418',182404.37,183117.37,0.00,0.00,713.00,474145.00,0.00,0.00,0.00),('1','187','939','240016',4599770,'2765','418',129719.28,130250.28,0.00,0.00,531.00,353115.00,0.00,0.00,0.00),('1','187','939','240017',4599771,'2760','418',663026.15,663361.72,0.00,0.00,335.57,251677.50,0.00,0.00,0.00),('1','187','939','240017',4599772,'2761','418',357073.39,357635.89,0.00,0.00,562.50,374062.50,0.00,0.00,0.00),('1','187','939','240017',4599773,'2762','418',210501.79,210745.79,0.00,0.00,244.00,162260.00,0.00,0.00,0.00),('1','187','939','240017',4599774,'2763','418',197964.55,198151.22,0.00,0.00,186.67,124135.55,0.00,0.00,0.00),('1','187','939','240017',4599775,'2764','418',183117.37,183725.37,0.00,0.00,608.00,404320.00,0.00,0.00,0.00),('1','187','939','240017',4599776,'2765','418',130250.28,130668.28,0.00,0.00,418.00,277970.00,0.00,0.00,0.00),('1','187','939','240018',4599777,'2760','418',663361.72,663505.43,0.00,0.00,143.71,107782.50,0.00,0.00,0.00),('1','187','939','240018',4599778,'2761','418',357635.89,358023.89,0.00,0.00,388.00,258020.00,0.00,0.00,0.00),('1','187','939','240018',4599779,'2762','418',210745.79,210968.79,0.00,0.00,223.00,148295.00,0.00,0.00,0.00),('1','187','939','240018',4599780,'2763','418',198151.22,198354.22,0.00,0.00,203.00,134995.00,0.00,0.00,0.00),('1','187','939','240018',4599781,'2764','418',183725.37,184095.37,0.00,0.00,370.00,246050.00,0.00,0.00,0.00),('1','187','939','240018',4599782,'2765','418',130668.28,130934.28,0.00,0.00,266.00,176890.00,0.00,0.00,0.00),('1','187','939','240019',4599783,'2760','418',663505.43,663505.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240019',4599784,'2761','418',358023.89,358023.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240019',4599785,'2762','418',210968.79,210968.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240019',4599786,'2763','418',198354.22,198354.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240019',4599787,'2764','418',184095.37,184095.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240019',4599788,'2765','418',130934.28,130934.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240020',4599789,'2760','418',663505.43,663878.71,0.00,0.00,373.28,279960.00,0.00,0.00,0.00),('1','187','939','240020',4599790,'2761','418',358023.89,361141.35,0.00,0.00,3117.46,2073110.90,0.00,0.00,0.00),('1','187','939','240020',4599791,'2762','418',210968.79,211513.68,0.00,0.00,544.89,362351.85,0.00,0.00,0.00),('1','187','939','240020',4599792,'2763','418',198354.22,199237.30,0.00,0.00,883.08,587248.20,0.00,0.00,0.00),('1','187','939','240020',4599793,'2764','418',184095.37,184870.18,0.00,0.00,774.81,515248.65,0.00,0.00,0.00),('1','187','939','240020',4599794,'2765','418',130934.28,131801.97,0.00,0.00,867.69,577013.85,0.00,0.00,0.00),('1','187','939','240021',4599795,'2760','418',663878.71,664087.45,0.00,0.00,208.74,156555.00,0.00,0.00,0.00),('1','187','939','240021',4599796,'2761','418',361141.35,362409.35,0.00,0.00,1268.00,843220.00,0.00,0.00,0.00),('1','187','939','240021',4599797,'2762','418',211513.68,211671.42,0.00,0.00,157.74,104897.10,0.00,0.00,0.00),('1','187','939','240021',4599798,'2763','418',199237.30,199337.30,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','187','939','240021',4599799,'2764','418',184870.18,185020.18,0.00,0.00,150.00,99750.00,0.00,0.00,0.00),('1','187','939','240021',4599800,'2765','418',131801.97,131901.97,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','187','939','240022',4599801,'2760','418',664087.45,664406.75,0.00,0.00,319.30,239475.00,0.00,0.00,0.00),('1','187','939','240022',4599802,'2761','418',362409.35,363347.46,0.00,0.00,938.11,623843.15,0.00,0.00,0.00),('1','187','939','240022',4599803,'2762','418',211671.42,211686.46,0.00,0.00,15.04,10001.60,0.00,0.00,0.00),('1','187','939','240022',4599804,'2763','418',199337.30,199687.30,0.00,0.00,350.00,232750.00,0.00,0.00,0.00),('1','187','939','240022',4599805,'2764','418',185020.18,185220.18,0.00,0.00,200.00,133000.00,0.00,0.00,0.00),('1','187','939','240022',4599806,'2765','418',131901.97,132051.97,0.00,0.00,150.00,99750.00,0.00,0.00,0.00),('1','187','939','240023',4599807,'2760','418',664406.75,664648.48,0.00,0.00,241.73,181297.50,0.00,0.00,0.00),('1','187','939','240023',4599808,'2761','418',363347.46,363673.46,0.00,0.00,326.00,216790.00,0.00,0.00,0.00),('1','187','939','240023',4599809,'2762','418',211686.46,211816.46,0.00,0.00,130.00,86450.00,0.00,0.00,0.00),('1','187','939','240023',4599810,'2763','418',199687.30,199887.30,0.00,0.00,200.00,133000.00,0.00,0.00,0.00),('1','187','939','240023',4599811,'2764','418',185220.18,185370.18,0.00,0.00,150.00,99750.00,0.00,0.00,0.00),('1','187','939','240023',4599812,'2765','418',132051.97,132101.97,0.00,0.00,50.00,33250.00,0.00,0.00,0.00),('1','187','939','240024',4599813,'2760','418',664648.48,664940.62,0.00,0.00,292.14,219105.00,0.00,0.00,0.00),('1','187','939','240024',4599814,'2761','418',363673.46,364099.46,0.00,0.00,426.00,283290.00,0.00,0.00,0.00),('1','187','939','240024',4599815,'2762','418',211816.46,212060.46,0.00,0.00,244.00,162260.00,0.00,0.00,0.00),('1','187','939','240024',4599816,'2763','418',199887.30,200242.30,0.00,0.00,355.00,236075.00,0.00,0.00,0.00),('1','187','939','240024',4599817,'2764','418',185370.18,185720.18,0.00,0.00,350.00,232750.00,0.00,0.00,0.00),('1','187','939','240024',4599818,'2765','418',132101.97,132534.97,0.00,0.00,433.00,287945.00,0.00,0.00,0.00),('1','187','939','240025',4599819,'2760','418',664940.62,665123.48,0.00,0.00,182.86,137145.00,0.00,0.00,0.00),('1','187','939','240025',4599820,'2761','418',364099.46,364399.46,0.00,0.00,300.00,199500.00,0.00,0.00,0.00),('1','187','939','240025',4599821,'2762','418',212060.46,212154.46,0.00,0.00,94.00,62510.00,0.00,0.00,0.00),('1','187','939','240025',4599822,'2763','418',200242.30,200568.30,0.00,0.00,326.00,216790.00,0.00,0.00,0.00),('1','187','939','240025',4599823,'2764','418',185720.18,185875.18,0.00,0.00,155.00,103075.00,0.00,0.00,0.00),('1','187','939','240025',4599824,'2765','418',132534.97,132634.97,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','187','939','240026',4599825,'2760','418',665123.48,665496.35,0.00,0.00,372.87,279652.50,0.00,0.00,0.00),('1','187','939','240026',4599826,'2761','418',364399.46,364699.46,0.00,0.00,300.00,199500.00,0.00,0.00,0.00),('1','187','939','240026',4599827,'2762','418',212154.46,212274.50,0.00,0.00,120.04,79826.60,0.00,0.00,0.00),('1','187','939','240026',4599828,'2763','418',200568.30,200668.30,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','187','939','240026',4599829,'2764','418',185875.18,186153.18,0.00,0.00,278.00,184870.00,0.00,0.00,0.00),('1','187','939','240026',4599830,'2765','418',132634.97,132734.97,0.00,0.00,100.00,66500.00,0.00,0.00,0.00),('1','187','939','240027',4599831,'2760','418',665496.35,665869.64,0.00,0.00,373.29,279967.50,0.00,0.00,0.00),('1','187','939','240027',4599832,'2761','418',364699.46,365510.96,0.00,0.00,811.50,532344.00,0.00,0.00,0.00),('1','187','939','240027',4599833,'2762','418',212274.50,212524.50,0.00,0.00,250.00,164000.00,0.00,0.00,0.00),('1','187','939','240027',4599834,'2763','418',200668.30,201002.30,0.00,0.00,334.00,219104.00,0.00,0.00,0.00),('1','187','939','240027',4599835,'2764','418',186153.18,186553.18,0.00,0.00,400.00,262400.00,0.00,0.00,0.00),('1','187','939','240027',4599836,'2765','418',132734.97,133268.97,0.00,0.00,534.00,350304.00,0.00,0.00,0.00),('1','187','939','240028',4599837,'2760','418',665869.64,666283.20,0.00,0.00,413.56,310170.00,0.00,0.00,0.00),('1','187','939','240028',4599838,'2761','418',365510.96,366631.96,0.00,0.00,1121.00,735376.00,0.00,0.00,0.00),('1','187','939','240028',4599839,'2762','418',212524.50,212712.50,0.00,0.00,188.00,123328.00,0.00,0.00,0.00),('1','187','939','240028',4599840,'2763','418',201002.30,201556.30,0.00,0.00,554.00,363424.00,0.00,0.00,0.00),('1','187','939','240028',4599841,'2764','418',186553.18,186934.18,0.00,0.00,381.00,249936.00,0.00,0.00,0.00),('1','187','939','240028',4599842,'2765','418',133268.97,133748.97,0.00,0.00,480.00,314880.00,0.00,0.00,0.00),('1','187','939','240029',4599843,'2760','418',666283.20,666656.29,0.00,0.00,373.09,279817.50,0.00,0.00,0.00),('1','187','939','240029',4599844,'2761','418',366631.96,367073.46,0.00,0.00,441.50,289624.00,0.00,0.00,0.00),('1','187','939','240029',4599845,'2762','418',212712.50,213131.74,0.00,0.00,419.24,275021.44,0.00,0.00,0.00),('1','187','939','240029',4599846,'2763','418',201556.30,201959.30,0.00,0.00,403.00,264368.00,0.00,0.00,0.00),('1','187','939','240029',4599847,'2764','418',186934.18,187284.18,0.00,0.00,350.00,229600.00,0.00,0.00,0.00),('1','187','939','240029',4599848,'2765','418',133748.97,133898.97,0.00,0.00,150.00,98400.00,0.00,0.00,0.00),('1','187','939','240030',4599849,'2760','418',666656.29,666733.95,0.00,0.00,77.66,58245.00,0.00,0.00,0.00),('1','187','939','240030',4599850,'2761','418',367073.46,367323.46,0.00,0.00,250.00,164000.00,0.00,0.00,0.00),('1','187','939','240030',4599851,'2762','418',213131.74,213131.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240030',4599852,'2763','418',201959.30,202059.30,0.00,0.00,100.00,65600.00,0.00,0.00,0.00),('1','187','939','240030',4599853,'2764','418',187284.18,187284.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240030',4599854,'2765','418',133898.97,133898.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240031',4599855,'2760','418',666733.95,666733.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240031',4599856,'2761','418',367323.46,367323.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240031',4599857,'2762','418',213131.74,213131.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240031',4599858,'2763','418',202059.30,202059.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240031',4599859,'2764','418',187284.18,187284.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240031',4599860,'2765','418',133898.97,133898.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240032',4599861,'2760','418',666733.95,667244.66,0.00,0.00,510.71,383032.50,0.00,0.00,0.00),('1','187','939','240032',4599862,'2761','418',367323.46,368324.46,0.00,0.00,1001.00,656656.00,0.00,0.00,0.00),('1','187','939','240032',4599863,'2762','418',213131.74,213516.74,0.00,0.00,385.00,252560.00,0.00,0.00,0.00),('1','187','939','240032',4599864,'2763','418',202059.30,202494.30,0.00,0.00,435.00,285360.00,0.00,0.00,0.00),('1','187','939','240032',4599865,'2764','418',187284.18,188202.18,0.00,0.00,918.00,601396.00,0.00,0.00,0.00),('1','187','939','240032',4599866,'2765','418',133898.97,134762.97,0.00,0.00,864.00,565972.00,0.00,0.00,0.00),('1','187','939','240033',4599867,'2760','418',667244.66,667513.05,0.00,0.00,268.39,201292.50,0.00,0.00,0.00),('1','187','939','240033',4599868,'2761','418',368324.46,369123.46,0.00,0.00,799.00,524144.00,0.00,0.00,0.00),('1','187','939','240033',4599869,'2762','418',213516.74,213716.74,0.00,0.00,200.00,131200.00,0.00,0.00,0.00),('1','187','939','240033',4599870,'2763','418',202494.30,202914.30,0.00,0.00,420.00,275520.00,0.00,0.00,0.00),('1','187','939','240033',4599871,'2764','418',188202.18,188652.18,0.00,0.00,450.00,295200.00,0.00,0.00,0.00),('1','187','939','240033',4599872,'2765','418',134762.97,134837.97,0.00,0.00,75.00,49200.00,0.00,0.00,0.00),('1','187','939','240034',4599873,'2760','418',667513.05,667827.62,0.00,0.00,314.57,235927.50,0.00,0.00,0.00),('1','187','939','240034',4599874,'2761','418',369123.46,369692.46,0.00,0.00,569.00,373264.00,0.00,0.00,0.00),('1','187','939','240034',4599875,'2762','418',213716.74,213736.74,0.00,0.00,20.00,13120.00,0.00,0.00,0.00),('1','187','939','240034',4599876,'2763','418',202914.30,202949.30,0.00,0.00,35.00,22960.00,0.00,0.00,0.00),('1','187','939','240034',4599877,'2764','418',188652.18,188871.18,0.00,0.00,219.00,143664.00,0.00,0.00,0.00),('1','187','939','240034',4599878,'2765','418',134837.97,134887.97,0.00,0.00,50.00,32800.00,0.00,0.00,0.00),('1','187','939','240035',4599879,'2760','418',667827.62,668136.62,0.00,0.00,309.00,231750.00,0.00,0.00,0.00),('1','187','939','240035',4599880,'2761','418',369692.46,370788.46,0.00,0.00,1096.00,718976.00,0.00,0.00,0.00),('1','187','939','240035',4599881,'2762','418',213736.74,213946.74,0.00,0.00,210.00,137760.00,0.00,0.00,0.00),('1','187','939','240035',4599882,'2763','418',202949.30,203199.30,0.00,0.00,250.00,164000.00,0.00,0.00,0.00),('1','187','939','240035',4599883,'2764','418',188871.18,188970.18,0.00,0.00,99.00,64944.00,0.00,0.00,0.00),('1','187','939','240035',4599884,'2765','418',134887.97,134985.97,0.00,0.00,98.00,64288.00,0.00,0.00,0.00),('1','187','939','240036',4599885,'2760','418',668136.62,668442.73,0.00,0.00,306.11,229582.50,0.00,0.00,0.00),('1','187','939','240036',4599886,'2761','418',370788.46,371790.46,0.00,0.00,1002.00,657312.00,0.00,0.00,0.00),('1','187','939','240036',4599887,'2762','418',213946.74,214021.74,0.00,0.00,75.00,49200.00,0.00,0.00,0.00),('1','187','939','240036',4599888,'2763','418',203199.30,203741.22,0.00,0.00,541.92,355499.52,0.00,0.00,0.00),('1','187','939','240036',4599889,'2764','418',188970.18,189320.18,0.00,0.00,350.00,229600.00,0.00,0.00,0.00),('1','187','939','240036',4599890,'2765','418',134985.97,135335.97,0.00,0.00,350.00,229600.00,0.00,0.00,0.00),('1','187','939','240037',4599891,'2760','418',668442.73,668768.95,0.00,0.00,326.22,244665.00,0.00,0.00,0.00),('1','187','939','240037',4599892,'2761','418',371790.46,372544.38,0.00,0.00,753.92,494571.52,0.00,0.00,0.00),('1','187','939','240037',4599893,'2762','418',214021.74,214096.74,0.00,0.00,75.00,49200.00,0.00,0.00,0.00),('1','187','939','240037',4599894,'2763','418',203741.22,204046.72,0.00,0.00,305.50,200408.00,0.00,0.00,0.00),('1','187','939','240037',4599895,'2764','418',189320.18,189420.18,0.00,0.00,100.00,65600.00,0.00,0.00,0.00),('1','187','939','240037',4599896,'2765','418',135335.97,135390.97,0.00,0.00,55.00,36080.00,0.00,0.00,0.00),('1','187','939','240038',4599897,'2760','418',668768.95,669001.36,0.00,0.00,232.41,174307.50,0.00,0.00,0.00),('1','187','939','240038',4599898,'2761','418',372544.38,372894.38,0.00,0.00,350.00,229600.00,0.00,0.00,0.00),('1','187','939','240038',4599899,'2762','418',214096.74,214206.74,0.00,0.00,110.00,72160.00,0.00,0.00,0.00),('1','187','939','240038',4599900,'2763','418',204046.72,204196.72,0.00,0.00,150.00,98400.00,0.00,0.00,0.00),('1','187','939','240038',4599901,'2764','418',189420.18,189479.33,0.00,0.00,59.15,38802.40,0.00,0.00,0.00),('1','187','939','240038',4599902,'2765','418',135390.97,135490.97,0.00,0.00,100.00,65600.00,0.00,0.00,0.00),('1','187','939','240039',4599903,'2760','418',669001.36,669292.49,0.00,0.00,291.13,218347.50,0.00,0.00,0.00),('1','187','939','240039',4599904,'2761','418',372894.38,373792.38,0.00,0.00,898.00,583700.00,0.00,0.00,0.00),('1','187','939','240039',4599905,'2762','418',214206.74,214412.74,0.00,0.00,206.00,133900.00,0.00,0.00,0.00),('1','187','939','240039',4599906,'2763','418',204196.72,204446.72,0.00,0.00,250.00,162500.00,0.00,0.00,0.00),('1','187','939','240039',4599907,'2764','418',189479.33,189929.33,0.00,0.00,450.00,292500.00,0.00,0.00,0.00),('1','187','939','240039',4599908,'2765','418',135490.97,135703.97,0.00,0.00,213.00,138450.00,0.00,0.00,0.00),('1','187','939','240040',4599909,'2760','418',669292.49,669597.48,0.00,0.00,304.99,228742.50,0.00,0.00,0.00),('1','187','939','240040',4599910,'2761','418',373792.38,374336.38,0.00,0.00,544.00,353600.00,0.00,0.00,0.00),('1','187','939','240040',4599911,'2762','418',214412.74,214626.74,0.00,0.00,214.00,139100.00,0.00,0.00,0.00),('1','187','939','240040',4599912,'2763','418',204446.72,204801.72,0.00,0.00,355.00,230750.00,0.00,0.00,0.00),('1','187','939','240040',4599913,'2764','418',189929.33,190104.33,0.00,0.00,175.00,113750.00,0.00,0.00,0.00),('1','187','939','240040',4599914,'2765','418',135703.97,135953.97,0.00,0.00,250.00,162500.00,0.00,0.00,0.00),('1','187','939','240041',4599915,'2760','418',669597.48,669756.07,0.00,0.00,158.59,118942.50,0.00,0.00,0.00),('1','187','939','240041',4599916,'2761','418',374336.38,374806.38,0.00,0.00,470.00,305500.00,0.00,0.00,0.00),('1','187','939','240041',4599917,'2762','418',214626.74,214776.74,0.00,0.00,150.00,97500.00,0.00,0.00,0.00),('1','187','939','240041',4599918,'2763','418',204801.72,204901.72,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','187','939','240041',4599919,'2764','418',190104.33,190304.33,0.00,0.00,200.00,130000.00,0.00,0.00,0.00),('1','187','939','240041',4599920,'2765','418',135953.97,136174.74,0.00,0.00,220.77,143500.50,0.00,0.00,0.00),('1','187','939','240042',4599921,'2760','418',669756.07,670037.48,0.00,0.00,281.41,211057.50,0.00,0.00,0.00),('1','187','939','240042',4599922,'2761','418',374806.38,375759.72,0.00,0.00,953.34,619361.01,0.00,0.00,0.00),('1','187','939','240042',4599923,'2762','418',214776.74,215465.50,0.00,0.00,688.76,447274.00,0.00,0.00,0.00),('1','187','939','240042',4599924,'2763','418',204901.72,205409.48,0.00,0.00,507.76,329870.00,0.00,0.00,0.00),('1','187','939','240042',4599925,'2764','418',190304.33,191202.97,0.00,0.00,898.64,583291.00,0.00,0.00,0.00),('1','187','939','240042',4599926,'2765','418',136174.74,137256.75,0.00,0.00,1082.01,702628.47,0.00,0.00,0.00),('1','187','939','240043',4599927,'2760','418',670037.48,670037.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240043',4599928,'2761','418',375759.72,375759.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240043',4599929,'2762','418',215465.50,215465.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240043',4599930,'2763','418',205409.48,205409.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240043',4599931,'2764','418',191202.97,191202.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240043',4599932,'2765','418',137256.75,137256.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240044',4599933,'2760','418',670037.48,670287.03,0.00,0.00,249.55,187162.50,0.00,0.00,0.00),('1','187','939','240044',4599934,'2761','418',375759.72,376340.22,0.00,0.00,580.50,377325.00,0.00,0.00,0.00),('1','187','939','240044',4599935,'2762','418',215465.50,215635.50,0.00,0.00,170.00,110500.00,0.00,0.00,0.00),('1','187','939','240044',4599936,'2763','418',205409.48,205804.86,0.00,0.00,395.38,256997.00,0.00,0.00,0.00),('1','187','939','240044',4599937,'2764','418',191202.97,191302.97,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','187','939','240044',4599938,'2765','418',137256.75,137356.75,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','187','939','240045',4599939,'2760','418',670287.03,670595.72,0.00,0.00,308.69,231517.50,0.00,0.00,0.00),('1','187','939','240045',4599940,'2761','418',376340.22,378268.22,0.00,0.00,1928.00,1253200.00,0.00,0.00,0.00),('1','187','939','240045',4599941,'2762','418',215635.50,215900.88,0.00,0.00,265.38,172497.00,0.00,0.00,0.00),('1','187','939','240045',4599942,'2763','418',205804.86,206488.86,0.00,0.00,684.00,444600.00,0.00,0.00,0.00),('1','187','939','240045',4599943,'2764','418',191302.97,192092.97,0.00,0.00,790.00,513500.00,0.00,0.00,0.00),('1','187','939','240045',4599944,'2765','418',137356.75,137956.67,0.00,0.00,599.92,389948.00,0.00,0.00,0.00),('1','187','939','240046',4599945,'2760','418',670595.72,670923.10,0.00,0.00,327.38,245535.00,0.00,0.00,0.00),('1','187','939','240046',4599946,'2761','418',378268.22,379580.22,0.00,0.00,1312.00,852800.00,0.00,0.00,0.00),('1','187','939','240046',4599947,'2762','418',215900.88,216000.88,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','187','939','240046',4599948,'2763','418',206488.86,206693.86,0.00,0.00,205.00,133250.00,0.00,0.00,0.00),('1','187','939','240046',4599949,'2764','418',192092.97,192192.97,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','187','939','240046',4599950,'2765','418',137956.67,138006.67,0.00,0.00,50.00,32500.00,0.00,0.00,0.00),('1','187','939','240047',4599951,'2760','418',670923.10,671216.02,0.00,0.00,292.92,219690.00,0.00,0.00,0.00),('1','187','939','240047',4599952,'2761','418',379580.22,380358.22,0.00,0.00,778.00,505700.00,0.00,0.00,0.00),('1','187','939','240047',4599953,'2762','418',216000.88,216000.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240047',4599954,'2763','418',206693.86,207093.86,0.00,0.00,400.00,260000.00,0.00,0.00,0.00),('1','187','939','240047',4599955,'2764','418',192192.97,192331.59,0.00,0.00,138.62,90103.00,0.00,0.00,0.00),('1','187','939','240047',4599956,'2765','418',138006.67,138256.67,0.00,0.00,250.00,162500.00,0.00,0.00,0.00),('1','187','939','240048',4599957,'2760','418',671216.02,671623.39,0.00,0.00,407.37,305527.50,0.00,0.00,0.00),('1','187','939','240048',4599958,'2761','418',380358.22,380934.99,0.00,0.00,576.77,375700.50,0.00,0.00,0.00),('1','187','939','240048',4599959,'2762','418',216000.88,216545.88,0.00,0.00,545.00,354250.00,0.00,0.00,0.00),('1','187','939','240048',4599960,'2763','418',207093.86,207383.86,0.00,0.00,290.00,187920.00,0.00,0.00,0.00),('1','187','939','240048',4599961,'2764','418',192331.59,192877.59,0.00,0.00,546.00,354320.00,0.00,0.00,0.00),('1','187','939','240048',4599962,'2765','418',138256.67,138832.67,0.00,0.00,576.00,373936.00,0.00,0.00,0.00),('1','187','939','240049',4599963,'2760','418',671623.39,672035.11,0.00,0.00,411.72,308790.00,0.00,0.00,0.00),('1','187','939','240049',4599964,'2761','418',380934.99,381722.99,0.00,0.00,788.00,512200.00,0.00,0.00,0.00),('1','187','939','240049',4599965,'2762','418',216545.88,216638.03,0.00,0.00,92.15,59897.50,0.00,0.00,0.00),('1','187','939','240049',4599966,'2763','418',207383.86,207634.86,0.00,0.00,251.00,163150.00,0.00,0.00,0.00),('1','187','939','240049',4599967,'2764','418',192877.59,192877.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240049',4599968,'2765','418',138832.67,138907.67,0.00,0.00,75.00,48750.00,0.00,0.00,0.00),('1','187','939','240050',4599969,'2760','418',672035.11,672242.54,0.00,0.00,207.43,155572.50,0.00,0.00,0.00),('1','187','939','240050',4599970,'2761','418',381722.99,382459.99,0.00,0.00,737.00,479050.00,0.00,0.00,0.00),('1','187','939','240050',4599971,'2762','418',216638.03,216886.03,0.00,0.00,248.00,161200.00,0.00,0.00,0.00),('1','187','939','240050',4599972,'2763','418',207634.86,207936.63,0.00,0.00,301.77,196150.50,0.00,0.00,0.00),('1','187','939','240050',4599973,'2764','418',192877.59,193097.59,0.00,0.00,220.00,143000.00,0.00,0.00,0.00),('1','187','939','240050',4599974,'2765','418',138907.67,138907.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240051',4599975,'2760','418',672242.54,672500.27,0.00,0.00,257.73,193297.50,0.00,0.00,0.00),('1','187','939','240051',4599976,'2761','418',382459.99,383639.68,0.00,0.00,1179.69,766798.50,0.00,0.00,0.00),('1','187','939','240051',4599977,'2762','418',216886.03,217255.88,0.00,0.00,369.85,240402.50,0.00,0.00,0.00),('1','187','939','240051',4599978,'2763','418',207936.63,208141.63,0.00,0.00,205.00,133250.00,0.00,0.00,0.00),('1','187','939','240051',4599979,'2764','418',193097.59,193247.59,0.00,0.00,150.00,97500.00,0.00,0.00,0.00),('1','187','939','240051',4599980,'2765','418',138907.67,138970.17,0.00,0.00,62.50,40625.00,0.00,0.00,0.00),('1','187','939','240052',4599981,'2760','418',672500.27,672804.35,0.00,0.00,304.08,228060.00,0.00,0.00,0.00),('1','187','939','240052',4599982,'2761','418',383639.68,384139.68,0.00,0.00,500.00,325000.00,0.00,0.00,0.00),('1','187','939','240052',4599983,'2762','418',217255.88,217553.88,0.00,0.00,298.00,193700.00,0.00,0.00,0.00),('1','187','939','240052',4599984,'2763','418',208141.63,208341.63,0.00,0.00,200.00,130000.00,0.00,0.00,0.00),('1','187','939','240052',4599985,'2764','418',193247.59,193347.59,0.00,0.00,100.00,65000.00,0.00,0.00,0.00),('1','187','939','240052',4599986,'2765','418',138970.17,139320.17,0.00,0.00,350.00,227500.00,0.00,0.00,0.00),('1','187','939','240053',4599987,'2760','418',672804.35,673106.75,0.00,0.00,302.40,226800.00,0.00,0.00,0.00),('1','187','939','240053',4599988,'2761','418',384139.68,385239.68,0.00,0.00,1100.00,715000.00,0.00,0.00,0.00),('1','187','939','240053',4599989,'2762','418',217553.88,217906.88,0.00,0.00,353.00,229450.00,0.00,0.00,0.00),('1','187','939','240053',4599990,'2763','418',208341.63,208887.70,0.00,0.00,546.07,354945.50,0.00,0.00,0.00),('1','187','939','240053',4599991,'2764','418',193347.59,193932.59,0.00,0.00,585.00,380250.00,0.00,0.00,0.00),('1','187','939','240053',4599992,'2765','418',139320.17,139770.17,0.00,0.00,450.00,292500.00,0.00,0.00,0.00),('1','187','939','240054',4599993,'2760','418',673106.75,673262.22,0.00,0.00,155.47,116602.50,0.00,0.00,0.00),('1','187','939','240054',4599994,'2761','418',385239.68,385489.68,0.00,0.00,250.00,162500.00,0.00,0.00,0.00),('1','187','939','240054',4599995,'2762','418',217906.88,218106.88,0.00,0.00,200.00,130000.00,0.00,0.00,0.00),('1','187','939','240054',4599996,'2763','418',208887.70,209057.70,0.00,0.00,170.00,110500.00,0.00,0.00,0.00),('1','187','939','240054',4599997,'2764','418',193932.59,194132.59,0.00,0.00,200.00,130000.00,0.00,0.00,0.00),('1','187','939','240054',4599998,'2765','418',139770.17,139820.17,0.00,0.00,50.00,32500.00,0.00,0.00,0.00),('1','187','939','240055',4599999,'2760','418',673262.22,673262.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240055',4600000,'2761','418',385489.68,385489.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240055',4600001,'2762','418',218106.88,218106.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240055',4600002,'2763','418',209057.70,209057.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240055',4600003,'2764','418',194132.59,194132.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240055',4600004,'2765','418',139820.17,139820.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240056',4600005,'2760','418',673262.22,673681.40,0.00,0.00,419.18,297617.80,0.00,0.00,0.00),('1','187','939','240056',4600006,'2761','418',385489.68,386460.85,0.00,0.00,971.17,621548.80,0.00,0.00,0.00),('1','187','939','240056',4600007,'2762','418',218106.88,218670.38,0.00,0.00,563.50,360640.00,0.00,0.00,0.00),('1','187','939','240056',4600008,'2763','418',209057.70,209381.36,0.00,0.00,323.66,207142.40,0.00,0.00,0.00),('1','187','939','240056',4600009,'2764','418',194132.59,194883.37,0.00,0.00,750.78,480499.20,0.00,0.00,0.00),('1','187','939','240056',4600010,'2765','418',139820.17,140367.02,0.00,0.00,546.85,349984.00,0.00,0.00,0.00),('1','187','939','240057',4600011,'2760','418',673681.40,674143.30,0.00,0.00,461.90,327949.00,0.00,0.00,0.00),('1','187','939','240057',4600012,'2761','418',386460.85,387154.85,0.00,0.00,694.00,444160.00,0.00,0.00,0.00),('1','187','939','240057',4600013,'2762','418',218670.38,219116.38,0.00,0.00,446.00,285440.00,0.00,0.00,0.00),('1','187','939','240057',4600014,'2763','418',209381.36,209651.36,0.00,0.00,270.00,172800.00,0.00,0.00,0.00),('1','187','939','240057',4600015,'2764','418',194883.37,195555.37,0.00,0.00,672.00,430080.00,0.00,0.00,0.00),('1','187','939','240057',4600016,'2765','418',140367.02,140667.02,0.00,0.00,300.00,192000.00,0.00,0.00,0.00),('1','187','939','240058',4600017,'2760','418',674143.30,674472.25,0.00,0.00,328.95,233554.50,0.00,0.00,0.00),('1','187','939','240058',4600018,'2761','418',387154.85,387574.85,0.00,0.00,420.00,268800.00,0.00,0.00,0.00),('1','187','939','240058',4600019,'2762','418',219116.38,219271.88,0.00,0.00,155.50,99520.00,0.00,0.00,0.00),('1','187','939','240058',4600020,'2763','418',209651.36,210042.19,0.00,0.00,390.83,250131.20,0.00,0.00,0.00),('1','187','939','240058',4600021,'2764','418',195555.37,195955.37,0.00,0.00,400.00,256000.00,0.00,0.00,0.00),('1','187','939','240058',4600022,'2765','418',140667.02,140917.02,0.00,0.00,250.00,160000.00,0.00,0.00,0.00),('1','187','939','240059',4600023,'2760','418',674472.25,674956.67,0.00,0.00,484.42,343938.20,0.00,0.00,0.00),('1','187','939','240059',4600024,'2761','418',387574.85,388687.85,0.00,0.00,1113.00,712616.10,0.00,0.00,0.00),('1','187','939','240059',4600025,'2762','418',219271.88,219371.88,0.00,0.00,100.00,64000.00,0.00,0.00,0.00),('1','187','939','240059',4600026,'2763','418',210042.19,210332.19,0.00,0.00,290.00,185600.00,0.00,0.00,0.00),('1','187','939','240059',4600027,'2764','418',195955.37,196205.37,0.00,0.00,250.00,160000.00,0.00,0.00,0.00),('1','187','939','240059',4600028,'2765','418',140917.02,140967.02,0.00,0.00,50.00,32000.00,0.00,0.00,0.00),('1','187','939','240060',4600029,'2760','418',674956.67,675234.42,0.00,0.00,277.75,197202.50,0.00,0.00,0.00),('1','187','939','240060',4600030,'2761','418',388687.85,389598.29,0.00,0.00,910.44,583125.40,0.00,0.00,0.00),('1','187','939','240060',4600031,'2762','418',219371.88,219446.88,0.00,0.00,75.00,48000.00,0.00,0.00,0.00),('1','187','939','240060',4600032,'2763','418',210332.19,210620.19,0.00,0.00,288.00,184320.00,0.00,0.00,0.00),('1','187','939','240060',4600033,'2764','418',196205.37,196236.62,0.00,0.00,31.25,20000.00,0.00,0.00,0.00),('1','187','939','240060',4600034,'2765','418',140967.02,140967.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240061',4600035,'2760','418',675234.42,675642.51,0.00,0.00,408.09,289743.90,0.00,0.00,0.00),('1','187','939','240061',4600036,'2761','418',389598.29,389998.29,0.00,0.00,400.00,256000.00,0.00,0.00,0.00),('1','187','939','240061',4600037,'2762','418',219446.88,219446.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240061',4600038,'2763','418',210620.19,210980.19,0.00,0.00,360.00,230400.00,0.00,0.00,0.00),('1','187','939','240061',4600039,'2764','418',196236.62,196425.68,0.00,0.00,189.06,120998.40,0.00,0.00,0.00),('1','187','939','240061',4600040,'2765','418',140967.02,141187.02,0.00,0.00,220.00,140800.00,0.00,0.00,0.00),('1','187','939','240062',4600041,'2760','418',675642.51,676068.75,0.00,0.00,426.24,302630.40,0.00,0.00,0.00),('1','187','939','240062',4600042,'2761','418',389998.29,390734.29,0.00,0.00,736.00,471040.00,0.00,0.00,0.00),('1','187','939','240062',4600043,'2762','418',219446.88,219646.88,0.00,0.00,200.00,128000.00,0.00,0.00,0.00),('1','187','939','240062',4600044,'2763','418',210980.19,211015.66,0.00,0.00,35.47,22700.80,0.00,0.00,0.00),('1','187','939','240062',4600045,'2764','418',196425.68,196525.68,0.00,0.00,100.00,64000.00,0.00,0.00,0.00),('1','187','939','240062',4600046,'2765','418',141187.02,141187.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240063',4600047,'2760','418',676068.75,676577.65,0.00,0.00,508.90,361319.00,0.00,0.00,0.00),('1','187','939','240063',4600048,'2761','418',390734.29,392074.26,0.00,0.00,1339.97,857580.80,0.00,0.00,0.00),('1','187','939','240063',4600049,'2762','418',219646.88,219858.88,0.00,0.00,212.00,135680.00,0.00,0.00,0.00),('1','187','939','240063',4600050,'2763','418',211015.66,211535.66,0.00,0.00,520.00,332800.00,0.00,0.00,0.00),('1','187','939','240063',4600051,'2764','418',196525.68,196845.68,0.00,0.00,320.00,204800.00,0.00,0.00,0.00),('1','187','939','240063',4600052,'2765','418',141187.02,141212.02,0.00,0.00,25.00,16000.00,0.00,0.00,0.00),('1','187','939','240064',4600053,'2760','418',676577.65,676918.70,0.00,0.00,341.05,242145.50,0.00,0.00,0.00),('1','187','939','240064',4600054,'2761','418',392074.26,393334.51,0.00,0.00,1260.25,806717.50,0.00,0.00,0.00),('1','187','939','240064',4600055,'2762','418',219858.88,219958.88,0.00,0.00,100.00,64000.00,0.00,0.00,0.00),('1','187','939','240064',4600056,'2763','418',211535.66,212009.66,0.00,0.00,474.00,303360.00,0.00,0.00,0.00),('1','187','939','240064',4600057,'2764','418',196845.68,197135.68,0.00,0.00,290.00,185600.00,0.00,0.00,0.00),('1','187','939','240064',4600058,'2765','418',141212.02,141736.02,0.00,0.00,524.00,335360.00,0.00,0.00,0.00),('1','187','939','240065',4600059,'2760','418',676918.70,677222.61,0.00,0.00,303.91,215776.10,0.00,0.00,0.00),('1','187','939','240065',4600060,'2761','418',393334.51,393702.01,0.00,0.00,367.50,235200.00,0.00,0.00,0.00),('1','187','939','240065',4600061,'2762','418',219958.88,220008.88,0.00,0.00,50.00,32000.00,0.00,0.00,0.00),('1','187','939','240065',4600062,'2763','418',212009.66,212116.66,0.00,0.00,107.00,68480.00,0.00,0.00,0.00),('1','187','939','240065',4600063,'2764','418',197135.68,197135.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240065',4600064,'2765','418',141736.02,141736.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240066',4600065,'2760','418',677222.61,677428.95,0.00,0.00,206.34,146501.40,0.00,0.00,0.00),('1','187','939','240066',4600066,'2761','418',393702.01,394418.01,0.00,0.00,716.00,458240.00,0.00,0.00,0.00),('1','187','939','240066',4600067,'2762','418',220008.88,220378.88,0.00,0.00,370.00,236800.00,0.00,0.00,0.00),('1','187','939','240066',4600068,'2763','418',212116.66,212466.66,0.00,0.00,350.00,224000.00,0.00,0.00,0.00),('1','187','939','240066',4600069,'2764','418',197135.68,197170.68,0.00,0.00,35.00,22400.00,0.00,0.00,0.00),('1','187','939','240066',4600070,'2765','418',141736.02,142229.21,0.00,0.00,493.19,315641.60,0.00,0.00,0.00),('1','187','939','240067',4600071,'2760','418',677428.95,677428.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240067',4600072,'2761','418',394418.01,394418.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240067',4600073,'2762','418',220378.88,220378.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240067',4600074,'2763','418',212466.66,212466.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240067',4600075,'2764','418',197170.68,197170.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240067',4600076,'2765','418',142229.21,142229.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','187','939','240068',4600077,'2760','418',677428.95,677843.92,0.00,0.00,414.97,294628.70,0.00,0.00,0.00),('1','187','939','240068',4600078,'2761','418',394418.01,396890.11,0.00,0.00,2472.10,1582144.00,0.00,0.00,0.00),('1','187','939','240068',4600079,'2762','418',220378.88,220890.38,0.00,0.00,511.50,327360.00,0.00,0.00,0.00),('1','187','939','240068',4600080,'2763','418',212466.66,213165.82,0.00,0.00,699.16,447462.40,0.00,0.00,0.00),('1','187','939','240068',4600081,'2764','418',197170.68,198004.11,0.00,0.00,833.43,533395.20,0.00,0.00,0.00),('1','187','939','240068',4600082,'2765','418',142229.21,142845.68,0.00,0.00,616.47,394540.80,0.00,0.00,0.00),('1','187','939','240069',4600083,'2760','418',677843.92,678146.89,0.00,0.00,302.97,215108.70,0.00,0.00,0.00),('1','187','939','240069',4600084,'2761','418',396890.11,397640.11,0.00,0.00,750.00,480000.00,0.00,0.00,0.00),('1','187','939','240069',4600085,'2762','418',220890.38,221040.38,0.00,0.00,150.00,96000.00,0.00,0.00,0.00),('1','187','939','240069',4600086,'2763','418',213165.82,213225.82,0.00,0.00,60.00,38400.00,0.00,0.00,0.00),('1','187','939','240069',4600087,'2764','418',198004.11,198154.11,0.00,0.00,150.00,96000.00,0.00,0.00,0.00),('1','187','939','240069',4600088,'2765','418',142845.68,142895.68,0.00,0.00,50.00,32000.00,0.00,0.00,0.00),('1','187','939','240070',4600089,'2760','418',678146.89,678477.34,0.00,0.00,330.45,234619.50,0.00,0.00,0.00),('1','187','939','240070',4600090,'2761','418',397640.11,398275.11,0.00,0.00,635.00,406400.00,0.00,0.00,0.00),('1','187','939','240070',4600091,'2762','418',221040.38,221448.97,0.00,0.00,408.59,261497.60,0.00,0.00,0.00),('1','187','939','240070',4600092,'2763','418',213225.82,213425.82,0.00,0.00,200.00,128000.00,0.00,0.00,0.00),('1','187','939','240070',4600093,'2764','418',198154.11,198524.11,0.00,0.00,370.00,236800.00,0.00,0.00,0.00),('1','187','939','240070',4600094,'2765','418',142895.68,143475.68,0.00,0.00,580.00,371200.00,0.00,0.00,0.00),('1','187','939','240071',4600095,'2760','418',678477.34,678940.47,0.00,0.00,463.13,328822.30,0.00,0.00,0.00),('1','187','939','240071',4600096,'2761','418',398275.11,399360.85,0.00,0.00,1085.74,694873.60,0.00,0.00,0.00),('1','187','939','240071',4600097,'2762','418',221448.97,221622.65,0.00,0.00,173.68,111155.20,0.00,0.00,0.00),('1','187','939','240071',4600098,'2763','418',213425.82,213712.79,0.00,0.00,286.97,183660.80,0.00,0.00,0.00),('1','187','939','240071',4600099,'2764','418',198524.11,198923.42,0.00,0.00,399.31,255558.40,0.00,0.00,0.00),('1','187','939','240071',4600100,'2765','418',143475.68,143813.51,0.00,0.00,337.83,216211.20,0.00,0.00,0.00),('1','187','939','240072',4600101,'2760','418',678940.47,679339.59,0.00,0.00,399.12,283375.20,0.00,0.00,0.00),('1','187','939','240072',4600102,'2761','418',399360.85,399592.93,0.00,0.00,232.08,148531.20,0.00,0.00,0.00),('1','187','939','240072',4600103,'2762','418',221622.65,221897.65,0.00,0.00,275.00,176000.00,0.00,0.00,0.00),('1','187','939','240072',4600104,'2763','418',213712.79,213915.79,0.00,0.00,203.00,129920.00,0.00,0.00,0.00),('1','187','939','240072',4600105,'2764','418',198923.42,199173.42,0.00,0.00,250.00,160000.00,0.00,0.00,0.00),('1','187','939','240072',4600106,'2765','418',143813.51,143938.34,0.00,0.00,124.83,79891.20,0.00,0.00,0.00),('1','187','939','240073',4600107,'2760','418',679339.59,0.00,0.00,0.00,850.00,595000.00,0.00,0.00,0.00),('1','187','939','240073',4600108,'2761','418',399592.93,0.00,0.00,0.00,1770.00,1115100.00,0.00,0.00,0.00),('1','187','939','240073',4600109,'2762','418',221897.65,0.00,0.00,0.00,343.00,216090.00,0.00,0.00,0.00),('1','187','939','240073',4600110,'2763','418',213915.79,0.00,0.00,0.00,430.00,270900.00,0.00,0.00,0.00),('1','187','939','240073',4600111,'2764','418',199173.42,0.00,0.00,0.00,400.00,252000.00,0.00,0.00,0.00),('1','187','939','240073',4600112,'2765','418',143938.34,0.00,0.00,0.00,510.00,321300.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=683900 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','187','204280','418',292.00,376.00,0.00,1247.60,364299.20,398697.60,34398.40,591586),('1','187','204283','418',292.00,376.00,0.00,495.18,144592.56,168587.68,23995.12,591591),('1','187','204398','418',292.00,376.00,0.00,0.00,0.00,0.00,0.00,591900),('1','187','204402','418',292.00,376.00,0.00,883.78,258063.76,296461.28,38397.52,591910),('1','187','204615','418',292.00,376.00,0.00,1677.67,489879.64,528147.92,38268.28,592460),('1','187','204836','418',292.00,376.00,0.00,507.78,148271.76,161242.08,12970.32,592988),('1','187','204925','418',292.00,376.00,0.00,0.00,0.00,0.00,0.00,593215),('1','187','204931','418',292.00,376.00,0.00,712.17,207953.64,227251.12,19297.48,593229),('1','187','205053','418',292.00,376.00,0.00,1090.65,318469.80,353764.40,35294.60,593533),('1','187','205241','418',292.00,376.00,0.00,1922.38,561334.96,609662.88,48327.92,594036),('1','187','205478','418',292.00,376.00,0.00,1076.46,314326.32,337676.96,23350.64,594632),('1','187','205691','418',292.00,376.00,0.00,0.00,0.00,0.00,0.00,595208),('1','187','205753','418',292.00,376.00,0.00,4754.14,1388208.88,1487861.04,99652.16,595347),('1','187','206119','418',292.00,376.00,0.00,4507.25,1316117.00,1437186.00,121069.00,596306),('1','187','206181','418',292.00,376.00,0.00,393.51,114904.92,127239.76,12334.84,596448),('1','187','206289','418',292.00,376.00,0.00,0.00,0.00,0.00,0.00,596737),('1','187','206328','418',305.00,376.00,0.00,3409.43,1039876.15,1096585.68,56709.53,596834),('1','187','206393','418',305.00,376.00,0.00,3567.03,1087944.15,1154835.28,66891.13,596987),('1','187','206754','418',305.00,376.00,0.00,1449.39,442063.95,469034.64,26970.69,597930),('1','187','206803','418',305.00,376.00,0.00,2846.50,868182.50,922416.00,54233.50,598043),('1','187','207025','418',305.00,376.00,0.00,3640.32,1110297.60,1182952.32,72654.72,598623),('1','187','207252','418',305.00,376.00,0.00,4550.13,1387789.65,1467696.88,79907.23,599208),('1','187','207486','418',305.00,376.00,0.00,3983.19,1214872.95,1289583.44,74710.49,599815),('1','187','207709','418',305.00,376.00,0.00,796.58,242956.90,261901.58,18944.68,600375),('1','187','207847','418',305.00,376.00,0.00,0.00,0.00,0.00,0.00,600737),('1','187','208325','418',310.00,376.00,0.00,13281.92,4117395.20,4328018.42,210623.22,601953),('1','187','208539','418',310.00,376.00,0.00,5173.13,1603670.30,1731790.88,128120.58,602515),('1','187','208763','418',310.00,376.00,0.00,760.85,235863.50,257219.60,21356.10,603083),('1','187','208845','418',310.00,376.00,0.00,0.00,0.00,0.00,0.00,603275),('1','187','208856','418',320.00,376.00,0.00,3245.06,1038419.20,1099457.06,61037.86,603302),('1','187','209005','418',320.00,376.00,0.00,4332.35,1386352.00,1464812.60,78460.60,603686),('1','187','209221','418',320.00,376.00,0.00,9162.98,2932153.60,3091353.48,159199.88,604243),('1','187','209414','418',320.00,376.00,0.00,0.00,0.00,0.00,0.00,604741),('1','187','209505','418',340.00,376.00,0.00,6529.60,2220064.00,2309245.40,89181.40,604966),('1','187','209687','418',340.00,384.00,0.00,2538.52,863096.80,901631.68,38534.88,605427),('1','187','209871','418',340.00,384.00,0.00,4074.10,1385194.00,1481432.40,96238.40,605908),('1','187','210112','418',340.00,400.00,0.00,4661.50,1584910.00,1694189.00,109279.00,606538),('1','187','210319','418',340.00,400.00,0.00,2922.25,993565.00,1062804.00,69239.00,607070),('1','187','210560','418',340.00,400.00,0.00,3668.70,1247358.00,1312305.90,64947.90,607699),('1','187','210690','418',340.00,400.00,0.00,0.00,0.00,0.00,0.00,608060),('1','187','210763','418',342.00,400.00,0.00,9485.30,3243972.60,3398124.40,154151.80,608240),('1','187','210962','418',342.00,400.00,0.00,6876.95,2351916.90,2442844.40,90927.50,608746),('1','187','211197','418',342.00,400.00,0.00,4356.45,1489905.90,1565871.50,75965.60,609343),('1','187','211390','418',342.00,400.00,0.00,3865.90,1322137.80,1387217.00,65079.20,609854),('1','187','211586','418',342.00,400.00,0.00,0.00,0.00,0.00,0.00,610376),('1','187','211683','418',350.00,400.00,0.00,3230.40,1130640.00,1186148.00,55508.00,610606),('1','187','211872','418',350.00,400.00,0.00,1636.00,572600.00,599490.00,26890.00,611097),('1','187','211912','418',350.00,400.00,0.00,0.00,0.00,0.00,0.00,611202),('1','187','212700','418',368.00,400.00,0.00,2379.85,875784.80,895338.00,19553.20,613275),('1','187','212879','418',368.00,400.00,0.00,3985.75,1466756.00,1489670.00,22914.00,613738),('1','187','213147','418',368.00,400.00,0.00,16574.25,6099324.00,6155134.00,55810.00,614433),('1','187','213402','418',368.00,400.00,0.00,1603.88,590227.84,602314.62,12086.78,615087),('1','187','213745','418',368.00,400.00,0.00,0.00,0.00,0.00,0.00,616004),('1','187','213750','418',368.00,400.00,0.00,2829.50,1041256.00,1060196.00,18940.00,616016),('1','187','213900','418',368.00,400.00,0.00,4350.10,1600836.80,1632234.90,31398.10,616408),('1','187','214105','418',368.00,400.00,0.00,4560.75,1678356.00,1712474.00,34118.00,616939),('1','187','214369','418',368.00,400.00,0.00,1675.25,616492.00,631698.00,15206.00,617620),('1','187','214546','418',368.00,400.00,0.00,5613.00,2065584.00,2104631.00,39047.00,618078),('1','187','214793','418',368.00,400.00,0.00,5331.90,1962139.20,1997523.60,35384.40,618722),('1','187','214972','418',368.00,400.00,0.00,0.00,0.00,0.00,0.00,619207),('1','187','214996','418',368.00,400.00,0.00,10239.95,3768301.60,3834076.80,65775.20,619263),('1','187','215224','418',368.00,400.00,0.00,5648.75,2078740.00,2118008.00,39268.00,619843),('1','187','215438','418',368.00,400.00,0.00,7700.25,2833692.00,2885054.50,51362.50,620399),('1','187','215684','418',368.00,400.00,0.00,916.25,337180.00,343243.00,6063.00,621027),('1','187','215735','418',368.00,400.00,0.00,0.00,0.00,0.00,0.00,621159),('1','187','215915','418',375.00,400.00,0.00,3355.72,1258395.00,1321554.00,63159.00,621617),('1','187','216102','418',375.00,450.00,0.00,6893.02,2584882.50,2700715.80,115833.30,622109),('1','187','216321','418',375.00,450.00,0.00,5330.44,1998915.00,2088234.00,89319.00,622679),('1','187','216558','418',375.00,450.00,0.00,6836.79,2563796.25,2679025.50,115229.25,623303),('1','187','216791','418',375.00,450.00,0.00,2034.47,762926.25,798031.50,35105.25,623919),('1','187','216926','418',375.00,450.00,0.00,0.00,0.00,0.00,0.00,624277),('1','187','217022','418',405.00,450.00,0.00,603.54,244433.70,262189.20,17755.50,624519),('1','187','217291','418',405.00,480.00,0.00,2605.47,1055215.35,1108725.60,53510.25,625220),('1','187','217520','418',405.00,480.00,0.00,3497.46,1416471.30,1475907.00,59435.70,625819),('1','187','217712','418',405.00,480.00,0.00,3788.10,1534180.50,1600368.00,66187.50,626322),('1','187','217992','418',405.00,480.00,0.00,2695.37,1091624.85,1144197.60,52572.75,627059),('1','187','218229','418',405.00,480.00,0.00,3938.43,1595064.15,1663466.40,68402.25,627687),('1','187','218452','418',405.00,480.00,0.00,2400.50,972202.50,1020420.00,48217.50,628273),('1','187','218687','418',405.00,480.00,0.00,2833.28,1147478.40,1205234.40,57756.00,628880),('1','187','218904','418',405.00,480.00,0.00,1778.17,720158.85,751341.60,31182.75,629457),('1','187','218972','418',405.00,480.00,0.00,0.00,0.00,0.00,0.00,629620),('1','187','219411','418',400.00,480.00,0.00,8479.78,3391912.00,3516094.40,124182.40,630768),('1','187','219609','418',400.00,480.00,0.00,2970.48,1188192.00,1233798.40,45606.40,631287),('1','187','219813','418',400.00,480.00,0.00,6638.41,2655364.00,2750080.80,94716.80,631829),('1','187','220043','418',400.00,480.00,0.00,6378.85,2551540.00,2636440.00,84900.00,632447),('1','187','220212','418',400.00,480.00,0.00,0.00,0.00,0.00,0.00,632904),('1','187','220718','418',400.00,480.00,0.00,6064.39,2407562.83,2512019.20,104456.37,634203),('1','187','220914','418',397.00,480.00,0.00,9210.46,3656552.62,3812352.80,155800.18,634722),('1','187','221152','418',397.00,480.00,0.00,9011.14,3577422.58,3729123.20,151700.62,635330),('1','187','221534','418',397.00,480.00,0.00,0.00,0.00,0.00,0.00,636339),('1','187','222126','418',397.00,480.00,0.00,8527.33,3385350.01,3525085.16,139735.15,637880),('1','187','222274','418',397.00,480.00,0.00,7809.38,3100323.86,3227486.40,127162.54,638251),('1','187','222515','418',397.00,480.00,0.00,6777.04,2690484.88,2793469.20,102984.32,638864),('1','187','223041','418',397.00,480.00,0.00,2464.00,1010240.00,1054790.00,44550.00,640280),('1','187','223189','418',410.00,480.00,0.00,15781.86,6470562.60,6672503.30,201940.70,640641),('1','187','223432','418',410.00,480.00,0.00,3655.10,1498591.00,1631335.20,132744.20,641237),('1','187','223647','418',410.00,480.00,0.00,2649.40,1086254.00,1179588.00,93334.00,641791),('1','187','223783','418',410.00,480.00,0.00,0.00,0.00,0.00,0.00,642149),('1','187','224125','418',410.00,480.00,0.00,600.00,246000.00,238200.00,-7800.00,643026),('1','187','224127','418',410.00,480.00,0.00,0.00,0.00,0.00,0.00,643030),('1','187','224419','418',435.00,510.00,0.00,563.58,245157.30,273925.80,28768.50,643793),('1','187','224563','418',435.00,510.00,0.00,1151.03,500698.05,559455.30,58757.25,644170),('1','187','224785','418',435.00,510.00,0.00,8059.08,3505699.80,3810550.80,304851.00,644734),('1','187','225033','418',435.00,510.00,0.00,2707.63,1177819.05,1272036.30,94217.25,645369),('1','187','225267','418',435.00,510.00,0.00,4525.18,1968453.30,2115961.80,147508.50,645986),('1','187','225487','418',435.00,510.00,0.00,1838.92,799930.20,870349.20,70419.00,646551),('1','187','225711','418',435.00,510.00,0.00,5714.51,2485811.85,2660825.10,175013.25,647127),('1','187','226047','418',435.00,510.00,0.00,0.00,0.00,0.00,0.00,648009),('1','187','226061','418',435.00,510.00,0.00,3025.88,1407034.20,1457248.80,50214.60,648047),('1','187','226280','418',465.00,510.00,0.00,4106.61,1909573.65,1978811.10,69237.45,648613),('1','187','226482','418',465.00,510.00,0.00,5392.84,2507670.60,2594228.40,86557.80,649125),('1','187','226737','418',465.00,510.00,0.00,4149.10,1929331.50,1997601.00,68269.50,649786),('1','187','226968','418',465.00,510.00,0.00,7661.76,3562718.40,3685107.60,122389.20,650394),('1','187','227166','418',465.00,510.00,0.00,0.00,0.00,0.00,0.00,650921),('1','187','227383','418',465.00,510.00,0.00,8190.05,3808373.25,3938065.50,129692.25,651456),('1','187','227619','418',465.00,510.00,0.00,4486.13,2086050.45,2160825.30,74774.85,652065),('1','187','227859','418',465.00,510.00,0.00,6022.57,2800495.05,2897840.70,97345.65,652691),('1','187','228116','418',465.00,510.00,0.00,4685.92,2178952.80,2257939.20,78986.40,653378),('1','187','228403','418',465.00,510.00,0.00,1062.17,493909.05,510746.70,16837.65,654114),('1','187','228420','418',465.00,510.00,0.00,0.00,0.00,0.00,0.00,654154),('1','187','228545','418',484.00,540.00,0.00,4143.82,2005608.88,2080062.80,74453.92,654466),('1','187','228781','418',484.00,540.00,0.00,5861.33,2836883.72,2930892.20,94008.48,655073),('1','187','228954','418',484.00,540.00,0.00,5519.18,2671283.12,2764523.20,93240.08,655512),('1','187','229172','418',484.00,540.00,0.00,7061.01,3417528.84,3532093.40,114564.56,656099),('1','187','229450','418',484.00,540.00,0.00,1981.85,959215.40,992879.00,33663.60,656804),('1','187','229632','418',484.00,540.00,0.00,0.00,0.00,0.00,0.00,657296),('1','187','229678','418',502.00,540.00,0.00,2500.00,1255000.00,1317211.00,62211.00,657391),('1','187','229897','418',502.00,568.00,0.00,4363.56,2190507.12,2287766.21,97259.09,657951),('1','187','230096','418',502.00,568.00,0.00,4342.30,2179834.60,2272480.90,92646.30,658464),('1','187','230320','418',502.00,568.00,0.00,3435.63,1724686.26,1805831.84,81145.58,659045),('1','187','230534','418',502.00,568.00,0.00,3935.36,1975550.72,2061243.48,85692.76,659597),('1','187','230793','418',502.00,568.00,0.00,2192.98,1100875.96,1155231.64,54355.68,660266),('1','187','231073','418',502.00,568.00,0.00,1969.76,988819.52,1037090.68,48271.16,661017),('1','187','231396','418',502.00,568.00,0.00,1878.65,943082.30,984259.20,41176.90,661875),('1','187','231548','418',502.00,568.00,0.00,0.00,0.00,0.00,0.00,662291),('1','187','232181','418',528.00,568.00,0.00,1748.90,923419.20,957253.20,33834.00,663966),('1','187','232353','418',528.00,588.00,0.00,5201.56,2746423.68,2835677.28,89253.60,664403),('1','187','232590','418',528.00,588.00,0.00,2541.97,1342160.16,1393293.36,51133.20,665037),('1','187','232854','418',528.00,588.00,0.00,2576.01,1360133.28,1407953.88,47820.60,665736),('1','187','233129','418',528.00,588.00,0.00,4537.76,2395937.28,2475591.18,79653.90,666441),('1','187','233403','418',528.00,588.00,0.00,1384.46,730994.88,787933.84,56938.96,667171),('1','187','233620','418',528.00,604.00,0.00,1689.60,892108.80,960958.40,68849.60,667739),('1','187','233891','418',528.00,604.00,0.00,3317.90,1751851.20,1881451.60,129600.40,668445),('1','187','234046','418',528.00,604.00,0.00,1606.20,848073.60,908104.80,60031.20,668864),('1','187','234239','418',528.00,604.00,0.00,0.00,0.00,0.00,0.00,669383),('1','187','234588','418',543.00,604.00,0.00,2249.90,1221695.70,1278719.60,57023.90,670294),('1','187','234837','418',543.00,604.00,0.00,3246.50,1762849.50,1837606.00,74756.50,670953),('1','187','235102','418',543.00,604.00,0.00,1835.66,996763.38,1042698.64,45935.26,671669),('1','187','235316','418',543.00,604.00,0.00,3502.30,1901748.90,1982589.20,80840.30,672225),('1','187','235583','418',543.00,604.00,0.00,3633.92,1973218.56,2060442.88,87224.32,672906),('1','187','235765','418',543.00,604.00,0.00,8336.40,4526665.20,4709345.60,182680.40,673381),('1','187','236085','418',543.00,604.00,0.00,1805.50,980386.50,1020442.00,40055.50,674221),('1','187','236167','418',543.00,604.00,0.00,0.00,0.00,0.00,0.00,674456),('1','187','236255','418',550.00,604.00,0.00,2550.33,1402681.50,1472779.32,70097.82,674670),('1','187','236535','418',550.00,604.00,0.00,3390.88,1864984.00,1954884.52,89900.52,675410),('1','187','236753','418',550.00,604.00,0.00,9328.80,5130840.00,5363530.20,232690.20,675968),('1','187','236984','418',550.00,604.00,0.00,5691.50,3130325.00,3273656.00,143331.00,676569),('1','187','237172','418',550.00,604.00,0.00,2302.20,1266210.00,1330537.80,64327.80,677055),('1','187','237409','418',550.00,604.00,0.00,1364.60,750530.00,783898.40,33368.40,677661),('1','187','237521','418',550.00,604.00,0.00,0.00,0.00,0.00,0.00,677964),('1','187','237539','418',578.00,604.00,0.00,4628.20,2675099.60,2745814.40,70714.80,678016),('1','187','237643','418',578.00,640.00,0.00,3562.06,2058870.68,2127865.90,68995.22,678271),('1','187','237886','418',578.00,634.00,0.00,4133.05,2388902.90,2475819.70,86916.80,678909),('1','187','238144','418',578.00,634.00,0.00,3055.40,1766021.20,1826929.10,60907.90,679572),('1','187','238391','418',578.00,634.00,0.00,2966.99,1714920.22,1774933.16,60012.94,680200),('1','187','238640','418',578.00,634.00,0.00,5881.00,3399218.00,3507911.50,108693.50,680864),('1','187','238889','418',578.00,634.00,0.00,0.00,0.00,0.00,0.00,681505),('1','187','239166','418',578.00,634.00,0.00,400.00,231200.00,158800.00,-72400.00,682230),('1','187','239642','418',578.00,634.00,0.00,200.00,115600.00,79400.00,-36200.00,683468),('1','187','239643','418',502.00,560.00,0.00,1787.30,897224.60,932088.00,34863.40,683469),('1','187','239644','418',502.00,560.00,0.00,2140.84,1074701.68,1119980.80,45279.12,683470),('1','187','239645','418',502.00,560.00,0.00,643.00,322786.00,339720.00,16934.00,683471),('1','187','239646','418',502.00,560.00,0.00,2341.21,1175287.42,1226425.60,51138.18,683472),('1','187','239647','418',502.00,560.00,0.00,1829.78,918549.56,957276.80,38727.24,683473),('1','187','239648','418',502.00,560.00,0.00,1911.80,959723.60,999224.40,39500.80,683474),('1','187','239649','418',502.00,560.00,0.00,2365.31,1187385.62,1233103.20,45717.58,683475),('1','187','239650','418',502.00,560.00,0.00,2477.04,1243474.08,1292081.60,48607.52,683476),('1','187','239651','418',502.00,560.00,0.00,3179.50,1596109.00,1659711.20,63602.20,683477),('1','187','239652','418',502.00,560.00,0.00,895.97,449776.94,470847.60,21070.66,683478),('1','187','239653','418',502.00,560.00,0.00,3415.26,1714460.52,1779683.60,65223.08,683479),('1','187','239654','418',502.00,560.00,0.00,591.12,296742.24,307924.40,11182.16,683480),('1','187','239655','418',502.00,502.00,0.00,0.00,0.00,0.00,0.00,683481),('1','187','239656','418',508.00,560.00,0.00,4571.95,2322550.60,2407207.12,84656.52,683482),('1','187','239657','418',508.00,560.00,0.00,3188.52,1619768.16,1682608.66,62840.50,683483),('1','187','239658','418',508.00,560.00,0.00,1345.42,683473.36,712380.20,28906.84,683484),('1','187','239659','418',508.00,560.00,0.00,1889.94,960089.52,1001430.68,41341.16,683485),('1','187','239660','418',508.00,560.00,0.00,2541.45,1291056.60,1343055.98,51999.38,683486),('1','187','239661','418',508.00,560.00,0.00,2977.45,1512544.60,1573838.00,61293.40,683487),('1','187','239662','418',508.00,560.00,0.00,3009.26,1528704.08,1587061.60,58357.52,683488),('1','187','239663','418',508.00,560.00,0.00,1866.98,948425.84,988080.08,39654.24,683489),('1','187','239664','418',508.00,560.00,0.00,3094.33,1571919.64,1630875.80,58956.16,683490),('1','187','239665','418',508.00,560.00,0.00,0.00,0.00,0.00,0.00,683491),('1','187','239666','418',508.00,560.00,0.00,3620.83,1839381.64,1916243.40,76861.76,683492),('1','187','239667','418',508.00,560.00,0.00,2824.03,1434607.24,1490189.24,55582.00,683493),('1','187','239668','418',508.00,560.00,0.00,1591.48,808471.84,840986.66,32514.82,683494),('1','187','239669','418',508.00,560.00,0.00,4832.72,2455021.76,2548672.00,93650.24,683495),('1','187','239670','418',508.00,560.00,0.00,5053.72,2567289.76,2663255.74,95965.98,683496),('1','187','239671','418',508.00,630.00,0.00,1619.57,822741.56,974611.00,151869.44,683497),('1','187','239672','418',508.00,560.00,0.00,1380.21,701146.68,835214.70,134068.02,683498),('1','187','239673','418',508.00,630.00,0.00,1198.74,608959.92,727231.20,118271.28,683499),('1','187','239674','418',508.00,630.00,0.00,1607.96,816843.68,972179.70,155336.02,683500),('1','187','239675','418',508.00,630.00,0.00,722.57,367065.56,435042.30,67976.74,683501),('1','187','239676','418',508.00,630.00,0.00,0.00,0.00,0.00,0.00,683502),('1','187','239677','418',508.00,630.00,0.00,0.00,0.00,0.00,0.00,683503),('1','187','239678','418',574.00,630.00,0.00,2233.58,1282074.92,1346585.40,64510.48,683504),('1','187','239679','418',574.00,630.00,0.00,2744.77,1575497.98,1652765.10,77267.12,683505),('1','187','239680','418',574.00,630.00,0.00,1296.96,744455.04,783538.20,39083.16,683506),('1','187','239681','418',574.00,630.00,0.00,1250.97,718056.78,755501.10,37444.32,683507),('1','187','239682','418',574.00,630.00,0.00,2439.58,1400318.92,1418456.96,18138.04,683508),('1','187','239683','418',574.00,608.00,0.00,2747.57,1577105.18,1598982.56,21877.38,683509),('1','187','239684','418',574.00,608.00,0.00,1415.62,812565.88,825558.08,12992.20,683510),('1','187','239685','418',574.00,608.00,0.00,2940.91,1688082.34,1714214.04,26131.70,683511),('1','187','239686','418',574.00,608.00,0.00,4941.15,2836220.10,2870491.20,34271.10,683512),('1','187','239687','418',574.00,608.00,0.00,2748.69,1577748.06,1583245.44,5497.38,683513),('1','187','239688','418',574.00,608.00,0.00,0.00,0.00,0.00,0.00,683514),('1','187','239689','418',572.00,608.00,0.00,4445.25,2542683.00,2611235.46,68552.46,683515),('1','187','239690','418',572.00,608.00,0.00,2396.33,1370700.76,1422754.60,52053.84,683516),('1','187','239691','418',572.00,620.00,0.00,1311.58,750223.76,805162.10,54938.34,683517),('1','187','239692','418',572.00,620.00,0.00,3233.21,1849396.12,1975474.40,126078.28,683518),('1','187','239693','418',572.00,640.00,0.00,3934.91,2250768.52,2412476.60,161708.08,683519),('1','187','239694','418',572.00,640.00,0.00,2768.64,1583662.08,1696203.00,112540.92,683520),('1','187','239695','418',572.00,640.00,0.00,2907.85,1663290.20,1784901.40,121611.20,683521),('1','187','239696','418',572.00,640.00,0.00,3357.02,1920215.44,2057117.60,136902.16,683522),('1','187','239697','418',572.00,640.00,0.00,0.00,0.00,0.00,0.00,683523),('1','187','239698','418',572.00,640.00,0.00,8125.03,4647517.16,4816976.70,169459.54,683524),('1','187','239699','418',572.00,640.00,0.00,8063.38,4612253.36,4772932.20,160678.84,683525),('1','187','239700','418',572.00,640.00,0.00,5346.91,3058432.52,3167219.90,108787.38,683526),('1','187','239701','418',572.00,640.00,0.00,2976.30,1702443.60,1762195.50,59751.90,683527),('1','187','239702','418',572.00,640.00,0.00,0.00,0.00,0.00,0.00,683528),('1','187','239703','418',572.00,640.00,0.00,2301.76,1316606.72,1369408.90,52802.18,683529),('1','187','239704','418',572.00,640.00,0.00,2466.79,1411003.88,1467033.60,56029.72,683530),('1','187','239705','418',572.00,640.00,0.00,3199.61,1830176.92,1896622.40,66445.48,683531),('1','187','239706','418',572.00,640.00,0.00,1983.99,1134842.28,1177501.10,42658.82,683532),('1','187','239707','418',572.00,640.00,0.00,2899.63,1658588.36,1720393.70,61805.34,683533),('1','187','239708','418',572.00,640.00,0.00,2400.38,1373017.36,1421301.70,48284.34,683534),('1','187','239709','418',572.00,640.00,0.00,1264.68,723396.96,753744.70,30347.74,683535),('1','187','239710','418',572.00,640.00,0.00,2516.41,1439386.52,1492840.40,53453.88,683536),('1','187','239711','418',572.00,640.00,0.00,1962.07,1122304.04,1167331.30,45027.26,683537),('1','187','239712','418',572.00,640.00,0.00,2706.55,1548146.60,1610437.50,62290.90,683538),('1','187','239713','418',572.00,640.00,0.00,701.81,401435.32,418442.90,17007.58,683539),('1','187','239714','418',572.00,640.00,0.00,0.00,0.00,0.00,0.00,683540),('1','187','239715','418',572.00,640.00,0.00,0.00,0.00,0.00,0.00,683541),('1','187','239716','418',562.00,640.00,0.00,4941.55,2777151.10,2896695.40,119544.30,683542),('1','187','239717','418',562.00,640.00,0.00,1989.94,1118346.28,1167577.60,49231.32,683543),('1','187','239718','418',562.00,640.00,0.00,2996.12,1683819.44,1758582.80,74763.36,683544),('1','187','239719','418',562.00,640.00,0.00,3563.76,2002833.12,2080353.60,77520.48,683545),('1','187','239720','418',562.00,640.00,0.00,1628.42,915172.04,953064.20,37892.16,683546),('1','187','239721','418',562.00,640.00,0.00,4108.49,2308971.38,2400654.80,91683.42,683547),('1','187','239722','418',562.00,640.00,0.00,2191.16,1231431.92,1279808.00,48376.08,683548),('1','187','239723','418',562.00,640.00,0.00,3128.72,1758340.64,1830815.60,72474.96,683549),('1','187','239724','418',562.00,640.00,0.00,0.00,0.00,0.00,0.00,683550),('1','187','239725','418',562.00,640.00,0.00,2871.01,1613507.62,1683037.60,69529.98,683551),('1','187','239726','418',562.00,640.00,0.00,2525.92,1419567.04,1483885.00,64317.96,683552),('1','187','239727','418',562.00,640.00,0.00,5230.92,2939777.04,3053371.80,113594.76,683553),('1','187','239728','418',562.00,640.00,0.00,5404.81,3037503.22,3157868.20,120364.98,683554),('1','187','239729','418',562.00,640.00,0.00,4937.17,2774689.54,2889687.40,114997.86,683555),('1','187','239730','418',562.00,640.00,0.00,3243.59,1822897.58,1904462.60,81565.02,683556),('1','187','239731','418',562.00,640.00,0.00,181.84,102194.08,105467.20,3273.12,683557),('1','187','239732','418',562.00,640.00,0.00,0.00,0.00,0.00,0.00,683558),('1','187','239733','418',562.00,640.00,0.00,4176.72,2347316.64,2434422.60,87105.96,683559),('1','187','239734','418',562.00,640.00,0.00,4207.03,2364350.86,2461349.80,96998.94,683560),('1','187','239735','418',562.00,640.00,0.00,4688.18,2634757.16,2739155.60,104398.44,683561),('1','187','239736','418',562.00,640.00,0.00,4290.20,2411092.40,2513588.00,102495.60,683562),('1','187','239737','418',562.00,640.00,0.00,4392.18,2468405.16,2570215.20,101810.04,683563),('1','187','239738','418',562.00,640.00,0.00,1951.04,1096484.48,1148067.20,51582.72,683564),('1','187','239739','418',562.00,640.00,0.00,826.94,464740.28,479625.20,14884.92,683565),('1','187','239740','418',562.00,640.00,0.00,0.00,0.00,0.00,0.00,683566),('1','187','239741','418',562.00,640.00,0.00,1849.19,1039244.78,1084241.60,44996.82,683567),('1','187','239742','418',562.00,640.00,0.00,5872.58,3300389.96,3422907.80,122517.84,683568),('1','187','239743','418',562.00,640.00,0.00,6308.05,3545124.10,3679176.40,134052.30,683569),('1','187','239744','418',562.00,640.00,0.00,3418.51,1921202.62,2003706.40,82503.78,683570),('1','187','239745','418',562.00,640.00,0.00,5576.80,3134161.60,3245744.20,111582.60,683571),('1','187','239746','418',562.00,640.00,0.00,1179.30,662766.60,731803.64,69037.04,683572),('1','187','239747','418',562.00,656.00,0.00,464.71,261167.02,287576.24,26409.22,683573),('1','187','239748','418',597.00,660.00,0.00,2791.69,1666638.93,1718642.76,52003.83,683574),('1','187','239749','418',597.00,660.00,0.00,3063.35,1828819.95,1886952.60,58132.65,683575),('1','187','239750','418',597.00,660.00,0.00,6349.22,3790484.34,3901952.88,111468.54,683576),('1','187','239751','418',597.00,660.00,0.00,5886.52,3514252.44,3607186.10,92933.66,683577),('1','187','239752','418',597.00,660.00,0.00,6617.17,3950450.49,4055330.68,104880.19,683578),('1','187','239753','418',597.00,660.00,0.00,0.00,0.00,0.00,0.00,683579),('1','187','239754','418',612.00,660.00,0.00,5713.31,3496545.72,3601155.72,104610.00,683580),('1','187','239755','418',612.00,660.00,0.00,5903.96,3613223.52,3727702.80,114479.28,683581),('1','187','239756','418',612.00,660.00,0.00,6437.98,3940043.76,4060156.80,120113.04,683582),('1','187','239757','418',612.00,660.00,0.00,5527.28,3382695.36,3479959.44,97264.08,683583),('1','187','239758','418',612.00,660.00,0.00,0.00,0.00,0.00,0.00,683584),('1','187','239759','418',622.00,680.00,0.00,8385.41,5215725.02,5379280.80,163555.78,683585),('1','187','239760','418',622.00,680.00,0.00,13401.41,8335677.02,8584397.20,248720.18,683586),('1','187','239761','418',622.00,680.00,0.00,2550.81,1586603.82,1639860.50,53256.68,683587),('1','187','239762','418',622.00,680.00,0.00,0.00,0.00,0.00,0.00,683588),('1','187','239763','418',642.00,680.00,0.00,10743.71,6897461.82,7165974.96,268513.14,683589),('1','187','239764','418',642.00,700.00,0.00,13778.08,8845527.36,9188793.86,343266.50,683590),('1','187','239765','418',642.00,700.00,0.00,0.00,0.00,0.00,0.00,683591),('1','187','239766','418',652.00,730.00,0.00,11464.83,7475069.16,7767171.90,292102.74,683592),('1','187','239767','418',652.00,730.00,0.00,8204.84,5349555.68,5557902.02,208346.34,683593),('1','187','239768','418',652.00,730.00,0.00,0.00,0.00,0.00,0.00,683594),('1','187','239769','418',652.00,730.00,0.00,14632.16,9540168.32,10239442.10,699273.78,683595),('1','187','239770','418',652.00,770.00,0.00,3872.91,2525137.32,2719419.18,194281.86,683596),('1','187','239771','418',652.00,770.00,0.00,6165.19,4019703.88,4319807.62,300103.74,683597),('1','187','239772','418',652.00,770.00,0.00,0.00,0.00,0.00,0.00,683598),('1','187','239773','418',652.00,770.00,0.00,5364.98,3497966.96,3744549.78,246582.82,683599),('1','187','239774','418',652.00,770.00,0.00,3079.80,2008029.60,2154300.00,146270.40,683600),('1','187','239775','418',652.00,770.00,0.00,2790.77,1819582.04,1952468.65,132886.61,683601),('1','187','239776','418',652.00,770.00,0.00,3238.85,2111730.20,2262763.70,151033.50,683602),('1','187','239777','418',652.00,770.00,0.00,3945.79,2572655.08,2749170.30,176515.22,683603),('1','187','239778','418',652.00,770.00,0.00,1230.12,802038.24,861605.20,59566.96,683604),('1','187','239779','418',652.00,770.00,0.00,4286.51,2794804.52,2972950.74,178146.22,683605),('1','187','239780','418',652.00,770.00,0.00,657.10,428429.20,456846.20,28417.00,683606),('1','187','239781','418',652.00,770.00,0.00,0.00,0.00,0.00,0.00,683607),('1','187','239782','418',652.00,770.00,0.00,993.65,647859.80,688212.90,40353.10,683608),('1','187','239783','418',652.00,770.00,0.00,4498.97,2933328.44,3134194.90,200866.46,683609),('1','187','239784','418',652.00,770.00,0.00,4697.98,3063082.96,3275477.40,212394.44,683610),('1','187','239785','418',652.00,770.00,0.00,1952.74,1273186.48,1376009.80,102823.32,683611),('1','187','239786','418',652.00,770.00,0.00,1564.28,1019910.56,1099569.20,79658.64,683612),('1','187','239787','418',652.00,770.00,0.00,3116.01,2031638.52,2167047.70,135409.18,683613),('1','187','239788','418',652.00,770.00,0.00,4266.06,2781471.12,2954983.20,173512.08,683614),('1','187','239789','418',652.00,770.00,0.00,3684.61,2402365.72,2561094.50,158728.78,683615),('1','187','239790','418',652.00,770.00,0.00,0.00,0.00,0.00,0.00,683616),('1','187','239791','418',652.00,770.00,0.00,9846.59,6419976.68,6825604.70,405628.02,683617),('1','187','239792','418',652.00,770.00,0.00,6775.22,4417443.44,4732042.60,314599.16,683618),('1','187','239793','418',652.00,770.00,0.00,2469.36,1610022.72,1722297.60,112274.88,683619),('1','187','239794','418',652.00,770.00,0.00,1843.91,1202229.32,1281204.30,78974.98,683620),('1','187','239795','418',652.00,770.00,0.00,2432.28,1585846.56,1698937.20,113090.64,683621),('1','187','239796','418',652.00,770.00,0.00,1562.80,1018945.60,1086252.00,67306.40,683622),('1','187','239797','418',652.00,770.00,0.00,0.00,0.00,0.00,0.00,683623),('1','187','239798','418',652.00,770.00,0.00,1550.35,1010828.20,1096889.50,86061.30,683624),('1','187','239799','418',652.00,770.00,0.00,3324.66,2167678.32,2323561.00,155882.68,683625),('1','187','239800','418',652.00,770.00,0.00,4470.34,2914661.68,3069393.70,154732.02,683626),('1','187','239801','418',652.00,770.00,0.00,2078.01,1354862.52,1435106.70,80244.18,683627),('1','187','239802','418',652.00,770.00,0.00,819.45,534281.40,574433.10,40151.70,683628),('1','187','239803','418',652.00,770.00,0.00,2190.61,1428277.72,1508575.10,80297.38,683629),('1','187','239804','418',652.00,770.00,0.00,2198.67,1433532.84,1511823.90,78291.06,683630),('1','187','239805','418',652.00,770.00,0.00,2071.54,1350644.08,1430074.40,79430.32,683631),('1','187','239806','418',652.00,770.00,0.00,3219.53,2099133.56,2208861.70,109728.14,683632),('1','187','239807','418',652.00,770.00,0.00,1270.51,828372.52,882965.60,54593.08,683633),('1','187','239808','418',652.00,770.00,0.00,1371.62,894296.24,951947.20,57650.96,683634),('1','187','239809','418',652.00,770.00,0.00,0.00,0.00,0.00,0.00,683635),('1','187','239810','418',645.00,770.00,0.00,1073.65,692504.25,739688.60,47184.35,683636),('1','187','239811','418',645.00,770.00,0.00,2673.37,1724323.65,1839189.20,114865.55,683637),('1','187','239812','418',645.00,770.00,0.00,1648.57,1063327.65,1152893.90,89566.25,683638),('1','187','239813','418',645.00,770.00,0.00,2289.38,1476650.10,1564194.84,87544.74,683639),('1','187','239814','418',645.00,770.00,0.00,1705.31,1099924.95,1154530.42,54605.47,683640),('1','187','239815','418',645.00,720.00,0.00,1201.62,775044.90,813083.94,38039.04,683641),('1','187','239816','418',645.00,720.00,0.00,3040.41,1961064.45,2047682.16,86617.71,683642),('1','187','239817','418',645.00,720.00,0.00,2219.19,1431377.55,1491490.80,60113.25,683643),('1','187','239818','418',645.00,720.00,0.00,3910.15,2522046.75,2624054.04,102007.29,683644),('1','187','239819','418',645.00,720.00,0.00,4752.70,3065491.50,3184563.78,119072.28,683645),('1','187','239820','418',645.00,720.00,0.00,0.00,0.00,0.00,0.00,683646),('1','187','239821','418',645.00,720.00,0.00,3918.62,2527509.90,2629163.70,101653.80,683647),('1','187','239822','418',645.00,720.00,0.00,4867.44,3139498.80,3267928.80,128430.00,683648),('1','187','239823','418',645.00,720.00,0.00,4999.58,3224729.10,3353997.60,129268.50,683649),('1','187','239824','418',645.00,720.00,0.00,6015.48,3879984.60,4024411.02,144426.42,683650),('1','187','239825','418',645.00,720.00,0.00,3280.56,2115961.20,2204638.02,88676.82,683651),('1','187','239826','418',645.00,720.00,0.00,1353.72,873149.40,905041.08,31891.68,683652),('1','187','239827','418',645.00,720.00,0.00,150.00,96750.00,99900.00,3150.00,683653),('1','187','239828','418',645.00,720.00,0.00,0.00,0.00,0.00,0.00,683654),('1','187','239829','418',652.00,720.00,0.00,5744.02,3745101.04,3866599.90,121498.86,683655),('1','187','239830','418',652.00,720.00,0.00,4470.27,2914616.04,3013138.90,98522.86,683656),('1','187','239831','418',652.00,720.00,0.00,3551.47,2315558.44,2401223.40,85664.96,683657),('1','187','239832','418',652.00,720.00,0.00,3258.73,2124691.96,2202560.60,77868.64,683658),('1','187','239833','418',652.00,720.00,0.00,2042.52,1331723.04,1378814.40,47091.36,683659),('1','187','239834','418',652.00,720.00,0.00,3405.89,2220640.28,2304063.30,83423.02,683660),('1','187','239835','418',652.00,720.00,0.00,741.30,483327.60,518286.00,34958.40,683661),('1','187','239836','418',652.00,720.00,0.00,1144.65,746311.80,772848.00,26536.20,683662),('1','187','239837','418',652.00,720.00,0.00,0.00,0.00,0.00,0.00,683663),('1','187','239838','418',652.00,720.00,0.00,677.19,441527.88,468176.80,26648.92,683664),('1','187','239839','418',652.00,720.00,0.00,2469.54,1610140.08,1674408.80,64268.72,683665),('1','187','239840','418',652.00,720.00,0.00,3427.47,2234710.44,2315753.40,81042.96,683666),('1','187','239841','418',652.00,720.00,0.00,3993.79,2603951.08,2690774.80,86823.72,683667),('1','187','239842','418',652.00,720.00,0.00,1360.28,886902.56,923480.10,36577.54,683668),('1','187','239843','418',652.00,720.00,0.00,4685.29,3054809.08,3154572.80,99763.72,683669),('1','187','239844','418',652.00,720.00,0.00,2455.80,1601181.60,1663566.00,62384.40,683670),('1','187','239845','418',652.00,720.00,0.00,2016.40,1314692.80,1363675.50,48982.70,683671),('1','187','239846','418',652.00,720.00,0.00,2587.52,1687063.04,1747964.40,60901.36,683672),('1','187','239847','418',652.00,720.00,0.00,930.46,606659.92,632932.70,26272.78,683673),('1','187','239848','418',652.00,720.00,0.00,0.00,0.00,0.00,0.00,683674),('1','187','239849','418',647.00,720.00,0.00,3409.47,2205927.09,2296132.90,90205.81,683675),('1','187','239850','418',647.00,720.00,0.00,3405.76,2203526.72,2294363.70,90836.98,683676),('1','187','239851','418',647.00,720.00,0.00,5629.05,3641995.35,3775928.30,133932.95,683677),('1','187','239852','418',647.00,720.00,0.00,3122.62,2020335.14,2108068.90,87733.76,683678),('1','187','239853','418',647.00,720.00,0.00,2805.82,1815365.54,1902171.90,86806.36,683679),('1','187','239854','418',647.00,720.00,0.00,2550.88,1650419.36,1725136.10,74716.74,683680),('1','187','239855','418',647.00,720.00,0.00,2599.10,1681617.70,1773827.00,92209.30,683681),('1','187','239856','418',647.00,720.00,0.00,886.60,573630.20,597992.50,24362.30,683682),('1','187','239857','418',647.00,720.00,0.00,205.36,132867.92,147859.20,14991.28,683683),('1','187','239858','418',647.00,720.00,0.00,0.00,0.00,0.00,0.00,683684),('1','187','239859','418',642.00,720.00,0.00,4092.81,2627584.02,2763396.20,135812.18,683685),('1','187','239860','418',642.00,720.00,0.00,2915.92,1872020.64,1971631.90,99611.26,683686),('1','187','239861','418',642.00,720.00,0.00,3030.43,1945536.06,2049129.60,103593.54,683687),('1','187','239862','418',642.00,720.00,0.00,3414.93,2192385.06,2303581.60,111196.54,683688),('1','187','239863','418',642.00,720.00,0.00,3642.90,2338741.80,2450688.00,111946.20,683689),('1','187','239864','418',642.00,720.00,0.00,1883.64,1209296.88,1286512.80,77215.92,683690),('1','187','239865','418',642.00,720.00,0.00,2966.03,1904191.26,2007599.10,103407.84,683691),('1','187','239866','418',642.00,720.00,0.00,1711.86,1099014.12,1157814.70,58800.58,683692),('1','187','239867','418',642.00,720.00,0.00,969.62,622496.04,651864.40,29368.36,683693),('1','187','239868','418',642.00,720.00,0.00,0.00,0.00,0.00,0.00,683694),('1','187','239869','418',640.00,720.00,0.00,2300.39,1472249.60,1535205.60,62956.00,683695),('1','187','239870','418',640.00,720.00,0.00,1234.13,789843.20,833847.60,44004.40,683696),('1','187','239871','418',640.00,720.00,0.00,2569.66,1644582.40,1720099.20,75516.80,683697),('1','187','239872','418',640.00,720.00,0.00,1322.66,846502.40,893633.40,47131.00,683698),('1','187','239873','418',640.00,720.00,0.00,2465.84,1578137.60,1660114.20,81976.60,683699),('1','187','239874','418',640.00,720.00,0.00,3160.24,2022553.60,2109666.60,87113.00,683700),('1','187','239875','418',640.00,720.00,0.00,4937.41,3159942.40,3285886.80,125944.40,683701),('1','187','239876','418',640.00,720.00,0.00,2943.48,1883827.20,1961385.60,77558.40,683702),('1','187','239877','418',640.00,720.00,0.00,1646.61,1053830.40,1098312.60,44482.20,683703),('1','187','239878','418',640.00,720.00,0.00,2007.31,1284678.40,1336912.80,52234.40,683704),('1','187','239879','418',640.00,720.00,0.00,0.00,0.00,0.00,0.00,683705),('1','187','239880','418',640.00,720.00,0.00,2930.00,1875200.00,1964640.00,89440.00,683706),('1','187','239881','418',640.00,720.00,0.00,1552.44,993561.60,1048153.20,54591.60,683707),('1','187','239882','418',640.00,720.00,0.00,2929.49,1874873.60,1959706.80,84833.20,683708),('1','187','239883','418',640.00,720.00,0.00,4157.67,2660908.80,2765890.20,104981.40,683709),('1','187','239884','418',640.00,720.00,0.00,2719.56,1740518.40,1824283.20,83764.80,683710),('1','187','239885','418',640.00,720.00,0.00,4412.06,2823718.40,2950123.20,126404.80,683711),('1','187','239886','418',640.00,720.00,0.00,1592.30,1019072.00,1075296.00,56224.00,683712),('1','187','239887','418',640.00,720.00,0.00,3398.87,2175276.80,2272226.40,96949.60,683713),('1','187','239888','418',640.00,720.00,0.00,71.43,45715.20,47364.60,1649.40,683714),('1','187','239889','418',640.00,720.00,0.00,0.00,0.00,0.00,0.00,683715),('1','187','239890','418',627.00,720.00,0.00,705.50,442348.50,475980.00,33631.50,683716),('1','187','239891','418',627.00,720.00,0.00,4178.06,2619643.62,2772623.05,152979.43,683717),('1','187','239892','418',627.00,720.00,0.00,4311.38,2703235.26,2849327.95,146092.69,683718),('1','187','239893','418',627.00,720.00,0.00,4411.54,2766035.58,2905949.75,139914.17,683719),('1','187','239894','418',627.00,720.00,0.00,3860.56,2420571.12,2561931.20,141360.08,683720),('1','187','239895','418',627.00,720.00,0.00,1649.52,1034249.04,1101478.05,67229.01,683721),('1','187','239896','418',627.00,720.00,0.00,3360.64,2107121.28,2222706.25,115584.97,683722),('1','187','239897','418',627.00,720.00,0.00,1840.98,1154294.46,1211896.65,57602.19,683723),('1','187','239898','418',627.00,720.00,0.00,24.46,15336.42,16156.50,820.08,683724),('1','187','239899','418',627.00,720.00,0.00,0.00,0.00,0.00,0.00,683725),('1','187','239900','418',627.00,720.00,0.00,3384.52,2122094.04,2241594.40,119500.36,683726),('1','187','239901','418',627.00,720.00,0.00,5039.78,3159942.06,3320541.60,160599.54,683727),('1','187','239902','418',627.00,720.00,0.00,3906.49,2449369.23,2578159.95,128790.72,683728),('1','187','239903','418',627.00,720.00,0.00,2415.71,1514650.17,1596462.65,81812.48,683729),('1','187','239904','418',627.00,720.00,0.00,3411.48,2138997.96,2256961.95,117963.99,683730),('1','187','239905','418',627.00,720.00,0.00,6607.62,4142977.74,4343910.25,200932.51,683731),('1','187','239906','418',627.00,720.00,0.00,0.00,0.00,0.00,0.00,683732),('1','187','239907','418',627.00,720.00,0.00,5960.86,3737459.22,3983106.40,245647.18,683733),('1','187','239908','418',627.00,720.00,0.00,4117.58,2581722.66,2755077.35,173354.69,683734),('1','187','239909','418',627.00,720.00,0.00,3819.52,2394839.04,2560826.90,165987.86,683735),('1','187','239910','418',627.00,720.00,0.00,2388.98,1497890.46,1607425.60,109535.14,683736),('1','187','239911','418',627.00,720.00,0.00,3559.86,2232032.22,2374138.45,142106.23,683737),('1','187','239912','418',627.00,720.00,0.00,4699.85,2946805.95,3131049.30,184243.35,683738),('1','187','239913','418',627.00,720.00,0.00,0.00,0.00,0.00,0.00,683739),('1','187','239914','418',627.00,720.00,0.00,5990.67,3756150.09,4025527.90,269377.81,683740),('1','187','239915','418',627.00,720.00,0.00,4248.24,2663646.48,2857519.30,193872.82,683741),('1','187','239916','418',627.00,720.00,0.00,3564.84,2235154.68,2402696.30,167541.62,683742),('1','187','239917','418',627.00,720.00,0.00,4512.02,2829036.54,3039029.40,209992.86,683743),('1','187','239918','418',627.00,720.00,0.00,2756.32,1728212.64,1859722.20,131509.56,683744),('1','187','239919','418',627.00,720.00,0.00,3448.88,2162447.76,2320813.60,158365.84,683745),('1','187','239920','418',627.00,720.00,0.00,0.00,0.00,0.00,0.00,683746),('1','187','239921','418',640.00,720.00,0.00,6165.29,3945785.60,4198242.30,252456.70,683747),('1','187','239922','418',640.00,750.00,0.00,7580.47,4851500.80,5136735.00,285234.20,683748),('1','187','239923','418',640.00,750.00,0.00,2256.23,1443987.20,1554291.75,110304.55,683749),('1','187','239924','418',640.00,750.00,0.00,5744.75,3676640.00,3907901.25,231261.25,683750),('1','187','239925','418',640.00,750.00,0.00,2796.56,1789798.40,1894510.50,104712.10,683751),('1','187','239926','418',640.00,750.00,0.00,0.00,0.00,0.00,0.00,683752),('1','187','239927','418',657.00,750.00,0.00,3485.42,2289920.94,2375077.50,85156.56,683753),('1','187','239928','418',657.00,750.00,0.00,4739.73,3114002.61,3211011.25,97008.64,683754),('1','187','239929','418',657.00,750.00,0.00,4252.37,2793807.09,2884344.00,90536.91,683755),('1','187','239930','418',657.00,750.00,0.00,3409.27,2239890.39,2328413.25,88522.86,683756),('1','187','239931','418',657.00,750.00,0.00,4985.42,3275420.94,3381044.65,105623.71,683757),('1','187','239932','418',657.00,750.00,0.00,3874.45,2545513.65,2624737.50,79223.85,683758),('1','187','239933','418',657.00,750.00,0.00,0.00,0.00,0.00,0.00,683759),('1','187','239934','418',657.00,750.00,0.00,9841.04,6465563.28,6667692.75,202129.47,683760),('1','187','239935','418',657.00,750.00,0.00,3495.30,2296412.10,2381287.50,84875.40,683761),('1','187','239936','418',657.00,750.00,0.00,2572.56,1690171.92,1759207.50,69035.58,683762),('1','187','239937','418',657.00,750.00,0.00,3969.95,2608257.15,2699832.00,91574.85,683763),('1','187','239938','418',657.00,750.00,0.00,3447.77,2265184.89,2344927.50,79742.61,683764),('1','187','239939','418',657.00,750.00,0.00,1380.20,906791.40,931940.00,25148.60,683765),('1','187','239940','418',657.00,750.00,0.00,0.00,0.00,0.00,0.00,683766),('1','187','239941','418',657.00,750.00,0.00,7990.45,5249725.65,5406821.40,157095.75,683767),('1','187','239942','418',657.00,750.00,0.00,2089.30,1372670.10,1417371.00,44700.90,683768),('1','187','239943','418',657.00,750.00,0.00,3690.82,2424868.74,2505575.25,80706.51,683769),('1','187','239944','418',657.00,750.00,0.00,2281.79,1499136.03,1548817.50,49681.47,683770),('1','187','239945','418',657.00,750.00,0.00,5435.58,3571176.06,3692310.00,121133.94,683771),('1','187','239946','418',657.00,750.00,0.00,3224.65,2118595.05,2179827.50,61232.45,683772),('1','187','239947','418',657.00,750.00,0.00,0.00,0.00,0.00,0.00,683773),('1','187','239948','418',640.00,750.00,0.00,5643.64,3611929.60,3823185.90,211256.30,683774),('1','187','239949','418',640.00,750.00,0.00,5424.39,3471609.60,3695154.75,223545.15,683775),('1','187','239950','418',640.00,750.00,0.00,4145.06,2652838.40,2824784.25,171945.85,683776),('1','187','239951','418',640.00,750.00,0.00,4586.71,2935494.40,3118582.50,183088.10,683777),('1','187','239952','418',640.00,750.00,0.00,4752.66,3041702.40,3212620.00,170917.60,683778),('1','187','239953','418',640.00,750.00,0.00,0.00,0.00,0.00,0.00,683779),('1','187','239954','418',640.00,750.00,0.00,3191.72,2042700.80,2167065.00,124364.20,683780),('1','187','239955','418',640.00,750.00,0.00,7378.73,4722387.20,5008222.50,285835.30,683781),('1','187','239956','418',640.00,750.00,0.00,6899.46,4415654.40,4675990.00,260335.60,683782),('1','187','239957','418',640.00,750.00,0.00,4129.58,2642931.20,2810010.00,167078.80,683783),('1','187','239958','418',640.00,750.00,0.00,3259.06,2085798.40,2203460.00,117661.60,683784),('1','187','239959','418',640.00,750.00,0.00,0.00,0.00,0.00,0.00,683785),('1','187','239960','418',632.00,750.00,0.00,7383.38,4666296.16,5002560.80,336264.64,683786),('1','187','239961','418',632.00,750.00,0.00,3602.22,2276603.04,2460465.00,183861.96,683787),('1','187','239962','418',632.00,750.00,0.00,3643.00,2302376.00,2468244.45,165868.45,683788),('1','187','239963','418',632.00,750.00,0.00,6338.18,4005729.76,4302085.00,296355.24,683789),('1','187','239964','418',632.00,750.00,0.00,3655.91,2310535.12,2473107.50,162572.38,683790),('1','187','239965','418',632.00,750.00,0.00,0.00,0.00,0.00,0.00,683791),('1','187','239966','418',630.00,750.00,0.00,8193.55,5161936.50,5489084.90,327148.40,683792),('1','187','239967','418',630.00,750.00,0.00,9660.66,6086215.80,6456972.95,370757.15,683793),('1','187','239968','418',630.00,750.00,0.00,4766.98,3003197.40,3201413.50,198216.10,683794),('1','187','239969','418',630.00,750.00,0.00,2220.99,1399223.70,1485799.20,86575.50,683795),('1','187','239970','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683796),('1','187','239971','418',630.00,750.00,0.00,3735.38,2353289.40,2506265.00,152975.60,683797),('1','187','239972','418',630.00,750.00,0.00,1030.01,648906.30,704227.50,55321.20,683798),('1','187','239973','418',630.00,750.00,0.00,8251.76,5198608.80,5556625.60,358016.80,683799),('1','187','239974','418',630.00,750.00,0.00,5957.93,3753495.90,4025145.10,271649.20,683800),('1','187','239975','418',630.00,750.00,0.00,5526.08,3481430.40,3714482.40,233052.00,683801),('1','187','239976','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683802),('1','187','239977','418',630.00,750.00,0.00,13547.25,8534767.50,9081952.03,547184.53,683803),('1','187','239978','418',630.00,750.00,0.00,4619.00,2909970.00,3134802.00,224832.00,683804),('1','187','239979','418',630.00,750.00,0.00,4250.36,2677726.80,2887976.40,210249.60,683805),('1','187','239980','418',630.00,750.00,0.00,2270.66,1430515.80,1532861.40,102345.60,683806),('1','187','239981','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683807),('1','187','239982','418',630.00,750.00,0.00,2532.81,1595670.30,1718668.30,122998.00,683808),('1','187','239983','418',630.00,750.00,0.00,16048.89,10110800.70,10763008.30,652207.60,683809),('1','187','239984','418',630.00,750.00,0.00,2727.57,1718369.10,1856933.50,138564.40,683810),('1','187','239985','418',630.00,750.00,0.00,3389.02,2135082.60,2282910.60,147828.00,683811),('1','187','239986','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683812),('1','187','239987','418',630.00,750.00,0.00,7369.70,4642911.00,4961595.80,318684.80,683813),('1','187','239988','418',630.00,750.00,0.00,3973.77,2503475.10,2696272.30,192797.20,683814),('1','187','239989','418',630.00,750.00,0.00,1903.35,1199110.50,1292890.90,93780.40,683815),('1','187','239990','418',630.00,750.00,0.00,5735.65,3613459.50,3879281.50,265822.00,683816),('1','187','239991','418',630.00,750.00,0.00,4783.34,3013504.20,3239185.80,225681.60,683817),('1','187','239992','418',630.00,750.00,0.00,821.63,517626.90,562382.50,44755.60,683818),('1','187','239993','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683819),('1','187','239994','418',630.00,750.00,0.00,1881.61,1185414.30,1274407.50,88993.20,683820),('1','187','239995','418',630.00,750.00,0.00,5412.46,3409849.80,3630432.45,220582.65,683821),('1','187','239996','418',630.00,750.00,0.00,3466.92,2184159.60,2338662.00,154502.40,683822),('1','187','239997','418',630.00,750.00,0.00,4715.84,2970979.20,3164969.30,193990.10,683823),('1','187','239998','418',630.00,750.00,0.00,2400.40,1512252.00,1615105.40,102853.40,683824),('1','187','239999','418',630.00,750.00,0.00,5834.36,3675646.80,3912412.05,236765.25,683825),('1','187','240000','418',630.00,750.00,0.00,840.16,529300.80,561538.60,32237.80,683826),('1','187','240001','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683827),('1','187','240002','418',630.00,750.00,0.00,2428.57,1529999.10,1629415.90,99416.80,683828),('1','187','240003','418',630.00,750.00,0.00,5271.55,3321076.50,3540827.70,219751.20,683829),('1','187','240004','418',630.00,750.00,0.00,2211.25,1393087.50,1498314.50,105227.00,683830),('1','187','240005','418',630.00,750.00,0.00,3412.76,2150038.80,2299638.30,149599.50,683831),('1','187','240006','418',630.00,750.00,0.00,5055.37,3184883.10,3393270.20,208387.10,683832),('1','187','240007','418',630.00,750.00,0.00,2337.48,1472612.40,1580985.00,108372.60,683833),('1','187','240008','418',630.00,750.00,0.00,3570.00,2249100.00,2403561.15,154461.15,683834),('1','187','240009','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683835),('1','187','240010','418',630.00,750.00,0.00,4844.49,3052028.70,3244013.10,191984.40,683836),('1','187','240011','418',630.00,750.00,0.00,3252.81,2049270.30,2194314.50,145044.20,683837),('1','187','240012','418',630.00,750.00,0.00,2440.89,1537760.70,1646253.20,108492.50,683838),('1','187','240013','418',630.00,750.00,0.00,3861.77,2432915.10,2595852.50,162937.40,683839),('1','187','240014','418',630.00,750.00,0.00,2432.75,1532632.50,1648433.15,115800.65,683840),('1','187','240015','418',630.00,750.00,0.00,878.64,553543.20,612315.00,58771.80,683841),('1','187','240016','418',630.00,750.00,0.00,2919.14,1839058.20,1970093.25,131035.05,683842),('1','187','240017','418',630.00,750.00,0.00,2354.74,1483486.20,1594425.55,110939.35,683843),('1','187','240018','418',630.00,750.00,0.00,1593.71,1004037.30,1072032.50,67995.20,683844),('1','187','240019','418',630.00,750.00,0.00,0.00,0.00,0.00,0.00,683845),('1','187','240020','418',617.00,750.00,0.00,6561.21,4048266.57,4394933.45,346666.88,683846),('1','187','240021','418',617.00,750.00,0.00,1984.48,1224424.16,1337422.10,112997.94,683847),('1','187','240022','418',617.00,750.00,0.00,1972.45,1217001.65,1338819.75,121818.10,683848),('1','187','240023','418',617.00,750.00,0.00,1097.73,677299.41,750537.50,73238.09,683849),('1','187','240024','418',617.00,750.00,0.00,2100.14,1295786.38,1421425.00,125638.62,683850),('1','187','240025','418',617.00,750.00,0.00,1157.86,714399.62,785520.00,71120.38,683851),('1','187','240026','418',617.00,750.00,0.00,1270.91,784151.47,876849.10,92697.63,683852),('1','187','240027','418',617.00,750.00,0.00,2702.79,1667621.43,1808119.50,140498.07,683853),('1','187','240028','418',617.00,750.00,0.00,3137.56,1935874.52,2097114.00,161239.48,683854),('1','187','240029','418',617.00,750.00,0.00,2136.83,1318424.11,1436830.94,118406.83,683855),('1','187','240030','418',617.00,750.00,0.00,427.66,263866.22,287845.00,23978.78,683856),('1','187','240031','418',617.00,750.00,0.00,0.00,0.00,0.00,0.00,683857),('1','187','240032','418',617.00,750.00,0.00,4113.71,2538159.07,2744976.50,206817.43,683858),('1','187','240033','418',617.00,750.00,0.00,2212.39,1365044.63,1476556.50,111511.87,683859),('1','187','240034','418',617.00,750.00,0.00,1207.57,745070.69,821735.50,76664.81,683860),('1','187','240035','418',617.00,750.00,0.00,2062.00,1272254.00,1381718.00,109464.00,683861),('1','187','240036','418',617.00,750.00,0.00,2625.03,1619643.51,1750794.02,131150.51,683862),('1','187','240037','418',617.00,750.00,0.00,1615.64,996849.88,1090524.52,93674.64,683863),('1','187','240038','418',617.00,750.00,0.00,1001.56,617962.52,678869.90,60907.38,683864),('1','187','240039','418',617.00,750.00,0.00,2308.13,1424116.21,1529397.50,105281.29,683865),('1','187','240040','418',617.00,750.00,0.00,1842.99,1137124.83,1228442.50,91317.67,683866),('1','187','240041','418',617.00,750.00,0.00,1299.36,801705.12,860443.00,58737.88,683867),('1','187','240042','418',617.00,750.00,0.00,4411.92,2722154.64,2893481.98,171327.34,683868),('1','187','240043','418',617.00,750.00,0.00,0.00,0.00,0.00,0.00,683869),('1','187','240044','418',617.00,750.00,0.00,1595.43,984380.31,1061984.50,77604.19,683870),('1','187','240045','418',617.00,750.00,0.00,4575.99,2823385.83,3005262.50,181876.67,683871),('1','187','240046','418',617.00,750.00,0.00,2094.38,1292232.46,1394085.00,101852.54,683872),('1','187','240047','418',617.00,750.00,0.00,1859.54,1147336.18,1237993.00,90656.82,683873),('1','187','240048','418',617.00,750.00,0.00,2941.14,1814683.38,1951654.00,136970.62,683874),('1','187','240049','418',617.00,750.00,0.00,1617.87,998225.79,1092787.50,94561.71,683875),('1','187','240050','418',617.00,750.00,0.00,1714.20,1057661.40,1134973.00,77311.60,683876),('1','187','240051','418',617.00,750.00,0.00,2224.77,1372683.09,1471873.50,99190.41,683877),('1','187','240052','418',617.00,750.00,0.00,1752.08,1081033.36,1169260.00,88226.64,683878),('1','187','240053','418',617.00,750.00,0.00,3336.47,2058601.99,2198945.50,140343.51,683879),('1','187','240054','418',617.00,750.00,0.00,1025.47,632714.99,682102.50,49387.51,683880),('1','187','240055','418',617.00,750.00,0.00,0.00,0.00,0.00,0.00,683881),('1','187','240056','418',605.00,710.00,0.00,3575.14,2162959.70,2317432.20,154472.50,683882),('1','187','240057','418',605.00,710.00,0.00,2843.90,1720559.50,1852429.00,131869.50,683883),('1','187','240058','418',605.00,710.00,0.00,1945.28,1176894.40,1268005.70,91111.30,683884),('1','187','240059','418',605.00,710.00,0.00,2287.42,1383889.10,1498154.30,114265.20,683885),('1','187','240060','418',605.00,710.00,0.00,1582.44,957376.20,1032647.90,75271.70,683886),('1','187','240061','418',605.00,710.00,0.00,1577.15,954175.75,1037942.30,83766.55,683887),('1','187','240062','418',605.00,710.00,0.00,1497.71,906114.55,988371.20,82256.65,683888),('1','187','240063','418',605.00,710.00,0.00,2925.87,1770151.35,1908179.80,138028.45,683889),('1','187','240064','418',605.00,710.00,0.00,2989.30,1808526.50,1937183.00,128656.50,683890),('1','187','240065','418',605.00,710.00,0.00,828.41,501188.05,551456.10,50268.05,683891),('1','187','240066','418',605.00,710.00,0.00,2170.53,1313170.65,1403583.00,90412.35,683892),('1','187','240067','418',605.00,710.00,0.00,0.00,0.00,0.00,0.00,683893),('1','187','240068','418',600.00,710.00,0.00,5547.63,3328578.00,3579531.10,250953.10,683894),('1','187','240069','418',600.00,710.00,0.00,1462.97,877782.00,957508.70,79726.70,683895),('1','187','240070','418',600.00,710.00,0.00,2524.04,1514424.00,1638517.10,124093.10,683896),('1','187','240071','418',600.00,710.00,0.00,2746.66,1647996.00,1790281.50,142285.50,683897),('1','187','240072','418',600.00,710.00,0.00,1484.03,890418.00,977717.60,87299.60,683898),('1','187','240073','418',600.00,710.00,0.00,4303.00,2581800.00,2770390.00,188590.00,683899);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=386 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',385,'187','LPG PRODUCT TANK','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=940 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','187','385',939,1,'418','LPG TANK',25000.00,1.00,4381.91,'TANK CONTAINING LPG PRODUCT.','479','2021-06-16 09:24:59','2022-02-11 22:49:02','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','187',939,6860.67,'2023-03-20 18:10:05');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2648852 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2612803,'1','187',NULL,418,'Balance from closing inventory values 2021-11-31 23:59:59',263004124.41,252698683.58,848550.37,848550.37,10283242.78,'2021-11-30 23:59:59','',''),(2613925,'1','187','939',0,'Balance from closing inventory values 2021-11-31 23:59:59',263004124.41,8457783.58,273559.02,273501.84,10283242.78,'2021-11-30 23:59:59','',''),(2613926,'1','187','939',0,'Tank level zero out for dipping',0.00,0.00,0.00,57.18,0.00,'2022-02-12 00:07:20','',''),(2613927,'1','187','939',0,'Inventory adjustment from tank dipping to 1',0.00,0.00,1.00,0.00,0.00,'2022-02-12 00:07:20','',''),(2613928,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,12504820.00,24910.00,0.00,0.00,'2022-02-12 08:54:31','',''),(2613929,'1','187',NULL,418,'Reception corrector for bridging 123743',0.00,0.00,0.00,24910.00,0.00,'2022-02-12 09:06:18','',''),(2613930,'1','187','939',418,'Received from bridging 123743',0.00,0.00,24910.00,0.00,0.00,'2022-02-12 09:06:18','',''),(2613931,'1','187','939',418,'Retail Sale Id 1180500',260000.00,0.00,0.00,500.00,9000.00,'2022-02-12 11:53:36','',''),(2613932,'1','187','939',418,'Retail Sale Id 1180501',104000.00,0.00,0.00,200.00,3600.00,'2022-02-12 11:55:40','',''),(2613933,'1','187','939',418,'Retail Sale Id 1180502',260000.00,0.00,0.00,500.00,9000.00,'2022-02-12 11:56:51','',''),(2613934,'1','187','939',418,'Retail Sale Id 1180503',208000.00,0.00,0.00,400.00,7200.00,'2022-02-12 11:59:46','',''),(2613935,'1','187','939',418,'Retail Sale Id 1180504',62400.00,0.00,0.00,120.00,2160.00,'2022-02-12 12:00:44','',''),(2613936,'1','187','939',418,'Retail Sale Id 1180505',7000.00,0.00,0.00,12.50,725.00,'2022-02-12 12:01:52','',''),(2613937,'1','187','939',418,'Retail Sale Id 1180506',2688.00,0.00,0.00,4.80,278.40,'2022-02-12 12:04:13','',''),(2613938,'1','187','939',418,'Retail Sale Id 1180507',14000.00,0.00,0.00,25.00,1450.00,'2022-02-12 12:05:05','',''),(2613939,'1','187','939',418,'Retail Sale Id 1180508',14000.00,0.00,0.00,25.00,1450.00,'2022-02-12 12:06:29','',''),(2613940,'1','187','939',418,'Retail Sale Id 1180509',28000.00,0.00,0.00,50.00,2900.00,'2022-02-12 18:22:41','',''),(2613941,'1','187','939',418,'Retail Sale Id 1180510',28000.00,0.00,0.00,50.00,2900.00,'2022-02-12 18:23:24','',''),(2613942,'1','187','939',418,'Retail Sale Id 1180511',28000.00,0.00,0.00,50.00,2900.00,'2022-02-12 18:24:45','',''),(2613943,'1','187','939',418,'Retail Sale Id 1180512',427518.00,0.00,0.00,822.15,14798.70,'2022-02-12 18:35:16','',''),(2613944,'1','187','939',418,'Retail Sale Id 1180513',364026.00,0.00,0.00,700.05,12600.90,'2022-02-12 18:35:52','',''),(2613945,'1','187','939',418,'Retail Sale Id 1180514',234020.80,0.00,0.00,450.04,8100.72,'2022-02-12 18:36:40','',''),(2613946,'1','187','939',418,'Retail Sale Id 1180515',10416.00,0.00,0.00,18.60,1078.80,'2022-02-12 18:37:37','',''),(2613947,'1','187','939',418,'Retail Sale Id 1180516',3360.00,0.00,0.00,6.00,348.00,'2022-02-13 10:29:07','',''),(2613948,'1','187','939',418,'Retail Sale Id 1180517',1500.80,0.00,0.00,2.68,155.44,'2022-02-13 10:30:07','',''),(2613949,'1','187','939',418,'Retail Sale Id 1180518',2497.60,0.00,0.00,4.46,258.68,'2022-02-13 10:37:43','',''),(2613950,'1','187','939',418,'Retail Sale Id 1180519',7000.00,0.00,0.00,12.50,725.00,'2022-02-13 10:40:19','',''),(2613951,'1','187','939',418,'Retail Sale Id 1180520',52000.00,0.00,0.00,100.00,1800.00,'2022-02-13 10:42:23','',''),(2613952,'1','187','939',418,'Retail Sale Id 1180521',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 10:45:05','',''),(2613953,'1','187','939',418,'Retail Sale Id 1180522',1120.00,0.00,0.00,2.00,116.00,'2022-02-13 10:58:46','',''),(2613954,'1','187','939',418,'Retail Sale Id 1180523',1680.00,0.00,0.00,3.00,174.00,'2022-02-13 11:01:29','',''),(2613955,'1','187','939',418,'Retail Sale Id 1180524',3360.00,0.00,0.00,6.00,348.00,'2022-02-13 11:06:34','',''),(2613956,'1','187','939',418,'Retail Sale Id 1180525',1999.20,0.00,0.00,3.57,207.06,'2022-02-13 11:12:21','',''),(2613957,'1','187','939',418,'Retail Sale Id 1180526',2800.00,0.00,0.00,5.00,290.00,'2022-02-13 11:13:23','',''),(2613958,'1','187','939',418,'Retail Sale Id 1180528',26000.00,0.00,0.00,50.00,900.00,'2022-02-13 11:29:08','',''),(2613959,'1','187','939',418,'Retail Sale Id 1180529',26000.00,0.00,0.00,50.00,900.00,'2022-02-13 11:31:33','',''),(2613960,'1','187','939',418,'Retail Sale Id 1180530',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 11:33:26','',''),(2613961,'1','187','939',418,'Retail Sale Id 1180531',1120.00,0.00,0.00,2.00,116.00,'2022-02-13 11:45:43','',''),(2613962,'1','187','939',418,'Retail Sale Id 1180532',7000.00,0.00,0.00,12.50,725.00,'2022-02-13 11:50:04','',''),(2613963,'1','187','939',418,'Retail Sale Id 1180533',52000.00,0.00,0.00,100.00,1800.00,'2022-02-13 12:15:09','',''),(2613964,'1','187','939',418,'Retail Sale Id 1180534',78000.00,0.00,0.00,150.00,2700.00,'2022-02-13 12:19:05','',''),(2613965,'1','187','939',418,'Retail Sale Id 1180535',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 12:46:51','',''),(2613966,'1','187','939',418,'Retail Sale Id 1180536',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 13:07:04','',''),(2613967,'1','187','939',418,'Retail Sale Id 1180537',2240.00,0.00,0.00,4.00,232.00,'2022-02-13 13:17:56','',''),(2613968,'1','187','939',418,'Retail Sale Id 1180538',1120.00,0.00,0.00,2.00,116.00,'2022-02-13 13:25:20','',''),(2613969,'1','187','939',418,'Retail Sale Id 1180539',3360.00,0.00,0.00,6.00,348.00,'2022-02-13 13:40:47','',''),(2613970,'1','187','939',418,'Retail Sale Id 1180540',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 13:52:27','',''),(2613971,'1','187','939',418,'Retail Sale Id 1180541',3360.00,0.00,0.00,6.00,348.00,'2022-02-13 14:23:01','',''),(2613972,'1','187','939',418,'Retail Sale Id 1180542',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 15:03:28','',''),(2613973,'1','187','939',418,'Retail Sale Id 1180543',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 15:04:01','',''),(2613974,'1','187','939',418,'Retail Sale Id 1180544',3360.00,0.00,0.00,6.00,348.00,'2022-02-13 15:04:47','',''),(2613975,'1','187','939',418,'Retail Sale Id 1180545',31200.00,0.00,0.00,60.00,1080.00,'2022-02-13 15:08:14','',''),(2613976,'1','187','939',418,'Return of Retail Sale Id 1180545',0.00,31200.00,60.00,0.00,-1080.00,'2022-02-13 15:24:57','',''),(2613977,'1','187','939',418,'Retail Sale Id 1180546',30680.00,0.00,0.00,59.00,1062.00,'2022-02-13 15:25:36','',''),(2613978,'1','187','939',418,'Retail Sale Id 1180547',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 15:39:18','',''),(2613979,'1','187','939',418,'Retail Sale Id 1180548',1680.00,0.00,0.00,3.00,174.00,'2022-02-13 15:41:48','',''),(2613980,'1','187','939',418,'Retail Sale Id 1180549',7000.00,0.00,0.00,12.50,725.00,'2022-02-13 15:47:47','',''),(2613981,'1','187','939',418,'Retail Sale Id 1180550',1500.80,0.00,0.00,2.68,155.44,'2022-02-13 15:52:59','',''),(2613982,'1','187','939',418,'Retail Sale Id 1180551',1120.00,0.00,0.00,2.00,116.00,'2022-02-13 15:54:21','',''),(2613983,'1','187','939',418,'Retail Sale Id 1180552',3360.00,0.00,0.00,6.00,348.00,'2022-02-13 15:57:17','',''),(2613984,'1','187','939',418,'Retail Sale Id 1180553',1002.40,0.00,0.00,1.79,103.82,'2022-02-13 16:15:29','',''),(2613985,'1','187','939',418,'Retail Sale Id 1180554',2800.00,0.00,0.00,5.00,290.00,'2022-02-13 16:16:26','',''),(2613986,'1','187','939',418,'Retail Sale Id 1180555',1680.00,0.00,0.00,3.00,174.00,'2022-02-13 16:17:21','',''),(2613987,'1','187','939',418,'Retail Sale Id 1180556',1500.80,0.00,0.00,2.68,155.44,'2022-02-14 08:01:47','',''),(2613988,'1','187','939',418,'Retail Sale Id 1180557',1198.40,0.00,0.00,2.14,124.12,'2022-02-14 08:02:58','',''),(2613989,'1','187','939',418,'Retail Sale Id 1180558',3500.00,0.00,0.00,6.25,362.50,'2022-02-14 08:15:54','',''),(2613990,'1','187','939',418,'Retail Sale Id 1180559',1680.00,0.00,0.00,3.00,174.00,'2022-02-14 08:16:47','',''),(2613991,'1','187','939',418,'Retail Sale Id 1180560',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 08:21:01','',''),(2613992,'1','187','939',418,'Retail Sale Id 1180561',3920.00,0.00,0.00,7.00,406.00,'2022-02-14 08:42:20','',''),(2613993,'1','187','939',418,'Retail Sale Id 1180562',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 08:48:12','',''),(2613994,'1','187','939',418,'Retail Sale Id 1180563',1500.80,0.00,0.00,2.68,155.44,'2022-02-14 08:49:54','',''),(2613995,'1','187','939',418,'Retail Sale Id 1180564',49400.00,0.00,0.00,95.00,1710.00,'2022-02-14 08:51:42','',''),(2613996,'1','187','939',418,'Retail Sale Id 1180565',3998.40,0.00,0.00,7.14,414.12,'2022-02-14 08:52:46','',''),(2613997,'1','187','939',418,'Retail Sale Id 1180566',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 08:54:44','',''),(2613998,'1','187','939',418,'Retail Sale Id 1180567',20800.00,0.00,0.00,40.00,720.00,'2022-02-14 09:14:09','',''),(2613999,'1','187','939',418,'Retail Sale Id 1180568',6720.00,0.00,0.00,12.00,696.00,'2022-02-14 09:36:33','',''),(2614000,'1','187','939',418,'Retail Sale Id 1180569',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 09:37:43','',''),(2614001,'1','187','939',418,'Retail Sale Id 1180570',1198.40,0.00,0.00,2.14,124.12,'2022-02-14 09:50:11','',''),(2614002,'1','187','939',418,'Retail Sale Id 1180571',52000.00,0.00,0.00,100.00,1800.00,'2022-02-14 09:51:26','',''),(2614003,'1','187','939',418,'Retail Sale Id 1180572',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 10:01:52','',''),(2614004,'1','187','939',418,'Retail Sale Id 1180574',20800.00,0.00,0.00,40.00,720.00,'2022-02-14 10:03:02','',''),(2614005,'1','187','939',418,'Retail Sale Id 1180576',78000.00,0.00,0.00,150.00,2700.00,'2022-02-14 10:15:31','',''),(2614006,'1','187','939',418,'Retail Sale Id 1180577',78000.00,0.00,0.00,150.00,2700.00,'2022-02-14 10:16:24','',''),(2614007,'1','187','939',418,'Retail Sale Id 1180578',78000.00,0.00,0.00,150.00,2700.00,'2022-02-14 10:17:20','',''),(2614008,'1','187','939',418,'Retail Sale Id 1180579',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 10:18:26','',''),(2614009,'1','187','939',418,'Retail Sale Id 1180580',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 10:19:29','',''),(2614010,'1','187','939',418,'Retail Sale Id 1180581',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 10:44:57','',''),(2614011,'1','187','939',418,'Retail Sale Id 1180582',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 10:46:09','',''),(2614012,'1','187','939',418,'Retail Sale Id 1180583',1680.00,0.00,0.00,3.00,174.00,'2022-02-14 10:51:47','',''),(2614013,'1','187','939',418,'Retail Sale Id 1180584',52000.00,0.00,0.00,100.00,1800.00,'2022-02-14 10:54:02','',''),(2614014,'1','187','939',418,'Retail Sale Id 1180585',41600.00,0.00,0.00,80.00,1440.00,'2022-02-14 10:56:07','',''),(2614015,'1','187','939',418,'Retail Sale Id 1180586',1120.00,0.00,0.00,2.00,116.00,'2022-02-14 11:19:58','',''),(2614016,'1','187','939',418,'Retail Sale Id 1180588',78000.00,0.00,0.00,150.00,2700.00,'2022-02-14 11:28:52','',''),(2614017,'1','187','939',418,'Retail Sale Id 1180589',1999.20,0.00,0.00,3.57,207.06,'2022-02-14 11:32:12','',''),(2614018,'1','187','939',418,'Retail Sale Id 1180590',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 11:39:54','',''),(2614019,'1','187','939',418,'Retail Sale Id 1180591',1120.00,0.00,0.00,2.00,116.00,'2022-02-14 11:59:15','',''),(2614020,'1','187','939',418,'Retail Sale Id 1180592',2800.00,0.00,0.00,5.00,290.00,'2022-02-14 12:03:49','',''),(2614021,'1','187','939',418,'Retail Sale Id 1180593',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 12:08:40','',''),(2614022,'1','187','939',418,'Retail Sale Id 1180594',2800.00,0.00,0.00,5.00,290.00,'2022-02-14 12:12:57','',''),(2614023,'1','187','939',418,'Retail Sale Id 1180595',1680.00,0.00,0.00,3.00,174.00,'2022-02-14 12:14:23','',''),(2614024,'1','187','939',418,'Retail Sale Id 1180596',52000.00,0.00,0.00,100.00,1800.00,'2022-02-14 12:31:11','',''),(2614025,'1','187','939',418,'Retail Sale Id 1180597',10360.00,0.00,0.00,18.50,1073.00,'2022-02-14 12:55:40','',''),(2614026,'1','187','939',418,'Retail Sale Id 1180598',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 12:57:22','',''),(2614027,'1','187','939',418,'Retail Sale Id 1180599',20800.00,0.00,0.00,40.00,720.00,'2022-02-14 13:32:07','',''),(2614028,'1','187','939',418,'Retail Sale Id 1180600',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 14:01:47','',''),(2614029,'1','187','939',418,'Retail Sale Id 1180601',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 14:05:51','',''),(2614030,'1','187','939',418,'Retail Sale Id 1180602',52000.00,0.00,0.00,100.00,1800.00,'2022-02-14 14:08:54','',''),(2614031,'1','187','939',418,'Retail Sale Id 1180603',52000.00,0.00,0.00,100.00,1800.00,'2022-02-14 14:36:07','',''),(2614032,'1','187','939',418,'Retail Sale Id 1180604',28600.00,0.00,0.00,55.00,990.00,'2022-02-14 14:38:02','',''),(2614033,'1','187','939',418,'Retail Sale Id 1180605',1120.00,0.00,0.00,2.00,116.00,'2022-02-14 14:39:43','',''),(2614034,'1','187','939',418,'Retail Sale Id 1180606',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 14:44:36','',''),(2614035,'1','187','939',418,'Retail Sale Id 1180607',3360.00,0.00,0.00,6.00,348.00,'2022-02-14 14:49:17','',''),(2614036,'1','187','939',418,'Retail Sale Id 1180608',1680.00,0.00,0.00,3.00,174.00,'2022-02-14 14:57:10','',''),(2614037,'1','187','939',418,'Retail Sale Id 1180609',52000.00,0.00,0.00,100.00,1800.00,'2022-02-14 15:09:49','',''),(2614038,'1','187','939',418,'Retail Sale Id 1180610',1680.00,0.00,0.00,3.00,174.00,'2022-02-14 15:12:06','',''),(2614039,'1','187','939',418,'Retail Sale Id 1180611',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 15:25:10','',''),(2614040,'1','187','939',418,'Retail Sale Id 1180612',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 15:27:30','',''),(2614041,'1','187','939',418,'Retail Sale Id 1180613',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 15:29:47','',''),(2614042,'1','187','939',418,'Retail Sale Id 1180614',1500.80,0.00,0.00,2.68,155.44,'2022-02-14 15:52:11','',''),(2614043,'1','187','939',418,'Retail Sale Id 1180615',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 15:56:10','',''),(2614044,'1','187','939',418,'Retail Sale Id 1180616',1500.80,0.00,0.00,2.68,155.44,'2022-02-14 16:13:50','',''),(2614045,'1','187','939',418,'Retail Sale Id 1180617',1120.00,0.00,0.00,2.00,116.00,'2022-02-14 16:17:37','',''),(2614046,'1','187','939',418,'Retail Sale Id 1180618',26000.00,0.00,0.00,50.00,900.00,'2022-02-14 16:21:00','',''),(2614047,'1','187','939',418,'Retail Sale Id 1180619',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 16:21:56','',''),(2614048,'1','187','939',418,'Retail Sale Id 1180620',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 16:39:53','',''),(2614049,'1','187','939',418,'Retail Sale Id 1180621',62400.00,0.00,0.00,120.00,2160.00,'2022-02-14 16:42:08','',''),(2614050,'1','187','939',418,'Retail Sale Id 1180622',2497.60,0.00,0.00,4.46,258.68,'2022-02-14 16:49:49','',''),(2614051,'1','187','939',418,'Retail Sale Id 1180623',39000.00,0.00,0.00,75.00,1350.00,'2022-02-14 16:51:38','',''),(2614052,'1','187','939',418,'Retail Sale Id 1180624',1999.20,0.00,0.00,3.57,207.06,'2022-02-14 16:53:11','',''),(2614053,'1','187','939',418,'Retail Sale Id 1180625',1120.00,0.00,0.00,2.00,116.00,'2022-02-14 17:04:11','',''),(2614054,'1','187','939',418,'Retail Sale Id 1180626',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 17:10:10','',''),(2614055,'1','187','939',418,'Retail Sale Id 1180627',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 17:11:30','',''),(2614056,'1','187','939',418,'Retail Sale Id 1180628',7000.00,0.00,0.00,12.50,725.00,'2022-02-14 17:12:34','',''),(2614057,'1','187','939',418,'Retail Sale Id 1180629',1848.00,0.00,0.00,3.30,191.40,'2022-02-14 17:14:57','',''),(2614058,'1','187','939',418,'Retail Sale Id 1180630',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 17:17:00','',''),(2614059,'1','187','939',418,'Retail Sale Id 1180631',2240.00,0.00,0.00,4.00,232.00,'2022-02-14 17:21:41','',''),(2614060,'1','187','939',418,'Retail Sale Id 1180633',2240.00,0.00,0.00,4.00,232.00,'2022-02-14 17:23:54','',''),(2614061,'1','187','939',418,'Retail Sale Id 1180634',3399.20,0.00,0.00,6.07,352.06,'2022-02-14 17:24:42','',''),(2614062,'1','187','939',418,'Retail Sale Id 1180635',1500.80,0.00,0.00,2.68,155.44,'2022-02-14 17:25:29','',''),(2614063,'1','187','939',418,'Retail Sale Id 1180636',1500.80,0.00,0.00,2.68,155.44,'2022-02-14 17:26:40','',''),(2614064,'1','187','939',418,'Retail Sale Id 1180637',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 17:28:00','',''),(2614065,'1','187','939',418,'Retail Sale Id 1180638',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 17:30:45','',''),(2614066,'1','187','939',418,'Retail Sale Id 1180639',1680.00,0.00,0.00,3.00,174.00,'2022-02-14 17:33:01','',''),(2614067,'1','187','939',418,'Retail Sale Id 1180640',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 17:34:15','',''),(2614068,'1','187','939',418,'Retail Sale Id 1180641',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 17:42:36','',''),(2614069,'1','187','939',418,'Retail Sale Id 1180642',1002.40,0.00,0.00,1.79,103.82,'2022-02-14 17:43:17','',''),(2614070,'1','187','939',418,'Retail Sale Id 1180643',1702.40,0.00,0.00,3.04,176.32,'2022-02-14 17:54:54','',''),(2614071,'1','187','939',418,'Retail Sale Id 1180644',3001.60,0.00,0.00,5.36,310.88,'2022-02-14 17:57:52','',''),(2614072,'1','187','939',418,'Retail Sale Id 1180645',3399.20,0.00,0.00,6.07,352.06,'2022-02-14 17:59:50','',''),(2614073,'1','187','939',418,'Retail Sale Id 1180646',3744.00,0.00,0.00,7.20,129.60,'2022-02-14 18:29:12','',''),(2614074,'1','187','939',418,'Retail Sale Id 1180647',7332.00,0.00,0.00,14.10,253.80,'2022-02-14 18:32:12','',''),(2614075,'1','187','939',418,'Retail Sale Id 1180648',28.00,0.00,0.00,0.05,2.90,'2022-02-14 18:55:40','',''),(2614076,'1','187','939',418,'Retail Sale Id 1180649',26000.00,0.00,0.00,50.00,900.00,'2022-02-15 08:12:42','',''),(2614077,'1','187','939',418,'Retail Sale Id 1180650',1500.80,0.00,0.00,2.68,155.44,'2022-02-15 08:28:17','',''),(2614078,'1','187','939',418,'Retail Sale Id 1180651',7000.00,0.00,0.00,12.50,725.00,'2022-02-15 08:38:29','',''),(2614079,'1','187','939',418,'Retail Sale Id 1180652',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 08:52:56','',''),(2614080,'1','187','939',418,'Retail Sale Id 1180653',26000.00,0.00,0.00,50.00,900.00,'2022-02-15 08:57:11','',''),(2614081,'1','187','939',418,'Retail Sale Id 1180654',3399.20,0.00,0.00,6.07,352.06,'2022-02-15 09:19:47','',''),(2614082,'1','187','939',418,'Retail Sale Id 1180655',3399.20,0.00,0.00,6.07,352.06,'2022-02-15 09:28:29','',''),(2614083,'1','187','939',418,'Retail Sale Id 1180656',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 09:30:33','',''),(2614084,'1','187','939',418,'Retail Sale Id 1180657',52000.00,0.00,0.00,100.00,1800.00,'2022-02-15 09:32:36','',''),(2614085,'1','187','939',418,'Retail Sale Id 1180658',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 09:34:26','',''),(2614086,'1','187','939',418,'Retail Sale Id 1180659',3399.20,0.00,0.00,6.07,352.06,'2022-02-15 10:02:59','',''),(2614087,'1','187','939',418,'Retail Sale Id 1180660',26000.00,0.00,0.00,50.00,900.00,'2022-02-15 10:04:03','',''),(2614088,'1','187','939',418,'Retail Sale Id 1180661',1002.40,0.00,0.00,1.79,103.82,'2022-02-15 10:06:57','',''),(2614089,'1','187','939',418,'Retail Sale Id 1180662',52000.00,0.00,0.00,100.00,1800.00,'2022-02-15 10:46:46','',''),(2614090,'1','187','939',418,'Retail Sale Id 1180663',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 10:51:01','',''),(2614091,'1','187','939',418,'Retail Sale Id 1180664',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 11:03:14','',''),(2614092,'1','187','939',418,'Retail Sale Id 1180665',5000.80,0.00,0.00,8.93,517.94,'2022-02-15 11:04:28','',''),(2614093,'1','187','939',418,'Retail Sale Id 1180666',1500.80,0.00,0.00,2.68,155.44,'2022-02-15 11:18:26','',''),(2614094,'1','187','939',418,'Retail Sale Id 1180667',18200.00,0.00,0.00,35.00,630.00,'2022-02-15 11:19:57','',''),(2614095,'1','187','939',418,'Retail Sale Id 1180668',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 11:21:13','',''),(2614096,'1','187','939',418,'Retail Sale Id 1180669',52000.00,0.00,0.00,100.00,1800.00,'2022-02-15 11:33:12','',''),(2614097,'1','187','939',418,'Retail Sale Id 1180670',1500.80,0.00,0.00,2.68,155.44,'2022-02-15 11:57:43','',''),(2614098,'1','187','939',418,'Retail Sale Id 1180671',3399.20,0.00,0.00,6.07,352.06,'2022-02-15 12:43:56','',''),(2614099,'1','187','939',418,'Retail Sale Id 1180672',1120.00,0.00,0.00,2.00,116.00,'2022-02-15 13:02:08','',''),(2614100,'1','187','939',418,'Retail Sale Id 1180673',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 13:04:02','',''),(2614101,'1','187','939',418,'Retail Sale Id 1180674',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 13:32:51','',''),(2614102,'1','187','939',418,'Return of Retail Sale Id 1180674',0.00,78000.00,150.00,0.00,-2700.00,'2022-02-15 13:38:32','',''),(2614103,'1','187','939',418,'Retail Sale Id 1180676',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 13:39:15','',''),(2614104,'1','187','939',418,'Retail Sale Id 1180677',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 14:05:34','',''),(2614105,'1','187','939',418,'Retail Sale Id 1180678',3500.00,0.00,0.00,6.25,362.50,'2022-02-15 14:56:28','',''),(2614106,'1','187','939',418,'Retail Sale Id 1180679',3360.00,0.00,0.00,6.00,348.00,'2022-02-15 15:02:48','',''),(2614107,'1','187','939',418,'Retail Sale Id 1180680',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 15:05:42','',''),(2614108,'1','187','939',418,'Retail Sale Id 1180681',26000.00,0.00,0.00,50.00,900.00,'2022-02-15 15:13:33','',''),(2614109,'1','187','939',418,'Retail Sale Id 1180682',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 15:22:29','',''),(2614110,'1','187','939',418,'Retail Sale Id 1180683',52000.00,0.00,0.00,100.00,1800.00,'2022-02-15 15:23:34','',''),(2614111,'1','187','939',418,'Retail Sale Id 1180684',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 15:26:35','',''),(2614112,'1','187','939',418,'Retail Sale Id 1180685',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 15:28:11','',''),(2614113,'1','187','939',418,'Retail Sale Id 1180686',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 15:49:58','',''),(2614114,'1','187','939',418,'Retail Sale Id 1180687',52000.00,0.00,0.00,100.00,1800.00,'2022-02-15 16:02:12','',''),(2614115,'1','187','939',418,'Retail Sale Id 1180689',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 16:24:52','',''),(2614116,'1','187','939',418,'Retail Sale Id 1180690',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 16:34:30','',''),(2614117,'1','187','939',418,'Retail Sale Id 1180691',1002.40,0.00,0.00,1.79,103.82,'2022-02-15 16:45:57','',''),(2614118,'1','187','939',418,'Retail Sale Id 1180692',1999.20,0.00,0.00,3.57,207.06,'2022-02-15 16:49:00','',''),(2614119,'1','187','939',418,'Retail Sale Id 1180693',1002.40,0.00,0.00,1.79,103.82,'2022-02-15 16:53:38','',''),(2614120,'1','187','939',418,'Retail Sale Id 1180694',1198.40,0.00,0.00,2.14,124.12,'2022-02-15 16:55:11','',''),(2614121,'1','187','939',418,'Retail Sale Id 1180695',1500.80,0.00,0.00,2.68,155.44,'2022-02-15 16:56:35','',''),(2614122,'1','187','939',418,'Retail Sale Id 1180696',1002.40,0.00,0.00,1.79,103.82,'2022-02-15 17:08:28','',''),(2614123,'1','187','939',418,'Retail Sale Id 1180697',3500.00,0.00,0.00,6.25,362.50,'2022-02-15 17:18:26','',''),(2614124,'1','187','939',418,'Retail Sale Id 1180698',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 17:26:45','',''),(2614125,'1','187','939',418,'Retail Sale Id 1180700',1198.40,0.00,0.00,2.14,124.12,'2022-02-15 17:34:00','',''),(2614126,'1','187','939',418,'Retail Sale Id 1180701',1002.40,0.00,0.00,1.79,103.82,'2022-02-15 17:38:02','',''),(2614127,'1','187','939',418,'Retail Sale Id 1180702',26000.00,0.00,0.00,50.00,900.00,'2022-02-15 17:39:25','',''),(2614128,'1','187','939',418,'Retail Sale Id 1180703',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 17:52:15','',''),(2614129,'1','187','939',418,'Retail Sale Id 1180704',78000.00,0.00,0.00,150.00,2700.00,'2022-02-15 18:01:55','',''),(2614130,'1','187','939',418,'Retail Sale Id 1180705',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 18:08:36','',''),(2614131,'1','187','939',418,'Retail Sale Id 1180706',1120.00,0.00,0.00,2.00,116.00,'2022-02-15 18:16:46','',''),(2614132,'1','187','939',418,'Retail Sale Id 1180707',1002.40,0.00,0.00,1.79,103.82,'2022-02-15 18:19:05','',''),(2614133,'1','187','939',418,'Retail Sale Id 1180708',1702.40,0.00,0.00,3.04,176.32,'2022-02-15 18:19:46','',''),(2614134,'1','187','939',418,'Return of Retail Sale Id 1180707',0.00,1002.40,1.79,0.00,-103.82,'2022-02-15 18:22:49','',''),(2614135,'1','187','939',418,'Retail Sale Id 1180709',151.20,0.00,0.00,0.27,15.66,'2022-02-15 18:55:29','',''),(2614136,'1','187','939',418,'Retail Sale Id 1180710',1999.20,0.00,0.00,3.57,207.06,'2022-02-16 08:45:19','',''),(2614137,'1','187','939',418,'Retail Sale Id 1180711',1999.20,0.00,0.00,3.57,207.06,'2022-02-16 08:46:48','',''),(2614138,'1','187','939',418,'Retail Sale Id 1180712',1148.00,0.00,0.00,2.05,118.90,'2022-02-16 08:48:37','',''),(2614139,'1','187','939',418,'Retail Sale Id 1180713',90480.00,0.00,0.00,174.00,3132.00,'2022-02-16 08:54:31','',''),(2614140,'1','187','939',418,'Retail Sale Id 1180714',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 08:57:13','',''),(2614141,'1','187','939',418,'Retail Sale Id 1180715',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 09:09:25','',''),(2614142,'1','187','939',418,'Retail Sale Id 1180716',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 09:25:19','',''),(2614143,'1','187','939',418,'Retail Sale Id 1180717',1120.00,0.00,0.00,2.00,116.00,'2022-02-16 09:26:49','',''),(2614144,'1','187','939',418,'Retail Sale Id 1180718',1500.80,0.00,0.00,2.68,155.44,'2022-02-16 09:32:30','',''),(2614145,'1','187','939',418,'Retail Sale Id 1180719',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 09:33:26','',''),(2614146,'1','187','939',418,'Retail Sale Id 1180720',26000.00,0.00,0.00,50.00,900.00,'2022-02-16 09:35:23','',''),(2614147,'1','187','939',418,'Retail Sale Id 1180721',60320.00,0.00,0.00,116.00,2088.00,'2022-02-16 09:43:46','',''),(2614148,'1','187','939',418,'Retail Sale Id 1180722',15600.00,0.00,0.00,30.00,540.00,'2022-02-16 09:44:34','',''),(2614149,'1','187','939',418,'Retail Sale Id 1180723',104000.00,0.00,0.00,200.00,3600.00,'2022-02-16 09:47:41','',''),(2614150,'1','187','939',418,'Retail Sale Id 1180724',3001.60,0.00,0.00,5.36,310.88,'2022-02-16 09:54:41','',''),(2614151,'1','187','939',418,'Retail Sale Id 1180725',78000.00,0.00,0.00,150.00,2700.00,'2022-02-16 09:59:11','',''),(2614152,'1','187','939',418,'Retail Sale Id 1180726',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 10:26:00','',''),(2614153,'1','187','939',418,'Retail Sale Id 1180727',2800.00,0.00,0.00,5.00,290.00,'2022-02-16 10:46:25','',''),(2614154,'1','187','939',418,'Retail Sale Id 1180728',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 10:47:36','',''),(2614155,'1','187','939',418,'Retail Sale Id 1180729',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 11:15:14','',''),(2614156,'1','187','939',418,'Retail Sale Id 1180730',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 11:19:12','',''),(2614157,'1','187','939',418,'Retail Sale Id 1180731',78000.00,0.00,0.00,150.00,2700.00,'2022-02-16 11:41:29','',''),(2614158,'1','187','939',418,'Retail Sale Id 1180732',3399.20,0.00,0.00,6.07,352.06,'2022-02-16 11:45:06','',''),(2614159,'1','187','939',418,'Retail Sale Id 1180733',3399.20,0.00,0.00,6.07,352.06,'2022-02-16 12:12:24','',''),(2614160,'1','187','939',418,'Retail Sale Id 1180734',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 12:17:36','',''),(2614161,'1','187','939',418,'Retail Sale Id 1180735',2251.20,0.00,0.00,4.02,233.16,'2022-02-16 13:02:16','',''),(2614162,'1','187','939',418,'Retail Sale Id 1180737',52000.00,0.00,0.00,100.00,1800.00,'2022-02-16 13:48:53','',''),(2614163,'1','187','939',418,'Retail Sale Id 1180738',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 14:03:52','',''),(2614164,'1','187','939',418,'Retail Sale Id 1180739',52000.00,0.00,0.00,100.00,1800.00,'2022-02-16 14:10:23','',''),(2614165,'1','187','939',418,'Retail Sale Id 1180741',52000.00,0.00,0.00,100.00,1800.00,'2022-02-16 14:11:42','',''),(2614166,'1','187','939',418,'Retail Sale Id 1180742',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 14:16:24','',''),(2614167,'1','187','939',418,'Retail Sale Id 1180743',26000.00,0.00,0.00,50.00,900.00,'2022-02-16 14:27:28','',''),(2614168,'1','187','939',418,'Retail Sale Id 1180744',26000.00,0.00,0.00,50.00,900.00,'2022-02-16 14:28:53','',''),(2614169,'1','187','939',418,'Retail Sale Id 1180745',52000.00,0.00,0.00,100.00,1800.00,'2022-02-16 14:34:41','',''),(2614170,'1','187','939',418,'Retail Sale Id 1180746',1500.80,0.00,0.00,2.68,155.44,'2022-02-16 14:37:23','',''),(2614171,'1','187','939',418,'Retail Sale Id 1180747',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 14:40:23','',''),(2614172,'1','187','939',418,'Retail Sale Id 1180748',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 14:51:02','',''),(2614173,'1','187','939',418,'Retail Sale Id 1180749',1999.20,0.00,0.00,3.57,207.06,'2022-02-16 15:12:53','',''),(2614174,'1','187','939',418,'Retail Sale Id 1180750',1680.00,0.00,0.00,3.00,174.00,'2022-02-16 15:50:20','',''),(2614175,'1','187','939',418,'Retail Sale Id 1180751',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 15:50:57','',''),(2614176,'1','187','939',418,'Retail Sale Id 1180752',2800.00,0.00,0.00,5.00,290.00,'2022-02-16 16:08:46','',''),(2614177,'1','187','939',418,'Retail Sale Id 1180753',3399.20,0.00,0.00,6.07,352.06,'2022-02-16 16:16:24','',''),(2614178,'1','187','939',418,'Retail Sale Id 1180754',3399.20,0.00,0.00,6.07,352.06,'2022-02-16 16:34:48','',''),(2614179,'1','187','939',418,'Retail Sale Id 1180755',3001.60,0.00,0.00,5.36,310.88,'2022-02-16 16:40:21','',''),(2614180,'1','187','939',418,'Retail Sale Id 1180757',52000.00,0.00,0.00,100.00,1800.00,'2022-02-16 16:51:33','',''),(2614181,'1','187','939',418,'Retail Sale Id 1180758',26000.00,0.00,0.00,50.00,900.00,'2022-02-16 16:53:37','',''),(2614182,'1','187','939',418,'Retail Sale Id 1180759',25480.00,0.00,0.00,49.00,882.00,'2022-02-16 16:54:54','',''),(2614183,'1','187','939',418,'Retail Sale Id 1180760',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 16:58:29','',''),(2614184,'1','187','939',418,'Retail Sale Id 1180761',1702.40,0.00,0.00,3.04,176.32,'2022-02-16 17:02:48','',''),(2614185,'1','187','939',418,'Retail Sale Id 1180762',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 17:04:23','',''),(2614186,'1','187','939',418,'Retail Sale Id 1180763',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 17:07:25','',''),(2614187,'1','187','939',418,'Retail Sale Id 1180764',1702.40,0.00,0.00,3.04,176.32,'2022-02-16 17:26:20','',''),(2614188,'1','187','939',418,'Retail Sale Id 1180765',1702.40,0.00,0.00,3.04,176.32,'2022-02-16 17:28:07','',''),(2614189,'1','187','939',418,'Retail Sale Id 1180766',14040.00,0.00,0.00,27.00,486.00,'2022-02-16 17:29:52','',''),(2614190,'1','187','939',418,'Retail Sale Id 1180767',1198.40,0.00,0.00,2.14,124.12,'2022-02-16 17:32:10','',''),(2614191,'1','187','939',418,'Retail Sale Id 1180768',1500.80,0.00,0.00,2.68,155.44,'2022-02-16 17:34:05','',''),(2614192,'1','187','939',418,'Retail Sale Id 1180769',52000.00,0.00,0.00,100.00,1800.00,'2022-02-16 17:46:44','',''),(2614193,'1','187','939',418,'Retail Sale Id 1180770',1702.40,0.00,0.00,3.04,176.32,'2022-02-16 17:59:34','',''),(2614194,'1','187','939',418,'Retail Sale Id 1180771',1002.40,0.00,0.00,1.79,103.82,'2022-02-16 18:05:25','',''),(2614195,'1','187','939',418,'Retail Sale Id 1180776',26000.00,0.00,0.00,50.00,900.00,'2022-02-16 18:19:42','',''),(2614196,'1','187','939',418,'Retail Sale Id 1180777',1702.40,0.00,0.00,3.04,176.32,'2022-02-16 18:20:38','',''),(2614197,'1','187','939',418,'Retail Sale Id 1180778',25266.80,0.00,0.00,48.59,874.62,'2022-02-16 18:32:43','',''),(2614198,'1','187','939',418,'Retail Sale Id 1180779',212.80,0.00,0.00,0.38,22.04,'2022-02-16 18:34:14','',''),(2614199,'1','187','939',418,'Return of Retail Sale Id 1180758',0.00,26000.00,50.00,0.00,-900.00,'2022-02-16 18:40:06','',''),(2614200,'1','187','939',418,'Retail Sale Id 1180780',20800.00,0.00,0.00,40.00,720.00,'2022-02-16 18:40:48','',''),(2614201,'1','187','939',418,'Retail Sale Id 1180781',104000.00,0.00,0.00,200.00,3600.00,'2022-02-17 08:23:45','',''),(2614202,'1','187','939',418,'Retail Sale Id 1180782',104000.00,0.00,0.00,200.00,3600.00,'2022-02-17 08:24:57','',''),(2614203,'1','187','939',418,'Retail Sale Id 1180783',104000.00,0.00,0.00,200.00,3600.00,'2022-02-17 08:26:02','',''),(2614204,'1','187','939',418,'Retail Sale Id 1180784',100360.00,0.00,0.00,193.00,3474.00,'2022-02-17 08:26:51','',''),(2614205,'1','187','939',418,'Retail Sale Id 1180785',1999.20,0.00,0.00,3.57,207.06,'2022-02-17 08:44:30','',''),(2614206,'1','187','939',418,'Retail Sale Id 1180786',26000.00,0.00,0.00,50.00,900.00,'2022-02-17 08:46:40','',''),(2614207,'1','187','939',418,'Retail Sale Id 1180787',5600.00,0.00,0.00,10.00,580.00,'2022-02-17 08:51:39','',''),(2614208,'1','187','939',418,'Retail Sale Id 1180788',26000.00,0.00,0.00,50.00,900.00,'2022-02-17 09:11:32','',''),(2614209,'1','187','939',418,'Retail Sale Id 1180789',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 09:14:24','',''),(2614210,'1','187','939',418,'Retail Sale Id 1180790',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 09:17:09','',''),(2614211,'1','187','939',418,'Retail Sale Id 1180791',104000.00,0.00,0.00,200.00,3600.00,'2022-02-17 09:47:40','',''),(2614212,'1','187','939',418,'Retail Sale Id 1180792',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 09:55:25','',''),(2614213,'1','187','939',418,'Retail Sale Id 1180793',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 10:16:09','',''),(2614214,'1','187','939',418,'Retail Sale Id 1180795',1702.40,0.00,0.00,3.04,176.32,'2022-02-17 10:28:06','',''),(2614215,'1','187','939',418,'Retail Sale Id 1180796',52000.00,0.00,0.00,100.00,1800.00,'2022-02-17 10:29:00','',''),(2614216,'1','187','939',418,'Retail Sale Id 1180797',18200.00,0.00,0.00,35.00,630.00,'2022-02-17 10:34:35','',''),(2614217,'1','187','939',418,'Retail Sale Id 1180798',104000.00,0.00,0.00,200.00,3600.00,'2022-02-17 10:50:34','',''),(2614218,'1','187','939',418,'Retail Sale Id 1180799',2497.60,0.00,0.00,4.46,258.68,'2022-02-17 11:08:20','',''),(2614219,'1','187','939',418,'Retail Sale Id 1180800',26000.00,0.00,0.00,50.00,900.00,'2022-02-17 11:56:55','',''),(2614220,'1','187','939',418,'Retail Sale Id 1180801',26000.00,0.00,0.00,50.00,900.00,'2022-02-17 11:58:51','',''),(2614221,'1','187','939',418,'Retail Sale Id 1180802',100.80,0.00,0.00,0.18,10.44,'2022-02-17 12:00:10','',''),(2614222,'1','187','939',418,'Retail Sale Id 1180803',901.60,0.00,0.00,1.61,93.38,'2022-02-17 12:01:33','',''),(2614223,'1','187','939',418,'Retail Sale Id 1180804',52000.00,0.00,0.00,100.00,1800.00,'2022-02-17 12:03:55','',''),(2614224,'1','187','939',418,'Retail Sale Id 1180805',1120.00,0.00,0.00,2.00,116.00,'2022-02-17 12:40:11','',''),(2614225,'1','187','939',418,'Retail Sale Id 1180806',1120.00,0.00,0.00,2.00,116.00,'2022-02-17 13:09:10','',''),(2614226,'1','187','939',418,'Retail Sale Id 1180807',30160.00,0.00,0.00,58.00,1044.00,'2022-02-17 13:34:29','',''),(2614227,'1','187','939',418,'Retail Sale Id 1180808',29640.00,0.00,0.00,57.00,1026.00,'2022-02-17 13:53:08','',''),(2614228,'1','187','939',418,'Retail Sale Id 1180809',75920.00,0.00,0.00,146.00,2628.00,'2022-02-17 14:08:31','',''),(2614229,'1','187','939',418,'Retail Sale Id 1180810',30160.00,0.00,0.00,58.00,1044.00,'2022-02-17 14:09:54','',''),(2614230,'1','187','939',418,'Return of Retail Sale Id 1180810',0.00,30160.00,58.00,0.00,-1044.00,'2022-02-17 14:28:20','',''),(2614231,'1','187','939',418,'Retail Sale Id 1180811',30160.00,0.00,0.00,58.00,1044.00,'2022-02-17 14:29:40','',''),(2614232,'1','187','939',418,'Retail Sale Id 1180812',1999.20,0.00,0.00,3.57,207.06,'2022-02-17 14:34:20','',''),(2614233,'1','187','939',418,'Retail Sale Id 1180813',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 14:54:02','',''),(2614234,'1','187','939',418,'Retail Sale Id 1180814',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 15:16:02','',''),(2614235,'1','187','939',418,'Retail Sale Id 1180815',1702.40,0.00,0.00,3.04,176.32,'2022-02-17 15:35:04','',''),(2614236,'1','187','939',418,'Retail Sale Id 1180816',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 15:40:28','',''),(2614237,'1','187','939',418,'Retail Sale Id 1180817',26000.00,0.00,0.00,50.00,900.00,'2022-02-17 15:55:44','',''),(2614238,'1','187','939',418,'Retail Sale Id 1180818',1500.80,0.00,0.00,2.68,155.44,'2022-02-17 16:00:11','',''),(2614239,'1','187','939',418,'Retail Sale Id 1180819',1500.80,0.00,0.00,2.68,155.44,'2022-02-17 16:22:57','',''),(2614240,'1','187','939',418,'Retail Sale Id 1180820',78000.00,0.00,0.00,150.00,2700.00,'2022-02-17 17:01:06','',''),(2614241,'1','187','939',418,'Retail Sale Id 1180821',3001.60,0.00,0.00,5.36,310.88,'2022-02-17 17:02:44','',''),(2614242,'1','187','939',418,'Retail Sale Id 1180822',1198.40,0.00,0.00,2.14,124.12,'2022-02-17 17:06:21','',''),(2614243,'1','187','939',418,'Retail Sale Id 1180823',1702.40,0.00,0.00,3.04,176.32,'2022-02-17 17:11:30','',''),(2614244,'1','187','939',418,'Retail Sale Id 1180824',672000.00,0.00,0.00,1200.00,69600.00,'2022-02-17 17:12:49','',''),(2614245,'1','187','939',418,'Return of Retail Sale Id 1180824',0.00,672000.00,1200.00,0.00,-69600.00,'2022-02-17 17:16:40','',''),(2614246,'1','187','939',418,'Retail Sale Id 1180825',1198.40,0.00,0.00,2.14,124.12,'2022-02-17 17:17:05','',''),(2614247,'1','187','939',418,'Retail Sale Id 1180826',26000.00,0.00,0.00,50.00,900.00,'2022-02-17 17:19:54','',''),(2614248,'1','187','939',418,'Return of Retail Sale Id 1180826',0.00,26000.00,50.00,0.00,-900.00,'2022-02-17 17:20:38','',''),(2614249,'1','187','939',418,'Retail Sale Id 1180828',18610.80,0.00,0.00,35.79,644.22,'2022-02-17 17:22:10','',''),(2614250,'1','187','939',418,'Retail Sale Id 1180829',5517.20,0.00,0.00,10.61,190.98,'2022-02-17 17:23:15','',''),(2614251,'1','187','939',418,'Retail Sale Id 1180830',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 17:23:40','',''),(2614252,'1','187','939',418,'Retail Sale Id 1180831',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 17:24:22','',''),(2614253,'1','187','939',418,'Retail Sale Id 1180832',1120.00,0.00,0.00,2.00,116.00,'2022-02-17 17:36:29','',''),(2614254,'1','187','939',418,'Retail Sale Id 1180833',3360.00,0.00,0.00,6.00,348.00,'2022-02-17 17:38:53','',''),(2614255,'1','187','939',418,'Retail Sale Id 1180834',1002.40,0.00,0.00,1.79,103.82,'2022-02-17 17:39:38','',''),(2614256,'1','187','939',418,'Retail Sale Id 1180835',7000.00,0.00,0.00,12.50,725.00,'2022-02-17 17:53:30','',''),(2614257,'1','187','939',418,'Retail Sale Id 1180836',1702.40,0.00,0.00,3.04,176.32,'2022-02-17 17:55:25','',''),(2614258,'1','187','939',418,'Retail Sale Id 1180837',16064.00,0.00,0.00,32.00,0.00,'2022-02-17 18:01:33','',''),(2614259,'1','187','939',418,'Retail Sale Id 1180838',15600.00,0.00,0.00,30.00,540.00,'2022-02-17 18:02:02','',''),(2614260,'1','187','939',418,'Return of Retail Sale Id 1180786',0.00,26000.00,50.00,0.00,-900.00,'2022-02-17 18:03:53','',''),(2614261,'1','187','939',418,'Retail Sale Id 1180839',14040.00,0.00,0.00,27.00,486.00,'2022-02-17 18:04:38','',''),(2614262,'1','187','939',418,'Retail Sale Id 1180841',20800.00,0.00,0.00,40.00,720.00,'2022-02-17 18:06:35','',''),(2614263,'1','187','939',418,'Return of Retail Sale Id 1180841',0.00,20800.00,40.00,0.00,-720.00,'2022-02-17 18:07:17','',''),(2614264,'1','187','939',418,'Retail Sale Id 1180842',8840.00,0.00,0.00,17.00,306.00,'2022-02-17 18:07:49','',''),(2614265,'1','187','939',418,'Retail Sale Id 1180843',11960.00,0.00,0.00,23.00,414.00,'2022-02-17 18:08:15','',''),(2614266,'1','187','939',418,'Retail Sale Id 1180844',8320.00,0.00,0.00,16.00,288.00,'2022-02-17 18:35:51','',''),(2614267,'1','187','939',418,'Return of Retail Sale Id 1180842',0.00,8840.00,17.00,0.00,-306.00,'2022-02-17 18:41:22','',''),(2614268,'1','187','939',418,'Retail Sale Id 1180845',8840.00,0.00,0.00,17.00,306.00,'2022-02-17 18:42:06','',''),(2614269,'1','187','939',418,'Return of Retail Sale Id 1180829',0.00,5517.20,10.61,0.00,-190.98,'2022-02-17 18:44:09','',''),(2614270,'1','187','939',418,'Retail Sale Id 1180846',5538.00,0.00,0.00,10.65,191.70,'2022-02-17 18:46:46','',''),(2614271,'1','187','939',418,'Return of Retail Sale Id 1180846',0.00,5538.00,10.65,0.00,-191.70,'2022-02-17 18:47:29','',''),(2614272,'1','187','939',418,'Retail Sale Id 1180847',5496.40,0.00,0.00,10.57,190.26,'2022-02-17 18:48:18','',''),(2614273,'1','187','939',418,'Return of Retail Sale Id 1180844',0.00,8320.00,16.00,0.00,-288.00,'2022-02-17 18:57:46','',''),(2614274,'1','187','939',418,'Retail Sale Id 1180848',1120.00,0.00,0.00,2.00,116.00,'2022-02-18 08:17:23','',''),(2614275,'1','187','939',418,'Retail Sale Id 1180849',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 08:23:27','',''),(2614276,'1','187','939',418,'Retail Sale Id 1180850',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 08:34:35','',''),(2614277,'1','187','939',418,'Retail Sale Id 1180851',1999.20,0.00,0.00,3.57,207.06,'2022-02-18 08:36:52','',''),(2614278,'1','187','939',418,'Retail Sale Id 1180852',2497.60,0.00,0.00,4.46,258.68,'2022-02-18 08:51:19','',''),(2614279,'1','187','939',418,'Retail Sale Id 1180853',3399.20,0.00,0.00,6.07,352.06,'2022-02-18 09:09:42','',''),(2614280,'1','187','939',418,'Retail Sale Id 1180854',1500.80,0.00,0.00,2.68,155.44,'2022-02-18 09:33:17','',''),(2614281,'1','187','939',418,'Retail Sale Id 1180855',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 09:34:21','',''),(2614282,'1','187','939',418,'Retail Sale Id 1180856',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 09:36:06','',''),(2614283,'1','187','939',418,'Retail Sale Id 1180857',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 09:43:58','',''),(2614284,'1','187','939',418,'Retail Sale Id 1180858',20800.00,0.00,0.00,40.00,720.00,'2022-02-18 10:23:21','',''),(2614285,'1','187','939',418,'Retail Sale Id 1180859',1797.60,0.00,0.00,3.21,186.18,'2022-02-18 10:24:46','',''),(2614286,'1','187','939',418,'Retail Sale Id 1180860',52000.00,0.00,0.00,100.00,1800.00,'2022-02-18 10:25:51','',''),(2614287,'1','187','939',418,'Retail Sale Id 1180861',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 10:27:03','',''),(2614288,'1','187','939',418,'Retail Sale Id 1180862',1500.80,0.00,0.00,2.68,155.44,'2022-02-18 10:37:29','',''),(2614289,'1','187','939',418,'Retail Sale Id 1180863',52000.00,0.00,0.00,100.00,1800.00,'2022-02-18 10:39:51','',''),(2614290,'1','187','939',418,'Retail Sale Id 1180864',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 10:40:39','',''),(2614291,'1','187','939',418,'Retail Sale Id 1180865',1120.00,0.00,0.00,2.00,116.00,'2022-02-18 10:41:31','',''),(2614292,'1','187','939',418,'Retail Sale Id 1180866',5040.00,0.00,0.00,9.00,522.00,'2022-02-18 10:53:59','',''),(2614293,'1','187','939',418,'Retail Sale Id 1180867',3399.20,0.00,0.00,6.07,352.06,'2022-02-18 11:24:33','',''),(2614294,'1','187','939',418,'Retail Sale Id 1180868',52000.00,0.00,0.00,100.00,1800.00,'2022-02-18 11:38:48','',''),(2614295,'1','187','939',418,'Retail Sale Id 1180869',3001.60,0.00,0.00,5.36,310.88,'2022-02-18 11:56:41','',''),(2614296,'1','187','939',418,'Retail Sale Id 1180870',1120.00,0.00,0.00,2.00,116.00,'2022-02-18 12:01:46','',''),(2614297,'1','187','939',418,'Retail Sale Id 1180871',464400.00,0.00,0.00,900.00,12600.00,'2022-02-18 12:18:40','',''),(2614298,'1','187','939',418,'Retail Sale Id 1180872',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 12:19:40','',''),(2614299,'1','187','939',418,'Retail Sale Id 1180873',12480.00,0.00,0.00,24.00,432.00,'2022-02-18 12:26:24','',''),(2614300,'1','187','939',418,'Retail Sale Id 1180874',3399.20,0.00,0.00,6.07,352.06,'2022-02-18 12:36:05','',''),(2614301,'1','187','939',418,'Retail Sale Id 1180875',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 12:39:31','',''),(2614302,'1','187','939',418,'Retail Sale Id 1180876',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 12:49:43','',''),(2614303,'1','187','939',418,'Retail Sale Id 1180877',1198.40,0.00,0.00,2.14,124.12,'2022-02-18 13:23:32','',''),(2614304,'1','187','939',418,'Retail Sale Id 1180878',3001.60,0.00,0.00,5.36,310.88,'2022-02-18 13:41:43','',''),(2614305,'1','187','939',418,'Retail Sale Id 1180879',52000.00,0.00,0.00,100.00,1800.00,'2022-02-18 13:43:31','',''),(2614306,'1','187','939',418,'Retail Sale Id 1180880',52000.00,0.00,0.00,100.00,1800.00,'2022-02-18 13:51:28','',''),(2614307,'1','187','939',418,'Retail Sale Id 1180881',52000.00,0.00,0.00,100.00,1800.00,'2022-02-18 13:54:10','',''),(2614308,'1','187','939',418,'Retail Sale Id 1180882',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 14:51:06','',''),(2614309,'1','187','939',418,'Retail Sale Id 1180883',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 14:52:05','',''),(2614310,'1','187','939',418,'Retail Sale Id 1180884',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 14:53:30','',''),(2614311,'1','187','939',418,'Retail Sale Id 1180885',3998.40,0.00,0.00,7.14,414.12,'2022-02-18 14:57:48','',''),(2614312,'1','187','939',418,'Retail Sale Id 1180886',1500.80,0.00,0.00,2.68,155.44,'2022-02-18 15:06:27','',''),(2614313,'1','187','939',418,'Retail Sale Id 1180887',3399.20,0.00,0.00,6.07,352.06,'2022-02-18 15:07:39','',''),(2614314,'1','187','939',418,'Retail Sale Id 1180888',2800.00,0.00,0.00,5.00,290.00,'2022-02-18 15:19:28','',''),(2614315,'1','187','939',418,'Retail Sale Id 1180889',31200.00,0.00,0.00,60.00,1080.00,'2022-02-18 15:38:05','',''),(2614316,'1','187','939',418,'Retail Sale Id 1180891',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 16:08:11','',''),(2614317,'1','187','939',418,'Retail Sale Id 1180892',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 16:24:41','',''),(2614318,'1','187','939',418,'Retail Sale Id 1180893',1120.00,0.00,0.00,2.00,116.00,'2022-02-18 16:31:45','',''),(2614319,'1','187','939',418,'Retail Sale Id 1180894',1198.40,0.00,0.00,2.14,124.12,'2022-02-18 16:48:03','',''),(2614320,'1','187','939',418,'Retail Sale Id 1180895',3001.60,0.00,0.00,5.36,310.88,'2022-02-18 16:56:58','',''),(2614321,'1','187','939',418,'Retail Sale Id 1180896',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 17:00:23','',''),(2614322,'1','187','939',418,'Retail Sale Id 1180897',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 17:01:52','',''),(2614323,'1','187','939',418,'Retail Sale Id 1180898',1198.40,0.00,0.00,2.14,124.12,'2022-02-18 17:06:12','',''),(2614324,'1','187','939',418,'Retail Sale Id 1180899',1198.40,0.00,0.00,2.14,124.12,'2022-02-18 17:08:25','',''),(2614325,'1','187','939',418,'Retail Sale Id 1180900',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 17:11:13','',''),(2614326,'1','187','939',418,'Retail Sale Id 1180901',3399.20,0.00,0.00,6.07,352.06,'2022-02-18 17:18:04','',''),(2614327,'1','187','939',418,'Retail Sale Id 1180902',1198.40,0.00,0.00,2.14,124.12,'2022-02-18 17:26:42','',''),(2614328,'1','187','939',418,'Retail Sale Id 1180904',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 17:28:35','',''),(2614329,'1','187','939',418,'Retail Sale Id 1180907',2251.20,0.00,0.00,4.02,233.16,'2022-02-18 17:30:54','',''),(2614330,'1','187','939',418,'Retail Sale Id 1180908',800.80,0.00,0.00,1.43,82.94,'2022-02-18 17:32:21','',''),(2614331,'1','187','939',418,'Retail Sale Id 1180909',1999.20,0.00,0.00,3.57,207.06,'2022-02-18 17:33:53','',''),(2614332,'1','187','939',418,'Retail Sale Id 1180911',1999.20,0.00,0.00,3.57,207.06,'2022-02-18 17:35:16','',''),(2614333,'1','187','939',418,'Retail Sale Id 1180912',3399.20,0.00,0.00,6.07,352.06,'2022-02-18 17:38:13','',''),(2614334,'1','187','939',418,'Retail Sale Id 1180913',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 17:39:32','',''),(2614335,'1','187','939',418,'Retail Sale Id 1180914',2497.60,0.00,0.00,4.46,258.68,'2022-02-18 17:41:59','',''),(2614336,'1','187','939',418,'Retail Sale Id 1180915',1002.40,0.00,0.00,1.79,103.82,'2022-02-18 17:47:29','',''),(2614337,'1','187','939',418,'Retail Sale Id 1180916',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 18:01:33','',''),(2614338,'1','187','939',418,'Retail Sale Id 1180917',20800.00,0.00,0.00,40.00,720.00,'2022-02-18 18:02:55','',''),(2614339,'1','187','939',418,'Return of Retail Sale Id 1180916',0.00,26000.00,50.00,0.00,-900.00,'2022-02-18 18:05:04','',''),(2614340,'1','187','939',418,'Return of Retail Sale Id 1180917',0.00,20800.00,40.00,0.00,-720.00,'2022-02-18 18:05:54','',''),(2614341,'1','187','939',418,'Retail Sale Id 1180918',1702.40,0.00,0.00,3.04,176.32,'2022-02-18 18:16:29','',''),(2614342,'1','187','939',418,'Retail Sale Id 1180919',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 18:25:35','',''),(2614343,'1','187','939',418,'Retail Sale Id 1180921',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 18:26:49','',''),(2614344,'1','187','939',418,'Retail Sale Id 1180922',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 18:28:17','',''),(2614345,'1','187','939',418,'Retail Sale Id 1180923',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 18:32:11','',''),(2614346,'1','187','939',418,'Retail Sale Id 1180924',14000.00,0.00,0.00,25.00,1450.00,'2022-02-18 18:34:58','',''),(2614347,'1','187','939',418,'Return of Retail Sale Id 1180856',0.00,26000.00,50.00,0.00,-900.00,'2022-02-18 18:45:20','',''),(2614348,'1','187','939',418,'Retail Sale Id 1180925',6531.20,0.00,0.00,12.56,226.08,'2022-02-18 18:46:28','',''),(2614349,'1','187','939',418,'Retail Sale Id 1180926',30862.00,0.00,0.00,59.35,1068.30,'2022-02-18 18:48:05','',''),(2614350,'1','187','939',418,'Retail Sale Id 1180927',5517.20,0.00,0.00,10.61,190.98,'2022-02-18 18:55:17','',''),(2614351,'1','187','939',418,'Retail Sale Id 1180928',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 19:05:52','',''),(2614352,'1','187','939',418,'Retail Sale Id 1180929',26000.00,0.00,0.00,50.00,900.00,'2022-02-18 19:06:43','',''),(2614353,'1','187','939',418,'Return of Retail Sale Id 1180929',0.00,26000.00,50.00,0.00,-900.00,'2022-02-18 19:09:39','',''),(2614354,'1','187','939',418,'Retail Sale Id 1180930',15600.00,0.00,0.00,30.00,540.00,'2022-02-18 19:11:51','',''),(2614355,'1','187','939',418,'Retail Sale Id 1180931',1702.40,0.00,0.00,3.04,176.32,'2022-02-19 08:06:22','',''),(2614356,'1','187','939',418,'Retail Sale Id 1180932',3500.00,0.00,0.00,6.25,362.50,'2022-02-19 08:08:59','',''),(2614357,'1','187','939',418,'Retail Sale Id 1180933',2800.00,0.00,0.00,5.00,290.00,'2022-02-19 08:10:09','',''),(2614358,'1','187','939',418,'Retail Sale Id 1180934',1702.40,0.00,0.00,3.04,176.32,'2022-02-19 08:14:52','',''),(2614359,'1','187','939',418,'Retail Sale Id 1180935',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 08:19:57','',''),(2614360,'1','187','939',418,'Retail Sale Id 1180936',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 08:32:03','',''),(2614361,'1','187','939',418,'Retail Sale Id 1180937',53560.00,0.00,0.00,103.00,1854.00,'2022-02-19 08:42:16','',''),(2614362,'1','187','939',418,'Retail Sale Id 1180938',1198.40,0.00,0.00,2.14,124.12,'2022-02-19 08:42:50','',''),(2614363,'1','187','939',418,'Retail Sale Id 1180939',1797.60,0.00,0.00,3.21,186.18,'2022-02-19 08:47:51','',''),(2614364,'1','187','939',418,'Retail Sale Id 1180940',1999.20,0.00,0.00,3.57,207.06,'2022-02-19 08:48:46','',''),(2614365,'1','187','939',418,'Retail Sale Id 1180941',2800.00,0.00,0.00,5.00,290.00,'2022-02-19 08:49:56','',''),(2614366,'1','187','939',418,'Retail Sale Id 1180942',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 09:03:15','',''),(2614367,'1','187','939',418,'Retail Sale Id 1180943',26000.00,0.00,0.00,50.00,900.00,'2022-02-19 09:04:57','',''),(2614368,'1','187','939',418,'Retail Sale Id 1180944',26000.00,0.00,0.00,50.00,900.00,'2022-02-19 09:06:09','',''),(2614369,'1','187','939',418,'Retail Sale Id 1180945',5040.00,0.00,0.00,9.00,522.00,'2022-02-19 09:07:09','',''),(2614370,'1','187','939',418,'Retail Sale Id 1180946',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 09:14:01','',''),(2614371,'1','187','939',418,'Retail Sale Id 1180947',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 09:14:56','',''),(2614372,'1','187','939',418,'Retail Sale Id 1180948',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 09:31:36','',''),(2614373,'1','187','939',418,'Retail Sale Id 1180949',3399.20,0.00,0.00,6.07,352.06,'2022-02-19 09:35:44','',''),(2614374,'1','187','939',418,'Retail Sale Id 1180951',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 10:37:19','',''),(2614375,'1','187','939',418,'Retail Sale Id 1180952',1702.40,0.00,0.00,3.04,176.32,'2022-02-19 10:39:25','',''),(2614376,'1','187','939',418,'Retail Sale Id 1180953',1999.20,0.00,0.00,3.57,207.06,'2022-02-19 10:45:05','',''),(2614377,'1','187','939',418,'Retail Sale Id 1180954',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 12:05:36','',''),(2614378,'1','187','939',418,'Retail Sale Id 1180955',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 12:07:36','',''),(2614379,'1','187','939',418,'Retail Sale Id 1180956',26000.00,0.00,0.00,50.00,900.00,'2022-02-19 12:08:20','',''),(2614380,'1','187','939',418,'Retail Sale Id 1180957',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 12:12:54','',''),(2614381,'1','187','939',418,'Retail Sale Id 1180958',1500.80,0.00,0.00,2.68,155.44,'2022-02-19 12:19:25','',''),(2614382,'1','187','939',418,'Retail Sale Id 1180959',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 13:09:54','',''),(2614383,'1','187','939',418,'Retail Sale Id 1180960',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 13:11:55','',''),(2614384,'1','187','939',418,'Retail Sale Id 1180961',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 13:13:21','',''),(2614385,'1','187','939',418,'Retail Sale Id 1180962',6199.20,0.00,0.00,11.07,642.06,'2022-02-19 13:15:50','',''),(2614386,'1','187','939',418,'Retail Sale Id 1180963',700.00,0.00,0.00,1.25,72.50,'2022-02-19 13:32:48','',''),(2614387,'1','187','939',418,'Retail Sale Id 1180964',3399.20,0.00,0.00,6.07,352.06,'2022-02-19 13:41:19','',''),(2614388,'1','187','939',418,'Retail Sale Id 1180965',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 13:55:46','',''),(2614389,'1','187','939',418,'Retail Sale Id 1180966',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 13:57:19','',''),(2614390,'1','187','939',418,'Retail Sale Id 1180967',3701.60,0.00,0.00,6.61,383.38,'2022-02-19 13:59:01','',''),(2614391,'1','187','939',418,'Retail Sale Id 1180968',1120.00,0.00,0.00,2.00,116.00,'2022-02-19 14:02:17','',''),(2614392,'1','187','939',418,'Retail Sale Id 1180969',1680.00,0.00,0.00,3.00,174.00,'2022-02-19 14:25:51','',''),(2614393,'1','187','939',418,'Retail Sale Id 1180970',20800.00,0.00,0.00,40.00,720.00,'2022-02-19 14:46:45','',''),(2614394,'1','187','939',418,'Retail Sale Id 1180971',1680.00,0.00,0.00,3.00,174.00,'2022-02-19 14:52:09','',''),(2614395,'1','187','939',418,'Retail Sale Id 1180972',498.40,0.00,0.00,0.89,51.62,'2022-02-19 15:10:11','',''),(2614396,'1','187','939',418,'Retail Sale Id 1180973',498.40,0.00,0.00,0.89,51.62,'2022-02-19 15:11:37','',''),(2614397,'1','187','939',418,'Retail Sale Id 1180974',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 15:15:41','',''),(2614398,'1','187','939',418,'Retail Sale Id 1180976',1999.20,0.00,0.00,3.57,207.06,'2022-02-19 15:17:53','',''),(2614399,'1','187','939',418,'Retail Sale Id 1180977',26000.00,0.00,0.00,50.00,900.00,'2022-02-19 15:44:06','',''),(2614400,'1','187','939',418,'Retail Sale Id 1180978',1999.20,0.00,0.00,3.57,207.06,'2022-02-19 16:15:18','',''),(2614401,'1','187','939',418,'Retail Sale Id 1180979',1999.20,0.00,0.00,3.57,207.06,'2022-02-19 16:16:30','',''),(2614402,'1','187','939',418,'Retail Sale Id 1180980',1120.00,0.00,0.00,2.00,116.00,'2022-02-19 16:22:55','',''),(2614403,'1','187','939',418,'Retail Sale Id 1180981',1198.40,0.00,0.00,2.14,124.12,'2022-02-19 16:24:13','',''),(2614404,'1','187','939',418,'Retail Sale Id 1180983',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 16:37:16','',''),(2614405,'1','187','939',418,'Retail Sale Id 1180984',52000.00,0.00,0.00,100.00,1800.00,'2022-02-19 16:42:13','',''),(2614406,'1','187','939',418,'Retail Sale Id 1180985',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 16:45:08','',''),(2614407,'1','187','939',418,'Retail Sale Id 1180986',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 16:50:59','',''),(2614408,'1','187','939',418,'Retail Sale Id 1180987',901.60,0.00,0.00,1.61,93.38,'2022-02-19 16:52:12','',''),(2614409,'1','187','939',418,'Retail Sale Id 1180988',78000.00,0.00,0.00,150.00,2700.00,'2022-02-19 16:54:34','',''),(2614410,'1','187','939',418,'Retail Sale Id 1180989',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 17:04:08','',''),(2614411,'1','187','939',418,'Retail Sale Id 1180990',3399.20,0.00,0.00,6.07,352.06,'2022-02-19 17:10:50','',''),(2614412,'1','187','939',418,'Retail Sale Id 1180991',1198.40,0.00,0.00,2.14,124.12,'2022-02-19 17:13:17','',''),(2614413,'1','187','939',418,'Retail Sale Id 1180992',1500.80,0.00,0.00,2.68,155.44,'2022-02-19 17:18:22','',''),(2614414,'1','187','939',418,'Retail Sale Id 1180993',599.20,0.00,0.00,1.07,62.06,'2022-02-19 17:43:22','',''),(2614415,'1','187','939',418,'Retail Sale Id 1180994',26000.00,0.00,0.00,50.00,900.00,'2022-02-19 17:44:56','',''),(2614416,'1','187','939',418,'Retail Sale Id 1180995',3360.00,0.00,0.00,6.00,348.00,'2022-02-19 17:51:39','',''),(2614417,'1','187','939',418,'Retail Sale Id 1180996',3399.20,0.00,0.00,6.07,352.06,'2022-02-19 17:58:31','',''),(2614418,'1','187','939',418,'Retail Sale Id 1180997',1999.20,0.00,0.00,3.57,207.06,'2022-02-19 18:05:08','',''),(2614419,'1','187','939',418,'Retail Sale Id 1180998',10001.60,0.00,0.00,17.86,1035.88,'2022-02-19 18:06:57','',''),(2614420,'1','187','939',418,'Return of Retail Sale Id 1180998',0.00,10001.60,17.86,0.00,-1035.88,'2022-02-19 18:17:16','',''),(2614421,'1','187','939',418,'Retail Sale Id 1180999',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 18:20:31','',''),(2614422,'1','187','939',418,'Retail Sale Id 1181000',1002.40,0.00,0.00,1.79,103.82,'2022-02-19 18:28:45','',''),(2614423,'1','187','939',418,'Retail Sale Id 1181001',6888.00,0.00,0.00,12.30,713.40,'2022-02-19 19:15:53','',''),(2614424,'1','187','939',418,'Retail Sale Id 1181002',81702.40,0.00,0.00,157.12,2828.16,'2022-02-19 19:17:33','',''),(2614425,'1','187','939',418,'Retail Sale Id 1181003',9443.20,0.00,0.00,18.16,326.88,'2022-02-19 19:19:07','',''),(2614426,'1','187','939',418,'Retail Sale Id 1181004',183008.80,0.00,0.00,351.94,6334.92,'2022-02-19 19:20:57','',''),(2614427,'1','187','939',418,'Retail Sale Id 1181005',3399.20,0.00,0.00,6.07,352.06,'2022-02-20 10:34:50','',''),(2614428,'1','187','939',418,'Retail Sale Id 1181006',26000.00,0.00,0.00,50.00,900.00,'2022-02-20 10:53:36','',''),(2614429,'1','187','939',418,'Retail Sale Id 1181007',1702.40,0.00,0.00,3.04,176.32,'2022-02-20 10:55:30','',''),(2614430,'1','187','939',418,'Retail Sale Id 1181008',1002.40,0.00,0.00,1.79,103.82,'2022-02-20 10:56:48','',''),(2614431,'1','187','939',418,'Retail Sale Id 1181009',1999.20,0.00,0.00,3.57,207.06,'2022-02-20 10:58:02','',''),(2614432,'1','187','939',418,'Retail Sale Id 1181010',1500.80,0.00,0.00,2.68,155.44,'2022-02-20 11:05:47','',''),(2614433,'1','187','939',418,'Retail Sale Id 1181011',26000.00,0.00,0.00,50.00,900.00,'2022-02-20 11:20:33','',''),(2614434,'1','187','939',418,'Retail Sale Id 1181012',52000.00,0.00,0.00,100.00,1800.00,'2022-02-20 11:39:26','',''),(2614435,'1','187','939',418,'Retail Sale Id 1181013',1002.40,0.00,0.00,1.79,103.82,'2022-02-20 11:43:46','',''),(2614436,'1','187','939',418,'Retail Sale Id 1181014',1002.40,0.00,0.00,1.79,103.82,'2022-02-20 11:53:03','',''),(2614437,'1','187','939',418,'Retail Sale Id 1181015',52000.00,0.00,0.00,100.00,1800.00,'2022-02-20 12:19:26','',''),(2614438,'1','187','939',418,'Retail Sale Id 1181016',26000.00,0.00,0.00,50.00,900.00,'2022-02-20 12:20:23','',''),(2614439,'1','187','939',418,'Retail Sale Id 1181017',4480.00,0.00,0.00,8.00,464.00,'2022-02-20 12:31:20','',''),(2614440,'1','187','939',418,'Retail Sale Id 1181018',20800.00,0.00,0.00,40.00,720.00,'2022-02-20 12:32:58','',''),(2614441,'1','187','939',418,'Retail Sale Id 1181019',85800.00,0.00,0.00,165.00,2970.00,'2022-02-20 12:54:52','',''),(2614442,'1','187','939',418,'Retail Sale Id 1181020',1702.40,0.00,0.00,3.04,176.32,'2022-02-20 13:09:40','',''),(2614443,'1','187','939',418,'Retail Sale Id 1181021',1999.20,0.00,0.00,3.57,207.06,'2022-02-20 13:13:22','',''),(2614444,'1','187','939',418,'Retail Sale Id 1181022',13000.00,0.00,0.00,25.00,450.00,'2022-02-20 13:15:50','',''),(2614445,'1','187','939',418,'Retail Sale Id 1181023',3399.20,0.00,0.00,6.07,352.06,'2022-02-20 13:40:18','',''),(2614446,'1','187','939',418,'Retail Sale Id 1181024',3500.00,0.00,0.00,6.25,362.50,'2022-02-20 14:05:52','',''),(2614447,'1','187','939',418,'Retail Sale Id 1181025',1999.20,0.00,0.00,3.57,207.06,'2022-02-20 14:11:46','',''),(2614448,'1','187','939',418,'Retail Sale Id 1181026',1002.40,0.00,0.00,1.79,103.82,'2022-02-20 14:22:41','',''),(2614449,'1','187','939',418,'Retail Sale Id 1181027',6798.40,0.00,0.00,12.14,704.12,'2022-02-20 14:39:02','',''),(2614450,'1','187','939',418,'Retail Sale Id 1181028',1702.40,0.00,0.00,3.04,176.32,'2022-02-20 14:40:31','',''),(2614451,'1','187','939',418,'Retail Sale Id 1181029',57200.00,0.00,0.00,110.00,1980.00,'2022-02-20 14:44:48','',''),(2614452,'1','187','939',418,'Retail Sale Id 1181030',26000.00,0.00,0.00,50.00,900.00,'2022-02-20 14:49:16','',''),(2614453,'1','187','939',418,'Retail Sale Id 1181031',5101.60,0.00,0.00,9.11,528.38,'2022-02-20 14:54:32','',''),(2614454,'1','187','939',418,'Retail Sale Id 1181032',2301.60,0.00,0.00,4.11,238.38,'2022-02-20 15:09:26','',''),(2614455,'1','187','939',418,'Retail Sale Id 1181033',1999.20,0.00,0.00,3.57,207.06,'2022-02-20 15:35:36','',''),(2614456,'1','187','939',418,'Retail Sale Id 1181034',17160.00,0.00,0.00,33.00,594.00,'2022-02-20 15:36:30','',''),(2614457,'1','187','939',418,'Retail Sale Id 1181035',1002.40,0.00,0.00,1.79,103.82,'2022-02-20 15:49:34','',''),(2614458,'1','187','939',418,'Retail Sale Id 1181036',1702.40,0.00,0.00,3.04,176.32,'2022-02-20 15:56:03','',''),(2614459,'1','187','939',418,'Retail Sale Id 1181037',11306.40,0.00,0.00,20.19,1171.02,'2022-02-20 16:15:52','',''),(2614460,'1','187','939',418,'Return of Retail Sale Id 1181029',0.00,57200.00,110.00,0.00,-1980.00,'2022-02-20 16:17:23','',''),(2614461,'1','187','939',418,'Retail Sale Id 1181038',1702.40,0.00,0.00,3.04,176.32,'2022-02-20 16:19:12','',''),(2614462,'1','187','939',418,'Retail Sale Id 1181039',2497.60,0.00,0.00,4.46,258.68,'2022-02-20 16:21:09','',''),(2614463,'1','187','939',418,'Retail Sale Id 1181040',3399.20,0.00,0.00,6.07,352.06,'2022-02-20 16:27:23','',''),(2614464,'1','187','939',418,'Retail Sale Id 1181041',56882.80,0.00,0.00,109.39,1969.02,'2022-02-20 16:31:29','',''),(2614465,'1','187','939',418,'Retail Sale Id 1181042',1999.20,0.00,0.00,3.57,207.06,'2022-02-21 08:25:38','',''),(2614466,'1','187','939',418,'Retail Sale Id 1181043',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 08:28:29','',''),(2614467,'1','187','939',418,'Retail Sale Id 1181044',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 08:33:45','',''),(2614468,'1','187','939',418,'Retail Sale Id 1181045',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 08:48:39','',''),(2614469,'1','187','939',418,'Retail Sale Id 1181046',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 08:49:53','',''),(2614470,'1','187','939',418,'Retail Sale Id 1181047',5600.00,0.00,0.00,10.00,580.00,'2022-02-21 08:54:54','',''),(2614471,'1','187','939',418,'Retail Sale Id 1181048',2301.60,0.00,0.00,4.11,238.38,'2022-02-21 08:56:42','',''),(2614472,'1','187','939',418,'Retail Sale Id 1181049',3998.40,0.00,0.00,7.14,414.12,'2022-02-21 08:57:52','',''),(2614473,'1','187','939',418,'Retail Sale Id 1181050',2800.00,0.00,0.00,5.00,290.00,'2022-02-21 09:16:34','',''),(2614474,'1','187','939',418,'Retail Sale Id 1181051',52000.00,0.00,0.00,100.00,1800.00,'2022-02-21 09:22:45','',''),(2614475,'1','187','939',418,'Retail Sale Id 1181052',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 09:46:59','',''),(2614476,'1','187','939',418,'Retail Sale Id 1181053',1097.60,0.00,0.00,1.96,113.68,'2022-02-21 09:48:21','',''),(2614477,'1','187','939',418,'Retail Sale Id 1181054',5600.00,0.00,0.00,10.00,580.00,'2022-02-21 09:49:50','',''),(2614478,'1','187','939',418,'Retail Sale Id 1181055',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 09:58:39','',''),(2614479,'1','187','939',418,'Retail Sale Id 1181056',52000.00,0.00,0.00,100.00,1800.00,'2022-02-21 10:00:03','',''),(2614480,'1','187','939',418,'Retail Sale Id 1181057',52000.00,0.00,0.00,100.00,1800.00,'2022-02-21 10:01:25','',''),(2614481,'1','187','939',418,'Retail Sale Id 1181058',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 10:11:09','',''),(2614482,'1','187','939',418,'Retail Sale Id 1181059',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 10:12:50','',''),(2614483,'1','187','939',418,'Retail Sale Id 1181060',58240.00,0.00,0.00,112.00,2016.00,'2022-02-21 10:14:03','',''),(2614484,'1','187','939',418,'Retail Sale Id 1181061',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 10:19:01','',''),(2614485,'1','187','939',418,'Retail Sale Id 1181062',52000.00,0.00,0.00,100.00,1800.00,'2022-02-21 10:20:52','',''),(2614486,'1','187','939',418,'Retail Sale Id 1181063',52000.00,0.00,0.00,100.00,1800.00,'2022-02-21 10:25:44','',''),(2614487,'1','187','939',418,'Retail Sale Id 1181064',28600.00,0.00,0.00,55.00,990.00,'2022-02-21 10:28:26','',''),(2614488,'1','187','939',418,'Retail Sale Id 1181065',26000.00,0.00,0.00,50.00,900.00,'2022-02-21 10:30:02','',''),(2614489,'1','187','939',418,'Retail Sale Id 1181066',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 10:38:13','',''),(2614490,'1','187','939',418,'Retail Sale Id 1181067',26000.00,0.00,0.00,50.00,900.00,'2022-02-21 10:44:06','',''),(2614491,'1','187','939',418,'Retail Sale Id 1181068',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 10:47:49','',''),(2614492,'1','187','939',418,'Retail Sale Id 1181069',1400.00,0.00,0.00,2.50,145.00,'2022-02-21 10:49:06','',''),(2614493,'1','187','939',418,'Retail Sale Id 1181070',302.40,0.00,0.00,0.54,31.32,'2022-02-21 10:49:55','',''),(2614494,'1','187','939',418,'Retail Sale Id 1181071',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 11:02:08','',''),(2614495,'1','187','939',418,'Retail Sale Id 1181072',26000.00,0.00,0.00,50.00,900.00,'2022-02-21 11:06:01','',''),(2614496,'1','187','939',418,'Retail Sale Id 1181073',52000.00,0.00,0.00,100.00,1800.00,'2022-02-21 11:08:57','',''),(2614497,'1','187','939',418,'Retail Sale Id 1181074',26000.00,0.00,0.00,50.00,900.00,'2022-02-21 11:25:08','',''),(2614498,'1','187','939',418,'Retail Sale Id 1181075',84000.00,0.00,0.00,150.00,8700.00,'2022-02-21 11:34:31','',''),(2614499,'1','187','939',418,'Retail Sale Id 1181076',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 11:37:01','',''),(2614500,'1','187','939',418,'Retail Sale Id 1181077',1999.20,0.00,0.00,3.57,207.06,'2022-02-21 12:08:56','',''),(2614501,'1','187','939',418,'Retail Sale Id 1181078',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 12:10:11','',''),(2614502,'1','187','939',418,'Retail Sale Id 1181079',31200.00,0.00,0.00,60.00,1080.00,'2022-02-21 12:14:24','',''),(2614503,'1','187','939',418,'Retail Sale Id 1181080',1120.00,0.00,0.00,2.00,116.00,'2022-02-21 12:38:12','',''),(2614504,'1','187','939',418,'Retail Sale Id 1181081',1198.40,0.00,0.00,2.14,124.12,'2022-02-21 12:58:52','',''),(2614505,'1','187','939',418,'Retail Sale Id 1181082',3399.20,0.00,0.00,6.07,352.06,'2022-02-21 13:23:02','',''),(2614506,'1','187','939',418,'Retail Sale Id 1181083',1500.80,0.00,0.00,2.68,155.44,'2022-02-21 13:31:08','',''),(2614507,'1','187','939',418,'Retail Sale Id 1181084',3500.00,0.00,0.00,6.25,362.50,'2022-02-21 13:39:09','',''),(2614508,'1','187','939',418,'Retail Sale Id 1181085',1999.20,0.00,0.00,3.57,207.06,'2022-02-21 13:39:52','',''),(2614509,'1','187','939',418,'Retail Sale Id 1181086',2497.60,0.00,0.00,4.46,258.68,'2022-02-21 13:43:39','',''),(2614510,'1','187','939',418,'Retail Sale Id 1181087',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 14:14:49','',''),(2614511,'1','187','939',418,'Retail Sale Id 1181088',1198.40,0.00,0.00,2.14,124.12,'2022-02-21 14:25:37','',''),(2614512,'1','187','939',418,'Retail Sale Id 1181089',1198.40,0.00,0.00,2.14,124.12,'2022-02-21 14:26:49','',''),(2614513,'1','187','939',418,'Retail Sale Id 1181090',2800.00,0.00,0.00,5.00,290.00,'2022-02-21 14:42:41','',''),(2614514,'1','187','939',418,'Retail Sale Id 1181092',1120.00,0.00,0.00,2.00,116.00,'2022-02-21 14:48:38','',''),(2614515,'1','187','939',418,'Retail Sale Id 1181093',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 14:54:45','',''),(2614516,'1','187','939',418,'Retail Sale Id 1181094',1198.40,0.00,0.00,2.14,124.12,'2022-02-21 15:07:34','',''),(2614517,'1','187','939',418,'Retail Sale Id 1181095',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 15:08:57','',''),(2614518,'1','187','939',418,'Retail Sale Id 1181097',1120.00,0.00,0.00,2.00,116.00,'2022-02-21 15:22:15','',''),(2614519,'1','187','939',418,'Retail Sale Id 1181098',1198.40,0.00,0.00,2.14,124.12,'2022-02-21 15:40:36','',''),(2614520,'1','187','939',418,'Retail Sale Id 1181099',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 15:42:17','',''),(2614521,'1','187','939',418,'Retail Sale Id 1181100',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 16:39:16','',''),(2614522,'1','187','939',418,'Retail Sale Id 1181101',3399.20,0.00,0.00,6.07,352.06,'2022-02-21 16:41:04','',''),(2614523,'1','187','939',418,'Retail Sale Id 1181102',1002.40,0.00,0.00,1.79,103.82,'2022-02-21 16:43:57','',''),(2614524,'1','187','939',418,'Retail Sale Id 1181103',1198.40,0.00,0.00,2.14,124.12,'2022-02-21 16:53:31','',''),(2614525,'1','187','939',418,'Return of Retail Sale Id 1181063',0.00,52000.00,100.00,0.00,-1800.00,'2022-02-21 16:57:06','',''),(2614526,'1','187','939',418,'Return of Retail Sale Id 1181067',0.00,26000.00,50.00,0.00,-900.00,'2022-02-21 16:58:12','',''),(2614527,'1','187','939',418,'Retail Sale Id 1181104',518580.00,0.00,0.00,1005.00,14070.00,'2022-02-21 16:59:52','',''),(2614528,'1','187','939',418,'Retail Sale Id 1181105',2028.00,0.00,0.00,3.90,70.20,'2022-02-21 17:00:21','',''),(2614529,'1','187','939',418,'Retail Sale Id 1181106',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 17:01:00','',''),(2614530,'1','187','939',418,'Retail Sale Id 1181107',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 17:02:52','',''),(2614531,'1','187','939',418,'Retail Sale Id 1181108',1702.40,0.00,0.00,3.04,176.32,'2022-02-21 17:08:45','',''),(2614532,'1','187','939',418,'Retail Sale Id 1181110',7280.00,0.00,0.00,13.00,754.00,'2022-02-21 17:09:42','',''),(2614533,'1','187','939',418,'Retail Sale Id 1181111',3399.20,0.00,0.00,6.07,352.06,'2022-02-21 17:12:00','',''),(2614534,'1','187','939',418,'Retail Sale Id 1181112',3001.60,0.00,0.00,5.36,310.88,'2022-02-21 17:19:39','',''),(2614535,'1','187','939',418,'Retail Sale Id 1181113',3399.20,0.00,0.00,6.07,352.06,'2022-02-21 17:30:13','',''),(2614536,'1','187','939',418,'Retail Sale Id 1181116',26000.00,0.00,0.00,50.00,900.00,'2022-02-21 17:36:02','',''),(2614537,'1','187','939',418,'Retail Sale Id 1181117',1999.20,0.00,0.00,3.57,207.06,'2022-02-21 17:36:56','',''),(2614538,'1','187','939',418,'Retail Sale Id 1181118',1999.20,0.00,0.00,3.57,207.06,'2022-02-21 17:46:36','',''),(2614539,'1','187','939',418,'Retail Sale Id 1181119',3399.20,0.00,0.00,6.07,352.06,'2022-02-21 17:56:04','',''),(2614540,'1','187','939',418,'Retail Sale Id 1181120',2200.80,0.00,0.00,3.93,227.94,'2022-02-21 18:04:44','',''),(2614541,'1','187','939',418,'Retail Sale Id 1181121',31278.00,0.00,0.00,60.15,1082.70,'2022-02-21 18:17:06','',''),(2614542,'1','187','939',418,'Retail Sale Id 1181122',91000.00,0.00,0.00,175.00,3150.00,'2022-02-21 18:20:37','',''),(2614543,'1','187','939',418,'Retail Sale Id 1181123',1993.60,0.00,0.00,3.56,206.48,'2022-02-21 18:27:10','',''),(2614544,'1','187','939',418,'Return of Retail Sale Id 1181075',0.00,84000.00,150.00,0.00,-8700.00,'2022-02-21 18:56:59','',''),(2614545,'1','187','939',418,'Retail Sale Id 1181124',78000.00,0.00,0.00,150.00,2700.00,'2022-02-21 18:57:55','',''),(2614546,'1','187','939',418,'Retail Sale Id 1181125',52000.00,0.00,0.00,100.00,1800.00,'2022-02-22 08:31:07','',''),(2614547,'1','187','939',418,'Retail Sale Id 1181126',1002.40,0.00,0.00,1.79,103.82,'2022-02-22 08:32:31','',''),(2614548,'1','187','939',418,'Return of Retail Sale Id 1181125',0.00,52000.00,100.00,0.00,-1800.00,'2022-02-22 08:33:40','',''),(2614549,'1','187','939',418,'Return of Retail Sale Id 1181126',0.00,1002.40,1.79,0.00,-103.82,'2022-02-22 08:34:04','',''),(2614550,'1','187','939',418,'Retail Sale Id 1181127',2240.00,0.00,0.00,4.00,232.00,'2022-02-22 08:35:53','',''),(2614551,'1','187','939',418,'Retail Sale Id 1181128',1002.40,0.00,0.00,1.79,103.82,'2022-02-22 08:37:10','',''),(2614552,'1','187','939',418,'Retail Sale Id 1181129',52000.00,0.00,0.00,100.00,1800.00,'2022-02-22 08:37:45','',''),(2614553,'1','187','939',418,'Retail Sale Id 1181130',78000.00,0.00,0.00,150.00,2700.00,'2022-02-22 08:41:48','',''),(2614554,'1','187','939',418,'Retail Sale Id 1181131',1702.40,0.00,0.00,3.04,176.32,'2022-02-22 09:03:40','',''),(2614555,'1','187','939',418,'Retail Sale Id 1181132',104000.00,0.00,0.00,200.00,3600.00,'2022-02-22 09:27:36','',''),(2614556,'1','187','939',418,'Retail Sale Id 1181133',78000.00,0.00,0.00,150.00,2700.00,'2022-02-22 09:28:38','',''),(2614557,'1','187','939',418,'Retail Sale Id 1181134',52000.00,0.00,0.00,100.00,1800.00,'2022-02-22 09:29:30','',''),(2614558,'1','187','939',418,'Return of Retail Sale Id 1181133',0.00,78000.00,150.00,0.00,-2700.00,'2022-02-22 09:38:18','',''),(2614559,'1','187','939',418,'Return of Retail Sale Id 1181132',0.00,104000.00,200.00,0.00,-3600.00,'2022-02-22 09:38:44','',''),(2614560,'1','187','939',418,'Retail Sale Id 1181135',52000.00,0.00,0.00,100.00,1800.00,'2022-02-22 09:39:35','',''),(2614561,'1','187','939',418,'Retail Sale Id 1181136',1002.40,0.00,0.00,1.79,103.82,'2022-02-22 09:41:16','',''),(2614562,'1','187','939',418,'Retail Sale Id 1181137',1702.40,0.00,0.00,3.04,176.32,'2022-02-22 09:43:13','',''),(2614563,'1','187','939',418,'Retail Sale Id 1181138',52000.00,0.00,0.00,100.00,1800.00,'2022-02-22 09:48:13','',''),(2614564,'1','187','939',418,'Retail Sale Id 1181139',20800.00,0.00,0.00,40.00,720.00,'2022-02-22 10:25:03','',''),(2614565,'1','187','939',418,'Return of Retail Sale Id 1181139',0.00,20800.00,40.00,0.00,-720.00,'2022-02-22 11:31:57','',''),(2614566,'1','187','939',418,'Retail Sale Id 1181140',14404.00,0.00,0.00,27.70,498.60,'2022-02-22 11:32:51','',''),(2614567,'1','187','939',418,'Return of Retail Sale Id 1181140',0.00,14404.00,27.70,0.00,-498.60,'2022-02-22 11:34:02','',''),(2614568,'1','187','939',418,'Retail Sale Id 1181141',14414.40,0.00,0.00,27.72,498.96,'2022-02-22 11:36:51','',''),(2614569,'1','187','939',418,'Return of Retail Sale Id 1181141',0.00,14414.40,27.72,0.00,-498.96,'2022-02-22 11:55:48','',''),(2614570,'1','187','939',418,'Retail Sale Id 1181142',14185.60,0.00,0.00,27.28,491.04,'2022-02-22 11:56:36','',''),(2614571,'1','187','939',418,'Return of Retail Sale Id 1181130',0.00,78000.00,150.00,0.00,-2700.00,'2022-02-22 11:57:16','',''),(2614572,'1','187','939',418,'Retail Sale Id 1181143',78150.80,0.00,0.00,150.29,2705.22,'2022-02-22 11:58:03','',''),(2614573,'1','187','939',418,'Return of Retail Sale Id 1181136',0.00,1002.40,1.79,0.00,-103.82,'2022-02-22 12:04:13','',''),(2614574,'1','187','939',418,'Retail Sale Id 1181144',940.80,0.00,0.00,1.68,97.44,'2022-02-22 12:05:22','',''),(2614575,'1','187','939',418,'Distributed to OPERATIONAL LOSS for sales id:332539',668598.74,0.00,0.00,1331.87,0.00,'2022-02-23 09:31:46','',''),(2614576,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,12628880.00,24860.00,0.00,0.00,'2022-02-23 11:54:56','',''),(2614577,'1','187',NULL,418,'Reception corrector for bridging 123744',0.00,0.00,0.00,24860.00,0.00,'2022-02-23 12:01:46','',''),(2614578,'1','187','939',418,'Received from bridging 123744',0.00,0.00,24860.00,0.00,0.00,'2022-02-23 12:01:46','',''),(2614579,'1','187','939',418,'Retail Sale Id 1181145',7000.00,0.00,0.00,12.50,650.00,'2022-02-23 12:04:10','',''),(2614580,'1','187','939',418,'Retail Sale Id 1181146',78900.00,0.00,0.00,150.00,2700.00,'2022-02-23 12:07:00','',''),(2614581,'1','187','939',418,'Retail Sale Id 1181148',78900.00,0.00,0.00,150.00,2700.00,'2022-02-23 12:10:23','',''),(2614582,'1','187','939',418,'Retail Sale Id 1181149',78900.00,0.00,0.00,150.00,2700.00,'2022-02-23 12:11:47','',''),(2614583,'1','187','939',418,'Retail Sale Id 1181150',105200.00,0.00,0.00,200.00,3600.00,'2022-02-23 12:13:17','',''),(2614584,'1','187','939',418,'Retail Sale Id 1181151',52600.00,0.00,0.00,100.00,1800.00,'2022-02-23 12:16:02','',''),(2614585,'1','187','939',418,'Retail Sale Id 1181152',2251.20,0.00,0.00,4.02,209.04,'2022-02-23 12:19:44','',''),(2614586,'1','187','939',418,'Retail Sale Id 1181153',64435.00,0.00,0.00,122.50,2205.00,'2022-02-23 12:26:10','',''),(2614587,'1','187','939',418,'Retail Sale Id 1181154',26300.00,0.00,0.00,50.00,900.00,'2022-02-23 12:37:10','',''),(2614588,'1','187','939',418,'Retail Sale Id 1181155',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 12:40:02','',''),(2614589,'1','187','939',418,'Retail Sale Id 1181156',52600.00,0.00,0.00,100.00,1800.00,'2022-02-23 12:49:24','',''),(2614590,'1','187','939',418,'Retail Sale Id 1181157',78900.00,0.00,0.00,150.00,2700.00,'2022-02-23 12:52:36','',''),(2614591,'1','187','939',418,'Retail Sale Id 1181160',18410.00,0.00,0.00,35.00,630.00,'2022-02-23 12:57:26','',''),(2614592,'1','187','939',418,'Retail Sale Id 1181162',26300.00,0.00,0.00,50.00,900.00,'2022-02-23 13:01:19','',''),(2614593,'1','187','939',418,'Retail Sale Id 1181163',1002.40,0.00,0.00,1.79,93.08,'2022-02-23 13:05:33','',''),(2614594,'1','187','939',418,'Retail Sale Id 1181164',1002.40,0.00,0.00,1.79,93.08,'2022-02-23 13:58:05','',''),(2614595,'1','187','939',418,'Retail Sale Id 1181165',52600.00,0.00,0.00,100.00,1800.00,'2022-02-23 14:01:20','',''),(2614596,'1','187','939',418,'Retail Sale Id 1181166',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 14:11:06','',''),(2614597,'1','187','939',418,'Retail Sale Id 1181167',18410.00,0.00,0.00,35.00,630.00,'2022-02-23 14:22:48','',''),(2614598,'1','187','939',418,'Retail Sale Id 1181168',1002.40,0.00,0.00,1.79,93.08,'2022-02-23 14:38:06','',''),(2614599,'1','187','939',418,'Retail Sale Id 1181169',52600.00,0.00,0.00,100.00,1800.00,'2022-02-23 14:49:40','',''),(2614600,'1','187','939',418,'Retail Sale Id 1181170',26300.00,0.00,0.00,50.00,900.00,'2022-02-23 14:50:58','',''),(2614601,'1','187','939',418,'Retail Sale Id 1181171',13150.00,0.00,0.00,25.00,450.00,'2022-02-23 15:00:16','',''),(2614602,'1','187','939',418,'Retail Sale Id 1181172',2800.00,0.00,0.00,5.00,260.00,'2022-02-23 15:17:13','',''),(2614603,'1','187','939',418,'Retail Sale Id 1181173',105200.00,0.00,0.00,200.00,3600.00,'2022-02-23 15:36:02','',''),(2614604,'1','187','939',418,'Retail Sale Id 1181174',105200.00,0.00,0.00,200.00,3600.00,'2022-02-23 15:37:03','',''),(2614605,'1','187','939',418,'Retail Sale Id 1181175',15780.00,0.00,0.00,30.00,540.00,'2022-02-23 15:39:52','',''),(2614606,'1','187','939',418,'Retail Sale Id 1181176',30508.00,0.00,0.00,58.00,1044.00,'2022-02-23 15:41:22','',''),(2614607,'1','187','939',418,'Retail Sale Id 1181177',1702.40,0.00,0.00,3.04,158.08,'2022-02-23 15:43:41','',''),(2614608,'1','187','939',418,'Retail Sale Id 1181178',26300.00,0.00,0.00,50.00,900.00,'2022-02-23 15:52:55','',''),(2614609,'1','187','939',418,'Retail Sale Id 1181180',117298.00,0.00,0.00,223.00,4014.00,'2022-02-23 15:56:38','',''),(2614610,'1','187','939',418,'Retail Sale Id 1181181',3399.20,0.00,0.00,6.07,315.64,'2022-02-23 15:58:47','',''),(2614611,'1','187','939',418,'Retail Sale Id 1181182',1002.40,0.00,0.00,1.79,93.08,'2022-02-23 16:02:33','',''),(2614612,'1','187','939',418,'Retail Sale Id 1181183',52600.00,0.00,0.00,100.00,1800.00,'2022-02-23 16:15:55','',''),(2614613,'1','187','939',418,'Retail Sale Id 1181184',1702.40,0.00,0.00,3.04,158.08,'2022-02-23 16:16:57','',''),(2614614,'1','187','939',418,'Retail Sale Id 1181185',1002.40,0.00,0.00,1.79,93.08,'2022-02-23 16:28:11','',''),(2614615,'1','187','939',418,'Retail Sale Id 1181186',3399.20,0.00,0.00,6.07,315.64,'2022-02-23 16:29:09','',''),(2614616,'1','187','939',418,'Retail Sale Id 1181187',2251.20,0.00,0.00,4.02,209.04,'2022-02-23 16:39:55','',''),(2614617,'1','187','939',418,'Retail Sale Id 1181188',1500.80,0.00,0.00,2.68,139.36,'2022-02-23 16:44:08','',''),(2614618,'1','187','939',418,'Retail Sale Id 1181189',78900.00,0.00,0.00,150.00,2700.00,'2022-02-23 16:45:25','',''),(2614619,'1','187','939',418,'Retail Sale Id 1181190',2800.00,0.00,0.00,5.00,260.00,'2022-02-23 16:55:53','',''),(2614620,'1','187','939',418,'Return of Retail Sale Id 1181190',0.00,2800.00,5.00,0.00,-260.00,'2022-02-23 16:57:10','',''),(2614621,'1','187','939',418,'Retail Sale Id 1181191',26300.00,0.00,0.00,50.00,900.00,'2022-02-23 17:00:48','',''),(2614622,'1','187','939',418,'Retail Sale Id 1181192',53652.00,0.00,0.00,102.00,1836.00,'2022-02-23 17:06:49','',''),(2614623,'1','187','939',418,'Retail Sale Id 1181193',3399.20,0.00,0.00,6.07,315.64,'2022-02-23 17:10:34','',''),(2614624,'1','187','939',418,'Retail Sale Id 1181194',1500.80,0.00,0.00,2.68,139.36,'2022-02-23 17:13:10','',''),(2614625,'1','187','939',418,'Retail Sale Id 1181195',1500.80,0.00,0.00,2.68,139.36,'2022-02-23 17:15:55','',''),(2614626,'1','187','939',418,'Retail Sale Id 1181196',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 17:18:51','',''),(2614627,'1','187','939',418,'Retail Sale Id 1181197',26300.00,0.00,0.00,50.00,900.00,'2022-02-23 17:26:12','',''),(2614628,'1','187','939',418,'Retail Sale Id 1181198',1120.00,0.00,0.00,2.00,104.00,'2022-02-23 17:27:30','',''),(2614629,'1','187','939',418,'Retail Sale Id 1181199',3001.60,0.00,0.00,5.36,278.72,'2022-02-23 17:28:53','',''),(2614630,'1','187','939',418,'Retail Sale Id 1181200',2800.00,0.00,0.00,5.00,260.00,'2022-02-23 17:30:00','',''),(2614631,'1','187','939',418,'Retail Sale Id 1181201',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 17:36:29','',''),(2614632,'1','187','939',418,'Retail Sale Id 1181202',1500.80,0.00,0.00,2.68,139.36,'2022-02-23 17:40:23','',''),(2614633,'1','187','939',418,'Retail Sale Id 1181203',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 17:43:35','',''),(2614634,'1','187','939',418,'Retail Sale Id 1181204',3360.00,0.00,0.00,6.00,312.00,'2022-02-23 17:47:14','',''),(2614635,'1','187','939',418,'Retail Sale Id 1181205',3399.20,0.00,0.00,6.07,315.64,'2022-02-23 17:51:54','',''),(2614636,'1','187','939',418,'Retail Sale Id 1181206',1120.00,0.00,0.00,2.00,104.00,'2022-02-23 17:54:01','',''),(2614637,'1','187','939',418,'Retail Sale Id 1181207',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 17:55:09','',''),(2614638,'1','187','939',418,'Return of Retail Sale Id 1181205',0.00,3399.20,6.07,0.00,-315.64,'2022-02-23 17:55:53','',''),(2614639,'1','187','939',418,'Retail Sale Id 1181208',560.00,0.00,0.00,1.00,52.00,'2022-02-23 18:01:09','',''),(2614640,'1','187','939',418,'Retail Sale Id 1181209',1999.20,0.00,0.00,3.57,185.64,'2022-02-23 18:04:20','',''),(2614641,'1','187','939',418,'Return of Retail Sale Id 1181180',0.00,117298.00,223.00,0.00,-4014.00,'2022-02-23 18:06:25','',''),(2614642,'1','187','939',418,'Retail Sale Id 1181210',529914.00,0.00,0.00,1023.00,10230.00,'2022-02-23 18:09:22','',''),(2614643,'1','187','939',418,'Retail Sale Id 1181211',182000.00,0.00,0.00,350.00,4200.00,'2022-02-23 18:11:00','',''),(2614644,'1','187','939',418,'Retail Sale Id 1181212',80080.00,0.00,0.00,154.00,1848.00,'2022-02-23 18:11:41','',''),(2614645,'1','187','939',418,'Return of Retail Sale Id 1181212',0.00,80080.00,154.00,0.00,-1848.00,'2022-02-23 18:11:57','',''),(2614646,'1','187','939',418,'Retail Sale Id 1181213',81004.00,0.00,0.00,154.00,2772.00,'2022-02-23 18:12:49','',''),(2614647,'1','187','939',418,'Retail Sale Id 1181214',30508.00,0.00,0.00,58.00,1044.00,'2022-02-23 18:14:37','',''),(2614648,'1','187','939',418,'Retail Sale Id 1181215',1702.40,0.00,0.00,3.04,158.08,'2022-02-23 18:23:54','',''),(2614649,'1','187','939',418,'Return of Retail Sale Id 1181183',0.00,52600.00,100.00,0.00,-1800.00,'2022-02-23 18:26:52','',''),(2614650,'1','187','939',418,'Retail Sale Id 1181216',52505.32,0.00,0.00,99.82,1796.76,'2022-02-23 18:28:11','',''),(2614651,'1','187','939',418,'Retail Sale Id 1181217',2251.20,0.00,0.00,4.02,209.04,'2022-02-23 18:30:07','',''),(2614652,'1','187','939',418,'Retail Sale Id 1181218',1002.40,0.00,0.00,1.79,93.08,'2022-02-23 18:30:53','',''),(2614653,'1','187','939',418,'Retail Sale Id 1181220',157800.00,0.00,0.00,300.00,5400.00,'2022-02-23 18:39:28','',''),(2614654,'1','187','939',418,'Retail Sale Id 1181221',2760.80,0.00,0.00,4.93,256.36,'2022-02-23 18:41:11','',''),(2614655,'1','187','939',418,'Return of Retail Sale Id 1181210',0.00,529914.00,1023.00,0.00,-10230.00,'2022-02-23 18:47:59','',''),(2614656,'1','187','939',418,'Retail Sale Id 1181222',536052.00,0.00,0.00,1023.00,16368.00,'2022-02-23 18:48:41','',''),(2614657,'1','187','939',418,'Return of Retail Sale Id 1181211',0.00,182000.00,350.00,0.00,-4200.00,'2022-02-23 19:08:12','',''),(2614658,'1','187','939',418,'Retail Sale Id 1181223',184100.00,0.00,0.00,350.00,6300.00,'2022-02-23 19:08:52','',''),(2614659,'1','187','939',418,'Retail Sale Id 1181224',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 08:17:47','',''),(2614660,'1','187','939',418,'Retail Sale Id 1181225',105200.00,0.00,0.00,200.00,3600.00,'2022-02-24 08:19:50','',''),(2614661,'1','187','939',418,'Retail Sale Id 1181226',105200.00,0.00,0.00,200.00,3600.00,'2022-02-24 08:20:47','',''),(2614662,'1','187','939',418,'Retail Sale Id 1181227',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 08:27:12','',''),(2614663,'1','187','939',418,'Retail Sale Id 1181228',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 08:31:18','',''),(2614664,'1','187','939',418,'Retail Sale Id 1181229',6501.60,0.00,0.00,11.61,603.72,'2022-02-24 08:33:00','',''),(2614665,'1','187','939',418,'Return of Retail Sale Id 1181229',0.00,6501.60,11.61,0.00,-603.72,'2022-02-24 08:33:51','',''),(2614666,'1','187','939',418,'Retail Sale Id 1181230',22092.00,0.00,0.00,42.00,756.00,'2022-02-24 08:35:00','',''),(2614667,'1','187','939',418,'Retail Sale Id 1181231',1999.20,0.00,0.00,3.57,185.64,'2022-02-24 08:36:20','',''),(2614668,'1','187','939',418,'Retail Sale Id 1181232',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 08:43:05','',''),(2614669,'1','187','939',418,'Retail Sale Id 1181233',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 08:49:35','',''),(2614670,'1','187','939',418,'Retail Sale Id 1181234',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 08:52:11','',''),(2614671,'1','187','939',418,'Retail Sale Id 1181235',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 09:05:37','',''),(2614672,'1','187','939',418,'Retail Sale Id 1181236',157800.00,0.00,0.00,300.00,5400.00,'2022-02-24 09:09:41','',''),(2614673,'1','187','939',418,'Retail Sale Id 1181237',52600.00,0.00,0.00,100.00,1800.00,'2022-02-24 09:23:51','',''),(2614674,'1','187','939',418,'Retail Sale Id 1181238',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 09:29:27','',''),(2614675,'1','187','939',418,'Retail Sale Id 1181239',7000.00,0.00,0.00,12.50,650.00,'2022-02-24 09:33:22','',''),(2614676,'1','187','939',418,'Retail Sale Id 1181240',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 09:36:00','',''),(2614677,'1','187','939',418,'Retail Sale Id 1181241',21040.00,0.00,0.00,40.00,720.00,'2022-02-24 09:42:21','',''),(2614678,'1','187','939',418,'Retail Sale Id 1181242',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 09:45:16','',''),(2614679,'1','187','939',418,'Retail Sale Id 1181243',1120.00,0.00,0.00,2.00,104.00,'2022-02-24 09:47:59','',''),(2614680,'1','187','939',418,'Retail Sale Id 1181245',3156.00,0.00,0.00,6.00,108.00,'2022-02-24 10:16:56','',''),(2614681,'1','187','939',418,'Retail Sale Id 1181246',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 10:21:28','',''),(2614682,'1','187','939',418,'Retail Sale Id 1181247',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 10:24:56','',''),(2614683,'1','187','939',418,'Retail Sale Id 1181248',52600.00,0.00,0.00,100.00,1800.00,'2022-02-24 10:33:27','',''),(2614684,'1','187','939',418,'Retail Sale Id 1181249',52600.00,0.00,0.00,100.00,1800.00,'2022-02-24 10:37:44','',''),(2614685,'1','187','939',418,'Retail Sale Id 1181250',1500.80,0.00,0.00,2.68,139.36,'2022-02-24 10:39:50','',''),(2614686,'1','187','939',418,'Retail Sale Id 1181251',105200.00,0.00,0.00,200.00,3600.00,'2022-02-24 10:54:03','',''),(2614687,'1','187','939',418,'Retail Sale Id 1181252',52600.00,0.00,0.00,100.00,1800.00,'2022-02-24 11:00:38','',''),(2614688,'1','187','939',418,'Retail Sale Id 1181253',52600.00,0.00,0.00,100.00,1800.00,'2022-02-24 11:10:32','',''),(2614689,'1','187','939',418,'Retail Sale Id 1181254',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 11:18:03','',''),(2614690,'1','187','939',418,'Retail Sale Id 1181255',7000.00,0.00,0.00,12.50,650.00,'2022-02-24 11:23:39','',''),(2614691,'1','187','939',418,'Retail Sale Id 1181256',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 11:33:18','',''),(2614692,'1','187','939',418,'Retail Sale Id 1181257',78900.00,0.00,0.00,150.00,2700.00,'2022-02-24 11:41:36','',''),(2614693,'1','187','939',418,'Retail Sale Id 1181258',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 11:43:45','',''),(2614694,'1','187','939',418,'Retail Sale Id 1181259',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 11:46:54','',''),(2614695,'1','187','939',418,'Retail Sale Id 1181261',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 11:49:40','',''),(2614696,'1','187','939',418,'Retail Sale Id 1181262',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 11:51:16','',''),(2614697,'1','187','939',418,'Retail Sale Id 1181263',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 11:55:37','',''),(2614698,'1','187','939',418,'Retail Sale Id 1181264',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 12:56:38','',''),(2614699,'1','187','939',418,'Retail Sale Id 1181265',1120.00,0.00,0.00,2.00,104.00,'2022-02-24 13:05:52','',''),(2614700,'1','187','939',418,'Retail Sale Id 1181266',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 13:12:20','',''),(2614701,'1','187','939',418,'Retail Sale Id 1181267',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 13:17:56','',''),(2614702,'1','187','939',418,'Retail Sale Id 1181268',2800.00,0.00,0.00,5.00,260.00,'2022-02-24 13:33:09','',''),(2614703,'1','187','939',418,'Retail Sale Id 1181269',3399.20,0.00,0.00,6.07,315.64,'2022-02-24 13:45:56','',''),(2614704,'1','187','939',418,'Retail Sale Id 1181270',47340.00,0.00,0.00,90.00,1620.00,'2022-02-24 14:00:14','',''),(2614705,'1','187','939',418,'Retail Sale Id 1181271',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 14:08:32','',''),(2614706,'1','187','939',418,'Retail Sale Id 1181272',105200.00,0.00,0.00,200.00,3600.00,'2022-02-24 14:14:21','',''),(2614707,'1','187','939',418,'Retail Sale Id 1181273',78900.00,0.00,0.00,150.00,2700.00,'2022-02-24 14:16:06','',''),(2614708,'1','187','939',418,'Retail Sale Id 1181274',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 14:42:45','',''),(2614709,'1','187','939',418,'Retail Sale Id 1181275',78900.00,0.00,0.00,150.00,2700.00,'2022-02-24 15:01:13','',''),(2614710,'1','187','939',418,'Retail Sale Id 1181276',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 15:05:50','',''),(2614711,'1','187','939',418,'Retail Sale Id 1181277',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 15:23:50','',''),(2614712,'1','187','939',418,'Retail Sale Id 1181278',1702.40,0.00,0.00,3.04,158.08,'2022-02-24 15:40:29','',''),(2614713,'1','187','939',418,'Retail Sale Id 1181279',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 15:52:09','',''),(2614714,'1','187','939',418,'Retail Sale Id 1181280',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 16:03:35','',''),(2614715,'1','187','939',418,'Retail Sale Id 1181281',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 16:23:29','',''),(2614716,'1','187','939',418,'Retail Sale Id 1181282',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 16:35:38','',''),(2614717,'1','187','939',418,'Retail Sale Id 1181283',52600.00,0.00,0.00,100.00,1800.00,'2022-02-24 16:53:08','',''),(2614718,'1','187','939',418,'Retail Sale Id 1181284',1999.20,0.00,0.00,3.57,185.64,'2022-02-24 17:00:25','',''),(2614719,'1','187','939',418,'Retail Sale Id 1181285',1500.80,0.00,0.00,2.68,139.36,'2022-02-24 17:03:43','',''),(2614720,'1','187','939',418,'Retail Sale Id 1181286',78900.00,0.00,0.00,150.00,2700.00,'2022-02-24 17:08:29','',''),(2614721,'1','187','939',418,'Retail Sale Id 1181287',1999.20,0.00,0.00,3.57,185.64,'2022-02-24 17:10:10','',''),(2614722,'1','187','939',418,'Retail Sale Id 1181288',26300.00,0.00,0.00,50.00,900.00,'2022-02-24 17:14:15','',''),(2614723,'1','187','939',418,'Retail Sale Id 1181289',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 17:24:16','',''),(2614724,'1','187','939',418,'Retail Sale Id 1181290',78900.00,0.00,0.00,150.00,2700.00,'2022-02-24 17:26:22','',''),(2614725,'1','187','939',418,'Retail Sale Id 1181291',1198.40,0.00,0.00,2.14,111.28,'2022-02-24 17:37:45','',''),(2614726,'1','187','939',418,'Retail Sale Id 1181292',1002.40,0.00,0.00,1.79,93.08,'2022-02-24 18:07:36','',''),(2614727,'1','187','939',418,'Retail Sale Id 1181293',6469.80,0.00,0.00,12.30,221.40,'2022-02-24 18:11:28','',''),(2614728,'1','187','939',418,'Retail Sale Id 1181294',19993.26,0.00,0.00,38.01,684.18,'2022-02-24 18:12:23','',''),(2614729,'1','187','939',418,'Retail Sale Id 1181295',9559.20,0.00,0.00,17.07,887.64,'2022-02-24 18:17:45','',''),(2614730,'1','187','939',418,'Retail Sale Id 1181296',21040.00,0.00,0.00,40.00,720.00,'2022-02-25 08:51:06','',''),(2614731,'1','187','939',418,'Retail Sale Id 1181297',21040.00,0.00,0.00,40.00,720.00,'2022-02-25 08:57:33','',''),(2614732,'1','187','939',418,'Retail Sale Id 1181298',3399.20,0.00,0.00,6.07,315.64,'2022-02-25 09:00:17','',''),(2614733,'1','187','939',418,'Retail Sale Id 1181299',1702.40,0.00,0.00,3.04,158.08,'2022-02-25 09:02:56','',''),(2614734,'1','187','939',418,'Retail Sale Id 1181300',3998.40,0.00,0.00,7.14,371.28,'2022-02-25 09:05:16','',''),(2614735,'1','187','939',418,'Retail Sale Id 1181301',26300.00,0.00,0.00,50.00,900.00,'2022-02-25 09:09:23','',''),(2614736,'1','187','939',418,'Retail Sale Id 1181302',1702.40,0.00,0.00,3.04,158.08,'2022-02-25 09:13:18','',''),(2614737,'1','187','939',418,'Retail Sale Id 1181303',5600.00,0.00,0.00,10.00,520.00,'2022-02-25 09:14:12','',''),(2614738,'1','187','939',418,'Retail Sale Id 1181304',1097.60,0.00,0.00,1.96,101.92,'2022-02-25 09:32:34','',''),(2614739,'1','187','939',418,'Retail Sale Id 1181305',1097.60,0.00,0.00,1.96,101.92,'2022-02-25 09:35:09','',''),(2614740,'1','187','939',418,'Retail Sale Id 1181306',1999.20,0.00,0.00,3.57,185.64,'2022-02-25 09:55:15','',''),(2614741,'1','187','939',418,'Retail Sale Id 1181307',1702.40,0.00,0.00,3.04,158.08,'2022-02-25 09:59:30','',''),(2614742,'1','187','939',418,'Retail Sale Id 1181308',21040.00,0.00,0.00,40.00,720.00,'2022-02-25 10:11:18','',''),(2614743,'1','187','939',418,'Retail Sale Id 1181310',78900.00,0.00,0.00,150.00,2700.00,'2022-02-25 10:15:35','',''),(2614744,'1','187','939',418,'Retail Sale Id 1181311',105200.00,0.00,0.00,200.00,3600.00,'2022-02-25 11:14:41','',''),(2614745,'1','187','939',418,'Retail Sale Id 1181312',3399.20,0.00,0.00,6.07,315.64,'2022-02-25 11:20:45','',''),(2614746,'1','187','939',418,'Retail Sale Id 1181314',3399.20,0.00,0.00,6.07,315.64,'2022-02-25 12:48:36','',''),(2614747,'1','187','939',418,'Retail Sale Id 1181315',1702.40,0.00,0.00,3.04,158.08,'2022-02-25 13:07:06','',''),(2614748,'1','187','939',418,'Retail Sale Id 1181316',1999.20,0.00,0.00,3.57,185.64,'2022-02-25 13:15:05','',''),(2614749,'1','187','939',418,'Retail Sale Id 1181317',1198.40,0.00,0.00,2.14,111.28,'2022-02-25 14:05:24','',''),(2614750,'1','187','939',418,'Retail Sale Id 1181318',1120.00,0.00,0.00,2.00,104.00,'2022-02-25 14:50:37','',''),(2614751,'1','187','939',418,'Retail Sale Id 1181319',1500.80,0.00,0.00,2.68,139.36,'2022-02-25 15:40:28','',''),(2614752,'1','187','939',418,'Retail Sale Id 1181320',3399.20,0.00,0.00,6.07,315.64,'2022-02-25 16:05:28','',''),(2614753,'1','187','939',418,'Retail Sale Id 1181321',1999.20,0.00,0.00,3.57,185.64,'2022-02-25 16:48:45','',''),(2614754,'1','187','939',418,'Retail Sale Id 1181322',52600.00,0.00,0.00,100.00,1800.00,'2022-02-25 16:55:00','',''),(2614755,'1','187','939',418,'Retail Sale Id 1181323',1198.40,0.00,0.00,2.14,111.28,'2022-02-25 17:00:14','',''),(2614756,'1','187','939',418,'Retail Sale Id 1181324',52600.00,0.00,0.00,100.00,1800.00,'2022-02-25 17:03:42','',''),(2614757,'1','187','939',418,'Retail Sale Id 1181325',26300.00,0.00,0.00,50.00,900.00,'2022-02-25 17:06:16','',''),(2614758,'1','187','939',418,'Retail Sale Id 1181326',1198.40,0.00,0.00,2.14,111.28,'2022-02-25 17:09:18','',''),(2614759,'1','187','939',418,'Retail Sale Id 1181327',1002.40,0.00,0.00,1.79,93.08,'2022-02-25 17:20:34','',''),(2614760,'1','187','939',418,'Retail Sale Id 1181328',1500.80,0.00,0.00,2.68,139.36,'2022-02-25 17:26:18','',''),(2614761,'1','187','939',418,'Retail Sale Id 1181329',26300.00,0.00,0.00,50.00,900.00,'2022-02-25 17:32:36','',''),(2614762,'1','187','939',418,'Retail Sale Id 1181330',1702.40,0.00,0.00,3.04,158.08,'2022-02-25 17:34:31','',''),(2614763,'1','187','939',418,'Retail Sale Id 1181331',3399.20,0.00,0.00,6.07,315.64,'2022-02-25 17:47:19','',''),(2614764,'1','187','939',418,'Retail Sale Id 1181332',3399.20,0.00,0.00,6.07,315.64,'2022-02-25 17:53:31','',''),(2614765,'1','187','939',418,'Retail Sale Id 1181333',21040.00,0.00,0.00,40.00,720.00,'2022-02-25 17:57:54','',''),(2614766,'1','187','939',418,'Retail Sale Id 1181335',65750.00,0.00,0.00,125.00,2250.00,'2022-02-25 18:14:04','',''),(2614767,'1','187','939',418,'Retail Sale Id 1181337',59175.00,0.00,0.00,112.50,2025.00,'2022-02-25 18:15:11','',''),(2614768,'1','187','939',418,'Retail Sale Id 1181338',52594.74,0.00,0.00,99.99,1799.82,'2022-02-25 18:16:49','',''),(2614769,'1','187','939',418,'Retail Sale Id 1181339',5260.00,0.00,0.00,10.00,180.00,'2022-02-25 18:20:58','',''),(2614770,'1','187','939',418,'Return of Retail Sale Id 1181338',0.00,52594.74,99.99,0.00,-1799.82,'2022-02-25 18:24:02','',''),(2614771,'1','187','939',418,'Retail Sale Id 1181340',52600.00,0.00,0.00,100.00,1800.00,'2022-02-25 18:25:14','',''),(2614772,'1','187','939',418,'Retail Sale Id 1181341',21817.60,0.00,0.00,38.96,2025.92,'2022-02-25 18:27:31','',''),(2614773,'1','187','939',418,'Retail Sale Id 1181342',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 08:26:51','',''),(2614774,'1','187','939',418,'Retail Sale Id 1181343',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 08:30:30','',''),(2614775,'1','187','939',418,'Retail Sale Id 1181344',1198.40,0.00,0.00,2.14,111.28,'2022-02-26 08:32:18','',''),(2614776,'1','187','939',418,'Retail Sale Id 1181345',3001.60,0.00,0.00,5.36,278.72,'2022-02-26 08:33:36','',''),(2614777,'1','187','939',418,'Retail Sale Id 1181346',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 08:44:58','',''),(2614778,'1','187','939',418,'Retail Sale Id 1181347',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 08:55:26','',''),(2614779,'1','187','939',418,'Retail Sale Id 1181348',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 09:02:36','',''),(2614780,'1','187','939',418,'Retail Sale Id 1181349',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 09:12:36','',''),(2614781,'1','187','939',418,'Retail Sale Id 1181350',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 09:17:06','',''),(2614782,'1','187','939',418,'Retail Sale Id 1181351',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 09:18:40','',''),(2614783,'1','187','939',418,'Retail Sale Id 1181352',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 09:35:55','',''),(2614784,'1','187','939',418,'Retail Sale Id 1181353',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 09:46:00','',''),(2614785,'1','187','939',418,'Retail Sale Id 1181354',1680.00,0.00,0.00,3.00,156.00,'2022-02-26 09:47:23','',''),(2614786,'1','187','939',418,'Retail Sale Id 1181355',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 09:53:03','',''),(2614787,'1','187','939',418,'Retail Sale Id 1181356',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 09:55:51','',''),(2614788,'1','187','939',418,'Retail Sale Id 1181357',5258.40,0.00,0.00,9.39,488.28,'2022-02-26 09:58:49','',''),(2614789,'1','187','939',418,'Retail Sale Id 1181358',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 10:00:38','',''),(2614790,'1','187','939',418,'Retail Sale Id 1181359',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 10:02:16','',''),(2614791,'1','187','939',418,'Retail Sale Id 1181360',526.40,0.00,0.00,0.94,48.88,'2022-02-26 10:03:44','',''),(2614792,'1','187','939',418,'Retail Sale Id 1181361',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 10:06:12','',''),(2614793,'1','187','939',418,'Retail Sale Id 1181362',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 10:09:06','',''),(2614794,'1','187','939',418,'Retail Sale Id 1181363',6160.00,0.00,0.00,11.00,572.00,'2022-02-26 10:11:01','',''),(2614795,'1','187','939',418,'Retail Sale Id 1181364',3399.20,0.00,0.00,6.07,315.64,'2022-02-26 10:13:52','',''),(2614796,'1','187','939',418,'Retail Sale Id 1181365',526.40,0.00,0.00,0.94,48.88,'2022-02-26 10:17:03','',''),(2614797,'1','187','939',418,'Retail Sale Id 1181367',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 10:20:28','',''),(2614798,'1','187','939',418,'Retail Sale Id 1181368',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 10:21:54','',''),(2614799,'1','187','939',418,'Retail Sale Id 1181369',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 10:30:04','',''),(2614800,'1','187','939',418,'Retail Sale Id 1181370',3500.00,0.00,0.00,6.25,325.00,'2022-02-26 10:31:44','',''),(2614801,'1','187','939',418,'Retail Sale Id 1181371',26300.00,0.00,0.00,50.00,900.00,'2022-02-26 10:35:07','',''),(2614802,'1','187','939',418,'Retail Sale Id 1181372',1500.80,0.00,0.00,2.68,139.36,'2022-02-26 10:38:15','',''),(2614803,'1','187','939',418,'Retail Sale Id 1181373',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 10:39:37','',''),(2614804,'1','187','939',418,'Retail Sale Id 1181374',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 10:50:44','',''),(2614805,'1','187','939',418,'Retail Sale Id 1181375',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 11:00:24','',''),(2614806,'1','187','939',418,'Retail Sale Id 1181376',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 11:05:40','',''),(2614807,'1','187','939',418,'Retail Sale Id 1181377',1198.40,0.00,0.00,2.14,111.28,'2022-02-26 11:07:23','',''),(2614808,'1','187','939',418,'Retail Sale Id 1181378',19988.00,0.00,0.00,38.00,684.00,'2022-02-26 11:10:49','',''),(2614809,'1','187','939',418,'Retail Sale Id 1181379',3001.60,0.00,0.00,5.36,278.72,'2022-02-26 11:12:45','',''),(2614810,'1','187','939',418,'Retail Sale Id 1181380',7000.00,0.00,0.00,12.50,650.00,'2022-02-26 11:18:51','',''),(2614811,'1','187','939',418,'Retail Sale Id 1181381',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 11:21:38','',''),(2614812,'1','187','939',418,'Retail Sale Id 1181382',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 11:23:47','',''),(2614813,'1','187','939',418,'Retail Sale Id 1181383',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 11:26:30','',''),(2614814,'1','187','939',418,'Retail Sale Id 1181384',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 11:38:20','',''),(2614815,'1','187','939',418,'Retail Sale Id 1181385',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 11:47:26','',''),(2614816,'1','187','939',418,'Retail Sale Id 1181386',2800.00,0.00,0.00,5.00,260.00,'2022-02-26 11:49:03','',''),(2614817,'1','187','939',418,'Retail Sale Id 1181387',1500.80,0.00,0.00,2.68,139.36,'2022-02-26 11:50:49','',''),(2614818,'1','187','939',418,'Retail Sale Id 1181388',26300.00,0.00,0.00,50.00,900.00,'2022-02-26 11:52:37','',''),(2614819,'1','187','939',418,'Retail Sale Id 1181389',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 11:54:48','',''),(2614820,'1','187','939',418,'Retail Sale Id 1181390',1198.40,0.00,0.00,2.14,111.28,'2022-02-26 11:57:23','',''),(2614821,'1','187','939',418,'Retail Sale Id 1181391',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 11:58:19','',''),(2614822,'1','187','939',418,'Retail Sale Id 1181392',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 12:03:59','',''),(2614823,'1','187','939',418,'Retail Sale Id 1181393',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 12:14:29','',''),(2614824,'1','187','939',418,'Retail Sale Id 1181394',78900.00,0.00,0.00,150.00,2700.00,'2022-02-26 12:23:02','',''),(2614825,'1','187','939',418,'Retail Sale Id 1181395',3500.00,0.00,0.00,6.25,325.00,'2022-02-26 12:34:09','',''),(2614826,'1','187','939',418,'Retail Sale Id 1181396',13150.00,0.00,0.00,25.00,450.00,'2022-02-26 12:37:16','',''),(2614827,'1','187','939',418,'Retail Sale Id 1181397',1052.00,0.00,0.00,2.00,36.00,'2022-02-26 12:41:16','',''),(2614828,'1','187','939',418,'Retail Sale Id 1181399',3399.20,0.00,0.00,6.07,315.64,'2022-02-26 12:42:39','',''),(2614829,'1','187','939',418,'Retail Sale Id 1181401',31560.00,0.00,0.00,60.00,1080.00,'2022-02-26 13:48:11','',''),(2614830,'1','187','939',418,'Retail Sale Id 1181402',1500.80,0.00,0.00,2.68,139.36,'2022-02-26 14:00:28','',''),(2614831,'1','187','939',418,'Retail Sale Id 1181403',2800.00,0.00,0.00,5.00,260.00,'2022-02-26 15:54:58','',''),(2614832,'1','187','939',418,'Retail Sale Id 1181404',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 15:56:56','',''),(2614833,'1','187','939',418,'Retail Sale Id 1181405',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 16:14:42','',''),(2614834,'1','187','939',418,'Retail Sale Id 1181406',23670.00,0.00,0.00,45.00,810.00,'2022-02-26 16:20:11','',''),(2614835,'1','187','939',418,'Retail Sale Id 1181408',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 16:22:54','',''),(2614836,'1','187','939',418,'Retail Sale Id 1181409',830028.00,0.00,0.00,1578.00,28404.00,'2022-02-26 16:25:21','',''),(2614837,'1','187','939',418,'Retail Sale Id 1181410',176210.00,0.00,0.00,335.00,6030.00,'2022-02-26 16:31:46','',''),(2614838,'1','187','939',418,'Retail Sale Id 1181411',11.70,0.00,0.00,3.42,-1725.66,'2022-02-26 16:36:29','',''),(2614839,'1','187','939',418,'Retail Sale Id 1181412',1798.92,0.00,0.00,3.42,61.56,'2022-02-26 16:38:29','',''),(2614840,'1','187','939',418,'Retail Sale Id 1181413',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 16:51:15','',''),(2614841,'1','187','939',418,'Return of Retail Sale Id 1181411',0.00,11.70,3.42,0.00,1725.66,'2022-02-26 16:58:51','',''),(2614842,'1','187','939',418,'Return of Retail Sale Id 1181410',0.00,176210.00,335.00,0.00,-6030.00,'2022-02-26 16:59:39','',''),(2614843,'1','187','939',418,'Return of Retail Sale Id 1181409',0.00,830028.00,1578.00,0.00,-28404.00,'2022-02-26 17:00:29','',''),(2614844,'1','187','939',418,'Retail Sale Id 1181414',5000.80,0.00,0.00,8.93,464.36,'2022-02-26 17:02:49','',''),(2614845,'1','187','939',418,'Retail Sale Id 1181415',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 17:04:52','',''),(2614846,'1','187','939',418,'Retail Sale Id 1181416',1002.40,0.00,0.00,1.79,93.08,'2022-02-26 17:10:09','',''),(2614847,'1','187','939',418,'Retail Sale Id 1181417',3399.20,0.00,0.00,6.07,315.64,'2022-02-26 17:25:30','',''),(2614848,'1','187','939',418,'Retail Sale Id 1181418',52600.00,0.00,0.00,100.00,1800.00,'2022-02-26 17:36:34','',''),(2614849,'1','187','939',418,'Retail Sale Id 1181419',26300.00,0.00,0.00,50.00,900.00,'2022-02-26 17:39:46','',''),(2614850,'1','187','939',418,'Retail Sale Id 1181420',2800.00,0.00,0.00,5.00,260.00,'2022-02-26 17:40:58','',''),(2614851,'1','187','939',418,'Retail Sale Id 1181421',5391.50,0.00,0.00,10.25,184.50,'2022-02-26 17:47:59','',''),(2614852,'1','187','939',418,'Retail Sale Id 1181422',2240.00,0.00,0.00,4.00,208.00,'2022-02-26 17:52:26','',''),(2614853,'1','187','939',418,'Return of Retail Sale Id 1181421',0.00,5391.50,10.25,0.00,-184.50,'2022-02-26 17:53:26','',''),(2614854,'1','187','939',418,'Retail Sale Id 1181423',5549.30,0.00,0.00,10.55,189.90,'2022-02-26 17:55:31','',''),(2614855,'1','187','939',418,'Retail Sale Id 1181424',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 17:56:01','',''),(2614856,'1','187','939',418,'Retail Sale Id 1181425',1120.00,0.00,0.00,2.00,104.00,'2022-02-26 17:59:19','',''),(2614857,'1','187','939',418,'Retail Sale Id 1181426',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 18:00:35','',''),(2614858,'1','187','939',418,'Retail Sale Id 1181427',1702.40,0.00,0.00,3.04,158.08,'2022-02-26 18:04:10','',''),(2614859,'1','187','939',418,'Return of Retail Sale Id 1181418',0.00,52600.00,100.00,0.00,-1800.00,'2022-02-26 18:07:53','',''),(2614860,'1','187','939',418,'Retail Sale Id 1181428',47660.86,0.00,0.00,90.61,1630.98,'2022-02-26 18:09:50','',''),(2614861,'1','187','939',418,'Retail Sale Id 1181429',2240.00,0.00,0.00,4.00,208.00,'2022-02-26 18:13:26','',''),(2614862,'1','187','939',418,'Retail Sale Id 1181430',1999.20,0.00,0.00,3.57,185.64,'2022-02-26 18:19:59','',''),(2614863,'1','187','939',418,'Retail Sale Id 1181431',3393.60,0.00,0.00,6.06,315.12,'2022-02-26 18:24:46','',''),(2614864,'1','187','939',418,'Retail Sale Id 1181432',26300.00,0.00,0.00,50.00,900.00,'2022-02-27 10:46:36','',''),(2614865,'1','187','939',418,'Retail Sale Id 1181433',3500.00,0.00,0.00,6.25,325.00,'2022-02-27 10:51:41','',''),(2614866,'1','187','939',418,'Retail Sale Id 1181434',1500.80,0.00,0.00,2.68,139.36,'2022-02-27 10:56:31','',''),(2614867,'1','187','939',418,'Retail Sale Id 1181435',124136.00,0.00,0.00,236.00,4248.00,'2022-02-27 11:00:33','',''),(2614868,'1','187','939',418,'Retail Sale Id 1181436',93102.00,0.00,0.00,177.00,3186.00,'2022-02-27 11:02:47','',''),(2614869,'1','187','939',418,'Retail Sale Id 1181437',62068.00,0.00,0.00,118.00,2124.00,'2022-02-27 11:04:59','',''),(2614870,'1','187','939',418,'Retail Sale Id 1181438',62068.00,0.00,0.00,118.00,2124.00,'2022-02-27 11:07:08','',''),(2614871,'1','187','939',418,'Retail Sale Id 1181439',124136.00,0.00,0.00,236.00,4248.00,'2022-02-27 11:08:47','',''),(2614872,'1','187','939',418,'Retail Sale Id 1181440',52600.00,0.00,0.00,100.00,1800.00,'2022-02-27 11:11:13','',''),(2614873,'1','187','939',418,'Retail Sale Id 1181441',3001.60,0.00,0.00,5.36,278.72,'2022-02-27 11:16:17','',''),(2614874,'1','187','939',418,'Retail Sale Id 1181442',6296.22,0.00,0.00,11.97,215.46,'2022-02-27 11:20:21','',''),(2614875,'1','187','939',418,'Retail Sale Id 1181443',1002.40,0.00,0.00,1.79,93.08,'2022-02-27 11:24:13','',''),(2614876,'1','187','939',418,'Retail Sale Id 1181444',1002.40,0.00,0.00,1.79,93.08,'2022-02-27 11:36:15','',''),(2614877,'1','187','939',418,'Retail Sale Id 1181445',7000.00,0.00,0.00,12.50,650.00,'2022-02-27 11:39:51','',''),(2614878,'1','187','939',418,'Retail Sale Id 1181446',26300.00,0.00,0.00,50.00,900.00,'2022-02-27 12:12:13','',''),(2614879,'1','187','939',418,'Retail Sale Id 1181447',3399.20,0.00,0.00,6.07,315.64,'2022-02-27 12:14:36','',''),(2614880,'1','187','939',418,'Retail Sale Id 1181448',6312.00,0.00,0.00,12.00,216.00,'2022-02-27 12:22:02','',''),(2614881,'1','187','939',418,'Retail Sale Id 1181449',1002.40,0.00,0.00,1.79,93.08,'2022-02-27 12:35:43','',''),(2614882,'1','187','939',418,'Retail Sale Id 1181450',1002.40,0.00,0.00,1.79,93.08,'2022-02-27 12:56:19','',''),(2614883,'1','187','939',418,'Retail Sale Id 1181455',1500.80,0.00,0.00,2.68,139.36,'2022-02-27 12:58:45','',''),(2614884,'1','187','939',418,'Retail Sale Id 1181456',3399.20,0.00,0.00,6.07,315.64,'2022-02-27 13:00:10','',''),(2614885,'1','187','939',418,'Retail Sale Id 1181457',1500.80,0.00,0.00,2.68,139.36,'2022-02-27 13:01:45','',''),(2614886,'1','187','939',418,'Retail Sale Id 1181458',78900.00,0.00,0.00,150.00,2700.00,'2022-02-27 13:24:18','',''),(2614887,'1','187','939',418,'Retail Sale Id 1181459',52600.00,0.00,0.00,100.00,1800.00,'2022-02-27 13:26:22','',''),(2614888,'1','187','939',418,'Retail Sale Id 1181460',1002.40,0.00,0.00,1.79,93.08,'2022-02-27 13:56:13','',''),(2614889,'1','187','939',418,'Retail Sale Id 1181461',1702.40,0.00,0.00,3.04,158.08,'2022-02-27 14:25:36','',''),(2614890,'1','187','939',418,'Retail Sale Id 1181462',26300.00,0.00,0.00,50.00,900.00,'2022-02-27 14:31:57','',''),(2614891,'1','187','939',418,'Retail Sale Id 1181463',21040.00,0.00,0.00,40.00,720.00,'2022-02-27 14:39:09','',''),(2614892,'1','187','939',418,'Retail Sale Id 1181464',26300.00,0.00,0.00,50.00,900.00,'2022-02-27 14:52:48','',''),(2614893,'1','187','939',418,'Retail Sale Id 1181465',1002.40,0.00,0.00,1.79,93.08,'2022-02-27 14:54:23','',''),(2614894,'1','187','939',418,'Retail Sale Id 1181466',1999.20,0.00,0.00,3.57,185.64,'2022-02-27 15:06:24','',''),(2614895,'1','187','939',418,'Retail Sale Id 1181467',7000.00,0.00,0.00,12.50,650.00,'2022-02-27 15:12:53','',''),(2614896,'1','187','939',418,'Retail Sale Id 1181468',78900.00,0.00,0.00,150.00,2700.00,'2022-02-27 15:22:39','',''),(2614897,'1','187','939',418,'Retail Sale Id 1181469',52600.00,0.00,0.00,100.00,1800.00,'2022-02-27 15:39:59','',''),(2614898,'1','187','939',418,'Retail Sale Id 1181470',3399.20,0.00,0.00,6.07,315.64,'2022-02-27 15:47:16','',''),(2614899,'1','187','939',418,'Retail Sale Id 1181471',3001.60,0.00,0.00,5.36,278.72,'2022-02-27 16:18:03','',''),(2614900,'1','187','939',418,'Retail Sale Id 1181472',13649.70,0.00,0.00,25.95,467.10,'2022-02-27 16:41:25','',''),(2614901,'1','187','939',418,'Retail Sale Id 1181473',52600.00,0.00,0.00,100.00,1800.00,'2022-02-27 17:06:44','',''),(2614902,'1','187','939',418,'Retail Sale Id 1181474',52600.00,0.00,0.00,100.00,1800.00,'2022-02-27 17:34:53','',''),(2614903,'1','187','939',418,'Retail Sale Id 1181475',52600.00,0.00,0.00,100.00,1800.00,'2022-02-27 17:36:40','',''),(2614904,'1','187','939',418,'Retail Sale Id 1181476',12645.04,0.00,0.00,24.04,432.72,'2022-02-27 17:38:34','',''),(2614905,'1','187','939',418,'Retail Sale Id 1181477',81303.82,0.00,0.00,154.57,2782.26,'2022-02-27 17:40:19','',''),(2614906,'1','187','939',418,'Retail Sale Id 1181479',54704.00,0.00,0.00,104.00,1872.00,'2022-02-27 17:43:35','',''),(2614907,'1','187','939',418,'Retail Sale Id 1181480',55076.00,0.00,0.00,98.35,5114.20,'2022-02-27 17:54:48','',''),(2614908,'1','187','939',418,'Retail Sale Id 1181481',1500.80,0.00,0.00,2.68,139.36,'2022-02-28 08:24:34','',''),(2614909,'1','187','939',418,'Retail Sale Id 1181482',7000.00,0.00,0.00,12.50,650.00,'2022-02-28 08:25:23','',''),(2614910,'1','187','939',418,'Retail Sale Id 1181483',3399.20,0.00,0.00,6.07,315.64,'2022-02-28 08:26:39','',''),(2614911,'1','187','939',418,'Retail Sale Id 1181484',1198.40,0.00,0.00,2.14,111.28,'2022-02-28 08:27:42','',''),(2614912,'1','187','939',418,'Retail Sale Id 1181485',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 08:29:15','',''),(2614913,'1','187','939',418,'Retail Sale Id 1181486',21040.00,0.00,0.00,40.00,720.00,'2022-02-28 08:35:07','',''),(2614914,'1','187','939',418,'Retail Sale Id 1181487',26300.00,0.00,0.00,50.00,900.00,'2022-02-28 08:36:55','',''),(2614915,'1','187','939',418,'Retail Sale Id 1181488',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 08:38:32','',''),(2614916,'1','187','939',418,'Retail Sale Id 1181489',3001.60,0.00,0.00,5.36,278.72,'2022-02-28 08:49:23','',''),(2614917,'1','187','939',418,'Retail Sale Id 1181490',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 08:50:13','',''),(2614918,'1','187','939',418,'Retail Sale Id 1181491',2251.20,0.00,0.00,4.02,209.04,'2022-02-28 08:51:45','',''),(2614919,'1','187','939',418,'Retail Sale Id 1181492',30508.00,0.00,0.00,58.00,1044.00,'2022-02-28 08:53:35','',''),(2614920,'1','187','939',418,'Retail Sale Id 1181493',78900.00,0.00,0.00,150.00,2700.00,'2022-02-28 08:55:07','',''),(2614921,'1','187','939',418,'Retail Sale Id 1181494',78900.00,0.00,0.00,150.00,2700.00,'2022-02-28 08:55:57','',''),(2614922,'1','187','939',418,'Retail Sale Id 1181495',3399.20,0.00,0.00,6.07,315.64,'2022-02-28 08:57:37','',''),(2614923,'1','187','939',418,'Retail Sale Id 1181497',78900.00,0.00,0.00,150.00,2700.00,'2022-02-28 09:01:00','',''),(2614924,'1','187','939',418,'Retail Sale Id 1181498',96521.00,0.00,0.00,183.50,3303.00,'2022-02-28 09:51:01','',''),(2614925,'1','187','939',418,'Retail Sale Id 1181499',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 09:55:18','',''),(2614926,'1','187','939',418,'Retail Sale Id 1181500',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 10:05:45','',''),(2614927,'1','187','939',418,'Retail Sale Id 1181501',52600.00,0.00,0.00,100.00,1800.00,'2022-02-28 10:11:10','',''),(2614928,'1','187','939',418,'Retail Sale Id 1181502',1500.80,0.00,0.00,2.68,139.36,'2022-02-28 10:12:07','',''),(2614929,'1','187','939',418,'Retail Sale Id 1181503',131500.00,0.00,0.00,250.00,4500.00,'2022-02-28 10:14:30','',''),(2614930,'1','187','939',418,'Retail Sale Id 1181505',52600.00,0.00,0.00,100.00,1800.00,'2022-02-28 10:16:43','',''),(2614931,'1','187','939',418,'Retail Sale Id 1181506',26300.00,0.00,0.00,50.00,900.00,'2022-02-28 10:23:48','',''),(2614932,'1','187','939',418,'Retail Sale Id 1181507',14000.00,0.00,0.00,25.00,1300.00,'2022-02-28 10:26:52','',''),(2614933,'1','187','939',418,'Retail Sale Id 1181508',1500.80,0.00,0.00,2.68,139.36,'2022-02-28 10:28:41','',''),(2614934,'1','187','939',418,'Retail Sale Id 1181509',599.20,0.00,0.00,1.07,55.64,'2022-02-28 10:51:17','',''),(2614935,'1','187','939',418,'Retail Sale Id 1181510',52600.00,0.00,0.00,100.00,1800.00,'2022-02-28 11:41:06','',''),(2614936,'1','187','939',418,'Retail Sale Id 1181511',26300.00,0.00,0.00,50.00,900.00,'2022-02-28 11:42:41','',''),(2614937,'1','187','939',418,'Retail Sale Id 1181512',131500.00,0.00,0.00,250.00,4500.00,'2022-02-28 12:50:20','',''),(2614938,'1','187','939',418,'Retail Sale Id 1181513',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 13:19:28','',''),(2614939,'1','187','939',418,'Retail Sale Id 1181514',52600.00,0.00,0.00,100.00,1800.00,'2022-02-28 13:26:52','',''),(2614940,'1','187','939',418,'Retail Sale Id 1181515',105200.00,0.00,0.00,200.00,3600.00,'2022-02-28 13:33:40','',''),(2614941,'1','187','939',418,'Retail Sale Id 1181516',1578.00,0.00,0.00,3.00,54.00,'2022-02-28 13:39:34','',''),(2614942,'1','187','939',418,'Retail Sale Id 1181517',3001.60,0.00,0.00,5.36,278.72,'2022-02-28 13:55:45','',''),(2614943,'1','187','939',418,'Retail Sale Id 1181518',1120.00,0.00,0.00,2.00,104.00,'2022-02-28 14:12:46','',''),(2614944,'1','187','939',418,'Retail Sale Id 1181519',3399.20,0.00,0.00,6.07,315.64,'2022-02-28 14:29:29','',''),(2614945,'1','187','939',418,'Retail Sale Id 1181520',52600.00,0.00,0.00,100.00,1800.00,'2022-02-28 14:47:52','',''),(2614946,'1','187','939',418,'Retail Sale Id 1181521',1999.20,0.00,0.00,3.57,185.64,'2022-02-28 15:25:15','',''),(2614947,'1','187','939',418,'Retail Sale Id 1181522',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 15:51:37','',''),(2614948,'1','187','939',418,'Retail Sale Id 1181523',1999.20,0.00,0.00,3.57,185.64,'2022-02-28 15:59:31','',''),(2614949,'1','187','939',418,'Retail Sale Id 1181524',26300.00,0.00,0.00,50.00,900.00,'2022-02-28 16:01:07','',''),(2614950,'1','187','939',418,'Retail Sale Id 1181525',78900.00,0.00,0.00,150.00,2700.00,'2022-02-28 16:03:47','',''),(2614951,'1','187','939',418,'Retail Sale Id 1181526',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 16:35:10','',''),(2614952,'1','187','939',418,'Retail Sale Id 1181527',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 16:40:57','',''),(2614953,'1','187','939',418,'Retail Sale Id 1181528',1120.00,0.00,0.00,2.00,104.00,'2022-02-28 16:44:42','',''),(2614954,'1','187','939',418,'Retail Sale Id 1181529',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 16:45:36','',''),(2614955,'1','187','939',418,'Retail Sale Id 1181530',1120.00,0.00,0.00,2.00,104.00,'2022-02-28 17:01:21','',''),(2614956,'1','187','939',418,'Retail Sale Id 1181531',78900.00,0.00,0.00,150.00,2700.00,'2022-02-28 17:02:54','',''),(2614957,'1','187','939',418,'Retail Sale Id 1181532',1999.20,0.00,0.00,3.57,185.64,'2022-02-28 17:06:52','',''),(2614958,'1','187','939',418,'Retail Sale Id 1181533',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 17:09:22','',''),(2614959,'1','187','939',418,'Retail Sale Id 1181535',3399.20,0.00,0.00,6.07,315.64,'2022-02-28 17:17:24','',''),(2614960,'1','187','939',418,'Retail Sale Id 1181536',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 17:18:29','',''),(2614961,'1','187','939',418,'Retail Sale Id 1181537',32875.00,0.00,0.00,62.50,1125.00,'2022-02-28 17:26:43','',''),(2614962,'1','187','939',418,'Retail Sale Id 1181538',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 17:27:46','',''),(2614963,'1','187','939',418,'Retail Sale Id 1181539',1898.40,0.00,0.00,3.39,176.28,'2022-02-28 17:29:04','',''),(2614964,'1','187','939',418,'Retail Sale Id 1181540',1500.80,0.00,0.00,2.68,139.36,'2022-02-28 17:41:06','',''),(2614965,'1','187','939',418,'Retail Sale Id 1181541',1500.80,0.00,0.00,2.68,139.36,'2022-02-28 17:45:15','',''),(2614966,'1','187','939',418,'Retail Sale Id 1181542',13150.00,0.00,0.00,25.00,450.00,'2022-02-28 17:48:07','',''),(2614967,'1','187','939',418,'Retail Sale Id 1181543',2800.00,0.00,0.00,5.00,260.00,'2022-02-28 17:53:50','',''),(2614968,'1','187','939',418,'Retail Sale Id 1181544',2800.00,0.00,0.00,5.00,260.00,'2022-02-28 17:55:16','',''),(2614969,'1','187','939',418,'Retail Sale Id 1181545',3399.20,0.00,0.00,6.07,315.64,'2022-02-28 17:59:00','',''),(2614970,'1','187','939',418,'Retail Sale Id 1181546',1500.80,0.00,0.00,2.68,139.36,'2022-02-28 17:59:59','',''),(2614971,'1','187','939',418,'Retail Sale Id 1181547',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 18:07:05','',''),(2614972,'1','187','939',418,'Retail Sale Id 1181548',1120.00,0.00,0.00,2.00,104.00,'2022-02-28 18:08:06','',''),(2614973,'1','187','939',418,'Retail Sale Id 1181549',1198.40,0.00,0.00,2.14,111.28,'2022-02-28 18:09:15','',''),(2614974,'1','187','939',418,'Retail Sale Id 1181550',1120.00,0.00,0.00,2.00,104.00,'2022-02-28 18:11:58','',''),(2614975,'1','187','939',418,'Retail Sale Id 1181551',26300.00,0.00,0.00,50.00,900.00,'2022-02-28 18:17:10','',''),(2614976,'1','187','939',418,'Retail Sale Id 1181552',46814.00,0.00,0.00,89.00,1602.00,'2022-02-28 18:18:26','',''),(2614977,'1','187','939',418,'Retail Sale Id 1181553',47340.00,0.00,0.00,90.00,1620.00,'2022-02-28 18:19:19','',''),(2614978,'1','187','939',418,'Retail Sale Id 1181554',1702.40,0.00,0.00,3.04,158.08,'2022-02-28 18:19:55','',''),(2614979,'1','187','939',418,'Retail Sale Id 1181555',2800.00,0.00,0.00,5.00,260.00,'2022-02-28 18:21:43','',''),(2614980,'1','187','939',418,'Retail Sale Id 1181556',1002.40,0.00,0.00,1.79,93.08,'2022-02-28 18:23:25','',''),(2614981,'1','187','939',418,'Retail Sale Id 1181557',1120.00,0.00,0.00,2.00,104.00,'2022-02-28 18:25:15','',''),(2614982,'1','187','939',418,'Retail Sale Id 1181558',6300.00,0.00,0.00,11.25,585.00,'2022-02-28 18:26:07','',''),(2614983,'1','187','939',418,'Retail Sale Id 1181559',17606.40,0.00,0.00,31.44,1634.88,'2022-02-28 18:34:01','',''),(2614984,'1','187','939',418,'Retail Sale Id 1181560',14728.00,0.00,0.00,28.00,504.00,'2022-03-01 09:07:50','',''),(2614985,'1','187','939',418,'Retail Sale Id 1181561',3600.80,0.00,0.00,6.43,334.36,'2022-03-01 09:12:08','',''),(2614986,'1','187','939',418,'Retail Sale Id 1181563',26300.00,0.00,0.00,50.00,900.00,'2022-03-01 09:29:15','',''),(2614987,'1','187','939',418,'Retail Sale Id 1181564',52600.00,0.00,0.00,100.00,1800.00,'2022-03-01 09:31:28','',''),(2614988,'1','187','939',418,'Retail Sale Id 1181565',78900.00,0.00,0.00,150.00,2700.00,'2022-03-01 09:38:58','',''),(2614989,'1','187','939',418,'Retail Sale Id 1181566',52600.00,0.00,0.00,100.00,1800.00,'2022-03-01 09:50:08','',''),(2614990,'1','187','939',418,'Retail Sale Id 1181567',52600.00,0.00,0.00,100.00,1800.00,'2022-03-01 09:51:19','',''),(2614991,'1','187','939',418,'Retail Sale Id 1181568',1999.20,0.00,0.00,3.57,185.64,'2022-03-01 09:54:02','',''),(2614992,'1','187','939',418,'Retail Sale Id 1181569',3001.60,0.00,0.00,5.36,278.72,'2022-03-01 10:01:03','',''),(2614993,'1','187','939',418,'Retail Sale Id 1181570',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 10:04:36','',''),(2614994,'1','187','939',418,'Retail Sale Id 1181571',1702.40,0.00,0.00,3.04,158.08,'2022-03-01 10:10:17','',''),(2614995,'1','187','939',418,'Retail Sale Id 1181572',18410.00,0.00,0.00,35.00,630.00,'2022-03-01 10:11:42','',''),(2614996,'1','187','939',418,'Retail Sale Id 1181573',1500.80,0.00,0.00,2.68,139.36,'2022-03-01 10:12:52','',''),(2614997,'1','187','939',418,'Retail Sale Id 1181574',78900.00,0.00,0.00,150.00,2700.00,'2022-03-01 10:14:00','',''),(2614998,'1','187','939',418,'Retail Sale Id 1181575',26300.00,0.00,0.00,50.00,900.00,'2022-03-01 10:17:04','',''),(2614999,'1','187','939',418,'Retail Sale Id 1181576',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 10:17:59','',''),(2615000,'1','187','939',418,'Retail Sale Id 1181577',131500.00,0.00,0.00,250.00,4500.00,'2022-03-01 10:57:35','',''),(2615001,'1','187','939',418,'Retail Sale Id 1181578',105200.00,0.00,0.00,200.00,3600.00,'2022-03-01 11:01:45','',''),(2615002,'1','187','939',418,'Retail Sale Id 1181579',2251.20,0.00,0.00,4.02,209.04,'2022-03-01 12:40:35','',''),(2615003,'1','187','939',418,'Retail Sale Id 1181580',78900.00,0.00,0.00,150.00,2700.00,'2022-03-01 12:57:57','',''),(2615004,'1','187','939',418,'Retail Sale Id 1181581',78900.00,0.00,0.00,150.00,2700.00,'2022-03-01 12:59:07','',''),(2615005,'1','187','939',418,'Retail Sale Id 1181582',78900.00,0.00,0.00,150.00,2700.00,'2022-03-01 13:00:05','',''),(2615006,'1','187','939',418,'Retail Sale Id 1181583',2800.00,0.00,0.00,5.00,260.00,'2022-03-01 13:54:36','',''),(2615007,'1','187','939',418,'Retail Sale Id 1181584',3399.20,0.00,0.00,6.07,315.64,'2022-03-01 14:02:37','',''),(2615008,'1','187','939',418,'Retail Sale Id 1181585',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 14:13:30','',''),(2615009,'1','187','939',418,'Retail Sale Id 1181586',1797.60,0.00,0.00,3.21,166.92,'2022-03-01 14:22:44','',''),(2615010,'1','187','939',418,'Retail Sale Id 1181587',3399.20,0.00,0.00,6.07,315.64,'2022-03-01 14:40:28','',''),(2615011,'1','187','939',418,'Retail Sale Id 1181588',52600.00,0.00,0.00,100.00,1800.00,'2022-03-01 15:16:05','',''),(2615012,'1','187','939',418,'Retail Sale Id 1181589',1601.60,0.00,0.00,2.86,148.72,'2022-03-01 15:26:11','',''),(2615013,'1','187','939',418,'Retail Sale Id 1181590',2800.00,0.00,0.00,5.00,260.00,'2022-03-01 15:46:42','',''),(2615014,'1','187','939',418,'Retail Sale Id 1181591',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 15:49:16','',''),(2615015,'1','187','939',418,'Retail Sale Id 1181592',3399.20,0.00,0.00,6.07,315.64,'2022-03-01 16:15:50','',''),(2615016,'1','187','939',418,'Retail Sale Id 1181593',1601.60,0.00,0.00,2.86,148.72,'2022-03-01 16:16:50','',''),(2615017,'1','187','939',418,'Retail Sale Id 1181594',3399.20,0.00,0.00,6.07,315.64,'2022-03-01 16:38:23','',''),(2615018,'1','187','939',418,'Retail Sale Id 1181595',2800.00,0.00,0.00,5.00,260.00,'2022-03-01 16:49:56','',''),(2615019,'1','187','939',418,'Retail Sale Id 1181596',1198.40,0.00,0.00,2.14,111.28,'2022-03-01 16:57:39','',''),(2615020,'1','187','939',418,'Retail Sale Id 1181597',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 17:07:44','',''),(2615021,'1','187','939',418,'Retail Sale Id 1181598',1702.40,0.00,0.00,3.04,158.08,'2022-03-01 17:09:14','',''),(2615022,'1','187','939',418,'Retail Sale Id 1181599',26300.00,0.00,0.00,50.00,900.00,'2022-03-01 17:19:19','',''),(2615023,'1','187','939',418,'Retail Sale Id 1181600',2251.20,0.00,0.00,4.02,209.04,'2022-03-01 17:29:05','',''),(2615024,'1','187','939',418,'Retail Sale Id 1181601',105200.00,0.00,0.00,200.00,3600.00,'2022-03-01 17:34:58','',''),(2615025,'1','187','939',418,'Retail Sale Id 1181602',341900.00,0.00,0.00,650.00,11700.00,'2022-03-01 17:36:02','',''),(2615026,'1','187','939',418,'Retail Sale Id 1181603',117298.00,0.00,0.00,223.00,4014.00,'2022-03-01 17:37:04','',''),(2615027,'1','187','939',418,'Retail Sale Id 1181604',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 17:39:12','',''),(2615028,'1','187','939',418,'Retail Sale Id 1181605',1702.40,0.00,0.00,3.04,158.08,'2022-03-01 17:41:29','',''),(2615029,'1','187','939',418,'Retail Sale Id 1181606',1999.20,0.00,0.00,3.57,185.64,'2022-03-01 18:00:28','',''),(2615030,'1','187','939',418,'Retail Sale Id 1181607',1002.40,0.00,0.00,1.79,93.08,'2022-03-01 18:06:52','',''),(2615031,'1','187','939',418,'Retail Sale Id 1181608',12101.60,0.00,0.00,21.61,1123.72,'2022-03-01 18:19:24','',''),(2615032,'1','187','939',418,'Retail Sale Id 1181609',1702.40,0.00,0.00,3.04,158.08,'2022-03-02 08:27:04','',''),(2615033,'1','187','939',418,'Retail Sale Id 1181610',1702.40,0.00,0.00,3.04,158.08,'2022-03-02 08:28:04','',''),(2615034,'1','187','939',418,'Retail Sale Id 1181611',1002.40,0.00,0.00,1.79,93.08,'2022-03-02 08:29:03','',''),(2615035,'1','187','939',418,'Retail Sale Id 1181612',1702.40,0.00,0.00,3.04,158.08,'2022-03-02 08:43:19','',''),(2615036,'1','187','939',418,'Retail Sale Id 1181613',3399.20,0.00,0.00,6.07,315.64,'2022-03-02 09:00:42','',''),(2615037,'1','187','939',418,'Retail Sale Id 1181614',1702.40,0.00,0.00,3.04,158.08,'2022-03-02 09:08:24','',''),(2615038,'1','187','939',418,'Retail Sale Id 1181615',26300.00,0.00,0.00,50.00,900.00,'2022-03-02 09:10:46','',''),(2615039,'1','187','939',418,'Retail Sale Id 1181616',52600.00,0.00,0.00,100.00,1800.00,'2022-03-02 09:18:28','',''),(2615040,'1','187','939',418,'Retail Sale Id 1181617',26300.00,0.00,0.00,50.00,900.00,'2022-03-02 09:28:41','',''),(2615041,'1','187','939',418,'Retail Sale Id 1181618',91524.00,0.00,0.00,174.00,3132.00,'2022-03-02 09:34:22','',''),(2615042,'1','187','939',418,'Retail Sale Id 1181619',2251.20,0.00,0.00,4.02,209.04,'2022-03-02 10:07:36','',''),(2615043,'1','187','939',418,'Retail Sale Id 1181620',21040.00,0.00,0.00,40.00,720.00,'2022-03-02 10:17:25','',''),(2615044,'1','187','939',418,'Retail Sale Id 1181621',1002.40,0.00,0.00,1.79,93.08,'2022-03-02 10:21:09','',''),(2615045,'1','187','939',418,'Retail Sale Id 1181622',105200.00,0.00,0.00,200.00,3600.00,'2022-03-02 10:26:46','',''),(2615046,'1','187','939',418,'Retail Sale Id 1181623',131500.00,0.00,0.00,250.00,4500.00,'2022-03-02 10:27:48','',''),(2615047,'1','187','939',418,'Retail Sale Id 1181624',1500.80,0.00,0.00,2.68,139.36,'2022-03-02 10:28:59','',''),(2615048,'1','187','939',418,'Retail Sale Id 1181625',82582.00,0.00,0.00,157.00,2826.00,'2022-03-02 11:13:09','',''),(2615049,'1','187','939',418,'Retail Sale Id 1181626',1120.00,0.00,0.00,2.00,104.00,'2022-03-02 11:16:40','',''),(2615050,'1','187','939',418,'Retail Sale Id 1181627',3001.60,0.00,0.00,5.36,278.72,'2022-03-02 11:32:15','',''),(2615051,'1','187','939',418,'Retail Sale Id 1181628',31034.00,0.00,0.00,59.00,1062.00,'2022-03-02 11:34:26','',''),(2615052,'1','187','939',418,'Retail Sale Id 1181629',31560.00,0.00,0.00,60.00,1080.00,'2022-03-02 11:46:59','',''),(2615053,'1','187','939',418,'Retail Sale Id 1181630',57860.00,0.00,0.00,110.00,1980.00,'2022-03-02 11:52:34','',''),(2615054,'1','187','939',418,'Retail Sale Id 1181631',52600.00,0.00,0.00,100.00,1800.00,'2022-03-02 11:56:16','',''),(2615055,'1','187','939',418,'Retail Sale Id 1181632',5000.80,0.00,0.00,8.93,464.36,'2022-03-02 12:07:10','',''),(2615056,'1','187','939',418,'Retail Sale Id 1181633',1002.40,0.00,0.00,1.79,93.08,'2022-03-02 12:09:46','',''),(2615057,'1','187','939',418,'Retail Sale Id 1181634',3500.00,0.00,0.00,6.25,325.00,'2022-03-02 12:13:59','',''),(2615058,'1','187','939',418,'Retail Sale Id 1181635',1120.00,0.00,0.00,2.00,104.00,'2022-03-02 12:41:43','',''),(2615059,'1','187','939',418,'Retail Sale Id 1181636',1198.40,0.00,0.00,2.14,111.28,'2022-03-02 12:45:35','',''),(2615060,'1','187','939',418,'Retail Sale Id 1181637',31560.00,0.00,0.00,60.00,1080.00,'2022-03-02 12:52:45','',''),(2615061,'1','187','939',418,'Retail Sale Id 1181638',31302.26,0.00,0.00,59.51,1071.18,'2022-03-02 13:06:43','',''),(2615062,'1','187','939',418,'Retail Sale Id 1181639',3001.60,0.00,0.00,5.36,278.72,'2022-03-02 13:11:08','',''),(2615063,'1','187','939',418,'Retail Sale Id 1181640',1120.00,0.00,0.00,2.00,104.00,'2022-03-02 13:12:09','',''),(2615064,'1','187','939',418,'Retail Sale Id 1181642',6838.00,0.00,0.00,13.00,234.00,'2022-03-02 13:16:12','',''),(2615065,'1','187','939',418,'Retail Sale Id 1181643',2497.60,0.00,0.00,4.46,231.92,'2022-03-02 13:56:16','',''),(2615066,'1','187','939',418,'Retail Sale Id 1181644',1198.40,0.00,0.00,2.14,111.28,'2022-03-02 14:23:30','',''),(2615067,'1','187','939',418,'Retail Sale Id 1181645',5600.00,0.00,0.00,10.00,520.00,'2022-03-02 14:26:58','',''),(2615068,'1','187','939',418,'Retail Sale Id 1181646',1500.80,0.00,0.00,2.68,139.36,'2022-03-02 14:58:42','',''),(2615069,'1','187','939',418,'Retail Sale Id 1181647',18410.00,0.00,0.00,35.00,630.00,'2022-03-02 15:07:45','',''),(2615070,'1','187','939',418,'Retail Sale Id 1181648',1999.20,0.00,0.00,3.57,185.64,'2022-03-02 15:31:25','',''),(2615071,'1','187','939',418,'Retail Sale Id 1181649',1120.00,0.00,0.00,2.00,104.00,'2022-03-02 15:35:16','',''),(2615072,'1','187','939',418,'Retail Sale Id 1181650',1002.40,0.00,0.00,1.79,93.08,'2022-03-02 15:48:37','',''),(2615073,'1','187','939',418,'Retail Sale Id 1181651',1500.80,0.00,0.00,2.68,139.36,'2022-03-02 17:03:13','',''),(2615074,'1','187','939',418,'Retail Sale Id 1181652',1702.40,0.00,0.00,3.04,158.08,'2022-03-02 17:04:24','',''),(2615075,'1','187','939',418,'Retail Sale Id 1181653',1702.40,0.00,0.00,3.04,158.08,'2022-03-02 17:19:53','',''),(2615076,'1','187','939',418,'Retail Sale Id 1181654',2251.20,0.00,0.00,4.02,209.04,'2022-03-02 17:28:10','',''),(2615077,'1','187','939',418,'Retail Sale Id 1181655',1198.40,0.00,0.00,2.14,111.28,'2022-03-02 17:31:59','',''),(2615078,'1','187','939',418,'Retail Sale Id 1181656',599.20,0.00,0.00,1.07,55.64,'2022-03-02 17:35:55','',''),(2615079,'1','187','939',418,'Retail Sale Id 1181657',1002.40,0.00,0.00,1.79,93.08,'2022-03-02 17:52:58','',''),(2615080,'1','187','939',418,'Retail Sale Id 1181658',1002.40,0.00,0.00,1.79,93.08,'2022-03-02 17:53:58','',''),(2615081,'1','187','939',418,'Retail Sale Id 1181659',44973.60,0.00,0.00,80.31,4176.12,'2022-03-02 18:14:10','',''),(2615082,'1','187','939',418,'Retail Sale Id 1181661',6575.00,0.00,0.00,12.50,225.00,'2022-03-02 18:19:59','',''),(2615083,'1','187','939',418,'Retail Sale Id 1181662',78900.00,0.00,0.00,150.00,2700.00,'2022-03-02 18:21:22','',''),(2615084,'1','187','939',418,'Retail Sale Id 1181663',23769.94,0.00,0.00,45.19,813.42,'2022-03-02 18:23:03','',''),(2615085,'1','187','939',418,'Return of Retail Sale Id 1181642',0.00,6838.00,13.00,0.00,-234.00,'2022-03-02 18:36:13','',''),(2615086,'1','187','939',418,'Retail Sale Id 1181664',6880.08,0.00,0.00,13.08,235.44,'2022-03-02 18:37:31','',''),(2615087,'1','187','939',418,'Return of Retail Sale Id 1181628',0.00,31034.00,59.00,0.00,-1062.00,'2022-03-02 18:41:26','',''),(2615088,'1','187','939',418,'Retail Sale Id 1181666',4734.00,0.00,0.00,9.00,162.00,'2022-03-02 18:42:39','',''),(2615089,'1','187','939',418,'Return of Retail Sale Id 1181659',0.00,44973.60,80.31,0.00,-4176.12,'2022-03-02 18:44:46','',''),(2615090,'1','187','939',418,'Retail Sale Id 1181667',67.20,0.00,0.00,0.12,6.24,'2022-03-02 18:45:48','',''),(2615091,'1','187','939',418,'Retail Sale Id 1181668',37648.80,0.00,0.00,67.23,3495.96,'2022-03-02 18:46:44','',''),(2615092,'1','187','939',418,'Retail Sale Id 1181669',7258.80,0.00,0.00,13.80,248.40,'2022-03-02 18:51:20','',''),(2615093,'1','187','939',418,'Retail Sale Id 1181670',1198.40,0.00,0.00,2.14,111.28,'2022-03-03 08:32:29','',''),(2615094,'1','187','939',418,'Retail Sale Id 1181671',2200.80,0.00,0.00,3.93,204.36,'2022-03-03 08:43:46','',''),(2615095,'1','187','939',418,'Retail Sale Id 1181672',2800.00,0.00,0.00,5.00,260.00,'2022-03-03 09:10:53','',''),(2615096,'1','187','939',418,'Retail Sale Id 1181673',1702.40,0.00,0.00,3.04,158.08,'2022-03-03 09:14:36','',''),(2615097,'1','187','939',418,'Retail Sale Id 1181674',1500.80,0.00,0.00,2.68,139.36,'2022-03-03 09:19:34','',''),(2615098,'1','187','939',418,'Retail Sale Id 1181675',1120.00,0.00,0.00,2.00,104.00,'2022-03-03 09:23:39','',''),(2615099,'1','187','939',418,'Retail Sale Id 1181676',6575.00,0.00,0.00,12.50,225.00,'2022-03-03 09:28:11','',''),(2615100,'1','187','939',418,'Retail Sale Id 1181677',1999.20,0.00,0.00,3.57,185.64,'2022-03-03 09:29:53','',''),(2615101,'1','187','939',418,'Retail Sale Id 1181678',52600.00,0.00,0.00,100.00,1800.00,'2022-03-03 09:37:58','',''),(2615102,'1','187','939',418,'Retail Sale Id 1181679',52600.00,0.00,0.00,100.00,1800.00,'2022-03-03 09:39:31','',''),(2615103,'1','187','939',418,'Retail Sale Id 1181680',105200.00,0.00,0.00,200.00,3600.00,'2022-03-03 09:49:40','',''),(2615104,'1','187','939',418,'Retail Sale Id 1181682',105200.00,0.00,0.00,200.00,3600.00,'2022-03-03 09:51:24','',''),(2615105,'1','187','939',418,'Retail Sale Id 1181683',1002.40,0.00,0.00,1.79,93.08,'2022-03-03 09:55:05','',''),(2615106,'1','187','939',418,'Retail Sale Id 1181684',1999.20,0.00,0.00,3.57,185.64,'2022-03-03 09:56:10','',''),(2615107,'1','187','939',418,'Retail Sale Id 1181685',78900.00,0.00,0.00,150.00,2700.00,'2022-03-03 09:58:23','',''),(2615108,'1','187','939',418,'Retail Sale Id 1181686',78900.00,0.00,0.00,150.00,2700.00,'2022-03-03 10:03:22','',''),(2615109,'1','187','939',418,'Retail Sale Id 1181687',700.00,0.00,0.00,1.25,65.00,'2022-03-03 10:05:22','',''),(2615110,'1','187','939',418,'Retail Sale Id 1181688',52600.00,0.00,0.00,100.00,1800.00,'2022-03-03 10:08:46','',''),(2615111,'1','187','939',418,'Retail Sale Id 1181689',30508.00,0.00,0.00,58.00,1044.00,'2022-03-03 10:30:28','',''),(2615112,'1','187','939',418,'Retail Sale Id 1181690',3399.20,0.00,0.00,6.07,315.64,'2022-03-03 10:51:04','',''),(2615113,'1','187','939',418,'Retail Sale Id 1181691',3001.60,0.00,0.00,5.36,278.72,'2022-03-03 10:52:52','',''),(2615114,'1','187','939',418,'Retail Sale Id 1181692',1500.80,0.00,0.00,2.68,139.36,'2022-03-03 10:53:49','',''),(2615115,'1','187','939',418,'Retail Sale Id 1181694',2800.00,0.00,0.00,5.00,260.00,'2022-03-03 10:55:43','',''),(2615116,'1','187','939',418,'Retail Sale Id 1181695',52600.00,0.00,0.00,100.00,1800.00,'2022-03-03 11:23:56','',''),(2615117,'1','187','939',418,'Retail Sale Id 1181696',26300.00,0.00,0.00,50.00,900.00,'2022-03-03 11:27:12','',''),(2615118,'1','187','939',418,'Retail Sale Id 1181697',26300.00,0.00,0.00,50.00,900.00,'2022-03-03 11:29:07','',''),(2615119,'1','187','939',418,'Retail Sale Id 1181698',700.00,0.00,0.00,1.25,65.00,'2022-03-03 11:38:11','',''),(2615120,'1','187','939',418,'Retail Sale Id 1181699',1999.20,0.00,0.00,3.57,185.64,'2022-03-03 11:55:09','',''),(2615121,'1','187','939',418,'Retail Sale Id 1181700',1702.40,0.00,0.00,3.04,158.08,'2022-03-03 11:58:05','',''),(2615122,'1','187','939',418,'Retail Sale Id 1181701',1702.40,0.00,0.00,3.04,158.08,'2022-03-03 11:59:36','',''),(2615123,'1','187','939',418,'Retail Sale Id 1181702',7364.00,0.00,0.00,14.00,252.00,'2022-03-03 12:23:16','',''),(2615124,'1','187','939',418,'Retail Sale Id 1181703',1999.20,0.00,0.00,3.57,185.64,'2022-03-03 12:47:37','',''),(2615125,'1','187','939',418,'Retail Sale Id 1181704',52600.00,0.00,0.00,100.00,1800.00,'2022-03-03 12:49:03','',''),(2615126,'1','187','939',418,'Retail Sale Id 1181705',78900.00,0.00,0.00,150.00,2700.00,'2022-03-03 12:50:15','',''),(2615127,'1','187','939',418,'Retail Sale Id 1181706',1702.40,0.00,0.00,3.04,158.08,'2022-03-03 12:51:20','',''),(2615128,'1','187','939',418,'Retail Sale Id 1181707',105200.00,0.00,0.00,200.00,3600.00,'2022-03-03 12:57:53','',''),(2615129,'1','187','939',418,'Retail Sale Id 1181708',105200.00,0.00,0.00,200.00,3600.00,'2022-03-03 12:59:09','',''),(2615130,'1','187','939',418,'Retail Sale Id 1181709',78900.00,0.00,0.00,150.00,2700.00,'2022-03-03 13:07:36','',''),(2615131,'1','187','939',418,'Retail Sale Id 1181710',26300.00,0.00,0.00,50.00,900.00,'2022-03-03 13:13:27','',''),(2615132,'1','187','939',418,'Retail Sale Id 1181711',78900.00,0.00,0.00,150.00,2700.00,'2022-03-03 13:18:46','',''),(2615133,'1','187','939',418,'Retail Sale Id 1181712',26300.00,0.00,0.00,50.00,900.00,'2022-03-03 13:20:58','',''),(2615134,'1','187','939',418,'Retail Sale Id 1181713',26300.00,0.00,0.00,50.00,900.00,'2022-03-03 13:23:19','',''),(2615135,'1','187','939',418,'Retail Sale Id 1181714',78900.00,0.00,0.00,150.00,2700.00,'2022-03-03 13:25:06','',''),(2615136,'1','187','939',418,'Retail Sale Id 1181715',1120.00,0.00,0.00,2.00,104.00,'2022-03-03 13:35:14','',''),(2615137,'1','187','939',418,'Retail Sale Id 1181716',52600.00,0.00,0.00,100.00,1800.00,'2022-03-03 13:37:08','',''),(2615138,'1','187','939',418,'Retail Sale Id 1181717',21040.00,0.00,0.00,40.00,720.00,'2022-03-03 13:49:30','',''),(2615139,'1','187','939',418,'Retail Sale Id 1181718',100992.00,0.00,0.00,192.00,3456.00,'2022-03-03 13:56:18','',''),(2615140,'1','187','939',418,'Retail Sale Id 1181719',3399.20,0.00,0.00,6.07,315.64,'2022-03-03 14:21:36','',''),(2615141,'1','187','939',418,'Retail Sale Id 1181720',3399.20,0.00,0.00,6.07,315.64,'2022-03-03 14:23:34','',''),(2615142,'1','187','939',418,'Retail Sale Id 1181721',1500.80,0.00,0.00,2.68,139.36,'2022-03-03 14:25:39','',''),(2615143,'1','187','939',418,'Retail Sale Id 1181722',1120.00,0.00,0.00,2.00,104.00,'2022-03-03 14:27:28','',''),(2615144,'1','187','939',418,'Retail Sale Id 1181723',42080.00,0.00,0.00,80.00,1440.00,'2022-03-03 14:56:01','',''),(2615145,'1','187','939',418,'Retail Sale Id 1181724',27352.00,0.00,0.00,52.00,936.00,'2022-03-03 15:26:43','',''),(2615146,'1','187','939',418,'Retail Sale Id 1181725',6395.20,0.00,0.00,11.42,593.84,'2022-03-03 15:28:03','',''),(2615147,'1','187','939',418,'Distributed to OPERATIONAL LOSS for sales id:332540',190347.60,0.00,0.00,374.70,0.00,'2022-03-03 20:00:05','',''),(2615148,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,12552680.00,24710.00,0.00,0.00,'2022-03-04 08:47:43','',''),(2615149,'1','187',NULL,418,'Reception corrector for bridging 123745',0.00,0.00,0.00,24710.00,0.00,'2022-03-04 08:49:37','',''),(2615150,'1','187','939',418,'Received from bridging 123745',0.00,0.00,24710.00,0.00,0.00,'2022-03-04 08:49:37','',''),(2615151,'1','187','939',418,'Retail Sale Id 1181726',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 08:51:14','',''),(2615152,'1','187','939',418,'Retail Sale Id 1181727',1097.60,0.00,0.00,1.96,101.92,'2022-03-04 08:53:36','',''),(2615153,'1','187','939',418,'Retail Sale Id 1181728',1601.60,0.00,0.00,2.86,148.72,'2022-03-04 08:57:58','',''),(2615154,'1','187','939',418,'Retail Sale Id 1181729',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 08:58:54','',''),(2615155,'1','187','939',418,'Retail Sale Id 1181730',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 09:01:20','',''),(2615156,'1','187','939',418,'Retail Sale Id 1181731',1500.80,0.00,0.00,2.68,139.36,'2022-03-04 09:05:04','',''),(2615157,'1','187','939',418,'Retail Sale Id 1181732',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 09:16:33','',''),(2615158,'1','187','939',418,'Retail Sale Id 1181733',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 09:18:54','',''),(2615159,'1','187','939',418,'Retail Sale Id 1181734',78900.00,0.00,0.00,150.00,2700.00,'2022-03-04 09:21:02','',''),(2615160,'1','187','939',418,'Retail Sale Id 1181735',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 09:22:52','',''),(2615161,'1','187','939',418,'Retail Sale Id 1181736',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 09:26:09','',''),(2615162,'1','187','939',418,'Retail Sale Id 1181737',7000.00,0.00,0.00,12.50,650.00,'2022-03-04 09:27:12','',''),(2615163,'1','187','939',418,'Retail Sale Id 1181738',2497.60,0.00,0.00,4.46,231.92,'2022-03-04 09:28:40','',''),(2615164,'1','187','939',418,'Retail Sale Id 1181740',31034.00,0.00,0.00,59.00,1062.00,'2022-03-04 09:31:33','',''),(2615165,'1','187','939',418,'Retail Sale Id 1181741',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 09:33:55','',''),(2615166,'1','187','939',418,'Retail Sale Id 1181742',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 09:35:15','',''),(2615167,'1','187','939',418,'Retail Sale Id 1181743',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 09:36:09','',''),(2615168,'1','187','939',418,'Retail Sale Id 1181744',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 09:41:49','',''),(2615169,'1','187','939',418,'Retail Sale Id 1181745',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 09:45:12','',''),(2615170,'1','187','939',418,'Retail Sale Id 1181746',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 10:06:32','',''),(2615171,'1','187','939',418,'Retail Sale Id 1181747',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 10:08:25','',''),(2615172,'1','187','939',418,'Retail Sale Id 1181748',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 10:09:57','',''),(2615173,'1','187','939',418,'Retail Sale Id 1181749',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 10:11:57','',''),(2615174,'1','187','939',418,'Retail Sale Id 1181750',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 10:13:05','',''),(2615175,'1','187','939',418,'Retail Sale Id 1181751',1120.00,0.00,0.00,2.00,104.00,'2022-03-04 10:16:11','',''),(2615176,'1','187','939',418,'Retail Sale Id 1181752',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 10:18:11','',''),(2615177,'1','187','939',418,'Retail Sale Id 1181753',105200.00,0.00,0.00,200.00,3600.00,'2022-03-04 10:20:41','',''),(2615178,'1','187','939',418,'Retail Sale Id 1181754',5997.60,0.00,0.00,10.71,556.92,'2022-03-04 10:22:08','',''),(2615179,'1','187','939',418,'Retail Sale Id 1181755',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 10:39:03','',''),(2615180,'1','187','939',418,'Retail Sale Id 1181756',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 10:48:26','',''),(2615181,'1','187','939',418,'Retail Sale Id 1181757',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 10:50:00','',''),(2615182,'1','187','939',418,'Retail Sale Id 1181758',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 10:55:30','',''),(2615183,'1','187','939',418,'Retail Sale Id 1181759',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 11:00:49','',''),(2615184,'1','187','939',418,'Retail Sale Id 1181760',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 11:12:32','',''),(2615185,'1','187','939',418,'Retail Sale Id 1181761',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 11:24:29','',''),(2615186,'1','187','939',418,'Retail Sale Id 1181762',78900.00,0.00,0.00,150.00,2700.00,'2022-03-04 11:25:49','',''),(2615187,'1','187','939',418,'Retail Sale Id 1181764',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 11:27:02','',''),(2615188,'1','187','939',418,'Retail Sale Id 1181765',1500.80,0.00,0.00,2.68,139.36,'2022-03-04 11:27:51','',''),(2615189,'1','187','939',418,'Retail Sale Id 1181766',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 11:30:54','',''),(2615190,'1','187','939',418,'Retail Sale Id 1181767',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 11:38:09','',''),(2615191,'1','187','939',418,'Retail Sale Id 1181768',3998.40,0.00,0.00,7.14,371.28,'2022-03-04 11:40:48','',''),(2615192,'1','187','939',418,'Retail Sale Id 1181769',21040.00,0.00,0.00,40.00,720.00,'2022-03-04 11:44:03','',''),(2615193,'1','187','939',418,'Retail Sale Id 1181770',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 11:44:56','',''),(2615194,'1','187','939',418,'Retail Sale Id 1181771',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 11:48:11','',''),(2615195,'1','187','939',418,'Retail Sale Id 1181772',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 12:14:04','',''),(2615196,'1','187','939',418,'Retail Sale Id 1181773',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 12:24:49','',''),(2615197,'1','187','939',418,'Retail Sale Id 1181774',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 12:25:42','',''),(2615198,'1','187','939',418,'Retail Sale Id 1181775',1500.80,0.00,0.00,2.68,139.36,'2022-03-04 12:40:28','',''),(2615199,'1','187','939',418,'Retail Sale Id 1181776',1500.80,0.00,0.00,2.68,139.36,'2022-03-04 12:45:46','',''),(2615200,'1','187','939',418,'Retail Sale Id 1181777',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 12:55:07','',''),(2615201,'1','187','939',418,'Retail Sale Id 1181778',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 12:57:34','',''),(2615202,'1','187','939',418,'Retail Sale Id 1181779',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 13:12:30','',''),(2615203,'1','187','939',418,'Retail Sale Id 1181780',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 13:15:57','',''),(2615204,'1','187','939',418,'Retail Sale Id 1181781',22618.00,0.00,0.00,43.00,774.00,'2022-03-04 13:22:37','',''),(2615205,'1','187','939',418,'Retail Sale Id 1181782',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 13:27:43','',''),(2615206,'1','187','939',418,'Retail Sale Id 1181783',5000.80,0.00,0.00,8.93,464.36,'2022-03-04 13:29:09','',''),(2615207,'1','187','939',418,'Retail Sale Id 1181784',78900.00,0.00,0.00,150.00,2700.00,'2022-03-04 13:32:08','',''),(2615208,'1','187','939',418,'Retail Sale Id 1181785',1120.00,0.00,0.00,2.00,104.00,'2022-03-04 13:40:30','',''),(2615209,'1','187','939',418,'Retail Sale Id 1181786',2800.00,0.00,0.00,5.00,260.00,'2022-03-04 13:44:24','',''),(2615210,'1','187','939',418,'Retail Sale Id 1181787',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 13:46:16','',''),(2615211,'1','187','939',418,'Retail Sale Id 1181788',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 13:49:39','',''),(2615212,'1','187','939',418,'Retail Sale Id 1181790',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 13:51:43','',''),(2615213,'1','187','939',418,'Retail Sale Id 1181791',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 14:17:00','',''),(2615214,'1','187','939',418,'Retail Sale Id 1181792',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 14:18:51','',''),(2615215,'1','187','939',418,'Retail Sale Id 1181793',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 14:24:50','',''),(2615216,'1','187','939',418,'Retail Sale Id 1181794',1120.00,0.00,0.00,2.00,104.00,'2022-03-04 14:25:55','',''),(2615217,'1','187','939',418,'Retail Sale Id 1181795',78900.00,0.00,0.00,150.00,2700.00,'2022-03-04 14:46:27','',''),(2615218,'1','187','939',418,'Retail Sale Id 1181796',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 14:47:35','',''),(2615219,'1','187','939',418,'Retail Sale Id 1181797',105200.00,0.00,0.00,200.00,3600.00,'2022-03-04 14:48:25','',''),(2615220,'1','187','939',418,'Retail Sale Id 1181798',26300.00,0.00,0.00,50.00,900.00,'2022-03-04 14:50:22','',''),(2615221,'1','187','939',418,'Retail Sale Id 1181799',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 14:58:15','',''),(2615222,'1','187','939',418,'Retail Sale Id 1181800',3001.60,0.00,0.00,5.36,278.72,'2022-03-04 15:02:16','',''),(2615223,'1','187','939',418,'Retail Sale Id 1181801',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 15:03:07','',''),(2615224,'1','187','939',418,'Retail Sale Id 1181802',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 15:05:36','',''),(2615225,'1','187','939',418,'Retail Sale Id 1181804',36820.00,0.00,0.00,70.00,1260.00,'2022-03-04 15:23:18','',''),(2615226,'1','187','939',418,'Retail Sale Id 1181805',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 15:25:32','',''),(2615227,'1','187','939',418,'Retail Sale Id 1181806',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 15:26:23','',''),(2615228,'1','187','939',418,'Retail Sale Id 1181807',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 15:27:22','',''),(2615229,'1','187','939',418,'Retail Sale Id 1181808',2497.60,0.00,0.00,4.46,231.92,'2022-03-04 15:29:00','',''),(2615230,'1','187','939',418,'Retail Sale Id 1181809',1299.20,0.00,0.00,2.32,120.64,'2022-03-04 15:34:56','',''),(2615231,'1','187','939',418,'Retail Sale Id 1181810',1568.00,0.00,0.00,2.80,145.60,'2022-03-04 15:46:10','',''),(2615232,'1','187','939',418,'Retail Sale Id 1181811',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 15:47:50','',''),(2615233,'1','187','939',418,'Retail Sale Id 1181812',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:00:08','',''),(2615234,'1','187','939',418,'Retail Sale Id 1181813',2251.20,0.00,0.00,4.02,209.04,'2022-03-04 16:04:50','',''),(2615235,'1','187','939',418,'Retail Sale Id 1181814',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 16:06:41','',''),(2615236,'1','187','939',418,'Retail Sale Id 1181815',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 16:16:48','',''),(2615237,'1','187','939',418,'Retail Sale Id 1181816',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:22:27','',''),(2615238,'1','187','939',418,'Retail Sale Id 1181817',3001.60,0.00,0.00,5.36,278.72,'2022-03-04 16:23:27','',''),(2615239,'1','187','939',418,'Retail Sale Id 1181818',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:25:37','',''),(2615240,'1','187','939',418,'Retail Sale Id 1181819',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:34:54','',''),(2615241,'1','187','939',418,'Retail Sale Id 1181820',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:40:13','',''),(2615242,'1','187','939',418,'Retail Sale Id 1181821',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:41:19','',''),(2615243,'1','187','939',418,'Retail Sale Id 1181822',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:42:14','',''),(2615244,'1','187','939',418,'Retail Sale Id 1181823',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:42:55','',''),(2615245,'1','187','939',418,'Retail Sale Id 1181824',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:43:48','',''),(2615246,'1','187','939',418,'Retail Sale Id 1181825',2800.00,0.00,0.00,5.00,260.00,'2022-03-04 16:46:36','',''),(2615247,'1','187','939',418,'Retail Sale Id 1181826',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 16:47:22','',''),(2615248,'1','187','939',418,'Retail Sale Id 1181827',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 16:48:33','',''),(2615249,'1','187','939',418,'Retail Sale Id 1181828',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 16:49:40','',''),(2615250,'1','187','939',418,'Retail Sale Id 1181829',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 16:53:33','',''),(2615251,'1','187','939',418,'Retail Sale Id 1181830',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 16:55:02','',''),(2615252,'1','187','939',418,'Retail Sale Id 1181831',3998.40,0.00,0.00,7.14,371.28,'2022-03-04 16:56:34','',''),(2615253,'1','187','939',418,'Retail Sale Id 1181832',1400.00,0.00,0.00,2.50,130.00,'2022-03-04 16:58:28','',''),(2615254,'1','187','939',418,'Retail Sale Id 1181833',2800.00,0.00,0.00,5.00,260.00,'2022-03-04 16:59:48','',''),(2615255,'1','187','939',418,'Retail Sale Id 1181834',1500.80,0.00,0.00,2.68,139.36,'2022-03-04 17:03:38','',''),(2615256,'1','187','939',418,'Retail Sale Id 1181835',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 17:12:46','',''),(2615257,'1','187','939',418,'Retail Sale Id 1181836',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 17:17:07','',''),(2615258,'1','187','939',418,'Retail Sale Id 1181838',1120.00,0.00,0.00,2.00,104.00,'2022-03-04 17:23:27','',''),(2615259,'1','187','939',418,'Retail Sale Id 1181839',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 17:27:29','',''),(2615260,'1','187','939',418,'Retail Sale Id 1181840',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 17:40:32','',''),(2615261,'1','187','939',418,'Retail Sale Id 1181841',1198.40,0.00,0.00,2.14,111.28,'2022-03-04 17:43:40','',''),(2615262,'1','187','939',418,'Retail Sale Id 1181842',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 17:44:52','',''),(2615263,'1','187','939',418,'Retail Sale Id 1181843',1999.20,0.00,0.00,3.57,185.64,'2022-03-04 17:50:32','',''),(2615264,'1','187','939',418,'Retail Sale Id 1181844',1299.20,0.00,0.00,2.32,120.64,'2022-03-04 17:51:32','',''),(2615265,'1','187','939',418,'Retail Sale Id 1181845',52600.00,0.00,0.00,100.00,1800.00,'2022-03-04 17:54:42','',''),(2615266,'1','187','939',418,'Retail Sale Id 1181846',3001.60,0.00,0.00,5.36,278.72,'2022-03-04 18:01:02','',''),(2615267,'1','187','939',418,'Retail Sale Id 1181847',141246.00,0.00,0.00,171.00,54378.00,'2022-03-04 18:03:06','',''),(2615268,'1','187','939',418,'Return of Retail Sale Id 1181847',0.00,141246.00,171.00,0.00,-54378.00,'2022-03-04 18:04:08','',''),(2615269,'1','187','939',418,'Retail Sale Id 1181848',89946.00,0.00,0.00,171.00,3078.00,'2022-03-04 18:04:48','',''),(2615270,'1','187','939',418,'Retail Sale Id 1181849',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 18:05:49','',''),(2615271,'1','187','939',418,'Retail Sale Id 1181850',1797.60,0.00,0.00,3.21,166.92,'2022-03-04 18:06:40','',''),(2615272,'1','187','939',418,'Retail Sale Id 1181851',1120.00,0.00,0.00,2.00,104.00,'2022-03-04 18:07:22','',''),(2615273,'1','187','939',418,'Retail Sale Id 1181852',3399.20,0.00,0.00,6.07,315.64,'2022-03-04 18:08:31','',''),(2615274,'1','187','939',418,'Retail Sale Id 1181853',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 18:11:04','',''),(2615275,'1','187','939',418,'Retail Sale Id 1181855',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 18:12:58','',''),(2615276,'1','187','939',418,'Retail Sale Id 1181856',20897.98,0.00,0.00,39.73,715.14,'2022-03-04 18:18:14','',''),(2615277,'1','187','939',418,'Retail Sale Id 1181857',1702.40,0.00,0.00,3.04,158.08,'2022-03-04 18:19:17','',''),(2615278,'1','187','939',418,'Retail Sale Id 1181858',1002.40,0.00,0.00,1.79,93.08,'2022-03-04 18:20:41','',''),(2615279,'1','187','939',418,'Retail Sale Id 1181859',14486.04,0.00,0.00,27.54,495.72,'2022-03-04 18:46:07','',''),(2615280,'1','187','939',418,'Retail Sale Id 1181860',157800.00,0.00,0.00,300.00,5400.00,'2022-03-04 18:47:26','',''),(2615281,'1','187','939',418,'Retail Sale Id 1181861',10029.60,0.00,0.00,17.91,931.32,'2022-03-04 18:50:38','',''),(2615282,'1','187','939',418,'Retail Sale Id 1181862',52247.58,0.00,0.00,99.33,1787.94,'2022-03-04 18:53:27','',''),(2615283,'1','187','939',418,'Retail Sale Id 1181863',119665.00,0.00,0.00,227.50,4095.00,'2022-03-04 18:55:49','',''),(2615284,'1','187','939',418,'Retail Sale Id 1181864',78900.00,0.00,0.00,150.00,2700.00,'2022-03-05 08:43:08','',''),(2615285,'1','187','939',418,'Retail Sale Id 1181865',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 08:43:59','',''),(2615286,'1','187','939',418,'Retail Sale Id 1181866',3001.60,0.00,0.00,5.36,278.72,'2022-03-05 08:45:07','',''),(2615287,'1','187','939',418,'Retail Sale Id 1181867',3500.00,0.00,0.00,6.25,325.00,'2022-03-05 08:46:40','',''),(2615288,'1','187','939',418,'Retail Sale Id 1181868',2497.60,0.00,0.00,4.46,231.92,'2022-03-05 08:49:00','',''),(2615289,'1','187','939',418,'Retail Sale Id 1181869',1198.40,0.00,0.00,2.14,111.28,'2022-03-05 08:49:43','',''),(2615290,'1','187','939',418,'Retail Sale Id 1181870',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 08:50:56','',''),(2615291,'1','187','939',418,'Retail Sale Id 1181871',3399.20,0.00,0.00,6.07,315.64,'2022-03-05 08:51:47','',''),(2615292,'1','187','939',418,'Retail Sale Id 1181872',2301.60,0.00,0.00,4.11,213.72,'2022-03-05 09:00:57','',''),(2615293,'1','187','939',418,'Retail Sale Id 1181873',1702.40,0.00,0.00,3.04,158.08,'2022-03-05 09:26:26','',''),(2615294,'1','187','939',418,'Retail Sale Id 1181874',3298.40,0.00,0.00,5.89,306.28,'2022-03-05 09:27:29','',''),(2615295,'1','187','939',418,'Retail Sale Id 1181875',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 09:41:12','',''),(2615296,'1','187','939',418,'Retail Sale Id 1181876',105200.00,0.00,0.00,200.00,3600.00,'2022-03-05 09:42:10','',''),(2615297,'1','187','939',418,'Retail Sale Id 1181877',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 09:43:27','',''),(2615298,'1','187','939',418,'Retail Sale Id 1181878',131500.00,0.00,0.00,250.00,4500.00,'2022-03-05 09:58:16','',''),(2615299,'1','187','939',418,'Retail Sale Id 1181879',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 10:01:02','',''),(2615300,'1','187','939',418,'Retail Sale Id 1181880',2800.00,0.00,0.00,5.00,260.00,'2022-03-05 10:02:42','',''),(2615301,'1','187','939',418,'Retail Sale Id 1181882',1702.40,0.00,0.00,3.04,158.08,'2022-03-05 10:37:52','',''),(2615302,'1','187','939',418,'Retail Sale Id 1181883',3399.20,0.00,0.00,6.07,315.64,'2022-03-05 10:38:59','',''),(2615303,'1','187','939',418,'Retail Sale Id 1181884',1198.40,0.00,0.00,2.14,111.28,'2022-03-05 10:40:30','',''),(2615304,'1','187','939',418,'Retail Sale Id 1181885',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 10:42:34','',''),(2615305,'1','187','939',418,'Retail Sale Id 1181886',2800.00,0.00,0.00,5.00,260.00,'2022-03-05 10:58:00','',''),(2615306,'1','187','939',418,'Retail Sale Id 1181887',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 11:02:17','',''),(2615307,'1','187','939',418,'Retail Sale Id 1181888',1002.40,0.00,0.00,1.79,93.08,'2022-03-05 11:16:36','',''),(2615308,'1','187','939',418,'Retail Sale Id 1181889',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 11:18:57','',''),(2615309,'1','187','939',418,'Retail Sale Id 1181890',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 11:23:37','',''),(2615310,'1','187','939',418,'Retail Sale Id 1181891',1680.00,0.00,0.00,3.00,156.00,'2022-03-05 11:32:23','',''),(2615311,'1','187','939',418,'Retail Sale Id 1181892',11998.06,0.00,0.00,22.81,410.58,'2022-03-05 11:33:42','',''),(2615312,'1','187','939',418,'Retail Sale Id 1181893',2497.60,0.00,0.00,4.46,231.92,'2022-03-05 11:34:28','',''),(2615313,'1','187','939',418,'Retail Sale Id 1181894',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 11:51:08','',''),(2615314,'1','187','939',418,'Retail Sale Id 1181895',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 11:54:19','',''),(2615315,'1','187','939',418,'Retail Sale Id 1181896',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 12:11:23','',''),(2615316,'1','187','939',418,'Retail Sale Id 1181897',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 12:12:10','',''),(2615317,'1','187','939',418,'Retail Sale Id 1181898',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 12:15:59','',''),(2615318,'1','187','939',418,'Retail Sale Id 1181899',1500.80,0.00,0.00,2.68,139.36,'2022-03-05 12:17:01','',''),(2615319,'1','187','939',418,'Retail Sale Id 1181900',2497.60,0.00,0.00,4.46,231.92,'2022-03-05 12:30:04','',''),(2615320,'1','187','939',418,'Retail Sale Id 1181901',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 12:41:08','',''),(2615321,'1','187','939',418,'Retail Sale Id 1181902',38997.64,0.00,0.00,74.14,1334.52,'2022-03-05 12:42:32','',''),(2615322,'1','187','939',418,'Retail Sale Id 1181903',105200.00,0.00,0.00,200.00,3600.00,'2022-03-05 12:46:54','',''),(2615323,'1','187','939',418,'Retail Sale Id 1181904',1702.40,0.00,0.00,3.04,158.08,'2022-03-05 12:49:32','',''),(2615324,'1','187','939',418,'Retail Sale Id 1181905',1999.20,0.00,0.00,3.57,185.64,'2022-03-05 12:56:32','',''),(2615325,'1','187','939',418,'Retail Sale Id 1181906',1002.40,0.00,0.00,1.79,93.08,'2022-03-05 13:23:51','',''),(2615326,'1','187','939',418,'Retail Sale Id 1181907',1999.20,0.00,0.00,3.57,185.64,'2022-03-05 13:25:46','',''),(2615327,'1','187','939',418,'Retail Sale Id 1181908',52600.00,0.00,0.00,100.00,1800.00,'2022-03-05 13:28:41','',''),(2615328,'1','187','939',418,'Retail Sale Id 1181909',1002.40,0.00,0.00,1.79,93.08,'2022-03-05 13:37:12','',''),(2615329,'1','187','939',418,'Retail Sale Id 1181910',2800.00,0.00,0.00,5.00,260.00,'2022-03-05 13:41:42','',''),(2615330,'1','187','939',418,'Retail Sale Id 1181911',1999.20,0.00,0.00,3.57,185.64,'2022-03-05 16:22:34','',''),(2615331,'1','187','939',418,'Retail Sale Id 1181912',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 16:31:13','',''),(2615332,'1','187','939',418,'Retail Sale Id 1181913',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 16:32:47','',''),(2615333,'1','187','939',418,'Retail Sale Id 1181914',1797.60,0.00,0.00,3.21,166.92,'2022-03-05 16:47:06','',''),(2615334,'1','187','939',418,'Retail Sale Id 1181915',1702.40,0.00,0.00,3.04,158.08,'2022-03-05 17:07:15','',''),(2615335,'1','187','939',418,'Retail Sale Id 1181916',3399.20,0.00,0.00,6.07,315.64,'2022-03-05 17:27:14','',''),(2615336,'1','187','939',418,'Retail Sale Id 1181917',2497.60,0.00,0.00,4.46,231.92,'2022-03-05 17:28:30','',''),(2615337,'1','187','939',418,'Retail Sale Id 1181920',3399.20,0.00,0.00,6.07,315.64,'2022-03-05 17:32:08','',''),(2615338,'1','187','939',418,'Retail Sale Id 1181922',3399.20,0.00,0.00,6.07,315.64,'2022-03-05 17:35:06','',''),(2615339,'1','187','939',418,'Retail Sale Id 1181923',5000.80,0.00,0.00,8.93,464.36,'2022-03-05 17:45:48','',''),(2615340,'1','187','939',418,'Retail Sale Id 1181924',46061.82,0.00,0.00,87.57,1576.26,'2022-03-05 17:47:26','',''),(2615341,'1','187','939',418,'Retail Sale Id 1181925',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 17:47:57','',''),(2615342,'1','187','939',418,'Retail Sale Id 1181926',26205.32,0.00,0.00,49.82,896.76,'2022-03-05 17:48:32','',''),(2615343,'1','187','939',418,'Retail Sale Id 1181927',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 17:49:57','',''),(2615344,'1','187','939',418,'Retail Sale Id 1181928',26300.00,0.00,0.00,50.00,900.00,'2022-03-05 17:50:30','',''),(2615345,'1','187','939',418,'Retail Sale Id 1181929',2548.00,0.00,0.00,4.55,236.60,'2022-03-05 18:24:37','',''),(2615346,'1','187','939',418,'Retail Sale Id 1181930',3399.20,0.00,0.00,6.07,315.64,'2022-03-06 10:20:47','',''),(2615347,'1','187','939',418,'Retail Sale Id 1181931',67328.00,0.00,0.00,128.00,2304.00,'2022-03-06 10:21:49','',''),(2615348,'1','187','939',418,'Retail Sale Id 1181932',61016.00,0.00,0.00,116.00,2088.00,'2022-03-06 10:22:40','',''),(2615349,'1','187','939',418,'Retail Sale Id 1181933',30508.00,0.00,0.00,58.00,1044.00,'2022-03-06 10:23:24','',''),(2615350,'1','187','939',418,'Retail Sale Id 1181934',52600.00,0.00,0.00,100.00,1800.00,'2022-03-06 10:25:19','',''),(2615351,'1','187','939',418,'Retail Sale Id 1181935',3998.40,0.00,0.00,7.14,371.28,'2022-03-06 10:25:55','',''),(2615352,'1','187','939',418,'Retail Sale Id 1181936',26300.00,0.00,0.00,50.00,900.00,'2022-03-06 10:44:25','',''),(2615353,'1','187','939',418,'Retail Sale Id 1181938',1002.40,0.00,0.00,1.79,93.08,'2022-03-06 11:00:01','',''),(2615354,'1','187','939',418,'Retail Sale Id 1181939',26300.00,0.00,0.00,50.00,900.00,'2022-03-06 11:03:26','',''),(2615355,'1','187','939',418,'Retail Sale Id 1181940',1500.80,0.00,0.00,2.68,139.36,'2022-03-06 11:04:23','',''),(2615356,'1','187','939',418,'Retail Sale Id 1181941',1198.40,0.00,0.00,2.14,111.28,'2022-03-06 11:10:46','',''),(2615357,'1','187','939',418,'Retail Sale Id 1181942',1702.40,0.00,0.00,3.04,158.08,'2022-03-06 11:19:04','',''),(2615358,'1','187','939',418,'Retail Sale Id 1181943',1999.20,0.00,0.00,3.57,185.64,'2022-03-06 11:24:57','',''),(2615359,'1','187','939',418,'Retail Sale Id 1181944',22307.66,0.00,0.00,42.41,763.38,'2022-03-06 11:44:18','',''),(2615360,'1','187','939',418,'Retail Sale Id 1181945',52600.00,0.00,0.00,100.00,1800.00,'2022-03-06 11:56:00','',''),(2615361,'1','187','939',418,'Retail Sale Id 1181946',30508.00,0.00,0.00,58.00,1044.00,'2022-03-06 11:57:21','',''),(2615362,'1','187','939',418,'Retail Sale Id 1181947',1702.40,0.00,0.00,3.04,158.08,'2022-03-06 12:00:06','',''),(2615363,'1','187','939',418,'Retail Sale Id 1181948',21040.00,0.00,0.00,40.00,720.00,'2022-03-06 12:07:02','',''),(2615364,'1','187','939',418,'Retail Sale Id 1181949',1002.40,0.00,0.00,1.79,93.08,'2022-03-06 12:16:32','',''),(2615365,'1','187','939',418,'Retail Sale Id 1181950',7840.00,0.00,0.00,14.00,728.00,'2022-03-06 12:27:26','',''),(2615366,'1','187','939',418,'Retail Sale Id 1181951',3399.20,0.00,0.00,6.07,315.64,'2022-03-06 12:33:27','',''),(2615367,'1','187','939',418,'Retail Sale Id 1181952',1999.20,0.00,0.00,3.57,185.64,'2022-03-06 12:38:32','',''),(2615368,'1','187','939',418,'Retail Sale Id 1181953',3399.20,0.00,0.00,6.07,315.64,'2022-03-06 12:57:01','',''),(2615369,'1','187','939',418,'Retail Sale Id 1181954',2497.60,0.00,0.00,4.46,231.92,'2022-03-06 13:10:17','',''),(2615370,'1','187','939',418,'Retail Sale Id 1181955',1500.80,0.00,0.00,2.68,139.36,'2022-03-06 13:22:26','',''),(2615371,'1','187','939',418,'Retail Sale Id 1181956',1120.00,0.00,0.00,2.00,104.00,'2022-03-06 13:28:39','',''),(2615372,'1','187','939',418,'Retail Sale Id 1181957',1120.00,0.00,0.00,2.00,104.00,'2022-03-06 13:36:44','',''),(2615373,'1','187','939',418,'Retail Sale Id 1181958',1002.40,0.00,0.00,1.79,93.08,'2022-03-06 13:38:41','',''),(2615374,'1','187','939',418,'Retail Sale Id 1181959',2800.00,0.00,0.00,5.00,260.00,'2022-03-06 13:43:02','',''),(2615375,'1','187','939',418,'Retail Sale Id 1181960',21040.00,0.00,0.00,40.00,720.00,'2022-03-06 13:47:19','',''),(2615376,'1','187','939',418,'Retail Sale Id 1181962',105200.00,0.00,0.00,200.00,3600.00,'2022-03-06 13:59:27','',''),(2615377,'1','187','939',418,'Retail Sale Id 1181963',105200.00,0.00,0.00,200.00,3600.00,'2022-03-06 14:00:32','',''),(2615378,'1','187','939',418,'Retail Sale Id 1181964',105200.00,0.00,0.00,200.00,3600.00,'2022-03-06 14:02:05','',''),(2615379,'1','187','939',418,'Retail Sale Id 1181965',1999.20,0.00,0.00,3.57,185.64,'2022-03-06 14:14:51','',''),(2615380,'1','187','939',418,'Retail Sale Id 1181967',3001.60,0.00,0.00,5.36,278.72,'2022-03-06 14:27:36','',''),(2615381,'1','187','939',418,'Retail Sale Id 1181968',1002.40,0.00,0.00,1.79,93.08,'2022-03-06 14:54:12','',''),(2615382,'1','187','939',418,'Retail Sale Id 1181969',5101.60,0.00,0.00,9.11,473.72,'2022-03-06 15:06:18','',''),(2615383,'1','187','939',418,'Retail Sale Id 1181970',1500.80,0.00,0.00,2.68,139.36,'2022-03-06 15:54:08','',''),(2615384,'1','187','939',418,'Retail Sale Id 1181971',1002.40,0.00,0.00,1.79,93.08,'2022-03-06 16:01:54','',''),(2615385,'1','187','939',418,'Retail Sale Id 1181972',19619.80,0.00,0.00,37.30,671.40,'2022-03-06 16:03:15','',''),(2615386,'1','187','939',418,'Retail Sale Id 1181973',4208.00,0.00,0.00,8.00,144.00,'2022-03-06 16:10:51','',''),(2615387,'1','187','939',418,'Retail Sale Id 1181974',26300.00,0.00,0.00,50.00,900.00,'2022-03-06 16:11:36','',''),(2615388,'1','187','939',418,'Return of Retail Sale Id 1181973',0.00,4208.00,8.00,0.00,-144.00,'2022-03-06 16:13:02','',''),(2615389,'1','187','939',418,'Retail Sale Id 1181975',4208.00,0.00,0.00,8.00,144.00,'2022-03-06 16:13:33','',''),(2615390,'1','187','939',418,'Retail Sale Id 1181976',5919.20,0.00,0.00,10.57,549.64,'2022-03-06 16:15:48','',''),(2615391,'1','187','939',418,'Retail Sale Id 1181978',3500.00,0.00,0.00,6.25,325.00,'2022-03-07 08:45:40','',''),(2615392,'1','187','939',418,'Retail Sale Id 1181979',1999.20,0.00,0.00,3.57,185.64,'2022-03-07 08:49:10','',''),(2615393,'1','187','939',418,'Retail Sale Id 1181977',7498.40,0.00,0.00,13.39,696.28,'2022-03-07 08:51:06','',''),(2615394,'1','187','939',418,'Retail Sale Id 1181980',1500.80,0.00,0.00,2.68,139.36,'2022-03-07 08:52:16','',''),(2615395,'1','187','939',418,'Retail Sale Id 1181981',3500.00,0.00,0.00,6.25,325.00,'2022-03-07 08:55:23','',''),(2615396,'1','187','939',418,'Retail Sale Id 1181982',105200.00,0.00,0.00,200.00,3600.00,'2022-03-07 08:56:45','',''),(2615397,'1','187','939',418,'Retail Sale Id 1181983',105200.00,0.00,0.00,200.00,3600.00,'2022-03-07 08:57:32','',''),(2615398,'1','187','939',418,'Retail Sale Id 1181984',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 08:58:16','',''),(2615399,'1','187','939',418,'Retail Sale Id 1181985',105200.00,0.00,0.00,200.00,3600.00,'2022-03-07 09:08:25','',''),(2615400,'1','187','939',418,'Retail Sale Id 1181986',78900.00,0.00,0.00,150.00,2700.00,'2022-03-07 09:09:09','',''),(2615401,'1','187','939',418,'Retail Sale Id 1181987',105200.00,0.00,0.00,200.00,3600.00,'2022-03-07 09:15:59','',''),(2615402,'1','187','939',418,'Retail Sale Id 1181988',1500.80,0.00,0.00,2.68,139.36,'2022-03-07 09:18:49','',''),(2615403,'1','187','939',418,'Retail Sale Id 1181989',31034.00,0.00,0.00,59.00,1062.00,'2022-03-07 09:21:05','',''),(2615404,'1','187','939',418,'Retail Sale Id 1181990',47340.00,0.00,0.00,90.00,1620.00,'2022-03-07 09:22:45','',''),(2615405,'1','187','939',418,'Retail Sale Id 1181991',2800.00,0.00,0.00,5.00,260.00,'2022-03-07 09:31:14','',''),(2615406,'1','187','939',418,'Retail Sale Id 1181992',19988.00,0.00,0.00,38.00,684.00,'2022-03-07 09:32:54','',''),(2615407,'1','187','939',418,'Retail Sale Id 1181993',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 09:43:20','',''),(2615408,'1','187','939',418,'Retail Sale Id 1181994',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 09:47:35','',''),(2615409,'1','187','939',418,'Retail Sale Id 1181995',1797.60,0.00,0.00,3.21,166.92,'2022-03-07 09:54:15','',''),(2615410,'1','187','939',418,'Retail Sale Id 1181996',105200.00,0.00,0.00,200.00,3600.00,'2022-03-07 09:56:30','',''),(2615411,'1','187','939',418,'Retail Sale Id 1181997',1797.60,0.00,0.00,3.21,166.92,'2022-03-07 09:58:32','',''),(2615412,'1','187','939',418,'Retail Sale Id 1181998',2800.00,0.00,0.00,5.00,260.00,'2022-03-07 10:02:57','',''),(2615413,'1','187','939',418,'Retail Sale Id 1181999',91524.00,0.00,0.00,174.00,3132.00,'2022-03-07 10:23:10','',''),(2615414,'1','187','939',418,'Retail Sale Id 1182000',31560.00,0.00,0.00,60.00,1080.00,'2022-03-07 10:26:55','',''),(2615415,'1','187','939',418,'Retail Sale Id 1182001',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 10:29:27','',''),(2615416,'1','187','939',418,'Retail Sale Id 1182002',157800.00,0.00,0.00,300.00,5400.00,'2022-03-07 10:31:01','',''),(2615417,'1','187','939',418,'Retail Sale Id 1182003',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 10:36:53','',''),(2615418,'1','187','939',418,'Retail Sale Id 1182004',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 11:00:51','',''),(2615419,'1','187','939',418,'Retail Sale Id 1182005',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 11:01:37','',''),(2615420,'1','187','939',418,'Retail Sale Id 1182006',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 11:02:40','',''),(2615421,'1','187','939',418,'Retail Sale Id 1182007',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 11:22:12','',''),(2615422,'1','187','939',418,'Retail Sale Id 1182008',21040.00,0.00,0.00,40.00,720.00,'2022-03-07 11:24:41','',''),(2615423,'1','187','939',418,'Retail Sale Id 1182009',31560.00,0.00,0.00,60.00,1080.00,'2022-03-07 11:29:53','',''),(2615424,'1','187','939',418,'Retail Sale Id 1182010',3001.60,0.00,0.00,5.36,278.72,'2022-03-07 11:31:48','',''),(2615425,'1','187','939',418,'Retail Sale Id 1182011',21040.00,0.00,0.00,40.00,720.00,'2022-03-07 11:35:42','',''),(2615426,'1','187','939',418,'Retail Sale Id 1182012',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 11:38:03','',''),(2615427,'1','187','939',418,'Retail Sale Id 1182013',2497.60,0.00,0.00,4.46,231.92,'2022-03-07 11:51:00','',''),(2615428,'1','187','939',418,'Retail Sale Id 1182014',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 11:59:35','',''),(2615429,'1','187','939',418,'Retail Sale Id 1182015',5600.00,0.00,0.00,10.00,520.00,'2022-03-07 12:08:11','',''),(2615430,'1','187','939',418,'Retail Sale Id 1182016',7890.00,0.00,0.00,15.00,270.00,'2022-03-07 12:11:43','',''),(2615431,'1','187','939',418,'Retail Sale Id 1182017',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 12:13:31','',''),(2615432,'1','187','939',418,'Retail Sale Id 1182018',21040.00,0.00,0.00,40.00,720.00,'2022-03-07 12:16:06','',''),(2615433,'1','187','939',418,'Retail Sale Id 1182019',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 12:18:32','',''),(2615434,'1','187','939',418,'Retail Sale Id 1182020',131500.00,0.00,0.00,250.00,4500.00,'2022-03-07 12:21:04','',''),(2615435,'1','187','939',418,'Retail Sale Id 1182021',105200.00,0.00,0.00,200.00,3600.00,'2022-03-07 12:23:51','',''),(2615436,'1','187','939',418,'Retail Sale Id 1182022',15001.52,0.00,0.00,28.52,513.36,'2022-03-07 12:25:18','',''),(2615437,'1','187','939',418,'Retail Sale Id 1182023',131500.00,0.00,0.00,250.00,4500.00,'2022-03-07 12:33:10','',''),(2615438,'1','187','939',418,'Retail Sale Id 1182024',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 12:43:27','',''),(2615439,'1','187','939',418,'Retail Sale Id 1182025',1120.00,0.00,0.00,2.00,104.00,'2022-03-07 12:52:30','',''),(2615440,'1','187','939',418,'Retail Sale Id 1182026',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 12:59:01','',''),(2615441,'1','187','939',418,'Retail Sale Id 1182027',1999.20,0.00,0.00,3.57,185.64,'2022-03-07 13:09:33','',''),(2615442,'1','187','939',418,'Retail Sale Id 1182028',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 13:24:02','',''),(2615443,'1','187','939',418,'Retail Sale Id 1182029',78900.00,0.00,0.00,150.00,2700.00,'2022-03-07 13:33:03','',''),(2615444,'1','187','939',418,'Retail Sale Id 1182030',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 13:35:28','',''),(2615445,'1','187','939',418,'Retail Sale Id 1182031',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 13:36:49','',''),(2615446,'1','187','939',418,'Retail Sale Id 1182032',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 13:37:48','',''),(2615447,'1','187','939',418,'Retail Sale Id 1182033',122032.00,0.00,0.00,232.00,4176.00,'2022-03-07 14:05:02','',''),(2615448,'1','187','939',418,'Retail Sale Id 1182034',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 14:06:14','',''),(2615449,'1','187','939',418,'Retail Sale Id 1182035',52600.00,0.00,0.00,100.00,1800.00,'2022-03-07 14:07:10','',''),(2615450,'1','187','939',418,'Retail Sale Id 1182036',1601.60,0.00,0.00,2.86,148.72,'2022-03-07 14:33:48','',''),(2615451,'1','187','939',418,'Retail Sale Id 1182037',1500.80,0.00,0.00,2.68,139.36,'2022-03-07 14:35:40','',''),(2615452,'1','187','939',418,'Retail Sale Id 1182038',3399.20,0.00,0.00,6.07,315.64,'2022-03-07 14:36:27','',''),(2615453,'1','187','939',418,'Retail Sale Id 1182039',3399.20,0.00,0.00,6.07,315.64,'2022-03-07 14:53:18','',''),(2615454,'1','187','939',418,'Retail Sale Id 1182040',7000.00,0.00,0.00,12.50,650.00,'2022-03-07 15:01:20','',''),(2615455,'1','187','939',418,'Retail Sale Id 1182041',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 15:05:04','',''),(2615456,'1','187','939',418,'Retail Sale Id 1182042',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 15:21:56','',''),(2615457,'1','187','939',418,'Retail Sale Id 1182043',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 15:34:35','',''),(2615458,'1','187','939',418,'Retail Sale Id 1182044',1500.80,0.00,0.00,2.68,139.36,'2022-03-07 15:35:25','',''),(2615459,'1','187','939',418,'Retail Sale Id 1182045',2800.00,0.00,0.00,5.00,260.00,'2022-03-07 15:36:16','',''),(2615460,'1','187','939',418,'Retail Sale Id 1182046',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 15:48:41','',''),(2615461,'1','187','939',418,'Retail Sale Id 1182047',1198.40,0.00,0.00,2.14,111.28,'2022-03-07 16:00:35','',''),(2615462,'1','187','939',418,'Retail Sale Id 1182048',1120.00,0.00,0.00,2.00,104.00,'2022-03-07 16:02:48','',''),(2615463,'1','187','939',418,'Retail Sale Id 1182049',22092.00,0.00,0.00,42.00,756.00,'2022-03-07 16:06:17','',''),(2615464,'1','187','939',418,'Retail Sale Id 1182050',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 16:38:34','',''),(2615465,'1','187','939',418,'Retail Sale Id 1182051',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 16:47:03','',''),(2615466,'1','187','939',418,'Retail Sale Id 1182052',2251.20,0.00,0.00,4.02,209.04,'2022-03-07 16:54:19','',''),(2615467,'1','187','939',418,'Retail Sale Id 1182053',1120.00,0.00,0.00,2.00,104.00,'2022-03-07 17:02:24','',''),(2615468,'1','187','939',418,'Retail Sale Id 1182054',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 17:02:52','',''),(2615469,'1','187','939',418,'Retail Sale Id 1182055',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 17:15:14','',''),(2615470,'1','187','939',418,'Retail Sale Id 1182056',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 17:20:00','',''),(2615471,'1','187','939',418,'Retail Sale Id 1182057',78900.00,0.00,0.00,150.00,2700.00,'2022-03-07 17:21:31','',''),(2615472,'1','187','939',418,'Retail Sale Id 1182058',49065.28,0.00,0.00,93.28,1679.04,'2022-03-07 17:22:47','',''),(2615473,'1','187','939',418,'Retail Sale Id 1182059',1198.40,0.00,0.00,2.14,111.28,'2022-03-07 17:23:52','',''),(2615474,'1','187','939',418,'Retail Sale Id 1182060',1198.40,0.00,0.00,2.14,111.28,'2022-03-07 17:27:42','',''),(2615475,'1','187','939',418,'Retail Sale Id 1182061',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 17:37:58','',''),(2615476,'1','187','939',418,'Retail Sale Id 1182062',1198.40,0.00,0.00,2.14,111.28,'2022-03-07 17:38:54','',''),(2615477,'1','187','939',418,'Retail Sale Id 1182063',26300.00,0.00,0.00,50.00,900.00,'2022-03-07 17:40:46','',''),(2615478,'1','187','939',418,'Retail Sale Id 1182064',2301.60,0.00,0.00,4.11,213.72,'2022-03-07 17:42:49','',''),(2615479,'1','187','939',418,'Retail Sale Id 1182065',1002.40,0.00,0.00,1.79,93.08,'2022-03-07 17:48:57','',''),(2615480,'1','187','939',418,'Retail Sale Id 1182066',7000.00,0.00,0.00,12.50,650.00,'2022-03-07 17:53:22','',''),(2615481,'1','187','939',418,'Retail Sale Id 1182067',1702.40,0.00,0.00,3.04,158.08,'2022-03-07 17:57:34','',''),(2615482,'1','187','939',418,'Retail Sale Id 1182068',3371.20,0.00,0.00,6.02,313.04,'2022-03-07 18:06:02','',''),(2615483,'1','187','939',418,'Retail Sale Id 1182069',13150.00,0.00,0.00,25.00,450.00,'2022-03-07 18:07:24','',''),(2615484,'1','187','939',418,'Retail Sale Id 1182070',5000.80,0.00,0.00,8.93,464.36,'2022-03-08 08:41:21','',''),(2615485,'1','187','939',418,'Retail Sale Id 1182071',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 08:45:32','',''),(2615486,'1','187','939',418,'Retail Sale Id 1182072',78900.00,0.00,0.00,150.00,2700.00,'2022-03-08 08:55:10','',''),(2615487,'1','187','939',418,'Retail Sale Id 1182073',3001.60,0.00,0.00,5.36,278.72,'2022-03-08 09:00:06','',''),(2615488,'1','187','939',418,'Retail Sale Id 1182074',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 09:13:18','',''),(2615489,'1','187','939',418,'Retail Sale Id 1182075',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 09:16:21','',''),(2615490,'1','187','939',418,'Retail Sale Id 1182076',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 09:18:18','',''),(2615491,'1','187','939',418,'Retail Sale Id 1182077',21040.00,0.00,0.00,40.00,720.00,'2022-03-08 09:23:27','',''),(2615492,'1','187','939',418,'Retail Sale Id 1182078',1500.80,0.00,0.00,2.68,139.36,'2022-03-08 09:25:35','',''),(2615493,'1','187','939',418,'Retail Sale Id 1182079',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 09:40:02','',''),(2615494,'1','187','939',418,'Retail Sale Id 1182080',78900.00,0.00,0.00,150.00,2700.00,'2022-03-08 09:41:23','',''),(2615495,'1','187','939',418,'Retail Sale Id 1182081',2800.00,0.00,0.00,5.00,260.00,'2022-03-08 09:42:27','',''),(2615496,'1','187','939',418,'Retail Sale Id 1182082',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 09:46:27','',''),(2615497,'1','187','939',418,'Retail Sale Id 1182083',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 09:48:53','',''),(2615498,'1','187','939',418,'Retail Sale Id 1182084',1500.80,0.00,0.00,2.68,139.36,'2022-03-08 09:53:04','',''),(2615499,'1','187','939',418,'Retail Sale Id 1182085',131500.00,0.00,0.00,250.00,4500.00,'2022-03-08 09:59:01','',''),(2615500,'1','187','939',418,'Retail Sale Id 1182086',78900.00,0.00,0.00,150.00,2700.00,'2022-03-08 10:05:54','',''),(2615501,'1','187','939',418,'Retail Sale Id 1182087',105200.00,0.00,0.00,200.00,3600.00,'2022-03-08 10:08:36','',''),(2615502,'1','187','939',418,'Retail Sale Id 1182088',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 10:13:00','',''),(2615503,'1','187','939',418,'Retail Sale Id 1182089',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 10:18:57','',''),(2615504,'1','187','939',418,'Retail Sale Id 1182090',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 10:22:53','',''),(2615505,'1','187','939',418,'Retail Sale Id 1182091',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 10:30:13','',''),(2615506,'1','187','939',418,'Retail Sale Id 1182092',63120.00,0.00,0.00,120.00,2160.00,'2022-03-08 10:36:45','',''),(2615507,'1','187','939',418,'Retail Sale Id 1182093',52600.00,0.00,0.00,100.00,1800.00,'2022-03-08 11:07:51','',''),(2615508,'1','187','939',418,'Retail Sale Id 1182094',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 11:09:31','',''),(2615509,'1','187','939',418,'Retail Sale Id 1182095',52600.00,0.00,0.00,100.00,1800.00,'2022-03-08 11:24:33','',''),(2615510,'1','187','939',418,'Retail Sale Id 1182096',2800.00,0.00,0.00,5.00,260.00,'2022-03-08 11:29:31','',''),(2615511,'1','187','939',418,'Retail Sale Id 1182097',105200.00,0.00,0.00,200.00,3600.00,'2022-03-08 11:34:53','',''),(2615512,'1','187','939',418,'Retail Sale Id 1182098',105200.00,0.00,0.00,200.00,3600.00,'2022-03-08 12:07:38','',''),(2615513,'1','187','939',418,'Retail Sale Id 1182099',52600.00,0.00,0.00,100.00,1800.00,'2022-03-08 12:09:28','',''),(2615514,'1','187','939',418,'Retail Sale Id 1182101',31034.00,0.00,0.00,59.00,1062.00,'2022-03-08 12:11:42','',''),(2615515,'1','187','939',418,'Retail Sale Id 1182102',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 12:20:29','',''),(2615516,'1','187','939',418,'Retail Sale Id 1182103',1797.60,0.00,0.00,3.21,166.92,'2022-03-08 12:24:00','',''),(2615517,'1','187','939',418,'Retail Sale Id 1182104',78900.00,0.00,0.00,150.00,2700.00,'2022-03-08 12:25:26','',''),(2615518,'1','187','939',418,'Retail Sale Id 1182105',1198.40,0.00,0.00,2.14,111.28,'2022-03-08 12:33:53','',''),(2615519,'1','187','939',418,'Retail Sale Id 1182106',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 12:51:17','',''),(2615520,'1','187','939',418,'Retail Sale Id 1182107',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 12:54:53','',''),(2615521,'1','187','939',418,'Retail Sale Id 1182108',1198.40,0.00,0.00,2.14,111.28,'2022-03-08 13:00:01','',''),(2615522,'1','187','939',418,'Retail Sale Id 1182109',1097.60,0.00,0.00,1.96,101.92,'2022-03-08 13:02:58','',''),(2615523,'1','187','939',418,'Retail Sale Id 1182110',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 13:03:54','',''),(2615524,'1','187','939',418,'Retail Sale Id 1182111',2800.00,0.00,0.00,5.00,260.00,'2022-03-08 13:04:22','',''),(2615525,'1','187','939',418,'Retail Sale Id 1182112',5260.00,0.00,0.00,10.00,180.00,'2022-03-08 13:05:42','',''),(2615526,'1','187','939',418,'Retail Sale Id 1182113',3298.40,0.00,0.00,5.89,306.28,'2022-03-08 13:07:18','',''),(2615527,'1','187','939',418,'Retail Sale Id 1182114',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 13:10:29','',''),(2615528,'1','187','939',418,'Retail Sale Id 1182115',3399.20,0.00,0.00,6.07,315.64,'2022-03-08 13:37:14','',''),(2615529,'1','187','939',418,'Retail Sale Id 1182116',52600.00,0.00,0.00,100.00,1800.00,'2022-03-08 13:46:10','',''),(2615530,'1','187','939',418,'Retail Sale Id 1182117',52600.00,0.00,0.00,100.00,1800.00,'2022-03-08 13:47:50','',''),(2615531,'1','187','939',418,'Retail Sale Id 1182118',1999.20,0.00,0.00,3.57,185.64,'2022-03-08 13:48:32','',''),(2615532,'1','187','939',418,'Retail Sale Id 1182119',1999.20,0.00,0.00,3.57,185.64,'2022-03-08 15:01:04','',''),(2615533,'1','187','939',418,'Retail Sale Id 1182120',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 15:03:36','',''),(2615534,'1','187','939',418,'Retail Sale Id 1182121',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 15:04:17','',''),(2615535,'1','187','939',418,'Retail Sale Id 1182122',131500.00,0.00,0.00,250.00,4500.00,'2022-03-08 15:05:16','',''),(2615536,'1','187','939',418,'Retail Sale Id 1182123',131500.00,0.00,0.00,250.00,4500.00,'2022-03-08 15:08:50','',''),(2615537,'1','187','939',418,'Retail Sale Id 1182124',131500.00,0.00,0.00,250.00,4500.00,'2022-03-08 15:19:31','',''),(2615538,'1','187','939',418,'Retail Sale Id 1182125',52600.00,0.00,0.00,100.00,1800.00,'2022-03-08 15:20:43','',''),(2615539,'1','187','939',418,'Retail Sale Id 1182126',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 15:31:36','',''),(2615540,'1','187','939',418,'Retail Sale Id 1182127',26300.00,0.00,0.00,50.00,900.00,'2022-03-08 15:37:07','',''),(2615541,'1','187','939',418,'Retail Sale Id 1182128',3399.20,0.00,0.00,6.07,315.64,'2022-03-08 15:38:03','',''),(2615542,'1','187','939',418,'Retail Sale Id 1182129',86790.00,0.00,0.00,165.00,2970.00,'2022-03-08 16:08:22','',''),(2615543,'1','187','939',418,'Retail Sale Id 1182130',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 17:07:22','',''),(2615544,'1','187','939',418,'Retail Sale Id 1182131',3399.20,0.00,0.00,6.07,315.64,'2022-03-08 17:08:47','',''),(2615545,'1','187','939',418,'Retail Sale Id 1182134',3001.60,0.00,0.00,5.36,278.72,'2022-03-08 17:09:51','',''),(2615546,'1','187','939',418,'Retail Sale Id 1182136',3399.20,0.00,0.00,6.07,315.64,'2022-03-08 17:11:54','',''),(2615547,'1','187','939',418,'Retail Sale Id 1182139',1702.40,0.00,0.00,3.04,158.08,'2022-03-08 17:20:46','',''),(2615548,'1','187','939',418,'Retail Sale Id 1182140',1198.40,0.00,0.00,2.14,111.28,'2022-03-08 17:21:41','',''),(2615549,'1','187','939',418,'Retail Sale Id 1182141',5000.80,0.00,0.00,8.93,464.36,'2022-03-08 17:27:06','',''),(2615550,'1','187','939',418,'Retail Sale Id 1182142',85475.00,0.00,0.00,162.50,2925.00,'2022-03-08 17:38:30','',''),(2615551,'1','187','939',418,'Retail Sale Id 1182143',105200.00,0.00,0.00,200.00,3600.00,'2022-03-08 17:43:27','',''),(2615552,'1','187','939',418,'Retail Sale Id 1182144',166221.26,0.00,0.00,316.01,5688.18,'2022-03-08 17:56:38','',''),(2615553,'1','187','939',418,'Retail Sale Id 1182145',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 17:57:38','',''),(2615554,'1','187','939',418,'Retail Sale Id 1182146',1500.80,0.00,0.00,2.68,139.36,'2022-03-08 17:58:27','',''),(2615555,'1','187','939',418,'Retail Sale Id 1182147',186430.18,0.00,0.00,354.43,6379.74,'2022-03-08 18:01:01','',''),(2615556,'1','187','939',418,'Retail Sale Id 1182148',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 18:02:09','',''),(2615557,'1','187','939',418,'Retail Sale Id 1182149',70052.68,0.00,0.00,133.18,2397.24,'2022-03-08 18:06:04','',''),(2615558,'1','187','939',418,'Retail Sale Id 1182150',1002.40,0.00,0.00,1.79,93.08,'2022-03-08 18:06:40','',''),(2615559,'1','187','939',418,'Retail Sale Id 1182151',99940.00,0.00,0.00,190.00,3420.00,'2022-03-08 18:29:49','',''),(2615560,'1','187','939',418,'Retail Sale Id 1182152',3455.82,0.00,0.00,6.57,118.26,'2022-03-08 19:19:00','',''),(2615561,'1','187','939',418,'Retail Sale Id 1182153',150000.00,0.00,0.00,250.00,23000.00,'2022-03-09 09:36:26','',''),(2615562,'1','187','939',418,'Retail Sale Id 1182154',6999.30,0.00,0.00,11.11,1355.42,'2022-03-09 09:46:10','',''),(2615563,'1','187','939',418,'Retail Sale Id 1182155',2998.80,0.00,0.00,4.76,580.72,'2022-03-09 09:48:35','',''),(2615564,'1','187','939',418,'Retail Sale Id 1182157',21000.00,0.00,0.00,35.00,3220.00,'2022-03-09 10:00:46','',''),(2615565,'1','187','939',418,'Retail Sale Id 1182158',4200.00,0.00,0.00,7.00,644.00,'2022-03-09 10:03:59','',''),(2615566,'1','187','939',418,'Retail Sale Id 1182159',30000.00,0.00,0.00,50.00,4600.00,'2022-03-09 10:06:43','',''),(2615567,'1','187','939',418,'Retail Sale Id 1182160',1902.60,0.00,0.00,3.02,368.44,'2022-03-09 10:08:42','',''),(2615568,'1','187','939',418,'Retail Sale Id 1182161',2501.10,0.00,0.00,3.97,484.34,'2022-03-09 10:16:29','',''),(2615569,'1','187','939',418,'Retail Sale Id 1182162',1001.70,0.00,0.00,1.59,193.98,'2022-03-09 10:17:49','',''),(2615570,'1','187','939',418,'Retail Sale Id 1182163',120000.00,0.00,0.00,200.00,18400.00,'2022-03-09 10:28:46','',''),(2615571,'1','187','939',418,'Retail Sale Id 1182164',1997.10,0.00,0.00,3.17,386.74,'2022-03-09 10:41:43','',''),(2615572,'1','187','939',418,'Retail Sale Id 1182165',1997.10,0.00,0.00,3.17,386.74,'2022-03-09 10:48:52','',''),(2615573,'1','187','939',418,'Retail Sale Id 1182166',3798.90,0.00,0.00,6.03,735.66,'2022-03-09 10:51:24','',''),(2615574,'1','187','939',418,'Retail Sale Id 1182167',108000.00,0.00,0.00,180.00,16560.00,'2022-03-09 10:53:56','',''),(2615575,'1','187','939',418,'Retail Sale Id 1182168',90000.00,0.00,0.00,150.00,13800.00,'2022-03-09 10:54:55','',''),(2615576,'1','187','939',418,'Retail Sale Id 1182169',12000.00,0.00,0.00,20.00,1840.00,'2022-03-09 10:55:55','',''),(2615577,'1','187','939',418,'Retail Sale Id 1182170',3998.40,0.00,0.00,7.14,371.28,'2022-03-09 10:57:34','',''),(2615578,'1','187','939',418,'Retail Sale Id 1182171',1297.80,0.00,0.00,2.06,251.32,'2022-03-09 11:07:55','',''),(2615579,'1','187','939',418,'Retail Sale Id 1182172',1902.60,0.00,0.00,3.02,368.44,'2022-03-09 11:10:26','',''),(2615580,'1','187','939',418,'Retail Sale Id 1182173',1801.80,0.00,0.00,2.86,348.92,'2022-03-09 11:12:00','',''),(2615581,'1','187','939',418,'Retail Sale Id 1182174',60000.00,0.00,0.00,100.00,9200.00,'2022-03-09 11:17:19','',''),(2615582,'1','187','939',418,'Retail Sale Id 1182175',1001.70,0.00,0.00,1.59,193.98,'2022-03-09 11:18:21','',''),(2615583,'1','187','939',418,'Retail Sale Id 1182176',3698.10,0.00,0.00,5.87,716.14,'2022-03-09 11:19:35','',''),(2615584,'1','187','939',418,'Retail Sale Id 1182177',1801.80,0.00,0.00,2.86,348.92,'2022-03-09 11:21:27','',''),(2615585,'1','187','939',418,'Retail Sale Id 1182178',1997.10,0.00,0.00,3.17,386.74,'2022-03-09 11:23:54','',''),(2615586,'1','187','939',418,'Retail Sale Id 1182179',1997.10,0.00,0.00,3.17,386.74,'2022-03-09 11:29:58','',''),(2615587,'1','187','939',418,'Retail Sale Id 1182180',30000.00,0.00,0.00,50.00,4600.00,'2022-03-09 11:32:00','',''),(2615588,'1','187','939',418,'Retail Sale Id 1182181',1260.00,0.00,0.00,2.00,244.00,'2022-03-09 11:35:25','',''),(2615589,'1','187','939',418,'Retail Sale Id 1182182',1001.70,0.00,0.00,1.59,193.98,'2022-03-09 11:41:28','',''),(2615590,'1','187','939',418,'Retail Sale Id 1182183',1001.70,0.00,0.00,1.59,193.98,'2022-03-09 11:53:39','',''),(2615591,'1','187','939',418,'Retail Sale Id 1182184',1002.40,0.00,0.00,1.79,93.08,'2022-03-09 12:02:43','',''),(2615592,'1','187','939',418,'Retail Sale Id 1182185',1001.70,0.00,0.00,1.59,193.98,'2022-03-09 12:11:43','',''),(2615593,'1','187','939',418,'Retail Sale Id 1182186',1797.60,0.00,0.00,3.21,166.92,'2022-03-09 12:18:07','',''),(2615594,'1','187','939',418,'Retail Sale Id 1182187',5052.60,0.00,0.00,8.02,978.44,'2022-03-09 12:35:32','',''),(2615595,'1','187','939',418,'Retail Sale Id 1182188',1260.00,0.00,0.00,2.00,244.00,'2022-03-09 13:07:46','',''),(2615596,'1','187','939',418,'Retail Sale Id 1182189',2601.90,0.00,0.00,4.13,503.86,'2022-03-09 13:09:48','',''),(2615597,'1','187','939',418,'Retail Sale Id 1182190',4000.50,0.00,0.00,6.35,774.70,'2022-03-09 13:13:05','',''),(2615598,'1','187','939',418,'Retail Sale Id 1182191',1001.70,0.00,0.00,1.59,193.98,'2022-03-09 13:16:25','',''),(2615599,'1','187','939',418,'Retail Sale Id 1182192',1198.80,0.00,0.00,3.33,-492.84,'2022-03-09 13:19:29','',''),(2615600,'1','187','939',418,'Retail Sale Id 1182193',1197.00,0.00,0.00,1.90,231.80,'2022-03-09 13:23:00','',''),(2615601,'1','187','939',418,'Retail Sale Id 1182194',90000.00,0.00,0.00,150.00,13800.00,'2022-03-09 13:55:31','',''),(2615602,'1','187','939',418,'Retail Sale Id 1182195',120000.00,0.00,0.00,200.00,18400.00,'2022-03-09 13:58:27','',''),(2615603,'1','187','939',418,'Retail Sale Id 1182196',1902.60,0.00,0.00,3.02,368.44,'2022-03-09 14:39:09','',''),(2615604,'1','187','939',418,'Retail Sale Id 1182197',4284.00,0.00,0.00,7.14,656.88,'2022-03-09 16:06:14','',''),(2615605,'1','187','939',418,'Return of Retail Sale Id 1182170',0.00,3998.40,7.14,0.00,-371.28,'2022-03-09 16:10:24','',''),(2615606,'1','187','939',418,'Return of Retail Sale Id 1182192',0.00,1198.80,3.33,0.00,492.84,'2022-03-09 16:11:28','',''),(2615607,'1','187','939',418,'Return of Retail Sale Id 1182186',0.00,1797.60,3.21,0.00,-166.92,'2022-03-09 16:14:24','',''),(2615608,'1','187','939',418,'Retail Sale Id 1182199',1776.60,0.00,0.00,2.82,344.04,'2022-03-09 16:24:43','',''),(2615609,'1','187','939',418,'Retail Sale Id 1182200',33000.00,0.00,0.00,55.00,5060.00,'2022-03-09 16:26:31','',''),(2615610,'1','187','939',418,'Retail Sale Id 1182201',38172.00,0.00,0.00,63.62,5853.04,'2022-03-09 16:31:00','',''),(2615611,'1','187','939',418,'Retail Sale Id 1182202',1200.00,0.00,0.00,2.00,184.00,'2022-03-09 17:16:41','',''),(2615612,'1','187','939',418,'Retail Sale Id 1182203',60000.00,0.00,0.00,100.00,9200.00,'2022-03-10 09:36:19','',''),(2615613,'1','187','939',418,'Retail Sale Id 1182204',60000.00,0.00,0.00,100.00,9200.00,'2022-03-10 09:42:11','',''),(2615614,'1','187','939',418,'Retail Sale Id 1182205',3600.00,0.00,0.00,6.00,552.00,'2022-03-10 09:43:16','',''),(2615615,'1','187','939',418,'Retail Sale Id 1182206',2952.00,0.00,0.00,4.92,452.64,'2022-03-10 09:45:59','',''),(2615616,'1','187','939',418,'Retail Sale Id 1182207',27745.20,0.00,0.00,44.04,5372.88,'2022-03-10 09:47:31','',''),(2615617,'1','187','939',418,'Retail Sale Id 1182208',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 09:52:54','',''),(2615618,'1','187','939',418,'Retail Sale Id 1182209',70800.00,0.00,0.00,118.00,10856.00,'2022-03-10 09:54:28','',''),(2615619,'1','187','939',418,'Retail Sale Id 1182210',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 10:07:01','',''),(2615620,'1','187','939',418,'Retail Sale Id 1182211',7900.20,0.00,0.00,12.54,1529.88,'2022-03-10 10:09:56','',''),(2615621,'1','187','939',418,'Retail Sale Id 1182212',24000.00,0.00,0.00,40.00,3680.00,'2022-03-10 10:12:24','',''),(2615622,'1','187','939',418,'Retail Sale Id 1182213',30000.00,0.00,0.00,50.00,4600.00,'2022-03-10 10:17:42','',''),(2615623,'1','187','939',418,'Retail Sale Id 1182214',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 10:19:02','',''),(2615624,'1','187','939',418,'Retail Sale Id 1182215',30000.00,0.00,0.00,50.00,4600.00,'2022-03-10 10:28:42','',''),(2615625,'1','187','939',418,'Retail Sale Id 1182216',7900.20,0.00,0.00,12.54,1529.88,'2022-03-10 10:31:02','',''),(2615626,'1','187','939',418,'Retail Sale Id 1182217',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 10:42:02','',''),(2615627,'1','187','939',418,'Retail Sale Id 1182218',90000.00,0.00,0.00,150.00,13800.00,'2022-03-10 10:46:22','',''),(2615628,'1','187','939',418,'Retail Sale Id 1182219',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 10:54:42','',''),(2615629,'1','187','939',418,'Retail Sale Id 1182220',24000.00,0.00,0.00,40.00,3680.00,'2022-03-10 11:00:32','',''),(2615630,'1','187','939',418,'Retail Sale Id 1182221',60000.00,0.00,0.00,100.00,9200.00,'2022-03-10 11:04:02','',''),(2615631,'1','187','939',418,'Retail Sale Id 1182222',30000.00,0.00,0.00,50.00,4600.00,'2022-03-10 11:06:00','',''),(2615632,'1','187','939',418,'Retail Sale Id 1182223',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 11:14:18','',''),(2615633,'1','187','939',418,'Retail Sale Id 1182224',21000.00,0.00,0.00,35.00,3220.00,'2022-03-10 11:30:33','',''),(2615634,'1','187','939',418,'Retail Sale Id 1182225',90000.00,0.00,0.00,150.00,13800.00,'2022-03-10 12:45:08','',''),(2615635,'1','187','939',418,'Retail Sale Id 1182226',60000.00,0.00,0.00,100.00,9200.00,'2022-03-10 12:50:15','',''),(2615636,'1','187','939',418,'Retail Sale Id 1182227',1997.10,0.00,0.00,3.17,386.74,'2022-03-10 13:29:40','',''),(2615637,'1','187','939',418,'Retail Sale Id 1182228',3798.90,0.00,0.00,6.03,735.66,'2022-03-10 13:33:32','',''),(2615638,'1','187','939',418,'Retail Sale Id 1182229',1260.00,0.00,0.00,2.00,244.00,'2022-03-10 13:46:43','',''),(2615639,'1','187','939',418,'Retail Sale Id 1182230',30000.00,0.00,0.00,50.00,4600.00,'2022-03-10 13:56:03','',''),(2615640,'1','187','939',418,'Retail Sale Id 1182231',3798.90,0.00,0.00,6.03,735.66,'2022-03-10 13:57:48','',''),(2615641,'1','187','939',418,'Retail Sale Id 1182232',7597.80,0.00,0.00,12.06,1471.32,'2022-03-10 14:01:34','',''),(2615642,'1','187','939',418,'Retail Sale Id 1182233',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 15:24:37','',''),(2615643,'1','187','939',418,'Retail Sale Id 1182234',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 15:25:32','',''),(2615644,'1','187','939',418,'Retail Sale Id 1182235',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 15:26:28','',''),(2615645,'1','187','939',418,'Retail Sale Id 1182236',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 15:29:48','',''),(2615646,'1','187','939',418,'Retail Sale Id 1182237',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 15:31:08','',''),(2615647,'1','187','939',418,'Retail Sale Id 1182238',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 15:32:50','',''),(2615648,'1','187','939',418,'Retail Sale Id 1182239',6999.30,0.00,0.00,11.11,1355.42,'2022-03-10 15:49:18','',''),(2615649,'1','187','939',418,'Retail Sale Id 1182240',630.00,0.00,0.00,1.00,122.00,'2022-03-10 15:53:29','',''),(2615650,'1','187','939',418,'Retail Sale Id 1182241',3798.90,0.00,0.00,6.03,735.66,'2022-03-10 15:55:48','',''),(2615651,'1','187','939',418,'Retail Sale Id 1182242',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 15:57:56','',''),(2615652,'1','187','939',418,'Retail Sale Id 1182243',3798.90,0.00,0.00,6.03,735.66,'2022-03-10 15:59:58','',''),(2615653,'1','187','939',418,'Retail Sale Id 1182244',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 16:18:52','',''),(2615654,'1','187','939',418,'Retail Sale Id 1182245',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 16:22:29','',''),(2615655,'1','187','939',418,'Retail Sale Id 1182246',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 16:37:06','',''),(2615656,'1','187','939',418,'Retail Sale Id 1182247',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 16:41:01','',''),(2615657,'1','187','939',418,'Retail Sale Id 1182248',3200.40,0.00,0.00,5.08,619.76,'2022-03-10 16:42:13','',''),(2615658,'1','187','939',418,'Retail Sale Id 1182249',3200.40,0.00,0.00,5.08,619.76,'2022-03-10 16:45:04','',''),(2615659,'1','187','939',418,'Retail Sale Id 1182250',3798.90,0.00,0.00,6.03,735.66,'2022-03-10 16:47:47','',''),(2615660,'1','187','939',418,'Retail Sale Id 1182251',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 16:57:11','',''),(2615661,'1','187','939',418,'Retail Sale Id 1182252',1297.80,0.00,0.00,2.06,251.32,'2022-03-10 16:59:26','',''),(2615662,'1','187','939',418,'Retail Sale Id 1182253',1997.10,0.00,0.00,3.17,386.74,'2022-03-10 17:01:11','',''),(2615663,'1','187','939',418,'Retail Sale Id 1182254',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 17:05:28','',''),(2615664,'1','187','939',418,'Retail Sale Id 1182255',6300.00,0.00,0.00,10.00,1220.00,'2022-03-10 17:08:39','',''),(2615665,'1','187','939',418,'Retail Sale Id 1182256',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 17:11:18','',''),(2615666,'1','187','939',418,'Retail Sale Id 1182257',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 17:15:54','',''),(2615667,'1','187','939',418,'Retail Sale Id 1182258',1197.00,0.00,0.00,1.90,231.80,'2022-03-10 17:17:09','',''),(2615668,'1','187','939',418,'Retail Sale Id 1182259',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 17:18:28','',''),(2615669,'1','187','939',418,'Retail Sale Id 1182260',1121.40,0.00,0.00,1.78,217.16,'2022-03-10 17:20:29','',''),(2615670,'1','187','939',418,'Retail Sale Id 1182261',699.30,0.00,0.00,1.11,135.42,'2022-03-10 17:21:58','',''),(2615671,'1','187','939',418,'Retail Sale Id 1182262',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 17:23:15','',''),(2615672,'1','187','939',418,'Retail Sale Id 1182263',3899.70,0.00,0.00,6.19,755.18,'2022-03-10 17:24:47','',''),(2615673,'1','187','939',418,'Retail Sale Id 1182264',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 17:31:14','',''),(2615674,'1','187','939',418,'Retail Sale Id 1182265',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 17:34:01','',''),(2615675,'1','187','939',418,'Retail Sale Id 1182266',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 17:46:34','',''),(2615676,'1','187','939',418,'Retail Sale Id 1182267',1902.60,0.00,0.00,3.02,368.44,'2022-03-10 17:47:30','',''),(2615677,'1','187','939',418,'Retail Sale Id 1182268',1297.80,0.00,0.00,2.06,251.32,'2022-03-10 17:49:15','',''),(2615678,'1','187','939',418,'Retail Sale Id 1182269',1001.70,0.00,0.00,1.59,193.98,'2022-03-10 18:33:53','',''),(2615679,'1','187','939',418,'Retail Sale Id 1182270',598.50,0.00,0.00,0.95,115.90,'2022-03-10 18:35:40','',''),(2615680,'1','187','939',418,'Retail Sale Id 1182271',1499.40,0.00,0.00,2.38,290.36,'2022-03-10 18:39:39','',''),(2615681,'1','187','939',418,'Retail Sale Id 1182272',1297.80,0.00,0.00,2.06,251.32,'2022-03-10 18:42:22','',''),(2615682,'1','187','939',418,'Retail Sale Id 1182273',5002.20,0.00,0.00,7.94,968.68,'2022-03-11 08:54:26','',''),(2615683,'1','187','939',418,'Retail Sale Id 1182274',2998.80,0.00,0.00,4.76,580.72,'2022-03-11 08:55:43','',''),(2615684,'1','187','939',418,'Retail Sale Id 1182275',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 08:56:53','',''),(2615685,'1','187','939',418,'Retail Sale Id 1182276',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 08:57:47','',''),(2615686,'1','187','939',418,'Retail Sale Id 1182281',1902.60,0.00,0.00,3.02,368.44,'2022-03-11 09:11:20','',''),(2615687,'1','187','939',418,'Retail Sale Id 1182282',30000.00,0.00,0.00,50.00,4600.00,'2022-03-11 09:19:58','',''),(2615688,'1','187','939',418,'Retail Sale Id 1182283',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 09:20:53','',''),(2615689,'1','187','939',418,'Retail Sale Id 1182284',5701.50,0.00,0.00,9.05,1104.10,'2022-03-11 09:27:53','',''),(2615690,'1','187','939',418,'Retail Sale Id 1182285',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 09:34:01','',''),(2615691,'1','187','939',418,'Retail Sale Id 1182286',36000.00,0.00,0.00,60.00,5520.00,'2022-03-11 09:46:24','',''),(2615692,'1','187','939',418,'Retail Sale Id 1182287',2501.10,0.00,0.00,3.97,484.34,'2022-03-11 09:48:49','',''),(2615693,'1','187','939',418,'Retail Sale Id 1182288',30000.00,0.00,0.00,50.00,4600.00,'2022-03-11 09:53:19','',''),(2615694,'1','187','939',418,'Retail Sale Id 1182289',1902.60,0.00,0.00,3.02,368.44,'2022-03-11 09:57:55','',''),(2615695,'1','187','939',418,'Retail Sale Id 1182290',6999.30,0.00,0.00,11.11,1355.42,'2022-03-11 10:12:48','',''),(2615696,'1','187','939',418,'Retail Sale Id 1182291',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 10:13:41','',''),(2615697,'1','187','939',418,'Retail Sale Id 1182292',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 10:24:59','',''),(2615698,'1','187','939',418,'Retail Sale Id 1182293',60000.00,0.00,0.00,100.00,9200.00,'2022-03-11 10:34:04','',''),(2615699,'1','187','939',418,'Retail Sale Id 1182294',18000.00,0.00,0.00,30.00,2760.00,'2022-03-11 10:43:29','',''),(2615700,'1','187','939',418,'Retail Sale Id 1182295',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 10:44:47','',''),(2615701,'1','187','939',418,'Retail Sale Id 1182297',1197.00,0.00,0.00,1.90,231.80,'2022-03-11 10:58:10','',''),(2615702,'1','187','939',418,'Retail Sale Id 1182298',1902.60,0.00,0.00,3.02,368.44,'2022-03-11 11:00:11','',''),(2615703,'1','187','939',418,'Retail Sale Id 1182299',90000.00,0.00,0.00,150.00,13800.00,'2022-03-11 11:09:21','',''),(2615704,'1','187','939',418,'Retail Sale Id 1182300',1701.00,0.00,0.00,2.70,329.40,'2022-03-11 11:10:40','',''),(2615705,'1','187','939',418,'Retail Sale Id 1182301',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 11:14:26','',''),(2615706,'1','187','939',418,'Retail Sale Id 1182302',30000.00,0.00,0.00,50.00,4600.00,'2022-03-11 11:35:56','',''),(2615707,'1','187','939',418,'Retail Sale Id 1182303',1902.60,0.00,0.00,3.02,368.44,'2022-03-11 12:08:38','',''),(2615708,'1','187','939',418,'Retail Sale Id 1182304',3150.00,0.00,0.00,5.00,610.00,'2022-03-11 12:11:14','',''),(2615709,'1','187','939',418,'Retail Sale Id 1182305',60000.00,0.00,0.00,100.00,9200.00,'2022-03-11 12:20:00','',''),(2615710,'1','187','939',418,'Retail Sale Id 1182306',60000.00,0.00,0.00,100.00,9200.00,'2022-03-11 12:20:59','',''),(2615711,'1','187','939',418,'Retail Sale Id 1182307',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 12:21:48','',''),(2615712,'1','187','939',418,'Retail Sale Id 1182308',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 12:22:58','',''),(2615713,'1','187','939',418,'Retail Sale Id 1182309',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 12:24:08','',''),(2615714,'1','187','939',418,'Retail Sale Id 1182310',1197.00,0.00,0.00,1.90,231.80,'2022-03-11 12:33:24','',''),(2615715,'1','187','939',418,'Retail Sale Id 1182311',1297.80,0.00,0.00,2.06,251.32,'2022-03-11 12:36:11','',''),(2615716,'1','187','939',418,'Retail Sale Id 1182312',1499.40,0.00,0.00,2.38,290.36,'2022-03-11 12:39:42','',''),(2615717,'1','187','939',418,'Retail Sale Id 1182313',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 12:50:58','',''),(2615718,'1','187','939',418,'Retail Sale Id 1182314',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 12:52:35','',''),(2615719,'1','187','939',418,'Retail Sale Id 1182315',2501.10,0.00,0.00,3.97,484.34,'2022-03-11 13:22:15','',''),(2615720,'1','187','939',418,'Retail Sale Id 1182316',3000.00,0.00,0.00,5.00,460.00,'2022-03-11 14:19:13','',''),(2615721,'1','187','939',418,'Retail Sale Id 1182317',5997.60,0.00,0.00,9.52,1161.44,'2022-03-11 14:45:58','',''),(2615722,'1','187','939',418,'Retail Sale Id 1182318',5701.50,0.00,0.00,9.05,1104.10,'2022-03-11 14:48:00','',''),(2615723,'1','187','939',418,'Retail Sale Id 1182319',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 14:50:36','',''),(2615724,'1','187','939',418,'Retail Sale Id 1182320',5701.50,0.00,0.00,9.05,1104.10,'2022-03-11 14:58:01','',''),(2615725,'1','187','939',418,'Retail Sale Id 1182321',18000.00,0.00,0.00,30.00,2760.00,'2022-03-11 15:00:44','',''),(2615726,'1','187','939',418,'Retail Sale Id 1182322',3798.90,0.00,0.00,6.03,735.66,'2022-03-11 15:05:16','',''),(2615727,'1','187','939',418,'Retail Sale Id 1182323',1297.80,0.00,0.00,2.06,251.32,'2022-03-11 15:11:04','',''),(2615728,'1','187','939',418,'Retail Sale Id 1182324',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 15:20:01','',''),(2615729,'1','187','939',418,'Retail Sale Id 1182325',2797.20,0.00,0.00,4.44,541.68,'2022-03-11 15:23:15','',''),(2615730,'1','187','939',418,'Retail Sale Id 1182326',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 15:25:30','',''),(2615731,'1','187','939',418,'Retail Sale Id 1182327',1499.40,0.00,0.00,2.38,290.36,'2022-03-11 15:27:30','',''),(2615732,'1','187','939',418,'Retail Sale Id 1182328',7500.00,0.00,0.00,12.50,1150.00,'2022-03-11 15:34:09','',''),(2615733,'1','187','939',418,'Retail Sale Id 1182329',4000.50,0.00,0.00,6.35,774.70,'2022-03-11 15:36:08','',''),(2615734,'1','187','939',418,'Retail Sale Id 1182330',2998.80,0.00,0.00,4.76,580.72,'2022-03-11 15:42:56','',''),(2615735,'1','187','939',418,'Retail Sale Id 1182331',3150.00,0.00,0.00,5.00,610.00,'2022-03-11 15:53:16','',''),(2615736,'1','187','939',418,'Retail Sale Id 1182332',1499.40,0.00,0.00,2.38,290.36,'2022-03-11 16:05:05','',''),(2615737,'1','187','939',418,'Retail Sale Id 1182333',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 16:08:28','',''),(2615738,'1','187','939',418,'Retail Sale Id 1182334',90000.00,0.00,0.00,150.00,13800.00,'2022-03-11 16:09:52','',''),(2615739,'1','187','939',418,'Retail Sale Id 1182335',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 16:10:55','',''),(2615740,'1','187','939',418,'Retail Sale Id 1182336',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 16:15:19','',''),(2615741,'1','187','939',418,'Retail Sale Id 1182337',3200.40,0.00,0.00,5.08,619.76,'2022-03-11 16:38:50','',''),(2615742,'1','187','939',418,'Retail Sale Id 1182338',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 16:39:52','',''),(2615743,'1','187','939',418,'Retail Sale Id 1182339',1197.00,0.00,0.00,1.90,231.80,'2022-03-11 16:43:19','',''),(2615744,'1','187','939',418,'Retail Sale Id 1182340',1902.60,0.00,0.00,3.02,368.44,'2022-03-11 16:50:34','',''),(2615745,'1','187','939',418,'Retail Sale Id 1182341',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 16:58:47','',''),(2615746,'1','187','939',418,'Retail Sale Id 1182342',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 17:00:03','',''),(2615747,'1','187','939',418,'Retail Sale Id 1182343',3502.80,0.00,0.00,5.56,678.32,'2022-03-11 17:05:52','',''),(2615748,'1','187','939',418,'Retail Sale Id 1182344',3402.00,0.00,0.00,5.40,658.80,'2022-03-11 17:06:55','',''),(2615749,'1','187','939',418,'Retail Sale Id 1182345',1499.40,0.00,0.00,2.38,290.36,'2022-03-11 17:07:46','',''),(2615750,'1','187','939',418,'Retail Sale Id 1182346',3798.90,0.00,0.00,6.03,735.66,'2022-03-11 17:09:48','',''),(2615751,'1','187','939',418,'Retail Sale Id 1182347',1997.10,0.00,0.00,3.17,386.74,'2022-03-11 17:20:16','',''),(2615752,'1','187','939',418,'Retail Sale Id 1182348',2501.10,0.00,0.00,3.97,484.34,'2022-03-11 17:24:42','',''),(2615753,'1','187','939',418,'Retail Sale Id 1182349',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 17:26:57','',''),(2615754,'1','187','939',418,'Retail Sale Id 1182350',1197.00,0.00,0.00,1.90,231.80,'2022-03-11 17:32:34','',''),(2615755,'1','187','939',418,'Retail Sale Id 1182351',1197.00,0.00,0.00,1.90,231.80,'2022-03-11 17:33:31','',''),(2615756,'1','187','939',418,'Retail Sale Id 1182352',30000.00,0.00,0.00,50.00,4600.00,'2022-03-11 17:40:21','',''),(2615757,'1','187','939',418,'Retail Sale Id 1182353',1197.00,0.00,0.00,1.90,231.80,'2022-03-11 17:41:29','',''),(2615758,'1','187','939',418,'Retail Sale Id 1182354',900.90,0.00,0.00,1.43,174.46,'2022-03-11 17:42:54','',''),(2615759,'1','187','939',418,'Retail Sale Id 1182355',6999.30,0.00,0.00,11.11,1355.42,'2022-03-11 17:46:42','',''),(2615760,'1','187','939',418,'Retail Sale Id 1182356',5701.50,0.00,0.00,9.05,1104.10,'2022-03-11 17:48:36','',''),(2615761,'1','187','939',418,'Retail Sale Id 1182357',6300.00,0.00,0.00,10.00,1220.00,'2022-03-11 17:49:50','',''),(2615762,'1','187','939',418,'Retail Sale Id 1182358',3798.90,0.00,0.00,6.03,735.66,'2022-03-11 17:51:28','',''),(2615763,'1','187','939',418,'Retail Sale Id 1182359',1499.40,0.00,0.00,2.38,290.36,'2022-03-11 17:52:26','',''),(2615764,'1','187','939',418,'Retail Sale Id 1182360',1001.70,0.00,0.00,1.59,193.98,'2022-03-11 18:01:35','',''),(2615765,'1','187','939',418,'Return of Retail Sale Id 1182316',0.00,3000.00,5.00,0.00,-460.00,'2022-03-11 18:43:12','',''),(2615766,'1','187','939',418,'Retail Sale Id 1182361',3131.10,0.00,0.00,4.97,606.34,'2022-03-11 18:45:27','',''),(2615767,'1','187','939',418,'Retail Sale Id 1182362',3798.90,0.00,0.00,6.03,735.66,'2022-03-12 08:24:30','',''),(2615768,'1','187','939',418,'Retail Sale Id 1182363',2501.10,0.00,0.00,3.97,484.34,'2022-03-12 08:27:42','',''),(2615769,'1','187','939',418,'Retail Sale Id 1182364',2501.10,0.00,0.00,3.97,484.34,'2022-03-12 08:29:03','',''),(2615770,'1','187','939',418,'Retail Sale Id 1182365',1902.60,0.00,0.00,3.02,368.44,'2022-03-12 08:30:03','',''),(2615771,'1','187','939',418,'Retail Sale Id 1182366',12000.00,0.00,0.00,20.00,1840.00,'2022-03-12 08:32:59','',''),(2615772,'1','187','939',418,'Retail Sale Id 1182367',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 08:33:44','',''),(2615773,'1','187','939',418,'Retail Sale Id 1182368',3798.90,0.00,0.00,6.03,735.66,'2022-03-12 08:42:15','',''),(2615774,'1','187','939',418,'Retail Sale Id 1182369',2998.80,0.00,0.00,4.76,580.72,'2022-03-12 09:01:21','',''),(2615775,'1','187','939',418,'Retail Sale Id 1182370',1297.80,0.00,0.00,2.06,251.32,'2022-03-12 09:14:42','',''),(2615776,'1','187','939',418,'Retail Sale Id 1182371',3798.90,0.00,0.00,6.03,735.66,'2022-03-12 09:16:06','',''),(2615777,'1','187','939',418,'Retail Sale Id 1182372',30000.00,0.00,0.00,50.00,4600.00,'2022-03-12 09:17:56','',''),(2615778,'1','187','939',418,'Retail Sale Id 1182373',3502.80,0.00,0.00,5.56,678.32,'2022-03-12 09:28:10','',''),(2615779,'1','187','939',418,'Retail Sale Id 1182375',13200.00,0.00,0.00,22.00,2024.00,'2022-03-12 09:33:25','',''),(2615780,'1','187','939',418,'Retail Sale Id 1182376',1902.60,0.00,0.00,3.02,368.44,'2022-03-12 09:38:19','',''),(2615781,'1','187','939',418,'Retail Sale Id 1182377',7497.00,0.00,0.00,11.90,1451.80,'2022-03-12 09:40:00','',''),(2615782,'1','187','939',418,'Retail Sale Id 1182378',90000.00,0.00,0.00,150.00,13800.00,'2022-03-12 09:48:41','',''),(2615783,'1','187','939',418,'Retail Sale Id 1182379',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 09:49:44','',''),(2615784,'1','187','939',418,'Retail Sale Id 1182380',648.90,0.00,0.00,1.03,125.66,'2022-03-12 09:51:46','',''),(2615785,'1','187','939',418,'Retail Sale Id 1182381',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 09:52:30','',''),(2615786,'1','187','939',418,'Retail Sale Id 1182382',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 10:03:27','',''),(2615787,'1','187','939',418,'Retail Sale Id 1182383',7900.20,0.00,0.00,12.54,1529.88,'2022-03-12 10:07:06','',''),(2615788,'1','187','939',418,'Retail Sale Id 1182384',24000.00,0.00,0.00,40.00,3680.00,'2022-03-12 10:08:39','',''),(2615789,'1','187','939',418,'Retail Sale Id 1182385',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 10:13:54','',''),(2615790,'1','187','939',418,'Retail Sale Id 1182386',749.70,0.00,0.00,1.19,145.18,'2022-03-12 10:15:11','',''),(2615791,'1','187','939',418,'Retail Sale Id 1182387',1297.80,0.00,0.00,2.06,251.32,'2022-03-12 10:22:09','',''),(2615792,'1','187','939',418,'Retail Sale Id 1182388',3502.80,0.00,0.00,5.56,678.32,'2022-03-12 10:27:55','',''),(2615793,'1','187','939',418,'Retail Sale Id 1182389',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 10:28:49','',''),(2615794,'1','187','939',418,'Retail Sale Id 1182390',1801.80,0.00,0.00,2.86,348.92,'2022-03-12 10:29:52','',''),(2615795,'1','187','939',418,'Retail Sale Id 1182391',1499.40,0.00,0.00,2.38,290.36,'2022-03-12 10:33:15','',''),(2615796,'1','187','939',418,'Retail Sale Id 1182392',3798.90,0.00,0.00,6.03,735.66,'2022-03-12 10:34:53','',''),(2615797,'1','187','939',418,'Retail Sale Id 1182393',3200.40,0.00,0.00,5.08,619.76,'2022-03-12 10:35:48','',''),(2615798,'1','187','939',418,'Retail Sale Id 1182394',7597.80,0.00,0.00,12.06,1471.32,'2022-03-12 10:40:24','',''),(2615799,'1','187','939',418,'Retail Sale Id 1182395',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 10:52:33','',''),(2615800,'1','187','939',418,'Retail Sale Id 1182396',1197.00,0.00,0.00,1.90,231.80,'2022-03-12 10:53:42','',''),(2615801,'1','187','939',418,'Retail Sale Id 1182397',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 10:57:44','',''),(2615802,'1','187','939',418,'Retail Sale Id 1182398',2501.10,0.00,0.00,3.97,484.34,'2022-03-12 10:58:29','',''),(2615803,'1','187','939',418,'Retail Sale Id 1182399',36000.00,0.00,0.00,60.00,5520.00,'2022-03-12 11:07:58','',''),(2615804,'1','187','939',418,'Retail Sale Id 1182400',2998.80,0.00,0.00,4.76,580.72,'2022-03-12 11:09:09','',''),(2615805,'1','187','939',418,'Retail Sale Id 1182401',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 11:52:08','',''),(2615806,'1','187','939',418,'Retail Sale Id 1182402',1499.40,0.00,0.00,2.38,290.36,'2022-03-12 11:59:01','',''),(2615807,'1','187','939',418,'Retail Sale Id 1182403',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 12:03:28','',''),(2615808,'1','187','939',418,'Retail Sale Id 1182404',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 12:08:00','',''),(2615809,'1','187','939',418,'Retail Sale Id 1182405',1297.80,0.00,0.00,2.06,251.32,'2022-03-12 12:13:15','',''),(2615810,'1','187','939',418,'Retail Sale Id 1182406',1902.60,0.00,0.00,3.02,368.44,'2022-03-12 12:18:48','',''),(2615811,'1','187','939',418,'Retail Sale Id 1182407',900.90,0.00,0.00,1.43,174.46,'2022-03-12 12:20:19','',''),(2615812,'1','187','939',418,'Retail Sale Id 1182408',60000.00,0.00,0.00,100.00,9200.00,'2022-03-12 12:41:24','',''),(2615813,'1','187','939',418,'Retail Sale Id 1182409',30000.00,0.00,0.00,50.00,4600.00,'2022-03-12 12:44:22','',''),(2615814,'1','187','939',418,'Retail Sale Id 1182410',90000.00,0.00,0.00,150.00,13800.00,'2022-03-12 12:54:51','',''),(2615815,'1','187','939',418,'Retail Sale Id 1182411',60000.00,0.00,0.00,100.00,9200.00,'2022-03-12 12:58:22','',''),(2615816,'1','187','939',418,'Retail Sale Id 1182412',90000.00,0.00,0.00,150.00,13800.00,'2022-03-12 13:17:36','',''),(2615817,'1','187','939',418,'Retail Sale Id 1182413',3200.40,0.00,0.00,5.08,619.76,'2022-03-12 13:20:24','',''),(2615818,'1','187','939',418,'Retail Sale Id 1182414',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 13:26:09','',''),(2615819,'1','187','939',418,'Retail Sale Id 1182415',1499.40,0.00,0.00,2.38,290.36,'2022-03-12 13:40:06','',''),(2615820,'1','187','939',418,'Retail Sale Id 1182416',21000.00,0.00,0.00,35.00,3220.00,'2022-03-12 13:46:26','',''),(2615821,'1','187','939',418,'Retail Sale Id 1182417',26502.00,0.00,0.00,44.17,4063.64,'2022-03-12 14:02:39','',''),(2615822,'1','187','939',418,'Retail Sale Id 1182418',4000.50,0.00,0.00,6.35,774.70,'2022-03-12 14:24:38','',''),(2615823,'1','187','939',418,'Retail Sale Id 1182419',60000.00,0.00,0.00,100.00,9200.00,'2022-03-12 14:30:51','',''),(2615824,'1','187','939',418,'Retail Sale Id 1182421',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 14:32:40','',''),(2615825,'1','187','939',418,'Retail Sale Id 1182422',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 14:38:02','',''),(2615826,'1','187','939',418,'Retail Sale Id 1182423',120000.00,0.00,0.00,200.00,18400.00,'2022-03-12 14:45:05','',''),(2615827,'1','187','939',418,'Retail Sale Id 1182424',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 14:51:48','',''),(2615828,'1','187','939',418,'Retail Sale Id 1182425',1499.40,0.00,0.00,2.38,290.36,'2022-03-12 14:54:43','',''),(2615829,'1','187','939',418,'Retail Sale Id 1182426',1297.80,0.00,0.00,2.06,251.32,'2022-03-12 15:06:17','',''),(2615830,'1','187','939',418,'Retail Sale Id 1182428',7900.20,0.00,0.00,12.54,1529.88,'2022-03-12 15:14:48','',''),(2615831,'1','187','939',418,'Retail Sale Id 1182429',1701.00,0.00,0.00,2.70,329.40,'2022-03-12 15:15:56','',''),(2615832,'1','187','939',418,'Retail Sale Id 1182430',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 15:25:52','',''),(2615833,'1','187','939',418,'Retail Sale Id 1182434',26298.00,0.00,0.00,43.83,4032.36,'2022-03-12 15:46:31','',''),(2615834,'1','187','939',418,'Retail Sale Id 1182435',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 15:50:35','',''),(2615835,'1','187','939',418,'Retail Sale Id 1182433',24000.00,0.00,0.00,40.00,3680.00,'2022-03-12 15:52:41','',''),(2615836,'1','187','939',418,'Retail Sale Id 1182436',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 15:53:51','',''),(2615837,'1','187','939',418,'Retail Sale Id 1182437',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 15:54:51','',''),(2615838,'1','187','939',418,'Retail Sale Id 1182438',3702.00,0.00,0.00,6.17,567.64,'2022-03-12 16:05:50','',''),(2615839,'1','187','939',418,'Retail Sale Id 1182439',1102.50,0.00,0.00,1.75,213.50,'2022-03-12 16:12:39','',''),(2615840,'1','187','939',418,'Retail Sale Id 1182440',3798.90,0.00,0.00,6.03,735.66,'2022-03-12 16:25:51','',''),(2615841,'1','187','939',418,'Retail Sale Id 1182441',2998.80,0.00,0.00,4.76,580.72,'2022-03-12 16:33:44','',''),(2615842,'1','187','939',418,'Retail Sale Id 1182442',1398.60,0.00,0.00,2.22,270.84,'2022-03-12 16:37:24','',''),(2615843,'1','187','939',418,'Retail Sale Id 1182443',1260.00,0.00,0.00,2.00,244.00,'2022-03-12 16:55:08','',''),(2615844,'1','187','939',418,'Retail Sale Id 1182444',2520.00,0.00,0.00,4.00,488.00,'2022-03-12 16:58:10','',''),(2615845,'1','187','939',418,'Retail Sale Id 1182445',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 16:59:21','',''),(2615846,'1','187','939',418,'Retail Sale Id 1182446',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 17:03:51','',''),(2615847,'1','187','939',418,'Retail Sale Id 1182447',1297.80,0.00,0.00,2.06,251.32,'2022-03-12 17:10:42','',''),(2615848,'1','187','939',418,'Retail Sale Id 1182448',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 17:15:01','',''),(2615849,'1','187','939',418,'Retail Sale Id 1182449',1398.60,0.00,0.00,2.22,270.84,'2022-03-12 17:20:54','',''),(2615850,'1','187','939',418,'Retail Sale Id 1182450',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 17:25:55','',''),(2615851,'1','187','939',418,'Retail Sale Id 1182451',1297.80,0.00,0.00,2.06,251.32,'2022-03-12 17:27:53','',''),(2615852,'1','187','939',418,'Retail Sale Id 1182452',1499.40,0.00,0.00,2.38,290.36,'2022-03-12 17:31:08','',''),(2615853,'1','187','939',418,'Retail Sale Id 1182453',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 17:32:37','',''),(2615854,'1','187','939',418,'Retail Sale Id 1182454',2998.80,0.00,0.00,4.76,580.72,'2022-03-12 17:36:37','',''),(2615855,'1','187','939',418,'Retail Sale Id 1182455',1997.10,0.00,0.00,3.17,386.74,'2022-03-12 17:52:26','',''),(2615856,'1','187','939',418,'Retail Sale Id 1182456',1001.70,0.00,0.00,1.59,193.98,'2022-03-12 17:54:49','',''),(2615857,'1','187','939',418,'Retail Sale Id 1182457',24000.00,0.00,0.00,40.00,3680.00,'2022-03-13 12:34:47','',''),(2615858,'1','187','939',418,'Retail Sale Id 1182458',5701.50,0.00,0.00,9.05,1104.10,'2022-03-13 13:05:19','',''),(2615859,'1','187','939',418,'Retail Sale Id 1182459',1001.70,0.00,0.00,1.59,193.98,'2022-03-13 13:06:11','',''),(2615860,'1','187','939',418,'Retail Sale Id 1182460',1701.00,0.00,0.00,2.70,329.40,'2022-03-13 13:10:30','',''),(2615861,'1','187','939',418,'Retail Sale Id 1182461',1997.10,0.00,0.00,3.17,386.74,'2022-03-13 13:11:20','',''),(2615862,'1','187','939',418,'Retail Sale Id 1182462',1997.10,0.00,0.00,3.17,386.74,'2022-03-13 13:12:05','',''),(2615863,'1','187','939',418,'Retail Sale Id 1182463',1902.60,0.00,0.00,3.02,368.44,'2022-03-13 13:13:04','',''),(2615864,'1','187','939',418,'Retail Sale Id 1182465',1102.50,0.00,0.00,1.75,213.50,'2022-03-13 13:14:13','',''),(2615865,'1','187','939',418,'Retail Sale Id 1182466',2998.80,0.00,0.00,4.76,580.72,'2022-03-13 13:15:05','',''),(2615866,'1','187','939',418,'Retail Sale Id 1182467',1001.70,0.00,0.00,1.59,193.98,'2022-03-13 13:16:14','',''),(2615867,'1','187','939',418,'Retail Sale Id 1182468',1499.40,0.00,0.00,2.38,290.36,'2022-03-13 13:17:36','',''),(2615868,'1','187','939',418,'Retail Sale Id 1182470',77400.00,0.00,0.00,129.00,11868.00,'2022-03-13 13:26:00','',''),(2615869,'1','187','939',418,'Retail Sale Id 1182471',108000.00,0.00,0.00,180.00,16560.00,'2022-03-13 13:30:53','',''),(2615870,'1','187','939',418,'Retail Sale Id 1182472',60000.00,0.00,0.00,100.00,9200.00,'2022-03-13 13:35:48','',''),(2615871,'1','187','939',418,'Retail Sale Id 1182473',1001.70,0.00,0.00,1.59,193.98,'2022-03-13 13:51:35','',''),(2615872,'1','187','939',418,'Retail Sale Id 1182474',3798.90,0.00,0.00,6.03,735.66,'2022-03-13 13:53:50','',''),(2615873,'1','187','939',418,'Retail Sale Id 1182475',1001.70,0.00,0.00,1.59,193.98,'2022-03-13 13:54:58','',''),(2615874,'1','187','939',418,'Retail Sale Id 1182476',3798.90,0.00,0.00,6.03,735.66,'2022-03-13 13:56:09','',''),(2615875,'1','187','939',418,'Retail Sale Id 1182477',1001.70,0.00,0.00,1.59,193.98,'2022-03-13 13:57:15','',''),(2615876,'1','187','939',418,'Retail Sale Id 1182478',107820.00,0.00,0.00,179.70,16532.40,'2022-03-13 14:03:36','',''),(2615877,'1','187','939',418,'Retail Sale Id 1182479',35028.00,0.00,0.00,58.38,5370.96,'2022-03-13 14:05:07','',''),(2615878,'1','187','939',418,'Retail Sale Id 1182480',14688.00,0.00,0.00,24.48,2252.16,'2022-03-13 14:50:07','',''),(2615879,'1','187','939',418,'Return of Retail Sale Id 1182457',0.00,24000.00,40.00,0.00,-3680.00,'2022-03-13 15:03:19','',''),(2615880,'1','187','939',418,'Retail Sale Id 1182481',600.00,0.00,0.00,1.00,92.00,'2022-03-13 15:08:00','',''),(2615881,'1','187','939',418,'Distributed to A.A RANO NIG. LTD. for sales id:332541',131150.36,0.00,0.00,258.17,0.00,'2022-03-13 21:50:45','',''),(2615882,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,14263900.00,24850.00,0.00,0.00,'2022-03-13 22:26:47','',''),(2615883,'1','187',NULL,418,'Reception corrector for bridging 123746',0.00,0.00,0.00,24850.00,0.00,'2022-03-13 22:29:28','',''),(2615884,'1','187','939',418,'Received from bridging 123746',0.00,0.00,24850.00,0.00,0.00,'2022-03-13 22:29:28','',''),(2615885,'1','187','939',418,'Retail Sale Id 1182482',36000.00,0.00,0.00,60.00,1560.00,'2022-03-14 10:31:12','',''),(2615886,'1','187','939',418,'Retail Sale Id 1182483',24000.00,0.00,0.00,40.00,1040.00,'2022-03-14 10:31:57','',''),(2615887,'1','187','939',418,'Retail Sale Id 1182484',7560.00,0.00,0.00,12.00,672.00,'2022-03-14 10:33:21','',''),(2615888,'1','187','939',418,'Retail Sale Id 1182485',6300.00,0.00,0.00,10.00,560.00,'2022-03-14 10:34:29','',''),(2615889,'1','187','939',418,'Retail Sale Id 1182486',3780.00,0.00,0.00,6.00,336.00,'2022-03-14 10:35:03','',''),(2615890,'1','187','939',418,'Retail Sale Id 1182487',30000.00,0.00,0.00,50.00,1300.00,'2022-03-14 10:37:04','',''),(2615891,'1','187','939',418,'Retail Sale Id 1182488',36000.00,0.00,0.00,60.00,1560.00,'2022-03-14 10:38:26','',''),(2615892,'1','187','939',418,'Retail Sale Id 1182489',27000.00,0.00,0.00,45.00,1170.00,'2022-03-14 10:39:24','',''),(2615893,'1','187','939',418,'Retail Sale Id 1182490',33000.00,0.00,0.00,55.00,1430.00,'2022-03-14 10:40:20','',''),(2615894,'1','187','939',418,'Retail Sale Id 1182491',33000.00,0.00,0.00,55.00,1430.00,'2022-03-14 10:41:46','',''),(2615895,'1','187','939',418,'Retail Sale Id 1182492',6615.00,0.00,0.00,10.50,588.00,'2022-03-14 10:44:03','',''),(2615896,'1','187','939',418,'Retail Sale Id 1182493',30000.00,0.00,0.00,50.00,1300.00,'2022-03-14 10:45:13','',''),(2615897,'1','187','939',418,'Retail Sale Id 1182494',60000.00,0.00,0.00,100.00,2600.00,'2022-03-14 13:11:52','',''),(2615898,'1','187','939',418,'Retail Sale Id 1182495',60000.00,0.00,0.00,100.00,2600.00,'2022-03-14 13:12:51','',''),(2615899,'1','187','939',418,'Retail Sale Id 1182496',138000.00,0.00,0.00,230.00,5980.00,'2022-03-14 13:13:28','',''),(2615900,'1','187','939',418,'Retail Sale Id 1182497',187200.00,0.00,0.00,312.00,8112.00,'2022-03-14 13:14:42','',''),(2615901,'1','187','939',418,'Retail Sale Id 1182498',19530.00,0.00,0.00,31.00,1736.00,'2022-03-14 13:15:23','',''),(2615902,'1','187','939',418,'Retail Sale Id 1182499',1127.70,0.00,0.00,1.79,100.24,'2022-03-14 13:19:06','',''),(2615903,'1','187','939',418,'Retail Sale Id 1182500',5670.00,0.00,0.00,9.00,504.00,'2022-03-14 15:00:43','',''),(2615904,'1','187','939',418,'Retail Sale Id 1182501',3780.00,0.00,0.00,6.00,336.00,'2022-03-14 15:01:30','',''),(2615905,'1','187','939',418,'Retail Sale Id 1182502',1890.00,0.00,0.00,3.00,168.00,'2022-03-14 15:01:56','',''),(2615906,'1','187','939',418,'Retail Sale Id 1182503',2142.00,0.00,0.00,3.40,190.40,'2022-03-14 15:03:27','',''),(2615907,'1','187','939',418,'Retail Sale Id 1182504',4410.00,0.00,0.00,7.00,392.00,'2022-03-14 15:04:40','',''),(2615908,'1','187','939',418,'Retail Sale Id 1182505',2583.00,0.00,0.00,4.10,229.60,'2022-03-14 15:05:13','',''),(2615909,'1','187','939',418,'Retail Sale Id 1182506',3780.00,0.00,0.00,6.00,336.00,'2022-03-14 15:17:17','',''),(2615910,'1','187','939',418,'Retail Sale Id 1182507',120000.00,0.00,0.00,200.00,5200.00,'2022-03-14 15:36:00','',''),(2615911,'1','187','939',418,'Retail Sale Id 1182508',75000.00,0.00,0.00,125.00,3250.00,'2022-03-14 15:38:59','',''),(2615912,'1','187','939',418,'Retail Sale Id 1182509',60000.00,0.00,0.00,100.00,2600.00,'2022-03-14 16:05:50','',''),(2615913,'1','187','939',418,'Retail Sale Id 1182510',90000.00,0.00,0.00,150.00,3900.00,'2022-03-14 16:07:28','',''),(2615914,'1','187','939',418,'Retail Sale Id 1182511',35400.00,0.00,0.00,59.00,1534.00,'2022-03-14 17:24:22','',''),(2615915,'1','187','939',418,'Retail Sale Id 1182512',30000.00,0.00,0.00,50.00,1300.00,'2022-03-14 17:41:16','',''),(2615916,'1','187','939',418,'Retail Sale Id 1182513',24000.00,0.00,0.00,40.00,1040.00,'2022-03-14 17:46:59','',''),(2615917,'1','187','939',418,'Retail Sale Id 1182514',51000.00,0.00,0.00,85.00,2210.00,'2022-03-14 17:50:15','',''),(2615918,'1','187','939',418,'Retail Sale Id 1182515',30000.00,0.00,0.00,50.00,1300.00,'2022-03-14 17:50:55','',''),(2615919,'1','187','939',418,'Retail Sale Id 1182516',7875.00,0.00,0.00,12.50,700.00,'2022-03-14 18:15:59','',''),(2615920,'1','187','939',418,'Retail Sale Id 1182517',7875.00,0.00,0.00,12.50,700.00,'2022-03-14 18:16:38','',''),(2615921,'1','187','939',418,'Retail Sale Id 1182518',7875.00,0.00,0.00,12.50,700.00,'2022-03-14 18:16:59','',''),(2615922,'1','187','939',418,'Retail Sale Id 1182519',7875.00,0.00,0.00,12.50,700.00,'2022-03-14 18:17:22','',''),(2615923,'1','187','939',418,'Retail Sale Id 1182520',7875.00,0.00,0.00,12.50,700.00,'2022-03-14 18:17:49','',''),(2615924,'1','187','939',418,'Retail Sale Id 1182521',8820.00,0.00,0.00,14.00,784.00,'2022-03-14 18:18:11','',''),(2615925,'1','187','939',418,'Retail Sale Id 1182522',10080.00,0.00,0.00,16.00,896.00,'2022-03-14 18:18:36','',''),(2615926,'1','187','939',418,'Retail Sale Id 1182523',7742.70,0.00,0.00,12.29,688.24,'2022-03-14 18:19:37','',''),(2615927,'1','187','939',418,'Retail Sale Id 1182524',1800.00,0.00,0.00,3.00,78.00,'2022-03-14 18:20:17','',''),(2615928,'1','187','939',418,'Retail Sale Id 1182526',1499.40,0.00,0.00,2.38,133.28,'2022-03-15 08:20:51','',''),(2615929,'1','187','939',418,'Retail Sale Id 1182527',1997.10,0.00,0.00,3.17,177.52,'2022-03-15 08:21:36','',''),(2615930,'1','187','939',418,'Retail Sale Id 1182528',3798.90,0.00,0.00,6.03,337.68,'2022-03-15 08:40:01','',''),(2615931,'1','187','939',418,'Retail Sale Id 1182529',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 08:49:48','',''),(2615932,'1','187','939',418,'Retail Sale Id 1182530',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 09:01:37','',''),(2615933,'1','187','939',418,'Retail Sale Id 1182531',1260.00,0.00,0.00,2.00,112.00,'2022-03-15 09:07:10','',''),(2615934,'1','187','939',418,'Retail Sale Id 1182532',1997.10,0.00,0.00,3.17,177.52,'2022-03-15 09:35:09','',''),(2615935,'1','187','939',418,'Retail Sale Id 1182533',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 09:47:59','',''),(2615936,'1','187','939',418,'Retail Sale Id 1182534',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 10:08:28','',''),(2615937,'1','187','939',418,'Retail Sale Id 1182535',120000.00,0.00,0.00,200.00,5200.00,'2022-03-15 10:11:15','',''),(2615938,'1','187','939',418,'Retail Sale Id 1182536',3780.00,0.00,0.00,6.00,336.00,'2022-03-15 10:16:42','',''),(2615939,'1','187','939',418,'Retail Sale Id 1182537',63000.00,0.00,0.00,105.00,2730.00,'2022-03-15 10:18:09','',''),(2615940,'1','187','939',418,'Retail Sale Id 1182538',1701.00,0.00,0.00,2.70,151.20,'2022-03-15 10:18:57','',''),(2615941,'1','187','939',418,'Retail Sale Id 1182539',1902.60,0.00,0.00,3.02,169.12,'2022-03-15 10:20:33','',''),(2615942,'1','187','939',418,'Retail Sale Id 1182540',3798.90,0.00,0.00,6.03,337.68,'2022-03-15 10:23:10','',''),(2615943,'1','187','939',418,'Retail Sale Id 1182541',15000.00,0.00,0.00,25.00,650.00,'2022-03-15 10:26:37','',''),(2615944,'1','187','939',418,'Retail Sale Id 1182542',60000.00,0.00,0.00,100.00,2600.00,'2022-03-15 10:27:53','',''),(2615945,'1','187','939',418,'Retail Sale Id 1182543',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 10:29:23','',''),(2615946,'1','187','939',418,'Retail Sale Id 1182544',150000.00,0.00,0.00,250.00,6500.00,'2022-03-15 10:32:37','',''),(2615947,'1','187','939',418,'Retail Sale Id 1182545',150000.00,0.00,0.00,250.00,6500.00,'2022-03-15 10:33:51','',''),(2615948,'1','187','939',418,'Retail Sale Id 1182546',1297.80,0.00,0.00,2.06,115.36,'2022-03-15 10:34:44','',''),(2615949,'1','187','939',418,'Retail Sale Id 1182547',60000.00,0.00,0.00,100.00,2600.00,'2022-03-15 10:38:35','',''),(2615950,'1','187','939',418,'Retail Sale Id 1182548',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 10:41:12','',''),(2615951,'1','187','939',418,'Retail Sale Id 1182549',67200.00,0.00,0.00,112.00,2912.00,'2022-03-15 10:52:08','',''),(2615952,'1','187','939',418,'Retail Sale Id 1182550',36000.00,0.00,0.00,60.00,1560.00,'2022-03-15 10:58:18','',''),(2615953,'1','187','939',418,'Retail Sale Id 1182551',7900.20,0.00,0.00,12.54,702.24,'2022-03-15 11:20:26','',''),(2615954,'1','187','939',418,'Retail Sale Id 1182552',10710.00,0.00,0.00,17.00,952.00,'2022-03-15 11:43:50','',''),(2615955,'1','187','939',418,'Retail Sale Id 1182553',6999.30,0.00,0.00,11.11,622.16,'2022-03-15 11:47:06','',''),(2615956,'1','187','939',418,'Retail Sale Id 1182554',24000.00,0.00,0.00,40.00,1040.00,'2022-03-15 12:14:07','',''),(2615957,'1','187','939',418,'Retail Sale Id 1182555',3798.90,0.00,0.00,6.03,337.68,'2022-03-15 12:19:41','',''),(2615958,'1','187','939',418,'Retail Sale Id 1182556',26400.00,0.00,0.00,44.00,1144.00,'2022-03-15 12:23:17','',''),(2615959,'1','187','939',418,'Retail Sale Id 1182557',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 12:26:55','',''),(2615960,'1','187','939',418,'Retail Sale Id 1182558',3780.00,0.00,0.00,6.00,336.00,'2022-03-15 12:39:18','',''),(2615961,'1','187','939',418,'Retail Sale Id 1182559',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 12:40:07','',''),(2615962,'1','187','939',418,'Retail Sale Id 1182560',90000.00,0.00,0.00,150.00,3900.00,'2022-03-15 12:46:45','',''),(2615963,'1','187','939',418,'Retail Sale Id 1182561',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 12:58:56','',''),(2615964,'1','187','939',418,'Retail Sale Id 1182562',2998.80,0.00,0.00,4.76,266.56,'2022-03-15 13:10:31','',''),(2615965,'1','187','939',418,'Retail Sale Id 1182563',1801.80,0.00,0.00,2.86,160.16,'2022-03-15 13:23:07','',''),(2615966,'1','187','939',418,'Retail Sale Id 1182564',90000.00,0.00,0.00,150.00,3900.00,'2022-03-15 13:45:18','',''),(2615967,'1','187','939',418,'Retail Sale Id 1182565',1297.80,0.00,0.00,2.06,115.36,'2022-03-15 13:52:25','',''),(2615968,'1','187','939',418,'Retail Sale Id 1182566',57000.00,0.00,0.00,95.00,2470.00,'2022-03-15 14:06:16','',''),(2615969,'1','187','939',418,'Retail Sale Id 1182567',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 14:14:12','',''),(2615970,'1','187','939',418,'Retail Sale Id 1182568',1997.10,0.00,0.00,3.17,177.52,'2022-03-15 14:15:12','',''),(2615971,'1','187','939',418,'Retail Sale Id 1182569',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 14:27:23','',''),(2615972,'1','187','939',418,'Retail Sale Id 1182570',1499.40,0.00,0.00,2.38,133.28,'2022-03-15 14:48:43','',''),(2615973,'1','187','939',418,'Retail Sale Id 1182571',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 15:02:15','',''),(2615974,'1','187','939',418,'Retail Sale Id 1182572',1902.60,0.00,0.00,3.02,169.12,'2022-03-15 15:05:49','',''),(2615975,'1','187','939',418,'Retail Sale Id 1182573',1997.10,0.00,0.00,3.17,177.52,'2022-03-15 15:21:51','',''),(2615976,'1','187','939',418,'Retail Sale Id 1182574',2520.00,0.00,0.00,4.00,224.00,'2022-03-15 15:41:10','',''),(2615977,'1','187','939',418,'Retail Sale Id 1182575',48000.00,0.00,0.00,80.00,2080.00,'2022-03-15 15:54:08','',''),(2615978,'1','187','939',418,'Retail Sale Id 1182576',1801.80,0.00,0.00,2.86,160.16,'2022-03-15 16:04:26','',''),(2615979,'1','187','939',418,'Retail Sale Id 1182577',1197.00,0.00,0.00,1.90,106.40,'2022-03-15 16:05:41','',''),(2615980,'1','187','939',418,'Retail Sale Id 1182578',1902.60,0.00,0.00,3.02,169.12,'2022-03-15 16:10:38','',''),(2615981,'1','187','939',418,'Retail Sale Id 1182579',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 16:15:01','',''),(2615982,'1','187','939',418,'Retail Sale Id 1182580',60000.00,0.00,0.00,100.00,2600.00,'2022-03-15 16:42:37','',''),(2615983,'1','187','939',418,'Retail Sale Id 1182581',1297.80,0.00,0.00,2.06,115.36,'2022-03-15 16:44:44','',''),(2615984,'1','187','939',418,'Retail Sale Id 1182582',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 16:47:27','',''),(2615985,'1','187','939',418,'Retail Sale Id 1182583',2242.80,0.00,0.00,3.56,199.36,'2022-03-15 16:49:12','',''),(2615986,'1','187','939',418,'Retail Sale Id 1182584',18000.00,0.00,0.00,30.00,780.00,'2022-03-15 16:52:09','',''),(2615987,'1','187','939',418,'Retail Sale Id 1182590',3798.90,0.00,0.00,6.03,337.68,'2022-03-15 16:55:35','',''),(2615988,'1','187','939',418,'Retail Sale Id 1182591',3798.90,0.00,0.00,6.03,337.68,'2022-03-15 16:56:15','',''),(2615989,'1','187','939',418,'Retail Sale Id 1182592',2601.90,0.00,0.00,4.13,231.28,'2022-03-15 16:59:49','',''),(2615990,'1','187','939',418,'Retail Sale Id 1182593',1499.40,0.00,0.00,2.38,133.28,'2022-03-15 17:01:31','',''),(2615991,'1','187','939',418,'Retail Sale Id 1182594',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 17:02:56','',''),(2615992,'1','187','939',418,'Retail Sale Id 1182595',1902.60,0.00,0.00,3.02,169.12,'2022-03-15 17:05:50','',''),(2615993,'1','187','939',418,'Retail Sale Id 1182596',3899.70,0.00,0.00,6.19,346.64,'2022-03-15 17:16:28','',''),(2615994,'1','187','939',418,'Retail Sale Id 1182597',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 17:23:28','',''),(2615995,'1','187','939',418,'Retail Sale Id 1182598',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 17:28:55','',''),(2615996,'1','187','939',418,'Retail Sale Id 1182599',34200.00,0.00,0.00,57.00,1482.00,'2022-03-15 17:32:22','',''),(2615997,'1','187','939',418,'Retail Sale Id 1182600',1297.80,0.00,0.00,2.06,115.36,'2022-03-15 17:34:09','',''),(2615998,'1','187','939',418,'Retail Sale Id 1182601',1001.70,0.00,0.00,1.59,89.04,'2022-03-15 17:35:29','',''),(2615999,'1','187','939',418,'Retail Sale Id 1182602',7900.20,0.00,0.00,12.54,702.24,'2022-03-15 17:36:37','',''),(2616000,'1','187','939',418,'Retail Sale Id 1182603',90000.00,0.00,0.00,150.00,3900.00,'2022-03-15 17:38:10','',''),(2616001,'1','187','939',418,'Retail Sale Id 1182604',1499.40,0.00,0.00,2.38,133.28,'2022-03-15 17:44:46','',''),(2616002,'1','187','939',418,'Retail Sale Id 1182605',1902.60,0.00,0.00,3.02,169.12,'2022-03-15 17:46:39','',''),(2616003,'1','187','939',418,'Retail Sale Id 1182606',30000.00,0.00,0.00,50.00,1300.00,'2022-03-15 17:48:03','',''),(2616004,'1','187','939',418,'Retail Sale Id 1182607',60000.00,0.00,0.00,100.00,2600.00,'2022-03-15 17:58:51','',''),(2616005,'1','187','939',418,'Retail Sale Id 1182608',1165.50,0.00,0.00,1.85,103.60,'2022-03-15 18:05:03','',''),(2616006,'1','187','939',418,'Retail Sale Id 1182609',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 09:27:44','',''),(2616007,'1','187','939',418,'Retail Sale Id 1182610',3798.90,0.00,0.00,6.03,337.68,'2022-03-16 09:32:21','',''),(2616008,'1','187','939',418,'Retail Sale Id 1182611',30000.00,0.00,0.00,50.00,1300.00,'2022-03-16 09:42:45','',''),(2616009,'1','187','939',418,'Retail Sale Id 1182612',150000.00,0.00,0.00,250.00,6500.00,'2022-03-16 09:47:09','',''),(2616010,'1','187','939',418,'Retail Sale Id 1182613',1801.80,0.00,0.00,2.86,160.16,'2022-03-16 09:50:04','',''),(2616011,'1','187','939',418,'Retail Sale Id 1182614',104400.00,0.00,0.00,174.00,4524.00,'2022-03-16 09:56:36','',''),(2616012,'1','187','939',418,'Retail Sale Id 1182615',30000.00,0.00,0.00,50.00,1300.00,'2022-03-16 10:07:45','',''),(2616013,'1','187','939',418,'Retail Sale Id 1182616',1902.60,0.00,0.00,3.02,169.12,'2022-03-16 10:08:45','',''),(2616014,'1','187','939',418,'Retail Sale Id 1182617',1197.00,0.00,0.00,1.90,106.40,'2022-03-16 10:15:19','',''),(2616015,'1','187','939',418,'Retail Sale Id 1182618',3798.90,0.00,0.00,6.03,337.68,'2022-03-16 10:18:37','',''),(2616016,'1','187','939',418,'Retail Sale Id 1182619',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 10:20:42','',''),(2616017,'1','187','939',418,'Retail Sale Id 1182620',4498.20,0.00,0.00,7.14,399.84,'2022-03-16 10:26:26','',''),(2616018,'1','187','939',418,'Retail Sale Id 1182621',1902.60,0.00,0.00,3.02,169.12,'2022-03-16 10:36:39','',''),(2616019,'1','187','939',418,'Retail Sale Id 1182622',1297.80,0.00,0.00,2.06,115.36,'2022-03-16 10:56:27','',''),(2616020,'1','187','939',418,'Retail Sale Id 1182623',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 11:19:43','',''),(2616021,'1','187','939',418,'Retail Sale Id 1182624',14400.00,0.00,0.00,24.00,624.00,'2022-03-16 11:26:40','',''),(2616022,'1','187','939',418,'Retail Sale Id 1182625',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 11:49:14','',''),(2616023,'1','187','939',418,'Retail Sale Id 1182626',1121.40,0.00,0.00,1.78,99.68,'2022-03-16 11:56:58','',''),(2616024,'1','187','939',418,'Retail Sale Id 1182627',2501.10,0.00,0.00,3.97,222.32,'2022-03-16 12:00:52','',''),(2616025,'1','187','939',418,'Retail Sale Id 1182628',18000.00,0.00,0.00,30.00,780.00,'2022-03-16 12:03:44','',''),(2616026,'1','187','939',418,'Retail Sale Id 1182629',30000.00,0.00,0.00,50.00,1300.00,'2022-03-16 12:05:04','',''),(2616027,'1','187','939',418,'Retail Sale Id 1182630',90000.00,0.00,0.00,150.00,3900.00,'2022-03-16 12:06:49','',''),(2616028,'1','187','939',418,'Retail Sale Id 1182631',3502.80,0.00,0.00,5.56,311.36,'2022-03-16 12:09:49','',''),(2616029,'1','187','939',418,'Retail Sale Id 1182632',1197.00,0.00,0.00,1.90,106.40,'2022-03-16 12:16:45','',''),(2616030,'1','187','939',418,'Retail Sale Id 1182633',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 12:29:06','',''),(2616031,'1','187','939',418,'Retail Sale Id 1182634',1297.80,0.00,0.00,2.06,115.36,'2022-03-16 12:45:31','',''),(2616032,'1','187','939',418,'Retail Sale Id 1182635',3200.40,0.00,0.00,5.08,284.48,'2022-03-16 12:54:37','',''),(2616033,'1','187','939',418,'Retail Sale Id 1182636',1297.80,0.00,0.00,2.06,115.36,'2022-03-16 12:57:30','',''),(2616034,'1','187','939',418,'Retail Sale Id 1182637',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 13:14:32','',''),(2616035,'1','187','939',418,'Retail Sale Id 1182638',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 13:18:48','',''),(2616036,'1','187','939',418,'Retail Sale Id 1182639',90000.00,0.00,0.00,150.00,3900.00,'2022-03-16 13:22:30','',''),(2616037,'1','187','939',418,'Retail Sale Id 1182640',1297.80,0.00,0.00,2.06,115.36,'2022-03-16 13:23:24','',''),(2616038,'1','187','939',418,'Retail Sale Id 1182641',3502.80,0.00,0.00,5.56,311.36,'2022-03-16 13:27:23','',''),(2616039,'1','187','939',418,'Retail Sale Id 1182642',1997.10,0.00,0.00,3.17,177.52,'2022-03-16 14:22:39','',''),(2616040,'1','187','939',418,'Retail Sale Id 1182643',3798.90,0.00,0.00,6.03,337.68,'2022-03-16 14:29:30','',''),(2616041,'1','187','939',418,'Retail Sale Id 1182644',36000.00,0.00,0.00,60.00,1560.00,'2022-03-16 14:36:40','',''),(2616042,'1','187','939',418,'Retail Sale Id 1182645',1701.00,0.00,0.00,2.70,151.20,'2022-03-16 15:08:48','',''),(2616043,'1','187','939',418,'Retail Sale Id 1182646',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 15:17:36','',''),(2616044,'1','187','939',418,'Retail Sale Id 1182647',1297.80,0.00,0.00,2.06,115.36,'2022-03-16 16:17:10','',''),(2616045,'1','187','939',418,'Retail Sale Id 1182648',60000.00,0.00,0.00,100.00,2600.00,'2022-03-16 16:22:11','',''),(2616046,'1','187','939',418,'Retail Sale Id 1182649',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 16:31:36','',''),(2616047,'1','187','939',418,'Retail Sale Id 1182650',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 16:47:11','',''),(2616048,'1','187','939',418,'Retail Sale Id 1182651',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 16:48:15','',''),(2616049,'1','187','939',418,'Retail Sale Id 1182652',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 16:54:58','',''),(2616050,'1','187','939',418,'Retail Sale Id 1182653',1997.10,0.00,0.00,3.17,177.52,'2022-03-16 16:55:39','',''),(2616051,'1','187','939',418,'Retail Sale Id 1182654',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 16:56:18','',''),(2616052,'1','187','939',418,'Retail Sale Id 1182655',1297.80,0.00,0.00,2.06,115.36,'2022-03-16 17:06:08','',''),(2616053,'1','187','939',418,'Retail Sale Id 1182656',1997.10,0.00,0.00,3.17,177.52,'2022-03-16 17:16:03','',''),(2616054,'1','187','939',418,'Retail Sale Id 1182657',1902.60,0.00,0.00,3.02,169.12,'2022-03-16 17:17:27','',''),(2616055,'1','187','939',418,'Retail Sale Id 1182658',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 17:18:18','',''),(2616056,'1','187','939',418,'Retail Sale Id 1182659',3798.90,0.00,0.00,6.03,337.68,'2022-03-16 17:18:55','',''),(2616057,'1','187','939',418,'Retail Sale Id 1182661',1902.60,0.00,0.00,3.02,169.12,'2022-03-16 17:23:04','',''),(2616058,'1','187','939',418,'Retail Sale Id 1182662',2998.80,0.00,0.00,4.76,266.56,'2022-03-16 17:24:54','',''),(2616059,'1','187','939',418,'Retail Sale Id 1182663',2501.10,0.00,0.00,3.97,222.32,'2022-03-16 17:27:44','',''),(2616060,'1','187','939',418,'Retail Sale Id 1182664',1499.40,0.00,0.00,2.38,133.28,'2022-03-16 17:34:46','',''),(2616061,'1','187','939',418,'Retail Sale Id 1182665',3798.90,0.00,0.00,6.03,337.68,'2022-03-16 17:45:42','',''),(2616062,'1','187','939',418,'Retail Sale Id 1182666',18132.00,0.00,0.00,30.22,785.72,'2022-03-16 17:47:18','',''),(2616063,'1','187','939',418,'Retail Sale Id 1182667',1997.10,0.00,0.00,3.17,177.52,'2022-03-16 17:49:24','',''),(2616064,'1','187','939',418,'Retail Sale Id 1182668',900.90,0.00,0.00,1.43,80.08,'2022-03-16 17:50:21','',''),(2616065,'1','187','939',418,'Retail Sale Id 1182669',1001.70,0.00,0.00,1.59,89.04,'2022-03-16 17:54:30','',''),(2616066,'1','187','939',418,'Retail Sale Id 1182670',20090.70,0.00,0.00,31.89,1785.84,'2022-03-16 18:02:49','',''),(2616067,'1','187','939',418,'Retail Sale Id 1182671',2998.80,0.00,0.00,4.76,266.56,'2022-03-17 08:10:11','',''),(2616068,'1','187','939',418,'Retail Sale Id 1182672',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 08:11:37','',''),(2616069,'1','187','939',418,'Retail Sale Id 1182673',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 08:13:35','',''),(2616070,'1','187','939',418,'Retail Sale Id 1182674',2998.80,0.00,0.00,4.76,266.56,'2022-03-17 08:30:35','',''),(2616071,'1','187','939',418,'Retail Sale Id 1182675',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 08:34:48','',''),(2616072,'1','187','939',418,'Retail Sale Id 1182676',1701.00,0.00,0.00,2.70,151.20,'2022-03-17 08:38:52','',''),(2616073,'1','187','939',418,'Retail Sale Id 1182677',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 08:51:45','',''),(2616074,'1','187','939',418,'Retail Sale Id 1182678',2998.80,0.00,0.00,4.76,266.56,'2022-03-17 08:55:18','',''),(2616075,'1','187','939',418,'Retail Sale Id 1182679',24000.00,0.00,0.00,40.00,1040.00,'2022-03-17 09:00:46','',''),(2616076,'1','187','939',418,'Retail Sale Id 1182681',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 09:03:41','',''),(2616077,'1','187','939',418,'Retail Sale Id 1182682',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 09:07:17','',''),(2616078,'1','187','939',418,'Retail Sale Id 1182683',1902.60,0.00,0.00,3.02,169.12,'2022-03-17 09:31:01','',''),(2616079,'1','187','939',418,'Retail Sale Id 1182684',60000.00,0.00,0.00,100.00,2600.00,'2022-03-17 09:43:07','',''),(2616080,'1','187','939',418,'Retail Sale Id 1182685',15000.00,0.00,0.00,25.00,650.00,'2022-03-17 09:55:58','',''),(2616081,'1','187','939',418,'Retail Sale Id 1182686',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 10:21:09','',''),(2616082,'1','187','939',418,'Retail Sale Id 1182687',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 10:30:48','',''),(2616083,'1','187','939',418,'Retail Sale Id 1182688',1297.80,0.00,0.00,2.06,115.36,'2022-03-17 10:35:41','',''),(2616084,'1','187','939',418,'Retail Sale Id 1182689',12.60,0.00,0.00,0.02,1.12,'2022-03-17 10:53:26','',''),(2616085,'1','187','939',418,'Retail Sale Id 1182690',66000.00,0.00,0.00,110.00,2860.00,'2022-03-17 10:56:37','',''),(2616086,'1','187','939',418,'Retail Sale Id 1182691',2501.10,0.00,0.00,3.97,222.32,'2022-03-17 10:58:02','',''),(2616087,'1','187','939',418,'Retail Sale Id 1182692',1701.00,0.00,0.00,2.70,151.20,'2022-03-17 10:59:01','',''),(2616088,'1','187','939',418,'Retail Sale Id 1182693',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 11:00:07','',''),(2616089,'1','187','939',418,'Retail Sale Id 1182694',7900.20,0.00,0.00,12.54,702.24,'2022-03-17 11:02:37','',''),(2616090,'1','187','939',418,'Retail Sale Id 1182695',5997.60,0.00,0.00,9.52,533.12,'2022-03-17 11:13:19','',''),(2616091,'1','187','939',418,'Retail Sale Id 1182696',1297.80,0.00,0.00,2.06,115.36,'2022-03-17 11:28:01','',''),(2616092,'1','187','939',418,'Retail Sale Id 1182698',22200.00,0.00,0.00,37.00,962.00,'2022-03-17 11:34:20','',''),(2616093,'1','187','939',418,'Retail Sale Id 1182699',1902.60,0.00,0.00,3.02,169.12,'2022-03-17 11:39:22','',''),(2616094,'1','187','939',418,'Retail Sale Id 1182700',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 12:07:01','',''),(2616095,'1','187','939',418,'Retail Sale Id 1182701',1902.60,0.00,0.00,3.02,169.12,'2022-03-17 12:22:16','',''),(2616096,'1','187','939',418,'Retail Sale Id 1182702',3600.00,0.00,0.00,6.00,156.00,'2022-03-17 12:25:25','',''),(2616097,'1','187','939',418,'Retail Sale Id 1182703',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 12:33:22','',''),(2616098,'1','187','939',418,'Retail Sale Id 1182705',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 13:17:07','',''),(2616099,'1','187','939',418,'Retail Sale Id 1182706',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 13:26:10','',''),(2616100,'1','187','939',418,'Retail Sale Id 1182707',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 13:33:51','',''),(2616101,'1','187','939',418,'Retail Sale Id 1182708',1499.40,0.00,0.00,2.38,133.28,'2022-03-17 13:38:11','',''),(2616102,'1','187','939',418,'Retail Sale Id 1182709',90000.00,0.00,0.00,150.00,3900.00,'2022-03-17 13:40:22','',''),(2616103,'1','187','939',418,'Retail Sale Id 1182710',1297.80,0.00,0.00,2.06,115.36,'2022-03-17 14:05:40','',''),(2616104,'1','187','939',418,'Retail Sale Id 1182711',1499.40,0.00,0.00,2.38,133.28,'2022-03-17 14:23:44','',''),(2616105,'1','187','939',418,'Retail Sale Id 1182712',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 15:03:40','',''),(2616106,'1','187','939',418,'Retail Sale Id 1182713',90000.00,0.00,0.00,150.00,3900.00,'2022-03-17 15:06:15','',''),(2616107,'1','187','939',418,'Retail Sale Id 1182714',3798.90,0.00,0.00,6.03,337.68,'2022-03-17 15:43:25','',''),(2616108,'1','187','939',418,'Retail Sale Id 1182715',3502.80,0.00,0.00,5.56,311.36,'2022-03-17 15:44:44','',''),(2616109,'1','187','939',418,'Retail Sale Id 1182716',1499.40,0.00,0.00,2.38,133.28,'2022-03-17 15:48:05','',''),(2616110,'1','187','939',418,'Retail Sale Id 1182717',30000.00,0.00,0.00,50.00,1300.00,'2022-03-17 15:55:23','',''),(2616111,'1','187','939',418,'Retail Sale Id 1182718',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 17:25:16','',''),(2616112,'1','187','939',418,'Retail Sale Id 1182719',1197.00,0.00,0.00,1.90,106.40,'2022-03-17 17:29:03','',''),(2616113,'1','187','939',418,'Retail Sale Id 1182720',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 17:30:09','',''),(2616114,'1','187','939',418,'Retail Sale Id 1182721',120000.00,0.00,0.00,200.00,5200.00,'2022-03-17 17:32:27','',''),(2616115,'1','187','939',418,'Retail Sale Id 1182722',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 17:33:54','',''),(2616116,'1','187','939',418,'Retail Sale Id 1182723',120000.00,0.00,0.00,200.00,5200.00,'2022-03-17 17:34:06','',''),(2616117,'1','187','939',418,'Retail Sale Id 1182724',1997.10,0.00,0.00,3.17,177.52,'2022-03-17 17:36:27','',''),(2616118,'1','187','939',418,'Retail Sale Id 1182725',1499.40,0.00,0.00,2.38,133.28,'2022-03-17 17:46:47','',''),(2616119,'1','187','939',418,'Retail Sale Id 1182726',11400.00,0.00,0.00,19.00,494.00,'2022-03-17 17:52:30','',''),(2616120,'1','187','939',418,'Retail Sale Id 1182727',1001.70,0.00,0.00,1.59,89.04,'2022-03-17 17:55:31','',''),(2616121,'1','187','939',418,'Retail Sale Id 1182728',22396.50,0.00,0.00,35.55,1990.80,'2022-03-17 18:01:44','',''),(2616122,'1','187','939',418,'Retail Sale Id 1182730',34800.00,0.00,0.00,60.00,360.00,'2022-03-18 08:44:33','',''),(2616123,'1','187','939',418,'Retail Sale Id 1182731',58000.00,0.00,0.00,100.00,600.00,'2022-03-18 10:50:39','',''),(2616124,'1','187','939',418,'Retail Sale Id 1182732',46400.00,0.00,0.00,80.00,480.00,'2022-03-18 10:51:09','',''),(2616125,'1','187','939',418,'Retail Sale Id 1182735',64960.00,0.00,0.00,112.00,672.00,'2022-03-18 10:51:56','',''),(2616126,'1','187','939',418,'Retail Sale Id 1182736',37700.00,0.00,0.00,65.00,390.00,'2022-03-18 10:52:28','',''),(2616127,'1','187','939',418,'Retail Sale Id 1182737',29000.00,0.00,0.00,50.00,300.00,'2022-03-18 10:52:58','',''),(2616128,'1','187','939',418,'Retail Sale Id 1182739',75400.00,0.00,0.00,130.00,780.00,'2022-03-18 10:54:17','',''),(2616129,'1','187','939',418,'Retail Sale Id 1182740',58000.00,0.00,0.00,100.00,600.00,'2022-03-18 11:01:27','',''),(2616130,'1','187','939',418,'Retail Sale Id 1182741',29000.00,0.00,0.00,50.00,300.00,'2022-03-18 11:02:24','',''),(2616131,'1','187','939',418,'Retail Sale Id 1182742',6080.00,0.00,0.00,10.00,340.00,'2022-03-18 11:09:04','',''),(2616132,'1','187','939',418,'Retail Sale Id 1182743',7600.00,0.00,0.00,12.50,425.00,'2022-03-18 11:09:55','',''),(2616133,'1','187','939',418,'Retail Sale Id 1182744',6080.00,0.00,0.00,10.00,340.00,'2022-03-18 11:10:22','',''),(2616134,'1','187','939',418,'Retail Sale Id 1182745',34800.00,0.00,0.00,60.00,360.00,'2022-03-18 11:14:18','',''),(2616135,'1','187','939',418,'Retail Sale Id 1182746',34800.00,0.00,0.00,60.00,360.00,'2022-03-18 14:59:56','',''),(2616136,'1','187','939',418,'Retail Sale Id 1182747',23200.00,0.00,0.00,40.00,240.00,'2022-03-18 15:01:49','',''),(2616137,'1','187','939',418,'Retail Sale Id 1182748',9728.00,0.00,0.00,16.00,544.00,'2022-03-18 15:02:48','',''),(2616138,'1','187','939',418,'Retail Sale Id 1182749',4499.20,0.00,0.00,7.40,251.60,'2022-03-18 15:03:32','',''),(2616139,'1','187','939',418,'Retail Sale Id 1182750',3398.72,0.00,0.00,5.59,190.06,'2022-03-18 15:04:45','',''),(2616140,'1','187','939',418,'Retail Sale Id 1182751',4201.28,0.00,0.00,6.91,234.94,'2022-03-18 15:05:28','',''),(2616141,'1','187','939',418,'Retail Sale Id 1182752',3800.00,0.00,0.00,6.25,212.50,'2022-03-18 15:06:15','',''),(2616142,'1','187','939',418,'Retail Sale Id 1182753',7502.72,0.00,0.00,12.34,419.56,'2022-03-18 15:06:47','',''),(2616143,'1','187','939',418,'Retail Sale Id 1182754',5198.40,0.00,0.00,8.55,290.70,'2022-03-18 15:07:37','',''),(2616144,'1','187','939',418,'Retail Sale Id 1182755',4602.56,0.00,0.00,7.57,257.38,'2022-03-18 15:08:18','',''),(2616145,'1','187','939',418,'Retail Sale Id 1182756',4499.20,0.00,0.00,7.40,251.60,'2022-03-18 15:09:04','',''),(2616146,'1','187','939',418,'Retail Sale Id 1182757',3198.08,0.00,0.00,5.26,178.84,'2022-03-18 15:10:24','',''),(2616147,'1','187','939',418,'Retail Sale Id 1182758',997.12,0.00,0.00,1.64,55.76,'2022-03-18 15:10:59','',''),(2616148,'1','187','939',418,'Retail Sale Id 1182759',1197.76,0.00,0.00,1.97,66.98,'2022-03-18 15:11:49','',''),(2616149,'1','187','939',418,'Retail Sale Id 1182760',1903.04,0.00,0.00,3.13,106.42,'2022-03-18 15:14:14','',''),(2616150,'1','187','939',418,'Retail Sale Id 1182761',348000.00,0.00,0.00,600.00,3600.00,'2022-03-18 17:45:25','',''),(2616151,'1','187','939',418,'Retail Sale Id 1182762',174000.00,0.00,0.00,300.00,1800.00,'2022-03-18 17:45:59','',''),(2616152,'1','187','939',418,'Retail Sale Id 1182763',10730.00,0.00,0.00,18.50,111.00,'2022-03-18 17:47:37','',''),(2616153,'1','187','939',418,'Retail Sale Id 1182764',133400.00,0.00,0.00,230.00,1380.00,'2022-03-18 17:48:38','',''),(2616154,'1','187','939',418,'Retail Sale Id 1182765',104400.00,0.00,0.00,180.00,1080.00,'2022-03-18 17:49:29','',''),(2616155,'1','187','939',418,'Retail Sale Id 1182766',33060.00,0.00,0.00,57.00,342.00,'2022-03-18 17:50:18','',''),(2616156,'1','187','939',418,'Retail Sale Id 1182767',58000.00,0.00,0.00,100.00,600.00,'2022-03-18 17:51:38','',''),(2616157,'1','187','939',418,'Retail Sale Id 1182768',11281.00,0.00,0.00,19.45,116.70,'2022-03-18 17:54:53','',''),(2616158,'1','187','939',418,'Return of Retail Sale Id 1182735',0.00,64960.00,112.00,0.00,-672.00,'2022-03-18 18:17:06','',''),(2616159,'1','187','939',418,'Retail Sale Id 1182769',1526.08,0.00,0.00,2.51,85.34,'2022-03-18 18:44:44','',''),(2616160,'1','187','939',418,'Retail Sale Id 1182770',6153.80,0.00,0.00,10.61,63.66,'2022-03-18 18:47:29','',''),(2616161,'1','187','939',418,'Retail Sale Id 1182771',2320.00,0.00,0.00,4.00,24.00,'2022-03-18 19:00:39','',''),(2616162,'1','187','939',418,'Retail Sale Id 1182772',3769.60,0.00,0.00,6.20,210.80,'2022-03-19 08:19:39','',''),(2616163,'1','187','939',418,'Retail Sale Id 1182773',2997.44,0.00,0.00,4.93,167.62,'2022-03-19 08:20:02','',''),(2616164,'1','187','939',418,'Retail Sale Id 1182774',87000.00,0.00,0.00,150.00,900.00,'2022-03-19 08:22:49','',''),(2616165,'1','187','939',418,'Retail Sale Id 1182775',1702.40,0.00,0.00,2.80,95.20,'2022-03-19 08:24:42','',''),(2616166,'1','187','939',418,'Retail Sale Id 1182776',42340.00,0.00,0.00,73.00,438.00,'2022-03-19 08:31:47','',''),(2616167,'1','187','939',418,'Retail Sale Id 1182777',116000.00,0.00,0.00,200.00,1200.00,'2022-03-19 08:42:33','',''),(2616168,'1','187','939',418,'Retail Sale Id 1182778',29000.00,0.00,0.00,50.00,300.00,'2022-03-19 08:51:30','',''),(2616169,'1','187','939',418,'Retail Sale Id 1182779',24360.00,0.00,0.00,42.00,252.00,'2022-03-19 09:15:28','',''),(2616170,'1','187','939',418,'Retail Sale Id 1182780',29000.00,0.00,0.00,50.00,300.00,'2022-03-19 09:33:30','',''),(2616171,'1','187','939',418,'Retail Sale Id 1182781',2498.88,0.00,0.00,4.11,139.74,'2022-03-19 09:54:51','',''),(2616172,'1','187','939',418,'Retail Sale Id 1182782',33640.00,0.00,0.00,58.00,348.00,'2022-03-19 10:57:17','',''),(2616173,'1','187','939',418,'Retail Sale Id 1182783',17400.00,0.00,0.00,30.00,180.00,'2022-03-19 11:01:48','',''),(2616174,'1','187','939',418,'Retail Sale Id 1182784',145000.00,0.00,0.00,250.00,1500.00,'2022-03-19 11:05:27','',''),(2616175,'1','187','939',418,'Retail Sale Id 1182785',58000.00,0.00,0.00,100.00,600.00,'2022-03-19 11:29:00','',''),(2616176,'1','187','939',418,'Retail Sale Id 1182786',29000.00,0.00,0.00,50.00,300.00,'2022-03-19 11:58:16','',''),(2616177,'1','187','939',418,'Retail Sale Id 1182787',29000.00,0.00,0.00,50.00,300.00,'2022-03-19 12:02:26','',''),(2616178,'1','187','939',418,'Retail Sale Id 1182788',26100.00,0.00,0.00,45.00,270.00,'2022-03-19 12:07:20','',''),(2616179,'1','187','939',418,'Retail Sale Id 1182789',87000.00,0.00,0.00,150.00,900.00,'2022-03-19 12:49:08','',''),(2616180,'1','187','939',418,'Retail Sale Id 1182790',145000.00,0.00,0.00,250.00,1500.00,'2022-03-19 13:10:36','',''),(2616181,'1','187','939',418,'Retail Sale Id 1182791',145000.00,0.00,0.00,250.00,1500.00,'2022-03-19 13:11:50','',''),(2616182,'1','187','939',418,'Retail Sale Id 1182792',58000.00,0.00,0.00,100.00,600.00,'2022-03-19 13:13:36','',''),(2616183,'1','187','939',418,'Retail Sale Id 1182793',87000.00,0.00,0.00,150.00,900.00,'2022-03-19 13:14:38','',''),(2616184,'1','187','939',418,'Retail Sale Id 1182794',58000.00,0.00,0.00,100.00,600.00,'2022-03-19 14:08:25','',''),(2616185,'1','187','939',418,'Retail Sale Id 1182795',7600.00,0.00,0.00,12.50,425.00,'2022-03-19 14:09:43','',''),(2616186,'1','187','939',418,'Retail Sale Id 1182796',7600.00,0.00,0.00,12.50,425.00,'2022-03-19 14:10:16','',''),(2616187,'1','187','939',418,'Retail Sale Id 1182797',6688.00,0.00,0.00,11.00,374.00,'2022-03-19 14:10:49','',''),(2616188,'1','187','939',418,'Retail Sale Id 1182798',3404.80,0.00,0.00,5.60,190.40,'2022-03-19 14:11:15','',''),(2616189,'1','187','939',418,'Retail Sale Id 1182799',4560.00,0.00,0.00,7.50,255.00,'2022-03-19 14:12:34','',''),(2616190,'1','187','939',418,'Retail Sale Id 1182800',3830.40,0.00,0.00,6.30,214.20,'2022-03-19 14:13:16','',''),(2616191,'1','187','939',418,'Retail Sale Id 1182801',4256.00,0.00,0.00,7.00,238.00,'2022-03-19 14:15:09','',''),(2616192,'1','187','939',418,'Retail Sale Id 1182802',3648.00,0.00,0.00,6.00,204.00,'2022-03-19 14:17:17','',''),(2616193,'1','187','939',418,'Retail Sale Id 1182803',5228.80,0.00,0.00,8.60,292.40,'2022-03-19 14:17:40','',''),(2616194,'1','187','939',418,'Retail Sale Id 1182804',7600.00,0.00,0.00,12.50,425.00,'2022-03-19 14:21:14','',''),(2616195,'1','187','939',418,'Retail Sale Id 1182805',2128.00,0.00,0.00,3.50,119.00,'2022-03-19 14:21:40','',''),(2616196,'1','187','939',418,'Retail Sale Id 1182806',58000.00,0.00,0.00,100.00,600.00,'2022-03-19 15:09:38','',''),(2616197,'1','187','939',418,'Retail Sale Id 1182807',33060.00,0.00,0.00,57.00,342.00,'2022-03-19 15:35:21','',''),(2616198,'1','187','939',418,'Retail Sale Id 1182808',29000.00,0.00,0.00,50.00,300.00,'2022-03-19 15:37:43','',''),(2616199,'1','187','939',418,'Retail Sale Id 1182809',29000.00,0.00,0.00,50.00,300.00,'2022-03-19 16:05:30','',''),(2616200,'1','187','939',418,'Retail Sale Id 1182810',87000.00,0.00,0.00,150.00,900.00,'2022-03-19 16:07:58','',''),(2616201,'1','187','939',418,'Retail Sale Id 1182811',4000.64,0.00,0.00,6.58,223.72,'2022-03-19 17:04:13','',''),(2616202,'1','187','939',418,'Retail Sale Id 1182812',3502.08,0.00,0.00,5.76,195.84,'2022-03-19 17:12:40','',''),(2616203,'1','187','939',418,'Retail Sale Id 1182813',7296.00,0.00,0.00,12.00,408.00,'2022-03-19 17:13:38','',''),(2616204,'1','187','939',418,'Retail Sale Id 1182814',6080.00,0.00,0.00,10.00,340.00,'2022-03-19 17:14:12','',''),(2616205,'1','187','939',418,'Retail Sale Id 1182815',3040.00,0.00,0.00,5.00,170.00,'2022-03-19 17:14:32','',''),(2616206,'1','187','939',418,'Retail Sale Id 1182816',3648.00,0.00,0.00,6.00,204.00,'2022-03-19 17:15:16','',''),(2616207,'1','187','939',418,'Retail Sale Id 1182817',6080.00,0.00,0.00,10.00,340.00,'2022-03-19 17:50:41','',''),(2616208,'1','187','939',418,'Retail Sale Id 1182818',7904.00,0.00,0.00,13.00,442.00,'2022-03-19 17:58:50','',''),(2616209,'1','187','939',418,'Retail Sale Id 1182819',8019.52,0.00,0.00,13.19,448.46,'2022-03-19 17:59:13','',''),(2616210,'1','187','939',418,'Retail Sale Id 1182820',60900.00,0.00,0.00,105.00,630.00,'2022-03-20 10:16:13','',''),(2616211,'1','187','939',418,'Retail Sale Id 1182821',87000.00,0.00,0.00,150.00,900.00,'2022-03-20 10:55:20','',''),(2616212,'1','187','939',418,'Retail Sale Id 1182822',116000.00,0.00,0.00,200.00,1200.00,'2022-03-20 11:15:27','',''),(2616213,'1','187','939',418,'Retail Sale Id 1182823',29000.00,0.00,0.00,50.00,300.00,'2022-03-20 11:38:20','',''),(2616214,'1','187','939',418,'Retail Sale Id 1182824',58000.00,0.00,0.00,100.00,600.00,'2022-03-20 11:44:55','',''),(2616215,'1','187','939',418,'Retail Sale Id 1182825',58000.00,0.00,0.00,100.00,600.00,'2022-03-20 11:56:23','',''),(2616216,'1','187','939',418,'Retail Sale Id 1182826',58000.00,0.00,0.00,100.00,600.00,'2022-03-20 12:18:57','',''),(2616217,'1','187','939',418,'Retail Sale Id 1182827',58000.00,0.00,0.00,100.00,600.00,'2022-03-20 12:22:59','',''),(2616218,'1','187','939',418,'Retail Sale Id 1182828',7600.00,0.00,0.00,12.50,425.00,'2022-03-20 12:26:21','',''),(2616219,'1','187','939',418,'Retail Sale Id 1182830',29000.00,0.00,0.00,50.00,300.00,'2022-03-20 12:40:05','',''),(2616220,'1','187','939',418,'Retail Sale Id 1182831',6080.00,0.00,0.00,10.00,340.00,'2022-03-20 13:19:56','',''),(2616221,'1','187','939',418,'Retail Sale Id 1182832',6688.00,0.00,0.00,11.00,374.00,'2022-03-20 13:20:33','',''),(2616222,'1','187','939',418,'Retail Sale Id 1182833',4256.00,0.00,0.00,7.00,238.00,'2022-03-20 13:21:47','',''),(2616223,'1','187','939',418,'Retail Sale Id 1182834',3040.00,0.00,0.00,5.00,170.00,'2022-03-20 13:22:12','',''),(2616224,'1','187','939',418,'Retail Sale Id 1182835',3040.00,0.00,0.00,5.00,170.00,'2022-03-20 13:22:34','',''),(2616225,'1','187','939',418,'Retail Sale Id 1182836',4864.00,0.00,0.00,8.00,272.00,'2022-03-20 13:23:16','',''),(2616226,'1','187','939',418,'Retail Sale Id 1182837',11600.00,0.00,0.00,20.00,120.00,'2022-03-20 13:31:40','',''),(2616227,'1','187','939',418,'Retail Sale Id 1182838',4864.00,0.00,0.00,8.00,272.00,'2022-03-20 13:48:52','',''),(2616228,'1','187','939',418,'Retail Sale Id 1182839',3502.08,0.00,0.00,5.76,195.84,'2022-03-20 13:49:21','',''),(2616229,'1','187','939',418,'Retail Sale Id 1182840',4000.64,0.00,0.00,6.58,223.72,'2022-03-20 13:49:51','',''),(2616230,'1','187','939',418,'Retail Sale Id 1182841',4997.76,0.00,0.00,8.22,279.48,'2022-03-20 13:51:05','',''),(2616231,'1','187','939',418,'Retail Sale Id 1182842',9728.00,0.00,0.00,16.00,544.00,'2022-03-20 15:10:38','',''),(2616232,'1','187','939',418,'Retail Sale Id 1182843',3040.00,0.00,0.00,5.00,170.00,'2022-03-20 15:12:04','',''),(2616233,'1','187','939',418,'Retail Sale Id 1182844',4499.20,0.00,0.00,7.40,251.60,'2022-03-20 15:12:31','',''),(2616234,'1','187','939',418,'Retail Sale Id 1182845',13896.80,0.00,0.00,23.96,143.76,'2022-03-20 15:53:45','',''),(2616235,'1','187','939',418,'Retail Sale Id 1182846',23200.00,0.00,0.00,40.00,240.00,'2022-03-20 15:59:06','',''),(2616236,'1','187','939',418,'Retail Sale Id 1182847',29000.00,0.00,0.00,50.00,300.00,'2022-03-20 16:07:31','',''),(2616237,'1','187','939',418,'Retail Sale Id 1182848',12160.00,0.00,0.00,20.00,680.00,'2022-03-20 16:16:03','',''),(2616238,'1','187','939',418,'Retail Sale Id 1182849',7296.00,0.00,0.00,12.00,408.00,'2022-03-20 16:16:23','',''),(2616239,'1','187','939',418,'Retail Sale Id 1182850',67280.00,0.00,0.00,116.00,696.00,'2022-03-20 16:32:41','',''),(2616240,'1','187','939',418,'Retail Sale Id 1182851',29000.00,0.00,0.00,50.00,300.00,'2022-03-20 16:39:02','',''),(2616241,'1','187','939',418,'Retail Sale Id 1182852',8025.60,0.00,0.00,13.20,448.80,'2022-03-20 16:42:16','',''),(2616242,'1','187','939',418,'Retail Sale Id 1182853',7600.00,0.00,0.00,12.50,425.00,'2022-03-21 08:24:15','',''),(2616243,'1','187','939',418,'Retail Sale Id 1182854',6688.00,0.00,0.00,11.00,374.00,'2022-03-21 08:30:00','',''),(2616244,'1','187','939',418,'Retail Sale Id 1182855',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 08:33:29','',''),(2616245,'1','187','939',418,'Retail Sale Id 1182856',11600.00,0.00,0.00,20.00,120.00,'2022-03-21 08:36:24','',''),(2616246,'1','187','939',418,'Retail Sale Id 1182857',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 08:56:59','',''),(2616247,'1','187','939',418,'Retail Sale Id 1182858',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 09:06:15','',''),(2616248,'1','187','939',418,'Retail Sale Id 1182859',87000.00,0.00,0.00,150.00,900.00,'2022-03-21 09:12:54','',''),(2616249,'1','187','939',418,'Retail Sale Id 1182860',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 09:15:35','',''),(2616250,'1','187','939',418,'Retail Sale Id 1182861',67280.00,0.00,0.00,116.00,696.00,'2022-03-21 10:00:36','',''),(2616251,'1','187','939',418,'Retail Sale Id 1182862',48720.00,0.00,0.00,84.00,504.00,'2022-03-21 10:03:07','',''),(2616252,'1','187','939',418,'Retail Sale Id 1182863',58000.00,0.00,0.00,100.00,600.00,'2022-03-21 10:14:07','',''),(2616253,'1','187','939',418,'Retail Sale Id 1182864',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 10:42:11','',''),(2616254,'1','187','939',418,'Retail Sale Id 1182865',23200.00,0.00,0.00,40.00,240.00,'2022-03-21 10:53:56','',''),(2616255,'1','187','939',418,'Retail Sale Id 1182866',31998.60,0.00,0.00,55.17,331.02,'2022-03-21 10:56:55','',''),(2616256,'1','187','939',418,'Retail Sale Id 1182867',58000.00,0.00,0.00,100.00,600.00,'2022-03-21 11:08:59','',''),(2616257,'1','187','939',418,'Retail Sale Id 1182868',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 11:10:35','',''),(2616258,'1','187','939',418,'Retail Sale Id 1182869',58000.00,0.00,0.00,100.00,600.00,'2022-03-21 11:24:20','',''),(2616259,'1','187','939',418,'Retail Sale Id 1182870',10944.00,0.00,0.00,18.00,612.00,'2022-03-21 11:26:06','',''),(2616260,'1','187','939',418,'Retail Sale Id 1182871',6080.00,0.00,0.00,10.00,340.00,'2022-03-21 11:26:24','',''),(2616261,'1','187','939',418,'Retail Sale Id 1182872',39440.00,0.00,0.00,68.00,408.00,'2022-03-21 11:30:15','',''),(2616262,'1','187','939',418,'Retail Sale Id 1182873',87000.00,0.00,0.00,150.00,900.00,'2022-03-21 11:30:57','',''),(2616263,'1','187','939',418,'Retail Sale Id 1182874',91200.00,0.00,0.00,150.00,5100.00,'2022-03-21 11:31:53','',''),(2616264,'1','187','939',418,'Return of Retail Sale Id 1182874',0.00,91200.00,150.00,0.00,-5100.00,'2022-03-21 11:32:30','',''),(2616265,'1','187','939',418,'Retail Sale Id 1182876',87000.00,0.00,0.00,150.00,900.00,'2022-03-21 11:33:23','',''),(2616266,'1','187','939',418,'Retail Sale Id 1182877',58000.00,0.00,0.00,100.00,600.00,'2022-03-21 11:40:22','',''),(2616267,'1','187','939',418,'Retail Sale Id 1182879',14500.00,0.00,0.00,25.00,150.00,'2022-03-21 12:06:16','',''),(2616268,'1','187','939',418,'Retail Sale Id 1182880',87000.00,0.00,0.00,150.00,900.00,'2022-03-21 12:14:32','',''),(2616269,'1','187','939',418,'Retail Sale Id 1182882',58000.00,0.00,0.00,100.00,600.00,'2022-03-21 12:15:38','',''),(2616270,'1','187','939',418,'Retail Sale Id 1182883',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 12:18:06','',''),(2616271,'1','187','939',418,'Retail Sale Id 1182884',116000.00,0.00,0.00,200.00,1200.00,'2022-03-21 12:46:52','',''),(2616272,'1','187','939',418,'Retail Sale Id 1182885',997.12,0.00,0.00,1.64,55.76,'2022-03-21 13:22:38','',''),(2616273,'1','187','939',418,'Retail Sale Id 1182886',2997.44,0.00,0.00,4.93,167.62,'2022-03-21 13:23:05','',''),(2616274,'1','187','939',418,'Retail Sale Id 1182887',2000.32,0.00,0.00,3.29,111.86,'2022-03-21 13:23:30','',''),(2616275,'1','187','939',418,'Retail Sale Id 1182888',1501.76,0.00,0.00,2.47,83.98,'2022-03-21 13:23:57','',''),(2616276,'1','187','939',418,'Retail Sale Id 1182889',2000.32,0.00,0.00,3.29,111.86,'2022-03-21 13:24:23','',''),(2616277,'1','187','939',418,'Retail Sale Id 1182890',1501.76,0.00,0.00,2.47,83.98,'2022-03-21 13:24:57','',''),(2616278,'1','187','939',418,'Retail Sale Id 1182891',2498.88,0.00,0.00,4.11,139.74,'2022-03-21 13:25:25','',''),(2616279,'1','187','939',418,'Retail Sale Id 1182892',997.12,0.00,0.00,1.64,55.76,'2022-03-21 13:25:51','',''),(2616280,'1','187','939',418,'Retail Sale Id 1182893',2997.44,0.00,0.00,4.93,167.62,'2022-03-21 13:26:28','',''),(2616281,'1','187','939',418,'Retail Sale Id 1182894',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 14:48:20','',''),(2616282,'1','187','939',418,'Retail Sale Id 1182895',4000.64,0.00,0.00,6.58,223.72,'2022-03-21 15:04:37','',''),(2616283,'1','187','939',418,'Retail Sale Id 1182896',3702.72,0.00,0.00,6.09,207.06,'2022-03-21 15:05:00','',''),(2616284,'1','187','939',418,'Retail Sale Id 1182897',4602.56,0.00,0.00,7.57,257.38,'2022-03-21 15:05:19','',''),(2616285,'1','187','939',418,'Retail Sale Id 1182898',1903.04,0.00,0.00,3.13,106.42,'2022-03-21 15:05:41','',''),(2616286,'1','187','939',418,'Retail Sale Id 1182899',1817.92,0.00,0.00,2.99,101.66,'2022-03-21 15:06:03','',''),(2616287,'1','187','939',418,'Retail Sale Id 1182900',7016.32,0.00,0.00,11.54,392.36,'2022-03-21 15:06:27','',''),(2616288,'1','187','939',418,'Retail Sale Id 1182901',1495.68,0.00,0.00,2.46,83.64,'2022-03-21 15:06:48','',''),(2616289,'1','187','939',418,'Retail Sale Id 1182902',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 15:07:45','',''),(2616290,'1','187','939',418,'Retail Sale Id 1182903',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 15:17:51','',''),(2616291,'1','187','939',418,'Retail Sale Id 1182904',31900.00,0.00,0.00,55.00,330.00,'2022-03-21 15:39:43','',''),(2616292,'1','187','939',418,'Retail Sale Id 1182905',33640.00,0.00,0.00,58.00,348.00,'2022-03-21 15:46:43','',''),(2616293,'1','187','939',418,'Retail Sale Id 1182906',58000.00,0.00,0.00,100.00,600.00,'2022-03-21 16:00:13','',''),(2616294,'1','187','939',418,'Retail Sale Id 1182908',17400.00,0.00,0.00,30.00,180.00,'2022-03-21 16:10:12','',''),(2616295,'1','187','939',418,'Retail Sale Id 1182909',17400.00,0.00,0.00,30.00,180.00,'2022-03-21 16:14:11','',''),(2616296,'1','187','939',418,'Retail Sale Id 1182910',23200.00,0.00,0.00,40.00,240.00,'2022-03-21 16:34:35','',''),(2616297,'1','187','939',418,'Retail Sale Id 1182911',29000.00,0.00,0.00,50.00,300.00,'2022-03-21 16:58:18','',''),(2616298,'1','187','939',418,'Retail Sale Id 1182912',4797.12,0.00,0.00,7.89,268.26,'2022-03-21 17:24:03','',''),(2616299,'1','187','939',418,'Retail Sale Id 1182913',5997.20,0.00,0.00,10.34,62.04,'2022-03-21 17:42:54','',''),(2616300,'1','187','939',418,'Retail Sale Id 1182914',29121.80,0.00,0.00,50.21,301.26,'2022-03-21 17:45:56','',''),(2616301,'1','187','939',418,'Retail Sale Id 1182916',15504.00,0.00,0.00,25.50,867.00,'2022-03-21 17:50:08','',''),(2616302,'1','187','939',418,'Retail Sale Id 1182917',7600.00,0.00,0.00,12.50,425.00,'2022-03-21 17:50:52','',''),(2616303,'1','187','939',418,'Retail Sale Id 1182918',7600.00,0.00,0.00,12.50,425.00,'2022-03-21 17:51:26','',''),(2616304,'1','187','939',418,'Retail Sale Id 1182919',7600.00,0.00,0.00,12.50,425.00,'2022-03-21 17:53:09','',''),(2616305,'1','187','939',418,'Retail Sale Id 1182920',10944.00,0.00,0.00,18.00,612.00,'2022-03-21 17:53:36','',''),(2616306,'1','187','939',418,'Retail Sale Id 1182921',6080.00,0.00,0.00,10.00,340.00,'2022-03-21 17:53:56','',''),(2616307,'1','187','939',418,'Retail Sale Id 1182922',7904.00,0.00,0.00,13.00,442.00,'2022-03-21 17:57:12','',''),(2616308,'1','187','939',418,'Retail Sale Id 1182923',15200.00,0.00,0.00,25.00,850.00,'2022-03-21 17:57:34','',''),(2616309,'1','187','939',418,'Retail Sale Id 1182924',7502.72,0.00,0.00,12.34,419.56,'2022-03-21 18:01:38','',''),(2616310,'1','187','939',418,'Retail Sale Id 1182925',6000.96,0.00,0.00,9.87,335.58,'2022-03-21 18:01:57','',''),(2616311,'1','187','939',418,'Retail Sale Id 1182926',2997.44,0.00,0.00,4.93,167.62,'2022-03-21 18:02:19','',''),(2616312,'1','187','939',418,'Retail Sale Id 1182927',3543.80,0.00,0.00,6.11,36.66,'2022-03-21 18:03:58','',''),(2616313,'1','187','939',418,'Retail Sale Id 1182928',11199.36,0.00,0.00,18.42,626.28,'2022-03-21 18:15:00','',''),(2616314,'1','187','939',418,'Retail Sale Id 1182929',9223.36,0.00,0.00,15.17,515.78,'2022-03-22 08:38:49','',''),(2616315,'1','187','939',418,'Retail Sale Id 1182930',997.12,0.00,0.00,1.64,55.76,'2022-03-22 08:57:25','',''),(2616316,'1','187','939',418,'Retail Sale Id 1182931',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 09:24:06','',''),(2616317,'1','187','939',418,'Retail Sale Id 1182932',30740.00,0.00,0.00,53.00,318.00,'2022-03-22 09:27:27','',''),(2616318,'1','187','939',418,'Retail Sale Id 1182933',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 09:32:01','',''),(2616319,'1','187','939',418,'Retail Sale Id 1182934',7302.08,0.00,0.00,12.01,408.34,'2022-03-22 09:40:09','',''),(2616320,'1','187','939',418,'Retail Sale Id 1182935',1501.76,0.00,0.00,2.47,83.98,'2022-03-22 09:44:59','',''),(2616321,'1','187','939',418,'Retail Sale Id 1182936',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 09:51:35','',''),(2616322,'1','187','939',418,'Retail Sale Id 1182937',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 09:52:49','',''),(2616323,'1','187','939',418,'Retail Sale Id 1182938',4298.56,0.00,0.00,7.07,240.38,'2022-03-22 09:58:39','',''),(2616324,'1','187','939',418,'Retail Sale Id 1182939',2000.32,0.00,0.00,3.29,111.86,'2022-03-22 10:00:18','',''),(2616325,'1','187','939',418,'Retail Sale Id 1182940',34800.00,0.00,0.00,60.00,360.00,'2022-03-22 10:01:31','',''),(2616326,'1','187','939',418,'Retail Sale Id 1182941',997.12,0.00,0.00,1.64,55.76,'2022-03-22 10:10:12','',''),(2616327,'1','187','939',418,'Retail Sale Id 1182942',87000.00,0.00,0.00,150.00,900.00,'2022-03-22 10:19:40','',''),(2616328,'1','187','939',418,'Retail Sale Id 1182943',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 10:20:46','',''),(2616329,'1','187','939',418,'Retail Sale Id 1182944',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 10:21:45','',''),(2616330,'1','187','939',418,'Retail Sale Id 1182945',3702.72,0.00,0.00,6.09,207.06,'2022-03-22 10:22:50','',''),(2616331,'1','187','939',418,'Retail Sale Id 1182946',3648.00,0.00,0.00,6.00,204.00,'2022-03-22 10:36:43','',''),(2616332,'1','187','939',418,'Retail Sale Id 1182947',4864.00,0.00,0.00,8.00,272.00,'2022-03-22 10:46:47','',''),(2616333,'1','187','939',418,'Retail Sale Id 1182948',116000.00,0.00,0.00,200.00,1200.00,'2022-03-22 11:06:32','',''),(2616334,'1','187','939',418,'Retail Sale Id 1182949',997.12,0.00,0.00,1.64,55.76,'2022-03-22 11:09:29','',''),(2616335,'1','187','939',418,'Retail Sale Id 1182950',14500.00,0.00,0.00,25.00,150.00,'2022-03-22 11:21:22','',''),(2616336,'1','187','939',418,'Retail Sale Id 1182951',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 11:47:00','',''),(2616337,'1','187','939',418,'Retail Sale Id 1182952',1197.76,0.00,0.00,1.97,66.98,'2022-03-22 11:57:16','',''),(2616338,'1','187','939',418,'Retail Sale Id 1182953',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 12:03:11','',''),(2616339,'1','187','939',418,'Retail Sale Id 1182954',1197.76,0.00,0.00,1.97,66.98,'2022-03-22 12:04:14','',''),(2616340,'1','187','939',418,'Retail Sale Id 1182955',116000.00,0.00,0.00,200.00,1200.00,'2022-03-22 12:11:18','',''),(2616341,'1','187','939',418,'Retail Sale Id 1182956',997.12,0.00,0.00,1.64,55.76,'2022-03-22 12:12:51','',''),(2616342,'1','187','939',418,'Retail Sale Id 1182957',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 12:24:54','',''),(2616343,'1','187','939',418,'Retail Sale Id 1182958',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 12:26:10','',''),(2616344,'1','187','939',418,'Retail Sale Id 1182959',7502.72,0.00,0.00,12.34,419.56,'2022-03-22 12:27:33','',''),(2616345,'1','187','939',418,'Retail Sale Id 1182960',1501.76,0.00,0.00,2.47,83.98,'2022-03-22 12:58:56','',''),(2616346,'1','187','939',418,'Retail Sale Id 1182961',33640.00,0.00,0.00,58.00,348.00,'2022-03-22 13:04:07','',''),(2616347,'1','187','939',418,'Retail Sale Id 1182962',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 13:06:37','',''),(2616348,'1','187','939',418,'Retail Sale Id 1182963',4997.76,0.00,0.00,8.22,279.48,'2022-03-22 13:13:09','',''),(2616349,'1','187','939',418,'Retail Sale Id 1182964',997.12,0.00,0.00,1.64,55.76,'2022-03-22 13:22:08','',''),(2616350,'1','187','939',418,'Retail Sale Id 1182965',2000.32,0.00,0.00,3.29,111.86,'2022-03-22 13:22:52','',''),(2616351,'1','187','939',418,'Retail Sale Id 1182966',2000.32,0.00,0.00,3.29,111.86,'2022-03-22 13:23:46','',''),(2616352,'1','187','939',418,'Retail Sale Id 1182967',290000.00,0.00,0.00,50.00,261300.00,'2022-03-22 13:31:41','',''),(2616353,'1','187','939',418,'Retail Sale Id 1182968',116000.00,0.00,0.00,200.00,1200.00,'2022-03-22 13:36:53','',''),(2616354,'1','187','939',418,'Retail Sale Id 1182969',116000.00,0.00,0.00,200.00,1200.00,'2022-03-22 13:37:42','',''),(2616355,'1','187','939',418,'Retail Sale Id 1182970',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 13:38:42','',''),(2616356,'1','187','939',418,'Retail Sale Id 1182971',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 13:50:02','',''),(2616357,'1','187','939',418,'Retail Sale Id 1182972',145000.00,0.00,0.00,250.00,1500.00,'2022-03-22 14:01:13','',''),(2616358,'1','187','939',418,'Retail Sale Id 1182974',1197.76,0.00,0.00,1.97,66.98,'2022-03-22 14:02:52','',''),(2616359,'1','187','939',418,'Retail Sale Id 1182975',87000.00,0.00,0.00,150.00,900.00,'2022-03-22 14:10:26','',''),(2616360,'1','187','939',418,'Retail Sale Id 1182976',1197.76,0.00,0.00,1.97,66.98,'2022-03-22 14:28:29','',''),(2616361,'1','187','939',418,'Retail Sale Id 1182977',1301.12,0.00,0.00,2.14,72.76,'2022-03-22 15:02:14','',''),(2616362,'1','187','939',418,'Retail Sale Id 1182978',87000.00,0.00,0.00,150.00,900.00,'2022-03-22 15:08:39','',''),(2616363,'1','187','939',418,'Retail Sale Id 1182979',2000.32,0.00,0.00,3.29,111.86,'2022-03-22 15:09:43','',''),(2616364,'1','187','939',418,'Retail Sale Id 1182980',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 15:15:58','',''),(2616365,'1','187','939',418,'Retail Sale Id 1182981',1301.12,0.00,0.00,2.14,72.76,'2022-03-22 15:19:12','',''),(2616366,'1','187','939',418,'Retail Sale Id 1182982',2000.32,0.00,0.00,3.29,111.86,'2022-03-22 15:28:22','',''),(2616367,'1','187','939',418,'Retail Sale Id 1182983',1903.04,0.00,0.00,3.13,106.42,'2022-03-22 15:30:44','',''),(2616368,'1','187','939',418,'Retail Sale Id 1182984',3502.08,0.00,0.00,5.76,195.84,'2022-03-22 15:47:30','',''),(2616369,'1','187','939',418,'Retail Sale Id 1182985',3702.72,0.00,0.00,6.09,207.06,'2022-03-22 15:53:21','',''),(2616370,'1','187','939',418,'Retail Sale Id 1182986',3100.80,0.00,0.00,5.10,173.40,'2022-03-22 15:55:33','',''),(2616371,'1','187','939',418,'Retail Sale Id 1182987',46400.00,0.00,0.00,80.00,480.00,'2022-03-22 15:59:21','',''),(2616372,'1','187','939',418,'Retail Sale Id 1182988',58000.00,0.00,0.00,100.00,600.00,'2022-03-22 16:02:57','',''),(2616373,'1','187','939',418,'Retail Sale Id 1182989',7302.08,0.00,0.00,12.01,408.34,'2022-03-22 16:11:35','',''),(2616374,'1','187','939',418,'Retail Sale Id 1182990',2997.44,0.00,0.00,4.93,167.62,'2022-03-22 16:13:47','',''),(2616375,'1','187','939',418,'Retail Sale Id 1182991',997.12,0.00,0.00,1.64,55.76,'2022-03-22 16:21:40','',''),(2616376,'1','187','939',418,'Retail Sale Id 1182992',997.12,0.00,0.00,1.64,55.76,'2022-03-22 16:22:31','',''),(2616377,'1','187','939',418,'Retail Sale Id 1182993',2997.44,0.00,0.00,4.93,167.62,'2022-03-22 16:29:00','',''),(2616378,'1','187','939',418,'Retail Sale Id 1182994',319000.00,0.00,0.00,550.00,3300.00,'2022-03-22 17:51:19','',''),(2616379,'1','187','939',418,'Retail Sale Id 1182995',1988.16,0.00,0.00,3.27,111.18,'2022-03-22 17:57:28','',''),(2616380,'1','187','939',418,'Return of Retail Sale Id 1182967',0.00,290000.00,50.00,0.00,-261300.00,'2022-03-22 18:16:06','',''),(2616381,'1','187','939',418,'Retail Sale Id 1182996',29000.00,0.00,0.00,50.00,300.00,'2022-03-22 18:17:06','',''),(2616382,'1','187','939',418,'Retail Sale Id 1182997',634112.64,0.00,0.00,1100.89,2201.78,'2022-03-23 13:34:25','',''),(2616383,'1','187','939',418,'Retail Sale Id 1182998',334684.80,0.00,0.00,581.05,1162.10,'2022-03-23 13:36:14','',''),(2616384,'1','187','939',418,'Retail Sale Id 1182999',268848.00,0.00,0.00,466.75,933.50,'2022-03-23 13:37:11','',''),(2616385,'1','187','939',418,'Retail Sale Id 1183000',28800.00,0.00,0.00,50.00,100.00,'2022-03-23 13:37:58','',''),(2616386,'1','187','939',418,'Retail Sale Id 1183001',316800.00,0.00,0.00,550.00,1100.00,'2022-03-23 13:42:32','',''),(2616387,'1','187','939',418,'Distributed to OPERATIONAL LOSS for sales id:332545',51774.80,0.00,0.00,90.20,0.00,'2022-03-24 14:30:02','',''),(2616388,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,14277120.00,24960.00,0.00,0.00,'2022-03-25 09:53:23','',''),(2616389,'1','187',NULL,418,'Reception corrector for bridging 123747',0.00,0.00,0.00,24960.00,0.00,'2022-03-25 09:57:56','',''),(2616390,'1','187','939',418,'Received from bridging 123747',0.00,0.00,24960.00,0.00,0.00,'2022-03-25 09:57:56','',''),(2616391,'1','187','939',418,'Retail Sale Id 1183002',118000.00,0.00,0.00,200.00,3600.00,'2022-03-25 13:45:44','',''),(2616392,'1','187','939',418,'Retail Sale Id 1183003',147500.00,0.00,0.00,250.00,4500.00,'2022-03-25 13:47:31','',''),(2616393,'1','187','939',418,'Retail Sale Id 1183004',147500.00,0.00,0.00,250.00,4500.00,'2022-03-25 13:48:26','',''),(2616394,'1','187','939',418,'Retail Sale Id 1183005',277890.00,0.00,0.00,471.00,8478.00,'2022-03-25 13:53:09','',''),(2616395,'1','187','939',418,'Retail Sale Id 1183006',309750.00,0.00,0.00,525.00,9450.00,'2022-03-25 14:03:29','',''),(2616396,'1','187','939',418,'Retail Sale Id 1183007',29500.00,0.00,0.00,50.00,900.00,'2022-03-25 14:21:43','',''),(2616397,'1','187','939',418,'Retail Sale Id 1183008',33630.00,0.00,0.00,57.00,1026.00,'2022-03-25 14:25:42','',''),(2616398,'1','187','939',418,'Retail Sale Id 1183009',88500.00,0.00,0.00,150.00,2700.00,'2022-03-25 14:33:15','',''),(2616399,'1','187','939',418,'Retail Sale Id 1183010',7750.00,0.00,0.00,12.50,600.00,'2022-03-25 14:48:41','',''),(2616400,'1','187','939',418,'Retail Sale Id 1183011',2002.60,0.00,0.00,3.23,155.04,'2022-03-25 14:49:37','',''),(2616401,'1','187','939',418,'Retail Sale Id 1183012',1500.40,0.00,0.00,2.42,116.16,'2022-03-25 14:50:26','',''),(2616402,'1','187','939',418,'Retail Sale Id 1183013',3000.80,0.00,0.00,4.84,232.32,'2022-03-25 14:51:27','',''),(2616403,'1','187','939',418,'Retail Sale Id 1183014',4997.20,0.00,0.00,8.06,386.88,'2022-03-25 14:52:10','',''),(2616404,'1','187','939',418,'Retail Sale Id 1183015',3999.00,0.00,0.00,6.45,309.60,'2022-03-25 14:52:57','',''),(2616405,'1','187','939',418,'Retail Sale Id 1183016',12400.00,0.00,0.00,20.00,960.00,'2022-03-25 14:53:58','',''),(2616406,'1','187','939',418,'Retail Sale Id 1183017',10428.40,0.00,0.00,16.82,807.36,'2022-03-25 14:55:15','',''),(2616407,'1','187','939',418,'Retail Sale Id 1183018',1860.00,0.00,0.00,3.00,144.00,'2022-03-25 14:56:11','',''),(2616408,'1','187','939',418,'Retail Sale Id 1183019',29500.00,0.00,0.00,50.00,900.00,'2022-03-25 14:57:45','',''),(2616409,'1','187','939',418,'Retail Sale Id 1183020',59000.00,0.00,0.00,100.00,1800.00,'2022-03-25 14:59:36','',''),(2616410,'1','187','939',418,'Retail Sale Id 1183021',29500.00,0.00,0.00,50.00,900.00,'2022-03-25 15:11:10','',''),(2616411,'1','187','939',418,'Retail Sale Id 1183022',7750.00,0.00,0.00,12.50,600.00,'2022-03-25 17:31:42','',''),(2616412,'1','187','939',418,'Retail Sale Id 1183024',9120.00,0.00,0.00,15.00,540.00,'2022-03-25 18:25:25','',''),(2616413,'1','187','939',418,'Retail Sale Id 1183025',620.16,0.00,0.00,1.02,36.72,'2022-03-25 18:27:05','',''),(2616414,'1','187','939',418,'Retail Sale Id 1183026',9300.00,0.00,0.00,15.00,720.00,'2022-03-25 18:29:54','',''),(2616415,'1','187','939',418,'Return of Retail Sale Id 1183024',0.00,9120.00,15.00,0.00,-540.00,'2022-03-25 18:30:40','',''),(2616416,'1','187','939',418,'Retail Sale Id 1183027',7750.00,0.00,0.00,12.50,600.00,'2022-03-25 18:32:35','',''),(2616417,'1','187','939',418,'Retail Sale Id 1183028',6200.00,0.00,0.00,10.00,480.00,'2022-03-25 18:33:42','',''),(2616418,'1','187','939',418,'Retail Sale Id 1183029',15500.00,0.00,0.00,25.00,1200.00,'2022-03-25 18:38:52','',''),(2616419,'1','187','939',418,'Retail Sale Id 1183031',3720.00,0.00,0.00,6.00,288.00,'2022-03-25 18:40:18','',''),(2616420,'1','187','939',418,'Retail Sale Id 1183032',8060.00,0.00,0.00,13.00,624.00,'2022-03-25 18:41:11','',''),(2616421,'1','187','939',418,'Retail Sale Id 1183033',9300.00,0.00,0.00,15.00,720.00,'2022-03-25 18:43:59','',''),(2616422,'1','187','939',418,'Retail Sale Id 1183034',14880.00,0.00,0.00,24.00,1152.00,'2022-03-25 18:44:57','',''),(2616423,'1','187','939',418,'Retail Sale Id 1183035',178126.90,0.00,0.00,301.91,5434.38,'2022-03-25 18:57:17','',''),(2616424,'1','187','939',418,'Retail Sale Id 1183036',1002814.20,0.00,0.00,1728.99,13831.92,'2022-03-25 19:08:31','',''),(2616425,'1','187','939',418,'Retail Sale Id 1183037',29005.80,0.00,0.00,50.01,400.08,'2022-03-25 19:09:41','',''),(2616426,'1','187','939',418,'Retail Sale Id 1183038',7750.00,0.00,0.00,12.50,600.00,'2022-03-26 08:33:27','',''),(2616427,'1','187','939',418,'Retail Sale Id 1183039',47333.00,0.00,0.00,7.15,43243.20,'2022-03-26 08:34:46','',''),(2616428,'1','187','939',418,'Return of Retail Sale Id 1183039',0.00,47333.00,7.15,0.00,-43243.20,'2022-03-26 08:35:42','',''),(2616429,'1','187','939',418,'Retail Sale Id 1183040',4433.00,0.00,0.00,7.15,343.20,'2022-03-26 08:36:38','',''),(2616430,'1','187','939',418,'Retail Sale Id 1183041',17700.00,0.00,0.00,30.00,540.00,'2022-03-26 09:22:21','',''),(2616431,'1','187','939',418,'Retail Sale Id 1183042',20650.00,0.00,0.00,35.00,630.00,'2022-03-26 09:48:30','',''),(2616432,'1','187','939',418,'Retail Sale Id 1183043',2852.00,0.00,0.00,4.60,220.80,'2022-03-26 10:03:30','',''),(2616433,'1','187','939',418,'Retail Sale Id 1183044',10850.00,0.00,0.00,17.50,840.00,'2022-03-26 10:04:23','',''),(2616434,'1','187','939',418,'Retail Sale Id 1183045',3806.80,0.00,0.00,6.14,294.72,'2022-03-26 10:06:37','',''),(2616435,'1','187','939',418,'Retail Sale Id 1183046',8866.00,0.00,0.00,14.30,686.40,'2022-03-26 10:08:27','',''),(2616436,'1','187','939',418,'Retail Sale Id 1183047',6671.20,0.00,0.00,10.76,516.48,'2022-03-26 10:10:53','',''),(2616437,'1','187','939',418,'Retail Sale Id 1183048',3813.00,0.00,0.00,6.15,295.20,'2022-03-26 10:15:03','',''),(2616438,'1','187','939',418,'Retail Sale Id 1183049',59000.00,0.00,0.00,100.00,1800.00,'2022-03-26 10:23:15','',''),(2616439,'1','187','939',418,'Retail Sale Id 1183050',29500.00,0.00,0.00,50.00,900.00,'2022-03-26 10:32:40','',''),(2616440,'1','187','939',418,'Retail Sale Id 1183051',8680.00,0.00,0.00,14.00,672.00,'2022-03-26 11:00:01','',''),(2616441,'1','187','939',418,'Retail Sale Id 1183052',7440.00,0.00,0.00,12.00,576.00,'2022-03-26 11:00:58','',''),(2616442,'1','187','939',418,'Retail Sale Id 1183053',7148.60,0.00,0.00,11.53,553.44,'2022-03-26 11:04:37','',''),(2616443,'1','187','939',418,'Retail Sale Id 1183054',7601.20,0.00,0.00,12.26,588.48,'2022-03-26 11:07:52','',''),(2616444,'1','187','939',418,'Retail Sale Id 1183055',10149.40,0.00,0.00,16.37,785.76,'2022-03-26 11:12:01','',''),(2616445,'1','187','939',418,'Retail Sale Id 1183056',147500.00,0.00,0.00,250.00,4500.00,'2022-03-26 12:19:47','',''),(2616446,'1','187','939',418,'Retail Sale Id 1183057',147500.00,0.00,0.00,250.00,4500.00,'2022-03-26 12:20:44','',''),(2616447,'1','187','939',418,'Retail Sale Id 1183058',13570.00,0.00,0.00,23.00,414.00,'2022-03-26 12:21:58','',''),(2616448,'1','187','939',418,'Retail Sale Id 1183059',29500.00,0.00,0.00,50.00,900.00,'2022-03-26 12:26:30','',''),(2616449,'1','187','939',418,'Retail Sale Id 1183060',147500.00,0.00,0.00,250.00,4500.00,'2022-03-26 12:29:06','',''),(2616450,'1','187','939',418,'Retail Sale Id 1183061',90270.00,0.00,0.00,153.00,2754.00,'2022-03-26 12:30:15','',''),(2616451,'1','187','939',418,'Retail Sale Id 1183062',47200.00,0.00,0.00,80.00,1440.00,'2022-03-26 12:47:24','',''),(2616452,'1','187','939',418,'Retail Sale Id 1183063',88500.00,0.00,0.00,150.00,2700.00,'2022-03-26 13:08:43','',''),(2616453,'1','187','939',418,'Retail Sale Id 1183064',7440.00,0.00,0.00,12.00,576.00,'2022-03-26 13:14:46','',''),(2616454,'1','187','939',418,'Retail Sale Id 1183065',10540.00,0.00,0.00,17.00,816.00,'2022-03-26 13:17:31','',''),(2616455,'1','187','939',418,'Retail Sale Id 1183066',7973.20,0.00,0.00,12.86,617.28,'2022-03-26 13:20:46','',''),(2616456,'1','187','939',418,'Retail Sale Id 1183067',90860.00,0.00,0.00,154.00,2772.00,'2022-03-26 13:25:30','',''),(2616457,'1','187','939',418,'Retail Sale Id 1183068',34220.00,0.00,0.00,58.00,1044.00,'2022-03-26 13:44:51','',''),(2616458,'1','187','939',418,'Retail Sale Id 1183069',20650.00,0.00,0.00,35.00,630.00,'2022-03-26 15:18:14','',''),(2616459,'1','187','939',418,'Retail Sale Id 1183070',59000.00,0.00,0.00,100.00,1800.00,'2022-03-26 15:25:47','',''),(2616460,'1','187','939',418,'Retail Sale Id 1183071',8680.00,0.00,0.00,14.00,672.00,'2022-03-26 15:53:17','',''),(2616461,'1','187','939',418,'Retail Sale Id 1183072',6200.00,0.00,0.00,10.00,480.00,'2022-03-26 15:54:57','',''),(2616462,'1','187','939',418,'Retail Sale Id 1183073',5902.40,0.00,0.00,9.52,456.96,'2022-03-26 15:56:56','',''),(2616463,'1','187','939',418,'Retail Sale Id 1183074',6652.60,0.00,0.00,10.73,515.04,'2022-03-26 15:58:42','',''),(2616464,'1','187','939',418,'Retail Sale Id 1183075',29500.00,0.00,0.00,50.00,900.00,'2022-03-26 16:51:24','',''),(2616465,'1','187','939',418,'Retail Sale Id 1183076',118000.00,0.00,0.00,200.00,3600.00,'2022-03-26 17:04:36','',''),(2616466,'1','187','939',418,'Retail Sale Id 1183077',29500.00,0.00,0.00,50.00,900.00,'2022-03-26 17:29:32','',''),(2616467,'1','187','939',418,'Retail Sale Id 1183078',18290.00,0.00,0.00,31.00,558.00,'2022-03-26 17:32:21','',''),(2616468,'1','187','939',418,'Retail Sale Id 1183079',7440.00,0.00,0.00,12.00,576.00,'2022-03-26 18:04:47','',''),(2616469,'1','187','939',418,'Retail Sale Id 1183080',6894.40,0.00,0.00,11.12,533.76,'2022-03-26 18:07:44','',''),(2616470,'1','187','939',418,'Retail Sale Id 1183081',7750.00,0.00,0.00,12.50,600.00,'2022-03-26 18:09:57','',''),(2616471,'1','187','939',418,'Retail Sale Id 1183082',8866.00,0.00,0.00,14.30,686.40,'2022-03-26 18:11:37','',''),(2616472,'1','187','939',418,'Retail Sale Id 1183083',8060.00,0.00,0.00,13.00,624.00,'2022-03-26 18:13:23','',''),(2616473,'1','187','939',418,'Retail Sale Id 1183084',948.60,0.00,0.00,1.53,73.44,'2022-03-26 18:14:42','',''),(2616474,'1','187','939',418,'Retail Sale Id 1183085',936.20,0.00,0.00,1.51,72.48,'2022-03-26 18:30:04','',''),(2616475,'1','187','939',418,'Retail Sale Id 1183086',0.00,0.00,0.00,0.00,0.00,'2022-03-27 09:52:10','',''),(2616476,'1','187','939',418,'Retail Sale Id 1183087',30500.00,0.00,0.00,50.00,1900.00,'2022-03-27 10:54:20','',''),(2616477,'1','187','939',418,'Retail Sale Id 1183089',38240.90,0.00,0.00,62.69,2382.22,'2022-03-27 11:00:05','',''),(2616478,'1','187','939',418,'Retail Sale Id 1183090',76250.00,0.00,0.00,125.00,4750.00,'2022-03-27 11:06:18','',''),(2616479,'1','187','939',418,'Retail Sale Id 1183092',61000.00,0.00,0.00,100.00,3800.00,'2022-03-27 11:24:47','',''),(2616480,'1','187','939',418,'Retail Sale Id 1183093',61000.00,0.00,0.00,100.00,3800.00,'2022-03-27 11:32:50','',''),(2616481,'1','187','939',418,'Retail Sale Id 1183094',24400.00,0.00,0.00,40.00,1520.00,'2022-03-27 11:35:25','',''),(2616482,'1','187','939',418,'Retail Sale Id 1183095',67100.00,0.00,0.00,110.00,4180.00,'2022-03-27 12:17:19','',''),(2616483,'1','187','939',418,'Retail Sale Id 1183096',14640.00,0.00,0.00,24.00,912.00,'2022-03-27 12:19:43','',''),(2616484,'1','187','939',418,'Retail Sale Id 1183097',15250.00,0.00,0.00,25.00,950.00,'2022-03-27 12:25:02','',''),(2616485,'1','187','939',418,'Retail Sale Id 1183098',18300.00,0.00,0.00,30.00,1140.00,'2022-03-27 12:29:53','',''),(2616486,'1','187','939',418,'Retail Sale Id 1183099',35990.00,0.00,0.00,59.00,2242.00,'2022-03-27 12:41:53','',''),(2616487,'1','187','939',418,'Retail Sale Id 1183100',91500.00,0.00,0.00,150.00,5700.00,'2022-03-27 13:12:28','',''),(2616488,'1','187','939',418,'Retail Sale Id 1183101',61000.00,0.00,0.00,100.00,3800.00,'2022-03-27 13:14:48','',''),(2616489,'1','187','939',418,'Retail Sale Id 1183102',61000.00,0.00,0.00,100.00,3800.00,'2022-03-27 15:51:07','',''),(2616490,'1','187','939',418,'Retail Sale Id 1183103',30500.00,0.00,0.00,50.00,1900.00,'2022-03-27 16:00:03','',''),(2616491,'1','187','939',418,'Retail Sale Id 1183104',8000.00,0.00,0.00,12.50,850.00,'2022-03-27 16:00:50','',''),(2616492,'1','187','939',418,'Retail Sale Id 1183105',11200.00,0.00,0.00,17.50,1190.00,'2022-03-27 16:02:03','',''),(2616493,'1','187','939',418,'Retail Sale Id 1183106',5120.00,0.00,0.00,8.00,544.00,'2022-03-27 16:02:44','',''),(2616494,'1','187','939',418,'Retail Sale Id 1183107',9600.00,0.00,0.00,15.00,1020.00,'2022-03-27 16:03:34','',''),(2616495,'1','187','939',418,'Retail Sale Id 1183108',6400.00,0.00,0.00,10.00,680.00,'2022-03-27 16:04:06','',''),(2616496,'1','187','939',418,'Retail Sale Id 1183109',11520.00,0.00,0.00,18.00,1224.00,'2022-03-27 16:05:36','',''),(2616497,'1','187','939',418,'Retail Sale Id 1183110',4340.00,0.00,0.00,7.00,336.00,'2022-03-27 16:06:02','',''),(2616498,'1','187','939',418,'Retail Sale Id 1183112',14080.00,0.00,0.00,22.00,1496.00,'2022-03-27 16:06:48','',''),(2616499,'1','187','939',418,'Retail Sale Id 1183113',9600.00,0.00,0.00,15.00,1020.00,'2022-03-27 16:07:58','',''),(2616500,'1','187','939',418,'Retail Sale Id 1183114',3840.00,0.00,0.00,6.00,408.00,'2022-03-27 16:08:38','',''),(2616501,'1','187','939',418,'Retail Sale Id 1183115',6400.00,0.00,0.00,10.00,680.00,'2022-03-27 16:10:40','',''),(2616502,'1','187','939',418,'Retail Sale Id 1183116',3200.00,0.00,0.00,5.00,340.00,'2022-03-27 16:12:02','',''),(2616503,'1','187','939',418,'Retail Sale Id 1183117',6400.00,0.00,0.00,10.00,680.00,'2022-03-27 16:14:23','',''),(2616504,'1','187','939',418,'Retail Sale Id 1183119',8000.00,0.00,0.00,12.50,850.00,'2022-03-27 16:16:35','',''),(2616505,'1','187','939',418,'Retail Sale Id 1183120',3910.40,0.00,0.00,6.11,415.48,'2022-03-27 16:28:32','',''),(2616506,'1','187','939',418,'Retail Sale Id 1183121',1390.80,0.00,0.00,2.28,86.64,'2022-03-27 16:53:58','',''),(2616507,'1','187','939',418,'Retail Sale Id 1183122',5490.00,0.00,0.00,9.00,342.00,'2022-03-27 17:18:48','',''),(2616508,'1','187','939',418,'Retail Sale Id 1183123',30500.00,0.00,0.00,50.00,1900.00,'2022-03-28 08:09:45','',''),(2616509,'1','187','939',418,'Retail Sale Id 1183124',3720.00,0.00,0.00,6.00,288.00,'2022-03-28 08:30:59','',''),(2616510,'1','187','939',418,'Retail Sale Id 1183125',3100.00,0.00,0.00,5.00,240.00,'2022-03-28 08:31:24','',''),(2616511,'1','187','939',418,'Retail Sale Id 1183126',4960.00,0.00,0.00,8.00,384.00,'2022-03-28 08:31:47','',''),(2616512,'1','187','939',418,'Retail Sale Id 1183127',7750.00,0.00,0.00,12.50,600.00,'2022-03-28 08:32:08','',''),(2616513,'1','187','939',418,'Retail Sale Id 1183128',30500.00,0.00,0.00,50.00,1900.00,'2022-03-28 08:46:14','',''),(2616514,'1','187','939',418,'Retail Sale Id 1183129',30500.00,0.00,0.00,50.00,1900.00,'2022-03-28 08:53:37','',''),(2616515,'1','187','939',418,'Retail Sale Id 1183130',122000.00,0.00,0.00,200.00,7600.00,'2022-03-28 09:15:23','',''),(2616516,'1','187','939',418,'Retail Sale Id 1183131',122000.00,0.00,0.00,200.00,7600.00,'2022-03-28 09:17:25','',''),(2616517,'1','187','939',418,'Retail Sale Id 1183132',33550.00,0.00,0.00,55.00,2090.00,'2022-03-28 09:22:23','',''),(2616518,'1','187','939',418,'Retail Sale Id 1183133',30500.00,0.00,0.00,50.00,1900.00,'2022-03-28 09:29:45','',''),(2616519,'1','187','939',418,'Retail Sale Id 1183134',61000.00,0.00,0.00,100.00,3800.00,'2022-03-28 09:47:07','',''),(2616520,'1','187','939',418,'Retail Sale Id 1183135',3000.80,0.00,0.00,4.84,232.32,'2022-03-28 10:02:57','',''),(2616521,'1','187','939',418,'Retail Sale Id 1183136',24400.00,0.00,0.00,40.00,1520.00,'2022-03-28 10:04:00','',''),(2616522,'1','187','939',418,'Retail Sale Id 1183137',7930.00,0.00,0.00,13.00,494.00,'2022-03-28 10:18:53','',''),(2616523,'1','187','939',418,'Retail Sale Id 1183139',129625.00,0.00,0.00,212.50,8075.00,'2022-03-28 10:37:31','',''),(2616524,'1','187','939',418,'Retail Sale Id 1183141',61000.00,0.00,0.00,100.00,3800.00,'2022-03-28 11:05:56','',''),(2616525,'1','187','939',418,'Retail Sale Id 1183142',7750.00,0.00,0.00,12.50,600.00,'2022-03-28 11:59:02','',''),(2616526,'1','187','939',418,'Retail Sale Id 1183143',2498.60,0.00,0.00,4.03,193.44,'2022-03-28 11:59:34','',''),(2616527,'1','187','939',418,'Retail Sale Id 1183144',5598.60,0.00,0.00,9.03,433.44,'2022-03-28 12:00:23','',''),(2616528,'1','187','939',418,'Retail Sale Id 1183145',4501.20,0.00,0.00,7.26,348.48,'2022-03-28 12:36:00','',''),(2616529,'1','187','939',418,'Retail Sale Id 1183146',91500.00,0.00,0.00,150.00,5700.00,'2022-03-28 12:44:13','',''),(2616530,'1','187','939',418,'Retail Sale Id 1183147',61000.00,0.00,0.00,100.00,3800.00,'2022-03-28 12:47:26','',''),(2616531,'1','187','939',418,'Retail Sale Id 1183148',15250.00,0.00,0.00,25.00,950.00,'2022-03-28 13:06:22','',''),(2616532,'1','187','939',418,'Retail Sale Id 1183149',152500.00,0.00,0.00,250.00,9500.00,'2022-03-28 13:37:53','',''),(2616533,'1','187','939',418,'Retail Sale Id 1183150',152500.00,0.00,0.00,250.00,9500.00,'2022-03-28 13:38:33','',''),(2616534,'1','187','939',418,'Retail Sale Id 1183151',152500.00,0.00,0.00,250.00,9500.00,'2022-03-28 13:39:42','',''),(2616535,'1','187','939',418,'Retail Sale Id 1183152',30500.00,0.00,0.00,50.00,1900.00,'2022-03-28 14:04:17','',''),(2616536,'1','187','939',418,'Retail Sale Id 1183153',15250.00,0.00,0.00,25.00,950.00,'2022-03-28 15:15:21','',''),(2616537,'1','187','939',418,'Retail Sale Id 1183154',10000.60,0.00,0.00,16.13,774.24,'2022-03-28 15:41:37','',''),(2616538,'1','187','939',418,'Retail Sale Id 1183155',4997.20,0.00,0.00,8.06,386.88,'2022-03-28 15:42:09','',''),(2616539,'1','187','939',418,'Retail Sale Id 1183156',7750.00,0.00,0.00,12.50,600.00,'2022-03-28 15:42:43','',''),(2616540,'1','187','939',418,'Retail Sale Id 1183157',2480.00,0.00,0.00,4.00,192.00,'2022-03-28 15:43:02','',''),(2616541,'1','187','939',418,'Retail Sale Id 1183158',1860.00,0.00,0.00,3.00,144.00,'2022-03-28 15:45:45','',''),(2616542,'1','187','939',418,'Retail Sale Id 1183159',25132.00,0.00,0.00,41.20,1565.60,'2022-03-28 16:30:04','',''),(2616543,'1','187','939',418,'Retail Sale Id 1183160',61000.00,0.00,0.00,100.00,3800.00,'2022-03-28 16:35:33','',''),(2616544,'1','187','939',418,'Retail Sale Id 1183161',30500.00,0.00,0.00,50.00,1900.00,'2022-03-28 16:36:27','',''),(2616545,'1','187','939',418,'Retail Sale Id 1183162',7750.00,0.00,0.00,12.50,600.00,'2022-03-28 16:58:46','',''),(2616546,'1','187','939',418,'Retail Sale Id 1183163',36600.00,0.00,0.00,60.00,2280.00,'2022-03-28 16:59:51','',''),(2616547,'1','187','939',418,'Retail Sale Id 1183164',12400.00,0.00,0.00,20.00,960.00,'2022-03-28 17:16:51','',''),(2616548,'1','187','939',418,'Retail Sale Id 1183166',6497.60,0.00,0.00,10.48,503.04,'2022-03-28 17:17:23','',''),(2616549,'1','187','939',418,'Retail Sale Id 1183167',4960.00,0.00,0.00,8.00,384.00,'2022-03-28 17:17:49','',''),(2616550,'1','187','939',418,'Retail Sale Id 1183168',6200.00,0.00,0.00,10.00,480.00,'2022-03-28 17:18:11','',''),(2616551,'1','187','939',418,'Retail Sale Id 1183169',6820.00,0.00,0.00,11.00,528.00,'2022-03-28 17:18:31','',''),(2616552,'1','187','939',418,'Retail Sale Id 1183170',1860.00,0.00,0.00,3.00,144.00,'2022-03-28 17:18:50','',''),(2616553,'1','187','939',418,'Retail Sale Id 1183171',3100.00,0.00,0.00,5.00,240.00,'2022-03-28 17:19:08','',''),(2616554,'1','187','939',418,'Retail Sale Id 1183172',4960.00,0.00,0.00,8.00,384.00,'2022-03-28 17:19:40','',''),(2616555,'1','187','939',418,'Retail Sale Id 1183173',4340.00,0.00,0.00,7.00,336.00,'2022-03-28 17:19:57','',''),(2616556,'1','187','939',418,'Retail Sale Id 1183174',2170.00,0.00,0.00,3.50,168.00,'2022-03-28 17:20:17','',''),(2616557,'1','187','939',418,'Retail Sale Id 1183175',1860.00,0.00,0.00,3.00,144.00,'2022-03-28 17:21:44','',''),(2616558,'1','187','939',418,'Retail Sale Id 1183176',2480.00,0.00,0.00,4.00,192.00,'2022-03-28 17:22:04','',''),(2616559,'1','187','939',418,'Retail Sale Id 1183177',2480.00,0.00,0.00,4.00,192.00,'2022-03-28 17:22:22','',''),(2616560,'1','187','939',418,'Retail Sale Id 1183178',4960.00,0.00,0.00,8.00,384.00,'2022-03-28 17:23:38','',''),(2616561,'1','187','939',418,'Retail Sale Id 1183179',3100.00,0.00,0.00,5.00,240.00,'2022-03-28 17:23:59','',''),(2616562,'1','187','939',418,'Retail Sale Id 1183180',3720.00,0.00,0.00,6.00,288.00,'2022-03-28 17:24:35','',''),(2616563,'1','187','939',418,'Retail Sale Id 1183181',57950.00,0.00,0.00,95.00,3610.00,'2022-03-28 17:26:43','',''),(2616564,'1','187','939',418,'Retail Sale Id 1183182',25620.00,0.00,0.00,42.00,1596.00,'2022-03-28 17:57:19','',''),(2616565,'1','187','939',418,'Retail Sale Id 1183183',7750.00,0.00,0.00,12.50,600.00,'2022-03-28 18:06:12','',''),(2616566,'1','187','939',418,'Retail Sale Id 1183184',3720.00,0.00,0.00,6.00,288.00,'2022-03-28 18:06:35','',''),(2616567,'1','187','939',418,'Retail Sale Id 1183185',3844.00,0.00,0.00,6.20,297.60,'2022-03-28 18:06:54','',''),(2616568,'1','187','939',418,'Retail Sale Id 1183186',3348.00,0.00,0.00,5.40,259.20,'2022-03-28 18:07:15','',''),(2616569,'1','187','939',418,'Retail Sale Id 1183187',6200.00,0.00,0.00,10.00,480.00,'2022-03-28 18:07:49','',''),(2616570,'1','187','939',418,'Retail Sale Id 1183188',3503.00,0.00,0.00,5.65,271.20,'2022-03-28 18:10:29','',''),(2616571,'1','187','939',418,'Retail Sale Id 1183189',2002.60,0.00,0.00,3.23,155.04,'2022-03-28 18:10:54','',''),(2616572,'1','187','939',418,'Retail Sale Id 1183190',11048.40,0.00,0.00,17.82,855.36,'2022-03-28 18:22:56','',''),(2616573,'1','187','939',418,'Retail Sale Id 1183192',91500.00,0.00,0.00,150.00,5700.00,'2022-03-28 18:26:37','',''),(2616574,'1','187','939',418,'Retail Sale Id 1183193',61000.00,0.00,0.00,100.00,3800.00,'2022-03-28 18:27:22','',''),(2616575,'1','187','939',418,'Retail Sale Id 1183194',15030.40,0.00,0.00,24.64,936.32,'2022-03-28 18:55:31','',''),(2616576,'1','187','939',418,'Retail Sale Id 1183195',17226.40,0.00,0.00,28.24,1073.12,'2022-03-28 18:56:59','',''),(2616577,'1','187','939',418,'Retail Sale Id 1183196',8370.00,0.00,0.00,13.50,648.00,'2022-03-28 18:59:58','',''),(2616578,'1','187','939',418,'Retail Sale Id 1183197',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 08:41:27','',''),(2616579,'1','187','939',418,'Retail Sale Id 1183198',396500.00,0.00,0.00,650.00,24700.00,'2022-03-29 08:42:22','',''),(2616580,'1','187','939',418,'Retail Sale Id 1183199',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 08:44:04','',''),(2616581,'1','187','939',418,'Retail Sale Id 1183200',2259.20,0.00,0.00,3.53,240.04,'2022-03-29 08:46:12','',''),(2616582,'1','187','939',418,'Retail Sale Id 1183201',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 08:54:38','',''),(2616583,'1','187','939',418,'Retail Sale Id 1183202',3500.80,0.00,0.00,5.47,371.96,'2022-03-29 08:54:59','',''),(2616584,'1','187','939',418,'Retail Sale Id 1183203',30500.00,0.00,0.00,50.00,1900.00,'2022-03-29 09:07:31','',''),(2616585,'1','187','939',418,'Retail Sale Id 1183204',0.00,0.00,0.00,0.00,0.00,'2022-03-29 09:12:11','',''),(2616586,'1','187','939',418,'Retail Sale Id 1183205',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 09:31:59','',''),(2616587,'1','187','939',418,'Retail Sale Id 1183206',30500.00,0.00,0.00,50.00,1900.00,'2022-03-29 09:39:53','',''),(2616588,'1','187','939',418,'Retail Sale Id 1183207',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 09:44:51','',''),(2616589,'1','187','939',418,'Retail Sale Id 1183208',29280.00,0.00,0.00,48.00,1824.00,'2022-03-29 10:07:54','',''),(2616590,'1','187','939',418,'Retail Sale Id 1183209',30500.00,0.00,0.00,50.00,1900.00,'2022-03-29 11:28:53','',''),(2616591,'1','187','939',418,'Retail Sale Id 1183210',24400.00,0.00,0.00,40.00,1520.00,'2022-03-29 11:39:55','',''),(2616592,'1','187','939',418,'Retail Sale Id 1183211',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 12:30:48','',''),(2616593,'1','187','939',418,'Retail Sale Id 1183212',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 13:10:18','',''),(2616594,'1','187','939',418,'Retail Sale Id 1183213',0.00,0.00,0.00,0.00,0.00,'2022-03-29 13:19:52','',''),(2616595,'1','187','939',418,'Retail Sale Id 1183214',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 13:22:43','',''),(2616596,'1','187','939',418,'Retail Sale Id 1183215',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 13:51:50','',''),(2616597,'1','187','939',418,'Retail Sale Id 1183217',11590.00,0.00,0.00,19.00,722.00,'2022-03-29 14:31:01','',''),(2616598,'1','187','939',418,'Retail Sale Id 1183218',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 14:40:12','',''),(2616599,'1','187','939',418,'Retail Sale Id 1183219',6400.00,0.00,0.00,10.00,680.00,'2022-03-29 14:40:33','',''),(2616600,'1','187','939',418,'Retail Sale Id 1183220',3840.00,0.00,0.00,6.00,408.00,'2022-03-29 14:40:54','',''),(2616601,'1','187','939',418,'Retail Sale Id 1183221',3001.60,0.00,0.00,4.69,318.92,'2022-03-29 14:41:24','',''),(2616602,'1','187','939',418,'Retail Sale Id 1183222',3200.00,0.00,0.00,5.00,340.00,'2022-03-29 14:42:14','',''),(2616603,'1','187','939',418,'Retail Sale Id 1183223',6400.00,0.00,0.00,10.00,680.00,'2022-03-29 14:47:16','',''),(2616604,'1','187','939',418,'Retail Sale Id 1183224',2803.20,0.00,0.00,4.38,297.84,'2022-03-29 14:47:39','',''),(2616605,'1','187','939',418,'Retail Sale Id 1183225',4499.20,0.00,0.00,7.03,478.04,'2022-03-29 14:48:24','',''),(2616606,'1','187','939',418,'Retail Sale Id 1183226',3398.40,0.00,0.00,5.31,361.08,'2022-03-29 14:49:05','',''),(2616607,'1','187','939',418,'Retail Sale Id 1183227',3699.20,0.00,0.00,5.78,393.04,'2022-03-29 14:49:30','',''),(2616608,'1','187','939',418,'Retail Sale Id 1183228',8320.00,0.00,0.00,13.00,884.00,'2022-03-29 14:50:28','',''),(2616609,'1','187','939',418,'Retail Sale Id 1183229',6003.20,0.00,0.00,9.38,637.84,'2022-03-29 14:50:52','',''),(2616610,'1','187','939',418,'Retail Sale Id 1183230',2003.20,0.00,0.00,3.13,212.84,'2022-03-29 14:51:14','',''),(2616611,'1','187','939',418,'Retail Sale Id 1183231',1497.60,0.00,0.00,2.34,159.12,'2022-03-29 14:51:33','',''),(2616612,'1','187','939',418,'Retail Sale Id 1183232',1497.60,0.00,0.00,2.34,159.12,'2022-03-29 14:52:16','',''),(2616613,'1','187','939',418,'Retail Sale Id 1183233',3584.00,0.00,0.00,5.60,380.80,'2022-03-29 14:52:56','',''),(2616614,'1','187','939',418,'Retail Sale Id 1183234',9920.00,0.00,0.00,15.50,1054.00,'2022-03-29 14:54:11','',''),(2616615,'1','187','939',418,'Retail Sale Id 1183235',2240.00,0.00,0.00,3.50,238.00,'2022-03-29 14:54:35','',''),(2616616,'1','187','939',418,'Retail Sale Id 1183236',1664.00,0.00,0.00,2.60,176.80,'2022-03-29 14:54:53','',''),(2616617,'1','187','939',418,'Retail Sale Id 1183237',2003.20,0.00,0.00,3.13,212.84,'2022-03-29 14:55:22','',''),(2616618,'1','187','939',418,'Retail Sale Id 1183238',3840.00,0.00,0.00,6.00,408.00,'2022-03-29 14:55:39','',''),(2616619,'1','187','939',418,'Retail Sale Id 1183239',3840.00,0.00,0.00,6.00,408.00,'2022-03-29 14:56:00','',''),(2616620,'1','187','939',418,'Retail Sale Id 1183240',4480.00,0.00,0.00,7.00,476.00,'2022-03-29 14:56:26','',''),(2616621,'1','187','939',418,'Retail Sale Id 1183241',5120.00,0.00,0.00,8.00,544.00,'2022-03-29 14:56:58','',''),(2616622,'1','187','939',418,'Retail Sale Id 1183242',5120.00,0.00,0.00,8.00,544.00,'2022-03-29 14:57:20','',''),(2616623,'1','187','939',418,'Retail Sale Id 1183243',5760.00,0.00,0.00,9.00,612.00,'2022-03-29 14:57:44','',''),(2616624,'1','187','939',418,'Retail Sale Id 1183244',5120.00,0.00,0.00,8.00,544.00,'2022-03-29 14:58:02','',''),(2616625,'1','187','939',418,'Retail Sale Id 1183245',30500.00,0.00,0.00,50.00,1900.00,'2022-03-29 15:04:57','',''),(2616626,'1','187','939',418,'Retail Sale Id 1183246',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 15:12:05','',''),(2616627,'1','187','939',418,'Retail Sale Id 1183247',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 15:13:00','',''),(2616628,'1','187','939',418,'Retail Sale Id 1183248',35380.00,0.00,0.00,58.00,2204.00,'2022-03-29 15:15:53','',''),(2616629,'1','187','939',418,'Retail Sale Id 1183250',35380.00,0.00,0.00,58.00,2204.00,'2022-03-29 15:18:41','',''),(2616630,'1','187','939',418,'Retail Sale Id 1183251',30500.00,0.00,0.00,50.00,1900.00,'2022-03-29 16:07:32','',''),(2616631,'1','187','939',418,'Retail Sale Id 1183252',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 16:30:06','',''),(2616632,'1','187','939',418,'Retail Sale Id 1183253',152500.00,0.00,0.00,250.00,9500.00,'2022-03-29 16:40:48','',''),(2616633,'1','187','939',418,'Retail Sale Id 1183254',6400.00,0.00,0.00,10.00,680.00,'2022-03-29 16:46:31','',''),(2616634,'1','187','939',418,'Retail Sale Id 1183255',4102.40,0.00,0.00,6.41,435.88,'2022-03-29 16:47:05','',''),(2616635,'1','187','939',418,'Retail Sale Id 1183256',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 16:48:03','',''),(2616636,'1','187','939',418,'Retail Sale Id 1183257',3897.60,0.00,0.00,6.09,414.12,'2022-03-29 16:50:13','',''),(2616637,'1','187','939',418,'Retail Sale Id 1183258',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 16:51:37','',''),(2616638,'1','187','939',418,'Retail Sale Id 1183259',4864.00,0.00,0.00,7.60,516.80,'2022-03-29 17:02:03','',''),(2616639,'1','187','939',418,'Retail Sale Id 1183260',4128.00,0.00,0.00,6.45,438.60,'2022-03-29 17:02:35','',''),(2616640,'1','187','939',418,'Retail Sale Id 1183261',7040.00,0.00,0.00,11.00,748.00,'2022-03-29 17:03:03','',''),(2616641,'1','187','939',418,'Retail Sale Id 1183263',5440.00,0.00,0.00,8.50,578.00,'2022-03-29 17:03:31','',''),(2616642,'1','187','939',418,'Retail Sale Id 1183264',3840.00,0.00,0.00,6.00,408.00,'2022-03-29 17:04:07','',''),(2616643,'1','187','939',418,'Retail Sale Id 1183265',37820.00,0.00,0.00,62.00,2356.00,'2022-03-29 17:20:30','',''),(2616644,'1','187','939',418,'Retail Sale Id 1183266',0.00,0.00,0.00,0.00,0.00,'2022-03-29 17:21:27','',''),(2616645,'1','187','939',418,'Retail Sale Id 1183267',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 17:27:02','',''),(2616646,'1','187','939',418,'Retail Sale Id 1183268',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 17:29:18','',''),(2616647,'1','187','939',418,'Retail Sale Id 1183269',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 17:32:02','',''),(2616648,'1','187','939',418,'Retail Sale Id 1183270',0.00,0.00,0.00,0.00,0.00,'2022-03-29 17:51:33','',''),(2616649,'1','187','939',418,'Retail Sale Id 1183271',53680.00,0.00,0.00,88.00,3344.00,'2022-03-29 17:54:00','',''),(2616650,'1','187','939',418,'Retail Sale Id 1183272',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 17:57:35','',''),(2616651,'1','187','939',418,'Retail Sale Id 1183273',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 17:57:58','',''),(2616652,'1','187','939',418,'Retail Sale Id 1183274',6400.00,0.00,0.00,10.00,680.00,'2022-03-29 17:58:50','',''),(2616653,'1','187','939',418,'Retail Sale Id 1183275',5120.00,0.00,0.00,8.00,544.00,'2022-03-29 17:59:10','',''),(2616654,'1','187','939',418,'Retail Sale Id 1183276',3840.00,0.00,0.00,6.00,408.00,'2022-03-29 17:59:45','',''),(2616655,'1','187','939',418,'Retail Sale Id 1183277',3200.00,0.00,0.00,5.00,340.00,'2022-03-29 18:00:12','',''),(2616656,'1','187','939',418,'Retail Sale Id 1183278',3200.00,0.00,0.00,5.00,340.00,'2022-03-29 18:00:38','',''),(2616657,'1','187','939',418,'Retail Sale Id 1183279',2240.00,0.00,0.00,3.50,238.00,'2022-03-29 18:01:01','',''),(2616658,'1','187','939',418,'Retail Sale Id 1183280',91500.00,0.00,0.00,150.00,5700.00,'2022-03-29 18:02:36','',''),(2616659,'1','187','939',418,'Retail Sale Id 1183281',61000.00,0.00,0.00,100.00,3800.00,'2022-03-29 18:11:22','',''),(2616660,'1','187','939',418,'Retail Sale Id 1183282',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 18:25:44','',''),(2616661,'1','187','939',418,'Retail Sale Id 1183283',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 18:26:05','',''),(2616662,'1','187','939',418,'Retail Sale Id 1183284',8000.00,0.00,0.00,12.50,850.00,'2022-03-29 18:26:40','',''),(2616663,'1','187','939',418,'Retail Sale Id 1183285',9145.60,0.00,0.00,14.29,971.72,'2022-03-29 18:27:04','',''),(2616664,'1','187','939',418,'Retail Sale Id 1183286',34074.60,0.00,0.00,55.86,2122.68,'2022-03-29 18:30:31','',''),(2616665,'1','187','939',418,'Retail Sale Id 1183287',0.00,0.00,0.00,0.00,0.00,'2022-03-30 08:20:29','',''),(2616666,'1','187','939',418,'Retail Sale Id 1183289',39650.00,0.00,0.00,65.00,2470.00,'2022-03-30 09:03:53','',''),(2616667,'1','187','939',418,'Retail Sale Id 1183290',61000.00,0.00,0.00,100.00,3800.00,'2022-03-30 09:34:40','',''),(2616668,'1','187','939',418,'Retail Sale Id 1183291',30500.00,0.00,0.00,50.00,1900.00,'2022-03-30 09:41:33','',''),(2616669,'1','187','939',418,'Retail Sale Id 1183292',21350.00,0.00,0.00,35.00,1330.00,'2022-03-30 09:50:01','',''),(2616670,'1','187','939',418,'Retail Sale Id 1183293',61000.00,0.00,0.00,100.00,3800.00,'2022-03-30 10:05:48','',''),(2616671,'1','187','939',418,'Retail Sale Id 1183294',61000.00,0.00,0.00,100.00,3800.00,'2022-03-30 10:12:17','',''),(2616672,'1','187','939',418,'Retail Sale Id 1183295',152500.00,0.00,0.00,250.00,9500.00,'2022-03-30 10:13:04','',''),(2616673,'1','187','939',418,'Retail Sale Id 1183296',24400.00,0.00,0.00,40.00,1520.00,'2022-03-30 10:39:36','',''),(2616674,'1','187','939',418,'Retail Sale Id 1183297',122000.00,0.00,0.00,200.00,7600.00,'2022-03-30 10:49:24','',''),(2616675,'1','187','939',418,'Retail Sale Id 1183298',30500.00,0.00,0.00,50.00,1900.00,'2022-03-30 10:50:41','',''),(2616676,'1','187','939',418,'Retail Sale Id 1183299',0.00,0.00,0.00,0.00,0.00,'2022-03-30 10:51:36','',''),(2616677,'1','187','939',418,'Retail Sale Id 1183300',15250.00,0.00,0.00,25.00,950.00,'2022-03-30 10:54:47','',''),(2616678,'1','187','939',418,'Retail Sale Id 1183301',30500.00,0.00,0.00,50.00,1900.00,'2022-03-30 11:01:36','',''),(2616679,'1','187','939',418,'Retail Sale Id 1183302',30500.00,0.00,0.00,50.00,1900.00,'2022-03-30 11:05:18','',''),(2616680,'1','187','939',418,'Retail Sale Id 1183303',30500.00,0.00,0.00,50.00,1900.00,'2022-03-30 11:06:37','',''),(2616681,'1','187','939',418,'Retail Sale Id 1183304',111020.00,0.00,0.00,182.00,6916.00,'2022-03-30 11:08:23','',''),(2616682,'1','187','939',418,'Retail Sale Id 1183305',91500.00,0.00,0.00,150.00,5700.00,'2022-03-30 11:13:57','',''),(2616683,'1','187','939',418,'Retail Sale Id 1183306',61000.00,0.00,0.00,100.00,3800.00,'2022-03-30 11:19:10','',''),(2616684,'1','187','939',418,'Retail Sale Id 1183307',27450.00,0.00,0.00,45.00,1710.00,'2022-03-30 11:25:51','',''),(2616685,'1','187','939',418,'Retail Sale Id 1183308',36600.00,0.00,0.00,60.00,2280.00,'2022-03-30 11:36:28','',''),(2616686,'1','187','939',418,'Retail Sale Id 1183309',58560.00,0.00,0.00,96.00,3648.00,'2022-03-30 12:08:28','',''),(2616687,'1','187','939',418,'Retail Sale Id 1183310',8000.00,0.00,0.00,12.50,850.00,'2022-03-30 12:51:52','',''),(2616688,'1','187','939',418,'Retail Sale Id 1183311',6400.00,0.00,0.00,10.00,680.00,'2022-03-30 12:52:24','',''),(2616689,'1','187','939',418,'Retail Sale Id 1183312',12800.00,0.00,0.00,20.00,1360.00,'2022-03-30 12:52:44','',''),(2616690,'1','187','939',418,'Retail Sale Id 1183313',3840.00,0.00,0.00,6.00,408.00,'2022-03-30 12:53:05','',''),(2616691,'1','187','939',418,'Retail Sale Id 1183314',3840.00,0.00,0.00,6.00,408.00,'2022-03-30 12:54:53','',''),(2616692,'1','187','939',418,'Retail Sale Id 1183315',5120.00,0.00,0.00,8.00,544.00,'2022-03-30 12:55:17','',''),(2616693,'1','187','939',418,'Retail Sale Id 1183316',5760.00,0.00,0.00,9.00,612.00,'2022-03-30 12:55:47','',''),(2616694,'1','187','939',418,'Retail Sale Id 1183317',4480.00,0.00,0.00,7.00,476.00,'2022-03-30 12:56:08','',''),(2616695,'1','187','939',418,'Retail Sale Id 1183318',8000.00,0.00,0.00,12.50,850.00,'2022-03-30 12:57:10','',''),(2616696,'1','187','939',418,'Retail Sale Id 1183319',8000.00,0.00,0.00,12.50,850.00,'2022-03-30 12:57:29','',''),(2616697,'1','187','939',418,'Retail Sale Id 1183320',4800.00,0.00,0.00,7.50,510.00,'2022-03-30 12:57:55','',''),(2616698,'1','187','939',418,'Retail Sale Id 1183321',5760.00,0.00,0.00,9.00,612.00,'2022-03-30 12:58:15','',''),(2616699,'1','187','939',418,'Retail Sale Id 1183322',3840.00,0.00,0.00,6.00,408.00,'2022-03-30 12:58:51','',''),(2616700,'1','187','939',418,'Retail Sale Id 1183323',5120.00,0.00,0.00,8.00,544.00,'2022-03-30 12:59:08','',''),(2616701,'1','187','939',418,'Retail Sale Id 1183324',7040.00,0.00,0.00,11.00,748.00,'2022-03-30 12:59:35','',''),(2616702,'1','187','939',418,'Retail Sale Id 1183325',6400.00,0.00,0.00,10.00,680.00,'2022-03-30 12:59:57','',''),(2616703,'1','187','939',418,'Retail Sale Id 1183326',5497.60,0.00,0.00,8.59,584.12,'2022-03-30 13:00:34','',''),(2616704,'1','187','939',418,'Retail Sale Id 1183327',4992.00,0.00,0.00,7.80,530.40,'2022-03-30 13:00:57','',''),(2616705,'1','187','939',418,'Retail Sale Id 1183328',6144.00,0.00,0.00,9.60,652.80,'2022-03-30 13:01:51','',''),(2616706,'1','187','939',418,'Retail Sale Id 1183329',8000.00,0.00,0.00,12.50,850.00,'2022-03-30 13:02:14','',''),(2616707,'1','187','939',418,'Retail Sale Id 1183330',30500.00,0.00,0.00,50.00,1900.00,'2022-03-30 13:41:12','',''),(2616708,'1','187','939',418,'Retail Sale Id 1183331',61000.00,0.00,0.00,100.00,3800.00,'2022-03-30 13:53:06','',''),(2616709,'1','187','939',418,'Retail Sale Id 1183332',91500.00,0.00,0.00,150.00,5700.00,'2022-03-30 14:19:22','',''),(2616710,'1','187','939',418,'Retail Sale Id 1183333',14213.00,0.00,0.00,23.30,885.40,'2022-03-30 15:34:32','',''),(2616711,'1','187','939',418,'Retail Sale Id 1183334',91500.00,0.00,0.00,150.00,5700.00,'2022-03-30 16:16:55','',''),(2616712,'1','187','939',418,'Retail Sale Id 1183335',35380.00,0.00,0.00,58.00,2204.00,'2022-03-30 16:35:55','',''),(2616713,'1','187','939',418,'Retail Sale Id 1183336',61000.00,0.00,0.00,100.00,3800.00,'2022-03-30 17:33:31','',''),(2616714,'1','187','939',418,'Retail Sale Id 1183337',3840.00,0.00,0.00,6.00,408.00,'2022-03-30 17:55:58','',''),(2616715,'1','187','939',418,'Retail Sale Id 1183338',57901.20,0.00,0.00,94.92,3606.96,'2022-03-30 18:02:19','',''),(2616716,'1','187','939',418,'Retail Sale Id 1183339',16000.00,0.00,0.00,25.00,1700.00,'2022-03-30 18:41:29','',''),(2616717,'1','187','939',418,'Retail Sale Id 1183340',10240.00,0.00,0.00,16.00,1088.00,'2022-03-30 18:41:50','',''),(2616718,'1','187','939',418,'Retail Sale Id 1183341',2515.20,0.00,0.00,3.93,267.24,'2022-03-30 18:42:37','',''),(2616719,'1','187','939',418,'Retail Sale Id 1183342',8659.20,0.00,0.00,13.53,920.04,'2022-03-31 08:52:28','',''),(2616720,'1','187','939',418,'Retail Sale Id 1183343',0.00,0.00,0.00,0.00,0.00,'2022-03-31 08:56:49','',''),(2616721,'1','187','939',418,'Retail Sale Id 1183345',30500.00,0.00,0.00,50.00,1900.00,'2022-03-31 09:43:46','',''),(2616722,'1','187','939',418,'Retail Sale Id 1183346',91500.00,0.00,0.00,150.00,5700.00,'2022-03-31 10:13:05','',''),(2616723,'1','187','939',418,'Retail Sale Id 1183347',61000.00,0.00,0.00,100.00,3800.00,'2022-03-31 10:18:34','',''),(2616724,'1','187','939',418,'Retail Sale Id 1183349',91500.00,0.00,0.00,150.00,5700.00,'2022-03-31 11:45:13','',''),(2616725,'1','187','939',418,'Retail Sale Id 1183350',103090.00,0.00,0.00,169.00,6422.00,'2022-03-31 11:46:05','',''),(2616726,'1','187','939',418,'Retail Sale Id 1183351',61000.00,0.00,0.00,100.00,3800.00,'2022-03-31 11:47:11','',''),(2616727,'1','187','939',418,'Retail Sale Id 1183352',61000.00,0.00,0.00,100.00,3800.00,'2022-03-31 11:48:02','',''),(2616728,'1','187','939',418,'Retail Sale Id 1183353',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 12:05:18','',''),(2616729,'1','187','939',418,'Retail Sale Id 1183354',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 12:05:37','',''),(2616730,'1','187','939',418,'Retail Sale Id 1183355',6400.00,0.00,0.00,10.00,680.00,'2022-03-31 12:05:59','',''),(2616731,'1','187','939',418,'Retail Sale Id 1183356',4352.00,0.00,0.00,6.80,462.40,'2022-03-31 12:06:20','',''),(2616732,'1','187','939',418,'Retail Sale Id 1183357',4800.00,0.00,0.00,7.50,510.00,'2022-03-31 12:06:39','',''),(2616733,'1','187','939',418,'Retail Sale Id 1183358',3840.00,0.00,0.00,6.00,408.00,'2022-03-31 12:06:57','',''),(2616734,'1','187','939',418,'Retail Sale Id 1183359',3840.00,0.00,0.00,6.00,408.00,'2022-03-31 12:07:19','',''),(2616735,'1','187','939',418,'Retail Sale Id 1183360',998.40,0.00,0.00,1.56,106.08,'2022-03-31 12:07:39','',''),(2616736,'1','187','939',418,'Retail Sale Id 1183361',5504.00,0.00,0.00,8.60,584.80,'2022-03-31 12:08:01','',''),(2616737,'1','187','939',418,'Retail Sale Id 1183362',1920.00,0.00,0.00,3.00,204.00,'2022-03-31 12:08:23','',''),(2616738,'1','187','939',418,'Retail Sale Id 1183363',1920.00,0.00,0.00,3.00,204.00,'2022-03-31 12:08:42','',''),(2616739,'1','187','939',418,'Retail Sale Id 1183364',3200.00,0.00,0.00,5.00,340.00,'2022-03-31 12:09:01','',''),(2616740,'1','187','939',418,'Retail Sale Id 1183365',6400.00,0.00,0.00,10.00,680.00,'2022-03-31 12:09:19','',''),(2616741,'1','187','939',418,'Retail Sale Id 1183366',5760.00,0.00,0.00,9.00,612.00,'2022-03-31 12:09:40','',''),(2616742,'1','187','939',418,'Retail Sale Id 1183367',3840.00,0.00,0.00,6.00,408.00,'2022-03-31 12:10:00','',''),(2616743,'1','187','939',418,'Retail Sale Id 1183368',2560.00,0.00,0.00,4.00,272.00,'2022-03-31 12:10:20','',''),(2616744,'1','187','939',418,'Retail Sale Id 1183369',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 12:10:38','',''),(2616745,'1','187','939',418,'Retail Sale Id 1183370',11840.00,0.00,0.00,18.50,1258.00,'2022-03-31 12:10:57','',''),(2616746,'1','187','939',418,'Retail Sale Id 1183371',4499.20,0.00,0.00,7.03,478.04,'2022-03-31 12:11:15','',''),(2616747,'1','187','939',418,'Retail Sale Id 1183372',3801.60,0.00,0.00,5.94,403.92,'2022-03-31 12:11:34','',''),(2616748,'1','187','939',418,'Retail Sale Id 1183373',14640.00,0.00,0.00,24.00,912.00,'2022-03-31 12:14:27','',''),(2616749,'1','187','939',418,'Retail Sale Id 1183374',61000.00,0.00,0.00,100.00,3800.00,'2022-03-31 12:33:35','',''),(2616750,'1','187','939',418,'Retail Sale Id 1183375',213500.00,0.00,0.00,350.00,13300.00,'2022-03-31 12:48:32','',''),(2616751,'1','187','939',418,'Retail Sale Id 1183376',183000.00,0.00,0.00,300.00,11400.00,'2022-03-31 12:50:08','',''),(2616752,'1','187','939',418,'Retail Sale Id 1183377',15250.00,0.00,0.00,25.00,950.00,'2022-03-31 12:59:20','',''),(2616753,'1','187','939',418,'Retail Sale Id 1183378',42700.00,0.00,0.00,70.00,2660.00,'2022-03-31 14:08:34','',''),(2616754,'1','187','939',418,'Retail Sale Id 1183379',30500.00,0.00,0.00,50.00,1900.00,'2022-03-31 14:43:21','',''),(2616755,'1','187','939',418,'Retail Sale Id 1183381',122000.00,0.00,0.00,200.00,7600.00,'2022-03-31 14:52:50','',''),(2616756,'1','187','939',418,'Retail Sale Id 1183382',63928.00,0.00,0.00,104.80,3982.40,'2022-03-31 15:23:57','',''),(2616757,'1','187','939',418,'Retail Sale Id 1183383',30500.00,0.00,0.00,50.00,1900.00,'2022-03-31 15:26:44','',''),(2616758,'1','187','939',418,'Retail Sale Id 1183384',61000.00,0.00,0.00,100.00,3800.00,'2022-03-31 15:27:56','',''),(2616759,'1','187','939',418,'Retail Sale Id 1183385',3200.00,0.00,0.00,5.00,340.00,'2022-03-31 15:31:32','',''),(2616760,'1','187','939',418,'Retail Sale Id 1183386',3361.10,0.00,0.00,5.51,209.38,'2022-03-31 15:35:48','',''),(2616761,'1','187','939',418,'Retail Sale Id 1183387',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 17:11:52','',''),(2616762,'1','187','939',418,'Retail Sale Id 1183388',15250.00,0.00,0.00,25.00,950.00,'2022-03-31 17:12:38','',''),(2616763,'1','187','939',418,'Retail Sale Id 1183389',16470.00,0.00,0.00,27.00,1026.00,'2022-03-31 18:01:57','',''),(2616764,'1','187','939',418,'Retail Sale Id 1183390',4499.20,0.00,0.00,7.03,478.04,'2022-03-31 18:02:42','',''),(2616765,'1','187','939',418,'Retail Sale Id 1183391',74639.60,0.00,0.00,122.36,4649.68,'2022-03-31 18:26:53','',''),(2616766,'1','187','939',418,'Retail Sale Id 1183392',100497.50,0.00,0.00,164.75,6260.50,'2022-03-31 18:28:08','',''),(2616767,'1','187','939',418,'Retail Sale Id 1183393',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 18:35:14','',''),(2616768,'1','187','939',418,'Retail Sale Id 1183394',15360.00,0.00,0.00,24.00,1632.00,'2022-03-31 18:35:31','',''),(2616769,'1','187','939',418,'Retail Sale Id 1183395',11840.00,0.00,0.00,18.50,1258.00,'2022-03-31 18:35:47','',''),(2616770,'1','187','939',418,'Retail Sale Id 1183396',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 18:36:17','',''),(2616771,'1','187','939',418,'Retail Sale Id 1183397',10240.00,0.00,0.00,16.00,1088.00,'2022-03-31 18:36:54','',''),(2616772,'1','187','939',418,'Retail Sale Id 1183398',5120.00,0.00,0.00,8.00,544.00,'2022-03-31 18:37:13','',''),(2616773,'1','187','939',418,'Retail Sale Id 1183399',3840.00,0.00,0.00,6.00,408.00,'2022-03-31 18:37:30','',''),(2616774,'1','187','939',418,'Retail Sale Id 1183400',8320.00,0.00,0.00,13.00,884.00,'2022-03-31 18:37:47','',''),(2616775,'1','187','939',418,'Retail Sale Id 1183401',7040.00,0.00,0.00,11.00,748.00,'2022-03-31 18:38:19','',''),(2616776,'1','187','939',418,'Retail Sale Id 1183402',6400.00,0.00,0.00,10.00,680.00,'2022-03-31 18:38:40','',''),(2616777,'1','187','939',418,'Retail Sale Id 1183403',6080.00,0.00,0.00,9.50,646.00,'2022-03-31 18:39:10','',''),(2616778,'1','187','939',418,'Retail Sale Id 1183404',5120.00,0.00,0.00,8.00,544.00,'2022-03-31 18:39:30','',''),(2616779,'1','187','939',418,'Retail Sale Id 1183405',8000.00,0.00,0.00,12.50,850.00,'2022-03-31 18:40:01','',''),(2616780,'1','187','939',418,'Retail Sale Id 1183406',9881.60,0.00,0.00,15.44,1049.92,'2022-03-31 18:41:32','',''),(2616781,'1','187','939',418,'Retail Sale Id 1183407',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 08:37:43','',''),(2616782,'1','187','939',418,'Retail Sale Id 1183408',30500.00,0.00,0.00,50.00,1900.00,'2022-04-01 08:39:15','',''),(2616783,'1','187','939',418,'Retail Sale Id 1183409',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 08:50:50','',''),(2616784,'1','187','939',418,'Retail Sale Id 1183410',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 08:55:43','',''),(2616785,'1','187','939',418,'Retail Sale Id 1183411',30500.00,0.00,0.00,50.00,1900.00,'2022-04-01 08:56:45','',''),(2616786,'1','187','939',418,'Retail Sale Id 1183412',91500.00,0.00,0.00,150.00,5700.00,'2022-04-01 08:58:32','',''),(2616787,'1','187','939',418,'Retail Sale Id 1183413',3840.00,0.00,0.00,6.00,408.00,'2022-04-01 09:06:40','',''),(2616788,'1','187','939',418,'Retail Sale Id 1183414',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 09:07:39','',''),(2616789,'1','187','939',418,'Retail Sale Id 1183415',6400.00,0.00,0.00,10.00,680.00,'2022-04-01 09:08:21','',''),(2616790,'1','187','939',418,'Retail Sale Id 1183416',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 09:08:45','',''),(2616791,'1','187','939',418,'Retail Sale Id 1183417',7040.00,0.00,0.00,11.00,748.00,'2022-04-01 09:09:15','',''),(2616792,'1','187','939',418,'Retail Sale Id 1183418',73200.00,0.00,0.00,120.00,4560.00,'2022-04-01 09:26:05','',''),(2616793,'1','187','939',418,'Retail Sale Id 1183419',122000.00,0.00,0.00,200.00,7600.00,'2022-04-01 09:38:24','',''),(2616794,'1','187','939',418,'Retail Sale Id 1183420',79300.00,0.00,0.00,130.00,4940.00,'2022-04-01 09:56:49','',''),(2616795,'1','187','939',418,'Retail Sale Id 1183421',6710.00,0.00,0.00,11.00,418.00,'2022-04-01 09:58:54','',''),(2616796,'1','187','939',418,'Retail Sale Id 1183422',3500.80,0.00,0.00,5.47,371.96,'2022-04-01 10:00:14','',''),(2616797,'1','187','939',418,'Retail Sale Id 1183423',122000.00,0.00,0.00,200.00,7600.00,'2022-04-01 10:07:32','',''),(2616798,'1','187','939',418,'Retail Sale Id 1183424',24400.00,0.00,0.00,40.00,1520.00,'2022-04-01 10:10:03','',''),(2616799,'1','187','939',418,'Retail Sale Id 1183425',152500.00,0.00,0.00,250.00,9500.00,'2022-04-01 10:15:05','',''),(2616800,'1','187','939',418,'Retail Sale Id 1183426',122000.00,0.00,0.00,200.00,7600.00,'2022-04-01 10:18:54','',''),(2616801,'1','187','939',418,'Retail Sale Id 1183427',4499.20,0.00,0.00,7.03,478.04,'2022-04-01 10:36:18','',''),(2616802,'1','187','939',418,'Retail Sale Id 1183428',91500.00,0.00,0.00,150.00,5700.00,'2022-04-01 10:39:16','',''),(2616803,'1','187','939',418,'Retail Sale Id 1183429',4499.20,0.00,0.00,7.03,478.04,'2022-04-01 10:45:07','',''),(2616804,'1','187','939',418,'Retail Sale Id 1183430',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 10:47:21','',''),(2616805,'1','187','939',418,'Retail Sale Id 1183431',3840.00,0.00,0.00,6.00,408.00,'2022-04-01 11:02:55','',''),(2616806,'1','187','939',418,'Retail Sale Id 1183432',24400.00,0.00,0.00,40.00,1520.00,'2022-04-01 11:04:47','',''),(2616807,'1','187','939',418,'Retail Sale Id 1183433',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 11:06:47','',''),(2616808,'1','187','939',418,'Retail Sale Id 1183434',30500.00,0.00,0.00,50.00,1900.00,'2022-04-01 11:11:59','',''),(2616809,'1','187','939',418,'Retail Sale Id 1183435',4499.20,0.00,0.00,7.03,478.04,'2022-04-01 11:22:41','',''),(2616810,'1','187','939',418,'Retail Sale Id 1183436',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 11:23:17','',''),(2616811,'1','187','939',418,'Retail Sale Id 1183437',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 11:24:57','',''),(2616812,'1','187','939',418,'Retail Sale Id 1183438',3200.00,0.00,0.00,5.00,340.00,'2022-04-01 11:27:19','',''),(2616813,'1','187','939',418,'Retail Sale Id 1183439',2003.20,0.00,0.00,3.13,212.84,'2022-04-01 11:28:16','',''),(2616814,'1','187','939',418,'Retail Sale Id 1183440',3500.80,0.00,0.00,5.47,371.96,'2022-04-01 11:28:39','',''),(2616815,'1','187','939',418,'Retail Sale Id 1183441',4000.00,0.00,0.00,6.25,425.00,'2022-04-01 11:30:00','',''),(2616816,'1','187','939',418,'Retail Sale Id 1183442',3801.60,0.00,0.00,5.94,403.92,'2022-04-01 11:30:21','',''),(2616817,'1','187','939',418,'Retail Sale Id 1183443',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 11:31:15','',''),(2616818,'1','187','939',418,'Retail Sale Id 1183444',6400.00,0.00,0.00,10.00,680.00,'2022-04-01 11:31:37','',''),(2616819,'1','187','939',418,'Retail Sale Id 1183445',3840.00,0.00,0.00,6.00,408.00,'2022-04-01 11:33:07','',''),(2616820,'1','187','939',418,'Retail Sale Id 1183446',3801.60,0.00,0.00,5.94,403.92,'2022-04-01 11:33:28','',''),(2616821,'1','187','939',418,'Retail Sale Id 1183447',3603.20,0.00,0.00,5.63,382.84,'2022-04-01 11:33:47','',''),(2616822,'1','187','939',418,'Retail Sale Id 1183448',13120.00,0.00,0.00,20.50,1394.00,'2022-04-01 11:34:12','',''),(2616823,'1','187','939',418,'Retail Sale Id 1183449',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 11:34:32','',''),(2616824,'1','187','939',418,'Retail Sale Id 1183450',7360.00,0.00,0.00,11.50,782.00,'2022-04-01 11:34:56','',''),(2616825,'1','187','939',418,'Retail Sale Id 1183451',6080.00,0.00,0.00,9.50,646.00,'2022-04-01 11:35:30','',''),(2616826,'1','187','939',418,'Retail Sale Id 1183452',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 11:36:17','',''),(2616827,'1','187','939',418,'Retail Sale Id 1183453',79300.00,0.00,0.00,130.00,4940.00,'2022-04-01 11:37:51','',''),(2616828,'1','187','939',418,'Retail Sale Id 1183454',70760.00,0.00,0.00,116.00,4408.00,'2022-04-01 11:47:58','',''),(2616829,'1','187','939',418,'Retail Sale Id 1183455',24400.00,0.00,0.00,40.00,1520.00,'2022-04-01 12:20:28','',''),(2616830,'1','187','939',418,'Retail Sale Id 1183456',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 12:27:50','',''),(2616831,'1','187','939',418,'Retail Sale Id 1183457',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 12:28:59','',''),(2616832,'1','187','939',418,'Retail Sale Id 1183458',54948.80,0.00,0.00,90.08,3423.04,'2022-04-01 12:58:43','',''),(2616833,'1','187','939',418,'Retail Sale Id 1183459',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 13:05:01','',''),(2616834,'1','187','939',418,'Retail Sale Id 1183460',3603.20,0.00,0.00,5.63,382.84,'2022-04-01 13:06:44','',''),(2616835,'1','187','939',418,'Retail Sale Id 1183461',4198.40,0.00,0.00,6.56,446.08,'2022-04-01 13:07:06','',''),(2616836,'1','187','939',418,'Retail Sale Id 1183462',6400.00,0.00,0.00,10.00,680.00,'2022-04-01 13:07:31','',''),(2616837,'1','187','939',418,'Retail Sale Id 1183463',61000.00,0.00,0.00,100.00,3800.00,'2022-04-01 13:20:27','',''),(2616838,'1','187','939',418,'Retail Sale Id 1183464',30500.00,0.00,0.00,50.00,1900.00,'2022-04-01 13:25:06','',''),(2616839,'1','187','939',418,'Retail Sale Id 1183465',8000.00,0.00,0.00,12.50,850.00,'2022-04-01 13:32:39','',''),(2616840,'1','187','939',418,'Retail Sale Id 1183466',6400.00,0.00,0.00,10.00,680.00,'2022-04-01 13:48:54','',''),(2616841,'1','187','939',418,'Retail Sale Id 1183467',6803.20,0.00,0.00,10.63,722.84,'2022-04-01 13:49:17','',''),(2616842,'1','187','939',418,'Retail Sale Id 1183468',2440.00,0.00,0.00,4.00,152.00,'2022-04-01 13:50:09','',''),(2616843,'1','187','939',418,'Return of Retail Sale Id 1183463',0.00,61000.00,100.00,0.00,-3800.00,'2022-04-01 13:52:52','',''),(2616844,'1','187','939',418,'Return of Retail Sale Id 1183464',0.00,30500.00,50.00,0.00,-1900.00,'2022-04-01 14:00:38','',''),(2616845,'1','187','939',418,'Retail Sale Id 1183470',11535.10,0.00,0.00,18.91,718.58,'2022-04-01 14:06:23','',''),(2616846,'1','187','939',418,'Retail Sale Id 1183471',30878.20,0.00,0.00,50.62,1923.56,'2022-04-01 14:09:21','',''),(2616847,'1','187','939',418,'Retail Sale Id 1183472',3500.80,0.00,0.00,5.47,371.96,'2022-04-01 14:10:14','',''),(2616848,'1','187','939',418,'Retail Sale Id 1183473',2003.20,0.00,0.00,3.13,212.84,'2022-04-01 14:10:37','',''),(2616849,'1','187','939',418,'Retail Sale Id 1183474',7360.00,0.00,0.00,11.50,782.00,'2022-04-01 14:11:09','',''),(2616850,'1','187','939',418,'Retail Sale Id 1183475',34843.20,0.00,0.00,57.12,2170.56,'2022-04-01 14:50:00','',''),(2616851,'1','187','939',418,'Return of Retail Sale Id 1183471',0.00,30878.20,50.62,0.00,-1923.56,'2022-04-01 14:54:34','',''),(2616852,'1','187','939',418,'Retail Sale Id 1183476',14408.20,0.00,0.00,23.62,897.56,'2022-04-01 14:57:55','',''),(2616853,'1','187','939',418,'Retail Sale Id 1183477',2707.20,0.00,0.00,4.23,287.64,'2022-04-01 15:00:48','',''),(2616854,'1','187','939',418,'Retail Sale Id 1183478',8735.20,0.00,0.00,14.32,544.16,'2022-04-01 18:37:17','',''),(2616855,'1','187','939',418,'Retail Sale Id 1183479',5971.90,0.00,0.00,9.79,372.02,'2022-04-01 18:39:05','',''),(2616856,'1','187','939',418,'Retail Sale Id 1183480',1350.40,0.00,0.00,2.11,143.48,'2022-04-01 18:40:02','',''),(2616857,'1','187','939',418,'Retail Sale Id 1183481',610.00,0.00,0.00,1.00,38.00,'2022-04-01 18:43:32','',''),(2616858,'1','187','939',418,'Distributed to OPERATIONAL LOSS for sales id:332546',346180.12,0.00,0.00,605.21,0.00,'2022-04-01 21:45:16','',''),(2616859,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,14288560.00,24980.00,0.00,0.00,'2022-04-03 10:45:48','',''),(2616860,'1','187',NULL,418,'Reception corrector for bridging 123748',0.00,0.00,0.00,24980.00,0.00,'2022-04-03 10:47:52','',''),(2616861,'1','187','939',418,'Received from bridging 123748',0.00,0.00,24980.00,0.00,0.00,'2022-04-03 10:47:52','',''),(2616862,'1','187','939',418,'Retail Sale Id 1183482',29500.00,0.00,0.00,50.00,900.00,'2022-04-03 12:23:54','',''),(2616863,'1','187','939',418,'Retail Sale Id 1183483',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 12:24:39','',''),(2616864,'1','187','939',418,'Retail Sale Id 1183484',88500.00,0.00,0.00,150.00,2700.00,'2022-04-03 12:26:03','',''),(2616865,'1','187','939',418,'Retail Sale Id 1183485',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 12:28:51','',''),(2616866,'1','187','939',418,'Retail Sale Id 1183486',147500.00,0.00,0.00,250.00,4500.00,'2022-04-03 12:29:58','',''),(2616867,'1','187','939',418,'Retail Sale Id 1183487',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 12:30:31','',''),(2616868,'1','187','939',418,'Retail Sale Id 1183488',70800.00,0.00,0.00,120.00,2160.00,'2022-04-03 13:10:10','',''),(2616869,'1','187','939',418,'Retail Sale Id 1183489',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 13:10:36','',''),(2616870,'1','187','939',418,'Retail Sale Id 1183490',11840.00,0.00,0.00,18.50,1258.00,'2022-04-03 13:10:59','',''),(2616871,'1','187','939',418,'Retail Sale Id 1183491',4800.00,0.00,0.00,7.50,510.00,'2022-04-03 13:11:23','',''),(2616872,'1','187','939',418,'Retail Sale Id 1183492',10240.00,0.00,0.00,16.00,1088.00,'2022-04-03 13:11:48','',''),(2616873,'1','187','939',418,'Retail Sale Id 1183493',10880.00,0.00,0.00,17.00,1156.00,'2022-04-03 13:13:52','',''),(2616874,'1','187','939',418,'Retail Sale Id 1183494',5120.00,0.00,0.00,8.00,544.00,'2022-04-03 13:14:14','',''),(2616875,'1','187','939',418,'Retail Sale Id 1183495',147500.00,0.00,0.00,250.00,4500.00,'2022-04-03 13:15:47','',''),(2616876,'1','187','939',418,'Retail Sale Id 1183496',88500.00,0.00,0.00,150.00,2700.00,'2022-04-03 13:16:19','',''),(2616877,'1','187','939',418,'Retail Sale Id 1183497',91500.00,0.00,0.00,150.00,5700.00,'2022-04-03 13:17:14','',''),(2616878,'1','187','939',418,'Retail Sale Id 1183498',118000.00,0.00,0.00,200.00,3600.00,'2022-04-03 13:17:45','',''),(2616879,'1','187','939',418,'Retail Sale Id 1183499',177000.00,0.00,0.00,300.00,5400.00,'2022-04-03 13:18:19','',''),(2616880,'1','187','939',418,'Retail Sale Id 1183500',88500.00,0.00,0.00,150.00,2700.00,'2022-04-03 13:19:04','',''),(2616881,'1','187','939',418,'Retail Sale Id 1183501',6400.00,0.00,0.00,10.00,680.00,'2022-04-03 13:23:11','',''),(2616882,'1','187','939',418,'Retail Sale Id 1183502',236000.00,0.00,0.00,590.00,-101480.00,'2022-04-03 13:23:43','',''),(2616883,'1','187','939',418,'Retail Sale Id 1183503',5120.00,0.00,0.00,8.00,544.00,'2022-04-03 13:24:51','',''),(2616884,'1','187','939',418,'Retail Sale Id 1183504',7040.00,0.00,0.00,11.00,748.00,'2022-04-03 13:25:14','',''),(2616885,'1','187','939',418,'Retail Sale Id 1183505',3840.00,0.00,0.00,6.00,408.00,'2022-04-03 13:25:38','',''),(2616886,'1','187','939',418,'Retail Sale Id 1183506',4499.20,0.00,0.00,7.03,478.04,'2022-04-03 13:26:23','',''),(2616887,'1','187','939',418,'Retail Sale Id 1183507',8499.20,0.00,0.00,13.28,903.04,'2022-04-03 13:26:54','',''),(2616888,'1','187','939',418,'Retail Sale Id 1183508',90270.00,0.00,0.00,153.00,2754.00,'2022-04-03 13:28:19','',''),(2616889,'1','187','939',418,'Retail Sale Id 1183509',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 13:30:59','',''),(2616890,'1','187','939',418,'Retail Sale Id 1183510',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 13:31:55','',''),(2616891,'1','187','939',418,'Retail Sale Id 1183511',3500.80,0.00,0.00,5.47,371.96,'2022-04-03 13:33:35','',''),(2616892,'1','187','939',418,'Retail Sale Id 1183512',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 13:34:35','',''),(2616893,'1','187','939',418,'Retail Sale Id 1183513',4000.00,0.00,0.00,6.25,425.00,'2022-04-03 13:37:02','',''),(2616894,'1','187','939',418,'Retail Sale Id 1183514',2003.20,0.00,0.00,3.13,212.84,'2022-04-03 13:37:27','',''),(2616895,'1','187','939',418,'Retail Sale Id 1183515',4499.20,0.00,0.00,7.03,478.04,'2022-04-03 13:43:26','',''),(2616896,'1','187','939',418,'Retail Sale Id 1183516',3699.20,0.00,0.00,5.78,393.04,'2022-04-03 13:44:46','',''),(2616897,'1','187','939',418,'Retail Sale Id 1183517',4102.40,0.00,0.00,6.41,435.88,'2022-04-03 13:53:15','',''),(2616898,'1','187','939',418,'Retail Sale Id 1183518',0.00,0.00,0.00,0.00,0.00,'2022-04-03 14:13:30','',''),(2616899,'1','187','939',418,'Retail Sale Id 1183519',5760.00,0.00,0.00,9.00,612.00,'2022-04-03 14:25:11','',''),(2616900,'1','187','939',418,'Retail Sale Id 1183520',2502.40,0.00,0.00,3.91,265.88,'2022-04-03 14:27:13','',''),(2616901,'1','187','939',418,'Retail Sale Id 1183521',3001.60,0.00,0.00,4.69,318.92,'2022-04-03 14:27:39','',''),(2616902,'1','187','939',418,'Retail Sale Id 1183522',2003.20,0.00,0.00,3.13,212.84,'2022-04-03 14:28:05','',''),(2616903,'1','187','939',418,'Retail Sale Id 1183523',4697.60,0.00,0.00,7.34,499.12,'2022-04-03 14:28:41','',''),(2616904,'1','187','939',418,'Retail Sale Id 1183524',4102.40,0.00,0.00,6.41,435.88,'2022-04-03 14:33:10','',''),(2616905,'1','187','939',418,'Retail Sale Id 1183525',8320.00,0.00,0.00,13.00,884.00,'2022-04-03 14:35:30','',''),(2616906,'1','187','939',418,'Retail Sale Id 1183526',15360.00,0.00,0.00,24.00,1632.00,'2022-04-03 15:00:08','',''),(2616907,'1','187','939',418,'Retail Sale Id 1183527',118000.00,0.00,0.00,200.00,3600.00,'2022-04-03 15:07:11','',''),(2616908,'1','187','939',418,'Retail Sale Id 1183528',354000.00,0.00,0.00,600.00,10800.00,'2022-04-03 15:08:41','',''),(2616909,'1','187','939',418,'Retail Sale Id 1183529',206500.00,0.00,0.00,350.00,6300.00,'2022-04-03 15:09:30','',''),(2616910,'1','187','939',418,'Retail Sale Id 1183530',76658.70,0.00,0.00,129.93,2338.74,'2022-04-03 15:14:20','',''),(2616911,'1','187','939',418,'Retail Sale Id 1183531',118000.00,0.00,0.00,200.00,3600.00,'2022-04-03 15:15:13','',''),(2616912,'1','187','939',418,'Retail Sale Id 1183532',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 15:16:39','',''),(2616913,'1','187','939',418,'Retail Sale Id 1183533',37647.90,0.00,0.00,63.81,1148.58,'2022-04-03 15:18:27','',''),(2616914,'1','187','939',418,'Retail Sale Id 1183534',12785.30,0.00,0.00,21.67,390.06,'2022-04-03 15:19:48','',''),(2616915,'1','187','939',418,'Retail Sale Id 1183535',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 15:20:26','',''),(2616916,'1','187','939',418,'Retail Sale Id 1183536',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 15:20:48','',''),(2616917,'1','187','939',418,'Retail Sale Id 1183537',5203.20,0.00,0.00,8.13,552.84,'2022-04-03 15:21:39','',''),(2616918,'1','187','939',418,'Retail Sale Id 1183538',6400.00,0.00,0.00,10.00,680.00,'2022-04-03 15:22:15','',''),(2616919,'1','187','939',418,'Retail Sale Id 1183539',11840.00,0.00,0.00,18.50,1258.00,'2022-04-03 15:23:01','',''),(2616920,'1','187','939',418,'Retail Sale Id 1183540',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 15:26:04','',''),(2616921,'1','187','939',418,'Retail Sale Id 1183541',3001.60,0.00,0.00,4.69,318.92,'2022-04-03 15:26:53','',''),(2616922,'1','187','939',418,'Retail Sale Id 1183542',4000.00,0.00,0.00,6.25,425.00,'2022-04-03 15:27:17','',''),(2616923,'1','187','939',418,'Retail Sale Id 1183543',6502.40,0.00,0.00,10.16,690.88,'2022-04-03 15:27:57','',''),(2616924,'1','187','939',418,'Retail Sale Id 1183544',4998.40,0.00,0.00,7.81,531.08,'2022-04-03 15:28:36','',''),(2616925,'1','187','939',418,'Retail Sale Id 1183545',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 15:29:19','',''),(2616926,'1','187','939',418,'Retail Sale Id 1183546',5120.00,0.00,0.00,8.00,544.00,'2022-04-03 15:29:53','',''),(2616927,'1','187','939',418,'Retail Sale Id 1183547',7040.00,0.00,0.00,11.00,748.00,'2022-04-03 15:30:31','',''),(2616928,'1','187','939',418,'Retail Sale Id 1183548',3840.00,0.00,0.00,6.00,408.00,'2022-04-03 15:32:30','',''),(2616929,'1','187','939',418,'Retail Sale Id 1183549',3897.60,0.00,0.00,6.09,414.12,'2022-04-03 15:32:53','',''),(2616930,'1','187','939',418,'Retail Sale Id 1183550',5440.00,0.00,0.00,8.50,578.00,'2022-04-03 15:33:22','',''),(2616931,'1','187','939',418,'Retail Sale Id 1183551',8000.00,0.00,0.00,12.50,850.00,'2022-04-03 15:35:56','',''),(2616932,'1','187','939',418,'Retail Sale Id 1183552',6400.00,0.00,0.00,10.00,680.00,'2022-04-03 15:39:50','',''),(2616933,'1','187','939',418,'Retail Sale Id 1183553',354000.00,0.00,0.00,600.00,10800.00,'2022-04-03 15:41:56','',''),(2616934,'1','187','939',418,'Retail Sale Id 1183554',59000.00,0.00,0.00,100.00,1800.00,'2022-04-03 15:42:55','',''),(2616935,'1','187','939',418,'Retail Sale Id 1183555',2560.00,0.00,0.00,4.00,272.00,'2022-04-03 15:44:05','',''),(2616936,'1','187','939',418,'Retail Sale Id 1183556',4998.40,0.00,0.00,7.81,531.08,'2022-04-03 15:44:38','',''),(2616937,'1','187','939',418,'Retail Sale Id 1183557',6201.60,0.00,0.00,9.69,658.92,'2022-04-03 15:45:16','',''),(2616938,'1','187','939',418,'Retail Sale Id 1183558',6400.00,0.00,0.00,10.00,680.00,'2022-04-03 15:45:44','',''),(2616939,'1','187','939',418,'Retail Sale Id 1183559',303319.00,0.00,0.00,514.10,9253.80,'2022-04-03 18:04:05','',''),(2616940,'1','187','939',418,'Retail Sale Id 1183560',264225.60,0.00,0.00,447.84,8061.12,'2022-04-03 18:05:14','',''),(2616941,'1','187','939',418,'Retail Sale Id 1183561',184375.00,0.00,0.00,312.50,5625.00,'2022-04-03 18:08:49','',''),(2616942,'1','187','939',418,'Retail Sale Id 1183562',177000.00,0.00,0.00,300.00,5400.00,'2022-04-03 18:09:36','',''),(2616943,'1','187','939',418,'Retail Sale Id 1183563',236000.00,0.00,0.00,400.00,7200.00,'2022-04-03 18:11:18','',''),(2616944,'1','187','939',418,'Retail Sale Id 1183564',181720.00,0.00,0.00,308.00,5544.00,'2022-04-03 18:13:13','',''),(2616945,'1','187','939',418,'Retail Sale Id 1183565',1401.60,0.00,0.00,2.19,148.92,'2022-04-03 18:14:07','',''),(2616946,'1','187','939',418,'Return of Retail Sale Id 1183502',0.00,236000.00,590.00,0.00,101480.00,'2022-04-03 18:41:41','',''),(2616947,'1','187','939',418,'Retail Sale Id 1183566',236000.00,0.00,0.00,400.00,7200.00,'2022-04-03 18:43:42','',''),(2616948,'1','187','939',418,'Return of Retail Sale Id 1183497',0.00,91500.00,150.00,0.00,-5700.00,'2022-04-03 18:45:20','',''),(2616949,'1','187','939',418,'Retail Sale Id 1183567',88500.00,0.00,0.00,150.00,2700.00,'2022-04-03 18:46:31','',''),(2616950,'1','187','939',418,'Retail Sale Id 1183568',112100.00,0.00,0.00,190.00,3420.00,'2022-04-03 18:57:36','',''),(2616951,'1','187','939',418,'Retail Sale Id 1183569',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 09:01:53','',''),(2616952,'1','187','939',418,'Retail Sale Id 1183570',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 09:20:25','',''),(2616953,'1','187','939',418,'Retail Sale Id 1183571',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 09:22:30','',''),(2616954,'1','187','939',418,'Retail Sale Id 1183572',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 09:26:27','',''),(2616955,'1','187','939',418,'Retail Sale Id 1183573',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 09:27:14','',''),(2616956,'1','187','939',418,'Retail Sale Id 1183574',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 10:01:07','',''),(2616957,'1','187','939',418,'Retail Sale Id 1183575',0.00,0.00,0.00,0.00,0.00,'2022-04-04 10:02:02','',''),(2616958,'1','187','939',418,'Retail Sale Id 1183576',7680.00,0.00,0.00,12.00,816.00,'2022-04-04 11:11:07','',''),(2616959,'1','187','939',418,'Retail Sale Id 1183577',3840.00,0.00,0.00,6.00,408.00,'2022-04-04 11:11:35','',''),(2616960,'1','187','939',418,'Retail Sale Id 1183578',3897.60,0.00,0.00,6.09,414.12,'2022-04-04 11:12:09','',''),(2616961,'1','187','939',418,'Retail Sale Id 1183579',6400.00,0.00,0.00,10.00,680.00,'2022-04-04 11:12:58','',''),(2616962,'1','187','939',418,'Retail Sale Id 1183580',7040.00,0.00,0.00,11.00,748.00,'2022-04-04 11:13:33','',''),(2616963,'1','187','939',418,'Retail Sale Id 1183581',3200.00,0.00,0.00,5.00,340.00,'2022-04-04 11:14:38','',''),(2616964,'1','187','939',418,'Retail Sale Id 1183582',5440.00,0.00,0.00,8.50,578.00,'2022-04-04 11:15:07','',''),(2616965,'1','187','939',418,'Retail Sale Id 1183583',3200.00,0.00,0.00,5.00,340.00,'2022-04-04 11:15:35','',''),(2616966,'1','187','939',418,'Retail Sale Id 1183584',3398.40,0.00,0.00,5.31,361.08,'2022-04-04 11:16:11','',''),(2616967,'1','187','939',418,'Retail Sale Id 1183585',4998.40,0.00,0.00,7.81,531.08,'2022-04-04 11:16:45','',''),(2616968,'1','187','939',418,'Retail Sale Id 1183586',7001.60,0.00,0.00,10.94,743.92,'2022-04-04 11:17:38','',''),(2616969,'1','187','939',418,'Retail Sale Id 1183587',6003.20,0.00,0.00,9.38,637.84,'2022-04-04 11:18:05','',''),(2616970,'1','187','939',418,'Retail Sale Id 1183588',4499.20,0.00,0.00,7.03,478.04,'2022-04-04 11:18:46','',''),(2616971,'1','187','939',418,'Retail Sale Id 1183589',6297.60,0.00,0.00,9.84,669.12,'2022-04-04 11:19:20','',''),(2616972,'1','187','939',418,'Retail Sale Id 1183590',4800.00,0.00,0.00,7.50,510.00,'2022-04-04 11:19:51','',''),(2616973,'1','187','939',418,'Retail Sale Id 1183591',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 11:20:19','',''),(2616974,'1','187','939',418,'Retail Sale Id 1183592',15360.00,0.00,0.00,24.00,1632.00,'2022-04-04 11:20:40','',''),(2616975,'1','187','939',418,'Retail Sale Id 1183593',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 11:21:39','',''),(2616976,'1','187','939',418,'Retail Sale Id 1183594',88500.00,0.00,0.00,150.00,2700.00,'2022-04-04 11:23:14','',''),(2616977,'1','187','939',418,'Retail Sale Id 1183595',118000.00,0.00,0.00,200.00,3600.00,'2022-04-04 11:38:31','',''),(2616978,'1','187','939',418,'Retail Sale Id 1183596',59000.00,0.00,0.00,100.00,1800.00,'2022-04-04 11:39:36','',''),(2616979,'1','187','939',418,'Retail Sale Id 1183597',35400.00,0.00,0.00,60.00,1080.00,'2022-04-04 11:40:08','',''),(2616980,'1','187','939',418,'Retail Sale Id 1183598',29500.00,0.00,0.00,50.00,900.00,'2022-04-04 11:40:43','',''),(2616981,'1','187','939',418,'Retail Sale Id 1183599',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 11:41:28','',''),(2616982,'1','187','939',418,'Retail Sale Id 1183600',59000.00,0.00,0.00,100.00,1800.00,'2022-04-04 11:53:04','',''),(2616983,'1','187','939',418,'Retail Sale Id 1183601',59000.00,0.00,0.00,100.00,1800.00,'2022-04-04 11:53:40','',''),(2616984,'1','187','939',418,'Retail Sale Id 1183602',236000.00,0.00,0.00,400.00,7200.00,'2022-04-04 15:16:38','',''),(2616985,'1','187','939',418,'Retail Sale Id 1183603',177000.00,0.00,0.00,300.00,5400.00,'2022-04-04 15:17:21','',''),(2616986,'1','187','939',418,'Retail Sale Id 1183604',29948.40,0.00,0.00,50.76,913.68,'2022-04-04 15:18:03','',''),(2616987,'1','187','939',418,'Retail Sale Id 1183605',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 15:19:32','',''),(2616988,'1','187','939',418,'Retail Sale Id 1183606',106200.00,0.00,0.00,180.00,3240.00,'2022-04-04 15:20:13','',''),(2616989,'1','187','939',418,'Retail Sale Id 1183607',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 15:20:58','',''),(2616990,'1','187','939',418,'Retail Sale Id 1183608',88500.00,0.00,0.00,150.00,2700.00,'2022-04-04 15:22:09','',''),(2616991,'1','187','939',418,'Retail Sale Id 1183609',118000.00,0.00,0.00,200.00,3600.00,'2022-04-04 15:22:39','',''),(2616992,'1','187','939',418,'Retail Sale Id 1183610',88500.00,0.00,0.00,150.00,2700.00,'2022-04-04 15:23:19','',''),(2616993,'1','187','939',418,'Retail Sale Id 1183611',35400.00,0.00,0.00,60.00,1080.00,'2022-04-04 15:24:09','',''),(2616994,'1','187','939',418,'Retail Sale Id 1183612',118000.00,0.00,0.00,200.00,3600.00,'2022-04-04 15:25:21','',''),(2616995,'1','187','939',418,'Retail Sale Id 1183613',165200.00,0.00,0.00,280.00,5040.00,'2022-04-04 15:26:08','',''),(2616996,'1','187','939',418,'Retail Sale Id 1183614',188800.00,0.00,0.00,320.00,5760.00,'2022-04-04 15:26:47','',''),(2616997,'1','187','939',418,'Retail Sale Id 1183615',118000.00,0.00,0.00,200.00,3600.00,'2022-04-04 15:28:14','',''),(2616998,'1','187','939',418,'Retail Sale Id 1183616',147500.00,0.00,0.00,250.00,4500.00,'2022-04-04 15:29:27','',''),(2616999,'1','187','939',418,'Retail Sale Id 1183617',59000.00,0.00,0.00,100.00,1800.00,'2022-04-04 15:30:09','',''),(2617000,'1','187','939',418,'Retail Sale Id 1183618',338801.60,0.00,0.00,574.24,10336.32,'2022-04-04 17:36:48','',''),(2617001,'1','187','939',418,'Retail Sale Id 1183619',123227.40,0.00,0.00,208.86,3759.48,'2022-04-04 17:37:51','',''),(2617002,'1','187','939',418,'Retail Sale Id 1183620',100842.80,0.00,0.00,170.92,3076.56,'2022-04-04 17:39:21','',''),(2617003,'1','187','939',418,'Retail Sale Id 1183621',325084.10,0.00,0.00,550.99,9917.82,'2022-04-04 17:41:35','',''),(2617004,'1','187','939',418,'Retail Sale Id 1183622',3859.20,0.00,0.00,6.03,410.04,'2022-04-04 17:50:13','',''),(2617005,'1','187','939',418,'Retail Sale Id 1183623',3840.00,0.00,0.00,6.00,408.00,'2022-04-04 17:51:01','',''),(2617006,'1','187','939',418,'Retail Sale Id 1183624',4000.00,0.00,0.00,6.25,425.00,'2022-04-04 17:51:25','',''),(2617007,'1','187','939',418,'Retail Sale Id 1183625',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 17:51:48','',''),(2617008,'1','187','939',418,'Retail Sale Id 1183626',11840.00,0.00,0.00,18.50,1258.00,'2022-04-04 17:56:10','',''),(2617009,'1','187','939',418,'Retail Sale Id 1183627',59000.00,0.00,0.00,100.00,1800.00,'2022-04-04 18:16:14','',''),(2617010,'1','187','939',418,'Retail Sale Id 1183628',59000.00,0.00,0.00,100.00,1800.00,'2022-04-04 18:17:40','',''),(2617011,'1','187','939',418,'Retail Sale Id 1183629',86641.50,0.00,0.00,146.85,2643.30,'2022-04-04 18:19:05','',''),(2617012,'1','187','939',418,'Retail Sale Id 1183630',177000.00,0.00,0.00,300.00,5400.00,'2022-04-04 18:20:07','',''),(2617013,'1','187','939',418,'Retail Sale Id 1183631',15360.00,0.00,0.00,24.00,1632.00,'2022-04-04 18:22:39','',''),(2617014,'1','187','939',418,'Retail Sale Id 1183632',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 18:23:42','',''),(2617015,'1','187','939',418,'Retail Sale Id 1183633',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 18:24:36','',''),(2617016,'1','187','939',418,'Retail Sale Id 1183634',8000.00,0.00,0.00,12.50,850.00,'2022-04-04 18:28:51','',''),(2617017,'1','187','939',418,'Retail Sale Id 1183635',10931.20,0.00,0.00,17.08,1161.44,'2022-04-04 18:30:20','',''),(2617018,'1','187','939',418,'Retail Sale Id 1183636',118000.00,0.00,0.00,200.00,3600.00,'2022-04-05 08:37:24','',''),(2617019,'1','187','939',418,'Retail Sale Id 1183637',147500.00,0.00,0.00,250.00,4500.00,'2022-04-05 08:38:19','',''),(2617020,'1','187','939',418,'Retail Sale Id 1183638',147500.00,0.00,0.00,250.00,4500.00,'2022-04-05 08:39:23','',''),(2617021,'1','187','939',418,'Retail Sale Id 1183639',118000.00,0.00,0.00,200.00,3600.00,'2022-04-05 08:40:03','',''),(2617022,'1','187','939',418,'Retail Sale Id 1183640',8000.00,0.00,0.00,12.50,850.00,'2022-04-05 11:00:02','',''),(2617023,'1','187','939',418,'Retail Sale Id 1183641',0.00,0.00,0.00,1.00,-572.00,'2022-04-05 11:02:06','',''),(2617024,'1','187','939',418,'Retail Sale Id 1183642',8000.00,0.00,0.00,12.50,850.00,'2022-04-05 11:03:38','',''),(2617025,'1','187','939',418,'Retail Sale Id 1183643',8000.00,0.00,0.00,12.50,850.00,'2022-04-05 11:04:59','',''),(2617026,'1','187','939',418,'Retail Sale Id 1183644',8000.00,0.00,0.00,12.50,850.00,'2022-04-05 11:05:33','',''),(2617027,'1','187','939',418,'Retail Sale Id 1183645',11840.00,0.00,0.00,18.50,1258.00,'2022-04-05 11:07:01','',''),(2617028,'1','187','939',418,'Retail Sale Id 1183646',177000.00,0.00,0.00,300.00,5400.00,'2022-04-05 11:07:39','',''),(2617029,'1','187','939',418,'Retail Sale Id 1183647',29500.00,0.00,0.00,50.00,900.00,'2022-04-05 11:08:19','',''),(2617030,'1','187','939',418,'Retail Sale Id 1183648',88500.00,0.00,0.00,150.00,2700.00,'2022-04-05 11:08:59','',''),(2617031,'1','187','939',418,'Retail Sale Id 1183649',70800.00,0.00,0.00,120.00,2160.00,'2022-04-05 11:10:06','',''),(2617032,'1','187','939',418,'Retail Sale Id 1183650',106200.00,0.00,0.00,180.00,3240.00,'2022-04-05 11:11:27','',''),(2617033,'1','187','939',418,'Retail Sale Id 1183651',88500.00,0.00,0.00,150.00,2700.00,'2022-04-05 11:12:04','',''),(2617034,'1','187','939',418,'Retail Sale Id 1183652',59000.00,0.00,0.00,100.00,1800.00,'2022-04-05 11:14:31','',''),(2617035,'1','187','939',418,'Retail Sale Id 1183653',118000.00,0.00,0.00,200.00,3600.00,'2022-04-05 11:16:30','',''),(2617036,'1','187','939',418,'Retail Sale Id 1183654',6400.00,0.00,0.00,10.00,680.00,'2022-04-05 11:17:52','',''),(2617037,'1','187','939',418,'Retail Sale Id 1183655',8000.00,0.00,0.00,12.50,850.00,'2022-04-05 11:18:29','',''),(2617038,'1','187','939',418,'Retail Sale Id 1183656',7680.00,0.00,0.00,12.00,816.00,'2022-04-05 11:19:17','',''),(2617039,'1','187','939',418,'Retail Sale Id 1183657',3500.80,0.00,0.00,5.47,371.96,'2022-04-05 11:20:29','',''),(2617040,'1','187','939',418,'Retail Sale Id 1183658',4000.00,0.00,0.00,6.25,425.00,'2022-04-05 11:26:10','',''),(2617041,'1','187','939',418,'Retail Sale Id 1183659',3801.60,0.00,0.00,5.94,403.92,'2022-04-05 11:26:39','',''),(2617042,'1','187','939',418,'Retail Sale Id 1183660',2003.20,0.00,0.00,3.13,212.84,'2022-04-05 11:29:47','',''),(2617043,'1','187','939',418,'Retail Sale Id 1183661',88500.00,0.00,0.00,150.00,2700.00,'2022-04-05 11:30:21','',''),(2617044,'1','187','939',418,'Retail Sale Id 1183662',4000.00,0.00,0.00,6.25,425.00,'2022-04-05 11:41:10','',''),(2617045,'1','187','939',418,'Retail Sale Id 1183663',3840.00,0.00,0.00,6.00,408.00,'2022-04-05 11:41:55','',''),(2617046,'1','187','939',418,'Retail Sale Id 1183664',9600.00,0.00,0.00,15.00,1020.00,'2022-04-05 11:42:45','',''),(2617047,'1','187','939',418,'Retail Sale Id 1183665',29500.00,0.00,0.00,50.00,900.00,'2022-04-05 13:32:14','',''),(2617048,'1','187','939',418,'Retail Sale Id 1183666',47200.00,0.00,0.00,80.00,1440.00,'2022-04-05 13:33:18','',''),(2617049,'1','187','939',418,'Retail Sale Id 1183667',59000.00,0.00,0.00,100.00,1800.00,'2022-04-05 13:34:31','',''),(2617050,'1','187','939',418,'Retail Sale Id 1183668',59000.00,0.00,0.00,100.00,1800.00,'2022-04-05 13:35:12','',''),(2617051,'1','187','939',418,'Retail Sale Id 1183669',2502.40,0.00,0.00,3.91,265.88,'2022-04-05 13:39:14','',''),(2617052,'1','187','939',418,'Retail Sale Id 1183670',3500.80,0.00,0.00,5.47,371.96,'2022-04-05 13:40:08','',''),(2617053,'1','187','939',418,'Retail Sale Id 1183671',998.40,0.00,0.00,1.56,106.08,'2022-04-05 13:40:33','',''),(2617054,'1','187','939',418,'Retail Sale Id 1183672',1920.00,0.00,0.00,3.00,204.00,'2022-04-05 13:43:31','',''),(2617055,'1','187','939',418,'Retail Sale Id 1183673',29500.00,0.00,0.00,50.00,900.00,'2022-04-05 13:45:03','',''),(2617056,'1','187','939',418,'Retail Sale Id 1183674',34220.00,0.00,0.00,58.00,1044.00,'2022-04-05 14:58:08','',''),(2617057,'1','187','939',418,'Retail Sale Id 1183675',118000.00,0.00,0.00,200.00,3600.00,'2022-04-05 14:58:55','',''),(2617058,'1','187','939',418,'Retail Sale Id 1183676',88500.00,0.00,0.00,150.00,2700.00,'2022-04-05 15:00:05','',''),(2617059,'1','187','939',418,'Retail Sale Id 1183677',29500.00,0.00,0.00,50.00,900.00,'2022-04-05 15:00:35','',''),(2617060,'1','187','939',418,'Retail Sale Id 1183678',59000.00,0.00,0.00,100.00,1800.00,'2022-04-05 15:01:36','',''),(2617061,'1','187','939',418,'Retail Sale Id 1183679',70800.00,0.00,0.00,120.00,2160.00,'2022-04-05 15:02:25','',''),(2617062,'1','187','939',418,'Retail Sale Id 1183680',2803.20,0.00,0.00,4.38,297.84,'2022-04-05 15:03:30','',''),(2617063,'1','187','939',418,'Retail Sale Id 1183681',3500.80,0.00,0.00,5.47,371.96,'2022-04-05 15:03:52','',''),(2617064,'1','187','939',418,'Retail Sale Id 1183682',2502.40,0.00,0.00,3.91,265.88,'2022-04-05 15:04:16','',''),(2617065,'1','187','939',418,'Retail Sale Id 1183683',8960.00,0.00,0.00,14.00,952.00,'2022-04-05 15:04:44','',''),(2617066,'1','187','939',418,'Retail Sale Id 1183684',2297.60,0.00,0.00,3.59,244.12,'2022-04-05 15:06:18','',''),(2617067,'1','187','939',418,'Retail Sale Id 1183685',2502.40,0.00,0.00,3.91,265.88,'2022-04-05 15:06:52','',''),(2617068,'1','187','939',418,'Retail Sale Id 1183686',2560.00,0.00,0.00,4.00,272.00,'2022-04-05 15:07:53','',''),(2617069,'1','187','939',418,'Retail Sale Id 1183687',2496.00,0.00,0.00,3.90,265.20,'2022-04-05 15:08:16','',''),(2617070,'1','187','939',418,'Retail Sale Id 1183688',8000.00,0.00,0.00,12.50,850.00,'2022-04-05 15:09:35','',''),(2617071,'1','187','939',418,'Retail Sale Id 1183689',1280.00,0.00,0.00,2.00,136.00,'2022-04-05 15:59:37','',''),(2617072,'1','187','939',418,'Retail Sale Id 1183690',1920.00,0.00,0.00,3.00,204.00,'2022-04-05 16:03:08','',''),(2617073,'1','187','939',418,'Retail Sale Id 1183691',2502.40,0.00,0.00,3.91,265.88,'2022-04-05 16:29:40','',''),(2617074,'1','187','939',418,'Retail Sale Id 1183692',1497.60,0.00,0.00,2.34,159.12,'2022-04-05 16:42:15','',''),(2617075,'1','187','939',418,'Retail Sale Id 1183693',1280.00,0.00,0.00,2.00,136.00,'2022-04-05 16:42:43','',''),(2617076,'1','187','939',418,'Retail Sale Id 1183694',2560.00,0.00,0.00,4.00,272.00,'2022-04-05 17:03:58','',''),(2617077,'1','187','939',418,'Retail Sale Id 1183695',3840.00,0.00,0.00,6.00,408.00,'2022-04-05 17:05:28','',''),(2617078,'1','187','939',418,'Retail Sale Id 1183697',3840.00,0.00,0.00,6.00,408.00,'2022-04-05 17:22:23','',''),(2617079,'1','187','939',418,'Retail Sale Id 1183701',3200.00,0.00,0.00,5.00,340.00,'2022-04-05 17:23:07','',''),(2617080,'1','187','939',418,'Retail Sale Id 1183702',2560.00,0.00,0.00,4.00,272.00,'2022-04-05 17:24:20','',''),(2617081,'1','187','939',418,'Retail Sale Id 1183703',124248.10,0.00,0.00,210.59,3790.62,'2022-04-05 17:41:27','',''),(2617082,'1','187','939',418,'Retail Sale Id 1183704',147500.00,0.00,0.00,250.00,4500.00,'2022-04-05 17:42:18','',''),(2617083,'1','187','939',418,'Retail Sale Id 1183705',88500.00,0.00,0.00,150.00,2700.00,'2022-04-05 17:43:05','',''),(2617084,'1','187','939',418,'Retail Sale Id 1183706',59000.00,0.00,0.00,100.00,1800.00,'2022-04-05 17:44:23','',''),(2617085,'1','187','939',418,'Retail Sale Id 1183707',70912.10,0.00,0.00,120.19,2163.42,'2022-04-05 17:45:41','',''),(2617086,'1','187','939',418,'Retail Sale Id 1183708',88500.00,0.00,0.00,150.00,2700.00,'2022-04-05 17:46:25','',''),(2617087,'1','187','939',418,'Retail Sale Id 1183709',50150.00,0.00,0.00,85.00,1530.00,'2022-04-05 17:47:00','',''),(2617088,'1','187','939',418,'Retail Sale Id 1183710',38350.00,0.00,0.00,65.00,1170.00,'2022-04-05 17:48:54','',''),(2617089,'1','187','939',418,'Retail Sale Id 1183711',236000.00,0.00,0.00,400.00,7200.00,'2022-04-05 17:51:18','',''),(2617090,'1','187','939',418,'Retail Sale Id 1183712',35931.00,0.00,0.00,60.90,1096.20,'2022-04-05 17:51:52','',''),(2617091,'1','187','939',418,'Retail Sale Id 1183713',29500.00,0.00,0.00,50.00,900.00,'2022-04-05 17:54:13','',''),(2617092,'1','187','939',418,'Retail Sale Id 1183714',1772.80,0.00,0.00,2.77,188.36,'2022-04-05 18:04:11','',''),(2617093,'1','187','939',418,'Retail Sale Id 1183715',49306.30,0.00,0.00,83.57,1504.26,'2022-04-05 18:25:41','',''),(2617094,'1','187','939',418,'Retail Sale Id 1183716',640.00,0.00,0.00,1.00,68.00,'2022-04-05 18:29:16','',''),(2617095,'1','187','939',418,'Retail Sale Id 1183717',6400.00,0.00,0.00,10.00,680.00,'2022-04-06 09:17:49','',''),(2617096,'1','187','939',418,'Retail Sale Id 1183718',88500.00,0.00,0.00,150.00,2700.00,'2022-04-06 09:18:32','',''),(2617097,'1','187','939',418,'Retail Sale Id 1183719',106200.00,0.00,0.00,180.00,3240.00,'2022-04-06 09:19:10','',''),(2617098,'1','187','939',418,'Retail Sale Id 1183720',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 09:19:52','',''),(2617099,'1','187','939',418,'Retail Sale Id 1183721',265500.00,0.00,0.00,450.00,8100.00,'2022-04-06 09:20:42','',''),(2617100,'1','187','939',418,'Retail Sale Id 1183722',2502.40,0.00,0.00,3.91,265.88,'2022-04-06 09:21:41','',''),(2617101,'1','187','939',418,'Retail Sale Id 1183723',6201.60,0.00,0.00,9.69,658.92,'2022-04-06 09:22:17','',''),(2617102,'1','187','939',418,'Retail Sale Id 1183724',8000.00,0.00,0.00,12.50,850.00,'2022-04-06 09:22:53','',''),(2617103,'1','187','939',418,'Retail Sale Id 1183725',3200.00,0.00,0.00,5.00,340.00,'2022-04-06 09:23:21','',''),(2617104,'1','187','939',418,'Retail Sale Id 1183726',3200.00,0.00,0.00,5.00,340.00,'2022-04-06 09:23:46','',''),(2617105,'1','187','939',418,'Retail Sale Id 1183727',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 09:24:35','',''),(2617106,'1','187','939',418,'Retail Sale Id 1183728',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 09:25:19','',''),(2617107,'1','187','939',418,'Retail Sale Id 1183729',3840.00,0.00,0.00,6.00,408.00,'2022-04-06 09:26:16','',''),(2617108,'1','187','939',418,'Retail Sale Id 1183730',5120.00,0.00,0.00,8.00,544.00,'2022-04-06 09:26:43','',''),(2617109,'1','187','939',418,'Retail Sale Id 1183731',2560.00,0.00,0.00,4.00,272.00,'2022-04-06 10:01:42','',''),(2617110,'1','187','939',418,'Retail Sale Id 1183732',3200.00,0.00,0.00,5.00,340.00,'2022-04-06 10:02:37','',''),(2617111,'1','187','939',418,'Retail Sale Id 1183733',3840.00,0.00,0.00,6.00,408.00,'2022-04-06 10:03:26','',''),(2617112,'1','187','939',418,'Retail Sale Id 1183734',3840.00,0.00,0.00,6.00,408.00,'2022-04-06 10:04:38','',''),(2617113,'1','187','939',418,'Retail Sale Id 1183735',3840.00,0.00,0.00,6.00,408.00,'2022-04-06 10:05:40','',''),(2617114,'1','187','939',418,'Retail Sale Id 1183736',1920.00,0.00,0.00,3.00,204.00,'2022-04-06 10:06:18','',''),(2617115,'1','187','939',418,'Retail Sale Id 1183737',3840.00,0.00,0.00,6.00,408.00,'2022-04-06 10:07:08','',''),(2617116,'1','187','939',418,'Retail Sale Id 1183738',3200.00,0.00,0.00,5.00,340.00,'2022-04-06 10:07:44','',''),(2617117,'1','187','939',418,'Retail Sale Id 1183739',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 12:53:45','',''),(2617118,'1','187','939',418,'Retail Sale Id 1183740',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 12:54:29','',''),(2617119,'1','187','939',418,'Retail Sale Id 1183741',35400.00,0.00,0.00,60.00,1080.00,'2022-04-06 12:55:01','',''),(2617120,'1','187','939',418,'Retail Sale Id 1183742',998.40,0.00,0.00,1.56,106.08,'2022-04-06 13:04:26','',''),(2617121,'1','187','939',418,'Retail Sale Id 1183743',1920.00,0.00,0.00,3.00,204.00,'2022-04-06 13:16:51','',''),(2617122,'1','187','939',418,'Retail Sale Id 1183744',2560.00,0.00,0.00,4.00,272.00,'2022-04-06 13:19:48','',''),(2617123,'1','187','939',418,'Retail Sale Id 1183745',88500.00,0.00,0.00,150.00,2700.00,'2022-04-06 14:33:56','',''),(2617124,'1','187','939',418,'Retail Sale Id 1183746',70800.00,0.00,0.00,120.00,2160.00,'2022-04-06 14:35:27','',''),(2617125,'1','187','939',418,'Retail Sale Id 1183747',103250.00,0.00,0.00,175.00,3150.00,'2022-04-06 14:36:09','',''),(2617126,'1','187','939',418,'Retail Sale Id 1183748',88500.00,0.00,0.00,150.00,2700.00,'2022-04-06 14:37:26','',''),(2617127,'1','187','939',418,'Retail Sale Id 1183749',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 14:38:42','',''),(2617128,'1','187','939',418,'Retail Sale Id 1183750',28001.40,0.00,0.00,47.46,854.28,'2022-04-06 14:39:22','',''),(2617129,'1','187','939',418,'Retail Sale Id 1183751',177000.00,0.00,0.00,300.00,5400.00,'2022-04-06 14:40:09','',''),(2617130,'1','187','939',418,'Retail Sale Id 1183752',76700.00,0.00,0.00,130.00,2340.00,'2022-04-06 14:42:05','',''),(2617131,'1','187','939',418,'Retail Sale Id 1183753',29500.00,0.00,0.00,50.00,900.00,'2022-04-06 14:51:20','',''),(2617132,'1','187','939',418,'Retail Sale Id 1183754',59000.00,0.00,0.00,100.00,1800.00,'2022-04-06 14:51:56','',''),(2617133,'1','187','939',418,'Return of Retail Sale Id 1183753',0.00,29500.00,50.00,0.00,-900.00,'2022-04-06 14:53:46','',''),(2617134,'1','187','939',418,'Retail Sale Id 1183755',17700.00,0.00,0.00,30.00,540.00,'2022-04-06 15:20:48','',''),(2617135,'1','187','939',418,'Retail Sale Id 1183756',8000.00,0.00,0.00,12.50,850.00,'2022-04-06 15:22:00','',''),(2617136,'1','187','939',418,'Return of Retail Sale Id 1183728',0.00,59000.00,100.00,0.00,-1800.00,'2022-04-06 16:07:37','',''),(2617137,'1','187','939',418,'Retail Sale Id 1183757',902.40,0.00,0.00,1.41,95.88,'2022-04-06 16:22:21','',''),(2617138,'1','187','939',418,'Retail Sale Id 1183758',47878.50,0.00,0.00,81.15,1460.70,'2022-04-06 16:27:56','',''),(2617139,'1','187','939',418,'Retail Sale Id 1183759',88500.00,0.00,0.00,150.00,2700.00,'2022-04-06 16:28:46','',''),(2617140,'1','187','939',418,'Retail Sale Id 1183760',5823.30,0.00,0.00,9.87,177.66,'2022-04-06 16:30:01','',''),(2617141,'1','187','939',418,'Retail Sale Id 1183761',30302.40,0.00,0.00,51.36,924.48,'2022-04-06 16:31:26','',''),(2617142,'1','187','939',418,'Retail Sale Id 1183762',10555.10,0.00,0.00,17.89,322.02,'2022-04-06 16:34:10','',''),(2617143,'1','187','939',418,'Distributed to OPERATIONAL LOSS for sales id:332547',267913.36,0.00,0.00,468.38,0.00,'2022-04-06 21:57:35','',''),(2617144,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,14288560.00,24980.00,0.00,0.00,'2022-04-06 22:02:13','',''),(2617145,'1','187',NULL,418,'Reception corrector for bridging 123749',0.00,0.00,0.00,24980.00,0.00,'2022-04-06 22:06:16','',''),(2617146,'1','187','939',418,'Received from bridging 123749',0.00,0.00,24980.00,0.00,0.00,'2022-04-06 22:06:16','',''),(2617147,'1','187','939',418,'Retail Sale Id 1183763',59413.00,0.00,0.00,100.70,1812.60,'2022-04-07 07:49:02','',''),(2617148,'1','187','939',418,'Retail Sale Id 1183764',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 07:55:44','',''),(2617149,'1','187','939',418,'Retail Sale Id 1183765',8000.00,0.00,0.00,12.50,850.00,'2022-04-07 07:56:34','',''),(2617150,'1','187','939',418,'Retail Sale Id 1183766',34220.00,0.00,0.00,58.00,1044.00,'2022-04-07 09:52:55','',''),(2617151,'1','187','939',418,'Retail Sale Id 1183767',59000.00,0.00,0.00,100.00,1800.00,'2022-04-07 09:56:45','',''),(2617152,'1','187','939',418,'Retail Sale Id 1183768',59000.00,0.00,0.00,100.00,1800.00,'2022-04-07 10:19:24','',''),(2617153,'1','187','939',418,'Retail Sale Id 1183769',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 10:20:00','',''),(2617154,'1','187','939',418,'Retail Sale Id 1183770',5760.00,0.00,0.00,9.00,612.00,'2022-04-07 10:20:26','',''),(2617155,'1','187','939',418,'Retail Sale Id 1183771',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 10:20:52','',''),(2617156,'1','187','939',418,'Retail Sale Id 1183772',8000.00,0.00,0.00,12.50,850.00,'2022-04-07 10:21:23','',''),(2617157,'1','187','939',418,'Retail Sale Id 1183773',2560.00,0.00,0.00,4.00,272.00,'2022-04-07 10:22:16','',''),(2617158,'1','187','939',418,'Retail Sale Id 1183774',6400.00,0.00,0.00,10.00,680.00,'2022-04-07 10:22:42','',''),(2617159,'1','187','939',418,'Retail Sale Id 1183775',5120.00,0.00,0.00,8.00,544.00,'2022-04-07 10:23:09','',''),(2617160,'1','187','939',418,'Retail Sale Id 1183776',3200.00,0.00,0.00,5.00,340.00,'2022-04-07 10:24:02','',''),(2617161,'1','187','939',418,'Retail Sale Id 1183777',59212.40,0.00,0.00,100.36,1806.48,'2022-04-07 12:12:52','',''),(2617162,'1','187','939',418,'Retail Sale Id 1183778',23659.00,0.00,0.00,40.10,721.80,'2022-04-07 12:27:51','',''),(2617163,'1','187','939',418,'Retail Sale Id 1183779',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 12:28:46','',''),(2617164,'1','187','939',418,'Retail Sale Id 1183780',88500.00,0.00,0.00,150.00,2700.00,'2022-04-07 12:29:51','',''),(2617165,'1','187','939',418,'Retail Sale Id 1183781',2502.40,0.00,0.00,3.91,265.88,'2022-04-07 12:30:22','',''),(2617166,'1','187','939',418,'Retail Sale Id 1183782',26550.00,0.00,0.00,45.00,810.00,'2022-04-07 12:36:08','',''),(2617167,'1','187','939',418,'Retail Sale Id 1183783',2560.00,0.00,0.00,4.00,272.00,'2022-04-07 12:38:25','',''),(2617168,'1','187','939',418,'Retail Sale Id 1183784',3200.00,0.00,0.00,5.00,340.00,'2022-04-07 12:39:43','',''),(2617169,'1','187','939',418,'Retail Sale Id 1183785',3200.00,0.00,0.00,5.00,340.00,'2022-04-07 12:40:40','',''),(2617170,'1','187','939',418,'Retail Sale Id 1183786',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 12:41:07','',''),(2617171,'1','187','939',418,'Retail Sale Id 1183787',8320.00,0.00,0.00,13.00,884.00,'2022-04-07 13:07:45','',''),(2617172,'1','187','939',418,'Retail Sale Id 1183788',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 13:11:18','',''),(2617173,'1','187','939',418,'Retail Sale Id 1183789',34220.00,0.00,0.00,58.00,1044.00,'2022-04-07 13:11:55','',''),(2617174,'1','187','939',418,'Retail Sale Id 1183790',3200.00,0.00,0.00,5.00,340.00,'2022-04-07 15:43:15','',''),(2617175,'1','187','939',418,'Retail Sale Id 1183791',5760.00,0.00,0.00,9.00,612.00,'2022-04-07 15:46:20','',''),(2617176,'1','187','939',418,'Retail Sale Id 1183792',6400.00,0.00,0.00,10.00,680.00,'2022-04-07 15:46:59','',''),(2617177,'1','187','939',418,'Retail Sale Id 1183793',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 15:47:26','',''),(2617178,'1','187','939',418,'Retail Sale Id 1183794',8000.00,0.00,0.00,12.50,850.00,'2022-04-07 15:47:52','',''),(2617179,'1','187','939',418,'Retail Sale Id 1183796',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 16:00:59','',''),(2617180,'1','187','939',418,'Retail Sale Id 1183797',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 16:01:41','',''),(2617181,'1','187','939',418,'Retail Sale Id 1183798',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 16:02:20','',''),(2617182,'1','187','939',418,'Retail Sale Id 1183799',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 16:30:40','',''),(2617183,'1','187','939',418,'Retail Sale Id 1183800',118000.00,0.00,0.00,200.00,3600.00,'2022-04-07 16:31:46','',''),(2617184,'1','187','939',418,'Retail Sale Id 1183801',59000.00,0.00,0.00,100.00,1800.00,'2022-04-07 16:34:03','',''),(2617185,'1','187','939',418,'Retail Sale Id 1183802',88500.00,0.00,0.00,150.00,2700.00,'2022-04-07 16:35:36','',''),(2617186,'1','187','939',418,'Retail Sale Id 1183803',54870.00,0.00,0.00,93.00,1674.00,'2022-04-07 16:37:07','',''),(2617187,'1','187','939',418,'Retail Sale Id 1183804',8000.00,0.00,0.00,12.50,850.00,'2022-04-07 16:39:29','',''),(2617188,'1','187','939',418,'Retail Sale Id 1183805',69944.50,0.00,0.00,118.55,2133.90,'2022-04-07 16:41:47','',''),(2617189,'1','187','939',418,'Retail Sale Id 1183806',3200.00,0.00,0.00,5.00,340.00,'2022-04-07 16:43:04','',''),(2617190,'1','187','939',418,'Retail Sale Id 1183807',5120.00,0.00,0.00,8.00,544.00,'2022-04-07 16:44:03','',''),(2617191,'1','187','939',418,'Retail Sale Id 1183808',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 16:53:51','',''),(2617192,'1','187','939',418,'Retail Sale Id 1183809',5120.00,0.00,0.00,8.00,544.00,'2022-04-07 16:54:24','',''),(2617193,'1','187','939',418,'Retail Sale Id 1183810',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 16:55:01','',''),(2617194,'1','187','939',418,'Retail Sale Id 1183811',3840.00,0.00,0.00,6.00,408.00,'2022-04-07 16:55:44','',''),(2617195,'1','187','939',418,'Retail Sale Id 1183812',5120.00,0.00,0.00,8.00,544.00,'2022-04-07 16:56:16','',''),(2617196,'1','187','939',418,'Retail Sale Id 1183813',1920.00,0.00,0.00,3.00,204.00,'2022-04-07 16:57:04','',''),(2617197,'1','187','939',418,'Retail Sale Id 1183814',8000.00,0.00,0.00,12.50,850.00,'2022-04-07 17:00:52','',''),(2617198,'1','187','939',418,'Retail Sale Id 1183816',59000.00,0.00,0.00,100.00,1800.00,'2022-04-07 17:45:45','',''),(2617199,'1','187','939',418,'Retail Sale Id 1183817',112631.00,0.00,0.00,190.90,3436.20,'2022-04-07 17:47:38','',''),(2617200,'1','187','939',418,'Return of Retail Sale Id 1183817',0.00,112631.00,190.90,0.00,-3436.20,'2022-04-07 17:47:54','',''),(2617201,'1','187','939',418,'Retail Sale Id 1183818',64841.00,0.00,0.00,109.90,1978.20,'2022-04-07 17:48:50','',''),(2617202,'1','187','939',418,'Retail Sale Id 1183819',29936.60,0.00,0.00,50.74,913.32,'2022-04-07 17:50:16','',''),(2617203,'1','187','939',418,'Retail Sale Id 1183820',29500.00,0.00,0.00,50.00,900.00,'2022-04-07 17:53:41','',''),(2617204,'1','187','939',418,'Retail Sale Id 1183821',3840.00,0.00,0.00,6.00,408.00,'2022-04-08 09:13:37','',''),(2617205,'1','187','939',418,'Retail Sale Id 1183822',3200.00,0.00,0.00,5.00,340.00,'2022-04-08 09:13:57','',''),(2617206,'1','187','939',418,'Retail Sale Id 1183823',5120.00,0.00,0.00,8.00,544.00,'2022-04-08 09:14:30','',''),(2617207,'1','187','939',418,'Retail Sale Id 1183824',8000.00,0.00,0.00,12.50,850.00,'2022-04-08 09:24:25','',''),(2617208,'1','187','939',418,'Retail Sale Id 1183825',88500.00,0.00,0.00,150.00,2700.00,'2022-04-08 10:52:26','',''),(2617209,'1','187','939',418,'Retail Sale Id 1183826',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 10:52:58','',''),(2617210,'1','187','939',418,'Retail Sale Id 1183827',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 10:53:29','',''),(2617211,'1','187','939',418,'Retail Sale Id 1183828',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 10:54:05','',''),(2617212,'1','187','939',418,'Retail Sale Id 1183829',8000.00,0.00,0.00,12.50,850.00,'2022-04-08 11:28:54','',''),(2617213,'1','187','939',418,'Retail Sale Id 1183830',147500.00,0.00,0.00,250.00,4500.00,'2022-04-08 11:29:39','',''),(2617214,'1','187','939',418,'Retail Sale Id 1183831',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 11:30:40','',''),(2617215,'1','187','939',418,'Retail Sale Id 1183832',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 11:39:45','',''),(2617216,'1','187','939',418,'Retail Sale Id 1183834',3840.00,0.00,0.00,6.00,408.00,'2022-04-08 14:42:00','',''),(2617217,'1','187','939',418,'Retail Sale Id 1183835',6400.00,0.00,0.00,10.00,680.00,'2022-04-08 14:42:29','',''),(2617218,'1','187','939',418,'Retail Sale Id 1183836',7001.60,0.00,0.00,10.94,743.92,'2022-04-08 14:43:09','',''),(2617219,'1','187','939',418,'Retail Sale Id 1183837',7680.00,0.00,0.00,12.00,816.00,'2022-04-08 14:43:50','',''),(2617220,'1','187','939',418,'Retail Sale Id 1183838',5120.00,0.00,0.00,8.00,544.00,'2022-04-08 14:44:13','',''),(2617221,'1','187','939',418,'Retail Sale Id 1183839',3840.00,0.00,0.00,6.00,408.00,'2022-04-08 14:44:37','',''),(2617222,'1','187','939',418,'Retail Sale Id 1183840',5760.00,0.00,0.00,9.00,612.00,'2022-04-08 14:45:53','',''),(2617223,'1','187','939',418,'Retail Sale Id 1183841',3840.00,0.00,0.00,6.00,408.00,'2022-04-08 14:46:26','',''),(2617224,'1','187','939',418,'Retail Sale Id 1183842',3200.00,0.00,0.00,5.00,340.00,'2022-04-08 14:46:54','',''),(2617225,'1','187','939',418,'Retail Sale Id 1183843',10240.00,0.00,0.00,16.00,1088.00,'2022-04-08 14:47:25','',''),(2617226,'1','187','939',418,'Retail Sale Id 1183844',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 14:47:58','',''),(2617227,'1','187','939',418,'Retail Sale Id 1183845',88500.00,0.00,0.00,150.00,2700.00,'2022-04-08 14:48:33','',''),(2617228,'1','187','939',418,'Retail Sale Id 1183846',88500.00,0.00,0.00,150.00,2700.00,'2022-04-08 14:49:09','',''),(2617229,'1','187','939',418,'Retail Sale Id 1183847',88500.00,0.00,0.00,150.00,2700.00,'2022-04-08 14:50:17','',''),(2617230,'1','187','939',418,'Retail Sale Id 1183848',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 14:50:53','',''),(2617231,'1','187','939',418,'Retail Sale Id 1183849',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 15:17:06','',''),(2617232,'1','187','939',418,'Retail Sale Id 1183850',120950.00,0.00,0.00,205.00,3690.00,'2022-04-08 15:18:36','',''),(2617233,'1','187','939',418,'Retail Sale Id 1183833',3840.00,0.00,0.00,6.00,408.00,'2022-04-08 17:05:35','',''),(2617234,'1','187','939',418,'Retail Sale Id 1183851',4720.00,0.00,0.00,8.00,144.00,'2022-04-08 17:41:50','',''),(2617235,'1','187','939',418,'Retail Sale Id 1183852',118000.00,0.00,0.00,200.00,3600.00,'2022-04-08 17:42:30','',''),(2617236,'1','187','939',418,'Retail Sale Id 1183853',33783.40,0.00,0.00,57.26,1030.68,'2022-04-08 17:45:28','',''),(2617237,'1','187','939',418,'Retail Sale Id 1183855',8000.00,0.00,0.00,12.50,850.00,'2022-04-08 17:48:20','',''),(2617238,'1','187','939',418,'Retail Sale Id 1183856',15360.00,0.00,0.00,24.00,1632.00,'2022-04-08 17:49:58','',''),(2617239,'1','187','939',418,'Retail Sale Id 1183857',8000.00,0.00,0.00,12.50,850.00,'2022-04-08 17:50:20','',''),(2617240,'1','187','939',418,'Retail Sale Id 1183858',7680.00,0.00,0.00,12.00,816.00,'2022-04-08 17:51:55','',''),(2617241,'1','187','939',418,'Retail Sale Id 1183859',7680.00,0.00,0.00,12.00,816.00,'2022-04-08 17:52:20','',''),(2617242,'1','187','939',418,'Retail Sale Id 1183860',5120.00,0.00,0.00,8.00,544.00,'2022-04-08 17:53:01','',''),(2617243,'1','187','939',418,'Retail Sale Id 1183861',59000.00,0.00,0.00,100.00,1800.00,'2022-04-08 17:54:17','',''),(2617244,'1','187','939',418,'Return of Retail Sale Id 1183827',0.00,59000.00,100.00,0.00,-1800.00,'2022-04-08 17:57:11','',''),(2617245,'1','187','939',418,'Retail Sale Id 1183862',11840.00,0.00,0.00,18.50,1258.00,'2022-04-08 17:58:46','',''),(2617246,'1','187','939',418,'Retail Sale Id 1183863',6400.00,0.00,0.00,10.00,680.00,'2022-04-08 17:59:05','',''),(2617247,'1','187','939',418,'Retail Sale Id 1183864',3840.00,0.00,0.00,6.00,408.00,'2022-04-08 17:59:35','',''),(2617248,'1','187','939',418,'Retail Sale Id 1183865',57772.80,0.00,0.00,97.92,1762.56,'2022-04-08 18:01:12','',''),(2617249,'1','187','939',418,'Return of Retail Sale Id 1183856',0.00,15360.00,24.00,0.00,-1632.00,'2022-04-08 18:01:46','',''),(2617250,'1','187','939',418,'Retail Sale Id 1183868',2448.50,0.00,0.00,4.15,74.70,'2022-04-08 18:14:37','',''),(2617251,'1','187','939',418,'Retail Sale Id 1183869',7026.90,0.00,0.00,11.91,214.38,'2022-04-08 18:16:17','',''),(2617252,'1','187','939',418,'Retail Sale Id 1183871',1350.40,0.00,0.00,2.11,143.48,'2022-04-08 18:17:25','',''),(2617253,'1','187','939',418,'Retail Sale Id 1183872',88500.00,0.00,0.00,150.00,2700.00,'2022-04-09 07:58:54','',''),(2617254,'1','187','939',418,'Retail Sale Id 1183873',147500.00,0.00,0.00,250.00,4500.00,'2022-04-09 07:59:52','',''),(2617255,'1','187','939',418,'Retail Sale Id 1183874',177000.00,0.00,0.00,300.00,5400.00,'2022-04-09 08:00:46','',''),(2617256,'1','187','939',418,'Retail Sale Id 1183875',59000.00,0.00,0.00,100.00,1800.00,'2022-04-09 08:01:46','',''),(2617257,'1','187','939',418,'Retail Sale Id 1183876',88500.00,0.00,0.00,150.00,2700.00,'2022-04-09 08:03:20','',''),(2617258,'1','187','939',418,'Retail Sale Id 1183877',5760.00,0.00,0.00,9.00,612.00,'2022-04-09 08:04:12','',''),(2617259,'1','187','939',418,'Retail Sale Id 1183878',8000.00,0.00,0.00,12.50,850.00,'2022-04-09 08:05:04','',''),(2617260,'1','187','939',418,'Retail Sale Id 1183881',8000.00,0.00,0.00,12.50,850.00,'2022-04-09 08:06:06','',''),(2617261,'1','187','939',418,'Retail Sale Id 1183882',177000.00,0.00,0.00,300.00,5400.00,'2022-04-09 08:07:16','',''),(2617262,'1','187','939',418,'Retail Sale Id 1183883',147500.00,0.00,0.00,250.00,4500.00,'2022-04-09 08:08:15','',''),(2617263,'1','187','939',418,'Retail Sale Id 1183884',8000.00,0.00,0.00,12.50,850.00,'2022-04-09 08:09:11','',''),(2617264,'1','187','939',418,'Retail Sale Id 1183885',11840.00,0.00,0.00,18.50,1258.00,'2022-04-09 08:09:59','',''),(2617265,'1','187','939',418,'Retail Sale Id 1183888',7040.00,0.00,0.00,11.00,748.00,'2022-04-09 08:10:58','',''),(2617266,'1','187','939',418,'Retail Sale Id 1183889',118000.00,0.00,0.00,200.00,3600.00,'2022-04-09 08:11:56','',''),(2617267,'1','187','939',418,'Retail Sale Id 1183890',5120.00,0.00,0.00,8.00,544.00,'2022-04-09 15:33:46','',''),(2617268,'1','187','939',418,'Retail Sale Id 1183891',6400.00,0.00,0.00,10.00,680.00,'2022-04-09 15:34:42','',''),(2617269,'1','187','939',418,'Retail Sale Id 1183892',5120.00,0.00,0.00,8.00,544.00,'2022-04-09 15:37:28','',''),(2617270,'1','187','939',418,'Retail Sale Id 1183893',8320.00,0.00,0.00,13.00,884.00,'2022-04-09 15:37:52','',''),(2617271,'1','187','939',418,'Retail Sale Id 1183894',3840.00,0.00,0.00,6.00,408.00,'2022-04-09 15:38:20','',''),(2617272,'1','187','939',418,'Retail Sale Id 1183895',5760.00,0.00,0.00,9.00,612.00,'2022-04-09 15:38:50','',''),(2617273,'1','187','939',418,'Retail Sale Id 1183896',3840.00,0.00,0.00,6.00,408.00,'2022-04-09 15:44:39','',''),(2617274,'1','187','939',418,'Retail Sale Id 1183897',3840.00,0.00,0.00,6.00,408.00,'2022-04-09 15:48:13','',''),(2617275,'1','187','939',418,'Retail Sale Id 1183898',5120.00,0.00,0.00,8.00,544.00,'2022-04-09 16:49:41','',''),(2617276,'1','187','939',418,'Retail Sale Id 1183899',8000.00,0.00,0.00,12.50,850.00,'2022-04-09 16:50:20','',''),(2617277,'1','187','939',418,'Retail Sale Id 1183900',3200.00,0.00,0.00,5.00,340.00,'2022-04-09 16:50:54','',''),(2617278,'1','187','939',418,'Retail Sale Id 1183901',3840.00,0.00,0.00,6.00,408.00,'2022-04-09 16:51:20','',''),(2617279,'1','187','939',418,'Retail Sale Id 1183902',88500.00,0.00,0.00,150.00,2700.00,'2022-04-09 17:05:41','',''),(2617280,'1','187','939',418,'Retail Sale Id 1183903',147500.00,0.00,0.00,250.00,4500.00,'2022-04-09 17:08:24','',''),(2617281,'1','187','939',418,'Retail Sale Id 1183904',59000.00,0.00,0.00,100.00,1800.00,'2022-04-09 17:12:59','',''),(2617282,'1','187','939',418,'Retail Sale Id 1183905',79650.00,0.00,0.00,135.00,2430.00,'2022-04-09 17:14:38','',''),(2617283,'1','187','939',418,'Retail Sale Id 1183906',118000.00,0.00,0.00,200.00,3600.00,'2022-04-09 17:15:42','',''),(2617284,'1','187','939',418,'Retail Sale Id 1183907',902.70,0.00,0.00,1.53,27.54,'2022-04-09 18:11:18','',''),(2617285,'1','187','939',418,'Retail Sale Id 1183908',221651.20,0.00,0.00,375.68,6762.24,'2022-04-09 18:16:12','',''),(2617286,'1','187','939',418,'Retail Sale Id 1183909',63354.20,0.00,0.00,107.38,1932.84,'2022-04-09 18:17:24','',''),(2617287,'1','187','939',418,'Retail Sale Id 1183911',1752.30,0.00,0.00,2.97,53.46,'2022-04-09 18:18:14','',''),(2617288,'1','187','939',418,'Retail Sale Id 1183912',2272.00,0.00,0.00,3.55,241.40,'2022-04-09 18:19:38','',''),(2617289,'1','187','939',418,'Retail Sale Id 1183913',118000.00,0.00,0.00,200.00,3600.00,'2022-04-10 09:24:55','',''),(2617290,'1','187','939',418,'Retail Sale Id 1183914',3840.00,0.00,0.00,6.00,408.00,'2022-04-10 09:27:00','',''),(2617291,'1','187','939',418,'Retail Sale Id 1183915',6400.00,0.00,0.00,10.00,680.00,'2022-04-10 09:28:43','',''),(2617292,'1','187','939',418,'Retail Sale Id 1183916',8000.00,0.00,0.00,12.50,850.00,'2022-04-10 09:29:08','',''),(2617293,'1','187','939',418,'Retail Sale Id 1183917',88500.00,0.00,0.00,150.00,2700.00,'2022-04-10 09:37:20','',''),(2617294,'1','187','939',418,'Retail Sale Id 1183918',88500.00,0.00,0.00,150.00,2700.00,'2022-04-10 09:37:51','',''),(2617295,'1','187','939',418,'Retail Sale Id 1183919',88500.00,0.00,0.00,150.00,2700.00,'2022-04-10 09:38:19','',''),(2617296,'1','187','939',418,'Retail Sale Id 1183920',59000.00,0.00,0.00,100.00,1800.00,'2022-04-10 09:39:11','',''),(2617297,'1','187','939',418,'Retail Sale Id 1183921',59000.00,0.00,0.00,100.00,1800.00,'2022-04-10 09:39:47','',''),(2617298,'1','187','939',418,'Retail Sale Id 1183922',4499.20,0.00,0.00,7.03,478.04,'2022-04-10 09:40:17','',''),(2617299,'1','187','939',418,'Retail Sale Id 1183923',6003.20,0.00,0.00,9.38,637.84,'2022-04-10 09:41:03','',''),(2617300,'1','187','939',418,'Retail Sale Id 1183924',6400.00,0.00,0.00,10.00,680.00,'2022-04-10 09:41:38','',''),(2617301,'1','187','939',418,'Retail Sale Id 1183925',8499.20,0.00,0.00,13.28,903.04,'2022-04-10 09:42:10','',''),(2617302,'1','187','939',418,'Retail Sale Id 1183926',117616.50,0.00,0.00,199.35,3588.30,'2022-04-10 15:25:24','',''),(2617303,'1','187','939',418,'Retail Sale Id 1183927',59000.00,0.00,0.00,100.00,1800.00,'2022-04-10 15:26:23','',''),(2617304,'1','187','939',418,'Retail Sale Id 1183928',88500.00,0.00,0.00,150.00,2700.00,'2022-04-10 15:28:24','',''),(2617305,'1','187','939',418,'Retail Sale Id 1183929',59000.00,0.00,0.00,100.00,1800.00,'2022-04-10 15:29:53','',''),(2617306,'1','187','939',418,'Retail Sale Id 1183930',53100.00,0.00,0.00,90.00,1620.00,'2022-04-10 15:31:38','',''),(2617307,'1','187','939',418,'Retail Sale Id 1183931',59000.00,0.00,0.00,100.00,1800.00,'2022-04-10 15:32:57','',''),(2617308,'1','187','939',418,'Retail Sale Id 1183932',4998.40,0.00,0.00,7.81,531.08,'2022-04-10 15:33:31','',''),(2617309,'1','187','939',418,'Retail Sale Id 1183933',5120.00,0.00,0.00,8.00,544.00,'2022-04-10 15:33:56','',''),(2617310,'1','187','939',418,'Retail Sale Id 1183934',8000.00,0.00,0.00,12.50,850.00,'2022-04-10 15:34:20','',''),(2617311,'1','187','939',418,'Retail Sale Id 1183936',3840.00,0.00,0.00,6.00,408.00,'2022-04-10 15:34:43','',''),(2617312,'1','187','939',418,'Retail Sale Id 1183937',6400.00,0.00,0.00,10.00,680.00,'2022-04-10 15:35:07','',''),(2617313,'1','187','939',418,'Retail Sale Id 1183938',3500.80,0.00,0.00,5.47,371.96,'2022-04-10 15:35:33','',''),(2617314,'1','187','939',418,'Retail Sale Id 1183939',2560.00,0.00,0.00,4.00,272.00,'2022-04-10 15:35:59','',''),(2617315,'1','187','939',418,'Retail Sale Id 1183940',998.40,0.00,0.00,1.56,106.08,'2022-04-10 15:36:31','',''),(2617316,'1','187','939',418,'Retail Sale Id 1183942',3001.60,0.00,0.00,4.69,318.92,'2022-04-10 15:36:58','',''),(2617317,'1','187','939',418,'Retail Sale Id 1183944',3840.00,0.00,0.00,6.00,408.00,'2022-04-10 15:37:52','',''),(2617318,'1','187','939',418,'Retail Sale Id 1183945',45217.60,0.00,0.00,76.64,1379.52,'2022-04-10 15:39:00','',''),(2617319,'1','187','939',418,'Retail Sale Id 1183946',59000.00,0.00,0.00,100.00,1800.00,'2022-04-10 15:53:03','',''),(2617320,'1','187','939',418,'Retail Sale Id 1183947',3020.80,0.00,0.00,4.72,320.96,'2022-04-10 16:13:36','',''),(2617321,'1','187','939',418,'Retail Sale Id 1183948',29328.90,0.00,0.00,49.71,894.78,'2022-04-10 16:14:50','',''),(2617322,'1','187','939',418,'Retail Sale Id 1183949',17316.50,0.00,0.00,29.35,528.30,'2022-04-10 16:23:30','',''),(2617323,'1','187','939',418,'Retail Sale Id 1183950',94400.00,0.00,0.00,160.00,2880.00,'2022-04-11 08:01:49','',''),(2617324,'1','187','939',418,'Retail Sale Id 1183952',118000.00,0.00,0.00,200.00,3600.00,'2022-04-11 08:02:25','',''),(2617325,'1','187','939',418,'Retail Sale Id 1183954',147500.00,0.00,0.00,250.00,4500.00,'2022-04-11 08:03:52','',''),(2617326,'1','187','939',418,'Retail Sale Id 1183955',59000.00,0.00,0.00,100.00,1800.00,'2022-04-11 10:52:23','',''),(2617327,'1','187','939',418,'Retail Sale Id 1183956',8000.00,0.00,0.00,12.50,850.00,'2022-04-11 12:58:25','',''),(2617328,'1','187','939',418,'Retail Sale Id 1183957',6400.00,0.00,0.00,10.00,680.00,'2022-04-11 12:58:53','',''),(2617329,'1','187','939',418,'Retail Sale Id 1183958',6400.00,0.00,0.00,10.00,680.00,'2022-04-11 12:59:32','',''),(2617330,'1','187','939',418,'Retail Sale Id 1183959',5120.00,0.00,0.00,8.00,544.00,'2022-04-11 13:00:59','',''),(2617331,'1','187','939',418,'Retail Sale Id 1183960',3840.00,0.00,0.00,6.00,408.00,'2022-04-11 13:02:14','',''),(2617332,'1','187','939',418,'Retail Sale Id 1183961',3840.00,0.00,0.00,6.00,408.00,'2022-04-11 13:03:00','',''),(2617333,'1','187','939',418,'Retail Sale Id 1183962',4480.00,0.00,0.00,7.00,476.00,'2022-04-11 13:03:27','',''),(2617334,'1','187','939',418,'Retail Sale Id 1183963',5120.00,0.00,0.00,8.00,544.00,'2022-04-11 13:03:53','',''),(2617335,'1','187','939',418,'Retail Sale Id 1183964',5760.00,0.00,0.00,9.00,612.00,'2022-04-11 13:04:17','',''),(2617336,'1','187','939',418,'Retail Sale Id 1183965',3840.00,0.00,0.00,6.00,408.00,'2022-04-11 13:04:42','',''),(2617337,'1','187','939',418,'Retail Sale Id 1183966',1920.00,0.00,0.00,3.00,204.00,'2022-04-11 13:05:06','',''),(2617338,'1','187','939',418,'Retail Sale Id 1183967',3840.00,0.00,0.00,6.00,408.00,'2022-04-11 13:05:29','',''),(2617339,'1','187','939',418,'Retail Sale Id 1183968',7040.00,0.00,0.00,11.00,748.00,'2022-04-11 13:05:53','',''),(2617340,'1','187','939',418,'Retail Sale Id 1183969',5120.00,0.00,0.00,8.00,544.00,'2022-04-11 13:06:18','',''),(2617341,'1','187','939',418,'Retail Sale Id 1183970',2560.00,0.00,0.00,4.00,272.00,'2022-04-11 13:06:55','',''),(2617342,'1','187','939',418,'Retail Sale Id 1183971',5760.00,0.00,0.00,9.00,612.00,'2022-04-11 13:07:23','',''),(2617343,'1','187','939',418,'Retail Sale Id 1183972',3840.00,0.00,0.00,6.00,408.00,'2022-04-11 13:07:47','',''),(2617344,'1','187','939',418,'Retail Sale Id 1183973',4480.00,0.00,0.00,7.00,476.00,'2022-04-11 13:08:15','',''),(2617345,'1','187','939',418,'Retail Sale Id 1183974',3840.00,0.00,0.00,6.00,408.00,'2022-04-11 13:08:49','',''),(2617346,'1','187','939',418,'Retail Sale Id 1183975',6400.00,0.00,0.00,10.00,680.00,'2022-04-11 13:09:19','',''),(2617347,'1','187','939',418,'Retail Sale Id 1183976',63720.00,0.00,0.00,108.00,1944.00,'2022-04-11 13:32:52','',''),(2617348,'1','187','939',418,'Retail Sale Id 1183977',90860.00,0.00,0.00,154.00,2772.00,'2022-04-11 13:33:56','',''),(2617349,'1','187','939',418,'Retail Sale Id 1183978',76700.00,0.00,0.00,130.00,2340.00,'2022-04-11 13:35:06','',''),(2617350,'1','187','939',418,'Retail Sale Id 1183979',41300.00,0.00,0.00,70.00,1260.00,'2022-04-11 13:35:45','',''),(2617351,'1','187','939',418,'Retail Sale Id 1183981',295531.00,0.00,0.00,500.90,9016.20,'2022-04-11 16:20:36','',''),(2617352,'1','187','939',418,'Retail Sale Id 1183987',88500.00,0.00,0.00,150.00,2700.00,'2022-04-11 16:21:46','',''),(2617353,'1','187','939',418,'Retail Sale Id 1183988',59000.00,0.00,0.00,100.00,1800.00,'2022-04-11 16:22:28','',''),(2617354,'1','187','939',418,'Retail Sale Id 1183989',59000.00,0.00,0.00,100.00,1800.00,'2022-04-11 16:23:07','',''),(2617355,'1','187','939',418,'Retail Sale Id 1183990',100300.00,0.00,0.00,170.00,3060.00,'2022-04-11 16:24:46','',''),(2617356,'1','187','939',418,'Retail Sale Id 1183991',67850.00,0.00,0.00,115.00,2070.00,'2022-04-11 16:29:05','',''),(2617357,'1','187','939',418,'Retail Sale Id 1183992',54280.00,0.00,0.00,92.00,1656.00,'2022-04-11 16:30:40','',''),(2617358,'1','187','939',418,'Retail Sale Id 1183993',88500.00,0.00,0.00,150.00,2700.00,'2022-04-11 16:31:37','',''),(2617359,'1','187','939',418,'Retail Sale Id 1183994',24856.70,0.00,0.00,42.13,758.34,'2022-04-11 18:19:25','',''),(2617360,'1','187','939',418,'Retail Sale Id 1183995',38562.40,0.00,0.00,65.36,1176.48,'2022-04-11 18:20:55','',''),(2617361,'1','187','939',418,'Retail Sale Id 1183996',29500.00,0.00,0.00,50.00,900.00,'2022-04-11 18:21:30','',''),(2617362,'1','187','939',418,'Retail Sale Id 1183997',15360.00,0.00,0.00,24.00,1632.00,'2022-04-11 18:22:01','',''),(2617363,'1','187','939',418,'Retail Sale Id 1183998',8000.00,0.00,0.00,12.50,850.00,'2022-04-11 18:22:20','',''),(2617364,'1','187','939',418,'Retail Sale Id 1183999',2073.60,0.00,0.00,3.24,220.32,'2022-04-11 18:23:01','',''),(2617365,'1','187','939',418,'Retail Sale Id 1184000',3840.00,0.00,0.00,6.00,408.00,'2022-04-12 07:20:17','',''),(2617366,'1','187','939',418,'Retail Sale Id 1184001',5120.00,0.00,0.00,8.00,544.00,'2022-04-12 07:20:46','',''),(2617367,'1','187','939',418,'Retail Sale Id 1184002',5120.00,0.00,0.00,8.00,544.00,'2022-04-12 07:21:17','',''),(2617368,'1','187','939',418,'Retail Sale Id 1184003',8000.00,0.00,0.00,12.50,850.00,'2022-04-12 07:22:06','',''),(2617369,'1','187','939',418,'Retail Sale Id 1184004',88500.00,0.00,0.00,150.00,2700.00,'2022-04-12 07:33:57','',''),(2617370,'1','187','939',418,'Retail Sale Id 1184005',88500.00,0.00,0.00,150.00,2700.00,'2022-04-12 07:34:36','',''),(2617371,'1','187','939',418,'Retail Sale Id 1184006',59000.00,0.00,0.00,100.00,1800.00,'2022-04-12 07:35:12','',''),(2617372,'1','187','939',418,'Retail Sale Id 1184007',5120.00,0.00,0.00,8.00,544.00,'2022-04-12 11:03:27','',''),(2617373,'1','187','939',418,'Retail Sale Id 1184008',3200.00,0.00,0.00,5.00,340.00,'2022-04-12 11:03:52','',''),(2617374,'1','187','939',418,'Retail Sale Id 1184009',3840.00,0.00,0.00,6.00,408.00,'2022-04-12 11:04:18','',''),(2617375,'1','187','939',418,'Retail Sale Id 1184010',3200.00,0.00,0.00,5.00,340.00,'2022-04-12 11:04:49','',''),(2617376,'1','187','939',418,'Retail Sale Id 1184011',3840.00,0.00,0.00,6.00,408.00,'2022-04-12 11:05:15','',''),(2617377,'1','187','939',418,'Retail Sale Id 1184012',3500.80,0.00,0.00,5.47,371.96,'2022-04-12 11:12:54','',''),(2617378,'1','187','939',418,'Retail Sale Id 1184013',4000.00,0.00,0.00,6.25,425.00,'2022-04-12 11:13:25','',''),(2617379,'1','187','939',418,'Retail Sale Id 1184014',4499.20,0.00,0.00,7.03,478.04,'2022-04-12 11:13:48','',''),(2617380,'1','187','939',418,'Retail Sale Id 1184015',8000.00,0.00,0.00,12.50,850.00,'2022-04-12 11:14:35','',''),(2617381,'1','187','939',418,'Retail Sale Id 1184016',2240000.00,0.00,0.00,3500.00,238000.00,'2022-04-12 11:15:12','',''),(2617382,'1','187','939',418,'Retail Sale Id 1184017',6400.00,0.00,0.00,10.00,680.00,'2022-04-12 11:16:01','',''),(2617383,'1','187','939',418,'Retail Sale Id 1184018',2880000.00,0.00,0.00,4500.00,306000.00,'2022-04-12 11:17:44','',''),(2617384,'1','187','939',418,'Retail Sale Id 1184019',2560.00,0.00,0.00,4.00,272.00,'2022-04-12 11:18:35','',''),(2617385,'1','187','939',418,'Return of Retail Sale Id 1184018',0.00,2880000.00,4500.00,0.00,-306000.00,'2022-04-12 14:26:53','',''),(2617386,'1','187','939',418,'Return of Retail Sale Id 1184016',0.00,2240000.00,3500.00,0.00,-238000.00,'2022-04-12 14:28:12','',''),(2617387,'1','187','939',418,'Retail Sale Id 1184020',126850.00,0.00,0.00,215.00,3870.00,'2022-04-12 14:31:01','',''),(2617388,'1','187','939',418,'Retail Sale Id 1184021',147500.00,0.00,0.00,250.00,4500.00,'2022-04-12 14:34:15','',''),(2617389,'1','187','939',418,'Retail Sale Id 1184022',88500.00,0.00,0.00,150.00,2700.00,'2022-04-12 14:35:00','',''),(2617390,'1','187','939',418,'Retail Sale Id 1184023',59000.00,0.00,0.00,100.00,1800.00,'2022-04-12 14:36:00','',''),(2617391,'1','187','939',418,'Retail Sale Id 1184024',118000.00,0.00,0.00,200.00,3600.00,'2022-04-12 14:36:57','',''),(2617392,'1','187','939',418,'Retail Sale Id 1184025',88500.00,0.00,0.00,150.00,2700.00,'2022-04-12 14:38:06','',''),(2617393,'1','187','939',418,'Retail Sale Id 1184026',64734.80,0.00,0.00,109.72,1974.96,'2022-04-12 14:39:37','',''),(2617394,'1','187','939',418,'Return of Retail Sale Id 1184015',0.00,8000.00,12.50,0.00,-850.00,'2022-04-12 18:14:41','',''),(2617395,'1','187','939',418,'Retail Sale Id 1184027',2752.00,0.00,0.00,4.30,292.40,'2022-04-12 18:16:05','',''),(2617396,'1','187','939',418,'Retail Sale Id 1184028',103881.30,0.00,0.00,176.07,3169.26,'2022-04-12 18:17:55','',''),(2617397,'1','187','939',418,'Retail Sale Id 1184029',152220.00,0.00,0.00,258.00,4644.00,'2022-04-12 18:19:19','',''),(2617398,'1','187','939',418,'Retail Sale Id 1184030',94423.60,0.00,0.00,160.04,2880.72,'2022-04-12 18:21:32','',''),(2617399,'1','187','939',418,'Retail Sale Id 1184031',47200.00,0.00,0.00,80.00,1440.00,'2022-04-12 18:23:53','',''),(2617400,'1','187','939',418,'Retail Sale Id 1184032',29500.00,0.00,0.00,50.00,900.00,'2022-04-12 18:25:03','',''),(2617401,'1','187','939',418,'Retail Sale Id 1184033',88500.00,0.00,0.00,150.00,2700.00,'2022-04-13 09:12:16','',''),(2617402,'1','187','939',418,'Retail Sale Id 1184035',3200.00,0.00,0.00,5.00,340.00,'2022-04-13 09:13:01','',''),(2617403,'1','187','939',418,'Retail Sale Id 1184036',9600.00,0.00,0.00,15.00,1020.00,'2022-04-13 09:13:40','',''),(2617404,'1','187','939',418,'Retail Sale Id 1184037',59000.00,0.00,0.00,100.00,1800.00,'2022-04-13 09:14:17','',''),(2617405,'1','187','939',418,'Retail Sale Id 1184038',76700.00,0.00,0.00,130.00,2340.00,'2022-04-13 09:15:02','',''),(2617406,'1','187','939',418,'Retail Sale Id 1184039',88500.00,0.00,0.00,150.00,2700.00,'2022-04-13 09:15:45','',''),(2617407,'1','187','939',418,'Retail Sale Id 1184040',59000.00,0.00,0.00,100.00,1800.00,'2022-04-13 09:16:25','',''),(2617408,'1','187','939',418,'Retail Sale Id 1184041',3840.00,0.00,0.00,6.00,408.00,'2022-04-13 09:19:08','',''),(2617409,'1','187','939',418,'Retail Sale Id 1184042',5120.00,0.00,0.00,8.00,544.00,'2022-04-13 09:19:34','',''),(2617410,'1','187','939',418,'Retail Sale Id 1184043',5120.00,0.00,0.00,8.00,544.00,'2022-04-13 09:20:08','',''),(2617411,'1','187','939',418,'Retail Sale Id 1184044',8000.00,0.00,0.00,12.50,850.00,'2022-04-13 09:20:39','',''),(2617412,'1','187','939',418,'Retail Sale Id 1184045',8000.00,0.00,0.00,12.50,850.00,'2022-04-13 13:07:14','',''),(2617413,'1','187','939',418,'Retail Sale Id 1184046',1920.00,0.00,0.00,3.00,204.00,'2022-04-13 13:07:51','',''),(2617414,'1','187','939',418,'Retail Sale Id 1184047',3200.00,0.00,0.00,5.00,340.00,'2022-04-13 13:08:23','',''),(2617415,'1','187','939',418,'Retail Sale Id 1184048',3840.00,0.00,0.00,6.00,408.00,'2022-04-13 13:08:59','',''),(2617416,'1','187','939',418,'Retail Sale Id 1184049',1280.00,0.00,0.00,2.00,136.00,'2022-04-13 13:09:26','',''),(2617417,'1','187','939',418,'Retail Sale Id 1184050',2560.00,0.00,0.00,4.00,272.00,'2022-04-13 13:09:58','',''),(2617418,'1','187','939',418,'Retail Sale Id 1184051',6400.00,0.00,0.00,10.00,680.00,'2022-04-13 13:10:47','',''),(2617419,'1','187','939',418,'Retail Sale Id 1184052',3200.00,0.00,0.00,5.00,340.00,'2022-04-13 13:11:15','',''),(2617420,'1','187','939',418,'Retail Sale Id 1184053',8000.00,0.00,0.00,12.50,850.00,'2022-04-13 18:30:14','',''),(2617421,'1','187','939',418,'Retail Sale Id 1184054',3840.00,0.00,0.00,6.00,408.00,'2022-04-13 18:31:02','',''),(2617422,'1','187','939',418,'Retail Sale Id 1184056',29500.00,0.00,0.00,50.00,900.00,'2022-04-13 18:32:42','',''),(2617423,'1','187','939',418,'Retail Sale Id 1184057',159305.90,0.00,0.00,270.01,4860.18,'2022-04-13 18:33:42','',''),(2617424,'1','187','939',418,'Retail Sale Id 1184058',88500.00,0.00,0.00,150.00,2700.00,'2022-04-13 18:34:47','',''),(2617425,'1','187','939',418,'Retail Sale Id 1184059',37170.00,0.00,0.00,63.00,1134.00,'2022-04-13 18:35:33','',''),(2617426,'1','187','939',418,'Retail Sale Id 1184060',8000.00,0.00,0.00,12.50,850.00,'2022-04-13 18:36:02','',''),(2617427,'1','187','939',418,'Retail Sale Id 1184061',8000.00,0.00,0.00,12.50,850.00,'2022-04-13 18:36:35','',''),(2617428,'1','187','939',418,'Retail Sale Id 1184062',3948.80,0.00,0.00,6.17,419.56,'2022-04-13 18:37:51','',''),(2617429,'1','187','939',418,'Return of Retail Sale Id 1184038',0.00,76700.00,130.00,0.00,-2340.00,'2022-04-13 18:38:14','',''),(2617430,'1','187','939',418,'Retail Sale Id 1184063',47200.00,0.00,0.00,80.00,1440.00,'2022-04-13 18:39:45','',''),(2617431,'1','187','939',418,'Retail Sale Id 1184064',88500.00,0.00,0.00,150.00,2700.00,'2022-04-14 08:08:26','',''),(2617432,'1','187','939',418,'Retail Sale Id 1184065',118000.00,0.00,0.00,200.00,3600.00,'2022-04-14 08:09:13','',''),(2617433,'1','187','939',418,'Retail Sale Id 1184066',11840.00,0.00,0.00,18.50,1258.00,'2022-04-14 08:09:57','',''),(2617434,'1','187','939',418,'Retail Sale Id 1184067',6400.00,0.00,0.00,10.00,680.00,'2022-04-14 08:10:28','',''),(2617435,'1','187','939',418,'Retail Sale Id 1184068',3840.00,0.00,0.00,6.00,408.00,'2022-04-14 08:10:59','',''),(2617436,'1','187','939',418,'Retail Sale Id 1184069',3200.00,0.00,0.00,5.00,340.00,'2022-04-14 13:13:56','',''),(2617437,'1','187','939',418,'Retail Sale Id 1184070',3840.00,0.00,0.00,6.00,408.00,'2022-04-14 13:14:49','',''),(2617438,'1','187','939',418,'Retail Sale Id 1184071',3200.00,0.00,0.00,5.00,340.00,'2022-04-14 13:15:48','',''),(2617439,'1','187','939',418,'Retail Sale Id 1184072',5120.00,0.00,0.00,8.00,544.00,'2022-04-14 13:16:45','',''),(2617440,'1','187','939',418,'Retail Sale Id 1184073',1798.40,0.00,0.00,2.81,191.08,'2022-04-14 13:17:32','',''),(2617441,'1','187','939',418,'Retail Sale Id 1184074',2560.00,0.00,0.00,4.00,272.00,'2022-04-14 13:17:57','',''),(2617442,'1','187','939',418,'Retail Sale Id 1184075',5120.00,0.00,0.00,8.00,544.00,'2022-04-14 13:18:20','',''),(2617443,'1','187','939',418,'Retail Sale Id 1184076',6400.00,0.00,0.00,10.00,680.00,'2022-04-14 13:19:06','',''),(2617444,'1','187','939',418,'Retail Sale Id 1184077',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 13:31:27','',''),(2617445,'1','187','939',418,'Retail Sale Id 1184078',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 13:32:04','',''),(2617446,'1','187','939',418,'Retail Sale Id 1184079',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 13:35:08','',''),(2617447,'1','187','939',418,'Retail Sale Id 1184080',29500.00,0.00,0.00,50.00,900.00,'2022-04-14 13:37:33','',''),(2617448,'1','187','939',418,'Retail Sale Id 1184081',88500.00,0.00,0.00,150.00,2700.00,'2022-04-14 13:38:04','',''),(2617449,'1','187','939',418,'Retail Sale Id 1184082',88500.00,0.00,0.00,150.00,2700.00,'2022-04-14 13:39:04','',''),(2617450,'1','187','939',418,'Retail Sale Id 1184083',15340.00,0.00,0.00,26.00,468.00,'2022-04-14 13:39:39','',''),(2617451,'1','187','939',418,'Retail Sale Id 1184084',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 13:40:17','',''),(2617452,'1','187','939',418,'Retail Sale Id 1184085',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 13:40:46','',''),(2617453,'1','187','939',418,'Retail Sale Id 1184086',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 13:41:35','',''),(2617454,'1','187','939',418,'Retail Sale Id 1184087',29500.00,0.00,0.00,50.00,900.00,'2022-04-14 13:45:03','',''),(2617455,'1','187','939',418,'Retail Sale Id 1184088',21240.00,0.00,0.00,36.00,648.00,'2022-04-14 13:46:10','',''),(2617456,'1','187','939',418,'Retail Sale Id 1184089',7640.50,0.00,0.00,12.95,233.10,'2022-04-14 13:47:04','',''),(2617457,'1','187','939',418,'Retail Sale Id 1184090',3840.00,0.00,0.00,6.00,408.00,'2022-04-14 13:47:54','',''),(2617458,'1','187','939',418,'Retail Sale Id 1184091',1920.00,0.00,0.00,3.00,204.00,'2022-04-14 13:48:23','',''),(2617459,'1','187','939',418,'Retail Sale Id 1184092',4998.40,0.00,0.00,7.81,531.08,'2022-04-14 13:48:49','',''),(2617460,'1','187','939',418,'Retail Sale Id 1184093',7680.00,0.00,0.00,12.00,816.00,'2022-04-14 13:49:22','',''),(2617461,'1','187','939',418,'Retail Sale Id 1184094',5760.00,0.00,0.00,9.00,612.00,'2022-04-14 13:52:22','',''),(2617462,'1','187','939',418,'Retail Sale Id 1184095',3840.00,0.00,0.00,6.00,408.00,'2022-04-14 13:52:49','',''),(2617463,'1','187','939',418,'Retail Sale Id 1184097',3500.80,0.00,0.00,5.47,371.96,'2022-04-14 13:53:19','',''),(2617464,'1','187','939',418,'Retail Sale Id 1184098',4499.20,0.00,0.00,7.03,478.04,'2022-04-14 13:53:44','',''),(2617465,'1','187','939',418,'Retail Sale Id 1184099',118000.00,0.00,0.00,200.00,3600.00,'2022-04-14 17:16:05','',''),(2617466,'1','187','939',418,'Retail Sale Id 1184100',88500.00,0.00,0.00,150.00,2700.00,'2022-04-14 17:17:01','',''),(2617467,'1','187','939',418,'Retail Sale Id 1184101',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 17:17:48','',''),(2617468,'1','187','939',418,'Retail Sale Id 1184102',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 17:18:20','',''),(2617469,'1','187','939',418,'Retail Sale Id 1184103',59000.00,0.00,0.00,100.00,1800.00,'2022-04-14 17:18:57','',''),(2617470,'1','187','939',418,'Retail Sale Id 1184104',29500.00,0.00,0.00,50.00,900.00,'2022-04-14 17:49:03','',''),(2617471,'1','187','939',418,'Retail Sale Id 1184105',118017.70,0.00,0.00,200.03,3600.54,'2022-04-14 17:52:12','',''),(2617472,'1','187','939',418,'Return of Retail Sale Id 1184099',0.00,118000.00,200.00,0.00,-3600.00,'2022-04-14 18:25:10','',''),(2617473,'1','187','939',418,'Retail Sale Id 1184106',29500.00,0.00,0.00,50.00,900.00,'2022-04-14 18:26:51','',''),(2617474,'1','187','939',418,'Retail Sale Id 1184107',8000.00,0.00,0.00,12.50,850.00,'2022-04-14 18:27:22','',''),(2617475,'1','187','939',418,'Retail Sale Id 1184108',6400.00,0.00,0.00,10.00,680.00,'2022-04-14 18:30:11','',''),(2617476,'1','187','939',418,'Retail Sale Id 1184109',46173.40,0.00,0.00,78.26,1408.68,'2022-04-14 18:31:47','',''),(2617477,'1','187','939',418,'Retail Sale Id 1184110',672.00,0.00,0.00,1.05,71.40,'2022-04-14 18:33:28','',''),(2617478,'1','187','939',418,'Retail Sale Id 1184111',29500.00,0.00,0.00,50.00,900.00,'2022-04-14 18:34:50','',''),(2617479,'1','187','939',418,'Retail Sale Id 1184112',29500.00,0.00,0.00,50.00,900.00,'2022-04-14 18:37:20','',''),(2617480,'1','187','939',418,'Retail Sale Id 1184113',10240.00,0.00,0.00,16.00,1088.00,'2022-04-15 07:07:10','',''),(2617481,'1','187','939',418,'Retail Sale Id 1184114',88500.00,0.00,0.00,150.00,2700.00,'2022-04-15 07:08:11','',''),(2617482,'1','187','939',418,'Retail Sale Id 1184115',59000.00,0.00,0.00,100.00,1800.00,'2022-04-15 07:08:49','',''),(2617483,'1','187','939',418,'Retail Sale Id 1184116',3840.00,0.00,0.00,6.00,408.00,'2022-04-15 12:16:05','',''),(2617484,'1','187','939',418,'Retail Sale Id 1184117',5120.00,0.00,0.00,8.00,544.00,'2022-04-15 12:16:41','',''),(2617485,'1','187','939',418,'Retail Sale Id 1184118',3840.00,0.00,0.00,6.00,408.00,'2022-04-15 12:17:03','',''),(2617486,'1','187','939',418,'Retail Sale Id 1184119',3200.00,0.00,0.00,5.00,340.00,'2022-04-15 12:17:32','',''),(2617487,'1','187','939',418,'Retail Sale Id 1184120',3840.00,0.00,0.00,6.00,408.00,'2022-04-15 12:18:50','',''),(2617488,'1','187','939',418,'Retail Sale Id 1184121',3200.00,0.00,0.00,5.00,340.00,'2022-04-15 12:19:19','',''),(2617489,'1','187','939',418,'Retail Sale Id 1184122',68440.00,0.00,0.00,116.00,2088.00,'2022-04-15 12:19:55','',''),(2617490,'1','187','939',418,'Retail Sale Id 1184123',29500.00,0.00,0.00,50.00,900.00,'2022-04-15 12:20:37','',''),(2617491,'1','187','939',418,'Retail Sale Id 1184124',3200.00,0.00,0.00,5.00,340.00,'2022-04-15 12:21:07','',''),(2617492,'1','187','939',418,'Retail Sale Id 1184125',6400.00,0.00,0.00,10.00,680.00,'2022-04-15 12:21:30','',''),(2617493,'1','187','939',418,'Retail Sale Id 1184126',5120.00,0.00,0.00,8.00,544.00,'2022-04-15 12:21:54','',''),(2617494,'1','187','939',418,'Retail Sale Id 1184127',7680.00,0.00,0.00,12.00,816.00,'2022-04-15 12:22:20','',''),(2617495,'1','187','939',418,'Retail Sale Id 1184128',8000.00,0.00,0.00,12.50,850.00,'2022-04-15 12:22:58','',''),(2617496,'1','187','939',418,'Retail Sale Id 1184129',46020.00,0.00,0.00,78.00,1404.00,'2022-04-15 12:25:34','',''),(2617497,'1','187','939',418,'Retail Sale Id 1184130',3840.00,0.00,0.00,6.00,408.00,'2022-04-15 12:26:02','',''),(2617498,'1','187','939',418,'Retail Sale Id 1184131',3200.00,0.00,0.00,5.00,340.00,'2022-04-15 12:26:31','',''),(2617499,'1','187','939',418,'Retail Sale Id 1184132',3840.00,0.00,0.00,6.00,408.00,'2022-04-15 12:28:14','',''),(2617500,'1','187','939',418,'Retail Sale Id 1184133',3200.00,0.00,0.00,5.00,340.00,'2022-04-15 12:28:42','',''),(2617501,'1','187','939',418,'Retail Sale Id 1184134',112100.00,0.00,0.00,190.00,3420.00,'2022-04-15 15:52:15','',''),(2617502,'1','187','939',418,'Retail Sale Id 1184135',88500.00,0.00,0.00,150.00,2700.00,'2022-04-15 15:54:23','',''),(2617503,'1','187','939',418,'Retail Sale Id 1184136',147500.00,0.00,0.00,250.00,4500.00,'2022-04-15 15:55:39','',''),(2617504,'1','187','939',418,'Retail Sale Id 1184137',73750.00,0.00,0.00,125.00,2250.00,'2022-04-15 15:59:23','',''),(2617505,'1','187','939',418,'Retail Sale Id 1184138',8000.00,0.00,0.00,12.50,850.00,'2022-04-15 17:32:31','',''),(2617506,'1','187','939',418,'Retail Sale Id 1184139',29500.00,0.00,0.00,50.00,900.00,'2022-04-15 17:42:09','',''),(2617507,'1','187','939',418,'Retail Sale Id 1184140',1180.00,0.00,0.00,2.00,36.00,'2022-04-15 17:43:14','',''),(2617508,'1','187','939',418,'Retail Sale Id 1184141',11840.00,0.00,0.00,18.50,1258.00,'2022-04-15 17:55:39','',''),(2617509,'1','187','939',418,'Retail Sale Id 1184142',8000.00,0.00,0.00,12.50,850.00,'2022-04-15 17:56:04','',''),(2617510,'1','187','939',418,'Retail Sale Id 1184143',6400.00,0.00,0.00,10.00,680.00,'2022-04-15 17:57:25','',''),(2617511,'1','187','939',418,'Retail Sale Id 1184144',118000.00,0.00,0.00,200.00,3600.00,'2022-04-15 17:58:48','',''),(2617512,'1','187','939',418,'Retail Sale Id 1184145',59000.00,0.00,0.00,100.00,1800.00,'2022-04-15 17:59:30','',''),(2617513,'1','187','939',418,'Retail Sale Id 1184146',122053.30,0.00,0.00,206.87,3723.66,'2022-04-15 18:03:03','',''),(2617514,'1','187','939',418,'Retail Sale Id 1184147',12288.00,0.00,0.00,19.20,1305.60,'2022-04-15 18:17:26','',''),(2617515,'1','187','939',418,'Retail Sale Id 1184148',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 07:50:40','',''),(2617516,'1','187','939',418,'Retail Sale Id 1184149',88500.00,0.00,0.00,150.00,2700.00,'2022-04-16 07:51:22','',''),(2617517,'1','187','939',418,'Retail Sale Id 1184150',88500.00,0.00,0.00,150.00,2700.00,'2022-04-16 07:52:05','',''),(2617518,'1','187','939',418,'Retail Sale Id 1184151',6400.00,0.00,0.00,10.00,680.00,'2022-04-16 07:52:38','',''),(2617519,'1','187','939',418,'Retail Sale Id 1184152',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 07:53:02','',''),(2617520,'1','187','939',418,'Retail Sale Id 1184153',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 07:53:46','',''),(2617521,'1','187','939',418,'Retail Sale Id 1184154',3840.00,0.00,0.00,6.00,408.00,'2022-04-16 10:52:36','',''),(2617522,'1','187','939',418,'Retail Sale Id 1184155',3500.80,0.00,0.00,5.47,371.96,'2022-04-16 10:53:08','',''),(2617523,'1','187','939',418,'Retail Sale Id 1184156',3001.60,0.00,0.00,4.69,318.92,'2022-04-16 10:53:36','',''),(2617524,'1','187','939',418,'Retail Sale Id 1184157',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 10:54:03','',''),(2617525,'1','187','939',418,'Retail Sale Id 1184158',3200.00,0.00,0.00,5.00,340.00,'2022-04-16 10:54:32','',''),(2617526,'1','187','939',418,'Retail Sale Id 1184159',3840.00,0.00,0.00,6.00,408.00,'2022-04-16 10:54:58','',''),(2617527,'1','187','939',418,'Retail Sale Id 1184160',4000.00,0.00,0.00,6.25,425.00,'2022-04-16 10:55:25','',''),(2617528,'1','187','939',418,'Retail Sale Id 1184161',6400.00,0.00,0.00,10.00,680.00,'2022-04-16 10:55:52','',''),(2617529,'1','187','939',418,'Retail Sale Id 1184162',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 10:58:24','',''),(2617530,'1','187','939',418,'Retail Sale Id 1184163',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 10:59:02','',''),(2617531,'1','187','939',418,'Retail Sale Id 1184164',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 11:00:09','',''),(2617532,'1','187','939',418,'Retail Sale Id 1184165',88500.00,0.00,0.00,150.00,2700.00,'2022-04-16 11:00:49','',''),(2617533,'1','187','939',418,'Retail Sale Id 1184166',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 11:01:21','',''),(2617534,'1','187','939',418,'Retail Sale Id 1184167',5120.00,0.00,0.00,8.00,544.00,'2022-04-16 12:02:45','',''),(2617535,'1','187','939',418,'Retail Sale Id 1184168',3398.40,0.00,0.00,5.31,361.08,'2022-04-16 12:03:29','',''),(2617536,'1','187','939',418,'Retail Sale Id 1184169',118000.00,0.00,0.00,200.00,3600.00,'2022-04-16 13:04:06','',''),(2617537,'1','187','939',418,'Retail Sale Id 1184170',88500.00,0.00,0.00,150.00,2700.00,'2022-04-16 13:06:36','',''),(2617538,'1','187','939',418,'Retail Sale Id 1184171',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 13:07:08','',''),(2617539,'1','187','939',418,'Retail Sale Id 1184172',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 13:08:21','',''),(2617540,'1','187','939',418,'Retail Sale Id 1184173',88500.00,0.00,0.00,150.00,2700.00,'2022-04-16 13:09:04','',''),(2617541,'1','187','939',418,'Retail Sale Id 1184174',59000.00,0.00,0.00,100.00,1800.00,'2022-04-16 13:09:35','',''),(2617542,'1','187','939',418,'Retail Sale Id 1184175',44303.10,0.00,0.00,75.09,1351.62,'2022-04-16 13:10:35','',''),(2617543,'1','187','939',418,'Retail Sale Id 1184176',3200.00,0.00,0.00,5.00,340.00,'2022-04-16 15:59:35','',''),(2617544,'1','187','939',418,'Retail Sale Id 1184177',3840.00,0.00,0.00,6.00,408.00,'2022-04-16 16:00:14','',''),(2617545,'1','187','939',418,'Retail Sale Id 1184178',4499.20,0.00,0.00,7.03,478.04,'2022-04-16 16:00:38','',''),(2617546,'1','187','939',418,'Retail Sale Id 1184179',3001.60,0.00,0.00,4.69,318.92,'2022-04-16 16:01:01','',''),(2617547,'1','187','939',418,'Retail Sale Id 1184180',2502.40,0.00,0.00,3.91,265.88,'2022-04-16 16:01:23','',''),(2617548,'1','187','939',418,'Retail Sale Id 1184181',6003.20,0.00,0.00,9.38,637.84,'2022-04-16 16:01:51','',''),(2617549,'1','187','939',418,'Retail Sale Id 1184182',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 16:03:29','',''),(2617550,'1','187','939',418,'Retail Sale Id 1184183',7680.00,0.00,0.00,12.00,816.00,'2022-04-16 16:14:30','',''),(2617551,'1','187','939',418,'Retail Sale Id 1184184',88500.00,0.00,0.00,150.00,2700.00,'2022-04-16 16:15:39','',''),(2617552,'1','187','939',418,'Retail Sale Id 1184185',64900.00,0.00,0.00,110.00,1980.00,'2022-04-16 16:17:12','',''),(2617553,'1','187','939',418,'Retail Sale Id 1184186',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 16:20:37','',''),(2617554,'1','187','939',418,'Retail Sale Id 1184187',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 16:21:11','',''),(2617555,'1','187','939',418,'Retail Sale Id 1184188',5120.00,0.00,0.00,8.00,544.00,'2022-04-16 16:36:23','',''),(2617556,'1','187','939',418,'Retail Sale Id 1184189',3840.00,0.00,0.00,6.00,408.00,'2022-04-16 16:37:21','',''),(2617557,'1','187','939',418,'Retail Sale Id 1184190',1920.00,0.00,0.00,3.00,204.00,'2022-04-16 16:37:44','',''),(2617558,'1','187','939',418,'Retail Sale Id 1184192',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 16:50:29','',''),(2617559,'1','187','939',418,'Retail Sale Id 1184193',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 17:14:56','',''),(2617560,'1','187','939',418,'Retail Sale Id 1184194',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 17:40:55','',''),(2617561,'1','187','939',418,'Retail Sale Id 1184195',3200.00,0.00,0.00,5.00,340.00,'2022-04-16 17:43:10','',''),(2617562,'1','187','939',418,'Retail Sale Id 1184196',3840.00,0.00,0.00,6.00,408.00,'2022-04-16 17:43:40','',''),(2617563,'1','187','939',418,'Retail Sale Id 1184197',15936.00,0.00,0.00,24.90,1693.20,'2022-04-16 18:02:26','',''),(2617564,'1','187','939',418,'Retail Sale Id 1184198',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 18:06:17','',''),(2617565,'1','187','939',418,'Retail Sale Id 1184199',8000.00,0.00,0.00,12.50,850.00,'2022-04-16 18:07:06','',''),(2617566,'1','187','939',418,'Retail Sale Id 1184200',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 18:10:29','',''),(2617567,'1','187','939',418,'Retail Sale Id 1184201',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 18:10:54','',''),(2617568,'1','187','939',418,'Retail Sale Id 1184202',29500.00,0.00,0.00,50.00,900.00,'2022-04-16 18:12:34','',''),(2617569,'1','187','939',418,'Retail Sale Id 1184203',11840.00,0.00,0.00,18.50,1258.00,'2022-04-16 18:14:05','',''),(2617570,'1','187','939',418,'Return of Retail Sale Id 1184195',0.00,3200.00,5.00,0.00,-340.00,'2022-04-16 18:14:53','',''),(2617571,'1','187','939',418,'Retail Sale Id 1184204',1811.20,0.00,0.00,2.83,192.44,'2022-04-16 18:16:40','',''),(2617572,'1','187','939',418,'Retail Sale Id 1184205',3840.00,0.00,0.00,6.00,408.00,'2022-04-17 10:15:27','',''),(2617573,'1','187','939',418,'Retail Sale Id 1184206',3200.00,0.00,0.00,5.00,340.00,'2022-04-17 10:18:05','',''),(2617574,'1','187','939',418,'Retail Sale Id 1184207',1491.20,0.00,0.00,2.33,158.44,'2022-04-17 10:19:03','',''),(2617575,'1','187','939',418,'Retail Sale Id 1184208',29500.00,0.00,0.00,50.00,900.00,'2022-04-17 10:21:04','',''),(2617576,'1','187','939',418,'Retail Sale Id 1184209',29500.00,0.00,0.00,50.00,900.00,'2022-04-17 10:22:25','',''),(2617577,'1','187','939',418,'Retail Sale Id 1184210',63720.00,0.00,0.00,108.00,1944.00,'2022-04-17 10:23:38','',''),(2617578,'1','187','939',418,'Retail Sale Id 1184211',8000.00,0.00,0.00,12.50,850.00,'2022-04-17 10:24:56','',''),(2617579,'1','187','939',418,'Retail Sale Id 1184212',3840.00,0.00,0.00,6.00,408.00,'2022-04-17 10:38:33','',''),(2617580,'1','187','939',418,'Retail Sale Id 1184213',3840.00,0.00,0.00,6.00,408.00,'2022-04-17 10:38:56','',''),(2617581,'1','187','939',418,'Retail Sale Id 1184214',3200.00,0.00,0.00,5.00,340.00,'2022-04-17 10:39:17','',''),(2617582,'1','187','939',418,'Retail Sale Id 1184215',8490.10,0.00,0.00,14.39,259.02,'2022-04-17 11:43:10','',''),(2617583,'1','187','939',418,'Retail Sale Id 1184216',65731.90,0.00,0.00,111.41,2005.38,'2022-04-17 11:44:38','',''),(2617584,'1','187','939',418,'Retail Sale Id 1184217',8000.00,0.00,0.00,12.50,850.00,'2022-04-17 11:45:08','',''),(2617585,'1','187','939',418,'Retail Sale Id 1184218',5152.00,0.00,0.00,8.05,547.40,'2022-04-17 11:46:59','',''),(2617586,'1','187','939',418,'Retail Sale Id 1184219',15682.20,0.00,0.00,26.58,478.44,'2022-04-17 14:04:52','',''),(2617587,'1','187','939',418,'Retail Sale Id 1184220',29500.00,0.00,0.00,50.00,900.00,'2022-04-17 14:05:20','',''),(2617588,'1','187','939',418,'Retail Sale Id 1184221',35228.90,0.00,0.00,59.71,1074.78,'2022-04-17 14:06:04','',''),(2617589,'1','187','939',418,'Retail Sale Id 1184222',35181.70,0.00,0.00,59.63,1073.34,'2022-04-17 14:07:12','',''),(2617590,'1','187','939',418,'Retail Sale Id 1184223',49908.10,0.00,0.00,84.59,1522.62,'2022-04-17 14:08:42','',''),(2617591,'1','187','939',418,'Retail Sale Id 1184224',6400.00,0.00,0.00,10.00,680.00,'2022-04-17 14:11:16','',''),(2617592,'1','187','939',418,'Retail Sale Id 1184225',9036.80,0.00,0.00,14.12,960.16,'2022-04-17 14:12:40','',''),(2617593,'1','187','939',418,'Distributed to OPERATIONAL LOSS for sales id:332548',329655.04,0.00,0.00,576.32,0.00,'2022-04-17 15:20:06','',''),(2617594,'1','187',NULL,418,'Purchased from AA RANO NIGERIA LIMITED',0.00,14050000.00,25000.00,0.00,0.00,'2022-04-17 15:36:09','',''),(2617595,'1','187',NULL,418,'Reception corrector for bridging 123751',0.00,0.00,0.00,24999.00,0.00,'2022-04-18 10:36:52','',''),(2617596,'1','187','939',418,'Received from bridging 123751',0.00,0.00,24999.00,0.00,0.00,'2022-04-18 10:36:52','',''),(2617597,'1','187','939',418,'Retail Sale Id 1184234',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 10:37:32','',''),(2617598,'1','187','939',418,'Retail Sale Id 1184235',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 10:38:19','',''),(2617599,'1','187','939',418,'Retail Sale Id 1184236',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 10:38:55','',''),(2617600,'1','187','939',418,'Retail Sale Id 1184237',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 10:39:33','',''),(2617601,'1','187','939',418,'Retail Sale Id 1184238',16000.00,0.00,0.00,25.00,1950.00,'2022-04-18 10:40:06','',''),(2617602,'1','187','939',418,'Retail Sale Id 1184239',147500.00,0.00,0.00,250.00,7000.00,'2022-04-18 10:40:57','',''),(2617603,'1','187','939',418,'Retail Sale Id 1184240',118000.00,0.00,0.00,200.00,5600.00,'2022-04-18 10:42:28','',''),(2617604,'1','187','939',418,'Retail Sale Id 1184241',118000.00,0.00,0.00,200.00,5600.00,'2022-04-18 10:43:32','',''),(2617605,'1','187','939',418,'Retail Sale Id 1184242',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 10:44:27','',''),(2617606,'1','187','939',418,'Retail Sale Id 1184243',1920.00,0.00,0.00,3.00,234.00,'2022-04-18 10:44:56','',''),(2617607,'1','187','939',418,'Retail Sale Id 1184244',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 10:45:26','',''),(2617608,'1','187','939',418,'Retail Sale Id 1184245',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 10:45:30','',''),(2617609,'1','187','939',418,'Retail Sale Id 1184246',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 10:46:04','',''),(2617610,'1','187','939',418,'Retail Sale Id 1184247',58000.00,0.00,0.00,100.00,1800.00,'2022-04-18 10:46:52','',''),(2617611,'1','187','939',418,'Retail Sale Id 1184248',116000.00,0.00,0.00,200.00,3600.00,'2022-04-18 10:47:09','',''),(2617612,'1','187','939',418,'Return of Retail Sale Id 1184241',0.00,118000.00,200.00,0.00,-5600.00,'2022-04-18 10:49:03','',''),(2617613,'1','187','939',418,'Return of Retail Sale Id 1184239',0.00,147500.00,250.00,0.00,-7000.00,'2022-04-18 10:49:38','',''),(2617614,'1','187','939',418,'Return of Retail Sale Id 1184240',0.00,118000.00,200.00,0.00,-5600.00,'2022-04-18 10:52:22','',''),(2617615,'1','187','939',418,'Retail Sale Id 1184250',116000.00,0.00,0.00,200.00,3600.00,'2022-04-18 10:57:32','',''),(2617616,'1','187','939',418,'Retail Sale Id 1184251',145000.00,0.00,0.00,250.00,4500.00,'2022-04-18 11:00:46','',''),(2617617,'1','187','939',418,'Retail Sale Id 1184252',87000.00,0.00,0.00,150.00,2700.00,'2022-04-18 11:01:35','',''),(2617618,'1','187','939',418,'Retail Sale Id 1184253',6400.00,0.00,0.00,10.00,780.00,'2022-04-18 11:02:01','',''),(2617619,'1','187','939',418,'Retail Sale Id 1184254',145000.00,0.00,0.00,250.00,4500.00,'2022-04-18 11:05:05','',''),(2617620,'1','187','939',418,'Retail Sale Id 1184255',58000.00,0.00,0.00,100.00,1800.00,'2022-04-18 11:06:16','',''),(2617621,'1','187','939',418,'Retail Sale Id 1184256',87000.00,0.00,0.00,150.00,2700.00,'2022-04-18 14:04:27','',''),(2617622,'1','187','939',418,'Retail Sale Id 1184257',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 14:04:57','',''),(2617623,'1','187','939',418,'Retail Sale Id 1184258',116452.40,0.00,0.00,200.78,3614.04,'2022-04-18 14:05:46','',''),(2617624,'1','187','939',418,'Retail Sale Id 1184259',139368.20,0.00,0.00,240.29,4325.22,'2022-04-18 14:06:35','',''),(2617625,'1','187','939',418,'Retail Sale Id 1184260',120640.00,0.00,0.00,208.00,3744.00,'2022-04-18 14:07:42','',''),(2617626,'1','187','939',418,'Retail Sale Id 1184261',87000.00,0.00,0.00,150.00,2700.00,'2022-04-18 14:08:23','',''),(2617627,'1','187','939',418,'Retail Sale Id 1184262',37758.00,0.00,0.00,65.10,1171.80,'2022-04-18 14:09:48','',''),(2617628,'1','187','939',418,'Retail Sale Id 1184263',87000.00,0.00,0.00,150.00,2700.00,'2022-04-18 14:10:57','',''),(2617629,'1','187','939',418,'Retail Sale Id 1184264',290000.00,0.00,0.00,500.00,9000.00,'2022-04-18 14:11:46','',''),(2617630,'1','187','939',418,'Retail Sale Id 1184265',15068.40,0.00,0.00,25.98,467.64,'2022-04-18 14:12:50','',''),(2617631,'1','187','939',418,'Retail Sale Id 1184266',116000.00,0.00,0.00,200.00,3600.00,'2022-04-18 14:13:27','',''),(2617632,'1','187','939',418,'Retail Sale Id 1184267',53360.00,0.00,0.00,92.00,1656.00,'2022-04-18 14:14:40','',''),(2617633,'1','187','939',418,'Retail Sale Id 1184268',5120.00,0.00,0.00,8.00,624.00,'2022-04-18 14:15:04','',''),(2617634,'1','187','939',418,'Retail Sale Id 1184269',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 14:15:26','',''),(2617635,'1','187','939',418,'Retail Sale Id 1184270',1920.00,0.00,0.00,3.00,234.00,'2022-04-18 14:15:51','',''),(2617636,'1','187','939',418,'Retail Sale Id 1184271',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 14:16:14','',''),(2617637,'1','187','939',418,'Retail Sale Id 1184272',6400.00,0.00,0.00,10.00,780.00,'2022-04-18 14:16:49','',''),(2617638,'1','187','939',418,'Retail Sale Id 1184273',3001.60,0.00,0.00,4.69,365.82,'2022-04-18 14:17:14','',''),(2617639,'1','187','939',418,'Retail Sale Id 1184274',2502.40,0.00,0.00,3.91,304.98,'2022-04-18 14:17:39','',''),(2617640,'1','187','939',418,'Retail Sale Id 1184275',4000.00,0.00,0.00,6.25,487.50,'2022-04-18 14:18:00','',''),(2617641,'1','187','939',418,'Retail Sale Id 1184276',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 14:18:24','',''),(2617642,'1','187','939',418,'Retail Sale Id 1184277',2502.40,0.00,0.00,3.91,304.98,'2022-04-18 14:18:52','',''),(2617643,'1','187','939',418,'Retail Sale Id 1184278',3200.00,0.00,0.00,5.00,390.00,'2022-04-18 14:19:20','',''),(2617644,'1','187','939',418,'Retail Sale Id 1184279',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 14:20:59','',''),(2617645,'1','187','939',418,'Retail Sale Id 1184280',6400.00,0.00,0.00,10.00,780.00,'2022-04-18 14:21:27','',''),(2617646,'1','187','939',418,'Retail Sale Id 1184281',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 14:21:51','',''),(2617647,'1','187','939',418,'Retail Sale Id 1184282',1920.00,0.00,0.00,3.00,234.00,'2022-04-18 17:14:25','',''),(2617648,'1','187','939',418,'Retail Sale Id 1184283',3200.00,0.00,0.00,5.00,390.00,'2022-04-18 17:14:53','',''),(2617649,'1','187','939',418,'Retail Sale Id 1184284',6400.00,0.00,0.00,10.00,780.00,'2022-04-18 17:15:17','',''),(2617650,'1','187','939',418,'Retail Sale Id 1184285',3840.00,0.00,0.00,6.00,468.00,'2022-04-18 17:15:40','',''),(2617651,'1','187','939',418,'Retail Sale Id 1184286',3200.00,0.00,0.00,5.00,390.00,'2022-04-18 17:16:02','',''),(2617652,'1','187','939',418,'Retail Sale Id 1184287',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 17:16:29','',''),(2617653,'1','187','939',418,'Retail Sale Id 1184288',2560.00,0.00,0.00,4.00,312.00,'2022-04-18 17:16:51','',''),(2617654,'1','187','939',418,'Retail Sale Id 1184289',4480.00,0.00,0.00,7.00,546.00,'2022-04-18 17:17:23','',''),(2617655,'1','187','939',418,'Retail Sale Id 1184290',1920.00,0.00,0.00,3.00,234.00,'2022-04-18 17:17:53','',''),(2617656,'1','187','939',418,'Retail Sale Id 1184291',3200.00,0.00,0.00,5.00,390.00,'2022-04-18 17:18:17','',''),(2617657,'1','187','939',418,'Retail Sale Id 1184292',6400.00,0.00,0.00,10.00,780.00,'2022-04-18 17:18:37','',''),(2617658,'1','187','939',418,'Retail Sale Id 1184293',7040.00,0.00,0.00,11.00,858.00,'2022-04-18 17:18:57','',''),(2617659,'1','187','939',418,'Retail Sale Id 1184294',1920.00,0.00,0.00,3.00,234.00,'2022-04-18 17:19:22','',''),(2617660,'1','187','939',418,'Retail Sale Id 1184295',4480.00,0.00,0.00,7.00,546.00,'2022-04-18 17:19:44','',''),(2617661,'1','187','939',418,'Retail Sale Id 1184296',3200.00,0.00,0.00,5.00,390.00,'2022-04-18 17:23:05','',''),(2617662,'1','187','939',418,'Retail Sale Id 1184297',2560.00,0.00,0.00,4.00,312.00,'2022-04-18 17:24:44','',''),(2617663,'1','187','939',418,'Retail Sale Id 1184298',1408.00,0.00,0.00,2.20,171.60,'2022-04-18 17:26:29','',''),(2617664,'1','187','939',418,'Retail Sale Id 1184299',87000.00,0.00,0.00,150.00,2700.00,'2022-04-18 17:59:29','',''),(2617665,'1','187','939',418,'Retail Sale Id 1184300',174000.00,0.00,0.00,300.00,5400.00,'2022-04-18 18:00:15','',''),(2617666,'1','187','939',418,'Retail Sale Id 1184301',70446.80,0.00,0.00,121.46,2186.28,'2022-04-18 18:02:23','',''),(2617667,'1','187','939',418,'Retail Sale Id 1184302',37700.00,0.00,0.00,65.00,1170.00,'2022-04-18 18:03:22','',''),(2617668,'1','187','939',418,'Retail Sale Id 1184303',161240.00,0.00,0.00,278.00,5004.00,'2022-04-18 18:04:42','',''),(2617669,'1','187','939',418,'Retail Sale Id 1184304',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 18:05:52','',''),(2617670,'1','187','939',418,'Retail Sale Id 1184305',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 18:06:12','',''),(2617671,'1','187','939',418,'Retail Sale Id 1184306',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 18:06:31','',''),(2617672,'1','187','939',418,'Retail Sale Id 1184307',15360.00,0.00,0.00,24.00,1872.00,'2022-04-18 18:07:35','',''),(2617673,'1','187','939',418,'Retail Sale Id 1184308',12800.00,0.00,0.00,20.00,1560.00,'2022-04-18 18:07:53','',''),(2617674,'1','187','939',418,'Retail Sale Id 1184309',3500.80,0.00,0.00,5.47,426.66,'2022-04-18 18:09:07','',''),(2617675,'1','187','939',418,'Retail Sale Id 1184310',4000.00,0.00,0.00,6.25,487.50,'2022-04-18 18:09:33','',''),(2617676,'1','187','939',418,'Retail Sale Id 1184311',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 18:10:48','',''),(2617677,'1','187','939',418,'Retail Sale Id 1184312',5497.60,0.00,0.00,8.59,670.02,'2022-04-18 18:11:57','',''),(2617678,'1','187','939',418,'Retail Sale Id 1184313',8000.00,0.00,0.00,12.50,975.00,'2022-04-18 18:12:16','',''),(2617679,'1','187','939',418,'Retail Sale Id 1184315',4000.00,0.00,0.00,6.25,487.50,'2022-04-18 18:13:04','',''),(2617680,'1','187','939',418,'Retail Sale Id 1184316',6400.00,0.00,0.00,10.00,780.00,'2022-04-18 18:13:44','',''),(2617681,'1','187','939',418,'Retail Sale Id 1184317',107300.00,0.00,0.00,185.00,3330.00,'2022-04-18 18:29:54','',''),(2617682,'1','187','939',418,'Retail Sale Id 1184318',58000.00,0.00,0.00,100.00,1800.00,'2022-04-18 18:31:54','',''),(2617683,'1','187','939',418,'Retail Sale Id 1184319',15360.00,0.00,0.00,24.00,1872.00,'2022-04-18 18:32:54','',''),(2617684,'1','187','939',418,'Retail Sale Id 1184320',11468.80,0.00,0.00,17.92,1397.76,'2022-04-18 18:33:20','',''),(2617685,'1','187','939',418,'Retail Sale Id 1184321',116000.00,0.00,0.00,200.00,3600.00,'2022-04-19 08:28:49','',''),(2617686,'1','187','939',418,'Retail Sale Id 1184322',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 08:35:37','',''),(2617687,'1','187','939',418,'Retail Sale Id 1184323',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 08:36:39','',''),(2617688,'1','187','939',418,'Retail Sale Id 1184324',3840.00,0.00,0.00,6.00,468.00,'2022-04-19 08:37:47','',''),(2617689,'1','187','939',418,'Retail Sale Id 1184325',6400.00,0.00,0.00,10.00,780.00,'2022-04-19 08:39:25','',''),(2617690,'1','187','939',418,'Retail Sale Id 1184326',7680.00,0.00,0.00,12.00,936.00,'2022-04-19 09:40:33','',''),(2617691,'1','187','939',418,'Retail Sale Id 1184327',3840.00,0.00,0.00,6.00,468.00,'2022-04-19 09:42:05','',''),(2617692,'1','187','939',418,'Retail Sale Id 1184328',3200.00,0.00,0.00,5.00,390.00,'2022-04-19 09:44:17','',''),(2617693,'1','187','939',418,'Retail Sale Id 1184329',6400.00,0.00,0.00,10.00,780.00,'2022-04-19 09:44:43','',''),(2617694,'1','187','939',418,'Retail Sale Id 1184330',5120.00,0.00,0.00,8.00,624.00,'2022-04-19 09:45:08','',''),(2617695,'1','187','939',418,'Retail Sale Id 1184331',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 11:52:26','',''),(2617696,'1','187','939',418,'Retail Sale Id 1184332',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 11:53:01','',''),(2617697,'1','187','939',418,'Retail Sale Id 1184333',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 11:54:00','',''),(2617698,'1','187','939',418,'Retail Sale Id 1184334',87000.00,0.00,0.00,150.00,2700.00,'2022-04-19 11:54:50','',''),(2617699,'1','187','939',418,'Retail Sale Id 1184335',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 11:56:19','',''),(2617700,'1','187','939',418,'Retail Sale Id 1184336',145000.00,0.00,0.00,250.00,4500.00,'2022-04-19 14:46:18','',''),(2617701,'1','187','939',418,'Retail Sale Id 1184337',23432.00,0.00,0.00,40.40,727.20,'2022-04-19 14:47:05','',''),(2617702,'1','187','939',418,'Retail Sale Id 1184338',52200.00,0.00,0.00,90.00,1620.00,'2022-04-19 14:48:02','',''),(2617703,'1','187','939',418,'Retail Sale Id 1184339',58000.00,0.00,0.00,100.00,1800.00,'2022-04-19 14:48:44','',''),(2617704,'1','187','939',418,'Retail Sale Id 1184340',56840.00,0.00,0.00,98.00,1764.00,'2022-04-19 14:49:46','',''),(2617705,'1','187','939',418,'Retail Sale Id 1184341',6400.00,0.00,0.00,10.00,780.00,'2022-04-19 14:50:06','',''),(2617706,'1','187','939',418,'Retail Sale Id 1184342',5120.00,0.00,0.00,8.00,624.00,'2022-04-19 14:50:25','',''),(2617707,'1','187','939',418,'Retail Sale Id 1184343',3840.00,0.00,0.00,6.00,468.00,'2022-04-19 14:50:44','',''),(2617708,'1','187','939',418,'Retail Sale Id 1184344',7680.00,0.00,0.00,12.00,936.00,'2022-04-19 14:51:03','',''),(2617709,'1','187','939',418,'Retail Sale Id 1184345',4000.00,0.00,0.00,6.25,487.50,'2022-04-19 14:51:28','',''),(2617710,'1','187','939',418,'Retail Sale Id 1184347',4499.20,0.00,0.00,7.03,548.34,'2022-04-19 14:52:17','',''),(2617711,'1','187','939',418,'Retail Sale Id 1184349',3500.80,0.00,0.00,5.47,426.66,'2022-04-19 14:53:00','',''),(2617712,'1','187','939',418,'Retail Sale Id 1184350',3840.00,0.00,0.00,6.00,468.00,'2022-04-19 14:53:21','',''),(2617713,'1','187','939',418,'Retail Sale Id 1184351',4480.00,0.00,0.00,7.00,546.00,'2022-04-19 14:53:42','',''),(2617714,'1','187','939',418,'Retail Sale Id 1184352',3200.00,0.00,0.00,5.00,390.00,'2022-04-19 14:54:02','',''),(2617715,'1','187','939',418,'Retail Sale Id 1184353',3840.00,0.00,0.00,6.00,468.00,'2022-04-19 14:54:24','',''),(2617716,'1','187','939',418,'Retail Sale Id 1184354',2560.00,0.00,0.00,4.00,312.00,'2022-04-19 14:54:44','',''),(2617717,'1','187','939',418,'Retail Sale Id 1184355',22040.00,0.00,0.00,38.00,684.00,'2022-04-19 17:57:45','',''),(2617718,'1','187','939',418,'Retail Sale Id 1184356',29000.00,0.00,0.00,50.00,900.00,'2022-04-19 18:00:16','',''),(2617719,'1','187','939',418,'Retail Sale Id 1184357',87000.00,0.00,0.00,150.00,2700.00,'2022-04-19 18:05:20','',''),(2617720,'1','187','939',418,'Retail Sale Id 1184358',22400.00,0.00,0.00,35.00,2730.00,'2022-04-19 18:07:44','',''),(2617721,'1','187','939',418,'Retail Sale Id 1184359',11840.00,0.00,0.00,18.50,1443.00,'2022-04-19 18:08:06','',''),(2617722,'1','187','939',418,'Retail Sale Id 1184360',8000.00,0.00,0.00,12.50,975.00,'2022-04-19 18:08:26','',''),(2617723,'1','187','939',418,'Retail Sale Id 1184361',6400.00,0.00,0.00,10.00,780.00,'2022-04-19 18:08:55','',''),(2617724,'1','187','939',418,'Retail Sale Id 1184362',4985.60,0.00,0.00,7.79,607.62,'2022-04-19 18:20:39','',''),(2617725,'1','187','939',418,'Retail Sale Id 1184363',87000.00,0.00,0.00,150.00,2700.00,'2022-04-20 07:08:28','',''),(2617726,'1','187','939',418,'Retail Sale Id 1184364',58000.00,0.00,0.00,100.00,1800.00,'2022-04-20 07:09:06','',''),(2617727,'1','187','939',418,'Retail Sale Id 1184365',116000.00,0.00,0.00,200.00,3600.00,'2022-04-20 07:09:45','',''),(2617728,'1','187','939',418,'Retail Sale Id 1184366',69600.00,0.00,0.00,120.00,2160.00,'2022-04-20 07:10:24','',''),(2617729,'1','187','939',418,'Retail Sale Id 1184367',58000.00,0.00,0.00,100.00,1800.00,'2022-04-20 07:10:57','',''),(2617730,'1','187','939',418,'Retail Sale Id 1184368',8000.00,0.00,0.00,12.50,975.00,'2022-04-20 07:11:33','',''),(2617731,'1','187','939',418,'Retail Sale Id 1184369',8000.00,0.00,0.00,12.50,975.00,'2022-04-20 07:12:01','',''),(2617732,'1','187','939',418,'Retail Sale Id 1184370',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 10:22:11','',''),(2617733,'1','187','939',418,'Retail Sale Id 1184371',1920.00,0.00,0.00,3.00,234.00,'2022-04-20 10:22:41','',''),(2617734,'1','187','939',418,'Retail Sale Id 1184372',998.40,0.00,0.00,1.56,121.68,'2022-04-20 10:23:28','',''),(2617735,'1','187','939',418,'Retail Sale Id 1184373',33640.00,0.00,0.00,58.00,1044.00,'2022-04-20 10:25:25','',''),(2617736,'1','187','939',418,'Retail Sale Id 1184374',58000.00,0.00,0.00,100.00,1800.00,'2022-04-20 10:26:08','',''),(2617737,'1','187','939',418,'Retail Sale Id 1184375',8000.00,0.00,0.00,12.50,975.00,'2022-04-20 10:26:45','',''),(2617738,'1','187','939',418,'Retail Sale Id 1184376',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 10:27:15','',''),(2617739,'1','187','939',418,'Retail Sale Id 1184377',1920.00,0.00,0.00,3.00,234.00,'2022-04-20 10:27:46','',''),(2617740,'1','187','939',418,'Retail Sale Id 1184378',3001.60,0.00,0.00,4.69,365.82,'2022-04-20 10:28:20','',''),(2617741,'1','187','939',418,'Retail Sale Id 1184379',1497.60,0.00,0.00,2.34,182.52,'2022-04-20 10:28:50','',''),(2617742,'1','187','939',418,'Retail Sale Id 1184380',58000.00,0.00,0.00,100.00,1800.00,'2022-04-20 10:31:20','',''),(2617743,'1','187','939',418,'Retail Sale Id 1184381',58000.00,0.00,0.00,100.00,1800.00,'2022-04-20 10:32:11','',''),(2617744,'1','187','939',418,'Retail Sale Id 1184382',6400.00,0.00,0.00,10.00,780.00,'2022-04-20 10:33:17','',''),(2617745,'1','187','939',418,'Retail Sale Id 1184383',29000.00,0.00,0.00,50.00,900.00,'2022-04-20 10:34:06','',''),(2617746,'1','187','939',418,'Retail Sale Id 1184384',75342.00,0.00,0.00,129.90,2338.20,'2022-04-20 13:36:41','',''),(2617747,'1','187','939',418,'Retail Sale Id 1184385',32480.00,0.00,0.00,56.00,1008.00,'2022-04-20 13:37:46','',''),(2617748,'1','187','939',418,'Retail Sale Id 1184386',82360.00,0.00,0.00,142.00,2556.00,'2022-04-20 13:40:23','',''),(2617749,'1','187','939',418,'Retail Sale Id 1184387',29000.00,0.00,0.00,50.00,900.00,'2022-04-20 13:43:26','',''),(2617750,'1','187','939',418,'Retail Sale Id 1184388',29000.00,0.00,0.00,50.00,900.00,'2022-04-20 13:49:17','',''),(2617751,'1','187','939',418,'Retail Sale Id 1184389',4000.00,0.00,0.00,6.25,487.50,'2022-04-20 13:57:41','',''),(2617752,'1','187','939',418,'Retail Sale Id 1184390',4000.00,0.00,0.00,6.25,487.50,'2022-04-20 13:58:09','',''),(2617753,'1','187','939',418,'Retail Sale Id 1184391',6400.00,0.00,0.00,10.00,780.00,'2022-04-20 13:58:51','',''),(2617754,'1','187','939',418,'Retail Sale Id 1184392',4998.40,0.00,0.00,7.81,609.18,'2022-04-20 13:59:51','',''),(2617755,'1','187','939',418,'Retail Sale Id 1184393',8000.00,0.00,0.00,12.50,975.00,'2022-04-20 17:02:12','',''),(2617756,'1','187','939',418,'Retail Sale Id 1184394',116000.00,0.00,0.00,200.00,3600.00,'2022-04-20 17:18:17','',''),(2617757,'1','187','939',418,'Retail Sale Id 1184395',116000.00,0.00,0.00,200.00,3600.00,'2022-04-20 17:20:24','',''),(2617758,'1','187','939',418,'Retail Sale Id 1184396',91640.00,0.00,0.00,158.00,2844.00,'2022-04-20 17:21:25','',''),(2617759,'1','187','939',418,'Retail Sale Id 1184397',8000.00,0.00,0.00,12.50,975.00,'2022-04-20 17:23:11','',''),(2617760,'1','187','939',418,'Retail Sale Id 1184398',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 17:23:36','',''),(2617761,'1','187','939',418,'Retail Sale Id 1184399',3001.60,0.00,0.00,4.69,365.82,'2022-04-20 17:24:01','',''),(2617762,'1','187','939',418,'Retail Sale Id 1184400',2502.40,0.00,0.00,3.91,304.98,'2022-04-20 17:26:31','',''),(2617763,'1','187','939',418,'Retail Sale Id 1184401',1702.40,0.00,0.00,2.66,207.48,'2022-04-20 17:27:02','',''),(2617764,'1','187','939',418,'Retail Sale Id 1184402',1920.00,0.00,0.00,3.00,234.00,'2022-04-20 17:27:31','',''),(2617765,'1','187','939',418,'Retail Sale Id 1184403',2502.40,0.00,0.00,3.91,304.98,'2022-04-20 17:27:58','',''),(2617766,'1','187','939',418,'Retail Sale Id 1184404',8000.00,0.00,0.00,12.50,975.00,'2022-04-20 17:29:24','',''),(2617767,'1','187','939',418,'Retail Sale Id 1184405',6400.00,0.00,0.00,10.00,780.00,'2022-04-20 17:29:54','',''),(2617768,'1','187','939',418,'Retail Sale Id 1184406',9600.00,0.00,0.00,15.00,1170.00,'2022-04-20 17:30:19','',''),(2617769,'1','187','939',418,'Retail Sale Id 1184407',4480.00,0.00,0.00,7.00,546.00,'2022-04-20 17:30:49','',''),(2617770,'1','187','939',418,'Retail Sale Id 1184408',4998.40,0.00,0.00,7.81,609.18,'2022-04-20 17:31:16','',''),(2617771,'1','187','939',418,'Retail Sale Id 1184409',1280.00,0.00,0.00,2.00,156.00,'2022-04-20 17:31:46','',''),(2617772,'1','187','939',418,'Retail Sale Id 1184410',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 17:32:13','',''),(2617773,'1','187','939',418,'Retail Sale Id 1184411',2560.00,0.00,0.00,4.00,312.00,'2022-04-20 17:32:38','',''),(2617774,'1','187','939',418,'Retail Sale Id 1184412',2240.00,0.00,0.00,3.50,273.00,'2022-04-20 17:33:06','',''),(2617775,'1','187','939',418,'Retail Sale Id 1184413',2502.40,0.00,0.00,3.91,304.98,'2022-04-20 17:43:18','',''),(2617776,'1','187','939',418,'Retail Sale Id 1184414',3500.80,0.00,0.00,5.47,426.66,'2022-04-20 17:43:51','',''),(2617777,'1','187','939',418,'Retail Sale Id 1184415',3200.00,0.00,0.00,5.00,390.00,'2022-04-20 17:44:20','',''),(2617778,'1','187','939',418,'Retail Sale Id 1184416',640.00,0.00,0.00,1.00,78.00,'2022-04-20 17:44:47','',''),(2617779,'1','187','939',418,'Retail Sale Id 1184417',8320.00,0.00,0.00,13.00,1014.00,'2022-04-20 17:45:16','',''),(2617780,'1','187','939',418,'Retail Sale Id 1184418',3200.00,0.00,0.00,5.00,390.00,'2022-04-20 17:45:46','',''),(2617781,'1','187','939',418,'Retail Sale Id 1184419',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 17:46:14','',''),(2617782,'1','187','939',418,'Retail Sale Id 1184420',2560.00,0.00,0.00,4.00,312.00,'2022-04-20 17:46:48','',''),(2617783,'1','187','939',418,'Retail Sale Id 1184421',1497.60,0.00,0.00,2.34,182.52,'2022-04-20 17:47:19','',''),(2617784,'1','187','939',418,'Retail Sale Id 1184422',5120.00,0.00,0.00,8.00,624.00,'2022-04-20 17:47:48','',''),(2617785,'1','187','939',418,'Retail Sale Id 1184423',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 17:49:01','',''),(2617786,'1','187','939',418,'Retail Sale Id 1184424',3200.00,0.00,0.00,5.00,390.00,'2022-04-20 17:49:29','',''),(2617787,'1','187','939',418,'Retail Sale Id 1184426',2003.20,0.00,0.00,3.13,244.14,'2022-04-20 17:50:45','',''),(2617788,'1','187','939',418,'Retail Sale Id 1184427',6400.00,0.00,0.00,10.00,780.00,'2022-04-20 17:51:55','',''),(2617789,'1','187','939',418,'Retail Sale Id 1184428',3200.00,0.00,0.00,5.00,390.00,'2022-04-20 17:52:19','',''),(2617790,'1','187','939',418,'Retail Sale Id 1184429',2003.20,0.00,0.00,3.13,244.14,'2022-04-20 17:52:50','',''),(2617791,'1','187','939',418,'Retail Sale Id 1184430',1798.40,0.00,0.00,2.81,219.18,'2022-04-20 17:53:17','',''),(2617792,'1','187','939',418,'Retail Sale Id 1184431',3840.00,0.00,0.00,6.00,468.00,'2022-04-20 17:53:42','',''),(2617793,'1','187','939',418,'Retail Sale Id 1184432',3520.00,0.00,0.00,5.50,429.00,'2022-04-20 17:54:12','',''),(2617794,'1','187','939',418,'Retail Sale Id 1184433',1920.00,0.00,0.00,3.00,234.00,'2022-04-20 17:54:35','',''),(2617795,'1','187','939',418,'Retail Sale Id 1184434',1600.00,0.00,0.00,2.50,195.00,'2022-04-20 17:55:08','',''),(2617796,'1','187','939',418,'Retail Sale Id 1184435',4160.00,0.00,0.00,6.50,507.00,'2022-04-20 17:56:01','',''),(2617797,'1','187','939',418,'Retail Sale Id 1184436',2560.00,0.00,0.00,4.00,312.00,'2022-04-20 17:56:40','',''),(2617798,'1','187','939',418,'Retail Sale Id 1184437',3398.40,0.00,0.00,5.31,414.18,'2022-04-20 17:57:18','',''),(2617799,'1','187','939',418,'Retail Sale Id 1184438',136300.00,0.00,0.00,235.00,4230.00,'2022-04-20 18:03:47','',''),(2617800,'1','187','939',418,'Retail Sale Id 1184439',203000.00,0.00,0.00,350.00,6300.00,'2022-04-20 18:06:35','',''),(2617801,'1','187','939',418,'Retail Sale Id 1184440',2713.60,0.00,0.00,4.24,330.72,'2022-04-20 18:16:44','',''),(2617802,'1','187','939',418,'Retail Sale Id 1184441',3840.00,0.00,0.00,6.00,468.00,'2022-04-21 07:43:52','',''),(2617803,'1','187','939',418,'Retail Sale Id 1184442',58000.00,0.00,0.00,100.00,1800.00,'2022-04-21 07:45:23','',''),(2617804,'1','187','939',418,'Retail Sale Id 1184443',58000.00,0.00,0.00,100.00,1800.00,'2022-04-21 07:47:08','',''),(2617805,'1','187','939',418,'Retail Sale Id 1184444',29000.00,0.00,0.00,50.00,900.00,'2022-04-21 07:49:21','',''),(2617806,'1','187','939',418,'Retail Sale Id 1184445',87000.00,0.00,0.00,150.00,2700.00,'2022-04-21 09:56:20','',''),(2617807,'1','187','939',418,'Retail Sale Id 1184446',8000.00,0.00,0.00,12.50,975.00,'2022-04-21 09:57:31','',''),(2617808,'1','187','939',418,'Retail Sale Id 1184447',3840.00,0.00,0.00,6.00,468.00,'2022-04-21 09:58:16','',''),(2617809,'1','187','939',418,'Retail Sale Id 1184448',1920.00,0.00,0.00,3.00,234.00,'2022-04-21 10:03:00','',''),(2617810,'1','187','939',418,'Retail Sale Id 1184449',3001.60,0.00,0.00,4.69,365.82,'2022-04-21 10:03:40','',''),(2617811,'1','187','939',418,'Retail Sale Id 1184450',87000.00,0.00,0.00,150.00,2700.00,'2022-04-21 10:04:51','',''),(2617812,'1','187','939',418,'Retail Sale Id 1184451',3840.00,0.00,0.00,6.00,468.00,'2022-04-21 13:07:38','',''),(2617813,'1','187','939',418,'Retail Sale Id 1184452',3001.60,0.00,0.00,4.69,365.82,'2022-04-21 13:08:09','',''),(2617814,'1','187','939',418,'Retail Sale Id 1184453',8000.00,0.00,0.00,12.50,975.00,'2022-04-21 13:08:48','',''),(2617815,'1','187','939',418,'Retail Sale Id 1184454',2560.00,0.00,0.00,4.00,312.00,'2022-04-21 13:09:22','',''),(2617816,'1','187','939',418,'Retail Sale Id 1184455',6400.00,0.00,0.00,10.00,780.00,'2022-04-21 13:10:01','',''),(2617817,'1','187','939',418,'Retail Sale Id 1184456',9600.00,0.00,0.00,15.00,1170.00,'2022-04-21 13:13:08','',''),(2617818,'1','187','939',418,'Retail Sale Id 1184457',9600.00,0.00,0.00,15.00,1170.00,'2022-04-21 13:13:36','',''),(2617819,'1','187','939',418,'Retail Sale Id 1184458',78880.00,0.00,0.00,136.00,2448.00,'2022-04-21 13:16:52','',''),(2617820,'1','187','939',418,'Retail Sale Id 1184459',58000.00,0.00,0.00,100.00,1800.00,'2022-04-21 13:17:34','',''),(2617821,'1','187','939',418,'Retail Sale Id 1184460',87000.00,0.00,0.00,150.00,2700.00,'2022-04-21 13:19:37','',''),(2617822,'1','187','939',418,'Retail Sale Id 1184461',116000.00,0.00,0.00,200.00,3600.00,'2022-04-21 13:20:31','',''),(2617823,'1','187','939',418,'Retail Sale Id 1184462',89900.00,0.00,0.00,155.00,2790.00,'2022-04-21 13:22:15','',''),(2617824,'1','187','939',418,'Retail Sale Id 1184463',525155.20,0.00,0.00,905.44,16297.92,'2022-04-21 16:51:33','',''),(2617825,'1','187','939',418,'Retail Sale Id 1184464',167040.00,0.00,0.00,288.00,5184.00,'2022-04-21 16:52:21','',''),(2617826,'1','187','939',418,'Retail Sale Id 1184465',241088.60,0.00,0.00,415.67,7482.06,'2022-04-21 16:53:17','',''),(2617827,'1','187','939',418,'Retail Sale Id 1184466',91553.00,0.00,0.00,157.85,2841.30,'2022-04-21 16:54:06','',''),(2617828,'1','187','939',418,'Retail Sale Id 1184467',116000.00,0.00,0.00,200.00,3600.00,'2022-04-21 16:54:56','',''),(2617829,'1','187','939',418,'Retail Sale Id 1184468',3840.00,0.00,0.00,6.00,468.00,'2022-04-21 16:56:38','',''),(2617830,'1','187','939',418,'Retail Sale Id 1184469',8000.00,0.00,0.00,12.50,975.00,'2022-04-21 16:57:18','',''),(2617831,'1','187','939',418,'Retail Sale Id 1184470',6400.00,0.00,0.00,10.00,780.00,'2022-04-21 16:57:52','',''),(2617832,'1','187','939',418,'Retail Sale Id 1184471',3001.60,0.00,0.00,4.69,365.82,'2022-04-21 16:58:33','',''),(2617833,'1','187','939',418,'Retail Sale Id 1184472',1798.40,0.00,0.00,2.81,219.18,'2022-04-21 16:59:07','',''),(2617834,'1','187','939',418,'Retail Sale Id 1184473',2502.40,0.00,0.00,3.91,304.98,'2022-04-21 16:59:40','',''),(2617835,'1','187','939',418,'Retail Sale Id 1184474',3200.00,0.00,0.00,5.00,390.00,'2022-04-21 17:00:06','',''),(2617836,'1','187','939',418,'Retail Sale Id 1184475',4480.00,0.00,0.00,7.00,546.00,'2022-04-21 17:00:35','',''),(2617837,'1','187','939',418,'Retail Sale Id 1184476',998.40,0.00,0.00,1.56,121.68,'2022-04-21 17:01:06','',''),(2617838,'1','187','939',418,'Retail Sale Id 1184477',3840.00,0.00,0.00,6.00,468.00,'2022-04-21 17:01:43','',''),(2617839,'1','187','939',