-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_186
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_186`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_186` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_186`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3407 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3396,400121,'',0,'22','1','186','PURCHASES','','2021-06-16 09:56:24',5,0.00,0.00,'','479','2021-06-16 09:56:24','479',0,1),(3397,20053,'',0,'20','1','186','SALES','','2021-06-16 09:56:45',5,0.00,0.00,'','479','2021-06-16 09:56:45','479',0,1),(3398,40053,'',0,'6.1','1','186','CASH','','2021-06-16 09:57:24',5,0.00,0.00,'','479','2021-06-16 09:57:24','479',0,1),(3399,400322,'',0,'24','1','186','SALARIES & WAGES','','2021-06-16 10:13:23',5,0.00,0.00,'','479','2021-06-16 10:13:23','479',0,1),(3400,400323,'',0,'24','1','186','PURCHASES','','2021-06-16 10:13:44',5,0.00,0.00,'','479','2021-06-16 10:13:44','479',0,1),(3402,400604,'',0,'2','1','186','DANKANO-EBILLS(ZNB:1014717618)','','2021-06-16 10:19:54',5,0.00,0.00,'','479','2021-06-16 10:19:54','479',0,1),(3403,400605,'',0,'2','1','186','FID POS COLLECTION-5620141491','','2021-06-16 10:20:36',5,0.00,0.00,'','479','2021-06-16 10:20:36','479',0,1),(3404,400606,'',0,'2','1','186','ZNB POS COLLECTION ACCT:-10159','ZNB POS COLLECTION ACCT:-1015965368','2022-10-07 16:37:24',5,0.00,0.00,'','792','2022-10-07 16:37:24','792',0,0),(3405,400607,'',0,'2','1','186','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:43:24',5,0.00,0.00,'','792','2023-02-20 14:43:24','792',0,0),(3406,400608,'',0,'2','1','186','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:46:28',5,0.00,0.00,'2023-03-15','792','2023-03-17 14:03:03','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2993 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2787,'','1','186','MUSA YAU SHAIBU','0000','08104018534','@','OSOGBO','OSOGBO','OSOGBOLPG','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-21 08:06:48',5,'636','2021-06-21 08:06:48','636'),(2834,'','1','186','AARANO','0000','08138282428','sulson111@gmail.com','OSOGBO','OSOGBO','AARANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-25 10:47:58',5,'636','2022-05-28 21:06:48','882'),(2835,'','1','186','Achiever Gas ','Offa Kwara','00000000','ranocustomer@gmail.com ','Offa','Kwara','Offa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 08:55:44',5,'882','2022-11-22 08:55:44','882'),(2836,'','1','186','Halleuyah','Offa Kwara','00000000','ranocustomer@gmail.com ','Offa','Kwara','Offa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 08:56:39',5,'882','2022-11-22 08:56:39','882'),(2837,'','1','186','Ultimate Gas','Offa Kwara','00000000','ranocustomer@gmail.com ','Offa','Kwara','Offa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 08:57:14',5,'882','2022-11-22 08:57:14','882'),(2838,'','1','186','J.K Gas','Okebale','00000000','ranocustomer@gmail.com ','Osogbo ','Osun','Osogbo ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 08:58:11',5,'882','2022-11-22 08:58:11','882'),(2839,'','1','186','Baba Gas ','Osogbo ','00000000','ranocustomer@gmail.com ','Osogbo ','Osun','Osogbo ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 08:59:12',5,'882','2022-11-22 08:59:12','882'),(2840,'','1','186','Nobble Gas ','Offa Kwara','00000000','ranocustomer@gmail.com ','Offa','Kwara','Offa','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:02:51',5,'882','2022-11-22 09:02:51','882'),(2841,'','1','186','ROYAL GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:42:15',5,'882','2022-11-22 09:42:15','882'),(2842,'','1','186','K1 GAS','KWARA','00000000','customer@rano.com','KWARA','KWARA','KWARA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:43:01',5,'882','2022-11-22 09:43:01','882'),(2843,'','1','186','ADEOLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','IKIRUN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:43:43',5,'882','2022-11-22 09:43:43','882'),(2844,'','1','186','LIGHT GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:44:12',5,'882','2022-11-22 09:44:12','882'),(2845,'','1','186','CHARLES GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:45:42',5,'882','2022-11-22 09:45:42','882'),(2846,'','1','186','ADEBAYO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:46:19',5,'882','2022-11-22 09:46:19','882'),(2847,'','1','186','MULAIZ GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','GBAGAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:47:08',5,'882','2022-11-22 09:47:08','882'),(2848,'','1','186','AWOO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','ILESHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:50:50',5,'882','2022-11-22 09:50:50','882'),(2849,'','1','186','BOWAS GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','ILA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:51:52',5,'882','2022-11-22 09:51:52','882'),(2850,'','1','186','DEJI GBAGAN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','GBANGAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:52:24',5,'882','2022-11-22 09:52:24','882'),(2851,'','1','186','PRISM GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 09:52:59',5,'882','2022-11-22 09:52:59','882'),(2852,'','1','186','AFRICA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:01:37',5,'882','2022-11-22 10:01:37','882'),(2853,'','1','186','ABDULGAFAR GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:02:09',5,'882','2022-11-22 10:02:09','882'),(2854,'','1','186','BABANLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:04:32',5,'882','2022-11-22 10:04:32','882'),(2855,'','1','186','EJERE  GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:05:45',5,'882','2022-11-22 10:05:45','882'),(2856,'','1','186','ADEBAUO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:09:10',5,'882','2022-11-22 10:09:10','882'),(2857,'','1','186','BELLO BEST GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','ILESHA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:09:44',5,'882','2022-11-22 10:09:44','882'),(2858,'','1','186','EDDY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','ILA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:10:14',5,'882','2022-11-22 10:10:14','882'),(2859,'','1','186','ADEYEMI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 10:11:44',5,'882','2022-11-22 10:11:44','882'),(2860,'','1','186','BULKY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:17:33',5,'882','2022-11-22 11:17:33','882'),(2861,'','1','186','WAHID GAS ','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:18:13',5,'882','2022-11-22 11:18:13','882'),(2862,'','1','186','SHERIF GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:18:47',5,'882','2022-11-22 11:18:47','882'),(2863,'','1','186','FEMI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:19:28',5,'882','2022-11-22 11:19:28','882'),(2864,'','1','186','F. M GAS AND ACCESSORIES','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','IFE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:20:16',5,'882','2022-11-22 11:20:16','882'),(2865,'','1','186','EJIGBON GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','EJIGBAN','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:21:08',5,'882','2022-11-22 11:21:08','882'),(2866,'','1','186','IKEDE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','IKEDE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:21:43',5,'882','2022-11-22 11:21:43','882'),(2867,'','1','186','JIBOLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:22:11',5,'882','2022-11-22 11:22:11','882'),(2868,'','1','186','ILESHA ADE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:22:38',5,'882','2022-11-22 11:22:38','882'),(2869,'','1','186','MEGASTAR GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:23:20',5,'882','2022-11-22 11:23:20','882'),(2870,'','1','186','OLA BEST GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OFFA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:23:49',5,'882','2022-11-22 11:23:49','882'),(2871,'','1','186','RAJI GAS','OSOGBO','00000000','customer@rano.com','EDE','OSUN','EKITI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:24:51',5,'882','2022-11-22 11:24:51','882'),(2872,'','1','186','P MAN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:25:36',5,'882','2022-11-22 11:25:36','882'),(2873,'','1','186','OLUWA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:25:56',5,'882','2022-11-22 11:25:56','882'),(2874,'','1','186','OLOMODA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:26:37',5,'882','2022-11-22 11:26:37','882'),(2875,'','1','186','BALOGUN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:27:49',5,'882','2022-11-22 11:27:49','882'),(2876,'','1','186','ADE GLOBAL GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:28:35',5,'882','2022-11-22 11:28:35','882'),(2877,'','1','186','TUNDE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:29:14',5,'882','2022-11-22 11:29:14','882'),(2878,'','1','186','IBOLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:29:49',5,'882','2022-11-22 11:29:49','882'),(2879,'','1','186','OTUNMBA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:30:21',5,'882','2022-11-22 11:30:21','882'),(2880,'','1','186','EMBASSEY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','EDE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:31:01',5,'882','2022-11-22 11:31:01','882'),(2881,'','1','186','AJEGBE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:31:32',5,'882','2022-11-22 11:31:32','882'),(2882,'','1','186','AWOO KORKPE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:32:12',5,'882','2022-11-22 11:32:12','882'),(2883,'','1','186','EKITI LOLA GAS','OSOGBO','00000000','customer@rano.com','EKITI','EKITI','EKITI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:32:56',5,'882','2022-11-22 11:32:56','882'),(2884,'','1','186','JAMALLULAH GAS','OFFA','00000000','customer@rano.com','OSOGBO','OSUN','OFFA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:33:33',5,'882','2022-11-22 11:33:33','882'),(2885,'','1','186','GAS AND MORE','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:34:24',5,'882','2022-11-22 11:34:24','882'),(2886,'','1','186','GRACE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:34:52',5,'882','2022-11-22 11:34:52','882'),(2887,'','1','186','MUMMY ABBAS GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:35:22',5,'882','2022-11-22 11:35:22','882'),(2888,'','1','186','HAZZAN PANA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:35:58',5,'882','2022-11-22 11:35:58','882'),(2889,'','1','186','KAZZEEM GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','AYETORO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:37:50',5,'882','2022-11-22 11:37:50','882'),(2890,'','1','186','LARRY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:38:16',5,'882','2022-11-22 11:38:16','882'),(2891,'','1','186','MRS OKUN OLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:38:52',5,'882','2022-11-22 11:38:52','882'),(2892,'','1','186','OMO ALAJA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OFFA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:39:35',5,'882','2022-11-22 11:39:35','882'),(2893,'','1','186','TAYOLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:40:14',5,'882','2022-11-22 11:40:14','882'),(2894,'','1','186','UNITY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:40:59',5,'882','2022-11-22 11:40:59','882'),(2895,'','1','186','DEVINE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:41:39',5,'882','2022-11-22 11:41:39','882'),(2896,'','1','186','AFRO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:42:12',5,'882','2022-11-22 11:42:12','882'),(2897,'','1','186','I.B GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OLA IYA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:42:47',5,'882','2022-11-22 11:42:47','882'),(2898,'','1','186','T.K GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:43:39',5,'882','2022-11-22 11:43:39','882'),(2899,'','1','186','AYODETEMI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:44:18',5,'882','2022-11-22 11:44:18','882'),(2900,'','1','186','OLUSIKKAMI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:44:44',5,'882','2022-11-22 11:44:44','882'),(2901,'','1','186','ALIWUYI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:45:13',5,'882','2022-11-22 11:45:13','882'),(2902,'','1','186','OLASUKEMI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:46:11',5,'882','2022-11-22 11:46:11','882'),(2903,'','1','186','MUYIDEEN GAS','OFFA','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:46:53',5,'882','2022-11-22 11:46:53','882'),(2904,'','1','186','MALAIKA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:47:21',5,'882','2022-11-22 11:47:21','882'),(2905,'','1','186','AR RAHMAN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OKEFIA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:48:45',5,'882','2022-11-22 11:48:45','882'),(2906,'','1','186','OLASUEN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:49:07',5,'882','2022-11-22 11:49:07','882'),(2907,'','1','186','SENDAF GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:49:32',5,'882','2022-11-22 11:49:32','882'),(2908,'','1','186','ADEGBOYEGA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:50:03',5,'882','2022-11-22 11:50:03','882'),(2909,'','1','186','OLULE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:50:28',5,'882','2022-11-22 11:50:28','882'),(2910,'','1','186','RAZMAX GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:50:53',5,'882','2022-11-22 11:50:53','882'),(2911,'','1','186','OMOOBA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:51:20',5,'882','2022-11-22 11:51:20','882'),(2912,'','1','186','GBAGAN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:51:44',5,'882','2022-11-22 11:51:44','882'),(2913,'','1','186','LATEEFULAH GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:52:12',5,'882','2022-11-22 11:52:12','882'),(2914,'','1','186','GBOLOLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:52:41',5,'882','2022-11-22 11:52:41','882'),(2915,'','1','186','TIMININU GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:53:04',5,'882','2022-11-22 11:53:04','882'),(2916,'','1','186','IMOLE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:53:33',5,'882','2022-11-22 11:53:33','882'),(2917,'','1','186','BOKULA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:54:18',5,'882','2022-11-22 11:54:18','882'),(2918,'','1','186','SUSAN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 11:55:23',5,'882','2022-11-22 11:55:23','882'),(2919,'','1','186','ADESHEF GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:39:07',5,'882','2022-11-22 13:39:07','882'),(2920,'','1','186','ADELIS GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:48:21',5,'882','2022-11-22 13:48:21','882'),(2921,'','1','186','ADEGAFAR GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:48:51',5,'882','2022-11-22 13:48:51','882'),(2922,'','1','186','NEAT GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:51:11',5,'882','2022-11-22 13:51:11','882'),(2923,'','1','186','NURUDDEN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:51:38',5,'882','2022-11-22 13:51:38','882'),(2924,'','1','186','ADESHINA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:55:42',5,'882','2022-11-22 13:55:42','882'),(2925,'','1','186','PASTOR GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:56:20',5,'882','2022-11-22 13:56:20','882'),(2926,'','1','186','ULOMA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:56:48',5,'882','2022-11-22 13:56:48','882'),(2927,'','1','186','ALAYO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:57:16',5,'882','2022-11-22 13:57:16','882'),(2928,'','1','186','Y C IFE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:58:41',5,'882','2022-11-22 13:58:41','882'),(2929,'','1','186','BUKART GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:59:06',5,'882','2022-11-22 13:59:06','882'),(2930,'','1','186','ROTIMI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:59:28',5,'882','2022-11-22 13:59:28','882'),(2931,'','1','186','ADELIXA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 13:59:56',5,'882','2022-11-22 13:59:56','882'),(2932,'','1','186','AMOS DELE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:00:24',5,'882','2022-11-22 14:00:24','882'),(2933,'','1','186','ALL FOR GOD GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:00:49',5,'882','2022-11-22 14:00:49','882'),(2934,'','1','186','BABS GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:01:10',5,'882','2022-11-22 14:01:10','882'),(2935,'','1','186','IYANU GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:01:33',5,'882','2022-11-22 14:01:33','882'),(2936,'','1','186','KORED GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:01:52',5,'882','2022-11-22 14:01:52','882'),(2937,'','1','186','AROMA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:02:15',5,'882','2022-11-22 14:02:15','882'),(2938,'','1','186','ALEXANDRA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:02:43',5,'882','2022-11-22 14:02:43','882'),(2939,'','1','186','MIDELE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:03:08',5,'882','2022-11-22 14:03:08','882'),(2940,'','1','186','RIDWANU GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:03:36',5,'882','2022-11-22 14:03:36','882'),(2941,'','1','186','IKEOLUWA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:04:02',5,'882','2022-11-22 14:04:02','882'),(2942,'','1','186','I V D GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:04:24',5,'882','2022-11-22 14:04:24','882'),(2943,'','1','186','ILEGBON GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:05:12',5,'882','2022-11-22 14:05:12','882'),(2944,'','1','186','ASEPANO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:05:37',5,'882','2022-11-22 14:05:37','882'),(2945,'','1','186','MANNY GAS ','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:06:03',5,'882','2022-11-22 14:06:03','882'),(2946,'','1','186','GOMERT GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:06:32',5,'882','2022-11-22 14:06:32','882'),(2947,'','1','186','FIST GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:06:55',5,'882','2022-11-22 14:06:55','882'),(2948,'','1','186','MIGHTY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:07:20',5,'882','2022-11-22 14:07:20','882'),(2949,'','1','186','MADAN CIVIL DEFENCE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:07:55',5,'882','2022-11-22 14:07:55','882'),(2950,'','1','186','SAKANMA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:08:53',5,'882','2022-11-22 14:08:53','882'),(2951,'','1','186','OPE 11 GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:09:17',5,'882','2022-11-22 14:09:17','882'),(2952,'','1','186','HIS GRACE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:09:37',5,'882','2022-11-22 14:09:37','882'),(2953,'','1','186','YELLOW GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:10:05',5,'882','2022-11-22 14:10:05','882'),(2954,'','1','186','A Y GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:10:35',5,'882','2022-11-22 14:10:35','882'),(2955,'','1','186','IBUKUN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:10:57',5,'882','2022-11-22 14:10:57','882'),(2956,'','1','186','MUTIYI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:11:22',5,'882','2022-11-22 14:11:22','882'),(2957,'','1','186','SALAM SALAM','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:11:49',5,'882','2022-11-22 14:11:49','882'),(2958,'','1','186','ALNOOR GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','EDE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:12:17',5,'882','2022-11-22 14:12:17','882'),(2959,'','1','186','ALBARIKA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:12:46',5,'882','2022-11-22 14:12:46','882'),(2960,'','1','186','ADEWEX GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:14:06',5,'882','2022-11-22 14:14:06','882'),(2961,'','1','186','OLAJESU ILA ','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:14:37',5,'882','2022-11-22 14:14:37','882'),(2962,'','1','186','GEE SUCCESS GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:15:04',5,'882','2022-11-22 14:15:04','882'),(2963,'','1','186','ROVIC GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:15:23',5,'882','2022-11-22 14:15:23','882'),(2964,'','1','186','TUNJI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:15:51',5,'882','2022-11-22 14:15:51','882'),(2965,'','1','186','LARA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:16:22',5,'882','2022-11-22 14:16:22','882'),(2966,'','1','186','TOBI GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:16:44',5,'882','2022-11-22 14:16:44','882'),(2967,'','1','186','IJEOBA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:17:08',5,'882','2022-11-22 14:17:08','882'),(2968,'','1','186','OJA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:17:33',5,'882','2022-11-22 14:17:33','882'),(2969,'','1','186','KUNLE LIGHT GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:17:58',5,'882','2022-11-22 14:17:58','882'),(2970,'','1','186','BEN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:18:22',5,'882','2022-11-22 14:18:22','882'),(2971,'','1','186','JAMIU GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:18:45',5,'882','2022-11-22 14:18:45','882'),(2972,'','1','186','OLA ILA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:19:11',5,'882','2022-11-22 14:19:11','882'),(2973,'','1','186','VICTOR SUN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:19:52',5,'882','2022-11-22 14:19:52','882'),(2974,'','1','186','ZEBRA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:20:14',5,'882','2022-11-22 14:20:14','882'),(2975,'','1','186','KOLALULE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:20:52',5,'882','2022-11-22 14:20:52','882'),(2976,'','1','186','YETUNDE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:21:16',5,'882','2022-11-22 14:21:16','882'),(2977,'','1','186','JESUS LORD GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:21:46',5,'882','2022-11-22 14:21:46','882'),(2978,'','1','186','AMAZING GRACE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:22:17',5,'882','2022-11-22 14:22:17','882'),(2979,'','1','186','DELE OWO GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:22:49',5,'882','2022-11-22 14:22:49','882'),(2980,'','1','186','GRACIOUS GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:23:14',5,'882','2022-11-22 14:23:14','882'),(2981,'','1','186','YEMI','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:23:39',5,'882','2022-11-22 14:23:39','882'),(2982,'','1','186','OKUKUN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:24:01',5,'882','2022-11-22 14:24:01','882'),(2983,'','1','186','ILESHA GAS ','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:24:30',5,'882','2022-11-22 14:24:30','882'),(2984,'','1','186','KIRUN GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:24:55',5,'882','2022-11-22 14:24:55','882'),(2985,'','1','186','IYA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:25:08',5,'882','2022-11-22 14:25:08','882'),(2986,'','1','186','AWOFE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:25:43',5,'882','2022-11-22 14:25:43','882'),(2987,'','1','186','SHOLA GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:26:06',5,'882','2022-11-22 14:26:06','882'),(2988,'','1','186','GAMBLE ALL GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:26:36',5,'882','2022-11-22 14:26:36','882'),(2989,'','1','186','MERCY GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:26:58',5,'882','2022-11-22 14:26:58','882'),(2990,'','1','186','JOYABLE GAS','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:28:25',5,'882','2022-11-22 14:28:25','882'),(2991,'','1','186','SAMUEL IKIRUN','OSOGBO','00000000','customer@rano.com','OSOGBO','OSUN','OSOGBO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-22 14:28:57',5,'882','2022-11-22 14:28:57','882'),(2992,'','1','186','GRACE BULK GAS','BABA GRACE GAS','0000000000','@gmail','OSOGBO','OSUN','OSOGBO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-10 20:19:21',5,'882','2023-02-10 20:19:21','882');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16640 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','186',16375,'940',2586.23,1.00,'2021-09-09','new','2021-09-09 08:57:22','483','483',2021,'483','2021-09-09 08:57:22',5),('1','186',16639,'940',3528.02,3347.00,'2021-09-28','new dipping','2021-09-28 09:35:24','483','483',2021,'483','2021-09-28 09:35:24',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2762 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','186','940',2761,'5','LPG NOZZLE',4794767.09,'LPG DISPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258136 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','186',205278,'DAY SHIP','2021-06-21','2021-06-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-22 10:46:25','636','2021-06-22 10:46:55',10,0),('1','186',205562,'DAY SHIP','2021-06-22','2021-06-22 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-23 12:11:21','636','2021-06-23 12:12:09',10,0),('1','186',205968,'DAY SHIP','2021-06-23','2021-06-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-24 07:44:08','636','2021-06-24 07:45:46',10,0),('1','186',206045,'DAY SHIP','2021-06-24','2021-06-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-25 10:38:46','636','2021-06-25 10:39:11',10,0),('1','186',206248,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-26 09:40:36','636','2021-06-26 09:41:23',10,0),('1','186',206423,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-26 10:46:41','636','2021-06-26 10:47:17',10,0),('1','186',206458,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-27 07:39:41','636','2021-06-27 07:40:10',10,0),('1','186',206592,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-27 20:26:05','636','2021-06-27 20:26:26',10,0),('1','186',206824,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-28 16:56:35','636','2021-06-28 16:56:52',10,0),('1','186',206988,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-06-30 06:55:21','636','2021-06-30 06:55:37',10,0),('1','186',207263,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-01 19:36:58','636','2021-07-01 19:37:19',10,0),('1','186',207674,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-01 20:00:56','636','2021-07-01 20:01:20',10,0),('1','186',208006,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-03 12:23:04','636','2021-07-03 12:23:29',10,0),('1','186',208133,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-04 08:07:47','636','2021-07-04 08:08:53',10,0),('1','186',208406,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-05 09:22:34','636','2021-07-05 09:22:52',10,0),('1','186',208408,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-05 09:38:41','636','2021-07-05 09:39:25',10,0),('1','186',208567,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-06 12:51:35','636','2021-07-06 12:51:59',10,0),('1','186',208661,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-07 09:58:25','636','2021-07-07 09:58:57',10,0),('1','186',208847,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-08 09:47:06','636','2021-07-08 09:47:23',10,0),('1','186',209068,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-08 10:08:23','636','2021-07-08 10:09:26',10,0),('1','186',209193,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-10 20:01:23','636','2021-07-10 20:01:49',10,0),('1','186',209620,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-10 20:06:09','636','2021-07-10 20:06:28',10,0),('1','186',209835,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-11 19:36:00','636','2021-07-11 19:36:50',10,0),('1','186',209837,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-11 19:52:00','636','2021-07-11 19:52:16',10,0),('1','186',209838,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-12 08:33:43','636','2021-07-12 08:34:06',10,0),('1','186',210113,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-13 07:08:12','636','2021-07-13 07:09:01',10,0),('1','186',210369,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-14 09:10:33','636','2021-07-14 09:11:04',10,0),('1','186',210533,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-15 08:11:31','636','2021-07-15 08:11:54',10,0),('1','186',210540,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-15 08:21:03','636','2021-07-15 08:21:23',10,0),('1','186',210922,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-16 19:36:24','636','2021-07-16 19:38:20',10,0),('1','186',210924,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-16 20:02:06','636','2021-07-16 20:02:33',10,0),('1','186',211180,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-18 07:14:24','636','2021-07-18 07:14:42',10,0),('1','186',211184,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-18 07:25:05','636','2021-07-18 07:25:24',10,0),('1','186',211385,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-19 07:10:12','636','2021-07-19 07:10:56',10,0),('1','186',211477,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-20 12:08:30','636','2021-07-20 12:08:50',10,0),('1','186',211660,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-20 12:17:43','636','2021-07-20 12:18:04',10,0),('1','186',211662,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-22 08:54:30','636','2021-07-22 08:54:49',10,0),('1','186',212036,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-22 09:07:30','636','2021-07-22 09:07:53',10,0),('1','186',212047,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-23 11:58:35','636','2021-07-23 11:59:09',10,0),('1','186',212549,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-25 12:47:51','636','2021-07-25 12:48:10',10,0),('1','186',212759,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-26 19:59:30','636','2021-07-26 19:59:58',10,0),('1','186',213102,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-26 20:08:30','636','2021-07-26 20:09:05',10,0),('1','186',213430,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-28 08:29:39','636','2021-07-28 08:29:56',10,0),('1','186',213696,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-29 09:56:54','636','2021-07-29 09:57:32',10,0),('1','186',214060,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-31 11:39:31','636','2021-07-31 11:44:40',10,0),('1','186',214192,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-07-31 11:58:49','636','2021-07-31 11:59:53',10,0),('1','186',214334,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-01 06:31:23','636','2021-08-01 06:31:43',10,0),('1','186',214427,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-02 07:25:04','636','2021-08-02 07:25:31',10,0),('1','186',214647,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-03 09:12:48','636','2021-08-03 09:13:07',10,0),('1','186',214831,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-04 10:34:09','636','2021-08-04 10:34:26',10,0),('1','186',215082,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-04 10:40:03','636','2021-08-04 10:40:20',10,0),('1','186',215161,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-05 09:20:19','636','2021-08-05 09:20:53',10,0),('1','186',215556,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-06 11:53:01','636','2021-08-06 11:53:17',10,0),('1','186',215561,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-06 11:56:29','636','2021-08-06 11:56:50',10,0),('1','186',215718,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-07 09:19:39','636','2021-08-07 09:19:59',10,0),('1','186',215813,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-08 18:29:55','636','2021-08-08 18:30:10',10,0),('1','186',216124,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-09 11:47:17','636','2021-08-09 11:47:41',10,0),('1','186',216216,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-10 09:54:50','636','2021-08-10 09:55:12',10,0),('1','186',216685,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-12 19:52:54','636','2021-08-12 19:53:10',10,0),('1','186',216995,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-12 19:57:59','636','2021-08-12 19:58:23',10,0),('1','186',216996,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-13 08:33:19','636','2021-08-13 08:33:39',10,0),('1','186',217368,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-14 10:40:29','636','2021-08-14 10:40:50',10,0),('1','186',217673,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-15 20:17:12','636','2021-08-15 20:17:28',10,0),('1','186',217676,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-15 20:28:54','636','2021-08-15 20:29:11',10,0),('1','186',217748,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-16 08:05:37','636','2021-08-16 08:06:14',10,0),('1','186',218039,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-17 08:57:34','636','2021-08-17 08:57:51',10,0),('1','186',218276,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-18 09:00:42','636','2021-08-18 09:00:59',10,0),('1','186',218279,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-19 07:45:48','636','2021-08-19 07:46:10',10,0),('1','186',218481,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-19 08:06:24','636','2021-08-19 08:06:49',10,0),('1','186',218736,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-20 09:25:15','636','2021-08-20 09:25:44',10,0),('1','186',218945,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-21 09:15:32','636','2021-08-21 09:15:48',10,0),('1','186',219058,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-21 22:28:36','636','2021-08-21 22:28:57',10,0),('1','186',220568,'DAILY SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 12:35:22','636','2021-08-28 12:35:47',10,0),('1','186',220571,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 12:58:44','636','2021-08-28 12:59:13',10,0),('1','186',220581,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 13:09:13','636','2021-08-28 13:09:40',10,0),('1','186',220585,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 13:32:24','636','2021-08-28 13:32:43',10,0),('1','186',220597,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 13:45:16','636','2021-08-28 13:45:33',10,0),('1','186',220601,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 14:00:02','636','2021-08-28 14:00:25',10,0),('1','186',220606,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 14:10:37','636','2021-08-28 14:10:57',10,0),('1','186',220610,'DAILY SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-28 14:20:02','636','2021-08-28 14:20:29',10,0),('1','186',220763,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-29 11:52:10','636','2021-08-29 11:53:18',10,0),('1','186',221107,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-30 18:52:11','636','2021-08-30 18:53:59',10,0),('1','186',221110,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-08-30 18:58:47','636','2021-08-30 18:59:08',10,0),('1','186',221111,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-02 09:25:18','636','2021-09-02 09:25:44',10,0),('1','186',221683,'DELLY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-02 15:50:40','636','2021-09-02 15:51:09',10,0),('1','186',221828,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-03 09:22:52','636','2021-09-03 09:23:09',10,0),('1','186',222134,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-04 10:51:33','636','2021-09-04 10:51:51',10,0),('1','186',222345,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-05 10:43:20','636','2021-09-05 10:44:06',10,0),('1','186',222350,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-05 10:57:02','636','2021-09-05 10:57:21',10,0),('1','186',222574,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-06 11:33:51','636','2021-09-06 11:34:13',10,0),('1','186',222793,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-08 09:51:08','636','2021-09-08 09:51:27',10,0),('1','186',223010,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-08 09:59:44','636','2021-09-08 10:00:03',10,0),('1','186',223012,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-08 10:49:01','636','2021-09-08 10:49:20',10,0),('1','186',223194,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-09 07:23:51','636','2021-09-09 07:24:19',10,0),('1','186',223200,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-09 07:38:56','636','2021-09-09 07:39:15',10,0),('1','186',223228,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-10 11:54:03','636','2021-09-10 11:54:24',10,0),('1','186',223515,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-10 14:03:21','636','2021-09-10 14:03:37',10,0),('1','186',223543,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-10 14:13:01','636','2021-09-10 14:13:17',10,0),('1','186',224137,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-14 09:49:05','636','2021-09-14 09:49:54',10,0),('1','186',224386,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-14 14:01:38','636','2021-09-14 14:01:58',10,0),('1','186',224624,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-15 10:32:55','636','2021-09-15 10:34:53',10,0),('1','186',224629,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-15 12:57:19','636','2021-09-15 12:57:45',10,0),('1','186',224669,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-15 14:14:00','636','2021-09-15 14:17:19',10,0),('1','186',224698,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-16 06:45:33','636','2021-09-16 06:45:54',10,0),('1','186',224807,'Daily shift','2021-09-16','2021-09-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-16 21:20:41','636','2021-09-16 21:21:24',10,0),('1','186',224997,'Daily shift','2021-09-16','2021-09-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-17 14:06:56','636','2021-09-17 14:07:30',10,0),('1','186',225162,'Daily shift','2021-09-17','2021-09-17 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-18 10:03:31','636','2021-09-18 10:04:28',10,0),('1','186',225461,'Daily shift','2021-09-18','2021-09-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-19 10:13:52','636','2021-09-19 10:14:35',10,0),('1','186',225549,'Daily shift','2021-09-19','2021-09-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-19 21:02:01','636','2021-09-19 21:02:44',10,0),('1','186',225674,'Daily shift','2021-09-19','2021-09-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-19 21:21:12','636','2021-09-19 21:21:41',10,0),('1','186',225675,'Daily shift','2021-09-19','2021-09-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-20 07:33:32','636','2021-09-20 07:34:00',10,0),('1','186',225994,'Daily shift is','2021-09-20','2021-09-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-21 09:16:47','636','2021-09-21 09:17:19',10,0),('1','186',226042,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-21 10:17:18','636','2021-09-21 10:17:35',10,0),('1','186',226069,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-21 10:32:15','636','2021-09-21 10:33:19',10,0),('1','186',226275,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-23 09:12:02','636','2021-09-23 09:12:33',10,0),('1','186',226542,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-24 10:07:00','636','2021-09-24 10:07:57',10,0),('1','186',226931,'Daily shift','2021-09-24','2021-09-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-25 07:44:08','636','2021-09-25 07:44:37',10,0),('1','186',226985,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-25 08:06:28','636','2021-09-25 08:06:55',10,0),('1','186',226990,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-25 08:16:29','636','2021-09-25 08:17:18',10,0),('1','186',226996,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-26 07:14:25','636','2021-09-26 07:16:18',10,0),('1','186',227199,'Daily shift','2021-09-26','2021-09-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-28 09:46:58','636','2021-09-28 09:47:31',10,0),('1','186',227675,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-28 10:17:37','636','2021-09-28 10:18:10',10,0),('1','186',227682,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-28 10:23:09','636','2021-09-28 10:23:44',10,0),('1','186',227897,'Daily shifts','2021-09-28','2021-09-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-29 08:38:38','636','2021-09-29 08:39:44',10,0),('1','186',227907,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-29 19:11:05','636','2021-09-29 19:11:47',10,0),('1','186',228099,'Daily shifts','2021-09-29','2021-09-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-29 21:14:50','636','2021-09-29 21:15:16',10,0),('1','186',228101,'Daily shift','2021-09-29','2021-09-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-29 21:38:22','636','2021-09-29 21:38:54',10,0),('1','186',228117,'Daily shifts','2021-09-30','2021-09-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-09-30 21:30:55','636','2021-09-30 21:31:28',10,0),('1','186',228338,'Daily shifts','2021-10-01','2021-10-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-01 21:11:31','636','2021-10-01 21:12:00',10,0),('1','186',228548,'Daily shifts','2021-10-02','2021-10-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-02 21:56:28','636','2021-10-02 21:56:48',10,0),('1','186',228738,'Daily shift ','2021-10-02','2021-10-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-02 22:02:52','636','2021-10-02 22:03:17',10,0),('1','186',228801,'Daily shift ','2021-10-02','2021-10-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-03 11:28:55','636','2021-10-03 11:29:14',10,0),('1','186',228825,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-03 20:52:46','636','2021-10-03 20:53:41',10,0),('1','186',228945,'Daily shift ','2021-10-04','2021-10-04 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-04 21:31:21','636','2021-10-04 21:31:50',10,0),('1','186',229195,'Daily shift ','2021-10-05','2021-10-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-06 07:18:38','636','2021-10-06 07:19:09',10,0),('1','186',229434,'Daily shift ','2021-10-05','2021-10-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-06 10:05:23','636','2021-10-06 10:05:46',10,0),('1','186',229501,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-06 10:15:35','636','2021-10-06 10:15:51',10,0),('1','186',229507,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-07 10:27:48','636','2021-10-07 10:28:03',10,0),('1','186',229738,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-07 21:35:38','636','2021-10-07 21:36:09',10,0),('1','186',229870,'Daily shift ','2021-10-07','2021-10-07 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-07 21:42:08','636','2021-10-07 21:42:43',10,0),('1','186',229903,'Daily shift ','2021-10-08','2021-10-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-08 22:11:11','636','2021-10-08 22:11:41',10,0),('1','186',230073,'Daily shift ','2021-10-09','2021-10-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-09 20:16:20','636','2021-10-09 20:16:48',10,0),('1','186',230278,'Daily shift ','2021-10-10','2021-10-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-11 05:22:21','636','2021-10-11 05:22:53',10,0),('1','186',230516,'Daily shift ','2021-10-10','2021-10-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-11 05:39:56','636','2021-10-11 05:40:27',10,0),('1','186',230517,'Daily shift ','2021-10-11','2021-10-11 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-11 21:07:01','636','2021-10-11 21:07:38',10,0),('1','186',230768,'Daily shift','2021-10-12','2021-10-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-12 21:13:44','636','2021-10-12 21:14:20',10,0),('1','186',231126,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-13 09:38:02','636','2021-10-13 09:39:20',10,0),('1','186',231442,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-14 09:30:04','636','2021-10-14 09:30:56',10,0),('1','186',232074,'Daily shift','2021-10-16','2021-10-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-16 21:30:59','636','2021-10-16 21:31:33',10,0),('1','186',232131,'Daily shift','2021-10-17','2021-10-17 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-17 21:55:28','636','2021-10-17 21:55:54',10,0),('1','186',232372,'Daily shift ','2021-10-18','2021-10-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-18 21:58:08','636','2021-10-18 21:58:31',10,0),('1','186',232596,'Daily shift ','2021-10-19','2021-10-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-19 20:14:59','636','2021-10-19 20:15:25',10,0),('1','186',232863,'Daily shift','2021-10-20','2021-10-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-20 13:39:35','636','2021-10-20 13:39:53',10,0),('1','186',233009,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-20 21:37:05','636','2021-10-20 21:37:25',10,0),('1','186',233099,'Daily shift ','2021-10-21','2021-10-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-21 20:54:39','636','2021-10-21 20:54:57',10,0),('1','186',233587,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-23 14:58:06','636','2021-10-23 14:58:30',10,0),('1','186',233765,'Daily shift','2021-10-23','2021-10-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-23 21:45:23','636','2021-10-23 21:45:50',10,0),('1','186',233816,'Daily shift ','2021-10-23','2021-10-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-25 07:40:23','636','2021-10-25 07:40:46',10,0),('1','186',234098,'Daily shift ','2021-10-24','2021-10-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-25 08:16:20','636','2021-10-25 08:18:27',10,0),('1','186',234179,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-25 21:13:05','636','2021-10-25 21:13:30',10,0),('1','186',234311,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-27 06:42:43','636','2021-10-27 06:44:22',10,0),('1','186',234584,'Daily shift ','2021-10-27','2021-10-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-27 21:37:54','636','2021-10-27 21:38:18',10,0),('1','186',234825,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-28 20:57:14','636','2021-10-28 20:57:43',10,0),('1','186',235121,'Daily shift ','2021-10-29','2021-10-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-29 10:50:41','636','2021-10-29 10:52:19',10,0),('1','186',235178,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-29 11:06:25','636','2021-10-29 11:06:49',10,0),('1','186',235179,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-29 21:38:06','636','2021-10-29 21:38:33',10,0),('1','186',235274,'Daily shift ','2021-10-29','2021-10-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-30 06:50:11','636','2021-10-30 06:50:41',10,0),('1','186',235323,'Daily shift','2021-10-30','2021-10-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-30 21:33:53','636','2021-10-30 21:34:21',10,0),('1','186',235534,'Daily shift ','2021-10-31','2021-10-31 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-31 20:06:45','636','2021-10-31 20:07:07',10,0),('1','186',235712,'Daily shift','2021-10-31','2021-10-31 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-31 20:13:02','636','2021-10-31 20:13:30',10,0),('1','186',235713,'Daily shift ','2021-10-31','2021-10-31 00:00:00',NULL,'636',0.00,0.00,'636','2021-10-31 22:34:37','636','2021-10-31 22:35:06',10,0),('1','186',235758,'Daily shift','2021-11-01','2021-11-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-01 21:30:59','636','2021-11-01 21:31:33',10,0),('1','186',236070,'Daily shift ','2021-11-02','2021-11-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-02 20:28:56','636','2021-11-02 20:30:23',10,0),('1','186',236245,'Daily shift','2021-11-03','2021-11-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-03 17:39:13','636','2021-11-03 17:39:29',10,0),('1','186',236441,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-04 06:13:21','636','2021-11-04 06:14:05',10,0),('1','186',236521,'Daily shift ','2021-11-04','2021-11-04 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-04 21:38:42','636','2021-11-04 21:39:39',10,0),('1','186',236721,'Daily shift ','2021-11-05','2021-11-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-05 21:25:19','636','2021-11-05 21:26:21',10,0),('1','186',236924,'Daily shifts','2021-11-05','2021-11-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-06 06:55:48','636','2021-11-06 06:56:19',10,0),('1','186',237522,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-08 22:29:08','636','2021-11-08 22:29:33',10,0),('1','186',237686,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-09 22:14:47','636','2021-11-09 22:15:11',10,0),('1','186',237899,'Daily shift ','2021-11-10','2021-11-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-10 20:58:10','636','2021-11-10 20:58:40',10,0),('1','186',238081,'Daily shift','2021-11-10','2021-11-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-10 21:04:03','636','2021-11-10 21:04:27',10,0),('1','186',238223,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-12 05:29:06','636','2021-11-12 05:29:56',10,0),('1','186',238351,'Daily shift','2021-11-12','2021-11-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-13 06:02:38','636','2021-11-13 06:03:22',10,0),('1','186',238609,'Daily shift ','2021-11-13','2021-11-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-14 08:58:59','636','2021-11-14 08:59:59',10,0),('1','186',238891,'DAILY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-14 09:31:50','636','2021-11-14 09:32:14',10,0),('1','186',238899,'DAILY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-15 06:30:24','636','2021-11-15 06:31:29',10,0),('1','186',239082,'Daily shift','2021-11-15','2021-11-15 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-15 22:22:24','636','2021-11-15 22:22:52',10,0),('1','186',239304,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-16 07:47:31','636','2021-11-16 07:47:53',10,0),('1','186',239432,'DAILY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-17 07:28:07','636','2021-11-17 07:28:29',10,0),('1','186',239698,'DAILY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-18 09:10:07','636','2021-11-18 09:10:25',10,0),('1','186',239871,'DAILY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-18 22:07:57','636','2021-11-18 22:08:25',10,0),('1','186',240168,'Daily shift ','2021-11-18','2021-11-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-20 12:53:01','636','2021-11-20 12:53:20',10,0),('1','186',240308,'DAILY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-20 13:23:31','636','2021-11-20 13:23:51',10,0),('1','186',240320,'DAILY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-20 21:33:39','636','2021-11-20 21:34:20',10,0),('1','186',240476,'DAILY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-22 06:52:56','636','2021-11-22 06:53:22',10,0),('1','186',240721,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-22 07:34:20','636','2021-11-22 07:34:44',10,0),('1','186',240735,'DAILY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-23 06:40:59','636','2021-11-23 06:41:26',10,0),('1','186',240987,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-24 06:52:32','636','2021-11-24 06:53:37',10,0),('1','186',241244,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-25 06:40:19','636','2021-11-25 06:40:41',10,0),('1','186',241519,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-25 20:50:17','636','2021-11-25 20:50:48',10,0),('1','186',241698,'Daily shift','2021-11-25','2021-11-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-25 21:07:09','636','2021-11-25 21:07:33',10,0),('1','186',241776,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-26 22:04:17','636','2021-11-26 22:04:45',10,0),('1','186',242031,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-27 21:42:54','636','2021-11-27 21:43:38',10,0),('1','186',242228,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-28 21:28:35','636','2021-11-28 21:29:03',10,0),('1','186',242431,'Daily shift ','2021-11-29','2021-11-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-11-29 21:48:05','636','2021-11-29 21:48:33',10,0),('1','186',242724,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-01 07:22:04','636','2021-12-01 07:22:26',10,0),('1','186',242970,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-01 07:42:44','636','2021-12-01 07:43:07',10,0),('1','186',242975,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-01 21:28:20','636','2021-12-01 21:28:45',10,0),('1','186',243211,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-02 20:55:37','636','2021-12-02 20:56:15',10,0),('1','186',243432,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-04 17:46:31','636','2021-12-04 17:46:56',10,0),('1','186',243868,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-05 09:13:17','636','2021-12-05 09:17:03',10,0),('1','186',243900,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-05 09:30:14','636','2021-12-05 09:30:44',10,0),('1','186',243903,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-06 07:34:34','636','2021-12-06 07:34:52',10,0),('1','186',244095,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-07 06:43:48','636','2021-12-07 06:44:12',10,0),('1','186',244308,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-07 21:27:47','636','2021-12-07 21:28:13',10,0),('1','186',244548,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-08 07:29:12','636','2021-12-08 07:29:41',10,0),('1','186',244558,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-09 08:40:52','636','2021-12-09 08:41:18',10,0),('1','186',244805,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-10 08:49:51','636','2021-12-10 08:50:10',10,0),('1','186',245254,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-11 07:57:22','636','2021-12-11 07:57:52',10,0),('1','186',245261,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-11 08:46:30','636','2021-12-11 08:49:09',10,0),('1','186',245277,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-12 08:13:23','636','2021-12-12 08:14:00',10,0),('1','186',245501,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-13 08:06:38','636','2021-12-13 08:09:39',10,0),('1','186',246011,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-14 10:25:11','636','2021-12-14 10:25:42',10,0),('1','186',246030,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-14 12:19:45','636','2021-12-14 12:20:10',10,0),('1','186',246055,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-14 22:02:39','636','2021-12-14 22:03:02',10,0),('1','186',246251,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-15 21:52:09','636','2021-12-15 21:52:37',10,0),('1','186',246512,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-17 08:23:23','636','2021-12-17 08:23:43',10,0),('1','186',246763,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-18 08:23:06','636','2021-12-18 08:23:27',10,0),('1','186',246994,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-19 07:50:50','636','2021-12-19 07:52:17',10,0),('1','186',247362,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-19 19:57:51','636','2021-12-19 19:58:09',10,0),('1','186',247363,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-20 06:33:21','636','2021-12-20 06:33:49',10,0),('1','186',247418,'Daily shift ','2021-12-20','2021-12-20 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-21 08:25:35','636','2021-12-21 08:26:19',10,0),('1','186',247716,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-22 09:35:47','636','2021-12-22 09:37:48',10,0),('1','186',248463,'Daily shift','2021-12-24','2021-12-24 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-25 12:26:17','636','2021-12-25 12:31:27',10,0),('1','186',248745,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-25 12:40:51','636','2021-12-25 12:41:07',10,0),('1','186',248748,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-26 07:44:42','636','2021-12-26 07:48:12',10,0),('1','186',248913,'Daily shift ','2021-12-26','2021-12-26 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-27 07:12:12','636','2021-12-27 07:12:54',10,0),('1','186',249145,'Daily shift tomorrow','2021-12-27','2021-12-27 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-28 06:35:27','636','2021-12-28 06:38:58',10,0),('1','186',249362,'Daily shift','2021-12-28','2021-12-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-28 14:57:24','636','2021-12-28 14:57:45',10,0),('1','186',249511,'Daily shift ','2021-12-28','2021-12-28 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-29 07:50:21','636','2021-12-29 07:50:43',10,0),('1','186',249641,'Daily shift ','2021-12-29','2021-12-29 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-30 07:21:14','636','2021-12-30 07:21:39',10,0),('1','186',249891,'Daily shift','2021-12-30','2021-12-30 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-31 10:57:44','636','2021-12-31 10:58:22',10,0),('1','186',250203,'Daily shift ','2021-12-31','2021-12-31 00:00:00',NULL,'636',0.00,0.00,'636','2021-12-31 11:40:25','636','2021-12-31 11:40:42',10,0),('1','186',250206,'Daily shift ','2021-12-31','2021-12-31 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-01 10:34:45','636','2022-01-01 10:35:03',10,0),('1','186',250417,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-02 09:20:33','636','2022-01-02 09:21:31',10,0),('1','186',250630,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-03 09:02:53','636','2022-01-03 09:03:18',10,0),('1','186',250870,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-04 10:14:09','636','2022-01-04 10:14:37',10,0),('1','186',251103,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-04 10:28:09','636','2022-01-04 10:29:15',10,0),('1','186',251109,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-05 11:04:46','636','2022-01-05 11:05:07',10,0),('1','186',251363,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-06 11:13:55','636','2022-01-06 11:14:35',10,0),('1','186',251614,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-08 12:02:43','636','2022-01-08 12:07:41',10,0),('1','186',252089,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-08 12:23:02','636','2022-01-08 12:25:23',10,0),('1','186',252094,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-08 12:51:14','636','2022-01-08 12:51:42',10,0),('1','186',252104,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-09 10:53:35','636','2022-01-09 10:55:40',10,0),('1','186',252306,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-10 07:44:46','636','2022-01-10 07:45:12',10,0),('1','186',252495,'Daily shift ','2022-01-10','2022-01-10 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-11 11:03:14','636','2022-01-11 11:03:38',10,0),('1','186',252811,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-12 09:17:08','636','2022-01-12 09:17:26',10,0),('1','186',253032,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-12 09:25:26','636','2022-01-12 09:25:48',10,0),('1','186',253035,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-13 10:03:55','636','2022-01-13 10:05:31',10,0),('1','186',253282,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-14 22:48:51','636','2022-01-14 22:49:41',10,0),('1','186',253686,'Daily shift ','2022-01-13','2022-01-13 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-14 22:58:20','636','2022-01-14 22:58:39',10,0),('1','186',253689,'Daily shift','2022-01-14','2022-01-14 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-15 09:38:13','636','2022-01-15 09:38:31',10,0),('1','186',253772,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-16 10:38:01','636','2022-01-16 10:40:07',10,0),('1','186',254025,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-18 10:13:31','636','2022-01-18 10:53:03',10,0),('1','186',254542,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-18 10:57:02','636','2022-01-18 10:57:18',10,0),('1','186',254544,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-18 11:26:00','636','2022-01-18 11:26:22',10,0),('1','186',254549,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-18 11:41:51','636','2022-01-18 11:42:35',10,0),('1','186',254552,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-19 09:07:50','636','2022-01-19 09:08:10',10,0),('1','186',254763,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-20 08:39:53','636','2022-01-20 08:40:34',10,0),('1','186',255000,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-21 15:18:54','636','2022-01-21 15:34:16',10,0),('1','186',255369,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-22 10:27:28','636','2022-01-22 10:27:45',10,0),('1','186',255535,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-22 10:44:27','636','2022-01-22 10:44:58',10,0),('1','186',255540,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-22 11:07:55','636','2022-01-22 11:09:25',10,0),('1','186',255550,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-23 10:26:15','636','2022-01-23 10:28:59',10,0),('1','186',255777,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-24 07:16:05','636','2022-01-24 07:16:29',10,0),('1','186',255947,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-24 17:27:46','636','2022-01-24 17:28:22',10,0),('1','186',256125,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-25 09:55:48','636','2022-01-25 09:56:26',10,0),('1','186',256286,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-26 10:06:46','636','2022-01-26 10:07:12',10,0),('1','186',256557,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-27 09:15:27','636','2022-01-27 09:15:49',10,0),('1','186',256775,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-27 09:27:09','636','2022-01-27 09:27:27',10,0),('1','186',256870,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-28 09:09:25','636','2022-01-28 09:09:57',10,0),('1','186',257024,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-29 10:36:37','636','2022-01-29 10:38:27',10,0),('1','186',257310,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-30 10:05:05','636','2022-01-30 10:05:40',10,0),('1','186',257547,'DAILY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-31 09:08:43','636','2022-01-31 09:09:00',10,0),('1','186',257548,'DAILY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'636',0.00,0.00,'636','2022-01-31 10:01:49','636','2022-01-31 10:02:14',10,0),('1','186',257549,'Daily shifts','2022-01-31','2022-01-31 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-01 08:44:22','636','2022-02-01 08:46:34',10,0),('1','186',257550,'DAILY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-02 08:59:27','636','2022-02-02 08:59:47',10,0),('1','186',257551,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-02 10:10:37','636','2022-02-02 10:10:52',10,0),('1','186',257552,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-03 08:33:29','636','2022-02-03 08:33:52',10,0),('1','186',257553,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-04 08:47:58','636','2022-02-04 08:48:29',10,0),('1','186',257554,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-04 09:20:08','636','2022-02-04 09:20:29',10,0),('1','186',257555,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-05 09:08:44','636','2022-02-05 09:09:02',10,0),('1','186',257556,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-06 10:11:37','636','2022-02-06 10:12:14',10,0),('1','186',257557,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-06 10:25:16','636','2022-02-06 10:25:33',10,0),('1','186',257558,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-07 10:25:17','636','2022-02-07 10:25:38',10,0),('1','186',257559,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-08 09:56:14','636','2022-02-08 09:56:31',10,0),('1','186',257560,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-09 09:27:41','636','2022-02-09 09:28:04',10,0),('1','186',257561,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-09 09:40:42','636','2022-02-09 09:40:59',10,0),('1','186',257562,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-10 09:42:21','636','2022-02-10 09:42:46',10,0),('1','186',257563,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-11 10:46:07','636','2022-02-11 10:46:23',10,0),('1','186',257564,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-12 11:05:48','636','2022-02-12 11:06:43',10,0),('1','186',257565,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-12 12:16:16','636','2022-02-12 20:31:43',10,0),('1','186',257566,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-13 11:19:34','636','2022-02-13 11:20:08',10,0),('1','186',257567,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-14 09:37:11','636','2022-02-14 09:37:25',10,0),('1','186',257568,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-15 10:25:07','636','2022-02-15 10:25:51',10,0),('1','186',257569,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-15 20:25:59','636','2022-02-15 20:26:19',10,0),('1','186',257570,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-16 08:57:23','636','2022-02-16 08:57:57',10,0),('1','186',257571,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-17 20:02:45','636','2022-02-17 20:03:37',10,0),('1','186',257572,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-17 20:12:00','636','2022-02-17 20:12:16',10,0),('1','186',257573,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-18 09:36:29','636','2022-02-18 09:36:58',10,0),('1','186',257574,'DAILY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-19 10:34:58','636','2022-02-19 10:35:26',10,0),('1','186',257575,'DAILY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-20 09:18:15','636','2022-02-20 09:18:30',10,0),('1','186',257576,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-20 09:30:56','636','2022-02-20 09:31:13',10,0),('1','186',257577,'DAILY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-21 09:32:17','636','2022-02-21 09:32:51',10,0),('1','186',257578,'DAILY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'636',0.00,0.00,'636','2022-02-22 09:18:43','636','2022-02-22 09:19:02',10,0),('1','186',257579,'DAILY SHIFT','2022-02-22','2022-02-22 09:30:13','2022-02-23 09:30:13','636',0.00,0.00,'636','2022-02-23 09:53:21','636','2022-02-23 09:53:47',10,0),('1','186',257580,'DAILY SHIFT','2022-02-22','2022-02-23 09:58:14','2022-02-24 09:58:14','636',0.00,0.00,'636','2022-02-23 10:30:51','636','2022-02-23 10:31:26',10,0),('1','186',257581,'DAILY SHIFT','2022-02-23','2022-02-23 10:32:20','2022-02-24 10:32:20','636',0.00,0.00,'636','2022-02-24 08:52:02','636','2022-02-24 08:52:30',10,0),('1','186',257582,'DAILY SHIFT','2022-02-25','2022-02-25 15:28:56','2022-02-26 15:28:56','636',0.00,0.00,'636','2022-02-25 16:19:09','636','2022-02-25 16:19:31',10,0),('1','186',257583,'DAILY SHIFT','2022-02-25','2022-02-25 16:19:55','2022-02-26 16:19:55','636',0.00,0.00,'636','2022-02-26 08:00:46','636','2022-02-26 08:01:01',10,0),('1','186',257584,'DAILY SHIFT','2022-02-26','2022-02-26 08:01:26','2022-02-27 08:01:26','636',0.00,0.00,'636','2022-02-27 08:03:38','636','2022-02-27 08:04:24',10,0),('1','186',257585,'Daily shift','2022-02-27','2022-02-27 08:05:30','2022-02-28 11:05:30','636',0.00,0.00,'636','2022-02-28 10:41:32','636','2022-02-28 10:42:06',10,0),('1','186',257586,'DAILY SHIFT','2022-02-28','2022-02-28 16:47:44','2022-03-01 16:47:44','636',0.00,0.00,'636','2022-02-28 16:54:43','636','2022-02-28 16:55:02',10,0),('1','186',257587,'DAILY SHIFT','2022-02-28','2022-02-28 17:55:27','2022-03-01 17:55:27','636',0.00,0.00,'636','2022-02-28 23:07:04','636','2022-02-28 23:07:36',10,0),('1','186',257588,'DAILY SHIFT','2022-03-01','2022-03-01 07:50:04','2022-03-02 07:50:04','636',0.00,0.00,'636','2022-03-01 21:12:41','636','2022-03-01 21:13:01',10,0),('1','186',257589,'DAILY SHIFT','2022-03-02','2022-03-02 07:24:56','2022-03-03 07:24:56','636',0.00,0.00,'636','2022-03-02 21:32:49','636','2022-03-02 21:33:31',10,0),('1','186',257590,'DAILY SHIFT','2022-03-03','2022-03-03 20:39:42','2022-03-04 20:39:42','636',0.00,0.00,'636','2022-03-03 20:44:33','636','2022-03-03 20:44:53',10,0),('1','186',257591,'DAILY SHIFT','2022-03-03','2022-03-03 20:52:08','2022-03-04 20:52:08','636',0.00,0.00,'636','2022-03-03 23:06:44','636','2022-03-03 23:07:06',10,0),('1','186',257592,'DAILY SHIFT','2022-03-04','2022-03-04 07:52:11','2022-03-05 07:52:11','636',0.00,0.00,'636','2022-03-04 23:10:04','636','2022-03-04 23:10:35',10,0),('1','186',257593,'DAILY SHIFT','2022-03-05','2022-03-05 07:29:57','2022-03-06 07:29:57','636',0.00,0.00,'636','2022-03-05 22:44:28','636','2022-03-05 22:44:48',10,0),('1','186',257594,'DAILY SHIFT','2022-03-06','2022-03-06 08:38:00','2022-03-07 08:38:00','636',0.00,0.00,'636','2022-03-06 20:18:08','636','2022-03-06 20:18:25',10,0),('1','186',257595,'DAILY SHIFT','2022-03-06','2022-03-06 20:19:07','2022-03-07 20:19:07','636',0.00,0.00,'636','2022-03-06 22:04:43','636','2022-03-06 22:05:31',10,0),('1','186',257596,'DAILY SHIFT','2022-03-07','2022-03-07 07:59:51','2022-03-08 07:59:51','636',0.00,0.00,'636','2022-03-07 23:39:30','636','2022-03-07 23:40:02',10,0),('1','186',257597,'Daily shift ','2022-03-08','2022-03-08 07:44:59','2022-03-09 07:44:59','636',0.00,0.00,'636','2022-03-08 21:37:45','636','2022-03-08 21:38:13',10,0),('1','186',257598,'DAILY SHIFT','2022-03-10','2022-03-10 12:48:59','2022-03-11 12:48:59','636',0.00,0.00,'636','2022-03-10 12:57:18','636','2022-03-10 12:57:40',10,0),('1','186',257599,'DAILY SHIFT','2022-03-10','2022-03-10 13:00:49','2022-03-11 13:00:49','636',0.00,0.00,'636','2022-03-10 13:06:01','636','2022-03-10 13:06:21',10,0),('1','186',257600,'DAILY SHIFT','2022-03-10','2022-03-10 13:46:35','2022-03-11 13:46:35','636',0.00,0.00,'636','2022-03-10 22:59:49','636','2022-03-10 23:00:21',10,0),('1','186',257601,'Daily shift','2022-03-11','2022-03-11 07:01:42','2022-03-12 07:01:42','636',0.00,0.00,'636','2022-03-11 22:43:57','636','2022-03-11 22:44:17',10,0),('1','186',257602,'DAILY SHIFT','2022-03-12','2022-03-12 07:39:30','2022-03-13 07:39:30','636',0.00,0.00,'636','2022-03-12 21:30:08','636','2022-03-12 21:30:45',10,0),('1','186',257603,'Daily shift','2022-03-13','2022-03-13 07:27:09','2022-03-14 07:27:09','636',0.00,0.00,'636','2022-03-13 22:29:38','636','2022-03-13 22:30:11',10,0),('1','186',257604,'DAILY SHIFT','2022-03-13','2022-03-14 08:41:21','2022-03-15 08:41:21','636',0.00,0.00,'636','2022-03-14 08:47:27','636','2022-03-14 08:47:46',10,0),('1','186',257605,'DAILY SHIFT','2022-03-14','2022-03-14 10:56:53','2022-03-15 10:56:53','636',0.00,0.00,'636','2022-03-14 11:27:30','636','2022-03-14 11:27:58',10,0),('1','186',257606,'DAILY SHIFT','2022-03-14','2022-03-14 11:31:53','2022-03-15 11:31:53','636',0.00,0.00,'636','2022-03-14 23:07:32','636','2022-03-14 23:08:30',10,0),('1','186',257607,'Daily shift ','2022-03-15','2022-03-15 08:06:08','2022-03-16 08:06:08','636',0.00,0.00,'636','2022-03-15 22:50:23','636','2022-03-15 22:50:53',10,0),('1','186',257608,'Daily shift','2022-03-16','2022-03-16 07:46:51','2022-03-17 07:46:51','636',0.00,0.00,'636','2022-03-16 22:14:46','636','2022-03-16 22:15:37',10,0),('1','186',257609,'DAILY SHIFT','2022-03-17','2022-03-17 20:25:28','2022-03-18 20:25:28','636',0.00,0.00,'636','2022-03-17 20:36:22','636','2022-03-17 20:36:46',10,0),('1','186',257610,'DAILY SHIFT','2022-03-17','2022-03-17 20:44:38','2022-03-18 20:44:38','636',0.00,0.00,'636','2022-03-17 20:49:05','636','2022-03-17 20:49:33',10,0),('1','186',257611,'Daily shift','2022-03-18','2022-03-18 08:14:36','2022-03-19 08:14:36','636',0.00,0.00,'636','2022-03-18 22:39:26','636','2022-03-18 22:40:00',10,0),('1','186',257612,'Daily shift','2022-03-19','2022-03-19 08:24:34','2022-03-20 08:24:34','636',0.00,0.00,'636','2022-03-19 23:04:07','636','2022-03-19 23:04:31',10,0),('1','186',257613,'DAILY SHIFT','2022-03-20','2022-03-20 08:14:36','2022-03-21 08:14:36','636',0.00,0.00,'636','2022-03-20 21:35:03','636','2022-03-20 21:35:39',10,0),('1','186',257614,'DAILY SHIFT','2022-03-20','2022-03-21 09:55:05','2022-03-22 09:55:05','636',0.00,0.00,'636','2022-03-21 09:57:51','636','2022-03-21 09:58:09',10,0),('1','186',257615,'DAILY SHIFT','2022-03-24','2022-03-24 08:56:09','2022-03-25 08:56:09','636',0.00,0.00,'636','2022-03-24 22:05:55','636','2022-03-24 22:06:23',10,0),('1','186',257616,'DAILY SHIFT','2022-03-25','2022-03-25 07:58:32','2022-03-26 07:58:32','636',0.00,0.00,'636','2022-03-25 21:55:59','636','2022-03-25 21:56:24',10,0),('1','186',257617,'DAILY SHIFT','2022-03-26','2022-03-26 08:14:55','2022-03-27 08:14:55','636',0.00,0.00,'636','2022-03-26 21:05:36','636','2022-03-26 21:06:09',10,0),('1','186',257618,'DAILY SHIFT','2022-03-26','2022-03-27 07:08:41','2022-03-28 07:08:41','636',0.00,0.00,'636','2022-03-27 07:13:23','636','2022-03-27 07:13:43',10,0),('1','186',257619,'DAILY SHIFT','2022-03-27','2022-03-27 08:01:38','2022-03-28 08:01:38','636',0.00,0.00,'636','2022-03-27 22:34:48','636','2022-03-27 22:35:24',10,0),('1','186',257620,'Daily shift','2022-03-27','2022-03-27 22:36:08','2022-03-28 22:36:08','636',0.00,0.00,'636','2022-03-27 22:46:16','636','2022-03-27 22:46:47',10,0),('1','186',257621,'DAILY SHIFT','2022-03-28','2022-03-28 07:54:46','2022-03-29 07:54:46','636',0.00,0.00,'636','2022-03-28 21:31:40','636','2022-03-28 21:32:16',10,0),('1','186',257622,'DAILY SHIFT','2022-03-29','2022-03-29 08:28:31','2022-03-30 08:28:31','636',0.00,0.00,'636','2022-03-29 22:14:32','636','2022-03-29 22:15:03',10,0),('1','186',257623,'DAILY SHIFT','2022-03-30','2022-03-30 07:56:28','2022-03-31 07:56:28','636',0.00,0.00,'636','2022-03-30 22:19:42','636','2022-03-30 22:20:19',10,0),('1','186',257624,'DAILY SHIFT','2022-03-31','2022-03-31 07:40:03','2022-04-01 07:40:03','636',0.00,0.00,'636','2022-03-31 22:49:08','636','2022-03-31 22:49:59',10,0),('1','186',257625,'Daily shift ','2022-03-31','2022-03-31 22:51:31','2022-04-01 22:51:31','636',0.00,0.00,'636','2022-03-31 22:55:48','636','2022-03-31 22:56:18',10,0),('1','186',257626,'DAILY SHIFT','2022-04-01','2022-04-01 07:57:26','2022-04-02 07:57:26','636',0.00,0.00,'636','2022-04-01 22:52:17','636','2022-04-01 22:52:58',10,0),('1','186',257627,'DAILY SHIFT','2022-04-02','2022-04-02 07:41:33','2022-04-03 07:41:33','636',0.00,0.00,'636','2022-04-02 20:35:40','636','2022-04-02 20:37:44',10,0),('1','186',257628,'DAILY SHIFT','2022-04-05','2022-04-05 11:53:40','2022-04-06 11:53:40','636',0.00,0.00,'636','2022-04-05 11:57:12','636','2022-04-05 11:57:33',10,0),('1','186',257629,'DAILY SHIFT','2022-04-05','2022-04-05 12:03:01','2022-04-06 12:03:01','636',0.00,0.00,'636','2022-04-05 22:03:11','636','2022-04-05 22:03:42',10,0),('1','186',257630,'DAILY SHIFT','2022-04-06','2022-04-06 08:18:51','2022-04-07 08:18:51','636',0.00,0.00,'636','2022-04-06 22:33:49','636','2022-04-06 22:34:20',10,0),('1','186',257631,'Daily shift ','2022-04-07','2022-04-07 07:59:40','2022-04-08 07:59:40','636',0.00,0.00,'636','2022-04-07 22:08:31','636','2022-04-07 22:09:01',10,0),('1','186',257632,'Daily shift','2022-04-07','2022-04-07 22:09:30','2022-04-08 22:09:30','636',0.00,0.00,'636','2022-04-07 22:15:02','636','2022-04-07 22:15:44',10,0),('1','186',257633,'DAILY SHIFT','2022-04-08','2022-04-08 08:21:44','2022-04-09 08:21:44','636',0.00,0.00,'636','2022-04-08 08:35:15','636','2022-04-08 08:35:33',10,0),('1','186',257634,'DAILY SHIFT','2022-04-08','2022-04-08 08:39:07','2022-04-09 08:39:07','636',0.00,0.00,'636','2022-04-08 22:46:27','636','2022-04-08 22:46:48',10,0),('1','186',257635,'DAILY SHIFT','2022-04-09','2022-04-09 15:03:25','2022-04-10 15:03:25','636',0.00,0.00,'636','2022-04-09 22:29:51','636','2022-04-09 22:30:18',10,0),('1','186',257636,'DAILY SHIFT','2022-04-11','2022-04-11 18:32:22','2022-04-12 18:32:22','636',0.00,0.00,'636','2022-04-11 19:58:58','636','2022-04-11 19:59:17',10,0),('1','186',257637,'DAILY SHIFT','2022-04-10','2022-04-11 20:00:44','2022-04-12 20:00:44','636',0.00,0.00,'636','2022-04-12 07:45:58','636','2022-04-12 07:46:13',10,0),('1','186',257638,'DAILY SHIFT','2022-04-10','2022-04-12 07:51:57','2022-04-13 07:51:57','636',0.00,0.00,'636','2022-04-12 08:07:46','636','2022-04-12 08:08:03',10,0),('1','186',257639,'DAILY SHIFT','2022-04-11','2022-04-12 08:32:32','2022-04-13 08:32:32','636',0.00,0.00,'636','2022-04-12 08:42:09','636','2022-04-12 08:42:25',10,0),('1','186',257640,'DAILY SHIFT','2022-04-12','2022-04-12 08:42:56','2022-04-13 08:42:56','636',0.00,0.00,'636','2022-04-12 22:22:28','636','2022-04-12 22:22:53',10,0),('1','186',257641,'DAILY SHIFT','2022-04-12','2022-04-13 20:08:39','2022-04-14 20:08:39','636',0.00,0.00,'636','2022-04-13 20:12:58','636','2022-04-13 20:13:16',10,0),('1','186',257642,'DAILY SHIFT','2022-04-13','2022-04-13 20:22:05','2022-04-14 20:22:05','636',0.00,0.00,'636','2022-04-13 20:30:28','636','2022-04-13 20:30:45',10,0),('1','186',257643,'DAILY SHIFT','2022-04-14','2022-04-14 08:15:20','2022-04-15 08:15:20','636',0.00,0.00,'636','2022-04-14 22:38:46','636','2022-04-14 22:39:15',10,0),('1','186',257644,'DAILY SHIFT','2022-04-15','2022-04-15 08:43:13','2022-04-16 08:43:13','636',0.00,0.00,'636','2022-04-15 21:41:06','636','2022-04-15 21:41:25',10,0),('1','186',257645,'DAILY SHIFT','2022-04-15','2022-04-16 11:52:14','2022-04-17 11:52:14','636',0.00,0.00,'636','2022-04-16 11:59:31','636','2022-04-16 11:59:50',10,0),('1','186',257646,'DAILY SHIFT','2022-04-16','2022-04-16 14:09:14','2022-04-17 14:09:14','636',0.00,0.00,'636','2022-04-16 23:12:08','636','2022-04-16 23:12:28',10,0),('1','186',257647,'DAILY SHIFT','2022-04-17','2022-04-17 08:08:57','2022-04-18 08:08:57','636',0.00,0.00,'636','2022-04-17 22:11:17','636','2022-04-17 22:11:47',10,0),('1','186',257648,'DAILY SHIFT','2022-04-18','2022-04-18 08:25:56','2022-04-19 08:25:56','636',0.00,0.00,'636','2022-04-18 22:14:29','636','2022-04-18 22:14:52',10,0),('1','186',257649,'DAILY SHIFT','2022-04-18','2022-04-19 19:37:53','2022-04-20 19:37:53','636',0.00,0.00,'636','2022-04-19 19:41:32','636','2022-04-19 19:42:01',10,0),('1','186',257650,'DAILY SHIFT','2022-04-19','2022-04-19 20:31:00','2022-04-20 20:31:00','636',0.00,0.00,'636','2022-04-19 20:43:46','636','2022-04-19 20:45:00',10,0),('1','186',257651,'DAILY SHIFT','2022-04-20','2022-04-20 08:15:52','2022-04-21 08:15:52','636',0.00,0.00,'636','2022-04-20 21:44:08','636','2022-04-20 21:44:38',10,0),('1','186',257652,'DAILY SHIFT','2022-04-21','2022-04-21 09:40:01','2022-04-22 09:40:01','636',0.00,0.00,'636','2022-04-21 20:20:02','636','2022-04-21 20:20:17',10,0),('1','186',257653,'DAILY SHIFT','2022-04-22','2022-04-22 10:16:49','2022-04-23 10:16:49','636',0.00,0.00,'636','2022-04-22 19:52:22','636','2022-04-22 19:52:47',10,0),('1','186',257654,'DAILY SHIFT','2022-04-22','2022-04-23 20:31:40','2022-04-24 20:31:40','636',0.00,0.00,'636','2022-04-23 20:35:18','636','2022-04-23 20:35:42',10,0),('1','186',257655,'DAILY SHIFT','2022-04-23','2022-04-23 20:39:38','2022-04-24 20:39:38','636',0.00,0.00,'636','2022-04-23 23:18:10','636','2022-04-23 23:18:49',10,0),('1','186',257656,'DAILY SHIFT','2022-04-24','2022-04-24 08:27:12','2022-04-25 08:27:12','636',0.00,0.00,'636','2022-04-24 21:20:42','636','2022-04-24 21:21:13',10,0),('1','186',257657,'DAILY SHIFT','2022-04-25','2022-04-25 08:01:47','2022-04-26 08:01:47','636',0.00,0.00,'636','2022-04-25 22:41:06','636','2022-04-25 22:41:41',10,0),('1','186',257658,'DAILY SHIFT','2022-04-26','2022-04-26 08:40:27','2022-04-27 08:40:27','636',0.00,0.00,'636','2022-04-26 08:50:45','636','2022-04-26 08:51:17',10,0),('1','186',257659,'DAILY SHIFT','2022-04-26','2022-04-26 09:03:00','2022-04-27 09:03:00','636',0.00,0.00,'636','2022-04-26 20:22:14','636','2022-04-26 20:22:31',10,0),('1','186',257660,'DAILY SHIFT','2022-04-27','2022-04-27 08:38:55','2022-04-28 08:38:55','636',0.00,0.00,'636','2022-04-27 20:32:33','636','2022-04-27 20:32:47',10,0),('1','186',257661,'OPRATINAL LOSSESS','2022-04-27','2022-04-27 20:36:30','2022-04-28 20:36:30','636',0.00,0.00,'636','2022-04-27 20:41:18','636','2022-04-27 20:41:34',10,0),('1','186',257662,'DAILY SHIFT','2022-04-28','2022-04-28 08:25:08','2022-04-29 08:25:08','636',0.00,0.00,'636','2022-04-28 21:21:04','636','2022-04-28 21:21:38',10,0),('1','186',257663,'DAILY SHIFT','2022-04-29','2022-04-29 08:29:22','2022-04-30 08:29:22','636',0.00,0.00,'636','2022-04-29 20:34:01','636','2022-04-29 20:34:22',10,0),('1','186',257664,'OPRATINAL LOSSESS','2022-04-29','2022-04-30 09:33:34','2022-05-01 09:33:34','636',0.00,0.00,'636','2022-04-30 09:39:20','636','2022-04-30 09:39:44',10,0),('1','186',257665,'DAILY SHIFT','2022-04-30','2022-04-30 19:36:37','2022-05-01 19:36:37','636',0.00,0.00,'636','2022-04-30 20:24:52','636','2022-04-30 20:25:11',10,0),('1','186',257666,'DAILY SHIFT','2022-05-01','2022-05-01 10:06:55','2022-05-02 10:06:55','636',0.00,0.00,'636','2022-05-01 23:05:22','636','2022-05-01 23:05:43',10,0),('1','186',257667,'DAILY SHIFT','2022-05-02','2022-05-02 10:04:33','2022-05-03 10:04:33','636',0.00,0.00,'636','2022-05-02 19:54:24','636','2022-05-02 19:55:08',10,0),('1','186',257668,'OPRATINAL LOSSESS','2022-05-03','2022-05-03 08:20:14','2022-05-04 08:20:14','636',0.00,0.00,'636','2022-05-03 08:28:31','636','2022-05-03 08:29:34',10,0),('1','186',257669,'DAILY SHIFT','2022-05-03','2022-05-03 19:19:15','2022-05-04 19:19:15','636',0.00,0.00,'636','2022-05-03 21:57:08','636','2022-05-03 21:57:29',10,0),('1','186',257670,'DAILY SHIFT','2022-05-04','2022-05-04 09:49:21','2022-05-05 09:49:21','636',0.00,0.00,'636','2022-05-04 22:14:54','636','2022-05-04 22:15:33',10,0),('1','186',257671,'DAILY SHIFT','2022-05-05','2022-05-05 09:18:44','2022-05-06 09:18:44','636',0.00,0.00,'636','2022-05-05 21:24:21','636','2022-05-05 21:24:40',10,0),('1','186',257672,'OPRATINAL LOSSESS','2022-05-06','2022-05-07 10:15:16','2022-05-08 10:15:16','636',0.00,0.00,'636','2022-05-07 10:22:35','636','2022-05-07 10:24:14',10,0),('1','186',257673,'DAILY SHIFT','2022-05-07','2022-05-07 10:45:58','2022-05-08 10:45:58','636',0.00,0.00,'636','2022-05-07 22:35:50','636','2022-05-07 22:36:13',10,0),('1','186',257674,'DAILY SHIFT','2022-05-08','2022-05-08 11:38:27','2022-05-09 11:38:27','636',0.00,0.00,'636','2022-05-09 04:03:13','636','2022-05-09 04:03:38',10,0),('1','186',257675,'DAILY SHIFT','2022-05-09','2022-05-09 08:34:30','2022-05-10 08:34:30','636',0.00,0.00,'636','2022-05-09 08:36:52','636','2022-05-09 08:37:13',10,0),('1','186',257676,'OPRATINAL LOSSESS','2022-05-09','2022-05-09 08:37:37','2022-05-10 08:37:37','636',0.00,0.00,'636','2022-05-09 08:43:06','636','2022-05-09 08:43:25',10,0),('1','186',257677,'DAILY SHIFT','2022-05-10','2022-05-10 15:14:16','2022-05-11 15:14:16','636',0.00,0.00,'636','2022-05-10 20:52:14','636','2022-05-10 20:52:49',10,0),('1','186',257678,'DAILY SHIFT','2022-05-11','2022-05-11 07:39:31','2022-05-12 07:39:31','636',0.00,0.00,'636','2022-05-11 21:32:13','636','2022-05-11 21:32:41',10,0),('1','186',257679,'DAILY SHIFT','2022-05-12','2022-05-12 07:12:00','2022-05-13 07:12:00','636',0.00,0.00,'636','2022-05-12 20:20:16','636','2022-05-12 20:24:12',10,0),('1','186',257680,'DAILY SHIFT','2022-05-13','2022-05-13 07:03:04','2022-05-14 07:03:04','636',0.00,0.00,'636','2022-05-13 17:19:56','636','2022-05-13 17:20:10',10,0),('1','186',257681,'OPRATINAL LOSS','2022-05-13','2022-05-13 17:53:34','2022-05-14 17:53:34','636',0.00,0.00,'636','2022-05-13 17:57:06','636','2022-05-13 17:57:20',10,0),('1','186',257682,'DAILY SHIFT','2022-05-18','2022-05-18 09:19:44','2022-05-19 09:19:44','636',0.00,0.00,'636','2022-05-18 20:29:09','636','2022-05-18 20:30:05',10,0),('1','186',257683,'DAILY SHIFT','2022-05-19','2022-05-19 07:06:15','2022-05-20 07:06:15','636',0.00,0.00,'636','2022-05-19 21:07:13','636','2022-05-19 21:08:43',10,0),('1','186',257684,'DAILY SHIFT','2022-05-20','2022-05-20 07:02:22','2022-05-21 07:02:22','636',0.00,0.00,'636','2022-05-20 19:16:30','636','2022-05-20 19:17:32',10,0),('1','186',257685,'DAILY SHIFT','2022-05-21','2022-05-21 07:16:27','2022-05-22 07:16:27','636',0.00,0.00,'636','2022-05-21 19:37:53','636','2022-05-21 19:38:09',10,0),('1','186',257686,'DAILY SHIFT','2022-05-22','2022-05-22 07:04:01','2022-05-23 07:04:01','636',0.00,0.00,'636','2022-05-22 18:15:07','636','2022-05-22 18:26:55',10,0),('1','186',257687,'OPRATINAL LOSS','2022-05-22','2022-05-22 18:27:15','2022-05-23 18:27:15','636',0.00,0.00,'636','2022-05-22 18:50:13','636','2022-05-22 18:50:26',10,0),('1','186',257688,'DAILY SHIFT','2022-05-23','2022-05-23 06:51:45','2022-05-24 06:51:45','636',0.00,0.00,'882','2022-05-23 20:33:03','882','2022-05-23 20:33:26',10,0),('1','186',257689,'DAILY SHIFT','2022-05-24','2022-05-24 06:58:15','2022-05-25 06:58:15','882',0.00,0.00,'882','2022-05-24 20:01:55','882','2022-05-24 20:02:12',10,0),('1','186',257690,'DAILY SHIFT','2022-05-24','2022-05-24 20:22:30','2022-05-25 20:22:30','882',0.00,0.00,'882','2022-05-24 20:29:35','882','2022-05-24 20:29:56',10,0),('1','186',257691,'DAILY SHIFT','2022-05-25','2022-05-25 06:59:34','2022-05-26 06:59:34','882',0.00,0.00,'882','2022-05-25 21:15:00','882','2022-05-25 21:15:16',10,0),('1','186',257692,'DAILY SHIFT','2022-05-26','2022-05-26 07:10:45','2022-05-27 07:10:45','882',0.00,0.00,'882','2022-05-26 19:21:33','882','2022-05-26 19:21:52',10,0),('1','186',257693,'DAILY SHIFT','2022-05-27','2022-05-27 07:00:22','2022-05-28 07:00:22','882',0.00,0.00,'882','2022-05-27 19:24:35','882','2022-05-27 19:24:59',10,0),('1','186',257694,'OPRATINAL LOSS','2022-05-27','2022-05-27 19:37:52','2022-05-28 19:37:52','882',0.00,0.00,'882','2022-05-27 19:40:27','882','2022-05-27 19:40:41',10,0),('1','186',257695,'DAILY SHIFT','2022-05-28','2022-05-28 15:14:08','2022-05-29 15:14:08','882',0.00,0.00,'882','2022-05-28 21:20:52','882','2022-05-28 21:21:11',10,0),('1','186',257696,'DAILY SHIFT','2022-05-29','2022-05-29 07:05:44','2022-05-30 07:05:44','882',0.00,0.00,'882','2022-05-29 18:41:05','882','2022-05-29 18:41:24',10,0),('1','186',257697,'DAILY SHIFT','2022-05-30','2022-05-30 06:53:31','2022-05-31 06:53:31','882',0.00,0.00,'882','2022-05-30 14:45:21','882','2022-05-30 14:45:49',10,0),('1','186',257698,'OPRATINAL LOSS','2022-05-30','2022-05-30 16:01:10','2022-05-31 16:01:10','882',0.00,0.00,'882','2022-05-30 16:03:36','882','2022-05-30 16:03:51',10,0),('1','186',257699,'DAILY SHIFT','2022-06-01','2022-06-01 06:54:49','2022-06-02 06:54:49','882',0.00,0.00,'882','2022-06-01 20:54:47','882','2022-06-01 20:58:54',10,0),('1','186',257700,'DAILY SHIFT','2022-06-02','2022-06-02 07:14:42','2022-06-03 07:14:42','882',0.00,0.00,'882','2022-06-02 17:37:58','882','2022-06-02 17:44:10',10,0),('1','186',257701,'OPRATINAL LOSS','2022-06-02','2022-06-02 18:11:50','2022-06-03 18:11:50','882',0.00,0.00,'882','2022-06-02 18:14:44','882','2022-06-02 18:14:58',10,0),('1','186',257702,'DAILY SHIFT','2022-06-05','2022-06-05 12:13:28','2022-06-06 12:13:28','882',0.00,0.00,'882','2022-06-05 20:02:43','882','2022-06-05 20:04:49',10,0),('1','186',257703,'DAILY SHIFT','2022-06-06','2022-06-06 06:55:56','2022-06-07 06:55:56','882',0.00,0.00,'882','2022-06-06 19:14:06','882','2022-06-06 19:14:24',10,0),('1','186',257704,'DAILY SHIFT','2022-06-07','2022-06-07 07:01:43','2022-06-08 07:01:43','882',0.00,0.00,'882','2022-06-07 12:33:13','882','2022-06-07 12:33:31',10,0),('1','186',257705,'OPERATIONAL LOSS','2022-06-07','2022-06-07 12:35:48','2022-06-08 12:35:48','882',0.00,0.00,'882','2022-06-07 12:42:36','882','2022-06-07 12:42:58',10,0),('1','186',257706,'DAILY SHIFT','2022-06-07','2022-06-07 12:43:18','2022-06-08 12:43:18','882',0.00,0.00,'882','2022-06-07 19:35:38','882','2022-06-08 07:04:19',10,0),('1','186',257707,'DAILY SHIFT','2022-06-08','2022-06-08 07:04:38','2022-06-09 07:04:38','882',0.00,0.00,'882','2022-06-08 20:09:11','882','2022-06-08 20:09:33',10,0),('1','186',257708,'DAILY SHIFT','2022-06-09','2022-06-09 06:57:40','2022-06-10 06:57:40','882',0.00,0.00,'882','2022-06-09 13:26:40','882','2022-06-09 13:27:10',10,0),('1','186',257709,'OPRATINAL LOSS','2022-06-09','2022-06-09 13:32:19','2022-06-10 13:32:19','882',0.00,0.00,'882','2022-06-09 13:35:13','882','2022-06-09 13:35:29',10,0),('1','186',257710,'DAILY SHIFT','2022-06-10','2022-06-10 11:12:04','2022-06-11 11:12:04','882',0.00,0.00,'882','2022-06-10 16:04:46','882','2022-06-10 16:05:02',10,0),('1','186',257711,'DAILY SHIFT','2022-06-10','2022-06-10 16:06:14','2022-06-11 16:06:14','882',0.00,0.00,'882','2022-06-10 19:09:02','882','2022-06-10 19:09:18',10,0),('1','186',257712,'DAILY SHIFT','2022-06-11','2022-06-11 07:04:37','2022-06-12 07:04:37','882',0.00,0.00,'882','2022-06-11 20:00:07','882','2022-06-11 20:00:28',10,0),('1','186',257713,'DAILY SHIFT','2022-06-12','2022-06-12 07:07:04','2022-06-13 07:07:04','882',0.00,0.00,'882','2022-06-12 18:50:51','882','2022-06-12 18:51:08',10,0),('1','186',257714,'OPERATIONAL LOSS','2022-06-12','2022-06-12 18:51:47','2022-06-13 18:51:47','882',0.00,0.00,'882','2022-06-12 18:54:56','882','2022-06-12 18:55:18',10,0),('1','186',257715,'DAILY SHIFT','2022-06-14','2022-06-14 12:16:43','2022-06-15 12:16:43','882',0.00,0.00,'882','2022-06-14 18:35:28','882','2022-06-14 18:35:45',10,0),('1','186',257716,'DAILY SHIFT','2022-06-15','2022-06-15 07:23:07','2022-06-16 07:23:07','882',0.00,0.00,'882','2022-06-15 18:36:04','882','2022-06-15 18:36:24',10,0),('1','186',257717,'DAILY SHIFT','2022-06-16','2022-06-16 07:06:39','2022-06-17 07:06:39','882',0.00,0.00,'882','2022-06-16 19:26:21','882','2022-06-16 19:26:44',10,0),('1','186',257718,'OPERATIONAL LOSS','2022-06-16','2022-06-16 19:54:31','2022-06-17 19:54:31','882',0.00,0.00,'882','2022-06-16 19:56:34','882','2022-06-16 19:56:50',10,0),('1','186',257719,'DAILY SHIFT','2022-06-17','2022-06-17 07:05:21','2022-06-18 07:05:21','882',0.00,0.00,'882','2022-06-17 18:53:05','882','2022-06-17 18:53:24',10,0),('1','186',257720,'DAILY SHIFT','2022-06-18','2022-06-18 07:09:13','2022-06-19 07:09:13','882',0.00,0.00,'882','2022-06-18 18:55:01','882','2022-06-18 18:56:05',10,0),('1','186',257721,'DAILY SHIFT','2022-06-19','2022-06-19 06:51:53','2022-06-20 06:51:53','882',0.00,0.00,'882','2022-06-19 19:03:36','882','2022-06-19 19:03:57',10,0),('1','186',257722,'DAILY SHIFT','2022-06-20','2022-06-20 07:11:01','2022-06-21 07:11:01','882',0.00,0.00,'882','2022-06-20 13:32:12','882','2022-06-20 13:32:32',10,0),('1','186',257723,'OPERATIONAL LOSS','2022-06-20','2022-06-20 13:35:31','2022-06-21 13:35:31','882',0.00,0.00,'882','2022-06-20 13:45:39','882','2022-06-20 13:46:05',10,0),('1','186',257724,'DAILY SHIFT','2022-06-20','2022-06-20 14:35:08','2022-06-21 14:35:08','882',0.00,0.00,'882','2022-06-20 19:50:32','882','2022-06-20 19:50:49',10,0),('1','186',257725,'DAILY SHIFT','2022-06-21','2022-06-21 06:56:47','2022-06-22 06:56:47','882',0.00,0.00,'882','2022-06-21 18:30:19','882','2022-06-21 18:30:45',10,0),('1','186',257726,'DAILY SHIFT','2022-06-22','2022-06-22 07:05:29','2022-06-23 07:05:29','882',0.00,0.00,'882','2022-06-22 20:13:20','882','2022-06-22 20:13:42',10,0),('1','186',257727,'OPERATIONAL LOSS','2022-06-23','2022-06-23 10:48:16','2022-06-24 10:48:16','882',0.00,0.00,'882','2022-06-23 10:50:41','882','2022-06-23 10:51:03',10,0),('1','186',257728,'DAILY SHIFT','2022-06-23','2022-06-23 11:01:28','2022-06-24 11:01:28','882',0.00,0.00,'882','2022-06-23 19:44:36','882','2022-06-23 19:45:49',10,0),('1','186',257729,'DAILY SHIFT','2022-06-24','2022-06-24 06:58:39','2022-06-25 06:58:39','882',0.00,0.00,'882','2022-06-24 19:55:28','882','2022-06-24 19:55:47',10,0),('1','186',257730,'DAILY SHIFT','2022-06-25','2022-06-25 07:10:26','2022-06-26 07:10:26','882',0.00,0.00,'882','2022-06-25 18:39:33','882','2022-06-25 18:41:42',10,0),('1','186',257731,'DAILY SHIFT','2022-06-26','2022-06-26 07:05:19','2022-06-27 07:05:19','882',0.00,0.00,'882','2022-06-26 17:10:04','882','2022-06-26 17:10:23',10,0),('1','186',257732,'DAILY SHIFT','2022-06-27','2022-06-27 08:53:22','2022-06-28 08:53:22','882',0.00,0.00,'882','2022-06-27 16:48:36','882','2022-06-27 16:49:03',10,0),('1','186',257733,'DAILY SHIFT','2022-06-28','2022-06-28 10:36:31','2022-06-29 10:36:31','882',0.00,0.00,'882','2022-06-28 10:38:40','882','2022-06-28 10:39:03',10,0),('1','186',257734,'OPRATINAL LOSS','2022-06-28','2022-06-28 10:39:38','2022-06-29 10:39:38','882',0.00,0.00,'882','2022-06-28 10:42:23','882','2022-06-28 10:42:40',10,0),('1','186',257735,'DAILY SHIFT','2022-06-28','2022-06-28 16:20:43','2022-06-29 16:20:43','882',0.00,0.00,'882','2022-06-28 19:30:17','882','2022-06-28 19:30:44',10,0),('1','186',257736,'DAILY SHIFT7','2022-06-29','2022-06-29 07:05:17','2022-06-30 07:05:17','882',0.00,0.00,'882','2022-06-29 19:07:31','882','2022-06-29 19:07:48',10,0),('1','186',257737,'DAILY SHIFT','2022-06-30','2022-06-30 07:07:56','2022-07-01 07:07:56','882',0.00,0.00,'882','2022-06-30 19:26:36','882','2022-06-30 19:27:26',10,0),('1','186',257738,'DAILY SHIFT','2022-07-01','2022-07-01 07:03:41','2022-07-02 07:03:41','882',0.00,0.00,'882','2022-07-01 12:26:22','882','2022-07-01 12:26:43',10,0),('1','186',257739,'OPRATINAL LOSS','2022-07-01','2022-07-01 12:30:32','2022-07-02 12:30:32','882',0.00,0.00,'882','2022-07-01 12:46:39','882','2022-07-01 12:47:38',10,0),('1','186',257740,'DAILY SHIFT','2022-07-01','2022-07-01 12:52:18','2022-07-02 12:52:18','882',0.00,0.00,'882','2022-07-01 19:40:23','882','2022-07-01 19:40:45',10,0),('1','186',257741,'DAILY SHIFT','2022-07-02','2022-07-02 07:16:50','2022-07-03 07:16:50','882',0.00,0.00,'882','2022-07-02 19:50:07','882','2022-07-02 19:50:26',10,0),('1','186',257742,'DAILY SHIFT','2022-07-03','2022-07-03 07:11:38','2022-07-04 07:11:38','882',0.00,0.00,'882','2022-07-03 18:25:39','882','2022-07-03 18:25:58',10,0),('1','186',257743,'OPERATIONAL LOSS','2022-07-03','2022-07-03 19:40:09','2022-07-04 19:40:09','882',0.00,0.00,'882','2022-07-03 19:43:18','882','2022-07-03 19:43:36',10,0),('1','186',257744,'DAILY SHIFT','2022-07-04','2022-07-04 06:55:53','2022-07-05 06:55:53','882',0.00,0.00,'882','2022-07-04 19:56:06','882','2022-07-04 19:56:46',10,0),('1','186',257745,'DAILY SHIFT','2022-07-05','2022-07-05 07:03:47','2022-07-06 07:03:47','882',0.00,0.00,'882','2022-07-05 19:33:59','882','2022-07-05 19:34:19',10,0),('1','186',257746,'DAILY SHIFT','2022-07-06','2022-07-06 07:00:29','2022-07-07 07:00:29','882',0.00,0.00,'882','2022-07-06 13:32:10','882','2022-07-06 13:32:57',10,0),('1','186',257747,'OPERATIONAL LOSS','2022-07-06','2022-07-06 13:36:04','2022-07-07 13:36:04','882',0.00,0.00,'882','2022-07-06 13:41:54','882','2022-07-06 13:42:09',10,0),('1','186',257748,'DAILY SHIFT','2022-07-09','2022-07-09 10:23:50','2022-07-10 10:23:50','882',0.00,0.00,'882','2022-07-09 19:06:48','882','2022-07-09 19:08:13',10,0),('1','186',257749,'DAILY SHIFT','2022-07-10','2022-07-10 07:05:23','2022-07-11 07:05:23','882',0.00,0.00,'882','2022-07-10 19:13:07','882','2022-07-10 19:13:23',10,0),('1','186',257750,'DAILY SHIFT','2022-07-11','2022-07-11 06:58:33','2022-07-12 06:58:33','882',0.00,0.00,'882','2022-07-11 19:38:29','882','2022-07-11 19:39:44',10,0),('1','186',257751,'DAILY SHIFT','2022-07-12','2022-07-12 07:06:07','2022-07-13 07:06:07','882',0.00,0.00,'882','2022-07-12 18:39:08','882','2022-07-12 18:39:27',10,0),('1','186',257752,'OPRATINAL LOSS','2022-07-12','2022-07-12 18:40:22','2022-07-13 18:40:22','882',0.00,0.00,'882','2022-07-12 18:43:36','882','2022-07-12 18:43:49',10,0),('1','186',257753,'DAILY SHIFT','2022-07-13','2022-07-13 08:16:29','2022-07-14 08:16:29','882',0.00,0.00,'882','2022-07-13 19:49:44','882','2022-07-13 19:50:05',10,0),('1','186',257754,'Daily Shift','2022-07-14','2022-07-14 07:29:31','2022-07-15 07:29:31','882',0.00,0.00,'882','2022-07-14 20:18:14','882','2022-07-14 20:18:35',10,0),('1','186',257755,'DAILY SHIFT','2022-07-15','2022-07-15 07:08:48','2022-07-16 07:08:48','882',0.00,0.00,'882','2022-07-15 11:38:25','882','2022-07-15 11:38:43',10,0),('1','186',257756,'OPERATIONAL LOSS','2022-07-15','2022-07-15 11:39:12','2022-07-16 11:39:12','882',0.00,0.00,'882','2022-07-15 11:42:39','882','2022-07-15 11:43:10',10,0),('1','186',257757,'DAILY SHIFT','2022-07-15','2022-07-15 12:06:57','2022-07-16 12:06:57','882',0.00,0.00,'882','2022-07-15 19:58:39','882','2022-07-15 19:58:58',10,0),('1','186',257758,'Daily Shift','2022-07-17','2022-07-17 07:03:10','2022-07-18 07:03:10','882',0.00,0.00,'882','2022-07-17 19:21:12','882','2022-07-17 19:21:42',10,0),('1','186',257759,'DAILY SHIFT','2022-07-18','2022-07-18 07:20:36','2022-07-19 07:20:36','882',0.00,0.00,'882','2022-07-18 11:58:50','882','2022-07-18 11:59:11',10,0),('1','186',257760,'Operational Loss','2022-07-18','2022-07-18 11:59:50','2022-07-19 11:59:50','882',0.00,0.00,'882','2022-07-18 12:03:20','882','2022-07-18 12:03:35',10,0),('1','186',257761,'DAILY SHIFT','2022-07-18','2022-07-18 13:59:17','2022-07-19 13:59:17','882',0.00,0.00,'882','2022-07-18 20:18:22','882','2022-07-18 20:18:48',10,0),('1','186',257762,'Daily Shift','2022-07-19','2022-07-19 07:05:54','2022-07-20 07:05:54','882',0.00,0.00,'882','2022-07-19 18:56:07','882','2022-07-19 18:56:25',10,0),('1','186',257763,'DAILY SHIFT','2022-07-20','2022-07-20 07:03:51','2022-07-21 07:03:51','882',0.00,0.00,'882','2022-07-20 19:01:12','882','2022-07-20 19:01:29',10,0),('1','186',257764,'Daily Shift','2022-07-21','2022-07-21 07:14:19','2022-07-22 07:14:19','882',0.00,0.00,'882','2022-07-21 17:12:22','882','2022-07-21 17:12:41',10,0),('1','186',257765,'OPRATINAL LOSS','2022-07-21','2022-07-21 17:13:41','2022-07-22 17:13:41','882',0.00,0.00,'882','2022-07-21 17:16:17','882','2022-07-21 17:16:47',10,0),('1','186',257766,'Daily Shift','2022-07-22','2022-07-22 07:00:34','2022-07-23 07:00:34','882',0.00,0.00,'882','2022-07-22 19:01:19','882','2022-07-22 19:01:38',10,0),('1','186',257767,'Daily Shift','2022-07-23','2022-07-23 07:06:59','2022-07-24 07:06:59','882',0.00,0.00,'882','2022-07-23 19:01:56','882','2022-07-23 19:02:16',10,0),('1','186',257768,'Daily Shift','2022-07-24','2022-07-24 07:24:35','2022-07-25 07:24:35','882',0.00,0.00,'882','2022-07-24 19:35:06','882','2022-07-24 19:35:47',10,0),('1','186',257769,'Daily Shift','2022-07-25','2022-07-25 07:04:12','2022-07-26 07:04:12','882',0.00,0.00,'882','2022-07-25 15:18:08','882','2022-07-25 15:21:06',10,0),('1','186',257770,'OPERATIONAL LOSS','2022-07-25','2022-07-25 15:21:50','2022-07-26 15:21:50','882',0.00,0.00,'882','2022-07-25 15:23:36','882','2022-07-25 15:23:51',10,0),('1','186',257771,'Daily Shift','2022-07-26','2022-07-26 07:02:12','2022-07-27 07:02:12','882',0.00,0.00,'882','2022-07-26 19:31:54','882','2022-07-26 19:32:11',10,0),('1','186',257772,'Daily Shift','2022-07-27','2022-07-27 07:01:14','2022-07-28 07:01:14','882',0.00,0.00,'882','2022-07-27 19:34:49','882','2022-07-27 19:35:04',10,0),('1','186',257773,'Daily Shift','2022-07-28','2022-07-28 07:09:07','2022-07-29 07:09:07','882',0.00,0.00,'882','2022-07-28 19:10:35','882','2022-07-28 19:11:25',10,0),('1','186',257774,'OPRATINAL LOSS','2022-07-28','2022-07-28 19:12:12','2022-07-29 19:12:12','882',0.00,0.00,'882','2022-07-28 19:14:26','882','2022-07-28 19:14:43',10,0),('1','186',257775,'DAILY SHIFT','2022-07-29','2022-07-29 10:59:57','2022-07-30 10:59:57','882',0.00,0.00,'882','2022-07-29 19:55:03','882','2022-07-29 19:56:02',10,0),('1','186',257776,'Daily Shift','2022-07-30','2022-07-30 07:21:15','2022-07-31 07:21:15','882',0.00,0.00,'882','2022-07-30 18:59:09','882','2022-07-30 19:06:37',10,0),('1','186',257777,'Daily Shift','2022-07-31','2022-07-31 07:01:57','2022-08-01 07:01:57','882',0.00,0.00,'882','2022-07-31 19:05:46','882','2022-07-31 19:06:07',10,0),('1','186',257778,'Daily Shift','2022-08-01','2022-08-01 07:01:10','2022-08-02 07:01:10','882',0.00,0.00,'882','2022-08-01 14:40:12','882','2022-08-01 15:10:28',10,0),('1','186',257779,'OPRATINAL LOSS','2022-08-01','2022-08-01 15:11:00','2022-08-02 15:11:00','882',0.00,0.00,'882','2022-08-01 15:12:35','882','2022-08-01 15:12:52',10,0),('1','186',257780,'DAILY SHIFT','2022-08-01','2022-08-01 15:15:34','2022-08-02 15:15:34','882',0.00,0.00,'882','2022-08-01 19:44:07','882','2022-08-01 19:44:28',10,0),('1','186',257781,'Daily Shift','2022-08-02','2022-08-02 07:01:02','2022-08-03 07:01:02','882',0.00,0.00,'882','2022-08-02 19:43:04','882','2022-08-02 19:43:21',10,0),('1','186',257782,'Daily Shift','2022-08-03','2022-08-03 07:00:18','2022-08-04 07:00:18','882',0.00,0.00,'882','2022-08-03 16:18:12','882','2022-08-03 16:18:30',10,0),('1','186',257783,'OPRATINAL LOSS','2022-08-03','2022-08-03 16:18:56','2022-08-04 16:18:56','882',0.00,0.00,'882','2022-08-03 16:20:51','882','2022-08-03 16:21:23',10,0),('1','186',257784,'Daily Shift','2022-08-04','2022-08-04 10:37:15','2022-08-05 10:37:15','882',0.00,0.00,'882','2022-08-04 21:27:34','882','2022-08-04 21:27:54',10,0),('1','186',257785,'Daily Shift','2022-08-05','2022-08-05 07:22:27','2022-08-06 07:22:27','882',0.00,0.00,'882','2022-08-05 18:59:42','882','2022-08-05 19:00:10',10,0),('1','186',257786,'DAILY SHIFT','2022-08-06','2022-08-06 11:14:45','2022-08-07 11:14:45','882',0.00,0.00,'882','2022-08-06 11:15:44','882','2022-08-06 11:15:59',10,0),('1','186',257787,'OPRATINAL LOSS','2022-08-06','2022-08-06 11:16:22','2022-08-07 11:16:22','882',0.00,0.00,'882','2022-08-06 11:19:04','882','2022-08-06 11:19:26',10,0),('1','186',257788,'DAILY SHIFT','2022-08-06','2022-08-06 12:26:27','2022-08-07 12:26:27','882',0.00,0.00,'882','2022-08-06 21:22:47','882','2022-08-06 21:23:10',10,0),('1','186',257789,'Daily Shift','2022-08-07','2022-08-07 07:09:29','2022-08-08 07:09:29','882',0.00,0.00,'882','2022-08-07 18:35:35','882','2022-08-07 18:37:12',10,0),('1','186',257790,'OPERATIONAL LOSS','2022-08-07','2022-08-07 18:44:00','2022-08-08 18:44:00','882',0.00,0.00,'882','2022-08-07 18:46:25','882','2022-08-07 18:46:39',10,0),('1','186',257791,'DAILY SHIFT','2022-08-07','2022-08-07 20:45:56','2022-08-08 20:45:56','882',0.00,0.00,'882','2022-08-07 20:46:56','882','2022-08-07 20:47:25',10,0),('1','186',257792,'Daily Shift','2022-08-08','2022-08-08 07:08:16','2022-08-09 07:08:16','882',0.00,0.00,'882','2022-08-08 20:04:47','882','2022-08-08 20:05:07',10,0),('1','186',257793,'Daily Shift','2022-08-09','2022-08-09 07:20:22','2022-08-10 07:20:22','882',0.00,0.00,'882','2022-08-09 17:26:33','882','2022-08-09 17:26:52',10,0),('1','186',257794,'OPRATINAL LOSS','2022-08-09','2022-08-09 17:41:16','2022-08-10 17:41:16','882',0.00,0.00,'882','2022-08-09 17:43:17','882','2022-08-09 17:43:35',10,0),('1','186',257795,'DAILY SHIFT','2022-08-10','2022-08-10 07:15:52','2022-08-11 07:15:52','882',0.00,0.00,'882','2022-08-10 19:51:58','882','2022-08-10 19:52:26',10,0),('1','186',257796,'DAILY SHIFT','2022-08-11','2022-08-11 07:01:47','2022-08-12 07:01:47','882',0.00,0.00,'882','2022-08-11 19:25:45','882','2022-08-11 19:26:02',10,0),('1','186',257797,'DAILY SHIFT','2022-08-12','2022-08-12 07:00:01','2022-08-13 07:00:01','882',0.00,0.00,'882','2022-08-12 19:27:47','882','2022-08-12 19:28:06',10,0),('1','186',257798,'DAILY SHIFT','2022-08-13','2022-08-13 07:07:14','2022-08-14 07:07:14','882',0.00,0.00,'882','2022-08-13 09:35:01','882','2022-08-13 09:35:15',10,0),('1','186',257799,'Operational Loss','2022-08-13','2022-08-13 09:35:54','2022-08-14 09:35:54','882',0.00,0.00,'882','2022-08-13 09:38:37','882','2022-08-13 09:39:07',10,0),('1','186',257800,'Daily Shift','2022-08-13','2022-08-13 09:48:52','2022-08-14 09:48:52','882',0.00,0.00,'882','2022-08-13 19:56:40','882','2022-08-13 19:58:26',10,0),('1','186',257801,'DAILY SHIFT','2022-08-14','2022-08-14 07:05:35','2022-08-15 07:05:35','882',0.00,0.00,'882','2022-08-14 20:22:02','882','2022-08-14 20:22:56',10,0),('1','186',257802,'DAILY SHIFT','2022-08-15','2022-08-15 07:09:05','2022-08-16 07:09:05','882',0.00,0.00,'882','2022-08-15 18:41:36','882','2022-08-15 18:42:26',10,0),('1','186',257803,'Operational Loss','2022-08-15','2022-08-15 19:12:25','2022-08-16 19:12:25','882',0.00,0.00,'882','2022-08-15 19:14:48','882','2022-08-15 19:15:08',10,0),('1','186',257804,'Daily Shift','2022-08-16','2022-08-16 12:39:15','2022-08-17 12:39:15','882',0.00,0.00,'882','2022-08-16 12:42:16','882','2022-08-16 12:42:39',10,0),('1','186',257805,'DAILY SHIFT','2022-08-16','2022-08-16 12:47:25','2022-08-17 12:47:25','882',0.00,0.00,'882','2022-08-16 21:30:44','882','2022-08-16 21:30:59',10,0),('1','186',257806,'DAILY SHIFT','2022-08-17','2022-08-17 07:08:23','2022-08-18 07:08:23','882',0.00,0.00,'882','2022-08-17 20:41:17','882','2022-08-17 20:41:38',10,0),('1','186',257807,'DAILY SHIFT','2022-08-18','2022-08-18 07:02:00','2022-08-19 07:02:00','882',0.00,0.00,'882','2022-08-18 18:48:11','882','2022-08-18 18:48:35',10,0),('1','186',257808,'OPERATIONAL LOSS','2022-08-18','2022-08-18 18:56:50','2022-08-19 18:56:50','882',0.00,0.00,'882','2022-08-18 19:00:09','882','2022-08-18 19:00:36',10,0),('1','186',257809,'DAILY SHIFT','2022-08-19','2022-08-19 06:55:13','2022-08-20 06:55:13','882',0.00,0.00,'882','2022-08-19 20:18:33','882','2022-08-19 20:19:06',10,0),('1','186',257810,'DAILY SHIFT','2022-08-20','2022-08-20 07:11:22','2022-08-21 07:11:22','882',0.00,0.00,'882','2022-08-20 22:10:35','882','2022-08-20 22:10:54',10,0),('1','186',257811,'DAILY SHIFT','2022-08-21','2022-08-21 07:01:35','2022-08-22 07:01:35','882',0.00,0.00,'882','2022-08-21 19:30:31','882','2022-08-21 19:30:53',10,0),('1','186',257812,'DAILY SHIFT','2022-08-22','2022-08-22 07:20:04','2022-08-23 07:20:04','882',0.00,0.00,'882','2022-08-22 19:09:46','882','2022-08-22 19:10:05',10,0),('1','186',257813,'OPERATIONAL LOSS','2022-08-22','2022-08-22 19:13:32','2022-08-23 19:13:32','882',0.00,0.00,'882','2022-08-23 08:29:03','882','2022-08-23 08:29:21',10,0),('1','186',257814,'DAILY SHIFT','2022-08-23','2022-08-23 08:34:17','2022-08-24 08:34:17','882',0.00,0.00,'882','2022-08-23 19:31:44','882','2022-08-23 19:32:34',10,0),('1','186',257815,'DAILY SHIFT','2022-08-24','2022-08-24 07:00:55','2022-08-25 07:00:55','882',0.00,0.00,'882','2022-08-24 19:49:25','882','2022-08-24 19:49:48',10,0),('1','186',257816,'DAILY SHIFT','2022-08-25','2022-08-25 06:58:01','2022-08-26 06:58:01','882',0.00,0.00,'882','2022-08-25 16:04:22','882','2022-08-25 16:05:00',10,0),('1','186',257817,'OPRATINAL LOSS','2022-08-25','2022-08-25 16:06:28','2022-08-26 16:06:28','882',0.00,0.00,'882','2022-08-25 16:10:34','882','2022-08-25 16:10:57',10,0),('1','186',257818,'DAILY SHIFT','2022-08-25','2022-08-25 16:56:36','2022-08-26 16:56:36','882',0.00,0.00,'882','2022-08-25 19:14:37','882','2022-08-25 19:16:14',10,0),('1','186',257819,'DAILY SHIFT','2022-08-26','2022-08-26 07:16:49','2022-08-27 07:16:49','882',0.00,0.00,'882','2022-08-26 18:56:25','882','2022-08-26 18:56:46',10,0),('1','186',257820,'DAILY SHIFT','2022-08-27','2022-08-27 06:58:05','2022-08-28 06:58:05','882',0.00,0.00,'882','2022-08-27 19:15:20','882','2022-08-27 19:15:44',10,0),('1','186',257821,'DAILY SHIFT','2022-08-28','2022-08-28 07:12:22','2022-08-29 07:12:22','882',0.00,0.00,'882','2022-08-28 18:33:19','882','2022-08-28 18:34:10',10,0),('1','186',257822,'OPERATIONAL LOSS','2022-08-28','2022-08-28 18:52:18','2022-08-29 18:52:18','882',0.00,0.00,'882','2022-08-28 18:54:59','882','2022-08-28 18:55:15',10,0),('1','186',257823,'DAILY SHIFT','2022-08-29','2022-08-29 08:27:10','2022-08-30 08:27:10','882',0.00,0.00,'882','2022-08-29 19:32:26','882','2022-08-29 19:35:26',10,0),('1','186',257824,'DAILY SHIFT','2022-08-30','2022-08-30 07:02:01','2022-08-31 07:02:01','882',0.00,0.00,'882','2022-08-30 19:01:50','882','2022-08-30 19:02:12',10,0),('1','186',257825,'DAILY SHIFT','2022-08-31','2022-08-31 07:18:28','2022-09-01 07:18:28','882',0.00,0.00,'882','2022-08-31 19:59:39','882','2022-08-31 20:00:27',10,0),('1','186',257826,'DAILY SHIFT','2022-09-01','2022-09-01 07:11:27','2022-09-02 07:11:27','882',0.00,0.00,'882','2022-09-01 08:29:22','882','2022-09-01 08:29:38',10,0),('1','186',257827,'OPERATIONAL LOSS','2022-09-01','2022-09-01 08:29:59','2022-09-02 08:29:59','882',0.00,0.00,'882','2022-09-01 08:32:41','882','2022-09-01 08:32:57',10,0),('1','186',257828,'DAILY SHIFT','2022-09-01','2022-09-01 09:30:28','2022-09-02 09:30:28','882',0.00,0.00,'882','2022-09-01 20:28:56','882','2022-09-01 20:29:13',10,0),('1','186',257829,'DAILY SHIFT','2022-09-02','2022-09-02 07:05:22','2022-09-03 07:05:22','882',0.00,0.00,'882','2022-09-02 20:29:29','882','2022-09-02 20:30:04',10,0),('1','186',257830,'DAILY SHIFT','2022-09-03','2022-09-03 07:05:50','2022-09-04 07:05:50','882',0.00,0.00,'882','2022-09-03 16:10:13','882','2022-09-03 16:12:23',10,0),('1','186',257831,'Operational Loss','2022-09-03','2022-09-03 17:17:52','2022-09-04 17:17:52','882',0.00,0.00,'882','2022-09-03 17:21:51','882','2022-09-03 17:22:09',10,0),('1','186',257832,'DAILY SHIFT','2022-09-04','2022-09-04 07:00:56','2022-09-05 07:00:56','882',0.00,0.00,'882','2022-09-04 20:10:11','882','2022-09-04 20:10:37',10,0),('1','186',257833,'DAILY SHIFT','2022-09-05','2022-09-05 07:06:45','2022-09-06 07:06:45','882',0.00,0.00,'882','2022-09-05 18:59:50','882','2022-09-05 19:00:06',10,0),('1','186',257834,'DAILY SHIFT','2022-09-06','2022-09-06 07:11:28','2022-09-07 07:11:28','882',0.00,0.00,'882','2022-09-06 12:44:45','882','2022-09-06 12:45:04',10,0),('1','186',257835,'OPERATIONAL LOSS','2022-09-06','2022-09-06 12:45:33','2022-09-07 12:45:33','882',0.00,0.00,'882','2022-09-06 12:47:30','882','2022-09-06 12:47:44',10,0),('1','186',257836,'DAILY SHIFT','2022-09-06','2022-09-06 12:50:59','2022-09-07 12:50:59','882',0.00,0.00,'882','2022-09-06 19:42:10','882','2022-09-06 19:42:38',10,0),('1','186',257837,'DAILY SHIFT','2022-09-07','2022-09-07 06:57:15','2022-09-08 06:57:15','882',0.00,0.00,'882','2022-09-07 20:21:47','882','2022-09-07 20:22:18',10,0),('1','186',257838,'DAILY SHIFT','2022-09-08','2022-09-08 07:12:56','2022-09-09 07:12:56','882',0.00,0.00,'882','2022-09-08 19:06:52','882','2022-09-08 19:07:12',10,0),('1','186',257839,'DAILY SHIFT','2022-09-09','2022-09-09 07:01:13','2022-09-10 07:01:13','882',0.00,0.00,'882','2022-09-09 11:36:11','882','2022-09-09 11:37:09',10,0),('1','186',257840,'OPERATIONAL LOSS','2022-09-09','2022-09-09 11:46:26','2022-09-10 11:46:26','882',0.00,0.00,'882','2022-09-09 11:49:35','882','2022-09-09 11:49:53',10,0),('1','186',257841,'DAILY SHIFT','2022-09-10','2022-09-10 12:33:19','2022-09-11 12:33:19','882',0.00,0.00,'882','2022-09-10 18:41:45','882','2022-09-10 18:42:11',10,0),('1','186',257842,'DAILY SHIFT','2022-09-11','2022-09-11 07:08:58','2022-09-12 07:08:58','882',0.00,0.00,'882','2022-09-11 18:54:42','882','2022-09-11 18:55:09',10,0),('1','186',257843,'DAILY SHIFT','2022-09-12','2022-09-12 07:07:51','2022-09-13 07:07:51','882',0.00,0.00,'882','2022-09-12 19:18:07','882','2022-09-12 19:18:33',10,0),('1','186',257844,'DAILY SHIFT','2022-09-13','2022-09-13 07:21:16','2022-09-14 07:21:16','882',0.00,0.00,'882','2022-09-13 11:53:12','882','2022-09-13 11:53:28',10,0),('1','186',257845,'OPERATIONAL LOSS','2022-09-13','2022-09-13 12:32:18','2022-09-14 12:32:18','882',0.00,0.00,'882','2022-09-13 12:34:16','882','2022-09-13 12:34:30',10,0),('1','186',257846,'DAILY SHIFT','2022-09-13','2022-09-13 12:44:27','2022-09-14 12:44:27','882',0.00,0.00,'882','2022-09-13 19:44:20','882','2022-09-13 19:45:03',10,0),('1','186',257847,'DAILY SHIFT','2022-09-14','2022-09-14 07:04:03','2022-09-15 07:04:03','882',0.00,0.00,'882','2022-09-14 19:51:21','882','2022-09-14 19:51:48',10,0),('1','186',257848,'DAILY SHIFT','2022-09-15','2022-09-15 06:57:22','2022-09-16 06:57:22','882',0.00,0.00,'882','2022-09-15 19:10:28','882','2022-09-15 19:10:48',10,0),('1','186',257849,'DAILY SHIFT','2022-09-16','2022-09-16 07:08:43','2022-09-17 07:08:43','882',0.00,0.00,'882','2022-09-16 10:27:45','882','2022-09-16 10:28:17',10,0),('1','186',257850,'Operational Loss','2022-09-16','2022-09-16 10:28:45','2022-09-17 10:28:45','882',0.00,0.00,'882','2022-09-16 18:53:14','882','2022-09-16 18:55:05',10,0),('1','186',257851,'DAILY SHIFT','2022-09-18','2022-09-18 10:39:14','2022-09-19 10:39:14','882',0.00,0.00,'882','2022-09-18 19:58:26','882','2022-09-18 19:59:02',10,0),('1','186',257852,'DAILY SHIFT','2022-09-19','2022-09-19 07:06:39','2022-09-20 07:06:39','882',0.00,0.00,'882','2022-09-19 19:18:38','882','2022-09-19 19:18:56',10,0),('1','186',257853,'DAILY SHIFT','2022-09-20','2022-09-20 07:13:20','2022-09-21 07:13:20','882',0.00,0.00,'882','2022-09-20 12:56:44','882','2022-09-20 12:57:49',10,0),('1','186',257854,'OPERATIONAL LOSS','2022-09-20','2022-09-20 13:50:22','2022-09-21 13:50:22','882',0.00,0.00,'882','2022-09-20 13:52:07','882','2022-09-20 13:52:22',10,0),('1','186',257855,'DAILY SHIFT','2022-09-20','2022-09-20 15:09:42','2022-09-21 15:09:42','882',0.00,0.00,'882','2022-09-20 20:27:34','882','2022-09-20 20:28:09',10,0),('1','186',257856,'DAILY SHIFT','2022-09-21','2022-09-21 07:07:23','2022-09-22 07:07:23','882',0.00,0.00,'882','2022-09-21 20:11:24','882','2022-09-21 20:12:02',10,0),('1','186',257857,'DAILY SHIFT','2022-09-22','2022-09-22 07:09:35','2022-09-23 07:09:35','882',0.00,0.00,'882','2022-09-22 19:14:46','882','2022-09-22 19:15:06',10,0),('1','186',257858,'DAILY SHIFT','2022-09-23','2022-09-23 06:50:18','2022-09-24 06:50:18','882',0.00,0.00,'882','2022-09-23 13:07:36','882','2022-09-23 13:07:59',10,0),('1','186',257859,'OPERATIONAL LOSS','2022-09-23','2022-09-23 13:10:24','2022-09-24 13:10:24','882',0.00,0.00,'882','2022-09-23 13:13:20','882','2022-09-23 13:13:35',10,0),('1','186',257860,'DAILY SHIFT','2022-09-23','2022-09-23 14:30:02','2022-09-24 14:30:02','882',0.00,0.00,'882','2022-09-23 19:39:58','882','2022-09-23 19:40:38',10,0),('1','186',257861,'DAILY SHIFT','2022-09-24','2022-09-24 06:59:15','2022-09-25 06:59:15','882',0.00,0.00,'882','2022-09-24 18:57:17','882','2022-09-24 18:57:39',10,0),('1','186',257862,'DAILY SHIFT','2022-09-25','2022-09-25 06:59:57','2022-09-26 06:59:57','882',0.00,0.00,'882','2022-09-25 18:42:51','882','2022-09-25 18:43:08',10,0),('1','186',257863,'DAILY SHIFT','2022-09-26','2022-09-26 07:03:28','2022-09-27 07:03:28','882',0.00,0.00,'882','2022-09-26 15:33:12','882','2022-09-26 15:33:29',10,0),('1','186',257864,'OPERATIONAL LOSS','2022-09-26','2022-09-26 15:35:08','2022-09-27 15:35:08','882',0.00,0.00,'882','2022-09-26 15:36:53','882','2022-09-26 15:37:11',10,0),('1','186',257865,'DAILY SHIFT','2022-09-26','2022-09-26 16:44:52','2022-09-27 16:44:52','882',0.00,0.00,'882','2022-09-26 19:01:30','882','2022-09-26 19:01:46',10,0),('1','186',257866,'DAILY SHIFT','2022-09-27','2022-09-27 07:10:40','2022-09-28 07:10:40','882',0.00,0.00,'882','2022-09-27 21:28:01','882','2022-09-27 21:28:21',10,0),('1','186',257867,'DAILY SHIFT','2022-09-28','2022-09-28 07:07:06','2022-09-29 07:07:06','882',0.00,0.00,'882','2022-09-28 18:53:05','882','2022-09-28 18:53:24',10,0),('1','186',257868,'DAILY SHIFT','2022-09-29','2022-09-29 07:05:03','2022-09-30 07:05:03','882',0.00,0.00,'882','2022-09-29 19:24:20','882','2022-09-29 19:24:40',10,0),('1','186',257869,'DAILY SHIFT','2022-09-30','2022-09-30 07:49:55','2022-10-01 07:49:55','882',0.00,0.00,'882','2022-09-30 07:51:54','882','2022-09-30 07:52:09',10,0),('1','186',257870,'OPERATIONAL LOSS','2022-09-30','2022-09-30 07:58:45','2022-10-01 07:58:45','882',0.00,0.00,'882','2022-09-30 08:01:14','882','2022-09-30 08:01:31',10,0),('1','186',257871,'DAILY SHIFT','2022-09-30','2022-09-30 08:13:12','2022-10-01 08:13:12','882',0.00,0.00,'882','2022-09-30 19:05:21','882','2022-09-30 19:05:39',10,0),('1','186',257872,'DAILY SHIFT','2022-10-01','2022-10-01 07:16:33','2022-10-02 07:16:33','882',0.00,0.00,'882','2022-10-01 19:18:30','882','2022-10-01 19:20:06',10,0),('1','186',257873,'DAILY SHIFT','2022-10-02','2022-10-02 07:29:41','2022-10-03 07:29:41','882',0.00,0.00,'882','2022-10-02 19:10:27','882','2022-10-02 19:10:43',10,0),('1','186',257874,'DAILY SHIFT','2022-10-03','2022-10-03 07:22:33','2022-10-04 07:22:33','882',0.00,0.00,'882','2022-10-03 09:59:31','882','2022-10-03 09:59:49',10,0),('1','186',257875,'OPERATIONAL LOSS','2022-10-03','2022-10-03 10:00:30','2022-10-04 10:00:30','882',0.00,0.00,'882','2022-10-03 10:04:31','882','2022-10-03 10:04:46',10,0),('1','186',257876,'DAILY SHIFT','2022-10-04','2022-10-04 09:08:20','2022-10-05 09:08:20','882',0.00,0.00,'882','2022-10-04 20:12:41','882','2022-10-04 20:12:56',10,0),('1','186',257877,'DAILY SHIFT','2022-10-05','2022-10-05 07:09:57','2022-10-06 07:09:57','882',0.00,0.00,'882','2022-10-05 19:48:43','882','2022-10-05 19:49:02',10,0),('1','186',257878,'DAILY SHIFT','2022-10-06','2022-10-06 07:14:56','2022-10-07 07:14:56','882',0.00,0.00,'882','2022-10-06 17:33:10','882','2022-10-06 17:33:32',10,0),('1','186',257879,'DAILY SHIFT','2022-10-07','2022-10-07 08:01:34','2022-10-08 08:01:34','882',0.00,0.00,'882','2022-10-07 08:36:15','882','2022-10-07 08:37:03',10,0),('1','186',257880,'OPERATIONAL LOSS','2022-10-07','2022-10-07 14:19:00','2022-10-08 14:19:00','882',0.00,0.00,'882','2022-10-07 14:23:49','882','2022-10-07 14:24:09',10,0),('1','186',257881,'DAILY SHIFT','2022-10-07','2022-10-07 14:27:06','2022-10-08 14:27:06','882',0.00,0.00,'882','2022-10-07 21:03:08','882','2022-10-07 21:04:35',10,0),('1','186',257882,'DAILY SHIFT','2022-10-08','2022-10-08 08:44:19','2022-10-09 08:44:19','882',0.00,0.00,'882','2022-10-08 20:24:23','882','2022-10-08 20:24:40',10,0),('1','186',257883,'DAILY SHIFT','2022-10-09','2022-10-09 07:07:40','2022-10-10 07:07:40','882',0.00,0.00,'882','2022-10-09 19:51:19','882','2022-10-09 19:52:04',10,0),('1','186',257884,'DAILY SHIFT','2022-10-10','2022-10-10 07:05:24','2022-10-11 07:05:24','882',0.00,0.00,'882','2022-10-10 10:20:26','882','2022-10-10 10:20:43',10,0),('1','186',257885,'OPERATIONAL LOSS','2022-10-10','2022-10-10 10:21:06','2022-10-11 10:21:06','882',0.00,0.00,'882','2022-10-10 10:23:04','882','2022-10-10 10:23:19',10,0),('1','186',257886,'DAILY SHIFT','2022-10-10','2022-10-10 10:27:18','2022-10-11 10:27:18','882',0.00,0.00,'882','2022-10-10 20:49:09','882','2022-10-10 20:49:27',10,0),('1','186',257887,'DAILY SHIFT','2022-10-11','2022-10-11 07:47:12','2022-10-12 07:47:12','882',0.00,0.00,'882','2022-10-11 21:54:40','882','2022-10-11 21:55:03',10,0),('1','186',257888,'DAILY SHIFT','2022-10-12','2022-10-12 16:33:19','2022-10-13 16:33:19','882',0.00,0.00,'882','2022-10-12 16:34:45','882','2022-10-12 16:35:40',10,0),('1','186',257889,'OPERATIONAL LOSS','2022-10-12','2022-10-12 16:37:52','2022-10-13 16:37:52','882',0.00,0.00,'882','2022-10-12 16:40:56','882','2022-10-12 16:41:13',10,0),('1','186',257890,'DAILY SHIFT','2022-10-13','2022-10-13 09:07:39','2022-10-14 09:07:39','882',0.00,0.00,'882','2022-10-13 19:13:08','882','2022-10-13 19:13:32',10,0),('1','186',257891,'DAILY SHIFT','2022-10-14','2022-10-14 07:30:53','2022-10-15 07:30:53','882',0.00,0.00,'882','2022-10-14 20:18:06','882','2022-10-14 20:29:24',10,0),('1','186',257892,'DAILY SHIFT','2022-10-16','2022-10-16 07:05:16','2022-10-17 07:05:16','882',0.00,0.00,'882','2022-10-16 16:47:12','882','2022-10-16 16:47:29',10,0),('1','186',257893,'OPERATIONAL LOSS','2022-10-16','2022-10-16 16:56:33','2022-10-17 16:56:33','882',0.00,0.00,'882','2022-10-16 16:58:58','882','2022-10-16 16:59:33',10,0),('1','186',257894,'DAILY SHIFT','2022-10-17','2022-10-17 10:14:43','2022-10-18 10:14:43','882',0.00,0.00,'882','2022-10-17 19:38:57','882','2022-10-17 19:39:14',10,0),('1','186',257895,'DAILY SHIFT','2022-10-18','2022-10-18 07:12:12','2022-10-19 07:12:12','882',0.00,0.00,'882','2022-10-18 20:06:41','882','2022-10-18 20:07:07',10,0),('1','186',257896,'OPERATIONAL LOSS','2022-10-18','2022-10-18 20:07:32','2022-10-19 20:07:32','882',0.00,0.00,'882','2022-10-18 20:11:42','882','2022-10-18 20:11:59',10,0),('1','186',257897,'DAILY SHIFT','2022-10-19','2022-10-19 07:00:50','2022-10-20 07:00:50','882',0.00,0.00,'882','2022-10-19 21:33:49','882','2022-10-19 21:34:21',10,0),('1','186',257898,'DAILY SHIFT','2022-10-20','2022-10-20 07:19:20','2022-10-21 07:19:20','882',0.00,0.00,'882','2022-10-20 19:20:27','882','2022-10-20 19:21:25',10,0),('1','186',257899,'DAILY SHIFT','2022-10-21','2022-10-21 07:03:56','2022-10-22 07:03:56','882',0.00,0.00,'882','2022-10-21 10:26:00','882','2022-10-21 10:26:25',10,0),('1','186',257900,'OPERATIONAL LOSS','2022-10-21','2022-10-21 10:26:55','2022-10-22 10:26:55','882',0.00,0.00,'882','2022-10-21 10:29:26','882','2022-10-21 10:29:48',10,0),('1','186',257901,'DAILY SHIFT','2022-10-21','2022-10-21 11:34:39','2022-10-22 11:34:39','882',0.00,0.00,'882','2022-10-21 20:25:34','882','2022-10-21 20:26:08',10,0),('1','186',257902,'DAILY SHIFT','2022-10-22','2022-10-22 07:11:19','2022-10-23 07:11:19','882',0.00,0.00,'882','2022-10-22 18:56:14','882','2022-10-22 18:56:34',10,0),('1','186',257903,'DAILY SHIFT','2022-10-23','2022-10-23 07:13:48','2022-10-24 07:13:48','882',0.00,0.00,'882','2022-10-23 19:13:41','882','2022-10-23 19:14:02',10,0),('1','186',257904,'DAILY SHIFT','2022-10-24','2022-10-24 07:05:14','2022-10-25 07:05:14','882',0.00,0.00,'882','2022-10-24 14:23:24','882','2022-10-24 14:24:03',10,0),('1','186',257905,'OPERATIONAL LOSS','2022-10-24','2022-10-24 14:43:00','2022-10-25 14:43:00','882',0.00,0.00,'882','2022-10-24 14:46:13','882','2022-10-24 14:46:34',10,0),('1','186',257906,'DAILY SHIFT','2022-10-24','2022-10-24 15:02:46','2022-10-25 15:02:46','882',0.00,0.00,'882','2022-10-24 19:16:02','882','2022-10-24 19:16:21',10,0),('1','186',257907,'DAILY SHIFT','2022-10-25','2022-10-25 07:26:28','2022-10-26 07:26:28','882',0.00,0.00,'882','2022-10-25 19:10:37','882','2022-10-25 19:10:55',10,0),('1','186',257908,'DAILY SHIFT','2022-10-26','2022-10-26 07:14:13','2022-10-27 07:14:13','882',0.00,0.00,'882','2022-10-26 19:16:22','882','2022-10-26 19:19:05',10,0),('1','186',257909,'DAILY SHIFT','2022-10-27','2022-10-27 07:06:07','2022-10-28 07:06:07','882',0.00,0.00,'882','2022-10-27 08:46:47','882','2022-10-27 08:47:07',10,0),('1','186',257910,'OPERATIONAL LOSS','2022-10-27','2022-10-27 09:29:09','2022-10-28 09:29:09','882',0.00,0.00,'882','2022-10-27 09:32:14','882','2022-10-27 09:32:31',10,0),('1','186',257911,'DAILY SHIFT','2022-10-27','2022-10-27 09:34:59','2022-10-28 09:34:59','882',0.00,0.00,'882','2022-10-27 18:53:38','882','2022-10-27 18:53:55',10,0),('1','186',257912,'DAILY SHIFT','2022-10-28','2022-10-28 07:41:43','2022-10-29 07:41:43','882',0.00,0.00,'882','2022-10-28 19:18:09','882','2022-10-28 19:21:06',10,0),('1','186',257913,'DAILY SHIFT','2022-10-29','2022-10-29 07:10:03','2022-10-30 07:10:03','882',0.00,0.00,'882','2022-10-29 20:09:27','882','2022-10-29 20:10:00',10,0),('1','186',257914,'DAILY SHIFT','2022-10-30','2022-10-30 07:01:06','2022-10-31 07:01:06','882',0.00,0.00,'882','2022-10-30 10:40:08','882','2022-10-30 10:40:37',10,0),('1','186',257915,'OPERATIONAL LOSS','2022-10-30','2022-10-30 10:42:19','2022-10-31 10:42:19','882',0.00,0.00,'882','2022-10-30 10:47:37','882','2022-10-30 10:48:04',10,0),('1','186',257916,'DAILY SHIFT','2022-10-30','2022-10-30 11:44:44','2022-10-31 11:44:44','882',0.00,0.00,'882','2022-10-30 19:08:03','882','2022-10-30 19:08:28',10,0),('1','186',257917,'DAILY SHIFT','2022-10-31','2022-10-31 07:07:32','2022-11-01 07:07:32','882',0.00,0.00,'882','2022-10-31 19:31:31','882','2022-10-31 19:46:01',10,0),('1','186',257918,'DAILY SHIFT','2022-11-01','2022-11-01 07:18:08','2022-11-02 07:18:08','882',0.00,0.00,'882','2022-11-01 11:54:45','882','2022-11-01 11:55:12',10,0),('1','186',257919,'DAILY SHIFT','2022-11-02','2022-11-02 08:30:04','2022-11-03 08:30:04','882',0.00,0.00,'882','2022-11-02 08:34:07','882','2022-11-02 08:34:38',10,0),('1','186',257920,'OPERATIONAL LOSS','2022-11-03','2022-11-03 11:29:43','2022-11-04 11:29:43','882',0.00,0.00,'882','2022-11-03 11:32:20','882','2022-11-03 11:33:01',10,0),('1','186',257921,'DAILY SHIFT','2022-11-03','2022-11-03 12:24:17','2022-11-04 12:24:17','882',0.00,0.00,'882','2022-11-03 19:11:39','882','2022-11-03 19:19:34',10,0),('1','186',257922,'DAILY SHIFT','2022-11-04','2022-11-04 07:34:40','2022-11-05 07:34:40','882',0.00,0.00,'882','2022-11-04 19:10:31','882','2022-11-04 19:10:52',10,0),('1','186',257923,'DAILY SHIFT','2022-11-05','2022-11-05 07:52:55','2022-11-06 07:52:55','882',0.00,0.00,'882','2022-11-05 19:42:43','882','2022-11-05 19:43:14',10,0),('1','186',257924,'DAILY SHIFT','2022-11-06','2022-11-06 07:48:40','2022-11-07 07:48:40','882',0.00,0.00,'882','2022-11-06 11:45:37','882','2022-11-06 11:46:27',10,0),('1','186',257925,'OPERATIONAL LOSS','2022-11-06','2022-11-06 12:02:10','2022-11-07 12:02:10','882',0.00,0.00,'882','2022-11-06 12:16:45','882','2022-11-06 12:17:08',10,0),('1','186',257926,'DAILY SHIFT','2022-11-06','2022-11-06 13:17:05','2022-11-07 13:17:05','882',0.00,0.00,'882','2022-11-06 19:52:37','882','2022-11-06 19:53:02',10,0),('1','186',257927,'DAILY SHIFT','2022-11-07','2022-11-07 07:03:33','2022-11-08 07:03:33','882',0.00,0.00,'882','2022-11-07 19:31:11','882','2022-11-07 19:31:38',10,0),('1','186',257928,'DAILY SHIFT','2022-11-08','2022-11-08 07:20:20','2022-11-09 07:20:20','882',0.00,0.00,'882','2022-11-08 19:14:01','882','2022-11-08 19:14:20',10,0),('1','186',257929,'DAILY SHIFT','2022-11-09','2022-11-09 07:18:54','2022-11-10 07:18:54','882',0.00,0.00,'882','2022-11-09 11:41:05','882','2022-11-09 11:41:40',10,0),('1','186',257930,'OPERATIONAL LOSS','2022-11-09','2022-11-09 11:42:08','2022-11-10 11:42:08','882',0.00,0.00,'882','2022-11-09 11:44:53','882','2022-11-09 11:45:13',10,0),('1','186',257931,'DAILY SHIFT','2022-11-09','2022-11-09 12:40:55','2022-11-10 12:40:55','882',0.00,0.00,'882','2022-11-09 19:03:50','882','2022-11-09 19:04:15',10,0),('1','186',257932,'DAILY SHIFT','2022-11-10','2022-11-10 06:54:32','2022-11-11 06:54:32','882',0.00,0.00,'882','2022-11-10 20:18:48','882','2022-11-10 20:19:11',10,0),('1','186',257933,'DAILY SHIFT','2022-11-11','2022-11-11 07:07:28','2022-11-12 07:07:28','882',0.00,0.00,'882','2022-11-11 19:15:52','882','2022-11-11 19:16:32',10,0),('1','186',257934,'DAILY SHIFT','2022-11-12','2022-11-12 07:04:52','2022-11-13 07:04:52','882',0.00,0.00,'882','2022-11-12 10:18:45','882','2022-11-12 10:19:11',10,0),('1','186',257935,'OPERATIONAL LOSS','2022-11-12','2022-11-12 10:29:53','2022-11-13 10:29:53','882',0.00,0.00,'882','2022-11-12 10:33:56','882','2022-11-12 10:34:13',10,0),('1','186',257936,'DAILY SHIFT','2022-11-12','2022-11-12 10:38:59','2022-11-13 10:38:59','882',0.00,0.00,'882','2022-11-12 19:16:09','882','2022-11-12 19:16:28',10,0),('1','186',257937,'DAILY SHIFT','2022-11-13','2022-11-13 07:07:07','2022-11-14 07:07:07','882',0.00,0.00,'882','2022-11-13 18:50:37','882','2022-11-13 18:50:56',10,0),('1','186',257938,'DAILY SHIFT','2022-11-14','2022-11-14 07:12:30','2022-11-15 07:12:30','882',0.00,0.00,'882','2022-11-14 17:40:38','882','2022-11-14 17:41:03',10,0),('1','186',257939,'OPERATIONAL LOSS','2022-11-14','2022-11-14 17:42:09','2022-11-15 17:42:09','882',0.00,0.00,'882','2022-11-14 17:49:59','882','2022-11-14 17:50:21',10,0),('1','186',257940,'DAILY SHIFT','2022-11-15','2022-11-15 12:14:35','2022-11-16 12:14:35','882',0.00,0.00,'882','2022-11-15 18:53:54','882','2022-11-15 18:54:25',10,0),('1','186',257941,'DAILY SHIFT','2022-11-16','2022-11-16 07:08:23','2022-11-17 07:08:23','882',0.00,0.00,'882','2022-11-16 19:38:47','882','2022-11-16 19:39:09',10,0),('1','186',257942,'DAILY SHIFT','2022-11-17','2022-11-17 07:07:29','2022-11-18 07:07:29','882',0.00,0.00,'882','2022-11-17 19:30:22','882','2022-11-17 19:30:40',10,0),('1','186',257943,'DAILY SHIFT','2022-11-18','2022-11-18 07:09:00','2022-11-19 07:09:00','882',0.00,0.00,'882','2022-11-18 17:10:56','882','2022-11-18 17:11:28',10,0),('1','186',257944,'OPERATIONAL LOSS','2022-11-18','2022-11-18 17:34:20','2022-11-19 17:34:20','882',0.00,0.00,'882','2022-11-18 17:39:42','882','2022-11-18 17:40:08',10,0),('1','186',257945,'DAILY SHIFT','2022-11-21','2022-11-21 07:07:53','2022-11-22 07:07:53','882',0.00,0.00,'882','2022-11-21 20:14:55','882','2022-11-21 20:15:25',10,0),('1','186',257946,'DAILY SHIFT','2022-11-22','2022-11-22 07:07:47','2022-11-23 07:07:47','882',0.00,0.00,'882','2022-11-22 15:59:45','882','2022-11-22 16:00:07',10,0),('1','186',257947,'OPERATIONAL LOSS','2022-11-22','2022-11-22 16:02:06','2022-11-23 16:02:06','882',0.00,0.00,'882','2022-11-22 16:04:03','882','2022-11-22 16:04:21',10,0),('1','186',257948,'DAILY SHIFT','2022-11-22','2022-11-22 16:09:44','2022-11-23 16:09:44','882',0.00,0.00,'882','2022-11-22 18:47:10','882','2022-11-22 18:47:33',10,0),('1','186',257949,'DAILY SHIFT','2022-11-23','2022-11-23 07:04:18','2022-11-24 07:04:18','882',0.00,0.00,'882','2022-11-23 18:58:12','882','2022-11-23 18:59:10',10,0),('1','186',257950,'DAILY SHIFT','2022-11-24','2022-11-24 07:02:33','2022-11-25 07:02:33','882',0.00,0.00,'882','2022-11-24 19:04:40','882','2022-11-24 19:05:02',10,0),('1','186',257951,'DAILY SHIFT','2022-11-25','2022-11-25 07:05:20','2022-11-26 07:05:20','882',0.00,0.00,'882','2022-11-25 19:19:04','882','2022-11-25 19:19:30',10,0),('1','186',257952,'DAILY SHIFT','2022-11-26','2022-11-26 07:01:36','2022-11-27 07:01:36','882',0.00,0.00,'882','2022-11-26 18:04:25','882','2022-11-26 18:04:52',10,0),('1','186',257953,'OPERATIONAL LOSS','2022-11-26','2022-11-26 18:17:39','2022-11-27 18:17:39','882',0.00,0.00,'882','2022-11-26 18:20:43','882','2022-11-26 18:21:05',10,0),('1','186',257954,'DAILY SHIFT','2022-11-28','2022-11-28 07:02:52','2022-11-29 07:02:52','882',0.00,0.00,'882','2022-11-28 19:41:04','882','2022-11-28 19:41:40',10,0),('1','186',257955,'DAILY SHIFT','2022-11-29','2022-11-29 06:58:49','2022-11-30 06:58:49','882',0.00,0.00,'882','2022-11-29 18:44:32','882','2022-11-29 18:44:57',10,0),('1','186',257956,'OPERATIONAL LOSS','2022-11-29','2022-11-29 19:27:04','2022-11-30 19:27:04','882',0.00,0.00,'882','2022-11-29 19:27:24','882','2022-11-29 19:28:25',10,0),('1','186',257957,'OPERATIONAL LOSS','2022-11-29','2022-11-29 19:28:42','2022-11-30 19:28:42','882',0.00,0.00,'882','2022-11-29 19:30:54','882','2022-11-29 19:31:34',10,0),('1','186',257958,'DAILY SHIFT','2022-11-30','2022-11-30 06:51:27','2022-12-01 06:51:27','882',0.00,0.00,'882','2022-11-30 19:00:34','882','2022-11-30 19:02:42',10,0),('1','186',257959,'DAILY SHIFT','2022-12-01','2022-12-01 07:10:07','2022-12-02 07:10:07','882',0.00,0.00,'882','2022-12-01 19:00:13','882','2022-12-01 19:00:40',10,0),('1','186',257960,'DAILY SHIFT','2022-12-02','2022-12-02 07:38:38','2022-12-03 07:38:38','882',0.00,0.00,'882','2022-12-02 14:23:55','882','2022-12-02 14:24:25',10,0),('1','186',257961,'OPERATIONAL LOSS','2022-12-02','2022-12-02 14:24:56','2022-12-03 14:24:56','882',0.00,0.00,'882','2022-12-02 14:27:25','882','2022-12-02 14:30:26',10,0),('1','186',257962,'DAILY SHIFT','2022-12-02','2022-12-02 14:30:55','2022-12-03 14:30:55','882',0.00,0.00,'882','2022-12-02 19:09:07','882','2022-12-02 19:09:30',10,0),('1','186',257963,'DAILY SHIFT','2022-12-03','2022-12-03 07:09:03','2022-12-04 07:09:03','882',0.00,0.00,'882','2022-12-03 19:09:13','882','2022-12-03 19:09:38',10,0),('1','186',257964,'DAILY SHIFT','2022-12-04','2022-12-04 06:59:56','2022-12-05 06:59:56','882',0.00,0.00,'882','2022-12-04 18:49:46','882','2022-12-04 18:50:34',10,0),('1','186',257965,'DAILY SHIFT','2022-12-05','2022-12-05 07:01:16','2022-12-06 07:01:16','882',0.00,0.00,'882','2022-12-05 09:45:57','882','2022-12-05 09:46:20',10,0),('1','186',257966,'OPERATIONAL LOSS','2022-12-05','2022-12-05 09:53:44','2022-12-06 09:53:44','882',0.00,0.00,'882','2022-12-05 09:55:51','882','2022-12-05 09:56:18',10,0),('1','186',257967,'DAILY SHIFT','2022-12-05','2022-12-05 10:00:50','2022-12-06 10:00:50','882',0.00,0.00,'882','2022-12-05 19:06:19','882','2022-12-05 19:23:16',10,0),('1','186',257968,'DAILY SHIFT','2022-12-06','2022-12-06 07:37:23','2022-12-07 07:37:23','882',0.00,0.00,'882','2022-12-06 19:47:07','882','2022-12-06 19:47:32',10,0),('1','186',257969,'DAILY SHIFT','2022-12-07','2022-12-07 07:01:35','2022-12-08 07:01:35','882',0.00,0.00,'882','2022-12-07 19:22:28','882','2022-12-07 19:22:49',10,0),('1','186',257970,'DAILY SHIFT','2022-12-08','2022-12-08 07:03:24','2022-12-09 07:03:24','882',0.00,0.00,'882','2022-12-08 12:32:58','882','2022-12-08 12:33:19',10,0),('1','186',257971,'OPERATIONAL LOSS','2022-12-08','2022-12-08 12:33:42','2022-12-09 12:33:42','882',0.00,0.00,'882','2022-12-08 12:36:12','882','2022-12-08 12:36:34',10,0),('1','186',257972,'DAILY SHIFT','2022-12-09','2022-12-09 07:02:37','2022-12-10 07:02:37','882',0.00,0.00,'882','2022-12-09 19:05:06','882','2022-12-09 19:05:31',10,0),('1','186',257973,'DAILY SHIFT','2022-12-10','2022-12-10 06:58:19','2022-12-11 06:58:19','882',0.00,0.00,'882','2022-12-10 20:18:51','882','2022-12-10 20:19:14',10,0),('1','186',257974,'DAILY SHIFT','2022-12-11','2022-12-11 07:00:38','2022-12-12 07:00:38','882',0.00,0.00,'882','2022-12-11 15:32:09','882','2022-12-11 15:32:40',10,0),('1','186',257975,'OPERATIONAL LOSS','2022-12-11','2022-12-11 15:37:53','2022-12-12 15:37:53','882',0.00,0.00,'882','2022-12-11 15:39:53','882','2022-12-11 15:40:11',10,0),('1','186',257976,'DAILY SHIFT','2022-12-12','2022-12-12 07:04:13','2022-12-13 07:04:13','882',0.00,0.00,'882','2022-12-12 20:19:46','882','2022-12-12 20:20:08',10,0),('1','186',257977,'DAILY SHIFT','2022-12-13','2022-12-13 07:02:09','2022-12-14 07:02:09','882',0.00,0.00,'882','2022-12-13 14:55:18','882','2022-12-13 14:55:50',10,0),('1','186',257978,'OPERATIONAL LOSS','2022-12-13','2022-12-13 14:59:58','2022-12-14 14:59:58','882',0.00,0.00,'882','2022-12-13 15:03:51','882','2022-12-13 15:05:26',10,0),('1','186',257979,'DAILY SHIFT','2022-12-13','2022-12-13 15:08:53','2022-12-14 15:08:53','882',0.00,0.00,'882','2022-12-13 19:01:45','882','2022-12-13 19:02:19',10,0),('1','186',257980,'DAILY SHIFT','2022-12-14','2022-12-14 07:00:36','2022-12-15 07:00:36','882',0.00,0.00,'882','2022-12-14 19:08:53','882','2022-12-14 19:09:14',10,0),('1','186',257981,'DAILY SHIFT','2022-12-15','2022-12-15 06:55:56','2022-12-16 06:55:56','882',0.00,0.00,'882','2022-12-15 18:04:57','882','2022-12-15 18:05:20',10,0),('1','186',257982,'OPERATIONAL LOSS','2022-12-15','2022-12-15 18:05:42','2022-12-16 18:05:42','882',0.00,0.00,'882','2022-12-15 18:08:02','882','2022-12-15 18:08:21',10,0),('1','186',257983,'DAILY SHIFT','2022-12-15','2022-12-15 18:11:01','2022-12-16 18:11:01','882',0.00,0.00,'882','2022-12-15 19:01:28','882','2022-12-15 19:01:47',10,0),('1','186',257984,'DAILY SHIFT','2022-12-16','2022-12-16 07:01:56','2022-12-17 07:01:56','882',0.00,0.00,'882','2022-12-16 19:18:45','882','2022-12-16 19:20:40',10,0),('1','186',257985,'DAILY SHIFT','2022-12-17','2022-12-17 07:03:21','2022-12-18 07:03:21','882',0.00,0.00,'882','2022-12-17 14:45:41','882','2022-12-17 14:46:02',10,0),('1','186',257986,'OPERATIONAL LOSS','2022-12-17','2022-12-17 14:51:51','2022-12-18 14:51:51','882',0.00,0.00,'882','2022-12-17 14:53:48','882','2022-12-17 14:54:07',10,0),('1','186',257987,'OPERATIONAL LOSS','2022-12-17','2022-12-17 15:03:27','2022-12-18 15:03:27','882',0.00,0.00,'882','2022-12-17 15:07:02','882','2022-12-17 15:07:19',10,0),('1','186',257988,'DAILY SHIFT','2022-12-19','2022-12-19 12:07:54','2022-12-20 12:07:54','882',0.00,0.00,'882','2022-12-19 21:50:57','882','2022-12-19 21:51:57',10,0),('1','186',257989,'DAILY SHIFT','2022-12-20','2022-12-20 07:12:33','2022-12-21 07:12:33','882',0.00,0.00,'882','2022-12-20 19:51:25','882','2022-12-20 19:51:46',10,0),('1','186',257990,'OPERATIONAL LOSS','2022-12-21','2022-12-21 13:29:19','2022-12-22 13:29:19','882',0.00,0.00,'882','2022-12-21 13:32:21','882','2022-12-21 13:32:38',10,0),('1','186',257991,'DAILY SHIFT','2022-12-22','2022-12-22 07:00:09','2022-12-23 07:00:09','882',0.00,0.00,'882','2022-12-22 19:16:24','882','2022-12-22 19:21:32',10,0),('1','186',257992,'DAILY SHIFT','2022-12-23','2022-12-23 06:59:39','2022-12-24 06:59:39','882',0.00,0.00,'882','2022-12-23 15:12:06','882','2022-12-23 15:12:31',10,0),('1','186',257993,'OPERATIONAL LOSS','2022-12-23','2022-12-23 15:14:02','2022-12-24 15:14:02','882',0.00,0.00,'882','2022-12-23 15:15:51','882','2022-12-23 15:16:10',10,0),('1','186',257994,'DAILY SHIFT','2022-12-23','2022-12-23 15:20:30','2022-12-24 15:20:30','882',0.00,0.00,'882','2022-12-23 19:35:09','882','2022-12-23 19:35:29',10,0),('1','186',257995,'DAILY SHIFT','2022-12-24','2022-12-24 07:00:14','2022-12-25 07:00:14','882',0.00,0.00,'882','2022-12-24 20:15:54','882','2022-12-24 20:16:22',10,0),('1','186',257996,'DAILY SHIFT','2022-12-25','2022-12-25 07:07:03','2022-12-26 07:07:03','882',0.00,0.00,'882','2022-12-25 12:13:08','882','2022-12-25 12:13:28',10,0),('1','186',257997,'OPERATIONAL LOSS','2022-12-25','2022-12-25 12:20:34','2022-12-26 12:20:34','882',0.00,0.00,'882','2022-12-25 12:26:14','882','2022-12-25 12:27:04',10,0),('1','186',257998,'DAILY SHIFT','2022-12-25','2022-12-25 12:30:14','2022-12-26 12:30:14','882',0.00,0.00,'882','2022-12-25 19:12:16','882','2022-12-25 19:12:35',10,0),('1','186',257999,'DAILY SHIFT','2022-12-26','2022-12-26 06:59:51','2022-12-27 06:59:51','882',0.00,0.00,'882','2022-12-26 19:46:24','882','2022-12-26 19:48:11',10,0),('1','186',258000,'DAILY SHIFT','2022-12-27','2022-12-27 07:05:26','2022-12-28 07:05:26','882',0.00,0.00,'882','2022-12-27 11:46:22','882','2022-12-27 11:46:41',10,0),('1','186',258001,'OPERATIONAL LOSS','2022-12-27','2022-12-27 11:47:02','2022-12-28 11:47:02','882',0.00,0.00,'882','2022-12-27 11:49:48','882','2022-12-27 11:50:11',10,0),('1','186',258002,'DAILY SHIFT','2022-12-27','2022-12-27 11:52:48','2022-12-28 11:52:48','882',0.00,0.00,'882','2022-12-27 19:38:25','882','2022-12-27 19:38:49',10,0),('1','186',258003,'DAILY SHIFT','2022-12-28','2022-12-28 07:07:00','2022-12-29 07:07:00','882',0.00,0.00,'882','2022-12-28 19:41:16','882','2022-12-28 19:41:52',10,0),('1','186',258004,'DAILY SHIFT','2022-12-29','2022-12-29 07:06:42','2022-12-30 07:06:42','882',0.00,0.00,'882','2022-12-29 17:19:58','882','2022-12-29 17:20:17',10,0),('1','186',258005,'OPERATIONAL LOSS','2022-12-29','2022-12-29 17:30:24','2022-12-30 17:30:24','882',0.00,0.00,'882','2022-12-29 17:33:50','882','2022-12-29 17:37:16',10,0),('1','186',258006,'DAILY SHIFT','2022-12-30','2022-12-30 07:07:25','2022-12-31 07:07:25','882',0.00,0.00,'882','2022-12-30 20:23:27','882','2022-12-30 20:23:51',10,0),('1','186',258007,'DAILY SHIFT','2022-12-31','2022-12-31 07:06:17','2023-01-01 07:06:17','882',0.00,0.00,'882','2022-12-31 14:21:07','882','2022-12-31 14:21:30',10,0),('1','186',258008,'OPERATIONAL LOSS','2022-12-31','2022-12-31 14:22:11','2023-01-01 14:22:11','882',0.00,0.00,'882','2022-12-31 14:25:28','882','2022-12-31 14:25:56',10,0),('1','186',258009,'DAILY SHIFT','2022-12-31','2022-12-31 14:27:45','2023-01-01 14:27:45','882',0.00,0.00,'882','2022-12-31 20:08:48','882','2022-12-31 20:09:19',10,0),('1','186',258010,'DAILY SHIFT','2023-01-01','2023-01-01 07:34:20','2023-01-02 07:34:20','882',0.00,0.00,'882','2023-01-01 20:19:50','882','2023-01-01 20:20:30',10,0),('1','186',258011,'DAILY SHIFT','2023-01-02','2023-01-02 07:08:25','2023-01-03 07:08:25','882',0.00,0.00,'882','2023-01-02 12:44:43','882','2023-01-02 12:45:04',10,0),('1','186',258012,'OPERATIONAL LOSS','2023-01-02','2023-01-02 12:47:42','2023-01-03 12:47:42','882',0.00,0.00,'882','2023-01-02 12:50:45','882','2023-01-02 12:51:31',10,0),('1','186',258013,'DAILY SHIFT','2023-01-03','2023-01-03 07:27:59','2023-01-04 07:27:59','882',0.00,0.00,'882','2023-01-03 20:35:39','882','2023-01-03 20:36:08',10,0),('1','186',258014,'DAILY SHIFT','2023-01-04','2023-01-04 07:07:13','2023-01-05 07:07:13','882',0.00,0.00,'882','2023-01-04 12:42:15','882','2023-01-04 12:42:34',10,0),('1','186',258015,'OPERATIONAL LOSS','2023-01-04','2023-01-04 12:45:01','2023-01-05 12:45:01','882',0.00,0.00,'882','2023-01-04 12:47:34','882','2023-01-04 12:47:53',10,0),('1','186',258016,'DAILY SHIFT','2023-01-04','2023-01-04 13:05:11','2023-01-05 13:05:11','882',0.00,0.00,'882','2023-01-04 21:55:50','882','2023-01-04 22:05:03',10,0),('1','186',258017,'DAILY SHIFT','2023-01-05','2023-01-05 07:15:05','2023-01-06 07:15:05','882',0.00,0.00,'882','2023-01-05 15:00:12','882','2023-01-05 15:00:34',10,0),('1','186',258018,'OPERATIONAL LOSS','2023-01-05','2023-01-05 15:03:24','2023-01-06 15:03:24','882',0.00,0.00,'882','2023-01-05 15:06:03','882','2023-01-05 15:06:17',10,0),('1','186',258019,'DAILY SHIFT','2023-01-05','2023-01-05 15:08:27','2023-01-06 15:08:27','882',0.00,0.00,'882','2023-01-05 19:45:35','882','2023-01-05 19:45:52',10,0),('1','186',258020,'DAILY SHIFT','2023-01-06','2023-01-06 07:09:48','2023-01-07 07:09:48','882',0.00,0.00,'882','2023-01-06 19:55:43','882','2023-01-06 19:56:06',10,0),('1','186',258021,'OPERATIONAL LOSS','2023-01-04','2023-01-06 20:00:43','2023-01-07 20:00:43','882',0.00,0.00,'882','2023-01-06 20:04:40','882','2023-01-06 20:05:02',10,0),('1','186',258022,'DAILY SHIFT','2023-01-07','2023-01-07 07:08:35','2023-01-08 07:08:35','882',0.00,0.00,'882','2023-01-07 19:17:15','882','2023-01-07 19:17:59',10,0),('1','186',258023,'OPERATIONAL LOSS','2023-01-07','2023-01-07 19:31:54','2023-01-08 19:31:54','882',0.00,0.00,'882','2023-01-07 19:34:49','882','2023-01-07 19:35:13',10,0),('1','186',258024,'DAILY SHIFT','2023-01-09','2023-01-09 07:10:14','2023-01-10 07:10:14','882',0.00,0.00,'882','2023-01-09 20:13:57','882','2023-01-09 20:14:31',10,0),('1','186',258025,'DAILY SHIFT','2023-01-10','2023-01-10 07:01:41','2023-01-11 07:01:41','882',0.00,0.00,'882','2023-01-10 16:48:12','882','2023-01-10 16:48:37',10,0),('1','186',258026,'OPERATIONAL LOSS','2023-01-10','2023-01-10 16:49:28','2023-01-11 16:49:28','882',0.00,0.00,'882','2023-01-10 16:57:23','882','2023-01-10 16:57:48',10,0),('1','186',258027,'DAILY SHIFT','2023-01-10','2023-01-10 17:07:05','2023-01-11 17:07:05','882',0.00,0.00,'882','2023-01-10 20:20:44','882','2023-01-10 20:21:18',10,0),('1','186',258028,'DAILY SHIFT','2023-01-11','2023-01-11 07:13:51','2023-01-12 07:13:51','882',0.00,0.00,'882','2023-01-11 19:43:10','882','2023-01-11 19:43:55',10,0),('1','186',258029,'DAILY SHIFT','2023-01-12','2023-01-12 07:07:45','2023-01-13 07:07:45','882',0.00,0.00,'882','2023-01-12 19:48:16','882','2023-01-12 19:48:51',10,0),('1','186',258030,'DAILY SHIFT','2023-01-13','2023-01-13 06:58:33','2023-01-14 06:58:33','882',0.00,0.00,'882','2023-01-13 11:58:45','882','2023-01-13 11:59:30',10,0),('1','186',258031,'OPERATIONAL LOSS','2023-01-13','2023-01-13 12:01:04','2023-01-14 12:01:04','882',0.00,0.00,'882','2023-01-13 23:56:41','882','2023-01-14 00:37:58',10,0),('1','186',258032,'DAILY SHIFT','2023-01-14','2023-01-14 06:54:34','2023-01-15 06:54:34','882',0.00,0.00,'882','2023-01-14 19:31:11','882','2023-01-14 19:31:43',10,0),('1','186',258033,'DAILY SHIFT','2023-01-15','2023-01-15 07:00:52','2023-01-16 07:00:52','882',0.00,0.00,'882','2023-01-15 19:57:11','882','2023-01-15 19:57:37',10,0),('1','186',258034,'DAILY SHIFT','2023-01-16','2023-01-16 07:05:25','2023-01-17 07:05:25','882',0.00,0.00,'882','2023-01-16 09:08:45','882','2023-01-16 09:09:05',10,0),('1','186',258035,'OPERATIONAL LOSS','2023-01-16','2023-01-16 09:09:22','2023-01-17 09:09:22','882',0.00,0.00,'882','2023-01-16 09:12:36','882','2023-01-16 09:12:54',10,0),('1','186',258036,'OPERATIONAL LOSS','2023-01-16','2023-01-16 09:13:23','2023-01-17 09:13:23','882',0.00,0.00,'882','2023-01-16 09:15:39','882','2023-01-16 09:16:14',10,0),('1','186',258037,'OPERATIONAL LOSS','2023-01-16','2023-01-16 09:19:37','2023-01-17 09:19:37','882',0.00,0.00,'882','2023-01-16 09:20:21','882','2023-01-16 09:20:40',10,0),('1','186',258038,'DAILY SHIFT','2023-01-16','2023-01-16 09:21:02','2023-01-17 09:21:02','882',0.00,0.00,'882','2023-01-16 19:18:32','882','2023-01-16 19:18:55',10,0),('1','186',258039,'OPERATIONAL LOSS','2023-01-17','2023-01-17 07:08:32','2023-01-18 07:08:32','882',0.00,0.00,'882','2023-01-17 18:55:24','882','2023-01-17 18:55:47',10,0),('1','186',258040,'DAILY SHIFT','2023-01-18','2023-01-18 07:04:32','2023-01-19 07:04:32','882',0.00,0.00,'882','2023-01-18 17:38:42','882','2023-01-18 17:39:46',10,0),('1','186',258041,'OPERATIONAL LOSS','2023-01-18','2023-01-18 17:41:26','2023-01-19 17:41:26','882',0.00,0.00,'882','2023-01-18 17:43:53','882','2023-01-18 17:44:13',10,0),('1','186',258042,'DAILY SHIFT','2023-01-18','2023-01-18 17:53:08','2023-01-19 17:53:08','882',0.00,0.00,'882','2023-01-18 19:46:00','882','2023-01-18 19:46:24',10,0),('1','186',258043,'DAILY SHIFT','2023-01-19','2023-01-19 06:58:14','2023-01-20 06:58:14','882',0.00,0.00,'882','2023-01-19 19:05:04','882','2023-01-19 19:05:23',10,0),('1','186',258044,'DAILY SHIFT','2023-01-20','2023-01-20 07:14:09','2023-01-21 07:14:09','882',0.00,0.00,'882','2023-01-20 19:01:47','882','2023-01-20 19:02:22',10,0),('1','186',258045,'DAILY SHIFT','2023-01-21','2023-01-21 07:08:50','2023-01-22 07:08:50','882',0.00,0.00,'882','2023-01-21 14:48:19','882','2023-01-21 14:48:45',10,0),('1','186',258046,'OPERATIONAL LOSS','2023-01-21','2023-01-21 14:49:16','2023-01-22 14:49:16','882',0.00,0.00,'882','2023-01-21 14:50:57','882','2023-01-21 14:51:16',10,0),('1','186',258047,'DAILY SHIFT','2023-01-21','2023-01-21 14:53:50','2023-01-22 14:53:50','882',0.00,0.00,'882','2023-01-21 18:59:38','882','2023-01-21 19:00:00',10,0),('1','186',258048,'DAILY SHIFT','2023-01-22','2023-01-22 07:09:26','2023-01-23 07:09:26','882',0.00,0.00,'882','2023-01-22 19:28:49','882','2023-01-22 19:29:10',10,0),('1','186',258049,'DAILY SHIFT','2023-01-23','2023-01-23 07:11:40','2023-01-24 07:11:40','882',0.00,0.00,'882','2023-01-23 17:34:21','882','2023-01-23 17:35:03',10,0),('1','186',258050,'OPERATIONAL LOSS','2023-01-23','2023-01-23 17:38:42','2023-01-24 17:38:42','882',0.00,0.00,'882','2023-01-23 17:41:13','882','2023-01-23 17:41:33',10,0),('1','186',258051,'DAILY SHIFT','2023-01-24','2023-01-24 13:39:51','2023-01-25 13:39:51','882',0.00,0.00,'882','2023-01-24 19:49:05','882','2023-01-24 19:49:47',10,0),('1','186',258052,'DAILY SHIFT','2023-01-25','2023-01-25 07:00:38','2023-01-26 07:00:38','882',0.00,0.00,'882','2023-01-25 19:43:19','882','2023-01-25 19:43:45',10,0),('1','186',258053,'DAILY SHIFT','2023-01-26','2023-01-26 07:12:25','2023-01-27 07:12:25','882',0.00,0.00,'882','2023-01-26 18:25:55','882','2023-01-26 18:26:23',10,0),('1','186',258054,'DAILY SHIFT','2023-01-27','2023-01-27 17:51:53','2023-01-28 17:51:53','882',0.00,0.00,'882','2023-01-27 18:00:49','882','2023-01-27 18:01:10',10,0),('1','186',258055,'OPERATIONAL LOSS','2023-01-27','2023-01-27 18:02:45','2023-01-28 18:02:45','882',0.00,0.00,'882','2023-01-27 18:07:31','882','2023-01-27 18:08:09',10,0),('1','186',258056,'DAILY SHIFT','2023-01-28','2023-01-28 07:01:08','2023-01-29 07:01:08','882',0.00,0.00,'882','2023-01-28 19:19:29','882','2023-01-28 19:19:54',10,0),('1','186',258057,'DAILY SHIFT','2023-01-29','2023-01-29 07:14:01','2023-01-30 07:14:01','882',0.00,0.00,'882','2023-01-29 17:37:07','882','2023-01-29 17:37:36',10,0),('1','186',258058,'OPERATIONAL LOSS','2023-01-29','2023-01-29 17:37:57','2023-01-30 17:37:57','882',0.00,0.00,'882','2023-01-29 17:39:40','882','2023-01-29 17:40:01',10,0),('1','186',258059,'DAILY SHIFT','2023-01-29','2023-01-29 17:43:43','2023-01-30 17:43:43','882',0.00,0.00,'882','2023-01-29 19:32:03','882','2023-01-29 19:32:20',10,0),('1','186',258060,'DAILY SHIFT','2023-01-30','2023-01-30 07:33:35','2023-01-31 07:33:35','882',0.00,0.00,'882','2023-01-30 19:37:50','882','2023-01-30 19:38:44',10,0),('1','186',258061,'DAILY SHIFT','2023-01-31','2023-01-31 06:58:29','2023-02-01 06:58:29','882',0.00,0.00,'882','2023-01-31 19:20:07','882','2023-01-31 19:22:02',10,0),('1','186',258062,'DAILY SHIFT','2023-02-01','2023-02-01 07:01:05','2023-02-02 07:01:05','882',0.00,0.00,'882','2023-02-01 12:01:52','882','2023-02-01 12:02:14',10,0),('1','186',258063,'OPERATIONAL LOSS','2023-02-01','2023-02-01 12:02:52','2023-02-02 12:02:52','882',0.00,0.00,'882','2023-02-01 12:05:06','882','2023-02-01 12:05:24',10,0),('1','186',258064,'DAILY SHIFT','2023-02-01','2023-02-01 12:07:51','2023-02-02 12:07:51','882',0.00,0.00,'882','2023-02-01 20:21:59','882','2023-02-01 20:22:25',10,0),('1','186',258065,'DAILY SHIFT','2023-02-02','2023-02-02 07:02:11','2023-02-03 07:02:11','882',0.00,0.00,'882','2023-02-02 19:11:20','882','2023-02-02 19:12:26',10,0),('1','186',258066,'DAILY SHIFT.','2023-02-03','2023-02-03 06:59:35','2023-02-04 06:59:35','882',0.00,0.00,'882','2023-02-03 20:14:02','882','2023-02-03 20:14:38',10,0),('1','186',258067,'DAILY SHIFT','2023-02-04','2023-02-04 07:08:07','2023-02-05 07:08:07','882',0.00,0.00,'882','2023-02-04 11:02:03','882','2023-02-04 11:02:33',10,0),('1','186',258068,'OPERATIONAL LOSS','2023-02-04','2023-02-04 11:02:58','2023-02-05 11:02:58','882',0.00,0.00,'882','2023-02-04 11:04:52','882','2023-02-04 11:05:14',10,0),('1','186',258069,'DAILY SHIFT','2023-02-04','2023-02-04 11:07:46','2023-02-05 11:07:46','882',0.00,0.00,'882','2023-02-04 19:21:08','882','2023-02-04 19:21:38',10,0),('1','186',258070,'DAILY SHIFT','2023-02-05','2023-02-05 07:00:17','2023-02-06 07:00:17','882',0.00,0.00,'882','2023-02-05 19:34:44','882','2023-02-05 19:36:04',10,0),('1','186',258071,'DAILY SHIFT','2023-02-06','2023-02-06 07:20:31','2023-02-07 07:20:31','882',0.00,0.00,'882','2023-02-06 16:50:56','882','2023-02-06 16:51:34',10,0),('1','186',258072,'DAILY SHIFT','2023-02-07','2023-02-07 09:44:15','2023-02-08 09:44:15','882',0.00,0.00,'882','2023-02-07 10:12:32','882','2023-02-07 10:13:09',10,0),('1','186',258073,'OPERATIONAL LOSS','2023-02-07','2023-02-07 10:13:28','2023-02-08 10:13:28','882',0.00,0.00,'882','2023-02-07 10:15:22','882','2023-02-07 10:15:44',10,0),('1','186',258074,'DAILY SHIFT','2023-02-07','2023-02-07 10:18:15','2023-02-08 10:18:15','882',0.00,0.00,'882','2023-02-07 21:23:20','882','2023-02-07 21:24:21',10,0),('1','186',258075,'DAILY SHIFT','2023-02-08','2023-02-08 07:01:55','2023-02-09 07:01:55','882',0.00,0.00,'882','2023-02-08 20:00:05','882','2023-02-08 20:00:48',10,0),('1','186',258076,'DAILY SHIFT','2023-02-09','2023-02-09 07:01:43','2023-02-10 07:01:43','882',0.00,0.00,'882','2023-02-09 19:43:11','882','2023-02-09 19:43:56',10,0),('1','186',258077,'OPERATIONAL LOSS','2023-02-09','2023-02-09 19:56:25','2023-02-10 19:56:25','882',0.00,0.00,'882','2023-02-10 08:19:25','882','2023-02-10 08:19:55',10,0),('1','186',258078,'DAILY SHIFT','2023-02-10','2023-02-10 08:21:00','2023-02-11 08:21:00','882',0.00,0.00,'882','2023-02-10 20:29:32','882','2023-02-10 20:29:59',10,0),('1','186',258079,'DAILY SHIFT','2023-02-11','2023-02-11 07:18:06','2023-02-12 07:18:06','882',0.00,0.00,'882','2023-02-11 15:10:13','882','2023-02-11 15:10:53',10,0),('1','186',258080,'OPERATIONAL LOSS','2023-02-11','2023-02-11 15:11:07','2023-02-12 15:11:07','882',0.00,0.00,'882','2023-02-11 15:13:08','882','2023-02-11 15:13:25',10,0),('1','186',258081,'DAILY SHIFT','2023-02-11','2023-02-11 15:16:51','2023-02-12 15:16:51','882',0.00,0.00,'882','2023-02-11 19:38:04','882','2023-02-11 19:39:40',10,0),('1','186',258082,'DAILY SHIFT','2023-02-12','2023-02-12 07:12:50','2023-02-13 07:12:50','882',0.00,0.00,'882','2023-02-12 19:23:14','882','2023-02-12 19:24:20',10,0),('1','186',258083,'DAILY SHIFT','2023-02-13','2023-02-13 07:02:22','2023-02-14 07:02:22','882',0.00,0.00,'882','2023-02-13 20:11:13','882','2023-02-13 20:11:42',10,0),('1','186',258084,'DAILY SHIFT','2023-02-14','2023-02-14 07:10:14','2023-02-15 07:10:14','882',0.00,0.00,'882','2023-02-14 14:05:48','882','2023-02-14 14:07:17',10,0),('1','186',258085,'OPERATIONAL LOSS','2023-02-14','2023-02-14 14:08:52','2023-02-15 14:08:52','882',0.00,0.00,'882','2023-02-14 14:20:39','882','2023-02-14 14:21:06',10,0),('1','186',258086,'DAILY SHIFT','2023-02-15','2023-02-15 07:29:05','2023-02-16 07:29:05','882',0.00,0.00,'882','2023-02-15 21:28:27','882','2023-02-15 21:30:29',10,0),('1','186',258087,'DAILY SHIFT','2023-02-16','2023-02-16 07:19:01','2023-02-17 07:19:01','882',0.00,0.00,'882','2023-02-16 22:00:47','882','2023-02-16 22:01:20',10,0),('1','186',258088,'DAILY SHIFT','2023-02-17','2023-02-17 07:09:59','2023-02-18 07:09:59','882',0.00,0.00,'882','2023-02-17 18:56:33','882','2023-02-17 18:56:51',10,0),('1','186',258089,'DAILY SHIFT','2023-02-18','2023-02-18 14:30:54','2023-02-19 14:30:54','882',0.00,0.00,'882','2023-02-18 14:32:24','882','2023-02-18 14:32:49',10,0),('1','186',258090,'OPERATIONAL LOSS','2023-02-18','2023-02-18 14:34:19','2023-02-19 14:34:19','882',0.00,0.00,'882','2023-02-18 14:38:30','882','2023-02-18 14:38:58',10,0),('1','186',258091,'DAILY SHIFT','2023-02-19','2023-02-19 08:07:56','2023-02-20 08:07:56','882',0.00,0.00,'882','2023-02-19 21:09:23','882','2023-02-19 21:09:53',10,0),('1','186',258092,'OPERATIONAL LOSS','2023-02-20','2023-02-20 07:21:22','2023-02-21 07:21:22','882',0.00,0.00,'882','2023-02-20 20:29:42','882','2023-02-20 20:30:18',10,0),('1','186',258093,'OPERATIONAL LOSS 1','2023-02-21','2023-02-21 13:48:00','2023-02-22 13:48:00','882',0.00,0.00,'882','2023-02-21 13:54:57','882','2023-02-21 13:55:19',10,0),('1','186',258094,'DAILY SHIFT','2023-02-21','2023-02-21 14:31:52','2023-02-22 14:31:52','882',0.00,0.00,'882','2023-02-21 20:26:08','882','2023-02-21 20:26:29',10,0),('1','186',258095,'DAILY SHIFT','2023-02-22','2023-02-22 07:10:47','2023-02-23 07:10:47','882',0.00,0.00,'882','2023-02-22 20:24:34','882','2023-02-22 20:25:06',10,0),('1','186',258096,'DAILY SHIFT','2023-02-23','2023-02-23 07:07:02','2023-02-24 07:07:02','882',0.00,0.00,'882','2023-02-23 17:49:21','882','2023-02-23 17:49:56',10,0),('1','186',258097,'DAILY SHIFT','2023-02-23','2023-02-23 17:50:38','2023-02-24 17:50:38','882',0.00,0.00,'882','2023-02-23 17:53:04','882','2023-02-23 17:53:26',10,0),('1','186',258098,'DAILY SHIFT 111','2023-02-23','2023-02-23 17:55:57','2023-02-24 17:55:57','882',0.00,0.00,'882','2023-02-24 18:05:28','882','2023-02-24 18:07:17',10,0),('1','186',258099,'DAILY SHIFT','2023-02-24','2023-02-24 18:07:40','2023-02-25 18:07:40','882',0.00,0.00,'882','2023-02-25 08:53:50','882','2023-02-25 08:55:25',10,0),('1','186',258100,'DAILY SHIFT','2023-02-27','2023-02-27 09:54:42','2023-02-28 09:54:42','882',0.00,0.00,'882','2023-02-27 16:16:49','882','2023-02-27 16:17:17',10,0),('1','186',258101,'OPERATIONAL LOSS','2023-02-27','2023-02-27 16:26:45','2023-02-28 16:26:45','882',0.00,0.00,'882','2023-02-27 16:29:04','882','2023-02-27 16:29:52',10,0),('1','186',258102,'DAILY SHIFT','2023-02-28','2023-02-28 07:17:15','2023-03-01 07:17:15','882',0.00,0.00,'882','2023-02-28 19:15:42','882','2023-02-28 19:17:17',10,0),('1','186',258103,'DAILY SHIFT','2023-03-01','2023-03-01 07:10:06','2023-03-02 07:10:06','882',0.00,0.00,'882','2023-03-01 20:08:34','882','2023-03-01 20:11:40',10,0),('1','186',258104,'DAILY SHIFT','2023-03-02','2023-03-02 07:05:29','2023-03-03 07:05:29','882',0.00,0.00,'882','2023-03-02 09:58:43','882','2023-03-02 09:59:06',10,0),('1','186',258105,'OPERATIONAL LOSS','2023-03-02','2023-03-02 10:00:57','2023-03-03 10:00:57','882',0.00,0.00,'882','2023-03-02 10:03:03','882','2023-03-02 10:03:24',10,0),('1','186',258106,'DAILY SHIFT','2023-03-02','2023-03-02 14:17:26','2023-03-03 14:17:26','882',0.00,0.00,'882','2023-03-02 19:23:42','882','2023-03-02 19:24:01',10,0),('1','186',258107,'DAILY SHIFT','2023-03-03','2023-03-03 07:03:28','2023-03-04 07:03:28','882',0.00,0.00,'882','2023-03-03 19:47:16','882','2023-03-03 19:49:05',10,0),('1','186',258108,'DAILY SHIFT','2023-03-03','2023-03-03 20:29:42','2023-03-04 20:29:42','882',0.00,0.00,'882','2023-03-03 20:42:40','882','2023-03-03 20:43:02',10,0),('1','186',258109,'DAILY SHIFT','2023-03-04','2023-03-04 07:07:10','2023-03-05 07:07:10','882',0.00,0.00,'882','2023-03-04 16:03:56','882','2023-03-04 16:04:23',10,0),('1','186',258110,'OPERATIONAL LOSS','2023-03-04','2023-03-04 16:04:48','2023-03-05 16:04:48','882',0.00,0.00,'882','2023-03-04 16:09:16','882','2023-03-04 16:09:32',10,0),('1','186',258111,'DAILY SHIFT','2023-03-04','2023-03-04 16:09:47','2023-03-05 16:09:47','882',0.00,0.00,'882','2023-03-04 19:30:31','882','2023-03-04 19:31:23',10,0),('1','186',258112,'DAILY SHIFT','2023-03-05','2023-03-05 07:07:54','2023-03-06 07:07:54','882',0.00,0.00,'882','2023-03-05 20:49:45','882','2023-03-05 20:50:36',10,0),('1','186',258113,'DAILY SHIFT','2023-03-06','2023-03-06 07:10:00','2023-03-07 07:10:00','882',0.00,0.00,'882','2023-03-06 21:52:38','882','2023-03-06 21:53:00',10,0),('1','186',258114,'DAILY SHIFT','2023-03-07','2023-03-07 07:04:55','2023-03-08 07:04:55','882',0.00,0.00,'882','2023-03-07 10:52:59','882','2023-03-07 10:53:23',10,0),('1','186',258115,'OPERATIONAL LOSS','2023-03-07','2023-03-07 10:54:41','2023-03-08 10:54:41','882',0.00,0.00,'882','2023-03-07 10:58:42','882','2023-03-07 10:59:21',10,0),('1','186',258116,'DAILY SHIFT','2023-03-07','2023-03-07 13:06:07','2023-03-08 13:06:07','882',0.00,0.00,'882','2023-03-07 19:29:45','882','2023-03-07 19:30:14',10,0),('1','186',258117,'DAILY SHIFT','2023-03-08','2023-03-08 07:05:52','2023-03-09 07:05:52','882',0.00,0.00,'882','2023-03-08 19:01:01','882','2023-03-08 19:01:36',10,0),('1','186',258118,'DAILY SHIFT','2023-03-09','2023-03-09 07:15:50','2023-03-10 07:15:50','882',0.00,0.00,'882','2023-03-09 19:33:40','882','2023-03-09 19:34:20',10,0),('1','186',258119,'DAILY SHIFT','2023-03-10','2023-03-10 07:10:00','2023-03-11 07:10:00','882',0.00,0.00,'882','2023-03-10 09:38:05','882','2023-03-10 09:38:45',10,0),('1','186',258120,'OPERATIONAL LOSS','2023-03-10','2023-03-10 09:42:00','2023-03-11 09:42:00','882',0.00,0.00,'882','2023-03-10 09:44:33','882','2023-03-10 09:44:52',10,0),('1','186',258121,'DAILY SHIFT','2023-03-10','2023-03-10 09:49:40','2023-03-11 09:49:40','882',0.00,0.00,'882','2023-03-10 19:38:58','882','2023-03-10 19:39:49',10,0),('1','186',258122,'DAILY SHIFT','2023-03-11','2023-03-11 07:21:52','2023-03-12 07:21:52','882',0.00,0.00,'882','2023-03-11 19:39:02','882','2023-03-11 19:39:52',10,0),('1','186',258123,'DAILY SHIFT','2023-03-12','2023-03-12 07:07:05','2023-03-13 07:07:05','882',0.00,0.00,'882','2023-03-12 19:33:27','882','2023-03-12 19:33:51',10,0),('1','186',258124,'DAILY SHIFT','2023-03-13','2023-03-13 07:25:11','2023-03-14 07:25:11','882',0.00,0.00,'882','2023-03-13 08:47:45','882','2023-03-13 08:48:16',10,0),('1','186',258125,'OPERATIONAL LOSS','2023-03-13','2023-03-13 08:48:46','2023-03-14 08:48:46','882',0.00,0.00,'882','2023-03-13 12:35:21','882','2023-03-13 12:35:45',10,0),('1','186',258126,'DAILY SHIFT 111','2023-03-13','2023-03-13 12:38:14','2023-03-14 12:38:14','882',0.00,0.00,'882','2023-03-13 20:35:39','882','2023-03-13 20:36:03',10,0),('1','186',258127,'DAILY SHIFT','2023-03-14','2023-03-14 07:09:18','2023-03-15 07:09:18','882',0.00,0.00,'882','2023-03-14 19:54:54','882','2023-03-14 19:55:35',10,0),('1','186',258128,'DAILY SHIFT','2023-03-16','2023-03-16 08:04:01','2023-03-17 08:04:01','882',0.00,0.00,'882','2023-03-16 12:52:48','882','2023-03-16 12:53:16',10,0),('1','186',258129,'OPERATIONAL LOSS','2023-03-16','2023-03-16 12:53:31','2023-03-17 12:53:31','882',0.00,0.00,'882','2023-03-16 12:55:26','882','2023-03-16 12:55:54',10,0),('1','186',258130,'DAILY SHIFT','2023-03-16','2023-03-16 13:07:46','2023-03-17 13:07:46','882',0.00,0.00,'882','2023-03-16 19:26:51','882','2023-03-16 19:27:23',10,0),('1','186',258131,'DAILY SHIFT','2023-03-17','2023-03-17 07:07:37','2023-03-18 07:07:37','882',0.00,0.00,'882','2023-03-17 20:00:07','882','2023-03-17 20:00:47',10,0),('1','186',258132,'DAILY SHIFT','2023-03-19','2023-03-19 07:05:10','2023-03-20 07:05:10','882',0.00,0.00,'882','2023-03-19 19:27:24','882','2023-03-19 19:27:43',10,0),('1','186',258133,'DAILY SHIFT','2023-03-20','2023-03-20 07:11:09','2023-03-21 07:11:09','882',0.00,0.00,'882','2023-03-20 07:55:37','882','2023-03-20 07:56:35',10,0),('1','186',258134,'OPERATIONAL LOSS','2023-03-20','2023-03-20 07:57:24','2023-03-21 07:57:24','882',0.00,0.00,'882','2023-03-20 08:03:30','882','2023-03-20 08:07:36',10,0),('1','186',258135,'DAILY SHIFT','2023-03-20','2023-03-20 08:07:59','2023-03-21 08:07:59','882',0.00,0.00,'882','2023-03-20 19:53:43','882','2023-03-20 19:54:07',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904831 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','186','940','205278',3989348,'2761','419',0.00,4590.02,0.00,0.00,4590.02,1436278.88,0.00,0.00,0.00),('1','186','940','205562',3994615,'2761','419',4590.02,11109.77,0.00,0.00,6519.75,2022937.14,0.00,0.00,0.00),('1','186','940','205968',4001877,'2761','419',11109.77,14172.17,0.00,0.00,3062.40,960889.80,0.00,0.00,0.00),('1','186','940','206045',4003249,'2761','419',14172.17,18859.77,0.00,0.00,4687.60,1461269.20,0.00,0.00,0.00),('1','186','940','206248',4006906,'2761','419',18859.77,18859.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','206423',4009806,'2761','419',18859.77,24707.17,0.00,0.00,5847.40,2007902.80,0.00,0.00,0.00),('1','186','940','206458',4010461,'2761','419',24707.17,29725.07,0.00,0.00,5017.90,1575670.80,0.00,0.00,0.00),('1','186','940','206592',4012784,'2761','419',29725.07,32437.67,0.00,0.00,2712.60,859835.20,0.00,0.00,0.00),('1','186','940','206824',4016876,'2761','419',32437.67,37321.07,0.00,0.00,4883.40,1525556.80,0.00,0.00,0.00),('1','186','940','206988',4020150,'2761','419',37321.07,37859.77,0.00,0.00,538.70,161610.00,0.00,0.00,0.00),('1','186','940','207263',4024844,'2761','419',37859.77,47785.57,0.00,0.00,9925.80,3100281.60,0.00,0.00,0.00),('1','186','940','207674',4032160,'2761','419',47785.57,50971.47,0.00,0.00,3185.90,1006316.80,0.00,0.00,0.00),('1','186','940','208006',4037743,'2761','419',50971.47,58392.87,0.00,0.00,7421.40,2392210.00,0.00,0.00,0.00),('1','186','940','208133',4039944,'2761','419',58392.87,60539.47,0.00,0.00,2146.60,701526.00,0.00,0.00,0.00),('1','186','940','208406',4044875,'2761','419',60539.47,60859.47,0.00,0.00,320.00,96000.00,0.00,0.00,0.00),('1','186','940','208408',4044889,'2761','419',60859.47,72476.97,0.00,0.00,11617.50,3744407.00,0.00,0.00,0.00),('1','186','940','208567',4047604,'2761','419',72476.97,83674.67,0.00,0.00,11197.70,3607838.00,0.00,0.00,0.00),('1','186','940','208661',4049280,'2761','419',83674.67,84877.37,0.00,0.00,1202.70,388126.00,0.00,0.00,0.00),('1','186','940','208847',4052414,'2761','419',84877.37,85719.77,0.00,0.00,842.40,252720.00,0.00,0.00,0.00),('1','186','940','209068',4056240,'2761','419',85719.77,98422.27,0.00,0.00,12702.50,4083100.00,0.00,0.00,0.00),('1','186','940','209193',4058682,'2761','419',98422.27,107990.47,0.00,0.00,9568.20,3130258.40,0.00,0.00,0.00),('1','186','940','209620',4066286,'2761','419',107990.47,108697.37,0.00,0.00,706.90,248764.80,0.00,0.00,0.00),('1','186','940','209835',4070137,'2761','419',108697.37,110369.67,0.00,0.00,1672.30,570471.60,0.00,0.00,0.00),('1','186','940','209837',4070164,'2761','419',110369.67,110719.77,0.00,0.00,350.10,105030.00,0.00,0.00,0.00),('1','186','940','209838',4070165,'2761','419',110719.77,131591.07,0.00,0.00,20871.30,7006944.60,0.00,0.00,0.00),('1','186','940','210113',4074859,'2761','419',131591.07,131898.47,0.00,0.00,307.40,122960.00,0.00,0.00,0.00),('1','186','940','210369',4079307,'2761','419',131898.47,132799.57,0.00,0.00,901.10,341272.80,0.00,0.00,0.00),('1','186','940','210533',4082383,'2761','419',132799.57,135208.57,0.00,0.00,2409.00,857270.40,0.00,0.00,0.00),('1','186','940','210540',4082504,'2761','419',135208.57,135549.77,0.00,0.00,341.20,102360.00,0.00,0.00,0.00),('1','186','940','210922',4089334,'2761','419',135549.77,143633.17,0.00,0.00,8083.40,2867163.20,0.00,0.00,0.00),('1','186','940','210924',4089343,'2761','419',143633.17,151701.27,0.00,0.00,8068.10,2859636.80,0.00,0.00,0.00),('1','186','940','211180',4093702,'2761','419',151701.27,160090.17,0.00,0.00,8388.90,2976768.00,0.00,0.00,0.00),('1','186','940','211184',4093727,'2761','419',160090.17,160430.17,0.00,0.00,340.00,115600.00,0.00,0.00,0.00),('1','186','940','211385',4097415,'2761','419',160430.17,175647.27,0.00,0.00,15217.10,5381302.40,0.00,0.00,0.00),('1','186','940','211477',4098992,'2761','419',175647.27,185095.27,0.00,0.00,9448.00,3355248.00,0.00,0.00,0.00),('1','186','940','211660',4102188,'2761','419',185095.27,185430.17,0.00,0.00,334.90,113866.00,0.00,0.00,0.00),('1','186','940','211662',4102202,'2761','419',185430.17,190180.57,0.00,0.00,4750.40,1753892.00,0.00,0.00,0.00),('1','186','940','212036',4108627,'2761','419',190180.57,203266.17,0.00,0.00,13085.60,4807869.80,0.00,0.00,0.00),('1','186','940','212047',4108794,'2761','419',203266.17,204918.37,0.00,0.00,1652.20,612664.60,0.00,0.00,0.00),('1','186','940','212549',4117944,'2761','419',204918.37,207335.27,0.00,0.00,2416.90,903048.00,0.00,0.00,0.00),('1','186','940','212759',4121607,'2761','419',207335.27,212496.27,0.00,0.00,5161.00,1936940.00,0.00,0.00,0.00),('1','186','940','213102',4127746,'2761','419',212496.27,219845.57,0.00,0.00,7349.30,2740156.00,0.00,0.00,0.00),('1','186','940','213430',4132994,'2761','419',219845.57,224670.69,0.00,0.00,4825.12,1796120.40,0.00,0.00,0.00),('1','186','940','213696',4137512,'2761','419',224670.69,229542.89,0.00,0.00,4872.20,1802774.00,0.00,0.00,0.00),('1','186','940','214060',4143561,'2761','419',229542.89,229916.89,0.00,0.00,374.00,137632.00,0.00,0.00,0.00),('1','186','940','214192',4145715,'2761','419',229916.89,239022.09,0.00,0.00,9105.20,3389342.00,0.00,0.00,0.00),('1','186','940','214334',4148305,'2761','419',239022.09,247107.19,0.00,0.00,8085.10,3021422.00,0.00,0.00,0.00),('1','186','940','214427',4149802,'2761','419',247107.19,250942.39,0.00,0.00,3835.20,1444404.00,0.00,0.00,0.00),('1','186','940','214647',4153510,'2761','419',250942.39,254534.89,0.00,0.00,3592.50,1354290.00,0.00,0.00,0.00),('1','186','940','214831',4156735,'2761','419',254534.89,254906.89,0.00,0.00,372.00,136896.00,0.00,0.00,0.00),('1','186','940','215082',4160916,'2761','419',254906.89,265185.89,0.00,0.00,10279.00,3832396.00,0.00,0.00,0.00),('1','186','940','215161',4162417,'2761','419',265185.89,271639.59,0.00,0.00,6453.70,2409588.00,0.00,0.00,0.00),('1','186','940','215556',4168907,'2761','419',271639.59,279114.49,0.00,0.00,7474.90,2791922.00,0.00,0.00,0.00),('1','186','940','215561',4168971,'2761','419',279114.49,279836.49,0.00,0.00,722.00,265696.00,0.00,0.00,0.00),('1','186','940','215718',4171658,'2761','419',279836.49,293625.39,0.00,0.00,13788.90,5131424.00,0.00,0.00,0.00),('1','186','940','215813',4173575,'2761','419',293625.39,304029.29,0.00,0.00,10403.90,3877880.00,0.00,0.00,0.00),('1','186','940','216124',4178689,'2761','419',304029.29,304996.49,0.00,0.00,967.20,355929.60,0.00,0.00,0.00),('1','186','940','216216',4180303,'2761','419',304996.49,325598.69,0.00,0.00,20602.20,7729721.00,0.00,0.00,0.00),('1','186','940','216685',4188503,'2761','419',325598.69,329624.29,0.00,0.00,4025.60,1549014.60,0.00,0.00,0.00),('1','186','940','216995',4194186,'2761','419',329624.29,329996.49,0.00,0.00,372.20,136969.60,0.00,0.00,0.00),('1','186','940','216996',4194187,'2761','419',329996.49,348712.79,0.00,0.00,18716.30,7425222.00,0.00,0.00,0.00),('1','186','940','217368',4200747,'2761','419',348712.79,354771.54,0.00,0.00,6058.75,2566910.10,0.00,0.00,0.00),('1','186','940','217673',4206260,'2761','419',354771.54,355144.04,0.00,0.00,372.50,141550.00,0.00,0.00,0.00),('1','186','940','217676',4206289,'2761','419',355144.04,358018.36,0.00,0.00,2874.32,1226283.60,0.00,0.00,0.00),('1','186','940','217748',4207245,'2761','419',358018.36,359089.66,0.00,0.00,1071.30,480156.00,0.00,0.00,0.00),('1','186','940','218039',4212535,'2761','419',359089.66,365891.36,0.00,0.00,6801.70,2881526.00,0.00,0.00,0.00),('1','186','940','218276',4216676,'2761','419',365891.36,370293.36,0.00,0.00,4402.00,1876440.00,0.00,0.00,0.00),('1','186','940','218279',4216741,'2761','419',370293.36,379315.16,0.00,0.00,9021.80,3811836.60,0.00,0.00,0.00),('1','186','940','218481',4220263,'2761','419',379315.16,379673.96,0.00,0.00,358.80,143520.00,0.00,0.00,0.00),('1','186','940','218736',4224786,'2761','419',379673.96,385790.46,0.00,0.00,6116.50,2592634.00,0.00,0.00,0.00),('1','186','940','218945',4228471,'2761','419',385790.46,388520.96,0.00,0.00,2730.50,1169540.00,0.00,0.00,0.00),('1','186','940','219058',4230478,'2761','419',388520.96,394311.06,0.00,0.00,5790.10,2459824.80,0.00,0.00,0.00),('1','186','940','220568',4257203,'2761','419',394311.06,399303.56,0.00,0.00,4992.50,2087019.20,0.00,0.00,0.00),('1','186','940','220571',4257261,'2761','419',399303.56,404118.36,0.00,0.00,4814.80,2003795.20,0.00,0.00,0.00),('1','186','940','220581',4257446,'2761','419',404118.36,404513.96,0.00,0.00,395.60,158240.00,0.00,0.00,0.00),('1','186','940','220585',4257500,'2761','419',404513.96,414694.76,0.00,0.00,10180.80,4238218.20,0.00,0.00,0.00),('1','186','940','220597',4257740,'2761','419',414694.76,424300.46,0.00,0.00,9605.70,3994462.20,0.00,0.00,0.00),('1','186','940','220601',4257801,'2761','419',424300.46,429217.26,0.00,0.00,4916.80,2057807.00,0.00,0.00,0.00),('1','186','940','220606',4257851,'2761','419',429217.26,429693.26,0.00,0.00,476.00,190400.00,0.00,0.00,0.00),('1','186','940','220610',4257924,'2761','419',429693.26,436110.26,0.00,0.00,6417.00,2687304.00,0.00,0.00,0.00),('1','186','940','220763',4260430,'2761','419',436110.26,446889.56,0.00,0.00,10779.30,4466386.80,0.00,0.00,0.00),('1','186','940','221107',4266888,'2761','419',446889.56,453937.36,0.00,0.00,7047.80,2930572.20,0.00,0.00,0.00),('1','186','940','221110',4266944,'2761','419',453937.36,454229.96,0.00,0.00,292.60,119966.00,0.00,0.00,0.00),('1','186','940','221111',4266945,'2761','419',454229.96,454613.26,0.00,0.00,383.30,153320.00,0.00,0.00,0.00),('1','186','940','221683',4277099,'2761','419',454613.26,461658.56,0.00,0.00,7045.30,2910564.00,0.00,0.00,0.00),('1','186','940','221828',4279787,'2761','419',461658.56,471123.66,0.00,0.00,9465.10,3915498.00,0.00,0.00,0.00),('1','186','940','222134',4285151,'2761','419',471123.66,479246.36,0.00,0.00,8122.70,3373963.00,0.00,0.00,0.00),('1','186','940','222345',4288683,'2761','419',479246.36,479614.26,0.00,0.00,367.90,147160.00,0.00,0.00,0.00),('1','186','940','222350',4288759,'2761','419',479614.26,488934.06,0.00,0.00,9319.80,3864576.00,0.00,0.00,0.00),('1','186','940','222574',4292580,'2761','419',488934.06,497068.06,0.00,0.00,8134.00,3374315.00,0.00,0.00,0.00),('1','186','940','222793',4296679,'2761','419',497068.06,504236.26,0.00,0.00,7168.20,2960034.60,0.00,0.00,0.00),('1','186','940','223010',4300901,'2761','419',504236.26,504614.26,0.00,0.00,378.00,151200.00,0.00,0.00,0.00),('1','186','940','223012',4300927,'2761','419',504614.26,518127.66,0.00,0.00,13513.40,5585543.00,0.00,0.00,0.00),('1','186','940','223194',4303867,'2761','419',518127.66,523664.76,0.00,0.00,5537.10,2289143.20,0.00,0.00,0.00),('1','186','940','223200',4303920,'2761','419',523664.76,524044.26,0.00,0.00,379.50,151800.00,0.00,0.00,0.00),('1','186','940','223228',4304407,'2761','419',524044.26,542912.76,0.00,0.00,18868.50,7771480.00,0.00,0.00,0.00),('1','186','940','223515',4309471,'2761','419',542912.76,548695.26,0.00,0.00,5782.50,2581601.60,0.00,0.00,0.00),('1','186','940','223543',4310070,'2761','419',548695.26,548695.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','224137',4320759,'2761','419',548695.26,556260.46,0.00,0.00,7565.20,3422148.00,0.00,0.00,0.00),('1','186','940','224386',4325281,'2761','419',556260.46,572933.46,0.00,0.00,16673.00,7506442.00,0.00,0.00,0.00),('1','186','940','224624',4329436,'2761','419',572933.46,573349.06,0.00,0.00,415.60,198656.80,0.00,0.00,0.00),('1','186','940','224629',4329526,'2761','419',573349.06,573349.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','224669',4330245,'2761','419',573349.06,580482.76,0.00,0.00,7133.70,3437436.00,0.00,0.00,0.00),('1','186','940','224698',4330685,'2761','419',580482.76,592211.46,0.00,0.00,11728.70,5625421.80,0.00,0.00,0.00),('1','186','940','224807',4332562,'2761','419',592211.46,598000.96,0.00,0.00,5789.50,2787606.00,0.00,0.00,0.00),('1','186','940','224997',4336382,'2761','419',598000.96,598000.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','225162',4339192,'2761','419',598000.96,606516.26,0.00,0.00,8515.30,3935942.60,0.00,0.00,0.00),('1','186','940','225461',4344837,'2761','419',606516.26,620608.96,0.00,0.00,14092.70,6494543.60,0.00,0.00,0.00),('1','186','940','225549',4346169,'2761','419',620608.96,622653.96,0.00,0.00,2045.00,948556.20,0.00,0.00,0.00),('1','186','940','225674',4348550,'2761','419',622653.96,622653.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','225675',4348551,'2761','419',622653.96,642141.86,0.00,0.00,19487.90,8957098.00,0.00,0.00,0.00),('1','186','940','225994',4353723,'2761','419',642141.86,647309.36,0.00,0.00,5167.50,2481117.00,0.00,0.00,0.00),('1','186','940','226042',4354603,'2761','419',647309.36,647309.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','226069',4355035,'2761','419',647309.36,653920.36,0.00,0.00,6611.00,3181720.00,0.00,0.00,0.00),('1','186','940','226275',4358911,'2761','419',653920.36,656338.94,0.00,0.00,2418.58,1154647.85,0.00,0.00,0.00),('1','186','940','226542',4363551,'2761','419',656338.94,670461.34,0.00,0.00,14122.40,6580883.70,0.00,0.00,0.00),('1','186','940','226931',4371050,'2761','419',670461.34,671900.26,0.00,0.00,1438.92,703341.60,0.00,0.00,0.00),('1','186','940','226985',4371594,'2761','419',671900.26,671900.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','226990',4371691,'2761','419',671900.26,689725.76,0.00,0.00,17825.50,8299550.00,0.00,0.00,0.00),('1','186','940','226996',4371752,'2761','419',689725.76,691571.14,0.00,0.00,1845.38,910242.40,0.00,0.00,0.00),('1','186','940','227199',4375384,'2761','419',691571.14,696448.31,0.00,0.00,4877.17,2359890.26,0.00,0.00,0.00),('1','186','940','227675',4383746,'2761','419',696448.31,696448.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','227682',4383899,'2761','419',696448.31,712765.81,0.00,0.00,16317.50,7834000.00,0.00,0.00,0.00),('1','186','940','227897',4387734,'2761','419',712765.81,719489.31,0.00,0.00,6723.50,3238820.00,0.00,0.00,0.00),('1','186','940','227907',4387829,'2761','419',719489.31,721000.71,0.00,0.00,1511.40,734092.00,0.00,0.00,0.00),('1','186','940','228099',4391841,'2761','419',721000.71,721000.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','228101',4391855,'2761','419',721000.71,725861.21,0.00,0.00,4860.50,2341060.00,0.00,0.00,0.00),('1','186','940','228117',4391978,'2761','419',725861.21,739181.51,0.00,0.00,13320.30,6396394.20,0.00,0.00,0.00),('1','186','940','228338',4396407,'2761','419',739181.51,744593.21,0.00,0.00,5411.70,2677588.00,0.00,0.00,0.00),('1','186','940','228548',4400015,'2761','419',744593.21,745654.94,0.00,0.00,1061.73,538045.00,0.00,0.00,0.00),('1','186','940','228738',4403951,'2761','419',745654.94,745654.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','228801',4404743,'2761','419',745654.94,747517.94,0.00,0.00,1863.00,931720.00,0.00,0.00,0.00),('1','186','940','228825',4405250,'2761','419',747517.94,749311.61,0.00,0.00,1793.67,922181.80,0.00,0.00,0.00),('1','186','940','228945',4407476,'2761','419',749311.61,752698.31,0.00,0.00,3386.70,1714232.00,0.00,0.00,0.00),('1','186','940','229195',4412307,'2761','419',752698.31,770313.24,0.00,0.00,17614.93,8807453.94,0.00,0.00,0.00),('1','186','940','229434',4416523,'2761','419',770313.24,770313.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','229501',4417798,'2761','419',770313.24,770313.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','229507',4417873,'2761','419',770313.24,770313.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','229738',4422515,'2761','419',770313.24,771725.74,0.00,0.00,1412.50,738600.00,0.00,0.00,0.00),('1','186','940','229870',4425541,'2761','419',771725.74,774892.24,0.00,0.00,3166.50,1661622.00,0.00,0.00,0.00),('1','186','940','229903',4425817,'2761','419',774892.24,784465.94,0.00,0.00,9573.70,5006881.60,0.00,0.00,0.00),('1','186','940','230073',4429253,'2761','419',784465.94,792839.44,0.00,0.00,8373.50,4383948.00,0.00,0.00,0.00),('1','186','940','230278',4432990,'2761','419',792839.44,794975.74,0.00,0.00,2136.30,1132446.80,0.00,0.00,0.00),('1','186','940','230516',4437474,'2761','419',794975.74,794975.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','230517',4437475,'2761','419',794975.74,805344.24,0.00,0.00,10368.50,5419108.00,0.00,0.00,0.00),('1','186','940','230768',4442033,'2761','419',805344.24,813969.54,0.00,0.00,8625.30,4514220.40,0.00,0.00,0.00),('1','186','940','231126',4447964,'2761','419',813969.54,819644.54,0.00,0.00,5675.00,2961623.70,0.00,0.00,0.00),('1','186','940','231442',4452914,'2761','419',819644.54,819644.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','232074',4464571,'2761','419',819644.54,820956.54,0.00,0.00,1312.00,715948.50,0.00,0.00,0.00),('1','186','940','232131',4465274,'2761','419',820956.54,828686.44,0.00,0.00,7729.90,4216088.30,0.00,0.00,0.00),('1','186','940','232372',4469513,'2761','419',828686.44,836827.64,0.00,0.00,8141.20,4437133.60,0.00,0.00,0.00),('1','186','940','232596',4473692,'2761','419',836827.64,844295.64,0.00,0.00,7468.00,4068304.00,0.00,0.00,0.00),('1','186','940','232863',4478372,'2761','419',844295.64,844295.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','233009',4481169,'2761','419',844295.64,853775.24,0.00,0.00,9479.60,5162919.80,0.00,0.00,0.00),('1','186','940','233099',4482897,'2761','419',853775.24,867587.94,0.00,0.00,13812.70,7508567.60,0.00,0.00,0.00),('1','186','940','233587',4491850,'2761','419',867587.94,869036.14,0.00,0.00,1448.20,813888.40,0.00,0.00,0.00),('1','186','940','233765',4494895,'2761','419',869036.14,869036.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','233816',4495875,'2761','419',869036.14,871419.59,0.00,0.00,2383.45,1368603.80,0.00,0.00,0.00),('1','186','940','234098',4500760,'2761','419',871419.59,875376.09,0.00,0.00,3956.50,2255526.00,0.00,0.00,0.00),('1','186','940','234179',4502445,'2761','419',875376.09,879193.59,0.00,0.00,3817.50,2165670.00,0.00,0.00,0.00),('1','186','940','234311',4504690,'2761','419',879193.59,880660.09,0.00,0.00,1466.50,835766.00,0.00,0.00,0.00),('1','186','940','234584',4509446,'2761','419',880660.09,883078.29,0.00,0.00,2418.20,1387592.80,0.00,0.00,0.00),('1','186','940','234825',4513786,'2761','419',883078.29,885794.09,0.00,0.00,2715.80,1555143.20,0.00,0.00,0.00),('1','186','940','235121',4519008,'2761','419',885794.09,893563.64,0.00,0.00,7769.55,4375058.30,0.00,0.00,0.00),('1','186','940','235178',4520095,'2761','419',893563.64,893802.74,0.00,0.00,239.10,134374.20,0.00,0.00,0.00),('1','186','940','235179',4520096,'2761','419',893802.74,893802.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','235274',4521798,'2761','419',893802.74,908346.54,0.00,0.00,14543.80,8205355.20,0.00,0.00,0.00),('1','186','940','235323',4522450,'2761','419',908346.54,917786.04,0.00,0.00,9439.50,5343932.00,0.00,0.00,0.00),('1','186','940','235534',4526194,'2761','419',917786.04,918440.14,0.00,0.00,654.10,377281.20,0.00,0.00,0.00),('1','186','940','235712',4529462,'2761','419',918440.14,918440.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','235713',4529463,'2761','419',918440.14,928003.64,0.00,0.00,9563.50,5465254.00,0.00,0.00,0.00),('1','186','940','235758',4530190,'2761','419',928003.64,936150.64,0.00,0.00,8147.00,4660188.00,0.00,0.00,0.00),('1','186','940','236070',4535519,'2761','419',936150.64,943085.64,0.00,0.00,6935.00,3970228.00,0.00,0.00,0.00),('1','186','940','236245',4538783,'2761','419',943085.64,943085.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','236441',4542396,'2761','419',943085.64,955529.14,0.00,0.00,12443.50,7117874.00,0.00,0.00,0.00),('1','186','940','236521',4543652,'2761','419',955529.14,963852.64,0.00,0.00,8323.50,4775094.00,0.00,0.00,0.00),('1','186','940','236721',4547049,'2761','419',963852.64,967733.64,0.00,0.00,3881.00,2219152.00,0.00,0.00,0.00),('1','186','940','236924',4550759,'2761','419',967733.64,967733.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','237522',4561344,'2761','419',967733.64,984461.14,0.00,0.00,16727.50,9893880.00,0.00,0.00,0.00),('1','186','940','237686',4564096,'2761','419',984461.14,990730.19,0.00,0.00,6269.05,3774639.60,0.00,0.00,0.00),('1','186','940','237899',4567472,'2761','419',990730.19,992367.64,0.00,0.00,1637.45,977538.75,0.00,0.00,0.00),('1','186','940','238081',4570678,'2761','419',992367.64,992367.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','238223',4573010,'2761','419',992367.64,996260.47,0.00,0.00,3892.83,2322248.69,0.00,0.00,0.00),('1','186','940','238351',4575222,'2761','419',996260.47,1010323.47,0.00,0.00,14063.00,8357432.90,0.00,0.00,0.00),('1','186','940','238609',4579403,'2761','419',1010323.47,1017063.64,0.00,0.00,6740.17,4014110.25,0.00,0.00,0.00),('1','186','940','238891',4584502,'2761','419',1017063.64,1017063.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','238899',4584628,'2761','419',1017063.64,1033580.84,0.00,0.00,16517.20,9819580.05,0.00,0.00,0.00),('1','186','940','239082',4587796,'2761','419',1033580.84,1041671.64,0.00,0.00,8090.80,4815381.27,0.00,0.00,0.00),('1','186','940','239304',4591644,'2761','419',1041671.64,1041671.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','239432',4593897,'2761','419',1041671.64,1045889.14,0.00,0.00,4217.50,2520160.00,0.00,0.00,0.00),('1','186','940','239698',4598641,'2761','419',1045889.14,1064584.64,0.00,0.00,18695.50,11118706.00,0.00,0.00,0.00),('1','186','940','239871',4601543,'2761','419',1064584.64,1066224.64,0.00,0.00,1640.00,990560.00,0.00,0.00,0.00),('1','186','940','240168',4606829,'2761','419',1066224.64,1066224.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','240308',4609126,'2761','419',1066224.64,1066581.78,0.00,0.00,357.14,214998.28,0.00,0.00,0.00),('1','186','940','240320',4609376,'2761','419',1066581.78,1067988.28,0.00,0.00,1406.50,859400.00,0.00,0.00,0.00),('1','186','940','240476',4611571,'2761','419',1067988.28,1087517.94,0.00,0.00,19529.66,11624448.88,0.00,0.00,0.00),('1','186','940','240721',4615416,'2761','419',1087517.94,1087517.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','240735',4615672,'2761','419',1087517.94,1091743.94,0.00,0.00,4226.00,2537790.00,0.00,0.00,0.00),('1','186','940','240987',4620128,'2761','419',1091743.94,1095599.44,0.00,0.00,3855.50,2303770.00,0.00,0.00,0.00),('1','186','940','241244',4624796,'2761','419',1095599.44,1110495.44,0.00,0.00,14896.00,8859590.00,0.00,0.00,0.00),('1','186','940','241519',4629359,'2761','419',1110495.44,1112171.64,0.00,0.00,1676.20,993986.60,0.00,0.00,0.00),('1','186','940','241698',4632802,'2761','419',1112171.64,1112171.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','241776',4633953,'2761','419',1112171.64,1114396.64,0.00,0.00,2225.00,1328350.00,0.00,0.00,0.00),('1','186','940','242031',4638339,'2761','419',1114396.64,1116950.64,0.00,0.00,2554.00,1534810.00,0.00,0.00,0.00),('1','186','940','242228',4641855,'2761','419',1116950.64,1129673.64,0.00,0.00,12723.00,7480520.00,0.00,0.00,0.00),('1','186','940','242431',4645450,'2761','419',1129673.64,1132096.14,0.00,0.00,2422.50,1446100.00,0.00,0.00,0.00),('1','186','940','242724',4650542,'2761','419',1132096.14,1136722.64,0.00,0.00,4626.50,2684700.00,0.00,0.00,0.00),('1','186','940','242970',4654699,'2761','419',1136722.64,1136722.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','242975',4654772,'2761','419',1136722.64,1144330.64,0.00,0.00,7608.00,4429356.00,0.00,0.00,0.00),('1','186','940','243211',4659015,'2761','419',1144330.64,1156048.14,0.00,0.00,11717.50,6801325.00,0.00,0.00,0.00),('1','186','940','243432',4662866,'2761','419',1156048.14,1161799.24,0.00,0.00,5751.10,3340893.00,0.00,0.00,0.00),('1','186','940','243868',4670373,'2761','419',1161799.24,1161799.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','243900',4671038,'2761','419',1161799.24,1162929.89,0.00,0.00,1130.65,653515.70,0.00,0.00,0.00),('1','186','940','243903',4671071,'2761','419',1162929.89,1170343.39,0.00,0.00,7413.50,4309605.00,0.00,0.00,0.00),('1','186','940','244095',4674385,'2761','419',1170343.39,1183773.39,0.00,0.00,13430.00,7788800.00,0.00,0.00,0.00),('1','186','940','244308',4677862,'2761','419',1183773.39,1186392.74,0.00,0.00,2619.35,1517338.30,0.00,0.00,0.00),('1','186','940','244548',4682084,'2761','419',1186392.74,1186392.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','244558',4682212,'2761','419',1186392.74,1194273.14,0.00,0.00,7880.40,4590402.00,0.00,0.00,0.00),('1','186','940','244805',4686550,'2761','419',1194273.14,1211065.74,0.00,0.00,16792.60,9735638.80,0.00,0.00,0.00),('1','186','940','245254',4694355,'2761','419',1211065.74,1211065.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','245261',4694419,'2761','419',1211065.74,1213228.36,0.00,0.00,2162.62,1249994.36,0.00,0.00,0.00),('1','186','940','245277',4694746,'2761','419',1213228.36,1228835.86,0.00,0.00,15607.50,9059225.00,0.00,0.00,0.00),('1','186','940','245501',4698696,'2761','419',1228835.86,1235860.75,0.00,0.00,7024.89,5767888.97,0.00,0.00,0.00),('1','186','940','246011',4707024,'2761','419',1235860.75,1235860.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','246030',4707380,'2761','419',1235860.75,1238826.69,0.00,0.00,2965.94,1654994.52,0.00,0.00,0.00),('1','186','940','246055',4707798,'2761','419',1238826.69,1243113.19,0.00,0.00,4286.50,2420284.00,0.00,0.00,0.00),('1','186','940','246251',4711104,'2761','419',1243113.19,1245885.14,0.00,0.00,2771.95,1567041.20,0.00,0.00,0.00),('1','186','940','246512',4715499,'2761','419',1245885.14,1249991.64,0.00,0.00,4106.50,2311804.00,0.00,0.00,0.00),('1','186','940','246763',4719784,'2761','419',1249991.64,1253963.64,0.00,0.00,3972.00,2242352.00,0.00,0.00,0.00),('1','186','940','246994',4723867,'2761','419',1253963.64,1260524.75,0.00,0.00,6561.11,3689861.60,0.00,0.00,0.00),('1','186','940','247362',4730621,'2761','419',1260524.75,1260524.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','247363',4730622,'2761','419',1260524.75,1262623.25,0.00,0.00,2098.50,1149978.00,0.00,0.00,0.00),('1','186','940','247418',4731241,'2761','419',1262623.25,1273709.25,0.00,0.00,11086.00,6099100.00,0.00,0.00,0.00),('1','186','940','247716',4736317,'2761','419',1273709.25,1279099.75,0.00,0.00,5390.50,2977300.00,0.00,0.00,0.00),('1','186','940','248463',4748759,'2761','419',1279099.75,1284862.75,0.00,0.00,5763.00,3166600.00,0.00,0.00,0.00),('1','186','940','248745',4753815,'2761','419',1284862.75,1284862.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','248748',4753865,'2761','419',1284862.75,1290832.05,0.00,0.00,5969.30,3292980.00,0.00,0.00,0.00),('1','186','940','248913',4756442,'2761','419',1290832.05,1303917.05,0.00,0.00,13085.00,7084900.00,0.00,0.00,0.00),('1','186','940','249145',4760184,'2761','419',1303917.05,1309456.05,0.00,0.00,5539.00,2983762.00,0.00,0.00,0.00),('1','186','940','249362',4764191,'2761','419',1309456.05,1309456.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','249511',4766724,'2761','419',1309456.05,1317413.05,0.00,0.00,7957.00,4305060.00,0.00,0.00,0.00),('1','186','940','249641',4768762,'2761','419',1317413.05,1327447.05,0.00,0.00,10034.00,5426342.00,0.00,0.00,0.00),('1','186','940','249891',4772986,'2761','419',1327447.05,1334077.55,0.00,0.00,6630.50,3587490.00,0.00,0.00,0.00),('1','186','940','250203',4778358,'2761','419',1334077.55,1334077.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','250206',4778389,'2761','419',1334077.55,1343146.05,0.00,0.00,9068.50,4735730.00,0.00,0.00,0.00),('1','186','940','250417',4781719,'2761','419',1343146.05,1353206.05,0.00,0.00,10060.00,5238600.00,0.00,0.00,0.00),('1','186','940','250630',4785327,'2761','419',1353206.05,1358741.55,0.00,0.00,5535.50,2879880.00,0.00,0.00,0.00),('1','186','940','250870',4789741,'2761','419',1358741.55,1358741.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','251103',4793773,'2761','419',1358741.55,1360591.55,0.00,0.00,1850.00,958300.00,0.00,0.00,0.00),('1','186','940','251109',4793849,'2761','419',1360591.55,1370521.05,0.00,0.00,9929.50,5176520.00,0.00,0.00,0.00),('1','186','940','251363',4798318,'2761','419',1370521.05,1379146.05,0.00,0.00,8625.00,4500000.00,0.00,0.00,0.00),('1','186','940','251614',4802661,'2761','419',1379146.05,1383394.65,0.00,0.00,4248.60,2214152.00,0.00,0.00,0.00),('1','186','940','252089',4811060,'2761','419',1383394.65,1383394.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','252094',4811094,'2761','419',1383394.65,1384694.65,0.00,0.00,1300.00,673400.00,0.00,0.00,0.00),('1','186','940','252104',4811199,'2761','419',1384694.65,1395402.65,0.00,0.00,10708.00,5583480.00,0.00,0.00,0.00),('1','186','940','252306',4814566,'2761','419',1395402.65,1398558.15,0.00,0.00,3155.50,1657080.00,0.00,0.00,0.00),('1','186','940','252495',4818123,'2761','419',1398558.15,1408108.05,0.00,0.00,9549.90,4894665.20,0.00,0.00,0.00),('1','186','940','252811',4823477,'2761','419',1408108.05,1408108.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','253032',4827007,'2761','419',1408108.05,1411159.23,0.00,0.00,3051.18,1549999.44,0.00,0.00,0.00),('1','186','940','253035',4827045,'2761','419',1411159.23,1428417.73,0.00,0.00,17258.50,8811260.00,0.00,0.00,0.00),('1','186','940','253282',4831423,'2761','419',1428417.73,1432699.23,0.00,0.00,4281.50,2191140.00,0.00,0.00,0.00),('1','186','940','253686',4838527,'2761','419',1432699.23,1432699.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','253689',4838550,'2761','419',1432699.23,1434199.23,0.00,0.00,1500.00,762000.00,0.00,0.00,0.00),('1','186','940','253772',4839713,'2761','419',1434199.23,1450472.34,0.00,0.00,16273.11,8309787.88,0.00,0.00,0.00),('1','186','940','254025',4844173,'2761','419',1450472.34,1452083.23,0.00,0.00,1610.89,824353.90,0.00,0.00,0.00),('1','186','940','254542',4853331,'2761','419',1452083.23,1452083.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','254544',4853333,'2761','419',1452083.23,1454445.43,0.00,0.00,2362.20,1199997.60,0.00,0.00,0.00),('1','186','940','254549',4853421,'2761','419',1454445.43,1456828.93,0.00,0.00,2383.50,1212560.00,0.00,0.00,0.00),('1','186','940','254552',4853436,'2761','419',1456828.93,1466201.09,0.00,0.00,9372.16,4804159.60,0.00,0.00,0.00),('1','186','940','254763',4856881,'2761','419',1466201.09,1469126.39,0.00,0.00,2925.30,1530418.00,0.00,0.00,0.00),('1','186','940','255000',4860982,'2761','419',1469126.39,1476339.03,0.00,0.00,7212.64,3679703.16,0.00,0.00,0.00),('1','186','940','255369',4867710,'2761','419',1476339.03,1476656.23,0.00,0.00,317.20,161137.60,0.00,0.00,0.00),('1','186','940','255535',4870067,'2761','419',1476656.23,1476656.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','255540',4870118,'2761','419',1476656.23,1484106.23,0.00,0.00,7450.00,3784600.00,0.00,0.00,0.00),('1','186','940','255550',4870274,'2761','419',1484106.23,1496630.23,0.00,0.00,12524.00,6385440.00,0.00,0.00,0.00),('1','186','940','255777',4874118,'2761','419',1496630.23,1501307.23,0.00,0.00,4677.00,2381545.00,0.00,0.00,0.00),('1','186','940','255947',4876999,'2761','419',1501307.23,1501307.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','256125',4880104,'2761','419',1501307.23,1508307.23,0.00,0.00,7000.00,3556000.00,0.00,0.00,0.00),('1','186','940','256286',4882389,'2761','419',1508307.23,1520373.23,0.00,0.00,12066.00,6163960.00,0.00,0.00,0.00),('1','186','940','256557',4887109,'2761','419',1520373.23,1525931.93,0.00,0.00,5558.70,2839762.00,0.00,0.00,0.00),('1','186','940','256775',4890668,'2761','419',1525931.93,1525931.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','256870',4892543,'2761','419',1525931.93,1530044.43,0.00,0.00,4112.50,2095000.00,0.00,0.00,0.00),('1','186','940','257024',4895010,'2761','419',1530044.43,1534214.43,0.00,0.00,4170.00,2137100.00,0.00,0.00,0.00),('1','186','940','257310',4900254,'2761','419',1534214.43,1537737.43,0.00,0.00,3523.00,1810380.00,0.00,0.00,0.00),('1','186','940','257547',4904242,'2761','419',1537737.43,1551615.23,0.00,0.00,13877.80,6975050.00,0.00,0.00,0.00),('1','186','940','257548',4904243,'2761','419',1551615.23,1551615.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257549',4904244,'2761','419',1551615.23,1570348.73,0.00,0.00,18733.50,9403940.00,0.00,0.00,0.00),('1','186','940','257550',4904245,'2761','419',1570348.73,1576139.23,0.00,0.00,5790.50,2907828.00,0.00,0.00,0.00),('1','186','940','257551',4904246,'2761','419',1576139.23,1576139.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257552',4904247,'2761','419',1576139.23,1595367.23,0.00,0.00,19228.00,9659155.00,0.00,0.00,0.00),('1','186','940','257553',4904248,'2761','419',1595367.23,1600781.23,0.00,0.00,5414.00,2713453.00,0.00,0.00,0.00),('1','186','940','257554',4904249,'2761','419',1600781.23,1600781.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257555',4904250,'2761','419',1600781.23,1619741.73,0.00,0.00,18960.50,9532090.00,0.00,0.00,0.00),('1','186','940','257556',4904251,'2761','419',1619741.73,1625394.23,0.00,0.00,5652.50,2843600.00,0.00,0.00,0.00),('1','186','940','257557',4904252,'2761','419',1625394.23,1625394.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257558',4904253,'2761','419',1625394.23,1627944.23,0.00,0.00,2550.00,1275000.00,0.00,0.00,0.00),('1','186','940','257559',4904254,'2761','419',1627944.23,1644367.23,0.00,0.00,16423.00,8261580.00,0.00,0.00,0.00),('1','186','940','257560',4904255,'2761','419',1644367.23,1650016.93,0.00,0.00,5649.70,2840629.40,0.00,0.00,0.00),('1','186','940','257561',4904256,'2761','419',1650016.93,1650016.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257562',4904257,'2761','419',1650016.93,1652036.43,0.00,0.00,2019.50,1010920.00,0.00,0.00,0.00),('1','186','940','257563',4904258,'2761','419',1652036.43,1667675.93,0.00,0.00,15639.50,7844720.00,0.00,0.00,0.00),('1','186','940','257564',4904259,'2761','419',1667675.93,1674457.93,0.00,0.00,6782.00,3406970.00,0.00,0.00,0.00),('1','186','940','257565',4904260,'2761','419',1674457.93,1674457.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257566',4904261,'2761','419',1674457.93,1676807.93,0.00,0.00,2350.00,1175000.00,0.00,0.00,0.00),('1','186','940','257567',4904262,'2761','419',1676807.93,1694441.53,0.00,0.00,17633.60,8866356.00,0.00,0.00,0.00),('1','186','940','257568',4904263,'2761','419',1694441.53,1699005.93,0.00,0.00,4564.40,2287500.00,0.00,0.00,0.00),('1','186','940','257569',4904264,'2761','419',1699005.93,1699005.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257570',4904265,'2761','419',1699005.93,1716245.43,0.00,0.00,17239.50,8645820.00,0.00,0.00,0.00),('1','186','940','257571',4904266,'2761','419',1716245.43,1723490.43,0.00,0.00,7245.00,3631070.00,0.00,0.00,0.00),('1','186','940','257572',4904267,'2761','419',1723490.43,1723490.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257573',4904268,'2761','419',1723490.43,1726520.43,0.00,0.00,3030.00,1515000.00,0.00,0.00,0.00),('1','186','940','257574',4904269,'2761','419',1726520.43,1743319.13,0.00,0.00,16798.70,8442972.00,0.00,0.00,0.00),('1','186','940','257575',4904270,'2761','419',1743319.13,1748068.13,0.00,0.00,4749.00,2407436.00,0.00,0.00,0.00),('1','186','940','257576',4904271,'2761','419',1748068.13,1748068.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257577',4904272,'2761','419',1748068.13,1751774.53,0.00,0.00,3706.40,2396584.00,0.00,0.00,0.00),('1','186','940','257578',4904273,'2761','419',1751774.53,1755871.53,0.00,0.00,4097.00,2070820.00,0.00,0.00,0.00),('1','186','940','257579',4904274,'2761','419',1755871.53,1759001.53,0.00,0.00,3130.00,1572800.00,0.00,0.00,0.00),('1','186','940','257580',4904275,'2761','419',1759001.53,1769352.83,0.00,0.00,10351.30,5217228.00,0.00,0.00,0.00),('1','186','940','257581',4904276,'2761','419',1769352.83,1772601.83,0.00,0.00,3249.00,1639680.00,0.00,0.00,0.00),('1','186','940','257582',4904277,'2761','419',1772601.83,1772601.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257583',4904278,'2761','419',1772601.83,1773784.33,0.00,0.00,1182.50,620600.00,0.00,0.00,0.00),('1','186','940','257584',4904279,'2761','419',1773784.33,1789386.04,0.00,0.00,15601.71,8175743.54,0.00,0.00,0.00),('1','186','940','257585',4904280,'2761','419',1789386.04,1797088.90,0.00,0.00,7702.86,4040845.92,0.00,0.00,0.00),('1','186','940','257586',4904281,'2761','419',1797088.90,1797088.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257587',4904282,'2761','419',1797088.90,1801538.90,0.00,0.00,4450.00,2327100.00,0.00,0.00,0.00),('1','186','940','257588',4904283,'2761','419',1801538.90,1808096.40,0.00,0.00,6557.50,3451630.00,0.00,0.00,0.00),('1','186','940','257589',4904284,'2761','419',1808096.40,1821410.83,0.00,0.00,13314.43,6980627.46,0.00,0.00,0.00),('1','186','940','257590',4904285,'2761','419',1821410.83,1821410.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257591',4904286,'2761','419',1821410.83,1824660.83,0.00,0.00,3250.00,1696500.00,0.00,0.00,0.00),('1','186','940','257592',4904287,'2761','419',1824660.83,1840491.11,0.00,0.00,15830.28,8300377.92,0.00,0.00,0.00),('1','186','940','257593',4904288,'2761','419',1840491.11,1845923.91,0.00,0.00,5432.80,2855491.20,0.00,0.00,0.00),('1','186','940','257594',4904289,'2761','419',1845923.91,1845923.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257595',4904290,'2761','419',1845923.91,1849017.56,0.00,0.00,3093.65,1618818.60,0.00,0.00,0.00),('1','186','940','257596',4904291,'2761','419',1849017.56,1862552.56,0.00,0.00,13535.00,7110440.00,0.00,0.00,0.00),('1','186','940','257597',4904292,'2761','419',1862552.56,1870201.61,0.00,0.00,7649.05,4001864.20,0.00,0.00,0.00),('1','186','940','257598',4904293,'2761','419',1870201.61,1870219.61,0.00,0.00,18.00,9432.00,0.00,0.00,0.00),('1','186','940','257599',4904294,'2761','419',1870219.61,1870219.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257600',4904295,'2761','419',1870219.61,1872516.11,0.00,0.00,2296.50,1303830.00,0.00,0.00,0.00),('1','186','940','257601',4904296,'2761','419',1872516.11,1874883.11,0.00,0.00,2367.00,1361540.00,0.00,0.00,0.00),('1','186','940','257602',4904297,'2761','419',1874883.11,1891629.11,0.00,0.00,16746.00,9714534.00,0.00,0.00,0.00),('1','186','940','257603',4904298,'2761','419',1891629.11,1894882.61,0.00,0.00,3253.50,1888870.00,0.00,0.00,0.00),('1','186','940','257604',4904299,'2761','419',1894882.61,1894882.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257605',4904300,'2761','419',1894882.61,1901898.09,0.00,0.00,7015.48,4057354.04,0.00,0.00,0.00),('1','186','940','257606',4904301,'2761','419',1901898.09,1903410.59,0.00,0.00,1512.50,905750.00,0.00,0.00,0.00),('1','186','940','257607',4904302,'2761','419',1903410.59,1908244.09,0.00,0.00,4833.50,2814770.00,0.00,0.00,0.00),('1','186','940','257608',4904303,'2761','419',1908244.09,1914527.61,0.00,0.00,6283.52,3647182.40,0.00,0.00,0.00),('1','186','940','257609',4904304,'2761','419',1914527.61,1914527.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257610',4904305,'2761','419',1914527.61,1915227.61,0.00,0.00,700.00,404600.00,0.00,0.00,0.00),('1','186','940','257611',4904306,'2761','419',1915227.61,1928274.61,0.00,0.00,13047.00,7525540.00,0.00,0.00,0.00),('1','186','940','257612',4904307,'2761','419',1928274.61,1933629.61,0.00,0.00,5355.00,3109500.00,0.00,0.00,0.00),('1','186','940','257613',4904308,'2761','419',1933629.61,1939192.61,0.00,0.00,5563.00,3206288.00,0.00,0.00,0.00),('1','186','940','257614',4904309,'2761','419',1939192.61,1939192.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257615',4904310,'2761','419',1939192.61,1950409.61,0.00,0.00,11217.00,6478540.00,0.00,0.00,0.00),('1','186','940','257616',4904311,'2761','419',1950409.61,1960570.11,0.00,0.00,10160.50,5862910.00,0.00,0.00,0.00),('1','186','940','257617',4904312,'2761','419',1960570.11,1963416.61,0.00,0.00,2846.50,1637444.00,0.00,0.00,0.00),('1','186','940','257618',4904313,'2761','419',1963416.61,1963416.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257619',4904314,'2761','419',1963416.61,1980970.11,0.00,0.00,17553.50,10104570.00,0.00,0.00,0.00),('1','186','940','257620',4904315,'2761','419',1980970.11,1981230.61,0.00,0.00,260.50,163930.00,0.00,0.00,0.00),('1','186','940','257621',4904316,'2761','419',1981230.61,1982444.21,0.00,0.00,1213.60,784976.00,0.00,0.00,0.00),('1','186','940','257622',4904317,'2761','419',1982444.21,1983600.41,0.00,0.00,1156.20,745092.00,0.00,0.00,0.00),('1','186','940','257623',4904318,'2761','419',1983600.41,1984568.01,0.00,0.00,967.60,620616.00,0.00,0.00,0.00),('1','186','940','257624',4904319,'2761','419',1984568.01,1988010.61,0.00,0.00,3442.60,1998978.80,0.00,0.00,0.00),('1','186','940','257625',4904320,'2761','419',1988010.61,1988010.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257626',4904321,'2761','419',1988010.61,1999573.91,0.00,0.00,11563.30,6732146.00,0.00,0.00,0.00),('1','186','940','257627',4904322,'2761','419',1999573.91,2012623.61,0.00,0.00,13049.70,7561814.00,0.00,0.00,0.00),('1','186','940','257628',4904323,'2761','419',2012623.61,2012623.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257629',4904324,'2761','419',2012623.61,2029849.91,0.00,0.00,17226.30,9985706.00,0.00,0.00,0.00),('1','186','940','257630',4904325,'2761','419',2029849.91,2035534.41,0.00,0.00,5684.50,3302390.00,0.00,0.00,0.00),('1','186','940','257631',4904326,'2761','419',2035534.41,2037017.61,0.00,0.00,1483.20,867584.00,0.00,0.00,0.00),('1','186','940','257632',4904327,'2761','419',2037017.61,2037017.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257633',4904328,'2761','419',2037017.61,2038879.91,0.00,0.00,1862.30,1076409.40,0.00,0.00,0.00),('1','186','940','257634',4904329,'2761','419',2038879.91,2057304.41,0.00,0.00,18424.50,10686190.00,0.00,0.00,0.00),('1','186','940','257635',4904330,'2761','419',2057304.41,2060791.01,0.00,0.00,3486.60,2022368.00,0.00,0.00,0.00),('1','186','940','257636',4904331,'2761','419',2060791.01,2061291.01,0.00,0.00,500.00,289000.00,0.00,0.00,0.00),('1','186','940','257637',4904332,'2761','419',2061291.01,2061291.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257638',4904333,'2761','419',2061291.01,2062680.30,0.00,0.00,1389.29,803009.62,0.00,0.00,0.00),('1','186','940','257639',4904334,'2761','419',2062680.30,2080731.80,0.00,0.00,18051.50,10472110.00,0.00,0.00,0.00),('1','186','940','257640',4904335,'2761','419',2080731.80,2085713.01,0.00,0.00,4981.21,2892629.38,0.00,0.00,0.00),('1','186','940','257641',4904336,'2761','419',2085713.01,2085713.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257642',4904337,'2761','419',2085713.01,2086068.75,0.00,0.00,355.74,205617.72,0.00,0.00,0.00),('1','186','940','257643',4904338,'2761','419',2086068.75,2104113.75,0.00,0.00,18045.00,10469100.00,0.00,0.00,0.00),('1','186','940','257644',4904339,'2761','419',2104113.75,2110349.65,0.00,0.00,6235.90,3618032.20,0.00,0.00,0.00),('1','186','940','257645',4904340,'2761','419',2110349.65,2110349.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257646',4904341,'2761','419',2110349.65,2113207.15,0.00,0.00,2857.50,1665650.00,0.00,0.00,0.00),('1','186','940','257647',4904342,'2761','419',2113207.15,2130123.15,0.00,0.00,16916.00,9811820.00,0.00,0.00,0.00),('1','186','940','257648',4904343,'2761','419',2130123.15,2135030.65,0.00,0.00,4907.50,2847750.00,0.00,0.00,0.00),('1','186','940','257649',4904344,'2761','419',2135030.65,2135030.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257650',4904345,'2761','419',2135030.65,2135837.72,0.00,0.00,807.07,473498.60,0.00,0.00,0.00),('1','186','940','257651',4904346,'2761','419',2135837.72,2147262.42,0.00,0.00,11424.70,6640404.00,0.00,0.00,0.00),('1','186','940','257652',4904347,'2761','419',2147262.42,2158221.02,0.00,0.00,10958.60,6373232.00,0.00,0.00,0.00),('1','186','940','257653',4904348,'2761','419',2158221.02,2159522.65,0.00,0.00,1301.63,758145.40,0.00,0.00,0.00),('1','186','940','257654',4904349,'2761','419',2159522.65,2159522.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257655',4904350,'2761','419',2159522.65,2161930.15,0.00,0.00,2407.50,1407050.00,0.00,0.00,0.00),('1','186','940','257656',4904351,'2761','419',2161930.15,2181248.65,0.00,0.00,19318.50,11206170.00,0.00,0.00,0.00),('1','186','940','257657',4904352,'2761','419',2181248.65,2184216.65,0.00,0.00,2968.00,1742025.00,0.00,0.00,0.00),('1','186','940','257658',4904353,'2761','419',2184216.65,2184216.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257659',4904354,'2761','419',2184216.65,2199795.95,0.00,0.00,15579.30,9042120.00,0.00,0.00,0.00),('1','186','940','257660',4904355,'2761','419',2199795.95,2203043.65,0.00,0.00,3247.70,1891674.00,0.00,0.00,0.00),('1','186','940','257661',4904356,'2761','419',2203043.65,2203043.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257662',4904357,'2761','419',2203043.65,2216927.25,0.00,0.00,13883.60,8064932.00,0.00,0.00,0.00),('1','186','940','257663',4904358,'2761','419',2216927.25,2227755.55,0.00,0.00,10828.30,6296747.40,0.00,0.00,0.00),('1','186','940','257664',4904359,'2761','419',2227755.55,2227755.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257665',4904360,'2761','419',2227755.55,2230161.15,0.00,0.00,2405.60,1402972.00,0.00,0.00,0.00),('1','186','940','257666',4904361,'2761','419',2230161.15,2250727.65,0.00,0.00,20566.50,11925030.00,0.00,0.00,0.00),('1','186','940','257667',4904362,'2761','419',2250727.65,2252379.55,0.00,0.00,1651.90,958382.00,0.00,0.00,0.00),('1','186','940','257668',4904363,'2761','419',2252379.55,2252379.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257669',4904364,'2761','419',2252379.55,2254814.05,0.00,0.00,2434.50,1422490.00,0.00,0.00,0.00),('1','186','940','257670',4904365,'2761','419',2254814.05,2272823.85,0.00,0.00,18009.80,10447636.00,0.00,0.00,0.00),('1','186','940','257671',4904366,'2761','419',2272823.85,2276990.55,0.00,0.00,4166.70,2417434.00,0.00,0.00,0.00),('1','186','940','257672',4904367,'2761','419',2276990.55,2276990.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257673',4904368,'2761','419',2276990.55,2295827.55,0.00,0.00,18837.00,10927940.00,0.00,0.00,0.00),('1','186','940','257674',4904369,'2761','419',2295827.55,2301766.45,0.00,0.00,5938.90,3497007.20,0.00,0.00,0.00),('1','186','940','257675',4904370,'2761','419',2301766.45,2301766.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257676',4904371,'2761','419',2301766.45,2301766.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257677',4904372,'2761','419',2301766.45,2304947.80,0.00,0.00,3181.35,1895037.00,0.00,0.00,0.00),('1','186','940','257678',4904373,'2761','419',2304947.80,2315860.09,0.00,0.00,10912.29,6423263.40,0.00,0.00,0.00),('1','186','940','257679',4904374,'2761','419',2315860.09,2324283.53,0.00,0.00,8423.44,4990492.80,0.00,0.00,0.00),('1','186','940','257680',4904375,'2761','419',2324283.53,2326432.01,0.00,0.00,2148.48,1260257.60,0.00,0.00,0.00),('1','186','940','257681',4904376,'2761','419',2326432.01,2326432.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257682',4904377,'2761','419',2326432.01,2330480.72,0.00,0.00,4048.71,2636474.80,0.00,0.00,0.00),('1','186','940','257683',4904378,'2761','419',2330480.72,2335069.33,0.00,0.00,4588.61,3002549.80,0.00,0.00,0.00),('1','186','940','257684',4904379,'2761','419',2335069.33,2338484.03,0.00,0.00,3414.70,2233534.64,0.00,0.00,0.00),('1','186','940','257685',4904380,'2761','419',2338484.03,2345283.20,0.00,0.00,6799.17,4380158.10,0.00,0.00,0.00),('1','186','940','257686',4904381,'2761','419',2345283.20,2350924.83,0.00,0.00,5641.63,3565905.40,0.00,0.00,0.00),('1','186','940','257687',4904382,'2761','419',2350924.83,2350924.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257688',4904383,'2761','419',2350924.83,2364242.22,0.00,0.00,13317.39,8260464.10,0.00,0.00,0.00),('1','186','940','257689',4904384,'2761','419',2364242.22,2375691.07,0.00,0.00,11448.85,7064397.90,0.00,0.00,0.00),('1','186','940','257690',4904385,'2761','419',2375691.07,2375691.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257691',4904386,'2761','419',2375691.07,2384812.59,0.00,0.00,9121.52,6060506.33,0.00,0.00,0.00),('1','186','940','257692',4904387,'2761','419',2384812.59,2391638.08,0.00,0.00,6825.49,4569840.39,0.00,0.00,0.00),('1','186','940','257693',4904388,'2761','419',2391638.08,2400247.41,0.00,0.00,8609.33,5707861.05,0.00,0.00,0.00),('1','186','940','257694',4904389,'2761','419',2400247.41,2400247.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257695',4904390,'2761','419',2400247.41,2407274.37,0.00,0.00,7026.96,4495500.80,0.00,0.00,0.00),('1','186','940','257696',4904391,'2761','419',2407274.37,2420179.69,0.00,0.00,12905.32,8267487.56,0.00,0.00,0.00),('1','186','940','257697',4904392,'2761','419',2420179.69,2424736.75,0.00,0.00,4557.06,2913222.00,0.00,0.00,0.00),('1','186','940','257698',4904393,'2761','419',2424736.75,2424736.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257699',4904394,'2761','419',2424736.75,2440328.95,0.00,0.00,15592.20,10253749.60,0.00,0.00,0.00),('1','186','940','257700',4904395,'2761','419',2440328.95,2449064.57,0.00,0.00,8735.62,5770938.80,0.00,0.00,0.00),('1','186','940','257701',4904396,'2761','419',2449064.57,2449064.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257702',4904397,'2761','419',2449064.57,2457292.70,0.00,0.00,8228.13,5642656.20,0.00,0.00,0.00),('1','186','940','257703',4904398,'2761','419',2457292.70,2465068.96,0.00,0.00,7776.26,5415345.60,0.00,0.00,0.00),('1','186','940','257704',4904399,'2761','419',2465068.96,2468789.27,0.00,0.00,3720.31,2565787.80,0.00,0.00,0.00),('1','186','940','257705',4904400,'2761','419',2468789.27,2468789.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257706',4904401,'2761','419',2468789.27,2476406.83,0.00,0.00,7617.56,5221418.85,0.00,0.00,0.00),('1','186','940','257707',4904402,'2761','419',2476406.83,2487343.50,0.00,0.00,10936.67,7514825.60,0.00,0.00,0.00),('1','186','940','257708',4904403,'2761','419',2487343.50,2493414.66,0.00,0.00,6071.16,4146066.70,0.00,0.00,0.00),('1','186','940','257709',4904404,'2761','419',2493414.66,2493414.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257710',4904405,'2761','419',2493414.66,2495972.03,0.00,0.00,2557.37,1772028.30,0.00,0.00,0.00),('1','186','940','257711',4904406,'2761','419',2495972.03,2497730.20,0.00,0.00,1758.17,1277052.60,0.00,0.00,0.00),('1','186','940','257712',4904407,'2761','419',2497730.20,2508873.69,0.00,0.00,11143.49,7892369.20,0.00,0.00,0.00),('1','186','940','257713',4904408,'2761','419',2508873.69,2518118.34,0.00,0.00,9244.65,6548321.70,0.00,0.00,0.00),('1','186','940','257714',4904409,'2761','419',2518118.34,2518118.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257715',4904410,'2761','419',2518118.34,2523312.57,0.00,0.00,5194.23,3650512.50,0.00,0.00,0.00),('1','186','940','257716',4904411,'2761','419',2523312.57,2534749.65,0.00,0.00,11437.08,8009306.40,0.00,0.00,0.00),('1','186','940','257717',4904412,'2761','419',2534749.65,2541682.48,0.00,0.00,6932.83,4906523.10,0.00,0.00,0.00),('1','186','940','257718',4904413,'2761','419',2541682.48,2541682.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257719',4904414,'2761','419',2541682.48,2547965.73,0.00,0.00,6283.25,4375863.14,0.00,0.00,0.00),('1','186','940','257720',4904415,'2761','419',2547965.73,2557160.83,0.00,0.00,9195.10,6396926.72,0.00,0.00,0.00),('1','186','940','257721',4904416,'2761','419',2557160.83,2563876.38,0.00,0.00,6715.55,4675499.10,0.00,0.00,0.00),('1','186','940','257722',4904417,'2761','419',2563876.38,2566155.35,0.00,0.00,2278.97,1549607.74,0.00,0.00,0.00),('1','186','940','257723',4904418,'2761','419',2566155.35,2566155.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257724',4904419,'2761','419',2566155.35,2569954.62,0.00,0.00,3799.27,2636115.18,0.00,0.00,0.00),('1','186','940','257725',4904420,'2761','419',2569954.62,2579466.98,0.00,0.00,9512.36,6544310.88,0.00,0.00,0.00),('1','186','940','257726',4904421,'2761','419',2579466.98,2590728.16,0.00,0.00,11261.18,7722266.12,0.00,0.00,0.00),('1','186','940','257727',4904422,'2761','419',2590728.16,2590728.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257728',4904423,'2761','419',2590728.16,2596018.58,0.00,0.00,5290.42,3672061.00,0.00,0.00,0.00),('1','186','940','257729',4904424,'2761','419',2596018.58,2604375.08,0.00,0.00,8356.50,5791197.00,0.00,0.00,0.00),('1','186','940','257730',4904425,'2761','419',2604375.08,2611351.18,0.00,0.00,6976.10,4877354.88,0.00,0.00,0.00),('1','186','940','257731',4904426,'2761','419',2611351.18,2615484.57,0.00,0.00,4133.39,2868401.34,0.00,0.00,0.00),('1','186','940','257732',4904427,'2761','419',2615484.57,2615521.28,0.00,0.00,36.71,25187.14,0.00,0.00,0.00),('1','186','940','257733',4904428,'2761','419',2615521.28,2615541.26,0.00,0.00,19.98,14985.00,0.00,0.00,0.00),('1','186','940','257734',4904429,'2761','419',2615541.26,2615541.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257735',4904430,'2761','419',2615541.26,2619371.44,0.00,0.00,3830.18,2629815.00,0.00,0.00,0.00),('1','186','940','257736',4904431,'2761','419',2619371.44,2629554.80,0.00,0.00,10183.36,7030571.64,0.00,0.00,0.00),('1','186','940','257737',4904432,'2761','419',2629554.80,2637436.10,0.00,0.00,7881.30,5476566.24,0.00,0.00,0.00),('1','186','940','257738',4904433,'2761','419',2637436.10,2640166.17,0.00,0.00,2730.07,1885132.90,0.00,0.00,0.00),('1','186','940','257739',4904434,'2761','419',2640166.17,2640166.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257740',4904435,'2761','419',2640166.17,2645448.05,0.00,0.00,5281.88,3619818.04,0.00,0.00,0.00),('1','186','940','257741',4904436,'2761','419',2645448.05,2656399.16,0.00,0.00,10951.11,7493060.28,0.00,0.00,0.00),('1','186','940','257742',4904437,'2761','419',2656399.16,2664672.59,0.00,0.00,8273.43,5666477.04,0.00,0.00,0.00),('1','186','940','257743',4904438,'2761','419',2664672.59,2664672.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257744',4904439,'2761','419',2664672.59,2676158.83,0.00,0.00,11486.24,7819068.62,0.00,0.00,0.00),('1','186','940','257745',4904440,'2761','419',2676158.83,2683943.49,0.00,0.00,7784.66,5353853.98,0.00,0.00,0.00),('1','186','940','257746',4904441,'2761','419',2683943.49,2689380.95,0.00,0.00,5437.46,3684462.00,0.00,0.00,0.00),('1','186','940','257747',4904442,'2761','419',2689380.95,2689380.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257748',4904443,'2761','419',2689380.95,2693248.02,0.00,0.00,3867.07,2665754.52,0.00,0.00,0.00),('1','186','940','257749',4904444,'2761','419',2693248.02,2706423.75,0.00,0.00,13175.73,8936973.38,0.00,0.00,0.00),('1','186','940','257750',4904445,'2761','419',2706423.75,2713154.16,0.00,0.00,6730.41,4625355.00,0.00,0.00,0.00),('1','186','940','257751',4904446,'2761','419',2713154.16,2714085.44,0.00,0.00,931.28,664477.62,0.00,0.00,0.00),('1','186','940','257752',4904447,'2761','419',2714085.44,2714085.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257753',4904448,'2761','419',2714085.44,2725548.22,0.00,0.00,11462.78,7789330.34,0.00,0.00,0.00),('1','186','940','257754',4904449,'2761','419',2725548.22,2735086.86,0.00,0.00,9538.64,6458563.78,0.00,0.00,0.00),('1','186','940','257755',4904450,'2761','419',2735086.86,2738661.90,0.00,0.00,3575.04,2433455.54,0.00,0.00,0.00),('1','186','940','257756',4904451,'2761','419',2738661.90,2738661.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257757',4904452,'2761','419',2738661.90,2746105.04,0.00,0.00,7443.14,5085085.06,0.00,0.00,0.00),('1','186','940','257758',4904453,'2761','419',2746105.04,2759419.33,0.00,0.00,13314.29,9041895.70,0.00,0.00,0.00),('1','186','940','257759',4904454,'2761','419',2759419.33,2763193.59,0.00,0.00,3774.26,2560342.56,0.00,0.00,0.00),('1','186','940','257760',4904455,'2761','419',2763193.59,2763193.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257761',4904456,'2761','419',2763193.59,2769724.43,0.00,0.00,6530.84,4442623.28,0.00,0.00,0.00),('1','186','940','257762',4904457,'2761','419',2769724.43,2776630.37,0.00,0.00,6905.94,4745758.64,0.00,0.00,0.00),('1','186','940','257763',4904458,'2761','419',2776630.37,2782484.31,0.00,0.00,5853.94,4031266.20,0.00,0.00,0.00),('1','186','940','257764',4904459,'2761','419',2782484.31,2787806.27,0.00,0.00,5321.96,3624010.80,0.00,0.00,0.00),('1','186','940','257765',4904460,'2761','419',2787806.27,2787806.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257766',4904461,'2761','419',2787806.27,2794700.23,0.00,0.00,6893.96,4711743.70,0.00,0.00,0.00),('1','186','940','257767',4904462,'2761','419',2794700.23,2802212.56,0.00,0.00,7512.33,5106124.90,0.00,0.00,0.00),('1','186','940','257768',4904463,'2761','419',2802212.56,2809026.47,0.00,0.00,6813.91,4665174.30,0.00,0.00,0.00),('1','186','940','257769',4904464,'2761','419',2809026.47,2812366.50,0.00,0.00,3340.03,2263875.90,0.00,0.00,0.00),('1','186','940','257770',4904465,'2761','419',2812366.50,2812366.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257771',4904466,'2761','419',2812366.50,2823024.39,0.00,0.00,10657.89,7197140.60,0.00,0.00,0.00),('1','186','940','257772',4904467,'2761','419',2823024.39,2830878.80,0.00,0.00,7854.41,5340848.50,0.00,0.00,0.00),('1','186','940','257773',4904468,'2761','419',2830878.80,2837067.99,0.00,0.00,6189.19,4244268.70,0.00,0.00,0.00),('1','186','940','257774',4904469,'2761','419',2837067.99,2837067.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257775',4904470,'2761','419',2837067.99,2841027.60,0.00,0.00,3959.61,2739722.70,0.00,0.00,0.00),('1','186','940','257776',4904471,'2761','419',2841027.60,2847367.85,0.00,0.00,6340.25,4354665.70,0.00,0.00,0.00),('1','186','940','257777',4904472,'2761','419',2847367.85,2855174.84,0.00,0.00,7806.99,5312552.40,0.00,0.00,0.00),('1','186','940','257778',4904473,'2761','419',2855174.84,2862000.90,0.00,0.00,6826.06,4570367.80,0.00,0.00,0.00),('1','186','940','257779',4904474,'2761','419',2862000.90,2862000.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257780',4904475,'2761','419',2862000.90,2865744.26,0.00,0.00,3743.36,2538264.90,0.00,0.00,0.00),('1','186','940','257781',4904476,'2761','419',2865744.26,2879396.06,0.00,0.00,13651.80,9193451.90,0.00,0.00,0.00),('1','186','940','257782',4904477,'2761','419',2879396.06,2886704.80,0.00,0.00,7308.74,4939794.10,0.00,0.00,0.00),('1','186','940','257783',4904478,'2761','419',2886704.80,2886704.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257784',4904479,'2761','419',2886704.80,2897953.53,0.00,0.00,11248.73,7528005.84,0.00,0.00,0.00),('1','186','940','257785',4904480,'2761','419',2897953.53,2911188.72,0.00,0.00,13235.19,8820485.84,0.00,0.00,0.00),('1','186','940','257786',4904481,'2761','419',2911188.72,2911287.37,0.00,0.00,98.65,65109.00,0.00,0.00,0.00),('1','186','940','257787',4904482,'2761','419',2911287.37,2911287.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257788',4904483,'2761','419',2911287.37,2923567.60,0.00,0.00,12280.23,8184973.08,0.00,0.00,0.00),('1','186','940','257789',4904484,'2761','419',2923567.60,2936580.50,0.00,0.00,13012.90,8759912.08,0.00,0.00,0.00),('1','186','940','257790',4904485,'2761','419',2936580.50,2936580.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257791',4904486,'2761','419',2936580.50,2938676.73,0.00,0.00,2096.23,1396089.18,0.00,0.00,0.00),('1','186','940','257792',4904487,'2761','419',2938676.73,2952471.76,0.00,0.00,13795.03,9409920.94,0.00,0.00,0.00),('1','186','940','257793',4904488,'2761','419',2952471.76,2961200.75,0.00,0.00,8728.99,5974749.18,0.00,0.00,0.00),('1','186','940','257794',4904489,'2761','419',2961200.75,2961200.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257795',4904490,'2761','419',2961200.75,2968883.01,0.00,0.00,7682.26,5311468.92,0.00,0.00,0.00),('1','186','940','257796',4904491,'2761','419',2968883.01,2977726.10,0.00,0.00,8843.09,6068225.78,0.00,0.00,0.00),('1','186','940','257797',4904492,'2761','419',2977726.10,2984962.59,0.00,0.00,7236.49,5037340.90,0.00,0.00,0.00),('1','186','940','257798',4904493,'2761','419',2984962.59,2985981.37,0.00,0.00,1018.78,693583.58,0.00,0.00,0.00),('1','186','940','257799',4904494,'2761','419',2985981.37,2985981.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257800',4904495,'2761','419',2985981.37,2995870.75,0.00,0.00,9889.38,6792136.34,0.00,0.00,0.00),('1','186','940','257801',4904496,'2761','419',2995870.75,3003106.26,0.00,0.00,7235.51,5003662.22,0.00,0.00,0.00),('1','186','940','257802',4904497,'2761','419',3003106.26,3010556.46,0.00,0.00,7450.20,5163238.00,0.00,0.00,0.00),('1','186','940','257803',4904498,'2761','419',3010556.46,3010556.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257804',4904499,'2761','419',3010556.46,3010562.61,0.00,0.00,6.15,4489.50,0.00,0.00,0.00),('1','186','940','257805',4904500,'2761','419',3010562.61,3016021.14,0.00,0.00,5458.53,3753614.90,0.00,0.00,0.00),('1','186','940','257806',4904501,'2761','419',3016021.14,3029607.22,0.00,0.00,13586.08,9289377.60,0.00,0.00,0.00),('1','186','940','257807',4904502,'2761','419',3029607.22,3035372.93,0.00,0.00,5765.71,3975631.42,0.00,0.00,0.00),('1','186','940','257808',4904503,'2761','419',3035372.93,3035372.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257809',4904504,'2761','419',3035372.93,3042597.70,0.00,0.00,7224.77,5027456.42,0.00,0.00,0.00),('1','186','940','257810',4904505,'2761','419',3042597.70,3049675.60,0.00,0.00,7077.90,4923647.24,0.00,0.00,0.00),('1','186','940','257811',4904506,'2761','419',3049675.60,3054393.58,0.00,0.00,4717.98,3305055.56,0.00,0.00,0.00),('1','186','940','257812',4904507,'2761','419',3054393.58,3060132.88,0.00,0.00,5739.30,3998561.00,0.00,0.00,0.00),('1','186','940','257813',4904508,'2761','419',3060132.88,3060132.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257814',4904509,'2761','419',3060132.88,3070900.07,0.00,0.00,10767.19,7263666.20,0.00,0.00,0.00),('1','186','940','257815',4904510,'2761','419',3070900.07,3079547.20,0.00,0.00,8647.13,5850419.90,0.00,0.00,0.00),('1','186','940','257816',4904511,'2761','419',3079547.20,3084603.61,0.00,0.00,5056.41,3440362.30,0.00,0.00,0.00),('1','186','940','257817',4904512,'2761','419',3084603.61,3084603.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257818',4904513,'2761','419',3084603.61,3086427.54,0.00,0.00,1823.93,1238508.90,0.00,0.00,0.00),('1','186','940','257819',4904514,'2761','419',3086427.54,3094142.75,0.00,0.00,7715.21,5260123.30,0.00,0.00,0.00),('1','186','940','257820',4904515,'2761','419',3094142.75,3103789.93,0.00,0.00,9647.18,6547740.20,0.00,0.00,0.00),('1','186','940','257821',4904516,'2761','419',3103789.93,3109184.60,0.00,0.00,5394.67,3696126.80,0.00,0.00,0.00),('1','186','940','257822',4904517,'2761','419',3109184.60,3109184.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257823',4904518,'2761','419',3109184.60,3117277.01,0.00,0.00,8092.41,5495253.10,0.00,0.00,0.00),('1','186','940','257824',4904519,'2761','419',3117277.01,3123769.63,0.00,0.00,6492.62,4443378.20,0.00,0.00,0.00),('1','186','940','257825',4904520,'2761','419',3123769.63,3133698.87,0.00,0.00,9929.24,6721935.20,0.00,0.00,0.00),('1','186','940','257826',4904521,'2761','419',3133698.87,3133801.93,0.00,0.00,103.06,69179.70,0.00,0.00,0.00),('1','186','940','257827',4904522,'2761','419',3133801.93,3133801.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257828',4904523,'2761','419',3133801.93,3143253.31,0.00,0.00,9451.38,6329984.80,0.00,0.00,0.00),('1','186','940','257829',4904524,'2761','419',3143253.31,3153447.11,0.00,0.00,10193.80,6864266.32,0.00,0.00,0.00),('1','186','940','257830',4904525,'2761','419',3153447.11,3158397.76,0.00,0.00,4950.65,3347844.48,0.00,0.00,0.00),('1','186','940','257831',4904526,'2761','419',3158397.76,3158397.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257832',4904527,'2761','419',3158397.76,3168021.31,0.00,0.00,9623.55,6487024.00,0.00,0.00,0.00),('1','186','940','257833',4904528,'2761','419',3168021.31,3178642.45,0.00,0.00,10621.14,7091291.48,0.00,0.00,0.00),('1','186','940','257834',4904529,'2761','419',3178642.45,3183244.20,0.00,0.00,4601.75,3065990.00,0.00,0.00,0.00),('1','186','940','257835',4904530,'2761','419',3183244.20,3183244.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257836',4904531,'2761','419',3183244.20,3190406.87,0.00,0.00,7162.67,4795460.92,0.00,0.00,0.00),('1','186','940','257837',4904532,'2761','419',3190406.87,3200635.99,0.00,0.00,10229.12,6829707.08,0.00,0.00,0.00),('1','186','940','257838',4904533,'2761','419',3200635.99,3206884.16,0.00,0.00,6248.17,4224982.40,0.00,0.00,0.00),('1','186','940','257839',4904534,'2761','419',3206884.16,3208143.13,0.00,0.00,1258.97,868810.88,0.00,0.00,0.00),('1','186','940','257840',4904535,'2761','419',3208143.13,3208143.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257841',4904536,'2761','419',3208143.13,3213140.25,0.00,0.00,4997.12,3367836.84,0.00,0.00,0.00),('1','186','940','257842',4904537,'2761','419',3213140.25,3221411.81,0.00,0.00,8271.56,5577167.80,0.00,0.00,0.00),('1','186','940','257843',4904538,'2761','419',3221411.81,3229517.77,0.00,0.00,8105.96,5468683.20,0.00,0.00,0.00),('1','186','940','257844',4904539,'2761','419',3229517.77,3232829.18,0.00,0.00,3311.41,2223395.20,0.00,0.00,0.00),('1','186','940','257845',4904540,'2761','419',3232829.18,3232829.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257846',4904541,'2761','419',3232829.18,3241870.45,0.00,0.00,9041.27,5966758.40,0.00,0.00,0.00),('1','186','940','257847',4904542,'2761','419',3241870.45,3248756.18,0.00,0.00,6885.73,4625171.60,0.00,0.00,0.00),('1','186','940','257848',4904543,'2761','419',3248756.18,3256190.54,0.00,0.00,7434.36,5005337.92,0.00,0.00,0.00),('1','186','940','257849',4904544,'2761','419',3256190.54,3257621.70,0.00,0.00,1431.16,968419.20,0.00,0.00,0.00),('1','186','940','257850',4904545,'2761','419',3257621.70,3257621.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257851',4904546,'2761','419',3257621.70,3268059.72,0.00,0.00,10438.02,6952687.60,0.00,0.00,0.00),('1','186','940','257852',4904547,'2761','419',3268059.72,3280971.04,0.00,0.00,12911.32,8567533.04,0.00,0.00,0.00),('1','186','940','257853',4904548,'2761','419',3280971.04,3282549.47,0.00,0.00,1578.43,1102197.60,0.00,0.00,0.00),('1','186','940','257854',4904549,'2761','419',3282549.47,3282549.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257855',4904550,'2761','419',3282549.47,3287985.64,0.00,0.00,5436.17,3634187.40,0.00,0.00,0.00),('1','186','940','257856',4904551,'2761','419',3287985.64,3297878.29,0.00,0.00,9892.65,6615616.12,0.00,0.00,0.00),('1','186','940','257857',4904552,'2761','419',3297878.29,3303870.25,0.00,0.00,5991.96,4061380.40,0.00,0.00,0.00),('1','186','940','257858',4904553,'2761','419',3303870.25,3307171.96,0.00,0.00,3301.71,2221443.20,0.00,0.00,0.00),('1','186','940','257859',4904554,'2761','419',3307171.96,3307171.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257860',4904555,'2761','419',3307171.96,3310044.49,0.00,0.00,2872.53,1929702.48,0.00,0.00,0.00),('1','186','940','257861',4904556,'2761','419',3310044.49,3319228.90,0.00,0.00,9184.41,6078626.84,0.00,0.00,0.00),('1','186','940','257862',4904557,'2761','419',3319228.90,3324752.12,0.00,0.00,5523.22,3703493.48,0.00,0.00,0.00),('1','186','940','257863',4904558,'2761','419',3324752.12,3331744.86,0.00,0.00,6992.74,4598859.68,0.00,0.00,0.00),('1','186','940','257864',4904559,'2761','419',3331744.86,3331744.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257865',4904560,'2761','419',3331744.86,3333148.54,0.00,0.00,1403.68,949972.00,0.00,0.00,0.00),('1','186','940','257866',4904561,'2761','419',3333148.54,3341854.67,0.00,0.00,8706.13,5766047.00,0.00,0.00,0.00),('1','186','940','257867',4904562,'2761','419',3341854.67,3348552.10,0.00,0.00,6697.43,4471423.92,0.00,0.00,0.00),('1','186','940','257868',4904563,'2761','419',3348552.10,3355375.24,0.00,0.00,6823.14,4539292.00,0.00,0.00,0.00),('1','186','940','257869',4904564,'2761','419',3355375.24,3355546.80,0.00,0.00,171.56,112292.00,0.00,0.00,0.00),('1','186','940','257870',4904565,'2761','419',3355546.80,3355546.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257871',4904566,'2761','419',3355546.80,3363861.86,0.00,0.00,8315.06,5526272.28,0.00,0.00,0.00),('1','186','940','257872',4904567,'2761','419',3363861.86,3372604.66,0.00,0.00,8742.80,5822078.00,0.00,0.00,0.00),('1','186','940','257873',4904568,'2761','419',3372604.66,3379704.59,0.00,0.00,7099.93,4750667.00,0.00,0.00,0.00),('1','186','940','257874',4904569,'2761','419',3379704.59,3380227.93,0.00,0.00,523.34,366338.00,0.00,0.00,0.00),('1','186','940','257875',4904570,'2761','419',3380227.93,3380227.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257876',4904571,'2761','419',3380227.93,3389465.18,0.00,0.00,9237.25,6054664.80,0.00,0.00,0.00),('1','186','940','257877',4904572,'2761','419',3389465.18,3400154.72,0.00,0.00,10689.54,6973930.20,0.00,0.00,0.00),('1','186','940','257878',4904573,'2761','419',3400154.72,3404363.58,0.00,0.00,4208.86,2817419.80,0.00,0.00,0.00),('1','186','940','257879',4904574,'2761','419',3404363.58,3404504.92,0.00,0.00,141.34,92938.00,0.00,0.00,0.00),('1','186','940','257880',4904575,'2761','419',3404504.92,3404504.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257881',4904576,'2761','419',3404504.92,3410528.72,0.00,0.00,6023.80,3933070.00,0.00,0.00,0.00),('1','186','940','257882',4904577,'2761','419',3410528.72,3420933.04,0.00,0.00,10404.32,6830317.80,0.00,0.00,0.00),('1','186','940','257883',4904578,'2761','419',3420933.04,3428111.88,0.00,0.00,7178.84,4763943.20,0.00,0.00,0.00),('1','186','940','257884',4904579,'2761','419',3428111.88,3428709.61,0.00,0.00,597.73,392182.60,0.00,0.00,0.00),('1','186','940','257885',4904580,'2761','419',3428709.61,3428709.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257886',4904581,'2761','419',3428709.61,3439181.32,0.00,0.00,10471.71,6813828.00,0.00,0.00,0.00),('1','186','940','257887',4904582,'2761','419',3439181.32,3453164.62,0.00,0.00,13983.30,9055736.00,0.00,0.00,0.00),('1','186','940','257888',4904583,'2761','419',3453164.62,3453250.88,0.00,0.00,86.26,55206.40,0.00,0.00,0.00),('1','186','940','257889',4904584,'2761','419',3453250.88,3453250.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257890',4904585,'2761','419',3453250.88,3464151.40,0.00,0.00,10900.52,7084533.80,0.00,0.00,0.00),('1','186','940','257891',4904586,'2761','419',3464151.40,3475442.69,0.00,0.00,11291.29,7395232.60,0.00,0.00,0.00),('1','186','940','257892',4904587,'2761','419',3475442.69,3478190.16,0.00,0.00,2747.47,1923229.00,0.00,0.00,0.00),('1','186','940','257893',4904588,'2761','419',3478190.16,3478190.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257894',4904589,'2761','419',3478190.16,3491651.26,0.00,0.00,13461.10,8722613.20,0.00,0.00,0.00),('1','186','940','257895',4904590,'2761','419',3491651.26,3497466.22,0.00,0.00,5814.96,3858907.36,0.00,0.00,0.00),('1','186','940','257896',4904591,'2761','419',3497466.22,3497466.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257897',4904592,'2761','419',3497466.22,3511350.97,0.00,0.00,13884.75,9204589.90,0.00,0.00,0.00),('1','186','940','257898',4904593,'2761','419',3511350.97,3520262.36,0.00,0.00,8911.39,6027651.80,0.00,0.00,0.00),('1','186','940','257899',4904594,'2761','419',3520262.36,3521838.35,0.00,0.00,1575.99,1071677.10,0.00,0.00,0.00),('1','186','940','257900',4904595,'2761','419',3521838.35,3521838.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257901',4904596,'2761','419',3521838.35,3526197.79,0.00,0.00,4359.44,2990278.50,0.00,0.00,0.00),('1','186','940','257902',4904597,'2761','419',3526197.79,3537087.50,0.00,0.00,10889.71,7295799.40,0.00,0.00,0.00),('1','186','940','257903',4904598,'2761','419',3537087.50,3544477.96,0.00,0.00,7390.46,5014466.10,0.00,0.00,0.00),('1','186','940','257904',4904599,'2761','419',3544477.96,3546296.36,0.00,0.00,1818.40,1255275.36,0.00,0.00,0.00),('1','186','940','257905',4904600,'2761','419',3546296.36,3546296.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257906',4904601,'2761','419',3546296.36,3550939.89,0.00,0.00,4643.53,3157385.00,0.00,0.00,0.00),('1','186','940','257907',4904602,'2761','419',3550939.89,3563585.10,0.00,0.00,12645.21,8530458.40,0.00,0.00,0.00),('1','186','940','257908',4904603,'2761','419',3563585.10,3570374.16,0.00,0.00,6789.06,4661509.80,0.00,0.00,0.00),('1','186','940','257909',4904604,'2761','419',3570374.16,3570728.80,0.00,0.00,354.64,238935.10,0.00,0.00,0.00),('1','186','940','257910',4904605,'2761','419',3570728.80,3570728.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257911',4904606,'2761','419',3570728.80,3577434.66,0.00,0.00,6705.86,4586780.10,0.00,0.00,0.00),('1','186','940','257912',4904607,'2761','419',3577434.66,3584480.92,0.00,0.00,7046.26,4841511.20,0.00,0.00,0.00),('1','186','940','257913',4904608,'2761','419',3584480.92,3594122.95,0.00,0.00,9642.03,6548884.90,0.00,0.00,0.00),('1','186','940','257914',4904609,'2761','419',3594122.95,3594915.93,0.00,0.00,792.98,547447.50,0.00,0.00,0.00),('1','186','940','257915',4904610,'2761','419',3594915.93,3594915.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257916',4904611,'2761','419',3594915.93,3602399.10,0.00,0.00,7483.17,5050338.10,0.00,0.00,0.00),('1','186','940','257917',4904612,'2761','419',3602399.10,3613411.20,0.00,0.00,11012.10,7463637.00,0.00,0.00,0.00),('1','186','940','257918',4904613,'2761','419',3613411.20,3613994.72,0.00,0.00,583.52,425969.60,0.00,0.00,0.00),('1','186','940','257919',4904614,'2761','419',3613994.72,3614037.74,0.00,0.00,43.02,30591.20,0.00,0.00,0.00),('1','186','940','257920',4904615,'2761','419',3614037.74,3614037.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257921',4904616,'2761','419',3614037.74,3621572.49,0.00,0.00,7534.75,5106115.40,0.00,0.00,0.00),('1','186','940','257922',4904617,'2761','419',3621572.49,3629353.01,0.00,0.00,7780.52,5314586.10,0.00,0.00,0.00),('1','186','940','257923',4904618,'2761','419',3629353.01,3637971.42,0.00,0.00,8618.41,5882147.40,0.00,0.00,0.00),('1','186','940','257924',4904619,'2761','419',3637971.42,3638592.59,0.00,0.00,621.17,453454.10,0.00,0.00,0.00),('1','186','940','257925',4904620,'2761','419',3638592.59,3638592.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257926',4904621,'2761','419',3638592.59,3644596.91,0.00,0.00,6004.32,4055433.60,0.00,0.00,0.00),('1','186','940','257927',4904622,'2761','419',3644596.91,3652721.79,0.00,0.00,8124.88,5510602.40,0.00,0.00,0.00),('1','186','940','257928',4904623,'2761','419',3652721.79,3660485.84,0.00,0.00,7764.05,5282036.50,0.00,0.00,0.00),('1','186','940','257929',4904624,'2761','419',3660485.84,3663141.57,0.00,0.00,2655.73,1797236.70,0.00,0.00,0.00),('1','186','940','257930',4904625,'2761','419',3663141.57,3663141.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257931',4904626,'2761','419',3663141.57,3666674.75,0.00,0.00,3533.18,2429771.40,0.00,0.00,0.00),('1','186','940','257932',4904627,'2761','419',3666674.75,3672491.11,0.00,0.00,5816.36,3995514.30,0.00,0.00,0.00),('1','186','940','257933',4904628,'2761','419',3672491.11,3681225.32,0.00,0.00,8734.21,5920137.00,0.00,0.00,0.00),('1','186','940','257934',4904629,'2761','419',3681225.32,3682245.81,0.00,0.00,1020.49,690921.20,0.00,0.00,0.00),('1','186','940','257935',4904630,'2761','419',3682245.81,3682245.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257936',4904631,'2761','419',3682245.81,3688394.12,0.00,0.00,6148.31,4167413.90,0.00,0.00,0.00),('1','186','940','257937',4904632,'2761','419',3688394.12,3697109.02,0.00,0.00,8714.90,5903704.40,0.00,0.00,0.00),('1','186','940','257938',4904633,'2761','419',3697109.02,3701573.81,0.00,0.00,4464.79,3048865.20,0.00,0.00,0.00),('1','186','940','257939',4904634,'2761','419',3701573.81,3701573.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257940',4904635,'2761','419',3701573.81,3707916.20,0.00,0.00,6342.39,4282616.80,0.00,0.00,0.00),('1','186','940','257941',4904636,'2761','419',3707916.20,3713190.63,0.00,0.00,5274.43,3614124.60,0.00,0.00,0.00),('1','186','940','257942',4904637,'2761','419',3713190.63,3719421.23,0.00,0.00,6230.60,4245240.60,0.00,0.00,0.00),('1','186','940','257943',4904638,'2761','419',3719421.23,3721363.17,0.00,0.00,1941.94,1393696.80,0.00,0.00,0.00),('1','186','940','257944',4904639,'2761','419',3721363.17,3721363.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257945',4904640,'2761','419',3721363.17,3736360.95,0.00,0.00,14997.78,10032053.40,0.00,0.00,0.00),('1','186','940','257946',4904641,'2761','419',3736360.95,3740563.13,0.00,0.00,4202.18,2840200.20,0.00,0.00,0.00),('1','186','940','257947',4904642,'2761','419',3740563.13,3740563.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257948',4904643,'2761','419',3740563.13,3743533.60,0.00,0.00,2970.47,2008543.20,0.00,0.00,0.00),('1','186','940','257949',4904644,'2761','419',3743533.60,3749692.73,0.00,0.00,6159.13,4204411.00,0.00,0.00,0.00),('1','186','940','257950',4904645,'2761','419',3749692.73,3754484.53,0.00,0.00,4791.80,3281137.20,0.00,0.00,0.00),('1','186','940','257951',4904646,'2761','419',3754484.53,3759184.50,0.00,0.00,4699.97,3228287.90,0.00,0.00,0.00),('1','186','940','257952',4904647,'2761','419',3759184.50,3765186.42,0.00,0.00,6001.92,4047072.88,0.00,0.00,0.00),('1','186','940','257953',4904648,'2761','419',3765186.42,3765186.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257954',4904649,'2761','419',3765186.42,3776309.89,0.00,0.00,11123.47,7328508.64,0.00,0.00,0.00),('1','186','940','257955',4904650,'2761','419',3776309.89,3783803.53,0.00,0.00,7493.64,4969946.50,0.00,0.00,0.00),('1','186','940','257956',4904651,'2761','419',3783803.53,3783803.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257957',4904652,'2761','419',3783803.53,3783803.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257958',4904653,'2761','419',3783803.53,3790834.29,0.00,0.00,7030.76,4689282.00,0.00,0.00,0.00),('1','186','940','257959',4904654,'2761','419',3790834.29,3799256.15,0.00,0.00,8421.86,5595832.00,0.00,0.00,0.00),('1','186','940','257960',4904655,'2761','419',3799256.15,3803301.83,0.00,0.00,4045.68,2689801.00,0.00,0.00,0.00),('1','186','940','257961',4904656,'2761','419',3803301.83,3803301.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257962',4904657,'2761','419',3803301.83,3806368.93,0.00,0.00,3067.10,2051392.50,0.00,0.00,0.00),('1','186','940','257963',4904658,'2761','419',3806368.93,3815128.87,0.00,0.00,8759.94,5823592.00,0.00,0.00,0.00),('1','186','940','257964',4904659,'2761','419',3815128.87,3824961.62,0.00,0.00,9832.75,6508940.00,0.00,0.00,0.00),('1','186','940','257965',4904660,'2761','419',3824961.62,3828229.69,0.00,0.00,3268.07,2131834.50,0.00,0.00,0.00),('1','186','940','257966',4904661,'2761','419',3828229.69,3828229.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257967',4904662,'2761','419',3828229.69,3834607.04,0.00,0.00,6377.35,4240468.50,0.00,0.00,0.00),('1','186','940','257968',4904663,'2761','419',3834607.04,3843803.54,0.00,0.00,9196.50,6092810.00,0.00,0.00,0.00),('1','186','940','257969',4904664,'2761','419',3843803.54,3851193.64,0.00,0.00,7390.10,4918866.00,0.00,0.00,0.00),('1','186','940','257970',4904665,'2761','419',3851193.64,3853186.43,0.00,0.00,1992.79,1341753.00,0.00,0.00,0.00),('1','186','940','257971',4904666,'2761','419',3853186.43,3853186.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257972',4904667,'2761','419',3853186.43,3866359.51,0.00,0.00,13173.08,8688688.00,0.00,0.00,0.00),('1','186','940','257973',4904668,'2761','419',3866359.51,3872511.34,0.00,0.00,6151.83,4134097.50,0.00,0.00,0.00),('1','186','940','257974',4904669,'2761','419',3872511.34,3878019.76,0.00,0.00,5508.42,3646924.00,0.00,0.00,0.00),('1','186','940','257975',4904670,'2761','419',3878019.76,3878019.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257976',4904671,'2761','419',3878019.76,3889778.84,0.00,0.00,11759.08,7741960.00,0.00,0.00,0.00),('1','186','940','257977',4904672,'2761','419',3889778.84,3897691.27,0.00,0.00,7912.43,5200849.00,0.00,0.00,0.00),('1','186','940','257978',4904673,'2761','419',3897691.27,3897691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257979',4904674,'2761','419',3897691.27,3900284.87,0.00,0.00,2593.60,1732015.00,0.00,0.00,0.00),('1','186','940','257980',4904675,'2761','419',3900284.87,3914279.34,0.00,0.00,13994.47,9210503.50,0.00,0.00,0.00),('1','186','940','257981',4904676,'2761','419',3914279.34,3922193.23,0.00,0.00,7913.89,5246601.50,0.00,0.00,0.00),('1','186','940','257982',4904677,'2761','419',3922193.23,3922193.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257983',4904678,'2761','419',3922193.23,3922734.84,0.00,0.00,541.61,359623.50,0.00,0.00,0.00),('1','186','940','257984',4904679,'2761','419',3922734.84,3934730.27,0.00,0.00,11995.43,7927080.00,0.00,0.00,0.00),('1','186','940','257985',4904680,'2761','419',3934730.27,3941784.23,0.00,0.00,7053.96,4626708.50,0.00,0.00,0.00),('1','186','940','257986',4904681,'2761','419',3941784.23,3941784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257987',4904682,'2761','419',3941784.23,3941784.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257988',4904683,'2761','419',3941784.23,3951612.01,0.00,0.00,9827.78,6477983.00,0.00,0.00,0.00),('1','186','940','257989',4904684,'2761','419',3951612.01,3966743.86,0.00,0.00,15131.85,9975772.50,0.00,0.00,0.00),('1','186','940','257990',4904685,'2761','419',3966743.86,3966743.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257991',4904686,'2761','419',3966743.86,3985087.42,0.00,0.00,18343.56,12094104.00,0.00,0.00,0.00),('1','186','940','257992',4904687,'2761','419',3985087.42,3990972.87,0.00,0.00,5885.45,3971365.00,0.00,0.00,0.00),('1','186','940','257993',4904688,'2761','419',3990972.87,3990972.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257994',4904689,'2761','419',3990972.87,3994442.85,0.00,0.00,3469.98,2340636.00,0.00,0.00,0.00),('1','186','940','257995',4904690,'2761','419',3994442.85,4010301.40,0.00,0.00,15858.55,10541000.50,0.00,0.00,0.00),('1','186','940','257996',4904691,'2761','419',4010301.40,4015685.51,0.00,0.00,5384.11,3574419.50,0.00,0.00,0.00),('1','186','940','257997',4904692,'2761','419',4015685.51,4015685.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','257998',4904693,'2761','419',4015685.51,4020651.47,0.00,0.00,4965.96,3297772.00,0.00,0.00,0.00),('1','186','940','257999',4904694,'2761','419',4020651.47,4035981.72,0.00,0.00,15330.25,10076374.00,0.00,0.00,0.00),('1','186','940','258000',4904695,'2761','419',4035981.72,4040036.24,0.00,0.00,4054.52,2672985.00,0.00,0.00,0.00),('1','186','940','258001',4904696,'2761','419',4040036.24,4040036.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258002',4904697,'2761','419',4040036.24,4049115.41,0.00,0.00,9079.17,5954018.00,0.00,0.00,0.00),('1','186','940','258003',4904698,'2761','419',4049115.41,4060538.60,0.00,0.00,11423.19,7553896.50,0.00,0.00,0.00),('1','186','940','258004',4904699,'2761','419',4060538.60,4064726.04,0.00,0.00,4187.44,2780208.00,0.00,0.00,0.00),('1','186','940','258005',4904700,'2761','419',4064726.04,4064726.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258006',4904701,'2761','419',4064726.04,4081262.38,0.00,0.00,16536.34,10929966.00,0.00,0.00,0.00),('1','186','940','258007',4904702,'2761','419',4081262.38,4089059.13,0.00,0.00,7796.75,5145153.50,0.00,0.00,0.00),('1','186','940','258008',4904703,'2761','419',4089059.13,4089059.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258009',4904704,'2761','419',4089059.13,4092975.73,0.00,0.00,3916.60,2612001.50,0.00,0.00,0.00),('1','186','940','258010',4904705,'2761','419',4092975.73,4103667.88,0.00,0.00,10692.15,7062518.50,0.00,0.00,0.00),('1','186','940','258011',4904706,'2761','419',4103667.88,4108473.17,0.00,0.00,4805.29,3169202.00,0.00,0.00,0.00),('1','186','940','258012',4904707,'2761','419',4108473.17,4108473.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258013',4904708,'2761','419',4108473.17,4122023.16,0.00,0.00,13549.99,8913198.00,0.00,0.00,0.00),('1','186','940','258014',4904709,'2761','419',4122023.16,4127656.24,0.00,0.00,5633.08,3697377.50,0.00,0.00,0.00),('1','186','940','258015',4904710,'2761','419',4127656.24,4127656.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258016',4904711,'2761','419',4127656.24,4141412.71,0.00,0.00,13756.47,8987738.00,0.00,0.00,0.00),('1','186','940','258017',4904712,'2761','419',4141412.71,4146908.28,0.00,0.00,5495.57,3640149.00,0.00,0.00,0.00),('1','186','940','258018',4904713,'2761','419',4146908.28,4146908.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258019',4904714,'2761','419',4146908.28,4150138.73,0.00,0.00,3230.45,2156965.00,0.00,0.00,0.00),('1','186','940','258020',4904715,'2761','419',4150138.73,4158491.35,0.00,0.00,8352.62,5552564.00,0.00,0.00,0.00),('1','186','940','258021',4904716,'2761','419',4158491.35,4158491.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258022',4904717,'2761','419',4158491.35,4171724.83,0.00,0.00,13233.48,8708239.00,0.00,0.00,0.00),('1','186','940','258023',4904718,'2761','419',4171724.83,4171724.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258024',4904719,'2761','419',4171724.83,4189468.11,0.00,0.00,17743.28,11632020.00,0.00,0.00,0.00),('1','186','940','258025',4904720,'2761','419',4189468.11,4196058.90,0.00,0.00,6590.79,4366219.04,0.00,0.00,0.00),('1','186','940','258026',4904721,'2761','419',4196058.90,4196058.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258027',4904722,'2761','419',4196058.90,4198300.61,0.00,0.00,2241.71,1486750.96,0.00,0.00,0.00),('1','186','940','258028',4904723,'2761','419',4198300.61,4207721.45,0.00,0.00,9420.84,6239377.50,0.00,0.00,0.00),('1','186','940','258029',4904724,'2761','419',4207721.45,4217031.45,0.00,0.00,9310.00,6174492.80,0.00,0.00,0.00),('1','186','940','258030',4904725,'2761','419',4217031.45,4220413.17,0.00,0.00,3381.72,2231163.50,0.00,0.00,0.00),('1','186','940','258031',4904726,'2761','419',4220413.17,4224683.20,0.00,0.00,4270.03,2795572.80,0.00,0.00,0.00),('1','186','940','258032',4904727,'2761','419',4224683.20,4234280.92,0.00,0.00,9597.72,6255352.40,0.00,0.00,0.00),('1','186','940','258033',4904728,'2761','419',4234280.92,4242243.07,0.00,0.00,7962.15,5188873.60,0.00,0.00,0.00),('1','186','940','258034',4904729,'2761','419',4242243.07,4244244.70,0.00,0.00,2001.63,1281383.61,0.00,0.00,0.00),('1','186','940','258035',4904730,'2761','419',4244244.70,4244244.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258036',4904731,'2761','419',4244244.70,4244244.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258037',4904732,'2761','419',4244244.70,4244244.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258038',4904733,'2761','419',4244244.70,4253469.67,0.00,0.00,9224.97,5974467.39,0.00,0.00,0.00),('1','186','940','258039',4904734,'2761','419',4253469.67,4262075.20,0.00,0.00,8605.53,5586923.60,0.00,0.00,0.00),('1','186','940','258040',4904735,'2761','419',4262075.20,4268290.32,0.00,0.00,6215.12,4043870.73,0.00,0.00,0.00),('1','186','940','258041',4904736,'2761','419',4268290.32,4268290.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258042',4904737,'2761','419',4268290.32,4270048.87,0.00,0.00,1758.55,1138720.07,0.00,0.00,0.00),('1','186','940','258043',4904738,'2761','419',4270048.87,4279808.26,0.00,0.00,9759.39,6331799.20,0.00,0.00,0.00),('1','186','940','258044',4904739,'2761','419',4279808.26,4287389.20,0.00,0.00,7580.94,4951843.20,0.00,0.00,0.00),('1','186','940','258045',4904740,'2761','419',4287389.20,4292736.30,0.00,0.00,5347.10,3473936.84,0.00,0.00,0.00),('1','186','940','258046',4904741,'2761','419',4292736.30,4292736.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258047',4904742,'2761','419',4292736.30,4296262.93,0.00,0.00,3526.63,2303834.10,0.00,0.00,0.00),('1','186','940','258048',4904743,'2761','419',4296262.93,4306146.54,0.00,0.00,9883.61,6316388.70,0.00,0.00,0.00),('1','186','940','258049',4904744,'2761','419',4306146.54,4317420.64,0.00,0.00,11274.10,7153057.60,0.00,0.00,0.00),('1','186','940','258050',4904745,'2761','419',4317420.64,4317420.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258051',4904746,'2761','419',4317420.64,4322314.55,0.00,0.00,4893.91,3137285.70,0.00,0.00,0.00),('1','186','940','258052',4904747,'2761','419',4322314.55,4332396.80,0.00,0.00,10082.25,6435949.90,0.00,0.00,0.00),('1','186','940','258053',4904748,'2761','419',4332396.80,4342084.49,0.00,0.00,9687.69,6166844.30,0.00,0.00,0.00),('1','186','940','258054',4904749,'2761','419',4342084.49,4342132.48,0.00,0.00,47.99,30233.70,0.00,0.00,0.00),('1','186','940','258055',4904750,'2761','419',4342132.48,4342132.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258056',4904751,'2761','419',4342132.48,4356221.76,0.00,0.00,14089.28,8964368.40,0.00,0.00,0.00),('1','186','940','258057',4904752,'2761','419',4356221.76,4366407.31,0.00,0.00,10185.55,6488976.77,0.00,0.00,0.00),('1','186','940','258058',4904753,'2761','419',4366407.31,4366407.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258059',4904754,'2761','419',4366407.31,4368064.39,0.00,0.00,1657.08,1054917.46,0.00,0.00,0.00),('1','186','940','258060',4904755,'2761','419',4368064.39,4379357.54,0.00,0.00,11293.15,7194026.90,0.00,0.00,0.00),('1','186','940','258061',4904756,'2761','419',4379357.54,4387769.39,0.00,0.00,8411.85,5394557.10,0.00,0.00,0.00),('1','186','940','258062',4904757,'2761','419',4387769.39,4390554.65,0.00,0.00,2785.26,1768760.30,0.00,0.00,0.00),('1','186','940','258063',4904758,'2761','419',4390554.65,4390554.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258064',4904759,'2761','419',4390554.65,4393860.83,0.00,0.00,3306.18,2144809.40,0.00,0.00,0.00),('1','186','940','258065',4904760,'2761','419',4393860.83,4405439.66,0.00,0.00,11578.83,7380601.10,0.00,0.00,0.00),('1','186','940','258066',4904761,'2761','419',4405439.66,4411466.75,0.00,0.00,6027.09,3892742.70,0.00,0.00,0.00),('1','186','940','258067',4904762,'2761','419',4411466.75,4414827.72,0.00,0.00,3360.97,2136258.30,0.00,0.00,0.00),('1','186','940','258068',4904763,'2761','419',4414827.72,4414827.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258069',4904764,'2761','419',4414827.72,4420542.18,0.00,0.00,5714.46,3682666.60,0.00,0.00,0.00),('1','186','940','258070',4904765,'2761','419',4420542.18,4430097.96,0.00,0.00,9555.78,6128462.40,0.00,0.00,0.00),('1','186','940','258071',4904766,'2761','419',4430097.96,4439181.35,0.00,0.00,9083.39,5762161.50,0.00,0.00,0.00),('1','186','940','258072',4904767,'2761','419',4439181.35,4439237.14,0.00,0.00,55.79,35147.70,0.00,0.00,0.00),('1','186','940','258073',4904768,'2761','419',4439237.14,4439237.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258074',4904769,'2761','419',4439237.14,4445330.92,0.00,0.00,6093.78,3914019.40,0.00,0.00,0.00),('1','186','940','258075',4904770,'2761','419',4445330.92,4455829.26,0.00,0.00,10498.34,6714854.60,0.00,0.00,0.00),('1','186','940','258076',4904771,'2761','419',4455829.26,4463842.34,0.00,0.00,8013.08,5136927.20,0.00,0.00,0.00),('1','186','940','258077',4904772,'2761','419',4463842.34,4463842.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258078',4904773,'2761','419',4463842.34,4482197.59,0.00,0.00,18355.25,11577693.50,0.00,0.00,0.00),('1','186','940','258079',4904774,'2761','419',4482197.59,4487986.55,0.00,0.00,5788.96,3698723.89,0.00,0.00,0.00),('1','186','940','258080',4904775,'2761','419',4487986.55,4487986.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258081',4904776,'2761','419',4487986.55,4492107.60,0.00,0.00,4121.05,2642989.81,0.00,0.00,0.00),('1','186','940','258082',4904777,'2761','419',4492107.60,4498398.92,0.00,0.00,6291.32,4068000.80,0.00,0.00,0.00),('1','186','940','258083',4904778,'2761','419',4498398.92,4508406.58,0.00,0.00,10007.66,6392012.60,0.00,0.00,0.00),('1','186','940','258084',4904779,'2761','419',4508406.58,4512259.85,0.00,0.00,3853.27,2470761.30,0.00,0.00,0.00),('1','186','940','258085',4904780,'2761','419',4512259.85,4512259.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258086',4904781,'2761','419',4512259.85,4522986.44,0.00,0.00,10726.59,6837845.30,0.00,0.00,0.00),('1','186','940','258087',4904782,'2761','419',4522986.44,4535443.72,0.00,0.00,12457.28,7930170.25,0.00,0.00,0.00),('1','186','940','258088',4904783,'2761','419',4535443.72,4536504.76,0.00,0.00,1061.04,681937.20,0.00,0.00,0.00),('1','186','940','258089',4904784,'2761','419',4536504.76,4536532.51,0.00,0.00,27.75,17482.50,0.00,0.00,0.00),('1','186','940','258090',4904785,'2761','419',4536532.51,4536532.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258091',4904786,'2761','419',4536532.51,4548123.15,0.00,0.00,11590.64,7385567.40,0.00,0.00,0.00),('1','186','940','258092',4904787,'2761','419',4548123.15,4555710.18,0.00,0.00,7587.03,4878798.50,0.00,0.00,0.00),('1','186','940','258093',4904788,'2761','419',4555710.18,4555710.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258094',4904789,'2761','419',4555710.18,4560174.11,0.00,0.00,4463.93,2867454.50,0.00,0.00,0.00),('1','186','940','258095',4904790,'2761','419',4560174.11,4568751.26,0.00,0.00,8577.15,5524492.90,0.00,0.00,0.00),('1','186','940','258096',4904791,'2761','419',4568751.26,4579919.69,0.00,0.00,11168.43,7144189.30,0.00,0.00,0.00),('1','186','940','258097',4904792,'2761','419',4579919.69,4579919.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258098',4904793,'2761','419',4579919.69,4593412.50,0.00,0.00,13492.81,8622038.50,0.00,0.00,0.00),('1','186','940','258099',4904794,'2761','419',4593412.50,4597168.24,0.00,0.00,3755.74,2345899.00,0.00,0.00,0.00),('1','186','940','258100',4904795,'2761','419',4597168.24,4604242.21,0.00,0.00,7073.97,4513256.70,0.00,0.00,0.00),('1','186','940','258101',4904796,'2761','419',4604242.21,4604242.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258102',4904797,'2761','419',4604242.21,4613699.12,0.00,0.00,9456.91,6075186.70,0.00,0.00,0.00),('1','186','940','258103',4904798,'2761','419',4613699.12,4628361.09,0.00,0.00,14661.97,9330381.30,0.00,0.00,0.00),('1','186','940','258104',4904799,'2761','419',4628361.09,4628590.20,0.00,0.00,229.11,148103.70,0.00,0.00,0.00),('1','186','940','258105',4904800,'2761','419',4628590.20,4628590.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258106',4904801,'2761','419',4628590.20,4637368.97,0.00,0.00,8778.77,5528175.90,0.00,0.00,0.00),('1','186','940','258107',4904802,'2761','419',4637368.97,4644489.20,0.00,0.00,7120.23,4613473.30,0.00,0.00,0.00),('1','186','940','258108',4904803,'2761','419',4644489.20,4644745.29,0.00,0.00,256.09,161336.70,0.00,0.00,0.00),('1','186','940','258109',4904804,'2761','419',4644745.29,4652449.90,0.00,0.00,7704.61,4922925.70,0.00,0.00,0.00),('1','186','940','258110',4904805,'2761','419',4652449.90,4652449.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258111',4904806,'2761','419',4652449.90,4654551.11,0.00,0.00,2101.21,1350850.70,0.00,0.00,0.00),('1','186','940','258112',4904807,'2761','419',4654551.11,4662901.25,0.00,0.00,8350.14,5380158.20,0.00,0.00,0.00),('1','186','940','258113',4904808,'2761','419',4662901.25,4676099.02,0.00,0.00,13197.77,8423481.70,0.00,0.00,0.00),('1','186','940','258114',4904809,'2761','419',4676099.02,4676822.40,0.00,0.00,723.38,466421.80,0.00,0.00,0.00),('1','186','940','258115',4904810,'2761','419',4676822.40,4676822.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258116',4904811,'2761','419',4676822.40,4683137.52,0.00,0.00,6315.12,4032577.60,0.00,0.00,0.00),('1','186','940','258117',4904812,'2761','419',4683137.52,4691251.09,0.00,0.00,8113.57,5212912.70,0.00,0.00,0.00),('1','186','940','258118',4904813,'2761','419',4691251.09,4700697.30,0.00,0.00,9446.21,6049336.70,0.00,0.00,0.00),('1','186','940','258119',4904814,'2761','419',4700697.30,4701596.02,0.00,0.00,898.72,578298.40,0.00,0.00,0.00),('1','186','940','258120',4904815,'2761','419',4701596.02,4701596.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258121',4904816,'2761','419',4701596.02,4708245.32,0.00,0.00,6649.30,4295385.20,0.00,0.00,0.00),('1','186','940','258122',4904817,'2761','419',4708245.32,4714998.22,0.00,0.00,6752.90,4381482.60,0.00,0.00,0.00),('1','186','940','258123',4904818,'2761','419',4714998.22,4724954.12,0.00,0.00,9955.90,6383882.30,0.00,0.00,0.00),('1','186','940','258124',4904819,'2761','419',4724954.12,4725688.93,0.00,0.00,734.81,463075.64,0.00,0.00,0.00),('1','186','940','258125',4904820,'2761','419',4725688.93,4725688.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258126',4904821,'2761','419',4725688.93,4732638.80,0.00,0.00,6949.87,4444225.07,0.00,0.00,0.00),('1','186','940','258127',4904822,'2761','419',4732638.80,4740636.96,0.00,0.00,7998.16,5152126.00,0.00,0.00,0.00),('1','186','940','258128',4904823,'2761','419',4740636.96,4750032.73,0.00,0.00,9395.77,5840265.90,0.00,0.00,0.00),('1','186','940','258129',4904824,'2761','419',4750032.73,4750032.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258130',4904825,'2761','419',4750032.73,4753492.16,0.00,0.00,3459.43,2239978.10,0.00,0.00,0.00),('1','186','940','258131',4904826,'2761','419',4753492.16,4764327.90,0.00,0.00,10835.74,6922511.40,0.00,0.00,0.00),('1','186','940','258132',4904827,'2761','419',4764327.90,4774609.25,0.00,0.00,10281.35,6612864.50,0.00,0.00,0.00),('1','186','940','258133',4904828,'2761','419',4774609.25,4774873.31,0.00,0.00,264.06,167153.40,0.00,0.00,0.00),('1','186','940','258134',4904829,'2761','419',4774873.31,4774873.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','186','940','258135',4904830,'2761','419',4774873.31,4794767.09,0.00,0.00,19893.78,12634894.10,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730339 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','186','205278','419',0.00,352.00,0.00,4590.02,0.00,1436278.88,1436278.88,594128),('1','186','205562','419',0.00,352.00,0.00,6519.75,0.00,2022937.14,2022937.14,594853),('1','186','205968','419',352.00,352.00,0.00,3062.40,1077964.80,960889.80,-117075.00,595905),('1','186','206045','419',352.00,352.00,0.00,4687.60,1650035.20,1461269.20,-188766.00,596107),('1','186','206248','419',352.00,292.00,0.00,0.00,0.00,0.00,0.00,596626),('1','186','206423','419',300.00,352.00,0.00,5847.40,1754220.00,2007902.80,253682.80,597063),('1','186','206458','419',300.00,352.00,0.00,5017.90,1505370.00,1575670.80,70300.80,597155),('1','186','206592','419',300.00,352.00,0.00,2712.60,813780.00,859835.20,46055.20,597494),('1','186','206824','419',300.00,352.00,0.00,4883.40,1465020.00,1525556.80,60536.80,598094),('1','186','206988','419',300.00,352.00,0.00,538.70,161610.00,161610.00,0.00,598540),('1','186','207263','419',300.00,352.00,0.00,9925.80,2977740.00,3100281.60,122541.60,599232),('1','186','207674','419',360.00,360.00,0.00,3185.90,1121436.80,1006316.80,-115120.00,600294),('1','186','208006','419',352.00,352.00,0.00,7421.40,2671704.00,2392210.00,-279494.00,601139),('1','186','208133','419',300.00,360.00,0.00,2146.60,643980.00,701526.00,57546.00,601458),('1','186','208406','419',300.00,360.00,0.00,320.00,96000.00,96000.00,0.00,602164),('1','186','208408','419',300.00,360.00,0.00,11617.50,3485250.00,3744407.00,259157.00,602168),('1','186','208567','419',300.00,360.00,0.00,11197.70,3359310.00,3607838.00,248528.00,602569),('1','186','208661','419',300.00,360.00,0.00,1202.70,360810.00,388126.00,27316.00,602820),('1','186','208847','419',300.00,360.00,0.00,842.40,252720.00,252720.00,0.00,603279),('1','186','209068','419',300.00,360.00,0.00,12702.50,3810750.00,4083100.00,272350.00,603843),('1','186','209193','419',372.00,372.00,0.00,9568.20,3559370.40,3130258.40,-429112.00,604182),('1','186','209620','419',300.00,372.00,0.00,706.90,212070.00,248764.80,36694.80,605276),('1','186','209835','419',300.00,372.00,0.00,1672.30,501690.00,570471.60,68781.60,605836),('1','186','209837','419',300.00,372.00,0.00,350.10,105030.00,105030.00,0.00,605839),('1','186','209838','419',300.00,372.00,0.00,20871.30,6261390.00,7006944.60,745554.60,605840),('1','186','210113','419',300.00,372.00,0.00,307.40,122960.00,122960.00,0.00,606539),('1','186','210369','419',400.00,400.00,0.00,901.10,360440.00,341272.80,-19167.20,607192),('1','186','210533','419',300.00,400.00,0.00,2409.00,963600.00,857270.40,-106329.60,607630),('1','186','210540','419',400.00,400.00,0.00,341.20,136480.00,102360.00,-34120.00,607649),('1','186','210922','419',340.00,400.00,0.00,8083.40,2748356.00,2867163.20,118807.20,608655),('1','186','210924','419',340.00,400.00,0.00,8068.10,2743154.00,2859636.80,116482.80,608659),('1','186','211180','419',340.00,400.00,0.00,8388.90,2852226.00,2976768.00,124542.00,609307),('1','186','211184','419',340.00,400.00,0.00,340.00,115600.00,115600.00,0.00,609313),('1','186','211385','419',340.00,400.00,0.00,15217.10,5173814.00,5381302.40,207488.40,609841),('1','186','211477','419',400.00,400.00,0.00,9448.00,3779200.00,3355248.00,-423952.00,610086),('1','186','211660','419',340.00,400.00,0.00,334.90,113866.00,113866.00,0.00,610556),('1','186','211662','419',340.00,400.00,0.00,4750.40,1615136.00,1753892.00,138756.00,610560),('1','186','212036','419',340.00,400.00,0.00,13085.60,4449104.00,4807869.80,358765.80,611519),('1','186','212047','419',340.00,400.00,0.00,1652.20,561748.00,612664.60,50916.60,611550),('1','186','212549','419',420.00,420.00,0.00,2416.90,889419.20,903048.00,13628.80,612874),('1','186','212759','419',368.00,420.00,0.00,5161.00,1899248.00,1936940.00,37692.00,613430),('1','186','213102','419',368.00,420.00,0.00,7349.30,2704542.40,2740156.00,35613.60,614334),('1','186','213430','419',368.00,420.00,0.00,4825.12,1775644.16,1796120.40,20476.24,615158),('1','186','213696','419',368.00,420.00,0.00,4872.20,1792969.60,1802774.00,9804.40,615877),('1','186','214060','419',368.00,420.00,0.00,374.00,137632.00,137632.00,0.00,616839),('1','186','214192','419',368.00,420.00,0.00,9105.20,3350713.60,3389342.00,38628.40,617165),('1','186','214334','419',368.00,420.00,0.00,8085.10,2975316.80,3021422.00,46105.20,617538),('1','186','214427','419',400.00,400.00,0.00,3835.20,1542584.00,1444404.00,-98180.00,617780),('1','186','214647','419',420.00,420.00,0.00,3592.50,1341410.00,1354290.00,12880.00,618343),('1','186','214831','419',368.00,420.00,0.00,372.00,136896.00,136896.00,0.00,618826),('1','186','215082','419',368.00,420.00,0.00,10279.00,3782672.00,3832396.00,49724.00,619490),('1','186','215161','419',368.00,420.00,0.00,6453.70,2374961.60,2409588.00,34626.40,619694),('1','186','215556','419',368.00,420.00,0.00,7474.90,2750763.20,2791922.00,41158.80,620694),('1','186','215561','419',368.00,420.00,0.00,722.00,265696.00,265696.00,0.00,620704),('1','186','215718','419',368.00,420.00,0.00,13788.90,5074315.20,5131424.00,57108.80,621110),('1','186','215813','419',368.00,420.00,0.00,10403.90,3828635.20,3877880.00,49244.80,621365),('1','186','216124','419',368.00,420.00,0.00,967.20,355929.60,355929.60,0.00,622156),('1','186','216216','419',368.00,430.00,0.00,20602.20,7581609.60,7729721.00,148111.40,622400),('1','186','216685','419',368.00,430.00,0.00,4025.60,1481420.80,1549014.60,67593.80,623642),('1','186','216995','419',480.00,480.00,0.00,372.20,178656.00,136969.60,-41686.40,624463),('1','186','216996','419',480.00,480.00,0.00,18716.30,7112194.00,7425222.00,313028.00,624464),('1','186','217368','419',380.00,480.00,0.00,6058.75,2302325.00,2566910.10,264585.10,625429),('1','186','217673','419',380.00,480.00,0.00,372.50,141550.00,141550.00,0.00,626238),('1','186','217676','419',480.00,480.00,0.00,2874.32,1149728.00,1226283.60,76555.60,626245),('1','186','217748','419',400.00,480.00,0.00,1071.30,428520.00,480156.00,51636.00,626411),('1','186','218039','419',400.00,480.00,0.00,6801.70,2720680.00,2881526.00,160846.00,627181),('1','186','218276','419',400.00,480.00,0.00,4402.00,1760800.00,1876440.00,115640.00,627807),('1','186','218279','419',400.00,480.00,0.00,9021.80,3608720.00,3811836.60,203116.60,627814),('1','186','218481','419',400.00,480.00,0.00,358.80,143520.00,143520.00,0.00,628339),('1','186','218736','419',400.00,480.00,0.00,6116.50,2446600.00,2592634.00,146034.00,628999),('1','186','218945','419',400.00,480.00,0.00,2730.50,1092200.00,1169540.00,77340.00,629553),('1','186','219058','419',400.00,480.00,0.00,5790.10,2316040.00,2459824.80,143784.80,629854),('1','186','220568','419',400.00,480.00,0.00,4992.50,1997000.00,2087019.20,90019.20,633828),('1','186','220571','419',400.00,480.00,0.00,4814.80,1925920.00,2003795.20,77875.20,633835),('1','186','220581','419',400.00,480.00,0.00,395.60,158240.00,158240.00,0.00,633862),('1','186','220585','419',400.00,480.00,0.00,10180.80,4072320.00,4238218.20,165898.20,633873),('1','186','220597','419',400.00,480.00,0.00,9605.70,3842280.00,3994462.20,152182.20,633904),('1','186','220601','419',400.00,480.00,0.00,4916.80,1966720.00,2057807.00,91087.00,633914),('1','186','220606','419',400.00,480.00,0.00,476.00,190400.00,190400.00,0.00,633925),('1','186','220610','419',400.00,480.00,0.00,6417.00,2566800.00,2687304.00,120504.00,633934),('1','186','220763','419',400.00,480.00,0.00,10779.30,4311720.00,4466386.80,154666.80,634325),('1','186','221107','419',400.00,480.00,0.00,7047.80,2819120.00,2930572.20,111452.20,635232),('1','186','221110','419',400.00,480.00,0.00,292.60,117040.00,119966.00,2926.00,635239),('1','186','221111','419',400.00,480.00,0.00,383.30,153320.00,153320.00,0.00,635240),('1','186','221683','419',400.00,480.00,0.00,7045.30,2818120.00,2910564.00,92444.00,636726),('1','186','221828','419',400.00,480.00,0.00,9465.10,3786040.00,3915498.00,129458.00,637108),('1','186','222134','419',400.00,480.00,0.00,8122.70,3249080.00,3373963.00,124883.00,637894),('1','186','222345','419',400.00,480.00,0.00,367.90,147160.00,147160.00,0.00,638437),('1','186','222350','419',400.00,480.00,0.00,9319.80,3727920.00,3864576.00,136656.00,638450),('1','186','222574','419',400.00,480.00,0.00,8134.00,3253600.00,3374315.00,120715.00,639025),('1','186','222793','419',400.00,480.00,0.00,7168.20,2867280.00,2960034.60,92754.60,639601),('1','186','223010','419',400.00,480.00,0.00,378.00,151200.00,151200.00,0.00,640195),('1','186','223012','419',400.00,480.00,0.00,13513.40,5405360.00,5585543.00,180183.00,640199),('1','186','223194','419',400.00,480.00,0.00,5537.10,2214840.00,2289143.20,74303.20,640650),('1','186','223200','419',400.00,480.00,0.00,379.50,151800.00,151800.00,0.00,640665),('1','186','223228','419',400.00,480.00,0.00,18868.50,8094586.50,7771480.00,-323106.50,640738),('1','186','223515','419',429.00,480.00,0.00,5782.50,2480692.50,2581601.60,100909.10,641452),('1','186','223543','419',429.00,480.00,0.00,0.00,0.00,0.00,0.00,641525),('1','186','224137','419',435.00,500.00,0.00,7565.20,3290862.00,3422148.00,131286.00,643055),('1','186','224386','419',435.00,500.00,0.00,16673.00,7252755.00,7506442.00,253687.00,643701),('1','186','224624','419',435.00,500.00,0.00,415.60,180786.00,198656.80,17870.80,644334),('1','186','224629','419',435.00,500.00,0.00,0.00,0.00,0.00,0.00,644347),('1','186','224669','419',435.00,500.00,0.00,7133.70,3124153.20,3437436.00,313282.80,644454),('1','186','224698','419',520.00,520.00,0.00,11728.70,6098924.00,5625421.80,-473502.20,644533),('1','186','224807','419',520.00,520.00,0.00,5789.50,3010540.00,2787606.00,-222934.00,644783),('1','186','224997','419',520.00,520.00,0.00,0.00,0.00,0.00,0.00,645304),('1','186','225162','419',520.00,520.00,0.00,8515.30,3670094.30,3935942.60,265848.30,645721),('1','186','225461','419',431.00,520.00,0.00,14092.70,6073953.70,6494543.60,420589.90,646499),('1','186','225549','419',431.00,520.00,0.00,2045.00,881395.00,948556.20,67161.20,646714),('1','186','225674','419',431.00,520.00,0.00,0.00,0.00,0.00,0.00,647050),('1','186','225675','419',431.00,520.00,0.00,19487.90,8399284.90,8957098.00,557813.10,647051),('1','186','225994','419',431.00,520.00,0.00,5167.50,2227192.50,2481117.00,253924.50,647869),('1','186','226042','419',431.00,520.00,0.00,0.00,0.00,0.00,0.00,647997),('1','186','226069','419',431.00,520.00,0.00,6611.00,2849341.00,3181720.00,332379.00,648068),('1','186','226275','419',431.00,520.00,0.00,2418.58,1042407.98,1154647.85,112239.87,648603),('1','186','226542','419',431.00,520.00,0.00,14122.40,6086754.40,6580883.70,494129.30,649273),('1','186','226931','419',431.00,520.00,0.00,1438.92,620174.52,703341.60,83167.08,650312),('1','186','226985','419',431.00,520.00,0.00,0.00,0.00,0.00,0.00,650438),('1','186','226990','419',431.00,520.00,0.00,17825.50,7682790.50,8299550.00,616759.50,650449),('1','186','226996','419',431.00,520.00,0.00,1845.38,795358.78,910242.40,114883.62,650463),('1','186','227199','419',431.00,520.00,0.00,4877.17,2102060.27,2359890.26,257829.99,650988),('1','186','227675','419',431.00,520.00,0.00,0.00,0.00,0.00,0.00,652213),('1','186','227682','419',431.00,520.00,0.00,16317.50,7032842.50,7834000.00,801157.50,652231),('1','186','227897','419',431.00,520.00,0.00,6723.50,2897828.50,3238820.00,340991.50,652788),('1','186','227907','419',431.00,520.00,0.00,1511.40,651413.40,734092.00,82678.60,652814),('1','186','228099','419',431.00,520.00,0.00,0.00,0.00,0.00,0.00,653350),('1','186','228101','419',431.00,520.00,0.00,4860.50,2094875.50,2341060.00,246184.50,653354),('1','186','228117','419',431.00,520.00,0.00,13320.30,5741049.30,6396394.20,655344.90,653379),('1','186','228338','419',431.00,520.00,0.00,5411.70,2909347.00,2677588.00,-231759.00,653964),('1','186','228548','419',540.00,540.00,0.00,1061.73,573334.20,538045.00,-35289.20,654472),('1','186','228738','419',540.00,540.00,0.00,0.00,0.00,0.00,0.00,654984),('1','186','228801','419',540.00,540.00,0.00,1863.00,903555.00,931720.00,28165.00,655120),('1','186','228825','419',485.00,540.00,0.00,1793.67,869929.95,922181.80,52251.85,655189),('1','186','228945','419',485.00,540.00,0.00,3386.70,1642549.50,1714232.00,71682.50,655493),('1','186','229195','419',485.00,540.00,0.00,17614.93,9502244.70,8807453.94,-694790.76,656148),('1','186','229434','419',540.00,540.00,0.00,0.00,0.00,0.00,0.00,656765),('1','186','229501','419',485.00,540.00,0.00,0.00,0.00,0.00,0.00,656935),('1','186','229507','419',485.00,540.00,0.00,0.00,0.00,0.00,0.00,656952),('1','186','229738','419',502.00,540.00,0.00,1412.50,716500.00,738600.00,22100.00,657544),('1','186','229870','419',568.00,568.00,0.00,3166.50,1798572.00,1661622.00,-136950.00,657904),('1','186','229903','419',568.00,568.00,0.00,9573.70,5437861.60,5006881.60,-430980.00,657964),('1','186','230073','419',568.00,568.00,0.00,8373.50,4756148.00,4383948.00,-372200.00,658427),('1','186','230278','419',568.00,568.00,0.00,2136.30,1213418.40,1132446.80,-80971.60,658941),('1','186','230516','419',568.00,568.00,0.00,0.00,0.00,0.00,0.00,659562),('1','186','230517','419',568.00,568.00,0.00,10368.50,5028722.50,5419108.00,390385.50,659563),('1','186','230768','419',485.00,568.00,0.00,8625.30,4183270.50,4514220.40,330949.90,660226),('1','186','231126','419',485.00,568.00,0.00,5675.00,2752375.00,2961623.70,209248.70,661154),('1','186','231442','419',485.00,568.00,0.00,0.00,0.00,0.00,0.00,662000),('1','186','232074','419',528.00,568.00,0.00,1312.00,771456.00,715948.50,-55507.50,663700),('1','186','232131','419',588.00,588.00,0.00,7729.90,4545181.20,4216088.30,-329092.90,663833),('1','186','232372','419',588.00,588.00,0.00,8141.20,4787025.60,4437133.60,-349892.00,664449),('1','186','232596','419',588.00,588.00,0.00,7468.00,4391184.00,4068304.00,-322880.00,665052),('1','186','232863','419',588.00,588.00,0.00,0.00,0.00,0.00,0.00,665755),('1','186','233009','419',588.00,588.00,0.00,9479.60,4597606.00,5162919.80,565313.80,666157),('1','186','233099','419',485.00,588.00,0.00,13812.70,6699159.50,7508567.60,809408.10,666385),('1','186','233587','419',485.00,588.00,0.00,1448.20,702377.00,813888.40,111511.40,667665),('1','186','233765','419',485.00,588.00,0.00,0.00,0.00,0.00,0.00,668130),('1','186','233816','419',485.00,588.00,0.00,2383.45,1439603.80,1368603.80,-71000.00,668269),('1','186','234098','419',604.00,604.00,0.00,3956.50,2389726.00,2255526.00,-134200.00,668994),('1','186','234179','419',604.00,604.00,0.00,3817.50,2305770.00,2165670.00,-140100.00,669214),('1','186','234311','419',604.00,604.00,0.00,1466.50,885766.00,835766.00,-50000.00,669565),('1','186','234584','419',604.00,604.00,0.00,2418.20,1460592.80,1387592.80,-73000.00,670284),('1','186','234825','419',604.00,604.00,0.00,2715.80,1640343.20,1555143.20,-85200.00,670925),('1','186','235121','419',604.00,604.00,0.00,7769.55,4692808.20,4375058.30,-317749.90,671718),('1','186','235178','419',604.00,604.00,0.00,239.10,144416.40,134374.20,-10042.20,671869),('1','186','235179','419',604.00,604.00,0.00,0.00,0.00,0.00,0.00,671870),('1','186','235274','419',604.00,604.00,0.00,14543.80,7577319.80,8205355.20,628035.40,672130),('1','186','235323','419',521.00,604.00,0.00,9439.50,4917979.50,5343932.00,425952.50,672241),('1','186','235534','419',521.00,604.00,0.00,654.10,340786.10,377281.20,36495.10,672781),('1','186','235712','419',521.00,604.00,0.00,0.00,0.00,0.00,0.00,673258),('1','186','235713','419',521.00,604.00,0.00,9563.50,4982583.50,5465254.00,482670.50,673259),('1','186','235758','419',521.00,604.00,0.00,8147.00,4244587.00,4660188.00,415601.00,673364),('1','186','236070','419',521.00,604.00,0.00,6935.00,3613135.00,3970228.00,357093.00,674181),('1','186','236245','419',521.00,604.00,0.00,0.00,0.00,0.00,0.00,674650),('1','186','236441','419',521.00,604.00,0.00,12443.50,6815354.00,7117874.00,302520.00,675187),('1','186','236521','419',604.00,604.00,0.00,8323.50,5027394.00,4775094.00,-252300.00,675382),('1','186','236721','419',604.00,604.00,0.00,3881.00,2344124.00,2219152.00,-124972.00,675904),('1','186','236924','419',604.00,604.00,0.00,0.00,0.00,0.00,0.00,676435),('1','186','237522','419',632.00,632.00,0.00,16727.50,10571780.00,9893880.00,-677900.00,677965),('1','186','237686','419',632.00,632.00,0.00,6269.05,3962039.60,3774639.60,-187400.00,678384),('1','186','237899','419',632.00,632.00,0.00,1637.45,1034868.40,977538.75,-57329.65,678933),('1','186','238081','419',632.00,632.00,0.00,0.00,0.00,0.00,0.00,679431),('1','186','238223','419',578.00,632.00,0.00,3892.83,2250055.74,2322248.69,72192.95,679778),('1','186','238351','419',578.00,632.00,0.00,14063.00,8128414.00,8357432.90,229018.90,680110),('1','186','238609','419',578.00,632.00,0.00,6740.17,3895818.26,4014110.25,118291.99,680784),('1','186','238891','419',578.00,632.00,0.00,0.00,0.00,0.00,0.00,681509),('1','186','238899','419',578.00,632.00,0.00,16517.20,9546941.60,9819580.05,272638.45,681529),('1','186','239082','419',578.00,632.00,0.00,8090.80,4676482.40,4815381.27,138898.87,682000),('1','186','239304','419',578.00,632.00,0.00,0.00,0.00,0.00,0.00,682583),('1','186','239432','419',578.00,632.00,0.00,4217.50,2437715.00,2520160.00,82445.00,682932),('1','186','239698','419',578.00,632.00,0.00,18695.50,10805999.00,11118706.00,312707.00,683619),('1','186','239871','419',578.00,632.00,0.00,1640.00,947920.00,990560.00,42640.00,684065),('1','186','240168','419',578.00,632.00,0.00,0.00,0.00,0.00,0.00,684848),('1','186','240308','419',640.00,640.00,0.00,357.14,228569.60,214998.28,-13571.32,685189),('1','186','240320','419',640.00,640.00,0.00,1406.50,900160.00,859400.00,-40760.00,685221),('1','186','240476','419',640.00,640.00,0.00,19529.66,12498982.40,11624448.88,-874533.52,685629),('1','186','240721','419',640.00,640.00,0.00,0.00,0.00,0.00,0.00,686220),('1','186','240735','419',640.00,640.00,0.00,4226.00,2484888.00,2537790.00,52902.00,686255),('1','186','240987','419',588.00,640.00,0.00,3855.50,2267034.00,2303770.00,36736.00,686936),('1','186','241244','419',588.00,640.00,0.00,14896.00,8758848.00,8859590.00,100742.00,687608),('1','186','241519','419',588.00,640.00,0.00,1676.20,985605.60,993986.60,8381.00,688338),('1','186','241698','419',588.00,640.00,0.00,0.00,0.00,0.00,0.00,688834),('1','186','241776','419',588.00,640.00,0.00,2225.00,1308300.00,1328350.00,20050.00,689026),('1','186','242031','419',588.00,640.00,0.00,2554.00,1501752.00,1534810.00,33058.00,689684),('1','186','242228','419',588.00,640.00,0.00,12723.00,7481124.00,7480520.00,-604.00,690202),('1','186','242431','419',588.00,640.00,0.00,2422.50,1546630.00,1446100.00,-100530.00,690718),('1','186','242724','419',640.00,640.00,0.00,4626.50,2960960.00,2684700.00,-276260.00,691475),('1','186','242970','419',630.00,630.00,0.00,0.00,0.00,0.00,0.00,692118),('1','186','242975','419',630.00,630.00,0.00,7608.00,4321344.00,4429356.00,108012.00,692129),('1','186','243211','419',568.00,630.00,0.00,11717.50,6655540.00,6801325.00,145785.00,692752),('1','186','243432','419',568.00,630.00,0.00,5751.10,3266624.80,3340893.00,74268.20,693331),('1','186','243868','419',568.00,630.00,0.00,0.00,0.00,0.00,0.00,694462),('1','186','243900','419',568.00,630.00,0.00,1130.65,642209.20,653515.70,11306.50,694544),('1','186','243903','419',568.00,630.00,0.00,7413.50,4210868.00,4309605.00,98737.00,694551),('1','186','244095','419',568.00,630.00,0.00,13430.00,7628240.00,7788800.00,160560.00,695039),('1','186','244308','419',568.00,630.00,0.00,2619.35,1487790.80,1517338.30,29547.50,695600),('1','186','244548','419',568.00,630.00,0.00,0.00,0.00,0.00,0.00,696217),('1','186','244558','419',568.00,630.00,0.00,7880.40,4476067.20,4590402.00,114334.80,696241),('1','186','244805','419',568.00,630.00,0.00,16792.60,9538196.80,9735638.80,197442.00,696894),('1','186','245254','419',568.00,630.00,0.00,0.00,0.00,0.00,0.00,698050),('1','186','245261','419',568.00,630.00,0.00,2162.62,1228368.16,1249994.36,21626.20,698064),('1','186','245277','419',568.00,630.00,0.00,15607.50,8865060.00,9059225.00,194165.00,698107),('1','186','245501','419',568.00,630.00,0.00,7024.89,3990137.52,5767888.97,1777751.45,698685),('1','186','246011','419',568.00,630.00,0.00,0.00,0.00,0.00,0.00,700017),('1','186','246030','419',528.00,616.00,0.00,2965.94,1827019.04,1654994.52,-172024.52,700070),('1','186','246055','419',616.00,616.00,0.00,4286.50,2640484.00,2420284.00,-220200.00,700137),('1','186','246251','419',616.00,616.00,0.00,2771.95,1707521.20,1567041.20,-140480.00,700627),('1','186','246512','419',616.00,616.00,0.00,4106.50,2529604.00,2311804.00,-217800.00,701323),('1','186','246763','419',616.00,616.00,0.00,3972.00,2446752.00,2242352.00,-204400.00,701974),('1','186','246994','419',616.00,616.00,0.00,6561.11,4041643.76,3689861.60,-351782.16,702565),('1','186','247362','419',616.00,616.00,0.00,0.00,0.00,0.00,0.00,703541),('1','186','247363','419',616.00,616.00,0.00,2098.50,1259100.00,1149978.00,-109122.00,703542),('1','186','247418','419',600.00,600.00,0.00,11086.00,6651600.00,6099100.00,-552500.00,703654),('1','186','247716','419',600.00,600.00,0.00,5390.50,3234300.00,2977300.00,-257000.00,704440),('1','186','248463','419',600.00,600.00,0.00,5763.00,3457800.00,3166600.00,-291200.00,706356),('1','186','248745','419',600.00,600.00,0.00,0.00,0.00,0.00,0.00,707085),('1','186','248748','419',600.00,600.00,0.00,5969.30,3151790.40,3292980.00,141189.60,707092),('1','186','248913','419',528.00,600.00,0.00,13085.00,7361540.00,7084900.00,-276640.00,707518),('1','186','249145','419',580.00,580.00,0.00,5539.00,3212620.00,2983762.00,-228858.00,708098),('1','186','249362','419',580.00,580.00,0.00,0.00,0.00,0.00,0.00,708670),('1','186','249511','419',580.00,580.00,0.00,7957.00,4201296.00,4305060.00,103764.00,709061),('1','186','249641','419',528.00,580.00,0.00,10034.00,5297952.00,5426342.00,128390.00,709378),('1','186','249891','419',528.00,580.00,0.00,6630.50,3500904.00,3587490.00,86586.00,710022),('1','186','250203','419',528.00,580.00,0.00,0.00,0.00,0.00,0.00,710828),('1','186','250206','419',528.00,580.00,0.00,9068.50,4794568.00,4735730.00,-58838.00,710833),('1','186','250417','419',560.00,560.00,0.00,10060.00,5633600.00,5238600.00,-395000.00,711354),('1','186','250630','419',560.00,560.00,0.00,5535.50,3099880.00,2879880.00,-220000.00,711905),('1','186','250870','419',560.00,560.00,0.00,0.00,0.00,0.00,0.00,712530),('1','186','251103','419',560.00,560.00,0.00,1850.00,952750.00,958300.00,5550.00,713131),('1','186','251109','419',515.00,560.00,0.00,9929.50,5113692.50,5176520.00,62827.50,713146),('1','186','251363','419',515.00,560.00,0.00,8625.00,4441875.00,4500000.00,58125.00,713820),('1','186','251614','419',515.00,560.00,0.00,4248.60,2188029.00,2214152.00,26123.00,714472),('1','186','252089','419',515.00,560.00,0.00,0.00,0.00,0.00,0.00,715714),('1','186','252094','419',515.00,560.00,0.00,1300.00,669500.00,673400.00,3900.00,715725),('1','186','252104','419',515.00,560.00,0.00,10708.00,5514620.00,5583480.00,68860.00,715752),('1','186','252306','419',515.00,560.00,0.00,3155.50,1625082.50,1657080.00,31997.50,716280),('1','186','252495','419',515.00,560.00,0.00,9549.90,5331294.00,4894665.20,-436628.80,716770),('1','186','252811','419',560.00,560.00,0.00,0.00,0.00,0.00,0.00,717586),('1','186','253032','419',490.00,560.00,0.00,3051.18,1495078.20,1549999.44,54921.24,718157),('1','186','253035','419',560.00,560.00,0.00,17258.50,9664760.00,8811260.00,-853500.00,718163),('1','186','253282','419',560.00,560.00,0.00,4281.50,2397640.00,2191140.00,-206500.00,718820),('1','186','253686','419',560.00,560.00,0.00,0.00,0.00,0.00,0.00,719894),('1','186','253689','419',560.00,560.00,0.00,1500.00,735000.00,762000.00,27000.00,719902),('1','186','253772','419',490.00,560.00,0.00,16273.11,9093171.60,8309787.88,-783383.72,720083),('1','186','254025','419',560.00,560.00,0.00,1610.89,902098.40,824353.90,-77744.50,720744),('1','186','254542','419',560.00,560.00,0.00,0.00,0.00,0.00,0.00,722087),('1','186','254544','419',560.00,560.00,0.00,2362.20,1157478.00,1199997.60,42519.60,722089),('1','186','254549','419',490.00,560.00,0.00,2383.50,1167915.00,1212560.00,44645.00,722099),('1','186','254552','419',490.00,560.00,0.00,9372.16,4950004.60,4804159.60,-145845.00,722106),('1','186','254763','419',560.00,560.00,0.00,2925.30,1638168.00,1530418.00,-107750.00,722625),('1','186','255000','419',560.00,560.00,0.00,7212.64,4039078.40,3679703.16,-359375.24,723235),('1','186','255369','419',560.00,560.00,0.00,317.20,177632.00,161137.60,-16494.40,724204),('1','186','255535','419',560.00,560.00,0.00,0.00,0.00,0.00,0.00,724578),('1','186','255540','419',560.00,560.00,0.00,7450.00,4172000.00,3784600.00,-387400.00,724589),('1','186','255550','419',490.00,560.00,0.00,12524.00,6136760.00,6385440.00,248680.00,724612),('1','186','255777','419',490.00,560.00,0.00,4677.00,2291730.00,2381545.00,89815.00,725188),('1','186','255947','419',490.00,560.00,0.00,0.00,0.00,0.00,0.00,725636),('1','186','256125','419',490.00,560.00,0.00,7000.00,3430000.00,3556000.00,126000.00,726089),('1','186','256286','419',490.00,560.00,0.00,12066.00,5912340.00,6163960.00,251620.00,726459),('1','186','256557','419',490.00,560.00,0.00,5558.70,2723763.00,2839762.00,115999.00,727177),('1','186','256775','419',490.00,560.00,0.00,0.00,0.00,0.00,0.00,727728),('1','186','256870','419',490.00,560.00,0.00,4112.50,2015125.00,2095000.00,79875.00,728000),('1','186','257024','419',490.00,560.00,0.00,4170.00,2043300.00,2137100.00,93800.00,728379),('1','186','257310','419',490.00,560.00,0.00,3523.00,1726270.00,1810380.00,84110.00,729130),('1','186','257547','419',490.00,560.00,0.00,13877.80,7771568.00,6975050.00,-796518.00,729750),('1','186','257548','419',560.00,560.00,0.00,0.00,0.00,0.00,0.00,729751),('1','186','257549','419',485.00,560.00,0.00,18733.50,9085747.50,9403940.00,318192.50,729752),('1','186','257550','419',485.00,560.00,0.00,5790.50,2808392.50,2907828.00,99435.50,729753),('1','186','257551','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729754),('1','186','257552','419',485.00,560.00,0.00,19228.00,9325580.00,9659155.00,333575.00,729755),('1','186','257553','419',485.00,560.00,0.00,5414.00,2625790.00,2713453.00,87663.00,729756),('1','186','257554','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729757),('1','186','257555','419',485.00,560.00,0.00,18960.50,9195842.50,9532090.00,336247.50,729758),('1','186','257556','419',485.00,560.00,0.00,5652.50,2741462.50,2843600.00,102137.50,729759),('1','186','257557','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729760),('1','186','257558','419',485.00,560.00,0.00,2550.00,1236750.00,1275000.00,38250.00,729761),('1','186','257559','419',485.00,560.00,0.00,16423.00,7965155.00,8261580.00,296425.00,729762),('1','186','257560','419',485.00,560.00,0.00,5649.70,2740104.50,2840629.40,100524.90,729763),('1','186','257561','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729764),('1','186','257562','419',485.00,560.00,0.00,2019.50,979457.50,1010920.00,31462.50,729765),('1','186','257563','419',485.00,560.00,0.00,15639.50,7585157.50,7844720.00,259562.50,729766),('1','186','257564','419',485.00,560.00,0.00,6782.00,3289270.00,3406970.00,117700.00,729767),('1','186','257565','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729768),('1','186','257566','419',485.00,560.00,0.00,2350.00,1139750.00,1175000.00,35250.00,729769),('1','186','257567','419',485.00,560.00,0.00,17633.60,8552296.00,8866356.00,314060.00,729770),('1','186','257568','419',485.00,560.00,0.00,4564.40,2213734.00,2287500.00,73766.00,729771),('1','186','257569','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729772),('1','186','257570','419',485.00,560.00,0.00,17239.50,8361157.50,8645820.00,284662.50,729773),('1','186','257571','419',485.00,560.00,0.00,7245.00,3513825.00,3631070.00,117245.00,729774),('1','186','257572','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729775),('1','186','257573','419',485.00,560.00,0.00,3030.00,1469550.00,1515000.00,45450.00,729776),('1','186','257574','419',485.00,560.00,0.00,16798.70,8147369.50,8442972.00,295602.50,729777),('1','186','257575','419',485.00,560.00,0.00,4749.00,2303265.00,2407436.00,104171.00,729778),('1','186','257576','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729779),('1','186','257577','419',485.00,560.00,0.00,3706.40,1797604.00,2396584.00,598980.00,729780),('1','186','257578','419',485.00,560.00,0.00,4097.00,1987045.00,2070820.00,83775.00,729781),('1','186','257579','419',485.00,560.00,0.00,3130.00,1518050.00,1572800.00,54750.00,729782),('1','186','257580','419',485.00,560.00,0.00,10351.30,5020380.50,5217228.00,196847.50,729783),('1','186','257581','419',485.00,560.00,0.00,3249.00,1575765.00,1639680.00,63915.00,729784),('1','186','257582','419',485.00,560.00,0.00,0.00,0.00,0.00,0.00,729785),('1','186','257583','419',485.00,560.00,0.00,1182.50,600710.00,620600.00,19890.00,729786),('1','186','257584','419',508.00,560.00,0.00,15601.71,8797488.44,8175743.54,-621744.90,729787),('1','186','257585','419',564.00,564.00,0.00,7702.86,4344413.04,4040845.92,-303567.12,729788),('1','186','257586','419',564.00,564.00,0.00,0.00,0.00,0.00,0.00,729789),('1','186','257587','419',508.00,564.00,0.00,4450.00,2260600.00,2327100.00,66500.00,729790),('1','186','257588','419',508.00,564.00,0.00,6557.50,3331210.00,3451630.00,120420.00,729791),('1','186','257589','419',508.00,564.00,0.00,13314.43,6763730.44,6980627.46,216897.02,729792),('1','186','257590','419',508.00,564.00,0.00,0.00,0.00,0.00,0.00,729793),('1','186','257591','419',508.00,564.00,0.00,3250.00,1651000.00,1696500.00,45500.00,729794),('1','186','257592','419',508.00,564.00,0.00,15830.28,8041782.24,8300377.92,258595.68,729795),('1','186','257593','419',508.00,564.00,0.00,5432.80,2759862.40,2855491.20,95628.80,729796),('1','186','257594','419',508.00,564.00,0.00,0.00,0.00,0.00,0.00,729797),('1','186','257595','419',508.00,564.00,0.00,3093.65,1571574.20,1618818.60,47244.40,729798),('1','186','257596','419',508.00,564.00,0.00,13535.00,6875780.00,7110440.00,234660.00,729799),('1','186','257597','419',508.00,564.00,0.00,7649.05,3885717.40,4001864.20,116146.80,729800),('1','186','257598','419',508.00,564.00,0.00,18.00,9144.00,9432.00,288.00,729801),('1','186','257599','419',508.00,564.00,0.00,0.00,0.00,0.00,0.00,729802),('1','186','257600','419',560.00,620.00,0.00,2296.50,1286040.00,1303830.00,17790.00,729803),('1','186','257601','419',560.00,620.00,0.00,2367.00,1325520.00,1361540.00,36020.00,729804),('1','186','257602','419',560.00,620.00,0.00,16746.00,9377760.00,9714534.00,336774.00,729805),('1','186','257603','419',560.00,620.00,0.00,3253.50,1821960.00,1888870.00,66910.00,729806),('1','186','257604','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729807),('1','186','257605','419',560.00,620.00,0.00,7015.48,3928668.80,4057354.04,128685.24,729808),('1','186','257606','419',560.00,620.00,0.00,1512.50,847000.00,905750.00,58750.00,729809),('1','186','257607','419',560.00,620.00,0.00,4833.50,2706760.00,2814770.00,108010.00,729810),('1','186','257608','419',560.00,620.00,0.00,6283.52,3518771.20,3647182.40,128411.20,729811),('1','186','257609','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729812),('1','186','257610','419',560.00,620.00,0.00,700.00,392000.00,404600.00,12600.00,729813),('1','186','257611','419',560.00,620.00,0.00,13047.00,8054490.00,7525540.00,-528950.00,729814),('1','186','257612','419',620.00,620.00,0.00,5355.00,3320100.00,3109500.00,-210600.00,729815),('1','186','257613','419',620.00,620.00,0.00,5563.00,3449060.00,3206288.00,-242772.00,729816),('1','186','257614','419',620.00,620.00,0.00,0.00,0.00,0.00,0.00,729817),('1','186','257615','419',560.00,620.00,0.00,11217.00,6281520.00,6478540.00,197020.00,729818),('1','186','257616','419',560.00,620.00,0.00,10160.50,5689880.00,5862910.00,173030.00,729819),('1','186','257617','419',560.00,620.00,0.00,2846.50,1594040.00,1637444.00,43404.00,729820),('1','186','257618','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729821),('1','186','257619','419',560.00,620.00,0.00,17553.50,10247960.00,10104570.00,-143390.00,729822),('1','186','257620','419',620.00,620.00,0.00,260.50,171930.00,163930.00,-8000.00,729823),('1','186','257621','419',660.00,660.00,0.00,1213.60,800976.00,784976.00,-16000.00,729824),('1','186','257622','419',660.00,660.00,0.00,1156.20,763092.00,745092.00,-18000.00,729825),('1','186','257623','419',660.00,660.00,0.00,967.60,638616.00,620616.00,-18000.00,729826),('1','186','257624','419',660.00,660.00,0.00,3442.60,2134412.00,1998978.80,-135433.20,729827),('1','186','257625','419',620.00,620.00,0.00,0.00,0.00,0.00,0.00,729828),('1','186','257626','419',560.00,620.00,0.00,11563.30,6475448.00,6732146.00,256698.00,729829),('1','186','257627','419',560.00,620.00,0.00,13049.70,7307832.00,7561814.00,253982.00,729830),('1','186','257628','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729831),('1','186','257629','419',560.00,620.00,0.00,17226.30,9646728.00,9985706.00,338978.00,729832),('1','186','257630','419',560.00,620.00,0.00,5684.50,3183320.00,3302390.00,119070.00,729833),('1','186','257631','419',560.00,620.00,0.00,1483.20,830592.00,867584.00,36992.00,729834),('1','186','257632','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729835),('1','186','257633','419',560.00,620.00,0.00,1862.30,1042888.00,1076409.40,33521.40,729836),('1','186','257634','419',560.00,620.00,0.00,18424.50,10317720.00,10686190.00,368470.00,729837),('1','186','257635','419',560.00,620.00,0.00,3486.60,1952496.00,2022368.00,69872.00,729838),('1','186','257636','419',560.00,620.00,0.00,500.00,280000.00,289000.00,9000.00,729839),('1','186','257637','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729840),('1','186','257638','419',560.00,620.00,0.00,1389.29,778002.40,803009.62,25007.22,729841),('1','186','257639','419',560.00,620.00,0.00,18051.50,10108840.00,10472110.00,363270.00,729842),('1','186','257640','419',560.00,620.00,0.00,4981.21,2789477.60,2892629.38,103151.78,729843),('1','186','257641','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729844),('1','186','257642','419',560.00,620.00,0.00,355.74,199214.40,205617.72,6403.32,729845),('1','186','257643','419',560.00,620.00,0.00,18045.00,10105200.00,10469100.00,363900.00,729846),('1','186','257644','419',560.00,620.00,0.00,6235.90,3492104.00,3618032.20,125928.20,729847),('1','186','257645','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729848),('1','186','257646','419',560.00,620.00,0.00,2857.50,1600200.00,1665650.00,65450.00,729849),('1','186','257647','419',560.00,620.00,0.00,16916.00,9472960.00,9811820.00,338860.00,729850),('1','186','257648','419',560.00,620.00,0.00,4907.50,2748200.00,2847750.00,99550.00,729851),('1','186','257649','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729852),('1','186','257650','419',560.00,620.00,0.00,807.07,451959.20,473498.60,21539.40,729853),('1','186','257651','419',560.00,620.00,0.00,11424.70,6397832.00,6640404.00,242572.00,729854),('1','186','257652','419',560.00,620.00,0.00,10958.60,6136816.00,6373232.00,236416.00,729855),('1','186','257653','419',560.00,620.00,0.00,1301.63,728912.80,758145.40,29232.60,729856),('1','186','257654','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729857),('1','186','257655','419',560.00,620.00,0.00,2407.50,1348200.00,1407050.00,58850.00,729858),('1','186','257656','419',560.00,620.00,0.00,19318.50,10818360.00,11206170.00,387810.00,729859),('1','186','257657','419',560.00,620.00,0.00,2968.00,1662080.00,1742025.00,79945.00,729860),('1','186','257658','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729861),('1','186','257659','419',560.00,620.00,0.00,15579.30,8724408.00,9042120.00,317712.00,729862),('1','186','257660','419',560.00,620.00,0.00,3247.70,1818712.00,1891674.00,72962.00,729863),('1','186','257661','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729864),('1','186','257662','419',560.00,620.00,0.00,13883.60,7774816.00,8064932.00,290116.00,729865),('1','186','257663','419',560.00,620.00,0.00,10828.30,6063848.00,6296747.40,232899.40,729866),('1','186','257664','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729867),('1','186','257665','419',560.00,620.00,0.00,2405.60,1347136.00,1402972.00,55836.00,729868),('1','186','257666','419',560.00,620.00,0.00,20566.50,11517240.00,11925030.00,407790.00,729869),('1','186','257667','419',560.00,620.00,0.00,1651.90,925064.00,958382.00,33318.00,729870),('1','186','257668','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729871),('1','186','257669','419',560.00,620.00,0.00,2434.50,1363320.00,1422490.00,59170.00,729872),('1','186','257670','419',560.00,620.00,0.00,18009.80,10085488.00,10447636.00,362148.00,729873),('1','186','257671','419',560.00,620.00,0.00,4166.70,2333352.00,2417434.00,84082.00,729874),('1','186','257672','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729875),('1','186','257673','419',560.00,620.00,0.00,18837.00,10548720.00,10927940.00,379220.00,729876),('1','186','257674','419',560.00,620.00,0.00,5938.90,3325784.00,3497007.20,171223.20,729877),('1','186','257675','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729878),('1','186','257676','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729879),('1','186','257677','419',560.00,620.00,0.00,3181.35,1781556.00,1895037.00,113481.00,729880),('1','186','257678','419',560.00,620.00,0.00,10912.29,6110882.40,6423263.40,312381.00,729881),('1','186','257679','419',560.00,620.00,0.00,8423.44,4717126.40,4990492.80,273366.40,729882),('1','186','257680','419',560.00,620.00,0.00,2148.48,1203148.80,1260257.60,57108.80,729883),('1','186','257681','419',560.00,620.00,0.00,0.00,0.00,0.00,0.00,729884),('1','186','257682','419',607.00,680.00,0.00,4048.71,2457566.97,2636474.80,178907.83,729885),('1','186','257683','419',607.00,680.00,0.00,4588.61,2785286.27,3002549.80,217263.53,729886),('1','186','257684','419',607.00,680.00,0.00,3414.70,2072722.90,2233534.64,160811.74,729887),('1','186','257685','419',607.00,680.00,0.00,6799.17,4127096.19,4380158.10,253061.91,729888),('1','186','257686','419',607.00,680.00,0.00,5641.63,3424469.41,3565905.40,141435.99,729889),('1','186','257687','419',607.00,680.00,0.00,0.00,0.00,0.00,0.00,729890),('1','186','257688','419',597.00,680.00,0.00,13317.39,7950481.83,8260464.10,309982.27,729891),('1','186','257689','419',597.00,680.00,0.00,11448.85,6834963.45,7064397.90,229434.45,729892),('1','186','257690','419',597.00,680.00,0.00,0.00,0.00,0.00,0.00,729893),('1','186','257691','419',632.00,700.00,0.00,9121.52,5764800.64,6060506.33,295705.69,729894),('1','186','257692','419',632.00,700.00,0.00,6825.49,4313709.68,4569840.39,256130.71,729895),('1','186','257693','419',632.00,700.00,0.00,8609.33,5441096.56,5707861.05,266764.49,729896),('1','186','257694','419',632.00,700.00,0.00,0.00,0.00,0.00,0.00,729897),('1','186','257695','419',622.00,680.00,0.00,7026.96,4370769.12,4495500.80,124731.68,729898),('1','186','257696','419',622.00,680.00,0.00,12905.32,8027109.04,8267487.56,240378.52,729899),('1','186','257697','419',622.00,680.00,0.00,4557.06,2834491.32,2913222.00,78730.68,729900),('1','186','257698','419',622.00,680.00,0.00,0.00,0.00,0.00,0.00,729901),('1','186','257699','419',632.00,720.00,0.00,15592.20,9854270.40,10253749.60,399479.20,729902),('1','186','257700','419',632.00,720.00,0.00,8735.62,5520911.84,5770938.80,250026.96,729903),('1','186','257701','419',632.00,720.00,0.00,0.00,0.00,0.00,0.00,729904),('1','186','257702','419',652.00,740.00,0.00,8228.13,5364740.76,5642656.20,277915.44,729905),('1','186','257703','419',652.00,740.00,0.00,7776.26,5070121.52,5415345.60,345224.08,729906),('1','186','257704','419',652.00,740.00,0.00,3720.31,2425642.12,2565787.80,140145.68,729907),('1','186','257705','419',652.00,740.00,0.00,0.00,0.00,0.00,0.00,729908),('1','186','257706','419',652.00,740.00,0.00,7617.56,4966649.12,5221418.85,254769.73,729909),('1','186','257707','419',652.00,740.00,0.00,10936.67,7130708.84,7514825.60,384116.76,729910),('1','186','257708','419',652.00,740.00,0.00,6071.16,3958396.32,4146066.70,187670.38,729911),('1','186','257709','419',652.00,740.00,0.00,0.00,0.00,0.00,0.00,729912),('1','186','257710','419',652.00,740.00,0.00,2557.37,1667405.24,1772028.30,104623.06,729913),('1','186','257711','419',652.00,780.00,0.00,1758.17,1146326.84,1277052.60,130725.76,729914),('1','186','257712','419',652.00,780.00,0.00,11143.49,7265555.48,7892369.20,626813.72,729915),('1','186','257713','419',652.00,780.00,0.00,9244.65,6027511.80,6548321.70,520809.90,729916),('1','186','257714','419',652.00,780.00,0.00,0.00,0.00,0.00,0.00,729917),('1','186','257715','419',652.00,750.00,0.00,5194.23,3386637.96,3650512.50,263874.54,729918),('1','186','257716','419',652.00,750.00,0.00,11437.08,7456976.16,8009306.40,552330.24,729919),('1','186','257717','419',652.00,750.00,0.00,6932.83,4520205.16,4906523.10,386317.94,729920),('1','186','257718','419',652.00,750.00,0.00,0.00,0.00,0.00,0.00,729921),('1','186','257719','419',652.00,750.00,0.00,6283.25,4096679.00,4375863.14,279184.14,729922),('1','186','257720','419',652.00,750.00,0.00,9195.10,5995205.20,6396926.72,401721.52,729923),('1','186','257721','419',652.00,750.00,0.00,6715.55,4378538.60,4675499.10,296960.50,729924),('1','186','257722','419',652.00,750.00,0.00,2278.97,1485888.44,1549607.74,63719.30,729925),('1','186','257723','419',652.00,750.00,0.00,0.00,0.00,0.00,0.00,729926),('1','186','257724','419',652.00,750.00,0.00,3799.27,2477124.04,2636115.18,158991.14,729927),('1','186','257725','419',652.00,750.00,0.00,9512.36,6202058.72,6544310.88,342252.16,729928),('1','186','257726','419',652.00,750.00,0.00,11261.18,7342289.36,7722266.12,379976.76,729929),('1','186','257727','419',652.00,750.00,0.00,0.00,0.00,0.00,0.00,729930),('1','186','257728','419',652.00,750.00,0.00,5290.42,3449353.84,3672061.00,222707.16,729931),('1','186','257729','419',652.00,750.00,0.00,8356.50,5448438.00,5791197.00,342759.00,729932),('1','186','257730','419',652.00,750.00,0.00,6976.10,4548417.20,4877354.88,328937.68,729933),('1','186','257731','419',652.00,750.00,0.00,4133.39,2694970.28,2868401.34,173431.06,729934),('1','186','257732','419',652.00,750.00,0.00,36.71,23934.92,25187.14,1252.22,729935),('1','186','257733','419',652.00,750.00,0.00,19.98,13026.96,14985.00,1958.04,729936),('1','186','257734','419',652.00,750.00,0.00,0.00,0.00,0.00,0.00,729937),('1','186','257735','419',652.00,750.00,0.00,3830.18,2497277.36,2629815.00,132537.64,729938),('1','186','257736','419',652.00,750.00,0.00,10183.36,6639550.72,7030571.64,391020.92,729939),('1','186','257737','419',652.00,750.00,0.00,7881.30,5138607.60,5476566.24,337958.64,729940),('1','186','257738','419',652.00,750.00,0.00,2730.07,1780005.64,1885132.90,105127.26,729941),('1','186','257739','419',652.00,750.00,0.00,0.00,0.00,0.00,0.00,729942),('1','186','257740','419',652.00,728.00,0.00,5281.88,3443785.76,3619818.04,176032.28,729943),('1','186','257741','419',652.00,728.00,0.00,10951.11,7140123.72,7493060.28,352936.56,729944),('1','186','257742','419',652.00,728.00,0.00,8273.43,5394276.36,5666477.04,272200.68,729945),('1','186','257743','419',652.00,728.00,0.00,0.00,0.00,0.00,0.00,729946),('1','186','257744','419',652.00,730.00,0.00,11486.24,7489028.48,7819068.62,330040.14,729947),('1','186','257745','419',652.00,730.00,0.00,7784.66,5075598.32,5353853.98,278255.66,729948),('1','186','257746','419',652.00,730.00,0.00,5437.46,3545223.92,3684462.00,139238.08,729949),('1','186','257747','419',652.00,730.00,0.00,0.00,0.00,0.00,0.00,729950),('1','186','257748','419',652.00,730.00,0.00,3867.07,2521329.64,2665754.52,144424.88,729951),('1','186','257749','419',652.00,730.00,0.00,13175.73,8590575.96,8936973.38,346397.42,729952),('1','186','257750','419',652.00,730.00,0.00,6730.41,4388227.32,4625355.00,237127.68,729953),('1','186','257751','419',652.00,730.00,0.00,931.28,607194.56,664477.62,57283.06,729954),('1','186','257752','419',652.00,730.00,0.00,0.00,0.00,0.00,0.00,729955),('1','186','257753','419',652.00,730.00,0.00,11462.78,7473732.56,7789330.34,315597.78,729956),('1','186','257754','419',652.00,730.00,0.00,9538.64,6219193.28,6458563.78,239370.50,729957),('1','186','257755','419',652.00,730.00,0.00,3575.04,2330926.08,2433455.54,102529.46,729958),('1','186','257756','419',652.00,730.00,0.00,0.00,0.00,0.00,0.00,729959),('1','186','257757','419',652.00,730.00,0.00,7443.14,4852927.28,5085085.06,232157.78,729960),('1','186','257758','419',652.00,730.00,0.00,13314.29,8680917.08,9041895.70,360978.62,729961),('1','186','257759','419',652.00,730.00,0.00,3774.26,2460817.52,2560342.56,99525.04,729962),('1','186','257760','419',652.00,730.00,0.00,0.00,0.00,0.00,0.00,729963),('1','186','257761','419',652.00,730.00,0.00,6530.84,4258107.68,4442623.28,184515.60,729964),('1','186','257762','419',652.00,730.00,0.00,6905.94,4502672.88,4745758.64,243085.76,729965),('1','186','257763','419',652.00,730.00,0.00,5853.94,3816768.88,4031266.20,214497.32,729966),('1','186','257764','419',652.00,730.00,0.00,5321.96,3469917.92,3624010.80,154092.88,729967),('1','186','257765','419',652.00,730.00,0.00,0.00,0.00,0.00,0.00,729968),('1','186','257766','419',645.00,730.00,0.00,6893.96,4446604.20,4711743.70,265139.50,729969),('1','186','257767','419',645.00,730.00,0.00,7512.33,4845452.85,5106124.90,260672.05,729970),('1','186','257768','419',645.00,730.00,0.00,6813.91,4394971.95,4665174.30,270202.35,729971),('1','186','257769','419',645.00,730.00,0.00,3340.03,2154319.35,2263875.90,109556.55,729972),('1','186','257770','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,729973),('1','186','257771','419',645.00,730.00,0.00,10657.89,6874339.05,7197140.60,322801.55,729974),('1','186','257772','419',645.00,730.00,0.00,7854.41,5066094.45,5340848.50,274754.05,729975),('1','186','257773','419',645.00,730.00,0.00,6189.19,3992027.55,4244268.70,252241.15,729976),('1','186','257774','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,729977),('1','186','257775','419',645.00,730.00,0.00,3959.61,2553948.45,2739722.70,185774.25,729978),('1','186','257776','419',645.00,730.00,0.00,6340.25,4089461.25,4354665.70,265204.45,729979),('1','186','257777','419',645.00,730.00,0.00,7806.99,5035508.55,5312552.40,277043.85,729980),('1','186','257778','419',645.00,730.00,0.00,6826.06,4402808.70,4570367.80,167559.10,729981),('1','186','257779','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,729982),('1','186','257780','419',645.00,730.00,0.00,3743.36,2414467.20,2538264.90,123797.70,729983),('1','186','257781','419',645.00,730.00,0.00,13651.80,8805411.00,9193451.90,388040.90,729984),('1','186','257782','419',645.00,730.00,0.00,7308.74,4714137.30,4939794.10,225656.80,729985),('1','186','257783','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,729986),('1','186','257784','419',645.00,712.00,0.00,11248.73,7255430.85,7528005.84,272574.99,729987),('1','186','257785','419',645.00,712.00,0.00,13235.19,8536697.55,8820485.84,283788.29,729988),('1','186','257786','419',645.00,712.00,0.00,98.65,63629.25,65109.00,1479.75,729989),('1','186','257787','419',645.00,712.00,0.00,0.00,0.00,0.00,0.00,729990),('1','186','257788','419',645.00,712.00,0.00,12280.23,7920748.35,8184973.08,264224.73,729991),('1','186','257789','419',645.00,712.00,0.00,13012.90,8393320.50,8759912.08,366591.58,729992),('1','186','257790','419',645.00,712.00,0.00,0.00,0.00,0.00,0.00,729993),('1','186','257791','419',655.00,730.00,0.00,2096.23,1373030.65,1396089.18,23058.53,729994),('1','186','257792','419',655.00,730.00,0.00,13795.03,9035744.65,9409920.94,374176.29,729995),('1','186','257793','419',655.00,730.00,0.00,8728.99,5717488.45,5974749.18,257260.73,729996),('1','186','257794','419',655.00,730.00,0.00,0.00,0.00,0.00,0.00,729997),('1','186','257795','419',655.00,730.00,0.00,7682.26,5031880.30,5311468.92,279588.62,729998),('1','186','257796','419',655.00,730.00,0.00,8843.09,5792223.95,6068225.78,276001.83,729999),('1','186','257797','419',655.00,730.00,0.00,7236.49,4739900.95,5037340.90,297439.95,730000),('1','186','257798','419',655.00,730.00,0.00,1018.78,667300.90,693583.58,26282.68,730001),('1','186','257799','419',655.00,730.00,0.00,0.00,0.00,0.00,0.00,730002),('1','186','257800','419',655.00,730.00,0.00,9889.38,6477543.90,6792136.34,314592.44,730003),('1','186','257801','419',655.00,730.00,0.00,7235.51,4739259.05,5003662.22,264403.17,730004),('1','186','257802','419',655.00,730.00,0.00,7450.20,4879881.00,5163238.00,283357.00,730005),('1','186','257803','419',655.00,730.00,0.00,0.00,0.00,0.00,0.00,730006),('1','186','257804','419',655.00,730.00,0.00,6.15,4028.25,4489.50,461.25,730007),('1','186','257805','419',655.00,730.00,0.00,5458.53,3575337.15,3753614.90,178277.75,730008),('1','186','257806','419',655.00,730.00,0.00,13586.08,8898882.40,9289377.60,390495.20,730009),('1','186','257807','419',655.00,730.00,0.00,5765.71,3776540.05,3975631.42,199091.37,730010),('1','186','257808','419',655.00,730.00,0.00,0.00,0.00,0.00,0.00,730011),('1','186','257809','419',650.00,730.00,0.00,7224.77,4696100.50,5027456.42,331355.92,730012),('1','186','257810','419',650.00,730.00,0.00,7077.90,4600635.00,4923647.24,323012.24,730013),('1','186','257811','419',650.00,730.00,0.00,4717.98,3066687.00,3305055.56,238368.56,730014),('1','186','257812','419',650.00,730.00,0.00,5739.30,3730545.00,3998561.00,268016.00,730015),('1','186','257813','419',650.00,730.00,0.00,0.00,0.00,0.00,0.00,730016),('1','186','257814','419',640.00,730.00,0.00,10767.19,6891001.60,7263666.20,372664.60,730017),('1','186','257815','419',640.00,730.00,0.00,8647.13,5534163.20,5850419.90,316256.70,730018),('1','186','257816','419',640.00,730.00,0.00,5056.41,3236102.40,3440362.30,204259.90,730019),('1','186','257817','419',640.00,730.00,0.00,0.00,0.00,0.00,0.00,730020),('1','186','257818','419',640.00,730.00,0.00,1823.93,1167315.20,1238508.90,71193.70,730021),('1','186','257819','419',640.00,730.00,0.00,7715.21,4937734.40,5260123.30,322388.90,730022),('1','186','257820','419',640.00,730.00,0.00,9647.18,6174195.20,6547740.20,373545.00,730023),('1','186','257821','419',640.00,730.00,0.00,5394.67,3452588.80,3696126.80,243538.00,730024),('1','186','257822','419',640.00,730.00,0.00,0.00,0.00,0.00,0.00,730025),('1','186','257823','419',640.00,730.00,0.00,8092.41,5179142.40,5495253.10,316110.70,730026),('1','186','257824','419',640.00,730.00,0.00,6492.62,4155276.80,4443378.20,288101.40,730027),('1','186','257825','419',640.00,730.00,0.00,9929.24,6354713.60,6721935.20,367221.60,730028),('1','186','257826','419',640.00,730.00,0.00,103.06,65958.40,69179.70,3221.30,730029),('1','186','257827','419',640.00,730.00,0.00,0.00,0.00,0.00,0.00,730030),('1','186','257828','419',635.00,720.00,0.00,9451.38,6001626.30,6329984.80,328358.50,730031),('1','186','257829','419',635.00,720.00,0.00,10193.80,6473063.00,6864266.32,391203.32,730032),('1','186','257830','419',635.00,720.00,0.00,4950.65,3143662.75,3347844.48,204181.73,730033),('1','186','257831','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730034),('1','186','257832','419',635.00,720.00,0.00,9623.55,6110954.25,6487024.00,376069.75,730035),('1','186','257833','419',635.00,720.00,0.00,10621.14,6744423.90,7091291.48,346867.58,730036),('1','186','257834','419',635.00,720.00,0.00,4601.75,2922111.25,3065990.00,143878.75,730037),('1','186','257835','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730038),('1','186','257836','419',635.00,720.00,0.00,7162.67,4548295.45,4795460.92,247165.47,730039),('1','186','257837','419',635.00,720.00,0.00,10229.12,6495491.20,6829707.08,334215.88,730040),('1','186','257838','419',635.00,720.00,0.00,6248.17,3967587.95,4224982.40,257394.45,730041),('1','186','257839','419',635.00,720.00,0.00,1258.97,799445.95,868810.88,69364.93,730042),('1','186','257840','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730043),('1','186','257841','419',635.00,720.00,0.00,4997.12,3173171.20,3367836.84,194665.64,730044),('1','186','257842','419',635.00,720.00,0.00,8271.56,5252440.60,5577167.80,324727.20,730045),('1','186','257843','419',635.00,720.00,0.00,8105.96,5147284.60,5468683.20,321398.60,730046),('1','186','257844','419',635.00,720.00,0.00,3311.41,2102745.35,2223395.20,120649.85,730047),('1','186','257845','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730048),('1','186','257846','419',635.00,720.00,0.00,9041.27,5741206.45,5966758.40,225551.95,730049),('1','186','257847','419',635.00,720.00,0.00,6885.73,4372438.55,4625171.60,252733.05,730050),('1','186','257848','419',635.00,720.00,0.00,7434.36,4720818.60,5005337.92,284519.32,730051),('1','186','257849','419',635.00,720.00,0.00,1431.16,908786.60,968419.20,59632.60,730052),('1','186','257850','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730053),('1','186','257851','419',635.00,720.00,0.00,10438.02,6628142.70,6952687.60,324544.90,730054),('1','186','257852','419',635.00,720.00,0.00,12911.32,8198688.20,8567533.04,368844.84,730055),('1','186','257853','419',635.00,720.00,0.00,1578.43,1002303.05,1102197.60,99894.55,730056),('1','186','257854','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730057),('1','186','257855','419',635.00,720.00,0.00,5436.17,3451967.95,3634187.40,182219.45,730058),('1','186','257856','419',635.00,720.00,0.00,9892.65,6281832.75,6615616.12,333783.37,730059),('1','186','257857','419',635.00,720.00,0.00,5991.96,3804894.60,4061380.40,256485.80,730060),('1','186','257858','419',635.00,720.00,0.00,3301.71,2096585.85,2221443.20,124857.35,730061),('1','186','257859','419',635.00,720.00,0.00,0.00,0.00,0.00,0.00,730062),('1','186','257860','419',625.00,700.00,0.00,2872.53,1795331.25,1929702.48,134371.23,730063),('1','186','257861','419',625.00,700.00,0.00,9184.41,5740256.25,6078626.84,338370.59,730064),('1','186','257862','419',625.00,700.00,0.00,5523.22,3452012.50,3703493.48,251480.98,730065),('1','186','257863','419',625.00,700.00,0.00,6992.74,4370462.50,4598859.68,228397.18,730066),('1','186','257864','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730067),('1','186','257865','419',625.00,700.00,0.00,1403.68,877300.00,949972.00,72672.00,730068),('1','186','257866','419',625.00,700.00,0.00,8706.13,5441331.25,5766047.00,324715.75,730069),('1','186','257867','419',625.00,700.00,0.00,6697.43,4185893.75,4471423.92,285530.17,730070),('1','186','257868','419',625.00,700.00,0.00,6823.14,4264462.50,4539292.00,274829.50,730071),('1','186','257869','419',625.00,700.00,0.00,171.56,107225.00,112292.00,5067.00,730072),('1','186','257870','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730073),('1','186','257871','419',625.00,700.00,0.00,8315.06,5196912.50,5526272.28,329359.78,730074),('1','186','257872','419',625.00,700.00,0.00,8742.80,5464250.00,5822078.00,357828.00,730075),('1','186','257873','419',625.00,700.00,0.00,7099.93,4437456.25,4750667.00,313210.75,730076),('1','186','257874','419',625.00,700.00,0.00,523.34,327087.50,366338.00,39250.50,730077),('1','186','257875','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730078),('1','186','257876','419',625.00,700.00,0.00,9237.25,5773281.25,6054664.80,281383.55,730079),('1','186','257877','419',625.00,700.00,0.00,10689.54,6680962.50,6973930.20,292967.70,730080),('1','186','257878','419',625.00,700.00,0.00,4208.86,2630537.50,2817419.80,186882.30,730081),('1','186','257879','419',625.00,700.00,0.00,141.34,88337.50,92938.00,4600.50,730082),('1','186','257880','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730083),('1','186','257881','419',625.00,700.00,0.00,6023.80,3764875.00,3933070.00,168195.00,730084),('1','186','257882','419',625.00,700.00,0.00,10404.32,6502700.00,6830317.80,327617.80,730085),('1','186','257883','419',625.00,700.00,0.00,7178.84,4486775.00,4763943.20,277168.20,730086),('1','186','257884','419',625.00,700.00,0.00,597.73,373581.25,392182.60,18601.35,730087),('1','186','257885','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730088),('1','186','257886','419',625.00,700.00,0.00,10471.71,6544818.75,6813828.00,269009.25,730089),('1','186','257887','419',625.00,700.00,0.00,13983.30,8739562.50,9055736.00,316173.50,730090),('1','186','257888','419',625.00,700.00,0.00,86.26,53912.50,55206.40,1293.90,730091),('1','186','257889','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730092),('1','186','257890','419',625.00,700.00,0.00,10900.52,6812825.00,7084533.80,271708.80,730093),('1','186','257891','419',625.00,700.00,0.00,11291.29,7057056.25,7395232.60,338176.35,730094),('1','186','257892','419',625.00,700.00,0.00,2747.47,1717168.75,1923229.00,206060.25,730095),('1','186','257893','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730096),('1','186','257894','419',625.00,700.00,0.00,13461.10,8413187.50,8722613.20,309425.70,730097),('1','186','257895','419',625.00,700.00,0.00,5814.96,3634350.00,3858907.36,224557.36,730098),('1','186','257896','419',625.00,700.00,0.00,0.00,0.00,0.00,0.00,730099),('1','186','257897','419',625.00,720.00,0.00,13884.75,8677968.75,9204589.90,526621.15,730100),('1','186','257898','419',625.00,720.00,0.00,8911.39,5569618.75,6027651.80,458033.05,730101),('1','186','257899','419',625.00,720.00,0.00,1575.99,984993.75,1071677.10,86683.35,730102),('1','186','257900','419',625.00,720.00,0.00,0.00,0.00,0.00,0.00,730103),('1','186','257901','419',625.00,720.00,0.00,4359.44,2724650.00,2990278.50,265628.50,730104),('1','186','257902','419',625.00,720.00,0.00,10889.71,6806068.75,7295799.40,489730.65,730105),('1','186','257903','419',625.00,720.00,0.00,7390.46,4619037.50,5014466.10,395428.60,730106),('1','186','257904','419',625.00,720.00,0.00,1818.40,1136500.00,1255275.36,118775.36,730107),('1','186','257905','419',625.00,720.00,0.00,0.00,0.00,0.00,0.00,730108),('1','186','257906','419',645.00,730.00,0.00,4643.53,2995076.85,3157385.00,162308.15,730109),('1','186','257907','419',645.00,730.00,0.00,12645.21,8156160.45,8530458.40,374297.95,730110),('1','186','257908','419',645.00,730.00,0.00,6789.06,4378943.70,4661509.80,282566.10,730111),('1','186','257909','419',645.00,730.00,0.00,354.64,228742.80,238935.10,10192.30,730112),('1','186','257910','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730113),('1','186','257911','419',645.00,730.00,0.00,6705.86,4325279.70,4586780.10,261500.40,730114),('1','186','257912','419',645.00,730.00,0.00,7046.26,4544837.70,4841511.20,296673.50,730115),('1','186','257913','419',645.00,730.00,0.00,9642.03,6219109.35,6548884.90,329775.55,730116),('1','186','257914','419',645.00,730.00,0.00,792.98,511472.10,547447.50,35975.40,730117),('1','186','257915','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730118),('1','186','257916','419',645.00,730.00,0.00,7483.17,4826644.65,5050338.10,223693.45,730119),('1','186','257917','419',645.00,730.00,0.00,11012.10,7102804.50,7463637.00,360832.50,730120),('1','186','257918','419',645.00,730.00,0.00,583.52,376370.40,425969.60,49599.20,730121),('1','186','257919','419',645.00,730.00,0.00,43.02,27747.90,30591.20,2843.30,730122),('1','186','257920','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730123),('1','186','257921','419',645.00,730.00,0.00,7534.75,4859913.75,5106115.40,246201.65,730124),('1','186','257922','419',645.00,730.00,0.00,7780.52,5018435.40,5314586.10,296150.70,730125),('1','186','257923','419',645.00,730.00,0.00,8618.41,5558874.45,5882147.40,323272.95,730126),('1','186','257924','419',645.00,730.00,0.00,621.17,400654.65,453454.10,52799.45,730127),('1','186','257925','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730128),('1','186','257926','419',645.00,730.00,0.00,6004.32,3872786.40,4055433.60,182647.20,730129),('1','186','257927','419',645.00,730.00,0.00,8124.88,5240547.60,5510602.40,270054.80,730130),('1','186','257928','419',645.00,730.00,0.00,7764.05,5007812.25,5282036.50,274224.25,730131),('1','186','257929','419',645.00,730.00,0.00,2655.73,1712945.85,1797236.70,84290.85,730132),('1','186','257930','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730133),('1','186','257931','419',645.00,730.00,0.00,3533.18,2278901.10,2429771.40,150870.30,730134),('1','186','257932','419',645.00,730.00,0.00,5816.36,3751552.20,3995514.30,243962.10,730135),('1','186','257933','419',645.00,730.00,0.00,8734.21,5633565.45,5920137.00,286571.55,730136),('1','186','257934','419',645.00,730.00,0.00,1020.49,658216.05,690921.20,32705.15,730137),('1','186','257935','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730138),('1','186','257936','419',645.00,730.00,0.00,6148.31,3965659.95,4167413.90,201753.95,730139),('1','186','257937','419',645.00,730.00,0.00,8714.90,5621110.50,5903704.40,282593.90,730140),('1','186','257938','419',645.00,730.00,0.00,4464.79,2879789.55,3048865.20,169075.65,730141),('1','186','257939','419',645.00,730.00,0.00,0.00,0.00,0.00,0.00,730142),('1','186','257940','419',640.00,730.00,0.00,6342.39,4059129.60,4282616.80,223487.20,730143),('1','186','257941','419',640.00,720.00,0.00,5274.43,3375635.20,3614124.60,238489.40,730144),('1','186','257942','419',640.00,720.00,0.00,6230.60,3987584.00,4245240.60,257656.60,730145),('1','186','257943','419',640.00,720.00,0.00,1941.94,1242841.60,1393696.80,150855.20,730146),('1','186','257944','419',640.00,720.00,0.00,0.00,0.00,0.00,0.00,730147),('1','186','257945','419',640.00,720.00,0.00,14997.78,9598579.20,10032053.40,433474.20,730148),('1','186','257946','419',640.00,720.00,0.00,4202.18,2689395.20,2840200.20,150805.00,730149),('1','186','257947','419',640.00,720.00,0.00,0.00,0.00,0.00,0.00,730150),('1','186','257948','419',640.00,720.00,0.00,2970.47,1901100.80,2008543.20,107442.40,730151),('1','186','257949','419',640.00,720.00,0.00,6159.13,3941843.20,4204411.00,262567.80,730152),('1','186','257950','419',640.00,720.00,0.00,4791.80,3066752.00,3281137.20,214385.20,730153),('1','186','257951','419',640.00,720.00,0.00,4699.97,3007980.80,3228287.90,220307.10,730154),('1','186','257952','419',640.00,720.00,0.00,6001.92,3841228.80,4047072.88,205844.08,730155),('1','186','257953','419',640.00,720.00,0.00,0.00,0.00,0.00,0.00,730156),('1','186','257954','419',640.00,700.00,0.00,11123.47,7119020.80,7328508.64,209487.84,730157),('1','186','257955','419',640.00,700.00,0.00,7493.64,4795929.60,4969946.50,174016.90,730158),('1','186','257956','419',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730159),('1','186','257957','419',640.00,700.00,0.00,0.00,0.00,0.00,0.00,730160),('1','186','257958','419',630.00,700.00,0.00,7030.76,4429378.80,4689282.00,259903.20,730161),('1','186','257959','419',630.00,700.00,0.00,8421.86,5305771.80,5595832.00,290060.20,730162),('1','186','257960','419',630.00,700.00,0.00,4045.68,2548778.40,2689801.00,141022.60,730163),('1','186','257961','419',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730164),('1','186','257962','419',630.00,700.00,0.00,3067.10,1932273.00,2051392.50,119119.50,730165),('1','186','257963','419',630.00,700.00,0.00,8759.94,5518762.20,5823592.00,304829.80,730166),('1','186','257964','419',630.00,700.00,0.00,9832.75,6194632.50,6508940.00,314307.50,730167),('1','186','257965','419',630.00,700.00,0.00,3268.07,2058884.10,2131834.50,72950.40,730168),('1','186','257966','419',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730169),('1','186','257967','419',630.00,700.00,0.00,6377.35,4017730.50,4240468.50,222738.00,730170),('1','186','257968','419',630.00,700.00,0.00,9196.50,5793795.00,6092810.00,299015.00,730171),('1','186','257969','419',630.00,700.00,0.00,7390.10,4655763.00,4918866.00,263103.00,730172),('1','186','257970','419',630.00,700.00,0.00,1992.79,1255457.70,1341753.00,86295.30,730173),('1','186','257971','419',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730174),('1','186','257972','419',630.00,700.00,0.00,13173.08,8299040.40,8688688.00,389647.60,730175),('1','186','257973','419',630.00,700.00,0.00,6151.83,3875652.90,4134097.50,258444.60,730176),('1','186','257974','419',630.00,700.00,0.00,5508.42,3470304.60,3646924.00,176619.40,730177),('1','186','257975','419',630.00,700.00,0.00,0.00,0.00,0.00,0.00,730178),('1','186','257976','419',626.00,700.00,0.00,11759.08,7361184.08,7741960.00,380775.92,730179),('1','186','257977','419',626.00,700.00,0.00,7912.43,4953181.18,5200849.00,247667.82,730180),('1','186','257978','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730181),('1','186','257979','419',626.00,700.00,0.00,2593.60,1623593.60,1732015.00,108421.40,730182),('1','186','257980','419',626.00,700.00,0.00,13994.47,8760538.22,9210503.50,449965.28,730183),('1','186','257981','419',626.00,700.00,0.00,7913.89,4954095.14,5246601.50,292506.36,730184),('1','186','257982','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730185),('1','186','257983','419',626.00,700.00,0.00,541.61,339047.86,359623.50,20575.64,730186),('1','186','257984','419',626.00,700.00,0.00,11995.43,7509139.18,7927080.00,417940.82,730187),('1','186','257985','419',626.00,700.00,0.00,7053.96,4415778.96,4626708.50,210929.54,730188),('1','186','257986','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730189),('1','186','257987','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730190),('1','186','257988','419',626.00,700.00,0.00,9827.78,6152190.28,6477983.00,325792.72,730191),('1','186','257989','419',626.00,700.00,0.00,15131.85,9472538.10,9975772.50,503234.40,730192),('1','186','257990','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730193),('1','186','257991','419',626.00,700.00,0.00,18343.56,11483068.56,12094104.00,611035.44,730194),('1','186','257992','419',626.00,700.00,0.00,5885.45,3684291.70,3971365.00,287073.30,730195),('1','186','257993','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730196),('1','186','257994','419',626.00,700.00,0.00,3469.98,2172207.48,2340636.00,168428.52,730197),('1','186','257995','419',626.00,700.00,0.00,15858.55,9927452.30,10541000.50,613548.20,730198),('1','186','257996','419',626.00,700.00,0.00,5384.11,3370452.86,3574419.50,203966.64,730199),('1','186','257997','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730200),('1','186','257998','419',626.00,700.00,0.00,4965.96,3108690.96,3297772.00,189081.04,730201),('1','186','257999','419',626.00,700.00,0.00,15330.25,9596736.50,10076374.00,479637.50,730202),('1','186','258000','419',626.00,700.00,0.00,4054.52,2538129.52,2672985.00,134855.48,730203),('1','186','258001','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730204),('1','186','258002','419',626.00,700.00,0.00,9079.17,5683560.42,5954018.00,270457.58,730205),('1','186','258003','419',626.00,700.00,0.00,11423.19,7150916.94,7553896.50,402979.56,730206),('1','186','258004','419',626.00,700.00,0.00,4187.44,2621337.44,2780208.00,158870.56,730207),('1','186','258005','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730208),('1','186','258006','419',626.00,700.00,0.00,16536.34,10351748.84,10929966.00,578217.16,730209),('1','186','258007','419',626.00,700.00,0.00,7796.75,4880765.50,5145153.50,264388.00,730210),('1','186','258008','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730211),('1','186','258009','419',626.00,700.00,0.00,3916.60,2451791.60,2612001.50,160209.90,730212),('1','186','258010','419',626.00,700.00,0.00,10692.15,6693285.90,7062518.50,369232.60,730213),('1','186','258011','419',626.00,700.00,0.00,4805.29,3008111.54,3169202.00,161090.46,730214),('1','186','258012','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730215),('1','186','258013','419',626.00,700.00,0.00,13549.99,8482293.74,8913198.00,430904.26,730216),('1','186','258014','419',626.00,700.00,0.00,5633.08,3526308.08,3697377.50,171069.42,730217),('1','186','258015','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730218),('1','186','258016','419',626.00,700.00,0.00,13756.47,8611550.22,8987738.00,376187.78,730219),('1','186','258017','419',626.00,700.00,0.00,5495.57,3440226.82,3640149.00,199922.18,730220),('1','186','258018','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730221),('1','186','258019','419',626.00,700.00,0.00,3230.45,2022261.70,2156965.00,134703.30,730222),('1','186','258020','419',626.00,700.00,0.00,8352.62,5228740.12,5552564.00,323823.88,730223),('1','186','258021','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730224),('1','186','258022','419',626.00,700.00,0.00,13233.48,8284158.48,8708239.00,424080.52,730225),('1','186','258023','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730226),('1','186','258024','419',626.00,700.00,0.00,17743.28,11107293.28,11632020.00,524726.72,730227),('1','186','258025','419',626.00,700.00,0.00,6590.79,4125834.54,4366219.04,240384.50,730228),('1','186','258026','419',626.00,700.00,0.00,0.00,0.00,0.00,0.00,730229),('1','186','258027','419',626.00,700.00,0.00,2241.71,1403310.46,1486750.96,83440.50,730230),('1','186','258028','419',626.00,700.00,0.00,9420.84,5897445.84,6239377.50,341931.66,730231),('1','186','258029','419',626.00,700.00,0.00,9310.00,5828060.00,6174492.80,346432.80,730232),('1','186','258030','419',626.00,700.00,0.00,3381.72,2116956.72,2231163.50,114206.78,730233),('1','186','258031','419',626.00,700.00,0.00,4270.03,2647418.60,2795572.80,148154.20,730234),('1','186','258032','419',620.00,680.00,0.00,9597.72,5950586.40,6255352.40,304766.00,730235),('1','186','258033','419',620.00,680.00,0.00,7962.15,4936533.00,5188873.60,252340.60,730236),('1','186','258034','419',620.00,680.00,0.00,2001.63,1241010.60,1281383.61,40373.01,730237),('1','186','258035','419',620.00,680.00,0.00,0.00,0.00,0.00,0.00,730238),('1','186','258036','419',620.00,680.00,0.00,0.00,0.00,0.00,0.00,730239),('1','186','258037','419',620.00,680.00,0.00,0.00,0.00,0.00,0.00,730240),('1','186','258038','419',620.00,680.00,0.00,9224.97,5719481.40,5974467.39,254985.99,730241),('1','186','258039','419',620.00,680.00,0.00,8605.53,5335428.60,5586923.60,251495.00,730242),('1','186','258040','419',620.00,680.00,0.00,6215.12,3853374.40,4043870.73,190496.33,730243),('1','186','258041','419',620.00,680.00,0.00,0.00,0.00,0.00,0.00,730244),('1','186','258042','419',620.00,680.00,0.00,1758.55,1090301.00,1138720.07,48419.07,730245),('1','186','258043','419',620.00,680.00,0.00,9759.39,6050821.80,6331799.20,280977.40,730246),('1','186','258044','419',620.00,680.00,0.00,7580.94,4700182.80,4951843.20,251660.40,730247),('1','186','258045','419',620.00,680.00,0.00,5347.10,3315202.00,3473936.84,158734.84,730248),('1','186','258046','419',620.00,680.00,0.00,0.00,0.00,0.00,0.00,730249),('1','186','258047','419',603.00,680.00,0.00,3526.63,2126557.89,2303834.10,177276.21,730250),('1','186','258048','419',603.00,670.00,0.00,9883.61,5959816.83,6316388.70,356571.87,730251),('1','186','258049','419',603.00,670.00,0.00,11274.10,6798282.30,7153057.60,354775.30,730252),('1','186','258050','419',603.00,670.00,0.00,0.00,0.00,0.00,0.00,730253),('1','186','258051','419',603.00,670.00,0.00,4893.91,2951027.73,3137285.70,186257.97,730254),('1','186','258052','419',603.00,670.00,0.00,10082.25,6079596.75,6435949.90,356353.15,730255),('1','186','258053','419',603.00,670.00,0.00,9687.69,5841677.07,6166844.30,325167.23,730256),('1','186','258054','419',603.00,670.00,0.00,47.99,28937.97,30233.70,1295.73,730257),('1','186','258055','419',603.00,670.00,0.00,0.00,0.00,0.00,0.00,730258),('1','186','258056','419',611.00,670.00,0.00,14089.28,8608550.08,8964368.40,355818.32,730259),('1','186','258057','419',611.00,670.00,0.00,10185.55,6223371.05,6488976.77,265605.72,730260),('1','186','258058','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730261),('1','186','258059','419',611.00,670.00,0.00,1657.08,1012475.88,1054917.46,42441.58,730262),('1','186','258060','419',611.00,670.00,0.00,11293.15,6900114.65,7194026.90,293912.25,730263),('1','186','258061','419',611.00,670.00,0.00,8411.85,5139640.35,5394557.10,254916.75,730264),('1','186','258062','419',611.00,670.00,0.00,2785.26,1701793.86,1768760.30,66966.44,730265),('1','186','258063','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730266),('1','186','258064','419',611.00,670.00,0.00,3306.18,2020075.98,2144809.40,124733.42,730267),('1','186','258065','419',611.00,670.00,0.00,11578.83,7074665.13,7380601.10,305935.97,730268),('1','186','258066','419',611.00,670.00,0.00,6027.09,3682551.99,3892742.70,210190.71,730269),('1','186','258067','419',611.00,670.00,0.00,3360.97,2053552.67,2136258.30,82705.63,730270),('1','186','258068','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730271),('1','186','258069','419',611.00,670.00,0.00,5714.46,3491535.06,3682666.60,191131.54,730272),('1','186','258070','419',611.00,670.00,0.00,9555.78,5838581.58,6128462.40,289880.82,730273),('1','186','258071','419',611.00,670.00,0.00,9083.39,5549951.29,5762161.50,212210.21,730274),('1','186','258072','419',611.00,670.00,0.00,55.79,34087.69,35147.70,1060.01,730275),('1','186','258073','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730276),('1','186','258074','419',611.00,670.00,0.00,6093.78,3723299.58,3914019.40,190719.82,730277),('1','186','258075','419',611.00,670.00,0.00,10498.34,6414485.74,6714854.60,300368.86,730278),('1','186','258076','419',611.00,670.00,0.00,8013.08,4895991.88,5136927.20,240935.32,730279),('1','186','258077','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730280),('1','186','258078','419',611.00,670.00,0.00,18355.25,11215057.75,11577693.50,362635.75,730281),('1','186','258079','419',611.00,670.00,0.00,5788.96,3537054.56,3698723.89,161669.33,730282),('1','186','258080','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730283),('1','186','258081','419',611.00,670.00,0.00,4121.05,2517961.55,2642989.81,125028.26,730284),('1','186','258082','419',611.00,670.00,0.00,6291.32,3843996.52,4068000.80,224004.28,730285),('1','186','258083','419',611.00,670.00,0.00,10007.66,6114680.26,6392012.60,277332.34,730286),('1','186','258084','419',611.00,670.00,0.00,3853.27,2354347.97,2470761.30,116413.33,730287),('1','186','258085','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730288),('1','186','258086','419',611.00,670.00,0.00,10726.59,6553946.49,6837845.30,283898.81,730289),('1','186','258087','419',611.00,670.00,0.00,12457.28,7611398.08,7930170.25,318772.17,730290),('1','186','258088','419',611.00,670.00,0.00,1061.04,648295.44,681937.20,33641.76,730291),('1','186','258089','419',611.00,670.00,0.00,27.75,16955.25,17482.50,527.25,730292),('1','186','258090','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730293),('1','186','258091','419',611.00,670.00,0.00,11590.64,7081881.04,7385567.40,303686.36,730294),('1','186','258092','419',611.00,670.00,0.00,7587.03,4635675.33,4878798.50,243123.17,730295),('1','186','258093','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730296),('1','186','258094','419',611.00,670.00,0.00,4463.93,2727461.23,2867454.50,139993.27,730297),('1','186','258095','419',611.00,670.00,0.00,8577.15,5240638.65,5524492.90,283854.25,730298),('1','186','258096','419',611.00,670.00,0.00,11168.43,6823910.73,7144189.30,320278.57,730299),('1','186','258097','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730300),('1','186','258098','419',611.00,670.00,0.00,13492.81,8244106.91,8622038.50,377931.59,730301),('1','186','258099','419',611.00,670.00,0.00,3755.74,2294757.14,2345899.00,51141.86,730302),('1','186','258100','419',611.00,670.00,0.00,7073.97,4322195.67,4513256.70,191061.03,730303),('1','186','258101','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730304),('1','186','258102','419',611.00,670.00,0.00,9456.91,5778172.01,6075186.70,297014.69,730305),('1','186','258103','419',611.00,670.00,0.00,14661.97,8958463.67,9330381.30,371917.63,730306),('1','186','258104','419',611.00,670.00,0.00,229.11,139986.21,148103.70,8117.49,730307),('1','186','258105','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730308),('1','186','258106','419',611.00,670.00,0.00,8778.77,5363828.47,5528175.90,164347.43,730309),('1','186','258107','419',611.00,670.00,0.00,7120.23,4350460.53,4613473.30,263012.77,730310),('1','186','258108','419',611.00,670.00,0.00,256.09,156470.99,161336.70,4865.71,730311),('1','186','258109','419',611.00,670.00,0.00,7704.61,4707516.71,4922925.70,215408.99,730312),('1','186','258110','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730313),('1','186','258111','419',611.00,670.00,0.00,2101.21,1283839.31,1350850.70,67011.39,730314),('1','186','258112','419',611.00,670.00,0.00,8350.14,5101935.54,5380158.20,278222.66,730315),('1','186','258113','419',611.00,670.00,0.00,13197.77,8063837.47,8423481.70,359644.23,730316),('1','186','258114','419',611.00,670.00,0.00,723.38,441985.18,466421.80,24436.62,730317),('1','186','258115','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730318),('1','186','258116','419',611.00,670.00,0.00,6315.12,3858538.32,4032577.60,174039.28,730319),('1','186','258117','419',611.00,670.00,0.00,8113.57,4957391.27,5212912.70,255521.43,730320),('1','186','258118','419',611.00,670.00,0.00,9446.21,5771634.31,6049336.70,277702.39,730321),('1','186','258119','419',611.00,670.00,0.00,898.72,549117.92,578298.40,29180.48,730322),('1','186','258120','419',611.00,670.00,0.00,0.00,0.00,0.00,0.00,730323),('1','186','258121','419',596.00,670.00,0.00,6649.30,3962982.80,4295385.20,332402.40,730324),('1','186','258122','419',596.00,670.00,0.00,6752.90,4024728.40,4381482.60,356754.20,730325),('1','186','258123','419',596.00,670.00,0.00,9955.90,5933716.40,6383882.30,450165.90,730326),('1','186','258124','419',596.00,670.00,0.00,734.81,437946.76,463075.64,25128.88,730327),('1','186','258125','419',596.00,670.00,0.00,0.00,0.00,0.00,0.00,730328),('1','186','258126','419',596.00,670.00,0.00,6949.87,4142122.52,4444225.07,302102.55,730329),('1','186','258127','419',596.00,670.00,0.00,7998.16,4766903.36,5152126.00,385222.64,730330),('1','186','258128','419',596.00,670.00,0.00,9395.77,5599878.92,5840265.90,240386.98,730331),('1','186','258129','419',596.00,670.00,0.00,0.00,0.00,0.00,0.00,730332),('1','186','258130','419',596.00,670.00,0.00,3459.43,2061820.28,2239978.10,178157.82,730333),('1','186','258131','419',596.00,670.00,0.00,10835.74,6458101.04,6922511.40,464410.36,730334),('1','186','258132','419',596.00,670.00,0.00,10281.35,6127684.60,6612864.50,485179.90,730335),('1','186','258133','419',596.00,670.00,0.00,264.06,157379.76,167153.40,9773.64,730336),('1','186','258134','419',596.00,670.00,0.00,0.00,0.00,0.00,0.00,730337),('1','186','258135','419',596.00,670.00,0.00,19893.78,11856692.88,12634894.10,778201.22,730338);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',386,'186','LPG PRODUCT TANK.','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=941 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','186','386',940,1,'419','LPG TANK',23000.00,1.00,4562.43,'TANK CONTAINING LPG PRODUCT.','479','2021-06-16 09:54:19','2021-06-16 09:54:19','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','186',940,3014.52,'2023-03-20 19:51:24');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2779472 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108874,'1','186','940',419,'Retail Sale Id 1254432',867000.00,0.00,0.00,0.00,-93000.00,'2021-12-01 07:09:45','',''),(2108875,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1500.00,0.00,'2021-12-01 07:09:45','',''),(2108907,'1','186','940',419,'Retail Sale Id 1254440',273180.00,0.00,0.00,0.00,-28260.00,'2021-12-01 07:10:41','',''),(2108908,'1','186','940',419,'Retail sales',0.00,0.00,0.00,471.00,0.00,'2021-12-01 07:10:41','',''),(2109555,'1','186','940',419,'Distributed to AARANO for sales id:336454',219870.00,0.00,0.00,349.00,0.00,'2021-12-01 07:41:17','',''),(2109721,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,8190560.00,14420.00,0.00,0.00,'2021-12-01 07:47:45','',''),(2109772,'1','186',NULL,419,'Reception corrector for bridging 125816',0.00,0.00,0.00,14420.00,0.00,'2021-12-01 07:50:18','',''),(2109773,'1','186','940',419,'Received from bridging 125816',0.00,0.00,14420.00,0.00,0.00,'2021-12-01 07:50:18','',''),(2109828,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,6611520.00,11640.00,0.00,0.00,'2021-12-01 07:53:03','',''),(2109926,'1','186',NULL,419,'Reception corrector for bridging 125820',0.00,0.00,0.00,8580.00,0.00,'2021-12-01 07:58:13','',''),(2109927,'1','186','940',419,'Received from bridging 125820',0.00,0.00,8580.00,0.00,0.00,'2021-12-01 07:58:13','',''),(2110104,'1','186','940',419,'Retail Sale Id 1254985',6930.00,0.00,0.00,0.00,682.00,'2021-12-01 08:07:35','',''),(2110105,'1','186','940',419,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 08:07:35','',''),(2110160,'1','186','940',419,'Retail Sale Id 1255010',7875.00,0.00,0.00,0.00,775.00,'2021-12-01 08:11:02','',''),(2110161,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:11:02','',''),(2110236,'1','186','940',419,'Retail Sale Id 1255051',5670.00,0.00,0.00,0.00,558.00,'2021-12-01 08:15:28','',''),(2110237,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 08:15:28','',''),(2110242,'1','186','940',419,'Retail Sale Id 1255055',9450.00,0.00,0.00,0.00,930.00,'2021-12-01 08:16:14','',''),(2110243,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 08:16:14','',''),(2110258,'1','186','940',419,'Retail Sale Id 1255064',9450.00,0.00,0.00,0.00,930.00,'2021-12-01 08:16:54','',''),(2110259,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 08:16:54','',''),(2110282,'1','186','940',419,'Retail Sale Id 1255076',11970.00,0.00,0.00,0.00,1178.00,'2021-12-01 08:17:58','',''),(2110283,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-01 08:17:58','',''),(2110310,'1','186','940',419,'Retail Sale Id 1255091',4410.00,0.00,0.00,0.00,434.00,'2021-12-01 08:19:32','',''),(2110311,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:19:32','',''),(2110324,'1','186','940',419,'Retail Sale Id 1255101',5670.00,0.00,0.00,0.00,558.00,'2021-12-01 08:20:13','',''),(2110325,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 08:20:13','',''),(2110348,'1','186','940',419,'Retail Sale Id 1255110',20790.00,0.00,0.00,0.00,2046.00,'2021-12-01 08:21:03','',''),(2110349,'1','186','940',419,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-01 08:21:03','',''),(2110366,'1','186','940',419,'Retail Sale Id 1255119',10710.00,0.00,0.00,0.00,1054.00,'2021-12-01 08:22:09','',''),(2110367,'1','186','940',419,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-01 08:22:09','',''),(2110384,'1','186','940',419,'Retail Sale Id 1255128',3150.00,0.00,0.00,0.00,310.00,'2021-12-01 08:23:03','',''),(2110385,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:23:03','',''),(2110393,'1','186','940',419,'Retail Sale Id 1255130',3780.00,0.00,0.00,0.00,372.00,'2021-12-01 08:24:06','',''),(2110394,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:24:06','',''),(2110403,'1','186','940',419,'Retail Sale Id 1255138',5040.00,0.00,0.00,0.00,496.00,'2021-12-01 08:24:45','',''),(2110404,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 08:24:45','',''),(2110413,'1','186','940',419,'Retail Sale Id 1255143',4410.00,0.00,0.00,0.00,434.00,'2021-12-01 08:25:40','',''),(2110414,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:25:40','',''),(2110423,'1','186','940',419,'Retail Sale Id 1255149',5040.00,0.00,0.00,0.00,496.00,'2021-12-01 08:26:31','',''),(2110424,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 08:26:31','',''),(2110517,'1','186','940',419,'Retail Sale Id 1255193',3150.00,0.00,0.00,0.00,310.00,'2021-12-01 08:32:14','',''),(2110518,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:32:14','',''),(2110533,'1','186','940',419,'Retail Sale Id 1255203',5040.00,0.00,0.00,0.00,496.00,'2021-12-01 08:33:16','',''),(2110534,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 08:33:16','',''),(2110576,'1','186','940',419,'Retail Sale Id 1255222',3150.00,0.00,0.00,0.00,310.00,'2021-12-01 08:35:21','',''),(2110577,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:35:21','',''),(2110590,'1','186','940',419,'Retail Sale Id 1255229',3780.00,0.00,0.00,0.00,372.00,'2021-12-01 08:36:17','',''),(2110591,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:36:17','',''),(2110613,'1','186','940',419,'Retail Sale Id 1255235',5670.00,0.00,0.00,0.00,558.00,'2021-12-01 08:37:43','',''),(2110614,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 08:37:43','',''),(2110621,'1','186','940',419,'Retail Sale Id 1255241',4410.00,0.00,0.00,0.00,434.00,'2021-12-01 08:38:19','',''),(2110622,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 08:38:19','',''),(2110633,'1','186','940',419,'Retail Sale Id 1255246',5040.00,0.00,0.00,0.00,496.00,'2021-12-01 08:38:59','',''),(2110634,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 08:38:59','',''),(2110643,'1','186','940',419,'Retail Sale Id 1255250',5670.00,0.00,0.00,0.00,558.00,'2021-12-01 08:39:34','',''),(2110644,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-01 08:39:34','',''),(2110653,'1','186','940',419,'Retail Sale Id 1255256',3780.00,0.00,0.00,0.00,372.00,'2021-12-01 08:40:09','',''),(2110654,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:40:09','',''),(2110675,'1','186','940',419,'Retail Sale Id 1255261',3150.00,0.00,0.00,0.00,310.00,'2021-12-01 08:40:46','',''),(2110676,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:40:46','',''),(2110700,'1','186','940',419,'Retail Sale Id 1255278',2023000.00,0.00,0.00,0.00,35000.00,'2021-12-01 08:41:51','',''),(2110701,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3500.00,0.00,'2021-12-01 08:41:51','',''),(2120088,'1','186','940',419,'Retail Sale Id 1259765',602276.00,0.00,0.00,0.00,10420.00,'2021-12-01 21:22:47','',''),(2120089,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1042.00,0.00,'2021-12-01 21:22:47','',''),(2120090,'1','186','940',419,'Retail Sale Id 1259766',1479000.00,0.00,0.00,0.00,30600.00,'2021-12-01 21:24:22','',''),(2120091,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2550.00,0.00,'2021-12-01 21:24:22','',''),(2120093,'1','186','940',419,'Retail Sale Id 1259767',167895.00,0.00,0.00,0.00,16523.00,'2021-12-01 21:27:28','',''),(2120094,'1','186','940',419,'Retail sales',0.00,0.00,0.00,266.50,0.00,'2021-12-01 21:27:28','',''),(2123611,'1','186','940',419,'Retail Sale Id 1261365',4410.00,0.00,0.00,0.00,434.00,'2021-12-02 08:54:47','',''),(2123612,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 08:54:47','',''),(2123627,'1','186','940',419,'Retail Sale Id 1261374',3780.00,0.00,0.00,0.00,372.00,'2021-12-02 08:55:24','',''),(2123628,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:55:24','',''),(2123641,'1','186','940',419,'Retail Sale Id 1261381',3780.00,0.00,0.00,0.00,372.00,'2021-12-02 08:56:01','',''),(2123642,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:56:01','',''),(2123661,'1','186','940',419,'Retail Sale Id 1261389',9450.00,0.00,0.00,0.00,930.00,'2021-12-02 08:56:52','',''),(2123662,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 08:56:52','',''),(2123669,'1','186','940',419,'Retail Sale Id 1261393',5670.00,0.00,0.00,0.00,558.00,'2021-12-02 08:57:34','',''),(2123670,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 08:57:34','',''),(2123683,'1','186','940',419,'Retail Sale Id 1261400',11970.00,0.00,0.00,0.00,1178.00,'2021-12-02 08:58:19','',''),(2123684,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-02 08:58:19','',''),(2123697,'1','186','940',419,'Retail Sale Id 1261408',7875.00,0.00,0.00,0.00,775.00,'2021-12-02 08:59:05','',''),(2123698,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:59:05','',''),(2123729,'1','186','940',419,'Retail Sale Id 1261422',5040.00,0.00,0.00,0.00,496.00,'2021-12-02 09:00:32','',''),(2123730,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 09:00:32','',''),(2123743,'1','186','940',419,'Retail Sale Id 1261431',11970.00,0.00,0.00,0.00,1178.00,'2021-12-02 09:01:13','',''),(2123744,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-02 09:01:13','',''),(2123779,'1','186','940',419,'Retail Sale Id 1261443',7875.00,0.00,0.00,0.00,775.00,'2021-12-02 09:03:28','',''),(2123780,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:03:28','',''),(2123807,'1','186','940',419,'Retail Sale Id 1261470',11970.00,0.00,0.00,0.00,1178.00,'2021-12-02 09:04:42','',''),(2123808,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-02 09:04:42','',''),(2123829,'1','186','940',419,'Retail Sale Id 1261484',11340.00,0.00,0.00,0.00,1116.00,'2021-12-02 09:05:46','',''),(2123830,'1','186','940',419,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-02 09:05:46','',''),(2123867,'1','186','940',419,'Retail Sale Id 1261510',4410.00,0.00,0.00,0.00,434.00,'2021-12-02 09:07:35','',''),(2123868,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 09:07:35','',''),(2123895,'1','186','940',419,'Retail Sale Id 1261517',9450.00,0.00,0.00,0.00,930.00,'2021-12-02 09:08:33','',''),(2123896,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 09:08:33','',''),(2123911,'1','186','940',419,'Retail Sale Id 1261531',3780.00,0.00,0.00,0.00,372.00,'2021-12-02 09:09:45','',''),(2123912,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:09:45','',''),(2123935,'1','186','940',419,'Retail Sale Id 1261543',4410.00,0.00,0.00,0.00,434.00,'2021-12-02 09:10:51','',''),(2123936,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-02 09:10:51','',''),(2123961,'1','186','940',419,'Retail Sale Id 1261549',3780.00,0.00,0.00,0.00,372.00,'2021-12-02 09:11:25','',''),(2123962,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:11:25','',''),(2123983,'1','186','940',419,'Retail Sale Id 1261562',5670.00,0.00,0.00,0.00,558.00,'2021-12-02 09:12:48','',''),(2123984,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 09:12:48','',''),(2123997,'1','186','940',419,'Retail Sale Id 1261567',5670.00,0.00,0.00,0.00,558.00,'2021-12-02 09:13:32','',''),(2123998,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 09:13:32','',''),(2124078,'1','186','940',419,'Retail Sale Id 1261590',2312000.00,0.00,0.00,0.00,40000.00,'2021-12-02 09:16:18','',''),(2124079,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4000.00,0.00,'2021-12-02 09:16:18','',''),(2126382,'1','186','940',419,'Retail Sale Id 1262764',7875.00,0.00,0.00,0.00,775.00,'2021-12-02 11:30:45','',''),(2126383,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:30:45','',''),(2132844,'1','186','940',419,'Retail Sale Id 1265815',7875.00,0.00,0.00,0.00,775.00,'2021-12-02 17:49:43','',''),(2132845,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:49:43','',''),(2133510,'1','186','940',419,'Retail Sale Id 1266047',2225300.00,0.00,0.00,0.00,38500.00,'2021-12-02 20:43:08','',''),(2133511,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3850.00,0.00,'2021-12-02 20:43:08','',''),(2133522,'1','186','940',419,'Retail Sale Id 1266048',2001000.00,0.00,0.00,0.00,41400.00,'2021-12-02 20:44:59','',''),(2133523,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3450.00,0.00,'2021-12-02 20:44:59','',''),(2133531,'1','186','940',419,'Retail Sale Id 1266050',114975.00,0.00,0.00,0.00,11315.00,'2021-12-02 20:49:07','',''),(2133532,'1','186','940',419,'Retail sales',0.00,0.00,0.00,182.50,0.00,'2021-12-02 20:49:07','',''),(2136608,'1','186','940',419,'Retail Sale Id 1267296',8190.00,0.00,0.00,0.00,806.00,'2021-12-03 08:38:11','',''),(2136609,'1','186','940',419,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-03 08:38:11','',''),(2136677,'1','186','940',419,'Retail Sale Id 1267302',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 08:39:52','',''),(2136678,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 08:39:52','',''),(2136974,'1','186','940',419,'Retail Sale Id 1267446',7875.00,0.00,0.00,0.00,775.00,'2021-12-03 08:55:41','',''),(2136975,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:55:41','',''),(2136996,'1','186','940',419,'Retail Sale Id 1267457',5670.00,0.00,0.00,0.00,558.00,'2021-12-03 08:57:01','',''),(2136997,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 08:57:01','',''),(2137042,'1','186','940',419,'Retail Sale Id 1267478',5670.00,0.00,0.00,0.00,558.00,'2021-12-03 08:59:39','',''),(2137043,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 08:59:39','',''),(2137066,'1','186','940',419,'Retail Sale Id 1267499',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 09:00:59','',''),(2137067,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 09:00:59','',''),(2137100,'1','186','940',419,'Retail Sale Id 1267515',8190.00,0.00,0.00,0.00,806.00,'2021-12-03 09:02:26','',''),(2137101,'1','186','940',419,'Retail sales',0.00,0.00,0.00,13.00,0.00,'2021-12-03 09:02:26','',''),(2137126,'1','186','940',419,'Retail Sale Id 1267528',11970.00,0.00,0.00,0.00,1178.00,'2021-12-03 09:03:43','',''),(2137127,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-03 09:03:43','',''),(2137223,'1','186','940',419,'Retail Sale Id 1267584',7875.00,0.00,0.00,0.00,775.00,'2021-12-03 09:08:06','',''),(2137224,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:08:06','',''),(2137275,'1','186','940',419,'Retail Sale Id 1267596',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 09:11:00','',''),(2137276,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 09:11:00','',''),(2137298,'1','186','940',419,'Retail Sale Id 1267637',5670.00,0.00,0.00,0.00,558.00,'2021-12-03 09:12:13','',''),(2137299,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 09:12:13','',''),(2137312,'1','186','940',419,'Retail Sale Id 1267645',3780.00,0.00,0.00,0.00,372.00,'2021-12-03 09:12:47','',''),(2137313,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:12:47','',''),(2137328,'1','186','940',419,'Retail Sale Id 1267655',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 09:13:24','',''),(2137329,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 09:13:24','',''),(2137338,'1','186','940',419,'Retail Sale Id 1267662',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 09:14:11','',''),(2137339,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 09:14:11','',''),(2137354,'1','186','940',419,'Retail Sale Id 1267670',3780.00,0.00,0.00,0.00,372.00,'2021-12-03 09:14:47','',''),(2137355,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:14:47','',''),(2137370,'1','186','940',419,'Retail Sale Id 1267677',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 09:15:31','',''),(2137371,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 09:15:31','',''),(2137383,'1','186','940',419,'Retail Sale Id 1267684',5670.00,0.00,0.00,0.00,558.00,'2021-12-03 09:16:09','',''),(2137384,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 09:16:09','',''),(2137395,'1','186','940',419,'Retail Sale Id 1267690',5040.00,0.00,0.00,0.00,496.00,'2021-12-03 09:16:46','',''),(2137396,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 09:16:46','',''),(2137417,'1','186','940',419,'Retail Sale Id 1267707',5670.00,0.00,0.00,0.00,558.00,'2021-12-03 09:17:36','',''),(2137418,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-03 09:17:36','',''),(2137434,'1','186','940',419,'Retail Sale Id 1267714',231200.00,0.00,0.00,0.00,4000.00,'2021-12-03 09:18:26','',''),(2137435,'1','186','940',419,'Retail sales',0.00,0.00,0.00,400.00,0.00,'2021-12-03 09:18:26','',''),(2140192,'1','186','940',419,'Retail Sale Id 1269171',630.00,0.00,0.00,0.00,62.00,'2021-12-03 12:29:45','',''),(2140193,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 12:29:45','',''),(2144677,'1','186','940',419,'Retail Sale Id 1271262',7875.00,0.00,0.00,0.00,775.00,'2021-12-03 16:35:29','',''),(2144678,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:35:29','',''),(2146305,'1','186',NULL,419,'Reception corrector for bridging 126140',0.00,0.00,0.00,3060.00,0.00,'2021-12-03 21:44:44','',''),(2146306,'1','186','940',419,'Received from bridging 126140',0.00,0.00,3060.00,0.00,0.00,'2021-12-03 21:44:44','',''),(2146309,'1','186','940',419,'Retail Sale Id 1271931',2601000.00,0.00,0.00,0.00,45000.00,'2021-12-03 21:46:35','',''),(2146310,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4500.00,0.00,'2021-12-03 21:46:35','',''),(2146311,'1','186','940',419,'Retail Sale Id 1271932',319000.00,0.00,0.00,0.00,6600.00,'2021-12-03 21:51:04','',''),(2146312,'1','186','940',419,'Retail sales',0.00,0.00,0.00,550.00,0.00,'2021-12-03 21:51:04','',''),(2155388,'1','186','940',419,'Retail Sale Id 1275897',65898.00,0.00,0.00,0.00,6485.20,'2021-12-04 13:26:00','',''),(2155389,'1','186','940',419,'Retail sales',0.00,0.00,0.00,104.60,0.00,'2021-12-04 13:26:00','',''),(2163266,'1','186','940',419,'Retail Sale Id 1279307',7875.00,0.00,0.00,0.00,775.00,'2021-12-05 07:33:16','',''),(2163267,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:33:16','',''),(2164932,'1','186','940',419,'Return of Retail Sale Id 1279307',0.00,7875.00,12.50,0.00,-775.00,'2021-12-05 09:00:17','',''),(2165172,'1','186','940',419,'Distributed to AARANO for sales id:337314',619290.00,0.00,0.00,983.00,0.00,'2021-12-05 09:12:12','',''),(2165330,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14171600.00,24950.00,0.00,0.00,'2021-12-05 09:21:50','',''),(2165362,'1','186',NULL,419,'Reception corrector for bridging 126295',0.00,0.00,0.00,22999.60,0.00,'2021-12-05 09:24:01','',''),(2165363,'1','186','940',419,'Received from bridging 126295',0.00,0.00,22999.60,0.00,0.00,'2021-12-05 09:24:01','',''),(2165426,'1','186','940',419,'Retail Sale Id 1280484',653515.70,0.00,0.00,0.00,11306.50,'2021-12-05 09:27:22','',''),(2165427,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1130.65,0.00,'2021-12-05 09:27:22','',''),(2165584,'1','186','940',419,'Retail Sale Id 1280576',10710.00,0.00,0.00,0.00,1054.00,'2021-12-05 09:35:26','',''),(2165585,'1','186','940',419,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-05 09:35:26','',''),(2165594,'1','186','940',419,'Retail Sale Id 1280583',5040.00,0.00,0.00,0.00,496.00,'2021-12-05 09:36:06','',''),(2165595,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 09:36:06','',''),(2165610,'1','186','940',419,'Retail Sale Id 1280590',5040.00,0.00,0.00,0.00,496.00,'2021-12-05 09:36:48','',''),(2165611,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 09:36:48','',''),(2165618,'1','186','940',419,'Retail Sale Id 1280595',11970.00,0.00,0.00,0.00,1178.00,'2021-12-05 09:37:25','',''),(2165619,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-05 09:37:25','',''),(2165636,'1','186','940',419,'Retail Sale Id 1280604',7875.00,0.00,0.00,0.00,775.00,'2021-12-05 09:38:04','',''),(2165637,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:38:04','',''),(2165644,'1','186','940',419,'Retail Sale Id 1280608',10080.00,0.00,0.00,0.00,992.00,'2021-12-05 09:38:43','',''),(2165645,'1','186','940',419,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-05 09:38:43','',''),(2165658,'1','186','940',419,'Retail Sale Id 1280616',9450.00,0.00,0.00,0.00,930.00,'2021-12-05 09:39:25','',''),(2165659,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-05 09:39:25','',''),(2165674,'1','186','940',419,'Retail Sale Id 1280620',7875.00,0.00,0.00,0.00,775.00,'2021-12-05 09:40:07','',''),(2165675,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:40:07','',''),(2165692,'1','186','940',419,'Retail Sale Id 1280632',2312000.00,0.00,0.00,0.00,40000.00,'2021-12-05 09:41:08','',''),(2165693,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4000.00,0.00,'2021-12-05 09:41:08','',''),(2165714,'1','186','940',419,'Retail Sale Id 1280638',11970.00,0.00,0.00,0.00,1178.00,'2021-12-05 09:41:49','',''),(2165715,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-05 09:41:49','',''),(2165730,'1','186','940',419,'Retail Sale Id 1280648',9450.00,0.00,0.00,0.00,930.00,'2021-12-05 09:42:33','',''),(2165731,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-05 09:42:33','',''),(2165744,'1','186','940',419,'Retail Sale Id 1280655',7875.00,0.00,0.00,0.00,775.00,'2021-12-05 09:43:13','',''),(2165745,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:43:13','',''),(2173059,'1','186','940',419,'Retail Sale Id 1284282',7875.00,0.00,0.00,0.00,775.00,'2021-12-05 16:33:36','',''),(2173060,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:33:36','',''),(2175770,'1','186','940',419,'Retail Sale Id 1285344',838100.00,0.00,0.00,0.00,14500.00,'2021-12-06 07:25:29','',''),(2175771,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1450.00,0.00,'2021-12-06 07:25:29','',''),(2175790,'1','186','940',419,'Retail Sale Id 1285355',899000.00,0.00,0.00,0.00,18600.00,'2021-12-06 07:26:45','',''),(2175791,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1550.00,0.00,'2021-12-06 07:26:45','',''),(2175816,'1','186','940',419,'Retail Sale Id 1285367',159408.90,0.00,0.00,0.00,15687.86,'2021-12-06 07:28:21','',''),(2175817,'1','186','940',419,'Retail sales',0.00,0.00,0.00,253.03,0.00,'2021-12-06 07:28:21','',''),(2175880,'1','186','940',419,'Return of Retail Sale Id 1280590',0.00,5040.00,8.00,0.00,-496.00,'2021-12-06 07:32:28','',''),(2175907,'1','186','940',419,'Retail Sale Id 1285410',926.10,0.00,0.00,0.00,91.14,'2021-12-06 07:34:02','',''),(2175908,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1.47,0.00,'2021-12-06 07:34:02','',''),(2175975,'1','186','940',419,'Retail Sale Id 1285445',4410.00,0.00,0.00,0.00,434.00,'2021-12-06 07:38:01','',''),(2175976,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-06 07:38:01','',''),(2175989,'1','186','940',419,'Retail Sale Id 1285451',5670.00,0.00,0.00,0.00,558.00,'2021-12-06 07:38:40','',''),(2175990,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 07:38:40','',''),(2176009,'1','186','940',419,'Retail Sale Id 1285457',5670.00,0.00,0.00,0.00,558.00,'2021-12-06 07:40:04','',''),(2176010,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 07:40:04','',''),(2176023,'1','186','940',419,'Retail Sale Id 1285468',5670.00,0.00,0.00,0.00,558.00,'2021-12-06 07:40:43','',''),(2176024,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-06 07:40:43','',''),(2176143,'1','186','940',419,'Retail Sale Id 1285523',7875.00,0.00,0.00,0.00,775.00,'2021-12-06 07:45:40','',''),(2176144,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:45:40','',''),(2176153,'1','186','940',419,'Retail Sale Id 1285536',1890.00,0.00,0.00,0.00,186.00,'2021-12-06 07:46:14','',''),(2176154,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:46:14','',''),(2176178,'1','186','940',419,'Retail Sale Id 1285544',10080.00,0.00,0.00,0.00,992.00,'2021-12-06 07:46:51','',''),(2176179,'1','186','940',419,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-06 07:46:51','',''),(2176190,'1','186','940',419,'Retail Sale Id 1285551',7875.00,0.00,0.00,0.00,775.00,'2021-12-06 07:47:24','',''),(2176191,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:47:24','',''),(2176202,'1','186','940',419,'Retail Sale Id 1285557',9450.00,0.00,0.00,0.00,930.00,'2021-12-06 07:48:12','',''),(2176203,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 07:48:12','',''),(2176219,'1','186','940',419,'Retail Sale Id 1285562',3150.00,0.00,0.00,0.00,310.00,'2021-12-06 07:48:52','',''),(2176220,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:48:52','',''),(2176233,'1','186','940',419,'Retail Sale Id 1285569',3780.00,0.00,0.00,0.00,372.00,'2021-12-06 07:49:41','',''),(2176234,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:49:41','',''),(2176251,'1','186','940',419,'Retail Sale Id 1285578',3780.00,0.00,0.00,0.00,372.00,'2021-12-06 07:50:20','',''),(2176252,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 07:50:20','',''),(2176264,'1','186','940',419,'Retail Sale Id 1285584',1260.00,0.00,0.00,0.00,124.00,'2021-12-06 07:51:08','',''),(2176265,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 07:51:08','',''),(2176278,'1','186','940',419,'Retail Sale Id 1285591',2520.00,0.00,0.00,0.00,248.00,'2021-12-06 07:51:40','',''),(2176279,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 07:51:40','',''),(2176294,'1','186','940',419,'Retail Sale Id 1285594',3150.00,0.00,0.00,0.00,310.00,'2021-12-06 07:52:14','',''),(2176295,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 07:52:14','',''),(2176331,'1','186','940',419,'Retail Sale Id 1285600',5040.00,0.00,0.00,0.00,496.00,'2021-12-06 07:52:55','',''),(2176332,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 07:52:55','',''),(2176339,'1','186','940',419,'Retail Sale Id 1285606',5040.00,0.00,0.00,0.00,496.00,'2021-12-06 07:53:26','',''),(2176340,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 07:53:26','',''),(2176345,'1','186','940',419,'Retail Sale Id 1285609',5040.00,0.00,0.00,0.00,496.00,'2021-12-06 07:53:58','',''),(2176346,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 07:53:58','',''),(2176369,'1','186','940',419,'Retail Sale Id 1285619',1156000.00,0.00,0.00,0.00,20000.00,'2021-12-06 07:55:02','',''),(2176370,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-06 07:55:02','',''),(2176416,'1','186','940',419,'Retail Sale Id 1285642',1156000.00,0.00,0.00,0.00,20000.00,'2021-12-06 07:57:06','',''),(2176417,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-06 07:57:06','',''),(2186816,'1','186','940',419,'Retail Sale Id 1290604',1734000.00,0.00,0.00,0.00,30000.00,'2021-12-06 21:49:45','',''),(2186817,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3000.00,0.00,'2021-12-06 21:49:45','',''),(2186818,'1','186','940',419,'Retail Sale Id 1290605',1618400.00,0.00,0.00,0.00,28000.00,'2021-12-06 21:51:37','',''),(2186819,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2800.00,0.00,'2021-12-06 21:51:37','',''),(2186832,'1','186','940',419,'Retail Sale Id 1290606',1885000.00,0.00,0.00,0.00,39000.00,'2021-12-06 21:54:07','',''),(2186833,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3250.00,0.00,'2021-12-06 21:54:07','',''),(2186847,'1','186','940',419,'Retail Sale Id 1290607',148050.00,0.00,0.00,0.00,14570.00,'2021-12-06 21:57:04','',''),(2186848,'1','186','940',419,'Retail sales',0.00,0.00,0.00,235.00,0.00,'2021-12-06 21:57:04','',''),(2188360,'1','186','940',419,'Retail Sale Id 1291259',3780.00,0.00,0.00,0.00,372.00,'2021-12-07 07:20:32','',''),(2188361,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 07:20:32','',''),(2188384,'1','186','940',419,'Retail Sale Id 1291267',4410.00,0.00,0.00,0.00,434.00,'2021-12-07 07:21:11','',''),(2188385,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 07:21:11','',''),(2188390,'1','186','940',419,'Retail Sale Id 1291270',7875.00,0.00,0.00,0.00,775.00,'2021-12-07 07:21:53','',''),(2188391,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:21:53','',''),(2188404,'1','186','940',419,'Retail Sale Id 1291278',9450.00,0.00,0.00,0.00,930.00,'2021-12-07 07:22:30','',''),(2188405,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-07 07:22:30','',''),(2188412,'1','186','940',419,'Retail Sale Id 1291285',5670.00,0.00,0.00,0.00,558.00,'2021-12-07 07:23:18','',''),(2188413,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-07 07:23:18','',''),(2188430,'1','186','940',419,'Retail Sale Id 1291291',4410.00,0.00,0.00,0.00,434.00,'2021-12-07 07:23:59','',''),(2188431,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-07 07:23:59','',''),(2188458,'1','186','940',419,'Retail Sale Id 1291302',5040.00,0.00,0.00,0.00,496.00,'2021-12-07 07:24:58','',''),(2188459,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 07:24:58','',''),(2188547,'1','186',NULL,419,'Reception corrector for bridging 126447',0.00,0.00,0.00,1950.00,0.00,'2021-12-07 07:28:52','',''),(2188548,'1','186','940',419,'Received from bridging 126447',0.00,0.00,1950.00,0.00,0.00,'2021-12-07 07:28:52','',''),(2188573,'1','186','940',419,'Retail Sale Id 1291357',1156000.00,0.00,0.00,0.00,20000.00,'2021-12-07 07:30:10','',''),(2188574,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-07 07:30:10','',''),(2199465,'1','186','940',419,'Retail Sale Id 1296754',320703.30,0.00,0.00,0.00,5548.50,'2021-12-07 21:22:12','',''),(2199466,'1','186','940',419,'Retail sales',0.00,0.00,0.00,554.85,0.00,'2021-12-07 21:22:12','',''),(2200913,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:337889',202492.00,0.00,0.00,356.50,0.00,'2021-12-08 07:28:34','',''),(2201109,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14217040.00,25030.00,0.00,0.00,'2021-12-08 07:36:48','',''),(2201138,'1','186',NULL,419,'Reception corrector for bridging 126553',0.00,0.00,0.00,23000.00,0.00,'2021-12-08 07:38:27','',''),(2201139,'1','186','940',419,'Received from bridging 126553',0.00,0.00,23000.00,0.00,0.00,'2021-12-08 07:38:27','',''),(2201168,'1','186','940',419,'Retail Sale Id 1297399',7875.00,0.00,0.00,0.00,775.00,'2021-12-08 07:40:44','',''),(2201169,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:40:44','',''),(2201176,'1','186','940',419,'Retail Sale Id 1297414',11970.00,0.00,0.00,0.00,1178.00,'2021-12-08 07:41:16','',''),(2201177,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-08 07:41:16','',''),(2201210,'1','186','940',419,'Retail Sale Id 1297429',5040.00,0.00,0.00,0.00,496.00,'2021-12-08 07:43:22','',''),(2201211,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 07:43:22','',''),(2201809,'1','186','940',419,'Retail Sale Id 1297437',11970.00,0.00,0.00,0.00,1178.00,'2021-12-08 08:16:34','',''),(2201810,'1','186','940',419,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-08 08:16:34','',''),(2201965,'1','186','940',419,'Retail Sale Id 1297723',5040.00,0.00,0.00,0.00,496.00,'2021-12-08 08:26:28','',''),(2201966,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 08:26:28','',''),(2208245,'1','186','940',419,'Retail Sale Id 1300677',2312000.00,0.00,0.00,0.00,40000.00,'2021-12-08 15:11:30','',''),(2208246,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4000.00,0.00,'2021-12-08 15:11:30','',''),(2214512,'1','186','940',419,'Retail Sale Id 1303545',867000.00,0.00,0.00,0.00,15000.00,'2021-12-09 08:24:04','',''),(2214513,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1500.00,0.00,'2021-12-09 08:24:04','',''),(2214557,'1','186','940',419,'Retail Sale Id 1303561',1023700.00,0.00,0.00,0.00,21180.00,'2021-12-09 08:25:28','',''),(2214558,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1765.00,0.00,'2021-12-09 08:25:28','',''),(2214681,'1','186','940',419,'Retail Sale Id 1303605',345807.00,0.00,0.00,0.00,34031.80,'2021-12-09 08:30:29','',''),(2214682,'1','186','940',419,'Retail sales',0.00,0.00,0.00,548.90,0.00,'2021-12-09 08:30:29','',''),(2214951,'1','186','940',419,'Retail Sale Id 1303744',7875.00,0.00,0.00,0.00,775.00,'2021-12-09 08:43:43','',''),(2214952,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:43:43','',''),(2214979,'1','186','940',419,'Retail Sale Id 1303753',11340.00,0.00,0.00,0.00,1116.00,'2021-12-09 08:44:34','',''),(2214980,'1','186','940',419,'Retail sales',0.00,0.00,0.00,18.00,0.00,'2021-12-09 08:44:34','',''),(2215102,'1','186','940',419,'Retail Sale Id 1303810',4410.00,0.00,0.00,0.00,434.00,'2021-12-09 08:52:08','',''),(2215103,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 08:52:08','',''),(2215188,'1','186','940',419,'Retail Sale Id 1303857',10080.00,0.00,0.00,0.00,992.00,'2021-12-09 08:57:54','',''),(2215189,'1','186','940',419,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-09 08:57:54','',''),(2215206,'1','186','940',419,'Retail Sale Id 1303866',10710.00,0.00,0.00,0.00,1054.00,'2021-12-09 08:59:02','',''),(2215207,'1','186','940',419,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-09 08:59:02','',''),(2215257,'1','186','940',419,'Retail Sale Id 1303874',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:01:24','',''),(2215258,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:01:24','',''),(2215299,'1','186','940',419,'Retail Sale Id 1303910',3150.00,0.00,0.00,0.00,310.00,'2021-12-09 09:03:32','',''),(2215300,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:03:32','',''),(2215330,'1','186','940',419,'Retail Sale Id 1303925',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:05:36','',''),(2215331,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:05:36','',''),(2215360,'1','186','940',419,'Retail Sale Id 1303944',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:07:49','',''),(2215361,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:07:49','',''),(2215438,'1','186','940',419,'Retail Sale Id 1303984',5040.00,0.00,0.00,0.00,496.00,'2021-12-09 09:12:21','',''),(2215439,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 09:12:21','',''),(2215448,'1','186','940',419,'Retail Sale Id 1303989',5040.00,0.00,0.00,0.00,496.00,'2021-12-09 09:13:26','',''),(2215449,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 09:13:26','',''),(2215493,'1','186','940',419,'Retail Sale Id 1304013',2312000.00,0.00,0.00,0.00,40000.00,'2021-12-09 09:16:26','',''),(2215494,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4000.00,0.00,'2021-12-09 09:16:26','',''),(2215511,'1','186','940',419,'Retail Sale Id 1304023',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:17:21','',''),(2215512,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:17:21','',''),(2215517,'1','186','940',419,'Retail Sale Id 1304027',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:17:56','',''),(2215518,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:17:56','',''),(2215529,'1','186','940',419,'Retail Sale Id 1304031',5040.00,0.00,0.00,0.00,496.00,'2021-12-09 09:18:45','',''),(2215530,'1','186','940',419,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 09:18:45','',''),(2215539,'1','186','940',419,'Retail Sale Id 1304036',7875.00,0.00,0.00,0.00,775.00,'2021-12-09 09:19:20','',''),(2215540,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:19:20','',''),(2215557,'1','186','940',419,'Retail Sale Id 1304044',3150.00,0.00,0.00,0.00,310.00,'2021-12-09 09:19:59','',''),(2215558,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 09:19:59','',''),(2215571,'1','186','940',419,'Retail Sale Id 1304052',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:20:49','',''),(2215572,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:20:49','',''),(2215581,'1','186','940',419,'Retail Sale Id 1304057',4410.00,0.00,0.00,0.00,434.00,'2021-12-09 09:21:21','',''),(2215582,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-09 09:21:21','',''),(2215591,'1','186','940',419,'Retail Sale Id 1304062',5670.00,0.00,0.00,0.00,558.00,'2021-12-09 09:22:09','',''),(2215592,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:22:09','',''),(2224711,'1','186','940',419,'Retail Sale Id 1308304',2890000.00,0.00,0.00,0.00,50000.00,'2021-12-09 21:21:51','',''),(2224712,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5000.00,0.00,'2021-12-09 21:21:51','',''),(2224717,'1','186','940',419,'Retail Sale Id 1308305',154980.00,0.00,0.00,0.00,15252.00,'2021-12-09 21:25:48','',''),(2224718,'1','186','940',419,'Retail sales',0.00,0.00,0.00,246.00,0.00,'2021-12-09 21:25:48','',''),(2224720,'1','186','940',419,'Retail Sale Id 1308306',2030000.00,0.00,0.00,0.00,42000.00,'2021-12-09 21:27:23','',''),(2224721,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3500.00,0.00,'2021-12-09 21:27:23','',''),(2226078,'1','186',NULL,419,'Reception corrector for bridging 126829',0.00,0.00,0.00,2030.00,0.00,'2021-12-10 07:19:05','',''),(2226079,'1','186','940',419,'Received from bridging 126829',0.00,0.00,2030.00,0.00,0.00,'2021-12-10 07:19:05','',''),(2226307,'1','186','940',419,'Retail Sale Id 1308952',2230848.80,0.00,0.00,0.00,38596.00,'2021-12-10 07:31:08','',''),(2226308,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3859.60,0.00,'2021-12-10 07:31:08','',''),(2240312,'1','186','940',419,'Distributed to AARANO for sales id:338727',202776.00,0.00,0.00,357.00,0.00,'2021-12-11 07:56:36','',''),(2240799,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14285200.00,25150.00,0.00,0.00,'2021-12-11 08:17:49','',''),(2240900,'1','186',NULL,419,'Reception corrector for bridging 126984',0.00,0.00,0.00,23000.00,0.00,'2021-12-11 08:22:39','',''),(2240901,'1','186','940',419,'Received from bridging 126984',0.00,0.00,23000.00,0.00,0.00,'2021-12-11 08:22:39','',''),(2241044,'1','186','940',419,'Retail Sale Id 1315688',1249751.60,0.00,0.00,0.00,21622.00,'2021-12-11 08:30:42','',''),(2241045,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2162.20,0.00,'2021-12-11 08:30:42','',''),(2241276,'1','186','940',419,'Return of Retail Sale Id 1315688',0.00,1249751.60,2162.20,0.00,-21622.00,'2021-12-11 08:42:17','',''),(2241323,'1','186','940',419,'Retail Sale Id 1315813',1249994.36,0.00,0.00,0.00,21626.20,'2021-12-11 08:44:02','',''),(2241324,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2162.62,0.00,'2021-12-11 08:44:02','',''),(2251802,'1','186','940',419,'Retail Sale Id 1320778',351225.00,0.00,0.00,0.00,34565.00,'2021-12-11 21:32:40','',''),(2251803,'1','186','940',419,'Retail sales',0.00,0.00,0.00,557.50,0.00,'2021-12-11 21:32:40','',''),(2251804,'1','186','940',419,'Retail Sale Id 1320779',2639000.00,0.00,0.00,0.00,54600.00,'2021-12-11 21:34:14','',''),(2251805,'1','186','940',419,'Retail sales',0.00,0.00,0.00,4550.00,0.00,'2021-12-11 21:34:14','',''),(2251806,'1','186','940',419,'Retail Sale Id 1320780',6074202.00,0.00,0.00,0.00,105090.00,'2021-12-11 21:35:49','',''),(2251807,'1','186','940',419,'Retail sales',0.00,0.00,0.00,10509.00,0.00,'2021-12-11 21:35:49','',''),(2251821,'1','186','940',419,'Return of Retail Sale Id 1320780',0.00,6074202.00,10509.00,0.00,-105090.00,'2021-12-11 21:37:44','',''),(2251822,'1','186','940',419,'Retail Sale Id 1320781',6069000.00,0.00,0.00,0.00,105000.00,'2021-12-11 21:38:46','',''),(2251823,'1','186','940',419,'Retail sales',0.00,0.00,0.00,10500.00,0.00,'2021-12-11 21:38:46','',''),(2254414,'1','186','940',419,'Retail Sale Id 1321961',7875.00,0.00,0.00,0.00,775.00,'2021-12-12 08:50:36','',''),(2254415,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 08:50:36','',''),(2254707,'1','186','940',419,'Retail Sale Id 1322046',5670.00,0.00,0.00,0.00,558.00,'2021-12-12 09:08:10','',''),(2254708,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-12 09:08:10','',''),(2254749,'1','186','940',419,'Retail Sale Id 1322123',5670.00,0.00,0.00,0.00,558.00,'2021-12-12 09:10:22','',''),(2254750,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-12 09:10:22','',''),(2254793,'1','186','940',419,'Retail Sale Id 1322140',9450.00,0.00,0.00,0.00,930.00,'2021-12-12 09:11:58','',''),(2254794,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-12 09:11:58','',''),(2255036,'1','186','940',419,'Retail Sale Id 1322279',4410.00,0.00,0.00,0.00,434.00,'2021-12-12 09:26:32','',''),(2255037,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 09:26:32','',''),(2255046,'1','186','940',419,'Retail Sale Id 1322285',4410.00,0.00,0.00,0.00,434.00,'2021-12-12 09:27:12','',''),(2255047,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-12 09:27:12','',''),(2255056,'1','186','940',419,'Retail Sale Id 1322288',5670.00,0.00,0.00,0.00,558.00,'2021-12-12 09:27:50','',''),(2255057,'1','186','940',419,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-12 09:27:50','',''),(2256395,'1','186','940',419,'Retail Sale Id 1322952',10710.00,0.00,0.00,0.00,1054.00,'2021-12-12 10:37:56','',''),(2256396,'1','186','940',419,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-12 10:37:56','',''),(2256423,'1','186','940',419,'Retail Sale Id 1322965',1734000.00,0.00,0.00,0.00,30000.00,'2021-12-12 10:39:00','',''),(2256424,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3000.00,0.00,'2021-12-12 10:39:00','',''),(2264750,'1','186',NULL,419,'Reception corrector for bridging 127200',0.00,0.00,0.00,2150.00,0.00,'2021-12-12 19:40:31','',''),(2264751,'1','186','940',419,'Received from bridging 127200',0.00,0.00,2150.00,0.00,0.00,'2021-12-12 19:40:31','',''),(2264773,'1','186','940',419,'Retail Sale Id 1326741',1156000.00,0.00,0.00,0.00,20000.00,'2021-12-12 19:42:18','',''),(2264774,'1','186','940',419,'Retail sales',0.00,0.00,0.00,2000.00,0.00,'2021-12-12 19:42:18','',''),(2264784,'1','186','940',419,'Retail Sale Id 1326742',2622423.97,0.00,0.00,0.00,1702610.45,'2021-12-12 19:44:39','',''),(2264785,'1','186','940',419,'Retail sales',0.00,0.00,0.00,1619.39,0.00,'2021-12-12 19:44:39','',''),(2264808,'1','186','940',419,'Retail Sale Id 1326743',201600.00,0.00,0.00,0.00,19840.00,'2021-12-12 19:45:45','',''),(2264809,'1','186','940',419,'Retail sales',0.00,0.00,0.00,320.00,0.00,'2021-12-12 19:45:45','',''),(2280431,'1','186','940',419,'Distributed to AARANO for sales id:339526',201634.32,0.00,0.00,354.99,0.00,'2021-12-14 09:24:39','',''),(2281377,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13210560.00,25020.00,0.00,0.00,'2021-12-14 10:18:09','',''),(2281458,'1','186',NULL,419,'Reception corrector for bridging 127333',0.00,0.00,0.00,23000.00,0.00,'2021-12-14 10:21:14','',''),(2281459,'1','186','940',419,'Received from bridging 127333',0.00,0.00,23000.00,0.00,0.00,'2021-12-14 10:21:14','',''),(2281602,'1','186','940',419,'Retail Sale Id 1334473',7700.00,0.00,0.00,0.00,1100.00,'2021-12-14 10:29:43','',''),(2281603,'1','186','940',419,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 10:29:43','',''),(2281642,'1','186','940',419,'Retail Sale Id 1334533',9240.00,0.00,0.00,0.00,1320.00,'2021-12-14 10:32:00','',''),(2281643,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-14 10:32:00','',''),(2281678,'1','186','940',419,'Retail Sale Id 1334550',3696.00,0.00,0.00,0.00,528.00,'2021-12-14 10:33:36','',''),(2281679,'1','186','940',419,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:33:36','',''),(2281694,'1','186','940',419,'Retail Sale Id 1334560',3080.00,0.00,0.00,0.00,440.00,'2021-12-14 10:34:25','',''),(2281695,'1','186','940',419,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 10:34:25','',''),(2281746,'1','186','940',419,'Retail Sale Id 1334589',4312.00,0.00,0.00,0.00,616.00,'2021-12-14 10:36:55','',''),(2281747,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-14 10:36:55','',''),(2281789,'1','186','940',419,'Retail Sale Id 1334613',4312.00,0.00,0.00,0.00,616.00,'2021-12-14 10:39:49','',''),(2281790,'1','186','940',419,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-14 10:39:49','',''),(2281818,'1','186','940',419,'Retail Sale Id 1334627',9240.00,0.00,0.00,0.00,1320.00,'2021-12-14 10:41:10','',''),(2281819,'1','186','940',419,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-14 10:41:10','',''),(2281866,'1','186','940',419,'Retail Sale Id 1334646',1674000.00,0.00,0.00,0.00,90000.00,'2021-12-14 10:43:35','',''),(2281867,'1','186','940',419,'Retail sales',0.00,0.00,0.00,3000.00,0.00,'2021-12-14 10:43:35','',''),(2281985,'1','186','940',419,'Retail Sale Id 1334711',279000.00,0.00,0.00,0.00,15000.00,'2021-12-14 10:50:54','',''),(2281986,'1','186','940',419,'Retail sales',0.00,0.00,0.00,500.00,0.00,'2021-12-14 10:50:54','',''),(2282287,'1','186','940',419,'Return of Retail Sale Id 1334627',0.00,9240.00,15.00,0.00,-1320.00,'2021-12-14 11:09:50','',''),(2282302,'1','186','940',419,'Return of Retail Sale Id 1334613',0.00,4312.00,7.00,0.00,-616.00,'2021-12-14 11:10:17','',''),(2282319,'1','186','940',419,'Return of Retail Sale Id 1334589',0.00,4312.00,7.00,0.00,-616.00,'2021-12-14 11:10:56','',''),(2282330,'1','186','940',419,'Return of Retail Sale Id 1334560',0.00,3080.00,5.00,0.00,-440.00,'2021-12-14 11:11:50','',''),(2282351,'1','186','940',419,'Return of Retail Sale Id 1334550',0.00,3696.00,6.00,0.00,-528.00,'2021-12-14 11:12:52','',''),(2282362,'1','186','940',419,'Return of Retail Sale Id 1334533',0.00,9240.00,15.00,0.00,-1320.00,'2021-12-14 11:13:28','',''),(2282398,'1','186','940',419,'Return of Retail Sale Id 1334473',0.00,7700.00,12.50,0.00,-1100.00,'2021-12-14 11:15:26','',''),(2282399,'1','186','940',419,'Return of Retail Sale Id 1334711',0.00,279000.00,500.00,0.00,-15000.00,'2021-12-14 11:16:51','',''),(2282400,'1','186','940',419,'Return of Retail Sale Id 1334646',0.00,1674000.00,3000.00,0.00,-90000.00,'2021-12-14 11:17:59','',''),(2282450,'1','186','940',419,'Retail Sale Id 1335328',1654994.52,0.00,0.00,2965.94,-172024.52,'2021-12-14 12:18:53','',''),(2282763,'1','186','940',419,'Retail Sale Id 1335609',130900.00,0.00,0.00,212.50,0.00,'2021-12-14 13:03:29','',''),(2282770,'1','186','940',419,'Retail Sale Id 1335616',4312.00,0.00,0.00,7.00,0.00,'2021-12-14 13:04:43','',''),(2282774,'1','186','940',419,'Retail Sale Id 1335621',4373.60,0.00,0.00,7.10,0.00,'2021-12-14 13:05:20','',''),(2282781,'1','186','940',419,'Retail Sale Id 1335629',5544.00,0.00,0.00,9.00,0.00,'2021-12-14 13:05:59','',''),(2282783,'1','186','940',419,'Retail Sale Id 1335635',3696.00,0.00,0.00,6.00,0.00,'2021-12-14 13:06:35','',''),(2282796,'1','186','940',419,'Retail Sale Id 1335640',9856.00,0.00,0.00,16.00,0.00,'2021-12-14 13:07:12','',''),(2282802,'1','186','940',419,'Retail Sale Id 1335646',306900.00,0.00,0.00,550.00,-31900.00,'2021-12-14 13:08:00','',''),(2285556,'1','186','940',419,'Retail Sale Id 1337636',976500.00,0.00,0.00,1750.00,-101500.00,'2021-12-14 21:45:22','',''),(2285557,'1','186','940',419,'Retail Sale Id 1337637',868000.00,0.00,0.00,1550.00,-86800.00,'2021-12-14 21:46:35','',''),(2285560,'1','186','940',419,'Retail Sale Id 1337638',158681.60,0.00,0.00,257.60,0.00,'2021-12-14 21:49:47','',''),(2285566,'1','186','940',419,'Retail Sale Id 1337639',48479.20,0.00,0.00,78.70,0.00,'2021-12-14 21:52:59','',''),(2285567,'1','186','940',419,'Return of Retail Sale Id 1337639',0.00,48479.20,78.70,0.00,0.00,'2021-12-14 21:54:11','',''),(2285569,'1','186','940',419,'Return of Retail Sale Id 1335640',0.00,9856.00,16.00,0.00,0.00,'2021-12-14 21:57:25','',''),(2285570,'1','186','940',419,'Return of Retail Sale Id 1337638',0.00,158681.60,257.60,0.00,0.00,'2021-12-14 21:58:40','',''),(2285579,'1','186','940',419,'Retail Sale Id 1337640',120058.40,0.00,0.00,194.90,0.00,'2021-12-14 22:01:25','',''),(2287217,'1','186','940',419,'Retail Sale Id 1338736',7700.00,0.00,0.00,12.50,0.00,'2021-12-15 08:30:23','',''),(2287227,'1','186','940',419,'Retail Sale Id 1338742',5544.00,0.00,0.00,9.00,0.00,'2021-12-15 08:31:34','',''),(2287273,'1','186','940',419,'Retail Sale Id 1338765',4928.00,0.00,0.00,8.00,0.00,'2021-12-15 08:34:57','',''),(2287285,'1','186','940',419,'Retail Sale Id 1338777',9240.00,0.00,0.00,15.00,0.00,'2021-12-15 08:36:25','',''),(2287309,'1','186','940',419,'Retail Sale Id 1338796',4312.00,0.00,0.00,7.00,0.00,'2021-12-15 08:38:52','',''),(2287345,'1','186','940',419,'Retail Sale Id 1338821',837000.00,0.00,0.00,1500.00,-87000.00,'2021-12-15 08:42:54','',''),(2287357,'1','186','940',419,'Retail Sale Id 1338840',4928.00,0.00,0.00,8.00,0.00,'2021-12-15 08:44:26','',''),(2292873,'1','186','940',419,'Retail Sale Id 1343183',534800.00,0.00,0.00,955.00,-53480.00,'2021-12-15 21:46:42','',''),(2292876,'1','186','940',419,'Retail Sale Id 1343186',158589.20,0.00,0.00,257.45,0.00,'2021-12-15 21:49:07','',''),(2294583,'1','186','940',419,'Retail Sale Id 1344368',7700.00,0.00,0.00,12.50,0.00,'2021-12-16 08:22:08','',''),(2294611,'1','186','940',419,'Retail Sale Id 1344385',11704.00,0.00,0.00,19.00,0.00,'2021-12-16 08:23:54','',''),(2294646,'1','186','940',419,'Retail Sale Id 1344405',11088.00,0.00,0.00,18.00,0.00,'2021-12-16 08:26:16','',''),(2294655,'1','186','940',419,'Retail Sale Id 1344413',9240.00,0.00,0.00,15.00,0.00,'2021-12-16 08:27:07','',''),(2294661,'1','186','940',419,'Retail Sale Id 1344421',3080.00,0.00,0.00,5.00,0.00,'2021-12-16 08:28:01','',''),(2295054,'1','186','940',419,'Retail Sale Id 1344701',4928.00,0.00,0.00,8.00,0.00,'2021-12-16 08:58:49','',''),(2295064,'1','186','940',419,'Retail Sale Id 1344708',5544.00,0.00,0.00,9.00,0.00,'2021-12-16 08:59:33','',''),(2295073,'1','186','940',419,'Retail Sale Id 1344720',2464.00,0.00,0.00,4.00,0.00,'2021-12-16 09:00:22','',''),(2295078,'1','186','940',419,'Retail Sale Id 1344726',11704.00,0.00,0.00,19.00,0.00,'2021-12-16 09:01:01','',''),(2295088,'1','186','940',419,'Retail Sale Id 1344736',4928.00,0.00,0.00,8.00,0.00,'2021-12-16 09:02:06','',''),(2295112,'1','186','940',419,'Retail Sale Id 1344755',3696.00,0.00,0.00,6.00,0.00,'2021-12-16 09:04:12','',''),(2295119,'1','186','940',419,'Retail Sale Id 1344763',41272.00,0.00,0.00,67.00,0.00,'2021-12-16 09:04:56','',''),(2295128,'1','186','940',419,'Retail Sale Id 1344772',11704.00,0.00,0.00,19.00,0.00,'2021-12-16 09:05:39','',''),(2295143,'1','186','940',419,'Retail Sale Id 1344780',4928.00,0.00,0.00,8.00,0.00,'2021-12-16 09:06:47','',''),(2295151,'1','186','940',419,'Retail Sale Id 1344792',4928.00,0.00,0.00,8.00,0.00,'2021-12-16 09:07:26','',''),(2295164,'1','186','940',419,'Retail Sale Id 1344805',9240.00,0.00,0.00,15.00,0.00,'2021-12-16 09:08:21','',''),(2295179,'1','186','940',419,'Retail Sale Id 1344813',10472.00,0.00,0.00,17.00,0.00,'2021-12-16 09:09:05','',''),(2295189,'1','186','940',419,'Retail Sale Id 1344821',11704.00,0.00,0.00,19.00,0.00,'2021-12-16 09:09:52','',''),(2295192,'1','186','940',419,'Retail Sale Id 1344825',9240.00,0.00,0.00,15.00,0.00,'2021-12-16 09:10:29','',''),(2295198,'1','186','940',419,'Retail Sale Id 1344831',9240.00,0.00,0.00,15.00,0.00,'2021-12-16 09:11:09','',''),(2295217,'1','186','940',419,'Retail Sale Id 1344850',1395000.00,0.00,0.00,2500.00,-145000.00,'2021-12-16 09:12:41','',''),(2302561,'1','186','940',419,'Retail Sale Id 1350458',728000.00,0.00,0.00,1300.00,-72800.00,'2021-12-17 08:21:52','',''),(2302783,'1','186','940',419,'Retail Sale Id 1350631',11704.00,0.00,0.00,19.00,0.00,'2021-12-17 08:40:59','',''),(2302805,'1','186','940',419,'Retail Sale Id 1350657',7700.00,0.00,0.00,12.50,0.00,'2021-12-17 08:43:16','',''),(2302831,'1','186','940',419,'Retail Sale Id 1350665',4928.00,0.00,0.00,8.00,0.00,'2021-12-17 08:45:21','',''),(2302869,'1','186','940',419,'Retail Sale Id 1350686',7700.00,0.00,0.00,12.50,0.00,'2021-12-17 08:47:08','',''),(2302935,'1','186','940',419,'Retail Sale Id 1350689',5544.00,0.00,0.00,9.00,0.00,'2021-12-17 08:52:15','',''),(2302955,'1','186','940',419,'Retail Sale Id 1350751',11704.00,0.00,0.00,19.00,0.00,'2021-12-17 08:53:52','',''),(2302978,'1','186','940',419,'Retail Sale Id 1350758',4312.00,0.00,0.00,7.00,0.00,'2021-12-17 08:54:52','',''),(2302988,'1','186','940',419,'Retail Sale Id 1350772',3696.00,0.00,0.00,6.00,0.00,'2021-12-17 08:56:47','',''),(2302995,'1','186','940',419,'Retail Sale Id 1350778',4312.00,0.00,0.00,7.00,0.00,'2021-12-17 08:57:37','',''),(2303236,'1','186','940',419,'Retail Sale Id 1350918',4312.00,0.00,0.00,7.00,0.00,'2021-12-17 09:15:29','',''),(2303244,'1','186','940',419,'Retail Sale Id 1350923',9240.00,0.00,0.00,15.00,0.00,'2021-12-17 09:16:58','',''),(2303272,'1','186','940',419,'Retail Sale Id 1350934',1400000.00,0.00,0.00,2500.00,-140000.00,'2021-12-17 09:19:57','',''),(2310412,'1','186','940',419,'Retail Sale Id 1356558',644000.00,0.00,0.00,1150.00,-64400.00,'2021-12-18 08:17:43','',''),(2310452,'1','186','940',419,'Retail Sale Id 1356598',123200.00,0.00,0.00,200.00,0.00,'2021-12-18 08:21:36','',''),(2310666,'1','186','940',419,'Retail Sale Id 1356762',7700.00,0.00,0.00,12.50,0.00,'2021-12-18 08:35:58','',''),(2310673,'1','186','940',419,'Retail Sale Id 1356768',5544.00,0.00,0.00,9.00,0.00,'2021-12-18 08:36:34','',''),(2310677,'1','186','940',419,'Retail Sale Id 1356773',3696.00,0.00,0.00,6.00,0.00,'2021-12-18 08:37:17','',''),(2310684,'1','186','940',419,'Retail Sale Id 1356779',3080.00,0.00,0.00,5.00,0.00,'2021-12-18 08:37:58','',''),(2310695,'1','186','940',419,'Retail Sale Id 1356792',4928.00,0.00,0.00,8.00,0.00,'2021-12-18 08:38:34','',''),(2310718,'1','186','940',419,'Retail Sale Id 1356801',5544.00,0.00,0.00,9.00,0.00,'2021-12-18 08:40:30','',''),(2310733,'1','186','940',419,'Retail Sale Id 1356828',4312.00,0.00,0.00,7.00,0.00,'2021-12-18 08:41:53','',''),(2310775,'1','186','940',419,'Retail Sale Id 1356865',5544.00,0.00,0.00,9.00,0.00,'2021-12-18 08:45:24','',''),(2310785,'1','186','940',419,'Retail Sale Id 1356874',6160.00,0.00,0.00,10.00,0.00,'2021-12-18 08:47:06','',''),(2310794,'1','186','940',419,'Retail Sale Id 1356886',5544.00,0.00,0.00,9.00,0.00,'2021-12-18 08:48:04','',''),(2310811,'1','186','940',419,'Retail Sale Id 1356902',3696.00,0.00,0.00,6.00,0.00,'2021-12-18 08:49:31','',''),(2310828,'1','186','940',419,'Retail Sale Id 1356921',11704.00,0.00,0.00,19.00,0.00,'2021-12-18 08:50:52','',''),(2310836,'1','186','940',419,'Retail Sale Id 1356932',11088.00,0.00,0.00,18.00,0.00,'2021-12-18 08:51:36','',''),(2310857,'1','186','940',419,'Retail Sale Id 1356941',837000.00,0.00,0.00,1500.00,-87000.00,'2021-12-18 08:53:15','',''),(2316778,'1','186','940',419,'Retail Sale Id 1362060',1674000.00,0.00,0.00,3000.00,-174000.00,'2021-12-18 16:56:11','',''),(2316793,'1','186','940',419,'Retail Sale Id 1362076',7700.00,0.00,0.00,12.50,0.00,'2021-12-18 16:57:28','',''),(2317675,'1','186',NULL,419,'Reception corrector for bridging 127920',0.00,0.00,0.00,2020.00,0.00,'2021-12-18 20:56:14','',''),(2317676,'1','186','940',419,'Received from bridging 127920',0.00,0.00,2020.00,0.00,0.00,'2021-12-18 20:56:14','',''),(2317687,'1','186','940',419,'Retail Sale Id 1362734',184800.00,0.00,0.00,300.00,0.00,'2021-12-18 21:05:06','',''),(2317690,'1','186','940',419,'Retail Sale Id 1362736',2627997.63,0.00,0.00,1621.11,1629393.87,'2021-12-18 21:08:12','',''),(2317710,'1','186','940',419,'Return of Retail Sale Id 1362736',0.00,2627997.63,1621.11,0.00,-1629393.87,'2021-12-18 21:12:58','',''),(2317721,'1','186','940',419,'Retail Sale Id 1362739',907821.60,0.00,0.00,1621.11,-90782.16,'2021-12-18 21:14:50','',''),(2325888,'1','186','940',419,'Distributed to AARANO for sales id:340891',219296.00,0.00,0.00,356.00,0.00,'2021-12-19 19:57:04','',''),(2325889,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13078560.00,24770.00,0.00,0.00,'2021-12-19 20:01:10','',''),(2325891,'1','186',NULL,419,'Reception corrector for bridging 128018',0.00,0.00,0.00,23000.00,0.00,'2021-12-19 20:04:25','',''),(2325892,'1','186','940',419,'Received from bridging 128018',0.00,0.00,23000.00,0.00,0.00,'2021-12-19 20:04:25','',''),(2326253,'1','186','940',419,'Retail Sale Id 1369646',1149978.00,0.00,0.00,2098.50,-109122.00,'2021-12-20 06:27:45','',''),(2326321,'1','186','940',419,'Retail Sale Id 1369687',7200.00,0.00,0.00,12.00,0.00,'2021-12-20 06:39:57','',''),(2326326,'1','186','940',419,'Retail Sale Id 1369693',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 06:40:41','',''),(2326331,'1','186','940',419,'Retail Sale Id 1369698',3600.00,0.00,0.00,6.00,0.00,'2021-12-20 06:41:42','',''),(2326339,'1','186','940',419,'Retail Sale Id 1369702',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 06:42:29','',''),(2326341,'1','186','940',419,'Retail Sale Id 1369704',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 06:43:12','',''),(2326344,'1','186','940',419,'Retail Sale Id 1369707',6000.00,0.00,0.00,10.00,0.00,'2021-12-20 06:43:52','',''),(2326347,'1','186','940',419,'Retail Sale Id 1369709',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 06:44:32','',''),(2326353,'1','186','940',419,'Retail Sale Id 1369717',6000.00,0.00,0.00,10.00,0.00,'2021-12-20 06:45:14','',''),(2326357,'1','186','940',419,'Retail Sale Id 1369720',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 06:45:53','',''),(2326363,'1','186','940',419,'Retail Sale Id 1369726',1644000.00,0.00,0.00,3000.00,-156000.00,'2021-12-20 06:46:56','',''),(2328553,'1','186','940',419,'Retail Sale Id 1371503',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 10:57:56','',''),(2328559,'1','186','940',419,'Retail Sale Id 1371508',3000.00,0.00,0.00,5.00,0.00,'2021-12-20 10:58:33','',''),(2328565,'1','186','940',419,'Retail Sale Id 1371515',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 10:59:09','',''),(2328573,'1','186','940',419,'Retail Sale Id 1371523',5400.00,0.00,0.00,9.00,0.00,'2021-12-20 10:59:54','',''),(2328581,'1','186','940',419,'Retail Sale Id 1371530',5400.00,0.00,0.00,9.00,0.00,'2021-12-20 11:00:35','',''),(2328590,'1','186','940',419,'Retail Sale Id 1371537',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 11:01:11','',''),(2328602,'1','186','940',419,'Retail Sale Id 1371546',5400.00,0.00,0.00,9.00,0.00,'2021-12-20 11:02:09','',''),(2328606,'1','186','940',419,'Retail Sale Id 1371550',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 11:02:44','',''),(2328632,'1','186','940',419,'Retail Sale Id 1371563',9000.00,0.00,0.00,15.00,0.00,'2021-12-20 11:04:48','',''),(2328647,'1','186','940',419,'Retail Sale Id 1371585',4800.00,0.00,0.00,8.00,0.00,'2021-12-20 11:05:44','',''),(2328655,'1','186','940',419,'Retail Sale Id 1371593',4800.00,0.00,0.00,8.00,0.00,'2021-12-20 11:06:31','',''),(2328666,'1','186','940',419,'Retail Sale Id 1371604',1096000.00,0.00,0.00,2000.00,-104000.00,'2021-12-20 11:07:52','',''),(2333195,'1','186','940',419,'Retail Sale Id 1374938',60000.00,0.00,0.00,100.00,0.00,'2021-12-20 21:16:37','',''),(2333204,'1','186','940',419,'Retail Sale Id 1374940',1787500.00,0.00,0.00,3250.00,-162500.00,'2021-12-20 21:19:32','',''),(2333206,'1','186','940',419,'Retail Sale Id 1374941',1370000.00,0.00,0.00,2500.00,-130000.00,'2021-12-20 21:21:05','',''),(2334601,'1','186','940',419,'Retail Sale Id 1376014',75000.00,0.00,0.00,125.00,0.00,'2021-12-21 08:33:01','',''),(2334615,'1','186','940',419,'Retail Sale Id 1376025',1644000.00,0.00,0.00,3000.00,-156000.00,'2021-12-21 08:35:06','',''),(2334662,'1','186','940',419,'Retail Sale Id 1376084',10200.00,0.00,0.00,17.00,0.00,'2021-12-21 08:44:03','',''),(2334666,'1','186','940',419,'Retail Sale Id 1376089',3600.00,0.00,0.00,6.00,0.00,'2021-12-21 08:45:11','',''),(2334670,'1','186','940',419,'Retail Sale Id 1376093',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 08:46:02','',''),(2334682,'1','186','940',419,'Retail Sale Id 1376097',3600.00,0.00,0.00,6.00,0.00,'2021-12-21 08:46:58','',''),(2334693,'1','186','940',419,'Retail Sale Id 1376111',11400.00,0.00,0.00,19.00,0.00,'2021-12-21 08:47:39','',''),(2334702,'1','186','940',419,'Retail Sale Id 1376118',7500.00,0.00,0.00,12.50,0.00,'2021-12-21 08:49:06','',''),(2334727,'1','186','940',419,'Retail Sale Id 1376127',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 08:50:31','',''),(2334755,'1','186','940',419,'Retail Sale Id 1376135',10800.00,0.00,0.00,18.00,0.00,'2021-12-21 08:52:44','',''),(2334777,'1','186','940',419,'Retail Sale Id 1376150',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 08:55:48','',''),(2334786,'1','186','940',419,'Retail Sale Id 1376163',10800.00,0.00,0.00,18.00,0.00,'2021-12-21 08:57:01','',''),(2334791,'1','186','940',419,'Retail Sale Id 1376167',5400.00,0.00,0.00,9.00,0.00,'2021-12-21 08:57:49','',''),(2334809,'1','186','940',419,'Retail Sale Id 1376185',600.00,0.00,0.00,1.00,0.00,'2021-12-21 08:59:52','',''),(2334818,'1','186','940',419,'Retail Sale Id 1376194',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 09:01:44','',''),(2334966,'1','186','940',419,'Retail Sale Id 1376330',4200.00,0.00,0.00,7.00,0.00,'2021-12-21 09:20:00','',''),(2335057,'1','186','940',419,'Retail Sale Id 1376381',11400.00,0.00,0.00,19.00,0.00,'2021-12-21 09:26:05','',''),(2335084,'1','186','940',419,'Retail Sale Id 1376403',5400.00,0.00,0.00,9.00,0.00,'2021-12-21 09:30:07','',''),(2335094,'1','186','940',419,'Retail Sale Id 1376418',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 09:31:57','',''),(2335106,'1','186','940',419,'Retail Sale Id 1376440',11400.00,0.00,0.00,19.00,0.00,'2021-12-21 09:33:20','',''),(2335131,'1','186','940',419,'Retail Sale Id 1376447',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 09:35:51','',''),(2335144,'1','186','940',419,'Retail Sale Id 1376464',9000.00,0.00,0.00,15.00,0.00,'2021-12-21 09:36:47','',''),(2340953,'1','186','940',419,'Retail Sale Id 1381118',825000.00,0.00,0.00,1500.00,-75000.00,'2021-12-21 21:15:47','',''),(2340954,'1','186','940',419,'Retail Sale Id 1381119',274000.00,0.00,0.00,500.00,-26000.00,'2021-12-21 21:17:47','',''),(2344479,'1','186',NULL,419,'Reception corrector for bridging 128321',0.00,0.00,0.00,1770.00,0.00,'2021-12-22 10:52:41','',''),(2344480,'1','186','940',419,'Received from bridging 128321',0.00,0.00,1770.00,0.00,0.00,'2021-12-22 10:52:41','',''),(2359949,'1','186','940',419,'Retail Sale Id 1396308',1644000.00,0.00,0.00,3000.00,-156000.00,'2021-12-24 08:31:17','',''),(2359991,'1','186','940',419,'Retail Sale Id 1396320',7500.00,0.00,0.00,12.50,0.00,'2021-12-24 08:32:06','',''),(2364834,'1','186','940',419,'Retail Sale Id 1400577',13800.00,0.00,0.00,23.00,0.00,'2021-12-24 14:58:35','',''),(2364850,'1','186','940',419,'Retail Sale Id 1400587',9000.00,0.00,0.00,15.00,0.00,'2021-12-24 14:59:38','',''),(2364870,'1','186','940',419,'Retail Sale Id 1400599',7500.00,0.00,0.00,12.50,0.00,'2021-12-24 15:00:25','',''),(2364892,'1','186','940',419,'Retail Sale Id 1400615',1370000.00,0.00,0.00,2500.00,-130000.00,'2021-12-24 15:02:26','',''),(2367840,'1','186','940',419,'Retail Sale Id 1402962',60000.00,0.00,0.00,100.00,0.00,'2021-12-24 21:58:24','',''),(2367841,'1','186','940',419,'Retail Sale Id 1402963',54800.00,0.00,0.00,100.00,-5200.00,'2021-12-24 22:00:44','',''),(2372057,'1','186','940',419,'Distributed to AARANO for sales id:342244',259200.00,0.00,0.00,432.00,0.00,'2021-12-25 12:40:27','',''),(2372138,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13173600.00,24950.00,0.00,0.00,'2021-12-25 12:49:00','',''),(2372237,'1','186',NULL,419,'Reception corrector for bridging 128733',0.00,0.00,0.00,23000.00,0.00,'2021-12-25 12:59:18','',''),(2372238,'1','186','940',419,'Received from bridging 128733',0.00,0.00,23000.00,0.00,0.00,'2021-12-25 12:59:18','',''),(2373293,'1','186','940',419,'Retail Sale Id 1407567',59400.00,0.00,0.00,99.00,7128.00,'2021-12-25 14:37:53','',''),(2373305,'1','186','940',419,'Retail Sale Id 1407578',5400.00,0.00,0.00,9.00,648.00,'2021-12-25 14:40:13','',''),(2373313,'1','186','940',419,'Retail Sale Id 1407585',2192000.00,0.00,0.00,4000.00,80000.00,'2021-12-25 14:41:20','',''),(2373329,'1','186','940',419,'Retail Sale Id 1407598',9000.00,0.00,0.00,15.00,1080.00,'2021-12-25 14:44:35','',''),(2373337,'1','186','940',419,'Retail Sale Id 1407610',11400.00,0.00,0.00,19.00,1368.00,'2021-12-25 14:45:48','',''),(2373345,'1','186','940',419,'Retail Sale Id 1407617',9000.00,0.00,0.00,15.00,1080.00,'2021-12-25 14:47:03','',''),(2373351,'1','186','940',419,'Retail Sale Id 1407625',5400.00,0.00,0.00,9.00,648.00,'2021-12-25 14:47:48','',''),(2373358,'1','186','940',419,'Retail Sale Id 1407630',4800.00,0.00,0.00,8.00,576.00,'2021-12-25 14:49:13','',''),(2373378,'1','186','940',419,'Retail Sale Id 1407649',11400.00,0.00,0.00,19.00,1368.00,'2021-12-25 14:53:03','',''),(2373386,'1','186','940',419,'Retail Sale Id 1407659',3780.00,0.00,0.00,6.30,453.60,'2021-12-25 14:54:20','',''),(2374617,'1','186','940',419,'Retail Sale Id 1408422',849400.00,0.00,0.00,1550.00,31000.00,'2021-12-25 21:45:05','',''),(2374639,'1','186','940',419,'Retail Sale Id 1408423',132000.00,0.00,0.00,220.00,15840.00,'2021-12-25 21:49:50','',''),(2375504,'1','186','940',419,'Retail Sale Id 1408924',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 07:58:25','',''),(2375608,'1','186','940',419,'Retail Sale Id 1409006',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 08:08:39','',''),(2375637,'1','186','940',419,'Retail Sale Id 1409021',6000.00,0.00,0.00,10.00,720.00,'2021-12-26 08:12:58','',''),(2375651,'1','186','940',419,'Retail Sale Id 1409045',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 08:13:55','',''),(2375668,'1','186','940',419,'Retail Sale Id 1409059',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 08:15:40','',''),(2375696,'1','186','940',419,'Retail Sale Id 1409065',6000.00,0.00,0.00,10.00,720.00,'2021-12-26 08:16:44','',''),(2375719,'1','186','940',419,'Retail Sale Id 1409075',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 08:18:35','',''),(2375721,'1','186','940',419,'Retail Sale Id 1409078',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 08:19:20','',''),(2376640,'1','186','940',419,'Retail Sale Id 1409820',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 09:58:00','',''),(2376650,'1','186','940',419,'Retail Sale Id 1409830',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 09:58:55','',''),(2376663,'1','186','940',419,'Retail Sale Id 1409842',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 10:00:37','',''),(2376671,'1','186','940',419,'Retail Sale Id 1409850',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 10:01:21','',''),(2376676,'1','186','940',419,'Retail Sale Id 1409855',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 10:02:02','',''),(2376684,'1','186','940',419,'Retail Sale Id 1409864',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 10:02:45','',''),(2376691,'1','186','940',419,'Retail Sale Id 1409871',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 10:03:37','',''),(2376698,'1','186','940',419,'Retail Sale Id 1409878',7500.00,0.00,0.00,12.50,900.00,'2021-12-26 10:04:22','',''),(2376755,'1','186','940',419,'Retail Sale Id 1409933',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 10:13:05','',''),(2376758,'1','186','940',419,'Retail Sale Id 1409936',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 10:13:44','',''),(2376763,'1','186','940',419,'Retail Sale Id 1409941',3600.00,0.00,0.00,6.00,432.00,'2021-12-26 10:14:30','',''),(2376772,'1','186','940',419,'Retail Sale Id 1409945',11400.00,0.00,0.00,19.00,1368.00,'2021-12-26 10:16:31','',''),(2376777,'1','186','940',419,'Retail Sale Id 1409957',9000.00,0.00,0.00,15.00,1080.00,'2021-12-26 10:17:18','',''),(2376785,'1','186','940',419,'Retail Sale Id 1409964',60000.00,0.00,0.00,100.00,7200.00,'2021-12-26 10:18:03','',''),(2376794,'1','186','940',419,'Retail Sale Id 1409973',2160000.00,0.00,0.00,4000.00,48000.00,'2021-12-26 10:19:47','',''),(2380391,'1','186','940',419,'Retail Sale Id 1412594',2690000.00,0.00,0.00,5000.00,-210000.00,'2021-12-26 21:45:45','',''),(2380394,'1','186','940',419,'Retail Sale Id 1412595',1917000.00,0.00,0.00,3550.00,-142000.00,'2021-12-26 21:51:03','',''),(2380397,'1','186','940',419,'Retail Sale Id 1412596',89900.00,0.00,0.00,155.00,0.00,'2021-12-26 21:55:02','',''),(2380401,'1','186',NULL,419,'Reception corrector for bridging 128852',0.00,0.00,0.00,1950.00,0.00,'2021-12-26 21:58:10','',''),(2380402,'1','186','940',419,'Received from bridging 128852',0.00,0.00,1950.00,0.00,0.00,'2021-12-26 21:58:10','',''),(2380744,'1','186','940',419,'Retail Sale Id 1412802',2152000.00,0.00,0.00,4000.00,-168000.00,'2021-12-27 07:15:06','',''),(2381129,'1','186','940',419,'Retail Sale Id 1413024',8700.00,0.00,0.00,15.00,0.00,'2021-12-27 07:47:11','',''),(2381141,'1','186','940',419,'Retail Sale Id 1413041',7250.00,0.00,0.00,12.50,0.00,'2021-12-27 07:48:23','',''),(2381162,'1','186','940',419,'Retail Sale Id 1413053',5800.00,0.00,0.00,10.00,0.00,'2021-12-27 07:49:54','',''),(2381176,'1','186','940',419,'Retail Sale Id 1413060',5800.00,0.00,0.00,10.00,0.00,'2021-12-27 07:50:41','',''),(2381181,'1','186','940',419,'Retail Sale Id 1413067',7250.00,0.00,0.00,12.50,0.00,'2021-12-27 07:51:21','',''),(2382991,'1','186','940',419,'Retail Sale Id 1414697',8700.00,0.00,0.00,15.00,0.00,'2021-12-27 10:38:52','',''),(2383003,'1','186','940',419,'Retail Sale Id 1414710',8700.00,0.00,0.00,15.00,0.00,'2021-12-27 10:40:05','',''),(2386641,'1','186','940',419,'Retail Sale Id 1417383',779562.00,0.00,0.00,1449.00,-60858.00,'2021-12-28 06:34:12','',''),(2386683,'1','186','940',419,'Retail Sale Id 1417393',7250.00,0.00,0.00,12.50,0.00,'2021-12-28 06:41:20','',''),(2386691,'1','186','940',419,'Retail Sale Id 1417400',5800.00,0.00,0.00,10.00,0.00,'2021-12-28 06:42:59','',''),(2386695,'1','186','940',419,'Retail Sale Id 1417404',8700.00,0.00,0.00,15.00,0.00,'2021-12-28 06:43:52','',''),(2386700,'1','186','940',419,'Retail Sale Id 1417407',7250.00,0.00,0.00,12.50,0.00,'2021-12-28 06:45:04','',''),(2391359,'1','186','940',419,'Return of Retail Sale Id 1417407',0.00,7250.00,12.50,0.00,0.00,'2021-12-28 14:41:21','',''),(2391362,'1','186','940',419,'Return of Retail Sale Id 1417404',0.00,8700.00,15.00,0.00,0.00,'2021-12-28 14:41:58','',''),(2391372,'1','186','940',419,'Return of Retail Sale Id 1417400',0.00,5800.00,10.00,0.00,0.00,'2021-12-28 14:42:42','',''),(2391377,'1','186','940',419,'Return of Retail Sale Id 1417393',0.00,7250.00,12.50,0.00,0.00,'2021-12-28 14:43:12','',''),(2391467,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:342723',206886.00,0.00,0.00,356.70,0.00,'2021-12-28 14:56:36','',''),(2391512,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13189440.00,24980.00,0.00,0.00,'2021-12-28 15:03:36','',''),(2391543,'1','186',NULL,419,'Reception corrector for bridging 129017',0.00,0.00,0.00,23000.00,0.00,'2021-12-28 15:05:35','',''),(2391544,'1','186','940',419,'Received from bridging 129017',0.00,0.00,23000.00,0.00,0.00,'2021-12-28 15:05:35','',''),(2393069,'1','186','940',419,'Retail Sale Id 1422414',265060.00,0.00,0.00,457.00,23764.00,'2021-12-28 21:15:23','',''),(2393070,'1','186','940',419,'Retail Sale Id 1422415',2152000.00,0.00,0.00,4000.00,40000.00,'2021-12-28 21:18:18','',''),(2393071,'1','186','940',419,'Retail Sale Id 1422416',1350000.00,0.00,0.00,2500.00,30000.00,'2021-12-28 21:20:57','',''),(2394101,'1','186','940',419,'Retail Sale Id 1423014',538000.00,0.00,0.00,1000.00,10000.00,'2021-12-29 07:49:46','',''),(2394144,'1','186','940',419,'Retail Sale Id 1423035',1345000.00,0.00,0.00,2500.00,25000.00,'2021-12-29 07:52:23','',''),(2394149,'1','186','940',419,'Retail Sale Id 1423039',7250.00,0.00,0.00,12.50,650.00,'2021-12-29 07:53:01','',''),(2394165,'1','186','940',419,'Retail Sale Id 1423049',7250.00,0.00,0.00,12.50,650.00,'2021-12-29 07:54:15','',''),(2399738,'1','186','940',419,'Retail Sale Id 1427363',2156842.00,0.00,0.00,4009.00,40090.00,'2021-12-29 20:40:18','',''),(2399741,'1','186','940',419,'Retail Sale Id 1427364',1620000.00,0.00,0.00,3000.00,36000.00,'2021-12-29 20:41:57','',''),(2399757,'1','186','940',419,'Retail Sale Id 1427365',290000.00,0.00,0.00,500.00,26000.00,'2021-12-29 20:57:04','',''),(2400578,'1','186','940',419,'Retail Sale Id 1427773',1076000.00,0.00,0.00,2000.00,20000.00,'2021-12-30 07:23:45','',''),(2400584,'1','186','940',419,'Retail Sale Id 1427779',38860.00,0.00,0.00,67.00,3484.00,'2021-12-30 07:24:48','',''),(2402276,'1','186','940',419,'Retail Sale Id 1429080',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 09:52:48','',''),(2402287,'1','186','940',419,'Retail Sale Id 1429098',7250.00,0.00,0.00,12.50,650.00,'2021-12-30 09:53:42','',''),(2402292,'1','186','940',419,'Retail Sale Id 1429106',11020.00,0.00,0.00,19.00,988.00,'2021-12-30 09:54:18','',''),(2402302,'1','186','940',419,'Retail Sale Id 1429114',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 09:54:59','',''),(2402309,'1','186','940',419,'Retail Sale Id 1429121',31900.00,0.00,0.00,55.00,2860.00,'2021-12-30 09:55:48','',''),(2402315,'1','186','940',419,'Retail Sale Id 1429127',7250.00,0.00,0.00,12.50,650.00,'2021-12-30 09:56:27','',''),(2402353,'1','186','940',419,'Retail Sale Id 1429167',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 09:59:24','',''),(2402360,'1','186','940',419,'Retail Sale Id 1429173',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:00:01','',''),(2402368,'1','186','940',419,'Retail Sale Id 1429183',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:00:59','',''),(2402375,'1','186','940',419,'Retail Sale Id 1429189',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:01:31','',''),(2402389,'1','186','940',419,'Retail Sale Id 1429202',11020.00,0.00,0.00,19.00,988.00,'2021-12-30 10:02:44','',''),(2402399,'1','186','940',419,'Retail Sale Id 1429212',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:04:03','',''),(2402402,'1','186','940',419,'Retail Sale Id 1429216',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:04:39','',''),(2402413,'1','186','940',419,'Retail Sale Id 1429228',11020.00,0.00,0.00,19.00,988.00,'2021-12-30 10:05:41','',''),(2402419,'1','186','940',419,'Retail Sale Id 1429233',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:06:32','',''),(2402437,'1','186','940',419,'Retail Sale Id 1429252',8700.00,0.00,0.00,15.00,780.00,'2021-12-30 10:07:53','',''),(2402446,'1','186','940',419,'Retail Sale Id 1429260',7250.00,0.00,0.00,12.50,650.00,'2021-12-30 10:08:34','',''),(2402458,'1','186','940',419,'Retail Sale Id 1429270',11020.00,0.00,0.00,19.00,988.00,'2021-12-30 10:10:09','',''),(2407127,'1','186','940',419,'Retail Sale Id 1432901',1076000.00,0.00,0.00,2000.00,20000.00,'2021-12-30 22:03:26','',''),(2407136,'1','186',NULL,419,'Reception corrector for bridging 129289',0.00,0.00,0.00,1980.00,0.00,'2021-12-30 22:07:53','',''),(2407137,'1','186','940',419,'Received from bridging 129289',0.00,0.00,1980.00,0.00,0.00,'2021-12-30 22:07:53','',''),(2407141,'1','186','940',419,'Retail Sale Id 1432906',1104300.00,0.00,0.00,2045.00,24540.00,'2021-12-30 22:11:35','',''),(2407142,'1','186','940',419,'Retail Sale Id 1432907',116000.00,0.00,0.00,200.00,10400.00,'2021-12-30 22:13:24','',''),(2410123,'1','186','940',419,'Return of Retail Sale Id 1432907',0.00,116000.00,200.00,0.00,-10400.00,'2021-12-31 10:50:55','',''),(2410167,'1','186','940',419,'Retail Sale Id 1435354',107600.00,0.00,0.00,200.00,2000.00,'2021-12-31 10:56:03','',''),(2410558,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:343317',189288.00,0.00,0.00,358.50,0.00,'2021-12-31 11:39:37','',''),(2412222,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13210560.00,25020.00,0.00,0.00,'2021-12-31 14:53:56','',''),(2412264,'1','186',NULL,419,'Reception corrector for bridging 129330',0.00,0.00,0.00,23000.00,0.00,'2021-12-31 14:58:39','',''),(2412265,'1','186','940',419,'Received from bridging 129330',0.00,0.00,23000.00,0.00,0.00,'2021-12-31 14:58:39','',''),(2412273,'1','186','940',419,'Retail Sale Id 1437216',5800.00,0.00,0.00,10.00,520.00,'2021-12-31 14:59:27','',''),(2412282,'1','186','940',419,'Retail Sale Id 1437233',7250.00,0.00,0.00,12.50,650.00,'2021-12-31 15:00:20','',''),(2412287,'1','186','940',419,'Retail Sale Id 1437238',7250.00,0.00,0.00,12.50,650.00,'2021-12-31 15:01:01','',''),(2412291,'1','186','940',419,'Retail Sale Id 1437241',5800.00,0.00,0.00,10.00,520.00,'2021-12-31 15:01:36','',''),(2412297,'1','186','940',419,'Retail Sale Id 1437245',5800.00,0.00,0.00,10.00,520.00,'2021-12-31 15:02:22','',''),(2412306,'1','186','940',419,'Retail Sale Id 1437255',580.00,0.00,0.00,1.00,52.00,'2021-12-31 15:03:14','',''),(2412312,'1','186','940',419,'Retail Sale Id 1437262',7250.00,0.00,0.00,12.50,650.00,'2021-12-31 15:03:48','',''),(2412321,'1','186','940',419,'Retail Sale Id 1437270',1554000.00,0.00,0.00,3000.00,-30000.00,'2021-12-31 15:05:25','',''),(2414294,'1','186','940',419,'Retail Sale Id 1438822',1820000.00,0.00,0.00,3500.00,-28000.00,'2021-12-31 21:41:09','',''),(2414295,'1','186','940',419,'Retail Sale Id 1438823',1036000.00,0.00,0.00,2000.00,-20000.00,'2021-12-31 21:43:44','',''),(2414296,'1','186','940',419,'Retail Sale Id 1438824',174000.00,0.00,0.00,300.00,15600.00,'2021-12-31 21:46:47','',''),(2416904,'1','186','940',419,'Retail Sale Id 1440934',112000.00,0.00,0.00,200.00,0.00,'2022-01-01 10:30:09','',''),(2416995,'1','186','940',419,'Retail Sale Id 1441007',8400.00,0.00,0.00,15.00,0.00,'2022-01-01 10:40:09','',''),(2417003,'1','186','940',419,'Retail Sale Id 1441015',8400.00,0.00,0.00,15.00,0.00,'2022-01-01 10:41:02','',''),(2417009,'1','186','940',419,'Retail Sale Id 1441020',10640.00,0.00,0.00,19.00,0.00,'2022-01-01 10:41:38','',''),(2417017,'1','186','940',419,'Retail Sale Id 1441029',10640.00,0.00,0.00,19.00,0.00,'2022-01-01 10:42:21','',''),(2417039,'1','186','940',419,'Retail Sale Id 1441048',10640.00,0.00,0.00,19.00,0.00,'2022-01-01 10:44:45','',''),(2417050,'1','186','940',419,'Retail Sale Id 1441058',10640.00,0.00,0.00,19.00,0.00,'2022-01-01 10:45:37','',''),(2417055,'1','186','940',419,'Retail Sale Id 1441062',8400.00,0.00,0.00,15.00,0.00,'2022-01-01 10:46:28','',''),(2417080,'1','186','940',419,'Retail Sale Id 1441085',3360.00,0.00,0.00,6.00,0.00,'2022-01-01 10:48:30','',''),(2417095,'1','186','940',419,'Retail Sale Id 1441096',8400.00,0.00,0.00,15.00,0.00,'2022-01-01 10:49:27','',''),(2417108,'1','186','940',419,'Retail Sale Id 1441106',4480.00,0.00,0.00,8.00,0.00,'2022-01-01 10:50:37','',''),(2417130,'1','186','940',419,'Retail Sale Id 1441125',10640.00,0.00,0.00,19.00,0.00,'2022-01-01 10:53:24','',''),(2417136,'1','186','940',419,'Retail Sale Id 1441131',4480.00,0.00,0.00,8.00,0.00,'2022-01-01 10:54:32','',''),(2417146,'1','186','940',419,'Retail Sale Id 1441142',10080.00,0.00,0.00,18.00,0.00,'2022-01-01 10:55:35','',''),(2417237,'1','186','940',419,'Retail Sale Id 1441158',2072000.00,0.00,0.00,4000.00,-168000.00,'2022-01-01 11:04:38','',''),(2420547,'1','186','940',419,'Retail Sale Id 1443774',1295000.00,0.00,0.00,2500.00,-105000.00,'2022-01-01 22:00:22','',''),(2420548,'1','186','940',419,'Retail Sale Id 1443775',1586000.00,0.00,0.00,3050.00,-122000.00,'2022-01-01 22:02:00','',''),(2420549,'1','186','940',419,'Retail Sale Id 1443776',176400.00,0.00,0.00,315.00,0.00,'2022-01-01 22:04:57','',''),(2422097,'1','186','940',419,'Retail Sale Id 1444970',1036000.00,0.00,0.00,2000.00,-84000.00,'2022-01-02 09:33:18','',''),(2422104,'1','186','940',419,'Retail Sale Id 1444978',30800.00,0.00,0.00,55.00,0.00,'2022-01-02 09:34:07','',''),(2423042,'1','186','940',419,'Retail Sale Id 1445814',5040.00,0.00,0.00,9.00,0.00,'2022-01-02 11:14:50','',''),(2423053,'1','186','940',419,'Retail Sale Id 1445827',7000.00,0.00,0.00,12.50,0.00,'2022-01-02 11:15:57','',''),(2423061,'1','186','940',419,'Retail Sale Id 1445835',5040.00,0.00,0.00,9.00,0.00,'2022-01-02 11:17:01','',''),(2423067,'1','186','940',419,'Retail Sale Id 1445841',8400.00,0.00,0.00,15.00,0.00,'2022-01-02 11:17:55','',''),(2423092,'1','186','940',419,'Retail Sale Id 1445857',7000.00,0.00,0.00,12.50,0.00,'2022-01-02 11:19:28','',''),(2423099,'1','186','940',419,'Retail Sale Id 1445867',8400.00,0.00,0.00,15.00,0.00,'2022-01-02 11:20:21','',''),(2423110,'1','186','940',419,'Retail Sale Id 1445877',10640.00,0.00,0.00,19.00,0.00,'2022-01-02 11:21:18','',''),(2426182,'1','186',NULL,419,'Reception corrector for bridging 129516',0.00,0.00,0.00,2020.00,0.00,'2022-01-02 20:55:37','',''),(2426183,'1','186','940',419,'Received from bridging 129516',0.00,0.00,2020.00,0.00,0.00,'2022-01-02 20:55:37','',''),(2426188,'1','186','940',419,'Retail Sale Id 1448502',1036000.00,0.00,0.00,2000.00,-84000.00,'2022-01-02 21:01:53','',''),(2426195,'1','186','940',419,'Retail Sale Id 1448509',676000.00,0.00,0.00,1300.00,-52000.00,'2022-01-02 21:05:43','',''),(2426198,'1','186','940',419,'Retail Sale Id 1448511',49560.00,0.00,0.00,88.50,0.00,'2022-01-02 21:07:10','',''),(2427741,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:343793',199360.00,0.00,0.00,356.00,0.00,'2022-01-03 09:20:11','',''),(2435277,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12880150.00,25010.00,0.00,0.00,'2022-01-04 10:23:36','',''),(2435295,'1','186',NULL,419,'Reception corrector for bridging 129666',0.00,0.00,0.00,23000.00,0.00,'2022-01-04 10:25:52','',''),(2435296,'1','186','940',419,'Received from bridging 129666',0.00,0.00,23000.00,0.00,0.00,'2022-01-04 10:25:52','',''),(2435318,'1','186','940',419,'Retail Sale Id 1455746',958300.00,0.00,0.00,1850.00,5550.00,'2022-01-04 10:27:11','',''),(2435400,'1','186','940',419,'Retail Sale Id 1455807',2072000.00,0.00,0.00,4000.00,12000.00,'2022-01-04 10:33:16','',''),(2435414,'1','186','940',419,'Retail Sale Id 1455821',86800.00,0.00,0.00,155.00,6975.00,'2022-01-04 10:34:50','',''),(2437112,'1','186','940',419,'Retail Sale Id 1457434',8400.00,0.00,0.00,15.00,675.00,'2022-01-04 13:26:34','',''),(2437123,'1','186','940',419,'Retail Sale Id 1457442',7000.00,0.00,0.00,12.50,562.50,'2022-01-04 13:27:53','',''),(2437136,'1','186','940',419,'Retail Sale Id 1457478',7000.00,0.00,0.00,12.50,562.50,'2022-01-04 13:30:20','',''),(2437152,'1','186','940',419,'Retail Sale Id 1457551',8400.00,0.00,0.00,15.00,675.00,'2022-01-04 13:31:17','',''),(2437167,'1','186','940',419,'Retail Sale Id 1457562',10640.00,0.00,0.00,19.00,855.00,'2022-01-04 13:32:09','',''),(2437198,'1','186','940',419,'Retail Sale Id 1457584',7000.00,0.00,0.00,12.50,562.50,'2022-01-04 13:33:23','',''),(2437213,'1','186','940',419,'Retail Sale Id 1457599',10640.00,0.00,0.00,19.00,855.00,'2022-01-04 13:34:52','',''),(2437275,'1','186','940',419,'Retail Sale Id 1457624',8400.00,0.00,0.00,15.00,675.00,'2022-01-04 13:38:15','',''),(2437291,'1','186','940',419,'Retail Sale Id 1457651',10640.00,0.00,0.00,19.00,855.00,'2022-01-04 13:39:11','',''),(2437317,'1','186','940',419,'Retail Sale Id 1457666',8400.00,0.00,0.00,15.00,675.00,'2022-01-04 13:40:46','',''),(2437335,'1','186','940',419,'Retail Sale Id 1457678',1036000.00,0.00,0.00,2000.00,6000.00,'2022-01-04 13:42:15','',''),(2442473,'1','186','940',419,'Retail Sale Id 1461535',1716000.00,0.00,0.00,3300.00,16500.00,'2022-01-05 10:48:21','',''),(2442548,'1','186','940',419,'Retail Sale Id 1461599',179200.00,0.00,0.00,320.00,14400.00,'2022-01-05 10:54:33','',''),(2442820,'1','186','940',419,'Retail Sale Id 1461865',86800.00,0.00,0.00,155.00,6975.00,'2022-01-05 11:21:48','',''),(2442843,'1','186','940',419,'Retail Sale Id 1461872',2590000.00,0.00,0.00,5000.00,15000.00,'2022-01-05 11:22:53','',''),(2443991,'1','186','940',419,'Retail Sale Id 1462923',5600.00,0.00,0.00,10.00,450.00,'2022-01-05 13:05:22','',''),(2443999,'1','186','940',419,'Retail Sale Id 1462931',5600.00,0.00,0.00,10.00,450.00,'2022-01-05 13:06:20','',''),(2444006,'1','186','940',419,'Retail Sale Id 1462938',8400.00,0.00,0.00,15.00,675.00,'2022-01-05 13:07:09','',''),(2444016,'1','186','940',419,'Retail Sale Id 1462951',8400.00,0.00,0.00,15.00,675.00,'2022-01-05 13:08:20','',''),(2444029,'1','186','940',419,'Retail Sale Id 1462964',5600.00,0.00,0.00,10.00,450.00,'2022-01-05 13:09:07','',''),(2444035,'1','186','940',419,'Retail Sale Id 1462972',5600.00,0.00,0.00,10.00,450.00,'2022-01-05 13:09:54','',''),(2444043,'1','186','940',419,'Retail Sale Id 1462979',8400.00,0.00,0.00,15.00,675.00,'2022-01-05 13:10:37','',''),(2444053,'1','186','940',419,'Retail Sale Id 1462989',5600.00,0.00,0.00,10.00,450.00,'2022-01-05 13:11:36','',''),(2444076,'1','186','940',419,'Retail Sale Id 1463003',7000.00,0.00,0.00,12.50,562.50,'2022-01-05 13:13:08','',''),(2444083,'1','186','940',419,'Retail Sale Id 1463015',7000.00,0.00,0.00,12.50,562.50,'2022-01-05 13:14:15','',''),(2450517,'1','186','940',419,'Retail Sale Id 1467802',1560000.00,0.00,0.00,3000.00,15000.00,'2022-01-06 11:08:32','',''),(2450559,'1','186','940',419,'Retail Sale Id 1467840',196000.00,0.00,0.00,350.00,15750.00,'2022-01-06 11:13:12','',''),(2450748,'1','186','940',419,'Retail Sale Id 1468026',1036000.00,0.00,0.00,2000.00,6000.00,'2022-01-06 11:29:43','',''),(2450757,'1','186','940',419,'Retail Sale Id 1468034',8400.00,0.00,0.00,15.00,675.00,'2022-01-06 11:30:44','',''),(2450763,'1','186','940',419,'Retail Sale Id 1468041',8400.00,0.00,0.00,15.00,675.00,'2022-01-06 11:31:22','',''),(2450774,'1','186','940',419,'Retail Sale Id 1468052',10640.00,0.00,0.00,19.00,855.00,'2022-01-06 11:32:03','',''),(2450779,'1','186','940',419,'Retail Sale Id 1468060',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:32:41','',''),(2450786,'1','186','940',419,'Retail Sale Id 1468066',8400.00,0.00,0.00,15.00,675.00,'2022-01-06 11:33:34','',''),(2450801,'1','186','940',419,'Retail Sale Id 1468083',8400.00,0.00,0.00,15.00,675.00,'2022-01-06 11:34:48','',''),(2450813,'1','186','940',419,'Retail Sale Id 1468092',10640.00,0.00,0.00,19.00,855.00,'2022-01-06 11:35:45','',''),(2450823,'1','186','940',419,'Retail Sale Id 1468102',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:36:22','',''),(2450830,'1','186','940',419,'Retail Sale Id 1468111',8400.00,0.00,0.00,15.00,675.00,'2022-01-06 11:37:06','',''),(2450841,'1','186','940',419,'Retail Sale Id 1468123',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:37:44','',''),(2450848,'1','186','940',419,'Retail Sale Id 1468132',10640.00,0.00,0.00,19.00,855.00,'2022-01-06 11:38:30','',''),(2450863,'1','186','940',419,'Retail Sale Id 1468152',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:39:49','',''),(2450871,'1','186','940',419,'Retail Sale Id 1468155',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:40:23','',''),(2450892,'1','186',NULL,419,'Reception corrector for bridging 129964',0.00,0.00,0.00,2010.00,0.00,'2022-01-06 11:42:53','',''),(2450893,'1','186','940',419,'Received from bridging 129964',0.00,0.00,2010.00,0.00,0.00,'2022-01-06 11:42:53','',''),(2450907,'1','186','940',419,'Retail Sale Id 1468195',14000.00,0.00,0.00,25.00,1125.00,'2022-01-06 11:43:51','',''),(2450913,'1','186','940',419,'Retail Sale Id 1468201',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:44:28','',''),(2450917,'1','186','940',419,'Retail Sale Id 1468204',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:45:06','',''),(2450944,'1','186','940',419,'Retail Sale Id 1468216',7000.00,0.00,0.00,12.50,562.50,'2022-01-06 11:46:02','',''),(2450950,'1','186','940',419,'Retail Sale Id 1468220',8400.00,0.00,0.00,15.00,675.00,'2022-01-06 11:46:43','',''),(2450980,'1','186','940',419,'Retail Sale Id 1468237',518000.00,0.00,0.00,1000.00,3000.00,'2022-01-06 11:48:24','',''),(2455582,'1','186','940',419,'Retail Sale Id 1472115',507832.00,0.00,0.00,976.60,4883.00,'2022-01-06 22:33:08','',''),(2462726,'1','186','940',419,'Return of Retail Sale Id 1468220',0.00,8400.00,15.00,0.00,-675.00,'2022-01-07 20:51:41','',''),(2462727,'1','186','940',419,'Return of Retail Sale Id 1468216',0.00,7000.00,12.50,0.00,-562.50,'2022-01-07 20:52:07','',''),(2462728,'1','186','940',419,'Return of Retail Sale Id 1468204',0.00,7000.00,12.50,0.00,-562.50,'2022-01-07 20:52:43','',''),(2462729,'1','186','940',419,'Return of Retail Sale Id 1468201',0.00,7000.00,12.50,0.00,-562.50,'2022-01-07 20:53:18','',''),(2466095,'1','186','940',419,'Retail Sale Id 1480674',29512.00,0.00,0.00,52.70,2371.50,'2022-01-08 11:58:20','',''),(2466151,'1','186','940',419,'Return of Retail Sale Id 1480674',0.00,29512.00,52.70,0.00,-2371.50,'2022-01-08 12:01:19','',''),(2466158,'1','186','940',419,'Retail Sale Id 1480711',29400.00,0.00,0.00,52.50,2362.50,'2022-01-08 12:02:11','',''),(2466369,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:344843',183803.50,0.00,0.00,356.90,0.00,'2022-01-08 12:20:47','',''),(2466494,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12911050.00,25070.00,0.00,0.00,'2022-01-08 12:33:45','',''),(2466514,'1','186',NULL,419,'Reception corrector for bridging 130171',0.00,0.00,0.00,23000.00,0.00,'2022-01-08 12:36:11','',''),(2466515,'1','186','940',419,'Received from bridging 130171',0.00,0.00,23000.00,0.00,0.00,'2022-01-08 12:36:11','',''),(2466650,'1','186','940',419,'Retail Sale Id 1481138',673400.00,0.00,0.00,1300.00,3900.00,'2022-01-08 12:50:43','',''),(2466763,'1','186','940',419,'Retail Sale Id 1481261',2331000.00,0.00,0.00,4500.00,13500.00,'2022-01-08 13:01:46','',''),(2466826,'1','186','940',419,'Retail Sale Id 1481334',3360.00,0.00,0.00,6.00,270.00,'2022-01-08 13:08:39','',''),(2466839,'1','186','940',419,'Retail Sale Id 1481339',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:10:38','',''),(2466848,'1','186','940',419,'Retail Sale Id 1481358',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:11:36','',''),(2466862,'1','186','940',419,'Retail Sale Id 1481365',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:13:52','',''),(2466871,'1','186','940',419,'Retail Sale Id 1481376',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:14:53','',''),(2466877,'1','186','940',419,'Retail Sale Id 1481384',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:15:58','',''),(2466924,'1','186','940',419,'Retail Sale Id 1481426',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:21:00','',''),(2466950,'1','186','940',419,'Retail Sale Id 1481452',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:23:06','',''),(2466970,'1','186','940',419,'Retail Sale Id 1481467',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:24:21','',''),(2466988,'1','186','940',419,'Retail Sale Id 1481479',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:25:45','',''),(2467011,'1','186','940',419,'Retail Sale Id 1481491',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:28:23','',''),(2467019,'1','186','940',419,'Retail Sale Id 1481509',8400.00,0.00,0.00,15.00,675.00,'2022-01-08 13:29:19','',''),(2467028,'1','186','940',419,'Retail Sale Id 1481520',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:29:50','',''),(2467034,'1','186','940',419,'Retail Sale Id 1481523',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:30:25','',''),(2467039,'1','186','940',419,'Retail Sale Id 1481529',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:31:16','',''),(2467043,'1','186','940',419,'Retail Sale Id 1481535',10640.00,0.00,0.00,19.00,855.00,'2022-01-08 13:31:47','',''),(2467050,'1','186','940',419,'Retail Sale Id 1481541',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:32:17','',''),(2467057,'1','186','940',419,'Retail Sale Id 1481546',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:33:10','',''),(2467085,'1','186','940',419,'Retail Sale Id 1481568',7000.00,0.00,0.00,12.50,562.50,'2022-01-08 13:35:28','',''),(2467094,'1','186','940',419,'Retail Sale Id 1481577',10640.00,0.00,0.00,19.00,855.00,'2022-01-08 13:36:11','',''),(2467117,'1','186','940',419,'Retail Sale Id 1481585',10640.00,0.00,0.00,19.00,855.00,'2022-01-08 13:36:50','',''),(2473452,'1','186','940',419,'Retail Sale Id 1487054',1036000.00,0.00,0.00,2000.00,6000.00,'2022-01-09 10:40:37','',''),(2473486,'1','186','940',419,'Retail Sale Id 1487074',1820000.00,0.00,0.00,3500.00,17500.00,'2022-01-09 10:43:38','',''),(2473665,'1','186','940',419,'Retail Sale Id 1487197',232400.00,0.00,0.00,415.00,18675.00,'2022-01-09 10:52:59','',''),(2473796,'1','186','940',419,'Retail Sale Id 1487345',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 11:05:10','',''),(2474498,'1','186','940',419,'Retail Sale Id 1487970',10640.00,0.00,0.00,19.00,855.00,'2022-01-09 12:00:28','',''),(2474759,'1','186','940',419,'Retail Sale Id 1488254',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:26:27','',''),(2474776,'1','186','940',419,'Retail Sale Id 1488267',2590000.00,0.00,0.00,5000.00,15000.00,'2022-01-09 12:27:51','',''),(2474796,'1','186','940',419,'Retail Sale Id 1488291',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 12:29:56','',''),(2474806,'1','186','940',419,'Retail Sale Id 1488305',10640.00,0.00,0.00,19.00,855.00,'2022-01-09 12:30:53','',''),(2474824,'1','186','940',419,'Retail Sale Id 1488317',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:32:26','',''),(2474834,'1','186','940',419,'Retail Sale Id 1488336',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:33:07','',''),(2474845,'1','186','940',419,'Retail Sale Id 1488346',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:33:57','',''),(2474864,'1','186','940',419,'Retail Sale Id 1488364',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 12:35:47','',''),(2474877,'1','186','940',419,'Retail Sale Id 1488385',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 12:36:54','',''),(2474909,'1','186','940',419,'Retail Sale Id 1488417',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:38:59','',''),(2474971,'1','186','940',419,'Retail Sale Id 1488438',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:40:45','',''),(2474996,'1','186','940',419,'Retail Sale Id 1488461',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 12:41:44','',''),(2475011,'1','186','940',419,'Retail Sale Id 1488479',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 12:42:58','',''),(2475023,'1','186','940',419,'Retail Sale Id 1488491',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:44:03','',''),(2475037,'1','186','940',419,'Retail Sale Id 1488503',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:45:07','',''),(2475049,'1','186','940',419,'Retail Sale Id 1488516',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:45:56','',''),(2475066,'1','186','940',419,'Retail Sale Id 1488530',8400.00,0.00,0.00,15.00,675.00,'2022-01-09 12:47:01','',''),(2475085,'1','186','940',419,'Retail Sale Id 1488545',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:48:20','',''),(2475102,'1','186','940',419,'Retail Sale Id 1488566',7000.00,0.00,0.00,12.50,562.50,'2022-01-09 12:49:49','',''),(2475111,'1','186','940',419,'Retail Sale Id 1488578',10640.00,0.00,0.00,19.00,855.00,'2022-01-09 12:51:15','',''),(2475135,'1','186','940',419,'Retail Sale Id 1488605',1560000.00,0.00,0.00,3000.00,15000.00,'2022-01-09 12:53:07','',''),(2479570,'1','186','940',419,'Return of Retail Sale Id 1488605',0.00,1560000.00,3000.00,0.00,-15000.00,'2022-01-10 07:24:48','',''),(2479595,'1','186','940',419,'Return of Retail Sale Id 1488267',0.00,2590000.00,5000.00,0.00,-15000.00,'2022-01-10 07:33:47','',''),(2479610,'1','186','940',419,'Retail Sale Id 1492204',1036000.00,0.00,0.00,2000.00,6000.00,'2022-01-10 07:36:52','',''),(2479622,'1','186','940',419,'Retail Sale Id 1492208',338000.00,0.00,0.00,650.00,3250.00,'2022-01-10 07:39:08','',''),(2479638,'1','186','940',419,'Retail Sale Id 1492229',115360.00,0.00,0.00,206.00,9270.00,'2022-01-10 07:43:48','',''),(2479654,'1','186','940',419,'Retail Sale Id 1492244',8400.00,0.00,0.00,15.00,675.00,'2022-01-10 07:47:09','',''),(2479658,'1','186','940',419,'Retail Sale Id 1492248',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:47:48','',''),(2479663,'1','186','940',419,'Retail Sale Id 1492254',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:48:31','',''),(2479668,'1','186','940',419,'Retail Sale Id 1492260',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:49:13','',''),(2479670,'1','186','940',419,'Retail Sale Id 1492262',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:50:27','',''),(2479677,'1','186','940',419,'Retail Sale Id 1492271',5600.00,0.00,0.00,10.00,450.00,'2022-01-10 07:52:13','',''),(2479680,'1','186','940',419,'Retail Sale Id 1492274',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:53:51','',''),(2479713,'1','186','940',419,'Retail Sale Id 1492292',5600.00,0.00,0.00,10.00,450.00,'2022-01-10 07:56:56','',''),(2479724,'1','186','940',419,'Retail Sale Id 1492299',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:58:17','',''),(2479730,'1','186','940',419,'Retail Sale Id 1492308',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 07:59:21','',''),(2479735,'1','186','940',419,'Retail Sale Id 1492315',8400.00,0.00,0.00,15.00,675.00,'2022-01-10 08:00:20','',''),(2479743,'1','186','940',419,'Retail Sale Id 1492324',8400.00,0.00,0.00,15.00,675.00,'2022-01-10 08:01:06','',''),(2479747,'1','186','940',419,'Retail Sale Id 1492328',8400.00,0.00,0.00,15.00,675.00,'2022-01-10 08:01:51','',''),(2479753,'1','186','940',419,'Retail Sale Id 1492339',5600.00,0.00,0.00,10.00,450.00,'2022-01-10 08:02:36','',''),(2479757,'1','186','940',419,'Retail Sale Id 1492343',5600.00,0.00,0.00,10.00,450.00,'2022-01-10 08:03:19','',''),(2479763,'1','186','940',419,'Retail Sale Id 1492348',8400.00,0.00,0.00,15.00,675.00,'2022-01-10 08:04:09','',''),(2481208,'1','186','940',419,'Retail Sale Id 1493580',86800.00,0.00,0.00,155.00,6975.00,'2022-01-10 10:23:29','',''),(2481214,'1','186','940',419,'Retail Sale Id 1493587',7000.00,0.00,0.00,12.50,562.50,'2022-01-10 10:24:08','',''),(2485807,'1','186','940',419,'Retail Sale Id 1497836',2540000.00,0.00,0.00,5000.00,-260000.00,'2022-01-10 18:42:40','',''),(2486249,'1','186',NULL,419,'Reception corrector for bridging 130405',0.00,0.00,0.00,2070.00,0.00,'2022-01-10 22:41:26','',''),(2486250,'1','186','940',419,'Received from bridging 130405',0.00,0.00,2070.00,0.00,0.00,'2022-01-10 22:41:26','',''),(2486264,'1','186','940',419,'Retail Sale Id 1498038',1657500.00,0.00,0.00,3250.00,-162500.00,'2022-01-10 22:44:01','',''),(2486277,'1','186','940',419,'Retail Sale Id 1498041',189280.00,0.00,0.00,338.00,0.00,'2022-01-10 22:54:55','',''),(2486279,'1','186','940',419,'Retail Sale Id 1498042',300685.20,0.00,0.00,591.90,-30778.80,'2022-01-10 22:57:50','',''),(2488745,'1','186','940',419,'Distributed to AARANO for sales id:345447',199696.00,0.00,0.00,356.60,0.00,'2022-01-11 11:10:39','',''),(2495162,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12240200.00,24980.00,0.00,0.00,'2022-01-12 09:14:46','',''),(2495185,'1','186',NULL,419,'Reception corrector for bridging 130561',0.00,0.00,0.00,23000.00,0.00,'2022-01-12 09:16:35','',''),(2495186,'1','186','940',419,'Received from bridging 130561',0.00,0.00,23000.00,0.00,0.00,'2022-01-12 09:16:35','',''),(2495226,'1','186','940',419,'Retail Sale Id 1505290',1549999.44,0.00,0.00,3051.18,54921.24,'2022-01-12 09:20:27','',''),(2495298,'1','186','940',419,'Retail Sale Id 1505363',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:28:33','',''),(2495306,'1','186','940',419,'Retail Sale Id 1505372',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:29:07','',''),(2495312,'1','186','940',419,'Retail Sale Id 1505382',10640.00,0.00,0.00,19.00,0.00,'2022-01-12 09:29:42','',''),(2495319,'1','186','940',419,'Retail Sale Id 1505388',8400.00,0.00,0.00,15.00,0.00,'2022-01-12 09:30:37','',''),(2495330,'1','186','940',419,'Retail Sale Id 1505399',10640.00,0.00,0.00,19.00,0.00,'2022-01-12 09:31:20','',''),(2495336,'1','186','940',419,'Retail Sale Id 1505409',10640.00,0.00,0.00,19.00,0.00,'2022-01-12 09:32:03','',''),(2495342,'1','186','940',419,'Retail Sale Id 1505418',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:32:42','',''),(2495350,'1','186','940',419,'Retail Sale Id 1505425',8400.00,0.00,0.00,15.00,0.00,'2022-01-12 09:33:25','',''),(2495368,'1','186','940',419,'Retail Sale Id 1505440',10640.00,0.00,0.00,19.00,0.00,'2022-01-12 09:34:44','',''),(2495383,'1','186','940',419,'Retail Sale Id 1505451',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:35:49','',''),(2495393,'1','186','940',419,'Retail Sale Id 1505464',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:36:39','',''),(2495399,'1','186','940',419,'Retail Sale Id 1505471',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:37:21','',''),(2495423,'1','186','940',419,'Retail Sale Id 1505480',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:38:00','',''),(2495439,'1','186','940',419,'Retail Sale Id 1505492',1524000.00,0.00,0.00,3000.00,-156000.00,'2022-01-12 09:39:08','',''),(2495448,'1','186','940',419,'Retail Sale Id 1505500',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:39:45','',''),(2495456,'1','186','940',419,'Retail Sale Id 1505510',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:40:21','',''),(2495462,'1','186','940',419,'Retail Sale Id 1505516',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:40:57','',''),(2495470,'1','186','940',419,'Retail Sale Id 1505520',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:41:31','',''),(2495478,'1','186','940',419,'Retail Sale Id 1505526',8400.00,0.00,0.00,15.00,0.00,'2022-01-12 09:42:09','',''),(2495488,'1','186','940',419,'Retail Sale Id 1505536',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:42:46','',''),(2495505,'1','186','940',419,'Retail Sale Id 1505549',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:44:02','',''),(2495514,'1','186','940',419,'Retail Sale Id 1505558',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 09:44:43','',''),(2495732,'1','186','940',419,'Retail Sale Id 1505702',1524000.00,0.00,0.00,3000.00,-156000.00,'2022-01-12 10:00:45','',''),(2497605,'1','186','940',419,'Retail Sale Id 1507580',7000.00,0.00,0.00,12.50,0.00,'2022-01-12 13:12:37','',''),(2501536,'1','186','940',419,'Retail Sale Id 1511093',1524000.00,0.00,0.00,3000.00,-156000.00,'2022-01-12 22:30:12','',''),(2501539,'1','186','940',419,'Retail Sale Id 1511096',1810500.00,0.00,0.00,3550.00,-177500.00,'2022-01-12 22:33:11','',''),(2503049,'1','186','940',419,'Retail Sale Id 1512138',224000.00,0.00,0.00,400.00,0.00,'2022-01-13 09:37:36','',''),(2503142,'1','186','940',419,'Retail Sale Id 1512196',2032000.00,0.00,0.00,4000.00,-208000.00,'2022-01-13 09:48:42','',''),(2503502,'1','186','940',419,'Retail Sale Id 1512429',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:16:28','',''),(2503513,'1','186','940',419,'Retail Sale Id 1512439',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:17:38','',''),(2503529,'1','186','940',419,'Retail Sale Id 1512452',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:18:40','',''),(2503536,'1','186','940',419,'Retail Sale Id 1512464',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:19:28','',''),(2503551,'1','186','940',419,'Retail Sale Id 1512478',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:20:50','',''),(2503563,'1','186','940',419,'Retail Sale Id 1512487',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:22:03','',''),(2503580,'1','186','940',419,'Retail Sale Id 1512504',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:23:26','',''),(2503606,'1','186','940',419,'Retail Sale Id 1512530',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:26:21','',''),(2503652,'1','186',NULL,419,'Reception corrector for bridging 130699',0.00,0.00,0.00,1980.00,0.00,'2022-01-13 10:29:44','',''),(2503653,'1','186','940',419,'Received from bridging 130699',0.00,0.00,1980.00,0.00,0.00,'2022-01-13 10:29:44','',''),(2503692,'1','186','940',419,'Retail Sale Id 1512595',1524000.00,0.00,0.00,3000.00,-156000.00,'2022-01-13 10:33:11','',''),(2503717,'1','186','940',419,'Retail Sale Id 1512635',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:35:15','',''),(2503727,'1','186','940',419,'Retail Sale Id 1512645',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:36:02','',''),(2503746,'1','186','940',419,'Retail Sale Id 1512662',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:37:27','',''),(2503752,'1','186','940',419,'Retail Sale Id 1512668',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:38:11','',''),(2503760,'1','186','940',419,'Retail Sale Id 1512681',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:39:01','',''),(2503783,'1','186','940',419,'Retail Sale Id 1512701',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:40:19','',''),(2503792,'1','186','940',419,'Retail Sale Id 1512711',10640.00,0.00,0.00,19.00,0.00,'2022-01-13 10:41:00','',''),(2503809,'1','186','940',419,'Retail Sale Id 1512723',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:41:41','',''),(2503820,'1','186','940',419,'Retail Sale Id 1512734',8400.00,0.00,0.00,15.00,0.00,'2022-01-13 10:42:31','',''),(2503829,'1','186','940',419,'Retail Sale Id 1512740',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:43:27','',''),(2503841,'1','186','940',419,'Retail Sale Id 1512754',7000.00,0.00,0.00,12.50,0.00,'2022-01-13 10:44:09','',''),(2503887,'1','186','940',419,'Retail Sale Id 1512782',255000.00,0.00,0.00,500.00,-25000.00,'2022-01-13 10:46:23','',''),(2509052,'1','186','940',419,'Retail Sale Id 1517343',260100.00,0.00,0.00,510.00,-25500.00,'2022-01-13 20:53:18','',''),(2516547,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:346372',217739.20,0.00,0.00,388.82,0.00,'2022-01-14 22:57:49','',''),(2517990,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,9795100.00,19990.00,0.00,0.00,'2022-01-15 09:16:05','',''),(2518033,'1','186',NULL,419,'Reception corrector for bridging 130974',0.00,0.00,0.00,19990.00,0.00,'2022-01-15 09:19:29','',''),(2518034,'1','186','940',419,'Received from bridging 130974',0.00,0.00,19990.00,0.00,0.00,'2022-01-15 09:19:29','',''),(2518168,'1','186','940',419,'Retail Sale Id 1525127',762000.00,0.00,0.00,1500.00,27000.00,'2022-01-15 09:27:05','',''),(2518722,'1','186','940',419,'Retail Sale Id 1525626',8400.00,0.00,0.00,15.00,1050.00,'2022-01-15 10:09:51','',''),(2518740,'1','186','940',419,'Retail Sale Id 1525645',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:11:26','',''),(2518771,'1','186','940',419,'Retail Sale Id 1525685',10640.00,0.00,0.00,19.00,1330.00,'2022-01-15 10:14:28','',''),(2518809,'1','186','940',419,'Retail Sale Id 1525712',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:17:11','',''),(2518823,'1','186','940',419,'Retail Sale Id 1525734',8400.00,0.00,0.00,15.00,1050.00,'2022-01-15 10:18:29','',''),(2518828,'1','186','940',419,'Retail Sale Id 1525753',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:19:27','',''),(2518844,'1','186','940',419,'Retail Sale Id 1525775',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:20:36','',''),(2518855,'1','186','940',419,'Retail Sale Id 1525787',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:21:39','',''),(2518915,'1','186','940',419,'Retail Sale Id 1525833',3360.00,0.00,0.00,6.00,420.00,'2022-01-15 10:26:11','',''),(2518923,'1','186','940',419,'Retail Sale Id 1525844',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:27:12','',''),(2518933,'1','186','940',419,'Retail Sale Id 1525855',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:28:01','',''),(2518946,'1','186','940',419,'Retail Sale Id 1525865',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:28:53','',''),(2519022,'1','186','940',419,'Retail Sale Id 1525910',560.00,0.00,0.00,1.00,70.00,'2022-01-15 10:32:56','',''),(2519048,'1','186','940',419,'Retail Sale Id 1525934',3360.00,0.00,0.00,6.00,420.00,'2022-01-15 10:34:51','',''),(2519062,'1','186','940',419,'Retail Sale Id 1525950',5040.00,0.00,0.00,9.00,630.00,'2022-01-15 10:35:25','',''),(2519069,'1','186','940',419,'Retail Sale Id 1525955',8400.00,0.00,0.00,15.00,1050.00,'2022-01-15 10:35:57','',''),(2519085,'1','186','940',419,'Retail Sale Id 1525971',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:37:12','',''),(2519104,'1','186','940',419,'Retail Sale Id 1525986',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:38:25','',''),(2519137,'1','186','940',419,'Retail Sale Id 1526000',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:40:07','',''),(2519150,'1','186','940',419,'Retail Sale Id 1526014',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:41:14','',''),(2519166,'1','186','940',419,'Retail Sale Id 1526032',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:42:15','',''),(2519188,'1','186','940',419,'Retail Sale Id 1526051',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:43:43','',''),(2519206,'1','186','940',419,'Retail Sale Id 1526068',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:44:54','',''),(2519220,'1','186','940',419,'Retail Sale Id 1526082',7000.00,0.00,0.00,12.50,875.00,'2022-01-15 10:46:03','',''),(2521002,'1','186','940',419,'Retail Sale Id 1527700',7250.00,0.00,0.00,12.50,0.00,'2022-01-15 13:14:15','',''),(2521142,'1','186','940',419,'Retail Sale Id 1527775',3048.00,0.00,0.00,6.00,-312.00,'2022-01-15 13:20:45','',''),(2521257,'1','186','940',419,'Retail Sale Id 1527792',777549.88,0.00,0.00,1530.61,-79591.72,'2022-01-15 13:30:39','',''),(2525578,'1','186','940',419,'Retail Sale Id 1531535',6350000.00,0.00,0.00,12500.00,-650000.00,'2022-01-15 23:00:04','',''),(2525579,'1','186','940',419,'Retail Sale Id 1531536',1810500.00,0.00,0.00,3550.00,-177500.00,'2022-01-15 23:01:37','',''),(2525601,'1','186','940',419,'Return of Retail Sale Id 1531535',0.00,6350000.00,12500.00,0.00,650000.00,'2022-01-15 23:26:50','',''),(2525602,'1','186','940',419,'Retail Sale Id 1531549',5334000.00,0.00,0.00,10500.00,-546000.00,'2022-01-15 23:28:20','',''),(2525603,'1','186','940',419,'Retail Sale Id 1531550',217280.00,0.00,0.00,388.00,0.00,'2022-01-15 23:33:35','',''),(2528154,'1','186','940',419,'Retail Sale Id 1533637',7000.00,0.00,0.00,12.50,0.00,'2022-01-16 10:45:48','',''),(2528178,'1','186','940',419,'Retail Sale Id 1533651',7000.00,0.00,0.00,12.50,0.00,'2022-01-16 10:47:08','',''),(2528193,'1','186','940',419,'Retail Sale Id 1533675',8400.00,0.00,0.00,15.00,0.00,'2022-01-16 10:48:13','',''),(2528203,'1','186','940',419,'Retail Sale Id 1533685',8400.00,0.00,0.00,15.00,0.00,'2022-01-16 10:48:54','',''),(2528215,'1','186','940',419,'Retail Sale Id 1533694',10640.00,0.00,0.00,19.00,0.00,'2022-01-16 10:49:39','',''),(2528232,'1','186','940',419,'Retail Sale Id 1533713',8400.00,0.00,0.00,15.00,0.00,'2022-01-16 10:51:03','',''),(2528255,'1','186','940',419,'Retail Sale Id 1533729',8400.00,0.00,0.00,15.00,0.00,'2022-01-16 10:53:03','',''),(2528269,'1','186','940',419,'Retail Sale Id 1533751',508000.00,0.00,0.00,1000.00,-52000.00,'2022-01-16 10:54:32','',''),(2528280,'1','186','940',419,'Retail Sale Id 1533764',101600.00,0.00,0.00,200.00,-10400.00,'2022-01-16 10:55:56','',''),(2536500,'1','186','940',419,'Retail Sale Id 1540888',156513.90,0.00,0.00,306.89,-15344.50,'2022-01-17 11:47:42','',''),(2543090,'1','186','940',419,'Distributed to AARANO for sales id:347055',339360.00,0.00,0.00,606.00,0.00,'2022-01-18 10:56:35','',''),(2543117,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12230400.00,24960.00,0.00,0.00,'2022-01-18 11:00:00','',''),(2543142,'1','186',NULL,419,'Reception corrector for bridging 131284',0.00,0.00,0.00,23000.00,0.00,'2022-01-18 11:02:28','',''),(2543143,'1','186','940',419,'Received from bridging 131284',0.00,0.00,23000.00,0.00,0.00,'2022-01-18 11:02:28','',''),(2543307,'1','186','940',419,'Retail Sale Id 1546704',1199997.60,0.00,0.00,2362.20,42519.60,'2022-01-18 11:20:53','',''),(2543470,'1','186','940',419,'Retail Sale Id 1546837',18760.00,0.00,0.00,33.50,2345.00,'2022-01-18 11:39:14','',''),(2543484,'1','186','940',419,'Retail Sale Id 1546848',1193800.00,0.00,0.00,2350.00,42300.00,'2022-01-18 11:40:25','',''),(2543810,'1','186','940',419,'Retail Sale Id 1547162',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:23:40','',''),(2543813,'1','186','940',419,'Retail Sale Id 1547164',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:24:26','',''),(2543820,'1','186','940',419,'Retail Sale Id 1547174',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:25:10','',''),(2543828,'1','186','940',419,'Retail Sale Id 1547180',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:25:58','',''),(2543839,'1','186','940',419,'Retail Sale Id 1547190',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:26:44','',''),(2543843,'1','186','940',419,'Retail Sale Id 1547193',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:27:23','',''),(2543851,'1','186','940',419,'Retail Sale Id 1547202',8400.00,0.00,0.00,15.00,1050.00,'2022-01-18 12:28:26','',''),(2543864,'1','186','940',419,'Retail Sale Id 1547214',8400.00,0.00,0.00,15.00,1050.00,'2022-01-18 12:30:04','',''),(2543871,'1','186','940',419,'Retail Sale Id 1547223',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:30:44','',''),(2543875,'1','186','940',419,'Retail Sale Id 1547226',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:31:23','',''),(2543881,'1','186','940',419,'Retail Sale Id 1547232',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:32:16','',''),(2543888,'1','186','940',419,'Retail Sale Id 1547237',8400.00,0.00,0.00,15.00,1050.00,'2022-01-18 12:32:59','',''),(2543896,'1','186','940',419,'Retail Sale Id 1547244',10640.00,0.00,0.00,19.00,1330.00,'2022-01-18 12:33:38','',''),(2543901,'1','186','940',419,'Retail Sale Id 1547253',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:34:14','',''),(2543917,'1','186','940',419,'Retail Sale Id 1547269',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:35:48','',''),(2543929,'1','186','940',419,'Retail Sale Id 1547282',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:36:47','',''),(2543937,'1','186','940',419,'Retail Sale Id 1547291',8400.00,0.00,0.00,15.00,1050.00,'2022-01-18 12:37:26','',''),(2543941,'1','186','940',419,'Retail Sale Id 1547295',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:38:07','',''),(2543949,'1','186','940',419,'Retail Sale Id 1547302',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:38:50','',''),(2544059,'1','186','940',419,'Retail Sale Id 1547402',7000.00,0.00,0.00,12.50,875.00,'2022-01-18 12:51:43','',''),(2544067,'1','186','940',419,'Retail Sale Id 1547420',2032000.00,0.00,0.00,4000.00,72000.00,'2022-01-18 12:53:05','',''),(2545236,'1','186','940',419,'Retail Sale Id 1548497',7250.00,0.00,0.00,12.50,0.00,'2022-01-18 14:59:10','',''),(2547250,'1','186','940',419,'Retail Sale Id 1550273',1016000.00,0.00,0.00,2000.00,-104000.00,'2022-01-18 17:46:24','',''),(2548107,'1','186','940',419,'Retail Sale Id 1551056',248169.60,0.00,0.00,443.16,0.00,'2022-01-18 22:57:22','',''),(2548110,'1','186','940',419,'Retail Sale Id 1551057',1351500.00,0.00,0.00,2650.00,-132500.00,'2022-01-18 22:59:00','',''),(2549586,'1','186','940',419,'Retail Sale Id 1552083',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:10:18','',''),(2549607,'1','186','940',419,'Retail Sale Id 1552100',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:11:56','',''),(2549610,'1','186','940',419,'Retail Sale Id 1552107',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:12:35','',''),(2549620,'1','186','940',419,'Retail Sale Id 1552118',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:13:11','',''),(2549627,'1','186','940',419,'Retail Sale Id 1552125',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:13:53','',''),(2549636,'1','186','940',419,'Retail Sale Id 1552134',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:14:34','',''),(2549773,'1','186','940',419,'Retail Sale Id 1552236',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:24:52','',''),(2549779,'1','186','940',419,'Retail Sale Id 1552243',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:25:30','',''),(2549796,'1','186','940',419,'Retail Sale Id 1552260',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:26:50','',''),(2549808,'1','186','940',419,'Retail Sale Id 1552273',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:28:01','',''),(2549818,'1','186','940',419,'Retail Sale Id 1552281',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:28:44','',''),(2549826,'1','186','940',419,'Retail Sale Id 1552290',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:29:33','',''),(2549848,'1','186','940',419,'Retail Sale Id 1552307',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:31:32','',''),(2549891,'1','186','940',419,'Retail Sale Id 1552342',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 09:34:04','',''),(2549897,'1','186','940',419,'Retail Sale Id 1552345',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:34:46','',''),(2549921,'1','186','940',419,'Retail Sale Id 1552375',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:36:42','',''),(2549940,'1','186','940',419,'Retail Sale Id 1552397',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:38:30','',''),(2549947,'1','186','940',419,'Retail Sale Id 1552410',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:39:21','',''),(2549968,'1','186','940',419,'Retail Sale Id 1552419',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:41:34','',''),(2549977,'1','186','940',419,'Retail Sale Id 1552438',8400.00,0.00,0.00,15.00,0.00,'2022-01-19 09:42:18','',''),(2550159,'1','186',NULL,419,'Reception corrector for bridging 131372',0.00,0.00,0.00,1960.00,0.00,'2022-01-19 10:01:30','',''),(2550160,'1','186','940',419,'Received from bridging 131372',0.00,0.00,1960.00,0.00,0.00,'2022-01-19 10:01:30','',''),(2550186,'1','186','940',419,'Retail Sale Id 1552627',1524000.00,0.00,0.00,3000.00,-156000.00,'2022-01-19 10:03:41','',''),(2550206,'1','186','940',419,'Retail Sale Id 1552658',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 10:06:04','',''),(2550956,'1','186','940',419,'Retail Sale Id 1553384',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 11:20:44','',''),(2551057,'1','186','940',419,'Retail Sale Id 1553502',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 11:32:14','',''),(2551100,'1','186','940',419,'Retail Sale Id 1553544',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 11:36:56','',''),(2551232,'1','186','940',419,'Retail Sale Id 1553695',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 11:51:01','',''),(2551397,'1','186','940',419,'Retail Sale Id 1553821',1016000.00,0.00,0.00,2000.00,-104000.00,'2022-01-19 12:06:15','',''),(2552293,'1','186','940',419,'Retail Sale Id 1554718',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 13:57:35','',''),(2552310,'1','186','940',419,'Retail Sale Id 1554734',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:01:18','',''),(2552390,'1','186','940',419,'Retail Sale Id 1554811',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:08:54','',''),(2552458,'1','186','940',419,'Retail Sale Id 1554883',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:17:52','',''),(2552507,'1','186','940',419,'Retail Sale Id 1554937',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:24:29','',''),(2552606,'1','186','940',419,'Retail Sale Id 1555000',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:30:45','',''),(2552666,'1','186','940',419,'Retail Sale Id 1555057',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:36:54','',''),(2552705,'1','186','940',419,'Retail Sale Id 1555093',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:41:11','',''),(2552747,'1','186','940',419,'Retail Sale Id 1555116',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:43:58','',''),(2552770,'1','186','940',419,'Return of Retail Sale Id 1552627',0.00,1524000.00,3000.00,0.00,156000.00,'2022-01-19 14:45:51','',''),(2552821,'1','186','940',419,'Retail Sale Id 1555177',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 14:51:11','',''),(2552846,'1','186','940',419,'Retail Sale Id 1555203',560.00,0.00,0.00,1.00,0.00,'2022-01-19 14:53:40','',''),(2552935,'1','186','940',419,'Retail Sale Id 1555300',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 15:02:03','',''),(2552965,'1','186','940',419,'Retail Sale Id 1555322',560.00,0.00,0.00,1.00,0.00,'2022-01-19 15:05:00','',''),(2553019,'1','186','940',419,'Retail Sale Id 1555371',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 15:10:11','',''),(2553175,'1','186','940',419,'Retail Sale Id 1555526',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 15:26:03','',''),(2553257,'1','186','940',419,'Retail Sale Id 1555595',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 15:33:41','',''),(2553452,'1','186','940',419,'Retail Sale Id 1555710',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 15:45:27','',''),(2554122,'1','186','940',419,'Retail Sale Id 1556217',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 16:36:34','',''),(2554371,'1','186','940',419,'Retail Sale Id 1556492',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 16:56:19','',''),(2554436,'1','186','940',419,'Retail Sale Id 1556553',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:00:13','',''),(2554484,'1','186','940',419,'Retail Sale Id 1556611',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:03:28','',''),(2554512,'1','186','940',419,'Retail Sale Id 1556646',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:05:41','',''),(2554548,'1','186','940',419,'Retail Sale Id 1556685',3360.00,0.00,0.00,6.00,0.00,'2022-01-19 17:08:38','',''),(2554566,'1','186','940',419,'Retail Sale Id 1556701',1680.00,0.00,0.00,3.00,0.00,'2022-01-19 17:09:54','',''),(2554583,'1','186','940',419,'Retail Sale Id 1556719',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-19 17:11:01','',''),(2554595,'1','186','940',419,'Retail Sale Id 1556732',3360.00,0.00,0.00,6.00,0.00,'2022-01-19 17:11:58','',''),(2554613,'1','186','940',419,'Retail Sale Id 1556750',700.00,0.00,0.00,1.25,0.00,'2022-01-19 17:13:14','',''),(2554624,'1','186','940',419,'Retail Sale Id 1556764',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:14:13','',''),(2554636,'1','186','940',419,'Retail Sale Id 1556776',1120.00,0.00,0.00,2.00,0.00,'2022-01-19 17:15:16','',''),(2554658,'1','186','940',419,'Retail Sale Id 1556798',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:16:51','',''),(2554673,'1','186','940',419,'Retail Sale Id 1556818',2800.00,0.00,0.00,5.00,0.00,'2022-01-19 17:17:48','',''),(2554704,'1','186','940',419,'Retail Sale Id 1556835',12750.00,0.00,0.00,25.00,-1250.00,'2022-01-19 17:19:17','',''),(2554715,'1','186','940',419,'Retail Sale Id 1556848',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:20:09','',''),(2554737,'1','186','940',419,'Retail Sale Id 1556867',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:21:59','',''),(2554745,'1','186','940',419,'Retail Sale Id 1556878',1680.00,0.00,0.00,3.00,0.00,'2022-01-19 17:22:52','',''),(2555002,'1','186','940',419,'Retail Sale Id 1557127',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 17:43:57','',''),(2555270,'1','186','940',419,'Retail Sale Id 1557381',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 18:07:01','',''),(2555417,'1','186','940',419,'Retail Sale Id 1557521',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 18:28:38','',''),(2555439,'1','186','940',419,'Retail Sale Id 1557543',7000.00,0.00,0.00,12.50,0.00,'2022-01-19 18:32:04','',''),(2556848,'1','186','940',419,'Retail Sale Id 1558492',71148.00,0.00,0.00,127.05,0.00,'2022-01-20 08:39:21','',''),(2557010,'1','186','940',419,'Retail Sale Id 1558604',8400.00,0.00,0.00,15.00,0.00,'2022-01-20 08:51:45','',''),(2557067,'1','186','940',419,'Retail Sale Id 1558654',1680.00,0.00,0.00,3.00,0.00,'2022-01-20 08:55:40','',''),(2557571,'1','186','940',419,'Retail Sale Id 1559059',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 09:32:19','',''),(2557712,'1','186','940',419,'Retail Sale Id 1559224',2296.00,0.00,0.00,4.10,0.00,'2022-01-20 09:46:53','',''),(2557733,'1','186','940',419,'Retail Sale Id 1559247',1680.00,0.00,0.00,3.00,0.00,'2022-01-20 09:48:59','',''),(2557768,'1','186','940',419,'Retail Sale Id 1559281',3981.60,0.00,0.00,7.11,0.00,'2022-01-20 09:52:29','',''),(2557933,'1','186','940',419,'Retail Sale Id 1559439',15300.00,0.00,0.00,30.00,-1500.00,'2022-01-20 10:07:36','',''),(2557996,'1','186','940',419,'Retail Sale Id 1559488',20400.00,0.00,0.00,40.00,-2000.00,'2022-01-20 10:12:06','',''),(2558034,'1','186','940',419,'Retail Sale Id 1559515',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 10:14:55','',''),(2558081,'1','186','940',419,'Retail Sale Id 1559551',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 10:18:41','',''),(2558105,'1','186','940',419,'Retail Sale Id 1559574',1680.00,0.00,0.00,3.00,0.00,'2022-01-20 10:21:00','',''),(2558153,'1','186','940',419,'Retail Sale Id 1559608',3920.00,0.00,0.00,7.00,0.00,'2022-01-20 10:23:58','',''),(2558224,'1','186','940',419,'Retail Sale Id 1559664',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 10:28:22','',''),(2558361,'1','186','940',419,'Retail Sale Id 1559746',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 10:34:16','',''),(2558447,'1','186','940',419,'Retail Sale Id 1559810',1456.00,0.00,0.00,2.60,0.00,'2022-01-20 10:39:01','',''),(2558490,'1','186','940',419,'Retail Sale Id 1559848',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 10:42:36','',''),(2558671,'1','186','940',419,'Retail Sale Id 1560034',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 10:58:36','',''),(2558715,'1','186','940',419,'Retail Sale Id 1560089',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 11:03:49','',''),(2558804,'1','186','940',419,'Retail Sale Id 1560188',11760.00,0.00,0.00,21.00,0.00,'2022-01-20 11:13:01','',''),(2558840,'1','186','940',419,'Retail Sale Id 1560227',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 11:16:40','',''),(2558881,'1','186','940',419,'Retail Sale Id 1560275',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 11:21:12','',''),(2558895,'1','186','940',419,'Retail Sale Id 1560294',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 11:23:08','',''),(2558911,'1','186','940',419,'Retail Sale Id 1560309',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 11:24:34','',''),(2558921,'1','186','940',419,'Retail Sale Id 1560321',20451.00,0.00,0.00,40.10,-2005.00,'2022-01-20 11:25:53','',''),(2558986,'1','186','940',419,'Retail Sale Id 1560379',76500.00,0.00,0.00,150.00,-7500.00,'2022-01-20 11:30:44','',''),(2559058,'1','186','940',419,'Retail Sale Id 1560454',5040.00,0.00,0.00,9.00,0.00,'2022-01-20 11:38:19','',''),(2559081,'1','186','940',419,'Retail Sale Id 1560477',30600.00,0.00,0.00,60.00,-3000.00,'2022-01-20 11:40:18','',''),(2559124,'1','186','940',419,'Retail Sale Id 1560521',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 11:45:04','',''),(2559208,'1','186','940',419,'Retail Sale Id 1560612',2800.00,0.00,0.00,5.00,0.00,'2022-01-20 11:52:44','',''),(2559336,'1','186','940',419,'Retail Sale Id 1560749',560.00,0.00,0.00,1.00,0.00,'2022-01-20 12:05:29','',''),(2559371,'1','186','940',419,'Retail Sale Id 1560792',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 12:10:03','',''),(2559438,'1','186','940',419,'Retail Sale Id 1560871',560.00,0.00,0.00,1.00,0.00,'2022-01-20 12:18:53','',''),(2559475,'1','186','940',419,'Retail Sale Id 1560911',4480.00,0.00,0.00,8.00,0.00,'2022-01-20 12:21:55','',''),(2559495,'1','186','940',419,'Retail Sale Id 1560931',2497.60,0.00,0.00,4.46,0.00,'2022-01-20 12:23:37','',''),(2559535,'1','186','940',419,'Retail Sale Id 1560976',20400.00,0.00,0.00,40.00,-2000.00,'2022-01-20 12:28:01','',''),(2559555,'1','186','940',419,'Retail Sale Id 1560999',1680.00,0.00,0.00,3.00,0.00,'2022-01-20 12:30:13','',''),(2559568,'1','186','940',419,'Retail Sale Id 1561013',1960.00,0.00,0.00,3.50,0.00,'2022-01-20 12:32:10','',''),(2559586,'1','186','940',419,'Retail Sale Id 1561034',3360.00,0.00,0.00,6.00,0.00,'2022-01-20 12:33:33','',''),(2559595,'1','186','940',419,'Retail Sale Id 1561044',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 12:34:29','',''),(2559608,'1','186','940',419,'Retail Sale Id 1561055',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 12:35:33','',''),(2559618,'1','186','940',419,'Retail Sale Id 1561066',3360.00,0.00,0.00,6.00,0.00,'2022-01-20 12:36:37','',''),(2559641,'1','186','940',419,'Retail Sale Id 1561076',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 12:37:51','',''),(2559707,'1','186','940',419,'Retail Sale Id 1561132',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 12:45:49','',''),(2559725,'1','186','940',419,'Retail Sale Id 1561151',1960.00,0.00,0.00,3.50,0.00,'2022-01-20 12:47:29','',''),(2559758,'1','186','940',419,'Retail Sale Id 1561176',51510.00,0.00,0.00,101.00,-5050.00,'2022-01-20 12:50:52','',''),(2559791,'1','186','940',419,'Retail Sale Id 1561219',2240.00,0.00,0.00,4.00,0.00,'2022-01-20 12:54:00','',''),(2559821,'1','186','940',419,'Retail Sale Id 1561264',3360.00,0.00,0.00,6.00,0.00,'2022-01-20 12:58:21','',''),(2559857,'1','186','940',419,'Retail Sale Id 1561348',49980.00,0.00,0.00,98.00,-4900.00,'2022-01-20 13:02:53','',''),(2559937,'1','186','940',419,'Retail Sale Id 1561422',2240.00,0.00,0.00,4.00,0.00,'2022-01-20 13:11:07','',''),(2559970,'1','186','940',419,'Retail Sale Id 1561461',5600.00,0.00,0.00,10.00,0.00,'2022-01-20 13:13:58','',''),(2559989,'1','186','940',419,'Retail Sale Id 1561482',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 13:15:58','',''),(2560002,'1','186','940',419,'Retail Sale Id 1561498',1960.00,0.00,0.00,3.50,0.00,'2022-01-20 13:17:12','',''),(2560021,'1','186','940',419,'Retail Sale Id 1561517',1680.00,0.00,0.00,3.00,0.00,'2022-01-20 13:18:56','',''),(2560090,'1','186','940',419,'Retail Sale Id 1561588',5992.00,0.00,0.00,10.70,0.00,'2022-01-20 13:25:16','',''),(2560208,'1','186','940',419,'Retail Sale Id 1561717',2800.00,0.00,0.00,5.00,0.00,'2022-01-20 13:39:38','',''),(2560255,'1','186','940',419,'Retail Sale Id 1561772',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 13:44:28','',''),(2560456,'1','186','940',419,'Retail Sale Id 1561954',560.00,0.00,0.00,1.00,0.00,'2022-01-20 14:02:26','',''),(2560617,'1','186','940',419,'Retail Sale Id 1562136',952.00,0.00,0.00,1.70,0.00,'2022-01-20 14:20:31','',''),(2560861,'1','186','940',419,'Retail Sale Id 1562371',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 14:42:20','',''),(2560888,'1','186','940',419,'Retail Sale Id 1562387',24480.00,0.00,0.00,48.00,-2400.00,'2022-01-20 14:44:09','',''),(2560925,'1','186','940',419,'Retail Sale Id 1562419',25500.00,0.00,0.00,50.00,-2500.00,'2022-01-20 14:47:27','',''),(2560961,'1','186','940',419,'Retail Sale Id 1562458',28050.00,0.00,0.00,55.00,-2750.00,'2022-01-20 14:50:12','',''),(2561008,'1','186','940',419,'Retail Sale Id 1562488',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 14:52:50','',''),(2561052,'1','186','940',419,'Retail Sale Id 1562526',3360.00,0.00,0.00,6.00,0.00,'2022-01-20 14:56:13','',''),(2561207,'1','186','940',419,'Retail Sale Id 1562669',3920.00,0.00,0.00,7.00,0.00,'2022-01-20 15:08:21','',''),(2561225,'1','186','940',419,'Retail Sale Id 1562692',1120.00,0.00,0.00,2.00,0.00,'2022-01-20 15:10:09','',''),(2561279,'1','186','940',419,'Retail Sale Id 1562735',4984.00,0.00,0.00,8.90,0.00,'2022-01-20 15:14:03','',''),(2561294,'1','186','940',419,'Retail Sale Id 1562750',2296.00,0.00,0.00,4.10,0.00,'2022-01-20 15:15:44','',''),(2561356,'1','186','940',419,'Retail Sale Id 1562792',76500.00,0.00,0.00,150.00,-7500.00,'2022-01-20 15:19:47','',''),(2561379,'1','186','940',419,'Retail Sale Id 1562816',3360.00,0.00,0.00,6.00,0.00,'2022-01-20 15:21:33','',''),(2561399,'1','186','940',419,'Retail Sale Id 1562832',24990.00,0.00,0.00,49.00,-2450.00,'2022-01-20 15:23:19','',''),(2561425,'1','186','940',419,'Retail Sale Id 1562866',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 15:26:02','',''),(2561452,'1','186','940',419,'Retail Sale Id 1562892',2968.00,0.00,0.00,5.30,0.00,'2022-01-20 15:28:26','',''),(2561516,'1','186','940',419,'Retail Sale Id 1562944',10360.00,0.00,0.00,18.50,0.00,'2022-01-20 15:34:41','',''),(2561559,'1','186','940',419,'Retail Sale Id 1563185',1960.00,0.00,0.00,3.50,0.00,'2022-01-20 15:42:58','',''),(2561634,'1','186','940',419,'Retail Sale Id 1563269',560.00,0.00,0.00,1.00,0.00,'2022-01-20 15:49:12','',''),(2561675,'1','186','940',419,'Retail Sale Id 1563310',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 15:53:18','',''),(2561698,'1','186','940',419,'Retail Sale Id 1563329',7000.00,0.00,0.00,12.50,0.00,'2022-01-20 15:54:50','',''),(2561777,'1','186','940',419,'Retail Sale Id 1563404',1680.00,0.00,0.00,3.00,0.00,'2022-01-20 16:03:00','',''),(2561821,'1','186','940',419,'Retail Sale Id 1563476',560.00,0.00,0.00,1.00,0.00,'2022-01-20 16:08:38','',''),(2562466,'1','186','940',419,'Retail Sale Id 1563972',560.00,0.00,0.00,1.00,0.00,'2022-01-20 16:47:43','',''),(2563664,'1','186','940',419,'Retail Sale Id 1565415',51000.00,0.00,0.00,100.00,-5000.00,'2022-01-20 18:18:02','',''),(2563786,'1','186','940',419,'Retail Sale Id 1565539',560.00,0.00,0.00,1.00,0.00,'2022-01-20 18:34:20','',''),(2566434,'1','186','940',419,'Retail Sale Id 1565398',51000.00,0.00,0.00,100.00,-5000.00,'2022-01-21 10:17:51','',''),(2566501,'1','186','940',419,'Retail Sale Id 1565401',51000.00,0.00,0.00,100.00,-5000.00,'2022-01-21 10:22:14','',''),(2566780,'1','186','940',419,'Retail Sale Id 1563478',560.00,0.00,0.00,1.00,0.00,'2022-01-21 10:43:40','',''),(2566786,'1','186','940',419,'Retail Sale Id 1565537',1456.00,0.00,0.00,2.60,0.00,'2022-01-21 10:44:15','',''),(2566865,'1','186','940',419,'Retail Sale Id 1567913',560.00,0.00,0.00,1.00,0.00,'2022-01-21 10:52:50','',''),(2566900,'1','186','940',419,'Retail Sale Id 1567949',2686441.16,0.00,0.00,5288.27,-274990.04,'2022-01-21 10:56:34','',''),(2567170,'1','186','940',419,'Return of Retail Sale Id 1567913',0.00,560.00,1.00,0.00,0.00,'2022-01-21 11:26:25','',''),(2567177,'1','186','940',419,'Return of Retail Sale Id 1563478',0.00,560.00,1.00,0.00,0.00,'2022-01-21 11:27:03','',''),(2567185,'1','186','940',419,'Return of Retail Sale Id 1565539',0.00,560.00,1.00,0.00,0.00,'2022-01-21 11:28:08','',''),(2567191,'1','186','940',419,'Return of Retail Sale Id 1565537',0.00,1456.00,2.60,0.00,0.00,'2022-01-21 11:28:43','',''),(2567201,'1','186','940',419,'Return of Retail Sale Id 1563972',0.00,560.00,1.00,0.00,0.00,'2022-01-21 11:29:16','',''),(2567204,'1','186','940',419,'Return of Retail Sale Id 1563476',0.00,560.00,1.00,0.00,0.00,'2022-01-21 11:30:02','',''),(2567214,'1','186','940',419,'Return of Retail Sale Id 1563310',0.00,7000.00,12.50,0.00,0.00,'2022-01-21 11:31:02','',''),(2567243,'1','186','940',419,'Return of Retail Sale Id 1563329',0.00,7000.00,12.50,0.00,0.00,'2022-01-21 11:33:27','',''),(2567254,'1','186','940',419,'Return of Retail Sale Id 1563404',0.00,1680.00,3.00,0.00,0.00,'2022-01-21 11:34:17','',''),(2567264,'1','186','940',419,'Return of Retail Sale Id 1563185',0.00,1960.00,3.50,0.00,0.00,'2022-01-21 11:35:33','',''),(2567287,'1','186','940',419,'Return of Retail Sale Id 1562944',0.00,10360.00,18.50,0.00,0.00,'2022-01-21 11:37:38','',''),(2567296,'1','186','940',419,'Return of Retail Sale Id 1562892',0.00,2968.00,5.30,0.00,0.00,'2022-01-21 11:38:20','',''),(2567305,'1','186','940',419,'Return of Retail Sale Id 1562866',0.00,7000.00,12.50,0.00,0.00,'2022-01-21 11:39:22','',''),(2567333,'1','186','940',419,'Return of Retail Sale Id 1562735',0.00,4984.00,8.90,0.00,0.00,'2022-01-21 11:41:41','',''),(2567357,'1','186','940',419,'Return of Retail Sale Id 1562669',0.00,3920.00,7.00,0.00,0.00,'2022-01-21 11:42:28','',''),(2567372,'1','186','940',419,'Return of Retail Sale Id 1562816',0.00,3360.00,6.00,0.00,0.00,'2022-01-21 11:43:17','',''),(2567388,'1','186','940',419,'Return of Retail Sale Id 1562750',0.00,2296.00,4.10,0.00,0.00,'2022-01-21 11:44:05','',''),(2567401,'1','186','940',419,'Return of Retail Sale Id 1562692',0.00,1120.00,2.00,0.00,0.00,'2022-01-21 11:45:02','',''),(2567412,'1','186','940',419,'Return of Retail Sale Id 1562488',0.00,7000.00,12.50,0.00,0.00,'2022-01-21 11:45:56','',''),(2567419,'1','186','940',419,'Return of Retail Sale Id 1562371',0.00,7000.00,12.50,0.00,0.00,'2022-01-21 11:46:39','',''),(2567437,'1','186','940',419,'Return of Retail Sale Id 1562526',0.00,3360.00,6.00,0.00,0.00,'2022-01-21 11:47:32','',''),(2567450,'1','186','940',419,'Return of Retail Sale Id 1562136',0.00,952.00,1.70,0.00,0.00,'2022-01-21 11:48:31','',''),(2567471,'1','186','940',419,'Return of Retail Sale Id 1561461',0.00,5600.00,10.00,0.00,0.00,'2022-01-21 11:49:33','',''),(2567478,'1','186','940',419,'Return of Retail Sale Id 1561717',0.00,2800.00,5.00,0.00,0.00,'2022-01-21 11:50:46','',''),(2567489,'1','186','940',419,'Return of Retail Sale Id 1561498',0.00,1960.00,3.50,0.00,0.00,'2022-01-21 11:51:29','',''),(2567550,'1','186','940',419,'Return of Retail Sale Id 1567949',0.00,2686441.16,5288.27,0.00,274990.04,'2022-01-21 11:55:11','',''),(2567564,'1','186','940',419,'Return of Retail Sale Id 1561588',0.00,5992.00,10.70,0.00,0.00,'2022-01-21 11:56:51','',''),(2567580,'1','186','940',419,'Return of Retail Sale Id 1561954',0.00,560.00,1.00,0.00,0.00,'2022-01-21 11:57:57','',''),(2567591,'1','186','940',419,'Return of Retail Sale Id 1561772',0.00,1120.00,2.00,0.00,0.00,'2022-01-21 11:58:56','',''),(2567629,'1','186','940',419,'Return of Retail Sale Id 1565415',0.00,51000.00,100.00,0.00,5000.00,'2022-01-21 12:02:30','',''),(2567642,'1','186','940',419,'Return of Retail Sale Id 1565401',0.00,51000.00,100.00,0.00,5000.00,'2022-01-21 12:04:18','',''),(2567977,'1','186','940',419,'Return of Retail Sale Id 1561264',0.00,3360.00,6.00,0.00,0.00,'2022-01-21 12:38:33','',''),(2567997,'1','186','940',419,'Return of Retail Sale Id 1561422',0.00,2240.00,4.00,0.00,0.00,'2022-01-21 12:40:28','',''),(2568023,'1','186','940',419,'Return of Retail Sale Id 1565398',0.00,51000.00,100.00,0.00,5000.00,'2022-01-21 12:43:01','',''),(2568030,'1','186','940',419,'Return of Retail Sale Id 1562792',0.00,76500.00,150.00,0.00,7500.00,'2022-01-21 12:44:38','',''),(2568046,'1','186','940',419,'Return of Retail Sale Id 1562832',0.00,24990.00,49.00,0.00,2450.00,'2022-01-21 12:46:20','',''),(2568080,'1','186','940',419,'Return of Retail Sale Id 1562458',0.00,28050.00,55.00,0.00,2750.00,'2022-01-21 12:49:56','',''),(2568111,'1','186','940',419,'Return of Retail Sale Id 1561348',0.00,49980.00,98.00,0.00,4900.00,'2022-01-21 12:53:37','',''),(2568155,'1','186','940',419,'Return of Retail Sale Id 1562419',0.00,25500.00,50.00,0.00,2500.00,'2022-01-21 12:57:05','',''),(2568235,'1','186','940',419,'Return of Retail Sale Id 1562387',0.00,24480.00,48.00,0.00,2400.00,'2022-01-21 13:05:18','',''),(2568317,'1','186','940',419,'Return of Retail Sale Id 1561482',0.00,25500.00,50.00,0.00,2500.00,'2022-01-21 13:15:59','',''),(2568810,'1','186','940',419,'Return of Retail Sale Id 1561176',0.00,51510.00,101.00,0.00,5050.00,'2022-01-21 14:16:35','',''),(2568867,'1','186','940',419,'Return of Retail Sale Id 1559488',0.00,20400.00,40.00,0.00,2000.00,'2022-01-21 14:23:54','',''),(2568915,'1','186','940',419,'Return of Retail Sale Id 1560976',0.00,20400.00,40.00,0.00,2000.00,'2022-01-21 14:29:06','',''),(2568998,'1','186','940',419,'Return of Retail Sale Id 1559439',0.00,15300.00,30.00,0.00,1500.00,'2022-01-21 14:33:57','',''),(2569050,'1','186','940',419,'Return of Retail Sale Id 1560477',0.00,30600.00,60.00,0.00,3000.00,'2022-01-21 14:39:46','',''),(2569131,'1','186','940',419,'Return of Retail Sale Id 1560379',0.00,76500.00,150.00,0.00,7500.00,'2022-01-21 14:47:57','',''),(2569162,'1','186','940',419,'Return of Retail Sale Id 1560321',0.00,20451.00,40.10,0.00,2005.00,'2022-01-21 14:51:23','',''),(2569217,'1','186','940',419,'Return of Retail Sale Id 1559746',0.00,25500.00,50.00,0.00,2500.00,'2022-01-21 14:55:40','',''),(2569259,'1','186','940',419,'Return of Retail Sale Id 1559664',0.00,25500.00,50.00,0.00,2500.00,'2022-01-21 15:00:06','',''),(2569302,'1','186','940',419,'Return of Retail Sale Id 1559551',0.00,25500.00,50.00,0.00,2500.00,'2022-01-21 15:04:49','',''),(2569335,'1','186','940',419,'Return of Retail Sale Id 1559515',0.00,25500.00,50.00,0.00,2500.00,'2022-01-21 15:07:54','',''),(2569437,'1','186','940',419,'Retail Sale Id 1570265',867000.00,0.00,0.00,1700.00,-85000.00,'2022-01-21 15:11:39','',''),(2569493,'1','186','940',419,'Retail Sale Id 1570298',2656011.96,0.00,0.00,5228.37,-271875.24,'2022-01-21 15:14:35','',''),(2570829,'1','186','940',419,'Retail Sale Id 1571705',7000.00,0.00,0.00,12.50,0.00,'2022-01-21 16:56:03','',''),(2572108,'1','186','940',419,'Retail Sale Id 1573012',7000.00,0.00,0.00,12.50,0.00,'2022-01-21 18:44:06','',''),(2574684,'1','186','940',419,'Return of Retail Sale Id 1573012',0.00,7000.00,12.50,0.00,0.00,'2022-01-22 10:12:41','',''),(2574693,'1','186','940',419,'Return of Retail Sale Id 1571705',0.00,7000.00,12.50,0.00,0.00,'2022-01-22 10:13:28','',''),(2574790,'1','186','940',419,'Retail Sale Id 1575149',161137.60,0.00,0.00,317.20,-16494.40,'2022-01-22 10:22:17','',''),(2575032,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:348217',216720.00,0.00,0.00,387.00,0.00,'2022-01-22 10:41:30','',''),(2575230,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12269600.00,25040.00,0.00,0.00,'2022-01-22 10:59:49','',''),(2575299,'1','186',NULL,419,'Reception corrector for bridging 131710',0.00,0.00,0.00,23000.00,0.00,'2022-01-22 11:04:47','',''),(2575300,'1','186','940',419,'Received from bridging 131710',0.00,0.00,23000.00,0.00,0.00,'2022-01-22 11:04:47','',''),(2575351,'1','186','940',419,'Retail Sale Id 1575638',3784600.00,0.00,0.00,7450.00,-387400.00,'2022-01-22 11:07:08','',''),(2575552,'1','186','940',419,'Retail Sale Id 1575965',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 11:20:15','',''),(2575573,'1','186','940',419,'Retail Sale Id 1575992',2032000.00,0.00,0.00,4000.00,72000.00,'2022-01-22 11:21:56','',''),(2576352,'1','186','940',419,'Retail Sale Id 1576711',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:17:48','',''),(2576375,'1','186','940',419,'Retail Sale Id 1576732',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:19:22','',''),(2576428,'1','186','940',419,'Retail Sale Id 1576774',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 12:23:40','',''),(2576468,'1','186','940',419,'Retail Sale Id 1576805',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 12:26:41','',''),(2576596,'1','186','940',419,'Retail Sale Id 1576933',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 12:34:35','',''),(2576661,'1','186','940',419,'Retail Sale Id 1576995',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 12:38:54','',''),(2576672,'1','186','940',419,'Retail Sale Id 1577009',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:39:32','',''),(2576684,'1','186','940',419,'Retail Sale Id 1577018',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:40:20','',''),(2576697,'1','186','940',419,'Retail Sale Id 1577033',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:41:10','',''),(2576703,'1','186','940',419,'Retail Sale Id 1577038',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:41:44','',''),(2576716,'1','186','940',419,'Retail Sale Id 1577050',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 12:42:51','',''),(2576727,'1','186','940',419,'Retail Sale Id 1577061',10640.00,0.00,0.00,19.00,1330.00,'2022-01-22 12:43:55','',''),(2576743,'1','186','940',419,'Retail Sale Id 1577075',8400.00,0.00,0.00,15.00,1050.00,'2022-01-22 12:45:01','',''),(2576768,'1','186','940',419,'Retail Sale Id 1577089',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 12:46:02','',''),(2579296,'1','186','940',419,'Retail Sale Id 1579384',7000.00,0.00,0.00,12.50,875.00,'2022-01-22 16:19:58','',''),(2583718,'1','186','940',419,'Retail Sale Id 1583404',56000.00,0.00,0.00,100.00,7000.00,'2022-01-23 10:20:21','',''),(2583733,'1','186','940',419,'Retail Sale Id 1583422',2540000.00,0.00,0.00,5000.00,90000.00,'2022-01-23 10:21:48','',''),(2583754,'1','186','940',419,'Retail Sale Id 1583444',1632000.00,0.00,0.00,3200.00,64000.00,'2022-01-23 10:23:53','',''),(2584234,'1','186',NULL,419,'Reception corrector for bridging 131852',0.00,0.00,0.00,2040.00,0.00,'2022-01-23 11:04:19','',''),(2584235,'1','186','940',419,'Received from bridging 131852',0.00,0.00,2040.00,0.00,0.00,'2022-01-23 11:04:19','',''),(2584286,'1','186','940',419,'Retail Sale Id 1583838',2032000.00,0.00,0.00,4000.00,72000.00,'2022-01-23 11:08:53','',''),(2584494,'1','186','940',419,'Retail Sale Id 1584137',7000.00,0.00,0.00,12.50,875.00,'2022-01-23 11:28:10','',''),(2589948,'1','186','940',419,'Retail Sale Id 1588741',40880.00,0.00,0.00,73.00,5110.00,'2022-01-24 07:11:58','',''),(2589949,'1','186','940',419,'Retail Sale Id 1588742',301665.00,0.00,0.00,591.50,11830.00,'2022-01-24 07:14:56','',''),(2595576,'1','186','940',419,'Distributed to AARANO for sales id:348745',190610.00,0.00,0.00,389.00,0.00,'2022-01-24 17:26:26','',''),(2595688,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12254900.00,25010.00,0.00,0.00,'2022-01-24 17:34:04','',''),(2595703,'1','186',NULL,419,'Reception corrector for bridging 131985',0.00,0.00,0.00,23000.00,0.00,'2022-01-24 17:35:33','',''),(2595704,'1','186','940',419,'Received from bridging 131985',0.00,0.00,23000.00,0.00,0.00,'2022-01-24 17:35:33','',''),(2595775,'1','186','940',419,'Retail Sale Id 1594233',2540000.00,0.00,0.00,5000.00,90000.00,'2022-01-24 17:40:22','',''),(2596758,'1','186','940',419,'Retail Sale Id 1595115',1016000.00,0.00,0.00,2000.00,36000.00,'2022-01-24 21:00:39','',''),(2598894,'1','186','940',419,'Retail Sale Id 1596913',70000.00,0.00,0.00,125.00,8750.00,'2022-01-25 10:16:37','',''),(2598901,'1','186','940',419,'Retail Sale Id 1596922',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:17:14','',''),(2598904,'1','186','940',419,'Retail Sale Id 1596925',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:17:51','',''),(2598909,'1','186','940',419,'Retail Sale Id 1596930',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:18:24','',''),(2598912,'1','186','940',419,'Retail Sale Id 1596934',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:18:58','',''),(2598914,'1','186','940',419,'Retail Sale Id 1596938',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:19:31','',''),(2598921,'1','186','940',419,'Retail Sale Id 1596944',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:20:08','',''),(2598928,'1','186','940',419,'Retail Sale Id 1596950',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:20:43','',''),(2598934,'1','186','940',419,'Retail Sale Id 1596958',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:21:18','',''),(2598942,'1','186','940',419,'Retail Sale Id 1596966',2800.00,0.00,0.00,5.00,350.00,'2022-01-25 10:22:14','',''),(2598952,'1','186','940',419,'Retail Sale Id 1596977',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:23:46','',''),(2598963,'1','186','940',419,'Retail Sale Id 1596987',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:24:28','',''),(2598968,'1','186','940',419,'Retail Sale Id 1596992',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:25:05','',''),(2598979,'1','186','940',419,'Retail Sale Id 1597008',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:25:41','',''),(2598983,'1','186','940',419,'Retail Sale Id 1597013',7000.00,0.00,0.00,12.50,875.00,'2022-01-25 10:26:18','',''),(2598992,'1','186','940',419,'Retail Sale Id 1597024',560.00,0.00,0.00,1.00,70.00,'2022-01-25 10:26:58','',''),(2598996,'1','186','940',419,'Retail Sale Id 1597027',8400.00,0.00,0.00,15.00,1050.00,'2022-01-25 10:27:36','',''),(2598999,'1','186','940',419,'Retail Sale Id 1597031',7000.00,0.00,0.00,12.50,875.00,'2022-01-25 10:28:22','',''),(2599006,'1','186','940',419,'Retail Sale Id 1597039',7000.00,0.00,0.00,12.50,875.00,'2022-01-25 10:29:35','',''),(2599028,'1','186','940',419,'Retail Sale Id 1597066',2540000.00,0.00,0.00,5000.00,90000.00,'2022-01-25 10:31:58','',''),(2604275,'1','186','940',419,'Retail Sale Id 1602061',1524000.00,0.00,0.00,3000.00,54000.00,'2022-01-25 18:06:15','',''),(2604428,'1','186','940',419,'Retail Sale Id 1602232',7000.00,0.00,0.00,12.50,875.00,'2022-01-25 18:21:42','',''),(2605230,'1','186','940',419,'Retail Sale Id 1602910',84000.00,0.00,0.00,150.00,10500.00,'2022-01-25 20:47:30','',''),(2605231,'1','186','940',419,'Retail Sale Id 1602911',1805400.00,0.00,0.00,3540.00,70800.00,'2022-01-25 20:49:12','',''),(2607475,'1','186',NULL,419,'Reception corrector for bridging 132145',0.00,0.00,0.00,2010.00,0.00,'2022-01-26 10:13:07','',''),(2607476,'1','186','940',419,'Received from bridging 132145',0.00,0.00,2010.00,0.00,0.00,'2022-01-26 10:13:07','',''),(2607570,'1','186','940',419,'Retail Sale Id 1604594',2032000.00,0.00,0.00,4000.00,72000.00,'2022-01-26 10:21:07','',''),(2607604,'1','186','940',419,'Retail Sale Id 1604719',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 10:23:46','',''),(2607613,'1','186','940',419,'Retail Sale Id 1604733',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 10:24:43','',''),(2607654,'1','186','940',419,'Retail Sale Id 1604760',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 10:27:39','',''),(2607799,'1','186','940',419,'Retail Sale Id 1604859',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:42:22','',''),(2607803,'1','186','940',419,'Retail Sale Id 1604870',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:43:26','',''),(2607811,'1','186','940',419,'Retail Sale Id 1604879',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:44:51','',''),(2607827,'1','186','940',419,'Retail Sale Id 1604892',10640.00,0.00,0.00,19.00,1330.00,'2022-01-26 10:47:37','',''),(2607833,'1','186','940',419,'Retail Sale Id 1604900',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:48:19','',''),(2607847,'1','186','940',419,'Retail Sale Id 1604914',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 10:50:31','',''),(2607872,'1','186','940',419,'Retail Sale Id 1604938',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 10:54:31','',''),(2607889,'1','186','940',419,'Retail Sale Id 1604958',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:56:16','',''),(2607899,'1','186','940',419,'Retail Sale Id 1604968',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 10:57:05','',''),(2607915,'1','186','940',419,'Retail Sale Id 1604984',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:58:16','',''),(2607924,'1','186','940',419,'Retail Sale Id 1604994',7000.00,0.00,0.00,12.50,875.00,'2022-01-26 10:58:58','',''),(2607937,'1','186','940',419,'Retail Sale Id 1605001',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 11:00:08','',''),(2607947,'1','186','940',419,'Retail Sale Id 1605013',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 11:01:16','',''),(2608025,'1','186','940',419,'Retail Sale Id 1605071',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 11:09:08','',''),(2608030,'1','186','940',419,'Retail Sale Id 1605099',8400.00,0.00,0.00,15.00,1050.00,'2022-01-26 11:09:57','',''),(2613028,'1','186',NULL,419,'Balance from closing inventory values 2021-11-31 23:59:59',618304587.08,599997918.18,1930492.97,1928172.67,14978144.38,'2021-11-30 23:59:59','',''),(2613175,'1','186','940',0,'Balance from closing inventory values 2021-11-31 23:59:59',602604587.08,77848868.18,716726.33,714406.33,14978144.38,'2021-11-30 23:59:59','',''),(2615309,'1','186','940',419,'Retail Sale Id 1611317',664122.00,0.00,0.00,1302.20,26044.00,'2022-01-27 09:09:53','',''),(2615495,'1','186','940',419,'Distributed to AARANO for sales id:349392',188650.00,0.00,0.00,385.00,0.00,'2022-01-27 09:26:34','',''),(2619266,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12759600.00,26040.00,0.00,0.00,'2022-01-27 15:22:28','',''),(2619285,'1','186',NULL,419,'Reception corrector for bridging 132291',0.00,0.00,0.00,22999.70,0.00,'2022-01-27 15:24:39','',''),(2619286,'1','186','940',419,'Received from bridging 132291',0.00,0.00,22999.70,0.00,0.00,'2022-01-27 15:24:39','',''),(2619310,'1','186','940',419,'Retail Sale Id 1614870',2032000.00,0.00,0.00,4000.00,72000.00,'2022-01-27 15:26:26','',''),(2619316,'1','186','940',419,'Retail Sale Id 1614880',7000.00,0.00,0.00,12.50,875.00,'2022-01-27 15:27:18','',''),(2619331,'1','186','940',419,'Retail Sale Id 1614889',7000.00,0.00,0.00,12.50,875.00,'2022-01-27 15:27:59','',''),(2619343,'1','186','940',419,'Retail Sale Id 1614902',8400.00,0.00,0.00,15.00,1050.00,'2022-01-27 15:28:38','',''),(2619353,'1','186','940',419,'Retail Sale Id 1614909',8400.00,0.00,0.00,15.00,1050.00,'2022-01-27 15:29:27','',''),(2619364,'1','186','940',419,'Retail Sale Id 1614923',8400.00,0.00,0.00,15.00,1050.00,'2022-01-27 15:30:23','',''),(2619389,'1','186','940',419,'Retail Sale Id 1614948',8400.00,0.00,0.00,15.00,1050.00,'2022-01-27 15:32:28','',''),(2619396,'1','186','940',419,'Retail Sale Id 1614955',8400.00,0.00,0.00,15.00,1050.00,'2022-01-27 15:33:10','',''),(2619409,'1','186','940',419,'Retail Sale Id 1614962',7000.00,0.00,0.00,12.50,875.00,'2022-01-27 15:33:56','',''),(2624588,'1','186','940',419,'Retail Sale Id 1619082',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 09:57:08','',''),(2624612,'1','186','940',419,'Retail Sale Id 1619111',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 09:59:17','',''),(2624619,'1','186','940',419,'Retail Sale Id 1619115',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:00:01','',''),(2624642,'1','186','940',419,'Retail Sale Id 1619138',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:02:29','',''),(2624664,'1','186','940',419,'Retail Sale Id 1619156',7000.00,0.00,0.00,12.50,875.00,'2022-01-28 10:04:07','',''),(2624672,'1','186','940',419,'Retail Sale Id 1619167',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:05:09','',''),(2624677,'1','186','940',419,'Retail Sale Id 1619174',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:05:42','',''),(2624688,'1','186','940',419,'Retail Sale Id 1619179',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:06:27','',''),(2624695,'1','186','940',419,'Retail Sale Id 1619186',7000.00,0.00,0.00,12.50,875.00,'2022-01-28 10:07:06','',''),(2624701,'1','186','940',419,'Retail Sale Id 1619193',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:07:41','',''),(2624716,'1','186','940',419,'Retail Sale Id 1619203',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:08:22','',''),(2624724,'1','186','940',419,'Retail Sale Id 1619209',7000.00,0.00,0.00,12.50,875.00,'2022-01-28 10:08:53','',''),(2624745,'1','186','940',419,'Retail Sale Id 1619229',2286000.00,0.00,0.00,4500.00,81000.00,'2022-01-28 10:10:20','',''),(2624751,'1','186','940',419,'Retail Sale Id 1619233',7000.00,0.00,0.00,12.50,875.00,'2022-01-28 10:10:56','',''),(2624798,'1','186','940',419,'Retail Sale Id 1619257',7000.00,0.00,0.00,12.50,875.00,'2022-01-28 10:13:31','',''),(2624808,'1','186','940',419,'Retail Sale Id 1619266',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:14:18','',''),(2624812,'1','186','940',419,'Retail Sale Id 1619276',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:14:53','',''),(2624829,'1','186','940',419,'Retail Sale Id 1619285',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:15:30','',''),(2624836,'1','186','940',419,'Retail Sale Id 1619293',7000.00,0.00,0.00,12.50,875.00,'2022-01-28 10:16:12','',''),(2624842,'1','186','940',419,'Retail Sale Id 1619302',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:17:17','',''),(2624868,'1','186','940',419,'Retail Sale Id 1619317',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:18:06','',''),(2624876,'1','186','940',419,'Retail Sale Id 1619323',8400.00,0.00,0.00,15.00,1050.00,'2022-01-28 10:18:45','',''),(2631049,'1','186','940',419,'Retail Sale Id 1624870',2844800.00,0.00,0.00,5600.00,100800.00,'2022-01-28 20:21:04','',''),(2631063,'1','186','940',419,'Retail Sale Id 1624879',1912500.00,0.00,0.00,3750.00,75000.00,'2022-01-28 20:26:52','',''),(2632556,'1','186','940',419,'Return of Retail Sale Id 1624870',0.00,2844800.00,5600.00,0.00,-100800.00,'2022-01-29 09:54:46','',''),(2632572,'1','186','940',419,'Return of Retail Sale Id 1619229',0.00,2286000.00,4500.00,0.00,-81000.00,'2022-01-29 09:59:04','',''),(2632586,'1','186','940',419,'Return of Retail Sale Id 1624879',0.00,1912500.00,3750.00,0.00,-75000.00,'2022-01-29 10:02:13','',''),(2632859,'1','186','940',419,'Retail Sale Id 1626203',797560.00,0.00,0.00,1570.00,28260.00,'2022-01-29 10:20:34','',''),(2632886,'1','186','940',419,'Retail Sale Id 1626234',1168400.00,0.00,0.00,2300.00,41400.00,'2022-01-29 10:22:31','',''),(2633007,'1','186','940',419,'Return of Retail Sale Id 1626203',0.00,797560.00,1570.00,0.00,-28260.00,'2022-01-29 10:30:26','',''),(2633038,'1','186','940',419,'Retail Sale Id 1626351',800700.00,0.00,0.00,1570.00,31400.00,'2022-01-29 10:32:20','',''),(2633509,'1','186','940',419,'Retail Sale Id 1626753',508000.00,0.00,0.00,1000.00,18000.00,'2022-01-29 11:00:41','',''),(2633520,'1','186','940',419,'Retail Sale Id 1626784',8400.00,0.00,0.00,15.00,1050.00,'2022-01-29 11:01:19','',''),(2633545,'1','186','940',419,'Retail Sale Id 1626795',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:02:28','',''),(2633575,'1','186','940',419,'Retail Sale Id 1626805',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:03:26','',''),(2633597,'1','186','940',419,'Retail Sale Id 1626836',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:04:43','',''),(2633619,'1','186','940',419,'Retail Sale Id 1626850',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:05:25','',''),(2633640,'1','186','940',419,'Retail Sale Id 1626859',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:06:06','',''),(2633664,'1','186','940',419,'Retail Sale Id 1626871',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:06:45','',''),(2633672,'1','186','940',419,'Retail Sale Id 1626878',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:07:21','',''),(2633686,'1','186','940',419,'Retail Sale Id 1626896',8400.00,0.00,0.00,15.00,1050.00,'2022-01-29 11:07:55','',''),(2633695,'1','186','940',419,'Retail Sale Id 1626905',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:08:34','',''),(2633702,'1','186','940',419,'Retail Sale Id 1626911',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:09:08','',''),(2633717,'1','186','940',419,'Retail Sale Id 1626931',8400.00,0.00,0.00,15.00,1050.00,'2022-01-29 11:09:55','',''),(2633725,'1','186','940',419,'Retail Sale Id 1626938',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:10:31','',''),(2633739,'1','186','940',419,'Retail Sale Id 1626956',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:11:21','',''),(2633751,'1','186','940',419,'Retail Sale Id 1626965',10640.00,0.00,0.00,19.00,1330.00,'2022-01-29 11:12:01','',''),(2633759,'1','186','940',419,'Retail Sale Id 1626974',8400.00,0.00,0.00,15.00,1050.00,'2022-01-29 11:12:38','',''),(2633799,'1','186','940',419,'Retail Sale Id 1626990',3360.00,0.00,0.00,6.00,420.00,'2022-01-29 11:13:38','',''),(2633817,'1','186','940',419,'Retail Sale Id 1627014',3920.00,0.00,0.00,7.00,490.00,'2022-01-29 11:14:50','',''),(2633831,'1','186','940',419,'Retail Sale Id 1627028',5040.00,0.00,0.00,9.00,630.00,'2022-01-29 11:15:31','',''),(2633840,'1','186','940',419,'Retail Sale Id 1627037',7000.00,0.00,0.00,12.50,875.00,'2022-01-29 11:16:11','',''),(2633857,'1','186','940',419,'Retail Sale Id 1627051',5040.00,0.00,0.00,9.00,630.00,'2022-01-29 11:17:18','',''),(2640548,'1','186','940',419,'Retail Sale Id 1633024',762000.00,0.00,0.00,1500.00,27000.00,'2022-01-29 22:43:39','',''),(2642495,'1','186','940',419,'Retail Sale Id 1634633',331500.00,0.00,0.00,650.00,13000.00,'2022-01-30 09:54:37','',''),(2642612,'1','186','940',419,'Retail Sale Id 1634735',63280.00,0.00,0.00,113.00,7910.00,'2022-01-30 10:02:02','',''),(2642796,'1','186',NULL,419,'Reception corrector for bridging 132636',0.00,0.00,0.00,3040.30,0.00,'2022-01-30 10:14:38','',''),(2642797,'1','186','940',419,'Received from bridging 132636',0.00,0.00,3040.30,0.00,0.00,'2022-01-30 10:14:38','',''),(2642820,'1','186','940',419,'Retail Sale Id 1634941',3500000.00,0.00,0.00,7000.00,-420000.00,'2022-01-30 10:16:36','',''),(2642860,'1','186','940',419,'Retail Sale Id 1634986',1004000.00,0.00,0.00,2000.00,-116000.00,'2022-01-30 10:19:04','',''),(2642882,'1','186','940',419,'Retail Sale Id 1635007',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:20:17','',''),(2642893,'1','186','940',419,'Retail Sale Id 1635022',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:20:52','',''),(2642903,'1','186','940',419,'Retail Sale Id 1635028',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:21:29','',''),(2642920,'1','186','940',419,'Retail Sale Id 1635043',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:22:16','',''),(2642931,'1','186','940',419,'Retail Sale Id 1635051',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:22:51','',''),(2643055,'1','186','940',419,'Retail Sale Id 1635171',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:30:46','',''),(2643076,'1','186','940',419,'Retail Sale Id 1635190',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:31:51','',''),(2643118,'1','186','940',419,'Retail Sale Id 1635231',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:34:48','',''),(2643135,'1','186','940',419,'Retail Sale Id 1635238',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:35:39','',''),(2643158,'1','186','940',419,'Retail Sale Id 1635263',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:36:48','',''),(2643177,'1','186','940',419,'Retail Sale Id 1635282',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:37:40','',''),(2643185,'1','186','940',419,'Retail Sale Id 1635293',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:38:22','',''),(2643210,'1','186','940',419,'Retail Sale Id 1635307',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:39:06','',''),(2643253,'1','186','940',419,'Retail Sale Id 1635338',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:41:02','',''),(2643276,'1','186','940',419,'Retail Sale Id 1635353',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:41:58','',''),(2643371,'1','186','940',419,'Retail Sale Id 1635441',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:47:45','',''),(2643434,'1','186','940',419,'Retail Sale Id 1635459',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:48:54','',''),(2643450,'1','186','940',419,'Retail Sale Id 1635478',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:49:49','',''),(2643479,'1','186','940',419,'Retail Sale Id 1635509',8400.00,0.00,0.00,15.00,0.00,'2022-01-30 10:51:17','',''),(2643507,'1','186','940',419,'Retail Sale Id 1635520',7000.00,0.00,0.00,12.50,0.00,'2022-01-30 10:53:09','',''),(2643508,'1','186','940',419,'Retail Sale Id 1635521',112000.00,0.00,0.00,200.00,0.00,'2022-01-31 08:21:34','',''),(2643509,'1','186','940',419,'Retail Sale Id 1635522',1029100.00,0.00,0.00,2050.00,-118900.00,'2022-01-31 08:23:54','',''),(2643510,'1','186','940',419,'Retail Sale Id 1635523',1180150.00,0.00,0.00,2360.30,-141618.00,'2022-01-31 08:26:09','',''),(2643511,'1','186','940',419,'Retail Sale Id 1635524',8400.00,0.00,0.00,15.00,0.00,'2022-01-31 09:54:58','',''),(2643512,'1','186','940',419,'Return of Retail Sale Id 1635524',0.00,8400.00,15.00,0.00,0.00,'2022-01-31 09:56:13','',''),(2643513,'1','186','940',419,'Distributed to AARANO for sales id:349393',199920.00,0.00,0.00,357.00,0.00,'2022-01-31 10:01:27','',''),(2643514,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12066800.00,24880.00,0.00,0.00,'2022-01-31 10:06:44','',''),(2643515,'1','186',NULL,419,'Reception corrector for bridging 132637',0.00,0.00,0.00,23000.00,0.00,'2022-01-31 10:08:57','',''),(2643516,'1','186','940',419,'Received from bridging 132637',0.00,0.00,23000.00,0.00,0.00,'2022-01-31 10:08:57','',''),(2643517,'1','186','940',419,'Retail Sale Id 1635525',276360.00,0.00,0.00,493.50,37012.50,'2022-01-31 23:23:22','',''),(2643518,'1','186','940',419,'Retail Sale Id 1635526',1902580.00,0.00,0.00,3790.00,64430.00,'2022-01-31 23:24:17','',''),(2643519,'1','186','940',419,'Retail Sale Id 1635527',6725000.00,0.00,0.00,13450.00,201750.00,'2022-01-31 23:25:20','',''),(2643520,'1','186','940',419,'Retail Sale Id 1635529',500000.00,0.00,0.00,1000.00,15000.00,'2022-02-01 08:39:18','',''),(2643521,'1','186','940',419,'Retail Sale Id 1635531',2000000.00,0.00,0.00,4000.00,60000.00,'2022-02-01 09:06:54','',''),(2643522,'1','186','940',419,'Retail Sale Id 1635532',8400.00,0.00,0.00,15.00,1125.00,'2022-02-01 09:08:57','',''),(2643523,'1','186','940',419,'Retail Sale Id 1635533',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:09:45','',''),(2643524,'1','186','940',419,'Retail Sale Id 1635534',8400.00,0.00,0.00,15.00,1125.00,'2022-02-01 09:10:56','',''),(2643525,'1','186','940',419,'Retail Sale Id 1635535',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:11:41','',''),(2643526,'1','186','940',419,'Retail Sale Id 1635536',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:12:33','',''),(2643527,'1','186','940',419,'Retail Sale Id 1635537',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:15:21','',''),(2643528,'1','186','940',419,'Retail Sale Id 1635538',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:17:21','',''),(2643529,'1','186','940',419,'Retail Sale Id 1635539',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:18:15','',''),(2643530,'1','186','940',419,'Retail Sale Id 1635540',7000.00,0.00,0.00,12.50,937.50,'2022-02-01 09:18:52','',''),(2643531,'1','186','940',419,'Retail Sale Id 1635541',8400.00,0.00,0.00,15.00,1125.00,'2022-02-01 09:19:23','',''),(2643532,'1','186','940',419,'Retail Sale Id 1635542',8400.00,0.00,0.00,15.00,1125.00,'2022-02-01 09:19:59','',''),(2643533,'1','186','940',419,'Retail Sale Id 1635543',10640.00,0.00,0.00,19.00,1425.00,'2022-02-01 09:20:36','',''),(2643534,'1','186','940',419,'Retail Sale Id 1635544',8400.00,0.00,0.00,15.00,1125.00,'2022-02-01 09:56:53','',''),(2643535,'1','186','940',419,'Retail Sale Id 1635545',8400.00,0.00,0.00,15.00,1125.00,'2022-02-01 09:58:43','',''),(2643536,'1','186',NULL,419,'Reception corrector for bridging 132638',0.00,0.00,0.00,1880.00,0.00,'2022-02-02 08:36:40','',''),(2643537,'1','186','940',419,'Received from bridging 132638',0.00,0.00,1880.00,0.00,0.00,'2022-02-02 08:36:40','',''),(2643538,'1','186','940',419,'Retail Sale Id 1635546',600000.00,0.00,0.00,1200.00,18000.00,'2022-02-02 08:39:37','',''),(2643539,'1','186','940',419,'Retail Sale Id 1635547',197788.00,0.00,0.00,394.00,6698.00,'2022-02-02 08:50:57','',''),(2643540,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349394',172660.00,0.00,0.00,356.00,0.00,'2022-02-02 09:53:25','',''),(2643541,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12125000.00,25000.00,0.00,0.00,'2022-02-02 10:16:45','',''),(2643542,'1','186',NULL,419,'Reception corrector for bridging 132639',0.00,0.00,0.00,23000.00,0.00,'2022-02-02 10:18:26','',''),(2643543,'1','186','940',419,'Received from bridging 132639',0.00,0.00,23000.00,0.00,0.00,'2022-02-02 10:18:26','',''),(2643544,'1','186','940',419,'Retail Sale Id 1635548',2250000.00,0.00,0.00,4500.00,67500.00,'2022-02-02 10:19:45','',''),(2643545,'1','186','940',419,'Retail Sale Id 1635549',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:32:57','',''),(2643546,'1','186','940',419,'Retail Sale Id 1635550',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:33:29','',''),(2643547,'1','186','940',419,'Retail Sale Id 1635551',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:33:58','',''),(2643548,'1','186','940',419,'Retail Sale Id 1635552',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:34:33','',''),(2643549,'1','186','940',419,'Retail Sale Id 1635553',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:35:16','',''),(2643550,'1','186','940',419,'Retail Sale Id 1635554',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:36:51','',''),(2643551,'1','186','940',419,'Retail Sale Id 1635555',8400.00,0.00,0.00,15.00,1125.00,'2022-02-02 10:38:02','',''),(2643552,'1','186','940',419,'Retail Sale Id 1635556',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:38:43','',''),(2643553,'1','186','940',419,'Retail Sale Id 1635557',8400.00,0.00,0.00,15.00,1125.00,'2022-02-02 10:39:27','',''),(2643554,'1','186','940',419,'Retail Sale Id 1635558',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:41:58','',''),(2643555,'1','186','940',419,'Retail Sale Id 1635559',8400.00,0.00,0.00,15.00,1125.00,'2022-02-02 10:43:02','',''),(2643556,'1','186','940',419,'Retail Sale Id 1635560',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:43:53','',''),(2643557,'1','186','940',419,'Retail Sale Id 1635561',8400.00,0.00,0.00,15.00,1125.00,'2022-02-02 10:44:33','',''),(2643558,'1','186','940',419,'Retail Sale Id 1635562',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:46:41','',''),(2643559,'1','186','940',419,'Retail Sale Id 1635563',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:47:27','',''),(2643560,'1','186','940',419,'Retail Sale Id 1635564',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:48:26','',''),(2643561,'1','186','940',419,'Retail Sale Id 1635565',7000.00,0.00,0.00,12.50,937.50,'2022-02-02 10:48:57','',''),(2643562,'1','186','940',419,'Retail Sale Id 1635566',2500000.00,0.00,0.00,5000.00,75000.00,'2022-02-02 21:19:58','',''),(2643563,'1','186','940',419,'Retail Sale Id 1635567',207075.00,0.00,0.00,412.50,7012.50,'2022-02-02 21:21:52','',''),(2643564,'1','186','940',419,'Retail Sale Id 1635568',2500000.00,0.00,0.00,5000.00,75000.00,'2022-02-02 21:23:54','',''),(2643565,'1','186','940',419,'Retail Sale Id 1635569',1857400.00,0.00,0.00,3700.00,62900.00,'2022-02-02 21:27:27','',''),(2643566,'1','186','940',419,'Retail Sale Id 1635570',220080.00,0.00,0.00,393.00,29475.00,'2022-02-03 08:22:38','',''),(2643567,'1','186','940',419,'Retail Sale Id 1635571',7000.00,0.00,0.00,12.50,937.50,'2022-02-03 08:35:11','',''),(2643568,'1','186','940',419,'Retail Sale Id 1635572',7000.00,0.00,0.00,12.50,937.50,'2022-02-03 08:35:44','',''),(2643569,'1','186','940',419,'Retail Sale Id 1635573',7000.00,0.00,0.00,12.50,937.50,'2022-02-03 08:36:30','',''),(2643570,'1','186','940',419,'Retail Sale Id 1635574',7000.00,0.00,0.00,12.50,937.50,'2022-02-03 08:37:11','',''),(2643571,'1','186','940',419,'Retail Sale Id 1635575',7000.00,0.00,0.00,12.50,937.50,'2022-02-03 08:38:01','',''),(2643572,'1','186',NULL,419,'Reception corrector for bridging 132640',0.00,0.00,0.00,2000.00,0.00,'2022-02-03 08:41:29','',''),(2643573,'1','186','940',419,'Received from bridging 132640',0.00,0.00,2000.00,0.00,0.00,'2022-02-03 08:41:29','',''),(2643574,'1','186','940',419,'Retail Sale Id 1635576',2000000.00,0.00,0.00,4000.00,60000.00,'2022-02-03 08:47:21','',''),(2643575,'1','186','940',419,'Retail Sale Id 1635577',678453.00,0.00,0.00,1351.50,22975.50,'2022-02-04 08:36:38','',''),(2643576,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349395',173630.00,0.00,0.00,358.00,0.00,'2022-02-04 09:17:05','',''),(2643577,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12110450.00,24970.00,0.00,0.00,'2022-02-04 13:59:24','',''),(2643578,'1','186',NULL,419,'Reception corrector for bridging 132641',0.00,0.00,0.00,23000.00,0.00,'2022-02-04 14:01:35','',''),(2643579,'1','186','940',419,'Received from bridging 132641',0.00,0.00,23000.00,0.00,0.00,'2022-02-04 14:01:35','',''),(2643580,'1','186','940',419,'Retail Sale Id 1635578',3500000.00,0.00,0.00,7000.00,105000.00,'2022-02-04 14:04:37','',''),(2643581,'1','186','940',419,'Retail Sale Id 1635579',7000.00,0.00,0.00,12.50,937.50,'2022-02-04 14:05:20','',''),(2643582,'1','186','940',419,'Retail Sale Id 1635580',8400.00,0.00,0.00,15.00,1125.00,'2022-02-04 14:07:22','',''),(2643583,'1','186','940',419,'Retail Sale Id 1635581',8400.00,0.00,0.00,15.00,1125.00,'2022-02-04 14:09:00','',''),(2643584,'1','186','940',419,'Retail Sale Id 1635582',7000.00,0.00,0.00,12.50,937.50,'2022-02-04 14:09:47','',''),(2643585,'1','186','940',419,'Retail Sale Id 1635583',7000.00,0.00,0.00,12.50,937.50,'2022-02-04 14:10:37','',''),(2643586,'1','186','940',419,'Retail Sale Id 1635584',8400.00,0.00,0.00,15.00,1125.00,'2022-02-04 14:12:14','',''),(2643587,'1','186','940',419,'Retail Sale Id 1635585',1885010.00,0.00,0.00,3755.00,63835.00,'2022-02-04 21:43:38','',''),(2643588,'1','186','940',419,'Retail Sale Id 1635586',3250000.00,0.00,0.00,6500.00,97500.00,'2022-02-05 08:28:28','',''),(2643589,'1','186','940',419,'Retail Sale Id 1635587',348880.00,0.00,0.00,623.00,46725.00,'2022-02-05 08:32:22','',''),(2643590,'1','186','940',419,'Retail Sale Id 1635588',502000.00,0.00,0.00,1000.00,17000.00,'2022-02-05 08:33:22','',''),(2643591,'1','186',NULL,419,'Reception corrector for bridging 132642',0.00,0.00,0.00,1970.00,0.00,'2022-02-05 09:15:37','',''),(2643592,'1','186','940',419,'Received from bridging 132642',0.00,0.00,1970.00,0.00,0.00,'2022-02-05 09:15:37','',''),(2643593,'1','186','940',419,'Retail Sale Id 1635589',8400.00,0.00,0.00,15.00,1125.00,'2022-02-05 09:17:04','',''),(2643594,'1','186','940',419,'Retail Sale Id 1635590',7000.00,0.00,0.00,12.50,937.50,'2022-02-05 09:17:56','',''),(2643595,'1','186','940',419,'Retail Sale Id 1635591',7000.00,0.00,0.00,12.50,937.50,'2022-02-05 09:18:50','',''),(2643596,'1','186','940',419,'Retail Sale Id 1635592',7000.00,0.00,0.00,12.50,937.50,'2022-02-05 09:20:38','',''),(2643597,'1','186','940',419,'Retail Sale Id 1635593',150000.00,0.00,0.00,300.00,4500.00,'2022-02-05 09:23:57','',''),(2643598,'1','186','940',419,'Retail Sale Id 1635594',2000000.00,0.00,0.00,4000.00,60000.00,'2022-02-05 21:39:49','',''),(2643599,'1','186','940',419,'Retail Sale Id 1635595',552200.00,0.00,0.00,1100.00,18700.00,'2022-02-05 21:42:13','',''),(2643600,'1','186','940',419,'Retail Sale Id 1635596',112000.00,0.00,0.00,200.00,15000.00,'2022-02-06 10:04:30','',''),(2643601,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349396',173145.00,0.00,0.00,357.00,0.00,'2022-02-06 10:24:25','',''),(2643602,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12115300.00,24980.00,0.00,0.00,'2022-02-06 21:01:14','',''),(2643603,'1','186',NULL,419,'Reception corrector for bridging 132643',0.00,0.00,0.00,23000.00,0.00,'2022-02-06 21:04:05','',''),(2643604,'1','186','940',419,'Received from bridging 132643',0.00,0.00,23000.00,0.00,0.00,'2022-02-06 21:04:05','',''),(2643605,'1','186','940',419,'Retail Sale Id 1635597',1275000.00,0.00,0.00,2550.00,38250.00,'2022-02-06 21:15:22','',''),(2643606,'1','186','940',419,'Retail Sale Id 1635598',7000.00,0.00,0.00,12.50,937.50,'2022-02-07 10:36:41','',''),(2643607,'1','186','940',419,'Retail Sale Id 1635599',7000.00,0.00,0.00,12.50,937.50,'2022-02-07 10:37:25','',''),(2643608,'1','186','940',419,'Retail Sale Id 1635600',8400.00,0.00,0.00,15.00,1125.00,'2022-02-07 10:38:23','',''),(2643609,'1','186','940',419,'Retail Sale Id 1635601',1500000.00,0.00,0.00,3000.00,45000.00,'2022-02-07 10:42:10','',''),(2643610,'1','186','940',419,'Retail Sale Id 1635602',7000.00,0.00,0.00,12.50,937.50,'2022-02-07 10:44:55','',''),(2643611,'1','186','940',419,'Retail Sale Id 1635603',8400.00,0.00,0.00,15.00,1125.00,'2022-02-07 10:47:12','',''),(2643612,'1','186','940',419,'Retail Sale Id 1635604',8400.00,0.00,0.00,15.00,1125.00,'2022-02-07 10:48:25','',''),(2643613,'1','186','940',419,'Retail Sale Id 1635605',7000.00,0.00,0.00,12.50,937.50,'2022-02-07 10:50:02','',''),(2643614,'1','186','940',419,'Retail Sale Id 1635606',8400.00,0.00,0.00,15.00,1125.00,'2022-02-07 10:50:47','',''),(2643615,'1','186','940',419,'Retail Sale Id 1635607',7000.00,0.00,0.00,12.50,937.50,'2022-02-07 10:51:26','',''),(2643616,'1','186','940',419,'Retail Sale Id 1635608',8400.00,0.00,0.00,15.00,1125.00,'2022-02-07 10:52:00','',''),(2643617,'1','186','940',419,'Retail Sale Id 1635609',7000.00,0.00,0.00,12.50,937.50,'2022-02-07 10:53:16','',''),(2643618,'1','186','940',419,'Retail Sale Id 1635610',8400.00,0.00,0.00,15.00,1125.00,'2022-02-07 10:54:12','',''),(2643619,'1','186','940',419,'Retail Sale Id 1635611',10640.00,0.00,0.00,19.00,1425.00,'2022-02-07 10:56:19','',''),(2643620,'1','186','940',419,'Retail Sale Id 1635612',4675000.00,0.00,0.00,9350.00,140250.00,'2022-02-08 08:58:48','',''),(2643621,'1','186','940',419,'Retail Sale Id 1635613',1681700.00,0.00,0.00,3350.00,56950.00,'2022-02-08 09:08:02','',''),(2643622,'1','186','940',419,'Retail Sale Id 1635614',301840.00,0.00,0.00,539.00,40425.00,'2022-02-08 09:37:21','',''),(2643623,'1','186',NULL,419,'Reception corrector for bridging 132644',0.00,0.00,0.00,1980.00,0.00,'2022-02-08 10:02:02','',''),(2643624,'1','186','940',419,'Received from bridging 132644',0.00,0.00,1980.00,0.00,0.00,'2022-02-08 10:02:02','',''),(2643625,'1','186','940',419,'Retail Sale Id 1635615',8400.00,0.00,0.00,15.00,1125.00,'2022-02-08 10:09:14','',''),(2643626,'1','186','940',419,'Retail Sale Id 1635616',7000.00,0.00,0.00,12.50,937.50,'2022-02-08 10:11:25','',''),(2643627,'1','186','940',419,'Retail Sale Id 1635617',1500000.00,0.00,0.00,3000.00,45000.00,'2022-02-08 10:12:10','',''),(2643628,'1','186','940',419,'Retail Sale Id 1635618',7000.00,0.00,0.00,12.50,937.50,'2022-02-08 10:12:57','',''),(2643629,'1','186','940',419,'Retail Sale Id 1635619',8400.00,0.00,0.00,15.00,1125.00,'2022-02-08 10:14:07','',''),(2643630,'1','186','940',419,'Retail Sale Id 1635620',7000.00,0.00,0.00,12.50,937.50,'2022-02-08 10:15:28','',''),(2643631,'1','186','940',419,'Retail Sale Id 1635621',7000.00,0.00,0.00,12.50,937.50,'2022-02-08 10:16:05','',''),(2643632,'1','186','940',419,'Retail Sale Id 1635622',7000.00,0.00,0.00,12.50,937.50,'2022-02-08 10:16:39','',''),(2643633,'1','186','940',419,'Retail Sale Id 1635623',8400.00,0.00,0.00,15.00,1125.00,'2022-02-08 10:18:09','',''),(2643634,'1','186','940',419,'Retail Sale Id 1635624',7000.00,0.00,0.00,12.50,937.50,'2022-02-08 10:19:37','',''),(2643635,'1','186','940',419,'Retail Sale Id 1635625',8400.00,0.00,0.00,15.00,1125.00,'2022-02-08 10:21:17','',''),(2643636,'1','186','940',419,'Retail Sale Id 1635626',8400.00,0.00,0.00,15.00,1125.00,'2022-02-08 10:21:53','',''),(2643637,'1','186','940',419,'Retail Sale Id 1635627',752849.40,0.00,0.00,1499.70,25494.90,'2022-02-09 09:03:46','',''),(2643638,'1','186','940',419,'Retail Sale Id 1635628',35280.00,0.00,0.00,63.00,4725.00,'2022-02-09 09:08:14','',''),(2643639,'1','186','940',419,'Retail Sale Id 1635629',468500.00,0.00,0.00,937.00,14055.00,'2022-02-09 09:11:59','',''),(2643640,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349397',173145.00,0.00,0.00,357.00,0.00,'2022-02-09 09:36:43','',''),(2643641,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12028000.00,24800.00,0.00,0.00,'2022-02-09 19:06:04','',''),(2643642,'1','186',NULL,419,'Reception corrector for bridging 132645',0.00,0.00,0.00,22999.70,0.00,'2022-02-09 19:08:42','',''),(2643643,'1','186','940',419,'Received from bridging 132645',0.00,0.00,22999.70,0.00,0.00,'2022-02-09 19:08:42','',''),(2643644,'1','186','940',419,'Retail Sale Id 1635630',1000000.00,0.00,0.00,2000.00,30000.00,'2022-02-09 19:27:49','',''),(2643645,'1','186','940',419,'Retail Sale Id 1635631',10920.00,0.00,0.00,19.50,1462.50,'2022-02-10 09:37:21','',''),(2643646,'1','186','940',419,'Retail Sale Id 1635632',3500000.00,0.00,0.00,7000.00,105000.00,'2022-02-10 09:56:00','',''),(2643647,'1','186','940',419,'Retail Sale Id 1635633',7000.00,0.00,0.00,12.50,937.50,'2022-02-10 10:06:59','',''),(2643648,'1','186','940',419,'Retail Sale Id 1635634',500000.00,0.00,0.00,1000.00,15000.00,'2022-02-10 10:07:52','',''),(2643649,'1','186','940',419,'Retail Sale Id 1635635',1004000.00,0.00,0.00,2000.00,34000.00,'2022-02-10 10:08:59','',''),(2643650,'1','186','940',419,'Retail Sale Id 1635636',2500000.00,0.00,0.00,5000.00,75000.00,'2022-02-11 10:30:30','',''),(2643651,'1','186','940',419,'Retail Sale Id 1635637',150600.00,0.00,0.00,300.00,5100.00,'2022-02-11 10:31:46','',''),(2643652,'1','186','940',419,'Retail Sale Id 1635638',183120.00,0.00,0.00,327.00,24525.00,'2022-02-11 10:32:52','',''),(2643653,'1','186','940',419,'Retail Sale Id 1635639',2500000.00,0.00,0.00,5000.00,75000.00,'2022-02-11 10:47:39','',''),(2643654,'1','186',NULL,419,'Reception corrector for bridging 132646',0.00,0.00,0.00,1800.30,0.00,'2022-02-11 10:49:52','',''),(2643655,'1','186','940',419,'Received from bridging 132646',0.00,0.00,1800.30,0.00,0.00,'2022-02-11 10:49:52','',''),(2643656,'1','186','940',419,'Retail Sale Id 1635640',552200.00,0.00,0.00,1100.00,18700.00,'2022-02-11 10:54:30','',''),(2643657,'1','186','940',419,'Retail Sale Id 1635641',7000.00,0.00,0.00,12.50,937.50,'2022-02-11 10:55:13','',''),(2643658,'1','186','940',419,'Retail Sale Id 1635642',121520.00,0.00,0.00,217.00,16275.00,'2022-02-12 10:31:28','',''),(2643659,'1','186','940',419,'Retail Sale Id 1635643',226250.00,0.00,0.00,452.50,6787.50,'2022-02-12 10:40:31','',''),(2643660,'1','186','940',419,'Distributed to AARANO for sales id:349399',174260.50,0.00,0.00,359.30,0.00,'2022-02-12 12:15:44','',''),(2643661,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12081350.00,24910.00,0.00,0.00,'2022-02-12 20:29:15','',''),(2643662,'1','186',NULL,419,'Reception corrector for bridging 132647',0.00,0.00,0.00,23000.00,0.00,'2022-02-12 20:31:02','',''),(2643663,'1','186','940',419,'Received from bridging 132647',0.00,0.00,23000.00,0.00,0.00,'2022-02-12 20:31:02','',''),(2643664,'1','186','940',419,'Retail Sale Id 1635645',3500000.00,0.00,0.00,7000.00,105000.00,'2022-02-13 10:56:07','',''),(2643665,'1','186','940',419,'Retail Sale Id 1635646',1681700.00,0.00,0.00,3350.00,56950.00,'2022-02-13 11:01:20','',''),(2643666,'1','186','940',419,'Retail Sale Id 1635647',2500000.00,0.00,0.00,5000.00,75000.00,'2022-02-13 11:04:00','',''),(2643667,'1','186','940',419,'Return of Retail Sale Id 1635647',0.00,2500000.00,5000.00,0.00,-75000.00,'2022-02-13 11:04:47','',''),(2643668,'1','186','940',419,'Return of Retail Sale Id 1635646',0.00,1681700.00,3350.00,0.00,-56950.00,'2022-02-13 11:05:16','',''),(2643669,'1','186','940',419,'Return of Retail Sale Id 1635645',0.00,3500000.00,7000.00,0.00,-105000.00,'2022-02-13 11:05:57','',''),(2643670,'1','186','940',419,'Retail Sale Id 1635648',825000.00,0.00,0.00,1650.00,24750.00,'2022-02-13 11:07:24','',''),(2643671,'1','186','940',419,'Retail Sale Id 1635649',350000.00,0.00,0.00,700.00,10500.00,'2022-02-13 11:12:44','',''),(2643672,'1','186','940',419,'Retail Sale Id 1635650',6775000.00,0.00,0.00,13550.00,203250.00,'2022-02-14 09:23:45','',''),(2643673,'1','186','940',419,'Retail Sale Id 1635651',1691740.00,0.00,0.00,3370.00,57290.00,'2022-02-14 09:25:13','',''),(2643674,'1','186','940',419,'Retail Sale Id 1635652',399616.00,0.00,0.00,713.60,53520.00,'2022-02-14 09:36:39','',''),(2643675,'1','186',NULL,419,'Reception corrector for bridging 132648',0.00,0.00,0.00,1910.00,0.00,'2022-02-14 09:54:34','',''),(2643676,'1','186','940',419,'Received from bridging 132648',0.00,0.00,1910.00,0.00,0.00,'2022-02-14 09:54:34','',''),(2643677,'1','186','940',419,'Retail Sale Id 1635653',7000.00,0.00,0.00,12.50,937.50,'2022-02-14 10:15:22','',''),(2643678,'1','186','940',419,'Retail Sale Id 1635654',7000.00,0.00,0.00,12.50,937.50,'2022-02-14 10:15:56','',''),(2643679,'1','186','940',419,'Retail Sale Id 1635655',8400.00,0.00,0.00,15.00,1125.00,'2022-02-14 10:16:48','',''),(2643680,'1','186','940',419,'Retail Sale Id 1635656',1250000.00,0.00,0.00,2500.00,37500.00,'2022-02-14 10:17:43','',''),(2643681,'1','186','940',419,'Retail Sale Id 1635657',727900.00,0.00,0.00,1450.00,24650.00,'2022-02-15 10:10:37','',''),(2643682,'1','186','940',419,'Retail Sale Id 1635658',287200.00,0.00,0.00,574.40,8616.00,'2022-02-15 10:12:21','',''),(2643683,'1','186','940',419,'Distributed to AARANO for sales id:349400',175570.00,0.00,0.00,362.00,0.00,'2022-02-15 10:43:53','',''),(2643684,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12047400.00,24840.00,0.00,0.00,'2022-02-15 20:27:50','',''),(2643685,'1','186',NULL,419,'Reception corrector for bridging 132649',0.00,0.00,0.00,23000.00,0.00,'2022-02-15 20:29:20','',''),(2643686,'1','186','940',419,'Received from bridging 132649',0.00,0.00,23000.00,0.00,0.00,'2022-02-15 20:29:20','',''),(2643687,'1','186','940',419,'Retail Sale Id 1635659',1725000.00,0.00,0.00,3450.00,51750.00,'2022-02-16 08:49:13','',''),(2643688,'1','186','940',419,'Return of Retail Sale Id 1635659',0.00,1725000.00,3450.00,0.00,-51750.00,'2022-02-16 08:50:52','',''),(2643689,'1','186','940',419,'Retail Sale Id 1635660',178920.00,0.00,0.00,319.50,23962.50,'2022-02-16 08:51:39','',''),(2643690,'1','186','940',419,'Retail Sale Id 1635661',1731900.00,0.00,0.00,3450.00,58650.00,'2022-02-16 08:52:34','',''),(2643691,'1','186','940',419,'Retail Sale Id 1635662',6735000.00,0.00,0.00,13470.00,202050.00,'2022-02-16 08:56:35','',''),(2643692,'1','186','940',419,'Retail Sale Id 1635663',8400.00,0.00,0.00,15.00,1125.00,'2022-02-16 09:21:35','',''),(2643693,'1','186','940',419,'Retail Sale Id 1635664',8400.00,0.00,0.00,15.00,1125.00,'2022-02-16 09:22:22','',''),(2643694,'1','186','940',419,'Retail Sale Id 1635665',7000.00,0.00,0.00,12.50,937.50,'2022-02-16 09:22:58','',''),(2643695,'1','186','940',419,'Retail Sale Id 1635666',7000.00,0.00,0.00,12.50,937.50,'2022-02-16 09:23:35','',''),(2643696,'1','186','940',419,'Retail Sale Id 1635667',2000000.00,0.00,0.00,4000.00,60000.00,'2022-02-16 09:24:43','',''),(2643697,'1','186','940',419,'Retail Sale Id 1635668',8400.00,0.00,0.00,15.00,1125.00,'2022-02-16 09:26:41','',''),(2643698,'1','186','940',419,'Retail Sale Id 1635669',7000.00,0.00,0.00,12.50,937.50,'2022-02-16 09:27:44','',''),(2643699,'1','186','940',419,'Retail Sale Id 1635670',7000.00,0.00,0.00,12.50,937.50,'2022-02-16 09:28:42','',''),(2643700,'1','186','940',419,'Retail Sale Id 1635671',8400.00,0.00,0.00,15.00,1125.00,'2022-02-16 09:29:19','',''),(2643701,'1','186','940',419,'Return of Retail Sale Id 1635667',0.00,2000000.00,4000.00,0.00,-60000.00,'2022-02-17 07:41:03','',''),(2643702,'1','186','940',419,'Retail Sale Id 1635672',2000000.00,0.00,0.00,4000.00,60000.00,'2022-02-17 07:51:40','',''),(2643703,'1','186','940',419,'Return of Retail Sale Id 1635672',0.00,2000000.00,4000.00,0.00,-60000.00,'2022-02-17 07:54:38','',''),(2643704,'1','186',NULL,419,'Reception corrector for bridging 132650',0.00,0.00,0.00,1840.00,0.00,'2022-02-17 08:00:50','',''),(2643705,'1','186','940',419,'Received from bridging 132650',0.00,0.00,1840.00,0.00,0.00,'2022-02-17 08:00:50','',''),(2643706,'1','186','940',419,'Retail Sale Id 1635673',3075000.00,0.00,0.00,6150.00,92250.00,'2022-02-17 08:05:30','',''),(2643707,'1','186','940',419,'Retail Sale Id 1635674',494470.00,0.00,0.00,985.00,16745.00,'2022-02-17 08:10:02','',''),(2643708,'1','186','940',419,'Distributed to AARANO for sales id:349401',172417.50,0.00,0.00,355.50,0.00,'2022-02-17 20:11:33','',''),(2643709,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12095900.00,24940.00,0.00,0.00,'2022-02-18 09:30:37','',''),(2643710,'1','186',NULL,419,'Reception corrector for bridging 132651',0.00,0.00,0.00,23000.00,0.00,'2022-02-18 09:32:15','',''),(2643711,'1','186','940',419,'Received from bridging 132651',0.00,0.00,23000.00,0.00,0.00,'2022-02-18 09:32:15','',''),(2643712,'1','186','940',419,'Retail Sale Id 1635676',1515000.00,0.00,0.00,3030.00,45450.00,'2022-02-18 09:35:53','',''),(2643713,'1','186','940',419,'Retail Sale Id 1635677',1500000.00,0.00,0.00,3000.00,45000.00,'2022-02-18 09:46:10','',''),(2643714,'1','186','940',419,'Retail Sale Id 1635678',8400.00,0.00,0.00,15.00,1125.00,'2022-02-18 09:47:05','',''),(2643715,'1','186','940',419,'Retail Sale Id 1635679',7000.00,0.00,0.00,12.50,937.50,'2022-02-18 10:02:31','',''),(2643716,'1','186','940',419,'Retail Sale Id 1635680',8400.00,0.00,0.00,15.00,1125.00,'2022-02-18 10:03:09','',''),(2643717,'1','186','940',419,'Retail Sale Id 1635681',10640.00,0.00,0.00,19.00,1425.00,'2022-02-18 10:03:41','',''),(2643718,'1','186','940',419,'Retail Sale Id 1635682',7000.00,0.00,0.00,12.50,937.50,'2022-02-18 10:04:13','',''),(2643719,'1','186','940',419,'Retail Sale Id 1635683',8400.00,0.00,0.00,15.00,1125.00,'2022-02-18 10:04:49','',''),(2643720,'1','186','940',419,'Retail Sale Id 1635684',8400.00,0.00,0.00,15.00,1125.00,'2022-02-18 10:05:22','',''),(2643721,'1','186','940',419,'Retail Sale Id 1635685',7000.00,0.00,0.00,12.50,937.50,'2022-02-18 10:06:12','',''),(2643722,'1','186','940',419,'Retail Sale Id 1635686',7000.00,0.00,0.00,12.50,937.50,'2022-02-18 10:07:14','',''),(2643723,'1','186','940',419,'Retail Sale Id 1635687',7000.00,0.00,0.00,12.50,937.50,'2022-02-18 17:09:13','',''),(2643724,'1','186','940',419,'Retail Sale Id 1635688',2500000.00,0.00,0.00,5000.00,75000.00,'2022-02-19 10:12:09','',''),(2643725,'1','186','940',419,'Retail Sale Id 1635689',2233900.00,0.00,0.00,4450.00,75650.00,'2022-02-19 10:14:46','',''),(2643726,'1','186','940',419,'Retail Sale Id 1635690',1885000.00,0.00,0.00,3770.00,56550.00,'2022-02-19 10:20:08','',''),(2643727,'1','186','940',419,'Retail Sale Id 1635691',244832.00,0.00,0.00,437.20,32790.00,'2022-02-19 10:26:06','',''),(2643728,'1','186','940',419,'Retail Sale Id 1635692',1000000.00,0.00,0.00,2000.00,30000.00,'2022-02-19 10:41:02','',''),(2643729,'1','186','940',419,'Retail Sale Id 1635693',480916.00,0.00,0.00,958.00,16286.00,'2022-02-19 22:00:18','',''),(2643730,'1','186',NULL,419,'Reception corrector for bridging 132652',0.00,0.00,0.00,1940.00,0.00,'2022-02-19 22:04:32','',''),(2643731,'1','186','940',419,'Received from bridging 132652',0.00,0.00,1940.00,0.00,0.00,'2022-02-19 22:04:32','',''),(2643732,'1','186','940',419,'Retail Sale Id 1635694',750000.00,0.00,0.00,1500.00,22500.00,'2022-02-19 22:04:55','',''),(2643733,'1','186','940',419,'Return of Retail Sale Id 1635692',0.00,1000000.00,2000.00,0.00,-30000.00,'2022-02-20 08:40:07','',''),(2643734,'1','186','940',419,'Retail Sale Id 1635695',289520.00,0.00,0.00,517.00,38775.00,'2022-02-20 09:11:26','',''),(2643735,'1','186','940',419,'Retail Sale Id 1635696',887000.00,0.00,0.00,1774.00,26610.00,'2022-02-20 09:14:27','',''),(2643736,'1','186','940',419,'Distributed to AARANO for sales id:349402',175715.50,0.00,0.00,362.30,0.00,'2022-02-20 09:30:26','',''),(2643737,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12076500.00,24900.00,0.00,0.00,'2022-02-20 09:34:36','',''),(2643738,'1','186',NULL,419,'Reception corrector for bridging 132653',0.00,0.00,0.00,23000.00,0.00,'2022-02-20 09:37:02','',''),(2643739,'1','186','940',419,'Received from bridging 132653',0.00,0.00,23000.00,0.00,0.00,'2022-02-20 09:37:02','',''),(2643740,'1','186','940',419,'Retail Sale Id 1635698',1000000.00,0.00,0.00,2000.00,30000.00,'2022-02-20 09:39:48','',''),(2643741,'1','186','940',419,'Retail Sale Id 1635699',251000.00,0.00,0.00,500.00,8500.00,'2022-02-20 09:42:27','',''),(2643742,'1','186','940',419,'Retail Sale Id 1635700',7000.00,0.00,0.00,12.50,937.50,'2022-02-20 09:43:36','',''),(2643743,'1','186','940',419,'Retail Sale Id 1635701',8400.00,0.00,0.00,15.00,1125.00,'2022-02-20 09:44:07','',''),(2643744,'1','186','940',419,'Retail Sale Id 1635702',10640.00,0.00,0.00,19.00,1425.00,'2022-02-20 09:44:48','',''),(2643745,'1','186','940',419,'Retail Sale Id 1635703',10640.00,0.00,0.00,19.00,1425.00,'2022-02-20 09:45:26','',''),(2643746,'1','186','940',419,'Retail Sale Id 1635704',7000.00,0.00,0.00,12.50,937.50,'2022-02-20 09:45:59','',''),(2643747,'1','186','940',419,'Retail Sale Id 1635705',7000.00,0.00,0.00,12.50,937.50,'2022-02-20 09:46:31','',''),(2643748,'1','186','940',419,'Retail Sale Id 1635706',8400.00,0.00,0.00,15.00,1125.00,'2022-02-20 09:47:09','',''),(2643749,'1','186','940',419,'Retail Sale Id 1635707',7000.00,0.00,0.00,12.50,937.50,'2022-02-20 09:47:59','',''),(2643750,'1','186','940',419,'Retail Sale Id 1635708',7000.00,0.00,0.00,12.50,937.50,'2022-02-20 09:55:02','',''),(2643751,'1','186','940',419,'Retail Sale Id 1635709',750000.00,0.00,0.00,500.00,507500.00,'2022-02-20 18:02:18','',''),(2643752,'1','186','940',419,'Retail Sale Id 1635710',7000.00,0.00,0.00,12.50,937.50,'2022-02-20 19:07:51','',''),(2643753,'1','186','940',419,'Retail Sale Id 1635711',315504.00,0.00,0.00,563.40,42255.00,'2022-02-21 09:20:17','',''),(2643754,'1','186','940',419,'Retail Sale Id 1635712',1500000.00,0.00,0.00,3000.00,45000.00,'2022-02-21 09:39:04','',''),(2643755,'1','186','940',419,'Retail Sale Id 1635713',10640.00,0.00,0.00,19.00,1425.00,'2022-02-21 09:39:49','',''),(2643756,'1','186','940',419,'Retail Sale Id 1635714',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 09:49:54','',''),(2643757,'1','186','940',419,'Retail Sale Id 1635715',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 09:56:25','',''),(2643758,'1','186','940',419,'Retail Sale Id 1635716',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 10:25:24','',''),(2643759,'1','186','940',419,'Retail Sale Id 1635717',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 10:26:09','',''),(2643760,'1','186','940',419,'Retail Sale Id 1635718',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 10:26:42','',''),(2643761,'1','186','940',419,'Retail Sale Id 1635719',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 10:27:52','',''),(2643762,'1','186','940',419,'Retail Sale Id 1635720',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 10:28:39','',''),(2643763,'1','186','940',419,'Retail Sale Id 1635721',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 10:29:12','',''),(2643764,'1','186','940',419,'Retail Sale Id 1635722',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 10:29:47','',''),(2643765,'1','186','940',419,'Retail Sale Id 1635723',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 10:30:23','',''),(2643766,'1','186','940',419,'Retail Sale Id 1635724',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 12:15:03','',''),(2643767,'1','186','940',419,'Retail Sale Id 1635725',8400.00,0.00,0.00,15.00,1125.00,'2022-02-21 12:15:39','',''),(2643768,'1','186','940',419,'Retail Sale Id 1635726',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 12:16:10','',''),(2643769,'1','186','940',419,'Retail Sale Id 1635727',7000.00,0.00,0.00,12.50,937.50,'2022-02-21 12:16:41','',''),(2643770,'1','186','940',419,'Retail Sale Id 1635728',75880.00,0.00,0.00,135.50,10162.50,'2022-02-22 09:02:12','',''),(2643771,'1','186','940',419,'Retail Sale Id 1635729',376500.00,0.00,0.00,750.00,12750.00,'2022-02-22 09:13:36','',''),(2643772,'1','186','940',419,'Retail Sale Id 1635730',1000000.00,0.00,0.00,2000.00,30000.00,'2022-02-22 09:31:23','',''),(2643773,'1','186','940',419,'Retail Sale Id 1635731',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:32:06','',''),(2643774,'1','186','940',419,'Retail Sale Id 1635732',7000.00,0.00,0.00,12.50,937.50,'2022-02-22 09:33:35','',''),(2643775,'1','186','940',419,'Retail Sale Id 1635733',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:36:19','',''),(2643776,'1','186','940',419,'Retail Sale Id 1635734',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:42:03','',''),(2643777,'1','186','940',419,'Retail Sale Id 1635735',7000.00,0.00,0.00,12.50,937.50,'2022-02-22 09:42:39','',''),(2643778,'1','186','940',419,'Retail Sale Id 1635736',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:43:09','',''),(2643779,'1','186','940',419,'Retail Sale Id 1635737',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:43:38','',''),(2643780,'1','186','940',419,'Retail Sale Id 1635738',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:44:24','',''),(2643781,'1','186','940',419,'Retail Sale Id 1635739',8400.00,0.00,0.00,15.00,1125.00,'2022-02-22 09:44:57','',''),(2643782,'1','186','940',419,'Retail Sale Id 1635740',500000.00,0.00,0.00,1000.00,15000.00,'2022-02-22 09:45:57','',''),(2643783,'1','186','940',419,'Retail Sale Id 1635741',1380500.00,0.00,0.00,2750.00,46750.00,'2022-02-23 10:20:39','',''),(2643784,'1','186','940',419,'Retail Sale Id 1635742',3500000.00,0.00,0.00,7000.00,105000.00,'2022-02-23 10:25:24','',''),(2643785,'1','186','940',419,'Retail Sale Id 1635743',336728.00,0.00,0.00,601.30,45097.50,'2022-02-23 10:30:10','',''),(2643786,'1','186',NULL,419,'Reception corrector for bridging 132654',0.00,0.00,0.00,1900.00,0.00,'2022-02-23 10:34:46','',''),(2643787,'1','186','940',419,'Received from bridging 132654',0.00,0.00,1900.00,0.00,0.00,'2022-02-23 10:34:46','',''),(2643788,'1','186','940',419,'Retail Sale Id 1635744',1150000.00,0.00,0.00,2300.00,34500.00,'2022-02-23 10:37:36','',''),(2643789,'1','186','940',419,'Retail Sale Id 1635745',361440.00,0.00,0.00,720.00,12240.00,'2022-02-24 08:46:52','',''),(2643790,'1','186','940',419,'Retail Sale Id 1635746',128240.00,0.00,0.00,229.00,17175.00,'2022-02-24 08:47:41','',''),(2643791,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349403',177655.50,0.00,0.00,366.30,0.00,'2022-02-25 15:34:18','',''),(2643792,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12618720.00,24840.00,0.00,0.00,'2022-02-25 16:25:31','',''),(2643793,'1','186',NULL,419,'Reception corrector for bridging 132655',0.00,0.00,0.00,23000.00,0.00,'2022-02-25 16:27:37','',''),(2643794,'1','186','940',419,'Received from bridging 132655',0.00,0.00,23000.00,0.00,0.00,'2022-02-25 16:27:37','',''),(2643795,'1','186','940',419,'Retail Sale Id 1635747',8400.00,0.00,0.00,15.00,780.00,'2022-02-25 16:32:36','',''),(2643796,'1','186','940',419,'Retail Sale Id 1635748',7000.00,0.00,0.00,12.50,650.00,'2022-02-25 16:34:46','',''),(2643797,'1','186','940',419,'Retail Sale Id 1635749',7000.00,0.00,0.00,12.50,650.00,'2022-02-25 17:02:30','',''),(2643798,'1','186','940',419,'Retail Sale Id 1635750',261000.00,0.00,0.00,500.00,7000.00,'2022-02-25 17:03:51','',''),(2643799,'1','186','940',419,'Retail Sale Id 1635751',8400.00,0.00,0.00,15.00,780.00,'2022-02-25 17:04:32','',''),(2643800,'1','186','940',419,'Retail Sale Id 1635752',52400.00,0.00,0.00,100.00,1600.00,'2022-02-25 17:07:01','',''),(2643801,'1','186','940',419,'Retail Sale Id 1635753',8400.00,0.00,0.00,15.00,780.00,'2022-02-25 17:08:05','',''),(2643802,'1','186','940',419,'Retail Sale Id 1635754',7000.00,0.00,0.00,12.50,650.00,'2022-02-25 17:41:38','',''),(2643803,'1','186','940',419,'Retail Sale Id 1635755',261000.00,0.00,0.00,500.00,7000.00,'2022-02-26 07:58:13','',''),(2643804,'1','186','940',419,'Retail Sale Id 1635756',7000.00,0.00,0.00,12.50,650.00,'2022-02-26 08:15:00','',''),(2643805,'1','186','940',419,'Retail Sale Id 1635757',8400.00,0.00,0.00,15.00,780.00,'2022-02-26 08:15:51','',''),(2643806,'1','186','940',419,'Retail Sale Id 1635758',3360.00,0.00,0.00,6.00,312.00,'2022-02-26 08:17:01','',''),(2643807,'1','186','940',419,'Retail Sale Id 1635759',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:18:51','',''),(2643808,'1','186','940',419,'Retail Sale Id 1635760',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:19:33','',''),(2643809,'1','186','940',419,'Retail Sale Id 1635761',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:20:07','',''),(2643810,'1','186','940',419,'Retail Sale Id 1635762',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:20:39','',''),(2643811,'1','186','940',419,'Retail Sale Id 1635763',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:21:20','',''),(2643812,'1','186','940',419,'Retail Sale Id 1635764',78300.00,0.00,0.00,150.00,-6300.00,'2022-02-26 08:22:16','',''),(2643813,'1','186','940',419,'Retail Sale Id 1635765',104400.00,0.00,0.00,200.00,-8400.00,'2022-02-26 08:23:08','',''),(2643814,'1','186','940',419,'Retail Sale Id 1635766',156600.00,0.00,0.00,300.00,-12600.00,'2022-02-26 08:24:17','',''),(2643815,'1','186','940',419,'Retail Sale Id 1635767',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:24:53','',''),(2643816,'1','186','940',419,'Retail Sale Id 1635768',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:25:52','',''),(2643817,'1','186','940',419,'Retail Sale Id 1635769',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:26:27','',''),(2643818,'1','186','940',419,'Retail Sale Id 1635770',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:27:05','',''),(2643819,'1','186','940',419,'Retail Sale Id 1635771',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:38:59','',''),(2643820,'1','186','940',419,'Retail Sale Id 1635772',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:40:10','',''),(2643821,'1','186','940',419,'Retail Sale Id 1635773',26100.00,0.00,0.00,50.00,-2100.00,'2022-02-26 08:41:08','',''),(2643822,'1','186','940',419,'Retail Sale Id 1635774',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:42:34','',''),(2643823,'1','186','940',419,'Retail Sale Id 1635775',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:44:48','',''),(2643824,'1','186','940',419,'Retail Sale Id 1635776',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:45:43','',''),(2643825,'1','186','940',419,'Retail Sale Id 1635777',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:46:18','',''),(2643826,'1','186','940',419,'Retail Sale Id 1635778',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 08:46:58','',''),(2643827,'1','186','940',419,'Retail Sale Id 1635779',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 08:50:49','',''),(2643828,'1','186','940',419,'Retail Sale Id 1635781',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-26 08:52:42','',''),(2643829,'1','186','940',419,'Retail Sale Id 1635782',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 09:09:57','',''),(2643830,'1','186','940',419,'Retail Sale Id 1635783',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 09:10:26','',''),(2643831,'1','186','940',419,'Retail Sale Id 1635784',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 09:10:58','',''),(2643832,'1','186','940',419,'Retail Sale Id 1635785',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 09:11:49','',''),(2643833,'1','186','940',419,'Retail Sale Id 1635786',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-26 09:12:42','',''),(2643834,'1','186','940',419,'Retail Sale Id 1635787',287100.00,0.00,0.00,550.00,-23100.00,'2022-02-26 09:58:18','',''),(2643835,'1','186','940',419,'Retail Sale Id 1635788',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 09:59:26','',''),(2643836,'1','186','940',419,'Retail Sale Id 1635789',5640.00,0.00,0.00,10.00,0.00,'2022-02-26 10:00:43','',''),(2643837,'1','186','940',419,'Retail Sale Id 1635790',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 10:02:06','',''),(2643838,'1','186','940',419,'Retail Sale Id 1635791',5640.00,0.00,0.00,10.00,0.00,'2022-02-26 10:03:30','',''),(2643839,'1','186','940',419,'Retail Sale Id 1635792',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 10:04:18','',''),(2643840,'1','186','940',419,'Retail Sale Id 1635793',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 10:05:29','',''),(2643841,'1','186','940',419,'Retail Sale Id 1635794',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 10:06:48','',''),(2643842,'1','186','940',419,'Retail Sale Id 1635795',5640.00,0.00,0.00,10.00,0.00,'2022-02-26 10:07:42','',''),(2643843,'1','186','940',419,'Retail Sale Id 1635796',522000.00,0.00,0.00,1000.00,-42000.00,'2022-02-26 12:43:38','',''),(2643844,'1','186','940',419,'Retail Sale Id 1635797',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 12:44:44','',''),(2643845,'1','186','940',419,'Retail Sale Id 1635798',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 12:45:24','',''),(2643846,'1','186','940',419,'Retail Sale Id 1635799',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 12:46:10','',''),(2643847,'1','186','940',419,'Retail Sale Id 1635800',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-26 14:26:02','',''),(2643848,'1','186','940',419,'Retail Sale Id 1635801',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 14:27:45','',''),(2643849,'1','186','940',419,'Retail Sale Id 1635802',5640.00,0.00,0.00,10.00,0.00,'2022-02-26 14:28:41','',''),(2643850,'1','186','940',419,'Retail Sale Id 1635803',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 14:29:41','',''),(2643851,'1','186','940',419,'Retail Sale Id 1635805',156600.00,0.00,0.00,300.00,-12600.00,'2022-02-26 16:21:37','',''),(2643852,'1','186','940',419,'Retail Sale Id 1635806',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 16:22:37','',''),(2643853,'1','186','940',419,'Retail Sale Id 1635807',8460.00,0.00,0.00,15.00,0.00,'2022-02-26 18:20:39','',''),(2643854,'1','186','940',419,'Retail Sale Id 1635808',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 18:21:20','',''),(2643855,'1','186','940',419,'Retail Sale Id 1635809',5640.00,0.00,0.00,10.00,0.00,'2022-02-26 18:22:19','',''),(2643856,'1','186','940',419,'Retail Sale Id 1635810',5640.00,0.00,0.00,10.00,0.00,'2022-02-26 18:23:04','',''),(2643857,'1','186','940',419,'Retail Sale Id 1635811',7050.00,0.00,0.00,12.50,0.00,'2022-02-26 18:23:46','',''),(2643858,'1','186','940',419,'Retail Sale Id 1635812',783000.00,0.00,0.00,1500.00,-63000.00,'2022-02-26 21:16:58','',''),(2643859,'1','186','940',419,'Retail Sale Id 1635813',428.64,0.00,0.00,0.76,0.00,'2022-02-27 07:31:22','',''),(2643860,'1','186','940',419,'Retail Sale Id 1635814',1980982.00,0.00,0.00,3780.50,-151220.00,'2022-02-27 07:34:50','',''),(2643861,'1','186','940',419,'Retail Sale Id 1635815',27405225.00,0.00,0.00,5235.00,24452685.00,'2022-02-27 07:36:48','',''),(2643862,'1','186','940',419,'Return of Retail Sale Id 1635815',0.00,27405225.00,5235.00,0.00,-24452685.00,'2022-02-27 07:41:54','',''),(2643863,'1','186','940',419,'Retail Sale Id 1635816',2732670.00,0.00,0.00,5235.00,-219870.00,'2022-02-27 07:43:37','',''),(2643864,'1','186','940',419,'Return of Retail Sale Id 1635773',0.00,26100.00,50.00,0.00,2100.00,'2022-02-27 07:49:22','',''),(2643865,'1','186','940',419,'Retail Sale Id 1635817',265932.90,0.00,0.00,509.45,-21396.90,'2022-02-27 07:59:30','',''),(2643866,'1','186','940',419,'Retail Sale Id 1635818',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 08:06:27','',''),(2643867,'1','186','940',419,'Retail Sale Id 1635819',5640.00,0.00,0.00,10.00,0.00,'2022-02-27 08:07:24','',''),(2643868,'1','186','940',419,'Retail Sale Id 1635820',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 08:39:40','',''),(2643869,'1','186','940',419,'Retail Sale Id 1635821',52200.00,0.00,0.00,100.00,-4200.00,'2022-02-27 08:40:45','',''),(2643870,'1','186','940',419,'Retail Sale Id 1635822',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 10:01:24','',''),(2643871,'1','186','940',419,'Retail Sale Id 1635823',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 10:11:41','',''),(2643872,'1','186','940',419,'Retail Sale Id 1635824',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 10:14:58','',''),(2643873,'1','186','940',419,'Retail Sale Id 1635825',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-27 10:28:39','',''),(2643874,'1','186',NULL,419,'Reception corrector for bridging 132656',0.00,0.00,0.00,1840.00,0.00,'2022-02-27 11:28:27','',''),(2643875,'1','186','940',419,'Received from bridging 132656',0.00,0.00,1840.00,0.00,0.00,'2022-02-27 11:28:27','',''),(2643876,'1','186','940',419,'Retail Sale Id 1635826',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 11:31:01','',''),(2643877,'1','186','940',419,'Retail Sale Id 1635827',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:10:58','',''),(2643878,'1','186','940',419,'Retail Sale Id 1635828',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 12:12:18','',''),(2643879,'1','186','940',419,'Retail Sale Id 1635829',10716.00,0.00,0.00,19.00,0.00,'2022-02-27 12:13:12','',''),(2643880,'1','186','940',419,'Retail Sale Id 1635830',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 12:13:58','',''),(2643881,'1','186','940',419,'Retail Sale Id 1635831',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 12:14:49','',''),(2643882,'1','186','940',419,'Retail Sale Id 1635832',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 12:15:28','',''),(2643883,'1','186','940',419,'Retail Sale Id 1635833',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:16:18','',''),(2643884,'1','186','940',419,'Retail Sale Id 1635834',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:17:01','',''),(2643885,'1','186','940',419,'Retail Sale Id 1635835',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:18:03','',''),(2643886,'1','186','940',419,'Retail Sale Id 1635836',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:19:07','',''),(2643887,'1','186','940',419,'Retail Sale Id 1635837',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:19:53','',''),(2643888,'1','186','940',419,'Retail Sale Id 1635838',26100.00,0.00,0.00,50.00,-2100.00,'2022-02-27 12:20:50','',''),(2643889,'1','186','940',419,'Retail Sale Id 1635839',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 12:21:35','',''),(2643890,'1','186','940',419,'Retail Sale Id 1635840',52200.00,0.00,0.00,100.00,-4200.00,'2022-02-27 12:22:23','',''),(2643891,'1','186','940',419,'Retail Sale Id 1635841',104400.00,0.00,0.00,200.00,-8400.00,'2022-02-27 12:23:34','',''),(2643892,'1','186','940',419,'Retail Sale Id 1635842',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-27 12:24:35','',''),(2643893,'1','186','940',419,'Retail Sale Id 1635843',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 17:51:11','',''),(2643894,'1','186','940',419,'Retail Sale Id 1635844',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-27 17:53:29','',''),(2643895,'1','186','940',419,'Retail Sale Id 1635845',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 17:54:06','',''),(2643896,'1','186','940',419,'Retail Sale Id 1635847',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 17:56:30','',''),(2643897,'1','186','940',419,'Retail Sale Id 1635848',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 17:57:13','',''),(2643898,'1','186','940',419,'Retail Sale Id 1635850',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 17:57:55','',''),(2643899,'1','186','940',419,'Retail Sale Id 1635851',522000.00,0.00,0.00,1000.00,-42000.00,'2022-02-27 18:00:16','',''),(2643900,'1','186','940',419,'Retail Sale Id 1635852',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 18:01:07','',''),(2643901,'1','186','940',419,'Retail Sale Id 1635853',8460.00,0.00,0.00,15.00,0.00,'2022-02-27 18:01:41','',''),(2643902,'1','186','940',419,'Retail Sale Id 1635854',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 18:02:18','',''),(2643903,'1','186','940',419,'Retail Sale Id 1635855',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 18:02:49','',''),(2643904,'1','186','940',419,'Retail Sale Id 1635856',78300.00,0.00,0.00,150.00,-6300.00,'2022-02-27 18:03:59','',''),(2643905,'1','186','940',419,'Retail Sale Id 1635857',26100.00,0.00,0.00,50.00,-2100.00,'2022-02-27 18:05:27','',''),(2643906,'1','186','940',419,'Retail Sale Id 1635858',7050.00,0.00,0.00,12.50,0.00,'2022-02-27 18:06:24','',''),(2643907,'1','186','940',419,'Retail Sale Id 1635859',261000.00,0.00,0.00,500.00,-21000.00,'2022-02-27 18:07:28','',''),(2643908,'1','186','940',419,'Retail Sale Id 1635860',864600.00,0.00,0.00,1650.00,-66000.00,'2022-02-28 10:31:21','',''),(2643909,'1','186','940',419,'Retail Sale Id 1635861',1044000.00,0.00,0.00,2000.00,-84000.00,'2022-02-28 10:33:06','',''),(2643910,'1','186','940',419,'Retail Sale Id 1635862',3319.92,0.00,0.00,6.36,-267.12,'2022-02-28 10:39:47','',''),(2643911,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349404',198697.20,0.00,0.00,352.30,0.00,'2022-02-28 16:53:58','',''),(2643912,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12537440.00,24680.00,0.00,0.00,'2022-02-28 17:14:13','',''),(2643913,'1','186',NULL,419,'Reception corrector for bridging 132657',0.00,0.00,0.00,22999.37,0.00,'2022-02-28 17:17:12','',''),(2643914,'1','186','940',419,'Received from bridging 132657',0.00,0.00,22999.37,0.00,0.00,'2022-02-28 17:17:12','',''),(2643915,'1','186','940',419,'Retail Sale Id 1635863',26100.00,0.00,0.00,50.00,700.00,'2022-02-28 17:57:18','',''),(2643916,'1','186','940',419,'Retail Sale Id 1635864',130500.00,0.00,0.00,250.00,3500.00,'2022-02-28 17:58:41','',''),(2643917,'1','186','940',419,'Retail Sale Id 1635865',156600.00,0.00,0.00,300.00,4200.00,'2022-02-28 18:00:11','',''),(2643918,'1','186','940',419,'Retail Sale Id 1635866',8460.00,0.00,0.00,15.00,840.00,'2022-02-28 18:01:03','',''),(2643919,'1','186','940',419,'Retail Sale Id 1635867',8460.00,0.00,0.00,15.00,840.00,'2022-02-28 18:03:25','',''),(2643920,'1','186','940',419,'Retail Sale Id 1635868',8460.00,0.00,0.00,15.00,840.00,'2022-02-28 18:27:05','',''),(2643921,'1','186','940',419,'Retail Sale Id 1635869',7050.00,0.00,0.00,12.50,700.00,'2022-02-28 18:48:22','',''),(2643922,'1','186','940',419,'Retail Sale Id 1635870',8460.00,0.00,0.00,15.00,840.00,'2022-02-28 18:50:04','',''),(2643923,'1','186','940',419,'Retail Sale Id 1635871',7050.00,0.00,0.00,12.50,700.00,'2022-02-28 18:57:34','',''),(2643924,'1','186','940',419,'Retail Sale Id 1635872',8460.00,0.00,0.00,15.00,840.00,'2022-02-28 18:58:10','',''),(2643925,'1','186','940',419,'Retail Sale Id 1635873',261000.00,0.00,0.00,500.00,7000.00,'2022-02-28 18:59:33','',''),(2643926,'1','186','940',419,'Retail Sale Id 1635874',1696500.00,0.00,0.00,3250.00,45500.00,'2022-02-28 23:06:01','',''),(2643927,'1','186','940',419,'Retail Sale Id 1635875',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 07:51:40','',''),(2643928,'1','186','940',419,'Retail Sale Id 1635876',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 07:52:43','',''),(2643929,'1','186','940',419,'Retail Sale Id 1635877',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 07:53:18','',''),(2643930,'1','186','940',419,'Retail Sale Id 1635878',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 07:54:35','',''),(2643931,'1','186','940',419,'Retail Sale Id 1635879',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 07:55:23','',''),(2643932,'1','186','940',419,'Retail Sale Id 1635881',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 07:56:04','',''),(2643933,'1','186','940',419,'Retail Sale Id 1635882',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 07:56:48','',''),(2643934,'1','186','940',419,'Retail Sale Id 1635883',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 07:57:30','',''),(2643935,'1','186','940',419,'Retail Sale Id 1635884',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 07:58:15','',''),(2643936,'1','186','940',419,'Retail Sale Id 1635885',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 07:59:01','',''),(2643937,'1','186','940',419,'Retail Sale Id 1635886',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 07:59:35','',''),(2643938,'1','186','940',419,'Retail Sale Id 1635887',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 08:19:46','',''),(2643939,'1','186','940',419,'Retail Sale Id 1635888',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 08:22:37','',''),(2643940,'1','186','940',419,'Retail Sale Id 1635889',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 08:27:41','',''),(2643941,'1','186','940',419,'Retail Sale Id 1635890',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 08:28:31','',''),(2643942,'1','186','940',419,'Retail Sale Id 1635891',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 08:29:30','',''),(2643943,'1','186','940',419,'Retail Sale Id 1635892',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 08:30:03','',''),(2643944,'1','186','940',419,'Retail Sale Id 1635893',1044000.00,0.00,0.00,2000.00,28000.00,'2022-03-01 08:37:39','',''),(2643945,'1','186','940',419,'Retail Sale Id 1635894',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 08:40:53','',''),(2643946,'1','186','940',419,'Retail Sale Id 1635895',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 08:42:11','',''),(2643947,'1','186','940',419,'Retail Sale Id 1635896',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 08:42:43','',''),(2643948,'1','186','940',419,'Retail Sale Id 1635897',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 08:43:36','',''),(2643949,'1','186','940',419,'Retail Sale Id 1635898',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 14:41:00','',''),(2643950,'1','186','940',419,'Retail Sale Id 1635899',104400.00,0.00,0.00,200.00,2800.00,'2022-03-01 14:50:55','',''),(2643951,'1','186','940',419,'Retail Sale Id 1635900',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 14:55:36','',''),(2643952,'1','186','940',419,'Retail Sale Id 1635901',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 14:56:54','',''),(2643953,'1','186','940',419,'Retail Sale Id 1635902',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 14:57:39','',''),(2643954,'1','186','940',419,'Retail Sale Id 1635903',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 14:59:12','',''),(2643955,'1','186','940',419,'Retail Sale Id 1635904',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 15:00:13','',''),(2643956,'1','186','940',419,'Retail Sale Id 1635905',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 15:01:00','',''),(2643957,'1','186','940',419,'Retail Sale Id 1635906',261000.00,0.00,0.00,500.00,7000.00,'2022-03-01 15:01:53','',''),(2643958,'1','186','940',419,'Retail Sale Id 1635907',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 15:03:00','',''),(2643959,'1','186','940',419,'Retail Sale Id 1635908',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 15:05:46','',''),(2643960,'1','186','940',419,'Retail Sale Id 1635909',78300.00,0.00,0.00,150.00,2100.00,'2022-03-01 15:06:49','',''),(2643961,'1','186','940',419,'Retail Sale Id 1635910',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 15:09:13','',''),(2643962,'1','186','940',419,'Retail Sale Id 1635911',7050.00,0.00,0.00,12.50,700.00,'2022-03-01 15:10:27','',''),(2643963,'1','186','940',419,'Retail Sale Id 1635912',783000.00,0.00,0.00,1500.00,21000.00,'2022-03-01 15:48:31','',''),(2643964,'1','186','940',419,'Retail Sale Id 1635913',8460.00,0.00,0.00,15.00,840.00,'2022-03-01 15:51:17','',''),(2643965,'1','186','940',419,'Retail Sale Id 1635915',87420.00,0.00,0.00,155.00,8680.00,'2022-03-01 20:45:18','',''),(2643966,'1','186','940',419,'Retail Sale Id 1635914',26100.00,0.00,0.00,50.00,700.00,'2022-03-01 20:57:12','',''),(2643967,'1','186','940',419,'Retail Sale Id 1635916',812200.00,0.00,0.00,1550.00,24800.00,'2022-03-01 21:03:37','',''),(2643968,'1','186','940',419,'Retail Sale Id 1635917',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 07:27:01','',''),(2643969,'1','186','940',419,'Retail Sale Id 1635918',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 07:33:09','',''),(2643970,'1','186','940',419,'Retail Sale Id 1635919',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 07:35:12','',''),(2643971,'1','186','940',419,'Retail Sale Id 1635920',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 07:37:27','',''),(2643972,'1','186','940',419,'Retail Sale Id 1635921',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 07:39:46','',''),(2643973,'1','186','940',419,'Retail Sale Id 1635922',26200.00,0.00,0.00,50.00,800.00,'2022-03-02 07:43:22','',''),(2643974,'1','186','940',419,'Retail Sale Id 1635923',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 07:48:58','',''),(2643975,'1','186','940',419,'Retail Sale Id 1635924',78300.00,0.00,0.00,150.00,2100.00,'2022-03-02 07:52:48','',''),(2643976,'1','186','940',419,'Retail Sale Id 1635925',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 10:02:58','',''),(2643977,'1','186','940',419,'Retail Sale Id 1635926',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 10:03:33','',''),(2643978,'1','186','940',419,'Retail Sale Id 1635927',3384.00,0.00,0.00,6.00,336.00,'2022-03-02 10:04:22','',''),(2643979,'1','186','940',419,'Retail Sale Id 1635928',2820.00,0.00,0.00,5.00,280.00,'2022-03-02 10:05:33','',''),(2643980,'1','186','940',419,'Retail Sale Id 1635929',1692.00,0.00,0.00,3.00,168.00,'2022-03-02 10:06:18','',''),(2643981,'1','186','940',419,'Retail Sale Id 1635930',5640.00,0.00,0.00,10.00,560.00,'2022-03-02 10:07:00','',''),(2643982,'1','186','940',419,'Retail Sale Id 1635931',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 10:07:47','',''),(2643983,'1','186','940',419,'Retail Sale Id 1635932',3384.00,0.00,0.00,6.00,336.00,'2022-03-02 10:08:56','',''),(2643984,'1','186','940',419,'Retail Sale Id 1635933',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 10:09:37','',''),(2643985,'1','186','940',419,'Retail Sale Id 1635934',261000.00,0.00,0.00,500.00,7000.00,'2022-03-02 10:10:23','',''),(2643986,'1','186','940',419,'Retail Sale Id 1635935',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 10:10:58','',''),(2643987,'1','186','940',419,'Retail Sale Id 1635936',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 10:11:46','',''),(2643988,'1','186','940',419,'Retail Sale Id 1635937',261000.00,0.00,0.00,500.00,7000.00,'2022-03-02 14:23:10','',''),(2643989,'1','186','940',419,'Retail Sale Id 1635938',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 14:26:05','',''),(2643990,'1','186','940',419,'Retail Sale Id 1635939',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:32:44','',''),(2643991,'1','186','940',419,'Retail Sale Id 1635940',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 14:34:25','',''),(2643992,'1','186','940',419,'Retail Sale Id 1635941',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 14:36:19','',''),(2643993,'1','186','940',419,'Retail Sale Id 1635942',574200.00,0.00,0.00,1100.00,15400.00,'2022-03-02 14:37:28','',''),(2643994,'1','186','940',419,'Retail Sale Id 1635943',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:38:57','',''),(2643995,'1','186','940',419,'Retail Sale Id 1635944',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:40:30','',''),(2643996,'1','186','940',419,'Retail Sale Id 1635945',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:42:57','',''),(2643997,'1','186','940',419,'Retail Sale Id 1635946',8460.00,0.00,0.00,15.00,840.00,'2022-03-02 14:43:38','',''),(2643998,'1','186','940',419,'Retail Sale Id 1635947',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:50:50','',''),(2643999,'1','186','940',419,'Retail Sale Id 1635948',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:51:22','',''),(2644000,'1','186','940',419,'Retail Sale Id 1635949',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 14:51:59','',''),(2644001,'1','186','940',419,'Retail Sale Id 1635950',261000.00,0.00,0.00,500.00,7000.00,'2022-03-02 14:52:47','',''),(2644002,'1','186','940',419,'Retail Sale Id 1635951',261000.00,0.00,0.00,500.00,7000.00,'2022-03-02 17:54:52','',''),(2644003,'1','186','940',419,'Retail Sale Id 1635952',7050.00,0.00,0.00,12.50,700.00,'2022-03-02 17:59:51','',''),(2644004,'1','186','940',419,'Retail Sale Id 1635953',890800.00,0.00,0.00,1700.00,27200.00,'2022-03-02 20:49:08','',''),(2644005,'1','186','940',419,'Retail Sale Id 1635954',522000.00,0.00,0.00,1000.00,14000.00,'2022-03-02 20:59:50','',''),(2644006,'1','186','940',419,'Retail Sale Id 1635955',1566000.00,0.00,0.00,3000.00,42000.00,'2022-03-02 21:01:14','',''),(2644007,'1','186',NULL,419,'Reception corrector for bridging 132658',0.00,0.00,0.00,1680.63,0.00,'2022-03-02 21:14:00','',''),(2644008,'1','186','940',419,'Received from bridging 132658',0.00,0.00,1680.63,0.00,0.00,'2022-03-02 21:14:00','',''),(2644009,'1','186','940',419,'Retail Sale Id 1635956',1048000.00,0.00,0.00,2000.00,32000.00,'2022-03-02 21:17:35','',''),(2644010,'1','186','940',419,'Retail Sale Id 1635957',112800.00,0.00,0.00,200.00,11200.00,'2022-03-02 21:20:17','',''),(2644011,'1','186','940',419,'Retail Sale Id 1635958',922337.46,0.00,0.00,1766.93,24737.02,'2022-03-02 21:22:47','',''),(2644012,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349405',182219.60,0.00,0.00,358.70,0.00,'2022-03-03 20:43:56','',''),(2644013,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12633960.00,24870.00,0.00,0.00,'2022-03-03 20:47:17','',''),(2644014,'1','186',NULL,419,'Reception corrector for bridging 132659',0.00,0.00,0.00,23000.00,0.00,'2022-03-03 20:50:01','',''),(2644015,'1','186','940',419,'Received from bridging 132659',0.00,0.00,23000.00,0.00,0.00,'2022-03-03 20:50:01','',''),(2644016,'1','186','940',419,'Retail Sale Id 1635959',1696500.00,0.00,0.00,3250.00,45500.00,'2022-03-03 20:53:23','',''),(2644017,'1','186','940',419,'Retail Sale Id 1635960',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 07:52:48','',''),(2644018,'1','186','940',419,'Retail Sale Id 1635961',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 08:14:00','',''),(2644019,'1','186','940',419,'Retail Sale Id 1635962',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 08:28:30','',''),(2644020,'1','186','940',419,'Retail Sale Id 1635963',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 08:29:06','',''),(2644021,'1','186','940',419,'Retail Sale Id 1635964',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 08:30:21','',''),(2644022,'1','186','940',419,'Retail Sale Id 1635965',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 08:35:43','',''),(2644023,'1','186','940',419,'Retail Sale Id 1635966',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 08:38:30','',''),(2644024,'1','186','940',419,'Retail Sale Id 1635967',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 08:41:48','',''),(2644025,'1','186','940',419,'Retail Sale Id 1635968',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 08:42:28','',''),(2644026,'1','186','940',419,'Retail Sale Id 1635969',261000.00,0.00,0.00,500.00,7000.00,'2022-03-04 08:48:47','',''),(2644027,'1','186','940',419,'Retail Sale Id 1635970',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 08:49:53','',''),(2644028,'1','186','940',419,'Retail Sale Id 1635971',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 08:50:46','',''),(2644029,'1','186','940',419,'Retail Sale Id 1635972',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 15:17:01','',''),(2644030,'1','186','940',419,'Retail Sale Id 1635973',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 15:46:26','',''),(2644031,'1','186','940',419,'Retail Sale Id 1635974',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 15:49:45','',''),(2644032,'1','186','940',419,'Retail Sale Id 1635975',1044000.00,0.00,0.00,2000.00,28000.00,'2022-03-04 15:52:40','',''),(2644033,'1','186','940',419,'Retail Sale Id 1635976',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 15:55:34','',''),(2644034,'1','186','940',419,'Retail Sale Id 1635977',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 15:56:49','',''),(2644035,'1','186','940',419,'Retail Sale Id 1635978',7050.00,0.00,0.00,12.50,700.00,'2022-03-04 15:57:52','',''),(2644036,'1','186','940',419,'Retail Sale Id 1635979',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 15:58:27','',''),(2644037,'1','186','940',419,'Retail Sale Id 1635980',8460.00,0.00,0.00,15.00,840.00,'2022-03-04 16:00:23','',''),(2644038,'1','186','940',419,'Retail Sale Id 1635981',4880700.00,0.00,0.00,9350.00,130900.00,'2022-03-04 22:59:07','',''),(2644039,'1','186','940',419,'Retail Sale Id 1635982',1705620.00,0.00,0.00,3255.00,52080.00,'2022-03-04 23:01:45','',''),(2644040,'1','186','940',419,'Retail Sale Id 1635983',825007.92,0.00,0.00,1462.78,81915.68,'2022-03-04 23:04:16','',''),(2644041,'1','186','940',419,'Return of Retail Sale Id 1635983',0.00,825007.92,1462.78,0.00,-81915.68,'2022-03-04 23:05:14','',''),(2644042,'1','186','940',419,'Retail Sale Id 1635984',261007.92,0.00,0.00,462.78,25915.68,'2022-03-04 23:07:26','',''),(2644043,'1','186','940',419,'Retail Sale Id 1635985',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 08:05:25','',''),(2644044,'1','186','940',419,'Retail Sale Id 1635986',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 09:02:02','',''),(2644045,'1','186','940',419,'Retail Sale Id 1635987',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 09:03:04','',''),(2644046,'1','186','940',419,'Retail Sale Id 1635988',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 09:03:50','',''),(2644047,'1','186','940',419,'Retail Sale Id 1635989',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 09:05:55','',''),(2644048,'1','186','940',419,'Retail Sale Id 1635990',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 09:06:34','',''),(2644049,'1','186','940',419,'Retail Sale Id 1635991',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 09:07:14','',''),(2644050,'1','186','940',419,'Retail Sale Id 1635992',261000.00,0.00,0.00,500.00,7000.00,'2022-03-05 09:15:08','',''),(2644051,'1','186',NULL,419,'Reception corrector for bridging 132660',0.00,0.00,0.00,1870.00,0.00,'2022-03-05 09:22:23','',''),(2644052,'1','186','940',419,'Received from bridging 132660',0.00,0.00,1870.00,0.00,0.00,'2022-03-05 09:22:23','',''),(2644053,'1','186','940',419,'Retail Sale Id 1635993',26100.00,0.00,0.00,50.00,700.00,'2022-03-05 09:23:35','',''),(2644054,'1','186','940',419,'Retail Sale Id 1635994',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 09:25:09','',''),(2644055,'1','186','940',419,'Retail Sale Id 1635995',261000.00,0.00,0.00,500.00,7000.00,'2022-03-05 09:26:55','',''),(2644056,'1','186','940',419,'Retail Sale Id 1635996',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 09:27:52','',''),(2644057,'1','186','940',419,'Retail Sale Id 1635997',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 09:28:34','',''),(2644058,'1','186','940',419,'Retail Sale Id 1635999',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 09:31:42','',''),(2644059,'1','186','940',419,'Retail Sale Id 1636000',261000.00,0.00,0.00,500.00,7000.00,'2022-03-05 10:15:40','',''),(2644060,'1','186','940',419,'Retail Sale Id 1636001',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 10:17:07','',''),(2644061,'1','186','940',419,'Retail Sale Id 1636002',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 10:18:01','',''),(2644062,'1','186','940',419,'Retail Sale Id 1636003',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 10:27:42','',''),(2644063,'1','186','940',419,'Retail Sale Id 1636004',1692.00,0.00,0.00,3.00,168.00,'2022-03-05 10:28:47','',''),(2644064,'1','186','940',419,'Retail Sale Id 1636005',2820.00,0.00,0.00,5.00,280.00,'2022-03-05 10:29:46','',''),(2644065,'1','186','940',419,'Retail Sale Id 1636006',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 10:32:08','',''),(2644066,'1','186','940',419,'Retail Sale Id 1636007',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 10:33:41','',''),(2644067,'1','186','940',419,'Retail Sale Id 1636008',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 10:40:55','',''),(2644068,'1','186','940',419,'Retail Sale Id 1636009',26100.00,0.00,0.00,50.00,700.00,'2022-03-05 10:43:11','',''),(2644069,'1','186','940',419,'Retail Sale Id 1636010',4176.00,0.00,0.00,8.00,112.00,'2022-03-05 10:45:22','',''),(2644070,'1','186','940',419,'Retail Sale Id 1636011',261000.00,0.00,0.00,500.00,7000.00,'2022-03-05 15:26:22','',''),(2644071,'1','186','940',419,'Retail Sale Id 1636012',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 15:30:55','',''),(2644072,'1','186','940',419,'Retail Sale Id 1636013',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 15:31:37','',''),(2644073,'1','186','940',419,'Retail Sale Id 1636014',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 15:32:11','',''),(2644074,'1','186','940',419,'Retail Sale Id 1636015',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 15:32:53','',''),(2644075,'1','186','940',419,'Retail Sale Id 1636016',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 15:33:57','',''),(2644076,'1','186','940',419,'Retail Sale Id 1636017',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 15:37:46','',''),(2644077,'1','186','940',419,'Retail Sale Id 1636018',261000.00,0.00,0.00,500.00,7000.00,'2022-03-05 15:38:39','',''),(2644078,'1','186','940',419,'Retail Sale Id 1636019',78300.00,0.00,0.00,150.00,2100.00,'2022-03-05 16:24:52','',''),(2644079,'1','186','940',419,'Retail Sale Id 1636020',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 16:36:07','',''),(2644080,'1','186','940',419,'Retail Sale Id 1636021',7050.00,0.00,0.00,12.50,700.00,'2022-03-05 16:45:13','',''),(2644081,'1','186','940',419,'Retail Sale Id 1636022',8460.00,0.00,0.00,15.00,840.00,'2022-03-05 16:46:46','',''),(2644082,'1','186','940',419,'Retail Sale Id 1636023',352914.00,0.00,0.00,673.50,10776.00,'2022-03-05 22:33:31','',''),(2644083,'1','186','940',419,'Retail Sale Id 1636024',522000.00,0.00,0.00,1000.00,14000.00,'2022-03-05 22:36:10','',''),(2644084,'1','186','940',419,'Retail Sale Id 1636025',28200.00,0.00,0.00,50.00,2800.00,'2022-03-05 22:38:14','',''),(2644085,'1','186','940',419,'Retail Sale Id 1636026',312199.20,0.00,0.00,595.80,9532.80,'2022-03-05 22:41:35','',''),(2644086,'1','186','940',419,'Distributed to AARANO for sales id:349406',181315.36,0.00,0.00,356.92,0.00,'2022-03-06 20:16:00','',''),(2644087,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,12684760.00,24970.00,0.00,0.00,'2022-03-06 21:28:39','',''),(2644088,'1','186',NULL,419,'Reception corrector for bridging 132661',0.00,0.00,0.00,23000.00,0.00,'2022-03-06 22:01:50','',''),(2644089,'1','186','940',419,'Received from bridging 132661',0.00,0.00,23000.00,0.00,0.00,'2022-03-06 22:01:50','',''),(2644090,'1','186','940',419,'Retail Sale Id 1636027',1566000.00,0.00,0.00,3000.00,42000.00,'2022-03-06 22:02:55','',''),(2644091,'1','186','940',419,'Retail Sale Id 1636028',52818.60,0.00,0.00,93.65,5244.40,'2022-03-06 22:04:05','',''),(2644092,'1','186','940',419,'Retail Sale Id 1636029',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 08:00:55','',''),(2644093,'1','186','940',419,'Retail Sale Id 1636030',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 08:03:05','',''),(2644094,'1','186','940',419,'Retail Sale Id 1636031',8460.00,0.00,0.00,15.00,840.00,'2022-03-07 08:04:04','',''),(2644095,'1','186','940',419,'Retail Sale Id 1636032',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 08:04:58','',''),(2644096,'1','186','940',419,'Retail Sale Id 1636033',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 08:05:34','',''),(2644097,'1','186','940',419,'Retail Sale Id 1636034',8460.00,0.00,0.00,15.00,840.00,'2022-03-07 09:49:13','',''),(2644098,'1','186','940',419,'Retail Sale Id 1636035',8460.00,0.00,0.00,15.00,840.00,'2022-03-07 09:50:00','',''),(2644099,'1','186','940',419,'Retail Sale Id 1636036',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 09:50:33','',''),(2644100,'1','186','940',419,'Retail Sale Id 1636037',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 09:51:01','',''),(2644101,'1','186','940',419,'Retail Sale Id 1636038',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 09:55:54','',''),(2644102,'1','186','940',419,'Retail Sale Id 1636039',8460.00,0.00,0.00,15.00,840.00,'2022-03-07 09:56:59','',''),(2644103,'1','186','940',419,'Retail Sale Id 1636040',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 09:57:39','',''),(2644104,'1','186','940',419,'Retail Sale Id 1636041',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 09:58:27','',''),(2644105,'1','186','940',419,'Retail Sale Id 1636042',261000.00,0.00,0.00,500.00,7000.00,'2022-03-07 09:59:11','',''),(2644106,'1','186','940',419,'Retail Sale Id 1636043',26100.00,0.00,0.00,50.00,700.00,'2022-03-07 10:01:00','',''),(2644107,'1','186','940',419,'Retail Sale Id 1636044',26100.00,0.00,0.00,50.00,700.00,'2022-03-07 10:01:54','',''),(2644108,'1','186','940',419,'Retail Sale Id 1636045',8460.00,0.00,0.00,15.00,840.00,'2022-03-07 17:31:54','',''),(2644109,'1','186','940',419,'Retail Sale Id 1636046',261000.00,0.00,0.00,500.00,7000.00,'2022-03-07 17:32:52','',''),(2644110,'1','186','940',419,'Retail Sale Id 1636047',1044000.00,0.00,0.00,2000.00,28000.00,'2022-03-07 18:30:29','',''),(2644111,'1','186','940',419,'Retail Sale Id 1636048',261000.00,0.00,0.00,500.00,7000.00,'2022-03-07 18:32:17','',''),(2644112,'1','186','940',419,'Retail Sale Id 1636049',261000.00,0.00,0.00,500.00,7000.00,'2022-03-07 18:33:03','',''),(2644113,'1','186','940',419,'Retail Sale Id 1636050',78300.00,0.00,0.00,150.00,2100.00,'2022-03-07 18:34:08','',''),(2644114,'1','186','940',419,'Retail Sale Id 1636051',7050.00,0.00,0.00,12.50,700.00,'2022-03-07 18:37:44','',''),(2644115,'1','186','940',419,'Retail Sale Id 1636052',282000.00,0.00,0.00,500.00,28000.00,'2022-03-07 21:19:12','',''),(2644116,'1','186','940',419,'Retail Sale Id 1636053',112800.00,0.00,0.00,200.00,11200.00,'2022-03-07 21:20:08','',''),(2644117,'1','186','940',419,'Retail Sale Id 1636054',1900680.00,0.00,0.00,3370.00,188720.00,'2022-03-07 21:21:34','',''),(2644118,'1','186','940',419,'Retail Sale Id 1636055',2610000.00,0.00,0.00,5000.00,70000.00,'2022-03-07 21:22:47','',''),(2644119,'1','186','940',419,'Retail Sale Id 1636056',8460.00,0.00,0.00,15.00,840.00,'2022-03-07 21:24:36','',''),(2644120,'1','186','940',419,'Return of Retail Sale Id 1636054',0.00,1900680.00,3370.00,0.00,-188720.00,'2022-03-07 21:29:02','',''),(2644121,'1','186','940',419,'Retail Sale Id 1636057',1765880.00,0.00,0.00,3370.00,53920.00,'2022-03-07 21:29:46','',''),(2644122,'1','186','940',419,'Retail Sale Id 1636058',7050.00,0.00,0.00,12.50,700.00,'2022-03-08 07:46:50','',''),(2644123,'1','186','940',419,'Retail Sale Id 1636059',8460.00,0.00,0.00,15.00,840.00,'2022-03-08 07:48:26','',''),(2644124,'1','186','940',419,'Retail Sale Id 1636060',8460.00,0.00,0.00,15.00,840.00,'2022-03-08 07:49:36','',''),(2644125,'1','186','940',419,'Retail Sale Id 1636061',130500.00,0.00,0.00,250.00,3500.00,'2022-03-08 07:52:40','',''),(2644126,'1','186','940',419,'Retail Sale Id 1636062',7050.00,0.00,0.00,12.50,700.00,'2022-03-08 07:54:55','',''),(2644127,'1','186','940',419,'Retail Sale Id 1636063',26100.00,0.00,0.00,50.00,700.00,'2022-03-08 13:52:23','',''),(2644128,'1','186','940',419,'Retail Sale Id 1636064',7050.00,0.00,0.00,12.50,700.00,'2022-03-08 14:34:57','',''),(2644129,'1','186','940',419,'Retail Sale Id 1636065',261000.00,0.00,0.00,500.00,7000.00,'2022-03-08 15:08:41','',''),(2644130,'1','186','940',419,'Return of Retail Sale Id 1636061',0.00,130500.00,250.00,0.00,-3500.00,'2022-03-08 18:27:33','',''),(2644131,'1','186','940',419,'Return of Retail Sale Id 1636065',0.00,261000.00,500.00,0.00,-7000.00,'2022-03-08 18:28:23','',''),(2644132,'1','186','940',419,'Return of Retail Sale Id 1636063',0.00,26100.00,50.00,0.00,-700.00,'2022-03-08 18:29:05','',''),(2644133,'1','186',NULL,419,'Reception corrector for bridging 132662',0.00,0.00,0.00,1970.00,0.00,'2022-03-08 18:32:25','',''),(2644134,'1','186','940',419,'Received from bridging 132662',0.00,0.00,1970.00,0.00,0.00,'2022-03-08 18:32:25','',''),(2644135,'1','186','940',419,'Retail Sale Id 1636066',1044000.00,0.00,0.00,2000.00,28000.00,'2022-03-08 18:34:46','',''),(2644136,'1','186','940',419,'Retail Sale Id 1636067',26100.00,0.00,0.00,50.00,700.00,'2022-03-08 18:35:34','',''),(2644137,'1','186','940',419,'Retail Sale Id 1636068',261000.00,0.00,0.00,500.00,7000.00,'2022-03-08 18:36:22','',''),(2644138,'1','186','940',419,'Retail Sale Id 1636069',26100.00,0.00,0.00,50.00,700.00,'2022-03-08 18:37:26','',''),(2644139,'1','186','940',419,'Retail Sale Id 1636070',261000.00,0.00,0.00,500.00,7000.00,'2022-03-08 18:38:33','',''),(2644140,'1','186','940',419,'Retail Sale Id 1636071',1566000.00,0.00,0.00,3000.00,42000.00,'2022-03-08 18:39:24','',''),(2644141,'1','186','940',419,'Retail Sale Id 1636072',733600.00,0.00,0.00,1400.00,22400.00,'2022-03-08 18:43:01','',''),(2644142,'1','186','940',419,'Retail Sale Id 1636073',45994.20,0.00,0.00,81.55,4566.80,'2022-03-08 18:46:11','',''),(2644143,'1','186','940',419,'Retail Sale Id 1636074',9432.00,0.00,0.00,18.00,288.00,'2022-03-10 12:54:09','',''),(2644144,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349407',342544.40,0.00,0.00,674.30,0.00,'2022-03-10 13:05:04','',''),(2644145,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14011200.00,25020.00,0.00,0.00,'2022-03-10 13:35:25','',''),(2644146,'1','186',NULL,419,'Reception corrector for bridging 132663',0.00,0.00,0.00,23000.00,0.00,'2022-03-10 13:37:47','',''),(2644147,'1','186','940',419,'Received from bridging 132663',0.00,0.00,23000.00,0.00,0.00,'2022-03-10 13:37:47','',''),(2644148,'1','186','940',419,'Retail Sale Id 1636075',9300.00,0.00,0.00,15.00,900.00,'2022-03-10 13:53:36','',''),(2644149,'1','186','940',419,'Retail Sale Id 1636076',7750.00,0.00,0.00,12.50,750.00,'2022-03-10 13:55:58','',''),(2644150,'1','186','940',419,'Retail Sale Id 1636077',290000.00,0.00,0.00,500.00,10000.00,'2022-03-10 13:57:48','',''),(2644151,'1','186','940',419,'Retail Sale Id 1636078',7750.00,0.00,0.00,12.50,750.00,'2022-03-10 14:00:29','',''),(2644152,'1','186','940',419,'Retail Sale Id 1636079',7750.00,0.00,0.00,12.50,750.00,'2022-03-10 14:01:07','',''),(2644153,'1','186','940',419,'Retail Sale Id 1636080',9300.00,0.00,0.00,15.00,900.00,'2022-03-10 17:10:22','',''),(2644154,'1','186','940',419,'Retail Sale Id 1636081',9300.00,0.00,0.00,15.00,900.00,'2022-03-10 17:11:01','',''),(2644155,'1','186','940',419,'Retail Sale Id 1636082',7750.00,0.00,0.00,12.50,750.00,'2022-03-10 17:11:41','',''),(2644156,'1','186','940',419,'Retail Sale Id 1636083',9300.00,0.00,0.00,15.00,900.00,'2022-03-10 17:12:18','',''),(2644157,'1','186','940',419,'Retail Sale Id 1636084',146630.00,0.00,0.00,236.50,14190.00,'2022-03-10 22:44:06','',''),(2644158,'1','186','940',419,'Retail Sale Id 1636085',280000.00,0.00,0.00,500.00,0.00,'2022-03-10 22:48:04','',''),(2644159,'1','186','940',419,'Return of Retail Sale Id 1636077',0.00,290000.00,500.00,0.00,-10000.00,'2022-03-10 22:51:10','',''),(2644160,'1','186','940',419,'Return of Retail Sale Id 1636085',0.00,280000.00,500.00,0.00,0.00,'2022-03-10 22:51:48','',''),(2644161,'1','186','940',419,'Retail Sale Id 1636086',837000.00,0.00,0.00,1500.00,-3000.00,'2022-03-10 22:54:41','',''),(2644162,'1','186','940',419,'Retail Sale Id 1636087',252000.00,0.00,0.00,450.00,0.00,'2022-03-10 22:56:18','',''),(2644163,'1','186','940',419,'Retail Sale Id 1636088',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 07:02:48','',''),(2644164,'1','186','940',419,'Retail Sale Id 1636089',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 07:04:02','',''),(2644165,'1','186','940',419,'Retail Sale Id 1636090',6200.00,0.00,0.00,10.00,600.00,'2022-03-11 07:04:51','',''),(2644166,'1','186','940',419,'Retail Sale Id 1636091',9300.00,0.00,0.00,15.00,900.00,'2022-03-11 09:09:30','',''),(2644167,'1','186','940',419,'Retail Sale Id 1636092',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 09:10:16','',''),(2644168,'1','186','940',419,'Retail Sale Id 1636093',29000.00,0.00,0.00,50.00,1000.00,'2022-03-11 09:53:15','',''),(2644169,'1','186','940',419,'Retail Sale Id 1636094',87000.00,0.00,0.00,150.00,3000.00,'2022-03-11 09:54:04','',''),(2644170,'1','186','940',419,'Retail Sale Id 1636095',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 09:54:43','',''),(2644171,'1','186','940',419,'Retail Sale Id 1636096',29000.00,0.00,0.00,50.00,1000.00,'2022-03-11 09:55:38','',''),(2644172,'1','186','940',419,'Retail Sale Id 1636097',116000.00,0.00,0.00,200.00,4000.00,'2022-03-11 09:59:54','',''),(2644173,'1','186','940',419,'Retail Sale Id 1636098',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 10:12:31','',''),(2644174,'1','186','940',419,'Retail Sale Id 1636099',29000.00,0.00,0.00,50.00,1000.00,'2022-03-11 10:13:48','',''),(2644175,'1','186','940',419,'Retail Sale Id 1636100',29000.00,0.00,0.00,50.00,1000.00,'2022-03-11 10:15:01','',''),(2644176,'1','186','940',419,'Retail Sale Id 1636101',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 16:13:39','',''),(2644177,'1','186','940',419,'Retail Sale Id 1636102',290000.00,0.00,0.00,500.00,10000.00,'2022-03-11 16:14:45','',''),(2644178,'1','186','940',419,'Retail Sale Id 1636103',29000.00,0.00,0.00,50.00,1000.00,'2022-03-11 16:15:30','',''),(2644179,'1','186','940',419,'Retail Sale Id 1636104',29000.00,0.00,0.00,50.00,1000.00,'2022-03-11 16:16:08','',''),(2644180,'1','186','940',419,'Retail Sale Id 1636105',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 16:16:40','',''),(2644181,'1','186','940',419,'Retail Sale Id 1636106',9300.00,0.00,0.00,15.00,900.00,'2022-03-11 16:17:15','',''),(2644182,'1','186','940',419,'Retail Sale Id 1636107',7750.00,0.00,0.00,12.50,750.00,'2022-03-11 16:17:46','',''),(2644183,'1','186','940',419,'Retail Sale Id 1636108',250000.00,0.00,0.00,500.00,-30000.00,'2022-03-11 16:19:36','',''),(2644184,'1','186','940',419,'Retail Sale Id 1636109',357740.00,0.00,0.00,577.00,34620.00,'2022-03-11 22:19:51','',''),(2644185,'1','186','940',419,'Retail Sale Id 1636110',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 07:40:40','',''),(2644186,'1','186','940',419,'Retail Sale Id 1636111',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 07:41:19','',''),(2644187,'1','186','940',419,'Retail Sale Id 1636112',3100.00,0.00,0.00,5.00,300.00,'2022-03-12 07:41:56','',''),(2644188,'1','186','940',419,'Retail Sale Id 1636113',3720.00,0.00,0.00,6.00,360.00,'2022-03-12 07:42:36','',''),(2644189,'1','186','940',419,'Retail Sale Id 1636114',1860.00,0.00,0.00,3.00,180.00,'2022-03-12 07:43:42','',''),(2644190,'1','186','940',419,'Retail Sale Id 1636115',3100.00,0.00,0.00,5.00,300.00,'2022-03-12 07:44:18','',''),(2644191,'1','186','940',419,'Retail Sale Id 1636116',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 07:45:24','',''),(2644192,'1','186','940',419,'Retail Sale Id 1636117',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 07:47:44','',''),(2644193,'1','186','940',419,'Retail Sale Id 1636118',29000.00,0.00,0.00,50.00,1000.00,'2022-03-12 08:09:53','',''),(2644194,'1','186','940',419,'Retail Sale Id 1636119',87000.00,0.00,0.00,150.00,3000.00,'2022-03-12 08:10:59','',''),(2644195,'1','186','940',419,'Retail Sale Id 1636120',58000.00,0.00,0.00,100.00,2000.00,'2022-03-12 08:13:50','',''),(2644196,'1','186','940',419,'Retail Sale Id 1636121',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:10:18','',''),(2644197,'1','186','940',419,'Retail Sale Id 1636122',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:10:57','',''),(2644198,'1','186','940',419,'Retail Sale Id 1636123',290000.00,0.00,0.00,500.00,10000.00,'2022-03-12 10:11:56','',''),(2644199,'1','186','940',419,'Retail Sale Id 1636124',58000.00,0.00,0.00,100.00,2000.00,'2022-03-12 10:12:51','',''),(2644200,'1','186','940',419,'Retail Sale Id 1636125',9300.00,0.00,0.00,15.00,900.00,'2022-03-12 10:14:07','',''),(2644201,'1','186','940',419,'Retail Sale Id 1636126',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:16:05','',''),(2644202,'1','186','940',419,'Retail Sale Id 1636127',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:33:43','',''),(2644203,'1','186','940',419,'Retail Sale Id 1636128',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:35:13','',''),(2644204,'1','186','940',419,'Retail Sale Id 1636129',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:36:12','',''),(2644205,'1','186','940',419,'Retail Sale Id 1636130',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:37:40','',''),(2644206,'1','186','940',419,'Retail Sale Id 1636131',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:43:21','',''),(2644207,'1','186','940',419,'Retail Sale Id 1636132',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:44:11','',''),(2644208,'1','186','940',419,'Retail Sale Id 1636133',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:45:11','',''),(2644209,'1','186','940',419,'Retail Sale Id 1636134',290000.00,0.00,0.00,500.00,10000.00,'2022-03-12 10:47:05','',''),(2644210,'1','186','940',419,'Retail Sale Id 1636135',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 10:54:40','',''),(2644211,'1','186','940',419,'Retail Sale Id 1636136',9300.00,0.00,0.00,15.00,900.00,'2022-03-12 14:11:15','',''),(2644212,'1','186','940',419,'Retail Sale Id 1636137',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 14:12:21','',''),(2644213,'1','186','940',419,'Retail Sale Id 1636138',174000.00,0.00,0.00,300.00,6000.00,'2022-03-12 14:13:34','',''),(2644214,'1','186','940',419,'Retail Sale Id 1636139',7750.00,0.00,0.00,12.50,750.00,'2022-03-12 15:24:33','',''),(2644215,'1','186','940',419,'Retail Sale Id 1636140',580000.00,0.00,0.00,1000.00,20000.00,'2022-03-12 21:19:31','',''),(2644216,'1','186','940',419,'Retail Sale Id 1636141',7706474.00,0.00,0.00,13333.00,239994.00,'2022-03-12 21:22:08','',''),(2644217,'1','186','940',419,'Retail Sale Id 1636142',279930.00,0.00,0.00,451.50,27090.00,'2022-03-12 21:24:48','',''),(2644218,'1','186','940',419,'Retail Sale Id 1636143',7750.00,0.00,0.00,12.50,750.00,'2022-03-13 07:28:24','',''),(2644219,'1','186','940',419,'Retail Sale Id 1636144',6200.00,0.00,0.00,10.00,600.00,'2022-03-13 07:29:24','',''),(2644220,'1','186','940',419,'Retail Sale Id 1636145',3720.00,0.00,0.00,6.00,360.00,'2022-03-13 07:30:54','',''),(2644221,'1','186','940',419,'Retail Sale Id 1636146',6200.00,0.00,0.00,10.00,600.00,'2022-03-13 07:32:01','',''),(2644222,'1','186','940',419,'Retail Sale Id 1636147',87000.00,0.00,0.00,150.00,3000.00,'2022-03-13 07:33:43','',''),(2644223,'1','186','940',419,'Retail Sale Id 1636148',7750.00,0.00,0.00,12.50,750.00,'2022-03-13 09:42:17','',''),(2644224,'1','186','940',419,'Retail Sale Id 1636149',7750.00,0.00,0.00,12.50,750.00,'2022-03-13 09:46:37','',''),(2644225,'1','186','940',419,'Retail Sale Id 1636150',116000.00,0.00,0.00,200.00,4000.00,'2022-03-13 09:47:29','',''),(2644226,'1','186','940',419,'Retail Sale Id 1636151',290000.00,0.00,0.00,500.00,10000.00,'2022-03-13 10:13:18','',''),(2644227,'1','186','940',419,'Retail Sale Id 1636152',87000.00,0.00,0.00,150.00,3000.00,'2022-03-13 15:17:40','',''),(2644228,'1','186',NULL,419,'Reception corrector for bridging 132664',0.00,0.00,0.00,2020.00,0.00,'2022-03-13 15:47:58','',''),(2644229,'1','186','940',419,'Received from bridging 132664',0.00,0.00,2020.00,0.00,0.00,'2022-03-13 15:47:58','',''),(2644230,'1','186','940',419,'Retail Sale Id 1636153',290000.00,0.00,0.00,500.00,10000.00,'2022-03-13 16:03:10','',''),(2644231,'1','186','940',419,'Retail Sale Id 1636154',7750.00,0.00,0.00,12.50,750.00,'2022-03-13 16:04:48','',''),(2644232,'1','186','940',419,'Retail Sale Id 1636155',290000.00,0.00,0.00,500.00,10000.00,'2022-03-13 16:06:35','',''),(2644233,'1','186','940',419,'Retail Sale Id 1636156',664700.00,0.00,0.00,1150.00,20700.00,'2022-03-13 16:30:53','',''),(2644234,'1','186','940',419,'Retail Sale Id 1636157',7750.00,0.00,0.00,12.50,750.00,'2022-03-13 17:15:45','',''),(2644235,'1','186','940',419,'Retail Sale Id 1636158',3100.00,0.00,0.00,5.00,300.00,'2022-03-13 22:26:04','',''),(2644236,'1','186','940',419,'Retail Sale Id 1636159',6200.00,0.00,0.00,10.00,600.00,'2022-03-13 22:28:20','',''),(2644237,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349408',199920.00,0.00,0.00,357.00,0.00,'2022-03-14 08:44:28','',''),(2644238,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,11205600.00,20010.00,0.00,0.00,'2022-03-14 10:53:14','',''),(2644239,'1','186',NULL,419,'Reception corrector for bridging 132665',0.00,0.00,0.00,20010.00,0.00,'2022-03-14 10:56:03','',''),(2644240,'1','186','940',419,'Received from bridging 132665',0.00,0.00,20010.00,0.00,0.00,'2022-03-14 10:56:03','',''),(2644241,'1','186','940',419,'Retail Sale Id 1636160',4021828.04,0.00,0.00,6958.18,125247.24,'2022-03-14 11:13:14','',''),(2644242,'1','186','940',419,'Retail Sale Id 1636161',35526.00,0.00,0.00,57.30,3438.00,'2022-03-14 11:15:16','',''),(2644243,'1','186','940',419,'Retail Sale Id 1636162',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 11:51:15','',''),(2644244,'1','186','940',419,'Retail Sale Id 1636163',290000.00,0.00,0.00,500.00,10000.00,'2022-03-14 15:50:43','',''),(2644245,'1','186','940',419,'Retail Sale Id 1636164',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 15:52:14','',''),(2644246,'1','186','940',419,'Retail Sale Id 1636165',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 15:54:11','',''),(2644247,'1','186','940',419,'Retail Sale Id 1636166',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 15:54:57','',''),(2644248,'1','186','940',419,'Retail Sale Id 1636167',9300.00,0.00,0.00,15.00,900.00,'2022-03-14 16:01:14','',''),(2644249,'1','186','940',419,'Retail Sale Id 1636168',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:02:07','',''),(2644250,'1','186','940',419,'Retail Sale Id 1636169',9300.00,0.00,0.00,15.00,900.00,'2022-03-14 16:02:55','',''),(2644251,'1','186','940',419,'Retail Sale Id 1636170',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:04:44','',''),(2644252,'1','186','940',419,'Retail Sale Id 1636171',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:05:19','',''),(2644253,'1','186','940',419,'Retail Sale Id 1636172',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:15:14','',''),(2644254,'1','186','940',419,'Retail Sale Id 1636174',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:15:46','',''),(2644255,'1','186','940',419,'Retail Sale Id 1636175',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:24:09','',''),(2644256,'1','186','940',419,'Retail Sale Id 1636176',7750.00,0.00,0.00,12.50,750.00,'2022-03-14 16:24:53','',''),(2644257,'1','186','940',419,'Retail Sale Id 1636177',174000.00,0.00,0.00,300.00,6000.00,'2022-03-14 16:43:49','',''),(2644258,'1','186','940',419,'Retail Sale Id 1636178',1156000.00,0.00,0.00,2000.00,36000.00,'2022-03-14 22:52:06','',''),(2644259,'1','186','940',419,'Return of Retail Sale Id 1636178',0.00,1156000.00,2000.00,0.00,-36000.00,'2022-03-14 22:54:42','',''),(2644260,'1','186','940',419,'Retail Sale Id 1636179',957900.00,0.00,0.00,1545.00,92700.00,'2022-03-14 22:58:30','',''),(2644261,'1','186','940',419,'Return of Retail Sale Id 1636179',0.00,957900.00,1545.00,0.00,-92700.00,'2022-03-14 23:02:02','',''),(2644262,'1','186','940',419,'Retail Sale Id 1636180',337900.00,0.00,0.00,545.00,32700.00,'2022-03-14 23:04:21','',''),(2644263,'1','186','940',419,'Retail Sale Id 1636181',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 08:07:47','',''),(2644264,'1','186','940',419,'Retail Sale Id 1636182',9300.00,0.00,0.00,15.00,900.00,'2022-03-15 08:09:08','',''),(2644265,'1','186','940',419,'Retail Sale Id 1636183',145000.00,0.00,0.00,250.00,5000.00,'2022-03-15 08:10:20','',''),(2644266,'1','186','940',419,'Retail Sale Id 1636184',6200.00,0.00,0.00,10.00,600.00,'2022-03-15 08:15:07','',''),(2644267,'1','186','940',419,'Retail Sale Id 1636185',9300.00,0.00,0.00,15.00,900.00,'2022-03-15 08:16:44','',''),(2644268,'1','186','940',419,'Retail Sale Id 1636186',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 08:17:40','',''),(2644269,'1','186','940',419,'Retail Sale Id 1636187',9300.00,0.00,0.00,15.00,900.00,'2022-03-15 08:18:33','',''),(2644270,'1','186','940',419,'Retail Sale Id 1636188',87000.00,0.00,0.00,150.00,3000.00,'2022-03-15 08:19:35','',''),(2644271,'1','186','940',419,'Retail Sale Id 1636189',9300.00,0.00,0.00,15.00,900.00,'2022-03-15 10:23:49','',''),(2644272,'1','186','940',419,'Retail Sale Id 1636190',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 10:30:11','',''),(2644273,'1','186','940',419,'Retail Sale Id 1636191',9300.00,0.00,0.00,15.00,900.00,'2022-03-15 10:34:04','',''),(2644274,'1','186','940',419,'Retail Sale Id 1636192',290000.00,0.00,0.00,500.00,10000.00,'2022-03-15 10:35:43','',''),(2644275,'1','186','940',419,'Retail Sale Id 1636193',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 10:52:54','',''),(2644276,'1','186','940',419,'Retail Sale Id 1636194',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 10:53:31','',''),(2644277,'1','186','940',419,'Retail Sale Id 1636195',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 10:55:26','',''),(2644278,'1','186','940',419,'Retail Sale Id 1636196',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 10:56:03','',''),(2644279,'1','186','940',419,'Retail Sale Id 1636197',7750.00,0.00,0.00,12.50,750.00,'2022-03-15 10:58:55','',''),(2644280,'1','186','940',419,'Retail Sale Id 1636198',290000.00,0.00,0.00,500.00,10000.00,'2022-03-15 11:56:00','',''),(2644281,'1','186','940',419,'Retail Sale Id 1636199',2890000.00,0.00,0.00,5000.00,90000.00,'2022-03-15 20:53:03','',''),(2644282,'1','186','940',419,'Return of Retail Sale Id 1636199',0.00,2890000.00,5000.00,0.00,-90000.00,'2022-03-15 22:42:16','',''),(2644283,'1','186','940',419,'Retail Sale Id 1636200',9000000.00,0.00,0.00,3000.00,7320000.00,'2022-03-15 22:43:32','',''),(2644284,'1','186','940',419,'Return of Retail Sale Id 1636200',0.00,9000000.00,3000.00,0.00,-7320000.00,'2022-03-15 22:44:15','',''),(2644285,'1','186','940',419,'Retail Sale Id 1636201',1734000.00,0.00,0.00,3000.00,54000.00,'2022-03-15 22:45:11','',''),(2644286,'1','186','940',419,'Retail Sale Id 1636202',154070.00,0.00,0.00,248.50,14910.00,'2022-03-15 22:49:33','',''),(2644287,'1','186','940',419,'Retail Sale Id 1636203',87000.00,0.00,0.00,150.00,3000.00,'2022-03-16 07:48:14','',''),(2644288,'1','186','940',419,'Retail Sale Id 1636204',3720.00,0.00,0.00,6.00,360.00,'2022-03-16 07:49:38','',''),(2644289,'1','186','940',419,'Retail Sale Id 1636205',7750.00,0.00,0.00,12.50,750.00,'2022-03-16 08:53:10','',''),(2644290,'1','186','940',419,'Retail Sale Id 1636206',7750.00,0.00,0.00,12.50,750.00,'2022-03-16 08:53:58','',''),(2644291,'1','186','940',419,'Retail Sale Id 1636207',116000.00,0.00,0.00,200.00,4000.00,'2022-03-16 21:10:05','',''),(2644292,'1','186','940',419,'Retail Sale Id 1636208',2485400.00,0.00,0.00,4300.00,77400.00,'2022-03-16 21:14:02','',''),(2644293,'1','186','940',419,'Retail Sale Id 1636209',783000.00,0.00,0.00,1350.00,27000.00,'2022-03-16 21:15:19','',''),(2644294,'1','186','940',419,'Retail Sale Id 1636210',156562.40,0.00,0.00,252.52,15151.20,'2022-03-16 21:18:58','',''),(2644295,'1','186','940',419,'Distributed to AARANO for sales id:349409',204400.00,0.00,0.00,365.00,0.00,'2022-03-17 20:35:55','',''),(2644296,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14011200.00,25020.00,0.00,0.00,'2022-03-17 20:40:10','',''),(2644297,'1','186',NULL,419,'Reception corrector for bridging 132666',0.00,0.00,0.00,23000.00,0.00,'2022-03-17 20:42:00','',''),(2644298,'1','186','940',419,'Received from bridging 132666',0.00,0.00,23000.00,0.00,0.00,'2022-03-17 20:42:00','',''),(2644299,'1','186','940',419,'Retail Sale Id 1636211',404600.00,0.00,0.00,700.00,12600.00,'2022-03-17 20:47:59','',''),(2644300,'1','186','940',419,'Retail Sale Id 1636212',9300.00,0.00,0.00,15.00,900.00,'2022-03-18 08:15:44','',''),(2644301,'1','186','940',419,'Retail Sale Id 1636213',7750.00,0.00,0.00,12.50,750.00,'2022-03-18 08:48:07','',''),(2644302,'1','186','940',419,'Retail Sale Id 1636214',7750.00,0.00,0.00,12.50,750.00,'2022-03-18 08:48:39','',''),(2644303,'1','186','940',419,'Retail Sale Id 1636215',7750.00,0.00,0.00,12.50,750.00,'2022-03-18 08:49:13','',''),(2644304,'1','186','940',419,'Retail Sale Id 1636216',288000.00,0.00,0.00,500.00,8000.00,'2022-03-18 09:07:36','',''),(2644305,'1','186','940',419,'Retail Sale Id 1636217',7750.00,0.00,0.00,12.50,750.00,'2022-03-18 09:12:08','',''),(2644306,'1','186','940',419,'Retail Sale Id 1636218',7750.00,0.00,0.00,12.50,750.00,'2022-03-18 09:15:21','',''),(2644307,'1','186','940',419,'Retail Sale Id 1636219',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:17:58','',''),(2644308,'1','186','940',419,'Retail Sale Id 1636220',9300.00,0.00,0.00,15.00,0.00,'2022-03-18 09:18:47','',''),(2644309,'1','186','940',419,'Retail Sale Id 1636221',9300.00,0.00,0.00,15.00,0.00,'2022-03-18 09:19:26','',''),(2644310,'1','186','940',419,'Retail Sale Id 1636222',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:23:10','',''),(2644311,'1','186','940',419,'Retail Sale Id 1636223',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:26:06','',''),(2644312,'1','186','940',419,'Retail Sale Id 1636224',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:27:27','',''),(2644313,'1','186','940',419,'Retail Sale Id 1636225',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:31:19','',''),(2644314,'1','186','940',419,'Retail Sale Id 1636226',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:34:37','',''),(2644315,'1','186','940',419,'Retail Sale Id 1636227',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 09:36:43','',''),(2644316,'1','186','940',419,'Retail Sale Id 1636228',28800.00,0.00,0.00,50.00,-2200.00,'2022-03-18 17:22:20','',''),(2644317,'1','186','940',419,'Retail Sale Id 1636229',9300.00,0.00,0.00,15.00,0.00,'2022-03-18 17:23:17','',''),(2644318,'1','186','940',419,'Retail Sale Id 1636230',57600.00,0.00,0.00,100.00,-4400.00,'2022-03-18 17:25:08','',''),(2644319,'1','186','940',419,'Retail Sale Id 1636231',288000.00,0.00,0.00,500.00,-22000.00,'2022-03-18 17:26:31','',''),(2644320,'1','186','940',419,'Retail Sale Id 1636232',28800.00,0.00,0.00,50.00,-2200.00,'2022-03-18 17:27:50','',''),(2644321,'1','186','940',419,'Retail Sale Id 1636233',7750.00,0.00,0.00,12.50,0.00,'2022-03-18 17:29:16','',''),(2644322,'1','186','940',419,'Retail Sale Id 1636234',115200.00,0.00,0.00,200.00,-8800.00,'2022-03-18 17:32:58','',''),(2644323,'1','186','940',419,'Retail Sale Id 1636235',9300.00,0.00,0.00,15.00,0.00,'2022-03-18 20:04:01','',''),(2644324,'1','186','940',419,'Retail Sale Id 1636236',21000000.00,0.00,0.00,3000.00,19140000.00,'2022-03-18 20:15:26','',''),(2644325,'1','186','940',419,'Retail Sale Id 1636237',4032000.00,0.00,0.00,7000.00,-308000.00,'2022-03-18 20:24:25','',''),(2644326,'1','186','940',419,'Return of Retail Sale Id 1636237',0.00,4032000.00,7000.00,0.00,308000.00,'2022-03-18 20:26:25','',''),(2644327,'1','186','940',419,'Return of Retail Sale Id 1636236',0.00,21000000.00,3000.00,0.00,-19140000.00,'2022-03-18 20:27:16','',''),(2644328,'1','186','940',419,'Retail Sale Id 1636238',4032000.00,0.00,0.00,7000.00,-308000.00,'2022-03-18 20:32:00','',''),(2644329,'1','186','940',419,'Retail Sale Id 1636239',253890.00,0.00,0.00,409.50,0.00,'2022-03-18 22:29:26','',''),(2644330,'1','186','940',419,'Retail Sale Id 1636240',1152000.00,0.00,0.00,2000.00,-88000.00,'2022-03-18 22:32:25','',''),(2644331,'1','186','940',419,'Return of Retail Sale Id 1636238',0.00,4032000.00,7000.00,0.00,308000.00,'2022-03-18 22:34:45','',''),(2644332,'1','186','940',419,'Retail Sale Id 1636241',5166000.00,0.00,0.00,9000.00,-414000.00,'2022-03-18 22:36:31','',''),(2644333,'1','186','940',419,'Retail Sale Id 1636242',86400.00,0.00,0.00,150.00,-6600.00,'2022-03-19 08:26:15','',''),(2644334,'1','186','940',419,'Retail Sale Id 1636243',6200.00,0.00,0.00,10.00,0.00,'2022-03-19 08:26:55','',''),(2644335,'1','186','940',419,'Retail Sale Id 1636244',7750.00,0.00,0.00,12.50,0.00,'2022-03-19 10:48:20','',''),(2644336,'1','186','940',419,'Retail Sale Id 1636245',7750.00,0.00,0.00,12.50,0.00,'2022-03-19 12:02:28','',''),(2644337,'1','186','940',419,'Retail Sale Id 1636246',288000.00,0.00,0.00,500.00,-22000.00,'2022-03-19 12:20:08','',''),(2644338,'1','186','940',419,'Retail Sale Id 1636247',7750.00,0.00,0.00,12.50,0.00,'2022-03-19 12:20:42','',''),(2644339,'1','186','940',419,'Retail Sale Id 1636248',7750.00,0.00,0.00,12.50,0.00,'2022-03-19 12:28:42','',''),(2644340,'1','186','940',419,'Retail Sale Id 1636249',7750.00,0.00,0.00,12.50,0.00,'2022-03-19 16:08:53','',''),(2644341,'1','186','940',419,'Retail Sale Id 1636250',7750.00,0.00,0.00,12.50,0.00,'2022-03-19 16:09:22','',''),(2644342,'1','186','940',419,'Retail Sale Id 1636251',201600.00,0.00,0.00,350.00,-15400.00,'2022-03-19 16:10:32','',''),(2644343,'1','186','940',419,'Retail Sale Id 1636252',373100.00,0.00,0.00,650.00,-29900.00,'2022-03-19 22:52:26','',''),(2644344,'1','186','940',419,'Return of Retail Sale Id 1636252',0.00,373100.00,650.00,0.00,29900.00,'2022-03-19 22:54:15','',''),(2644345,'1','186','940',419,'Retail Sale Id 1636253',374400.00,0.00,0.00,650.00,-28600.00,'2022-03-19 22:55:40','',''),(2644346,'1','186','940',419,'Retail Sale Id 1636254',384400.00,0.00,0.00,620.00,0.00,'2022-03-19 22:56:58','',''),(2644347,'1','186','940',419,'Retail Sale Id 1636255',2870000.00,0.00,0.00,5000.00,-230000.00,'2022-03-19 22:58:52','',''),(2644348,'1','186','940',419,'Return of Retail Sale Id 1636255',0.00,2870000.00,5000.00,0.00,230000.00,'2022-03-19 22:59:46','',''),(2644349,'1','186','940',419,'Retail Sale Id 1636256',1722000.00,0.00,0.00,3000.00,-138000.00,'2022-03-19 23:01:02','',''),(2644350,'1','186','940',419,'Retail Sale Id 1636257',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:15:37','',''),(2644351,'1','186','940',419,'Retail Sale Id 1636258',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:16:08','',''),(2644352,'1','186','940',419,'Retail Sale Id 1636259',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:16:41','',''),(2644353,'1','186','940',419,'Retail Sale Id 1636260',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:17:21','',''),(2644354,'1','186','940',419,'Retail Sale Id 1636261',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:18:18','',''),(2644355,'1','186','940',419,'Retail Sale Id 1636262',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:19:02','',''),(2644356,'1','186','940',419,'Retail Sale Id 1636263',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:19:36','',''),(2644357,'1','186','940',419,'Retail Sale Id 1636264',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:20:21','',''),(2644358,'1','186','940',419,'Retail Sale Id 1636265',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:20:58','',''),(2644359,'1','186','940',419,'Retail Sale Id 1636266',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:21:34','',''),(2644360,'1','186','940',419,'Retail Sale Id 1636267',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:22:05','',''),(2644361,'1','186','940',419,'Retail Sale Id 1636268',7750.00,0.00,0.00,12.50,0.00,'2022-03-20 08:22:35','',''),(2644362,'1','186','940',419,'Retail Sale Id 1636269',1722000.00,0.00,0.00,3000.00,-138000.00,'2022-03-20 13:08:09','',''),(2644363,'1','186',NULL,419,'Reception corrector for bridging 132667',0.00,0.00,0.00,2020.00,0.00,'2022-03-20 13:22:34','',''),(2644364,'1','186','940',419,'Received from bridging 132667',0.00,0.00,2020.00,0.00,0.00,'2022-03-20 13:22:34','',''),(2644365,'1','186','940',419,'Retail Sale Id 1636270',861000.00,0.00,0.00,1500.00,-69000.00,'2022-03-20 21:11:44','',''),(2644366,'1','186','940',419,'Return of Retail Sale Id 1636270',0.00,861000.00,1500.00,0.00,69000.00,'2022-03-20 21:13:17','',''),(2644367,'1','186','940',419,'Return of Retail Sale Id 1636269',0.00,1722000.00,3000.00,0.00,138000.00,'2022-03-20 21:15:51','',''),(2644368,'1','186','940',419,'Retail Sale Id 1636271',2583000.00,0.00,0.00,4500.00,-207000.00,'2022-03-20 21:17:05','',''),(2644369,'1','186','940',419,'Return of Retail Sale Id 1636271',0.00,2583000.00,4500.00,0.00,207000.00,'2022-03-20 21:25:20','',''),(2644370,'1','186','940',419,'Retail Sale Id 1636274',2583000.00,0.00,0.00,4500.00,-207000.00,'2022-03-20 21:27:26','',''),(2644371,'1','186','940',419,'Retail Sale Id 1636275',403200.00,0.00,0.00,700.00,-30800.00,'2022-03-20 21:29:00','',''),(2644372,'1','186','940',419,'Retail Sale Id 1636276',62000.00,0.00,0.00,100.00,0.00,'2022-03-20 21:31:01','',''),(2644373,'1','186','940',419,'Retail Sale Id 1636277',65088.00,0.00,0.00,113.00,-4972.00,'2022-03-20 21:33:31','',''),(2644374,'1','186','940',419,'Distributed to AARANO for sales id:349410',220100.00,0.00,0.00,355.00,0.00,'2022-03-21 09:57:20','',''),(2644375,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13988800.00,24980.00,0.00,0.00,'2022-03-23 18:07:34','',''),(2644376,'1','186',NULL,419,'Reception corrector for bridging 132668',0.00,0.00,0.00,23000.00,0.00,'2022-03-23 18:11:07','',''),(2644377,'1','186','940',419,'Received from bridging 132668',0.00,0.00,23000.00,0.00,0.00,'2022-03-23 18:11:07','',''),(2644378,'1','186','940',419,'Retail Sale Id 1636278',7750.00,0.00,0.00,12.50,750.00,'2022-03-24 09:37:56','',''),(2644379,'1','186','940',419,'Retail Sale Id 1636279',9300.00,0.00,0.00,15.00,900.00,'2022-03-24 09:38:31','',''),(2644380,'1','186','940',419,'Retail Sale Id 1636280',7750.00,0.00,0.00,12.50,750.00,'2022-03-24 09:40:11','',''),(2644381,'1','186','940',419,'Retail Sale Id 1636281',7750.00,0.00,0.00,12.50,750.00,'2022-03-24 09:41:58','',''),(2644382,'1','186','940',419,'Retail Sale Id 1636282',288000.00,0.00,0.00,500.00,8000.00,'2022-03-24 09:43:42','',''),(2644383,'1','186','940',419,'Retail Sale Id 1636283',7750.00,0.00,0.00,12.50,750.00,'2022-03-24 09:44:36','',''),(2644384,'1','186','940',419,'Retail Sale Id 1636284',11780.00,0.00,0.00,19.00,1140.00,'2022-03-24 09:45:08','',''),(2644385,'1','186','940',419,'Retail Sale Id 1636285',3720.00,0.00,0.00,6.00,360.00,'2022-03-24 09:46:37','',''),(2644386,'1','186','940',419,'Retail Sale Id 1636286',7750.00,0.00,0.00,12.50,750.00,'2022-03-24 09:47:12','',''),(2644387,'1','186','940',419,'Retail Sale Id 1636287',1860.00,0.00,0.00,3.00,180.00,'2022-03-24 09:48:18','',''),(2644388,'1','186','940',419,'Retail Sale Id 1636288',3100.00,0.00,0.00,5.00,300.00,'2022-03-24 09:49:52','',''),(2644389,'1','186','940',419,'Retail Sale Id 1636289',7750.00,0.00,0.00,12.50,750.00,'2022-03-24 09:50:39','',''),(2644390,'1','186','940',419,'Retail Sale Id 1636290',3720.00,0.00,0.00,6.00,360.00,'2022-03-24 09:51:21','',''),(2644391,'1','186','940',419,'Retail Sale Id 1636291',288000.00,0.00,0.00,500.00,8000.00,'2022-03-24 09:52:50','',''),(2644392,'1','186','940',419,'Retail Sale Id 1636292',9300.00,0.00,0.00,15.00,900.00,'2022-03-24 09:56:25','',''),(2644393,'1','186','940',419,'Retail Sale Id 1636293',288000.00,0.00,0.00,500.00,8000.00,'2022-03-24 10:57:28','',''),(2644394,'1','186','940',419,'Retail Sale Id 1636294',1148000.00,0.00,0.00,2000.00,28000.00,'2022-03-24 10:59:13','',''),(2644395,'1','186','940',419,'Retail Sale Id 1636295',355260.00,0.00,0.00,573.00,34380.00,'2022-03-24 21:58:24','',''),(2644396,'1','186','940',419,'Retail Sale Id 1636296',1152000.00,0.00,0.00,2000.00,32000.00,'2022-03-24 21:59:57','',''),(2644397,'1','186','940',419,'Retail Sale Id 1636297',2870000.00,0.00,0.00,5000.00,70000.00,'2022-03-24 22:01:56','',''),(2644398,'1','186','940',419,'Retail Sale Id 1636298',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 07:59:17','',''),(2644399,'1','186','940',419,'Retail Sale Id 1636299',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:04:39','',''),(2644400,'1','186','940',419,'Retail Sale Id 1636300',3720.00,0.00,0.00,6.00,360.00,'2022-03-25 08:05:18','',''),(2644401,'1','186','940',419,'Retail Sale Id 1636301',3100.00,0.00,0.00,5.00,300.00,'2022-03-25 08:05:51','',''),(2644402,'1','186','940',419,'Retail Sale Id 1636302',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:06:47','',''),(2644403,'1','186','940',419,'Retail Sale Id 1636303',1860.00,0.00,0.00,3.00,180.00,'2022-03-25 08:07:46','',''),(2644404,'1','186','940',419,'Retail Sale Id 1636304',288000.00,0.00,0.00,500.00,8000.00,'2022-03-25 08:09:22','',''),(2644405,'1','186','940',419,'Retail Sale Id 1636305',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:10:12','',''),(2644406,'1','186','940',419,'Retail Sale Id 1636306',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:11:06','',''),(2644407,'1','186','940',419,'Retail Sale Id 1636307',9300.00,0.00,0.00,15.00,900.00,'2022-03-25 08:11:47','',''),(2644408,'1','186','940',419,'Retail Sale Id 1636308',86400.00,0.00,0.00,150.00,2400.00,'2022-03-25 08:12:33','',''),(2644409,'1','186','940',419,'Retail Sale Id 1636309',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:14:21','',''),(2644410,'1','186','940',419,'Retail Sale Id 1636310',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:15:21','',''),(2644411,'1','186','940',419,'Retail Sale Id 1636311',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:16:26','',''),(2644412,'1','186','940',419,'Retail Sale Id 1636312',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:54:36','',''),(2644413,'1','186','940',419,'Retail Sale Id 1636313',288000.00,0.00,0.00,500.00,8000.00,'2022-03-25 08:55:23','',''),(2644414,'1','186','940',419,'Retail Sale Id 1636314',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 08:56:51','',''),(2644415,'1','186','940',419,'Retail Sale Id 1636315',11780.00,0.00,0.00,19.00,1140.00,'2022-03-25 15:32:40','',''),(2644416,'1','186','940',419,'Retail Sale Id 1636316',288000.00,0.00,0.00,500.00,8000.00,'2022-03-25 15:34:23','',''),(2644417,'1','186','940',419,'Retail Sale Id 1636317',7750.00,0.00,0.00,12.50,750.00,'2022-03-25 17:34:26','',''),(2644418,'1','186','940',419,'Retail Sale Id 1636319',2870000.00,0.00,0.00,5000.00,70000.00,'2022-03-25 21:23:34','',''),(2644419,'1','186','940',419,'Retail Sale Id 1636320',1150000.00,0.00,0.00,2000.00,30000.00,'2022-03-25 21:25:14','',''),(2644420,'1','186','940',419,'Retail Sale Id 1636321',201500.00,0.00,0.00,325.00,19500.00,'2022-03-25 21:27:40','',''),(2644421,'1','186','940',419,'Retail Sale Id 1636322',574000.00,0.00,0.00,1000.00,14000.00,'2022-03-25 21:31:11','',''),(2644422,'1','186','940',419,'Return of Retail Sale Id 1636322',0.00,574000.00,1000.00,0.00,-14000.00,'2022-03-25 21:36:18','',''),(2644423,'1','186','940',419,'Return of Retail Sale Id 1636319',0.00,2870000.00,5000.00,0.00,-70000.00,'2022-03-25 21:41:45','',''),(2644424,'1','186','940',419,'Return of Retail Sale Id 1636320',0.00,1150000.00,2000.00,0.00,-30000.00,'2022-03-25 21:42:56','',''),(2644425,'1','186','940',419,'Retail Sale Id 1636324',3444000.00,0.00,0.00,6000.00,84000.00,'2022-03-25 21:50:30','',''),(2644426,'1','186','940',419,'Retail Sale Id 1636323',1152000.00,0.00,0.00,2000.00,32000.00,'2022-03-25 21:55:06','',''),(2644427,'1','186',NULL,419,'Reception corrector for bridging 132669',0.00,0.00,0.00,1980.00,0.00,'2022-03-26 08:43:23','',''),(2644428,'1','186','940',419,'Received from bridging 132669',0.00,0.00,1980.00,0.00,0.00,'2022-03-26 08:43:23','',''),(2644429,'1','186','940',419,'Retail Sale Id 1636325',1148000.00,0.00,0.00,2000.00,28000.00,'2022-03-26 08:44:37','',''),(2644430,'1','186','940',419,'Retail Sale Id 1636326',7750.00,0.00,0.00,12.50,750.00,'2022-03-26 08:45:11','',''),(2644431,'1','186','940',419,'Retail Sale Id 1636327',9300.00,0.00,0.00,15.00,900.00,'2022-03-26 08:45:43','',''),(2644432,'1','186','940',419,'Retail Sale Id 1636328',7750.00,0.00,0.00,12.50,750.00,'2022-03-26 08:46:28','',''),(2644433,'1','186','940',419,'Retail Sale Id 1636329',7750.00,0.00,0.00,12.50,750.00,'2022-03-26 14:46:26','',''),(2644434,'1','186','940',419,'Retail Sale Id 1636330',7750.00,0.00,0.00,12.50,750.00,'2022-03-26 14:47:10','',''),(2644435,'1','186','940',419,'Retail Sale Id 1636332',288000.00,0.00,0.00,500.00,8000.00,'2022-03-26 14:51:21','',''),(2644436,'1','186','940',419,'Retail Sale Id 1636333',379872.00,0.00,0.00,659.50,10552.00,'2022-03-26 14:54:33','',''),(2644437,'1','186','940',419,'Return of Retail Sale Id 1636332',0.00,288000.00,500.00,0.00,-8000.00,'2022-03-26 14:55:35','',''),(2644438,'1','186','940',419,'Retail Sale Id 1636334',287000.00,0.00,0.00,500.00,7000.00,'2022-03-26 14:56:17','',''),(2644439,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349411',211680.00,0.00,0.00,378.00,0.00,'2022-03-26 20:35:20','',''),(2644440,'1','186','940',419,'Return of Retail Sale Id 1636333',0.00,379872.00,659.50,0.00,-10552.00,'2022-03-26 20:52:49','',''),(2644441,'1','186','940',419,'Retail Sale Id 1636335',162144.00,0.00,0.00,281.50,4504.00,'2022-03-26 21:00:16','',''),(2644442,'1','186','940',419,'Distributed to AARANO for sales id:349412',211680.00,0.00,0.00,378.00,0.00,'2022-03-27 07:12:05','',''),(2644443,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13977600.00,24960.00,0.00,0.00,'2022-03-27 07:20:33','',''),(2644444,'1','186',NULL,419,'Reception corrector for bridging 132670',0.00,0.00,0.00,23000.00,0.00,'2022-03-27 07:49:04','',''),(2644445,'1','186','940',419,'Received from bridging 132670',0.00,0.00,23000.00,0.00,0.00,'2022-03-27 07:49:04','',''),(2644446,'1','186','940',419,'Retail Sale Id 1636336',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:05:48','',''),(2644447,'1','186','940',419,'Retail Sale Id 1636337',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:10:10','',''),(2644448,'1','186','940',419,'Retail Sale Id 1636338',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:11:00','',''),(2644449,'1','186','940',419,'Retail Sale Id 1636339',3100.00,0.00,0.00,5.00,300.00,'2022-03-27 08:12:04','',''),(2644450,'1','186','940',419,'Retail Sale Id 1636340',3100.00,0.00,0.00,5.00,300.00,'2022-03-27 08:12:49','',''),(2644451,'1','186','940',419,'Retail Sale Id 1636341',3720.00,0.00,0.00,6.00,360.00,'2022-03-27 08:13:40','',''),(2644452,'1','186','940',419,'Retail Sale Id 1636342',6200.00,0.00,0.00,10.00,600.00,'2022-03-27 08:14:28','',''),(2644453,'1','186','940',419,'Retail Sale Id 1636343',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:15:01','',''),(2644454,'1','186','940',419,'Retail Sale Id 1636344',574000.00,0.00,0.00,1000.00,14000.00,'2022-03-27 08:16:33','',''),(2644455,'1','186','940',419,'Retail Sale Id 1636345',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:17:17','',''),(2644456,'1','186','940',419,'Retail Sale Id 1636346',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:18:16','',''),(2644457,'1','186','940',419,'Retail Sale Id 1636347',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:19:09','',''),(2644458,'1','186','940',419,'Retail Sale Id 1636348',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 08:19:51','',''),(2644459,'1','186','940',419,'Retail Sale Id 1636349',9300.00,0.00,0.00,15.00,900.00,'2022-03-27 08:20:58','',''),(2644460,'1','186','940',419,'Retail Sale Id 1636350',287000.00,0.00,0.00,500.00,7000.00,'2022-03-27 08:24:21','',''),(2644461,'1','186','940',419,'Retail Sale Id 1636351',7750.00,0.00,0.00,12.50,750.00,'2022-03-27 11:05:23','',''),(2644462,'1','186','940',419,'Retail Sale Id 1636352',5510400.00,0.00,0.00,9600.00,134400.00,'2022-03-27 12:38:57','',''),(2644463,'1','186','940',419,'Retail Sale Id 1636353',1152000.00,0.00,0.00,2000.00,32000.00,'2022-03-27 12:43:20','',''),(2644464,'1','186','940',419,'Retail Sale Id 1636354',8250.00,0.00,0.00,12.50,0.00,'2022-03-27 14:27:17','',''),(2644465,'1','186','940',419,'Retail Sale Id 1636355',1152000.00,0.00,0.00,2000.00,-168000.00,'2022-03-27 22:00:33','',''),(2644466,'1','186','940',419,'Retail Sale Id 1636356',1148000.00,0.00,0.00,2000.00,-172000.00,'2022-03-27 22:01:35','',''),(2644467,'1','186','940',419,'Return of Retail Sale Id 1636354',0.00,8250.00,12.50,0.00,0.00,'2022-03-27 22:08:25','',''),(2644468,'1','186','940',419,'Retail Sale Id 1636357',186000.00,0.00,0.00,300.00,0.00,'2022-03-27 22:12:25','',''),(2644469,'1','186','940',419,'Retail Sale Id 1636358',8250.00,0.00,0.00,12.50,0.00,'2022-03-27 22:38:39','',''),(2644470,'1','186','940',419,'Retail Sale Id 1636359',9900.00,0.00,0.00,15.00,0.00,'2022-03-27 22:39:16','',''),(2644471,'1','186','940',419,'Retail Sale Id 1636360',6600.00,0.00,0.00,10.00,0.00,'2022-03-27 22:40:19','',''),(2644472,'1','186','940',419,'Retail Sale Id 1636361',9900.00,0.00,0.00,15.00,0.00,'2022-03-27 22:41:02','',''),(2644473,'1','186','940',419,'Retail Sale Id 1636362',1980.00,0.00,0.00,3.00,0.00,'2022-03-27 22:41:52','',''),(2644474,'1','186','940',419,'Retail Sale Id 1636363',3300.00,0.00,0.00,5.00,0.00,'2022-03-27 22:42:40','',''),(2644475,'1','186','940',419,'Retail Sale Id 1636364',31000.00,0.00,0.00,50.00,-2000.00,'2022-03-27 22:43:47','',''),(2644476,'1','186','940',419,'Retail Sale Id 1636365',93000.00,0.00,0.00,150.00,-6000.00,'2022-03-27 22:44:56','',''),(2644477,'1','186','940',419,'Retail Sale Id 1636366',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 08:53:53','',''),(2644478,'1','186','940',419,'Retail Sale Id 1636367',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 08:55:27','',''),(2644479,'1','186','940',419,'Retail Sale Id 1636368',3300.00,0.00,0.00,5.00,0.00,'2022-03-28 08:56:12','',''),(2644480,'1','186','940',419,'Retail Sale Id 1636369',3960.00,0.00,0.00,6.00,0.00,'2022-03-28 08:57:05','',''),(2644481,'1','186','940',419,'Retail Sale Id 1636370',1980.00,0.00,0.00,3.00,0.00,'2022-03-28 08:57:47','',''),(2644482,'1','186','940',419,'Retail Sale Id 1636371',3300.00,0.00,0.00,5.00,0.00,'2022-03-28 08:58:33','',''),(2644483,'1','186','940',419,'Retail Sale Id 1636372',6600.00,0.00,0.00,10.00,0.00,'2022-03-28 09:00:31','',''),(2644484,'1','186','940',419,'Retail Sale Id 1636373',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 09:01:59','',''),(2644485,'1','186','940',419,'Retail Sale Id 1636374',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 09:02:29','',''),(2644486,'1','186','940',419,'Retail Sale Id 1636375',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 09:03:27','',''),(2644487,'1','186','940',419,'Retail Sale Id 1636376',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 09:06:06','',''),(2644488,'1','186','940',419,'Retail Sale Id 1636377',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 09:06:59','',''),(2644489,'1','186','940',419,'Retail Sale Id 1636378',62000.00,0.00,0.00,100.00,-4000.00,'2022-03-28 09:08:20','',''),(2644490,'1','186','940',419,'Retail Sale Id 1636379',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 09:29:49','',''),(2644491,'1','186','940',419,'Retail Sale Id 1636380',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 18:10:51','',''),(2644492,'1','186','940',419,'Retail Sale Id 1636381',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 18:11:46','',''),(2644493,'1','186','940',419,'Retail Sale Id 1636382',3960.00,0.00,0.00,6.00,0.00,'2022-03-28 18:12:34','',''),(2644494,'1','186','940',419,'Retail Sale Id 1636383',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 18:13:38','',''),(2644495,'1','186','940',419,'Retail Sale Id 1636384',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 18:14:24','',''),(2644496,'1','186','940',419,'Retail Sale Id 1636385',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 18:15:07','',''),(2644497,'1','186','940',419,'Retail Sale Id 1636386',31000.00,0.00,0.00,50.00,-2000.00,'2022-03-28 18:16:10','',''),(2644498,'1','186','940',419,'Retail Sale Id 1636387',8250.00,0.00,0.00,12.50,0.00,'2022-03-28 18:22:32','',''),(2644499,'1','186','940',419,'Retail Sale Id 1636388',398376.00,0.00,0.00,603.60,0.00,'2022-03-28 21:27:39','',''),(2644500,'1','186','940',419,'Retail Sale Id 1636389',155000.00,0.00,0.00,250.00,-10000.00,'2022-03-28 21:29:50','',''),(2644501,'1','186','940',419,'Retail Sale Id 1636390',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:17:52','',''),(2644502,'1','186','940',419,'Retail Sale Id 1636391',9900.00,0.00,0.00,15.00,0.00,'2022-03-29 10:18:39','',''),(2644503,'1','186','940',419,'Retail Sale Id 1636392',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:22:22','',''),(2644504,'1','186','940',419,'Retail Sale Id 1636393',9900.00,0.00,0.00,15.00,0.00,'2022-03-29 10:24:10','',''),(2644505,'1','186','940',419,'Retail Sale Id 1636394',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:25:19','',''),(2644506,'1','186','940',419,'Retail Sale Id 1636395',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:27:16','',''),(2644507,'1','186','940',419,'Retail Sale Id 1636396',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:28:11','',''),(2644508,'1','186','940',419,'Retail Sale Id 1636397',3300.00,0.00,0.00,5.00,0.00,'2022-03-29 10:29:10','',''),(2644509,'1','186','940',419,'Retail Sale Id 1636398',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:30:18','',''),(2644510,'1','186','940',419,'Retail Sale Id 1636399',5940.00,0.00,0.00,9.00,0.00,'2022-03-29 10:31:41','',''),(2644511,'1','186','940',419,'Retail Sale Id 1636400',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:37:58','',''),(2644512,'1','186','940',419,'Retail Sale Id 1636401',12540.00,0.00,0.00,19.00,0.00,'2022-03-29 10:38:48','',''),(2644513,'1','186','940',419,'Retail Sale Id 1636402',4620.00,0.00,0.00,7.00,0.00,'2022-03-29 10:39:53','',''),(2644514,'1','186','940',419,'Retail Sale Id 1636403',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:40:32','',''),(2644515,'1','186','940',419,'Retail Sale Id 1636404',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:41:38','',''),(2644516,'1','186','940',419,'Retail Sale Id 1636405',8250.00,0.00,0.00,12.50,0.00,'2022-03-29 10:42:17','',''),(2644517,'1','186','940',419,'Retail Sale Id 1636406',31000.00,0.00,0.00,50.00,-2000.00,'2022-03-29 11:43:57','',''),(2644518,'1','186','940',419,'Retail Sale Id 1636407',337392.00,0.00,0.00,511.20,0.00,'2022-03-29 22:10:39','',''),(2644519,'1','186','940',419,'Retail Sale Id 1636408',248000.00,0.00,0.00,400.00,-16000.00,'2022-03-29 22:12:39','',''),(2644520,'1','186','940',419,'Retail Sale Id 1636409',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 07:57:43','',''),(2644521,'1','186','940',419,'Retail Sale Id 1636410',9900.00,0.00,0.00,15.00,0.00,'2022-03-30 07:58:20','',''),(2644522,'1','186','940',419,'Retail Sale Id 1636411',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 07:58:51','',''),(2644523,'1','186','940',419,'Retail Sale Id 1636412',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 07:59:25','',''),(2644524,'1','186','940',419,'Retail Sale Id 1636413',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 07:59:54','',''),(2644525,'1','186','940',419,'Retail Sale Id 1636414',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 08:00:31','',''),(2644526,'1','186','940',419,'Retail Sale Id 1636415',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 08:09:23','',''),(2644527,'1','186','940',419,'Retail Sale Id 1636416',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 08:09:56','',''),(2644528,'1','186','940',419,'Retail Sale Id 1636417',62000.00,0.00,0.00,100.00,-4000.00,'2022-03-30 08:11:12','',''),(2644529,'1','186','940',419,'Retail Sale Id 1636418',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 14:14:40','',''),(2644530,'1','186','940',419,'Retail Sale Id 1636419',8250.00,0.00,0.00,12.50,0.00,'2022-03-30 14:25:51','',''),(2644531,'1','186','940',419,'Retail Sale Id 1636420',257466.00,0.00,0.00,390.10,0.00,'2022-03-30 22:13:27','',''),(2644532,'1','186','940',419,'Retail Sale Id 1636421',217000.00,0.00,0.00,350.00,-14000.00,'2022-03-30 22:18:46','',''),(2644533,'1','186','940',419,'Retail Sale Id 1636422',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 07:45:01','',''),(2644534,'1','186','940',419,'Retail Sale Id 1636423',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 08:15:29','',''),(2644535,'1','186',NULL,419,'Reception corrector for bridging 132671',0.00,0.00,0.00,1960.00,0.00,'2022-03-31 08:20:59','',''),(2644536,'1','186','940',419,'Received from bridging 132671',0.00,0.00,1960.00,0.00,0.00,'2022-03-31 08:20:59','',''),(2644537,'1','186','940',419,'Retail Sale Id 1636424',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 08:21:40','',''),(2644538,'1','186','940',419,'Retail Sale Id 1636425',289000.00,0.00,0.00,500.00,-21000.00,'2022-03-31 08:22:28','',''),(2644539,'1','186','940',419,'Retail Sale Id 1636426',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 08:39:38','',''),(2644540,'1','186','940',419,'Retail Sale Id 1636427',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 08:42:13','',''),(2644541,'1','186','940',419,'Retail Sale Id 1636428',7750.00,0.00,0.00,12.50,0.00,'2022-03-31 10:34:30','',''),(2644542,'1','186','940',419,'Retail Sale Id 1636429',1295000.00,0.00,0.00,2500.00,-255000.00,'2022-03-31 10:36:09','',''),(2644543,'1','186','940',419,'Return of Retail Sale Id 1636429',0.00,1295000.00,2500.00,0.00,255000.00,'2022-03-31 22:40:05','',''),(2644544,'1','186','940',419,'Retail Sale Id 1636430',88660.00,0.00,0.00,143.00,0.00,'2022-03-31 22:43:43','',''),(2644545,'1','186','940',419,'Retail Sale Id 1636431',1574818.80,0.00,0.00,2724.60,-114433.20,'2022-03-31 22:46:36','',''),(2644546,'1','186','940',419,'Distributed to AARANO for sales id:349413',226920.00,0.00,0.00,366.00,0.00,'2022-03-31 22:55:06','',''),(2644547,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13988800.00,24980.00,0.00,0.00,'2022-03-31 22:58:38','',''),(2644548,'1','186',NULL,419,'Reception corrector for bridging 132673',0.00,0.00,0.00,23000.00,0.00,'2022-04-01 07:56:48','',''),(2644549,'1','186','940',419,'Received from bridging 132673',0.00,0.00,23000.00,0.00,0.00,'2022-04-01 07:56:48','',''),(2644550,'1','186','940',419,'Retail Sale Id 1636432',7750.00,0.00,0.00,12.50,750.00,'2022-04-01 07:58:04','',''),(2644551,'1','186','940',419,'Retail Sale Id 1636433',7750.00,0.00,0.00,12.50,750.00,'2022-04-01 07:58:39','',''),(2644552,'1','186','940',419,'Retail Sale Id 1636434',289000.00,0.00,0.00,500.00,9000.00,'2022-04-01 07:59:31','',''),(2644553,'1','186','940',419,'Retail Sale Id 1636435',28900.00,0.00,0.00,50.00,900.00,'2022-04-01 08:00:22','',''),(2644554,'1','186','940',419,'Retail Sale Id 1636436',7750.00,0.00,0.00,12.50,750.00,'2022-04-01 08:00:56','',''),(2644555,'1','186','940',419,'Retail Sale Id 1636437',9300.00,0.00,0.00,15.00,900.00,'2022-04-01 08:01:33','',''),(2644556,'1','186','940',419,'Retail Sale Id 1636438',3100.00,0.00,0.00,5.00,300.00,'2022-04-01 08:02:09','',''),(2644557,'1','186','940',419,'Retail Sale Id 1636439',1860.00,0.00,0.00,3.00,180.00,'2022-04-01 08:02:47','',''),(2644558,'1','186','940',419,'Retail Sale Id 1636440',7750.00,0.00,0.00,12.50,750.00,'2022-04-01 08:04:19','',''),(2644559,'1','186','940',419,'Retail Sale Id 1636441',7750.00,0.00,0.00,12.50,750.00,'2022-04-01 08:12:14','',''),(2644560,'1','186','940',419,'Retail Sale Id 1636442',7750.00,0.00,0.00,12.50,750.00,'2022-04-01 08:13:27','',''),(2644561,'1','186','940',419,'Retail Sale Id 1636443',567486.00,0.00,0.00,915.30,54918.00,'2022-04-01 22:40:39','',''),(2644562,'1','186','940',419,'Retail Sale Id 1636444',4046000.00,0.00,0.00,7000.00,126000.00,'2022-04-01 22:43:04','',''),(2644563,'1','186','940',419,'Retail Sale Id 1636445',1740000.00,0.00,0.00,3000.00,60000.00,'2022-04-01 22:44:27','',''),(2644564,'1','186','940',419,'Retail Sale Id 1636446',7750.00,0.00,0.00,12.50,750.00,'2022-04-02 07:42:57','',''),(2644565,'1','186','940',419,'Retail Sale Id 1636447',7750.00,0.00,0.00,12.50,750.00,'2022-04-02 07:43:47','',''),(2644566,'1','186','940',419,'Retail Sale Id 1636448',9300.00,0.00,0.00,15.00,900.00,'2022-04-02 07:45:00','',''),(2644567,'1','186','940',419,'Retail Sale Id 1636449',7750.00,0.00,0.00,12.50,750.00,'2022-04-02 07:46:22','',''),(2644568,'1','186','940',419,'Retail Sale Id 1636450',7750.00,0.00,0.00,12.50,750.00,'2022-04-02 07:48:22','',''),(2644569,'1','186','940',419,'Retail Sale Id 1636451',29000.00,0.00,0.00,50.00,1000.00,'2022-04-02 07:50:04','',''),(2644570,'1','186','940',419,'Retail Sale Id 1636452',58000.00,0.00,0.00,100.00,2000.00,'2022-04-02 07:50:52','',''),(2644571,'1','186','940',419,'Retail Sale Id 1636453',7750.00,0.00,0.00,12.50,750.00,'2022-04-02 08:25:13','',''),(2644572,'1','186',NULL,419,'Reception corrector for bridging 132674',0.00,0.00,0.00,1980.00,0.00,'2022-04-02 14:51:39','',''),(2644573,'1','186','940',419,'Received from bridging 132674',0.00,0.00,1980.00,0.00,0.00,'2022-04-02 14:51:39','',''),(2644574,'1','186','940',419,'Retail Sale Id 1636454',7253900.00,0.00,0.00,12550.00,225900.00,'2022-04-02 14:55:38','',''),(2644575,'1','186','940',419,'Return of Retail Sale Id 1636454',0.00,7253900.00,12550.00,0.00,-225900.00,'2022-04-02 14:57:13','',''),(2644576,'1','186','940',419,'Retail Sale Id 1636455',6647000.00,0.00,0.00,11500.00,207000.00,'2022-04-02 14:58:29','',''),(2644577,'1','186','940',419,'Retail Sale Id 1636456',580000.00,0.00,0.00,1000.00,20000.00,'2022-04-02 15:00:22','',''),(2644578,'1','186','940',419,'Retail Sale Id 1636457',199764.00,0.00,0.00,322.20,19332.00,'2022-04-02 15:01:40','',''),(2644579,'1','186','940',419,'Distributed to AARANO for sales id:349414',205520.00,0.00,0.00,367.00,0.00,'2022-04-05 11:56:50','',''),(2644580,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13865600.00,24760.00,0.00,0.00,'2022-04-05 11:59:41','',''),(2644581,'1','186',NULL,419,'Reception corrector for bridging 132675',0.00,0.00,0.00,23000.00,0.00,'2022-04-05 12:02:29','',''),(2644582,'1','186','940',419,'Received from bridging 132675',0.00,0.00,23000.00,0.00,0.00,'2022-04-05 12:02:29','',''),(2644583,'1','186','940',419,'Retail Sale Id 1636458',7750.00,0.00,0.00,12.50,750.00,'2022-04-05 12:05:39','',''),(2644584,'1','186','940',419,'Retail Sale Id 1636459',620.00,0.00,0.00,1.00,60.00,'2022-04-05 12:06:52','',''),(2644585,'1','186','940',419,'Retail Sale Id 1636460',7750.00,0.00,0.00,12.50,750.00,'2022-04-05 12:07:31','',''),(2644586,'1','186','940',419,'Retail Sale Id 1636461',29000.00,0.00,0.00,50.00,1000.00,'2022-04-05 12:08:36','',''),(2644587,'1','186','940',419,'Retail Sale Id 1636462',145000.00,0.00,0.00,250.00,5000.00,'2022-04-05 12:09:37','',''),(2644588,'1','186','940',419,'Retail Sale Id 1636463',29000.00,0.00,0.00,50.00,1000.00,'2022-04-05 12:11:22','',''),(2644589,'1','186','940',419,'Retail Sale Id 1636464',7750.00,0.00,0.00,12.50,750.00,'2022-04-05 12:12:35','',''),(2644590,'1','186','940',419,'Retail Sale Id 1636465',7750.00,0.00,0.00,12.50,750.00,'2022-04-05 12:14:05','',''),(2644591,'1','186','940',419,'Retail Sale Id 1636466',9300.00,0.00,0.00,15.00,900.00,'2022-04-05 12:16:12','',''),(2644592,'1','186','940',419,'Retail Sale Id 1636467',9300.00,0.00,0.00,15.00,900.00,'2022-04-05 12:17:58','',''),(2644593,'1','186','940',419,'Retail Sale Id 1636468',29000.00,0.00,0.00,50.00,1000.00,'2022-04-05 12:23:08','',''),(2644594,'1','186','940',419,'Retail Sale Id 1636469',7750.00,0.00,0.00,12.50,750.00,'2022-04-05 12:23:48','',''),(2644595,'1','186','940',419,'Retail Sale Id 1636470',268336.00,0.00,0.00,432.80,25968.00,'2022-04-05 21:55:40','',''),(2644596,'1','186','940',419,'Retail Sale Id 1636471',1740000.00,0.00,0.00,3000.00,60000.00,'2022-04-05 21:56:40','',''),(2644597,'1','186','940',419,'Retail Sale Id 1636472',7687400.00,0.00,0.00,13300.00,239400.00,'2022-04-05 21:59:48','',''),(2644598,'1','186','940',419,'Retail Sale Id 1636473',7750.00,0.00,0.00,12.50,750.00,'2022-04-06 08:19:48','',''),(2644599,'1','186','940',419,'Retail Sale Id 1636474',9300.00,0.00,0.00,15.00,900.00,'2022-04-06 08:21:01','',''),(2644600,'1','186','940',419,'Retail Sale Id 1636475',145000.00,0.00,0.00,250.00,5000.00,'2022-04-06 08:21:45','',''),(2644601,'1','186','940',419,'Retail Sale Id 1636476',29000.00,0.00,0.00,50.00,1000.00,'2022-04-06 08:22:59','',''),(2644602,'1','186','940',419,'Retail Sale Id 1636477',29000.00,0.00,0.00,50.00,1000.00,'2022-04-06 09:56:31','',''),(2644603,'1','186','940',419,'Retail Sale Id 1636478',190340.00,0.00,0.00,307.00,18420.00,'2022-04-06 22:26:36','',''),(2644604,'1','186','940',419,'Retail Sale Id 1636479',580000.00,0.00,0.00,1000.00,20000.00,'2022-04-06 22:28:13','',''),(2644605,'1','186','940',419,'Retail Sale Id 1636480',2312000.00,0.00,0.00,4000.00,72000.00,'2022-04-06 22:30:58','',''),(2644606,'1','186',NULL,419,'Reception corrector for bridging 132676',0.00,0.00,0.00,1760.00,0.00,'2022-04-07 08:06:05','',''),(2644607,'1','186','940',419,'Received from bridging 132676',0.00,0.00,1760.00,0.00,0.00,'2022-04-07 08:06:05','',''),(2644608,'1','186','940',419,'Retail Sale Id 1636481',578000.00,0.00,0.00,1000.00,18000.00,'2022-04-07 08:06:55','',''),(2644609,'1','186','940',419,'Retail Sale Id 1636482',7750.00,0.00,0.00,12.50,750.00,'2022-04-07 10:29:52','',''),(2644610,'1','186','940',419,'Retail Sale Id 1636483',7750.00,0.00,0.00,12.50,750.00,'2022-04-07 10:30:42','',''),(2644611,'1','186','940',419,'Retail Sale Id 1636484',7750.00,0.00,0.00,12.50,750.00,'2022-04-07 10:31:12','',''),(2644612,'1','186','940',419,'Retail Sale Id 1636485',9300.00,0.00,0.00,15.00,900.00,'2022-04-07 10:31:43','',''),(2644613,'1','186','940',419,'Retail Sale Id 1636486',9300.00,0.00,0.00,15.00,900.00,'2022-04-07 10:32:16','',''),(2644614,'1','186','940',419,'Retail Sale Id 1636487',29000.00,0.00,0.00,50.00,1000.00,'2022-04-07 10:32:56','',''),(2644615,'1','186','940',419,'Retail Sale Id 1636488',29000.00,0.00,0.00,50.00,1000.00,'2022-04-07 10:33:37','',''),(2644616,'1','186','940',419,'Retail Sale Id 1636489',87000.00,0.00,0.00,150.00,3000.00,'2022-04-07 21:59:07','',''),(2644617,'1','186','940',419,'Retail Sale Id 1636490',102734.00,0.00,0.00,165.70,9942.00,'2022-04-07 22:05:40','',''),(2644618,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349415',204960.00,0.00,0.00,366.00,0.00,'2022-04-07 22:14:28','',''),(2644619,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13988800.00,24980.00,0.00,0.00,'2022-04-07 22:18:32','',''),(2644620,'1','186',NULL,419,'Reception corrector for bridging 132677',0.00,0.00,0.00,23000.00,0.00,'2022-04-07 22:21:47','',''),(2644621,'1','186','940',419,'Received from bridging 132677',0.00,0.00,23000.00,0.00,0.00,'2022-04-07 22:21:47','',''),(2644622,'1','186','940',419,'Retail Sale Id 1636491',107692.96,0.00,0.00,186.32,3353.76,'2022-04-08 08:29:55','',''),(2644623,'1','186','940',419,'Return of Retail Sale Id 1636491',0.00,107692.96,186.32,0.00,-3353.76,'2022-04-08 08:32:13','',''),(2644624,'1','186','940',419,'Retail Sale Id 1636492',1076409.40,0.00,0.00,1862.30,33521.40,'2022-04-08 08:33:18','',''),(2644625,'1','186','940',419,'Retail Sale Id 1636493',3100.00,0.00,0.00,5.00,300.00,'2022-04-08 08:40:18','',''),(2644626,'1','186','940',419,'Retail Sale Id 1636494',9300.00,0.00,0.00,15.00,900.00,'2022-04-08 08:41:02','',''),(2644627,'1','186','940',419,'Retail Sale Id 1636495',7750.00,0.00,0.00,12.50,750.00,'2022-04-08 08:41:43','',''),(2644628,'1','186','940',419,'Retail Sale Id 1636496',29000.00,0.00,0.00,50.00,1000.00,'2022-04-08 08:42:49','',''),(2644629,'1','186','940',419,'Retail Sale Id 1636497',7750.00,0.00,0.00,12.50,750.00,'2022-04-08 08:56:51','',''),(2644630,'1','186','940',419,'Retail Sale Id 1636498',116000.00,0.00,0.00,200.00,4000.00,'2022-04-08 09:08:05','',''),(2644631,'1','186','940',419,'Retail Sale Id 1636499',1160000.00,0.00,0.00,2000.00,40000.00,'2022-04-08 20:49:17','',''),(2644632,'1','186','940',419,'Retail Sale Id 1636500',1445000.00,0.00,0.00,2500.00,45000.00,'2022-04-08 20:53:02','',''),(2644633,'1','186','940',419,'Retail Sale Id 1636501',7750.00,0.00,0.00,12.50,750.00,'2022-04-08 20:53:35','',''),(2644634,'1','186','940',419,'Retail Sale Id 1636502',290000.00,0.00,0.00,500.00,10000.00,'2022-04-08 20:55:42','',''),(2644635,'1','186','940',419,'Retail Sale Id 1636503',4046000.00,0.00,0.00,7000.00,126000.00,'2022-04-08 22:29:40','',''),(2644636,'1','186','940',419,'Retail Sale Id 1636504',870000.00,0.00,0.00,1500.00,30000.00,'2022-04-08 22:31:30','',''),(2644637,'1','186','940',419,'Retail Sale Id 1636505',2312000.00,0.00,0.00,4000.00,72000.00,'2022-04-08 22:34:39','',''),(2644638,'1','186','940',419,'Retail Sale Id 1636506',382540.00,0.00,0.00,617.00,37020.00,'2022-04-08 22:44:39','',''),(2644639,'1','186',NULL,419,'Reception corrector for bridging 132678',0.00,0.00,0.00,1980.00,0.00,'2022-04-09 15:02:59','',''),(2644640,'1','186','940',419,'Received from bridging 132678',0.00,0.00,1980.00,0.00,0.00,'2022-04-09 15:02:59','',''),(2644641,'1','186','940',419,'Retail Sale Id 1636507',7750.00,0.00,0.00,12.50,750.00,'2022-04-09 15:04:22','',''),(2644642,'1','186','940',419,'Retail Sale Id 1636508',9300.00,0.00,0.00,15.00,900.00,'2022-04-09 15:06:32','',''),(2644643,'1','186','940',419,'Retail Sale Id 1636509',9300.00,0.00,0.00,15.00,900.00,'2022-04-09 15:07:37','',''),(2644644,'1','186','940',419,'Retail Sale Id 1636510',9300.00,0.00,0.00,15.00,900.00,'2022-04-09 15:08:09','',''),(2644645,'1','186','940',419,'Retail Sale Id 1636511',290000.00,0.00,0.00,500.00,10000.00,'2022-04-09 15:09:01','',''),(2644646,'1','186','940',419,'Retail Sale Id 1636512',3720.00,0.00,0.00,6.00,360.00,'2022-04-09 15:10:10','',''),(2644647,'1','186','940',419,'Retail Sale Id 1636513',58000.00,0.00,0.00,100.00,2000.00,'2022-04-09 15:11:11','',''),(2644648,'1','186','940',419,'Retail Sale Id 1636514',7750.00,0.00,0.00,12.50,750.00,'2022-04-09 15:12:18','',''),(2644649,'1','186','940',419,'Retail Sale Id 1636515',1445000.00,0.00,0.00,2500.00,45000.00,'2022-04-09 17:59:44','',''),(2644650,'1','186','940',419,'Retail Sale Id 1636516',7750.00,0.00,0.00,12.50,750.00,'2022-04-09 18:00:57','',''),(2644651,'1','186','940',419,'Retail Sale Id 1636517',9300.00,0.00,0.00,15.00,900.00,'2022-04-09 18:01:48','',''),(2644652,'1','186','940',419,'Retail Sale Id 1636518',7750.00,0.00,0.00,12.50,750.00,'2022-04-09 18:02:57','',''),(2644653,'1','186','940',419,'Retail Sale Id 1636519',7750.00,0.00,0.00,12.50,750.00,'2022-04-09 18:04:04','',''),(2644654,'1','186','940',419,'Retail Sale Id 1636520',149698.00,0.00,0.00,258.10,5162.00,'2022-04-09 18:06:11','',''),(2644655,'1','186','940',419,'Retail Sale Id 1636521',289000.00,0.00,0.00,500.00,9000.00,'2022-04-11 18:44:36','',''),(2644656,'1','186','940',419,'Distributed to AARANO for sales id:349417',395696.00,0.00,0.00,706.60,0.00,'2022-04-12 07:45:00','',''),(2644657,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13882400.00,24790.00,0.00,0.00,'2022-04-12 07:56:44','',''),(2644658,'1','186',NULL,419,'Reception corrector for bridging 132679',0.00,0.00,0.00,23000.00,0.00,'2022-04-12 07:58:59','',''),(2644659,'1','186','940',419,'Received from bridging 132679',0.00,0.00,23000.00,0.00,0.00,'2022-04-12 07:58:59','',''),(2644660,'1','186','940',419,'Retail Sale Id 1636522',802957.60,0.00,0.00,1389.20,25005.60,'2022-04-12 07:59:22','',''),(2644661,'1','186','940',419,'Return of Retail Sale Id 1636522',0.00,802957.60,1389.20,0.00,-25005.60,'2022-04-12 08:01:14','',''),(2644662,'1','186','940',419,'Retail Sale Id 1636523',803009.62,0.00,0.00,1389.29,25007.22,'2022-04-12 08:07:21','',''),(2644663,'1','186','940',419,'Retail Sale Id 1636524',449500.00,0.00,0.00,725.00,43500.00,'2022-04-12 08:34:02','',''),(2644664,'1','186','940',419,'Return of Retail Sale Id 1636524',0.00,449500.00,725.00,0.00,-43500.00,'2022-04-12 08:34:59','',''),(2644665,'1','186','940',419,'Retail Sale Id 1636525',448570.00,0.00,0.00,723.50,43410.00,'2022-04-12 08:35:52','',''),(2644666,'1','186','940',419,'Retail Sale Id 1636526',2307240.00,0.00,0.00,3978.00,79560.00,'2022-04-12 08:37:04','',''),(2644667,'1','186','940',419,'Retail Sale Id 1636527',7716300.00,0.00,0.00,13350.00,240300.00,'2022-04-12 08:38:03','',''),(2644668,'1','186','940',419,'Retail Sale Id 1636528',7750.00,0.00,0.00,12.50,750.00,'2022-04-12 08:43:30','',''),(2644669,'1','186','940',419,'Retail Sale Id 1636529',7750.00,0.00,0.00,12.50,750.00,'2022-04-12 08:44:04','',''),(2644670,'1','186','940',419,'Retail Sale Id 1636530',9300.00,0.00,0.00,15.00,900.00,'2022-04-12 08:44:40','',''),(2644671,'1','186','940',419,'Retail Sale Id 1636531',29000.00,0.00,0.00,50.00,1000.00,'2022-04-12 08:45:28','',''),(2644672,'1','186','940',419,'Retail Sale Id 1636532',29000.00,0.00,0.00,50.00,1000.00,'2022-04-12 08:46:17','',''),(2644673,'1','186','940',419,'Retail Sale Id 1636533',116000.00,0.00,0.00,200.00,4000.00,'2022-04-12 08:47:25','',''),(2644674,'1','186',NULL,419,'Reception corrector for bridging 132680',0.00,0.00,0.00,1790.00,0.00,'2022-04-12 08:49:30','',''),(2644675,'1','186','940',419,'Received from bridging 132680',0.00,0.00,1790.00,0.00,0.00,'2022-04-12 08:49:30','',''),(2644676,'1','186','940',419,'Retail Sale Id 1636534',1156000.00,0.00,0.00,2000.00,36000.00,'2022-04-12 12:56:56','',''),(2644677,'1','186','940',419,'Retail Sale Id 1636535',754000.00,0.00,0.00,1300.00,26000.00,'2022-04-12 22:11:00','',''),(2644678,'1','186','940',419,'Retail Sale Id 1636536',127100.00,0.00,0.00,205.00,12300.00,'2022-04-12 22:14:55','',''),(2644679,'1','186','940',419,'Retail Sale Id 1636537',656729.38,0.00,0.00,1136.21,20451.78,'2022-04-12 22:19:46','',''),(2644680,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349418',206080.00,0.00,0.00,368.00,0.00,'2022-04-13 20:12:06','',''),(2644681,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14011200.00,25020.00,0.00,0.00,'2022-04-13 20:16:36','',''),(2644682,'1','186',NULL,419,'Reception corrector for bridging 132681',0.00,0.00,0.00,23000.00,0.00,'2022-04-13 20:19:17','',''),(2644683,'1','186','940',419,'Received from bridging 132681',0.00,0.00,23000.00,0.00,0.00,'2022-04-13 20:19:17','',''),(2644684,'1','186','940',419,'Retail Sale Id 1636538',205617.72,0.00,0.00,355.74,6403.32,'2022-04-13 20:30:02','',''),(2644685,'1','186','940',419,'Retail Sale Id 1636539',7750.00,0.00,0.00,12.50,750.00,'2022-04-14 08:16:28','',''),(2644686,'1','186','940',419,'Retail Sale Id 1636540',7750.00,0.00,0.00,12.50,750.00,'2022-04-14 08:17:34','',''),(2644687,'1','186','940',419,'Retail Sale Id 1636541',29000.00,0.00,0.00,50.00,1000.00,'2022-04-14 08:18:37','',''),(2644688,'1','186','940',419,'Retail Sale Id 1636542',7750.00,0.00,0.00,12.50,750.00,'2022-04-14 08:32:56','',''),(2644689,'1','186','940',419,'Retail Sale Id 1636543',87000.00,0.00,0.00,150.00,3000.00,'2022-04-14 08:36:56','',''),(2644690,'1','186','940',419,'Retail Sale Id 1636544',7750.00,0.00,0.00,12.50,750.00,'2022-04-14 08:43:41','',''),(2644691,'1','186','940',419,'Retail Sale Id 1636545',290000.00,0.00,0.00,500.00,10000.00,'2022-04-14 08:47:26','',''),(2644692,'1','186','940',419,'Retail Sale Id 1636546',7750.00,0.00,0.00,12.50,750.00,'2022-04-14 08:51:11','',''),(2644693,'1','186','940',419,'Retail Sale Id 1636548',7750.00,0.00,0.00,12.50,750.00,'2022-04-14 08:51:55','',''),(2644694,'1','186','940',419,'Retail Sale Id 1636549',1856000.00,0.00,0.00,3200.00,64000.00,'2022-04-14 22:31:54','',''),(2644695,'1','186','940',419,'Retail Sale Id 1636550',415400.00,0.00,0.00,670.00,40200.00,'2022-04-14 22:33:17','',''),(2644696,'1','186','940',419,'Retail Sale Id 1636551',7745200.00,0.00,0.00,13400.00,241200.00,'2022-04-14 22:36:03','',''),(2644697,'1','186','940',419,'Retail Sale Id 1636552',3720.00,0.00,0.00,6.00,360.00,'2022-04-15 08:44:03','',''),(2644698,'1','186','940',419,'Retail Sale Id 1636553',7750.00,0.00,0.00,12.50,750.00,'2022-04-15 08:44:51','',''),(2644699,'1','186','940',419,'Retail Sale Id 1636554',9300.00,0.00,0.00,15.00,900.00,'2022-04-15 08:45:42','',''),(2644700,'1','186','940',419,'Retail Sale Id 1636555',7750.00,0.00,0.00,12.50,750.00,'2022-04-15 08:47:52','',''),(2644701,'1','186','940',419,'Retail Sale Id 1636556',7750.00,0.00,0.00,12.50,750.00,'2022-04-15 08:49:14','',''),(2644702,'1','186','940',419,'Retail Sale Id 1636557',7750.00,0.00,0.00,12.50,750.00,'2022-04-15 08:49:59','',''),(2644703,'1','186','940',419,'Retail Sale Id 1636558',87000.00,0.00,0.00,150.00,3000.00,'2022-04-15 08:51:06','',''),(2644704,'1','186','940',419,'Retail Sale Id 1636559',290000.00,0.00,0.00,500.00,10000.00,'2022-04-15 08:51:55','',''),(2644705,'1','186','940',419,'Retail Sale Id 1636560',290000.00,0.00,0.00,500.00,10000.00,'2022-04-15 10:17:46','',''),(2644706,'1','186',NULL,419,'Reception corrector for bridging 132682',0.00,0.00,0.00,2020.00,0.00,'2022-04-15 20:28:46','',''),(2644707,'1','186','940',419,'Received from bridging 132682',0.00,0.00,2020.00,0.00,0.00,'2022-04-15 20:28:46','',''),(2644708,'1','186','940',419,'Retail Sale Id 1636561',2601000.00,0.00,0.00,4500.00,81000.00,'2022-04-15 21:27:57','',''),(2644709,'1','186','940',419,'Retail Sale Id 1636562',124000.00,0.00,0.00,200.00,12000.00,'2022-04-15 21:36:44','',''),(2644710,'1','186','940',419,'Retail Sale Id 1636563',182012.20,0.00,0.00,314.90,5668.20,'2022-04-15 21:38:58','',''),(2644711,'1','186','940',419,'Distributed to AARANO for sales id:349419',214681.60,0.00,0.00,383.36,0.00,'2022-04-16 11:58:59','',''),(2644712,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14028000.00,25050.00,0.00,0.00,'2022-04-16 14:05:19','',''),(2644713,'1','186',NULL,419,'Reception corrector for bridging 132683',0.00,0.00,0.00,23000.00,0.00,'2022-04-16 14:07:40','',''),(2644714,'1','186','940',419,'Received from bridging 132683',0.00,0.00,23000.00,0.00,0.00,'2022-04-16 14:07:40','',''),(2644715,'1','186','940',419,'Retail Sale Id 1636564',7750.00,0.00,0.00,12.50,750.00,'2022-04-16 14:10:41','',''),(2644716,'1','186','940',419,'Retail Sale Id 1636565',7750.00,0.00,0.00,12.50,750.00,'2022-04-16 14:11:37','',''),(2644717,'1','186','940',419,'Retail Sale Id 1636566',7750.00,0.00,0.00,12.50,750.00,'2022-04-16 14:12:41','',''),(2644718,'1','186','940',419,'Retail Sale Id 1636567',290000.00,0.00,0.00,500.00,10000.00,'2022-04-16 14:15:33','',''),(2644719,'1','186','940',419,'Retail Sale Id 1636568',29000.00,0.00,0.00,50.00,1000.00,'2022-04-16 14:16:27','',''),(2644720,'1','186','940',419,'Retail Sale Id 1636569',167400.00,0.00,0.00,270.00,16200.00,'2022-04-16 23:06:14','',''),(2644721,'1','186','940',419,'Retail Sale Id 1636570',1156000.00,0.00,0.00,2000.00,36000.00,'2022-04-16 23:09:12','',''),(2644722,'1','186','940',419,'Retail Sale Id 1636571',29000.00,0.00,0.00,50.00,1000.00,'2022-04-17 08:13:18','',''),(2644723,'1','186','940',419,'Retail Sale Id 1636572',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:11:25','',''),(2644724,'1','186','940',419,'Retail Sale Id 1636573',9300.00,0.00,0.00,15.00,900.00,'2022-04-17 10:15:16','',''),(2644725,'1','186','940',419,'Retail Sale Id 1636574',290000.00,0.00,0.00,500.00,10000.00,'2022-04-17 10:16:28','',''),(2644726,'1','186','940',419,'Retail Sale Id 1636575',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:17:52','',''),(2644727,'1','186','940',419,'Retail Sale Id 1636576',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:18:52','',''),(2644728,'1','186','940',419,'Retail Sale Id 1636577',29000.00,0.00,0.00,50.00,1000.00,'2022-04-17 10:24:38','',''),(2644729,'1','186','940',419,'Retail Sale Id 1636578',290000.00,0.00,0.00,500.00,10000.00,'2022-04-17 10:26:49','',''),(2644730,'1','186','940',419,'Retail Sale Id 1636579',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:30:20','',''),(2644731,'1','186','940',419,'Retail Sale Id 1636580',9300.00,0.00,0.00,15.00,900.00,'2022-04-17 10:33:55','',''),(2644732,'1','186','940',419,'Retail Sale Id 1636581',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:37:17','',''),(2644733,'1','186','940',419,'Retail Sale Id 1636582',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:38:19','',''),(2644734,'1','186','940',419,'Retail Sale Id 1636583',7750.00,0.00,0.00,12.50,750.00,'2022-04-17 10:40:07','',''),(2644735,'1','186','940',419,'Retail Sale Id 1636584',9300.00,0.00,0.00,15.00,900.00,'2022-04-17 10:41:36','',''),(2644736,'1','186','940',419,'Retail Sale Id 1636585',29000.00,0.00,0.00,50.00,1000.00,'2022-04-17 10:44:33','',''),(2644737,'1','186','940',419,'Retail Sale Id 1636586',361770.00,0.00,0.00,583.50,35010.00,'2022-04-17 21:57:13','',''),(2644738,'1','186','940',419,'Retail Sale Id 1636587',580000.00,0.00,0.00,1000.00,20000.00,'2022-04-17 21:58:51','',''),(2644739,'1','186','940',419,'Retail Sale Id 1636588',7831900.00,0.00,0.00,13550.00,243900.00,'2022-04-17 22:01:25','',''),(2644740,'1','186','940',419,'Retail Sale Id 1636589',289000.00,0.00,0.00,500.00,9000.00,'2022-04-17 22:04:42','',''),(2644741,'1','186','940',419,'Retail Sale Id 1636590',7750.00,0.00,0.00,12.50,750.00,'2022-04-18 08:27:01','',''),(2644742,'1','186','940',419,'Retail Sale Id 1636591',7750.00,0.00,0.00,12.50,750.00,'2022-04-18 08:27:52','',''),(2644743,'1','186','940',419,'Retail Sale Id 1636592',3720.00,0.00,0.00,6.00,360.00,'2022-04-18 08:28:50','',''),(2644744,'1','186','940',419,'Retail Sale Id 1636593',3100.00,0.00,0.00,5.00,300.00,'2022-04-18 08:29:25','',''),(2644745,'1','186','940',419,'Retail Sale Id 1636594',1860.00,0.00,0.00,3.00,180.00,'2022-04-18 08:30:15','',''),(2644746,'1','186','940',419,'Retail Sale Id 1636595',3720.00,0.00,0.00,6.00,360.00,'2022-04-18 08:31:12','',''),(2644747,'1','186','940',419,'Retail Sale Id 1636596',3100.00,0.00,0.00,5.00,300.00,'2022-04-18 08:32:01','',''),(2644748,'1','186','940',419,'Retail Sale Id 1636597',29000.00,0.00,0.00,50.00,1000.00,'2022-04-18 08:32:46','',''),(2644749,'1','186','940',419,'Retail Sale Id 1636598',58000.00,0.00,0.00,100.00,2000.00,'2022-04-18 08:33:41','',''),(2644750,'1','186','940',419,'Retail Sale Id 1636599',290000.00,0.00,0.00,500.00,10000.00,'2022-04-18 08:35:14','',''),(2644751,'1','186',NULL,419,'Reception corrector for bridging 132684',0.00,0.00,0.00,2050.00,0.00,'2022-04-18 08:38:06','',''),(2644752,'1','186','940',419,'Received from bridging 132684',0.00,0.00,2050.00,0.00,0.00,'2022-04-18 08:38:06','',''),(2644753,'1','186','940',419,'Retail Sale Id 1636600',1994100.00,0.00,0.00,3450.00,62100.00,'2022-04-18 22:08:14','',''),(2644754,'1','186','940',419,'Retail Sale Id 1636601',348000.00,0.00,0.00,600.00,12000.00,'2022-04-18 22:10:30','',''),(2644755,'1','186','940',419,'Retail Sale Id 1636602',97650.00,0.00,0.00,157.50,9450.00,'2022-04-18 22:12:41','',''),(2644756,'1','186','940',419,'Distributed to AARANO for sales id:349420',206640.00,0.00,0.00,369.00,0.00,'2022-04-19 19:39:58','',''),(2644757,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13921600.00,24860.00,0.00,0.00,'2022-04-19 19:45:34','',''),(2644758,'1','186',NULL,419,'Reception corrector for bridging 132685',0.00,0.00,0.00,23000.00,0.00,'2022-04-19 20:40:22','',''),(2644759,'1','186','940',419,'Received from bridging 132685',0.00,0.00,23000.00,0.00,0.00,'2022-04-19 20:40:22','',''),(2644760,'1','186','940',419,'Retail Sale Id 1636603',389829.60,0.00,0.00,672.12,13442.40,'2022-04-19 20:41:03','',''),(2644761,'1','186','940',419,'Retail Sale Id 1636604',83669.00,0.00,0.00,134.95,8097.00,'2022-04-19 20:42:20','',''),(2644762,'1','186','940',419,'Retail Sale Id 1636605',7750.00,0.00,0.00,12.50,750.00,'2022-04-20 08:17:14','',''),(2644763,'1','186','940',419,'Retail Sale Id 1636606',7750.00,0.00,0.00,12.50,750.00,'2022-04-20 08:18:46','',''),(2644764,'1','186','940',419,'Retail Sale Id 1636607',290000.00,0.00,0.00,500.00,10000.00,'2022-04-20 08:19:41','',''),(2644765,'1','186','940',419,'Retail Sale Id 1636608',7750.00,0.00,0.00,12.50,750.00,'2022-04-20 09:04:05','',''),(2644766,'1','186','940',419,'Retail Sale Id 1636609',7750.00,0.00,0.00,12.50,750.00,'2022-04-20 09:14:20','',''),(2644767,'1','186','940',419,'Retail Sale Id 1636610',29000.00,0.00,0.00,50.00,1000.00,'2022-04-20 09:15:11','',''),(2644768,'1','186','940',419,'Retail Sale Id 1636611',7750.00,0.00,0.00,12.50,750.00,'2022-04-20 09:15:44','',''),(2644769,'1','186','940',419,'Retail Sale Id 1636612',7750.00,0.00,0.00,12.50,750.00,'2022-04-20 09:16:15','',''),(2644770,'1','186','940',419,'Retail Sale Id 1636613',29000.00,0.00,0.00,50.00,1000.00,'2022-04-20 09:17:09','',''),(2644771,'1','186','940',419,'Retail Sale Id 1636614',399714.00,0.00,0.00,644.70,38682.00,'2022-04-20 21:30:51','',''),(2644772,'1','186','940',419,'Retail Sale Id 1636615',1595000.00,0.00,0.00,2750.00,55000.00,'2022-04-20 21:32:53','',''),(2644773,'1','186','940',419,'Retail Sale Id 1636616',4251190.00,0.00,0.00,7355.00,132390.00,'2022-04-20 21:34:10','',''),(2644774,'1','186','940',419,'Retail Sale Id 1636617',7750.00,0.00,0.00,12.50,750.00,'2022-04-21 09:47:38','',''),(2644775,'1','186','940',419,'Retail Sale Id 1636618',7750.00,0.00,0.00,12.50,750.00,'2022-04-21 09:48:34','',''),(2644776,'1','186','940',419,'Retail Sale Id 1636619',7750.00,0.00,0.00,12.50,750.00,'2022-04-21 09:50:56','',''),(2644777,'1','186','940',419,'Retail Sale Id 1636620',290000.00,0.00,0.00,500.00,10000.00,'2022-04-21 09:51:51','',''),(2644778,'1','186','940',419,'Retail Sale Id 1636621',29000.00,0.00,0.00,50.00,1000.00,'2022-04-21 09:54:53','',''),(2644779,'1','186','940',419,'Retail Sale Id 1636622',7750.00,0.00,0.00,12.50,750.00,'2022-04-21 09:55:30','',''),(2644780,'1','186','940',419,'Retail Sale Id 1636623',1798000.00,0.00,0.00,3100.00,62000.00,'2022-04-21 20:10:43','',''),(2644781,'1','186','940',419,'Retail Sale Id 1636624',439332.00,0.00,0.00,708.60,42516.00,'2022-04-21 20:12:47','',''),(2644782,'1','186',NULL,419,'Reception corrector for bridging 132686',0.00,0.00,0.00,1860.00,0.00,'2022-04-21 20:14:58','',''),(2644783,'1','186','940',419,'Received from bridging 132686',0.00,0.00,1860.00,0.00,0.00,'2022-04-21 20:14:58','',''),(2644784,'1','186','940',419,'Retail Sale Id 1636625',3785900.00,0.00,0.00,6550.00,117900.00,'2022-04-21 20:17:29','',''),(2644785,'1','186','940',419,'Retail Sale Id 1636626',7750.00,0.00,0.00,12.50,750.00,'2022-04-22 10:24:39','',''),(2644786,'1','186','940',419,'Retail Sale Id 1636627',9300.00,0.00,0.00,15.00,900.00,'2022-04-22 10:34:45','',''),(2644787,'1','186','940',419,'Retail Sale Id 1636628',289000.00,0.00,0.00,500.00,9000.00,'2022-04-22 10:36:01','',''),(2644788,'1','186','940',419,'Retail Sale Id 1636629',28900.00,0.00,0.00,50.00,900.00,'2022-04-22 11:11:26','',''),(2644789,'1','186','940',419,'Retail Sale Id 1636630',62000.00,0.00,0.00,100.00,6000.00,'2022-04-22 19:34:11','',''),(2644790,'1','186','940',419,'Retail Sale Id 1636631',231200.00,0.00,0.00,400.00,7200.00,'2022-04-22 19:35:24','',''),(2644791,'1','186','940',419,'Retail Sale Id 1636632',129995.40,0.00,0.00,224.13,4482.60,'2022-04-22 19:37:41','',''),(2644792,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349421',206080.00,0.00,0.00,368.00,0.00,'2022-04-23 20:34:18','',''),(2644793,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14033600.00,25060.00,0.00,0.00,'2022-04-23 20:37:22','',''),(2644794,'1','186',NULL,419,'Reception corrector for bridging 132687',0.00,0.00,0.00,23000.00,0.00,'2022-04-23 20:38:51','',''),(2644795,'1','186','940',419,'Received from bridging 132687',0.00,0.00,23000.00,0.00,0.00,'2022-04-23 20:38:51','',''),(2644796,'1','186','940',419,'Retail Sale Id 1636633',664700.00,0.00,0.00,1150.00,20700.00,'2022-04-23 20:45:28','',''),(2644797,'1','186','940',419,'Retail Sale Id 1636634',388600.00,0.00,0.00,670.00,13400.00,'2022-04-23 20:47:22','',''),(2644798,'1','186','940',419,'Retail Sale Id 1636635',209250.00,0.00,0.00,337.50,20250.00,'2022-04-23 20:48:59','',''),(2644799,'1','186','940',419,'Retail Sale Id 1636636',144500.00,0.00,0.00,250.00,4500.00,'2022-04-23 23:17:26','',''),(2644800,'1','186','940',419,'Retail Sale Id 1636637',7750.00,0.00,0.00,12.50,750.00,'2022-04-24 08:27:50','',''),(2644801,'1','186','940',419,'Retail Sale Id 1636638',87000.00,0.00,0.00,150.00,3000.00,'2022-04-24 08:28:44','',''),(2644802,'1','186','940',419,'Retail Sale Id 1636639',3720.00,0.00,0.00,6.00,360.00,'2022-04-24 08:29:20','',''),(2644803,'1','186','940',419,'Retail Sale Id 1636640',7750.00,0.00,0.00,12.50,750.00,'2022-04-24 08:30:33','',''),(2644804,'1','186','940',419,'Retail Sale Id 1636641',7750.00,0.00,0.00,12.50,750.00,'2022-04-24 08:31:16','',''),(2644805,'1','186','940',419,'Retail Sale Id 1636642',7750.00,0.00,0.00,12.50,750.00,'2022-04-24 08:32:22','',''),(2644806,'1','186','940',419,'Retail Sale Id 1636643',7750.00,0.00,0.00,12.50,750.00,'2022-04-24 08:32:55','',''),(2644807,'1','186','940',419,'Retail Sale Id 1636644',29000.00,0.00,0.00,50.00,1000.00,'2022-04-24 08:35:29','',''),(2644808,'1','186','940',419,'Retail Sale Id 1636645',2146000.00,0.00,0.00,3700.00,74000.00,'2022-04-24 21:07:52','',''),(2644809,'1','186','940',419,'Retail Sale Id 1636646',434000.00,0.00,0.00,700.00,42000.00,'2022-04-24 21:09:56','',''),(2644810,'1','186','940',419,'Retail Sale Id 1636647',8467700.00,0.00,0.00,14650.00,263700.00,'2022-04-24 21:11:50','',''),(2644811,'1','186','940',419,'Retail Sale Id 1636648',7750.00,0.00,0.00,12.50,750.00,'2022-04-25 08:02:29','',''),(2644812,'1','186','940',419,'Retail Sale Id 1636649',4960.00,0.00,0.00,8.00,480.00,'2022-04-25 08:35:15','',''),(2644813,'1','186','940',419,'Retail Sale Id 1636650',7750.00,0.00,0.00,12.50,750.00,'2022-04-25 08:35:51','',''),(2644814,'1','186','940',419,'Retail Sale Id 1636651',7750.00,0.00,0.00,12.50,750.00,'2022-04-25 08:37:08','',''),(2644815,'1','186','940',419,'Retail Sale Id 1636652',7750.00,0.00,0.00,12.50,750.00,'2022-04-25 08:38:29','',''),(2644816,'1','186','940',419,'Retail Sale Id 1636653',7750.00,0.00,0.00,12.50,750.00,'2022-04-25 08:39:43','',''),(2644817,'1','186','940',419,'Retail Sale Id 1636654',9300.00,0.00,0.00,15.00,900.00,'2022-04-25 08:40:19','',''),(2644818,'1','186','940',419,'Retail Sale Id 1636655',29000.00,0.00,0.00,50.00,1000.00,'2022-04-25 08:41:15','',''),(2644819,'1','186','940',419,'Retail Sale Id 1636656',58000.00,0.00,0.00,100.00,2000.00,'2022-04-25 08:42:13','',''),(2644820,'1','186','940',419,'Retail Sale Id 1636657',290000.00,0.00,0.00,500.00,10000.00,'2022-04-25 08:43:15','',''),(2644821,'1','186','940',419,'Retail Sale Id 1636658',9300.00,0.00,0.00,15.00,900.00,'2022-04-25 08:50:23','',''),(2644822,'1','186',NULL,419,'Reception corrector for bridging 132688',0.00,0.00,0.00,2060.00,0.00,'2022-04-25 22:30:50','',''),(2644823,'1','186','940',419,'Received from bridging 132688',0.00,0.00,2060.00,0.00,0.00,'2022-04-25 22:30:50','',''),(2644824,'1','186','940',419,'Retail Sale Id 1636659',310000.00,0.00,0.00,500.00,30000.00,'2022-04-25 22:33:48','',''),(2644825,'1','186','940',419,'Retail Sale Id 1636660',992715.00,0.00,0.00,1717.50,30915.00,'2022-04-25 22:36:29','',''),(2644826,'1','186','940',419,'Distributed to AARANO for sales id:349422',204960.00,0.00,0.00,366.00,0.00,'2022-04-26 08:50:20','',''),(2644827,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,10746400.00,19190.00,0.00,0.00,'2022-04-26 08:58:43','',''),(2644828,'1','186',NULL,419,'Reception corrector for bridging 132689',0.00,0.00,0.00,19190.00,0.00,'2022-04-26 09:01:26','',''),(2644829,'1','186','940',419,'Received from bridging 132689',0.00,0.00,19190.00,0.00,0.00,'2022-04-26 09:01:26','',''),(2644830,'1','186','940',419,'Retail Sale Id 1636661',7750.00,0.00,0.00,12.50,750.00,'2022-04-26 09:03:54','',''),(2644831,'1','186','940',419,'Retail Sale Id 1636662',29000.00,0.00,0.00,50.00,1000.00,'2022-04-26 09:05:02','',''),(2644832,'1','186','940',419,'Retail Sale Id 1636663',87000.00,0.00,0.00,150.00,3000.00,'2022-04-26 09:05:57','',''),(2644833,'1','186','940',419,'Retail Sale Id 1636664',116000.00,0.00,0.00,200.00,4000.00,'2022-04-26 09:06:49','',''),(2644834,'1','186','940',419,'Retail Sale Id 1636665',4960.00,0.00,0.00,8.00,480.00,'2022-04-26 09:07:25','',''),(2644835,'1','186','940',419,'Retail Sale Id 1636666',7750.00,0.00,0.00,12.50,750.00,'2022-04-26 09:07:55','',''),(2644836,'1','186','940',419,'Retail Sale Id 1636667',7750.00,0.00,0.00,12.50,750.00,'2022-04-26 09:08:25','',''),(2644837,'1','186','940',419,'Retail Sale Id 1636668',1856000.00,0.00,0.00,3200.00,64000.00,'2022-04-26 20:04:48','',''),(2644838,'1','186','940',419,'Retail Sale Id 1636669',6510014.00,0.00,0.00,11263.00,202734.00,'2022-04-26 20:11:43','',''),(2644839,'1','186','940',419,'Retail Sale Id 1636670',415896.00,0.00,0.00,670.80,40248.00,'2022-04-26 20:15:13','',''),(2644840,'1','186','940',419,'Retail Sale Id 1636671',7750.00,0.00,0.00,12.50,750.00,'2022-04-27 08:39:52','',''),(2644841,'1','186','940',419,'Retail Sale Id 1636672',3720.00,0.00,0.00,6.00,360.00,'2022-04-27 08:41:20','',''),(2644842,'1','186','940',419,'Retail Sale Id 1636673',7750.00,0.00,0.00,12.50,750.00,'2022-04-27 08:41:55','',''),(2644843,'1','186','940',419,'Retail Sale Id 1636674',29000.00,0.00,0.00,50.00,1000.00,'2022-04-27 08:42:41','',''),(2644844,'1','186','940',419,'Retail Sale Id 1636675',87000.00,0.00,0.00,150.00,3000.00,'2022-04-27 08:43:35','',''),(2644845,'1','186','940',419,'Retail Sale Id 1636676',7750.00,0.00,0.00,12.50,750.00,'2022-04-27 11:13:33','',''),(2644846,'1','186','940',419,'Retail Sale Id 1636677',290000.00,0.00,0.00,500.00,10000.00,'2022-04-27 11:19:46','',''),(2644847,'1','186','940',419,'Retail Sale Id 1636678',174000.00,0.00,0.00,300.00,6000.00,'2022-04-27 11:21:24','',''),(2644848,'1','186','940',419,'Retail Sale Id 1636679',1127100.00,0.00,0.00,1950.00,35100.00,'2022-04-27 20:26:18','',''),(2644849,'1','186','940',419,'Retail Sale Id 1636680',157604.00,0.00,0.00,254.20,15252.00,'2022-04-27 20:29:10','',''),(2644850,'1','186','940',419,'Distributed to AARANO for sales id:349423',203280.00,0.00,0.00,363.00,0.00,'2022-04-27 20:40:43','',''),(2644851,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14033600.00,25060.00,0.00,0.00,'2022-04-28 08:37:52','',''),(2644852,'1','186',NULL,419,'Reception corrector for bridging 132690',0.00,0.00,0.00,23000.00,0.00,'2022-04-28 08:46:45','',''),(2644853,'1','186','940',419,'Received from bridging 132690',0.00,0.00,23000.00,0.00,0.00,'2022-04-28 08:46:45','',''),(2644854,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,11200.00,20.00,0.00,0.00,'2022-04-28 08:48:16','',''),(2644855,'1','186','940',419,'Retail Sale Id 1636681',7750.00,0.00,0.00,12.50,750.00,'2022-04-28 08:50:50','',''),(2644856,'1','186','940',419,'Retail Sale Id 1636682',9300.00,0.00,0.00,15.00,900.00,'2022-04-28 08:51:38','',''),(2644857,'1','186','940',419,'Retail Sale Id 1636683',1860.00,0.00,0.00,3.00,180.00,'2022-04-28 08:52:17','',''),(2644858,'1','186','940',419,'Retail Sale Id 1636684',29000.00,0.00,0.00,50.00,1000.00,'2022-04-28 08:57:47','',''),(2644859,'1','186','940',419,'Retail Sale Id 1636685',7750.00,0.00,0.00,12.50,750.00,'2022-04-28 09:10:25','',''),(2644860,'1','186','940',419,'Retail Sale Id 1636686',290000.00,0.00,0.00,500.00,10000.00,'2022-04-28 09:11:40','',''),(2644861,'1','186','940',419,'Retail Sale Id 1636687',7750.00,0.00,0.00,12.50,750.00,'2022-04-28 09:23:31','',''),(2644862,'1','186','940',419,'Retail Sale Id 1636688',451422.00,0.00,0.00,728.10,43686.00,'2022-04-28 20:34:32','',''),(2644863,'1','186','940',419,'Retail Sale Id 1636689',1798000.00,0.00,0.00,3100.00,62000.00,'2022-04-28 20:35:39','',''),(2644864,'1','186','940',419,'Retail Sale Id 1636690',5462100.00,0.00,0.00,9450.00,170100.00,'2022-04-28 20:40:55','',''),(2644865,'1','186','940',419,'Retail Sale Id 1636691',7750.00,0.00,0.00,12.50,750.00,'2022-04-29 08:30:52','',''),(2644866,'1','186','940',419,'Retail Sale Id 1636692',29000.00,0.00,0.00,50.00,1000.00,'2022-04-29 08:32:47','',''),(2644867,'1','186','940',419,'Retail Sale Id 1636693',7750.00,0.00,0.00,12.50,750.00,'2022-04-29 08:33:59','',''),(2644868,'1','186','940',419,'Retail Sale Id 1636694',9300.00,0.00,0.00,15.00,900.00,'2022-04-29 08:36:41','',''),(2644869,'1','186','940',419,'Retail Sale Id 1636695',58000.00,0.00,0.00,100.00,2000.00,'2022-04-29 08:37:28','',''),(2644870,'1','186','940',419,'Retail Sale Id 1636696',7750.00,0.00,0.00,12.50,750.00,'2022-04-29 08:38:25','',''),(2644871,'1','186','940',419,'Retail Sale Id 1636697',290000.00,0.00,0.00,500.00,10000.00,'2022-04-29 13:16:20','',''),(2644872,'1','186','940',419,'Retail Sale Id 1636698',7750.00,0.00,0.00,12.50,750.00,'2022-04-29 13:18:09','',''),(2644873,'1','186',NULL,419,'Reception corrector for bridging 132691',0.00,0.00,0.00,2060.00,0.00,'2022-04-29 20:16:39','',''),(2644874,'1','186','940',419,'Received from bridging 132691',0.00,0.00,2060.00,0.00,0.00,'2022-04-29 20:16:39','',''),(2644875,'1','186',NULL,419,'Reception corrector for bridging 132692',0.00,0.00,0.00,20.00,0.00,'2022-04-29 20:18:12','',''),(2644876,'1','186','940',419,'Received from bridging 132692',0.00,0.00,20.00,0.00,0.00,'2022-04-29 20:18:12','',''),(2644877,'1','186','940',419,'Retail Sale Id 1636699',1566000.00,0.00,0.00,2700.00,54000.00,'2022-04-29 20:22:22','',''),(2644878,'1','186','940',419,'Retail Sale Id 1636700',421600.00,0.00,0.00,680.00,40800.00,'2022-04-29 20:25:21','',''),(2644879,'1','186','940',419,'Retail Sale Id 1636701',3891847.40,0.00,0.00,6733.30,121199.40,'2022-04-29 20:29:57','',''),(2644880,'1','186','940',419,'Distributed to AARANO for sales id:349424',206136.00,0.00,0.00,368.10,0.00,'2022-04-30 09:38:17','',''),(2644881,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14006720.00,25012.00,0.00,0.00,'2022-04-30 19:34:06','',''),(2644882,'1','186',NULL,419,'Reception corrector for bridging 132693',0.00,0.00,0.00,23000.00,0.00,'2022-04-30 19:35:54','',''),(2644883,'1','186','940',419,'Received from bridging 132693',0.00,0.00,23000.00,0.00,0.00,'2022-04-30 19:35:54','',''),(2644884,'1','186','940',419,'Retail Sale Id 1636702',173972.00,0.00,0.00,280.60,16836.00,'2022-04-30 20:18:03','',''),(2644885,'1','186','940',419,'Retail Sale Id 1636703',217500.00,0.00,0.00,375.00,7500.00,'2022-04-30 20:19:14','',''),(2644886,'1','186','940',419,'Retail Sale Id 1636704',1011500.00,0.00,0.00,1750.00,31500.00,'2022-04-30 20:20:12','',''),(2644887,'1','186','940',419,'Retail Sale Id 1636705',9300.00,0.00,0.00,15.00,900.00,'2022-05-01 10:07:46','',''),(2644888,'1','186','940',419,'Retail Sale Id 1636706',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:08:28','',''),(2644889,'1','186','940',419,'Retail Sale Id 1636707',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:09:18','',''),(2644890,'1','186','940',419,'Retail Sale Id 1636708',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:10:31','',''),(2644891,'1','186','940',419,'Retail Sale Id 1636709',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:12:09','',''),(2644892,'1','186','940',419,'Retail Sale Id 1636710',1160000.00,0.00,0.00,2000.00,40000.00,'2022-05-01 10:16:05','',''),(2644893,'1','186','940',419,'Retail Sale Id 1636711',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:16:47','',''),(2644894,'1','186','940',419,'Retail Sale Id 1636712',290000.00,0.00,0.00,500.00,10000.00,'2022-05-01 10:17:40','',''),(2644895,'1','186','940',419,'Retail Sale Id 1636713',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:18:15','',''),(2644896,'1','186','940',419,'Retail Sale Id 1636714',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:18:48','',''),(2644897,'1','186','940',419,'Retail Sale Id 1636715',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 10:19:25','',''),(2644898,'1','186','940',419,'Retail Sale Id 1636716',290000.00,0.00,0.00,500.00,10000.00,'2022-05-01 10:20:23','',''),(2644899,'1','186','940',419,'Retail Sale Id 1636717',7750.00,0.00,0.00,12.50,750.00,'2022-05-01 15:43:25','',''),(2644900,'1','186','940',419,'Retail Sale Id 1636718',365180.00,0.00,0.00,589.00,35340.00,'2022-05-01 22:58:05','',''),(2644901,'1','186','940',419,'Retail Sale Id 1636719',435000.00,0.00,0.00,750.00,15000.00,'2022-05-01 23:00:04','',''),(2644902,'1','186','940',419,'Retail Sale Id 1636720',9305800.00,0.00,0.00,16100.00,289800.00,'2022-05-01 23:02:00','',''),(2644903,'1','186',NULL,419,'Reception corrector for bridging 132694',0.00,0.00,0.00,2012.00,0.00,'2022-05-02 10:03:40','',''),(2644904,'1','186','940',419,'Received from bridging 132694',0.00,0.00,2012.00,0.00,0.00,'2022-05-02 10:03:40','',''),(2644905,'1','186','940',419,'Retail Sale Id 1636721',809200.00,0.00,0.00,1400.00,25200.00,'2022-05-02 10:53:24','',''),(2644906,'1','186','940',419,'Retail Sale Id 1636722',47740.00,0.00,0.00,77.00,4620.00,'2022-05-02 19:44:02','',''),(2644907,'1','186','940',419,'Retail Sale Id 1636724',101442.00,0.00,0.00,174.90,3498.00,'2022-05-02 19:47:52','',''),(2644908,'1','186','940',419,'Distributed to AARANO for sales id:349425',217280.00,0.00,0.00,388.00,0.00,'2022-05-03 08:27:07','',''),(2644909,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13988800.00,24980.00,0.00,0.00,'2022-05-03 19:16:25','',''),(2644910,'1','186',NULL,419,'Reception corrector for bridging 132695',0.00,0.00,0.00,23000.00,0.00,'2022-05-03 19:18:41','',''),(2644911,'1','186','940',419,'Received from bridging 132695',0.00,0.00,23000.00,0.00,0.00,'2022-05-03 19:18:41','',''),(2644912,'1','186','940',419,'Retail Sale Id 1636725',838100.00,0.00,0.00,1450.00,26100.00,'2022-05-03 19:20:18','',''),(2644913,'1','186','940',419,'Retail Sale Id 1636726',207390.00,0.00,0.00,334.50,20070.00,'2022-05-03 19:21:26','',''),(2644914,'1','186','940',419,'Retail Sale Id 1636727',377000.00,0.00,0.00,650.00,13000.00,'2022-05-03 21:47:20','',''),(2644915,'1','186','940',419,'Retail Sale Id 1636728',207390.00,0.00,0.00,334.50,20070.00,'2022-05-03 21:48:19','',''),(2644916,'1','186','940',419,'Return of Retail Sale Id 1636727',0.00,377000.00,650.00,0.00,-13000.00,'2022-05-03 21:52:44','',''),(2644917,'1','186','940',419,'Return of Retail Sale Id 1636725',0.00,838100.00,1450.00,0.00,-26100.00,'2022-05-03 21:53:17','',''),(2644918,'1','186','940',419,'Return of Retail Sale Id 1636726',0.00,207390.00,334.50,0.00,-20070.00,'2022-05-03 21:54:21','',''),(2644919,'1','186','940',419,'Retail Sale Id 1636729',377000.00,0.00,0.00,650.00,13000.00,'2022-05-03 21:55:18','',''),(2644920,'1','186','940',419,'Retail Sale Id 1636730',838100.00,0.00,0.00,1450.00,26100.00,'2022-05-03 21:56:36','',''),(2644921,'1','186','940',419,'Retail Sale Id 1636731',7750.00,0.00,0.00,12.50,750.00,'2022-05-04 09:51:09','',''),(2644922,'1','186','940',419,'Retail Sale Id 1636732',1740000.00,0.00,0.00,3000.00,60000.00,'2022-05-04 10:29:02','',''),(2644923,'1','186','940',419,'Retail Sale Id 1636733',9300.00,0.00,0.00,15.00,900.00,'2022-05-04 10:29:37','',''),(2644924,'1','186','940',419,'Retail Sale Id 1636734',7750.00,0.00,0.00,12.50,750.00,'2022-05-04 10:30:34','',''),(2644925,'1','186','940',419,'Retail Sale Id 1636735',425430.00,0.00,0.00,733.50,14670.00,'2022-05-04 21:56:59','',''),(2644926,'1','186','940',419,'Retail Sale Id 1636736',7831900.00,0.00,0.00,13550.00,243900.00,'2022-05-04 21:59:27','',''),(2644927,'1','186','940',419,'Retail Sale Id 1636737',425506.00,0.00,0.00,686.30,41178.00,'2022-05-04 22:11:43','',''),(2644928,'1','186','940',419,'Retail Sale Id 1636738',7750.00,0.00,0.00,12.50,750.00,'2022-05-05 12:50:09','',''),(2644929,'1','186',NULL,419,'Reception corrector for bridging 132696',0.00,0.00,0.00,1980.00,0.00,'2022-05-05 18:32:54','',''),(2644930,'1','186','940',419,'Received from bridging 132696',0.00,0.00,1980.00,0.00,0.00,'2022-05-05 18:32:54','',''),(2644931,'1','186','940',419,'Retail Sale Id 1636739',2023000.00,0.00,0.00,3500.00,63000.00,'2022-05-05 18:34:04','',''),(2644932,'1','186','940',419,'Retail Sale Id 1636740',59520.00,0.00,0.00,96.00,5760.00,'2022-05-05 18:36:06','',''),(2644933,'1','186','940',419,'Retail Sale Id 1636741',274340.00,0.00,0.00,473.00,9460.00,'2022-05-05 18:39:37','',''),(2644934,'1','186','940',419,'Retail Sale Id 1636743',52824.00,0.00,0.00,85.20,5112.00,'2022-05-05 18:42:02','',''),(2644935,'1','186','940',419,'Distributed to MUSA YAU SHAIBU for sales id:349426',206640.00,0.00,0.00,369.00,0.00,'2022-05-07 10:19:00','',''),(2644936,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,13988800.00,24980.00,0.00,0.00,'2022-05-07 10:38:38','',''),(2644937,'1','186',NULL,419,'Reception corrector for bridging 132697',0.00,0.00,0.00,23000.00,0.00,'2022-05-07 10:41:16','',''),(2644938,'1','186','940',419,'Received from bridging 132697',0.00,0.00,23000.00,0.00,0.00,'2022-05-07 10:41:16','',''),(2644939,'1','186','940',419,'Retail Sale Id 1636744',7750.00,0.00,0.00,12.50,750.00,'2022-05-07 10:47:17','',''),(2644940,'1','186','940',419,'Retail Sale Id 1636745',7750.00,0.00,0.00,12.50,750.00,'2022-05-07 10:48:23','',''),(2644941,'1','186','940',419,'Retail Sale Id 1636746',7750.00,0.00,0.00,12.50,750.00,'2022-05-07 10:48:58','',''),(2644942,'1','186','940',419,'Retail Sale Id 1636747',11780.00,0.00,0.00,19.00,1140.00,'2022-05-07 10:53:09','',''),(2644943,'1','186','940',419,'Retail Sale Id 1636748',1160000.00,0.00,0.00,2000.00,40000.00,'2022-05-07 10:54:16','',''),(2644944,'1','186','940',419,'Retail Sale Id 1636749',29000.00,0.00,0.00,50.00,1000.00,'2022-05-07 10:55:50','',''),(2644945,'1','186','940',419,'Retail Sale Id 1636750',870000.00,0.00,0.00,1500.00,30000.00,'2022-05-07 22:28:00','',''),(2644946,'1','186','940',419,'Retail Sale Id 1636751',8381000.00,0.00,0.00,14500.00,261000.00,'2022-05-07 22:29:56','',''),(2644947,'1','186','940',419,'Retail Sale Id 1636752',452910.00,0.00,0.00,730.50,43830.00,'2022-05-07 22:33:30','',''),(2644948,'1','186','940',419,'Retail Sale Id 1636753',928000.00,0.00,0.00,1600.00,32000.00,'2022-05-08 11:47:43','',''),(2644949,'1','186','940',419,'Retail Sale Id 1636754',290000.00,0.00,0.00,500.00,10000.00,'2022-05-08 11:51:10','',''),(2644950,'1','186','940',419,'Retail Sale Id 1636755',1240.00,0.00,0.00,2.00,120.00,'2022-05-08 12:16:53','',''),(2644951,'1','186','940',419,'Retail Sale Id 1636756',998.20,0.00,0.00,1.61,96.60,'2022-05-08 13:18:53','',''),(2644952,'1','186','940',419,'Retail Sale Id 1636757',998.20,0.00,0.00,1.61,96.60,'2022-05-08 13:21:05','',''),(2644953,'1','186','940',419,'Retail Sale Id 1636758',998.20,0.00,0.00,1.61,96.60,'2022-05-08 13:22:40','',''),(2644954,'1','186','940',419,'Retail Sale Id 1636759',1860.00,0.00,0.00,3.00,180.00,'2022-05-08 13:24:27','',''),(2644955,'1','186','940',419,'Retail Sale Id 1636760',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:26:30','',''),(2644956,'1','186','940',419,'Retail Sale Id 1636761',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:28:30','',''),(2644957,'1','186','940',419,'Retail Sale Id 1636762',1500.40,0.00,0.00,2.42,145.20,'2022-05-08 13:33:04','',''),(2644958,'1','186','940',419,'Retail Sale Id 1636763',3100.00,0.00,0.00,5.00,300.00,'2022-05-08 13:34:22','',''),(2644959,'1','186','940',419,'Retail Sale Id 1636764',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:36:46','',''),(2644960,'1','186','940',419,'Retail Sale Id 1636765',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:43:56','',''),(2644961,'1','186','940',419,'Retail Sale Id 1636766',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:46:22','',''),(2644962,'1','186','940',419,'Retail Sale Id 1636767',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:47:39','',''),(2644963,'1','186','940',419,'Retail Sale Id 1636768',1860.00,0.00,0.00,3.00,180.00,'2022-05-08 13:48:48','',''),(2644964,'1','186','940',419,'Retail Sale Id 1636769',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:49:37','',''),(2644965,'1','186','940',419,'Retail Sale Id 1636770',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:50:34','',''),(2644966,'1','186','940',419,'Retail Sale Id 1636771',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:51:43','',''),(2644967,'1','186','940',419,'Retail Sale Id 1636772',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:53:21','',''),(2644968,'1','186','940',419,'Retail Sale Id 1636773',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:55:49','',''),(2644969,'1','186','940',419,'Retail Sale Id 1636774',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:56:26','',''),(2644970,'1','186','940',419,'Retail Sale Id 1636775',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 13:58:30','',''),(2644971,'1','186','940',419,'Retail Sale Id 1636776',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 14:01:51','',''),(2644972,'1','186','940',419,'Retail Sale Id 1636777',3100.00,0.00,0.00,5.00,300.00,'2022-05-08 14:03:13','',''),(2644973,'1','186','940',419,'Retail Sale Id 1636778',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 14:04:02','',''),(2644974,'1','186','940',419,'Retail Sale Id 1636779',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 14:12:45','',''),(2644975,'1','186','940',419,'Retail Sale Id 1636780',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 14:29:59','',''),(2644976,'1','186','940',419,'Retail Sale Id 1636781',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:10:27','',''),(2644977,'1','186','940',419,'Retail Sale Id 1636782',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:22:46','',''),(2644978,'1','186','940',419,'Retail Sale Id 1636783',1240.00,0.00,0.00,2.00,120.00,'2022-05-08 15:27:57','',''),(2644979,'1','186','940',419,'Retail Sale Id 1636784',29000.00,0.00,0.00,50.00,1000.00,'2022-05-08 15:29:39','',''),(2644980,'1','186','940',419,'Retail Sale Id 1636785',1240.00,0.00,0.00,2.00,120.00,'2022-05-08 15:35:34','',''),(2644981,'1','186','940',419,'Retail Sale Id 1636786',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:37:44','',''),(2644982,'1','186','940',419,'Retail Sale Id 1636787',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:39:23','',''),(2644983,'1','186','940',419,'Retail Sale Id 1636788',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:42:09','',''),(2644984,'1','186','940',419,'Retail Sale Id 1636789',29000.00,0.00,0.00,50.00,1000.00,'2022-05-08 15:44:58','',''),(2644985,'1','186','940',419,'Retail Sale Id 1636790',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:46:35','',''),(2644986,'1','186','940',419,'Retail Sale Id 1636791',3720.00,0.00,0.00,6.00,360.00,'2022-05-08 15:48:41','',''),(2644987,'1','186','940',419,'Retail Sale Id 1636792',29000.00,0.00,0.00,50.00,1000.00,'2022-05-08 15:51:45','',''),(2644988,'1','186','940',419,'Retail Sale Id 1636793',3100.00,0.00,0.00,5.00,300.00,'2022-05-08 15:53:30','',''),(2644989,'1','186','940',419,'Retail Sale Id 1636794',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:56:12','',''),(2644990,'1','186','940',419,'Retail Sale Id 1636795',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 15:59:39','',''),(2644991,'1','186','940',419,'Retail Sale Id 1636796',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:02:14','',''),(2644992,'1','186','940',419,'Retail Sale Id 1636797',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:09:35','',''),(2644993,'1','186','940',419,'Retail Sale Id 1636798',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:11:14','',''),(2644994,'1','186','940',419,'Retail Sale Id 1636799',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:20:44','',''),(2644995,'1','186','940',419,'Retail Sale Id 1636800',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:24:18','',''),(2644996,'1','186','940',419,'Retail Sale Id 1636802',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:27:17','',''),(2644997,'1','186','940',419,'Retail Sale Id 1636803',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:30:12','',''),(2644998,'1','186','940',419,'Retail Sale Id 1636804',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:31:57','',''),(2644999,'1','186','940',419,'Retail Sale Id 1636805',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:34:29','',''),(2645000,'1','186','940',419,'Retail Sale Id 1636806',3100.00,0.00,0.00,5.00,300.00,'2022-05-08 16:36:06','',''),(2645001,'1','186','940',419,'Retail Sale Id 1636807',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:37:42','',''),(2645002,'1','186','940',419,'Retail Sale Id 1636808',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:38:37','',''),(2645003,'1','186','940',419,'Retail Sale Id 1636809',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:41:10','',''),(2645004,'1','186','940',419,'Retail Sale Id 1636810',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:45:43','',''),(2645005,'1','186','940',419,'Retail Sale Id 1636811',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:51:29','',''),(2645006,'1','186','940',419,'Retail Sale Id 1636812',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 16:58:33','',''),(2645007,'1','186','940',419,'Retail Sale Id 1636813',7750.00,0.00,0.00,12.50,750.00,'2022-05-08 17:31:51','',''),(2645008,'1','186',NULL,419,'Reception corrector for bridging 132698',0.00,0.00,0.00,1980.00,0.00,'2022-05-08 19:09:49','',''),(2645009,'1','186','940',419,'Received from bridging 132698',0.00,0.00,1980.00,0.00,0.00,'2022-05-08 19:09:49','',''),(2645010,'1','186','940',419,'Retail Sale Id 1636814',467095.60,0.00,0.00,753.38,45202.80,'2022-05-08 19:22:09','',''),(2645011,'1','186','940',419,'Retail Sale Id 1636815',1054440.00,0.00,0.00,1818.00,36360.00,'2022-05-08 19:23:40','',''),(2645012,'1','186','940',419,'Retail Sale Id 1636816',324666.60,0.00,0.00,559.77,11195.40,'2022-05-08 20:06:39','',''),(2645013,'1','186','940',419,'Distributed to AARANO for sales id:349427',114296.00,0.00,0.00,204.10,0.00,'2022-05-09 08:42:35','',''),(2645014,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,14033600.00,25060.00,0.00,0.00,'2022-05-10 13:56:01','',''),(2645015,'1','186',NULL,419,'Reception corrector for bridging 132699',0.00,0.00,0.00,23000.00,0.00,'2022-05-10 14:00:41','',''),(2645016,'1','186','940',419,'Received from bridging 132699',0.00,0.00,23000.00,0.00,0.00,'2022-05-10 14:00:41','',''),(2645017,'1','186','940',419,'Retail Sale Id 1636817',7750.00,0.00,0.00,12.50,750.00,'2022-05-10 15:17:24','',''),(2645018,'1','186','940',419,'Retail Sale Id 1636819',6200.00,0.00,0.00,10.00,600.00,'2022-05-10 15:50:06','',''),(2645019,'1','186','940',419,'Retail Sale Id 1636820',7750.00,0.00,0.00,12.50,750.00,'2022-05-10 15:58:04','',''),(2645020,'1','186','940',419,'Retail Sale Id 1636821',29000.00,0.00,0.00,50.00,1000.00,'2022-05-10 16:02:09','',''),(2645021,'1','186','940',419,'Retail Sale Id 1636822',3100.00,0.00,0.00,5.00,300.00,'2022-05-10 16:06:06','',''),(2645022,'1','186','940',419,'Retail Sale Id 1636823',1860.00,0.00,0.00,3.00,180.00,'2022-05-10 16:10:37','',''),(2645023,'1','186','940',419,'Retail Sale Id 1636824',1240.00,0.00,0.00,2.00,120.00,'2022-05-10 16:13:07','',''),(2645024,'1','186','940',419,'Retail Sale Id 1636825',3720.00,0.00,0.00,6.00,360.00,'2022-05-10 16:22:05','',''),(2645025,'1','186','940',419,'Retail Sale Id 1636826',3720.00,0.00,0.00,6.00,360.00,'2022-05-10 16:26:14','',''),(2645026,'1','186','940',419,'Retail Sale Id 1636828',29000.00,0.00,0.00,50.00,1000.00,'2022-05-10 16:32:06','',''),(2645027,'1','186','940',419,'Retail Sale Id 1636829',2480.00,0.00,0.00,4.00,240.00,'2022-05-10 16:34:12','',''),(2645028,'1','186','940',419,'Retail Sale Id 1636830',3720.00,0.00,0.00,6.00,360.00,'2022-05-10 16:35:45','',''),(2645029,'1','186','940',419,'Retail Sale Id 1636831',2480.00,0.00,0.00,4.00,240.00,'2022-05-10 16:36:52','',''),(2645030,'1','186','940',419,'Retail Sale Id 1636832',4340.00,0.00,0.00,7.00,420.00,'2022-05-10 16:39:04','',''),(2645031,'1','186','940',419,'Retail Sale Id 1636833',3100.00,0.00,0.00,5.00,300.00,'2022-05-10 16:40:38','',''),(2645032,'1','186','940',419,'Retail Sale Id 1636835',7750.00,0.00,0.00,12.50,750.00,'2022-05-10 16:42:09','',''),(2645033,'1','186','940',419,'Retail Sale Id 1636836',14500.00,0.00,0.00,25.00,500.00,'2022-05-10 16:54:48','',''),(2645034,'1','186','940',419,'Retail Sale Id 1636839',5580.00,0.00,0.00,9.00,540.00,'2022-05-10 16:56:24','',''),(2645035,'1','186','940',419,'Retail Sale Id 1636840',707947.00,0.00,0.00,1141.85,68511.00,'2022-05-10 20:44:01','',''),(2645036,'1','186','940',419,'Retail Sale Id 1636841',1049800.00,0.00,0.00,1810.00,36200.00,'2022-05-10 20:46:29','',''),(2645037,'1','186','940',419,'Retail Sale Id 1636842',620.00,0.00,0.00,1.00,60.00,'2022-05-11 07:40:18','',''),(2645038,'1','186','940',419,'Retail Sale Id 1636843',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 09:23:36','',''),(2645039,'1','186','940',419,'Retail Sale Id 1636844',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 09:28:58','',''),(2645040,'1','186','940',419,'Retail Sale Id 1636845',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 09:30:31','',''),(2645041,'1','186','940',419,'Retail Sale Id 1636846',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 09:32:34','',''),(2645042,'1','186','940',419,'Retail Sale Id 1636847',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 09:33:04','',''),(2645043,'1','186','940',419,'Retail Sale Id 1636848',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 09:33:31','',''),(2645044,'1','186','940',419,'Retail Sale Id 1636849',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 09:35:07','',''),(2645045,'1','186','940',419,'Retail Sale Id 1636850',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 09:36:11','',''),(2645046,'1','186','940',419,'Retail Sale Id 1636851',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 09:37:14','',''),(2645047,'1','186','940',419,'Retail Sale Id 1636852',620.00,0.00,0.00,1.00,60.00,'2022-05-11 09:38:06','',''),(2645048,'1','186','940',419,'Retail Sale Id 1636853',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 09:39:24','',''),(2645049,'1','186','940',419,'Retail Sale Id 1636854',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 09:41:00','',''),(2645050,'1','186','940',419,'Retail Sale Id 1636856',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 09:42:45','',''),(2645051,'1','186','940',419,'Retail Sale Id 1636857',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 09:44:26','',''),(2645052,'1','186','940',419,'Retail Sale Id 1636858',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 09:47:18','',''),(2645053,'1','186','940',419,'Retail Sale Id 1636860',44080.00,0.00,0.00,76.00,1520.00,'2022-05-11 09:51:08','',''),(2645054,'1','186','940',419,'Retail Sale Id 1636862',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 09:53:11','',''),(2645055,'1','186','940',419,'Retail Sale Id 1636863',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 09:54:49','',''),(2645056,'1','186','940',419,'Retail Sale Id 1636864',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 09:57:32','',''),(2645057,'1','186','940',419,'Retail Sale Id 1636865',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 09:59:06','',''),(2645058,'1','186','940',419,'Retail Sale Id 1636866',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 09:59:46','',''),(2645059,'1','186','940',419,'Retail Sale Id 1636867',34800.00,0.00,0.00,60.00,1200.00,'2022-05-11 10:00:43','',''),(2645060,'1','186','940',419,'Retail Sale Id 1636868',4501.20,0.00,0.00,7.26,435.60,'2022-05-11 10:01:41','',''),(2645061,'1','186','940',419,'Retail Sale Id 1636869',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 10:02:54','',''),(2645062,'1','186','940',419,'Retail Sale Id 1636870',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 10:03:53','',''),(2645063,'1','186','940',419,'Retail Sale Id 1636871',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 10:04:43','',''),(2645064,'1','186','940',419,'Retail Sale Id 1636872',127600.00,0.00,0.00,220.00,4400.00,'2022-05-11 10:06:40','',''),(2645065,'1','186','940',419,'Retail Sale Id 1636876',998.20,0.00,0.00,1.61,96.60,'2022-05-11 10:14:02','',''),(2645066,'1','186','940',419,'Retail Sale Id 1636877',998.20,0.00,0.00,1.61,96.60,'2022-05-11 10:17:15','',''),(2645067,'1','186','940',419,'Retail Sale Id 1636878',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 10:22:58','',''),(2645068,'1','186','940',419,'Retail Sale Id 1636879',6200.00,0.00,0.00,10.00,600.00,'2022-05-11 10:24:02','',''),(2645069,'1','186','940',419,'Retail Sale Id 1636880',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 10:24:35','',''),(2645070,'1','186','940',419,'Retail Sale Id 1636881',11600.00,0.00,0.00,20.00,400.00,'2022-05-11 10:25:17','',''),(2645071,'1','186','940',419,'Retail Sale Id 1636882',6200.00,0.00,0.00,10.00,600.00,'2022-05-11 10:31:09','',''),(2645072,'1','186','940',419,'Retail Sale Id 1636883',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 10:38:27','',''),(2645073,'1','186','940',419,'Retail Sale Id 1636884',60900.00,0.00,0.00,105.00,2100.00,'2022-05-11 10:46:17','',''),(2645074,'1','186','940',419,'Retail Sale Id 1636886',3503.00,0.00,0.00,5.65,339.00,'2022-05-11 10:48:06','',''),(2645075,'1','186','940',419,'Retail Sale Id 1636888',4340.00,0.00,0.00,7.00,420.00,'2022-05-11 10:49:39','',''),(2645076,'1','186','940',419,'Retail Sale Id 1636889',31900.00,0.00,0.00,55.00,1100.00,'2022-05-11 10:50:16','',''),(2645077,'1','186','940',419,'Retail Sale Id 1636890',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 10:51:01','',''),(2645078,'1','186','940',419,'Retail Sale Id 1636891',3999.00,0.00,0.00,6.45,387.00,'2022-05-11 10:52:59','',''),(2645079,'1','186','940',419,'Retail Sale Id 1636892',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 10:57:25','',''),(2645080,'1','186','940',419,'Retail Sale Id 1636893',5580.00,0.00,0.00,9.00,540.00,'2022-05-11 10:59:32','',''),(2645081,'1','186','940',419,'Retail Sale Id 1636894',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 11:01:19','',''),(2645082,'1','186','940',419,'Retail Sale Id 1636895',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 11:01:54','',''),(2645083,'1','186','940',419,'Retail Sale Id 1636896',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 11:02:31','',''),(2645084,'1','186','940',419,'Retail Sale Id 1636897',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 11:03:39','',''),(2645085,'1','186','940',419,'Retail Sale Id 1636899',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 11:05:51','',''),(2645086,'1','186','940',419,'Retail Sale Id 1636900',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 11:06:20','',''),(2645087,'1','186','940',419,'Retail Sale Id 1636901',14880.00,0.00,0.00,24.00,1440.00,'2022-05-11 11:06:55','',''),(2645088,'1','186','940',419,'Retail Sale Id 1636902',4501.20,0.00,0.00,7.26,435.60,'2022-05-11 11:08:30','',''),(2645089,'1','186','940',419,'Retail Sale Id 1636903',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 11:09:49','',''),(2645090,'1','186','940',419,'Retail Sale Id 1636904',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 11:10:22','',''),(2645091,'1','186','940',419,'Retail Sale Id 1636905',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 11:10:51','',''),(2645092,'1','186','940',419,'Retail Sale Id 1636906',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 11:15:49','',''),(2645093,'1','186','940',419,'Retail Sale Id 1636907',1202.80,0.00,0.00,1.94,116.40,'2022-05-11 11:17:40','',''),(2645094,'1','186','940',419,'Retail Sale Id 1636908',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 11:18:53','',''),(2645095,'1','186','940',419,'Retail Sale Id 1636909',998.20,0.00,0.00,1.61,96.60,'2022-05-11 11:20:09','',''),(2645096,'1','186','940',419,'Retail Sale Id 1636910',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 11:22:36','',''),(2645097,'1','186','940',419,'Retail Sale Id 1636911',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 11:26:53','',''),(2645098,'1','186','940',419,'Retail Sale Id 1636912',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 11:28:26','',''),(2645099,'1','186','940',419,'Retail Sale Id 1636913',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 11:29:55','',''),(2645100,'1','186','940',419,'Retail Sale Id 1636914',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 11:31:42','',''),(2645101,'1','186','940',419,'Retail Sale Id 1636916',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 11:33:13','',''),(2645102,'1','186','940',419,'Retail Sale Id 1636917',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 11:34:21','',''),(2645103,'1','186','940',419,'Retail Sale Id 1636919',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 11:35:40','',''),(2645104,'1','186','940',419,'Retail Sale Id 1636920',4340.00,0.00,0.00,7.00,420.00,'2022-05-11 11:37:13','',''),(2645105,'1','186','940',419,'Retail Sale Id 1636921',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 11:38:40','',''),(2645106,'1','186','940',419,'Retail Sale Id 1636922',5580.00,0.00,0.00,9.00,540.00,'2022-05-11 11:43:07','',''),(2645107,'1','186','940',419,'Retail Sale Id 1636923',67280.00,0.00,0.00,116.00,2320.00,'2022-05-11 11:45:34','',''),(2645108,'1','186','940',419,'Retail Sale Id 1636924',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 11:48:53','',''),(2645109,'1','186','940',419,'Retail Sale Id 1636925',3999.00,0.00,0.00,6.45,387.00,'2022-05-11 11:50:30','',''),(2645110,'1','186','940',419,'Retail Sale Id 1636926',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 11:51:51','',''),(2645111,'1','186','940',419,'Retail Sale Id 1636927',998.20,0.00,0.00,1.61,96.60,'2022-05-11 11:52:53','',''),(2645112,'1','186','940',419,'Retail Sale Id 1636928',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 11:53:26','',''),(2645113,'1','186','940',419,'Retail Sale Id 1636929',1401.20,0.00,0.00,2.26,135.60,'2022-05-11 11:54:05','',''),(2645114,'1','186','940',419,'Retail Sale Id 1636930',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 11:54:55','',''),(2645115,'1','186','940',419,'Retail Sale Id 1636931',998.20,0.00,0.00,1.61,96.60,'2022-05-11 11:55:27','',''),(2645116,'1','186','940',419,'Retail Sale Id 1636932',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 11:55:58','',''),(2645117,'1','186','940',419,'Retail Sale Id 1636933',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 11:56:39','',''),(2645118,'1','186','940',419,'Retail Sale Id 1636934',3999.00,0.00,0.00,6.45,387.00,'2022-05-11 11:58:58','',''),(2645119,'1','186','940',419,'Retail Sale Id 1636935',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 12:00:42','',''),(2645120,'1','186','940',419,'Retail Sale Id 1636936',4960.00,0.00,0.00,8.00,480.00,'2022-05-11 12:02:59','',''),(2645121,'1','186','940',419,'Retail Sale Id 1636937',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 12:05:10','',''),(2645122,'1','186','940',419,'Retail Sale Id 1636939',145000.00,0.00,0.00,250.00,5000.00,'2022-05-11 12:10:49','',''),(2645123,'1','186','940',419,'Retail Sale Id 1636940',6200.00,0.00,0.00,10.00,600.00,'2022-05-11 12:14:14','',''),(2645124,'1','186','940',419,'Retail Sale Id 1636941',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 12:16:24','',''),(2645125,'1','186','940',419,'Retail Sale Id 1636942',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 12:19:27','',''),(2645126,'1','186','940',419,'Retail Sale Id 1636943',9610.00,0.00,0.00,15.50,930.00,'2022-05-11 12:21:33','',''),(2645127,'1','186','940',419,'Retail Sale Id 1636944',6200.00,0.00,0.00,10.00,600.00,'2022-05-11 12:22:15','',''),(2645128,'1','186','940',419,'Retail Sale Id 1636945',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 12:24:50','',''),(2645129,'1','186','940',419,'Retail Sale Id 1636946',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 12:25:55','',''),(2645130,'1','186','940',419,'Retail Sale Id 1636947',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 12:26:31','',''),(2645131,'1','186','940',419,'Retail Sale Id 1636948',1202.80,0.00,0.00,1.94,116.40,'2022-05-11 12:27:14','',''),(2645132,'1','186','940',419,'Retail Sale Id 1636949',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 12:28:01','',''),(2645133,'1','186','940',419,'Retail Sale Id 1636950',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 12:28:50','',''),(2645134,'1','186','940',419,'Retail Sale Id 1636951',58000.00,0.00,0.00,100.00,2000.00,'2022-05-11 12:29:40','',''),(2645135,'1','186','940',419,'Retail Sale Id 1636952',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 12:31:47','',''),(2645136,'1','186','940',419,'Retail Sale Id 1636953',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 12:33:05','',''),(2645137,'1','186','940',419,'Retail Sale Id 1636954',32480.00,0.00,0.00,56.00,1120.00,'2022-05-11 12:34:42','',''),(2645138,'1','186','940',419,'Retail Sale Id 1636955',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 12:37:16','',''),(2645139,'1','186','940',419,'Retail Sale Id 1636956',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 12:39:14','',''),(2645140,'1','186','940',419,'Retail Sale Id 1636957',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 12:40:42','',''),(2645141,'1','186','940',419,'Retail Sale Id 1636958',10540.00,0.00,0.00,17.00,1020.00,'2022-05-11 12:41:49','',''),(2645142,'1','186','940',419,'Retail Sale Id 1636959',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 12:46:05','',''),(2645143,'1','186','940',419,'Retail Sale Id 1636960',87000.00,0.00,0.00,150.00,3000.00,'2022-05-11 12:47:34','',''),(2645144,'1','186','940',419,'Retail Sale Id 1636961',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 12:50:24','',''),(2645145,'1','186','940',419,'Retail Sale Id 1636962',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 12:52:09','',''),(2645146,'1','186','940',419,'Retail Sale Id 1636964',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 12:53:05','',''),(2645147,'1','186','940',419,'Retail Sale Id 1636965',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 12:53:50','',''),(2645148,'1','186','940',419,'Retail Sale Id 1636966',3701.40,0.00,0.00,5.97,358.20,'2022-05-11 12:54:59','',''),(2645149,'1','186','940',419,'Retail Sale Id 1636967',6001.60,0.00,0.00,9.68,580.80,'2022-05-11 12:56:03','',''),(2645150,'1','186','940',419,'Retail Sale Id 1636968',12400.00,0.00,0.00,20.00,1200.00,'2022-05-11 12:59:50','',''),(2645151,'1','186','940',419,'Retail Sale Id 1636969',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 13:03:24','',''),(2645152,'1','186','940',419,'Retail Sale Id 1636970',998.20,0.00,0.00,1.61,96.60,'2022-05-11 13:05:26','',''),(2645153,'1','186','940',419,'Retail Sale Id 1636971',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 13:06:34','',''),(2645154,'1','186','940',419,'Retail Sale Id 1636972',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 13:08:16','',''),(2645155,'1','186','940',419,'Retail Sale Id 1636973',3503.00,0.00,0.00,5.65,339.00,'2022-05-11 13:10:25','',''),(2645156,'1','186','940',419,'Retail Sale Id 1636974',1202.80,0.00,0.00,1.94,116.40,'2022-05-11 13:11:39','',''),(2645157,'1','186','940',419,'Retail Sale Id 1636975',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 13:14:05','',''),(2645158,'1','186','940',419,'Retail Sale Id 1636976',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 13:16:57','',''),(2645159,'1','186','940',419,'Retail Sale Id 1636977',232000.00,0.00,0.00,400.00,8000.00,'2022-05-11 13:22:54','',''),(2645160,'1','186','940',419,'Retail Sale Id 1636978',3503.00,0.00,0.00,5.65,339.00,'2022-05-11 13:25:34','',''),(2645161,'1','186','940',419,'Retail Sale Id 1636979',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 13:32:10','',''),(2645162,'1','186','940',419,'Retail Sale Id 1636980',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 13:34:25','',''),(2645163,'1','186','940',419,'Retail Sale Id 1636981',10230.00,0.00,0.00,16.50,990.00,'2022-05-11 13:38:19','',''),(2645164,'1','186','940',419,'Retail Sale Id 1636982',6820.00,0.00,0.00,11.00,660.00,'2022-05-11 13:39:23','',''),(2645165,'1','186','940',419,'Retail Sale Id 1636983',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 13:40:52','',''),(2645166,'1','186','940',419,'Retail Sale Id 1636984',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 13:41:58','',''),(2645167,'1','186','940',419,'Retail Sale Id 1636985',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 13:45:43','',''),(2645168,'1','186','940',419,'Retail Sale Id 1636986',15500.00,0.00,0.00,25.00,1500.00,'2022-05-11 13:48:41','',''),(2645169,'1','186','940',419,'Retail Sale Id 1636987',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 13:50:01','',''),(2645170,'1','186','940',419,'Retail Sale Id 1636988',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 13:51:47','',''),(2645171,'1','186','940',419,'Retail Sale Id 1636989',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 13:53:49','',''),(2645172,'1','186','940',419,'Retail Sale Id 1636990',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 13:54:57','',''),(2645173,'1','186','940',419,'Retail Sale Id 1636991',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 13:56:56','',''),(2645174,'1','186','940',419,'Retail Sale Id 1636992',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 13:58:00','',''),(2645175,'1','186','940',419,'Retail Sale Id 1636993',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 14:01:47','',''),(2645176,'1','186','940',419,'Retail Sale Id 1636994',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 14:02:46','',''),(2645177,'1','186','940',419,'Retail Sale Id 1636995',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 14:04:04','',''),(2645178,'1','186','940',419,'Retail Sale Id 1636996',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 14:05:00','',''),(2645179,'1','186','940',419,'Retail Sale Id 1636997',64960.00,0.00,0.00,112.00,2240.00,'2022-05-11 14:07:11','',''),(2645180,'1','186','940',419,'Retail Sale Id 1636998',11470.00,0.00,0.00,18.50,1110.00,'2022-05-11 14:08:55','',''),(2645181,'1','186','940',419,'Retail Sale Id 1636999',12400.00,0.00,0.00,20.00,1200.00,'2022-05-11 14:11:33','',''),(2645182,'1','186','940',419,'Retail Sale Id 1637000',4997.20,0.00,0.00,8.06,483.60,'2022-05-11 14:13:41','',''),(2645183,'1','186','940',419,'Retail Sale Id 1637001',998.20,0.00,0.00,1.61,96.60,'2022-05-11 14:16:07','',''),(2645184,'1','186','940',419,'Retail Sale Id 1637002',4340.00,0.00,0.00,7.00,420.00,'2022-05-11 14:20:15','',''),(2645185,'1','186','940',419,'Retail Sale Id 1637003',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 14:22:02','',''),(2645186,'1','186','940',419,'Retail Sale Id 1637004',34800.00,0.00,0.00,60.00,1200.00,'2022-05-11 14:24:53','',''),(2645187,'1','186','940',419,'Retail Sale Id 1637005',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 14:26:49','',''),(2645188,'1','186','940',419,'Retail Sale Id 1637006',30450.00,0.00,0.00,52.50,1050.00,'2022-05-11 14:30:34','',''),(2645189,'1','186','940',419,'Retail Sale Id 1637007',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 14:33:20','',''),(2645190,'1','186','940',419,'Retail Sale Id 1637008',7502.00,0.00,0.00,12.10,726.00,'2022-05-11 14:34:27','',''),(2645191,'1','186','940',419,'Retail Sale Id 1637009',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 14:35:24','',''),(2645192,'1','186','940',419,'Retail Sale Id 1637010',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 14:35:54','',''),(2645193,'1','186','940',419,'Retail Sale Id 1637011',17400.00,0.00,0.00,30.00,600.00,'2022-05-11 14:36:55','',''),(2645194,'1','186','940',419,'Retail Sale Id 1637012',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 14:37:43','',''),(2645195,'1','186','940',419,'Retail Sale Id 1637013',7502.00,0.00,0.00,12.10,726.00,'2022-05-11 14:39:57','',''),(2645196,'1','186','940',419,'Retail Sale Id 1637014',4340.00,0.00,0.00,7.00,420.00,'2022-05-11 14:42:37','',''),(2645197,'1','186','940',419,'Retail Sale Id 1637015',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 14:45:16','',''),(2645198,'1','186','940',419,'Retail Sale Id 1637016',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 14:47:33','',''),(2645199,'1','186','940',419,'Retail Sale Id 1637017',6999.80,0.00,0.00,11.29,677.40,'2022-05-11 14:48:33','',''),(2645200,'1','186','940',419,'Retail Sale Id 1637018',75826.00,0.00,0.00,122.30,7338.00,'2022-05-11 14:50:17','',''),(2645201,'1','186','940',419,'Retail Sale Id 1637019',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 14:51:25','',''),(2645202,'1','186','940',419,'Retail Sale Id 1637020',7502.00,0.00,0.00,12.10,726.00,'2022-05-11 14:56:01','',''),(2645203,'1','186','940',419,'Retail Sale Id 1637021',3999.00,0.00,0.00,6.45,387.00,'2022-05-11 15:00:43','',''),(2645204,'1','186','940',419,'Retail Sale Id 1637024',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 15:04:03','',''),(2645205,'1','186','940',419,'Retail Sale Id 1637025',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:05:15','',''),(2645206,'1','186','940',419,'Retail Sale Id 1637026',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 15:07:43','',''),(2645207,'1','186','940',419,'Retail Sale Id 1637027',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 15:09:17','',''),(2645208,'1','186','940',419,'Retail Sale Id 1637028',3999.00,0.00,0.00,6.45,387.00,'2022-05-11 15:10:44','',''),(2645209,'1','186','940',419,'Retail Sale Id 1637029',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 15:11:27','',''),(2645210,'1','186','940',419,'Retail Sale Id 1637030',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 15:13:16','',''),(2645211,'1','186','940',419,'Retail Sale Id 1637031',116000.00,0.00,0.00,200.00,4000.00,'2022-05-11 15:18:43','',''),(2645212,'1','186','940',419,'Retail Sale Id 1637032',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:24:16','',''),(2645213,'1','186','940',419,'Retail Sale Id 1637033',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 15:24:42','',''),(2645214,'1','186','940',419,'Retail Sale Id 1637034',115200.00,0.00,0.00,200.00,3200.00,'2022-05-11 15:26:02','',''),(2645215,'1','186','940',419,'Retail Sale Id 1637035',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:27:09','',''),(2645216,'1','186','940',419,'Retail Sale Id 1637036',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 15:28:03','',''),(2645217,'1','186','940',419,'Retail Sale Id 1637037',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:28:43','',''),(2645218,'1','186','940',419,'Retail Sale Id 1637038',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 15:29:25','',''),(2645219,'1','186','940',419,'Retail Sale Id 1637039',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 15:30:01','',''),(2645220,'1','186','940',419,'Retail Sale Id 1637040',115600.00,0.00,0.00,200.00,3600.00,'2022-05-11 15:34:10','',''),(2645221,'1','186','940',419,'Retail Sale Id 1637041',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 15:35:36','',''),(2645222,'1','186','940',419,'Retail Sale Id 1637042',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 15:36:32','',''),(2645223,'1','186','940',419,'Retail Sale Id 1637043',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 15:37:50','',''),(2645224,'1','186','940',419,'Retail Sale Id 1637044',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:38:26','',''),(2645225,'1','186','940',419,'Retail Sale Id 1637045',1302.00,0.00,0.00,2.10,126.00,'2022-05-11 15:39:19','',''),(2645226,'1','186','940',419,'Retail Sale Id 1637046',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 15:40:06','',''),(2645227,'1','186','940',419,'Retail Sale Id 1637047',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 15:40:43','',''),(2645228,'1','186','940',419,'Retail Sale Id 1637048',5580.00,0.00,0.00,9.00,540.00,'2022-05-11 15:43:19','',''),(2645229,'1','186','940',419,'Retail Sale Id 1637049',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 15:43:54','',''),(2645230,'1','186','940',419,'Retail Sale Id 1637050',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:45:50','',''),(2645231,'1','186','940',419,'Retail Sale Id 1637051',14500.00,0.00,0.00,25.00,500.00,'2022-05-11 15:46:44','',''),(2645232,'1','186','940',419,'Retail Sale Id 1637052',1550.00,0.00,0.00,2.50,150.00,'2022-05-11 15:48:22','',''),(2645233,'1','186','940',419,'Retail Sale Id 1637054',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 15:49:13','',''),(2645234,'1','186','940',419,'Retail Sale Id 1637055',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 15:50:29','',''),(2645235,'1','186','940',419,'Retail Sale Id 1637057',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 15:52:04','',''),(2645236,'1','186','940',419,'Retail Sale Id 1637058',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 15:52:36','',''),(2645237,'1','186','940',419,'Retail Sale Id 1637059',998.20,0.00,0.00,1.61,96.60,'2022-05-11 15:53:22','',''),(2645238,'1','186','940',419,'Retail Sale Id 1637060',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 15:53:55','',''),(2645239,'1','186','940',419,'Retail Sale Id 1637061',3503.00,0.00,0.00,5.65,339.00,'2022-05-11 15:54:35','',''),(2645240,'1','186','940',419,'Retail Sale Id 1637062',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 15:55:23','',''),(2645241,'1','186','940',419,'Retail Sale Id 1637063',58000.00,0.00,0.00,100.00,2000.00,'2022-05-11 15:56:09','',''),(2645242,'1','186','940',419,'Retail Sale Id 1637064',17400.00,0.00,0.00,30.00,600.00,'2022-05-11 15:56:53','',''),(2645243,'1','186','940',419,'Retail Sale Id 1637065',67280.00,0.00,0.00,116.00,2320.00,'2022-05-11 15:57:38','',''),(2645244,'1','186','940',419,'Retail Sale Id 1637066',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 15:59:10','',''),(2645245,'1','186','940',419,'Retail Sale Id 1637067',1897.20,0.00,0.00,3.06,183.60,'2022-05-11 15:59:48','',''),(2645246,'1','186','940',419,'Retail Sale Id 1637068',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 16:00:27','',''),(2645247,'1','186','940',419,'Retail Sale Id 1637069',14997.80,0.00,0.00,24.19,1451.40,'2022-05-11 16:01:13','',''),(2645248,'1','186','940',419,'Retail Sale Id 1637070',1897.20,0.00,0.00,3.06,183.60,'2022-05-11 16:01:56','',''),(2645249,'1','186','940',419,'Retail Sale Id 1637071',87000.00,0.00,0.00,150.00,3000.00,'2022-05-11 16:02:54','',''),(2645250,'1','186','940',419,'Retail Sale Id 1637072',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 16:03:36','',''),(2645251,'1','186','940',419,'Retail Sale Id 1637073',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 16:04:13','',''),(2645252,'1','186','940',419,'Retail Sale Id 1637074',4997.20,0.00,0.00,8.06,483.60,'2022-05-11 16:06:18','',''),(2645253,'1','186','940',419,'Retail Sale Id 1637075',58000.00,0.00,0.00,100.00,2000.00,'2022-05-11 16:07:33','',''),(2645254,'1','186','940',419,'Retail Sale Id 1637076',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 16:08:55','',''),(2645255,'1','186','940',419,'Retail Sale Id 1637077',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 16:09:32','',''),(2645256,'1','186','940',419,'Retail Sale Id 1637078',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 16:11:31','',''),(2645257,'1','186','940',419,'Retail Sale Id 1637079',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 16:14:13','',''),(2645258,'1','186','940',419,'Retail Sale Id 1637080',2201.00,0.00,0.00,3.55,213.00,'2022-05-11 16:16:15','',''),(2645259,'1','186','940',419,'Retail Sale Id 1637082',1302.00,0.00,0.00,2.10,126.00,'2022-05-11 16:17:12','',''),(2645260,'1','186','940',419,'Retail Sale Id 1637083',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 16:18:10','',''),(2645261,'1','186','940',419,'Retail Sale Id 1637084',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 16:18:56','',''),(2645262,'1','186','940',419,'Retail Sale Id 1637085',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 16:19:31','',''),(2645263,'1','186','940',419,'Retail Sale Id 1637086',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 16:20:09','',''),(2645264,'1','186','940',419,'Retail Sale Id 1637087',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 16:20:58','',''),(2645265,'1','186','940',419,'Retail Sale Id 1637089',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 16:22:32','',''),(2645266,'1','186','940',419,'Retail Sale Id 1637090',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 16:25:03','',''),(2645267,'1','186','940',419,'Retail Sale Id 1637091',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 16:29:12','',''),(2645268,'1','186','940',419,'Retail Sale Id 1637092',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 16:30:37','',''),(2645269,'1','186','940',419,'Retail Sale Id 1637093',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 16:31:39','',''),(2645270,'1','186','940',419,'Retail Sale Id 1637094',3199.20,0.00,0.00,5.16,309.60,'2022-05-11 16:32:41','',''),(2645271,'1','186','940',419,'Retail Sale Id 1637095',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 16:33:58','',''),(2645272,'1','186','940',419,'Retail Sale Id 1637096',34800.00,0.00,0.00,60.00,1200.00,'2022-05-11 16:35:22','',''),(2645273,'1','186','940',419,'Retail Sale Id 1637097',111940.00,0.00,0.00,193.00,3860.00,'2022-05-11 16:36:41','',''),(2645274,'1','186','940',419,'Retail Sale Id 1637098',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 16:38:12','',''),(2645275,'1','186','940',419,'Retail Sale Id 1637099',998.20,0.00,0.00,1.61,96.60,'2022-05-11 16:38:44','',''),(2645276,'1','186','940',419,'Retail Sale Id 1637100',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 16:39:17','',''),(2645277,'1','186','940',419,'Retail Sale Id 1637101',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 16:40:22','',''),(2645278,'1','186','940',419,'Retail Sale Id 1637102',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 16:41:32','',''),(2645279,'1','186','940',419,'Retail Sale Id 1637103',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 16:42:29','',''),(2645280,'1','186','940',419,'Retail Sale Id 1637104',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 16:44:27','',''),(2645281,'1','186','940',419,'Retail Sale Id 1637105',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 16:48:10','',''),(2645282,'1','186','940',419,'Retail Sale Id 1637106',1897.20,0.00,0.00,3.06,183.60,'2022-05-11 16:55:52','',''),(2645283,'1','186','940',419,'Retail Sale Id 1637107',6200.00,0.00,0.00,10.00,600.00,'2022-05-11 16:56:38','',''),(2645284,'1','186','940',419,'Retail Sale Id 1637108',1847.60,0.00,0.00,2.98,178.80,'2022-05-11 16:57:24','',''),(2645285,'1','186','940',419,'Retail Sale Id 1637109',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 16:58:10','',''),(2645286,'1','186','940',419,'Retail Sale Id 1637110',6999.80,0.00,0.00,11.29,677.40,'2022-05-11 16:58:54','',''),(2645287,'1','186','940',419,'Retail Sale Id 1637111',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 16:59:57','',''),(2645288,'1','186','940',419,'Retail Sale Id 1637112',6001.60,0.00,0.00,9.68,580.80,'2022-05-11 17:00:40','',''),(2645289,'1','186','940',419,'Retail Sale Id 1637113',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:06:20','',''),(2645290,'1','186','940',419,'Retail Sale Id 1637115',921600.00,0.00,0.00,1600.00,25600.00,'2022-05-11 17:07:41','',''),(2645291,'1','186','940',419,'Retail Sale Id 1637116',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:09:47','',''),(2645292,'1','186','940',419,'Retail Sale Id 1637117',116000.00,0.00,0.00,200.00,4000.00,'2022-05-11 17:11:42','',''),(2645293,'1','186','940',419,'Retail Sale Id 1637118',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 17:12:33','',''),(2645294,'1','186','940',419,'Retail Sale Id 1637119',3503.00,0.00,0.00,5.65,339.00,'2022-05-11 17:13:04','',''),(2645295,'1','186','940',419,'Retail Sale Id 1637120',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 17:14:10','',''),(2645296,'1','186','940',419,'Retail Sale Id 1637121',998.20,0.00,0.00,1.61,96.60,'2022-05-11 17:14:40','',''),(2645297,'1','186','940',419,'Retail Sale Id 1637122',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 17:15:09','',''),(2645298,'1','186','940',419,'Retail Sale Id 1637123',11600.00,0.00,0.00,20.00,400.00,'2022-05-11 17:15:49','',''),(2645299,'1','186','940',419,'Retail Sale Id 1637124',4960.00,0.00,0.00,8.00,480.00,'2022-05-11 17:18:28','',''),(2645300,'1','186','940',419,'Retail Sale Id 1637125',998.20,0.00,0.00,1.61,96.60,'2022-05-11 17:19:48','',''),(2645301,'1','186','940',419,'Retail Sale Id 1637126',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 17:20:32','',''),(2645302,'1','186','940',419,'Retail Sale Id 1637127',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 17:21:16','',''),(2645303,'1','186','940',419,'Retail Sale Id 1637128',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 17:21:48','',''),(2645304,'1','186','940',419,'Retail Sale Id 1637129',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 17:22:16','',''),(2645305,'1','186','940',419,'Retail Sale Id 1637130',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 17:22:57','',''),(2645306,'1','186','940',419,'Retail Sale Id 1637131',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 17:23:38','',''),(2645307,'1','186','940',419,'Retail Sale Id 1637132',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 17:24:04','',''),(2645308,'1','186','940',419,'Retail Sale Id 1637133',5580.00,0.00,0.00,9.00,540.00,'2022-05-11 17:24:46','',''),(2645309,'1','186','940',419,'Retail Sale Id 1637134',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:25:17','',''),(2645310,'1','186','940',419,'Retail Sale Id 1637135',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 17:25:48','',''),(2645311,'1','186','940',419,'Retail Sale Id 1637136',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 17:26:32','',''),(2645312,'1','186','940',419,'Retail Sale Id 1637137',52200.00,0.00,0.00,90.00,1800.00,'2022-05-11 17:27:11','',''),(2645313,'1','186','940',419,'Retail Sale Id 1637138',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 17:27:38','',''),(2645314,'1','186','940',419,'Retail Sale Id 1637139',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 17:28:30','',''),(2645315,'1','186','940',419,'Retail Sale Id 1637140',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 17:29:30','',''),(2645316,'1','186','940',419,'Retail Sale Id 1637141',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 17:30:11','',''),(2645317,'1','186','940',419,'Retail Sale Id 1637142',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 17:30:57','',''),(2645318,'1','186','940',419,'Retail Sale Id 1637143',2480.00,0.00,0.00,4.00,240.00,'2022-05-11 17:31:33','',''),(2645319,'1','186','940',419,'Retail Sale Id 1637144',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 17:32:52','',''),(2645320,'1','186','940',419,'Retail Sale Id 1637145',4340.00,0.00,0.00,7.00,420.00,'2022-05-11 17:33:41','',''),(2645321,'1','186','940',419,'Retail Sale Id 1637147',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:34:42','',''),(2645322,'1','186','940',419,'Retail Sale Id 1637148',3800.60,0.00,0.00,6.13,367.80,'2022-05-11 17:36:24','',''),(2645323,'1','186','940',419,'Retail Sale Id 1637149',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:37:10','',''),(2645324,'1','186','940',419,'Retail Sale Id 1637150',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 17:37:40','',''),(2645325,'1','186','940',419,'Retail Sale Id 1637151',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 17:38:15','',''),(2645326,'1','186','940',419,'Retail Sale Id 1637152',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 17:38:53','',''),(2645327,'1','186','940',419,'Retail Sale Id 1637153',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 17:40:06','',''),(2645328,'1','186','940',419,'Retail Sale Id 1637154',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 17:41:02','',''),(2645329,'1','186','940',419,'Retail Sale Id 1637155',15080.00,0.00,0.00,26.00,520.00,'2022-05-11 17:41:50','',''),(2645330,'1','186','940',419,'Retail Sale Id 1637156',17980.00,0.00,0.00,31.00,620.00,'2022-05-11 17:42:38','',''),(2645331,'1','186','940',419,'Retail Sale Id 1637157',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 17:43:25','',''),(2645332,'1','186','940',419,'Retail Sale Id 1637158',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 17:44:30','',''),(2645333,'1','186','940',419,'Retail Sale Id 1637159',6999.80,0.00,0.00,11.29,677.40,'2022-05-11 17:45:28','',''),(2645334,'1','186','940',419,'Retail Sale Id 1637160',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 17:46:03','',''),(2645335,'1','186','940',419,'Retail Sale Id 1637161',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 17:46:50','',''),(2645336,'1','186','940',419,'Retail Sale Id 1637162',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 17:47:44','',''),(2645337,'1','186','940',419,'Retail Sale Id 1637163',23200.00,0.00,0.00,40.00,800.00,'2022-05-11 17:48:23','',''),(2645338,'1','186','940',419,'Retail Sale Id 1637164',23200.00,0.00,0.00,40.00,800.00,'2022-05-11 17:49:47','',''),(2645339,'1','186','940',419,'Retail Sale Id 1637165',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:50:31','',''),(2645340,'1','186','940',419,'Retail Sale Id 1637166',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 17:51:15','',''),(2645341,'1','186','940',419,'Retail Sale Id 1637168',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 17:52:11','',''),(2645342,'1','186','940',419,'Retail Sale Id 1637169',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 17:52:41','',''),(2645343,'1','186','940',419,'Retail Sale Id 1637170',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 17:53:29','',''),(2645344,'1','186','940',419,'Retail Sale Id 1637171',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 17:54:24','',''),(2645345,'1','186','940',419,'Retail Sale Id 1637172',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 17:56:20','',''),(2645346,'1','186','940',419,'Retail Sale Id 1637173',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 17:57:05','',''),(2645347,'1','186','940',419,'Retail Sale Id 1637174',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 17:58:14','',''),(2645348,'1','186','940',419,'Retail Sale Id 1637175',4997.20,0.00,0.00,8.06,483.60,'2022-05-11 17:59:27','',''),(2645349,'1','186','940',419,'Retail Sale Id 1637176',8060.00,0.00,0.00,13.00,780.00,'2022-05-11 18:01:20','',''),(2645350,'1','186','940',419,'Retail Sale Id 1637177',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 18:02:31','',''),(2645351,'1','186','940',419,'Retail Sale Id 1637178',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 18:03:42','',''),(2645352,'1','186','940',419,'Retail Sale Id 1637179',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 18:04:15','',''),(2645353,'1','186','940',419,'Retail Sale Id 1637180',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 18:05:01','',''),(2645354,'1','186','940',419,'Retail Sale Id 1637181',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 18:05:46','',''),(2645355,'1','186','940',419,'Retail Sale Id 1637182',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 18:06:18','',''),(2645356,'1','186','940',419,'Retail Sale Id 1637183',31900.00,0.00,0.00,55.00,1100.00,'2022-05-11 18:07:44','',''),(2645357,'1','186','940',419,'Retail Sale Id 1637184',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 18:08:18','',''),(2645358,'1','186','940',419,'Retail Sale Id 1637185',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 18:09:05','',''),(2645359,'1','186','940',419,'Retail Sale Id 1637186',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 18:10:22','',''),(2645360,'1','186','940',419,'Retail Sale Id 1637187',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 18:12:27','',''),(2645361,'1','186','940',419,'Retail Sale Id 1637188',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 18:13:11','',''),(2645362,'1','186','940',419,'Retail Sale Id 1637189',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 18:14:07','',''),(2645363,'1','186','940',419,'Retail Sale Id 1637190',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 18:14:50','',''),(2645364,'1','186','940',419,'Retail Sale Id 1637191',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 18:16:22','',''),(2645365,'1','186','940',419,'Retail Sale Id 1637192',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 18:16:49','',''),(2645366,'1','186','940',419,'Retail Sale Id 1637193',1798.00,0.00,0.00,2.90,174.00,'2022-05-11 18:19:08','',''),(2645367,'1','186','940',419,'Retail Sale Id 1637194',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 18:19:53','',''),(2645368,'1','186','940',419,'Retail Sale Id 1637195',1302.00,0.00,0.00,2.10,126.00,'2022-05-11 18:20:34','',''),(2645369,'1','186','940',419,'Retail Sale Id 1637196',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 18:21:19','',''),(2645370,'1','186','940',419,'Retail Sale Id 1637197',7502.00,0.00,0.00,12.10,726.00,'2022-05-11 18:22:43','',''),(2645371,'1','186','940',419,'Retail Sale Id 1637198',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 18:23:49','',''),(2645372,'1','186','940',419,'Retail Sale Id 1637199',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 18:26:53','',''),(2645373,'1','186','940',419,'Retail Sale Id 1637200',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 18:28:03','',''),(2645374,'1','186','940',419,'Retail Sale Id 1637202',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 18:28:57','',''),(2645375,'1','186','940',419,'Retail Sale Id 1637203',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 18:29:45','',''),(2645376,'1','186','940',419,'Retail Sale Id 1637204',998.20,0.00,0.00,1.61,96.60,'2022-05-11 18:30:16','',''),(2645377,'1','186','940',419,'Retail Sale Id 1637205',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 18:30:55','',''),(2645378,'1','186','940',419,'Retail Sale Id 1637206',14880.00,0.00,0.00,24.00,1440.00,'2022-05-11 18:32:01','',''),(2645379,'1','186','940',419,'Retail Sale Id 1637207',3000.80,0.00,0.00,4.84,290.40,'2022-05-11 18:33:38','',''),(2645380,'1','186','940',419,'Retail Sale Id 1637208',13001.40,0.00,0.00,20.97,1258.20,'2022-05-11 18:34:22','',''),(2645381,'1','186','940',419,'Retail Sale Id 1637209',998.20,0.00,0.00,1.61,96.60,'2022-05-11 18:35:33','',''),(2645382,'1','186','940',419,'Retail Sale Id 1637210',998.20,0.00,0.00,1.61,96.60,'2022-05-11 18:36:33','',''),(2645383,'1','186','940',419,'Retail Sale Id 1637211',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 18:37:14','',''),(2645384,'1','186','940',419,'Retail Sale Id 1637212',1860.00,0.00,0.00,3.00,180.00,'2022-05-11 18:38:14','',''),(2645385,'1','186','940',419,'Retail Sale Id 1637213',7440.00,0.00,0.00,12.00,720.00,'2022-05-11 18:39:47','',''),(2645386,'1','186','940',419,'Retail Sale Id 1637214',317900.00,0.00,0.00,550.00,9900.00,'2022-05-11 18:42:39','',''),(2645387,'1','186','940',419,'Retail Sale Id 1637215',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 18:43:55','',''),(2645388,'1','186','940',419,'Retail Sale Id 1637216',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 18:44:48','',''),(2645389,'1','186','940',419,'Retail Sale Id 1637217',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 18:45:51','',''),(2645390,'1','186','940',419,'Retail Sale Id 1637218',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 18:46:29','',''),(2645391,'1','186','940',419,'Retail Sale Id 1637219',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 18:47:13','',''),(2645392,'1','186','940',419,'Retail Sale Id 1637220',998.20,0.00,0.00,1.61,96.60,'2022-05-11 18:49:54','',''),(2645393,'1','186','940',419,'Retail Sale Id 1637221',6200.00,0.00,0.00,10.00,600.00,'2022-05-11 18:50:40','',''),(2645394,'1','186','940',419,'Retail Sale Id 1637222',4997.20,0.00,0.00,8.06,483.60,'2022-05-11 18:51:26','',''),(2645395,'1','186','940',419,'Retail Sale Id 1637223',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 18:51:57','',''),(2645396,'1','186','940',419,'Retail Sale Id 1637225',23200.00,0.00,0.00,40.00,800.00,'2022-05-11 18:54:03','',''),(2645397,'1','186','940',419,'Retail Sale Id 1637226',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 18:55:06','',''),(2645398,'1','186','940',419,'Retail Sale Id 1637227',1599.60,0.00,0.00,2.58,154.80,'2022-05-11 18:55:37','',''),(2645399,'1','186','940',419,'Retail Sale Id 1637228',1500.40,0.00,0.00,2.42,145.20,'2022-05-11 18:56:01','',''),(2645400,'1','186','940',419,'Retail Sale Id 1637229',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 18:57:10','',''),(2645401,'1','186','940',419,'Retail Sale Id 1637231',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 18:57:51','',''),(2645402,'1','186','940',419,'Retail Sale Id 1637232',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 18:58:55','',''),(2645403,'1','186','940',419,'Retail Sale Id 1637233',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 18:59:59','',''),(2645404,'1','186','940',419,'Retail Sale Id 1637234',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 19:00:40','',''),(2645405,'1','186','940',419,'Retail Sale Id 1637236',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 19:02:25','',''),(2645406,'1','186','940',419,'Retail Sale Id 1637237',1240.00,0.00,0.00,2.00,120.00,'2022-05-11 19:03:53','',''),(2645407,'1','186','940',419,'Retail Sale Id 1637238',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 19:04:56','',''),(2645408,'1','186','940',419,'Retail Sale Id 1637239',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 19:06:01','',''),(2645409,'1','186','940',419,'Retail Sale Id 1637240',2498.60,0.00,0.00,4.03,241.80,'2022-05-11 19:07:04','',''),(2645410,'1','186','940',419,'Retail Sale Id 1637241',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 19:07:44','',''),(2645411,'1','186','940',419,'Retail Sale Id 1637242',998.20,0.00,0.00,1.61,96.60,'2022-05-11 19:08:25','',''),(2645412,'1','186','940',419,'Retail Sale Id 1637243',998.20,0.00,0.00,1.61,96.60,'2022-05-11 19:09:29','',''),(2645413,'1','186','940',419,'Retail Sale Id 1637244',3720.00,0.00,0.00,6.00,360.00,'2022-05-11 19:10:15','',''),(2645414,'1','186','940',419,'Retail Sale Id 1637245',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 19:10:54','',''),(2645415,'1','186','940',419,'Retail Sale Id 1637246',3100.00,0.00,0.00,5.00,300.00,'2022-05-11 19:11:53','',''),(2645416,'1','186','940',419,'Retail Sale Id 1637247',2002.60,0.00,0.00,3.23,193.80,'2022-05-11 19:13:07','',''),(2645417,'1','186','940',419,'Retail Sale Id 1637248',7750.00,0.00,0.00,12.50,750.00,'2022-05-11 19:13:45','',''),(2645418,'1','186','940',419,'Retail Sale Id 1637249',998.20,0.00,0.00,1.61,96.60,'2022-05-11 19:16:24','',''),(2645419,'1','186','940',419,'Retail Sale Id 1637250',29000.00,0.00,0.00,50.00,1000.00,'2022-05-11 19:17:18','',''),(2645420,'1','186','940',419,'Retail Sale Id 1637251',1302.00,0.00,0.00,2.10,126.00,'2022-05-11 19:18:04','',''),(2645421,'1','186','940',419,'Retail Sale Id 1637252',674487.80,0.00,0.00,1162.91,23258.20,'2022-05-11 21:27:08','',''),(2645422,'1','186','940',419,'Retail Sale Id 1637253',315604.80,0.00,0.00,509.04,30542.40,'2022-05-11 21:29:33','',''),(2645423,'1','186','940',419,'Retail Sale Id 1637254',3701.40,0.00,0.00,5.97,358.20,'2022-05-12 07:16:17','',''),(2645424,'1','186','940',419,'Retail Sale Id 1637255',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 07:17:29','',''),(2645425,'1','186','940',419,'Retail Sale Id 1637256',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 07:18:15','',''),(2645426,'1','186','940',419,'Retail Sale Id 1637257',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 07:19:04','',''),(2645427,'1','186','940',419,'Retail Sale Id 1637258',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 07:20:20','',''),(2645428,'1','186','940',419,'Retail Sale Id 1637259',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 07:23:13','',''),(2645429,'1','186','940',419,'Retail Sale Id 1637260',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 07:24:11','',''),(2645430,'1','186','940',419,'Retail Sale Id 1637261',3999.00,0.00,0.00,6.45,387.00,'2022-05-12 07:24:58','',''),(2645431,'1','186','940',419,'Retail Sale Id 1637262',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 07:26:54','',''),(2645432,'1','186','940',419,'Retail Sale Id 1637263',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 07:34:31','',''),(2645433,'1','186','940',419,'Retail Sale Id 1637264',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 07:35:47','',''),(2645434,'1','186','940',419,'Retail Sale Id 1637265',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 07:37:09','',''),(2645435,'1','186','940',419,'Retail Sale Id 1637266',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 07:37:44','',''),(2645436,'1','186','940',419,'Retail Sale Id 1637267',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 07:39:12','',''),(2645437,'1','186','940',419,'Retail Sale Id 1637268',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 07:39:59','',''),(2645438,'1','186','940',419,'Retail Sale Id 1637269',14500.00,0.00,0.00,25.00,500.00,'2022-05-12 07:43:33','',''),(2645439,'1','186','940',419,'Retail Sale Id 1637270',69600.00,0.00,0.00,120.00,2400.00,'2022-05-12 07:50:50','',''),(2645440,'1','186','940',419,'Retail Sale Id 1637271',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 07:52:10','',''),(2645441,'1','186','940',419,'Retail Sale Id 1637272',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 07:53:43','',''),(2645442,'1','186','940',419,'Retail Sale Id 1637273',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 07:55:14','',''),(2645443,'1','186','940',419,'Retail Sale Id 1637274',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 07:57:47','',''),(2645444,'1','186','940',419,'Retail Sale Id 1637275',998.20,0.00,0.00,1.61,96.60,'2022-05-12 07:59:43','',''),(2645445,'1','186','940',419,'Retail Sale Id 1637276',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 08:00:22','',''),(2645446,'1','186','940',419,'Retail Sale Id 1637277',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 08:00:58','',''),(2645447,'1','186','940',419,'Retail Sale Id 1637278',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 08:01:46','',''),(2645448,'1','186','940',419,'Retail Sale Id 1637279',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 08:02:57','',''),(2645449,'1','186','940',419,'Retail Sale Id 1637280',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 08:03:43','',''),(2645450,'1','186','940',419,'Retail Sale Id 1637281',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 08:06:38','',''),(2645451,'1','186','940',419,'Retail Sale Id 1637282',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 08:08:31','',''),(2645452,'1','186','940',419,'Retail Sale Id 1637283',11600.00,0.00,0.00,20.00,400.00,'2022-05-12 08:10:24','',''),(2645453,'1','186','940',419,'Retail Sale Id 1637284',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 08:11:26','',''),(2645454,'1','186','940',419,'Retail Sale Id 1637285',6999.80,0.00,0.00,11.29,677.40,'2022-05-12 08:12:15','',''),(2645455,'1','186','940',419,'Retail Sale Id 1637286',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 08:12:59','',''),(2645456,'1','186','940',419,'Retail Sale Id 1637287',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 08:13:34','',''),(2645457,'1','186','940',419,'Retail Sale Id 1637288',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 08:14:10','',''),(2645458,'1','186','940',419,'Retail Sale Id 1637289',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 08:15:37','',''),(2645459,'1','186','940',419,'Retail Sale Id 1637290',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 08:16:57','',''),(2645460,'1','186','940',419,'Retail Sale Id 1637291',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 08:17:37','',''),(2645461,'1','186','940',419,'Retail Sale Id 1637292',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 08:18:32','',''),(2645462,'1','186','940',419,'Retail Sale Id 1637293',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 08:20:00','',''),(2645463,'1','186','940',419,'Retail Sale Id 1637294',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 08:21:03','',''),(2645464,'1','186','940',419,'Retail Sale Id 1637295',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 08:21:36','',''),(2645465,'1','186','940',419,'Retail Sale Id 1637296',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 08:22:41','',''),(2645466,'1','186','940',419,'Retail Sale Id 1637297',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 08:23:51','',''),(2645467,'1','186','940',419,'Retail Sale Id 1637298',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 08:24:23','',''),(2645468,'1','186','940',419,'Retail Sale Id 1637299',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 08:25:05','',''),(2645469,'1','186','940',419,'Retail Sale Id 1637301',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 08:26:24','',''),(2645470,'1','186','940',419,'Retail Sale Id 1637302',33640.00,0.00,0.00,58.00,1160.00,'2022-05-12 08:27:25','',''),(2645471,'1','186','940',419,'Retail Sale Id 1637303',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 08:28:25','',''),(2645472,'1','186','940',419,'Retail Sale Id 1637304',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 08:29:11','',''),(2645473,'1','186','940',419,'Retail Sale Id 1637305',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 08:30:17','',''),(2645474,'1','186','940',419,'Retail Sale Id 1637306',20001.20,0.00,0.00,32.26,1935.60,'2022-05-12 08:31:32','',''),(2645475,'1','186','940',419,'Retail Sale Id 1637307',8556.00,0.00,0.00,13.80,828.00,'2022-05-12 08:34:05','',''),(2645476,'1','186','940',419,'Retail Sale Id 1637308',4997.20,0.00,0.00,8.06,483.60,'2022-05-12 08:34:55','',''),(2645477,'1','186','940',419,'Retail Sale Id 1637309',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 08:38:47','',''),(2645478,'1','186','940',419,'Retail Sale Id 1637310',4340.00,0.00,0.00,7.00,420.00,'2022-05-12 08:40:34','',''),(2645479,'1','186','940',419,'Retail Sale Id 1637311',998.20,0.00,0.00,1.61,96.60,'2022-05-12 08:43:06','',''),(2645480,'1','186','940',419,'Retail Sale Id 1637312',23200.00,0.00,0.00,40.00,800.00,'2022-05-12 08:44:50','',''),(2645481,'1','186','940',419,'Retail Sale Id 1637313',998.20,0.00,0.00,1.61,96.60,'2022-05-12 08:46:07','',''),(2645482,'1','186','940',419,'Retail Sale Id 1637314',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 08:46:55','',''),(2645483,'1','186','940',419,'Retail Sale Id 1637315',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 08:47:47','',''),(2645484,'1','186','940',419,'Retail Sale Id 1637316',23200.00,0.00,0.00,40.00,800.00,'2022-05-12 08:48:39','',''),(2645485,'1','186','940',419,'Retail Sale Id 1637317',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 08:49:29','',''),(2645486,'1','186','940',419,'Retail Sale Id 1637318',14500.00,0.00,0.00,25.00,500.00,'2022-05-12 08:51:20','',''),(2645487,'1','186','940',419,'Retail Sale Id 1637319',998.20,0.00,0.00,1.61,96.60,'2022-05-12 08:53:16','',''),(2645488,'1','186','940',419,'Retail Sale Id 1637320',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 08:56:04','',''),(2645489,'1','186','940',419,'Retail Sale Id 1637321',5580.00,0.00,0.00,9.00,540.00,'2022-05-12 08:58:29','',''),(2645490,'1','186','940',419,'Retail Sale Id 1637322',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 08:59:18','',''),(2645491,'1','186','940',419,'Retail Sale Id 1637323',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 09:00:21','',''),(2645492,'1','186','940',419,'Retail Sale Id 1637324',4960.00,0.00,0.00,8.00,480.00,'2022-05-12 09:01:42','',''),(2645493,'1','186','940',419,'Retail Sale Id 1637325',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 09:03:54','',''),(2645494,'1','186','940',419,'Retail Sale Id 1637326',12400.00,0.00,0.00,20.00,1200.00,'2022-05-12 09:04:48','',''),(2645495,'1','186','940',419,'Retail Sale Id 1637327',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 09:05:48','',''),(2645496,'1','186','940',419,'Retail Sale Id 1637328',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 09:06:35','',''),(2645497,'1','186','940',419,'Retail Sale Id 1637329',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 09:07:27','',''),(2645498,'1','186','940',419,'Retail Sale Id 1637330',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 09:09:49','',''),(2645499,'1','186','940',419,'Retail Sale Id 1637331',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 09:10:32','',''),(2645500,'1','186','940',419,'Retail Sale Id 1637332',10540.00,0.00,0.00,17.00,1020.00,'2022-05-12 09:14:40','',''),(2645501,'1','186','940',419,'Retail Sale Id 1637333',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 09:18:29','',''),(2645502,'1','186','940',419,'Retail Sale Id 1637334',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 09:20:39','',''),(2645503,'1','186','940',419,'Retail Sale Id 1637335',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 09:25:45','',''),(2645504,'1','186','940',419,'Retail Sale Id 1637336',34800.00,0.00,0.00,60.00,1200.00,'2022-05-12 09:28:48','',''),(2645505,'1','186','940',419,'Retail Sale Id 1637337',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 09:30:51','',''),(2645506,'1','186','940',419,'Retail Sale Id 1637338',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 09:32:02','',''),(2645507,'1','186','940',419,'Retail Sale Id 1637339',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 09:32:49','',''),(2645508,'1','186','940',419,'Retail Sale Id 1637340',26100.00,0.00,0.00,45.00,900.00,'2022-05-12 09:35:45','',''),(2645509,'1','186','940',419,'Retail Sale Id 1637341',3999.00,0.00,0.00,6.45,387.00,'2022-05-12 09:37:39','',''),(2645510,'1','186','940',419,'Retail Sale Id 1637342',14500.00,0.00,0.00,25.00,500.00,'2022-05-12 09:39:42','',''),(2645511,'1','186','940',419,'Retail Sale Id 1637343',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 09:41:01','',''),(2645512,'1','186','940',419,'Retail Sale Id 1637344',7502.00,0.00,0.00,12.10,726.00,'2022-05-12 09:41:41','',''),(2645513,'1','186','940',419,'Retail Sale Id 1637345',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 09:43:21','',''),(2645514,'1','186','940',419,'Retail Sale Id 1637346',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 09:44:13','',''),(2645515,'1','186','940',419,'Retail Sale Id 1637347',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 09:44:54','',''),(2645516,'1','186','940',419,'Retail Sale Id 1637348',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 09:45:53','',''),(2645517,'1','186','940',419,'Retail Sale Id 1637349',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 09:46:52','',''),(2645518,'1','186','940',419,'Retail Sale Id 1637350',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 09:47:26','',''),(2645519,'1','186','940',419,'Retail Sale Id 1637351',11470.00,0.00,0.00,18.50,1110.00,'2022-05-12 09:48:12','',''),(2645520,'1','186','940',419,'Retail Sale Id 1637352',17360.00,0.00,0.00,28.00,1680.00,'2022-05-12 09:51:58','',''),(2645521,'1','186','940',419,'Retail Sale Id 1637353',26040.00,0.00,0.00,42.00,2520.00,'2022-05-12 09:54:41','',''),(2645522,'1','186','940',419,'Retail Sale Id 1637354',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 09:55:25','',''),(2645523,'1','186','940',419,'Retail Sale Id 1637355',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 09:57:20','',''),(2645524,'1','186','940',419,'Retail Sale Id 1637356',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 09:57:51','',''),(2645525,'1','186','940',419,'Retail Sale Id 1637357',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 09:58:49','',''),(2645526,'1','186','940',419,'Retail Sale Id 1637358',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 09:59:32','',''),(2645527,'1','186','940',419,'Retail Sale Id 1637359',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 10:00:33','',''),(2645528,'1','186','940',419,'Retail Sale Id 1637360',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 10:06:05','',''),(2645529,'1','186','940',419,'Retail Sale Id 1637361',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 10:06:55','',''),(2645530,'1','186','940',419,'Retail Sale Id 1637362',87000.00,0.00,0.00,150.00,3000.00,'2022-05-12 10:07:48','',''),(2645531,'1','186','940',419,'Retail Sale Id 1637363',20300.00,0.00,0.00,35.00,700.00,'2022-05-12 10:11:44','',''),(2645532,'1','186','940',419,'Retail Sale Id 1637364',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 10:13:05','',''),(2645533,'1','186','940',419,'Retail Sale Id 1637365',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 10:15:30','',''),(2645534,'1','186','940',419,'Retail Sale Id 1637366',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 10:17:20','',''),(2645535,'1','186','940',419,'Retail Sale Id 1637367',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 10:18:49','',''),(2645536,'1','186','940',419,'Retail Sale Id 1637369',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 10:19:24','',''),(2645537,'1','186','940',419,'Retail Sale Id 1637370',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 10:23:35','',''),(2645538,'1','186','940',419,'Retail Sale Id 1637371',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 10:28:35','',''),(2645539,'1','186','940',419,'Retail Sale Id 1637372',998.20,0.00,0.00,1.61,96.60,'2022-05-12 10:29:46','',''),(2645540,'1','186','940',419,'Retail Sale Id 1637373',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 10:31:21','',''),(2645541,'1','186','940',419,'Retail Sale Id 1637374',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 10:33:22','',''),(2645542,'1','186','940',419,'Retail Sale Id 1637375',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 10:35:33','',''),(2645543,'1','186','940',419,'Retail Sale Id 1637376',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 10:39:01','',''),(2645544,'1','186','940',419,'Retail Sale Id 1637377',23250.00,0.00,0.00,37.50,2250.00,'2022-05-12 10:39:37','',''),(2645545,'1','186','940',419,'Retail Sale Id 1637378',5580.00,0.00,0.00,9.00,540.00,'2022-05-12 10:41:01','',''),(2645546,'1','186','940',419,'Retail Sale Id 1637379',5580.00,0.00,0.00,9.00,540.00,'2022-05-12 10:45:03','',''),(2645547,'1','186','940',419,'Retail Sale Id 1637381',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 10:46:35','',''),(2645548,'1','186','940',419,'Retail Sale Id 1637383',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 10:47:57','',''),(2645549,'1','186','940',419,'Retail Sale Id 1637384',998.20,0.00,0.00,1.61,96.60,'2022-05-12 10:48:36','',''),(2645550,'1','186','940',419,'Retail Sale Id 1637385',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 10:49:06','',''),(2645551,'1','186','940',419,'Retail Sale Id 1637386',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 10:49:45','',''),(2645552,'1','186','940',419,'Retail Sale Id 1637387',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 10:50:42','',''),(2645553,'1','186','940',419,'Retail Sale Id 1637388',4997.20,0.00,0.00,8.06,483.60,'2022-05-12 10:51:07','',''),(2645554,'1','186','940',419,'Retail Sale Id 1637390',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 10:52:59','',''),(2645555,'1','186','940',419,'Retail Sale Id 1637391',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 10:53:47','',''),(2645556,'1','186','940',419,'Retail Sale Id 1637392',3800.60,0.00,0.00,6.13,367.80,'2022-05-12 10:56:01','',''),(2645557,'1','186','940',419,'Retail Sale Id 1637393',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 10:56:43','',''),(2645558,'1','186','940',419,'Retail Sale Id 1637394',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 10:57:20','',''),(2645559,'1','186','940',419,'Retail Sale Id 1637395',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 11:00:20','',''),(2645560,'1','186','940',419,'Retail Sale Id 1637396',15660.00,0.00,0.00,27.00,540.00,'2022-05-12 11:01:59','',''),(2645561,'1','186','940',419,'Retail Sale Id 1637397',998.20,0.00,0.00,1.61,96.60,'2022-05-12 11:04:18','',''),(2645562,'1','186','940',419,'Retail Sale Id 1637398',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 11:07:54','',''),(2645563,'1','186','940',419,'Retail Sale Id 1637399',11600.00,0.00,0.00,20.00,400.00,'2022-05-12 11:11:12','',''),(2645564,'1','186','940',419,'Retail Sale Id 1637400',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 11:12:03','',''),(2645565,'1','186','940',419,'Retail Sale Id 1637401',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 11:13:26','',''),(2645566,'1','186','940',419,'Retail Sale Id 1637402',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:14:05','',''),(2645567,'1','186','940',419,'Retail Sale Id 1637403',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:15:26','',''),(2645568,'1','186','940',419,'Retail Sale Id 1637404',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 11:16:18','',''),(2645569,'1','186','940',419,'Retail Sale Id 1637405',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 11:17:09','',''),(2645570,'1','186','940',419,'Retail Sale Id 1637406',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 11:17:49','',''),(2645571,'1','186','940',419,'Retail Sale Id 1637407',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 11:19:21','',''),(2645572,'1','186','940',419,'Retail Sale Id 1637408',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 11:20:39','',''),(2645573,'1','186','940',419,'Retail Sale Id 1637409',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:21:26','',''),(2645574,'1','186','940',419,'Retail Sale Id 1637410',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 11:22:58','',''),(2645575,'1','186','940',419,'Retail Sale Id 1637411',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 11:23:46','',''),(2645576,'1','186','940',419,'Retail Sale Id 1637412',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:24:41','',''),(2645577,'1','186','940',419,'Retail Sale Id 1637413',998.20,0.00,0.00,1.61,96.60,'2022-05-12 11:28:13','',''),(2645578,'1','186','940',419,'Retail Sale Id 1637415',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 11:29:03','',''),(2645579,'1','186','940',419,'Retail Sale Id 1637416',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 11:31:49','',''),(2645580,'1','186','940',419,'Retail Sale Id 1637417',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 11:32:37','',''),(2645581,'1','186','940',419,'Retail Sale Id 1637418',3999.00,0.00,0.00,6.45,387.00,'2022-05-12 11:33:15','',''),(2645582,'1','186','940',419,'Retail Sale Id 1637419',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 11:34:18','',''),(2645583,'1','186','940',419,'Retail Sale Id 1637420',116000.00,0.00,0.00,200.00,4000.00,'2022-05-12 11:36:10','',''),(2645584,'1','186','940',419,'Retail Sale Id 1637421',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 11:36:53','',''),(2645585,'1','186','940',419,'Retail Sale Id 1637422',87000.00,0.00,0.00,150.00,3000.00,'2022-05-12 11:41:08','',''),(2645586,'1','186','940',419,'Retail Sale Id 1637423',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:42:33','',''),(2645587,'1','186','940',419,'Retail Sale Id 1637424',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 11:44:02','',''),(2645588,'1','186','940',419,'Retail Sale Id 1637425',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 11:45:14','',''),(2645589,'1','186','940',419,'Retail Sale Id 1637426',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 11:46:33','',''),(2645590,'1','186','940',419,'Retail Sale Id 1637427',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:48:41','',''),(2645591,'1','186','940',419,'Retail Sale Id 1637428',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 11:54:06','',''),(2645592,'1','186','940',419,'Retail Sale Id 1637429',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 11:55:04','',''),(2645593,'1','186','940',419,'Retail Sale Id 1637430',15500.00,0.00,0.00,25.00,1500.00,'2022-05-12 11:56:26','',''),(2645594,'1','186','940',419,'Retail Sale Id 1637431',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 11:59:36','',''),(2645595,'1','186','940',419,'Retail Sale Id 1637432',10850.00,0.00,0.00,17.50,1050.00,'2022-05-12 12:00:37','',''),(2645596,'1','186','940',419,'Retail Sale Id 1637433',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 12:02:06','',''),(2645597,'1','186','940',419,'Retail Sale Id 1637434',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 12:05:42','',''),(2645598,'1','186','940',419,'Retail Sale Id 1637435',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 12:06:30','',''),(2645599,'1','186','940',419,'Retail Sale Id 1637436',32480.00,0.00,0.00,56.00,1120.00,'2022-05-12 12:07:21','',''),(2645600,'1','186','940',419,'Retail Sale Id 1637437',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 12:07:58','',''),(2645601,'1','186','940',419,'Retail Sale Id 1637438',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 12:09:04','',''),(2645602,'1','186','940',419,'Retail Sale Id 1637439',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 12:12:25','',''),(2645603,'1','186','940',419,'Retail Sale Id 1637440',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 12:13:09','',''),(2645604,'1','186','940',419,'Retail Sale Id 1637441',26100.00,0.00,0.00,45.00,900.00,'2022-05-12 12:15:20','',''),(2645605,'1','186','940',419,'Retail Sale Id 1637442',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 12:30:42','',''),(2645606,'1','186','940',419,'Retail Sale Id 1637443',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 12:38:45','',''),(2645607,'1','186','940',419,'Retail Sale Id 1637444',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 12:50:26','',''),(2645608,'1','186','940',419,'Retail Sale Id 1637445',69600.00,0.00,0.00,120.00,2400.00,'2022-05-12 12:52:56','',''),(2645609,'1','186','940',419,'Retail Sale Id 1637446',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 12:54:13','',''),(2645610,'1','186','940',419,'Retail Sale Id 1637447',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 12:57:12','',''),(2645611,'1','186','940',419,'Retail Sale Id 1637448',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 13:00:50','',''),(2645612,'1','186','940',419,'Retail Sale Id 1637449',17400.00,0.00,0.00,30.00,600.00,'2022-05-12 13:02:02','',''),(2645613,'1','186','940',419,'Retail Sale Id 1637450',1897.20,0.00,0.00,3.06,183.60,'2022-05-12 13:03:37','',''),(2645614,'1','186','940',419,'Retail Sale Id 1637451',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 13:06:31','',''),(2645615,'1','186','940',419,'Retail Sale Id 1637452',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 13:07:20','',''),(2645616,'1','186','940',419,'Retail Sale Id 1637453',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 13:08:21','',''),(2645617,'1','186','940',419,'Retail Sale Id 1637455',34800.00,0.00,0.00,60.00,1200.00,'2022-05-12 13:09:52','',''),(2645618,'1','186','940',419,'Retail Sale Id 1637456',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 13:11:18','',''),(2645619,'1','186','940',419,'Retail Sale Id 1637457',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 13:12:59','',''),(2645620,'1','186','940',419,'Retail Sale Id 1637458',5580.00,0.00,0.00,9.00,540.00,'2022-05-12 13:14:56','',''),(2645621,'1','186','940',419,'Retail Sale Id 1637459',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 13:16:24','',''),(2645622,'1','186','940',419,'Retail Sale Id 1637460',20001.20,0.00,0.00,32.26,1935.60,'2022-05-12 13:18:59','',''),(2645623,'1','186','940',419,'Retail Sale Id 1637461',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 13:20:51','',''),(2645624,'1','186','940',419,'Retail Sale Id 1637462',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 13:22:11','',''),(2645625,'1','186','940',419,'Retail Sale Id 1637464',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 13:23:22','',''),(2645626,'1','186','940',419,'Retail Sale Id 1637465',26100.00,0.00,0.00,45.00,900.00,'2022-05-12 13:24:05','',''),(2645627,'1','186','940',419,'Retail Sale Id 1637466',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 13:26:00','',''),(2645628,'1','186','940',419,'Retail Sale Id 1637467',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 13:27:07','',''),(2645629,'1','186','940',419,'Retail Sale Id 1637468',998.20,0.00,0.00,1.61,96.60,'2022-05-12 13:28:22','',''),(2645630,'1','186','940',419,'Retail Sale Id 1637469',998.20,0.00,0.00,1.61,96.60,'2022-05-12 13:29:04','',''),(2645631,'1','186','940',419,'Retail Sale Id 1637470',4997.20,0.00,0.00,8.06,483.60,'2022-05-12 13:30:19','',''),(2645632,'1','186','940',419,'Retail Sale Id 1637471',17400.00,0.00,0.00,30.00,600.00,'2022-05-12 13:31:51','',''),(2645633,'1','186','940',419,'Retail Sale Id 1637473',15500.00,0.00,0.00,25.00,1500.00,'2022-05-12 13:34:04','',''),(2645634,'1','186','940',419,'Retail Sale Id 1637474',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 13:34:58','',''),(2645635,'1','186','940',419,'Retail Sale Id 1637475',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 13:36:50','',''),(2645636,'1','186','940',419,'Retail Sale Id 1637476',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 13:39:42','',''),(2645637,'1','186','940',419,'Retail Sale Id 1637477',4997.20,0.00,0.00,8.06,483.60,'2022-05-12 13:40:34','',''),(2645638,'1','186','940',419,'Retail Sale Id 1637478',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 13:43:49','',''),(2645639,'1','186','940',419,'Retail Sale Id 1637479',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 13:44:21','',''),(2645640,'1','186','940',419,'Retail Sale Id 1637480',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 13:46:47','',''),(2645641,'1','186','940',419,'Retail Sale Id 1637481',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 13:47:20','',''),(2645642,'1','186','940',419,'Retail Sale Id 1637482',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 13:48:23','',''),(2645643,'1','186','940',419,'Retail Sale Id 1637483',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 13:50:48','',''),(2645644,'1','186','940',419,'Retail Sale Id 1637484',6999.80,0.00,0.00,11.29,677.40,'2022-05-12 13:57:36','',''),(2645645,'1','186','940',419,'Retail Sale Id 1637485',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 13:59:22','',''),(2645646,'1','186','940',419,'Retail Sale Id 1637486',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 14:05:36','',''),(2645647,'1','186','940',419,'Retail Sale Id 1637487',4997.20,0.00,0.00,8.06,483.60,'2022-05-12 14:06:17','',''),(2645648,'1','186','940',419,'Retail Sale Id 1637488',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 14:07:31','',''),(2645649,'1','186','940',419,'Retail Sale Id 1637489',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 14:17:12','',''),(2645650,'1','186','940',419,'Retail Sale Id 1637490',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 14:20:19','',''),(2645651,'1','186','940',419,'Retail Sale Id 1637491',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 14:21:44','',''),(2645652,'1','186','940',419,'Retail Sale Id 1637492',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 14:22:37','',''),(2645653,'1','186','940',419,'Retail Sale Id 1637493',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 14:26:02','',''),(2645654,'1','186','940',419,'Retail Sale Id 1637494',16240.00,0.00,0.00,28.00,560.00,'2022-05-12 14:27:07','',''),(2645655,'1','186','940',419,'Retail Sale Id 1637495',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 14:27:47','',''),(2645656,'1','186','940',419,'Retail Sale Id 1637496',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 14:30:25','',''),(2645657,'1','186','940',419,'Retail Sale Id 1637497',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 14:38:08','',''),(2645658,'1','186','940',419,'Retail Sale Id 1637498',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 14:41:07','',''),(2645659,'1','186','940',419,'Retail Sale Id 1637499',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 14:41:59','',''),(2645660,'1','186','940',419,'Retail Sale Id 1637500',1599.60,0.00,0.00,2.58,154.80,'2022-05-12 14:45:19','',''),(2645661,'1','186','940',419,'Retail Sale Id 1637501',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 14:46:16','',''),(2645662,'1','186','940',419,'Retail Sale Id 1637502',13950.00,0.00,0.00,22.50,1350.00,'2022-05-12 14:46:59','',''),(2645663,'1','186','940',419,'Retail Sale Id 1637503',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 14:48:43','',''),(2645664,'1','186','940',419,'Retail Sale Id 1637504',998.20,0.00,0.00,1.61,96.60,'2022-05-12 14:49:20','',''),(2645665,'1','186','940',419,'Retail Sale Id 1637505',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 14:50:02','',''),(2645666,'1','186','940',419,'Retail Sale Id 1637506',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 14:50:39','',''),(2645667,'1','186','940',419,'Retail Sale Id 1637507',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 14:51:09','',''),(2645668,'1','186','940',419,'Retail Sale Id 1637508',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 14:51:40','',''),(2645669,'1','186','940',419,'Retail Sale Id 1637509',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 14:52:08','',''),(2645670,'1','186','940',419,'Retail Sale Id 1637510',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 14:52:46','',''),(2645671,'1','186','940',419,'Retail Sale Id 1637511',91060.00,0.00,0.00,157.00,3140.00,'2022-05-12 14:55:38','',''),(2645672,'1','186','940',419,'Retail Sale Id 1637512',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 14:59:00','',''),(2645673,'1','186','940',419,'Retail Sale Id 1637513',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 14:59:37','',''),(2645674,'1','186','940',419,'Retail Sale Id 1637514',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 15:00:11','',''),(2645675,'1','186','940',419,'Retail Sale Id 1637515',174000.00,0.00,0.00,300.00,6000.00,'2022-05-12 15:01:44','',''),(2645676,'1','186','940',419,'Retail Sale Id 1637516',4340.00,0.00,0.00,7.00,420.00,'2022-05-12 15:03:59','',''),(2645677,'1','186','940',419,'Retail Sale Id 1637517',173400.00,0.00,0.00,300.00,5400.00,'2022-05-12 15:04:44','',''),(2645678,'1','186','940',419,'Retail Sale Id 1637518',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 15:06:54','',''),(2645679,'1','186','940',419,'Retail Sale Id 1637519',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 15:08:24','',''),(2645680,'1','186','940',419,'Retail Sale Id 1637520',34220.00,0.00,0.00,59.00,1180.00,'2022-05-12 15:12:49','',''),(2645681,'1','186','940',419,'Retail Sale Id 1637521',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 15:14:41','',''),(2645682,'1','186','940',419,'Retail Sale Id 1637522',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 15:16:16','',''),(2645683,'1','186','940',419,'Retail Sale Id 1637523',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 15:17:21','',''),(2645684,'1','186','940',419,'Retail Sale Id 1637524',998.20,0.00,0.00,1.61,96.60,'2022-05-12 15:18:34','',''),(2645685,'1','186','940',419,'Retail Sale Id 1637525',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 15:19:38','',''),(2645686,'1','186','940',419,'Retail Sale Id 1637526',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 15:24:26','',''),(2645687,'1','186','940',419,'Retail Sale Id 1637527',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 15:27:45','',''),(2645688,'1','186','940',419,'Retail Sale Id 1637528',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 15:29:25','',''),(2645689,'1','186','940',419,'Retail Sale Id 1637529',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 15:30:25','',''),(2645690,'1','186','940',419,'Retail Sale Id 1637530',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 15:34:03','',''),(2645691,'1','186','940',419,'Retail Sale Id 1637531',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 15:35:24','',''),(2645692,'1','186','940',419,'Retail Sale Id 1637532',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 15:36:48','',''),(2645693,'1','186','940',419,'Retail Sale Id 1637533',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 15:40:37','',''),(2645694,'1','186','940',419,'Retail Sale Id 1637534',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 15:41:52','',''),(2645695,'1','186','940',419,'Retail Sale Id 1637535',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 15:42:55','',''),(2645696,'1','186','940',419,'Retail Sale Id 1637536',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 15:44:44','',''),(2645697,'1','186','940',419,'Retail Sale Id 1637537',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 15:45:40','',''),(2645698,'1','186','940',419,'Retail Sale Id 1637538',15500.00,0.00,0.00,25.00,1500.00,'2022-05-12 15:46:42','',''),(2645699,'1','186','940',419,'Retail Sale Id 1637539',14500.00,0.00,0.00,25.00,500.00,'2022-05-12 15:48:33','',''),(2645700,'1','186','940',419,'Retail Sale Id 1637540',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 15:50:15','',''),(2645701,'1','186','940',419,'Retail Sale Id 1637541',12400.00,0.00,0.00,20.00,1200.00,'2022-05-12 15:51:26','',''),(2645702,'1','186','940',419,'Retail Sale Id 1637542',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 15:52:05','',''),(2645703,'1','186','940',419,'Retail Sale Id 1637543',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 15:52:40','',''),(2645704,'1','186','940',419,'Retail Sale Id 1637544',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 15:55:11','',''),(2645705,'1','186','940',419,'Retail Sale Id 1637545',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 15:56:15','',''),(2645706,'1','186','940',419,'Retail Sale Id 1637546',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 15:56:48','',''),(2645707,'1','186','940',419,'Retail Sale Id 1637547',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 15:58:02','',''),(2645708,'1','186','940',419,'Retail Sale Id 1637548',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 15:58:34','',''),(2645709,'1','186','940',419,'Retail Sale Id 1637549',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 15:59:04','',''),(2645710,'1','186','940',419,'Retail Sale Id 1637550',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 15:59:41','',''),(2645711,'1','186','940',419,'Retail Sale Id 1637551',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 16:01:54','',''),(2645712,'1','186','940',419,'Retail Sale Id 1637552',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:04:08','',''),(2645713,'1','186','940',419,'Retail Sale Id 1637553',998.20,0.00,0.00,1.61,96.60,'2022-05-12 16:05:47','',''),(2645714,'1','186','940',419,'Retail Sale Id 1637554',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 16:07:20','',''),(2645715,'1','186','940',419,'Retail Sale Id 1637555',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 16:08:57','',''),(2645716,'1','186','940',419,'Retail Sale Id 1637556',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 16:10:48','',''),(2645717,'1','186','940',419,'Retail Sale Id 1637557',8370.00,0.00,0.00,13.50,810.00,'2022-05-12 16:11:47','',''),(2645718,'1','186','940',419,'Retail Sale Id 1637558',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 16:13:41','',''),(2645719,'1','186','940',419,'Retail Sale Id 1637559',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 16:15:21','',''),(2645720,'1','186','940',419,'Retail Sale Id 1637560',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:16:45','',''),(2645721,'1','186','940',419,'Retail Sale Id 1637561',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:17:57','',''),(2645722,'1','186','940',419,'Retail Sale Id 1637562',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:18:54','',''),(2645723,'1','186','940',419,'Retail Sale Id 1637563',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 16:20:21','',''),(2645724,'1','186','940',419,'Retail Sale Id 1637564',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:22:05','',''),(2645725,'1','186','940',419,'Retail Sale Id 1637565',4960.00,0.00,0.00,8.00,480.00,'2022-05-12 16:26:24','',''),(2645726,'1','186','940',419,'Retail Sale Id 1637566',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 16:27:56','',''),(2645727,'1','186','940',419,'Retail Sale Id 1637567',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 16:28:35','',''),(2645728,'1','186','940',419,'Retail Sale Id 1637568',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 16:29:28','',''),(2645729,'1','186','940',419,'Retail Sale Id 1637569',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 16:30:16','',''),(2645730,'1','186','940',419,'Retail Sale Id 1637570',4197.40,0.00,0.00,6.77,406.20,'2022-05-12 16:30:57','',''),(2645731,'1','186','940',419,'Retail Sale Id 1637571',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:31:57','',''),(2645732,'1','186','940',419,'Retail Sale Id 1637572',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:32:29','',''),(2645733,'1','186','940',419,'Retail Sale Id 1637573',11600.00,0.00,0.00,20.00,400.00,'2022-05-12 16:34:40','',''),(2645734,'1','186','940',419,'Retail Sale Id 1637574',34800.00,0.00,0.00,60.00,1200.00,'2022-05-12 16:36:27','',''),(2645735,'1','186','940',419,'Retail Sale Id 1637575',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 16:37:17','',''),(2645736,'1','186','940',419,'Retail Sale Id 1637576',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 16:38:34','',''),(2645737,'1','186','940',419,'Retail Sale Id 1637577',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 16:39:48','',''),(2645738,'1','186','940',419,'Retail Sale Id 1637578',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 16:43:15','',''),(2645739,'1','186','940',419,'Retail Sale Id 1637579',1897.20,0.00,0.00,3.06,183.60,'2022-05-12 16:44:17','',''),(2645740,'1','186','940',419,'Retail Sale Id 1637580',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 16:45:31','',''),(2645741,'1','186','940',419,'Retail Sale Id 1637582',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 16:48:00','',''),(2645742,'1','186','940',419,'Retail Sale Id 1637583',998.20,0.00,0.00,1.61,96.60,'2022-05-12 16:49:19','',''),(2645743,'1','186','940',419,'Retail Sale Id 1637585',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 16:50:40','',''),(2645744,'1','186','940',419,'Retail Sale Id 1637586',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 16:52:42','',''),(2645745,'1','186','940',419,'Retail Sale Id 1637587',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 16:53:37','',''),(2645746,'1','186','940',419,'Retail Sale Id 1637588',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 16:54:37','',''),(2645747,'1','186','940',419,'Retail Sale Id 1637589',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 16:55:25','',''),(2645748,'1','186','940',419,'Retail Sale Id 1637590',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 16:56:38','',''),(2645749,'1','186','940',419,'Retail Sale Id 1637591',3701.40,0.00,0.00,5.97,358.20,'2022-05-12 16:58:04','',''),(2645750,'1','186','940',419,'Retail Sale Id 1637592',3701.40,0.00,0.00,5.97,358.20,'2022-05-12 16:58:57','',''),(2645751,'1','186','940',419,'Retail Sale Id 1637593',2201.00,0.00,0.00,3.55,213.00,'2022-05-12 17:00:31','',''),(2645752,'1','186','940',419,'Retail Sale Id 1637594',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 17:02:13','',''),(2645753,'1','186','940',419,'Retail Sale Id 1637595',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 17:04:26','',''),(2645754,'1','186','940',419,'Retail Sale Id 1637596',6497.60,0.00,0.00,10.48,628.80,'2022-05-12 17:06:34','',''),(2645755,'1','186','940',419,'Retail Sale Id 1637597',4960.00,0.00,0.00,8.00,480.00,'2022-05-12 17:07:45','',''),(2645756,'1','186','940',419,'Retail Sale Id 1637598',33640.00,0.00,0.00,58.00,1160.00,'2022-05-12 17:09:36','',''),(2645757,'1','186','940',419,'Retail Sale Id 1637599',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:12:10','',''),(2645758,'1','186','940',419,'Retail Sale Id 1637600',6820.00,0.00,0.00,11.00,660.00,'2022-05-12 17:13:30','',''),(2645759,'1','186','940',419,'Retail Sale Id 1637601',34800.00,0.00,0.00,60.00,1200.00,'2022-05-12 17:15:13','',''),(2645760,'1','186','940',419,'Retail Sale Id 1637602',6001.60,0.00,0.00,9.68,580.80,'2022-05-12 17:18:01','',''),(2645761,'1','186','940',419,'Retail Sale Id 1637603',34800.00,0.00,0.00,60.00,1200.00,'2022-05-12 17:20:03','',''),(2645762,'1','186','940',419,'Retail Sale Id 1637604',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 17:21:16','',''),(2645763,'1','186','940',419,'Retail Sale Id 1637606',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 17:23:31','',''),(2645764,'1','186','940',419,'Retail Sale Id 1637607',43500.00,0.00,0.00,75.00,1500.00,'2022-05-12 17:25:33','',''),(2645765,'1','186','940',419,'Retail Sale Id 1637608',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 17:26:46','',''),(2645766,'1','186','940',419,'Retail Sale Id 1637609',9300.00,0.00,0.00,15.00,900.00,'2022-05-12 17:27:49','',''),(2645767,'1','186','940',419,'Retail Sale Id 1637610',3800.60,0.00,0.00,6.13,367.80,'2022-05-12 17:29:43','',''),(2645768,'1','186','940',419,'Retail Sale Id 1637611',998.20,0.00,0.00,1.61,96.60,'2022-05-12 17:30:41','',''),(2645769,'1','186','940',419,'Retail Sale Id 1637612',3999.00,0.00,0.00,6.45,387.00,'2022-05-12 17:31:14','',''),(2645770,'1','186','940',419,'Retail Sale Id 1637613',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 17:31:49','',''),(2645771,'1','186','940',419,'Retail Sale Id 1637614',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 17:32:26','',''),(2645772,'1','186','940',419,'Retail Sale Id 1637615',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 17:33:12','',''),(2645773,'1','186','940',419,'Retail Sale Id 1637616',15500.00,0.00,0.00,25.00,1500.00,'2022-05-12 17:33:41','',''),(2645774,'1','186','940',419,'Retail Sale Id 1637617',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:34:13','',''),(2645775,'1','186','940',419,'Retail Sale Id 1637618',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 17:34:54','',''),(2645776,'1','186','940',419,'Retail Sale Id 1637619',24940.00,0.00,0.00,43.00,860.00,'2022-05-12 17:35:35','',''),(2645777,'1','186','940',419,'Retail Sale Id 1637620',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 17:36:06','',''),(2645778,'1','186','940',419,'Retail Sale Id 1637621',4997.20,0.00,0.00,8.06,483.60,'2022-05-12 17:36:44','',''),(2645779,'1','186','940',419,'Retail Sale Id 1637622',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:37:13','',''),(2645780,'1','186','940',419,'Retail Sale Id 1637624',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 17:37:55','',''),(2645781,'1','186','940',419,'Retail Sale Id 1637625',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 17:38:38','',''),(2645782,'1','186','940',419,'Retail Sale Id 1637626',2498.60,0.00,0.00,4.03,241.80,'2022-05-12 17:39:10','',''),(2645783,'1','186','940',419,'Retail Sale Id 1637627',58000.00,0.00,0.00,100.00,2000.00,'2022-05-12 17:39:41','',''),(2645784,'1','186','940',419,'Retail Sale Id 1637628',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 17:40:17','',''),(2645785,'1','186','940',419,'Retail Sale Id 1637629',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 17:40:51','',''),(2645786,'1','186','940',419,'Retail Sale Id 1637630',8060.00,0.00,0.00,13.00,780.00,'2022-05-12 17:41:25','',''),(2645787,'1','186','940',419,'Retail Sale Id 1637631',998.20,0.00,0.00,1.61,96.60,'2022-05-12 17:41:55','',''),(2645788,'1','186','940',419,'Retail Sale Id 1637632',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:42:24','',''),(2645789,'1','186','940',419,'Retail Sale Id 1637633',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 17:42:52','',''),(2645790,'1','186','940',419,'Retail Sale Id 1637634',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 17:43:18','',''),(2645791,'1','186','940',419,'Retail Sale Id 1637636',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 17:44:26','',''),(2645792,'1','186','940',419,'Retail Sale Id 1637638',998.20,0.00,0.00,1.61,96.60,'2022-05-12 17:44:54','',''),(2645793,'1','186','940',419,'Retail Sale Id 1637639',96280.00,0.00,0.00,166.00,3320.00,'2022-05-12 17:45:27','',''),(2645794,'1','186','940',419,'Retail Sale Id 1637640',11470.00,0.00,0.00,18.50,1110.00,'2022-05-12 17:46:18','',''),(2645795,'1','186','940',419,'Retail Sale Id 1637641',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 17:49:11','',''),(2645796,'1','186','940',419,'Retail Sale Id 1637642',3999.00,0.00,0.00,6.45,387.00,'2022-05-12 17:49:42','',''),(2645797,'1','186','940',419,'Retail Sale Id 1637643',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 17:50:11','',''),(2645798,'1','186','940',419,'Retail Sale Id 1637644',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 17:50:37','',''),(2645799,'1','186','940',419,'Retail Sale Id 1637645',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 17:51:11','',''),(2645800,'1','186','940',419,'Retail Sale Id 1637646',998.20,0.00,0.00,1.61,96.60,'2022-05-12 17:51:50','',''),(2645801,'1','186','940',419,'Retail Sale Id 1637647',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 17:52:20','',''),(2645802,'1','186','940',419,'Retail Sale Id 1637649',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 17:52:54','',''),(2645803,'1','186','940',419,'Retail Sale Id 1637650',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:53:23','',''),(2645804,'1','186','940',419,'Retail Sale Id 1637651',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 17:54:08','',''),(2645805,'1','186','940',419,'Retail Sale Id 1637652',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 17:54:42','',''),(2645806,'1','186','940',419,'Retail Sale Id 1637653',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 17:55:22','',''),(2645807,'1','186','940',419,'Retail Sale Id 1637654',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 17:55:50','',''),(2645808,'1','186','940',419,'Retail Sale Id 1637655',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:56:34','',''),(2645809,'1','186','940',419,'Retail Sale Id 1637656',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 17:57:01','',''),(2645810,'1','186','940',419,'Retail Sale Id 1637657',6200.00,0.00,0.00,10.00,600.00,'2022-05-12 17:57:43','',''),(2645811,'1','186','940',419,'Retail Sale Id 1637658',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:58:23','',''),(2645812,'1','186','940',419,'Retail Sale Id 1637659',14500.00,0.00,0.00,25.00,500.00,'2022-05-12 17:59:00','',''),(2645813,'1','186','940',419,'Retail Sale Id 1637660',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 17:59:31','',''),(2645814,'1','186','940',419,'Retail Sale Id 1637661',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 17:59:58','',''),(2645815,'1','186','940',419,'Retail Sale Id 1637662',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:00:23','',''),(2645816,'1','186','940',419,'Retail Sale Id 1637663',6820.00,0.00,0.00,11.00,660.00,'2022-05-12 18:00:58','',''),(2645817,'1','186','940',419,'Retail Sale Id 1637664',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 18:01:27','',''),(2645818,'1','186','940',419,'Retail Sale Id 1637665',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:01:57','',''),(2645819,'1','186','940',419,'Retail Sale Id 1637666',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 18:02:35','',''),(2645820,'1','186','940',419,'Retail Sale Id 1637667',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:03:06','',''),(2645821,'1','186','940',419,'Retail Sale Id 1637668',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 18:03:38','',''),(2645822,'1','186','940',419,'Retail Sale Id 1637669',14500.00,0.00,0.00,25.00,500.00,'2022-05-12 18:04:17','',''),(2645823,'1','186','940',419,'Retail Sale Id 1637670',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 18:04:43','',''),(2645824,'1','186','940',419,'Retail Sale Id 1637671',7440.00,0.00,0.00,12.00,720.00,'2022-05-12 18:05:26','',''),(2645825,'1','186','940',419,'Retail Sale Id 1637672',7502.00,0.00,0.00,12.10,726.00,'2022-05-12 18:06:18','',''),(2645826,'1','186','940',419,'Retail Sale Id 1637673',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 18:06:57','',''),(2645827,'1','186','940',419,'Retail Sale Id 1637674',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 18:07:27','',''),(2645828,'1','186','940',419,'Retail Sale Id 1637675',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 18:08:12','',''),(2645829,'1','186','940',419,'Retail Sale Id 1637676',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 18:09:20','',''),(2645830,'1','186','940',419,'Retail Sale Id 1637677',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 18:10:15','',''),(2645831,'1','186','940',419,'Retail Sale Id 1637678',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 18:14:07','',''),(2645832,'1','186','940',419,'Retail Sale Id 1637679',22620.00,0.00,0.00,39.00,780.00,'2022-05-12 18:16:34','',''),(2645833,'1','186','940',419,'Retail Sale Id 1637680',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 18:17:12','',''),(2645834,'1','186','940',419,'Retail Sale Id 1637681',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:17:41','',''),(2645835,'1','186','940',419,'Retail Sale Id 1637682',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:18:11','',''),(2645836,'1','186','940',419,'Retail Sale Id 1637683',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 18:18:37','',''),(2645837,'1','186','940',419,'Retail Sale Id 1637684',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 18:19:02','',''),(2645838,'1','186','940',419,'Retail Sale Id 1637685',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:19:31','',''),(2645839,'1','186','940',419,'Retail Sale Id 1637686',1698.80,0.00,0.00,2.74,164.40,'2022-05-12 18:20:00','',''),(2645840,'1','186','940',419,'Retail Sale Id 1637687',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 18:20:28','',''),(2645841,'1','186','940',419,'Retail Sale Id 1637688',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 18:20:54','',''),(2645842,'1','186','940',419,'Retail Sale Id 1637689',7750.00,0.00,0.00,12.50,750.00,'2022-05-12 18:21:53','',''),(2645843,'1','186','940',419,'Retail Sale Id 1637690',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 18:24:01','',''),(2645844,'1','186','940',419,'Retail Sale Id 1637691',8060.00,0.00,0.00,13.00,780.00,'2022-05-12 18:25:00','',''),(2645845,'1','186','940',419,'Retail Sale Id 1637692',1860.00,0.00,0.00,3.00,180.00,'2022-05-12 18:25:52','',''),(2645846,'1','186','940',419,'Retail Sale Id 1637693',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 18:26:54','',''),(2645847,'1','186','940',419,'Retail Sale Id 1637694',12400.00,0.00,0.00,20.00,1200.00,'2022-05-12 18:27:46','',''),(2645848,'1','186','940',419,'Retail Sale Id 1637695',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 18:28:31','',''),(2645849,'1','186','940',419,'Retail Sale Id 1637696',1500.40,0.00,0.00,2.42,145.20,'2022-05-12 18:29:20','',''),(2645850,'1','186','940',419,'Retail Sale Id 1637697',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 18:30:32','',''),(2645851,'1','186','940',419,'Retail Sale Id 1637698',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 18:31:16','',''),(2645852,'1','186','940',419,'Retail Sale Id 1637699',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 18:32:37','',''),(2645853,'1','186','940',419,'Retail Sale Id 1637700',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 18:33:27','',''),(2645854,'1','186','940',419,'Retail Sale Id 1637701',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 18:35:39','',''),(2645855,'1','186','940',419,'Retail Sale Id 1637702',1240.00,0.00,0.00,2.00,120.00,'2022-05-12 18:37:00','',''),(2645856,'1','186','940',419,'Retail Sale Id 1637703',998.20,0.00,0.00,1.61,96.60,'2022-05-12 18:37:49','',''),(2645857,'1','186','940',419,'Retail Sale Id 1637704',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 18:39:24','',''),(2645858,'1','186','940',419,'Retail Sale Id 1637705',2480.00,0.00,0.00,4.00,240.00,'2022-05-12 18:40:18','',''),(2645859,'1','186','940',419,'Retail Sale Id 1637706',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 18:41:15','',''),(2645860,'1','186','940',419,'Retail Sale Id 1637707',3000.80,0.00,0.00,4.84,290.40,'2022-05-12 18:42:08','',''),(2645861,'1','186','940',419,'Retail Sale Id 1637708',1302.00,0.00,0.00,2.10,126.00,'2022-05-12 18:43:18','',''),(2645862,'1','186','940',419,'Retail Sale Id 1637709',9920.00,0.00,0.00,16.00,960.00,'2022-05-12 18:44:16','',''),(2645863,'1','186','940',419,'Retail Sale Id 1637710',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 18:45:22','',''),(2645864,'1','186','940',419,'Retail Sale Id 1637711',1798.00,0.00,0.00,2.90,174.00,'2022-05-12 18:46:28','',''),(2645865,'1','186','940',419,'Retail Sale Id 1637712',29000.00,0.00,0.00,50.00,1000.00,'2022-05-12 18:48:33','',''),(2645866,'1','186','940',419,'Retail Sale Id 1637713',31900.00,0.00,0.00,55.00,1100.00,'2022-05-12 18:49:40','',''),(2645867,'1','186','940',419,'Retail Sale Id 1637714',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 18:50:37','',''),(2645868,'1','186','940',419,'Retail Sale Id 1637715',5580.00,0.00,0.00,9.00,540.00,'2022-05-12 18:51:20','',''),(2645869,'1','186','940',419,'Retail Sale Id 1637716',2002.60,0.00,0.00,3.23,193.80,'2022-05-12 18:52:07','',''),(2645870,'1','186','940',419,'Retail Sale Id 1637717',2498.60,0.00,0.00,4.03,241.80,'2022-05-12 18:52:57','',''),(2645871,'1','186','940',419,'Retail Sale Id 1637718',1097.40,0.00,0.00,1.77,106.20,'2022-05-12 18:53:58','',''),(2645872,'1','186','940',419,'Retail Sale Id 1637720',1202.80,0.00,0.00,1.94,116.40,'2022-05-12 18:55:34','',''),(2645873,'1','186','940',419,'Retail Sale Id 1637721',3720.00,0.00,0.00,6.00,360.00,'2022-05-12 18:56:27','',''),(2645874,'1','186','940',419,'Retail Sale Id 1637722',23200.00,0.00,0.00,40.00,800.00,'2022-05-12 18:57:46','',''),(2645875,'1','186','940',419,'Retail Sale Id 1637723',3100.00,0.00,0.00,5.00,300.00,'2022-05-12 18:58:35','',''),(2645876,'1','186','940',419,'Retail Sale Id 1637724',59210.00,0.00,0.00,95.50,5730.00,'2022-05-12 19:26:43','',''),(2645877,'1','186','940',419,'Retail Sale Id 1637725',20460.00,0.00,0.00,33.00,1980.00,'2022-05-12 19:49:04','',''),(2645878,'1','186','940',419,'Return of Retail Sale Id 1637471',0.00,17400.00,30.00,0.00,-600.00,'2022-05-12 20:13:21','',''),(2645879,'1','186','940',419,'Retail Sale Id 1637726',23200.00,0.00,0.00,40.00,800.00,'2022-05-13 07:05:23','',''),(2645880,'1','186','940',419,'Retail Sale Id 1637727',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 07:08:02','',''),(2645881,'1','186','940',419,'Retail Sale Id 1637728',2002.60,0.00,0.00,3.23,193.80,'2022-05-13 07:08:55','',''),(2645882,'1','186','940',419,'Retail Sale Id 1637729',100920.00,0.00,0.00,174.00,3480.00,'2022-05-13 07:10:18','',''),(2645883,'1','186','940',419,'Retail Sale Id 1637730',31900.00,0.00,0.00,55.00,1100.00,'2022-05-13 07:15:37','',''),(2645884,'1','186','940',419,'Retail Sale Id 1637731',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 07:18:36','',''),(2645885,'1','186','940',419,'Retail Sale Id 1637732',1240.00,0.00,0.00,2.00,120.00,'2022-05-13 07:26:34','',''),(2645886,'1','186','940',419,'Retail Sale Id 1637733',2002.60,0.00,0.00,3.23,193.80,'2022-05-13 07:28:13','',''),(2645887,'1','186','940',419,'Retail Sale Id 1637734',15500.00,0.00,0.00,25.00,1500.00,'2022-05-13 07:29:47','',''),(2645888,'1','186','940',419,'Retail Sale Id 1637735',998.20,0.00,0.00,1.61,96.60,'2022-05-13 07:30:48','',''),(2645889,'1','186','940',419,'Retail Sale Id 1637736',3701.40,0.00,0.00,5.97,358.20,'2022-05-13 07:32:10','',''),(2645890,'1','186','940',419,'Retail Sale Id 1637737',3100.00,0.00,0.00,5.00,300.00,'2022-05-13 07:33:09','',''),(2645891,'1','186','940',419,'Retail Sale Id 1637738',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 07:34:22','',''),(2645892,'1','186','940',419,'Retail Sale Id 1637739',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 07:37:02','',''),(2645893,'1','186','940',419,'Retail Sale Id 1637740',3999.00,0.00,0.00,6.45,387.00,'2022-05-13 07:53:19','',''),(2645894,'1','186','940',419,'Retail Sale Id 1637741',1860.00,0.00,0.00,3.00,180.00,'2022-05-13 07:54:40','',''),(2645895,'1','186','940',419,'Retail Sale Id 1637742',998.20,0.00,0.00,1.61,96.60,'2022-05-13 07:55:37','',''),(2645896,'1','186','940',419,'Retail Sale Id 1637743',1860.00,0.00,0.00,3.00,180.00,'2022-05-13 07:57:04','',''),(2645897,'1','186','940',419,'Retail Sale Id 1637744',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 07:58:05','',''),(2645898,'1','186',NULL,419,'Reception corrector for bridging 132700',0.00,0.00,0.00,2060.00,0.00,'2022-05-13 08:02:42','',''),(2645899,'1','186','940',419,'Received from bridging 132700',0.00,0.00,2060.00,0.00,0.00,'2022-05-13 08:02:42','',''),(2645900,'1','186','940',419,'Retail Sale Id 1637746',33640.00,0.00,0.00,58.00,1160.00,'2022-05-13 08:03:48','',''),(2645901,'1','186','940',419,'Retail Sale Id 1637747',2480.00,0.00,0.00,4.00,240.00,'2022-05-13 08:04:34','',''),(2645902,'1','186','940',419,'Retail Sale Id 1637748',998.20,0.00,0.00,1.61,96.60,'2022-05-13 08:05:24','',''),(2645903,'1','186','940',419,'Retail Sale Id 1637749',2002.60,0.00,0.00,3.23,193.80,'2022-05-13 08:06:23','',''),(2645904,'1','186','940',419,'Retail Sale Id 1637750',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 08:08:43','',''),(2645905,'1','186','940',419,'Retail Sale Id 1637751',998.20,0.00,0.00,1.61,96.60,'2022-05-13 08:09:52','',''),(2645906,'1','186','940',419,'Retail Sale Id 1637752',3720.00,0.00,0.00,6.00,360.00,'2022-05-13 08:11:58','',''),(2645907,'1','186','940',419,'Retail Sale Id 1637753',15660.00,0.00,0.00,27.00,540.00,'2022-05-13 08:14:20','',''),(2645908,'1','186','940',419,'Retail Sale Id 1637754',3800.60,0.00,0.00,6.13,367.80,'2022-05-13 08:15:45','',''),(2645909,'1','186','940',419,'Retail Sale Id 1637755',31900.00,0.00,0.00,55.00,1100.00,'2022-05-13 08:18:14','',''),(2645910,'1','186','940',419,'Retail Sale Id 1637756',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:20:40','',''),(2645911,'1','186','940',419,'Retail Sale Id 1637757',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:21:20','',''),(2645912,'1','186','940',419,'Retail Sale Id 1637758',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:22:25','',''),(2645913,'1','186','940',419,'Retail Sale Id 1637759',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:23:15','',''),(2645914,'1','186','940',419,'Retail Sale Id 1637760',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:24:56','',''),(2645915,'1','186','940',419,'Retail Sale Id 1637761',1240.00,0.00,0.00,2.00,120.00,'2022-05-13 08:25:38','',''),(2645916,'1','186','940',419,'Retail Sale Id 1637762',3999.00,0.00,0.00,6.45,387.00,'2022-05-13 08:26:22','',''),(2645917,'1','186','940',419,'Retail Sale Id 1637763',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 08:28:31','',''),(2645918,'1','186','940',419,'Retail Sale Id 1637764',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:29:21','',''),(2645919,'1','186','940',419,'Retail Sale Id 1637765',15500.00,0.00,0.00,25.00,1500.00,'2022-05-13 08:34:28','',''),(2645920,'1','186','940',419,'Retail Sale Id 1637766',5580.00,0.00,0.00,9.00,540.00,'2022-05-13 08:35:46','',''),(2645921,'1','186','940',419,'Retail Sale Id 1637767',3800.60,0.00,0.00,6.13,367.80,'2022-05-13 08:37:52','',''),(2645922,'1','186','940',419,'Retail Sale Id 1637768',1860.00,0.00,0.00,3.00,180.00,'2022-05-13 08:40:12','',''),(2645923,'1','186','940',419,'Retail Sale Id 1637769',3800.60,0.00,0.00,6.13,367.80,'2022-05-13 08:41:10','',''),(2645924,'1','186','940',419,'Retail Sale Id 1637770',3100.00,0.00,0.00,5.00,300.00,'2022-05-13 08:42:12','',''),(2645925,'1','186','940',419,'Retail Sale Id 1637771',4997.20,0.00,0.00,8.06,483.60,'2022-05-13 08:43:11','',''),(2645926,'1','186','940',419,'Retail Sale Id 1637772',3800.60,0.00,0.00,6.13,367.80,'2022-05-13 08:44:18','',''),(2645927,'1','186','940',419,'Retail Sale Id 1637773',2002.60,0.00,0.00,3.23,193.80,'2022-05-13 08:44:47','',''),(2645928,'1','186','940',419,'Retail Sale Id 1637774',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 08:45:16','',''),(2645929,'1','186','940',419,'Retail Sale Id 1637775',2480.00,0.00,0.00,4.00,240.00,'2022-05-13 08:46:13','',''),(2645930,'1','186','940',419,'Retail Sale Id 1637776',3100.00,0.00,0.00,5.00,300.00,'2022-05-13 08:47:04','',''),(2645931,'1','186','940',419,'Retail Sale Id 1637777',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:47:33','',''),(2645932,'1','186','940',419,'Retail Sale Id 1637778',58000.00,0.00,0.00,100.00,2000.00,'2022-05-13 08:48:13','',''),(2645933,'1','186','940',419,'Retail Sale Id 1637779',3720.00,0.00,0.00,6.00,360.00,'2022-05-13 08:48:47','',''),(2645934,'1','186','940',419,'Retail Sale Id 1637780',2002.60,0.00,0.00,3.23,193.80,'2022-05-13 08:49:17','',''),(2645935,'1','186','940',419,'Retail Sale Id 1637781',3999.00,0.00,0.00,6.45,387.00,'2022-05-13 08:50:26','',''),(2645936,'1','186','940',419,'Retail Sale Id 1637782',58000.00,0.00,0.00,100.00,2000.00,'2022-05-13 08:51:23','',''),(2645937,'1','186','940',419,'Retail Sale Id 1637783',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:52:58','',''),(2645938,'1','186','940',419,'Retail Sale Id 1637784',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 08:53:30','',''),(2645939,'1','186','940',419,'Retail Sale Id 1637785',81200.00,0.00,0.00,140.00,2800.00,'2022-05-13 08:57:04','',''),(2645940,'1','186','940',419,'Retail Sale Id 1637786',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 08:58:14','',''),(2645941,'1','186','940',419,'Retail Sale Id 1637787',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 09:00:19','',''),(2645942,'1','186','940',419,'Retail Sale Id 1637788',6820.00,0.00,0.00,11.00,660.00,'2022-05-13 09:03:06','',''),(2645943,'1','186','940',419,'Retail Sale Id 1637789',3503.00,0.00,0.00,5.65,339.00,'2022-05-13 09:04:03','',''),(2645944,'1','186','940',419,'Retail Sale Id 1637790',3100.00,0.00,0.00,5.00,300.00,'2022-05-13 09:08:59','',''),(2645945,'1','186','940',419,'Retail Sale Id 1637791',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 09:10:46','',''),(2645946,'1','186','940',419,'Retail Sale Id 1637792',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 09:15:05','',''),(2645947,'1','186','940',419,'Retail Sale Id 1637793',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 09:16:19','',''),(2645948,'1','186','940',419,'Retail Sale Id 1637794',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 09:17:15','',''),(2645949,'1','186','940',419,'Retail Sale Id 1637795',33640.00,0.00,0.00,58.00,1160.00,'2022-05-13 09:21:09','',''),(2645950,'1','186','940',419,'Retail Sale Id 1637796',17400.00,0.00,0.00,30.00,600.00,'2022-05-13 09:21:49','',''),(2645951,'1','186','940',419,'Retail Sale Id 1637797',58000.00,0.00,0.00,100.00,2000.00,'2022-05-13 09:22:27','',''),(2645952,'1','186','940',419,'Retail Sale Id 1637798',998.20,0.00,0.00,1.61,96.60,'2022-05-13 09:23:08','',''),(2645953,'1','186','940',419,'Retail Sale Id 1637799',4960.00,0.00,0.00,8.00,480.00,'2022-05-13 09:24:44','',''),(2645954,'1','186','940',419,'Retail Sale Id 1637800',63800.00,0.00,0.00,110.00,2200.00,'2022-05-13 09:26:17','',''),(2645955,'1','186','940',419,'Retail Sale Id 1637801',27840.00,0.00,0.00,48.00,960.00,'2022-05-13 09:27:50','',''),(2645956,'1','186','940',419,'Retail Sale Id 1637802',2002.60,0.00,0.00,3.23,193.80,'2022-05-13 09:29:59','',''),(2645957,'1','186','940',419,'Retail Sale Id 1637803',1240.00,0.00,0.00,2.00,120.00,'2022-05-13 09:30:31','',''),(2645958,'1','186','940',419,'Retail Sale Id 1637804',29000.00,0.00,0.00,50.00,1000.00,'2022-05-13 09:31:26','',''),(2645959,'1','186','940',419,'Retail Sale Id 1637805',7750.00,0.00,0.00,12.50,750.00,'2022-05-13 09:33:14','',''),(2645960,'1','186','940',419,'Retail Sale Id 1637806',5476.00,0.00,0.00,74.00,-35964.00,'2022-05-13 09:34:15','',''),(2645961,'1','186','940',419,'Return of Retail Sale Id 1637806',0.00,5476.00,74.00,0.00,35964.00,'2022-05-13 09:50:19','',''),(2645962,'1','186','940',419,'Return of Retail Sale Id 1637805',0.00,7750.00,12.50,0.00,-750.00,'2022-05-13 10:04:27','',''),(2645963,'1','186','940',419,'Retail Sale Id 1637807',2790.00,0.00,0.00,4.50,270.00,'2022-05-13 10:14:54','',''),(2645964,'1','186','940',419,'Distributed to AARANO for sales id:349428',221278.40,0.00,0.00,395.14,0.00,'2022-05-13 17:56:12','',''),(2645965,'1','186',NULL,419,'Purchased from AA RANO NIGERIA LIMITED',0.00,15108230.00,24890.00,0.00,0.00,'2022-05-18 08:34:42','',''),(2645966,'1','186',NULL,419,'Reception corrector for bridging 132701',0.00,0.00,0.00,23000.00,0.00,'2022-05-18 08:39:15','',''),(2645967,'1','186','940',419,'Received from bridging 132701',0.00,0.00,23000.00,0.00,0.00,'2022-05-18 08:39:15','',''),(2645968,'1','186','940',419,'Retail Sale Id 1637808',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 09:20:16','',''),(2645969,'1','186','940',419,'Retail Sale Id 1637809',2699.60,0.00,0.00,3.97,289.81,'2022-05-18 10:35:36','',''),(2645970,'1','186','940',419,'Retail Sale Id 1637810',2380.00,0.00,0.00,3.50,255.50,'2022-05-18 10:37:11','',''),(2645971,'1','186','940',419,'Retail Sale Id 1637811',2502.40,0.00,0.00,3.68,268.64,'2022-05-18 10:37:58','',''),(2645972,'1','186','940',419,'Retail Sale Id 1637812',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 10:38:44','',''),(2645973,'1','186','940',419,'Retail Sale Id 1637813',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 10:39:52','',''),(2645974,'1','186','940',419,'Retail Sale Id 1637814',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 10:40:36','',''),(2645975,'1','186','940',419,'Retail Sale Id 1637815',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 10:41:43','',''),(2645976,'1','186','940',419,'Retail Sale Id 1637816',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 10:43:00','',''),(2645977,'1','186','940',419,'Retail Sale Id 1637817',8160.00,0.00,0.00,12.00,876.00,'2022-05-18 10:43:47','',''),(2645978,'1','186','940',419,'Retail Sale Id 1637818',999.60,0.00,0.00,1.47,107.31,'2022-05-18 10:44:31','',''),(2645979,'1','186','940',419,'Retail Sale Id 1637819',6120.00,0.00,0.00,9.00,657.00,'2022-05-18 10:46:08','',''),(2645980,'1','186','940',419,'Retail Sale Id 1637820',12978.00,0.00,0.00,20.60,473.80,'2022-05-18 10:47:48','',''),(2645981,'1','186','940',419,'Retail Sale Id 1637821',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 10:48:44','',''),(2645982,'1','186','940',419,'Retail Sale Id 1637822',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 10:49:31','',''),(2645983,'1','186','940',419,'Retail Sale Id 1637823',4501.60,0.00,0.00,6.62,483.26,'2022-05-18 10:50:20','',''),(2645984,'1','186','940',419,'Retail Sale Id 1637824',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 10:51:13','',''),(2645985,'1','186','940',419,'Retail Sale Id 1637825',3100.80,0.00,0.00,4.56,332.88,'2022-05-18 10:52:03','',''),(2645986,'1','186','940',419,'Retail Sale Id 1637826',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 10:52:57','',''),(2645987,'1','186','940',419,'Retail Sale Id 1637827',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 10:53:47','',''),(2645988,'1','186','940',419,'Retail Sale Id 1637828',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 10:54:27','',''),(2645989,'1','186','940',419,'Retail Sale Id 1637829',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 10:55:10','',''),(2645990,'1','186','940',419,'Retail Sale Id 1637830',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 10:56:10','',''),(2645991,'1','186','940',419,'Retail Sale Id 1637831',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 10:57:39','',''),(2645992,'1','186','940',419,'Retail Sale Id 1637832',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 10:58:31','',''),(2645993,'1','186','940',419,'Retail Sale Id 1637833',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 10:59:16','',''),(2645994,'1','186','940',419,'Retail Sale Id 1637834',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:00:02','',''),(2645995,'1','186','940',419,'Retail Sale Id 1637835',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:00:49','',''),(2645996,'1','186','940',419,'Retail Sale Id 1637836',7398.40,0.00,0.00,10.88,794.24,'2022-05-18 11:01:40','',''),(2645997,'1','186','940',419,'Retail Sale Id 1637837',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 11:02:35','',''),(2645998,'1','186','940',419,'Retail Sale Id 1637838',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 11:04:09','',''),(2645999,'1','186','940',419,'Retail Sale Id 1637839',12240.00,0.00,0.00,18.00,1314.00,'2022-05-18 11:05:01','',''),(2646000,'1','186','940',419,'Retail Sale Id 1637840',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 11:06:24','',''),(2646001,'1','186','940',419,'Retail Sale Id 1637841',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 11:07:32','',''),(2646002,'1','186','940',419,'Retail Sale Id 1637842',36540.00,0.00,0.00,58.00,1334.00,'2022-05-18 11:09:30','',''),(2646003,'1','186','940',419,'Retail Sale Id 1637844',6120.00,0.00,0.00,9.00,657.00,'2022-05-18 11:17:22','',''),(2646004,'1','186','940',419,'Retail Sale Id 1637845',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 11:20:57','',''),(2646005,'1','186','940',419,'Retail Sale Id 1637846',15750.00,0.00,0.00,25.00,575.00,'2022-05-18 11:22:23','',''),(2646006,'1','186','940',419,'Retail Sale Id 1637847',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 11:26:20','',''),(2646007,'1','186','940',419,'Retail Sale Id 1637848',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:28:55','',''),(2646008,'1','186','940',419,'Retail Sale Id 1637849',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 11:32:01','',''),(2646009,'1','186','940',419,'Retail Sale Id 1637850',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:35:06','',''),(2646010,'1','186','940',419,'Retail Sale Id 1637851',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 11:39:38','',''),(2646011,'1','186','940',419,'Retail Sale Id 1637852',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:40:23','',''),(2646012,'1','186','940',419,'Retail Sale Id 1637853',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 11:41:56','',''),(2646013,'1','186','940',419,'Retail Sale Id 1637854',12580.00,0.00,0.00,18.50,1350.50,'2022-05-18 11:44:11','',''),(2646014,'1','186','940',419,'Retail Sale Id 1637855',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 11:45:12','',''),(2646015,'1','186','940',419,'Retail Sale Id 1637856',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 11:46:01','',''),(2646016,'1','186','940',419,'Retail Sale Id 1637857',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:51:46','',''),(2646017,'1','186','940',419,'Retail Sale Id 1637858',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 11:52:45','',''),(2646018,'1','186','940',419,'Retail Sale Id 1637859',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 11:57:32','',''),(2646019,'1','186','940',419,'Retail Sale Id 1637860',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 11:59:14','',''),(2646020,'1','186','940',419,'Retail Sale Id 1637861',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 12:00:49','',''),(2646021,'1','186','940',419,'Retail Sale Id 1637862',20400.00,0.00,0.00,30.00,2190.00,'2022-05-18 12:01:50','',''),(2646022,'1','186','940',419,'Retail Sale Id 1637863',34650.00,0.00,0.00,55.00,1265.00,'2022-05-18 12:03:19','',''),(2646023,'1','186','940',419,'Retail Sale Id 1637864',7480.00,0.00,0.00,11.00,803.00,'2022-05-18 12:04:17','',''),(2646024,'1','186','940',419,'Retail Sale Id 1637865',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 12:09:36','',''),(2646025,'1','186','940',419,'Retail Sale Id 1637866',63000.00,0.00,0.00,100.00,2300.00,'2022-05-18 12:11:49','',''),(2646026,'1','186','940',419,'Retail Sale Id 1637867',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 12:12:58','',''),(2646027,'1','186','940',419,'Retail Sale Id 1637868',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 12:13:52','',''),(2646028,'1','186','940',419,'Retail Sale Id 1637869',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 12:15:45','',''),(2646029,'1','186','940',419,'Retail Sale Id 1637871',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 12:17:07','',''),(2646030,'1','186','940',419,'Retail Sale Id 1637872',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 12:18:05','',''),(2646031,'1','186','940',419,'Retail Sale Id 1637873',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 12:18:47','',''),(2646032,'1','186','940',419,'Retail Sale Id 1637874',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 12:23:43','',''),(2646033,'1','186','940',419,'Retail Sale Id 1637876',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 12:28:25','',''),(2646034,'1','186','940',419,'Retail Sale Id 1637877',21080.00,0.00,0.00,31.00,2263.00,'2022-05-18 12:30:21','',''),(2646035,'1','186','940',419,'Retail Sale Id 1637878',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 12:31:30','',''),(2646036,'1','186','940',419,'Retail Sale Id 1637879',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 12:32:16','',''),(2646037,'1','186','940',419,'Retail Sale Id 1637880',28350.00,0.00,0.00,45.00,1035.00,'2022-05-18 12:34:29','',''),(2646038,'1','186','940',419,'Retail Sale Id 1637882',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 12:35:50','',''),(2646039,'1','186','940',419,'Retail Sale Id 1637883',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 12:36:46','',''),(2646040,'1','186','940',419,'Retail Sale Id 1637884',17000.00,0.00,0.00,25.00,1825.00,'2022-05-18 12:38:01','',''),(2646041,'1','186','940',419,'Retail Sale Id 1637886',2597.60,0.00,0.00,3.82,278.86,'2022-05-18 12:40:44','',''),(2646042,'1','186','940',419,'Retail Sale Id 1637887',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 12:41:36','',''),(2646043,'1','186','940',419,'Retail Sale Id 1637888',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 12:47:01','',''),(2646044,'1','186','940',419,'Retail Sale Id 1637889',6120.00,0.00,0.00,9.00,657.00,'2022-05-18 12:50:57','',''),(2646045,'1','186','940',419,'Retail Sale Id 1637890',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 12:53:13','',''),(2646046,'1','186','940',419,'Retail Sale Id 1637891',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 12:54:11','',''),(2646047,'1','186','940',419,'Retail Sale Id 1637893',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 12:56:29','',''),(2646048,'1','186','940',419,'Retail Sale Id 1637894',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 12:58:13','',''),(2646049,'1','186','940',419,'Retail Sale Id 1637895',6997.20,0.00,0.00,10.29,751.17,'2022-05-18 12:59:07','',''),(2646050,'1','186','940',419,'Retail Sale Id 1637896',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:01:52','',''),(2646051,'1','186','940',419,'Retail Sale Id 1637897',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:03:51','',''),(2646052,'1','186','940',419,'Retail Sale Id 1637898',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:07:19','',''),(2646053,'1','186','940',419,'Retail Sale Id 1637899',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:09:27','',''),(2646054,'1','186','940',419,'Retail Sale Id 1637900',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 13:10:31','',''),(2646055,'1','186','940',419,'Retail Sale Id 1637901',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:11:36','',''),(2646056,'1','186','940',419,'Retail Sale Id 1637902',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:18:49','',''),(2646057,'1','186','940',419,'Retail Sale Id 1637903',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 13:20:42','',''),(2646058,'1','186','940',419,'Retail Sale Id 1637904',10200.00,0.00,0.00,15.00,1095.00,'2022-05-18 13:22:54','',''),(2646059,'1','186','940',419,'Retail Sale Id 1637905',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 13:23:48','',''),(2646060,'1','186','940',419,'Retail Sale Id 1637906',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:25:34','',''),(2646061,'1','186','940',419,'Retail Sale Id 1637907',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 13:26:28','',''),(2646062,'1','186','940',419,'Retail Sale Id 1637908',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 13:27:14','',''),(2646063,'1','186','940',419,'Retail Sale Id 1637909',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 13:29:05','',''),(2646064,'1','186','940',419,'Retail Sale Id 1637910',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:31:36','',''),(2646065,'1','186','940',419,'Retail Sale Id 1637911',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:34:12','',''),(2646066,'1','186','940',419,'Retail Sale Id 1637912',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 13:36:32','',''),(2646067,'1','186','940',419,'Retail Sale Id 1637913',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 13:37:47','',''),(2646068,'1','186','940',419,'Retail Sale Id 1637914',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:40:09','',''),(2646069,'1','186','940',419,'Retail Sale Id 1637915',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:41:13','',''),(2646070,'1','186','940',419,'Retail Sale Id 1637916',4501.60,0.00,0.00,6.62,483.26,'2022-05-18 13:44:45','',''),(2646071,'1','186','940',419,'Retail Sale Id 1637918',15300.00,0.00,0.00,22.50,1642.50,'2022-05-18 13:52:24','',''),(2646072,'1','186','940',419,'Retail Sale Id 1637919',2998.80,0.00,0.00,4.41,321.93,'2022-05-18 13:53:39','',''),(2646073,'1','186','940',419,'Retail Sale Id 1637920',36540.00,0.00,0.00,58.00,1334.00,'2022-05-18 13:54:37','',''),(2646074,'1','186','940',419,'Retail Sale Id 1637921',6120.00,0.00,0.00,9.00,657.00,'2022-05-18 13:55:38','',''),(2646075,'1','186','940',419,'Retail Sale Id 1637922',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 13:56:31','',''),(2646076,'1','186','940',419,'Retail Sale Id 1637923',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:58:00','',''),(2646077,'1','186','940',419,'Retail Sale Id 1637924',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 13:59:22','',''),(2646078,'1','186','940',419,'Retail Sale Id 1637925',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 14:00:10','',''),(2646079,'1','186','940',419,'Retail Sale Id 1637926',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 14:01:23','',''),(2646080,'1','186','940',419,'Retail Sale Id 1637927',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 14:05:55','',''),(2646081,'1','186','940',419,'Retail Sale Id 1637928',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 14:10:26','',''),(2646082,'1','186','940',419,'Retail Sale Id 1637929',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 14:11:08','',''),(2646083,'1','186','940',419,'Retail Sale Id 1637930',2998.80,0.00,0.00,4.41,321.93,'2022-05-18 14:12:03','',''),(2646084,'1','186','940',419,'Retail Sale Id 1637931',11900.00,0.00,0.00,17.50,1277.50,'2022-05-18 14:13:03','',''),(2646085,'1','186','940',419,'Retail Sale Id 1637932',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 14:16:08','',''),(2646086,'1','186','940',419,'Retail Sale Id 1637933',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 14:19:07','',''),(2646087,'1','186','940',419,'Retail Sale Id 1637934',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 14:21:03','',''),(2646088,'1','186','940',419,'Retail Sale Id 1637935',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 14:22:38','',''),(2646089,'1','186','940',419,'Retail Sale Id 1637936',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 14:25:13','',''),(2646090,'1','186','940',419,'Retail Sale Id 1637937',6997.20,0.00,0.00,10.29,751.17,'2022-05-18 14:26:15','',''),(2646091,'1','186','940',419,'Retail Sale Id 1637938',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 14:27:03','',''),(2646092,'1','186','940',419,'Retail Sale Id 1637939',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 14:30:57','',''),(2646093,'1','186','940',419,'Retail Sale Id 1637940',3502.00,0.00,0.00,5.15,375.95,'2022-05-18 14:34:34','',''),(2646094,'1','186','940',419,'Retail Sale Id 1637941',6120.00,0.00,0.00,9.00,657.00,'2022-05-18 14:35:57','',''),(2646095,'1','186','940',419,'Retail Sale Id 1637942',1802.00,0.00,0.00,2.65,193.45,'2022-05-18 14:37:25','',''),(2646096,'1','186','940',419,'Retail Sale Id 1637943',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 14:39:05','',''),(2646097,'1','186','940',419,'Retail Sale Id 1637944',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 14:40:42','',''),(2646098,'1','186','940',419,'Retail Sale Id 1637945',3060.00,0.00,0.00,4.50,328.50,'2022-05-18 14:42:10','',''),(2646099,'1','186','940',419,'Retail Sale Id 1637946',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 14:43:04','',''),(2646100,'1','186','940',419,'Retail Sale Id 1637947',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 14:44:03','',''),(2646101,'1','186','940',419,'Retail Sale Id 1637948',492352.00,0.00,0.00,784.00,16464.00,'2022-05-18 14:46:59','',''),(2646102,'1','186','940',419,'Retail Sale Id 1637949',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 14:49:16','',''),(2646103,'1','186','940',419,'Retail Sale Id 1637950',30240.00,0.00,0.00,48.00,1104.00,'2022-05-18 14:50:59','',''),(2646104,'1','186','940',419,'Retail Sale Id 1637951',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 14:51:47','',''),(2646105,'1','186','940',419,'Retail Sale Id 1637952',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 14:52:27','',''),(2646106,'1','186','940',419,'Retail Sale Id 1637953',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 14:53:49','',''),(2646107,'1','186','940',419,'Retail Sale Id 1637954',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 14:54:50','',''),(2646108,'1','186','940',419,'Retail Sale Id 1637955',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 14:55:38','',''),(2646109,'1','186','940',419,'Retail Sale Id 1637956',25200.00,0.00,0.00,40.00,920.00,'2022-05-18 14:57:08','',''),(2646110,'1','186','940',419,'Retail Sale Id 1637957',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 14:58:24','',''),(2646111,'1','186','940',419,'Retail Sale Id 1637958',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 14:59:53','',''),(2646112,'1','186','940',419,'Retail Sale Id 1637959',2998.80,0.00,0.00,4.41,321.93,'2022-05-18 15:01:16','',''),(2646113,'1','186','940',419,'Retail Sale Id 1637960',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 15:02:43','',''),(2646114,'1','186','940',419,'Retail Sale Id 1637961',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 15:03:30','',''),(2646115,'1','186','940',419,'Retail Sale Id 1637962',4760.00,0.00,0.00,7.00,511.00,'2022-05-18 15:05:12','',''),(2646116,'1','186','940',419,'Retail Sale Id 1637963',2502.40,0.00,0.00,3.68,268.64,'2022-05-18 15:07:41','',''),(2646117,'1','186','940',419,'Retail Sale Id 1637964',999.60,0.00,0.00,1.47,107.31,'2022-05-18 15:08:27','',''),(2646118,'1','186','940',419,'Retail Sale Id 1637965',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 15:09:04','',''),(2646119,'1','186','940',419,'Retail Sale Id 1637966',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 15:09:47','',''),(2646120,'1','186','940',419,'Retail Sale Id 1637967',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:11:22','',''),(2646121,'1','186','940',419,'Retail Sale Id 1637968',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 15:12:43','',''),(2646122,'1','186','940',419,'Retail Sale Id 1637969',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:13:28','',''),(2646123,'1','186','940',419,'Retail Sale Id 1637970',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:18:23','',''),(2646124,'1','186','940',419,'Retail Sale Id 1637971',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 15:19:06','',''),(2646125,'1','186','940',419,'Retail Sale Id 1637972',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 15:21:25','',''),(2646126,'1','186','940',419,'Retail Sale Id 1637973',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:23:38','',''),(2646127,'1','186','940',419,'Retail Sale Id 1637974',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 15:25:01','',''),(2646128,'1','186','940',419,'Retail Sale Id 1637975',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 15:28:55','',''),(2646129,'1','186','940',419,'Retail Sale Id 1637976',17000.00,0.00,0.00,25.00,1825.00,'2022-05-18 15:30:25','',''),(2646130,'1','186','940',419,'Retail Sale Id 1637977',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:31:41','',''),(2646131,'1','186','940',419,'Retail Sale Id 1637978',2998.80,0.00,0.00,4.41,321.93,'2022-05-18 15:34:02','',''),(2646132,'1','186','940',419,'Retail Sale Id 1637979',23940.00,0.00,0.00,38.00,874.00,'2022-05-18 15:35:00','',''),(2646133,'1','186','940',419,'Retail Sale Id 1637980',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 15:35:47','',''),(2646134,'1','186','940',419,'Retail Sale Id 1637981',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:37:12','',''),(2646135,'1','186','940',419,'Retail Sale Id 1637982',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 15:37:57','',''),(2646136,'1','186','940',419,'Retail Sale Id 1637983',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 15:42:07','',''),(2646137,'1','186','940',419,'Retail Sale Id 1637984',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 15:43:18','',''),(2646138,'1','186','940',419,'Retail Sale Id 1637985',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 15:47:52','',''),(2646139,'1','186','940',419,'Retail Sale Id 1637986',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 15:48:53','',''),(2646140,'1','186','940',419,'Retail Sale Id 1637987',18900.00,0.00,0.00,30.00,690.00,'2022-05-18 15:51:03','',''),(2646141,'1','186','940',419,'Retail Sale Id 1637988',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 15:52:03','',''),(2646142,'1','186','940',419,'Retail Sale Id 1637989',17010.00,0.00,0.00,27.00,621.00,'2022-05-18 15:53:43','',''),(2646143,'1','186','940',419,'Retail Sale Id 1637990',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 15:54:32','',''),(2646144,'1','186','940',419,'Retail Sale Id 1637991',6997.20,0.00,0.00,10.29,751.17,'2022-05-18 15:55:11','',''),(2646145,'1','186','940',419,'Retail Sale Id 1637992',1400.80,0.00,0.00,2.06,150.38,'2022-05-18 15:56:24','',''),(2646146,'1','186','940',419,'Retail Sale Id 1637993',1400.80,0.00,0.00,2.06,150.38,'2022-05-18 15:57:04','',''),(2646147,'1','186','940',419,'Retail Sale Id 1637994',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 15:58:05','',''),(2646148,'1','186','940',419,'Retail Sale Id 1637995',1400.80,0.00,0.00,2.06,150.38,'2022-05-18 15:59:59','',''),(2646149,'1','186','940',419,'Retail Sale Id 1637996',2998.80,0.00,0.00,4.41,321.93,'2022-05-18 16:00:46','',''),(2646150,'1','186','940',419,'Retail Sale Id 1637997',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 16:05:05','',''),(2646151,'1','186','940',419,'Retail Sale Id 1637998',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 16:06:21','',''),(2646152,'1','186','940',419,'Retail Sale Id 1637999',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 16:07:12','',''),(2646153,'1','186','940',419,'Retail Sale Id 1638000',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 16:09:57','',''),(2646154,'1','186','940',419,'Retail Sale Id 1638001',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:11:43','',''),(2646155,'1','186','940',419,'Retail Sale Id 1638002',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 16:14:42','',''),(2646156,'1','186','940',419,'Retail Sale Id 1638003',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:15:34','',''),(2646157,'1','186','940',419,'Retail Sale Id 1638004',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 16:17:38','',''),(2646158,'1','186','940',419,'Retail Sale Id 1638005',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:18:45','',''),(2646159,'1','186','940',419,'Retail Sale Id 1638006',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 16:19:31','',''),(2646160,'1','186','940',419,'Retail Sale Id 1638007',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 16:21:07','',''),(2646161,'1','186','940',419,'Retail Sale Id 1638008',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 16:22:47','',''),(2646162,'1','186','940',419,'Retail Sale Id 1638009',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 16:23:38','',''),(2646163,'1','186','940',419,'Retail Sale Id 1638010',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 16:24:18','',''),(2646164,'1','186','940',419,'Retail Sale Id 1638011',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 16:25:20','',''),(2646165,'1','186','940',419,'Retail Sale Id 1638012',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 16:26:43','',''),(2646166,'1','186','940',419,'Retail Sale Id 1638013',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 16:28:31','',''),(2646167,'1','186','940',419,'Retail Sale Id 1638014',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 16:30:24','',''),(2646168,'1','186','940',419,'Retail Sale Id 1638015',5997.60,0.00,0.00,8.82,643.86,'2022-05-18 16:31:43','',''),(2646169,'1','186','940',419,'Retail Sale Id 1638016',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 16:33:00','',''),(2646170,'1','186','940',419,'Retail Sale Id 1638017',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 16:34:25','',''),(2646171,'1','186','940',419,'Retail Sale Id 1638018',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:35:46','',''),(2646172,'1','186','940',419,'Retail Sale Id 1638019',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:37:14','',''),(2646173,'1','186','940',419,'Retail Sale Id 1638020',2801.60,0.00,0.00,4.12,300.76,'2022-05-18 16:39:26','',''),(2646174,'1','186','940',419,'Retail Sale Id 1638021',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 16:40:02','',''),(2646175,'1','186','940',419,'Retail Sale Id 1638022',3502.00,0.00,0.00,5.15,375.95,'2022-05-18 16:40:43','',''),(2646176,'1','186','940',419,'Retail Sale Id 1638023',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 16:41:19','',''),(2646177,'1','186','940',419,'Retail Sale Id 1638024',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 16:42:15','',''),(2646178,'1','186','940',419,'Retail Sale Id 1638025',28980.00,0.00,0.00,46.00,1058.00,'2022-05-18 16:44:56','',''),(2646179,'1','186','940',419,'Retail Sale Id 1638026',1400.80,0.00,0.00,2.06,150.38,'2022-05-18 16:45:46','',''),(2646180,'1','186','940',419,'Retail Sale Id 1638027',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:47:15','',''),(2646181,'1','186','940',419,'Retail Sale Id 1638028',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 16:50:42','',''),(2646182,'1','186','940',419,'Retail Sale Id 1638029',1400.80,0.00,0.00,2.06,150.38,'2022-05-18 16:51:51','',''),(2646183,'1','186','940',419,'Retail Sale Id 1638030',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 16:52:41','',''),(2646184,'1','186','940',419,'Retail Sale Id 1638031',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 16:53:37','',''),(2646185,'1','186','940',419,'Retail Sale Id 1638032',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 16:54:46','',''),(2646186,'1','186','940',419,'Retail Sale Id 1638033',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 16:56:52','',''),(2646187,'1','186','940',419,'Retail Sale Id 1638034',6997.20,0.00,0.00,10.29,751.17,'2022-05-18 16:57:58','',''),(2646188,'1','186','940',419,'Retail Sale Id 1638035',1101.60,0.00,0.00,1.62,118.26,'2022-05-18 16:58:55','',''),(2646189,'1','186','940',419,'Retail Sale Id 1638036',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 17:00:14','',''),(2646190,'1','186','940',419,'Retail Sale Id 1638037',2998.80,0.00,0.00,4.41,321.93,'2022-05-18 17:01:23','',''),(2646191,'1','186','940',419,'Retail Sale Id 1638038',7201.20,0.00,0.00,10.59,773.07,'2022-05-18 17:02:48','',''),(2646192,'1','186','940',419,'Retail Sale Id 1638039',34650.00,0.00,0.00,55.00,1265.00,'2022-05-18 17:04:49','',''),(2646193,'1','186','940',419,'Retail Sale Id 1638040',3100.80,0.00,0.00,4.56,332.88,'2022-05-18 17:05:57','',''),(2646194,'1','186','940',419,'Retail Sale Id 1638041',5440.00,0.00,0.00,8.00,584.00,'2022-05-18 17:07:36','',''),(2646195,'1','186','940',419,'Retail Sale Id 1638042',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 17:08:37','',''),(2646196,'1','186','940',419,'Retail Sale Id 1638043',3502.00,0.00,0.00,5.15,375.95,'2022-05-18 17:09:40','',''),(2646197,'1','186','940',419,'Retail Sale Id 1638044',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 17:10:36','',''),(2646198,'1','186','940',419,'Retail Sale Id 1638045',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 17:11:44','',''),(2646199,'1','186','940',419,'Retail Sale Id 1638046',190402.80,0.00,0.00,280.00,20442.80,'2022-05-18 17:13:24','',''),(2646200,'1','186','940',419,'Retail Sale Id 1638047',2101.20,0.00,0.00,3.09,225.57,'2022-05-18 17:14:46','',''),(2646201,'1','186','940',419,'Retail Sale Id 1638048',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 17:16:34','',''),(2646202,'1','186','940',419,'Retail Sale Id 1638049',176400.00,0.00,0.00,280.00,6440.00,'2022-05-18 17:17:43','',''),(2646203,'1','186','940',419,'Retail Sale Id 1638050',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 17:20:26','',''),(2646204,'1','186','940',419,'Retail Sale Id 1638051',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 17:22:35','',''),(2646205,'1','186','940',419,'Retail Sale Id 1638052',26460.00,0.00,0.00,42.00,966.00,'2022-05-18 17:23:52','',''),(2646206,'1','186','940',419,'Retail Sale Id 1638053',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 17:25:04','',''),(2646207,'1','186','940',419,'Retail Sale Id 1638054',2101.20,0.00,0.00,3.09,225.57,'2022-05-18 17:25:51','',''),(2646208,'1','186','940',419,'Retail Sale Id 1638055',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 17:26:43','',''),(2646209,'1','186','940',419,'Retail Sale Id 1638056',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 17:27:20','',''),(2646210,'1','186','940',419,'Retail Sale Id 1638057',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 17:27:57','',''),(2646211,'1','186','940',419,'Retail Sale Id 1638058',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 17:28:53','',''),(2646212,'1','186','940',419,'Retail Sale Id 1638059',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 17:29:49','',''),(2646213,'1','186','940',419,'Retail Sale Id 1638060',2502.40,0.00,0.00,3.68,268.64,'2022-05-18 17:30:39','',''),(2646214,'1','186','940',419,'Retail Sale Id 1638061',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 17:31:19','',''),(2646215,'1','186','940',419,'Retail Sale Id 1638062',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 17:32:06','',''),(2646216,'1','186','940',419,'Retail Sale Id 1638063',6997.20,0.00,0.00,10.29,751.17,'2022-05-18 17:32:54','',''),(2646217,'1','186','940',419,'Retail Sale Id 1638064',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 17:33:42','',''),(2646218,'1','186','940',419,'Retail Sale Id 1638065',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 17:34:27','',''),(2646219,'1','186','940',419,'Retail Sale Id 1638066',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 17:35:42','',''),(2646220,'1','186','940',419,'Retail Sale Id 1638067',1196.80,0.00,0.00,1.76,128.48,'2022-05-18 17:36:34','',''),(2646221,'1','186','940',419,'Retail Sale Id 1638068',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 17:38:58','',''),(2646222,'1','186','940',419,'Retail Sale Id 1638069',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 17:39:36','',''),(2646223,'1','186','940',419,'Retail Sale Id 1638070',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 17:40:10','',''),(2646224,'1','186','940',419,'Retail Sale Id 1638071',9520.00,0.00,0.00,14.00,1022.00,'2022-05-18 17:40:51','',''),(2646225,'1','186','940',419,'Retail Sale Id 1638072',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 17:41:32','',''),(2646226,'1','186','940',419,'Retail Sale Id 1638073',5997.60,0.00,0.00,8.82,643.86,'2022-05-18 17:42:21','',''),(2646227,'1','186','940',419,'Retail Sale Id 1638074',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 17:42:59','',''),(2646228,'1','186','940',419,'Retail Sale Id 1638075',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 17:43:34','',''),(2646229,'1','186','940',419,'Retail Sale Id 1638076',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 17:44:14','',''),(2646230,'1','186','940',419,'Retail Sale Id 1638077',999.60,0.00,0.00,1.47,107.31,'2022-05-18 17:44:57','',''),(2646231,'1','186','940',419,'Retail Sale Id 1638078',2502.40,0.00,0.00,3.68,268.64,'2022-05-18 17:45:34','',''),(2646232,'1','186','940',419,'Retail Sale Id 1638079',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 17:46:18','',''),(2646233,'1','186','940',419,'Retail Sale Id 1638080',2720.00,0.00,0.00,4.00,292.00,'2022-05-18 17:47:23','',''),(2646234,'1','186','940',419,'Retail Sale Id 1638081',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 17:48:11','',''),(2646235,'1','186','940',419,'Retail Sale Id 1638082',6997.20,0.00,0.00,10.29,751.17,'2022-05-18 17:49:05','',''),(2646236,'1','186','940',419,'Retail Sale Id 1638083',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 17:49:43','',''),(2646237,'1','186','940',419,'Retail Sale Id 1638084',1360.00,0.00,0.00,2.00,146.00,'2022-05-18 17:50:19','',''),(2646238,'1','186','940',419,'Retail Sale Id 1638085',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 17:51:09','',''),(2646239,'1','186','940',419,'Retail Sale Id 1638086',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 17:51:46','',''),(2646240,'1','186','940',419,'Retail Sale Id 1638087',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 17:52:35','',''),(2646241,'1','186','940',419,'Retail Sale Id 1638088',1802.00,0.00,0.00,2.65,193.45,'2022-05-18 17:53:16','',''),(2646242,'1','186','940',419,'Retail Sale Id 1638089',3400.00,0.00,0.00,5.00,365.00,'2022-05-18 17:53:53','',''),(2646243,'1','186','940',419,'Retail Sale Id 1638090',4080.00,0.00,0.00,6.00,438.00,'2022-05-18 17:54:37','',''),(2646244,'1','186','940',419,'Retail Sale Id 1638091',31500.00,0.00,0.00,50.00,1150.00,'2022-05-18 17:55:33','',''),(2646245,'1','186','940',419,'Retail Sale Id 1638092',1196.80,0.00,0.00,1.76,128.48,'2022-05-18 17:56:50','',''),(2646246,'1','186','940',419,'Retail Sale Id 1638093',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 17:57:39','',''),(2646247,'1','186','940',419,'Retail Sale Id 1638094',3998.40,0.00,0.00,5.88,429.24,'2022-05-18 17:58:03','',''),(2646248,'1','186','940',419,'Retail Sale Id 1638095',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 17:58:31','',''),(2646249,'1','186','940',419,'Retail Sale Id 1638096',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 17:59:02','',''),(2646250,'1','186','940',419,'Retail Sale Id 1638097',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 17:59:28','',''),(2646251,'1','186','940',419,'Retail Sale Id 1638098',4760.00,0.00,0.00,7.00,511.00,'2022-05-18 17:59:58','',''),(2646252,'1','186','940',419,'Retail Sale Id 1638099',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 18:01:06','',''),(2646253,'1','186','940',419,'Retail Sale Id 1638100',6800.00,0.00,0.00,10.00,730.00,'2022-05-18 18:01:33','',''),(2646254,'1','186','940',419,'Retail Sale Id 1638101',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 18:02:23','',''),(2646255,'1','186','940',419,'Retail Sale Id 1638102',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 18:02:55','',''),(2646256,'1','186','940',419,'Retail Sale Id 1638103',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 18:03:21','',''),(2646257,'1','186','940',419,'Retail Sale Id 1638104',4998.00,0.00,0.00,7.35,536.55,'2022-05-18 18:03:46','',''),(2646258,'1','186','940',419,'Retail Sale Id 1638106',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 18:04:27','',''),(2646259,'1','186','940',419,'Retail Sale Id 1638107',8500.00,0.00,0.00,12.50,912.50,'2022-05-18 18:05:02','',''),(2646260,'1','186','940',419,'Retail Sale Id 1638108',16320.00,0.00,0.00,24.00,1752.00,'2022-05-18 18:05:57','',''),(2646261,'1','186','940',419,'Retail Sale Id 1638109',3298.00,0.00,0.00,4.85,354.05,'2022-05-18 18:07:01','',''),(2646262,'1','186','940',419,'Retail Sale Id 1638110',2380.00,0.00,0.00,3.50,255.50,'2022-05-18 18:07:37','',''),(2646263,'1','186','940',419,'Retail Sale Id 1638112',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 18:08:43','',''),(2646264,'1','186','940',419,'Retail Sale Id 1638113',10540.00,0.00,0.00,15.50,1131.50,'2022-05-18 18:09:12','',''),(2646265,'1','186','940',419,'Retail Sale Id 1638114',15750.00,0.00,0.00,25.00,575.00,'2022-05-18 18:09:47','',''),(2646266,'1','186','940',419,'Retail Sale Id 1638115',2040.00,0.00,0.00,3.00,219.00,'2022-05-18 18:10:21','',''),(2646267,'1','186','940',419,'Retail Sale Id 1638116',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 18:10:57','',''),(2646268,'1','186','940',419,'Retail Sale Id 1638117',1502.80,0.00,0.00,2.21,161.33,'2022-05-18 18:11:33','',''),(2646269,'1','186','940',419,'Retail Sale Id 1638118',15750.00,0.00,0.00,25.00,575.00,'2022-05-18 18:12:18','',''),(2646270,'1','186','940',419,'Retail Sale Id 1638119',1999.20,0.00,0.00,2.94,214.62,'2022-05-18 18:12:49','',''),(2646271,'1','186','940',419,'Return of Retail Sale Id 1638046',0.00,190402.80,280.00,0.00,-20442.80,'2022-05-18 18:58:16','',''),(2646272,'1','186','940',419,'Retail Sale Id 1638120',11696.00,0.00,0.00,17.20,1255.60,'2022-05-18 20:28:46','',''),(2646273,'1','186','940',419,'Retail Sale Id 1638124',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 07:12:55','',''),(2646274,'1','186','940',419,'Retail Sale Id 1638125',25200.00,0.00,0.00,40.00,920.00,'2022-05-19 07:22:23','',''),(2646275,'1','186','940',419,'Retail Sale Id 1638126',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 07:26:09','',''),(2646276,'1','186','940',419,'Retail Sale Id 1638127',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 07:28:14','',''),(2646277,'1','186','940',419,'Retail Sale Id 1638128',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 07:30:12','',''),(2646278,'1','186','940',419,'Retail Sale Id 1638129',4998.00,0.00,0.00,7.35,536.55,'2022-05-19 07:31:10','',''),(2646279,'1','186','940',419,'Retail Sale Id 1638130',4998.00,0.00,0.00,7.35,536.55,'2022-05-19 07:32:10','',''),(2646280,'1','186','940',419,'Retail Sale Id 1638131',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 07:35:49','',''),(2646281,'1','186','940',419,'Retail Sale Id 1638132',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 07:39:11','',''),(2646282,'1','186','940',419,'Retail Sale Id 1638133',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 07:41:16','',''),(2646283,'1','186','940',419,'Retail Sale Id 1638134',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 07:42:50','',''),(2646284,'1','186','940',419,'Retail Sale Id 1638135',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 07:45:38','',''),(2646285,'1','186','940',419,'Retail Sale Id 1638136',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 07:46:39','',''),(2646286,'1','186','940',419,'Retail Sale Id 1638137',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 07:47:33','',''),(2646287,'1','186','940',419,'Retail Sale Id 1638138',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 07:49:30','',''),(2646288,'1','186','940',419,'Retail Sale Id 1638139',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 07:50:54','',''),(2646289,'1','186','940',419,'Retail Sale Id 1638140',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 07:51:49','',''),(2646290,'1','186','940',419,'Retail Sale Id 1638141',37800.00,0.00,0.00,60.00,1380.00,'2022-05-19 07:53:50','',''),(2646291,'1','186','940',419,'Retail Sale Id 1638142',34650.00,0.00,0.00,55.00,1265.00,'2022-05-19 07:55:03','',''),(2646292,'1','186','940',419,'Retail Sale Id 1638143',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 07:56:16','',''),(2646293,'1','186','940',419,'Retail Sale Id 1638144',999.60,0.00,0.00,1.47,107.31,'2022-05-19 07:56:58','',''),(2646294,'1','186','940',419,'Retail Sale Id 1638145',2502.40,0.00,0.00,3.68,268.64,'2022-05-19 07:57:53','',''),(2646295,'1','186','940',419,'Retail Sale Id 1638146',5997.60,0.00,0.00,8.82,643.86,'2022-05-19 07:59:14','',''),(2646296,'1','186','940',419,'Retail Sale Id 1638147',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 08:00:19','',''),(2646297,'1','186','940',419,'Retail Sale Id 1638148',7480.00,0.00,0.00,11.00,803.00,'2022-05-19 08:03:25','',''),(2646298,'1','186','940',419,'Retail Sale Id 1638149',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:04:35','',''),(2646299,'1','186','940',419,'Retail Sale Id 1638150',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 08:05:47','',''),(2646300,'1','186','940',419,'Retail Sale Id 1638151',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 08:06:51','',''),(2646301,'1','186','940',419,'Retail Sale Id 1638152',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:08:31','',''),(2646302,'1','186','940',419,'Retail Sale Id 1638152',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:08:31','',''),(2646303,'1','186','940',419,'Retail Sale Id 1638153',25200.00,0.00,0.00,40.00,920.00,'2022-05-19 08:12:02','',''),(2646304,'1','186','940',419,'Retail Sale Id 1638154',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 08:13:28','',''),(2646305,'1','186','940',419,'Retail Sale Id 1638155',8840.00,0.00,0.00,13.00,949.00,'2022-05-19 08:15:27','',''),(2646306,'1','186','940',419,'Retail Sale Id 1638157',27720.00,0.00,0.00,44.00,1012.00,'2022-05-19 08:17:27','',''),(2646307,'1','186','940',419,'Retail Sale Id 1638158',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 08:19:57','',''),(2646308,'1','186','940',419,'Retail Sale Id 1638159',999.60,0.00,0.00,1.47,107.31,'2022-05-19 08:21:36','',''),(2646309,'1','186','940',419,'Retail Sale Id 1638160',10200.00,0.00,0.00,15.00,1095.00,'2022-05-19 08:22:23','',''),(2646310,'1','186','940',419,'Retail Sale Id 1638161',999.60,0.00,0.00,1.47,107.31,'2022-05-19 08:23:01','',''),(2646311,'1','186','940',419,'Retail Sale Id 1638162',1196.80,0.00,0.00,1.76,128.48,'2022-05-19 08:23:43','',''),(2646312,'1','186','940',419,'Retail Sale Id 1638163',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 08:24:54','',''),(2646313,'1','186','940',419,'Retail Sale Id 1638164',4998.00,0.00,0.00,7.35,536.55,'2022-05-19 08:25:34','',''),(2646314,'1','186','940',419,'Retail Sale Id 1638165',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 08:26:18','',''),(2646315,'1','186','940',419,'Retail Sale Id 1638166',8160.00,0.00,0.00,12.00,876.00,'2022-05-19 08:27:40','',''),(2646316,'1','186','940',419,'Retail Sale Id 1638167',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 08:29:00','',''),(2646317,'1','186','940',419,'Retail Sale Id 1638168',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:30:47','',''),(2646318,'1','186','940',419,'Retail Sale Id 1638169',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 08:31:31','',''),(2646319,'1','186','940',419,'Retail Sale Id 1638170',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 08:33:24','',''),(2646320,'1','186','940',419,'Retail Sale Id 1638171',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 08:34:46','',''),(2646321,'1','186','940',419,'Retail Sale Id 1638172',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 08:35:48','',''),(2646322,'1','186','940',419,'Retail Sale Id 1638173',2502.40,0.00,0.00,3.68,268.64,'2022-05-19 08:36:46','',''),(2646323,'1','186','940',419,'Retail Sale Id 1638174',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:37:54','',''),(2646324,'1','186','940',419,'Retail Sale Id 1638175',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 08:39:47','',''),(2646325,'1','186','940',419,'Retail Sale Id 1638176',15750.00,0.00,0.00,25.00,575.00,'2022-05-19 08:42:29','',''),(2646326,'1','186','940',419,'Retail Sale Id 1638177',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 08:43:20','',''),(2646327,'1','186','940',419,'Retail Sale Id 1638178',3100.80,0.00,0.00,4.56,332.88,'2022-05-19 08:44:32','',''),(2646328,'1','186','940',419,'Retail Sale Id 1638179',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 08:45:37','',''),(2646329,'1','186','940',419,'Retail Sale Id 1638180',9520.00,0.00,0.00,14.00,1022.00,'2022-05-19 08:46:47','',''),(2646330,'1','186','940',419,'Retail Sale Id 1638181',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 08:47:48','',''),(2646331,'1','186','940',419,'Retail Sale Id 1638182',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 08:49:04','',''),(2646332,'1','186','940',419,'Retail Sale Id 1638183',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:50:31','',''),(2646333,'1','186','940',419,'Retail Sale Id 1638184',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 08:51:20','',''),(2646334,'1','186','940',419,'Retail Sale Id 1638185',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 08:52:07','',''),(2646335,'1','186','940',419,'Retail Sale Id 1638186',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 08:53:14','',''),(2646336,'1','186','940',419,'Retail Sale Id 1638187',63000.00,0.00,0.00,100.00,2300.00,'2022-05-19 08:58:48','',''),(2646337,'1','186','940',419,'Retail Sale Id 1638188',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 08:59:51','',''),(2646338,'1','186','940',419,'Retail Sale Id 1638189',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 09:00:30','',''),(2646339,'1','186','940',419,'Retail Sale Id 1638190',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 09:01:13','',''),(2646340,'1','186','940',419,'Retail Sale Id 1638191',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 09:01:53','',''),(2646341,'1','186','940',419,'Retail Sale Id 1638192',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 09:03:34','',''),(2646342,'1','186','940',419,'Retail Sale Id 1638193',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 09:04:20','',''),(2646343,'1','186','940',419,'Retail Sale Id 1638194',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 09:04:57','',''),(2646344,'1','186','940',419,'Retail Sale Id 1638195',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 09:05:32','',''),(2646345,'1','186','940',419,'Retail Sale Id 1638196',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 09:06:17','',''),(2646346,'1','186','940',419,'Retail Sale Id 1638197',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 09:07:01','',''),(2646347,'1','186','940',419,'Retail Sale Id 1638198',6201.60,0.00,0.00,9.12,665.76,'2022-05-19 09:08:06','',''),(2646348,'1','186','940',419,'Retail Sale Id 1638199',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 09:08:55','',''),(2646349,'1','186','940',419,'Retail Sale Id 1638200',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 09:09:43','',''),(2646350,'1','186','940',419,'Retail Sale Id 1638201',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 09:10:42','',''),(2646351,'1','186','940',419,'Retail Sale Id 1638202',22050.00,0.00,0.00,35.00,805.00,'2022-05-19 09:13:49','',''),(2646352,'1','186','940',419,'Retail Sale Id 1638203',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 09:14:51','',''),(2646353,'1','186','940',419,'Retail Sale Id 1638204',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 09:16:44','',''),(2646354,'1','186','940',419,'Retail Sale Id 1638206',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 09:28:10','',''),(2646355,'1','186','940',419,'Retail Sale Id 1638206',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 09:28:10','',''),(2646356,'1','186','940',419,'Retail Sale Id 1638206',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 09:28:10','',''),(2646357,'1','186','940',419,'Retail Sale Id 1638207',7480.00,0.00,0.00,11.00,803.00,'2022-05-19 09:29:24','',''),(2646358,'1','186','940',419,'Retail Sale Id 1638208',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 09:30:56','',''),(2646359,'1','186','940',419,'Retail Sale Id 1638208',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 09:30:56','',''),(2646360,'1','186','940',419,'Retail Sale Id 1638209',999.60,0.00,0.00,1.47,107.31,'2022-05-19 09:31:38','',''),(2646361,'1','186','940',419,'Retail Sale Id 1638210',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 09:32:41','',''),(2646362,'1','186','940',419,'Retail Sale Id 1638211',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 09:34:12','',''),(2646363,'1','186','940',419,'Retail Sale Id 1638212',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 09:34:58','',''),(2646364,'1','186','940',419,'Retail Sale Id 1638213',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 09:35:51','',''),(2646365,'1','186','940',419,'Retail Sale Id 1638214',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 09:37:54','',''),(2646366,'1','186','940',419,'Retail Sale Id 1638215',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 09:38:53','',''),(2646367,'1','186','940',419,'Retail Sale Id 1638216',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 09:39:42','',''),(2646368,'1','186','940',419,'Retail Sale Id 1638217',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 09:40:30','',''),(2646369,'1','186','940',419,'Retail Sale Id 1638218',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 09:44:25','',''),(2646370,'1','186','940',419,'Retail Sale Id 1638219',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 09:47:16','',''),(2646371,'1','186','940',419,'Retail Sale Id 1638220',999.60,0.00,0.00,1.47,107.31,'2022-05-19 09:49:29','',''),(2646372,'1','186','940',419,'Retail Sale Id 1638221',7480.00,0.00,0.00,11.00,803.00,'2022-05-19 09:54:13','',''),(2646373,'1','186','940',419,'Retail Sale Id 1638222',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 10:02:59','',''),(2646374,'1','186','940',419,'Retail Sale Id 1638223',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 10:05:40','',''),(2646375,'1','186','940',419,'Retail Sale Id 1638224',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:06:27','',''),(2646376,'1','186','940',419,'Retail Sale Id 1638225',21483.00,0.00,0.00,34.10,784.30,'2022-05-19 10:08:05','',''),(2646377,'1','186','940',419,'Retail Sale Id 1638226',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 10:09:17','',''),(2646378,'1','186','940',419,'Retail Sale Id 1638228',9520.00,0.00,0.00,14.00,1022.00,'2022-05-19 10:16:14','',''),(2646379,'1','186','940',419,'Retail Sale Id 1638229',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:22:34','',''),(2646380,'1','186','940',419,'Retail Sale Id 1638230',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 10:23:34','',''),(2646381,'1','186','940',419,'Retail Sale Id 1638231',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 10:24:40','',''),(2646382,'1','186','940',419,'Retail Sale Id 1638232',999.60,0.00,0.00,1.47,107.31,'2022-05-19 10:25:39','',''),(2646383,'1','186','940',419,'Retail Sale Id 1638233',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 10:26:33','',''),(2646384,'1','186','940',419,'Retail Sale Id 1638234',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 10:27:17','',''),(2646385,'1','186','940',419,'Retail Sale Id 1638235',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 10:28:25','',''),(2646386,'1','186','940',419,'Retail Sale Id 1638236',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 10:29:35','',''),(2646387,'1','186','940',419,'Retail Sale Id 1638237',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:34:04','',''),(2646388,'1','186','940',419,'Retail Sale Id 1638238',15750.00,0.00,0.00,25.00,575.00,'2022-05-19 10:35:33','',''),(2646389,'1','186','940',419,'Retail Sale Id 1638239',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 10:36:24','',''),(2646390,'1','186','940',419,'Retail Sale Id 1638240',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:38:26','',''),(2646391,'1','186','940',419,'Retail Sale Id 1638240',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 10:38:26','',''),(2646392,'1','186','940',419,'Retail Sale Id 1638241',30870.00,0.00,0.00,49.00,1127.00,'2022-05-19 10:39:53','',''),(2646393,'1','186','940',419,'Retail Sale Id 1638242',94500.00,0.00,0.00,150.00,3450.00,'2022-05-19 10:42:09','',''),(2646394,'1','186','940',419,'Retail Sale Id 1638243',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 10:43:38','',''),(2646395,'1','186','940',419,'Retail Sale Id 1638244',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:44:28','',''),(2646396,'1','186','940',419,'Retail Sale Id 1638245',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 10:45:17','',''),(2646397,'1','186','940',419,'Retail Sale Id 1638246',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 10:46:05','',''),(2646398,'1','186','940',419,'Retail Sale Id 1638247',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:47:01','',''),(2646399,'1','186','940',419,'Retail Sale Id 1638248',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 10:47:44','',''),(2646400,'1','186','940',419,'Retail Sale Id 1638249',2502.40,0.00,0.00,3.68,268.64,'2022-05-19 10:48:18','',''),(2646401,'1','186','940',419,'Retail Sale Id 1638250',8160.00,0.00,0.00,12.00,876.00,'2022-05-19 10:49:02','',''),(2646402,'1','186','940',419,'Retail Sale Id 1638251',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 10:50:01','',''),(2646403,'1','186','940',419,'Retail Sale Id 1638252',30240.00,0.00,0.00,48.00,1104.00,'2022-05-19 10:53:33','',''),(2646404,'1','186','940',419,'Retail Sale Id 1638253',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 10:56:43','',''),(2646405,'1','186','940',419,'Retail Sale Id 1638254',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 10:57:47','',''),(2646406,'1','186','940',419,'Retail Sale Id 1638255',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 10:58:44','',''),(2646407,'1','186','940',419,'Retail Sale Id 1638256',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 10:59:56','',''),(2646408,'1','186','940',419,'Retail Sale Id 1638257',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 11:01:34','',''),(2646409,'1','186','940',419,'Retail Sale Id 1638258',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 11:02:25','',''),(2646410,'1','186','940',419,'Retail Sale Id 1638259',1700.00,0.00,0.00,2.50,182.50,'2022-05-19 11:03:27','',''),(2646411,'1','186','940',419,'Retail Sale Id 1638260',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 11:04:20','',''),(2646412,'1','186','940',419,'Retail Sale Id 1638261',1298.80,0.00,0.00,1.91,139.43,'2022-05-19 11:05:10','',''),(2646413,'1','186','940',419,'Retail Sale Id 1638262',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 11:06:00','',''),(2646414,'1','186','940',419,'Retail Sale Id 1638263',4998.00,0.00,0.00,7.35,536.55,'2022-05-19 11:06:55','',''),(2646415,'1','186','940',419,'Retail Sale Id 1638264',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 11:08:01','',''),(2646416,'1','186','940',419,'Retail Sale Id 1638265',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 11:09:46','',''),(2646417,'1','186','940',419,'Retail Sale Id 1638266',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 11:11:05','',''),(2646418,'1','186','940',419,'Retail Sale Id 1638267',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 11:12:54','',''),(2646419,'1','186','940',419,'Retail Sale Id 1638268',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 11:15:47','',''),(2646420,'1','186','940',419,'Retail Sale Id 1638268',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 11:15:47','',''),(2646421,'1','186','940',419,'Retail Sale Id 1638269',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 11:17:04','',''),(2646422,'1','186','940',419,'Retail Sale Id 1638270',999.60,0.00,0.00,1.47,107.31,'2022-05-19 11:19:04','',''),(2646423,'1','186','940',419,'Retail Sale Id 1638271',7996.80,0.00,0.00,11.76,858.48,'2022-05-19 11:20:01','',''),(2646424,'1','186','940',419,'Retail Sale Id 1638272',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 11:29:25','',''),(2646425,'1','186','940',419,'Retail Sale Id 1638274',3998.40,0.00,0.00,5.88,429.24,'2022-05-19 11:30:52','',''),(2646426,'1','186','940',419,'Retail Sale Id 1638275',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 11:32:23','',''),(2646427,'1','186','940',419,'Retail Sale Id 1638276',999.60,0.00,0.00,1.47,107.31,'2022-05-19 11:34:55','',''),(2646428,'1','186','940',419,'Retail Sale Id 1638277',15750.00,0.00,0.00,25.00,575.00,'2022-05-19 11:39:47','',''),(2646429,'1','186','940',419,'Retail Sale Id 1638278',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 11:41:12','',''),(2646430,'1','186','940',419,'Retail Sale Id 1638279',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 11:42:30','',''),(2646431,'1','186','940',419,'Retail Sale Id 1638280',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 11:44:22','',''),(2646432,'1','186','940',419,'Retail Sale Id 1638281',4998.00,0.00,0.00,7.35,536.55,'2022-05-19 11:46:03','',''),(2646433,'1','186','940',419,'Retail Sale Id 1638282',42840.00,0.00,0.00,68.00,1564.00,'2022-05-19 11:53:02','',''),(2646434,'1','186','940',419,'Retail Sale Id 1638284',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 11:56:32','',''),(2646435,'1','186','940',419,'Retail Sale Id 1638287',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 11:59:32','',''),(2646436,'1','186','940',419,'Retail Sale Id 1638287',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 11:59:32','',''),(2646437,'1','186','940',419,'Retail Sale Id 1638288',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 12:01:19','',''),(2646438,'1','186','940',419,'Retail Sale Id 1638290',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 12:03:27','',''),(2646439,'1','186','940',419,'Retail Sale Id 1638291',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 12:04:36','',''),(2646440,'1','186','940',419,'Retail Sale Id 1638292',36540.00,0.00,0.00,58.00,1334.00,'2022-05-19 12:14:54','',''),(2646441,'1','186','940',419,'Retail Sale Id 1638293',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 12:16:00','',''),(2646442,'1','186','940',419,'Retail Sale Id 1638294',34020.00,0.00,0.00,54.00,1242.00,'2022-05-19 12:17:16','',''),(2646443,'1','186','940',419,'Retail Sale Id 1638295',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 12:18:11','',''),(2646444,'1','186','940',419,'Retail Sale Id 1638296',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 12:19:07','',''),(2646445,'1','186','940',419,'Retail Sale Id 1638297',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 12:19:48','',''),(2646446,'1','186','940',419,'Retail Sale Id 1638298',34650.00,0.00,0.00,55.00,1265.00,'2022-05-19 12:20:40','',''),(2646447,'1','186','940',419,'Retail Sale Id 1638299',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 12:21:31','',''),(2646448,'1','186','940',419,'Retail Sale Id 1638300',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 12:23:10','',''),(2646449,'1','186','940',419,'Retail Sale Id 1638300',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 12:23:10','',''),(2646450,'1','186','940',419,'Retail Sale Id 1638300',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 12:23:10','',''),(2646451,'1','186','940',419,'Retail Sale Id 1638301',3100.80,0.00,0.00,4.56,332.88,'2022-05-19 12:25:43','',''),(2646452,'1','186','940',419,'Retail Sale Id 1638302',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 12:28:17','',''),(2646453,'1','186','940',419,'Retail Sale Id 1638303',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 12:29:08','',''),(2646454,'1','186','940',419,'Retail Sale Id 1638304',15750.00,0.00,0.00,25.00,575.00,'2022-05-19 12:30:20','',''),(2646455,'1','186','940',419,'Retail Sale Id 1638305',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 12:31:55','',''),(2646456,'1','186','940',419,'Retail Sale Id 1638305',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 12:31:55','',''),(2646457,'1','186','940',419,'Retail Sale Id 1638306',1196.80,0.00,0.00,1.76,128.48,'2022-05-19 12:33:09','',''),(2646458,'1','186','940',419,'Retail Sale Id 1638306',1196.80,0.00,0.00,1.76,128.48,'2022-05-19 12:33:09','',''),(2646459,'1','186','940',419,'Retail Sale Id 1638307',50400.00,0.00,0.00,80.00,1840.00,'2022-05-19 12:34:40','',''),(2646460,'1','186','940',419,'Retail Sale Id 1638308',30870.00,0.00,0.00,49.00,1127.00,'2022-05-19 12:35:42','',''),(2646461,'1','186','940',419,'Retail Sale Id 1638309',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 12:36:34','',''),(2646462,'1','186','940',419,'Retail Sale Id 1638310',999.60,0.00,0.00,1.47,107.31,'2022-05-19 12:37:17','',''),(2646463,'1','186','940',419,'Retail Sale Id 1638311',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 12:38:55','',''),(2646464,'1','186','940',419,'Retail Sale Id 1638312',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 12:41:55','',''),(2646465,'1','186','940',419,'Retail Sale Id 1638312',7140.00,0.00,0.00,10.50,766.50,'2022-05-19 12:41:55','',''),(2646466,'1','186','940',419,'Retail Sale Id 1638312',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 12:41:55','',''),(2646467,'1','186','940',419,'Retail Sale Id 1638313',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 12:43:24','',''),(2646468,'1','186','940',419,'Retail Sale Id 1638314',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 12:44:37','',''),(2646469,'1','186','940',419,'Retail Sale Id 1638315',12240.00,0.00,0.00,18.00,1314.00,'2022-05-19 12:46:08','',''),(2646470,'1','186','940',419,'Retail Sale Id 1638316',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 13:09:34','',''),(2646471,'1','186','940',419,'Retail Sale Id 1638318',2502.40,0.00,0.00,3.68,268.64,'2022-05-19 13:10:47','',''),(2646472,'1','186','940',419,'Retail Sale Id 1638319',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 13:11:34','',''),(2646473,'1','186','940',419,'Retail Sale Id 1638320',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 13:13:26','',''),(2646474,'1','186','940',419,'Retail Sale Id 1638320',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 13:13:26','',''),(2646475,'1','186','940',419,'Retail Sale Id 1638321',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 13:21:32','',''),(2646476,'1','186','940',419,'Retail Sale Id 1638322',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 13:22:23','',''),(2646477,'1','186','940',419,'Retail Sale Id 1638323',47250.00,0.00,0.00,75.00,1725.00,'2022-05-19 13:23:13','',''),(2646478,'1','186','940',419,'Retail Sale Id 1638324',6997.20,0.00,0.00,10.29,751.17,'2022-05-19 13:23:45','',''),(2646479,'1','186','940',419,'Retail Sale Id 1638326',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 13:24:23','',''),(2646480,'1','186','940',419,'Retail Sale Id 1638327',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 13:24:51','',''),(2646481,'1','186','940',419,'Retail Sale Id 1638328',999.60,0.00,0.00,1.47,107.31,'2022-05-19 13:25:18','',''),(2646482,'1','186','940',419,'Retail Sale Id 1638329',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 13:25:48','',''),(2646483,'1','186','940',419,'Retail Sale Id 1638331',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 13:27:02','',''),(2646484,'1','186','940',419,'Retail Sale Id 1638331',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 13:27:02','',''),(2646485,'1','186','940',419,'Retail Sale Id 1638332',63000.00,0.00,0.00,100.00,2300.00,'2022-05-19 13:28:16','',''),(2646486,'1','186','940',419,'Retail Sale Id 1638333',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 13:30:50','',''),(2646487,'1','186','940',419,'Retail Sale Id 1638334',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 13:32:28','',''),(2646488,'1','186','940',419,'Retail Sale Id 1638335',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 13:34:03','',''),(2646489,'1','186','940',419,'Retail Sale Id 1638336',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 13:35:26','',''),(2646490,'1','186','940',419,'Retail Sale Id 1638337',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 13:36:19','',''),(2646491,'1','186','940',419,'Retail Sale Id 1638338',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 13:38:22','',''),(2646492,'1','186','940',419,'Retail Sale Id 1638339',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 13:39:33','',''),(2646493,'1','186','940',419,'Retail Sale Id 1638340',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 13:42:00','',''),(2646494,'1','186','940',419,'Retail Sale Id 1638341',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 13:45:49','',''),(2646495,'1','186','940',419,'Retail Sale Id 1638350',12580.00,0.00,0.00,18.50,1350.50,'2022-05-19 13:49:30','',''),(2646496,'1','186','940',419,'Retail Sale Id 1638355',4998.00,0.00,0.00,7.35,536.55,'2022-05-19 13:51:56','',''),(2646497,'1','186','940',419,'Retail Sale Id 1638356',68040.00,0.00,0.00,108.00,2484.00,'2022-05-19 13:55:50','',''),(2646498,'1','186','940',419,'Retail Sale Id 1638357',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 13:56:22','',''),(2646499,'1','186','940',419,'Retail Sale Id 1638358',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 13:57:19','',''),(2646500,'1','186','940',419,'Retail Sale Id 1638359',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 13:58:38','',''),(2646501,'1','186','940',419,'Retail Sale Id 1638360',999.60,0.00,0.00,1.47,107.31,'2022-05-19 13:59:20','',''),(2646502,'1','186','940',419,'Retail Sale Id 1638361',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 14:01:01','',''),(2646503,'1','186','940',419,'Retail Sale Id 1638361',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 14:01:01','',''),(2646504,'1','186','940',419,'Retail Sale Id 1638361',9520.00,0.00,0.00,14.00,1022.00,'2022-05-19 14:01:01','',''),(2646505,'1','186','940',419,'Retail Sale Id 1638362',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 14:02:58','',''),(2646506,'1','186','940',419,'Retail Sale Id 1638363',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 14:03:54','',''),(2646507,'1','186','940',419,'Retail Sale Id 1638364',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:05:26','',''),(2646508,'1','186','940',419,'Retail Sale Id 1638365',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 14:09:28','',''),(2646509,'1','186','940',419,'Retail Sale Id 1638366',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:10:55','',''),(2646510,'1','186','940',419,'Retail Sale Id 1638367',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 14:14:58','',''),(2646511,'1','186','940',419,'Retail Sale Id 1638368',8200.80,0.00,0.00,12.06,880.38,'2022-05-19 14:19:22','',''),(2646512,'1','186','940',419,'Retail Sale Id 1638369',6099.60,0.00,0.00,8.97,654.81,'2022-05-19 14:21:12','',''),(2646513,'1','186','940',419,'Retail Sale Id 1638370',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 14:22:57','',''),(2646514,'1','186','940',419,'Retail Sale Id 1638371',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 14:26:23','',''),(2646515,'1','186','940',419,'Retail Sale Id 1638371',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:26:23','',''),(2646516,'1','186','940',419,'Retail Sale Id 1638372',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 14:27:00','',''),(2646517,'1','186','940',419,'Retail Sale Id 1638372',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:27:00','',''),(2646518,'1','186','940',419,'Retail Sale Id 1638373',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 14:28:24','',''),(2646519,'1','186','940',419,'Retail Sale Id 1638374',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 14:29:38','',''),(2646520,'1','186','940',419,'Retail Sale Id 1638375',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 14:33:15','',''),(2646521,'1','186','940',419,'Retail Sale Id 1638376',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 14:34:55','',''),(2646522,'1','186','940',419,'Retail Sale Id 1638377',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:36:19','',''),(2646523,'1','186','940',419,'Retail Sale Id 1638378',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:38:14','',''),(2646524,'1','186','940',419,'Retail Sale Id 1638379',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:39:37','',''),(2646525,'1','186','940',419,'Retail Sale Id 1638380',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 14:41:15','',''),(2646526,'1','186','940',419,'Retail Sale Id 1638381',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 14:42:30','',''),(2646527,'1','186','940',419,'Retail Sale Id 1638382',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 14:44:26','',''),(2646528,'1','186','940',419,'Retail Sale Id 1638383',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 14:46:12','',''),(2646529,'1','186','940',419,'Retail Sale Id 1638384',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 14:46:59','',''),(2646530,'1','186','940',419,'Retail Sale Id 1638385',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 14:48:24','',''),(2646531,'1','186','940',419,'Retail Sale Id 1638386',34650.00,0.00,0.00,55.00,1265.00,'2022-05-19 14:49:20','',''),(2646532,'1','186','940',419,'Retail Sale Id 1638387',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 14:51:08','',''),(2646533,'1','186','940',419,'Retail Sale Id 1638388',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 14:52:16','',''),(2646534,'1','186','940',419,'Retail Sale Id 1638389',999.60,0.00,0.00,1.47,107.31,'2022-05-19 14:53:29','',''),(2646535,'1','186','940',419,'Retail Sale Id 1638390',8160.00,0.00,0.00,12.00,876.00,'2022-05-19 14:56:11','',''),(2646536,'1','186','940',419,'Retail Sale Id 1638392',2203.20,0.00,0.00,3.24,236.52,'2022-05-19 15:03:18','',''),(2646537,'1','186','940',419,'Retail Sale Id 1638393',4297.60,0.00,0.00,6.32,461.36,'2022-05-19 15:04:01','',''),(2646538,'1','186','940',419,'Retail Sale Id 1638394',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 15:05:30','',''),(2646539,'1','186','940',419,'Retail Sale Id 1638395',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 15:06:33','',''),(2646540,'1','186','940',419,'Retail Sale Id 1638396',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 15:07:39','',''),(2646541,'1','186','940',419,'Retail Sale Id 1638397',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 15:08:43','',''),(2646542,'1','186','940',419,'Retail Sale Id 1638398',680.00,0.00,0.00,1.00,73.00,'2022-05-19 15:10:57','',''),(2646543,'1','186','940',419,'Retail Sale Id 1638398',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 15:10:57','',''),(2646544,'1','186','940',419,'Retail Sale Id 1638399',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 15:12:05','',''),(2646545,'1','186','940',419,'Retail Sale Id 1638400',3998.40,0.00,0.00,5.88,429.24,'2022-05-19 15:12:59','',''),(2646546,'1','186','940',419,'Retail Sale Id 1638401',2502.40,0.00,0.00,3.68,268.64,'2022-05-19 15:14:04','',''),(2646547,'1','186','940',419,'Retail Sale Id 1638402',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 15:15:58','',''),(2646548,'1','186','940',419,'Retail Sale Id 1638403',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 15:17:37','',''),(2646549,'1','186','940',419,'Retail Sale Id 1638404',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 15:18:34','',''),(2646550,'1','186','940',419,'Retail Sale Id 1638405',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 15:19:30','',''),(2646551,'1','186','940',419,'Retail Sale Id 1638406',999.60,0.00,0.00,1.47,107.31,'2022-05-19 15:20:46','',''),(2646552,'1','186','940',419,'Retail Sale Id 1638406',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 15:20:46','',''),(2646553,'1','186','940',419,'Retail Sale Id 1638407',999.60,0.00,0.00,1.47,107.31,'2022-05-19 15:21:39','',''),(2646554,'1','186','940',419,'Retail Sale Id 1638408',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 15:22:52','',''),(2646555,'1','186','940',419,'Retail Sale Id 1638409',999.60,0.00,0.00,1.47,107.31,'2022-05-19 15:23:53','',''),(2646556,'1','186','940',419,'Retail Sale Id 1638410',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 15:24:52','',''),(2646557,'1','186','940',419,'Retail Sale Id 1638410',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 15:24:52','',''),(2646558,'1','186','940',419,'Retail Sale Id 1638411',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 15:26:00','',''),(2646559,'1','186','940',419,'Retail Sale Id 1638413',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 15:27:55','',''),(2646560,'1','186','940',419,'Retail Sale Id 1638413',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:27:55','',''),(2646561,'1','186','940',419,'Retail Sale Id 1638414',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:28:46','',''),(2646562,'1','186','940',419,'Retail Sale Id 1638415',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 15:29:42','',''),(2646563,'1','186','940',419,'Retail Sale Id 1638416',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 15:30:49','',''),(2646564,'1','186','940',419,'Retail Sale Id 1638417',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 15:31:35','',''),(2646565,'1','186','940',419,'Retail Sale Id 1638418',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 15:34:38','',''),(2646566,'1','186','940',419,'Retail Sale Id 1638419',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:35:53','',''),(2646567,'1','186','940',419,'Retail Sale Id 1638420',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 15:37:01','',''),(2646568,'1','186','940',419,'Retail Sale Id 1638421',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:38:16','',''),(2646569,'1','186','940',419,'Retail Sale Id 1638421',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 15:38:16','',''),(2646570,'1','186','940',419,'Retail Sale Id 1638422',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:40:36','',''),(2646571,'1','186','940',419,'Retail Sale Id 1638423',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:44:11','',''),(2646572,'1','186','940',419,'Retail Sale Id 1638424',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 15:46:32','',''),(2646573,'1','186','940',419,'Retail Sale Id 1638425',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 15:48:15','',''),(2646574,'1','186','940',419,'Retail Sale Id 1638426',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 15:50:14','',''),(2646575,'1','186','940',419,'Retail Sale Id 1638427',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 15:52:09','',''),(2646576,'1','186','940',419,'Retail Sale Id 1638428',999.60,0.00,0.00,1.47,107.31,'2022-05-19 15:53:20','',''),(2646577,'1','186','940',419,'Retail Sale Id 1638429',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 15:58:19','',''),(2646578,'1','186','940',419,'Retail Sale Id 1638430',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 16:00:46','',''),(2646579,'1','186','940',419,'Retail Sale Id 1638431',1298.80,0.00,0.00,1.91,139.43,'2022-05-19 16:01:36','',''),(2646580,'1','186','940',419,'Retail Sale Id 1638432',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 16:03:11','',''),(2646581,'1','186','940',419,'Retail Sale Id 1638433',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:04:21','',''),(2646582,'1','186','940',419,'Retail Sale Id 1638434',16320.00,0.00,0.00,24.00,1752.00,'2022-05-19 16:05:57','',''),(2646583,'1','186','940',419,'Retail Sale Id 1638436',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 16:08:09','',''),(2646584,'1','186','940',419,'Retail Sale Id 1638437',15750.00,0.00,0.00,25.00,575.00,'2022-05-19 16:09:53','',''),(2646585,'1','186','940',419,'Retail Sale Id 1638438',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:10:51','',''),(2646586,'1','186','940',419,'Retail Sale Id 1638439',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:11:51','',''),(2646587,'1','186','940',419,'Retail Sale Id 1638440',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:12:51','',''),(2646588,'1','186','940',419,'Retail Sale Id 1638441',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:13:45','',''),(2646589,'1','186','940',419,'Retail Sale Id 1638442',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 16:14:32','',''),(2646590,'1','186','940',419,'Retail Sale Id 1638443',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 16:15:33','',''),(2646591,'1','186','940',419,'Retail Sale Id 1638444',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 16:16:53','',''),(2646592,'1','186','940',419,'Retail Sale Id 1638445',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 16:17:53','',''),(2646593,'1','186','940',419,'Retail Sale Id 1638446',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 16:18:56','',''),(2646594,'1','186','940',419,'Retail Sale Id 1638447',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:19:48','',''),(2646595,'1','186','940',419,'Retail Sale Id 1638448',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 16:26:31','',''),(2646596,'1','186','940',419,'Retail Sale Id 1638449',999.60,0.00,0.00,1.47,107.31,'2022-05-19 16:27:21','',''),(2646597,'1','186','940',419,'Retail Sale Id 1638450',3998.40,0.00,0.00,5.88,429.24,'2022-05-19 16:28:59','',''),(2646598,'1','186','940',419,'Retail Sale Id 1638451',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 16:30:10','',''),(2646599,'1','186','940',419,'Retail Sale Id 1638452',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:30:57','',''),(2646600,'1','186','940',419,'Retail Sale Id 1638453',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 16:31:55','',''),(2646601,'1','186','940',419,'Retail Sale Id 1638454',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 16:32:36','',''),(2646602,'1','186','940',419,'Retail Sale Id 1638455',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 16:33:32','',''),(2646603,'1','186','940',419,'Retail Sale Id 1638456',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:34:08','',''),(2646604,'1','186','940',419,'Retail Sale Id 1638457',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:34:46','',''),(2646605,'1','186','940',419,'Retail Sale Id 1638458',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:36:30','',''),(2646606,'1','186','940',419,'Retail Sale Id 1638459',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:37:10','',''),(2646607,'1','186','940',419,'Retail Sale Id 1638460',34650.00,0.00,0.00,55.00,1265.00,'2022-05-19 16:38:41','',''),(2646608,'1','186','940',419,'Retail Sale Id 1638462',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 16:40:04','',''),(2646609,'1','186','940',419,'Retail Sale Id 1638463',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 16:41:33','',''),(2646610,'1','186','940',419,'Retail Sale Id 1638464',10540.00,0.00,0.00,15.50,1131.50,'2022-05-19 16:42:37','',''),(2646611,'1','186','940',419,'Retail Sale Id 1638465',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 16:45:38','',''),(2646612,'1','186','940',419,'Retail Sale Id 1638466',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:46:48','',''),(2646613,'1','186','940',419,'Retail Sale Id 1638467',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 16:47:59','',''),(2646614,'1','186','940',419,'Retail Sale Id 1638468',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 16:49:01','',''),(2646615,'1','186','940',419,'Retail Sale Id 1638469',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:49:48','',''),(2646616,'1','186','940',419,'Retail Sale Id 1638470',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 16:50:22','',''),(2646617,'1','186','940',419,'Retail Sale Id 1638471',3801.20,0.00,0.00,5.59,408.07,'2022-05-19 16:51:19','',''),(2646618,'1','186','940',419,'Retail Sale Id 1638473',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 16:52:19','',''),(2646619,'1','186','940',419,'Retail Sale Id 1638474',3719.60,0.00,0.00,5.47,399.31,'2022-05-19 16:53:09','',''),(2646620,'1','186','940',419,'Retail Sale Id 1638475',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 16:53:41','',''),(2646621,'1','186','940',419,'Retail Sale Id 1638476',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:54:22','',''),(2646622,'1','186','940',419,'Retail Sale Id 1638477',2502.40,0.00,0.00,3.68,268.64,'2022-05-19 16:54:58','',''),(2646623,'1','186','940',419,'Retail Sale Id 1638479',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:55:47','',''),(2646624,'1','186','940',419,'Retail Sale Id 1638480',17000.00,0.00,0.00,25.00,1825.00,'2022-05-19 16:56:52','',''),(2646625,'1','186','940',419,'Retail Sale Id 1638481',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 16:57:44','',''),(2646626,'1','186','940',419,'Retail Sale Id 1638482',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 16:58:22','',''),(2646627,'1','186','940',419,'Retail Sale Id 1638483',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 16:59:21','',''),(2646628,'1','186','940',419,'Retail Sale Id 1638484',7799.60,0.00,0.00,11.47,837.31,'2022-05-19 17:00:18','',''),(2646629,'1','186','940',419,'Retail Sale Id 1638485',7996.80,0.00,0.00,11.76,858.48,'2022-05-19 17:01:07','',''),(2646630,'1','186','940',419,'Retail Sale Id 1638486',8840.00,0.00,0.00,13.00,949.00,'2022-05-19 17:01:57','',''),(2646631,'1','186','940',419,'Retail Sale Id 1638487',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:02:41','',''),(2646632,'1','186','940',419,'Retail Sale Id 1638488',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 17:03:27','',''),(2646633,'1','186','940',419,'Retail Sale Id 1638489',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:04:06','',''),(2646634,'1','186','940',419,'Retail Sale Id 1638490',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:04:45','',''),(2646635,'1','186','940',419,'Retail Sale Id 1638491',3699.20,0.00,0.00,5.44,397.12,'2022-05-19 17:05:18','',''),(2646636,'1','186','940',419,'Retail Sale Id 1638492',999.60,0.00,0.00,1.47,107.31,'2022-05-19 17:05:55','',''),(2646637,'1','186','940',419,'Retail Sale Id 1638493',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 17:06:38','',''),(2646638,'1','186','940',419,'Retail Sale Id 1638494',3998.40,0.00,0.00,5.88,429.24,'2022-05-19 17:07:09','',''),(2646639,'1','186','940',419,'Retail Sale Id 1638495',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:07:56','',''),(2646640,'1','186','940',419,'Retail Sale Id 1638496',3998.40,0.00,0.00,5.88,429.24,'2022-05-19 17:08:34','',''),(2646641,'1','186','940',419,'Retail Sale Id 1638497',6120.00,0.00,0.00,9.00,657.00,'2022-05-19 17:09:09','',''),(2646642,'1','186','940',419,'Retail Sale Id 1638498',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:10:17','',''),(2646643,'1','186','940',419,'Retail Sale Id 1638499',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:11:21','',''),(2646644,'1','186','940',419,'Retail Sale Id 1638500',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 17:13:25','',''),(2646645,'1','186','940',419,'Retail Sale Id 1638501',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:14:11','',''),(2646646,'1','186','940',419,'Retail Sale Id 1638502',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 17:15:25','',''),(2646647,'1','186','940',419,'Retail Sale Id 1638503',5997.60,0.00,0.00,8.82,643.86,'2022-05-19 17:16:44','',''),(2646648,'1','186','940',419,'Retail Sale Id 1638504',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:17:44','',''),(2646649,'1','186','940',419,'Retail Sale Id 1638505',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 17:19:49','',''),(2646650,'1','186','940',419,'Retail Sale Id 1638506',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 17:20:30','',''),(2646651,'1','186','940',419,'Retail Sale Id 1638507',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:21:16','',''),(2646652,'1','186','940',419,'Retail Sale Id 1638508',2998.80,0.00,0.00,4.41,321.93,'2022-05-19 17:21:56','',''),(2646653,'1','186','940',419,'Retail Sale Id 1638509',16320.00,0.00,0.00,24.00,1752.00,'2022-05-19 17:24:02','',''),(2646654,'1','186','940',419,'Retail Sale Id 1638521',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 17:26:01','',''),(2646655,'1','186','940',419,'Retail Sale Id 1638522',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 17:28:40','',''),(2646656,'1','186','940',419,'Retail Sale Id 1638523',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:30:58','',''),(2646657,'1','186','940',419,'Retail Sale Id 1638525',1400.80,0.00,0.00,2.06,150.38,'2022-05-19 17:32:15','',''),(2646658,'1','186','940',419,'Retail Sale Id 1638526',1999.20,0.00,0.00,2.94,214.62,'2022-05-19 17:33:16','',''),(2646659,'1','186','940',419,'Retail Sale Id 1638527',7480.00,0.00,0.00,11.00,803.00,'2022-05-19 17:33:56','',''),(2646660,'1','186','940',419,'Retail Sale Id 1638528',17010.00,0.00,0.00,27.00,621.00,'2022-05-19 17:34:33','',''),(2646661,'1','186','940',419,'Retail Sale Id 1638529',7480.00,0.00,0.00,11.00,803.00,'2022-05-19 17:35:09','',''),(2646662,'1','186','940',419,'Retail Sale Id 1638530',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:35:49','',''),(2646663,'1','186','940',419,'Retail Sale Id 1638531',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 17:37:47','',''),(2646664,'1','186','940',419,'Retail Sale Id 1638532',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:39:18','',''),(2646665,'1','186','940',419,'Retail Sale Id 1638533',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:39:53','',''),(2646666,'1','186','940',419,'Retail Sale Id 1638534',9520.00,0.00,0.00,14.00,1022.00,'2022-05-19 17:40:30','',''),(2646667,'1','186','940',419,'Retail Sale Id 1638535',7480.00,0.00,0.00,11.00,803.00,'2022-05-19 17:41:09','',''),(2646668,'1','186','940',419,'Retail Sale Id 1638536',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 17:42:57','',''),(2646669,'1','186','940',419,'Retail Sale Id 1638537',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 17:44:08','',''),(2646670,'1','186','940',419,'Retail Sale Id 1638538',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 17:44:46','',''),(2646671,'1','186','940',419,'Retail Sale Id 1638539',999.60,0.00,0.00,1.47,107.31,'2022-05-19 17:45:42','',''),(2646672,'1','186','940',419,'Retail Sale Id 1638540',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:46:16','',''),(2646673,'1','186','940',419,'Retail Sale Id 1638541',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 17:47:08','',''),(2646674,'1','186','940',419,'Retail Sale Id 1638542',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 17:48:07','',''),(2646675,'1','186','940',419,'Retail Sale Id 1638543',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:49:52','',''),(2646676,'1','186','940',419,'Retail Sale Id 1638544',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 17:50:51','',''),(2646677,'1','186','940',419,'Retail Sale Id 1638545',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 17:52:09','',''),(2646678,'1','186','940',419,'Retail Sale Id 1638546',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 17:53:17','',''),(2646679,'1','186','940',419,'Retail Sale Id 1638547',6800.00,0.00,0.00,10.00,730.00,'2022-05-19 17:54:00','',''),(2646680,'1','186','940',419,'Retail Sale Id 1638548',1502.80,0.00,0.00,2.21,161.33,'2022-05-19 17:54:52','',''),(2646681,'1','186','940',419,'Retail Sale Id 1638549',1700.00,0.00,0.00,2.50,182.50,'2022-05-19 17:55:40','',''),(2646682,'1','186','940',419,'Retail Sale Id 1638550',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 17:56:17','',''),(2646683,'1','186','940',419,'Retail Sale Id 1638551',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 17:56:59','',''),(2646684,'1','186','940',419,'Retail Sale Id 1638552',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 17:57:59','',''),(2646685,'1','186','940',419,'Retail Sale Id 1638553',1251.20,0.00,0.00,1.84,134.32,'2022-05-19 17:59:52','',''),(2646686,'1','186','940',419,'Retail Sale Id 1638554',2720.00,0.00,0.00,4.00,292.00,'2022-05-19 18:01:23','',''),(2646687,'1','186','940',419,'Retail Sale Id 1638555',4760.00,0.00,0.00,7.00,511.00,'2022-05-19 18:02:14','',''),(2646688,'1','186','940',419,'Retail Sale Id 1638563',2040.00,0.00,0.00,3.00,219.00,'2022-05-19 18:03:19','',''),(2646689,'1','186','940',419,'Retail Sale Id 1638564',63000.00,0.00,0.00,100.00,2300.00,'2022-05-19 18:04:30','',''),(2646690,'1','186','940',419,'Retail Sale Id 1638565',6861.20,0.00,0.00,10.09,736.57,'2022-05-19 18:09:44','',''),(2646691,'1','186','940',419,'Retail Sale Id 1638567',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 18:10:32','',''),(2646692,'1','186','940',419,'Retail Sale Id 1638568',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 18:13:46','',''),(2646693,'1','186','940',419,'Retail Sale Id 1638569',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 18:15:02','',''),(2646694,'1','186','940',419,'Retail Sale Id 1638582',4080.00,0.00,0.00,6.00,438.00,'2022-05-19 18:16:03','',''),(2646695,'1','186','940',419,'Retail Sale Id 1638584',999.60,0.00,0.00,1.47,107.31,'2022-05-19 18:17:20','',''),(2646696,'1','186','940',419,'Retail Sale Id 1638585',25200.00,0.00,0.00,40.00,920.00,'2022-05-19 18:19:08','',''),(2646697,'1','186','940',419,'Retail Sale Id 1638586',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 18:20:16','',''),(2646698,'1','186','940',419,'Retail Sale Id 1638587',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 18:20:58','',''),(2646699,'1','186','940',419,'Retail Sale Id 1638588',8500.00,0.00,0.00,12.50,912.50,'2022-05-19 18:21:54','',''),(2646700,'1','186','940',419,'Retail Sale Id 1638589',3400.00,0.00,0.00,5.00,365.00,'2022-05-19 18:23:27','',''),(2646701,'1','186','940',419,'Retail Sale Id 1638590',1360.00,0.00,0.00,2.00,146.00,'2022-05-19 18:25:21','',''),(2646702,'1','186','940',419,'Retail Sale Id 1638593',999.60,0.00,0.00,1.47,107.31,'2022-05-19 18:26:33','',''),(2646703,'1','186','940',419,'Retail Sale Id 1638594',31500.00,0.00,0.00,50.00,1150.00,'2022-05-19 18:30:00','',''),(2646704,'1','186','940',419,'Return of Retail Sale Id 1638509',0.00,16320.00,24.00,0.00,-1752.00,'2022-05-19 20:02:57','',''),(2646705,'1','186','940',419,'Retail Sale Id 1638595',5650.80,0.00,0.00,8.31,606.63,'2022-05-19 20:03:42','',''),(2646706,'1','186','940',419,'Return of Retail Sale Id 1638595',0.00,5650.80,8.31,0.00,-606.63,'2022-05-19 20:07:16','',''),(2646707,'1','186','940',419,'Return of Retail Sale Id 1638593',0.00,999.60,1.47,0.00,-107.31,'2022-05-19 20:08:13','',''),(2646708,'1','186','940',419,'Retail Sale Id 1638596',1203.60,0.00,0.00,1.77,129.21,'2022-05-19 20:51:06','',''),(2646709,'1','186','940',419,'Retail Sale Id 1638597',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 07:12:36','',''),(2646710,'1','186','940',419,'Retail Sale Id 1638598',7500.40,0.00,0.00,11.03,805.19,'2022-05-20 07:13:56','',''),(2646711,'1','186','940',419,'Retail Sale Id 1638599',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 07:18:27','',''),(2646712,'1','186','940',419,'Retail Sale Id 1638600',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 07:19:08','',''),(2646713,'1','186','940',419,'Retail Sale Id 1638601',999.60,0.00,0.00,1.47,107.31,'2022-05-20 07:19:49','',''),(2646714,'1','186','940',419,'Retail Sale Id 1638602',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 07:21:19','',''),(2646715,'1','186','940',419,'Retail Sale Id 1638603',7996.80,0.00,0.00,11.76,858.48,'2022-05-20 07:22:45','',''),(2646716,'1','186','940',419,'Retail Sale Id 1638605',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 07:25:40','',''),(2646717,'1','186','940',419,'Retail Sale Id 1638606',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 07:27:18','',''),(2646718,'1','186','940',419,'Retail Sale Id 1638607',999.60,0.00,0.00,1.47,107.31,'2022-05-20 07:28:02','',''),(2646719,'1','186','940',419,'Retail Sale Id 1638608',2699.60,0.00,0.00,3.97,289.81,'2022-05-20 07:29:10','',''),(2646720,'1','186','940',419,'Retail Sale Id 1638609',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 07:29:57','',''),(2646721,'1','186','940',419,'Retail Sale Id 1638610',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 07:30:50','',''),(2646722,'1','186','940',419,'Retail Sale Id 1638611',999.60,0.00,0.00,1.47,107.31,'2022-05-20 07:31:46','',''),(2646723,'1','186','940',419,'Retail Sale Id 1638612',2502.40,0.00,0.00,3.68,268.64,'2022-05-20 07:32:36','',''),(2646724,'1','186','940',419,'Retail Sale Id 1638613',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 07:33:51','',''),(2646725,'1','186','940',419,'Retail Sale Id 1638614',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 07:37:11','',''),(2646726,'1','186','940',419,'Retail Sale Id 1638615',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 07:39:11','',''),(2646727,'1','186','940',419,'Retail Sale Id 1638616',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 07:40:12','',''),(2646728,'1','186','940',419,'Retail Sale Id 1638617',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 07:42:22','',''),(2646729,'1','186','940',419,'Retail Sale Id 1638618',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 07:43:11','',''),(2646730,'1','186','940',419,'Retail Sale Id 1638619',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 07:45:55','',''),(2646731,'1','186','940',419,'Retail Sale Id 1638620',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 07:47:08','',''),(2646732,'1','186','940',419,'Retail Sale Id 1638621',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 07:48:34','',''),(2646733,'1','186','940',419,'Retail Sale Id 1638622',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 07:50:34','',''),(2646734,'1','186','940',419,'Retail Sale Id 1638622',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 07:50:34','',''),(2646735,'1','186','940',419,'Retail Sale Id 1638623',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 07:52:10','',''),(2646736,'1','186','940',419,'Retail Sale Id 1638624',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 07:53:07','',''),(2646737,'1','186','940',419,'Retail Sale Id 1638625',999.60,0.00,0.00,1.47,107.31,'2022-05-20 07:53:52','',''),(2646738,'1','186','940',419,'Retail Sale Id 1638626',999.60,0.00,0.00,1.47,107.31,'2022-05-20 07:54:39','',''),(2646739,'1','186','940',419,'Retail Sale Id 1638627',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 07:56:06','',''),(2646740,'1','186','940',419,'Retail Sale Id 1638628',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 07:56:57','',''),(2646741,'1','186','940',419,'Retail Sale Id 1638629',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 07:58:14','',''),(2646742,'1','186','940',419,'Retail Sale Id 1638630',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 07:59:29','',''),(2646743,'1','186','940',419,'Retail Sale Id 1638631',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 08:01:04','',''),(2646744,'1','186','940',419,'Retail Sale Id 1638632',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 08:02:07','',''),(2646745,'1','186','940',419,'Retail Sale Id 1638633',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 08:03:35','',''),(2646746,'1','186','940',419,'Retail Sale Id 1638633',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 08:03:35','',''),(2646747,'1','186','940',419,'Retail Sale Id 1638633',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 08:03:35','',''),(2646748,'1','186','940',419,'Retail Sale Id 1638634',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 08:05:13','',''),(2646749,'1','186','940',419,'Retail Sale Id 1638635',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 08:07:14','',''),(2646750,'1','186','940',419,'Retail Sale Id 1638636',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 08:08:46','',''),(2646751,'1','186','940',419,'Retail Sale Id 1638637',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 08:10:07','',''),(2646752,'1','186','940',419,'Retail Sale Id 1638638',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 08:11:14','',''),(2646753,'1','186','940',419,'Retail Sale Id 1638639',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 08:23:51','',''),(2646754,'1','186','940',419,'Retail Sale Id 1638640',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 08:27:02','',''),(2646755,'1','186','940',419,'Retail Sale Id 1638641',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 08:27:54','',''),(2646756,'1','186','940',419,'Retail Sale Id 1638642',1196.80,0.00,0.00,1.76,128.48,'2022-05-20 08:28:53','',''),(2646757,'1','186','940',419,'Retail Sale Id 1638643',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 08:29:48','',''),(2646758,'1','186','940',419,'Retail Sale Id 1638644',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 08:31:29','',''),(2646759,'1','186','940',419,'Retail Sale Id 1638645',999.60,0.00,0.00,1.47,107.31,'2022-05-20 08:33:55','',''),(2646760,'1','186','940',419,'Retail Sale Id 1638646',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 08:38:22','',''),(2646761,'1','186','940',419,'Retail Sale Id 1638647',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 08:39:23','',''),(2646762,'1','186','940',419,'Retail Sale Id 1638648',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 08:40:32','',''),(2646763,'1','186','940',419,'Retail Sale Id 1638649',5440.00,0.00,0.00,8.00,584.00,'2022-05-20 08:42:08','',''),(2646764,'1','186','940',419,'Retail Sale Id 1638650',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 08:43:24','',''),(2646765,'1','186','940',419,'Retail Sale Id 1638651',999.60,0.00,0.00,1.47,107.31,'2022-05-20 08:48:20','',''),(2646766,'1','186','940',419,'Retail Sale Id 1638652',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 08:49:57','',''),(2646767,'1','186','940',419,'Retail Sale Id 1638653',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 08:54:13','',''),(2646768,'1','186','940',419,'Retail Sale Id 1638654',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 08:55:26','',''),(2646769,'1','186','940',419,'Retail Sale Id 1638655',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 08:57:02','',''),(2646770,'1','186','940',419,'Retail Sale Id 1638655',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 08:57:02','',''),(2646771,'1','186','940',419,'Retail Sale Id 1638656',4998.00,0.00,0.00,7.35,536.55,'2022-05-20 08:58:02','',''),(2646772,'1','186','940',419,'Retail Sale Id 1638657',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 08:59:04','',''),(2646773,'1','186','940',419,'Retail Sale Id 1638658',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 09:00:16','',''),(2646774,'1','186','940',419,'Retail Sale Id 1638659',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 09:01:12','',''),(2646775,'1','186','940',419,'Retail Sale Id 1638660',999.60,0.00,0.00,1.47,107.31,'2022-05-20 09:02:04','',''),(2646776,'1','186','940',419,'Retail Sale Id 1638661',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 09:03:21','',''),(2646777,'1','186','940',419,'Retail Sale Id 1638662',15750.00,0.00,0.00,25.00,575.00,'2022-05-20 09:06:01','',''),(2646778,'1','186','940',419,'Retail Sale Id 1638663',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 09:11:06','',''),(2646779,'1','186','940',419,'Retail Sale Id 1638664',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 09:12:33','',''),(2646780,'1','186','940',419,'Retail Sale Id 1638665',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 09:14:52','',''),(2646781,'1','186','940',419,'Retail Sale Id 1638666',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 09:16:06','',''),(2646782,'1','186','940',419,'Retail Sale Id 1638667',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 09:20:21','',''),(2646783,'1','186','940',419,'Retail Sale Id 1638668',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 09:21:52','',''),(2646784,'1','186','940',419,'Retail Sale Id 1638669',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 09:22:57','',''),(2646785,'1','186','940',419,'Retail Sale Id 1638670',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 09:23:47','',''),(2646786,'1','186','940',419,'Retail Sale Id 1638671',6120.00,0.00,0.00,9.00,657.00,'2022-05-20 09:26:39','',''),(2646787,'1','186','940',419,'Retail Sale Id 1638672',5997.60,0.00,0.00,8.82,643.86,'2022-05-20 09:28:47','',''),(2646788,'1','186','940',419,'Retail Sale Id 1638673',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 09:30:03','',''),(2646789,'1','186','940',419,'Retail Sale Id 1638674',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 09:31:41','',''),(2646790,'1','186','940',419,'Retail Sale Id 1638675',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 09:37:15','',''),(2646791,'1','186','940',419,'Retail Sale Id 1638676',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 09:39:24','',''),(2646792,'1','186','940',419,'Retail Sale Id 1638677',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 09:45:45','',''),(2646793,'1','186','940',419,'Retail Sale Id 1638678',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 09:47:26','',''),(2646794,'1','186','940',419,'Retail Sale Id 1638679',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 09:49:01','',''),(2646795,'1','186','940',419,'Retail Sale Id 1638680',680.00,0.00,0.00,1.00,73.00,'2022-05-20 09:53:21','',''),(2646796,'1','186','940',419,'Retail Sale Id 1638681',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 09:57:00','',''),(2646797,'1','186','940',419,'Retail Sale Id 1638682',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 10:03:02','',''),(2646798,'1','186','940',419,'Retail Sale Id 1638683',3502.00,0.00,0.00,5.15,375.95,'2022-05-20 10:03:56','',''),(2646799,'1','186','940',419,'Retail Sale Id 1638684',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 10:05:14','',''),(2646800,'1','186','940',419,'Retail Sale Id 1638685',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 10:08:01','',''),(2646801,'1','186','940',419,'Retail Sale Id 1638686',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 10:10:21','',''),(2646802,'1','186','940',419,'Retail Sale Id 1638687',2101.20,0.00,0.00,3.09,225.57,'2022-05-20 10:11:29','',''),(2646803,'1','186','940',419,'Retail Sale Id 1638688',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 10:12:36','',''),(2646804,'1','186','940',419,'Retail Sale Id 1638689',999.60,0.00,0.00,1.47,107.31,'2022-05-20 10:13:29','',''),(2646805,'1','186','940',419,'Retail Sale Id 1638693',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 10:14:59','',''),(2646806,'1','186','940',419,'Retail Sale Id 1638693',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 10:14:59','',''),(2646807,'1','186','940',419,'Retail Sale Id 1638694',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 10:15:57','',''),(2646808,'1','186','940',419,'Retail Sale Id 1638695',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 10:16:46','',''),(2646809,'1','186','940',419,'Retail Sale Id 1638696',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 10:17:53','',''),(2646810,'1','186','940',419,'Retail Sale Id 1638697',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 10:20:00','',''),(2646811,'1','186','940',419,'Retail Sale Id 1638698',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 10:25:33','',''),(2646812,'1','186','940',419,'Retail Sale Id 1638699',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 10:32:28','',''),(2646813,'1','186','940',419,'Retail Sale Id 1638700',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 10:34:30','',''),(2646814,'1','186','940',419,'Retail Sale Id 1638701',4800.80,0.00,0.00,7.06,515.38,'2022-05-20 10:37:17','',''),(2646815,'1','186','940',419,'Retail Sale Id 1638702',4100.40,0.00,0.00,6.03,440.19,'2022-05-20 10:39:16','',''),(2646816,'1','186','940',419,'Retail Sale Id 1638703',2046.80,0.00,0.00,3.01,219.73,'2022-05-20 10:40:48','',''),(2646817,'1','186','940',419,'Retail Sale Id 1638704',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 10:42:40','',''),(2646818,'1','186','940',419,'Retail Sale Id 1638705',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 10:43:41','',''),(2646819,'1','186','940',419,'Retail Sale Id 1638706',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 10:46:23','',''),(2646820,'1','186','940',419,'Retail Sale Id 1638707',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 10:48:37','',''),(2646821,'1','186','940',419,'Retail Sale Id 1638708',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 10:49:41','',''),(2646822,'1','186','940',419,'Retail Sale Id 1638709',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 10:51:01','',''),(2646823,'1','186','940',419,'Retail Sale Id 1638710',999.60,0.00,0.00,1.47,107.31,'2022-05-20 10:52:09','',''),(2646824,'1','186','940',419,'Retail Sale Id 1638711',4760.00,0.00,0.00,7.00,511.00,'2022-05-20 10:53:58','',''),(2646825,'1','186','940',419,'Retail Sale Id 1638712',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 10:58:20','',''),(2646826,'1','186','940',419,'Retail Sale Id 1638713',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 11:02:33','',''),(2646827,'1','186','940',419,'Retail Sale Id 1638714',5440.00,0.00,0.00,8.00,584.00,'2022-05-20 11:04:32','',''),(2646828,'1','186','940',419,'Retail Sale Id 1638715',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 11:06:45','',''),(2646829,'1','186','940',419,'Retail Sale Id 1638716',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 11:08:30','',''),(2646830,'1','186','940',419,'Retail Sale Id 1638717',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 11:09:35','',''),(2646831,'1','186','940',419,'Retail Sale Id 1638719',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 11:12:00','',''),(2646832,'1','186','940',419,'Retail Sale Id 1638720',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 11:13:23','',''),(2646833,'1','186','940',419,'Retail Sale Id 1638721',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 11:14:47','',''),(2646834,'1','186','940',419,'Retail Sale Id 1638722',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 11:15:33','',''),(2646835,'1','186','940',419,'Retail Sale Id 1638723',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 11:16:39','',''),(2646836,'1','186','940',419,'Retail Sale Id 1638724',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 11:18:05','',''),(2646837,'1','186','940',419,'Retail Sale Id 1638725',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 11:19:49','',''),(2646838,'1','186','940',419,'Retail Sale Id 1638726',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 11:21:07','',''),(2646839,'1','186','940',419,'Retail Sale Id 1638727',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 11:22:56','',''),(2646840,'1','186','940',419,'Retail Sale Id 1638728',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 11:24:01','',''),(2646841,'1','186','940',419,'Retail Sale Id 1638729',37800.00,0.00,0.00,60.00,1380.00,'2022-05-20 11:25:45','',''),(2646842,'1','186','940',419,'Retail Sale Id 1638730',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 11:28:05','',''),(2646843,'1','186','940',419,'Retail Sale Id 1638730',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 11:28:05','',''),(2646844,'1','186','940',419,'Retail Sale Id 1638730',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 11:28:05','',''),(2646845,'1','186','940',419,'Retail Sale Id 1638731',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 11:29:49','',''),(2646846,'1','186','940',419,'Retail Sale Id 1638732',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 11:30:55','',''),(2646847,'1','186','940',419,'Retail Sale Id 1638733',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 11:31:50','',''),(2646848,'1','186','940',419,'Retail Sale Id 1638734',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 11:32:50','',''),(2646849,'1','186','940',419,'Retail Sale Id 1638735',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 11:42:15','',''),(2646850,'1','186','940',419,'Retail Sale Id 1638736',9520.00,0.00,0.00,14.00,1022.00,'2022-05-20 11:44:52','',''),(2646851,'1','186','940',419,'Retail Sale Id 1638737',1298.80,0.00,0.00,1.91,139.43,'2022-05-20 11:46:16','',''),(2646852,'1','186','940',419,'Retail Sale Id 1638738',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 11:46:56','',''),(2646853,'1','186','940',419,'Retail Sale Id 1638740',2101.20,0.00,0.00,3.09,225.57,'2022-05-20 11:48:25','',''),(2646854,'1','186','940',419,'Retail Sale Id 1638741',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 11:49:26','',''),(2646855,'1','186','940',419,'Retail Sale Id 1638742',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 11:53:41','',''),(2646856,'1','186','940',419,'Retail Sale Id 1638743',3740.00,0.00,0.00,5.50,401.50,'2022-05-20 11:56:19','',''),(2646857,'1','186','940',419,'Retail Sale Id 1638744',6120.00,0.00,0.00,9.00,657.00,'2022-05-20 11:58:38','',''),(2646858,'1','186','940',419,'Retail Sale Id 1638745',37800.00,0.00,0.00,60.00,1380.00,'2022-05-20 12:00:58','',''),(2646859,'1','186','940',419,'Retail Sale Id 1638746',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:02:49','',''),(2646860,'1','186','940',419,'Retail Sale Id 1638747',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:06:31','',''),(2646861,'1','186','940',419,'Retail Sale Id 1638748',5997.60,0.00,0.00,8.82,643.86,'2022-05-20 12:07:58','',''),(2646862,'1','186','940',419,'Retail Sale Id 1638749',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:09:05','',''),(2646863,'1','186','940',419,'Retail Sale Id 1638750',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:10:16','',''),(2646864,'1','186','940',419,'Retail Sale Id 1638750',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 12:10:16','',''),(2646865,'1','186','940',419,'Retail Sale Id 1638751',4100.40,0.00,0.00,6.03,440.19,'2022-05-20 12:12:23','',''),(2646866,'1','186','940',419,'Retail Sale Id 1638752',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 12:13:49','',''),(2646867,'1','186','940',419,'Retail Sale Id 1638753',51660.00,0.00,0.00,82.00,1886.00,'2022-05-20 12:27:21','',''),(2646868,'1','186','940',419,'Retail Sale Id 1638754',4100.40,0.00,0.00,6.03,440.19,'2022-05-20 12:33:34','',''),(2646869,'1','186','940',419,'Retail Sale Id 1638755',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 12:34:46','',''),(2646870,'1','186','940',419,'Retail Sale Id 1638756',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 12:40:04','',''),(2646871,'1','186','940',419,'Retail Sale Id 1638758',4100.40,0.00,0.00,6.03,440.19,'2022-05-20 12:42:56','',''),(2646872,'1','186','940',419,'Retail Sale Id 1638759',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:44:10','',''),(2646873,'1','186','940',419,'Retail Sale Id 1638760',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 12:46:36','',''),(2646874,'1','186','940',419,'Retail Sale Id 1638761',7480.00,0.00,0.00,11.00,803.00,'2022-05-20 12:48:45','',''),(2646875,'1','186','940',419,'Retail Sale Id 1638762',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:54:09','',''),(2646876,'1','186','940',419,'Retail Sale Id 1638763',6997.20,0.00,0.00,10.29,751.17,'2022-05-20 12:55:46','',''),(2646877,'1','186','940',419,'Retail Sale Id 1638764',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 12:57:25','',''),(2646878,'1','186','940',419,'Retail Sale Id 1638765',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 12:59:47','',''),(2646879,'1','186','940',419,'Retail Sale Id 1638766',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 13:02:33','',''),(2646880,'1','186','940',419,'Retail Sale Id 1638767',7480.00,0.00,0.00,11.00,803.00,'2022-05-20 13:04:02','',''),(2646881,'1','186','940',419,'Retail Sale Id 1638768',999.60,0.00,0.00,1.47,107.31,'2022-05-20 13:05:35','',''),(2646882,'1','186','940',419,'Retail Sale Id 1638769',2747.20,0.00,0.00,4.04,294.92,'2022-05-20 13:10:16','',''),(2646883,'1','186','940',419,'Retail Sale Id 1638770',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 13:11:22','',''),(2646884,'1','186','940',419,'Retail Sale Id 1638771',2046.80,0.00,0.00,3.01,219.73,'2022-05-20 13:12:29','',''),(2646885,'1','186','940',419,'Retail Sale Id 1638772',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 13:13:30','',''),(2646886,'1','186','940',419,'Retail Sale Id 1638773',28350.00,0.00,0.00,45.00,1035.00,'2022-05-20 13:19:23','',''),(2646887,'1','186','940',419,'Retail Sale Id 1638774',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 13:23:13','',''),(2646888,'1','186','940',419,'Retail Sale Id 1638776',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 13:27:25','',''),(2646889,'1','186','940',419,'Retail Sale Id 1638777',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 13:31:58','',''),(2646890,'1','186','940',419,'Retail Sale Id 1638778',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 13:35:00','',''),(2646891,'1','186','940',419,'Retail Sale Id 1638779',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 13:36:17','',''),(2646892,'1','186','940',419,'Retail Sale Id 1638780',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 13:40:39','',''),(2646893,'1','186','940',419,'Retail Sale Id 1638781',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 14:37:37','',''),(2646894,'1','186','940',419,'Retail Sale Id 1638782',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 14:38:21','',''),(2646895,'1','186','940',419,'Retail Sale Id 1638783',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 14:39:24','',''),(2646896,'1','186','940',419,'Retail Sale Id 1638783',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 14:39:24','',''),(2646897,'1','186','940',419,'Retail Sale Id 1638784',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 14:40:23','',''),(2646898,'1','186','940',419,'Retail Sale Id 1638785',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 14:41:15','',''),(2646899,'1','186','940',419,'Retail Sale Id 1638786',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 14:42:34','',''),(2646900,'1','186','940',419,'Retail Sale Id 1638787',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 14:43:23','',''),(2646901,'1','186','940',419,'Retail Sale Id 1638788',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 14:44:07','',''),(2646902,'1','186','940',419,'Retail Sale Id 1638789',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 14:45:00','',''),(2646903,'1','186','940',419,'Retail Sale Id 1638798',2801.60,0.00,0.00,4.12,300.76,'2022-05-20 14:46:47','',''),(2646904,'1','186','940',419,'Retail Sale Id 1638799',999.60,0.00,0.00,1.47,107.31,'2022-05-20 14:48:55','',''),(2646905,'1','186','940',419,'Retail Sale Id 1638800',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 14:51:37','',''),(2646906,'1','186','940',419,'Retail Sale Id 1638801',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 14:52:53','',''),(2646907,'1','186','940',419,'Retail Sale Id 1638802',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 14:54:16','',''),(2646908,'1','186','940',419,'Retail Sale Id 1638804',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 14:57:01','',''),(2646909,'1','186','940',419,'Retail Sale Id 1638805',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 14:58:01','',''),(2646910,'1','186','940',419,'Retail Sale Id 1638806',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 14:59:34','',''),(2646911,'1','186','940',419,'Retail Sale Id 1638807',63000.00,0.00,0.00,100.00,2300.00,'2022-05-20 15:01:46','',''),(2646912,'1','186','940',419,'Retail Sale Id 1638808',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:03:09','',''),(2646913,'1','186','940',419,'Retail Sale Id 1638809',999.60,0.00,0.00,1.47,107.31,'2022-05-20 15:03:55','',''),(2646914,'1','186','940',419,'Retail Sale Id 1638810',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 15:04:39','',''),(2646915,'1','186','940',419,'Retail Sale Id 1638811',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 15:07:27','',''),(2646916,'1','186','940',419,'Retail Sale Id 1638812',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 15:08:18','',''),(2646917,'1','186','940',419,'Retail Sale Id 1638813',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 15:09:51','',''),(2646918,'1','186','940',419,'Retail Sale Id 1638813',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 15:09:51','',''),(2646919,'1','186','940',419,'Retail Sale Id 1638814',34650.00,0.00,0.00,55.00,1265.00,'2022-05-20 15:11:06','',''),(2646920,'1','186','940',419,'Retail Sale Id 1638818',2801.60,0.00,0.00,4.12,300.76,'2022-05-20 15:12:19','',''),(2646921,'1','186','940',419,'Retail Sale Id 1638820',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 15:13:29','',''),(2646922,'1','186','940',419,'Retail Sale Id 1638821',6296.80,0.00,0.00,9.26,675.98,'2022-05-20 15:14:40','',''),(2646923,'1','186','940',419,'Retail Sale Id 1638822',999.60,0.00,0.00,1.47,107.31,'2022-05-20 15:15:29','',''),(2646924,'1','186','940',419,'Retail Sale Id 1638823',2502.40,0.00,0.00,3.68,268.64,'2022-05-20 15:16:49','',''),(2646925,'1','186','940',419,'Retail Sale Id 1638824',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 15:17:52','',''),(2646926,'1','186','940',419,'Retail Sale Id 1638825',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 15:19:21','',''),(2646927,'1','186','940',419,'Retail Sale Id 1638826',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 15:20:40','',''),(2646928,'1','186','940',419,'Retail Sale Id 1638827',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 15:23:21','',''),(2646929,'1','186','940',419,'Retail Sale Id 1638828',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 15:24:21','',''),(2646930,'1','186','940',419,'Retail Sale Id 1638829',2699.60,0.00,0.00,3.97,289.81,'2022-05-20 15:25:33','',''),(2646931,'1','186','940',419,'Retail Sale Id 1638830',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 15:26:37','',''),(2646932,'1','186','940',419,'Retail Sale Id 1638831',220500.00,0.00,0.00,350.00,8050.00,'2022-05-20 15:28:26','',''),(2646933,'1','186','940',419,'Retail Sale Id 1638832',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:29:21','',''),(2646934,'1','186','940',419,'Retail Sale Id 1638833',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 15:30:06','',''),(2646935,'1','186','940',419,'Retail Sale Id 1638834',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 15:31:07','',''),(2646936,'1','186','940',419,'Retail Sale Id 1638835',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:32:03','',''),(2646937,'1','186','940',419,'Retail Sale Id 1638835',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:32:03','',''),(2646938,'1','186','940',419,'Retail Sale Id 1638836',6120.00,0.00,0.00,9.00,657.00,'2022-05-20 15:32:59','',''),(2646939,'1','186','940',419,'Retail Sale Id 1638837',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:33:55','',''),(2646940,'1','186','940',419,'Retail Sale Id 1638838',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 15:34:34','',''),(2646941,'1','186','940',419,'Retail Sale Id 1638839',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:36:10','',''),(2646942,'1','186','940',419,'Retail Sale Id 1638840',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:37:12','',''),(2646943,'1','186','940',419,'Retail Sale Id 1638841',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 15:39:24','',''),(2646944,'1','186','940',419,'Retail Sale Id 1638842',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 15:40:41','',''),(2646945,'1','186','940',419,'Retail Sale Id 1638843',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 15:49:58','',''),(2646946,'1','186','940',419,'Retail Sale Id 1638844',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 15:52:55','',''),(2646947,'1','186','940',419,'Retail Sale Id 1638845',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:54:07','',''),(2646948,'1','186','940',419,'Retail Sale Id 1638846',7480.00,0.00,0.00,11.00,803.00,'2022-05-20 15:56:03','',''),(2646949,'1','186','940',419,'Retail Sale Id 1638847',3502.00,0.00,0.00,5.15,375.95,'2022-05-20 15:57:07','',''),(2646950,'1','186','940',419,'Retail Sale Id 1638848',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 15:57:45','',''),(2646951,'1','186','940',419,'Retail Sale Id 1638849',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 15:58:34','',''),(2646952,'1','186','940',419,'Retail Sale Id 1638850',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 16:01:00','',''),(2646953,'1','186','940',419,'Retail Sale Id 1638851',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 16:02:09','',''),(2646954,'1','186','940',419,'Retail Sale Id 1638852',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 16:03:58','',''),(2646955,'1','186','940',419,'Retail Sale Id 1638852',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 16:03:58','',''),(2646956,'1','186','940',419,'Retail Sale Id 1638853',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 16:07:17','',''),(2646957,'1','186','940',419,'Retail Sale Id 1638854',3053.20,0.00,0.00,4.49,327.77,'2022-05-20 16:08:18','',''),(2646958,'1','186','940',419,'Retail Sale Id 1638855',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 16:09:33','',''),(2646959,'1','186','940',419,'Retail Sale Id 1638856',2046.80,0.00,0.00,3.01,219.73,'2022-05-20 16:11:02','',''),(2646960,'1','186','940',419,'Retail Sale Id 1638858',4250.00,0.00,0.00,6.25,456.25,'2022-05-20 16:11:46','',''),(2646961,'1','186','940',419,'Retail Sale Id 1638859',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 16:17:51','',''),(2646962,'1','186','940',419,'Retail Sale Id 1638860',12600.00,0.00,0.00,20.00,460.00,'2022-05-20 16:22:25','',''),(2646963,'1','186','940',419,'Retail Sale Id 1638861',1196.80,0.00,0.00,1.76,128.48,'2022-05-20 16:23:57','',''),(2646964,'1','186','940',419,'Retail Sale Id 1638862',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 16:25:58','',''),(2646965,'1','186','940',419,'Retail Sale Id 1638863',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 16:27:54','',''),(2646966,'1','186','940',419,'Retail Sale Id 1638864',2801.60,0.00,0.00,4.12,300.76,'2022-05-20 16:29:26','',''),(2646967,'1','186','940',419,'Retail Sale Id 1638865',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 16:30:20','',''),(2646968,'1','186','940',419,'Retail Sale Id 1638866',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 16:31:50','',''),(2646969,'1','186','940',419,'Retail Sale Id 1638867',4100.40,0.00,0.00,6.03,440.19,'2022-05-20 16:32:50','',''),(2646970,'1','186','940',419,'Retail Sale Id 1638868',4100.40,0.00,0.00,6.03,440.19,'2022-05-20 16:34:11','',''),(2646971,'1','186','940',419,'Retail Sale Id 1638869',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 16:37:43','',''),(2646972,'1','186','940',419,'Retail Sale Id 1638870',2046.80,0.00,0.00,3.01,219.73,'2022-05-20 16:38:59','',''),(2646973,'1','186','940',419,'Retail Sale Id 1638871',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 16:40:01','',''),(2646974,'1','186','940',419,'Retail Sale Id 1638872',999.60,0.00,0.00,1.47,107.31,'2022-05-20 16:40:49','',''),(2646975,'1','186','940',419,'Retail Sale Id 1638873',3998.40,0.00,0.00,5.88,429.24,'2022-05-20 16:41:38','',''),(2646976,'1','186','940',419,'Retail Sale Id 1638874',999.60,0.00,0.00,1.47,107.31,'2022-05-20 16:42:25','',''),(2646977,'1','186','940',419,'Retail Sale Id 1638875',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 16:43:55','',''),(2646978,'1','186','940',419,'Retail Sale Id 1638876',3998.40,0.00,0.00,5.88,429.24,'2022-05-20 16:46:19','',''),(2646979,'1','186','940',419,'Retail Sale Id 1638876',7996.80,0.00,0.00,11.76,858.48,'2022-05-20 16:46:19','',''),(2646980,'1','186','940',419,'Retail Sale Id 1638877',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 16:47:43','',''),(2646981,'1','186','940',419,'Retail Sale Id 1638878',1400.80,0.00,0.00,2.06,150.38,'2022-05-20 16:49:04','',''),(2646982,'1','186','940',419,'Retail Sale Id 1638879',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:49:45','',''),(2646983,'1','186','940',419,'Retail Sale Id 1638880',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:51:26','',''),(2646984,'1','186','940',419,'Retail Sale Id 1638881',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 16:52:30','',''),(2646985,'1','186','940',419,'Retail Sale Id 1638882',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:53:28','',''),(2646986,'1','186','940',419,'Retail Sale Id 1638883',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:54:13','',''),(2646987,'1','186','940',419,'Retail Sale Id 1638884',680.00,0.00,0.00,1.00,73.00,'2022-05-20 16:55:38','',''),(2646988,'1','186','940',419,'Retail Sale Id 1638884',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 16:55:38','',''),(2646989,'1','186','940',419,'Retail Sale Id 1638885',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:56:20','',''),(2646990,'1','186','940',419,'Retail Sale Id 1638886',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:57:00','',''),(2646991,'1','186','940',419,'Retail Sale Id 1638887',3998.40,0.00,0.00,5.88,429.24,'2022-05-20 16:57:39','',''),(2646992,'1','186','940',419,'Retail Sale Id 1638888',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 16:58:27','',''),(2646993,'1','186','940',419,'Retail Sale Id 1638889',2502.40,0.00,0.00,3.68,268.64,'2022-05-20 16:59:26','',''),(2646994,'1','186','940',419,'Retail Sale Id 1638890',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 17:00:21','',''),(2646995,'1','186','940',419,'Retail Sale Id 1638891',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 17:01:25','',''),(2646996,'1','186','940',419,'Retail Sale Id 1638891',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 17:01:25','',''),(2646997,'1','186','940',419,'Retail Sale Id 1638891',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:01:25','',''),(2646998,'1','186','940',419,'Retail Sale Id 1638892',282600.00,0.00,0.00,450.00,9450.00,'2022-05-20 17:03:35','',''),(2646999,'1','186','940',419,'Retail Sale Id 1638893',7480.00,0.00,0.00,11.00,803.00,'2022-05-20 17:05:18','',''),(2647000,'1','186','940',419,'Retail Sale Id 1638894',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 17:08:24','',''),(2647001,'1','186','940',419,'Retail Sale Id 1638895',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 17:10:00','',''),(2647002,'1','186','940',419,'Retail Sale Id 1638896',1502.80,0.00,0.00,2.21,161.33,'2022-05-20 17:11:27','',''),(2647003,'1','186','940',419,'Retail Sale Id 1638897',1101.60,0.00,0.00,1.62,118.26,'2022-05-20 17:12:42','',''),(2647004,'1','186','940',419,'Retail Sale Id 1638897',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:12:42','',''),(2647005,'1','186','940',419,'Retail Sale Id 1638898',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:14:04','',''),(2647006,'1','186','940',419,'Retail Sale Id 1638899',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:14:42','',''),(2647007,'1','186','940',419,'Retail Sale Id 1638900',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:15:15','',''),(2647008,'1','186','940',419,'Retail Sale Id 1638901',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 17:16:52','',''),(2647009,'1','186','940',419,'Retail Sale Id 1638902',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:17:48','',''),(2647010,'1','186','940',419,'Retail Sale Id 1638903',1999.20,0.00,0.00,2.94,214.62,'2022-05-20 17:19:30','',''),(2647011,'1','186','940',419,'Retail Sale Id 1638904',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 17:20:11','',''),(2647012,'1','186','940',419,'Retail Sale Id 1638905',6800.00,0.00,0.00,10.00,730.00,'2022-05-20 17:21:08','',''),(2647013,'1','186','940',419,'Retail Sale Id 1638906',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 17:22:24','',''),(2647014,'1','186','940',419,'Retail Sale Id 1638907',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:23:50','',''),(2647015,'1','186','940',419,'Retail Sale Id 1638908',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:25:25','',''),(2647016,'1','186','940',419,'Retail Sale Id 1638909',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 17:26:14','',''),(2647017,'1','186','940',419,'Retail Sale Id 1638910',3148.40,0.00,0.00,4.63,337.99,'2022-05-20 17:28:14','',''),(2647018,'1','186','940',419,'Retail Sale Id 1638911',1802.00,0.00,0.00,2.65,193.45,'2022-05-20 17:29:17','',''),(2647019,'1','186','940',419,'Retail Sale Id 1638913',2203.20,0.00,0.00,3.24,236.52,'2022-05-20 17:30:38','',''),(2647020,'1','186','940',419,'Retail Sale Id 1638914',1360.00,0.00,0.00,2.00,146.00,'2022-05-20 17:31:55','',''),(2647021,'1','186','940',419,'Retail Sale Id 1638914',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:31:55','',''),(2647022,'1','186','940',419,'Retail Sale Id 1638915',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 17:33:35','',''),(2647023,'1','186','940',419,'Retail Sale Id 1638916',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 17:35:06','',''),(2647024,'1','186','940',419,'Retail Sale Id 1638916',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 17:35:06','',''),(2647025,'1','186','940',419,'Retail Sale Id 1638917',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 17:36:21','',''),(2647026,'1','186','940',419,'Retail Sale Id 1638918',31500.00,0.00,0.00,50.00,1150.00,'2022-05-20 17:37:15','',''),(2647027,'1','186','940',419,'Retail Sale Id 1638919',2040.00,0.00,0.00,3.00,219.00,'2022-05-20 17:38:56','',''),(2647028,'1','186','940',419,'Retail Sale Id 1638920',8248.40,0.00,0.00,12.13,885.49,'2022-05-20 17:41:48','',''),(2647029,'1','186','940',419,'Retail Sale Id 1638920',8248.40,0.00,0.00,12.13,885.49,'2022-05-20 17:41:48','',''),(2647030,'1','186','940',419,'Retail Sale Id 1638924',1047.20,0.00,0.00,1.54,112.42,'2022-05-20 17:44:29','',''),(2647031,'1','186','940',419,'Retail Sale Id 1638925',8500.00,0.00,0.00,12.50,912.50,'2022-05-20 17:46:18','',''),(2647032,'1','186','940',419,'Retail Sale Id 1638926',999.60,0.00,0.00,1.47,107.31,'2022-05-20 17:47:24','',''),(2647033,'1','186','940',419,'Retail Sale Id 1638927',2720.00,0.00,0.00,4.00,292.00,'2022-05-20 17:48:47','',''),(2647034,'1','186','940',419,'Retail Sale Id 1638928',3400.00,0.00,0.00,5.00,365.00,'2022-05-20 17:49:27','',''),(2647035,'1','186','940',419,'Retail Sale Id 1638929',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 17:50:20','',''),(2647036,'1','186','940',419,'Retail Sale Id 1638930',4080.00,0.00,0.00,6.00,438.00,'2022-05-20 17:51:12','',''),(2647037,'1','186','940',419,'Return of Retail Sale Id 1638892',0.00,282600.00,450.00,0.00,-9450.00,'2022-05-20 18:12:15','',''),(2647038,'1','186','940',419,'Retail Sale Id 1638932',252255.04,0.00,0.00,401.68,8435.28,'2022-05-20 18:15:22','',''),(2647039,'1','186','940',419,'Retail Sale Id 1638933',2998.80,0.00,0.00,4.41,321.93,'2022-05-20 18:42:20','',''),(2647040,'1','186','940',419,'Retail Sale Id 1638934',1516.40,0.00,0.00,2.23,162.79,'2022-05-20 18:43:57','',''),(2647041,'1','186','940',419,'Return of Retail Sale Id 1638934',0.00,1516.40,2.23,0.00,-162.79,'2022-05-20 19:09:30','',''),(2647042,'1','186','940',419,'Return of Retail Sale Id 1638929',0.00,2998.80,4.41,0.00,-321.93,'2022-05-20 19:11:03','',''),(2647043,'1','186','940',419,'Retail Sale Id 1638935',1693.20,0.00,0.00,2.49,181.77,'2022-05-20 19:11:50','',''),(2647044,'1','186','940',419,'Retail Sale Id 1638936',2822.40,0.00,0.00,4.48,103.04,'2022-05-20 19:15:44','',''),(2647045,'1','186','940',419,'Retail Sale Id 1638937',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 07:39:45','',''),(2647046,'1','186','940',419,'Retail Sale Id 1638938',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 07:44:20','',''),(2647047,'1','186','940',419,'Retail Sale Id 1638939',2502.40,0.00,0.00,3.68,268.64,'2022-05-21 07:50:31','',''),(2647048,'1','186','940',419,'Retail Sale Id 1638940',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 07:52:41','',''),(2647049,'1','186','940',419,'Retail Sale Id 1638941',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 08:02:55','',''),(2647050,'1','186','940',419,'Retail Sale Id 1638942',19530.00,0.00,0.00,31.00,713.00,'2022-05-21 08:12:15','',''),(2647051,'1','186','940',419,'Retail Sale Id 1638943',1196.80,0.00,0.00,1.76,128.48,'2022-05-21 08:13:22','',''),(2647052,'1','186','940',419,'Retail Sale Id 1638944',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 08:14:27','',''),(2647053,'1','186','940',419,'Retail Sale Id 1638945',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 08:16:38','',''),(2647054,'1','186','940',419,'Retail Sale Id 1638946',999.60,0.00,0.00,1.47,107.31,'2022-05-21 08:17:20','',''),(2647055,'1','186','940',419,'Retail Sale Id 1638947',6201.60,0.00,0.00,9.12,665.76,'2022-05-21 08:18:16','',''),(2647056,'1','186','940',419,'Retail Sale Id 1638948',2101.20,0.00,0.00,3.09,225.57,'2022-05-21 08:19:08','',''),(2647057,'1','186','940',419,'Retail Sale Id 1638949',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 08:19:52','',''),(2647058,'1','186','940',419,'Retail Sale Id 1638950',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 08:20:34','',''),(2647059,'1','186','940',419,'Retail Sale Id 1638951',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:22:21','',''),(2647060,'1','186','940',419,'Retail Sale Id 1638952',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:24:44','',''),(2647061,'1','186','940',419,'Retail Sale Id 1638953',4998.00,0.00,0.00,7.35,536.55,'2022-05-21 08:26:15','',''),(2647062,'1','186','940',419,'Retail Sale Id 1638954',15750.00,0.00,0.00,25.00,575.00,'2022-05-21 08:27:26','',''),(2647063,'1','186','940',419,'Retail Sale Id 1638955',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 08:28:42','',''),(2647064,'1','186','940',419,'Retail Sale Id 1638956',1298.80,0.00,0.00,1.91,139.43,'2022-05-21 08:29:36','',''),(2647065,'1','186','940',419,'Retail Sale Id 1638957',999.60,0.00,0.00,1.47,107.31,'2022-05-21 08:33:17','',''),(2647066,'1','186','940',419,'Retail Sale Id 1638958',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 08:35:05','',''),(2647067,'1','186','940',419,'Retail Sale Id 1638959',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:36:36','',''),(2647068,'1','186','940',419,'Retail Sale Id 1638960',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 08:38:06','',''),(2647069,'1','186','940',419,'Retail Sale Id 1638961',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 08:38:54','',''),(2647070,'1','186','940',419,'Retail Sale Id 1638962',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 08:39:49','',''),(2647071,'1','186','940',419,'Retail Sale Id 1638963',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 08:40:38','',''),(2647072,'1','186','940',419,'Retail Sale Id 1638964',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 08:41:37','',''),(2647073,'1','186','940',419,'Retail Sale Id 1638965',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:43:16','',''),(2647074,'1','186','940',419,'Retail Sale Id 1638966',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 08:44:17','',''),(2647075,'1','186','940',419,'Retail Sale Id 1638967',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:45:07','',''),(2647076,'1','186','940',419,'Retail Sale Id 1638968',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 08:45:54','',''),(2647077,'1','186','940',419,'Retail Sale Id 1638969',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 08:46:58','',''),(2647078,'1','186','940',419,'Retail Sale Id 1638970',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 08:47:58','',''),(2647079,'1','186','940',419,'Retail Sale Id 1638971',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 08:48:48','',''),(2647080,'1','186','940',419,'Retail Sale Id 1638972',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 08:49:27','',''),(2647081,'1','186','940',419,'Retail Sale Id 1638973',2801.60,0.00,0.00,4.12,300.76,'2022-05-21 08:50:16','',''),(2647082,'1','186','940',419,'Retail Sale Id 1638974',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 08:51:28','',''),(2647083,'1','186','940',419,'Retail Sale Id 1638975',2801.60,0.00,0.00,4.12,300.76,'2022-05-21 08:52:29','',''),(2647084,'1','186','940',419,'Retail Sale Id 1638976',999.60,0.00,0.00,1.47,107.31,'2022-05-21 08:53:12','',''),(2647085,'1','186','940',419,'Retail Sale Id 1638977',999.60,0.00,0.00,1.47,107.31,'2022-05-21 08:53:52','',''),(2647086,'1','186','940',419,'Retail Sale Id 1638978',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 08:54:34','',''),(2647087,'1','186','940',419,'Retail Sale Id 1638979',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:55:30','',''),(2647088,'1','186','940',419,'Retail Sale Id 1638980',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 08:56:14','',''),(2647089,'1','186','940',419,'Retail Sale Id 1638981',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 08:57:13','',''),(2647090,'1','186','940',419,'Retail Sale Id 1638982',999.60,0.00,0.00,1.47,107.31,'2022-05-21 08:59:01','',''),(2647091,'1','186','940',419,'Retail Sale Id 1638983',2101.20,0.00,0.00,3.09,225.57,'2022-05-21 09:01:19','',''),(2647092,'1','186','940',419,'Retail Sale Id 1638984',999.60,0.00,0.00,1.47,107.31,'2022-05-21 09:02:47','',''),(2647093,'1','186','940',419,'Retail Sale Id 1638985',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:04:08','',''),(2647094,'1','186','940',419,'Retail Sale Id 1638986',1298.80,0.00,0.00,1.91,139.43,'2022-05-21 09:06:15','',''),(2647095,'1','186','940',419,'Retail Sale Id 1638987',27720.00,0.00,0.00,44.00,1012.00,'2022-05-21 09:07:46','',''),(2647096,'1','186','940',419,'Retail Sale Id 1638988',1802.00,0.00,0.00,2.65,193.45,'2022-05-21 09:11:39','',''),(2647097,'1','186','940',419,'Retail Sale Id 1638989',2699.60,0.00,0.00,3.97,289.81,'2022-05-21 09:13:11','',''),(2647098,'1','186','940',419,'Retail Sale Id 1638990',39060.00,0.00,0.00,62.00,1426.00,'2022-05-21 09:14:26','',''),(2647099,'1','186','940',419,'Retail Sale Id 1638991',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 09:20:11','',''),(2647100,'1','186','940',419,'Retail Sale Id 1638993',6296.80,0.00,0.00,9.26,675.98,'2022-05-21 09:24:33','',''),(2647101,'1','186','940',419,'Retail Sale Id 1638994',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:29:12','',''),(2647102,'1','186','940',419,'Retail Sale Id 1638994',8160.00,0.00,0.00,12.00,876.00,'2022-05-21 09:29:12','',''),(2647103,'1','186','940',419,'Retail Sale Id 1638995',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 09:30:16','',''),(2647104,'1','186','940',419,'Retail Sale Id 1638996',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 09:31:46','',''),(2647105,'1','186','940',419,'Retail Sale Id 1638997',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 09:33:03','',''),(2647106,'1','186','940',419,'Retail Sale Id 1638998',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 09:33:48','',''),(2647107,'1','186','940',419,'Retail Sale Id 1638999',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 09:34:58','',''),(2647108,'1','186','940',419,'Retail Sale Id 1639000',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:35:44','',''),(2647109,'1','186','940',419,'Retail Sale Id 1639001',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 09:36:47','',''),(2647110,'1','186','940',419,'Retail Sale Id 1639002',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 09:37:25','',''),(2647111,'1','186','940',419,'Retail Sale Id 1639003',5440.00,0.00,0.00,8.00,584.00,'2022-05-21 09:38:22','',''),(2647112,'1','186','940',419,'Retail Sale Id 1639004',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 09:39:21','',''),(2647113,'1','186','940',419,'Retail Sale Id 1639005',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:39:59','',''),(2647114,'1','186','940',419,'Retail Sale Id 1639006',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 09:40:41','',''),(2647115,'1','186','940',419,'Retail Sale Id 1639007',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 09:41:31','',''),(2647116,'1','186','940',419,'Retail Sale Id 1639008',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 09:42:10','',''),(2647117,'1','186','940',419,'Retail Sale Id 1639009',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 09:42:42','',''),(2647118,'1','186','940',419,'Retail Sale Id 1639010',7480.00,0.00,0.00,11.00,803.00,'2022-05-21 09:44:00','',''),(2647119,'1','186','940',419,'Retail Sale Id 1639011',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 09:44:48','',''),(2647120,'1','186','940',419,'Retail Sale Id 1639012',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 09:45:34','',''),(2647121,'1','186','940',419,'Retail Sale Id 1639013',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:46:12','',''),(2647122,'1','186','940',419,'Retail Sale Id 1639014',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 09:46:49','',''),(2647123,'1','186','940',419,'Retail Sale Id 1639015',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 09:47:24','',''),(2647124,'1','186','940',419,'Retail Sale Id 1639016',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 09:48:14','',''),(2647125,'1','186','940',419,'Retail Sale Id 1639017',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:49:28','',''),(2647126,'1','186','940',419,'Retail Sale Id 1639018',4760.00,0.00,0.00,7.00,511.00,'2022-05-21 09:50:09','',''),(2647127,'1','186','940',419,'Retail Sale Id 1639019',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:51:35','',''),(2647128,'1','186','940',419,'Retail Sale Id 1639019',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 09:51:35','',''),(2647129,'1','186','940',419,'Retail Sale Id 1639019',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 09:51:35','',''),(2647130,'1','186','940',419,'Retail Sale Id 1639020',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 09:52:44','',''),(2647131,'1','186','940',419,'Retail Sale Id 1639021',1502.80,0.00,0.00,2.21,161.33,'2022-05-21 09:53:42','',''),(2647132,'1','186','940',419,'Retail Sale Id 1639022',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 09:54:23','',''),(2647133,'1','186','940',419,'Retail Sale Id 1639023',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 09:56:09','',''),(2647134,'1','186','940',419,'Retail Sale Id 1639024',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 09:56:53','',''),(2647135,'1','186','940',419,'Retail Sale Id 1639025',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 09:58:31','',''),(2647136,'1','186','940',419,'Retail Sale Id 1639026',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 09:59:21','',''),(2647137,'1','186','940',419,'Retail Sale Id 1639027',999.60,0.00,0.00,1.47,107.31,'2022-05-21 10:00:27','',''),(2647138,'1','186','940',419,'Retail Sale Id 1639027',1502.80,0.00,0.00,2.21,161.33,'2022-05-21 10:00:27','',''),(2647139,'1','186','940',419,'Retail Sale Id 1639028',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 10:01:38','',''),(2647140,'1','186','940',419,'Retail Sale Id 1639029',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 10:04:44','',''),(2647141,'1','186','940',419,'Retail Sale Id 1639031',5501.20,0.00,0.00,8.09,590.57,'2022-05-21 10:05:40','',''),(2647142,'1','186','940',419,'Retail Sale Id 1639032',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:06:59','',''),(2647143,'1','186','940',419,'Retail Sale Id 1639032',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:06:59','',''),(2647144,'1','186','940',419,'Retail Sale Id 1639033',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:08:32','',''),(2647145,'1','186','940',419,'Retail Sale Id 1639034',5446.80,0.00,0.00,8.01,584.73,'2022-05-21 10:09:34','',''),(2647146,'1','186','940',419,'Retail Sale Id 1639035',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:10:17','',''),(2647147,'1','186','940',419,'Retail Sale Id 1639036',22050.00,0.00,0.00,35.00,805.00,'2022-05-21 10:11:55','',''),(2647148,'1','186','940',419,'Retail Sale Id 1639037',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 10:13:06','',''),(2647149,'1','186','940',419,'Retail Sale Id 1639038',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 10:14:09','',''),(2647150,'1','186','940',419,'Retail Sale Id 1639039',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:14:57','',''),(2647151,'1','186','940',419,'Retail Sale Id 1639040',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:15:40','',''),(2647152,'1','186','940',419,'Retail Sale Id 1639041',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 10:17:53','',''),(2647153,'1','186','940',419,'Retail Sale Id 1639042',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 10:18:52','',''),(2647154,'1','186','940',419,'Retail Sale Id 1639043',34650.00,0.00,0.00,55.00,1265.00,'2022-05-21 10:19:58','',''),(2647155,'1','186','940',419,'Retail Sale Id 1639044',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 10:20:56','',''),(2647156,'1','186','940',419,'Retail Sale Id 1639045',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 10:22:59','',''),(2647157,'1','186','940',419,'Retail Sale Id 1639046',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:25:52','',''),(2647158,'1','186','940',419,'Retail Sale Id 1639048',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:27:52','',''),(2647159,'1','186','940',419,'Retail Sale Id 1639051',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 10:29:31','',''),(2647160,'1','186','940',419,'Retail Sale Id 1639052',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 10:30:45','',''),(2647161,'1','186','940',419,'Retail Sale Id 1639053',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 10:31:48','',''),(2647162,'1','186','940',419,'Retail Sale Id 1639054',6120.00,0.00,0.00,9.00,657.00,'2022-05-21 10:32:27','',''),(2647163,'1','186','940',419,'Retail Sale Id 1639055',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:33:10','',''),(2647164,'1','186','940',419,'Retail Sale Id 1639056',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:33:59','',''),(2647165,'1','186','940',419,'Retail Sale Id 1639057',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:34:40','',''),(2647166,'1','186','940',419,'Retail Sale Id 1639058',6120.00,0.00,0.00,9.00,657.00,'2022-05-21 10:35:15','',''),(2647167,'1','186','940',419,'Retail Sale Id 1639059',2699.60,0.00,0.00,3.97,289.81,'2022-05-21 10:35:53','',''),(2647168,'1','186','940',419,'Retail Sale Id 1639060',999.60,0.00,0.00,1.47,107.31,'2022-05-21 10:36:36','',''),(2647169,'1','186','940',419,'Retail Sale Id 1639061',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 10:37:40','',''),(2647170,'1','186','940',419,'Retail Sale Id 1639062',18900.00,0.00,0.00,30.00,690.00,'2022-05-21 10:38:22','',''),(2647171,'1','186','940',419,'Retail Sale Id 1639063',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 10:39:06','',''),(2647172,'1','186','940',419,'Retail Sale Id 1639064',6120.00,0.00,0.00,9.00,657.00,'2022-05-21 10:39:55','',''),(2647173,'1','186','940',419,'Retail Sale Id 1639065',2801.60,0.00,0.00,4.12,300.76,'2022-05-21 10:40:33','',''),(2647174,'1','186','940',419,'Retail Sale Id 1639066',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 10:42:37','',''),(2647175,'1','186','940',419,'Retail Sale Id 1639067',999.60,0.00,0.00,1.47,107.31,'2022-05-21 10:43:26','',''),(2647176,'1','186','940',419,'Retail Sale Id 1639068',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 10:44:09','',''),(2647177,'1','186','940',419,'Retail Sale Id 1639069',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 10:44:45','',''),(2647178,'1','186','940',419,'Retail Sale Id 1639070',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 10:45:58','',''),(2647179,'1','186','940',419,'Retail Sale Id 1639071',15750.00,0.00,0.00,25.00,575.00,'2022-05-21 10:46:46','',''),(2647180,'1','186','940',419,'Retail Sale Id 1639072',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 10:47:21','',''),(2647181,'1','186','940',419,'Retail Sale Id 1639073',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 10:48:47','',''),(2647182,'1','186','940',419,'Retail Sale Id 1639074',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:49:23','',''),(2647183,'1','186','940',419,'Retail Sale Id 1639075',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 10:49:58','',''),(2647184,'1','186','940',419,'Retail Sale Id 1639076',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 10:50:37','',''),(2647185,'1','186','940',419,'Retail Sale Id 1639077',15750.00,0.00,0.00,25.00,575.00,'2022-05-21 10:53:07','',''),(2647186,'1','186','940',419,'Retail Sale Id 1639079',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 10:53:42','',''),(2647187,'1','186','940',419,'Retail Sale Id 1639082',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 10:54:40','',''),(2647188,'1','186','940',419,'Retail Sale Id 1639083',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 10:55:18','',''),(2647189,'1','186','940',419,'Retail Sale Id 1639084',4998.00,0.00,0.00,7.35,536.55,'2022-05-21 10:56:14','',''),(2647190,'1','186','940',419,'Retail Sale Id 1639085',999.60,0.00,0.00,1.47,107.31,'2022-05-21 10:57:41','',''),(2647191,'1','186','940',419,'Retail Sale Id 1639086',2699.60,0.00,0.00,3.97,289.81,'2022-05-21 10:58:51','',''),(2647192,'1','186','940',419,'Retail Sale Id 1639087',2101.20,0.00,0.00,3.09,225.57,'2022-05-21 10:59:37','',''),(2647193,'1','186','940',419,'Retail Sale Id 1639088',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 11:00:37','',''),(2647194,'1','186','940',419,'Retail Sale Id 1639089',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 11:01:47','',''),(2647195,'1','186','940',419,'Retail Sale Id 1639090',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 11:03:15','',''),(2647196,'1','186','940',419,'Retail Sale Id 1639091',999.60,0.00,0.00,1.47,107.31,'2022-05-21 11:04:06','',''),(2647197,'1','186','940',419,'Retail Sale Id 1639092',2101.20,0.00,0.00,3.09,225.57,'2022-05-21 11:05:09','',''),(2647198,'1','186','940',419,'Retail Sale Id 1639093',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 11:06:02','',''),(2647199,'1','186','940',419,'Retail Sale Id 1639094',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 11:08:19','',''),(2647200,'1','186','940',419,'Retail Sale Id 1639095',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 11:09:37','',''),(2647201,'1','186','940',419,'Retail Sale Id 1639096',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 11:12:24','',''),(2647202,'1','186','940',419,'Retail Sale Id 1639097',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 11:14:36','',''),(2647203,'1','186','940',419,'Retail Sale Id 1639098',7480.00,0.00,0.00,11.00,803.00,'2022-05-21 11:16:12','',''),(2647204,'1','186','940',419,'Retail Sale Id 1639099',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 11:16:56','',''),(2647205,'1','186','940',419,'Retail Sale Id 1639101',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 11:18:39','',''),(2647206,'1','186','940',419,'Retail Sale Id 1639102',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 11:19:45','',''),(2647207,'1','186','940',419,'Retail Sale Id 1639103',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 11:20:43','',''),(2647208,'1','186','940',419,'Retail Sale Id 1639104',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 11:21:31','',''),(2647209,'1','186','940',419,'Retail Sale Id 1639105',999.60,0.00,0.00,1.47,107.31,'2022-05-21 11:22:17','',''),(2647210,'1','186','940',419,'Retail Sale Id 1639107',126000.00,0.00,0.00,200.00,4600.00,'2022-05-21 11:25:38','',''),(2647211,'1','186','940',419,'Retail Sale Id 1639109',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 11:27:47','',''),(2647212,'1','186','940',419,'Retail Sale Id 1639110',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 11:28:51','',''),(2647213,'1','186','940',419,'Retail Sale Id 1639111',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 11:29:49','',''),(2647214,'1','186','940',419,'Retail Sale Id 1639114',2502.40,0.00,0.00,3.68,268.64,'2022-05-21 11:32:02','',''),(2647215,'1','186','940',419,'Retail Sale Id 1639115',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 11:32:50','',''),(2647216,'1','186','940',419,'Retail Sale Id 1639116',2747.20,0.00,0.00,4.04,294.92,'2022-05-21 11:38:30','',''),(2647217,'1','186','940',419,'Retail Sale Id 1639117',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 11:39:08','',''),(2647218,'1','186','940',419,'Retail Sale Id 1639117',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 11:39:08','',''),(2647219,'1','186','940',419,'Retail Sale Id 1639118',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 11:39:58','',''),(2647220,'1','186','940',419,'Retail Sale Id 1639119',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 11:41:07','',''),(2647221,'1','186','940',419,'Retail Sale Id 1639120',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 11:41:53','',''),(2647222,'1','186','940',419,'Retail Sale Id 1639121',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 11:42:21','',''),(2647223,'1','186','940',419,'Retail Sale Id 1639122',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 11:43:15','',''),(2647224,'1','186','940',419,'Retail Sale Id 1639123',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 11:44:39','',''),(2647225,'1','186','940',419,'Retail Sale Id 1639124',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 11:46:11','',''),(2647226,'1','186','940',419,'Retail Sale Id 1639125',4100.40,0.00,0.00,6.03,440.19,'2022-05-21 11:48:01','',''),(2647227,'1','186','940',419,'Retail Sale Id 1639127',1196.80,0.00,0.00,1.76,128.48,'2022-05-21 11:48:58','',''),(2647228,'1','186','940',419,'Retail Sale Id 1639128',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 11:49:40','',''),(2647229,'1','186','940',419,'Retail Sale Id 1639129',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 11:50:12','',''),(2647230,'1','186','940',419,'Retail Sale Id 1639130',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 11:51:00','',''),(2647231,'1','186','940',419,'Retail Sale Id 1639131',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 11:51:53','',''),(2647232,'1','186','940',419,'Retail Sale Id 1639132',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 11:53:50','',''),(2647233,'1','186','940',419,'Retail Sale Id 1639134',2046.80,0.00,0.00,3.01,219.73,'2022-05-21 11:54:47','',''),(2647234,'1','186','940',419,'Retail Sale Id 1639135',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 11:56:15','',''),(2647235,'1','186','940',419,'Retail Sale Id 1639136',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 11:57:43','',''),(2647236,'1','186','940',419,'Retail Sale Id 1639137',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 11:58:12','',''),(2647237,'1','186','940',419,'Retail Sale Id 1639138',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 11:58:56','',''),(2647238,'1','186','940',419,'Retail Sale Id 1639139',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 11:59:29','',''),(2647239,'1','186','940',419,'Retail Sale Id 1639140',1360.00,0.00,0.00,2.00,146.00,'2022-05-21 12:00:07','',''),(2647240,'1','186','940',419,'Retail Sale Id 1639141',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:00:56','',''),(2647241,'1','186','940',419,'Retail Sale Id 1639142',18900.00,0.00,0.00,30.00,690.00,'2022-05-21 12:02:21','',''),(2647242,'1','186','940',419,'Retail Sale Id 1639143',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 12:04:54','',''),(2647243,'1','186','940',419,'Retail Sale Id 1639145',2998.80,0.00,0.00,4.41,321.93,'2022-05-21 12:06:40','',''),(2647244,'1','186','940',419,'Retail Sale Id 1639148',2747.20,0.00,0.00,4.04,294.92,'2022-05-21 12:12:52','',''),(2647245,'1','186','940',419,'Retail Sale Id 1639149',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 12:14:02','',''),(2647246,'1','186','940',419,'Retail Sale Id 1639149',7480.00,0.00,0.00,11.00,803.00,'2022-05-21 12:14:02','',''),(2647247,'1','186','940',419,'Retail Sale Id 1639150',22680.00,0.00,0.00,36.00,828.00,'2022-05-21 12:16:41','',''),(2647248,'1','186','940',419,'Retail Sale Id 1639151',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 12:18:11','',''),(2647249,'1','186','940',419,'Retail Sale Id 1639153',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 12:19:17','',''),(2647250,'1','186','940',419,'Retail Sale Id 1639154',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 12:20:42','',''),(2647251,'1','186','940',419,'Retail Sale Id 1639155',28350.00,0.00,0.00,45.00,1035.00,'2022-05-21 12:21:36','',''),(2647252,'1','186','940',419,'Retail Sale Id 1639156',30870.00,0.00,0.00,49.00,1127.00,'2022-05-21 12:24:40','',''),(2647253,'1','186','940',419,'Retail Sale Id 1639157',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 12:25:31','',''),(2647254,'1','186','940',419,'Retail Sale Id 1639158',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 12:26:34','',''),(2647255,'1','186','940',419,'Retail Sale Id 1639159',3998.40,0.00,0.00,5.88,429.24,'2022-05-21 12:27:16','',''),(2647256,'1','186','940',419,'Retail Sale Id 1639160',4800.80,0.00,0.00,7.06,515.38,'2022-05-21 12:27:55','',''),(2647257,'1','186','940',419,'Retail Sale Id 1639161',999.60,0.00,0.00,1.47,107.31,'2022-05-21 12:28:41','',''),(2647258,'1','186','940',419,'Retail Sale Id 1639163',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 12:29:55','',''),(2647259,'1','186','940',419,'Retail Sale Id 1639164',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:32:09','',''),(2647260,'1','186','940',419,'Retail Sale Id 1639164',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 12:32:09','',''),(2647261,'1','186','940',419,'Retail Sale Id 1639165',36540.00,0.00,0.00,58.00,1334.00,'2022-05-21 12:33:20','',''),(2647262,'1','186','940',419,'Retail Sale Id 1639166',4760.00,0.00,0.00,7.00,511.00,'2022-05-21 12:34:21','',''),(2647263,'1','186','940',419,'Retail Sale Id 1639171',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 12:35:02','',''),(2647264,'1','186','940',419,'Retail Sale Id 1639172',6800.00,0.00,0.00,10.00,730.00,'2022-05-21 12:35:49','',''),(2647265,'1','186','940',419,'Retail Sale Id 1639173',63000.00,0.00,0.00,100.00,2300.00,'2022-05-21 12:36:43','',''),(2647266,'1','186','940',419,'Retail Sale Id 1639174',1502.80,0.00,0.00,2.21,161.33,'2022-05-21 12:37:54','',''),(2647267,'1','186','940',419,'Retail Sale Id 1639175',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:39:12','',''),(2647268,'1','186','940',419,'Retail Sale Id 1639176',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:40:16','',''),(2647269,'1','186','940',419,'Retail Sale Id 1639177',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 12:41:04','',''),(2647270,'1','186','940',419,'Retail Sale Id 1639178',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 12:42:54','',''),(2647271,'1','186','940',419,'Retail Sale Id 1639179',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:44:26','',''),(2647272,'1','186','940',419,'Retail Sale Id 1639180',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:46:02','',''),(2647273,'1','186','940',419,'Retail Sale Id 1639181',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 12:47:21','',''),(2647274,'1','186','940',419,'Retail Sale Id 1639184',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:48:33','',''),(2647275,'1','186','940',419,'Retail Sale Id 1639185',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 12:50:14','',''),(2647276,'1','186','940',419,'Retail Sale Id 1639186',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 12:51:35','',''),(2647277,'1','186','940',419,'Retail Sale Id 1639187',4998.00,0.00,0.00,7.35,536.55,'2022-05-21 12:52:46','',''),(2647278,'1','186','940',419,'Retail Sale Id 1639188',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 12:54:06','',''),(2647279,'1','186','940',419,'Retail Sale Id 1639189',4998.00,0.00,0.00,7.35,536.55,'2022-05-21 12:55:45','',''),(2647280,'1','186','940',419,'Retail Sale Id 1639190',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 12:56:42','',''),(2647281,'1','186','940',419,'Retail Sale Id 1639191',63000.00,0.00,0.00,100.00,2300.00,'2022-05-21 12:58:03','',''),(2647282,'1','186','940',419,'Retail Sale Id 1639192',8500.00,0.00,0.00,12.50,912.50,'2022-05-21 12:59:05','',''),(2647283,'1','186','940',419,'Retail Sale Id 1639193',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 13:02:05','',''),(2647284,'1','186','940',419,'Retail Sale Id 1639194',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 13:04:35','',''),(2647285,'1','186','940',419,'Retail Sale Id 1639195',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 13:05:54','',''),(2647286,'1','186','940',419,'Retail Sale Id 1639196',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 13:06:57','',''),(2647287,'1','186','940',419,'Retail Sale Id 1639197',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 13:07:51','',''),(2647288,'1','186','940',419,'Retail Sale Id 1639198',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 13:08:52','',''),(2647289,'1','186','940',419,'Retail Sale Id 1639198',2720.00,0.00,0.00,4.00,292.00,'2022-05-21 13:08:52','',''),(2647290,'1','186','940',419,'Retail Sale Id 1639199',3400.00,0.00,0.00,5.00,365.00,'2022-05-21 13:10:28','',''),(2647291,'1','186','940',419,'Retail Sale Id 1639200',2040.00,0.00,0.00,3.00,219.00,'2022-05-21 13:11:16','',''),(2647292,'1','186','940',419,'Retail Sale Id 1639201',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 13:12:01','',''),(2647293,'1','186','940',419,'Retail Sale Id 1639202',31500.00,0.00,0.00,50.00,1150.00,'2022-05-21 13:12:50','',''),(2647294,'1','186','940',419,'Retail Sale Id 1639203',4080.00,0.00,0.00,6.00,438.00,'2022-05-21 13:14:13','',''),(2647295,'1','186','940',419,'Retail Sale Id 1639204',1400.80,0.00,0.00,2.06,150.38,'2022-05-21 13:15:08','',''),(2647296,'1','186','940',419,'Retail Sale Id 1639205',360.40,0.00,0.00,0.53,38.69,'2022-05-21 13:16:12','',''),(2647297,'1','186','940',419,'Retail Sale Id 1639207',1999.20,0.00,0.00,2.94,214.62,'2022-05-21 13:17:14','',''),(2647298,'1','186','940',419,'Retail Sale Id 163920