-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_185
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_185`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_185` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_185`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4007 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3374,400314,'',0,'24','1','185','AGO CONSUMPTION','','2021-06-14 14:50:48',5,0.00,0.00,'','178','2021-06-14 14:50:48','178',0,1),(3375,400315,'',0,'24','1','185','PURCHASES','','2021-06-14 14:50:59',5,0.00,0.00,'','178','2021-06-14 14:50:59','178',0,1),(3376,400316,'',0,'24','1','185','FUELING & REPAIR OF OFFICIAL C','','2021-06-14 14:51:09',5,0.00,0.00,'','178','2021-06-14 14:51:09','178',0,1),(3377,400317,'',0,'24','1','185','SALARIES ','','2021-06-14 14:51:21',5,0.00,0.00,'','178','2021-06-14 14:51:21','178',0,1),(3378,400318,'',0,'24','1','185','PUMP AND GENERATOR REPAIRS','','2021-06-14 14:51:35',5,0.00,0.00,'','178','2021-06-14 14:51:35','178',0,1),(3379,400319,'',0,'24','1','185','STATION REPAIRS & MAINTAINANCE','','2021-06-14 14:51:52',5,0.00,0.00,'','178','2021-06-14 14:51:52','178',0,1),(3380,20051,'',0,'20','1','185','SALES','','2021-06-14 14:52:00',5,0.00,0.00,'','178','2021-06-14 14:52:00','178',0,1),(3381,40051,'',0,'6.1','1','185','CASH','','2021-06-14 14:52:30',5,0.00,0.00,'','178','2021-06-14 14:52:30','178',0,1),(3385,400597,'',0,'2','1','185','ACCESS BANK','','2021-06-15 15:45:59',5,0.00,0.00,'','634','2021-06-15 15:45:59','634',0,1),(3386,400598,'',0,'2','1','185','KEYSTONE SURPLUS','','2021-06-15 15:46:09',5,0.00,0.00,'','634','2021-06-15 15:46:09','634',0,1),(3387,400599,'',0,'2','1','185','KEYSTONE POS','','2021-06-15 15:46:17',5,0.00,0.00,'','634','2021-06-15 15:46:17','634',0,1),(3388,400600,'',0,'2','1','185','GTB POS','','2021-06-15 15:47:00',5,0.00,0.00,'','634','2021-06-15 15:47:00','634',0,1),(3401,400603,'',0,'2','1','185','E-BILLS ACCESS 13883535028','','2021-06-16 10:15:33',5,0.00,0.00,'','178','2021-06-16 10:15:33','178',0,1),(3405,400607,'',0,'2','1','185','UBA POS','','2021-06-18 09:55:59',5,0.00,0.00,'','634','2021-06-18 09:55:59','634',0,1),(3431,400622,'',0,'2','1','185','FIDELITY POS','','2021-06-28 08:35:58',5,0.00,0.00,'','634','2021-06-28 08:35:58','634',0,1),(3441,400332,'',0,'24','1','185','INVENTORY VALUE ADJUSTMENT','','2021-07-07 13:39:44',5,0.00,0.00,'','634','2021-07-07 13:39:44','634',0,1),(3442,400333,'',0,'24','1','185','CASH IMPREST','','2021-07-07 13:40:05',5,0.00,0.00,'','634','2021-07-07 13:40:05','634',0,1),(3443,400334,'',0,'24','1','185','COMPUTER REPAIRS & INTERNET SU','','2021-07-07 13:40:13',5,0.00,0.00,'','634','2021-07-07 13:40:13','634',0,1),(3444,400335,'',0,'24','1','185','CLEANING & SANITARY ITEMS','','2021-07-07 13:40:22',5,0.00,0.00,'','634','2021-07-07 13:40:22','634',0,1),(3445,400336,'',0,'24','1','185','DISCOUNT ALLOWED','','2021-07-07 13:40:30',5,0.00,0.00,'','634','2021-07-07 13:40:30','634',0,1),(3446,400337,'',0,'24','1','185','DONATION','','2021-07-07 13:40:43',5,0.00,0.00,'','634','2021-07-07 13:40:43','634',0,1),(3447,400338,'',0,'24','1','185','ELECTRICITY & WATER BILL','','2021-07-07 13:40:54',5,0.00,0.00,'','634','2021-07-07 13:40:54','634',0,1),(3448,400339,'',0,'24','1','185','FEES, FINES & DUES','','2021-07-07 13:41:05',5,0.00,0.00,'','634','2021-07-07 13:41:05','634',0,1),(3449,400340,'',0,'24','1','185','FUELING & REPAIRS OF OFFICIAL ','','2021-07-07 13:41:12',5,0.00,0.00,'','634','2021-07-07 13:41:12','634',0,1),(3450,400341,'',0,'24','1','185','MEDICAL EXPENSES','','2021-07-07 13:41:34',5,0.00,0.00,'','634','2021-07-07 13:41:34','634',0,1),(3451,4041,'',0,'5','1','185','INVENTORY VALUE ADJUSTMENT','','2021-07-07 13:42:52',5,0.00,0.00,'','634','2021-07-07 13:42:52','634',0,1),(3452,400342,'',0,'24','1','185','PUBLIC RELATIONS','','2021-07-08 08:52:50',5,0.00,0.00,'','634','2021-07-08 08:52:50','634',0,1),(3905,40013,'',0,'14','1','185','CASH IMPREST','','2021-11-29 13:18:45',5,0.00,0.00,'','634','2021-11-29 13:18:45','634',0,0),(3999,400701,'',0,'2','1','185','ke','','2021-12-10 12:56:12',5,0.00,0.00,'','634','2021-12-10 12:56:12','634',0,0),(4000,400702,'',0,'2','1','185','SURPLUS KEYSTONE','','2021-12-10 12:56:31',5,0.00,0.00,'','634','2021-12-10 12:56:31','634',0,0),(4001,400703,'',0,'2','1','185','ECO EBILLS','','2022-03-30 11:33:38',5,0.00,0.00,'','634','2022-03-30 11:33:38','634',0,0),(4002,400704,'',0,'2','1','185','ZEN TRANSFER ACC','','2022-05-17 11:15:57',5,0.00,0.00,'','634','2022-05-17 11:15:57','634',0,0),(4003,400705,'',0,'2','1','185','ECO BANK. 2580008123','','2022-05-31 11:18:53',5,0.00,0.00,'','634','2022-05-31 11:18:53','634',0,0),(4004,400706,'',0,'2','1','185','ECO POS','','2022-06-20 09:02:09',5,0.00,0.00,'','634','2022-06-20 09:02:09','634',0,0),(4005,400707,'',0,'2','1','185','ECO BANK ACC 2580011293','','2022-12-02 10:50:24',5,0.00,0.00,'','634','2022-12-02 10:50:24','634',0,0),(4006,400708,'',0,'2','1','185','MONIEPOINT POS','','2023-03-15 12:19:45',5,0.00,0.00,'','634','2023-03-15 12:19:45','634',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=82237 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (79894,'1','185','0000-00-00','2021-07-07 13:44:24',10,'634','','0000-00-00 00:00:00','634','2021-07-07 13:45:22'),(79896,'1','185','0000-00-00','2021-07-07 13:48:41',10,'634','','0000-00-00 00:00:00','634','2021-07-07 13:49:51'),(79904,'1','185','0000-00-00','2021-07-08 08:49:30',10,'634','','0000-00-00 00:00:00','634','2021-07-08 08:53:47'),(79905,'1','185','0000-00-00','2021-07-08 08:51:07',10,'634','','0000-00-00 00:00:00','634','2021-07-08 08:53:53'),(79979,'1','185','0000-00-00','2021-08-04 08:05:47',10,'634','','0000-00-00 00:00:00','634','2021-08-04 08:15:31'),(79980,'1','185','0000-00-00','2021-08-04 08:09:56',10,'634','','0000-00-00 00:00:00','634','2021-08-04 08:15:41'),(80095,'1','185','0000-00-00','2021-09-02 09:38:55',10,'634','','0000-00-00 00:00:00','634','2021-09-02 09:39:51'),(80096,'1','185','0000-00-00','2021-09-02 09:40:51',10,'634','','0000-00-00 00:00:00','634','2021-09-02 09:42:14'),(80332,'1','185','0000-00-00','2021-10-04 08:53:40',10,'634','','0000-00-00 00:00:00','634','2021-10-04 08:58:13'),(80333,'1','185','0000-00-00','2021-10-04 08:55:59',10,'634','','0000-00-00 00:00:00','634','2021-10-04 08:58:31'),(80334,'1','185','0000-00-00','2021-10-04 08:56:44',10,'634','','0000-00-00 00:00:00','634','2021-10-04 08:58:37'),(80335,'1','185','0000-00-00','2021-10-04 08:57:29',10,'634','','0000-00-00 00:00:00','634','2021-10-04 08:58:53'),(81840,'1','185','0000-00-00','2021-12-02 11:27:15',10,'634','','0000-00-00 00:00:00','634','2021-12-02 11:28:16'),(81841,'1','185','0000-00-00','2021-12-02 11:32:11',10,'634','','0000-00-00 00:00:00','634','2021-12-02 11:36:15'),(82084,'1','185','0000-00-00','2021-12-14 09:51:21',10,'633','','0000-00-00 00:00:00','634','2022-01-04 12:30:34'),(82208,'1','185','0000-00-00','2022-01-04 12:31:27',10,'634','','0000-00-00 00:00:00','634','2022-01-04 12:32:14'),(82209,'1','185','0000-00-00','2022-01-04 12:32:44',10,'634','','0000-00-00 00:00:00','634','2022-01-04 12:33:13'),(82216,'1','185','0000-00-00','2022-01-06 10:07:28',10,'634','','0000-00-00 00:00:00','634','2022-01-06 10:11:00'),(82217,'1','185','0000-00-00','2022-02-01 15:03:40',10,'634','','0000-00-00 00:00:00','634','2022-02-01 15:05:29'),(82218,'1','185','0000-00-00','2022-02-01 15:04:52',10,'634','','0000-00-00 00:00:00','634','2022-02-01 15:05:33'),(82222,'1','185','0000-00-00','2022-02-20 11:40:20',10,'633','','0000-00-00 00:00:00','634','2022-03-01 11:15:25'),(82223,'1','185','0000-00-00','2022-02-23 18:07:28',10,'633','','0000-00-00 00:00:00','634','2022-03-01 11:15:49'),(82224,'1','185','0000-00-00','2022-03-01 10:32:43',10,'633','','0000-00-00 00:00:00','634','2022-03-01 11:15:57'),(82225,'1','185','0000-00-00','2022-03-18 14:57:48',10,'634','','0000-00-00 00:00:00','634','2022-03-18 15:05:45'),(82226,'1','185','0000-00-00','2022-04-02 13:43:33',10,'634','','0000-00-00 00:00:00','634','2022-04-02 13:45:47'),(82227,'1','185','0000-00-00','2022-04-02 13:44:45',10,'634','','0000-00-00 00:00:00','634','2022-04-02 13:45:51'),(82230,'1','185','0000-00-00','2022-05-04 12:19:57',10,'634','','0000-00-00 00:00:00','634','2022-05-04 12:22:03'),(82231,'1','185','0000-00-00','2022-05-04 12:20:48',10,'634','','0000-00-00 00:00:00','634','2022-05-04 12:22:08'),(82232,'1','185','0000-00-00','2022-05-24 13:29:35',10,'634','','0000-00-00 00:00:00','634','2022-05-24 13:30:41'),(82233,'1','185','0000-00-00','2022-08-08 10:50:07',10,'634','','0000-00-00 00:00:00','634','2022-08-08 10:51:19'),(82234,'1','185','0000-00-00','2022-09-02 10:10:20',10,'634','','0000-00-00 00:00:00','634','2022-09-02 10:10:52'),(82235,'1','185','0000-00-00','2023-02-06 14:37:51',10,'634','','0000-00-00 00:00:00','634','2023-02-06 14:39:16'),(82236,'1','185','0000-00-00','2023-03-20 11:13:48',10,'634','','0000-00-00 00:00:00','634','2023-03-20 11:15:05');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=173654 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (168214,'1','185','79894','3451','5',0.00,'AGO INCREMENT FROM 280 TO 290, DIPPING 6,800',68000.00,'2021-06-23'),(168215,'1','185','79894','228','supplier',68000.00,'AGO INCREMENT FROM 280 TO 290, DIPPING 6,800',0.00,'2021-06-23'),(168218,'1','185','79896','228','supplier',0.00,'AGO CONSUMPTION FOR THE MONTH OF JUNE',255000.00,'2021-06-30'),(168219,'1','185','79896','3451','5',255000.00,'AGO CONSUMPTION FOR THE MONTH OF JUNE',0.00,'2021-06-30'),(168234,'1','185','79904','228','supplier',0.00,'DISCOUNT ON AGO',3000.00,'2021-06-30'),(168235,'1','185','79904','3445','24',3000.00,'DISCOUNT ON AGO',0.00,'2021-06-30'),(168236,'1','185','79905','228','supplier',0.00,'66.3 LTRS OF PMS GIVEN TO DPR STAFF IN THE MONTH OF JUNE ',10806.90,'2021-06-30'),(168237,'1','185','79905','3452','24',10806.90,'66.3 LTRS OF PMS GIVEN TO DPR STAFF IN THE MONTH OF JUNE ',0.00,'2021-06-30'),(168391,'1','185','79979','3451','5',0.00,'AGO INCREMENT FROM 290 TO 295 DIPPING   5,400.00 ',27000.00,'2021-07-19'),(168392,'1','185','79979','228','supplier',27000.00,'AGO INCREMENT FROM 290 TO 295 DIPPING   5,400.00 ',0.00,'2021-07-19'),(168393,'1','185','79980','228','supplier',0.00,'AGO CONSUMPTION FOR THE MONTH OF JULY',351500.00,'2021-07-30'),(168394,'1','185','79980','3374','24',351500.00,'AGO CONSUMPTION FOR THE MONTH OF JULY',0.00,'2021-07-30'),(168630,'1','185','80095','228','supplier',0.00,'DECREMENT OF AGO FROM 295 TO 290 DIPPING   8,000.00 ',40000.00,'2021-08-24'),(168631,'1','185','80095','3451','5',40000.00,'DECREMENT OF AGO FROM 295 TO 290 DIPPING   8,000.00 ',0.00,'2021-08-24'),(168632,'1','185','80096','228','supplier',0.00,'AGO CONSUMPTION FOR THE MONTH OF AUGUST',383500.00,'2021-08-31'),(168633,'1','185','80096','3374','24',383500.00,'AGO CONSUMPTION FOR THE MONTH OF AUGUST',0.00,'2021-08-31'),(169161,'1','185','80332','228','supplier',0.00,'AGO CONSUMPTION FOR THE MONTH OF SEPTEMBER',350000.00,'2021-09-30'),(169162,'1','185','80332','3374','24',350000.00,'AGO CONSUMPTION FOR THE MONTH OF SEPTEMBER',0.00,'2021-09-30'),(169163,'1','185','80333','3451','5',0.00,'PRICE INCREMENT',124000.00,'2021-09-17'),(169164,'1','185','80333','228','supplier',124000.00,'PRICE INCREMENT',0.00,'2021-09-17'),(169165,'1','185','80334','3451','5',0.00,'PRICE INCREMENT',68000.00,'2021-09-21'),(169166,'1','185','80334','228','supplier',68000.00,'PRICE INCREMENT',0.00,'2021-09-21'),(169167,'1','185','80335','3451','5',0.00,'PRICE INCREMENT',29000.00,'2021-09-28'),(169168,'1','185','80335','228','supplier',29000.00,'PRICE INCREMENT',0.00,'2021-09-28'),(172682,'1','185','81840','228','supplier',0.00,'AGO CONSUMPTION FOR NOVEMBER',350000.00,'2021-11-30'),(172683,'1','185','81840','3374','24',350000.00,'AGO CONSUMPTION FOR NOVEMBER',0.00,'2021-11-30'),(172685,'1','185','81841','3451','5',0.00,'INCREMENT ON PMS   26,500.00 *2 AND  AGO 15,200*10 & 750*5',208750.00,'2021-10-31'),(172686,'1','185','81841','228','supplier',208750.00,'INCREMENT ON PMS   26,500.00 *2 AND  AGO 15,200*10 & 750*5',0.00,'2021-10-31'),(172687,'1','185','81841','228','supplier',0.00,'DECREMENT FROM 320 TO 310 14,000',140000.00,'2021-10-31'),(172688,'1','185','81841','3451','5',140000.00,'DECREMENT FROM 320 TO 310 14,000',0.00,'2021-10-31'),(173280,'1','185','82084','228','supplier',0.00,'AGO CONSUMPTION OF 500LTRS @350 175000',175000.00,'2021-12-02'),(173283,'1','185','82084','3374','24',175000.00,'AGO CONSUMPTION OF 500LTRS @350 175000',0.00,'2021-12-02'),(173586,'1','185','82208','228','supplier',0.00,'AGO CONSUMPTION 300 @350',105000.00,'2021-12-23'),(173587,'1','185','82208','3374','24',105000.00,'AGO CONSUMPTION 300 @350',0.00,'2021-12-23'),(173588,'1','185','82209','228','supplier',0.00,'DECREMENT FROM 350 TO 345 ',18000.00,'2021-12-29'),(173589,'1','185','82209','3451','5',18000.00,'DECREMENT FROM 350 TO 345',0.00,'2021-12-29'),(173606,'1','185','82216','4127','customer',222525.00,'MISTAKE OF LTRS TO SHAARTAKE PROPERTIES AT 345',0.00,'2022-01-05'),(173607,'1','185','82216','3380','20',0.00,'MISTAKE OF LTRS TO SHAARTAKE PROPERTIES AT 345',222525.00,'2022-01-05'),(173608,'1','185','82217','228','supplier',0.00,'AGO CONSUMPTION FOR JANUARY 2022',331000.00,'2022-01-31'),(173609,'1','185','82217','3374','24',331000.00,'AGO CONSUMPTION FOR JANUARY 2022',0.00,'2022-01-31'),(173610,'1','185','82218','3451','5',0.00,'INCREMENT OF THE MONTH JANUARY, 2022',375750.00,'2022-01-31'),(173611,'1','185','82218','228','supplier',375750.00,'INCREMENT OF THE MONTH JANUARY, 2022',0.00,'2022-01-31'),(173618,'1','185','82222','228','supplier',0.00,'AGO CONSUMPTION 800LTRS',292000.00,'2022-02-01'),(173619,'1','185','82222','3374','24',292000.00,'AGO CONSUMPTION 800LTRS',0.00,'2022-02-01'),(173620,'1','185','82223','3451','5',0.00,'AGO INCREMENT FROM 365 TO 380 WITH 4,400 AS DIPPING',66000.00,'2022-02-04'),(173622,'1','185','82223','228','supplier',66000.00,'AGO INCREMENT FROM 365 TO 380 WITH 4,400 AS DIPPING',0.00,'2022-02-04'),(173623,'1','185','82223','3451','5',0.00,'AGO INCREMENT FROM 380 TO 390 WITH 11,600 AS DIPPING',116000.00,'2022-02-09'),(173624,'1','185','82223','228','supplier',116000.00,'AGO INCREMENT FROM 380 TO 390 WITH 11,600 AS DIPPING',0.00,'2022-02-09'),(173625,'1','185','82223','3451','5',0.00,'AGO INCREMENT FROM 390 TO 410 WITH 14,200 AS DIPPING',284000.00,'2022-02-12'),(173626,'1','185','82223','228','supplier',284000.00,'AGO INCREMENT FROM 390 TO 410 WITH 14,200 AS DIPPING',0.00,'2022-02-12'),(173627,'1','185','82224','3451','5',0.00,'AGO INCREMENT FROM 410 TO 420 WITH 20,400 AS DIPPING',204000.00,'2022-02-25'),(173628,'1','185','82224','228','supplier',204000.00,'AGO INCREMENT FROM 410 TO 420 WITH 20,400 AS DIPPING',0.00,'2022-02-25'),(173629,'1','185','82225','4128','customer',989854.75,'Reversal of Credit Sales for 6,035.70 Litres of Petrol from shift 257697 on 2022-03-17 12:19:37',0.00,'2022-03-17'),(173630,'1','185','82225','3380','20',0.00,'Reversal of Credit Sales for 6,035.70 Litres of Petrol from shift 257697 on 2022-03-17 12:19:37',989854.75,'2022-03-17'),(173631,'1','185','82226','228','supplier',0.00,'AGO CONSUMPTION FOR MARCH2022',597000.00,'2022-03-31'),(173632,'1','185','82226','3374','24',597000.00,'AGO CONSUMPTION FOR MARCH2022',0.00,'2022-03-31'),(173633,'1','185','82227','3451','5',0.00,'AGO INCREMENT SUMMATION FROM 430 TO 680',2756500.00,'2022-03-31'),(173635,'1','185','82227','228','supplier',2756500.00,'AGO INCREMENT SUMMATION FROM 430 TO 680',0.00,'2022-03-31'),(173640,'1','185','82230','228','supplier',0.00,'AGO CONSUMPTION FOR THE MONTH OF APRIL',718000.00,'2022-04-30'),(173641,'1','185','82230','3374','24',718000.00,'AGO CONSUMPTION FOR THE MONTH OF APRIL',0.00,'2022-04-30'),(173642,'1','185','82231','228','supplier',0.00,'DECREMENT FOR THE MONTH OF APRIL',328000.00,'2022-04-30'),(173643,'1','185','82231','3451','5',328000.00,'DECREMENT FOR THE MONTH OF APRIL',0.00,'2022-04-30'),(173644,'1','185','82232','4129','customer',0.00,'WRONG ENTRY OF 71.65 LTRS OF PMS ',11822.25,'2022-05-23'),(173645,'1','185','82232','4128','customer',11822.25,'WRONG ENTRY OF 71.65 LTRS OF PMS ',0.00,'2022-05-23'),(173646,'1','185','82233','4128','customer',0.00,'CREDIT SALES OF 7TH AUGUST',9718.00,'2022-08-07'),(173647,'1','185','82233','3380','20',9718.00,'CREDIT SALES OF 7TH AUGUST',0.00,'2022-08-07'),(173648,'1','185','82234','4129','customer',0.00,'27 LTRS PMS @ 185 ',4995.00,'2022-09-01'),(173649,'1','185','82234','3380','20',4995.00,'27 LTRS PMS @ 185 ',0.00,'2022-09-01'),(173650,'1','185','82235','4128','customer',0.00,'MISSING ENTRY OF 351 LTRS OF PMS',70200.00,'2023-02-05'),(173651,'1','185','82235','3380','20',70200.00,'MISSING ENTRY OF 351 LTRS OF PMS',0.00,'2023-02-05'),(173652,'1','185','82236','4133','customer',0.00,'MISSING ENTRY OF PMS instead of AGO 270 ltrs',167400.00,'2023-03-09'),(173653,'1','185','82236','3380','20',167400.00,'MISSING ENTRY OF PMS instead of AGO 270 ltrs',0.00,'2023-03-09');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46112 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
INSERT INTO `accounts_vouchers` VALUES (46111,'1','185','2021-10-23','','3442',0.00,'2021-10-23 09:00:50',0,'178','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=83302 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (83301,'1','185',46111,3444,'5 SACHET OFDETERGENT',2000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4135 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3630,'','1','185','DRIVER SHORTAGE','UMAR TRANSPORT','08030647174','drivershor@aarano.ng','KADUNA','KADUNA STATE','KADUNA 4','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-30 10:29:27',5,'634','2021-10-30 10:29:27','634'),(3864,'','1','185','Bajaj Boxer Confirm Full tank ','AA RANO NIG.','08035450199','mrmohasul@gmail.com','KANO','KANO STATE','HEAD OFFICE','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-27 12:55:49',0,'634','2021-11-27 12:55:49','634'),(4127,'','1','185','SHARTAKE PROPERTIES','HAMZA ABDULLAHI','07030446617','adamabdulsarki@gmail.com','kaduna','kaduna state','kaduna','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-12-31 15:56:28',5,'634','2022-06-09 16:18:50','634'),(4128,'','1','185','EFCC','MUHAMMAD ABDUL SULE','08035450199','mrmohasul@gmail.com','KADUNA ','KADUNA STATE','KADUNA STATE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-02-21 09:08:55',5,'634','2022-02-21 09:08:55','634'),(4129,'','1','185','RONCHESS GLOBAL RESOURCES','ABDULSAMAD MIKAIL','234 803 618 8926','mikailuabdulsamad@gmail.com','KADUNA ','KADUNA STATE','KADUNA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-03-02 14:38:47',5,'634','2022-06-10 16:42:40','634'),(4130,'','1','185','AL-ITQAAN ACADEMY','ABUBAKAR ISA DOMA','08030523051','alitqaanacademy16@yahoo.com','KADUNA ','KADUNA STATE','PLOT 5 ISA KAITA ROAD, MALALI GRA KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-20 11:14:17',5,'634','2022-06-10 18:02:51','634'),(4131,'','1','185','KADUNA ELECTRIC KAWO','AREA MANAGER','08033050140, 08036254090','areolahadizan@gmail.com','KADUNA','KADUNA STATE','ABUJA ROAD','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-09 16:15:35',5,'634','2022-11-17 15:22:00','634'),(4132,'','1','185','ARTEK ACADEMY','MR AROME A A','08029108669','artekacademy@gmail.com','KADUNA','KADUNA STATE','15 ISA KAITA ROAD, MALALI GRA KADUNA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 14:16:15',5,'634','2022-07-21 14:16:15','634'),(4133,'','1','185','GOLDEN ACRES','ALH. SANI TAHIR','08092778647','sanitahir21@gmail.com','KADUNA ','KADUNA STATE','MILLENIUM CITY KADUNA ','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-01-23 12:24:43',5,'634','2023-01-26 17:53:55','634'),(4134,'','1','185','NIGERIA POLICE FORCE (ELECTION','YUSUF C USMAN','08071785115','dopstransport@gmail.com','KADUNA','KADUNA STATE','ABUJA','Nigeria',0.00,0.00,0.00,'0000-00-00','2023-02-20 15:04:52',5,'634','2023-02-20 15:04:52','634');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
INSERT INTO `customers_status` VALUES (1,'1','185','3864',0,'CLOSED','2022-06-09 16:19:02');
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18536 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','185',15936,'936',6968.74,8400.00,'2021-08-02','New Tank Dipping','2021-08-02 14:02:40','633','633',2021,'633','2021-08-02 14:02:40',5),('1','185',16899,'935',90955.96,5.00,'2021-10-24','there is error in the tanks reading','2021-10-24 14:01:23','633','633',2021,'633','2021-10-24 14:01:23',5),('1','185',17105,'936',3159.35,45000.00,'2021-10-29','5000','2021-10-29 06:36:00','633','633',2021,'633','2021-10-29 06:36:00',5),('1','185',17207,'935',68951.11,37500.00,'2021-10-30','','2021-10-30 10:41:56','634','634',2021,'634','2021-10-30 10:41:56',5),('1','185',17208,'936',38635.79,600.00,'2021-10-30','','2021-10-30 10:42:28','634','634',2021,'634','2021-10-30 10:42:28',5),('1','185',17209,'937',579.10,650.00,'2021-10-30','','2021-10-30 10:42:44','634','634',2021,'634','2021-10-30 10:42:44',5),('1','185',17554,'935',14405.72,21000.00,'2021-11-09','','2021-11-09 14:04:08','634','634',2021,'634','2021-11-09 14:04:08',5),('1','185',17891,'936',753.46,9500.00,'2021-12-02','','2021-12-02 13:57:00','634','634',2021,'634','2021-12-02 13:57:00',5),('1','185',17913,'936',1709.66,40000.00,'2021-12-05','','2021-12-05 14:33:15','634','634',2021,'634','2021-12-05 14:33:15',5),('1','185',17914,'936',40000.00,41780.00,'2021-12-05','','2021-12-05 14:34:03','634','634',2021,'634','2021-12-05 14:34:03',5),('1','185',17922,'936',5655.00,10000.00,'2021-12-07','','2021-12-07 14:27:26','634','634',2021,'634','2021-12-07 14:27:26',5),('1','185',17957,'937',413.62,2000.00,'2021-12-09','','2021-12-09 14:08:26','634','634',2021,'634','2021-12-09 14:08:26',5),('1','185',18427,'936',5002.14,15100.00,'2022-01-12','','2022-01-12 15:01:07','634','634',2022,'634','2022-01-12 15:01:07',5),('1','185',18504,'937',634.44,2500.00,'2022-01-19','','2022-01-19 14:27:08','634','634',2022,'634','2022-01-19 14:27:08',5),('1','185',18505,'935',6560.76,10500.00,'2022-01-31','','2022-01-31 08:32:24','634','634',2022,'634','2022-01-31 08:32:24',5),('1','185',18506,'936',9662.57,20000.00,'2022-02-28','','2022-02-28 09:01:18','634','634',2022,'634','2022-02-28 09:01:18',5),('1','185',18507,'937',956.34,3000.00,'2022-03-03','','2022-03-03 07:45:07','634','634',2022,'634','2022-03-03 07:45:07',5),('1','185',18508,'936',9117.27,15790.00,'2022-03-07','','2022-03-07 08:03:50','634','634',2022,'634','2022-03-07 08:03:50',5),('1','185',18509,'936',1922.97,16550.00,'2022-03-07','','2022-03-07 09:45:51','634','634',2022,'634','2022-03-07 09:45:51',5),('1','185',18510,'936',1441.15,3144.00,'2022-03-14','','2022-03-14 10:44:36','634','634',2022,'634','2022-03-14 10:44:36',5),('1','185',18511,'936',32196.29,46000.00,'2022-03-16','','2022-03-16 17:50:22','634','634',2022,'634','2022-03-16 17:50:22',5),('1','185',18512,'936',11000.00,17000.00,'2022-03-16','','2022-03-16 17:51:47','634','634',2022,'634','2022-03-16 17:51:47',5),('1','185',18513,'936',1000.00,32196.00,'2022-03-16','','2022-03-16 17:53:01','634','634',2022,'634','2022-03-16 17:53:01',5),('1','185',18514,'937',36.82,600.00,'2022-05-12','For Shift to close','2022-05-12 15:52:20','559','559',2022,'559','2022-05-12 15:52:20',5),('1','185',18515,'935',57692.26,14700.00,'2022-06-08','','2022-06-08 08:59:02','634','634',2022,'634','2022-06-08 08:59:02',5),('1','185',18516,'936',9799.66,7700.00,'2022-06-08','','2022-06-08 08:59:18','634','634',2022,'634','2022-06-08 08:59:18',5),('1','185',18517,'937',3505.54,4800.00,'2022-06-08','','2022-06-08 08:59:35','634','634',2022,'634','2022-06-08 08:59:35',5),('1','185',18518,'937',2229.17,3700.00,'2022-07-20','','2022-07-20 07:55:35','634','634',2022,'634','2022-07-20 07:55:35',5),('1','185',18519,'937',1081.89,1400.00,'2022-07-20','','2022-07-20 15:50:17','634','634',2022,'634','2022-07-20 15:50:17',5),('1','185',18520,'937',80.79,2000.00,'2022-07-22','','2022-07-22 08:16:05','634','634',2022,'634','2022-07-22 08:16:05',5),('1','185',18521,'936',14592.42,15200.00,'2022-08-03','','2022-08-03 07:19:21','634','634',2022,'634','2022-08-03 07:19:21',5),('1','185',18522,'936',14566.66,18400.00,'2022-08-06','','2022-08-06 16:53:10','634','634',2022,'634','2022-08-06 16:53:10',5),('1','185',18523,'937',93.03,1000.00,'2022-09-27','','2022-09-27 07:31:34','634','634',2022,'634','2022-09-27 07:31:34',5),('1','185',18524,'937',292.59,400.00,'2022-10-07','For Shift to close','2022-10-07 17:48:15','559','559',2022,'559','2022-10-07 17:48:15',5),('1','185',18525,'937',986.17,1500.00,'2022-11-12','For Shift to close','2022-11-12 07:22:33','559','559',2022,'559','2022-11-12 07:22:33',5),('1','185',18526,'937',2481.08,3800.00,'2022-11-25','For Shift to close','2022-11-25 18:48:15','559','559',2022,'559','2022-11-25 18:48:15',5),('1','185',18527,'936',24438.47,45000.00,'2023-01-05','','2023-01-05 19:13:40','634','634',2023,'634','2023-01-05 19:13:40',5),('1','185',18528,'935',92572.70,2000.00,'2023-01-05','','2023-01-05 19:13:58','634','634',2023,'634','2023-01-05 19:13:58',5),('1','185',18529,'937',1299.59,2800.00,'2023-03-09','for shift to close','2023-03-09 19:10:37','559','559',2023,'559','2023-03-09 19:10:37',5),('1','185',18530,'936',30122.63,4500.00,'2023-03-20','For Shift to close','2023-03-20 07:19:44','559','559',2023,'559','2023-03-20 07:19:44',5),('1','185',18531,'937',1215.03,2000.00,'2023-03-20','For Shift to close','2023-03-20 07:22:45','559','559',2023,'559','2023-03-20 07:22:45',5),('1','185',18532,'936',4500.00,14500.00,'2023-03-20','For Shift to close','2023-03-20 07:33:42','559','559',2023,'559','2023-03-20 07:33:42',5),('1','185',18533,'935',10012.23,21000.00,'2023-03-20','','2023-03-20 11:18:57','634','634',2023,'634','2023-03-20 11:18:57',5),('1','185',18534,'936',14500.00,20000.00,'2023-03-20','','2023-03-20 11:19:11','634','634',2023,'634','2023-03-20 11:19:11',5),('1','185',18535,'937',2000.00,2500.00,'2023-03-20','','2023-03-20 11:20:02','634','634',2023,'634','2023-03-20 11:20:02',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2760 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','185','935',2744,'5','PUMP 1',686111.15,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-30 06:25:01','633'),('1','185','935',2745,'5','PUMP 2',979594.21,'DISPENSING PMS','',NULL,NULL,'',5,'2022-11-12 19:02:33','633'),('1','185','935',2746,'5','PUMP 3',964525.84,'DISPENSING PMS','',NULL,NULL,'',5,'2022-11-12 19:05:20','633'),('1','185','935',2747,'5','PUMP 4',1642877.66,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-02 07:49:45','633'),('1','185','935',2748,'5','PUMP 5',1403381.52,'DISPENSING PMS','',NULL,NULL,'',5,'2022-10-05 07:48:26','633'),('1','185','935',2749,'5','PUMP 6',737412.84,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-15 15:46:30','633'),('1','185','936',2750,'5','PUMP 7',1830343.73,'DISPENSING PMS','',NULL,NULL,'',5,'2021-06-14 14:45:01','178'),('1','185','936',2751,'5','PUMP 8',1074152.61,'DISPENSING PMS','',NULL,NULL,'',5,'2022-09-21 08:34:55','633'),('1','185','936',2752,'5','PUMP 9',2147021.84,'DISPENSING PMS','',NULL,NULL,'',5,'2021-06-14 14:45:41','178'),('1','185','936',2753,'5','PUMP 10',1289989.08,'DISPENSING PMS','',NULL,NULL,'',5,'2022-01-24 14:29:33','633'),('1','185','936',2754,'5','PUMP 11',2103191.11,'DISPENSING PMS','',NULL,NULL,'',5,'2021-12-04 04:57:13','633'),('1','185','936',2755,'5','PUMP 12',1243134.91,'DISPENSING PMS','',NULL,NULL,'',5,'2022-02-04 14:43:38','633'),('1','185','937',2756,'5','AGO PUMP 1',702353.74,'DISPENSING AGO','',NULL,NULL,'',5,'2022-04-30 14:34:45','633'),('1','185','937',2757,'5','AGO PUMP 2',803359.41,'DISPENSING AGO','',NULL,NULL,'',5,'2022-12-17 14:53:33','633'),('1','185','938',2758,'5','DPK PUMP 1',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','185','938',2759,'5','DPK PUMP 2',0.00,'DISPENSING DPK',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258347 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','185',204072,'OPENING DAY','2021-06-11','2021-06-11 00:00:00',NULL,'633',0.00,4110351.97,'633','2021-06-15 12:32:08','559','2021-06-15 15:34:30',10,0),('1','185',204123,'DAY2 ','2021-06-12','2021-06-12 00:00:00',NULL,'633',6032799.33,6032799.33,'633','2021-06-15 15:45:31','559','2021-06-15 15:49:20',10,0),('1','185',204125,'DAY3','2021-06-13','2021-06-13 00:00:00',NULL,'633',6065776.52,6065776.52,'633','2021-06-15 15:58:11','559','2021-06-15 15:59:51',10,0),('1','185',204131,'DAY4','2021-06-14','2021-06-14 00:00:00',NULL,'633',6540997.61,6540997.61,'633','2021-06-15 16:15:10','559','2021-06-15 16:20:28',10,0),('1','185',204134,'DAY5','2021-06-15','2021-06-15 00:00:00',NULL,'633',6080942.12,6080942.12,'633','2021-06-16 10:58:50','559','2021-06-16 12:35:54',10,0),('1','185',204314,'DAY 6','2021-06-16','2021-06-16 00:00:00',NULL,'633',6327883.70,6327883.70,'633','2021-06-17 10:00:01','559','2021-06-17 11:09:37',10,0),('1','185',204556,'DAY 7','2021-06-17','2021-06-17 00:00:00',NULL,'633',5656923.63,5656923.63,'633','2021-06-18 09:39:52','559','2021-06-18 09:54:50',10,0),('1','185',204690,'DAY 8','2021-06-18','2021-06-18 00:00:00',NULL,'633',5789973.72,5789973.72,'633','2021-06-19 09:23:12','559','2021-06-19 09:40:28',10,0),('1','185',204899,'DAY 8','2021-06-19','2021-06-19 00:00:00',NULL,'633',5562179.65,5562179.65,'633','2021-06-20 09:04:13','559','2021-06-20 09:09:53',10,0),('1','185',205094,'DAY 10','2021-06-20','2021-06-20 00:00:00',NULL,'633',6292670.07,6292670.07,'633','2021-06-21 08:46:26','559','2021-06-21 08:51:26',10,0),('1','185',205294,'DAY 11','2021-06-21','2021-06-21 00:00:00',NULL,'633',5972889.34,5972889.34,'633','2021-06-22 12:49:49','559','2021-06-22 12:52:50',10,0),('1','185',205600,'DAY 12','2021-06-22','2021-06-22 00:00:00',NULL,'633',5770511.57,5770511.57,'633','2021-06-23 11:45:44','559','2021-06-23 12:19:26',10,0),('1','185',205841,'DAY 13','2021-06-23','2021-06-23 00:00:00',NULL,'633',6232280.30,6272378.00,'633','2021-06-24 10:03:57','559','2021-06-24 10:15:47',10,0),('1','185',206020,'DAY 14','2021-06-24','2021-06-24 00:00:00',NULL,'633',6389667.97,6389667.97,'633','2021-06-25 08:13:09','559','2021-06-25 08:13:57',10,0),('1','185',206195,'MORNING','2021-06-25','2021-06-25 00:00:00',NULL,'633',2778986.44,2778986.44,'633','2021-06-25 16:13:57','559','2021-06-25 16:16:29',10,0),('1','185',206312,'AFTERNOON','2021-06-25','2021-06-25 00:00:00',NULL,'633',3509468.39,3509468.39,'633','2021-06-26 09:48:10','559','2021-06-26 09:52:23',10,0),('1','185',206424,'MORNING','2021-06-26','2021-06-26 00:00:00',NULL,'633',2219986.52,2219986.52,'633','2021-06-26 18:39:18','559','2021-06-26 18:43:37',10,0),('1','185',206531,'AFTERNOON','2021-06-26','2021-06-26 00:00:00',NULL,'633',3244387.01,3244387.01,'633','2021-06-27 09:21:24','559','2021-06-27 10:05:22',10,0),('1','185',206635,'MORNING','2021-06-27','2021-06-27 00:00:00',NULL,'633',3098448.88,3098448.88,'633','2021-06-27 15:52:51','559','2021-06-27 16:04:48',10,0),('1','185',206734,'AFTERNOON','2021-06-27','2021-06-27 00:00:00',NULL,'633',3353740.39,3353740.39,'633','2021-06-28 07:50:33','559','2021-06-28 07:53:23',10,0),('1','185',206846,'MORNING','2021-06-28','2021-06-28 00:00:00',NULL,'633',3049005.91,3049005.91,'633','2021-06-28 15:27:46','559','2021-06-28 15:29:31',10,0),('1','185',206975,'AFTERNOON','2021-06-28','2021-06-28 00:00:00',NULL,'633',4038633.19,4038633.19,'633','2021-06-29 08:50:01','559','2021-06-29 09:03:44',10,0),('1','185',207094,'MORNING','2021-06-29','2021-06-29 00:00:00',NULL,'633',3221393.41,3221393.41,'633','2021-06-29 14:51:51','559','2021-06-29 14:54:05',10,0),('1','185',207277,'AFTERNOON','2021-06-29','2021-06-29 00:00:00',NULL,'633',3369597.19,3369597.19,'633','2021-06-30 08:45:16','559','2021-06-30 09:23:22',10,0),('1','185',207340,'MORNING','2021-06-30','2021-06-30 00:00:00',NULL,'633',2622038.43,2622038.43,'633','2021-07-01 09:06:43','559','2021-07-01 09:14:24',10,0),('1','185',207535,'AFTERNOON SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'633',3551537.04,832830.70,'633','2021-07-01 10:20:56','559','2021-07-01 10:32:54',10,0),('1','185',207620,'Afternoon shift PMS ONLY','2021-06-30','2021-06-30 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',207648,'MORNING','2021-07-01','2021-07-01 00:00:00',NULL,'633',2651173.79,2651173.79,'633','2021-07-01 16:53:06','559','2021-07-01 17:00:06',10,0),('1','185',207651,'AFTERNOON','2021-07-01','2021-07-01 00:00:00',NULL,'633',3393497.56,3393497.56,'633','2021-07-02 08:47:17','559','2021-07-02 11:26:10',10,0),('1','185',207865,'AFTERNOON','2021-07-02','2021-07-02 00:00:00',NULL,'633',3271514.74,3271514.74,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',207870,'MORNING','2021-07-02','2021-07-02 00:00:00',NULL,'633',3271514.74,3271514.74,'633','2021-07-02 18:34:45','559','2021-07-02 18:47:35',10,0),('1','185',207872,'AFTERNOON','2021-07-02','2021-07-02 00:00:00',NULL,'633',3704407.08,3704407.08,'633','2021-07-03 10:26:33','559','2021-07-03 10:30:55',10,0),('1','185',207992,'MORNING','2021-07-03','2021-07-03 00:00:00',NULL,'633',2874926.54,2874926.54,'633','2021-07-03 15:20:18','559','2021-07-03 15:37:37',10,0),('1','185',208146,'AFTERNOON','2021-07-03','2021-07-03 00:00:00',NULL,'633',4377353.89,4377353.89,'633','2021-07-04 09:52:05','559','2021-07-04 09:58:00',10,0),('1','185',208191,'MORNING','2021-07-04','2021-07-04 00:00:00',NULL,'633',2971581.20,2971581.20,'633','2021-07-05 09:04:32','559','2021-07-05 09:06:31',10,0),('1','185',208399,'AFTERNOON','2021-07-04','2021-07-04 00:00:00',NULL,'633',3622041.27,3622041.27,'633','2021-07-05 09:20:46','559','2021-07-05 09:23:15',10,0),('1','185',208411,'MORNING','2021-07-05','2021-07-05 00:00:00',NULL,'633',2847742.91,2847742.91,'633','2021-07-06 08:11:48','559','2021-07-06 08:15:23',10,0),('1','185',208586,'AFTERNOON','2021-07-05','2021-07-05 00:00:00',NULL,'633',4727304.82,4727304.82,'633','2021-07-06 08:23:11','559','2021-07-06 08:47:41',10,0),('1','185',208608,'MORNING','2021-07-06','2021-07-06 00:00:00',NULL,'633',2818656.74,2818656.74,'633','2021-07-06 15:01:27','559','2021-07-06 15:17:01',10,0),('1','185',208708,'AFTERNOON','2021-07-06','2021-07-06 00:00:00',NULL,'633',3188503.29,3188503.29,'633','2021-07-07 08:32:48','559','2021-07-07 08:45:14',10,0),('1','185',208828,'MORNING','2021-07-07','2021-07-07 00:00:00',NULL,'633',3203866.63,3203866.63,'633','2021-07-07 14:45:52','559','2021-07-07 14:48:56',10,0),('1','185',208933,'AFTERNOON','2021-07-07','2021-07-07 00:00:00',NULL,'633',3092318.25,3092318.25,'633','2021-07-08 08:36:04','559','2021-07-08 08:39:59',10,0),('1','185',209064,'MORNING','2021-07-08','2021-07-08 00:00:00',NULL,'633',2937442.71,2937442.71,'633','2021-07-08 14:40:46','559','2021-07-08 14:43:24',10,0),('1','185',209142,'AFTERNOON','2021-07-08','2021-07-08 00:00:00',NULL,'633',3147438.74,3147438.74,'633','2021-07-09 08:31:12','559','2021-07-09 08:41:30',10,0),('1','185',209272,'MORNING','2021-07-09','2021-07-09 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',209368,'MORNING','2021-07-09','2021-07-09 00:00:00',NULL,'633',2796084.83,2796084.83,'633','2021-07-09 17:36:52','559','2021-07-09 18:41:37',10,0),('1','185',209475,'MORNING','2021-07-10','2021-07-10 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',209480,'AFTERNOON','2021-07-09','2021-07-09 00:00:00',NULL,'633',3445255.26,3445255.26,'633','2021-07-10 08:28:30','559','2021-07-10 08:34:48',10,0),('1','185',209489,'MORNING','2021-07-10','2021-07-10 00:00:00',NULL,'633',3095082.75,3095082.75,'633','2021-07-10 16:31:38','559','2021-07-10 19:06:31',10,0),('1','185',209699,'AFTERNOON','2021-07-10','2021-07-10 00:00:00',NULL,'633',3377055.88,3377055.88,'633','2021-07-11 10:18:58','559','2021-07-11 12:21:29',10,0),('1','185',209801,'MORNING','2021-07-11','2021-07-11 00:00:00',NULL,'633',2838740.82,2838740.82,'633','2021-07-11 17:03:15','559','2021-07-11 17:06:38',10,0),('1','185',209814,'AFTERNOON','2021-07-11','2021-07-11 00:00:00',NULL,'633',2899980.20,2899980.20,'633','2021-07-12 09:26:44','559','2021-07-12 09:35:39',10,0),('1','185',209940,'MORNING','2021-07-12','2021-07-12 00:00:00',NULL,'633',2598302.72,2598302.72,'633','2021-07-12 15:19:22','559','2021-07-12 15:26:32',10,0),('1','185',210054,'AFTERNOON','2021-07-12','2021-07-12 00:00:00',NULL,'633',3038448.15,3038448.15,'633','2021-07-13 08:52:10','559','2021-07-13 08:58:18',10,0),('1','185',210166,'MORNING','2021-07-13','2021-07-13 00:00:00',NULL,'633',2822128.67,2822128.67,'633','2021-07-13 16:27:02','559','2021-07-13 16:35:42',10,0),('1','185',210351,'AFTERNOON','2021-07-13','2021-07-13 00:00:00',NULL,'633',3565114.62,3565114.62,'633','2021-07-14 09:19:21','559','2021-07-14 09:42:08',10,0),('1','185',210390,'MORNING','2021-07-14','2021-07-14 00:00:00',NULL,'633',3042977.10,3042977.10,'633','2021-07-14 15:58:14','559','2021-07-14 16:17:24',10,0),('1','185',210472,'AFTERNOON','2021-07-14','2021-07-14 00:00:00',NULL,'633',3515770.28,3515770.28,'633','2021-07-15 13:36:24','559','2021-07-15 13:40:35',10,0),('1','185',210655,'MORNING','2021-07-15','2021-07-15 00:00:00',NULL,'633',3016909.07,3016909.07,'633','2021-07-16 08:55:15','559','2021-07-16 08:59:44',10,0),('1','185',210786,'AFTERNOON','2021-07-15','2021-07-15 00:00:00',NULL,'633',3359426.30,3359426.30,'633','2021-07-16 09:16:16','559','2021-07-16 09:26:51',10,0),('1','185',210804,'MORNING','2021-07-16','2021-07-16 00:00:00',NULL,'633',2747648.76,2747648.76,'633','2021-07-16 22:43:49','559','2021-07-17 06:46:24',10,0),('1','185',211015,'AFTERNOON','2021-07-16','2021-07-16 00:00:00',NULL,'633',3507220.09,3507220.09,'633','2021-07-17 09:32:41','559','2021-07-17 14:45:56',10,0),('1','185',211118,'MORNING','2021-07-17','2021-07-17 00:00:00',NULL,'633',3001247.26,3001247.26,'633','2021-07-17 16:46:10','559','2021-07-17 20:03:20',10,0),('1','185',211207,'AFTERNOON','2021-07-17','2021-07-17 00:00:00',NULL,'633',4297944.34,4297944.34,'633','2021-07-18 11:08:51','559','2021-07-18 15:28:10',10,0),('1','185',211312,'MORNING','2021-07-18','2021-07-18 00:00:00',NULL,'633',3303429.19,3303429.19,'633','2021-07-18 16:22:32','559','2021-07-19 07:44:09',10,0),('1','185',211435,'AFTERNOON','2021-07-18','2021-07-18 00:00:00',NULL,'633',3627728.29,3627728.29,'633','2021-07-19 09:15:18','559','2021-07-19 15:44:52',10,0),('1','185',211585,'MORNING','2021-07-19','2021-07-19 00:00:00',NULL,'633',3286489.05,3286489.05,'633','2021-07-19 22:36:59','559','2021-07-20 09:14:31',10,0),('1','185',211625,'AFTERNOON','2021-07-20','2021-07-20 00:00:00',NULL,'633',4545641.07,4545641.07,'633','2021-07-20 10:07:19','559','2021-07-20 11:02:27',10,0),('1','185',211723,'MORNING','2021-07-20','2021-07-20 00:00:00',NULL,'633',2255666.13,2255666.13,'633','2021-07-20 16:49:52','559','2021-07-20 18:30:24',10,0),('1','185',211839,'AFTERNOON','2021-07-20','2021-07-20 00:00:00',NULL,'633',3050833.51,3050833.51,'633','2021-07-21 10:03:51','559','2021-07-21 13:50:52',10,0),('1','185',211921,'MORNING','2021-07-21','2021-07-21 00:00:00',NULL,'633',2628330.13,2628330.13,'633','2021-07-21 16:21:10','559','2021-07-21 16:32:28',10,0),('1','185',211991,'AFTERNOON','2021-07-21','2021-07-21 00:00:00',NULL,'633',3313872.59,3313872.59,'633','2021-07-22 10:38:10','559','2021-07-22 14:34:35',10,0),('1','185',212170,'MORNING','2021-07-22','2021-07-22 00:00:00',NULL,'633',3382903.78,3382903.78,'633','2021-07-22 16:27:39','559','2021-07-22 21:12:19',10,0),('1','185',212299,'AFTERNOON','2021-07-22','2021-07-22 00:00:00',NULL,'633',3091534.24,3091534.24,'633','2021-07-23 09:34:21','559','2021-07-23 15:37:29',10,0),('1','185',212404,'MORNING','2021-07-23','2021-07-23 00:00:00',NULL,'633',2603875.57,2603875.57,'633','2021-07-23 16:31:36','559','2021-07-23 17:55:33',10,0),('1','185',212428,'AFTERNOON','2021-07-23','2021-07-23 00:00:00',NULL,'633',3367157.78,3367157.78,'633','2021-07-24 09:35:26','559','2021-07-24 11:30:38',10,0),('1','185',212639,'MORNING','2021-07-24','2021-07-24 00:00:00',NULL,'633',3047935.55,3047935.55,'633','2021-07-24 20:18:39','559','2021-07-25 00:30:17',10,0),('1','185',212726,'AFTERNOON','2021-07-24','2021-07-24 00:00:00',NULL,'633',3513133.75,3513133.75,'633','2021-07-25 10:32:48','559','2021-07-25 10:43:51',10,0),('1','185',212733,'MORNING','2021-07-25','2021-07-25 00:00:00',NULL,'633',2762504.60,2762504.60,'633','2021-07-25 16:10:54','559','2021-07-25 16:52:42',10,0),('1','185',213094,'AFTERNOON','2021-07-26','2021-07-26 00:00:00',NULL,'633',3286656.26,3286656.26,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',213098,'AFTERNOON','2021-07-25','2021-07-25 00:00:00',NULL,'633',3286656.26,3286656.26,'633','2021-07-26 19:34:57','559','2021-07-26 19:39:59',10,0),('1','185',213100,'MORNING','2021-07-26','2021-07-26 00:00:00',NULL,'633',2796885.18,2796885.18,'633','2021-07-26 20:56:08','559','2021-07-27 05:38:44',10,0),('1','185',213169,'AFTERNOON','2021-07-26','2021-07-26 00:00:00',NULL,'633',2764776.50,2764776.50,'633','2021-07-27 09:32:31','559','2021-07-27 09:46:27',10,0),('1','185',213267,'MORNING','2021-07-27','2021-07-27 00:00:00',NULL,'633',2631055.35,2631055.35,'633','2021-07-27 15:43:34','559','2021-07-27 17:31:58',10,0),('1','185',213438,'AFTERNOON','2021-07-28','2021-07-28 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',213440,'AFTERNOON','2021-07-27','2021-07-27 00:00:00',NULL,'633',2857253.30,2857253.30,'633','2021-07-28 10:00:59','559','2021-07-28 11:04:55',10,0),('1','185',213605,'MORNING','2021-07-28','2021-07-28 00:00:00',NULL,'633',2256527.00,2256527.00,'633','2021-07-28 19:49:22','559','2021-07-29 08:05:03',10,0),('1','185',213707,'AFTERNOON','2021-07-28','2021-07-28 00:00:00',NULL,'633',3422654.92,3422654.92,'633','2021-07-29 10:28:46','559','2021-07-29 11:41:07',10,0),('1','185',213740,'MORNING','2021-07-29','2021-07-29 00:00:00',NULL,'633',2732588.09,2732588.09,'633','2021-07-29 21:38:48','559','2021-07-29 22:18:19',10,0),('1','185',213873,'AFTERNOON','2021-07-29','2021-07-29 00:00:00',NULL,'633',3483233.94,3483233.94,'633','2021-07-30 10:52:34','559','2021-07-30 12:52:38',10,0),('1','185',214034,'MORNING','2021-07-30','2021-07-30 00:00:00',NULL,'633',1724892.45,1724892.45,'633','2021-07-30 15:38:15','559','2021-07-30 15:41:13',10,0),('1','185',214074,'AFTERNOON','2021-07-30','2021-07-30 00:00:00',NULL,'633',4518892.62,4518892.62,'633','2021-07-31 09:07:42','559','2021-07-31 09:27:33',10,0),('1','185',214252,'MORNING','2021-07-31','2021-07-31 00:00:00',NULL,'633',3427102.94,3427102.94,'633','2021-07-31 15:39:45','559','2021-07-31 20:22:59',10,0),('1','185',214308,'AFTERNOON','2021-07-31','2021-07-31 00:00:00',NULL,'633',3936597.72,3936597.72,'633','2021-08-02 11:54:41','559','2021-08-02 11:56:58',10,0),('1','185',214670,'MORNING ','2021-08-01','2021-08-01 00:00:00',NULL,'633',2594037.37,2594037.37,'633','2021-08-02 13:14:03','559','2021-08-02 13:17:49',10,0),('1','185',214684,'AFTERNOON ','2021-08-01','2021-08-01 00:00:00',NULL,'633',3187047.72,3187047.72,'633','2021-08-02 14:03:23','559','2021-08-02 14:06:24',10,0),('1','185',214698,'MORNING','2021-08-02','2021-08-02 00:00:00',NULL,'633',3078716.08,3078716.08,'633','2021-08-03 08:24:32','559','2021-08-03 12:31:11',10,0),('1','185',214904,'AFTERNOON','2021-08-02','2021-08-02 00:00:00',NULL,'633',3718295.44,3718295.44,'633','2021-08-03 13:13:22','559','2021-08-03 13:51:11',10,0),('1','185',214937,'MORNING','2021-08-03','2021-08-03 00:00:00',NULL,'633',2979427.33,2979427.33,'633','2021-08-03 14:51:49','559','2021-08-03 14:58:02',10,0),('1','185',215062,'AFTERNOON','2021-08-03','2021-08-03 00:00:00',NULL,'633',3003271.63,3003271.63,'633','2021-08-04 09:23:19','559','2021-08-04 10:34:21',10,0),('1','185',215142,'MORNING','2021-08-04','2021-08-04 00:00:00',NULL,'633',2941827.85,2941827.85,'633','2021-08-04 15:31:43','559','2021-08-04 15:44:04',10,0),('1','185',215263,'AFTERNOON ','2021-08-04','2021-08-04 00:00:00',NULL,'633',2997884.02,2997884.02,'633','2021-08-05 08:52:18','559','2021-08-05 08:53:32',10,0),('1','185',215283,'MORNING ','2021-08-05','2021-08-05 00:00:00',NULL,'633',2532232.93,2532232.93,'633','2021-08-05 17:22:14','559','2021-08-05 17:29:29',10,0),('1','185',215555,'AFTERNOON','2021-08-05','2021-08-05 00:00:00',NULL,'633',3042115.40,3042115.40,'633','2021-08-06 11:25:06','559','2021-08-06 15:42:22',10,0),('1','185',215816,'MORNING','2021-08-06','2021-08-06 00:00:00',NULL,'633',2579239.08,2579239.08,'633','2021-08-07 15:32:18','559','2021-08-07 15:36:33',10,0),('1','185',215835,'AFTERNOON','2021-08-06','2021-08-06 00:00:00',NULL,'633',2935545.69,2935545.69,'633','2021-08-07 16:37:52','559','2021-08-07 16:40:49',10,0),('1','185',215847,'MORNING','2021-08-07','2021-08-07 00:00:00',NULL,'633',3082678.80,3082678.80,'633','2021-08-07 17:14:01','559','2021-08-07 17:15:52',10,0),('1','185',215870,'AFTERNOON','2021-08-07','2021-08-07 00:00:00',NULL,'633',2895164.03,2895164.03,'633','2021-08-08 10:34:11','559','2021-08-08 10:48:11',10,0),('1','185',216027,'MORNING','2021-08-08','2021-08-08 00:00:00',NULL,'633',2347124.38,2347124.38,'633','2021-08-08 15:26:28','559','2021-08-08 15:39:11',10,0),('1','185',216148,'AFTERNOON','2021-08-08','2021-08-08 00:00:00',NULL,'633',3143276.98,3143276.98,'633','2021-08-09 09:23:44','559','2021-08-09 09:33:38',10,0),('1','185',216171,'MORNING','2021-08-09','2021-08-09 00:00:00',NULL,'633',3239906.05,3239906.05,'633','2021-08-09 14:51:42','559','2021-08-09 15:04:04',10,0),('1','185',216263,'AFTERNOON','2021-08-09','2021-08-09 00:00:00',NULL,'633',2939620.17,2939620.17,'633','2021-08-10 10:08:00','559','2021-08-10 11:12:10',10,0),('1','185',216471,'MORNING','2021-08-10','2021-08-10 00:00:00',NULL,'633',2737559.81,2737559.81,'633','2021-08-10 15:40:41','559','2021-08-10 16:52:18',10,0),('1','185',216633,'AFTERNOON','2021-08-10','2021-08-10 00:00:00',NULL,'633',2892310.03,2892310.03,'633','2021-08-11 10:40:55','559','2021-08-11 11:50:41',10,0),('1','185',216691,'MORNING','2021-08-11','2021-08-11 00:00:00',NULL,'633',2816143.41,2816143.41,'633','2021-08-11 16:58:14','559','2021-08-11 18:45:11',10,0),('1','185',216861,'AFTERNOON','2021-08-11','2021-08-11 00:00:00',NULL,'633',2597294.90,2597294.90,'633','2021-08-12 09:57:16','559','2021-08-12 10:20:14',10,0),('1','185',216881,'MORNING','2021-08-12','2021-08-12 00:00:00',NULL,'633',2584917.25,2584917.25,'633','2021-08-12 15:40:50','559','2021-08-12 16:58:34',10,0),('1','185',217144,'AFTERNOON','2021-08-12','2021-08-12 00:00:00',NULL,'633',3200036.90,3200036.90,'633','2021-08-13 11:52:18','559','2021-08-13 13:50:35',10,0),('1','185',217186,'MORNING','2021-08-13','2021-08-13 00:00:00',NULL,'633',2120493.94,2120493.94,'633','2021-08-13 16:11:51','559','2021-08-13 17:18:23',10,0),('1','185',217331,'AFTERNOON','2021-08-13','2021-08-13 00:00:00',NULL,'633',3224232.93,3224232.93,'633','2021-08-15 10:04:10','559','2021-08-15 10:07:19',10,0),('1','185',217551,'MORNING','2021-08-14','2021-08-14 00:00:00',NULL,'633',2314303.34,2314303.34,'633','2021-08-15 10:14:51','559','2021-08-15 10:16:09',10,0),('1','185',217554,'AFTERNOON','2021-08-14','2021-08-14 00:00:00',NULL,'633',2502912.27,2502912.27,'633','2021-08-15 10:24:24','559','2021-08-15 10:29:22',10,0),('1','185',217557,'MORNING','2021-08-15','2021-08-15 00:00:00',NULL,'633',2061721.94,2061721.94,'633','2021-08-15 14:56:26','559','2021-08-15 16:10:56',10,0),('1','185',217747,'AFTERNOON','2021-08-15','2021-08-15 00:00:00',NULL,'633',2637526.08,2637526.08,'633','2021-08-16 09:21:06','559','2021-08-16 09:23:33',10,0),('1','185',217797,'MORNING','2021-08-16','2021-08-16 00:00:00',NULL,'633',2452330.30,2452330.30,'633','2021-08-16 15:33:00','559','2021-08-16 16:18:32',10,0),('1','185',218041,'AFTERNOON','2021-08-16','2021-08-16 00:00:00',NULL,'633',2859955.34,2859955.34,'633','2021-08-17 09:12:34','559','2021-08-17 09:30:04',10,0),('1','185',218301,'MORNING','2021-08-18','2021-08-18 00:00:00',NULL,'633',2433142.00,2433142.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',218356,'MORNING','2021-08-17','2021-08-17 00:00:00',NULL,'633',2433142.00,2433142.00,'633','2021-08-18 13:28:41','634','2021-08-18 13:29:54',10,0),('1','185',218362,'AFTERNOON','2021-08-17','2021-08-17 00:00:00',NULL,'633',2571644.55,2571644.55,'633','2021-08-18 13:51:37','559','2021-08-18 13:54:55',10,0),('1','185',218371,'MORNING','2021-08-18','2021-08-18 00:00:00',NULL,'633',2220572.54,2220572.54,'633','2021-08-18 15:00:41','559','2021-08-18 15:41:44',10,0),('1','185',218426,'AFTERNOON','2021-08-18','2021-08-18 00:00:00',NULL,'633',2338210.94,2338210.94,'633','2021-08-19 09:15:45','559','2021-08-19 09:29:51',10,0),('1','185',218528,'MORNING','2021-08-19','2021-08-19 00:00:00',NULL,'633',2737078.94,2737078.94,'633','2021-08-19 15:30:11','559','2021-08-19 16:19:22',10,0),('1','185',218723,'AFTERNOON','2021-08-19','2021-08-19 00:00:00',NULL,'633',3393723.41,3393723.41,'633','2021-08-20 08:47:14','559','2021-08-20 09:09:09',10,0),('1','185',218741,'MORNING','2021-08-20','2021-08-20 00:00:00',NULL,'633',2268786.97,2268786.97,'633','2021-08-20 14:50:04','559','2021-08-20 15:39:47',10,0),('1','185',218852,'AFTERNOON','2021-08-20','2021-08-20 00:00:00',NULL,'633',3223728.42,3223728.42,'633','2021-08-21 09:35:51','559','2021-08-21 12:52:43',10,0),('1','185',219031,'MORNING','2021-08-21','2021-08-21 00:00:00',NULL,'633',3089379.25,3089379.25,'633','2021-08-21 15:13:56','559','2021-08-21 16:46:10',10,0),('1','185',219173,'AFTERNOON','2021-08-21','2021-08-21 00:00:00',NULL,'633',3126207.12,3126207.12,'633','2021-08-22 09:46:26','559','2021-08-22 09:52:24',10,0),('1','185',219184,'MORNING','2021-08-22','2021-08-22 00:00:00',NULL,'633',2495245.66,2495245.66,'633','2021-08-22 16:39:20','559','2021-08-22 19:42:40',10,0),('1','185',219416,'AFTERNOON','2021-08-22','2021-08-22 00:00:00',NULL,'633',2765009.18,2765009.18,'633','2021-08-23 09:19:08','559','2021-08-23 09:38:47',10,0),('1','185',219433,'MORNING','2021-08-23','2021-08-23 00:00:00',NULL,'633',2590271.94,2590271.94,'633','2021-08-23 15:36:41','559','2021-08-23 15:41:50',10,0),('1','185',219534,'AFTERNOON','2021-08-23','2021-08-23 00:00:00',NULL,'633',3705138.04,3705138.04,'633','2021-08-24 08:53:18','559','2021-08-24 10:05:39',10,0),('1','185',219740,'MORNING','2021-08-24','2021-08-24 00:00:00',NULL,'633',2366592.93,2366592.93,'633','2021-08-24 14:44:24','559','2021-08-24 15:40:26',10,0),('1','185',219883,'AFTERNOON','2021-08-24','2021-08-24 00:00:00',NULL,'633',2664676.91,2664676.91,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',219890,'AFTERNOON','2021-08-24','2021-08-24 00:00:00',NULL,'633',2661903.31,2661903.31,'633','2021-08-25 09:57:35','559','2021-08-25 14:23:54',10,0),('1','185',219973,'MORNING','2021-08-25','2021-08-25 00:00:00',NULL,'633',2187007.40,2187007.40,'633','2021-08-25 15:34:42','559','2021-08-25 17:22:42',10,0),('1','185',220124,'AFTERNOON','2021-08-25','2021-08-25 00:00:00',NULL,'633',2319302.81,2319302.81,'633','2021-08-26 10:28:01','559','2021-08-26 10:29:36',10,0),('1','185',220129,'MORNING','2021-08-26','2021-08-26 00:00:00',NULL,'633',2360681.12,2360681.12,'633','2021-08-26 14:27:26','559','2021-08-26 14:31:38',10,0),('1','185',220319,'AFTERNOON','2021-08-26','2021-08-26 00:00:00',NULL,'633',3063730.54,3063730.54,'633','2021-08-27 09:49:49','559','2021-08-27 10:12:55',10,0),('1','185',220335,'MORNING','2021-08-27','2021-08-27 00:00:00',NULL,'633',2502972.77,2502972.77,'633','2021-08-27 15:38:13','559','2021-08-27 15:40:11',10,0),('1','185',220417,'AFTERNOON','2021-08-27','2021-08-27 00:00:00',NULL,'633',3146596.70,3146596.70,'633','2021-08-28 09:47:01','559','2021-08-28 10:14:44',10,0),('1','185',220621,'MORNING','2021-08-28','2021-08-28 00:00:00',NULL,'633',2650659.32,2650659.32,'633','2021-08-28 15:19:34','559','2021-08-28 15:25:26',10,0),('1','185',220734,'AFTERNOON','2021-08-28','2021-08-28 00:00:00',NULL,'633',3084593.11,3084593.11,'633','2021-08-29 09:31:09','559','2021-08-29 10:18:47',10,0),('1','185',220831,'MORNING','2021-08-29','2021-08-29 00:00:00',NULL,'633',3024870.00,3024870.00,'633','2021-08-29 15:20:37','559','2021-08-29 15:23:25',10,0),('1','185',220955,'AFTERNOON','2021-08-29','2021-08-29 00:00:00',NULL,'633',3055732.90,3055732.90,'633','2021-08-30 08:40:38','559','2021-08-30 09:04:46',10,0),('1','185',221007,'MORNING','2021-08-30','2021-08-30 00:00:00',NULL,'633',2674444.54,2674444.54,'633','2021-08-30 16:04:13','559','2021-08-30 17:15:41',10,0),('1','185',221198,'AFTERNOON','2021-08-30','2021-08-30 00:00:00',NULL,'633',3192838.14,3192838.14,'633','2021-08-31 09:06:22','559','2021-08-31 09:09:54',10,0),('1','185',221223,'MORNING','2021-08-31','2021-08-31 00:00:00',NULL,'633',2476098.02,2476098.02,'633','2021-08-31 15:51:51','559','2021-08-31 19:08:04',10,0),('1','185',221434,'AFTERNOON','2021-08-31','2021-08-31 00:00:00',NULL,'633',2832017.63,2832017.63,'633','2021-09-01 08:21:58','559','2021-09-01 15:34:35',10,0),('1','185',221571,'MORNING','2021-09-01','2021-09-01 00:00:00',NULL,'633',2566474.38,2566474.38,'633','2021-09-01 17:59:06','559','2021-09-02 08:24:13',10,0),('1','185',221726,'AFTERNOON','2021-09-01','2021-09-01 00:00:00',NULL,'633',2887563.32,2887563.32,'633','2021-09-02 12:56:29','559','2021-09-02 13:33:32',10,0),('1','185',221771,'MORNING','2021-09-02','2021-09-02 00:00:00',NULL,'633',2315522.88,2315522.88,'633','2021-09-02 16:00:51','559','2021-09-02 22:51:52',10,0),('1','185',221889,'AFTERNOON','2021-09-02','2021-09-02 00:00:00',NULL,'633',2705899.40,2705899.40,'633','2021-09-03 09:42:00','559','2021-09-03 10:16:21',10,0),('1','185',222007,'MORNING','2021-09-03','2021-09-03 00:00:00',NULL,'633',2220457.89,2220457.89,'633','2021-09-03 16:25:31','559','2021-09-03 16:52:52',10,0),('1','185',222121,'AFTERNOON','2021-09-03','2021-09-03 00:00:00',NULL,'633',2952398.66,2952398.66,'633','2021-09-04 10:10:11','559','2021-09-04 14:31:44',10,0),('1','185',222196,'MORNING','2021-09-04','2021-09-04 00:00:00',NULL,'633',2121538.10,2121538.10,'633','2021-09-04 14:44:41','559','2021-09-04 17:25:08',10,0),('1','185',222316,'AFTERNOON','2021-09-04','2021-09-04 00:00:00',NULL,'633',3413845.56,3413845.56,'633','2021-09-05 10:02:59','559','2021-09-05 13:28:18',10,0),('1','185',222439,'MORNING','2021-09-05','2021-09-05 00:00:00',NULL,'633',3005757.69,3005757.69,'633','2021-09-05 16:31:50','559','2021-09-05 20:07:37',10,0),('1','185',222559,'AFTERNOON','2021-09-05','2021-09-05 00:00:00',NULL,'633',3545167.37,3545167.37,'633','2021-09-06 09:35:59','559','2021-09-06 11:17:19',10,0),('1','185',222647,'MORNING','2021-09-06','2021-09-06 00:00:00',NULL,'633',2596455.38,2596455.38,'633','2021-09-06 14:41:17','559','2021-09-06 16:52:50',10,0),('1','185',222779,'AFTERNOON','2021-09-06','2021-09-06 00:00:00',NULL,'633',2713520.35,2713520.35,'633','2021-09-07 09:27:34','559','2021-09-07 10:29:42',10,0),('1','185',222868,'MORNING','2021-09-07','2021-09-07 00:00:00',NULL,'633',2258334.35,2258334.35,'633','2021-09-07 14:06:09','559','2021-09-07 15:06:10',10,0),('1','185',222979,'AFTERNOON','2021-09-07','2021-09-07 00:00:00',NULL,'633',2865462.77,2865462.77,'633','2021-09-08 08:49:02','559','2021-09-08 09:48:27',10,0),('1','185',223090,'MORNING','2021-09-08','2021-09-08 00:00:00',NULL,'633',2351288.58,2351288.58,'633','2021-09-08 14:29:16','559','2021-09-08 15:23:32',10,0),('1','185',223220,'AFTERNOON','2021-09-08','2021-09-08 00:00:00',NULL,'633',2795419.67,2795419.67,'633','2021-09-09 08:53:10','559','2021-09-09 09:41:42',10,0),('1','185',223318,'MORNING','2021-09-09','2021-09-09 00:00:00',NULL,'633',2308179.05,2308179.05,'633','2021-09-09 14:14:14','559','2021-09-09 15:05:28',10,0),('1','185',223459,'AFTERNOON','2021-09-09','2021-09-09 00:00:00',NULL,'633',2999767.30,2999767.30,'633','2021-09-10 09:16:48','559','2021-09-10 16:31:07',10,0),('1','185',223725,'MORNING','2021-09-10','2021-09-10 00:00:00',NULL,'633',2347059.79,2347059.79,'633','2021-09-11 10:54:18','559','2021-09-11 11:29:01',10,0),('1','185',223760,'AFTERNOON','2021-09-10','2021-09-10 00:00:00',NULL,'633',2643212.76,2643212.76,'633','2021-09-11 12:28:44','559','2021-09-11 13:03:50',10,0),('1','185',223842,'MORNING','2021-09-11','2021-09-11 00:00:00',NULL,'633',2489321.33,2489321.33,'633','2021-09-11 19:34:04','559','2021-09-12 07:56:51',10,0),('1','185',224057,'AFTERNOON','2021-09-11','2021-09-11 00:00:00',NULL,'633',2550118.70,2550118.70,'633','2021-09-12 21:08:56','559','2021-09-13 08:06:49',10,0),('1','185',224140,'MORNING','2021-09-12','2021-09-12 00:00:00',NULL,'633',2229091.83,2229091.83,'633','2021-09-13 09:17:58','559','2021-09-13 09:21:14',10,0),('1','185',224145,'AFTERNOON','2021-09-12','2021-09-12 00:00:00',NULL,'633',2129547.73,2129547.73,'633','2021-09-13 09:26:08','559','2021-09-13 10:49:39',10,0),('1','185',224271,'MORNING','2021-09-13','2021-09-13 00:00:00',NULL,'633',2930428.57,2930428.57,'633','2021-09-13 17:14:12','559','2021-09-14 05:14:58',10,0),('1','185',224389,'AFTERNOON','2021-09-13','2021-09-13 00:00:00',NULL,'633',3253209.79,3253209.79,'633','2021-09-14 09:59:58','559','2021-09-14 14:00:54',10,0),('1','185',224457,'MORNING','2021-09-14','2021-09-14 00:00:00',NULL,'633',2917373.27,2917373.27,'633','2021-09-14 14:22:01','559','2021-09-14 15:21:14',10,0),('1','185',224585,'AFTERNOON','2021-09-14','2021-09-14 00:00:00',NULL,'633',2875092.70,2875092.70,'633','2021-09-15 08:55:42','559','2021-09-15 09:10:40',10,0),('1','185',224615,'MORNING','2021-09-15','2021-09-15 00:00:00',NULL,'633',2493617.73,2493617.73,'633','2021-09-15 17:13:35','559','2021-09-16 08:11:59',10,0),('1','185',224832,'AFTERNOON','2021-09-15','2021-09-15 00:00:00',NULL,'633',3010560.61,3010560.61,'633','2021-09-16 09:28:31','559','2021-09-16 12:20:14',10,0),('1','185',224949,'MORNING','2021-09-16','2021-09-16 00:00:00',NULL,'633',2325726.50,2325726.50,'633','2021-09-16 15:00:54','559','2021-09-16 15:48:26',10,0),('1','185',225102,'AFTERNOON','2021-09-16','2021-09-16 00:00:00',NULL,'633',3368865.25,3368865.25,'633','2021-09-17 10:09:35','559','2021-09-17 14:09:03',10,0),('1','185',225167,'MORNING','2021-09-17','2021-09-17 00:00:00',NULL,'633',4025835.30,4025835.30,'633','2021-09-17 16:01:01','559','2021-09-17 16:56:19',10,0),('1','185',225343,'AFTERNOON','2021-09-17','2021-09-17 00:00:00',NULL,'633',3174980.74,3174980.74,'633','2021-09-18 10:12:39','559','2021-09-18 11:41:46',10,0),('1','185',225421,'MORNING','2021-09-18','2021-09-18 00:00:00',NULL,'633',2895414.39,2895414.39,'633','2021-09-18 15:44:47','559','2021-09-18 19:32:44',10,0),('1','185',225536,'AFTERNOON','2021-09-18','2021-09-18 00:00:00',NULL,'633',3210274.89,3210274.89,'633','2021-09-19 09:55:53','559','2021-09-19 12:21:29',10,0),('1','185',225614,'MORNING','2021-09-19','2021-09-19 00:00:00',NULL,'633',2535522.03,2535522.03,'633','2021-09-19 14:41:05','559','2021-09-19 16:02:53',10,0),('1','185',225751,'AFTERNOON','2021-09-19','2021-09-19 00:00:00',NULL,'633',2877196.73,2877196.73,'633','2021-09-20 08:21:34','559','2021-09-20 09:06:24',10,0),('1','185',225787,'MORNING','2021-09-20','2021-09-20 00:00:00',NULL,'633',2615536.54,2615536.54,'633','2021-09-20 16:21:42','559','2021-09-20 19:50:33',10,0),('1','185',226013,'AFTERNOON','2021-09-20','2021-09-20 00:00:00',NULL,'633',2950132.76,2950132.76,'633','2021-09-21 08:12:50','559','2021-09-21 08:55:38',10,0),('1','185',226160,'MORNING','2021-09-21','2021-09-21 00:00:00',NULL,'633',2822675.06,2822675.06,'633','2021-09-21 15:46:30','559','2021-09-21 19:29:51',10,0),('1','185',226325,'AFTERNOON','2021-09-21','2021-09-21 00:00:00',NULL,'633',2801842.42,2801842.42,'633','2021-09-22 11:09:46','559','2021-09-22 11:24:48',10,0),('1','185',226338,'MORNING','2021-09-22','2021-09-22 00:00:00',NULL,'633',2110271.94,2110271.94,'633','2021-09-22 15:17:16','559','2021-09-22 15:19:40',10,0),('1','185',226549,'AFTERNOON','2021-09-22','2021-09-22 00:00:00',NULL,'633',2823609.62,2823609.62,'633','2021-09-23 09:52:09','559','2021-09-23 15:21:18',10,0),('1','185',226684,'MORNING','2021-09-23','2021-09-23 00:00:00',NULL,'633',2237890.16,2237890.16,'633','2021-09-23 17:23:56','559','2021-09-23 20:25:07',10,0),('1','185',226800,'MORNING','2021-09-23','2021-09-23 00:00:00',NULL,'633',2693487.95,2693487.95,'633','2021-09-24 14:31:55','559','2021-09-24 14:35:14',10,0),('1','185',226885,'MORNING','2021-09-24','2021-09-24 00:00:00',NULL,'633',2741233.85,2741233.85,'633','2021-09-24 14:50:27','559','2021-09-24 15:19:43',10,0),('1','185',227017,'AFTERNOON','2021-09-24','2021-09-24 00:00:00',NULL,'633',2704909.42,2704909.42,'633','2021-09-25 09:29:56','559','2021-09-25 11:26:45',10,0),('1','185',227103,'MORNING','2021-09-25','2021-09-25 00:00:00',NULL,'633',2358993.73,2358993.73,'633','2021-09-25 14:20:31','559','2021-09-25 18:23:29',10,0),('1','185',227400,'AFTERNOON','2021-09-25','2021-09-25 00:00:00',NULL,'633',2891594.59,2891594.59,'633','2021-09-27 07:43:17','559','2021-09-27 08:01:50',10,0),('1','185',227413,'MORNING','2021-09-26','2021-09-26 00:00:00',NULL,'633',2385703.53,2385703.53,'633','2021-09-27 08:39:48','559','2021-09-27 08:43:25',10,0),('1','185',227433,'AFTERNOON','2021-09-26','2021-09-26 00:00:00',NULL,'633',3258058.29,3258058.29,'633','2021-09-27 08:52:29','559','2021-09-27 09:05:18',10,0),('1','185',227453,'MORNING','2021-09-27','2021-09-27 00:00:00',NULL,'633',2993183.95,2993183.95,'633','2021-09-27 16:04:39','559','2021-09-28 09:26:27',10,0),('1','185',227667,'AFTERNOON','2021-09-27','2021-09-27 00:00:00',NULL,'633',2759198.75,2759198.75,'633','2021-09-28 09:43:14','559','2021-09-28 12:02:52',10,0),('1','185',227777,'MORNING','2021-09-28','2021-09-28 00:00:00',NULL,'633',2340416.46,2340416.46,'633','2021-09-28 14:18:53','559','2021-09-28 15:59:39',10,0),('1','185',227999,'AFTERNOON','2021-09-28','2021-09-28 00:00:00',NULL,'633',2572902.30,2572902.30,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',228017,'AFTERNOON','2021-09-28','2021-09-28 00:00:00',NULL,'633',2583299.40,2583299.40,'633','2021-09-29 14:47:11','559','2021-09-29 15:28:39',10,0),('1','185',228058,'MORNING','2021-09-29','2021-09-29 00:00:00',NULL,'633',2663450.00,2663450.00,'633','2021-09-29 16:32:37','559','2021-09-29 16:38:59',10,0),('1','185',228171,'AFTERNOON','2021-09-29','2021-09-29 00:00:00',NULL,'633',2815922.74,2815922.74,'633','2021-09-30 10:08:03','559','2021-09-30 15:17:45',10,0),('1','185',228279,'MORNING','2021-09-30','2021-09-30 00:00:00',NULL,'633',2973323.26,2973323.26,'633','2021-09-30 16:07:21','559','2021-09-30 20:45:28',10,0),('1','185',228391,'AFTERNOON','2021-09-30','2021-09-30 00:00:00',NULL,'633',3725876.95,3725876.95,'633','2021-10-01 09:24:43','559','2021-10-01 09:30:50',10,0),('1','185',228486,'MORNING','2021-10-01','2021-10-01 00:00:00',NULL,'633',2616768.50,2616768.50,'633','2021-10-01 16:05:05','559','2021-10-01 17:04:59',10,0),('1','185',228567,'AFTERNOON','2021-10-01','2021-10-01 00:00:00',NULL,'633',2444744.09,2444744.09,'633','2021-10-02 09:07:01','559','2021-10-02 11:01:50',10,0),('1','185',228648,'MORNING','2021-10-02','2021-10-02 00:00:00',NULL,'633',2362336.18,2362336.18,'633','2021-10-02 14:26:25','559','2021-10-02 16:04:11',10,0),('1','185',228777,'AFTERNOON','2021-10-02','2021-10-02 00:00:00',NULL,'633',2713300.04,2713300.04,'633','2021-10-03 12:42:45','559','2021-10-03 13:02:04',10,0),('1','185',228858,'MORNING','2021-10-03','2021-10-03 00:00:00',NULL,'633',2771450.64,2771450.64,'633','2021-10-03 16:55:10','559','2021-10-03 21:01:37',10,0),('1','185',228999,'AFTERNOON','2021-10-03','2021-10-03 00:00:00',NULL,'633',2857499.04,2857499.04,'633','2021-10-04 09:24:15','559','2021-10-04 17:14:47',10,0),('1','185',229161,'MORNING','2021-10-04','2021-10-04 00:00:00',NULL,'633',2832164.50,2832164.50,'633','2021-10-05 05:37:27','559','2021-10-05 07:33:21',10,0),('1','185',229231,'AFTERNOON','2021-10-04','2021-10-04 00:00:00',NULL,'633',2538735.55,2538735.55,'633','2021-10-05 09:41:13','559','2021-10-05 09:56:58',10,0),('1','185',229235,'MORNING','2021-10-05','2021-10-05 00:00:00',NULL,'633',2745084.65,2745084.65,'633','2021-10-05 21:09:35','559','2021-10-06 09:01:21',10,0),('1','185',229464,'AFTERNOON','2021-10-05','2021-10-05 00:00:00',NULL,'633',2711510.18,2711510.18,'633','2021-10-06 09:09:20','559','2021-10-06 10:17:55',10,0),('1','185',229614,'MORNING','2021-10-06','2021-10-06 00:00:00',NULL,'633',2695689.84,2695689.84,'633','2021-10-06 16:32:26','559','2021-10-06 16:55:47',10,0),('1','185',229726,'AFTERNOON','2021-10-06','2021-10-06 00:00:00',NULL,'633',2749068.50,2749068.50,'633','2021-10-07 10:13:24','559','2021-10-07 10:18:24',10,0),('1','185',229742,'MORNING','2021-10-07','2021-10-07 00:00:00',NULL,'633',2922372.92,2922372.92,'633','2021-10-07 21:57:14','559','2021-10-08 08:34:58',10,0),('1','185',229929,'AFTERNOON','2021-10-07','2021-10-07 00:00:00',NULL,'633',3579269.30,3579269.30,'633','2021-10-08 08:56:16','559','2021-10-08 09:47:41',10,0),('1','185',230137,'MORNING','2021-10-08','2021-10-08 00:00:00',NULL,'633',3169840.11,3169840.11,'633','2021-10-09 09:15:44','559','2021-10-09 09:34:40',10,0),('1','185',230145,'AFTERNOON','2021-10-08','2021-10-08 00:00:00',NULL,'633',3212122.59,3212122.59,'633','2021-10-09 10:02:41','559','2021-10-09 10:10:44',10,0),('1','185',230164,'MORNING','2021-10-09','2021-10-09 00:00:00',NULL,'633',3476911.63,3476911.63,'633','2021-10-09 17:50:01','559','2021-10-10 08:12:37',10,0),('1','185',230352,'AFTERNOON','2021-10-09','2021-10-09 00:00:00',NULL,'633',2565535.24,2565535.24,'633','2021-10-10 09:43:57','559','2021-10-10 10:32:31',10,0),('1','185',230446,'MORNING','2021-10-10','2021-10-10 00:00:00',NULL,'633',3236008.03,3236008.03,'633','2021-10-10 14:50:00','559','2021-10-10 15:08:31',10,0),('1','185',230575,'AFTERNOON','2021-10-10','2021-10-10 00:00:00',NULL,'633',3492447.78,3492447.78,'633','2021-10-11 09:12:43','559','2021-10-11 10:11:45',10,0),('1','185',230700,'MORNING','2021-10-11','2021-10-11 00:00:00',NULL,'633',2727684.38,2727684.38,'633','2021-10-11 15:31:39','559','2021-10-11 17:57:17',10,0),('1','185',230829,'AFTERNOON','2021-10-11','2021-10-11 00:00:00',NULL,'633',2135891.69,2135891.69,'633','2021-10-12 08:50:51','559','2021-10-12 09:49:12',10,0),('1','185',231037,'MORNING','2021-10-12','2021-10-12 00:00:00',NULL,'633',2264366.66,2264366.66,'633','2021-10-12 20:38:27','559','2021-10-13 08:29:46',10,0),('1','185',231146,'AFTERNOON','2021-10-12','2021-10-12 00:00:00',NULL,'633',2048584.00,2048584.00,'633','2021-10-13 10:16:49','559','2021-10-13 15:04:47',10,0),('1','185',231308,'MORNING','2021-10-13','2021-10-13 00:00:00',NULL,'633',2059989.11,2059989.11,'633','2021-10-13 16:26:51','559','2021-10-13 17:06:08',10,0),('1','185',231452,'AFTERNOON','2021-10-13','2021-10-13 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',231453,'AFTERNOON','2021-10-13','2021-10-13 00:00:00',NULL,'633',2138797.98,2138797.98,'633','2021-10-14 09:49:51','559','2021-10-14 15:10:16',10,0),('1','185',231572,'MORNING','2021-10-14','2021-10-14 00:00:00',NULL,'633',2141226.68,2141226.68,'633','2021-10-14 15:37:35','559','2021-10-15 08:02:11',10,0),('1','185',231703,'AFTERNOON','2021-10-14','2021-10-14 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',231707,'AFTERNOON','2021-10-14','2021-10-14 00:00:00',NULL,'633',1928526.35,1928526.35,'633','2021-10-15 09:43:23','559','2021-10-15 10:12:01',10,0),('1','185',231837,'MORNING','2021-10-15','2021-10-15 00:00:00',NULL,'633',2044629.62,2044629.62,'633','2021-10-15 16:23:08','559','2021-10-15 20:56:48',10,0),('1','185',231958,'AFTERNOON','2021-10-15','2021-10-15 00:00:00',NULL,'633',2041288.12,2041288.12,'633','2021-10-16 10:26:59','559','2021-10-16 10:38:16',10,0),('1','185',232022,'MORNING','2021-10-16','2021-10-16 00:00:00',NULL,'633',2099246.03,2099246.03,'633','2021-10-16 14:32:28','559','2021-10-16 15:39:32',10,0),('1','185',232194,'AFTERNOON','2021-10-16','2021-10-16 00:00:00',NULL,'633',2155490.81,2155490.81,'633','2021-10-17 11:56:03','559','2021-10-17 14:29:36',10,0),('1','185',232287,'MORNING','2021-10-17','2021-10-17 00:00:00',NULL,'633',1833785.86,1833785.86,'633','2021-10-17 18:18:00','559','2021-10-18 08:54:56',10,0),('1','185',232411,'AFTERNOON','2021-10-17','2021-10-17 00:00:00',NULL,'633',2069625.67,2069625.67,'633','2021-10-18 09:53:58','559','2021-10-18 09:59:39',10,0),('1','185',232419,'MORNING','2021-10-18','2021-10-18 00:00:00',NULL,'633',2013956.28,2013956.28,'633','2021-10-18 15:58:54','559','2021-10-18 20:32:04',10,0),('1','185',232664,'AFTERNOON','2021-10-18','2021-10-18 00:00:00',NULL,'633',2161045.85,2161045.85,'633','2021-10-19 09:23:35','559','2021-10-19 09:39:40',10,0),('1','185',232671,'MORNING','2021-10-19','2021-10-19 00:00:00',NULL,'633',1655630.12,1655630.12,'633','2021-10-19 15:20:01','559','2021-10-19 19:29:08',10,0),('1','185',232903,'AFTERNOON','2021-10-19','2021-10-19 00:00:00',NULL,'633',2288365.15,2288365.15,'633','2021-10-20 08:52:10','559','2021-10-20 11:14:51',10,0),('1','185',233089,'MORNING','2021-10-20','2021-10-20 00:00:00',NULL,'633',2032895.25,2032895.25,'633','2021-10-20 22:36:21','559','2021-10-21 08:17:24',10,0),('1','185',233168,'AFTERNOON','2021-10-20','2021-10-20 00:00:00',NULL,'633',2486950.21,2486950.21,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',233210,'AFTERNOON','2021-10-20','2021-10-20 00:00:00',NULL,'633',2495611.21,2495611.21,'633','2021-10-21 10:21:17','559','2021-10-21 11:01:14',10,0),('1','185',233274,'MORNING','2021-10-21','2021-10-21 00:00:00',NULL,'633',2163353.08,2163353.08,'633','2021-10-21 14:51:21','559','2021-10-21 15:28:24',10,0),('1','185',233425,'AFTERNOON','2021-10-21','2021-10-21 00:00:00',NULL,'633',2621265.57,2621265.57,'633','2021-10-22 08:25:13','559','2021-10-22 09:02:15',10,0),('1','185',233538,'MORNING','2021-10-22','2021-10-22 00:00:00',NULL,'633',2291639.26,2291639.26,'633','2021-10-22 21:32:08','559','2021-10-23 07:45:28',10,0),('1','185',233650,'AFTERNOON','2021-10-22','2021-10-22 00:00:00',NULL,'633',2334892.43,2334892.43,'633','2021-10-23 08:00:34','559','2021-10-23 08:20:55',10,0),('1','185',233664,'MORNING','2021-10-23','2021-10-23 00:00:00',NULL,'633',2184016.31,2184016.31,'633','2021-10-23 21:45:16','559','2021-10-24 06:15:05',10,0),('1','185',233843,'AFTERNOON','2021-10-23','2021-10-23 00:00:00',NULL,'633',3160285.64,3160285.64,'633','2021-10-24 10:56:06','559','2021-10-24 11:18:42',10,0),('1','185',233960,'MORNING','2021-10-24','2021-10-24 00:00:00',NULL,'633',1488362.17,1504725.35,'633','2021-10-24 14:20:00','559','2021-10-25 06:21:21',10,0),('1','185',234061,'AFTERNOON','2021-10-24','2021-10-24 00:00:00',NULL,'633',2557113.10,2586546.50,'633','2021-10-25 08:44:20','559','2021-10-25 08:50:04',10,0),('1','185',234231,'MORNING','2021-10-25','2021-10-25 00:00:00',NULL,'633',2763801.85,2791682.75,'633','2021-10-25 15:21:56','559','2021-10-25 15:26:17',10,0),('1','185',234294,'AFTERNOON','2021-10-25','2021-10-25 00:00:00',NULL,'633',3356658.56,3389683.80,'633','2021-10-26 08:17:28','634','2021-10-26 09:00:42',10,0),('1','185',234432,'MORNING','2021-10-26','2021-10-26 00:00:00',NULL,'633',2939584.52,2967246.60,'633','2021-10-26 14:28:56','559','2021-10-26 15:23:26',10,0),('1','185',234565,'AFTERNOON','2021-10-26','2021-10-26 00:00:00',NULL,'633',3040651.52,3066830.60,'633','2021-10-27 08:54:04','634','2021-10-27 09:23:45',10,0),('1','185',234724,'MORNING','2021-10-27','2021-10-27 00:00:00',NULL,'633',2614804.65,2614804.65,'633','2021-10-27 14:07:15','559','2021-10-27 14:11:04',10,0),('1','185',234808,'AFTERNOON','2021-10-27','2021-10-27 00:00:00',NULL,'633',2504082.65,2504082.65,'633','2021-10-28 06:46:42','559','2021-10-28 06:48:24',10,0),('1','185',234967,'MORNING','2021-10-28','2021-10-28 00:00:00',NULL,'633',2504907.90,2504907.90,'633','2021-10-28 14:16:22','559','2021-10-28 14:27:07',10,0),('1','185',235053,'AFTERNOON','2021-10-28','2021-10-28 00:00:00',NULL,'633',2878344.15,2878344.15,'633','2021-10-29 06:38:09','559','2021-10-29 06:39:06',10,0),('1','185',235216,'MORNING','2021-10-29','2021-10-29 00:00:00',NULL,'633',2612557.20,2612557.20,'633','2021-10-29 13:56:52','559','2021-10-29 14:06:46',10,0),('1','185',235287,'AFTERNOON','2021-10-29','2021-10-29 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',235293,'AFTERNOON','2021-10-29','2021-10-29 00:00:00',NULL,'633',2154716.85,2154716.85,'633','2021-10-30 05:15:12','559','2021-10-30 06:43:43',10,0),('1','185',235397,'MORNING','2021-10-30','2021-10-30 00:00:00',NULL,'634',2759303.25,2759303.25,'633','2021-10-30 15:46:37','559','2021-10-30 15:57:04',10,0),('1','185',235509,'AFTERNOON','2021-10-30','2021-10-30 00:00:00',NULL,'633',2676686.10,2676686.10,'633','2021-10-31 05:03:28','559','2021-10-31 06:43:27',10,0),('1','185',235556,'MORNING','2021-10-31','2021-10-31 00:00:00',NULL,'633',2220710.25,2220710.25,'633','2021-10-31 14:28:41','559','2021-10-31 14:31:41',10,0),('1','185',235739,'AFTERNOON','2021-10-31','2021-10-31 00:00:00',NULL,'633',2951897.85,2951897.85,'633','2021-11-01 05:02:08','559','2021-11-01 06:35:58',10,0),('1','185',235924,'MORNING','2021-11-01','2021-11-01 00:00:00',NULL,'633',2687254.35,2687254.35,'633','2021-11-01 14:06:35','559','2021-11-01 15:00:10',10,0),('1','185',235999,'AFTERNOON','2021-11-01','2021-11-01 00:00:00',NULL,'633',2667965.85,2667965.85,'633','2021-11-02 07:06:09','559','2021-11-02 07:16:10',10,0),('1','185',236153,'MORNING','2021-11-02','2021-11-02 00:00:00',NULL,'633',2491247.55,2491247.55,'633','2021-11-02 14:20:11','559','2021-11-02 14:21:00',10,0),('1','185',236225,'AFTERNOON','2021-11-03','2021-11-03 00:00:00',NULL,'633',3139438.50,3139438.50,'633','2021-11-03 06:48:21','559','2021-11-03 06:49:25',10,0),('1','185',236408,'MORNING','2021-11-03','2021-11-03 00:00:00',NULL,'633',2643569.00,2643569.00,'633','2021-11-03 14:24:01','559','2021-11-03 14:25:27',10,0),('1','185',236498,'AFTERNOON','2021-11-03','2021-11-03 00:00:00',NULL,'633',2746621.70,2746621.70,'633','2021-11-04 05:24:06','559','2021-11-04 06:50:20',10,0),('1','185',236651,'MORNING','2021-11-04','2021-11-04 00:00:00',NULL,'633',2605469.50,2605469.50,'633','2021-11-04 13:55:11','559','2021-11-04 14:09:53',10,0),('1','185',236755,'AFTERNOON','2021-11-04','2021-11-04 00:00:00',NULL,'633',3418717.05,3418717.05,'633','2021-11-05 10:37:00','559','2021-11-05 11:09:59',10,0),('1','185',236866,'MORNING','2021-11-05','2021-11-05 00:00:00',NULL,'633',2940942.70,2940942.70,'633','2021-11-05 14:15:01','559','2021-11-05 14:17:38',10,0),('1','185',236948,'AFTERNOON','2021-11-05','2021-11-05 00:00:00',NULL,'633',3306846.20,3306846.20,'633','2021-11-06 07:12:28','559','2021-11-06 07:17:16',10,0),('1','185',237080,'MORNING','2021-11-06','2021-11-06 00:00:00',NULL,'633',2704386.70,2704386.70,'633','2021-11-06 13:40:55','559','2021-11-06 13:55:56',10,0),('1','185',237136,'AFTERNOON','2021-11-06','2021-11-06 00:00:00',NULL,'633',2793283.05,2793283.05,'633','2021-11-07 07:08:01','559','2021-11-07 07:17:40',10,0),('1','185',237281,'MORNING','2021-11-07','2021-11-07 00:00:00',NULL,'633',2595636.60,2595636.60,'633','2021-11-07 13:36:00','559','2021-11-07 14:19:02',10,0),('1','185',237377,'AFTERNOON','2021-11-07','2021-11-07 00:00:00',NULL,'633',3311819.10,3311819.10,'633','2021-11-08 05:40:11','559','2021-11-08 06:42:48',10,0),('1','185',237507,'MORNING','2021-11-08','2021-11-08 00:00:00',NULL,'633',2699167.90,2699167.90,'633','2021-11-08 13:40:07','559','2021-11-08 13:48:53',10,0),('1','185',237600,'AFTERNOON','2021-11-08','2021-11-08 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',237601,'AFTERNOON','2021-11-08','2021-11-08 00:00:00',NULL,'633',2432190.65,2432190.65,'633','2021-11-09 05:48:24','559','2021-11-09 05:58:19',10,0),('1','185',237739,'MORNING','2021-11-09','2021-11-09 00:00:00',NULL,'633',3226744.95,3226744.95,'633','2021-11-09 14:06:43','559','2021-11-09 14:33:37',10,0),('1','185',237860,'AFTERNOON','2021-11-09','2021-11-09 00:00:00',NULL,'633',2574247.50,2574247.50,'633','2021-11-10 05:28:33','559','2021-11-10 07:00:29',10,0),('1','185',238023,'MORNING','2021-11-10','2021-11-10 00:00:00',NULL,'633',2697479.40,2697479.40,'633','2021-11-10 13:49:37','559','2021-11-10 13:55:54',10,0),('1','185',238095,'AFTERNOON','2021-11-10','2021-11-10 00:00:00',NULL,'633',3247528.35,3247528.35,'633','2021-11-11 06:55:22','559','2021-11-11 06:57:31',10,0),('1','185',238242,'MORNING','2021-11-11','2021-11-11 00:00:00',NULL,'634',3065190.15,3065190.15,'633','2021-11-11 13:42:27','559','2021-11-11 13:50:40',10,0),('1','185',238344,'AFTERNOON','2021-11-11','2021-11-11 00:00:00',NULL,'633',3403657.95,3403657.95,'633','2021-11-12 05:10:09','559','2021-11-12 05:49:11',10,0),('1','185',238511,'MORNING','2021-11-12','2021-11-12 00:00:00',NULL,'633',3559100.05,3559100.05,'633','2021-11-12 13:56:20','559','2021-11-12 14:07:13',10,0),('1','185',238591,'AFTERNOON','2021-11-12','2021-11-12 00:00:00',NULL,'633',4211689.00,4211689.00,'633','2021-11-13 05:25:52','559','2021-11-13 06:34:22',10,0),('1','185',238743,'MORNING','2021-11-13','2021-11-13 00:00:00',NULL,'633',4284727.15,4284727.15,'633','2021-11-13 13:43:27','559','2021-11-13 13:53:22',10,0),('1','185',241756,'AFTERNOON','2021-11-25','2021-11-25 00:00:00',NULL,'633',2068526.85,2068526.85,'633','2021-11-26 06:50:25','559','2021-11-26 06:51:56',10,0),('1','185',241786,'MORNING','2021-11-26','2021-11-26 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',241877,'MORNING','2021-11-26','2021-11-26 00:00:00',NULL,'633',1939413.75,1939413.75,'633','2021-11-26 14:00:04','559','2021-11-26 14:03:48',10,0),('1','185',241920,'AFTERNOON','2021-11-26','2021-11-26 00:00:00',NULL,'633',2450485.35,2450485.35,'633','2021-11-27 06:41:02','559','2021-11-27 06:42:39',10,0),('1','185',242023,'MORNING','2021-11-27','2021-11-27 00:00:00',NULL,'633',3213938.05,3213938.05,'633','2021-11-27 13:37:51','559','2021-11-27 13:39:40',10,0),('1','185',242220,'AFTERNOON','2021-11-27','2021-11-27 00:00:00',NULL,'633',2888806.75,2888806.75,'633','2021-11-28 06:58:13','559','2021-11-28 07:00:07',10,0),('1','185',242240,'MORNING','2021-11-28','2021-11-28 00:00:00',NULL,'633',3162617.50,3162617.50,'633','2021-11-28 13:56:31','559','2021-11-28 13:57:57',10,0),('1','185',242442,'AFTERNOON ','2021-11-28','2021-11-28 00:00:00',NULL,'633',3127305.35,3127305.35,'633','2021-11-29 06:45:33','559','2021-11-29 06:47:41',10,0),('1','185',242487,'MORNING','2021-11-29','2021-11-29 00:00:00',NULL,'633',2621325.30,2621325.30,'633','2021-11-29 13:31:39','559','2021-11-29 13:33:03',10,0),('1','185',242690,'MORNING','2021-11-30','2021-11-30 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',242691,'AFTERNOON','2021-11-30','2021-11-30 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',242694,'AFTERNOON','2021-11-29','2021-11-29 00:00:00',NULL,'633',2854229.40,2854229.40,'633','2021-11-30 06:47:11','559','2021-11-30 06:48:47',10,0),('1','185',242715,'MORNING','2021-11-30','2021-11-30 00:00:00',NULL,'633',2553513.60,2553513.60,'633','2021-11-30 13:36:04','559','2021-11-30 13:38:02',10,0),('1','185',242928,'AFTERNOON','2021-11-30','2021-11-30 00:00:00',NULL,'633',2499362.25,2499362.25,'633','2021-12-01 06:28:42','559','2021-12-01 06:30:11',10,0),('1','185',242953,'MORNING','2021-12-01','2021-12-01 00:00:00',NULL,'633',2379311.55,2379311.55,'633','2021-12-01 13:46:57','559','2021-12-01 13:48:16',10,0),('1','185',243159,'AFTERNOON','2021-12-01','2021-12-01 00:00:00',NULL,'633',2546190.90,2546190.90,'633','2021-12-02 06:54:44','559','2021-12-02 06:55:46',10,0),('1','185',243178,'MORNING','2021-12-02','2021-12-02 00:00:00',NULL,'633',3114154.45,3114154.45,'633','2021-12-02 14:00:15','559','2021-12-02 14:12:00',10,0),('1','185',243345,'AFTERNOON','2021-12-02','2021-12-02 00:00:00',NULL,'633',2530186.95,2530186.95,'633','2021-12-03 05:17:47','559','2021-12-03 06:30:50',10,0),('1','185',243502,'MORNING','2021-12-03','2021-12-03 00:00:00',NULL,'633',2749599.05,2749599.05,'633','2021-12-03 13:36:04','559','2021-12-03 13:48:54',10,0),('1','185',243576,'AFTERNOON','2021-12-03','2021-12-03 00:00:00',NULL,'633',2692899.45,2692899.45,'633','2021-12-04 05:11:44','559','2021-12-04 06:35:22',10,0),('1','185',243722,'MORNING','2021-12-04','2021-12-04 00:00:00',NULL,'633',3530971.25,3530971.25,'633','2021-12-04 13:34:32','559','2021-12-04 13:48:49',10,0),('1','185',243816,'AFTERNOON','2021-12-04','2021-12-04 00:00:00',NULL,'633',2530898.60,2530898.60,'633','2021-12-05 06:52:55','559','2021-12-05 07:39:21',10,0),('1','185',243952,'MORNING','2021-12-05','2021-12-05 00:00:00',NULL,'633',2584574.60,2584574.60,'633','2021-12-05 14:42:37','559','2021-12-05 15:16:31',10,0),('1','185',244051,'AFTERNOON','2021-12-05','2021-12-05 00:00:00',NULL,'633',3142975.40,3142975.40,'633','2021-12-06 06:56:04','559','2021-12-06 07:02:26',10,0),('1','185',244183,'MORNING','2021-12-06','2021-12-06 00:00:00',NULL,'633',3084071.00,3084071.00,'633','2021-12-06 13:53:16','559','2021-12-06 13:59:25',10,0),('1','185',244306,'AFTERNOON','2021-12-06','2021-12-06 00:00:00',NULL,'633',3083262.75,3083262.75,'633','2021-12-07 06:48:16','559','2021-12-07 06:50:23',10,0),('1','185',244428,'MORNING','2021-12-07','2021-12-07 00:00:00',NULL,'633',1712010.75,1712010.75,'633','2021-12-07 14:33:14','559','2021-12-07 14:41:43',10,0),('1','185',244515,'AFTERNOON','2021-12-07','2021-12-07 00:00:00',NULL,'633',1027033.90,1027033.90,'633','2021-12-08 06:34:29','559','2021-12-08 06:41:05',10,0),('1','185',244635,'MORNING','2021-12-08','2021-12-08 00:00:00',NULL,'633',2864786.50,2864786.50,'633','2021-12-08 13:12:59','559','2021-12-08 13:29:46',10,0),('1','185',244742,'AFTERNOON','2021-12-08','2021-12-08 00:00:00',NULL,'633',2432420.45,2432420.45,'633','2021-12-09 06:48:57','559','2021-12-09 06:53:27',10,0),('1','185',244871,'MORNING','2021-12-09','2021-12-09 00:00:00',NULL,'633',2049552.15,2049552.15,'633','2021-12-09 14:08:46','559','2021-12-09 14:09:53',10,0),('1','185',244985,'AFTERNOON','2021-12-09','2021-12-09 00:00:00',NULL,'633',2081017.95,2081017.95,'633','2021-12-10 06:01:46','559','2021-12-10 06:36:29',10,0),('1','185',245113,'MORNING','2021-12-10','2021-12-10 00:00:00',NULL,'633',3758186.75,3758186.75,'633','2021-12-10 13:52:35','559','2021-12-10 14:25:50',10,0),('1','185',245200,'AFTERNOON','2021-12-10','2021-12-10 00:00:00',NULL,'633',3063771.75,3063771.75,'633','2021-12-11 05:13:25','559','2021-12-11 06:34:34',10,0),('1','185',245325,'MORNING','2021-12-11','2021-12-11 00:00:00',NULL,'633',3226323.35,3226323.35,'633','2021-12-11 13:22:50','559','2021-12-11 13:28:06',10,0),('1','185',245441,'AFTERNOON','2021-12-11','2021-12-11 00:00:00',NULL,'633',2874718.60,2874718.60,'633','2021-12-12 06:13:16','559','2021-12-12 06:37:08',10,0),('1','185',245565,'MORNING','2021-12-12','2021-12-12 00:00:00',NULL,'633',2245404.55,2245404.55,'633','2021-12-12 13:43:52','559','2021-12-12 14:10:53',10,0),('1','185',245667,'AFTERNOON','2021-12-12','2021-12-12 00:00:00',NULL,'633',2623950.55,2623950.55,'633','2021-12-13 05:25:27','559','2021-12-13 06:43:10',10,0),('1','185',245795,'MORNING','2021-12-13','2021-12-13 00:00:00',NULL,'633',2898151.45,2898151.45,'633','2021-12-13 13:17:38','559','2021-12-13 13:24:58',10,0),('1','185',245933,'AFTERNOON','2021-12-13','2021-12-13 00:00:00',NULL,'633',2594021.50,2594021.50,'633','2021-12-14 05:52:32','559','2021-12-14 06:24:30',10,0),('1','185',246068,'MORNING','2021-12-14','2021-12-14 00:00:00',NULL,'633',2697334.95,2697334.95,'633','2021-12-14 13:23:30','559','2021-12-14 13:57:15',10,0),('1','185',246176,'AFTERNOON','2021-12-14','2021-12-14 00:00:00',NULL,'633',2620969.35,2620969.35,'633','2021-12-15 05:35:29','559','2021-12-15 06:25:48',10,0),('1','185',246341,'MORNING','2021-12-15','2021-12-15 00:00:00',NULL,'633',2331355.60,2331355.60,'633','2021-12-15 13:28:45','559','2021-12-15 14:03:45',10,0),('1','185',246381,'AFTERNOON','2021-12-15','2021-12-15 00:00:00',NULL,'633',2284575.65,2284575.65,'633','2021-12-16 06:26:56','559','2021-12-16 06:30:19',10,0),('1','185',246584,'MORNING','2021-12-16','2021-12-16 00:00:00',NULL,'633',2259765.15,2259765.15,'633','2021-12-16 13:26:01','559','2021-12-16 13:46:39',10,0),('1','185',246693,'AFTERNOON','2021-12-16','2021-12-16 00:00:00',NULL,'633',2399603.20,2399603.20,'633','2021-12-17 05:43:39','559','2021-12-17 06:28:06',10,0),('1','185',246832,'MORNING','2021-12-17','2021-12-17 00:00:00',NULL,'633',2543082.00,2543082.00,'633','2021-12-17 13:34:25','559','2021-12-17 15:20:44',10,0),('1','185',246952,'AFTERNOON','2021-12-17','2021-12-17 00:00:00',NULL,'633',2597268.85,2597268.85,'633','2021-12-18 06:42:41','559','2021-12-18 06:53:29',10,0),('1','185',247072,'MORNING','2021-12-18','2021-12-18 00:00:00',NULL,'633',2684209.10,2684209.10,'633','2021-12-18 13:34:56','559','2021-12-18 13:43:47',10,0),('1','185',247165,'AFTERNOON','2021-12-18','2021-12-18 00:00:00',NULL,'633',2595279.00,2595279.00,'633','2021-12-19 05:58:06','559','2021-12-19 06:25:54',10,0),('1','185',247298,'MORNING','2021-12-19','2021-12-19 00:00:00',NULL,'633',2604572.95,2604572.95,'633','2021-12-19 13:49:58','559','2021-12-19 13:50:24',10,0),('1','185',247387,'AFTERNOON','2021-12-19','2021-12-19 00:00:00',NULL,'633',2027990.15,2027990.15,'633','2021-12-20 05:41:40','559','2021-12-20 06:29:48',10,0),('1','185',247549,'MORNING','2021-12-20','2021-12-20 00:00:00',NULL,'633',1940101.50,1940101.50,'633','2021-12-20 13:28:02','559','2021-12-20 13:41:40',10,0),('1','185',247666,'AFTERNOON','2021-12-20','2021-12-20 00:00:00',NULL,'633',1253030.80,1253030.80,'633','2021-12-21 06:00:10','559','2021-12-21 06:22:40',10,0),('1','185',247798,'MORNING','2021-12-21','2021-12-21 00:00:00',NULL,'633',3161707.60,3161707.60,'633','2021-12-21 13:42:35','559','2021-12-21 13:45:05',10,0),('1','185',247914,'AFTERNOON','2021-12-21','2021-12-21 00:00:00',NULL,'633',2654355.70,2654355.70,'633','2021-12-22 06:15:07','559','2021-12-22 06:29:27',10,0),('1','185',248039,'MORNING','2021-12-22','2021-12-22 00:00:00',NULL,'633',3044450.80,3044450.80,'633','2021-12-22 13:18:52','559','2021-12-22 13:39:42',10,0),('1','185',248139,'AFTERNOON','2021-12-22','2021-12-22 00:00:00',NULL,'633',2680533.85,2680533.85,'633','2021-12-23 06:48:48','559','2021-12-23 06:58:46',10,0),('1','185',248297,'MORNING','2021-12-23','2021-12-23 00:00:00',NULL,'633',2898609.70,2898609.70,'633','2021-12-23 13:35:29','559','2021-12-23 13:53:30',10,0),('1','185',248394,'AFTERNOON','2021-12-23','2021-12-23 00:00:00',NULL,'633',2957607.75,2957607.75,'633','2021-12-24 05:56:49','559','2021-12-24 06:31:30',10,0),('1','185',248515,'MORNING','2021-12-24','2021-12-24 00:00:00',NULL,'633',3075566.35,3075566.35,'633','2021-12-24 13:29:43','559','2021-12-24 14:15:47',10,0),('1','185',248593,'AFTERNOON','2021-12-24','2021-12-24 00:00:00',NULL,'633',3422350.20,3422350.20,'633','2021-12-25 05:33:58','559','2021-12-25 06:16:47',10,0),('1','185',248693,'MORNING','2021-12-25','2021-12-25 00:00:00',NULL,'633',2878150.25,2878150.25,'633','2021-12-25 13:37:09','559','2021-12-25 13:49:21',10,0),('1','185',248875,'AFTERNOON','2021-12-25','2021-12-25 00:00:00',NULL,'633',1706059.40,1706059.40,'633','2021-12-26 06:34:35','559','2021-12-26 06:39:49',10,0),('1','185',248988,'MORNING','2021-12-26','2021-12-26 00:00:00',NULL,'633',1233698.90,1233698.90,'633','2021-12-26 13:10:29','559','2021-12-26 13:16:21',10,0),('1','185',249132,'AFTERNOON','2021-12-26','2021-12-26 00:00:00',NULL,'633',298166.35,298166.35,'633','2021-12-27 06:50:02','559','2021-12-27 07:02:46',10,0),('1','185',249289,'MORNING','2021-12-27','2021-12-27 00:00:00',NULL,'633',714147.00,714147.00,'633','2021-12-27 18:21:16','559','2021-12-27 18:24:16',10,0),('1','185',249342,'AFTERNOON','2021-12-27','2021-12-27 00:00:00',NULL,'633',1705641.40,1705641.40,'633','2021-12-28 06:05:15','559','2021-12-28 06:25:32',10,0),('1','185',249471,'MORNING','2021-12-28','2021-12-28 00:00:00',NULL,'633',3176186.85,3176186.85,'633','2021-12-28 13:16:09','559','2021-12-28 13:21:47',10,0),('1','185',249574,'AFTERNOON','2021-12-28','2021-12-28 00:00:00',NULL,'633',3065045.70,3065045.70,'633','2021-12-29 05:21:45','559','2021-12-29 05:53:30',10,0),('1','185',249708,'MORNING','2021-12-29','2021-12-29 00:00:00',NULL,'634',2643727.50,2643727.50,'633','2021-12-29 13:30:06','559','2021-12-29 13:34:30',10,0),('1','185',249860,'AFTERNOON','2021-12-29','2021-12-29 00:00:00',NULL,'633',2598763.65,2598763.65,'633','2021-12-30 06:31:40','559','2021-12-30 06:41:00',10,0),('1','185',249981,'MORNING','2021-12-30','2021-12-30 00:00:00',NULL,'633',2040467.85,2040467.85,'633','2021-12-30 13:03:32','559','2021-12-30 13:38:14',10,0),('1','185',250088,'AFTERNOON','2021-12-30','2021-12-30 00:00:00',NULL,'633',424812.30,424812.30,'633','2021-12-31 05:34:39','559','2021-12-31 06:40:06',10,0),('1','185',250222,'MORNING','2021-12-31','2021-12-31 00:00:00',NULL,'633',347480.55,347480.55,'633','2021-12-31 13:12:49','559','2021-12-31 14:09:17',10,0),('1','185',250351,'AFTERNOON','2021-12-31','2021-12-31 00:00:00',NULL,'633',2475642.60,2475642.60,'633','2022-01-01 06:40:15','559','2022-01-01 08:20:47',10,0),('1','185',250445,'MORNING','2022-01-01','2022-01-01 00:00:00',NULL,'633',2834329.05,2834329.05,'633','2022-01-01 13:04:19','559','2022-01-01 13:19:30',10,0),('1','185',250561,'AFTERNOON','2022-01-01','2022-01-01 00:00:00',NULL,'633',1435132.80,1435132.80,'633','2022-01-02 06:11:07','559','2022-01-02 06:40:35',10,0),('1','185',250799,'DAY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'633',978834.00,978834.00,'633','2022-01-03 06:07:41','559','2022-01-03 06:25:02',10,0),('1','185',251012,'DAY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'633',4181619.60,4181619.60,'633','2022-01-04 07:05:30','559','2022-01-04 07:17:15',10,0),('1','185',251153,'MORNING','2022-01-04','2022-01-04 00:00:00',NULL,'633',3973525.05,3973525.05,'633','2022-01-04 13:30:24','559','2022-01-04 13:32:59',10,0),('1','185',251277,'AFTERNOON','2022-01-04','2022-01-04 00:00:00',NULL,'633',3382109.55,3382109.55,'633','2022-01-05 06:33:25','559','2022-01-05 06:34:27',10,0),('1','185',251408,'MORNING','2022-01-05','2022-01-05 00:00:00',NULL,'633',2891870.85,2891870.85,'633','2022-01-05 15:06:49','559','2022-01-05 15:18:26',10,0),('1','185',251528,'AFTERNOON','2022-01-05','2022-01-05 00:00:00',NULL,'633',2731416.00,2731416.00,'633','2022-01-06 08:22:25','559','2022-01-06 08:25:08',10,0),('1','185',251656,'MORNING','2022-01-06','2022-01-06 00:00:00',NULL,'633',2431441.65,2431441.65,'633','2022-01-06 14:44:38','559','2022-01-06 14:54:59',10,0),('1','185',251754,'AFTERNOON','2022-01-06','2022-01-06 00:00:00',NULL,'633',2814313.65,2814313.65,'633','2022-01-07 06:32:57','559','2022-01-07 07:38:29',10,0),('1','185',251886,'MORNING','2022-01-07','2022-01-07 00:00:00',NULL,'633',2154069.15,2154069.15,'633','2022-01-07 14:45:57','559','2022-01-07 14:51:57',10,0),('1','185',251991,'AFTERNOON','2022-01-07','2022-01-07 00:00:00',NULL,'633',2522928.60,2522928.60,'633','2022-01-08 07:05:40','559','2022-01-08 07:09:16',10,0),('1','185',252131,'MORNING','2022-01-08','2022-01-08 00:00:00',NULL,'633',2010541.05,2010541.05,'633','2022-01-08 14:27:02','559','2022-01-08 14:51:53',10,0),('1','185',252250,'AFTERNOON','2022-01-08','2022-01-08 00:00:00',NULL,'633',3165961.20,3165961.20,'633','2022-01-09 07:39:47','559','2022-01-09 07:41:00',10,0),('1','185',252355,'MORNING','2022-01-09','2022-01-09 00:00:00',NULL,'633',2748561.15,2748561.15,'633','2022-01-09 14:48:37','559','2022-01-09 15:13:46',10,0),('1','185',252472,'AFTERNOON','2022-01-09','2022-01-09 00:00:00',NULL,'633',3100882.35,3100882.35,'633','2022-01-10 07:03:00','559','2022-01-10 07:23:42',10,0),('1','185',252619,'MORNING','2022-01-10','2022-01-10 00:00:00',NULL,'633',3371154.45,3371154.45,'633','2022-01-10 14:47:04','559','2022-01-10 14:54:00',10,0),('1','185',252721,'AFTERNOON','2022-01-10','2022-01-10 00:00:00',NULL,'633',4000668.75,4000668.75,'633','2022-01-11 07:34:58','559','2022-01-11 07:35:22',10,0),('1','185',252858,'MORNING','2022-01-11','2022-01-11 00:00:00',NULL,'633',3244438.65,3244438.65,'633','2022-01-11 15:02:15','559','2022-01-11 15:05:04',10,0),('1','185',252974,'AFTERNOON','2022-01-11','2022-01-11 00:00:00',NULL,'633',2835419.10,2835419.10,'633','2022-01-12 07:29:00','559','2022-01-12 07:32:12',10,0),('1','185',253095,'MORNING','2022-01-12','2022-01-12 00:00:00',NULL,'633',3025350.90,3025350.90,'633','2022-01-12 15:03:15','559','2022-01-12 15:08:20',10,0),('1','185',253207,'AFTERNOON','2022-01-12','2022-01-12 00:00:00',NULL,'633',3062930.70,3062930.70,'633','2022-01-13 07:31:46','559','2022-01-13 07:37:59',10,0),('1','185',253369,'MORNING','2022-01-13','2022-01-13 00:00:00',NULL,'633',3595658.10,3595658.10,'633','2022-01-13 14:58:40','559','2022-01-13 15:14:26',10,0),('1','185',253480,'AFTERNOON','2022-01-13','2022-01-13 00:00:00',NULL,'633',2932427.55,2932427.55,'633','2022-01-14 07:39:21','559','2022-01-14 07:40:56',10,0),('1','185',253606,'MORNING','2022-01-14','2022-01-14 00:00:00',NULL,'633',2656306.50,2656306.50,'633','2022-01-14 14:30:03','559','2022-01-14 14:37:09',10,0),('1','185',253703,'AFTERNOON','2022-01-14','2022-01-14 00:00:00',NULL,'633',3028252.95,3028252.95,'633','2022-01-15 06:45:04','559','2022-01-15 07:21:45',10,0),('1','185',253842,'MORNING','2022-01-15','2022-01-15 00:00:00',NULL,'633',3031246.05,3031246.05,'633','2022-01-15 14:39:55','559','2022-01-15 15:15:08',10,0),('1','185',253967,'AFTERNOON','2022-01-15','2022-01-15 00:00:00',NULL,'633',2679123.60,2679123.60,'633','2022-01-16 07:30:40','559','2022-01-16 07:33:58',10,0),('1','185',254089,'AFTERNOON','2022-01-16','2022-01-16 00:00:00',NULL,'633',2472764.55,2472764.55,'633','2022-01-16 15:09:28','559','2022-01-16 15:21:58',10,0),('1','185',254184,'AFTERNOON','2022-01-16','2022-01-16 00:00:00',NULL,'633',2757462.60,2757462.60,'633','2022-01-17 07:02:29','559','2022-01-17 07:42:47',10,0),('1','185',254350,'MORNING','2022-01-17','2022-01-17 00:00:00',NULL,'633',2904012.90,2904012.90,'633','2022-01-17 14:43:59','559','2022-01-17 15:12:09',10,0),('1','185',254462,'AFTERNOON','2022-01-17','2022-01-17 00:00:00',NULL,'633',2150638.20,2150638.20,'633','2022-01-18 07:49:37','559','2022-01-18 07:51:17',10,0),('1','185',254594,'MORNING','2022-01-18','2022-01-18 00:00:00',NULL,'633',2301178.50,2301178.50,'633','2022-01-18 14:41:09','559','2022-01-18 14:46:03',10,0),('1','185',254712,'AFTERNOON','2022-01-18','2022-01-18 00:00:00',NULL,'633',3084105.35,3084105.35,'633','2022-01-19 07:42:08','559','2022-01-19 07:46:40',10,0),('1','185',254840,'MORNING','2022-01-19','2022-01-19 00:00:00',NULL,'633',747620.95,747620.95,'633','2022-01-19 14:27:35','559','2022-01-19 14:41:27',10,0),('1','185',254954,'AFTERNOON','2022-01-19','2022-01-19 00:00:00',NULL,'633',2062861.35,2062861.35,'633','2022-01-20 07:43:31','559','2022-01-20 07:44:19',10,0),('1','185',255084,'MORNING','2022-01-20','2022-01-20 00:00:00',NULL,'633',2003559.95,2003559.95,'633','2022-01-20 14:43:31','559','2022-01-20 14:45:03',10,0),('1','185',255181,'AFTERNOON','2022-01-20','2022-01-20 00:00:00',NULL,'633',2148340.85,2148340.85,'633','2022-01-21 06:30:52','559','2022-01-21 07:36:17',10,0),('1','185',255334,'MORNING','2022-01-21','2022-01-21 00:00:00',NULL,'633',1597433.80,1597433.80,'633','2022-01-21 15:03:02','559','2022-01-21 15:12:55',10,0),('1','185',255460,'AFTERNOON','2022-01-21','2022-01-21 00:00:00',NULL,'633',237727.00,237727.00,'633','2022-01-22 07:21:45','559','2022-01-22 07:37:10',10,0),('1','185',255704,'DAY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'633',1691467.35,1691467.35,'633','2022-01-23 06:34:19','559','2022-01-23 07:35:52',10,0),('1','185',255821,'MORNING','2022-01-23','2022-01-23 00:00:00',NULL,'633',2565707.60,2565707.60,'633','2022-01-23 13:52:35','559','2022-01-23 15:44:30',10,0),('1','185',255954,'AFTERNOON','2022-01-23','2022-01-23 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',255967,'AFTERNOON','2022-01-23','2022-01-23 00:00:00',NULL,'633',2682766.15,2682766.15,'633','2022-01-24 07:40:49','559','2022-01-24 07:48:59',10,0),('1','185',256084,'MORNING','2022-01-24','2022-01-24 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',256099,'MORNING','2022-01-24','2022-01-24 00:00:00',NULL,'633',2388021.25,2388021.25,'633','2022-01-24 14:53:45','559','2022-01-24 14:55:18',10,0),('1','185',256221,'AFTERNOON','2022-01-24','2022-01-24 00:00:00',NULL,'633',2712220.50,2712220.50,'633','2022-01-25 07:14:22','559','2022-01-25 07:44:48',10,0),('1','185',256360,'MORNING','2022-01-25','2022-01-25 00:00:00',NULL,'633',2466360.00,2466360.00,'633','2022-01-25 14:37:40','559','2022-01-25 14:43:20',10,0),('1','185',256495,'AFTERNOON','2022-01-25','2022-01-25 00:00:00',NULL,'633',3646118.70,3646118.70,'633','2022-01-26 07:44:15','559','2022-01-26 07:52:08',10,0),('1','185',256616,'MORNING','2022-01-26','2022-01-26 00:00:00',NULL,'633',2691955.95,2691955.95,'633','2022-01-26 14:52:30','559','2022-01-26 15:01:34',10,0),('1','185',256739,'AFTERNOON','2022-01-26','2022-01-26 00:00:00',NULL,'633',3378208.20,3378208.20,'633','2022-01-27 07:53:15','559','2022-01-27 08:10:08',10,0),('1','185',256849,'MORNING','2022-01-27','2022-01-27 00:00:00',NULL,'633',2232291.60,2232291.60,'633','2022-01-27 14:24:20','559','2022-01-27 14:45:00',10,0),('1','185',256956,'AFTERNOON','2022-01-27','2022-01-27 00:00:00',NULL,'633',3173565.60,3173565.60,'633','2022-01-28 06:42:53','559','2022-01-28 07:40:54',10,0),('1','185',257100,'MORNING','2022-01-28','2022-01-28 00:00:00',NULL,'633',2572415.85,2572415.85,'633','2022-01-28 14:28:29','559','2022-01-28 14:42:43',10,0),('1','185',257229,'AFTERNOON','2022-01-28','2022-01-28 00:00:00',NULL,'633',2786791.80,2786791.80,'633','2022-01-29 06:58:23','559','2022-01-29 07:46:04',10,0),('1','185',257361,'MORNING','2022-01-29','2022-01-29 00:00:00',NULL,'633',2667080.45,2667080.45,'633','2022-01-29 15:00:43','559','2022-01-29 15:04:36',10,0),('1','185',257491,'AFTERNOON','2022-01-29','2022-01-29 00:00:00',NULL,'633',3215374.45,3215374.45,'633','2022-01-30 07:23:11','559','2022-01-30 07:42:57',10,0),('1','185',257613,'MORNING','2022-01-30','2022-01-30 00:00:00',NULL,'633',2152258.30,2152258.30,'633','2022-01-30 14:31:49','559','2022-01-30 14:45:10',10,0),('1','185',257614,'AFTERNOON','2022-01-30','2022-01-30 00:00:00',NULL,'633',3116480.45,3116480.45,'633','2022-01-31 08:58:18','559','2022-01-31 09:04:48',10,0),('1','185',257615,'MORNING','2022-01-31','2022-01-31 00:00:00',NULL,'633',3197676.30,3197676.30,'633','2022-01-31 15:17:12','559','2022-01-31 15:18:28',10,0),('1','185',257616,'AFTERNOON','2022-01-31','2022-01-31 00:00:00',NULL,'633',3846048.75,3846048.75,'633','2022-02-01 08:02:31','559','2022-02-01 08:11:37',10,0),('1','185',257617,'MORNING','2022-02-01','2022-02-01 00:00:00',NULL,'633',3671721.25,3671721.25,'633','2022-02-01 14:36:11','559','2022-02-01 14:51:06',10,0),('1','185',257618,'AFTERNOON','2022-02-01','2022-02-01 00:00:00',NULL,'633',3543884.80,3543884.80,'633','2022-02-02 07:30:29','559','2022-02-02 07:36:14',10,0),('1','185',257619,'MORNING','2022-02-02','2022-02-02 00:00:00',NULL,'633',2648913.35,2648913.35,'633','2022-02-02 14:12:57','559','2022-02-02 14:36:17',10,0),('1','185',257620,'AFTERNOON','2022-02-02','2022-02-02 00:00:00',NULL,'633',2692731.35,2692731.35,'633','2022-02-03 07:28:18','559','2022-02-03 07:34:44',10,0),('1','185',257621,'MORNING','2022-02-03','2022-02-03 00:00:00',NULL,'633',4400027.60,4400027.60,'633','2022-02-03 14:46:25','559','2022-02-03 14:49:24',10,0),('1','185',257622,'AFTERNOON','2022-02-03','2022-02-03 00:00:00',NULL,'633',3255621.70,3255621.70,'633','2022-02-04 07:55:21','559','2022-02-04 07:57:50',10,0),('1','185',257623,'MORNING','2022-02-04','2022-02-04 00:00:00',NULL,'633',2126897.90,2126897.90,'633','2022-02-04 14:47:22','559','2022-02-04 15:21:00',10,0),('1','185',257624,'AFTERNOON','2022-02-04','2022-02-04 00:00:00',NULL,'633',2936529.85,2936529.85,'633','2022-02-05 07:58:28','559','2022-02-05 08:03:17',10,0),('1','185',257625,'MORNING','2022-02-05','2022-02-05 00:00:00',NULL,'633',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('1','185',257626,'MORNING','2022-02-05','2022-02-05 00:00:00',NULL,'633',2307844.80,2307844.80,'633','2022-02-05 14:26:23','559','2022-02-05 14:29:30',10,0),('1','185',257627,'AFTERNOON','2022-02-05','2022-02-05 00:00:00',NULL,'633',3070766.85,3070766.85,'633','2022-02-06 07:19:56','559','2022-02-06 07:27:54',10,0),('1','185',257628,'MORNING','2022-02-06','2022-02-06 00:00:00',NULL,'633',2459019.45,2459019.45,'633','2022-02-06 14:06:16','559','2022-02-06 14:39:05',10,0),('1','185',257629,'AFTERNOON','2022-02-06','2022-02-06 00:00:00',NULL,'633',2706719.05,2706719.05,'633','2022-02-07 07:57:04','559','2022-02-07 07:58:18',10,0),('1','185',257630,'DAY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'633',3227464.95,3227464.95,'633','2022-02-08 06:56:40','559','2022-02-08 07:36:09',10,0),('1','185',257631,'MORNING','2022-02-08','2022-02-08 00:00:00',NULL,'633',3976666.15,3976666.15,'633','2022-02-08 14:09:18','559','2022-02-08 14:59:47',10,0),('1','185',257632,'AFTERNOON','2022-02-08','2022-02-08 00:00:00',NULL,'633',4318352.85,4318352.85,'633','2022-02-09 07:27:46','559','2022-02-09 07:39:29',10,0),('1','185',257633,'DAY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'633',2210222.40,2210222.40,'633','2022-02-09 20:00:14','559','2022-02-10 07:46:42',10,0),('1','185',257634,'DAY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'633',1392179.10,1392179.10,'633','2022-02-10 19:59:36','559','2022-02-11 07:36:26',10,0),('1','185',257635,'DAY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'633',2087768.55,2087768.55,'633','2022-02-12 07:32:44','559','2022-02-12 08:05:51',10,0),('1','185',257636,'MORNING','2022-02-12','2022-02-12 00:00:00',NULL,'633',3714434.85,3714434.85,'633','2022-02-12 16:32:45','559','2022-02-12 16:38:24',10,0),('1','185',257637,'AFTERNOON','2022-02-12','2022-02-12 00:00:00',NULL,'633',1833653.25,1833653.25,'633','2022-02-13 07:14:17','559','2022-02-13 07:39:34',10,0),('1','185',257638,'MORNING','2022-02-13','2022-02-13 00:00:00',NULL,'633',4191556.65,4191556.65,'633','2022-02-13 14:38:38','559','2022-02-13 15:48:29',10,0),('1','185',257639,'AFTERNOON','2022-02-13','2022-02-13 00:00:00',NULL,'633',3262664.65,3262664.65,'633','2022-02-14 07:32:35','559','2022-02-14 07:35:01',10,0),('1','185',257640,'MORNING','2022-02-14','2022-02-14 00:00:00',NULL,'633',3130254.40,3130254.40,'633','2022-02-14 14:39:52','559','2022-02-14 14:47:02',10,0),('1','185',257641,'AFTERNOON','2022-02-14','2022-02-14 00:00:00',NULL,'633',436461.40,436461.40,'633','2022-02-15 07:19:01','559','2022-02-15 07:29:07',10,0),('1','185',257642,'DAY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'633',5052011.30,5052011.30,'633','2022-02-16 09:10:46','559','2022-02-16 10:02:11',10,0),('1','185',257643,'MORNING','2022-02-16','2022-02-16 00:00:00',NULL,'633',4488064.70,4488064.70,'633','2022-02-16 17:22:04','559','2022-02-16 17:40:06',10,0),('1','185',257644,'AFTERNOON','2022-02-16','2022-02-16 00:00:00',NULL,'633',3463741.20,3463741.20,'633','2022-02-17 07:32:54','559','2022-02-17 07:55:30',10,0),('1','185',257645,'MORNING','2022-02-17','2022-02-17 00:00:00',NULL,'633',3201503.50,3201503.50,'633','2022-02-18 07:32:30','559','2022-02-18 07:35:55',10,0),('1','185',257646,'AFTERNOON','2022-02-17','2022-02-17 00:00:00',NULL,'633',4875358.10,4875358.10,'633','2022-02-18 08:44:27','559','2022-02-18 08:53:17',10,0),('1','185',257647,'MORNING','2022-02-18','2022-02-18 00:00:00',NULL,'633',3973522.75,3973522.75,'633','2022-02-18 21:44:13','559','2022-02-19 07:20:25',10,0),('1','185',257648,'AFTERNOON','2022-02-18','2022-02-18 00:00:00',NULL,'633',2393999.45,2393999.45,'633','2022-02-19 08:09:36','559','2022-02-19 08:36:35',10,0),('1','185',257649,'MORNING','2022-02-19','2022-02-19 00:00:00',NULL,'633',4229433.30,4229433.30,'633','2022-02-19 15:00:00','559','2022-02-19 15:13:44',10,0),('1','185',257650,'AFTERNOON','2022-02-19','2022-02-19 00:00:00',NULL,'633',3626399.90,3626399.90,'633','2022-02-20 07:54:52','559','2022-02-20 08:24:48',10,0),('1','185',257651,'MORNING','2022-02-20','2022-02-20 00:00:00',NULL,'633',5690096.30,5690096.30,'633','2022-02-20 15:05:48','559','2022-02-20 15:29:30',10,0),('1','185',257652,'AFTERNOON','2022-02-20','2022-02-20 00:00:00',NULL,'633',3986456.70,3986456.70,'633','2022-02-21 07:49:59','559','2022-02-21 08:00:17',10,0),('1','185',257653,'MORNING','2022-02-21','2022-02-21 00:00:00',NULL,'633',4468502.50,4468502.50,'633','2022-02-21 15:11:39','559','2022-02-21 15:22:43',10,0),('1','185',257654,'AFTERNOON','2022-02-21','2022-02-22 07:42:58','2022-02-23 07:42:58','633',4175036.45,4175036.45,'633','2022-02-22 08:14:35','559','2022-02-22 08:19:36',10,0),('1','185',257655,'MORNING','2022-02-22','2022-02-22 14:53:35','2022-02-23 14:53:35','633',3777559.30,3777559.30,'633','2022-02-22 14:57:38','559','2022-02-22 15:23:22',10,0),('1','185',257656,'AFTERNOON','2022-02-22','2022-02-23 07:10:49','2022-02-24 07:10:49','633',3169981.65,3169981.65,'633','2022-02-23 07:55:54','559','2022-02-23 07:59:36',10,0),('1','185',257657,'DAY SHIFT','2022-02-23','2022-02-24 06:51:56','2022-02-25 06:51:56','633',1247478.30,1247478.30,'633','2022-02-24 06:59:42','559','2022-02-24 07:18:45',10,0),('1','185',257658,'DAY SHIFT','2022-02-24','2022-02-24 09:17:33','2022-02-25 09:17:33','633',1152772.40,1152772.40,'633','2022-02-25 06:29:55','559','2022-02-25 08:00:31',10,0),('1','185',257659,'DAY SHIFT','2022-02-25','2022-02-25 15:59:24','2022-02-26 15:59:24','633',3385714.05,3385714.05,'633','2022-02-26 09:58:08','559','2022-02-26 11:32:18',10,0),('1','185',257660,'MORNING','2022-02-26','2022-02-26 14:50:29','2022-02-27 14:50:29','633',5159503.05,5159503.05,'633','2022-02-26 15:10:42','559','2022-02-26 15:43:01',10,0),('1','185',257661,'AFTERNOON','2022-02-26','2022-02-27 07:49:56','2022-02-28 07:49:56','633',3976702.80,3976702.80,'633','2022-02-27 10:09:43','559','2022-02-27 10:10:40',10,0),('1','185',257662,'MORNING','2022-02-27','2022-02-27 18:36:31','2022-02-28 18:36:31','633',5751258.15,5751258.15,'633','2022-02-27 18:41:32','634','2022-02-27 19:34:55',10,0),('1','185',257663,'AFTERNOON','2022-02-27','2022-02-28 07:16:29','2022-03-01 07:16:29','633',3043914.75,3043914.75,'633','2022-02-28 09:05:52','559','2022-02-28 09:48:53',10,0),('1','185',257664,'MORNING','2022-02-28','2022-02-28 14:53:10','2022-03-01 14:53:10','633',1134139.05,1134139.05,'633','2022-02-28 14:56:10','559','2022-02-28 15:38:44',10,0),('1','185',257665,'AFTERNOON','2022-02-28','2022-03-01 09:34:02','2022-03-02 09:34:02','633',1453994.40,1453994.40,'633','2022-03-01 09:50:15','559','2022-03-01 15:09:22',10,0),('1','185',257666,'MORNING','2022-03-01','2022-03-01 21:19:23','2022-03-02 21:19:23','633',5363853.00,5363853.00,'633','2022-03-01 21:23:00','559','2022-03-02 07:44:56',10,0),('1','185',257667,'AFTERNOON','2022-03-01','2022-03-02 10:58:56','2022-03-03 10:58:56','633',3690103.80,3690103.80,'633','2022-03-02 11:02:44','634','2022-03-02 11:05:44',10,0),('1','185',257668,'MORNING','2022-03-02','2022-03-02 19:15:56','2022-03-03 19:15:56','633',3958919.85,3958919.85,'633','2022-03-02 19:39:56','559','2022-03-02 19:43:27',10,0),('1','185',257669,'AFTERNOON','2022-03-02','2022-03-02 22:43:24','2022-03-03 22:43:24','633',1858804.50,1858804.50,'633','2022-03-03 07:48:37','559','2022-03-03 08:02:46',10,0),('1','185',257670,'MORNING','2022-03-03','2022-03-03 17:05:21','2022-03-04 17:05:21','633',914508.80,914508.80,'633','2022-03-03 17:09:01','559','2022-03-03 20:25:33',10,0),('1','185',257671,'AFTERNOON','2022-03-03','2022-03-04 07:57:14','2022-03-05 07:57:14','633',1127091.90,1127091.90,'633','2022-03-04 12:41:37','559','2022-03-04 15:00:15',10,0),('1','185',257672,'MORNING','2022-03-04','2022-03-04 23:32:03','2022-03-05 23:32:03','633',5462283.75,5462283.75,'633','2022-03-04 23:37:11','559','2022-03-05 06:46:57',10,0),('1','185',257673,'AFTERNOON','2022-03-04','2022-03-05 08:11:29','2022-03-06 08:11:29','633',756272.55,756272.55,'633','2022-03-05 11:11:00','559','2022-03-05 12:04:06',10,0),('1','185',257674,'MORNING','2022-03-05','2022-03-06 11:05:19','2022-03-07 11:05:19','633',5093484.00,5093484.00,'633','2022-03-06 11:29:41','559','2022-03-06 13:20:19',10,0),('1','185',257675,'AFTERNOON','2022-03-05','2022-03-06 20:38:48','2022-03-07 20:38:48','633',2332060.50,2332060.50,'633','2022-03-06 20:40:27','559','2022-03-06 20:45:29',10,0),('1','185',257676,'MORNING','2022-03-06','2022-03-06 21:08:06','2022-03-07 21:08:06','633',4112006.25,4112006.25,'633','2022-03-07 08:06:59','559','2022-03-07 08:12:51',10,0),('1','185',257677,'AFTERNOON','2022-03-06','2022-03-07 08:13:42','2022-03-08 08:13:42','633',5036714.10,5036714.10,'633','2022-03-07 10:14:54','559','2022-03-07 10:18:46',10,0),('1','185',257678,'MORNING','2022-03-07','2022-03-07 23:41:46','2022-03-08 23:41:46','633',1934945.50,1934945.50,'633','2022-03-08 07:53:36','559','2022-03-08 08:21:12',10,0),('1','185',257679,'AFTERNOON','2022-03-07','2022-03-08 09:04:22','2022-03-09 09:04:22','633',1240265.00,1240265.00,'633','2022-03-08 10:08:14','559','2022-03-08 14:36:45',10,0),('1','185',257680,'MORNING','2022-03-08','2022-03-08 17:01:40','2022-03-09 17:01:40','633',4841856.80,4841856.80,'633','2022-03-08 17:05:05','559','2022-03-08 17:14:45',10,0),('1','185',257681,'AFTERNOON','2022-03-08','2022-03-09 19:28:49','2022-03-10 19:28:49','633',4531326.55,4531326.55,'633','2022-03-09 19:52:50','559','2022-03-09 20:03:54',10,0),('1','185',257682,'MORNING','2022-03-09','2022-03-09 20:14:10','2022-03-10 20:14:10','633',6137808.00,6137808.00,'633','2022-03-09 20:25:35','559','2022-03-09 20:34:22',10,0),('1','185',257683,'AFTERNOON','2022-03-09','2022-03-10 09:08:12','2022-03-11 09:08:12','633',3294273.90,3294273.90,'633','2022-03-10 09:39:05','559','2022-03-10 15:06:49',10,0),('1','185',257684,'MORNING','2022-03-10','2022-03-11 07:56:39','2022-03-12 07:56:39','633',4765263.30,4765263.30,'633','2022-03-11 08:06:57','559','2022-03-11 08:30:02',10,0),('1','185',257685,'AFTERNOON','2022-03-10','2022-03-11 08:31:51','2022-03-12 08:31:51','633',2944072.20,2944072.20,'633','2022-03-11 08:39:55','559','2022-03-11 13:27:05',10,0),('1','185',257686,'MORNING','2022-03-11','2022-03-11 15:41:13','2022-03-12 15:41:13','633',6749572.50,6749572.50,'633','2022-03-11 15:50:37','559','2022-03-12 07:28:31',10,0),('1','185',257687,'AFTERNOON','2022-03-11','2022-03-12 20:00:36','2022-03-13 20:00:36','633',5091765.00,5091765.00,'633','2022-03-12 20:20:17','559','2022-03-12 20:23:58',10,0),('1','185',257688,'MORNING','2022-03-12','2022-03-12 20:35:18','2022-03-13 20:35:18','633',5660814.90,5660814.90,'633','2022-03-12 20:44:30','559','2022-03-12 22:30:54',10,0),('1','185',257689,'AFTERNOON','2022-03-12','2022-03-13 09:16:34','2022-03-14 09:16:34','633',2627681.10,2627681.10,'633','2022-03-14 08:27:37','559','2022-03-14 08:33:18',10,0),('1','185',257690,'MORNING','2022-03-13','2022-03-14 09:19:02','2022-03-15 09:19:02','633',4259410.80,4259410.80,'633','2022-03-14 09:28:19','559','2022-03-14 09:31:22',10,0),('1','185',257691,'AFTERNOON','2022-03-13','2022-03-14 09:33:40','2022-03-15 09:33:40','633',1365851.55,1365851.55,'633','2022-03-14 11:54:02','559','2022-03-14 12:02:21',10,0),('1','185',257692,'MORNING','2022-03-14','2022-03-15 20:06:26','2022-03-16 20:06:26','633',1410651.90,1410651.90,'633','2022-03-15 20:09:57','559','2022-03-15 20:26:59',10,0),('1','185',257693,'AFTERNOON','2022-03-14','2022-03-15 21:57:20','2022-03-16 21:57:20','633',2359402.35,2359402.35,'633','2022-03-15 21:59:37','559','2022-03-15 22:03:51',10,0),('1','185',257694,'MORNING','2022-03-15','2022-03-15 22:11:20','2022-03-16 22:11:20','633',5866175.45,5866175.45,'633','2022-03-15 22:15:42','559','2022-03-15 22:17:21',10,0),('1','185',257695,'AFTERNOON','2022-03-15','2022-03-16 07:48:54','2022-03-17 07:48:54','633',4085005.85,4085005.85,'633','2022-03-16 09:02:11','559','2022-03-16 12:10:45',10,0),('1','185',257696,'MORNING','2022-03-16','2022-03-16 19:55:03','2022-03-17 19:55:03','633',5719708.50,5719708.50,'633','2022-03-16 20:03:14','559','2022-03-16 20:04:19',10,0),('1','185',257697,'AFTERNOON','2022-03-16','2022-03-17 11:04:16','2022-03-18 11:04:16','633',2968226.25,2968226.25,'633','2022-03-17 11:11:25','559','2022-03-17 12:19:37',10,0),('1','185',257698,'MORNING','2022-03-17','2022-03-17 19:55:39','2022-03-18 19:55:39','633',5273525.40,5273525.40,'633','2022-03-17 20:01:05','559','2022-03-18 07:52:21',10,0),('1','185',257699,'AFTERNOON','2022-03-17','2022-03-18 07:54:10','2022-03-19 07:54:10','633',2588135.55,2588135.55,'633','2022-03-18 10:26:39','559','2022-03-18 11:00:22',10,0),('1','185',257700,'MORNING','2022-03-18','2022-03-18 18:13:55','2022-03-19 18:13:55','633',5840729.70,5840729.70,'633','2022-03-18 20:41:26','559','2022-03-18 20:58:52',10,0),('1','185',257701,'AFTERNOON','2022-03-18','2022-03-19 11:07:45','2022-03-20 11:07:45','633',6550722.00,6550722.00,'633','2022-03-19 11:15:39','559','2022-03-19 11:19:13',10,0),('1','185',257702,'MORNING','2022-03-19','2022-03-19 12:54:31','2022-03-20 12:54:31','633',0.00,0.00,'633','2022-03-19 18:13:34','559','2022-03-19 18:16:53',10,0),('1','185',257703,'MORNING','2022-03-19','2022-03-19 18:34:27','2022-03-20 18:34:27','633',5338113.20,5338113.20,'633','2022-03-19 18:43:10','559','2022-03-19 18:46:31',10,0),('1','185',257704,'AFTERNOON','2022-03-19','2022-03-20 09:46:26','2022-03-21 09:46:26','633',3424141.10,3424141.10,'633','2022-03-20 10:01:45','559','2022-03-20 10:07:08',10,0),('1','185',257705,'MORNING','2022-03-20','2022-03-20 19:13:15','2022-03-21 19:13:15','633',4270428.80,4270428.80,'633','2022-03-20 19:24:08','559','2022-03-20 20:06:23',10,0),('1','185',257706,'AFTERNOON','2022-03-20','2022-03-21 00:02:59','2022-03-22 00:02:59','633',1253940.40,1253940.40,'633','2022-03-21 00:06:14','559','2022-03-21 07:55:09',10,0),('1','185',257707,'MORNING','2022-03-21','2022-03-22 06:32:08','2022-03-23 06:32:08','633',596931.20,596931.20,'633','2022-03-22 06:32:52','559','2022-03-22 06:45:46',10,0),('1','185',257708,'AFTERNOON','2022-03-21','2022-03-22 06:47:02','2022-03-23 06:47:02','633',1151777.20,1151777.20,'633','2022-03-22 06:48:12','559','2022-03-22 14:25:42',10,0),('1','185',257709,'MORNING','2022-03-22','2022-03-22 17:02:46','2022-03-23 17:02:46','633',7467353.00,7467353.00,'633','2022-03-22 17:10:20','559','2022-03-22 20:47:08',10,0),('1','185',257710,'AFTERNOON','2022-03-22','2022-03-23 06:59:42','2022-03-24 06:59:42','633',1618141.80,1618141.80,'633','2022-03-23 07:06:40','559','2022-03-23 07:15:19',10,0),('1','185',257711,'MORNING','2022-03-23','2022-03-23 19:37:57','2022-03-24 19:37:57','633',5602883.20,5602883.20,'633','2022-03-23 20:04:12','559','2022-03-24 07:11:42',10,0),('1','185',257712,'AFTERNOON','2022-03-23','2022-03-24 07:14:20','2022-03-25 07:14:20','633',1333310.00,1333310.00,'633','2022-03-24 07:21:19','559','2022-03-24 07:24:51',10,0),('1','185',257713,'MORNING','2022-03-24','2022-03-24 19:44:08','2022-03-25 19:44:08','633',6459081.45,6459081.45,'633','2022-03-24 19:50:19','559','2022-03-24 20:25:09',10,0),('1','185',257714,'AFTERNOON','2022-03-24','2022-03-25 08:24:39','2022-03-26 08:24:39','633',4499730.30,4499730.30,'633','2022-03-25 09:28:23','634','2022-03-25 09:31:57',10,0),('1','185',257715,'MORNING','2022-03-25','2022-03-25 19:33:10','2022-03-26 19:33:10','633',5858619.30,5858619.30,'633','2022-03-25 19:43:07','559','2022-03-26 07:45:49',10,0),('1','185',257716,'AFTERNOON','2022-03-25','2022-03-26 12:42:27','2022-03-27 12:42:27','633',2096410.90,2096410.90,'633','2022-03-26 12:50:24','559','2022-03-26 15:33:24',10,0),('1','185',257717,'MORNING','2022-03-26','2022-03-26 15:36:04','2022-03-27 15:36:04','633',4866022.15,4866022.15,'633','2022-03-26 15:46:06','559','2022-03-27 07:11:08',10,0),('1','185',257718,'AFTERNOON','2022-03-26','2022-03-27 17:48:28','2022-03-28 17:48:28','633',793868.70,793868.70,'633','2022-03-27 23:42:37','559','2022-03-28 06:24:51',10,0),('1','185',257719,'MORNING','2022-03-27','2022-03-28 09:37:12','2022-03-29 09:37:12','633',3351574.50,3351574.50,'633','2022-03-28 09:39:39','634','2022-03-28 10:15:57',10,0),('1','185',257720,'AFTERNOON','2022-03-27','2022-03-28 11:16:54','2022-03-29 11:16:54','633',598413.60,598413.60,'633','2022-03-28 11:23:54','559','2022-03-28 13:36:36',10,0),('1','185',257721,'MORNING','2022-03-28','2022-03-28 20:35:41','2022-03-29 20:35:41','633',502302.40,502302.40,'633','2022-03-28 20:36:37','559','2022-03-28 20:58:26',10,0),('1','185',257722,'AFTERNOON','2022-03-28','2022-03-29 06:55:43','2022-03-30 06:55:43','633',1114465.60,1114465.60,'633','2022-03-29 08:31:10','559','2022-03-29 09:37:04',10,0),('1','185',257723,'MORNING','2022-03-29','2022-03-29 16:04:07','2022-03-30 16:04:07','633',5041971.80,5041971.80,'633','2022-03-29 16:09:51','559','2022-03-29 17:36:45',10,0),('1','185',257724,'AFTERNOON','2022-03-29','2022-03-30 09:30:38','2022-03-31 09:30:38','633',4032022.30,4032022.30,'633','2022-03-30 09:54:54','634','2022-03-30 10:00:41',10,0),('1','185',257725,'MORNING','2022-03-30','2022-03-30 15:22:41','2022-03-31 15:22:41','633',4395393.85,4395393.85,'633','2022-03-30 15:46:05','559','2022-03-30 15:52:22',10,0),('1','185',257726,'AFTERNOON','2022-03-30','2022-03-31 06:45:36','2022-04-01 06:45:36','633',3703022.20,3703022.20,'633','2022-03-31 06:59:38','559','2022-03-31 07:13:17',10,0),('1','185',257727,'MORNING','2022-03-31','2022-03-31 14:32:38','2022-04-01 14:32:38','633',5255819.95,5255819.95,'633','2022-03-31 14:36:48','559','2022-03-31 14:48:25',10,0),('1','185',257728,'AFTERNOON','2022-03-31','2022-04-01 06:25:04','2022-04-02 06:25:04','633',2778186.75,2778186.75,'633','2022-04-01 06:38:28','559','2022-04-01 07:22:55',10,0),('1','185',257729,'MORNING','2022-04-01','2022-04-01 14:40:29','2022-04-02 14:40:29','633',5096817.85,5096817.85,'633','2022-04-01 14:44:42','559','2022-04-01 14:56:12',10,0),('1','185',257730,'AFTERNOON','2022-04-01','2022-04-02 05:58:51','2022-04-03 05:58:51','633',3318619.45,3318619.45,'633','2022-04-02 06:11:40','559','2022-04-02 07:09:38',10,0),('1','185',257731,'MORNING','2022-04-02','2022-04-02 14:16:58','2022-04-03 14:16:58','633',5496794.30,5496794.30,'633','2022-04-02 14:21:49','559','2022-04-02 14:43:40',10,0),('1','185',257732,'AFTERNOON','2022-04-02','2022-04-03 06:04:27','2022-04-04 06:04:27','633',6061574.60,6061574.60,'633','2022-04-03 06:18:36','559','2022-04-03 07:38:30',10,0),('1','185',257733,'MORNING','2022-04-03','2022-04-03 14:13:56','2022-04-04 14:13:56','633',3674140.65,3674140.65,'633','2022-04-03 14:16:55','559','2022-04-03 14:49:36',10,0),('1','185',257734,'AFTERNOON','2022-04-03','2022-04-04 05:53:20','2022-04-05 05:53:20','633',2042076.55,2042076.55,'633','2022-04-04 06:04:40','559','2022-04-04 08:10:20',10,0),('1','185',257735,'MORNING','2022-04-04','2022-04-04 14:10:25','2022-04-05 14:10:25','633',5192908.55,5192908.55,'633','2022-04-04 14:43:57','559','2022-04-04 14:54:17',10,0),('1','185',257736,'AFTERNOON','2022-04-04','2022-04-05 05:49:23','2022-04-06 05:49:23','633',3394592.85,3394592.85,'633','2022-04-05 06:05:00','559','2022-04-05 07:07:32',10,0),('1','185',257737,'MORNING','2022-04-05','2022-04-05 14:10:34','2022-04-06 14:10:34','633',4636007.75,4636007.75,'633','2022-04-05 14:20:36','559','2022-04-05 14:37:52',10,0),('1','185',257738,'AFTERNOON','2022-04-05','2022-04-06 05:55:00','2022-04-07 05:55:00','633',3146853.15,3146853.15,'633','2022-04-06 06:04:35','559','2022-04-06 07:18:20',10,0),('1','185',257739,'MORNING','2022-04-06','2022-04-06 13:43:12','2022-04-07 13:43:12','633',5316749.45,5316749.45,'633','2022-04-06 13:51:10','559','2022-04-06 14:00:24',10,0),('1','185',257740,'AFTERNOON','2022-04-06','2022-04-07 05:56:34','2022-04-08 05:56:34','633',6183403.25,6183403.25,'633','2022-04-07 06:09:38','559','2022-04-07 07:14:02',10,0),('1','185',257741,'MORNING','2022-04-07','2022-04-07 14:04:35','2022-04-08 14:04:35','633',5184062.65,5184062.65,'633','2022-04-07 14:13:22','559','2022-04-07 14:37:36',10,0),('1','185',257742,'AFTERNOON','2022-04-07','2022-04-08 06:15:25','2022-04-09 06:15:25','633',3473950.00,3473950.00,'633','2022-04-08 06:28:18','559','2022-04-08 06:57:45',10,0),('1','185',257743,'MORNING','2022-04-08','2022-04-08 13:50:39','2022-04-09 13:50:39','633',2246847.75,2246847.75,'633','2022-04-08 13:54:06','559','2022-04-08 15:19:12',10,0),('1','185',257744,'AFTERNOON','2022-04-08','2022-04-09 06:04:07','2022-04-10 06:04:07','633',626252.80,626252.80,'633','2022-04-09 06:08:05','559','2022-04-09 07:19:32',10,0),('1','185',257745,'MORNING','2022-04-09','2022-04-09 13:55:18','2022-04-10 13:55:18','633',5825618.20,5825618.20,'633','2022-04-09 14:32:47','559','2022-04-09 14:39:43',10,0),('1','185',257746,'AFTERNOON','2022-04-09','2022-04-10 06:01:48','2022-04-11 06:01:48','633',3563273.40,3563273.40,'633','2022-04-10 06:32:48','559','2022-04-10 06:44:37',10,0),('1','185',257747,'MORNING','2022-04-10','2022-04-10 13:48:36','2022-04-11 13:48:36','633',3814369.35,3814369.35,'633','2022-04-10 14:12:40','559','2022-04-10 14:21:06',10,0),('1','185',257748,'AFTERNOON','2022-04-10','2022-04-11 06:00:41','2022-04-12 06:00:41','633',2097800.10,2097800.10,'633','2022-04-11 06:09:18','559','2022-04-11 07:08:35',10,0),('1','185',257749,'DAY SHIFT','2022-04-11','2022-04-11 19:43:43','2022-04-12 19:43:43','633',2458872.90,2458872.90,'633','2022-04-11 19:46:48','559','2022-04-12 04:56:09',10,0),('1','185',257750,'MORNING','2022-04-12','2022-04-12 06:05:40','2022-04-13 06:05:40','633',4553744.25,4553744.25,'633','2022-04-12 14:18:01','559','2022-04-12 14:27:01',10,0),('1','185',257751,'AFTERNOON','2022-04-12','2022-04-13 06:00:11','2022-04-14 06:00:11','633',3710166.95,3710166.95,'633','2022-04-13 06:27:18','559','2022-04-13 07:23:25',10,0),('1','185',257752,'MORNING','2022-04-13','2022-04-13 14:45:20','2022-04-14 14:45:20','633',3941174.55,3941174.55,'633','2022-04-13 14:51:53','559','2022-04-13 15:12:47',10,0),('1','185',257753,'AFTERNOON','2022-04-13','2022-04-14 06:02:44','2022-04-15 06:02:44','633',3534506.60,3534506.60,'633','2022-04-14 06:16:01','559','2022-04-14 07:13:32',10,0),('1','185',257754,'MORNING','2022-04-14','2022-04-14 14:53:57','2022-04-15 14:53:57','633',7022162.00,7022162.00,'633','2022-04-14 14:59:13','559','2022-04-14 15:03:58',10,0),('1','185',257755,'AFTERNOON','2022-04-14','2022-04-15 05:49:20','2022-04-16 05:49:20','633',4851928.75,4851928.75,'633','2022-04-15 06:01:30','559','2022-04-15 06:03:40',10,0),('1','185',257756,'MORNING','2022-04-15','2022-04-15 14:46:13','2022-04-16 14:46:13','633',4298623.75,4298623.75,'633','2022-04-15 14:52:55','559','2022-04-15 15:38:29',10,0),('1','185',257757,'AFTERNOON','2022-04-16','2022-04-16 05:48:04','2022-04-17 05:48:04','633',4253996.50,4253996.50,'633','2022-04-16 05:58:33','559','2022-04-16 07:09:09',10,0),('1','185',257758,'MORNING','2022-04-16','2022-04-16 14:23:25','2022-04-17 14:23:25','633',3950337.60,3950337.60,'633','2022-04-16 14:30:05','559','2022-04-16 15:09:43',10,0),('1','185',257759,'AFTERNOON','2022-04-16','2022-04-17 06:06:34','2022-04-18 06:06:34','633',3097525.20,3097525.20,'633','2022-04-17 06:20:00','559','2022-04-17 07:14:44',10,0),('1','185',257760,'MORNING','2022-04-17','2022-04-17 14:17:39','2022-04-18 14:17:39','633',2811824.40,2811824.40,'633','2022-04-17 14:22:38','559','2022-04-17 14:30:08',10,0),('1','185',257761,'AFTERNOON','2022-04-17','2022-04-18 05:58:07','2022-04-19 05:58:07','633',2921501.55,2921501.55,'633','2022-04-18 06:10:16','559','2022-04-18 06:40:55',10,0),('1','185',257762,'MORNING','2022-04-18','2022-04-18 14:21:26','2022-04-19 14:21:26','633',3789657.30,3789657.30,'633','2022-04-18 14:25:02','559','2022-04-18 14:34:32',10,0),('1','185',257763,'AFTERNOON','2022-04-18','2022-04-19 05:58:31','2022-04-20 05:58:31','633',3062383.50,3062383.50,'633','2022-04-19 06:10:32','559','2022-04-19 07:36:27',10,0),('1','185',257764,'MORNING','2022-04-19','2022-04-19 14:18:01','2022-04-20 14:18:01','633',3900220.50,3900220.50,'633','2022-04-19 14:23:42','559','2022-04-19 15:09:31',10,0),('1','185',257765,'AFTERNOON','2022-04-19','2022-04-20 05:54:32','2022-04-21 05:54:32','633',3176804.40,3176804.40,'633','2022-04-20 06:06:31','559','2022-04-20 07:26:33',10,0),('1','185',257766,'DAY SHIFT','2022-04-20','2022-04-21 05:49:31','2022-04-22 05:49:31','633',2890839.95,2890839.95,'633','2022-04-21 06:01:44','559','2022-04-21 06:58:17',10,0),('1','185',257767,'MORNING','2022-04-21','2022-04-21 13:59:41','2022-04-22 13:59:41','633',4952899.10,4952899.10,'633','2022-04-21 14:04:07','559','2022-04-21 14:42:25',10,0),('1','185',257768,'AFTERNOON','2022-04-21','2022-04-22 05:37:25','2022-04-23 05:37:25','633',3652706.40,3652706.40,'633','2022-04-22 05:45:24','559','2022-04-22 07:21:08',10,0),('1','185',257769,'MORNING','2022-04-22','2022-04-22 14:58:13','2022-04-23 14:58:13','633',4850743.50,4850743.50,'633','2022-04-22 15:04:00','559','2022-04-22 16:19:27',10,0),('1','185',257770,'AFTERNOON','2022-04-22','2022-04-23 06:00:30','2022-04-24 06:00:30','633',3347517.80,3347517.80,'633','2022-04-23 06:07:27','559','2022-04-23 07:49:50',10,0),('1','185',257771,'MORNING','2022-04-23','2022-04-23 14:10:04','2022-04-24 14:10:04','633',4930585.40,4930585.40,'633','2022-04-23 14:14:40','559','2022-04-23 14:57:01',10,0),('1','185',257772,'AFTERNOON','2022-04-23','2022-04-24 05:44:25','2022-04-25 05:44:25','633',4221743.10,4221743.10,'633','2022-04-24 05:57:54','559','2022-04-24 07:26:49',10,0),('1','185',257773,'MORNING','2022-04-24','2022-04-24 16:07:43','2022-04-25 16:07:43','633',1868776.05,1868776.05,'633','2022-04-24 16:16:38','559','2022-04-24 19:57:25',10,0),('1','185',257774,'AFTERNOON','2022-04-24','2022-04-25 06:48:42','2022-04-26 06:48:42','633',1285642.00,1285642.00,'633','2022-04-25 06:52:22','559','2022-04-25 07:09:11',10,0),('1','185',257775,'MORNING','2022-04-25','2022-04-26 08:04:46','2022-04-27 08:04:46','633',443142.40,443142.40,'633','2022-04-26 08:05:28','559','2022-04-26 08:18:16',10,0),('1','185',257776,'AFTERNOON','2022-04-25','2022-04-26 08:21:34','2022-04-27 08:21:34','633',3384550.40,3384550.40,'633','2022-04-26 08:23:54','559','2022-04-26 08:26:17',10,0),('1','185',257777,'MORNING','2022-04-26','2022-04-26 16:52:09','2022-04-27 16:52:09','633',4312042.40,4312042.40,'633','2022-04-26 16:58:58','559','2022-04-26 17:03:47',10,0),('1','185',257778,'AFTERNOON','2022-04-26','2022-04-27 05:58:28','2022-04-28 05:58:28','633',3877453.95,3877453.95,'633','2022-04-27 06:11:56','559','2022-04-27 07:17:08',10,0),('1','185',257779,'MORNING','2022-04-27','2022-04-27 13:19:01','2022-04-28 13:19:01','633',4093848.95,4093848.95,'633','2022-04-27 13:29:29','559','2022-04-27 14:54:34',10,0),('1','185',257780,'AFTERNOON','2022-04-27','2022-04-28 05:47:06','2022-04-29 05:47:06','633',4986317.95,4986317.95,'633','2022-04-28 05:59:02','559','2022-04-28 07:42:50',10,0),('1','185',257781,'MORNING','2022-04-28','2022-04-28 14:46:07','2022-04-29 14:46:07','633',4506955.75,4506955.75,'633','2022-04-28 14:51:01','559','2022-04-28 14:53:46',10,0),('1','185',257782,'AFTERNOON','2022-04-28','2022-04-29 05:42:57','2022-04-30 05:42:57','633',4456693.80,4456693.80,'633','2022-04-29 06:02:22','559','2022-04-29 07:40:18',10,0),('1','185',257783,'MORNING','2022-04-29','2022-04-29 14:52:05','2022-04-30 14:52:05','633',4253135.45,4253135.45,'633','2022-04-29 14:55:14','559','2022-04-29 15:15:23',10,0),('1','185',257784,'AFTERNOON','2022-04-29','2022-04-30 05:47:26','2022-05-01 05:47:26','633',4150728.35,4150728.35,'633','2022-04-30 05:55:23','559','2022-04-30 07:44:08',10,0),('1','185',257785,'MORNING','2022-04-30','2022-04-30 14:35:10','2022-05-01 14:35:10','633',5303567.10,5303567.10,'633','2022-04-30 14:40:03','559','2022-04-30 14:50:13',10,0),('1','185',257786,'AFTERNOON','2022-04-30','2022-05-01 05:44:14','2022-05-02 05:44:14','633',5694139.30,5694139.30,'633','2022-05-01 05:53:00','559','2022-05-01 07:36:59',10,0),('1','185',257787,'MORNING','2022-05-01','2022-05-01 15:07:15','2022-05-02 15:07:15','633',3489173.40,3489173.40,'633','2022-05-01 15:12:43','559','2022-05-01 15:15:03',10,0),('1','185',257788,'AFTERNOON','2022-05-01','2022-05-02 06:56:30','2022-05-03 06:56:30','633',5156933.70,5156933.70,'633','2022-05-02 07:03:24','559','2022-05-02 08:03:43',10,0),('1','185',257789,'MORNING','2022-05-02','2022-05-02 12:41:19','2022-05-03 12:41:19','633',2426601.55,2426601.55,'633','2022-05-02 13:24:12','559','2022-05-02 14:53:29',10,0),('1','185',257790,'AFTERNOON','2022-05-02','2022-05-03 06:59:35','2022-05-04 06:59:35','633',3467636.05,3467636.05,'633','2022-05-03 07:09:06','559','2022-05-03 07:52:10',10,0),('1','185',257791,'MORNING','2022-05-03','2022-05-03 15:06:56','2022-05-04 15:06:56','633',2339754.10,2339754.10,'633','2022-05-03 15:11:17','559','2022-05-03 15:24:43',10,0),('1','185',257792,'AFTERNOON','2022-05-03','2022-05-04 07:37:44','2022-05-05 07:37:44','633',2647369.05,2647369.05,'633','2022-05-04 07:43:17','559','2022-05-04 08:54:26',10,0),('1','185',257793,'MORNING','2022-05-04','2022-05-04 13:53:23','2022-05-05 13:53:23','633',2515207.20,2515207.20,'633','2022-05-04 13:57:07','559','2022-05-04 15:00:30',10,0),('1','185',257794,'AFTERNOON','2022-05-04','2022-05-05 05:52:22','2022-05-06 05:52:22','633',3297107.10,3297107.10,'633','2022-05-05 05:59:06','559','2022-05-05 07:38:01',10,0),('1','185',257795,'MORNING','2022-05-05','2022-05-05 13:29:31','2022-05-06 13:29:31','633',2368644.00,2368644.00,'633','2022-05-05 13:39:15','559','2022-05-05 14:58:13',10,0),('1','185',257796,'AFTERNOON','2022-05-05','2022-05-06 05:55:42','2022-05-07 05:55:42','633',805779.60,805779.60,'633','2022-05-06 06:02:09','559','2022-05-06 07:28:13',10,0),('1','185',257797,'MORNING','2022-05-06','2022-05-06 15:08:02','2022-05-07 15:08:02','633',3599362.80,3599362.80,'633','2022-05-06 15:14:12','559','2022-05-06 15:30:37',10,0),('1','185',257798,'AFTERNOON','2022-05-06','2022-05-07 05:52:36','2022-05-08 05:52:36','633',3290319.45,3290319.45,'633','2022-05-07 05:59:40','559','2022-05-07 06:24:53',10,0),('1','185',257799,'MORNING','2022-05-07','2022-05-07 13:48:41','2022-05-08 13:48:41','633',3421369.05,3421369.05,'633','2022-05-07 13:53:14','559','2022-05-07 14:53:38',10,0),('1','185',257800,'AFTERNOON','2022-05-07','2022-05-08 06:45:55','2022-05-09 06:45:55','633',4063948.35,4063948.35,'633','2022-05-08 06:53:38','559','2022-05-08 07:33:29',10,0),('1','185',257801,'MORNING','2022-05-08','2022-05-08 14:38:00','2022-05-09 14:38:00','633',5087393.80,5087393.80,'633','2022-05-08 14:50:12','559','2022-05-08 14:57:01',10,0),('1','185',257802,'AFTERNOON','2022-05-08','2022-05-09 05:59:46','2022-05-10 05:59:46','633',6208310.95,6208310.95,'633','2022-05-09 06:09:54','559','2022-05-09 06:56:39',10,0),('1','185',257803,'MORNING','2022-05-09','2022-05-09 14:23:21','2022-05-10 14:23:21','633',1798954.10,1798954.10,'633','2022-05-09 14:28:16','559','2022-05-09 14:49:27',10,0),('1','185',257804,'AFTERNOON','2022-05-09','2022-05-10 05:41:24','2022-05-11 05:41:24','633',1235709.60,1235709.60,'633','2022-05-10 05:43:00','559','2022-05-10 08:09:58',10,0),('1','185',257805,'MORNING','2022-05-10','2022-05-10 14:56:24','2022-05-11 14:56:24','633',5027459.75,5027459.75,'633','2022-05-10 15:06:08','559','2022-05-10 15:19:18',10,0),('1','185',257806,'MORNING','2022-05-10','2022-05-11 05:45:08','2022-05-12 05:45:08','633',0.00,0.00,'633','2022-05-11 06:12:48','559','2022-05-11 06:15:12',10,0),('1','185',257807,'AFTERNOON','2022-05-10','2022-05-11 06:19:03','2022-05-12 06:19:03','633',1880956.00,1880956.00,'633','2022-05-11 06:20:00','559','2022-05-11 06:23:30',10,0),('1','185',257808,'MORNING','2022-05-11','2022-05-11 10:09:47','2022-05-12 10:09:47','633',6936387.60,6936387.60,'633','2022-05-11 14:09:30','559','2022-05-11 14:12:47',10,0),('1','185',257809,'AFTERNOON','2022-05-11','2022-05-12 07:44:58','2022-05-13 07:44:58','633',1174222.00,1174222.00,'633','2022-05-12 07:48:48','559','2022-05-12 07:51:17',10,0),('1','185',257810,'MORNING','2022-05-12','2022-05-12 09:50:22','2022-05-13 09:50:22','633',6526591.95,6526591.95,'633','2022-05-12 16:02:13','559','2022-05-12 16:17:29',10,0),('1','185',257811,'MORNING','2022-05-13','2022-05-13 08:26:05','2022-05-14 08:26:05','633',5690544.75,5690544.75,'633','2022-05-13 15:23:20','559','2022-05-13 15:28:24',10,0),('1','185',257812,'AFTERNOON','2022-05-13','2022-05-13 16:59:07','2022-05-14 16:59:07','633',1040755.65,1040755.65,'633','2022-05-13 17:40:19','559','2022-05-13 17:41:30',10,0),('1','185',257813,'MORNING','2022-05-14','2022-05-14 08:53:44','2022-05-15 08:53:44','633',4983595.65,4983595.65,'633','2022-05-14 14:57:07','559','2022-05-14 14:59:05',10,0),('1','185',257814,'AFTERNOON','2022-05-14','2022-05-14 17:33:31','2022-05-15 17:33:31','633',807407.70,807407.70,'633','2022-05-14 17:37:14','559','2022-05-14 17:38:55',10,0),('1','185',257815,'MORNING','2022-05-15','2022-05-15 09:30:20','2022-05-16 09:30:20','633',2581000.95,2581000.95,'633','2022-05-15 14:56:11','559','2022-05-15 14:58:03',10,0),('1','185',257816,'AFTERNOON','2022-05-15','2022-05-15 17:12:42','2022-05-16 17:12:42','633',1328352.30,1328352.30,'633','2022-05-15 17:16:35','559','2022-05-15 17:19:47',10,0),('1','185',257817,'AFTERNOON','2022-05-16','2022-05-17 08:35:05','2022-05-18 08:35:05','633',292705.00,292705.00,'633','2022-05-17 08:47:54','559','2022-05-17 08:50:26',10,0),('1','185',257818,'MORNING','2022-05-17','2022-05-17 11:41:18','2022-05-18 11:41:18','633',3175851.30,3175851.30,'633','2022-05-17 15:01:43','559','2022-05-17 15:03:54',10,0),('1','185',257819,'AFTERNOON','2022-05-17','2022-05-18 07:19:04','2022-05-19 07:19:04','633',4843733.60,4843733.60,'633','2022-05-18 07:36:16','559','2022-05-18 07:38:50',10,0),('1','185',257820,'MORNING','2022-05-18','2022-05-18 14:48:05','2022-05-19 14:48:05','633',3259333.20,3259333.20,'633','2022-05-18 15:01:29','559','2022-05-18 15:05:17',10,0),('1','185',257821,'AFTERNOON','2022-05-18','2022-05-19 07:49:42','2022-05-20 07:49:42','633',3797635.05,3797635.05,'633','2022-05-19 07:56:28','559','2022-05-19 07:59:35',10,0),('1','185',257822,'MORNING','2022-05-19','2022-05-19 08:16:08','2022-05-20 08:16:08','633',4916673.30,4916673.30,'633','2022-05-19 14:57:42','559','2022-05-19 15:00:26',10,0),('1','185',257823,'AFTERNOON','2022-05-19','2022-05-20 08:14:57','2022-05-21 08:14:57','633',1662155.55,1662155.55,'633','2022-05-20 08:21:53','559','2022-05-20 08:24:29',10,0),('1','185',257824,'MORNING','2022-05-20','2022-05-20 09:15:45','2022-05-21 09:15:45','633',6183850.20,6183850.20,'633','2022-05-20 15:00:51','559','2022-05-20 15:05:17',10,0),('1','185',257825,'AFTERNOON','2022-05-20','2022-05-21 08:10:07','2022-05-22 08:10:07','633',449824.65,449824.65,'633','2022-05-21 08:28:37','559','2022-05-21 08:37:29',10,0),('1','185',257826,'MORNING','2022-05-21','2022-05-21 14:45:32','2022-05-22 14:45:32','633',4491014.55,4491014.55,'633','2022-05-21 14:51:25','559','2022-05-21 15:10:10',10,0),('1','185',257827,'AFTERNOON','2022-05-21','2022-05-22 06:23:47','2022-05-23 06:23:47','633',3689484.15,3689484.15,'633','2022-05-22 06:37:15','559','2022-05-22 07:41:22',10,0),('1','185',257828,'MORNING','2022-05-22','2022-05-22 14:46:54','2022-05-23 14:46:54','633',4845140.85,4845140.85,'633','2022-05-22 14:53:59','559','2022-05-22 18:36:30',10,0),('1','185',257829,'AFTERNOON','2022-05-22','2022-05-23 07:49:10','2022-05-24 07:49:10','633',3291146.10,3291146.10,'633','2022-05-23 07:58:18','559','2022-05-23 08:00:27',10,0),('1','185',257830,'MORNING','2022-05-23','2022-05-23 14:21:54','2022-05-24 14:21:54','633',4922232.15,4922232.15,'633','2022-05-23 15:08:03','559','2022-05-23 15:14:42',10,0),('1','185',257831,'AFTERNOON','2022-05-23','2022-05-24 07:41:27','2022-05-25 07:41:27','633',2509641.75,2509641.75,'633','2022-05-24 07:48:03','559','2022-05-24 07:56:19',10,0),('1','185',257832,'MORNING','2022-05-24','2022-05-24 14:42:19','2022-05-25 14:42:19','633',4115184.15,4115184.15,'633','2022-05-24 15:34:35','559','2022-05-24 15:38:19',10,0),('1','185',257833,'AFTERNOON','2022-05-24','2022-05-25 07:24:00','2022-05-26 07:24:00','633',4038841.95,4038841.95,'633','2022-05-25 07:31:07','559','2022-05-25 07:53:26',10,0),('1','185',257834,'MORNING','2022-05-25','2022-05-25 14:23:48','2022-05-26 14:23:48','633',4305364.80,4305364.80,'633','2022-05-25 15:08:09','559','2022-05-25 15:13:35',10,0),('1','185',257835,'AFTERNOON','2022-05-25','2022-05-26 07:37:43','2022-05-27 07:37:43','633',3155992.95,3155992.95,'633','2022-05-26 07:47:55','559','2022-05-26 07:58:56',10,0),('1','185',257836,'MORNING','2022-05-26','2022-05-26 14:42:17','2022-05-27 14:42:17','633',2476183.05,2476183.05,'633','2022-05-26 14:45:20','559','2022-05-26 15:09:05',10,0),('1','185',257837,'AFTERNOON','2022-05-26','2022-05-27 07:27:13','2022-05-28 07:27:13','633',929943.60,929943.60,'633','2022-05-27 07:31:48','559','2022-05-27 07:46:27',10,0),('1','185',257838,'MORNING','2022-05-27','2022-05-27 15:44:45','2022-05-28 15:44:45','633',9345394.35,9345394.35,'633','2022-05-27 16:17:14','559','2022-05-27 16:40:52',10,0),('1','185',257839,'AFTERNOON','2022-05-28','2022-05-28 08:04:57','2022-05-29 08:04:57','633',0.00,0.00,'633','2022-05-28 08:11:37','559','2022-05-28 08:13:42',10,0),('1','185',257840,'AFTERNOON','2022-05-27','2022-05-28 08:14:36','2022-05-29 08:14:36','633',4776405.30,4776405.30,'633','2022-05-28 08:18:57','559','2022-05-28 08:42:36',10,0),('1','185',257841,'MORNING','2022-05-28','2022-05-28 15:14:04','2022-05-29 15:14:04','633',6078981.05,6078981.05,'633','2022-05-28 15:22:22','559','2022-05-28 15:26:48',10,0),('1','185',257842,'AFTERNOON','2022-05-28','2022-05-29 05:48:24','2022-05-30 05:48:24','633',4837721.95,4837721.95,'633','2022-05-29 05:57:37','559','2022-05-29 07:29:15',10,0),('1','185',257843,'MORNING','2022-05-29','2022-05-29 15:17:25','2022-05-30 15:17:25','633',6076803.25,6076803.25,'633','2022-05-29 15:22:15','559','2022-05-29 15:24:34',10,0),('1','185',257844,'AFTERNOON','2022-05-29','2022-05-30 06:18:03','2022-05-31 06:18:03','633',4470205.20,4470205.20,'633','2022-05-30 06:27:32','559','2022-05-30 07:41:32',10,0),('1','185',257845,'MORNING','2022-05-30','2022-05-30 15:03:36','2022-05-31 15:03:36','633',4964971.00,4964971.00,'633','2022-05-30 15:14:34','559','2022-05-30 15:17:43',10,0),('1','185',257846,'AFTERNOON','2022-05-30','2022-05-31 05:46:30','2022-06-01 05:46:30','633',1891130.80,1891130.80,'633','2022-05-31 05:51:38','559','2022-05-31 07:31:19',10,0),('1','185',257847,'MORNING','2022-05-31','2022-05-31 15:31:39','2022-06-01 15:31:39','633',4709394.35,4709394.35,'633','2022-05-31 15:34:08','559','2022-05-31 16:26:10',10,0),('1','185',257848,'AFTERNOON','2022-05-31','2022-06-01 06:46:28','2022-06-02 06:46:28','633',4375349.55,4375349.55,'633','2022-06-01 07:56:37','559','2022-06-01 08:02:40',10,0),('1','185',257849,'MORNING','2022-06-01','2022-06-01 14:46:09','2022-06-02 14:46:09','633',6492717.75,6492717.75,'633','2022-06-01 14:56:26','559','2022-06-01 15:20:08',10,0),('1','185',257850,'AFTERNOON','2022-06-01','2022-06-02 06:40:59','2022-06-03 06:40:59','633',4896738.00,4896738.00,'633','2022-06-02 06:48:16','559','2022-06-02 07:23:08',10,0),('1','185',257851,'MORNING','2022-06-02','2022-06-02 19:21:24','2022-06-03 19:21:24','633',1785506.40,1785506.40,'633','2022-06-02 19:24:25','559','2022-06-02 19:42:30',10,0),('1','185',257852,'AFTERNOON','2022-06-02','2022-06-03 06:02:09','2022-06-04 06:02:09','633',1306679.40,1306679.40,'633','2022-06-03 06:06:23','559','2022-06-03 06:15:11',10,0),('1','185',257853,'MORNING SHIFT','2022-06-03','2022-06-03 10:03:04','2022-06-04 10:03:04','634',6833307.45,6833307.45,'633','2022-06-03 15:30:14','559','2022-06-03 15:35:58',10,0),('1','185',257854,'AFTERNOON','2022-06-03','2022-06-04 05:37:20','2022-06-05 05:37:20','633',5610586.35,5610586.35,'633','2022-06-04 05:48:15','559','2022-06-04 07:29:15',10,0),('1','185',257855,'MORNING','2022-06-04','2022-06-04 16:15:18','2022-06-05 16:15:18','633',7951742.40,7951742.40,'633','2022-06-04 16:56:47','559','2022-06-04 16:59:25',10,0),('1','185',257856,'AFTERNOON','2022-06-04','2022-06-05 05:33:57','2022-06-06 05:33:57','633',5413585.95,5413585.95,'633','2022-06-05 05:45:52','559','2022-06-05 07:43:26',10,0),('1','185',257857,'MORNING','2022-06-05','2022-06-05 15:51:21','2022-06-06 15:51:21','633',7090354.80,7090354.80,'633','2022-06-05 15:56:22','559','2022-06-05 16:31:58',10,0),('1','185',257858,'AFTERNOON','2022-06-05','2022-06-06 07:08:15','2022-06-07 07:08:15','633',4622124.45,4622124.45,'633','2022-06-06 07:15:25','559','2022-06-06 07:56:37',10,0),('1','185',257859,'MORNING','2022-06-06','2022-06-06 14:59:16','2022-06-07 14:59:16','633',1863078.15,1863078.15,'633','2022-06-06 15:02:38','559','2022-06-06 16:33:34',10,0),('1','185',257860,'AFTERNOON','2022-06-06','2022-06-07 05:43:35','2022-06-08 05:43:35','633',4203786.45,4203786.45,'633','2022-06-07 05:55:19','559','2022-06-07 07:56:09',10,0),('1','185',257861,'MORNING','2022-06-07','2022-06-07 14:31:56','2022-06-08 14:31:56','633',9962859.45,9962859.45,'633','2022-06-07 21:42:26','559','2022-06-07 22:00:42',10,0),('1','185',257862,'AFTERNOON','2022-06-07','2022-06-08 05:54:11','2022-06-09 05:54:11','633',0.00,0.00,'633','2022-06-08 05:57:28','559','2022-06-08 06:33:44',10,0),('1','185',257863,'AFTERNOON','2022-06-07','2022-06-08 06:56:10','2022-06-09 06:56:10','633',5966029.00,5966029.00,'633','2022-06-08 07:00:41','559','2022-06-08 07:10:38',10,0),('1','185',257864,'MORNING SHIFT','2022-06-08','2022-06-08 09:35:55','2022-06-09 09:35:55','634',4136862.30,4136862.30,'633','2022-06-08 14:44:39','559','2022-06-08 14:46:46',10,0),('1','185',257865,'AFTERNOON','2022-06-08','2022-06-09 07:45:04','2022-06-10 07:45:04','633',4017320.00,4017320.00,'633','2022-06-09 07:55:42','559','2022-06-09 08:00:46',10,0),('1','185',257866,'MORNING','2022-06-09','2022-06-09 15:22:44','2022-06-10 15:22:44','633',7384428.75,7384428.75,'633','2022-06-09 16:00:46','559','2022-06-09 16:47:02',10,0),('1','185',257867,'AFTERNOON','2022-06-09','2022-06-10 05:46:53','2022-06-11 05:46:53','633',5195483.15,5195483.15,'633','2022-06-10 05:55:01','559','2022-06-10 07:22:40',10,0),('1','185',257868,'MORNING SHIFT','2022-06-10','2022-06-10 08:56:20','2022-06-11 08:56:20','634',8171172.60,8171172.60,'633','2022-06-10 18:08:59','559','2022-06-10 18:19:13',10,0),('1','185',257869,'AFTERNOON','2022-06-10','2022-06-11 07:17:24','2022-06-12 07:17:24','633',5356452.00,5356452.00,'633','2022-06-11 07:59:01','559','2022-06-11 08:01:34',10,0),('1','185',257870,'MORNING','2022-06-11','2022-06-11 13:40:40','2022-06-12 13:40:40','633',7751433.05,7751433.05,'633','2022-06-11 15:42:16','559','2022-06-11 15:46:49',10,0),('1','185',257871,'AFTERNOON','2022-06-11','2022-06-12 06:22:35','2022-06-13 06:22:35','633',5180044.75,5180044.75,'633','2022-06-12 06:34:27','559','2022-06-12 07:40:01',10,0),('1','185',257872,'MORNING','2022-06-12','2022-06-12 15:10:52','2022-06-13 15:10:52','633',7214819.90,7214819.90,'633','2022-06-12 15:15:50','559','2022-06-12 16:15:45',10,0),('1','185',257873,'AFTERNOON','2022-06-12','2022-06-13 07:19:28','2022-06-14 07:19:28','633',2777026.10,2777026.10,'633','2022-06-13 07:26:34','559','2022-06-13 07:50:10',10,0),('1','185',257874,'MORNING','2022-06-13','2022-06-13 15:08:24','2022-06-14 15:08:24','633',6105469.10,6105469.10,'633','2022-06-13 15:18:28','559','2022-06-13 20:25:48',10,0),('1','185',257875,'AFTERNOON','2022-06-13','2022-06-14 06:37:12','2022-06-15 06:37:12','633',2963900.00,2963900.00,'633','2022-06-14 06:45:58','559','2022-06-14 07:31:39',10,0),('1','185',257876,'MORNING','2022-06-14','2022-06-14 14:49:06','2022-06-15 14:49:06','633',6937999.10,6937999.10,'633','2022-06-14 15:21:53','559','2022-06-14 15:33:26',10,0),('1','185',257877,'AFTERNOON','2022-06-14','2022-06-15 06:24:42','2022-06-16 06:24:42','633',5625663.65,5625663.65,'633','2022-06-15 06:35:07','559','2022-06-15 07:29:34',10,0),('1','185',257878,'MORNING','2022-06-15','2022-06-15 14:53:33','2022-06-16 14:53:33','633',6083812.50,6083812.50,'633','2022-06-15 15:09:31','559','2022-06-16 07:36:38',10,0),('1','185',257879,'AFTERNOON','2022-06-15','2022-06-16 07:44:53','2022-06-17 07:44:53','633',1872740.60,1872740.60,'633','2022-06-16 07:48:53','559','2022-06-16 09:07:26',10,0),('1','185',257880,'MORNING','2022-06-16','2022-06-16 16:00:19','2022-06-17 16:00:19','633',4079579.55,4079579.55,'633','2022-06-16 16:05:17','559','2022-06-17 07:47:49',10,0),('1','185',257881,'AFTERNOON','2022-06-16','2022-06-17 07:51:20','2022-06-18 07:51:20','633',1682617.50,1682617.50,'633','2022-06-17 07:56:28','559','2022-06-17 08:05:18',10,0),('1','185',257882,'MORNING','2022-06-17','2022-06-17 14:39:35','2022-06-18 14:39:35','633',6424347.70,6424347.70,'633','2022-06-17 15:50:05','559','2022-06-17 15:57:54',10,0),('1','185',257883,'AFTERNOON','2022-06-17','2022-06-18 05:54:47','2022-06-19 05:54:47','633',3766091.75,3766091.75,'633','2022-06-18 06:01:00','559','2022-06-18 07:52:31',10,0),('1','185',257884,'MORNING','2022-06-18','2022-06-18 15:00:37','2022-06-19 15:00:37','633',7001467.75,7001467.75,'633','2022-06-18 15:27:13','559','2022-06-18 21:05:56',10,0),('1','185',257885,'AFTERNOON','2022-06-18','2022-06-19 05:45:36','2022-06-20 05:45:36','633',2087063.90,2087063.90,'633','2022-06-19 05:54:20','559','2022-06-19 07:35:44',10,0),('1','185',257886,'MORNING','2022-06-19','2022-06-19 14:18:06','2022-06-20 14:18:06','633',467032.70,467032.70,'633','2022-06-19 14:19:34','559','2022-06-19 14:26:55',10,0),('1','185',257887,'AFTERNOON','2022-06-19','2022-06-20 06:59:12','2022-06-21 06:59:12','633',759026.70,759026.70,'633','2022-06-20 07:02:00','559','2022-06-20 07:44:22',10,0),('1','185',257888,'MORNING','2022-06-20','2022-06-20 13:26:09','2022-06-21 13:26:09','633',6057281.85,6057281.85,'633','2022-06-20 15:00:42','559','2022-06-20 15:22:07',10,0),('1','185',257889,'AFTERNOON','2022-06-20','2022-06-21 06:04:59','2022-06-22 06:04:59','633',5387656.95,5387656.95,'633','2022-06-21 06:18:30','559','2022-06-21 07:50:54',10,0),('1','185',257890,'MORNING','2022-06-21','2022-06-21 15:02:05','2022-06-22 15:02:05','633',5030006.90,5030006.90,'633','2022-06-21 15:16:20','559','2022-06-21 16:27:33',10,0),('1','185',257891,'AFTERNOON','2022-06-21','2022-06-22 07:32:13','2022-06-23 07:32:13','633',0.00,0.00,'634','2022-06-22 07:55:33','634','2022-06-22 07:55:53',10,0),('1','185',257892,'AFTERNOON','2022-06-21','2022-06-22 08:03:13','2022-06-23 08:03:13','633',2933664.65,2933664.65,'633','2022-06-22 09:42:05','559','2022-06-22 09:53:50',10,0),('1','185',257893,'MORNING','2022-06-22','2022-06-22 14:54:39','2022-06-23 14:54:39','633',6804767.75,6804767.75,'633','2022-06-22 14:58:02','559','2022-06-22 15:31:36',10,0),('1','185',257894,'MORNING','2022-06-22','2022-06-23 06:00:11','2022-06-24 06:00:11','633',5133785.45,5133785.45,'633','2022-06-23 07:00:45','559','2022-06-23 07:34:48',10,0),('1','185',257895,'MORNING','2022-06-23','2022-06-23 15:05:34','2022-06-24 15:05:34','633',7380808.10,7380808.10,'633','2022-06-23 15:15:11','559','2022-06-23 15:29:25',10,0),('1','185',257896,'AFTERNOON','2022-06-23','2022-06-24 07:01:39','2022-06-25 07:01:39','633',6824025.30,6824025.30,'633','2022-06-24 07:16:23','559','2022-06-24 07:54:08',10,0),('1','185',257897,'MORNING','2022-06-24','2022-06-24 14:46:01','2022-06-25 14:46:01','633',6002212.70,6002212.70,'633','2022-06-24 14:51:03','559','2022-06-24 15:02:19',10,0),('1','185',257898,'AFTERNOON','2022-06-24','2022-06-25 06:57:18','2022-06-26 06:57:18','633',7643315.90,7643315.90,'633','2022-06-25 07:07:25','559','2022-06-25 07:36:22',10,0),('1','185',257899,'MORNING','2022-06-25','2022-06-25 15:01:12','2022-06-26 15:01:12','633',7522336.75,7522336.75,'633','2022-06-25 15:59:35','559','2022-06-25 18:28:09',10,0),('1','185',257900,'AFTERNOON','2022-06-25','2022-06-26 05:37:16','2022-06-27 05:37:16','633',3687783.00,3687783.00,'633','2022-06-26 05:47:29','559','2022-06-26 07:56:14',10,0),('1','185',257901,'MORNING','2022-06-26','2022-06-26 14:57:11','2022-06-27 14:57:11','633',6479678.75,6479678.75,'633','2022-06-26 15:02:02','559','2022-06-26 15:10:06',10,0),('1','185',257902,'AFTERNOON','2022-06-26','2022-06-27 05:33:04','2022-06-28 05:33:04','633',5649454.00,5649454.00,'633','2022-06-27 05:41:40','559','2022-06-27 07:51:50',10,0),('1','185',257903,'MORNING','2022-06-27','2022-06-27 14:18:43','2022-06-28 14:18:43','633',7825598.85,7825598.85,'633','2022-06-27 14:26:40','559','2022-06-27 15:23:24',10,0),('1','185',257904,'AFTERNOON','2022-06-27','2022-06-28 05:38:52','2022-06-29 05:38:52','633',2271809.00,2271809.00,'633','2022-06-28 05:46:58','559','2022-06-28 07:47:19',10,0),('1','185',257905,'MORNING','2022-06-28','2022-06-28 10:49:59','2022-06-29 10:49:59','633',6950977.25,6950977.25,'633','2022-06-28 15:18:02','559','2022-06-28 15:22:11',10,0),('1','185',257906,'AFTERNOON','2022-06-28','2022-06-29 08:07:06','2022-06-30 08:07:06','633',2323858.45,2323858.45,'633','2022-06-29 08:30:47','559','2022-06-29 08:34:56',10,0),('1','185',257907,'DAY SHIFT','2022-06-29','2022-06-29 19:32:37','2022-06-30 19:32:37','633',2336616.00,2336616.00,'633','2022-06-29 19:39:03','559','2022-06-29 19:50:16',10,0),('1','185',257908,'MORNING','2022-06-30','2022-06-30 10:33:09','2022-07-01 10:33:09','633',6445021.65,6445021.65,'633','2022-06-30 15:03:44','559','2022-06-30 15:04:47',10,0),('1','185',257909,'AFTERNOON','2022-06-30','2022-06-30 20:37:53','2022-07-01 20:37:53','633',2590868.50,2590868.50,'633','2022-06-30 20:55:14','559','2022-06-30 20:59:02',10,0),('1','185',257910,'AFTERNOON','2022-06-30','2022-07-01 08:10:08','2022-07-02 08:10:08','633',0.00,0.00,'633','2022-07-01 08:15:10','559','2022-07-01 08:16:24',10,0),('1','185',257911,'MORNING','2022-07-01','2022-07-01 15:48:01','2022-07-02 15:48:01','633',10166886.60,10166886.60,'633','2022-07-01 16:01:04','559','2022-07-01 16:03:38',10,0),('1','185',257912,'AFTERNOON','2022-07-01','2022-07-01 20:19:45','2022-07-02 20:19:45','633',3337741.60,3337741.60,'633','2022-07-02 05:43:58','559','2022-07-02 07:51:18',10,0),('1','185',257913,'MORNING','2022-07-02','2022-07-02 14:55:48','2022-07-03 14:55:48','633',4484678.85,4484678.85,'633','2022-07-02 15:09:33','559','2022-07-02 15:12:06',10,0),('1','185',257914,'AFTERNOON','2022-07-02','2022-07-03 08:17:56','2022-07-04 08:17:56','633',2704185.95,2704185.95,'633','2022-07-03 08:25:49','559','2022-07-03 09:29:06',10,0),('1','185',257915,'DAY SHIFT','2022-07-03','2022-07-03 10:24:56','2022-07-04 10:24:56','633',1570061.20,1570061.20,'633','2022-07-04 07:15:04','559','2022-07-04 07:51:38',10,0),('1','185',257916,'MORNING SHIFT','2022-07-04','2022-07-04 10:50:06','2022-07-05 10:50:06','634',3466893.40,3466893.40,'633','2022-07-05 06:56:24','559','2022-07-05 07:07:20',10,0),('1','185',257917,'MORNING','2022-07-05','2022-07-06 06:34:59','2022-07-07 06:34:59','633',9469945.90,9469945.90,'633','2022-07-06 07:53:22','559','2022-07-06 07:58:32',10,0),('1','185',257918,'AFTERNOON','2022-07-05','2022-07-06 07:58:57','2022-07-07 07:58:57','633',2512578.40,2512578.40,'633','2022-07-06 08:03:41','559','2022-07-06 10:40:08',10,0),('1','185',257919,'MORNING','2022-07-06','2022-07-06 17:43:03','2022-07-07 17:43:03','633',7801909.05,7801909.05,'633','2022-07-06 17:54:57','559','2022-07-06 19:20:21',10,0),('1','185',257920,'AFTERNOON','2022-07-06','2022-07-07 08:30:12','2022-07-08 08:30:12','633',1428089.70,1428089.70,'633','2022-07-07 08:37:39','559','2022-07-07 08:43:10',10,0),('1','185',257921,'MORNING','2022-07-07','2022-07-08 08:24:26','2022-07-09 08:24:26','633',6960238.55,6960238.55,'633','2022-07-08 08:28:59','634','2022-07-08 09:29:16',10,0),('1','185',257922,'AFTERNOON','2022-07-07','2022-07-08 09:42:59','2022-07-09 09:42:59','633',4428969.60,4428969.60,'633','2022-07-08 10:13:33','634','2022-07-08 10:14:53',10,0),('1','185',257923,'MORNING','2022-07-08','2022-07-08 15:56:05','2022-07-09 15:56:05','633',5699737.30,5699737.30,'633','2022-07-08 16:25:47','559','2022-07-08 22:24:12',10,0),('1','185',257924,'AFTERNOON','2022-07-08','2022-07-09 06:48:10','2022-07-10 06:48:10','633',1261608.30,1261608.30,'633','2022-07-09 06:50:59','559','2022-07-09 07:45:08',10,0),('1','185',257925,'MORNING','2022-07-09','2022-07-09 17:04:17','2022-07-10 17:04:17','633',3258605.95,3258605.95,'633','2022-07-09 17:30:18','559','2022-07-09 18:13:09',10,0),('1','185',257926,'AFTERNOON','2022-07-09','2022-07-10 07:10:33','2022-07-11 07:10:33','633',2847805.20,2847805.20,'633','2022-07-10 07:17:00','559','2022-07-10 08:06:10',10,0),('1','185',257927,'MORNING','2022-07-10','2022-07-10 16:32:50','2022-07-11 16:32:50','633',2331642.30,2331642.30,'633','2022-07-10 16:35:44','559','2022-07-10 20:19:42',10,0),('1','185',257928,'AFTERNOON','2022-07-10','2022-07-11 05:46:55','2022-07-12 05:46:55','633',1093259.40,1093259.40,'633','2022-07-11 05:52:01','559','2022-07-11 07:32:31',10,0),('1','185',257929,'MORNING','2022-07-11','2022-07-11 19:57:32','2022-07-12 19:57:32','633',2185257.20,2185257.20,'633','2022-07-11 19:59:14','559','2022-07-11 20:03:07',10,0),('1','185',257930,'AFTERNOON','2022-07-11','2022-07-11 20:03:39','2022-07-12 20:03:39','633',2180119.50,2180119.50,'633','2022-07-12 06:04:44','559','2022-07-12 07:53:06',10,0),('1','185',257931,'MORNING','2022-07-12','2022-07-12 13:13:35','2022-07-13 13:13:35','633',7881086.90,7881086.90,'633','2022-07-12 14:41:37','559','2022-07-12 15:00:41',10,0),('1','185',257932,'AFTERNOON','2022-07-12','2022-07-13 05:41:10','2022-07-14 05:41:10','633',4943592.45,4943592.45,'633','2022-07-13 05:47:21','559','2022-07-13 07:44:56',10,0),('1','185',257933,'MORNING','2022-07-13','2022-07-13 15:29:05','2022-07-14 15:29:05','633',7696779.75,7696779.75,'633','2022-07-13 15:33:53','559','2022-07-13 19:23:45',10,0),('1','185',257934,'AFTERNOON','2022-07-13','2022-07-14 07:00:21','2022-07-15 07:00:21','633',5829773.55,5829773.55,'633','2022-07-14 07:08:04','559','2022-07-14 07:57:15',10,0),('1','185',257935,'MORNING','2022-07-14','2022-07-14 16:01:07','2022-07-15 16:01:07','633',5602448.95,5602448.95,'633','2022-07-14 16:07:03','559','2022-07-14 17:59:18',10,0),('1','185',257936,'AFTERNOON','2022-07-14','2022-07-15 05:46:47','2022-07-16 05:46:47','633',1816427.05,1816427.05,'633','2022-07-15 05:51:27','559','2022-07-15 07:20:07',10,0),('1','185',257937,'MORNING','2022-07-15','2022-07-15 14:30:04','2022-07-16 14:30:04','633',7524728.65,7524728.65,'633','2022-07-15 14:41:19','559','2022-07-15 15:05:02',10,0),('1','185',257938,'AFTERNOON','2022-07-15','2022-07-16 06:22:47','2022-07-17 06:22:47','633',3040698.65,3040698.65,'633','2022-07-16 06:29:39','559','2022-07-16 06:36:43',10,0),('1','185',257939,'MORNING','2022-07-16','2022-07-16 15:39:05','2022-07-17 15:39:05','633',4398311.25,4398311.25,'633','2022-07-16 15:53:34','559','2022-07-17 06:35:47',10,0),('1','185',257940,'AFTERNOON','2022-07-16','2022-07-17 06:39:14','2022-07-18 06:39:14','633',2089101.70,2089101.70,'633','2022-07-17 06:42:31','559','2022-07-17 08:06:11',10,0),('1','185',257941,'MORNING','2022-07-17','2022-07-17 14:58:43','2022-07-18 14:58:43','633',7076922.85,7076922.85,'633','2022-07-17 15:05:18','559','2022-07-17 16:33:13',10,0),('1','185',257942,'AFTERNOON','2022-07-17','2022-07-18 06:18:12','2022-07-19 06:18:12','633',3927603.80,3927603.80,'633','2022-07-18 06:28:03','559','2022-07-18 07:19:34',10,0),('1','185',257943,'MORNING','2022-07-18','2022-07-18 17:15:33','2022-07-19 17:15:33','633',750793.10,750793.10,'633','2022-07-18 17:16:18','559','2022-07-18 17:25:48',10,0),('1','185',257944,'AFTERNOON','2022-07-18','2022-07-19 05:52:51','2022-07-20 05:52:51','633',1315375.70,1315375.70,'633','2022-07-19 05:57:08','559','2022-07-19 07:31:48',10,0),('1','185',257945,'MORNING','2022-07-19','2022-07-19 14:44:10','2022-07-20 14:44:10','633',6295637.25,6295637.25,'633','2022-07-19 14:49:18','559','2022-07-19 15:13:01',10,0),('1','185',257946,'AFTERNOON','2022-07-19','2022-07-20 06:09:36','2022-07-21 06:09:36','633',2146850.20,2146850.20,'633','2022-07-20 07:56:30','559','2022-07-20 08:05:31',10,0),('1','185',257947,'MORNING','2022-07-20','2022-07-20 14:58:07','2022-07-21 14:58:07','633',8156919.95,8156919.95,'633','2022-07-20 15:56:27','559','2022-07-20 16:25:30',10,0),('1','185',257948,'AFTERNOON','2022-07-20','2022-07-21 05:36:25','2022-07-22 05:36:25','633',2162446.50,2162446.50,'633','2022-07-21 05:42:25','559','2022-07-21 07:40:14',10,0),('1','185',257949,'MORNING','2022-07-21','2022-07-21 15:02:44','2022-07-22 15:02:44','633',7150995.55,7150995.55,'633','2022-07-21 15:07:12','559','2022-07-21 15:23:59',10,0),('1','185',257950,'AFTERNOON','2022-07-21','2022-07-22 05:38:44','2022-07-23 05:38:44','633',3261743.75,3261743.75,'633','2022-07-22 08:24:44','559','2022-07-22 08:58:37',10,0),('1','185',257951,'MORNING','2022-07-22','2022-07-22 14:34:43','2022-07-23 14:34:43','633',6713040.85,6713040.85,'633','2022-07-22 14:38:50','559','2022-07-22 15:03:51',10,0),('1','185',257952,'AFTERNOON','2022-07-23','2022-07-23 06:56:02','2022-07-24 06:56:02','633',1358037.90,1358037.90,'633','2022-07-23 06:57:01','559','2022-07-23 07:55:03',10,0),('1','185',257953,'DAY SHIFT','2022-07-23','2022-07-24 05:38:24','2022-07-25 05:38:24','633',3932282.70,3932282.70,'633','2022-07-24 05:41:35','559','2022-07-24 07:55:24',10,0),('1','185',257954,'MORNING','2022-07-24','2022-07-24 17:23:38','2022-07-25 17:23:38','633',6868279.10,6868279.10,'633','2022-07-24 17:27:22','559','2022-07-24 23:28:25',10,0),('1','185',257955,'AFTERNOON','2022-07-24','2022-07-25 05:50:34','2022-07-26 05:50:34','633',3520375.00,3520375.00,'633','2022-07-25 05:57:57','559','2022-07-25 07:55:08',10,0),('1','185',257956,'DAY SHIFT','2022-07-25','2022-07-26 07:13:26','2022-07-27 07:13:26','633',1741240.80,1741240.80,'633','2022-07-26 07:17:26','559','2022-07-26 07:18:20',10,0),('1','185',257957,'DAY SHIFT','2022-07-26','2022-07-27 05:43:21','2022-07-28 05:43:21','633',3186872.10,3186872.10,'633','2022-07-27 05:46:09','559','2022-07-27 08:01:11',10,0),('1','185',257958,'MORNING','2022-07-27','2022-07-27 15:26:49','2022-07-28 15:26:49','633',7327886.00,7327886.00,'633','2022-07-27 15:33:08','559','2022-07-27 15:43:14',10,0),('1','185',257959,'AFTERNOON','2022-07-27','2022-07-28 06:49:19','2022-07-29 06:49:19','633',3448918.00,3448918.00,'633','2022-07-28 06:56:43','559','2022-07-28 07:28:58',10,0),('1','185',257960,'MORNING','2022-07-28','2022-07-28 15:03:06','2022-07-29 15:03:06','633',6273227.90,6273227.90,'633','2022-07-28 15:08:34','559','2022-07-28 15:12:11',10,0),('1','185',257961,'AFTERNOON','2022-07-28','2022-07-29 06:25:02','2022-07-30 06:25:02','633',2775338.55,2775338.55,'633','2022-07-29 07:44:27','559','2022-07-29 07:54:20',10,0),('1','185',257962,'MORNING','2022-07-29','2022-07-29 14:42:12','2022-07-30 14:42:12','633',8635070.45,8635070.45,'633','2022-07-29 14:59:37','559','2022-07-29 15:10:09',10,0),('1','185',257963,'AFTERNOON','2022-07-29','2022-07-30 06:49:57','2022-07-31 06:49:57','633',3871534.10,3871534.10,'633','2022-07-30 07:14:32','559','2022-07-30 07:51:01',10,0),('1','185',257964,'MORNING','2022-07-30','2022-07-30 14:52:25','2022-07-31 14:52:25','633',8103172.45,8103172.45,'633','2022-07-30 14:57:34','559','2022-07-30 16:18:07',10,0),('1','185',257965,'AFTERNOON','2022-07-30','2022-07-31 05:38:50','2022-08-01 05:38:50','633',8453087.10,8453087.10,'633','2022-07-31 05:42:41','559','2022-07-31 07:52:06',10,0),('1','185',257966,'MORNING','2022-07-31','2022-07-31 15:21:29','2022-08-01 15:21:29','633',6787413.85,6787413.85,'633','2022-07-31 15:38:10','559','2022-08-01 05:47:01',10,0),('1','185',257967,'AFTERNOON','2022-07-31','2022-08-01 05:47:48','2022-08-02 05:47:48','633',668695.50,668695.50,'633','2022-08-01 05:51:49','559','2022-08-01 07:13:55',10,0),('1','185',257968,'DAY SHIFT','2022-08-01','2022-08-02 06:27:06','2022-08-03 06:27:06','633',2628360.90,2628360.90,'633','2022-08-02 06:31:44','559','2022-08-02 08:35:46',10,0),('1','185',257969,'MORNING','2022-08-02','2022-08-02 14:24:58','2022-08-03 14:24:58','633',7555752.90,7555752.90,'633','2022-08-02 14:31:13','559','2022-08-02 15:00:56',10,0),('1','185',257970,'AFTERNOON','2022-08-02','2022-08-03 06:51:40','2022-08-04 06:51:40','633',3763917.25,3763917.25,'633','2022-08-03 07:25:52','559','2022-08-03 07:56:36',10,0),('1','185',257971,'MORNING','2022-08-03','2022-08-03 15:32:34','2022-08-04 15:32:34','633',7354309.10,7354309.10,'633','2022-08-03 15:44:16','559','2022-08-04 07:34:18',10,0),('1','185',257972,'AFTERNOON','2022-08-03','2022-08-04 07:35:30','2022-08-05 07:35:30','633',2860385.95,2860385.95,'633','2022-08-04 07:44:05','559','2022-08-04 08:15:46',10,0),('1','185',257973,'MORNING','2022-08-04','2022-08-04 15:06:37','2022-08-05 15:06:37','633',4963368.15,4963368.15,'633','2022-08-04 15:09:52','559','2022-08-04 17:41:25',10,0),('1','185',257974,'AFTERNOON','2022-08-04','2022-08-05 07:31:05','2022-08-06 07:31:05','633',3077874.95,3077874.95,'633','2022-08-05 07:36:13','559','2022-08-05 08:06:22',10,0),('1','185',257975,'MORNING','2022-08-05','2022-08-05 14:52:15','2022-08-06 14:52:15','633',7051131.25,7051131.25,'633','2022-08-05 15:11:19','559','2022-08-06 06:02:43',10,0),('1','185',257976,'AFTERNOON','2022-08-05','2022-08-06 07:08:34','2022-08-07 07:08:34','633',4212833.70,4212833.70,'633','2022-08-06 07:20:25','559','2022-08-06 07:41:34',10,0),('1','185',257977,'MORNING','2022-08-06','2022-08-06 12:08:16','2022-08-07 12:08:16','633',6702679.80,6702679.80,'633','2022-08-06 17:01:34','559','2022-08-07 07:03:59',10,0),('1','185',257978,'AFTERNOON','2022-08-06','2022-08-07 07:06:31','2022-08-08 07:06:31','633',1873060.20,1873060.20,'633','2022-08-07 07:10:56','559','2022-08-07 07:40:10',10,0),('1','185',257979,'MORNING','2022-08-07','2022-08-07 14:56:56','2022-08-08 14:56:56','633',7915963.95,7915963.95,'633','2022-08-07 15:08:09','559','2022-08-07 15:27:04',10,0),('1','185',257980,'AFTERNOON','2022-08-07','2022-08-08 07:54:13','2022-08-09 07:54:13','633',4067965.10,4067965.10,'633','2022-08-08 08:02:40','559','2022-08-08 08:42:14',10,0),('1','185',257981,'DAY SHIFT','2022-08-08','2022-08-09 05:34:57','2022-08-10 05:34:57','633',3664865.90,3664865.90,'633','2022-08-09 05:42:51','559','2022-08-09 07:37:12',10,0),('1','185',257982,'MORNING','2022-08-09','2022-08-09 14:27:05','2022-08-10 14:27:05','633',6388880.25,6388880.25,'633','2022-08-09 15:05:54','559','2022-08-09 15:28:30',10,0),('1','185',257983,'AFTERNOON','2022-08-09','2022-08-09 19:36:23','2022-08-10 19:36:23','633',2645041.45,2645041.45,'633','2022-08-10 08:10:00','634','2022-08-10 09:39:36',10,0),('1','185',257984,'MORNING','2022-08-10','2022-08-10 12:50:50','2022-08-11 12:50:50','633',6387619.35,6387619.35,'633','2022-08-10 15:16:12','559','2022-08-10 18:46:06',10,0),('1','185',257985,'AFTERNOON','2022-08-10','2022-08-10 19:24:43','2022-08-11 19:24:43','633',1948293.85,1948293.85,'633','2022-08-10 19:35:41','559','2022-08-11 08:33:41',10,0),('1','185',257986,'MORNING','2022-08-11','2022-08-11 08:39:06','2022-08-12 08:39:06','633',1432468.80,1432468.80,'633','2022-08-12 06:17:26','559','2022-08-12 08:04:46',10,0),('1','185',257987,'MORNING','2022-08-12','2022-08-12 08:54:39','2022-08-13 08:54:39','633',7636997.90,7636997.90,'633','2022-08-12 15:43:21','559','2022-08-12 16:17:01',10,0),('1','185',257988,'AFTERNOON','2022-08-12','2022-08-13 07:16:00','2022-08-14 07:16:00','633',2800663.00,2800663.00,'633','2022-08-13 08:04:37','559','2022-08-13 08:18:02',10,0),('1','185',257989,'MORNING','2022-08-13','2022-08-13 08:20:23','2022-08-14 08:20:23','633',4828685.70,4828685.70,'633','2022-08-13 14:47:35','559','2022-08-13 14:53:14',10,0),('1','185',257990,'AFTERNOON','2022-08-13','2022-08-14 08:28:07','2022-08-15 08:28:07','633',2039502.05,2039502.05,'633','2022-08-14 08:39:07','559','2022-08-14 08:51:51',10,0),('1','185',257991,'MORNING','2022-08-14','2022-08-14 09:59:24','2022-08-15 09:59:24','633',4044825.10,4044825.10,'633','2022-08-14 14:44:03','559','2022-08-14 14:57:18',10,0),('1','185',257992,'MORNING','2022-08-15','2022-08-15 08:13:22','2022-08-16 08:13:22','633',0.00,0.00,'633','2022-08-15 08:34:37','559','2022-08-15 08:37:36',10,0),('1','185',257993,'AFTERNOON','2022-08-14','2022-08-15 08:39:05','2022-08-16 08:39:05','633',3043781.20,3043781.20,'633','2022-08-15 08:44:17','559','2022-08-15 08:51:33',10,0),('1','185',257994,'MORNING','2022-08-15','2022-08-15 09:04:15','2022-08-16 09:04:15','633',2364189.05,2364189.05,'633','2022-08-15 14:56:18','559','2022-08-15 15:00:33',10,0),('1','185',257995,'AFTERNOON','2022-08-15','2022-08-16 08:16:57','2022-08-17 08:16:57','633',749160.90,749160.90,'633','2022-08-16 08:31:22','559','2022-08-16 08:34:17',10,0),('1','185',257996,'MORNING','2022-08-16','2022-08-16 14:58:44','2022-08-17 14:58:44','633',4605425.45,4605425.45,'633','2022-08-16 15:26:35','559','2022-08-16 17:19:17',10,0),('1','185',257997,'AFTERNOON','2022-08-16','2022-08-16 19:18:17','2022-08-17 19:18:17','633',3292706.30,3292706.30,'633','2022-08-17 07:12:43','559','2022-08-17 07:48:29',10,0),('1','185',257998,'MORNING','2022-08-17','2022-08-17 14:25:44','2022-08-18 14:25:44','633',3344214.95,3344214.95,'633','2022-08-17 14:59:54','559','2022-08-17 15:09:49',10,0),('1','185',257999,'AFTERNOON','2022-08-17','2022-08-18 06:58:04','2022-08-19 06:58:04','633',3681754.95,3681754.95,'633','2022-08-18 07:11:24','559','2022-08-18 07:33:23',10,0),('1','185',258000,'MORNING','2022-08-18','2022-08-18 09:40:50','2022-08-19 09:40:50','633',4189271.40,4189271.40,'633','2022-08-18 14:55:41','559','2022-08-18 15:03:27',10,0),('1','185',258001,'AFTERNOON','2022-08-18','2022-08-19 06:29:14','2022-08-20 06:29:14','633',4103306.75,4103306.75,'633','2022-08-19 06:39:45','559','2022-08-19 07:48:51',10,0),('1','185',258002,'MORNING','2022-08-19','2022-08-19 14:49:08','2022-08-20 14:49:08','633',3803264.05,3803264.05,'633','2022-08-19 14:56:20','559','2022-08-19 16:22:04',10,0),('1','185',258003,'AFTERNOON','2022-08-19','2022-08-20 06:43:02','2022-08-21 06:43:02','633',3927248.40,3927248.40,'633','2022-08-20 08:34:03','559','2022-08-20 09:38:55',10,0),('1','185',258004,'MORNING','2022-08-20','2022-08-20 14:52:56','2022-08-21 14:52:56','633',3478628.05,3478628.05,'633','2022-08-20 15:05:27','559','2022-08-20 15:45:44',10,0),('1','185',258005,'AFTERNOON','2022-08-20','2022-08-21 06:50:01','2022-08-22 06:50:01','633',3556818.80,3556818.80,'633','2022-08-21 06:59:17','559','2022-08-21 07:23:58',10,0),('1','185',258006,'MORNING','2022-08-21','2022-08-21 14:10:19','2022-08-22 14:10:19','633',3071063.10,3071063.10,'633','2022-08-21 14:18:19','559','2022-08-21 15:26:30',10,0),('1','185',258007,'AFTERNOON','2022-08-21','2022-08-22 06:39:07','2022-08-23 06:39:07','633',3356324.40,3356324.40,'633','2022-08-22 06:48:21','559','2022-08-22 07:49:40',10,0),('1','185',258008,'MORNING','2022-08-22','2022-08-22 14:44:42','2022-08-23 14:44:42','633',2755327.45,2755327.45,'633','2022-08-22 14:58:11','559','2022-08-22 15:02:52',10,0),('1','185',258009,'MORNING','2022-08-22','2022-08-23 06:49:33','2022-08-24 06:49:33','633',0.00,0.00,'633','2022-08-23 08:39:28','559','2022-08-23 08:41:57',10,0),('1','185',258010,'AFTERNOON','2022-08-22','2022-08-23 08:42:21','2022-08-24 08:42:21','633',2957436.75,2957436.75,'633','2022-08-23 08:46:27','559','2022-08-23 08:47:16',10,0),('1','185',258011,'MORNING','2022-08-23','2022-08-23 14:49:49','2022-08-24 14:49:49','633',3151549.10,3151549.10,'633','2022-08-23 15:05:20','559','2022-08-23 15:12:07',10,0),('1','185',258012,'AFTERNOON','2022-08-23','2022-08-24 06:58:03','2022-08-25 06:58:03','633',3109766.30,3109766.30,'633','2022-08-24 07:12:11','559','2022-08-24 08:15:03',10,0),('1','185',258013,'MORNING','2022-08-24','2022-08-24 14:40:25','2022-08-25 14:40:25','633',2798853.40,2798853.40,'633','2022-08-24 14:48:26','559','2022-08-24 15:05:28',10,0),('1','185',258014,'AFTERNOON','2022-08-24','2022-08-25 06:56:28','2022-08-26 06:56:28','633',2932748.25,2932748.25,'633','2022-08-25 07:02:58','559','2022-08-25 08:00:51',10,0),('1','185',258015,'MORNING','2022-08-25','2022-08-25 14:35:32','2022-08-26 14:35:32','633',3370285.20,3370285.20,'633','2022-08-25 14:45:29','559','2022-08-25 14:56:15',10,0),('1','185',258016,'AFTERNOON','2022-08-25','2022-08-26 07:49:08','2022-08-27 07:49:08','633',2229550.20,2229550.20,'633','2022-08-26 07:55:13','559','2022-08-26 09:23:38',10,0),('1','185',258017,'MORNING','2022-08-26','2022-08-26 14:40:48','2022-08-27 14:40:48','633',3920474.05,3920474.05,'633','2022-08-26 14:53:45','559','2022-08-26 16:22:17',10,0),('1','185',258018,'AFTERNOON','2022-08-26','2022-08-27 09:22:34','2022-08-28 09:22:34','633',3393659.00,3393659.00,'633','2022-08-27 09:28:39','559','2022-08-27 10:09:43',10,0),('1','185',258019,'MORNING','2022-08-27','2022-08-27 14:53:41','2022-08-28 14:53:41','633',2416686.75,2416686.75,'633','2022-08-27 14:56:56','559','2022-08-27 15:01:55',10,0),('1','185',258020,'AFTERNOON','2022-08-27','2022-08-28 06:50:17','2022-08-29 06:50:17','633',600464.00,600464.00,'633','2022-08-28 06:54:14','559','2022-08-28 07:39:51',10,0),('1','185',258021,'MORNING','2022-08-28','2022-08-28 14:31:48','2022-08-29 14:31:48','633',2896203.85,2896203.85,'633','2022-08-28 14:39:41','559','2022-08-28 15:18:45',10,0),('1','185',258022,'AFTERNOON','2022-08-28','2022-08-29 07:14:37','2022-08-30 07:14:37','633',3453352.15,3453352.15,'633','2022-08-29 07:21:37','559','2022-08-29 07:47:16',10,0),('1','185',258023,'MORNING','2022-08-29','2022-08-29 14:23:04','2022-08-30 14:23:04','633',3473123.00,3473123.00,'633','2022-08-29 14:26:11','559','2022-08-29 15:00:19',10,0),('1','185',258024,'AFTERNOON','2022-08-29','2022-08-30 07:09:40','2022-08-31 07:09:40','633',3229427.50,3229427.50,'633','2022-08-30 07:18:24','559','2022-08-30 07:23:03',10,0),('1','185',258025,'MORNING','2022-08-30','2022-08-30 14:43:03','2022-08-31 14:43:03','633',3808613.30,3808613.30,'633','2022-08-30 14:47:44','559','2022-08-30 15:14:40',10,0),('1','185',258026,'AFTERNOON','2022-08-30','2022-08-31 06:56:42','2022-09-01 06:56:42','633',3339815.55,3339815.55,'633','2022-08-31 07:09:01','559','2022-08-31 07:32:07',10,0),('1','185',258027,'MORNING','2022-08-31','2022-08-31 14:43:36','2022-09-01 14:43:36','633',3302979.65,3302979.65,'633','2022-08-31 14:46:24','559','2022-08-31 15:05:40',10,0),('1','185',258028,'AFTERNOON','2022-08-31','2022-09-01 07:38:08','2022-09-02 07:38:08','633',2905042.85,2905042.85,'633','2022-09-01 07:49:58','559','2022-09-01 08:01:47',10,0),('1','185',258029,'MORNING','2022-09-01','2022-09-01 14:34:18','2022-09-02 14:34:18','633',3180046.70,3180046.70,'633','2022-09-01 14:45:13','559','2022-09-01 14:51:00',10,0),('1','185',258030,'AFTERNOON','2022-09-01','2022-09-02 07:12:11','2022-09-03 07:12:11','633',3750435.55,3750435.55,'633','2022-09-02 07:21:48','559','2022-09-02 07:36:49',10,0),('1','185',258031,'MORNING','2022-09-02','2022-09-02 14:36:11','2022-09-03 14:36:11','633',3108409.00,3108409.00,'633','2022-09-02 14:53:02','559','2022-09-02 15:09:52',10,0),('1','185',258032,'AFTERNOON','2022-09-02','2022-09-03 07:20:30','2022-09-04 07:20:30','633',3346724.45,3346724.45,'633','2022-09-03 07:30:47','559','2022-09-03 07:57:54',10,0),('1','185',258033,'MORNING','2022-09-03','2022-09-03 14:30:58','2022-09-04 14:30:58','633',4064507.60,4064507.60,'633','2022-09-03 14:35:43','559','2022-09-03 17:08:33',10,0),('1','185',258034,'AFTERNOON','2022-09-03','2022-09-04 07:32:41','2022-09-05 07:32:41','633',5880122.85,5880122.85,'633','2022-09-04 08:19:09','559','2022-09-04 08:24:41',10,0),('1','185',258035,'MORNING','2022-09-04','2022-09-04 15:18:18','2022-09-05 15:18:18','633',3598244.00,3598244.00,'633','2022-09-04 15:21:07','559','2022-09-04 16:25:12',10,0),('1','185',258036,'AFTERNOON','2022-09-04','2022-09-05 06:30:49','2022-09-06 06:30:49','633',3302426.55,3302426.55,'633','2022-09-05 06:41:12','559','2022-09-05 08:03:28',10,0),('1','185',258037,'MORNING','2022-09-05','2022-09-05 14:35:44','2022-09-06 14:35:44','633',3421296.75,3421296.75,'633','2022-09-05 15:00:18','559','2022-09-05 15:10:30',10,0),('1','185',258038,'AFTERNOON','2022-09-05','2022-09-06 07:12:32','2022-09-07 07:12:32','633',3872338.95,3872338.95,'633','2022-09-06 07:23:49','559','2022-09-06 08:04:26',10,0),('1','185',258039,'MORNING','2022-09-06','2022-09-06 14:01:37','2022-09-07 14:01:37','633',3407580.50,3407580.50,'633','2022-09-06 14:14:36','559','2022-09-06 14:57:51',10,0),('1','185',258040,'AFTERNOON ','2022-09-06','2022-09-07 07:04:57','2022-09-08 07:04:57','633',3822603.95,3822603.95,'633','2022-09-07 07:52:39','559','2022-09-07 07:59:14',10,0),('1','185',258041,'MORNING','2022-09-07','2022-09-07 13:28:47','2022-09-08 13:28:47','633',3796679.00,3796679.00,'633','2022-09-07 14:39:23','559','2022-09-07 17:44:25',10,0),('1','185',258042,'AFTERNOON','2022-09-07','2022-09-08 07:40:43','2022-09-09 07:40:43','633',4149733.40,4149733.40,'633','2022-09-08 08:11:56','559','2022-09-08 08:21:01',10,0),('1','185',258043,'MORNING','2022-09-08','2022-09-08 14:05:03','2022-09-09 14:05:03','633',4245577.10,4245577.10,'633','2022-09-08 14:44:53','559','2022-09-08 14:46:44',10,0),('1','185',258044,'AFTERNOON','2022-09-08','2022-09-09 08:14:22','2022-09-10 08:14:22','633',3165065.65,3165065.65,'633','2022-09-09 08:37:06','634','2022-09-09 09:19:50',10,0),('1','185',258045,'MORNING','2022-09-09','2022-09-09 14:08:34','2022-09-10 14:08:34','633',3389786.35,3389786.35,'633','2022-09-09 14:34:38','559','2022-09-09 14:51:56',10,0),('1','185',258046,'AFTERNOON','2022-09-09','2022-09-09 14:57:42','2022-09-10 14:57:42','633',1474739.70,1474739.70,'633','2022-09-10 09:03:04','559','2022-09-10 12:37:29',10,0),('1','185',258047,'MORNING','2022-09-10','2022-09-10 15:49:29','2022-09-11 15:49:29','633',3780014.05,3780014.05,'633','2022-09-10 15:52:14','559','2022-09-10 18:26:31',10,0),('1','185',258048,'AFTERNOON ','2022-09-10','2022-09-11 07:08:20','2022-09-12 07:08:20','633',3215745.10,3215745.10,'633','2022-09-11 08:28:38','559','2022-09-11 08:31:25',10,0),('1','185',258049,'MORNING ','2022-09-11','2022-09-11 14:52:07','2022-09-12 14:52:07','633',3094871.60,3094871.60,'633','2022-09-11 14:59:34','559','2022-09-11 15:04:21',10,0),('1','185',258050,'AFTERNOON ','2022-09-11','2022-09-12 07:08:37','2022-09-13 07:08:37','633',2339197.35,2339197.35,'633','2022-09-12 07:18:17','559','2022-09-12 08:11:21',10,0),('1','185',258051,'DAY SHIFT ','2022-09-12','2022-09-13 05:41:42','2022-09-14 05:41:42','633',1604416.00,1604416.00,'633','2022-09-13 05:46:35','559','2022-09-13 08:13:06',10,0),('1','185',258052,'MORNING','2022-09-13','2022-09-13 14:11:28','2022-09-14 14:11:28','633',4112406.20,4112406.20,'633','2022-09-13 14:42:09','559','2022-09-13 15:25:05',10,0),('1','185',258053,'AFTERNOON ','2022-09-13','2022-09-14 07:25:56','2022-09-15 07:25:56','633',3850583.20,3850583.20,'633','2022-09-14 07:36:52','559','2022-09-14 08:06:40',10,0),('1','185',258054,'MORNING','2022-09-14','2022-09-14 14:39:31','2022-09-15 14:39:31','633',4190049.60,4190049.60,'633','2022-09-14 14:44:32','559','2022-09-14 15:04:42',10,0),('1','185',258055,'AFTERNOON','2022-09-14','2022-09-15 05:47:42','2022-09-16 05:47:42','633',2128341.30,2128341.30,'633','2022-09-15 05:55:16','559','2022-09-15 08:17:08',10,0),('1','185',258056,'MORNING','2022-09-15','2022-09-15 14:19:33','2022-09-16 14:19:33','633',3605681.45,3605681.45,'633','2022-09-15 14:26:52','559','2022-09-15 15:22:09',10,0),('1','185',258057,'AFTERNOON','2022-09-15','2022-09-16 07:45:35','2022-09-17 07:45:35','633',4175863.40,4175863.40,'633','2022-09-16 07:53:20','559','2022-09-16 08:04:08',10,0),('1','185',258058,'MORNING','2022-09-16','2022-09-16 15:48:06','2022-09-17 15:48:06','633',4771508.55,4771508.55,'633','2022-09-16 15:51:09','559','2022-09-17 07:14:29',10,0),('1','185',258059,'AFTERNOON','2022-09-16','2022-09-17 07:29:28','2022-09-18 07:29:28','633',3680421.45,3680421.45,'633','2022-09-17 07:43:23','559','2022-09-17 07:49:10',10,0),('1','185',258060,'MORNING','2022-09-17','2022-09-17 14:45:45','2022-09-18 14:45:45','633',3527222.10,3527222.10,'633','2022-09-17 14:48:27','559','2022-09-17 15:22:52',10,0),('1','185',258061,'AFTERNOON ','2022-09-17','2022-09-18 07:36:40','2022-09-19 07:36:40','633',3355277.85,3355277.85,'633','2022-09-18 07:55:23','559','2022-09-18 08:20:31',10,0),('1','185',258062,'MORNING','2022-09-18','2022-09-18 14:30:46','2022-09-19 14:30:46','633',2801790.60,2801790.60,'633','2022-09-18 14:32:50','559','2022-09-18 14:37:58',10,0),('1','185',258063,'AFTERNOON ','2022-09-18','2022-09-19 07:43:01','2022-09-20 07:43:01','633',533672.00,533672.00,'633','2022-09-19 07:49:24','559','2022-09-19 14:53:04',10,0),('1','185',258064,'DAY SHIFT','2022-09-19','2022-09-20 07:14:07','2022-09-21 07:14:07','633',2049133.60,2049133.60,'633','2022-09-20 07:17:22','559','2022-09-20 07:39:25',10,0),('1','185',258065,'MORNING ','2022-09-20','2022-09-20 14:44:27','2022-09-21 14:44:27','633',4858991.45,4858991.45,'633','2022-09-20 14:51:04','559','2022-09-20 15:10:28',10,0),('1','185',258066,'AFTERNOON ','2022-09-20','2022-09-21 07:12:53','2022-09-22 07:12:53','633',0.00,0.00,'633','2022-09-21 08:26:30','559','2022-09-21 08:32:15',10,0),('1','185',258067,'AFTERNOON','2022-09-20','2022-09-21 08:35:21','2022-09-22 08:35:21','633',3198974.75,3198974.75,'633','2022-09-21 08:40:14','559','2022-09-21 09:01:33',10,0),('1','185',258068,'MORNING','2022-09-21','2022-09-21 14:23:24','2022-09-22 14:23:24','633',3916895.85,3916895.85,'633','2022-09-21 14:28:32','559','2022-09-21 14:50:55',10,0),('1','185',258069,'AFTERNOON ','2022-09-21','2022-09-22 06:57:39','2022-09-23 06:57:39','633',1132654.60,1132654.60,'633','2022-09-22 07:02:14','559','2022-09-22 07:54:04',10,0),('1','185',258070,'MORNING','2022-09-22','2022-09-22 14:29:49','2022-09-23 14:29:49','633',3901334.45,3901334.45,'633','2022-09-22 14:34:24','559','2022-09-22 14:50:51',10,0),('1','185',258071,'AFTERNOON ','2022-09-22','2022-09-23 07:00:04','2022-09-24 07:00:04','633',0.00,0.00,'633','2022-09-23 07:41:20','559','2022-09-23 07:53:13',10,0),('1','185',258072,'AFTERNOON ','2022-09-22','2022-09-23 07:54:19','2022-09-24 07:54:19','633',3174394.00,3174394.00,'633','2022-09-23 07:59:57','559','2022-09-23 08:02:37',10,0),('1','185',258073,'MORNING','2022-09-23','2022-09-23 14:46:15','2022-09-24 14:46:15','633',3999765.75,3999765.75,'633','2022-09-23 14:49:59','559','2022-09-23 15:02:45',10,0),('1','185',258074,'AFTERNOON ','2022-09-23','2022-09-24 07:23:09','2022-09-25 07:23:09','633',538480.00,538480.00,'633','2022-09-24 07:26:31','559','2022-09-24 08:00:57',10,0),('1','185',258075,'MORNING','2022-09-24','2022-09-24 13:40:24','2022-09-25 13:40:24','633',5100082.30,5100082.30,'633','2022-09-24 14:54:40','559','2022-09-24 15:00:16',10,0),('1','185',258076,'AFTERNOON ','2022-09-24','2022-09-25 08:02:32','2022-09-26 08:02:32','633',3989178.20,3989178.20,'633','2022-09-25 08:10:19','559','2022-09-25 08:25:31',10,0),('1','185',258077,'MORNING','2022-09-25','2022-09-25 14:22:10','2022-09-26 14:22:10','633',2504180.85,2504180.85,'633','2022-09-25 14:25:41','559','2022-09-25 15:09:36',10,0),('1','185',258078,'AFTERNOON ','2022-09-25','2022-09-26 07:13:02','2022-09-27 07:13:02','633',579520.00,579520.00,'633','2022-09-26 07:16:55','559','2022-09-26 07:50:36',10,0),('1','185',258079,'MORNING ','2022-09-26','2022-09-26 14:24:03','2022-09-27 14:24:03','633',774064.00,774064.00,'633','2022-09-27 07:32:59','559','2022-09-27 07:36:13',10,0),('1','185',258080,'MORNING ','2022-09-27','2022-09-27 13:57:58','2022-09-28 13:57:58','633',5375589.40,5375589.40,'633','2022-09-27 14:25:26','559','2022-09-27 14:31:08',10,0),('1','185',258081,'AFTERNOON ','2022-09-27','2022-09-28 07:19:14','2022-09-29 07:19:14','633',3138573.10,3138573.10,'633','2022-09-28 07:26:11','559','2022-09-28 08:14:12',10,0),('1','185',258082,'DAY SHIFT','2022-09-28','2022-09-29 07:07:52','2022-09-30 07:07:52','633',2591391.20,2591391.20,'633','2022-09-29 07:17:09','559','2022-09-29 07:51:45',10,0),('1','185',258083,'MORNING','2022-09-29','2022-09-29 14:31:14','2022-09-30 14:31:14','633',3694067.05,3694067.05,'633','2022-09-29 14:36:43','559','2022-09-29 14:49:37',10,0),('1','185',258084,'AFTERNOON ','2022-09-29','2022-09-30 07:19:11','2022-10-01 07:19:11','633',1792953.40,1792953.40,'633','2022-09-30 07:25:12','559','2022-09-30 07:42:51',10,0),('1','185',258085,'MORNING','2022-09-30','2022-09-30 14:38:02','2022-10-01 14:38:02','633',4040370.40,4040370.40,'633','2022-09-30 14:42:33','559','2022-09-30 14:55:26',10,0),('1','185',258086,'AFTERNOON ','2022-09-30','2022-10-01 07:41:48','2022-10-02 07:41:48','633',3030488.70,3030488.70,'633','2022-10-01 07:48:24','559','2022-10-01 08:21:44',10,0),('1','185',258087,'DAY SHIFT','2022-10-01','2022-10-02 07:50:41','2022-10-03 07:50:41','633',848086.25,848086.25,'633','2022-10-02 07:55:35','559','2022-10-02 08:14:13',10,0),('1','185',258088,'MORNING','2022-10-04','2022-10-04 16:01:20','2022-10-05 16:01:20','633',7035960.65,7035960.65,'633','2022-10-04 16:08:05','559','2022-10-04 16:13:20',10,0),('1','185',258089,'AFTERNOON ','2022-10-04','2022-10-05 07:48:59','2022-10-06 07:48:59','633',2031628.05,2031628.05,'633','2022-10-05 07:55:03','559','2022-10-05 08:37:58',10,0),('1','185',258090,'MORNING','2022-10-05','2022-10-05 19:40:58','2022-10-06 19:40:58','633',5531748.75,5531748.75,'633','2022-10-05 20:04:17','559','2022-10-05 20:08:24',10,0),('1','185',258091,'AFTERNOON ','2022-10-05','2022-10-06 07:21:42','2022-10-07 07:21:42','633',1290250.95,1290250.95,'633','2022-10-06 07:24:51','559','2022-10-06 07:52:02',10,0),('1','185',258092,'MORNING','2022-10-06','2022-10-06 14:51:21','2022-10-07 14:51:21','633',6519342.25,6519342.25,'633','2022-10-06 16:13:54','559','2022-10-06 16:18:09',10,0),('1','185',258093,'AFTERNOON ','2022-10-06','2022-10-07 07:40:21','2022-10-08 07:40:21','633',5922428.90,5922428.90,'633','2022-10-07 07:50:32','559','2022-10-07 07:52:07',10,0),('1','185',258094,'DAY SHIFT','2022-10-07','2022-10-07 13:49:00','2022-10-08 13:49:00','633',1770806.10,1770806.10,'633','2022-10-07 18:41:23','559','2022-10-07 19:19:35',10,0),('1','185',258095,'MORNING','2022-10-08','2022-10-08 09:07:40','2022-10-09 09:07:40','633',5767580.35,5767580.35,'633','2022-10-08 14:46:57','559','2022-10-08 15:31:30',10,0),('1','185',258096,'AFTERNOON ','2022-10-08','2022-10-09 07:36:51','2022-10-10 07:36:51','633',1383805.55,1383805.55,'633','2022-10-09 07:41:41','559','2022-10-09 09:34:08',10,0),('1','185',258097,'DAY SHIFT','2022-10-09','2022-10-09 16:33:02','2022-10-10 16:33:02','633',3932881.70,3932881.70,'633','2022-10-09 16:38:52','559','2022-10-10 08:02:15',10,0),('1','185',258098,'DAY SHIFT','2022-10-11','2022-10-11 16:46:42','2022-10-12 16:46:42','633',3712398.70,3712398.70,'633','2022-10-11 16:52:32','559','2022-10-12 07:57:46',10,0),('1','185',258099,'AFTERNOON ','2022-10-12','2022-10-13 07:08:45','2022-10-14 07:08:45','633',3615714.00,3615714.00,'633','2022-10-13 07:31:12','559','2022-10-13 07:59:53',10,0),('1','185',258100,'MORNING ','2022-10-13','2022-10-13 20:03:14','2022-10-14 20:03:14','633',5020202.80,5020202.80,'633','2022-10-13 20:09:37','559','2022-10-13 20:14:46',10,0),('1','185',258101,'AFTERNOON','2022-10-13','2022-10-14 07:50:16','2022-10-15 07:50:16','633',1445220.90,1445220.90,'633','2022-10-14 07:53:22','559','2022-10-14 07:59:16',10,0),('1','185',258102,'MORNING','2022-10-14','2022-10-14 15:21:32','2022-10-15 15:21:32','633',5991144.25,5991144.25,'633','2022-10-14 15:34:28','559','2022-10-15 07:00:07',10,0),('1','185',258103,'AFTERNOON ','2022-10-14','2022-10-15 07:38:20','2022-10-16 07:38:20','633',3929027.05,3929027.05,'633','2022-10-15 07:44:40','559','2022-10-15 07:55:58',10,0),('1','185',258104,'MORNING','2022-10-15','2022-10-15 16:35:13','2022-10-16 16:35:13','633',3406499.95,3406499.95,'633','2022-10-15 16:44:10','559','2022-10-15 16:53:20',10,0),('1','185',258105,'AFTERNOON','2022-10-15','2022-10-16 08:08:59','2022-10-17 08:08:59','633',2216992.85,2216992.85,'633','2022-10-16 08:14:27','559','2022-10-16 08:38:42',10,0),('1','185',258106,'MORNING','2022-10-16','2022-10-16 17:47:17','2022-10-17 17:47:17','633',3818669.20,3818669.20,'633','2022-10-16 17:49:49','559','2022-10-17 07:59:48',10,0),('1','185',258107,'AFTERNOON ','2022-10-16','2022-10-17 08:43:19','2022-10-18 08:43:19','633',639515.00,639515.00,'633','2022-10-17 08:46:33','559','2022-10-17 11:31:55',10,0),('1','185',258108,'DAY SHIFT','2022-10-17','2022-10-18 07:40:00','2022-10-19 07:40:00','633',1635390.50,1635390.50,'633','2022-10-18 07:47:19','559','2022-10-18 07:55:34',10,0),('1','185',258109,'MORNING','2022-10-18','2022-10-18 14:44:56','2022-10-19 14:44:56','633',5215785.85,5215785.85,'633','2022-10-18 20:43:25','559','2022-10-19 07:46:47',10,0),('1','185',258110,'AFTERNOON','2022-10-18','2022-10-19 08:10:47','2022-10-20 08:10:47','633',4991201.75,4991201.75,'633','2022-10-19 08:17:03','559','2022-10-19 15:00:22',10,0),('1','185',258111,'MORNING','2022-10-19','2022-10-19 15:01:39','2022-10-20 15:01:39','633',5581974.15,5581974.15,'633','2022-10-19 15:08:49','559','2022-10-19 15:27:48',10,0),('1','185',258112,'AFTERNOON ','2022-10-19','2022-10-20 07:22:56','2022-10-21 07:22:56','633',464974.30,464974.30,'633','2022-10-20 07:25:55','559','2022-10-20 07:52:47',10,0),('1','185',258113,'MORNING','2022-10-20','2022-10-20 15:00:43','2022-10-21 15:00:43','633',3688553.15,3688553.15,'633','2022-10-20 16:08:22','559','2022-10-21 07:20:31',10,0),('1','185',258114,'AFTERNOON ','2022-10-20','2022-10-21 07:21:31','2022-10-22 07:21:31','633',989427.00,989427.00,'633','2022-10-21 07:25:55','634','2022-10-21 09:44:07',10,0),('1','185',258115,'MORNING','2022-10-21','2022-10-21 15:45:13','2022-10-22 15:45:13','633',6646392.40,6646392.40,'633','2022-10-21 15:54:54','559','2022-10-22 07:54:12',10,0),('1','185',258116,'AFTERNOON ','2022-10-21','2022-10-22 07:55:16','2022-10-23 07:55:16','633',609170.20,609170.20,'633','2022-10-22 07:58:03','559','2022-10-22 08:00:39',10,0),('1','185',258117,'DAY SHIFT','2022-10-22','2022-10-22 16:14:11','2022-10-23 16:14:11','633',3213861.35,3213861.35,'633','2022-10-22 18:57:03','559','2022-10-23 07:41:51',10,0),('1','185',258118,'DAY SHIFT','2022-10-23','2022-10-23 16:50:41','2022-10-24 16:50:41','633',2836236.85,2836236.85,'633','2022-10-23 16:53:14','559','2022-10-23 19:58:01',10,0),('1','185',258119,'DAY SHIFT','2022-10-24','2022-10-25 06:03:30','2022-10-26 06:03:30','633',1719062.80,1719062.80,'633','2022-10-25 08:52:19','559','2022-10-25 13:09:02',10,0),('1','185',258120,'MORNING','2022-10-25','2022-10-25 15:22:34','2022-10-26 15:22:34','633',4399096.40,4399096.40,'633','2022-10-25 18:52:58','559','2022-10-25 18:56:24',10,0),('1','185',258121,'AFTERNOON ','2022-10-25','2022-10-26 05:53:25','2022-10-27 05:53:25','633',1356487.05,1356487.05,'633','2022-10-26 06:01:01','559','2022-10-26 08:06:53',10,0),('1','185',258122,'MORNING','2022-10-26','2022-10-26 16:39:18','2022-10-27 16:39:18','633',4356066.60,4356066.60,'633','2022-10-26 16:43:48','559','2022-10-27 07:32:48',10,0),('1','185',258123,'AFTERNOON ','2022-10-26','2022-10-27 07:54:15','2022-10-28 07:54:15','633',509362.70,509362.70,'633','2022-10-27 08:08:49','559','2022-10-27 16:10:40',10,0),('1','185',258124,'DAY SHIFT','2022-10-27','2022-10-28 06:29:14','2022-10-29 06:29:14','633',454176.00,454176.00,'633','2022-10-28 06:33:34','559','2022-10-28 07:51:12',10,0),('1','185',258125,'MORNING','2022-10-28','2022-10-28 15:27:06','2022-10-29 15:27:06','633',3588865.20,3588865.20,'633','2022-10-28 15:37:50','559','2022-10-28 17:39:54',10,0),('1','185',258126,'AFTERNOON ','2022-10-28','2022-10-29 08:48:29','2022-10-30 08:48:29','633',430081.10,430081.10,'633','2022-10-29 08:53:14','559','2022-10-29 09:28:21',10,0),('1','185',258127,'DAY SHIFT','2022-10-29','2022-10-30 06:56:12','2022-10-31 06:56:12','633',1883328.10,1883328.10,'633','2022-10-30 07:02:40','559','2022-10-30 08:08:49',10,0),('1','185',258128,'MORNING','2022-10-30','2022-10-30 17:20:34','2022-10-31 17:20:34','633',5422872.35,5422872.35,'633','2022-10-31 09:38:46','559','2022-10-31 16:37:44',10,0),('1','185',258129,'MORNING','2022-10-31','2022-10-31 16:52:55','2022-11-01 16:52:55','633',4701362.45,4701362.45,'633','2022-10-31 17:17:58','559','2022-11-01 07:52:30',10,0),('1','185',258130,'AFTERNOON','2022-10-31','2022-11-01 07:54:16','2022-11-02 07:54:16','633',708753.60,708753.60,'633','2022-11-01 07:58:45','559','2022-11-01 08:02:36',10,0),('1','185',258131,'DAY SHIFT','2022-11-01','2022-11-01 23:25:04','2022-11-02 23:25:04','633',3163528.40,3163528.40,'633','2022-11-01 23:29:27','559','2022-11-02 08:02:26',10,0),('1','185',258132,'DAY SHIFT','2022-11-02','2022-11-02 23:06:57','2022-11-03 23:06:57','633',973731.10,973731.10,'633','2022-11-03 00:04:50','559','2022-11-03 07:56:33',10,0),('1','185',258133,'DAY SHIFT','2022-11-03','2022-11-04 05:56:08','2022-11-05 05:56:08','633',895985.00,895985.00,'633','2022-11-04 06:01:19','559','2022-11-04 07:36:01',10,0),('1','185',258134,'DAY SHIFT','2022-11-04','2022-11-04 23:40:14','2022-11-05 23:40:14','633',961115.10,961115.10,'633','2022-11-04 23:46:06','559','2022-11-05 09:08:43',10,0),('1','185',258135,'MORNING','2022-11-05','2022-11-05 17:42:08','2022-11-06 17:42:08','633',5119803.95,5119803.95,'633','2022-11-05 18:21:45','559','2022-11-05 18:42:09',10,0),('1','185',258136,'AFTERNOON','2022-11-05','2022-11-06 07:54:10','2022-11-07 07:54:10','633',1954000.40,1954000.40,'633','2022-11-06 07:59:20','559','2022-11-06 08:19:18',10,0),('1','185',258137,'MORNING','2022-11-06','2022-11-06 16:33:34','2022-11-07 16:33:34','633',3151964.05,3151964.05,'633','2022-11-06 16:47:56','559','2022-11-06 16:55:30',10,0),('1','185',258138,'AFTERNOON','2022-11-06','2022-11-07 07:48:43','2022-11-08 07:48:43','633',1388042.20,1388042.20,'633','2022-11-07 07:54:29','559','2022-11-07 08:34:11',10,0),('1','185',258139,'MORNING','2022-11-07','2022-11-07 14:24:36','2022-11-08 14:24:36','633',3684598.85,3684598.85,'633','2022-11-07 14:26:43','559','2022-11-07 15:23:42',10,0),('1','185',258140,'AFTERNOON','2022-11-07','2022-11-08 08:30:58','2022-11-09 08:30:58','633',512442.00,512442.00,'633','2022-11-08 08:33:54','559','2022-11-08 08:43:56',10,0),('1','185',258141,'MORNING ','2022-11-08','2022-11-08 14:55:22','2022-11-09 14:55:22','633',3426799.25,3426799.25,'633','2022-11-08 15:44:01','559','2022-11-09 07:35:16',10,0),('1','185',258142,'AFTERNOON ','2022-11-08','2022-11-09 07:36:53','2022-11-10 07:36:53','633',566765.50,566765.50,'633','2022-11-09 07:40:51','559','2022-11-09 11:13:21',10,0),('1','185',258143,'DAY SHIFT','2022-11-09','2022-11-10 07:05:57','2022-11-11 07:05:57','633',1599277.20,1599277.20,'633','2022-11-10 07:09:16','559','2022-11-10 07:43:57',10,0),('1','185',258144,'MORNING ','2022-11-10','2022-11-10 16:47:19','2022-11-11 16:47:19','633',579364.90,579364.90,'633','2022-11-10 16:48:24','559','2022-11-11 06:35:22',10,0),('1','185',258145,'AFTERNOON ','2022-11-10','2022-11-11 08:16:37','2022-11-12 08:16:37','633',131562.80,131562.80,'633','2022-11-11 08:19:51','559','2022-11-11 09:13:27',10,0),('1','185',258146,'DAY SHIFT','2022-11-11','2022-11-12 07:11:53','2022-11-13 07:11:53','633',1165635.40,1165635.40,'633','2022-11-12 07:36:36','559','2022-11-12 09:29:08',10,0),('1','185',258147,'DAY SHIFT','2022-11-12','2022-11-12 19:07:43','2022-11-13 19:07:43','633',7788333.50,7788333.50,'633','2022-11-12 19:16:47','559','2022-11-13 07:24:07',10,0),('1','185',258148,'DAY SHIFT','2022-11-13','2022-11-13 18:19:48','2022-11-14 18:19:48','633',4256246.90,4256246.90,'633','2022-11-13 22:15:15','559','2022-11-14 07:45:10',10,0),('1','185',258149,'DAY SHIFT','2022-11-14','2022-11-14 22:20:12','2022-11-15 22:20:12','633',3322862.70,3322862.70,'633','2022-11-14 22:25:18','559','2022-11-15 07:57:00',10,0),('1','185',258150,'DAY SHIFT','2022-11-15','2022-11-15 16:43:18','2022-11-16 16:43:18','633',4525515.65,4525515.65,'633','2022-11-15 18:28:47','559','2022-11-16 08:09:16',10,0),('1','185',258151,'AFTERNOON','2022-11-15','2022-11-16 08:14:31','2022-11-17 08:14:31','633',789308.00,789308.00,'633','2022-11-16 08:17:53','559','2022-11-16 10:42:38',10,0),('1','185',258152,'MORNING','2022-11-16','2022-11-16 16:18:55','2022-11-17 16:18:55','633',4993088.90,4993088.90,'633','2022-11-16 16:23:22','559','2022-11-16 22:26:16',10,0),('1','185',258153,'AFTERNOON','2022-11-16','2022-11-17 05:55:30','2022-11-18 05:55:30','633',3917385.90,3917385.90,'633','2022-11-17 05:59:25','559','2022-11-17 15:29:41',10,0),('1','185',258154,'MORNING','2022-11-17','2022-11-17 15:29:59','2022-11-18 15:29:59','633',5765372.95,5765372.95,'633','2022-11-17 15:32:06','559','2022-11-17 15:36:33',10,0),('1','185',258155,'AFTERNOON ','2022-11-17','2022-11-18 05:56:48','2022-11-19 05:56:48','633',803412.00,803412.00,'633','2022-11-18 05:58:59','559','2022-11-18 07:59:56',10,0),('1','185',258156,'MORNING','2022-11-18','2022-11-18 09:43:27','2022-11-19 09:43:27','633',4043992.05,4043992.05,'633','2022-11-18 15:18:44','559','2022-11-18 16:25:05',10,0),('1','185',258157,'AFTERNOON','2022-11-18','2022-11-19 08:27:56','2022-11-20 08:27:56','633',2805646.80,2805646.80,'633','2022-11-19 08:29:41','559','2022-11-19 13:15:12',10,0),('1','185',258158,'MORNING','2022-11-19','2022-11-19 15:26:26','2022-11-20 15:26:26','633',6654518.00,6654518.00,'633','2022-11-19 15:41:12','559','2022-11-19 16:07:50',10,0),('1','185',258159,'AFTERNOON ','2022-11-19','2022-11-20 05:04:19','2022-11-21 05:04:19','633',409552.00,409552.00,'633','2022-11-20 05:05:44','559','2022-11-20 08:28:01',10,0),('1','185',258160,'DAY SHIFT','2022-11-20','2022-11-20 23:35:58','2022-11-21 23:35:58','633',2274351.20,2274351.20,'633','2022-11-20 23:41:51','559','2022-11-21 06:18:50',10,0),('1','185',258161,'DAY SHIFT','2022-11-21','2022-11-21 18:30:16','2022-11-22 18:30:16','633',3006432.00,3006432.00,'633','2022-11-21 18:53:21','559','2022-11-21 21:04:12',10,0),('1','185',258162,'MORNING','2022-11-22','2022-11-22 15:21:57','2022-11-23 15:21:57','633',5253661.00,5253661.00,'633','2022-11-22 15:25:10','559','2022-11-22 16:42:04',10,0),('1','185',258163,'AFTERNOON ','2022-11-22','2022-11-23 05:56:28','2022-11-24 05:56:28','633',1562642.40,1562642.40,'633','2022-11-23 05:59:19','559','2022-11-23 08:11:16',10,0),('1','185',258164,'MORNING','2022-11-23','2022-11-23 15:37:56','2022-11-24 15:37:56','633',6173133.30,6173133.30,'633','2022-11-23 15:42:12','559','2022-11-23 16:16:47',10,0),('1','185',258165,'AFTERNOON ','2022-11-23','2022-11-24 07:30:04','2022-11-25 07:30:04','633',2067296.00,2067296.00,'633','2022-11-24 07:30:52','559','2022-11-24 07:45:53',10,0),('1','185',258166,'MORNING','2022-11-24','2022-11-24 18:13:10','2022-11-25 18:13:10','633',5489136.05,5489136.05,'633','2022-11-24 18:18:19','559','2022-11-25 06:31:57',10,0),('1','185',258167,'AFTERNOON ','2022-11-24','2022-11-25 07:53:43','2022-11-26 07:53:43','633',1511716.80,1511716.80,'633','2022-11-25 08:44:20','559','2022-11-25 16:37:54',10,0),('1','185',258168,'MORNING','2022-11-25','2022-11-25 16:55:16','2022-11-26 16:55:16','633',6082464.90,6082464.90,'633','2022-11-25 18:52:11','559','2022-11-25 20:38:36',10,0),('1','185',258169,'DAY SHIFT','2022-11-26','2022-11-26 17:21:08','2022-11-27 17:21:08','633',3379052.75,3379052.75,'633','2022-11-26 17:23:41','559','2022-11-26 18:32:50',10,0),('1','185',258170,'DAY SHIFT','2022-11-27','2022-11-27 19:16:18','2022-11-28 19:16:18','633',5886683.35,5886683.35,'633','2022-11-27 20:18:36','559','2022-11-28 08:31:05',10,0),('1','185',258171,'DAY SHIFT','2022-11-30','2022-11-30 21:11:20','2022-12-01 21:11:20','633',5855912.30,5855912.30,'633','2022-11-30 21:14:59','559','2022-11-30 21:20:09',10,0),('1','185',258172,'MORNING','2022-12-02','2022-12-02 22:41:03','2022-12-03 22:41:03','633',5875470.50,5875470.50,'633','2022-12-02 22:47:02','559','2022-12-03 08:21:31',10,0),('1','185',258173,'AFTERNOON ','2022-12-02','2022-12-03 08:23:47','2022-12-04 08:23:47','633',554936.80,554936.80,'633','2022-12-03 08:27:34','559','2022-12-03 14:05:25',10,0),('1','185',258174,'MORNING','2022-12-03','2022-12-03 17:40:58','2022-12-04 17:40:58','633',4377846.00,4377846.00,'633','2022-12-03 17:47:16','559','2022-12-03 21:08:06',10,0),('1','185',258175,'AFTERNOON ','2022-12-03','2022-12-04 08:19:40','2022-12-05 08:19:40','633',949757.60,949757.60,'633','2022-12-04 08:21:54','559','2022-12-04 14:58:50',10,0),('1','185',258176,'MORNING','2022-12-04','2022-12-04 14:59:17','2022-12-05 14:59:17','633',4265488.90,4265488.90,'633','2022-12-04 15:02:13','559','2022-12-05 06:47:07',10,0),('1','185',258177,'AFTERNOON ','2022-12-04','2022-12-05 08:32:20','2022-12-06 08:32:20','633',765333.00,765333.00,'633','2022-12-05 08:36:44','559','2022-12-05 10:23:29',10,0),('1','185',258178,'DAY SHIFT','2022-12-05','2022-12-05 22:14:06','2022-12-06 22:14:06','633',2228679.00,2228679.00,'633','2022-12-05 22:15:27','559','2022-12-06 06:20:15',10,0),('1','185',258179,'MORNING ','2022-12-06','2022-12-06 17:58:26','2022-12-07 17:58:26','633',4184355.05,4184355.05,'633','2022-12-06 18:22:38','559','2022-12-07 07:56:21',10,0),('1','185',258180,'AFTERNOON','2022-12-06','2022-12-07 10:55:50','2022-12-08 10:55:50','633',0.00,0.00,'633','2022-12-07 11:01:46','559','2022-12-07 11:05:44',10,0),('1','185',258181,'AFTERNOON','2022-12-06','2022-12-07 11:07:20','2022-12-08 11:07:20','633',1677035.90,1677035.90,'633','2022-12-07 11:09:09','559','2022-12-07 11:37:12',10,0),('1','185',258182,'MORNING','2022-12-07','2022-12-07 15:04:07','2022-12-08 15:04:07','633',4480812.70,4480812.70,'633','2022-12-07 18:59:03','559','2022-12-07 19:20:39',10,0),('1','185',258183,'AFTERNOON ','2022-12-07','2022-12-08 06:00:20','2022-12-09 06:00:20','633',1297887.00,1297887.00,'633','2022-12-08 06:01:27','559','2022-12-08 08:48:15',10,0),('1','185',258184,'DAY SHIFT','2022-12-08','2022-12-08 21:57:47','2022-12-09 21:57:47','633',2952984.40,2952984.40,'633','2022-12-08 21:58:39','559','2022-12-09 07:59:13',10,0),('1','185',258185,'DAY SHIFT ','2022-12-09','2022-12-09 13:31:38','2022-12-10 13:31:38','633',3136306.85,3136306.85,'633','2022-12-09 14:57:28','559','2022-12-09 20:34:24',10,0),('1','185',258186,'DAY SHIFT','2022-12-10','2022-12-11 07:12:16','2022-12-12 07:12:16','633',2501167.00,2501167.00,'633','2022-12-11 07:14:24','559','2022-12-11 08:02:15',10,0),('1','185',258187,'DAY SHIFT','2022-12-11','2022-12-11 17:06:43','2022-12-12 17:06:43','633',4633666.95,4633666.95,'633','2022-12-11 18:47:24','559','2022-12-11 20:37:12',10,0),('1','185',258188,'AFTERNOON ','2022-12-11','2022-12-12 07:28:45','2022-12-13 07:28:45','633',502485.10,502485.10,'633','2022-12-12 07:29:59','559','2022-12-12 08:26:49',10,0),('1','185',258189,'DAY SHIFT','2022-12-12','2022-12-12 23:02:55','2022-12-13 23:02:55','633',1733346.20,1733346.20,'633','2022-12-12 23:04:13','559','2022-12-13 08:37:26',10,0),('1','185',258190,'DAY SHIFT','2022-12-13','2022-12-13 18:03:00','2022-12-14 18:03:00','633',3029052.70,3029052.70,'633','2022-12-13 22:07:07','559','2022-12-14 13:25:07',10,0),('1','185',258191,'MORNING','2022-12-14','2022-12-15 01:16:39','2022-12-16 01:16:39','633',7335226.00,7335226.00,'633','2022-12-15 01:41:02','559','2022-12-15 07:31:23',10,0),('1','185',258192,'AFTERNOON','2022-12-14','2022-12-15 16:19:10','2022-12-16 16:19:10','633',849279.20,849279.20,'633','2022-12-15 16:21:10','559','2022-12-15 17:21:14',10,0),('1','185',258193,'MORNING','2022-12-15','2022-12-15 17:22:24','2022-12-16 17:22:24','633',4690150.95,4690150.95,'633','2022-12-15 17:25:32','559','2022-12-15 17:29:44',10,0),('1','185',258194,'AFTERNOON','2022-12-15','2022-12-16 07:46:01','2022-12-17 07:46:01','633',537424.80,537424.80,'633','2022-12-16 07:49:07','559','2022-12-16 12:07:12',10,0),('1','185',258195,'DAY SHIFT','2022-12-16','2022-12-16 17:17:23','2022-12-17 17:17:23','633',2051324.00,2051324.00,'633','2022-12-17 08:00:19','559','2022-12-17 08:02:21',10,0),('1','185',258196,'MORNING','2022-12-17','2022-12-17 14:53:57','2022-12-18 14:53:57','633',5859027.15,5859027.15,'633','2022-12-17 14:57:23','559','2022-12-17 19:56:34',10,0),('1','185',258197,'AFTERNOON','2022-12-17','2022-12-18 08:17:51','2022-12-19 08:17:51','633',492245.60,492245.60,'633','2022-12-18 08:21:00','559','2022-12-18 15:35:23',10,0),('1','185',258198,'MORNING','2022-12-18','2022-12-18 16:42:09','2022-12-19 16:42:09','633',6562880.40,6562880.40,'633','2022-12-18 16:48:46','559','2022-12-18 21:04:52',10,0),('1','185',258199,'AFTERNOON','2022-12-18','2022-12-19 08:14:54','2022-12-20 08:14:54','633',974476.80,974476.80,'633','2022-12-19 08:15:44','634','2022-12-19 10:03:47',10,0),('1','185',258200,'MORNING','2022-12-19','2022-12-19 15:10:41','2022-12-20 15:10:41','633',6012279.90,6012279.90,'633','2022-12-19 16:20:08','559','2022-12-20 08:15:50',10,0),('1','185',258201,'AFTERNOON','2022-12-19','2022-12-20 08:17:07','2022-12-21 08:17:07','633',3304356.00,3304356.00,'633','2022-12-20 08:17:54','559','2022-12-20 10:59:05',10,0),('1','185',258202,'MORNING ','2022-12-20','2022-12-20 16:05:32','2022-12-21 16:05:32','633',3703046.50,3703046.50,'633','2022-12-20 16:24:06','559','2022-12-20 16:30:20',10,0),('1','185',258203,'AFTERNOON ','2022-12-20','2022-12-21 00:33:13','2022-12-22 00:33:13','633',1859387.20,1859387.20,'633','2022-12-21 00:34:34','559','2022-12-21 07:51:28',10,0),('1','185',258204,'MORNING','2022-12-21','2022-12-21 14:54:50','2022-12-22 14:54:50','633',4986007.05,4986007.05,'633','2022-12-21 14:59:24','559','2022-12-21 15:04:20',10,0),('1','185',258205,'AFTERNOON','2022-12-21','2022-12-21 23:03:20','2022-12-22 23:03:20','633',602817.60,602817.60,'633','2022-12-22 00:09:25','559','2022-12-22 06:39:14',10,0),('1','185',258206,'DAY SHIFT','2022-12-22','2022-12-22 19:02:03','2022-12-23 19:02:03','633',1287660.00,1287660.00,'633','2022-12-23 07:14:27','559','2022-12-23 08:03:32',10,0),('1','185',258207,'MORNING','2022-12-23','2022-12-23 15:47:17','2022-12-24 15:47:17','633',3304399.25,3304399.25,'633','2022-12-23 15:51:58','559','2022-12-23 17:31:29',10,0),('1','185',258208,'AFTERNOON','2022-12-23','2022-12-24 08:22:01','2022-12-25 08:22:01','633',935334.40,935334.40,'633','2022-12-24 08:26:01','559','2022-12-24 08:43:31',10,0),('1','185',258209,'MORNING','2022-12-24','2022-12-24 14:59:22','2022-12-25 14:59:22','633',5234479.55,5234479.55,'633','2022-12-24 15:03:53','559','2022-12-24 15:33:51',10,0),('1','185',258210,'AFTERNOON','2022-12-24','2022-12-24 18:44:51','2022-12-25 18:44:51','633',548319.20,548319.20,'633','2022-12-24 18:45:41','559','2022-12-25 06:52:46',10,0),('1','185',258211,'MORNING','2022-12-25','2022-12-25 14:35:26','2022-12-26 14:35:26','633',3775447.60,3775447.60,'633','2022-12-25 14:52:29','559','2022-12-25 19:07:06',10,0),('1','185',258212,'AFTERNOON','2022-12-25','2022-12-25 19:11:23','2022-12-26 19:11:23','633',584496.00,584496.00,'633','2022-12-25 19:13:35','559','2022-12-26 08:14:24',10,0),('1','185',258213,'DAY SHIFT','2022-12-26','2022-12-27 01:04:43','2022-12-28 01:04:43','633',1235581.60,1235581.60,'633','2022-12-27 01:06:28','559','2022-12-27 07:51:12',10,0),('1','185',258214,'MORNING','2022-12-27','2022-12-27 19:21:33','2022-12-28 19:21:33','633',4962417.40,4962417.40,'633','2022-12-27 19:32:41','559','2022-12-28 07:41:31',10,0),('1','185',258215,'AFTERNOON','2022-12-27','2022-12-28 08:16:53','2022-12-29 08:16:53','633',1420760.00,1420760.00,'633','2022-12-28 08:17:54','559','2022-12-28 15:06:31',10,0),('1','185',258216,'MORNING','2022-12-28','2022-12-28 15:07:55','2022-12-29 15:07:55','633',6167633.40,6167633.40,'633','2022-12-28 15:17:46','559','2022-12-29 07:58:26',10,0),('1','185',258217,'AFTERNOON','2022-12-28','2022-12-29 08:30:18','2022-12-30 08:30:18','633',1125176.80,1125176.80,'633','2022-12-29 08:31:23','559','2022-12-29 08:44:53',10,0),('1','185',258218,'MORNING','2022-12-29','2022-12-29 14:18:05','2022-12-30 14:18:05','633',6226334.80,6226334.80,'633','2022-12-29 14:43:39','559','2022-12-29 20:43:16',10,0),('1','185',258219,'AFTERNOON','2022-12-29','2022-12-29 21:20:38','2022-12-30 21:20:38','633',680081.60,680081.60,'633','2022-12-29 21:55:37','559','2022-12-30 07:49:48',10,0),('1','185',258220,'MORNING','2022-12-30','2022-12-30 13:19:35','2022-12-31 13:19:35','633',4422405.65,4422405.65,'633','2022-12-30 15:03:11','559','2022-12-30 15:08:16',10,0),('1','185',258221,'AFTERNOON','2022-12-30','2022-12-30 23:50:12','2022-12-31 23:50:12','633',585596.00,585596.00,'633','2022-12-30 23:51:12','559','2022-12-31 08:56:56',10,0),('1','185',258222,'DAY SHIFT','2022-12-31','2022-12-31 19:34:21','2023-01-01 19:34:21','633',1288179.20,1288179.20,'633','2022-12-31 19:38:17','559','2023-01-01 08:11:27',10,0),('1','185',258223,'MORNING','2023-01-01','2023-01-01 11:33:58','2023-01-02 11:33:58','633',541622.40,541622.40,'633','2023-01-01 11:34:44','559','2023-01-01 12:35:32',10,0),('1','185',258224,'AFTERNOON','2023-01-02','2023-01-02 06:21:24','2023-01-03 06:21:24','633',842837.60,842837.60,'633','2023-01-02 06:36:28','559','2023-01-02 08:30:22',10,0),('1','185',258225,'MORNING','2023-01-02','2023-01-02 09:09:21','2023-01-03 09:09:21','633',6439621.20,6439621.20,'633','2023-01-02 16:51:06','559','2023-01-02 17:30:46',10,0),('1','185',258226,'AFTERNOON','2023-01-03','2023-01-03 08:11:46','2023-01-04 08:11:46','633',0.00,0.00,'633','2023-01-03 11:06:38','559','2023-01-03 11:08:29',10,0),('1','185',258227,'AFTERNOON','2023-01-02','2023-01-03 11:09:41','2023-01-04 11:09:41','633',668879.20,668879.20,'633','2023-01-03 11:12:38','559','2023-01-03 11:25:30',10,0),('1','185',258228,'MORNING','2023-01-03','2023-01-03 14:36:32','2023-01-04 14:36:32','633',3595298.45,3595298.45,'633','2023-01-03 14:43:10','559','2023-01-03 15:02:03',10,0),('1','185',258229,'AFTERNOON','2023-01-03','2023-01-03 16:18:53','2023-01-04 16:18:53','633',755524.00,755524.00,'633','2023-01-04 09:38:53','559','2023-01-04 09:49:02',10,0),('1','185',258230,'Morning/Afternoon','2023-01-04','2023-01-05 07:56:02','2023-01-06 07:56:02','633',1371937.60,1371937.60,'633','2023-01-05 07:57:48','559','2023-01-05 07:59:04',10,0),('1','185',258231,'MORNING','2023-01-05','2023-01-05 08:04:23','2023-01-06 08:04:23','633',6087543.75,6087543.75,'633','2023-01-05 19:25:06','559','2023-01-05 19:36:38',10,0),('1','185',258232,'AFTERNOON','2023-01-05','2023-01-05 21:13:31','2023-01-06 21:13:31','633',610068.80,610068.80,'633','2023-01-05 21:20:01','559','2023-01-05 21:23:12',10,0),('1','185',258233,'MORNING/AFTERNOON','2023-01-06','2023-01-06 10:20:14','2023-01-07 10:20:14','633',2113056.00,2113056.00,'633','2023-01-07 08:33:23','559','2023-01-07 08:38:38',10,0),('1','185',258234,'MORNING','2023-01-07','2023-01-07 15:26:51','2023-01-08 15:26:51','633',4783653.55,4783653.55,'633','2023-01-07 15:52:34','559','2023-01-07 15:55:33',10,0),('1','185',258235,'AFTERNOON','2023-01-07','2023-01-07 20:55:22','2023-01-08 20:55:22','633',350134.40,350134.40,'633','2023-01-07 21:01:52','559','2023-01-08 01:08:35',10,0),('1','185',258236,'MORNING','2023-01-08','2023-01-08 14:41:09','2023-01-09 14:41:09','633',4486750.80,4486750.80,'633','2023-01-08 14:49:13','559','2023-01-08 14:52:25',10,0),('1','185',258237,'AFTERNOON','2023-01-08','2023-01-08 21:45:37','2023-01-09 21:45:37','633',663933.60,663933.60,'633','2023-01-09 08:12:46','559','2023-01-09 08:14:34',10,0),('1','185',258238,'MORNING/AFTERNOON','2023-01-09','2023-01-10 08:35:43','2023-01-11 08:35:43','633',1595985.60,1595985.60,'633','2023-01-10 08:41:07','559','2023-01-10 08:42:34',10,0),('1','185',258239,'MORNING/AFTERNOON','2023-01-10','2023-01-10 20:07:02','2023-01-11 20:07:02','633',1680157.60,1680157.60,'633','2023-01-10 20:25:01','559','2023-01-10 20:28:06',10,0),('1','185',258240,'MORNING/AFTERNOON','2023-01-11','2023-01-11 20:31:21','2023-01-12 20:31:21','633',1961520.00,1961520.00,'633','2023-01-11 20:37:20','559','2023-01-11 20:40:34',10,0),('1','185',258241,'MORNING','2023-01-12','2023-01-12 14:48:34','2023-01-13 14:48:34','633',3513781.20,3513781.20,'633','2023-01-12 15:07:14','559','2023-01-12 15:12:58',10,0),('1','185',258242,'AFTERNOON','2023-01-12','2023-01-12 20:51:31','2023-01-13 20:51:31','633',854735.20,854735.20,'633','2023-01-12 21:01:09','559','2023-01-12 21:03:05',10,0),('1','185',258243,'MORNING','2023-01-13','2023-01-13 15:47:59','2023-01-14 15:47:59','633',4167569.15,4167569.15,'633','2023-01-13 16:51:07','559','2023-01-13 16:54:25',10,0),('1','185',258244,'AFTERNOON','2023-01-13','2023-01-13 20:22:29','2023-01-14 20:22:29','633',741408.80,741408.80,'633','2023-01-14 08:57:28','559','2023-01-14 09:00:57',10,0),('1','185',258245,'MORNING/AFTERNOON','2023-01-14','2023-01-14 11:18:02','2023-01-15 11:18:02','633',1613541.60,1613541.60,'633','2023-01-14 20:40:59','559','2023-01-14 20:44:34',10,0),('1','185',258246,'MORNING','2023-01-15','2023-01-15 19:06:44','2023-01-16 19:06:44','633',5539071.00,5539071.00,'633','2023-01-15 19:13:40','559','2023-01-15 19:15:03',10,0),('1','185',258247,'AFTERNOON','2023-01-15','2023-01-15 20:37:50','2023-01-16 20:37:50','633',180523.20,180523.20,'633','2023-01-15 20:47:22','559','2023-01-15 20:48:49',10,0),('1','185',258248,'MORNING/AFTERNOON','2023-01-16','2023-01-16 18:23:12','2023-01-17 18:23:12','633',902422.40,902422.40,'633','2023-01-16 20:04:28','559','2023-01-16 20:07:33',10,0),('1','185',258249,'MORNING/AFTERNOON','2023-01-17','2023-01-17 17:31:05','2023-01-18 17:31:05','633',3745859.65,3745859.65,'633','2023-01-17 18:17:03','559','2023-01-17 18:19:57',10,0),('1','185',258250,'MORNING','2023-01-18','2023-01-18 16:49:41','2023-01-19 16:49:41','633',3134214.50,3134214.50,'633','2023-01-18 16:57:32','559','2023-01-18 17:01:41',10,0),('1','185',258251,'AFTERNOON','2023-01-18','2023-01-19 09:20:35','2023-01-20 09:20:35','633',626052.00,626052.00,'633','2023-01-19 09:33:27','559','2023-01-19 09:36:25',10,0),('1','185',258252,'MORNING/AFTERNOON','2023-01-19','2023-01-19 17:04:43','2023-01-20 17:04:43','633',1440180.60,1440180.60,'633','2023-01-19 21:43:07','559','2023-01-19 21:44:53',10,0),('1','185',258253,'MORNING/AFTERNOON','2023-01-20','2023-01-20 19:15:09','2023-01-21 19:15:09','633',1280083.20,1280083.20,'633','2023-01-20 19:24:32','559','2023-01-20 19:25:57',10,0),('1','185',258254,'MORNING','2023-01-21','2023-01-21 16:43:07','2023-01-22 16:43:07','633',6440814.90,6440814.90,'633','2023-01-21 16:52:09','559','2023-01-21 16:53:41',10,0),('1','185',258255,'AFTERNOON','2023-01-21','2023-01-21 23:19:07','2023-01-22 23:19:07','633',427204.80,427204.80,'633','2023-01-21 23:24:23','559','2023-01-21 23:25:52',10,0),('1','185',258256,'MORNING','2023-01-22','2023-01-22 11:35:41','2023-01-23 11:35:41','633',3872367.90,3872367.90,'633','2023-01-22 14:25:20','559','2023-01-22 14:31:06',10,0),('1','185',258257,'AFTERNOON','2023-01-22','2023-01-22 21:14:35','2023-01-23 21:14:35','633',1125258.00,1125258.00,'633','2023-01-22 21:32:54','559','2023-01-22 21:35:28',10,0),('1','185',258258,'MORNING','2023-01-23','2023-01-23 14:35:11','2023-01-24 14:35:11','633',4907367.30,4907367.30,'633','2023-01-23 15:10:27','559','2023-01-23 15:15:08',10,0),('1','185',258259,'AFTERNOON','2023-01-23','2023-01-23 20:35:28','2023-01-24 20:35:28','633',651821.40,651821.40,'633','2023-01-24 09:57:24','559','2023-01-24 09:58:52',10,0),('1','185',258260,'MORNING/AFTERNOON','2023-01-24','2023-01-24 22:12:40','2023-01-25 22:12:40','633',1227213.30,1227213.30,'633','2023-01-24 22:23:58','559','2023-01-24 22:25:31',10,0),('1','185',258261,'MORNING/AFTERNOON','2023-01-25','2023-01-25 22:04:22','2023-01-26 22:04:22','633',1277647.20,1277647.20,'633','2023-01-25 22:17:30','559','2023-01-25 22:19:57',10,0),('1','185',258262,'MORNING','2023-01-26','2023-01-26 17:37:58','2023-01-27 17:37:58','633',5036410.70,5036410.70,'633','2023-01-26 18:03:16','559','2023-01-26 18:06:20',10,0),('1','185',258263,'AFTERNOON','2023-01-26','2023-01-26 22:07:31','2023-01-27 22:07:31','633',559401.30,559401.30,'633','2023-01-26 22:26:06','559','2023-01-26 22:29:01',10,0),('1','185',258264,'MORNING','2023-01-27','2023-01-27 16:31:30','2023-01-28 16:31:30','633',3550879.50,3550879.50,'633','2023-01-27 17:25:17','559','2023-01-27 17:30:44',10,0),('1','185',258265,'AFTERNOON','2023-01-27','2023-01-27 21:58:10','2023-01-28 21:58:10','633',688693.80,688693.80,'633','2023-01-27 22:40:36','559','2023-01-27 22:43:39',10,0),('1','185',258266,'MORNING','2023-01-28','2023-01-28 17:51:32','2023-01-29 17:51:32','633',4908823.00,4908823.00,'633','2023-01-28 18:08:30','559','2023-01-28 18:11:01',10,0),('1','185',258267,'AFTERNOON','2023-01-28','2023-01-28 20:55:26','2023-01-29 20:55:26','633',449650.00,449650.00,'633','2023-01-29 12:08:52','559','2023-01-29 12:12:12',10,0),('1','185',258268,'MORNING/AFTERNOON','2023-01-29','2023-01-29 21:05:20','2023-01-30 21:05:20','633',550137.00,550137.00,'633','2023-01-30 09:36:59','559','2023-01-30 09:38:22',10,0),('1','185',258269,'MORNING/AFTERNOON','2023-01-30','2023-01-30 11:41:37','2023-01-31 11:41:37','633',798906.50,798906.50,'633','2023-01-31 09:35:51','559','2023-01-31 09:37:04',10,0),('1','185',258270,'MORNING/AFTERNOON','2023-01-31','2023-01-31 21:37:07','2023-02-01 21:37:07','633',1386426.50,1386426.50,'633','2023-01-31 21:44:57','559','2023-01-31 21:46:58',10,0),('1','185',258271,'MORNING/AFTERNOON','2023-02-01','2023-02-01 21:35:55','2023-02-02 21:35:55','633',1500258.50,1500258.50,'633','2023-02-02 09:57:28','559','2023-02-02 10:01:32',10,0),('1','185',258272,'MORNING','2023-02-02','2023-02-02 18:21:24','2023-02-03 18:21:24','633',7288823.60,7288823.60,'633','2023-02-02 18:40:35','559','2023-02-02 18:42:35',10,0),('1','185',258273,'AFTERNOON','2023-02-02','2023-02-02 22:19:31','2023-02-03 22:19:31','633',380035.00,380035.00,'633','2023-02-03 09:41:36','559','2023-02-03 09:43:13',10,0),('1','185',258274,'MORNING/AFTERNOON','2023-02-03','2023-02-03 17:53:42','2023-02-04 17:53:42','633',268447.00,268447.00,'633','2023-02-03 21:19:24','559','2023-02-03 21:23:59',10,0),('1','185',258275,'MORNING/AFTERNOON','2023-02-04','2023-02-04 22:48:35','2023-02-05 22:48:35','633',4621008.00,4621008.00,'633','2023-02-04 22:56:50','559','2023-02-04 23:00:44',10,0),('1','185',258276,'MORNING','2023-02-05','2023-02-05 15:42:49','2023-02-06 15:42:49','633',5491143.00,5491143.00,'633','2023-02-05 15:49:27','559','2023-02-05 15:51:50',10,0),('1','185',258277,'AFTERNOON','2023-02-05','2023-02-05 22:09:31','2023-02-06 22:09:31','633',251132.00,251132.00,'633','2023-02-05 22:23:51','559','2023-02-05 22:45:23',10,0),('1','185',258278,'MORNING/AFTERNOON','2023-02-06','2023-02-07 09:18:51','2023-02-08 09:18:51','633',851368.50,851368.50,'633','2023-02-07 11:43:08','559','2023-02-07 11:49:22',10,0),('1','185',258279,'MORNING/AFTERNOON','2023-02-07','2023-02-07 21:15:53','2023-02-08 21:15:53','633',832167.00,832167.00,'633','2023-02-08 10:02:29','559','2023-02-08 10:04:38',10,0),('1','185',258280,'MORNING/AFTERNOON','2023-02-08','2023-02-08 21:35:20','2023-02-09 21:35:20','633',1420511.50,1420511.50,'633','2023-02-09 09:13:34','559','2023-02-09 09:14:56',10,0),('1','185',258281,'MORNING/AFTERNOON','2023-02-09','2023-02-09 21:41:43','2023-02-10 21:41:43','633',1338506.50,1338506.50,'633','2023-02-09 21:50:31','559','2023-02-09 21:52:45',10,0),('1','185',258282,'MORNING','2023-02-10','2023-02-10 21:30:36','2023-02-11 21:30:36','633',4926545.60,4926545.60,'633','2023-02-10 21:46:18','559','2023-02-10 21:49:37',10,0),('1','185',258283,'AFTERNOON','2023-02-10','2023-02-10 21:54:21','2023-02-11 21:54:21','633',638626.10,638626.10,'633','2023-02-11 09:31:17','559','2023-02-11 09:34:48',10,0),('1','185',258284,'MORNING/AFTERNOON','2023-02-11','2023-02-11 21:53:53','2023-02-12 21:53:53','633',1358641.70,1358641.70,'633','2023-02-11 22:01:41','559','2023-02-11 22:08:59',10,0),('1','185',258285,'MORNING','2023-02-12','2023-02-12 18:09:03','2023-02-13 18:09:03','633',4503325.80,4503325.80,'633','2023-02-12 18:14:22','559','2023-02-12 23:45:15',10,0),('1','185',258286,'AFTERNOON','2023-02-12','2023-02-13 00:41:57','2023-02-14 00:41:57','633',245754.80,245754.80,'633','2023-02-13 00:48:51','559','2023-02-13 00:51:13',10,0),('1','185',258287,'MORNING','2023-02-13','2023-02-13 17:30:04','2023-02-14 17:30:04','633',3867869.20,3867869.20,'633','2023-02-13 17:38:43','559','2023-02-13 17:40:48',10,0),('1','185',258288,'AFTERNOON','2023-02-13','2023-02-13 21:36:42','2023-02-14 21:36:42','633',328151.00,328151.00,'633','2023-02-14 07:08:04','559','2023-02-14 07:09:29',10,0),('1','185',258289,'MORNING','2023-02-14','2023-02-14 21:57:46','2023-02-15 21:57:46','633',3496184.10,3496184.10,'633','2023-02-14 22:02:39','559','2023-02-14 22:04:05',10,0),('1','185',258290,'AFTERNOON','2023-02-14','2023-02-14 22:05:52','2023-02-15 22:05:52','633',270002.50,270002.50,'633','2023-02-14 22:13:14','559','2023-02-14 22:15:10',10,0),('1','185',258291,'MORNING','2023-02-15','2023-02-15 18:39:29','2023-02-16 18:39:29','633',3320738.90,3320738.90,'633','2023-02-15 18:49:10','559','2023-02-15 19:17:48',10,0),('1','185',258292,'AFTERNOON','2023-02-15','2023-02-15 21:42:08','2023-02-16 21:42:08','633',280160.00,280160.00,'633','2023-02-16 11:04:40','559','2023-02-16 11:06:33',10,0),('1','185',258293,'MORNING','2023-02-16','2023-02-17 02:07:45','2023-02-18 02:07:45','633',6566556.10,6566556.10,'633','2023-02-17 02:18:08','559','2023-02-17 02:23:53',10,0),('1','185',258294,'AFTERNOON','2023-02-16','2023-02-17 02:25:17','2023-02-18 02:25:17','633',379099.50,379099.50,'633','2023-02-17 02:35:49','559','2023-02-17 07:13:42',10,0),('1','185',258295,'MORNING','2023-02-17','2023-02-17 17:20:02','2023-02-18 17:20:02','633',7307158.50,7307158.50,'633','2023-02-17 20:57:24','559','2023-02-17 21:00:04',10,0),('1','185',258296,'AFTERNOON','2023-02-17','2023-02-17 21:04:06','2023-02-18 21:04:06','633',185495.50,185495.50,'633','2023-02-17 21:09:39','559','2023-02-18 13:26:22',10,0),('1','185',258297,'MORNING','2023-02-18','2023-02-18 17:05:08','2023-02-19 17:05:08','633',6146183.60,6146183.60,'633','2023-02-18 21:27:53','559','2023-02-18 21:31:04',10,0),('1','185',258298,'AFTERNOON','2023-02-18','2023-02-19 09:27:21','2023-02-20 09:27:21','633',3171396.50,3171396.50,'633','2023-02-19 09:41:41','559','2023-02-19 09:43:09',10,0),('1','185',258299,'MORNING','2023-02-19','2023-02-19 19:42:21','2023-02-20 19:42:21','633',7963034.80,7963034.80,'633','2023-02-19 19:51:12','559','2023-02-19 19:55:22',10,0),('1','185',258300,'AFTERNOON','2023-02-19','2023-02-19 23:11:14','2023-02-20 23:11:14','633',3555400.70,3555400.70,'633','2023-02-20 09:31:24','559','2023-02-20 10:00:44',10,0),('1','185',258301,'MORNING/AFTERNOON','2023-02-20','2023-02-21 01:56:20','2023-02-22 01:56:20','633',9697844.40,9697844.40,'633','2023-02-21 10:55:47','559','2023-02-21 10:58:09',10,0),('1','185',258302,'MORNING','2023-02-21','2023-02-21 19:12:41','2023-02-22 19:12:41','633',6613151.80,6613151.80,'633','2023-02-22 08:22:38','559','2023-02-22 08:23:54',10,0),('1','185',258303,'AFTERNOON','2023-02-21','2023-02-22 08:34:39','2023-02-23 08:34:39','633',3875829.60,3875829.60,'633','2023-02-22 10:57:08','559','2023-02-22 10:58:53',10,0),('1','185',258304,'MORNING','2023-02-22','2023-02-22 17:29:09','2023-02-23 17:29:09','633',8252104.10,8252104.10,'633','2023-02-22 19:10:48','559','2023-02-22 19:13:37',10,0),('1','185',258305,'AFTERNOON','2023-02-22','2023-02-23 09:58:46','2023-02-24 09:58:46','633',75811.50,75811.50,'633','2023-02-23 10:04:32','559','2023-02-23 10:05:59',10,0),('1','185',258306,'MORNING','2023-02-23','2023-02-23 19:45:06','2023-02-24 19:45:06','633',8375477.00,8375477.00,'633','2023-02-23 20:45:34','559','2023-02-23 20:49:19',10,0),('1','185',258307,'AFTERNOON','2023-02-23','2023-02-23 20:50:22','2023-02-24 20:50:22','633',3282313.40,3282313.40,'633','2023-02-24 08:56:10','559','2023-02-24 08:59:23',10,0),('1','185',258308,'MORNING','2023-02-24','2023-02-24 20:40:02','2023-02-25 20:40:02','633',7183783.10,7183783.10,'633','2023-02-24 21:00:31','559','2023-02-24 21:02:37',10,0),('1','185',258309,'AFTERNOON','2023-02-24','2023-02-24 23:50:29','2023-02-25 23:50:29','633',4211166.40,4211166.40,'633','2023-02-25 09:34:41','559','2023-02-25 21:23:34',10,0),('1','185',258310,'MORNING/AFTERNOON','2023-02-25','2023-02-26 19:22:51','2023-02-27 19:22:51','633',1554675.10,1554675.10,'633','2023-02-26 19:44:46','559','2023-02-26 19:47:03',10,0),('1','185',258311,'MORNING','2023-02-26','2023-02-26 19:53:52','2023-02-27 19:53:52','633',7271331.10,7271331.10,'633','2023-02-26 20:20:38','559','2023-02-26 20:23:01',10,0),('1','185',258312,'AFTERNOON','2023-02-26','2023-02-26 20:26:04','2023-02-27 20:26:04','633',3765918.20,3765918.20,'633','2023-02-27 08:30:44','559','2023-02-27 08:32:16',10,0),('1','185',258313,'MORNING','2023-02-27','2023-02-27 17:13:28','2023-02-28 17:13:28','633',3734170.80,3734170.80,'633','2023-02-27 17:53:14','559','2023-02-27 17:54:49',10,0),('1','185',258314,'AFTERNOON','2023-02-27','2023-02-27 22:34:36','2023-02-28 22:34:36','633',752342.00,752342.00,'633','2023-02-28 10:35:28','559','2023-02-28 10:37:09',10,0),('1','185',258315,'MORNING','2023-02-28','2023-02-28 18:20:03','2023-03-01 18:20:03','633',8484912.40,8484912.40,'633','2023-02-28 19:14:34','559','2023-02-28 19:24:23',10,0),('1','185',258316,'AFTERNOON','2023-02-28','2023-02-28 22:40:14','2023-03-01 22:40:14','633',3774681.50,3774681.50,'633','2023-03-01 09:20:48','559','2023-03-01 09:22:16',10,0),('1','185',258317,'MORNING','2023-03-01','2023-03-01 23:21:59','2023-03-02 23:21:59','633',3914740.50,3914740.50,'633','2023-03-01 23:33:11','559','2023-03-01 23:52:51',10,0),('1','185',258318,'AFTERNOON','2023-03-01','2023-03-01 23:53:50','2023-03-02 23:53:50','633',959720.70,959720.70,'633','2023-03-02 09:14:37','559','2023-03-02 09:15:33',10,0),('1','185',258319,'MORNING','2023-03-02','2023-03-02 16:50:10','2023-03-03 16:50:10','633',3664297.60,3664297.60,'633','2023-03-02 16:58:50','559','2023-03-02 16:59:55',10,0),('1','185',258320,'AFTERNOON','2023-03-02','2023-03-03 06:43:36','2023-03-04 06:43:36','633',4243407.50,4243407.50,'633','2023-03-03 09:35:50','559','2023-03-03 09:38:47',10,0),('1','185',258321,'MORNING/AFTERNOON','2023-03-03','2023-03-03 15:07:57','2023-03-04 15:07:57','633',1732151.90,1732151.90,'633','2023-03-04 13:38:51','559','2023-03-04 13:41:44',10,0),('1','185',258322,'MORNING','2023-03-04','2023-03-04 18:43:23','2023-03-05 18:43:23','633',7059747.00,7059747.00,'633','2023-03-04 19:06:00','559','2023-03-04 19:09:27',10,0),('1','185',258323,'AFTERNOON','2023-03-04','2023-03-04 19:13:55','2023-03-05 19:13:55','633',589117.40,589117.40,'633','2023-03-04 19:40:13','559','2023-03-05 10:57:26',10,0),('1','185',258324,'MORNING/AFTERNOON','2023-03-05','2023-03-05 23:43:39','2023-03-06 23:43:39','633',2301382.50,2301382.50,'633','2023-03-06 00:44:07','559','2023-03-06 09:41:56',10,0),('1','185',258325,'MORNING/AFTERNOON','2023-03-06','2023-03-06 22:24:20','2023-03-07 22:24:20','633',1660182.60,1660182.60,'633','2023-03-06 22:34:07','559','2023-03-07 08:34:10',10,0),('1','185',258326,'MORNING','2023-03-07','2023-03-07 17:31:07','2023-03-08 17:31:07','633',7435224.50,7435224.50,'633','2023-03-07 17:46:05','559','2023-03-07 17:48:08',10,0),('1','185',258327,'AFTERNOON','2023-03-07','2023-03-07 22:09:44','2023-03-08 22:09:44','633',3030607.70,3030607.70,'633','2023-03-08 10:51:40','559','2023-03-08 10:52:53',10,0),('1','185',258328,'MORNING/AFTERNOON','2023-03-08','2023-03-08 21:20:29','2023-03-09 21:20:29','633',2452876.40,2452876.40,'633','2023-03-08 22:12:52','559','2023-03-08 22:14:56',10,0),('1','185',258329,'MORNING','2023-03-09','2023-03-09 18:24:28','2023-03-10 18:24:28','633',7339037.00,7339037.00,'633','2023-03-09 19:10:57','559','2023-03-09 19:19:28',10,0),('1','185',258330,'AFTERNOON','2023-03-09','2023-03-09 19:26:54','2023-03-10 19:26:54','633',1062167.60,1062167.60,'633','2023-03-10 10:52:44','559','2023-03-10 10:53:52',10,0),('1','185',258331,'MORNING','2023-03-10','2023-03-10 20:18:31','2023-03-11 20:18:31','633',7119518.70,7119518.70,'633','2023-03-10 20:33:57','559','2023-03-10 20:35:01',10,0),('1','185',258332,'AFTERNOON','2023-03-10','2023-03-10 23:46:29','2023-03-11 23:46:29','633',3310912.50,3310912.50,'633','2023-03-11 07:19:53','559','2023-03-11 07:20:57',10,0),('1','185',258333,'MORNING/AFTERNOON','2023-03-11','2023-03-11 19:41:23','2023-03-12 19:41:23','633',7010568.30,7010568.30,'633','2023-03-11 20:00:25','559','2023-03-12 06:20:09',10,0),('1','185',258334,'MORNING','2023-03-12','2023-03-12 17:49:30','2023-03-13 17:49:30','633',7951871.60,7951871.60,'633','2023-03-12 19:20:07','559','2023-03-12 19:22:16',10,0),('1','185',258335,'AFTERNOON','2023-03-12','2023-03-12 19:30:05','2023-03-13 19:30:05','633',635240.50,635240.50,'633','2023-03-13 10:06:26','559','2023-03-13 10:08:27',10,0),('1','185',258336,'MORNING/AFTERNOON','2023-03-13','2023-03-13 19:45:30','2023-03-14 19:45:30','633',1542042.80,1542042.80,'633','2023-03-13 20:15:06','559','2023-03-13 20:18:42',10,0),('1','185',258337,'MORNING','2023-03-14','2023-03-14 19:35:53','2023-03-15 19:35:53','633',6829481.70,6829481.70,'633','2023-03-14 19:44:48','559','2023-03-14 19:46:59',10,0),('1','185',258338,'AFTERNOON','2023-03-14','2023-03-14 19:47:54','2023-03-15 19:47:54','633',1033888.80,1033888.80,'633','2023-03-14 19:50:08','559','2023-03-14 19:52:26',10,0),('1','185',258339,'MORNING','2023-03-15','2023-03-15 15:07:13','2023-03-16 15:07:13','633',5282261.60,5282261.60,'633','2023-03-15 15:34:50','559','2023-03-15 15:37:03',10,0),('1','185',258340,'AFTERNOON','2023-03-15','2023-03-15 15:37:53','2023-03-16 15:37:53','633',1525134.40,1525134.40,'633','2023-03-16 09:30:21','559','2023-03-16 09:31:27',10,0),('1','185',258341,'MORNING','2023-03-16','2023-03-16 19:15:20','2023-03-17 19:15:20','633',9104071.80,9104071.80,'633','2023-03-16 19:30:28','559','2023-03-16 19:36:35',10,0),('1','185',258342,'AFTERNOON','2023-03-16','2023-03-16 19:37:08','2023-03-17 19:37:08','633',1039235.20,1039235.20,'633','2023-03-17 03:10:48','559','2023-03-17 03:12:34',10,0),('1','185',258343,'MORNING','2023-03-17','2023-03-17 20:36:00','2023-03-18 20:36:00','633',12326234.30,12326234.30,'633','2023-03-17 20:51:09','559','2023-03-17 20:53:24',10,0),('1','185',258344,'AFTERNOON','2023-03-17','2023-03-17 20:57:05','2023-03-18 20:57:05','633',2076912.40,2076912.40,'633','2023-03-18 09:11:51','559','2023-03-18 09:14:11',10,0),('1','185',258345,'MORNING','2023-03-19','2023-03-19 19:40:41','2023-03-20 19:40:41','633',9148756.40,9148756.40,'633','2023-03-19 19:48:30','559','2023-03-19 19:50:12',10,0),('1','185',258346,'AFTERNOON','2023-03-19','2023-03-19 19:51:05','2023-03-20 19:51:05','633',6340912.90,6340912.90,'633','2023-03-20 11:24:47','559','2023-03-20 11:26:17',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4917530 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','185','935','204072',3968039,'2744','415',507.30,836.41,329.11,53644.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','204072',3968040,'2745','415',689.68,4122.34,3432.66,559523.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','204072',3968041,'2746','415',582.54,1560.22,977.68,159361.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','204072',3968042,'2747','415',610.54,4008.97,3398.43,553944.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','204072',3968043,'2748','415',569.85,4316.03,3746.18,610627.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','204072',3968044,'2749','415',513.95,513.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','204072',3968045,'2750','415',789.89,3260.11,2470.22,402645.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','204072',3968046,'2751','415',1021.82,1654.38,632.56,103107.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','204072',3968047,'2752','415',617.18,4139.24,3522.06,574095.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','204072',3968048,'2753','415',722.09,722.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','204072',3968049,'2754','415',689.77,4011.66,3321.89,541468.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','204072',3968050,'2755','415',795.42,795.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','204072',3968051,'2756','416',791.52,2017.65,1226.13,343316.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','204072',3968052,'2757','416',854.24,1599.30,745.06,208616.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','204072',3968053,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204072',3968054,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204123',3969141,'2744','415',836.41,1574.28,737.87,120272.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','204123',3969142,'2745','415',4122.34,9437.17,5314.83,866317.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','204123',3969143,'2746','415',1560.22,2294.04,733.82,119612.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','204123',3969144,'2747','415',4008.97,8746.29,4737.32,772183.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','204123',3969145,'2748','415',4316.03,9364.22,5048.19,822854.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','204123',3969146,'2749','415',513.95,514.43,0.48,78.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','204123',3969147,'2750','415',3260.11,7232.01,3971.90,647419.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','204123',3969148,'2751','415',1654.38,1654.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','204123',3969149,'2752','415',4139.24,8746.35,4607.11,750958.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','204123',3969150,'2753','415',722.09,1770.42,1048.33,170877.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','204123',3969151,'2754','415',4011.66,8350.40,4338.74,707214.62,0.00,0.00,0.00,0.00,0.00),('1','185','936','204123',3969152,'2755','415',795.42,1235.14,439.72,71674.36,0.00,0.00,0.00,0.00,0.00),('1','185','937','204123',3969153,'2756','416',2017.65,3329.26,1311.61,367250.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','204123',3969154,'2757','416',1599.30,3799.60,2200.30,616084.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204123',3969155,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204123',3969156,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204125',3969174,'2744','415',1574.28,4444.51,2870.23,467847.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','204125',3969175,'2745','415',9437.17,13585.05,4147.88,676104.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','204125',3969176,'2746','415',2294.04,5241.10,2947.06,480370.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','204125',3969177,'2747','415',8746.29,12606.85,3860.56,629271.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','204125',3969178,'2748','415',9364.22,13709.31,4345.09,708249.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','204125',3969179,'2749','415',514.43,1309.61,795.18,129614.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','204125',3969180,'2750','415',7232.01,10637.67,3405.66,555122.58,0.00,0.00,0.00,0.00,0.00),('1','185','936','204125',3969181,'2751','415',1654.38,2556.05,901.67,146972.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','204125',3969182,'2752','415',8746.35,12937.28,4190.93,683121.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','204125',3969183,'2753','415',1770.42,2166.02,395.60,64482.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','204125',3969184,'2754','415',8350.40,12495.52,4145.12,675654.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','204125',3969185,'2755','415',1235.14,1533.00,297.86,48551.18,0.00,0.00,0.00,0.00,0.00),('1','185','937','204125',3969186,'2756','416',3329.26,4723.21,1393.95,390306.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','204125',3969187,'2757','416',3799.60,5264.27,1464.67,410107.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','204125',3969188,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204125',3969189,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204131',3969270,'2744','415',4444.51,8029.06,3554.55,579391.65,0.00,0.00,30.00,0.00,0.00),('1','185','935','204131',3969271,'2745','415',13585.05,18255.82,4640.77,756445.51,0.00,0.00,30.00,0.00,0.00),('1','185','935','204131',3969272,'2746','415',5241.10,8459.54,3168.44,516455.72,0.00,0.00,50.00,0.00,0.00),('1','185','935','204131',3969273,'2747','415',12606.85,16690.50,4053.65,660744.95,0.00,0.00,30.00,0.00,0.00),('1','185','935','204131',3969274,'2748','415',13709.31,17160.31,3391.00,552733.00,0.00,0.00,60.00,0.00,0.00),('1','185','935','204131',3969275,'2749','415',1309.61,5751.41,4411.80,719123.40,0.00,0.00,30.00,0.00,0.00),('1','185','936','204131',3969276,'2750','415',10637.67,13321.31,2653.64,432543.32,0.00,0.00,30.00,0.00,0.00),('1','185','936','204131',3969277,'2751','415',2556.05,2596.05,10.00,1630.00,0.00,0.00,30.00,0.00,0.00),('1','185','936','204131',3969278,'2752','415',12937.28,16983.94,3976.66,648195.58,0.00,0.00,70.00,0.00,0.00),('1','185','936','204131',3969279,'2753','415',2166.02,2206.02,10.00,1630.00,0.00,0.00,30.00,0.00,0.00),('1','185','936','204131',3969280,'2754','415',12495.52,15998.88,3473.36,566157.68,0.00,0.00,30.00,0.00,0.00),('1','185','936','204131',3969281,'2755','415',1533.00,1563.00,0.00,0.00,0.00,0.00,30.00,0.00,0.00),('1','185','937','204131',3969282,'2756','416',4723.21,6152.08,1428.87,400083.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','204131',3969283,'2757','416',5264.27,7785.21,2520.94,705863.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','204131',3969284,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204131',3969285,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204134',3969352,'2744','415',8029.06,10947.07,2918.01,475635.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','204134',3969353,'2745','415',18255.82,21536.17,3280.35,534697.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','204134',3969354,'2746','415',8459.54,11314.69,2855.15,465389.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','204134',3969355,'2747','415',16690.50,19986.39,3295.89,537230.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','204134',3969356,'2748','415',17160.31,20095.60,2935.29,478452.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','204134',3969357,'2749','415',5751.41,8728.63,2977.22,485286.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','204134',3969358,'2750','415',13321.31,15790.34,2469.03,402451.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','204134',3969359,'2751','415',2596.05,4637.89,2041.84,332819.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','204134',3969360,'2752','415',16983.94,21010.36,4026.42,656306.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','204134',3969361,'2753','415',2206.02,3493.29,1287.27,209825.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','204134',3969362,'2754','415',15998.88,18582.28,2583.40,421094.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','204134',3969363,'2755','415',1563.00,2921.97,1358.97,221512.11,0.00,0.00,0.00,0.00,0.00),('1','185','937','204134',3969364,'2756','416',6152.08,7904.72,1752.64,490739.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','204134',3969365,'2757','416',7785.21,9104.86,1319.65,369502.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204134',3969366,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204134',3969367,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204314',3972466,'2744','415',10947.07,14584.56,3627.49,591280.87,0.00,0.00,10.00,0.00,0.00),('1','185','935','204314',3972467,'2745','415',21536.17,25109.04,3562.87,580747.81,0.00,0.00,10.00,0.00,0.00),('1','185','935','204314',3972468,'2746','415',11314.69,14153.45,2828.76,461087.88,0.00,0.00,10.00,0.00,0.00),('1','185','935','204314',3972469,'2747','415',19986.39,23788.22,3791.83,618068.29,0.00,0.00,10.00,0.00,0.00),('1','185','935','204314',3972470,'2748','415',20095.60,22687.29,2581.69,420815.47,0.00,0.00,10.00,0.00,0.00),('1','185','935','204314',3972471,'2749','415',8728.63,11944.17,3195.54,520873.02,0.00,0.00,20.00,0.00,0.00),('1','185','936','204314',3972472,'2750','415',15790.34,18760.55,2960.21,482514.23,0.00,0.00,10.00,0.00,0.00),('1','185','936','204314',3972473,'2751','415',4637.89,6349.42,1701.53,277349.39,0.00,0.00,10.00,0.00,0.00),('1','185','936','204314',3972474,'2752','415',21010.36,24298.39,3278.03,534318.89,0.00,0.00,10.00,0.00,0.00),('1','185','936','204314',3972475,'2753','415',3493.29,5688.07,2184.78,356119.14,0.00,0.00,10.00,0.00,0.00),('1','185','936','204314',3972476,'2754','415',18582.28,20553.79,1961.51,319726.13,0.00,0.00,10.00,0.00,0.00),('1','185','936','204314',3972477,'2755','415',2921.97,4527.63,1595.66,260092.58,0.00,0.00,10.00,0.00,0.00),('1','185','937','204314',3972478,'2756','416',7904.72,9017.17,1112.45,311486.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','204314',3972479,'2757','416',9104.86,11224.16,2119.30,593404.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204314',3972480,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204314',3972481,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204556',3976991,'2744','415',14584.56,17981.55,3396.99,553709.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','204556',3976992,'2745','415',25109.04,28388.95,3279.91,534625.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','204556',3976993,'2746','415',14153.45,17427.73,3274.28,533707.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','204556',3976994,'2747','415',23788.22,27372.63,3584.41,584258.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','204556',3976995,'2748','415',22687.29,25990.42,3303.13,538410.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','204556',3976996,'2749','415',11944.17,14384.03,2439.86,397697.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','204556',3976997,'2750','415',18760.55,20410.78,1650.23,268987.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','204556',3976998,'2751','415',6349.42,7868.60,1519.18,247626.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','204556',3976999,'2752','415',24298.39,26866.60,2568.21,418618.23,0.00,0.00,0.00,0.00,0.00),('1','185','936','204556',3977000,'2753','415',5688.07,7781.64,2093.57,341251.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','204556',3977001,'2754','415',20553.79,22340.11,1786.32,291170.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','204556',3977002,'2755','415',4527.63,5944.75,1417.12,230990.56,0.00,0.00,0.00,0.00,0.00),('1','185','937','204556',3977003,'2756','416',9017.17,10130.04,1112.87,311603.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','204556',3977004,'2757','416',11224.16,12667.97,1443.81,404266.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','204556',3977005,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204556',3977006,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204690',3979157,'2744','415',17981.55,21010.45,3028.90,493710.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','204690',3979158,'2745','415',28388.95,31614.23,3225.28,525720.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','204690',3979159,'2746','415',17427.73,19725.77,2298.04,374580.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','204690',3979160,'2747','415',27372.63,30311.85,2939.22,479092.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','204690',3979161,'2748','415',25990.42,29129.92,3139.50,511738.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','204690',3979162,'2749','415',14384.03,16334.82,1950.79,317978.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','204690',3979163,'2750','415',20410.78,22731.27,2320.49,378239.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','204690',3979164,'2751','415',7868.60,10250.50,2381.90,388249.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','204690',3979165,'2752','415',26866.60,29951.48,3084.88,502835.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','204690',3979166,'2753','415',7781.64,10021.05,2239.41,365023.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','204690',3979167,'2754','415',22340.11,24965.27,2625.16,427901.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','204690',3979168,'2755','415',5944.75,7210.82,1266.07,206369.41,0.00,0.00,0.00,0.00,0.00),('1','185','937','204690',3979169,'2756','416',10130.04,11708.60,1578.56,441996.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','204690',3979170,'2757','416',12667.97,14012.74,1344.77,376535.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','204690',3979171,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204690',3979172,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','204899',3982533,'2744','415',21010.45,24007.83,2997.38,488572.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','204899',3982534,'2745','415',31614.23,34620.10,3005.87,489956.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','204899',3982535,'2746','415',19725.77,22103.79,2378.02,387617.26,0.00,0.00,0.00,0.00,0.00),('1','185','935','204899',3982536,'2747','415',30311.85,33578.99,3267.14,532543.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','204899',3982537,'2748','415',29129.92,32308.80,3178.88,518157.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','204899',3982538,'2749','415',16334.82,18480.15,2145.33,349688.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','204899',3982539,'2750','415',22731.27,24994.06,2262.79,368834.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','204899',3982540,'2751','415',10250.50,11966.13,1715.63,279647.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','204899',3982541,'2752','415',29951.48,32496.46,2544.98,414831.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','204899',3982542,'2753','415',10021.05,11837.13,1816.08,296021.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','204899',3982543,'2754','415',24965.27,27520.59,2555.32,416517.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','204899',3982544,'2755','415',7210.82,8841.55,1630.73,265808.99,0.00,0.00,0.00,0.00,0.00),('1','185','937','204899',3982545,'2756','416',11708.60,12743.40,1034.80,289744.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','204899',3982546,'2757','416',14012.74,15670.73,1657.99,464237.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','204899',3982547,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','204899',3982548,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','205094',3985982,'2744','415',24007.83,27345.28,3337.45,544004.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','205094',3985983,'2745','415',34620.10,38761.01,4140.91,674968.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','205094',3985984,'2746','415',22103.79,25125.42,3021.63,492525.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','205094',3985985,'2747','415',33578.99,37069.43,3490.44,568941.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','205094',3985986,'2748','415',32308.80,35297.59,2988.79,487172.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','205094',3985987,'2749','415',18480.15,20799.03,2318.88,377977.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','205094',3985988,'2750','415',24994.06,26923.10,1929.04,314433.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','205094',3985989,'2751','415',11966.13,14517.64,2551.51,415896.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','205094',3985990,'2752','415',32496.46,35267.30,2770.84,451646.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','205094',3985991,'2753','415',11837.13,14032.78,2195.65,357890.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','205094',3985992,'2754','415',27520.59,31063.15,3542.56,577437.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','205094',3985993,'2755','415',8841.55,10260.94,1419.39,231360.57,0.00,0.00,0.00,0.00,0.00),('1','185','937','205094',3985994,'2756','416',12743.40,13985.57,1242.17,347807.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','205094',3985995,'2757','416',15670.73,17280.04,1609.31,450606.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','205094',3985996,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','205094',3985997,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','205294',3989704,'2744','415',27345.28,30675.45,3330.17,542817.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','205294',3989705,'2745','415',38761.01,42386.16,3625.15,590899.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','205294',3989706,'2746','415',25125.42,27788.60,2663.18,434098.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','205294',3989707,'2747','415',37069.43,41184.66,4115.23,670782.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','205294',3989708,'2748','415',35297.59,38467.88,3170.29,516757.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','205294',3989709,'2749','415',20799.03,24250.44,3451.41,562579.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','205294',3989710,'2750','415',26923.10,29450.74,2527.64,412005.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','205294',3989711,'2751','415',14517.64,16439.24,1921.60,313220.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','205294',3989712,'2752','415',35267.30,38306.49,3039.19,495387.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','205294',3989713,'2753','415',14032.78,15853.46,1820.68,296770.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','205294',3989714,'2754','415',31063.15,33490.89,2427.74,395721.62,0.00,0.00,0.00,0.00,0.00),('1','185','936','205294',3989715,'2755','415',10260.94,12119.24,1858.30,302902.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','205294',3989716,'2756','416',13985.57,14904.67,919.10,257348.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','205294',3989717,'2757','416',17280.04,17928.60,648.56,181596.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','205294',3989718,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','205294',3989719,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','205600',3995362,'2744','415',30675.45,33646.11,2970.66,484217.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','205600',3995363,'2745','415',42386.16,45992.68,3606.52,587862.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','205600',3995364,'2746','415',27788.60,29828.45,2039.85,332495.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','205600',3995365,'2747','415',41184.66,43982.08,2797.42,455979.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','205600',3995366,'2748','415',38467.88,40735.37,2267.49,369600.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','205600',3995367,'2749','415',24250.44,26105.92,1855.48,302443.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','205600',3995368,'2750','415',29450.74,31693.89,2243.15,365633.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','205600',3995369,'2751','415',16439.24,18594.03,2154.79,351230.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','205600',3995370,'2752','415',38306.49,40882.43,2575.94,419878.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','205600',3995371,'2753','415',15853.46,18317.34,2463.88,401612.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','205600',3995372,'2754','415',33490.89,36088.87,2597.98,423470.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','205600',3995373,'2755','415',12119.24,13804.07,1684.83,274627.29,0.00,0.00,0.00,0.00,0.00),('1','185','937','205600',3995374,'2756','416',14904.67,16253.69,1349.02,377725.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','205600',3995375,'2757','416',17928.60,20156.22,2227.62,623733.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','205600',3995376,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','205600',3995377,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','205841',3999636,'2744','415',33646.11,37003.65,3357.54,547279.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','205841',3999637,'2745','415',45992.68,48741.64,2748.96,448080.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','205841',3999638,'2746','415',29828.45,33052.42,3223.97,525507.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','205841',3999639,'2747','415',43982.08,46649.20,2667.12,434740.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','205841',3999640,'2748','415',40735.37,44780.25,4044.88,659315.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','205841',3999641,'2749','415',26105.92,28004.71,1898.79,309502.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','205841',3999642,'2750','415',31693.89,33744.47,2050.58,334244.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','205841',3999643,'2751','415',18594.03,20493.53,1899.50,309618.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','205841',3999644,'2752','415',40882.43,43323.10,2440.67,397829.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','205841',3999645,'2753','415',18317.34,20846.52,2529.18,412256.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','205841',3999646,'2754','415',36088.87,38698.05,2609.18,425296.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','205841',3999647,'2755','415',13804.07,15680.60,1876.53,305874.39,0.00,0.00,0.00,0.00,0.00),('1','185','937','205841',3999648,'2756','416',16253.69,18423.75,2170.06,629317.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','205841',3999649,'2757','416',20156.22,21995.93,1839.71,533515.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','205841',3999650,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','205841',3999651,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206020',4002806,'2744','415',37003.65,39610.13,2606.48,424856.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','206020',4002807,'2745','415',48741.64,52361.90,3620.26,590102.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','206020',4002808,'2746','415',33052.42,35272.59,2220.17,361887.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','206020',4002809,'2747','415',46649.20,50530.56,3881.36,632661.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','206020',4002810,'2748','415',44780.25,47487.30,2707.05,441249.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','206020',4002811,'2749','415',28004.71,30800.52,2795.81,455717.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','206020',4002812,'2750','415',33744.47,35778.97,2034.50,331623.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','206020',4002813,'2751','415',20493.53,22851.98,2358.45,384427.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','206020',4002814,'2752','415',43323.10,46596.26,3273.16,533525.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','206020',4002815,'2753','415',20846.52,23169.86,2323.34,378704.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','206020',4002816,'2754','415',38698.05,40662.86,1964.81,320264.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','206020',4002817,'2755','415',15680.60,18561.50,2880.90,469586.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','206020',4002818,'2756','416',18423.75,19618.79,1195.04,346561.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','206020',4002819,'2757','416',21995.93,24473.52,2477.59,718501.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','206020',4002820,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206020',4002821,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206195',4005900,'2744','415',39610.13,42081.13,2471.00,402773.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206195',4005901,'2745','415',52361.90,53930.26,1568.36,255642.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','206195',4005902,'2746','415',35272.59,36248.91,976.32,159140.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','206195',4005903,'2747','415',50530.56,52158.74,1628.18,265393.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','206195',4005904,'2748','415',47487.30,48262.60,775.30,126373.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','206195',4005905,'2749','415',30800.52,32300.54,1500.02,244503.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','206195',4005906,'2750','415',35778.97,37688.23,1909.26,311209.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','206195',4005907,'2751','415',22851.98,23110.38,258.40,42119.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','206195',4005908,'2752','415',46596.26,48801.84,2205.58,359509.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','206195',4005909,'2753','415',23169.86,23175.38,5.52,899.76,0.00,0.00,0.00,0.00,0.00),('1','185','936','206195',4005910,'2754','415',40662.86,42800.20,2137.34,348386.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','206195',4005911,'2755','415',18561.50,18561.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206195',4005912,'2756','416',19618.79,20081.01,462.22,134043.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','206195',4005913,'2757','416',24473.52,24918.32,444.80,128992.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206195',4005914,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206195',4005915,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206312',4008137,'2744','415',42081.13,44045.02,1963.89,320114.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','206312',4008138,'2745','415',53930.26,56094.48,2164.22,352767.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','206312',4008139,'2746','415',36248.91,38317.26,2068.35,337141.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','206312',4008140,'2747','415',52158.74,54387.50,2228.76,363287.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','206312',4008141,'2748','415',48262.60,49586.74,1324.14,215834.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','206312',4008142,'2749','415',32300.54,33966.23,1665.69,271507.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','206312',4008143,'2750','415',37688.23,39614.24,1926.01,313939.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','206312',4008144,'2751','415',23110.38,23626.50,516.12,84127.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','206312',4008145,'2752','415',48801.84,51603.45,2801.61,456662.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','206312',4008146,'2753','415',23175.38,23175.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206312',4008147,'2754','415',42800.20,45516.21,2716.01,442709.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','206312',4008148,'2755','415',18561.50,18728.03,166.53,27144.39,0.00,0.00,0.00,0.00,0.00),('1','185','937','206312',4008149,'2756','416',20081.01,20822.16,741.15,214933.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','206312',4008150,'2757','416',24918.32,25295.21,376.89,109298.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','206312',4008151,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206312',4008152,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206424',4009807,'2744','415',44045.02,45501.47,1456.45,237401.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','206424',4009808,'2745','415',56094.48,57654.57,1560.09,254294.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','206424',4009809,'2746','415',38317.26,38647.30,330.04,53796.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','206424',4009810,'2747','415',54387.50,55970.63,1583.13,258050.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','206424',4009811,'2748','415',49586.74,51460.89,1874.15,305486.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','206424',4009812,'2749','415',33966.23,34633.09,666.86,108698.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','206424',4009813,'2750','415',39614.24,40974.72,1360.48,221758.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','206424',4009814,'2751','415',23626.50,23626.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206424',4009815,'2752','415',51603.45,53418.83,1815.38,295906.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','206424',4009816,'2753','415',23175.38,23175.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206424',4009817,'2754','415',45516.21,47488.27,1972.06,321445.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','206424',4009818,'2755','415',18728.03,18728.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206424',4009819,'2756','416',20822.16,21208.89,386.73,112151.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','206424',4009820,'2757','416',25295.21,25471.06,175.85,50996.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','206424',4009821,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206424',4009822,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206531',4011924,'2744','415',45501.47,47171.72,1670.25,272250.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','206531',4011925,'2745','415',57654.57,59562.66,1908.09,311018.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','206531',4011926,'2746','415',38647.30,40533.85,1886.55,307507.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','206531',4011927,'2747','415',55970.63,57661.00,1690.37,275530.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','206531',4011928,'2748','415',51460.89,53204.85,1743.96,284265.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','206531',4011929,'2749','415',34633.09,35765.22,1132.13,184537.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','206531',4011930,'2750','415',40974.72,43315.17,2340.45,381493.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','206531',4011931,'2751','415',23626.50,24647.61,1021.11,166440.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','206531',4011932,'2752','415',53418.83,56172.14,2753.31,448789.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','206531',4011933,'2753','415',23175.38,23185.38,10.00,1630.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206531',4011934,'2754','415',47488.27,49685.92,2197.65,358216.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','206531',4011935,'2755','415',18728.03,18738.03,10.00,1630.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206531',4011936,'2756','416',21208.89,21737.48,528.59,153291.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','206531',4011937,'2757','416',25471.06,25808.25,337.19,97785.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','206531',4011938,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206531',4011939,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206635',4013580,'2744','415',47171.72,48930.19,1758.47,286630.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','206635',4013581,'2745','415',59562.66,61295.52,1732.86,282456.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','206635',4013582,'2746','415',40533.85,41946.12,1412.27,230200.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','206635',4013583,'2747','415',57661.00,59332.50,1671.50,272454.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','206635',4013584,'2748','415',53204.85,54181.21,976.36,159146.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','206635',4013585,'2749','415',35765.22,38301.95,2536.73,413486.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','206635',4013586,'2750','415',43315.17,45493.09,2177.92,355000.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','206635',4013587,'2751','415',24647.61,24647.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206635',4013588,'2752','415',56172.14,58379.53,2207.39,359804.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','206635',4013589,'2753','415',23185.38,23185.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206635',4013590,'2754','415',49685.92,51976.78,2290.86,373410.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','206635',4013591,'2755','415',18738.03,18738.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206635',4013592,'2756','416',21737.48,22721.42,983.94,285342.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','206635',4013593,'2757','416',25808.25,26085.89,277.64,80515.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','206635',4013594,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206635',4013595,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206734',4015411,'2744','415',48930.19,50526.20,1596.01,260149.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','206734',4015412,'2745','415',61295.52,63483.77,2188.25,356684.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','206734',4015413,'2746','415',41946.12,43807.22,1861.10,303359.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','206734',4015414,'2747','415',59332.50,61798.13,2465.63,401897.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','206734',4015415,'2748','415',54181.21,56154.71,1973.50,321680.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','206734',4015416,'2749','415',38301.95,39117.50,815.55,132934.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','206734',4015417,'2750','415',45493.09,48019.29,2526.20,411770.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','206734',4015418,'2751','415',24647.61,24647.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206734',4015419,'2752','415',58379.53,60693.80,2314.27,377226.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','206734',4015420,'2753','415',23185.38,23185.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206734',4015421,'2754','415',51976.78,54018.70,2041.92,332832.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','206734',4015422,'2755','415',18738.03,18738.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206734',4015423,'2756','416',22721.42,23926.36,1204.94,349432.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','206734',4015424,'2757','416',26085.89,26450.62,364.73,105771.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','206734',4015425,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206734',4015426,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206846',4017226,'2744','415',50526.20,52347.90,1821.70,296937.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','206846',4017227,'2745','415',63483.77,65087.28,1603.51,261372.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','206846',4017228,'2746','415',43807.22,45591.13,1783.91,290777.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','206846',4017229,'2747','415',61798.13,63510.93,1712.80,279186.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','206846',4017230,'2748','415',56154.71,58016.37,1861.66,303450.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','206846',4017231,'2749','415',39117.50,39758.87,641.37,104543.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','206846',4017232,'2750','415',48019.29,49740.13,1720.84,280496.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','206846',4017233,'2751','415',24647.61,24647.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206846',4017234,'2752','415',60693.80,62891.26,2197.46,358185.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','206846',4017235,'2753','415',23185.38,23185.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','206846',4017236,'2754','415',54018.70,55861.92,1843.22,300444.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','206846',4017237,'2755','415',18738.03,18738.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206846',4017238,'2756','416',23926.36,24486.76,560.40,162516.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','206846',4017239,'2757','416',26450.62,27868.19,1417.57,411095.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','206846',4017240,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206846',4017241,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','206975',4019872,'2744','415',52347.90,54399.92,2042.02,332849.26,0.00,0.00,10.00,0.00,0.00),('1','185','935','206975',4019873,'2745','415',65087.28,67690.19,2592.91,422644.33,0.00,0.00,10.00,0.00,0.00),('1','185','935','206975',4019874,'2746','415',45591.13,47372.32,1751.19,285443.97,0.00,0.00,30.00,0.00,0.00),('1','185','935','206975',4019875,'2747','415',63510.93,65984.12,2453.19,399869.97,0.00,0.00,20.00,0.00,0.00),('1','185','935','206975',4019876,'2748','415',58016.37,60361.52,2335.15,380629.45,0.00,0.00,10.00,0.00,0.00),('1','185','935','206975',4019877,'2749','415',39758.87,40485.09,706.22,115113.86,0.00,0.00,20.00,0.00,0.00),('1','185','936','206975',4019878,'2750','415',49740.13,51626.92,1866.79,304286.77,0.00,0.00,20.00,0.00,0.00),('1','185','936','206975',4019879,'2751','415',24647.61,25874.35,1216.74,198328.62,0.00,0.00,10.00,0.00,0.00),('1','185','936','206975',4019880,'2752','415',62891.26,64325.56,1424.30,232160.90,0.00,0.00,10.00,0.00,0.00),('1','185','936','206975',4019881,'2753','415',23185.38,24679.78,1474.40,240327.20,0.00,0.00,20.00,0.00,0.00),('1','185','936','206975',4019882,'2754','415',55861.92,58160.74,2288.82,373077.66,0.00,0.00,10.00,0.00,0.00),('1','185','936','206975',4019883,'2755','415',18738.03,18738.03,-10.00,-1630.00,0.00,0.00,10.00,0.00,0.00),('1','185','937','206975',4019884,'2756','416',24486.76,26019.20,1532.44,444407.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','206975',4019885,'2757','416',27868.19,28941.03,1072.84,311123.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','206975',4019886,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','206975',4019887,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207094',4021755,'2744','415',54399.92,56094.18,1694.26,276164.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','207094',4021756,'2745','415',67690.19,69187.10,1496.91,243996.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','207094',4021757,'2746','415',47372.32,48909.17,1536.85,250506.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','207094',4021758,'2747','415',65984.12,67857.22,1873.10,305315.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','207094',4021759,'2748','415',60361.52,62427.27,2065.75,336717.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','207094',4021760,'2749','415',40485.09,40741.38,256.29,41775.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','207094',4021761,'2750','415',51626.92,53534.59,1907.67,310950.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','207094',4021762,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207094',4021763,'2752','415',64325.56,66187.87,1862.31,303556.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','207094',4021764,'2753','415',24679.78,25008.26,328.48,53542.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','207094',4021765,'2754','415',58160.74,59908.79,1748.05,284932.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','207094',4021766,'2755','415',18738.03,18738.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207094',4021767,'2756','416',26019.20,27347.87,1328.67,385314.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','207094',4021768,'2757','416',28941.03,30419.04,1478.01,428622.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','207094',4021769,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207094',4021770,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207277',4025037,'2744','415',56094.18,57193.14,1098.96,179130.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','207277',4025038,'2745','415',69187.10,71727.25,2540.15,414044.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','207277',4025039,'2746','415',48909.17,50218.76,1309.59,213463.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','207277',4025040,'2747','415',67857.22,70206.25,2349.03,382891.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','207277',4025041,'2748','415',62427.27,64120.94,1693.67,276068.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','207277',4025042,'2749','415',40741.38,42546.64,1805.26,294257.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','207277',4025043,'2750','415',53534.59,55692.34,2157.75,351713.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','207277',4025044,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207277',4025045,'2752','415',66187.87,68481.71,2293.84,373895.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','207277',4025046,'2753','415',25008.26,25008.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207277',4025047,'2754','415',59908.79,62060.19,2151.40,350678.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','207277',4025048,'2755','415',18738.03,19060.21,322.18,52515.34,0.00,0.00,0.00,0.00,0.00),('1','185','937','207277',4025049,'2756','416',27347.87,28133.80,785.93,227919.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','207277',4025050,'2757','416',30419.04,31291.52,872.48,253019.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','207277',4025051,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207277',4025052,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207340',4026166,'2744','415',57193.14,58996.82,1803.68,293999.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','207340',4026167,'2745','415',71727.25,73137.17,1409.92,229816.96,0.00,0.00,0.00,0.00,0.00),('1','185','935','207340',4026168,'2746','415',50218.76,51752.76,1534.00,250042.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207340',4026169,'2747','415',70206.25,71603.92,1397.67,227820.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','207340',4026170,'2748','415',64120.94,65836.16,1715.22,279580.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','207340',4026171,'2749','415',42546.64,43183.34,636.70,103782.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','207340',4026172,'2750','415',55692.34,57149.74,1457.40,237556.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','207340',4026173,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207340',4026174,'2752','415',68481.71,70798.57,2316.86,377648.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','207340',4026175,'2753','415',25008.26,25008.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207340',4026176,'2754','415',62060.19,63325.06,1264.87,206173.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','207340',4026177,'2755','415',19060.21,20151.60,1091.39,177896.57,0.00,0.00,0.00,0.00,0.00),('1','185','937','207340',4026178,'2756','416',28133.80,28621.45,487.65,141418.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','207340',4026179,'2757','416',31291.52,31623.60,332.08,96303.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','207340',4026180,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207340',4026181,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207535',4029748,'2744','415',58996.82,60104.70,1107.88,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207535',4029749,'2745','415',73137.17,75677.63,2540.46,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207535',4029750,'2746','415',51752.76,53316.31,1563.55,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207535',4029751,'2747','415',71603.92,73758.00,2154.08,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207535',4029752,'2748','415',65836.16,67616.13,1779.97,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207535',4029753,'2749','415',43183.34,44537.73,1354.39,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207535',4029754,'2750','415',57149.74,58958.75,1809.01,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207535',4029755,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207535',4029756,'2752','415',70798.57,73116.54,2317.97,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207535',4029757,'2753','415',25008.26,25008.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207535',4029758,'2754','415',63325.06,63532.20,207.14,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207535',4029759,'2755','415',20151.60,21996.33,1844.73,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207535',4029760,'2756','416',28621.45,29401.55,780.10,226229.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207535',4029761,'2757','416',31623.60,33715.33,2091.73,606601.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','207535',4029762,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207535',4029763,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207620',4031240,'2744','415',60104.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207620',4031241,'2745','415',75677.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207620',4031242,'2746','415',53316.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207620',4031243,'2747','415',73758.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207620',4031244,'2748','415',67616.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207620',4031245,'2749','415',44537.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207620',4031246,'2750','415',58958.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207620',4031247,'2751','415',25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207620',4031248,'2752','415',73116.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207620',4031249,'2753','415',25008.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207620',4031250,'2754','415',63532.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207620',4031251,'2755','415',21996.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207620',4031252,'2756','416',29401.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207620',4031253,'2757','416',33715.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207620',4031254,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207620',4031255,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207648',4031736,'2744','415',60104.70,61406.89,1302.19,212256.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','207648',4031737,'2745','415',75677.63,77281.82,1604.19,261482.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','207648',4031738,'2746','415',53316.31,54882.70,1566.39,255321.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','207648',4031739,'2747','415',73758.00,75328.10,1570.10,255926.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','207648',4031740,'2748','415',67616.13,69685.17,2069.04,337253.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','207648',4031741,'2749','415',44537.73,44961.37,423.64,69053.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','207648',4031742,'2750','415',58958.75,60461.13,1502.38,244887.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','207648',4031743,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207648',4031744,'2752','415',73116.54,75227.68,2111.14,344115.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','207648',4031745,'2753','415',25008.26,25008.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207648',4031746,'2754','415',63532.20,64997.56,1465.36,238853.68,0.00,0.00,0.00,0.00,0.00),('1','185','936','207648',4031747,'2755','415',21996.33,21996.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207648',4031748,'2756','416',29401.55,29935.99,534.44,154987.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','207648',4031749,'2757','416',33715.33,34670.62,955.29,277034.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','207648',4031750,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207648',4031751,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207651',4031782,'2744','415',61406.89,63218.56,1811.67,295302.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','207651',4031783,'2745','415',77281.82,79730.65,2448.83,399159.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','207651',4031784,'2746','415',54882.70,55651.50,768.80,125314.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','207651',4031785,'2747','415',75328.10,77781.92,2453.82,399972.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','207651',4031786,'2748','415',69685.17,70393.85,708.68,115514.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','207651',4031787,'2749','415',44961.37,46649.70,1688.33,275197.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','207651',4031788,'2750','415',60461.13,63368.45,2907.32,473893.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','207651',4031789,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207651',4031790,'2752','415',75227.68,77635.50,2407.82,392474.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','207651',4031791,'2753','415',25008.26,25683.91,675.65,110130.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','207651',4031792,'2754','415',64997.56,67821.26,2823.70,460263.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','207651',4031793,'2755','415',21996.33,21996.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207651',4031794,'2756','416',29935.99,30698.11,762.12,221014.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','207651',4031795,'2757','416',34670.62,35102.55,431.93,125259.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','207651',4031796,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207651',4031797,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207865',4035391,'2744','415',63218.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207865',4035392,'2745','415',79730.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207865',4035393,'2746','415',55651.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207865',4035394,'2747','415',77781.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207865',4035395,'2748','415',70393.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207865',4035396,'2749','415',46649.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207865',4035397,'2750','415',63368.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207865',4035398,'2751','415',25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207865',4035399,'2752','415',77635.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207865',4035400,'2753','415',25683.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207865',4035401,'2754','415',67821.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207865',4035402,'2755','415',21996.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207865',4035403,'2756','416',30698.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207865',4035404,'2757','416',35102.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207865',4035405,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207865',4035406,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207870',4035478,'2744','415',63218.56,65071.31,1852.75,301998.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','207870',4035479,'2745','415',79730.65,81701.56,1970.91,321258.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','207870',4035480,'2746','415',55651.50,57435.92,1784.42,290860.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','207870',4035481,'2747','415',77781.92,79515.04,1733.12,282498.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','207870',4035482,'2748','415',70393.85,72445.61,2051.76,334436.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','207870',4035483,'2749','415',46649.70,47323.70,674.00,109862.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207870',4035484,'2750','415',63368.45,65491.57,2123.12,346068.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','207870',4035485,'2751','415',25874.35,25874.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207870',4035486,'2752','415',77635.50,79755.91,2120.41,345626.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','207870',4035487,'2753','415',25683.91,25683.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207870',4035488,'2754','415',67821.26,70504.05,2682.79,437294.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','207870',4035489,'2755','415',21996.33,21996.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207870',4035490,'2756','416',30698.11,31637.79,939.68,272507.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','207870',4035491,'2757','416',35102.55,35892.56,790.01,229102.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','207870',4035492,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207870',4035493,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207872',4035510,'2744','415',65071.31,66295.89,1224.58,199606.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','207872',4035511,'2745','415',81701.56,84369.20,2667.64,434825.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','207872',4035512,'2746','415',57435.92,58272.43,836.51,136351.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','207872',4035513,'2747','415',79515.04,82231.20,2716.16,442734.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','207872',4035514,'2748','415',72445.61,73109.75,664.14,108254.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','207872',4035515,'2749','415',47323.70,48529.68,1205.98,196574.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','207872',4035516,'2750','415',65491.57,68530.36,3038.79,495322.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','207872',4035517,'2751','415',25874.35,26526.24,651.89,106258.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','207872',4035518,'2752','415',79755.91,82697.56,2941.65,479488.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','207872',4035519,'2753','415',25683.91,25683.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207872',4035520,'2754','415',70504.05,72931.97,2427.92,395750.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','207872',4035521,'2755','415',21996.33,23140.93,1144.60,186569.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','207872',4035522,'2756','416',31637.79,33123.56,1485.77,430873.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','207872',4035523,'2757','416',35892.56,36209.10,316.54,91796.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','207872',4035524,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207872',4035525,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','207992',4037498,'2744','415',66295.89,67978.29,1682.40,274231.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','207992',4037499,'2745','415',84369.20,86119.62,1750.42,285318.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','207992',4037500,'2746','415',58272.43,60024.19,1751.76,285536.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','207992',4037501,'2747','415',82231.20,84047.06,1815.86,295985.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','207992',4037502,'2748','415',73109.75,74572.13,1462.38,238367.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','207992',4037503,'2749','415',48529.68,49607.76,1078.08,175727.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','207992',4037504,'2750','415',68530.36,70078.82,1548.46,252398.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','207992',4037505,'2751','415',26526.24,26526.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207992',4037506,'2752','415',82697.56,84941.25,2243.69,365721.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','207992',4037507,'2753','415',25683.91,25683.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','207992',4037508,'2754','415',72931.97,74844.70,1912.73,311774.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','207992',4037509,'2755','415',23140.93,23140.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','207992',4037510,'2756','416',33123.56,34247.92,1124.36,326064.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','207992',4037511,'2757','416',36209.10,36429.10,220.00,63800.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207992',4037512,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','207992',4037513,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208146',4040110,'2744','415',67978.29,67978.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208146',4040111,'2745','415',86119.62,88352.57,2232.95,363970.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','208146',4040112,'2746','415',60024.19,62351.92,2327.73,379419.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','208146',4040113,'2747','415',84047.06,86763.54,2716.48,442786.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','208146',4040114,'2748','415',74572.13,77402.35,2830.22,461325.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','208146',4040115,'2749','415',49607.76,49607.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208146',4040116,'2750','415',70078.82,72996.76,2917.94,475624.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','208146',4040117,'2751','415',26526.24,27178.00,651.76,106236.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','208146',4040118,'2752','415',84941.25,87851.79,2910.54,474418.02,0.00,0.00,0.00,0.00,0.00),('1','185','936','208146',4040119,'2753','415',25683.91,25683.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208146',4040120,'2754','415',74844.70,77622.98,2778.28,452859.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','208146',4040121,'2755','415',23140.93,24070.66,929.73,151545.99,0.00,0.00,0.00,0.00,0.00),('1','185','937','208146',4040122,'2756','416',34247.92,36464.36,2216.44,642767.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','208146',4040123,'2757','416',36429.10,37899.44,1470.34,426398.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','208146',4040124,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208146',4040125,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208191',4041029,'2744','415',67978.29,69515.13,1536.84,250504.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','208191',4041030,'2745','415',88352.57,89961.10,1608.53,262190.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','208191',4041031,'2746','415',62351.92,64112.31,1760.39,286943.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','208191',4041032,'2747','415',86763.54,88884.66,2121.12,345742.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','208191',4041033,'2748','415',77402.35,78042.50,640.15,104344.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','208191',4041034,'2749','415',49607.76,51951.31,2343.55,381998.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','208191',4041035,'2750','415',72996.76,74870.92,1874.16,305488.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','208191',4041036,'2751','415',27178.00,27178.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208191',4041037,'2752','415',87851.79,89838.81,1987.02,323884.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','208191',4041038,'2753','415',25683.91,25683.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208191',4041039,'2754','415',77622.98,80216.32,2593.34,422714.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','208191',4041040,'2755','415',24070.66,24070.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208191',4041041,'2756','416',36464.36,37226.00,761.64,220875.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','208191',4041042,'2757','416',37899.44,38130.11,230.67,66894.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','208191',4041043,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208191',4041044,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208399',4044753,'2744','415',69515.13,69870.01,354.88,57845.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','208399',4044754,'2745','415',89961.10,92506.38,2545.28,414880.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','208399',4044755,'2746','415',64112.31,64554.64,442.33,72099.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','208399',4044756,'2747','415',88884.66,91543.97,2659.31,433467.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','208399',4044757,'2748','415',78042.50,80163.55,2121.05,345731.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','208399',4044758,'2749','415',51951.31,53626.72,1675.41,273091.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','208399',4044759,'2750','415',74870.92,77574.61,2703.69,440701.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','208399',4044760,'2751','415',27178.00,27178.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208399',4044761,'2752','415',89838.81,91707.79,1868.98,304643.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','208399',4044762,'2753','415',25683.91,26973.98,1290.07,210281.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','208399',4044763,'2754','415',80216.32,82580.95,2364.63,385434.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','208399',4044764,'2755','415',24070.66,24847.22,776.56,126579.28,0.00,0.00,0.00,0.00,0.00),('1','185','937','208399',4044765,'2756','416',37226.00,38385.34,1159.34,336208.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','208399',4044766,'2757','416',38130.11,38892.44,762.33,221075.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','208399',4044767,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208399',4044768,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208411',4044957,'2744','415',69870.01,69870.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208411',4044958,'2745','415',92506.38,95413.60,2907.22,473876.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','208411',4044959,'2746','415',64554.64,64554.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208411',4044960,'2747','415',91543.97,94002.26,2458.29,400701.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','208411',4044961,'2748','415',80163.55,81975.35,1811.80,295323.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','208411',4044962,'2749','415',53626.72,53626.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208411',4044963,'2750','415',77574.61,80496.73,2922.12,476305.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','208411',4044964,'2751','415',27178.00,27178.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208411',4044965,'2752','415',91707.79,93063.46,1355.67,220974.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','208411',4044966,'2753','415',26973.98,29195.73,2221.75,362145.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','208411',4044967,'2754','415',82580.95,85033.87,2452.92,399825.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','208411',4044968,'2755','415',24847.22,24847.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208411',4044969,'2756','416',38385.34,38863.59,478.25,138692.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','208411',4044970,'2757','416',38892.44,39167.95,275.51,79897.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','208411',4044971,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208411',4044972,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208586',4047905,'2744','415',69870.01,71755.25,1885.24,307294.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','208586',4047906,'2745','415',95413.60,97777.75,2364.15,385356.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','208586',4047907,'2746','415',64554.64,66452.58,1897.94,309364.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','208586',4047908,'2747','415',94002.26,96468.63,2466.37,402018.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','208586',4047909,'2748','415',81975.35,84563.44,2588.09,421858.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','208586',4047910,'2749','415',53626.72,54357.70,730.98,119149.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','208586',4047911,'2750','415',80496.73,82539.44,2042.71,332961.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','208586',4047912,'2751','415',27178.00,27645.35,467.35,76178.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','208586',4047913,'2752','415',93063.46,95179.44,2115.98,344904.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','208586',4047914,'2753','415',29195.73,29354.95,159.22,25952.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','208586',4047915,'2754','415',85033.87,87316.98,2283.11,372146.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','208586',4047916,'2755','415',24847.22,24847.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208586',4047917,'2756','416',38863.59,43899.67,5036.08,1460463.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','208586',4047918,'2757','416',39167.95,39752.97,585.02,169655.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','208586',4047919,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208586',4047920,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208608',4048204,'2744','415',71755.25,73070.12,1314.87,214323.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','208608',4048205,'2745','415',97777.75,99686.18,1908.43,311074.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','208608',4048206,'2746','415',66452.58,66452.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208608',4048207,'2747','415',96468.63,98974.53,2505.90,408461.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','208608',4048208,'2748','415',84563.44,86580.80,2017.36,328829.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','208608',4048209,'2749','415',54357.70,55178.50,820.80,133790.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','208608',4048210,'2750','415',82539.44,84778.77,2239.33,365010.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','208608',4048211,'2751','415',27645.35,27645.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208608',4048212,'2752','415',95179.44,97302.73,2123.29,346096.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','208608',4048213,'2753','415',29354.95,29354.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208608',4048214,'2754','415',87316.98,90285.38,2968.40,483849.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','208608',4048215,'2755','415',24847.22,24847.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208608',4048216,'2756','416',43899.67,44206.49,306.82,88977.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','208608',4048217,'2757','416',39752.97,40229.67,476.70,138243.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208608',4048218,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208608',4048219,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208708',4050245,'2744','415',73070.12,74675.95,1605.83,261750.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','208708',4050246,'2745','415',99686.18,101860.13,2173.95,354353.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','208708',4050247,'2746','415',66452.58,67325.10,872.52,142220.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','208708',4050248,'2747','415',98974.53,101177.46,2202.93,359077.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','208708',4050249,'2748','415',86580.80,87747.05,1166.25,190098.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','208708',4050250,'2749','415',55178.50,56837.07,1658.57,270346.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','208708',4050251,'2750','415',84778.77,86970.11,2191.34,357188.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','208708',4050252,'2751','415',27645.35,28014.29,368.94,60137.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','208708',4050253,'2752','415',97302.73,99528.85,2226.12,362857.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','208708',4050254,'2753','415',29354.95,29697.71,342.76,55869.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','208708',4050255,'2754','415',90285.38,90504.24,218.86,35674.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','208708',4050256,'2755','415',24847.22,26886.68,2039.46,332431.98,0.00,0.00,0.00,0.00,0.00),('1','185','937','208708',4050257,'2756','416',44206.49,45241.92,1035.43,300274.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','208708',4050258,'2757','416',40229.67,40595.95,366.28,106221.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','208708',4050259,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208708',4050260,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208828',4052026,'2744','415',74675.95,76441.93,1765.98,287854.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','208828',4052027,'2745','415',101860.13,102707.28,847.15,138085.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','208828',4052028,'2746','415',67325.10,69103.04,1777.94,289804.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','208828',4052029,'2747','415',101177.46,102785.92,1608.46,262178.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','208828',4052030,'2748','415',87747.05,89992.76,2245.71,366050.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','208828',4052031,'2749','415',56837.07,56837.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208828',4052032,'2750','415',86970.11,89071.52,2101.41,342529.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','208828',4052033,'2751','415',28014.29,28014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208828',4052034,'2752','415',99528.85,102296.70,2767.85,451159.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','208828',4052035,'2753','415',29697.71,29697.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208828',4052036,'2754','415',90504.24,92796.65,2292.41,373662.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','208828',4052037,'2755','415',26886.68,26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208828',4052038,'2756','416',45241.92,46720.18,1478.26,428695.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','208828',4052039,'2757','416',40595.95,41505.76,909.81,263844.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','208828',4052040,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208828',4052041,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','208933',4054048,'2744','415',76441.93,78202.03,1760.10,286896.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','208933',4054049,'2745','415',102707.28,104833.03,2125.75,346497.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','208933',4054050,'2746','415',69103.04,70766.26,1663.22,271104.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','208933',4054051,'2747','415',102785.92,104708.67,1922.75,313408.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','208933',4054052,'2748','415',89992.76,92138.40,2145.64,349739.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','208933',4054053,'2749','415',56837.07,57631.78,794.71,129537.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','208933',4054054,'2750','415',89071.52,90869.00,1797.48,292989.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','208933',4054055,'2751','415',28014.29,28014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','208933',4054056,'2752','415',102296.70,104470.60,2173.90,354345.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','208933',4054057,'2753','415',29697.71,30056.36,358.65,58459.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','208933',4054058,'2754','415',92796.65,95075.70,2279.05,371485.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','208933',4054059,'2755','415',26886.68,26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208933',4054060,'2756','416',46720.18,47648.48,928.30,269207.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','208933',4054061,'2757','416',41505.76,41673.51,167.75,48647.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','208933',4054062,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','208933',4054063,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209064',4056163,'2744','415',78202.03,78202.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209064',4056164,'2745','415',104833.03,106978.75,2145.72,349752.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','209064',4056165,'2746','415',70766.26,72263.40,1497.14,244033.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','209064',4056166,'2747','415',104708.67,106332.35,1623.68,264659.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','209064',4056167,'2748','415',92138.40,93906.21,1767.81,288153.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','209064',4056168,'2749','415',57631.78,58901.58,1269.80,206977.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','209064',4056169,'2750','415',90869.00,92782.11,1913.11,311836.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','209064',4056170,'2751','415',28014.29,28014.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209064',4056171,'2752','415',104470.60,106766.77,2296.17,374275.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','209064',4056172,'2753','415',30056.36,30056.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209064',4056173,'2754','415',95075.70,97341.44,2265.74,369315.62,0.00,0.00,0.00,0.00,0.00),('1','185','936','209064',4056174,'2755','415',26886.68,26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209064',4056175,'2756','416',47648.48,48577.74,929.26,269485.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','209064',4056176,'2757','416',41673.51,42566.45,892.94,258952.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','209064',4056177,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209064',4056178,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209142',4057605,'2744','415',78202.03,79828.83,1626.80,265168.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','209142',4057606,'2745','415',106978.75,108870.98,1892.23,308433.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','209142',4057607,'2746','415',72263.40,74228.31,1964.91,320280.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','209142',4057608,'2747','415',106332.35,107579.25,1246.90,203244.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','209142',4057609,'2748','415',93906.21,95534.84,1628.63,265466.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','209142',4057610,'2749','415',58901.58,59475.37,573.79,93527.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','209142',4057611,'2750','415',92782.11,94687.09,1904.98,310511.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','209142',4057612,'2751','415',28014.29,29005.18,990.89,161515.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','209142',4057613,'2752','415',106766.77,108718.83,1952.06,318185.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','209142',4057614,'2753','415',30056.36,30777.12,720.76,117483.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','209142',4057615,'2754','415',97341.44,100095.57,2754.13,448923.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','209142',4057616,'2755','415',26886.68,26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209142',4057617,'2756','416',48577.74,49427.85,850.11,246531.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','209142',4057618,'2757','416',42566.45,42870.47,304.02,88165.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','209142',4057619,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209142',4057620,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209272',4059905,'2744','415',79828.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209272',4059906,'2745','415',108870.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209272',4059907,'2746','415',74228.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209272',4059908,'2747','415',107579.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209272',4059909,'2748','415',95534.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209272',4059910,'2749','415',59475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209272',4059911,'2750','415',94687.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209272',4059912,'2751','415',29005.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209272',4059913,'2752','415',108718.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209272',4059914,'2753','415',30777.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209272',4059915,'2754','415',100095.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209272',4059916,'2755','415',26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209272',4059917,'2756','416',49427.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209272',4059918,'2757','416',42870.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209272',4059919,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209272',4059920,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209368',4061669,'2744','415',79828.83,81665.14,1836.31,299318.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','209368',4061670,'2745','415',108870.98,109777.97,906.99,147839.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','209368',4061671,'2746','415',74228.31,75359.86,1131.55,184442.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','209368',4061672,'2747','415',107579.25,109264.96,1685.71,274770.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','209368',4061673,'2748','415',95534.84,97378.83,1843.99,300570.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','209368',4061674,'2749','415',59475.37,59475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209368',4061675,'2750','415',94687.09,96095.00,1407.91,229489.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','209368',4061676,'2751','415',29005.18,29979.97,974.79,158890.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','209368',4061677,'2752','415',108718.83,111253.99,2535.16,413231.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','209368',4061678,'2753','415',30777.12,30886.70,109.58,17861.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','209368',4061679,'2754','415',100095.57,101900.54,1804.97,294210.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','209368',4061680,'2755','415',26886.68,26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209368',4061681,'2756','416',49427.85,50300.82,872.97,257526.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','209368',4061682,'2757','416',42870.47,43609.23,738.76,217934.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','209368',4061683,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209368',4061684,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209475',4063425,'2744','415',81665.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209475',4063426,'2745','415',109777.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209475',4063427,'2746','415',75359.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209475',4063428,'2747','415',109264.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209475',4063429,'2748','415',97378.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209475',4063430,'2749','415',59475.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209475',4063431,'2750','415',96095.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209475',4063432,'2751','415',29979.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209475',4063433,'2752','415',111253.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209475',4063434,'2753','415',30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209475',4063435,'2754','415',101900.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209475',4063436,'2755','415',26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209475',4063437,'2756','416',50300.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209475',4063438,'2757','416',43609.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209475',4063439,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209475',4063440,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209480',4063589,'2744','415',81665.14,83510.49,1845.35,300792.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','209480',4063590,'2745','415',109777.97,111874.88,2096.91,341796.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','209480',4063591,'2746','415',75359.86,77213.73,1853.87,302180.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','209480',4063592,'2747','415',109264.96,111700.88,2435.92,397054.96,0.00,0.00,0.00,0.00,0.00),('1','185','935','209480',4063593,'2748','415',97378.83,99404.38,2025.55,330164.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','209480',4063594,'2749','415',59475.37,60530.51,1055.14,171987.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','209480',4063595,'2750','415',96095.00,98001.85,1906.85,310816.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','209480',4063596,'2751','415',29979.97,30952.41,972.44,158507.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','209480',4063597,'2752','415',111253.99,113578.15,2324.16,378838.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','209480',4063598,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209480',4063599,'2754','415',101900.54,104390.37,2489.83,405842.29,0.00,0.00,0.00,0.00,0.00),('1','185','936','209480',4063600,'2755','415',26886.68,26886.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209480',4063601,'2756','416',50300.82,51257.68,956.86,282273.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','209480',4063602,'2757','416',43609.23,43829.57,220.34,65000.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','209480',4063603,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209480',4063604,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209489',4063779,'2744','415',83510.49,83510.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209489',4063780,'2745','415',111874.88,114309.64,2434.76,396865.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','209489',4063781,'2746','415',77213.73,77937.78,724.05,118020.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','209489',4063782,'2747','415',111700.88,114660.11,2959.23,482354.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','209489',4063783,'2748','415',99404.38,101317.42,1913.04,311825.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','209489',4063784,'2749','415',60530.51,60787.02,256.51,41811.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','209489',4063785,'2750','415',98001.85,99000.10,998.25,162714.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','209489',4063786,'2751','415',30952.41,32112.60,1160.19,189110.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','209489',4063787,'2752','415',113578.15,115538.87,1960.72,319597.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','209489',4063788,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209489',4063789,'2754','415',104390.37,106567.58,2177.21,354885.23,0.00,0.00,0.00,0.00,0.00),('1','185','936','209489',4063790,'2755','415',26886.68,27446.42,559.74,91237.62,0.00,0.00,0.00,0.00,0.00),('1','185','937','209489',4063791,'2756','416',51257.68,52330.30,1072.62,316422.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','209489',4063792,'2757','416',43829.57,44881.22,1051.65,310236.75,0.00,0.00,0.00,0.00,0.00),('1','185','938','209489',4063793,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209489',4063794,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209699',4067483,'2744','415',83510.49,85301.24,1790.75,291892.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','209699',4067484,'2745','415',114309.64,116211.19,1901.55,309952.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','209699',4067485,'2746','415',77937.78,80177.04,2239.26,364999.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','209699',4067486,'2747','415',114660.11,116724.27,2064.16,336458.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','209699',4067487,'2748','415',101317.42,103374.73,2057.31,335341.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','209699',4067488,'2749','415',60787.02,61952.47,1165.45,189968.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','209699',4067489,'2750','415',99000.10,100983.79,1983.69,323341.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','209699',4067490,'2751','415',32112.60,32112.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209699',4067491,'2752','415',115538.87,117890.23,2351.36,383271.68,0.00,0.00,0.00,0.00,0.00),('1','185','936','209699',4067492,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209699',4067493,'2754','415',106567.58,108688.11,2120.53,345646.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','209699',4067494,'2755','415',27446.42,27446.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209699',4067495,'2756','416',52330.30,53444.15,1113.85,328585.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','209699',4067496,'2757','416',44881.22,45449.35,568.13,167598.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','209699',4067497,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209699',4067498,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209801',4069491,'2744','415',85301.24,87146.27,1845.03,300739.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','209801',4069492,'2745','415',116211.19,117818.22,1607.03,261945.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','209801',4069493,'2746','415',80177.04,81625.18,1448.14,236046.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','209801',4069494,'2747','415',116724.27,118820.34,2096.07,341659.41,0.00,0.00,0.00,0.00,0.00),('1','185','935','209801',4069495,'2748','415',103374.73,105678.57,2303.84,375525.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','209801',4069496,'2749','415',61952.47,61952.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209801',4069497,'2750','415',100983.79,102573.74,1589.95,259161.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','209801',4069498,'2751','415',32112.60,32112.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209801',4069499,'2752','415',117890.23,120586.82,2696.59,439544.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','209801',4069500,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209801',4069501,'2754','415',108688.11,110922.60,2234.49,364221.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','209801',4069502,'2755','415',27446.42,27446.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209801',4069503,'2756','416',53444.15,53444.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209801',4069504,'2757','416',45449.35,46330.35,881.00,259895.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209801',4069505,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209801',4069506,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209814',4069728,'2744','415',87146.27,87146.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209814',4069729,'2745','415',117818.22,119945.56,2127.34,346756.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','209814',4069730,'2746','415',81625.18,83444.36,1819.18,296526.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','209814',4069731,'2747','415',118820.34,120698.36,1878.02,306117.26,0.00,0.00,0.00,0.00,0.00),('1','185','935','209814',4069732,'2748','415',105678.57,106412.98,734.41,119708.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','209814',4069733,'2749','415',61952.47,63367.07,1414.60,230579.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','209814',4069734,'2750','415',102573.74,104275.35,1701.61,277362.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','209814',4069735,'2751','415',32112.60,32881.25,768.65,125289.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','209814',4069736,'2752','415',120586.82,122699.32,2112.50,344337.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','209814',4069737,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209814',4069738,'2754','415',110922.60,113297.45,2374.85,387100.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','209814',4069739,'2755','415',27446.42,27619.73,173.31,28250.02,0.00,0.00,0.00,0.00,0.00),('1','185','937','209814',4069740,'2756','416',53444.15,54515.15,1071.00,315945.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','209814',4069741,'2757','416',46330.35,46743.93,413.58,122006.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','209814',4069742,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209814',4069743,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','209940',4071879,'2744','415',87146.27,88753.43,1607.16,261967.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','209940',4071880,'2745','415',119945.56,121496.08,1550.52,252734.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','209940',4071881,'2746','415',83444.36,84732.50,1288.14,209966.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','209940',4071882,'2747','415',120698.36,122294.39,1596.03,260152.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','209940',4071883,'2748','415',106412.98,107785.82,1372.84,223772.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','209940',4071884,'2749','415',63367.07,64214.93,847.86,138201.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','209940',4071885,'2750','415',104275.35,105909.12,1633.77,266304.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','209940',4071886,'2751','415',32881.25,32881.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209940',4071887,'2752','415',122699.32,124839.56,2140.24,348859.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','209940',4071888,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','209940',4071889,'2754','415',113297.45,113995.18,697.73,113729.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','209940',4071890,'2755','415',27619.73,29278.03,1658.30,270302.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','209940',4071891,'2756','416',54515.15,54805.98,290.83,85794.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','209940',4071892,'2757','416',46743.93,47308.39,564.46,166515.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','209940',4071893,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','209940',4071894,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210054',4073930,'2744','415',88753.43,90126.99,1373.56,223890.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','210054',4073931,'2745','415',121496.08,123612.70,2116.62,345009.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','210054',4073932,'2746','415',84732.32,86456.72,1724.40,281077.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','210054',4073933,'2747','415',122294.39,124610.52,2316.13,377529.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','210054',4073934,'2748','415',107785.82,107999.54,213.72,34836.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','210054',4073935,'2749','415',64214.93,65983.29,1768.36,288242.68,0.00,0.00,0.00,0.00,0.00),('1','185','936','210054',4073936,'2750','415',105909.12,106475.26,566.14,92280.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','210054',4073937,'2751','415',32881.25,34651.92,1770.67,288619.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','210054',4073938,'2752','415',124839.56,127419.24,2579.68,420487.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','210054',4073939,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210054',4073940,'2754','415',113995.18,116687.47,2692.29,438843.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','210054',4073941,'2755','415',29278.03,29322.21,44.18,7201.34,0.00,0.00,0.00,0.00,0.00),('1','185','937','210054',4073942,'2756','416',54805.98,55192.39,386.41,113990.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','210054',4073943,'2757','416',47308.39,47737.00,428.61,126439.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','210054',4073944,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210054',4073945,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210166',4075718,'2744','415',90126.99,91160.70,1033.71,168494.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','210166',4075719,'2745','415',123612.70,126228.89,2616.19,426438.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','210166',4075720,'2746','415',86456.72,88355.82,1899.10,309553.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','210166',4075721,'2747','415',124610.52,126463.52,1843.00,300409.00,0.00,0.00,10.00,0.00,0.00),('1','185','935','210166',4075722,'2748','415',107999.54,110121.37,2121.83,345858.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','210166',4075723,'2749','415',65983.29,67314.89,1331.60,217050.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','210166',4075724,'2750','415',106475.26,108331.71,1846.45,300971.35,0.00,0.00,10.00,0.00,0.00),('1','185','936','210166',4075725,'2751','415',34651.92,34892.34,240.42,39188.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','210166',4075726,'2752','415',127419.24,128933.15,1513.91,246767.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','210166',4075727,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210166',4075728,'2754','415',116687.47,117065.97,378.50,61695.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','210166',4075729,'2755','415',29322.21,30371.79,1049.58,171081.54,0.00,0.00,0.00,0.00,0.00),('1','185','937','210166',4075730,'2756','416',55192.39,55752.11,559.72,165117.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','210166',4075731,'2757','416',47737.00,47972.60,235.60,69502.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210166',4075732,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210166',4075733,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210351',4078920,'2744','415',91160.70,92395.46,1234.76,201265.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','210351',4078921,'2745','415',126228.89,128347.30,2118.41,345300.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','210351',4078922,'2746','415',88355.82,90687.51,2331.69,380065.47,0.00,0.00,0.00,0.00,0.00),('1','185','935','210351',4078923,'2747','415',126463.52,128459.69,1996.17,325375.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','210351',4078924,'2748','415',110121.37,112338.52,2217.15,361395.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','210351',4078925,'2749','415',67314.89,68336.88,1021.99,166584.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','210351',4078926,'2750','415',108331.71,109762.98,1431.27,233297.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','210351',4078927,'2751','415',34892.34,35576.75,684.41,111558.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','210351',4078928,'2752','415',128933.15,131964.52,3031.37,494113.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','210351',4078929,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210351',4078930,'2754','415',117065.97,119547.29,2481.32,404455.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','210351',4078931,'2755','415',30371.79,30371.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','210351',4078932,'2756','416',55752.11,56264.06,511.95,151025.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','210351',4078933,'2757','416',47972.60,49296.93,1324.33,390677.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','210351',4078934,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210351',4078935,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210390',4079714,'2744','415',92395.46,94328.54,1933.08,315092.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','210390',4079715,'2745','415',128347.30,130339.03,1981.73,323021.99,0.00,0.00,10.00,0.00,0.00),('1','185','935','210390',4079716,'2746','415',90687.51,92758.07,2070.56,337501.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','210390',4079717,'2747','415',128459.69,130075.24,1615.55,263334.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','210390',4079718,'2748','415',112338.52,114139.06,1800.54,293488.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','210390',4079719,'2749','415',68336.88,69346.22,1009.34,164522.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','210390',4079720,'2750','415',109762.98,110889.27,1126.29,183585.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','210390',4079721,'2751','415',35576.75,36369.57,792.82,129229.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','210390',4079722,'2752','415',131964.52,133296.94,1332.42,217184.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','210390',4079723,'2753','415',30886.70,30886.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210390',4079724,'2754','415',119547.29,120727.21,1179.92,192326.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','210390',4079725,'2755','415',30371.79,30371.79,-10.00,-1630.00,0.00,0.00,10.00,0.00,0.00),('1','185','937','210390',4079726,'2756','416',56264.06,57027.10,763.04,225096.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','210390',4079727,'2757','416',49296.93,50653.62,1356.69,400223.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','210390',4079728,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210390',4079729,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210472',4081409,'2744','415',94328.54,95477.24,1138.70,185608.10,0.00,0.00,10.00,0.00,0.00),('1','185','935','210472',4081410,'2745','415',130339.03,133024.98,2675.95,436179.85,0.00,0.00,10.00,0.00,0.00),('1','185','935','210472',4081411,'2746','415',92758.07,95135.64,2357.57,384283.91,0.00,0.00,20.00,0.00,0.00),('1','185','935','210472',4081412,'2747','415',130075.24,132060.93,1965.69,320407.47,0.00,0.00,20.00,0.00,0.00),('1','185','935','210472',4081413,'2748','415',114139.06,114474.68,325.62,53076.06,0.00,0.00,10.00,0.00,0.00),('1','185','935','210472',4081414,'2749','415',69346.22,70085.12,718.90,117180.70,0.00,0.00,20.00,0.00,0.00),('1','185','936','210472',4081415,'2750','415',110889.27,111304.93,405.66,66122.58,0.00,0.00,10.00,0.00,0.00),('1','185','936','210472',4081416,'2751','415',36369.57,38556.15,2166.58,353152.54,0.00,0.00,20.00,0.00,0.00),('1','185','936','210472',4081417,'2752','415',133296.94,136313.79,3006.85,490116.55,0.00,0.00,10.00,0.00,0.00),('1','185','936','210472',4081418,'2753','415',30886.70,30896.83,0.13,21.19,0.00,0.00,10.00,0.00,0.00),('1','185','936','210472',4081419,'2754','415',120727.21,122875.97,2128.76,346987.88,0.00,0.00,20.00,0.00,0.00),('1','185','936','210472',4081420,'2755','415',30371.79,31326.04,944.25,153912.75,0.00,0.00,10.00,0.00,0.00),('1','185','937','210472',4081421,'2756','416',57027.10,58117.20,1090.10,321579.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','210472',4081422,'2757','416',50653.62,51626.98,973.36,287141.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','210472',4081423,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210472',4081424,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210655',4084683,'2744','415',95477.24,96906.41,1429.17,232954.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','210655',4084684,'2745','415',133024.98,134584.89,1559.91,254265.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','210655',4084685,'2746','415',95135.64,96856.70,1721.06,280532.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','210655',4084686,'2747','415',132060.93,133906.93,1846.00,300898.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210655',4084687,'2748','415',114474.68,116146.26,1671.58,272467.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','210655',4084688,'2749','415',70085.12,70600.03,514.91,83930.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','210655',4084689,'2750','415',111304.93,113110.36,1805.43,294285.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','210655',4084690,'2751','415',38556.15,38556.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210655',4084691,'2752','415',136313.79,138258.70,1944.91,317020.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','210655',4084692,'2753','415',30896.83,31066.55,169.72,27664.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','210655',4084693,'2754','415',122875.97,122875.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210655',4084694,'2755','415',31326.04,33458.94,2132.90,347662.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','210655',4084695,'2756','416',58117.20,59375.63,1258.43,371236.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','210655',4084696,'2757','416',51626.98,52420.17,793.19,233991.05,0.00,0.00,0.00,0.00,0.00),('1','185','938','210655',4084697,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210655',4084698,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210786',4086853,'2744','415',96906.41,98278.33,1371.92,223622.96,0.00,0.00,0.00,0.00,0.00),('1','185','935','210786',4086854,'2745','415',134584.89,136600.08,2015.19,328475.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','210786',4086855,'2746','415',96856.70,98617.24,1760.54,286968.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','210786',4086856,'2747','415',133906.93,136063.28,2156.35,351485.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','210786',4086857,'2748','415',116146.26,118059.56,1913.30,311867.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','210786',4086858,'2749','415',70600.03,71450.31,850.28,138595.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','210786',4086859,'2750','415',113110.36,113710.82,600.46,97874.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','210786',4086860,'2751','415',38556.15,39780.63,1224.48,199590.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','210786',4086861,'2752','415',138258.70,140093.27,1834.57,299034.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','210786',4086862,'2753','415',31066.55,32670.14,1603.59,261385.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','210786',4086863,'2754','415',122875.97,125059.74,2183.77,355954.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','210786',4086864,'2755','415',33458.94,33458.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','210786',4086865,'2756','416',59375.63,60484.42,1108.79,327093.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','210786',4086866,'2757','416',52420.17,53021.79,601.62,177477.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','210786',4086867,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210786',4086868,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','210804',4087195,'2744','415',98278.33,99731.24,1452.91,236824.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','210804',4087196,'2745','415',136600.08,138048.83,1448.75,236146.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','210804',4087197,'2746','415',98617.24,100816.23,2198.99,358435.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','210804',4087198,'2747','415',136063.28,137455.77,1392.49,226975.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','210804',4087199,'2748','415',118059.56,120069.85,2010.29,327677.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','210804',4087200,'2749','415',71450.31,72506.00,1055.69,172077.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','210804',4087201,'2750','415',113710.82,115420.50,1709.68,278677.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','210804',4087202,'2751','415',39780.63,39780.68,0.05,8.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','210804',4087203,'2752','415',140093.27,142373.20,2279.93,371628.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','210804',4087204,'2753','415',32670.14,32670.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','210804',4087205,'2754','415',125059.74,127132.23,2072.49,337815.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','210804',4087206,'2755','415',33458.94,33458.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','210804',4087207,'2756','416',60484.42,60778.85,294.43,86856.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','210804',4087208,'2757','416',53021.79,53410.01,388.22,114524.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','210804',4087209,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','210804',4087210,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211015',4090592,'2744','415',99731.24,100766.65,1035.41,168771.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','211015',4090593,'2745','415',138048.83,140229.21,2180.38,355401.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','211015',4090594,'2746','415',100816.23,101280.36,464.13,75653.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','211015',4090595,'2747','415',137455.77,140095.54,2639.77,430282.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','211015',4090596,'2748','415',120069.85,122049.59,1979.74,322697.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','211015',4090597,'2749','415',72506.00,73486.82,980.82,159873.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','211015',4090598,'2750','415',115420.50,117250.25,1829.75,298249.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','211015',4090599,'2751','415',39780.68,40911.80,1131.12,184372.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','211015',4090600,'2752','415',142373.20,145126.47,2753.27,448783.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','211015',4090601,'2753','415',32670.14,33260.13,589.99,96168.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','211015',4090602,'2754','415',127132.23,129997.13,2864.90,466978.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','211015',4090603,'2755','415',33458.94,33980.19,521.25,84963.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','211015',4090604,'2756','416',60778.85,61947.40,1168.55,344722.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','211015',4090605,'2757','416',53410.01,53648.32,238.31,70301.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','211015',4090606,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211015',4090607,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211118',4092690,'2744','415',100766.65,103267.01,2500.36,407558.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','211118',4092691,'2745','415',140229.21,142968.94,2739.73,446575.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','211118',4092692,'2746','415',101280.36,103978.86,2698.50,439855.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','211118',4092693,'2747','415',140095.54,142215.46,2119.92,345546.96,0.00,0.00,0.00,0.00,0.00),('1','185','935','211118',4092694,'2748','415',122049.59,123846.11,1796.52,292832.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','211118',4092695,'2749','415',73486.82,75796.84,2310.02,376533.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','211118',4092696,'2750','415',117250.25,117962.53,712.28,116101.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','211118',4092697,'2751','415',40911.80,40911.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211118',4092698,'2752','415',145126.47,146130.70,1004.23,163689.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','211118',4092699,'2753','415',33260.13,33260.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211118',4092700,'2754','415',129997.13,130384.63,387.50,63162.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','211118',4092701,'2755','415',33980.19,34667.15,686.96,111974.48,0.00,0.00,0.00,0.00,0.00),('1','185','937','211118',4092702,'2756','416',61947.40,62497.11,549.71,162164.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','211118',4092703,'2757','416',53648.32,53903.41,255.09,75251.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','211118',4092704,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211118',4092705,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211207',4094065,'2744','415',103267.01,105942.62,2675.61,436124.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','211207',4094066,'2745','415',142968.94,145809.92,2840.98,463079.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','211207',4094067,'2746','415',103978.86,107329.76,3350.90,546196.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','211207',4094068,'2747','415',142215.46,145076.46,2861.00,466343.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211207',4094069,'2748','415',123846.11,127128.41,3282.30,535014.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','211207',4094070,'2749','415',75796.84,78511.83,2714.99,442543.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','211207',4094071,'2750','415',117962.53,118510.25,547.72,89278.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','211207',4094072,'2751','415',40911.80,42621.11,1709.31,278617.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','211207',4094073,'2752','415',146130.70,146130.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211207',4094074,'2753','415',33260.13,34291.80,1031.67,168162.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','211207',4094075,'2754','415',130384.63,131716.93,1332.30,217164.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','211207',4094076,'2755','415',34667.15,34667.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','211207',4094077,'2756','416',62497.11,64223.94,1726.83,509414.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','211207',4094078,'2757','416',53903.41,54398.34,494.93,146004.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','211207',4094079,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211207',4094080,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211312',4096169,'2744','415',105942.62,108233.06,2290.44,373341.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','211312',4096170,'2745','415',145809.92,147106.24,1296.32,211300.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','211312',4096171,'2746','415',107329.76,108774.20,1444.44,235443.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','211312',4096172,'2747','415',145076.46,147367.34,2290.88,373413.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','211312',4096173,'2748','415',127128.41,129672.75,2544.34,414727.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','211312',4096174,'2749','415',78511.83,78735.07,223.24,36388.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','211312',4096175,'2750','415',118510.25,121092.10,2581.85,420841.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','211312',4096176,'2751','415',42621.11,42621.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211312',4096177,'2752','415',146130.70,148713.06,2582.36,420924.68,0.00,0.00,0.00,0.00,0.00),('1','185','936','211312',4096178,'2753','415',34291.80,34291.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211312',4096179,'2754','415',131716.93,133831.26,2114.33,344635.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','211312',4096180,'2755','415',34667.15,35502.83,835.68,136215.84,0.00,0.00,0.00,0.00,0.00),('1','185','937','211312',4096181,'2756','416',64223.94,64477.15,253.21,74696.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','211312',4096182,'2757','416',54398.34,55284.78,886.44,261499.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','211312',4096183,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211312',4096184,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211435',4098204,'2744','415',108233.06,108243.06,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','935','211435',4098205,'2745','415',147106.24,150291.47,3175.23,517562.49,0.00,0.00,10.00,0.00,0.00),('1','185','935','211435',4098206,'2746','415',108774.20,109612.72,828.52,135048.76,0.00,0.00,10.00,0.00,0.00),('1','185','935','211435',4098207,'2747','415',147367.34,150330.79,2953.45,481412.35,0.00,0.00,10.00,0.00,0.00),('1','185','935','211435',4098208,'2748','415',129672.75,129682.75,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','935','211435',4098209,'2749','415',78735.07,81369.02,2623.95,427703.85,0.00,0.00,10.00,0.00,0.00),('1','185','936','211435',4098210,'2750','415',121092.10,123911.83,2809.73,457985.99,0.00,0.00,10.00,0.00,0.00),('1','185','936','211435',4098211,'2751','415',42621.11,42631.11,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','211435',4098212,'2752','415',148713.06,151702.74,2979.68,485687.84,0.00,0.00,10.00,0.00,0.00),('1','185','936','211435',4098213,'2753','415',34291.80,34301.80,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','211435',4098214,'2754','415',133831.26,136094.90,2253.64,367343.32,0.00,0.00,10.00,0.00,0.00),('1','185','936','211435',4098215,'2755','415',35502.83,37344.06,1821.23,296860.49,0.00,0.00,20.00,0.00,0.00),('1','185','937','211435',4098216,'2756','416',64477.15,65449.06,971.91,286713.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','211435',4098217,'2757','416',55284.78,55865.83,581.05,171409.75,0.00,0.00,0.00,0.00,0.00),('1','185','938','211435',4098218,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211435',4098219,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211585',4101015,'2744','415',108243.06,108243.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211585',4101016,'2745','415',150291.47,152943.63,2652.16,432302.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','211585',4101017,'2746','415',109612.72,111496.58,1883.86,307069.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','211585',4101018,'2747','415',150330.79,152595.82,2265.03,369199.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','211585',4101019,'2748','415',129682.75,131460.08,1777.33,289704.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','211585',4101020,'2749','415',81369.02,82401.55,1032.53,168302.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','211585',4101021,'2750','415',123911.83,126460.78,2548.95,415478.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','211585',4101022,'2751','415',42631.11,42631.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211585',4101023,'2752','415',151702.74,154466.65,2763.91,450517.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','211585',4101024,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211585',4101025,'2754','415',136094.90,138282.86,2187.96,356637.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','211585',4101026,'2755','415',37344.06,38642.63,1298.57,211666.91,0.00,0.00,0.00,0.00,0.00),('1','185','937','211585',4101027,'2756','416',65449.06,66043.47,594.41,175350.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','211585',4101028,'2757','416',55865.83,56239.59,373.76,110259.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','211585',4101029,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211585',4101030,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211625',4101557,'2744','415',108243.06,109799.30,1556.24,253667.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','211625',4101558,'2745','415',152943.63,155775.48,2831.85,461591.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','211625',4101559,'2746','415',111496.58,113342.38,1845.80,300865.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','211625',4101560,'2747','415',152595.82,155465.49,2869.67,467756.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','211625',4101561,'2748','415',131460.08,134080.66,2620.58,427154.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','211625',4101562,'2749','415',82401.55,83333.48,931.93,151904.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','211625',4101563,'2750','415',126460.78,129705.63,3244.85,528910.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','211625',4101564,'2751','415',42631.11,43256.07,624.96,101868.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','211625',4101565,'2752','415',154466.65,157656.02,3189.37,519867.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','211625',4101566,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211625',4101567,'2754','415',138282.86,141301.27,3018.41,492000.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','211625',4101568,'2755','415',38642.63,38752.11,109.48,17845.24,0.00,0.00,0.00,0.00,0.00),('1','185','937','211625',4101569,'2756','416',66043.47,67506.39,1462.92,431561.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','211625',4101570,'2757','416',56239.59,57563.82,1324.23,390647.85,0.00,0.00,0.00,0.00,0.00),('1','185','938','211625',4101571,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211625',4101572,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211723',4103256,'2744','415',109799.30,111761.44,1962.14,319828.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','211723',4103257,'2745','415',155775.48,157926.09,2150.61,350549.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','211723',4103258,'2746','415',113342.38,114269.81,927.43,151171.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','211723',4103259,'2747','415',155465.49,157799.04,2333.55,380368.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','211723',4103260,'2748','415',134080.66,135587.93,1507.27,245685.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','211723',4103261,'2749','415',83333.48,84997.50,1664.02,271235.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','211723',4103262,'2750','415',129705.63,130504.54,798.91,130222.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','211723',4103263,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211723',4103264,'2752','415',157656.02,158597.18,941.16,153409.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','211723',4103265,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211723',4103266,'2754','415',141301.27,142458.49,1157.22,188626.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','211723',4103267,'2755','415',38752.11,38752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','211723',4103268,'2756','416',67506.39,67651.54,145.15,42819.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','211723',4103269,'2757','416',57563.82,57637.55,73.73,21750.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','211723',4103270,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211723',4103271,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211839',4105043,'2744','415',111761.44,113302.16,1540.72,251137.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','211839',4105044,'2745','415',157926.09,159814.21,1888.12,307763.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','211839',4105045,'2746','415',114269.81,116128.46,1858.65,302959.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','211839',4105046,'2747','415',157799.04,160107.79,2308.75,376326.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','211839',4105047,'2748','415',135587.93,136156.11,568.18,92613.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','211839',4105048,'2749','415',84997.50,87047.03,2049.53,334073.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','211839',4105049,'2750','415',130504.54,132492.51,1987.97,324039.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','211839',4105050,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211839',4105051,'2752','415',158597.18,160644.65,2047.47,333737.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','211839',4105052,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211839',4105053,'2754','415',142458.49,144518.67,2060.18,335809.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','211839',4105054,'2755','415',38752.11,38752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','211839',4105055,'2756','416',67651.54,68044.94,393.40,116053.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','211839',4105056,'2757','416',57637.55,58574.23,936.68,276320.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','211839',4105057,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211839',4105058,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211921',4106709,'2744','415',113302.16,115026.69,1724.53,281098.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','211921',4106710,'2745','415',159814.21,161321.02,1506.81,245610.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','211921',4106711,'2746','415',116128.46,117891.89,1763.43,287439.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','211921',4106712,'2747','415',160107.79,161561.76,1453.97,236997.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','211921',4106713,'2748','415',136156.11,137628.67,1472.56,240027.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','211921',4106714,'2749','415',87047.03,88156.82,1109.79,180895.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','211921',4106715,'2750','415',132492.51,134928.77,2436.26,397110.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','211921',4106716,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211921',4106717,'2752','415',160644.65,162561.88,1917.23,312508.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','211921',4106718,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211921',4106719,'2754','415',144518.67,146259.00,1740.33,283673.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','211921',4106720,'2755','415',38752.11,38752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','211921',4106721,'2756','416',68044.94,68458.23,413.29,121920.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','211921',4106722,'2757','416',58574.23,58713.38,139.15,41049.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','211921',4106723,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211921',4106724,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','211991',4107868,'2744','415',115026.69,116687.20,1660.51,270663.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','211991',4107869,'2745','415',161321.02,163736.96,2415.94,393798.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','211991',4107870,'2746','415',117891.89,119700.40,1808.51,294787.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','211991',4107871,'2747','415',161561.76,163698.42,2136.66,348275.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','211991',4107872,'2748','415',137628.67,139327.19,1698.52,276858.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','211991',4107873,'2749','415',88156.82,89527.09,1370.27,223354.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','211991',4107874,'2750','415',134928.77,136863.15,1934.38,315303.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','211991',4107875,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211991',4107876,'2752','415',162561.88,165281.80,2719.92,443346.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','211991',4107877,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','211991',4107878,'2754','415',146259.00,149018.62,2759.62,449818.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','211991',4107879,'2755','415',38752.11,38752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','211991',4107880,'2756','416',68458.23,68947.86,489.63,144440.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','211991',4107881,'2757','416',58713.38,59232.79,519.41,153225.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','211991',4107882,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','211991',4107883,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212170',4111068,'2744','415',116687.20,118278.80,1591.60,259430.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','212170',4111069,'2745','415',163736.96,165672.62,1935.66,315512.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','212170',4111070,'2746','415',119700.40,121603.28,1902.88,310169.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','212170',4111071,'2747','415',163698.42,165104.63,1406.21,229212.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','212170',4111072,'2748','415',139327.19,140499.21,1172.02,191039.26,0.00,0.00,0.00,0.00,0.00),('1','185','935','212170',4111073,'2749','415',89527.09,90988.08,1460.99,238141.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','212170',4111074,'2750','415',136863.15,138931.03,2067.88,337064.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','212170',4111075,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212170',4111076,'2752','415',165281.80,167048.03,1766.23,287895.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','212170',4111077,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212170',4111078,'2754','415',149018.62,151239.01,2220.39,361923.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','212170',4111079,'2755','415',38752.11,38752.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','212170',4111080,'2756','416',68947.86,69373.43,425.57,125543.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','212170',4111081,'2757','416',59232.79,61697.10,2464.31,726971.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','212170',4111082,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212170',4111083,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212299',4113343,'2744','415',118278.80,119789.77,1510.97,246288.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','212299',4113344,'2745','415',165672.62,167676.60,2003.98,326648.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','212299',4113345,'2746','415',121603.28,123274.32,1671.04,272379.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','212299',4113346,'2747','415',165104.63,167288.23,2183.60,355926.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','212299',4113347,'2748','415',140499.21,141898.16,1398.95,228028.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','212299',4113348,'2749','415',90988.08,92474.33,1486.25,242258.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','212299',4113349,'2750','415',138931.03,141629.08,2698.05,439782.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','212299',4113350,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212299',4113351,'2752','415',167048.03,169237.21,2189.18,356836.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','212299',4113352,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212299',4113353,'2754','415',151239.01,152909.66,1670.65,272315.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','212299',4113354,'2755','415',38752.11,39403.67,651.56,106204.28,0.00,0.00,0.00,0.00,0.00),('1','185','937','212299',4113355,'2756','416',69373.43,70052.83,679.40,200423.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','212299',4113356,'2757','416',61697.10,61847.75,150.65,44441.75,0.00,0.00,0.00,0.00,0.00),('1','185','938','212299',4113357,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212299',4113358,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212404',4115376,'2744','415',119789.77,121131.48,1341.71,218698.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','212404',4115377,'2745','415',167676.60,169875.50,2198.90,358420.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','212404',4115378,'2746','415',123274.32,123274.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212404',4115379,'2747','415',167288.23,169305.51,2017.28,328816.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','212404',4115380,'2748','415',141898.16,143395.06,1496.90,243994.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','212404',4115381,'2749','415',92474.33,93720.93,1246.60,203195.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','212404',4115382,'2750','415',141629.08,143526.03,1896.95,309202.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','212404',4115383,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212404',4115384,'2752','415',169237.21,171490.06,2252.85,367214.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','212404',4115385,'2753','415',34301.80,34301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212404',4115386,'2754','415',152909.66,155164.16,2254.50,367483.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','212404',4115387,'2755','415',39403.67,39403.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','212404',4115388,'2756','416',70052.83,70590.45,537.62,158597.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','212404',4115389,'2757','416',61847.75,62011.31,163.56,48250.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','212404',4115390,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212404',4115391,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212428',4115877,'2744','415',121131.48,123136.66,2005.18,326844.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','212428',4115878,'2745','415',169875.50,171608.97,1733.47,282555.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','212428',4115879,'2746','415',123274.32,125416.57,2142.25,349186.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','212428',4115880,'2747','415',169305.51,171442.61,2137.10,348347.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','212428',4115881,'2748','415',143395.06,145173.12,1778.06,289823.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','212428',4115882,'2749','415',93720.93,94622.39,901.46,146937.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','212428',4115883,'2750','415',143526.03,145735.98,2209.95,360221.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','212428',4115884,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212428',4115885,'2752','415',171490.06,173787.34,2297.28,374456.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','212428',4115886,'2753','415',34301.80,34700.60,398.80,65004.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','212428',4115887,'2754','415',155164.16,157578.16,2414.00,393482.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212428',4115888,'2755','415',39403.67,39741.48,337.81,55063.03,0.00,0.00,0.00,0.00,0.00),('1','185','937','212428',4115889,'2756','416',70590.45,71590.97,1000.52,295153.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','212428',4115890,'2757','416',62011.31,62282.77,271.46,80080.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','212428',4115891,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212428',4115892,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212639',4119687,'2744','415',123136.66,125043.70,1907.04,310847.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','212639',4119688,'2745','415',171608.97,173252.27,1643.30,267857.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','212639',4119689,'2746','415',125416.57,125416.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212639',4119690,'2747','415',171442.61,173653.76,2211.15,360417.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','212639',4119691,'2748','415',145173.12,147258.95,2085.83,339990.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','212639',4119692,'2749','415',94622.39,95000.61,378.22,61649.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','212639',4119693,'2750','415',145735.98,148219.79,2483.81,404861.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','212639',4119694,'2751','415',43256.07,43256.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212639',4119695,'2752','415',173787.34,175985.19,2197.85,358249.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','212639',4119696,'2753','415',34700.60,34700.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212639',4119697,'2754','415',157578.16,159947.01,2368.85,386122.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','212639',4119698,'2755','415',39741.48,39741.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','212639',4119699,'2756','416',71590.97,72280.53,689.56,203420.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','212639',4119700,'2757','416',62282.77,63484.53,1201.76,354519.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','212639',4119701,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212639',4119702,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212726',4121013,'2744','415',125043.70,127400.11,2356.41,384094.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','212726',4121014,'2745','415',173252.27,175446.71,2194.44,357693.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','212726',4121015,'2746','415',125416.57,127657.68,2241.11,365300.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','212726',4121016,'2747','415',173653.76,176508.25,2854.49,465281.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','212726',4121017,'2748','415',147258.95,148181.32,922.37,150346.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','212726',4121018,'2749','415',95000.61,96435.60,1434.99,233903.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','212726',4121019,'2750','415',148219.79,150074.25,1854.46,302276.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','212726',4121020,'2751','415',43256.07,43835.80,579.73,94495.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','212726',4121021,'2752','415',175985.19,178041.26,2056.07,335139.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','212726',4121022,'2753','415',34700.60,35074.99,374.39,61025.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','212726',4121023,'2754','415',159947.01,161790.27,1843.26,300451.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','212726',4121024,'2755','415',39741.48,41106.66,1365.18,222524.34,0.00,0.00,0.00,0.00,0.00),('1','185','937','212726',4121025,'2756','416',72280.53,72836.78,556.25,164093.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','212726',4121026,'2757','416',63484.53,63743.87,259.34,76505.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','212726',4121027,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212726',4121028,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212733',4121109,'2744','415',127400.11,127400.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212733',4121110,'2745','415',175446.71,177823.83,2377.12,387470.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','212733',4121111,'2746','415',127657.68,127657.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','212733',4121112,'2747','415',176508.25,179233.20,2724.95,444166.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','212733',4121113,'2748','415',148181.32,150459.38,2278.06,371323.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','212733',4121114,'2749','415',96435.60,96449.71,14.11,2299.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','212733',4121115,'2750','415',150074.25,152656.50,2582.25,420906.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','212733',4121116,'2751','415',43835.80,43835.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212733',4121117,'2752','415',178041.26,181116.92,3075.66,501332.58,0.00,0.00,0.00,0.00,0.00),('1','185','936','212733',4121118,'2753','415',35074.99,35074.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','212733',4121119,'2754','415',161790.27,164502.87,2712.60,442153.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','212733',4121120,'2755','415',41106.66,41106.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','212733',4121121,'2756','416',72836.78,73258.11,421.33,124292.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','212733',4121122,'2757','416',63743.87,63976.27,232.40,68558.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212733',4121123,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','212733',4121124,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213094',4127602,'2744','415',127400.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213094',4127603,'2745','415',177823.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213094',4127604,'2746','415',127657.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213094',4127605,'2747','415',179233.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213094',4127606,'2748','415',150459.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213094',4127607,'2749','415',96449.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213094',4127608,'2750','415',152656.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213094',4127609,'2751','415',43835.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213094',4127610,'2752','415',181116.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213094',4127611,'2753','415',35074.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213094',4127612,'2754','415',164502.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213094',4127613,'2755','415',41106.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213094',4127614,'2756','416',73258.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213094',4127615,'2757','416',63976.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213094',4127616,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213094',4127617,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213098',4127694,'2744','415',127400.11,128420.08,1019.97,166255.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','213098',4127695,'2745','415',177823.83,180471.12,2647.29,431508.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','213098',4127696,'2746','415',127657.68,128701.01,1043.33,170062.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','213098',4127697,'2747','415',179233.20,181837.33,2604.13,424473.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','213098',4127698,'2748','415',150459.38,152925.28,2465.90,401941.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','213098',4127699,'2749','415',96449.71,97996.27,1546.56,252089.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','213098',4127700,'2750','415',152656.50,154309.05,1652.55,269365.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','213098',4127701,'2751','415',43835.80,44306.34,470.54,76698.02,0.00,0.00,0.00,0.00,0.00),('1','185','936','213098',4127702,'2752','415',181116.92,183283.88,2166.96,353214.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','213098',4127703,'2753','415',35074.99,35074.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213098',4127704,'2754','415',164502.87,166469.26,1966.39,320521.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','213098',4127705,'2755','415',41106.66,41898.26,791.60,129030.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','213098',4127706,'2756','416',73258.11,73818.08,559.97,165191.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','213098',4127707,'2757','416',63976.27,64404.42,428.15,126304.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','213098',4127708,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213098',4127709,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213100',4127717,'2744','415',128420.08,128870.94,450.86,73490.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','213100',4127718,'2745','415',180471.12,182177.96,1706.84,278214.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','213100',4127719,'2746','415',128701.01,128701.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213100',4127720,'2747','415',181837.33,183814.68,1977.35,322308.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','213100',4127721,'2748','415',152925.28,154532.89,1607.61,262040.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','213100',4127722,'2749','415',97996.27,99245.31,1249.04,203593.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','213100',4127723,'2750','415',154309.05,156749.56,2440.51,397803.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','213100',4127724,'2751','415',44306.34,44306.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213100',4127725,'2752','415',183283.88,185906.21,2622.33,427439.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','213100',4127726,'2753','415',35074.99,35074.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213100',4127727,'2754','415',166469.26,168700.08,2230.82,363623.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','213100',4127728,'2755','415',41898.26,41898.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213100',4127729,'2756','416',73818.08,75054.14,1236.06,364637.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','213100',4127730,'2757','416',64404.42,64756.06,351.64,103733.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','213100',4127731,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213100',4127732,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213169',4128719,'2744','415',128870.94,129112.90,241.96,39439.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','213169',4128720,'2745','415',182177.96,184885.27,2707.31,441291.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','213169',4128721,'2746','415',128701.01,128766.64,65.63,10697.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','213169',4128722,'2747','415',183814.68,186323.38,2508.70,408918.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','213169',4128723,'2748','415',154532.89,156372.60,1839.71,299872.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','213169',4128724,'2749','415',99245.31,100052.14,806.83,131513.29,0.00,0.00,0.00,0.00,0.00),('1','185','936','213169',4128725,'2750','415',156749.56,159021.58,2272.02,370339.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','213169',4128726,'2751','415',44306.34,44306.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213169',4128727,'2752','415',185906.21,188146.36,2240.15,365144.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','213169',4128728,'2753','415',35074.99,35074.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213169',4128729,'2754','415',168700.08,171413.32,2713.24,442258.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','213169',4128730,'2755','415',41898.26,41898.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213169',4128731,'2756','416',75054.14,75387.70,333.56,98400.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','213169',4128732,'2757','416',64756.06,65287.93,531.87,156901.65,0.00,0.00,0.00,0.00,0.00),('1','185','938','213169',4128733,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213169',4128734,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213267',4130315,'2744','415',129112.90,129112.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213267',4130316,'2745','415',184885.27,187095.52,2210.25,360270.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','213267',4130317,'2746','415',128766.64,128928.28,161.64,26347.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','213267',4130318,'2747','415',186323.38,188260.80,1937.42,315799.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','213267',4130319,'2748','415',156372.60,158208.98,1836.38,299329.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','213267',4130320,'2749','415',100052.14,101801.42,1749.28,285132.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','213267',4130321,'2750','415',159021.58,161334.98,2313.40,377084.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','213267',4130322,'2751','415',44306.34,44306.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213267',4130323,'2752','415',188146.36,189828.68,1682.32,274218.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','213267',4130324,'2753','415',35074.99,35156.15,81.16,13229.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','213267',4130325,'2754','415',171413.32,173342.32,1929.00,314427.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213267',4130326,'2755','415',41898.26,42282.96,384.70,62706.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','213267',4130327,'2756','416',75387.70,76277.56,889.86,262508.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','213267',4130328,'2757','416',65287.93,65423.53,135.60,40002.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213267',4130329,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213267',4130330,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213438',4133119,'2744','415',129112.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213438',4133120,'2745','415',187095.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213438',4133121,'2746','415',128928.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213438',4133122,'2747','415',188260.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213438',4133123,'2748','415',158208.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213438',4133124,'2749','415',101801.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213438',4133125,'2750','415',161334.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213438',4133126,'2751','415',44306.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213438',4133127,'2752','415',189828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213438',4133128,'2753','415',35156.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213438',4133129,'2754','415',173342.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213438',4133130,'2755','415',42282.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213438',4133131,'2756','416',76277.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213438',4133132,'2757','416',65423.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213438',4133133,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213438',4133134,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213440',4133146,'2744','415',129112.90,130790.23,1667.33,271774.79,0.00,0.00,10.00,0.00,0.00),('1','185','935','213440',4133147,'2745','415',187095.52,189065.99,1960.47,319556.61,0.00,0.00,10.00,0.00,0.00),('1','185','935','213440',4133148,'2746','415',128928.28,129812.14,873.86,142439.18,0.00,0.00,10.00,0.00,0.00),('1','185','935','213440',4133149,'2747','415',188260.80,190361.19,2090.39,340733.57,0.00,0.00,10.00,0.00,0.00),('1','185','935','213440',4133150,'2748','415',158208.98,159422.74,1203.76,196212.88,0.00,0.00,10.00,0.00,0.00),('1','185','935','213440',4133151,'2749','415',101801.42,103166.70,1355.28,220910.64,0.00,0.00,10.00,0.00,0.00),('1','185','936','213440',4133152,'2750','415',161334.98,163520.82,2175.84,354661.92,0.00,0.00,10.00,0.00,0.00),('1','185','936','213440',4133153,'2751','415',44306.34,44316.34,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','213440',4133154,'2752','415',189828.68,191882.87,2044.19,333202.97,0.00,0.00,10.00,0.00,0.00),('1','185','936','213440',4133155,'2753','415',35156.15,35465.60,299.45,48810.35,0.00,0.00,10.00,0.00,0.00),('1','185','936','213440',4133156,'2754','415',173342.32,175745.25,2392.93,390047.59,0.00,0.00,10.00,0.00,0.00),('1','185','936','213440',4133157,'2755','415',42282.96,42292.96,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','937','213440',4133158,'2756','416',76277.56,76895.87,618.31,182401.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','213440',4133159,'2757','416',65423.53,65615.06,191.53,56501.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','213440',4133160,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213440',4133161,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213605',4136006,'2744','415',130790.23,130790.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213605',4136007,'2745','415',189065.99,191008.25,1942.26,316588.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','213605',4136008,'2746','415',129812.14,129812.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213605',4136009,'2747','415',190361.19,192640.77,2279.58,371571.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','213605',4136010,'2748','415',159422.74,160666.17,1243.43,202679.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','213605',4136011,'2749','415',103166.70,103558.75,392.05,63904.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','213605',4136012,'2750','415',163520.82,165179.92,1659.10,270433.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','213605',4136013,'2751','415',44316.34,44701.09,384.75,62714.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','213605',4136014,'2752','415',191882.87,194153.65,2270.78,370137.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','213605',4136015,'2753','415',35465.60,35465.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213605',4136016,'2754','415',175745.25,177599.10,1853.85,302177.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','213605',4136017,'2755','415',42292.96,42292.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213605',4136018,'2756','416',76895.87,77374.07,478.20,141069.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213605',4136019,'2757','416',65615.06,66141.34,526.28,155252.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','213605',4136020,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213605',4136021,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213707',4137694,'2744','415',130790.23,133587.33,2797.10,455927.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','213707',4137695,'2745','415',191008.25,192929.00,1920.75,313082.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','213707',4137696,'2746','415',129812.14,131995.99,2183.85,355967.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','213707',4137697,'2747','415',192640.77,195101.83,2461.06,401152.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','213707',4137698,'2748','415',160666.17,163215.07,2548.90,415470.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','213707',4137699,'2749','415',103558.75,104486.67,927.92,151250.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','213707',4137700,'2750','415',165179.92,166506.83,1326.91,216286.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','213707',4137701,'2751','415',44701.09,44969.13,268.04,43690.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','213707',4137702,'2752','415',194153.65,195732.03,1578.38,257275.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','213707',4137703,'2753','415',35465.60,35465.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213707',4137704,'2754','415',177599.10,178987.48,1388.38,226305.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','213707',4137705,'2755','415',42292.96,42292.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','213707',4137706,'2756','416',77374.07,78034.59,660.52,194853.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','213707',4137707,'2757','416',66141.34,67468.09,1326.75,391391.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','213707',4137708,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213707',4137709,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213740',4138241,'2744','415',133587.33,134863.70,1276.37,208048.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','213740',4138242,'2745','415',192929.00,194680.96,1751.96,285569.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','213740',4138243,'2746','415',131995.99,133243.13,1247.14,203283.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','213740',4138244,'2747','415',195101.83,196631.21,1529.38,249288.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','213740',4138245,'2748','415',163215.07,164914.07,1699.00,276937.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213740',4138246,'2749','415',104486.67,105669.63,1182.96,192822.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','213740',4138247,'2750','415',166506.83,168020.99,1514.16,246808.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','213740',4138248,'2751','415',44969.13,44969.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213740',4138249,'2752','415',195732.03,198035.67,2303.64,375493.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','213740',4138250,'2753','415',35465.60,35465.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213740',4138251,'2754','415',178987.48,180776.54,1789.06,291616.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','213740',4138252,'2755','415',42292.96,42575.82,282.86,46106.18,0.00,0.00,0.00,0.00,0.00),('1','185','937','213740',4138253,'2756','416',78034.59,78918.02,883.43,260611.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','213740',4138254,'2757','416',67468.09,67793.52,325.43,96001.85,0.00,0.00,0.00,0.00,0.00),('1','185','938','213740',4138255,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213740',4138256,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213873',4140460,'2744','415',134863.70,134863.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','213873',4140461,'2745','415',194680.96,197683.76,3002.80,489456.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','213873',4140462,'2746','415',133243.13,133389.75,146.62,23899.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','213873',4140463,'2747','415',196631.21,198997.98,2366.77,385783.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','213873',4140464,'2748','415',164914.07,167521.95,2607.88,425084.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','213873',4140465,'2749','415',105669.63,107052.52,1382.89,225411.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','213873',4140466,'2750','415',168020.99,170831.57,2810.58,458124.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','213873',4140467,'2751','415',44969.13,44969.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213873',4140468,'2752','415',198035.67,200699.58,2663.91,434217.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','213873',4140469,'2753','415',35465.60,35465.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','213873',4140470,'2754','415',180776.54,182717.49,1940.95,316374.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','213873',4140471,'2755','415',42575.82,43928.15,1352.33,220429.79,0.00,0.00,0.00,0.00,0.00),('1','185','937','213873',4140472,'2756','416',78918.02,80148.47,1230.45,362982.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','213873',4140473,'2757','416',67793.52,68273.08,479.56,141470.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','213873',4140474,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','213873',4140475,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214034',4143063,'2744','415',134863.70,135564.29,700.59,114196.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','214034',4143064,'2745','415',197683.76,198369.08,685.32,111707.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','214034',4143065,'2746','415',133389.75,133389.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214034',4143066,'2747','415',198997.98,200376.67,1378.69,224726.47,0.00,0.00,0.00,0.00,0.00),('1','185','935','214034',4143067,'2748','415',167521.95,169075.65,1553.70,253253.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','214034',4143068,'2749','415',107052.52,107207.39,154.87,25243.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','214034',4143069,'2750','415',170831.57,173011.43,2179.86,355317.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','214034',4143070,'2751','415',44969.13,44969.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214034',4143071,'2752','415',200699.58,202264.13,1564.55,255021.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','214034',4143072,'2753','415',35465.60,35465.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214034',4143073,'2754','415',182717.49,184188.91,1471.42,239841.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','214034',4143074,'2755','415',43928.15,43928.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','214034',4143075,'2756','416',80148.47,80608.77,460.30,135788.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','214034',4143076,'2757','416',68273.08,68306.29,33.21,9796.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','214034',4143077,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214034',4143078,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214074',4143820,'2744','415',135564.29,137837.28,2272.99,370497.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','214074',4143821,'2745','415',198369.08,200635.93,2266.85,369496.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','214074',4143822,'2746','415',133389.75,135611.73,2221.98,362182.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','214074',4143823,'2747','415',200376.67,202700.74,2324.07,378823.41,0.00,0.00,0.00,0.00,0.00),('1','185','935','214074',4143824,'2748','415',169075.65,171704.81,2629.16,428553.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','214074',4143825,'2749','415',107207.39,107579.18,371.79,60601.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','214074',4143826,'2750','415',173011.43,175662.58,2651.15,432137.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','214074',4143827,'2751','415',44969.13,46323.43,1354.30,220750.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','214074',4143828,'2752','415',202264.13,204670.31,2406.18,392207.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','214074',4143829,'2753','415',35465.60,36393.28,927.68,151211.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','214074',4143830,'2754','415',184188.91,187474.05,3285.14,535477.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','214074',4143831,'2755','415',43928.15,43928.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','214074',4143832,'2756','416',80608.77,83237.42,2628.65,775451.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','214074',4143833,'2757','416',68306.29,68446.97,140.68,41500.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','214074',4143834,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214074',4143835,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214252',4146990,'2744','415',137837.28,137837.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214252',4146991,'2745','415',200635.93,201944.86,1308.93,213355.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','214252',4146992,'2746','415',135611.73,135611.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214252',4146993,'2747','415',202700.74,204247.57,1546.83,252133.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','214252',4146994,'2748','415',171704.81,171945.36,240.55,39209.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','214252',4146995,'2749','415',107579.18,108103.60,524.42,85480.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','214252',4146996,'2750','415',175662.58,178596.69,2934.11,478259.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','214252',4146997,'2751','415',46323.43,48280.07,1956.64,318932.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','214252',4146998,'2752','415',204670.31,207505.40,2835.09,462119.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','214252',4146999,'2753','415',36393.28,38064.82,1671.54,272461.02,0.00,0.00,0.00,0.00,0.00),('1','185','936','214252',4147000,'2754','415',187474.05,190229.33,2755.28,449110.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','214252',4147001,'2755','415',43928.15,44896.64,968.49,157863.87,0.00,0.00,0.00,0.00,0.00),('1','185','937','214252',4147002,'2756','416',83237.42,84919.22,1681.80,496131.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','214252',4147003,'2757','416',68446.97,69131.87,684.90,202045.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','214252',4147004,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214252',4147005,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214308',4147989,'2744','415',137837.28,140164.34,2327.06,379310.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','214308',4147990,'2745','415',201944.86,204222.34,2277.48,371229.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','214308',4147991,'2746','415',135611.73,138204.66,2592.93,422647.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','214308',4147992,'2747','415',204247.57,206314.08,2066.51,336841.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','214308',4147993,'2748','415',171945.36,174600.54,2655.18,432794.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','214308',4147994,'2749','415',108103.60,108931.06,827.46,134875.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','214308',4147995,'2750','415',178596.69,180187.77,1591.08,259346.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','214308',4147996,'2751','415',48280.07,48594.44,314.37,51242.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','214308',4147997,'2752','415',207505.40,209308.22,1802.82,293859.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','214308',4147998,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214308',4147999,'2754','415',190229.33,192187.73,1958.40,319219.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','214308',4148000,'2755','415',44896.64,45695.54,798.90,130220.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','214308',4148001,'2756','416',84919.22,86095.88,1176.66,347114.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','214308',4148002,'2757','416',69131.87,70684.06,1552.19,457896.05,0.00,0.00,0.00,0.00,0.00),('1','185','938','214308',4148003,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214308',4148004,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214670',4153881,'2744','415',140164.34,140164.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214670',4153882,'2745','415',204222.34,206749.10,2526.76,411861.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','214670',4153883,'2746','415',138204.66,138204.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214670',4153884,'2747','415',206314.08,209213.62,2899.54,472625.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','214670',4153885,'2748','415',174600.54,176888.38,2287.84,372917.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','214670',4153886,'2749','415',108931.06,108931.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214670',4153887,'2750','415',180187.77,182894.59,2706.82,441211.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','214670',4153888,'2751','415',48594.44,48594.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214670',4153889,'2752','415',209308.22,211923.73,2615.51,426328.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','214670',4153890,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214670',4153891,'2754','415',192187.73,193419.96,1232.23,200853.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','214670',4153892,'2755','415',45695.54,46239.78,544.24,88711.12,0.00,0.00,0.00,0.00,0.00),('1','185','937','214670',4153893,'2756','416',86095.88,86567.33,471.45,139077.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','214670',4153894,'2757','416',70684.06,70821.18,137.12,40450.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','214670',4153895,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214670',4153896,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214684',4154150,'2744','415',140164.34,141908.64,1744.30,284320.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','214684',4154151,'2745','415',206749.10,209274.41,2525.31,411625.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','214684',4154152,'2746','415',138204.66,140244.98,2040.32,332572.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','214684',4154153,'2747','415',209213.62,211674.99,2461.37,401203.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','214684',4154154,'2748','415',176888.38,179310.11,2421.73,394741.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','214684',4154155,'2749','415',108931.06,108931.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214684',4154156,'2750','415',182894.59,185514.40,2619.81,427029.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','214684',4154157,'2751','415',48594.44,48594.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214684',4154158,'2752','415',211923.73,214486.80,2563.07,417780.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','214684',4154159,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214684',4154160,'2754','415',193419.96,196596.49,3176.53,517774.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','214684',4154161,'2755','415',46239.78,46239.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','214684',4154162,'2756','416',86567.33,86567.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','214684',4154163,'2757','416',70821.18,70821.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214684',4154164,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214684',4154165,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214698',4154435,'2744','415',141908.64,143583.53,1674.89,273007.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','214698',4154436,'2745','415',209274.41,211119.00,1844.59,300668.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','214698',4154437,'2746','415',140244.98,141362.58,1117.60,182168.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','214698',4154438,'2747','415',211674.99,213509.71,1834.72,299059.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','214698',4154439,'2748','415',179310.11,181131.34,1821.23,296860.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','214698',4154440,'2749','415',108931.06,108931.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214698',4154441,'2750','415',185514.40,187549.62,2035.22,331740.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','214698',4154442,'2751','415',48594.44,48594.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214698',4154443,'2752','415',214486.80,216680.23,2193.43,357529.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','214698',4154444,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214698',4154445,'2754','415',196596.49,199029.62,2433.13,396600.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','214698',4154446,'2755','415',46239.78,46384.13,144.35,23529.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','214698',4154447,'2756','416',86567.33,87954.96,1387.63,409350.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','214698',4154448,'2757','416',70821.18,71526.95,705.77,208202.15,0.00,0.00,0.00,0.00,0.00),('1','185','938','214698',4154449,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214698',4154450,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214904',4157956,'2744','415',143583.53,145889.87,2306.34,375933.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','214904',4157957,'2745','415',211119.00,213820.93,2701.93,440414.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','214904',4157958,'2746','415',141362.58,141649.44,286.86,46758.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','214904',4157959,'2747','415',213509.71,216489.96,2980.25,485780.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','214904',4157960,'2748','415',181131.34,182464.04,1332.70,217230.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','214904',4157961,'2749','415',108931.06,110785.15,1854.09,302216.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','214904',4157962,'2750','415',187549.62,189271.92,1722.30,280734.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','214904',4157963,'2751','415',48594.44,48990.49,396.05,64556.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','214904',4157964,'2752','415',216680.23,219347.77,2667.54,434809.02,0.00,0.00,0.00,0.00,0.00),('1','185','936','214904',4157965,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214904',4157966,'2754','415',199029.62,201599.54,2569.92,418896.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','214904',4157967,'2755','415',46384.13,46384.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','214904',4157968,'2756','416',87954.96,89655.23,1700.27,501579.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','214904',4157969,'2757','416',71526.95,72033.34,506.39,149385.05,0.00,0.00,0.00,0.00,0.00),('1','185','938','214904',4157970,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214904',4157971,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','214937',4158606,'2744','415',145889.87,147384.52,1494.65,243627.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','214937',4158607,'2745','415',213820.93,215889.18,2068.25,337124.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','214937',4158608,'2746','415',141649.44,141842.62,193.18,31488.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','214937',4158609,'2747','415',216489.96,218293.92,1803.96,294045.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','214937',4158610,'2748','415',182464.04,184119.65,1655.61,269864.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','214937',4158611,'2749','415',110785.15,111478.68,693.53,113045.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','214937',4158612,'2750','415',189271.92,191610.42,2338.50,381175.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','214937',4158613,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214937',4158614,'2752','415',219347.77,221701.67,2353.90,383685.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','214937',4158615,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','214937',4158616,'2754','415',201599.54,203695.81,2096.27,341692.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','214937',4158617,'2755','415',46384.13,46793.49,409.36,66725.68,0.00,0.00,0.00,0.00,0.00),('1','185','937','214937',4158618,'2756','416',89655.23,90901.90,1246.67,367767.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','214937',4158619,'2757','416',72033.34,72539.05,505.71,149184.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','214937',4158620,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','214937',4158621,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215062',4160539,'2744','415',147384.52,148577.08,1192.56,194387.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','215062',4160540,'2745','415',215889.18,218323.04,2433.86,396719.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','215062',4160541,'2746','415',141842.62,142409.44,566.82,92391.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','215062',4160542,'2747','415',218293.92,221341.24,3047.32,496713.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','215062',4160543,'2748','415',184119.65,185715.19,1595.54,260073.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','215062',4160544,'2749','415',111478.68,113177.93,1699.25,276977.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','215062',4160545,'2750','415',191610.42,193456.29,1845.87,300876.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','215062',4160546,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215062',4160547,'2752','415',221701.67,223605.50,1903.83,310324.29,0.00,0.00,0.00,0.00,0.00),('1','185','936','215062',4160548,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215062',4160549,'2754','415',203695.81,205901.77,2205.96,359571.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','215062',4160550,'2755','415',46793.49,46793.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215062',4160551,'2756','416',90901.90,91627.28,725.38,213987.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','215062',4160552,'2757','416',72539.05,72882.27,343.22,101249.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','215062',4160553,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215062',4160554,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215142',4162038,'2744','415',148577.08,150263.06,1685.98,274814.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','215142',4162039,'2745','415',218323.04,219931.28,1608.24,262143.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','215142',4162040,'2746','415',142409.44,142409.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215142',4162041,'2747','415',221341.24,223488.08,2146.84,349934.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','215142',4162042,'2748','415',185715.19,187423.50,1708.31,278454.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','215142',4162043,'2749','415',113177.93,113857.20,679.27,110721.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','215142',4162044,'2750','415',193456.29,195715.84,2259.55,368306.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','215142',4162045,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215142',4162046,'2752','415',223605.50,225771.70,2166.20,353090.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','215142',4162047,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215142',4162048,'2754','415',205901.77,207162.15,1260.38,205441.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','215142',4162049,'2755','415',46793.49,48425.12,1631.63,265955.69,0.00,0.00,0.00,0.00,0.00),('1','185','937','215142',4162050,'2756','416',91627.28,92286.62,659.34,194505.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','215142',4162051,'2757','416',72882.27,73826.20,943.93,278459.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','215142',4162052,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215142',4162053,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215263',4163991,'2744','415',150263.06,151564.52,1301.46,212137.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','215263',4163992,'2745','415',219931.28,221802.68,1871.40,305038.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','215263',4163993,'2746','415',142409.44,142409.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215263',4163994,'2747','415',223488.08,226256.40,2768.32,451236.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','215263',4163995,'2748','415',187423.50,189206.65,1783.15,290653.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','215263',4163996,'2749','415',113857.20,114103.42,246.22,40133.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','215263',4163997,'2750','415',195715.84,198380.66,2664.82,434365.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','215263',4163998,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215263',4163999,'2752','415',225771.70,228590.65,2818.95,459488.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','215263',4164000,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215263',4164001,'2754','415',207162.15,210044.62,2882.47,469842.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','215263',4164002,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215263',4164003,'2756','416',92286.62,93096.45,809.83,238899.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','215263',4164004,'2757','416',73826.20,74151.92,325.72,96087.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','215263',4164005,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215263',4164006,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215283',4164302,'2744','415',151564.52,152177.81,613.29,99966.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','215283',4164303,'2745','415',221802.68,224044.05,2241.37,365343.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','215283',4164304,'2746','415',142409.44,142409.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215283',4164305,'2747','415',226256.40,228453.75,2197.35,358168.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','215283',4164306,'2748','415',189206.65,189206.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215283',4164307,'2749','415',114103.42,116025.89,1922.47,313362.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','215283',4164308,'2750','415',198380.66,200375.44,1994.78,325149.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','215283',4164309,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215283',4164310,'2752','415',228590.65,230870.18,2279.53,371563.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','215283',4164311,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215283',4164312,'2754','415',210044.62,212511.34,2466.72,402075.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','215283',4164313,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215283',4164314,'2756','416',93096.45,93463.57,367.12,108300.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','215283',4164315,'2757','416',74151.92,74790.24,638.32,188304.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','215283',4164316,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215283',4164317,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215555',4168891,'2744','415',152177.81,153734.79,1556.98,253787.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','215555',4168892,'2745','415',224044.05,226671.84,2627.79,428329.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','215555',4168893,'2746','415',142409.44,142576.12,166.68,27168.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','215555',4168894,'2747','415',228453.75,230964.21,2510.46,409204.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','215555',4168895,'2748','415',189206.65,190692.31,1485.66,242162.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','215555',4168896,'2749','415',116025.89,116363.67,337.78,55058.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','215555',4168897,'2750','415',200375.44,202770.68,2395.24,390424.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','215555',4168898,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215555',4168899,'2752','415',230870.18,233329.92,2459.74,400937.62,0.00,0.00,0.00,0.00,0.00),('1','185','936','215555',4168900,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215555',4168901,'2754','415',212511.34,215451.91,2940.57,479312.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','215555',4168902,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215555',4168903,'2756','416',93463.57,94361.15,897.58,264786.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','215555',4168904,'2757','416',74790.24,75098.52,308.28,90942.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','215555',4168905,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215555',4168906,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215816',4173604,'2744','415',153734.79,154782.23,1047.44,170732.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','215816',4173605,'2745','415',226671.84,228400.84,1729.00,281827.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215816',4173606,'2746','415',142576.12,143436.33,860.21,140214.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','215816',4173607,'2747','415',230964.21,233673.51,2709.30,441615.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','215816',4173608,'2748','415',190692.31,192808.08,2115.77,344870.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','215816',4173609,'2749','415',116363.67,116965.54,601.87,98104.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','215816',4173610,'2750','415',202770.68,203882.56,1111.88,181236.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','215816',4173611,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215816',4173612,'2752','415',233329.92,234879.50,1549.58,252581.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','215816',4173613,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215816',4173614,'2754','415',215451.91,216171.07,719.16,117223.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','215816',4173615,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215816',4173616,'2756','416',94361.15,95611.04,1249.89,368717.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','215816',4173617,'2757','416',75098.52,75715.86,617.34,182115.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','215816',4173618,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215816',4173619,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215835',4173931,'2744','415',154782.23,154782.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215835',4173932,'2745','415',228400.84,231360.22,2959.38,482378.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','215835',4173933,'2746','415',143436.33,143862.63,426.30,69486.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','215835',4173934,'2747','415',233673.51,236883.78,3210.27,523274.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','215835',4173935,'2748','415',192808.08,192953.63,145.55,23724.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','215835',4173936,'2749','415',116965.54,118771.54,1806.00,294378.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215835',4173937,'2750','415',203882.56,206376.12,2493.56,406450.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','215835',4173938,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215835',4173939,'2752','415',234879.50,237456.01,2576.51,419971.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','215835',4173940,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215835',4173941,'2754','415',216171.07,218590.03,2418.96,394290.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','215835',4173942,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215835',4173943,'2756','416',95611.04,96401.83,790.79,233283.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','215835',4173944,'2757','416',75715.86,76015.21,299.35,88308.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','215835',4173945,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215835',4173946,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215847',4174152,'2744','415',154782.23,156506.69,1724.46,281086.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','215847',4174153,'2745','415',231360.22,233464.52,2104.30,343000.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','215847',4174154,'2746','415',143862.63,143862.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215847',4174155,'2747','415',236883.78,238839.17,1955.39,318728.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','215847',4174156,'2748','415',192953.63,194668.82,1715.19,279575.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','215847',4174157,'2749','415',118771.54,119793.56,1022.02,166589.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','215847',4174158,'2750','415',206376.12,208025.29,1649.17,268814.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','215847',4174159,'2751','415',48990.49,48990.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215847',4174160,'2752','415',237456.01,239666.34,2210.33,360283.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','215847',4174161,'2753','415',38064.82,38064.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','215847',4174162,'2754','415',218590.03,221360.82,2770.79,451638.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','215847',4174163,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215847',4174164,'2756','416',96401.83,97375.42,973.59,287209.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','215847',4174165,'2757','416',76015.21,77119.45,1104.24,325750.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','215847',4174166,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215847',4174167,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','215870',4174520,'2744','415',156506.69,158215.58,1708.89,278549.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','215870',4174521,'2745','415',233464.52,234786.75,1322.23,215523.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','215870',4174522,'2746','415',143862.63,145095.53,1232.90,200962.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','215870',4174523,'2747','415',238839.17,240884.43,2045.26,333377.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','215870',4174524,'2748','415',194668.82,196753.60,2084.78,339819.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','215870',4174525,'2749','415',119793.56,121123.12,1329.56,216718.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','215870',4174526,'2750','415',208025.29,209654.32,1629.03,265531.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','215870',4174527,'2751','415',48990.49,49640.94,650.45,106023.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','215870',4174528,'2752','415',239666.34,241944.12,2277.78,371278.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','215870',4174529,'2753','415',38064.82,38344.07,279.25,45517.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','215870',4174530,'2754','415',221360.82,223358.00,1997.18,325540.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','215870',4174531,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','215870',4174532,'2756','416',97375.42,97756.47,381.05,112409.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','215870',4174533,'2757','416',77119.45,77403.90,284.45,83912.75,0.00,0.00,0.00,0.00,0.00),('1','185','938','215870',4174534,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','215870',4174535,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216027',4177091,'2744','415',158215.58,158215.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216027',4177092,'2745','415',234786.75,236982.78,2196.03,357952.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','216027',4177093,'2746','415',145095.53,145994.69,899.16,146563.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','216027',4177094,'2747','415',240884.43,243114.76,2230.33,363543.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','216027',4177095,'2748','415',196753.60,198558.00,1804.40,294117.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','216027',4177096,'2749','415',121123.12,121904.46,781.34,127358.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','216027',4177097,'2750','415',209654.32,211380.25,1725.93,281326.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','216027',4177098,'2751','415',49640.94,49640.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216027',4177099,'2752','415',241944.12,243290.58,1346.46,219472.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','216027',4177100,'2753','415',38344.07,38344.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216027',4177101,'2754','415',223358.00,225190.46,1832.46,298690.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','216027',4177102,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216027',4177103,'2756','416',97756.47,98426.29,669.82,197596.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','216027',4177104,'2757','416',77403.90,77608.99,205.09,60501.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','216027',4177105,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216027',4177106,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216148',4179142,'2744','415',158215.58,158882.48,666.90,108704.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','216148',4179143,'2745','415',236982.78,239376.17,2393.39,390122.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','216148',4179144,'2746','415',145994.69,147057.79,1063.10,173285.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','216148',4179145,'2747','415',243114.76,245383.13,2268.37,369744.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','216148',4179146,'2748','415',198558.00,200360.09,1802.09,293740.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','216148',4179147,'2749','415',121904.46,123458.61,1554.15,253326.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','216148',4179148,'2750','415',211380.25,213254.05,1873.80,305429.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','216148',4179149,'2751','415',49640.94,49640.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216148',4179150,'2752','415',243290.58,245394.90,2104.32,343004.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','216148',4179151,'2753','415',38344.07,38344.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216148',4179152,'2754','415',225190.46,227581.45,2390.99,389731.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','216148',4179153,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216148',4179154,'2756','416',98426.29,99169.93,743.64,219373.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','216148',4179155,'2757','416',77608.99,78615.14,1006.15,296814.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','216148',4179156,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216148',4179157,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216171',4179489,'2744','415',158882.48,158882.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216171',4179490,'2745','415',239376.17,241057.01,1680.84,273976.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','216171',4179491,'2746','415',147057.79,148696.34,1638.55,267083.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','216171',4179492,'2747','415',245383.13,246691.45,1308.32,213256.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','216171',4179493,'2748','415',200360.09,202579.25,2219.16,361723.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','216171',4179494,'2749','415',123458.61,124268.83,810.22,132065.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','216171',4179495,'2750','415',213254.05,215103.72,1849.67,301496.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','216171',4179496,'2751','415',49640.94,49640.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216171',4179497,'2752','415',245394.90,247504.70,2109.80,343897.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','216171',4179498,'2753','415',38344.07,38344.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216171',4179499,'2754','415',227581.45,229596.79,2015.34,328500.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','216171',4179500,'2755','415',48425.12,48425.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216171',4179501,'2756','416',99169.93,100926.92,1756.99,518312.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','216171',4179502,'2757','416',78615.14,80308.68,1693.54,499594.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','216171',4179503,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216171',4179504,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216263',4181209,'2744','415',158882.48,160517.06,1634.58,266436.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','216263',4181210,'2745','415',241057.01,242967.04,1910.03,311334.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','216263',4181211,'2746','415',148696.34,149053.75,357.41,58257.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','216263',4181212,'2747','415',246691.45,248956.88,2265.43,369265.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','216263',4181213,'2748','415',202579.25,204064.44,1485.19,242085.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','216263',4181214,'2749','415',124268.83,125234.50,965.67,157404.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','216263',4181215,'2750','415',215103.72,216594.77,1491.05,243041.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','216263',4181216,'2751','415',49640.94,50365.66,724.72,118129.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','216263',4181217,'2752','415',247504.70,249794.56,2289.86,373247.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','216263',4181218,'2753','415',38344.07,38344.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216263',4181219,'2754','415',229596.79,231376.76,1779.97,290135.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','216263',4181220,'2755','415',48425.12,49590.70,1165.58,189989.54,0.00,0.00,0.00,0.00,0.00),('1','185','937','216263',4181221,'2756','416',100926.92,101450.61,523.69,154488.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','216263',4181222,'2757','416',80308.68,80870.73,562.05,165804.75,0.00,0.00,0.00,0.00,0.00),('1','185','938','216263',4181223,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216263',4181224,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216471',4184792,'2744','415',160517.06,161712.10,1195.04,194791.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','216471',4184793,'2745','415',242967.04,244727.67,1760.63,286982.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','216471',4184794,'2746','415',149053.75,149434.97,381.22,62138.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','216471',4184795,'2747','415',248956.88,250649.59,1692.71,275911.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','216471',4184796,'2748','415',204064.44,205718.23,1653.79,269567.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','216471',4184797,'2749','415',125234.50,125903.21,668.71,108999.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','216471',4184798,'2750','415',216594.77,218285.96,1691.19,275663.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','216471',4184799,'2751','415',50365.66,50377.93,12.27,2000.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','216471',4184800,'2752','415',249794.56,251981.15,2186.59,356414.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','216471',4184801,'2753','415',38344.07,38491.73,147.66,24068.58,0.00,0.00,0.00,0.00,0.00),('1','185','936','216471',4184802,'2754','415',231376.76,233473.47,2096.71,341763.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','216471',4184803,'2755','415',49590.70,49590.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216471',4184804,'2756','416',101450.61,102558.58,1107.97,326851.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','216471',4184805,'2757','416',80870.73,81590.75,720.02,212405.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','216471',4184806,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216471',4184807,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216633',4187492,'2744','415',161712.10,163255.56,1543.46,251583.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','216633',4187493,'2745','415',244727.67,246626.88,1899.21,309571.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','216633',4187494,'2746','415',149434.97,150220.17,785.20,127987.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','216633',4187495,'2747','415',250649.59,252669.53,2019.94,329250.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','216633',4187496,'2748','415',205718.23,207767.69,2049.46,334061.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','216633',4187497,'2749','415',125903.21,126684.62,781.41,127369.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','216633',4187498,'2750','415',218285.96,219796.94,1510.98,246289.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','216633',4187499,'2751','415',50377.93,50887.56,509.63,83069.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','216633',4187500,'2752','415',251981.15,254224.79,2243.64,365713.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','216633',4187501,'2753','415',38491.73,38491.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216633',4187502,'2754','415',233473.47,235410.26,1936.79,315696.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','216633',4187503,'2755','415',49590.70,50232.24,641.54,104571.02,0.00,0.00,0.00,0.00,0.00),('1','185','937','216633',4187504,'2756','416',102558.58,103296.02,737.44,217544.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','216633',4187505,'2757','416',81590.75,81860.58,269.83,79599.85,0.00,0.00,0.00,0.00,0.00),('1','185','938','216633',4187506,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216633',4187507,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216691',4188573,'2744','415',163255.56,165189.55,1923.99,313610.37,0.00,0.00,10.00,0.00,0.00),('1','185','935','216691',4188574,'2745','415',246626.88,248563.04,1926.16,313964.08,0.00,0.00,10.00,0.00,0.00),('1','185','935','216691',4188575,'2746','415',150220.17,151186.79,946.62,154299.06,0.00,0.00,20.00,0.00,0.00),('1','185','935','216691',4188576,'2747','415',252669.53,255284.22,2604.69,424564.47,0.00,0.00,10.00,0.00,0.00),('1','185','935','216691',4188577,'2748','415',207767.69,209637.87,1860.18,303209.34,0.00,0.00,10.00,0.00,0.00),('1','185','935','216691',4188578,'2749','415',126684.62,127309.15,614.53,100168.39,0.00,0.00,10.00,0.00,0.00),('1','185','936','216691',4188579,'2750','415',219796.94,220763.98,957.04,155997.52,0.00,0.00,10.00,0.00,0.00),('1','185','936','216691',4188580,'2751','415',50887.56,50897.56,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','216691',4188581,'2752','415',254224.79,255398.16,1163.37,189629.31,0.00,0.00,10.00,0.00,0.00),('1','185','936','216691',4188582,'2753','415',38491.73,38491.73,-10.00,-1630.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','216691',4188583,'2754','415',235410.26,236882.70,1472.44,240007.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','216691',4188584,'2755','415',50232.24,50232.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216691',4188585,'2756','416',103296.02,104200.19,904.17,266730.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','216691',4188586,'2757','416',81860.58,83065.98,1205.40,355593.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216691',4188587,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216691',4188588,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216861',4191634,'2744','415',165189.55,166521.85,1332.30,217164.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','216861',4191635,'2745','415',248563.04,250510.66,1947.62,317462.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','216861',4191636,'2746','415',151186.79,152393.45,1206.66,196685.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','216861',4191637,'2747','415',255284.22,256763.12,1478.90,241060.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','216861',4191638,'2748','415',209637.87,211332.09,1694.22,276157.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','216861',4191639,'2749','415',127309.15,128250.91,941.76,153506.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','216861',4191640,'2750','415',220763.98,222784.45,2020.47,329336.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','216861',4191641,'2751','415',50897.56,50897.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216861',4191642,'2752','415',255398.16,258017.48,2619.32,426949.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','216861',4191643,'2753','415',38491.73,38491.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216861',4191644,'2754','415',236882.70,239084.50,2201.80,358893.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','216861',4191645,'2755','415',50232.24,50232.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216861',4191646,'2756','416',104200.19,104454.69,254.50,75077.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','216861',4191647,'2757','416',83065.98,83082.93,16.95,5000.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','216861',4191648,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216861',4191649,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216881',4191930,'2744','415',166521.85,166521.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216881',4191931,'2745','415',250510.66,253081.69,2571.03,419077.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','216881',4191932,'2746','415',152393.45,152393.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','216881',4191933,'2747','415',256763.12,259039.64,2276.52,371072.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','216881',4191934,'2748','415',211332.09,212935.87,1603.78,261416.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','216881',4191935,'2749','415',128250.91,128756.66,505.75,82437.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','216881',4191936,'2750','415',222784.45,224602.17,1817.72,296288.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','216881',4191937,'2751','415',50897.56,50897.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216881',4191938,'2752','415',258017.48,260530.38,2512.90,409602.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','216881',4191939,'2753','415',38491.73,38491.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','216881',4191940,'2754','415',239084.50,240976.95,1892.45,308469.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','216881',4191941,'2755','415',50232.24,50232.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','216881',4191942,'2756','416',104454.69,105657.59,1202.90,354855.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','216881',4191943,'2757','416',83082.93,83359.87,276.94,81697.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','216881',4191944,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','216881',4191945,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217144',4196606,'2744','415',166521.85,168242.70,1720.85,280498.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','217144',4196607,'2745','415',253081.69,255280.77,2199.08,358450.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','217144',4196608,'2746','415',152393.45,153820.87,1427.42,232669.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','217144',4196609,'2747','415',259039.64,260854.36,1814.72,295799.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','217144',4196610,'2748','415',212935.87,214445.13,1509.26,246009.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','217144',4196611,'2749','415',128756.66,129558.00,801.34,130618.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','217144',4196612,'2750','415',224602.17,225999.36,1397.19,227741.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','217144',4196613,'2751','415',50897.56,52202.54,1304.98,212711.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','217144',4196614,'2752','415',260530.38,262718.15,2187.77,356606.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','217144',4196615,'2753','415',38491.73,39610.17,1118.44,182305.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','217144',4196616,'2754','415',240976.95,242761.35,1784.40,290857.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','217144',4196617,'2755','415',50232.24,50232.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217144',4196618,'2756','416',105657.59,106965.28,1307.69,385768.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','217144',4196619,'2757','416',83359.87,83359.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217144',4196620,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217144',4196621,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217186',4197568,'2744','415',168242.70,168470.90,228.20,37196.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','217186',4197569,'2745','415',255280.77,257442.13,2161.36,352301.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','217186',4197570,'2746','415',153820.87,153820.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217186',4197571,'2747','415',260854.36,262695.36,1841.00,300083.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217186',4197572,'2748','415',214445.13,216144.76,1699.63,277039.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','217186',4197573,'2749','415',129558.00,130611.42,1053.42,171707.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','217186',4197574,'2750','415',225999.36,227711.06,1711.70,279007.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','217186',4197575,'2751','415',52202.54,52202.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217186',4197576,'2752','415',262718.15,264593.57,1875.42,305693.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','217186',4197577,'2753','415',39610.17,39610.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217186',4197578,'2754','415',242761.35,244382.40,1621.05,264231.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','217186',4197579,'2755','415',50232.24,50232.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217186',4197580,'2756','416',106965.28,107416.92,451.64,133233.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','217186',4197581,'2757','416',83359.87,83359.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217186',4197582,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217186',4197583,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217331',4200088,'2744','415',168470.90,170547.07,2076.17,338415.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','217331',4200089,'2745','415',257442.13,259624.44,2182.31,355716.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','217331',4200090,'2746','415',153820.87,154679.54,858.67,139963.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','217331',4200091,'2747','415',262695.36,265683.23,2987.87,487022.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','217331',4200092,'2748','415',216144.76,217877.77,1733.01,282480.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','217331',4200093,'2749','415',130611.42,131382.92,771.50,125754.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','217331',4200094,'2750','415',227711.06,229207.00,1495.94,243838.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','217331',4200095,'2751','415',52202.54,52202.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217331',4200096,'2752','415',264593.57,266341.20,1747.63,284863.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','217331',4200097,'2753','415',39610.17,40029.16,418.99,68295.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','217331',4200098,'2754','415',244382.40,246334.39,1951.99,318174.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','217331',4200099,'2755','415',50232.24,50242.07,9.83,1602.29,0.00,0.00,0.00,0.00,0.00),('1','185','937','217331',4200100,'2756','416',107416.92,108950.84,1533.92,452506.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','217331',4200101,'2757','416',83359.87,83785.63,425.76,125599.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','217331',4200102,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217331',4200103,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217551',4203899,'2744','415',170547.07,170547.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217551',4203900,'2745','415',259624.44,261777.05,2152.61,350875.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','217551',4203901,'2746','415',154679.54,155665.69,986.15,160742.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','217551',4203902,'2747','415',265683.23,267932.54,2249.31,366637.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','217551',4203903,'2748','415',217877.77,218360.77,483.00,78729.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217551',4203904,'2749','415',131382.92,132810.07,1427.15,232625.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','217551',4203905,'2750','415',229207.00,231139.41,1932.41,314982.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','217551',4203906,'2751','415',52202.54,52961.86,759.32,123769.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','217551',4203907,'2752','415',266341.20,268534.28,2193.08,357472.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','217551',4203908,'2753','415',40029.16,40029.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217551',4203909,'2754','415',246334.39,248349.54,2015.15,328469.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','217551',4203910,'2755','415',50242.07,50242.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217551',4203911,'2756','416',108950.84,108950.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217551',4203912,'2757','416',83785.63,83785.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217551',4203913,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217551',4203914,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217554',4203955,'2744','415',170547.07,172099.96,1542.89,251491.07,0.00,0.00,10.00,0.00,0.00),('1','185','935','217554',4203956,'2745','415',261777.05,264092.91,2305.86,375855.18,0.00,0.00,10.00,0.00,0.00),('1','185','935','217554',4203957,'2746','415',155665.69,156999.53,1323.84,215785.92,0.00,0.00,10.00,0.00,0.00),('1','185','935','217554',4203958,'2747','415',267932.54,269985.92,2043.38,333070.94,0.00,0.00,10.00,0.00,0.00),('1','185','935','217554',4203959,'2748','415',218360.77,219993.42,1622.65,264491.95,0.00,0.00,10.00,0.00,0.00),('1','185','935','217554',4203960,'2749','415',132810.07,134505.29,1685.22,274690.86,0.00,0.00,10.00,0.00,0.00),('1','185','936','217554',4203961,'2750','415',231139.41,232537.39,1387.98,226240.74,0.00,0.00,10.00,0.00,0.00),('1','185','936','217554',4203962,'2751','415',52961.86,52981.86,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','185','936','217554',4203963,'2752','415',268534.28,270417.58,1873.30,305347.90,0.00,0.00,10.00,0.00,0.00),('1','185','936','217554',4203964,'2753','415',40029.16,40039.16,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','217554',4203965,'2754','415',248349.54,249929.71,1570.17,255937.71,0.00,0.00,10.00,0.00,0.00),('1','185','936','217554',4203966,'2755','415',50242.07,50262.07,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','185','937','217554',4203967,'2756','416',108950.84,108950.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217554',4203968,'2757','416',83785.63,83785.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217554',4203969,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217554',4203970,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217557',4204005,'2744','415',172099.96,172146.51,46.55,7587.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','217557',4204006,'2745','415',264092.91,265946.27,1853.36,302097.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','217557',4204007,'2746','415',156999.53,156999.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217557',4204008,'2747','415',269985.92,271866.18,1880.26,306482.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','217557',4204009,'2748','415',219993.42,221063.85,1070.43,174480.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','217557',4204010,'2749','415',134505.29,135244.11,738.82,120427.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','217557',4204011,'2750','415',232537.39,233502.42,965.03,157299.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','217557',4204012,'2751','415',52981.86,54008.05,1026.19,167268.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','217557',4204013,'2752','415',270417.58,272532.64,2115.06,344754.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','217557',4204014,'2753','415',40039.16,40287.03,247.87,40402.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','217557',4204015,'2754','415',249929.71,251868.32,1938.61,315993.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','217557',4204016,'2755','415',50262.07,50262.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217557',4204017,'2756','416',108950.84,109245.50,294.66,86924.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','217557',4204018,'2757','416',83785.63,83914.45,128.82,38001.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','217557',4204019,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217557',4204020,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217747',4207229,'2744','415',172146.51,172307.86,161.35,26300.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','217747',4207230,'2745','415',265946.27,268520.89,2574.62,419663.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','217747',4207231,'2746','415',156999.53,157912.90,913.37,148879.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','217747',4207232,'2747','415',271866.18,274178.91,2312.73,376974.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','217747',4207233,'2748','415',221063.85,222479.41,1415.56,230736.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','217747',4207234,'2749','415',135244.11,135244.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217747',4207235,'2750','415',233502.42,235820.07,2317.65,377776.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','217747',4207236,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217747',4207237,'2752','415',272532.64,274930.35,2397.71,390826.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','217747',4207238,'2753','415',40287.03,40287.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217747',4207239,'2754','415',251868.32,254187.90,2319.58,378091.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','217747',4207240,'2755','415',50262.07,50982.36,720.29,117407.27,0.00,0.00,0.00,0.00,0.00),('1','185','937','217747',4207241,'2756','416',109245.50,109542.77,297.27,87694.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','217747',4207242,'2757','416',83914.45,84196.40,281.95,83175.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','217747',4207243,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217747',4207244,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','217797',4208270,'2744','415',172307.86,173454.03,1146.17,186825.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','217797',4208271,'2745','415',268520.89,270195.01,1674.12,272881.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','217797',4208272,'2746','415',157912.90,158816.29,903.39,147252.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','217797',4208273,'2747','415',274178.91,276010.89,1831.98,298612.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','217797',4208274,'2748','415',222479.41,224265.90,1786.49,291197.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','217797',4208275,'2749','415',135244.11,135244.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217797',4208276,'2750','415',235820.07,238052.20,2232.13,363837.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','217797',4208277,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217797',4208278,'2752','415',274930.35,276843.32,1912.97,311814.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','217797',4208279,'2753','415',40287.03,40287.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','217797',4208280,'2754','415',254187.90,255717.65,1529.75,249349.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','217797',4208281,'2755','415',50982.36,50982.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','217797',4208282,'2756','416',109542.77,110404.67,861.90,254260.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','217797',4208283,'2757','416',84196.40,84455.04,258.64,76298.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','217797',4208284,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','217797',4208285,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218041',4212542,'2744','415',173454.03,175506.69,2052.66,334583.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','218041',4212543,'2745','415',270195.01,272106.88,1911.87,311634.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','218041',4212544,'2746','415',158816.29,160578.57,1762.28,287251.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','218041',4212545,'2747','415',276010.89,278095.75,2084.86,339832.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','218041',4212546,'2748','415',224265.90,226016.09,1750.19,285280.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','218041',4212547,'2749','415',135244.11,135601.23,357.12,58210.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','218041',4212548,'2750','415',238052.20,239842.87,1790.67,291879.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','218041',4212549,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218041',4212550,'2752','415',276843.32,278724.16,1880.84,306576.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','218041',4212551,'2753','415',40287.03,40630.65,343.62,56010.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','218041',4212552,'2754','415',255717.65,257122.03,1404.38,228913.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','218041',4212553,'2755','415',50982.36,51568.90,586.54,95606.02,0.00,0.00,0.00,0.00,0.00),('1','185','937','218041',4212554,'2756','416',110404.67,111145.19,740.52,218453.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','218041',4212555,'2757','416',84455.04,84610.03,154.99,45722.05,0.00,0.00,0.00,0.00,0.00),('1','185','938','218041',4212556,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218041',4212557,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218301',4217109,'2744','415',175506.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218301',4217110,'2745','415',272106.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218301',4217111,'2746','415',160578.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218301',4217112,'2747','415',278095.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218301',4217113,'2748','415',226016.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218301',4217114,'2749','415',135601.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218301',4217115,'2750','415',239842.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218301',4217116,'2751','415',54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218301',4217117,'2752','415',278724.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218301',4217118,'2753','415',40630.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218301',4217119,'2754','415',257122.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218301',4217120,'2755','415',51568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218301',4217121,'2756','416',111145.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218301',4217122,'2757','416',84610.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218301',4217123,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218301',4217124,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218356',4218204,'2744','415',175506.69,175506.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218356',4218205,'2745','415',272106.88,274317.49,2210.61,360329.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','218356',4218206,'2746','415',160578.57,160578.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218356',4218207,'2747','415',278095.75,280488.38,2392.63,389998.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','218356',4218208,'2748','415',226016.09,227844.09,1828.00,297964.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218356',4218209,'2749','415',135601.23,135601.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218356',4218210,'2750','415',239842.87,241960.10,2117.23,345108.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','218356',4218211,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218356',4218212,'2752','415',278724.16,280717.69,1993.53,324945.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','218356',4218213,'2753','415',40630.65,40630.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218356',4218214,'2754','415',257122.03,259326.58,2204.55,359341.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','218356',4218215,'2755','415',51568.90,51568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218356',4218216,'2756','416',111145.19,111818.42,673.23,198602.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','218356',4218217,'2757','416',84610.03,85141.73,531.70,156851.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','218356',4218218,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218356',4218219,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218362',4218292,'2744','415',175506.69,176564.19,1057.50,172372.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','218362',4218293,'2745','415',274317.49,276044.78,1727.29,281548.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','218362',4218294,'2746','415',160578.57,162366.00,1787.43,291351.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','218362',4218295,'2747','415',280488.38,282206.96,1718.58,280128.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','218362',4218296,'2748','415',227844.09,229391.90,1547.81,252293.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','218362',4218297,'2749','415',135601.23,135601.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218362',4218298,'2750','415',241960.10,244084.66,2124.56,346303.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','218362',4218299,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218362',4218300,'2752','415',280717.69,282859.63,2141.94,349136.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','218362',4218301,'2753','415',40630.65,40630.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218362',4218302,'2754','415',259326.58,261399.82,2073.24,337938.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','218362',4218303,'2755','415',51568.90,51568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218362',4218304,'2756','416',111818.42,112386.50,568.08,167583.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','218362',4218305,'2757','416',85141.73,85456.95,315.22,92989.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','218362',4218306,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218362',4218307,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218371',4218453,'2744','415',176564.19,178012.15,1447.96,236017.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','218371',4218454,'2745','415',276044.78,277894.12,1849.34,301442.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','218371',4218455,'2746','415',162366.00,162436.54,70.54,11498.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','218371',4218456,'2747','415',282206.96,284013.75,1806.79,294506.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','218371',4218457,'2748','415',229391.90,230681.77,1289.87,210248.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','218371',4218458,'2749','415',135601.23,135601.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218371',4218459,'2750','415',244084.66,245699.48,1614.82,263215.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','218371',4218460,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218371',4218461,'2752','415',282859.63,284895.80,2036.17,331895.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','218371',4218462,'2753','415',40630.65,40630.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218371',4218463,'2754','415',261399.82,263534.91,2135.09,348019.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','218371',4218464,'2755','415',51568.90,51568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218371',4218465,'2756','416',112386.50,112780.08,393.58,116106.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','218371',4218466,'2757','416',85456.95,85821.77,364.82,107621.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','218371',4218467,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218371',4218468,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218426',4219607,'2744','415',178012.15,179675.83,1663.68,271179.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','218426',4219608,'2745','415',277894.12,279398.97,1504.85,245290.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','218426',4219609,'2746','415',162436.54,163260.90,824.36,134370.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','218426',4219610,'2747','415',284013.75,286048.46,2034.71,331657.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','218426',4219611,'2748','415',230681.77,232486.18,1804.41,294118.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','218426',4219612,'2749','415',135601.23,136243.23,642.00,104646.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218426',4219613,'2750','415',245699.48,247244.78,1545.30,251883.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','218426',4219614,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218426',4219615,'2752','415',284895.80,286394.38,1498.58,244268.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','218426',4219616,'2753','415',40630.65,40630.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218426',4219617,'2754','415',263534.91,265252.60,1717.69,279983.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','218426',4219618,'2755','415',51568.90,51568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218426',4219619,'2756','416',112780.08,113332.16,552.08,162863.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','218426',4219620,'2757','416',85821.77,85882.61,60.84,17947.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','218426',4219621,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218426',4219622,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218528',4221193,'2744','415',179675.83,180262.57,586.74,95638.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','218528',4221194,'2745','415',279398.97,281143.41,1744.44,284343.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','218528',4221195,'2746','415',163260.90,164913.01,1652.11,269293.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','218528',4221196,'2747','415',286048.46,287354.60,1306.14,212900.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','218528',4221197,'2748','415',232486.18,233952.46,1466.28,239003.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','218528',4221198,'2749','415',136243.23,136243.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218528',4221199,'2750','415',247244.78,249018.06,1773.28,289044.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','218528',4221200,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218528',4221201,'2752','415',286394.38,288872.51,2478.13,403935.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','218528',4221202,'2753','415',40630.65,40630.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218528',4221203,'2754','415',265252.60,267029.50,1776.90,289634.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','218528',4221204,'2755','415',51568.90,52354.76,785.86,128095.18,0.00,0.00,0.00,0.00,0.00),('1','185','937','218528',4221205,'2756','416',113332.16,114338.24,1006.08,296793.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','218528',4221206,'2757','416',85882.61,86656.83,774.22,228394.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','218528',4221207,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218528',4221208,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218723',4224593,'2744','415',180262.57,182102.36,1839.79,299885.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','218723',4224594,'2745','415',281143.41,283327.86,2184.45,356065.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','218723',4224595,'2746','415',164913.01,167047.16,2134.15,347866.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','218723',4224596,'2747','415',287354.60,289701.33,2346.73,382516.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','218723',4224597,'2748','415',233952.46,235925.55,1973.09,321613.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','218723',4224598,'2749','415',136243.23,136243.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218723',4224599,'2750','415',249018.06,251404.93,2386.87,389059.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','218723',4224600,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218723',4224601,'2752','415',288872.51,291038.86,2166.35,353115.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','218723',4224602,'2753','415',40630.65,40730.63,99.98,16296.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','218723',4224603,'2754','415',267029.50,268705.93,1676.43,273258.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','218723',4224604,'2755','415',52354.76,52479.39,124.63,20314.69,0.00,0.00,0.00,0.00,0.00),('1','185','937','218723',4224605,'2756','416',114338.24,114834.77,496.53,146476.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','218723',4224606,'2757','416',86656.83,88308.54,1651.71,487254.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','218723',4224607,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218723',4224608,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218741',4224852,'2744','415',182102.36,182102.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218741',4224853,'2745','415',283327.86,285665.33,2337.47,381007.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','218741',4224854,'2746','415',167047.16,167047.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218741',4224855,'2747','415',289701.33,291527.88,1826.55,297727.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','218741',4224856,'2748','415',235925.55,238048.75,2123.20,346081.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','218741',4224857,'2749','415',136243.23,136243.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218741',4224858,'2750','415',251404.93,253650.89,2245.96,366091.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','218741',4224859,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218741',4224860,'2752','415',291038.86,293578.58,2539.72,413974.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','218741',4224861,'2753','415',40730.63,40730.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218741',4224862,'2754','415',268705.93,270520.12,1814.19,295712.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','218741',4224863,'2755','415',52479.39,52479.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218741',4224864,'2756','416',114834.77,115222.37,387.60,114342.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','218741',4224865,'2757','416',88308.54,88491.08,182.54,53849.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','218741',4224866,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218741',4224867,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','218852',4227083,'2744','415',182102.36,183523.63,1421.27,231667.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','218852',4227084,'2745','415',285665.33,287670.88,2005.55,326904.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','218852',4227085,'2746','415',167047.16,168439.75,1392.59,226992.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','218852',4227086,'2747','415',291527.88,293381.77,1853.89,302184.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','218852',4227087,'2748','415',238048.75,239139.07,1090.32,177722.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','218852',4227088,'2749','415',136243.23,137778.18,1534.95,250196.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','218852',4227089,'2750','415',253650.89,255573.71,1922.82,313419.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','218852',4227090,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','218852',4227091,'2752','415',293578.58,294921.66,1343.08,218922.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','218852',4227092,'2753','415',40730.63,42223.49,1492.86,243336.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','218852',4227093,'2754','415',270520.12,272598.47,2078.35,338771.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','218852',4227094,'2755','415',52479.39,52638.90,159.51,26000.13,0.00,0.00,0.00,0.00,0.00),('1','185','937','218852',4227095,'2756','416',115222.37,115949.53,727.16,214512.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','218852',4227096,'2757','416',88491.08,89688.03,1196.95,353100.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','218852',4227097,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','218852',4227098,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219031',4229942,'2744','415',183523.63,183523.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219031',4229943,'2745','415',287670.88,290151.34,2480.46,404314.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','219031',4229944,'2746','415',168439.75,168913.75,474.00,77262.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219031',4229945,'2747','415',293381.77,295997.47,2615.70,426359.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','219031',4229946,'2748','415',239139.07,241147.58,2008.51,327387.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','219031',4229947,'2749','415',137778.18,137778.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219031',4229948,'2750','415',255573.71,258241.05,2667.34,434776.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','219031',4229949,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219031',4229950,'2752','415',294921.66,297424.14,2502.48,407904.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','219031',4229951,'2753','415',42223.49,42223.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219031',4229952,'2754','415',272598.47,275506.42,2907.95,473995.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','219031',4229953,'2755','415',52638.90,53063.71,424.81,69244.03,0.00,0.00,0.00,0.00,0.00),('1','185','937','219031',4229954,'2756','416',115949.53,117013.72,1064.19,313936.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','219031',4229955,'2757','416',89688.03,90210.74,522.71,154199.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','219031',4229956,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219031',4229957,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219173',4232253,'2744','415',183523.63,185312.67,1789.04,291613.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','219173',4232254,'2745','415',290151.34,291976.78,1825.44,297546.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','219173',4232255,'2746','415',168913.75,170995.31,2081.56,339294.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','219173',4232256,'2747','415',295997.47,297707.42,1709.95,278721.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','219173',4232257,'2748','415',241147.58,243158.03,2010.45,327703.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','219173',4232258,'2749','415',137778.18,138908.22,1130.04,184196.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','219173',4232259,'2750','415',258241.05,259618.20,1377.15,224475.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','219173',4232260,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219173',4232261,'2752','415',297424.14,298847.53,1423.39,232012.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','219173',4232262,'2753','415',42223.49,42362.46,138.97,22652.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','219173',4232263,'2754','415',275506.42,277269.62,1763.20,287401.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','219173',4232264,'2755','415',53063.71,53512.56,448.85,73162.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','219173',4232265,'2756','416',117013.72,117602.01,588.29,173545.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','219173',4232266,'2757','416',90210.74,91545.93,1335.19,393881.05,0.00,0.00,0.00,0.00,0.00),('1','185','938','219173',4232267,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219173',4232268,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219184',4232465,'2744','415',185312.67,185312.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219184',4232466,'2745','415',291976.78,294100.95,2124.17,346239.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','219184',4232467,'2746','415',170995.31,171584.15,588.84,95980.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','219184',4232468,'2747','415',297707.42,300035.47,2328.05,379472.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','219184',4232469,'2748','415',243158.03,245446.47,2288.44,373015.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','219184',4232470,'2749','415',138908.22,139069.39,161.17,26270.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','219184',4232471,'2750','415',259618.20,262057.51,2439.31,397607.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','219184',4232472,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219184',4232473,'2752','415',298847.53,300931.20,2083.67,339638.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','219184',4232474,'2753','415',42362.46,42362.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219184',4232475,'2754','415',277269.62,278992.69,1723.07,280860.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','219184',4232476,'2755','415',53512.56,53512.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219184',4232477,'2756','416',117602.01,118196.70,594.69,175433.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','219184',4232478,'2757','416',91545.93,91819.58,273.65,80726.75,0.00,0.00,0.00,0.00,0.00),('1','185','938','219184',4232479,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219184',4232480,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219416',4236605,'2744','415',185312.67,187030.06,1717.39,279934.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','219416',4236606,'2745','415',294100.95,295610.81,1509.86,246107.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','219416',4236607,'2746','415',171584.15,172718.71,1134.56,184933.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','219416',4236608,'2747','415',300035.47,301966.90,1931.43,314823.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','219416',4236609,'2748','415',245446.47,247030.95,1584.48,258270.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','219416',4236610,'2749','415',139069.39,139613.56,544.17,88699.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','219416',4236611,'2750','415',262057.51,263841.86,1784.35,290849.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','219416',4236612,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219416',4236613,'2752','415',300931.20,302394.32,1463.12,238488.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','219416',4236614,'2753','415',42362.46,43695.08,1332.62,217217.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','219416',4236615,'2754','415',278992.69,280940.12,1947.43,317431.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','219416',4236616,'2755','415',53512.56,53512.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219416',4236617,'2756','416',118196.70,118807.81,611.11,180277.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','219416',4236618,'2757','416',91819.58,92321.20,501.62,147977.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','219416',4236619,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219416',4236620,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219433',4236884,'2744','415',187030.06,187030.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219433',4236885,'2745','415',295610.81,297733.59,2122.78,346013.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','219433',4236886,'2746','415',172718.71,173622.65,903.94,147342.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','219433',4236887,'2747','415',301966.90,303882.41,1915.51,312228.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','219433',4236888,'2748','415',247030.95,249077.76,2046.81,333630.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','219433',4236889,'2749','415',139613.56,140565.80,952.24,155215.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','219433',4236890,'2750','415',263841.86,265787.03,1945.17,317062.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','219433',4236891,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219433',4236892,'2752','415',302394.32,304413.13,2018.81,329066.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','219433',4236893,'2753','415',43695.08,43695.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219433',4236894,'2754','415',280940.12,283044.94,2104.82,343085.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','219433',4236895,'2755','415',53512.56,53512.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219433',4236896,'2756','416',118807.81,118807.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219433',4236897,'2757','416',92321.20,93360.62,1039.42,306628.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','219433',4236898,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219433',4236899,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219534',4238827,'2744','415',187030.06,188950.01,1919.95,312951.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','219534',4238828,'2745','415',297733.59,299825.75,2092.16,341022.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','219534',4238829,'2746','415',173622.65,174997.31,1374.66,224069.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','219534',4238830,'2747','415',303882.41,306132.45,2250.04,366756.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','219534',4238831,'2748','415',249077.76,250870.89,1793.13,292280.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','219534',4238832,'2749','415',140565.80,142116.85,1551.05,252821.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','219534',4238833,'2750','415',265787.03,267717.20,1930.17,314617.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','219534',4238834,'2751','415',54008.05,54008.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219534',4238835,'2752','415',304413.13,306502.79,2089.66,340614.58,0.00,0.00,0.00,0.00,0.00),('1','185','936','219534',4238836,'2753','415',43695.08,44164.10,469.02,76450.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','219534',4238837,'2754','415',283044.94,285163.38,2118.44,345305.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','219534',4238838,'2755','415',53512.56,53512.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219534',4238839,'2756','416',118807.81,119972.71,1164.90,343645.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','219534',4238840,'2757','416',93360.62,95037.24,1676.62,494602.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','219534',4238841,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219534',4238842,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219740',4242540,'2744','415',188950.01,188965.96,15.95,2599.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','219740',4242541,'2745','415',299825.75,301788.11,1962.36,319864.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','219740',4242542,'2746','415',174997.31,174997.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219740',4242543,'2747','415',306132.45,307984.28,1851.83,301848.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','219740',4242544,'2748','415',250870.89,252507.22,1636.33,266721.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','219740',4242545,'2749','415',142116.85,143307.85,1191.00,194133.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219740',4242546,'2750','415',267717.20,269872.50,2155.30,351313.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','219740',4242547,'2751','415',54008.05,54008.23,0.18,29.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','219740',4242548,'2752','415',306502.79,308429.86,1927.07,314112.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','219740',4242549,'2753','415',44164.10,44164.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219740',4242550,'2754','415',285163.38,286939.62,1776.24,289527.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','219740',4242551,'2755','415',53512.56,54006.16,493.60,80456.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','219740',4242552,'2756','416',119972.71,120338.35,365.64,107863.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','219740',4242553,'2757','416',95037.24,95505.45,468.21,138121.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','219740',4242554,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219740',4242555,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219883',4244834,'2744','415',188965.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219883',4244835,'2745','415',301788.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219883',4244836,'2746','415',174997.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219883',4244837,'2747','415',307984.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219883',4244838,'2748','415',252507.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219883',4244839,'2749','415',143307.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219883',4244840,'2750','415',269872.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219883',4244841,'2751','415',54008.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219883',4244842,'2752','415',308429.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219883',4244843,'2753','415',44164.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219883',4244844,'2754','415',286939.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219883',4244845,'2755','415',54006.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219883',4244846,'2756','416',120338.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','219883',4244847,'2757','416',95505.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219883',4244848,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219883',4244849,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219890',4244968,'2744','415',188965.96,190857.40,1891.44,308304.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','219890',4244969,'2745','415',301788.11,303695.47,1907.36,310899.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','219890',4244970,'2746','415',174997.31,176296.02,1298.71,211689.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','219890',4244971,'2747','415',307984.28,309768.50,1784.22,290827.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','219890',4244972,'2748','415',252507.22,254190.23,1683.01,274330.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','219890',4244973,'2749','415',143307.85,144143.26,835.41,136171.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','219890',4244974,'2750','415',269872.50,271260.62,1388.12,226263.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','219890',4244975,'2751','415',54008.23,54008.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','219890',4244976,'2752','415',308429.86,309857.99,1428.13,232785.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','219890',4244977,'2753','415',44164.10,45109.36,945.26,154077.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','219890',4244978,'2754','415',286939.62,287812.78,873.16,142325.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','219890',4244979,'2755','415',54006.16,55315.11,1308.95,213358.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','219890',4244980,'2756','416',120338.35,120824.12,485.77,140873.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','219890',4244981,'2757','416',95505.45,95574.40,68.95,19995.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','219890',4244982,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219890',4244983,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','219973',4246708,'2744','415',190857.40,192815.17,1947.77,317486.51,0.00,0.00,10.00,0.00,0.00),('1','185','935','219973',4246709,'2745','415',303695.47,305330.67,1615.20,263277.60,0.00,0.00,20.00,0.00,0.00),('1','185','935','219973',4246710,'2746','415',176296.02,177693.59,1387.57,226173.91,0.00,0.00,10.00,0.00,0.00),('1','185','935','219973',4246711,'2747','415',309768.50,310100.20,321.70,52437.10,0.00,0.00,10.00,0.00,0.00),('1','185','935','219973',4246712,'2748','415',254190.23,255225.33,1025.10,167091.30,0.00,0.00,10.00,0.00,0.00),('1','185','935','219973',4246713,'2749','415',144143.26,144153.26,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','219973',4246714,'2750','415',271260.62,272666.76,1396.14,227570.82,0.00,0.00,10.00,0.00,0.00),('1','185','936','219973',4246715,'2751','415',54008.23,54028.23,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','185','936','219973',4246716,'2752','415',309857.99,311904.51,2036.52,331952.76,0.00,0.00,10.00,0.00,0.00),('1','185','936','219973',4246717,'2753','415',45109.36,45119.36,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','219973',4246718,'2754','415',287812.78,289026.67,1203.89,196234.07,0.00,0.00,10.00,0.00,0.00),('1','185','936','219973',4246719,'2755','415',55315.11,56533.92,1208.81,197036.03,0.00,0.00,10.00,0.00,0.00),('1','185','937','219973',4246720,'2756','416',120824.12,121161.53,337.41,97848.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','219973',4246721,'2757','416',95574.40,95953.36,378.96,109898.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','219973',4246722,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','219973',4246723,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220124',4249286,'2744','415',192815.17,194194.30,1379.13,224798.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','220124',4249287,'2745','415',305330.67,306115.72,785.05,127963.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','220124',4249288,'2746','415',177693.59,178706.56,1012.97,165114.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','220124',4249289,'2747','415',310100.20,311544.33,1444.13,235393.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','220124',4249290,'2748','415',255225.33,256766.09,1540.76,251143.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','220124',4249291,'2749','415',144153.26,144714.63,561.37,91503.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','220124',4249292,'2750','415',272666.76,274153.57,1486.81,242350.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','220124',4249293,'2751','415',54028.23,54139.35,111.12,18112.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','220124',4249294,'2752','415',311904.51,313284.33,1379.82,224910.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','220124',4249295,'2753','415',45119.36,46011.12,891.76,145356.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','220124',4249296,'2754','415',289026.67,290004.52,977.85,159389.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','220124',4249297,'2755','415',56533.92,57319.42,785.50,128036.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','220124',4249298,'2756','416',121161.53,122080.26,918.73,266431.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','220124',4249299,'2757','416',95953.36,96087.15,133.79,38799.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','220124',4249300,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220124',4249301,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220129',4249380,'2744','415',194194.30,195962.14,1767.84,288157.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','220129',4249381,'2745','415',306115.72,307718.58,1602.86,261266.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','220129',4249382,'2746','415',178706.56,179674.36,967.80,157751.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','220129',4249383,'2747','415',311544.33,313250.49,1706.16,278104.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','220129',4249384,'2748','415',256766.09,258096.64,1330.55,216879.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','220129',4249385,'2749','415',144714.63,145893.00,1178.37,192074.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','220129',4249386,'2750','415',274153.57,275454.17,1300.60,211997.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','220129',4249387,'2751','415',54139.35,54139.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220129',4249388,'2752','415',313284.33,314941.72,1657.39,270154.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','220129',4249389,'2753','415',46011.12,46011.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220129',4249390,'2754','415',290004.52,291900.29,1895.77,309010.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','220129',4249391,'2755','415',57319.42,57319.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','220129',4249392,'2756','416',122080.26,122562.28,482.02,139785.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','220129',4249393,'2757','416',96087.15,96209.56,122.41,35498.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','220129',4249394,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220129',4249395,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220319',4252607,'2744','415',195962.14,197489.61,1527.47,248977.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','220319',4252608,'2745','415',307718.58,309839.14,2120.56,345651.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','220319',4252609,'2746','415',179674.36,181301.03,1626.67,265147.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','220319',4252610,'2747','415',313250.49,315018.23,1767.74,288141.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','220319',4252611,'2748','415',258096.64,258754.33,657.69,107203.47,0.00,0.00,0.00,0.00,0.00),('1','185','935','220319',4252612,'2749','415',145893.00,146753.40,860.40,140245.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','220319',4252613,'2750','415',275454.17,277354.42,1900.25,309740.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','220319',4252614,'2751','415',54139.35,54139.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220319',4252615,'2752','415',314941.72,316500.92,1559.20,254149.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','220319',4252616,'2753','415',46011.12,47200.46,1189.34,193862.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','220319',4252617,'2754','415',291900.29,294156.29,2256.00,367728.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220319',4252618,'2755','415',57319.42,57553.38,233.96,38135.48,0.00,0.00,0.00,0.00,0.00),('1','185','937','220319',4252619,'2756','416',122562.28,123163.74,601.46,174423.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','220319',4252620,'2757','416',96209.56,97348.61,1139.05,330324.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','220319',4252621,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220319',4252622,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220335',4252968,'2744','415',197489.61,197489.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220335',4252969,'2745','415',309839.14,312125.17,2286.03,372622.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','220335',4252970,'2746','415',181301.03,181675.12,374.09,60976.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','220335',4252971,'2747','415',315018.23,317023.17,2004.94,326805.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','220335',4252972,'2748','415',258754.33,260711.62,1957.29,319038.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','220335',4252973,'2749','415',146753.40,147990.18,1236.78,201595.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','220335',4252974,'2750','415',277354.42,279262.12,1907.70,310955.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','220335',4252975,'2751','415',54139.35,54494.80,355.45,57938.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','220335',4252976,'2752','415',316500.92,318350.88,1849.96,301543.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','220335',4252977,'2753','415',47200.46,47339.47,139.01,22658.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','220335',4252978,'2754','415',294156.29,295638.15,1481.86,241543.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','220335',4252979,'2755','415',57553.38,57720.86,167.48,27299.24,0.00,0.00,0.00,0.00,0.00),('1','185','937','220335',4252980,'2756','416',123163.74,123649.95,486.21,141000.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','220335',4252981,'2757','416',97348.61,97758.94,410.33,118995.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','220335',4252982,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220335',4252983,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220417',4254751,'2744','415',197489.61,199752.86,2263.25,368909.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','220417',4254752,'2745','415',312125.17,314231.59,2106.42,343346.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','220417',4254753,'2746','415',181675.12,183259.60,1584.48,258270.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','220417',4254754,'2747','415',317023.17,319427.22,2404.05,391860.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','220417',4254755,'2748','415',260711.62,262421.41,1709.79,278695.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','220417',4254756,'2749','415',147990.18,149207.05,1216.87,198349.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','220417',4254757,'2750','415',279262.12,281109.39,1847.27,301105.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','220417',4254758,'2751','415',54494.80,54618.43,123.63,20151.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','220417',4254759,'2752','415',318350.88,320363.56,2012.68,328066.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','220417',4254760,'2753','415',47339.47,47339.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220417',4254761,'2754','415',295638.15,297881.28,2243.13,365630.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','220417',4254762,'2755','415',57720.86,57955.09,234.23,38179.49,0.00,0.00,0.00,0.00,0.00),('1','185','937','220417',4254763,'2756','416',123649.95,124205.18,555.23,161016.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','220417',4254764,'2757','416',97758.94,98079.68,320.74,93014.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','220417',4254765,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220417',4254766,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220621',4258115,'2744','415',199752.86,199752.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220621',4258116,'2745','415',314231.59,316408.61,2177.02,354854.26,0.00,0.00,0.00,0.00,0.00),('1','185','935','220621',4258117,'2746','415',183259.60,183782.12,522.52,85170.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','220621',4258118,'2747','415',319427.22,321604.89,2177.67,354960.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','220621',4258119,'2748','415',262421.41,262421.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220621',4258120,'2749','415',149207.05,151054.65,1847.60,301158.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','220621',4258121,'2750','415',281109.39,283447.42,2338.03,381098.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','220621',4258122,'2751','415',54618.43,54618.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220621',4258123,'2752','415',320363.56,322446.62,2083.06,339538.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','220621',4258124,'2753','415',47339.47,47933.51,594.04,96828.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','220621',4258125,'2754','415',297881.28,299897.98,2016.70,328722.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','220621',4258126,'2755','415',57955.09,58597.99,642.90,104792.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','220621',4258127,'2756','416',124205.18,124205.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','220621',4258128,'2757','416',98079.68,99126.35,1046.67,303534.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','220621',4258129,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220621',4258130,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220734',4259875,'2744','415',199752.86,201933.42,2180.56,355431.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','220734',4259876,'2745','415',316408.61,318338.85,1930.24,314629.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','220734',4259877,'2746','415',183782.12,185343.70,1561.58,254537.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','220734',4259878,'2747','415',321604.89,323523.37,1918.48,312712.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','220734',4259879,'2748','415',262421.41,264193.41,1772.00,288836.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220734',4259880,'2749','415',151054.65,152204.40,1149.75,187409.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','220734',4259881,'2750','415',283447.42,285447.30,1999.88,325980.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','220734',4259882,'2751','415',54618.43,54992.87,374.44,61033.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','220734',4259883,'2752','415',322446.62,323888.06,1441.44,234954.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','220734',4259884,'2753','415',47933.51,48119.07,185.56,30246.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','220734',4259885,'2754','415',299897.98,301778.12,1880.14,306462.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','220734',4259886,'2755','415',58597.99,58597.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','220734',4259887,'2756','416',124205.18,125136.37,931.19,270045.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','220734',4259888,'2757','416',99126.35,99617.09,490.74,142314.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','220734',4259889,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220734',4259890,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220831',4261824,'2744','415',201933.42,202753.96,820.54,133748.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','220831',4261825,'2745','415',318338.85,320519.36,2180.51,355423.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','220831',4261826,'2746','415',185343.70,186410.16,1066.46,173832.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','220831',4261827,'2747','415',323523.37,325893.22,2369.85,386285.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','220831',4261828,'2748','415',264193.41,264301.58,108.17,17631.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','220831',4261829,'2749','415',152204.40,153783.46,1579.06,257386.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','220831',4261830,'2750','415',285447.30,287862.42,2415.12,393664.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','220831',4261831,'2751','415',54992.87,54992.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','220831',4261832,'2752','415',323888.06,324275.35,387.29,63128.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','220831',4261833,'2753','415',48119.07,49991.98,1872.91,305284.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','220831',4261834,'2754','415',301778.12,304086.11,2307.99,376202.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','220831',4261835,'2755','415',58597.99,59095.09,497.10,81027.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','220831',4261836,'2756','416',125136.37,126453.63,1317.26,382005.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','220831',4261837,'2757','416',99617.09,99959.33,342.24,99249.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','220831',4261838,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220831',4261839,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','220955',4263865,'2744','415',202753.96,204038.23,1284.27,209336.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','220955',4263866,'2745','415',320519.36,322348.94,1829.58,298221.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','220955',4263867,'2746','415',186410.16,187938.13,1527.97,249059.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','220955',4263868,'2747','415',325893.22,327806.02,1912.80,311786.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','220955',4263869,'2748','415',264301.58,265852.86,1551.28,252858.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','220955',4263870,'2749','415',153783.46,154826.24,1042.78,169973.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','220955',4263871,'2750','415',287862.42,289398.47,1536.05,250376.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','220955',4263872,'2751','415',54992.87,55520.13,527.26,85943.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','220955',4263873,'2752','415',324275.35,326299.74,2024.39,329975.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','220955',4263874,'2753','415',49991.98,50594.16,602.18,98155.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','220955',4263875,'2754','415',304086.11,306176.26,2090.15,340694.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','220955',4263876,'2755','415',59095.09,59893.58,798.49,130153.87,0.00,0.00,0.00,0.00,0.00),('1','185','937','220955',4263877,'2756','416',126453.63,127383.65,930.02,269705.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','220955',4263878,'2757','416',99959.33,100164.48,205.15,59493.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','220955',4263879,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','220955',4263880,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221007',4264841,'2744','415',204038.23,205177.41,1139.18,185686.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','221007',4264842,'2745','415',322348.94,324188.94,1840.00,299920.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221007',4264843,'2746','415',187938.13,188441.62,503.49,82068.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','221007',4264844,'2747','415',327806.02,329636.66,1830.64,298394.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','221007',4264845,'2748','415',265852.86,267681.12,1828.26,298006.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','221007',4264846,'2749','415',154826.24,155330.03,503.79,82117.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','221007',4264847,'2750','415',289398.47,291162.28,1763.81,287501.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','221007',4264848,'2751','415',55520.13,55520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221007',4264849,'2752','415',326299.74,328455.87,2156.13,351449.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','221007',4264850,'2753','415',50594.16,51163.58,569.42,92815.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','221007',4264851,'2754','415',306176.26,308346.97,2170.71,353825.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','221007',4264852,'2755','415',59893.58,59989.43,95.85,15623.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','221007',4264853,'2756','416',127383.65,127958.24,574.59,166631.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','221007',4264854,'2757','416',100164.48,100717.60,553.12,160404.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','221007',4264855,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221007',4264856,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221198',4268155,'2744','415',205177.41,206972.49,1795.08,292598.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','221198',4268156,'2745','415',324188.94,326348.03,2159.09,351931.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','221198',4268157,'2746','415',188441.62,190314.59,1872.97,305294.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','221198',4268158,'2747','415',329636.66,331577.45,1940.79,316348.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','221198',4268159,'2748','415',267681.12,269517.39,1836.27,299312.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','221198',4268160,'2749','415',155330.03,156748.88,1418.85,231272.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','221198',4268161,'2750','415',291162.28,292728.69,1566.41,255324.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','221198',4268162,'2751','415',55520.13,55520.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221198',4268163,'2752','415',328455.87,329800.95,1345.08,219248.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','221198',4268164,'2753','415',51163.58,51163.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221198',4268165,'2754','415',308346.97,310065.17,1718.20,280066.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','221198',4268166,'2755','415',59989.43,60259.57,270.14,44032.82,0.00,0.00,0.00,0.00,0.00),('1','185','937','221198',4268167,'2756','416',127958.24,129865.87,1907.63,553212.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','221198',4268168,'2757','416',100717.60,100870.00,152.40,44196.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221198',4268169,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221198',4268170,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221223',4268635,'2744','415',206972.49,208420.89,1448.40,236089.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','221223',4268636,'2745','415',326348.03,327653.80,1305.77,212840.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','221223',4268637,'2746','415',190314.59,191547.99,1233.40,201044.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','221223',4268638,'2747','415',331577.45,333111.38,1533.93,250030.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','221223',4268639,'2748','415',269517.39,271011.11,1493.72,243476.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','221223',4268640,'2749','415',156748.88,157191.17,442.29,72093.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','221223',4268641,'2750','415',292728.69,294136.97,1408.28,229549.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','221223',4268642,'2751','415',55520.13,55530.13,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','221223',4268643,'2752','415',329800.95,331455.30,1644.35,268029.05,0.00,0.00,10.00,0.00,0.00),('1','185','936','221223',4268644,'2753','415',51163.58,52537.77,1374.19,223992.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','221223',4268645,'2754','415',310065.17,312268.38,2203.21,359123.23,0.00,0.00,0.00,0.00,0.00),('1','185','936','221223',4268646,'2755','415',60259.57,60259.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','221223',4268647,'2756','416',129865.87,130303.22,437.35,126831.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','221223',4268648,'2757','416',100870.00,101052.75,182.75,52997.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','221223',4268649,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221223',4268650,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221434',4272392,'2744','415',208420.89,210216.79,1795.90,292731.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','221434',4272393,'2745','415',327653.80,329215.72,1561.92,254592.96,0.00,0.00,0.00,0.00,0.00),('1','185','935','221434',4272394,'2746','415',191547.99,192487.08,939.09,153071.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','221434',4272395,'2747','415',333111.38,335577.64,2466.26,402000.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','221434',4272396,'2748','415',271011.11,272648.87,1637.76,266954.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','221434',4272397,'2749','415',157191.17,158145.82,954.65,155607.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','221434',4272398,'2750','415',294136.97,295951.80,1814.83,295817.29,0.00,0.00,0.00,0.00,0.00),('1','185','936','221434',4272399,'2751','415',55530.13,55729.51,199.38,32498.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','221434',4272400,'2752','415',331455.30,333197.85,1742.55,284035.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','221434',4272401,'2753','415',52537.77,53384.71,846.94,138051.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','221434',4272402,'2754','415',312268.38,314185.59,1917.21,312505.23,0.00,0.00,0.00,0.00,0.00),('1','185','936','221434',4272403,'2755','415',60259.57,60745.09,485.52,79139.76,0.00,0.00,0.00,0.00,0.00),('1','185','937','221434',4272404,'2756','416',130303.22,130513.59,210.37,61007.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','221434',4272405,'2757','416',101052.75,101411.38,358.63,104002.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','221434',4272406,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221434',4272407,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221571',4275269,'2744','415',210216.79,211320.28,1103.49,179868.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','221571',4275270,'2745','415',329215.72,330592.80,1377.08,224464.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','221571',4275271,'2746','415',192487.08,193888.95,1401.87,228504.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','221571',4275272,'2747','415',335577.64,337179.03,1601.39,261026.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','221571',4275273,'2748','415',272648.87,274110.47,1461.60,238240.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','221571',4275274,'2749','415',158145.82,158551.98,406.16,66204.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','221571',4275275,'2750','415',295951.80,297718.64,1766.84,287994.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','221571',4275276,'2751','415',55729.51,56813.54,1084.03,176696.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','221571',4275277,'2752','415',333197.85,334615.84,1417.99,231132.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','221571',4275278,'2753','415',53384.71,53885.85,501.14,81685.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','221571',4275279,'2754','415',314185.59,315965.66,1780.07,290151.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','221571',4275280,'2755','415',60745.09,60745.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','221571',4275281,'2756','416',130513.59,131437.05,923.46,267803.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','221571',4275282,'2757','416',101411.38,101524.14,112.76,32700.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','221571',4275283,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221571',4275284,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221726',4277877,'2744','415',211320.28,213019.87,1699.59,277033.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','221726',4277878,'2745','415',330592.80,332311.73,1718.93,280185.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','221726',4277879,'2746','415',193888.95,194926.67,1037.72,169148.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','221726',4277880,'2747','415',337179.03,339545.75,2366.72,385775.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','221726',4277881,'2748','415',274110.47,275854.60,1744.13,284293.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','221726',4277882,'2749','415',158551.98,159916.10,1364.12,222351.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','221726',4277883,'2750','415',297718.64,299323.39,1604.75,261574.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','221726',4277884,'2751','415',56813.54,56813.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221726',4277885,'2752','415',334615.84,334615.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221726',4277886,'2753','415',53885.85,55906.22,2020.37,329320.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','221726',4277887,'2754','415',315965.66,317399.67,1434.01,233743.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','221726',4277888,'2755','415',60745.09,60745.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','221726',4277889,'2756','416',131437.05,131923.48,486.43,141064.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','221726',4277890,'2757','416',101524.14,102569.22,1045.08,303073.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','221726',4277891,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221726',4277892,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221771',4278830,'2744','415',213019.87,213019.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221771',4278831,'2745','415',332311.73,334220.31,1908.58,311098.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','221771',4278832,'2746','415',194926.67,196191.77,1265.10,206211.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','221771',4278833,'2747','415',339545.75,341237.06,1691.31,275683.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','221771',4278834,'2748','415',275854.60,277480.69,1626.09,265052.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','221771',4278835,'2749','415',159916.10,160906.68,990.58,161464.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','221771',4278836,'2750','415',299323.39,301072.85,1749.46,285161.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','221771',4278837,'2751','415',56813.54,56813.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221771',4278838,'2752','415',334615.84,334615.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','221771',4278839,'2753','415',55906.22,57377.85,1471.63,239875.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','221771',4278840,'2754','415',317399.67,319530.75,2131.08,347366.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','221771',4278841,'2755','415',60745.09,61180.72,435.63,71007.69,0.00,0.00,0.00,0.00,0.00),('1','185','937','221771',4278842,'2756','416',131923.48,132132.80,209.32,60702.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','221771',4278843,'2757','416',102569.22,102886.11,316.89,91898.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','221771',4278844,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221771',4278845,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','221889',4280655,'2744','415',213019.87,214634.82,1614.95,263236.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','221889',4280656,'2745','415',334220.31,335789.59,1569.28,255792.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','221889',4280657,'2746','415',196191.77,196611.83,420.06,68469.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','221889',4280658,'2747','415',341237.06,343898.44,2661.38,433804.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','221889',4280659,'2748','415',277480.69,278742.58,1261.89,205688.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','221889',4280660,'2749','415',160906.68,162350.53,1443.85,235347.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','221889',4280661,'2750','415',301072.85,302694.26,1621.41,264289.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','221889',4280662,'2751','415',56813.54,57438.96,625.42,101943.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','221889',4280663,'2752','415',334615.84,336211.59,1595.75,260107.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','221889',4280664,'2753','415',57377.85,58601.99,1224.14,199534.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','221889',4280665,'2754','415',319530.75,321685.54,2154.79,351230.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','221889',4280666,'2755','415',61180.72,61236.30,55.58,9059.54,0.00,0.00,0.00,0.00,0.00),('1','185','937','221889',4280667,'2756','416',132132.80,132294.85,162.05,46994.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','221889',4280668,'2757','416',102886.11,102921.97,35.86,10399.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','221889',4280669,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','221889',4280670,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222007',4283039,'2744','415',214634.82,214634.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222007',4283040,'2745','415',335789.59,337861.85,2072.26,337778.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','222007',4283041,'2746','415',196611.83,197566.39,954.56,155593.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','222007',4283042,'2747','415',343898.44,345356.45,1458.01,237655.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','222007',4283043,'2748','415',278742.58,280198.79,1456.21,237362.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','222007',4283044,'2749','415',162350.53,163374.38,1023.85,166887.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','222007',4283045,'2750','415',302694.26,304741.85,2047.59,333757.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','222007',4283046,'2751','415',57438.96,57438.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222007',4283047,'2752','415',336211.59,337756.12,1544.53,251758.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','222007',4283048,'2753','415',58601.99,58601.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222007',4283049,'2754','415',321685.54,323724.46,2038.92,332343.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','222007',4283050,'2755','415',61236.30,61236.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','222007',4283051,'2756','416',132294.85,132693.01,398.16,115466.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','222007',4283052,'2757','416',102921.97,103100.78,178.81,51854.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','222007',4283053,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222007',4283054,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222121',4284975,'2744','415',214634.82,215630.23,995.41,162251.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','222121',4284976,'2745','415',337861.85,339747.05,1885.20,307287.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','222121',4284977,'2746','415',197566.39,199257.89,1691.50,275714.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','222121',4284978,'2747','415',345356.45,346865.70,1509.25,246007.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','222121',4284979,'2748','415',280198.79,281948.00,1749.21,285121.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','222121',4284980,'2749','415',163374.38,164427.15,1052.77,171601.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','222121',4284981,'2750','415',304741.85,306113.28,1371.43,223543.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','222121',4284982,'2751','415',57438.96,58355.22,916.26,149350.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','222121',4284983,'2752','415',337756.12,339275.40,1519.28,247642.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','222121',4284984,'2753','415',58601.99,59769.49,1167.50,190302.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','222121',4284985,'2754','415',323724.46,325208.60,1484.14,241914.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','222121',4284986,'2755','415',61236.30,61412.17,175.87,28666.81,0.00,0.00,0.00,0.00,0.00),('1','185','937','222121',4284987,'2756','416',132693.01,134041.26,1348.25,390992.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','222121',4284988,'2757','416',103100.78,103211.13,110.35,32001.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','222121',4284989,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222121',4284990,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222196',4286268,'2744','415',215630.23,215630.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222196',4286269,'2745','415',339747.05,341750.46,2003.41,326555.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','222196',4286270,'2746','415',199257.89,199874.69,616.80,100538.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','222196',4286271,'2747','415',346865.70,348653.47,1787.77,291406.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','222196',4286272,'2748','415',281948.00,284243.10,2295.10,374101.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','222196',4286273,'2749','415',164427.15,164427.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222196',4286274,'2750','415',306113.28,308217.04,2103.76,342912.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','222196',4286275,'2751','415',58355.22,58749.94,394.72,64339.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','222196',4286276,'2752','415',339275.40,340828.38,1552.98,253135.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','222196',4286277,'2753','415',59769.49,59769.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222196',4286278,'2754','415',325208.60,326730.06,1521.46,247997.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','222196',4286279,'2755','415',61412.17,61412.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','222196',4286280,'2756','416',134041.26,134377.85,336.59,97611.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','222196',4286281,'2757','416',103211.13,103290.23,79.10,22939.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222196',4286282,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222196',4286283,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222316',4288047,'2744','415',215630.23,216720.10,1089.87,177648.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','222316',4288048,'2745','415',341750.46,343757.86,2007.40,327206.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','222316',4288049,'2746','415',199874.69,201327.02,1452.33,236729.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','222316',4288050,'2747','415',348653.47,351550.31,2896.84,472184.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','222316',4288051,'2748','415',284243.10,286471.25,2228.15,363188.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','222316',4288052,'2749','415',164427.15,166296.44,1869.29,304694.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','222316',4288053,'2750','415',308217.04,310636.67,2419.63,394399.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','222316',4288054,'2751','415',58749.94,59313.17,563.23,91806.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','222316',4288055,'2752','415',340828.38,343035.68,2207.30,359789.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','222316',4288056,'2753','415',59769.49,59769.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222316',4288057,'2754','415',326730.06,329119.59,2389.53,389493.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','222316',4288058,'2755','415',61412.17,62124.62,712.45,116129.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','222316',4288059,'2756','416',134377.85,134586.91,209.06,60627.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','222316',4288060,'2757','416',103290.23,103703.84,413.61,119946.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','222316',4288061,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222316',4288062,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222439',4290469,'2744','415',216720.10,217569.10,849.00,138387.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222439',4290470,'2745','415',343757.86,345289.68,1531.82,249686.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','222439',4290471,'2746','415',201327.02,201588.97,261.95,42697.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','222439',4290472,'2747','415',351550.31,353574.93,2024.62,330013.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','222439',4290473,'2748','415',286471.25,286683.52,212.27,34600.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','222439',4290474,'2749','415',166296.44,167563.66,1267.22,206556.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','222439',4290475,'2750','415',310636.67,313020.65,2383.98,388588.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','222439',4290476,'2751','415',59313.17,59693.30,380.13,61961.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','222439',4290477,'2752','415',343035.68,345535.15,2499.47,407413.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','222439',4290478,'2753','415',59769.49,59769.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222439',4290479,'2754','415',329119.59,331037.19,1917.60,312568.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','222439',4290480,'2755','415',62124.62,62453.09,328.47,53540.61,0.00,0.00,0.00,0.00,0.00),('1','185','937','222439',4290481,'2756','416',134586.91,136085.97,1499.06,434727.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','222439',4290482,'2757','416',103703.84,104893.55,1189.71,345015.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','222439',4290483,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222439',4290484,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222559',4292367,'2744','415',217569.10,219872.19,2303.09,375403.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','222559',4292368,'2745','415',345289.68,347667.13,2377.45,387524.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','222559',4292369,'2746','415',201588.97,202898.96,1309.99,213528.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','222559',4292370,'2747','415',353574.93,356145.64,2570.71,419025.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','222559',4292371,'2748','415',286683.52,288626.60,1943.08,316722.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','222559',4292372,'2749','415',167563.66,169054.84,1491.18,243062.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','222559',4292373,'2750','415',313020.65,315065.57,2044.92,333321.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','222559',4292374,'2751','415',59693.30,59693.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222559',4292375,'2752','415',345535.15,347451.84,1916.69,312420.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','222559',4292376,'2753','415',59769.49,59993.50,224.01,36513.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','222559',4292377,'2754','415',331037.19,332718.56,1681.37,274063.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','222559',4292378,'2755','415',62453.09,63282.39,829.30,135175.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','222559',4292379,'2756','416',136085.97,136515.51,429.54,124566.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','222559',4292380,'2757','416',104893.55,106182.65,1289.10,373839.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222559',4292381,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222559',4292382,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222647',4294054,'2744','415',219872.19,220473.14,600.95,97954.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','222647',4294055,'2745','415',347667.13,349678.33,2011.20,327825.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','222647',4294056,'2746','415',202898.96,203522.33,623.37,101609.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','222647',4294057,'2747','415',356145.64,358833.42,2687.78,438108.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','222647',4294058,'2748','415',288626.60,288626.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222647',4294059,'2749','415',169054.84,170530.48,1475.64,240529.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','222647',4294060,'2750','415',315065.57,317522.95,2457.38,400552.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','222647',4294061,'2751','415',59693.30,59693.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222647',4294062,'2752','415',347451.84,349776.57,2324.73,378930.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','222647',4294063,'2753','415',59993.50,59993.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222647',4294064,'2754','415',332718.56,335134.57,2416.01,393809.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','222647',4294065,'2755','415',63282.39,63282.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','222647',4294066,'2756','416',136515.51,137086.67,571.16,165636.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','222647',4294067,'2757','416',106182.65,106360.23,177.58,51498.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','222647',4294068,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222647',4294069,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222779',4296416,'2744','415',220473.14,222303.47,1830.33,298343.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','222779',4296417,'2745','415',349678.33,351484.50,1806.17,294405.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','222779',4296418,'2746','415',203522.33,205168.81,1646.48,268376.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','222779',4296419,'2747','415',358833.42,360538.93,1705.51,277998.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','222779',4296420,'2748','415',288626.60,290312.02,1685.42,274723.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','222779',4296421,'2749','415',170530.48,171746.57,1216.09,198222.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','222779',4296422,'2750','415',317522.95,319293.68,1770.73,288628.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','222779',4296423,'2751','415',59693.30,59799.02,105.72,17232.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','222779',4296424,'2752','415',349776.57,349987.89,211.32,34445.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','222779',4296425,'2753','415',59993.50,61608.68,1615.18,263274.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','222779',4296426,'2754','415',335134.57,336701.77,1567.20,255453.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','222779',4296427,'2755','415',63282.39,64002.99,720.60,117457.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','222779',4296428,'2756','416',137086.67,137382.39,295.72,85758.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','222779',4296429,'2757','416',106360.23,106495.40,135.17,39199.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','222779',4296430,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222779',4296431,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222868',4298320,'2744','415',222303.47,222303.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222868',4298321,'2745','415',351484.50,353841.81,2357.31,384241.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','222868',4298322,'2746','415',205168.81,205168.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222868',4298323,'2747','415',360538.93,362528.38,1989.45,324280.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','222868',4298324,'2748','415',290312.02,292095.51,1783.49,290708.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','222868',4298325,'2749','415',171746.57,172770.31,1023.74,166869.62,0.00,0.00,0.00,0.00,0.00),('1','185','936','222868',4298326,'2750','415',319293.68,321303.29,2009.61,327566.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','222868',4298327,'2751','415',59799.02,59891.50,92.48,15074.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','222868',4298328,'2752','415',349987.89,351844.26,1856.37,302588.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','222868',4298329,'2753','415',61608.68,61608.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222868',4298330,'2754','415',336701.77,338623.77,1922.00,313286.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222868',4298331,'2755','415',64002.99,64002.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','222868',4298332,'2756','416',137382.39,137731.55,349.16,101256.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','222868',4298333,'2757','416',106495.40,106607.34,111.94,32462.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','222868',4298334,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222868',4298335,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','222979',4300344,'2744','415',222303.47,223327.74,1024.27,166956.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','222979',4300345,'2745','415',353841.81,355999.55,2157.74,351711.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','222979',4300346,'2746','415',205168.81,206003.54,834.73,136060.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','222979',4300347,'2747','415',362528.38,365643.78,3115.40,507810.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','222979',4300348,'2748','415',292095.51,293361.75,1266.24,206397.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','222979',4300349,'2749','415',172770.31,174551.16,1780.85,290278.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','222979',4300350,'2750','415',321303.29,322822.27,1518.98,247593.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','222979',4300351,'2751','415',59891.50,59891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222979',4300352,'2752','415',351844.26,353748.21,1903.95,310343.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','222979',4300353,'2753','415',61608.68,61608.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','222979',4300354,'2754','415',338623.77,340479.43,1855.66,302472.58,0.00,0.00,0.00,0.00,0.00),('1','185','936','222979',4300355,'2755','415',64002.99,64456.36,453.37,73899.31,0.00,0.00,0.00,0.00,0.00),('1','185','937','222979',4300356,'2756','416',137731.55,138189.09,457.54,132686.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','222979',4300357,'2757','416',106607.34,107087.52,480.18,139252.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','222979',4300358,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','222979',4300359,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223090',4302419,'2744','415',223327.74,223327.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223090',4302420,'2745','415',355999.55,358100.01,2100.46,342374.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','223090',4302421,'2746','415',206003.54,206248.35,244.81,39904.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','223090',4302422,'2747','415',365643.78,368020.62,2376.84,387424.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','223090',4302423,'2748','415',293361.75,293361.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223090',4302424,'2749','415',174551.16,175538.49,987.33,160934.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','223090',4302425,'2750','415',322822.27,324450.14,1627.87,265342.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','223090',4302426,'2751','415',59891.50,59891.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223090',4302427,'2752','415',353748.21,355799.88,2051.67,334422.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','223090',4302428,'2753','415',61608.68,61625.59,16.91,2756.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','223090',4302429,'2754','415',340479.43,342552.14,2072.71,337851.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','223090',4302430,'2755','415',64456.36,64939.32,482.96,78722.48,0.00,0.00,0.00,0.00,0.00),('1','185','937','223090',4302431,'2756','416',138189.09,138514.80,325.71,94455.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','223090',4302432,'2757','416',107087.52,108146.48,1058.96,307098.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','223090',4302433,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223090',4302434,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223220',4304257,'2744','415',223327.74,224895.62,1567.88,255564.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','223220',4304258,'2745','415',358100.01,359798.07,1698.06,276783.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','223220',4304259,'2746','415',206248.35,207217.19,968.84,157920.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','223220',4304260,'2747','415',368020.62,370042.42,2021.80,329553.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','223220',4304261,'2748','415',293361.75,294940.83,1579.08,257390.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','223220',4304262,'2749','415',175538.49,176566.38,1027.89,167546.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','223220',4304263,'2750','415',324450.14,325704.99,1254.85,204540.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','223220',4304264,'2751','415',59891.50,59966.96,75.46,12299.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','223220',4304265,'2752','415',355799.88,357614.24,1814.36,295740.68,0.00,0.00,0.00,0.00,0.00),('1','185','936','223220',4304266,'2753','415',61625.59,61625.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223220',4304267,'2754','415',342552.14,344092.58,1540.44,251091.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','223220',4304268,'2755','415',64939.32,65748.45,809.13,131888.19,0.00,0.00,0.00,0.00,0.00),('1','185','937','223220',4304269,'2756','416',138514.80,139242.73,727.93,211099.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','223220',4304270,'2757','416',108146.48,108987.86,841.38,244000.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','223220',4304271,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223220',4304272,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223318',4305854,'2744','415',224895.62,224895.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223318',4305855,'2745','415',359798.07,362107.61,2309.54,376455.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','223318',4305856,'2746','415',207217.19,207217.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223318',4305857,'2747','415',370042.42,372073.10,2030.68,331000.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','223318',4305858,'2748','415',294940.83,296515.19,1574.36,256620.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','223318',4305859,'2749','415',176566.38,177550.16,983.78,160356.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','223318',4305860,'2750','415',325704.99,328136.57,2431.58,396347.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','223318',4305861,'2751','415',59966.96,59966.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223318',4305862,'2752','415',357614.24,358676.18,1061.94,173096.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','223318',4305863,'2753','415',61625.59,61625.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223318',4305864,'2754','415',344092.58,346086.65,1994.07,325033.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','223318',4305865,'2755','415',65748.45,65748.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','223318',4305866,'2756','416',139242.73,139834.70,591.97,171671.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','223318',4305867,'2757','416',108987.86,109393.37,405.51,117597.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','223318',4305868,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223318',4305869,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223459',4308540,'2744','415',224895.62,226441.03,1545.41,251901.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','223459',4308541,'2745','415',362107.61,363918.29,1810.68,295140.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','223459',4308542,'2746','415',207217.19,208990.46,1773.27,289043.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','223459',4308543,'2747','415',372073.10,373844.18,1771.08,288686.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','223459',4308544,'2748','415',296515.19,298033.35,1518.16,247460.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','223459',4308545,'2749','415',177550.16,178600.15,1049.99,171148.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','223459',4308546,'2750','415',328136.57,329451.10,1314.53,214268.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','223459',4308547,'2751','415',59966.96,60185.49,218.53,35620.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','223459',4308548,'2752','415',358676.18,360141.88,1465.70,238909.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','223459',4308549,'2753','415',61625.59,61823.71,198.12,32293.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','223459',4308550,'2754','415',346086.65,347848.28,1761.63,287145.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','223459',4308551,'2755','415',65748.45,65748.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','223459',4308552,'2756','416',139834.70,140920.54,1085.84,314893.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','223459',4308553,'2757','416',109393.37,110542.53,1149.16,333256.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','223459',4308554,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223459',4308555,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223725',4313431,'2744','415',226441.03,226441.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223725',4313432,'2745','415',363918.29,366385.78,2467.49,402200.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','223725',4313433,'2746','415',208990.46,208990.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223725',4313434,'2747','415',373844.18,376154.38,2310.20,376562.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','223725',4313435,'2748','415',298033.35,298033.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223725',4313436,'2749','415',178600.15,180016.36,1416.21,230842.23,0.00,0.00,0.00,0.00,0.00),('1','185','936','223725',4313437,'2750','415',329451.10,331101.11,1650.01,268951.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','223725',4313438,'2751','415',60185.49,60775.53,590.04,96176.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','223725',4313439,'2752','415',360141.88,362285.78,2143.90,349455.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','223725',4313440,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223725',4313441,'2754','415',347848.28,349641.26,1792.98,292255.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','223725',4313442,'2755','415',65748.45,65748.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','223725',4313443,'2756','416',140920.54,141933.07,1012.53,293633.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','223725',4313444,'2757','416',110542.53,110670.05,127.52,36980.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','223725',4313445,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223725',4313446,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223760',4314227,'2744','415',226441.03,227382.98,931.95,151907.85,0.00,0.00,10.00,0.00,0.00),('1','185','935','223760',4314228,'2745','415',366385.78,367957.91,1562.13,254627.19,0.00,0.00,10.00,0.00,0.00),('1','185','935','223760',4314229,'2746','415',208990.46,209000.46,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','935','223760',4314230,'2747','415',376154.38,378893.10,2728.72,444781.36,0.00,0.00,10.00,0.00,0.00),('1','185','935','223760',4314231,'2748','415',298033.35,299994.77,1951.42,318081.46,0.00,0.00,10.00,0.00,0.00),('1','185','935','223760',4314232,'2749','415',180016.36,181475.63,1449.27,236231.01,0.00,0.00,10.00,0.00,0.00),('1','185','936','223760',4314233,'2750','415',331101.11,332824.69,1713.58,279313.54,0.00,0.00,10.00,0.00,0.00),('1','185','936','223760',4314234,'2751','415',60775.53,60785.53,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','223760',4314235,'2752','415',362285.78,364664.90,2369.12,386166.56,0.00,0.00,10.00,0.00,0.00),('1','185','936','223760',4314236,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223760',4314237,'2754','415',349641.26,351443.43,1792.17,292123.71,0.00,0.00,10.00,0.00,0.00),('1','185','936','223760',4314238,'2755','415',65748.45,66196.81,438.36,71452.68,0.00,0.00,10.00,0.00,0.00),('1','185','937','223760',4314239,'2756','416',141933.07,142365.41,432.34,125378.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','223760',4314240,'2757','416',110670.05,110956.77,286.72,83148.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','223760',4314241,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223760',4314242,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','223842',4315935,'2744','415',227382.98,228679.66,1296.68,211358.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','223842',4315936,'2745','415',367957.91,369595.17,1637.26,266873.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','223842',4315937,'2746','415',209000.46,211419.86,2419.40,394362.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','223842',4315938,'2747','415',378893.10,380371.87,1478.77,241039.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','223842',4315939,'2748','415',299994.77,301602.55,1607.78,262068.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','223842',4315940,'2749','415',181475.63,182829.42,1353.79,220667.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','223842',4315941,'2750','415',332824.69,334303.82,1479.13,241098.19,0.00,0.00,0.00,0.00,0.00),('1','185','936','223842',4315942,'2751','415',60785.53,60785.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223842',4315943,'2752','415',364664.90,366583.92,1919.02,312800.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','223842',4315944,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','223842',4315945,'2754','415',351443.43,353523.51,2080.08,339053.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','223842',4315946,'2755','415',66196.81,66196.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','223842',4315947,'2756','416',142365.41,142365.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','223842',4315948,'2757','416',110956.77,110956.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223842',4315949,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','223842',4315950,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224057',4319636,'2744','415',228679.66,230320.00,1640.34,267375.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','224057',4319637,'2745','415',369595.17,371453.43,1858.26,302896.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','224057',4319638,'2746','415',211419.86,212871.48,1451.62,236614.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','224057',4319639,'2747','415',380371.87,381739.17,1367.30,222869.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','224057',4319640,'2748','415',301602.55,303356.64,1754.09,285916.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','224057',4319641,'2749','415',182829.42,183378.43,549.01,89488.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','224057',4319642,'2750','415',334303.82,337163.41,2859.59,466113.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','224057',4319643,'2751','415',60785.53,60785.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224057',4319644,'2752','415',366583.92,368450.18,1866.26,304200.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','224057',4319645,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224057',4319646,'2754','415',353523.51,355821.94,2298.43,374644.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','224057',4319647,'2755','415',66196.81,66196.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224057',4319648,'2756','416',142365.41,142365.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224057',4319649,'2757','416',110956.77,110956.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224057',4319650,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224057',4319651,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224140',4320789,'2744','415',230320.00,231777.47,1457.47,237567.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','224140',4320790,'2745','415',371453.43,373248.70,1795.27,292629.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','224140',4320791,'2746','415',212871.48,213771.86,900.38,146761.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','224140',4320792,'2747','415',381739.17,383786.34,2047.17,333688.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','224140',4320793,'2748','415',303356.64,305198.82,1842.18,300275.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','224140',4320794,'2749','415',183378.43,183594.02,215.59,35141.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','224140',4320795,'2750','415',337163.41,338711.60,1548.19,252354.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','224140',4320796,'2751','415',60785.53,60785.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224140',4320797,'2752','415',368450.18,370554.51,2104.33,343005.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','224140',4320798,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224140',4320799,'2754','415',355821.94,357215.57,1393.63,227161.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','224140',4320800,'2755','415',66196.81,66568.01,371.20,60505.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','224140',4320801,'2756','416',142365.41,142365.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224140',4320802,'2757','416',110956.77,110956.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224140',4320803,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224140',4320804,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224145',4320877,'2744','415',231777.47,232000.65,223.18,36378.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','224145',4320878,'2745','415',373248.70,375079.90,1831.20,298485.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','224145',4320879,'2746','415',213771.86,214856.82,1084.96,176848.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','224145',4320880,'2747','415',383786.34,385622.75,1836.41,299334.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','224145',4320881,'2748','415',305198.82,307633.72,2434.90,396888.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','224145',4320882,'2749','415',183594.02,183594.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224145',4320883,'2750','415',338711.60,340625.03,1913.43,311889.09,0.00,0.00,0.00,0.00,0.00),('1','185','936','224145',4320884,'2751','415',60785.53,60865.51,79.98,13036.74,0.00,0.00,0.00,0.00,0.00),('1','185','936','224145',4320885,'2752','415',370554.51,372546.51,1992.00,324696.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224145',4320886,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224145',4320887,'2754','415',357215.57,358884.22,1668.65,271989.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','224145',4320888,'2755','415',66568.01,66568.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224145',4320889,'2756','416',142365.41,142365.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224145',4320890,'2757','416',110956.77,110956.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224145',4320891,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224145',4320892,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224271',4323573,'2744','415',232000.65,232134.36,133.71,21794.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','224271',4323574,'2745','415',375079.90,377304.00,2224.10,362528.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','224271',4323575,'2746','415',214856.82,216458.32,1601.50,261044.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','224271',4323576,'2747','415',385622.75,387690.32,2067.57,337013.91,0.00,0.00,0.00,0.00,0.00),('1','185','935','224271',4323577,'2748','415',307633.72,309029.90,1396.18,227577.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','224271',4323578,'2749','415',183594.02,184843.44,1249.42,203655.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','224271',4323579,'2750','415',340625.03,342899.43,2274.40,370727.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','224271',4323580,'2751','415',60865.51,60865.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224271',4323581,'2752','415',372546.51,374701.08,2154.57,351194.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','224271',4323582,'2753','415',61823.71,61823.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224271',4323583,'2754','415',358884.22,361096.56,2212.34,360611.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','224271',4323584,'2755','415',66568.01,66568.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224271',4323585,'2756','416',142365.41,143394.13,1028.72,298328.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','224271',4323586,'2757','416',110956.77,111425.57,468.80,135952.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224271',4323587,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224271',4323588,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224389',4325307,'2744','415',232134.36,232134.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224389',4325308,'2745','415',377304.00,380317.13,3013.13,491140.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','224389',4325309,'2746','415',216458.32,217272.56,814.24,132721.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','224389',4325310,'2747','415',387690.32,390274.32,2584.00,421192.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224389',4325311,'2748','415',309029.90,311147.64,2117.74,345191.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','224389',4325312,'2749','415',184843.44,185709.92,866.48,141236.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','224389',4325313,'2750','415',342899.43,344714.78,1815.35,295902.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','224389',4325314,'2751','415',60865.51,60865.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224389',4325315,'2752','415',374701.08,376308.29,1607.21,261975.23,0.00,0.00,0.00,0.00,0.00),('1','185','936','224389',4325316,'2753','415',61823.71,62629.67,805.96,131371.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','224389',4325317,'2754','415',361096.56,363171.83,2075.27,338269.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','224389',4325318,'2755','415',66568.01,67826.86,1258.85,205192.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','224389',4325319,'2756','416',143394.13,144456.11,1061.98,307974.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','224389',4325320,'2757','416',111425.57,112049.86,624.29,181044.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','224389',4325321,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224389',4325322,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224457',4326631,'2744','415',232134.36,232134.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224457',4326632,'2745','415',380317.13,382413.48,2096.35,341705.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','224457',4326633,'2746','415',217272.56,218727.40,1454.84,237138.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','224457',4326634,'2747','415',390274.32,392219.55,1945.23,317072.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','224457',4326635,'2748','415',311147.64,313060.55,1912.91,311804.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','224457',4326636,'2749','415',185709.92,185709.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224457',4326637,'2750','415',344714.78,347064.17,2349.39,382950.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','224457',4326638,'2751','415',60865.51,60865.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224457',4326639,'2752','415',376308.29,378195.61,1887.32,307633.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','224457',4326640,'2753','415',62629.67,62629.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224457',4326641,'2754','415',363171.83,365187.54,2015.71,328560.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','224457',4326642,'2755','415',67826.86,68120.60,293.74,47879.62,0.00,0.00,0.00,0.00,0.00),('1','185','937','224457',4326643,'2756','416',144456.11,145718.14,1262.03,365988.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','224457',4326644,'2757','416',112049.86,113003.79,953.93,276639.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','224457',4326645,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224457',4326646,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224585',4328743,'2744','415',232134.36,233126.29,991.93,161684.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','224585',4328744,'2745','415',382413.48,384122.87,1709.39,278630.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','224585',4328745,'2746','415',218727.40,219212.53,485.13,79076.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','224585',4328746,'2747','415',392219.55,394420.56,2201.01,358764.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','224585',4328747,'2748','415',313060.55,313402.72,342.17,55773.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','224585',4328748,'2749','415',185709.92,187396.22,1686.30,274866.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','224585',4328749,'2750','415',347064.17,349693.21,2629.04,428533.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','224585',4328750,'2751','415',60865.51,60865.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224585',4328751,'2752','415',378195.61,380732.46,2536.85,413506.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','224585',4328752,'2753','415',62629.67,62629.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224585',4328753,'2754','415',365187.54,367543.02,2355.48,383943.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','224585',4328754,'2755','415',68120.60,68120.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224585',4328755,'2756','416',145718.14,146191.26,473.12,137204.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','224585',4328756,'2757','416',113003.79,114048.99,1045.20,303108.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224585',4328757,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224585',4328758,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224615',4329300,'2744','415',233126.29,233881.81,755.52,123149.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','224615',4329301,'2745','415',384122.87,385751.40,1628.53,265450.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','224615',4329302,'2746','415',219212.53,220304.82,1092.29,178043.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','224615',4329303,'2747','415',394420.56,396612.27,2191.71,357248.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','224615',4329304,'2748','415',313402.72,315075.28,1672.56,272627.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','224615',4329305,'2749','415',187396.22,188642.61,1246.39,203161.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','224615',4329306,'2750','415',349693.21,350997.99,1304.78,212679.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','224615',4329307,'2751','415',60865.51,60865.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224615',4329308,'2752','415',380732.46,382090.08,1357.62,221292.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','224615',4329309,'2753','415',62629.67,62629.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224615',4329310,'2754','415',367543.02,369132.03,1589.01,259008.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','224615',4329311,'2755','415',68120.60,68120.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224615',4329312,'2756','416',146191.26,146870.46,679.20,196968.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224615',4329313,'2757','416',114048.99,114752.40,703.41,203988.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','224615',4329314,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224615',4329315,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224832',4332996,'2744','415',233881.81,234497.30,615.49,100324.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','224832',4332997,'2745','415',385751.40,387858.06,2106.66,343385.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','224832',4332998,'2746','415',220304.82,220304.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224832',4332999,'2747','415',396612.27,399348.00,2735.73,445923.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','224832',4333000,'2748','415',315075.28,317289.51,2214.23,360919.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','224832',4333001,'2749','415',188642.61,188642.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224832',4333002,'2750','415',350997.99,352925.17,1927.18,314130.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','224832',4333003,'2751','415',60865.51,61269.14,403.63,65791.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','224832',4333004,'2752','415',382090.08,384543.61,2453.53,399925.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','224832',4333005,'2753','415',62629.67,62629.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224832',4333006,'2754','415',369132.03,371737.35,2605.32,424667.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','224832',4333007,'2755','415',68120.60,68120.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224832',4333008,'2756','416',146870.46,147236.64,366.18,106192.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','224832',4333009,'2757','416',114752.40,116301.71,1549.31,449299.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','224832',4333010,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224832',4333011,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','224949',4335262,'2744','415',234497.30,235767.15,1269.85,206985.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','224949',4335263,'2745','415',387858.06,389762.92,1904.86,310492.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','224949',4335264,'2746','415',220304.82,220789.01,484.19,78922.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','224949',4335265,'2747','415',399348.00,400816.42,1468.42,239352.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','224949',4335266,'2748','415',317289.51,318733.27,1443.76,235332.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','224949',4335267,'2749','415',188642.61,189683.92,1041.31,169733.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','224949',4335268,'2750','415',352925.17,354616.65,1691.48,275711.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','224949',4335269,'2751','415',61269.14,61269.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224949',4335270,'2752','415',384543.61,386315.84,1772.23,288873.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','224949',4335271,'2753','415',62629.67,62629.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','224949',4335272,'2754','415',371737.35,373403.15,1665.80,271525.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','224949',4335273,'2755','415',68120.60,68120.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','224949',4335274,'2756','416',147236.64,147752.51,515.87,149602.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','224949',4335275,'2757','416',116301.71,116643.76,342.05,99194.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','224949',4335276,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','224949',4335277,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225102',4337998,'2744','415',235767.15,236188.91,421.76,68746.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','225102',4337999,'2745','415',389762.92,391480.60,1717.68,279981.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','225102',4338000,'2746','415',220789.01,221956.73,1167.72,190338.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','225102',4338001,'2747','415',400816.42,402019.07,1202.65,196031.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','225102',4338002,'2748','415',318733.27,320321.72,1588.45,258917.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','225102',4338003,'2749','415',189683.92,191036.81,1352.89,220521.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','225102',4338004,'2750','415',354616.65,356569.20,1952.55,318265.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','225102',4338005,'2751','415',61269.14,62342.04,1072.90,174882.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','225102',4338006,'2752','415',386315.84,388727.62,2411.78,393120.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','225102',4338007,'2753','415',62629.67,62629.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225102',4338008,'2754','415',373403.15,374885.65,1482.50,241647.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','225102',4338009,'2755','415',68120.60,69288.27,1167.67,190330.21,0.00,0.00,0.00,0.00,0.00),('1','185','937','225102',4338010,'2756','416',147752.51,149498.48,1745.97,506331.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','225102',4338011,'2757','416',116643.76,117780.83,1137.07,329750.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','225102',4338012,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225102',4338013,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225167',4339245,'2744','415',236188.91,236644.02,445.11,72552.93,0.00,0.00,10.00,0.00,0.00),('1','185','935','225167',4339246,'2745','415',391480.60,393069.88,1579.28,257422.64,0.00,0.00,10.00,0.00,0.00),('1','185','935','225167',4339247,'2746','415',221956.73,222643.26,676.53,110274.39,0.00,0.00,10.00,0.00,0.00),('1','185','935','225167',4339248,'2747','415',402019.07,404379.55,2340.48,381498.24,0.00,0.00,20.00,0.00,0.00),('1','185','935','225167',4339249,'2748','415',320321.72,322135.57,1803.85,294027.55,0.00,0.00,10.00,0.00,0.00),('1','185','935','225167',4339250,'2749','415',191036.81,192162.21,1115.40,181810.20,0.00,0.00,10.00,0.00,0.00),('1','185','936','225167',4339251,'2750','415',356569.20,358703.95,2124.75,346334.25,0.00,0.00,10.00,0.00,0.00),('1','185','936','225167',4339252,'2751','415',62342.04,62417.25,65.21,10629.23,0.00,0.00,10.00,0.00,0.00),('1','185','936','225167',4339253,'2752','415',388727.62,390631.73,1894.11,308739.93,0.00,0.00,10.00,0.00,0.00),('1','185','936','225167',4339254,'2753','415',62629.67,62639.67,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','225167',4339255,'2754','415',374885.65,376029.83,1134.18,184871.34,0.00,0.00,10.00,0.00,0.00),('1','185','936','225167',4339256,'2755','415',69288.27,69298.27,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','937','225167',4339257,'2756','416',149498.48,150220.80,712.32,206572.80,0.00,0.00,10.00,0.00,0.00),('1','185','937','225167',4339258,'2757','416',117780.83,123553.25,5762.42,1671101.80,0.00,0.00,10.00,0.00,0.00),('1','185','938','225167',4339259,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225167',4339260,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225343',4342244,'2744','415',236644.02,238548.40,1904.38,310413.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','225343',4342245,'2745','415',393069.88,395067.70,1997.82,325644.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','225343',4342246,'2746','415',222643.26,223778.98,1135.72,185122.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','225343',4342247,'2747','415',404379.55,406531.49,2151.94,350766.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','225343',4342248,'2748','415',322135.57,324210.02,2074.45,338135.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','225343',4342249,'2749','415',192162.21,192738.78,576.57,93980.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','225343',4342250,'2750','415',358703.95,361056.85,2352.90,383522.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','225343',4342251,'2751','415',62417.25,62417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225343',4342252,'2752','415',390631.73,392441.65,1809.92,295016.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','225343',4342253,'2753','415',62639.67,62639.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225343',4342254,'2754','415',376029.83,378667.11,2637.28,429876.64,0.00,0.00,0.00,0.00,0.00),('1','185','936','225343',4342255,'2755','415',69298.27,69298.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','225343',4342256,'2756','416',150220.80,150954.59,733.79,216468.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','225343',4342257,'2757','416',123553.25,124387.26,834.01,246032.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','225343',4342258,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225343',4342259,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225421',4344100,'2744','415',238548.40,238842.28,293.88,47902.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','225421',4344101,'2745','415',395067.70,397193.36,2125.66,346482.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','225421',4344102,'2746','415',223778.98,225028.88,1249.90,203733.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','225421',4344103,'2747','415',406531.49,408495.14,1963.65,320074.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','225421',4344104,'2748','415',324210.02,326223.37,2013.35,328176.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','225421',4344105,'2749','415',192738.78,193013.39,274.61,44761.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','225421',4344106,'2750','415',361056.85,362503.40,1446.55,235787.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','225421',4344107,'2751','415',62417.25,62417.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225421',4344108,'2752','415',392441.65,393988.73,1547.08,252174.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','225421',4344109,'2753','415',62639.67,62705.94,66.27,10802.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','225421',4344110,'2754','415',378667.11,379977.23,1310.12,213549.56,0.00,0.00,0.00,0.00,0.00),('1','185','936','225421',4344111,'2755','415',69298.27,69877.08,578.81,94346.03,0.00,0.00,0.00,0.00,0.00),('1','185','937','225421',4344112,'2756','416',150954.59,151725.52,770.93,227424.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','225421',4344113,'2757','416',124387.26,126320.14,1932.88,570199.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','225421',4344114,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225421',4344115,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225536',4345944,'2744','415',238842.28,240001.79,1159.51,189000.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','225536',4345945,'2745','415',397193.36,399583.43,2390.07,389581.41,0.00,0.00,0.00,0.00,0.00),('1','185','935','225536',4345946,'2746','415',225028.88,226200.48,1171.60,190970.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','225536',4345947,'2747','415',408495.14,410089.91,1594.77,259947.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','225536',4345948,'2748','415',326223.37,328062.16,1838.79,299722.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','225536',4345949,'2749','415',193013.39,193571.84,558.45,91027.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','225536',4345950,'2750','415',362503.40,364518.84,2015.44,328516.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','225536',4345951,'2751','415',62417.25,63143.55,726.30,118386.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','225536',4345952,'2752','415',393988.73,396466.17,2477.44,403822.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','225536',4345953,'2753','415',62705.94,62705.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225536',4345954,'2754','415',379977.23,381436.06,1458.83,237789.29,0.00,0.00,0.00,0.00,0.00),('1','185','936','225536',4345955,'2755','415',69877.08,71072.26,1195.18,194814.34,0.00,0.00,0.00,0.00,0.00),('1','185','937','225536',4345956,'2756','416',151725.52,153056.09,1330.57,392518.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','225536',4345957,'2757','416',126320.14,126707.18,387.04,114176.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','225536',4345958,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225536',4345959,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225614',4347546,'2744','415',240001.79,241591.50,1589.71,259122.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','225614',4347547,'2745','415',399583.43,401058.72,1475.29,240472.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','225614',4347548,'2746','415',226200.48,226200.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225614',4347549,'2747','415',410089.91,412236.68,2146.77,349923.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','225614',4347550,'2748','415',328062.16,329775.75,1713.59,279315.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','225614',4347551,'2749','415',193571.84,194400.00,828.16,134990.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','225614',4347552,'2750','415',364518.84,365854.51,1335.67,217714.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','225614',4347553,'2751','415',63143.55,63932.84,789.29,128654.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','225614',4347554,'2752','415',396466.17,398469.76,2003.59,326585.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','225614',4347555,'2753','415',62705.94,62705.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225614',4347556,'2754','415',381436.06,383067.56,1631.50,265934.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','225614',4347557,'2755','415',71072.26,71179.60,107.34,17496.42,0.00,0.00,0.00,0.00,0.00),('1','185','937','225614',4347558,'2756','416',153056.09,153569.86,513.77,151562.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','225614',4347559,'2757','416',126707.18,127262.27,555.09,163751.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','225614',4347560,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225614',4347561,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225751',4349411,'2744','415',241591.50,242958.80,1367.30,222869.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','225751',4349412,'2745','415',401058.72,402536.32,1477.60,240848.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','225751',4349413,'2746','415',226200.48,227487.18,1286.70,209732.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','225751',4349414,'2747','415',412236.68,413852.87,1616.19,263438.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','225751',4349415,'2748','415',329775.75,331553.37,1777.62,289752.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','225751',4349416,'2749','415',194400.00,195487.52,1087.52,177265.76,0.00,0.00,0.00,0.00,0.00),('1','185','936','225751',4349417,'2750','415',365854.51,367424.19,1569.68,255857.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','225751',4349418,'2751','415',63932.84,64814.86,882.02,143769.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','225751',4349419,'2752','415',398469.76,400031.54,1561.78,254570.14,0.00,0.00,0.00,0.00,0.00),('1','185','936','225751',4349420,'2753','415',62705.94,63358.16,652.22,106311.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','225751',4349421,'2754','415',383067.56,384615.05,1547.49,252240.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','225751',4349422,'2755','415',71179.60,71607.44,427.84,69737.92,0.00,0.00,0.00,0.00,0.00),('1','185','937','225751',4349423,'2756','416',153569.86,154633.05,1063.19,313641.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','225751',4349424,'2757','416',127262.27,127523.83,261.56,77160.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','225751',4349425,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225751',4349426,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','225787',4350137,'2744','415',242958.80,243497.82,539.02,87860.26,0.00,0.00,0.00,0.00,0.00),('1','185','935','225787',4350138,'2745','415',402536.32,404023.07,1486.75,242340.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','225787',4350139,'2746','415',227487.18,228092.60,605.42,98683.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','225787',4350140,'2747','415',413852.87,416008.63,2155.76,351388.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','225787',4350141,'2748','415',331553.37,333418.73,1865.36,304053.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','225787',4350142,'2749','415',195487.52,196431.81,944.29,153919.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','225787',4350143,'2750','415',367424.19,369296.79,1872.60,305233.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','225787',4350144,'2751','415',64814.86,64814.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225787',4350145,'2752','415',400031.54,401799.02,1767.48,288099.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','225787',4350146,'2753','415',63358.16,63358.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','225787',4350147,'2754','415',384615.05,386803.45,2188.40,356709.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','225787',4350148,'2755','415',71607.44,71607.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','225787',4350149,'2756','416',154633.05,155510.05,877.00,258715.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','225787',4350150,'2757','416',127523.83,128095.13,571.30,168533.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','225787',4350151,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','225787',4350152,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226013',4353973,'2744','415',243497.82,244526.79,1028.97,167722.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','226013',4353974,'2745','415',404023.07,406378.05,2354.98,383861.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','226013',4353975,'2746','415',228092.60,229643.35,1550.75,252772.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','226013',4353976,'2747','415',416008.63,417778.09,1769.46,288421.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','226013',4353977,'2748','415',333418.73,335166.14,1747.41,284827.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','226013',4353978,'2749','415',196431.81,197389.99,958.18,156183.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','226013',4353979,'2750','415',369296.79,370848.05,1551.26,252855.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','226013',4353980,'2751','415',64814.86,65674.50,859.64,140121.32,0.00,0.00,0.00,0.00,0.00),('1','185','936','226013',4353981,'2752','415',401799.02,404083.52,2284.50,372373.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','226013',4353982,'2753','415',63358.16,63358.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226013',4353983,'2754','415',386803.45,388382.76,1579.31,257427.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','226013',4353984,'2755','415',71607.44,71885.05,277.61,45250.43,0.00,0.00,0.00,0.00,0.00),('1','185','937','226013',4353985,'2756','416',155510.05,156323.89,813.84,240082.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','226013',4353986,'2757','416',128095.13,128462.02,366.89,108232.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','226013',4353987,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226013',4353988,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226160',4356921,'2744','415',244526.79,245258.04,731.25,119193.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','226160',4356922,'2745','415',406378.05,408087.33,1709.28,278612.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','226160',4356923,'2746','415',229643.35,230744.77,1101.42,179531.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','226160',4356924,'2747','415',417778.09,419708.89,1930.80,314720.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','226160',4356925,'2748','415',335166.14,337429.00,2262.86,368846.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','226160',4356926,'2749','415',197389.99,198358.41,968.42,157852.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','226160',4356927,'2750','415',370848.05,372363.35,1515.30,246993.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','226160',4356928,'2751','415',65674.50,65674.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226160',4356929,'2752','415',404083.52,405584.07,1500.55,244589.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','226160',4356930,'2753','415',63358.16,63457.58,99.42,16205.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','226160',4356931,'2754','415',388382.76,389451.63,1068.87,174225.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','226160',4356932,'2755','415',71885.05,71885.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226160',4356933,'2756','416',156323.89,157483.48,1159.59,342079.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','226160',4356934,'2757','416',128462.02,129749.56,1287.54,379824.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','226160',4356935,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226160',4356936,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226325',4359800,'2744','415',245258.04,245722.87,454.83,74137.29,0.00,0.00,10.00,0.00,0.00),('1','185','935','226325',4359801,'2745','415',408087.33,410106.82,2009.49,327546.87,0.00,0.00,10.00,0.00,0.00),('1','185','935','226325',4359802,'2746','415',230744.77,231563.92,809.15,131891.45,0.00,0.00,10.00,0.00,0.00),('1','185','935','226325',4359803,'2747','415',419708.89,421378.06,1659.17,270444.71,0.00,0.00,10.00,0.00,0.00),('1','185','935','226325',4359804,'2748','415',337429.00,339406.70,1967.70,320735.10,0.00,0.00,10.00,0.00,0.00),('1','185','935','226325',4359805,'2749','415',198358.41,198705.28,336.87,54909.81,0.00,0.00,10.00,0.00,0.00),('1','185','936','226325',4359806,'2750','415',372363.35,374201.83,1828.48,298042.24,0.00,0.00,10.00,0.00,0.00),('1','185','936','226325',4359807,'2751','415',65674.50,66158.32,473.82,77232.66,0.00,0.00,10.00,0.00,0.00),('1','185','936','226325',4359808,'2752','415',405584.07,407398.04,1803.97,294047.11,0.00,0.00,10.00,0.00,0.00),('1','185','936','226325',4359809,'2753','415',63457.58,63457.58,-10.00,-1630.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','226325',4359810,'2754','415',389451.63,391377.76,1916.13,312329.19,0.00,0.00,10.00,0.00,0.00),('1','185','936','226325',4359811,'2755','415',71885.05,71905.48,7.73,1259.99,0.00,0.00,12.70,0.00,0.00),('1','185','937','226325',4359812,'2756','416',157483.48,158601.70,1118.22,335466.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226325',4359813,'2757','416',129749.56,130767.66,1018.10,305430.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226325',4359814,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226325',4359815,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226338',4360045,'2744','415',245722.87,246267.09,544.22,88707.86,0.00,0.00,0.00,0.00,0.00),('1','185','935','226338',4360046,'2745','415',410106.82,411409.68,1302.86,212366.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','226338',4360047,'2746','415',231563.92,232427.11,863.19,140699.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','226338',4360048,'2747','415',421378.06,422898.02,1519.96,247753.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','226338',4360049,'2748','415',339406.70,339406.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226338',4360050,'2749','415',198705.28,199952.60,1247.32,203313.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','226338',4360051,'2750','415',374201.83,375420.56,1218.73,198652.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','226338',4360052,'2751','415',66158.32,67149.74,991.42,161601.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','226338',4360053,'2752','415',407398.04,409384.85,1986.81,323850.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','226338',4360054,'2753','415',63457.58,63457.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226338',4360055,'2754','415',391377.76,393569.63,2191.87,357274.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','226338',4360056,'2755','415',71905.48,71905.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226338',4360057,'2756','416',158601.70,159097.71,496.01,148803.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226338',4360058,'2757','416',130767.66,130858.49,90.83,27249.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226338',4360059,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226338',4360060,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226549',4363641,'2744','415',246267.09,248012.38,1745.29,284482.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','226549',4363642,'2745','415',411409.68,413565.26,2155.58,351359.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','226549',4363643,'2746','415',232427.11,233490.16,1063.05,173277.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','226549',4363644,'2747','415',422898.02,424854.65,1956.63,318930.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','226549',4363645,'2748','415',339406.70,340701.65,1294.95,211076.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','226549',4363646,'2749','415',199952.60,200644.11,691.51,112716.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','226549',4363647,'2750','415',375420.56,377341.75,1921.19,313153.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','226549',4363648,'2751','415',67149.74,67590.41,440.67,71829.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','226549',4363649,'2752','415',409384.85,411105.48,1720.63,280462.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','226549',4363650,'2753','415',63457.58,64162.76,705.18,114944.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','226549',4363651,'2754','415',393569.63,395114.50,1544.87,251813.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','226549',4363652,'2755','415',71905.48,72413.67,508.19,82834.97,0.00,0.00,0.00,0.00,0.00),('1','185','937','226549',4363653,'2756','416',159097.71,159688.41,590.70,177210.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226549',4363654,'2757','416',130858.49,131123.55,265.06,79518.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226549',4363655,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226549',4363656,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226684',4366470,'2744','415',248012.38,248871.20,858.82,139987.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','226684',4366471,'2745','415',413565.26,415310.98,1745.72,284552.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','226684',4366472,'2746','415',233490.16,233903.14,412.98,67315.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','226684',4366473,'2747','415',424854.65,426078.48,1223.83,199484.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','226684',4366474,'2748','415',340701.65,341076.00,374.35,61019.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','226684',4366475,'2749','415',200644.11,202256.59,1612.48,262834.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','226684',4366476,'2750','415',377341.75,379100.46,1758.71,286669.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','226684',4366477,'2751','415',67590.41,67590.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226684',4366478,'2752','415',411105.48,413202.96,2097.48,341889.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','226684',4366479,'2753','415',64162.76,64162.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226684',4366480,'2754','415',395114.50,396898.45,1783.95,290783.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','226684',4366481,'2755','415',72413.67,72413.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226684',4366482,'2756','416',159688.41,160088.59,400.18,120054.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226684',4366483,'2757','416',131123.55,131734.55,611.00,183300.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226684',4366484,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226684',4366485,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226800',4368316,'2744','415',248871.20,250921.86,2050.66,334257.58,0.00,0.00,0.00,0.00,0.00),('1','185','935','226800',4368317,'2745','415',415310.98,415945.23,634.25,103382.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','226800',4368318,'2746','415',233903.14,234917.91,1014.77,165407.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','226800',4368319,'2747','415',426078.48,428365.91,2287.43,372851.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','226800',4368320,'2748','415',341076.00,342892.96,1816.96,296164.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','226800',4368321,'2749','415',202256.59,202701.06,444.47,72448.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','226800',4368322,'2750','415',379100.46,380990.83,1890.37,308130.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','226800',4368323,'2751','415',67590.41,67632.92,42.51,6929.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','226800',4368324,'2752','415',413202.96,414801.55,1598.59,260570.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','226800',4368325,'2753','415',64162.76,64898.87,736.11,119985.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','226800',4368326,'2754','415',396898.45,398636.39,1737.94,283284.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','226800',4368327,'2755','415',72413.67,73628.26,1214.59,197978.17,0.00,0.00,0.00,0.00,0.00),('1','185','937','226800',4368328,'2756','416',160088.59,160617.25,528.66,158598.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226800',4368329,'2757','416',131734.55,131779.55,45.00,13500.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226800',4368330,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226800',4368331,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','226885',4370050,'2744','415',250921.86,251535.58,613.72,100036.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','226885',4370051,'2745','415',415945.23,416781.43,836.20,136300.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','226885',4370052,'2746','415',234917.91,235527.75,609.84,99403.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','226885',4370053,'2747','415',428365.91,430374.22,2008.31,327354.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','226885',4370054,'2748','415',342892.96,344480.99,1588.03,258848.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','226885',4370055,'2749','415',202701.06,203087.77,386.71,63033.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','226885',4370056,'2750','415',380990.83,383246.85,2256.02,367731.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','226885',4370057,'2751','415',67632.92,67632.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226885',4370058,'2752','415',414801.55,417136.88,2335.33,380658.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','226885',4370059,'2753','415',64898.87,64898.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','226885',4370060,'2754','415',398636.39,400288.18,1651.79,269241.77,0.00,0.00,0.00,0.00,0.00),('1','185','936','226885',4370061,'2755','415',73628.26,73628.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226885',4370062,'2756','416',160617.25,161284.39,667.14,200142.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','226885',4370063,'2757','416',131779.55,133574.49,1794.94,538482.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226885',4370064,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','226885',4370065,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227017',4372157,'2744','415',251535.58,253316.30,1780.72,290257.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','227017',4372158,'2745','415',416781.43,419158.07,2376.64,387392.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','227017',4372159,'2746','415',235527.75,236606.22,1078.47,175790.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','227017',4372160,'2747','415',430374.22,432050.74,1676.52,273272.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','227017',4372161,'2748','415',344480.99,344569.02,88.03,14348.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','227017',4372162,'2749','415',203087.77,204718.39,1630.62,265791.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','227017',4372163,'2750','415',383246.85,384889.35,1642.50,267727.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','227017',4372164,'2751','415',67632.92,67632.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227017',4372165,'2752','415',417136.88,419338.74,2201.86,358903.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','227017',4372166,'2753','415',64898.87,64898.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227017',4372167,'2754','415',400288.18,402066.86,1778.68,289924.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','227017',4372168,'2755','415',73628.26,74173.56,545.30,88883.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','227017',4372169,'2756','416',161284.39,162011.45,727.06,218118.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227017',4372170,'2757','416',133574.49,133822.82,248.33,74499.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227017',4372171,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227017',4372172,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227103',4373729,'2744','415',253316.30,254782.77,1466.47,239034.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','227103',4373730,'2745','415',419158.07,420685.30,1527.23,248938.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','227103',4373731,'2746','415',236606.22,236649.18,42.96,7002.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','227103',4373732,'2747','415',432050.74,433597.41,1546.67,252107.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','227103',4373733,'2748','415',344569.02,346331.49,1762.47,287282.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','227103',4373734,'2749','415',204718.39,205552.34,833.95,135933.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','227103',4373735,'2750','415',384889.35,386814.52,1925.17,313802.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','227103',4373736,'2751','415',67632.92,67632.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227103',4373737,'2752','415',419338.74,420984.30,1645.56,268226.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','227103',4373738,'2753','415',64898.87,64898.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227103',4373739,'2754','415',402066.86,404228.09,2161.23,352280.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','227103',4373740,'2755','415',74173.56,74173.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227103',4373741,'2756','416',162011.45,162519.40,507.95,152385.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227103',4373742,'2757','416',133822.82,134162.82,340.00,102000.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227103',4373743,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227103',4373744,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227400',4378852,'2744','415',254782.77,256175.50,1392.73,227014.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','227400',4378853,'2745','415',420685.30,421613.65,928.35,151321.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','227400',4378854,'2746','415',236649.18,237616.61,967.43,157691.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','227400',4378855,'2747','415',433597.41,435121.22,1523.81,248381.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','227400',4378856,'2748','415',346331.49,347204.63,873.14,142321.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','227400',4378857,'2749','415',205552.34,206227.03,674.69,109974.47,0.00,0.00,0.00,0.00,0.00),('1','185','936','227400',4378858,'2750','415',386814.52,388914.00,2099.48,342215.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','227400',4378859,'2751','415',67632.92,68008.52,375.60,61222.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','227400',4378860,'2752','415',420984.30,423255.47,2271.17,370200.71,0.00,0.00,0.00,0.00,0.00),('1','185','936','227400',4378861,'2753','415',64898.87,66123.68,1224.81,199644.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','227400',4378862,'2754','415',404228.09,405971.46,1743.37,284169.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','227400',4378863,'2755','415',74173.56,75244.91,1071.35,174630.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','227400',4378864,'2756','416',162519.40,163397.40,878.00,263400.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227400',4378865,'2757','416',134162.82,134694.18,531.36,159408.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227400',4378866,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227400',4378867,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227413',4379121,'2744','415',256175.50,256175.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227413',4379122,'2745','415',421613.65,421613.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227413',4379123,'2746','415',237616.61,237616.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227413',4379124,'2747','415',435121.22,435121.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227413',4379125,'2748','415',347204.63,347204.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227413',4379126,'2749','415',206227.03,206227.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227413',4379127,'2750','415',388914.00,390856.29,1942.29,316593.27,0.00,0.00,0.00,0.00,0.00),('1','185','936','227413',4379128,'2751','415',68008.52,70047.87,2039.35,332414.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','227413',4379129,'2752','415',423255.47,425926.27,2670.80,435340.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','227413',4379130,'2753','415',66123.68,68144.10,2020.42,329328.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','227413',4379131,'2754','415',405971.46,407927.71,1956.25,318868.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','227413',4379132,'2755','415',75244.91,76636.11,1391.20,226765.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','227413',4379133,'2756','416',163397.40,164193.85,796.45,238935.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227413',4379134,'2757','416',134694.18,135319.04,624.86,187458.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227413',4379135,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227413',4379136,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227433',4379622,'2744','415',256175.50,256464.00,288.50,47025.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','227433',4379623,'2745','415',421613.65,423032.33,1418.68,231244.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','227433',4379624,'2746','415',237616.61,238153.77,537.16,87557.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','227433',4379625,'2747','415',435121.22,436458.35,1337.13,217952.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','227433',4379626,'2748','415',347204.63,347906.76,702.13,114447.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','227433',4379627,'2749','415',206227.03,207086.99,859.96,140173.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','227433',4379628,'2750','415',390856.29,393131.90,2275.61,370924.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','227433',4379629,'2751','415',70047.87,71923.97,1876.10,305804.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','227433',4379630,'2752','415',425926.27,428374.74,2448.47,399100.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','227433',4379631,'2753','415',68144.10,69426.63,1282.53,209052.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','227433',4379632,'2754','415',407927.71,410857.33,2929.62,477528.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','227433',4379633,'2755','415',76636.11,77893.05,1256.94,204881.22,0.00,0.00,0.00,0.00,0.00),('1','185','937','227433',4379634,'2756','416',164193.85,165272.05,1078.20,323460.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227433',4379635,'2757','416',135319.04,135748.73,429.69,128907.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227433',4379636,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227433',4379637,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227453',4379994,'2744','415',256464.00,257882.29,1408.29,229551.27,0.00,0.00,10.00,0.00,0.00),('1','185','935','227453',4379995,'2745','415',423032.33,424680.91,1638.58,267088.54,0.00,0.00,10.00,0.00,0.00),('1','185','935','227453',4379996,'2746','415',238153.77,238280.15,116.38,18969.94,0.00,0.00,10.00,0.00,0.00),('1','185','935','227453',4379997,'2747','415',436458.35,438469.56,2001.21,326197.23,0.00,0.00,10.00,0.00,0.00),('1','185','935','227453',4379998,'2748','415',347906.76,349685.55,1768.79,288312.77,0.00,0.00,10.00,0.00,0.00),('1','185','935','227453',4379999,'2749','415',207086.99,207748.43,651.44,106184.72,0.00,0.00,10.00,0.00,0.00),('1','185','936','227453',4380000,'2750','415',393131.90,395275.22,2143.32,349361.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','227453',4380001,'2751','415',71923.97,71933.97,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','227453',4380002,'2752','415',428374.74,430579.98,2205.24,359454.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','227453',4380003,'2753','415',69426.63,69426.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227453',4380004,'2754','415',410857.33,413255.73,2388.40,389309.20,0.00,0.00,10.00,0.00,0.00),('1','185','936','227453',4380005,'2755','415',77893.05,77893.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227453',4380006,'2756','416',165272.05,166777.38,1505.33,451599.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227453',4380007,'2757','416',135748.73,136439.25,690.52,207156.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227453',4380008,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227453',4380009,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227667',4383586,'2744','415',257882.29,257882.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227667',4383587,'2745','415',424680.91,425885.84,1204.93,196403.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','227667',4383588,'2746','415',238280.15,238709.57,429.42,69995.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','227667',4383589,'2747','415',438469.56,439575.92,1106.36,180336.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','227667',4383590,'2748','415',349685.55,349685.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227667',4383591,'2749','415',207748.43,207874.45,126.02,20541.26,0.00,0.00,0.00,0.00,0.00),('1','185','936','227667',4383592,'2750','415',395275.22,397512.85,2237.63,364733.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','227667',4383593,'2751','415',71933.97,72828.50,894.53,145808.39,0.00,0.00,0.00,0.00,0.00),('1','185','936','227667',4383594,'2752','415',430579.98,433123.89,2543.91,414657.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','227667',4383595,'2753','415',69426.63,70009.60,582.97,95024.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','227667',4383596,'2754','415',413255.73,414576.29,1320.56,215251.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','227667',4383597,'2755','415',77893.05,79600.97,1707.92,278390.96,0.00,0.00,0.00,0.00,0.00),('1','185','937','227667',4383598,'2756','416',166777.38,167456.45,679.07,203721.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227667',4383599,'2757','416',136439.25,138353.70,1914.45,574335.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227667',4383600,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227667',4383601,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227777',4385718,'2744','415',257882.29,257882.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227777',4385719,'2745','415',425885.84,428260.57,2374.73,387080.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','227777',4385720,'2746','415',238709.57,238818.77,109.20,17799.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','227777',4385721,'2747','415',439575.92,441375.99,1800.07,293411.41,0.00,0.00,0.00,0.00,0.00),('1','185','935','227777',4385722,'2748','415',349685.55,351256.89,1571.34,256128.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','227777',4385723,'2749','415',207874.45,209010.56,1136.11,185185.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','227777',4385724,'2750','415',397512.85,399504.34,1991.49,324612.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','227777',4385725,'2751','415',72828.50,72828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227777',4385726,'2752','415',433123.89,435021.28,1897.39,309274.57,0.00,0.00,0.00,0.00,0.00),('1','185','936','227777',4385727,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227777',4385728,'2754','415',414576.29,416134.38,1558.09,253968.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','227777',4385729,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227777',4385730,'2756','416',167456.45,168201.29,744.84,223452.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227777',4385731,'2757','416',138353.70,138652.04,298.34,89502.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227777',4385732,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227777',4385733,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227999',4389718,'2744','415',257882.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227999',4389719,'2745','415',428260.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227999',4389720,'2746','415',238818.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227999',4389721,'2747','415',441375.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227999',4389722,'2748','415',351256.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','227999',4389723,'2749','415',209010.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227999',4389724,'2750','415',399504.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227999',4389725,'2751','415',72828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227999',4389726,'2752','415',435021.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227999',4389727,'2753','415',70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227999',4389728,'2754','415',416134.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','227999',4389729,'2755','415',79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227999',4389730,'2756','416',168201.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','227999',4389731,'2757','416',138652.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227999',4389732,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','227999',4389733,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228017',4390155,'2744','415',257882.29,258776.86,894.57,145814.91,0.00,0.00,0.00,0.00,0.00),('1','185','935','228017',4390156,'2745','415',428260.57,430428.68,2168.11,353401.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','228017',4390157,'2746','415',238818.77,240117.81,1299.04,211743.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','228017',4390158,'2747','415',441375.99,443025.12,1649.13,268808.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','228017',4390159,'2748','415',351256.89,352295.57,1038.68,169304.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','228017',4390160,'2749','415',209010.56,210082.71,1072.15,174760.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','228017',4390161,'2750','415',399504.34,401394.53,1890.19,308100.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','228017',4390162,'2751','415',72828.50,72828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228017',4390163,'2752','415',435021.28,436940.44,1919.16,312823.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','228017',4390164,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228017',4390165,'2754','415',416134.38,418074.45,1940.07,316231.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','228017',4390166,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228017',4390167,'2756','416',168201.29,168869.87,668.58,207259.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','228017',4390168,'2757','416',138652.04,139023.17,371.13,115050.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','228017',4390169,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228017',4390170,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228058',4391028,'2744','415',258776.86,258776.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228058',4391029,'2745','415',430428.68,432628.16,2199.48,358515.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','228058',4391030,'2746','415',240117.81,240800.20,682.39,111229.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','228058',4391031,'2747','415',443025.12,445038.84,2013.72,328236.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','228058',4391032,'2748','415',352295.57,354235.21,1939.64,316161.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','228058',4391033,'2749','415',210082.71,210777.64,694.93,113273.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','228058',4391034,'2750','415',401394.53,403262.99,1868.46,304558.98,0.00,0.00,0.00,0.00,0.00),('1','185','936','228058',4391035,'2751','415',72828.50,72828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228058',4391036,'2752','415',436940.44,438910.11,1969.67,321056.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','228058',4391037,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228058',4391038,'2754','415',418074.45,419948.36,1873.91,305447.33,0.00,0.00,0.00,0.00,0.00),('1','185','936','228058',4391039,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228058',4391040,'2756','416',168869.87,169978.80,1108.93,343768.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','228058',4391041,'2757','416',139023.17,139543.18,520.01,161203.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','228058',4391042,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228058',4391043,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228171',4393116,'2744','415',258776.86,260396.37,1619.51,263980.13,0.00,0.00,0.00,0.00,0.00),('1','185','935','228171',4393117,'2745','415',432628.16,434463.92,1835.76,299228.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','228171',4393118,'2746','415',240800.20,242170.02,1369.82,223280.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','228171',4393119,'2747','415',445038.84,446849.59,1810.75,295152.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','228171',4393120,'2748','415',354235.21,355714.48,1479.27,241121.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','228171',4393121,'2749','415',210777.64,211622.79,845.15,137759.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','228171',4393122,'2750','415',403262.99,405310.93,2047.94,333814.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','228171',4393123,'2751','415',72828.50,72828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228171',4393124,'2752','415',438910.11,440410.08,1499.97,244495.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','228171',4393125,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228171',4393126,'2754','415',419948.36,421702.97,1754.61,286001.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','228171',4393127,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228171',4393128,'2756','416',169978.80,171319.30,1340.50,415555.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228171',4393129,'2757','416',139543.18,139786.84,243.66,75534.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','228171',4393130,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228171',4393131,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228279',4395529,'2744','415',260396.37,260396.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228279',4395530,'2745','415',434463.92,437399.94,2936.02,478571.26,0.00,0.00,0.00,0.00,0.00),('1','185','935','228279',4395531,'2746','415',242170.02,242483.60,313.58,51113.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','228279',4395532,'2747','415',446849.59,449503.84,2654.25,432642.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','228279',4395533,'2748','415',355714.48,355803.44,88.96,14500.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','228279',4395534,'2749','415',211622.79,213119.50,1496.71,243963.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','228279',4395535,'2750','415',405310.93,407574.95,2254.02,367405.26,0.00,0.00,10.00,0.00,0.00),('1','185','936','228279',4395536,'2751','415',72828.50,72828.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228279',4395537,'2752','415',440410.08,442736.15,2326.07,379149.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','228279',4395538,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228279',4395539,'2754','415',421702.97,424014.08,2311.11,376710.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','228279',4395540,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228279',4395541,'2756','416',171319.30,172611.45,1292.15,400566.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','228279',4395542,'2757','416',139786.84,140524.58,737.74,228699.40,0.00,0.00,0.00,0.00,0.00),('1','185','938','228279',4395543,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228279',4395544,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228391',4397153,'2744','415',260396.37,261499.72,1103.35,179846.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','228391',4397154,'2745','415',437399.94,439670.02,2270.08,370023.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','228391',4397155,'2746','415',242483.60,244415.45,1931.85,314891.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','228391',4397156,'2747','415',449503.84,451775.18,2271.34,370228.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','228391',4397157,'2748','415',355803.44,357912.60,2109.16,343793.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','228391',4397158,'2749','415',213119.50,214110.20,990.70,161484.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','228391',4397159,'2750','415',407574.95,409697.83,2122.88,346029.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','228391',4397160,'2751','415',72828.50,73179.84,351.34,57268.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','228391',4397161,'2752','415',442736.15,445397.74,2661.59,433839.17,0.00,0.00,0.00,0.00,0.00),('1','185','936','228391',4397162,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228391',4397163,'2754','415',424014.08,426797.64,2783.56,453720.28,0.00,0.00,0.00,0.00,0.00),('1','185','936','228391',4397164,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228391',4397165,'2756','416',172611.45,173944.22,1332.77,413158.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','228391',4397166,'2757','416',140524.58,141432.95,908.37,281594.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','228391',4397167,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228391',4397168,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228486',4399161,'2744','415',261499.72,261499.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228486',4399162,'2745','415',439670.02,441735.64,2065.62,336696.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','228486',4399163,'2746','415',244415.45,245066.39,650.94,106103.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','228486',4399164,'2747','415',451775.18,454400.43,2625.25,427915.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','228486',4399165,'2748','415',357912.60,360329.55,2416.95,393962.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','228486',4399166,'2749','415',214110.20,214110.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228486',4399167,'2750','415',409697.83,412062.69,2364.86,385472.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','228486',4399168,'2751','415',73179.84,73179.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228486',4399169,'2752','415',445397.74,447349.35,1951.61,318112.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','228486',4399170,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228486',4399171,'2754','415',426797.64,429603.91,2806.27,457422.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','228486',4399172,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228486',4399173,'2756','416',173944.22,174408.02,463.80,143778.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228486',4399174,'2757','416',141432.95,141585.55,152.60,47306.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228486',4399175,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228486',4399176,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228567',4400367,'2744','415',261499.72,262530.35,1030.63,167992.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','228567',4400368,'2745','415',441735.64,443708.94,1973.30,321647.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','228567',4400369,'2746','415',245066.39,246078.88,1012.49,165035.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','228567',4400370,'2747','415',454400.43,456876.47,2476.04,403594.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','228567',4400371,'2748','415',360329.55,362728.13,2398.58,390968.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','228567',4400372,'2749','415',214110.20,214110.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228567',4400373,'2750','415',412062.69,413884.61,1821.92,296972.96,0.00,0.00,0.00,0.00,0.00),('1','185','936','228567',4400374,'2751','415',73179.84,73179.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228567',4400375,'2752','415',447349.35,449654.85,2305.50,375796.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','228567',4400376,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228567',4400377,'2754','415',429603.91,431583.88,1979.97,322735.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','228567',4400378,'2755','415',79600.97,79600.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228567',4400379,'2756','416',174408.02,174408.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228567',4400380,'2757','416',141585.55,141585.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228567',4400381,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228567',4400382,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228648',4402074,'2744','415',262530.35,262530.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228648',4402075,'2745','415',443708.94,446605.10,2896.16,472074.08,0.00,0.00,0.00,0.00,0.00),('1','185','935','228648',4402076,'2746','415',246078.88,246129.20,50.32,8202.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','228648',4402077,'2747','415',456876.47,459555.61,2679.14,436699.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','228648',4402078,'2748','415',362728.13,365069.33,2341.20,381615.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','228648',4402079,'2749','415',214110.20,214110.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228648',4402080,'2750','415',413884.61,415876.21,1991.60,324630.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','228648',4402081,'2751','415',73179.84,73179.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228648',4402082,'2752','415',449654.85,452021.35,2366.50,385739.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','228648',4402083,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228648',4402084,'2754','415',431583.88,433688.35,2104.47,343028.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','228648',4402085,'2755','415',79600.97,79664.44,63.47,10345.61,0.00,0.00,0.00,0.00,0.00),('1','185','937','228648',4402086,'2756','416',174408.02,174408.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228648',4402087,'2757','416',141585.55,141585.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228648',4402088,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228648',4402089,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228777',4404337,'2744','415',262530.35,262530.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228777',4404338,'2745','415',446605.10,449747.39,3142.29,512193.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','228777',4404339,'2746','415',246129.20,246794.91,665.71,108510.73,0.00,0.00,0.00,0.00,0.00),('1','185','935','228777',4404340,'2747','415',459555.61,462163.86,2608.25,425144.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','228777',4404341,'2748','415',365069.33,367091.93,2022.60,329683.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','228777',4404342,'2749','415',214110.20,214110.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228777',4404343,'2750','415',415876.21,417565.70,1689.49,275386.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','228777',4404344,'2751','415',73179.84,73179.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228777',4404345,'2752','415',452021.35,454446.11,2424.76,395235.88,0.00,0.00,0.00,0.00,0.00),('1','185','936','228777',4404346,'2753','415',70009.60,70009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228777',4404347,'2754','415',433688.35,434992.07,1303.72,212506.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','228777',4404348,'2755','415',79664.44,79709.60,45.16,7361.08,0.00,0.00,0.00,0.00,0.00),('1','185','937','228777',4404349,'2756','416',174408.02,174885.63,477.61,148059.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','228777',4404350,'2757','416',141585.55,142550.77,965.22,299218.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','228777',4404351,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228777',4404352,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228858',4405953,'2744','415',262530.35,263644.68,1114.33,181635.79,0.00,0.00,0.00,0.00,0.00),('1','185','935','228858',4405954,'2745','415',449747.39,451746.20,1998.81,325806.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','228858',4405955,'2746','415',246794.91,247048.08,253.17,41266.71,0.00,0.00,0.00,0.00,0.00),('1','185','935','228858',4405956,'2747','415',462163.86,465009.30,2845.44,463806.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','228858',4405957,'2748','415',367091.93,368775.14,1683.21,274363.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','228858',4405958,'2749','415',214110.20,215125.16,1014.96,165438.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','228858',4405959,'2750','415',417565.70,418603.15,1037.45,169104.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','228858',4405960,'2751','415',73179.84,73186.06,6.22,1013.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','228858',4405961,'2752','415',454446.11,457179.04,2732.93,445467.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','228858',4405962,'2753','415',70009.60,71003.21,993.61,161958.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','228858',4405963,'2754','415',434992.07,435450.62,458.55,74743.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','228858',4405964,'2755','415',79709.60,79814.00,104.40,17017.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','228858',4405965,'2756','416',174885.63,175892.68,1007.05,312185.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','228858',4405966,'2757','416',142550.77,142994.78,444.01,137643.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','228858',4405967,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228858',4405968,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228999',4408438,'2744','415',263644.68,264641.57,996.89,162493.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','228999',4408439,'2745','415',451746.20,453979.85,2233.65,364084.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','228999',4408440,'2746','415',247048.08,247697.93,649.85,105925.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','228999',4408441,'2747','415',465009.30,467201.12,2191.82,357266.66,0.00,0.00,0.00,0.00,0.00),('1','185','935','228999',4408442,'2748','415',368775.14,368775.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','228999',4408443,'2749','415',215125.16,216908.41,1783.25,290669.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','228999',4408444,'2750','415',418603.15,420841.04,2237.89,364776.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','228999',4408445,'2751','415',73186.06,73186.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228999',4408446,'2752','415',457179.04,459843.12,2664.08,434245.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','228999',4408447,'2753','415',71003.21,71003.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','228999',4408448,'2754','415',435450.62,437938.17,2487.55,405470.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','228999',4408449,'2755','415',79814.00,79814.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','228999',4408450,'2756','416',175892.68,176579.56,686.88,212932.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','228999',4408451,'2757','416',142994.78,143509.73,514.95,159634.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','228999',4408452,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','228999',4408453,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229161',4411909,'2744','415',264641.57,264641.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229161',4411910,'2745','415',453979.85,456427.43,2447.58,398955.54,0.00,0.00,0.00,0.00,0.00),('1','185','935','229161',4411911,'2746','415',247697.93,248911.71,1213.78,197846.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','229161',4411912,'2747','415',467201.12,468806.05,1604.93,261603.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','229161',4411913,'2748','415',368775.14,370784.43,2009.29,327514.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','229161',4411914,'2749','415',216908.41,216908.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229161',4411915,'2750','415',420841.04,422783.64,1942.60,316643.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','229161',4411916,'2751','415',73186.06,73186.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229161',4411917,'2752','415',459843.12,462635.72,2792.60,455193.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','229161',4411918,'2753','415',71003.21,71003.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229161',4411919,'2754','415',437938.17,440707.59,2769.42,451415.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','229161',4411920,'2755','415',79814.00,79814.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229161',4411921,'2756','416',176579.56,176911.14,331.58,102789.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','229161',4411922,'2757','416',143509.73,144542.64,1032.91,320202.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','229161',4411923,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229161',4411924,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229231',4413013,'2744','415',264641.57,265176.88,535.31,87255.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','229231',4413014,'2745','415',456427.43,459075.82,2648.39,431687.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','229231',4413015,'2746','415',248911.71,248911.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229231',4413016,'2747','415',468806.05,470991.34,2185.29,356202.27,0.00,0.00,0.00,0.00,0.00),('1','185','935','229231',4413017,'2748','415',370784.43,370971.87,187.44,30552.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','229231',4413018,'2749','415',216908.41,219181.29,2272.88,370479.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','229231',4413019,'2750','415',422783.64,424880.82,2097.18,341840.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','229231',4413020,'2751','415',73186.06,73186.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229231',4413021,'2752','415',462635.72,464882.79,2247.07,366272.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','229231',4413022,'2753','415',71003.21,71003.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229231',4413023,'2754','415',440707.59,442717.48,2009.89,327612.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','229231',4413024,'2755','415',79814.00,79814.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229231',4413025,'2756','416',176911.14,177433.98,522.84,162080.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','229231',4413026,'2757','416',144542.64,144751.52,208.88,64752.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','229231',4413027,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229231',4413028,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229235',4413074,'2744','415',265176.88,265176.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229235',4413075,'2745','415',459075.82,461785.96,2710.14,441752.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','229235',4413076,'2746','415',248911.71,249178.91,267.20,43553.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','229235',4413077,'2747','415',470991.34,473655.09,2663.75,434191.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','229235',4413078,'2748','415',370971.87,371113.19,141.32,23035.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','229235',4413079,'2749','415',219181.29,220968.67,1787.38,291342.94,0.00,0.00,0.00,0.00,0.00),('1','185','936','229235',4413080,'2750','415',424880.82,427001.87,2121.05,345731.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','229235',4413081,'2751','415',73186.06,73186.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229235',4413082,'2752','415',464882.79,467164.29,2281.50,371884.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','229235',4413083,'2753','415',71003.21,71003.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229235',4413084,'2754','415',442717.48,445563.79,2846.31,463948.53,0.00,0.00,0.00,0.00,0.00),('1','185','936','229235',4413085,'2755','415',79814.00,79814.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229235',4413086,'2756','416',177433.98,178318.28,884.30,274133.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229235',4413087,'2757','416',144751.52,144930.59,179.07,55511.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','229235',4413088,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229235',4413089,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229464',4417029,'2744','415',265176.88,265626.57,449.69,73299.47,0.00,0.00,0.00,0.00,0.00),('1','185','935','229464',4417030,'2745','415',461785.96,463222.81,1436.85,234206.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','229464',4417031,'2746','415',249178.91,250238.48,1059.57,172709.91,0.00,0.00,0.00,0.00,0.00),('1','185','935','229464',4417032,'2747','415',473655.09,475361.86,1706.77,278203.51,0.00,0.00,0.00,0.00,0.00),('1','185','935','229464',4417033,'2748','415',371113.19,371741.76,628.57,102456.91,0.00,0.00,0.00,0.00,0.00),('1','185','935','229464',4417034,'2749','415',220968.67,222129.42,1160.75,189202.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','229464',4417035,'2750','415',427001.87,428666.32,1664.45,271305.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','229464',4417036,'2751','415',73186.06,73933.53,747.47,121837.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','229464',4417037,'2752','415',467164.29,468966.97,1802.68,293836.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','229464',4417038,'2753','415',71003.21,71695.01,691.80,112763.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','229464',4417039,'2754','415',445563.79,446853.01,1289.22,210142.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','229464',4417040,'2755','415',79814.00,80451.04,637.04,103837.52,0.00,0.00,0.00,0.00,0.00),('1','185','937','229464',4417041,'2756','416',178318.28,179434.93,1116.65,346161.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','229464',4417042,'2757','416',144930.59,145580.74,650.15,201546.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','229464',4417043,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229464',4417044,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229614',4420356,'2744','415',265626.57,265626.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229614',4420357,'2745','415',463222.81,464931.70,1708.89,278549.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','229614',4420358,'2746','415',250238.48,250921.66,683.18,111358.34,0.00,0.00,0.00,0.00,0.00),('1','185','935','229614',4420359,'2747','415',475361.86,477722.01,2360.15,384704.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','229614',4420360,'2748','415',371741.76,374501.10,2759.34,449772.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','229614',4420361,'2749','415',222129.42,222129.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229614',4420362,'2750','415',428666.32,431269.99,2603.67,424398.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','229614',4420363,'2751','415',73933.53,73933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229614',4420364,'2752','415',468966.97,471385.39,2418.42,394202.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','229614',4420365,'2753','415',71695.01,71695.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229614',4420366,'2754','415',446853.01,446853.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229614',4420367,'2755','415',80451.04,82647.57,2196.53,358034.39,0.00,0.00,0.00,0.00,0.00),('1','185','937','229614',4420368,'2756','416',179434.93,180194.02,759.09,235317.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','229614',4420369,'2757','416',145580.74,145772.20,191.46,59352.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','229614',4420370,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229614',4420371,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229726',4422254,'2744','415',265626.57,266280.51,653.94,106592.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','229726',4422255,'2745','415',464931.70,467024.23,2092.53,341082.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','229726',4422256,'2746','415',250921.66,252096.54,1174.88,191505.44,0.00,0.00,0.00,0.00,0.00),('1','185','935','229726',4422257,'2747','415',477722.01,479865.51,2143.50,349390.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','229726',4422258,'2748','415',374501.10,375094.11,593.01,96660.63,0.00,0.00,0.00,0.00,0.00),('1','185','935','229726',4422259,'2749','415',222129.42,223340.93,1211.51,197476.13,0.00,0.00,0.00,0.00,0.00),('1','185','936','229726',4422260,'2750','415',431269.99,432927.41,1657.42,270159.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','229726',4422261,'2751','415',73933.53,73933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229726',4422262,'2752','415',471385.39,473257.80,1872.41,305202.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','229726',4422263,'2753','415',71695.01,71695.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229726',4422264,'2754','415',446853.01,448492.91,1639.90,267303.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','229726',4422265,'2755','415',82647.57,82647.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229726',4422266,'2756','416',180194.02,181377.07,1183.05,366745.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','229726',4422267,'2757','416',145772.20,146601.07,828.87,256949.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','229726',4422268,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229726',4422269,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229742',4422560,'2744','415',266280.51,266280.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229742',4422561,'2745','415',467024.23,470452.21,3427.98,558760.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','229742',4422562,'2746','415',252096.54,252096.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229742',4422563,'2747','415',479865.51,482283.44,2417.93,394122.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','229742',4422564,'2748','415',375094.11,376703.87,1609.76,262390.88,0.00,0.00,0.00,0.00,0.00),('1','185','935','229742',4422565,'2749','415',223340.93,223340.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229742',4422566,'2750','415',432927.41,435818.03,2890.62,471171.06,0.00,0.00,0.00,0.00,0.00),('1','185','936','229742',4422567,'2751','415',73933.53,73933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229742',4422568,'2752','415',473257.80,475814.65,2556.85,416766.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','229742',4422569,'2753','415',71695.01,71695.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229742',4422570,'2754','415',448492.91,451255.21,2762.30,450254.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','229742',4422571,'2755','415',82647.57,82647.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229742',4422572,'2756','416',181377.07,182156.12,779.05,241505.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','229742',4422573,'2757','416',146601.07,147012.04,410.97,127400.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','229742',4422574,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229742',4422575,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','229929',4426223,'2744','415',266280.51,266586.37,305.86,49855.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','229929',4426224,'2745','415',470452.21,473039.46,2587.25,421721.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','229929',4426225,'2746','415',252096.54,253019.07,922.53,150372.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','229929',4426226,'2747','415',482283.44,484158.88,1875.44,305696.72,0.00,0.00,0.00,0.00,0.00),('1','185','935','229929',4426227,'2748','415',376703.87,377570.97,867.10,141337.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','229929',4426228,'2749','415',223340.93,225022.90,1681.97,274161.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','229929',4426229,'2750','415',435818.03,437620.90,1802.87,293867.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','229929',4426230,'2751','415',73933.53,73933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229929',4426231,'2752','415',475814.65,477932.36,2117.71,345186.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','229929',4426232,'2753','415',71695.01,71695.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','229929',4426233,'2754','415',451255.21,453146.78,1891.57,308325.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','229929',4426234,'2755','415',82647.57,82647.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','229929',4426235,'2756','416',182156.12,185022.00,2865.88,888422.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','229929',4426236,'2757','416',147012.04,148303.40,1291.36,400321.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','229929',4426237,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','229929',4426238,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230137',4430029,'2744','415',266586.37,266586.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230137',4430030,'2745','415',473039.46,475637.87,2598.41,423540.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','230137',4430031,'2746','415',253019.07,253019.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230137',4430032,'2747','415',484158.88,487179.02,3020.14,492282.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','230137',4430033,'2748','415',377570.97,379648.49,2077.52,338635.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','230137',4430034,'2749','415',225022.90,226026.15,1003.25,163529.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','230137',4430035,'2750','415',437620.90,439758.08,2137.18,348360.34,0.00,0.00,0.00,0.00,0.00),('1','185','936','230137',4430036,'2751','415',73933.53,73933.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230137',4430037,'2752','415',477932.36,480151.78,2219.42,361765.46,0.00,0.00,0.00,0.00,0.00),('1','185','936','230137',4430038,'2753','415',71695.01,71695.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230137',4430039,'2754','415',453146.78,455803.43,2656.65,433033.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','230137',4430040,'2755','415',82647.57,82647.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230137',4430041,'2756','416',185022.00,186195.12,1173.12,363667.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','230137',4430042,'2757','416',148303.40,149093.80,790.40,245024.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230137',4430043,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230137',4430044,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230145',4430196,'2744','415',266586.37,267169.81,573.44,93470.72,0.00,0.00,10.00,0.00,0.00),('1','185','935','230145',4430197,'2745','415',475637.87,477250.77,1602.90,261272.70,0.00,0.00,10.00,0.00,0.00),('1','185','935','230145',4430198,'2746','415',253019.07,254125.14,1096.07,178659.41,0.00,0.00,10.00,0.00,0.00),('1','185','935','230145',4430199,'2747','415',487179.02,489494.83,2305.81,375847.03,0.00,0.00,10.00,0.00,0.00),('1','185','935','230145',4430200,'2748','415',379648.49,381793.68,2135.19,348035.97,0.00,0.00,10.00,0.00,0.00),('1','185','935','230145',4430201,'2749','415',226026.15,227143.91,1107.76,180564.88,0.00,0.00,10.00,0.00,0.00),('1','185','936','230145',4430202,'2750','415',439758.08,442337.06,2558.98,417113.74,0.00,0.00,20.00,0.00,0.00),('1','185','936','230145',4430203,'2751','415',73933.53,73943.53,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','230145',4430204,'2752','415',480151.78,483140.92,2969.14,483969.82,0.00,0.00,20.00,0.00,0.00),('1','185','936','230145',4430205,'2753','415',71695.01,71705.01,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','230145',4430206,'2754','415',455803.43,457810.32,1996.89,325493.07,0.00,0.00,10.00,0.00,0.00),('1','185','936','230145',4430207,'2755','415',82647.57,82657.72,0.15,24.45,0.00,0.00,10.00,0.00,0.00),('1','185','937','230145',4430208,'2756','416',186195.12,187157.92,962.80,298468.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230145',4430209,'2757','416',149093.80,149897.68,803.88,249202.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','230145',4430210,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230145',4430211,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230164',4430654,'2744','415',267169.81,267186.49,16.68,2718.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','230164',4430655,'2745','415',477250.77,480118.85,2868.08,467497.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','230164',4430656,'2746','415',254125.14,254125.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230164',4430657,'2747','415',489494.83,492079.95,2585.12,421374.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','230164',4430658,'2748','415',381793.68,384556.55,2762.87,450347.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','230164',4430659,'2749','415',227143.91,228612.78,1468.87,239425.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','230164',4430660,'2750','415',442337.06,445317.53,2980.47,485816.61,0.00,0.00,0.00,0.00,0.00),('1','185','936','230164',4430661,'2751','415',73943.53,73943.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230164',4430662,'2752','415',483140.92,485938.12,2797.20,455943.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','230164',4430663,'2753','415',71705.01,71705.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230164',4430664,'2754','415',457810.32,460879.84,3069.52,500331.76,0.00,0.00,0.00,0.00,0.00),('1','185','936','230164',4430665,'2755','415',82657.72,82657.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230164',4430666,'2756','416',187157.92,188232.72,1074.80,333188.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230164',4430667,'2757','416',149897.68,150285.64,387.96,120267.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','230164',4430668,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230164',4430669,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230352',4434028,'2744','415',267186.49,267650.83,464.34,75687.42,0.00,0.00,0.00,0.00,0.00),('1','185','935','230352',4434029,'2745','415',480118.85,482858.21,2739.36,446515.68,0.00,0.00,0.00,0.00,0.00),('1','185','935','230352',4434030,'2746','415',254125.14,255054.59,929.45,151500.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','230352',4434031,'2747','415',492079.95,495359.18,3279.23,534514.49,0.00,0.00,0.00,0.00,0.00),('1','185','935','230352',4434032,'2748','415',384556.55,386615.62,2059.07,335628.41,0.00,0.00,0.00,0.00,0.00),('1','185','935','230352',4434033,'2749','415',228612.78,229482.87,870.09,141824.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','230352',4434034,'2750','415',445317.53,446303.25,985.72,160672.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','230352',4434035,'2751','415',73943.53,73943.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230352',4434036,'2752','415',485938.12,488394.31,2456.19,400358.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','230352',4434037,'2753','415',71705.01,71705.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230352',4434038,'2754','415',460879.84,462835.87,1956.03,318832.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','230352',4434039,'2755','415',82657.72,82657.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230352',4434040,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230352',4434041,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230352',4434042,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230352',4434043,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230446',4436299,'2744','415',267650.83,267903.46,252.63,41178.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','230446',4436300,'2745','415',482858.21,486385.90,3527.69,575013.47,0.00,0.00,0.00,0.00,0.00),('1','185','935','230446',4436301,'2746','415',255054.59,255054.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230446',4436302,'2747','415',495359.18,499353.80,3994.62,651123.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','230446',4436303,'2748','415',386615.62,389255.59,2639.97,430315.11,0.00,0.00,0.00,0.00,0.00),('1','185','935','230446',4436304,'2749','415',229482.87,229616.41,133.54,21767.02,0.00,0.00,0.00,0.00,0.00),('1','185','936','230446',4436305,'2750','415',446303.25,448964.25,2661.00,433743.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230446',4436306,'2751','415',73943.53,74269.75,326.22,53173.86,0.00,0.00,0.00,0.00,0.00),('1','185','936','230446',4436307,'2752','415',488394.31,491504.92,3110.61,507029.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','230446',4436308,'2753','415',71705.01,71705.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230446',4436309,'2754','415',462835.87,465950.14,3114.27,507626.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','230446',4436310,'2755','415',82657.72,82749.98,92.26,15038.38,0.00,0.00,0.00,0.00,0.00),('1','185','937','230446',4436311,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230446',4436312,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230446',4436313,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230446',4436314,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230575',4438434,'2744','415',267903.46,268696.02,792.56,129187.28,0.00,0.00,0.00,0.00,0.00),('1','185','935','230575',4438435,'2745','415',486385.90,489488.94,3103.04,505795.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','230575',4438436,'2746','415',255054.59,256314.33,1259.74,205337.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','230575',4438437,'2747','415',499353.80,502784.74,3430.94,559243.22,0.00,0.00,0.00,0.00,0.00),('1','185','935','230575',4438438,'2748','415',389255.59,391846.00,2590.41,422236.83,0.00,0.00,0.00,0.00,0.00),('1','185','935','230575',4438439,'2749','415',229616.41,229616.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230575',4438440,'2750','415',448964.25,450261.59,1297.34,211466.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','230575',4438441,'2751','415',74269.75,75422.65,1152.90,187922.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','230575',4438442,'2752','415',491504.92,494556.95,3052.03,497480.89,0.00,0.00,0.00,0.00,0.00),('1','185','936','230575',4438443,'2753','415',71705.01,72393.58,688.57,112236.91,0.00,0.00,0.00,0.00,0.00),('1','185','936','230575',4438444,'2754','415',465950.14,469535.48,3585.34,584410.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','230575',4438445,'2755','415',82749.98,83223.17,473.19,77129.97,0.00,0.00,0.00,0.00,0.00),('1','185','937','230575',4438446,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230575',4438447,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230575',4438448,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230575',4438449,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230700',4440971,'2744','415',268696.02,270029.42,1333.40,217344.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','230700',4440972,'2745','415',489488.94,492311.24,2822.30,460034.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','230700',4440973,'2746','415',256314.33,257377.32,1062.99,173267.37,0.00,0.00,0.00,0.00,0.00),('1','185','935','230700',4440974,'2747','415',502784.74,505764.23,2979.49,485656.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','230700',4440975,'2748','415',391846.00,393789.14,1943.14,316731.82,0.00,0.00,0.00,0.00,0.00),('1','185','935','230700',4440976,'2749','415',229616.41,229616.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230700',4440977,'2750','415',450261.59,450261.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230700',4440978,'2751','415',75422.65,75422.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230700',4440979,'2752','415',494556.95,497502.66,2945.71,480150.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','230700',4440980,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230700',4440981,'2754','415',469535.48,473182.71,3647.23,594498.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','230700',4440982,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230700',4440983,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230700',4440984,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230700',4440985,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230700',4440986,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','230829',4442799,'2744','415',270029.42,270936.02,906.60,147775.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','230829',4442800,'2745','415',492311.24,494210.43,1899.19,309567.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','230829',4442801,'2746','415',257377.32,258085.47,708.15,115428.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','230829',4442802,'2747','415',505764.23,508545.35,2781.12,453322.56,0.00,0.00,0.00,0.00,0.00),('1','185','935','230829',4442803,'2748','415',393789.14,395407.23,1618.09,263748.67,0.00,0.00,0.00,0.00,0.00),('1','185','935','230829',4442804,'2749','415',229616.41,230730.18,1113.77,181544.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','230829',4442805,'2750','415',450261.59,450261.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230829',4442806,'2751','415',75422.65,75422.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230829',4442807,'2752','415',497502.66,499485.00,1982.34,323121.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','230829',4442808,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','230829',4442809,'2754','415',473182.71,475277.08,2094.37,341382.31,0.00,0.00,0.00,0.00,0.00),('1','185','936','230829',4442810,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230829',4442811,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','230829',4442812,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230829',4442813,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','230829',4442814,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231037',4446639,'2744','415',270936.02,272483.92,1547.90,252307.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','231037',4446640,'2745','415',494210.43,495729.54,1519.11,247614.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','231037',4446641,'2746','415',258085.47,258085.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231037',4446642,'2747','415',508545.35,510885.81,2340.46,381494.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','231037',4446643,'2748','415',395407.23,397438.14,2030.91,331038.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','231037',4446644,'2749','415',230730.18,230730.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231037',4446645,'2750','415',450261.59,452318.04,2056.45,335201.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','231037',4446646,'2751','415',75422.65,75422.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231037',4446647,'2752','415',499485.00,501618.58,2133.58,347773.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','231037',4446648,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231037',4446649,'2754','415',475277.08,477540.49,2263.41,368935.83,0.00,0.00,0.00,0.00,0.00),('1','185','936','231037',4446650,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231037',4446651,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231037',4446652,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231037',4446653,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231037',4446654,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231146',4448314,'2744','415',272483.92,273576.20,1092.28,178041.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','231146',4448315,'2745','415',495729.54,497288.94,1559.40,254182.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','231146',4448316,'2746','415',258085.47,258085.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231146',4448317,'2747','415',510885.81,513089.74,2203.93,359240.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','231146',4448318,'2748','415',397438.14,398732.99,1294.85,211060.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','231146',4448319,'2749','415',230730.18,231736.89,1006.71,164093.73,0.00,0.00,0.00,0.00,0.00),('1','185','936','231146',4448320,'2750','415',452318.04,454387.79,2069.75,337369.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','231146',4448321,'2751','415',75422.65,75422.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231146',4448322,'2752','415',501618.58,503429.06,1810.48,295108.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','231146',4448323,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231146',4448324,'2754','415',477540.49,479071.09,1530.60,249487.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','231146',4448325,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231146',4448326,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231146',4448327,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231146',4448328,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231146',4448329,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231308',4450918,'2744','415',273576.20,273576.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231308',4450919,'2745','415',497288.94,499414.67,2125.73,346493.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','231308',4450920,'2746','415',258085.47,258085.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231308',4450921,'2747','415',513089.74,515239.60,2149.86,350427.18,0.00,0.00,0.00,0.00,0.00),('1','185','935','231308',4450922,'2748','415',398732.99,400675.67,1942.68,316656.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','231308',4450923,'2749','415',231736.89,231736.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231308',4450924,'2750','415',454387.79,455921.23,1533.44,249950.72,0.00,0.00,0.00,0.00,0.00),('1','185','936','231308',4450925,'2751','415',75422.65,76813.91,1391.26,226775.38,0.00,0.00,0.00,0.00,0.00),('1','185','936','231308',4450926,'2752','415',503429.06,505348.38,1919.32,312849.16,0.00,0.00,0.00,0.00,0.00),('1','185','936','231308',4450927,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231308',4450928,'2754','415',479071.09,480646.77,1575.68,256835.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','231308',4450929,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231308',4450930,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231308',4450931,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231308',4450932,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231308',4450933,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231452',4453066,'2744','415',273576.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231452',4453067,'2745','415',499414.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231452',4453068,'2746','415',258085.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231452',4453069,'2747','415',515239.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231452',4453070,'2748','415',400675.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231452',4453071,'2749','415',231736.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231452',4453072,'2750','415',455921.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231452',4453073,'2751','415',76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231452',4453074,'2752','415',505348.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231452',4453075,'2753','415',72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231452',4453076,'2754','415',480646.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231452',4453077,'2755','415',83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231452',4453078,'2756','416',188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231452',4453079,'2757','416',150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231452',4453080,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231452',4453081,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231453',4453082,'2744','415',273576.20,274954.55,1378.35,224671.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','231453',4453083,'2745','415',499414.67,501294.20,1879.53,306363.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','231453',4453084,'2746','415',258085.47,259153.15,1067.68,174031.84,0.00,0.00,0.00,0.00,0.00),('1','185','935','231453',4453085,'2747','415',515239.60,517097.40,1857.80,302821.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','231453',4453086,'2748','415',400675.67,402089.67,1414.00,230482.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231453',4453087,'2749','415',231736.89,231736.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231453',4453088,'2750','415',455921.23,457564.10,1642.87,267787.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','231453',4453089,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231453',4453090,'2752','415',505348.38,507358.62,2010.24,327669.12,0.00,0.00,0.00,0.00,0.00),('1','185','936','231453',4453091,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231453',4453092,'2754','415',480644.77,482515.76,1870.99,304971.37,0.00,0.00,0.00,0.00,0.00),('1','185','936','231453',4453093,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231453',4453094,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231453',4453095,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231453',4453096,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231453',4453097,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231572',4455312,'2744','415',274954.55,276498.29,1543.74,251629.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','231572',4455313,'2745','415',501294.20,503147.48,1853.28,302084.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','231572',4455314,'2746','415',259153.15,259153.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231572',4455315,'2747','415',517097.40,519007.30,1909.90,311313.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','231572',4455316,'2748','415',402089.67,403711.91,1622.24,264425.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','231572',4455317,'2749','415',231736.89,232785.71,1048.82,170957.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','231572',4455318,'2750','415',457564.10,459386.18,1822.08,296999.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','231572',4455319,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231572',4455320,'2752','415',507358.62,509020.72,1662.10,270922.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','231572',4455321,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231572',4455322,'2754','415',482515.76,484189.96,1674.20,272894.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','231572',4455323,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231572',4455324,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231572',4455325,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231572',4455326,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231572',4455327,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231703',4457526,'2744','415',276498.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231703',4457527,'2745','415',503147.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231703',4457528,'2746','415',259153.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231703',4457529,'2747','415',519007.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231703',4457530,'2748','415',403711.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231703',4457531,'2749','415',232785.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231703',4457532,'2750','415',459386.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231703',4457533,'2751','415',76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231703',4457534,'2752','415',509020.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231703',4457535,'2753','415',72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231703',4457536,'2754','415',484189.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231703',4457537,'2755','415',83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231703',4457538,'2756','416',188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231703',4457539,'2757','416',150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231703',4457540,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231703',4457541,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231707',4457628,'2744','415',276498.29,276498.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231707',4457629,'2745','415',503147.48,505258.83,2111.35,344150.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','231707',4457630,'2746','415',259153.15,259858.77,705.62,115016.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','231707',4457631,'2747','415',519007.30,520635.92,1628.62,265465.06,0.00,0.00,0.00,0.00,0.00),('1','185','935','231707',4457632,'2748','415',403711.91,404925.75,1213.84,197855.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','231707',4457633,'2749','415',232784.71,234232.21,1447.50,235942.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','231707',4457634,'2750','415',459386.18,460880.04,1493.86,243499.18,0.00,0.00,0.00,0.00,0.00),('1','185','936','231707',4457635,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231707',4457636,'2752','415',509020.72,510764.56,1743.84,284245.92,0.00,0.00,0.00,0.00,0.00),('1','185','936','231707',4457637,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231707',4457638,'2754','415',484189.96,485676.78,1486.82,242351.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','231707',4457639,'2755','415',83223.17,83223.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231707',4457640,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231707',4457641,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231707',4457642,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231707',4457643,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231837',4460227,'2744','415',276498.29,277939.42,1441.13,234904.19,0.00,0.00,0.00,0.00,0.00),('1','185','935','231837',4460228,'2745','415',505258.83,506824.81,1565.98,255254.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','231837',4460229,'2746','415',259858.77,259999.49,140.72,22937.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','231837',4460230,'2747','415',520635.92,522720.03,2084.11,339709.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','231837',4460231,'2748','415',404925.75,406376.49,1450.74,236470.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','231837',4460232,'2749','415',234232.21,235228.27,996.06,162357.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','231837',4460233,'2750','415',460880.04,462757.97,1877.93,306102.59,0.00,0.00,0.00,0.00,0.00),('1','185','936','231837',4460234,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231837',4460235,'2752','415',510764.56,512164.67,1400.11,228217.93,0.00,0.00,0.00,0.00,0.00),('1','185','936','231837',4460236,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231837',4460237,'2754','415',485676.78,487212.51,1535.73,250323.99,0.00,0.00,0.00,0.00,0.00),('1','185','936','231837',4460238,'2755','415',83223.17,83274.40,51.23,8350.49,0.00,0.00,0.00,0.00,0.00),('1','185','937','231837',4460239,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231837',4460240,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231837',4460241,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231837',4460242,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231958',4462218,'2744','415',277939.42,279375.03,1435.61,234004.43,0.00,0.00,0.00,0.00,0.00),('1','185','935','231958',4462219,'2745','415',506824.81,508836.81,2012.00,327956.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','231958',4462220,'2746','415',259999.49,261235.77,1236.28,201513.64,0.00,0.00,0.00,0.00,0.00),('1','185','935','231958',4462221,'2747','415',522720.03,524792.42,2072.39,337799.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','231958',4462222,'2748','415',406376.49,407726.08,1349.59,219983.17,0.00,0.00,0.00,0.00,0.00),('1','185','935','231958',4462223,'2749','415',235228.27,235719.34,491.07,80044.41,0.00,0.00,0.00,0.00,0.00),('1','185','936','231958',4462224,'2750','415',462757.97,463958.92,1200.95,195754.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','231958',4462225,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231958',4462226,'2752','415',512164.67,513687.34,1522.67,248195.21,0.00,0.00,0.00,0.00,0.00),('1','185','936','231958',4462227,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','231958',4462228,'2754','415',487212.51,488415.19,1202.68,196036.84,0.00,0.00,0.00,0.00,0.00),('1','185','936','231958',4462229,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231958',4462230,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','231958',4462231,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231958',4462232,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','231958',4462233,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232022',4463431,'2744','415',279375.03,281277.99,1902.96,310182.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','232022',4463432,'2745','415',508836.81,508836.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232022',4463433,'2746','415',261235.77,262648.75,1412.98,230315.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','232022',4463434,'2747','415',524792.42,526224.21,1431.79,233381.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','232022',4463435,'2748','415',407726.08,407899.39,173.31,28249.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','232022',4463436,'2749','415',235719.34,237785.21,2065.87,336736.81,0.00,0.00,0.00,0.00,0.00),('1','185','936','232022',4463437,'2750','415',463958.92,465611.73,1652.81,269408.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','232022',4463438,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232022',4463439,'2752','415',513687.34,515968.95,2281.61,371902.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','232022',4463440,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232022',4463441,'2754','415',488415.19,490372.67,1957.48,319069.24,0.00,0.00,0.00,0.00,0.00),('1','185','936','232022',4463442,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232022',4463443,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232022',4463444,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232022',4463445,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232022',4463446,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232194',4466520,'2744','415',281277.99,282112.38,834.39,136005.57,0.00,0.00,0.00,0.00,0.00),('1','185','935','232194',4466521,'2745','415',508836.81,509183.35,346.54,56486.02,0.00,0.00,0.00,0.00,0.00),('1','185','935','232194',4466522,'2746','415',262648.75,263322.12,673.37,109759.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','232194',4466523,'2747','415',526224.21,528221.11,1996.90,325494.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','232194',4466524,'2748','415',407899.39,410308.37,2408.98,392663.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','232194',4466525,'2749','415',237785.21,237785.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232194',4466526,'2750','415',465611.73,467762.78,2151.05,350621.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','232194',4466527,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232194',4466528,'2752','415',515968.95,518562.96,2594.01,422823.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','232194',4466529,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232194',4466530,'2754','415',490372.67,492591.30,2218.63,361636.69,0.00,0.00,0.00,0.00,0.00),('1','185','936','232194',4466531,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232194',4466532,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232194',4466533,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232194',4466534,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232194',4466535,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232287',4468293,'2744','415',282112.38,283373.05,1260.67,205489.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','232287',4468294,'2745','415',509183.35,510268.83,1085.48,176933.24,0.00,0.00,0.00,0.00,0.00),('1','185','935','232287',4468295,'2746','415',263322.12,263565.44,243.32,39661.16,0.00,0.00,0.00,0.00,0.00),('1','185','935','232287',4468296,'2747','415',528221.11,530263.06,2041.95,332837.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','232287',4468297,'2748','415',410308.37,411797.21,1488.84,242680.92,0.00,0.00,0.00,0.00,0.00),('1','185','935','232287',4468298,'2749','415',237785.21,238481.66,696.45,113521.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','232287',4468299,'2750','415',467762.78,469204.43,1441.65,234988.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','232287',4468300,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232287',4468301,'2752','415',518562.96,520448.00,1885.04,307261.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','232287',4468302,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232287',4468303,'2754','415',492591.30,493698.12,1106.82,180411.66,0.00,0.00,0.00,0.00,0.00),('1','185','936','232287',4468304,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232287',4468305,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232287',4468306,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232287',4468307,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232287',4468308,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232411',4470278,'2744','415',283373.05,284710.88,1337.83,218066.29,0.00,0.00,0.00,0.00,0.00),('1','185','935','232411',4470279,'2745','415',510268.83,512087.02,1818.19,296364.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','232411',4470280,'2746','415',263565.44,264019.17,453.73,73957.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','232411',4470281,'2747','415',530263.06,532253.27,1990.21,324404.23,0.00,0.00,0.00,0.00,0.00),('1','185','935','232411',4470282,'2748','415',411797.21,413393.46,1596.25,260188.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','232411',4470283,'2749','415',238481.66,238481.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232411',4470284,'2750','415',469204.43,470889.76,1685.33,274708.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','232411',4470285,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232411',4470286,'2752','415',520448.00,522380.45,1932.45,314989.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','232411',4470287,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232411',4470288,'2754','415',493698.12,495581.22,1883.10,306945.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','232411',4470289,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232411',4470290,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232411',4470291,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232411',4470292,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232411',4470293,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232419',4470400,'2744','415',284710.88,284710.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232419',4470401,'2745','415',512087.02,514066.49,1979.47,322653.61,0.00,0.00,0.00,0.00,0.00),('1','185','935','232419',4470402,'2746','415',264019.17,264154.67,135.50,22086.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','232419',4470403,'2747','415',532253.27,534362.54,2109.27,343811.01,0.00,0.00,0.00,0.00,0.00),('1','185','935','232419',4470404,'2748','415',413393.46,415736.70,2343.24,381948.12,0.00,0.00,0.00,0.00,0.00),('1','185','935','232419',4470405,'2749','415',238481.66,238481.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232419',4470406,'2750','415',470889.76,472251.57,1361.81,221975.03,0.00,0.00,0.00,0.00,0.00),('1','185','936','232419',4470407,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232419',4470408,'2752','415',522380.45,524386.78,2006.33,327031.79,0.00,0.00,0.00,0.00,0.00),('1','185','936','232419',4470409,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232419',4470410,'2754','415',495581.22,498001.16,2419.94,394450.22,0.00,0.00,0.00,0.00,0.00),('1','185','936','232419',4470411,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232419',4470412,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232419',4470413,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232419',4470414,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232419',4470415,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232664',4475045,'2744','415',284710.88,286390.91,1680.03,273844.89,0.00,0.00,0.00,0.00,0.00),('1','185','935','232664',4475046,'2745','415',514066.49,516066.30,1999.81,325969.03,0.00,0.00,0.00,0.00,0.00),('1','185','935','232664',4475047,'2746','415',264154.67,264744.60,589.93,96158.59,0.00,0.00,0.00,0.00,0.00),('1','185','935','232664',4475048,'2747','415',534362.54,537086.50,2723.96,444005.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','232664',4475049,'2748','415',415736.70,417193.80,1457.10,237507.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','232664',4475050,'2749','415',238481.66,238825.82,344.16,56098.08,0.00,0.00,0.00,0.00,0.00),('1','185','936','232664',4475051,'2750','415',472251.57,473638.58,1387.01,226082.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','232664',4475052,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232664',4475053,'2752','415',524386.78,526050.12,1663.34,271124.42,0.00,0.00,0.00,0.00,0.00),('1','185','936','232664',4475054,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232664',4475055,'2754','415',498001.16,499413.77,1412.61,230255.43,0.00,0.00,0.00,0.00,0.00),('1','185','936','232664',4475056,'2755','415',83274.40,83274.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232664',4475057,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232664',4475058,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232664',4475059,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232664',4475060,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232671',4475187,'2744','415',286390.91,288256.70,1865.79,304123.77,0.00,0.00,0.00,0.00,0.00),('1','185','935','232671',4475188,'2745','415',516066.30,517443.50,1377.20,224483.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','232671',4475189,'2746','415',264744.60,264744.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232671',4475190,'2747','415',537086.50,538312.17,1225.67,199784.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','232671',4475191,'2748','415',417193.80,418737.91,1544.11,251689.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','232671',4475192,'2749','415',238825.82,238825.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232671',4475193,'2750','415',473638.58,474749.10,1110.52,181014.76,0.00,0.00,0.00,0.00,0.00),('1','185','936','232671',4475194,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232671',4475195,'2752','415',526050.12,527625.01,1574.89,256707.07,0.00,0.00,0.00,0.00,0.00),('1','185','936','232671',4475196,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232671',4475197,'2754','415',499413.77,500742.22,1328.45,216537.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','232671',4475198,'2755','415',83274.40,83405.01,130.61,21289.43,0.00,0.00,0.00,0.00,0.00),('1','185','937','232671',4475199,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232671',4475200,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232671',4475201,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232671',4475202,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','232903',4479121,'2744','415',288256.70,289068.27,811.57,132285.91,0.00,0.00,0.00,0.00,0.00),('1','185','935','232903',4479122,'2745','415',517443.50,520014.93,2571.43,419143.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','232903',4479123,'2746','415',264744.60,265133.12,388.52,63328.76,0.00,0.00,0.00,0.00,0.00),('1','185','935','232903',4479124,'2747','415',538312.17,540920.81,2608.64,425208.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','232903',4479125,'2748','415',418737.91,420551.28,1813.37,295579.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','232903',4479126,'2749','415',238825.82,239074.86,249.04,40593.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','232903',4479127,'2750','415',474749.10,476340.33,1591.23,259370.49,0.00,0.00,0.00,0.00,0.00),('1','185','936','232903',4479128,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232903',4479129,'2752','415',527625.01,529711.66,2086.65,340123.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','232903',4479130,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','232903',4479131,'2754','415',500742.22,502660.82,1918.60,312731.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','232903',4479132,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232903',4479133,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','232903',4479134,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232903',4479135,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','232903',4479136,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233089',4482770,'2744','415',289068.27,289365.05,296.78,48375.14,0.00,0.00,0.00,0.00,0.00),('1','185','935','233089',4482771,'2745','415',520014.93,521592.30,1577.37,257111.31,0.00,0.00,0.00,0.00,0.00),('1','185','935','233089',4482772,'2746','415',265133.12,266577.20,1444.08,235385.04,0.00,0.00,0.00,0.00,0.00),('1','185','935','233089',4482773,'2747','415',540920.81,542342.85,1422.04,231792.52,0.00,0.00,0.00,0.00,0.00),('1','185','935','233089',4482774,'2748','415',420551.28,422804.77,2253.49,367318.87,0.00,0.00,0.00,0.00,0.00),('1','185','935','233089',4482775,'2749','415',239074.86,239074.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233089',4482776,'2750','415',476340.33,478179.39,1839.06,299766.78,0.00,0.00,0.00,0.00,0.00),('1','185','936','233089',4482777,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233089',4482778,'2752','415',529711.66,531734.62,2022.96,329742.48,0.00,0.00,0.00,0.00,0.00),('1','185','936','233089',4482779,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233089',4482780,'2754','415',502660.82,504276.79,1615.97,263403.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','233089',4482781,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233089',4482782,'2756','416',188232.72,188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233089',4482783,'2757','416',150285.64,150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233089',4482784,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233089',4482785,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233168',4484035,'2744','415',289365.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233168',4484036,'2745','415',521592.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233168',4484037,'2746','415',266577.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233168',4484038,'2747','415',542342.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233168',4484039,'2748','415',422804.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233168',4484040,'2749','415',239074.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233168',4484041,'2750','415',478179.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233168',4484042,'2751','415',76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233168',4484043,'2752','415',531734.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233168',4484044,'2753','415',72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233168',4484045,'2754','415',504276.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233168',4484046,'2755','415',83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233168',4484047,'2756','416',188232.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233168',4484048,'2757','416',150285.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233168',4484049,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233168',4484050,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233210',4484728,'2744','415',289365.05,290801.68,1436.63,234170.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','233210',4484729,'2745','415',521592.30,523554.02,1961.72,319760.36,0.00,0.00,0.00,0.00,0.00),('1','185','935','233210',4484730,'2746','415',266577.20,266577.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233210',4484731,'2747','415',542342.85,545158.28,2815.43,458915.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','233210',4484732,'2748','415',422804.77,424722.23,1917.46,312545.98,0.00,0.00,0.00,0.00,0.00),('1','185','935','233210',4484733,'2749','415',239074.86,239074.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233210',4484734,'2750','415',478179.39,480177.36,1997.97,325669.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','233210',4484735,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233210',4484736,'2752','415',531734.62,533957.45,2222.83,362321.29,0.00,0.00,0.00,0.00,0.00),('1','185','936','233210',4484737,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233210',4484738,'2754','415',504276.79,506318.67,2041.88,332826.44,0.00,0.00,0.00,0.00,0.00),('1','185','936','233210',4484739,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233210',4484740,'2756','416',188232.72,188466.06,233.34,80502.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','233210',4484741,'2757','416',150285.64,150485.35,199.71,68899.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','233210',4484742,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233210',4484743,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233274',4485941,'2744','415',290801.68,292320.64,1518.96,247590.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','233274',4485942,'2745','415',523554.02,525521.55,1967.53,320707.39,0.00,0.00,0.00,0.00,0.00),('1','185','935','233274',4485943,'2746','415',266577.20,267673.16,1095.96,178641.48,0.00,0.00,0.00,0.00,0.00),('1','185','935','233274',4485944,'2747','415',545158.28,546915.02,1756.74,286348.62,0.00,0.00,0.00,0.00,0.00),('1','185','935','233274',4485945,'2748','415',424722.23,426865.80,2143.57,349401.91,0.00,0.00,0.00,0.00,0.00),('1','185','935','233274',4485946,'2749','415',239074.86,240216.63,1141.77,186108.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','233274',4485947,'2750','415',480177.36,480546.96,369.60,60244.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','233274',4485948,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233274',4485949,'2752','415',533957.45,534659.53,702.08,114439.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','233274',4485950,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233274',4485951,'2754','415',506318.67,506840.82,522.15,85110.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','233274',4485952,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233274',4485953,'2756','416',188466.06,189342.90,876.84,302509.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','233274',4485954,'2757','416',150485.35,150578.83,93.48,32250.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','233274',4485955,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233274',4485956,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233425',4488472,'2744','415',292320.64,294128.51,1807.87,294682.81,0.00,0.00,0.00,0.00,0.00),('1','185','935','233425',4488473,'2745','415',525521.55,527696.15,2174.60,354459.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','233425',4488474,'2746','415',267673.16,268384.14,710.98,115889.74,0.00,0.00,0.00,0.00,0.00),('1','185','935','233425',4488475,'2747','415',546915.02,549307.17,2392.15,389920.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','233425',4488476,'2748','415',426865.80,428973.43,2107.63,343543.69,0.00,0.00,0.00,0.00,0.00),('1','185','935','233425',4488477,'2749','415',240216.63,240634.77,418.14,68156.82,0.00,0.00,0.00,0.00,0.00),('1','185','936','233425',4488478,'2750','415',480546.96,482043.00,1496.04,243854.52,0.00,0.00,0.00,0.00,0.00),('1','185','936','233425',4488479,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233425',4488480,'2752','415',534659.53,536287.98,1628.45,265437.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','233425',4488481,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233425',4488482,'2754','415',506840.82,508227.40,1386.58,226012.54,0.00,0.00,0.00,0.00,0.00),('1','185','936','233425',4488483,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233425',4488484,'2756','416',189342.90,190045.37,702.47,242352.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','233425',4488485,'2757','416',150578.83,150801.89,223.06,76955.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','233425',4488486,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233425',4488487,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233538',4490739,'2744','415',294128.51,296310.15,2181.64,355607.32,0.00,0.00,0.00,0.00,0.00),('1','185','935','233538',4490740,'2745','415',527696.15,528712.46,1016.31,165658.53,0.00,0.00,0.00,0.00,0.00),('1','185','935','233538',4490741,'2746','415',268384.14,269922.20,1538.06,250703.78,0.00,0.00,0.00,0.00,0.00),('1','185','935','233538',4490742,'2747','415',549307.17,550127.43,820.26,133702.38,0.00,0.00,0.00,0.00,0.00),('1','185','935','233538',4490743,'2748','415',428973.43,431386.32,2412.89,393301.07,0.00,0.00,0.00,0.00,0.00),('1','185','935','233538',4490744,'2749','415',240634.77,240634.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233538',4490745,'2750','415',482043.00,483363.77,1320.77,215285.51,0.00,0.00,0.00,0.00,0.00),('1','185','936','233538',4490746,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233538',4490747,'2752','415',536287.98,537922.58,1634.60,266439.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','233538',4490748,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233538',4490749,'2754','415',508227.40,509848.89,1621.49,264302.87,0.00,0.00,0.00,0.00,0.00),('1','185','936','233538',4490750,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233538',4490751,'2756','416',190045.37,190490.06,444.69,155641.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','233538',4490752,'2757','416',150801.89,151061.88,259.99,90996.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','233538',4490753,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233538',4490754,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233650',4492630,'2744','415',296310.15,296887.26,577.11,94068.93,0.00,0.00,0.00,0.00,0.00),('1','185','935','233650',4492631,'2745','415',528712.46,530717.84,2005.38,326876.94,0.00,0.00,0.00,0.00,0.00),('1','185','935','233650',4492632,'2746','415',269922.20,269922.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233650',4492633,'2747','415',550127.43,552487.68,2360.25,384720.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','233650',4492634,'2748','415',431386.32,432931.82,1545.50,251916.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','233650',4492635,'2749','415',240634.77,241650.04,1015.27,165489.01,0.00,0.00,0.00,0.00,0.00),('1','185','936','233650',4492636,'2750','415',483363.77,485157.78,1794.01,292423.63,0.00,0.00,0.00,0.00,0.00),('1','185','936','233650',4492637,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233650',4492638,'2752','415',537922.58,539514.48,1591.90,259479.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','233650',4492639,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233650',4492640,'2754','415',509848.89,511780.08,1931.19,314783.97,0.00,0.00,0.00,0.00,0.00),('1','185','936','233650',4492641,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233650',4492642,'2756','416',190490.06,191061.48,571.42,199997.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233650',4492643,'2757','416',151061.88,151190.84,128.96,45136.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233650',4492644,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233650',4492645,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233664',4492861,'2744','415',296887.26,298499.06,1611.80,262723.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','233664',4492862,'2745','415',530717.84,532628.27,1910.43,311400.09,0.00,0.00,0.00,0.00,0.00),('1','185','935','233664',4492863,'2746','415',269922.20,271137.89,1215.69,198157.47,0.00,0.00,0.00,0.00,0.00),('1','185','935','233664',4492864,'2747','415',552487.68,554387.59,1899.91,309685.33,0.00,0.00,0.00,0.00,0.00),('1','185','935','233664',4492865,'2748','415',432931.82,434780.55,1848.73,301342.99,0.00,0.00,0.00,0.00,0.00),('1','185','935','233664',4492866,'2749','415',241650.04,242765.12,1115.08,181758.04,0.00,0.00,0.00,0.00,0.00),('1','185','936','233664',4492867,'2750','415',485157.78,485324.50,166.72,27175.36,0.00,0.00,0.00,0.00,0.00),('1','185','936','233664',4492868,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233664',4492869,'2752','415',539514.48,540126.84,612.36,99814.68,0.00,0.00,0.00,0.00,0.00),('1','185','936','233664',4492870,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233664',4492871,'2754','415',511780.08,513848.23,2068.15,337108.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','233664',4492872,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233664',4492873,'2756','416',191061.48,191503.91,442.43,154850.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','233664',4492874,'2757','416',151190.84,151190.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233664',4492875,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233664',4492876,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233843',4496202,'2744','415',298499.06,299981.13,1482.07,241577.41,0.00,0.00,0.00,0.00,0.00),('1','185','935','233843',4496203,'2745','415',532628.27,535067.94,2439.67,397666.21,0.00,0.00,0.00,0.00,0.00),('1','185','935','233843',4496204,'2746','415',271137.89,271626.08,488.19,79574.97,0.00,0.00,0.00,0.00,0.00),('1','185','935','233843',4496205,'2747','415',554387.59,557279.51,2891.92,471382.96,0.00,0.00,0.00,0.00,0.00),('1','185','935','233843',4496206,'2748','415',434780.55,437568.97,2788.42,454512.46,0.00,0.00,0.00,0.00,0.00),('1','185','935','233843',4496207,'2749','415',242765.12,243646.02,880.90,143586.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','233843',4496208,'2750','415',485324.50,487274.47,1949.97,317845.11,0.00,0.00,0.00,0.00,0.00),('1','185','936','233843',4496209,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233843',4496210,'2752','415',540126.84,542327.39,2200.55,358689.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','233843',4496211,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233843',4496212,'2754','415',513848.23,515904.32,2056.09,335142.67,0.00,0.00,0.00,0.00,0.00),('1','185','936','233843',4496213,'2755','415',83405.01,83405.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233843',4496214,'2756','416',191503.91,192162.64,658.73,230555.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','233843',4496215,'2757','416',151190.84,151561.56,370.72,129752.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233843',4496216,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233843',4496217,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','233960',4498425,'2744','415',299981.13,300791.65,810.52,133735.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','233960',4498426,'2745','415',535067.94,536134.77,1066.83,176026.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','233960',4498427,'2746','415',271626.08,272342.34,716.26,118182.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','233960',4498428,'2747','415',557279.51,558504.43,1224.92,202111.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','233960',4498429,'2748','415',437568.97,438682.36,1113.39,183709.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','233960',4498430,'2749','415',243646.02,244307.92,661.90,109213.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','233960',4498431,'2750','415',487274.47,487907.72,633.25,104486.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','233960',4498432,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233960',4498433,'2752','415',542327.39,542697.43,370.04,61056.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','233960',4498434,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','233960',4498435,'2754','415',515904.32,517427.49,1523.17,251323.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','233960',4498436,'2755','415',83405.01,83466.32,61.31,10116.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','233960',4498437,'2756','416',192162.64,192556.54,393.90,137865.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','233960',4498438,'2757','416',151561.56,151609.84,48.28,16898.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233960',4498439,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','233960',4498440,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234061',4500012,'2744','415',300791.65,302420.11,1628.46,268695.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','234061',4500013,'2745','415',536134.77,537664.72,1529.95,252441.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','234061',4500014,'2746','415',272342.34,272439.31,96.97,16000.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','234061',4500015,'2747','415',558504.43,561022.64,2518.21,415504.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','234061',4500016,'2748','415',438682.36,440185.08,1502.72,247948.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','234061',4500017,'2749','415',244307.92,245194.73,886.81,146323.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','234061',4500018,'2750','415',487907.72,490039.64,2131.92,351766.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','234061',4500019,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234061',4500020,'2752','415',542697.43,544783.76,2086.33,344244.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','234061',4500021,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234061',4500022,'2754','415',517427.49,519762.82,2335.33,385329.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','234061',4500023,'2755','415',83466.32,83466.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234061',4500024,'2756','416',192556.54,192853.08,296.54,103789.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234061',4500025,'2757','416',151609.84,151765.56,155.72,54502.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234061',4500026,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234061',4500027,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234231',4503370,'2744','415',302420.11,303928.76,1508.65,248927.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','234231',4503371,'2745','415',537664.72,539152.67,1487.95,245511.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','234231',4503372,'2746','415',272439.31,273140.25,700.94,115655.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234231',4503373,'2747','415',561022.64,562934.46,1911.82,315450.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','234231',4503374,'2748','415',440185.08,441976.42,1791.34,295571.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234231',4503375,'2749','415',245194.73,246240.61,1045.88,172570.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','234231',4503376,'2750','415',490039.64,492105.77,2066.13,340911.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','234231',4503377,'2751','415',76813.91,76813.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234231',4503378,'2752','415',544783.76,546536.99,1753.23,289282.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','234231',4503379,'2753','415',72393.58,72393.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234231',4503380,'2754','415',519762.82,521437.33,1674.51,276294.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','234231',4503381,'2755','415',83466.32,83466.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234231',4503382,'2756','416',192853.08,194257.39,1404.31,491508.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','234231',4503383,'2757','416',151765.56,151765.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234231',4503384,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234231',4503385,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234294',4504519,'2744','415',303928.76,304451.95,523.19,86326.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','234294',4504520,'2745','415',539152.67,541019.57,1866.90,308038.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','234294',4504521,'2746','415',273140.25,273761.52,621.27,102509.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','234294',4504522,'2747','415',562934.46,565590.83,2656.37,438301.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','234294',4504523,'2748','415',441976.42,443172.00,1195.58,197270.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','234294',4504524,'2749','415',246240.61,247537.76,1297.15,214029.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','234294',4504525,'2750','415',492105.77,494409.57,2303.80,380127.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234294',4504526,'2751','415',76813.91,77403.29,589.38,97247.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','234294',4504527,'2752','415',546536.99,549454.69,2917.70,481420.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','234294',4504528,'2753','415',72393.58,72421.27,27.69,4568.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','234294',4504529,'2754','415',521437.33,523950.92,2513.59,414742.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','234294',4504530,'2755','415',83466.32,83466.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234294',4504531,'2756','416',194257.39,195376.97,1119.58,391853.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234294',4504532,'2757','416',151765.56,152546.27,780.71,273248.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','234294',4504533,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234294',4504534,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234432',4507033,'2744','415',304451.95,305491.15,1039.20,171468.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234432',4507034,'2745','415',541019.57,542833.17,1813.60,299244.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234432',4507035,'2746','415',273761.52,273761.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234432',4507036,'2747','415',565590.83,567537.64,1946.81,321223.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','234432',4507037,'2748','415',443172.00,444540.34,1368.34,225776.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234432',4507038,'2749','415',247537.76,248534.64,996.88,164485.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','234432',4507039,'2750','415',494409.57,497075.30,2665.73,439845.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','234432',4507040,'2751','415',77403.29,77403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234432',4507041,'2752','415',549454.69,551597.48,2142.79,353560.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','234432',4507042,'2753','415',72421.27,72421.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234432',4507043,'2754','415',523950.92,525808.61,1857.69,306518.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','234432',4507044,'2755','415',83466.32,83466.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234432',4507045,'2756','416',195376.97,196094.47,717.50,251125.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234432',4507046,'2757','416',152546.27,153786.27,1240.00,434000.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234432',4507047,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234432',4507048,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234565',4509211,'2744','415',305491.15,306864.06,1372.91,226530.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','234565',4509212,'2745','415',542833.17,545031.95,2198.78,362798.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','234565',4509213,'2746','415',273761.52,275030.59,1269.07,209396.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','234565',4509214,'2747','415',567537.64,569405.54,1867.90,308203.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','234565',4509215,'2748','415',444540.34,446643.20,2102.86,346971.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','234565',4509216,'2749','415',248534.64,250251.02,1716.38,283202.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','234565',4509217,'2750','415',497075.30,497730.45,655.15,108099.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','234565',4509218,'2751','415',77403.29,77403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234565',4509219,'2752','415',551597.48,552489.73,892.25,147221.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','234565',4509220,'2753','415',72421.27,72421.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234565',4509221,'2754','415',525808.61,526822.85,1014.24,167349.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','234565',4509222,'2755','415',83466.32,83466.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234565',4509223,'2756','416',196094.47,196571.78,477.31,167058.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','234565',4509224,'2757','416',153786.27,155900.55,2114.28,739998.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234565',4509225,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234565',4509226,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234724',4511990,'2744','415',306864.06,308458.60,1594.54,263099.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234724',4511991,'2745','415',545031.95,546886.44,1854.49,305990.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','234724',4511992,'2746','415',275030.59,275030.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234724',4511993,'2747','415',569405.54,571586.68,2181.14,359888.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234724',4511994,'2748','415',446643.20,446667.44,24.24,3999.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','234724',4511995,'2749','415',250251.02,251703.28,1452.26,239622.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','234724',4511996,'2750','415',497730.45,499919.30,2188.85,361160.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','234724',4511997,'2751','415',77403.29,77403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234724',4511998,'2752','415',552489.73,555051.84,2562.11,422748.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','234724',4511999,'2753','415',72421.27,72421.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234724',4512000,'2754','415',526822.85,528612.47,1789.62,295287.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','234724',4512001,'2755','415',83466.32,83888.88,422.56,69722.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','234724',4512002,'2756','416',196571.78,196987.34,415.56,145446.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234724',4512003,'2757','416',155900.55,156322.95,422.40,147840.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234724',4512004,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234724',4512005,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234808',4513634,'2744','415',308458.60,308458.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234808',4513635,'2745','415',546886.44,549084.84,2198.40,362736.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234808',4513636,'2746','415',275030.59,275030.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234808',4513637,'2747','415',571586.68,573954.85,2368.17,390748.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','234808',4513638,'2748','415',446667.44,447693.38,1025.94,169280.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234808',4513639,'2749','415',251703.28,253231.35,1528.07,252131.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','234808',4513640,'2750','415',499919.30,502224.91,2305.61,380425.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','234808',4513641,'2751','415',77403.29,77403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234808',4513642,'2752','415',555051.84,557500.40,2448.56,404012.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','234808',4513643,'2753','415',72421.27,72421.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234808',4513644,'2754','415',528612.47,530849.13,2236.66,369048.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','234808',4513645,'2755','415',83888.88,83888.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234808',4513646,'2756','416',196987.34,197117.91,130.57,45699.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','234808',4513647,'2757','416',156322.95,156694.38,371.43,130000.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','234808',4513648,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234808',4513649,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','234967',4516462,'2744','415',308458.60,310002.47,1543.87,254738.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','234967',4516463,'2745','415',549084.84,550916.68,1831.84,302253.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','234967',4516464,'2746','415',275030.59,275988.53,957.94,158060.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','234967',4516465,'2747','415',573954.85,575796.35,1841.50,303847.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','234967',4516466,'2748','415',447693.38,450325.29,2621.91,432615.15,0.00,0.00,10.00,0.00,0.00),('1','185','935','234967',4516467,'2749','415',253231.35,253231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234967',4516468,'2750','415',502224.91,504138.71,1903.80,314127.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','234967',4516469,'2751','415',77403.29,77403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','234967',4516470,'2752','415',557500.40,559556.39,2055.99,339238.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','234967',4516471,'2753','415',72421.27,72944.93,523.66,86403.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','234967',4516472,'2754','415',530849.13,532759.88,1900.75,313623.75,0.00,0.00,10.00,0.00,0.00),('1','185','936','234967',4516473,'2755','415',83888.88,83888.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234967',4516474,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','234967',4516475,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234967',4516476,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','234967',4516477,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235053',4518021,'2744','415',310002.47,311347.66,1345.19,221956.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','235053',4518022,'2745','415',550916.68,553040.47,2123.79,350425.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','235053',4518023,'2746','415',275988.53,276292.16,303.63,50098.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','235053',4518024,'2747','415',575796.35,578148.05,2351.70,388030.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','235053',4518025,'2748','415',450325.29,452821.21,2495.92,411826.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','235053',4518026,'2749','415',253231.35,253231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235053',4518027,'2750','415',504138.71,506502.03,2363.32,389947.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','235053',4518028,'2751','415',77403.29,77403.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235053',4518029,'2752','415',559556.39,562524.55,2968.16,489746.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','235053',4518030,'2753','415',72944.93,73106.95,162.02,26733.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','235053',4518031,'2754','415',532759.88,535153.09,2393.21,394879.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','235053',4518032,'2755','415',83888.88,84826.45,937.57,154699.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','235053',4518033,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235053',4518034,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235053',4518035,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235053',4518036,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235216',4520673,'2744','415',311347.66,312576.58,1228.92,202771.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','235216',4520674,'2745','415',553040.47,555440.11,2399.64,395940.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','235216',4520675,'2746','415',276292.16,277184.11,891.95,147171.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','235216',4520676,'2747','415',578148.05,580509.48,2361.43,389635.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','235216',4520677,'2748','415',452821.21,452821.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235216',4520678,'2749','415',253231.35,253231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235216',4520679,'2750','415',506502.03,506796.59,294.56,48602.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','235216',4520680,'2751','415',77403.29,77714.72,311.43,51385.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','235216',4520681,'2752','415',562524.55,565555.57,3031.02,500118.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','235216',4520682,'2753','415',73106.95,74672.46,1565.51,258309.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','235216',4520683,'2754','415',535153.09,536182.43,1029.34,169841.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','235216',4520684,'2755','415',84826.45,87546.33,2719.88,448780.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','235216',4520685,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235216',4520686,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235216',4520687,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235216',4520688,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235287',4521986,'2744','415',312576.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235287',4521987,'2745','415',555440.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235287',4521988,'2746','415',277184.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235287',4521989,'2747','415',580509.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235287',4521990,'2748','415',452821.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235287',4521991,'2749','415',253231.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235287',4521992,'2750','415',506796.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235287',4521993,'2751','415',77714.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235287',4521994,'2752','415',565555.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235287',4521995,'2753','415',74672.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235287',4521996,'2754','415',536182.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235287',4521997,'2755','415',87546.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235287',4521998,'2756','416',197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235287',4521999,'2757','416',156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235287',4522000,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235287',4522001,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235293',4522025,'2744','415',312576.58,313641.76,1065.18,175754.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','235293',4522026,'2745','415',555440.11,556506.67,1066.56,175982.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','235293',4522027,'2746','415',277184.11,277184.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235293',4522028,'2747','415',580509.48,581758.29,1248.81,206053.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','235293',4522029,'2748','415',452821.21,453911.36,1090.15,179874.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','235293',4522030,'2749','415',253231.94,253231.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235293',4522031,'2750','415',506796.59,509070.89,2274.30,375259.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','235293',4522032,'2751','415',77714.72,78343.38,628.66,103728.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','235293',4522033,'2752','415',565555.57,567690.75,2135.18,352304.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','235293',4522034,'2753','415',74672.46,75561.26,888.80,146652.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235293',4522035,'2754','415',536182.43,538169.35,1976.92,326191.80,0.00,0.00,10.00,0.00,0.00),('1','185','936','235293',4522036,'2755','415',87546.33,88230.66,684.33,112914.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','235293',4522037,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235293',4522038,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235293',4522039,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235293',4522040,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235397',4523890,'2744','415',313641.76,313641.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235397',4523891,'2745','415',556506.67,558925.36,2418.69,399083.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','235397',4523892,'2746','415',277184.11,277184.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235397',4523893,'2747','415',581758.29,585176.47,3418.18,563999.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','235397',4523894,'2748','415',453911.36,456378.90,2467.54,407144.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','235397',4523895,'2749','415',253231.94,254356.29,1124.35,185517.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','235397',4523896,'2750','415',509070.89,510034.45,963.56,158987.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','235397',4523897,'2751','415',78343.38,78968.61,625.23,103162.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','235397',4523898,'2752','415',567690.75,570266.03,2575.28,424921.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','235397',4523899,'2753','415',75561.26,75561.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235397',4523900,'2754','415',538169.35,541299.57,3130.22,516486.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','235397',4523901,'2755','415',88230.66,88230.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235397',4523902,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235397',4523903,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235397',4523904,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235397',4523905,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235509',4525904,'2744','415',313641.76,315331.67,1689.91,278835.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','235509',4525905,'2745','415',558925.36,560840.55,1915.19,316006.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','235509',4525906,'2746','415',277184.11,278691.23,1507.12,248674.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','235509',4525907,'2747','415',585176.47,587409.65,2233.18,368474.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','235509',4525908,'2748','415',456378.90,458405.09,2026.19,334321.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','235509',4525909,'2749','415',254356.29,254721.88,365.59,60322.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','235509',4525910,'2750','415',510034.45,510034.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235509',4525911,'2751','415',78968.61,80747.90,1779.29,293582.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','235509',4525912,'2752','415',570266.03,572449.40,2183.37,360256.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','235509',4525913,'2753','415',75561.26,75561.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235509',4525914,'2754','415',541299.57,543822.07,2522.50,416212.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','235509',4525915,'2755','415',88230.66,88230.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235509',4525916,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235509',4525917,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235509',4525918,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235509',4525919,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235556',4526519,'2744','415',315331.67,315331.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235556',4526520,'2745','415',560840.55,562861.67,2021.12,333484.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','235556',4526521,'2746','415',278691.23,278691.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235556',4526522,'2747','415',587409.65,589549.54,2139.89,353081.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','235556',4526523,'2748','415',458405.09,459654.05,1248.96,206078.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','235556',4526524,'2749','415',254721.88,255886.42,1164.54,192149.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','235556',4526525,'2750','415',510034.45,510054.15,19.70,3250.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','235556',4526526,'2751','415',80747.90,82537.76,1789.86,295326.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','235556',4526527,'2752','415',572449.40,574540.75,2091.35,345072.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','235556',4526528,'2753','415',75561.26,75561.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235556',4526529,'2754','415',543822.07,545803.22,1981.15,326889.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','235556',4526530,'2755','415',88230.66,89232.94,1002.28,165376.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','235556',4526531,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235556',4526532,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235556',4526533,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235556',4526534,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235739',4530001,'2744','415',315331.67,317579.18,2247.51,370839.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','235739',4530002,'2745','415',562861.67,564744.43,1882.76,310655.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','235739',4530003,'2746','415',278691.23,279585.14,893.91,147495.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','235739',4530004,'2747','415',589549.54,592120.56,2571.02,424218.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','235739',4530005,'2748','415',459654.05,461555.38,1901.33,313719.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','235739',4530006,'2749','415',255886.42,255886.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235739',4530007,'2750','415',510054.15,510054.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235739',4530008,'2751','415',82537.76,85111.10,2573.34,424601.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','235739',4530009,'2752','415',574540.75,577475.41,2934.66,484218.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','235739',4530010,'2753','415',75561.26,75561.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235739',4530011,'2754','415',545803.22,548115.06,2311.84,381453.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','235739',4530012,'2755','415',89232.94,89806.86,573.92,94696.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','235739',4530013,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235739',4530014,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235739',4530015,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235739',4530016,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235924',4532969,'2744','415',317579.18,317823.70,244.52,40345.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','235924',4532970,'2745','415',564744.43,567836.27,3091.84,510153.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','235924',4532971,'2746','415',279585.14,280383.32,798.18,131699.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','235924',4532972,'2747','415',592120.56,594660.92,2540.36,419159.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','235924',4532973,'2748','415',461555.38,463939.06,2383.68,393307.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','235924',4532974,'2749','415',255886.42,257077.33,1190.91,196500.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','235924',4532975,'2750','415',510054.15,510054.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235924',4532976,'2751','415',85111.10,86642.61,1531.51,252699.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','235924',4532977,'2752','415',577475.41,579882.26,2406.85,397130.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','235924',4532978,'2753','415',75561.26,75561.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235924',4532979,'2754','415',548115.06,550213.60,2098.54,346259.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','235924',4532980,'2755','415',89806.86,89806.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235924',4532981,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235924',4532982,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235924',4532983,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235924',4532984,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','235999',4534505,'2744','415',317823.70,320103.73,2270.03,374554.95,0.00,0.00,10.00,0.00,0.00),('1','185','935','235999',4534506,'2745','415',567836.27,570013.90,2167.63,357658.95,0.00,0.00,10.00,0.00,0.00),('1','185','935','235999',4534507,'2746','415',280383.32,282721.52,2328.20,384153.00,0.00,0.00,10.00,0.00,0.00),('1','185','935','235999',4534508,'2747','415',594660.92,597118.58,2447.66,403863.90,0.00,0.00,10.00,0.00,0.00),('1','185','935','235999',4534509,'2748','415',463939.06,466053.66,2104.60,347259.00,0.00,0.00,10.00,0.00,0.00),('1','185','935','235999',4534510,'2749','415',257077.33,259445.37,2348.04,387426.60,0.00,0.00,20.00,0.00,0.00),('1','185','936','235999',4534511,'2750','415',510054.15,510054.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235999',4534512,'2751','415',86642.61,87433.68,791.07,130526.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','235999',4534513,'2752','415',579882.26,580784.21,901.95,148821.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','235999',4534514,'2753','415',75561.26,75561.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','235999',4534515,'2754','415',550213.60,550817.03,603.43,99565.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','235999',4534516,'2755','415',89806.86,90013.74,206.88,34135.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','235999',4534517,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','235999',4534518,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235999',4534519,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','235999',4534520,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236153',4537253,'2744','415',320103.73,320334.29,230.56,38042.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','236153',4537254,'2745','415',570013.90,570707.58,693.68,114457.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','236153',4537255,'2746','415',282721.52,282721.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236153',4537256,'2747','415',597118.58,597937.40,818.82,135105.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','236153',4537257,'2748','415',466053.66,466635.35,581.69,95978.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','236153',4537258,'2749','415',259445.37,259445.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236153',4537259,'2750','415',510054.15,510427.04,372.89,61526.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','236153',4537260,'2751','415',87433.68,90551.72,3118.04,514476.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','236153',4537261,'2752','415',580784.21,583892.89,3108.68,512932.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','236153',4537262,'2753','415',75561.26,77509.79,1948.53,321507.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','236153',4537263,'2754','415',550817.03,553421.62,2604.59,429757.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','236153',4537264,'2755','415',90013.74,91634.73,1620.99,267463.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','236153',4537265,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236153',4537266,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236153',4537267,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236153',4537268,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236225',4538582,'2744','415',320334.29,321007.71,673.42,111114.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','236225',4538583,'2745','415',570707.58,571629.15,921.57,152059.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','236225',4538584,'2746','415',282721.52,282885.76,164.24,27099.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','236225',4538585,'2747','415',597937.40,598853.57,916.17,151168.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','236225',4538586,'2748','415',466635.35,467576.31,940.96,155258.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','236225',4538587,'2749','415',259445.37,259895.20,449.83,74221.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','236225',4538588,'2750','415',510427.04,513090.30,2663.26,439437.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','236225',4538589,'2751','415',90551.72,93081.00,2529.28,417331.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','236225',4538590,'2752','415',583892.89,586030.85,2137.96,352763.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','236225',4538591,'2753','415',77509.79,80222.61,2712.82,447615.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','236225',4538592,'2754','415',553421.62,555893.56,2471.94,407870.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','236225',4538593,'2755','415',91634.73,94080.18,2445.45,403499.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','236225',4538594,'2756','416',197117.91,197117.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236225',4538595,'2757','416',156694.38,156694.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236225',4538596,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236225',4538597,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236408',4541721,'2744','415',321007.71,321007.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236408',4541722,'2745','415',571629.15,573749.61,2120.46,349875.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','236408',4541723,'2746','415',282885.76,283606.27,720.51,118884.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','236408',4541724,'2747','415',598853.57,600285.87,1432.30,236329.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','236408',4541725,'2748','415',467576.31,469588.47,2012.16,332006.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','236408',4541726,'2749','415',259895.20,260643.35,748.15,123444.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','236408',4541727,'2750','415',513090.30,515823.62,2733.32,450997.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','236408',4541728,'2751','415',93081.00,93081.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236408',4541729,'2752','415',586030.85,586036.48,5.63,928.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','236408',4541730,'2753','415',80222.61,82481.88,2259.27,372779.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','236408',4541731,'2754','415',555893.56,557685.34,1791.78,295643.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','236408',4541732,'2755','415',94080.18,94681.70,601.52,99250.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','236408',4541733,'2756','416',197117.91,197598.62,480.71,168248.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','236408',4541734,'2757','416',156694.38,156966.32,271.94,95179.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236408',4541735,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236408',4541736,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236498',4543323,'2744','415',321007.71,322439.40,1431.69,236228.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','236498',4543324,'2745','415',573749.61,576169.04,2419.43,399205.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','236498',4543325,'2746','415',283606.27,285879.08,2272.81,375013.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','236498',4543326,'2747','415',600285.87,602609.69,2323.82,383430.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','236498',4543327,'2748','415',469588.47,471520.91,1932.44,318852.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','236498',4543328,'2749','415',260643.35,263134.58,2491.23,411052.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','236498',4543329,'2750','415',515823.62,516566.61,742.99,122593.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','236498',4543330,'2751','415',93081.56,93081.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236498',4543331,'2752','415',586036.48,586895.90,859.42,141804.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','236498',4543332,'2753','415',82481.88,82481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236498',4543333,'2754','415',557685.34,558288.37,603.03,99499.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','236498',4543334,'2755','415',94681.70,94683.52,1.82,300.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','236498',4543335,'2756','416',197598.62,198269.87,671.25,234937.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','236498',4543336,'2757','416',156966.32,157034.04,67.72,23702.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236498',4543337,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236498',4543338,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236651',4545839,'2744','415',322439.40,325192.15,2752.75,454203.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','236651',4545840,'2745','415',576169.04,578582.02,2412.98,398141.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','236651',4545841,'2746','415',285879.08,288254.07,2374.99,391873.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','236651',4545842,'2747','415',602609.69,605224.83,2615.14,431498.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','236651',4545843,'2748','415',471520.91,473693.91,2173.00,358545.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236651',4545844,'2749','415',263134.58,264872.62,1738.04,286776.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','236651',4545845,'2750','415',516566.61,516566.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236651',4545846,'2751','415',93081.56,93081.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236651',4545847,'2752','415',586895.90,586895.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236651',4545848,'2753','415',82481.88,82481.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236651',4545849,'2754','415',558288.37,558288.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236651',4545850,'2755','415',94683.52,94683.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236651',4545851,'2756','416',198269.87,198681.67,411.80,144130.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236651',4545852,'2757','416',157034.04,157434.90,400.86,140301.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236651',4545853,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236651',4545854,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236755',4547462,'2744','415',325192.15,327231.94,2039.79,336565.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','236755',4547463,'2745','415',578582.02,580896.22,2314.20,381843.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236755',4547464,'2746','415',288254.07,290489.31,2235.24,368814.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','236755',4547465,'2747','415',605224.83,607802.72,2577.89,425351.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','236755',4547466,'2748','415',473693.91,475887.02,2193.11,361863.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','236755',4547467,'2749','415',264872.62,266889.62,2017.00,332805.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236755',4547468,'2750','415',516566.61,517777.39,1210.78,199778.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','236755',4547469,'2751','415',93081.56,93081.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236755',4547470,'2752','415',586895.90,587470.74,574.84,94848.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','236755',4547471,'2753','415',82481.88,82799.77,317.89,52451.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','236755',4547472,'2754','415',558288.37,559348.00,1059.63,174838.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','236755',4547473,'2755','415',94683.52,94908.22,224.70,37075.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','236755',4547474,'2756','416',198681.67,199687.19,1005.52,351932.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236755',4547475,'2757','416',157434.90,158293.61,858.71,300548.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','236755',4547476,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236755',4547477,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236866',4549581,'2744','415',327231.94,329153.39,1921.45,317039.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','236866',4549582,'2745','415',580896.22,582007.13,1110.91,183300.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','236866',4549583,'2746','415',290489.31,291067.00,577.69,95318.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','236866',4549584,'2747','415',607802.72,609561.69,1758.97,290230.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','236866',4549585,'2748','415',475887.02,477568.58,1681.56,277457.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','236866',4549586,'2749','415',266889.62,268142.71,1253.09,206759.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','236866',4549587,'2750','415',517777.39,519368.38,1590.99,262513.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','236866',4549588,'2751','415',93081.56,93513.50,431.94,71270.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','236866',4549589,'2752','415',587470.74,589398.50,1927.76,318080.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','236866',4549590,'2753','415',82799.77,83129.48,329.71,54402.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','236866',4549591,'2754','415',559348.00,561636.73,2288.73,377640.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','236866',4549592,'2755','415',94908.22,95068.50,160.28,26446.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','236866',4549593,'2756','416',199687.19,200830.29,1143.10,400085.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236866',4549594,'2757','416',158293.61,158466.18,172.57,60399.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','236866',4549595,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236866',4549596,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236948',4551078,'2744','415',329153.39,329736.81,583.42,96264.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','236948',4551079,'2745','415',582007.13,582973.97,966.84,159528.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','236948',4551080,'2746','415',291067.00,291142.15,75.15,12399.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','236948',4551081,'2747','415',609561.69,611008.41,1446.72,238708.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','236948',4551082,'2748','415',477568.58,477568.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','236948',4551083,'2749','415',268142.71,269079.34,936.63,154543.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','236948',4551084,'2750','415',519368.38,521894.11,2525.73,416745.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','236948',4551085,'2751','415',93513.50,95329.50,1816.00,299640.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','236948',4551086,'2752','415',589398.50,591655.79,2257.29,372452.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','236948',4551087,'2753','415',83129.48,85364.77,2235.29,368822.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','236948',4551088,'2754','415',561636.73,563998.84,2362.11,389748.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','236948',4551089,'2755','415',95068.50,96724.50,1656.00,273240.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','236948',4551090,'2756','416',200830.29,201554.16,723.87,253354.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','236948',4551091,'2757','416',158466.18,159241.60,775.42,271397.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236948',4551092,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','236948',4551093,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237080',4553367,'2744','415',329736.81,331651.80,1914.99,315973.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','237080',4553368,'2745','415',582973.97,585410.00,2436.03,401944.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','237080',4553369,'2746','415',291142.15,293683.61,2541.46,419340.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','237080',4553370,'2747','415',611008.41,613416.99,2408.58,397415.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','237080',4553371,'2748','415',477568.58,479877.15,2308.57,380914.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','237080',4553372,'2749','415',269079.34,271112.39,2033.05,335453.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','237080',4553373,'2750','415',521894.11,521894.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237080',4553374,'2751','415',95329.50,95329.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237080',4553375,'2752','415',591655.79,591655.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237080',4553376,'2753','415',85364.77,85364.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237080',4553377,'2754','415',563998.84,563998.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237080',4553378,'2755','415',96724.50,96724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237080',4553379,'2756','416',201554.16,202232.60,678.44,237454.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237080',4553380,'2757','416',159241.60,159858.43,616.83,215890.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','237080',4553381,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237080',4553382,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237136',4554490,'2744','415',331651.80,333530.18,1878.38,309932.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','237136',4554491,'2745','415',585410.00,587469.19,2059.19,339766.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','237136',4554492,'2746','415',293683.61,296138.66,2455.05,405083.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','237136',4554493,'2747','415',613416.99,615835.34,2418.35,399027.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','237136',4554494,'2748','415',479877.15,482059.45,2182.30,360079.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','237136',4554495,'2749','415',271112.39,272663.05,1550.66,255858.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','237136',4554496,'2750','415',521894.11,521894.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237136',4554497,'2751','415',95329.50,95329.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237136',4554498,'2752','415',591655.79,592206.54,550.75,90873.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','237136',4554499,'2753','415',85364.77,85364.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237136',4554500,'2754','415',563998.84,564264.93,266.09,43904.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','237136',4554501,'2755','415',96724.50,96724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237136',4554502,'2756','416',202232.60,202520.58,287.98,100793.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237136',4554503,'2757','416',159858.43,161252.61,1394.18,487963.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237136',4554504,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237136',4554505,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237281',4556889,'2744','415',333530.18,335135.63,1605.45,264899.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','237281',4556890,'2745','415',587469.19,588749.92,1280.73,211320.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','237281',4556891,'2746','415',296138.66,296865.60,726.94,119945.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','237281',4556892,'2747','415',615835.34,617700.67,1865.33,307779.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','237281',4556893,'2748','415',482059.45,483504.55,1445.10,238441.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','237281',4556894,'2749','415',272663.05,274555.59,1892.54,312269.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','237281',4556895,'2750','415',521894.11,523714.03,1819.92,300286.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','237281',4556896,'2751','415',95329.50,95844.61,515.11,84993.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','237281',4556897,'2752','415',592206.54,594375.19,2168.65,357827.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','237281',4556898,'2753','415',85364.77,85364.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237281',4556899,'2754','415',564264.93,565415.40,1150.47,189827.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','237281',4556900,'2755','415',96724.50,96724.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237281',4556901,'2756','416',202520.58,202693.43,172.85,60497.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','237281',4556902,'2757','416',161252.61,161674.18,421.57,147549.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','237281',4556903,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237281',4556904,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237377',4558716,'2744','415',335135.63,336313.25,1177.62,194307.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','237377',4558717,'2745','415',588749.92,589914.67,1164.75,192183.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','237377',4558718,'2746','415',296865.60,297565.66,700.06,115509.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','237377',4558719,'2747','415',617700.67,619013.20,1302.53,214917.45,0.00,0.00,10.00,0.00,0.00),('1','185','935','237377',4558720,'2748','415',483504.55,484566.46,1061.91,175215.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','237377',4558721,'2749','415',274555.59,275055.03,499.44,82407.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','237377',4558722,'2750','415',523714.03,526292.15,2568.12,423739.80,0.00,0.00,10.00,0.00,0.00),('1','185','936','237377',4558723,'2751','415',95844.61,96868.71,1024.10,168976.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','237377',4558724,'2752','415',594375.19,597310.74,2925.55,482715.75,0.00,0.00,10.00,0.00,0.00),('1','185','936','237377',4558725,'2753','415',85364.77,86391.41,1026.64,169395.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','237377',4558726,'2754','415',565415.40,567664.89,2249.49,371165.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','237377',4558727,'2755','415',96724.50,98363.63,1639.13,270456.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','237377',4558728,'2756','416',202693.43,203780.80,1087.37,380579.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','237377',4558729,'2757','416',161674.18,161874.89,200.71,70248.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','237377',4558730,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237377',4558731,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237507',4561118,'2744','415',336313.25,336313.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237507',4561119,'2745','415',589914.67,589914.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237507',4561120,'2746','415',297565.56,297565.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237507',4561121,'2747','415',619013.20,619013.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237507',4561122,'2748','415',484566.46,484566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237507',4561123,'2749','415',275055.03,275055.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237507',4561124,'2750','415',526292.15,529100.04,2807.89,463301.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','237507',4561125,'2751','415',96868.71,99530.91,2662.20,439263.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237507',4561126,'2752','415',597310.74,599853.26,2542.52,419515.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','237507',4561127,'2753','415',86391.41,88943.10,2551.69,421028.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','237507',4561128,'2754','415',567664.89,569911.98,2247.09,370769.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','237507',4561129,'2755','415',98363.63,100162.00,1798.37,296731.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','237507',4561130,'2756','416',203780.80,204270.93,490.13,171545.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','237507',4561131,'2757','416',161874.89,162209.21,334.32,117012.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237507',4561132,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237507',4561133,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237600',4562715,'2744','415',336313.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237600',4562716,'2745','415',589914.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237600',4562717,'2746','415',297565.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237600',4562718,'2747','415',619013.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237600',4562719,'2748','415',484566.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237600',4562720,'2749','415',275055.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237600',4562721,'2750','415',529100.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237600',4562722,'2751','415',99530.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237600',4562723,'2752','415',599853.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237600',4562724,'2753','415',88943.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237600',4562725,'2754','415',569911.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237600',4562726,'2755','415',100162.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237600',4562727,'2756','416',204270.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237600',4562728,'2757','416',162209.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237600',4562729,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237600',4562730,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237601',4562731,'2744','415',336313.25,337167.04,853.79,140875.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','237601',4562732,'2745','415',589914.67,590847.56,932.89,153926.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','237601',4562733,'2746','415',297565.56,298826.94,1261.38,208127.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','237601',4562734,'2747','415',619014.87,619970.55,955.68,157687.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','237601',4562735,'2748','415',484566.46,485743.70,1177.24,194244.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','237601',4562736,'2749','415',275055.03,275854.19,799.16,131861.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','237601',4562737,'2750','415',529100.04,530660.29,1560.25,257441.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','237601',4562738,'2751','415',99530.91,100331.73,800.82,132135.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','237601',4562739,'2752','415',599853.26,601557.29,1704.03,281164.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','237601',4562740,'2753','415',88943.10,90184.26,1241.16,204791.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','237601',4562741,'2754','415',569911.98,571140.98,1229.00,202785.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237601',4562742,'2755','415',100162.00,101121.91,959.91,158385.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','237601',4562743,'2756','416',204270.93,204780.81,509.88,178458.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237601',4562744,'2757','416',162209.21,162295.80,86.59,30306.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','237601',4562745,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237601',4562746,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237739',4565069,'2744','415',337167.04,340050.37,2883.33,475749.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','237739',4565070,'2745','415',590847.56,594296.74,3449.18,569114.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','237739',4565071,'2746','415',298826.94,302134.33,3307.39,545719.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','237739',4565072,'2747','415',619970.55,623685.72,3715.17,613003.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','237739',4565073,'2748','415',485743.70,488687.37,2943.67,485705.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','237739',4565074,'2749','415',275854.19,279111.48,3257.29,537452.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','237739',4565075,'2750','415',530660.29,530660.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237739',4565076,'2751','415',100331.73,100331.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237739',4565077,'2752','415',601557.29,601557.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237739',4565078,'2753','415',90184.26,90184.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237739',4565079,'2754','415',571140.98,571140.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237739',4565080,'2755','415',101121.91,101121.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237739',4565081,'2756','416',204780.81,204780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237739',4565082,'2757','416',162295.80,162295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237739',4565083,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237739',4565084,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237860',4567031,'2744','415',340050.37,341726.30,1675.93,276528.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','237860',4567032,'2745','415',594296.74,596404.83,2108.09,347834.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','237860',4567033,'2746','415',302134.33,303763.09,1628.76,268745.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','237860',4567034,'2747','415',623685.72,625941.18,2255.46,372150.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','237860',4567035,'2748','415',488687.37,490726.37,2039.00,336435.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','237860',4567036,'2749','415',279111.48,280081.16,969.68,159997.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','237860',4567037,'2750','415',530660.29,531429.14,768.85,126860.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','237860',4567038,'2751','415',100331.73,100331.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237860',4567039,'2752','415',601557.29,603077.74,1520.45,250874.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','237860',4567040,'2753','415',90184.26,90326.26,142.00,23430.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','237860',4567041,'2754','415',571140.98,572301.19,1160.21,191434.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','237860',4567042,'2755','415',101121.91,102454.98,1333.07,219956.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','237860',4567043,'2756','416',204780.81,204780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','237860',4567044,'2757','416',162295.80,162295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237860',4567045,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','237860',4567046,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238023',4569607,'2744','415',341726.30,343937.14,2210.84,364788.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','238023',4569608,'2745','415',596404.83,598248.42,1843.59,304192.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','238023',4569609,'2746','415',303763.09,304896.94,1133.85,187085.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','238023',4569610,'2747','415',625941.18,627822.69,1881.51,310449.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','238023',4569611,'2748','415',490726.37,492050.19,1323.82,218430.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','238023',4569612,'2749','415',280081.16,281293.82,1212.66,200088.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','238023',4569613,'2750','415',531429.14,533368.69,1939.55,320025.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','238023',4569614,'2751','415',100331.73,100590.51,258.78,42698.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','238023',4569615,'2752','415',603077.74,605236.19,2158.45,356144.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','238023',4569616,'2753','415',90326.26,90898.04,571.78,94343.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','238023',4569617,'2754','415',572301.19,574027.61,1726.42,284859.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','238023',4569618,'2755','415',102454.98,102542.09,87.11,14373.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','238023',4569619,'2756','416',204780.81,204780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238023',4569620,'2757','416',162295.80,162295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238023',4569621,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238023',4569622,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238095',4570901,'2744','415',343937.14,346276.60,2339.46,386010.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','238095',4570902,'2745','415',598248.42,600290.52,2042.10,336946.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','238095',4570903,'2746','415',304896.94,305480.56,583.62,96297.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','238095',4570904,'2747','415',627822.69,630270.61,2447.92,403906.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','238095',4570905,'2748','415',492050.19,494378.56,2328.37,384181.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','238095',4570906,'2749','415',281293.82,282003.01,709.19,117016.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','238095',4570907,'2750','415',533368.69,535835.29,2466.60,406989.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238095',4570908,'2751','415',100590.51,101247.52,657.01,108406.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','238095',4570909,'2752','415',605236.19,608156.25,2920.06,481809.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','238095',4570910,'2753','415',90898.04,90898.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238095',4570911,'2754','415',574027.61,576051.11,2023.50,333877.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','238095',4570912,'2755','415',102542.09,103706.25,1164.16,192086.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','238095',4570913,'2756','416',204780.81,204780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238095',4570914,'2757','416',162295.80,162295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238095',4570915,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238095',4570916,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238242',4573357,'2744','415',346276.60,348173.32,1896.72,312958.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','238242',4573358,'2745','415',600290.52,602648.65,2358.13,389091.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','238242',4573359,'2746','415',305480.56,306380.34,899.78,148463.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','238242',4573360,'2747','415',630270.61,632833.85,2563.24,422934.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','238242',4573361,'2748','415',494378.56,497020.27,2641.71,435882.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','238242',4573362,'2749','415',282003.01,282003.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238242',4573363,'2750','415',535835.29,537995.78,2160.49,356480.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','238242',4573364,'2751','415',101247.52,101247.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238242',4573365,'2752','415',608156.25,610435.75,2279.50,376117.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','238242',4573366,'2753','415',90898.04,91838.30,940.26,155142.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','238242',4573367,'2754','415',576051.11,578888.19,2837.08,468118.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','238242',4573368,'2755','415',103706.25,103706.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238242',4573369,'2756','416',204780.81,204780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238242',4573370,'2757','416',162295.80,162295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238242',4573371,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238242',4573372,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238344',4575178,'2744','415',348173.32,350330.93,2157.61,356005.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','238344',4575179,'2745','415',602648.65,605057.40,2408.75,397443.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','238344',4575180,'2746','415',306380.34,307316.03,935.69,154388.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','238344',4575181,'2747','415',632833.85,635457.70,2623.85,432935.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','238344',4575182,'2748','415',497020.27,497491.41,471.14,77738.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','238344',4575183,'2749','415',282003.01,285108.90,3105.89,512471.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','238344',4575184,'2750','415',537995.78,540032.66,2036.88,336085.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','238344',4575185,'2751','415',101247.52,101949.42,701.90,115813.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','238344',4575186,'2752','415',610435.75,612822.69,2386.94,393845.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','238344',4575187,'2753','415',91838.30,92648.31,810.01,133651.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','238344',4575188,'2754','415',578888.19,580708.53,1820.34,300356.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','238344',4575189,'2755','415',103706.25,104875.48,1169.23,192922.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','238344',4575190,'2756','416',204780.81,204780.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238344',4575191,'2757','416',162295.80,162295.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238344',4575192,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238344',4575193,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238511',4577830,'2744','415',350330.93,352585.53,2254.60,372009.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238511',4577831,'2745','415',605057.40,607174.73,2117.33,349359.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','238511',4577832,'2746','415',307316.03,308461.36,1145.33,188979.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','238511',4577833,'2747','415',635457.70,637763.22,2305.52,380410.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','238511',4577834,'2748','415',497491.41,497491.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238511',4577835,'2749','415',285108.90,286840.88,1731.98,285776.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','238511',4577836,'2750','415',540032.66,542380.10,2347.44,387327.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','238511',4577837,'2751','415',101949.42,101949.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238511',4577838,'2752','415',612822.69,616299.10,3476.41,573607.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','238511',4577839,'2753','415',92648.31,92648.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238511',4577840,'2754','415',580708.53,583656.89,2948.36,486479.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','238511',4577841,'2755','415',104875.48,104875.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238511',4577842,'2756','416',204780.81,206114.81,1334.00,466900.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238511',4577843,'2757','416',162295.80,162490.80,195.00,68250.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238511',4577844,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238511',4577845,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238591',4579293,'2744','415',352585.53,353980.37,1394.84,230148.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','238591',4579294,'2745','415',607174.73,608933.32,1758.59,290167.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','238591',4579295,'2746','415',308461.36,310101.73,1640.37,270661.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','238591',4579296,'2747','415',637763.22,640505.96,2742.74,452552.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','238591',4579297,'2748','415',497491.41,499545.03,2053.62,338847.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','238591',4579298,'2749','415',286840.88,289083.05,2242.17,369958.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','238591',4579299,'2750','415',542380.10,544636.09,2255.99,372238.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','238591',4579300,'2751','415',101949.42,102878.90,929.48,153364.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','238591',4579301,'2752','415',616299.10,619093.95,2794.85,461150.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','238591',4579302,'2753','415',92648.31,93358.50,710.19,117181.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','238591',4579303,'2754','415',583656.89,586102.00,2445.11,403443.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','238591',4579304,'2755','415',104928.63,105921.88,993.25,163886.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','238591',4579305,'2756','416',206114.81,206767.64,652.83,228490.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','238591',4579306,'2757','416',162490.80,163518.23,1027.43,359600.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','238591',4579307,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238591',4579308,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','238743',4581817,'2744','415',353980.37,356740.11,2759.74,455357.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','238743',4581818,'2745','415',608933.32,611229.10,2295.78,378803.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','238743',4581819,'2746','415',310101.73,311740.89,1639.16,270461.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','238743',4581820,'2747','415',640505.96,643228.54,2722.58,449225.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','238743',4581821,'2748','415',499545.03,502471.80,2926.77,482917.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','238743',4581822,'2749','415',289083.05,290048.62,965.57,159319.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','238743',4581823,'2750','415',544636.09,548254.70,3618.61,597070.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','238743',4581824,'2751','415',102878.90,103090.30,211.40,34881.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','238743',4581825,'2752','415',619093.95,621481.71,2387.76,393980.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','238743',4581826,'2753','415',93358.50,94626.88,1268.38,209282.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','238743',4581827,'2754','415',586102.00,589419.06,3317.06,547314.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','238743',4581828,'2755','415',105921.88,105921.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','238743',4581829,'2756','416',206767.64,207342.45,574.81,201183.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','238743',4581830,'2757','416',163518.23,163818.03,299.80,104930.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238743',4581831,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','238743',4581832,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241756',4633616,'2744','415',356740.11,356740.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241756',4633617,'2745','415',611229.10,611229.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241756',4633618,'2746','415',311740.89,312890.80,1149.91,189735.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','241756',4633619,'2747','415',643228.54,645074.10,1845.56,304517.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','241756',4633620,'2748','415',502471.80,503930.87,1459.07,240746.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','241756',4633621,'2749','415',290048.62,291796.84,1748.22,288456.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','241756',4633622,'2750','415',548254.70,549612.27,1357.57,223999.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','241756',4633623,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241756',4633624,'2752','415',621481.71,622802.13,1320.42,217869.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','241756',4633625,'2753','415',94626.88,95205.97,579.09,95549.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','241756',4633626,'2754','415',589419.06,591113.55,1694.49,279590.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','241756',4633627,'2755','415',105921.88,106540.44,618.56,102062.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','241756',4633628,'2756','416',207342.45,207360.34,17.89,6261.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','241756',4633629,'2757','416',163818.03,164160.14,342.11,119738.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','241756',4633630,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','241756',4633631,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241786',4634177,'2744','415',356740.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241786',4634178,'2745','415',611229.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241786',4634179,'2746','415',312890.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241786',4634180,'2747','415',645074.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241786',4634181,'2748','415',503930.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241786',4634182,'2749','415',291796.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241786',4634183,'2750','415',549612.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241786',4634184,'2751','415',103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241786',4634185,'2752','415',622802.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241786',4634186,'2753','415',95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241786',4634187,'2754','415',591113.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241786',4634188,'2755','415',106540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','241786',4634189,'2756','416',207360.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','241786',4634190,'2757','416',164160.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','241786',4634191,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','241786',4634192,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241877',4635555,'2744','415',582.73,582.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241877',4635556,'2745','415',641.63,641.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241877',4635557,'2746','415',312890.80,314853.97,1953.17,322273.05,0.00,0.00,10.00,0.00,0.00),('1','185','935','241877',4635558,'2747','415',645074.10,647851.45,2767.35,456612.75,0.00,0.00,10.00,0.00,0.00),('1','185','935','241877',4635559,'2748','415',503930.87,506943.64,3012.77,497107.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','241877',4635560,'2749','415',291796.84,294512.20,2715.36,448034.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','241877',4635561,'2750','415',549612.27,549612.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241877',4635562,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241877',4635563,'2752','415',622802.13,622802.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241877',4635564,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241877',4635565,'2754','415',591113.55,591113.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241877',4635566,'2755','415',106540.44,106540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','241877',4635567,'2756','416',207360.34,207514.32,153.98,53893.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','241877',4635568,'2757','416',164160.14,164621.55,461.41,161493.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','241877',4635569,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','241877',4635570,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241920',4636562,'2744','415',582.73,1740.55,1157.82,191040.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','241920',4636563,'2745','415',641.63,2545.43,1903.80,314127.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','241920',4636564,'2746','415',314853.97,317001.75,2147.78,354383.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','241920',4636565,'2747','415',647851.45,650222.52,2371.07,391226.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','241920',4636566,'2748','415',506943.64,509828.05,2884.41,475927.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','241920',4636567,'2749','415',294512.20,295551.41,1039.21,171469.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','241920',4636568,'2750','415',549612.27,549612.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241920',4636569,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241920',4636570,'2752','415',622802.13,622802.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241920',4636571,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241920',4636572,'2754','415',591113.55,591113.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','241920',4636573,'2755','415',106540.44,106540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','241920',4636574,'2756','416',207514.32,208168.05,653.73,228805.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','241920',4636575,'2757','416',164621.55,165545.85,924.30,323505.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','241920',4636576,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','241920',4636577,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242023',4638177,'2744','415',1740.55,2365.35,624.80,103092.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242023',4638178,'2745','415',2545.43,4813.03,2267.60,374154.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242023',4638179,'2746','415',317001.75,317237.34,235.59,38872.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','242023',4638180,'2747','415',650222.52,652599.54,2377.02,392208.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','242023',4638181,'2748','415',509828.05,512838.06,3010.01,496651.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','242023',4638182,'2749','415',295551.41,295551.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242023',4638183,'2750','415',549612.27,551834.65,2222.38,366692.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','242023',4638184,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242023',4638185,'2752','415',622802.13,625125.66,2323.53,383382.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','242023',4638186,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242023',4638187,'2754','415',591113.55,593159.49,2045.94,337580.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','242023',4638188,'2755','415',106540.44,106540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242023',4638189,'2756','416',208168.05,208834.66,666.61,233313.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','242023',4638190,'2757','416',165545.85,166940.11,1394.26,487991.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242023',4638191,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242023',4638192,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242220',4641707,'2744','415',2365.35,3879.44,1494.09,246524.85,0.00,0.00,20.00,0.00,0.00),('1','185','935','242220',4641708,'2745','415',4813.03,6278.45,1455.42,240144.30,0.00,0.00,10.00,0.00,0.00),('1','185','935','242220',4641709,'2746','415',317237.34,317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242220',4641710,'2747','415',652599.54,655628.29,3018.75,498093.75,0.00,0.00,10.00,0.00,0.00),('1','185','935','242220',4641711,'2748','415',512838.06,515197.78,2349.72,387703.80,0.00,0.00,10.00,0.00,0.00),('1','185','935','242220',4641712,'2749','415',295551.41,295551.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242220',4641713,'2750','415',551834.65,554267.87,2423.22,399831.30,0.00,0.00,10.00,0.00,0.00),('1','185','936','242220',4641714,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242220',4641715,'2752','415',625125.66,627710.23,2574.57,424804.05,0.00,0.00,10.00,0.00,0.00),('1','185','936','242220',4641716,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242220',4641717,'2754','415',593159.49,595271.97,2102.48,346909.20,0.00,0.00,10.00,0.00,0.00),('1','185','936','242220',4641718,'2755','415',106540.44,106540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242220',4641719,'2756','416',208834.66,209414.50,579.84,202944.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242220',4641720,'2757','416',166940.11,167345.40,405.29,141851.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','242220',4641721,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242220',4641722,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242240',4642005,'2744','415',3879.44,4733.99,854.55,141000.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','242240',4642006,'2745','415',6278.45,8015.45,1737.00,286605.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242240',4642007,'2746','415',317237.34,317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242240',4642008,'2747','415',655628.29,658475.06,2846.77,469717.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','242240',4642009,'2748','415',515197.78,518190.50,2992.72,493798.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','242240',4642010,'2749','415',295551.41,295551.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242240',4642011,'2750','415',554267.87,556766.30,2498.43,412240.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','242240',4642012,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242240',4642013,'2752','415',627710.23,630199.69,2489.46,410760.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','242240',4642014,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242240',4642015,'2754','415',595271.97,597668.84,2396.87,395483.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','242240',4642016,'2755','415',106540.44,106540.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242240',4642017,'2756','416',209414.50,209963.52,549.02,192157.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242240',4642018,'2757','416',167345.40,168376.41,1031.01,360853.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','242240',4642019,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242240',4642020,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242442',4645565,'2744','415',4733.99,5586.56,852.57,140674.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','242442',4645566,'2745','415',8015.45,10780.79,2765.34,456281.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','242442',4645567,'2746','415',317237.34,317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242442',4645568,'2747','415',658475.06,661118.09,2643.03,436099.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','242442',4645569,'2748','415',518190.50,520324.92,2134.42,352179.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','242442',4645570,'2749','415',295551.41,295996.24,444.83,73396.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','242442',4645571,'2750','415',556766.30,558970.52,2204.22,363696.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','242442',4645572,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242442',4645573,'2752','415',630199.69,633127.57,2927.88,483100.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','242442',4645574,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242442',4645575,'2754','415',597668.84,599753.03,2084.19,343891.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','242442',4645576,'2755','415',106540.44,107451.15,910.71,150267.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','242442',4645577,'2756','416',209963.52,210593.96,630.44,220654.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242442',4645578,'2757','416',168376.41,168682.31,305.90,107065.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242442',4645579,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242442',4645580,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242487',4646305,'2744','415',5586.56,5712.43,125.87,20768.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','242487',4646306,'2745','415',10780.79,13968.47,3187.68,525967.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','242487',4646307,'2746','415',317237.34,317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242487',4646308,'2747','415',661118.09,663915.51,2797.42,461574.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','242487',4646309,'2748','415',520324.92,521902.37,1577.45,260279.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','242487',4646310,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242487',4646311,'2750','415',558970.52,561957.40,2986.88,492835.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','242487',4646312,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242487',4646313,'2752','415',633127.57,635911.72,2784.15,459384.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','242487',4646314,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242487',4646315,'2754','415',599753.03,602180.40,2427.37,400516.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','242487',4646316,'2755','415',107451.15,107451.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242487',4646317,'2756','416',210593.96,210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242487',4646318,'2757','416',168682.31,168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242487',4646319,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242487',4646320,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242690',4649961,'2744','415',5712.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242690',4649962,'2745','415',13968.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242690',4649963,'2746','415',317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242690',4649964,'2747','415',663915.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242690',4649965,'2748','415',521902.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242690',4649966,'2749','415',295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242690',4649967,'2750','415',561957.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242690',4649968,'2751','415',103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242690',4649969,'2752','415',635911.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242690',4649970,'2753','415',95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242690',4649971,'2754','415',602180.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242690',4649972,'2755','415',107451.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242690',4649973,'2756','416',210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242690',4649974,'2757','416',168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242690',4649975,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242690',4649976,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242691',4649977,'2744','415',5712.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242691',4649978,'2745','415',13968.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242691',4649979,'2746','415',317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242691',4649980,'2747','415',663915.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242691',4649981,'2748','415',521902.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242691',4649982,'2749','415',295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242691',4649983,'2750','415',561957.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242691',4649984,'2751','415',103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242691',4649985,'2752','415',635911.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242691',4649986,'2753','415',95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242691',4649987,'2754','415',602180.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242691',4649988,'2755','415',107451.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242691',4649989,'2756','416',210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242691',4649990,'2757','416',168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242691',4649991,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242691',4649992,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242694',4650018,'2744','415',5712.43,7556.12,1843.69,304208.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','242694',4650019,'2745','415',13968.47,16273.68,2305.21,380359.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','242694',4650020,'2746','415',317237.34,317237.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242694',4650021,'2747','415',663915.51,666860.86,2945.35,485982.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','242694',4650022,'2748','415',521902.37,524213.42,2311.05,381323.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','242694',4650023,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242694',4650024,'2750','415',561957.40,564269.23,2311.83,381451.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','242694',4650025,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242694',4650026,'2752','415',635911.72,638762.63,2850.91,470400.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','242694',4650027,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242694',4650028,'2754','415',602180.40,604115.38,1934.98,319271.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','242694',4650029,'2755','415',107451.15,108246.49,795.34,131231.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','242694',4650030,'2756','416',210593.96,210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242694',4650031,'2757','416',168682.31,168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242694',4650032,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242694',4650033,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242715',4650351,'2744','415',7556.12,8198.20,642.08,105943.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','242715',4650352,'2745','415',16273.68,18864.34,2590.66,427458.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','242715',4650353,'2746','415',317237.34,318283.80,1046.46,172665.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','242715',4650354,'2747','415',666860.86,668945.08,2084.22,343896.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','242715',4650355,'2748','415',524213.42,526335.92,2122.50,350212.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','242715',4650356,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242715',4650357,'2750','415',564269.23,566110.24,1841.01,303766.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','242715',4650358,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242715',4650359,'2752','415',638762.63,641359.33,2596.70,428455.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','242715',4650360,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242715',4650361,'2754','415',604115.38,606558.49,2443.11,403113.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','242715',4650362,'2755','415',108246.49,108355.59,109.10,18001.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','242715',4650363,'2756','416',210593.96,210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242715',4650364,'2757','416',168682.31,168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242715',4650365,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242715',4650366,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242928',4653932,'2744','415',8198.20,9397.45,1199.25,197876.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','242928',4653933,'2745','415',18864.34,21019.98,2155.64,355680.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','242928',4653934,'2746','415',318283.80,318283.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242928',4653935,'2747','415',668945.08,671474.99,2529.91,417435.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','242928',4653936,'2748','415',526335.92,528319.24,1983.32,327247.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','242928',4653937,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242928',4653938,'2750','415',566110.24,568072.35,1962.11,323748.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','242928',4653939,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242928',4653940,'2752','415',641359.33,644092.59,2733.26,450987.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','242928',4653941,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242928',4653942,'2754','415',606558.49,608371.16,1812.67,299090.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','242928',4653943,'2755','415',108355.59,109127.08,771.49,127295.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','242928',4653944,'2756','416',210593.96,210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242928',4653945,'2757','416',168682.31,168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242928',4653946,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242928',4653947,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','242953',4654357,'2744','415',9397.45,10802.80,1405.35,231882.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','242953',4654358,'2745','415',21019.98,22817.43,1797.45,296579.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','242953',4654359,'2746','415',318283.80,319045.08,761.28,125611.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','242953',4654360,'2747','415',671474.99,673421.49,1946.50,321172.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','242953',4654361,'2748','415',528319.24,529897.45,1578.21,260404.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','242953',4654362,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242953',4654363,'2750','415',568072.35,569953.70,1881.35,310422.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','242953',4654364,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242953',4654365,'2752','415',644092.59,646843.01,2750.42,453819.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','242953',4654366,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','242953',4654367,'2754','415',608371.16,610330.87,1959.71,323352.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','242953',4654368,'2755','415',109127.08,109466.88,339.80,56067.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242953',4654369,'2756','416',210593.96,210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','242953',4654370,'2757','416',168682.31,168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242953',4654371,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','242953',4654372,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243159',4657942,'2744','415',10802.80,12342.87,1540.07,254111.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','243159',4657943,'2745','415',22817.43,24659.55,1842.12,303949.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','243159',4657944,'2746','415',319045.08,319453.74,408.66,67428.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','243159',4657945,'2747','415',673421.49,675590.66,2169.17,357913.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','243159',4657946,'2748','415',529897.45,531943.08,2045.63,337528.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','243159',4657947,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243159',4657948,'2750','415',569953.70,571986.27,2032.57,335374.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','243159',4657949,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243159',4657950,'2752','415',646843.01,649607.57,2764.56,456152.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','243159',4657951,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243159',4657952,'2754','415',610330.87,612431.52,2100.65,346607.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','243159',4657953,'2755','415',109466.88,109994.91,528.03,87124.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','243159',4657954,'2756','416',210593.96,210593.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243159',4657955,'2757','416',168682.31,168682.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243159',4657956,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243159',4657957,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243178',4658278,'2744','415',12342.87,12501.98,159.11,26253.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','243178',4658279,'2745','415',24659.55,27204.74,2545.19,419956.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','243178',4658280,'2746','415',319453.74,319453.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243178',4658281,'2747','415',675590.66,678171.90,2581.24,425904.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','243178',4658282,'2748','415',531943.08,533875.21,1932.13,318801.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','243178',4658283,'2749','415',295996.24,295996.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243178',4658284,'2750','415',571986.27,574546.47,2560.20,422433.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243178',4658285,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243178',4658286,'2752','415',649607.57,652426.51,2818.94,465125.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','243178',4658287,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243178',4658288,'2754','415',612431.52,615078.64,2647.12,436774.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','243178',4658289,'2755','415',109994.91,109994.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243178',4658290,'2756','416',210593.96,211676.00,1082.04,378714.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243178',4658291,'2757','416',168682.31,169311.43,629.12,220192.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243178',4658292,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243178',4658293,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243345',4661632,'2744','415',12501.98,14575.90,2073.92,342196.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','243345',4661633,'2745','415',27204.74,29529.49,2324.75,383583.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','243345',4661634,'2746','415',319453.74,321822.72,2368.98,390881.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','243345',4661635,'2747','415',678171.90,680977.82,2805.92,462976.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','243345',4661636,'2748','415',533875.21,536219.45,2344.24,386799.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','243345',4661637,'2749','415',295996.24,297880.74,1884.50,310942.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','243345',4661638,'2750','415',574546.47,574546.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243345',4661639,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243345',4661640,'2752','415',652426.51,652491.12,64.61,10660.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','243345',4661641,'2753','415',95205.97,95205.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243345',4661642,'2754','415',615078.64,615088.85,10.21,1684.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','243345',4661643,'2755','415',109994.91,109994.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243345',4661644,'2756','416',211676.00,212216.59,540.59,189206.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','243345',4661645,'2757','416',169311.43,169457.87,146.44,51254.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243345',4661646,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243345',4661647,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243502',4664067,'2744','415',14575.90,14888.88,312.98,51641.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','243502',4664068,'2745','415',29529.49,31333.81,1804.32,297712.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','243502',4664069,'2746','415',321822.72,322088.80,266.08,43903.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','243502',4664070,'2747','415',680977.82,683197.05,2219.23,366172.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','243502',4664071,'2748','415',536219.45,538203.56,1984.11,327378.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','243502',4664072,'2749','415',297880.74,298067.54,186.80,30822.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243502',4664073,'2750','415',574546.47,576573.82,2027.35,334512.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','243502',4664074,'2751','415',103090.30,103090.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243502',4664075,'2752','415',652491.12,655220.28,2729.16,450311.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','243502',4664076,'2753','415',95205.97,95231.32,25.35,4182.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','243502',4664077,'2754','415',615088.85,617691.94,2603.09,429509.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','243502',4664078,'2755','415',109994.91,109994.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243502',4664079,'2756','416',212216.59,212488.67,272.08,95228.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243502',4664080,'2757','416',169457.87,170367.08,909.21,318223.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','243502',4664081,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243502',4664082,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243576',4665565,'2744','415',14888.88,14888.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243576',4665566,'2745','415',31333.81,31333.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243576',4665567,'2746','415',322088.80,322088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243576',4665568,'2747','415',683197.05,683197.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243576',4665569,'2748','415',538203.56,538203.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243576',4665570,'2749','415',298067.54,298067.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243576',4665571,'2750','415',576573.82,579058.25,2484.43,409930.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','243576',4665572,'2751','415',103090.30,105267.27,2176.97,359200.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','243576',4665573,'2752','415',655220.28,657685.02,2464.74,406682.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','243576',4665574,'2753','415',95231.32,97798.16,2566.84,423528.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','243576',4665575,'2754','415',617691.91,619612.56,1920.65,316907.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','243576',4665576,'2755','415',109994.91,111722.81,1727.90,285103.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','243576',4665577,'2756','416',212488.67,212813.52,324.85,113697.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','243576',4665578,'2757','416',170367.08,171446.65,1079.57,377849.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','243576',4665579,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243576',4665580,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243722',4667980,'2744','415',14888.88,14888.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243722',4667981,'2745','415',31333.81,34249.52,2915.71,481092.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','243722',4667982,'2746','415',322088.80,322088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243722',4667983,'2747','415',683197.05,685485.24,2288.19,377551.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','243722',4667984,'2748','415',538203.56,540958.50,2754.94,454565.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','243722',4667985,'2749','415',298067.54,298067.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243722',4667986,'2750','415',579058.25,581501.27,2443.02,403098.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','243722',4667987,'2751','415',105267.27,105267.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243722',4667988,'2752','415',657685.02,659559.83,1874.81,309343.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','243722',4667989,'2753','415',97798.16,97798.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243722',4667990,'2754','415',619612.56,621981.84,2369.28,390931.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','243722',4667991,'2755','415',111722.81,111722.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243722',4667992,'2756','416',212813.52,213912.58,1099.06,384671.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243722',4667993,'2757','416',171446.65,173531.56,2084.91,729718.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','243722',4667994,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243722',4667995,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243816',4669739,'2744','415',14888.88,15431.03,542.15,89454.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','243816',4669740,'2745','415',34249.52,35432.23,1182.71,195147.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','243816',4669741,'2746','415',322088.80,322536.37,447.57,73849.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','243816',4669742,'2747','415',685485.24,686694.37,1209.13,199506.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','243816',4669743,'2748','415',540958.50,543129.52,2171.02,358218.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','243816',4669744,'2749','415',298067.54,299858.53,1790.99,295513.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','243816',4669745,'2750','415',581501.27,583329.24,1827.97,301615.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','243816',4669746,'2751','415',105267.27,105267.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243816',4669747,'2752','415',659559.83,661127.89,1568.06,258729.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','243816',4669748,'2753','415',97798.16,98488.83,690.67,113960.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','243816',4669749,'2754','415',621981.84,623327.68,1345.84,222063.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','243816',4669750,'2755','415',111722.81,112565.94,843.13,139116.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','243816',4669751,'2756','416',213912.58,214305.50,392.92,137522.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243816',4669752,'2757','416',173531.56,173949.28,417.72,146202.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243816',4669753,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243816',4669754,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243952',4671970,'2744','415',15431.03,15431.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243952',4671971,'2745','415',35432.23,38010.19,2577.96,425363.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','243952',4671972,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','243952',4671973,'2747','415',686694.37,688778.64,2084.27,343904.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','243952',4671974,'2748','415',543129.52,544949.93,1820.41,300367.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','243952',4671975,'2749','415',299858.53,301011.14,1152.61,190180.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','243952',4671976,'2750','415',583329.24,585204.32,1875.08,309388.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','243952',4671977,'2751','415',105267.27,105267.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243952',4671978,'2752','415',661127.89,663358.46,2230.57,368044.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','243952',4671979,'2753','415',98488.83,98488.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','243952',4671980,'2754','415',623327.68,625442.62,2114.94,348965.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','243952',4671981,'2755','415',112565.94,112565.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243952',4671982,'2756','416',214305.50,214621.08,315.58,110453.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','243952',4671983,'2757','416',173949.28,174486.16,536.88,187908.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243952',4671984,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','243952',4671985,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244051',4673643,'2744','415',15431.03,16538.23,1107.20,182688.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244051',4673644,'2745','415',38010.19,40789.84,2779.65,458642.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','244051',4673645,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244051',4673646,'2747','415',688778.64,691433.63,2654.99,438073.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','244051',4673647,'2748','415',544949.93,545874.42,924.49,152540.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','244051',4673648,'2749','415',301011.14,302950.76,1939.62,320037.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','244051',4673649,'2750','415',585204.32,587695.08,2490.76,410975.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','244051',4673650,'2751','415',105267.27,105267.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244051',4673651,'2752','415',663358.46,666290.31,2931.85,483755.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','244051',4673652,'2753','415',98488.83,98488.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244051',4673653,'2754','415',625442.62,628318.82,2876.20,474573.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244051',4673654,'2755','415',112565.94,112565.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244051',4673655,'2756','416',214621.08,215041.62,420.54,147189.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244051',4673656,'2757','416',174486.16,174699.02,212.86,74501.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244051',4673657,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244051',4673658,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244183',4675872,'2744','415',16538.23,16580.65,42.42,6999.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','244183',4675873,'2745','415',40789.84,43564.59,2774.75,457833.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','244183',4675874,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244183',4675875,'2747','415',691433.63,694576.26,3142.63,518533.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','244183',4675876,'2748','415',545874.42,545885.17,10.75,1773.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','244183',4675877,'2749','415',302950.76,305424.64,2473.88,408190.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','244183',4675878,'2750','415',587695.08,590564.95,2869.87,473528.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','244183',4675879,'2751','415',105267.27,105267.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244183',4675880,'2752','415',666290.31,668513.44,2223.13,366816.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','244183',4675881,'2753','415',98488.83,99179.06,690.23,113887.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','244183',4675882,'2754','415',628318.82,631170.06,2851.24,470454.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','244183',4675883,'2755','415',112565.94,112565.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244183',4675884,'2756','416',215041.62,215265.63,224.01,78403.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','244183',4675885,'2757','416',174699.02,175235.16,536.14,187649.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244183',4675886,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244183',4675887,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244306',4677844,'2744','415',16580.65,16580.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244306',4677845,'2745','415',43564.59,44816.60,1252.01,206581.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','244306',4677846,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244306',4677847,'2747','415',694576.26,696230.29,1654.03,272914.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','244306',4677848,'2748','415',545885.17,547114.35,1229.18,202814.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','244306',4677849,'2749','415',305424.64,305424.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244306',4677850,'2750','415',590564.95,593238.20,2673.25,441086.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','244306',4677851,'2751','415',105267.27,106660.15,1392.88,229825.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','244306',4677852,'2752','415',668513.44,671777.71,3264.27,538604.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','244306',4677853,'2753','415',99179.06,100656.61,1477.55,243795.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','244306',4677854,'2754','415',631170.06,633428.04,2257.98,372566.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','244306',4677855,'2755','415',112565.94,114471.14,1905.20,314358.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244306',4677856,'2756','416',215265.63,215546.68,281.05,98367.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','244306',4677857,'2757','416',175235.16,175699.01,463.85,162347.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','244306',4677858,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244306',4677859,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244428',4680151,'2744','415',16580.65,16580.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244428',4680152,'2745','415',44816.60,44816.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244428',4680153,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244428',4680154,'2747','415',696230.29,696230.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244428',4680155,'2748','415',547114.35,547114.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244428',4680156,'2749','415',305424.64,305424.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244428',4680157,'2750','415',593238.20,594961.30,1723.10,284311.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','244428',4680158,'2751','415',106660.15,108228.23,1568.08,258733.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','244428',4680159,'2752','415',671777.71,673494.48,1716.77,283267.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','244428',4680160,'2753','415',100656.61,102137.61,1481.00,244365.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244428',4680161,'2754','415',633428.04,634965.06,1537.02,253608.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','244428',4680162,'2755','415',114471.14,115631.12,1159.98,191396.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','244428',4680163,'2756','416',215546.68,215779.27,232.59,81406.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','244428',4680164,'2757','416',175699.01,176027.36,328.35,114922.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','244428',4680165,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244428',4680166,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244515',4681673,'2744','415',16580.65,16580.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244515',4681674,'2745','415',44816.60,45678.03,861.43,142135.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','244515',4681675,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244515',4681676,'2747','415',696230.29,696871.58,641.29,105812.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','244515',4681677,'2748','415',547114.35,547114.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244515',4681678,'2749','415',305424.64,306025.23,600.59,99097.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','244515',4681679,'2750','415',594961.30,595859.50,898.20,148203.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244515',4681680,'2751','415',108228.23,108424.95,196.72,32458.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','244515',4681681,'2752','415',673494.48,674562.72,1068.24,176259.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','244515',4681682,'2753','415',102137.61,102351.71,214.10,35326.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','244515',4681683,'2754','415',634965.06,635313.83,348.77,57547.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','244515',4681684,'2755','415',115631.12,116122.04,490.92,81001.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','244515',4681685,'2756','416',215779.27,215879.27,100.00,35000.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244515',4681686,'2757','416',176027.36,176353.62,326.26,114191.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244515',4681687,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244515',4681688,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244635',4683802,'2744','415',16580.65,17601.72,1021.07,168476.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','244635',4683803,'2745','415',45678.03,47638.24,1960.21,323434.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','244635',4683804,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244635',4683805,'2747','415',696871.58,699459.69,2588.11,427038.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','244635',4683806,'2748','415',547114.35,549147.94,2033.59,335542.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','244635',4683807,'2749','415',306025.23,306155.48,130.25,21491.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','244635',4683808,'2750','415',595859.50,597985.69,2126.19,350821.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','244635',4683809,'2751','415',108424.95,108424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244635',4683810,'2752','415',674562.72,677012.72,2450.00,404250.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244635',4683811,'2753','415',102351.71,102351.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244635',4683812,'2754','415',635313.83,637654.21,2340.38,386162.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','244635',4683813,'2755','415',116122.04,116122.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244635',4683814,'2756','416',215879.27,216562.33,683.06,239071.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244635',4683815,'2757','416',176353.62,176949.33,595.71,208498.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','244635',4683816,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244635',4683817,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244742',4685440,'2744','415',17601.72,17601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244742',4685441,'2745','415',47638.24,49818.31,2180.07,359711.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','244742',4685442,'2746','415',322536.37,322536.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244742',4685443,'2747','415',699459.69,701703.36,2243.67,370205.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','244742',4685444,'2748','415',549147.94,550652.05,1504.11,248178.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','244742',4685445,'2749','415',306155.48,307656.87,1501.39,247729.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','244742',4685446,'2750','415',597985.69,599606.41,1620.72,267418.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','244742',4685447,'2751','415',108424.95,108424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244742',4685448,'2752','415',677012.72,679114.71,2101.99,346828.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','244742',4685449,'2753','415',102351.71,102351.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244742',4685450,'2754','415',637654.21,639355.57,1701.36,280724.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','244742',4685451,'2755','415',116122.04,116871.56,749.52,123670.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','244742',4685452,'2756','416',216562.33,216845.34,283.01,99053.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','244742',4685453,'2757','416',176949.33,177203.33,254.00,88900.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244742',4685454,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244742',4685455,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244871',4687837,'2744','415',17601.72,18099.80,498.08,82183.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','244871',4687838,'2745','415',49818.31,52232.94,2414.63,398413.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','244871',4687839,'2746','415',322536.37,323046.69,510.32,84202.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','244871',4687840,'2747','415',701703.36,703663.51,1960.15,323424.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','244871',4687841,'2748','415',550652.05,552644.63,1992.58,328775.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','244871',4687842,'2749','415',307656.87,308053.43,396.56,65432.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','244871',4687843,'2750','415',599606.41,601022.96,1416.55,233730.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','244871',4687844,'2751','415',108424.95,108424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244871',4687845,'2752','415',679114.71,680223.34,1108.63,182923.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','244871',4687846,'2753','415',102351.71,102351.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244871',4687847,'2754','415',639355.57,640652.07,1276.01,210541.65,0.00,0.00,20.49,0.00,0.00),('1','185','936','244871',4687848,'2755','415',116871.56,116871.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244871',4687849,'2756','416',216845.34,216939.99,94.65,33127.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','244871',4687850,'2757','416',177203.33,177529.10,305.13,106795.50,0.00,0.00,20.64,0.00,0.00),('1','185','938','244871',4687851,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244871',4687852,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','244985',4689681,'2744','415',18099.80,20362.68,2262.88,373375.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','244985',4689682,'2745','415',52232.94,54378.72,2145.78,354053.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','244985',4689683,'2746','415',323046.69,325137.98,2091.29,345062.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','244985',4689684,'2747','415',703663.51,706060.79,2397.28,395551.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','244985',4689685,'2748','415',552644.63,554683.27,2038.64,336375.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','244985',4689686,'2749','415',308053.43,309729.79,1676.36,276599.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','244985',4689687,'2750','415',601022.96,601022.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244985',4689688,'2751','415',108424.95,108424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244985',4689689,'2752','415',680223.34,680223.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244985',4689690,'2753','415',102351.71,102351.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244985',4689691,'2754','415',640652.07,640652.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','244985',4689692,'2755','415',116871.56,116871.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244985',4689693,'2756','416',216939.99,216939.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','244985',4689694,'2757','416',177529.10,177529.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244985',4689695,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','244985',4689696,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245113',4692012,'2744','415',20362.68,20404.87,42.19,6961.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','245113',4692013,'2745','415',54378.72,56632.45,2253.73,371865.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','245113',4692014,'2746','415',325137.98,325137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245113',4692015,'2747','415',706060.79,709001.48,2940.69,485213.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','245113',4692016,'2748','415',554683.27,556432.98,1749.71,288702.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','245113',4692017,'2749','415',309729.79,310573.89,844.10,139276.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','245113',4692018,'2750','415',601022.96,602362.37,1339.41,221002.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','245113',4692019,'2751','415',108424.95,109396.03,971.08,160228.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','245113',4692020,'2752','415',680223.34,682040.84,1817.50,299887.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','245113',4692021,'2753','415',102351.71,102351.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245113',4692022,'2754','415',640652.07,642182.61,1530.54,252539.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','245113',4692023,'2755','415',116871.56,116871.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245113',4692024,'2756','416',216939.99,218742.08,1802.09,630731.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','245113',4692025,'2757','416',177529.10,180105.61,2576.51,901778.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','245113',4692026,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245113',4692027,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245200',4693678,'2744','415',20404.87,20463.96,59.09,9749.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','245200',4693679,'2745','415',56632.45,58144.65,1512.20,249513.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245200',4693680,'2746','415',325137.98,325137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245200',4693681,'2747','415',709001.48,710042.87,1041.39,171829.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','245200',4693682,'2748','415',556432.98,557260.72,827.74,136577.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','245200',4693683,'2749','415',310573.89,311574.60,1000.71,165117.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','245200',4693684,'2750','415',602362.37,604763.29,2400.92,396151.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','245200',4693685,'2751','415',109396.03,110251.28,855.25,141116.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','245200',4693686,'2752','415',682040.84,684487.87,2447.03,403759.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','245200',4693687,'2753','415',102351.71,103577.65,1225.94,202280.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','245200',4693688,'2754','415',642182.61,644330.77,2148.16,354446.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','245200',4693689,'2755','415',116871.56,118239.38,1367.82,225690.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','245200',4693690,'2756','416',218742.08,219750.77,1008.69,353041.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','245200',4693691,'2757','416',180105.61,180832.75,727.14,254499.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245200',4693692,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245200',4693693,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245325',4695752,'2744','415',20463.96,21826.61,1352.65,223187.25,0.00,0.00,10.00,0.00,0.00),('1','185','935','245325',4695753,'2745','415',58144.65,59714.29,1549.64,255690.60,0.00,0.00,20.00,0.00,0.00),('1','185','935','245325',4695754,'2746','415',325137.98,325157.98,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','185','935','245325',4695755,'2747','415',710042.87,712521.50,2468.63,407323.95,0.00,0.00,10.00,0.00,0.00),('1','185','935','245325',4695756,'2748','415',557260.72,559368.58,2097.86,346146.90,0.00,0.00,10.00,0.00,0.00),('1','185','935','245325',4695757,'2749','415',311574.60,312125.19,540.59,89197.35,0.00,0.00,10.00,0.00,0.00),('1','185','936','245325',4695758,'2750','415',604763.29,607873.99,3090.70,509965.50,0.00,0.00,20.00,0.00,0.00),('1','185','936','245325',4695759,'2751','415',110251.28,110261.28,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','245325',4695760,'2752','415',684487.87,687314.87,2807.00,463155.00,0.00,0.00,20.00,0.00,0.00),('1','185','936','245325',4695761,'2753','415',103577.65,103587.65,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','245325',4695762,'2754','415',644330.77,646682.59,2331.82,384750.30,0.00,0.00,20.00,0.00,0.00),('1','185','936','245325',4695763,'2755','415',118239.38,118249.38,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','937','245325',4695764,'2756','416',219750.77,220708.65,957.88,335258.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245325',4695765,'2757','416',180832.75,181437.46,604.71,211648.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','245325',4695766,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245325',4695767,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245441',4697719,'2744','415',21826.61,22512.38,685.77,113152.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','245441',4697720,'2745','415',59714.29,62281.63,2567.34,423611.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','245441',4697721,'2746','415',325157.98,325555.09,397.11,65523.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','245441',4697722,'2747','415',712521.50,715124.15,2602.65,429437.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','245441',4697723,'2748','415',559368.58,561100.25,1731.67,285725.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','245441',4697724,'2749','415',312125.19,313412.02,1286.83,212326.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','245441',4697725,'2750','415',607873.99,609780.05,1906.06,314499.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','245441',4697726,'2751','415',110261.28,110633.49,372.21,61414.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','245441',4697727,'2752','415',687314.87,688965.91,1651.04,272421.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','245441',4697728,'2753','415',103587.65,103587.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245441',4697729,'2754','415',646682.59,648418.05,1735.46,286350.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','245441',4697730,'2755','415',118249.38,118899.38,650.00,107250.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245441',4697731,'2756','416',220708.65,221110.79,402.14,140749.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245441',4697732,'2757','416',181437.46,181901.05,463.59,162256.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','245441',4697733,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245441',4697734,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245565',4699934,'2744','415',22152.38,23056.27,903.89,149141.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','245565',4699935,'2745','415',62281.63,64530.67,2249.04,371091.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','245565',4699936,'2746','415',325555.09,325570.24,15.15,2499.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','245565',4699937,'2747','415',715124.15,717267.91,2143.76,353720.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','245565',4699938,'2748','415',561100.25,561100.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245565',4699939,'2749','415',313412.02,315401.75,1989.73,328305.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','245565',4699940,'2750','415',609780.05,611417.19,1637.14,270128.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','245565',4699941,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245565',4699942,'2752','415',688965.91,691123.18,2157.27,355949.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','245565',4699943,'2753','415',103587.65,103587.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245565',4699944,'2754','415',648418.05,650019.84,1601.79,264295.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','245565',4699945,'2755','415',118899.38,118899.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245565',4699946,'2756','416',221110.79,221540.14,429.35,150272.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','245565',4699947,'2757','416',181901.05,181901.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245565',4699948,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245565',4699949,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245667',4701769,'2744','415',23056.27,23707.38,651.11,107433.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','245667',4701770,'2745','415',64530.67,66619.00,2088.33,344574.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','245667',4701771,'2746','415',325570.24,325570.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245667',4701772,'2747','415',717267.91,719600.06,2332.15,384804.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','245667',4701773,'2748','415',561100.25,562600.32,1500.07,247511.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','245667',4701774,'2749','415',315401.75,316224.40,822.65,135737.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','245667',4701775,'2750','415',611417.19,613647.33,2230.14,367973.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','245667',4701776,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245667',4701777,'2752','415',691123.18,693034.78,1911.60,315414.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245667',4701778,'2753','415',103587.65,103587.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245667',4701779,'2754','415',650019.84,652328.16,2308.32,380872.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','245667',4701780,'2755','415',118899.38,118899.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245667',4701781,'2756','416',221540.14,222044.78,504.64,176624.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245667',4701782,'2757','416',181901.05,182366.78,465.73,163005.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','245667',4701783,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245667',4701784,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245795',4703862,'2744','415',23707.38,23707.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245795',4703863,'2745','415',66619.00,68820.21,2201.21,363199.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','245795',4703864,'2746','415',325570.24,326330.63,760.39,125464.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','245795',4703865,'2747','415',719600.06,721138.55,1538.49,253850.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','245795',4703866,'2748','415',562600.32,563878.44,1278.12,210889.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','245795',4703867,'2749','415',316224.40,317158.62,934.22,154146.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','245795',4703868,'2750','415',613647.33,615492.24,1844.91,304410.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','245795',4703869,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245795',4703870,'2752','415',693034.78,694868.78,1834.00,302610.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245795',4703871,'2753','415',103587.65,103587.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245795',4703872,'2754','415',652328.16,654257.25,1929.09,318299.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','245795',4703873,'2755','415',118899.38,118899.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245795',4703874,'2756','416',222044.78,223196.43,1151.65,403077.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','245795',4703875,'2757','416',182366.78,183687.36,1320.58,462203.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245795',4703876,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245795',4703877,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','245933',4705792,'2744','415',23707.38,24947.34,1239.96,204593.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','245933',4705793,'2745','415',68820.21,70512.28,1692.07,279191.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','245933',4705794,'2746','415',326330.63,327725.19,1394.56,230102.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','245933',4705795,'2747','415',721138.55,723196.42,2057.87,339548.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','245933',4705796,'2748','415',563878.44,565353.96,1475.52,243460.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','245933',4705797,'2749','415',317158.62,318049.73,891.11,147033.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','245933',4705798,'2750','415',615492.24,616620.29,1128.05,186128.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','245933',4705799,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245933',4705800,'2752','415',694868.78,696312.53,1443.75,238218.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','245933',4705801,'2753','415',103587.65,103900.66,313.01,51646.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','245933',4705802,'2754','415',654257.25,655380.25,1123.00,185295.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','245933',4705803,'2755','415',118899.38,118899.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245933',4705804,'2756','416',223196.43,223408.25,211.82,74137.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','245933',4705805,'2757','416',183687.36,184872.12,1184.76,414666.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245933',4705806,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','245933',4705807,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246068',4708020,'2744','415',24947.34,25726.71,779.37,128596.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','246068',4708021,'2745','415',70512.28,72645.58,2133.30,351994.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','246068',4708022,'2746','415',327725.19,328810.99,1085.80,179157.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246068',4708023,'2747','415',723196.42,724547.47,1351.05,222923.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','246068',4708024,'2748','415',565353.96,567020.81,1666.85,275030.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','246068',4708025,'2749','415',318049.73,318049.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246068',4708026,'2750','415',616620.29,618167.76,1547.47,255332.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','246068',4708027,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246068',4708028,'2752','415',696312.53,698246.02,1933.49,319025.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','246068',4708029,'2753','415',103900.66,103900.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246068',4708030,'2754','415',655380.25,656843.95,1463.70,241510.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','246068',4708031,'2755','415',118899.38,118899.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246068',4708032,'2756','416',223408.25,224207.94,799.69,279891.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','246068',4708033,'2757','416',184872.12,186140.33,1268.21,443873.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','246068',4708034,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246068',4708035,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246176',4709967,'2744','415',25726.71,27324.81,1598.10,263686.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','246176',4709968,'2745','415',72645.58,74310.94,1665.36,274784.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','246176',4709969,'2746','415',328810.99,329783.89,972.90,160528.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','246176',4709970,'2747','415',724547.47,726126.10,1578.63,260473.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','246176',4709971,'2748','415',567020.81,568394.16,1373.35,226602.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','246176',4709972,'2749','415',318049.73,318707.70,657.97,108565.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','246176',4709973,'2750','415',618167.76,619609.60,1441.84,237903.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','246176',4709974,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246176',4709975,'2752','415',698246.02,700502.49,2256.47,372317.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','246176',4709976,'2753','415',103900.66,103900.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246176',4709977,'2754','415',656843.95,658976.48,2132.53,351867.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','246176',4709978,'2755','415',118899.38,119081.92,182.54,30119.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','246176',4709979,'2756','416',224207.94,225162.57,954.63,334120.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','246176',4709980,'2757','416',186140.33,186140.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246176',4709981,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246176',4709982,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246341',4712456,'2744','415',27324.81,29147.10,1822.29,300677.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','246341',4712457,'2745','415',74310.94,74617.16,306.22,50526.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','246341',4712458,'2746','415',329783.89,330168.90,385.01,63526.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','246341',4712459,'2747','415',726126.10,728164.44,2038.34,336326.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','246341',4712460,'2748','415',568394.16,570904.51,2510.35,414207.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','246341',4712461,'2749','415',318707.70,318707.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246341',4712462,'2750','415',619609.60,621428.96,1819.36,300194.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','246341',4712463,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246341',4712464,'2752','415',700502.49,701518.02,1015.53,167562.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','246341',4712465,'2753','415',103900.66,104337.42,436.76,72065.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','246341',4712466,'2754','415',658976.48,660815.76,1839.28,303481.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','246341',4712467,'2755','415',119081.92,119081.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246341',4712468,'2756','416',225162.57,225920.53,757.96,265286.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246341',4712469,'2757','416',186140.33,186304.62,164.29,57501.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','246341',4712470,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246341',4712471,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246381',4713266,'2744','415',29147.10,30517.36,1370.26,226092.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','246381',4713267,'2745','415',74617.16,76279.61,1662.45,274304.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','246381',4713268,'2746','415',330168.80,330394.62,225.82,37260.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','246381',4713269,'2747','415',728164.44,729915.11,1750.67,288860.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','246381',4713270,'2748','415',570904.51,572165.99,1261.48,208144.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','246381',4713271,'2749','415',318707.77,319648.61,940.84,155238.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','246381',4713272,'2750','415',621428.96,622866.59,1437.63,237208.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','246381',4713273,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246381',4713274,'2752','415',701518.02,703309.70,1791.68,295627.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','246381',4713275,'2753','415',104337.42,104337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246381',4713276,'2754','415',660815.76,662181.91,1366.15,225414.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','246381',4713277,'2755','415',119081.92,119808.65,726.73,119910.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','246381',4713278,'2756','416',225920.53,226405.28,484.75,169662.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','246381',4713279,'2757','416',186304.62,186438.48,133.86,46851.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246381',4713280,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246381',4713281,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246584',4716868,'2744','415',30517.36,31904.32,1386.96,228848.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','246584',4716869,'2745','415',76279.61,77790.51,1510.90,249298.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','246584',4716870,'2746','415',330394.62,331005.91,611.29,100862.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','246584',4716871,'2747','415',729915.11,731090.20,1175.09,193889.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','246584',4716872,'2748','415',572165.99,573623.79,1457.80,240537.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246584',4716873,'2749','415',319648.61,320040.80,392.19,64711.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','246584',4716874,'2750','415',622866.59,624284.11,1417.52,233890.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','246584',4716875,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246584',4716876,'2752','415',703309.70,704972.42,1662.72,274348.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','246584',4716877,'2753','415',104337.42,104337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246584',4716878,'2754','415',662181.91,663466.55,1284.64,211965.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','246584',4716879,'2755','415',119808.65,119808.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246584',4716880,'2756','416',226405.28,227184.12,778.84,272594.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246584',4716881,'2757','416',186438.48,186977.96,539.48,188818.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246584',4716882,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246584',4716883,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246693',4718709,'2744','415',31904.32,33198.98,1294.66,213618.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','246693',4718710,'2745','415',77790.51,79700.81,1910.30,315199.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','246693',4718711,'2746','415',331005.91,331626.22,620.31,102351.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','246693',4718712,'2747','415',731090.20,733378.45,2288.25,377561.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','246693',4718713,'2748','415',573623.79,575115.77,1491.98,246176.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','246693',4718714,'2749','415',320040.80,321346.80,1306.00,215490.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246693',4718715,'2750','415',624284.11,625600.39,1316.28,217186.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','246693',4718716,'2751','415',110633.49,110633.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246693',4718717,'2752','415',704972.42,706177.07,1204.65,198767.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','246693',4718718,'2753','415',104337.42,104337.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','246693',4718719,'2754','415',663466.55,664834.70,1368.15,225744.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','246693',4718720,'2755','415',119808.65,119808.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246693',4718721,'2756','416',227184.12,227755.72,571.60,200060.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246693',4718722,'2757','416',186977.96,187227.81,249.85,87447.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','246693',4718723,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246693',4718724,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246832',4721156,'2744','415',33198.98,34421.24,1222.26,201672.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','246832',4721157,'2745','415',79700.81,80798.47,1097.66,181113.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','246832',4721158,'2746','415',331626.22,332282.39,656.17,108268.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','246832',4721159,'2747','415',733378.45,735031.29,1652.84,272718.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','246832',4721160,'2748','415',575115.77,576312.04,1196.27,197384.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','246832',4721161,'2749','415',321346.80,321736.83,390.03,64354.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','246832',4721162,'2750','415',625600.39,627164.08,1563.69,258008.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','246832',4721163,'2751','415',110633.49,111222.17,588.68,97132.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','246832',4721164,'2752','415',706177.07,707746.29,1569.22,258921.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','246832',4721165,'2753','415',104337.42,104755.01,417.59,68902.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','246832',4721166,'2754','415',664834.70,666473.64,1638.94,270425.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','246832',4721167,'2755','415',119808.65,120053.80,245.15,40449.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','246832',4721168,'2756','416',227755.72,228122.95,367.23,128530.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','246832',4721169,'2757','416',187227.81,188356.95,1129.14,395199.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246832',4721170,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246832',4721171,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246952',4723180,'2744','415',34421.24,34496.99,75.75,12498.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','246952',4723181,'2745','415',80798.47,81654.09,855.62,141177.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','246952',4723182,'2746','415',332282.39,332282.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','246952',4723183,'2747','415',735031.29,735607.55,576.26,95082.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','246952',4723184,'2748','415',576312.04,576315.68,3.64,600.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','246952',4723185,'2749','415',321736.83,322520.37,783.54,129284.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','246952',4723186,'2750','415',627164.08,629304.83,2140.75,353223.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','246952',4723187,'2751','415',111222.17,113127.94,1905.77,314452.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','246952',4723188,'2752','415',707746.29,709959.07,2212.78,365108.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','246952',4723189,'2753','415',104755.01,106715.72,1960.71,323517.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','246952',4723190,'2754','415',666473.64,668363.65,1890.01,311851.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','246952',4723191,'2755','415',120053.80,121866.56,1812.76,299105.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','246952',4723192,'2756','416',228122.95,228180.95,58.00,20300.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','246952',4723193,'2757','416',188356.95,189017.14,660.19,231066.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','246952',4723194,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','246952',4723195,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247072',4725259,'2744','415',34496.99,35790.64,1293.65,213452.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','247072',4725260,'2745','415',81654.09,82987.92,1333.83,220081.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','247072',4725261,'2746','415',332282.39,333369.62,1087.23,179392.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','247072',4725262,'2747','415',735607.55,737139.70,1532.15,252804.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','247072',4725263,'2748','415',576315.68,577886.38,1570.70,259165.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','247072',4725264,'2749','415',322520.37,322815.42,295.05,48683.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','247072',4725265,'2750','415',629304.83,630864.16,1559.33,257289.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','247072',4725266,'2751','415',113127.94,113127.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247072',4725267,'2752','415',709959.07,711833.99,1874.92,309361.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','247072',4725268,'2753','415',106715.72,106715.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247072',4725269,'2754','415',668363.65,669825.33,1461.68,241177.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','247072',4725270,'2755','415',121866.56,121866.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247072',4725271,'2756','416',228180.95,229321.51,1140.56,399196.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247072',4725272,'2757','416',189017.14,189884.58,867.44,303604.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247072',4725273,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247072',4725274,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247165',4726889,'2744','415',35790.64,36857.72,1067.08,176068.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','247165',4726890,'2745','415',82987.92,85031.10,2043.18,337124.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','247165',4726891,'2746','415',333369.62,333369.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247165',4726892,'2747','415',737139.70,738916.03,1776.33,293094.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','247165',4726893,'2748','415',577886.38,579412.54,1526.16,251816.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','247165',4726894,'2749','415',322815.42,323707.79,892.37,147241.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','247165',4726895,'2750','415',630864.16,633059.45,2170.29,358097.85,0.00,0.00,25.00,0.00,0.00),('1','185','936','247165',4726896,'2751','415',113127.94,113127.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247165',4726897,'2752','415',711833.99,714175.56,2341.57,386359.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','247165',4726898,'2753','415',106715.72,106715.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247165',4726899,'2754','415',669825.33,671564.45,1739.12,286954.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','247165',4726900,'2755','415',121866.56,121866.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247165',4726901,'2756','416',229321.51,230345.86,1024.35,358522.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','247165',4726902,'2757','416',189884.58,189884.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247165',4726903,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247165',4726904,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247298',4729363,'2744','415',36857.72,38090.45,1232.73,203400.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','247298',4729364,'2745','415',85031.10,86314.59,1283.49,211775.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','247298',4729365,'2746','415',333369.62,333979.39,609.77,100612.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','247298',4729366,'2747','415',738916.03,740298.23,1382.20,228063.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247298',4729367,'2748','415',579412.54,580877.98,1465.44,241797.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','247298',4729368,'2749','415',323707.79,324164.34,456.55,75330.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','247298',4729369,'2750','415',633059.45,634289.30,1229.85,202925.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','247298',4729370,'2751','415',113127.94,113127.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247298',4729371,'2752','415',714175.56,716155.57,1980.01,326701.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','247298',4729372,'2753','415',106715.72,106715.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247298',4729373,'2754','415',671564.45,673196.44,1631.99,269278.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','247298',4729374,'2755','415',121866.56,121866.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247298',4729375,'2756','416',230345.86,231633.66,1287.80,450730.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247298',4729376,'2757','416',189884.58,190724.46,839.88,293958.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247298',4729377,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247298',4729378,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247387',4730933,'2744','415',38090.45,39400.52,1310.07,216161.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','247387',4730934,'2745','415',86314.59,88175.89,1861.30,307114.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','247387',4730935,'2746','415',333979.39,335396.60,1417.21,233839.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','247387',4730936,'2747','415',740298.23,742324.42,2026.19,334321.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','247387',4730937,'2748','415',580877.98,582583.38,1705.40,281391.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247387',4730938,'2749','415',324164.34,325530.73,1366.39,225454.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','247387',4730939,'2750','415',634289.30,634672.62,383.32,63247.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','247387',4730940,'2751','415',113127.94,113127.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247387',4730941,'2752','415',716155.57,716414.18,258.61,42670.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','247387',4730942,'2753','415',106715.72,106715.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247387',4730943,'2754','415',673196.44,673386.76,190.32,31402.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','247387',4730944,'2755','415',121866.56,121866.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247387',4730945,'2756','416',231633.66,232426.19,792.53,277385.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','247387',4730946,'2757','416',190724.46,190767.32,42.86,15001.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247387',4730947,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247387',4730948,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247549',4733403,'2744','415',39400.52,39565.01,164.49,27140.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','247549',4733404,'2745','415',88175.89,88369.24,193.35,31902.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','247549',4733405,'2746','415',335396.60,335593.51,196.91,32490.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','247549',4733406,'2747','415',742324.42,742435.76,111.34,18371.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','247549',4733407,'2748','415',582583.38,582850.29,266.91,44040.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','247549',4733408,'2749','415',325530.73,325573.43,42.70,7045.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','247549',4733409,'2750','415',634672.62,634675.62,3.00,495.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247549',4733410,'2751','415',113127.94,113127.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247549',4733411,'2752','415',716414.18,716414.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247549',4733412,'2753','415',106715.72,106715.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247549',4733413,'2754','415',673386.76,673386.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247549',4733414,'2755','415',121866.56,121866.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247549',4733415,'2756','416',232426.19,236183.65,3757.46,1315111.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247549',4733416,'2757','416',190767.32,192091.62,1324.30,463505.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247549',4733417,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247549',4733418,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247666',4735498,'2744','415',39565.01,39565.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247666',4735499,'2745','415',88369.24,88369.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247666',4735500,'2746','415',335593.51,335593.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247666',4735501,'2747','415',742435.76,742435.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247666',4735502,'2748','415',582850.29,582850.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247666',4735503,'2749','415',325573.43,325573.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247666',4735504,'2750','415',634675.62,635155.61,479.99,79198.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','247666',4735505,'2751','415',113127.94,113527.88,399.94,65990.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','247666',4735506,'2752','415',716414.18,716797.65,383.47,63272.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','247666',4735507,'2753','415',106715.72,107108.36,392.64,64785.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','247666',4735508,'2754','415',673386.76,673588.41,201.65,33272.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','247666',4735509,'2755','415',121866.56,122249.29,382.73,63150.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','247666',4735510,'2756','416',236183.65,237305.39,1121.74,392609.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247666',4735511,'2757','416',192091.62,193493.77,1402.15,490752.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','247666',4735512,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247666',4735513,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247798',4737731,'2744','415',39565.01,41445.16,1880.15,310224.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','247798',4737732,'2745','415',88369.24,90328.15,1958.91,323220.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','247798',4737733,'2746','415',335593.51,336564.11,970.60,160149.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247798',4737734,'2747','415',742435.76,744914.07,2478.31,408921.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','247798',4737735,'2748','415',582850.29,584627.70,1777.41,293272.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','247798',4737736,'2749','415',325573.43,325573.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247798',4737737,'2750','415',635155.61,637197.58,2041.97,336925.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','247798',4737738,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247798',4737739,'2752','415',716797.65,718708.28,1910.63,315253.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','247798',4737740,'2753','415',107108.36,107108.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247798',4737741,'2754','415',673588.41,675596.97,2008.56,331412.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','247798',4737742,'2755','415',122249.29,122249.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247798',4737743,'2756','416',237305.39,238555.53,1250.14,437549.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247798',4737744,'2757','416',193493.77,194193.14,699.37,244779.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','247798',4737745,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247798',4737746,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','247914',4739643,'2744','415',41445.16,42593.82,1148.66,189528.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','247914',4739644,'2745','415',90328.15,92402.76,2064.61,340660.65,0.00,0.00,10.00,0.00,0.00),('1','185','935','247914',4739645,'2746','415',336564.11,337454.92,890.81,146983.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','247914',4739646,'2747','415',744914.07,746947.37,2033.30,335494.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','247914',4739647,'2748','415',584627.70,586001.81,1374.11,226728.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','247914',4739648,'2749','415',325573.43,327028.32,1444.89,238406.85,0.00,0.00,10.00,0.00,0.00),('1','185','936','247914',4739649,'2750','415',637197.58,638594.29,1396.71,230457.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','247914',4739650,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247914',4739651,'2752','415',718708.28,720739.10,2020.82,333435.30,0.00,0.00,10.00,0.00,0.00),('1','185','936','247914',4739652,'2753','415',107108.36,107108.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','247914',4739653,'2754','415',675596.97,677219.44,1622.47,267707.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','247914',4739654,'2755','415',122249.29,122249.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247914',4739655,'2756','416',238555.53,239361.97,806.44,282254.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','247914',4739656,'2757','416',194193.14,194372.28,179.14,62699.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247914',4739657,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','247914',4739658,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248039',4741701,'2744','415',42593.82,43698.45,1104.63,182263.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','248039',4741702,'2745','415',92402.76,94270.83,1868.07,308231.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','248039',4741703,'2746','415',337454.92,338865.95,1411.03,232819.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','248039',4741704,'2747','415',746947.37,748267.22,1319.85,217775.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','248039',4741705,'2748','415',586001.81,587550.24,1538.43,253840.95,0.00,0.00,10.00,0.00,0.00),('1','185','935','248039',4741706,'2749','415',327028.32,327181.00,152.68,25192.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','248039',4741707,'2750','415',638594.29,639786.68,1192.39,196744.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','248039',4741708,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248039',4741709,'2752','415',720739.10,722467.06,1727.96,285113.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','248039',4741710,'2753','415',107108.36,107730.04,621.68,102577.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','248039',4741711,'2754','415',677219.44,678502.24,1282.80,211662.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248039',4741712,'2755','415',122249.29,122249.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248039',4741713,'2756','416',239361.97,240918.50,1556.53,544785.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','248039',4741714,'2757','416',194372.28,195753.55,1381.27,483444.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','248039',4741715,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248039',4741716,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248139',4743657,'2744','415',43698.45,44472.05,773.60,127644.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248139',4743658,'2745','415',94270.83,95739.20,1468.37,242281.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','248139',4743659,'2746','415',338865.95,338865.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248139',4743660,'2747','415',748267.22,750885.89,2618.67,432080.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','248139',4743661,'2748','415',587550.24,588697.29,1147.05,189263.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','248139',4743662,'2749','415',327181.00,328327.50,1146.50,189172.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','248139',4743663,'2750','415',639786.68,641401.15,1614.47,266387.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','248139',4743664,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248139',4743665,'2752','415',722467.06,724572.85,2105.79,347455.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','248139',4743666,'2753','415',107730.04,108043.74,313.70,51760.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','248139',4743667,'2754','415',678502.24,680410.98,1908.74,314942.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','248139',4743668,'2755','415',122249.29,122249.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248139',4743669,'2756','416',240918.50,241163.63,245.13,85795.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','248139',4743670,'2757','416',195753.55,196992.84,1239.29,433751.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','248139',4743671,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248139',4743672,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248297',4746329,'2744','415',44472.05,45965.99,1493.94,246500.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','248297',4746330,'2745','415',95739.20,97091.98,1352.78,223208.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','248297',4746331,'2746','415',338865.95,339864.56,998.61,164770.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','248297',4746332,'2747','415',750885.89,752497.03,1611.14,265838.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','248297',4746333,'2748','415',588697.29,590858.43,2161.14,356588.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','248297',4746334,'2749','415',328327.50,328327.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248297',4746335,'2750','415',641401.15,642578.89,1177.74,194327.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','248297',4746336,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248297',4746337,'2752','415',724572.85,726200.67,1627.82,268590.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','248297',4746338,'2753','415',108043.74,108043.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248297',4746339,'2754','415',680410.98,682070.09,1659.11,273753.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','248297',4746340,'2755','415',122249.29,122249.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248297',4746341,'2756','416',241163.63,242693.89,1530.26,535591.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248297',4746342,'2757','416',196992.84,198048.39,1055.55,369442.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','248297',4746343,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248297',4746344,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248394',4747919,'2744','415',45965.99,47189.72,1223.73,201915.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','248394',4747920,'2745','415',97091.98,99128.28,2036.30,335989.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','248394',4747921,'2746','415',339864.56,339864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248394',4747922,'2747','415',752497.03,755230.26,2733.23,450982.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','248394',4747923,'2748','415',590858.43,592579.87,1721.44,284037.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','248394',4747924,'2749','415',328327.50,329786.91,1459.41,240802.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','248394',4747925,'2750','415',642578.89,644875.36,2296.47,378917.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','248394',4747926,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248394',4747927,'2752','415',726200.67,728639.56,2438.89,402416.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','248394',4747928,'2753','415',108043.74,108043.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248394',4747929,'2754','415',682070.09,684137.40,2067.31,341106.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','248394',4747930,'2755','415',122249.29,122545.66,296.37,48901.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','248394',4747931,'2756','416',242693.89,243389.71,695.82,243537.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248394',4747932,'2757','416',198048.39,198131.25,82.86,29001.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248394',4747933,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248394',4747934,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248515',4749996,'2744','415',47189.72,48693.67,1503.95,248151.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','248515',4749997,'2745','415',99128.28,100286.70,1158.42,191139.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','248515',4749998,'2746','415',339864.56,339864.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248515',4749999,'2747','415',755230.26,757450.74,2220.48,366379.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','248515',4750000,'2748','415',592579.87,594048.73,1468.86,242361.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','248515',4750001,'2749','415',329786.91,331069.58,1282.67,211640.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','248515',4750002,'2750','415',644875.36,646380.10,1504.74,248282.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','248515',4750003,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248515',4750004,'2752','415',728639.56,730536.14,1896.58,312935.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','248515',4750005,'2753','415',108043.74,108286.27,242.53,40017.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','248515',4750006,'2754','415',684137.40,686245.79,2108.39,347884.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','248515',4750007,'2755','415',122545.66,122787.43,241.77,39892.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','248515',4750008,'2756','416',243389.71,244539.79,1150.08,402528.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248515',4750009,'2757','416',198131.25,199343.69,1212.44,424354.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248515',4750010,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248515',4750011,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248593',4751258,'2744','415',48693.67,49385.25,691.58,114110.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','248593',4751259,'2745','415',100286.70,103359.97,3073.27,507089.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','248593',4751260,'2746','415',339864.56,340874.89,1010.33,166704.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','248593',4751261,'2747','415',757450.74,760147.65,2696.91,444990.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','248593',4751262,'2748','415',594048.73,596044.55,1995.82,329310.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','248593',4751263,'2749','415',331069.58,332278.99,1209.41,199552.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','248593',4751264,'2750','415',646380.10,648537.04,2156.94,355895.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','248593',4751265,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248593',4751266,'2752','415',730536.14,732822.16,2286.02,377193.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','248593',4751267,'2753','415',108286.27,108286.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248593',4751268,'2754','415',686245.79,687784.33,1538.54,253859.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','248593',4751269,'2755','415',122787.43,123314.19,526.76,86915.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','248593',4751270,'2756','416',244539.79,245461.01,921.22,322427.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248593',4751271,'2757','416',199343.69,200098.84,755.15,264302.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','248593',4751272,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248593',4751273,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248693',4752687,'2744','415',49385.25,50844.80,1459.55,240825.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','248693',4752688,'2745','415',103359.97,105030.38,1670.41,275617.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','248693',4752689,'2746','415',340874.89,340874.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248693',4752690,'2747','415',760147.65,762197.01,2049.36,338144.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','248693',4752691,'2748','415',596044.55,597683.98,1639.43,270505.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','248693',4752692,'2749','415',332278.99,333092.26,813.27,134189.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','248693',4752693,'2750','415',648537.04,650334.50,1797.46,296580.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','248693',4752694,'2751','415',113527.88,113527.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248693',4752695,'2752','415',732822.16,734888.72,2066.56,340982.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','248693',4752696,'2753','415',108286.27,108286.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248693',4752697,'2754','415',687784.33,689693.24,1908.91,314970.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','248693',4752698,'2755','415',123314.19,123314.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248693',4752699,'2756','416',245461.01,246756.06,1295.05,453267.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','248693',4752700,'2757','416',200098.84,200707.60,608.76,213066.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248693',4752701,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248693',4752702,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248875',4755979,'2744','415',50844.80,50985.68,140.88,23245.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','248875',4755980,'2745','415',105030.38,105461.20,430.82,71085.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','248875',4755981,'2746','415',340874.89,340874.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248875',4755982,'2747','415',762197.01,762515.58,318.57,52564.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','248875',4755983,'2748','415',597683.98,598034.35,350.37,57811.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','248875',4755984,'2749','415',333092.26,333141.34,49.08,8098.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','248875',4755985,'2750','415',650334.50,651664.21,1329.71,219402.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','248875',4755986,'2751','415',113527.88,114580.19,1052.31,173631.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','248875',4755987,'2752','415',734888.72,736365.92,1477.20,243738.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248875',4755988,'2753','415',108286.27,109549.84,1263.57,208489.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','248875',4755989,'2754','415',689693.24,691070.15,1376.91,227190.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','248875',4755990,'2755','415',123314.19,124501.73,1187.54,195944.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','248875',4755991,'2756','416',246756.06,246794.77,38.71,13548.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','248875',4755992,'2757','416',200707.60,201311.35,603.75,211312.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','248875',4755993,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248875',4755994,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','248988',4757902,'2744','415',50985.68,51526.20,540.52,89185.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','248988',4757903,'2745','415',105461.20,105757.69,296.49,48920.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','248988',4757904,'2746','415',340874.89,340963.50,88.61,14620.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','248988',4757905,'2747','415',762515.58,762997.27,481.69,79478.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','248988',4757906,'2748','415',598034.35,598527.46,493.11,81363.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','248988',4757907,'2749','415',333141.34,333276.32,134.98,22271.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','248988',4757908,'2750','415',651664.21,651664.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248988',4757909,'2751','415',114580.19,114580.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248988',4757910,'2752','415',736365.92,736365.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248988',4757911,'2753','415',109549.84,109549.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','248988',4757912,'2754','415',691070.15,691467.12,396.97,65500.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','248988',4757913,'2755','415',124501.73,124634.72,132.99,21943.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','248988',4757914,'2756','416',246794.77,248136.79,1342.02,469707.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','248988',4757915,'2757','416',201311.35,202284.80,973.45,340707.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','248988',4757916,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','248988',4757917,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249132',4760083,'2744','415',51526.20,51526.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249132',4760084,'2745','415',105757.69,105757.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249132',4760085,'2746','415',340963.50,340963.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249132',4760086,'2747','415',762997.27,762997.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249132',4760087,'2748','415',598527.46,598527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249132',4760088,'2749','415',333276.32,333276.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249132',4760089,'2750','415',651664.21,651723.57,59.36,9794.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','249132',4760090,'2751','415',114580.19,114626.93,46.74,7712.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','249132',4760091,'2752','415',736365.92,736526.66,160.74,26522.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','249132',4760092,'2753','415',109549.84,109550.22,0.38,62.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','249132',4760093,'2754','415',691467.12,691649.90,182.78,30158.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','249132',4760094,'2755','415',124634.72,124830.51,195.79,32305.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','249132',4760095,'2756','416',248136.79,248339.36,202.57,70899.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','249132',4760096,'2757','416',202284.80,202629.69,344.89,120711.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','249132',4760097,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249132',4760098,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249289',4763071,'2744','415',51526.20,51526.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249289',4763072,'2745','415',105757.69,105757.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249289',4763073,'2746','415',340963.50,340963.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249289',4763074,'2747','415',762997.27,762997.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249289',4763075,'2748','415',598527.46,598527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249289',4763076,'2749','415',333276.32,333276.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249289',4763077,'2750','415',651723.57,651723.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249289',4763078,'2751','415',114626.93,114626.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249289',4763079,'2752','415',736526.66,736526.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249289',4763080,'2753','415',109550.22,109550.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249289',4763081,'2754','415',691649.90,691649.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249289',4763082,'2755','415',124830.51,124830.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249289',4763083,'2756','416',248339.36,249611.07,1271.71,445098.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','249289',4763084,'2757','416',202629.69,203398.40,768.71,269048.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','249289',4763085,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249289',4763086,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249342',4763928,'2744','415',51526.20,51526.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249342',4763929,'2745','415',105757.69,105757.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249342',4763930,'2746','415',340963.50,340963.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249342',4763931,'2747','415',762997.27,762997.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249342',4763932,'2748','415',598527.46,598527.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249342',4763933,'2749','415',333276.32,333276.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249342',4763934,'2750','415',651723.57,652683.46,959.89,158381.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','249342',4763935,'2751','415',114626.93,115319.56,692.63,114283.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','249342',4763936,'2752','415',736526.66,737442.55,915.89,151121.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','249342',4763937,'2753','415',109550.22,110348.77,798.55,131760.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','249342',4763938,'2754','415',691649.90,692494.02,844.12,139279.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','249342',4763939,'2755','415',124830.51,125898.09,1067.58,176150.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','249342',4763940,'2756','416',249611.07,251485.51,1874.44,656054.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249342',4763941,'2757','416',203398.40,203908.71,510.31,178608.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','249342',4763942,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249342',4763943,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249471',4766086,'2744','415',51526.20,53211.86,1685.66,278133.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','249471',4766087,'2745','415',105757.69,107207.93,1450.24,239289.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','249471',4766088,'2746','415',340963.50,342088.20,1124.70,185575.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','249471',4766089,'2747','415',762997.27,764684.86,1687.59,278452.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','249471',4766090,'2748','415',598527.46,600225.61,1698.15,280194.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','249471',4766091,'2749','415',333276.32,333701.89,425.57,70219.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','249471',4766092,'2750','415',652683.46,653973.65,1290.19,212881.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','249471',4766093,'2751','415',115319.56,115319.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249471',4766094,'2752','415',737442.55,739622.21,2179.66,359643.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','249471',4766095,'2753','415',110348.77,110348.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249471',4766096,'2754','415',692494.02,694604.55,2110.53,348237.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','249471',4766097,'2755','415',125898.09,125898.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249471',4766098,'2756','416',251485.51,253026.69,1541.18,539413.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249471',4766099,'2757','416',203908.71,205006.27,1097.56,384146.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249471',4766100,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249471',4766101,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249574',4767887,'2744','415',53211.86,54957.33,1745.47,288002.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','249574',4767888,'2745','415',107207.93,109086.15,1878.22,309906.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','249574',4767889,'2746','415',342088.20,343400.07,1311.87,216458.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','249574',4767890,'2747','415',764684.86,767323.25,2638.39,435334.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','249574',4767891,'2748','415',600225.61,602456.10,2230.49,368030.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','249574',4767892,'2749','415',333701.89,334371.57,669.68,110497.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','249574',4767893,'2750','415',653973.65,655387.86,1414.21,233344.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','249574',4767894,'2751','415',115319.56,115319.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249574',4767895,'2752','415',739622.21,741136.61,1514.40,249876.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249574',4767896,'2753','415',110348.77,110348.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249574',4767897,'2754','415',694604.55,696101.45,1496.90,246988.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','249574',4767898,'2755','415',125898.09,126039.94,141.85,23405.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','249574',4767899,'2756','416',253026.69,254154.43,1127.74,394709.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249574',4767900,'2757','416',205006.27,205544.82,538.55,188492.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','249574',4767901,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249574',4767902,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249708',4769890,'2744','415',54957.33,56564.40,1607.07,265166.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','249708',4769891,'2745','415',109086.15,110707.66,1621.51,267549.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','249708',4769892,'2746','415',343400.07,345441.20,2041.13,336786.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','249708',4769893,'2747','415',767323.25,769514.00,2190.75,361473.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','249708',4769894,'2748','415',602456.10,604003.46,1547.36,255314.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','249708',4769895,'2749','415',334371.57,336397.95,2026.38,334352.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','249708',4769896,'2750','415',655387.86,655387.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249708',4769897,'2751','415',115319.56,115319.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249708',4769898,'2752','415',741136.61,741136.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249708',4769899,'2753','415',110348.77,110348.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249708',4769900,'2754','415',696101.45,696101.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249708',4769901,'2755','415',126039.94,126039.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249708',4769902,'2756','416',254154.43,254882.01,727.58,254653.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249708',4769903,'2757','416',205544.82,207168.91,1624.09,568431.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','249708',4769904,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249708',4769905,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249860',4772562,'2744','415',56565.40,57527.20,961.80,158697.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249860',4772563,'2745','415',110707.66,111386.65,678.99,112033.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','249860',4772564,'2746','415',345441.20,346025.60,584.40,96426.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249860',4772565,'2747','415',769514.00,770515.43,1001.43,165235.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','249860',4772566,'2748','415',604003.46,605141.98,1138.52,187855.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','249860',4772567,'2749','415',336397.95,336818.64,420.69,69413.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','249860',4772568,'2750','415',655387.86,656701.18,1313.32,216697.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','249860',4772569,'2751','415',115319.56,116079.47,759.91,125385.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','249860',4772570,'2752','415',741136.61,742702.59,1565.98,258386.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','249860',4772571,'2753','415',110348.77,111048.43,699.66,115443.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','249860',4772572,'2754','415',696101.45,697733.97,1632.52,269365.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','249860',4772573,'2755','415',126039.94,126679.99,640.05,105608.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','249860',4772574,'2756','416',254882.01,255961.99,1079.98,372593.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','249860',4772575,'2757','416',207168.91,208170.71,1001.80,345621.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249860',4772576,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249860',4772577,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249981',4774744,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249981',4774745,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249981',4774746,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249981',4774747,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249981',4774748,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','249981',4774749,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249981',4774750,'2750','415',656701.18,658089.97,1388.79,229150.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','249981',4774751,'2751','415',116079.47,117618.85,1539.38,253997.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','249981',4774752,'2752','415',742702.59,744235.59,1533.00,252945.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','249981',4774753,'2753','415',111048.43,112480.17,1431.74,236237.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','249981',4774754,'2754','415',697733.97,699086.01,1352.04,223086.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','249981',4774755,'2755','415',126679.99,127676.19,996.20,164373.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','249981',4774756,'2756','416',255961.99,256889.24,927.25,319901.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','249981',4774757,'2757','416',208170.71,209216.44,1045.73,360776.85,0.00,0.00,0.00,0.00,0.00),('1','185','938','249981',4774758,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','249981',4774759,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250088',4776465,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250088',4776466,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250088',4776467,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250088',4776468,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250088',4776469,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250088',4776470,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250088',4776471,'2750','415',658089.97,658089.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250088',4776472,'2751','415',117618.85,117618.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250088',4776473,'2752','415',744235.59,744235.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250088',4776474,'2753','415',112480.17,112480.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250088',4776475,'2754','415',699086.01,699086.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250088',4776476,'2755','415',127676.19,127676.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','250088',4776477,'2756','416',256889.24,257510.72,621.48,214410.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','250088',4776478,'2757','416',209216.44,209826.30,609.86,210401.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','250088',4776479,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250088',4776480,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250222',4778686,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250222',4778687,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250222',4778688,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250222',4778689,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250222',4778690,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250222',4778691,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250222',4778692,'2750','415',658089.97,658089.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250222',4778693,'2751','415',117618.85,117618.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250222',4778694,'2752','415',744235.59,744235.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250222',4778695,'2753','415',112480.17,112480.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250222',4778696,'2754','415',699086.01,699086.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250222',4778697,'2755','415',127676.19,127676.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','250222',4778698,'2756','416',257510.72,258057.72,547.00,188715.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','250222',4778699,'2757','416',209826.30,210286.49,460.19,158765.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','250222',4778700,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250222',4778701,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250351',4780813,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250351',4780814,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250351',4780815,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250351',4780816,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250351',4780817,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250351',4780818,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250351',4780819,'2750','415',658089.97,660556.12,2466.15,406914.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','250351',4780820,'2751','415',117618.85,119289.57,1670.72,275668.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','250351',4780821,'2752','415',744235.59,746473.72,2238.13,369291.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','250351',4780822,'2753','415',112480.17,114889.11,2408.94,397475.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','250351',4780823,'2754','415',699086.01,700766.45,1680.44,277272.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','250351',4780824,'2755','415',127676.19,129887.31,2211.12,364834.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','250351',4780825,'2756','416',258057.72,258139.10,81.38,28076.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','250351',4780826,'2757','416',210286.49,211318.69,1032.20,356109.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250351',4780827,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250351',4780828,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250445',4782209,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250445',4782210,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250445',4782211,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250445',4782212,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250445',4782213,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250445',4782214,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250445',4782215,'2750','415',660556.12,662533.81,1977.69,326318.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','250445',4782216,'2751','415',119289.57,121158.79,1869.22,308421.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','250445',4782217,'2752','415',746473.72,748272.62,1798.90,296818.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','250445',4782218,'2753','415',114889.11,116656.52,1767.41,291622.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','250445',4782219,'2754','415',700766.45,702366.57,1600.12,264019.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','250445',4782220,'2755','415',129887.31,131303.71,1416.40,233706.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','250445',4782221,'2756','416',258139.10,259659.76,1520.66,524627.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','250445',4782222,'2757','416',211318.69,213025.34,1706.65,588794.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','250445',4782223,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250445',4782224,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250561',4784348,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250561',4784349,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250561',4784350,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250561',4784351,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250561',4784352,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250561',4784353,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250561',4784354,'2750','415',662533.81,663663.95,1130.14,186473.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','250561',4784355,'2751','415',121158.79,122421.49,1262.70,208345.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','250561',4784356,'2752','415',748272.62,749330.13,1057.51,174489.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','250561',4784357,'2753','415',116656.52,117937.24,1280.72,211318.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','250561',4784358,'2754','415',702366.57,703646.20,1279.63,211138.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','250561',4784359,'2755','415',131303.71,132030.62,726.91,119940.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','250561',4784360,'2756','416',259659.76,259968.33,308.57,106456.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','250561',4784361,'2757','416',213025.34,213654.24,628.90,216970.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','250561',4784362,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250561',4784363,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250799',4788473,'2744','415',57527.20,57527.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250799',4788474,'2745','415',111386.65,111386.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250799',4788475,'2746','415',346025.60,346025.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250799',4788476,'2747','415',770515.43,770515.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250799',4788477,'2748','415',605141.98,605141.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','250799',4788478,'2749','415',336818.64,336818.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250799',4788479,'2750','415',663663.95,663663.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250799',4788480,'2751','415',122421.49,122421.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250799',4788481,'2752','415',749330.13,749330.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250799',4788482,'2753','415',117937.24,117937.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250799',4788483,'2754','415',703646.20,703646.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','250799',4788484,'2755','415',132030.62,132030.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','250799',4788485,'2756','416',259968.33,261345.37,1377.04,475078.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','250799',4788486,'2757','416',213654.24,215114.40,1460.16,503755.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','250799',4788487,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','250799',4788488,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251012',4792428,'2744','415',57527.20,58967.82,1440.62,237702.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','251012',4792429,'2745','415',111386.65,113046.40,1659.75,273858.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251012',4792430,'2746','415',346025.60,347402.53,1376.93,227193.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','251012',4792431,'2747','415',770515.43,771884.28,1368.85,225860.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','251012',4792432,'2748','415',605141.98,606616.35,1474.37,243271.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','251012',4792433,'2749','415',336818.64,338171.39,1352.75,223203.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','251012',4792434,'2750','415',663663.95,665848.68,2184.73,360480.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','251012',4792435,'2751','415',122421.49,122975.53,554.04,91416.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','251012',4792436,'2752','415',749330.13,751952.78,2622.65,432737.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251012',4792437,'2753','415',117937.24,118653.24,716.00,118140.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251012',4792438,'2754','415',703646.20,705340.92,1694.72,279628.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','251012',4792439,'2755','415',132030.62,133845.76,1815.14,299498.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','251012',4792440,'2756','416',261345.37,263069.04,1723.67,594666.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','251012',4792441,'2757','416',215114.40,216778.06,1663.66,573962.70,0.00,0.00,0.00,0.00,0.00),('1','185','938','251012',4792442,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251012',4792443,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251153',4794740,'2744','415',58967.82,60113.97,1146.15,189114.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251153',4794741,'2745','415',113046.40,114041.52,995.12,164194.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','251153',4794742,'2746','415',347402.53,348794.29,1391.76,229640.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','251153',4794743,'2747','415',771884.28,773014.39,1130.11,186468.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','251153',4794744,'2748','415',606616.35,607763.02,1146.67,189200.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','251153',4794745,'2749','415',338171.39,338531.87,360.48,59479.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','251153',4794746,'2750','415',665848.68,668539.47,2690.79,443980.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','251153',4794747,'2751','415',122975.53,124808.50,1832.97,302440.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','251153',4794748,'2752','415',751952.78,754945.90,2993.12,493864.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','251153',4794749,'2753','415',118653.24,120226.65,1573.41,259612.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','251153',4794750,'2754','415',705340.92,707400.74,2059.82,339870.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','251153',4794751,'2755','415',133845.76,136046.66,2200.90,363148.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','251153',4794752,'2756','416',263069.04,264381.93,1312.89,452947.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','251153',4794753,'2757','416',216778.06,217646.36,868.30,299563.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','251153',4794754,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251153',4794755,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251277',4796818,'2744','415',60113.97,60668.32,554.35,91467.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251277',4796819,'2745','415',114041.52,114720.46,678.94,112025.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','251277',4796820,'2746','415',348794.29,349547.50,753.21,124279.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','251277',4796821,'2747','415',773014.39,773798.84,784.45,129434.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','251277',4796822,'2748','415',607763.02,608553.80,790.78,130478.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','251277',4796823,'2749','415',338531.87,339091.22,559.35,92292.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','251277',4796824,'2750','415',668539.47,670681.98,2142.51,353514.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','251277',4796825,'2751','415',124808.50,126521.91,1713.41,282712.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','251277',4796826,'2752','415',754945.90,757516.12,2570.22,424086.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','251277',4796827,'2753','415',120226.65,122861.70,2635.05,434783.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251277',4796828,'2754','415',707400.74,709796.61,2395.87,395318.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','251277',4796829,'2755','415',136046.66,137803.11,1756.45,289814.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','251277',4796830,'2756','416',264381.93,265400.42,1018.49,351379.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','251277',4796831,'2757','416',217646.36,218140.63,494.27,170523.15,0.00,0.00,0.00,0.00,0.00),('1','185','938','251277',4796832,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251277',4796833,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251408',4799051,'2744','415',60668.32,62304.24,1625.92,268276.80,0.00,0.00,10.00,0.00,0.00),('1','185','935','251408',4799052,'2745','415',114720.46,116121.87,1391.41,229582.65,0.00,0.00,10.00,0.00,0.00),('1','185','935','251408',4799053,'2746','415',349547.50,350893.95,1336.45,220514.25,0.00,0.00,10.00,0.00,0.00),('1','185','935','251408',4799054,'2747','415',773798.84,774967.48,1158.64,191175.60,0.00,0.00,10.00,0.00,0.00),('1','185','935','251408',4799055,'2748','415',608553.80,610444.56,1880.76,310325.40,0.00,0.00,10.00,0.00,0.00),('1','185','935','251408',4799056,'2749','415',339091.22,340065.79,964.57,159154.05,0.00,0.00,10.00,0.00,0.00),('1','185','936','251408',4799057,'2750','415',670681.98,671767.59,1075.61,177475.65,0.00,0.00,10.00,0.00,0.00),('1','185','936','251408',4799058,'2751','415',126521.91,126531.91,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','936','251408',4799059,'2752','415',757516.12,758915.50,1389.38,229247.70,0.00,0.00,10.00,0.00,0.00),('1','185','936','251408',4799060,'2753','415',122861.70,122881.70,0.00,0.00,0.00,0.00,20.00,0.00,0.00),('1','185','936','251408',4799061,'2754','415',709796.61,711277.63,1471.02,242718.30,0.00,0.00,10.00,0.00,0.00),('1','185','936','251408',4799062,'2755','415',137803.11,137813.11,0.00,0.00,0.00,0.00,10.00,0.00,0.00),('1','185','937','251408',4799063,'2756','416',265400.42,266497.41,1096.99,378461.55,0.00,0.00,0.00,0.00,0.00),('1','185','937','251408',4799064,'2757','416',218140.63,219546.25,1405.62,484938.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','251408',4799065,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251408',4799066,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251528',4801039,'2744','415',62304.24,62321.39,17.15,2829.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251528',4801040,'2745','415',116121.87,118303.87,2182.00,360030.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251528',4801041,'2746','415',350893.95,350893.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251528',4801042,'2747','415',774967.48,776987.51,2020.03,333304.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','251528',4801043,'2748','415',610444.56,612096.94,1652.38,272642.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','251528',4801044,'2749','415',340065.79,341191.07,1125.28,185671.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','251528',4801045,'2750','415',671767.59,673850.53,2082.94,343685.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','251528',4801046,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251528',4801047,'2752','415',758915.50,761107.19,2191.69,361628.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','251528',4801048,'2753','415',122881.70,122985.43,103.73,17115.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','251528',4801049,'2754','415',711277.63,713437.57,2159.94,356390.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','251528',4801050,'2755','415',137813.11,137813.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','251528',4801051,'2756','416',266497.41,266989.23,491.82,169677.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','251528',4801052,'2757','416',219546.25,220498.25,952.00,328440.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251528',4801053,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251528',4801054,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251656',4803454,'2744','415',62321.39,63341.08,1019.69,168248.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','251656',4803455,'2745','415',118303.87,119533.00,1229.13,202806.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','251656',4803456,'2746','415',350893.95,352060.82,1166.87,192533.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','251656',4803457,'2747','415',776987.51,777938.35,950.84,156888.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','251656',4803458,'2748','415',612096.94,613751.15,1654.21,272944.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','251656',4803459,'2749','415',341191.07,341883.25,692.18,114209.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','251656',4803460,'2750','415',673850.53,674723.14,872.61,143980.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','251656',4803461,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251656',4803462,'2752','415',761107.19,762361.04,1253.85,206885.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251656',4803463,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251656',4803464,'2754','415',713437.57,713914.02,476.45,78614.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251656',4803465,'2755','415',137813.11,137813.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','251656',4803466,'2756','416',266989.23,268186.08,1196.85,412913.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','251656',4803467,'2757','416',220498.25,221893.66,1395.41,481416.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','251656',4803468,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251656',4803469,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251754',4805319,'2744','415',63341.08,65083.41,1742.33,287484.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','251754',4805320,'2745','415',119533.00,121146.75,1613.75,266268.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251754',4805321,'2746','415',352060.82,352590.93,530.11,87468.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','251754',4805322,'2747','415',777938.35,779951.70,2013.35,332202.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251754',4805323,'2748','415',613751.15,615437.25,1686.10,278206.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','251754',4805324,'2749','415',341883.25,342515.46,632.21,104314.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','251754',4805325,'2750','415',674723.14,676263.73,1540.59,254197.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','251754',4805326,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251754',4805327,'2752','415',762361.04,763934.49,1573.45,259619.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251754',4805328,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251754',4805329,'2754','415',713914.02,715035.90,1121.88,185110.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','251754',4805330,'2755','415',137813.11,137813.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','251754',4805331,'2756','416',268186.08,268538.98,352.90,121750.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','251754',4805332,'2757','416',221893.66,223742.04,1848.38,637691.10,0.00,0.00,0.00,0.00,0.00),('1','185','938','251754',4805333,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251754',4805334,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251886',4807410,'2744','415',65083.41,65911.56,828.15,136644.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','251886',4807411,'2745','415',121146.75,122611.77,1465.02,241728.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','251886',4807412,'2746','415',352590.93,353338.51,747.58,123350.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','251886',4807413,'2747','415',779951.70,781337.76,1386.06,228699.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','251886',4807414,'2748','415',615437.25,616708.49,1271.24,209754.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','251886',4807415,'2749','415',342515.46,343293.51,778.05,128378.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251886',4807416,'2750','415',676263.73,677640.46,1376.73,227160.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','251886',4807417,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251886',4807418,'2752','415',763934.49,765569.39,1634.90,269758.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','251886',4807419,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251886',4807420,'2754','415',715035.90,716130.76,1094.86,180651.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','251886',4807421,'2755','415',137813.11,137813.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','251886',4807422,'2756','416',268538.98,269249.95,710.97,245284.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','251886',4807423,'2757','416',223742.04,224213.51,471.47,162657.15,0.00,0.00,0.00,0.00,0.00),('1','185','938','251886',4807424,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251886',4807425,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','251991',4809342,'2744','415',65911.56,67509.87,1598.31,263721.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','251991',4809343,'2745','415',122611.77,124043.84,1432.07,236291.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','251991',4809344,'2746','415',353338.51,353993.59,655.08,108088.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','251991',4809345,'2747','415',781337.76,783376.66,2038.90,336418.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','251991',4809346,'2748','415',616708.49,617937.14,1228.65,202727.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','251991',4809347,'2749','415',343293.51,344215.36,921.85,152105.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','251991',4809348,'2750','415',677640.46,679278.67,1638.21,270304.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','251991',4809349,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251991',4809350,'2752','415',765569.39,767673.71,2104.32,347212.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','251991',4809351,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','251991',4809352,'2754','415',716130.76,717633.94,1503.18,248024.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','251991',4809353,'2755','415',137813.11,138302.49,489.38,80747.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','251991',4809354,'2756','416',269249.95,269988.86,738.91,254923.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','251991',4809355,'2757','416',224213.51,224278.33,64.82,22362.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','251991',4809356,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','251991',4809357,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252131',4811667,'2744','415',67509.87,68909.45,1399.58,230930.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','252131',4811668,'2745','415',124043.84,125561.45,1517.61,250405.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','252131',4811669,'2746','415',353993.59,354648.32,654.73,108030.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','252131',4811670,'2747','415',783376.66,784648.27,1271.61,209815.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','252131',4811671,'2748','415',617937.14,619534.21,1597.07,263516.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','252131',4811672,'2749','415',344215.36,344833.75,618.39,102034.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','252131',4811673,'2750','415',679278.67,680317.74,1039.07,171446.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','252131',4811674,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252131',4811675,'2752','415',767673.71,769220.67,1546.96,255248.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','252131',4811676,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252131',4811677,'2754','415',717633.94,718667.58,1033.64,170550.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','252131',4811678,'2755','415',138302.49,138302.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','252131',4811679,'2756','416',269988.86,270272.20,283.34,97752.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','252131',4811680,'2757','416',224278.33,224715.46,437.13,150809.85,0.00,0.00,0.00,0.00,0.00),('1','185','938','252131',4811681,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252131',4811682,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252250',4813695,'2744','415',68909.45,69469.65,560.20,92433.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252250',4813696,'2745','415',125561.45,127631.59,2070.14,341573.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','252250',4813697,'2746','415',354648.32,355954.54,1306.22,215526.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','252250',4813698,'2747','415',784648.27,786094.87,1446.60,238689.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252250',4813699,'2748','415',619534.21,621423.27,1889.06,311694.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','252250',4813700,'2749','415',344833.75,345171.70,337.95,55761.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','252250',4813701,'2750','415',680317.74,681644.04,1326.30,218839.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','252250',4813702,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252250',4813703,'2752','415',769220.67,771601.90,2381.23,392902.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','252250',4813704,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252250',4813705,'2754','415',718667.58,720598.89,1931.31,318666.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','252250',4813706,'2755','415',138302.49,138375.81,73.32,12097.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','252250',4813707,'2756','416',270272.20,271592.11,1319.91,455368.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','252250',4813708,'2757','416',224715.46,226200.70,1485.24,512407.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','252250',4813709,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252250',4813710,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252355',4815629,'2744','415',69469.65,71078.22,1608.57,265414.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','252355',4815630,'2745','415',127631.59,129130.46,1498.87,247313.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','252355',4815631,'2746','415',355954.54,356902.48,947.94,156410.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','252355',4815632,'2747','415',786094.87,787349.28,1254.41,206977.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','252355',4815633,'2748','415',621423.27,622963.75,1540.48,254179.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','252355',4815634,'2749','415',345171.70,345816.76,645.06,106434.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','252355',4815635,'2750','415',681644.04,683157.06,1513.02,249648.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','252355',4815636,'2751','415',126531.91,126531.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252355',4815637,'2752','415',771601.90,773400.40,1798.50,296752.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','252355',4815638,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252355',4815639,'2754','415',720598.89,721756.46,1157.57,190999.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','252355',4815640,'2755','415',138375.81,138375.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','252355',4815641,'2756','416',271592.11,272664.22,1072.11,369877.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','252355',4815642,'2757','416',226200.70,227373.32,1172.62,404553.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','252355',4815643,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252355',4815644,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252472',4817915,'2744','415',71078.22,72902.66,1824.44,301032.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','252472',4817916,'2745','415',129130.46,131551.80,2421.34,399521.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','252472',4817917,'2746','415',356902.48,358215.61,1313.13,216666.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','252472',4817918,'2747','415',787349.28,789566.92,2217.64,365910.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','252472',4817919,'2748','415',622963.75,624922.79,1959.04,323241.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','252472',4817920,'2749','415',345816.76,347183.93,1367.17,225583.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','252472',4817921,'2750','415',683157.06,684748.25,1591.19,262546.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','252472',4817922,'2751','415',126531.91,126579.59,47.68,7867.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','252472',4817923,'2752','415',773400.40,775130.19,1729.79,285415.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','252472',4817924,'2753','415',122985.43,122985.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252472',4817925,'2754','415',721756.46,723440.33,1683.87,277838.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','252472',4817926,'2755','415',138375.81,138495.79,119.98,19796.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','252472',4817927,'2756','416',272664.22,273421.12,756.90,261130.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','252472',4817928,'2757','416',227373.32,227820.66,447.34,154332.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','252472',4817929,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252472',4817930,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252619',4820393,'2744','415',72902.66,74582.34,1679.68,277147.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','252619',4820394,'2745','415',131551.80,133595.12,2043.32,337147.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','252619',4820395,'2746','415',358215.61,359633.58,1417.97,233965.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','252619',4820396,'2747','415',789566.92,791333.68,1766.76,291515.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','252619',4820397,'2748','415',624922.79,626904.19,1981.40,326931.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252619',4820398,'2749','415',347183.93,348592.73,1408.80,232452.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252619',4820399,'2750','415',684748.25,686647.70,1899.45,313409.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','252619',4820400,'2751','415',126579.59,126579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252619',4820401,'2752','415',775130.19,776879.56,1749.37,288646.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','252619',4820402,'2753','415',122985.43,123492.76,507.33,83709.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','252619',4820403,'2754','415',723440.33,725603.65,2163.32,356947.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','252619',4820404,'2755','415',138495.79,138495.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','252619',4820405,'2756','416',273421.12,274314.54,893.42,308229.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','252619',4820406,'2757','416',227820.66,228751.25,930.59,321053.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','252619',4820407,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252619',4820408,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252721',4822088,'2744','415',74582.34,75512.23,929.89,153431.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','252721',4822089,'2745','415',133595.12,136805.84,3210.72,529768.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','252721',4822090,'2746','415',359633.58,361119.30,1485.72,245143.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','252721',4822091,'2747','415',791333.68,794168.20,2834.52,467695.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','252721',4822092,'2748','415',626904.19,628986.72,2082.53,343617.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','252721',4822093,'2749','415',348592.73,350743.70,2150.97,354910.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','252721',4822094,'2750','415',686647.70,689245.77,2598.07,428681.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','252721',4822095,'2751','415',126579.59,126579.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252721',4822096,'2752','415',776879.56,779774.89,2874.68,474322.20,0.00,0.00,20.65,0.00,0.00),('1','185','936','252721',4822097,'2753','415',123492.76,124054.35,561.59,92662.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','252721',4822098,'2754','415',725603.65,728044.57,2440.92,402751.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','252721',4822099,'2755','415',138495.79,140066.91,1571.12,259234.80,0.00,0.00,0.00,0.00,0.00),('1','185','937','252721',4822100,'2756','416',274314.54,274863.65,549.11,189442.95,0.00,0.00,0.00,0.00,0.00),('1','185','937','252721',4822101,'2757','416',228751.25,228922.28,171.03,59005.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','252721',4822102,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252721',4822103,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252858',4824291,'2744','415',75512.23,76927.94,1415.71,233592.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','252858',4824292,'2745','415',136805.84,138758.77,1952.93,322233.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','252858',4824293,'2746','415',361119.30,362801.50,1682.20,277563.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252858',4824294,'2747','415',794168.20,795985.12,1816.92,299791.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','252858',4824295,'2748','415',628986.72,630361.92,1375.20,226908.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252858',4824296,'2749','415',350743.70,351513.71,770.01,127051.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','252858',4824297,'2750','415',689245.77,690707.76,1461.99,241228.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','252858',4824298,'2751','415',126579.59,127475.26,895.67,147785.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','252858',4824299,'2752','415',779774.89,781697.46,1922.57,317224.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','252858',4824300,'2753','415',124054.35,124205.00,150.65,24857.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','252858',4824301,'2754','415',728044.57,729873.06,1828.49,301700.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','252858',4824302,'2755','415',140066.91,140222.05,155.14,25598.10,0.00,0.00,0.00,0.00,0.00),('1','185','937','252858',4824303,'2756','416',274863.65,275476.87,613.22,211560.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','252858',4824304,'2757','416',228922.28,230334.87,1412.59,487343.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','252858',4824305,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252858',4824306,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','252974',4826162,'2744','415',76927.94,78133.50,1205.56,198917.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','252974',4826163,'2745','415',138758.77,140665.35,1906.58,314585.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','252974',4826164,'2746','415',362801.50,363171.64,370.14,61073.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','252974',4826165,'2747','415',795985.12,798328.09,2342.97,386590.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','252974',4826166,'2748','415',630361.92,631934.01,1572.09,259394.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','252974',4826167,'2749','415',351513.71,352769.90,1256.19,207271.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','252974',4826168,'2750','415',690707.76,691740.93,1033.17,170473.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','252974',4826169,'2751','415',127475.26,128704.60,1229.34,202841.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','252974',4826170,'2752','415',781697.46,783534.74,1837.28,303151.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','252974',4826171,'2753','415',124205.00,124205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','252974',4826172,'2754','415',729873.06,731841.93,1968.87,324863.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','252974',4826173,'2755','415',140222.05,140888.65,666.60,109989.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','252974',4826174,'2756','416',275476.87,275914.52,437.65,150989.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','252974',4826175,'2757','416',230334.87,230755.97,421.10,145279.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','252974',4826176,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','252974',4826177,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253095',4828318,'2744','415',78133.50,79615.25,1481.75,244488.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','253095',4828319,'2745','415',140665.35,142119.48,1454.13,239931.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','253095',4828320,'2746','415',363171.64,364630.39,1458.75,240693.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','253095',4828321,'2747','415',798328.09,800105.03,1776.94,293195.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','253095',4828322,'2748','415',631934.01,633169.22,1235.21,203809.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','253095',4828323,'2749','415',352769.90,354139.99,1370.09,226064.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','253095',4828324,'2750','415',691740.93,693295.41,1554.48,256489.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','253095',4828325,'2751','415',128704.60,128709.51,4.91,810.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','253095',4828326,'2752','415',783534.74,785566.75,2032.01,335281.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','253095',4828327,'2753','415',124205.00,124205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253095',4828328,'2754','415',731841.93,733347.45,1505.52,248410.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','253095',4828329,'2755','415',140888.65,141530.94,642.29,105977.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','253095',4828330,'2756','416',275914.52,276278.62,364.10,125614.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','253095',4828331,'2757','416',230755.97,232218.53,1462.56,504583.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','253095',4828332,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253095',4828333,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253207',4830238,'2744','415',79615.25,80290.74,675.49,111455.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','253207',4830239,'2745','415',142119.48,144664.05,2544.57,419854.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','253207',4830240,'2746','415',364630.39,365573.12,942.73,155550.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','253207',4830241,'2747','415',800105.03,802395.05,2269.37,374446.05,0.00,0.00,20.65,0.00,0.00),('1','185','935','253207',4830242,'2748','415',633169.22,634202.02,1032.80,170412.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253207',4830243,'2749','415',354139.99,355103.70,963.71,159012.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','253207',4830244,'2750','415',693295.41,694649.67,1354.26,223452.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','253207',4830245,'2751','415',128709.51,128709.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253207',4830246,'2752','415',785566.75,787194.24,1627.49,268535.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','253207',4830247,'2753','415',124205.00,124205.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253207',4830248,'2754','415',733347.45,735078.94,1731.49,285695.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','253207',4830249,'2755','415',141530.94,141803.09,272.15,44904.75,0.00,0.00,0.00,0.00,0.00),('1','185','937','253207',4830250,'2756','416',276278.62,277545.36,1266.74,437025.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','253207',4830251,'2757','416',232218.53,233414.43,1195.90,412585.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','253207',4830252,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253207',4830253,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253369',4832762,'2744','415',80290.74,82017.55,1726.81,284923.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','253369',4832763,'2745','415',144664.05,146382.82,1718.77,283597.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','253369',4832764,'2746','415',365573.12,366994.09,1420.97,234460.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','253369',4832765,'2747','415',802395.05,804232.75,1837.70,303220.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','253369',4832766,'2748','415',634202.02,635934.74,1732.72,285898.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','253369',4832767,'2749','415',355103.70,356765.14,1661.44,274137.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','253369',4832768,'2750','415',694649.67,695399.98,750.31,123801.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','253369',4832769,'2751','415',128709.51,129375.02,665.51,109809.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','253369',4832770,'2752','415',787194.24,787793.31,599.07,98846.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','253369',4832771,'2753','415',124205.00,124964.41,759.41,125302.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','253369',4832772,'2754','415',735078.94,735822.18,743.24,122634.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','253369',4832773,'2755','415',141803.09,142311.79,508.70,83935.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','253369',4832774,'2756','416',277545.36,278836.09,1290.73,445301.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','253369',4832775,'2757','416',233414.43,235790.63,2376.20,819789.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253369',4832776,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253369',4832777,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253480',4834808,'2744','415',82017.55,82017.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253480',4834809,'2745','415',146382.82,146827.47,444.65,73367.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','253480',4834810,'2746','415',366994.09,366994.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253480',4834811,'2747','415',804232.75,804805.66,572.91,94530.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','253480',4834812,'2748','415',635934.74,635934.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253480',4834813,'2749','415',356765.14,356765.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253480',4834814,'2750','415',695399.98,697830.36,2430.38,401012.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','253480',4834815,'2751','415',129375.02,131810.81,2435.79,401905.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','253480',4834816,'2752','415',787793.31,790264.10,2470.79,407680.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','253480',4834817,'2753','415',124964.41,127464.86,2500.45,412574.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','253480',4834818,'2754','415',735822.18,737867.66,2045.48,337504.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','253480',4834819,'2755','415',142311.79,144379.28,2067.49,341135.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','253480',4834820,'2756','416',278836.09,279493.50,657.41,226806.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','253480',4834821,'2757','416',235790.63,236474.43,683.80,235911.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253480',4834822,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253480',4834823,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253606',4836976,'2744','415',82017.55,83732.77,1715.22,283011.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','253606',4836977,'2745','415',146827.47,148397.53,1570.06,259059.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','253606',4836978,'2746','415',366994.09,368054.24,1060.15,174924.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','253606',4836979,'2747','415',804805.66,806231.46,1425.80,235257.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253606',4836980,'2748','415',635934.74,637475.26,1540.52,254185.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','253606',4836981,'2749','415',356765.14,357455.33,690.19,113881.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','253606',4836982,'2750','415',697830.36,698918.28,1087.92,179506.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','253606',4836983,'2751','415',131810.81,132365.86,555.05,91583.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','253606',4836984,'2752','415',790264.10,791757.81,1493.71,246462.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','253606',4836985,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253606',4836986,'2754','415',737867.66,739143.79,1276.13,210561.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','253606',4836987,'2755','415',144379.28,144379.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','253606',4836988,'2756','416',279493.50,280254.71,761.21,262617.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','253606',4836989,'2757','416',236474.43,237475.17,1000.74,345255.30,0.00,0.00,0.00,0.00,0.00),('1','185','938','253606',4836990,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253606',4836991,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253703',4838685,'2744','415',83732.77,83732.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253703',4838686,'2745','415',148397.53,150683.16,2285.63,377128.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','253703',4838687,'2746','415',368054.24,368611.69,557.45,91979.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','253703',4838688,'2747','415',806231.46,808461.54,2230.08,367963.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','253703',4838689,'2748','415',637475.26,639388.59,1913.33,315699.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','253703',4838690,'2749','415',357455.33,357455.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253703',4838691,'2750','415',698918.28,701213.08,2294.80,378642.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253703',4838692,'2751','415',132365.86,132423.40,57.54,9494.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','253703',4838693,'2752','415',791757.81,794228.10,2470.29,407597.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','253703',4838694,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253703',4838695,'2754','415',739143.79,741647.47,2503.68,413107.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','253703',4838696,'2755','415',144379.28,144740.49,361.21,59599.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','253703',4838697,'2756','416',280254.71,280901.20,646.49,223039.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','253703',4838698,'2757','416',237475.17,238588.22,1113.05,384002.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','253703',4838699,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253703',4838700,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253842',4841105,'2744','415',83732.77,85110.27,1377.50,227287.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','253842',4841106,'2745','415',150683.16,152550.77,1867.61,308155.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','253842',4841107,'2746','415',368611.69,369883.34,1271.65,209822.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','253842',4841108,'2747','415',808461.54,810230.31,1768.77,291847.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','253842',4841109,'2748','415',639388.59,641062.04,1673.45,276119.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','253842',4841110,'2749','415',357455.33,358009.17,553.84,91383.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','253842',4841111,'2750','415',701213.08,701933.70,720.62,118902.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','253842',4841112,'2751','415',132423.40,133005.92,582.52,96115.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','253842',4841113,'2752','415',794228.10,795921.91,1693.81,279478.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','253842',4841114,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253842',4841115,'2754','415',741647.47,742824.71,1177.24,194244.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','253842',4841116,'2755','415',144740.49,144740.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','253842',4841117,'2756','416',280901.20,282224.61,1323.41,456576.45,0.00,0.00,0.00,0.00,0.00),('1','185','937','253842',4841118,'2757','416',238588.22,239983.33,1395.11,481312.95,0.00,0.00,0.00,0.00,0.00),('1','185','938','253842',4841119,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253842',4841120,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','253967',4843119,'2744','415',85110.27,87189.26,2078.99,343033.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','253967',4843120,'2745','415',152550.77,154819.24,2268.47,374297.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','253967',4843121,'2746','415',369883.34,372016.51,2133.17,351973.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','253967',4843122,'2747','415',810230.31,812986.33,2756.02,454743.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','253967',4843123,'2748','415',641062.04,643098.81,2036.77,336067.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','253967',4843124,'2749','415',358009.17,360189.11,2179.94,359690.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','253967',4843125,'2750','415',701933.70,701933.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253967',4843126,'2751','415',133005.92,133005.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253967',4843127,'2752','415',795921.91,795921.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253967',4843128,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253967',4843129,'2754','415',742824.71,742824.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','253967',4843130,'2755','415',144740.49,144740.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','253967',4843131,'2756','416',282224.61,283008.41,783.80,270411.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','253967',4843132,'2757','416',239983.33,240530.89,547.56,188908.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','253967',4843133,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','253967',4843134,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254089',4845462,'2744','415',87189.26,89094.08,1904.82,314295.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','254089',4845463,'2745','415',154819.24,156715.56,1896.32,312892.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','254089',4845464,'2746','415',372016.51,373907.75,1891.24,312054.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','254089',4845465,'2747','415',812986.33,814668.01,1681.68,277477.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','254089',4845466,'2748','415',643098.81,644667.44,1568.63,258823.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','254089',4845467,'2749','415',360189.11,361304.85,1115.74,184097.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','254089',4845468,'2750','415',701933.70,701933.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254089',4845469,'2751','415',133005.92,133005.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254089',4845470,'2752','415',795921.91,795921.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254089',4845471,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254089',4845472,'2754','415',742824.71,742824.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254089',4845473,'2755','415',144740.49,144740.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254089',4845474,'2756','416',283008.41,284365.44,1357.03,468175.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','254089',4845475,'2757','416',240530.89,241530.74,999.85,344948.25,0.00,0.00,0.00,0.00,0.00),('1','185','938','254089',4845476,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254089',4845477,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254184',4847284,'2744','415',89094.08,91265.89,2171.81,358348.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','254184',4847285,'2745','415',156715.56,159111.09,2395.53,395262.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','254184',4847286,'2746','415',373907.75,376493.18,2585.43,426595.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','254184',4847287,'2747','415',814668.01,817588.67,2920.66,481908.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','254184',4847288,'2748','415',644667.44,646553.64,1886.20,311223.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254184',4847289,'2749','415',361304.85,363534.14,2229.29,367832.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','254184',4847290,'2750','415',701933.70,701933.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254184',4847291,'2751','415',133005.92,133005.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254184',4847292,'2752','415',795921.91,795921.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254184',4847293,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254184',4847294,'2754','415',742824.71,742824.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254184',4847295,'2755','415',144740.49,144740.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254184',4847296,'2756','416',284365.44,284903.86,538.42,185754.90,0.00,0.00,0.00,0.00,0.00),('1','185','937','254184',4847297,'2757','416',241530.74,242198.96,668.22,230535.90,0.00,0.00,0.00,0.00,0.00),('1','185','938','254184',4847298,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254184',4847299,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254350',4850028,'2744','415',91265.89,93850.56,2584.67,426470.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','254350',4850029,'2745','415',159111.09,160827.12,1716.03,283144.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','254350',4850030,'2746','415',376493.18,378729.60,2236.42,369009.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','254350',4850031,'2747','415',817588.67,819966.31,2377.64,392310.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','254350',4850032,'2748','415',646553.64,648633.73,2080.09,343214.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','254350',4850033,'2749','415',363534.14,365721.57,2187.43,360925.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','254350',4850034,'2750','415',701933.70,701933.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254350',4850035,'2751','415',133005.92,133005.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254350',4850036,'2752','415',795921.91,795921.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254350',4850037,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254350',4850038,'2754','415',742824.71,742824.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254350',4850039,'2755','415',144740.49,144740.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254350',4850040,'2756','416',284903.86,285767.29,863.43,297883.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','254350',4850041,'2757','416',242198.96,243448.39,1249.43,431053.35,0.00,0.00,0.00,0.00,0.00),('1','185','938','254350',4850042,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254350',4850043,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254462',4851804,'2744','415',93850.56,95746.60,1896.04,312846.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','254462',4851805,'2745','415',160827.12,162764.84,1937.72,319723.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','254462',4851806,'2746','415',378729.60,380912.27,2182.67,360140.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','254462',4851807,'2747','415',819966.31,822519.34,2553.03,421249.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','254462',4851808,'2748','415',648633.73,650217.56,1583.83,261331.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','254462',4851809,'2749','415',365721.57,367326.62,1605.05,264833.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','254462',4851810,'2750','415',701933.70,701933.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254462',4851811,'2751','415',133005.92,133005.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254462',4851812,'2752','415',795921.91,795921.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254462',4851813,'2753','415',127464.86,127464.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254462',4851814,'2754','415',742824.71,742824.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254462',4851815,'2755','415',144740.49,144740.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254462',4851816,'2756','416',285767.29,286037.46,270.17,93208.65,0.00,0.00,0.00,0.00,0.00),('1','185','937','254462',4851817,'2757','416',243448.39,243788.40,340.01,117303.45,0.00,0.00,0.00,0.00,0.00),('1','185','938','254462',4851818,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254462',4851819,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254594',4854196,'2744','415',95746.60,96143.75,397.15,65529.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','254594',4854197,'2745','415',162764.84,163256.50,491.66,81123.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','254594',4854198,'2746','415',380912.27,381271.13,358.86,59211.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','254594',4854199,'2747','415',822519.34,823019.15,499.81,82468.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','254594',4854200,'2748','415',650217.56,650674.58,457.02,75408.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','254594',4854201,'2749','415',367326.62,367657.83,331.21,54649.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','254594',4854202,'2750','415',701933.70,702645.29,711.59,117412.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','254594',4854203,'2751','415',133005.92,133850.03,844.11,139278.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','254594',4854204,'2752','415',795921.91,796838.72,916.81,151273.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','254594',4854205,'2753','415',127464.86,128599.86,1135.00,187275.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254594',4854206,'2754','415',742824.71,743627.97,803.26,132537.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','254594',4854207,'2755','415',144740.49,145430.11,689.62,113787.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','254594',4854208,'2756','416',286037.46,287390.51,1353.05,473567.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','254594',4854209,'2757','416',243788.40,245410.27,1621.87,567654.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','254594',4854210,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254594',4854211,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254712',4856209,'2744','415',96143.75,96143.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254712',4856210,'2745','415',163256.50,163256.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254712',4856211,'2746','415',381271.13,381271.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254712',4856212,'2747','415',823019.15,823019.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254712',4856213,'2748','415',650674.58,650674.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254712',4856214,'2749','415',367657.83,367657.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254712',4856215,'2750','415',702645.29,704955.75,2310.46,381225.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','254712',4856216,'2751','415',133850.03,136372.09,2522.06,416139.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','254712',4856217,'2752','415',796838.72,799661.65,2797.93,461658.45,0.00,0.00,25.00,0.00,0.00),('1','185','936','254712',4856218,'2753','415',128599.86,131164.44,2564.58,423155.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','254712',4856219,'2754','415',743627.97,745663.27,2035.30,335824.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','254712',4856220,'2755','415',145430.11,147364.47,1934.36,319169.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','254712',4856221,'2756','416',287390.51,288428.85,1038.34,363419.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254712',4856222,'2757','416',245410.27,246506.02,1095.75,383512.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','254712',4856223,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254712',4856224,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254840',4858428,'2744','415',96143.75,96555.79,412.04,67986.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','254840',4858429,'2745','415',163256.50,163693.62,437.12,72124.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','254840',4858430,'2746','415',381271.13,381580.20,309.07,50996.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','254840',4858431,'2747','415',823019.15,823379.28,360.13,59421.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','254840',4858432,'2748','415',650674.58,650898.44,223.86,36936.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','254840',4858433,'2749','415',367657.83,368049.93,392.10,64696.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','254840',4858434,'2750','415',704955.75,705061.66,105.91,17475.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','254840',4858435,'2751','415',136372.09,136435.57,63.48,10474.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','254840',4858436,'2752','415',799661.65,799832.94,171.29,28262.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','254840',4858437,'2753','415',131164.44,131250.20,85.76,14150.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','254840',4858438,'2754','415',745663.27,745788.19,124.92,20611.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','254840',4858439,'2755','415',147364.47,147407.92,43.45,7169.25,0.00,0.00,0.00,0.00,0.00),('1','185','937','254840',4858440,'2756','416',288428.85,289015.86,587.01,205453.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','254840',4858441,'2757','416',246506.02,246768.48,262.46,91861.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254840',4858442,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254840',4858443,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','254954',4860352,'2744','415',96555.79,98054.09,1498.30,247219.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','254954',4860353,'2745','415',163693.62,166157.30,2463.68,406507.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','254954',4860354,'2746','415',381580.20,383860.17,2279.97,376195.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','254954',4860355,'2747','415',823379.28,825742.46,2363.18,389924.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','254954',4860356,'2748','415',650898.44,652918.60,2020.16,333326.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','254954',4860357,'2749','415',368049.93,369926.83,1876.90,309688.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','254954',4860358,'2750','415',705061.66,705061.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254954',4860359,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254954',4860360,'2752','415',799832.94,799832.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254954',4860361,'2753','415',131250.20,131250.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254954',4860362,'2754','415',745788.19,745788.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','254954',4860363,'2755','415',147407.92,147407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254954',4860364,'2756','416',289015.86,289015.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','254954',4860365,'2757','416',246768.48,246768.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254954',4860366,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','254954',4860367,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255084',4862672,'2744','415',98054.09,99695.28,1641.19,270796.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','255084',4862673,'2745','415',166157.30,167969.84,1812.54,299069.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','255084',4862674,'2746','415',383860.17,385668.38,1808.21,298354.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','255084',4862675,'2747','415',825742.46,827515.59,1773.13,292566.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','255084',4862676,'2748','415',652918.60,654777.07,1858.47,306647.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','255084',4862677,'2749','415',369926.83,371602.52,1675.69,276488.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','255084',4862678,'2750','415',705061.66,705061.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255084',4862679,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255084',4862680,'2752','415',799832.94,799832.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255084',4862681,'2753','415',131250.20,131250.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255084',4862682,'2754','415',745788.19,745788.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255084',4862683,'2755','415',147407.92,147407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255084',4862684,'2756','416',289015.86,289340.53,324.67,113634.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','255084',4862685,'2757','416',246768.48,247185.63,417.15,146002.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','255084',4862686,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255084',4862687,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255181',4864424,'2744','415',99695.28,101287.38,1592.10,262696.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','255181',4864425,'2745','415',167969.84,169702.30,1732.46,285855.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','255181',4864426,'2746','415',385668.38,387590.77,1922.39,317194.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','255181',4864427,'2747','415',827515.59,830088.89,2573.30,424594.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','255181',4864428,'2748','415',654777.07,656423.25,1646.18,271619.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','255181',4864429,'2749','415',371602.52,373148.78,1546.26,255132.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','255181',4864430,'2750','415',705061.66,705061.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255181',4864431,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255181',4864432,'2752','415',799832.94,799832.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255181',4864433,'2753','415',131250.20,131250.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255181',4864434,'2754','415',745788.19,745788.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255181',4864435,'2755','415',147407.92,147407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255181',4864436,'2756','416',289340.53,289940.38,599.85,209947.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','255181',4864437,'2757','416',247185.63,247532.20,346.57,121299.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','255181',4864438,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255181',4864439,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255334',4867127,'2744','415',101287.38,102894.82,1607.44,265227.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','255334',4867128,'2745','415',169702.30,171263.17,1560.87,257543.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','255334',4867129,'2746','415',387590.77,389130.84,1540.07,254111.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','255334',4867130,'2747','415',830088.89,831604.27,1515.38,250037.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','255334',4867131,'2748','415',656423.25,657565.40,1142.15,188454.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','255334',4867132,'2749','415',373148.78,373991.89,843.11,139113.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','255334',4867133,'2750','415',705061.66,705061.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255334',4867134,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255334',4867135,'2752','415',799832.94,799832.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255334',4867136,'2753','415',131250.20,131250.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255334',4867137,'2754','415',745788.19,745788.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255334',4867138,'2755','415',147407.92,147407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255334',4867139,'2756','416',289940.38,290394.52,454.14,158949.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255334',4867140,'2757','416',247532.20,247772.19,239.99,83996.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','255334',4867141,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255334',4867142,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255460',4869113,'2744','415',102894.82,102894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255460',4869114,'2745','415',171263.17,171263.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255460',4869115,'2746','415',389130.84,389130.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255460',4869116,'2747','415',831604.27,831604.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255460',4869117,'2748','415',657565.40,657565.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255460',4869118,'2749','415',373991.89,373991.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255460',4869119,'2750','415',705061.66,705061.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255460',4869120,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255460',4869121,'2752','415',799832.94,799832.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255460',4869122,'2753','415',131250.20,131250.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255460',4869123,'2754','415',745788.19,745788.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255460',4869124,'2755','415',147407.92,147407.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255460',4869125,'2756','416',290394.52,290673.74,279.22,97727.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255460',4869126,'2757','416',247772.19,248172.19,400.00,140000.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255460',4869127,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255460',4869128,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255704',4873194,'2744','415',102894.82,103263.99,369.17,60913.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','255704',4873195,'2745','415',171263.17,171613.18,350.01,57751.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','255704',4873196,'2746','415',389130.84,389399.12,268.28,44266.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','255704',4873197,'2747','415',831604.27,832083.76,479.49,79115.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','255704',4873198,'2748','415',657565.40,657926.38,360.98,59561.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','255704',4873199,'2749','415',373991.89,373991.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255704',4873200,'2750','415',705061.66,705691.65,629.99,103948.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','255704',4873201,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255704',4873202,'2752','415',799832.94,800417.37,584.43,96430.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','255704',4873203,'2753','415',131250.20,131433.51,183.31,30246.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','255704',4873204,'2754','415',745788.19,746186.72,398.53,65757.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','255704',4873205,'2755','415',147407.92,147867.92,460.00,75900.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255704',4873206,'2756','416',290673.74,291431.29,757.55,265142.50,0.00,0.00,0.00,0.00,0.00),('1','185','937','255704',4873207,'2757','416',248172.19,250322.00,2149.81,752433.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','255704',4873208,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255704',4873209,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255821',4874904,'2744','415',103263.99,104651.57,1387.58,228950.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','255821',4874905,'2745','415',171613.18,173216.67,1603.49,264575.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','255821',4874906,'2746','415',389399.12,390412.37,1013.25,167186.25,0.00,0.00,0.00,0.00,0.00),('1','185','935','255821',4874907,'2747','415',832083.76,833419.29,1335.53,220362.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','255821',4874908,'2748','415',657926.38,659095.47,1169.09,192899.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','255821',4874909,'2749','415',373991.89,374612.04,620.15,102324.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','255821',4874910,'2750','415',705691.65,706810.02,1118.37,184531.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','255821',4874911,'2751','415',136435.57,136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255821',4874912,'2752','415',800417.37,801744.28,1326.91,218940.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','255821',4874913,'2753','415',131433.51,131433.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255821',4874914,'2754','415',746186.72,747419.89,1233.17,203473.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','255821',4874915,'2755','415',147867.92,147867.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255821',4874916,'2756','416',291431.29,292267.17,835.88,292558.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255821',4874917,'2757','416',250322.00,251721.73,1399.73,489905.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','255821',4874918,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255821',4874919,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255954',4877068,'2744','415',104651.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255954',4877069,'2745','415',173216.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255954',4877070,'2746','415',390412.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255954',4877071,'2747','415',833419.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255954',4877072,'2748','415',659095.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255954',4877073,'2749','415',374612.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255954',4877074,'2750','415',706810.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255954',4877075,'2751','415',136435.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255954',4877076,'2752','415',801744.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255954',4877077,'2753','415',131433.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255954',4877078,'2754','415',747419.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','255954',4877079,'2755','415',147867.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255954',4877080,'2756','416',292267.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255954',4877081,'2757','416',251721.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255954',4877082,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255954',4877083,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255967',4877244,'2744','415',104651.57,105650.75,999.18,164864.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','255967',4877245,'2745','415',173216.67,174816.87,1600.20,264033.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','255967',4877246,'2746','415',390412.37,391242.69,830.32,137002.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','255967',4877247,'2747','415',833419.29,834563.75,1144.46,188835.90,0.00,0.00,0.00,0.00,0.00),('1','185','935','255967',4877248,'2748','415',659095.47,659840.88,745.41,122992.65,0.00,0.00,0.00,0.00,0.00),('1','185','935','255967',4877249,'2749','415',374612.04,375153.72,541.68,89377.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','255967',4877250,'2750','415',706810.02,708543.28,1733.26,285987.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','255967',4877251,'2751','415',136608.80,137219.63,610.83,100786.95,0.00,0.00,0.00,0.00,0.00),('1','185','936','255967',4877252,'2752','415',801744.28,803185.59,1441.31,237816.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','255967',4877253,'2753','415',131433.51,133646.99,2213.48,365224.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','255967',4877254,'2754','415',747419.89,749530.99,2111.10,348331.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','255967',4877255,'2755','415',147867.92,148463.30,595.38,98237.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','255967',4877256,'2756','416',292267.17,292725.55,458.38,160433.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','255967',4877257,'2757','416',251721.73,252061.28,339.55,118842.50,0.00,0.00,0.00,0.00,0.00),('1','185','938','255967',4877258,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','255967',4877259,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256084',4879422,'2744','415',105650.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256084',4879423,'2745','415',174816.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256084',4879424,'2746','415',391242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256084',4879425,'2747','415',834563.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256084',4879426,'2748','415',659840.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256084',4879427,'2749','415',375153.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256084',4879428,'2750','415',708543.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256084',4879429,'2751','415',137219.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256084',4879430,'2752','415',803185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256084',4879431,'2753','415',133646.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256084',4879432,'2754','415',749530.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256084',4879433,'2755','415',148463.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256084',4879434,'2756','416',292725.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256084',4879435,'2757','416',252061.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256084',4879436,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256084',4879437,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256099',4879665,'2744','415',105650.75,105650.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256099',4879666,'2745','415',174816.87,174816.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256099',4879667,'2746','415',391242.69,391242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256099',4879668,'2747','415',834563.75,834563.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256099',4879669,'2748','415',659840.88,659840.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256099',4879670,'2749','415',375153.72,375153.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256099',4879671,'2750','415',708543.28,710560.44,2007.16,331181.40,0.00,0.00,10.00,0.00,0.00),('1','185','936','256099',4879672,'2751','415',137219.63,139480.86,2236.23,368977.95,0.00,0.00,25.00,0.00,0.00),('1','185','936','256099',4879673,'2752','415',803185.59,805292.91,2077.32,342757.80,0.00,0.00,30.00,0.00,0.00),('1','185','936','256099',4879674,'2753','415',133646.34,135557.57,1901.23,313702.95,0.00,0.00,10.00,0.00,0.00),('1','185','936','256099',4879675,'2754','415',749530.99,751452.23,1901.24,313704.60,0.00,0.00,20.00,0.00,0.00),('1','185','936','256099',4879676,'2755','415',148463.30,150006.77,1533.47,253022.55,0.00,0.00,10.00,0.00,0.00),('1','185','937','256099',4879677,'2756','416',292725.55,293443.13,717.58,251153.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256099',4879678,'2757','416',252061.28,252671.34,610.06,213521.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256099',4879679,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256099',4879680,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256221',4881281,'2744','415',105650.75,105650.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256221',4881282,'2745','415',174816.87,174816.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256221',4881283,'2746','415',391242.69,391242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256221',4881284,'2747','415',834563.75,834563.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256221',4881285,'2748','415',659840.88,659840.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256221',4881286,'2749','415',375153.72,375153.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256221',4881287,'2750','415',710560.44,712845.96,2285.52,377110.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','256221',4881288,'2751','415',139480.86,141086.66,1605.80,264957.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256221',4881289,'2752','415',805292.91,807437.90,2144.99,353923.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','256221',4881290,'2753','415',135557.57,137863.59,2306.02,380493.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','256221',4881291,'2754','415',751452.23,753575.62,2123.39,350359.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','256221',4881292,'2755','415',150006.77,151733.66,1726.89,284936.85,0.00,0.00,0.00,0.00,0.00),('1','185','937','256221',4881293,'2756','416',293443.13,294045.79,602.66,213944.30,0.00,0.00,0.00,0.00,0.00),('1','185','937','256221',4881294,'2757','416',252671.34,254041.75,1370.41,486495.55,0.00,0.00,0.00,0.00,0.00),('1','185','938','256221',4881295,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256221',4881296,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256360',4883789,'2744','415',105650.75,105650.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256360',4883790,'2745','415',174816.87,174816.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256360',4883791,'2746','415',391242.69,391242.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256360',4883792,'2747','415',834563.75,834563.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256360',4883793,'2748','415',659840.88,659840.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256360',4883794,'2749','415',375153.72,375153.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','256360',4883795,'2750','415',712845.96,715093.02,2247.06,370764.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','256360',4883796,'2751','415',141086.66,142820.42,1733.76,286070.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','256360',4883797,'2752','415',807437.90,809652.00,2214.10,365326.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','256360',4883798,'2753','415',137863.59,139749.37,1885.78,311153.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','256360',4883799,'2754','415',753575.62,755148.59,1572.97,259540.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','256360',4883800,'2755','415',151733.66,153228.23,1494.57,246604.05,0.00,0.00,0.00,0.00,0.00),('1','185','937','256360',4883801,'2756','416',294045.79,295146.90,1101.11,396399.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','256360',4883802,'2757','416',254041.75,254682.03,640.28,230500.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','256360',4883803,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256360',4883804,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256495',4886121,'2744','415',105650.75,106207.97,557.22,91941.30,0.00,0.00,0.00,0.00,0.00),('1','185','935','256495',4886122,'2745','415',174816.87,175605.02,788.15,130044.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','256495',4886123,'2746','415',391242.69,392038.57,795.88,131320.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','256495',4886124,'2747','415',834563.75,835286.25,722.50,119212.50,0.00,0.00,0.00,0.00,0.00),('1','185','935','256495',4886125,'2748','415',659840.88,660637.40,796.52,131425.80,0.00,0.00,0.00,0.00,0.00),('1','185','935','256495',4886126,'2749','415',375153.72,375881.14,727.42,120024.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','256495',4886127,'2750','415',715093.02,717218.08,2125.06,350634.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','256495',4886128,'2751','415',142820.42,144939.10,2118.68,349582.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','256495',4886129,'2752','415',809652.00,812417.65,2765.65,456332.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','256495',4886130,'2753','415',139749.37,141738.06,1988.69,328133.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','256495',4886131,'2754','415',755148.59,757151.98,2003.39,330559.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','256495',4886132,'2755','415',153228.23,155291.21,2062.98,340391.70,0.00,0.00,0.00,0.00,0.00),('1','185','937','256495',4886133,'2756','416',295146.90,296236.10,1089.20,392112.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256495',4886134,'2757','416',254682.03,255722.04,1040.01,374403.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','256495',4886135,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256495',4886136,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256616',4888212,'2744','415',106207.97,107817.82,1159.85,191375.25,0.00,0.00,450.00,0.00,0.00),('1','185','935','256616',4888213,'2745','415',175605.02,177593.23,1838.21,303304.65,0.00,0.00,150.00,0.00,0.00),('1','185','935','256616',4888214,'2746','415',392038.57,393144.95,926.38,152852.70,0.00,0.00,180.00,0.00,0.00),('1','185','935','256616',4888215,'2747','415',835286.25,837001.04,1660.79,274030.35,0.00,0.00,54.00,0.00,0.00),('1','185','935','256616',4888216,'2748','415',660637.40,662828.33,2150.93,354903.45,0.00,0.00,40.00,0.00,0.00),('1','185','935','256616',4888217,'2749','415',375881.14,375951.41,-69.73,-11505.45,0.00,0.00,140.00,0.00,0.00),('1','185','936','256616',4888218,'2750','415',717218.08,719039.90,1821.82,300600.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','256616',4888219,'2751','415',144939.10,145011.36,72.26,11922.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','256616',4888220,'2752','415',812417.65,814440.44,2022.79,333760.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','256616',4888221,'2753','415',141738.06,141759.68,21.62,3567.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','256616',4888222,'2754','415',757151.98,759290.62,2113.64,348750.60,0.00,0.00,25.00,0.00,0.00),('1','185','936','256616',4888223,'2755','415',155291.21,155321.52,30.31,5001.15,0.00,0.00,0.00,0.00,0.00),('1','185','937','256616',4888224,'2756','416',296236.10,296761.06,524.96,188985.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','256616',4888225,'2757','416',255722.04,256373.17,651.13,234406.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','256616',4888226,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256616',4888227,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256739',4890085,'2744','415',107817.82,109674.76,1856.94,306395.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','256739',4890086,'2745','415',177593.23,179752.06,2158.83,356206.95,0.00,0.00,0.00,0.00,0.00),('1','185','935','256739',4890087,'2746','415',393144.95,394597.94,1452.99,239743.35,0.00,0.00,0.00,0.00,0.00),('1','185','935','256739',4890088,'2747','415',837001.04,839142.11,2141.07,353276.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','256739',4890089,'2748','415',662828.33,664565.49,1737.16,286631.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','256739',4890090,'2749','415',375951.41,376879.85,928.44,153192.60,0.00,0.00,0.00,0.00,0.00),('1','185','936','256739',4890091,'2750','415',719039.90,721470.82,2430.92,401101.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','256739',4890092,'2751','415',145011.36,145265.35,253.99,41908.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','256739',4890093,'2752','415',814440.44,815740.11,1299.67,214445.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','256739',4890094,'2753','415',141759.68,143045.60,1285.92,212176.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','256739',4890095,'2754','415',759290.62,761335.93,2045.31,337476.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','256739',4890096,'2755','415',155321.52,155321.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256739',4890097,'2756','416',296761.06,297459.26,698.20,251352.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256739',4890098,'2757','416',256373.17,256996.23,623.06,224301.60,0.00,0.00,0.00,0.00,0.00),('1','185','938','256739',4890099,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256739',4890100,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256849',4892159,'2744','415',109674.76,111390.96,1716.20,283173.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256849',4892160,'2745','415',179752.06,181537.20,1785.14,294548.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','256849',4892161,'2746','415',394597.94,395266.03,668.09,110234.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','256849',4892162,'2747','415',839142.11,841012.79,1870.68,308662.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','256849',4892163,'2748','415',664565.49,666062.82,1497.33,247059.45,0.00,0.00,0.00,0.00,0.00),('1','185','935','256849',4892164,'2749','415',376879.85,377632.42,752.57,124174.05,0.00,0.00,0.00,0.00,0.00),('1','185','936','256849',4892165,'2750','415',721470.82,722122.67,651.85,107555.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','256849',4892166,'2751','415',145265.35,145602.90,337.55,55695.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','256849',4892167,'2752','415',815740.11,816927.96,1187.85,195995.25,0.00,0.00,0.00,0.00,0.00),('1','185','936','256849',4892168,'2753','415',143045.60,143478.36,432.76,71405.40,0.00,0.00,0.00,0.00,0.00),('1','185','936','256849',4892169,'2754','415',761335.93,762593.59,1257.66,207513.90,0.00,0.00,0.00,0.00,0.00),('1','185','936','256849',4892170,'2755','415',155321.52,155321.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256849',4892171,'2756','416',297459.26,297927.80,468.54,168674.40,0.00,0.00,0.00,0.00,0.00),('1','185','937','256849',4892172,'2757','416',256996.23,257156.23,160.00,57600.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256849',4892173,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256849',4892174,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256956',4894073,'2744','415',111390.96,113107.90,1716.94,283295.10,0.00,0.00,0.00,0.00,0.00),('1','185','935','256956',4894074,'2745','415',181537.20,183288.69,1751.49,288995.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','256956',4894075,'2746','415',395266.03,396649.83,1383.80,228327.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','256956',4894076,'2747','415',841012.79,842927.57,1914.78,315938.70,0.00,0.00,0.00,0.00,0.00),('1','185','935','256956',4894077,'2748','415',666062.82,667766.11,1703.29,281042.85,0.00,0.00,0.00,0.00,0.00),('1','185','935','256956',4894078,'2749','415',377632.42,378618.49,986.07,162701.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','256956',4894079,'2750','415',722122.67,723549.56,1426.89,235436.85,0.00,0.00,0.00,0.00,0.00),('1','185','936','256956',4894080,'2751','415',145602.90,145976.18,373.28,61591.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','256956',4894081,'2752','415',816927.96,818749.77,1821.81,300598.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','256956',4894082,'2753','415',143478.36,144205.91,727.55,120045.75,0.00,0.00,0.00,0.00,0.00),('1','185','936','256956',4894083,'2754','415',762593.59,764083.57,1489.98,245846.70,0.00,0.00,0.00,0.00,0.00),('1','185','936','256956',4894084,'2755','415',155321.52,156142.12,820.60,135399.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','256956',4894085,'2756','416',297927.80,298682.77,754.97,271789.20,0.00,0.00,0.00,0.00,0.00),('1','185','937','256956',4894086,'2757','416',257156.23,257830.00,673.77,242557.20,0.00,0.00,0.00,0.00,0.00),('1','185','938','256956',4894087,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','256956',4894088,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','257100',4896682,'2744','415',113107.90,114818.97,1711.07,282326.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','257100',4896683,'2745','415',183288.69,184807.36,1518.67,250580.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','257100',4896684,'2746','415',396649.83,397080.10,430.27,70994.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','257100',4896685,'2747','415',842927.57,844892.94,1965.37,324286.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','257100',4896686,'2748','415',667766.11,669129.75,1363.64,225000.60,0.00,0.00,0.00,0.00,0.00),('1','185','935','257100',4896687,'2749','415',378618.49,379968.28,1349.79,222715.35,0.00,0.00,0.00,0.00,0.00),('1','185','936','257100',4896688,'2750','415',723549.56,725116.64,1567.08,258568.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','257100',4896689,'2751','415',145976.18,145976.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','257100',4896690,'2752','415',818749.77,818749.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','936','257100',4896691,'2753','415',144205.91,146071.85,1865.94,307880.10,0.00,0.00,0.00,0.00,0.00),('1','185','936','257100',4896692,'2754','415',764083.57,765294.19,1210.62,199752.30,0.00,0.00,0.00,0.00,0.00),('1','185','936','257100',4896693,'2755','415',156142.12,156142.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','257100',4896694,'2756','416',298682.77,299421.58,738.81,265971.60,0.00,0.00,0.00,0.00,0.00),('1','185','937','257100',4896695,'2757','416',257830.00,258286.50,456.50,164340.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','257100',4896696,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','257100',4896697,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','257229',4899017,'2744','415',114818.97,116045.13,1226.16,202316.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','257229',4899018,'2745','415',184807.36,186264.23,1456.87,240383.55,0.00,0.00,0.00,0.00,0.00),('1','185','935','257229',4899019,'2746','415',397080.10,398472.27,1392.17,229708.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','257229',4899020,'2747','415',844892.94,846068.65,1175.71,193992.15,0.00,0.00,0.00,0.00,0.00),('1','185','935','257229',4899021,'2748','415',669129.75,670438.63,1308.88,215965.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','257229',4899022,'2749','415',379968.28,380435.76,467.48,77134.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','257229',4899023,'2750','415',725116.64,726635.97,1519.33,250689.45,0.00,0.00,0.00,0.00,0.00),('1','185','936','257229',4899024,'2751','415',145976.18,146868.89,892.71,147297.15,0.00,0.00,0.00,0.00,0.00),('1','185','936','257229',4899025,'2752','415',818749.77,820991.25,2241.48,369844.20,0.00,0.00,0.00,0.00,0.00),('1','185','936','257229',4899026,'2753','415',146071.85,146982.75,910.90,150298.50,0.00,0.00,0.00,0.00,0.00),('1','185','936','257229',4899027,'2754','415',765294.19,766776.71,1482.52,244615.80,0.00,0.00,0.00,0.00,0.00),('1','185','936','257229',4899028,'2755','415',156142.12,156836.11,693.99,114508.35,0.00,0.00,0.00,0.00,0.00),('1','185','937','257229',4899029,'2756','416',299421.58,300032.53,610.95,219942.00,0.00,0.00,0.00,0.00,0.00),('1','185','937','257229',4899030,'2757','416',258286.50,258647.88,361.38,130096.80,0.00,0.00,0.00,0.00,0.00),('1','185','938','257229',4899031,'2758','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','938','257229',4899032,'2759','417',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','257361',4901302,'2744','415',116045.13,117767.69,1722.56,284222.40,0.00,0.00,0.00,0.00,0.00),('1','185','935','257361',4901303,'2745','415',186264.23,188163.00,1898.77,313297.05,0.00,0.00,0.00,0.00,0.00),('1','185','935','257361',4901304,'2746','415',398472.27,398472.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','185','935','257361',4901305,'2747','415',846068.65,848370.93,2302.28,379876.20,0.00,0.00,0.00,0.00,0.00),('1','185','935','257361',4901306,'2748','415',670438.63,672703.78,2265.15,373749.75,0.00,0.00,0.00,0.00,0.00),('1','185','935','257361',4901307,'2749','415',380435.76,381494.23,1058.47,174647.55,0.00,0.00,0.00,0.00,0.00),('1','185','936','257361',4901308,'2750','415',726635.97,728294.18,1658.21,273604.65,0.00,0.00,0.00,0.00,0.00),('1','185','936','257361',4901309,'2751','415',146868.89,146868.89,0.00,0.00,0.00,0.00,0.0