-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_180
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_180`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_180` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_180`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3355 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3336,400119,'',0,'22','1','180','PURCHASES','','2021-05-08 12:31:08',5,0.00,0.00,'','479','2021-05-08 12:31:08','479',0,1),(3337,20050,'',0,'20','1','180','SALES','','2021-05-08 12:31:24',5,0.00,0.00,'','479','2021-05-08 12:31:24','479',0,1),(3338,40050,'',0,'6.1','1','180','CASH','','2021-05-08 12:31:41',5,0.00,0.00,'','479','2021-05-08 12:31:41','479',0,1),(3339,400312,'',0,'24','1','180','SALARIES & WAGES','','2021-05-08 12:32:15',5,0.00,0.00,'','479','2021-05-08 12:32:15','479',0,1),(3340,400313,'',0,'24','1','180','PURCHASES','','2021-05-08 12:32:35',5,0.00,0.00,'','479','2021-05-08 12:32:35','479',0,1),(3341,400567,'',0,'2','1','180','ZB(LPG)1014471475','','2021-05-08 12:33:28',5,0.00,0.00,'','479','2021-05-08 12:33:28','479',0,1),(3342,400568,'',0,'2','1','180','FB(IBAL)202355223','','2021-05-08 12:34:08',5,0.00,0.00,'','479','2021-05-08 12:34:08','479',0,1),(3343,400569,'',0,'2','1','180','ZB 1015394845','','2021-05-08 12:34:46',5,0.00,0.00,'','479','2021-05-08 12:34:46','479',0,1),(3344,400570,'',0,'2','1','180','ZB 1015965423','','2021-05-08 12:35:23',5,0.00,0.00,'','479','2021-05-08 12:35:23','479',0,1),(3345,400571,'',0,'2','1','180','ZB 1015965375','','2021-05-08 12:36:14',5,0.00,0.00,'','479','2021-05-08 12:36:14','479',0,1),(3346,400572,'',0,'2','1','180','E-BILLS 1015372548','','2021-05-08 12:36:54',5,0.00,0.00,'','479','2021-05-08 12:36:54','479',0,1),(3347,400573,'',0,'2','1','180','E-BILLS IBAL 1015372548','','2021-05-08 12:37:58',5,0.00,0.00,'','479','2021-05-08 12:37:58','479',0,1),(3348,400574,'',0,'2','1','180','ZENITH BANK POS','','2021-05-08 12:38:35',5,0.00,0.00,'','479','2021-05-08 12:38:35','479',0,1),(3349,400575,'',0,'2','1','180','UNITY BANK-0024061656','','2021-05-08 12:39:17',5,0.00,0.00,'','479','2021-05-08 12:39:17','479',0,1),(3350,400576,'',0,'2','1','180','DANKANO-EBILLS(ZNB 1014717618)','','2021-05-08 12:40:23',5,0.00,0.00,'','479','2021-05-08 12:40:23','479',0,1),(3351,400577,'',0,'2','1','180','UBA YOLA-1021398099','','2021-05-08 12:41:06',5,0.00,0.00,'','479','2021-05-08 12:41:06','479',0,1),(3352,400578,'',0,'2','1','180','FID POS COLLECTION-5620141491','','2021-05-08 12:41:45',5,0.00,0.00,'','479','2021-05-08 12:41:45','479',0,1),(3353,400579,'',0,'2','1','180','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:17:24',5,0.00,0.00,'','792','2023-02-20 14:17:24','792',0,0),(3354,400580,'',0,'2','1','180','AA RANO LPG COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:26:52',5,0.00,0.00,'','792','2023-03-15 17:26:52','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
INSERT INTO `attendants` VALUES ('1','180',139,'NAZIRU','ISIHAQA','NIL','07060444290','nazirulpg@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria','ANAS ISIHAQA','07036398871','','',0,5,'0000-00-00 00:00:00','2021-10-07 18:25:20','624','2021-10-07 18:34:13','624');
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4027 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2667,'','1','180','M MUBARAK','MUBARAK','07031021201','naziru@aaranonigeria.com','SOKOTO','SOKOTO','mabera','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-10 17:22:47',5,'624','2021-05-10 17:22:47','624'),(2679,'','1','180','GREGSON','COLLINS','09067670982','aaranolpg@gmail.com','Sokoto','Sokoto','GUSAU','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-16 19:08:01',5,'624','2021-05-16 19:08:01','624'),(2683,'','1','180','GARANYE GAS','GARBA','09078885621','naziru@aaranonigeria.com','SOKOTO','SOKOTO','HAYIN DAJI\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-17 12:17:09',5,'624','2021-05-17 12:17:09','624'),(2684,'','1','180','SURAJO GAS','SURAJO','07032324565','naziruaarano@gmail.com','SOKOTO','SOKOTO','DOGON DAJI\r\n\r\n\r\n','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-17 12:18:45',5,'624','2021-05-17 12:18:45','624'),(2704,'','1','180','NUHU GAS','Alh Nuhu','08030894000','naziru@aaranonigeria.com','SOKOTO','SOKOTO','Runjin sambo','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-24 10:13:41',5,'624','2021-05-24 10:13:41','624'),(2716,'','1','180','AKA GAS','KASIMU','08065289557','naziru@aaranonigeria.com','SOKOTO','SOKOTO','MABERA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-05-31 16:53:27',5,'624','2021-05-31 16:53:27','624'),(2736,'','1','180','BABANGIDA ISAH','ISAH GAS','09030622244','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-06-10 09:54:58',5,'624','2021-06-10 09:54:58','624'),(2831,'','1','180','SABON BIRNI','SABON BIRNI','08166509076','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',200.00,0.00,0.00,'0000-00-00','2021-06-24 12:45:32',5,'624','2021-06-24 12:45:32','624'),(2954,'','1','180','OPERATIONAL LOSS','HAFIZ NURA GAYA','08069129774','hgaya@aaranonigeria.com','KANO','KANO','HOTORO KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-07-18 12:48:10',5,'624','2021-07-18 12:48:10','624'),(3138,'','1','180','COLLINS','GREESON','08034472201','naziruaarano@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-08-21 18:42:39',5,'624','2021-08-21 18:42:39','624'),(3173,'','1','180','OSCAR','OSCAR GAS','08036190758','naziru@aaranonigeria.com','SOKOTO','SOKOTO','TAMAJE','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-08-30 16:26:35',5,'624','2021-08-30 16:26:35','624'),(3209,'','1','180','SAMINU GAS ISAH','SAMINU ','09038135287','naziru@aaranonigeria.com','SOKOTO','SOKOTO','ISAH L.G','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-09-09 13:04:54',5,'624','2021-09-09 13:04:54','624'),(3343,'','1','180','AMANA GAS PLANT','I K','07066727973','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-09-22 17:40:37',5,'624','2021-09-22 17:40:37','624'),(3359,'','1','180','ABU GEMU GAS','ABUBAKAR SULAIMAN','08109239444','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-09-25 11:17:02',5,'624','2021-09-25 11:17:02','624'),(3405,'','1','180','GWADABAWA','MUHAMMAD','07061328543','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-10-05 18:17:49',5,'624','2021-10-05 18:17:49','624'),(3465,'','1','180',' JEGA GSA 2','JEGA GAS 2','08133236406','naziru@aaranonigeria.com','KEBBI','KEBBI STATE','JEGA','Nigeria',1000.00,0.00,0.00,'0000-00-00','2021-10-13 18:02:44',5,'624','2021-10-13 18:02:44','624'),(3474,'','1','180','CHRISTOLIGHT BUSINESS ENTERPRI','CHRISTOPHER','08105768221','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-10-15 15:28:23',5,'624','2021-10-15 15:28:23','624'),(3475,'','1','180','PRESUOCS 7 GAS','UGO','07015738271','naziru@aaranonigeria.com','SOKOTO','SOKOTO','TAMAJE','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-10-15 16:00:11',5,'624','2021-10-15 16:00:11','624'),(3493,'','1','180','JAMILU KAFINTA','JAMILU','08081890626','naziru@aaranonigeria.com','ZAMFARA','MAFARA','ZAMFARA','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-10-19 14:11:22',5,'624','2021-10-19 14:11:22','624'),(3605,'','1','180','DAVIDSON','NWODO','08147663066','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO ','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-10-24 11:53:35',5,'624','2021-10-24 11:53:35','624'),(3654,'','1','180','I K GAS','I K GAS','08034339169','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-11-02 14:33:35',5,'624','2021-11-02 14:33:35','624'),(3662,'','1','180','OKENWA GAS','IBRAHIM','08139585456','naziru@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-11-03 12:18:24',5,'624','2021-11-03 12:18:24','624'),(3819,'','1','180','Nasiru sabon binni','Nasiru ','08029902096','naziruishaqa2018@gmail.com','Sabon birni ','Sokoto ','Sokoto ','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-11-20 13:33:04',5,'624','2021-11-20 13:33:04','624'),(4022,'','1','180','F S C GAS','FCS','0812111373','naziruaarano@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2021-12-13 15:38:41',5,'624','2021-12-13 15:38:41','624'),(4023,'','1','180','JO GAS','DUGON YARO','08130674402','naziru@aaranonigeria.com','KEBBI','KEBBI STATE','ZURU','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-02-02 12:48:53',5,'624','2022-02-02 12:48:53','624'),(4024,'','1','180','Uguwar rogo gas','Abbakar','08138513271','naziruishaqa2018@gmail.com ','Sokoto','Sokoto ','Sokoto','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-04-27 13:38:54',5,'624','2022-04-27 13:38:54','624'),(4025,'','1','180','nura rufai','C G C','08130013511','nazirulpg@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',1000.00,0.00,0.00,'0000-00-00','2022-06-14 16:28:17',5,'624','2022-06-14 16:28:17','624'),(4026,'','1','180','UGO GAS','PAUL','08028680389','nazirulpg@aaranonigeria.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',500.00,0.00,0.00,'0000-00-00','2022-09-26 16:18:22',5,'624','2022-09-26 16:18:22','624');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16365 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','180',16364,'934',2302.09,2000.00,'2021-09-08','new','2021-09-08 18:51:38','483','483',2021,'483','2021-09-08 18:51:38',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2745 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','180','934',2743,'5','LPG NOZZLE 1',12637.90,'LPG DISPENSER','',NULL,NULL,'',5,'2022-02-11 06:57:39','483'),('1','180','934',2744,'5','LPG NOZZLE 2',18593.84,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-11 06:58:14','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=256974 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','180',196061,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-09 17:01:25','624','2021-05-09 17:02:15',10,0),('1','180',196322,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-10 17:26:15','624','2021-05-10 17:26:47',10,0),('1','180',196472,'DAILY SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-11 17:36:07','624','2021-05-11 17:36:35',10,0),('1','180',196699,'Daily shift','2021-05-12','2021-05-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-12 17:13:09','624','2021-05-12 17:13:33',10,0),('1','180',196916,'DAILY SHIFT ','2021-05-13','2021-05-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-13 17:30:52','624','2021-05-13 17:31:17',10,0),('1','180',197083,'DAILY  SHIFT ','2021-05-14','2021-05-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-14 18:37:38','624','2021-05-14 18:38:02',10,0),('1','180',197299,'DAILY SHIFT','2021-05-15','2021-05-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-16 10:46:18','624','2021-05-16 10:47:10',10,0),('1','180',197303,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-16 19:10:25','624','2021-05-16 19:10:49',10,0),('1','180',197535,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-17 18:51:13','624','2021-05-17 18:51:34',10,0),('1','180',197893,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-18 17:41:03','624','2021-05-18 17:41:37',10,0),('1','180',198135,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-19 18:15:29','624','2021-05-19 18:15:56',10,0),('1','180',198354,'DAILY SHIFT ','2021-05-20','2021-05-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-20 17:34:17','624','2021-05-20 17:34:46',10,0),('1','180',198577,'DAILY SHIFT ','2021-05-21','2021-05-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-22 07:07:39','624','2021-05-22 07:08:03',10,0),('1','180',198797,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-22 18:09:54','624','2021-05-22 18:10:32',10,0),('1','180',199005,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-23 17:44:34','624','2021-05-23 17:45:28',10,0),('1','180',199247,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-24 17:35:07','624','2021-05-24 17:35:37',10,0),('1','180',199467,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-25 18:39:55','624','2021-05-25 18:40:15',10,0),('1','180',199727,'DAILY SHIFT ','2021-05-26','2021-05-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-26 19:00:27','624','2021-05-26 19:00:46',10,0),('1','180',199892,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-27 17:36:04','624','2021-05-27 17:36:26',10,0),('1','180',200624,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-30 14:46:34','624','2021-05-30 14:47:07',10,0),('1','180',200789,'DAILY SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'624',0.00,0.00,'624','2021-05-31 20:35:59','624','2021-05-31 20:36:49',10,0),('1','180',200929,'DAILY SHIFT ','2021-06-01','2021-06-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-01 19:53:11','624','2021-06-01 19:53:37',10,0),('1','180',201123,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-02 19:57:16','624','2021-06-02 19:57:39',10,0),('1','180',201330,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-03 19:13:05','624','2021-06-03 19:13:30',10,0),('1','180',201525,'DAILY SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-04 19:54:41','624','2021-06-04 19:55:04',10,0),('1','180',201792,'DAILY SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-05 19:20:43','624','2021-06-05 19:21:06',10,0),('1','180',202043,'DAILY SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-06 19:02:59','624','2021-06-06 19:03:34',10,0),('1','180',202250,'DAILY SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-07 18:01:20','624','2021-06-07 18:02:13',10,0),('1','180',202698,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-09 19:31:41','624','2021-06-09 19:32:05',10,0),('1','180',202871,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-10 20:36:51','624','2021-06-10 20:37:21',10,0),('1','180',203128,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-11 19:19:53','624','2021-06-11 19:20:20',10,0),('1','180',203325,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-12 19:13:54','624','2021-06-12 19:14:14',10,0),('1','180',203545,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-13 14:59:08','624','2021-06-13 14:59:28',10,0),('1','180',203659,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-13 19:10:55','624','2021-06-13 19:11:24',10,0),('1','180',203807,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-14 18:46:44','624','2021-06-14 18:47:08',10,0),('1','180',203985,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-15 21:57:43','624','2021-06-15 21:58:17',10,0),('1','180',204210,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-16 20:14:03','624','2021-06-16 20:14:22',10,0),('1','180',204417,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-17 19:30:07','624','2021-06-17 19:30:29',10,0),('1','180',204675,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-18 20:24:05','624','2021-06-18 20:24:25',10,0),('1','180',204881,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-19 19:47:22','624','2021-06-19 19:47:44',10,0),('1','180',205093,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-20 21:02:28','624','2021-06-20 21:02:48',10,0),('1','180',205329,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-21 20:12:47','624','2021-06-21 20:13:03',10,0),('1','180',205506,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-22 22:29:55','624','2021-06-22 22:30:27',10,0),('1','180',205758,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-23 18:17:10','624','2021-06-23 18:17:42',10,0),('1','180',206043,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-24 19:39:37','624','2021-06-24 19:40:02',10,0),('1','180',206190,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-25 19:22:32','624','2021-06-25 19:22:57',10,0),('1','180',206415,'DAILY SHIFT ','2021-06-26','2021-06-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-26 22:02:46','624','2021-06-26 22:03:14',10,0),('1','180',206615,'DAILY SHIFT ','2021-06-27','2021-06-27 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-27 19:31:02','624','2021-06-27 19:31:24',10,0),('1','180',206927,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-28 19:08:58','624','2021-06-28 19:09:27',10,0),('1','180',207100,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-29 19:39:13','624','2021-06-29 19:41:17',10,0),('1','180',207349,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-06-30 19:04:28','624','2021-06-30 19:05:07',10,0),('1','180',207533,'DAILY SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-01 18:57:10','624','2021-07-01 18:57:36',10,0),('1','180',207772,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-02 19:04:08','624','2021-07-02 19:05:25',10,0),('1','180',207968,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-03 19:07:21','624','2021-07-03 19:08:07',10,0),('1','180',208152,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-04 19:16:50','624','2021-07-04 19:17:24',10,0),('1','180',208369,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-05 19:11:54','624','2021-07-05 19:12:18',10,0),('1','180',208580,'DAILY SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-06 19:40:08','624','2021-07-06 19:41:03',10,0),('1','180',208827,'DAILY SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-07 18:58:32','624','2021-07-07 18:58:59',10,0),('1','180',209106,'DAILY SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-08 20:02:07','624','2021-07-08 20:03:10',10,0),('1','180',209296,'DAILY SHIFT','2021-07-09','2021-07-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-09 19:18:09','624','2021-07-09 19:18:31',10,0),('1','180',209494,'DAILY SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-10 18:55:51','624','2021-07-10 18:56:13',10,0),('1','180',209704,'DAILY SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-11 19:08:16','624','2021-07-11 19:09:07',10,0),('1','180',209974,'DAILY SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-12 19:09:16','624','2021-07-12 19:09:47',10,0),('1','180',210199,'DAILY SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-13 18:52:50','624','2021-07-13 18:53:28',10,0),('1','180',210387,'DAILY SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-14 18:42:46','624','2021-07-14 18:43:08',10,0),('1','180',210634,'DAILY SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-15 18:48:49','624','2021-07-15 18:49:14',10,0),('1','180',210908,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-16 20:02:42','624','2021-07-16 20:03:04',10,0),('1','180',211134,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-17 20:07:19','624','2021-07-17 20:07:43',10,0),('1','180',211269,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-18 12:58:20','624','2021-07-18 12:58:45',10,0),('1','180',211273,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-18 13:04:02','624','2021-07-18 13:04:27',10,0),('1','180',211277,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-18 13:14:19','624','2021-07-18 13:14:48',10,0),('1','180',211279,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-18 19:15:38','624','2021-07-18 19:16:05',10,0),('1','180',211582,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-19 22:03:01','624','2021-07-19 22:03:27',10,0),('1','180',211753,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-20 21:38:06','624','2021-07-20 21:38:27',10,0),('1','180',211953,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-21 19:03:28','624','2021-07-21 19:03:58',10,0),('1','180',212205,'DAILY SHIFT ','2021-07-22','2021-07-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-22 20:21:43','624','2021-07-22 20:22:02',10,0),('1','180',212342,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-23 20:29:37','624','2021-07-23 20:30:03',10,0),('1','180',212642,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-24 21:03:06','624','2021-07-24 21:03:43',10,0),('1','180',212838,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-25 20:16:08','624','2021-07-25 20:16:32',10,0),('1','180',212972,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-26 18:48:07','624','2021-07-26 18:48:27',10,0),('1','180',213274,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-27 18:49:04','624','2021-07-27 18:49:29',10,0),('1','180',213488,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-28 18:54:45','624','2021-07-28 18:55:13',10,0),('1','180',213726,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-29 18:55:55','624','2021-07-29 18:56:30',10,0),('1','180',213965,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-30 18:54:08','624','2021-07-30 18:58:20',10,0),('1','180',214155,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'624',0.00,0.00,'624','2021-07-31 18:57:40','624','2021-07-31 18:58:04',10,0),('1','180',214412,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-01 19:26:08','624','2021-08-01 19:29:03',10,0),('1','180',214658,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-02 18:46:00','624','2021-08-02 18:51:33',10,0),('1','180',214886,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-03 18:49:29','624','2021-08-03 18:52:56',10,0),('1','180',215110,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-04 18:06:34','624','2021-08-04 18:15:11',10,0),('1','180',215337,'DAILY SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-05 19:11:47','624','2021-08-05 19:19:14',10,0),('1','180',215544,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-06 18:48:04','624','2021-08-06 18:51:50',10,0),('1','180',215756,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-07 18:49:14','624','2021-08-07 18:58:12',10,0),('1','180',215989,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-08 18:55:44','624','2021-08-08 18:57:32',10,0),('1','180',216234,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-09 18:54:19','624','2021-08-09 19:01:57',10,0),('1','180',216415,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-10 18:40:29','624','2021-08-10 18:47:47',10,0),('1','180',217450,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-14 16:28:12','624','2021-08-14 16:28:39',10,0),('1','180',217579,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-15 22:28:44','624','2021-08-15 22:30:14',10,0),('1','180',217863,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-16 21:36:41','624','2021-08-16 21:37:05',10,0),('1','180',218153,'DAILY SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-17 18:55:53','624','2021-08-17 18:57:53',10,0),('1','180',218405,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-18 18:58:29','624','2021-08-18 18:58:58',10,0),('1','180',218608,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-19 18:56:33','624','2021-08-19 18:56:52',10,0),('1','180',218777,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-20 19:08:17','624','2021-08-20 19:08:38',10,0),('1','180',219013,'DAILY SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-21 18:49:47','624','2021-08-21 18:51:43',10,0),('1','180',219311,'DAILY SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-22 22:22:12','624','2021-08-22 22:22:30',10,0),('1','180',219563,'DAILY SHIFT ','2021-08-23','2021-08-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-23 20:08:02','624','2021-08-23 20:08:20',10,0),('1','180',220069,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-26 07:44:59','624','2021-08-26 07:45:28',10,0),('1','180',221044,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-30 19:23:07','624','2021-08-30 19:24:32',10,0),('1','180',221332,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'624',0.00,0.00,'624','2021-08-31 18:54:47','624','2021-08-31 18:57:20',10,0),('1','180',221504,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-01 19:09:21','624','2021-09-01 19:12:27',10,0),('1','180',221775,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-02 18:06:38','624','2021-09-02 18:10:10',10,0),('1','180',221919,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-03 19:00:38','624','2021-09-03 19:05:33',10,0),('1','180',222163,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-04 18:20:41','624','2021-09-04 18:25:19',10,0),('1','180',222448,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-05 23:00:45','624','2021-09-05 23:01:30',10,0),('1','180',222602,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-06 18:53:21','624','2021-09-06 18:58:17',10,0),('1','180',222908,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-07 18:46:36','624','2021-09-07 18:50:44',10,0),('1','180',223088,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-08 18:24:28','624','2021-09-08 18:37:36',10,0),('1','180',223147,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-08 19:00:21','624','2021-09-08 19:01:12',10,0),('1','180',223300,'DAILY SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-09 19:00:49','624','2021-09-09 19:06:39',10,0),('1','180',223508,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-10 18:58:22','624','2021-09-10 19:05:50',10,0),('1','180',223751,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-11 22:12:57','624','2021-09-11 22:15:37',10,0),('1','180',224015,'DAILY SHIFT ','2021-09-12','2021-09-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-12 15:14:49','624','2021-09-12 15:15:08',10,0),('1','180',224960,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-16 18:57:01','624','2021-09-16 19:06:08',10,0),('1','180',225139,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-17 19:00:39','624','2021-09-17 19:05:03',10,0),('1','180',225426,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-18 18:37:16','624','2021-09-18 18:39:49',10,0),('1','180',225652,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-19 18:43:22','624','2021-09-19 18:44:32',10,0),('1','180',225938,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-20 19:00:56','624','2021-09-20 19:01:24',10,0),('1','180',226205,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-21 19:07:37','624','2021-09-21 19:08:59',10,0),('1','180',226413,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-22 18:46:58','624','2021-09-22 18:50:36',10,0),('1','180',226674,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-23 19:48:37','624','2021-09-23 19:51:08',10,0),('1','180',226746,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-24 18:50:29','624','2021-09-24 22:18:12',10,0),('1','180',227048,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-25 22:53:07','624','2021-09-25 22:53:31',10,0),('1','180',227335,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-26 18:51:00','624','2021-09-26 18:53:19',10,0),('1','180',227452,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-27 19:26:07','624','2021-09-27 19:28:55',10,0),('1','180',227810,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-28 18:41:18','624','2021-09-28 18:44:03',10,0),('1','180',228087,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-29 18:56:47','624','2021-09-29 19:00:24',10,0),('1','180',228334,'DAILY SHIFT ','2021-09-30','2021-09-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-09-30 21:00:45','624','2021-09-30 21:01:07',10,0),('1','180',228513,'DAILY SHIFT ','2021-10-01','2021-10-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-01 21:13:52','624','2021-10-01 21:14:08',10,0),('1','180',228665,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-02 22:10:19','624','2021-10-02 22:10:54',10,0),('1','180',228918,'DAILY SHIFT ','2021-10-03','2021-10-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-03 20:38:57','624','2021-10-03 20:39:16',10,0),('1','180',229040,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-04 18:10:01','624','2021-10-04 18:17:43',10,0),('1','180',229373,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-05 18:49:50','624','2021-10-05 18:50:46',10,0),('1','180',229587,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-06 22:43:15','624','2021-10-06 22:43:47',10,0),('1','180',229841,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-07 18:47:48','624','2021-10-07 18:49:41',10,0),('1','180',229905,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-08 18:44:02','624','2021-10-08 18:46:28',10,0),('1','180',230175,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-09 19:13:12','624','2021-10-09 19:13:42',10,0),('1','180',230351,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-10 15:37:35','624','2021-10-10 19:24:35',10,0),('1','180',230643,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-11 13:03:26','624','2021-10-11 13:03:52',10,0),('1','180',230665,'DAILY SHIFT ','2021-08-24','2021-08-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-11 16:47:54','624','2021-10-11 16:48:13',10,0),('1','180',230747,'DAILY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-11 18:46:08','624','2021-10-11 18:50:13',10,0),('1','180',230839,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-12 18:46:37','624','2021-10-12 18:50:53',10,0),('1','180',231180,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-13 18:10:42','624','2021-10-13 18:14:58',10,0),('1','180',231569,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-14 18:35:56','624','2021-10-14 18:42:01',10,0),('1','180',231678,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-15 18:32:08','624','2021-10-15 22:21:06',10,0),('1','180',231941,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-16 18:27:15','624','2021-10-16 18:30:06',10,0),('1','180',232228,'DAILY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-17 18:54:56','624','2021-10-17 18:57:39',10,0),('1','180',232436,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-18 18:04:05','624','2021-10-18 18:08:44',10,0),('1','180',232686,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-19 17:50:32','624','2021-10-19 18:03:48',10,0),('1','180',232993,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-20 18:28:42','624','2021-10-20 18:29:28',10,0),('1','180',233302,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-21 18:46:43','624','2021-10-21 18:50:02',10,0),('1','180',233328,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-21 19:04:07','624','2021-10-21 19:04:26',10,0),('1','180',233460,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-22 18:05:21','624','2021-10-22 18:06:51',10,0),('1','180',233721,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-23 19:35:21','624','2021-10-23 19:37:49',10,0),('1','180',233912,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-24 20:05:32','624','2021-10-24 20:09:43',10,0),('1','180',234135,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-25 17:59:08','624','2021-10-25 18:01:13',10,0),('1','180',234383,'DAILY SHIFT ','2021-10-26','2021-10-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-26 12:30:38','624','2021-10-26 12:31:05',10,0),('1','180',235189,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-29 12:18:53','624','2021-10-29 12:19:14',10,0),('1','180',235451,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-30 18:14:27','624','2021-10-30 18:20:08',10,0),('1','180',235603,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'624',0.00,0.00,'624','2021-10-31 17:59:14','624','2021-10-31 18:02:45',10,0),('1','180',235891,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-01 17:32:33','624','2021-11-01 17:37:06',10,0),('1','180',236152,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-02 19:09:18','624','2021-11-02 19:09:39',10,0),('1','180',236303,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-03 18:35:04','624','2021-11-03 18:39:51',10,0),('1','180',236586,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-04 17:47:30','624','2021-11-04 17:52:53',10,0),('1','180',236762,'DAILY SHIFT ','2021-11-05','2021-11-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-05 20:32:34','624','2021-11-05 20:32:57',10,0),('1','180',236986,'DAILY SHIFT ','2021-11-06','2021-11-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-06 20:14:27','624','2021-11-06 20:14:49',10,0),('1','180',237191,'DAILY SHIFT ','2021-11-07','2021-11-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-07 20:13:34','624','2021-11-07 20:13:54',10,0),('1','180',237412,'DAILY SHIFT ','2021-11-08','2021-11-08 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-08 21:25:58','624','2021-11-08 21:26:15',10,0),('1','180',237650,'DAILY SHIFT ','2021-11-09','2021-11-09 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-09 20:29:21','624','2021-11-09 20:29:56',10,0),('1','180',237907,'DAILY SHIFT ','2021-11-10','2021-11-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-10 22:24:46','624','2021-11-10 22:25:07',10,0),('1','180',238156,'DAILY SHIFT ','2021-11-11','2021-11-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-11 22:06:00','624','2021-11-11 22:06:21',10,0),('1','180',238376,'DAILY SHIFT ','2021-11-12','2021-11-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-12 19:50:13','624','2021-11-12 19:50:36',10,0),('1','180',238650,'DAILY SHIFT ','2021-11-13','2021-11-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-13 20:09:50','624','2021-11-13 20:10:22',10,0),('1','180',238858,'DAILY SHIFT ','2021-11-14','2021-11-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-14 20:08:29','624','2021-11-14 20:08:54',10,0),('1','180',239093,'DAILY SHIFT ','2021-11-15','2021-11-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-15 16:13:20','624','2021-11-15 16:13:43',10,0),('1','180',240286,'DAILY SHIFT ','2021-11-20','2021-11-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-20 12:20:11','624','2021-11-20 12:20:29',10,0),('1','180',240296,'DAILY SHIFT ','2021-11-20','2021-11-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-20 20:45:53','624','2021-11-20 20:46:15',10,0),('1','180',240488,'DAILY SHIFT ','2021-11-21','2021-11-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-21 20:14:03','624','2021-11-21 20:14:24',10,0),('1','180',240724,'DAILY SHIFT ','2021-11-22','2021-11-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-22 20:27:06','624','2021-11-22 20:27:39',10,0),('1','180',240996,'DAILY SHIFT ','2021-11-23','2021-11-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-23 19:57:20','624','2021-11-23 19:57:44',10,0),('1','180',241258,'DAILY SHIFT ','2021-11-24','2021-11-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-24 22:09:44','624','2021-11-24 22:10:09',10,0),('1','180',241566,'DAILY SHIFT ','2021-11-25','2021-11-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-25 21:07:36','624','2021-11-25 21:07:57',10,0),('1','180',241789,'DAILY SHIFT ','2021-11-26','2021-11-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-26 22:06:37','624','2021-11-26 22:07:05',10,0),('1','180',242000,'DAILY SHIFT ','2021-11-27','2021-11-27 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-27 20:08:32','624','2021-11-27 20:08:50',10,0),('1','180',242253,'DAILY SHIFT ','2021-11-28','2021-11-28 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-28 22:06:57','624','2021-11-28 22:07:19',10,0),('1','180',242509,'DAILY SHIFT ','2021-11-29','2021-11-29 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-29 22:04:45','624','2021-11-29 22:05:08',10,0),('1','180',242649,'DAILY SHIFT ','2021-11-30','2021-11-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-11-30 20:10:43','624','2021-11-30 20:11:02',10,0),('1','180',242946,'DAILY SHIFT ','2021-12-01','2021-12-01 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-01 20:27:24','624','2021-12-01 20:27:45',10,0),('1','180',243160,'DAILY SHIFT ','2021-12-02','2021-12-02 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-02 22:26:29','624','2021-12-02 22:26:49',10,0),('1','180',243387,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-03 22:17:28','624','2021-12-03 22:17:56',10,0),('1','180',243668,'DAILY SHIFT ','2021-12-04','2021-12-04 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-04 20:14:49','624','2021-12-04 20:15:25',10,0),('1','180',243894,'DAILY SHIFT ','2021-12-05','2021-12-05 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-05 20:35:54','624','2021-12-05 20:36:15',10,0),('1','180',244126,'DAILY SHIFT ','2021-12-06','2021-12-06 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-06 22:02:12','624','2021-12-06 22:02:38',10,0),('1','180',244375,'DAILY SHIFT ','2021-12-07','2021-12-07 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-07 17:53:40','624','2021-12-07 17:54:00',10,0),('1','180',245005,'DAILY SHIFT ','2021-12-10','2021-12-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-10 06:57:37','624','2021-12-10 06:57:56',10,0),('1','180',245008,'DAILY SHIFT ','2021-12-10','2021-12-10 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-10 20:19:19','624','2021-12-10 20:19:40',10,0),('1','180',245247,'DAILY SHIFT ','2021-12-11','2021-12-11 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-11 20:12:44','624','2021-12-11 20:13:07',10,0),('1','180',245465,'DAILY SHIFT ','2021-12-12','2021-12-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-12 07:25:20','624','2021-12-12 07:26:01',10,0),('1','180',245467,'DAILY SHIFT ','2021-12-12','2021-12-12 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-12 21:06:18','624','2021-12-12 21:06:41',10,0),('1','180',245708,'DAILY SHIFT ','2021-12-13','2021-12-13 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-13 22:04:06','624','2021-12-13 22:04:25',10,0),('1','180',245966,'DAILY SHIFT ','2021-12-14','2021-12-14 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-15 02:51:36','624','2021-12-15 02:51:53',10,0),('1','180',246207,'DAILY SHIFT ','2021-12-15','2021-12-15 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-15 23:10:00','624','2021-12-15 23:10:57',10,0),('1','180',246468,'DAILY SHIFT ','2021-12-16','2021-12-16 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-16 20:28:39','624','2021-12-16 20:29:13',10,0),('1','180',246707,'DAILY SHIFT ','2021-12-17','2021-12-17 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-17 19:45:27','624','2021-12-17 19:45:59',10,0),('1','180',246959,'DAILY SHIFT ','2021-12-18','2021-12-18 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-18 18:36:07','624','2021-12-18 18:36:35',10,0),('1','180',247193,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-19 19:00:23','624','2021-12-19 19:00:53',10,0),('1','180',247445,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-20 17:37:59','624','2021-12-20 17:38:37',10,0),('1','180',247749,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-21 18:02:35','624','2021-12-21 18:03:04',10,0),('1','180',247985,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-22 17:44:09','624','2021-12-22 17:48:36',10,0),('1','180',248232,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-23 18:27:51','624','2021-12-23 18:28:20',10,0),('1','180',248501,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-24 17:41:47','624','2021-12-24 17:42:10',10,0),('1','180',248728,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-25 17:11:45','624','2021-12-25 17:12:16',10,0),('1','180',248903,'DAILY SHIFT ','2021-12-26','2021-12-26 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-26 21:05:36','624','2021-12-26 21:10:26',10,0),('1','180',249125,'Daily shift','2021-12-27','2021-12-27 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-27 19:01:44','624','2021-12-27 19:02:37',10,0),('1','180',249370,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-28 18:30:37','624','2021-12-28 18:31:08',10,0),('1','180',249623,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-29 18:38:17','624','2021-12-29 18:38:41',10,0),('1','180',249889,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-30 18:55:33','624','2021-12-30 18:55:57',10,0),('1','180',250161,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'624',0.00,0.00,'624','2021-12-31 17:13:23','624','2021-12-31 17:13:53',10,0),('1','180',250371,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-01 18:01:14','624','2022-01-01 18:01:51',10,0),('1','180',250610,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-02 18:45:07','624','2022-01-02 18:45:47',10,0),('1','180',250865,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-03 18:18:04','624','2022-01-03 18:18:26',10,0),('1','180',251071,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-04 18:58:25','624','2022-01-04 18:58:53',10,0),('1','180',251337,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-05 14:57:28','624','2022-01-05 14:57:50',10,0),('1','180',252183,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-08 19:32:27','624','2022-01-08 19:33:09',10,0),('1','180',252326,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-09 19:47:15','624','2022-01-09 19:47:49',10,0),('1','180',252531,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-10 19:51:07','624','2022-01-10 19:51:37',10,0),('1','180',252742,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-11 19:15:28','624','2022-01-11 19:16:37',10,0),('1','180',253004,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-12 21:14:01','624','2022-01-12 21:14:40',10,0),('1','180',253314,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-13 19:25:03','624','2022-01-13 19:25:41',10,0),('1','180',253496,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-14 20:08:23','624','2022-01-14 20:08:43',10,0),('1','180',253698,'DAILY SHIFT ','2022-01-15','2022-01-15 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-15 21:05:53','624','2022-01-15 21:06:42',10,0),('1','180',253978,'DAILY SHIFT ','2022-01-16','2022-01-16 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-16 18:59:43','624','2022-01-16 19:04:31',10,0),('1','180',254183,'DAILY SHIFT ','2022-01-17','2022-01-17 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-17 20:44:13','624','2022-01-17 20:45:00',10,0),('1','180',254437,'DAILY SHIFT ','2022-01-18','2022-01-18 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-18 20:35:18','624','2022-01-18 20:35:38',10,0),('1','180',254690,'DAILY SHIFT ','2022-01-19','2022-01-19 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-19 21:19:06','624','2022-01-19 21:21:31',10,0),('1','180',254936,'DAILY SHIFT ','2022-01-20','2022-01-20 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-20 20:39:15','624','2022-01-20 20:39:43',10,0),('1','180',255201,'DAILY SHIFT ','2022-01-21','2022-01-21 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-21 20:17:08','624','2022-01-21 20:17:57',10,0),('1','180',255458,'DAILY SHIFT ','2022-01-22','2022-01-22 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-22 20:03:48','624','2022-01-22 20:04:11',10,0),('1','180',255709,'DAILY SHIFT ','2022-01-23','2022-01-23 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-23 20:24:43','624','2022-01-23 20:25:06',10,0),('1','180',255934,'DAILY SHIFT ','2022-01-24','2022-01-24 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-24 20:10:08','624','2022-01-24 20:10:31',10,0),('1','180',256220,'DAILY SHIFT ','2022-01-25','2022-01-25 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-25 20:31:43','624','2022-01-25 20:32:07',10,0),('1','180',256502,'DAILY SHIFT ','2022-01-26','2022-01-26 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-26 20:45:40','624','2022-01-26 20:46:57',10,0),('1','180',256746,'DAILY SHIFT ','2022-01-27','2022-01-27 00:00:00',NULL,'624',0.00,0.00,'624','2022-01-27 20:43:09','624','2022-01-27 20:43:41',10,0),('1','180',256747,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-02 08:57:12','624','2022-02-02 08:57:34',10,0),('1','180',256748,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-02 19:16:36','624','2022-02-02 19:16:59',10,0),('1','180',256749,'DAILY SHIFT ','2022-02-03','2022-02-03 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-03 19:00:12','624','2022-02-03 19:00:41',10,0),('1','180',256750,'DAILY SHIFT ','2022-02-04','2022-02-04 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-04 21:19:18','624','2022-02-04 21:19:33',10,0),('1','180',256751,'DAILY SHIFT ','2022-02-05','2022-02-05 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-05 19:03:33','624','2022-02-06 07:26:19',10,0),('1','180',256752,'DAILY SHIFT ','2022-02-06','2022-02-06 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-06 19:03:18','624','2022-02-06 19:04:04',10,0),('1','180',256753,'DAILY SHIFT ','2022-02-07','2022-02-07 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-07 20:35:22','624','2022-02-07 20:35:47',10,0),('1','180',256754,'DAILY SHIFT ','2022-02-08','2022-02-08 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-08 20:22:04','624','2022-02-08 20:24:02',10,0),('1','180',256755,'DAILY SHIFT ','2022-02-09','2022-02-09 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-09 19:19:51','624','2022-02-09 19:25:39',10,0),('1','180',256756,'DAILY SHIFT ','2022-02-10','2022-02-10 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-10 19:12:15','624','2022-02-10 19:12:33',10,0),('1','180',256757,'DAILY SHIFT ','2022-02-11','2022-02-11 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-11 19:18:03','624','2022-02-11 19:25:31',10,0),('1','180',256759,'DAILY SHIFT ','2022-02-12','2022-02-12 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-12 19:16:30','624','2022-02-12 19:16:59',10,0),('1','180',256760,'DAILY SHIFT ','2022-02-13','2022-02-13 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-13 19:18:21','624','2022-02-13 19:20:47',10,0),('1','180',256761,'DAILY SHIFT ','2022-02-14','2022-02-14 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-14 19:03:59','624','2022-02-14 19:04:19',10,0),('1','180',256762,'DAILY SHIFT ','2022-02-15','2022-02-15 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-15 18:54:30','624','2022-02-15 18:54:53',10,0),('1','180',256763,'DAILY SHIFT ','2022-02-16','2022-02-16 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-16 19:06:46','624','2022-02-16 19:10:22',10,0),('1','180',256764,'DAILY SHIFT ','2022-02-17','2022-02-17 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-17 19:04:59','624','2022-02-17 19:05:20',10,0),('1','180',256765,'DAILY SHIFT ','2022-02-18','2022-02-18 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-18 19:08:42','624','2022-02-18 19:09:37',10,0),('1','180',256766,'DAILY SHIFT ','2022-02-19','2022-02-19 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-19 19:14:43','624','2022-02-19 19:15:18',10,0),('1','180',256767,'DAILY SHIFT ','2022-02-20','2022-02-20 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-20 20:12:12','624','2022-02-20 20:12:40',10,0),('1','180',256768,'DAILY SHIFT ','2022-02-21','2022-02-21 00:00:00',NULL,'624',0.00,0.00,'624','2022-02-21 19:01:00','624','2022-02-21 19:01:30',10,0),('1','180',256769,'DAILY SHIFT ','2022-02-22','2022-02-22 08:22:38','2022-02-23 08:22:38','624',0.00,0.00,'624','2022-02-22 20:33:42','624','2022-02-22 20:34:11',10,0),('1','180',256770,'DAILY SHIFT ','2022-02-23','2022-02-23 07:52:01','2022-02-24 07:52:01','624',0.00,0.00,'624','2022-02-23 19:24:25','624','2022-02-23 19:27:26',10,0),('1','180',256771,'DAILY SHIFT ','2022-02-24','2022-02-24 07:50:28','2022-02-25 07:50:28','624',0.00,0.00,'624','2022-02-24 19:18:39','624','2022-02-24 19:18:57',10,0),('1','180',256772,'DAILY SHIFT ','2022-02-25','2022-02-25 08:12:38','2022-02-26 08:12:38','624',0.00,0.00,'624','2022-02-25 19:11:26','624','2022-02-25 19:12:15',10,0),('1','180',256773,'DAILY SHIFT ','2022-02-26','2022-02-26 07:41:46','2022-02-27 07:41:46','624',0.00,0.00,'624','2022-02-26 19:00:24','624','2022-02-26 19:00:47',10,0),('1','180',256774,'DAILY SHIFT','2022-02-27','2022-02-27 08:13:05','2022-02-28 08:13:05','624',0.00,0.00,'624','2022-02-27 19:58:53','624','2022-02-27 19:59:10',10,0),('1','180',256775,'DAILY SHIFT ','2022-02-28','2022-02-28 07:41:39','2022-03-01 07:41:39','624',0.00,0.00,'624','2022-02-28 19:03:04','624','2022-02-28 19:03:47',10,0),('1','180',256776,'DAILY SHIFT ','2022-03-01','2022-03-01 07:45:52','2022-03-02 07:45:52','624',0.00,0.00,'624','2022-03-01 19:23:26','624','2022-03-01 19:23:49',10,0),('1','180',256777,'DAILY SHIFT ','2022-03-02','2022-03-02 07:58:58','2022-03-03 07:58:58','624',0.00,0.00,'624','2022-03-02 18:58:58','624','2022-03-02 19:00:41',10,0),('1','180',256778,'DAILY SHIFT ','2022-03-03','2022-03-03 08:05:05','2022-03-04 08:05:05','624',0.00,0.00,'624','2022-03-03 19:18:47','624','2022-03-03 19:19:12',10,0),('1','180',256779,'DAILY SHIFT ','2022-03-04','2022-03-04 07:32:08','2022-03-05 07:32:08','624',0.00,0.00,'624','2022-03-04 19:14:31','624','2022-03-04 19:17:16',10,0),('1','180',256780,'DAILY SHIFT ','2022-03-05','2022-03-05 07:31:27','2022-03-06 07:31:27','624',0.00,0.00,'624','2022-03-05 19:16:03','624','2022-03-05 19:16:30',10,0),('1','180',256781,'Daily shift','2022-03-06','2022-03-06 08:43:12','2022-03-07 08:43:12','624',0.00,0.00,'624','2022-03-06 18:57:34','624','2022-03-06 18:58:02',10,0),('1','180',256782,'Daily shift','2022-03-07','2022-03-07 07:34:08','2022-03-08 07:34:08','624',0.00,0.00,'624','2022-03-07 19:11:53','624','2022-03-07 19:20:53',10,0),('1','180',256783,'DAILY SHIFT ','2022-03-08','2022-03-08 07:20:13','2022-03-09 07:20:13','624',0.00,0.00,'624','2022-03-08 16:31:40','624','2022-03-08 16:32:00',10,0),('1','180',256784,'DAILY SHIFT','2022-03-17','2022-03-17 15:22:06','2022-03-18 15:22:06','624',0.00,0.00,'624','2022-03-17 19:22:38','624','2022-03-17 19:23:01',10,0),('1','180',256785,'Daily shift','2022-03-18','2022-03-18 07:12:06','2022-03-19 07:12:06','624',0.00,0.00,'624','2022-03-18 21:45:53','624','2022-03-18 21:46:54',10,0),('1','180',256786,'Daily shift','2022-03-19','2022-03-19 07:15:28','2022-03-20 07:15:28','624',0.00,0.00,'624','2022-03-19 20:19:32','624','2022-03-19 20:19:50',10,0),('1','180',256787,'Daily shift','2022-03-20','2022-03-20 07:51:58','2022-03-21 07:51:58','624',0.00,0.00,'624','2022-03-20 20:45:21','624','2022-03-20 20:45:41',10,0),('1','180',256788,'Daily shift','2022-03-21','2022-03-21 07:07:22','2022-03-22 07:07:22','624',0.00,0.00,'624','2022-03-21 19:08:07','624','2022-03-21 19:08:28',10,0),('1','180',256789,'DAILY SHIFT','2022-03-22','2022-03-22 12:01:45','2022-03-23 12:01:45','624',0.00,0.00,'624','2022-03-22 19:19:10','624','2022-03-22 19:19:28',10,0),('1','180',256790,'Daily shift','2022-03-23','2022-03-23 07:02:08','2022-03-24 07:02:08','624',0.00,0.00,'624','2022-03-23 19:03:09','624','2022-03-23 19:03:26',10,0),('1','180',256791,'Daily shift','2022-03-24','2022-03-24 00:55:38','2022-03-25 00:55:38','624',0.00,0.00,'624','2022-03-24 19:04:40','624','2022-03-24 19:05:02',10,0),('1','180',256792,'Daily shift','2022-03-25','2022-03-25 01:14:35','2022-03-26 01:14:35','624',0.00,0.00,'624','2022-03-25 19:03:55','624','2022-03-25 19:04:14',10,0),('1','180',256793,'Daily shift','2022-03-26','2022-03-26 01:10:08','2022-03-27 01:10:08','624',0.00,0.00,'624','2022-03-26 19:19:07','624','2022-03-26 19:19:25',10,0),('1','180',256794,'Daily shift','2022-03-27','2022-03-27 07:13:13','2022-03-28 07:13:13','624',0.00,0.00,'624','2022-03-27 21:57:48','624','2022-03-27 21:58:06',10,0),('1','180',256795,'Daily shift','2022-03-28','2022-03-28 01:17:34','2022-03-29 01:17:34','624',0.00,0.00,'624','2022-03-28 19:09:32','624','2022-03-28 19:10:00',10,0),('1','180',256796,'Daily shift','2022-03-29','2022-03-29 00:37:49','2022-03-30 00:37:49','624',0.00,0.00,'624','2022-03-29 19:02:40','624','2022-03-29 19:03:06',10,0),('1','180',256797,'Daily shift','2022-03-30','2022-03-30 00:20:28','2022-03-31 00:20:28','624',0.00,0.00,'624','2022-03-30 19:55:28','624','2022-03-30 19:55:48',10,0),('1','180',256798,'Daily shift','2022-03-31','2022-03-31 09:36:40','2022-04-01 09:36:40','624',0.00,0.00,'624','2022-03-31 20:33:24','624','2022-03-31 20:33:49',10,0),('1','180',256799,'Daily shift','2022-04-01','2022-04-01 00:30:30','2022-04-02 00:30:30','624',0.00,0.00,'624','2022-04-01 21:06:12','624','2022-04-01 21:06:28',10,0),('1','180',256800,'Daily shift','2022-04-02','2022-04-02 04:44:55','2022-04-03 04:44:55','624',0.00,0.00,'624','2022-04-02 20:50:03','624','2022-04-02 20:50:22',10,0),('1','180',256801,'Daily shift','2022-04-03','2022-04-03 08:41:19','2022-04-04 08:41:19','624',0.00,0.00,'624','2022-04-03 20:00:55','624','2022-04-03 20:01:14',10,0),('1','180',256802,'Daily shift','2022-04-04','2022-04-04 09:21:27','2022-04-05 09:21:27','624',0.00,0.00,'624','2022-04-04 21:19:47','624','2022-04-04 21:20:08',10,0),('1','180',256803,'Daily shift','2022-04-05','2022-04-05 08:56:22','2022-04-06 08:56:22','624',0.00,0.00,'624','2022-04-05 21:50:37','624','2022-04-05 21:51:00',10,0),('1','180',256804,'Daily shift','2022-04-06','2022-04-06 09:03:50','2022-04-07 09:03:50','624',0.00,0.00,'624','2022-04-06 21:02:58','624','2022-04-06 21:03:12',10,0),('1','180',256805,'Daily shift','2022-04-07','2022-04-07 08:47:48','2022-04-08 08:47:48','624',0.00,0.00,'624','2022-04-07 19:36:57','624','2022-04-07 19:37:21',10,0),('1','180',256806,'Daily shift','2022-04-08','2022-04-08 09:07:26','2022-04-09 09:07:26','624',0.00,0.00,'624','2022-04-08 19:26:38','624','2022-04-08 19:26:59',10,0),('1','180',256807,'Daily shift','2022-04-09','2022-04-09 08:50:06','2022-04-10 08:50:06','624',0.00,0.00,'624','2022-04-09 22:30:41','624','2022-04-09 22:30:59',10,0),('1','180',256808,'Daily shift','2022-04-10','2022-04-10 11:24:33','2022-04-11 11:24:33','624',0.00,0.00,'624','2022-04-10 19:45:12','624','2022-04-10 19:45:46',10,0),('1','180',256809,'Daily shift','2022-04-10','2022-04-17 05:50:56','2022-04-18 05:50:56','624',0.00,0.00,'624','2022-04-17 05:56:51','624','2022-04-17 05:57:21',10,0),('1','180',256810,'Daily shift','2022-04-17','2022-04-17 11:21:06','2022-04-18 11:21:06','624',0.00,0.00,'624','2022-04-17 19:32:34','624','2022-04-17 19:32:54',10,0),('1','180',256811,'Daily shift','2022-04-18','2022-04-18 10:22:38','2022-04-19 10:22:38','624',0.00,0.00,'624','2022-04-18 19:35:24','624','2022-04-18 19:35:58',10,0),('1','180',256812,'Daily shift','2022-04-19','2022-04-19 08:31:11','2022-04-20 08:31:11','624',0.00,0.00,'624','2022-04-19 22:01:48','624','2022-04-19 22:10:04',10,0),('1','180',256813,'Daily shift','2022-04-20','2022-04-20 08:53:54','2022-04-21 08:53:54','624',0.00,0.00,'624','2022-04-20 21:55:39','624','2022-04-20 21:55:53',10,0),('1','180',256814,'Daily shift','2022-04-21','2022-04-21 09:15:40','2022-04-22 09:15:40','624',0.00,0.00,'624','2022-04-21 21:44:26','624','2022-04-21 21:44:48',10,0),('1','180',256815,'Daily shift','2022-04-22','2022-04-22 09:59:19','2022-04-23 09:59:19','624',0.00,0.00,'624','2022-04-22 20:51:36','624','2022-04-22 20:52:05',10,0),('1','180',256816,'Daily shift','2022-04-23','2022-04-23 08:40:26','2022-04-24 08:40:26','624',0.00,0.00,'624','2022-04-23 19:51:52','624','2022-04-23 19:52:14',10,0),('1','180',256817,'Daily shift','2022-04-24','2022-04-24 08:53:04','2022-04-25 08:53:04','624',0.00,0.00,'624','2022-04-24 19:26:53','624','2022-04-24 19:27:12',10,0),('1','180',256818,'Daily shift','2022-04-25','2022-04-25 09:25:26','2022-04-26 09:25:26','624',0.00,0.00,'624','2022-04-25 20:36:53','624','2022-04-25 20:37:13',10,0),('1','180',256819,'Daily shift','2022-04-26','2022-04-26 09:28:02','2022-04-27 09:28:02','624',0.00,0.00,'624','2022-04-26 20:53:43','624','2022-04-26 20:54:09',10,0),('1','180',256820,'Daily shift','2022-04-27','2022-04-27 08:00:19','2022-04-28 08:00:19','624',0.00,0.00,'624','2022-04-27 19:28:31','624','2022-04-27 19:29:48',10,0),('1','180',256821,'Daily shift','2022-04-28','2022-04-28 09:48:07','2022-04-29 09:48:07','624',0.00,0.00,'624','2022-04-28 20:33:23','624','2022-04-28 20:33:49',10,0),('1','180',256822,'Daily shift','2022-04-29','2022-04-29 08:50:22','2022-04-30 08:50:22','624',0.00,0.00,'624','2022-04-29 20:49:48','624','2022-04-29 20:50:20',10,0),('1','180',256823,'Daily shift','2022-04-30','2022-04-30 08:17:29','2022-05-01 08:17:29','624',0.00,0.00,'624','2022-04-30 20:48:41','624','2022-04-30 20:49:04',10,0),('1','180',256824,'Daily shift','2022-05-01','2022-05-01 09:23:02','2022-05-02 09:23:02','624',0.00,0.00,'624','2022-05-01 20:43:45','624','2022-05-01 20:44:15',10,0),('1','180',256825,'Daily shift','2022-05-02','2022-05-02 09:36:30','2022-05-03 09:36:30','624',0.00,0.00,'624','2022-05-02 21:09:04','624','2022-05-02 21:09:20',10,0),('1','180',256826,'Daily shift','2022-05-03','2022-05-03 08:52:24','2022-05-04 08:52:24','624',0.00,0.00,'624','2022-05-03 20:14:32','624','2022-05-03 20:15:08',10,0),('1','180',256827,'Daily shift','2022-05-04','2022-05-04 09:31:07','2022-05-05 09:31:07','624',0.00,0.00,'624','2022-05-04 19:34:25','624','2022-05-04 19:36:04',10,0),('1','180',256828,'Daily shift','2022-05-05','2022-05-05 10:07:32','2022-05-06 10:07:32','624',0.00,0.00,'624','2022-05-05 22:02:05','624','2022-05-05 22:02:28',10,0),('1','180',256829,'Daily shift','2022-05-06','2022-05-06 08:39:40','2022-05-07 08:39:40','624',0.00,0.00,'624','2022-05-06 21:27:16','624','2022-05-06 21:27:31',10,0),('1','180',256830,'Daily shift','2022-05-07','2022-05-07 09:02:50','2022-05-08 09:02:50','624',0.00,0.00,'624','2022-05-07 21:35:07','624','2022-05-07 21:35:35',10,0),('1','180',256831,'Daily shift','2022-05-08','2022-05-08 07:57:16','2022-05-09 07:57:16','624',0.00,0.00,'624','2022-05-08 21:52:59','624','2022-05-08 21:53:17',10,0),('1','180',256832,'Daily shift','2022-05-09','2022-05-09 07:49:22','2022-05-10 07:49:22','624',0.00,0.00,'624','2022-05-09 20:09:15','624','2022-05-09 20:09:32',10,0),('1','180',256833,'Daily shift','2022-05-10','2022-05-10 08:28:41','2022-05-11 08:28:41','624',0.00,0.00,'624','2022-05-10 20:58:42','624','2022-05-10 20:58:59',10,0),('1','180',256834,'Daily shift','2022-05-11','2022-05-11 06:36:14','2022-05-12 06:36:14','624',0.00,0.00,'624','2022-05-11 20:41:52','624','2022-05-11 20:42:24',10,0),('1','180',256835,'Daily shift','2022-05-12','2022-05-12 01:05:38','2022-05-13 01:05:38','624',0.00,0.00,'624','2022-05-12 21:07:56','624','2022-05-12 21:08:20',10,0),('1','180',256836,'Daily shift','2022-05-13','2022-05-13 05:34:00','2022-05-14 05:34:00','624',0.00,0.00,'624','2022-05-13 21:14:54','624','2022-05-13 21:15:11',10,0),('1','180',256837,'Daily shift','2022-05-14','2022-05-14 05:38:37','2022-05-15 05:38:37','624',0.00,0.00,'624','2022-05-14 21:13:36','624','2022-05-14 21:13:51',10,0),('1','180',256838,'Daily shift','2022-05-15','2022-05-15 05:56:42','2022-05-16 05:56:42','624',0.00,0.00,'624','2022-05-15 19:36:53','624','2022-05-15 19:37:44',10,0),('1','180',256839,'Daily shift','2022-05-16','2022-05-16 06:35:12','2022-05-17 06:35:12','624',0.00,0.00,'624','2022-05-16 22:45:31','624','2022-05-16 22:45:47',10,0),('1','180',256840,'Daily shift','2022-05-17','2022-05-17 07:03:45','2022-05-18 07:03:45','624',0.00,0.00,'624','2022-05-17 22:36:54','624','2022-05-17 22:37:10',10,0),('1','180',256841,'Daily shift','2022-05-18','2022-05-18 06:52:28','2022-05-19 06:52:28','624',0.00,0.00,'624','2022-05-18 19:59:20','624','2022-05-18 19:59:41',10,0),('1','180',256842,'Daily shift','2022-05-19','2022-05-19 05:55:27','2022-05-20 05:55:27','624',0.00,0.00,'624','2022-05-19 20:01:24','624','2022-05-19 20:01:41',10,0),('1','180',256843,'Daily shift','2022-05-20','2022-05-20 01:09:33','2022-05-21 01:09:33','624',0.00,0.00,'624','2022-05-20 22:16:05','624','2022-05-20 22:16:23',10,0),('1','180',256844,'Daily shift','2022-05-21','2022-05-21 06:16:20','2022-05-22 06:16:20','624',0.00,0.00,'624','2022-05-21 22:10:26','624','2022-05-21 22:10:44',10,0),('1','180',256845,'Daily shift','2022-05-22','2022-05-22 00:36:02','2022-05-23 00:36:02','624',0.00,0.00,'624','2022-05-22 21:51:04','624','2022-05-22 21:51:23',10,0),('1','180',256846,'Daily shift','2022-05-23','2022-05-23 01:55:59','2022-05-24 01:55:59','624',0.00,0.00,'624','2022-05-23 21:59:39','624','2022-05-23 21:59:58',10,0),('1','180',256847,'Daily shift','2022-05-24','2022-05-24 07:58:25','2022-05-25 07:58:25','624',0.00,0.00,'624','2022-05-24 20:38:07','624','2022-05-24 20:38:25',10,0),('1','180',256848,'Daily shift','2022-05-25','2022-05-25 06:05:39','2022-05-26 06:05:39','624',0.00,0.00,'624','2022-05-25 23:06:23','624','2022-05-25 23:06:41',10,0),('1','180',256849,'Daily shift','2022-05-26','2022-05-26 00:04:24','2022-05-27 00:04:24','624',0.00,0.00,'624','2022-05-26 21:35:08','624','2022-05-26 21:35:33',10,0),('1','180',256850,'Daily shift','2022-05-27','2022-05-27 07:28:28','2022-05-28 07:28:28','624',0.00,0.00,'624','2022-05-27 21:04:39','624','2022-05-27 21:04:56',10,0),('1','180',256851,'Daily shift','2022-05-28','2022-05-28 06:35:26','2022-05-29 06:35:26','624',0.00,0.00,'624','2022-05-28 21:38:45','624','2022-05-28 21:39:02',10,0),('1','180',256852,'Daily shift','2022-05-29','2022-05-29 01:06:03','2022-05-30 01:06:03','624',0.00,0.00,'624','2022-05-29 21:19:00','624','2022-05-29 21:19:14',10,0),('1','180',256853,'Daily shift','2022-05-30','2022-05-30 07:07:35','2022-05-31 07:07:35','624',0.00,0.00,'624','2022-05-30 22:06:38','624','2022-05-30 22:07:09',10,0),('1','180',256854,'Daily shift','2022-05-31','2022-05-31 06:04:07','2022-06-01 06:04:07','624',0.00,0.00,'624','2022-05-31 20:19:18','624','2022-05-31 20:19:33',10,0),('1','180',256855,'Daily shift','2022-06-01','2022-06-01 06:07:16','2022-06-02 06:07:16','624',0.00,0.00,'624','2022-06-01 22:17:01','624','2022-06-01 22:17:22',10,0),('1','180',256856,'Daily shift','2022-06-02','2022-06-02 00:41:08','2022-06-03 00:41:08','624',0.00,0.00,'624','2022-06-02 22:40:19','624','2022-06-02 22:40:43',10,0),('1','180',256857,'Daily shift','2022-06-03','2022-06-03 00:03:51','2022-06-04 00:03:51','624',0.00,0.00,'624','2022-06-03 20:41:38','624','2022-06-03 20:41:55',10,0),('1','180',256858,'Daily shift','2022-06-04','2022-06-04 06:19:17','2022-06-05 06:19:17','624',0.00,0.00,'624','2022-06-04 21:31:14','624','2022-06-04 21:31:31',10,0),('1','180',256859,'Daily shift','2022-06-05','2022-06-05 07:18:06','2022-06-06 07:18:06','624',0.00,0.00,'624','2022-06-05 20:37:35','624','2022-06-05 20:37:51',10,0),('1','180',256860,'Daily shift','2022-06-06','2022-06-06 07:30:35','2022-06-07 07:30:35','624',0.00,0.00,'624','2022-06-06 21:23:40','624','2022-06-06 21:23:54',10,0),('1','180',256861,'Daily shift','2022-06-07','2022-06-07 07:11:33','2022-06-08 07:11:33','624',0.00,0.00,'624','2022-06-07 21:23:35','624','2022-06-07 21:23:49',10,0),('1','180',256862,'Daily shift','2022-06-08','2022-06-08 07:06:28','2022-06-09 07:06:28','624',0.00,0.00,'624','2022-06-08 22:14:23','624','2022-06-08 22:14:40',10,0),('1','180',256863,'Daily shift','2022-06-09','2022-06-09 09:26:26','2022-06-10 09:26:26','624',0.00,0.00,'624','2022-06-09 21:26:56','624','2022-06-09 21:27:11',10,0),('1','180',256864,'Daily shift','2022-06-10','2022-06-10 07:00:05','2022-06-11 07:00:05','624',0.00,0.00,'624','2022-06-10 20:22:55','624','2022-06-10 20:23:10',10,0),('1','180',256865,'Daily shift','2022-06-11','2022-06-11 00:10:51','2022-06-12 00:10:51','624',0.00,0.00,'624','2022-06-11 21:08:37','624','2022-06-11 21:08:51',10,0),('1','180',256866,'Daily shift','2022-06-12','2022-06-12 00:03:44','2022-06-13 00:03:44','624',0.00,0.00,'624','2022-06-12 21:28:34','624','2022-06-12 21:28:51',10,0),('1','180',256867,'Daily shift','2022-06-13','2022-06-13 00:03:08','2022-06-14 00:03:08','624',0.00,0.00,'624','2022-06-13 18:38:35','624','2022-06-13 18:38:52',10,0),('1','180',256868,'Daily shift','2022-06-14','2022-06-14 00:23:34','2022-06-15 00:23:34','624',0.00,0.00,'624','2022-06-14 19:22:17','624','2022-06-14 19:22:36',10,0),('1','180',256869,'Daily shift','2022-06-15','2022-06-15 00:06:31','2022-06-16 00:06:31','624',0.00,0.00,'624','2022-06-15 18:38:24','624','2022-06-15 18:38:42',10,0),('1','180',256870,'Daily shifft','2022-06-16','2022-06-16 08:17:50','2022-06-17 08:17:50','624',0.00,0.00,'624','2022-06-16 19:21:42','624','2022-06-16 19:22:03',10,0),('1','180',256871,'Daily shift','2022-06-17','2022-06-17 00:14:50','2022-06-18 00:14:50','624',0.00,0.00,'624','2022-06-17 20:03:39','624','2022-06-17 20:04:37',10,0),('1','180',256872,'Daily shift','2022-06-18','2022-06-18 00:22:36','2022-06-19 00:22:36','624',0.00,0.00,'624','2022-06-18 18:56:46','624','2022-06-18 18:57:00',10,0),('1','180',256873,'Daily shift','2022-06-19','2022-06-19 00:04:02','2022-06-20 00:04:02','624',0.00,0.00,'624','2022-06-19 21:12:30','624','2022-06-19 21:12:57',10,0),('1','180',256874,'Daily shift','2022-06-20','2022-06-20 06:19:00','2022-06-21 06:19:00','624',0.00,0.00,'624','2022-06-20 22:06:36','624','2022-06-20 22:06:53',10,0),('1','180',256875,'Daily shift','2022-06-21','2022-06-21 00:28:34','2022-06-22 00:28:34','624',0.00,0.00,'624','2022-06-21 22:14:28','624','2022-06-21 22:14:45',10,0),('1','180',256876,'Daily shift','2022-06-25','2022-06-25 10:21:08','2022-06-26 10:21:08','624',0.00,0.00,'624','2022-06-25 10:25:43','624','2022-06-25 10:25:58',10,0),('1','180',256877,'Daily shift','2022-04-29','2022-06-25 10:32:09','2022-06-26 10:32:09','624',0.00,0.00,'624','2022-06-25 10:35:42','624','2022-06-25 10:35:56',10,0),('1','180',256878,'Daily shift','2022-06-25','2022-06-25 10:36:21','2022-06-26 10:36:21','624',0.00,0.00,'624','2022-06-25 19:55:51','624','2022-06-25 19:56:06',10,0),('1','180',256879,'Daily shift','2022-06-26','2022-06-26 07:46:29','2022-06-27 07:46:29','624',0.00,0.00,'624','2022-06-26 19:54:00','624','2022-06-26 19:54:15',10,0),('1','180',256880,'Daily shift','2022-06-27','2022-06-27 08:21:23','2022-06-28 08:21:23','624',0.00,0.00,'624','2022-06-27 19:37:05','624','2022-06-27 19:37:30',10,0),('1','180',256881,'Daily shift','2022-06-28','2022-06-28 00:39:21','2022-06-29 00:39:21','624',0.00,0.00,'624','2022-06-28 19:35:21','624','2022-06-28 19:35:37',10,0),('1','180',256882,'Daily shift','2022-06-29','2022-06-29 00:49:36','2022-06-30 00:49:36','624',0.00,0.00,'624','2022-06-29 19:04:48','624','2022-06-29 19:05:14',10,0),('1','180',256883,'Daily shift','2022-06-30','2022-06-30 00:33:23','2022-07-01 00:33:23','624',0.00,0.00,'624','2022-06-30 19:45:24','624','2022-06-30 19:51:31',10,0),('1','180',256884,'Daily shifft','2022-07-01','2022-07-01 00:39:19','2022-07-02 00:39:19','624',0.00,0.00,'624','2022-07-01 21:12:37','624','2022-07-01 21:12:53',10,0),('1','180',256885,'Daily shift','2022-07-02','2022-07-02 01:13:07','2022-07-03 01:13:07','624',0.00,0.00,'624','2022-07-02 19:10:34','624','2022-07-02 19:10:48',10,0),('1','180',256886,'Daily shiftl','2022-07-03','2022-07-03 00:07:47','2022-07-04 00:07:47','624',0.00,0.00,'624','2022-07-03 21:05:54','624','2022-07-03 21:06:11',10,0),('1','180',256887,'Daily shiftl','2022-07-04','2022-07-04 02:50:28','2022-07-05 02:50:28','624',0.00,0.00,'624','2022-07-04 21:56:13','624','2022-07-04 21:56:29',10,0),('1','180',256888,'Daily shift','2022-07-05','2022-07-05 00:11:28','2022-07-06 00:11:28','624',0.00,0.00,'624','2022-07-05 21:32:00','624','2022-07-05 21:32:15',10,0),('1','180',256889,'Daily shift','2022-07-06','2022-07-06 00:32:44','2022-07-07 00:32:44','624',0.00,0.00,'624','2022-07-06 20:12:25','624','2022-07-06 20:12:53',10,0),('1','180',256890,'Daily shift','2022-07-07','2022-07-07 00:33:45','2022-07-08 00:33:45','624',0.00,0.00,'624','2022-07-07 20:57:35','624','2022-07-07 20:57:54',10,0),('1','180',256891,'Daily shift','2022-07-08','2022-07-08 01:20:35','2022-07-09 01:20:35','624',0.00,0.00,'624','2022-07-08 19:57:26','624','2022-07-08 19:58:21',10,0),('1','180',256892,'Daily shift','2022-07-09','2022-07-09 09:15:57','2022-07-10 09:15:57','624',0.00,0.00,'624','2022-07-09 22:31:13','624','2022-07-09 22:31:29',10,0),('1','180',256893,'Daily shift','2022-07-10','2022-07-10 08:16:51','2022-07-11 08:16:51','624',0.00,0.00,'624','2022-07-10 22:09:16','624','2022-07-10 22:10:20',10,0),('1','180',256894,'Daily shift','2022-07-11','2022-07-11 00:06:16','2022-07-12 00:06:16','624',0.00,0.00,'624','2022-07-11 23:28:35','624','2022-07-11 23:29:12',10,0),('1','180',256895,'Daily shift','2022-07-12','2022-07-12 01:22:24','2022-07-13 01:22:24','624',0.00,0.00,'624','2022-07-12 20:41:47','624','2022-07-12 20:42:07',10,0),('1','180',256896,'Daily shift','2022-07-13','2022-07-13 05:28:23','2022-07-14 05:28:23','624',0.00,0.00,'624','2022-07-13 18:52:55','624','2022-07-13 18:53:15',10,0),('1','180',256897,'Daily shift','2022-07-14','2022-07-14 07:38:01','2022-07-15 07:38:01','624',0.00,0.00,'624','2022-07-14 18:48:21','624','2022-07-14 18:48:36',10,0),('1','180',256898,'Daily shift','2022-07-15','2022-07-15 07:24:56','2022-07-16 07:24:56','624',0.00,0.00,'624','2022-07-15 21:16:11','624','2022-07-15 21:16:36',10,0),('1','180',256899,'Daily shift','2022-07-16','2022-07-16 09:00:56','2022-07-17 09:00:56','624',0.00,0.00,'624','2022-07-16 21:35:07','624','2022-07-16 21:35:31',10,0),('1','180',256900,'Daily shift','2022-07-17','2022-07-17 07:15:16','2022-07-18 07:15:16','624',0.00,0.00,'624','2022-07-17 18:42:05','624','2022-07-17 18:42:19',10,0),('1','180',256901,'Daily shift','2022-07-18','2022-07-18 08:31:46','2022-07-19 08:31:46','624',0.00,0.00,'624','2022-07-18 18:50:19','624','2022-07-18 18:50:50',10,0),('1','180',256902,'Daily shift','2022-07-19','2022-07-19 01:06:44','2022-07-20 01:06:44','624',0.00,0.00,'624','2022-07-19 20:47:53','624','2022-07-19 20:48:10',10,0),('1','180',256903,'Daily shift','2022-07-20','2022-07-20 00:15:56','2022-07-21 00:15:56','624',0.00,0.00,'624','2022-07-20 20:07:15','624','2022-07-20 20:07:46',10,0),('1','180',256904,'Daily shift','2022-07-21','2022-07-21 00:31:35','2022-07-22 00:31:35','624',0.00,0.00,'624','2022-07-21 19:48:29','624','2022-07-21 19:52:27',10,0),('1','180',256905,'Daily shift','2022-07-22','2022-07-22 01:11:13','2022-07-23 01:11:13','624',0.00,0.00,'624','2022-07-22 20:14:17','624','2022-07-22 20:16:42',10,0),('1','180',256906,'Daily shift','2022-07-23','2022-07-23 04:09:11','2022-07-24 04:09:11','624',0.00,0.00,'624','2022-07-23 19:52:34','624','2022-07-23 19:54:57',10,0),('1','180',256907,'Daily shift','2022-07-24','2022-07-24 06:38:41','2022-07-25 06:38:41','624',0.00,0.00,'624','2022-07-24 19:44:26','624','2022-07-24 19:44:56',10,0),('1','180',256908,'Operational loss','2022-07-27','2022-07-27 10:03:25','2022-07-28 10:03:25','624',0.00,0.00,'624','2022-07-27 10:09:11','624','2022-07-27 10:09:27',10,0),('1','180',256909,'Daily shift','2022-07-27','2022-07-27 10:10:08','2022-07-28 10:10:08','624',0.00,0.00,'624','2022-07-27 20:40:47','624','2022-07-27 20:41:30',10,0),('1','180',256910,'Daily shift','2022-07-28','2022-07-28 04:53:00','2022-07-29 04:53:00','624',0.00,0.00,'624','2022-07-28 20:11:58','624','2022-07-28 20:12:13',10,0),('1','180',256911,'Daily shift','2022-07-29','2022-07-29 03:45:16','2022-07-30 03:45:16','624',0.00,0.00,'624','2022-07-29 20:06:20','624','2022-07-29 20:06:59',10,0),('1','180',256912,'Daily shift','2022-07-30','2022-07-30 05:04:08','2022-07-31 05:04:08','624',0.00,0.00,'624','2022-07-30 19:29:16','624','2022-07-30 19:29:34',10,0),('1','180',256913,'Daily shift','2022-07-31','2022-07-31 07:06:10','2022-08-01 07:06:10','624',0.00,0.00,'624','2022-07-31 19:36:15','624','2022-07-31 19:36:35',10,0),('1','180',256914,'Daily shift','2022-08-01','2022-08-01 05:03:01','2022-08-02 05:03:01','624',0.00,0.00,'624','2022-08-01 21:02:37','624','2022-08-01 21:02:56',10,0),('1','180',256915,'Daily shift','2022-08-02','2022-08-02 04:33:20','2022-08-03 04:33:20','624',0.00,0.00,'624','2022-08-02 20:02:10','624','2022-08-02 20:02:43',10,0),('1','180',256916,'Daily shift','2022-08-03','2022-08-03 06:01:22','2022-08-04 06:01:22','624',0.00,0.00,'624','2022-08-03 21:30:11','624','2022-08-03 21:30:33',10,0),('1','180',256917,'Daily shift','2022-08-04','2022-08-04 00:05:09','2022-08-05 00:05:09','624',0.00,0.00,'624','2022-08-04 18:58:10','624','2022-08-04 18:58:45',10,0),('1','180',256918,'Daily shift','2022-08-05','2022-08-05 00:04:55','2022-08-06 00:04:55','624',0.00,0.00,'624','2022-08-05 19:45:39','624','2022-08-05 19:46:05',10,0),('1','180',256919,'Daily shift','2022-08-06','2022-08-06 04:27:19','2022-08-07 04:27:19','624',0.00,0.00,'624','2022-08-06 19:39:04','624','2022-08-06 19:39:21',10,0),('1','180',256920,'Daily shift','2022-08-07','2022-08-07 07:17:26','2022-08-08 07:17:26','624',0.00,0.00,'624','2022-08-07 19:24:58','624','2022-08-07 19:25:20',10,0),('1','180',256921,'Daily shift','2022-08-08','2022-08-08 05:42:19','2022-08-09 05:42:19','624',0.00,0.00,'624','2022-08-08 21:19:21','624','2022-08-08 21:19:48',10,0),('1','180',256922,'Daily shift','2022-08-09','2022-08-09 05:07:18','2022-08-10 05:07:18','624',0.00,0.00,'624','2022-08-09 19:48:48','624','2022-08-09 19:49:11',10,0),('1','180',256923,'Daily shift','2022-08-10','2022-08-10 00:06:41','2022-08-11 00:06:41','624',0.00,0.00,'624','2022-08-10 20:05:33','624','2022-08-10 20:05:56',10,0),('1','180',256924,'Daily shift','2022-08-11','2022-08-11 06:30:19','2022-08-12 06:30:19','624',0.00,0.00,'624','2022-08-11 20:09:55','624','2022-08-11 20:10:11',10,0),('1','180',256925,'Daily shift','2022-08-12','2022-08-12 07:07:13','2022-08-13 07:07:13','624',0.00,0.00,'624','2022-08-12 21:41:17','624','2022-08-12 21:41:47',10,0),('1','180',256926,'Daily shift','2022-08-13','2022-08-13 07:02:55','2022-08-14 07:02:55','624',0.00,0.00,'624','2022-08-13 20:09:06','624','2022-08-13 20:09:24',10,0),('1','180',256927,'Daily shift','2022-08-14','2022-08-14 08:50:24','2022-08-15 08:50:24','624',0.00,0.00,'624','2022-08-14 20:19:11','624','2022-08-14 20:19:25',10,0),('1','180',256928,'Daily shift','2022-08-15','2022-08-15 07:09:34','2022-08-16 07:09:34','624',0.00,0.00,'624','2022-08-15 20:34:34','624','2022-08-15 20:34:53',10,0),('1','180',256929,'Daily shift','2022-08-16','2022-08-16 06:21:07','2022-08-17 06:21:07','624',0.00,0.00,'624','2022-08-16 20:41:27','624','2022-08-16 20:41:47',10,0),('1','180',256930,'Daily shift','2022-08-17','2022-08-17 06:11:26','2022-08-18 06:11:26','624',0.00,0.00,'624','2022-08-17 20:49:30','624','2022-08-17 20:49:55',10,0),('1','180',256931,'Daily shift','2022-08-18','2022-08-18 01:40:19','2022-08-19 01:40:19','624',0.00,0.00,'624','2022-08-18 19:58:13','624','2022-08-18 19:58:29',10,0),('1','180',256932,'Daily shift','2022-08-19','2022-08-19 00:21:24','2022-08-20 00:21:24','624',0.00,0.00,'624','2022-08-19 21:19:19','624','2022-08-19 21:19:43',10,0),('1','180',256933,'Daily shift','2022-08-20','2022-08-20 00:04:43','2022-08-21 00:04:43','624',0.00,0.00,'624','2022-08-20 20:31:45','624','2022-08-20 20:33:06',10,0),('1','180',256934,'Daily shift','2022-08-21','2022-08-21 00:27:01','2022-08-22 00:27:01','624',0.00,0.00,'624','2022-08-21 19:11:13','624','2022-08-21 19:11:35',10,0),('1','180',256935,'Daily shift','2022-08-22','2022-08-22 02:23:50','2022-08-23 02:23:50','624',0.00,0.00,'624','2022-08-22 20:40:18','624','2022-08-22 20:41:24',10,0),('1','180',256936,'Daily shift','2022-08-23','2022-08-23 02:33:28','2022-08-24 02:33:28','624',0.00,0.00,'624','2022-08-23 19:33:27','624','2022-08-23 19:33:41',10,0),('1','180',256937,'Operational loss','2022-09-10','2022-09-10 00:52:25','2022-09-11 00:52:25','624',0.00,0.00,'624','2022-09-10 00:55:36','624','2022-09-10 00:55:50',10,0),('1','180',256938,'Daily shift','2022-09-10','2022-09-10 01:02:55','2022-09-11 01:02:55','624',0.00,0.00,'624','2022-09-10 21:02:12','624','2022-09-10 21:02:26',10,0),('1','180',256939,'Daily shift','2022-09-11','2022-09-11 05:50:53','2022-09-12 05:50:53','624',0.00,0.00,'624','2022-09-11 19:40:47','624','2022-09-11 19:41:17',10,0),('1','180',256940,'Daily shift','2022-09-12','2022-09-12 02:03:58','2022-09-13 02:03:58','624',0.00,0.00,'624','2022-09-12 21:46:54','624','2022-09-12 21:49:05',10,0),('1','180',256941,'Daily shift','2022-09-13','2022-09-13 01:08:46','2022-09-14 01:08:46','624',0.00,0.00,'624','2022-09-13 19:40:51','624','2022-09-13 19:41:17',10,0),('1','180',256942,'Daily shift','2022-09-14','2022-09-14 00:13:10','2022-09-15 00:13:10','624',0.00,0.00,'624','2022-09-14 20:25:26','624','2022-09-14 20:25:42',10,0),('1','180',256943,'Daily shift','2022-09-15','2022-09-15 00:10:41','2022-09-16 00:10:41','624',0.00,0.00,'624','2022-09-15 23:09:38','624','2022-09-15 23:09:57',10,0),('1','180',256944,'Daily shift','2022-09-16','2022-09-16 00:18:09','2022-09-17 00:18:09','624',0.00,0.00,'624','2022-09-16 19:22:42','624','2022-09-16 19:23:01',10,0),('1','180',256945,'Daily shift','2022-09-17','2022-09-17 00:42:46','2022-09-18 00:42:46','624',0.00,0.00,'624','2022-09-17 21:20:14','624','2022-09-17 21:20:30',10,0),('1','180',256946,'Daily shift','2022-09-18','2022-09-18 07:45:18','2022-09-19 07:45:18','624',0.00,0.00,'624','2022-09-18 19:48:00','624','2022-09-18 19:48:21',10,0),('1','180',256947,'Daily shift','2022-09-19','2022-09-19 05:47:11','2022-09-20 05:47:11','624',0.00,0.00,'624','2022-09-19 20:34:40','624','2022-09-19 20:35:03',10,0),('1','180',256948,'Daily shift','2022-09-20','2022-09-20 05:41:24','2022-09-21 05:41:24','624',0.00,0.00,'624','2022-09-20 19:11:02','624','2022-09-20 19:11:17',10,0),('1','180',256949,'Daily shift','2022-09-21','2022-09-21 00:52:47','2022-09-22 00:52:47','624',0.00,0.00,'624','2022-09-21 20:57:50','624','2022-09-21 20:58:32',10,0),('1','180',256950,'Daily shift','2022-09-22','2022-09-22 00:05:03','2022-09-23 00:05:03','624',0.00,0.00,'624','2022-09-22 19:17:50','624','2022-09-22 19:18:12',10,0),('1','180',256951,'Daily shift','2022-09-23','2022-09-23 00:03:37','2022-09-24 00:03:37','624',0.00,0.00,'624','2022-09-23 19:15:37','624','2022-09-23 19:15:57',10,0),('1','180',256952,'Daily shift','2022-09-24','2022-09-24 00:10:26','2022-09-25 00:10:26','624',0.00,0.00,'624','2022-09-24 19:12:09','624','2022-09-24 19:12:24',10,0),('1','180',256953,'Daily shift','2022-09-25','2022-09-25 06:39:00','2022-09-26 06:39:00','624',0.00,0.00,'624','2022-09-25 18:49:38','624','2022-09-25 18:50:14',10,0),('1','180',256954,'Daily shift','2022-09-26','2022-09-26 04:03:09','2022-09-27 04:03:09','624',0.00,0.00,'624','2022-09-26 20:44:17','624','2022-09-26 20:44:38',10,0),('1','180',256955,'Daily shift','2022-09-27','2022-09-27 00:03:14','2022-09-28 00:03:14','624',0.00,0.00,'624','2022-09-27 19:21:45','624','2022-09-27 19:22:04',10,0),('1','180',256956,'Daily shift','2022-09-28','2022-09-28 04:27:08','2022-09-29 04:27:08','624',0.00,0.00,'624','2022-09-28 20:16:18','624','2022-09-28 20:16:44',10,0),('1','180',256957,'Daily shift','2022-09-29','2022-09-29 00:01:55','2022-09-30 00:01:55','624',0.00,0.00,'624','2022-09-29 20:06:34','624','2022-09-29 20:06:52',10,0),('1','180',256958,'Daily shift','2022-09-30','2022-09-30 02:14:24','2022-10-01 02:14:24','624',0.00,0.00,'624','2022-09-30 20:07:44','624','2022-09-30 20:08:06',10,0),('1','180',256959,'Daily shift','2022-10-01','2022-10-01 00:23:58','2022-10-02 00:23:58','624',0.00,0.00,'624','2022-10-01 19:40:11','624','2022-10-01 19:40:30',10,0),('1','180',256960,'Daily shift','2022-10-02','2022-10-02 07:55:37','2022-10-03 07:55:37','624',0.00,0.00,'624','2022-10-02 21:00:07','624','2022-10-02 21:00:36',10,0),('1','180',256961,'Daily shift','2022-10-03','2022-10-03 00:16:52','2022-10-04 00:16:52','624',0.00,0.00,'624','2022-10-03 19:21:59','624','2022-10-03 19:22:20',10,0),('1','180',256962,'Daily shift','2022-10-04','2022-10-04 01:12:07','2022-10-05 01:12:07','624',0.00,0.00,'624','2022-10-04 19:18:37','624','2022-10-04 19:18:51',10,0),('1','180',256963,'Daily shift','2022-10-05','2022-10-05 01:51:07','2022-10-06 01:51:07','624',0.00,0.00,'624','2022-10-05 21:29:11','624','2022-10-05 21:29:29',10,0),('1','180',256964,'Daily shift','2022-10-06','2022-10-06 01:22:31','2022-10-07 01:22:31','624',0.00,0.00,'624','2022-10-06 19:29:07','624','2022-10-06 19:29:24',10,0),('1','180',256965,'Daily shift','2022-10-07','2022-10-07 09:09:05','2022-10-08 09:09:05','624',0.00,0.00,'624','2022-10-07 23:04:17','624','2022-10-07 23:04:32',10,0),('1','180',256966,'Daily shift','2022-10-08','2022-10-08 09:40:11','2022-10-09 09:40:11','624',0.00,0.00,'624','2022-10-08 19:33:28','624','2022-10-08 19:33:50',10,0),('1','180',256967,'Daily shift','2022-10-09','2022-10-09 00:02:05','2022-10-10 00:02:05','624',0.00,0.00,'624','2022-10-09 19:12:56','624','2022-10-09 19:13:11',10,0),('1','180',256968,'Daily shift','2022-10-10','2022-10-10 01:04:24','2022-10-11 01:04:24','624',0.00,0.00,'624','2022-10-10 20:20:06','624','2022-10-10 20:20:34',10,0),('1','180',256969,'Daily shift','2022-10-11','2022-10-11 07:01:55','2022-10-12 07:01:55','624',0.00,0.00,'624','2022-10-11 19:35:21','624','2022-10-11 19:35:40',10,0),('1','180',256970,'Daily shift','2022-10-12','2022-10-12 00:43:13','2022-10-13 00:43:13','624',0.00,0.00,'624','2022-10-12 18:58:16','624','2022-10-12 18:58:42',10,0),('1','180',256971,'Daily shift','2022-10-13','2022-10-13 00:12:55','2022-10-14 00:12:55','624',0.00,0.00,'624','2022-10-13 20:10:14','624','2022-10-13 20:10:29',10,0),('1','180',256972,'Daily shift','2022-10-14','2022-10-14 00:54:18','2022-10-15 00:54:18','624',0.00,0.00,'624','2022-10-14 19:37:26','624','2022-10-14 19:37:42',10,0),('1','180',256973,'Daily shift','2022-10-15','2022-10-15 00:25:43','2022-10-16 00:25:43','624',0.00,0.00,'624','2022-10-15 18:00:35','624','2022-10-15 18:00:53',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4890596 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','180','934','196061',3826458,'2743','414',0.00,18.50,0.00,0.00,18.50,6364.00,0.00,0.00,0.00),('1','180','934','196322',3831523,'2743','414',18.50,221.50,0.00,0.00,203.00,65432.00,0.00,0.00,0.00),('1','180','934','196472',3834105,'2743','414',221.50,656.80,0.00,0.00,435.30,140943.20,0.00,0.00,0.00),('1','180','934','196699',3838111,'2743','414',656.80,681.25,0.00,0.00,24.45,8410.80,0.00,0.00,0.00),('1','180','934','196916',3842022,'2743','414',681.25,687.25,0.00,0.00,6.00,2064.00,0.00,0.00,0.00),('1','180','934','197083',3845035,'2743','414',687.25,692.25,0.00,0.00,5.00,1720.00,0.00,0.00,0.00),('1','180','934','197299',3849476,'2743','414',692.25,1207.75,0.00,0.00,515.50,166332.00,0.00,0.00,0.00),('1','180','934','197303',3849535,'2743','414',1207.75,1463.75,0.00,0.00,256.00,82564.00,0.00,0.00,0.00),('1','180','934','197535',3852684,'2743','414',1463.75,1987.05,0.00,0.00,523.30,169081.20,0.00,0.00,0.00),('1','180','934','197893',3859108,'2743','414',1987.05,2035.68,0.00,0.00,48.63,16728.72,0.00,0.00,0.00),('1','180','934','198135',3863292,'2743','414',2035.68,2564.18,0.00,0.00,528.50,170804.00,0.00,0.00,0.00),('1','180','934','198354',3867103,'2743','414',2564.18,2612.81,0.00,0.00,48.63,16728.72,0.00,0.00,0.00),('1','180','934','198577',3870898,'2743','414',2612.81,2644.62,0.00,0.00,31.81,10942.64,0.00,0.00,0.00),('1','180','934','198797',3874501,'2743','414',2644.62,2996.12,0.00,0.00,351.50,114316.00,0.00,0.00,0.00),('1','180','934','199005',3878164,'2743','414',2996.12,3182.62,0.00,0.00,186.50,60526.00,0.00,0.00,0.00),('1','180','934','199247',3882446,'2743','414',3182.62,3785.12,0.00,0.00,602.50,195160.00,0.00,0.00,0.00),('1','180','934','199467',3885854,'2743','414',3785.12,3818.93,0.00,0.00,33.81,11630.64,0.00,0.00,0.00),('1','180','934','199727',3890111,'2743','414',3818.93,4239.29,0.00,0.00,420.36,136815.84,0.00,0.00,0.00),('1','180','934','199892',3892809,'2743','414',4239.29,4265.29,0.00,0.00,26.00,8504.00,0.00,0.00,0.00),('1','180','934','200624',3906286,'2743','414',4265.29,4428.29,0.00,0.00,163.00,53036.00,0.00,0.00,0.00),('1','180','934','200789',3909131,'2743','414',4428.29,5170.79,0.00,0.00,742.50,241296.00,0.00,0.00,0.00),('1','180','934','200929',3911611,'2743','414',5170.79,5277.19,0.00,0.00,106.40,36601.60,0.00,0.00,0.00),('1','180','934','201123',3914705,'2743','414',5277.19,5340.59,0.00,0.00,63.40,21809.60,0.00,0.00,0.00),('1','180','934','201330',3918248,'2743','414',5340.59,5643.00,0.00,0.00,302.41,99189.04,0.00,0.00,0.00),('1','180','934','201525',3921751,'2743','414',5643.00,5665.82,0.00,0.00,22.82,7850.08,0.00,0.00,0.00),('1','180','934','201792',3926978,'2743','414',5665.82,5994.06,0.00,0.00,328.24,106314.56,0.00,0.00,0.00),('1','180','934','202043',3931762,'2743','414',5994.06,6208.97,0.00,0.00,214.91,70299.04,0.00,0.00,0.00),('1','180','934','202250',3935179,'2743','414',6208.97,6225.97,0.00,0.00,17.00,5848.00,0.00,0.00,0.00),('1','180','934','202698',3942951,'2743','414',6225.97,6393.47,0.00,0.00,167.50,55420.00,0.00,0.00,0.00),('1','180','934','202871',3946117,'2743','414',6393.47,6576.97,0.00,0.00,183.50,60594.00,0.00,0.00,0.00),('1','180','934','203128',3951037,'2743','414',6576.97,6666.47,0.00,0.00,89.50,29688.00,0.00,0.00,0.00),('1','180','934','203325',3954633,'2743','414',6666.47,7158.47,0.00,0.00,492.00,158864.00,0.00,0.00,0.00),('1','180','934','203545',3958601,'2743','414',7158.47,7476.27,0.00,0.00,317.80,103053.20,0.00,0.00,0.00),('1','180','934','203659',3960859,'2743','414',7476.27,7476.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','203807',3963354,'2743','414',7476.27,7536.71,0.00,0.00,60.44,21758.40,0.00,0.00,0.00),('1','180','934','203985',3966306,'2743','414',7536.71,7637.99,0.00,0.00,101.28,34180.80,0.00,0.00,0.00),('1','180','934','204210',3970534,'2743','414',7637.99,7761.07,0.00,0.00,123.08,42028.80,0.00,0.00,0.00),('1','180','934','204417',3974205,'2743','414',7761.07,7850.35,0.00,0.00,89.28,32140.80,0.00,0.00,0.00),('1','180','934','204675',3978803,'2743','414',7850.35,8004.61,0.00,0.00,154.26,52733.60,0.00,0.00,0.00),('1','180','934','204881',3982172,'2743','414',8004.61,8052.61,0.00,0.00,48.00,17280.00,0.00,0.00,0.00),('1','180','934','205093',3985981,'2743','414',8052.61,8166.81,0.00,0.00,114.20,39432.00,0.00,0.00,0.00),('1','180','934','205329',3990342,'2743','414',8166.81,8355.69,0.00,0.00,188.88,63292.80,0.00,0.00,0.00),('1','180','934','205506',3993436,'2743','414',8355.69,8414.69,0.00,0.00,59.00,21240.00,0.00,0.00,0.00),('1','180','934','205758',3998091,'2743','414',8414.69,8920.69,0.00,0.00,506.00,168636.00,0.00,0.00,0.00),('1','180','934','206043',4003214,'2743','414',8920.69,9216.41,0.00,0.00,295.72,99431.20,0.00,0.00,0.00),('1','180','934','206190',4005872,'2743','414',9216.41,9380.14,0.00,0.00,163.73,57262.80,0.00,0.00,0.00),('1','180','934','206415',4009682,'2743','414',9380.14,9420.42,0.00,0.00,40.28,14500.80,0.00,0.00,0.00),('1','180','934','206615',4013215,'2743','414',9420.42,9492.78,0.00,0.00,72.36,26049.60,0.00,0.00,0.00),('1','180','934','206927',4018889,'2743','414',9492.78,9796.56,0.00,0.00,303.78,101492.80,0.00,0.00,0.00),('1','180','934','207100',4021847,'2743','414',9796.56,9896.84,0.00,0.00,100.28,34420.80,0.00,0.00,0.00),('1','180','934','207349',4026265,'2743','414',9896.84,9958.92,0.00,0.00,62.08,22348.80,0.00,0.00,0.00),('1','180','934','207533',4029731,'2743','414',9958.92,10221.92,0.00,0.00,263.00,91432.00,0.00,0.00,0.00),('1','180','934','207772',4033691,'2743','414',10221.92,10447.22,0.00,0.00,225.30,84114.00,0.00,0.00,0.00),('1','180','934','207968',4037055,'2743','414',10447.22,10624.98,0.00,0.00,177.76,64798.80,0.00,0.00,0.00),('1','180','934','208152',4040218,'2743','414',10624.98,10752.98,0.00,0.00,128.00,47140.00,0.00,0.00,0.00),('1','180','934','208369',4044225,'2743','414',10752.98,11012.37,0.00,0.00,259.39,94168.20,0.00,0.00,0.00),('1','180','934','208580',4047820,'2743','414',11012.37,11085.02,0.00,0.00,72.65,27607.00,0.00,0.00,0.00),('1','180','934','208827',4052025,'2743','414',11085.02,11211.91,0.00,0.00,126.89,46718.20,0.00,0.00,0.00),('1','180','934','209106',4056913,'2743','414',11211.91,11465.91,0.00,0.00,254.00,93770.00,0.00,0.00,0.00),('1','180','934','209296',4060273,'2743','414',11465.91,11914.41,0.00,0.00,448.50,171480.00,0.00,0.00,0.00),('1','180','934','209494',4063879,'2743','414',11914.41,12046.16,0.00,0.00,131.75,52700.00,0.00,0.00,0.00),('1','180','934','209704',4067612,'2743','414',12046.16,12630.91,0.00,0.00,584.75,221276.00,0.00,0.00,0.00),('1','180','934','209974',4072445,'2743','414',12630.91,12693.87,0.00,0.00,62.96,26443.20,0.00,0.00,0.00),('1','180','934','210199',4076299,'2743','414',12693.87,12819.75,0.00,0.00,125.88,52869.60,0.00,0.00,0.00),('1','180','934','210387',4079659,'2743','414',12819.75,13056.77,0.00,0.00,237.02,92632.40,0.00,0.00,0.00),('1','180','934','210634',4084249,'2743','414',13056.77,13251.31,0.00,0.00,194.54,79502.80,0.00,0.00,0.00),('1','180','934','210908',4089096,'2743','414',13251.31,13398.46,0.00,0.00,147.15,59523.00,0.00,0.00,0.00),('1','180','934','211134',4093016,'2743','414',13398.46,13417.96,0.00,0.00,19.50,8190.00,0.00,0.00,0.00),('1','180','934','211269',4095413,'2743','414',13417.96,13417.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','211273',4095463,'2743','414',13417.96,13417.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','211277',4095515,'2743','414',13417.96,13417.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','211279',4095538,'2743','414',13417.96,14040.96,0.00,0.00,623.00,248802.40,0.00,0.00,0.00),('1','180','934','211582',4100977,'2743','414',14040.96,14426.36,0.00,0.00,385.40,159262.60,0.00,0.00,0.00),('1','180','934','211753',4103819,'2743','414',14426.36,14476.86,0.00,0.00,50.50,21412.00,0.00,0.00,0.00),('1','180','934','211953',4107256,'2743','414',14476.86,14562.06,0.00,0.00,85.20,36124.80,0.00,0.00,0.00),('1','180','934','212205',4111790,'2743','414',14562.06,14689.46,0.00,0.00,127.40,52277.60,0.00,0.00,0.00),('1','180','934','212342',4114154,'2743','414',14689.46,14755.86,0.00,0.00,66.40,28153.60,0.00,0.00,0.00),('1','180','934','212642',4119748,'2743','414',14755.86,15185.06,0.00,0.00,429.20,171830.80,0.00,0.00,0.00),('1','180','934','212838',4123144,'2743','414',15185.06,15274.26,0.00,0.00,89.20,37820.80,0.00,0.00,0.00),('1','180','934','212972',4125493,'2743','414',15274.26,15475.06,0.00,0.00,200.80,81717.20,0.00,0.00,0.00),('1','180','934','213274',4130407,'2743','414',15475.06,15638.08,0.00,0.00,163.02,69120.48,0.00,0.00,0.00),('1','180','934','213488',4134041,'2743','414',15638.08,15775.00,0.00,0.00,136.92,56314.08,0.00,0.00,0.00),('1','180','934','213726',4137987,'2743','414',15775.00,16073.59,0.00,0.00,298.59,119874.16,0.00,0.00,0.00),('1','180','934','213965',4141863,'2743','414',16073.59,16225.48,0.00,0.00,151.89,62961.36,0.00,0.00,0.00),('1','180','934','214155',4145061,'2743','414',16225.48,16614.28,0.00,0.00,388.80,158227.20,0.00,0.00,0.00),('1','180','934','214412',4149588,'2743','414',16614.28,17025.47,0.00,0.00,411.19,167144.56,0.00,0.00,0.00),('1','180','934','214658',4153730,'2743','414',17025.47,17219.51,0.00,0.00,194.04,80832.96,0.00,0.00,0.00),('1','180','934','214886',4157688,'2743','414',17219.51,17639.91,0.00,0.00,420.40,170665.60,0.00,0.00,0.00),('1','180','934','215110',4161410,'2743','414',17639.91,17897.06,0.00,0.00,257.15,106151.60,0.00,0.00,0.00),('1','180','934','215337',4165357,'2743','414',17897.06,18150.16,0.00,0.00,253.10,103138.40,0.00,0.00,0.00),('1','180','934','215544',4168732,'2743','414',18150.16,18235.54,0.00,0.00,85.38,36201.12,0.00,0.00,0.00),('1','180','934','215756',4172406,'2743','414',18235.54,19127.70,0.00,0.00,892.16,359435.84,0.00,0.00,0.00),('1','180','934','215989',4176369,'2743','414',19127.70,19293.32,0.00,0.00,165.62,68782.88,0.00,0.00,0.00),('1','180','934','216234',4180585,'2743','414',19293.32,19549.32,0.00,0.00,256.00,105904.00,0.00,0.00,0.00),('1','180','934','216415',4183723,'2743','414',19549.32,19712.37,0.00,0.00,163.05,67693.20,0.00,0.00,0.00),('1','180','934','217450',4202337,'2743','414',19712.37,20212.37,0.00,0.00,500.00,200000.00,0.00,0.00,0.00),('1','180','934','217579',4204382,'2743','414',20212.37,20612.03,0.00,0.00,399.66,177516.80,0.00,0.00,0.00),('1','180','934','217863',4209621,'2743','414',20612.03,20753.53,0.00,0.00,141.50,63280.00,0.00,0.00,0.00),('1','180','934','218153',4214624,'2743','414',20753.53,20902.86,0.00,0.00,149.33,71678.40,0.00,0.00,0.00),('1','180','934','218405',4219154,'2743','414',20902.86,21042.94,0.00,0.00,140.08,65038.40,0.00,0.00,0.00),('1','180','934','218608',4222853,'2743','414',21042.94,21149.02,0.00,0.00,106.08,48598.40,0.00,0.00,0.00),('1','180','934','218777',4225536,'2743','414',21149.02,21311.97,0.00,0.00,162.95,75816.00,0.00,0.00,0.00),('1','180','934','219013',4229644,'2743','414',21311.97,22123.68,0.00,0.00,811.71,359620.80,0.00,0.00,0.00),('1','180','934','219311',4235093,'2743','414',22123.68,22273.28,0.00,0.00,149.60,71808.00,0.00,0.00,0.00),('1','180','934','219563',4239416,'2743','414',22273.28,22593.98,0.00,0.00,320.70,144496.00,0.00,0.00,0.00),('1','180','934','220069',4248223,'2743','414',22593.98,22633.98,0.00,0.00,40.00,17600.00,0.00,0.00,0.00),('1','180','934','221044',4265560,'2743','414',22633.98,23613.79,0.00,0.00,979.81,435668.80,0.00,0.00,0.00),('1','180','934','221332',4270810,'2743','414',23613.79,23775.21,0.00,0.00,161.42,73481.60,0.00,0.00,0.00),('1','180','934','221504',4273783,'2743','414',23775.21,24205.96,0.00,0.00,430.75,192040.00,0.00,0.00,0.00),('1','180','934','221775',4278910,'2743','414',24205.96,24626.04,0.00,0.00,420.08,186438.40,0.00,0.00,0.00),('1','180','934','221919',4281203,'2743','414',24626.04,24841.71,0.00,0.00,215.67,98881.60,0.00,0.00,0.00),('1','180','934','222163',4285699,'2743','414',24841.71,25312.21,0.00,0.00,470.50,210240.00,0.00,0.00,0.00),('1','180','934','222448',4290710,'2743','414',25312.21,25425.71,0.00,0.00,113.50,54480.00,0.00,0.00,0.00),('1','180','934','222602',4293199,'2743','414',25425.71,25726.38,0.00,0.00,300.67,136001.60,0.00,0.00,0.00),('1','180','934','222908',4299106,'2743','414',25726.38,25853.95,0.00,0.00,127.57,61233.60,0.00,0.00,0.00),('1','180','934','223088',4302400,'2743','414',25853.95,26447.95,0.00,0.00,594.00,265120.00,0.00,0.00,0.00),('1','180','934','223147',4303363,'2743','414',26447.95,26447.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','223300',4305502,'2743','414',26447.95,26801.45,0.00,0.00,353.50,158720.00,0.00,0.00,0.00),('1','180','934','223508',4309393,'2743','414',26801.45,26924.51,0.00,0.00,123.06,59068.80,0.00,0.00,0.00),('1','180','934','223751',4314047,'2743','414',26924.51,27466.81,0.00,0.00,542.30,253356.00,0.00,0.00,0.00),('1','180','934','224015',4318780,'2743','414',27466.81,27532.81,0.00,0.00,66.00,30492.00,0.00,0.00,0.00),('1','180','934','224960',4335502,'2743','414',27532.81,28361.91,0.00,0.00,829.10,417314.00,0.00,0.00,0.00),('1','180','934','225139',4338757,'2743','414',28361.91,29333.97,0.00,0.00,972.06,488912.40,0.00,0.00,0.00),('1','180','934','225426',4344174,'2743','414',29333.97,30364.34,0.00,0.00,1030.37,518559.80,0.00,0.00,0.00),('1','180','934','225652',4348202,'2743','414',30364.34,30714.04,0.00,0.00,349.70,176438.00,0.00,0.00,0.00),('1','180','934','225938',4352910,'2743','414',30714.04,30870.54,0.00,0.00,156.50,82510.00,0.00,0.00,0.00),('1','180','934','226205',4357956,'2743','414',30870.54,31198.24,0.00,0.00,327.70,165758.00,0.00,0.00,0.00),('1','180','934','226413',4361512,'2743','414',31198.24,31501.44,0.00,0.00,303.20,155088.00,0.00,0.00,0.00),('1','180','934','226674',4366262,'2743','414',31501.44,31761.74,0.00,0.00,260.30,133362.00,0.00,0.00,0.00),('1','180','934','226746',4367445,'2743','414',31761.74,31845.74,0.00,0.00,84.00,45360.00,0.00,0.00,0.00),('1','180','934','227048',4372620,'2743','414',31845.74,32278.24,0.00,0.00,432.50,216750.00,0.00,0.00,0.00),('1','180','934','227335',4377975,'2743','414',32278.24,32446.74,0.00,0.00,168.50,86990.00,0.00,0.00,0.00),('1','180','934','227452',4379993,'2743','414',32446.74,32640.24,0.00,0.00,193.50,102490.00,0.00,0.00,0.00),('1','180','934','227810',4386356,'2743','414',32640.24,33417.34,0.00,0.00,777.10,391034.00,0.00,0.00,0.00),('1','180','934','228087',4391609,'2743','414',33417.34,33852.34,0.00,0.00,435.00,220900.00,0.00,0.00,0.00),('1','180','934','228334',4396315,'2743','414',33852.34,34004.94,0.00,0.00,152.60,80404.00,0.00,0.00,0.00),('1','180','934','228513',4399660,'2743','414',34004.94,34122.74,0.00,0.00,117.80,65968.00,0.00,0.00,0.00),('1','180','934','228665',4402421,'2743','414',34122.74,34470.74,0.00,0.00,348.00,185010.00,0.00,0.00,0.00),('1','180','934','228918',4407222,'2743','414',34470.74,34992.44,0.00,0.00,521.70,273252.00,0.00,0.00,0.00),('1','180','934','229040',4409477,'2743','414',34992.44,35490.13,0.00,0.00,497.69,260016.40,0.00,0.00,0.00),('1','180','934','229373',4415728,'2743','414',35490.13,35914.73,0.00,0.00,424.60,222656.00,0.00,0.00,0.00),('1','180','934','229587',4419722,'2743','414',35914.73,36294.23,0.00,0.00,379.50,208374.00,0.00,0.00,0.00),('1','180','934','229841',4424899,'2743','414',36294.23,36492.13,0.00,0.00,197.90,110121.60,0.00,0.00,0.00),('1','180','934','229905',4425836,'2743','414',36492.13,36644.95,0.00,0.00,152.82,86896.88,0.00,0.00,0.00),('1','180','934','230175',4430846,'2743','414',36644.95,36857.15,0.00,0.00,212.20,116874.80,0.00,0.00,0.00),('1','180','934','230351',4434027,'2743','414',36857.15,37085.50,0.00,0.00,228.35,125836.40,0.00,0.00,0.00),('1','180','934','230643',4439848,'2743','414',37085.50,37604.27,0.00,0.00,518.77,207508.00,0.00,0.00,0.00),('1','180','934','230665',4440230,'2743','414',37604.27,37604.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','230747',4441837,'2743','414',37604.27,37956.87,0.00,0.00,352.60,191818.40,0.00,0.00,0.00),('1','180','934','230839',4443081,'2743','414',37956.87,38064.97,0.00,0.00,108.10,63130.40,0.00,0.00,0.00),('1','180','934','231180',4448959,'2743','414',38064.97,39017.31,0.00,0.00,952.34,515511.56,0.00,0.00,0.00),('1','180','934','231569',4455271,'2743','414',39017.31,39232.16,0.00,0.00,214.85,120302.40,0.00,0.00,0.00),('1','180','934','231678',4456957,'2743','414',39232.16,39612.07,0.00,0.00,379.91,209177.44,0.00,0.00,0.00),('1','180','934','231941',4461924,'2743','414',39612.07,39848.46,0.00,0.00,236.39,131001.76,0.00,0.00,0.00),('1','180','934','232228',4467173,'2743','414',39848.46,40023.84,0.00,0.00,175.38,100071.92,0.00,0.00,0.00),('1','180','934','232436',4470718,'2743','414',40023.84,40781.24,0.00,0.00,757.40,409186.60,0.00,0.00,0.00),('1','180','934','232686',4475439,'2743','414',40781.24,41719.94,0.00,0.00,938.70,504584.80,0.00,0.00,0.00),('1','180','934','232993',4480864,'2743','414',41719.94,42578.94,0.00,0.00,859.00,462881.00,0.00,0.00,0.00),('1','180','934','233302',4486688,'2743','414',42578.94,42968.34,0.00,0.00,389.40,210724.60,0.00,0.00,0.00),('1','180','934','233328',4487087,'2743','414',42968.34,42968.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','233460',4489188,'2743','414',42968.34,43171.84,0.00,0.00,203.50,121584.00,0.00,0.00,0.00),('1','180','934','233721',4494006,'2743','414',43171.84,43410.04,0.00,0.00,238.20,142660.80,0.00,0.00,0.00),('1','180','934','233912',4497498,'2743','414',43410.04,44607.82,0.00,0.00,1197.78,706734.72,0.00,0.00,0.00),('1','180','934','234135',4501558,'2743','414',44607.82,45394.60,0.00,0.00,786.78,463950.72,0.00,0.00,0.00),('1','180','934','234383',4505930,'2743','414',45394.60,45594.60,0.00,0.00,200.00,117600.00,0.00,0.00,0.00),('1','180','934','235189',4520240,'2743','414',45594.60,45594.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','235451',4524921,'2743','414',45594.60,46025.60,0.00,0.00,431.00,255480.00,0.00,0.00,0.00),('1','180','934','235603',4527366,'2743','414',46025.60,46297.42,0.00,0.00,271.82,162415.68,0.00,0.00,0.00),('1','180','934','235891',4532393,'2743','414',46297.42,46454.52,0.00,0.00,157.10,94430.40,0.00,0.00,0.00),('1','180','934','236152',4537252,'2743','414',46454.52,46951.75,0.00,0.00,497.23,297095.52,0.00,0.00,0.00),('1','180','934','236303',4539802,'2743','414',46951.75,47907.56,0.00,0.00,955.81,566365.44,0.00,0.00,0.00),('1','180','934','236586',4544730,'2743','414',47907.56,48020.17,0.00,0.00,112.61,72070.40,0.00,0.00,0.00),('1','180','934','236762',4547552,'2743','414',48020.17,48351.45,0.00,0.00,331.28,204019.20,0.00,0.00,0.00),('1','180','934','236986',4551621,'2743','414',48351.45,48791.99,0.00,0.00,440.54,269721.60,0.00,0.00,0.00),('1','180','934','237191',4555157,'2743','414',48791.99,48954.43,0.00,0.00,162.44,102105.60,0.00,0.00,0.00),('1','180','934','237412',4559310,'2743','414',48954.43,49031.16,0.00,0.00,76.73,49107.20,0.00,0.00,0.00),('1','180','934','237650',4563396,'2743','414',49031.16,49146.46,0.00,0.00,115.30,73376.00,0.00,0.00,0.00),('1','180','934','237907',4567609,'2743','414',49146.46,49373.65,0.00,0.00,227.19,143641.60,0.00,0.00,0.00),('1','180','934','238156',4571625,'2743','414',49373.65,49607.12,0.00,0.00,233.47,146764.80,0.00,0.00,0.00),('1','180','934','238376',4575578,'2743','414',49607.12,50107.56,0.00,0.00,500.44,313881.60,0.00,0.00,0.00),('1','180','934','238650',4580101,'2743','414',50107.56,50165.72,0.00,0.00,58.16,37222.40,0.00,0.00,0.00),('1','180','934','238858',4583790,'2743','414',50165.72,50229.38,0.00,0.00,63.66,40742.40,0.00,0.00,0.00),('1','180','934','239093',4588008,'2743','414',50229.38,50398.67,0.00,0.00,169.29,106169.60,0.00,0.00,0.00),('1','180','934','240286',4608831,'2743','414',50398.67,50398.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','240296',4608955,'2743','414',50398.67,51347.72,0.00,0.00,949.05,599020.80,0.00,0.00,0.00),('1','180','934','240488',4611787,'2743','414',51347.72,51458.53,0.00,0.00,110.81,71391.36,0.00,0.00,0.00),('1','180','934','240724',4615428,'2743','414',51458.53,52121.27,0.00,0.00,662.74,418637.44,0.00,0.00,0.00),('1','180','934','240996',4620295,'2743','414',52121.27,52345.58,0.00,0.00,224.31,143247.36,0.00,0.00,0.00),('1','180','934','241258',4624971,'2743','414',52345.58,53002.09,0.00,0.00,656.51,415590.56,0.00,0.00,0.00),('1','180','934','241566',4630330,'2743','414',53002.09,53291.34,0.00,0.00,289.25,183924.00,0.00,0.00,0.00),('1','180','934','241789',4634221,'2743','414',53291.34,53343.93,0.00,0.00,52.59,34499.04,0.00,0.00,0.00),('1','180','934','242000',4637713,'2743','414',53343.93,53474.20,0.00,0.00,130.27,84157.12,0.00,0.00,0.00),('1','180','934','242253',4642257,'2743','414',53474.20,53581.72,0.00,0.00,107.52,70533.12,0.00,0.00,0.00),('1','180','934','242509',4646773,'2743','414',53581.72,53953.64,0.00,0.00,371.92,236647.52,0.00,0.00,0.00),('1','180','934','242649',4649502,'2743','414',53953.64,54033.93,0.00,0.00,80.29,52670.24,0.00,0.00,0.00),('1','180','934','242946',4654224,'2743','414',54033.93,54214.39,0.00,0.00,180.46,117081.76,0.00,0.00,0.00),('1','180','934','243160',4657958,'2743','414',54214.39,54346.45,0.00,0.00,132.06,85331.36,0.00,0.00,0.00),('1','180','934','243387',4662102,'2743','414',54346.45,54529.14,0.00,0.00,182.69,117244.64,0.00,0.00,0.00),('1','180','934','243668',4666898,'2743','414',54529.14,54889.22,0.00,0.00,360.08,228828.48,0.00,0.00,0.00),('1','180','934','243894',4670955,'2743','414',54889.22,54979.94,0.00,0.00,90.72,59512.32,0.00,0.00,0.00),('1','180','934','244126',4674904,'2743','414',54979.94,55178.12,0.00,0.00,198.18,126990.08,0.00,0.00,0.00),('1','180','934','244375',4679229,'2743','414',55178.12,55303.17,0.00,0.00,125.05,79172.80,0.00,0.00,0.00),('1','180','934','245005',4689967,'2743','414',55303.17,55303.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','245008',4689978,'2743','414',55303.17,55383.41,0.00,0.00,80.24,50517.76,0.00,0.00,0.00),('1','180','934','245247',4694246,'2743','414',55383.41,55617.83,0.00,0.00,234.42,143494.08,0.00,0.00,0.00),('1','180','934','245465',4698040,'2743','414',55617.83,55617.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','245467',4698075,'2743','414',55617.83,55706.46,0.00,0.00,88.63,54105.12,0.00,0.00,0.00),('1','180','934','245708',4702198,'2743','414',55706.46,55929.77,0.00,0.00,223.31,135361.44,0.00,0.00,0.00),('1','180','934','245966',4706177,'2743','414',55929.77,56179.34,0.00,0.00,249.57,143707.12,0.00,0.00,0.00),('1','180','934','246207',4710305,'2743','414',56179.34,56297.21,0.00,0.00,117.87,69939.92,0.00,0.00,0.00),('1','180','934','246468',4714691,'2743','414',56297.21,56446.95,0.00,0.00,149.74,89571.84,0.00,0.00,0.00),('1','180','934','246707',4718830,'2743','414',56446.95,56569.99,0.00,0.00,123.04,75792.64,0.00,0.00,0.00),('1','180','934','246959',4723274,'2743','414',56569.99,57008.10,0.00,0.00,438.11,255707.76,0.00,0.00,0.00),('1','180','934','247193',4727180,'2743','414',57008.10,57194.60,0.00,0.00,186.50,109824.00,0.00,0.00,0.00),('1','180','934','247445',4731709,'2743','414',57194.60,57298.84,0.00,0.00,104.24,61543.84,0.00,0.00,0.00),('1','180','934','247749',4736997,'2743','414',57298.84,57586.52,0.00,0.00,287.68,169574.88,0.00,0.00,0.00),('1','180','934','247985',4740867,'2743','414',57586.52,57631.51,0.00,0.00,44.99,27713.84,0.00,0.00,0.00),('1','180','934','248232',4745104,'2743','414',57631.51,57766.26,0.00,0.00,134.75,80338.00,0.00,0.00,0.00),('1','180','934','248501',4749709,'2743','414',57766.26,57849.10,0.00,0.00,82.84,51029.44,0.00,0.00,0.00),('1','180','934','248728',4753531,'2743','414',57849.10,58033.64,0.00,0.00,184.54,109076.64,0.00,0.00,0.00),('1','180','934','248903',4756346,'2743','414',58033.64,58240.14,0.00,0.00,206.50,119260.00,0.00,0.00,0.00),('1','180','934','249125',4759984,'2743','414',58240.14,58374.56,0.00,0.00,134.42,78652.00,0.00,0.00,0.00),('1','180','934','249370',4764236,'2743','414',58374.56,58597.26,0.00,0.00,222.70,128980.00,0.00,0.00,0.00),('1','180','934','249623',4768465,'2743','414',58597.26,58752.86,0.00,0.00,155.60,90960.00,0.00,0.00,0.00),('1','180','934','249889',4772973,'2743','414',58752.86,58927.00,0.00,0.00,174.14,99684.00,0.00,0.00,0.00),('1','180','934','250161',4777583,'2743','414',58927.00,59294.52,0.00,0.00,367.52,209940.40,0.00,0.00,0.00),('1','180','934','250371',4781045,'2743','414',59294.52,59454.02,0.00,0.00,159.50,91700.00,0.00,0.00,0.00),('1','180','934','250610',4784989,'2743','414',59454.02,59650.19,0.00,0.00,196.17,111062.00,0.00,0.00,0.00),('1','180','934','250865',4789637,'2743','414',59650.19,59758.89,0.00,0.00,108.70,62900.00,0.00,0.00,0.00),('1','180','934','251071',4793184,'2743','414',59758.89,59996.06,0.00,0.00,237.17,135662.00,0.00,0.00,0.00),('1','180','934','251337',4797923,'2743','414',59996.06,60165.73,0.00,0.00,169.67,95882.00,0.00,0.00,0.00),('1','180','934','252183',4812779,'2743','414',60165.73,60165.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','252326',4815000,'2743','414',60165.73,60360.80,0.00,0.00,195.07,112402.00,0.00,0.00,0.00),('1','180','934','252531',4818781,'2743','414',60360.80,60430.53,0.00,0.00,69.73,41838.00,0.00,0.00,0.00),('1','180','934','252742',4822406,'2743','414',60430.53,60699.93,0.00,0.00,269.40,153640.00,0.00,0.00,0.00),('1','180','934','253004',4826517,'2743','414',60699.93,60772.79,0.00,0.00,72.86,43716.00,0.00,0.00,0.00),('1','180','934','253314',4831867,'2743','414',60772.79,61115.59,0.00,0.00,342.80,194480.00,0.00,0.00,0.00),('1','180','934','253496',4834944,'2743','414',61115.59,61184.93,0.00,0.00,69.34,41604.00,0.00,0.00,0.00),('1','180','934','253698',4838646,'2743','414',61184.93,61368.59,0.00,0.00,183.66,105476.00,0.00,0.00,0.00),('1','180','934','253978',4843260,'2743','414',61368.59,61513.92,0.00,0.00,145.33,87198.00,0.00,0.00,0.00),('1','180','934','254183',4847283,'2743','414',61513.92,61727.60,0.00,0.00,213.68,123568.00,0.00,0.00,0.00),('1','180','934','254437',4851607,'2743','414',61727.60,61877.76,0.00,0.00,150.16,90096.00,0.00,0.00,0.00),('1','180','934','254690',4856008,'2743','414',61877.76,62063.26,0.00,0.00,185.50,106900.00,0.00,0.00,0.00),('1','180','934','254936',4860206,'2743','414',62063.26,62337.10,0.00,0.00,273.84,159664.00,0.00,0.00,0.00),('1','180','934','255201',4864551,'2743','414',62337.10,63255.76,0.00,0.00,918.66,517196.00,0.00,0.00,0.00),('1','180','934','255458',4869110,'2743','414',63255.76,63842.59,0.00,0.00,586.83,333058.00,0.00,0.00,0.00),('1','180','934','255709',4873228,'2743','414',63842.59,64200.76,0.00,0.00,358.17,205382.00,0.00,0.00,0.00),('1','180','934','255934',4876949,'2743','414',64200.76,64534.75,0.00,0.00,333.99,194394.00,0.00,0.00,0.00),('1','180','934','256220',4881280,'2743','414',64534.75,64656.09,0.00,0.00,121.34,72804.00,0.00,0.00,0.00),('1','180','934','256502',4886247,'2743','414',64656.09,64923.42,0.00,0.00,267.33,157998.00,0.00,0.00,0.00),('1','180','934','256746',4890152,'2743','414',64923.42,65157.77,0.00,0.00,234.35,135810.00,0.00,0.00,0.00),('1','180','934','256747',4890153,'2743','414',65157.77,65157.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256748',4890154,'2743','414',65157.77,65557.44,0.00,0.00,399.67,228042.00,0.00,0.00,0.00),('1','180','934','256749',4890155,'2743','414',65557.44,65664.46,0.00,0.00,107.02,64212.00,0.00,0.00,0.00),('1','180','934','256750',4890156,'2743','414',65664.46,66041.96,0.00,0.00,377.50,216500.00,0.00,0.00,0.00),('1','180','934','256751',4890157,'2743','414',66041.96,66237.46,0.00,0.00,195.50,117300.00,0.00,0.00,0.00),('1','180','934','256752',4890158,'2743','414',66237.46,66306.13,0.00,0.00,68.67,41202.00,0.00,0.00,0.00),('1','180','934','256753',4890159,'2743','414',66306.13,66377.63,0.00,0.00,71.50,42900.00,0.00,0.00,0.00),('1','180','934','256754',4890160,'2743','414',66377.63,66448.28,0.00,0.00,70.65,42390.00,0.00,0.00,0.00),('1','180','934','256755',4890161,'2743','414',66448.28,66598.78,0.00,0.00,150.50,88300.00,0.00,0.00,0.00),('1','180','934','256756',4890162,'2743','414',66598.78,66669.96,0.00,0.00,71.18,42708.00,0.00,0.00,0.00),('1','180','934','256757',4890163,'2743','414',70.40,70.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256757',4890164,'2744','414',219.99,356.31,0.00,0.00,136.32,81792.00,0.00,0.00,0.00),('1','180','934','256759',4890166,'2743','414',70.40,190.40,0.00,0.00,120.00,67200.00,0.00,0.00,0.00),('1','180','934','256759',4890167,'2744','414',356.31,452.64,0.00,0.00,96.33,57798.00,0.00,0.00,0.00),('1','180','934','256760',4890168,'2743','414',190.40,190.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256760',4890169,'2744','414',452.64,553.51,0.00,0.00,100.87,60522.00,0.00,0.00,0.00),('1','180','934','256761',4890170,'2743','414',190.40,255.40,0.00,0.00,65.00,35360.00,0.00,0.00,0.00),('1','180','934','256761',4890171,'2744','414',553.51,600.35,0.00,0.00,46.84,26605.12,0.00,0.00,0.00),('1','180','934','256762',4890172,'2743','414',255.40,375.40,0.00,0.00,120.00,65280.00,0.00,0.00,0.00),('1','180','934','256762',4890173,'2744','414',600.35,660.49,0.00,0.00,60.14,34159.52,0.00,0.00,0.00),('1','180','934','256763',4890174,'2743','414',375.40,375.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256763',4890175,'2744','414',660.49,720.80,0.00,0.00,60.31,34256.08,0.00,0.00,0.00),('1','180','934','256764',4890176,'2743','414',375.40,375.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256764',4890177,'2744','414',720.80,786.93,0.00,0.00,66.13,37561.84,0.00,0.00,0.00),('1','180','934','256765',4890178,'2743','414',375.40,375.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256765',4890179,'2744','414',786.93,828.59,0.00,0.00,41.66,23662.88,0.00,0.00,0.00),('1','180','934','256766',4890180,'2743','414',375.40,375.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256766',4890181,'2744','414',828.59,888.04,0.00,0.00,59.45,33767.60,0.00,0.00,0.00),('1','180','934','256767',4890182,'2743','414',375.40,375.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256767',4890183,'2744','414',888.04,992.90,0.00,0.00,104.86,59560.48,0.00,0.00,0.00),('1','180','934','256768',4890184,'2743','414',375.40,375.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256768',4890185,'2744','414',992.90,1084.28,0.00,0.00,91.38,51903.84,0.00,0.00,0.00),('1','180','934','256769',4890186,'2743','414',375.40,615.40,0.00,0.00,240.00,130560.00,0.00,0.00,0.00),('1','180','934','256769',4890187,'2744','414',1084.28,1122.97,0.00,0.00,38.69,21975.92,0.00,0.00,0.00),('1','180','934','256770',4890188,'2743','414',615.40,615.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256770',4890189,'2744','414',1122.97,1223.73,0.00,0.00,100.76,57231.68,0.00,0.00,0.00),('1','180','934','256771',4890190,'2743','414',615.40,615.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256771',4890191,'2744','414',1223.73,1354.29,0.00,0.00,130.56,74158.08,0.00,0.00,0.00),('1','180','934','256772',4890192,'2743','414',615.40,675.40,0.00,0.00,60.00,32640.00,0.00,0.00,0.00),('1','180','934','256772',4890193,'2744','414',1354.29,1385.84,0.00,0.00,31.55,17920.40,0.00,0.00,0.00),('1','180','934','256773',4890194,'2743','414',675.40,775.40,0.00,0.00,100.00,54400.00,0.00,0.00,0.00),('1','180','934','256773',4890195,'2744','414',1385.84,1484.86,0.00,0.00,99.02,56243.36,0.00,0.00,0.00),('1','180','934','256774',4890196,'2743','414',775.40,883.40,0.00,0.00,108.00,58752.00,0.00,0.00,0.00),('1','180','934','256774',4890197,'2744','414',1484.86,1578.97,0.00,0.00,94.11,53454.48,0.00,0.00,0.00),('1','180','934','256775',4890198,'2743','414',883.40,993.40,0.00,0.00,110.00,59840.00,0.00,0.00,0.00),('1','180','934','256775',4890199,'2744','414',1578.97,1691.85,0.00,0.00,112.88,64115.84,0.00,0.00,0.00),('1','180','934','256776',4890200,'2743','414',993.40,993.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256776',4890201,'2744','414',1691.85,1761.51,0.00,0.00,69.66,39566.88,0.00,0.00,0.00),('1','180','934','256777',4890202,'2743','414',993.40,993.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256777',4890203,'2744','414',1761.51,1828.85,0.00,0.00,67.34,38249.12,0.00,0.00,0.00),('1','180','934','256778',4890204,'2743','414',993.40,993.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256778',4890205,'2744','414',1828.85,1953.94,0.00,0.00,125.09,71051.12,0.00,0.00,0.00),('1','180','934','256779',4890206,'2743','414',993.40,1043.40,0.00,0.00,50.00,27200.00,0.00,0.00,0.00),('1','180','934','256779',4890207,'2744','414',1953.94,2021.59,0.00,0.00,67.65,38425.20,0.00,0.00,0.00),('1','180','934','256780',4890208,'2743','414',1043.40,1243.40,0.00,0.00,200.00,108800.00,0.00,0.00,0.00),('1','180','934','256780',4890209,'2744','414',2021.59,2172.95,0.00,0.00,151.36,85972.48,0.00,0.00,0.00),('1','180','934','256781',4890210,'2743','414',1243.40,1243.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256781',4890211,'2744','414',2172.95,2286.56,0.00,0.00,113.61,64530.48,0.00,0.00,0.00),('1','180','934','256782',4890212,'2743','414',1243.40,1303.40,0.00,0.00,60.00,32640.00,0.00,0.00,0.00),('1','180','934','256782',4890213,'2744','414',2286.56,2413.65,0.00,0.00,127.09,72187.12,0.00,0.00,0.00),('1','180','934','256783',4890214,'2743','414',1303.40,1378.40,0.00,0.00,75.00,40800.00,0.00,0.00,0.00),('1','180','934','256783',4890215,'2744','414',2413.65,2499.64,0.00,0.00,85.99,48842.32,0.00,0.00,0.00),('1','180','934','256784',4890216,'2743','414',1378.40,1378.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256784',4890217,'2744','414',2499.64,2524.79,0.00,0.00,25.15,17102.00,0.00,0.00,0.00),('1','180','934','256785',4890218,'2743','414',1378.40,1378.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256785',4890219,'2744','414',2524.79,2605.41,0.00,0.00,80.62,54821.60,0.00,0.00,0.00),('1','180','934','256786',4890220,'2743','414',1378.40,1378.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256786',4890221,'2744','414',2605.41,2683.29,0.00,0.00,77.88,52958.40,0.00,0.00,0.00),('1','180','934','256787',4890222,'2743','414',1378.40,1378.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256787',4890223,'2744','414',2683.29,2747.76,0.00,0.00,64.47,43839.60,0.00,0.00,0.00),('1','180','934','256788',4890224,'2743','414',1378.40,1378.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256788',4890225,'2744','414',2747.76,2842.09,0.00,0.00,94.33,64144.40,0.00,0.00,0.00),('1','180','934','256789',4890226,'2743','414',1378.40,1378.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256789',4890227,'2744','414',2842.09,2918.73,0.00,0.00,76.64,52115.20,0.00,0.00,0.00),('1','180','934','256790',4890228,'2743','414',1378.40,1578.40,0.00,0.00,200.00,128000.00,0.00,0.00,0.00),('1','180','934','256790',4890229,'2744','414',2918.73,2999.74,0.00,0.00,81.01,55086.80,0.00,0.00,0.00),('1','180','934','256791',4890230,'2743','414',1578.40,1638.40,0.00,0.00,60.00,38400.00,0.00,0.00,0.00),('1','180','934','256791',4890231,'2744','414',2999.74,3049.73,0.00,0.00,49.99,33993.20,0.00,0.00,0.00),('1','180','934','256792',4890232,'2743','414',1638.40,1638.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256792',4890233,'2744','414',3049.73,3127.98,0.00,0.00,78.25,53210.00,0.00,0.00,0.00),('1','180','934','256793',4890234,'2743','414',1638.40,1638.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256793',4890235,'2744','414',3127.98,3199.25,0.00,0.00,71.27,48463.60,0.00,0.00,0.00),('1','180','934','256794',4890236,'2743','414',1638.40,1638.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256794',4890237,'2744','414',3199.25,3272.89,0.00,0.00,73.64,50075.20,0.00,0.00,0.00),('1','180','934','256795',4890238,'2743','414',1638.40,1638.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256795',4890239,'2744','414',3272.89,3358.13,0.00,0.00,85.24,57963.20,0.00,0.00,0.00),('1','180','934','256796',4890240,'2743','414',1638.40,1748.40,0.00,0.00,110.00,70620.00,0.00,0.00,0.00),('1','180','934','256796',4890241,'2744','414',3358.13,3448.68,0.00,0.00,90.55,61574.00,0.00,0.00,0.00),('1','180','934','256797',4890242,'2743','414',1748.40,1908.40,0.00,0.00,160.00,102720.00,0.00,0.00,0.00),('1','180','934','256797',4890243,'2744','414',3448.68,3573.53,0.00,0.00,124.85,84898.00,0.00,0.00,0.00),('1','180','934','256798',4890244,'2743','414',1908.40,1908.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256798',4890245,'2744','414',3573.53,3746.84,0.00,0.00,173.31,117850.80,0.00,0.00,0.00),('1','180','934','256799',4890246,'2743','414',1908.40,2138.40,0.00,0.00,230.00,142600.00,0.00,0.00,0.00),('1','180','934','256799',4890247,'2744','414',3746.84,3987.15,0.00,0.00,240.31,156201.50,0.00,0.00,0.00),('1','180','934','256800',4890248,'2743','414',2138.40,2350.90,0.00,0.00,212.50,132125.00,0.00,0.00,0.00),('1','180','934','256800',4890249,'2744','414',3987.15,4295.67,0.00,0.00,308.52,197538.00,0.00,0.00,0.00),('1','180','934','256801',4890250,'2743','414',2350.90,2600.90,0.00,0.00,250.00,155000.00,0.00,0.00,0.00),('1','180','934','256801',4890251,'2744','414',4295.67,4449.95,0.00,0.00,154.28,100282.00,0.00,0.00,0.00),('1','180','934','256802',4890252,'2743','414',2600.90,2780.90,0.00,0.00,180.00,111600.00,0.00,0.00,0.00),('1','180','934','256802',4890253,'2744','414',4449.95,4608.51,0.00,0.00,158.56,103064.00,0.00,0.00,0.00),('1','180','934','256803',4890254,'2743','414',2780.90,3010.90,0.00,0.00,230.00,142600.00,0.00,0.00,0.00),('1','180','934','256803',4890255,'2744','414',4608.51,4730.75,0.00,0.00,122.24,79456.00,0.00,0.00,0.00),('1','180','934','256804',4890256,'2743','414',3010.90,3200.90,0.00,0.00,190.00,117800.00,0.00,0.00,0.00),('1','180','934','256804',4890257,'2744','414',4730.75,4848.28,0.00,0.00,117.53,76394.50,0.00,0.00,0.00),('1','180','934','256805',4890258,'2743','414',3200.90,3260.90,0.00,0.00,60.00,37200.00,0.00,0.00,0.00),('1','180','934','256805',4890259,'2744','414',4848.28,4897.59,0.00,0.00,49.31,32051.50,0.00,0.00,0.00),('1','180','934','256806',4890260,'2743','414',3260.90,3420.90,0.00,0.00,160.00,99200.00,0.00,0.00,0.00),('1','180','934','256806',4890261,'2744','414',4897.59,4926.29,0.00,0.00,28.70,18655.00,0.00,0.00,0.00),('1','180','934','256807',4890262,'2743','414',3420.90,3420.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256807',4890263,'2744','414',4926.29,4963.59,0.00,0.00,37.30,24245.00,0.00,0.00,0.00),('1','180','934','256808',4890264,'2743','414',3420.90,3570.90,0.00,0.00,150.00,93000.00,0.00,0.00,0.00),('1','180','934','256808',4890265,'2744','414',4963.59,5017.36,0.00,0.00,53.77,34950.50,0.00,0.00,0.00),('1','180','934','256809',4890266,'2743','414',3570.90,3570.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256809',4890267,'2744','414',5017.36,5017.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256810',4890268,'2743','414',3570.90,3740.90,0.00,0.00,170.00,105400.00,0.00,0.00,0.00),('1','180','934','256810',4890269,'2744','414',5017.36,5087.33,0.00,0.00,69.97,45480.50,0.00,0.00,0.00),('1','180','934','256811',4890270,'2743','414',3740.90,3740.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256811',4890271,'2744','414',5087.33,5162.13,0.00,0.00,74.80,48620.00,0.00,0.00,0.00),('1','180','934','256812',4890272,'2743','414',3740.90,3740.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256812',4890273,'2744','414',5162.13,5232.94,0.00,0.00,70.81,46026.50,0.00,0.00,0.00),('1','180','934','256813',4890274,'2743','414',3740.90,3850.90,0.00,0.00,110.00,68200.00,0.00,0.00,0.00),('1','180','934','256813',4890275,'2744','414',5232.94,5289.87,0.00,0.00,56.93,37004.50,0.00,0.00,0.00),('1','180','934','256814',4890276,'2743','414',3850.90,3850.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256814',4890277,'2744','414',5289.87,5337.18,0.00,0.00,47.31,30751.50,0.00,0.00,0.00),('1','180','934','256815',4890278,'2743','414',3850.90,3900.90,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','180','934','256815',4890279,'2744','414',5337.18,5411.12,0.00,0.00,73.94,48061.00,0.00,0.00,0.00),('1','180','934','256816',4890280,'2743','414',3900.90,3900.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256816',4890281,'2744','414',5411.12,5560.01,0.00,0.00,148.89,96778.50,0.00,0.00,0.00),('1','180','934','256817',4890282,'2743','414',3900.90,3900.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256817',4890283,'2744','414',5560.01,5635.06,0.00,0.00,75.05,48782.50,0.00,0.00,0.00),('1','180','934','256818',4890284,'2743','414',3900.90,3900.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256818',4890285,'2744','414',5635.06,5697.93,0.00,0.00,62.87,40865.50,0.00,0.00,0.00),('1','180','934','256819',4890286,'2743','414',3900.90,3900.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256819',4890287,'2744','414',5697.93,5776.86,0.00,0.00,78.93,51304.50,0.00,0.00,0.00),('1','180','934','256820',4890288,'2743','414',3900.90,3950.90,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','180','934','256820',4890289,'2744','414',5776.86,5920.45,0.00,0.00,143.59,93333.50,0.00,0.00,0.00),('1','180','934','256821',4890290,'2743','414',3950.90,3950.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256821',4890291,'2744','414',5920.45,5993.96,0.00,0.00,73.51,47781.50,0.00,0.00,0.00),('1','180','934','256822',4890292,'2743','414',3950.90,4010.90,0.00,0.00,60.00,37200.00,0.00,0.00,0.00),('1','180','934','256822',4890293,'2744','414',5993.96,6097.13,0.00,0.00,103.17,67060.50,0.00,0.00,0.00),('1','180','934','256823',4890294,'2743','414',4010.90,4190.90,0.00,0.00,180.00,111600.00,0.00,0.00,0.00),('1','180','934','256823',4890295,'2744','414',6097.13,6293.50,0.00,0.00,196.37,127640.50,0.00,0.00,0.00),('1','180','934','256824',4890296,'2743','414',4190.90,4190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256824',4890297,'2744','414',6293.50,6440.48,0.00,0.00,146.98,95537.00,0.00,0.00,0.00),('1','180','934','256825',4890298,'2743','414',4190.90,4190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256825',4890299,'2744','414',6440.48,6474.48,0.00,0.00,34.00,22100.00,0.00,0.00,0.00),('1','180','934','256826',4890300,'2743','414',4190.90,4190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256826',4890301,'2744','414',6474.48,6520.03,0.00,0.00,45.55,29607.50,0.00,0.00,0.00),('1','180','934','256827',4890302,'2743','414',4190.90,4240.90,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','180','934','256827',4890303,'2744','414',6520.03,6583.50,0.00,0.00,63.47,41255.50,0.00,0.00,0.00),('1','180','934','256828',4890304,'2743','414',4240.90,4240.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256828',4890305,'2744','414',6583.50,6664.73,0.00,0.00,81.23,52799.50,0.00,0.00,0.00),('1','180','934','256829',4890306,'2743','414',4240.90,4300.90,0.00,0.00,60.00,37200.00,0.00,0.00,0.00),('1','180','934','256829',4890307,'2744','414',6664.73,6714.27,0.00,0.00,49.54,32201.00,0.00,0.00,0.00),('1','180','934','256830',4890308,'2743','414',4300.90,4300.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256830',4890309,'2744','414',6714.27,6775.47,0.00,0.00,61.20,39780.00,0.00,0.00,0.00),('1','180','934','256831',4890310,'2743','414',4300.90,4500.90,0.00,0.00,200.00,124000.00,0.00,0.00,0.00),('1','180','934','256831',4890311,'2744','414',6775.47,6797.47,0.00,0.00,22.00,14300.00,0.00,0.00,0.00),('1','180','934','256832',4890312,'2743','414',4500.90,4550.90,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','180','934','256832',4890313,'2744','414',6797.47,6993.07,0.00,0.00,195.60,127140.00,0.00,0.00,0.00),('1','180','934','256833',4890314,'2743','414',4550.90,4600.90,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','180','934','256833',4890315,'2744','414',6993.07,7088.77,0.00,0.00,95.70,62205.00,0.00,0.00,0.00),('1','180','934','256834',4890316,'2743','414',4600.90,4780.90,0.00,0.00,180.00,111600.00,0.00,0.00,0.00),('1','180','934','256834',4890317,'2744','414',7088.77,7145.58,0.00,0.00,56.81,36926.50,0.00,0.00,0.00),('1','180','934','256835',4890318,'2743','414',4780.90,4780.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256835',4890319,'2744','414',7145.58,7256.20,0.00,0.00,110.62,71903.00,0.00,0.00,0.00),('1','180','934','256836',4890320,'2743','414',4780.90,4830.90,0.00,0.00,50.00,31000.00,0.00,0.00,0.00),('1','180','934','256836',4890321,'2744','414',7256.20,7306.36,0.00,0.00,50.16,32604.00,0.00,0.00,0.00),('1','180','934','256837',4890322,'2743','414',4830.90,5000.90,0.00,0.00,170.00,105400.00,0.00,0.00,0.00),('1','180','934','256837',4890323,'2744','414',7306.36,7375.49,0.00,0.00,69.13,44934.50,0.00,0.00,0.00),('1','180','934','256838',4890324,'2743','414',5000.90,5000.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256838',4890325,'2744','414',7375.49,7423.26,0.00,0.00,47.77,33247.92,0.00,0.00,0.00),('1','180','934','256839',4890326,'2743','414',5000.90,5050.90,0.00,0.00,50.00,32600.00,0.00,0.00,0.00),('1','180','934','256839',4890327,'2744','414',7423.26,7585.63,0.00,0.00,162.37,113009.52,0.00,0.00,0.00),('1','180','934','256840',4890328,'2743','414',5050.90,5050.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256840',4890329,'2744','414',7585.63,7646.63,0.00,0.00,61.00,42456.00,0.00,0.00,0.00),('1','180','934','256841',4890330,'2743','414',5050.90,5050.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256841',4890331,'2744','414',7646.63,7709.44,0.00,0.00,62.81,43715.76,0.00,0.00,0.00),('1','180','934','256842',4890332,'2743','414',5050.90,5210.90,0.00,0.00,160.00,104320.00,0.00,0.00,0.00),('1','180','934','256842',4890333,'2744','414',7709.44,7760.04,0.00,0.00,50.60,35217.60,0.00,0.00,0.00),('1','180','934','256843',4890334,'2743','414',5210.90,5260.90,0.00,0.00,50.00,32600.00,0.00,0.00,0.00),('1','180','934','256843',4890335,'2744','414',7760.04,7801.81,0.00,0.00,41.77,29071.92,0.00,0.00,0.00),('1','180','934','256844',4890336,'2743','414',5260.90,5310.90,0.00,0.00,50.00,32600.00,0.00,0.00,0.00),('1','180','934','256844',4890337,'2744','414',7801.81,7933.88,0.00,0.00,132.07,91920.72,0.00,0.00,0.00),('1','180','934','256845',4890338,'2743','414',5310.90,5310.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256845',4890339,'2744','414',7933.88,7987.26,0.00,0.00,53.38,37152.48,0.00,0.00,0.00),('1','180','934','256846',4890340,'2743','414',5310.90,5310.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256846',4890341,'2744','414',7987.26,8032.16,0.00,0.00,44.90,31250.40,0.00,0.00,0.00),('1','180','934','256847',4890342,'2743','414',5310.90,5370.90,0.00,0.00,60.00,39120.00,0.00,0.00,0.00),('1','180','934','256847',4890343,'2744','414',8032.16,8121.57,0.00,0.00,89.41,62229.36,0.00,0.00,0.00),('1','180','934','256848',4890344,'2743','414',5370.90,5370.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256848',4890345,'2744','414',8121.57,8180.64,0.00,0.00,59.07,43711.80,0.00,0.00,0.00),('1','180','934','256849',4890346,'2743','414',5370.90,5370.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256849',4890347,'2744','414',8180.64,8281.64,0.00,0.00,101.00,74740.00,0.00,0.00,0.00),('1','180','934','256850',4890348,'2743','414',5370.90,5370.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256850',4890349,'2744','414',8281.64,8355.27,0.00,0.00,73.63,54486.20,0.00,0.00,0.00),('1','180','934','256851',4890350,'2743','414',5370.90,5370.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256851',4890351,'2744','414',8355.27,8446.87,0.00,0.00,91.60,67784.00,0.00,0.00,0.00),('1','180','934','256852',4890352,'2743','414',5370.90,5500.90,0.00,0.00,130.00,90480.00,0.00,0.00,0.00),('1','180','934','256852',4890353,'2744','414',8446.87,8564.92,0.00,0.00,118.05,87357.00,0.00,0.00,0.00),('1','180','934','256853',4890354,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256853',4890355,'2744','414',8564.92,8664.70,0.00,0.00,99.78,73837.20,0.00,0.00,0.00),('1','180','934','256854',4890356,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256854',4890357,'2744','414',8664.70,8732.84,0.00,0.00,68.14,50423.60,0.00,0.00,0.00),('1','180','934','256855',4890358,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256855',4890359,'2744','414',8732.84,8830.47,0.00,0.00,97.63,72246.20,0.00,0.00,0.00),('1','180','934','256856',4890360,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256856',4890361,'2744','414',8830.47,8883.30,0.00,0.00,52.83,39094.20,0.00,0.00,0.00),('1','180','934','256857',4890362,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256857',4890363,'2744','414',8883.30,8975.36,0.00,0.00,92.06,68124.40,0.00,0.00,0.00),('1','180','934','256858',4890364,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256858',4890365,'2744','414',8975.36,9144.66,0.00,0.00,169.30,125282.00,0.00,0.00,0.00),('1','180','934','256859',4890366,'2743','414',5500.90,5500.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256859',4890367,'2744','414',9144.66,9271.48,0.00,0.00,126.82,93846.80,0.00,0.00,0.00),('1','180','934','256860',4890368,'2743','414',5500.90,5620.90,0.00,0.00,120.00,83520.00,0.00,0.00,0.00),('1','180','934','256860',4890369,'2744','414',9271.48,9444.23,0.00,0.00,172.75,127835.00,0.00,0.00,0.00),('1','180','934','256861',4890370,'2743','414',5620.90,5670.90,0.00,0.00,50.00,34800.00,0.00,0.00,0.00),('1','180','934','256861',4890371,'2744','414',9444.23,9558.17,0.00,0.00,113.94,84315.60,0.00,0.00,0.00),('1','180','934','256862',4890372,'2743','414',5670.90,5720.90,0.00,0.00,50.00,34800.00,0.00,0.00,0.00),('1','180','934','256862',4890373,'2744','414',9558.17,9683.32,0.00,0.00,125.15,92611.00,0.00,0.00,0.00),('1','180','934','256863',4890374,'2743','414',5720.90,5720.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256863',4890375,'2744','414',9683.32,9782.10,0.00,0.00,98.78,73097.20,0.00,0.00,0.00),('1','180','934','256864',4890376,'2743','414',5720.90,5720.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256864',4890377,'2744','414',9782.10,9874.87,0.00,0.00,92.77,71432.90,0.00,0.00,0.00),('1','180','934','256865',4890378,'2743','414',5720.90,5720.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256865',4890379,'2744','414',9874.87,10004.26,0.00,0.00,129.39,99630.30,0.00,0.00,0.00),('1','180','934','256866',4890380,'2743','414',5720.90,5720.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256866',4890381,'2744','414',10004.26,10069.61,0.00,0.00,65.35,50319.50,0.00,0.00,0.00),('1','180','934','256867',4890382,'2743','414',5720.90,5720.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256867',4890383,'2744','414',10069.61,10149.89,0.00,0.00,80.28,61815.60,0.00,0.00,0.00),('1','180','934','256868',4890384,'2743','414',5720.90,5820.90,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','180','934','256868',4890385,'2744','414',10149.89,10197.49,0.00,0.00,47.60,36652.00,0.00,0.00,0.00),('1','180','934','256869',4890386,'2743','414',5820.90,5870.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256869',4890387,'2744','414',10197.49,10305.97,0.00,0.00,108.48,83529.60,0.00,0.00,0.00),('1','180','934','256870',4890388,'2743','414',5870.90,5870.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256870',4890389,'2744','414',10305.97,10407.00,0.00,0.00,101.03,77793.10,0.00,0.00,0.00),('1','180','934','256871',4890390,'2743','414',5870.90,6070.90,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','180','934','256871',4890391,'2744','414',10407.00,10498.23,0.00,0.00,91.23,70247.10,0.00,0.00,0.00),('1','180','934','256872',4890392,'2743','414',6070.90,6190.90,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','180','934','256872',4890393,'2744','414',10498.23,10578.88,0.00,0.00,80.65,62100.50,0.00,0.00,0.00),('1','180','934','256873',4890394,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256873',4890395,'2744','414',10578.88,10636.02,0.00,0.00,57.14,43997.80,0.00,0.00,0.00),('1','180','934','256874',4890396,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256874',4890397,'2744','414',10636.02,10684.06,0.00,0.00,48.04,36990.80,0.00,0.00,0.00),('1','180','934','256875',4890398,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256875',4890399,'2744','414',10684.06,10684.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256876',4890400,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256876',4890401,'2744','414',10684.06,10684.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256877',4890402,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256877',4890403,'2744','414',10684.06,10684.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256878',4890404,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256878',4890405,'2744','414',10684.06,10734.08,0.00,0.00,50.02,38515.40,0.00,0.00,0.00),('1','180','934','256879',4890406,'2743','414',6190.90,6190.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256879',4890407,'2744','414',10734.08,10847.33,0.00,0.00,113.25,87202.50,0.00,0.00,0.00),('1','180','934','256880',4890408,'2743','414',6190.90,6240.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256880',4890409,'2744','414',10847.33,10912.63,0.00,0.00,65.30,50281.00,0.00,0.00,0.00),('1','180','934','256881',4890410,'2743','414',6240.90,6290.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256881',4890411,'2744','414',10912.63,10958.71,0.00,0.00,46.08,35481.60,0.00,0.00,0.00),('1','180','934','256882',4890412,'2743','414',6290.90,6290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256882',4890413,'2744','414',10958.71,10999.06,0.00,0.00,40.35,31069.50,0.00,0.00,0.00),('1','180','934','256883',4890414,'2743','414',6290.90,6290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256883',4890415,'2744','414',10999.06,11127.92,0.00,0.00,128.86,99222.20,0.00,0.00,0.00),('1','180','934','256884',4890416,'2743','414',6290.90,6290.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256884',4890417,'2744','414',11127.92,11249.13,0.00,0.00,121.21,93331.70,0.00,0.00,0.00),('1','180','934','256885',4890418,'2743','414',6290.90,6350.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256885',4890419,'2744','414',11249.13,11431.63,0.00,0.00,182.50,140525.00,0.00,0.00,0.00),('1','180','934','256886',4890420,'2743','414',6350.90,6350.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256886',4890421,'2744','414',11431.63,11501.17,0.00,0.00,69.54,53545.80,0.00,0.00,0.00),('1','180','934','256887',4890422,'2743','414',6350.90,6350.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256887',4890423,'2744','414',11501.17,11586.91,0.00,0.00,85.74,66019.80,0.00,0.00,0.00),('1','180','934','256888',4890424,'2743','414',6350.90,6470.90,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','180','934','256888',4890425,'2744','414',11586.91,11672.76,0.00,0.00,85.85,66104.50,0.00,0.00,0.00),('1','180','934','256889',4890426,'2743','414',6470.90,6470.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256889',4890427,'2744','414',11672.76,11733.00,0.00,0.00,60.24,46384.80,0.00,0.00,0.00),('1','180','934','256890',4890428,'2743','414',6470.90,6530.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256890',4890429,'2744','414',11733.00,11900.56,0.00,0.00,167.56,129021.20,0.00,0.00,0.00),('1','180','934','256891',4890430,'2743','414',6530.90,6840.90,0.00,0.00,310.00,223200.00,0.00,0.00,0.00),('1','180','934','256891',4890431,'2744','414',11900.56,12049.15,0.00,0.00,148.59,114414.30,0.00,0.00,0.00),('1','180','934','256892',4890432,'2743','414',6840.90,6840.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256892',4890433,'2744','414',12049.15,12099.65,0.00,0.00,50.50,38885.00,0.00,0.00,0.00),('1','180','934','256893',4890434,'2743','414',6840.90,6900.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256893',4890435,'2744','414',12099.65,12164.18,0.00,0.00,64.53,49688.10,0.00,0.00,0.00),('1','180','934','256894',4890436,'2743','414',6900.90,7080.90,0.00,0.00,180.00,129600.00,0.00,0.00,0.00),('1','180','934','256894',4890437,'2744','414',12164.18,12245.38,0.00,0.00,81.20,62524.00,0.00,0.00,0.00),('1','180','934','256895',4890438,'2743','414',7080.90,7230.90,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','180','934','256895',4890439,'2744','414',12245.38,12284.49,0.00,0.00,39.11,30114.70,0.00,0.00,0.00),('1','180','934','256896',4890440,'2743','414',7230.90,7370.90,0.00,0.00,140.00,100800.00,0.00,0.00,0.00),('1','180','934','256896',4890441,'2744','414',12284.49,12389.50,0.00,0.00,105.01,80857.70,0.00,0.00,0.00),('1','180','934','256897',4890442,'2743','414',7370.90,7490.90,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','180','934','256897',4890443,'2744','414',12389.50,12419.61,0.00,0.00,30.11,23184.70,0.00,0.00,0.00),('1','180','934','256898',4890444,'2743','414',7490.90,7540.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256898',4890445,'2744','414',12419.61,12513.72,0.00,0.00,94.11,72464.70,0.00,0.00,0.00),('1','180','934','256899',4890446,'2743','414',7540.90,7660.90,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','180','934','256899',4890447,'2744','414',12513.72,12592.62,0.00,0.00,78.90,60753.00,0.00,0.00,0.00),('1','180','934','256900',4890448,'2743','414',7660.90,7780.90,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','180','934','256900',4890449,'2744','414',12592.62,12675.76,0.00,0.00,83.14,64017.80,0.00,0.00,0.00),('1','180','934','256901',4890450,'2743','414',7780.90,7960.90,0.00,0.00,180.00,129600.00,0.00,0.00,0.00),('1','180','934','256901',4890451,'2744','414',12675.76,12761.56,0.00,0.00,85.80,66066.00,0.00,0.00,0.00),('1','180','934','256902',4890452,'2743','414',7960.90,8030.90,0.00,0.00,70.00,50400.00,0.00,0.00,0.00),('1','180','934','256902',4890453,'2744','414',12761.56,12861.03,0.00,0.00,99.47,76591.90,0.00,0.00,0.00),('1','180','934','256903',4890454,'2743','414',8030.90,8030.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256903',4890455,'2744','414',12861.03,12926.63,0.00,0.00,65.60,50512.00,0.00,0.00,0.00),('1','180','934','256904',4890456,'2743','414',8030.90,8030.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256904',4890457,'2744','414',12926.63,12974.14,0.00,0.00,47.51,36582.70,0.00,0.00,0.00),('1','180','934','256905',4890458,'2743','414',8030.90,8140.90,0.00,0.00,110.00,79200.00,0.00,0.00,0.00),('1','180','934','256905',4890459,'2744','414',12974.14,13052.57,0.00,0.00,78.43,60391.10,0.00,0.00,0.00),('1','180','934','256906',4890460,'2743','414',8140.90,8315.90,0.00,0.00,175.00,126000.00,0.00,0.00,0.00),('1','180','934','256906',4890461,'2744','414',13052.57,13182.25,0.00,0.00,129.68,99853.60,0.00,0.00,0.00),('1','180','934','256907',4890462,'2743','414',8315.90,8485.90,0.00,0.00,170.00,122400.00,0.00,0.00,0.00),('1','180','934','256907',4890463,'2744','414',13182.25,13191.93,0.00,0.00,9.68,7453.60,0.00,0.00,0.00),('1','180','934','256908',4890464,'2743','414',8485.90,8485.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256908',4890465,'2744','414',13191.93,13191.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256909',4890466,'2743','414',8485.90,8545.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256909',4890467,'2744','414',13191.93,13233.26,0.00,0.00,41.33,31824.10,0.00,0.00,0.00),('1','180','934','256910',4890468,'2743','414',8545.90,8545.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256910',4890469,'2744','414',13233.26,13340.87,0.00,0.00,107.61,82859.70,0.00,0.00,0.00),('1','180','934','256911',4890470,'2743','414',8545.90,8545.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256911',4890471,'2744','414',13340.87,13471.41,0.00,0.00,130.54,100515.80,0.00,0.00,0.00),('1','180','934','256912',4890472,'2743','414',8545.90,8545.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256912',4890473,'2744','414',13471.41,13554.80,0.00,0.00,83.39,64210.30,0.00,0.00,0.00),('1','180','934','256913',4890474,'2743','414',8545.90,8545.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256913',4890475,'2744','414',13554.80,13625.54,0.00,0.00,70.74,54469.80,0.00,0.00,0.00),('1','180','934','256914',4890476,'2743','414',8545.90,8595.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256914',4890477,'2744','414',13625.54,13768.49,0.00,0.00,142.95,110071.50,0.00,0.00,0.00),('1','180','934','256915',4890478,'2743','414',8595.90,8655.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256915',4890479,'2744','414',13768.49,13840.73,0.00,0.00,72.24,55624.80,0.00,0.00,0.00),('1','180','934','256916',4890480,'2743','414',8655.90,8655.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256916',4890481,'2744','414',13840.73,13927.52,0.00,0.00,86.79,66828.30,0.00,0.00,0.00),('1','180','934','256917',4890482,'2743','414',8655.90,8655.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256917',4890483,'2744','414',13927.52,13995.49,0.00,0.00,67.97,52336.90,0.00,0.00,0.00),('1','180','934','256918',4890484,'2743','414',8655.90,8881.90,0.00,0.00,226.00,162720.00,0.00,0.00,0.00),('1','180','934','256918',4890485,'2744','414',13995.49,14140.21,0.00,0.00,144.72,111434.40,0.00,0.00,0.00),('1','180','934','256919',4890486,'2743','414',8881.90,8999.90,0.00,0.00,118.00,84960.00,0.00,0.00,0.00),('1','180','934','256919',4890487,'2744','414',14140.21,14374.66,0.00,0.00,234.45,177526.50,0.00,0.00,0.00),('1','180','934','256920',4890488,'2743','414',8999.90,8999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256920',4890489,'2744','414',14374.66,14490.27,0.00,0.00,115.61,89019.70,0.00,0.00,0.00),('1','180','934','256921',4890490,'2743','414',8999.90,9289.90,0.00,0.00,290.00,208800.00,0.00,0.00,0.00),('1','180','934','256921',4890491,'2744','414',14490.27,14565.31,0.00,0.00,75.04,57780.80,0.00,0.00,0.00),('1','180','934','256922',4890492,'2743','414',9289.90,9389.90,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','180','934','256922',4890493,'2744','414',14565.31,14682.10,0.00,0.00,116.79,89928.30,0.00,0.00,0.00),('1','180','934','256923',4890494,'2743','414',9389.90,9717.90,0.00,0.00,328.00,236160.00,0.00,0.00,0.00),('1','180','934','256923',4890495,'2744','414',14682.10,14745.23,0.00,0.00,63.13,48610.10,0.00,0.00,0.00),('1','180','934','256924',4890496,'2743','414',9717.90,9775.90,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','180','934','256924',4890497,'2744','414',14745.23,14867.25,0.00,0.00,122.02,93955.40,0.00,0.00,0.00),('1','180','934','256925',4890498,'2743','414',9775.90,9825.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256925',4890499,'2744','414',14867.25,14945.08,0.00,0.00,77.83,59929.10,0.00,0.00,0.00),('1','180','934','256926',4890500,'2743','414',9825.90,9885.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256926',4890501,'2744','414',14945.08,15042.42,0.00,0.00,97.34,74951.80,0.00,0.00,0.00),('1','180','934','256927',4890502,'2743','414',9885.90,10005.90,0.00,0.00,120.00,86400.00,0.00,0.00,0.00),('1','180','934','256927',4890503,'2744','414',15042.42,15153.38,0.00,0.00,110.96,85439.20,0.00,0.00,0.00),('1','180','934','256928',4890504,'2743','414',10005.90,10179.90,0.00,0.00,174.00,125280.00,0.00,0.00,0.00),('1','180','934','256928',4890505,'2744','414',15153.38,15285.53,0.00,0.00,132.15,101755.50,0.00,0.00,0.00),('1','180','934','256929',4890506,'2743','414',10179.90,10179.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256929',4890507,'2744','414',15285.53,15404.22,0.00,0.00,118.69,91391.30,0.00,0.00,0.00),('1','180','934','256930',4890508,'2743','414',10179.90,10179.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256930',4890509,'2744','414',15404.22,15573.49,0.00,0.00,169.27,130337.90,0.00,0.00,0.00),('1','180','934','256931',4890510,'2743','414',10179.90,10229.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256931',4890511,'2744','414',15573.49,15667.61,0.00,0.00,94.12,72472.40,0.00,0.00,0.00),('1','180','934','256932',4890512,'2743','414',10229.90,10229.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256932',4890513,'2744','414',15667.61,15789.45,0.00,0.00,121.84,93816.80,0.00,0.00,0.00),('1','180','934','256933',4890514,'2743','414',10229.90,10229.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256933',4890515,'2744','414',15789.45,15871.34,0.00,0.00,81.89,63055.30,0.00,0.00,0.00),('1','180','934','256934',4890516,'2743','414',10229.90,10279.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256934',4890517,'2744','414',15871.34,15953.51,0.00,0.00,82.17,63270.90,0.00,0.00,0.00),('1','180','934','256935',4890518,'2743','414',10279.90,10339.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256935',4890519,'2744','414',15953.51,16056.62,0.00,0.00,103.11,79394.70,0.00,0.00,0.00),('1','180','934','256936',4890520,'2743','414',10339.90,10509.90,0.00,0.00,170.00,122400.00,0.00,0.00,0.00),('1','180','934','256936',4890521,'2744','414',16056.62,16070.92,0.00,0.00,14.30,11011.00,0.00,0.00,0.00),('1','180','934','256937',4890522,'2743','414',10509.90,10509.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256937',4890523,'2744','414',16070.92,16070.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256938',4890524,'2743','414',10509.90,10509.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256938',4890525,'2744','414',16070.92,16114.07,0.00,0.00,43.15,33225.50,0.00,0.00,0.00),('1','180','934','256939',4890526,'2743','414',10509.90,10509.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256939',4890527,'2744','414',16114.07,16162.51,0.00,0.00,48.44,37298.80,0.00,0.00,0.00),('1','180','934','256940',4890528,'2743','414',10509.90,10567.90,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','180','934','256940',4890529,'2744','414',16162.51,16216.31,0.00,0.00,53.80,41426.00,0.00,0.00,0.00),('1','180','934','256941',4890530,'2743','414',10567.90,10567.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256941',4890531,'2744','414',16216.31,16295.61,0.00,0.00,79.30,61061.00,0.00,0.00,0.00),('1','180','934','256942',4890532,'2743','414',10567.90,10567.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256942',4890533,'2744','414',16295.61,16356.57,0.00,0.00,60.96,46939.20,0.00,0.00,0.00),('1','180','934','256943',4890534,'2743','414',10567.90,10567.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256943',4890535,'2744','414',16356.57,16416.59,0.00,0.00,60.02,46215.40,0.00,0.00,0.00),('1','180','934','256944',4890536,'2743','414',10567.90,10627.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256944',4890537,'2744','414',16416.59,16464.08,0.00,0.00,47.49,36567.30,0.00,0.00,0.00),('1','180','934','256945',4890538,'2743','414',10627.90,10687.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256945',4890539,'2744','414',16464.08,16586.17,0.00,0.00,122.09,94009.30,0.00,0.00,0.00),('1','180','934','256946',4890540,'2743','414',10687.90,10803.90,0.00,0.00,116.00,83520.00,0.00,0.00,0.00),('1','180','934','256946',4890541,'2744','414',16586.17,16658.58,0.00,0.00,72.41,55755.70,0.00,0.00,0.00),('1','180','934','256947',4890542,'2743','414',10803.90,10803.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256947',4890543,'2744','414',16658.58,16827.41,0.00,0.00,168.83,129999.10,0.00,0.00,0.00),('1','180','934','256948',4890544,'2743','414',10803.90,10803.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256948',4890545,'2744','414',16827.41,16892.39,0.00,0.00,64.98,50034.60,0.00,0.00,0.00),('1','180','934','256949',4890546,'2743','414',10803.90,10863.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256949',4890547,'2744','414',16892.39,16968.16,0.00,0.00,75.77,58342.90,0.00,0.00,0.00),('1','180','934','256950',4890548,'2743','414',10863.90,10913.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256950',4890549,'2744','414',16968.16,16986.02,0.00,0.00,17.86,13752.20,0.00,0.00,0.00),('1','180','934','256951',4890550,'2743','414',10913.90,10963.90,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','180','934','256951',4890551,'2744','414',16986.02,17051.10,0.00,0.00,65.08,50111.60,0.00,0.00,0.00),('1','180','934','256952',4890552,'2743','414',10963.90,11163.90,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','180','934','256952',4890553,'2744','414',17051.10,17097.30,0.00,0.00,46.20,35574.00,0.00,0.00,0.00),('1','180','934','256953',4890554,'2743','414',11163.90,11221.90,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','180','934','256953',4890555,'2744','414',17097.30,17147.45,0.00,0.00,50.15,38615.50,0.00,0.00,0.00),('1','180','934','256954',4890556,'2743','414',11221.90,11371.90,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','180','934','256954',4890557,'2744','414',17147.45,17213.30,0.00,0.00,65.85,50704.50,0.00,0.00,0.00),('1','180','934','256955',4890558,'2743','414',11371.90,11371.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256955',4890559,'2744','414',17213.30,17280.98,0.00,0.00,67.68,52113.60,0.00,0.00,0.00),('1','180','934','256956',4890560,'2743','414',11371.90,11371.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256956',4890561,'2744','414',17280.98,17321.89,0.00,0.00,40.91,31500.70,0.00,0.00,0.00),('1','180','934','256957',4890562,'2743','414',11371.90,11431.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256957',4890563,'2744','414',17321.89,17404.57,0.00,0.00,82.68,63663.60,0.00,0.00,0.00),('1','180','934','256958',4890564,'2743','414',11431.90,11489.90,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','180','934','256958',4890565,'2744','414',17404.57,17432.18,0.00,0.00,27.61,21259.70,0.00,0.00,0.00),('1','180','934','256959',4890566,'2743','414',11489.90,11667.90,0.00,0.00,178.00,128160.00,0.00,0.00,0.00),('1','180','934','256959',4890567,'2744','414',17432.18,17530.19,0.00,0.00,98.01,75467.70,0.00,0.00,0.00),('1','180','934','256960',4890568,'2743','414',11667.90,11725.90,0.00,0.00,58.00,41760.00,0.00,0.00,0.00),('1','180','934','256960',4890569,'2744','414',17530.19,17622.93,0.00,0.00,92.74,71409.80,0.00,0.00,0.00),('1','180','934','256961',4890570,'2743','414',11725.90,11885.90,0.00,0.00,160.00,115200.00,0.00,0.00,0.00),('1','180','934','256961',4890571,'2744','414',17622.93,17722.77,0.00,0.00,99.84,76876.80,0.00,0.00,0.00),('1','180','934','256962',4890572,'2743','414',11885.90,11885.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256962',4890573,'2744','414',17722.77,17832.31,0.00,0.00,109.54,84345.80,0.00,0.00,0.00),('1','180','934','256963',4890574,'2743','414',11885.90,11885.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256963',4890575,'2744','414',17832.31,17895.54,0.00,0.00,63.23,48687.10,0.00,0.00,0.00),('1','180','934','256964',4890576,'2743','414',11885.90,12051.90,0.00,0.00,166.00,119520.00,0.00,0.00,0.00),('1','180','934','256964',4890577,'2744','414',17895.54,17943.60,0.00,0.00,48.06,37006.20,0.00,0.00,0.00),('1','180','934','256965',4890578,'2743','414',12051.90,12111.90,0.00,0.00,60.00,43200.00,0.00,0.00,0.00),('1','180','934','256965',4890579,'2744','414',17943.60,18008.82,0.00,0.00,65.22,50219.40,0.00,0.00,0.00),('1','180','934','256966',4890580,'2743','414',12111.90,12111.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256966',4890581,'2744','414',18008.82,18100.16,0.00,0.00,91.34,70331.80,0.00,0.00,0.00),('1','180','934','256967',4890582,'2743','414',12111.90,12111.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256967',4890583,'2744','414',18100.16,18233.95,0.00,0.00,133.79,103018.30,0.00,0.00,0.00),('1','180','934','256968',4890584,'2743','414',12111.90,12111.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256968',4890585,'2744','414',18233.95,18321.30,0.00,0.00,87.35,67259.50,0.00,0.00,0.00),('1','180','934','256969',4890586,'2743','414',12111.90,12111.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256969',4890587,'2744','414',18321.30,18403.93,0.00,0.00,82.63,63625.10,0.00,0.00,0.00),('1','180','934','256970',4890588,'2743','414',12111.90,12227.90,0.00,0.00,116.00,83520.00,0.00,0.00,0.00),('1','180','934','256970',4890589,'2744','414',18403.93,18487.20,0.00,0.00,83.27,64117.90,0.00,0.00,0.00),('1','180','934','256971',4890590,'2743','414',12227.90,12227.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','180','934','256971',4890591,'2744','414',18487.20,18522.98,0.00,0.00,35.78,27550.60,0.00,0.00,0.00),('1','180','934','256972',4890592,'2743','414',12227.90,12337.90,0.00,0.00,110.00,79200.00,0.00,0.00,0.00),('1','180','934','256972',4890593,'2744','414',18522.98,18575.84,0.00,0.00,52.86,40702.20,0.00,0.00,0.00),('1','180','934','256973',4890594,'2743','414',12337.90,12637.90,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','180','934','256973',4890595,'2744','414',18575.84,18593.84,0.00,0.00,18.00,13860.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=727890 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','180','196061','414',309.50,344.00,0.00,18.50,6364.00,6364.00,0.00,570499),('1','180','196322','414',344.00,344.00,0.00,203.00,69832.00,65432.00,-4400.00,571150),('1','180','196472','414',344.00,344.00,0.00,435.30,149743.20,140943.20,-8800.00,571541),('1','180','196699','414',344.00,344.00,0.00,24.45,8410.80,8410.80,0.00,572122),('1','180','196916','414',344.00,344.00,0.00,6.00,2064.00,2064.00,0.00,572694),('1','180','197083','414',344.00,344.00,0.00,5.00,1720.00,1720.00,0.00,573126),('1','180','197299','414',344.00,344.00,0.00,515.50,177332.00,166332.00,-11000.00,573719),('1','180','197303','414',344.00,344.00,0.00,256.00,88064.00,82564.00,-5500.00,573727),('1','180','197535','414',344.00,344.00,0.00,523.30,180015.20,169081.20,-10934.00,574207),('1','180','197893','414',344.00,344.00,0.00,48.63,16728.72,16728.72,0.00,575171),('1','180','198135','414',344.00,344.00,0.00,528.50,181804.00,170804.00,-11000.00,575788),('1','180','198354','414',344.00,344.00,0.00,48.63,16728.72,16728.72,0.00,576364),('1','180','198577','414',344.00,344.00,0.00,31.81,10942.64,10942.64,0.00,576946),('1','180','198797','414',344.00,344.00,0.00,351.50,120916.00,114316.00,-6600.00,577475),('1','180','199005','414',344.00,344.00,0.00,186.50,64156.00,60526.00,-3630.00,578025),('1','180','199247','414',344.00,344.00,0.00,602.50,207260.00,195160.00,-12100.00,578630),('1','180','199467','414',344.00,344.00,0.00,33.81,11630.64,11630.64,0.00,579166),('1','180','199727','414',344.00,344.00,0.00,420.36,144603.84,136815.84,-7788.00,579800),('1','180','199892','414',344.00,344.00,0.00,26.00,8944.00,8504.00,-440.00,580212),('1','180','200624','414',344.00,344.00,0.00,163.00,56072.00,53036.00,-3036.00,582138),('1','180','200789','414',309.00,344.00,0.00,742.50,229432.50,241296.00,11863.50,582561),('1','180','200929','414',309.00,344.00,0.00,106.40,32877.60,36601.60,3724.00,582913),('1','180','201123','414',309.00,344.00,0.00,63.40,19590.60,21809.60,2219.00,583399),('1','180','201330','414',309.00,344.00,0.00,302.41,93444.69,99189.04,5744.35,583936),('1','180','201525','414',309.00,344.00,0.00,22.82,7051.38,7850.08,798.70,584438),('1','180','201792','414',309.00,344.00,0.00,328.24,101426.16,106314.56,4888.40,585153),('1','180','202043','414',309.00,344.00,0.00,214.91,66407.19,70299.04,3891.85,585819),('1','180','202250','414',309.00,344.00,0.00,17.00,5253.00,5848.00,595.00,586349),('1','180','202698','414',309.00,344.00,0.00,167.50,51757.50,55420.00,3662.50,587489),('1','180','202871','414',309.00,344.00,0.00,183.50,56701.50,60594.00,3892.50,587934),('1','180','203128','414',309.00,344.00,0.00,89.50,27655.50,29688.00,2032.50,588605),('1','180','203325','414',309.00,344.00,0.00,492.00,152028.00,158864.00,6836.00,589129),('1','180','203545','414',309.00,344.00,0.00,317.80,98200.20,103053.20,4853.00,589682),('1','180','203659','414',309.00,360.00,0.00,0.00,0.00,0.00,0.00,589991),('1','180','203807','414',309.00,360.00,0.00,60.44,18675.96,21758.40,3082.44,590367),('1','180','203985','414',309.00,360.00,0.00,101.28,31295.52,34180.80,2885.28,590812),('1','180','204210','414',309.00,360.00,0.00,123.08,38031.72,42028.80,3997.08,591406),('1','180','204417','414',309.00,360.00,0.00,89.28,27587.52,32140.80,4553.28,591942),('1','180','204675','414',309.00,360.00,0.00,154.26,47666.34,52733.60,5067.26,592602),('1','180','204881','414',309.00,360.00,0.00,48.00,14832.00,17280.00,2448.00,593091),('1','180','205093','414',309.00,360.00,0.00,114.20,35287.80,39432.00,4144.20,593641),('1','180','205329','414',309.00,360.00,0.00,188.88,58363.92,63292.80,4928.88,594260),('1','180','205506','414',309.00,360.00,0.00,59.00,18231.00,21240.00,3009.00,594699),('1','180','205758','414',309.00,360.00,0.00,506.00,156354.00,168636.00,12282.00,595360),('1','180','206043','414',318.00,360.00,0.00,295.72,94038.96,99431.20,5392.24,596103),('1','180','206190','414',318.00,360.00,0.00,163.73,52066.14,57262.80,5196.66,596474),('1','180','206415','414',318.00,360.00,0.00,40.28,12809.04,14500.80,1691.76,597044),('1','180','206615','414',318.00,360.00,0.00,72.36,23010.48,26049.60,3039.12,597552),('1','180','206927','414',318.00,360.00,0.00,303.78,96602.04,101492.80,4890.76,598371),('1','180','207100','414',318.00,360.00,0.00,100.28,31889.04,34420.80,2531.76,598812),('1','180','207349','414',318.00,360.00,0.00,62.08,19741.44,22348.80,2607.36,599454),('1','180','207533','414',318.00,360.00,0.00,263.00,83634.00,91432.00,7798.00,599933),('1','180','207772','414',318.00,380.00,0.00,225.30,71645.40,84114.00,12468.60,600535),('1','180','207968','414',318.00,380.00,0.00,177.76,56527.68,64798.80,8271.12,601041),('1','180','208152','414',318.00,380.00,0.00,128.00,40704.00,47140.00,6436.00,601503),('1','180','208369','414',318.00,380.00,0.00,259.39,82486.02,94168.20,11682.18,602066),('1','180','208580','414',318.00,380.00,0.00,72.65,23102.70,27607.00,4504.30,602602),('1','180','208827','414',318.00,380.00,0.00,126.89,40351.02,46718.20,6367.18,603225),('1','180','209106','414',318.00,380.00,0.00,254.00,80772.00,93770.00,12998.00,603940),('1','180','209296','414',318.00,400.00,0.00,448.50,142623.00,171480.00,28857.00,604426),('1','180','209494','414',318.00,400.00,0.00,131.75,41896.50,52700.00,10803.50,604935),('1','180','209704','414',318.00,400.00,0.00,584.75,185950.50,221276.00,35325.50,605475),('1','180','209974','414',318.00,400.00,0.00,62.96,20021.28,26443.20,6421.92,606179),('1','180','210199','414',318.00,420.00,0.00,125.88,40029.84,52869.60,12839.76,606756),('1','180','210387','414',318.00,420.00,0.00,237.02,75372.36,92632.40,17260.04,607240),('1','180','210634','414',318.00,420.00,0.00,194.54,61863.72,79502.80,17639.08,607899),('1','180','210908','414',318.00,420.00,0.00,147.15,46793.70,59523.00,12729.30,608617),('1','180','211134','414',318.00,420.00,0.00,19.50,6201.00,8190.00,1989.00,609199),('1','180','211269','414',318.00,420.00,0.00,0.00,0.00,0.00,0.00,609541),('1','180','211273','414',318.00,420.00,0.00,0.00,0.00,0.00,0.00,609552),('1','180','211277','414',318.00,420.00,0.00,0.00,0.00,0.00,0.00,609562),('1','180','211279','414',318.00,420.00,0.00,623.00,237986.00,248802.40,10816.40,609566),('1','180','211582','414',382.00,424.00,0.00,385.40,147222.80,159262.60,12039.80,610367),('1','180','211753','414',382.00,424.00,0.00,50.50,19291.00,21412.00,2121.00,610799),('1','180','211953','414',382.00,424.00,0.00,85.20,32546.40,36124.80,3578.40,611315),('1','180','212205','414',382.00,424.00,0.00,127.40,48666.80,52277.60,3610.80,611977),('1','180','212342','414',382.00,424.00,0.00,66.40,25364.80,28153.60,2788.80,612330),('1','180','212642','414',382.00,424.00,0.00,429.20,163954.40,171830.80,7876.40,613137),('1','180','212838','414',382.00,424.00,0.00,89.20,34074.40,37820.80,3746.40,613640),('1','180','212972','414',382.00,424.00,0.00,200.80,76705.60,81717.20,5011.60,613985),('1','180','213274','414',382.00,424.00,0.00,163.02,62273.64,69120.48,6846.84,614765),('1','180','213488','414',382.00,424.00,0.00,136.92,52303.44,56314.08,4010.64,615324),('1','180','213726','414',382.00,424.00,0.00,298.59,114061.38,119874.16,5812.78,615955),('1','180','213965','414',382.00,424.00,0.00,151.89,58021.98,62961.36,4939.38,616580),('1','180','214155','414',382.00,424.00,0.00,388.80,148521.60,158227.20,9705.60,617069),('1','180','214412','414',382.00,424.00,0.00,411.19,157074.58,167144.56,10069.98,617743),('1','180','214658','414',382.00,424.00,0.00,194.04,74123.28,80832.96,6709.68,618372),('1','180','214886','414',382.00,424.00,0.00,420.40,160592.80,170665.60,10072.80,618973),('1','180','215110','414',382.00,424.00,0.00,257.15,98231.30,106151.60,7920.30,619556),('1','180','215337','414',382.00,424.00,0.00,253.10,96684.20,103138.40,6454.20,620139),('1','180','215544','414',382.00,424.00,0.00,85.38,32615.16,36201.12,3585.96,620668),('1','180','215756','414',382.00,424.00,0.00,892.16,340805.12,359435.84,18630.72,621215),('1','180','215989','414',382.00,424.00,0.00,165.62,63266.84,68782.88,5516.04,621812),('1','180','216234','414',382.00,424.00,0.00,256.00,97792.00,105904.00,8112.00,622449),('1','180','216415','414',382.00,424.00,0.00,163.05,62285.10,67693.20,5408.10,622922),('1','180','217450','414',382.00,424.00,0.00,500.00,191000.00,200000.00,9000.00,625654),('1','180','217579','414',382.00,480.00,0.00,399.66,152670.12,177516.80,24846.68,625973),('1','180','217863','414',382.00,480.00,0.00,141.50,54053.00,63280.00,9227.00,626728),('1','180','218153','414',382.00,480.00,0.00,149.33,57044.06,71678.40,14634.34,627491),('1','180','218405','414',382.00,480.00,0.00,140.08,53510.56,65038.40,11527.84,628160),('1','180','218608','414',382.00,480.00,0.00,106.08,40522.56,48598.40,8075.84,628677),('1','180','218777','414',382.00,480.00,0.00,162.95,62246.90,75816.00,13569.10,629108),('1','180','219013','414',382.00,480.00,0.00,811.71,310073.22,359620.80,49547.58,629729),('1','180','219311','414',382.00,480.00,0.00,149.60,57147.20,71808.00,14660.80,630524),('1','180','219563','414',382.00,480.00,0.00,320.70,122507.40,144496.00,21988.60,631186),('1','180','220069','414',382.00,480.00,0.00,40.00,15280.00,17600.00,2320.00,632506),('1','180','221044','414',425.00,480.00,0.00,979.81,416419.25,435668.80,19249.55,635055),('1','180','221332','414',425.00,480.00,0.00,161.42,68603.50,73481.60,4878.10,635821),('1','180','221504','414',425.00,480.00,0.00,430.75,183068.75,192040.00,8971.25,636259),('1','180','221775','414',425.00,480.00,0.00,420.08,178534.00,186438.40,7904.40,636977),('1','180','221919','414',425.00,480.00,0.00,215.67,91659.75,98881.60,7221.85,637333),('1','180','222163','414',425.00,480.00,0.00,470.50,199962.50,210240.00,10277.50,637969),('1','180','222448','414',425.00,480.00,0.00,113.50,48237.50,54480.00,6242.50,638708),('1','180','222602','414',425.00,480.00,0.00,300.67,127784.75,136001.60,8216.85,639104),('1','180','222908','414',425.00,480.00,0.00,127.57,54217.25,61233.60,7016.35,639926),('1','180','223088','414',425.00,480.00,0.00,594.00,252450.00,265120.00,12670.00,640408),('1','180','223147','414',425.00,480.00,0.00,0.00,0.00,0.00,0.00,640561),('1','180','223300','414',425.00,480.00,0.00,353.50,150237.50,158720.00,8482.50,640910),('1','180','223508','414',425.00,480.00,0.00,123.06,52300.50,59068.80,6768.30,641436),('1','180','223751','414',425.00,480.00,0.00,542.30,230477.50,253356.00,22878.50,642065),('1','180','224015','414',425.00,480.00,0.00,66.00,28050.00,30492.00,2442.00,642750),('1','180','224960','414',425.00,480.00,0.00,829.10,378898.70,417314.00,38415.30,645204),('1','180','225139','414',457.00,540.00,0.00,972.06,444231.42,488912.40,44680.98,645658),('1','180','225426','414',457.00,540.00,0.00,1030.37,470879.09,518559.80,47680.71,646404),('1','180','225652','414',457.00,540.00,0.00,349.70,159812.90,176438.00,16625.10,646990),('1','180','225938','414',457.00,540.00,0.00,156.50,71520.50,82510.00,10989.50,647749),('1','180','226205','414',457.00,540.00,0.00,327.70,149758.90,165758.00,15999.10,648434),('1','180','226413','414',457.00,540.00,0.00,303.20,138562.40,155088.00,16525.60,648977),('1','180','226674','414',457.00,540.00,0.00,260.30,118957.10,133362.00,14404.90,649641),('1','180','226746','414',457.00,540.00,0.00,84.00,38388.00,45360.00,6972.00,649807),('1','180','227048','414',457.00,540.00,0.00,432.50,197652.50,216750.00,19097.50,650601),('1','180','227335','414',457.00,540.00,0.00,168.50,77004.50,86990.00,9985.50,651350),('1','180','227452','414',482.00,540.00,0.00,193.50,93267.00,102490.00,9223.00,651641),('1','180','227810','414',482.00,540.00,0.00,777.10,374562.20,391034.00,16471.80,652579),('1','180','228087','414',482.00,540.00,0.00,435.00,209670.00,220900.00,11230.00,653318),('1','180','228334','414',482.00,540.00,0.00,152.60,73553.20,80404.00,6850.80,653956),('1','180','228513','414',482.00,560.00,0.00,117.80,56779.60,65968.00,9188.40,654410),('1','180','228665','414',482.00,560.00,0.00,348.00,167736.00,185010.00,17274.00,654787),('1','180','228918','414',482.00,560.00,0.00,521.70,251459.40,273252.00,21792.60,655441),('1','180','229040','414',482.00,560.00,0.00,497.69,239886.58,260016.40,20129.82,655743),('1','180','229373','414',482.00,560.00,0.00,424.60,204657.20,222656.00,17998.80,656630),('1','180','229587','414',482.00,584.00,0.00,379.50,182919.00,208374.00,25455.00,657173),('1','180','229841','414',482.00,584.00,0.00,197.90,95387.80,110121.60,14733.80,657825),('1','180','229905','414',482.00,584.00,0.00,152.82,73659.24,86896.88,13237.64,657968),('1','180','230175','414',482.00,584.00,0.00,212.20,102280.40,116874.80,14594.40,658676),('1','180','230351','414',482.00,584.00,0.00,228.35,110064.70,125836.40,15771.70,659127),('1','180','230643','414',482.00,584.00,0.00,518.77,250047.14,207508.00,-42539.14,659890),('1','180','230665','414',482.00,584.00,0.00,0.00,0.00,0.00,0.00,659950),('1','180','230747','414',522.00,584.00,0.00,352.60,184057.20,191818.40,7761.20,660179),('1','180','230839','414',522.00,584.00,0.00,108.10,56428.20,63130.40,6702.20,660387),('1','180','231180','414',522.00,584.00,0.00,952.34,497121.48,515511.56,18390.08,661296),('1','180','231569','414',522.00,584.00,0.00,214.85,112151.70,120302.40,8150.70,662347),('1','180','231678','414',522.00,584.00,0.00,379.91,198313.02,209177.44,10864.42,662610),('1','180','231941','414',522.00,584.00,0.00,236.39,123395.58,131001.76,7606.18,663328),('1','180','232228','414',522.00,584.00,0.00,175.38,91548.36,100071.92,8523.56,664092),('1','180','232436','414',522.00,584.00,0.00,757.40,395362.80,409186.60,13823.80,664627),('1','180','232686','414',522.00,584.00,0.00,938.70,490001.40,504584.80,14583.40,665290),('1','180','232993','414',522.00,584.00,0.00,859.00,448398.00,462881.00,14483.00,666114),('1','180','233302','414',567.00,584.00,0.00,389.40,220789.80,210724.60,-10065.20,666921),('1','180','233328','414',567.00,584.00,0.00,0.00,0.00,0.00,0.00,666988),('1','180','233460','414',567.00,624.00,0.00,203.50,115384.50,121584.00,6199.50,667321),('1','180','233721','414',567.00,624.00,0.00,238.20,135059.40,142660.80,7601.40,668004),('1','180','233912','414',567.00,624.00,0.00,1197.78,679141.26,706734.72,27593.46,668505),('1','180','234135','414',567.00,624.00,0.00,786.78,446104.26,463950.72,17846.46,669101),('1','180','234383','414',567.00,624.00,0.00,200.00,113400.00,117600.00,4200.00,669753),('1','180','235189','414',567.00,624.00,0.00,0.00,0.00,0.00,0.00,671898),('1','180','235451','414',572.00,624.00,0.00,431.00,246532.00,255480.00,8948.00,672584),('1','180','235603','414',572.00,624.00,0.00,271.82,155481.04,162415.68,6934.64,672959),('1','180','235891','414',572.00,624.00,0.00,157.10,89861.20,94430.40,4569.20,673714),('1','180','236152','414',572.00,624.00,0.00,497.23,284415.56,297095.52,12679.96,674413),('1','180','236303','414',572.00,624.00,0.00,955.81,546723.32,566365.44,19642.12,674798),('1','180','236586','414',572.00,640.00,0.00,112.61,64412.92,72070.40,7657.48,675542),('1','180','236762','414',572.00,640.00,0.00,331.28,189492.16,204019.20,14527.04,675991),('1','180','236986','414',572.00,640.00,0.00,440.54,251988.88,269721.60,17732.72,676571),('1','180','237191','414',572.00,640.00,0.00,162.44,92915.68,102105.60,9189.92,677095),('1','180','237412','414',572.00,640.00,0.00,76.73,43889.56,49107.20,5217.64,677666),('1','180','237650','414',572.00,640.00,0.00,115.30,65951.60,73376.00,7424.40,678285),('1','180','237907','414',572.00,640.00,0.00,227.19,129952.68,143641.60,13688.92,678952),('1','180','238156','414',572.00,640.00,0.00,233.47,133544.84,146764.80,13219.96,679606),('1','180','238376','414',572.00,640.00,0.00,500.44,286251.68,313881.60,27629.92,680167),('1','180','238650','414',572.00,640.00,0.00,58.16,33267.52,37222.40,3954.88,680886),('1','180','238858','414',572.00,640.00,0.00,63.66,36413.52,40742.40,4328.88,681422),('1','180','239093','414',572.00,640.00,0.00,169.29,96833.88,106169.60,9335.72,682024),('1','180','240286','414',572.00,640.00,0.00,0.00,0.00,0.00,0.00,685134),('1','180','240296','414',602.00,656.00,0.00,949.05,571328.10,599020.80,27692.70,685157),('1','180','240488','414',602.00,656.00,0.00,110.81,66707.62,71391.36,4683.74,685661),('1','180','240724','414',602.00,656.00,0.00,662.74,398969.48,418637.44,19667.96,686225),('1','180','240996','414',602.00,656.00,0.00,224.31,135034.62,143247.36,8212.74,686958),('1','180','241258','414',602.00,656.00,0.00,656.51,395219.02,415590.56,20371.54,687642),('1','180','241566','414',602.00,656.00,0.00,289.25,174128.50,183924.00,9795.50,688470),('1','180','241789','414',602.00,656.00,0.00,52.59,31659.18,34499.04,2839.86,689062),('1','180','242000','414',602.00,656.00,0.00,130.27,78422.54,84157.12,5734.58,689604),('1','180','242253','414',602.00,656.00,0.00,107.52,64727.04,70533.12,5806.08,690260),('1','180','242509','414',602.00,656.00,0.00,371.92,223895.84,236647.52,12751.68,690915),('1','180','242649','414',602.00,656.00,0.00,80.29,48334.58,52670.24,4335.66,691303),('1','180','242946','414',602.00,656.00,0.00,180.46,108636.92,117081.76,8444.84,692053),('1','180','243160','414',602.00,656.00,0.00,132.06,79500.12,85331.36,5831.24,692615),('1','180','243387','414',602.00,656.00,0.00,182.69,109979.38,117244.64,7265.26,693220),('1','180','243668','414',602.00,656.00,0.00,360.08,216768.16,228828.48,12060.32,693934),('1','180','243894','414',602.00,656.00,0.00,90.72,54613.44,59512.32,4898.88,694530),('1','180','244126','414',602.00,656.00,0.00,198.18,119304.36,126990.08,7685.72,695121),('1','180','244375','414',602.00,656.00,0.00,125.05,75280.10,79172.80,3892.70,695778),('1','180','245005','414',602.00,656.00,0.00,0.00,0.00,0.00,0.00,697410),('1','180','245008','414',602.00,656.00,0.00,80.24,46699.68,50517.76,3818.08,697415),('1','180','245247','414',582.00,624.00,0.00,234.42,136432.44,143494.08,7061.64,698034),('1','180','245465','414',582.00,624.00,0.00,0.00,0.00,0.00,0.00,698593),('1','180','245467','414',582.00,624.00,0.00,88.63,51582.66,54105.12,2522.46,698597),('1','180','245708','414',582.00,624.00,0.00,223.31,129966.42,135361.44,5395.02,699214),('1','180','245966','414',582.00,616.00,0.00,249.57,145249.74,143707.12,-1542.62,699903),('1','180','246207','414',582.00,616.00,0.00,117.87,68600.34,69939.92,1339.58,700516),('1','180','246468','414',582.00,616.00,0.00,149.74,87148.68,89571.84,2423.16,701212),('1','180','246707','414',582.00,616.00,0.00,123.04,71609.28,75792.64,4183.36,701842),('1','180','246959','414',582.00,616.00,0.00,438.11,254980.02,255707.76,727.74,702481),('1','180','247193','414',582.00,616.00,0.00,186.50,108543.00,109824.00,1281.00,703086),('1','180','247445','414',582.00,616.00,0.00,104.24,60667.68,61543.84,876.16,703722),('1','180','247749','414',582.00,616.00,0.00,287.68,167429.76,169574.88,2145.12,704518),('1','180','247985','414',582.00,616.00,0.00,44.99,26184.18,27713.84,1529.66,705126),('1','180','248232','414',582.00,616.00,0.00,134.75,78424.50,80338.00,1913.50,705767),('1','180','248501','414',582.00,616.00,0.00,82.84,48212.88,51029.44,2816.56,706456),('1','180','248728','414',582.00,616.00,0.00,184.54,107402.28,109076.64,1674.36,707047),('1','180','248903','414',590.00,600.00,0.00,206.50,121835.00,119260.00,-2575.00,707497),('1','180','249125','414',590.00,600.00,0.00,134.42,79307.80,78652.00,-655.80,708062),('1','180','249370','414',590.00,600.00,0.00,222.70,131393.00,128980.00,-2413.00,708684),('1','180','249623','414',590.00,600.00,0.00,155.60,91804.00,90960.00,-844.00,709332),('1','180','249889','414',590.00,600.00,0.00,174.14,102742.60,99684.00,-3058.60,710018),('1','180','250161','414',590.00,600.00,0.00,367.52,216836.80,209940.40,-6896.40,710710),('1','180','250371','414',590.00,600.00,0.00,159.50,94105.00,91700.00,-2405.00,711242),('1','180','250610','414',590.00,600.00,0.00,196.17,115740.30,111062.00,-4678.30,711854),('1','180','250865','414',590.00,600.00,0.00,108.70,64133.00,62900.00,-1233.00,712517),('1','180','251071','414',590.00,600.00,0.00,237.17,139930.30,135662.00,-4268.30,713049),('1','180','251337','414',590.00,600.00,0.00,169.67,100105.30,95882.00,-4223.30,713748),('1','180','252183','414',590.00,600.00,0.00,0.00,0.00,0.00,0.00,715973),('1','180','252326','414',527.00,600.00,0.00,195.07,102801.89,112402.00,9600.11,716334),('1','180','252531','414',527.00,600.00,0.00,69.73,36747.71,41838.00,5090.29,716851),('1','180','252742','414',527.00,600.00,0.00,269.40,141973.80,153640.00,11666.20,717413),('1','180','253004','414',527.00,600.00,0.00,72.86,38397.22,43716.00,5318.78,718085),('1','180','253314','414',527.00,600.00,0.00,342.80,180655.60,194480.00,13824.40,718908),('1','180','253496','414',527.00,600.00,0.00,69.34,36542.18,41604.00,5061.82,719373),('1','180','253698','414',527.00,600.00,0.00,183.66,96788.82,105476.00,8687.18,719921),('1','180','253978','414',527.00,600.00,0.00,145.33,76588.91,87198.00,10609.09,720624),('1','180','254183','414',527.00,600.00,0.00,213.68,112609.36,123568.00,10958.64,721179),('1','180','254437','414',527.00,600.00,0.00,150.16,79134.32,90096.00,10961.68,721841),('1','180','254690','414',527.00,600.00,0.00,185.50,97758.50,106900.00,9141.50,722472),('1','180','254936','414',527.00,600.00,0.00,273.84,144313.68,159664.00,15350.32,723099),('1','180','255201','414',527.00,600.00,0.00,918.66,484133.82,517196.00,33062.18,723768),('1','180','255458','414',527.00,600.00,0.00,586.83,309259.41,333058.00,23798.59,724419),('1','180','255709','414',527.00,600.00,0.00,358.17,188755.59,205382.00,16626.41,725038),('1','180','255934','414',527.00,600.00,0.00,333.99,176012.73,194394.00,18381.27,725620),('1','180','256220','414',527.00,600.00,0.00,121.34,63946.18,72804.00,8857.82,726301),('1','180','256502','414',527.00,600.00,0.00,267.33,140882.91,157998.00,17115.09,727042),('1','180','256746','414',527.00,600.00,0.00,234.35,123502.45,135810.00,12307.55,727662),('1','180','256747','414',527.00,600.00,0.00,0.00,0.00,0.00,0.00,727663),('1','180','256748','414',517.00,600.00,0.00,399.67,206629.39,228042.00,21412.61,727664),('1','180','256749','414',517.00,600.00,0.00,107.02,55329.34,64212.00,8882.66,727665),('1','180','256750','414',517.00,600.00,0.00,377.50,195167.50,216500.00,21332.50,727666),('1','180','256751','414',517.00,600.00,0.00,195.50,101073.50,117300.00,16226.50,727667),('1','180','256752','414',517.00,600.00,0.00,68.67,35502.39,41202.00,5699.61,727668),('1','180','256753','414',517.00,600.00,0.00,71.50,36965.50,42900.00,5934.50,727669),('1','180','256754','414',517.00,600.00,0.00,70.65,36526.05,42390.00,5863.95,727670),('1','180','256755','414',517.00,600.00,0.00,150.50,77808.50,88300.00,10491.50,727671),('1','180','256756','414',517.00,600.00,0.00,71.18,36800.06,42708.00,5907.94,727672),('1','180','256757','414',517.00,600.00,0.00,136.32,70477.44,81792.00,11314.56,727673),('1','180','256759','414',517.00,600.00,0.00,216.33,111842.61,124998.00,13155.39,727675),('1','180','256760','414',517.00,600.00,0.00,100.87,52149.79,60522.00,8372.21,727676),('1','180','256761','414',517.00,568.00,0.00,111.84,57821.28,61965.12,4143.84,727677),('1','180','256762','414',517.00,568.00,0.00,180.14,93132.38,99439.52,6307.14,727678),('1','180','256763','414',517.00,568.00,0.00,60.31,31180.27,34256.08,3075.81,727679),('1','180','256764','414',517.00,568.00,0.00,66.13,34189.21,37561.84,3372.63,727680),('1','180','256765','414',517.00,568.00,0.00,41.66,21538.22,23662.88,2124.66,727681),('1','180','256766','414',517.00,568.00,0.00,59.45,30735.65,33767.60,3031.95,727682),('1','180','256767','414',517.00,568.00,0.00,104.86,54212.62,59560.48,5347.86,727683),('1','180','256768','414',517.00,568.00,0.00,91.38,47243.46,51903.84,4660.38,727684),('1','180','256769','414',517.00,568.00,0.00,278.69,144082.73,152535.92,8453.19,727685),('1','180','256770','414',517.00,568.00,0.00,100.76,52092.92,57231.68,5138.76,727686),('1','180','256771','414',517.00,568.00,0.00,130.56,67499.52,74158.08,6658.56,727687),('1','180','256772','414',517.00,568.00,0.00,91.55,47331.35,50560.40,3229.05,727688),('1','180','256773','414',517.00,568.00,0.00,199.02,102893.34,110643.36,7750.02,727689),('1','180','256774','414',517.00,568.00,0.00,202.11,104490.87,112206.48,7715.61,727690),('1','180','256775','414',517.00,568.00,0.00,222.88,115228.96,123955.84,8726.88,727691),('1','180','256776','414',517.00,568.00,0.00,69.66,36014.22,39566.88,3552.66,727692),('1','180','256777','414',517.00,568.00,0.00,67.34,34814.78,38249.12,3434.34,727693),('1','180','256778','414',517.00,568.00,0.00,125.09,64671.53,71051.12,6379.59,727694),('1','180','256779','414',517.00,568.00,0.00,117.65,60825.05,65625.20,4800.15,727695),('1','180','256780','414',517.00,568.00,0.00,351.36,181653.12,194772.48,13119.36,727696),('1','180','256781','414',517.00,568.00,0.00,113.61,58736.37,64530.48,5794.11,727697),('1','180','256782','414',517.00,568.00,0.00,187.09,96725.53,104827.12,8101.59,727698),('1','180','256783','414',517.00,568.00,0.00,160.99,83231.83,89642.32,6410.49,727699),('1','180','256784','414',612.00,680.00,0.00,25.15,15391.80,17102.00,1710.20,727700),('1','180','256785','414',612.00,680.00,0.00,80.62,49339.44,54821.60,5482.16,727701),('1','180','256786','414',612.00,680.00,0.00,77.88,47662.56,52958.40,5295.84,727702),('1','180','256787','414',612.00,680.00,0.00,64.47,39455.64,43839.60,4383.96,727703),('1','180','256788','414',612.00,680.00,0.00,94.33,57729.96,64144.40,6414.44,727704),('1','180','256789','414',612.00,680.00,0.00,76.64,46903.68,52115.20,5211.52,727705),('1','180','256790','414',612.00,680.00,0.00,281.01,171978.12,183086.80,11108.68,727706),('1','180','256791','414',612.00,680.00,0.00,109.99,67313.88,72393.20,5079.32,727707),('1','180','256792','414',612.00,680.00,0.00,78.25,47889.00,53210.00,5321.00,727708),('1','180','256793','414',612.00,680.00,0.00,71.27,43617.24,48463.60,4846.36,727709),('1','180','256794','414',612.00,680.00,0.00,73.64,45067.68,50075.20,5007.52,727710),('1','180','256795','414',612.00,680.00,0.00,85.24,52166.88,57963.20,5796.32,727711),('1','180','256796','414',612.00,680.00,0.00,200.55,122736.60,132194.00,9457.40,727712),('1','180','256797','414',612.00,680.00,0.00,284.85,174328.20,187618.00,13289.80,727713),('1','180','256798','414',612.00,680.00,0.00,173.31,106065.72,117850.80,11785.08,727714),('1','180','256799','414',612.00,650.00,0.00,470.31,287829.72,298801.50,10971.78,727715),('1','180','256800','414',612.00,650.00,0.00,521.02,318864.24,329663.00,10798.76,727716),('1','180','256801','414',612.00,650.00,0.00,404.28,247419.36,255282.00,7862.64,727717),('1','180','256802','414',612.00,650.00,0.00,338.56,207198.72,214664.00,7465.28,727718),('1','180','256803','414',612.00,650.00,0.00,352.24,215570.88,222056.00,6485.12,727719),('1','180','256804','414',612.00,650.00,0.00,307.53,188208.36,194194.50,5986.14,727720),('1','180','256805','414',612.00,650.00,0.00,109.31,66897.72,69251.50,2353.78,727721),('1','180','256806','414',612.00,650.00,0.00,188.70,115484.40,117855.00,2370.60,727722),('1','180','256807','414',612.00,650.00,0.00,37.30,22827.60,24245.00,1417.40,727723),('1','180','256808','414',612.00,650.00,0.00,203.77,124707.24,127950.50,3243.26,727724),('1','180','256809','414',612.00,650.00,0.00,0.00,0.00,0.00,0.00,727725),('1','180','256810','414',602.00,650.00,0.00,239.97,144461.94,150880.50,6418.56,727726),('1','180','256811','414',602.00,650.00,0.00,74.80,45029.60,48620.00,3590.40,727727),('1','180','256812','414',602.00,650.00,0.00,70.81,42627.62,46026.50,3398.88,727728),('1','180','256813','414',602.00,650.00,0.00,166.93,100491.86,105204.50,4712.64,727729),('1','180','256814','414',602.00,650.00,0.00,47.31,28480.62,30751.50,2270.88,727730),('1','180','256815','414',602.00,650.00,0.00,123.94,74611.88,79061.00,4449.12,727731),('1','180','256816','414',602.00,650.00,0.00,148.89,89631.78,96778.50,7146.72,727732),('1','180','256817','414',602.00,650.00,0.00,75.05,45180.10,48782.50,3602.40,727733),('1','180','256818','414',602.00,650.00,0.00,62.87,37847.74,40865.50,3017.76,727734),('1','180','256819','414',602.00,650.00,0.00,78.93,47515.86,51304.50,3788.64,727735),('1','180','256820','414',602.00,650.00,0.00,193.59,116541.18,124333.50,7792.32,727736),('1','180','256821','414',602.00,650.00,0.00,73.51,44253.02,47781.50,3528.48,727737),('1','180','256822','414',602.00,650.00,0.00,163.17,98228.34,104260.50,6032.16,727738),('1','180','256823','414',602.00,650.00,0.00,376.37,226574.74,239240.50,12665.76,727739),('1','180','256824','414',602.00,650.00,0.00,146.98,88481.96,95537.00,7055.04,727740),('1','180','256825','414',602.00,650.00,0.00,34.00,20468.00,22100.00,1632.00,727741),('1','180','256826','414',602.00,650.00,0.00,45.55,27421.10,29607.50,2186.40,727742),('1','180','256827','414',602.00,650.00,0.00,113.47,68308.94,72255.50,3946.56,727743),('1','180','256828','414',602.00,650.00,0.00,81.23,48900.46,52799.50,3899.04,727744),('1','180','256829','414',602.00,650.00,0.00,109.54,65943.08,69401.00,3457.92,727745),('1','180','256830','414',602.00,650.00,0.00,61.20,36842.40,39780.00,2937.60,727746),('1','180','256831','414',602.00,650.00,0.00,222.00,133644.00,138300.00,4656.00,727747),('1','180','256832','414',602.00,650.00,0.00,245.60,147851.20,158140.00,10288.80,727748),('1','180','256833','414',602.00,650.00,0.00,145.70,87711.40,93205.00,5493.60,727749),('1','180','256834','414',602.00,650.00,0.00,236.81,142559.62,148526.50,5966.88,727750),('1','180','256835','414',602.00,650.00,0.00,110.62,66593.24,71903.00,5309.76,727751),('1','180','256836','414',602.00,650.00,0.00,100.16,60296.32,63604.00,3307.68,727752),('1','180','256837','414',602.00,650.00,0.00,239.13,143956.26,150334.50,6378.24,727753),('1','180','256838','414',602.00,696.00,0.00,47.77,28757.54,33247.92,4490.38,727754),('1','180','256839','414',602.00,696.00,0.00,212.37,127846.74,145609.52,17762.78,727755),('1','180','256840','414',602.00,696.00,0.00,61.00,36722.00,42456.00,5734.00,727756),('1','180','256841','414',602.00,696.00,0.00,62.81,37811.62,43715.76,5904.14,727757),('1','180','256842','414',602.00,696.00,0.00,210.60,126781.20,139537.60,12756.40,727758),('1','180','256843','414',602.00,696.00,0.00,91.77,55245.54,61671.92,6426.38,727759),('1','180','256844','414',602.00,696.00,0.00,182.07,109606.14,124520.72,14914.58,727760),('1','180','256845','414',602.00,696.00,0.00,53.38,32134.76,37152.48,5017.72,727761),('1','180','256846','414',602.00,696.00,0.00,44.90,27029.80,31250.40,4220.60,727762),('1','180','256847','414',602.00,696.00,0.00,149.41,89944.82,101349.36,11404.54,727763),('1','180','256848','414',602.00,696.00,0.00,59.07,35560.14,43711.80,8151.66,727764),('1','180','256849','414',602.00,740.00,0.00,101.00,60802.00,74740.00,13938.00,727765),('1','180','256850','414',602.00,740.00,0.00,73.63,44325.26,54486.20,10160.94,727766),('1','180','256851','414',602.00,740.00,0.00,91.60,55143.20,67784.00,12640.80,727767),('1','180','256852','414',602.00,740.00,0.00,248.05,149326.10,177837.00,28510.90,727768),('1','180','256853','414',602.00,740.00,0.00,99.78,60067.56,73837.20,13769.64,727769),('1','180','256854','414',602.00,740.00,0.00,68.14,41020.28,50423.60,9403.32,727770),('1','180','256855','414',602.00,740.00,0.00,97.63,58773.26,72246.20,13472.94,727771),('1','180','256856','414',602.00,740.00,0.00,52.83,31803.66,39094.20,7290.54,727772),('1','180','256857','414',602.00,740.00,0.00,92.06,55420.12,68124.40,12704.28,727773),('1','180','256858','414',602.00,740.00,0.00,169.30,101918.60,125282.00,23363.40,727774),('1','180','256859','414',602.00,740.00,0.00,126.82,76345.64,93846.80,17501.16,727775),('1','180','256860','414',602.00,740.00,0.00,292.75,176235.50,211355.00,35119.50,727776),('1','180','256861','414',602.00,740.00,0.00,163.94,98691.88,119115.60,20423.72,727777),('1','180','256862','414',602.00,740.00,0.00,175.15,105440.30,127411.00,21970.70,727778),('1','180','256863','414',602.00,740.00,0.00,98.78,59465.56,73097.20,13631.64,727779),('1','180','256864','414',602.00,740.00,0.00,92.77,55847.54,71432.90,15585.36,727780),('1','180','256865','414',602.00,770.00,0.00,129.39,77892.78,99630.30,21737.52,727781),('1','180','256866','414',602.00,770.00,0.00,65.35,39340.70,50319.50,10978.80,727782),('1','180','256867','414',602.00,770.00,0.00,80.28,48328.56,61815.60,13487.04,727783),('1','180','256868','414',602.00,770.00,0.00,147.60,88855.20,108652.00,19796.80,727784),('1','180','256869','414',602.00,770.00,0.00,158.48,95404.96,119529.60,24124.64,727785),('1','180','256870','414',602.00,770.00,0.00,101.03,60820.06,77793.10,16973.04,727786),('1','180','256871','414',602.00,770.00,0.00,291.23,175320.46,214247.10,38926.64,727787),('1','180','256872','414',602.00,770.00,0.00,200.65,120791.30,148500.50,27709.20,727788),('1','180','256873','414',602.00,770.00,0.00,57.14,34398.28,43997.80,9599.52,727789),('1','180','256874','414',602.00,770.00,0.00,48.04,28920.08,36990.80,8070.72,727790),('1','180','256875','414',602.00,770.00,0.00,0.00,0.00,0.00,0.00,727791),('1','180','256876','414',602.00,770.00,0.00,0.00,0.00,0.00,0.00,727792),('1','180','256877','414',692.00,770.00,0.00,0.00,0.00,0.00,0.00,727793),('1','180','256878','414',692.00,770.00,0.00,50.02,34613.84,38515.40,3901.56,727794),('1','180','256879','414',692.00,770.00,0.00,113.25,78369.00,87202.50,8833.50,727795),('1','180','256880','414',692.00,770.00,0.00,115.30,79787.60,86281.00,6493.40,727796),('1','180','256881','414',692.00,770.00,0.00,96.08,66487.36,71481.60,4994.24,727797),('1','180','256882','414',692.00,770.00,0.00,40.35,27922.20,31069.50,3147.30,727798),('1','180','256883','414',692.00,770.00,0.00,128.86,89171.12,99222.20,10051.08,727799),('1','180','256884','414',692.00,770.00,0.00,121.21,83877.32,93331.70,9454.38,727800),('1','180','256885','414',692.00,770.00,0.00,242.50,167810.00,183725.00,15915.00,727801),('1','180','256886','414',692.00,770.00,0.00,69.54,48121.68,53545.80,5424.12,727802),('1','180','256887','414',692.00,770.00,0.00,85.74,59332.08,66019.80,6687.72,727803),('1','180','256888','414',692.00,770.00,0.00,205.85,142448.20,152504.50,10056.30,727804),('1','180','256889','414',692.00,770.00,0.00,60.24,41686.08,46384.80,4698.72,727805),('1','180','256890','414',692.00,770.00,0.00,227.56,157471.52,172221.20,14749.68,727806),('1','180','256891','414',692.00,770.00,0.00,458.59,317344.28,337614.30,20270.02,727807),('1','180','256892','414',692.00,770.00,0.00,50.50,34946.00,38885.00,3939.00,727808),('1','180','256893','414',692.00,770.00,0.00,124.53,86174.76,92888.10,6713.34,727809),('1','180','256894','414',692.00,770.00,0.00,261.20,180750.40,192124.00,11373.60,727810),('1','180','256895','414',692.00,770.00,0.00,189.11,130864.12,138114.70,7250.58,727811),('1','180','256896','414',692.00,770.00,0.00,245.01,169546.92,181657.70,12110.78,727812),('1','180','256897','414',692.00,770.00,0.00,150.11,103876.12,109584.70,5708.58,727813),('1','180','256898','414',692.00,770.00,0.00,144.11,99724.12,108464.70,8740.58,727814),('1','180','256899','414',692.00,770.00,0.00,198.90,137638.80,147153.00,9514.20,727815),('1','180','256900','414',692.00,770.00,0.00,203.14,140572.88,150417.80,9844.92,727816),('1','180','256901','414',692.00,770.00,0.00,265.80,183933.60,195666.00,11732.40,727817),('1','180','256902','414',692.00,770.00,0.00,169.47,117273.24,126991.90,9718.66,727818),('1','180','256903','414',692.00,770.00,0.00,65.60,45395.20,50512.00,5116.80,727819),('1','180','256904','414',692.00,770.00,0.00,47.51,32876.92,36582.70,3705.78,727820),('1','180','256905','414',692.00,770.00,0.00,188.43,130393.56,139591.10,9197.54,727821),('1','180','256906','414',692.00,770.00,0.00,304.68,210838.56,225853.60,15015.04,727822),('1','180','256907','414',692.00,770.00,0.00,179.68,124338.56,129853.60,5515.04,727823),('1','180','256908','414',692.00,770.00,0.00,0.00,0.00,0.00,0.00,727824),('1','180','256909','414',692.00,770.00,0.00,101.33,70120.36,75024.10,4903.74,727825),('1','180','256910','414',692.00,770.00,0.00,107.61,74466.12,82859.70,8393.58,727826),('1','180','256911','414',692.00,770.00,0.00,130.54,90333.68,100515.80,10182.12,727827),('1','180','256912','414',692.00,770.00,0.00,83.39,57705.88,64210.30,6504.42,727828),('1','180','256913','414',692.00,770.00,0.00,70.74,48952.08,54469.80,5517.72,727829),('1','180','256914','414',692.00,770.00,0.00,192.95,133521.40,146071.50,12550.10,727830),('1','180','256915','414',692.00,770.00,0.00,132.24,91510.08,98824.80,7314.72,727831),('1','180','256916','414',692.00,770.00,0.00,86.79,60058.68,66828.30,6769.62,727832),('1','180','256917','414',692.00,770.00,0.00,67.97,47035.24,52336.90,5301.66,727833),('1','180','256918','414',692.00,770.00,0.00,370.72,256538.24,274154.40,17616.16,727834),('1','180','256919','414',692.00,770.00,0.00,352.45,243895.40,262486.50,18591.10,727835),('1','180','256920','414',692.00,770.00,0.00,115.61,80002.12,89019.70,9017.58,727836),('1','180','256921','414',692.00,770.00,0.00,365.04,252607.68,266580.80,13973.12,727837),('1','180','256922','414',692.00,770.00,0.00,216.79,150018.68,161928.30,11909.62,727838),('1','180','256923','414',692.00,770.00,0.00,391.13,270661.96,284770.10,14108.14,727839),('1','180','256924','414',692.00,770.00,0.00,180.02,124573.84,135715.40,11141.56,727840),('1','180','256925','414',692.00,770.00,0.00,127.83,88458.36,95929.10,7470.74,727841),('1','180','256926','414',692.00,770.00,0.00,157.34,108879.28,118151.80,9272.52,727842),('1','180','256927','414',692.00,770.00,0.00,230.96,159824.32,171839.20,12014.88,727843),('1','180','256928','414',692.00,770.00,0.00,306.15,211855.80,227035.50,15179.70,727844),('1','180','256929','414',692.00,770.00,0.00,118.69,82133.48,91391.30,9257.82,727845),('1','180','256930','414',692.00,770.00,0.00,169.27,117134.84,130337.90,13203.06,727846),('1','180','256931','414',692.00,770.00,0.00,144.12,99731.04,108472.40,8741.36,727847),('1','180','256932','414',692.00,770.00,0.00,121.84,84313.28,93816.80,9503.52,727848),('1','180','256933','414',692.00,770.00,0.00,81.89,56667.88,63055.30,6387.42,727849),('1','180','256934','414',692.00,770.00,0.00,132.17,91461.64,99270.90,7809.26,727850),('1','180','256935','414',692.00,770.00,0.00,163.11,112872.12,122594.70,9722.58,727851),('1','180','256936','414',692.00,770.00,0.00,184.30,127535.60,133411.00,5875.40,727852),('1','180','256937','414',692.00,612.00,0.00,0.00,0.00,0.00,0.00,727853),('1','180','256938','414',685.00,770.00,0.00,43.15,29557.75,33225.50,3667.75,727854),('1','180','256939','414',685.00,770.00,0.00,48.44,33181.40,37298.80,4117.40,727855),('1','180','256940','414',685.00,770.00,0.00,111.80,76583.00,83186.00,6603.00,727856),('1','180','256941','414',685.00,770.00,0.00,79.30,54320.50,61061.00,6740.50,727857),('1','180','256942','414',685.00,770.00,0.00,60.96,41757.60,46939.20,5181.60,727858),('1','180','256943','414',685.00,770.00,0.00,60.02,41113.70,46215.40,5101.70,727859),('1','180','256944','414',685.00,770.00,0.00,107.49,73630.65,79767.30,6136.65,727860),('1','180','256945','414',685.00,770.00,0.00,182.09,124731.65,137209.30,12477.65,727861),('1','180','256946','414',685.00,770.00,0.00,188.41,129060.85,139275.70,10214.85,727862),('1','180','256947','414',685.00,770.00,0.00,168.83,115648.55,129999.10,14350.55,727863),('1','180','256948','414',685.00,770.00,0.00,64.98,44511.30,50034.60,5523.30,727864),('1','180','256949','414',685.00,770.00,0.00,135.77,93002.45,101542.90,8540.45,727865),('1','180','256950','414',685.00,770.00,0.00,67.86,46484.10,49752.20,3268.10,727866),('1','180','256951','414',685.00,770.00,0.00,115.08,78829.80,86111.60,7281.80,727867),('1','180','256952','414',685.00,770.00,0.00,246.20,168647.00,179574.00,10927.00,727868),('1','180','256953','414',685.00,770.00,0.00,108.15,74082.75,80375.50,6292.75,727869),('1','180','256954','414',685.00,770.00,0.00,215.85,147857.25,158704.50,10847.25,727870),('1','180','256955','414',685.00,770.00,0.00,67.68,46360.80,52113.60,5752.80,727871),('1','180','256956','414',685.00,770.00,0.00,40.91,28023.35,31500.70,3477.35,727872),('1','180','256957','414',685.00,770.00,0.00,142.68,97735.80,106863.60,9127.80,727873),('1','180','256958','414',685.00,770.00,0.00,85.61,58642.85,63019.70,4376.85,727874),('1','180','256959','414',685.00,770.00,0.00,276.01,189066.85,203627.70,14560.85,727875),('1','180','256960','414',685.00,770.00,0.00,150.74,103256.90,113169.80,9912.90,727876),('1','180','256961','414',685.00,770.00,0.00,259.84,177990.40,192076.80,14086.40,727877),('1','180','256962','414',685.00,770.00,0.00,109.54,75034.90,84345.80,9310.90,727878),('1','180','256963','414',685.00,770.00,0.00,63.23,43312.55,48687.10,5374.55,727879),('1','180','256964','414',685.00,770.00,0.00,214.06,146631.10,156526.20,9895.10,727880),('1','180','256965','414',685.00,770.00,0.00,125.22,85775.70,93419.40,7643.70,727881),('1','180','256966','414',685.00,770.00,0.00,91.34,62567.90,70331.80,7763.90,727882),('1','180','256967','414',685.00,770.00,0.00,133.79,91646.15,103018.30,11372.15,727883),('1','180','256968','414',685.00,770.00,0.00,87.35,59834.75,67259.50,7424.75,727884),('1','180','256969','414',685.00,770.00,0.00,82.63,56601.55,63625.10,7023.55,727885),('1','180','256970','414',685.00,770.00,0.00,199.27,136499.95,147637.90,11137.95,727886),('1','180','256971','414',685.00,770.00,0.00,35.78,24509.30,27550.60,3041.30,727887),('1','180','256972','414',685.00,770.00,0.00,162.86,111559.10,119902.20,8343.10,727888),('1','180','256973','414',685.00,770.00,0.00,318.00,217830.00,229860.00,12030.00,727889);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',381,'180','LPG TANKS','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=935 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','180','381',934,1,'414','LPG TANK',6000.00,1.00,3023.66,'TANK CONTAINING LPG PRODUCT.','479','2021-05-08 12:23:01','2021-05-08 12:23:01','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','180',934,528.86,'2023-02-01 13:10:49');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2626317 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108652,'1','180','934',414,'Retail Sale Id 1254334',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 06:58:49','',''),(2108653,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 06:58:49','',''),(2108668,'1','180','934',414,'Retail Sale Id 1254342',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 06:59:34','',''),(2108669,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:59:34','',''),(2113939,'1','180','934',414,'Retail Sale Id 1256925',31500.00,0.00,0.00,0.00,1400.00,'2021-12-01 12:28:24','',''),(2113940,'1','180','934',414,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-01 12:28:24','',''),(2113947,'1','180','934',414,'Retail Sale Id 1256930',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:29:06','',''),(2113948,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:29:06','',''),(2113959,'1','180','934',414,'Retail Sale Id 1256935',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 12:29:46','',''),(2113960,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:29:46','',''),(2113977,'1','180','934',414,'Retail Sale Id 1256941',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 12:32:07','',''),(2113978,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:32:07','',''),(2117543,'1','180','934',414,'Retail Sale Id 1258632',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:15:58','',''),(2117544,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:15:58','',''),(2117704,'1','180','934',414,'Retail Sale Id 1258716',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:22:30','',''),(2117705,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:22:30','',''),(2117722,'1','180','934',414,'Retail Sale Id 1258729',4998.72,0.00,0.00,0.00,411.48,'2021-12-01 16:23:18','',''),(2117723,'1','180','934',414,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-01 16:23:18','',''),(2117742,'1','180','934',414,'Retail Sale Id 1258740',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:24:15','',''),(2117743,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:24:15','',''),(2117756,'1','180','934',414,'Retail Sale Id 1258746',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:25:07','',''),(2117757,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:25:07','',''),(2117816,'1','180','934',414,'Retail Sale Id 1258786',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:28:02','',''),(2117817,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:28:02','',''),(2117966,'1','180','934',414,'Retail Sale Id 1258869',7498.08,0.00,0.00,0.00,617.22,'2021-12-01 16:35:04','',''),(2117967,'1','180','934',414,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-01 16:35:04','',''),(2117982,'1','180','934',414,'Retail Sale Id 1258877',701.92,0.00,0.00,0.00,57.78,'2021-12-01 16:36:14','',''),(2117983,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-01 16:36:14','',''),(2118004,'1','180','934',414,'Retail Sale Id 1258891',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:37:10','',''),(2118005,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:37:10','',''),(2118074,'1','180','934',414,'Retail Sale Id 1258926',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:40:37','',''),(2118075,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:40:37','',''),(2118112,'1','180','934',414,'Retail Sale Id 1258948',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 16:42:24','',''),(2118113,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:42:24','',''),(2118142,'1','180','934',414,'Retail Sale Id 1258962',3503.04,0.00,0.00,0.00,288.36,'2021-12-01 16:43:59','',''),(2118143,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-01 16:43:59','',''),(2118156,'1','180','934',414,'Retail Sale Id 1258972',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:44:42','',''),(2118157,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:44:42','',''),(2118220,'1','180','934',414,'Retail Sale Id 1259003',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 16:48:12','',''),(2118221,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:48:12','',''),(2118367,'1','180','934',414,'Retail Sale Id 1259073',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:54:07','',''),(2118368,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:54:07','',''),(2118412,'1','180','934',414,'Retail Sale Id 1259097',7216.00,0.00,0.00,0.00,594.00,'2021-12-01 16:56:15','',''),(2118413,'1','180','934',414,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 16:56:15','',''),(2121352,'1','180','934',414,'Retail Sale Id 1260272',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 07:05:18','',''),(2121353,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:05:18','',''),(2121364,'1','180','934',414,'Retail Sale Id 1260280',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 07:05:58','',''),(2121365,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:05:58','',''),(2127078,'1','180','934',414,'Retail Sale Id 1263093',31500.00,0.00,0.00,0.00,1400.00,'2021-12-02 12:21:44','',''),(2127079,'1','180','934',414,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 12:21:44','',''),(2127176,'1','180','934',414,'Retail Sale Id 1263143',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 12:27:41','',''),(2127177,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:27:41','',''),(2127184,'1','180','934',414,'Retail Sale Id 1263147',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 12:28:25','',''),(2127185,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:28:25','',''),(2127186,'1','180','934',414,'Retail Sale Id 1263149',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 12:29:10','',''),(2127187,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 12:29:10','',''),(2127368,'1','180','934',414,'Retail Sale Id 1263261',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 12:43:05','',''),(2127369,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:43:05','',''),(2127382,'1','180','934',414,'Retail Sale Id 1263268',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 12:45:05','',''),(2127383,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:45:05','',''),(2127854,'1','180','934',414,'Retail Sale Id 1263480',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 13:16:50','',''),(2127855,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:16:50','',''),(2131052,'1','180','934',414,'Retail Sale Id 1264956',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 16:05:30','',''),(2131053,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 16:05:30','',''),(2131076,'1','180','934',414,'Retail Sale Id 1264965',7216.00,0.00,0.00,0.00,594.00,'2021-12-02 16:06:29','',''),(2131077,'1','180','934',414,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-02 16:06:29','',''),(2131090,'1','180','934',414,'Retail Sale Id 1264973',6560.00,0.00,0.00,0.00,540.00,'2021-12-02 16:07:15','',''),(2131091,'1','180','934',414,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 16:07:15','',''),(2131116,'1','180','934',414,'Retail Sale Id 1264985',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 16:08:00','',''),(2131117,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:08:00','',''),(2131126,'1','180','934',414,'Retail Sale Id 1260131',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 16:08:38','',''),(2131127,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:08:38','',''),(2131752,'1','180','934',414,'Retail Sale Id 1265300',2499.36,0.00,0.00,0.00,205.74,'2021-12-02 16:36:50','',''),(2131753,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-02 16:36:50','',''),(2133643,'1','180','934',414,'Retail Sale Id 1266057',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 22:24:08','',''),(2133644,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 22:24:08','',''),(2134741,'1','180','934',414,'Retail Sale Id 1266456',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 07:00:34','',''),(2134742,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:00:34','',''),(2134759,'1','180','934',414,'Retail Sale Id 1266466',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 07:01:43','',''),(2134760,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:01:43','',''),(2138359,'1','180','934',414,'Retail Sale Id 1268191',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:13:57','',''),(2138360,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:13:57','',''),(2138377,'1','180','934',414,'Retail Sale Id 1268201',2624.00,0.00,0.00,0.00,216.00,'2021-12-03 10:15:10','',''),(2138378,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 10:15:10','',''),(2138669,'1','180','934',414,'Retail Sale Id 1268342',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 10:32:02','',''),(2138670,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:32:02','',''),(2138845,'1','180','934',414,'Retail Sale Id 1268428',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 10:43:54','',''),(2138846,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:43:54','',''),(2139247,'1','180','934',414,'Retail Sale Id 1268643',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 11:15:01','',''),(2139248,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 11:15:01','',''),(2139556,'1','180','934',414,'Retail Sale Id 1268808',5248.00,0.00,0.00,0.00,432.00,'2021-12-03 11:40:01','',''),(2139557,'1','180','934',414,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 11:40:01','',''),(2140082,'1','180','934',414,'Retail Sale Id 1269113',63000.00,0.00,0.00,0.00,2800.00,'2021-12-03 12:20:33','',''),(2140083,'1','180','934',414,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-03 12:20:33','',''),(2145170,'1','180','934',414,'Retail Sale Id 1271476',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 16:57:46','',''),(2145171,'1','180','934',414,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:57:46','',''),(2145198,'1','180','934',414,'Retail Sale Id 1271489',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 16:59:36','',''),(2145199,'1','180','934',414,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 16:59:36','',''),(2145222,'1','180','934',414,'Retail Sale Id 1271501',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 17:00:56','',''),(2145223,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 17:00:56','',''),(2145230,'1','180','934',414,'Retail Sale Id 1271506',2624.00,0.00,0.00,0.00,216.00,'2021-12-03 17:02:02','',''),(2145231,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 17:02:02','',''),(2145248,'1','180','934',414,'Retail Sale Id 1271515',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 17:02:57','',''),(2145249,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 17:02:57','',''),(2145260,'1','180','934',414,'Retail Sale Id 1271524',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 17:03:52','',''),(2145261,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:03:52','',''),(2145391,'1','180','934',414,'Retail Sale Id 1271591',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 17:14:35','',''),(2145392,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 17:14:35','',''),(2150191,'1','180','934',414,'Retail Sale Id 1273883',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 09:03:08','',''),(2150192,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:03:08','',''),(2150231,'1','180','934',414,'Retail Sale Id 1273910',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 09:04:33','',''),(2150232,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 09:04:33','',''),(2152682,'1','180','934',414,'Retail Sale Id 1274475',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 10:49:28','',''),(2152683,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 10:49:28','',''),(2154171,'1','180','934',414,'Retail Sale Id 1275116',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 12:04:18','',''),(2154172,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:04:18','',''),(2154198,'1','180','934',414,'Retail Sale Id 1275127',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 12:05:47','',''),(2154199,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:05:47','',''),(2154216,'1','180','934',414,'Retail Sale Id 1275140',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 12:07:00','',''),(2154217,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:07:00','',''),(2154236,'1','180','934',414,'Retail Sale Id 1275148',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 12:08:16','',''),(2154237,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 12:08:16','',''),(2154256,'1','180','934',414,'Retail Sale Id 1275157',2624.00,0.00,0.00,0.00,216.00,'2021-12-04 12:09:17','',''),(2154257,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 12:09:17','',''),(2155083,'1','180','934',414,'Retail Sale Id 1275780',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 13:09:12','',''),(2155084,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:09:12','',''),(2155098,'1','180','934',414,'Retail Sale Id 1275786',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 13:10:19','',''),(2155099,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 13:10:19','',''),(2155115,'1','180','934',414,'Retail Sale Id 1275793',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 13:11:19','',''),(2155116,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:11:19','',''),(2155642,'1','180','934',414,'Retail Sale Id 1276003',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 13:39:15','',''),(2155643,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 13:39:15','',''),(2156152,'1','180','934',414,'Retail Sale Id 1276230',2624.00,0.00,0.00,0.00,216.00,'2021-12-04 14:03:44','',''),(2156153,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 14:03:44','',''),(2156882,'1','180','934',414,'Retail Sale Id 1276582',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 14:39:53','',''),(2156883,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:39:53','',''),(2157692,'1','180','934',414,'Retail Sale Id 1276908',69300.00,0.00,0.00,0.00,3080.00,'2021-12-04 15:20:27','',''),(2157693,'1','180','934',414,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-04 15:20:27','',''),(2157840,'1','180','934',414,'Retail Sale Id 1276965',2499.36,0.00,0.00,0.00,205.74,'2021-12-04 15:26:48','',''),(2157841,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-04 15:26:48','',''),(2158983,'1','180','934',414,'Retail Sale Id 1277542',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 16:21:23','',''),(2158984,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:21:23','',''),(2159614,'1','180','934',414,'Retail Sale Id 1277883',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 16:49:41','',''),(2159615,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 16:49:41','',''),(2160185,'1','180','934',414,'Retail Sale Id 1278161',109620.00,0.00,0.00,0.00,4872.00,'2021-12-04 17:23:19','',''),(2160186,'1','180','934',414,'Retail sales',0.00,0.00,0.00,174.00,0.00,'2021-12-04 17:23:19','',''),(2165045,'1','180','934',414,'Retail Sale Id 1280251',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 09:06:35','',''),(2165046,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:06:35','',''),(2165083,'1','180','934',414,'Retail Sale Id 1280270',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 09:08:11','',''),(2165084,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:08:11','',''),(2168166,'1','180','934',414,'Retail Sale Id 1281920',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 12:02:29','',''),(2168167,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:02:29','',''),(2168884,'1','180','934',414,'Retail Sale Id 1282282',6560.00,0.00,0.00,0.00,540.00,'2021-12-05 12:34:47','',''),(2168885,'1','180','934',414,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 12:34:47','',''),(2169334,'1','180','934',414,'Retail Sale Id 1282527',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 13:00:22','',''),(2169335,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:00:22','',''),(2170749,'1','180','934',414,'Retail Sale Id 1283180',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 14:15:48','',''),(2170750,'1','180','934',414,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 14:15:48','',''),(2170787,'1','180','934',414,'Retail Sale Id 1283193',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 14:17:05','',''),(2170788,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:17:05','',''),(2170832,'1','180','934',414,'Retail Sale Id 1283204',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 14:18:28','',''),(2170833,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:18:28','',''),(2170869,'1','180','934',414,'Retail Sale Id 1283225',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 14:20:19','',''),(2170870,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:20:19','',''),(2170883,'1','180','934',414,'Retail Sale Id 1283230',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 14:21:25','',''),(2170884,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 14:21:25','',''),(2170895,'1','180','934',414,'Retail Sale Id 1283237',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 14:22:51','',''),(2170896,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 14:22:51','',''),(2170913,'1','180','934',414,'Retail Sale Id 1283244',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 14:24:01','',''),(2170914,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 14:24:01','',''),(2172834,'1','180','934',414,'Retail Sale Id 1284157',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:19:45','',''),(2172835,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:19:45','',''),(2173043,'1','180','934',414,'Retail Sale Id 1284274',2624.00,0.00,0.00,0.00,216.00,'2021-12-05 16:32:55','',''),(2173044,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 16:32:55','',''),(2173784,'1','180','934',414,'Retail Sale Id 1284638',5248.00,0.00,0.00,0.00,432.00,'2021-12-05 17:21:53','',''),(2173785,'1','180','934',414,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 17:21:53','',''),(2173800,'1','180','934',414,'Retail Sale Id 1284643',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 17:23:03','',''),(2173801,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 17:23:03','',''),(2173804,'1','180','934',414,'Retail Sale Id 1284647',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 17:24:12','',''),(2173805,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 17:24:12','',''),(2173812,'1','180','934',414,'Retail Sale Id 1284652',2624.00,0.00,0.00,0.00,216.00,'2021-12-05 17:25:06','',''),(2173813,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 17:25:06','',''),(2177013,'1','180','934',414,'Retail Sale Id 1285952',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 08:39:16','',''),(2177014,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:39:16','',''),(2177023,'1','180','934',414,'Retail Sale Id 1285957',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 08:39:56','',''),(2177024,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 08:39:56','',''),(2180508,'1','180','934',414,'Retail Sale Id 1287795',73080.00,0.00,0.00,0.00,3248.00,'2021-12-06 12:26:01','',''),(2180509,'1','180','934',414,'Retail sales',0.00,0.00,0.00,116.00,0.00,'2021-12-06 12:26:01','',''),(2181134,'1','180','934',414,'Retail Sale Id 1288112',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 13:02:51','',''),(2181135,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:02:51','',''),(2181174,'1','180','934',414,'Retail Sale Id 1288133',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 13:06:07','',''),(2181175,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 13:06:07','',''),(2181194,'1','180','934',414,'Retail Sale Id 1288143',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 13:07:07','',''),(2181195,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:07:07','',''),(2181230,'1','180','934',414,'Retail Sale Id 1288160',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 13:09:12','',''),(2181231,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:09:12','',''),(2181256,'1','180','934',414,'Retail Sale Id 1288183',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 13:10:32','',''),(2181257,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:10:32','',''),(2181288,'1','180','934',414,'Retail Sale Id 1288199',2296.00,0.00,0.00,0.00,189.00,'2021-12-06 13:11:55','',''),(2181289,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-06 13:11:55','',''),(2181304,'1','180','934',414,'Retail Sale Id 1288207',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 13:13:11','',''),(2181305,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 13:13:11','',''),(2182103,'1','180','934',414,'Retail Sale Id 1288556',3503.04,0.00,0.00,0.00,288.36,'2021-12-06 13:55:14','',''),(2182104,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-06 13:55:14','',''),(2182245,'1','180','934',414,'Retail Sale Id 1288615',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 14:01:40','',''),(2182246,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:01:40','',''),(2183586,'1','180','934',414,'Retail Sale Id 1289236',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 15:09:22','',''),(2183587,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:09:22','',''),(2184377,'1','180','934',414,'Retail Sale Id 1289561',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 15:44:34','',''),(2184378,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:44:34','',''),(2184414,'1','180','934',414,'Retail Sale Id 1289575',701.92,0.00,0.00,0.00,57.78,'2021-12-06 15:45:48','',''),(2184415,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.07,0.00,'2021-12-06 15:45:48','',''),(2186063,'1','180','934',414,'Retail Sale Id 1290383',4998.72,0.00,0.00,0.00,411.48,'2021-12-06 17:23:26','',''),(2186064,'1','180','934',414,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 17:23:26','',''),(2186096,'1','180','934',414,'Retail Sale Id 1290400',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 17:26:37','',''),(2186097,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 17:26:37','',''),(2191132,'1','180','934',414,'Retail Sale Id 1292606',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:50:18','',''),(2191133,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:50:18','',''),(2191148,'1','180','934',414,'Retail Sale Id 1292610',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:50:57','',''),(2191149,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:50:57','',''),(2192819,'1','180','934',414,'Retail Sale Id 1293474',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 11:37:30','',''),(2192820,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 11:37:30','',''),(2192833,'1','180','934',414,'Retail Sale Id 1293480',69300.00,0.00,0.00,0.00,3080.00,'2021-12-07 11:38:37','',''),(2192834,'1','180','934',414,'Retail sales',0.00,0.00,0.00,110.00,0.00,'2021-12-07 11:38:37','',''),(2225710,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:338426',153811.00,0.00,0.00,255.50,0.00,'2021-12-10 06:56:06','',''),(2226313,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,2968200.00,5100.00,0.00,0.00,'2021-12-10 07:31:39','',''),(2226342,'1','180',NULL,414,'Reception corrector for bridging 126831',0.00,0.00,0.00,5100.00,0.00,'2021-12-10 07:33:17','',''),(2226343,'1','180','934',414,'Received from bridging 126831',0.00,0.00,5100.00,0.00,0.00,'2021-12-10 07:33:17','',''),(2226356,'1','180','934',414,'Retail Sale Id 1308971',3936.00,0.00,0.00,0.00,444.00,'2021-12-10 07:34:06','',''),(2226357,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 07:34:06','',''),(2226368,'1','180','934',414,'Retail Sale Id 1308976',1968.00,0.00,0.00,0.00,222.00,'2021-12-10 07:34:51','',''),(2226369,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:34:51','',''),(2226383,'1','180','934',414,'Retail Sale Id 1308983',3280.00,0.00,0.00,0.00,370.00,'2021-12-10 07:35:27','',''),(2226384,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 07:35:27','',''),(2231173,'1','180','934',414,'Retail Sale Id 1311171',3744.00,0.00,0.00,0.00,252.00,'2021-12-10 11:56:47','',''),(2231174,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:56:47','',''),(2233683,'1','180','934',414,'Retail Sale Id 1312316',3744.00,0.00,0.00,0.00,252.00,'2021-12-10 14:28:59','',''),(2233684,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 14:28:59','',''),(2233751,'1','180','934',414,'Retail Sale Id 1312365',1872.00,0.00,0.00,0.00,126.00,'2021-12-10 14:32:24','',''),(2233752,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 14:32:24','',''),(2233799,'1','180','934',414,'Retail Sale Id 1312392',998.40,0.00,0.00,0.00,67.20,'2021-12-10 14:34:30','',''),(2233800,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 14:34:30','',''),(2233831,'1','180','934',414,'Retail Sale Id 1312403',4992.00,0.00,0.00,0.00,336.00,'2021-12-10 14:35:58','',''),(2233832,'1','180','934',414,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-10 14:35:58','',''),(2234308,'1','180','934',414,'Retail Sale Id 1312610',4368.00,0.00,0.00,0.00,294.00,'2021-12-10 14:55:15','',''),(2234309,'1','180','934',414,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-10 14:55:15','',''),(2234348,'1','180','934',414,'Retail Sale Id 1312629',1397.76,0.00,0.00,0.00,94.08,'2021-12-10 14:57:28','',''),(2234349,'1','180','934',414,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-10 14:57:28','',''),(2235962,'1','180','934',414,'Retail Sale Id 1313416',3744.00,0.00,0.00,0.00,252.00,'2021-12-10 16:09:05','',''),(2235963,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:09:05','',''),(2236003,'1','180','934',414,'Retail Sale Id 1313439',2496.00,0.00,0.00,0.00,168.00,'2021-12-10 16:10:49','',''),(2236004,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 16:10:49','',''),(2236089,'1','180','934',414,'Retail Sale Id 1313491',1872.00,0.00,0.00,0.00,126.00,'2021-12-10 16:14:55','',''),(2236090,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:14:55','',''),(2236604,'1','180','934',414,'Retail Sale Id 1313747',1872.00,0.00,0.00,0.00,126.00,'2021-12-10 16:38:23','',''),(2236605,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:38:23','',''),(2237080,'1','180','934',414,'Retail Sale Id 1313979',3744.00,0.00,0.00,0.00,252.00,'2021-12-10 17:06:27','',''),(2237081,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 17:06:27','',''),(2237156,'1','180','934',414,'Retail Sale Id 1314014',5491.20,0.00,0.00,0.00,369.60,'2021-12-10 17:13:02','',''),(2237157,'1','180','934',414,'Retail sales',0.00,0.00,0.00,8.80,0.00,'2021-12-10 17:13:02','',''),(2237184,'1','180','934',414,'Retail Sale Id 1314030',998.40,0.00,0.00,0.00,67.20,'2021-12-10 17:15:28','',''),(2237185,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 17:15:28','',''),(2239865,'1','180','934',414,'Retail Sale Id 1315145',7800.00,0.00,0.00,0.00,525.00,'2021-12-11 07:37:11','',''),(2239866,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 07:37:11','',''),(2242183,'1','180','934',414,'Retail Sale Id 1316213',3744.00,0.00,0.00,0.00,252.00,'2021-12-11 09:21:44','',''),(2242184,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:21:44','',''),(2242207,'1','180','934',414,'Retail Sale Id 1316226',998.40,0.00,0.00,0.00,67.20,'2021-12-11 09:22:40','',''),(2242208,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 09:22:40','',''),(2242223,'1','180','934',414,'Retail Sale Id 1316235',6240.00,0.00,0.00,0.00,420.00,'2021-12-11 09:23:29','',''),(2242224,'1','180','934',414,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-11 09:23:29','',''),(2242245,'1','180','934',414,'Retail Sale Id 1316240',2496.00,0.00,0.00,0.00,168.00,'2021-12-11 09:24:38','',''),(2242246,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 09:24:39','',''),(2242259,'1','180','934',414,'Retail Sale Id 1316248',69600.00,0.00,0.00,0.00,2088.00,'2021-12-11 09:25:35','',''),(2242260,'1','180','934',414,'Retail sales',0.00,0.00,0.00,116.00,0.00,'2021-12-11 09:25:35','',''),(2244521,'1','180','934',414,'Retail Sale Id 1317327',3120.00,0.00,0.00,0.00,210.00,'2021-12-11 11:19:05','',''),(2244522,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 11:19:05','',''),(2244556,'1','180','934',414,'Retail Sale Id 1317341',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 11:20:47','',''),(2244557,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:20:47','',''),(2245652,'1','180','934',414,'Retail Sale Id 1317944',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 12:25:10','',''),(2245653,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:25:10','',''),(2245668,'1','180','934',414,'Retail Sale Id 1317954',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 12:26:15','',''),(2245669,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:26:15','',''),(2245732,'1','180','934',414,'Retail Sale Id 1317978',1248.00,0.00,0.00,0.00,84.00,'2021-12-11 12:29:33','',''),(2245733,'1','180','934',414,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 12:29:33','',''),(2246098,'1','180','934',414,'Retail Sale Id 1318169',4992.00,0.00,0.00,0.00,336.00,'2021-12-11 12:54:32','',''),(2246099,'1','180','934',414,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 12:54:33','',''),(2246533,'1','180','934',414,'Retail Sale Id 1318357',1697.28,0.00,0.00,0.00,114.24,'2021-12-11 13:25:23','',''),(2246534,'1','180','934',414,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-11 13:25:23','',''),(2246792,'1','180','934',414,'Retail Sale Id 1318473',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 13:41:13','',''),(2246793,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 13:41:13','',''),(2247026,'1','180','934',414,'Retail Sale Id 1318573',624.00,0.00,0.00,0.00,42.00,'2021-12-11 13:57:18','',''),(2247027,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-11 13:57:18','',''),(2249619,'1','180','934',414,'Retail Sale Id 1319912',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 16:14:56','',''),(2249620,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:14:56','',''),(2250449,'1','180','934',414,'Retail Sale Id 1320268',2496.00,0.00,0.00,0.00,168.00,'2021-12-11 17:00:23','',''),(2250450,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 17:00:23','',''),(2250612,'1','180','934',414,'Retail Sale Id 1320347',4992.00,0.00,0.00,0.00,336.00,'2021-12-11 17:10:54','',''),(2250613,'1','180','934',414,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-11 17:10:54','',''),(2250744,'1','180','934',414,'Retail Sale Id 1320420',998.40,0.00,0.00,0.00,67.20,'2021-12-11 17:24:08','',''),(2250745,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 17:24:08','',''),(2251274,'1','180','934',414,'Retail Sale Id 1320637',7800.00,0.00,0.00,0.00,525.00,'2021-12-11 18:10:48','',''),(2251275,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 18:10:48','',''),(2251285,'1','180','934',414,'Retail Sale Id 1320642',3744.00,0.00,0.00,0.00,252.00,'2021-12-11 18:11:42','',''),(2251286,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 18:11:42','',''),(2251299,'1','180','934',414,'Retail Sale Id 1320647',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 18:13:27','',''),(2251300,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 18:13:27','',''),(2251311,'1','180','934',414,'Retail Sale Id 1320652',1872.00,0.00,0.00,0.00,126.00,'2021-12-11 18:14:21','',''),(2251312,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 18:14:21','',''),(2251417,'1','180','934',414,'Retail Sale Id 1320700',7800.00,0.00,0.00,0.00,525.00,'2021-12-11 18:32:01','',''),(2251418,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 18:32:01','',''),(2253106,'1','180','934',414,'Retail Sale Id 1321291',3744.00,0.00,0.00,0.00,252.00,'2021-12-12 07:27:58','',''),(2253107,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 07:27:58','',''),(2257176,'1','180','934',414,'Retail Sale Id 1323343',3001.44,0.00,0.00,0.00,202.02,'2021-12-12 11:11:52','',''),(2257177,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-12 11:11:52','',''),(2258418,'1','180','934',414,'Retail Sale Id 1323957',1248.00,0.00,0.00,0.00,84.00,'2021-12-12 12:11:37','',''),(2258419,'1','180','934',414,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 12:11:37','',''),(2260414,'1','180','934',414,'Retail Sale Id 1324887',1872.00,0.00,0.00,0.00,126.00,'2021-12-12 13:47:06','',''),(2260415,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:47:06','',''),(2260428,'1','180','934',414,'Retail Sale Id 1324896',998.40,0.00,0.00,0.00,67.20,'2021-12-12 13:48:10','',''),(2260429,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 13:48:10','',''),(2260460,'1','180','934',414,'Retail Sale Id 1324897',998.40,0.00,0.00,0.00,67.20,'2021-12-12 13:49:27','',''),(2260461,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 13:49:27','',''),(2262989,'1','180','934',414,'Retail Sale Id 1325984',3001.44,0.00,0.00,0.00,202.02,'2021-12-12 16:01:31','',''),(2262990,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-12 16:01:31','',''),(2263031,'1','180','934',414,'Retail Sale Id 1326007',2502.24,0.00,0.00,0.00,168.42,'2021-12-12 16:04:06','',''),(2263032,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-12 16:04:06','',''),(2263755,'1','180','934',414,'Retail Sale Id 1326331',1872.00,0.00,0.00,0.00,126.00,'2021-12-12 16:48:24','',''),(2263756,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:48:24','',''),(2263813,'1','180','934',414,'Retail Sale Id 1326357',1872.00,0.00,0.00,0.00,126.00,'2021-12-12 16:51:00','',''),(2263814,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 16:51:00','',''),(2263833,'1','180','934',414,'Retail Sale Id 1326366',998.40,0.00,0.00,0.00,67.20,'2021-12-12 16:52:03','',''),(2263834,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 16:52:03','',''),(2263857,'1','180','934',414,'Retail Sale Id 1326379',30000.00,0.00,0.00,0.00,900.00,'2021-12-12 16:53:50','',''),(2263858,'1','180','934',414,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-12 16:53:50','',''),(2263983,'1','180','934',414,'Retail Sale Id 1326437',998.40,0.00,0.00,0.00,67.20,'2021-12-12 17:01:58','',''),(2263984,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 17:01:58','',''),(2264481,'1','180','934',414,'Retail Sale Id 1326660',998.40,0.00,0.00,0.00,67.20,'2021-12-12 18:02:45','',''),(2264482,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 18:02:45','',''),(2265881,'1','180','934',414,'Retail Sale Id 1327067',3744.00,0.00,0.00,0.00,252.00,'2021-12-13 07:06:46','',''),(2265882,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 07:06:46','',''),(2265899,'1','180','934',414,'Retail Sale Id 1327080',7800.00,0.00,0.00,0.00,525.00,'2021-12-13 07:07:40','',''),(2265900,'1','180','934',414,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 07:07:40','',''),(2272106,'1','180','934',414,'Retail Sale Id 1330003',69600.00,0.00,0.00,0.00,2088.00,'2021-12-13 13:34:01','',''),(2272107,'1','180','934',414,'Retail sales',0.00,0.00,0.00,116.00,0.00,'2021-12-13 13:34:01','',''),(2273243,'1','180','934',414,'Retail Sale Id 1330573',998.40,0.00,0.00,0.00,67.20,'2021-12-13 14:38:35','',''),(2273244,'1','180','934',414,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-13 14:38:35','',''),(2273261,'1','180','934',414,'Retail Sale Id 1330582',3744.00,0.00,0.00,0.00,252.00,'2021-12-13 14:39:34','',''),(2273262,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 14:39:34','',''),(2273279,'1','180','934',414,'Retail Sale Id 1330591',2496.00,0.00,0.00,0.00,168.00,'2021-12-13 14:40:56','',''),(2273280,'1','180','934',414,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 14:40:56','',''),(2273314,'1','180','934',414,'Retail Sale Id 1330603',3744.00,0.00,0.00,0.00,252.00,'2021-12-13 14:42:41','',''),(2273315,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 14:42:41','',''),(2273352,'1','180','934',414,'Retail Sale Id 1330624',2003.04,0.00,0.00,0.00,134.82,'2021-12-13 14:45:08','',''),(2273353,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-13 14:45:08','',''),(2273403,'1','180','934',414,'Retail Sale Id 1330653',1872.00,0.00,0.00,0.00,126.00,'2021-12-13 14:49:09','',''),(2273404,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 14:49:09','',''),(2274367,'1','180','934',414,'Retail Sale Id 1331102',30000.00,0.00,0.00,0.00,900.00,'2021-12-13 15:40:16','',''),(2274368,'1','180','934',414,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-13 15:40:16','',''),(2275767,'1','180','934',414,'Retail Sale Id 1331825',1872.00,0.00,0.00,0.00,126.00,'2021-12-13 17:00:40','',''),(2275768,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 17:00:40','',''),(2275785,'1','180','934',414,'Retail Sale Id 1331832',3744.00,0.00,0.00,0.00,252.00,'2021-12-13 17:01:26','',''),(2275786,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 17:01:26','',''),(2275809,'1','180','934',414,'Retail Sale Id 1331835',3744.00,0.00,0.00,0.00,252.00,'2021-12-13 17:02:26','',''),(2275810,'1','180','934',414,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 17:02:26','',''),(2277748,'1','180','934',414,'Retail Sale Id 1332454',1848.00,0.00,0.00,0.00,102.00,'2021-12-14 07:00:34','',''),(2277749,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:00:34','',''),(2277756,'1','180','934',414,'Retail Sale Id 1332457',1848.00,0.00,0.00,0.00,102.00,'2021-12-14 07:01:14','',''),(2277757,'1','180','934',414,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:01:14','',''),(2281868,'1','180','934',414,'Retail Sale Id 1334653',91200.00,0.00,0.00,0.00,-1920.00,'2021-12-14 10:43:35','',''),(2281869,'1','180','934',414,'Retail sales',0.00,0.00,0.00,160.00,0.00,'2021-12-14 10:43:35','',''),(2282277,'1','180','934',414,'Retail Sale Id 1334875',3080.00,0.00,0.00,0.00,170.00,'2021-12-14 11:09:03','',''),(2282278,'1','180','934',414,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 11:09:03','',''),(2282457,'1','180','934',414,'Retail Sale Id 1335337',3080.00,0.00,0.00,5.00,170.00,'2021-12-14 12:21:11','',''),(2282716,'1','180','934',414,'Retail Sale Id 1335567',3498.88,0.00,0.00,5.68,193.12,'2021-12-14 12:57:23','',''),(2282753,'1','180','934',414,'Retail Sale Id 1335600',1848.00,0.00,0.00,3.00,102.00,'2021-12-14 13:02:00','',''),(2282765,'1','180','934',414,'Retail Sale Id 1335613',1848.00,0.00,0.00,3.00,102.00,'2021-12-14 13:03:59','',''),(2283174,'1','180','934',414,'Retail Sale Id 1335930',33060.00,0.00,0.00,58.00,-696.00,'2021-12-14 13:53:09','',''),(2284926,'1','180','934',414,'Retail Sale Id 1337230',1848.00,0.00,0.00,3.00,102.00,'2021-12-14 16:48:06','',''),(2285093,'1','180','934',414,'Retail Sale Id 1337376',548.24,0.00,0.00,0.89,30.26,'2021-12-14 17:07:35','',''),(2286842,'1','180','934',414,'Retail Sale Id 1338438',1232.00,0.00,0.00,2.00,68.00,'2021-12-15 07:56:15','',''),(2288019,'1','180','934',414,'Retail Sale Id 1339385',3696.00,0.00,0.00,6.00,204.00,'2021-12-15 09:58:10','',''),(2288022,'1','180','934',414,'Retail Sale Id 1339390',1848.00,0.00,0.00,3.00,102.00,'2021-12-15 09:58:50','',''),(2288028,'1','180','934',414,'Retail Sale Id 1339395',33060.00,0.00,0.00,58.00,-696.00,'2021-12-15 09:59:49','',''),(2288492,'1','180','934',414,'Retail Sale Id 1339788',5544.00,0.00,0.00,9.00,306.00,'2021-12-15 11:00:07','',''),(2288794,'1','180','934',414,'Retail Sale Id 1340044',2464.00,0.00,0.00,4.00,136.00,'2021-12-15 11:33:46','',''),(2291186,'1','180','934',414,'Retail Sale Id 1341917',2999.92,0.00,0.00,4.87,165.58,'2021-12-15 15:42:18','',''),(2291195,'1','180','934',414,'Retail Sale Id 1341925',1848.00,0.00,0.00,3.00,102.00,'2021-12-15 15:43:19','',''),(2291957,'1','180','934',414,'Retail Sale Id 1342609',3696.00,0.00,0.00,6.00,204.00,'2021-12-15 16:50:20','',''),(2291973,'1','180','934',414,'Retail Sale Id 1342622',1848.00,0.00,0.00,3.00,102.00,'2021-12-15 16:51:43','',''),(2292202,'1','180','934',414,'Retail Sale Id 1342820',1848.00,0.00,0.00,3.00,102.00,'2021-12-15 17:17:49','',''),(2292253,'1','180','934',414,'Retail Sale Id 1342866',3696.00,0.00,0.00,6.00,204.00,'2021-12-15 17:26:00','',''),(2292557,'1','180','934',414,'Retail Sale Id 1343074',6160.00,0.00,0.00,10.00,340.00,'2021-12-15 18:18:25','',''),(2294549,'1','180','934',414,'Retail Sale Id 1344323',1848.00,0.00,0.00,3.00,102.00,'2021-12-16 08:19:35','',''),(2294585,'1','180','934',414,'Retail Sale Id 1344370',3696.00,0.00,0.00,6.00,204.00,'2021-12-16 08:22:19','',''),(2294645,'1','180','934',414,'Retail Sale Id 1344404',3080.00,0.00,0.00,5.00,170.00,'2021-12-16 08:25:54','',''),(2294674,'1','180','934',414,'Retail Sale Id 1344426',1848.00,0.00,0.00,3.00,102.00,'2021-12-16 08:28:37','',''),(2294787,'1','180','934',414,'Retail Sale Id 1344518',3696.00,0.00,0.00,6.00,204.00,'2021-12-16 08:38:28','',''),(2294858,'1','180','934',414,'Retail Sale Id 1344549',3080.00,0.00,0.00,5.00,170.00,'2021-12-16 08:41:23','',''),(2294892,'1','180','934',414,'Retail Sale Id 1344575',997.92,0.00,0.00,1.62,55.08,'2021-12-16 08:44:09','',''),(2296070,'1','180','934',414,'Retail Sale Id 1345548',7700.00,0.00,0.00,12.50,425.00,'2021-12-16 10:32:52','',''),(2296612,'1','180','934',414,'Retail Sale Id 1346055',5901.28,0.00,0.00,9.58,325.72,'2021-12-16 11:35:38','',''),(2296647,'1','180','934',414,'Retail Sale Id 1346090',1232.00,0.00,0.00,2.00,68.00,'2021-12-16 11:39:30','',''),(2296721,'1','180','934',414,'Retail Sale Id 1346160',1798.72,0.00,0.00,2.92,99.28,'2021-12-16 11:48:23','',''),(2296753,'1','180','934',414,'Retail Sale Id 1346191',33060.00,0.00,0.00,58.00,-696.00,'2021-12-16 11:52:22','',''),(2297080,'1','180','934',414,'Retail Sale Id 1346467',1232.00,0.00,0.00,2.00,68.00,'2021-12-16 12:30:15','',''),(2297749,'1','180','934',414,'Retail Sale Id 1347044',924.00,0.00,0.00,1.50,51.00,'2021-12-16 13:41:24','',''),(2298303,'1','180','934',414,'Retail Sale Id 1347487',11704.00,0.00,0.00,19.00,646.00,'2021-12-16 14:33:38','',''),(2298588,'1','180','934',414,'Retail Sale Id 1347648',1848.00,0.00,0.00,3.00,102.00,'2021-12-16 14:51:46','',''),(2298629,'1','180','934',414,'Retail Sale Id 1347685',1232.00,0.00,0.00,2.00,68.00,'2021-12-16 14:56:57','',''),(2299537,'1','180','934',414,'Retail Sale Id 1348384',3696.00,0.00,0.00,6.00,204.00,'2021-12-16 16:08:16','',''),(2299573,'1','180','934',414,'Retail Sale Id 1348403',997.92,0.00,0.00,1.62,55.08,'2021-12-16 16:09:52','',''),(2302220,'1','180','934',414,'Retail Sale Id 1350140',3080.00,0.00,0.00,5.00,170.00,'2021-12-17 07:49:51','',''),(2302247,'1','180','934',414,'Retail Sale Id 1350165',3080.00,0.00,0.00,5.00,170.00,'2021-12-17 07:52:18','',''),(2302883,'1','180','934',414,'Retail Sale Id 1350694',3696.00,0.00,0.00,6.00,204.00,'2021-12-17 08:48:35','',''),(2302903,'1','180','934',414,'Retail Sale Id 1350717',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 08:50:31','',''),(2303987,'1','180','934',414,'Retail Sale Id 1351578',3696.00,0.00,0.00,6.00,204.00,'2021-12-17 10:28:01','',''),(2304001,'1','180','934',414,'Retail Sale Id 1351590',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 10:29:49','',''),(2304017,'1','180','934',414,'Retail Sale Id 1351606',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 10:31:38','',''),(2304070,'1','180','934',414,'Retail Sale Id 1351649',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 10:37:11','',''),(2304308,'1','180','934',414,'Retail Sale Id 1351881',2464.00,0.00,0.00,4.00,136.00,'2021-12-17 11:04:52','',''),(2304362,'1','180','934',414,'Retail Sale Id 1351934',616000.00,0.00,0.00,1000.00,34000.00,'2021-12-17 11:10:41','',''),(2304412,'1','180','934',414,'Retail Sale Id 1351981',924.00,0.00,0.00,1.50,51.00,'2021-12-17 11:15:38','',''),(2304584,'1','180','934',414,'Retail Sale Id 1352127',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 11:28:58','',''),(2304844,'1','180','934',414,'Return of Retail Sale Id 1351934',0.00,616000.00,1000.00,0.00,-34000.00,'2021-12-17 12:00:03','',''),(2304887,'1','180','934',414,'Retail Sale Id 1352410',997.92,0.00,0.00,1.62,55.08,'2021-12-17 12:04:21','',''),(2305100,'1','180','934',414,'Retail Sale Id 1352607',3498.88,0.00,0.00,5.68,193.12,'2021-12-17 12:36:00','',''),(2305109,'1','180','934',414,'Retail Sale Id 1352615',1503.04,0.00,0.00,2.44,82.96,'2021-12-17 12:37:15','',''),(2305780,'1','180','934',414,'Retail Sale Id 1353207',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 14:01:33','',''),(2305838,'1','180','934',414,'Retail Sale Id 1353247',7700.00,0.00,0.00,12.50,425.00,'2021-12-17 14:06:34','',''),(2305852,'1','180','934',414,'Retail Sale Id 1353259',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 14:07:43','',''),(2306035,'1','180','934',414,'Retail Sale Id 1353421',2999.92,0.00,0.00,4.87,165.58,'2021-12-17 14:30:54','',''),(2306400,'1','180','934',414,'Retail Sale Id 1353676',3080.00,0.00,0.00,5.00,170.00,'2021-12-17 14:56:53','',''),(2307089,'1','180','934',414,'Retail Sale Id 1354236',3696.00,0.00,0.00,6.00,204.00,'2021-12-17 15:51:17','',''),(2307145,'1','180','934',414,'Retail Sale Id 1354296',4502.96,0.00,0.00,7.31,248.54,'2021-12-17 15:56:31','',''),(2307316,'1','180','934',414,'Retail Sale Id 1354476',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 16:12:34','',''),(2307446,'1','180','934',414,'Retail Sale Id 1354612',3696.00,0.00,0.00,6.00,204.00,'2021-12-17 16:23:21','',''),(2307493,'1','180','934',414,'Retail Sale Id 1354660',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 16:28:38','',''),(2307519,'1','180','934',414,'Retail Sale Id 1354684',3997.84,0.00,0.00,6.49,220.66,'2021-12-17 16:30:40','',''),(2307742,'1','180','934',414,'Retail Sale Id 1354880',1848.00,0.00,0.00,3.00,102.00,'2021-12-17 16:51:59','',''),(2307774,'1','180','934',414,'Retail Sale Id 1354910',2199.12,0.00,0.00,3.57,121.38,'2021-12-17 16:55:33','',''),(2307785,'1','180','934',414,'Retail Sale Id 1354920',2500.96,0.00,0.00,4.06,138.04,'2021-12-17 16:57:00','',''),(2309875,'1','180','934',414,'Retail Sale Id 1356139',997.92,0.00,0.00,1.62,55.08,'2021-12-18 07:33:51','',''),(2310588,'1','180','934',414,'Retail Sale Id 1356694',3696.00,0.00,0.00,6.00,204.00,'2021-12-18 08:29:28','',''),(2310674,'1','180','934',414,'Retail Sale Id 1356769',3080.00,0.00,0.00,5.00,170.00,'2021-12-18 08:36:47','',''),(2310694,'1','180','934',414,'Retail Sale Id 1356780',1848.00,0.00,0.00,3.00,102.00,'2021-12-18 08:38:29','',''),(2311075,'1','180','934',414,'Retail Sale Id 1357131',142500.00,0.00,0.00,250.00,-3000.00,'2021-12-18 09:10:15','',''),(2311985,'1','180','934',414,'Retail Sale Id 1357893',1848.00,0.00,0.00,3.00,102.00,'2021-12-18 10:28:48','',''),(2312456,'1','180','934',414,'Retail Sale Id 1358320',3696.00,0.00,0.00,6.00,204.00,'2021-12-18 11:06:28','',''),(2312679,'1','180','934',414,'Retail Sale Id 1358484',3696.00,0.00,0.00,6.00,204.00,'2021-12-18 11:22:00','',''),(2312694,'1','180','934',414,'Retail Sale Id 1358511',5001.92,0.00,0.00,8.12,276.08,'2021-12-18 11:23:20','',''),(2312983,'1','180','934',414,'Retail Sale Id 1358790',2698.08,0.00,0.00,4.38,148.92,'2021-12-18 11:49:24','',''),(2313118,'1','180','934',414,'Retail Sale Id 1358918',997.92,0.00,0.00,1.62,55.08,'2021-12-18 12:06:11','',''),(2313189,'1','180','934',414,'Retail Sale Id 1358985',33060.00,0.00,0.00,58.00,-696.00,'2021-12-18 12:12:55','',''),(2313276,'1','180','934',414,'Retail Sale Id 1359072',3080.00,0.00,0.00,5.00,170.00,'2021-12-18 12:21:37','',''),(2313524,'1','180','934',414,'Retail Sale Id 1359296',6160.00,0.00,0.00,10.00,340.00,'2021-12-18 12:46:02','',''),(2313584,'1','180','934',414,'Retail Sale Id 1359357',3696.00,0.00,0.00,6.00,204.00,'2021-12-18 12:52:13','',''),(2313960,'1','180','934',414,'Retail Sale Id 1359672',3696.00,0.00,0.00,6.00,204.00,'2021-12-18 13:24:33','',''),(2314279,'1','180','934',414,'Retail Sale Id 1359921',1848.00,0.00,0.00,3.00,102.00,'2021-12-18 13:50:28','',''),(2314844,'1','180','934',414,'Retail Sale Id 1360373',997.92,0.00,0.00,1.62,55.08,'2021-12-18 14:33:44','',''),(2314953,'1','180','934',414,'Retail Sale Id 1360461',1848.00,0.00,0.00,3.00,102.00,'2021-12-18 14:43:00','',''),(2315089,'1','180','934',414,'Retail Sale Id 1360573',1848.00,0.00,0.00,3.00,102.00,'2021-12-18 14:53:45','',''),(2316478,'1','180','934',414,'Retail Sale Id 1361780',7392.00,0.00,0.00,12.00,408.00,'2021-12-18 16:33:06','',''),(2316528,'1','180','934',414,'Retail Sale Id 1361838',4928.00,0.00,0.00,8.00,272.00,'2021-12-18 16:37:17','',''),(2316932,'1','180','934',414,'Retail Sale Id 1362223',7392.00,0.00,0.00,12.00,408.00,'2021-12-18 17:11:28','',''),(2316994,'1','180','934',414,'Retail Sale Id 1362279',7700.00,0.00,0.00,12.50,425.00,'2021-12-18 17:19:25','',''),(2317049,'1','180','934',414,'Retail Sale Id 1362337',2002.00,0.00,0.00,3.25,110.50,'2021-12-18 17:27:22','',''),(2318875,'1','180','934',414,'Retail Sale Id 1363595',3080.00,0.00,0.00,5.00,170.00,'2021-12-19 07:52:00','',''),(2319805,'1','180','934',414,'Retail Sale Id 1364302',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 09:12:44','',''),(2320212,'1','180','934',414,'Retail Sale Id 1364529',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 09:32:36','',''),(2320404,'1','180','934',414,'Retail Sale Id 1364726',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 09:49:11','',''),(2320561,'1','180','934',414,'Retail Sale Id 1364884',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 10:02:33','',''),(2321025,'1','180','934',414,'Retail Sale Id 1365333',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 10:39:39','',''),(2321245,'1','180','934',414,'Retail Sale Id 1365556',34200.00,0.00,0.00,60.00,-720.00,'2021-12-19 10:58:51','',''),(2322252,'1','180','934',414,'Retail Sale Id 1366508',28500.00,0.00,0.00,50.00,-600.00,'2021-12-19 12:22:11','',''),(2322351,'1','180','934',414,'Retail Sale Id 1366604',3080.00,0.00,0.00,5.00,170.00,'2021-12-19 12:33:27','',''),(2322502,'1','180','934',414,'Retail Sale Id 1366725',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 12:46:36','',''),(2322544,'1','180','934',414,'Retail Sale Id 1366768',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 12:49:51','',''),(2323045,'1','180','934',414,'Retail Sale Id 1367217',7392.00,0.00,0.00,12.00,408.00,'2021-12-19 13:32:39','',''),(2323265,'1','180','934',414,'Retail Sale Id 1367382',1503.04,0.00,0.00,2.44,82.96,'2021-12-19 13:49:32','',''),(2323330,'1','180','934',414,'Retail Sale Id 1367432',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 13:53:56','',''),(2323348,'1','180','934',414,'Retail Sale Id 1367453',1503.04,0.00,0.00,2.44,82.96,'2021-12-19 13:55:21','',''),(2323524,'1','180','934',414,'Retail Sale Id 1367602',997.92,0.00,0.00,1.62,55.08,'2021-12-19 14:06:13','',''),(2323756,'1','180','934',414,'Retail Sale Id 1367791',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 14:24:00','',''),(2324110,'1','180','934',414,'Retail Sale Id 1368119',3696.00,0.00,0.00,6.00,204.00,'2021-12-19 14:58:47','',''),(2324577,'1','180','934',414,'Retail Sale Id 1368542',1848.00,0.00,0.00,3.00,102.00,'2021-12-19 15:46:36','',''),(2324803,'1','180','934',414,'Retail Sale Id 1368735',1232.00,0.00,0.00,2.00,68.00,'2021-12-19 16:05:01','',''),(2325305,'1','180','934',414,'Retail Sale Id 1369131',1232.00,0.00,0.00,2.00,68.00,'2021-12-19 16:53:17','',''),(2325569,'1','180','934',414,'Retail Sale Id 1369346',3696.00,0.00,0.00,6.00,204.00,'2021-12-19 17:27:14','',''),(2325803,'1','180','934',414,'Retail Sale Id 1369545',1232.00,0.00,0.00,2.00,68.00,'2021-12-19 18:59:31','',''),(2327622,'1','180','934',414,'Retail Sale Id 1370731',3080.00,0.00,0.00,5.00,170.00,'2021-12-20 09:10:46','',''),(2327777,'1','180','934',414,'Retail Sale Id 1370842',1848.00,0.00,0.00,3.00,102.00,'2021-12-20 09:28:17','',''),(2327972,'1','180','934',414,'Retail Sale Id 1370998',1848.00,0.00,0.00,3.00,102.00,'2021-12-20 09:52:31','',''),(2328064,'1','180','934',414,'Retail Sale Id 1371055',33060.00,0.00,0.00,58.00,-696.00,'2021-12-20 10:02:02','',''),(2329867,'1','180','934',414,'Retail Sale Id 1372609',2464.00,0.00,0.00,4.00,136.00,'2021-12-20 13:11:14','',''),(2331061,'1','180','934',414,'Retail Sale Id 1373407',3696.00,0.00,0.00,6.00,204.00,'2021-12-20 14:51:53','',''),(2331077,'1','180','934',414,'Retail Sale Id 1373423',4312.00,0.00,0.00,7.00,238.00,'2021-12-20 14:53:05','',''),(2332008,'1','180','934',414,'Retail Sale Id 1374242',2457.84,0.00,0.00,3.99,135.66,'2021-12-20 16:25:23','',''),(2332047,'1','180','934',414,'Retail Sale Id 1374267',1232.00,0.00,0.00,2.00,68.00,'2021-12-20 16:29:05','',''),(2332065,'1','180','934',414,'Retail Sale Id 1374282',2464.00,0.00,0.00,4.00,136.00,'2021-12-20 16:30:53','',''),(2332338,'1','180','934',414,'Retail Sale Id 1374547',1232.00,0.00,0.00,2.00,68.00,'2021-12-20 16:59:18','',''),(2332440,'1','180','934',414,'Retail Sale Id 1374623',1848.00,0.00,0.00,3.00,102.00,'2021-12-20 17:11:22','',''),(2332579,'1','180','934',414,'Retail Sale Id 1374742',2002.00,0.00,0.00,3.25,110.50,'2021-12-20 17:34:00','',''),(2335821,'1','180','934',414,'Retail Sale Id 1377004',3080.00,0.00,0.00,5.00,170.00,'2021-12-21 10:48:42','',''),(2335834,'1','180','934',414,'Retail Sale Id 1377018',2002.00,0.00,0.00,3.25,110.50,'2021-12-21 10:50:33','',''),(2335864,'1','180','934',414,'Retail Sale Id 1377048',1848.00,0.00,0.00,3.00,102.00,'2021-12-21 10:54:25','',''),(2335897,'1','180','934',414,'Retail Sale Id 1377063',2002.00,0.00,0.00,3.25,110.50,'2021-12-21 10:56:02','',''),(2335914,'1','180','934',414,'Retail Sale Id 1377078',2464.00,0.00,0.00,4.00,136.00,'2021-12-21 10:57:42','',''),(2335925,'1','180','934',414,'Retail Sale Id 1377091',2464.00,0.00,0.00,4.00,136.00,'2021-12-21 10:59:06','',''),(2335957,'1','180','934',414,'Retail Sale Id 1377117',3696.00,0.00,0.00,6.00,204.00,'2021-12-21 11:02:16','',''),(2335978,'1','180','934',414,'Retail Sale Id 1377130',3080.00,0.00,0.00,5.00,170.00,'2021-12-21 11:03:53','',''),(2336084,'1','180','934',414,'Retail Sale Id 1377226',1848.00,0.00,0.00,3.00,102.00,'2021-12-21 11:14:54','',''),(2336098,'1','180','934',414,'Retail Sale Id 1377238',3696.00,0.00,0.00,6.00,204.00,'2021-12-21 11:16:23','',''),(2336132,'1','180','934',414,'Retail Sale Id 1377267',3696.00,0.00,0.00,6.00,204.00,'2021-12-21 11:19:43','',''),(2336148,'1','180','934',414,'Retail Sale Id 1377283',7392.00,0.00,0.00,12.00,408.00,'2021-12-21 11:21:45','',''),(2336157,'1','180','934',414,'Retail Sale Id 1377294',2002.00,0.00,0.00,3.25,110.50,'2021-12-21 11:22:51','',''),(2336246,'1','180','934',414,'Retail Sale Id 1377365',1232.00,0.00,0.00,2.00,68.00,'2021-12-21 11:32:44','',''),(2336302,'1','180','934',414,'Retail Sale Id 1377414',33060.00,0.00,0.00,58.00,-696.00,'2021-12-21 11:40:44','',''),(2336313,'1','180','934',414,'Retail Sale Id 1377425',33060.00,0.00,0.00,58.00,-696.00,'2021-12-21 11:42:04','',''),(2336571,'1','180','934',414,'Retail Sale Id 1377644',4312.00,0.00,0.00,7.00,238.00,'2021-12-21 12:14:28','',''),(2336601,'1','180','934',414,'Retail Sale Id 1377674',1848.00,0.00,0.00,3.00,102.00,'2021-12-21 12:18:16','',''),(2336634,'1','180','934',414,'Retail Sale Id 1377705',2008.16,0.00,0.00,3.26,110.84,'2021-12-21 12:21:29','',''),(2336657,'1','180','934',414,'Retail Sale Id 1377726',616.00,0.00,0.00,1.00,34.00,'2021-12-21 12:24:01','',''),(2336754,'1','180','934',414,'Retail Sale Id 1377810',28500.00,0.00,0.00,50.00,-600.00,'2021-12-21 12:35:26','',''),(2336910,'1','180','934',414,'Retail Sale Id 1377976',1232.00,0.00,0.00,2.00,68.00,'2021-12-21 12:54:09','',''),(2336938,'1','180','934',414,'Retail Sale Id 1377996',997.92,0.00,0.00,1.62,55.08,'2021-12-21 12:56:30','',''),(2337077,'1','180','934',414,'Retail Sale Id 1378113',1848.00,0.00,0.00,3.00,102.00,'2021-12-21 13:10:17','',''),(2337809,'1','180','934',414,'Retail Sale Id 1378695',3696.00,0.00,0.00,6.00,204.00,'2021-12-21 14:15:02','',''),(2337892,'1','180','934',414,'Retail Sale Id 1378726',1848.00,0.00,0.00,3.00,102.00,'2021-12-21 14:19:17','',''),(2338377,'1','180','934',414,'Retail Sale Id 1379158',2002.00,0.00,0.00,3.25,110.50,'2021-12-21 14:58:44','',''),(2338393,'1','180','934',414,'Retail Sale Id 1379165',2002.00,0.00,0.00,3.25,110.50,'2021-12-21 14:59:45','',''),(2338405,'1','180','934',414,'Retail Sale Id 1379177',997.92,0.00,0.00,1.62,55.08,'2021-12-21 15:00:42','',''),(2338954,'1','180','934',414,'Retail Sale Id 1379625',3696.00,0.00,0.00,6.00,204.00,'2021-12-21 15:42:17','',''),(2339787,'1','180','934',414,'Retail Sale Id 1380387',2999.92,0.00,0.00,4.87,165.58,'2021-12-21 16:43:52','',''),(2340059,'1','180','934',414,'Retail Sale Id 1380647',1503.04,0.00,0.00,2.44,82.96,'2021-12-21 17:09:03','',''),(2340106,'1','180','934',414,'Retail Sale Id 1380692',997.92,0.00,0.00,1.62,55.08,'2021-12-21 17:14:06','',''),(2340183,'1','180','934',414,'Retail Sale Id 1380758',1848.00,0.00,0.00,3.00,102.00,'2021-12-21 17:23:38','',''),(2343256,'1','180','934',414,'Retail Sale Id 1382861',1848.00,0.00,0.00,3.00,102.00,'2021-12-22 09:00:09','',''),(2344813,'1','180','934',414,'Retail Sale Id 1384357',2002.00,0.00,0.00,3.25,110.50,'2021-12-22 11:24:07','',''),(2344823,'1','180','934',414,'Retail Sale Id 1384371',1232.00,0.00,0.00,2.00,68.00,'2021-12-22 11:25:17','',''),(2345099,'1','180','934',414,'Retail Sale Id 1384634',1848.00,0.00,0.00,3.00,102.00,'2021-12-22 11:52:36','',''),(2345565,'1','180','934',414,'Retail Sale Id 1385050',5544.00,0.00,0.00,9.00,306.00,'2021-12-22 12:41:36','',''),(2345738,'1','180','934',414,'Retail Sale Id 1385184',3696.00,0.00,0.00,6.00,204.00,'2021-12-22 12:57:23','',''),(2345809,'1','180','934',414,'Retail Sale Id 1385257',2999.92,0.00,0.00,4.87,165.58,'2021-12-22 13:06:03','',''),(2347520,'1','180','934',414,'Retail Sale Id 1386513',1848.00,0.00,0.00,3.00,102.00,'2021-12-22 15:38:14','',''),(2347546,'1','180','934',414,'Retail Sale Id 1386536',3696.00,0.00,0.00,6.00,204.00,'2021-12-22 15:39:49','',''),(2348254,'1','180','934',414,'Retail Sale Id 1387141',2999.92,0.00,0.00,4.87,165.58,'2021-12-22 16:46:53','',''),(2351586,'1','180','934',414,'Retail Sale Id 1389513',2999.92,0.00,0.00,4.87,165.58,'2021-12-23 09:26:24','',''),(2354622,'1','180','934',414,'Retail Sale Id 1392232',5544.00,0.00,0.00,9.00,306.00,'2021-12-23 13:44:09','',''),(2354642,'1','180','934',414,'Retail Sale Id 1392252',997.92,0.00,0.00,1.62,55.08,'2021-12-23 13:45:47','',''),(2354651,'1','180','934',414,'Retail Sale Id 1392262',3696.00,0.00,0.00,6.00,204.00,'2021-12-23 13:46:50','',''),(2354713,'1','180','934',414,'Retail Sale Id 1392313',3696.00,0.00,0.00,6.00,204.00,'2021-12-23 13:50:27','',''),(2354740,'1','180','934',414,'Retail Sale Id 1392332',3696.00,0.00,0.00,6.00,204.00,'2021-12-23 13:52:12','',''),(2354765,'1','180','934',414,'Retail Sale Id 1392345',2500.96,0.00,0.00,4.06,138.04,'2021-12-23 13:53:54','',''),(2354778,'1','180','934',414,'Retail Sale Id 1392354',1848.00,0.00,0.00,3.00,102.00,'2021-12-23 13:55:13','',''),(2354805,'1','180','934',414,'Retail Sale Id 1392371',3080.00,0.00,0.00,5.00,170.00,'2021-12-23 13:57:15','',''),(2355230,'1','180','934',414,'Retail Sale Id 1392602',5999.84,0.00,0.00,9.74,331.16,'2021-12-23 14:20:58','',''),(2355396,'1','180','934',414,'Retail Sale Id 1392734',3696.00,0.00,0.00,6.00,204.00,'2021-12-23 14:35:38','',''),(2355607,'1','180','934',414,'Retail Sale Id 1392937',1848.00,0.00,0.00,3.00,102.00,'2021-12-23 14:57:28','',''),(2355967,'1','180','934',414,'Retail Sale Id 1393276',1798.72,0.00,0.00,2.92,99.28,'2021-12-23 15:29:24','',''),(2356097,'1','180','934',414,'Retail Sale Id 1393390',3080.00,0.00,0.00,5.00,170.00,'2021-12-23 15:40:27','',''),(2356117,'1','180','934',414,'Retail Sale Id 1393409',1798.72,0.00,0.00,2.92,99.28,'2021-12-23 15:41:55','',''),(2356249,'1','180','934',414,'Retail Sale Id 1393548',997.92,0.00,0.00,1.62,55.08,'2021-12-23 15:54:17','',''),(2356407,'1','180','934',414,'Retail Sale Id 1393698',33060.00,0.00,0.00,58.00,-696.00,'2021-12-23 16:07:49','',''),(2362179,'1','180','934',414,'Retail Sale Id 1398337',1848.00,0.00,0.00,3.00,102.00,'2021-12-24 11:18:52','',''),(2362198,'1','180','934',414,'Retail Sale Id 1398354',1232.00,0.00,0.00,2.00,68.00,'2021-12-24 11:21:01','',''),(2362212,'1','180','934',414,'Retail Sale Id 1398368',1848.00,0.00,0.00,3.00,102.00,'2021-12-24 11:22:27','',''),(2362224,'1','180','934',414,'Retail Sale Id 1398380',7700.00,0.00,0.00,12.50,425.00,'2021-12-24 11:23:48','',''),(2362234,'1','180','934',414,'Retail Sale Id 1398393',2002.00,0.00,0.00,3.25,110.50,'2021-12-24 11:25:05','',''),(2362277,'1','180','934',414,'Retail Sale Id 1398435',997.92,0.00,0.00,1.62,55.08,'2021-12-24 11:30:08','',''),(2362308,'1','180','934',414,'Retail Sale Id 1398464',3696.00,0.00,0.00,6.00,204.00,'2021-12-24 11:32:10','',''),(2362323,'1','180','934',414,'Retail Sale Id 1398479',3696.00,0.00,0.00,6.00,204.00,'2021-12-24 11:33:24','',''),(2362338,'1','180','934',414,'Retail Sale Id 1398495',3696.00,0.00,0.00,6.00,204.00,'2021-12-24 11:35:05','',''),(2362382,'1','180','934',414,'Retail Sale Id 1398520',3080.00,0.00,0.00,5.00,170.00,'2021-12-24 11:36:55','',''),(2362400,'1','180','934',414,'Retail Sale Id 1398540',1848.00,0.00,0.00,3.00,102.00,'2021-12-24 11:38:10','',''),(2362431,'1','180','934',414,'Retail Sale Id 1398568',2999.92,0.00,0.00,4.87,165.58,'2021-12-24 11:40:39','',''),(2364601,'1','180','934',414,'Retail Sale Id 1400439',3696.00,0.00,0.00,6.00,204.00,'2021-12-24 14:45:54','',''),(2364638,'1','180','934',414,'Retail Sale Id 1400463',997.92,0.00,0.00,1.62,55.08,'2021-12-24 14:48:23','',''),(2364652,'1','180','934',414,'Retail Sale Id 1400473',1848.00,0.00,0.00,3.00,102.00,'2021-12-24 14:49:14','',''),(2364681,'1','180','934',414,'Retail Sale Id 1400497',1848.00,0.00,0.00,3.00,102.00,'2021-12-24 14:51:13','',''),(2364715,'1','180','934',414,'Retail Sale Id 1400505',997.92,0.00,0.00,1.62,55.08,'2021-12-24 14:52:08','',''),(2365349,'1','180','934',414,'Retail Sale Id 1401042',2999.92,0.00,0.00,4.87,165.58,'2021-12-24 15:39:03','',''),(2366758,'1','180','934',414,'Retail Sale Id 1402259',3997.84,0.00,0.00,6.49,220.66,'2021-12-24 17:17:06','',''),(2371081,'1','180','934',414,'Retail Sale Id 1405724',5500.88,0.00,0.00,8.93,303.62,'2021-12-25 10:51:34','',''),(2371403,'1','180','934',414,'Retail Sale Id 1406015',28500.00,0.00,0.00,50.00,-600.00,'2021-12-25 11:21:43','',''),(2371513,'1','180','934',414,'Retail Sale Id 1406243',2999.92,0.00,0.00,4.87,165.58,'2021-12-25 11:35:44','',''),(2371524,'1','180','934',414,'Retail Sale Id 1406254',7700.00,0.00,0.00,12.50,425.00,'2021-12-25 11:37:10','',''),(2371538,'1','180','934',414,'Retail Sale Id 1406270',3696.00,0.00,0.00,6.00,204.00,'2021-12-25 11:38:31','',''),(2371656,'1','180','934',414,'Retail Sale Id 1406373',28500.00,0.00,0.00,50.00,-600.00,'2021-12-25 11:51:47','',''),(2371671,'1','180','934',414,'Retail Sale Id 1406388',1848.00,0.00,0.00,3.00,102.00,'2021-12-25 11:53:25','',''),(2371840,'1','180','934',414,'Retail Sale Id 1406550',2999.92,0.00,0.00,4.87,165.58,'2021-12-25 12:15:50','',''),(2371970,'1','180','934',414,'Retail Sale Id 1406685',6160.00,0.00,0.00,10.00,340.00,'2021-12-25 12:30:25','',''),(2372023,'1','180','934',414,'Retail Sale Id 1406736',5001.92,0.00,0.00,8.12,276.08,'2021-12-25 12:36:21','',''),(2372538,'1','180','934',414,'Retail Sale Id 1407128',3696.00,0.00,0.00,6.00,204.00,'2021-12-25 13:25:27','',''),(2373304,'1','180','934',414,'Retail Sale Id 1407577',2002.00,0.00,0.00,3.25,110.50,'2021-12-25 14:40:10','',''),(2373415,'1','180','934',414,'Retail Sale Id 1407691',1848.00,0.00,0.00,3.00,102.00,'2021-12-25 15:00:06','',''),(2373498,'1','180','934',414,'Retail Sale Id 1407750',4928.00,0.00,0.00,8.00,272.00,'2021-12-25 15:17:11','',''),(2373674,'1','180','934',414,'Retail Sale Id 1407897',3696.00,0.00,0.00,6.00,204.00,'2021-12-25 15:45:16','',''),(2375233,'1','180','934',414,'Retail Sale Id 1408724',2400.00,0.00,0.00,4.00,40.00,'2021-12-26 07:33:48','',''),(2376724,'1','180','934',414,'Retail Sale Id 1409900',3900.00,0.00,0.00,6.50,65.00,'2021-12-26 10:07:29','',''),(2376731,'1','180','934',414,'Retail Sale Id 1409909',3600.00,0.00,0.00,6.00,60.00,'2021-12-26 10:08:26','',''),(2376934,'1','180','934',414,'Retail Sale Id 1410112',3600.00,0.00,0.00,6.00,60.00,'2021-12-26 10:35:22','',''),(2377363,'1','180','934',414,'Retail Sale Id 1410487',4200.00,0.00,0.00,7.00,70.00,'2021-12-26 11:24:39','',''),(2377410,'1','180','934',414,'Retail Sale Id 1410529',3600.00,0.00,0.00,6.00,60.00,'2021-12-26 11:31:39','',''),(2377547,'1','180','934',414,'Retail Sale Id 1410654',3600.00,0.00,0.00,6.00,60.00,'2021-12-26 11:48:32','',''),(2377986,'1','180','934',414,'Retail Sale Id 1410986',3000.00,0.00,0.00,5.00,50.00,'2021-12-26 12:38:49','',''),(2378110,'1','180','934',414,'Retail Sale Id 1411114',32480.00,0.00,0.00,58.00,-1740.00,'2021-12-26 12:54:45','',''),(2378122,'1','180','934',414,'Retail Sale Id 1411127',32480.00,0.00,0.00,58.00,-1740.00,'2021-12-26 12:56:01','',''),(2379674,'1','180','934',414,'Retail Sale Id 1412215',3600.00,0.00,0.00,6.00,60.00,'2021-12-26 16:11:32','',''),(2379926,'1','180','934',414,'Retail Sale Id 1412490',3600.00,0.00,0.00,6.00,60.00,'2021-12-26 17:22:06','',''),(2379928,'1','180','934',414,'Retail Sale Id 1412492',7500.00,0.00,0.00,12.50,125.00,'2021-12-26 17:23:22','',''),(2379938,'1','180','934',414,'Retail Sale Id 1412506',4200.00,0.00,0.00,7.00,70.00,'2021-12-26 17:26:23','',''),(2379940,'1','180','934',414,'Retail Sale Id 1412509',7500.00,0.00,0.00,12.50,125.00,'2021-12-26 17:27:36','',''),(2382228,'1','180','934',414,'Retail Sale Id 1414017',2100.00,0.00,0.00,3.50,35.00,'2021-12-27 09:28:40','',''),(2382258,'1','180','934',414,'Retail Sale Id 1414047',1800.00,0.00,0.00,3.00,30.00,'2021-12-27 09:32:03','',''),(2382285,'1','180','934',414,'Retail Sale Id 1414075',3600.00,0.00,0.00,6.00,60.00,'2021-12-27 09:34:21','',''),(2383012,'1','180','934',414,'Retail Sale Id 1414718',1200.00,0.00,0.00,2.00,20.00,'2021-12-27 10:40:28','',''),(2383061,'1','180','934',414,'Retail Sale Id 1414761',2400.00,0.00,0.00,4.00,40.00,'2021-12-27 10:45:33','',''),(2383075,'1','180','934',414,'Retail Sale Id 1414782',2820.00,0.00,0.00,4.70,47.00,'2021-12-27 10:47:03','',''),(2383105,'1','180','934',414,'Retail Sale Id 1414808',3300.00,0.00,0.00,5.50,55.00,'2021-12-27 10:50:43','',''),(2383124,'1','180','934',414,'Retail Sale Id 1414824',1800.00,0.00,0.00,3.00,30.00,'2021-12-27 10:51:51','',''),(2383336,'1','180','934',414,'Retail Sale Id 1414908',3000.00,0.00,0.00,5.00,50.00,'2021-12-27 11:13:18','',''),(2383408,'1','180','934',414,'Retail Sale Id 1415043',1800.00,0.00,0.00,3.00,30.00,'2021-12-27 11:21:27','',''),(2383456,'1','180','934',414,'Retail Sale Id 1415137',28000.00,0.00,0.00,50.00,-1500.00,'2021-12-27 11:26:38','',''),(2383474,'1','180','934',414,'Retail Sale Id 1415157',7200.00,0.00,0.00,12.00,120.00,'2021-12-27 11:28:49','',''),(2384033,'1','180','934',414,'Retail Sale Id 1415655',4800.00,0.00,0.00,8.00,80.00,'2021-12-27 12:45:49','',''),(2384891,'1','180','934',414,'Retail Sale Id 1416243',3600.00,0.00,0.00,6.00,60.00,'2021-12-27 14:30:02','',''),(2385026,'1','180','934',414,'Retail Sale Id 1416341',3600.00,0.00,0.00,6.00,60.00,'2021-12-27 14:50:12','',''),(2385060,'1','180','934',414,'Retail Sale Id 1416376',2400.00,0.00,0.00,4.00,40.00,'2021-12-27 14:56:27','',''),(2385891,'1','180','934',414,'Retail Sale Id 1417110',1632.00,0.00,0.00,2.72,27.20,'2021-12-27 17:06:44','',''),(2385914,'1','180','934',414,'Retail Sale Id 1417130',3600.00,0.00,0.00,6.00,60.00,'2021-12-27 17:10:29','',''),(2388519,'1','180','934',414,'Retail Sale Id 1418945',1800.00,0.00,0.00,3.00,30.00,'2021-12-28 10:01:42','',''),(2388542,'1','180','934',414,'Retail Sale Id 1418966',3600.00,0.00,0.00,6.00,60.00,'2021-12-28 10:03:49','',''),(2389147,'1','180','934',414,'Retail Sale Id 1419512',3000.00,0.00,0.00,5.00,50.00,'2021-12-28 11:03:52','',''),(2389218,'1','180','934',414,'Retail Sale Id 1419554',5220.00,0.00,0.00,8.70,87.00,'2021-12-28 11:10:18','',''),(2389232,'1','180','934',414,'Retail Sale Id 1419585',2820.00,0.00,0.00,4.70,47.00,'2021-12-28 11:12:42','',''),(2389260,'1','180','934',414,'Retail Sale Id 1419601',1800.00,0.00,0.00,3.00,30.00,'2021-12-28 11:15:50','',''),(2389271,'1','180','934',414,'Retail Sale Id 1419622',1800.00,0.00,0.00,3.00,30.00,'2021-12-28 11:17:34','',''),(2389285,'1','180','934',414,'Retail Sale Id 1419634',960.00,0.00,0.00,1.60,16.00,'2021-12-28 11:19:15','',''),(2389307,'1','180','934',414,'Retail Sale Id 1419654',2400.00,0.00,0.00,4.00,40.00,'2021-12-28 11:21:30','',''),(2389320,'1','180','934',414,'Retail Sale Id 1419669',3000.00,0.00,0.00,5.00,50.00,'2021-12-28 11:23:01','',''),(2391741,'1','180','934',414,'Retail Sale Id 1421541',3000.00,0.00,0.00,5.00,50.00,'2021-12-28 15:31:08','',''),(2391746,'1','180','934',414,'Retail Sale Id 1421551',960.00,0.00,0.00,1.60,16.00,'2021-12-28 15:32:08','',''),(2391755,'1','180','934',414,'Retail Sale Id 1421561',1200.00,0.00,0.00,2.00,20.00,'2021-12-28 15:33:20','',''),(2391773,'1','180','934',414,'Retail Sale Id 1421578',1980.00,0.00,0.00,3.30,33.00,'2021-12-28 15:34:52','',''),(2391779,'1','180','934',414,'Retail Sale Id 1421589',1800.00,0.00,0.00,3.00,30.00,'2021-12-28 15:36:10','',''),(2391787,'1','180','934',414,'Retail Sale Id 1421598',3600.00,0.00,0.00,6.00,60.00,'2021-12-28 15:37:43','',''),(2391800,'1','180','934',414,'Retail Sale Id 1421611',1680.00,0.00,0.00,2.80,28.00,'2021-12-28 15:39:29','',''),(2391815,'1','180','934',414,'Retail Sale Id 1421625',1800.00,0.00,0.00,3.00,30.00,'2021-12-28 15:40:30','',''),(2391850,'1','180','934',414,'Retail Sale Id 1421649',3600.00,0.00,0.00,6.00,60.00,'2021-12-28 15:43:43','',''),(2391862,'1','180','934',414,'Retail Sale Id 1421657',1200.00,0.00,0.00,2.00,20.00,'2021-12-28 15:44:37','',''),(2391891,'1','180','934',414,'Retail Sale Id 1421672',32480.00,0.00,0.00,58.00,-1740.00,'2021-12-28 15:47:08','',''),(2391907,'1','180','934',414,'Retail Sale Id 1421688',32480.00,0.00,0.00,58.00,-1740.00,'2021-12-28 15:48:49','',''),(2392700,'1','180','934',414,'Retail Sale Id 1422262',3600.00,0.00,0.00,6.00,60.00,'2021-12-28 17:15:18','',''),(2392706,'1','180','934',414,'Retail Sale Id 1422271',600.00,0.00,0.00,1.00,10.00,'2021-12-28 17:16:33','',''),(2392712,'1','180','934',414,'Retail Sale Id 1422294',3600.00,0.00,0.00,6.00,60.00,'2021-12-28 17:17:49','',''),(2392723,'1','180','934',414,'Retail Sale Id 1422304',9000.00,0.00,0.00,15.00,150.00,'2021-12-28 17:20:29','',''),(2395910,'1','180','934',414,'Retail Sale Id 1424497',6000.00,0.00,0.00,10.00,100.00,'2021-12-29 10:55:09','',''),(2395923,'1','180','934',414,'Retail Sale Id 1424509',3000.00,0.00,0.00,5.00,50.00,'2021-12-29 10:56:25','',''),(2395947,'1','180','934',414,'Retail Sale Id 1424521',960.00,0.00,0.00,1.60,16.00,'2021-12-29 10:57:34','',''),(2395960,'1','180','934',414,'Retail Sale Id 1424530',3600.00,0.00,0.00,6.00,60.00,'2021-12-29 10:58:48','',''),(2395978,'1','180','934',414,'Retail Sale Id 1424549',1920.00,0.00,0.00,3.20,32.00,'2021-12-29 11:00:42','',''),(2395990,'1','180','934',414,'Retail Sale Id 1424559',1920.00,0.00,0.00,3.20,32.00,'2021-12-29 11:01:45','',''),(2396000,'1','180','934',414,'Retail Sale Id 1424570',3600.00,0.00,0.00,6.00,60.00,'2021-12-29 11:02:56','',''),(2396016,'1','180','934',414,'Retail Sale Id 1424590',7500.00,0.00,0.00,12.50,125.00,'2021-12-29 11:04:26','',''),(2396027,'1','180','934',414,'Retail Sale Id 1424603',3600.00,0.00,0.00,6.00,60.00,'2021-12-29 11:05:33','',''),(2396114,'1','180','934',414,'Retail Sale Id 1424680',2880.00,0.00,0.00,4.80,48.00,'2021-12-29 11:14:26','',''),(2396425,'1','180','934',414,'Retail Sale Id 1424944',33600.00,0.00,0.00,60.00,-1800.00,'2021-12-29 11:48:49','',''),(2396898,'1','180','934',414,'Retail Sale Id 1425368',3600.00,0.00,0.00,6.00,60.00,'2021-12-29 12:54:02','',''),(2396913,'1','180','934',414,'Retail Sale Id 1425380',2880.00,0.00,0.00,4.80,48.00,'2021-12-29 12:56:27','',''),(2399010,'1','180','934',414,'Retail Sale Id 1426855',3600.00,0.00,0.00,6.00,60.00,'2021-12-29 16:16:07','',''),(2399020,'1','180','934',414,'Retail Sale Id 1426865',7500.00,0.00,0.00,12.50,125.00,'2021-12-29 16:17:28','',''),(2399039,'1','180','934',414,'Retail Sale Id 1426881',1200.00,0.00,0.00,2.00,20.00,'2021-12-29 16:19:24','',''),(2399059,'1','180','934',414,'Retail Sale Id 1426902',3600.00,0.00,0.00,6.00,60.00,'2021-12-29 16:21:54','',''),(2401012,'1','180','934',414,'Retail Sale Id 1428120',3600.00,0.00,0.00,6.00,60.00,'2021-12-30 08:07:56','',''),(2404571,'1','180','934',414,'Retail Sale Id 1431005',0.00,0.00,0.00,5.00,-2950.00,'2021-12-30 13:58:10','',''),(2404691,'1','180','934',414,'Retail Sale Id 1431107',1800.00,0.00,0.00,3.00,30.00,'2021-12-30 14:11:52','',''),(2404750,'1','180','934',414,'Retail Sale Id 1431151',2400.00,0.00,0.00,4.00,40.00,'2021-12-30 14:17:10','',''),(2404769,'1','180','934',414,'Retail Sale Id 1431169',1800.00,0.00,0.00,3.00,30.00,'2021-12-30 14:19:10','',''),(2404789,'1','180','934',414,'Retail Sale Id 1431183',3000.00,0.00,0.00,5.00,50.00,'2021-12-30 14:20:08','',''),(2404805,'1','180','934',414,'Retail Sale Id 1431196',4200.00,0.00,0.00,7.00,70.00,'2021-12-30 14:21:37','',''),(2404821,'1','180','934',414,'Retail Sale Id 1431213',3600.00,0.00,0.00,6.00,60.00,'2021-12-30 14:22:49','',''),(2404835,'1','180','934',414,'Retail Sale Id 1431226',3600.00,0.00,0.00,6.00,60.00,'2021-12-30 14:23:54','',''),(2404875,'1','180','934',414,'Retail Sale Id 1431267',3000.00,0.00,0.00,5.00,50.00,'2021-12-30 14:29:57','',''),(2404886,'1','180','934',414,'Retail Sale Id 1431281',3000.00,0.00,0.00,5.00,50.00,'2021-12-30 14:31:37','',''),(2404900,'1','180','934',414,'Retail Sale Id 1431294',1002.00,0.00,0.00,1.67,16.70,'2021-12-30 14:32:54','',''),(2404915,'1','180','934',414,'Retail Sale Id 1431309',3600.00,0.00,0.00,6.00,60.00,'2021-12-30 14:34:52','',''),(2404922,'1','180','934',414,'Retail Sale Id 1431318',1500.00,0.00,0.00,2.50,25.00,'2021-12-30 14:35:53','',''),(2404940,'1','180','934',414,'Retail Sale Id 1431337',3600.00,0.00,0.00,6.00,60.00,'2021-12-30 14:37:34','',''),(2404952,'1','180','934',414,'Retail Sale Id 1431351',4980.00,0.00,0.00,8.30,83.00,'2021-12-30 14:39:12','',''),(2404965,'1','180','934',414,'Retail Sale Id 1431363',3000.00,0.00,0.00,5.00,50.00,'2021-12-30 14:40:26','',''),(2404978,'1','180','934',414,'Retail Sale Id 1431377',2400.00,0.00,0.00,4.00,40.00,'2021-12-30 14:41:49','',''),(2404996,'1','180','934',414,'Retail Sale Id 1431397',7500.00,0.00,0.00,12.50,125.00,'2021-12-30 14:43:24','',''),(2405005,'1','180','934',414,'Retail Sale Id 1431409',1800.00,0.00,0.00,3.00,30.00,'2021-12-30 14:44:34','',''),(2405052,'1','180','934',414,'Retail Sale Id 1431455',25200.00,0.00,0.00,45.00,-1350.00,'2021-12-30 14:51:38','',''),(2405373,'1','180','934',414,'Retail Sale Id 1431740',1002.00,0.00,0.00,1.67,16.70,'2021-12-30 15:26:42','',''),(2405389,'1','180','934',414,'Retail Sale Id 1431749',1200.00,0.00,0.00,2.00,20.00,'2021-12-30 15:28:01','',''),(2405434,'1','180','934',414,'Retail Sale Id 1431798',1800.00,0.00,0.00,3.00,30.00,'2021-12-30 15:33:33','',''),(2405750,'1','180','934',414,'Retail Sale Id 1432066',3600.00,0.00,0.00,6.00,60.00,'2021-12-30 16:02:42','',''),(2406558,'1','180','934',414,'Retail Sale Id 1432756',7500.00,0.00,0.00,12.50,125.00,'2021-12-30 17:22:17','',''),(2409880,'1','180','934',414,'Retail Sale Id 1435111',3000.00,0.00,0.00,5.00,50.00,'2021-12-31 10:29:39','',''),(2409915,'1','180','934',414,'Retail Sale Id 1435146',1800.00,0.00,0.00,3.00,30.00,'2021-12-31 10:33:47','',''),(2409943,'1','180','934',414,'Retail Sale Id 1435174',2400.00,0.00,0.00,4.00,40.00,'2021-12-31 10:36:18','',''),(2409961,'1','180','934',414,'Retail Sale Id 1435188',3000.00,0.00,0.00,5.00,50.00,'2021-12-31 10:37:50','',''),(2409979,'1','180','934',414,'Retail Sale Id 1435204',1800.00,0.00,0.00,3.00,30.00,'2021-12-31 10:39:35','',''),(2410037,'1','180','934',414,'Retail Sale Id 1435247',3600.00,0.00,0.00,6.00,60.00,'2021-12-31 10:43:46','',''),(2410053,'1','180','934',414,'Retail Sale Id 1435262',3600.00,0.00,0.00,6.00,60.00,'2021-12-31 10:45:19','',''),(2410078,'1','180','934',414,'Retail Sale Id 1435274',3300.00,0.00,0.00,5.50,55.00,'2021-12-31 10:47:06','',''),(2410231,'1','180','934',414,'Retail Sale Id 1435418',3600.00,0.00,0.00,6.00,60.00,'2021-12-31 11:03:07','',''),(2410246,'1','180','934',414,'Retail Sale Id 1435433',1980.00,0.00,0.00,3.30,33.00,'2021-12-31 11:05:05','',''),(2410257,'1','180','934',414,'Retail Sale Id 1435444',1200.00,0.00,0.00,2.00,20.00,'2021-12-31 11:06:42','',''),(2410267,'1','180','934',414,'Retail Sale Id 1435451',1800.00,0.00,0.00,3.00,30.00,'2021-12-31 11:08:12','',''),(2410283,'1','180','934',414,'Retail Sale Id 1435464',3000.00,0.00,0.00,5.00,50.00,'2021-12-31 11:10:05','',''),(2410309,'1','180','934',414,'Retail Sale Id 1435494',7500.00,0.00,0.00,12.50,125.00,'2021-12-31 11:13:44','',''),(2410702,'1','180','934',414,'Retail Sale Id 1435850',8460.00,0.00,0.00,14.10,141.00,'2021-12-31 11:53:55','',''),(2410730,'1','180','934',414,'Retail Sale Id 1435874',1998.00,0.00,0.00,3.33,33.30,'2021-12-31 11:56:53','',''),(2411002,'1','180','934',414,'Retail Sale Id 1436150',4302.00,0.00,0.00,7.17,71.70,'2021-12-31 12:41:19','',''),(2413078,'1','180','934',414,'Retail Sale Id 1437876',134400.00,0.00,0.00,240.00,-7200.00,'2021-12-31 15:59:33','',''),(2413474,'1','180','934',414,'Retail Sale Id 1438274',13602.40,0.00,0.00,24.29,-728.70,'2021-12-31 16:37:29','',''),(2413565,'1','180','934',414,'Retail Sale Id 1438327',5598.00,0.00,0.00,9.33,93.30,'2021-12-31 16:43:30','',''),(2417410,'1','180','934',414,'Retail Sale Id 1441387',3000.00,0.00,0.00,5.00,50.00,'2022-01-01 11:25:40','',''),(2417433,'1','180','934',414,'Retail Sale Id 1441410',3000.00,0.00,0.00,5.00,50.00,'2022-01-01 11:28:18','',''),(2417458,'1','180','934',414,'Retail Sale Id 1441435',960.00,0.00,0.00,1.60,16.00,'2022-01-01 11:30:48','',''),(2417551,'1','180','934',414,'Retail Sale Id 1441522',1800.00,0.00,0.00,3.00,30.00,'2022-01-01 11:39:39','',''),(2417568,'1','180','934',414,'Retail Sale Id 1441541',7500.00,0.00,0.00,12.50,125.00,'2022-01-01 11:41:13','',''),(2417581,'1','180','934',414,'Retail Sale Id 1441553',3600.00,0.00,0.00,6.00,60.00,'2022-01-01 11:42:36','',''),(2417600,'1','180','934',414,'Retail Sale Id 1441567',1080.00,0.00,0.00,1.80,18.00,'2022-01-01 11:44:37','',''),(2417631,'1','180','934',414,'Retail Sale Id 1441598',1800.00,0.00,0.00,3.00,30.00,'2022-01-01 11:48:15','',''),(2417654,'1','180','934',414,'Retail Sale Id 1441619',1320.00,0.00,0.00,2.20,22.00,'2022-01-01 11:51:01','',''),(2417670,'1','180','934',414,'Retail Sale Id 1441637',6000.00,0.00,0.00,10.00,100.00,'2022-01-01 11:52:58','',''),(2417760,'1','180','934',414,'Retail Sale Id 1441732',28000.00,0.00,0.00,50.00,-1500.00,'2022-01-01 12:03:09','',''),(2420085,'1','180','934',414,'Retail Sale Id 1443646',28000.00,0.00,0.00,50.00,-1500.00,'2022-01-01 17:16:50','',''),(2420087,'1','180','934',414,'Retail Sale Id 1443649',2100.00,0.00,0.00,3.50,35.00,'2022-01-01 17:18:00','',''),(2420102,'1','180','934',414,'Retail Sale Id 1443663',3540.00,0.00,0.00,5.90,59.00,'2022-01-01 17:22:51','',''),(2423243,'1','180','934',414,'Retail Sale Id 1446021',1800.00,0.00,0.00,3.00,30.00,'2022-01-02 11:35:10','',''),(2423270,'1','180','934',414,'Retail Sale Id 1446049',1002.00,0.00,0.00,1.67,16.70,'2022-01-02 11:38:05','',''),(2423281,'1','180','934',414,'Retail Sale Id 1446060',1620.00,0.00,0.00,2.70,27.00,'2022-01-02 11:39:54','',''),(2423294,'1','180','934',414,'Retail Sale Id 1446073',1920.00,0.00,0.00,3.20,32.00,'2022-01-02 11:41:37','',''),(2423305,'1','180','934',414,'Retail Sale Id 1446080',1800.00,0.00,0.00,3.00,30.00,'2022-01-02 11:42:40','',''),(2423445,'1','180','934',414,'Retail Sale Id 1446214',1800.00,0.00,0.00,3.00,30.00,'2022-01-02 12:01:32','',''),(2424691,'1','180','934',414,'Retail Sale Id 1447322',32480.00,0.00,0.00,58.00,-1740.00,'2022-01-02 14:26:40','',''),(2424702,'1','180','934',414,'Retail Sale Id 1447332',32480.00,0.00,0.00,58.00,-1740.00,'2022-01-02 14:27:48','',''),(2424759,'1','180','934',414,'Retail Sale Id 1447383',28000.00,0.00,0.00,50.00,-1500.00,'2022-01-02 14:33:58','',''),(2425683,'1','180','934',414,'Retail Sale Id 1448195',8160.00,0.00,0.00,13.60,136.00,'2022-01-02 16:36:54','',''),(2428326,'1','180','934',414,'Retail Sale Id 1450287',7500.00,0.00,0.00,12.50,125.00,'2022-01-03 10:29:23','',''),(2428339,'1','180','934',414,'Retail Sale Id 1450301',1800.00,0.00,0.00,3.00,30.00,'2022-01-03 10:31:03','',''),(2428352,'1','180','934',414,'Retail Sale Id 1450314',1800.00,0.00,0.00,3.00,30.00,'2022-01-03 10:32:06','',''),(2428358,'1','180','934',414,'Retail Sale Id 1450322',1920.00,0.00,0.00,3.20,32.00,'2022-01-03 10:33:03','',''),(2428367,'1','180','934',414,'Retail Sale Id 1450330',1500.00,0.00,0.00,2.50,25.00,'2022-01-03 10:34:01','',''),(2428378,'1','180','934',414,'Retail Sale Id 1450337',3000.00,0.00,0.00,5.00,50.00,'2022-01-03 10:35:04','',''),(2428398,'1','180','934',414,'Retail Sale Id 1450355',7500.00,0.00,0.00,12.50,125.00,'2022-01-03 10:36:58','',''),(2428485,'1','180','934',414,'Retail Sale Id 1450443',1800.00,0.00,0.00,3.00,30.00,'2022-01-03 10:48:10','',''),(2428555,'1','180','934',414,'Retail Sale Id 1450515',32480.00,0.00,0.00,58.00,-1740.00,'2022-01-03 10:58:48','',''),(2432399,'1','180','934',414,'Retail Sale Id 1453723',3600.00,0.00,0.00,6.00,60.00,'2022-01-03 18:17:02','',''),(2436220,'1','180','934',414,'Retail Sale Id 1456580',960.00,0.00,0.00,1.60,16.00,'2022-01-04 11:48:51','',''),(2436230,'1','180','934',414,'Retail Sale Id 1456588',3000.00,0.00,0.00,5.00,50.00,'2022-01-04 11:49:51','',''),(2436244,'1','180','934',414,'Retail Sale Id 1456603',1800.00,0.00,0.00,3.00,30.00,'2022-01-04 11:50:57','',''),(2436261,'1','180','934',414,'Retail Sale Id 1456615',3600.00,0.00,0.00,6.00,60.00,'2022-01-04 11:52:13','',''),(2436273,'1','180','934',414,'Retail Sale Id 1456628',960.00,0.00,0.00,1.60,16.00,'2022-01-04 11:53:32','',''),(2436285,'1','180','934',414,'Retail Sale Id 1456638',1800.00,0.00,0.00,3.00,30.00,'2022-01-04 11:54:51','',''),(2436297,'1','180','934',414,'Retail Sale Id 1456659',3000.00,0.00,0.00,5.00,50.00,'2022-01-04 11:56:06','',''),(2436307,'1','180','934',414,'Retail Sale Id 1456670',4200.00,0.00,0.00,7.00,70.00,'2022-01-04 11:57:13','',''),(2436322,'1','180','934',414,'Retail Sale Id 1456684',4800.00,0.00,0.00,8.00,80.00,'2022-01-04 11:58:42','',''),(2436407,'1','180','934',414,'Retail Sale Id 1456773',32480.00,0.00,0.00,58.00,-1740.00,'2022-01-04 12:08:33','',''),(2436426,'1','180','934',414,'Retail Sale Id 1456793',32480.00,0.00,0.00,58.00,-1740.00,'2022-01-04 12:10:42','',''),(2436624,'1','180','934',414,'Retail Sale Id 1456996',780.00,0.00,0.00,1.30,13.00,'2022-01-04 12:34:24','',''),(2436740,'1','180','934',414,'Retail Sale Id 1457115',28000.00,0.00,0.00,50.00,-1500.00,'2022-01-04 12:45:39','',''),(2436967,'1','180','934',414,'Retail Sale Id 1457320',1200.00,0.00,0.00,2.00,20.00,'2022-01-04 13:09:42','',''),(2437207,'1','180','934',414,'Retail Sale Id 1457593',1200.00,0.00,0.00,2.00,20.00,'2022-01-04 13:34:18','',''),(2438108,'1','180','934',414,'Retail Sale Id 1458248',2400.00,0.00,0.00,4.00,40.00,'2022-01-04 14:46:00','',''),(2438239,'1','180','934',414,'Retail Sale Id 1458363',1800.00,0.00,0.00,3.00,30.00,'2022-01-04 14:58:55','',''),(2438586,'1','180','934',414,'Retail Sale Id 1458634',3000.00,0.00,0.00,5.00,50.00,'2022-01-04 15:21:00','',''),(2439013,'1','180','934',414,'Retail Sale Id 1459003',1800.00,0.00,0.00,3.00,30.00,'2022-01-04 15:58:30','',''),(2439309,'1','180','934',414,'Retail Sale Id 1459292',1002.00,0.00,0.00,1.67,16.70,'2022-01-04 16:26:01','',''),(2439329,'1','180','934',414,'Retail Sale Id 1459312',3600.00,0.00,0.00,6.00,60.00,'2022-01-04 16:27:52','',''),(2439689,'1','180','934',414,'Retail Sale Id 1459681',1800.00,0.00,0.00,3.00,30.00,'2022-01-04 17:19:29','',''),(2444438,'1','180','934',414,'Retail Sale Id 1463334',2400.00,0.00,0.00,4.00,40.00,'2022-01-05 13:57:05','',''),(2444441,'1','180','934',414,'Retail Sale Id 1463340',3000.00,0.00,0.00,5.00,50.00,'2022-01-05 13:57:52','',''),(2444455,'1','180','934',414,'Retail Sale Id 1463353',1002.00,0.00,0.00,1.67,16.70,'2022-01-05 13:58:46','',''),(2444461,'1','180','934',414,'Retail Sale Id 1463358',1800.00,0.00,0.00,3.00,30.00,'2022-01-05 13:59:29','',''),(2444470,'1','180','934',414,'Retail Sale Id 1463366',28000.00,0.00,0.00,50.00,-1500.00,'2022-01-05 14:00:25','',''),(2444533,'1','180','934',414,'Retail Sale Id 1463392',32480.00,0.00,0.00,58.00,-1740.00,'2022-01-05 14:03:23','',''),(2444610,'1','180','934',414,'Retail Sale Id 1463464',3000.00,0.00,0.00,5.00,50.00,'2022-01-05 14:10:59','',''),(2444832,'1','180','934',414,'Retail Sale Id 1463612',22400.00,0.00,0.00,40.00,-1200.00,'2022-01-05 14:35:24','',''),(2444842,'1','180','934',414,'Retail Sale Id 1463620',1800.00,0.00,0.00,3.00,30.00,'2022-01-05 14:36:27','',''),(2471016,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344947',140089.60,0.00,0.00,237.44,0.00,'2022-01-08 19:31:33','',''),(2475035,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,2687700.00,5100.00,0.00,0.00,'2022-01-09 12:45:01','',''),(2475059,'1','180',NULL,414,'Reception corrector for bridging 130289',0.00,0.00,0.00,5100.00,0.00,'2022-01-09 12:46:23','',''),(2475060,'1','180','934',414,'Received from bridging 130289',0.00,0.00,5100.00,0.00,0.00,'2022-01-09 12:46:23','',''),(2475115,'1','180','934',414,'Retail Sale Id 1488584',1800.00,0.00,0.00,3.00,219.00,'2022-01-09 12:51:27','',''),(2475137,'1','180','934',414,'Retail Sale Id 1488607',1800.00,0.00,0.00,3.00,219.00,'2022-01-09 12:53:12','',''),(2475149,'1','180','934',414,'Retail Sale Id 1488623',3000.00,0.00,0.00,5.00,365.00,'2022-01-09 12:54:08','',''),(2475330,'1','180','934',414,'Retail Sale Id 1488790',3000.00,0.00,0.00,5.00,365.00,'2022-01-09 13:10:28','',''),(2475341,'1','180','934',414,'Retail Sale Id 1488801',3600.00,0.00,0.00,6.00,438.00,'2022-01-09 13:12:02','',''),(2475350,'1','180','934',414,'Retail Sale Id 1488808',1800.00,0.00,0.00,3.00,219.00,'2022-01-09 13:13:03','',''),(2475394,'1','180','934',414,'Retail Sale Id 1488859',32480.00,0.00,0.00,58.00,1914.00,'2022-01-09 13:16:55','',''),(2475406,'1','180','934',414,'Retail Sale Id 1488874',32480.00,0.00,0.00,58.00,1914.00,'2022-01-09 13:18:05','',''),(2475422,'1','180','934',414,'Retail Sale Id 1488891',2502.00,0.00,0.00,4.17,304.41,'2022-01-09 13:19:26','',''),(2475466,'1','180','934',414,'Retail Sale Id 1488936',7500.00,0.00,0.00,12.50,912.50,'2022-01-09 13:22:55','',''),(2475474,'1','180','934',414,'Retail Sale Id 1488945',1200.00,0.00,0.00,2.00,146.00,'2022-01-09 13:23:47','',''),(2475501,'1','180','934',414,'Retail Sale Id 1488971',6000.00,0.00,0.00,10.00,730.00,'2022-01-09 13:25:55','',''),(2476212,'1','180','934',414,'Retail Sale Id 1489673',1200.00,0.00,0.00,2.00,146.00,'2022-01-09 14:32:44','',''),(2478099,'1','180','934',414,'Retail Sale Id 1491499',1800.00,0.00,0.00,3.00,219.00,'2022-01-09 17:26:22','',''),(2478166,'1','180','934',414,'Retail Sale Id 1491549',5400.00,0.00,0.00,9.00,657.00,'2022-01-09 17:31:16','',''),(2478216,'1','180','934',414,'Retail Sale Id 1491585',4440.00,0.00,0.00,7.40,540.20,'2022-01-09 17:35:31','',''),(2478539,'1','180','934',414,'Retail Sale Id 1491847',2400.00,0.00,0.00,4.00,292.00,'2022-01-09 18:13:50','',''),(2480925,'1','180','934',414,'Retail Sale Id 1493337',1800.00,0.00,0.00,3.00,219.00,'2022-01-10 09:55:58','',''),(2481722,'1','180','934',414,'Retail Sale Id 1494101',3900.00,0.00,0.00,6.50,474.50,'2022-01-10 11:28:20','',''),(2481757,'1','180','934',414,'Retail Sale Id 1494133',1920.00,0.00,0.00,3.20,233.60,'2022-01-10 11:31:47','',''),(2481774,'1','180','934',414,'Retail Sale Id 1494146',5400.00,0.00,0.00,9.00,657.00,'2022-01-10 11:34:01','',''),(2481787,'1','180','934',414,'Retail Sale Id 1494163',7500.00,0.00,0.00,12.50,912.50,'2022-01-10 11:35:45','',''),(2484048,'1','180','934',414,'Retail Sale Id 1496282',2760.00,0.00,0.00,4.60,335.80,'2022-01-10 15:57:22','',''),(2484171,'1','180','934',414,'Retail Sale Id 1496316',960.00,0.00,0.00,1.60,116.80,'2022-01-10 16:11:21','',''),(2484179,'1','180','934',414,'Retail Sale Id 1496414',5400.00,0.00,0.00,9.00,657.00,'2022-01-10 16:12:21','',''),(2484376,'1','180','934',414,'Retail Sale Id 1496595',4398.00,0.00,0.00,7.33,535.09,'2022-01-10 16:32:43','',''),(2485074,'1','180','934',414,'Retail Sale Id 1497108',3000.00,0.00,0.00,5.00,365.00,'2022-01-10 17:25:54','',''),(2485178,'1','180','934',414,'Retail Sale Id 1497147',3000.00,0.00,0.00,5.00,365.00,'2022-01-10 17:31:44','',''),(2485221,'1','180','934',414,'Retail Sale Id 1497194',1800.00,0.00,0.00,3.00,219.00,'2022-01-10 17:34:17','',''),(2490086,'1','180','934',414,'Retail Sale Id 1501310',1920.00,0.00,0.00,3.20,233.60,'2022-01-11 13:57:33','',''),(2490099,'1','180','934',414,'Retail Sale Id 1501321',3600.00,0.00,0.00,6.00,438.00,'2022-01-11 13:58:56','',''),(2490112,'1','180','934',414,'Retail Sale Id 1501335',3000.00,0.00,0.00,5.00,365.00,'2022-01-11 14:00:42','',''),(2490131,'1','180','934',414,'Retail Sale Id 1501351',2202.00,0.00,0.00,3.67,267.91,'2022-01-11 14:03:20','',''),(2490138,'1','180','934',414,'Retail Sale Id 1501359',3000.00,0.00,0.00,5.00,365.00,'2022-01-11 14:04:17','',''),(2490223,'1','180','934',414,'Retail Sale Id 1501403',1800.00,0.00,0.00,3.00,219.00,'2022-01-11 14:16:26','',''),(2490240,'1','180','934',414,'Retail Sale Id 1501455',1800.00,0.00,0.00,3.00,219.00,'2022-01-11 14:18:00','',''),(2490259,'1','180','934',414,'Retail Sale Id 1501469',3000.00,0.00,0.00,5.00,365.00,'2022-01-11 14:19:15','',''),(2490458,'1','180','934',414,'Retail Sale Id 1501480',4920.00,0.00,0.00,8.20,598.60,'2022-01-11 14:33:58','',''),(2490494,'1','180','934',414,'Retail Sale Id 1501641',33600.00,0.00,0.00,60.00,1980.00,'2022-01-11 14:35:14','',''),(2490526,'1','180','934',414,'Retail Sale Id 1501658',13440.00,0.00,0.00,24.00,792.00,'2022-01-11 14:37:07','',''),(2490995,'1','180','934',414,'Retail Sale Id 1501967',32480.00,0.00,0.00,58.00,1914.00,'2022-01-11 15:18:12','',''),(2491043,'1','180','934',414,'Retail Sale Id 1501982',32480.00,0.00,0.00,58.00,1914.00,'2022-01-11 15:19:51','',''),(2491088,'1','180','934',414,'Retail Sale Id 1502012',3000.00,0.00,0.00,5.00,365.00,'2022-01-11 15:22:29','',''),(2491094,'1','180','934',414,'Retail Sale Id 1502020',3000.00,0.00,0.00,5.00,365.00,'2022-01-11 15:23:30','',''),(2491137,'1','180','934',414,'Retail Sale Id 1502027',1800.00,0.00,0.00,3.00,219.00,'2022-01-11 15:27:17','',''),(2493270,'1','180','934',414,'Retail Sale Id 1504035',3000.00,0.00,0.00,5.00,365.00,'2022-01-11 18:54:24','',''),(2493281,'1','180','934',414,'Retail Sale Id 1504043',1998.00,0.00,0.00,3.33,243.09,'2022-01-11 18:55:51','',''),(2493294,'1','180','934',414,'Retail Sale Id 1504055',3600.00,0.00,0.00,6.00,438.00,'2022-01-11 18:57:34','',''),(2497623,'1','180','934',414,'Retail Sale Id 1507600',5100.00,0.00,0.00,8.50,620.50,'2022-01-12 13:14:35','',''),(2497635,'1','180','934',414,'Retail Sale Id 1507611',3600.00,0.00,0.00,6.00,438.00,'2022-01-12 13:16:12','',''),(2497674,'1','180','934',414,'Retail Sale Id 1507650',4620.00,0.00,0.00,7.70,562.10,'2022-01-12 13:20:58','',''),(2501440,'1','180','934',414,'Retail Sale Id 1511079',6000.00,0.00,0.00,10.00,730.00,'2022-01-12 20:31:07','',''),(2501442,'1','180','934',414,'Retail Sale Id 1511081',4998.00,0.00,0.00,8.33,608.09,'2022-01-12 20:33:41','',''),(2501443,'1','180','934',414,'Retail Sale Id 1511082',3000.00,0.00,0.00,5.00,365.00,'2022-01-12 20:34:55','',''),(2501444,'1','180','934',414,'Retail Sale Id 1511083',3498.00,0.00,0.00,5.83,425.59,'2022-01-12 20:36:34','',''),(2501446,'1','180','934',414,'Retail Sale Id 1511084',7500.00,0.00,0.00,12.50,912.50,'2022-01-12 20:37:51','',''),(2501447,'1','180','934',414,'Retail Sale Id 1511085',3600.00,0.00,0.00,6.00,438.00,'2022-01-12 20:40:41','',''),(2501448,'1','180','934',414,'Retail Sale Id 1511086',1800.00,0.00,0.00,3.00,219.00,'2022-01-12 20:41:41','',''),(2505034,'1','180','934',414,'Retail Sale Id 1513949',1800.00,0.00,0.00,3.00,219.00,'2022-01-13 12:51:27','',''),(2505043,'1','180','934',414,'Retail Sale Id 1513956',3000.00,0.00,0.00,5.00,365.00,'2022-01-13 12:52:23','',''),(2505051,'1','180','934',414,'Retail Sale Id 1513965',3600.00,0.00,0.00,6.00,438.00,'2022-01-13 12:53:06','',''),(2505062,'1','180','934',414,'Retail Sale Id 1513977',1500.00,0.00,0.00,2.50,182.50,'2022-01-13 12:54:14','',''),(2505070,'1','180','934',414,'Retail Sale Id 1513983',3600.00,0.00,0.00,6.00,438.00,'2022-01-13 12:54:59','',''),(2505082,'1','180','934',414,'Retail Sale Id 1513993',1800.00,0.00,0.00,3.00,219.00,'2022-01-13 12:55:53','',''),(2505089,'1','180','934',414,'Retail Sale Id 1514000',3000.00,0.00,0.00,5.00,365.00,'2022-01-13 12:56:49','',''),(2505100,'1','180','934',414,'Retail Sale Id 1514007',1920.00,0.00,0.00,3.20,233.60,'2022-01-13 12:57:53','',''),(2505119,'1','180','934',414,'Retail Sale Id 1514014',1500.00,0.00,0.00,2.50,182.50,'2022-01-13 12:58:55','',''),(2505200,'1','180','934',414,'Retail Sale Id 1514034',67200.00,0.00,0.00,120.00,3960.00,'2022-01-13 13:01:52','',''),(2505367,'1','180','934',414,'Retail Sale Id 1514210',33600.00,0.00,0.00,60.00,1980.00,'2022-01-13 13:21:56','',''),(2505443,'1','180','934',414,'Retail Sale Id 1514294',56000.00,0.00,0.00,100.00,3300.00,'2022-01-13 13:31:58','',''),(2507576,'1','180','934',414,'Retail Sale Id 1516001',3600.00,0.00,0.00,6.00,438.00,'2022-01-13 17:00:42','',''),(2507608,'1','180','934',414,'Retail Sale Id 1516046',960.00,0.00,0.00,1.60,116.80,'2022-01-13 17:03:54','',''),(2507959,'1','180','934',414,'Retail Sale Id 1516469',8400.00,0.00,0.00,14.00,1022.00,'2022-01-13 17:38:07','',''),(2508052,'1','180','934',414,'Retail Sale Id 1516573',3000.00,0.00,0.00,5.00,365.00,'2022-01-13 17:47:55','',''),(2513453,'1','180','934',414,'Retail Sale Id 1521012',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 14:38:49','',''),(2513465,'1','180','934',414,'Retail Sale Id 1521024',2802.00,0.00,0.00,4.67,340.91,'2022-01-14 14:40:19','',''),(2513483,'1','180','934',414,'Retail Sale Id 1521041',2502.00,0.00,0.00,4.17,304.41,'2022-01-14 14:41:54','',''),(2513518,'1','180','934',414,'Retail Sale Id 1521053',4998.00,0.00,0.00,8.33,608.09,'2022-01-14 14:43:10','',''),(2513530,'1','180','934',414,'Retail Sale Id 1521067',3000.00,0.00,0.00,5.00,365.00,'2022-01-14 14:44:30','',''),(2513548,'1','180','934',414,'Retail Sale Id 1521075',3498.00,0.00,0.00,5.83,425.59,'2022-01-14 14:45:12','',''),(2513554,'1','180','934',414,'Retail Sale Id 1521087',1500.00,0.00,0.00,2.50,182.50,'2022-01-14 14:45:53','',''),(2513567,'1','180','934',414,'Retail Sale Id 1521096',1002.00,0.00,0.00,1.67,121.91,'2022-01-14 14:46:31','',''),(2513574,'1','180','934',414,'Retail Sale Id 1521104',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 14:47:11','',''),(2513581,'1','180','934',414,'Retail Sale Id 1521112',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 14:47:47','',''),(2513591,'1','180','934',414,'Retail Sale Id 1521115',3000.00,0.00,0.00,5.00,365.00,'2022-01-14 14:48:25','',''),(2513612,'1','180','934',414,'Retail Sale Id 1521123',2400.00,0.00,0.00,4.00,292.00,'2022-01-14 14:49:39','',''),(2513688,'1','180','934',414,'Retail Sale Id 1521314',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 15:02:15','',''),(2514822,'1','180','934',414,'Retail Sale Id 1522404',1002.00,0.00,0.00,1.67,121.91,'2022-01-14 16:49:34','',''),(2514856,'1','180','934',414,'Retail Sale Id 1522450',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 16:53:06','',''),(2515867,'1','180','934',414,'Retail Sale Id 1523542',1200.00,0.00,0.00,2.00,146.00,'2022-01-14 18:36:45','',''),(2517553,'1','180','934',414,'Retail Sale Id 1524567',32480.00,0.00,0.00,58.00,1914.00,'2022-01-15 08:35:40','',''),(2517683,'1','180','934',414,'Retail Sale Id 1524694',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 08:48:01','',''),(2519045,'1','180','934',414,'Retail Sale Id 1525931',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 10:34:34','',''),(2520129,'1','180','934',414,'Retail Sale Id 1526908',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 12:00:14','',''),(2520264,'1','180','934',414,'Retail Sale Id 1527029',1998.00,0.00,0.00,3.33,243.09,'2022-01-15 12:09:13','',''),(2520537,'1','180','934',414,'Retail Sale Id 1527321',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 12:34:38','',''),(2520635,'1','180','934',414,'Retail Sale Id 1527397',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 12:41:19','',''),(2521523,'1','180','934',414,'Retail Sale Id 1528150',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 13:57:52','',''),(2521535,'1','180','934',414,'Retail Sale Id 1528169',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 13:58:54','',''),(2521927,'1','180','934',414,'Retail Sale Id 1528516',33600.00,0.00,0.00,60.00,1980.00,'2022-01-15 14:34:31','',''),(2521943,'1','180','934',414,'Retail Sale Id 1528532',1998.00,0.00,0.00,3.33,243.09,'2022-01-15 14:35:29','',''),(2524346,'1','180','934',414,'Retail Sale Id 1530611',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 17:38:29','',''),(2524799,'1','180','934',414,'Retail Sale Id 1531018',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 18:14:59','',''),(2524921,'1','180','934',414,'Retail Sale Id 1531132',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 18:31:22','',''),(2524933,'1','180','934',414,'Retail Sale Id 1531145',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 18:32:40','',''),(2524960,'1','180','934',414,'Retail Sale Id 1531154',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 18:35:48','',''),(2526392,'1','180','934',414,'Retail Sale Id 1532026',600.00,0.00,0.00,1.00,73.00,'2022-01-16 08:24:49','',''),(2526682,'1','180','934',414,'Retail Sale Id 1532280',1200.00,0.00,0.00,2.00,146.00,'2022-01-16 08:49:16','',''),(2528608,'1','180','934',414,'Retail Sale Id 1534089',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 11:21:15','',''),(2528627,'1','180','934',414,'Retail Sale Id 1534099',6000.00,0.00,0.00,10.00,730.00,'2022-01-16 11:22:48','',''),(2528637,'1','180','934',414,'Retail Sale Id 1534116',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 11:23:32','',''),(2528646,'1','180','934',414,'Retail Sale Id 1534128',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 11:24:14','',''),(2528651,'1','180','934',414,'Retail Sale Id 1534136',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 11:24:56','',''),(2528665,'1','180','934',414,'Retail Sale Id 1534148',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 11:25:41','',''),(2528673,'1','180','934',414,'Retail Sale Id 1534156',4200.00,0.00,0.00,7.00,511.00,'2022-01-16 11:26:22','',''),(2528687,'1','180','934',414,'Retail Sale Id 1534172',7500.00,0.00,0.00,12.50,912.50,'2022-01-16 11:27:55','',''),(2529472,'1','180','934',414,'Retail Sale Id 1534985',2400.00,0.00,0.00,4.00,292.00,'2022-01-16 12:42:37','',''),(2529862,'1','180','934',414,'Retail Sale Id 1535393',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 13:20:12','',''),(2531033,'1','180','934',414,'Retail Sale Id 1536504',600.00,0.00,0.00,1.00,73.00,'2022-01-16 15:06:17','',''),(2531142,'1','180','934',414,'Retail Sale Id 1536569',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 15:13:34','',''),(2531521,'1','180','934',414,'Retail Sale Id 1536865',22500.00,0.00,0.00,37.50,2737.50,'2022-01-16 15:50:22','',''),(2531576,'1','180','934',414,'Retail Sale Id 1536921',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 15:57:49','',''),(2531610,'1','180','934',414,'Retail Sale Id 1536961',1998.00,0.00,0.00,3.33,243.09,'2022-01-16 16:02:38','',''),(2532553,'1','180','934',414,'Retail Sale Id 1537797',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 17:18:20','',''),(2532706,'1','180','934',414,'Retail Sale Id 1538037',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 17:32:23','',''),(2532738,'1','180','934',414,'Retail Sale Id 1538069',1002.00,0.00,0.00,1.67,121.91,'2022-01-16 17:34:42','',''),(2532981,'1','180','934',414,'Retail Sale Id 1538288',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 17:53:41','',''),(2533021,'1','180','934',414,'Retail Sale Id 1538330',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 17:57:51','',''),(2533126,'1','180','934',414,'Retail Sale Id 1538427',1998.00,0.00,0.00,3.33,243.09,'2022-01-16 18:08:25','',''),(2533224,'1','180','934',414,'Retail Sale Id 1538490',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 18:15:51','',''),(2534794,'1','180','934',414,'Retail Sale Id 1539467',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 08:37:03','',''),(2534950,'1','180','934',414,'Retail Sale Id 1539637',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 08:57:49','',''),(2535467,'1','180','934',414,'Retail Sale Id 1540014',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 09:50:56','',''),(2535472,'1','180','934',414,'Retail Sale Id 1540049',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 09:51:37','',''),(2537224,'1','180','934',414,'Retail Sale Id 1541604',4500.00,0.00,0.00,7.50,547.50,'2022-01-17 13:27:27','',''),(2537243,'1','180','934',414,'Retail Sale Id 1541621',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 13:29:53','',''),(2537263,'1','180','934',414,'Retail Sale Id 1541638',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 13:32:13','',''),(2537283,'1','180','934',414,'Retail Sale Id 1541024',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 13:35:35','',''),(2537321,'1','180','934',414,'Retail Sale Id 1541698',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 13:39:52','',''),(2537336,'1','180','934',414,'Retail Sale Id 1541718',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 13:41:21','',''),(2537348,'1','180','934',414,'Retail Sale Id 1541729',2502.00,0.00,0.00,4.17,304.41,'2022-01-17 13:42:47','',''),(2537354,'1','180','934',414,'Retail Sale Id 1541736',1500.00,0.00,0.00,2.50,182.50,'2022-01-17 13:44:02','',''),(2537383,'1','180','934',414,'Retail Sale Id 1541766',64960.00,0.00,0.00,116.00,3828.00,'2022-01-17 13:48:04','',''),(2537394,'1','180','934',414,'Retail Sale Id 1541776',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 13:49:00','',''),(2537869,'1','180','934',414,'Retail Sale Id 1542146',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 14:36:56','',''),(2537926,'1','180','934',414,'Retail Sale Id 1542194',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 14:43:34','',''),(2538073,'1','180','934',414,'Retail Sale Id 1542321',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 14:58:51','',''),(2538419,'1','180','934',414,'Retail Sale Id 1542570',900.00,0.00,0.00,1.50,109.50,'2022-01-17 15:27:48','',''),(2538748,'1','180','934',414,'Retail Sale Id 1542848',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 15:58:31','',''),(2538963,'1','180','934',414,'Retail Sale Id 1543043',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 16:19:58','',''),(2540288,'1','180','934',414,'Retail Sale Id 1544325',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 18:02:27','',''),(2540311,'1','180','934',414,'Retail Sale Id 1544342',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 18:04:12','',''),(2541834,'1','180','934',414,'Retail Sale Id 1545606',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 09:07:22','',''),(2541897,'1','180','934',414,'Retail Sale Id 1545652',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 09:12:55','',''),(2541904,'1','180','934',414,'Retail Sale Id 1545664',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 09:14:27','',''),(2541938,'1','180','934',414,'Retail Sale Id 1545672',2400.00,0.00,0.00,4.00,292.00,'2022-01-18 09:15:50','',''),(2542431,'1','180','934',414,'Retail Sale Id 1545996',1998.00,0.00,0.00,3.33,243.09,'2022-01-18 10:00:45','',''),(2543255,'1','180','934',414,'Retail Sale Id 1546652',1200.00,0.00,0.00,2.00,146.00,'2022-01-18 11:15:23','',''),(2543496,'1','180','934',414,'Retail Sale Id 1546855',6000.00,0.00,0.00,10.00,730.00,'2022-01-18 11:41:29','',''),(2543510,'1','180','934',414,'Retail Sale Id 1546872',1998.00,0.00,0.00,3.33,243.09,'2022-01-18 11:43:30','',''),(2543524,'1','180','934',414,'Retail Sale Id 1546884',1998.00,0.00,0.00,3.33,243.09,'2022-01-18 11:45:09','',''),(2543538,'1','180','934',414,'Retail Sale Id 1546894',1002.00,0.00,0.00,1.67,121.91,'2022-01-18 11:47:00','',''),(2543980,'1','180','934',414,'Retail Sale Id 1547331',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 12:41:37','',''),(2544396,'1','180','934',414,'Retail Sale Id 1547775',3600.00,0.00,0.00,6.00,438.00,'2022-01-18 13:35:11','',''),(2544442,'1','180','934',414,'Retail Sale Id 1547814',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 13:40:49','',''),(2544816,'1','180','934',414,'Retail Sale Id 1548164',1200.00,0.00,0.00,2.00,146.00,'2022-01-18 14:22:22','',''),(2544844,'1','180','934',414,'Retail Sale Id 1548179',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 14:24:00','',''),(2545631,'1','180','934',414,'Retail Sale Id 1545665',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 15:33:47','',''),(2545879,'1','180','934',414,'Retail Sale Id 1549003',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 15:54:10','',''),(2545891,'1','180','934',414,'Retail Sale Id 1549017',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 15:55:13','',''),(2545928,'1','180','934',414,'Retail Sale Id 1549051',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 15:58:18','',''),(2546424,'1','180','934',414,'Retail Sale Id 1549518',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 16:44:37','',''),(2546534,'1','180','934',414,'Retail Sale Id 1549615',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 16:53:38','',''),(2546668,'1','180','934',414,'Retail Sale Id 1547815',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 17:01:32','',''),(2546832,'1','180','934',414,'Retail Sale Id 1549866',6000.00,0.00,0.00,10.00,730.00,'2022-01-18 17:13:25','',''),(2547062,'1','180','934',414,'Retail Sale Id 1550097',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:30:40','',''),(2547072,'1','180','934',414,'Retail Sale Id 1550110',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 17:31:33','',''),(2547390,'1','180','934',414,'Retail Sale Id 1550411',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:58:09','',''),(2547719,'1','180','934',414,'Retail Sale Id 1550768',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 18:42:54','',''),(2549095,'1','180','934',414,'Retail Sale Id 1551662',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 08:32:12','',''),(2549557,'1','180','934',414,'Retail Sale Id 1552051',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 09:06:57','',''),(2549810,'1','180','934',414,'Retail Sale Id 1552275',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 09:28:09','',''),(2551234,'1','180','934',414,'Retail Sale Id 1553691',33600.00,0.00,0.00,60.00,1980.00,'2022-01-19 11:51:07','',''),(2551467,'1','180','934',414,'Retail Sale Id 1553936',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 12:15:11','',''),(2551669,'1','180','934',414,'Retail Sale Id 1554129',1200.00,0.00,0.00,2.00,146.00,'2022-01-19 12:40:28','',''),(2551950,'1','180','934',414,'Retail Sale Id 1554400',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 13:19:39','',''),(2552097,'1','180','934',414,'Retail Sale Id 1554531',3000.00,0.00,0.00,5.00,365.00,'2022-01-19 13:37:54','',''),(2552444,'1','180','934',414,'Retail Sale Id 1554872',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 14:16:03','',''),(2552609,'1','180','934',414,'Retail Sale Id 1555003',28000.00,0.00,0.00,50.00,1650.00,'2022-01-19 14:30:59','',''),(2553165,'1','180','934',414,'Retail Sale Id 1555515',2502.00,0.00,0.00,4.17,304.41,'2022-01-19 15:24:58','',''),(2553423,'1','180','934',414,'Retail Sale Id 1555691',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 15:43:03','',''),(2554352,'1','180','934',414,'Retail Sale Id 1556458',1998.00,0.00,0.00,3.33,243.09,'2022-01-19 16:54:57','',''),(2554834,'1','180','934',414,'Retail Sale Id 1556965',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 17:29:58','',''),(2555139,'1','180','934',414,'Retail Sale Id 1557273',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 17:56:27','',''),(2555247,'1','180','934',414,'Retail Sale Id 1557362',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 18:04:43','',''),(2555319,'1','180','934',414,'Retail Sale Id 1557437',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 18:14:30','',''),(2555470,'1','180','934',414,'Retail Sale Id 1557576',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 18:36:07','',''),(2557911,'1','180','934',414,'Retail Sale Id 1559416',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 10:05:08','',''),(2558059,'1','180','934',414,'Retail Sale Id 1559539',3300.00,0.00,0.00,5.50,401.50,'2022-01-20 10:17:41','',''),(2558584,'1','180','934',414,'Retail Sale Id 1559937',1002.00,0.00,0.00,1.67,121.91,'2022-01-20 10:51:03','',''),(2559099,'1','180','934',414,'Retail Sale Id 1560488',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 11:42:36','',''),(2559225,'1','180','934',414,'Retail Sale Id 1560630',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 11:54:51','',''),(2560127,'1','180','934',414,'Retail Sale Id 1561641',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 13:30:03','',''),(2560205,'1','180','934',414,'Retail Sale Id 1561718',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 13:39:29','',''),(2560305,'1','180','934',414,'Retail Sale Id 1561812',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 13:49:13','',''),(2560432,'1','180','934',414,'Retail Sale Id 1561927',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 13:59:43','',''),(2560530,'1','180','934',414,'Retail Sale Id 1562009',64960.00,0.00,0.00,116.00,3828.00,'2022-01-20 14:10:25','',''),(2560585,'1','180','934',414,'Retail Sale Id 1562100',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 14:16:01','',''),(2561182,'1','180','934',414,'Retail Sale Id 1562641',15000.00,0.00,0.00,25.00,1825.00,'2022-01-20 15:06:03','',''),(2561256,'1','180','934',414,'Retail Sale Id 1562718',4800.00,0.00,0.00,8.00,584.00,'2022-01-20 15:12:26','',''),(2561437,'1','180','934',414,'Retail Sale Id 1562856',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 15:27:02','',''),(2561525,'1','180','934',414,'Retail Sale Id 1562952',4002.00,0.00,0.00,6.67,486.91,'2022-01-20 15:35:44','',''),(2561802,'1','180','934',414,'Retail Sale Id 1563429',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 16:05:53','',''),(2562032,'1','180','934',414,'Retail Sale Id 1563604',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 16:21:05','',''),(2562041,'1','180','934',414,'Retail Sale Id 1563623',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 16:22:00','',''),(2562167,'1','180','934',414,'Retail Sale Id 1563764',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 16:31:21','',''),(2562199,'1','180','934',414,'Retail Sale Id 1563790',1500.00,0.00,0.00,2.50,182.50,'2022-01-20 16:33:51','',''),(2562232,'1','180','934',414,'Retail Sale Id 1563819',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 16:35:28','',''),(2562376,'1','180','934',414,'Retail Sale Id 1563906',1998.00,0.00,0.00,3.33,243.09,'2022-01-20 16:42:57','',''),(2562575,'1','180','934',414,'Retail Sale Id 1564070',2400.00,0.00,0.00,4.00,292.00,'2022-01-20 16:54:53','',''),(2562673,'1','180','934',414,'Retail Sale Id 1564221',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 17:02:40','',''),(2562793,'1','180','934',414,'Retail Sale Id 1564344',7500.00,0.00,0.00,12.50,912.50,'2022-01-20 17:10:09','',''),(2562829,'1','180','934',414,'Retail Sale Id 1564382',1002.00,0.00,0.00,1.67,121.91,'2022-01-20 17:12:39','',''),(2562994,'1','180','934',414,'Retail Sale Id 1564582',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 17:23:51','',''),(2563012,'1','180','934',414,'Retail Sale Id 1564603',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 17:25:11','',''),(2563369,'1','180','934',414,'Retail Sale Id 1565035',7200.00,0.00,0.00,12.00,876.00,'2022-01-20 17:55:41','',''),(2565399,'1','180','934',414,'Retail Sale Id 1566667',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 08:44:53','',''),(2565796,'1','180','934',414,'Retail Sale Id 1567058',3000.00,0.00,0.00,5.00,365.00,'2022-01-21 09:21:19','',''),(2566988,'1','180','934',414,'Retail Sale Id 1568042',1002.00,0.00,0.00,1.67,121.91,'2022-01-21 11:07:53','',''),(2567008,'1','180','934',414,'Retail Sale Id 1568060',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 11:09:15','',''),(2567028,'1','180','934',414,'Retail Sale Id 1568080',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 11:11:24','',''),(2567037,'1','180','934',414,'Retail Sale Id 1568087',1998.00,0.00,0.00,3.33,243.09,'2022-01-21 11:12:44','',''),(2568384,'1','180','934',414,'Retail Sale Id 1569282',3000.00,0.00,0.00,5.00,365.00,'2022-01-21 13:25:45','',''),(2568443,'1','180','934',414,'Retail Sale Id 1569336',1998.00,0.00,0.00,3.33,243.09,'2022-01-21 13:34:04','',''),(2568464,'1','180','934',414,'Retail Sale Id 1569357',600.00,0.00,0.00,1.00,73.00,'2022-01-21 13:36:21','',''),(2568471,'1','180','934',414,'Retail Sale Id 1569364',6000.00,0.00,0.00,10.00,730.00,'2022-01-21 13:37:35','',''),(2568514,'1','180','934',414,'Retail Sale Id 1569408',476000.00,0.00,0.00,850.00,28050.00,'2022-01-21 13:43:14','',''),(2569353,'1','180','934',414,'Retail Sale Id 1570240',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 15:08:53','',''),(2570293,'1','180','934',414,'Retail Sale Id 1571241',1998.00,0.00,0.00,3.33,243.09,'2022-01-21 16:23:23','',''),(2570654,'1','180','934',414,'Retail Sale Id 1571526',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 16:45:55','',''),(2571160,'1','180','934',414,'Retail Sale Id 1572059',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 17:18:26','',''),(2571423,'1','180','934',414,'Retail Sale Id 1572302',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 17:34:52','',''),(2572007,'1','180','934',414,'Retail Sale Id 1572908',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 18:28:53','',''),(2573379,'1','180','934',414,'Retail Sale Id 1573845',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 08:14:45','',''),(2574148,'1','180','934',414,'Retail Sale Id 1574617',1002.00,0.00,0.00,1.67,121.91,'2022-01-22 09:32:02','',''),(2574161,'1','180','934',414,'Retail Sale Id 1574630',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 09:33:18','',''),(2574177,'1','180','934',414,'Retail Sale Id 1574647',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 09:35:07','',''),(2576116,'1','180','934',414,'Retail Sale Id 1576488',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 12:00:03','',''),(2576652,'1','180','934',414,'Retail Sale Id 1576985',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 12:37:59','',''),(2576970,'1','180','934',414,'Retail Sale Id 1577342',32480.00,0.00,0.00,58.00,1914.00,'2022-01-22 13:00:46','',''),(2577002,'1','180','934',414,'Retail Sale Id 1577365',168000.00,0.00,0.00,300.00,9900.00,'2022-01-22 13:02:40','',''),(2577054,'1','180','934',414,'Retail Sale Id 1577409',33600.00,0.00,0.00,60.00,1980.00,'2022-01-22 13:07:18','',''),(2577068,'1','180','934',414,'Retail Sale Id 1577423',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 13:08:24','',''),(2577077,'1','180','934',414,'Retail Sale Id 1577433',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 13:09:26','',''),(2577183,'1','180','934',414,'Retail Sale Id 1577524',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 13:20:49','',''),(2578328,'1','180','934',414,'Retail Sale Id 1578568',1998.00,0.00,0.00,3.33,243.09,'2022-01-22 15:01:18','',''),(2578493,'1','180','934',414,'Retail Sale Id 1578665',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 15:09:40','',''),(2578933,'1','180','934',414,'Retail Sale Id 1579044',1998.00,0.00,0.00,3.33,243.09,'2022-01-22 15:45:50','',''),(2579095,'1','180','934',414,'Retail Sale Id 1579195',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 16:01:00','',''),(2579116,'1','180','934',414,'Retail Sale Id 1579209',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 16:02:26','',''),(2579294,'1','180','934',414,'Retail Sale Id 1579377',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 16:19:57','',''),(2580248,'1','180','934',414,'Retail Sale Id 1580277',11100.00,0.00,0.00,18.50,1350.50,'2022-01-22 17:28:44','',''),(2580304,'1','180','934',414,'Retail Sale Id 1580330',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 17:33:09','',''),(2580543,'1','180','934',414,'Retail Sale Id 1580570',1200.00,0.00,0.00,2.00,146.00,'2022-01-22 17:50:24','',''),(2580926,'1','180','934',414,'Retail Sale Id 1581132',600.00,0.00,0.00,1.00,73.00,'2022-01-22 18:31:36','',''),(2580997,'1','180','934',414,'Retail Sale Id 1581238',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 18:42:13','',''),(2581162,'1','180','934',414,'Retail Sale Id 1581457',32480.00,0.00,0.00,58.00,1914.00,'2022-01-22 19:10:05','',''),(2581200,'1','180','934',414,'Retail Sale Id 1581492',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 19:16:06','',''),(2582990,'1','180','934',414,'Retail Sale Id 1582613',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 09:12:24','',''),(2584246,'1','180','934',414,'Retail Sale Id 1583881',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 11:05:13','',''),(2584255,'1','180','934',414,'Retail Sale Id 1583891',1500.00,0.00,0.00,2.50,182.50,'2022-01-23 11:06:19','',''),(2584744,'1','180','934',414,'Retail Sale Id 1584392',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 11:53:45','',''),(2584842,'1','180','934',414,'Retail Sale Id 1584517',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 12:03:44','',''),(2584954,'1','180','934',414,'Retail Sale Id 1584639',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 12:16:59','',''),(2585049,'1','180','934',414,'Retail Sale Id 1584733',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 12:26:12','',''),(2585064,'1','180','934',414,'Retail Sale Id 1584749',32480.00,0.00,0.00,58.00,1914.00,'2022-01-23 12:27:28','',''),(2585178,'1','180','934',414,'Retail Sale Id 1584873',1200.00,0.00,0.00,2.00,146.00,'2022-01-23 12:38:41','',''),(2585221,'1','180','934',414,'Retail Sale Id 1584911',600.00,0.00,0.00,1.00,73.00,'2022-01-23 12:42:01','',''),(2585271,'1','180','934',414,'Retail Sale Id 1584949',9600.00,0.00,0.00,16.00,1168.00,'2022-01-23 12:45:01','',''),(2585303,'1','180','934',414,'Retail Sale Id 1584985',33600.00,0.00,0.00,60.00,1980.00,'2022-01-23 12:47:34','',''),(2585447,'1','180','934',414,'Retail Sale Id 1585131',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 12:59:47','',''),(2585839,'1','180','934',414,'Retail Sale Id 1585528',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 13:32:48','',''),(2586186,'1','180','934',414,'Retail Sale Id 1585846',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 13:57:12','',''),(2586211,'1','180','934',414,'Retail Sale Id 1585870',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 13:58:58','',''),(2586982,'1','180','934',414,'Retail Sale Id 1586513',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 14:54:58','',''),(2587040,'1','180','934',414,'Retail Sale Id 1586575',1998.00,0.00,0.00,3.33,243.09,'2022-01-23 15:00:15','',''),(2587482,'1','180','934',414,'Retail Sale Id 1586972',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 15:40:11','',''),(2587496,'1','180','934',414,'Retail Sale Id 1586986',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 15:42:30','',''),(2587593,'1','180','934',414,'Retail Sale Id 1587048',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 15:49:31','',''),(2588050,'1','180','934',414,'Retail Sale Id 1587347',2502.00,0.00,0.00,4.17,304.41,'2022-01-23 16:33:41','',''),(2588274,'1','180','934',414,'Retail Sale Id 1587537',67200.00,0.00,0.00,120.00,3960.00,'2022-01-23 16:56:09','',''),(2588401,'1','180','934',414,'Retail Sale Id 1587655',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 17:10:40','',''),(2588498,'1','180','934',414,'Retail Sale Id 1587759',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 17:17:54','',''),(2588593,'1','180','934',414,'Retail Sale Id 1587818',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 17:23:41','',''),(2588798,'1','180','934',414,'Retail Sale Id 1587945',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 17:36:11','',''),(2588952,'1','180','934',414,'Retail Sale Id 1588138',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 17:49:08','',''),(2589279,'1','180','934',414,'Retail Sale Id 1588468',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 18:27:14','',''),(2591541,'1','180','934',414,'Retail Sale Id 1589962',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 10:17:05','',''),(2591631,'1','180','934',414,'Retail Sale Id 1590055',6000.00,0.00,0.00,10.00,730.00,'2022-01-24 10:27:37','',''),(2591656,'1','180','934',414,'Retail Sale Id 1590085',7200.00,0.00,0.00,12.00,876.00,'2022-01-24 10:30:49','',''),(2591661,'1','180','934',414,'Retail Sale Id 1590095',6000.00,0.00,0.00,10.00,730.00,'2022-01-24 10:31:29','',''),(2591663,'1','180','934',414,'Retail Sale Id 1590100',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 10:32:07','',''),(2591956,'1','180','934',414,'Retail Sale Id 1590362',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 11:04:32','',''),(2591960,'1','180','934',414,'Retail Sale Id 1590366',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 11:05:14','',''),(2594139,'1','180','934',414,'Retail Sale Id 1592319',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 14:58:02','',''),(2594165,'1','180','934',414,'Retail Sale Id 1592327',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 14:59:03','',''),(2594193,'1','180','934',414,'Retail Sale Id 1592348',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 15:01:53','',''),(2594201,'1','180','934',414,'Retail Sale Id 1592357',4200.00,0.00,0.00,7.00,511.00,'2022-01-24 15:02:36','',''),(2594206,'1','180','934',414,'Retail Sale Id 1592362',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 15:03:25','',''),(2594212,'1','180','934',414,'Retail Sale Id 1592373',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 15:04:06','',''),(2594288,'1','180','934',414,'Retail Sale Id 1592422',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 15:09:30','',''),(2594364,'1','180','934',414,'Retail Sale Id 1592485',1002.00,0.00,0.00,1.67,121.91,'2022-01-24 15:16:09','',''),(2594506,'1','180','934',414,'Retail Sale Id 1592572',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 15:24:43','',''),(2594513,'1','180','934',414,'Retail Sale Id 1592580',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 15:25:41','',''),(2594532,'1','180','934',414,'Retail Sale Id 1592592',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 15:26:56','',''),(2594542,'1','180','934',414,'Retail Sale Id 1592602',6000.00,0.00,0.00,10.00,730.00,'2022-01-24 15:28:22','',''),(2594552,'1','180','934',414,'Retail Sale Id 1592617',7500.00,0.00,0.00,12.50,912.50,'2022-01-24 15:29:17','',''),(2594633,'1','180','934',414,'Retail Sale Id 1592700',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 15:36:17','',''),(2594736,'1','180','934',414,'Retail Sale Id 1592815',56000.00,0.00,0.00,100.00,3300.00,'2022-01-24 15:46:46','',''),(2594835,'1','180','934',414,'Retail Sale Id 1592915',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 15:57:05','',''),(2595099,'1','180','934',414,'Retail Sale Id 1593209',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 16:25:03','',''),(2595125,'1','180','934',414,'Retail Sale Id 1593259',28000.00,0.00,0.00,50.00,1650.00,'2022-01-24 16:28:06','',''),(2595299,'1','180','934',414,'Retail Sale Id 1593682',7200.00,0.00,0.00,12.00,876.00,'2022-01-24 16:54:26','',''),(2595839,'1','180','934',414,'Retail Sale Id 1594306',1200.00,0.00,0.00,2.00,146.00,'2022-01-24 17:46:09','',''),(2595857,'1','180','934',414,'Retail Sale Id 1594321',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:47:50','',''),(2595876,'1','180','934',414,'Retail Sale Id 1594339',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 17:49:31','',''),(2595894,'1','180','934',414,'Retail Sale Id 1594364',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:51:24','',''),(2595953,'1','180','934',414,'Retail Sale Id 1594419',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:56:33','',''),(2595961,'1','180','934',414,'Retail Sale Id 1594429',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:57:43','',''),(2595973,'1','180','934',414,'Retail Sale Id 1594440',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 17:59:11','',''),(2596069,'1','180','934',414,'Retail Sale Id 1594587',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 18:04:23','',''),(2596197,'1','180','934',414,'Retail Sale Id 1594700',1500.00,0.00,0.00,2.50,182.50,'2022-01-24 18:20:59','',''),(2596209,'1','180','934',414,'Retail Sale Id 1594753',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 18:22:29','',''),(2597905,'1','180','934',414,'Retail Sale Id 1595978',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 08:48:40','',''),(2597915,'1','180','934',414,'Retail Sale Id 1595986',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 08:49:28','',''),(2599301,'1','180','934',414,'Retail Sale Id 1597319',7500.00,0.00,0.00,12.50,912.50,'2022-01-25 10:56:45','',''),(2599635,'1','180','934',414,'Retail Sale Id 1597621',3000.00,0.00,0.00,5.00,365.00,'2022-01-25 11:26:41','',''),(2599663,'1','180','934',414,'Retail Sale Id 1597641',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 11:28:36','',''),(2599676,'1','180','934',414,'Retail Sale Id 1597659',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 11:30:35','',''),(2599836,'1','180','934',414,'Retail Sale Id 1597806',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 11:44:45','',''),(2600051,'1','180','934',414,'Retail Sale Id 1597992',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 12:02:59','',''),(2600075,'1','180','934',414,'Retail Sale Id 1598015',1002.00,0.00,0.00,1.67,121.91,'2022-01-25 12:04:49','',''),(2600088,'1','180','934',414,'Retail Sale Id 1598027',7500.00,0.00,0.00,12.50,912.50,'2022-01-25 12:06:04','',''),(2600102,'1','180','934',414,'Retail Sale Id 1598046',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 12:07:54','',''),(2600124,'1','180','934',414,'Retail Sale Id 1598078',1602.00,0.00,0.00,2.67,194.91,'2022-01-25 12:10:09','',''),(2600180,'1','180','934',414,'Retail Sale Id 1598134',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 12:18:37','',''),(2600191,'1','180','934',414,'Retail Sale Id 1598147',7500.00,0.00,0.00,12.50,912.50,'2022-01-25 12:20:20','',''),(2600943,'1','180','934',414,'Retail Sale Id 1598881',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 13:37:25','',''),(2601307,'1','180','934',414,'Retail Sale Id 1599247',702.00,0.00,0.00,1.17,85.41,'2022-01-25 14:20:14','',''),(2601687,'1','180','934',414,'Retail Sale Id 1599711',1998.00,0.00,0.00,3.33,243.09,'2022-01-25 14:55:28','',''),(2603447,'1','180','934',414,'Retail Sale Id 1601231',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 17:03:36','',''),(2603731,'1','180','934',414,'Retail Sale Id 1601541',1998.00,0.00,0.00,3.33,243.09,'2022-01-25 17:25:52','',''),(2603741,'1','180','934',414,'Retail Sale Id 1601551',4002.00,0.00,0.00,6.67,486.91,'2022-01-25 17:27:11','',''),(2603772,'1','180','934',414,'Retail Sale Id 1601575',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 17:29:43','',''),(2603787,'1','180','934',414,'Retail Sale Id 1601600',1002.00,0.00,0.00,1.67,121.91,'2022-01-25 17:31:00','',''),(2603820,'1','180','934',414,'Retail Sale Id 1601635',1998.00,0.00,0.00,3.33,243.09,'2022-01-25 17:33:13','',''),(2604047,'1','180','934',414,'Retail Sale Id 1601872',1200.00,0.00,0.00,2.00,146.00,'2022-01-25 17:48:50','',''),(2604386,'1','180','934',414,'Retail Sale Id 1602191',1200.00,0.00,0.00,2.00,146.00,'2022-01-25 18:16:31','',''),(2605893,'1','180','934',414,'Retail Sale Id 1603142',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 07:37:49','',''),(2606069,'1','180','934',414,'Retail Sale Id 1603283',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 07:57:07','',''),(2606243,'1','180','934',414,'Retail Sale Id 1603444',1998.00,0.00,0.00,3.33,243.09,'2022-01-26 08:15:14','',''),(2606461,'1','180','934',414,'Retail Sale Id 1603652',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 08:36:00','',''),(2606855,'1','180','934',414,'Retail Sale Id 1604008',6000.00,0.00,0.00,10.00,730.00,'2022-01-26 09:14:41','',''),(2608139,'1','180','934',414,'Retail Sale Id 1605251',6000.00,0.00,0.00,10.00,730.00,'2022-01-26 11:22:13','',''),(2608321,'1','180','934',414,'Retail Sale Id 1605446',7800.00,0.00,0.00,13.00,949.00,'2022-01-26 11:40:25','',''),(2608353,'1','180','934',414,'Retail Sale Id 1605491',1002.00,0.00,0.00,1.67,121.91,'2022-01-26 11:45:24','',''),(2608402,'1','180','934',414,'Retail Sale Id 1605552',15000.00,0.00,0.00,25.00,1825.00,'2022-01-26 11:52:06','',''),(2608433,'1','180','934',414,'Retail Sale Id 1605584',7500.00,0.00,0.00,12.50,912.50,'2022-01-26 11:53:43','',''),(2608892,'1','180','934',414,'Retail Sale Id 1606285',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 12:49:36','',''),(2609106,'1','180','934',414,'Retail Sale Id 1606589',1200.00,0.00,0.00,2.00,146.00,'2022-01-26 13:18:01','',''),(2609138,'1','180','934',414,'Retail Sale Id 1606618',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 13:21:20','',''),(2609209,'1','180','934',414,'Retail Sale Id 1606695',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 13:32:34','',''),(2610099,'1','180','934',414,'Retail Sale Id 1607874',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 15:36:30','',''),(2610182,'1','180','934',414,'Retail Sale Id 1607887',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 15:45:28','',''),(2610252,'1','180','934',414,'Retail Sale Id 1608016',1398.00,0.00,0.00,2.33,170.09,'2022-01-26 15:51:55','',''),(2610258,'1','180','934',414,'Retail Sale Id 1606284',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 15:52:36','',''),(2610280,'1','180','934',414,'Retail Sale Id 1608037',33600.00,0.00,0.00,60.00,1980.00,'2022-01-26 15:53:45','',''),(2610604,'1','180','934',414,'Retail Sale Id 1608369',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 16:27:52','',''),(2610782,'1','180','934',414,'Retail Sale Id 1608549',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 16:45:06','',''),(2610922,'1','180','934',414,'Retail Sale Id 1608692',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 16:54:57','',''),(2610943,'1','180','934',414,'Retail Sale Id 1608715',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 16:56:55','',''),(2611259,'1','180','934',414,'Retail Sale Id 1609079',9300.00,0.00,0.00,15.50,1131.50,'2022-01-26 17:20:59','',''),(2611284,'1','180','934',414,'Retail Sale Id 1609100',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 17:22:39','',''),(2611422,'1','180','934',414,'Retail Sale Id 1609244',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 17:31:05','',''),(2611640,'1','180','934',414,'Retail Sale Id 1609471',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 17:47:42','',''),(2611733,'1','180','934',414,'Retail Sale Id 1609554',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 17:55:34','',''),(2611934,'1','180','934',414,'Retail Sale Id 1609863',900.00,0.00,0.00,1.50,109.50,'2022-01-26 18:27:55','',''),(2611944,'1','180','934',414,'Retail Sale Id 1609905',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 18:32:56','',''),(2611955,'1','180','934',414,'Retail Sale Id 1609917',6000.00,0.00,0.00,10.00,730.00,'2022-01-26 18:35:58','',''),(2611969,'1','180','934',414,'Retail Sale Id 1609933',7500.00,0.00,0.00,12.50,912.50,'2022-01-26 18:39:10','',''),(2611978,'1','180','934',414,'Retail Sale Id 1609942',600.00,0.00,0.00,1.00,73.00,'2022-01-26 18:41:28','',''),(2612429,'1','180','934',414,'Retail Sale Id 1610338',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 20:45:11','',''),(2612963,'1','180',NULL,414,'Balance from closing inventory values 2021-11-31 23:59:59',26752762.04,25782632.00,88925.50,87400.76,1619539.32,'2021-11-30 23:59:59','',''),(2613604,'1','180','934',0,'Balance from closing inventory values 2021-11-31 23:59:59',26752762.04,149112.00,35635.65,34030.91,1619539.32,'2021-11-30 23:59:59','',''),(2614330,'1','180','934',414,'Retail Sale Id 1610577',3600.00,0.00,0.00,6.00,438.00,'2022-01-27 07:49:21','',''),(2616232,'1','180','934',414,'Retail Sale Id 1612063',6000.00,0.00,0.00,10.00,730.00,'2022-01-27 10:24:02','',''),(2616724,'1','180','934',414,'Retail Sale Id 1612477',4800.00,0.00,0.00,8.00,584.00,'2022-01-27 11:03:04','',''),(2616738,'1','180','934',414,'Retail Sale Id 1612494',3000.00,0.00,0.00,5.00,365.00,'2022-01-27 11:04:10','',''),(2617402,'1','180','934',414,'Retail Sale Id 1613109',3600.00,0.00,0.00,6.00,438.00,'2022-01-27 12:09:57','',''),(2617419,'1','180','934',414,'Retail Sale Id 1613125',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 12:11:32','',''),(2617452,'1','180','934',414,'Retail Sale Id 1613152',2502.00,0.00,0.00,4.17,304.41,'2022-01-27 12:13:28','',''),(2617471,'1','180','934',414,'Retail Sale Id 1613172',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 12:15:04','',''),(2617868,'1','180','934',414,'Retail Sale Id 1613559',1002.00,0.00,0.00,1.67,121.91,'2022-01-27 12:55:39','',''),(2618138,'1','180','934',414,'Retail Sale Id 1613816',3000.00,0.00,0.00,5.00,365.00,'2022-01-27 13:27:39','',''),(2618806,'1','180','934',414,'Retail Sale Id 1614438',4002.00,0.00,0.00,6.67,486.91,'2022-01-27 14:40:01','',''),(2618828,'1','180','934',414,'Retail Sale Id 1614454',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 14:41:25','',''),(2619376,'1','180','934',414,'Retail Sale Id 1614935',7200.00,0.00,0.00,12.00,876.00,'2022-01-27 15:31:42','',''),(2619399,'1','180','934',414,'Retail Sale Id 1614958',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 15:33:22','',''),(2620019,'1','180','934',414,'Retail Sale Id 1615466',1002.00,0.00,0.00,1.67,121.91,'2022-01-27 16:20:13','',''),(2620223,'1','180','934',414,'Retail Sale Id 1615637',1002.00,0.00,0.00,1.67,121.91,'2022-01-27 16:34:58','',''),(2620251,'1','180','934',414,'Retail Sale Id 1615667',798.00,0.00,0.00,1.33,97.09,'2022-01-27 16:37:11','',''),(2620727,'1','180','934',414,'Retail Sale Id 1616077',5400.00,0.00,0.00,9.00,657.00,'2022-01-27 17:08:22','',''),(2620808,'1','180','934',414,'Retail Sale Id 1616156',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 17:13:09','',''),(2620857,'1','180','934',414,'Retail Sale Id 1616202',7200.00,0.00,0.00,12.00,876.00,'2022-01-27 17:16:40','',''),(2620936,'1','180','934',414,'Retail Sale Id 1616268',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 17:21:51','',''),(2621389,'1','180','934',414,'Retail Sale Id 1616674',1002.00,0.00,0.00,1.67,121.91,'2022-01-27 17:52:27','',''),(2621548,'1','180','934',414,'Retail Sale Id 1616804',900.00,0.00,0.00,1.50,109.50,'2022-01-27 18:06:22','',''),(2621563,'1','180','934',414,'Retail Sale Id 1616812',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 18:07:40','',''),(2622496,'1','180','934',414,'Retail Sale Id 1617443',67200.00,0.00,0.00,120.00,3960.00,'2022-01-27 20:42:39','',''),(2622497,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344948',56894.92,0.00,0.00,107.96,0.00,'2022-02-02 08:56:19','',''),(2622498,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,2636700.00,5100.00,0.00,0.00,'2022-02-02 08:59:45','',''),(2622499,'1','180',NULL,414,'Reception corrector for bridging 130290',0.00,0.00,0.00,5100.00,0.00,'2022-02-02 09:01:54','',''),(2622500,'1','180','934',414,'Received from bridging 130290',0.00,0.00,5100.00,0.00,0.00,'2022-02-02 09:01:54','',''),(2622501,'1','180','934',414,'Retail Sale Id 1617444',7500.00,0.00,0.00,12.50,1037.50,'2022-02-02 09:21:00','',''),(2622502,'1','180','934',414,'Retail Sale Id 1617445',67200.00,0.00,0.00,120.00,5160.00,'2022-02-02 09:25:13','',''),(2622503,'1','180','934',414,'Retail Sale Id 1617446',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 10:08:08','',''),(2622504,'1','180','934',414,'Retail Sale Id 1617447',3600.00,0.00,0.00,6.00,498.00,'2022-02-02 10:38:21','',''),(2622505,'1','180','934',414,'Retail Sale Id 1617448',1998.00,0.00,0.00,3.33,276.39,'2022-02-02 11:22:28','',''),(2622506,'1','180','934',414,'Retail Sale Id 1617449',6600.00,0.00,0.00,11.00,913.00,'2022-02-02 11:23:21','',''),(2622507,'1','180','934',414,'Retail Sale Id 1617450',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 11:41:04','',''),(2622508,'1','180','934',414,'Retail Sale Id 1617451',600.00,0.00,0.00,1.00,83.00,'2022-02-02 11:53:47','',''),(2622509,'1','180','934',414,'Retail Sale Id 1617452',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 12:03:56','',''),(2622510,'1','180','934',414,'Retail Sale Id 1617453',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 12:38:27','',''),(2622511,'1','180','934',414,'Retail Sale Id 1617454',97440.00,0.00,0.00,174.00,7482.00,'2022-02-02 12:49:37','',''),(2622512,'1','180','934',414,'Retail Sale Id 1617456',2502.00,0.00,0.00,4.17,346.11,'2022-02-02 13:15:30','',''),(2622513,'1','180','934',414,'Retail Sale Id 1617457',4200.00,0.00,0.00,7.00,581.00,'2022-02-02 13:33:59','',''),(2622514,'1','180','934',414,'Retail Sale Id 1617458',3600.00,0.00,0.00,6.00,498.00,'2022-02-02 13:58:10','',''),(2622515,'1','180','934',414,'Retail Sale Id 1617459',3600.00,0.00,0.00,6.00,498.00,'2022-02-02 14:07:45','',''),(2622516,'1','180','934',414,'Retail Sale Id 1617461',1200.00,0.00,0.00,2.00,166.00,'2022-02-02 15:24:30','',''),(2622517,'1','180','934',414,'Retail Sale Id 1617462',7500.00,0.00,0.00,12.50,1037.50,'2022-02-02 16:42:01','',''),(2622518,'1','180','934',414,'Retail Sale Id 1617463',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 16:43:53','',''),(2622519,'1','180','934',414,'Retail Sale Id 1617464',3000.00,0.00,0.00,5.00,415.00,'2022-02-02 17:20:33','',''),(2622520,'1','180','934',414,'Retail Sale Id 1617465',2502.00,0.00,0.00,4.17,346.11,'2022-02-02 17:21:41','',''),(2622521,'1','180','934',414,'Retail Sale Id 1617466',3600.00,0.00,0.00,6.00,498.00,'2022-02-02 17:27:13','',''),(2622522,'1','180','934',414,'Retail Sale Id 1617467',2400.00,0.00,0.00,4.00,332.00,'2022-02-02 18:33:10','',''),(2622523,'1','180','934',414,'Retail Sale Id 1617468',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 08:52:48','',''),(2622524,'1','180','934',414,'Retail Sale Id 1617469',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 09:21:02','',''),(2622525,'1','180','934',414,'Retail Sale Id 1617470',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 09:58:24','',''),(2622526,'1','180','934',414,'Retail Sale Id 1617471',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 10:37:23','',''),(2622527,'1','180','934',414,'Retail Sale Id 1617472',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 10:38:21','',''),(2622528,'1','180','934',414,'Retail Sale Id 1617473',2400.00,0.00,0.00,4.00,332.00,'2022-02-03 10:59:17','',''),(2622529,'1','180','934',414,'Retail Sale Id 1617474',1002.00,0.00,0.00,1.67,138.61,'2022-02-03 11:04:36','',''),(2622530,'1','180','934',414,'Retail Sale Id 1617475',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 11:34:03','',''),(2622531,'1','180','934',414,'Retail Sale Id 1617476',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 12:25:36','',''),(2622532,'1','180','934',414,'Retail Sale Id 1617477',1500.00,0.00,0.00,2.50,207.50,'2022-02-03 12:37:24','',''),(2622533,'1','180','934',414,'Retail Sale Id 1617478',2502.00,0.00,0.00,4.17,346.11,'2022-02-03 13:18:38','',''),(2622534,'1','180','934',414,'Retail Sale Id 1617479',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 13:46:09','',''),(2622535,'1','180','934',414,'Retail Sale Id 1617480',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 14:09:15','',''),(2622536,'1','180','934',414,'Retail Sale Id 1617481',2502.00,0.00,0.00,4.17,346.11,'2022-02-03 14:12:54','',''),(2622537,'1','180','934',414,'Retail Sale Id 1617482',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 14:14:19','',''),(2622538,'1','180','934',414,'Retail Sale Id 1617483',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 14:16:57','',''),(2622539,'1','180','934',414,'Retail Sale Id 1617484',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 15:16:52','',''),(2622540,'1','180','934',414,'Retail Sale Id 1617485',2502.00,0.00,0.00,4.17,346.11,'2022-02-03 15:19:22','',''),(2622541,'1','180','934',414,'Retail Sale Id 1617486',4002.00,0.00,0.00,6.67,553.61,'2022-02-03 15:55:08','',''),(2622542,'1','180','934',414,'Retail Sale Id 1617487',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 15:57:36','',''),(2622543,'1','180','934',414,'Retail Sale Id 1617488',1002.00,0.00,0.00,1.67,138.61,'2022-02-03 16:00:02','',''),(2622544,'1','180','934',414,'Retail Sale Id 1617489',1200.00,0.00,0.00,2.00,166.00,'2022-02-03 17:32:32','',''),(2622545,'1','180','934',414,'Retail Sale Id 1617490',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 17:42:11','',''),(2622546,'1','180','934',414,'Retail Sale Id 1617491',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 17:43:22','',''),(2622547,'1','180','934',414,'Retail Sale Id 1617492',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 08:13:22','',''),(2622548,'1','180','934',414,'Retail Sale Id 1617495',1602.00,0.00,0.00,2.67,221.61,'2022-02-04 09:40:56','',''),(2622549,'1','180','934',414,'Retail Sale Id 1617496',600.00,0.00,0.00,1.00,83.00,'2022-02-04 09:55:27','',''),(2622550,'1','180','934',414,'Retail Sale Id 1617497',1998.00,0.00,0.00,3.33,276.39,'2022-02-04 10:20:44','',''),(2622551,'1','180','934',414,'Retail Sale Id 1617499',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 10:24:04','',''),(2622552,'1','180','934',414,'Retail Sale Id 1617500',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 11:24:28','',''),(2622553,'1','180','934',414,'Retail Sale Id 1617501',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 12:37:53','',''),(2622554,'1','180','934',414,'Retail Sale Id 1617502',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 12:39:45','',''),(2622555,'1','180','934',414,'Retail Sale Id 1617503',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 13:05:26','',''),(2622556,'1','180','934',414,'Retail Sale Id 1617504',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 13:06:31','',''),(2622557,'1','180','934',414,'Retail Sale Id 1617505',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 13:23:16','',''),(2622558,'1','180','934',414,'Retail Sale Id 1617506',4800.00,0.00,0.00,8.00,664.00,'2022-02-04 13:24:35','',''),(2622559,'1','180','934',414,'Retail Sale Id 1617507',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 13:45:05','',''),(2622560,'1','180','934',414,'Retail Sale Id 1617508',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 13:53:34','',''),(2622561,'1','180','934',414,'Retail Sale Id 1617509',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 13:54:28','',''),(2622562,'1','180','934',414,'Retail Sale Id 1617510',798.00,0.00,0.00,1.33,110.39,'2022-02-04 15:02:59','',''),(2622563,'1','180','934',414,'Retail Sale Id 1617511',1998.00,0.00,0.00,3.33,276.39,'2022-02-04 15:20:33','',''),(2622564,'1','180','934',414,'Retail Sale Id 1617512',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 15:42:39','',''),(2622565,'1','180','934',414,'Retail Sale Id 1617513',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 15:50:48','',''),(2622566,'1','180','934',414,'Retail Sale Id 1617514',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 16:01:57','',''),(2622567,'1','180','934',414,'Retail Sale Id 1617515',1002.00,0.00,0.00,1.67,138.61,'2022-02-04 16:42:07','',''),(2622568,'1','180','934',414,'Retail Sale Id 1617516',1200.00,0.00,0.00,2.00,166.00,'2022-02-04 17:05:32','',''),(2622569,'1','180','934',414,'Retail Sale Id 1617517',1500.00,0.00,0.00,2.50,207.50,'2022-02-04 17:36:17','',''),(2622570,'1','180','934',414,'Retail Sale Id 1617518',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 17:44:46','',''),(2622571,'1','180','934',414,'Retail Sale Id 1617519',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 17:48:25','',''),(2622572,'1','180','934',414,'Retail Sale Id 1617520',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 18:05:51','',''),(2622573,'1','180','934',414,'Retail Sale Id 1617521',1002.00,0.00,0.00,1.67,138.61,'2022-02-04 18:15:27','',''),(2622574,'1','180','934',414,'Retail Sale Id 1617522',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 18:17:02','',''),(2622575,'1','180','934',414,'Retail Sale Id 1617523',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 18:25:42','',''),(2622576,'1','180','934',414,'Retail Sale Id 1617524',140000.00,0.00,0.00,250.00,10750.00,'2022-02-04 18:45:41','',''),(2622577,'1','180','934',414,'Retail Sale Id 1617525',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 09:30:14','',''),(2622578,'1','180','934',414,'Retail Sale Id 1617526',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 10:06:11','',''),(2622579,'1','180','934',414,'Retail Sale Id 1617527',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 10:21:52','',''),(2622580,'1','180','934',414,'Retail Sale Id 1617528',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 10:22:48','',''),(2622581,'1','180','934',414,'Retail Sale Id 1617529',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 11:07:08','',''),(2622582,'1','180','934',414,'Retail Sale Id 1617530',8100.00,0.00,0.00,13.50,1120.50,'2022-02-05 11:10:55','',''),(2622583,'1','180','934',414,'Retail Sale Id 1617531',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 11:22:40','',''),(2622584,'1','180','934',414,'Retail Sale Id 1617532',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 11:24:16','',''),(2622585,'1','180','934',414,'Retail Sale Id 1617533',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 11:33:13','',''),(2622586,'1','180','934',414,'Retail Sale Id 1617534',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 11:34:27','',''),(2622587,'1','180','934',414,'Retail Sale Id 1617535',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 11:40:56','',''),(2622588,'1','180','934',414,'Retail Sale Id 1617536',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 11:54:11','',''),(2622589,'1','180','934',414,'Retail Sale Id 1617537',4800.00,0.00,0.00,8.00,664.00,'2022-02-05 12:24:16','',''),(2622590,'1','180','934',414,'Retail Sale Id 1617538',3300.00,0.00,0.00,5.50,456.50,'2022-02-05 12:25:15','',''),(2622591,'1','180','934',414,'Retail Sale Id 1617539',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 12:26:01','',''),(2622592,'1','180','934',414,'Retail Sale Id 1617540',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 13:20:10','',''),(2622593,'1','180','934',414,'Retail Sale Id 1617541',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 13:21:30','',''),(2622594,'1','180','934',414,'Retail Sale Id 1617542',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 13:22:32','',''),(2622595,'1','180','934',414,'Retail Sale Id 1617543',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 13:39:47','',''),(2622596,'1','180','934',414,'Retail Sale Id 1617544',1998.00,0.00,0.00,3.33,276.39,'2022-02-05 13:41:03','',''),(2622597,'1','180','934',414,'Retail Sale Id 1617545',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 14:30:24','',''),(2622598,'1','180','934',414,'Retail Sale Id 1617546',1200.00,0.00,0.00,2.00,166.00,'2022-02-05 14:59:51','',''),(2622599,'1','180','934',414,'Retail Sale Id 1617547',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 15:49:50','',''),(2622600,'1','180','934',414,'Retail Sale Id 1617548',1002.00,0.00,0.00,1.67,138.61,'2022-02-05 15:50:52','',''),(2622601,'1','180','934',414,'Retail Sale Id 1617549',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 15:56:07','',''),(2622602,'1','180','934',414,'Retail Sale Id 1617550',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 16:00:07','',''),(2622603,'1','180','934',414,'Retail Sale Id 1617551',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:10:46','',''),(2622604,'1','180','934',414,'Retail Sale Id 1617552',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:24:09','',''),(2622605,'1','180','934',414,'Retail Sale Id 1617553',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 16:33:03','',''),(2622606,'1','180','934',414,'Retail Sale Id 1617554',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:46:15','',''),(2622607,'1','180','934',414,'Retail Sale Id 1617555',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:52:24','',''),(2622608,'1','180','934',414,'Retail Sale Id 1617556',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:55:04','',''),(2622609,'1','180','934',414,'Retail Sale Id 1617557',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 17:00:22','',''),(2622610,'1','180','934',414,'Retail Sale Id 1617558',1200.00,0.00,0.00,2.00,166.00,'2022-02-05 17:24:10','',''),(2622611,'1','180','934',414,'Retail Sale Id 1617559',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 18:09:15','',''),(2622612,'1','180','934',414,'Retail Sale Id 1617560',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 18:26:43','',''),(2622613,'1','180','934',414,'Retail Sale Id 1617561',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 18:27:48','',''),(2622614,'1','180','934',414,'Retail Sale Id 1617562',600.00,0.00,0.00,1.00,83.00,'2022-02-05 18:33:52','',''),(2622615,'1','180','934',414,'Retail Sale Id 1617563',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 09:25:15','',''),(2622616,'1','180','934',414,'Retail Sale Id 1617564',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 09:39:24','',''),(2622617,'1','180','934',414,'Retail Sale Id 1617565',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 09:51:30','',''),(2622618,'1','180','934',414,'Retail Sale Id 1617566',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 09:52:32','',''),(2622619,'1','180','934',414,'Retail Sale Id 1617567',1998.00,0.00,0.00,3.33,276.39,'2022-02-06 10:04:08','',''),(2622620,'1','180','934',414,'Retail Sale Id 1617568',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 11:09:27','',''),(2622621,'1','180','934',414,'Retail Sale Id 1617569',2502.00,0.00,0.00,4.17,346.11,'2022-02-06 11:13:08','',''),(2622622,'1','180','934',414,'Retail Sale Id 1617570',1200.00,0.00,0.00,2.00,166.00,'2022-02-06 12:03:43','',''),(2622623,'1','180','934',414,'Retail Sale Id 1617571',1200.00,0.00,0.00,2.00,166.00,'2022-02-06 12:23:34','',''),(2622624,'1','180','934',414,'Retail Sale Id 1617572',1200.00,0.00,0.00,2.00,166.00,'2022-02-06 12:28:38','',''),(2622625,'1','180','934',414,'Retail Sale Id 1617573',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 12:32:22','',''),(2622626,'1','180','934',414,'Retail Sale Id 1617574',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 12:45:18','',''),(2622627,'1','180','934',414,'Retail Sale Id 1617575',498.00,0.00,0.00,0.83,68.89,'2022-02-06 14:00:55','',''),(2622628,'1','180','934',414,'Retail Sale Id 1617576',1002.00,0.00,0.00,1.67,138.61,'2022-02-06 14:02:05','',''),(2622629,'1','180','934',414,'Retail Sale Id 1617577',1002.00,0.00,0.00,1.67,138.61,'2022-02-06 16:37:08','',''),(2622630,'1','180','934',414,'Retail Sale Id 1617578',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 18:11:55','',''),(2622631,'1','180','934',414,'Retail Sale Id 1617579',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 18:14:34','',''),(2622632,'1','180','934',414,'Retail Sale Id 1617580',2400.00,0.00,0.00,4.00,332.00,'2022-02-06 18:23:50','',''),(2622633,'1','180','934',414,'Retail Sale Id 1617581',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 18:39:22','',''),(2622634,'1','180','934',414,'Retail Sale Id 1617582',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 08:24:56','',''),(2622635,'1','180','934',414,'Retail Sale Id 1617583',2400.00,0.00,0.00,4.00,332.00,'2022-02-07 08:28:00','',''),(2622636,'1','180','934',414,'Retail Sale Id 1617584',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 09:45:36','',''),(2622637,'1','180','934',414,'Retail Sale Id 1617585',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 09:49:52','',''),(2622638,'1','180','934',414,'Retail Sale Id 1617586',2400.00,0.00,0.00,4.00,332.00,'2022-02-07 10:08:53','',''),(2622639,'1','180','934',414,'Retail Sale Id 1617587',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 10:24:52','',''),(2622640,'1','180','934',414,'Retail Sale Id 1617588',1998.00,0.00,0.00,3.33,276.39,'2022-02-07 10:39:15','',''),(2622641,'1','180','934',414,'Retail Sale Id 1617589',600.00,0.00,0.00,1.00,83.00,'2022-02-07 13:21:53','',''),(2622642,'1','180','934',414,'Retail Sale Id 1617590',4002.00,0.00,0.00,6.67,553.61,'2022-02-07 14:01:18','',''),(2622643,'1','180','934',414,'Retail Sale Id 1617591',4800.00,0.00,0.00,8.00,664.00,'2022-02-07 19:16:02','',''),(2622644,'1','180','934',414,'Retail Sale Id 1617592',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 20:30:26','',''),(2622645,'1','180','934',414,'Retail Sale Id 1617593',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 20:31:17','',''),(2622646,'1','180','934',414,'Retail Sale Id 1617594',1500.00,0.00,0.00,2.50,207.50,'2022-02-07 20:32:21','',''),(2622647,'1','180','934',414,'Retail Sale Id 1617595',1500.00,0.00,0.00,2.50,207.50,'2022-02-07 20:33:27','',''),(2622648,'1','180','934',414,'Retail Sale Id 1617596',600.00,0.00,0.00,1.00,83.00,'2022-02-07 20:35:01','',''),(2622649,'1','180','934',414,'Retail Sale Id 1617597',498.00,0.00,0.00,0.83,68.89,'2022-02-08 11:40:27','',''),(2622650,'1','180','934',414,'Retail Sale Id 1617598',1998.00,0.00,0.00,3.33,276.39,'2022-02-08 12:05:16','',''),(2622651,'1','180','934',414,'Retail Sale Id 1617599',1998.00,0.00,0.00,3.33,276.39,'2022-02-08 12:11:41','',''),(2622652,'1','180','934',414,'Retail Sale Id 1617600',2700.00,0.00,0.00,4.50,373.50,'2022-02-08 12:12:25','',''),(2622653,'1','180','934',414,'Retail Sale Id 1617601',2400.00,0.00,0.00,4.00,332.00,'2022-02-08 12:13:09','',''),(2622654,'1','180','934',414,'Retail Sale Id 1617602',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 12:53:57','',''),(2622655,'1','180','934',414,'Retail Sale Id 1617603',1200.00,0.00,0.00,2.00,166.00,'2022-02-08 12:54:42','',''),(2622656,'1','180','934',414,'Retail Sale Id 1617604',1500.00,0.00,0.00,2.50,207.50,'2022-02-08 13:26:33','',''),(2622657,'1','180','934',414,'Retail Sale Id 1617605',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 13:39:29','',''),(2622658,'1','180','934',414,'Retail Sale Id 1617606',1500.00,0.00,0.00,2.50,207.50,'2022-02-08 14:47:37','',''),(2622659,'1','180','934',414,'Retail Sale Id 1617607',1998.00,0.00,0.00,3.33,276.39,'2022-02-08 14:54:00','',''),(2622660,'1','180','934',414,'Retail Sale Id 1617608',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 15:10:54','',''),(2622661,'1','180','934',414,'Retail Sale Id 1617609',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 15:19:33','',''),(2622662,'1','180','934',414,'Retail Sale Id 1617610',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 15:25:53','',''),(2622663,'1','180','934',414,'Retail Sale Id 1617611',2400.00,0.00,0.00,4.00,332.00,'2022-02-08 16:04:57','',''),(2622664,'1','180','934',414,'Retail Sale Id 1617612',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 16:55:12','',''),(2622665,'1','180','934',414,'Retail Sale Id 1617613',2400.00,0.00,0.00,4.00,332.00,'2022-02-08 17:04:58','',''),(2622666,'1','180','934',414,'Retail Sale Id 1617614',1998.00,0.00,0.00,3.33,276.39,'2022-02-08 17:19:05','',''),(2622667,'1','180','934',414,'Retail Sale Id 1617615',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 18:00:41','',''),(2622668,'1','180','934',414,'Retail Sale Id 1617616',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 18:22:13','',''),(2622669,'1','180','934',414,'Retail Sale Id 1617617',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 20:07:41','',''),(2622670,'1','180','934',414,'Retail Sale Id 1617618',2502.00,0.00,0.00,4.17,346.11,'2022-02-09 08:50:39','',''),(2622671,'1','180','934',414,'Retail Sale Id 1617619',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 08:57:40','',''),(2622672,'1','180','934',414,'Retail Sale Id 1617620',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 09:21:21','',''),(2622673,'1','180','934',414,'Retail Sale Id 1617621',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 10:08:24','',''),(2622674,'1','180','934',414,'Retail Sale Id 1617622',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 10:20:19','',''),(2622675,'1','180','934',414,'Retail Sale Id 1617623',7500.00,0.00,0.00,12.50,1037.50,'2022-02-09 10:26:27','',''),(2622676,'1','180','934',414,'Retail Sale Id 1617624',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 10:30:38','',''),(2622677,'1','180','934',414,'Retail Sale Id 1617625',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 10:31:50','',''),(2622678,'1','180','934',414,'Retail Sale Id 1617626',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 11:43:20','',''),(2622679,'1','180','934',414,'Retail Sale Id 1617627',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 12:01:24','',''),(2622680,'1','180','934',414,'Retail Sale Id 1617628',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 14:47:57','',''),(2622681,'1','180','934',414,'Retail Sale Id 1617629',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 15:36:42','',''),(2622682,'1','180','934',414,'Retail Sale Id 1617630',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 16:32:08','',''),(2622683,'1','180','934',414,'Retail Sale Id 1617631',1200.00,0.00,0.00,2.00,166.00,'2022-02-09 16:33:24','',''),(2622684,'1','180','934',414,'Retail Sale Id 1617632',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 16:57:44','',''),(2622685,'1','180','934',414,'Retail Sale Id 1617633',28000.00,0.00,0.00,50.00,2150.00,'2022-02-09 17:00:04','',''),(2622686,'1','180','934',414,'Retail Sale Id 1617634',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 17:02:57','',''),(2622687,'1','180','934',414,'Retail Sale Id 1617635',1998.00,0.00,0.00,3.33,276.39,'2022-02-09 17:16:10','',''),(2622688,'1','180','934',414,'Retail Sale Id 1617636',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 17:38:11','',''),(2622689,'1','180','934',414,'Retail Sale Id 1617637',1200.00,0.00,0.00,2.00,166.00,'2022-02-09 18:35:25','',''),(2622690,'1','180','934',414,'Retail Sale Id 1617638',7500.00,0.00,0.00,12.50,1037.50,'2022-02-09 18:40:49','',''),(2622691,'1','180','934',414,'Retail Sale Id 1617639',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 18:41:45','',''),(2622692,'1','180','934',414,'Retail Sale Id 1617640',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 09:46:02','',''),(2622693,'1','180','934',414,'Retail Sale Id 1617642',4998.00,0.00,0.00,8.33,691.39,'2022-02-10 09:48:28','',''),(2622694,'1','180','934',414,'Retail Sale Id 1617643',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 10:48:19','',''),(2622695,'1','180','934',414,'Retail Sale Id 1617644',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 10:49:31','',''),(2622696,'1','180','934',414,'Retail Sale Id 1617645',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 12:44:19','',''),(2622697,'1','180','934',414,'Retail Sale Id 1617646',2400.00,0.00,0.00,4.00,332.00,'2022-02-10 12:57:42','',''),(2622698,'1','180','934',414,'Retail Sale Id 1617647',702.00,0.00,0.00,1.17,97.11,'2022-02-10 13:45:29','',''),(2622699,'1','180','934',414,'Retail Sale Id 1617648',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 15:05:36','',''),(2622700,'1','180','934',414,'Retail Sale Id 1617652',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 15:15:57','',''),(2622701,'1','180','934',414,'Retail Sale Id 1617653',7500.00,0.00,0.00,12.50,1037.50,'2022-02-10 15:21:20','',''),(2622702,'1','180','934',414,'Retail Sale Id 1617654',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 15:37:46','',''),(2622703,'1','180','934',414,'Retail Sale Id 1617655',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 16:43:09','',''),(2622704,'1','180','934',414,'Retail Sale Id 1617656',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 17:03:00','',''),(2622705,'1','180','934',414,'Retail Sale Id 1617657',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 17:40:12','',''),(2622706,'1','180','934',414,'Retail Sale Id 1617658',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 18:00:37','',''),(2622707,'1','180','934',414,'Retail Sale Id 1617659',2502.00,0.00,0.00,4.17,346.11,'2022-02-10 18:08:42','',''),(2622708,'1','180','934',414,'Retail Sale Id 1617660',1002.00,0.00,0.00,1.67,138.61,'2022-02-11 08:39:26','',''),(2622709,'1','180','934',414,'Retail Sale Id 1617661',1998.00,0.00,0.00,3.33,276.39,'2022-02-11 09:02:32','',''),(2622710,'1','180','934',414,'Retail Sale Id 1617662',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 09:04:38','',''),(2622711,'1','180','934',414,'Retail Sale Id 1617664',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 09:58:50','',''),(2622712,'1','180','934',414,'Retail Sale Id 1617665',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 10:06:09','',''),(2622713,'1','180','934',414,'Retail Sale Id 1617666',1698.00,0.00,0.00,2.83,234.89,'2022-02-11 11:02:56','',''),(2622714,'1','180','934',414,'Retail Sale Id 1617667',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 11:04:16','',''),(2622715,'1','180','934',414,'Retail Sale Id 1617668',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 11:25:02','',''),(2622716,'1','180','934',414,'Retail Sale Id 1617669',3798.00,0.00,0.00,6.33,525.39,'2022-02-11 11:40:52','',''),(2622717,'1','180','934',414,'Retail Sale Id 1617670',7800.00,0.00,0.00,13.00,1079.00,'2022-02-11 11:43:18','',''),(2622718,'1','180','934',414,'Retail Sale Id 1617671',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 11:50:11','',''),(2622719,'1','180','934',414,'Retail Sale Id 1617672',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 12:41:34','',''),(2622720,'1','180','934',414,'Retail Sale Id 1617673',1998.00,0.00,0.00,3.33,276.39,'2022-02-11 13:18:00','',''),(2622721,'1','180','934',414,'Retail Sale Id 1617674',7500.00,0.00,0.00,12.50,1037.50,'2022-02-11 13:45:41','',''),(2622722,'1','180','934',414,'Retail Sale Id 1617675',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 15:17:17','',''),(2622723,'1','180','934',414,'Retail Sale Id 1617676',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 16:01:10','',''),(2622724,'1','180','934',414,'Retail Sale Id 1617678',6600.00,0.00,0.00,11.00,913.00,'2022-02-11 16:54:26','',''),(2622725,'1','180','934',414,'Retail Sale Id 1617679',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 17:15:23','',''),(2622726,'1','180','934',414,'Retail Sale Id 1617680',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 17:26:09','',''),(2622727,'1','180','934',414,'Retail Sale Id 1617681',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 17:42:53','',''),(2622728,'1','180','934',414,'Retail Sale Id 1617682',7200.00,0.00,0.00,12.00,996.00,'2022-02-11 17:46:20','',''),(2622729,'1','180','934',414,'Retail Sale Id 1617683',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 17:51:45','',''),(2622730,'1','180','934',414,'Retail Sale Id 1617684',1200.00,0.00,0.00,2.00,166.00,'2022-02-11 17:57:49','',''),(2622731,'1','180','934',414,'Retail Sale Id 1617685',2400.00,0.00,0.00,4.00,332.00,'2022-02-11 19:14:16','',''),(2622732,'1','180','934',414,'Retail Sale Id 1617686',798.00,0.00,0.00,1.33,110.39,'2022-02-11 19:17:13','',''),(2622733,'1','180','934',414,'Retail Sale Id 1617687',1500.00,0.00,0.00,2.50,207.50,'2022-02-12 08:38:23','',''),(2622734,'1','180','934',414,'Retail Sale Id 1617688',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 09:21:38','',''),(2622735,'1','180','934',414,'Retail Sale Id 1617689',1500.00,0.00,0.00,2.50,207.50,'2022-02-12 09:46:02','',''),(2622736,'1','180','934',414,'Retail Sale Id 1617690',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 10:40:12','',''),(2622737,'1','180','934',414,'Retail Sale Id 1617691',1200.00,0.00,0.00,2.00,166.00,'2022-02-12 10:43:32','',''),(2622738,'1','180','934',414,'Retail Sale Id 1617692',7500.00,0.00,0.00,12.50,1037.50,'2022-02-12 11:55:36','',''),(2622739,'1','180','934',414,'Retail Sale Id 1617693',2400.00,0.00,0.00,4.00,332.00,'2022-02-12 11:56:45','',''),(2622740,'1','180','934',414,'Retail Sale Id 1617695',67200.00,0.00,0.00,120.00,5160.00,'2022-02-12 12:14:42','',''),(2622741,'1','180','934',414,'Retail Sale Id 1617696',3498.00,0.00,0.00,5.83,483.89,'2022-02-12 12:19:57','',''),(2622742,'1','180','934',414,'Retail Sale Id 1617697',1998.00,0.00,0.00,3.33,276.39,'2022-02-12 12:47:28','',''),(2622743,'1','180','934',414,'Retail Sale Id 1617698',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 12:52:12','',''),(2622744,'1','180','934',414,'Retail Sale Id 1617699',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 13:14:45','',''),(2622745,'1','180','934',414,'Retail Sale Id 1617700',3000.00,0.00,0.00,5.00,415.00,'2022-02-12 13:43:12','',''),(2622746,'1','180','934',414,'Retail Sale Id 1617701',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 14:03:57','',''),(2622747,'1','180','934',414,'Retail Sale Id 1617702',1002.00,0.00,0.00,1.67,138.61,'2022-02-12 14:05:40','',''),(2622748,'1','180','934',414,'Retail Sale Id 1617703',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 14:26:48','',''),(2622749,'1','180','934',414,'Retail Sale Id 1617704',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 15:13:20','',''),(2622750,'1','180','934',414,'Retail Sale Id 1617705',2400.00,0.00,0.00,4.00,332.00,'2022-02-12 15:34:00','',''),(2622751,'1','180','934',414,'Retail Sale Id 1617706',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 17:08:10','',''),(2622752,'1','180','934',414,'Retail Sale Id 1617707',3000.00,0.00,0.00,5.00,415.00,'2022-02-12 18:17:34','',''),(2622753,'1','180','934',414,'Retail Sale Id 1617708',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 18:48:06','',''),(2622754,'1','180','934',414,'Retail Sale Id 1617709',5400.00,0.00,0.00,9.00,747.00,'2022-02-12 19:08:10','',''),(2622755,'1','180','934',414,'Retail Sale Id 1617710',1200.00,0.00,0.00,2.00,166.00,'2022-02-13 10:41:51','',''),(2622756,'1','180','934',414,'Retail Sale Id 1617711',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 10:43:24','',''),(2622757,'1','180','934',414,'Retail Sale Id 1617712',2700.00,0.00,0.00,4.50,373.50,'2022-02-13 10:45:13','',''),(2622758,'1','180','934',414,'Retail Sale Id 1617713',2520.00,0.00,0.00,4.20,348.60,'2022-02-13 10:46:35','',''),(2622759,'1','180','934',414,'Retail Sale Id 1617714',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 10:47:39','',''),(2622760,'1','180','934',414,'Retail Sale Id 1617715',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 12:35:08','',''),(2622761,'1','180','934',414,'Retail Sale Id 1617716',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 12:43:13','',''),(2622762,'1','180','934',414,'Retail Sale Id 1617717',1500.00,0.00,0.00,2.50,207.50,'2022-02-13 14:07:09','',''),(2622763,'1','180','934',414,'Retail Sale Id 1617718',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 15:08:07','',''),(2622764,'1','180','934',414,'Retail Sale Id 1617719',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 15:13:30','',''),(2622765,'1','180','934',414,'Retail Sale Id 1617720',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 15:44:42','',''),(2622766,'1','180','934',414,'Retail Sale Id 1617721',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 15:49:56','',''),(2622767,'1','180','934',414,'Retail Sale Id 1617722',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 16:37:09','',''),(2622768,'1','180','934',414,'Retail Sale Id 1617723',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 16:45:01','',''),(2622769,'1','180','934',414,'Retail Sale Id 1617724',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 16:46:05','',''),(2622770,'1','180','934',414,'Retail Sale Id 1617725',1200.00,0.00,0.00,2.00,166.00,'2022-02-13 16:58:38','',''),(2622771,'1','180','934',414,'Retail Sale Id 1617726',4998.00,0.00,0.00,8.33,691.39,'2022-02-13 17:23:45','',''),(2622772,'1','180','934',414,'Retail Sale Id 1617727',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 17:39:03','',''),(2622773,'1','180','934',414,'Retail Sale Id 1617728',1500.00,0.00,0.00,2.50,207.50,'2022-02-13 18:05:59','',''),(2622774,'1','180','934',414,'Retail Sale Id 1617729',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 18:40:51','',''),(2622775,'1','180','934',414,'Retail Sale Id 1617730',6997.76,0.00,0.00,12.32,628.32,'2022-02-14 11:00:26','',''),(2622776,'1','180','934',414,'Retail Sale Id 1617731',3976.00,0.00,0.00,7.00,357.00,'2022-02-14 11:22:59','',''),(2622777,'1','180','934',414,'Retail Sale Id 1617732',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 11:41:38','',''),(2622778,'1','180','934',414,'Retail Sale Id 1617733',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 13:47:08','',''),(2622779,'1','180','934',414,'Retail Sale Id 1617734',35360.00,0.00,0.00,65.00,1755.00,'2022-02-14 15:10:24','',''),(2622780,'1','180','934',414,'Retail Sale Id 1617735',1999.36,0.00,0.00,3.52,179.52,'2022-02-14 16:05:35','',''),(2622781,'1','180','934',414,'Retail Sale Id 1617736',1704.00,0.00,0.00,3.00,153.00,'2022-02-14 17:32:42','',''),(2622782,'1','180','934',414,'Retail Sale Id 1617737',1704.00,0.00,0.00,3.00,153.00,'2022-02-14 17:37:49','',''),(2622783,'1','180','934',414,'Retail Sale Id 1617738',3408.00,0.00,0.00,6.00,306.00,'2022-02-14 18:03:09','',''),(2622784,'1','180','934',414,'Retail Sale Id 1617739',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 09:08:09','',''),(2622785,'1','180','934',414,'Retail Sale Id 1617740',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 09:27:43','',''),(2622786,'1','180','934',414,'Retail Sale Id 1617741',4544.00,0.00,0.00,8.00,408.00,'2022-02-15 11:14:23','',''),(2622787,'1','180','934',414,'Retail Sale Id 1617742',1136.00,0.00,0.00,2.00,102.00,'2022-02-15 11:15:54','',''),(2622788,'1','180','934',414,'Retail Sale Id 1617743',65280.00,0.00,0.00,120.00,3240.00,'2022-02-15 13:59:19','',''),(2622789,'1','180','934',414,'Retail Sale Id 1617744',2840.00,0.00,0.00,5.00,255.00,'2022-02-15 15:28:26','',''),(2622790,'1','180','934',414,'Retail Sale Id 1617745',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 15:29:37','',''),(2622791,'1','180','934',414,'Retail Sale Id 1617746',1499.52,0.00,0.00,2.64,134.64,'2022-02-15 15:31:25','',''),(2622792,'1','180','934',414,'Retail Sale Id 1617747',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 16:26:52','',''),(2622793,'1','180','934',414,'Retail Sale Id 1617748',7100.00,0.00,0.00,12.50,637.50,'2022-02-15 16:53:41','',''),(2622794,'1','180','934',414,'Retail Sale Id 1617749',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 17:34:24','',''),(2622795,'1','180','934',414,'Retail Sale Id 1617750',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 17:48:32','',''),(2622796,'1','180','934',414,'Retail Sale Id 1617751',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 18:01:12','',''),(2622797,'1','180','934',414,'Retail Sale Id 1617752',1704.00,0.00,0.00,3.00,153.00,'2022-02-15 18:19:00','',''),(2622798,'1','180','934',414,'Retail Sale Id 1617753',3408.00,0.00,0.00,6.00,306.00,'2022-02-15 18:21:38','',''),(2622799,'1','180','934',414,'Retail Sale Id 1617754',1704.00,0.00,0.00,3.00,153.00,'2022-02-16 09:20:24','',''),(2622800,'1','180','934',414,'Retail Sale Id 1617755',1601.76,0.00,0.00,2.82,143.82,'2022-02-16 09:21:35','',''),(2622801,'1','180','934',414,'Retail Sale Id 1617756',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 09:43:51','',''),(2622802,'1','180','934',414,'Retail Sale Id 1617757',2840.00,0.00,0.00,5.00,255.00,'2022-02-16 10:10:26','',''),(2622803,'1','180','934',414,'Retail Sale Id 1617758',1704.00,0.00,0.00,3.00,153.00,'2022-02-16 11:14:06','',''),(2622804,'1','180','934',414,'Retail Sale Id 1617759',1840.32,0.00,0.00,3.24,165.24,'2022-02-16 11:15:51','',''),(2622805,'1','180','934',414,'Retail Sale Id 1617760',5112.00,0.00,0.00,9.00,459.00,'2022-02-16 12:58:47','',''),(2622806,'1','180','934',414,'Retail Sale Id 1617761',647.52,0.00,0.00,1.14,58.14,'2022-02-16 13:34:22','',''),(2622807,'1','180','934',414,'Retail Sale Id 1617762',2272.00,0.00,0.00,4.00,204.00,'2022-02-16 14:42:42','',''),(2622808,'1','180','934',414,'Retail Sale Id 1617763',1999.36,0.00,0.00,3.52,179.52,'2022-02-16 15:26:29','',''),(2622809,'1','180','934',414,'Retail Sale Id 1617764',1704.00,0.00,0.00,3.00,153.00,'2022-02-16 16:25:44','',''),(2622810,'1','180','934',414,'Retail Sale Id 1617765',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 17:32:50','',''),(2622811,'1','180','934',414,'Retail Sale Id 1617766',3408.00,0.00,0.00,6.00,306.00,'2022-02-16 17:40:34','',''),(2622812,'1','180','934',414,'Retail Sale Id 1617767',1704.00,0.00,0.00,3.00,153.00,'2022-02-16 17:46:16','',''),(2622813,'1','180','934',414,'Retail Sale Id 1617768',1471.12,0.00,0.00,2.59,132.09,'2022-02-16 19:05:58','',''),(2622814,'1','180','934',414,'Retail Sale Id 1617769',1704.00,0.00,0.00,3.00,153.00,'2022-02-17 10:43:18','',''),(2622815,'1','180','934',414,'Retail Sale Id 1617770',2840.00,0.00,0.00,5.00,255.00,'2022-02-17 10:44:12','',''),(2622816,'1','180','934',414,'Retail Sale Id 1617771',1198.48,0.00,0.00,2.11,107.61,'2022-02-17 11:22:59','',''),(2622817,'1','180','934',414,'Retail Sale Id 1617772',3998.72,0.00,0.00,7.04,359.04,'2022-02-17 11:23:49','',''),(2622818,'1','180','934',414,'Retail Sale Id 1617773',1704.00,0.00,0.00,3.00,153.00,'2022-02-17 11:25:00','',''),(2622819,'1','180','934',414,'Retail Sale Id 1617774',1601.76,0.00,0.00,2.82,143.82,'2022-02-17 11:26:40','',''),(2622820,'1','180','934',414,'Retail Sale Id 1617775',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 12:35:58','',''),(2622821,'1','180','934',414,'Retail Sale Id 1617776',4544.00,0.00,0.00,8.00,408.00,'2022-02-17 12:38:07','',''),(2622822,'1','180','934',414,'Retail Sale Id 1617777',1136.00,0.00,0.00,2.00,102.00,'2022-02-17 14:59:51','',''),(2622823,'1','180','934',414,'Retail Sale Id 1617778',1704.00,0.00,0.00,3.00,153.00,'2022-02-17 15:31:00','',''),(2622824,'1','180','934',414,'Retail Sale Id 1617779',1704.00,0.00,0.00,3.00,153.00,'2022-02-17 16:26:01','',''),(2622825,'1','180','934',414,'Retail Sale Id 1617780',1704.00,0.00,0.00,3.00,153.00,'2022-02-17 16:27:40','',''),(2622826,'1','180','934',414,'Retail Sale Id 1617781',1499.52,0.00,0.00,2.64,134.64,'2022-02-17 18:04:36','',''),(2622827,'1','180','934',414,'Retail Sale Id 1617782',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 18:14:36','',''),(2622828,'1','180','934',414,'Retail Sale Id 1617783',1999.36,0.00,0.00,3.52,179.52,'2022-02-17 18:15:59','',''),(2622829,'1','180','934',414,'Retail Sale Id 1617784',3408.00,0.00,0.00,6.00,306.00,'2022-02-17 19:02:14','',''),(2622830,'1','180','934',414,'Retail Sale Id 1617785',2999.04,0.00,0.00,5.28,269.28,'2022-02-18 11:52:53','',''),(2622831,'1','180','934',414,'Retail Sale Id 1617786',1704.00,0.00,0.00,3.00,153.00,'2022-02-18 12:30:33','',''),(2622832,'1','180','934',414,'Retail Sale Id 1617787',1704.00,0.00,0.00,3.00,153.00,'2022-02-18 13:37:39','',''),(2622833,'1','180','934',414,'Retail Sale Id 1617788',1704.00,0.00,0.00,3.00,153.00,'2022-02-18 14:59:47','',''),(2622834,'1','180','934',414,'Retail Sale Id 1617789',4544.00,0.00,0.00,8.00,408.00,'2022-02-18 15:41:13','',''),(2622835,'1','180','934',414,'Retail Sale Id 1617790',1704.00,0.00,0.00,3.00,153.00,'2022-02-18 16:15:58','',''),(2622836,'1','180','934',414,'Retail Sale Id 1617791',1198.48,0.00,0.00,2.11,107.61,'2022-02-18 17:33:14','',''),(2622837,'1','180','934',414,'Retail Sale Id 1617792',1704.00,0.00,0.00,3.00,153.00,'2022-02-18 17:46:21','',''),(2622838,'1','180','934',414,'Retail Sale Id 1617793',2698.00,0.00,0.00,4.75,242.25,'2022-02-18 17:54:00','',''),(2622839,'1','180','934',414,'Retail Sale Id 1617794',999.68,0.00,0.00,1.76,89.76,'2022-02-18 17:57:03','',''),(2622840,'1','180','934',414,'Retail Sale Id 1617795',1704.00,0.00,0.00,3.00,153.00,'2022-02-18 18:24:48','',''),(2622841,'1','180','934',414,'Retail Sale Id 1617796',999.68,0.00,0.00,1.76,89.76,'2022-02-18 18:30:53','',''),(2622842,'1','180','934',414,'Retail Sale Id 1617797',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 12:24:43','',''),(2622843,'1','180','934',414,'Retail Sale Id 1617798',2272.00,0.00,0.00,4.00,204.00,'2022-02-19 12:26:01','',''),(2622844,'1','180','934',414,'Retail Sale Id 1617799',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 12:26:37','',''),(2622845,'1','180','934',414,'Retail Sale Id 1617800',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 12:27:17','',''),(2622846,'1','180','934',414,'Retail Sale Id 1617801',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 12:29:24','',''),(2622847,'1','180','934',414,'Retail Sale Id 1617802',3408.00,0.00,0.00,6.00,306.00,'2022-02-19 14:06:58','',''),(2622848,'1','180','934',414,'Retail Sale Id 1617803',1999.36,0.00,0.00,3.52,179.52,'2022-02-19 14:08:20','',''),(2622849,'1','180','934',414,'Retail Sale Id 1617804',1499.52,0.00,0.00,2.64,134.64,'2022-02-19 14:19:17','',''),(2622850,'1','180','934',414,'Retail Sale Id 1617805',999.68,0.00,0.00,1.76,89.76,'2022-02-19 14:20:39','',''),(2622851,'1','180','934',414,'Retail Sale Id 1617806',999.68,0.00,0.00,1.76,89.76,'2022-02-19 15:55:41','',''),(2622852,'1','180','934',414,'Retail Sale Id 1617807',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 16:21:09','',''),(2622853,'1','180','934',414,'Retail Sale Id 1617808',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 16:41:15','',''),(2622854,'1','180','934',414,'Retail Sale Id 1617809',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 17:17:47','',''),(2622855,'1','180','934',414,'Retail Sale Id 1617810',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 18:03:48','',''),(2622856,'1','180','934',414,'Retail Sale Id 1617811',1704.00,0.00,0.00,3.00,153.00,'2022-02-19 18:05:41','',''),(2622857,'1','180','934',414,'Retail Sale Id 1617812',999.68,0.00,0.00,1.76,89.76,'2022-02-19 18:20:45','',''),(2622858,'1','180','934',414,'Retail Sale Id 1617813',4549.68,0.00,0.00,8.01,408.51,'2022-02-19 18:25:24','',''),(2622859,'1','180','934',414,'Retail Sale Id 1617814',2840.00,0.00,0.00,5.00,255.00,'2022-02-20 08:38:17','',''),(2622860,'1','180','934',414,'Retail Sale Id 1617815',2272.00,0.00,0.00,4.00,204.00,'2022-02-20 10:25:20','',''),(2622861,'1','180','934',414,'Retail Sale Id 1617816',1420.00,0.00,0.00,2.50,127.50,'2022-02-20 10:27:30','',''),(2622862,'1','180','934',414,'Retail Sale Id 1617817',1704.00,0.00,0.00,3.00,153.00,'2022-02-20 10:46:31','',''),(2622863,'1','180','934',414,'Retail Sale Id 1617818',999.68,0.00,0.00,1.76,89.76,'2022-02-20 12:24:05','',''),(2622864,'1','180','934',414,'Retail Sale Id 1617819',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 12:31:32','',''),(2622865,'1','180','934',414,'Retail Sale Id 1617820',3408.00,0.00,0.00,6.00,306.00,'2022-02-20 12:34:31','',''),(2622866,'1','180','934',414,'Retail Sale Id 1617821',3498.88,0.00,0.00,6.16,314.16,'2022-02-20 13:33:05','',''),(2622867,'1','180','934',414,'Return of Retail Sale Id 1617821',0.00,3498.88,6.16,0.00,-314.16,'2022-02-20 13:34:54','',''),(2622868,'1','180','934',414,'Retail Sale Id 1617822',3101.28,0.00,0.00,5.46,278.46,'2022-02-20 13:35:43','',''),(2622869,'1','180','934',414,'Retail Sale Id 1617823',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 14:14:39','',''),(2622870,'1','180','934',414,'Retail Sale Id 1617824',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 15:10:13','',''),(2622871,'1','180','934',414,'Retail Sale Id 1617825',1704.00,0.00,0.00,3.00,153.00,'2022-02-20 16:23:27','',''),(2622872,'1','180','934',414,'Retail Sale Id 1617826',1704.00,0.00,0.00,3.00,153.00,'2022-02-20 17:53:20','',''),(2622873,'1','180','934',414,'Retail Sale Id 1617827',1499.52,0.00,0.00,2.64,134.64,'2022-02-20 19:01:40','',''),(2622874,'1','180','934',414,'Retail Sale Id 1617828',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 19:42:45','',''),(2622875,'1','180','934',414,'Retail Sale Id 1617829',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 19:43:55','',''),(2622876,'1','180','934',414,'Retail Sale Id 1617830',7100.00,0.00,0.00,12.50,637.50,'2022-02-20 19:51:37','',''),(2622877,'1','180','934',414,'Retail Sale Id 1617831',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 12:06:21','',''),(2622878,'1','180','934',414,'Retail Sale Id 1617832',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 12:06:53','',''),(2622879,'1','180','934',414,'Retail Sale Id 1617833',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 12:07:39','',''),(2622880,'1','180','934',414,'Retail Sale Id 1617834',1704.00,0.00,0.00,3.00,153.00,'2022-02-21 12:08:46','',''),(2622881,'1','180','934',414,'Retail Sale Id 1617835',2272.00,0.00,0.00,4.00,204.00,'2022-02-21 12:09:26','',''),(2622882,'1','180','934',414,'Retail Sale Id 1617836',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 13:31:19','',''),(2622883,'1','180','934',414,'Retail Sale Id 1617837',999.68,0.00,0.00,1.76,89.76,'2022-02-21 13:37:19','',''),(2622884,'1','180','934',414,'Retail Sale Id 1617838',1704.00,0.00,0.00,3.00,153.00,'2022-02-21 13:45:20','',''),(2622885,'1','180','934',414,'Retail Sale Id 1617839',1704.00,0.00,0.00,3.00,153.00,'2022-02-21 14:03:23','',''),(2622886,'1','180','934',414,'Retail Sale Id 1617840',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 14:09:01','',''),(2622887,'1','180','934',414,'Retail Sale Id 1617841',1136.00,0.00,0.00,2.00,102.00,'2022-02-21 14:21:17','',''),(2622888,'1','180','934',414,'Retail Sale Id 1617842',3498.88,0.00,0.00,6.16,314.16,'2022-02-21 14:22:08','',''),(2622889,'1','180','934',414,'Retail Sale Id 1617843',5680.00,0.00,0.00,10.00,510.00,'2022-02-21 17:11:47','',''),(2622890,'1','180','934',414,'Retail Sale Id 1617844',2249.28,0.00,0.00,3.96,201.96,'2022-02-21 17:13:03','',''),(2622891,'1','180','934',414,'Retail Sale Id 1617845',3408.00,0.00,0.00,6.00,306.00,'2022-02-21 17:35:51','',''),(2622892,'1','180','934',414,'Retail Sale Id 1617846',7100.00,0.00,0.00,12.50,637.50,'2022-02-21 18:17:17','',''),(2622893,'1','180','934',414,'Retail Sale Id 1617847',1704.00,0.00,0.00,3.00,153.00,'2022-02-21 18:28:17','',''),(2622894,'1','180','934',414,'Retail Sale Id 1617848',1704.00,0.00,0.00,3.00,153.00,'2022-02-21 18:54:36','',''),(2622895,'1','180','934',414,'Retail Sale Id 1617849',2840.00,0.00,0.00,5.00,255.00,'2022-02-22 11:22:24','',''),(2622896,'1','180','934',414,'Retail Sale Id 1617850',1704.00,0.00,0.00,3.00,153.00,'2022-02-22 11:23:03','',''),(2622897,'1','180','934',414,'Retail Sale Id 1617851',2999.04,0.00,0.00,5.28,269.28,'2022-02-22 11:23:49','',''),(2622898,'1','180','934',414,'Retail Sale Id 1617852',1704.00,0.00,0.00,3.00,153.00,'2022-02-22 17:17:46','',''),(2622899,'1','180','934',414,'Retail Sale Id 1617853',3976.00,0.00,0.00,7.00,357.00,'2022-02-22 18:48:38','',''),(2622900,'1','180','934',414,'Retail Sale Id 1617854',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 19:03:32','',''),(2622901,'1','180','934',414,'Retail Sale Id 1617855',130560.00,0.00,0.00,240.00,6480.00,'2022-02-22 20:16:37','',''),(2622902,'1','180','934',414,'Retail Sale Id 1617856',5344.88,0.00,0.00,9.41,479.91,'2022-02-22 20:21:19','',''),(2622903,'1','180','934',414,'Retail Sale Id 1617857',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 10:06:04','',''),(2622904,'1','180','934',414,'Retail Sale Id 1617858',2272.00,0.00,0.00,4.00,204.00,'2022-02-23 10:06:43','',''),(2622905,'1','180','934',414,'Retail Sale Id 1617859',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 11:37:51','',''),(2622906,'1','180','934',414,'Retail Sale Id 1617860',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 12:59:04','',''),(2622907,'1','180','934',414,'Retail Sale Id 1617861',2272.00,0.00,0.00,4.00,204.00,'2022-02-23 13:00:12','',''),(2622908,'1','180','934',414,'Retail Sale Id 1617862',1198.48,0.00,0.00,2.11,107.61,'2022-02-23 13:04:58','',''),(2622909,'1','180','934',414,'Retail Sale Id 1617863',999.68,0.00,0.00,1.76,89.76,'2022-02-23 13:36:30','',''),(2622910,'1','180','934',414,'Retail Sale Id 1617864',2840.00,0.00,0.00,5.00,255.00,'2022-02-23 14:00:28','',''),(2622911,'1','180','934',414,'Retail Sale Id 1617865',1136.00,0.00,0.00,2.00,102.00,'2022-02-23 14:36:20','',''),(2622912,'1','180','934',414,'Retail Sale Id 1617866',2999.04,0.00,0.00,5.28,269.28,'2022-02-23 14:53:26','',''),(2622913,'1','180','934',414,'Retail Sale Id 1617867',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 17:31:40','',''),(2622914,'1','180','934',414,'Retail Sale Id 1617868',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 17:34:10','',''),(2622915,'1','180','934',414,'Retail Sale Id 1617869',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 17:48:31','',''),(2622916,'1','180','934',414,'Retail Sale Id 1617870',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 18:23:30','',''),(2622917,'1','180','934',414,'Retail Sale Id 1617871',1198.48,0.00,0.00,2.11,107.61,'2022-02-23 18:43:51','',''),(2622918,'1','180','934',414,'Retail Sale Id 1617872',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 18:53:44','',''),(2622919,'1','180','934',414,'Retail Sale Id 1617873',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 19:22:29','',''),(2622920,'1','180','934',414,'Retail Sale Id 1617874',2272.00,0.00,0.00,4.00,204.00,'2022-02-23 19:23:12','',''),(2622921,'1','180','934',414,'Retail Sale Id 1617875',7100.00,0.00,0.00,12.50,637.50,'2022-02-24 10:10:28','',''),(2622922,'1','180','934',414,'Retail Sale Id 1617876',7100.00,0.00,0.00,12.50,637.50,'2022-02-24 10:11:00','',''),(2622923,'1','180','934',414,'Retail Sale Id 1617877',3408.00,0.00,0.00,6.00,306.00,'2022-02-24 10:11:33','',''),(2622924,'1','180','934',414,'Retail Sale Id 1617878',4998.40,0.00,0.00,8.80,448.80,'2022-02-24 10:12:11','',''),(2622925,'1','180','934',414,'Retail Sale Id 1617879',5680.00,0.00,0.00,10.00,510.00,'2022-02-24 11:22:37','',''),(2622926,'1','180','934',414,'Retail Sale Id 1617880',4544.00,0.00,0.00,8.00,408.00,'2022-02-24 12:07:28','',''),(2622927,'1','180','934',414,'Retail Sale Id 1617881',1999.36,0.00,0.00,3.52,179.52,'2022-02-24 12:13:08','',''),(2622928,'1','180','934',414,'Retail Sale Id 1617882',1999.36,0.00,0.00,3.52,179.52,'2022-02-24 12:23:05','',''),(2622929,'1','180','934',414,'Retail Sale Id 1617883',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 12:27:12','',''),(2622930,'1','180','934',414,'Retail Sale Id 1617884',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 12:53:14','',''),(2622931,'1','180','934',414,'Retail Sale Id 1617885',999.68,0.00,0.00,1.76,89.76,'2022-02-24 14:16:04','',''),(2622932,'1','180','934',414,'Retail Sale Id 1617886',4998.40,0.00,0.00,8.80,448.80,'2022-02-24 14:46:40','',''),(2622933,'1','180','934',414,'Retail Sale Id 1617887',3408.00,0.00,0.00,6.00,306.00,'2022-02-24 17:06:23','',''),(2622934,'1','180','934',414,'Retail Sale Id 1617888',2999.04,0.00,0.00,5.28,269.28,'2022-02-24 17:11:29','',''),(2622935,'1','180','934',414,'Retail Sale Id 1617889',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 17:12:47','',''),(2622936,'1','180','934',414,'Retail Sale Id 1617891',1999.36,0.00,0.00,3.52,179.52,'2022-02-24 17:25:52','',''),(2622937,'1','180','934',414,'Retail Sale Id 1617890',7100.00,0.00,0.00,12.50,637.50,'2022-02-24 17:46:23','',''),(2622938,'1','180','934',414,'Retail Sale Id 1617892',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 17:55:53','',''),(2622939,'1','180','934',414,'Retail Sale Id 1617893',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 18:06:04','',''),(2622940,'1','180','934',414,'Retail Sale Id 1617894',4998.40,0.00,0.00,8.80,448.80,'2022-02-24 18:14:44','',''),(2622941,'1','180','934',414,'Retail Sale Id 1617895',602.08,0.00,0.00,1.06,54.06,'2022-02-24 18:35:26','',''),(2622942,'1','180','934',414,'Retail Sale Id 1617896',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 19:17:57','',''),(2622943,'1','180','934',414,'Retail Sale Id 1617897',3498.88,0.00,0.00,6.16,314.16,'2022-02-25 11:47:30','',''),(2622944,'1','180','934',414,'Retail Sale Id 1617898',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 11:48:19','',''),(2622945,'1','180','934',414,'Retail Sale Id 1617899',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 11:49:06','',''),(2622946,'1','180','934',414,'Retail Sale Id 1617900',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 11:49:50','',''),(2622947,'1','180','934',414,'Retail Sale Id 1617901',32640.00,0.00,0.00,60.00,1620.00,'2022-02-25 11:50:52','',''),(2622948,'1','180','934',414,'Retail Sale Id 1617902',1198.48,0.00,0.00,2.11,107.61,'2022-02-25 13:26:59','',''),(2622949,'1','180','934',414,'Retail Sale Id 1617903',999.68,0.00,0.00,1.76,89.76,'2022-02-25 13:27:43','',''),(2622950,'1','180','934',414,'Retail Sale Id 1617904',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 17:52:36','',''),(2622951,'1','180','934',414,'Retail Sale Id 1617905',1999.36,0.00,0.00,3.52,179.52,'2022-02-25 19:03:18','',''),(2622952,'1','180','934',414,'Retail Sale Id 1617906',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 10:50:08','',''),(2622953,'1','180','934',414,'Retail Sale Id 1617907',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 10:50:46','',''),(2622954,'1','180','934',414,'Retail Sale Id 1617908',3197.84,0.00,0.00,5.63,287.13,'2022-02-26 10:51:34','',''),(2622955,'1','180','934',414,'Retail Sale Id 1617909',4544.00,0.00,0.00,8.00,408.00,'2022-02-26 11:39:49','',''),(2622956,'1','180','934',414,'Retail Sale Id 1617910',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 12:07:19','',''),(2622957,'1','180','934',414,'Retail Sale Id 1617911',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 12:57:01','',''),(2622958,'1','180','934',414,'Retail Sale Id 1617912',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 13:01:32','',''),(2622959,'1','180','934',414,'Retail Sale Id 1617913',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 13:31:54','',''),(2622960,'1','180','934',414,'Retail Sale Id 1617914',1397.28,0.00,0.00,2.46,125.46,'2022-02-26 13:33:06','',''),(2622961,'1','180','934',414,'Retail Sale Id 1617915',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 14:04:32','',''),(2622962,'1','180','934',414,'Retail Sale Id 1617916',1300.72,0.00,0.00,2.29,116.79,'2022-02-26 14:21:32','',''),(2622963,'1','180','934',414,'Retail Sale Id 1617917',999.68,0.00,0.00,1.76,89.76,'2022-02-26 14:23:43','',''),(2622964,'1','180','934',414,'Retail Sale Id 1617918',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 14:35:10','',''),(2622965,'1','180','934',414,'Retail Sale Id 1617919',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 14:44:51','',''),(2622966,'1','180','934',414,'Retail Sale Id 1617920',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 16:09:42','',''),(2622967,'1','180','934',414,'Retail Sale Id 1617921',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 16:23:24','',''),(2622968,'1','180','934',414,'Retail Sale Id 1617922',897.44,0.00,0.00,1.58,80.58,'2022-02-26 16:24:38','',''),(2622969,'1','180','934',414,'Retail Sale Id 1617923',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 16:52:18','',''),(2622970,'1','180','934',414,'Retail Sale Id 1617924',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 17:10:59','',''),(2622971,'1','180','934',414,'Retail Sale Id 1617925',54400.00,0.00,0.00,100.00,2700.00,'2022-02-26 17:12:27','',''),(2622972,'1','180','934',414,'Retail Sale Id 1617926',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 17:23:38','',''),(2622973,'1','180','934',414,'Retail Sale Id 1617927',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 17:30:40','',''),(2622974,'1','180','934',414,'Retail Sale Id 1617928',2999.04,0.00,0.00,5.28,269.28,'2022-02-26 17:58:43','',''),(2622975,'1','180','934',414,'Retail Sale Id 1617929',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 08:13:54','',''),(2622976,'1','180','934',414,'Retail Sale Id 1617930',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 08:55:54','',''),(2622977,'1','180','934',414,'Retail Sale Id 1617931',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 09:06:22','',''),(2622978,'1','180','934',414,'Retail Sale Id 1617932',1198.48,0.00,0.00,2.11,107.61,'2022-02-27 09:16:00','',''),(2622979,'1','180','934',414,'Retail Sale Id 1617933',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 09:44:47','',''),(2622980,'1','180','934',414,'Retail Sale Id 1617934',2272.00,0.00,0.00,4.00,204.00,'2022-02-27 09:50:02','',''),(2622981,'1','180','934',414,'Retail Sale Id 1617935',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 11:34:01','',''),(2622982,'1','180','934',414,'Retail Sale Id 1617936',1136.00,0.00,0.00,2.00,102.00,'2022-02-27 11:35:04','',''),(2622983,'1','180','934',414,'Retail Sale Id 1617937',2499.20,0.00,0.00,4.40,224.40,'2022-02-27 11:36:01','',''),(2622984,'1','180','934',414,'Retail Sale Id 1617938',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 12:17:50','',''),(2622985,'1','180','934',414,'Retail Sale Id 1617939',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 12:35:37','',''),(2622986,'1','180','934',414,'Retail Sale Id 1617940',999.68,0.00,0.00,1.76,89.76,'2022-02-27 12:44:31','',''),(2622987,'1','180','934',414,'Retail Sale Id 1617941',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 14:09:03','',''),(2622988,'1','180','934',414,'Retail Sale Id 1617942',1136.00,0.00,0.00,2.00,102.00,'2022-02-27 15:01:29','',''),(2622989,'1','180','934',414,'Retail Sale Id 1617943',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 15:02:54','',''),(2622990,'1','180','934',414,'Retail Sale Id 1617946',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 15:28:56','',''),(2622991,'1','180','934',414,'Retail Sale Id 1617947',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 15:41:07','',''),(2622992,'1','180','934',414,'Retail Sale Id 1617948',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 16:16:36','',''),(2622993,'1','180','934',414,'Retail Sale Id 1617949',1136.00,0.00,0.00,2.00,102.00,'2022-02-27 16:22:19','',''),(2622994,'1','180','934',414,'Retail Sale Id 1617950',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 17:49:11','',''),(2622995,'1','180','934',414,'Retail Sale Id 1617951',999.68,0.00,0.00,1.76,89.76,'2022-02-27 18:07:47','',''),(2622996,'1','180','934',414,'Retail Sale Id 1617952',1988.00,0.00,0.00,3.50,178.50,'2022-02-27 18:10:46','',''),(2622997,'1','180','934',414,'Retail Sale Id 1617953',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 18:25:37','',''),(2622998,'1','180','934',414,'Retail Sale Id 1617954',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 18:45:01','',''),(2622999,'1','180','934',414,'Retail Sale Id 1617955',58752.00,0.00,0.00,108.00,2916.00,'2022-02-27 19:58:22','',''),(2623000,'1','180','934',414,'Retail Sale Id 1617956',1101.92,0.00,0.00,1.94,98.94,'2022-02-28 10:49:00','',''),(2623001,'1','180','934',414,'Retail Sale Id 1617957',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 10:59:48','',''),(2623002,'1','180','934',414,'Retail Sale Id 1617958',999.68,0.00,0.00,1.76,89.76,'2022-02-28 11:47:55','',''),(2623003,'1','180','934',414,'Retail Sale Id 1617959',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 12:35:42','',''),(2623004,'1','180','934',414,'Retail Sale Id 1617960',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 12:45:28','',''),(2623005,'1','180','934',414,'Retail Sale Id 1617961',999.68,0.00,0.00,1.76,89.76,'2022-02-28 13:31:06','',''),(2623006,'1','180','934',414,'Retail Sale Id 1617962',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 14:20:50','',''),(2623007,'1','180','934',414,'Retail Sale Id 1617963',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 14:27:32','',''),(2623008,'1','180','934',414,'Retail Sale Id 1617964',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 15:04:14','',''),(2623009,'1','180','934',414,'Retail Sale Id 1617965',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 15:19:18','',''),(2623010,'1','180','934',414,'Retail Sale Id 1617966',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 15:41:33','',''),(2623011,'1','180','934',414,'Retail Sale Id 1617967',3976.00,0.00,0.00,7.00,357.00,'2022-02-28 16:33:33','',''),(2623012,'1','180','934',414,'Retail Sale Id 1617968',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 16:34:44','',''),(2623013,'1','180','934',414,'Retail Sale Id 1617969',1999.36,0.00,0.00,3.52,179.52,'2022-02-28 17:01:06','',''),(2623014,'1','180','934',414,'Retail Sale Id 1617970',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 17:31:05','',''),(2623015,'1','180','934',414,'Retail Sale Id 1617971',6248.00,0.00,0.00,11.00,561.00,'2022-02-28 17:38:43','',''),(2623016,'1','180','934',414,'Retail Sale Id 1617972',2272.00,0.00,0.00,4.00,204.00,'2022-02-28 17:39:44','',''),(2623017,'1','180','934',414,'Retail Sale Id 1617973',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 17:48:27','',''),(2623018,'1','180','934',414,'Retail Sale Id 1617974',4498.56,0.00,0.00,7.92,403.92,'2022-02-28 17:54:53','',''),(2623019,'1','180','934',414,'Retail Sale Id 1617975',4498.56,0.00,0.00,7.92,403.92,'2022-02-28 17:57:43','',''),(2623020,'1','180','934',414,'Retail Sale Id 1617976',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 18:04:45','',''),(2623021,'1','180','934',414,'Retail Sale Id 1617977',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 18:06:18','',''),(2623022,'1','180','934',414,'Retail Sale Id 1617978',999.68,0.00,0.00,1.76,89.76,'2022-02-28 18:46:15','',''),(2623023,'1','180','934',414,'Retail Sale Id 1617979',59840.00,0.00,0.00,110.00,2970.00,'2022-02-28 18:48:28','',''),(2623024,'1','180','934',414,'Return of Retail Sale Id 1617975',0.00,4498.56,7.92,0.00,-403.92,'2022-02-28 18:50:08','',''),(2623025,'1','180','934',414,'Return of Retail Sale Id 1617974',0.00,4498.56,7.92,0.00,-403.92,'2022-02-28 18:51:18','',''),(2623026,'1','180','934',414,'Retail Sale Id 1617980',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 09:31:22','',''),(2623027,'1','180','934',414,'Retail Sale Id 1617981',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 10:51:42','',''),(2623028,'1','180','934',414,'Retail Sale Id 1617982',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 11:51:15','',''),(2623029,'1','180','934',414,'Retail Sale Id 1617983',999.68,0.00,0.00,1.76,89.76,'2022-03-01 11:53:03','',''),(2623030,'1','180','934',414,'Retail Sale Id 1617984',2499.20,0.00,0.00,4.40,224.40,'2022-03-01 11:54:40','',''),(2623031,'1','180','934',414,'Retail Sale Id 1617985',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 12:36:32','',''),(2623032,'1','180','934',414,'Retail Sale Id 1617986',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 15:01:02','',''),(2623033,'1','180','934',414,'Retail Sale Id 1617987',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 15:13:59','',''),(2623034,'1','180','934',414,'Retail Sale Id 1617988',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 15:51:07','',''),(2623035,'1','180','934',414,'Retail Sale Id 1617989',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 16:13:03','',''),(2623036,'1','180','934',414,'Retail Sale Id 1617990',4544.00,0.00,0.00,8.00,408.00,'2022-03-01 17:20:06','',''),(2623037,'1','180','934',414,'Retail Sale Id 1617991',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 17:21:03','',''),(2623038,'1','180','934',414,'Retail Sale Id 1617992',2840.00,0.00,0.00,5.00,255.00,'2022-03-01 17:25:01','',''),(2623039,'1','180','934',414,'Retail Sale Id 1617993',2840.00,0.00,0.00,5.00,255.00,'2022-03-01 19:15:43','',''),(2623040,'1','180','934',414,'Retail Sale Id 1617994',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 09:23:02','',''),(2623041,'1','180','934',414,'Retail Sale Id 1617995',2999.04,0.00,0.00,5.28,269.28,'2022-03-02 09:24:27','',''),(2623042,'1','180','934',414,'Retail Sale Id 1617996',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 09:50:38','',''),(2623043,'1','180','934',414,'Retail Sale Id 1617997',5680.00,0.00,0.00,10.00,510.00,'2022-03-02 10:48:09','',''),(2623044,'1','180','934',414,'Retail Sale Id 1617998',1499.52,0.00,0.00,2.64,134.64,'2022-03-02 10:49:24','',''),(2623045,'1','180','934',414,'Retail Sale Id 1617999',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 13:07:41','',''),(2623046,'1','180','934',414,'Retail Sale Id 1618000',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 13:36:38','',''),(2623047,'1','180','934',414,'Retail Sale Id 1618001',1136.00,0.00,0.00,2.00,102.00,'2022-03-02 13:42:44','',''),(2623048,'1','180','934',414,'Retail Sale Id 1618002',999.68,0.00,0.00,1.76,89.76,'2022-03-02 15:28:21','',''),(2623049,'1','180','934',414,'Retail Sale Id 1618004',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 15:36:59','',''),(2623050,'1','180','934',414,'Retail Sale Id 1618005',1499.52,0.00,0.00,2.64,134.64,'2022-03-02 15:44:44','',''),(2623051,'1','180','934',414,'Retail Sale Id 1618006',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 16:08:11','',''),(2623052,'1','180','934',414,'Retail Sale Id 1618007',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 16:18:03','',''),(2623053,'1','180','934',414,'Retail Sale Id 1618008',1999.36,0.00,0.00,3.52,179.52,'2022-03-02 16:19:09','',''),(2623054,'1','180','934',414,'Retail Sale Id 1618009',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 16:46:38','',''),(2623055,'1','180','934',414,'Retail Sale Id 1618010',2272.00,0.00,0.00,4.00,204.00,'2022-03-03 09:41:20','',''),(2623056,'1','180','934',414,'Retail Sale Id 1618011',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 10:12:53','',''),(2623057,'1','180','934',414,'Retail Sale Id 1618012',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 11:16:17','',''),(2623058,'1','180','934',414,'Retail Sale Id 1618013',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 11:59:01','',''),(2623059,'1','180','934',414,'Retail Sale Id 1618014',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 11:59:46','',''),(2623060,'1','180','934',414,'Retail Sale Id 1618015',3498.88,0.00,0.00,6.16,314.16,'2022-03-03 12:00:40','',''),(2623061,'1','180','934',414,'Retail Sale Id 1618016',7384.00,0.00,0.00,13.00,663.00,'2022-03-03 12:01:34','',''),(2623062,'1','180','934',414,'Retail Sale Id 1618017',3976.00,0.00,0.00,7.00,357.00,'2022-03-03 14:09:33','',''),(2623063,'1','180','934',414,'Retail Sale Id 1618018',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 14:10:43','',''),(2623064,'1','180','934',414,'Retail Sale Id 1618019',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 14:11:52','',''),(2623065,'1','180','934',414,'Retail Sale Id 1618020',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 14:17:59','',''),(2623066,'1','180','934',414,'Retail Sale Id 1618021',2840.00,0.00,0.00,5.00,255.00,'2022-03-03 14:44:31','',''),(2623067,'1','180','934',414,'Retail Sale Id 1618022',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 15:56:48','',''),(2623068,'1','180','934',414,'Retail Sale Id 1618023',1300.72,0.00,0.00,2.29,116.79,'2022-03-03 15:58:10','',''),(2623069,'1','180','934',414,'Retail Sale Id 1618024',1499.52,0.00,0.00,2.64,134.64,'2022-03-03 16:00:00','',''),(2623070,'1','180','934',414,'Retail Sale Id 1618025',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 17:40:06','',''),(2623071,'1','180','934',414,'Retail Sale Id 1618026',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 18:31:57','',''),(2623072,'1','180','934',414,'Retail Sale Id 1618027',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 18:33:12','',''),(2623073,'1','180','934',414,'Retail Sale Id 1618028',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 18:41:47','',''),(2623074,'1','180','934',414,'Retail Sale Id 1618029',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 18:43:54','',''),(2623075,'1','180','934',414,'Retail Sale Id 1618030',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 18:46:22','',''),(2623076,'1','180','934',414,'Retail Sale Id 1618031',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 18:55:46','',''),(2623077,'1','180','934',414,'Retail Sale Id 1618032',5680.00,0.00,0.00,10.00,510.00,'2022-03-03 18:59:21','',''),(2623078,'1','180','934',414,'Retail Sale Id 1618033',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 19:16:13','',''),(2623079,'1','180','934',414,'Retail Sale Id 1618034',2499.20,0.00,0.00,4.40,224.40,'2022-03-04 13:25:10','',''),(2623080,'1','180','934',414,'Retail Sale Id 1618035',4998.40,0.00,0.00,8.80,448.80,'2022-03-04 13:26:13','',''),(2623081,'1','180','934',414,'Retail Sale Id 1618036',3408.00,0.00,0.00,6.00,306.00,'2022-03-04 13:27:26','',''),(2623082,'1','180','934',414,'Retail Sale Id 1618037',3408.00,0.00,0.00,6.00,306.00,'2022-03-04 13:28:27','',''),(2623083,'1','180','934',414,'Retail Sale Id 1618038',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 13:29:28','',''),(2623084,'1','180','934',414,'Retail Sale Id 1618039',499.84,0.00,0.00,0.88,44.88,'2022-03-04 16:25:33','',''),(2623085,'1','180','934',414,'Retail Sale Id 1618040',1136.00,0.00,0.00,2.00,102.00,'2022-03-04 16:49:44','',''),(2623086,'1','180','934',414,'Retail Sale Id 1618042',2999.04,0.00,0.00,5.28,269.28,'2022-03-04 16:51:08','',''),(2623087,'1','180','934',414,'Retail Sale Id 1618043',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 16:52:08','',''),(2623088,'1','180','934',414,'Retail Sale Id 1618044',2005.04,0.00,0.00,3.53,180.03,'2022-03-04 16:54:58','',''),(2623089,'1','180','934',414,'Retail Sale Id 1618045',2840.00,0.00,0.00,5.00,255.00,'2022-03-04 17:08:09','',''),(2623090,'1','180','934',414,'Retail Sale Id 1618046',27200.00,0.00,0.00,50.00,1350.00,'2022-03-04 17:20:57','',''),(2623091,'1','180','934',414,'Retail Sale Id 1618047',999.68,0.00,0.00,1.76,89.76,'2022-03-04 17:44:45','',''),(2623092,'1','180','934',414,'Retail Sale Id 1618048',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 18:15:54','',''),(2623093,'1','180','934',414,'Retail Sale Id 1618049',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 18:17:30','',''),(2623094,'1','180','934',414,'Retail Sale Id 1618050',6816.00,0.00,0.00,12.00,612.00,'2022-03-04 18:40:33','',''),(2623095,'1','180','934',414,'Retail Sale Id 1618051',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 08:22:42','',''),(2623096,'1','180','934',414,'Retail Sale Id 1618052',4998.40,0.00,0.00,8.80,448.80,'2022-03-05 08:51:25','',''),(2623097,'1','180','934',414,'Retail Sale Id 1618053',1999.36,0.00,0.00,3.52,179.52,'2022-03-05 08:53:36','',''),(2623098,'1','180','934',414,'Retail Sale Id 1618054',2272.00,0.00,0.00,4.00,204.00,'2022-03-05 10:01:36','',''),(2623099,'1','180','934',414,'Retail Sale Id 1618055',1420.00,0.00,0.00,2.50,127.50,'2022-03-05 10:02:51','',''),(2623100,'1','180','934',414,'Retail Sale Id 1618056',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 10:42:03','',''),(2623101,'1','180','934',414,'Retail Sale Id 1618057',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 11:53:45','',''),(2623102,'1','180','934',414,'Retail Sale Id 1618058',3998.72,0.00,0.00,7.04,359.04,'2022-03-05 11:55:10','',''),(2623103,'1','180','934',414,'Retail Sale Id 1618059',1499.52,0.00,0.00,2.64,134.64,'2022-03-05 12:23:08','',''),(2623104,'1','180','934',414,'Retail Sale Id 1618060',1136.00,0.00,0.00,2.00,102.00,'2022-03-05 13:14:27','',''),(2623105,'1','180','934',414,'Retail Sale Id 1618061',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 13:40:38','',''),(2623106,'1','180','934',414,'Retail Sale Id 1618062',1988.00,0.00,0.00,3.50,178.50,'2022-03-05 13:41:26','',''),(2623107,'1','180','934',414,'Retail Sale Id 1618063',5680.00,0.00,0.00,10.00,510.00,'2022-03-05 13:47:13','',''),(2623108,'1','180','934',414,'Retail Sale Id 1618064',2272.00,0.00,0.00,4.00,204.00,'2022-03-05 14:03:29','',''),(2623109,'1','180','934',414,'Retail Sale Id 1618065',5600.48,0.00,0.00,9.86,502.86,'2022-03-05 15:43:05','',''),(2623110,'1','180','934',414,'Retail Sale Id 1618066',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 15:51:17','',''),(2623111,'1','180','934',414,'Retail Sale Id 1618068',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 15:53:02','',''),(2623112,'1','180','934',414,'Retail Sale Id 1618069',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 17:36:34','',''),(2623113,'1','180','934',414,'Retail Sale Id 1618070',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 18:04:40','',''),(2623114,'1','180','934',414,'Retail Sale Id 1618071',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 18:24:17','',''),(2623115,'1','180','934',414,'Retail Sale Id 1618072',2272.00,0.00,0.00,4.00,204.00,'2022-03-05 18:31:52','',''),(2623116,'1','180','934',414,'Retail Sale Id 1618073',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 18:36:58','',''),(2623117,'1','180','934',414,'Retail Sale Id 1618074',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 18:48:03','',''),(2623118,'1','180','934',414,'Retail Sale Id 1618075',108800.00,0.00,0.00,200.00,5400.00,'2022-03-05 18:57:02','',''),(2623119,'1','180','934',414,'Retail Sale Id 1618076',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 18:57:51','',''),(2623120,'1','180','934',414,'Retail Sale Id 1618077',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 09:41:22','',''),(2623121,'1','180','934',414,'Retail Sale Id 1618078',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 10:40:40','',''),(2623122,'1','180','934',414,'Retail Sale Id 1618079',1704.00,0.00,0.00,3.00,153.00,'2022-03-06 10:56:23','',''),(2623123,'1','180','934',414,'Retail Sale Id 1618080',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 11:35:38','',''),(2623124,'1','180','934',414,'Retail Sale Id 1618081',2840.00,0.00,0.00,5.00,255.00,'2022-03-06 11:41:13','',''),(2623125,'1','180','934',414,'Retail Sale Id 1618082',4998.40,0.00,0.00,8.80,448.80,'2022-03-06 11:54:58','',''),(2623126,'1','180','934',414,'Retail Sale Id 1618083',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 12:47:16','',''),(2623127,'1','180','934',414,'Retail Sale Id 1618084',5401.68,0.00,0.00,9.51,485.01,'2022-03-06 16:30:06','',''),(2623128,'1','180','934',414,'Retail Sale Id 1618085',2999.04,0.00,0.00,5.28,269.28,'2022-03-06 16:31:28','',''),(2623129,'1','180','934',414,'Retail Sale Id 1618086',1704.00,0.00,0.00,3.00,153.00,'2022-03-06 16:32:44','',''),(2623130,'1','180','934',414,'Retail Sale Id 1618087',1704.00,0.00,0.00,3.00,153.00,'2022-03-06 16:34:09','',''),(2623131,'1','180','934',414,'Retail Sale Id 1618088',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 17:00:02','',''),(2623132,'1','180','934',414,'Retail Sale Id 1618089',2272.00,0.00,0.00,4.00,204.00,'2022-03-06 17:20:05','',''),(2623133,'1','180','934',414,'Retail Sale Id 1618090',1704.00,0.00,0.00,3.00,153.00,'2022-03-06 18:44:25','',''),(2623134,'1','180','934',414,'Retail Sale Id 1618091',4544.00,0.00,0.00,8.00,408.00,'2022-03-06 18:46:45','',''),(2623135,'1','180','934',414,'Retail Sale Id 1618092',7100.00,0.00,0.00,12.50,637.50,'2022-03-06 18:47:21','',''),(2623136,'1','180','934',414,'Retail Sale Id 1618093',1999.36,0.00,0.00,3.52,179.52,'2022-03-06 18:48:20','',''),(2623137,'1','180','934',414,'Retail Sale Id 1618094',1136.00,0.00,0.00,2.00,102.00,'2022-03-06 18:49:23','',''),(2623138,'1','180','934',414,'Retail Sale Id 1618095',1420.00,0.00,0.00,2.50,127.50,'2022-03-07 10:25:52','',''),(2623139,'1','180','934',414,'Retail Sale Id 1618096',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 11:31:14','',''),(2623140,'1','180','934',414,'Retail Sale Id 1618097',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 11:32:55','',''),(2623141,'1','180','934',414,'Retail Sale Id 1618098',698.64,0.00,0.00,1.23,62.73,'2022-03-07 11:34:11','',''),(2623142,'1','180','934',414,'Retail Sale Id 1618099',2840.00,0.00,0.00,5.00,255.00,'2022-03-07 12:07:16','',''),(2623143,'1','180','934',414,'Retail Sale Id 1618100',1999.36,0.00,0.00,3.52,179.52,'2022-03-07 12:54:39','',''),(2623144,'1','180','934',414,'Retail Sale Id 1618101',5680.00,0.00,0.00,10.00,510.00,'2022-03-07 13:30:29','',''),(2623145,'1','180','934',414,'Retail Sale Id 1618102',2272.00,0.00,0.00,4.00,204.00,'2022-03-07 13:41:24','',''),(2623146,'1','180','934',414,'Retail Sale Id 1618103',32640.00,0.00,0.00,60.00,1620.00,'2022-03-07 15:05:03','',''),(2623147,'1','180','934',414,'Retail Sale Id 1618104',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 15:26:16','',''),(2623148,'1','180','934',414,'Retail Sale Id 1618105',1704.00,0.00,0.00,3.00,153.00,'2022-03-07 15:36:47','',''),(2623149,'1','180','934',414,'Retail Sale Id 1618106',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 15:43:09','',''),(2623150,'1','180','934',414,'Retail Sale Id 1618107',5112.00,0.00,0.00,9.00,459.00,'2022-03-07 15:55:48','',''),(2623151,'1','180','934',414,'Retail Sale Id 1618108',2999.04,0.00,0.00,5.28,269.28,'2022-03-07 15:56:49','',''),(2623152,'1','180','934',414,'Retail Sale Id 1618109',1136.00,0.00,0.00,2.00,102.00,'2022-03-07 15:57:55','',''),(2623153,'1','180','934',414,'Retail Sale Id 1618110',2999.04,0.00,0.00,5.28,269.28,'2022-03-07 16:01:25','',''),(2623154,'1','180','934',414,'Retail Sale Id 1618111',2272.00,0.00,0.00,4.00,204.00,'2022-03-07 16:19:11','',''),(2623155,'1','180','934',414,'Retail Sale Id 1618112',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 16:24:35','',''),(2623156,'1','180','934',414,'Retail Sale Id 1618113',1704.00,0.00,0.00,3.00,153.00,'2022-03-07 17:17:15','',''),(2623157,'1','180','934',414,'Retail Sale Id 1618114',2999.04,0.00,0.00,5.28,269.28,'2022-03-07 17:35:49','',''),(2623158,'1','180','934',414,'Retail Sale Id 1618115',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 18:05:23','',''),(2623159,'1','180','934',414,'Retail Sale Id 1618116',1136.00,0.00,0.00,2.00,102.00,'2022-03-07 18:55:50','',''),(2623160,'1','180','934',414,'Retail Sale Id 1618117',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 09:23:26','',''),(2623161,'1','180','934',414,'Retail Sale Id 1618118',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 09:25:05','',''),(2623162,'1','180','934',414,'Retail Sale Id 1618120',698.64,0.00,0.00,1.23,62.73,'2022-03-08 09:30:20','',''),(2623163,'1','180','934',414,'Retail Sale Id 1618121',5680.00,0.00,0.00,10.00,510.00,'2022-03-08 09:50:52','',''),(2623164,'1','180','934',414,'Retail Sale Id 1618122',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 09:51:55','',''),(2623165,'1','180','934',414,'Retail Sale Id 1618123',999.68,0.00,0.00,1.76,89.76,'2022-03-08 10:56:12','',''),(2623166,'1','180','934',414,'Retail Sale Id 1618126',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 11:06:17','',''),(2623167,'1','180','934',414,'Retail Sale Id 1618127',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 11:08:05','',''),(2623168,'1','180','934',414,'Retail Sale Id 1618128',1704.00,0.00,0.00,3.00,153.00,'2022-03-08 11:09:54','',''),(2623169,'1','180','934',414,'Retail Sale Id 1618129',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 11:36:17','',''),(2623170,'1','180','934',414,'Retail Sale Id 1618130',1704.00,0.00,0.00,3.00,153.00,'2022-03-08 11:41:37','',''),(2623171,'1','180','934',414,'Retail Sale Id 1618132',1704.00,0.00,0.00,3.00,153.00,'2022-03-08 13:33:58','',''),(2623172,'1','180','934',414,'Retail Sale Id 1618133',1704.00,0.00,0.00,3.00,153.00,'2022-03-08 13:35:03','',''),(2623173,'1','180','934',414,'Retail Sale Id 1618134',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 13:38:47','',''),(2623174,'1','180','934',414,'Retail Sale Id 1618135',40800.00,0.00,0.00,75.00,2025.00,'2022-03-08 16:29:55','',''),(2623175,'1','180','934',414,'Retail Sale Id 1618136',1420.00,0.00,0.00,2.50,127.50,'2022-03-08 16:30:49','',''),(2623176,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,3121200.00,5100.00,0.00,0.00,'2022-03-17 15:19:23','',''),(2623177,'1','180',NULL,414,'Reception corrector for bridging 130291',0.00,0.00,0.00,5100.00,0.00,'2022-03-17 15:20:54','',''),(2623178,'1','180','934',414,'Received from bridging 130291',0.00,0.00,5100.00,0.00,0.00,'2022-03-17 15:20:54','',''),(2623179,'1','180','934',414,'Retail Sale Id 1618137',6120.00,0.00,0.00,9.00,612.00,'2022-03-17 15:22:54','',''),(2623180,'1','180','934',414,'Retail Sale Id 1618138',1502.80,0.00,0.00,2.21,150.28,'2022-03-17 17:21:25','',''),(2623181,'1','180','934',414,'Retail Sale Id 1618139',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 17:34:15','',''),(2623182,'1','180','934',414,'Retail Sale Id 1618140',1999.20,0.00,0.00,2.94,199.92,'2022-03-17 18:26:15','',''),(2623183,'1','180','934',414,'Retail Sale Id 1618141',1360.00,0.00,0.00,2.00,136.00,'2022-03-17 18:27:03','',''),(2623184,'1','180','934',414,'Retail Sale Id 1618142',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 18:52:09','',''),(2623185,'1','180','934',414,'Retail Sale Id 1618143',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 08:15:15','',''),(2623186,'1','180','934',414,'Retail Sale Id 1618144',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 08:16:25','',''),(2623187,'1','180','934',414,'Retail Sale Id 1618145',3801.20,0.00,0.00,5.59,380.12,'2022-03-18 08:23:35','',''),(2623188,'1','180','934',414,'Retail Sale Id 1618146',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 10:58:48','',''),(2623189,'1','180','934',414,'Retail Sale Id 1618147',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 10:59:56','',''),(2623190,'1','180','934',414,'Retail Sale Id 1618148',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 11:00:49','',''),(2623191,'1','180','934',414,'Retail Sale Id 1618149',3998.40,0.00,0.00,5.88,399.84,'2022-03-18 11:02:31','',''),(2623192,'1','180','934',414,'Retail Sale Id 1618150',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 11:20:50','',''),(2623193,'1','180','934',414,'Retail Sale Id 1618151',6800.00,0.00,0.00,10.00,680.00,'2022-03-18 13:46:42','',''),(2623194,'1','180','934',414,'Retail Sale Id 1618152',3502.00,0.00,0.00,5.15,350.20,'2022-03-18 15:27:31','',''),(2623195,'1','180','934',414,'Retail Sale Id 1618153',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 15:51:13','',''),(2623196,'1','180','934',414,'Retail Sale Id 1618154',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 16:20:49','',''),(2623197,'1','180','934',414,'Retail Sale Id 1618155',2040.00,0.00,0.00,3.00,204.00,'2022-03-18 18:30:03','',''),(2623198,'1','180','934',414,'Retail Sale Id 1618156',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 18:35:13','',''),(2623199,'1','180','934',414,'Retail Sale Id 1618157',4080.00,0.00,0.00,6.00,408.00,'2022-03-18 18:53:56','',''),(2623200,'1','180','934',414,'Retail Sale Id 1618158',8500.00,0.00,0.00,12.50,850.00,'2022-03-19 08:53:20','',''),(2623201,'1','180','934',414,'Retail Sale Id 1618159',2998.80,0.00,0.00,4.41,299.88,'2022-03-19 08:54:30','',''),(2623202,'1','180','934',414,'Retail Sale Id 1618160',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 08:55:39','',''),(2623203,'1','180','934',414,'Retail Sale Id 1618161',2998.80,0.00,0.00,4.41,299.88,'2022-03-19 10:06:31','',''),(2623204,'1','180','934',414,'Retail Sale Id 1618162',3400.00,0.00,0.00,5.00,340.00,'2022-03-19 11:56:04','',''),(2623205,'1','180','934',414,'Retail Sale Id 1618163',4998.00,0.00,0.00,7.35,499.80,'2022-03-19 11:57:26','',''),(2623206,'1','180','934',414,'Retail Sale Id 1618164',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 14:32:49','',''),(2623207,'1','180','934',414,'Retail Sale Id 1618165',1360.00,0.00,0.00,2.00,136.00,'2022-03-19 14:34:12','',''),(2623208,'1','180','934',414,'Retail Sale Id 1618166',2720.00,0.00,0.00,4.00,272.00,'2022-03-19 16:43:49','',''),(2623209,'1','180','934',414,'Retail Sale Id 1618167',2040.00,0.00,0.00,3.00,204.00,'2022-03-19 17:33:26','',''),(2623210,'1','180','934',414,'Retail Sale Id 1618168',8500.00,0.00,0.00,12.50,850.00,'2022-03-19 17:36:15','',''),(2623211,'1','180','934',414,'Retail Sale Id 1618169',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 17:37:22','',''),(2623212,'1','180','934',414,'Retail Sale Id 1618170',4080.00,0.00,0.00,6.00,408.00,'2022-03-19 17:56:23','',''),(2623213,'1','180','934',414,'Retail Sale Id 1618171',999.60,0.00,0.00,1.47,99.96,'2022-03-19 18:28:07','',''),(2623214,'1','180','934',414,'Retail Sale Id 1618172',1502.80,0.00,0.00,2.21,150.28,'2022-03-19 18:52:31','',''),(2623215,'1','180','934',414,'Retail Sale Id 1618173',700.40,0.00,0.00,1.03,70.04,'2022-03-19 19:18:31','',''),(2623216,'1','180','934',414,'Retail Sale Id 1618174',6120.00,0.00,0.00,9.00,612.00,'2022-03-20 07:53:04','',''),(2623217,'1','180','934',414,'Retail Sale Id 1618175',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 08:24:05','',''),(2623218,'1','180','934',414,'Retail Sale Id 1618176',2720.00,0.00,0.00,4.00,272.00,'2022-03-20 08:25:21','',''),(2623219,'1','180','934',414,'Retail Sale Id 1618177',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 08:27:05','',''),(2623220,'1','180','934',414,'Retail Sale Id 1618178',2998.80,0.00,0.00,4.41,299.88,'2022-03-20 09:09:36','',''),(2623221,'1','180','934',414,'Retail Sale Id 1618179',999.60,0.00,0.00,1.47,99.96,'2022-03-20 10:27:39','',''),(2623222,'1','180','934',414,'Retail Sale Id 1618180',5440.00,0.00,0.00,8.00,544.00,'2022-03-20 10:28:48','',''),(2623223,'1','180','934',414,'Retail Sale Id 1618181',2998.80,0.00,0.00,4.41,299.88,'2022-03-20 10:29:58','',''),(2623224,'1','180','934',414,'Retail Sale Id 1618182',1101.60,0.00,0.00,1.62,110.16,'2022-03-20 10:47:06','',''),(2623225,'1','180','934',414,'Retail Sale Id 1618183',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 11:03:05','',''),(2623226,'1','180','934',414,'Retail Sale Id 1618184',1360.00,0.00,0.00,2.00,136.00,'2022-03-20 11:04:17','',''),(2623227,'1','180','934',414,'Retail Sale Id 1618185',2380.00,0.00,0.00,3.50,238.00,'2022-03-20 14:00:47','',''),(2623228,'1','180','934',414,'Retail Sale Id 1618186',2040.00,0.00,0.00,3.00,204.00,'2022-03-20 14:48:15','',''),(2623229,'1','180','934',414,'Retail Sale Id 1618187',999.60,0.00,0.00,1.47,99.96,'2022-03-20 15:07:17','',''),(2623230,'1','180','934',414,'Retail Sale Id 1618188',1999.20,0.00,0.00,2.94,199.92,'2022-03-20 16:01:58','',''),(2623231,'1','180','934',414,'Retail Sale Id 1618189',3400.00,0.00,0.00,5.00,340.00,'2022-03-20 20:34:50','',''),(2623232,'1','180','934',414,'Retail Sale Id 1618190',1802.00,0.00,0.00,2.65,180.20,'2022-03-20 20:44:08','',''),(2623233,'1','180','934',414,'Retail Sale Id 1618191',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 10:03:53','',''),(2623234,'1','180','934',414,'Retail Sale Id 1618192',1999.20,0.00,0.00,2.94,199.92,'2022-03-21 10:04:35','',''),(2623235,'1','180','934',414,'Retail Sale Id 1618193',6120.00,0.00,0.00,9.00,612.00,'2022-03-21 13:31:01','',''),(2623236,'1','180','934',414,'Retail Sale Id 1618194',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 13:31:42','',''),(2623237,'1','180','934',414,'Retail Sale Id 1618195',1999.20,0.00,0.00,2.94,199.92,'2022-03-21 13:32:32','',''),(2623238,'1','180','934',414,'Retail Sale Id 1618196',680.00,0.00,0.00,1.00,68.00,'2022-03-21 14:29:43','',''),(2623239,'1','180','934',414,'Retail Sale Id 1618197',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 14:37:37','',''),(2623240,'1','180','934',414,'Retail Sale Id 1618198',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 14:38:40','',''),(2623241,'1','180','934',414,'Retail Sale Id 1618199',3502.00,0.00,0.00,5.15,350.20,'2022-03-21 14:43:14','',''),(2623242,'1','180','934',414,'Retail Sale Id 1618200',17000.00,0.00,0.00,25.00,1700.00,'2022-03-21 14:57:54','',''),(2623243,'1','180','934',414,'Retail Sale Id 1618201',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 14:58:51','',''),(2623244,'1','180','934',414,'Retail Sale Id 1618202',4501.60,0.00,0.00,6.62,450.16,'2022-03-21 18:25:50','',''),(2623245,'1','180','934',414,'Retail Sale Id 1618203',2502.40,0.00,0.00,3.68,250.24,'2022-03-21 18:26:47','',''),(2623246,'1','180','934',414,'Retail Sale Id 1618204',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 18:27:43','',''),(2623247,'1','180','934',414,'Retail Sale Id 1618205',3400.00,0.00,0.00,5.00,340.00,'2022-03-21 18:53:15','',''),(2623248,'1','180','934',414,'Retail Sale Id 1618206',4080.00,0.00,0.00,6.00,408.00,'2022-03-21 18:54:19','',''),(2623249,'1','180','934',414,'Retail Sale Id 1618207',2040.00,0.00,0.00,3.00,204.00,'2022-03-21 19:01:51','',''),(2623250,'1','180','934',414,'Retail Sale Id 1618208',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 12:02:22','',''),(2623251,'1','180','934',414,'Retail Sale Id 1618209',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 14:12:03','',''),(2623252,'1','180','934',414,'Retail Sale Id 1618210',3400.00,0.00,0.00,5.00,340.00,'2022-03-22 14:15:46','',''),(2623253,'1','180','934',414,'Retail Sale Id 1618211',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 15:12:02','',''),(2623254,'1','180','934',414,'Retail Sale Id 1618212',8840.00,0.00,0.00,13.00,884.00,'2022-03-22 15:52:21','',''),(2623255,'1','180','934',414,'Retail Sale Id 1618213',1999.20,0.00,0.00,2.94,199.92,'2022-03-22 16:58:31','',''),(2623256,'1','180','934',414,'Retail Sale Id 1618214',2720.00,0.00,0.00,4.00,272.00,'2022-03-22 17:19:17','',''),(2623257,'1','180','934',414,'Retail Sale Id 1618215',3998.40,0.00,0.00,5.88,399.84,'2022-03-22 17:24:54','',''),(2623258,'1','180','934',414,'Retail Sale Id 1618216',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 18:13:59','',''),(2623259,'1','180','934',414,'Retail Sale Id 1618217',4998.00,0.00,0.00,7.35,499.80,'2022-03-22 18:17:00','',''),(2623260,'1','180','934',414,'Retail Sale Id 1618218',1360.00,0.00,0.00,2.00,136.00,'2022-03-22 18:26:55','',''),(2623261,'1','180','934',414,'Retail Sale Id 1618219',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 18:35:48','',''),(2623262,'1','180','934',414,'Retail Sale Id 1618220',999.60,0.00,0.00,1.47,99.96,'2022-03-22 18:39:59','',''),(2623263,'1','180','934',414,'Retail Sale Id 1618221',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 18:48:26','',''),(2623264,'1','180','934',414,'Retail Sale Id 1618222',4080.00,0.00,0.00,6.00,408.00,'2022-03-22 18:58:09','',''),(2623265,'1','180','934',414,'Retail Sale Id 1618223',2040.00,0.00,0.00,3.00,204.00,'2022-03-22 18:58:52','',''),(2623266,'1','180','934',414,'Retail Sale Id 1618224',2720.00,0.00,0.00,4.00,272.00,'2022-03-23 08:22:16','',''),(2623267,'1','180','934',414,'Retail Sale Id 1618225',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 08:32:20','',''),(2623268,'1','180','934',414,'Retail Sale Id 1618226',4080.00,0.00,0.00,6.00,408.00,'2022-03-23 09:04:29','',''),(2623269,'1','180','934',414,'Retail Sale Id 1618227',2502.40,0.00,0.00,3.68,250.24,'2022-03-23 10:59:59','',''),(2623270,'1','180','934',414,'Retail Sale Id 1618228',3998.40,0.00,0.00,5.88,399.84,'2022-03-23 12:05:58','',''),(2623271,'1','180','934',414,'Retail Sale Id 1618229',999.60,0.00,0.00,1.47,99.96,'2022-03-23 12:46:18','',''),(2623272,'1','180','934',414,'Retail Sale Id 1618230',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 13:54:22','',''),(2623273,'1','180','934',414,'Retail Sale Id 1618231',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 14:44:57','',''),(2623274,'1','180','934',414,'Retail Sale Id 1618232',1360.00,0.00,0.00,2.00,136.00,'2022-03-23 15:21:29','',''),(2623275,'1','180','934',414,'Retail Sale Id 1618233',503.20,0.00,0.00,0.74,50.32,'2022-03-23 15:28:35','',''),(2623276,'1','180','934',414,'Retail Sale Id 1618234',8500.00,0.00,0.00,12.50,850.00,'2022-03-23 15:55:01','',''),(2623277,'1','180','934',414,'Retail Sale Id 1618235',3400.00,0.00,0.00,5.00,340.00,'2022-03-23 16:40:30','',''),(2623278,'1','180','934',414,'Retail Sale Id 1618236',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 16:41:39','',''),(2623279,'1','180','934',414,'Retail Sale Id 1618237',700.40,0.00,0.00,1.03,70.04,'2022-03-23 17:04:09','',''),(2623280,'1','180','934',414,'Retail Sale Id 1618238',4760.00,0.00,0.00,7.00,476.00,'2022-03-23 17:14:46','',''),(2623281,'1','180','934',414,'Retail Sale Id 1618239',2040.00,0.00,0.00,3.00,204.00,'2022-03-23 17:15:47','',''),(2623282,'1','180','934',414,'Retail Sale Id 1618240',1700.00,0.00,0.00,2.50,170.00,'2022-03-23 18:09:34','',''),(2623283,'1','180','934',414,'Retail Sale Id 1618241',1700.00,0.00,0.00,2.50,170.00,'2022-03-23 18:10:35','',''),(2623284,'1','180','934',414,'Retail Sale Id 1618242',128000.00,0.00,0.00,200.00,5600.00,'2022-03-23 18:43:15','',''),(2623285,'1','180','934',414,'Retail Sale Id 1618243',1502.80,0.00,0.00,2.21,150.28,'2022-03-23 18:54:36','',''),(2623286,'1','180','934',414,'Retail Sale Id 1618244',3998.40,0.00,0.00,5.88,399.84,'2022-03-24 09:31:23','',''),(2623287,'1','180','934',414,'Retail Sale Id 1618245',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 09:32:48','',''),(2623288,'1','180','934',414,'Retail Sale Id 1618246',4080.00,0.00,0.00,6.00,408.00,'2022-03-24 10:16:17','',''),(2623289,'1','180','934',414,'Retail Sale Id 1618247',1196.80,0.00,0.00,1.76,119.68,'2022-03-24 11:35:22','',''),(2623290,'1','180','934',414,'Retail Sale Id 1618248',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 11:36:40','',''),(2623291,'1','180','934',414,'Retail Sale Id 1618249',5440.00,0.00,0.00,8.00,544.00,'2022-03-24 11:37:49','',''),(2623292,'1','180','934',414,'Retail Sale Id 1618250',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 12:00:36','',''),(2623293,'1','180','934',414,'Retail Sale Id 1618251',999.60,0.00,0.00,1.47,99.96,'2022-03-24 13:00:06','',''),(2623294,'1','180','934',414,'Retail Sale Id 1618252',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 14:49:40','',''),(2623295,'1','180','934',414,'Retail Sale Id 1618253',38400.00,0.00,0.00,60.00,1680.00,'2022-03-24 14:57:36','',''),(2623296,'1','180','934',414,'Retail Sale Id 1618254',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 15:00:23','',''),(2623297,'1','180','934',414,'Retail Sale Id 1618255',1999.20,0.00,0.00,2.94,199.92,'2022-03-24 15:01:32','',''),(2623298,'1','180','934',414,'Retail Sale Id 1618256',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 15:02:45','',''),(2623299,'1','180','934',414,'Retail Sale Id 1618257',999.60,0.00,0.00,1.47,99.96,'2022-03-24 15:40:22','',''),(2623300,'1','180','934',414,'Retail Sale Id 1618258',2040.00,0.00,0.00,3.00,204.00,'2022-03-24 17:27:34','',''),(2623301,'1','180','934',414,'Retail Sale Id 1618259',999.60,0.00,0.00,1.47,99.96,'2022-03-24 17:48:28','',''),(2623302,'1','180','934',414,'Retail Sale Id 1618260',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 09:16:32','',''),(2623303,'1','180','934',414,'Retail Sale Id 1618261',1196.80,0.00,0.00,1.76,119.68,'2022-03-25 09:51:33','',''),(2623304,'1','180','934',414,'Retail Sale Id 1618262',8160.00,0.00,0.00,12.00,816.00,'2022-03-25 10:01:32','',''),(2623305,'1','180','934',414,'Retail Sale Id 1618263',2720.00,0.00,0.00,4.00,272.00,'2022-03-25 10:22:29','',''),(2623306,'1','180','934',414,'Retail Sale Id 1618264',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 10:44:33','',''),(2623307,'1','180','934',414,'Retail Sale Id 1618265',2720.00,0.00,0.00,4.00,272.00,'2022-03-25 11:09:33','',''),(2623308,'1','180','934',414,'Retail Sale Id 1618266',1999.20,0.00,0.00,2.94,199.92,'2022-03-25 11:28:09','',''),(2623309,'1','180','934',414,'Retail Sale Id 1618267',8500.00,0.00,0.00,12.50,850.00,'2022-03-25 14:37:53','',''),(2623310,'1','180','934',414,'Retail Sale Id 1618268',2998.80,0.00,0.00,4.41,299.88,'2022-03-25 14:39:54','',''),(2623311,'1','180','934',414,'Retail Sale Id 1618269',2040.00,0.00,0.00,3.00,204.00,'2022-03-25 17:44:51','',''),(2623312,'1','180','934',414,'Retail Sale Id 1618270',4760.00,0.00,0.00,7.00,476.00,'2022-03-25 17:46:30','',''),(2623313,'1','180','934',414,'Retail Sale Id 1618271',1360.00,0.00,0.00,2.00,136.00,'2022-03-25 17:48:13','',''),(2623314,'1','180','934',414,'Retail Sale Id 1618272',999.60,0.00,0.00,1.47,99.96,'2022-03-25 17:49:41','',''),(2623315,'1','180','934',414,'Retail Sale Id 1618273',1999.20,0.00,0.00,2.94,199.92,'2022-03-25 18:01:52','',''),(2623316,'1','180','934',414,'Retail Sale Id 1618274',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 18:22:38','',''),(2623317,'1','180','934',414,'Retail Sale Id 1618275',999.60,0.00,0.00,1.47,99.96,'2022-03-25 18:23:32','',''),(2623318,'1','180','934',414,'Retail Sale Id 1618276',4080.00,0.00,0.00,6.00,408.00,'2022-03-25 18:34:51','',''),(2623319,'1','180','934',414,'Retail Sale Id 1618277',1196.80,0.00,0.00,1.76,119.68,'2022-03-25 18:35:34','',''),(2623320,'1','180','934',414,'Retail Sale Id 1618278',8840.00,0.00,0.00,13.00,884.00,'2022-03-26 09:27:08','',''),(2623321,'1','180','934',414,'Retail Sale Id 1618279',7480.00,0.00,0.00,11.00,748.00,'2022-03-26 09:52:45','',''),(2623322,'1','180','934',414,'Retail Sale Id 1618280',4080.00,0.00,0.00,6.00,408.00,'2022-03-26 10:13:04','',''),(2623323,'1','180','934',414,'Retail Sale Id 1618281',4501.60,0.00,0.00,6.62,450.16,'2022-03-26 10:34:51','',''),(2623324,'1','180','934',414,'Retail Sale Id 1618282',680.00,0.00,0.00,1.00,68.00,'2022-03-26 11:09:53','',''),(2623325,'1','180','934',414,'Retail Sale Id 1618283',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 11:46:08','',''),(2623326,'1','180','934',414,'Retail Sale Id 1618284',3998.40,0.00,0.00,5.88,399.84,'2022-03-26 12:45:41','',''),(2623327,'1','180','934',414,'Retail Sale Id 1618285',680.00,0.00,0.00,1.00,68.00,'2022-03-26 12:52:40','',''),(2623328,'1','180','934',414,'Retail Sale Id 1618286',2502.40,0.00,0.00,3.68,250.24,'2022-03-26 14:52:42','',''),(2623329,'1','180','934',414,'Retail Sale Id 1618287',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 14:55:30','',''),(2623330,'1','180','934',414,'Retail Sale Id 1618288',2040.00,0.00,0.00,3.00,204.00,'2022-03-26 14:56:22','',''),(2623331,'1','180','934',414,'Retail Sale Id 1618289',4080.00,0.00,0.00,6.00,408.00,'2022-03-26 15:00:58','',''),(2623332,'1','180','934',414,'Retail Sale Id 1618290',999.60,0.00,0.00,1.47,99.96,'2022-03-26 15:06:47','',''),(2623333,'1','180','934',414,'Retail Sale Id 1618291',4501.60,0.00,0.00,6.62,450.16,'2022-03-26 18:44:19','',''),(2623334,'1','180','934',414,'Retail Sale Id 1618292',5997.60,0.00,0.00,8.82,599.76,'2022-03-27 08:24:47','',''),(2623335,'1','180','934',414,'Retail Sale Id 1618293',999.60,0.00,0.00,1.47,99.96,'2022-03-27 08:25:45','',''),(2623336,'1','180','934',414,'Retail Sale Id 1618295',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 12:48:48','',''),(2623337,'1','180','934',414,'Retail Sale Id 1618296',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 12:49:31','',''),(2623338,'1','180','934',414,'Retail Sale Id 1618297',2998.80,0.00,0.00,4.41,299.88,'2022-03-27 12:50:18','',''),(2623339,'1','180','934',414,'Retail Sale Id 1618298',1802.00,0.00,0.00,2.65,180.20,'2022-03-27 12:51:07','',''),(2623340,'1','180','934',414,'Retail Sale Id 1618299',6800.00,0.00,0.00,10.00,680.00,'2022-03-27 13:44:50','',''),(2623341,'1','180','934',414,'Retail Sale Id 1618300',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 13:45:35','',''),(2623342,'1','180','934',414,'Retail Sale Id 1618301',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 14:48:47','',''),(2623343,'1','180','934',414,'Retail Sale Id 1618302',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 15:14:58','',''),(2623344,'1','180','934',414,'Retail Sale Id 1618303',1360.00,0.00,0.00,2.00,136.00,'2022-03-27 15:22:19','',''),(2623345,'1','180','934',414,'Retail Sale Id 1618304',3400.00,0.00,0.00,5.00,340.00,'2022-03-27 15:45:42','',''),(2623346,'1','180','934',414,'Retail Sale Id 1618305',4998.00,0.00,0.00,7.35,499.80,'2022-03-27 17:45:33','',''),(2623347,'1','180','934',414,'Retail Sale Id 1618306',2040.00,0.00,0.00,3.00,204.00,'2022-03-27 18:23:40','',''),(2623348,'1','180','934',414,'Retail Sale Id 1618307',4080.00,0.00,0.00,6.00,408.00,'2022-03-27 19:03:02','',''),(2623349,'1','180','934',414,'Retail Sale Id 1618308',999.60,0.00,0.00,1.47,99.96,'2022-03-27 19:04:16','',''),(2623350,'1','180','934',414,'Retail Sale Id 1618309',999.60,0.00,0.00,1.47,99.96,'2022-03-27 19:28:30','',''),(2623351,'1','180','934',414,'Retail Sale Id 1618310',1802.00,0.00,0.00,2.65,180.20,'2022-03-28 09:31:06','',''),(2623352,'1','180','934',414,'Retail Sale Id 1618311',2380.00,0.00,0.00,3.50,238.00,'2022-03-28 10:05:55','',''),(2623353,'1','180','934',414,'Retail Sale Id 1618312',1802.00,0.00,0.00,2.65,180.20,'2022-03-28 10:06:50','',''),(2623354,'1','180','934',414,'Retail Sale Id 1618313',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 13:09:55','',''),(2623355,'1','180','934',414,'Retail Sale Id 1618314',3400.00,0.00,0.00,5.00,340.00,'2022-03-28 13:51:20','',''),(2623356,'1','180','934',414,'Retail Sale Id 1618315',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 13:52:05','',''),(2623357,'1','180','934',414,'Retail Sale Id 1618316',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 15:01:03','',''),(2623358,'1','180','934',414,'Retail Sale Id 1618317',1360.00,0.00,0.00,2.00,136.00,'2022-03-28 15:40:24','',''),(2623359,'1','180','934',414,'Retail Sale Id 1618318',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 15:41:49','',''),(2623360,'1','180','934',414,'Retail Sale Id 1618319',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 15:51:26','',''),(2623361,'1','180','934',414,'Retail Sale Id 1618320',680.00,0.00,0.00,1.00,68.00,'2022-03-28 16:16:31','',''),(2623362,'1','180','934',414,'Retail Sale Id 1618321',999.60,0.00,0.00,1.47,99.96,'2022-03-28 16:27:16','',''),(2623363,'1','180','934',414,'Retail Sale Id 1618322',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 16:40:09','',''),(2623364,'1','180','934',414,'Retail Sale Id 1618323',2040.00,0.00,0.00,3.00,204.00,'2022-03-28 16:41:39','',''),(2623365,'1','180','934',414,'Retail Sale Id 1618324',999.60,0.00,0.00,1.47,99.96,'2022-03-28 17:39:22','',''),(2623366,'1','180','934',414,'Retail Sale Id 1618325',700.40,0.00,0.00,1.03,70.04,'2022-03-28 17:44:55','',''),(2623367,'1','180','934',414,'Retail Sale Id 1618326',8500.00,0.00,0.00,12.50,850.00,'2022-03-28 18:14:25','',''),(2623368,'1','180','934',414,'Retail Sale Id 1618327',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 18:40:44','',''),(2623369,'1','180','934',414,'Retail Sale Id 1618328',4080.00,0.00,0.00,6.00,408.00,'2022-03-28 18:53:53','',''),(2623370,'1','180','934',414,'Retail Sale Id 1618329',999.60,0.00,0.00,1.47,99.96,'2022-03-28 18:59:21','',''),(2623371,'1','180','934',414,'Retail Sale Id 1618330',6800.00,0.00,0.00,10.00,680.00,'2022-03-29 08:19:25','',''),(2623372,'1','180','934',414,'Retail Sale Id 1618331',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 08:20:19','',''),(2623373,'1','180','934',414,'Retail Sale Id 1618332',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 08:21:18','',''),(2623374,'1','180','934',414,'Retail Sale Id 1618333',8500.00,0.00,0.00,12.50,850.00,'2022-03-29 09:04:17','',''),(2623375,'1','180','934',414,'Retail Sale Id 1618334',4998.00,0.00,0.00,7.35,499.80,'2022-03-29 09:05:39','',''),(2623376,'1','180','934',414,'Retail Sale Id 1618335',897.60,0.00,0.00,1.32,89.76,'2022-03-29 10:17:41','',''),(2623377,'1','180','934',414,'Retail Sale Id 1618336',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 11:02:25','',''),(2623378,'1','180','934',414,'Retail Sale Id 1618337',1999.20,0.00,0.00,2.94,199.92,'2022-03-29 11:44:31','',''),(2623379,'1','180','934',414,'Retail Sale Id 1618338',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 11:46:10','',''),(2623380,'1','180','934',414,'Retail Sale Id 1618339',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 12:10:45','',''),(2623381,'1','180','934',414,'Retail Sale Id 1618340',2720.00,0.00,0.00,4.00,272.00,'2022-03-29 12:12:36','',''),(2623382,'1','180','934',414,'Retail Sale Id 1618341',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 12:33:45','',''),(2623383,'1','180','934',414,'Retail Sale Id 1618342',32100.00,0.00,0.00,50.00,1500.00,'2022-03-29 13:15:38','',''),(2623384,'1','180','934',414,'Retail Sale Id 1618343',3400.00,0.00,0.00,5.00,340.00,'2022-03-29 14:40:16','',''),(2623385,'1','180','934',414,'Retail Sale Id 1618344',680.00,0.00,0.00,1.00,68.00,'2022-03-29 14:41:50','',''),(2623386,'1','180','934',414,'Retail Sale Id 1618345',38520.00,0.00,0.00,60.00,1800.00,'2022-03-29 15:10:06','',''),(2623387,'1','180','934',414,'Retail Sale Id 1618346',5997.60,0.00,0.00,8.82,599.76,'2022-03-29 15:57:44','',''),(2623388,'1','180','934',414,'Retail Sale Id 1618347',4080.00,0.00,0.00,6.00,408.00,'2022-03-29 16:37:42','',''),(2623389,'1','180','934',414,'Retail Sale Id 1618348',2502.40,0.00,0.00,3.68,250.24,'2022-03-29 16:44:32','',''),(2623390,'1','180','934',414,'Retail Sale Id 1618349',2679.20,0.00,0.00,3.94,267.92,'2022-03-29 16:47:09','',''),(2623391,'1','180','934',414,'Retail Sale Id 1618350',2040.00,0.00,0.00,3.00,204.00,'2022-03-29 18:10:07','',''),(2623392,'1','180','934',414,'Retail Sale Id 1618351',2720.00,0.00,0.00,4.00,272.00,'2022-03-30 10:08:14','',''),(2623393,'1','180','934',414,'Retail Sale Id 1618353',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 10:08:59','',''),(2623394,'1','180','934',414,'Retail Sale Id 1618354',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 10:09:42','',''),(2623395,'1','180','934',414,'Retail Sale Id 1618355',1502.80,0.00,0.00,2.21,150.28,'2022-03-30 10:10:37','',''),(2623396,'1','180','934',414,'Retail Sale Id 1618356',1598.00,0.00,0.00,2.35,159.80,'2022-03-30 10:12:17','',''),(2623397,'1','180','934',414,'Retail Sale Id 1618357',2998.80,0.00,0.00,4.41,299.88,'2022-03-30 10:13:48','',''),(2623398,'1','180','934',414,'Retail Sale Id 1618358',3998.40,0.00,0.00,5.88,399.84,'2022-03-30 10:14:43','',''),(2623399,'1','180','934',414,'Retail Sale Id 1618360',700.40,0.00,0.00,1.03,70.04,'2022-03-30 10:57:36','',''),(2623400,'1','180','934',414,'Retail Sale Id 1618361',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 11:04:01','',''),(2623401,'1','180','934',414,'Retail Sale Id 1618362',1999.20,0.00,0.00,2.94,199.92,'2022-03-30 11:05:08','',''),(2623402,'1','180','934',414,'Retail Sale Id 1618363',5440.00,0.00,0.00,8.00,544.00,'2022-03-30 11:28:08','',''),(2623403,'1','180','934',414,'Retail Sale Id 1618364',38520.00,0.00,0.00,60.00,1800.00,'2022-03-30 11:29:50','',''),(2623404,'1','180','934',414,'Retail Sale Id 1618365',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 11:31:08','',''),(2623405,'1','180','934',414,'Retail Sale Id 1618366',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 11:33:32','',''),(2623406,'1','180','934',414,'Retail Sale Id 1618367',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 16:17:52','',''),(2623407,'1','180','934',414,'Retail Sale Id 1618368',3998.40,0.00,0.00,5.88,399.84,'2022-03-30 16:21:20','',''),(2623408,'1','180','934',414,'Retail Sale Id 1618369',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:23:19','',''),(2623409,'1','180','934',414,'Retail Sale Id 1618370',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 16:50:23','',''),(2623410,'1','180','934',414,'Retail Sale Id 1618371',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 16:51:19','',''),(2623411,'1','180','934',414,'Retail Sale Id 1618372',2502.40,0.00,0.00,3.68,250.24,'2022-03-30 16:52:16','',''),(2623412,'1','180','934',414,'Retail Sale Id 1618373',1700.00,0.00,0.00,2.50,170.00,'2022-03-30 16:53:05','',''),(2623413,'1','180','934',414,'Retail Sale Id 1618374',64200.00,0.00,0.00,100.00,3000.00,'2022-03-30 16:54:20','',''),(2623414,'1','180','934',414,'Retail Sale Id 1618375',680.00,0.00,0.00,1.00,68.00,'2022-03-30 16:54:54','',''),(2623415,'1','180','934',414,'Retail Sale Id 1618376',999.60,0.00,0.00,1.47,99.96,'2022-03-30 16:55:45','',''),(2623416,'1','180','934',414,'Retail Sale Id 1618377',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 18:18:07','',''),(2623417,'1','180','934',414,'Retail Sale Id 1618378',1360.00,0.00,0.00,2.00,136.00,'2022-03-30 18:19:04','',''),(2623418,'1','180','934',414,'Retail Sale Id 1618379',2040.00,0.00,0.00,3.00,204.00,'2022-03-30 18:20:35','',''),(2623419,'1','180','934',414,'Retail Sale Id 1618380',11220.00,0.00,0.00,16.50,1122.00,'2022-03-30 18:31:52','',''),(2623420,'1','180','934',414,'Retail Sale Id 1618381',4080.00,0.00,0.00,6.00,408.00,'2022-03-30 18:43:37','',''),(2623421,'1','180','934',414,'Retail Sale Id 1618382',3400.00,0.00,0.00,5.00,340.00,'2022-03-30 19:25:47','',''),(2623422,'1','180','934',414,'Retail Sale Id 1618383',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 09:37:30','',''),(2623423,'1','180','934',414,'Retail Sale Id 1618384',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 09:42:57','',''),(2623424,'1','180','934',414,'Retail Sale Id 1618385',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 09:43:53','',''),(2623425,'1','180','934',414,'Retail Sale Id 1618386',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 09:44:35','',''),(2623426,'1','180','934',414,'Retail Sale Id 1618387',1196.80,0.00,0.00,1.76,119.68,'2022-03-31 09:45:29','',''),(2623427,'1','180','934',414,'Retail Sale Id 1618388',5440.00,0.00,0.00,8.00,544.00,'2022-03-31 12:19:14','',''),(2623428,'1','180','934',414,'Retail Sale Id 1618389',6997.20,0.00,0.00,10.29,699.72,'2022-03-31 12:20:14','',''),(2623429,'1','180','934',414,'Retail Sale Id 1618390',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 12:21:07','',''),(2623430,'1','180','934',414,'Retail Sale Id 1618391',3400.00,0.00,0.00,5.00,340.00,'2022-03-31 12:22:00','',''),(2623431,'1','180','934',414,'Retail Sale Id 1618392',8160.00,0.00,0.00,12.00,816.00,'2022-03-31 12:22:58','',''),(2623432,'1','180','934',414,'Retail Sale Id 1618393',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 12:26:42','',''),(2623433,'1','180','934',414,'Retail Sale Id 1618394',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 12:27:33','',''),(2623434,'1','180','934',414,'Retail Sale Id 1618395',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 12:59:05','',''),(2623435,'1','180','934',414,'Retail Sale Id 1618396',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 12:59:57','',''),(2623436,'1','180','934',414,'Retail Sale Id 1618397',10540.00,0.00,0.00,15.50,1054.00,'2022-03-31 13:14:46','',''),(2623437,'1','180','934',414,'Retail Sale Id 1618398',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 13:31:48','',''),(2623438,'1','180','934',414,'Retail Sale Id 1618399',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 13:32:41','',''),(2623439,'1','180','934',414,'Retail Sale Id 1618400',8500.00,0.00,0.00,12.50,850.00,'2022-03-31 13:46:08','',''),(2623440,'1','180','934',414,'Retail Sale Id 1618401',2720.00,0.00,0.00,4.00,272.00,'2022-03-31 16:32:19','',''),(2623441,'1','180','934',414,'Retail Sale Id 1618402',2998.80,0.00,0.00,4.41,299.88,'2022-03-31 16:38:31','',''),(2623442,'1','180','934',414,'Retail Sale Id 1618403',2040.00,0.00,0.00,3.00,204.00,'2022-03-31 17:09:45','',''),(2623443,'1','180','934',414,'Retail Sale Id 1618404',4760.00,0.00,0.00,7.00,476.00,'2022-03-31 17:10:32','',''),(2623444,'1','180','934',414,'Retail Sale Id 1618405',1999.20,0.00,0.00,2.94,199.92,'2022-03-31 17:11:15','',''),(2623445,'1','180','934',414,'Retail Sale Id 1618406',9520.00,0.00,0.00,14.00,952.00,'2022-03-31 18:30:38','',''),(2623446,'1','180','934',414,'Retail Sale Id 1618407',8160.00,0.00,0.00,12.00,816.00,'2022-03-31 18:31:21','',''),(2623447,'1','180','934',414,'Retail Sale Id 1618408',4080.00,0.00,0.00,6.00,408.00,'2022-03-31 20:32:59','',''),(2623448,'1','180','934',414,'Retail Sale Id 1618409',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 09:00:36','',''),(2623449,'1','180','934',414,'Retail Sale Id 1618410',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 09:23:42','',''),(2623450,'1','180','934',414,'Retail Sale Id 1618411',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 09:25:13','',''),(2623451,'1','180','934',414,'Retail Sale Id 1618412',5850.00,0.00,0.00,9.00,342.00,'2022-04-01 10:14:50','',''),(2623452,'1','180','934',414,'Retail Sale Id 1618413',9002.50,0.00,0.00,13.85,526.30,'2022-04-01 10:15:58','',''),(2623453,'1','180','934',414,'Retail Sale Id 1618414',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 10:16:46','',''),(2623454,'1','180','934',414,'Retail Sale Id 1618415',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:17:34','',''),(2623455,'1','180','934',414,'Retail Sale Id 1618416',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 10:48:56','',''),(2623456,'1','180','934',414,'Retail Sale Id 1618417',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 10:50:43','',''),(2623457,'1','180','934',414,'Retail Sale Id 1618418',5525.00,0.00,0.00,8.50,323.00,'2022-04-01 10:51:38','',''),(2623458,'1','180','934',414,'Retail Sale Id 1618419',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 10:52:30','',''),(2623459,'1','180','934',414,'Retail Sale Id 1618420',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 10:53:13','',''),(2623460,'1','180','934',414,'Retail Sale Id 1618421',3497.00,0.00,0.00,5.38,204.44,'2022-04-01 10:54:05','',''),(2623461,'1','180','934',414,'Retail Sale Id 1618422',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 12:04:56','',''),(2623462,'1','180','934',414,'Retail Sale Id 1618423',3997.50,0.00,0.00,6.15,233.70,'2022-04-01 12:05:53','',''),(2623463,'1','180','934',414,'Retail Sale Id 1618424',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 12:46:01','',''),(2623464,'1','180','934',414,'Retail Sale Id 1618425',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 12:46:41','',''),(2623465,'1','180','934',414,'Retail Sale Id 1618426',31000.00,0.00,0.00,50.00,400.00,'2022-04-01 12:47:29','',''),(2623466,'1','180','934',414,'Retail Sale Id 1618427',3250.00,0.00,0.00,5.00,190.00,'2022-04-01 12:50:07','',''),(2623467,'1','180','934',414,'Retail Sale Id 1618428',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 12:59:30','',''),(2623468,'1','180','934',414,'Retail Sale Id 1618429',3900.00,0.00,0.00,6.00,228.00,'2022-04-01 13:03:13','',''),(2623469,'1','180','934',414,'Retail Sale Id 1618430',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 13:17:40','',''),(2623470,'1','180','934',414,'Retail Sale Id 1618431',3003.00,0.00,0.00,4.62,175.56,'2022-04-01 13:19:29','',''),(2623471,'1','180','934',414,'Retail Sale Id 1618432',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 15:14:17','',''),(2623472,'1','180','934',414,'Retail Sale Id 1618433',2925.00,0.00,0.00,4.50,171.00,'2022-04-01 15:15:09','',''),(2623473,'1','180','934',414,'Retail Sale Id 1618434',5850.00,0.00,0.00,9.00,342.00,'2022-04-01 16:47:25','',''),(2623474,'1','180','934',414,'Retail Sale Id 1618435',1950.00,0.00,0.00,3.00,114.00,'2022-04-01 16:54:17','',''),(2623475,'1','180','934',414,'Retail Sale Id 1618436',3497.00,0.00,0.00,5.38,204.44,'2022-04-01 20:09:43','',''),(2623476,'1','180','934',414,'Retail Sale Id 1618437',8125.00,0.00,0.00,12.50,475.00,'2022-04-01 20:10:40','',''),(2623477,'1','180','934',414,'Retail Sale Id 1618438',15600.00,0.00,0.00,24.00,912.00,'2022-04-01 20:12:01','',''),(2623478,'1','180','934',414,'Retail Sale Id 1618439',7150.00,0.00,0.00,11.00,418.00,'2022-04-01 20:13:03','',''),(2623479,'1','180','934',414,'Retail Sale Id 1618440',1501.50,0.00,0.00,2.31,87.78,'2022-04-01 20:13:56','',''),(2623480,'1','180','934',414,'Retail Sale Id 1618441',7800.00,0.00,0.00,12.00,456.00,'2022-04-01 20:14:40','',''),(2623481,'1','180','934',414,'Retail Sale Id 1618442',111600.00,0.00,0.00,180.00,1440.00,'2022-04-01 21:05:45','',''),(2623482,'1','180','934',414,'Retail Sale Id 1618443',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 10:28:56','',''),(2623483,'1','180','934',414,'Retail Sale Id 1618444',62000.00,0.00,0.00,100.00,800.00,'2022-04-02 11:04:55','',''),(2623484,'1','180','934',414,'Retail Sale Id 1618445',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 11:20:13','',''),(2623485,'1','180','934',414,'Retail Sale Id 1618446',3497.00,0.00,0.00,5.38,204.44,'2022-04-02 11:25:19','',''),(2623486,'1','180','934',414,'Retail Sale Id 1618447',3250.00,0.00,0.00,5.00,190.00,'2022-04-02 11:44:02','',''),(2623487,'1','180','934',414,'Retail Sale Id 1618448',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 11:45:08','',''),(2623488,'1','180','934',414,'Retail Sale Id 1618449',4550.00,0.00,0.00,7.00,266.00,'2022-04-02 12:01:10','',''),(2623489,'1','180','934',414,'Retail Sale Id 1618450',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 12:02:53','',''),(2623490,'1','180','934',414,'Retail Sale Id 1618451',2600.00,0.00,0.00,4.00,152.00,'2022-04-02 12:03:41','',''),(2623491,'1','180','934',414,'Retail Sale Id 1618452',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 12:12:43','',''),(2623492,'1','180','934',414,'Retail Sale Id 1618453',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 13:13:07','',''),(2623493,'1','180','934',414,'Retail Sale Id 1618454',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 13:14:02','',''),(2623494,'1','180','934',414,'Retail Sale Id 1618455',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 13:15:05','',''),(2623495,'1','180','934',414,'Retail Sale Id 1618456',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 13:16:03','',''),(2623496,'1','180','934',414,'Retail Sale Id 1618457',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 13:31:03','',''),(2623497,'1','180','934',414,'Retail Sale Id 1618458',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 13:31:56','',''),(2623498,'1','180','934',414,'Retail Sale Id 1618459',124000.00,0.00,0.00,200.00,1600.00,'2022-04-02 13:33:12','',''),(2623499,'1','180','934',414,'Retail Sale Id 1618460',8125.00,0.00,0.00,12.50,475.00,'2022-04-02 13:43:32','',''),(2623500,'1','180','934',414,'Retail Sale Id 1618461',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:06:07','',''),(2623501,'1','180','934',414,'Retail Sale Id 1618462',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:10:57','',''),(2623502,'1','180','934',414,'Retail Sale Id 1618463',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 14:20:55','',''),(2623503,'1','180','934',414,'Retail Sale Id 1618464',6500.00,0.00,0.00,10.00,380.00,'2022-04-02 14:52:04','',''),(2623504,'1','180','934',414,'Retail Sale Id 1618465',1950.00,0.00,0.00,3.00,114.00,'2022-04-02 14:53:36','',''),(2623505,'1','180','934',414,'Retail Sale Id 1618466',16250.00,0.00,0.00,25.00,950.00,'2022-04-02 16:34:56','',''),(2623506,'1','180','934',414,'Retail Sale Id 1618467',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 16:35:49','',''),(2623507,'1','180','934',414,'Retail Sale Id 1618468',799.50,0.00,0.00,1.23,46.74,'2022-04-02 16:36:47','',''),(2623508,'1','180','934',414,'Retail Sale Id 1618469',7000.50,0.00,0.00,10.77,409.26,'2022-04-02 17:39:05','',''),(2623509,'1','180','934',414,'Retail Sale Id 1618470',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 17:39:48','',''),(2623510,'1','180','934',414,'Retail Sale Id 1618471',5850.00,0.00,0.00,9.00,342.00,'2022-04-02 17:41:55','',''),(2623511,'1','180','934',414,'Retail Sale Id 1618472',5200.00,0.00,0.00,8.00,304.00,'2022-04-02 17:42:51','',''),(2623512,'1','180','934',414,'Retail Sale Id 1618473',1001.00,0.00,0.00,1.54,58.52,'2022-04-02 17:43:59','',''),(2623513,'1','180','934',414,'Retail Sale Id 1618474',3003.00,0.00,0.00,4.62,175.56,'2022-04-02 17:45:52','',''),(2623514,'1','180','934',414,'Retail Sale Id 1618475',2002.00,0.00,0.00,3.08,117.04,'2022-04-02 18:03:18','',''),(2623515,'1','180','934',414,'Retail Sale Id 1618476',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 18:20:03','',''),(2623516,'1','180','934',414,'Retail Sale Id 1618477',3900.00,0.00,0.00,6.00,228.00,'2022-04-02 19:25:02','',''),(2623517,'1','180','934',414,'Retail Sale Id 1618478',650.00,0.00,0.00,1.00,38.00,'2022-04-02 19:28:20','',''),(2623518,'1','180','934',414,'Retail Sale Id 1618479',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 10:17:54','',''),(2623519,'1','180','934',414,'Retail Sale Id 1618480',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 12:21:17','',''),(2623520,'1','180','934',414,'Retail Sale Id 1618481',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 12:22:04','',''),(2623521,'1','180','934',414,'Retail Sale Id 1618482',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 12:22:53','',''),(2623522,'1','180','934',414,'Retail Sale Id 1618483',7000.50,0.00,0.00,10.77,409.26,'2022-04-03 12:23:32','',''),(2623523,'1','180','934',414,'Retail Sale Id 1618484',1202.50,0.00,0.00,1.85,70.30,'2022-04-03 12:24:24','',''),(2623524,'1','180','934',414,'Retail Sale Id 1618485',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 13:33:05','',''),(2623525,'1','180','934',414,'Retail Sale Id 1618486',4225.00,0.00,0.00,6.50,247.00,'2022-04-03 14:00:52','',''),(2623526,'1','180','934',414,'Retail Sale Id 1618487',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 14:01:45','',''),(2623527,'1','180','934',414,'Retail Sale Id 1618488',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:27:55','',''),(2623528,'1','180','934',414,'Retail Sale Id 1618489',16250.00,0.00,0.00,25.00,950.00,'2022-04-03 14:28:38','',''),(2623529,'1','180','934',414,'Retail Sale Id 1618490',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 14:36:03','',''),(2623530,'1','180','934',414,'Retail Sale Id 1618491',3601.00,0.00,0.00,5.54,210.52,'2022-04-03 14:58:59','',''),(2623531,'1','180','934',414,'Retail Sale Id 1618492',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 15:18:22','',''),(2623532,'1','180','934',414,'Retail Sale Id 1618493',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 15:19:53','',''),(2623533,'1','180','934',414,'Retail Sale Id 1618494',3250.00,0.00,0.00,5.00,190.00,'2022-04-03 16:33:00','',''),(2623534,'1','180','934',414,'Retail Sale Id 1618495',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 16:46:50','',''),(2623535,'1','180','934',414,'Retail Sale Id 1618496',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:14:53','',''),(2623536,'1','180','934',414,'Retail Sale Id 1618497',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 17:29:32','',''),(2623537,'1','180','934',414,'Retail Sale Id 1618498',3003.00,0.00,0.00,4.62,175.56,'2022-04-03 17:37:49','',''),(2623538,'1','180','934',414,'Retail Sale Id 1618499',3900.00,0.00,0.00,6.00,228.00,'2022-04-03 17:39:06','',''),(2623539,'1','180','934',414,'Retail Sale Id 1618500',37200.00,0.00,0.00,60.00,480.00,'2022-04-03 17:40:05','',''),(2623540,'1','180','934',414,'Retail Sale Id 1618501',1950.00,0.00,0.00,3.00,114.00,'2022-04-03 18:10:52','',''),(2623541,'1','180','934',414,'Retail Sale Id 1618502',8125.00,0.00,0.00,12.50,475.00,'2022-04-03 18:37:05','',''),(2623542,'1','180','934',414,'Retail Sale Id 1618503',117800.00,0.00,0.00,190.00,1520.00,'2022-04-03 19:59:56','',''),(2623543,'1','180','934',414,'Retail Sale Id 1618504',37200.00,0.00,0.00,60.00,480.00,'2022-04-04 09:22:09','',''),(2623544,'1','180','934',414,'Retail Sale Id 1618505',43400.00,0.00,0.00,70.00,560.00,'2022-04-04 14:03:30','',''),(2623545,'1','180','934',414,'Retail Sale Id 1618506',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 14:04:08','',''),(2623546,'1','180','934',414,'Retail Sale Id 1618507',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:05:23','',''),(2623547,'1','180','934',414,'Retail Sale Id 1618508',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:15:19','',''),(2623548,'1','180','934',414,'Retail Sale Id 1618509',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 14:16:14','',''),(2623549,'1','180','934',414,'Retail Sale Id 1618510',7800.00,0.00,0.00,12.00,456.00,'2022-04-04 14:26:20','',''),(2623550,'1','180','934',414,'Retail Sale Id 1618511',7910.50,0.00,0.00,12.17,462.46,'2022-04-04 14:27:13','',''),(2623551,'1','180','934',414,'Retail Sale Id 1618512',4225.00,0.00,0.00,6.50,247.00,'2022-04-04 14:28:00','',''),(2623552,'1','180','934',414,'Retail Sale Id 1618513',7202.00,0.00,0.00,11.08,421.04,'2022-04-04 14:28:50','',''),(2623553,'1','180','934',414,'Retail Sale Id 1618514',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:29:35','',''),(2623554,'1','180','934',414,'Retail Sale Id 1618515',7800.00,0.00,0.00,12.00,456.00,'2022-04-04 14:32:35','',''),(2623555,'1','180','934',414,'Retail Sale Id 1618516',7150.00,0.00,0.00,11.00,418.00,'2022-04-04 14:49:36','',''),(2623556,'1','180','934',414,'Retail Sale Id 1618517',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 15:32:45','',''),(2623557,'1','180','934',414,'Retail Sale Id 1618518',31000.00,0.00,0.00,50.00,400.00,'2022-04-04 15:43:06','',''),(2623558,'1','180','934',414,'Retail Sale Id 1618519',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 15:54:20','',''),(2623559,'1','180','934',414,'Retail Sale Id 1618520',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 15:56:03','',''),(2623560,'1','180','934',414,'Retail Sale Id 1618521',7800.00,0.00,0.00,12.00,456.00,'2022-04-04 16:51:35','',''),(2623561,'1','180','934',414,'Retail Sale Id 1618522',4550.00,0.00,0.00,7.00,266.00,'2022-04-04 16:53:40','',''),(2623562,'1','180','934',414,'Retail Sale Id 1618523',1501.50,0.00,0.00,2.31,87.78,'2022-04-04 16:54:25','',''),(2623563,'1','180','934',414,'Retail Sale Id 1618524',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 17:05:23','',''),(2623564,'1','180','934',414,'Retail Sale Id 1618525',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 17:07:18','',''),(2623565,'1','180','934',414,'Retail Sale Id 1618526',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 18:05:58','',''),(2623566,'1','180','934',414,'Retail Sale Id 1618527',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 18:08:13','',''),(2623567,'1','180','934',414,'Retail Sale Id 1618528',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 18:14:33','',''),(2623568,'1','180','934',414,'Retail Sale Id 1618529',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 18:23:17','',''),(2623569,'1','180','934',414,'Retail Sale Id 1618530',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 18:28:27','',''),(2623570,'1','180','934',414,'Retail Sale Id 1618531',37200.00,0.00,0.00,60.00,480.00,'2022-04-05 08:57:21','',''),(2623571,'1','180','934',414,'Retail Sale Id 1618532',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:15:37','',''),(2623572,'1','180','934',414,'Retail Sale Id 1618533',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:16:20','',''),(2623573,'1','180','934',414,'Retail Sale Id 1618534',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 10:17:01','',''),(2623574,'1','180','934',414,'Retail Sale Id 1618535',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 10:23:30','',''),(2623575,'1','180','934',414,'Retail Sale Id 1618536',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 14:35:48','',''),(2623576,'1','180','934',414,'Retail Sale Id 1618537',6500.00,0.00,0.00,10.00,380.00,'2022-04-05 14:36:31','',''),(2623577,'1','180','934',414,'Retail Sale Id 1618538',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 14:37:04','',''),(2623578,'1','180','934',414,'Retail Sale Id 1618539',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 14:37:59','',''),(2623579,'1','180','934',414,'Retail Sale Id 1618540',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 14:38:37','',''),(2623580,'1','180','934',414,'Retail Sale Id 1618541',31000.00,0.00,0.00,50.00,400.00,'2022-04-05 14:39:37','',''),(2623581,'1','180','934',414,'Retail Sale Id 1618542',74400.00,0.00,0.00,120.00,960.00,'2022-04-05 14:41:41','',''),(2623582,'1','180','934',414,'Retail Sale Id 1618543',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 18:18:13','',''),(2623583,'1','180','934',414,'Retail Sale Id 1618544',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 18:19:38','',''),(2623584,'1','180','934',414,'Retail Sale Id 1618545',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 18:20:24','',''),(2623585,'1','180','934',414,'Retail Sale Id 1618546',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 18:21:02','',''),(2623586,'1','180','934',414,'Retail Sale Id 1618547',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 18:21:41','',''),(2623587,'1','180','934',414,'Retail Sale Id 1618548',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 18:27:09','',''),(2623588,'1','180','934',414,'Retail Sale Id 1618549',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 18:32:27','',''),(2623589,'1','180','934',414,'Retail Sale Id 1618550',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 18:49:30','',''),(2623590,'1','180','934',414,'Retail Sale Id 1618551',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 10:28:37','',''),(2623591,'1','180','934',414,'Retail Sale Id 1618552',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 10:29:36','',''),(2623592,'1','180','934',414,'Retail Sale Id 1618553',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 11:21:36','',''),(2623593,'1','180','934',414,'Retail Sale Id 1618554',1300.00,0.00,0.00,2.00,76.00,'2022-04-06 11:22:15','',''),(2623594,'1','180','934',414,'Retail Sale Id 1618555',9997.00,0.00,0.00,15.38,584.44,'2022-04-06 11:23:09','',''),(2623595,'1','180','934',414,'Retail Sale Id 1618556',3497.00,0.00,0.00,5.38,204.44,'2022-04-06 11:23:54','',''),(2623596,'1','180','934',414,'Retail Sale Id 1618557',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 13:09:42','',''),(2623597,'1','180','934',414,'Retail Sale Id 1618558',2600.00,0.00,0.00,4.00,152.00,'2022-04-06 13:11:57','',''),(2623598,'1','180','934',414,'Retail Sale Id 1618559',117800.00,0.00,0.00,190.00,1520.00,'2022-04-06 13:14:11','',''),(2623599,'1','180','934',414,'Retail Sale Id 1618560',3003.00,0.00,0.00,4.62,175.56,'2022-04-06 15:03:41','',''),(2623600,'1','180','934',414,'Retail Sale Id 1618561',1300.00,0.00,0.00,2.00,76.00,'2022-04-06 15:04:21','',''),(2623601,'1','180','934',414,'Retail Sale Id 1618562',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 15:25:08','',''),(2623602,'1','180','934',414,'Retail Sale Id 1618563',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 16:14:48','',''),(2623603,'1','180','934',414,'Retail Sale Id 1618564',6500.00,0.00,0.00,10.00,380.00,'2022-04-06 16:41:50','',''),(2623604,'1','180','934',414,'Retail Sale Id 1618565',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 16:43:27','',''),(2623605,'1','180','934',414,'Retail Sale Id 1618566',4498.00,0.00,0.00,6.92,262.96,'2022-04-06 17:01:46','',''),(2623606,'1','180','934',414,'Retail Sale Id 1618567',799.50,0.00,0.00,1.23,46.74,'2022-04-06 17:02:30','',''),(2623607,'1','180','934',414,'Retail Sale Id 1618568',1300.00,0.00,0.00,2.00,76.00,'2022-04-06 17:11:16','',''),(2623608,'1','180','934',414,'Retail Sale Id 1618569',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 18:18:52','',''),(2623609,'1','180','934',414,'Retail Sale Id 1618570',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 18:19:54','',''),(2623610,'1','180','934',414,'Retail Sale Id 1618571',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 18:31:07','',''),(2623611,'1','180','934',414,'Retail Sale Id 1618572',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 08:49:13','',''),(2623612,'1','180','934',414,'Retail Sale Id 1618573',37200.00,0.00,0.00,60.00,480.00,'2022-04-07 08:53:43','',''),(2623613,'1','180','934',414,'Retail Sale Id 1618574',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 15:40:17','',''),(2623614,'1','180','934',414,'Retail Sale Id 1618575',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 15:41:15','',''),(2623615,'1','180','934',414,'Retail Sale Id 1618576',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 15:41:53','',''),(2623616,'1','180','934',414,'Retail Sale Id 1618577',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 18:39:48','',''),(2623617,'1','180','934',414,'Retail Sale Id 1618578',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 19:23:25','',''),(2623618,'1','180','934',414,'Retail Sale Id 1618579',1501.50,0.00,0.00,2.31,87.78,'2022-04-07 19:24:05','',''),(2623619,'1','180','934',414,'Retail Sale Id 1618580',37200.00,0.00,0.00,60.00,480.00,'2022-04-08 11:48:20','',''),(2623620,'1','180','934',414,'Retail Sale Id 1618582',6500.00,0.00,0.00,10.00,380.00,'2022-04-08 13:20:50','',''),(2623621,'1','180','934',414,'Retail Sale Id 1618583',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 13:21:36','',''),(2623622,'1','180','934',414,'Retail Sale Id 1618584',2002.00,0.00,0.00,3.08,117.04,'2022-04-08 13:22:28','',''),(2623623,'1','180','934',414,'Retail Sale Id 1618585',62000.00,0.00,0.00,100.00,800.00,'2022-04-08 16:26:18','',''),(2623624,'1','180','934',414,'Retail Sale Id 1618586',3250.00,0.00,0.00,5.00,190.00,'2022-04-08 18:48:10','',''),(2623625,'1','180','934',414,'Retail Sale Id 1618587',3003.00,0.00,0.00,4.62,175.56,'2022-04-08 19:24:14','',''),(2623626,'1','180','934',414,'Retail Sale Id 1618588',3120.00,0.00,0.00,4.80,182.40,'2022-04-09 13:08:55','',''),(2623627,'1','180','934',414,'Retail Sale Id 1618589',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 16:18:34','',''),(2623628,'1','180','934',414,'Retail Sale Id 1618590',3250.00,0.00,0.00,5.00,190.00,'2022-04-09 16:19:10','',''),(2623629,'1','180','934',414,'Retail Sale Id 1618591',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 16:19:43','',''),(2623630,'1','180','934',414,'Retail Sale Id 1618592',1950.00,0.00,0.00,3.00,114.00,'2022-04-09 19:22:40','',''),(2623631,'1','180','934',414,'Retail Sale Id 1618593',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 22:30:08','',''),(2623632,'1','180','934',414,'Retail Sale Id 1618594',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 11:25:22','',''),(2623633,'1','180','934',414,'Retail Sale Id 1618595',5200.00,0.00,0.00,8.00,304.00,'2022-04-10 11:26:06','',''),(2623634,'1','180','934',414,'Retail Sale Id 1618596',7000.50,0.00,0.00,10.77,409.26,'2022-04-10 11:26:57','',''),(2623635,'1','180','934',414,'Retail Sale Id 1618597',2600.00,0.00,0.00,4.00,152.00,'2022-04-10 11:27:42','',''),(2623636,'1','180','934',414,'Retail Sale Id 1618598',8125.00,0.00,0.00,12.50,475.00,'2022-04-10 12:54:33','',''),(2623637,'1','180','934',414,'Retail Sale Id 1618599',8125.00,0.00,0.00,12.50,475.00,'2022-04-10 12:55:09','',''),(2623638,'1','180','934',414,'Retail Sale Id 1618600',93000.00,0.00,0.00,150.00,1200.00,'2022-04-10 14:50:08','',''),(2623639,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344949',238643.28,0.00,0.00,389.94,0.00,'2022-04-17 05:56:19','',''),(2623640,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,3010000.00,5000.00,0.00,0.00,'2022-04-17 11:14:02','',''),(2623641,'1','180',NULL,414,'Reception corrector for bridging 130292',0.00,0.00,0.00,5000.00,0.00,'2022-04-17 11:16:36','',''),(2623642,'1','180','934',414,'Received from bridging 130292',0.00,0.00,5000.00,0.00,0.00,'2022-04-17 11:16:36','',''),(2623643,'1','180','934',414,'Retail Sale Id 1618601',1950.00,0.00,0.00,3.00,144.00,'2022-04-17 11:23:14','',''),(2623644,'1','180','934',414,'Retail Sale Id 1618602',3900.00,0.00,0.00,6.00,288.00,'2022-04-17 11:23:59','',''),(2623645,'1','180','934',414,'Retail Sale Id 1618603',8125.00,0.00,0.00,12.50,600.00,'2022-04-17 12:07:23','',''),(2623646,'1','180','934',414,'Retail Sale Id 1618604',3900.00,0.00,0.00,6.00,288.00,'2022-04-17 13:47:32','',''),(2623647,'1','180','934',414,'Retail Sale Id 1618605',3003.00,0.00,0.00,4.62,221.76,'2022-04-17 13:48:20','',''),(2623648,'1','180','934',414,'Retail Sale Id 1618606',7800.00,0.00,0.00,12.00,576.00,'2022-04-17 13:50:07','',''),(2623649,'1','180','934',414,'Retail Sale Id 1618607',1501.50,0.00,0.00,2.31,110.88,'2022-04-17 13:50:56','',''),(2623650,'1','180','934',414,'Retail Sale Id 1618608',105400.00,0.00,0.00,170.00,3060.00,'2022-04-17 13:52:45','',''),(2623651,'1','180','934',414,'Retail Sale Id 1618609',3900.00,0.00,0.00,6.00,288.00,'2022-04-17 17:30:56','',''),(2623652,'1','180','934',414,'Retail Sale Id 1618610',1950.00,0.00,0.00,3.00,144.00,'2022-04-17 17:31:40','',''),(2623653,'1','180','934',414,'Retail Sale Id 1618611',1501.50,0.00,0.00,2.31,110.88,'2022-04-17 17:32:50','',''),(2623654,'1','180','934',414,'Retail Sale Id 1618612',1950.00,0.00,0.00,3.00,144.00,'2022-04-17 18:28:43','',''),(2623655,'1','180','934',414,'Retail Sale Id 1618613',3497.00,0.00,0.00,5.38,258.24,'2022-04-17 18:29:37','',''),(2623656,'1','180','934',414,'Retail Sale Id 1618614',2502.50,0.00,0.00,3.85,184.80,'2022-04-17 19:28:57','',''),(2623657,'1','180','934',414,'Retail Sale Id 1618615',3900.00,0.00,0.00,6.00,288.00,'2022-04-18 10:23:25','',''),(2623658,'1','180','934',414,'Retail Sale Id 1618616',8125.00,0.00,0.00,12.50,600.00,'2022-04-18 11:16:12','',''),(2623659,'1','180','934',414,'Retail Sale Id 1618617',2600.00,0.00,0.00,4.00,192.00,'2022-04-18 11:45:04','',''),(2623660,'1','180','934',414,'Retail Sale Id 1618618',3250.00,0.00,0.00,5.00,240.00,'2022-04-18 11:54:12','',''),(2623661,'1','180','934',414,'Retail Sale Id 1618619',1950.00,0.00,0.00,3.00,144.00,'2022-04-18 12:06:25','',''),(2623662,'1','180','934',414,'Retail Sale Id 1618620',3497.00,0.00,0.00,5.38,258.24,'2022-04-18 12:19:14','',''),(2623663,'1','180','934',414,'Retail Sale Id 1618621',3997.50,0.00,0.00,6.15,295.20,'2022-04-18 12:19:56','',''),(2623664,'1','180','934',414,'Retail Sale Id 1618622',8125.00,0.00,0.00,12.50,600.00,'2022-04-18 16:24:49','',''),(2623665,'1','180','934',414,'Retail Sale Id 1618623',8125.00,0.00,0.00,12.50,600.00,'2022-04-18 16:25:24','',''),(2623666,'1','180','934',414,'Retail Sale Id 1618624',1800.50,0.00,0.00,2.77,132.96,'2022-04-18 18:17:37','',''),(2623667,'1','180','934',414,'Retail Sale Id 1618625',3250.00,0.00,0.00,5.00,240.00,'2022-04-18 18:18:49','',''),(2623668,'1','180','934',414,'Retail Sale Id 1618626',3900.00,0.00,0.00,6.00,288.00,'2022-04-19 09:52:31','',''),(2623669,'1','180','934',414,'Retail Sale Id 1618627',799.50,0.00,0.00,1.23,59.04,'2022-04-19 09:53:24','',''),(2623670,'1','180','934',414,'Retail Sale Id 1618628',1950.00,0.00,0.00,3.00,144.00,'2022-04-19 14:12:22','',''),(2623671,'1','180','934',414,'Retail Sale Id 1618629',2002.00,0.00,0.00,3.08,147.84,'2022-04-19 14:13:01','',''),(2623672,'1','180','934',414,'Retail Sale Id 1618630',3250.00,0.00,0.00,5.00,240.00,'2022-04-19 14:13:39','',''),(2623673,'1','180','934',414,'Retail Sale Id 1618631',2502.50,0.00,0.00,3.85,184.80,'2022-04-19 14:14:22','',''),(2623674,'1','180','934',414,'Retail Sale Id 1618632',3900.00,0.00,0.00,6.00,288.00,'2022-04-19 14:14:58','',''),(2623675,'1','180','934',414,'Retail Sale Id 1618633',8125.00,0.00,0.00,12.50,600.00,'2022-04-19 16:45:19','',''),(2623676,'1','180','934',414,'Retail Sale Id 1618634',3900.00,0.00,0.00,6.00,288.00,'2022-04-19 16:45:56','',''),(2623677,'1','180','934',414,'Retail Sale Id 1618635',1950.00,0.00,0.00,3.00,144.00,'2022-04-19 16:46:42','',''),(2623678,'1','180','934',414,'Retail Sale Id 1618636',4998.50,0.00,0.00,7.69,369.12,'2022-04-19 16:47:21','',''),(2623679,'1','180','934',414,'Retail Sale Id 1618637',1950.00,0.00,0.00,3.00,144.00,'2022-04-19 17:44:04','',''),(2623680,'1','180','934',414,'Retail Sale Id 1618638',4998.50,0.00,0.00,7.69,369.12,'2022-04-19 17:59:07','',''),(2623681,'1','180','934',414,'Retail Sale Id 1618640',1800.50,0.00,0.00,2.77,132.96,'2022-04-19 18:25:04','',''),(2623682,'1','180','934',414,'Retail Sale Id 1618641',68200.00,0.00,0.00,110.00,1980.00,'2022-04-20 10:06:18','',''),(2623683,'1','180','934',414,'Retail Sale Id 1618642',1950.00,0.00,0.00,3.00,144.00,'2022-04-20 10:07:05','',''),(2623684,'1','180','934',414,'Retail Sale Id 1618643',3250.00,0.00,0.00,5.00,240.00,'2022-04-20 10:09:16','',''),(2623685,'1','180','934',414,'Retail Sale Id 1618644',3003.00,0.00,0.00,4.62,221.76,'2022-04-20 11:29:19','',''),(2623686,'1','180','934',414,'Retail Sale Id 1618645',2801.50,0.00,0.00,4.31,206.88,'2022-04-20 11:30:01','',''),(2623687,'1','180','934',414,'Retail Sale Id 1618646',2600.00,0.00,0.00,4.00,192.00,'2022-04-20 16:43:34','',''),(2623688,'1','180','934',414,'Retail Sale Id 1618647',1950.00,0.00,0.00,3.00,144.00,'2022-04-20 16:44:37','',''),(2623689,'1','180','934',414,'Retail Sale Id 1618648',3250.00,0.00,0.00,5.00,240.00,'2022-04-20 16:46:11','',''),(2623690,'1','180','934',414,'Retail Sale Id 1618649',3900.00,0.00,0.00,6.00,288.00,'2022-04-20 18:01:58','',''),(2623691,'1','180','934',414,'Retail Sale Id 1618650',5200.00,0.00,0.00,8.00,384.00,'2022-04-20 18:03:18','',''),(2623692,'1','180','934',414,'Retail Sale Id 1618651',2600.00,0.00,0.00,4.00,192.00,'2022-04-20 18:04:14','',''),(2623693,'1','180','934',414,'Retail Sale Id 1618652',4998.50,0.00,0.00,7.69,369.12,'2022-04-20 18:05:11','',''),(2623694,'1','180','934',414,'Retail Sale Id 1618653',1501.50,0.00,0.00,2.31,110.88,'2022-04-20 18:05:59','',''),(2623695,'1','180','934',414,'Retail Sale Id 1618654',3250.00,0.00,0.00,5.00,240.00,'2022-04-21 10:07:22','',''),(2623696,'1','180','934',414,'Retail Sale Id 1618655',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 10:08:05','',''),(2623697,'1','180','934',414,'Retail Sale Id 1618656',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 11:13:41','',''),(2623698,'1','180','934',414,'Retail Sale Id 1618657',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 14:36:46','',''),(2623699,'1','180','934',414,'Retail Sale Id 1618658',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 15:17:46','',''),(2623700,'1','180','934',414,'Retail Sale Id 1618659',1501.50,0.00,0.00,2.31,110.88,'2022-04-21 15:26:12','',''),(2623701,'1','180','934',414,'Retail Sale Id 1618660',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 16:22:23','',''),(2623702,'1','180','934',414,'Retail Sale Id 1618661',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 16:23:10','',''),(2623703,'1','180','934',414,'Retail Sale Id 1618662',6500.00,0.00,0.00,10.00,480.00,'2022-04-21 19:29:40','',''),(2623704,'1','180','934',414,'Retail Sale Id 1618663',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 10:00:19','',''),(2623705,'1','180','934',414,'Retail Sale Id 1618664',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 10:01:20','',''),(2623706,'1','180','934',414,'Retail Sale Id 1618665',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 10:36:57','',''),(2623707,'1','180','934',414,'Retail Sale Id 1618666',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 10:37:33','',''),(2623708,'1','180','934',414,'Retail Sale Id 1618667',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 12:42:10','',''),(2623709,'1','180','934',414,'Retail Sale Id 1618668',2002.00,0.00,0.00,3.08,147.84,'2022-04-22 12:45:32','',''),(2623710,'1','180','934',414,'Retail Sale Id 1618669',2502.50,0.00,0.00,3.85,184.80,'2022-04-22 12:46:42','',''),(2623711,'1','180','934',414,'Retail Sale Id 1618670',1501.50,0.00,0.00,2.31,110.88,'2022-04-22 13:46:14','',''),(2623712,'1','180','934',414,'Retail Sale Id 1618671',2502.50,0.00,0.00,3.85,184.80,'2022-04-22 15:14:24','',''),(2623713,'1','180','934',414,'Retail Sale Id 1618672',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 15:16:40','',''),(2623714,'1','180','934',414,'Retail Sale Id 1618673',799.50,0.00,0.00,1.23,59.04,'2022-04-22 15:44:20','',''),(2623715,'1','180','934',414,'Retail Sale Id 1618674',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 16:19:32','',''),(2623716,'1','180','934',414,'Retail Sale Id 1618675',31000.00,0.00,0.00,50.00,900.00,'2022-04-22 16:24:18','',''),(2623717,'1','180','934',414,'Retail Sale Id 1618676',3003.00,0.00,0.00,4.62,221.76,'2022-04-22 17:05:06','',''),(2623718,'1','180','934',414,'Retail Sale Id 1618677',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 17:09:27','',''),(2623719,'1','180','934',414,'Retail Sale Id 1618678',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 17:53:14','',''),(2623720,'1','180','934',414,'Retail Sale Id 1618679',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 17:53:52','',''),(2623721,'1','180','934',414,'Retail Sale Id 1618680',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 17:54:38','',''),(2623722,'1','180','934',414,'Retail Sale Id 1618681',650.00,0.00,0.00,1.00,48.00,'2022-04-22 17:55:21','',''),(2623723,'1','180','934',414,'Retail Sale Id 1618682',1300.00,0.00,0.00,2.00,96.00,'2022-04-22 17:55:58','',''),(2623724,'1','180','934',414,'Return of Retail Sale Id 1618675',0.00,31000.00,50.00,0.00,-900.00,'2022-04-22 17:57:17','',''),(2623725,'1','180','934',414,'Retail Sale Id 1618683',31000.00,0.00,0.00,50.00,900.00,'2022-04-22 17:58:14','',''),(2623726,'1','180','934',414,'Retail Sale Id 1618684',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 18:41:49','',''),(2623727,'1','180','934',414,'Retail Sale Id 1618685',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 18:42:34','',''),(2623728,'1','180','934',414,'Retail Sale Id 1618686',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 10:20:35','',''),(2623729,'1','180','934',414,'Retail Sale Id 1618687',3003.00,0.00,0.00,4.62,221.76,'2022-04-23 10:21:22','',''),(2623730,'1','180','934',414,'Retail Sale Id 1618688',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 10:22:21','',''),(2623731,'1','180','934',414,'Retail Sale Id 1618689',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 10:23:07','',''),(2623732,'1','180','934',414,'Retail Sale Id 1618690',5999.50,0.00,0.00,9.23,443.04,'2022-04-23 12:21:30','',''),(2623733,'1','180','934',414,'Retail Sale Id 1618691',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 12:39:24','',''),(2623734,'1','180','934',414,'Retail Sale Id 1618692',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 12:41:49','',''),(2623735,'1','180','934',414,'Retail Sale Id 1618693',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 12:43:05','',''),(2623736,'1','180','934',414,'Retail Sale Id 1618694',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 12:50:08','',''),(2623737,'1','180','934',414,'Retail Sale Id 1618695',1625.00,0.00,0.00,2.50,120.00,'2022-04-23 12:51:27','',''),(2623738,'1','180','934',414,'Retail Sale Id 1618696',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 12:52:25','',''),(2623739,'1','180','934',414,'Retail Sale Id 1618697',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 12:53:22','',''),(2623740,'1','180','934',414,'Retail Sale Id 1618698',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 14:50:21','',''),(2623741,'1','180','934',414,'Retail Sale Id 1618699',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 14:51:12','',''),(2623742,'1','180','934',414,'Retail Sale Id 1618700',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 14:51:56','',''),(2623743,'1','180','934',414,'Retail Sale Id 1618701',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 15:38:05','',''),(2623744,'1','180','934',414,'Retail Sale Id 1618702',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 15:38:46','',''),(2623745,'1','180','934',414,'Retail Sale Id 1618703',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 15:41:10','',''),(2623746,'1','180','934',414,'Retail Sale Id 1618704',8125.00,0.00,0.00,12.50,600.00,'2022-04-23 15:41:52','',''),(2623747,'1','180','934',414,'Retail Sale Id 1618705',5200.00,0.00,0.00,8.00,384.00,'2022-04-23 16:25:25','',''),(2623748,'1','180','934',414,'Retail Sale Id 1618706',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 16:26:07','',''),(2623749,'1','180','934',414,'Retail Sale Id 1618707',3497.00,0.00,0.00,5.38,258.24,'2022-04-23 16:26:52','',''),(2623750,'1','180','934',414,'Retail Sale Id 1618709',3497.00,0.00,0.00,5.38,258.24,'2022-04-23 18:20:02','',''),(2623751,'1','180','934',414,'Retail Sale Id 1618710',3003.00,0.00,0.00,4.62,221.76,'2022-04-23 18:20:54','',''),(2623752,'1','180','934',414,'Retail Sale Id 1618711',8125.00,0.00,0.00,12.50,600.00,'2022-04-23 19:43:08','',''),(2623753,'1','180','934',414,'Retail Sale Id 1618712',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 19:48:26','',''),(2623754,'1','180','934',414,'Retail Sale Id 1618713',3003.00,0.00,0.00,4.62,221.76,'2022-04-23 19:49:34','',''),(2623755,'1','180','934',414,'Retail Sale Id 1618714',3497.00,0.00,0.00,5.38,258.24,'2022-04-23 19:51:12','',''),(2623756,'1','180','934',414,'Retail Sale Id 1618715',3900.00,0.00,0.00,6.00,288.00,'2022-04-24 10:22:53','',''),(2623757,'1','180','934',414,'Retail Sale Id 1618716',2002.00,0.00,0.00,3.08,147.84,'2022-04-24 10:23:49','',''),(2623758,'1','180','934',414,'Retail Sale Id 1618717',3997.50,0.00,0.00,6.15,295.20,'2022-04-24 11:10:16','',''),(2623759,'1','180','934',414,'Retail Sale Id 1618718',3250.00,0.00,0.00,5.00,240.00,'2022-04-24 12:03:33','',''),(2623760,'1','180','934',414,'Retail Sale Id 1618719',3250.00,0.00,0.00,5.00,240.00,'2022-04-24 12:04:26','',''),(2623761,'1','180','934',414,'Retail Sale Id 1618720',1397.50,0.00,0.00,2.15,103.20,'2022-04-24 12:07:06','',''),(2623762,'1','180','934',414,'Retail Sale Id 1618721',1800.50,0.00,0.00,2.77,132.96,'2022-04-24 12:09:22','',''),(2623763,'1','180','934',414,'Retail Sale Id 1618722',3003.00,0.00,0.00,4.62,221.76,'2022-04-24 14:28:48','',''),(2623764,'1','180','934',414,'Retail Sale Id 1618723',1300.00,0.00,0.00,2.00,96.00,'2022-04-24 14:29:27','',''),(2623765,'1','180','934',414,'Retail Sale Id 1618724',8125.00,0.00,0.00,12.50,600.00,'2022-04-24 17:08:32','',''),(2623766,'1','180','934',414,'Retail Sale Id 1618725',1950.00,0.00,0.00,3.00,144.00,'2022-04-24 17:09:10','',''),(2623767,'1','180','934',414,'Retail Sale Id 1618726',3900.00,0.00,0.00,6.00,288.00,'2022-04-24 17:29:33','',''),(2623768,'1','180','934',414,'Retail Sale Id 1618727',3900.00,0.00,0.00,6.00,288.00,'2022-04-24 17:30:08','',''),(2623769,'1','180','934',414,'Retail Sale Id 1618728',1501.50,0.00,0.00,2.31,110.88,'2022-04-24 17:31:23','',''),(2623770,'1','180','934',414,'Retail Sale Id 1618729',2502.50,0.00,0.00,3.85,184.80,'2022-04-24 19:23:53','',''),(2623771,'1','180','934',414,'Retail Sale Id 1618730',3003.00,0.00,0.00,4.62,221.76,'2022-04-24 19:25:18','',''),(2623772,'1','180','934',414,'Retail Sale Id 1618731',3900.00,0.00,0.00,6.00,288.00,'2022-04-25 09:26:09','',''),(2623773,'1','180','934',414,'Retail Sale Id 1618732',1950.00,0.00,0.00,3.00,144.00,'2022-04-25 11:57:43','',''),(2623774,'1','180','934',414,'Retail Sale Id 1618733',1950.00,0.00,0.00,3.00,144.00,'2022-04-25 11:59:20','',''),(2623775,'1','180','934',414,'Retail Sale Id 1618734',1950.00,0.00,0.00,3.00,144.00,'2022-04-25 12:00:23','',''),(2623776,'1','180','934',414,'Retail Sale Id 1618735',2002.00,0.00,0.00,3.08,147.84,'2022-04-25 14:44:31','',''),(2623777,'1','180','934',414,'Retail Sale Id 1618736',2002.00,0.00,0.00,3.08,147.84,'2022-04-25 14:45:31','',''),(2623778,'1','180','934',414,'Retail Sale Id 1618737',3900.00,0.00,0.00,6.00,288.00,'2022-04-25 14:46:16','',''),(2623779,'1','180','934',414,'Retail Sale Id 1618738',2002.00,0.00,0.00,3.08,147.84,'2022-04-25 14:47:26','',''),(2623780,'1','180','934',414,'Retail Sale Id 1618739',3003.00,0.00,0.00,4.62,221.76,'2022-04-25 15:54:50','',''),(2623781,'1','180','934',414,'Retail Sale Id 1618740',1950.00,0.00,0.00,3.00,144.00,'2022-04-25 15:55:35','',''),(2623782,'1','180','934',414,'Retail Sale Id 1618741',3003.00,0.00,0.00,4.62,221.76,'2022-04-25 15:56:18','',''),(2623783,'1','180','934',414,'Retail Sale Id 1618742',6350.50,0.00,0.00,9.77,468.96,'2022-04-25 17:17:44','',''),(2623784,'1','180','934',414,'Retail Sale Id 1618743',1001.00,0.00,0.00,1.54,73.92,'2022-04-25 17:18:21','',''),(2623785,'1','180','934',414,'Retail Sale Id 1618744',1001.00,0.00,0.00,1.54,73.92,'2022-04-25 17:18:57','',''),(2623786,'1','180','934',414,'Retail Sale Id 1618745',1001.00,0.00,0.00,1.54,73.92,'2022-04-25 17:20:07','',''),(2623787,'1','180','934',414,'Retail Sale Id 1618746',3900.00,0.00,0.00,6.00,288.00,'2022-04-25 18:28:16','',''),(2623788,'1','180','934',414,'Retail Sale Id 1618747',3900.00,0.00,0.00,6.00,288.00,'2022-04-26 09:54:38','',''),(2623789,'1','180','934',414,'Retail Sale Id 1618748',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 09:55:47','',''),(2623790,'1','180','934',414,'Retail Sale Id 1618749',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 09:56:38','',''),(2623791,'1','180','934',414,'Retail Sale Id 1618750',3900.00,0.00,0.00,6.00,288.00,'2022-04-26 12:41:44','',''),(2623792,'1','180','934',414,'Retail Sale Id 1618751',3250.00,0.00,0.00,5.00,240.00,'2022-04-26 12:42:29','',''),(2623793,'1','180','934',414,'Retail Sale Id 1618752',3900.00,0.00,0.00,6.00,288.00,'2022-04-26 12:53:37','',''),(2623794,'1','180','934',414,'Retail Sale Id 1618753',2002.00,0.00,0.00,3.08,147.84,'2022-04-26 12:54:22','',''),(2623795,'1','180','934',414,'Retail Sale Id 1618754',1001.00,0.00,0.00,1.54,73.92,'2022-04-26 12:55:09','',''),(2623796,'1','180','934',414,'Retail Sale Id 1618755',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 16:56:10','',''),(2623797,'1','180','934',414,'Retail Sale Id 1618756',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 16:56:45','',''),(2623798,'1','180','934',414,'Retail Sale Id 1618757',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 16:57:23','',''),(2623799,'1','180','934',414,'Retail Sale Id 1618758',3900.00,0.00,0.00,6.00,288.00,'2022-04-26 16:58:03','',''),(2623800,'1','180','934',414,'Retail Sale Id 1618759',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 16:58:44','',''),(2623801,'1','180','934',414,'Retail Sale Id 1618760',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 16:59:24','',''),(2623802,'1','180','934',414,'Retail Sale Id 1618761',2002.00,0.00,0.00,3.08,147.84,'2022-04-26 17:00:05','',''),(2623803,'1','180','934',414,'Retail Sale Id 1618762',2600.00,0.00,0.00,4.00,192.00,'2022-04-26 17:00:49','',''),(2623804,'1','180','934',414,'Retail Sale Id 1618763',1001.00,0.00,0.00,1.54,73.92,'2022-04-26 17:01:29','',''),(2623805,'1','180','934',414,'Retail Sale Id 1618764',3250.00,0.00,0.00,5.00,240.00,'2022-04-26 17:02:06','',''),(2623806,'1','180','934',414,'Retail Sale Id 1618765',1950.00,0.00,0.00,3.00,144.00,'2022-04-26 17:28:05','',''),(2623807,'1','180','934',414,'Retail Sale Id 1618766',3497.00,0.00,0.00,5.38,258.24,'2022-04-26 17:36:23','',''),(2623808,'1','180','934',414,'Retail Sale Id 1618767',799.50,0.00,0.00,1.23,59.04,'2022-04-26 17:36:58','',''),(2623809,'1','180','934',414,'Retail Sale Id 1618768',702.00,0.00,0.00,1.08,51.84,'2022-04-26 19:24:30','',''),(2623810,'1','180','934',414,'Retail Sale Id 1618769',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 09:39:40','',''),(2623811,'1','180','934',414,'Retail Sale Id 1618770',8125.00,0.00,0.00,12.50,600.00,'2022-04-27 11:23:38','',''),(2623812,'1','180','934',414,'Retail Sale Id 1618771',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 11:25:01','',''),(2623813,'1','180','934',414,'Retail Sale Id 1618772',1950.00,0.00,0.00,3.00,144.00,'2022-04-27 11:25:52','',''),(2623814,'1','180','934',414,'Retail Sale Id 1618773',2600.00,0.00,0.00,4.00,192.00,'2022-04-27 11:26:41','',''),(2623815,'1','180','934',414,'Retail Sale Id 1618774',3250.00,0.00,0.00,5.00,240.00,'2022-04-27 11:27:35','',''),(2623816,'1','180','934',414,'Retail Sale Id 1618775',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 11:28:21','',''),(2623817,'1','180','934',414,'Retail Sale Id 1618776',1950.00,0.00,0.00,3.00,144.00,'2022-04-27 11:29:20','',''),(2623818,'1','180','934',414,'Retail Sale Id 1618777',1950.00,0.00,0.00,3.00,144.00,'2022-04-27 11:30:17','',''),(2623819,'1','180','934',414,'Retail Sale Id 1618778',8125.00,0.00,0.00,12.50,600.00,'2022-04-27 11:31:08','',''),(2623820,'1','180','934',414,'Retail Sale Id 1618779',2002.00,0.00,0.00,3.08,147.84,'2022-04-27 11:32:28','',''),(2623821,'1','180','934',414,'Retail Sale Id 1618780',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 13:31:23','',''),(2623822,'1','180','934',414,'Retail Sale Id 1618781',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 13:32:04','',''),(2623823,'1','180','934',414,'Retail Sale Id 1618782',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 13:32:47','',''),(2623824,'1','180','934',414,'Retail Sale Id 1618783',3003.00,0.00,0.00,4.62,221.76,'2022-04-27 13:33:48','',''),(2623825,'1','180','934',414,'Retail Sale Id 1618784',2197.00,0.00,0.00,3.38,162.24,'2022-04-27 13:34:42','',''),(2623826,'1','180','934',414,'Retail Sale Id 1618785',1501.50,0.00,0.00,2.31,110.88,'2022-04-27 13:35:29','',''),(2623827,'1','180','934',414,'Retail Sale Id 1618786',8125.00,0.00,0.00,12.50,600.00,'2022-04-27 13:36:16','',''),(2623828,'1','180','934',414,'Retail Sale Id 1618787',31000.00,0.00,0.00,50.00,900.00,'2022-04-27 13:39:41','',''),(2623829,'1','180','934',414,'Retail Sale Id 1618788',3900.00,0.00,0.00,6.00,288.00,'2022-04-27 14:19:04','',''),(2623830,'1','180','934',414,'Retail Sale Id 1618789',3250.00,0.00,0.00,5.00,240.00,'2022-04-27 16:51:47','',''),(2623831,'1','180','934',414,'Retail Sale Id 1618790',3003.00,0.00,0.00,4.62,221.76,'2022-04-27 16:52:27','',''),(2623832,'1','180','934',414,'Retail Sale Id 1618791',3250.00,0.00,0.00,5.00,240.00,'2022-04-27 18:05:07','',''),(2623833,'1','180','934',414,'Retail Sale Id 1618792',3250.00,0.00,0.00,5.00,240.00,'2022-04-27 18:06:13','',''),(2623834,'1','180','934',414,'Retail Sale Id 1618793',2002.00,0.00,0.00,3.08,147.84,'2022-04-27 18:08:40','',''),(2623835,'1','180','934',414,'Retail Sale Id 1618794',3003.00,0.00,0.00,4.62,221.76,'2022-04-27 18:10:23','',''),(2623836,'1','180','934',414,'Retail Sale Id 1618795',3497.00,0.00,0.00,5.38,258.24,'2022-04-27 19:27:50','',''),(2623837,'1','180','934',414,'Retail Sale Id 1618796',3900.00,0.00,0.00,6.00,288.00,'2022-04-28 09:48:50','',''),(2623838,'1','180','934',414,'Retail Sale Id 1618797',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 12:18:28','',''),(2623839,'1','180','934',414,'Retail Sale Id 1618798',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 12:19:13','',''),(2623840,'1','180','934',414,'Retail Sale Id 1618799',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 12:19:58','',''),(2623841,'1','180','934',414,'Retail Sale Id 1618801',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 12:21:14','',''),(2623842,'1','180','934',414,'Retail Sale Id 1618802',3900.00,0.00,0.00,6.00,288.00,'2022-04-28 13:42:43','',''),(2623843,'1','180','934',414,'Retail Sale Id 1618803',8125.00,0.00,0.00,12.50,600.00,'2022-04-28 13:43:27','',''),(2623844,'1','180','934',414,'Retail Sale Id 1618804',3003.00,0.00,0.00,4.62,221.76,'2022-04-28 15:03:54','',''),(2623845,'1','180','934',414,'Retail Sale Id 1618805',2600.00,0.00,0.00,4.00,192.00,'2022-04-28 15:13:51','',''),(2623846,'1','180','934',414,'Retail Sale Id 1618806',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 17:18:38','',''),(2623847,'1','180','934',414,'Retail Sale Id 1618807',2002.00,0.00,0.00,3.08,147.84,'2022-04-28 17:19:29','',''),(2623848,'1','180','934',414,'Retail Sale Id 1618808',1800.50,0.00,0.00,2.77,132.96,'2022-04-28 17:25:34','',''),(2623849,'1','180','934',414,'Retail Sale Id 1618809',1001.00,0.00,0.00,1.54,73.92,'2022-04-28 17:30:13','',''),(2623850,'1','180','934',414,'Retail Sale Id 1618810',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 18:14:15','',''),(2623851,'1','180','934',414,'Retail Sale Id 1618811',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 18:14:54','',''),(2623852,'1','180','934',414,'Retail Sale Id 1618812',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 18:45:39','',''),(2623853,'1','180','934',414,'Retail Sale Id 1618813',3900.00,0.00,0.00,6.00,288.00,'2022-04-28 18:46:24','',''),(2623854,'1','180','934',414,'Retail Sale Id 1618814',1950.00,0.00,0.00,3.00,144.00,'2022-04-28 18:47:03','',''),(2623855,'1','180','934',414,'Retail Sale Id 1618815',3900.00,0.00,0.00,6.00,288.00,'2022-04-29 08:51:06','',''),(2623856,'1','180','934',414,'Retail Sale Id 1618816',5200.00,0.00,0.00,8.00,384.00,'2022-04-29 11:04:45','',''),(2623857,'1','180','934',414,'Retail Sale Id 1618817',1950.00,0.00,0.00,3.00,144.00,'2022-04-29 11:05:27','',''),(2623858,'1','180','934',414,'Retail Sale Id 1618818',5200.00,0.00,0.00,8.00,384.00,'2022-04-29 11:06:07','',''),(2623859,'1','180','934',414,'Retail Sale Id 1618819',2197.00,0.00,0.00,3.38,162.24,'2022-04-29 11:06:52','',''),(2623860,'1','180','934',414,'Retail Sale Id 1618820',1501.50,0.00,0.00,2.31,110.88,'2022-04-29 11:07:30','',''),(2623861,'1','180','934',414,'Retail Sale Id 1618821',8125.00,0.00,0.00,12.50,600.00,'2022-04-29 11:08:18','',''),(2623862,'1','180','934',414,'Retail Sale Id 1618822',3250.00,0.00,0.00,5.00,240.00,'2022-04-29 11:09:37','',''),(2623863,'1','180','934',414,'Retail Sale Id 1618823',3003.00,0.00,0.00,4.62,221.76,'2022-04-29 11:12:21','',''),(2623864,'1','180','934',414,'Retail Sale Id 1618824',3997.50,0.00,0.00,6.15,295.20,'2022-04-29 11:13:03','',''),(2623865,'1','180','934',414,'Retail Sale Id 1618825',3003.00,0.00,0.00,4.62,221.76,'2022-04-29 11:13:50','',''),(2623866,'1','180','934',414,'Retail Sale Id 1618826',1300.00,0.00,0.00,2.00,96.00,'2022-04-29 11:14:28','',''),(2623867,'1','180','934',414,'Retail Sale Id 1618827',3900.00,0.00,0.00,6.00,288.00,'2022-04-29 13:19:53','',''),(2623868,'1','180','934',414,'Retail Sale Id 1618828',8125.00,0.00,0.00,12.50,600.00,'2022-04-29 13:21:36','',''),(2623869,'1','180','934',414,'Retail Sale Id 1618829',2002.00,0.00,0.00,3.08,147.84,'2022-04-29 13:23:55','',''),(2623870,'1','180','934',414,'Retail Sale Id 1618830',2002.00,0.00,0.00,3.08,147.84,'2022-04-29 13:24:34','',''),(2623871,'1','180','934',414,'Retail Sale Id 1618831',3003.00,0.00,0.00,4.62,221.76,'2022-04-29 13:25:16','',''),(2623872,'1','180','934',414,'Retail Sale Id 1618832',1501.50,0.00,0.00,2.31,110.88,'2022-04-29 13:26:02','',''),(2623873,'1','180','934',414,'Retail Sale Id 1618833',37200.00,0.00,0.00,60.00,1080.00,'2022-04-29 13:41:47','',''),(2623874,'1','180','934',414,'Retail Sale Id 1618834',3900.00,0.00,0.00,6.00,288.00,'2022-04-29 20:49:06','',''),(2623875,'1','180','934',414,'Retail Sale Id 1618835',3250.00,0.00,0.00,5.00,240.00,'2022-04-30 08:42:14','',''),(2623876,'1','180','934',414,'Retail Sale Id 1618836',2002.00,0.00,0.00,3.08,147.84,'2022-04-30 08:43:15','',''),(2623877,'1','180','934',414,'Retail Sale Id 1618837',2002.00,0.00,0.00,3.08,147.84,'2022-04-30 08:44:24','',''),(2623878,'1','180','934',414,'Retail Sale Id 1618838',1501.50,0.00,0.00,2.31,110.88,'2022-04-30 08:45:23','',''),(2623879,'1','180','934',414,'Retail Sale Id 1618839',2002.00,0.00,0.00,3.08,147.84,'2022-04-30 11:44:22','',''),(2623880,'1','180','934',414,'Retail Sale Id 1618840',6500.00,0.00,0.00,10.00,480.00,'2022-04-30 11:45:17','',''),(2623881,'1','180','934',414,'Retail Sale Id 1618841',1950.00,0.00,0.00,3.00,144.00,'2022-04-30 11:46:22','',''),(2623882,'1','180','934',414,'Retail Sale Id 1618842',3698.50,0.00,0.00,5.69,273.12,'2022-04-30 11:54:17','',''),(2623883,'1','180','934',414,'Retail Sale Id 1618843',1300.00,0.00,0.00,2.00,96.00,'2022-04-30 11:55:28','',''),(2623884,'1','180','934',414,'Retail Sale Id 1618844',8125.00,0.00,0.00,12.50,600.00,'2022-04-30 11:56:54','',''),(2623885,'1','180','934',414,'Retail Sale Id 1618845',3900.00,0.00,0.00,6.00,288.00,'2022-04-30 11:57:38','',''),(2623886,'1','180','934',414,'Retail Sale Id 1618846',3900.00,0.00,0.00,6.00,288.00,'2022-04-30 11:58:15','',''),(2623887,'1','180','934',414,'Retail Sale Id 1618847',3900.00,0.00,0.00,6.00,288.00,'2022-04-30 11:59:02','',''),(2623888,'1','180','934',414,'Retail Sale Id 1618848',3250.00,0.00,0.00,5.00,240.00,'2022-04-30 11:59:40','',''),(2623889,'1','180','934',414,'Retail Sale Id 1618849',1800.50,0.00,0.00,2.77,132.96,'2022-04-30 12:00:28','',''),(2623890,'1','180','934',414,'Retail Sale Id 1618850',3900.00,0.00,0.00,6.00,288.00,'2022-04-30 12:01:09','',''),(2623891,'1','180','934',414,'Retail Sale Id 1618851',7800.00,0.00,0.00,12.00,576.00,'2022-04-30 12:02:09','',''),(2623892,'1','180','934',414,'Retail Sale Id 1618852',3497.00,0.00,0.00,5.38,258.24,'2022-04-30 12:02:56','',''),(2623893,'1','180','934',414,'Retail Sale Id 1618853',1950.00,0.00,0.00,3.00,144.00,'2022-04-30 12:03:42','',''),(2623894,'1','180','934',414,'Retail Sale Id 1618854',1950.00,0.00,0.00,3.00,144.00,'2022-04-30 12:04:18','',''),(2623895,'1','180','934',414,'Retail Sale Id 1618855',1001.00,0.00,0.00,1.54,73.92,'2022-04-30 12:05:00','',''),(2623896,'1','180','934',414,'Retail Sale Id 1618856',1501.50,0.00,0.00,2.31,110.88,'2022-04-30 12:05:46','',''),(2623897,'1','180','934',414,'Retail Sale Id 1618857',111600.00,0.00,0.00,180.00,3240.00,'2022-04-30 12:06:57','',''),(2623898,'1','180','934',414,'Retail Sale Id 1618858',3900.00,0.00,0.00,6.00,288.00,'2022-04-30 14:37:50','',''),(2623899,'1','180','934',414,'Retail Sale Id 1618859',3900.00,0.00,0.00,6.00,288.00,'2022-04-30 14:38:39','',''),(2623900,'1','180','934',414,'Retail Sale Id 1618860',3250.00,0.00,0.00,5.00,240.00,'2022-04-30 14:39:53','',''),(2623901,'1','180','934',414,'Retail Sale Id 1618861',1950.00,0.00,0.00,3.00,144.00,'2022-04-30 14:40:36','',''),(2623902,'1','180','934',414,'Retail Sale Id 1618862',2600.00,0.00,0.00,4.00,192.00,'2022-04-30 14:41:24','',''),(2623903,'1','180','934',414,'Retail Sale Id 1618863',2002.00,0.00,0.00,3.08,147.84,'2022-04-30 14:42:06','',''),(2623904,'1','180','934',414,'Retail Sale Id 1618864',598.00,0.00,0.00,0.92,44.16,'2022-04-30 14:43:03','',''),(2623905,'1','180','934',414,'Retail Sale Id 1618865',1800.50,0.00,0.00,2.77,132.96,'2022-04-30 14:43:56','',''),(2623906,'1','180','934',414,'Retail Sale Id 1618866',1001.00,0.00,0.00,1.54,73.92,'2022-04-30 14:44:40','',''),(2623907,'1','180','934',414,'Retail Sale Id 1618867',3997.50,0.00,0.00,6.15,295.20,'2022-04-30 16:14:49','',''),(2623908,'1','180','934',414,'Retail Sale Id 1618868',5200.00,0.00,0.00,8.00,384.00,'2022-04-30 16:46:28','',''),(2623909,'1','180','934',414,'Retail Sale Id 1618869',16250.00,0.00,0.00,25.00,1200.00,'2022-04-30 16:53:34','',''),(2623910,'1','180','934',414,'Retail Sale Id 1618870',3003.00,0.00,0.00,4.62,221.76,'2022-04-30 16:54:21','',''),(2623911,'1','180','934',414,'Retail Sale Id 1618871',3003.00,0.00,0.00,4.62,221.76,'2022-04-30 16:54:55','',''),(2623912,'1','180','934',414,'Retail Sale Id 1618872',2002.00,0.00,0.00,3.08,147.84,'2022-04-30 19:33:47','',''),(2623913,'1','180','934',414,'Retail Sale Id 1618873',2502.50,0.00,0.00,3.85,184.80,'2022-04-30 19:35:59','',''),(2623914,'1','180','934',414,'Retail Sale Id 1618874',3900.00,0.00,0.00,6.00,288.00,'2022-05-01 09:23:51','',''),(2623915,'1','180','934',414,'Retail Sale Id 1618875',3900.00,0.00,0.00,6.00,288.00,'2022-05-01 09:24:35','',''),(2623916,'1','180','934',414,'Retail Sale Id 1618876',8125.00,0.00,0.00,12.50,600.00,'2022-05-01 12:25:38','',''),(2623917,'1','180','934',414,'Retail Sale Id 1618877',3250.00,0.00,0.00,5.00,240.00,'2022-05-01 12:26:29','',''),(2623918,'1','180','934',414,'Retail Sale Id 1618878',3250.00,0.00,0.00,5.00,240.00,'2022-05-01 12:27:03','',''),(2623919,'1','180','934',414,'Retail Sale Id 1618879',3900.00,0.00,0.00,6.00,288.00,'2022-05-01 12:27:42','',''),(2623920,'1','180','934',414,'Retail Sale Id 1618880',5850.00,0.00,0.00,9.00,432.00,'2022-05-01 12:28:18','',''),(2623921,'1','180','934',414,'Retail Sale Id 1618881',3900.00,0.00,0.00,6.00,288.00,'2022-05-01 14:30:51','',''),(2623922,'1','180','934',414,'Retail Sale Id 1618882',3003.00,0.00,0.00,4.62,221.76,'2022-05-01 14:34:53','',''),(2623923,'1','180','934',414,'Retail Sale Id 1618883',3250.00,0.00,0.00,5.00,240.00,'2022-05-01 16:31:48','',''),(2623924,'1','180','934',414,'Retail Sale Id 1618884',2600.00,0.00,0.00,4.00,192.00,'2022-05-01 16:32:30','',''),(2623925,'1','180','934',414,'Retail Sale Id 1618885',1950.00,0.00,0.00,3.00,144.00,'2022-05-01 16:33:21','',''),(2623926,'1','180','934',414,'Retail Sale Id 1618886',1300.00,0.00,0.00,2.00,96.00,'2022-05-01 16:34:01','',''),(2623927,'1','180','934',414,'Retail Sale Id 1618887',2002.00,0.00,0.00,3.08,147.84,'2022-05-01 16:34:40','',''),(2623928,'1','180','934',414,'Retail Sale Id 1618888',1950.00,0.00,0.00,3.00,144.00,'2022-05-01 16:46:28','',''),(2623929,'1','180','934',414,'Retail Sale Id 1618889',2002.00,0.00,0.00,3.08,147.84,'2022-05-01 16:47:06','',''),(2623930,'1','180','934',414,'Retail Sale Id 1618890',1950.00,0.00,0.00,3.00,144.00,'2022-05-01 17:48:13','',''),(2623931,'1','180','934',414,'Retail Sale Id 1618891',1950.00,0.00,0.00,3.00,144.00,'2022-05-01 17:49:23','',''),(2623932,'1','180','934',414,'Retail Sale Id 1618892',3003.00,0.00,0.00,4.62,221.76,'2022-05-01 17:50:17','',''),(2623933,'1','180','934',414,'Retail Sale Id 1618893',3997.50,0.00,0.00,6.15,295.20,'2022-05-01 17:51:09','',''),(2623934,'1','180','934',414,'Retail Sale Id 1618894',3152.50,0.00,0.00,4.85,232.80,'2022-05-01 17:52:07','',''),(2623935,'1','180','934',414,'Retail Sale Id 1618895',3900.00,0.00,0.00,6.00,288.00,'2022-05-01 17:56:02','',''),(2623936,'1','180','934',414,'Retail Sale Id 1618896',8125.00,0.00,0.00,12.50,600.00,'2022-05-01 17:56:46','',''),(2623937,'1','180','934',414,'Retail Sale Id 1618897',8125.00,0.00,0.00,12.50,600.00,'2022-05-01 18:22:48','',''),(2623938,'1','180','934',414,'Retail Sale Id 1618898',3900.00,0.00,0.00,6.00,288.00,'2022-05-01 18:23:49','',''),(2623939,'1','180','934',414,'Retail Sale Id 1618899',1300.00,0.00,0.00,2.00,96.00,'2022-05-01 18:24:41','',''),(2623940,'1','180','934',414,'Retail Sale Id 1618900',2002.00,0.00,0.00,3.08,147.84,'2022-05-01 20:42:48','',''),(2623941,'1','180','934',414,'Retail Sale Id 1618901',3900.00,0.00,0.00,6.00,288.00,'2022-05-02 10:45:48','',''),(2623942,'1','180','934',414,'Retail Sale Id 1618902',3900.00,0.00,0.00,6.00,288.00,'2022-05-02 10:46:34','',''),(2623943,'1','180','934',414,'Retail Sale Id 1618903',6500.00,0.00,0.00,10.00,480.00,'2022-05-02 11:55:06','',''),(2623944,'1','180','934',414,'Retail Sale Id 1618904',1950.00,0.00,0.00,3.00,144.00,'2022-05-02 11:56:03','',''),(2623945,'1','180','934',414,'Retail Sale Id 1618905',3900.00,0.00,0.00,6.00,288.00,'2022-05-02 17:59:03','',''),(2623946,'1','180','934',414,'Retail Sale Id 1618906',1950.00,0.00,0.00,3.00,144.00,'2022-05-02 18:00:12','',''),(2623947,'1','180','934',414,'Retail Sale Id 1618907',3003.00,0.00,0.00,4.62,221.76,'2022-05-03 10:20:51','',''),(2623948,'1','180','934',414,'Retail Sale Id 1618908',2002.00,0.00,0.00,3.08,147.84,'2022-05-03 10:21:37','',''),(2623949,'1','180','934',414,'Retail Sale Id 1618909',2002.00,0.00,0.00,3.08,147.84,'2022-05-03 10:22:36','',''),(2623950,'1','180','934',414,'Retail Sale Id 1618910',1898.00,0.00,0.00,2.92,140.16,'2022-05-03 10:23:41','',''),(2623951,'1','180','934',414,'Retail Sale Id 1618911',3802.50,0.00,0.00,5.85,280.80,'2022-05-03 10:24:21','',''),(2623952,'1','180','934',414,'Retail Sale Id 1618912',1950.00,0.00,0.00,3.00,144.00,'2022-05-03 10:24:57','',''),(2623953,'1','180','934',414,'Retail Sale Id 1618913',4998.50,0.00,0.00,7.69,369.12,'2022-05-03 10:27:38','',''),(2623954,'1','180','934',414,'Retail Sale Id 1618914',1950.00,0.00,0.00,3.00,144.00,'2022-05-03 10:29:53','',''),(2623955,'1','180','934',414,'Retail Sale Id 1618915',2002.00,0.00,0.00,3.08,147.84,'2022-05-03 12:30:11','',''),(2623956,'1','180','934',414,'Retail Sale Id 1618916',3997.50,0.00,0.00,6.15,295.20,'2022-05-03 12:30:50','',''),(2623957,'1','180','934',414,'Retail Sale Id 1618917',2002.00,0.00,0.00,3.08,147.84,'2022-05-03 12:31:46','',''),(2623958,'1','180','934',414,'Retail Sale Id 1618918',3900.00,0.00,0.00,6.00,288.00,'2022-05-04 09:32:28','',''),(2623959,'1','180','934',414,'Retail Sale Id 1618919',3900.00,0.00,0.00,6.00,288.00,'2022-05-04 11:45:58','',''),(2623960,'1','180','934',414,'Retail Sale Id 1618920',3900.00,0.00,0.00,6.00,288.00,'2022-05-04 11:46:49','',''),(2623961,'1','180','934',414,'Retail Sale Id 1618921',3900.00,0.00,0.00,6.00,288.00,'2022-05-04 12:40:27','',''),(2623962,'1','180','934',414,'Retail Sale Id 1618922',2600.00,0.00,0.00,4.00,192.00,'2022-05-04 12:41:00','',''),(2623963,'1','180','934',414,'Retail Sale Id 1618923',1950.00,0.00,0.00,3.00,144.00,'2022-05-04 12:41:35','',''),(2623964,'1','180','934',414,'Retail Sale Id 1618924',3003.00,0.00,0.00,4.62,221.76,'2022-05-04 12:42:12','',''),(2623965,'1','180','934',414,'Retail Sale Id 1618925',1950.00,0.00,0.00,3.00,144.00,'2022-05-04 12:53:35','',''),(2623966,'1','180','934',414,'Retail Sale Id 1618926',2600.00,0.00,0.00,4.00,192.00,'2022-05-04 13:05:50','',''),(2623967,'1','180','934',414,'Retail Sale Id 1618927',3900.00,0.00,0.00,6.00,288.00,'2022-05-04 13:14:17','',''),(2623968,'1','180','934',414,'Retail Sale Id 1618928',1703.00,0.00,0.00,2.62,125.76,'2022-05-04 13:15:08','',''),(2623969,'1','180','934',414,'Retail Sale Id 1618929',31000.00,0.00,0.00,50.00,900.00,'2022-05-04 13:58:13','',''),(2623970,'1','180','934',414,'Retail Sale Id 1618930',3250.00,0.00,0.00,5.00,240.00,'2022-05-04 17:29:44','',''),(2623971,'1','180','934',414,'Retail Sale Id 1618931',1950.00,0.00,0.00,3.00,144.00,'2022-05-04 17:30:15','',''),(2623972,'1','180','934',414,'Retail Sale Id 1618932',1950.00,0.00,0.00,3.00,144.00,'2022-05-04 17:30:58','',''),(2623973,'1','180','934',414,'Retail Sale Id 1618933',799.50,0.00,0.00,1.23,59.04,'2022-05-04 17:31:45','',''),(2623974,'1','180','934',414,'Retail Sale Id 1618934',3900.00,0.00,0.00,6.00,288.00,'2022-05-05 10:58:15','',''),(2623975,'1','180','934',414,'Retail Sale Id 1618935',3250.00,0.00,0.00,5.00,240.00,'2022-05-05 10:59:09','',''),(2623976,'1','180','934',414,'Retail Sale Id 1618936',2600.00,0.00,0.00,4.00,192.00,'2022-05-05 12:00:16','',''),(2623977,'1','180','934',414,'Retail Sale Id 1618937',8125.00,0.00,0.00,12.50,600.00,'2022-05-05 12:01:02','',''),(2623978,'1','180','934',414,'Retail Sale Id 1618938',8125.00,0.00,0.00,12.50,600.00,'2022-05-05 12:01:46','',''),(2623979,'1','180','934',414,'Retail Sale Id 1618939',2002.00,0.00,0.00,3.08,147.84,'2022-05-05 12:07:58','',''),(2623980,'1','180','934',414,'Retail Sale Id 1618940',3900.00,0.00,0.00,6.00,288.00,'2022-05-05 14:13:53','',''),(2623981,'1','180','934',414,'Retail Sale Id 1618941',2002.00,0.00,0.00,3.08,147.84,'2022-05-05 14:14:46','',''),(2623982,'1','180','934',414,'Retail Sale Id 1618942',5200.00,0.00,0.00,8.00,384.00,'2022-05-05 16:49:03','',''),(2623983,'1','180','934',414,'Retail Sale Id 1618943',1950.00,0.00,0.00,3.00,144.00,'2022-05-05 16:49:54','',''),(2623984,'1','180','934',414,'Retail Sale Id 1618944',3900.00,0.00,0.00,6.00,288.00,'2022-05-05 18:20:18','',''),(2623985,'1','180','934',414,'Retail Sale Id 1618945',1950.00,0.00,0.00,3.00,144.00,'2022-05-05 18:20:56','',''),(2623986,'1','180','934',414,'Retail Sale Id 1618946',2197.00,0.00,0.00,3.38,162.24,'2022-05-05 18:21:40','',''),(2623987,'1','180','934',414,'Retail Sale Id 1618947',1501.50,0.00,0.00,2.31,110.88,'2022-05-05 18:22:59','',''),(2623988,'1','180','934',414,'Retail Sale Id 1618948',2197.00,0.00,0.00,3.38,162.24,'2022-05-05 18:30:00','',''),(2623989,'1','180','934',414,'Retail Sale Id 1618949',1001.00,0.00,0.00,1.54,73.92,'2022-05-06 08:40:30','',''),(2623990,'1','180','934',414,'Retail Sale Id 1618950',4998.50,0.00,0.00,7.69,369.12,'2022-05-06 12:19:31','',''),(2623991,'1','180','934',414,'Retail Sale Id 1618951',4998.50,0.00,0.00,7.69,369.12,'2022-05-06 12:20:12','',''),(2623992,'1','180','934',414,'Retail Sale Id 1618952',1950.00,0.00,0.00,3.00,144.00,'2022-05-06 12:53:05','',''),(2623993,'1','180','934',414,'Retail Sale Id 1618953',1950.00,0.00,0.00,3.00,144.00,'2022-05-06 12:53:45','',''),(2623994,'1','180','934',414,'Retail Sale Id 1618954',1950.00,0.00,0.00,3.00,144.00,'2022-05-06 12:54:21','',''),(2623995,'1','180','934',414,'Retail Sale Id 1618955',1950.00,0.00,0.00,3.00,144.00,'2022-05-06 12:54:56','',''),(2623996,'1','180','934',414,'Retail Sale Id 1618956',1300.00,0.00,0.00,2.00,96.00,'2022-05-06 12:55:37','',''),(2623997,'1','180','934',414,'Retail Sale Id 1618957',2002.00,0.00,0.00,3.08,147.84,'2022-05-06 12:56:14','',''),(2623998,'1','180','934',414,'Retail Sale Id 1618958',1001.00,0.00,0.00,1.54,73.92,'2022-05-06 12:56:58','',''),(2623999,'1','180','934',414,'Retail Sale Id 1618959',37200.00,0.00,0.00,60.00,1080.00,'2022-05-06 21:22:24','',''),(2624000,'1','180','934',414,'Retail Sale Id 1618960',3250.00,0.00,0.00,5.00,240.00,'2022-05-06 21:25:30','',''),(2624001,'1','180','934',414,'Retail Sale Id 1618961',3250.00,0.00,0.00,5.00,240.00,'2022-05-06 21:26:08','',''),(2624002,'1','180','934',414,'Retail Sale Id 1618962',2600.00,0.00,0.00,4.00,192.00,'2022-05-06 21:26:50','',''),(2624003,'1','180','934',414,'Retail Sale Id 1618963',3250.00,0.00,0.00,5.00,240.00,'2022-05-07 09:04:33','',''),(2624004,'1','180','934',414,'Retail Sale Id 1618964',3900.00,0.00,0.00,6.00,288.00,'2022-05-07 11:22:41','',''),(2624005,'1','180','934',414,'Retail Sale Id 1618965',3900.00,0.00,0.00,6.00,288.00,'2022-05-07 11:23:30','',''),(2624006,'1','180','934',414,'Retail Sale Id 1618966',1950.00,0.00,0.00,3.00,144.00,'2022-05-07 11:24:26','',''),(2624007,'1','180','934',414,'Retail Sale Id 1618967',3900.00,0.00,0.00,6.00,288.00,'2022-05-07 14:38:11','',''),(2624008,'1','180','934',414,'Retail Sale Id 1618968',3900.00,0.00,0.00,6.00,288.00,'2022-05-07 14:38:47','',''),(2624009,'1','180','934',414,'Retail Sale Id 1618969',1950.00,0.00,0.00,3.00,144.00,'2022-05-07 14:39:21','',''),(2624010,'1','180','934',414,'Retail Sale Id 1618970',2002.00,0.00,0.00,3.08,147.84,'2022-05-07 21:32:07','',''),(2624011,'1','180','934',414,'Retail Sale Id 1618971',3003.00,0.00,0.00,4.62,221.76,'2022-05-07 21:32:49','',''),(2624012,'1','180','934',414,'Retail Sale Id 1618972',3900.00,0.00,0.00,6.00,288.00,'2022-05-07 21:33:48','',''),(2624013,'1','180','934',414,'Retail Sale Id 1618973',8125.00,0.00,0.00,12.50,600.00,'2022-05-07 21:34:42','',''),(2624014,'1','180','934',414,'Retail Sale Id 1618974',3900.00,0.00,0.00,6.00,288.00,'2022-05-08 08:03:05','',''),(2624015,'1','180','934',414,'Retail Sale Id 1618975',3250.00,0.00,0.00,5.00,240.00,'2022-05-08 18:08:13','',''),(2624016,'1','180','934',414,'Retail Sale Id 1618977',3900.00,0.00,0.00,6.00,288.00,'2022-05-08 18:08:58','',''),(2624017,'1','180','934',414,'Retail Sale Id 1618978',124000.00,0.00,0.00,200.00,3600.00,'2022-05-08 18:09:41','',''),(2624018,'1','180','934',414,'Retail Sale Id 1618979',3250.00,0.00,0.00,5.00,240.00,'2022-05-08 18:11:10','',''),(2624019,'1','180','934',414,'Retail Sale Id 1618980',3900.00,0.00,0.00,6.00,288.00,'2022-05-09 09:00:38','',''),(2624020,'1','180','934',414,'Retail Sale Id 1618981',4998.50,0.00,0.00,7.69,369.12,'2022-05-09 09:01:14','',''),(2624021,'1','180','934',414,'Retail Sale Id 1618982',3497.00,0.00,0.00,5.38,258.24,'2022-05-09 09:01:53','',''),(2624022,'1','180','934',414,'Retail Sale Id 1618983',1001.00,0.00,0.00,1.54,73.92,'2022-05-09 09:02:39','',''),(2624023,'1','180','934',414,'Retail Sale Id 1618984',3198.00,0.00,0.00,4.92,236.16,'2022-05-09 09:04:32','',''),(2624024,'1','180','934',414,'Retail Sale Id 1618985',1898.00,0.00,0.00,2.92,140.16,'2022-05-09 09:05:09','',''),(2624025,'1','180','934',414,'Retail Sale Id 1618986',7800.00,0.00,0.00,12.00,576.00,'2022-05-09 11:40:35','',''),(2624026,'1','180','934',414,'Retail Sale Id 1618987',3003.00,0.00,0.00,4.62,221.76,'2022-05-09 11:41:47','',''),(2624027,'1','180','934',414,'Retail Sale Id 1618988',4998.50,0.00,0.00,7.69,369.12,'2022-05-09 11:42:56','',''),(2624028,'1','180','934',414,'Retail Sale Id 1618989',8125.00,0.00,0.00,12.50,600.00,'2022-05-09 11:44:14','',''),(2624029,'1','180','934',414,'Retail Sale Id 1618990',8125.00,0.00,0.00,12.50,600.00,'2022-05-09 11:46:09','',''),(2624030,'1','180','934',414,'Retail Sale Id 1618991',7800.00,0.00,0.00,12.00,576.00,'2022-05-09 11:46:52','',''),(2624031,'1','180','934',414,'Retail Sale Id 1618992',5850.00,0.00,0.00,9.00,432.00,'2022-05-09 11:47:58','',''),(2624032,'1','180','934',414,'Retail Sale Id 1618993',5850.00,0.00,0.00,9.00,432.00,'2022-05-09 11:48:48','',''),(2624033,'1','180','934',414,'Retail Sale Id 1618994',4550.00,0.00,0.00,7.00,336.00,'2022-05-09 11:49:51','',''),(2624034,'1','180','934',414,'Retail Sale Id 1618995',8125.00,0.00,0.00,12.50,600.00,'2022-05-09 19:53:06','',''),(2624035,'1','180','934',414,'Retail Sale Id 1618996',1703.00,0.00,0.00,2.62,125.76,'2022-05-09 19:53:52','',''),(2624036,'1','180','934',414,'Retail Sale Id 1618997',1898.00,0.00,0.00,2.92,140.16,'2022-05-09 19:55:22','',''),(2624037,'1','180','934',414,'Retail Sale Id 1618998',1001.00,0.00,0.00,1.54,73.92,'2022-05-09 19:56:18','',''),(2624038,'1','180','934',414,'Retail Sale Id 1618999',5200.00,0.00,0.00,8.00,384.00,'2022-05-09 19:57:00','',''),(2624039,'1','180','934',414,'Retail Sale Id 1619000',4998.50,0.00,0.00,7.69,369.12,'2022-05-09 19:58:35','',''),(2624040,'1','180','934',414,'Retail Sale Id 1619001',5590.00,0.00,0.00,8.60,412.80,'2022-05-09 19:59:51','',''),(2624041,'1','180','934',414,'Retail Sale Id 1619002',2502.50,0.00,0.00,3.85,184.80,'2022-05-09 20:00:56','',''),(2624042,'1','180','934',414,'Retail Sale Id 1619003',3900.00,0.00,0.00,6.00,288.00,'2022-05-09 20:01:51','',''),(2624043,'1','180','934',414,'Retail Sale Id 1619004',8125.00,0.00,0.00,12.50,600.00,'2022-05-09 20:02:56','',''),(2624044,'1','180','934',414,'Retail Sale Id 1619005',3250.00,0.00,0.00,5.00,240.00,'2022-05-09 20:04:21','',''),(2624045,'1','180','934',414,'Retail Sale Id 1619006',3250.00,0.00,0.00,5.00,240.00,'2022-05-09 20:05:11','',''),(2624046,'1','180','934',414,'Retail Sale Id 1619007',2002.00,0.00,0.00,3.08,147.84,'2022-05-09 20:05:45','',''),(2624047,'1','180','934',414,'Retail Sale Id 1619008',1001.00,0.00,0.00,1.54,73.92,'2022-05-09 20:06:36','',''),(2624048,'1','180','934',414,'Retail Sale Id 1619009',31000.00,0.00,0.00,50.00,900.00,'2022-05-09 20:07:48','',''),(2624049,'1','180','934',414,'Retail Sale Id 1619010',8125.00,0.00,0.00,12.50,600.00,'2022-05-10 08:29:23','',''),(2624050,'1','180','934',414,'Retail Sale Id 1619011',8125.00,0.00,0.00,12.50,600.00,'2022-05-10 09:51:11','',''),(2624051,'1','180','934',414,'Retail Sale Id 1619012',5850.00,0.00,0.00,9.00,432.00,'2022-05-10 12:53:09','',''),(2624052,'1','180','934',414,'Retail Sale Id 1619013',3250.00,0.00,0.00,5.00,240.00,'2022-05-10 16:57:05','',''),(2624053,'1','180','934',414,'Retail Sale Id 1619014',2002.00,0.00,0.00,3.08,147.84,'2022-05-10 16:57:53','',''),(2624054,'1','180','934',414,'Retail Sale Id 1619015',2002.00,0.00,0.00,3.08,147.84,'2022-05-10 16:58:43','',''),(2624055,'1','180','934',414,'Retail Sale Id 1619016',3900.00,0.00,0.00,6.00,288.00,'2022-05-10 16:59:24','',''),(2624056,'1','180','934',414,'Retail Sale Id 1619017',3003.00,0.00,0.00,4.62,221.76,'2022-05-10 17:00:11','',''),(2624057,'1','180','934',414,'Retail Sale Id 1619018',1001.00,0.00,0.00,1.54,73.92,'2022-05-10 17:00:55','',''),(2624058,'1','180','934',414,'Retail Sale Id 1619019',8125.00,0.00,0.00,12.50,600.00,'2022-05-10 17:01:46','',''),(2624059,'1','180','934',414,'Retail Sale Id 1619020',8125.00,0.00,0.00,12.50,600.00,'2022-05-10 17:02:27','',''),(2624060,'1','180','934',414,'Retail Sale Id 1619021',1950.00,0.00,0.00,3.00,144.00,'2022-05-10 17:04:36','',''),(2624061,'1','180','934',414,'Retail Sale Id 1619022',3250.00,0.00,0.00,5.00,240.00,'2022-05-10 18:30:14','',''),(2624062,'1','180','934',414,'Retail Sale Id 1619023',3497.00,0.00,0.00,5.38,258.24,'2022-05-10 18:31:20','',''),(2624063,'1','180','934',414,'Retail Sale Id 1619024',31000.00,0.00,0.00,50.00,900.00,'2022-05-10 19:35:39','',''),(2624064,'1','180','934',414,'Retail Sale Id 1619025',3250.00,0.00,0.00,5.00,240.00,'2022-05-11 10:26:57','',''),(2624065,'1','180','934',414,'Retail Sale Id 1619026',3250.00,0.00,0.00,5.00,240.00,'2022-05-11 10:27:40','',''),(2624066,'1','180','934',414,'Retail Sale Id 1619027',1300.00,0.00,0.00,2.00,96.00,'2022-05-11 10:28:26','',''),(2624067,'1','180','934',414,'Retail Sale Id 1619028',2002.00,0.00,0.00,3.08,147.84,'2022-05-11 10:29:10','',''),(2624068,'1','180','934',414,'Retail Sale Id 1619029',3250.00,0.00,0.00,5.00,240.00,'2022-05-11 15:14:52','',''),(2624069,'1','180','934',414,'Retail Sale Id 1619030',3900.00,0.00,0.00,6.00,288.00,'2022-05-11 15:15:46','',''),(2624070,'1','180','934',414,'Retail Sale Id 1619031',2697.50,0.00,0.00,4.15,199.20,'2022-05-11 15:16:22','',''),(2624071,'1','180','934',414,'Retail Sale Id 1619032',111600.00,0.00,0.00,180.00,3240.00,'2022-05-11 15:16:58','',''),(2624072,'1','180','934',414,'Retail Sale Id 1619033',8125.00,0.00,0.00,12.50,600.00,'2022-05-11 18:09:59','',''),(2624073,'1','180','934',414,'Retail Sale Id 1619034',3003.00,0.00,0.00,4.62,221.76,'2022-05-11 18:10:40','',''),(2624074,'1','180','934',414,'Retail Sale Id 1619035',3997.50,0.00,0.00,6.15,295.20,'2022-05-11 18:49:41','',''),(2624075,'1','180','934',414,'Retail Sale Id 1619036',650.00,0.00,0.00,1.00,48.00,'2022-05-11 19:29:03','',''),(2624076,'1','180','934',414,'Retail Sale Id 1619037',1501.50,0.00,0.00,2.31,110.88,'2022-05-11 19:30:22','',''),(2624077,'1','180','934',414,'Retail Sale Id 1619038',8125.00,0.00,0.00,12.50,600.00,'2022-05-12 10:01:03','',''),(2624078,'1','180','934',414,'Retail Sale Id 1619039',3900.00,0.00,0.00,6.00,288.00,'2022-05-12 10:01:38','',''),(2624079,'1','180','934',414,'Retail Sale Id 1619040',3900.00,0.00,0.00,6.00,288.00,'2022-05-12 10:02:17','',''),(2624080,'1','180','934',414,'Retail Sale Id 1619041',1950.00,0.00,0.00,3.00,144.00,'2022-05-12 10:02:55','',''),(2624081,'1','180','934',414,'Retail Sale Id 1619042',8125.00,0.00,0.00,12.50,600.00,'2022-05-12 10:16:38','',''),(2624082,'1','180','934',414,'Retail Sale Id 1619043',3250.00,0.00,0.00,5.00,240.00,'2022-05-12 10:24:51','',''),(2624083,'1','180','934',414,'Retail Sale Id 1619044',1950.00,0.00,0.00,3.00,144.00,'2022-05-12 10:26:51','',''),(2624084,'1','180','934',414,'Retail Sale Id 1619045',4550.00,0.00,0.00,7.00,336.00,'2022-05-12 10:44:08','',''),(2624085,'1','180','934',414,'Retail Sale Id 1619046',2002.00,0.00,0.00,3.08,147.84,'2022-05-12 12:08:31','',''),(2624086,'1','180','934',414,'Retail Sale Id 1619047',1950.00,0.00,0.00,3.00,144.00,'2022-05-12 12:09:13','',''),(2624087,'1','180','934',414,'Retail Sale Id 1619048',8125.00,0.00,0.00,12.50,600.00,'2022-05-12 12:09:49','',''),(2624088,'1','180','934',414,'Retail Sale Id 1619049',4498.00,0.00,0.00,6.92,332.16,'2022-05-12 13:50:38','',''),(2624089,'1','180','934',414,'Retail Sale Id 1619050',7501.00,0.00,0.00,11.54,553.92,'2022-05-12 18:32:28','',''),(2624090,'1','180','934',414,'Retail Sale Id 1619051',8125.00,0.00,0.00,12.50,600.00,'2022-05-12 18:34:11','',''),(2624091,'1','180','934',414,'Retail Sale Id 1619052',2002.00,0.00,0.00,3.08,147.84,'2022-05-12 18:35:30','',''),(2624092,'1','180','934',414,'Retail Sale Id 1619053',1950.00,0.00,0.00,3.00,144.00,'2022-05-12 18:36:01','',''),(2624093,'1','180','934',414,'Retail Sale Id 1619054',31000.00,0.00,0.00,50.00,900.00,'2022-05-13 10:38:36','',''),(2624094,'1','180','934',414,'Retail Sale Id 1619055',3900.00,0.00,0.00,6.00,288.00,'2022-05-13 10:39:49','',''),(2624095,'1','180','934',414,'Retail Sale Id 1619056',3250.00,0.00,0.00,5.00,240.00,'2022-05-13 19:41:03','',''),(2624096,'1','180','934',414,'Retail Sale Id 1619057',3250.00,0.00,0.00,5.00,240.00,'2022-05-13 19:41:50','',''),(2624097,'1','180','934',414,'Retail Sale Id 1619058',2002.00,0.00,0.00,3.08,147.84,'2022-05-13 19:43:00','',''),(2624098,'1','180','934',414,'Retail Sale Id 1619059',3900.00,0.00,0.00,6.00,288.00,'2022-05-13 19:44:21','',''),(2624099,'1','180','934',414,'Retail Sale Id 1619060',4550.00,0.00,0.00,7.00,336.00,'2022-05-13 19:45:31','',''),(2624100,'1','180','934',414,'Retail Sale Id 1619061',7800.00,0.00,0.00,12.00,576.00,'2022-05-13 19:46:30','',''),(2624101,'1','180','934',414,'Retail Sale Id 1619062',3250.00,0.00,0.00,5.00,240.00,'2022-05-13 19:47:28','',''),(2624102,'1','180','934',414,'Retail Sale Id 1619063',702.00,0.00,0.00,1.08,51.84,'2022-05-13 19:48:48','',''),(2624103,'1','180','934',414,'Retail Sale Id 1619064',2002.00,0.00,0.00,3.08,147.84,'2022-05-14 09:57:08','',''),(2624104,'1','180','934',414,'Retail Sale Id 1619065',2002.00,0.00,0.00,3.08,147.84,'2022-05-14 09:59:04','',''),(2624105,'1','180','934',414,'Retail Sale Id 1619066',74400.00,0.00,0.00,120.00,2160.00,'2022-05-14 10:00:01','',''),(2624106,'1','180','934',414,'Retail Sale Id 1619067',3900.00,0.00,0.00,6.00,288.00,'2022-05-14 10:40:11','',''),(2624107,'1','180','934',414,'Retail Sale Id 1619068',1950.00,0.00,0.00,3.00,144.00,'2022-05-14 10:40:58','',''),(2624108,'1','180','934',414,'Retail Sale Id 1619069',8125.00,0.00,0.00,12.50,600.00,'2022-05-14 16:28:43','',''),(2624109,'1','180','934',414,'Retail Sale Id 1619070',3250.00,0.00,0.00,5.00,240.00,'2022-05-14 16:29:23','',''),(2624110,'1','180','934',414,'Retail Sale Id 1619071',3250.00,0.00,0.00,5.00,240.00,'2022-05-14 16:30:07','',''),(2624111,'1','180','934',414,'Retail Sale Id 1619072',3802.50,0.00,0.00,5.85,280.80,'2022-05-14 16:32:19','',''),(2624112,'1','180','934',414,'Retail Sale Id 1619073',3250.00,0.00,0.00,5.00,240.00,'2022-05-14 16:33:43','',''),(2624113,'1','180','934',414,'Retail Sale Id 1619075',3003.00,0.00,0.00,4.62,221.76,'2022-05-14 21:09:58','',''),(2624114,'1','180','934',414,'Retail Sale Id 1619076',3900.00,0.00,0.00,6.00,288.00,'2022-05-14 21:11:39','',''),(2624115,'1','180','934',414,'Retail Sale Id 1619077',6500.00,0.00,0.00,10.00,480.00,'2022-05-14 21:12:33','',''),(2624116,'1','180','934',414,'Retail Sale Id 1619078',31000.00,0.00,0.00,50.00,900.00,'2022-05-14 21:13:12','',''),(2624117,'1','180','934',414,'Retail Sale Id 1619079',1997.52,0.00,0.00,2.87,269.78,'2022-05-15 12:33:27','',''),(2624118,'1','180','934',414,'Retail Sale Id 1619080',2088.00,0.00,0.00,3.00,282.00,'2022-05-15 12:34:17','',''),(2624119,'1','180','934',414,'Retail Sale Id 1619081',2088.00,0.00,0.00,3.00,282.00,'2022-05-15 12:35:08','',''),(2624120,'1','180','934',414,'Retail Sale Id 1619082',3480.00,0.00,0.00,5.00,470.00,'2022-05-15 12:36:00','',''),(2624121,'1','180','934',414,'Retail Sale Id 1619083',4872.00,0.00,0.00,7.00,658.00,'2022-05-15 12:38:40','',''),(2624122,'1','180','934',414,'Retail Sale Id 1619084',8352.00,0.00,0.00,12.00,1128.00,'2022-05-15 17:34:37','',''),(2624123,'1','180','934',414,'Retail Sale Id 1619085',4997.28,0.00,0.00,7.18,674.92,'2022-05-15 17:35:29','',''),(2624124,'1','180','934',414,'Retail Sale Id 1619086',4176.00,0.00,0.00,6.00,564.00,'2022-05-15 17:36:30','',''),(2624125,'1','180','934',414,'Retail Sale Id 1619087',1197.12,0.00,0.00,1.72,161.68,'2022-05-15 17:38:03','',''),(2624126,'1','180','934',414,'Retail Sale Id 1619088',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 14:39:27','',''),(2624127,'1','180','934',414,'Retail Sale Id 1619089',8700.00,0.00,0.00,12.50,1175.00,'2022-05-16 14:40:21','',''),(2624128,'1','180','934',414,'Retail Sale Id 1619090',4997.28,0.00,0.00,7.18,674.92,'2022-05-16 22:25:57','',''),(2624129,'1','180','934',414,'Retail Sale Id 1619091',6960.00,0.00,0.00,10.00,940.00,'2022-05-16 22:26:59','',''),(2624130,'1','180','934',414,'Retail Sale Id 1619092',5568.00,0.00,0.00,8.00,752.00,'2022-05-16 22:29:20','',''),(2624131,'1','180','934',414,'Retail Sale Id 1619093',8352.00,0.00,0.00,12.00,1128.00,'2022-05-16 22:30:26','',''),(2624132,'1','180','934',414,'Retail Sale Id 1619094',10440.00,0.00,0.00,15.00,1410.00,'2022-05-16 22:31:34','',''),(2624133,'1','180','934',414,'Retail Sale Id 1619095',4997.28,0.00,0.00,7.18,674.92,'2022-05-16 22:33:25','',''),(2624134,'1','180','934',414,'Retail Sale Id 1619096',4002.00,0.00,0.00,5.75,540.50,'2022-05-16 22:34:38','',''),(2624135,'1','180','934',414,'Retail Sale Id 1619097',2199.36,0.00,0.00,3.16,297.04,'2022-05-16 22:35:40','',''),(2624136,'1','180','934',414,'Retail Sale Id 1619098',7746.48,0.00,0.00,11.13,1046.22,'2022-05-16 22:36:41','',''),(2624137,'1','180','934',414,'Retail Sale Id 1619099',1781.76,0.00,0.00,2.56,240.64,'2022-05-16 22:38:23','',''),(2624138,'1','180','934',414,'Retail Sale Id 1619100',17400.00,0.00,0.00,25.00,2350.00,'2022-05-16 22:39:50','',''),(2624139,'1','180','934',414,'Retail Sale Id 1619101',3500.88,0.00,0.00,5.03,472.82,'2022-05-16 22:40:43','',''),(2624140,'1','180','934',414,'Retail Sale Id 1619102',6264.00,0.00,0.00,9.00,846.00,'2022-05-16 22:41:32','',''),(2624141,'1','180','934',414,'Retail Sale Id 1619103',3702.72,0.00,0.00,5.32,500.08,'2022-05-16 22:42:25','',''),(2624142,'1','180','934',414,'Retail Sale Id 1619104',1698.24,0.00,0.00,2.44,229.36,'2022-05-16 22:43:29','',''),(2624143,'1','180','934',414,'Retail Sale Id 1619105',5999.52,0.00,0.00,8.62,810.28,'2022-05-16 22:44:21','',''),(2624144,'1','180','934',414,'Retail Sale Id 1619106',32600.00,0.00,0.00,50.00,2500.00,'2022-05-16 22:45:07','',''),(2624145,'1','180','934',414,'Retail Sale Id 1619107',4176.00,0.00,0.00,6.00,564.00,'2022-05-17 11:43:58','',''),(2624146,'1','180','934',414,'Retail Sale Id 1619108',4176.00,0.00,0.00,6.00,564.00,'2022-05-17 11:44:33','',''),(2624147,'1','180','934',414,'Retail Sale Id 1619109',3480.00,0.00,0.00,5.00,470.00,'2022-05-17 11:45:08','',''),(2624148,'1','180','934',414,'Retail Sale Id 1619110',3480.00,0.00,0.00,5.00,470.00,'2022-05-17 13:56:14','',''),(2624149,'1','180','934',414,'Retail Sale Id 1619111',3480.00,0.00,0.00,5.00,470.00,'2022-05-17 13:59:24','',''),(2624150,'1','180','934',414,'Retail Sale Id 1619112',4176.00,0.00,0.00,6.00,564.00,'2022-05-17 14:00:22','',''),(2624151,'1','180','934',414,'Retail Sale Id 1619113',4176.00,0.00,0.00,6.00,564.00,'2022-05-17 22:34:42','',''),(2624152,'1','180','934',414,'Retail Sale Id 1619114',5568.00,0.00,0.00,8.00,752.00,'2022-05-17 22:35:14','',''),(2624153,'1','180','934',414,'Retail Sale Id 1619115',3480.00,0.00,0.00,5.00,470.00,'2022-05-17 22:35:47','',''),(2624154,'1','180','934',414,'Retail Sale Id 1619116',6264.00,0.00,0.00,9.00,846.00,'2022-05-17 22:36:31','',''),(2624155,'1','180','934',414,'Retail Sale Id 1619117',4176.00,0.00,0.00,6.00,564.00,'2022-05-18 10:14:44','',''),(2624156,'1','180','934',414,'Retail Sale Id 1619118',1392.00,0.00,0.00,2.00,188.00,'2022-05-18 10:15:17','',''),(2624157,'1','180','934',414,'Retail Sale Id 1619119',3480.00,0.00,0.00,5.00,470.00,'2022-05-18 10:15:57','',''),(2624158,'1','180','934',414,'Retail Sale Id 1619120',2999.76,0.00,0.00,4.31,405.14,'2022-05-18 10:17:33','',''),(2624159,'1','180','934',414,'Retail Sale Id 1619121',3480.00,0.00,0.00,5.00,470.00,'2022-05-18 14:29:49','',''),(2624160,'1','180','934',414,'Retail Sale Id 1619122',3480.00,0.00,0.00,5.00,470.00,'2022-05-18 14:30:25','',''),(2624161,'1','180','934',414,'Retail Sale Id 1619123',3480.00,0.00,0.00,5.00,470.00,'2022-05-18 14:30:58','',''),(2624162,'1','180','934',414,'Retail Sale Id 1619124',3480.00,0.00,0.00,5.00,470.00,'2022-05-18 14:31:38','',''),(2624163,'1','180','934',414,'Retail Sale Id 1619125',3480.00,0.00,0.00,5.00,470.00,'2022-05-18 14:32:12','',''),(2624164,'1','180','934',414,'Retail Sale Id 1619126',7001.76,0.00,0.00,10.06,945.64,'2022-05-18 14:32:52','',''),(2624165,'1','180','934',414,'Retail Sale Id 1619127',4176.00,0.00,0.00,6.00,564.00,'2022-05-18 16:06:19','',''),(2624166,'1','180','934',414,'Retail Sale Id 1619128',2088.00,0.00,0.00,3.00,282.00,'2022-05-18 16:07:00','',''),(2624167,'1','180','934',414,'Retail Sale Id 1619129',1002.24,0.00,0.00,1.44,135.36,'2022-05-18 16:07:55','',''),(2624168,'1','180','934',414,'Retail Sale Id 1619130',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 09:38:50','',''),(2624169,'1','180','934',414,'Retail Sale Id 1619131',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 09:39:34','',''),(2624170,'1','180','934',414,'Retail Sale Id 1619132',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 09:40:28','',''),(2624171,'1','180','934',414,'Retail Sale Id 1619133',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 10:01:38','',''),(2624172,'1','180','934',414,'Retail Sale Id 1619134',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 10:02:16','',''),(2624173,'1','180','934',414,'Retail Sale Id 1619135',1503.36,0.00,0.00,2.16,203.04,'2022-05-19 10:02:54','',''),(2624174,'1','180','934',414,'Retail Sale Id 1619136',39120.00,0.00,0.00,60.00,3000.00,'2022-05-19 10:03:39','',''),(2624175,'1','180','934',414,'Retail Sale Id 1619137',4176.00,0.00,0.00,6.00,564.00,'2022-05-19 10:15:13','',''),(2624176,'1','180','934',414,'Retail Sale Id 1619138',2088.00,0.00,0.00,3.00,282.00,'2022-05-19 11:51:27','',''),(2624177,'1','180','934',414,'Retail Sale Id 1619139',65200.00,0.00,0.00,100.00,5000.00,'2022-05-19 11:52:52','',''),(2624178,'1','180','934',414,'Retail Sale Id 1619140',6960.00,0.00,0.00,10.00,940.00,'2022-05-19 14:08:43','',''),(2624179,'1','180','934',414,'Retail Sale Id 1619141',2498.64,0.00,0.00,3.59,337.46,'2022-05-19 19:59:09','',''),(2624180,'1','180','934',414,'Retail Sale Id 1619142',1997.52,0.00,0.00,2.87,269.78,'2022-05-19 20:00:11','',''),(2624181,'1','180','934',414,'Retail Sale Id 1619143',2999.76,0.00,0.00,4.31,405.14,'2022-05-19 20:00:53','',''),(2624182,'1','180','934',414,'Retail Sale Id 1619144',3480.00,0.00,0.00,5.00,470.00,'2022-05-20 12:49:17','',''),(2624183,'1','180','934',414,'Retail Sale Id 1619145',3480.00,0.00,0.00,5.00,470.00,'2022-05-20 12:50:33','',''),(2624184,'1','180','934',414,'Retail Sale Id 1619146',2784.00,0.00,0.00,4.00,376.00,'2022-05-20 12:51:13','',''),(2624185,'1','180','934',414,'Retail Sale Id 1619147',2088.00,0.00,0.00,3.00,282.00,'2022-05-20 12:52:05','',''),(2624186,'1','180','934',414,'Retail Sale Id 1619148',2797.92,0.00,0.00,4.02,377.88,'2022-05-20 18:56:47','',''),(2624187,'1','180','934',414,'Retail Sale Id 1619149',4176.00,0.00,0.00,6.00,564.00,'2022-05-20 18:57:26','',''),(2624188,'1','180','934',414,'Retail Sale Id 1619150',4002.00,0.00,0.00,5.75,540.50,'2022-05-20 18:58:17','',''),(2624189,'1','180','934',414,'Retail Sale Id 1619151',2088.00,0.00,0.00,3.00,282.00,'2022-05-20 18:58:54','',''),(2624190,'1','180','934',414,'Retail Sale Id 1619152',2088.00,0.00,0.00,3.00,282.00,'2022-05-20 18:59:33','',''),(2624191,'1','180','934',414,'Retail Sale Id 1619153',2088.00,0.00,0.00,3.00,282.00,'2022-05-20 19:39:36','',''),(2624192,'1','180','934',414,'Retail Sale Id 1619154',32600.00,0.00,0.00,50.00,2500.00,'2022-05-20 22:15:05','',''),(2624193,'1','180','934',414,'Retail Sale Id 1619155',3500.88,0.00,0.00,5.03,472.82,'2022-05-21 12:14:16','',''),(2624194,'1','180','934',414,'Retail Sale Id 1619156',4872.00,0.00,0.00,7.00,658.00,'2022-05-21 12:14:53','',''),(2624195,'1','180','934',414,'Retail Sale Id 1619157',4176.00,0.00,0.00,6.00,564.00,'2022-05-21 14:15:53','',''),(2624196,'1','180','934',414,'Retail Sale Id 1619158',2999.76,0.00,0.00,4.31,405.14,'2022-05-21 14:16:29','',''),(2624197,'1','180','934',414,'Retail Sale Id 1619159',2999.76,0.00,0.00,4.31,405.14,'2022-05-21 14:17:06','',''),(2624198,'1','180','934',414,'Retail Sale Id 1619160',2088.00,0.00,0.00,3.00,282.00,'2022-05-21 14:17:40','',''),(2624199,'1','180','934',414,'Retail Sale Id 1619161',8700.00,0.00,0.00,12.50,1175.00,'2022-05-21 14:18:17','',''),(2624200,'1','180','934',414,'Retail Sale Id 1619162',2088.00,0.00,0.00,3.00,282.00,'2022-05-21 14:18:52','',''),(2624201,'1','180','934',414,'Retail Sale Id 1619163',4176.00,0.00,0.00,6.00,564.00,'2022-05-21 14:19:28','',''),(2624202,'1','180','934',414,'Retail Sale Id 1619164',1997.52,0.00,0.00,2.87,269.78,'2022-05-21 14:20:20','',''),(2624203,'1','180','934',414,'Retail Sale Id 1619165',2088.00,0.00,0.00,3.00,282.00,'2022-05-21 14:21:06','',''),(2624204,'1','180','934',414,'Retail Sale Id 1619166',2999.76,0.00,0.00,4.31,405.14,'2022-05-21 14:21:43','',''),(2624205,'1','180','934',414,'Retail Sale Id 1619167',2088.00,0.00,0.00,3.00,282.00,'2022-05-21 14:23:11','',''),(2624206,'1','180','934',414,'Retail Sale Id 1619168',2088.00,0.00,0.00,3.00,282.00,'2022-05-21 14:23:46','',''),(2624207,'1','180','934',414,'Retail Sale Id 1619169',3480.00,0.00,0.00,5.00,470.00,'2022-05-21 14:24:19','',''),(2624208,'1','180','934',414,'Retail Sale Id 1619170',1392.00,0.00,0.00,2.00,188.00,'2022-05-21 14:31:30','',''),(2624209,'1','180','934',414,'Retail Sale Id 1619171',4176.00,0.00,0.00,6.00,564.00,'2022-05-21 14:41:06','',''),(2624210,'1','180','934',414,'Retail Sale Id 1619172',4176.00,0.00,0.00,6.00,564.00,'2022-05-21 15:48:19','',''),(2624211,'1','180','934',414,'Retail Sale Id 1619173',4176.00,0.00,0.00,6.00,564.00,'2022-05-21 15:48:55','',''),(2624212,'1','180','934',414,'Retail Sale Id 1619174',3480.00,0.00,0.00,5.00,470.00,'2022-05-21 15:49:30','',''),(2624213,'1','180','934',414,'Retail Sale Id 1619175',1698.24,0.00,0.00,2.44,229.36,'2022-05-21 15:51:05','',''),(2624214,'1','180','934',414,'Retail Sale Id 1619176',4997.28,0.00,0.00,7.18,674.92,'2022-05-21 16:14:08','',''),(2624215,'1','180','934',414,'Retail Sale Id 1619177',2999.76,0.00,0.00,4.31,405.14,'2022-05-21 16:14:41','',''),(2624216,'1','180','934',414,'Retail Sale Id 1619178',32600.00,0.00,0.00,50.00,2500.00,'2022-05-21 16:16:00','',''),(2624217,'1','180','934',414,'Retail Sale Id 1619179',2784.00,0.00,0.00,4.00,376.00,'2022-05-21 16:51:09','',''),(2624218,'1','180','934',414,'Retail Sale Id 1619180',2999.76,0.00,0.00,4.31,405.14,'2022-05-21 17:10:00','',''),(2624219,'1','180','934',414,'Retail Sale Id 1619181',8700.00,0.00,0.00,12.50,1175.00,'2022-05-21 22:10:03','',''),(2624220,'1','180','934',414,'Retail Sale Id 1619182',3480.00,0.00,0.00,5.00,470.00,'2022-05-22 11:26:05','',''),(2624221,'1','180','934',414,'Retail Sale Id 1619183',2999.76,0.00,0.00,4.31,405.14,'2022-05-22 11:26:55','',''),(2624222,'1','180','934',414,'Retail Sale Id 1619184',2088.00,0.00,0.00,3.00,282.00,'2022-05-22 11:27:54','',''),(2624223,'1','180','934',414,'Retail Sale Id 1619185',1503.36,0.00,0.00,2.16,203.04,'2022-05-22 11:29:00','',''),(2624224,'1','180','934',414,'Retail Sale Id 1619186',3201.60,0.00,0.00,4.60,432.40,'2022-05-22 14:28:44','',''),(2624225,'1','180','934',414,'Retail Sale Id 1619187',2088.00,0.00,0.00,3.00,282.00,'2022-05-22 14:57:25','',''),(2624226,'1','180','934',414,'Retail Sale Id 1619188',2498.64,0.00,0.00,3.59,337.46,'2022-05-22 14:58:13','',''),(2624227,'1','180','934',414,'Retail Sale Id 1619189',1503.36,0.00,0.00,2.16,203.04,'2022-05-22 15:00:26','',''),(2624228,'1','180','934',414,'Retail Sale Id 1619190',2088.00,0.00,0.00,3.00,282.00,'2022-05-22 16:44:49','',''),(2624229,'1','180','934',414,'Retail Sale Id 1619191',7001.76,0.00,0.00,10.06,945.64,'2022-05-22 17:17:43','',''),(2624230,'1','180','934',414,'Retail Sale Id 1619192',8700.00,0.00,0.00,12.50,1175.00,'2022-05-22 21:50:39','',''),(2624231,'1','180','934',414,'Retail Sale Id 1619193',3480.00,0.00,0.00,5.00,470.00,'2022-05-23 11:27:32','',''),(2624232,'1','180','934',414,'Retail Sale Id 1619194',5999.52,0.00,0.00,8.62,810.28,'2022-05-23 11:28:11','',''),(2624233,'1','180','934',414,'Retail Sale Id 1619195',4176.00,0.00,0.00,6.00,564.00,'2022-05-23 13:38:12','',''),(2624234,'1','180','934',414,'Retail Sale Id 1619196',2999.76,0.00,0.00,4.31,405.14,'2022-05-23 15:34:51','',''),(2624235,'1','180','934',414,'Retail Sale Id 1619197',1503.36,0.00,0.00,2.16,203.04,'2022-05-23 16:48:03','',''),(2624236,'1','180','934',414,'Retail Sale Id 1619198',7001.76,0.00,0.00,10.06,945.64,'2022-05-23 16:49:02','',''),(2624237,'1','180','934',414,'Retail Sale Id 1619199',2088.00,0.00,0.00,3.00,282.00,'2022-05-23 17:49:17','',''),(2624238,'1','180','934',414,'Retail Sale Id 1619200',4002.00,0.00,0.00,5.75,540.50,'2022-05-23 17:50:36','',''),(2624239,'1','180','934',414,'Retail Sale Id 1619201',3480.00,0.00,0.00,5.00,470.00,'2022-05-24 11:03:45','',''),(2624240,'1','180','934',414,'Retail Sale Id 1619202',3480.00,0.00,0.00,5.00,470.00,'2022-05-24 11:04:29','',''),(2624241,'1','180','934',414,'Retail Sale Id 1619203',4872.00,0.00,0.00,7.00,658.00,'2022-05-24 11:08:13','',''),(2624242,'1','180','934',414,'Retail Sale Id 1619204',1002.24,0.00,0.00,1.44,135.36,'2022-05-24 11:09:01','',''),(2624243,'1','180','934',414,'Retail Sale Id 1619205',2999.76,0.00,0.00,4.31,405.14,'2022-05-24 17:27:38','',''),(2624244,'1','180','934',414,'Retail Sale Id 1619207',8700.00,0.00,0.00,12.50,1175.00,'2022-05-24 17:30:08','',''),(2624245,'1','180','934',414,'Retail Sale Id 1619208',5568.00,0.00,0.00,8.00,752.00,'2022-05-24 17:31:26','',''),(2624246,'1','180','934',414,'Retail Sale Id 1619209',8352.00,0.00,0.00,12.00,1128.00,'2022-05-24 17:33:26','',''),(2624247,'1','180','934',414,'Retail Sale Id 1619210',8700.00,0.00,0.00,12.50,1175.00,'2022-05-24 17:34:41','',''),(2624248,'1','180','934',414,'Retail Sale Id 1619211',4176.00,0.00,0.00,6.00,564.00,'2022-05-24 17:35:51','',''),(2624249,'1','180','934',414,'Retail Sale Id 1619212',6960.00,0.00,0.00,10.00,940.00,'2022-05-24 17:36:43','',''),(2624250,'1','180','934',414,'Retail Sale Id 1619213',1997.52,0.00,0.00,2.87,269.78,'2022-05-24 17:37:45','',''),(2624251,'1','180','934',414,'Retail Sale Id 1619214',1941.84,0.00,0.00,2.79,262.26,'2022-05-24 17:39:29','',''),(2624252,'1','180','934',414,'Retail Sale Id 1619215',39120.00,0.00,0.00,60.00,3000.00,'2022-05-24 17:42:03','',''),(2624253,'1','180','934',414,'Retail Sale Id 1619216',2960.00,0.00,0.00,4.00,552.00,'2022-05-25 11:21:09','',''),(2624254,'1','180','934',414,'Retail Sale Id 1619217',2220.00,0.00,0.00,3.00,414.00,'2022-05-25 11:21:50','',''),(2624255,'1','180','934',414,'Retail Sale Id 1619218',2220.00,0.00,0.00,3.00,414.00,'2022-05-25 11:22:28','',''),(2624256,'1','180','934',414,'Retail Sale Id 1619219',2220.00,0.00,0.00,3.00,414.00,'2022-05-25 11:23:10','',''),(2624257,'1','180','934',414,'Retail Sale Id 1619220',7999.40,0.00,0.00,10.81,1491.78,'2022-05-25 11:23:47','',''),(2624258,'1','180','934',414,'Retail Sale Id 1619221',5498.20,0.00,0.00,7.43,1025.34,'2022-05-25 11:24:41','',''),(2624259,'1','180','934',414,'Retail Sale Id 1619222',3500.20,0.00,0.00,4.73,652.74,'2022-05-25 11:25:33','',''),(2624260,'1','180','934',414,'Retail Sale Id 1619223',2997.00,0.00,0.00,4.05,558.90,'2022-05-25 14:23:04','',''),(2624261,'1','180','934',414,'Retail Sale Id 1619224',1998.00,0.00,0.00,2.70,372.60,'2022-05-25 14:24:02','',''),(2624262,'1','180','934',414,'Retail Sale Id 1619225',2220.00,0.00,0.00,3.00,414.00,'2022-05-25 14:25:12','',''),(2624263,'1','180','934',414,'Retail Sale Id 1619226',1480.00,0.00,0.00,2.00,276.00,'2022-05-25 14:26:39','',''),(2624264,'1','180','934',414,'Retail Sale Id 1619227',4047.80,0.00,0.00,5.47,754.86,'2022-05-25 18:55:13','',''),(2624265,'1','180','934',414,'Retail Sale Id 1619228',2501.20,0.00,0.00,3.38,466.44,'2022-05-25 19:31:05','',''),(2624266,'1','180','934',414,'Retail Sale Id 1619229',1850.00,0.00,0.00,2.50,345.00,'2022-05-25 19:45:54','',''),(2624267,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,2102918.44,3493.22,0.00,0.00,'2022-05-26 12:44:42','',''),(2624268,'1','180',NULL,414,'Reception corrector for bridging 130293',0.00,0.00,0.00,3493.00,0.00,'2022-05-26 12:49:14','',''),(2624269,'1','180','934',414,'Received from bridging 130293',0.00,0.00,3493.00,0.00,0.00,'2022-05-26 12:49:14','',''),(2624270,'1','180','934',414,'Retail Sale Id 1619230',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 12:51:19','',''),(2624271,'1','180','934',414,'Retail Sale Id 1619231',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 12:53:07','',''),(2624272,'1','180','934',414,'Retail Sale Id 1619232',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 12:56:07','',''),(2624273,'1','180','934',414,'Retail Sale Id 1619233',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 12:57:28','',''),(2624274,'1','180','934',414,'Retail Sale Id 1619234',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 13:00:53','',''),(2624275,'1','180','934',414,'Retail Sale Id 1619235',7400.00,0.00,0.00,10.00,1380.00,'2022-05-26 13:02:00','',''),(2624276,'1','180','934',414,'Retail Sale Id 1619236',6001.40,0.00,0.00,8.11,1119.18,'2022-05-26 13:03:25','',''),(2624277,'1','180','934',414,'Retail Sale Id 1619237',1398.60,0.00,0.00,1.89,260.82,'2022-05-26 13:04:35','',''),(2624278,'1','180','934',414,'Retail Sale Id 1619238',1480.00,0.00,0.00,2.00,276.00,'2022-05-26 13:11:32','',''),(2624279,'1','180','934',414,'Retail Sale Id 1619239',5180.00,0.00,0.00,7.00,966.00,'2022-05-26 16:15:04','',''),(2624280,'1','180','934',414,'Retail Sale Id 1619240',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 16:16:06','',''),(2624281,'1','180','934',414,'Retail Sale Id 1619241',2220.00,0.00,0.00,3.00,414.00,'2022-05-26 16:17:28','',''),(2624282,'1','180','934',414,'Retail Sale Id 1619242',2220.00,0.00,0.00,3.00,414.00,'2022-05-26 16:18:11','',''),(2624283,'1','180','934',414,'Retail Sale Id 1619243',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 17:30:25','',''),(2624284,'1','180','934',414,'Retail Sale Id 1619244',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 17:30:59','',''),(2624285,'1','180','934',414,'Retail Sale Id 1619245',1480.00,0.00,0.00,2.00,276.00,'2022-05-26 17:31:31','',''),(2624286,'1','180','934',414,'Retail Sale Id 1619246',4440.00,0.00,0.00,6.00,828.00,'2022-05-26 17:52:59','',''),(2624287,'1','180','934',414,'Retail Sale Id 1619247',7400.00,0.00,0.00,10.00,1380.00,'2022-05-26 21:34:44','',''),(2624288,'1','180','934',414,'Retail Sale Id 1619248',9250.00,0.00,0.00,12.50,1725.00,'2022-05-27 11:12:27','',''),(2624289,'1','180','934',414,'Retail Sale Id 1619249',4440.00,0.00,0.00,6.00,828.00,'2022-05-27 11:13:26','',''),(2624290,'1','180','934',414,'Retail Sale Id 1619250',4440.00,0.00,0.00,6.00,828.00,'2022-05-27 11:14:13','',''),(2624291,'1','180','934',414,'Retail Sale Id 1619251',6001.40,0.00,0.00,8.11,1119.18,'2022-05-27 11:14:49','',''),(2624292,'1','180','934',414,'Retail Sale Id 1619252',4003.40,0.00,0.00,5.41,746.58,'2022-05-27 11:15:28','',''),(2624293,'1','180','934',414,'Retail Sale Id 1619253',2197.80,0.00,0.00,2.97,409.86,'2022-05-27 11:16:09','',''),(2624294,'1','180','934',414,'Retail Sale Id 1619254',2153.40,0.00,0.00,2.91,401.58,'2022-05-27 11:17:03','',''),(2624295,'1','180','934',414,'Retail Sale Id 1619255',2220.00,0.00,0.00,3.00,414.00,'2022-05-27 11:30:36','',''),(2624296,'1','180','934',414,'Retail Sale Id 1619256',4440.00,0.00,0.00,6.00,828.00,'2022-05-27 14:33:37','',''),(2624297,'1','180','934',414,'Retail Sale Id 1619257',7400.00,0.00,0.00,10.00,1380.00,'2022-05-27 20:59:17','',''),(2624298,'1','180','934',414,'Retail Sale Id 1619258',3500.20,0.00,0.00,4.73,652.74,'2022-05-27 21:00:42','',''),(2624299,'1','180','934',414,'Retail Sale Id 1619259',4440.00,0.00,0.00,6.00,828.00,'2022-05-27 21:01:37','',''),(2624300,'1','180','934',414,'Retail Sale Id 1619260',4440.00,0.00,0.00,6.00,828.00,'2022-05-28 11:17:21','',''),(2624301,'1','180','934',414,'Retail Sale Id 1619261',8502.60,0.00,0.00,11.49,1585.62,'2022-05-28 11:18:44','',''),(2624302,'1','180','934',414,'Retail Sale Id 1619262',8502.60,0.00,0.00,11.49,1585.62,'2022-05-28 11:19:34','',''),(2624303,'1','180','934',414,'Retail Sale Id 1619263',2501.20,0.00,0.00,3.38,466.44,'2022-05-28 11:20:13','',''),(2624304,'1','180','934',414,'Retail Sale Id 1619264',4440.00,0.00,0.00,6.00,828.00,'2022-05-28 17:27:12','',''),(2624305,'1','180','934',414,'Retail Sale Id 1619265',2220.00,0.00,0.00,3.00,414.00,'2022-05-28 17:28:11','',''),(2624306,'1','180','934',414,'Retail Sale Id 1619266',5801.60,0.00,0.00,7.84,1081.92,'2022-05-28 17:29:00','',''),(2624307,'1','180','934',414,'Retail Sale Id 1619267',8880.00,0.00,0.00,12.00,1656.00,'2022-05-28 17:29:48','',''),(2624308,'1','180','934',414,'Retail Sale Id 1619268',7400.00,0.00,0.00,10.00,1380.00,'2022-05-28 17:30:27','',''),(2624309,'1','180','934',414,'Retail Sale Id 1619269',2220.00,0.00,0.00,3.00,414.00,'2022-05-28 17:31:45','',''),(2624310,'1','180','934',414,'Retail Sale Id 1619270',4440.00,0.00,0.00,6.00,828.00,'2022-05-28 18:38:13','',''),(2624311,'1','180','934',414,'Retail Sale Id 1619271',1998.00,0.00,0.00,2.70,372.60,'2022-05-28 18:39:31','',''),(2624312,'1','180','934',414,'Retail Sale Id 1619272',4440.00,0.00,0.00,6.00,828.00,'2022-05-28 18:40:53','',''),(2624313,'1','180','934',414,'Retail Sale Id 1619273',1998.00,0.00,0.00,2.70,372.60,'2022-05-28 18:42:34','',''),(2624314,'1','180','934',414,'Retail Sale Id 1619274',4440.00,0.00,0.00,6.00,828.00,'2022-05-29 11:15:17','',''),(2624315,'1','180','934',414,'Retail Sale Id 1619275',2220.00,0.00,0.00,3.00,414.00,'2022-05-29 11:16:42','',''),(2624316,'1','180','934',414,'Retail Sale Id 1619276',5180.00,0.00,0.00,7.00,966.00,'2022-05-29 14:42:38','',''),(2624317,'1','180','934',414,'Retail Sale Id 1619277',2960.00,0.00,0.00,4.00,552.00,'2022-05-29 14:43:26','',''),(2624318,'1','180','934',414,'Retail Sale Id 1619278',5002.40,0.00,0.00,6.76,932.88,'2022-05-29 14:44:17','',''),(2624319,'1','180','934',414,'Retail Sale Id 1619279',2153.40,0.00,0.00,2.91,401.58,'2022-05-29 14:45:02','',''),(2624320,'1','180','934',414,'Retail Sale Id 1619280',2501.20,0.00,0.00,3.38,466.44,'2022-05-29 14:45:46','',''),(2624321,'1','180','934',414,'Retail Sale Id 1619281',9250.00,0.00,0.00,12.50,1725.00,'2022-05-29 14:46:36','',''),(2624322,'1','180','934',414,'Retail Sale Id 1619282',9250.00,0.00,0.00,12.50,1725.00,'2022-05-29 14:47:14','',''),(2624323,'1','180','934',414,'Retail Sale Id 1619283',4440.00,0.00,0.00,6.00,828.00,'2022-05-29 14:47:56','',''),(2624324,'1','180','934',414,'Retail Sale Id 1619284',90480.00,0.00,0.00,130.00,12220.00,'2022-05-29 14:57:15','',''),(2624325,'1','180','934',414,'Retail Sale Id 1619285',39960.00,0.00,0.00,54.00,7452.00,'2022-05-29 21:18:07','',''),(2624326,'1','180','934',414,'Retail Sale Id 1619286',9250.00,0.00,0.00,12.50,1725.00,'2022-05-30 13:02:40','',''),(2624327,'1','180','934',414,'Retail Sale Id 1619287',2220.00,0.00,0.00,3.00,414.00,'2022-05-30 13:03:12','',''),(2624328,'1','180','934',414,'Retail Sale Id 1619288',4440.00,0.00,0.00,6.00,828.00,'2022-05-30 13:59:49','',''),(2624329,'1','180','934',414,'Retail Sale Id 1619289',3396.60,0.00,0.00,4.59,633.42,'2022-05-30 14:00:36','',''),(2624330,'1','180','934',414,'Retail Sale Id 1619290',7400.00,0.00,0.00,10.00,1380.00,'2022-05-30 14:01:28','',''),(2624331,'1','180','934',414,'Retail Sale Id 1619291',5002.40,0.00,0.00,6.76,932.88,'2022-05-30 14:02:19','',''),(2624332,'1','180','934',414,'Retail Sale Id 1619292',5002.40,0.00,0.00,6.76,932.88,'2022-05-30 14:03:26','',''),(2624333,'1','180','934',414,'Retail Sale Id 1619293',3100.60,0.00,0.00,4.19,578.22,'2022-05-30 14:04:59','',''),(2624334,'1','180','934',414,'Retail Sale Id 1619294',6497.20,0.00,0.00,8.78,1211.64,'2022-05-30 14:06:01','',''),(2624335,'1','180','934',414,'Retail Sale Id 1619295',2197.80,0.00,0.00,2.97,409.86,'2022-05-30 14:07:20','',''),(2624336,'1','180','934',414,'Retail Sale Id 1619296',3700.00,0.00,0.00,5.00,690.00,'2022-05-30 14:08:38','',''),(2624337,'1','180','934',414,'Retail Sale Id 1619297',9250.00,0.00,0.00,12.50,1725.00,'2022-05-30 19:05:43','',''),(2624338,'1','180','934',414,'Retail Sale Id 1619298',3500.20,0.00,0.00,4.73,652.74,'2022-05-30 19:08:54','',''),(2624339,'1','180','934',414,'Retail Sale Id 1619299',4440.00,0.00,0.00,6.00,828.00,'2022-05-30 19:10:33','',''),(2624340,'1','180','934',414,'Retail Sale Id 1619300',4440.00,0.00,0.00,6.00,828.00,'2022-05-30 19:11:12','',''),(2624341,'1','180','934',414,'Retail Sale Id 1619301',4440.00,0.00,0.00,6.00,828.00,'2022-05-31 13:17:42','',''),(2624342,'1','180','934',414,'Retail Sale Id 1619302',4440.00,0.00,0.00,6.00,828.00,'2022-05-31 13:19:04','',''),(2624343,'1','180','934',414,'Retail Sale Id 1619303',2960.00,0.00,0.00,4.00,552.00,'2022-05-31 13:20:14','',''),(2624344,'1','180','934',414,'Retail Sale Id 1619304',2220.00,0.00,0.00,3.00,414.00,'2022-05-31 13:40:25','',''),(2624345,'1','180','934',414,'Retail Sale Id 1619305',2997.00,0.00,0.00,4.05,558.90,'2022-05-31 17:20:49','',''),(2624346,'1','180','934',414,'Retail Sale Id 1619306',3196.80,0.00,0.00,4.32,596.16,'2022-05-31 17:21:45','',''),(2624347,'1','180','934',414,'Retail Sale Id 1619307',5202.20,0.00,0.00,7.03,970.14,'2022-05-31 17:23:00','',''),(2624348,'1','180','934',414,'Retail Sale Id 1619308',8140.00,0.00,0.00,11.00,1518.00,'2022-05-31 17:23:47','',''),(2624349,'1','180','934',414,'Retail Sale Id 1619309',2220.00,0.00,0.00,3.00,414.00,'2022-05-31 17:25:27','',''),(2624350,'1','180','934',414,'Retail Sale Id 1619310',7703.40,0.00,0.00,10.41,1436.58,'2022-05-31 20:17:39','',''),(2624351,'1','180','934',414,'Retail Sale Id 1619311',4003.40,0.00,0.00,5.41,746.58,'2022-05-31 20:18:16','',''),(2624352,'1','180','934',414,'Retail Sale Id 1619312',2900.80,0.00,0.00,3.92,540.96,'2022-05-31 20:18:57','',''),(2624353,'1','180','934',414,'Retail Sale Id 1619313',4440.00,0.00,0.00,6.00,828.00,'2022-06-01 09:52:48','',''),(2624354,'1','180','934',414,'Retail Sale Id 1619314',5180.00,0.00,0.00,7.00,966.00,'2022-06-01 13:13:41','',''),(2624355,'1','180','934',414,'Retail Sale Id 1619315',8140.00,0.00,0.00,11.00,1518.00,'2022-06-01 13:14:38','',''),(2624356,'1','180','934',414,'Retail Sale Id 1619316',5202.20,0.00,0.00,7.03,970.14,'2022-06-01 13:16:58','',''),(2624357,'1','180','934',414,'Retail Sale Id 1619317',9250.00,0.00,0.00,12.50,1725.00,'2022-06-01 16:44:05','',''),(2624358,'1','180','934',414,'Retail Sale Id 1619318',7400.00,0.00,0.00,10.00,1380.00,'2022-06-01 16:45:36','',''),(2624359,'1','180','934',414,'Retail Sale Id 1619320',740.00,0.00,0.00,1.00,138.00,'2022-06-01 16:50:56','',''),(2624360,'1','180','934',414,'Retail Sale Id 1619321',8998.40,0.00,0.00,12.16,1678.08,'2022-06-01 19:33:42','',''),(2624361,'1','180','934',414,'Retail Sale Id 1619322',9250.00,0.00,0.00,12.50,1725.00,'2022-06-01 19:34:33','',''),(2624362,'1','180','934',414,'Retail Sale Id 1619323',8140.00,0.00,0.00,11.00,1518.00,'2022-06-01 19:35:22','',''),(2624363,'1','180','934',414,'Retail Sale Id 1619324',1502.20,0.00,0.00,2.03,280.14,'2022-06-01 19:36:20','',''),(2624364,'1','180','934',414,'Retail Sale Id 1619325',4003.40,0.00,0.00,5.41,746.58,'2022-06-01 19:39:43','',''),(2624365,'1','180','934',414,'Retail Sale Id 1619326',5002.40,0.00,0.00,6.76,932.88,'2022-06-02 13:15:54','',''),(2624366,'1','180','934',414,'Retail Sale Id 1619327',5002.40,0.00,0.00,6.76,932.88,'2022-06-02 13:16:35','',''),(2624367,'1','180','934',414,'Retail Sale Id 1619328',5002.40,0.00,0.00,6.76,932.88,'2022-06-02 13:17:38','',''),(2624368,'1','180','934',414,'Retail Sale Id 1619329',4440.00,0.00,0.00,6.00,828.00,'2022-06-02 13:18:31','',''),(2624369,'1','180','934',414,'Retail Sale Id 1619330',2501.20,0.00,0.00,3.38,466.44,'2022-06-02 13:19:27','',''),(2624370,'1','180','934',414,'Retail Sale Id 1619331',5920.00,0.00,0.00,8.00,1104.00,'2022-06-02 18:47:48','',''),(2624371,'1','180','934',414,'Retail Sale Id 1619332',5920.00,0.00,0.00,8.00,1104.00,'2022-06-02 18:48:25','',''),(2624372,'1','180','934',414,'Retail Sale Id 1619333',5305.80,0.00,0.00,7.17,989.46,'2022-06-02 18:50:31','',''),(2624373,'1','180','934',414,'Retail Sale Id 1619334',9250.00,0.00,0.00,12.50,1725.00,'2022-06-03 11:25:30','',''),(2624374,'1','180','934',414,'Retail Sale Id 1619335',9250.00,0.00,0.00,12.50,1725.00,'2022-06-03 11:26:02','',''),(2624375,'1','180','934',414,'Retail Sale Id 1619336',7400.00,0.00,0.00,10.00,1380.00,'2022-06-03 11:26:43','',''),(2624376,'1','180','934',414,'Retail Sale Id 1619337',2220.00,0.00,0.00,3.00,414.00,'2022-06-03 11:27:30','',''),(2624377,'1','180','934',414,'Retail Sale Id 1619338',4003.40,0.00,0.00,5.41,746.58,'2022-06-03 11:28:30','',''),(2624378,'1','180','934',414,'Retail Sale Id 1619339',2220.00,0.00,0.00,3.00,414.00,'2022-06-03 13:33:54','',''),(2624379,'1','180','934',414,'Retail Sale Id 1619340',5498.20,0.00,0.00,7.43,1025.34,'2022-06-03 17:33:59','',''),(2624380,'1','180','934',414,'Retail Sale Id 1619341',5498.20,0.00,0.00,7.43,1025.34,'2022-06-03 17:35:00','',''),(2624381,'1','180','934',414,'Retail Sale Id 1619342',8880.00,0.00,0.00,12.00,1656.00,'2022-06-03 17:35:56','',''),(2624382,'1','180','934',414,'Retail Sale Id 1619343',13904.60,0.00,0.00,18.79,2593.02,'2022-06-03 20:31:20','',''),(2624383,'1','180','934',414,'Retail Sale Id 1619344',4440.00,0.00,0.00,6.00,828.00,'2022-06-04 09:39:27','',''),(2624384,'1','180','934',414,'Retail Sale Id 1619346',9250.00,0.00,0.00,12.50,1725.00,'2022-06-04 11:23:54','',''),(2624385,'1','180','934',414,'Retail Sale Id 1619347',4440.00,0.00,0.00,6.00,828.00,'2022-06-04 11:34:18','',''),(2624386,'1','180','934',414,'Retail Sale Id 1619348',9250.00,0.00,0.00,12.50,1725.00,'2022-06-04 13:26:20','',''),(2624387,'1','180','934',414,'Retail Sale Id 1619349',2220.00,0.00,0.00,3.00,414.00,'2022-06-04 13:42:01','',''),(2624388,'1','180','934',414,'Retail Sale Id 1619350',3700.00,0.00,0.00,5.00,690.00,'2022-06-04 13:45:44','',''),(2624389,'1','180','934',414,'Retail Sale Id 1619351',9250.00,0.00,0.00,12.50,1725.00,'2022-06-04 13:48:20','',''),(2624390,'1','180','934',414,'Retail Sale Id 1619352',5202.20,0.00,0.00,7.03,970.14,'2022-06-04 14:27:51','',''),(2624391,'1','180','934',414,'Retail Sale Id 1619353',7296.40,0.00,0.00,9.86,1360.68,'2022-06-04 14:29:01','',''),(2624392,'1','180','934',414,'Retail Sale Id 1619354',5180.00,0.00,0.00,7.00,966.00,'2022-06-04 14:29:45','',''),(2624393,'1','180','934',414,'Retail Sale Id 1619355',4003.40,0.00,0.00,5.41,746.58,'2022-06-04 14:30:38','',''),(2624394,'1','180','934',414,'Retail Sale Id 1619356',3500.20,0.00,0.00,4.73,652.74,'2022-06-04 14:31:33','',''),(2624395,'1','180','934',414,'Retail Sale Id 1619357',2220.00,0.00,0.00,3.00,414.00,'2022-06-04 14:32:27','',''),(2624396,'1','180','934',414,'Retail Sale Id 1619358',1998.00,0.00,0.00,2.70,372.60,'2022-06-04 14:49:24','',''),(2624397,'1','180','934',414,'Retail Sale Id 1619359',2997.00,0.00,0.00,4.05,558.90,'2022-06-04 15:10:46','',''),(2624398,'1','180','934',414,'Retail Sale Id 1619360',4003.40,0.00,0.00,5.41,746.58,'2022-06-04 15:25:17','',''),(2624399,'1','180','934',414,'Retail Sale Id 1619361',2249.60,0.00,0.00,3.04,419.52,'2022-06-04 15:27:37','',''),(2624400,'1','180','934',414,'Retail Sale Id 1619362',3700.00,0.00,0.00,5.00,690.00,'2022-06-04 15:29:50','',''),(2624401,'1','180','934',414,'Retail Sale Id 1619363',2220.00,0.00,0.00,3.00,414.00,'2022-06-04 15:42:52','',''),(2624402,'1','180','934',414,'Retail Sale Id 1619364',9250.00,0.00,0.00,12.50,1725.00,'2022-06-04 15:58:30','',''),(2624403,'1','180','934',414,'Retail Sale Id 1619365',1998.00,0.00,0.00,2.70,372.60,'2022-06-04 16:02:08','',''),(2624404,'1','180','934',414,'Retail Sale Id 1619366',1998.00,0.00,0.00,2.70,372.60,'2022-06-04 16:02:51','',''),(2624405,'1','180','934',414,'Retail Sale Id 1619367',4003.40,0.00,0.00,5.41,746.58,'2022-06-04 17:44:44','',''),(2624406,'1','180','934',414,'Retail Sale Id 1619368',2220.00,0.00,0.00,3.00,414.00,'2022-06-04 17:53:39','',''),(2624407,'1','180','934',414,'Retail Sale Id 1619369',1110.00,0.00,0.00,1.50,207.00,'2022-06-04 17:54:43','',''),(2624408,'1','180','934',414,'Retail Sale Id 1619370',4003.40,0.00,0.00,5.41,746.58,'2022-06-04 18:15:58','',''),(2624409,'1','180','934',414,'Retail Sale Id 1619371',3700.00,0.00,0.00,5.00,690.00,'2022-06-04 18:16:52','',''),(2624410,'1','180','934',414,'Retail Sale Id 1619372',2220.00,0.00,0.00,3.00,414.00,'2022-06-04 18:17:51','',''),(2624411,'1','180','934',414,'Retail Sale Id 1619373',999.00,0.00,0.00,1.35,186.30,'2022-06-04 18:18:50','',''),(2624412,'1','180','934',414,'Retail Sale Id 1619374',2220.00,0.00,0.00,3.00,414.00,'2022-06-04 18:19:36','',''),(2624413,'1','180','934',414,'Retail Sale Id 1619375',4440.00,0.00,0.00,6.00,828.00,'2022-06-04 18:21:40','',''),(2624414,'1','180','934',414,'Retail Sale Id 1619376',3500.20,0.00,0.00,4.73,652.74,'2022-06-05 08:00:42','',''),(2624415,'1','180','934',414,'Retail Sale Id 1619377',2997.00,0.00,0.00,4.05,558.90,'2022-06-05 08:01:56','',''),(2624416,'1','180','934',414,'Retail Sale Id 1619378',3700.00,0.00,0.00,5.00,690.00,'2022-06-05 08:48:12','',''),(2624417,'1','180','934',414,'Retail Sale Id 1619379',2101.60,0.00,0.00,2.84,391.92,'2022-06-05 09:10:17','',''),(2624418,'1','180','934',414,'Retail Sale Id 1619380',799.20,0.00,0.00,1.08,149.04,'2022-06-05 09:20:49','',''),(2624419,'1','180','934',414,'Retail Sale Id 1619381',3700.00,0.00,0.00,5.00,690.00,'2022-06-05 09:47:26','',''),(2624420,'1','180','934',414,'Retail Sale Id 1619382',3700.00,0.00,0.00,5.00,690.00,'2022-06-05 09:48:19','',''),(2624421,'1','180','934',414,'Retail Sale Id 1619383',6660.00,0.00,0.00,9.00,1242.00,'2022-06-05 09:49:28','',''),(2624422,'1','180','934',414,'Retail Sale Id 1619384',1998.00,0.00,0.00,2.70,372.60,'2022-06-05 10:57:28','',''),(2624423,'1','180','934',414,'Retail Sale Id 1619385',1998.00,0.00,0.00,2.70,372.60,'2022-06-05 11:15:43','',''),(2624424,'1','180','934',414,'Retail Sale Id 1619386',1998.00,0.00,0.00,2.70,372.60,'2022-06-05 11:16:42','',''),(2624425,'1','180','934',414,'Retail Sale Id 1619387',4440.00,0.00,0.00,6.00,828.00,'2022-06-05 11:17:38','',''),(2624426,'1','180','934',414,'Retail Sale Id 1619388',4440.00,0.00,0.00,6.00,828.00,'2022-06-05 11:54:09','',''),(2624427,'1','180','934',414,'Retail Sale Id 1619389',2220.00,0.00,0.00,3.00,414.00,'2022-06-05 13:00:40','',''),(2624428,'1','180','934',414,'Retail Sale Id 1619390',1502.20,0.00,0.00,2.03,280.14,'2022-06-05 13:50:49','',''),(2624429,'1','180','934',414,'Retail Sale Id 1619391',2997.00,0.00,0.00,4.05,558.90,'2022-06-05 13:53:46','',''),(2624430,'1','180','934',414,'Retail Sale Id 1619392',4440.00,0.00,0.00,6.00,828.00,'2022-06-05 13:57:51','',''),(2624431,'1','180','934',414,'Retail Sale Id 1619393',1198.80,0.00,0.00,1.62,223.56,'2022-06-05 13:58:36','',''),(2624432,'1','180','934',414,'Retail Sale Id 1619394',2220.00,0.00,0.00,3.00,414.00,'2022-06-05 14:52:28','',''),(2624433,'1','180','934',414,'Retail Sale Id 1619395',1502.20,0.00,0.00,2.03,280.14,'2022-06-05 14:54:03','',''),(2624434,'1','180','934',414,'Retail Sale Id 1619396',2220.00,0.00,0.00,3.00,414.00,'2022-06-05 15:00:03','',''),(2624435,'1','180','934',414,'Retail Sale Id 1619397',2220.00,0.00,0.00,3.00,414.00,'2022-06-05 16:05:13','',''),(2624436,'1','180','934',414,'Retail Sale Id 1619398',2997.00,0.00,0.00,4.05,558.90,'2022-06-05 16:08:25','',''),(2624437,'1','180','934',414,'Retail Sale Id 1619400',4440.00,0.00,0.00,6.00,828.00,'2022-06-05 16:41:47','',''),(2624438,'1','180','934',414,'Retail Sale Id 1619401',1480.00,0.00,0.00,2.00,276.00,'2022-06-05 17:00:24','',''),(2624439,'1','180','934',414,'Retail Sale Id 1619402',2997.00,0.00,0.00,4.05,558.90,'2022-06-05 17:14:29','',''),(2624440,'1','180','934',414,'Retail Sale Id 1619403',1502.20,0.00,0.00,2.03,280.14,'2022-06-05 17:39:12','',''),(2624441,'1','180','934',414,'Retail Sale Id 1619404',2997.00,0.00,0.00,4.05,558.90,'2022-06-05 17:54:59','',''),(2624442,'1','180','934',414,'Retail Sale Id 1619405',999.00,0.00,0.00,1.35,186.30,'2022-06-05 18:19:02','',''),(2624443,'1','180','934',414,'Retail Sale Id 1619407',8880.00,0.00,0.00,12.00,1656.00,'2022-06-05 20:35:48','',''),(2624444,'1','180','934',414,'Retail Sale Id 1619408',5002.40,0.00,0.00,6.76,932.88,'2022-06-05 20:36:37','',''),(2624445,'1','180','934',414,'Retail Sale Id 1619409',2220.00,0.00,0.00,3.00,414.00,'2022-06-06 10:11:25','',''),(2624446,'1','180','934',414,'Retail Sale Id 1619410',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 10:12:20','',''),(2624447,'1','180','934',414,'Retail Sale Id 1619411',83520.00,0.00,0.00,120.00,11280.00,'2022-06-06 10:13:40','',''),(2624448,'1','180','934',414,'Retail Sale Id 1619412',9250.00,0.00,0.00,12.50,1725.00,'2022-06-06 10:36:32','',''),(2624449,'1','180','934',414,'Retail Sale Id 1619413',9250.00,0.00,0.00,12.50,1725.00,'2022-06-06 10:37:19','',''),(2624450,'1','180','934',414,'Retail Sale Id 1619414',9250.00,0.00,0.00,12.50,1725.00,'2022-06-06 10:38:00','',''),(2624451,'1','180','934',414,'Retail Sale Id 1619415',9250.00,0.00,0.00,12.50,1725.00,'2022-06-06 10:38:53','',''),(2624452,'1','180','934',414,'Retail Sale Id 1619416',7400.00,0.00,0.00,10.00,1380.00,'2022-06-06 10:39:40','',''),(2624453,'1','180','934',414,'Retail Sale Id 1619417',2220.00,0.00,0.00,3.00,414.00,'2022-06-06 10:42:15','',''),(2624454,'1','180','934',414,'Retail Sale Id 1619418',1998.00,0.00,0.00,2.70,372.60,'2022-06-06 10:47:08','',''),(2624455,'1','180','934',414,'Retail Sale Id 1619419',2220.00,0.00,0.00,3.00,414.00,'2022-06-06 10:53:06','',''),(2624456,'1','180','934',414,'Retail Sale Id 1619420',3500.20,0.00,0.00,4.73,652.74,'2022-06-06 10:54:04','',''),(2624457,'1','180','934',414,'Retail Sale Id 1619421',8880.00,0.00,0.00,12.00,1656.00,'2022-06-06 12:58:49','',''),(2624458,'1','180','934',414,'Retail Sale Id 1619422',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 12:59:41','',''),(2624459,'1','180','934',414,'Retail Sale Id 1619423',5098.60,0.00,0.00,6.89,950.82,'2022-06-06 13:00:25','',''),(2624460,'1','180','934',414,'Retail Sale Id 1619424',2220.00,0.00,0.00,3.00,414.00,'2022-06-06 13:01:31','',''),(2624461,'1','180','934',414,'Retail Sale Id 1619425',1998.00,0.00,0.00,2.70,372.60,'2022-06-06 13:26:30','',''),(2624462,'1','180','934',414,'Retail Sale Id 1619426',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 14:40:53','',''),(2624463,'1','180','934',414,'Retail Sale Id 1619427',1998.00,0.00,0.00,2.70,372.60,'2022-06-06 15:54:31','',''),(2624464,'1','180','934',414,'Retail Sale Id 1619428',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 16:35:36','',''),(2624465,'1','180','934',414,'Retail Sale Id 1619429',2220.00,0.00,0.00,3.00,414.00,'2022-06-06 16:47:29','',''),(2624466,'1','180','934',414,'Retail Sale Id 1619430',2997.00,0.00,0.00,4.05,558.90,'2022-06-06 17:08:02','',''),(2624467,'1','180','934',414,'Retail Sale Id 1619431',1502.20,0.00,0.00,2.03,280.14,'2022-06-06 17:11:12','',''),(2624468,'1','180','934',414,'Retail Sale Id 1619432',1502.20,0.00,0.00,2.03,280.14,'2022-06-06 17:12:34','',''),(2624469,'1','180','934',414,'Retail Sale Id 1619433',1198.80,0.00,0.00,1.62,223.56,'2022-06-06 17:26:30','',''),(2624470,'1','180','934',414,'Retail Sale Id 1619434',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 17:33:44','',''),(2624471,'1','180','934',414,'Retail Sale Id 1619435',8880.00,0.00,0.00,12.00,1656.00,'2022-06-06 17:35:25','',''),(2624472,'1','180','934',414,'Retail Sale Id 1619436',1702.00,0.00,0.00,2.30,317.40,'2022-06-06 17:36:09','',''),(2624473,'1','180','934',414,'Retail Sale Id 1619437',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 17:39:33','',''),(2624474,'1','180','934',414,'Retail Sale Id 1619438',4440.00,0.00,0.00,6.00,828.00,'2022-06-06 18:41:11','',''),(2624475,'1','180','934',414,'Retail Sale Id 1619439',9250.00,0.00,0.00,12.50,1725.00,'2022-06-07 11:11:30','',''),(2624476,'1','180','934',414,'Retail Sale Id 1619440',2442.00,0.00,0.00,3.30,455.40,'2022-06-07 12:47:20','',''),(2624477,'1','180','934',414,'Retail Sale Id 1619441',2220.00,0.00,0.00,3.00,414.00,'2022-06-07 12:48:35','',''),(2624478,'1','180','934',414,'Retail Sale Id 1619442',1998.00,0.00,0.00,2.70,372.60,'2022-06-07 12:49:47','',''),(2624479,'1','180','934',414,'Retail Sale Id 1619443',2501.20,0.00,0.00,3.38,466.44,'2022-06-07 12:51:47','',''),(2624480,'1','180','934',414,'Retail Sale Id 1619444',9250.00,0.00,0.00,12.50,1725.00,'2022-06-07 12:55:36','',''),(2624481,'1','180','934',414,'Retail Sale Id 1619445',4440.00,0.00,0.00,6.00,828.00,'2022-06-07 12:57:15','',''),(2624482,'1','180','934',414,'Retail Sale Id 1619446',2997.00,0.00,0.00,4.05,558.90,'2022-06-07 12:58:33','',''),(2624483,'1','180','934',414,'Retail Sale Id 1619447',3500.20,0.00,0.00,4.73,652.74,'2022-06-07 12:59:41','',''),(2624484,'1','180','934',414,'Retail Sale Id 1619448',1480.00,0.00,0.00,2.00,276.00,'2022-06-07 13:01:47','',''),(2624485,'1','180','934',414,'Retail Sale Id 1619449',4602.80,0.00,0.00,6.22,858.36,'2022-06-07 13:07:51','',''),(2624486,'1','180','934',414,'Retail Sale Id 1619450',4440.00,0.00,0.00,6.00,828.00,'2022-06-07 13:13:37','',''),(2624487,'1','180','934',414,'Retail Sale Id 1619451',2220.00,0.00,0.00,3.00,414.00,'2022-06-07 13:29:08','',''),(2624488,'1','180','934',414,'Retail Sale Id 1619453',1198.80,0.00,0.00,1.62,223.56,'2022-06-07 14:46:48','',''),(2624489,'1','180','934',414,'Retail Sale Id 1619454',4440.00,0.00,0.00,6.00,828.00,'2022-06-07 14:59:18','',''),(2624490,'1','180','934',414,'Retail Sale Id 1619455',9250.00,0.00,0.00,12.50,1725.00,'2022-06-07 17:55:11','',''),(2624491,'1','180','934',414,'Retail Sale Id 1619456',4440.00,0.00,0.00,6.00,828.00,'2022-06-07 17:56:33','',''),(2624492,'1','180','934',414,'Retail Sale Id 1619457',2501.20,0.00,0.00,3.38,466.44,'2022-06-07 18:13:51','',''),(2624493,'1','180','934',414,'Retail Sale Id 1619458',3700.00,0.00,0.00,5.00,690.00,'2022-06-07 18:14:27','',''),(2624494,'1','180','934',414,'Retail Sale Id 1619459',503.20,0.00,0.00,0.68,93.84,'2022-06-07 18:30:34','',''),(2624495,'1','180','934',414,'Retail Sale Id 1619460',4440.00,0.00,0.00,6.00,828.00,'2022-06-07 21:21:41','',''),(2624496,'1','180','934',414,'Retail Sale Id 1619461',2501.20,0.00,0.00,3.38,466.44,'2022-06-07 21:22:28','',''),(2624497,'1','180','934',414,'Retail Sale Id 1619462',34800.00,0.00,0.00,50.00,4700.00,'2022-06-07 21:23:09','',''),(2624498,'1','180','934',414,'Retail Sale Id 1619463',4440.00,0.00,0.00,6.00,828.00,'2022-06-08 10:57:39','',''),(2624499,'1','180','934',414,'Retail Sale Id 1619464',4440.00,0.00,0.00,6.00,828.00,'2022-06-08 10:58:28','',''),(2624500,'1','180','934',414,'Retail Sale Id 1619465',9250.00,0.00,0.00,12.50,1725.00,'2022-06-08 13:40:16','',''),(2624501,'1','180','934',414,'Retail Sale Id 1619466',999.00,0.00,0.00,1.35,186.30,'2022-06-08 15:00:47','',''),(2624502,'1','180','934',414,'Retail Sale Id 1619467',7999.40,0.00,0.00,10.81,1491.78,'2022-06-08 15:01:52','',''),(2624503,'1','180','934',414,'Retail Sale Id 1619468',5920.00,0.00,0.00,8.00,1104.00,'2022-06-08 15:02:25','',''),(2624504,'1','180','934',414,'Retail Sale Id 1619469',8880.00,0.00,0.00,12.00,1656.00,'2022-06-08 15:03:13','',''),(2624505,'1','180','934',414,'Retail Sale Id 1619470',5002.40,0.00,0.00,6.76,932.88,'2022-06-08 15:03:49','',''),(2624506,'1','180','934',414,'Retail Sale Id 1619471',4440.00,0.00,0.00,6.00,828.00,'2022-06-08 15:08:37','',''),(2624507,'1','180','934',414,'Retail Sale Id 1619473',1502.20,0.00,0.00,2.03,280.14,'2022-06-08 15:32:41','',''),(2624508,'1','180','934',414,'Retail Sale Id 1619474',2960.00,0.00,0.00,4.00,552.00,'2022-06-08 15:33:53','',''),(2624509,'1','180','934',414,'Retail Sale Id 1619475',1998.00,0.00,0.00,2.70,372.60,'2022-06-08 15:35:38','',''),(2624510,'1','180','934',414,'Retail Sale Id 1619476',5920.00,0.00,0.00,8.00,1104.00,'2022-06-08 22:07:20','',''),(2624511,'1','180','934',414,'Retail Sale Id 1619477',5180.00,0.00,0.00,7.00,966.00,'2022-06-08 22:09:08','',''),(2624512,'1','180','934',414,'Retail Sale Id 1619478',7400.00,0.00,0.00,10.00,1380.00,'2022-06-08 22:09:50','',''),(2624513,'1','180','934',414,'Retail Sale Id 1619479',8880.00,0.00,0.00,12.00,1656.00,'2022-06-08 22:11:27','',''),(2624514,'1','180','934',414,'Retail Sale Id 1619480',7400.00,0.00,0.00,10.00,1380.00,'2022-06-08 22:12:25','',''),(2624515,'1','180','934',414,'Retail Sale Id 1619481',34800.00,0.00,0.00,50.00,4700.00,'2022-06-08 22:13:59','',''),(2624516,'1','180','934',414,'Retail Sale Id 1619482',4440.00,0.00,0.00,6.00,828.00,'2022-06-09 09:27:08','',''),(2624517,'1','180','934',414,'Retail Sale Id 1619483',6001.40,0.00,0.00,8.11,1119.18,'2022-06-09 12:24:04','',''),(2624518,'1','180','934',414,'Retail Sale Id 1619484',5002.40,0.00,0.00,6.76,932.88,'2022-06-09 12:24:58','',''),(2624519,'1','180','934',414,'Retail Sale Id 1619485',3396.60,0.00,0.00,4.59,633.42,'2022-06-09 12:26:01','',''),(2624520,'1','180','934',414,'Retail Sale Id 1619486',2220.00,0.00,0.00,3.00,414.00,'2022-06-09 14:26:00','',''),(2624521,'1','180','934',414,'Retail Sale Id 1619487',1998.00,0.00,0.00,2.70,372.60,'2022-06-09 14:45:46','',''),(2624522,'1','180','934',414,'Retail Sale Id 1619488',4440.00,0.00,0.00,6.00,828.00,'2022-06-09 15:07:06','',''),(2624523,'1','180','934',414,'Retail Sale Id 1619489',5180.00,0.00,0.00,7.00,966.00,'2022-06-09 15:40:59','',''),(2624524,'1','180','934',414,'Retail Sale Id 1619490',4440.00,0.00,0.00,6.00,828.00,'2022-06-09 16:55:58','',''),(2624525,'1','180','934',414,'Retail Sale Id 1619491',5180.00,0.00,0.00,7.00,966.00,'2022-06-09 16:59:37','',''),(2624526,'1','180','934',414,'Retail Sale Id 1619492',7000.40,0.00,0.00,9.46,1305.48,'2022-06-09 17:00:41','',''),(2624527,'1','180','934',414,'Retail Sale Id 1619493',1302.40,0.00,0.00,1.76,242.88,'2022-06-09 17:01:57','',''),(2624528,'1','180','934',414,'Retail Sale Id 1619494',999.00,0.00,0.00,1.35,186.30,'2022-06-09 17:02:44','',''),(2624529,'1','180','934',414,'Retail Sale Id 1619495',2220.00,0.00,0.00,3.00,414.00,'2022-06-09 17:21:57','',''),(2624530,'1','180','934',414,'Retail Sale Id 1619496',2220.00,0.00,0.00,3.00,414.00,'2022-06-09 17:45:08','',''),(2624531,'1','180','934',414,'Retail Sale Id 1619497',2960.00,0.00,0.00,4.00,552.00,'2022-06-09 17:49:09','',''),(2624532,'1','180','934',414,'Retail Sale Id 1619498',4440.00,0.00,0.00,6.00,828.00,'2022-06-09 18:24:38','',''),(2624533,'1','180','934',414,'Retail Sale Id 1619499',2997.00,0.00,0.00,4.05,558.90,'2022-06-09 18:39:22','',''),(2624534,'1','180','934',414,'Retail Sale Id 1619500',2220.00,0.00,0.00,3.00,414.00,'2022-06-09 18:41:41','',''),(2624535,'1','180','934',414,'Retail Sale Id 1619501',4440.00,0.00,0.00,6.00,828.00,'2022-06-09 18:48:37','',''),(2624536,'1','180','934',414,'Retail Sale Id 1619502',4620.00,0.00,0.00,6.00,1008.00,'2022-06-10 10:25:46','',''),(2624537,'1','180','934',414,'Retail Sale Id 1619503',9240.00,0.00,0.00,12.00,2016.00,'2022-06-10 12:28:04','',''),(2624538,'1','180','934',414,'Retail Sale Id 1619504',5998.30,0.00,0.00,7.79,1308.72,'2022-06-10 12:28:56','',''),(2624539,'1','180','934',414,'Retail Sale Id 1619505',9240.00,0.00,0.00,12.00,2016.00,'2022-06-10 12:29:57','',''),(2624540,'1','180','934',414,'Retail Sale Id 1619506',5998.30,0.00,0.00,7.79,1308.72,'2022-06-10 12:31:13','',''),(2624541,'1','180','934',414,'Retail Sale Id 1619507',9001.30,0.00,0.00,11.69,1963.92,'2022-06-10 12:32:10','',''),(2624542,'1','180','934',414,'Retail Sale Id 1619508',3080.00,0.00,0.00,4.00,672.00,'2022-06-10 12:32:51','',''),(2624543,'1','180','934',414,'Retail Sale Id 1619509',3080.00,0.00,0.00,4.00,672.00,'2022-06-10 12:36:09','',''),(2624544,'1','180','934',414,'Retail Sale Id 1619510',9625.00,0.00,0.00,12.50,2100.00,'2022-06-10 15:30:21','',''),(2624545,'1','180','934',414,'Retail Sale Id 1619511',3850.00,0.00,0.00,5.00,840.00,'2022-06-10 17:38:49','',''),(2624546,'1','180','934',414,'Retail Sale Id 1619512',2310.00,0.00,0.00,3.00,504.00,'2022-06-10 17:40:18','',''),(2624547,'1','180','934',414,'Retail Sale Id 1619513',1540.00,0.00,0.00,2.00,336.00,'2022-06-10 17:45:27','',''),(2624548,'1','180','934',414,'Retail Sale Id 1619514',3850.00,0.00,0.00,5.00,840.00,'2022-06-10 20:22:30','',''),(2624549,'1','180','934',414,'Retail Sale Id 1619515',2310.00,0.00,0.00,3.00,504.00,'2022-06-11 08:34:21','',''),(2624550,'1','180','934',414,'Retail Sale Id 1619516',4620.00,0.00,0.00,6.00,1008.00,'2022-06-11 11:58:52','',''),(2624551,'1','180','934',414,'Retail Sale Id 1619517',4620.00,0.00,0.00,6.00,1008.00,'2022-06-11 12:00:04','',''),(2624552,'1','180','934',414,'Retail Sale Id 1619518',3080.00,0.00,0.00,4.00,672.00,'2022-06-11 12:01:18','',''),(2624553,'1','180','934',414,'Retail Sale Id 1619519',2002.00,0.00,0.00,2.60,436.80,'2022-06-11 12:02:20','',''),(2624554,'1','180','934',414,'Retail Sale Id 1619520',6999.30,0.00,0.00,9.09,1527.12,'2022-06-11 12:03:26','',''),(2624555,'1','180','934',414,'Retail Sale Id 1619521',3003.00,0.00,0.00,3.90,655.20,'2022-06-11 12:04:28','',''),(2624556,'1','180','934',414,'Retail Sale Id 1619522',4620.00,0.00,0.00,6.00,1008.00,'2022-06-11 12:05:38','',''),(2624557,'1','180','934',414,'Retail Sale Id 1619523',9625.00,0.00,0.00,12.50,2100.00,'2022-06-11 12:06:51','',''),(2624558,'1','180','934',414,'Retail Sale Id 1619525',9625.00,0.00,0.00,12.50,2100.00,'2022-06-11 12:07:51','',''),(2624559,'1','180','934',414,'Retail Sale Id 1619526',4620.00,0.00,0.00,6.00,1008.00,'2022-06-11 12:09:01','',''),(2624560,'1','180','934',414,'Retail Sale Id 1619527',1001.00,0.00,0.00,1.30,218.40,'2022-06-11 12:43:07','',''),(2624561,'1','180','934',414,'Retail Sale Id 1619528',2002.00,0.00,0.00,2.60,436.80,'2022-06-11 13:23:21','',''),(2624562,'1','180','934',414,'Retail Sale Id 1619529',1501.50,0.00,0.00,1.95,327.60,'2022-06-11 13:29:54','',''),(2624563,'1','180','934',414,'Retail Sale Id 1619530',6160.00,0.00,0.00,8.00,1344.00,'2022-06-11 15:31:22','',''),(2624564,'1','180','934',414,'Retail Sale Id 1619531',3080.00,0.00,0.00,4.00,672.00,'2022-06-11 15:32:41','',''),(2624565,'1','180','934',414,'Retail Sale Id 1619532',3850.00,0.00,0.00,5.00,840.00,'2022-06-11 15:40:30','',''),(2624566,'1','180','934',414,'Retail Sale Id 1619533',1540.00,0.00,0.00,2.00,336.00,'2022-06-11 16:02:53','',''),(2624567,'1','180','934',414,'Retail Sale Id 1619534',2002.00,0.00,0.00,2.60,436.80,'2022-06-11 16:10:53','',''),(2624568,'1','180','934',414,'Retail Sale Id 1619535',2002.00,0.00,0.00,2.60,436.80,'2022-06-11 16:11:49','',''),(2624569,'1','180','934',414,'Retail Sale Id 1619536',1001.00,0.00,0.00,1.30,218.40,'2022-06-11 16:33:53','',''),(2624570,'1','180','934',414,'Retail Sale Id 1619537',2002.00,0.00,0.00,2.60,436.80,'2022-06-11 16:57:45','',''),(2624571,'1','180','934',414,'Retail Sale Id 1619538',2310.00,0.00,0.00,3.00,504.00,'2022-06-11 17:08:24','',''),(2624572,'1','180','934',414,'Retail Sale Id 1619539',2502.50,0.00,0.00,3.25,546.00,'2022-06-11 17:32:16','',''),(2624573,'1','180','934',414,'Retail Sale Id 1619540',8470.00,0.00,0.00,11.00,1848.00,'2022-06-11 18:03:03','',''),(2624574,'1','180','934',414,'Retail Sale Id 1619541',2002.00,0.00,0.00,2.60,436.80,'2022-06-11 18:20:25','',''),(2624575,'1','180','934',414,'Retail Sale Id 1619542',3080.00,0.00,0.00,4.00,672.00,'2022-06-11 18:38:48','',''),(2624576,'1','180','934',414,'Retail Sale Id 1619543',3080.00,0.00,0.00,4.00,672.00,'2022-06-12 09:35:38','',''),(2624577,'1','180','934',414,'Retail Sale Id 1619544',2310.00,0.00,0.00,3.00,504.00,'2022-06-12 09:36:40','',''),(2624578,'1','180','934',414,'Retail Sale Id 1619545',2002.00,0.00,0.00,2.60,436.80,'2022-06-12 09:37:46','',''),(2624579,'1','180','934',414,'Retail Sale Id 1619546',9625.00,0.00,0.00,12.50,2100.00,'2022-06-12 10:27:31','',''),(2624580,'1','180','934',414,'Retail Sale Id 1619547',2310.00,0.00,0.00,3.00,504.00,'2022-06-12 10:28:20','',''),(2624581,'1','180','934',414,'Retail Sale Id 1619548',2310.00,0.00,0.00,3.00,504.00,'2022-06-12 10:29:15','',''),(2624582,'1','180','934',414,'Retail Sale Id 1619549',1701.70,0.00,0.00,2.21,371.28,'2022-06-12 10:53:07','',''),(2624583,'1','180','934',414,'Retail Sale Id 1619550',1001.00,0.00,0.00,1.30,218.40,'2022-06-12 11:05:15','',''),(2624584,'1','180','934',414,'Retail Sale Id 1619551',3850.00,0.00,0.00,5.00,840.00,'2022-06-12 15:22:20','',''),(2624585,'1','180','934',414,'Retail Sale Id 1619552',6160.00,0.00,0.00,8.00,1344.00,'2022-06-12 15:57:14','',''),(2624586,'1','180','934',414,'Retail Sale Id 1619553',3996.30,0.00,0.00,5.19,871.92,'2022-06-12 16:15:48','',''),(2624587,'1','180','934',414,'Retail Sale Id 1619554',2502.50,0.00,0.00,3.25,546.00,'2022-06-12 16:17:22','',''),(2624588,'1','180','934',414,'Retail Sale Id 1619555',4620.00,0.00,0.00,6.00,1008.00,'2022-06-12 17:14:07','',''),(2624589,'1','180','934',414,'Retail Sale Id 1619556',1540.00,0.00,0.00,2.00,336.00,'2022-06-12 18:08:16','',''),(2624590,'1','180','934',414,'Retail Sale Id 1619557',2310.00,0.00,0.00,3.00,504.00,'2022-06-12 18:08:55','',''),(2624591,'1','180','934',414,'Retail Sale Id 1619558',1001.00,0.00,0.00,1.30,218.40,'2022-06-12 18:28:29','',''),(2624592,'1','180','934',414,'Retail Sale Id 1619559',3850.00,0.00,0.00,5.00,840.00,'2022-06-13 10:09:41','',''),(2624593,'1','180','934',414,'Retail Sale Id 1619560',3996.30,0.00,0.00,5.19,871.92,'2022-06-13 10:10:38','',''),(2624594,'1','180','934',414,'Retail Sale Id 1619561',2002.00,0.00,0.00,2.60,436.80,'2022-06-13 10:11:40','',''),(2624595,'1','180','934',414,'Retail Sale Id 1619562',3850.00,0.00,0.00,5.00,840.00,'2022-06-13 11:32:26','',''),(2624596,'1','180','934',414,'Retail Sale Id 1619563',2002.00,0.00,0.00,2.60,436.80,'2022-06-13 11:34:34','',''),(2624597,'1','180','934',414,'Retail Sale Id 1619564',2502.50,0.00,0.00,3.25,546.00,'2022-06-13 11:35:45','',''),(2624598,'1','180','934',414,'Retail Sale Id 1619565',2310.00,0.00,0.00,3.00,504.00,'2022-06-13 12:15:09','',''),(2624599,'1','180','934',414,'Retail Sale Id 1619566',2002.00,0.00,0.00,2.60,436.80,'2022-06-13 12:19:27','',''),(2624600,'1','180','934',414,'Retail Sale Id 1619567',4620.00,0.00,0.00,6.00,1008.00,'2022-06-13 12:20:55','',''),(2624601,'1','180','934',414,'Retail Sale Id 1619568',4620.00,0.00,0.00,6.00,1008.00,'2022-06-13 12:21:55','',''),(2624602,'1','180','934',414,'Retail Sale Id 1619569',4496.80,0.00,0.00,5.84,981.12,'2022-06-13 13:25:47','',''),(2624603,'1','180','934',414,'Retail Sale Id 1619570',2002.00,0.00,0.00,2.60,436.80,'2022-06-13 13:30:23','',''),(2624604,'1','180','934',414,'Retail Sale Id 1619571',2002.00,0.00,0.00,2.60,436.80,'2022-06-13 16:25:03','',''),(2624605,'1','180','934',414,'Retail Sale Id 1619572',3850.00,0.00,0.00,5.00,840.00,'2022-06-13 16:26:42','',''),(2624606,'1','180','934',414,'Retail Sale Id 1619573',7700.00,0.00,0.00,10.00,1680.00,'2022-06-13 16:27:47','',''),(2624607,'1','180','934',414,'Retail Sale Id 1619574',6160.00,0.00,0.00,8.00,1344.00,'2022-06-13 16:29:21','',''),(2624608,'1','180','934',414,'Retail Sale Id 1619575',3850.00,0.00,0.00,5.00,840.00,'2022-06-13 18:38:03','',''),(2624609,'1','180','934',414,'Retail Sale Id 1619576',2002.00,0.00,0.00,2.60,436.80,'2022-06-14 11:26:16','',''),(2624610,'1','180','934',414,'Retail Sale Id 1619577',9625.00,0.00,0.00,12.50,2100.00,'2022-06-14 12:50:07','',''),(2624611,'1','180','934',414,'Retail Sale Id 1619578',9240.00,0.00,0.00,12.00,2016.00,'2022-06-14 12:59:00','',''),(2624612,'1','180','934',414,'Retail Sale Id 1619579',2310.00,0.00,0.00,3.00,504.00,'2022-06-14 14:37:19','',''),(2624613,'1','180','934',414,'Retail Sale Id 1619580',3850.00,0.00,0.00,5.00,840.00,'2022-06-14 14:58:20','',''),(2624614,'1','180','934',414,'Retail Sale Id 1619581',1001.00,0.00,0.00,1.30,218.40,'2022-06-14 15:07:38','',''),(2624615,'1','180','934',414,'Retail Sale Id 1619582',1001.00,0.00,0.00,1.30,218.40,'2022-06-14 15:08:35','',''),(2624616,'1','180','934',414,'Retail Sale Id 1619583',72000.00,0.00,0.00,100.00,11800.00,'2022-06-14 16:29:03','',''),(2624617,'1','180','934',414,'Retail Sale Id 1619584',3003.00,0.00,0.00,3.90,655.20,'2022-06-14 17:01:06','',''),(2624618,'1','180','934',414,'Retail Sale Id 1619585',4620.00,0.00,0.00,6.00,1008.00,'2022-06-14 17:37:16','',''),(2624619,'1','180','934',414,'Retail Sale Id 1619586',2310.00,0.00,0.00,3.00,504.00,'2022-06-15 09:14:37','',''),(2624620,'1','180','934',414,'Retail Sale Id 1619587',3996.30,0.00,0.00,5.19,871.92,'2022-06-15 09:31:25','',''),(2624621,'1','180','934',414,'Retail Sale Id 1619588',770.00,0.00,0.00,1.00,168.00,'2022-06-15 10:11:37','',''),(2624622,'1','180','934',414,'Retail Sale Id 1619589',2310.00,0.00,0.00,3.00,504.00,'2022-06-15 10:35:25','',''),(2624623,'1','180','934',414,'Retail Sale Id 1619590',2310.00,0.00,0.00,3.00,504.00,'2022-06-15 10:36:31','',''),(2624624,'1','180','934',414,'Retail Sale Id 1619591',2002.00,0.00,0.00,2.60,436.80,'2022-06-15 10:37:39','',''),(2624625,'1','180','934',414,'Retail Sale Id 1619592',9748.20,0.00,0.00,12.66,2126.88,'2022-06-15 11:14:29','',''),(2624626,'1','180','934',414,'Retail Sale Id 1619593',800.80,0.00,0.00,1.04,174.72,'2022-06-15 11:17:09','',''),(2624627,'1','180','934',414,'Retail Sale Id 1619594',2310.00,0.00,0.00,3.00,504.00,'2022-06-15 11:39:46','',''),(2624628,'1','180','934',414,'Retail Sale Id 1619595',4620.00,0.00,0.00,6.00,1008.00,'2022-06-15 12:00:51','',''),(2624629,'1','180','934',414,'Retail Sale Id 1619596',4997.30,0.00,0.00,6.49,1090.32,'2022-06-15 12:02:03','',''),(2624630,'1','180','934',414,'Retail Sale Id 1619597',4997.30,0.00,0.00,6.49,1090.32,'2022-06-15 12:40:35','',''),(2624631,'1','180','934',414,'Retail Sale Id 1619598',2310.00,0.00,0.00,3.00,504.00,'2022-06-15 12:59:47','',''),(2624632,'1','180','934',414,'Retail Sale Id 1619599',36000.00,0.00,0.00,50.00,5900.00,'2022-06-15 18:00:36','',''),(2624633,'1','180','934',414,'Retail Sale Id 1619600',6999.30,0.00,0.00,9.09,1527.12,'2022-06-15 18:01:45','',''),(2624634,'1','180','934',414,'Retail Sale Id 1619601',5390.00,0.00,0.00,7.00,1176.00,'2022-06-15 18:03:09','',''),(2624635,'1','180','934',414,'Retail Sale Id 1619602',5998.30,0.00,0.00,7.79,1308.72,'2022-06-15 18:03:44','',''),(2624636,'1','180','934',414,'Retail Sale Id 1619603',9001.30,0.00,0.00,11.69,1963.92,'2022-06-15 18:14:34','',''),(2624637,'1','180','934',414,'Retail Sale Id 1619604',2310.00,0.00,0.00,3.00,504.00,'2022-06-15 18:24:43','',''),(2624638,'1','180','934',414,'Retail Sale Id 1619605',3850.00,0.00,0.00,5.00,840.00,'2022-06-15 18:28:27','',''),(2624639,'1','180','934',414,'Retail Sale Id 1619606',6498.80,0.00,0.00,8.44,1417.92,'2022-06-15 18:37:41','',''),(2624640,'1','180','934',414,'Retail Sale Id 1619607',9240.00,0.00,0.00,12.00,2016.00,'2022-06-16 09:15:46','',''),(2624641,'1','180','934',414,'Retail Sale Id 1619608',3850.00,0.00,0.00,5.00,840.00,'2022-06-16 09:17:09','',''),(2624642,'1','180','934',414,'Retail Sale Id 1619609',3850.00,0.00,0.00,5.00,840.00,'2022-06-16 09:18:03','',''),(2624643,'1','180','934',414,'Retail Sale Id 1619610',3850.00,0.00,0.00,5.00,840.00,'2022-06-16 09:19:06','',''),(2624644,'1','180','934',414,'Retail Sale Id 1619611',4620.00,0.00,0.00,6.00,1008.00,'2022-06-16 09:20:08','',''),(2624645,'1','180','934',414,'Retail Sale Id 1619612',4620.00,0.00,0.00,6.00,1008.00,'2022-06-16 09:20:58','',''),(2624646,'1','180','934',414,'Retail Sale Id 1619613',3203.20,0.00,0.00,4.16,698.88,'2022-06-16 09:48:58','',''),(2624647,'1','180','934',414,'Retail Sale Id 1619614',3003.00,0.00,0.00,3.90,655.20,'2022-06-16 11:08:08','',''),(2624648,'1','180','934',414,'Retail Sale Id 1619615',4550.70,0.00,0.00,5.91,992.88,'2022-06-16 11:33:07','',''),(2624649,'1','180','934',414,'Retail Sale Id 1619617',4620.00,0.00,0.00,6.00,1008.00,'2022-06-16 11:59:14','',''),(2624650,'1','180','934',414,'Retail Sale Id 1619618',4620.00,0.00,0.00,6.00,1008.00,'2022-06-16 12:38:20','',''),(2624651,'1','180','934',414,'Retail Sale Id 1619619',1540.00,0.00,0.00,2.00,336.00,'2022-06-16 13:21:31','',''),(2624652,'1','180','934',414,'Retail Sale Id 1619620',3850.00,0.00,0.00,5.00,840.00,'2022-06-16 13:30:54','',''),(2624653,'1','180','934',414,'Retail Sale Id 1619621',1001.00,0.00,0.00,1.30,218.40,'2022-06-16 13:41:37','',''),(2624654,'1','180','934',414,'Retail Sale Id 1619622',3603.60,0.00,0.00,4.68,786.24,'2022-06-16 15:46:39','',''),(2624655,'1','180','934',414,'Retail Sale Id 1619623',2310.00,0.00,0.00,3.00,504.00,'2022-06-16 17:41:31','',''),(2624656,'1','180','934',414,'Retail Sale Id 1619624',3996.30,0.00,0.00,5.19,871.92,'2022-06-16 17:42:04','',''),(2624657,'1','180','934',414,'Retail Sale Id 1619625',11465.30,0.00,0.00,14.89,2501.52,'2022-06-16 19:21:17','',''),(2624658,'1','180','934',414,'Retail Sale Id 1619626',2310.00,0.00,0.00,3.00,504.00,'2022-06-17 10:03:33','',''),(2624659,'1','180','934',414,'Retail Sale Id 1619627',1901.90,0.00,0.00,2.47,414.96,'2022-06-17 10:09:34','',''),(2624660,'1','180','934',414,'Retail Sale Id 1619628',1540.00,0.00,0.00,2.00,336.00,'2022-06-17 10:31:41','',''),(2624661,'1','180','934',414,'Retail Sale Id 1619629',4620.00,0.00,0.00,6.00,1008.00,'2022-06-17 10:32:41','',''),(2624662,'1','180','934',414,'Retail Sale Id 1619630',2310.00,0.00,0.00,3.00,504.00,'2022-06-17 11:13:08','',''),(2624663,'1','180','934',414,'Retail Sale Id 1619631',1801.80,0.00,0.00,2.34,393.12,'2022-06-17 11:14:23','',''),(2624664,'1','180','934',414,'Retail Sale Id 1619632',3996.30,0.00,0.00,5.19,871.92,'2022-06-17 11:18:32','',''),(2624665,'1','180','934',414,'Retail Sale Id 1619633',2002.00,0.00,0.00,2.60,436.80,'2022-06-17 11:36:02','',''),(2624666,'1','180','934',414,'Retail Sale Id 1619634',1301.30,0.00,0.00,1.69,283.92,'2022-06-17 11:54:57','',''),(2624667,'1','180','934',414,'Retail Sale Id 1619635',36000.00,0.00,0.00,50.00,5900.00,'2022-06-17 11:56:24','',''),(2624668,'1','180','934',414,'Retail Sale Id 1619636',72000.00,0.00,0.00,100.00,11800.00,'2022-06-17 11:58:45','',''),(2624669,'1','180','934',414,'Retail Sale Id 1619637',3080.00,0.00,0.00,4.00,672.00,'2022-06-17 12:29:40','',''),(2624670,'1','180','934',414,'Retail Sale Id 1619638',5390.00,0.00,0.00,7.00,1176.00,'2022-06-17 13:09:59','',''),(2624671,'1','180','934',414,'Retail Sale Id 1619639',1155.00,0.00,0.00,1.50,252.00,'2022-06-17 13:12:01','',''),(2624672,'1','180','934',414,'Retail Sale Id 1619640',8000.30,0.00,0.00,10.39,1745.52,'2022-06-17 14:37:15','',''),(2624673,'1','180','934',414,'Retail Sale Id 1619641',1001.00,0.00,0.00,1.30,218.40,'2022-06-17 14:39:44','',''),(2624674,'1','180','934',414,'Retail Sale Id 1619642',2502.50,0.00,0.00,3.25,546.00,'2022-06-17 14:56:55','',''),(2624675,'1','180','934',414,'Retail Sale Id 1619643',2310.00,0.00,0.00,3.00,504.00,'2022-06-17 15:00:44','',''),(2624676,'1','180','934',414,'Retail Sale Id 1619644',3080.00,0.00,0.00,4.00,672.00,'2022-06-17 16:29:24','',''),(2624677,'1','180','934',414,'Retail Sale Id 1619645',3503.50,0.00,0.00,4.55,764.40,'2022-06-17 16:33:26','',''),(2624678,'1','180','934',414,'Retail Sale Id 1619646',8470.00,0.00,0.00,11.00,1848.00,'2022-06-17 17:34:33','',''),(2624679,'1','180','934',414,'Retail Sale Id 1619647',3850.00,0.00,0.00,5.00,840.00,'2022-06-17 18:05:12','',''),(2624680,'1','180','934',414,'Retail Sale Id 1619648',4620.00,0.00,0.00,6.00,1008.00,'2022-06-17 18:06:35','',''),(2624681,'1','180','934',414,'Retail Sale Id 1619649',1501.50,0.00,0.00,1.95,327.60,'2022-06-17 18:11:52','',''),(2624682,'1','180','934',414,'Retail Sale Id 1619650',36000.00,0.00,0.00,50.00,5900.00,'2022-06-17 18:17:23','',''),(2624683,'1','180','934',414,'Retail Sale Id 1619651',4496.80,0.00,0.00,5.84,981.12,'2022-06-18 08:55:03','',''),(2624684,'1','180','934',414,'Retail Sale Id 1619652',4620.00,0.00,0.00,6.00,1008.00,'2022-06-18 09:09:19','',''),(2624685,'1','180','934',414,'Retail Sale Id 1619653',3703.70,0.00,0.00,4.81,808.08,'2022-06-18 09:10:33','',''),(2624686,'1','180','934',414,'Retail Sale Id 1619654',3996.30,0.00,0.00,5.19,871.92,'2022-06-18 09:42:06','',''),(2624687,'1','180','934',414,'Retail Sale Id 1619655',4027.10,0.00,0.00,5.23,878.64,'2022-06-18 10:05:33','',''),(2624688,'1','180','934',414,'Retail Sale Id 1619656',4620.00,0.00,0.00,6.00,1008.00,'2022-06-18 10:17:58','',''),(2624689,'1','180','934',414,'Retail Sale Id 1619657',4620.00,0.00,0.00,6.00,1008.00,'2022-06-18 13:43:27','',''),(2624690,'1','180','934',414,'Retail Sale Id 1619658',2310.00,0.00,0.00,3.00,504.00,'2022-06-18 14:11:45','',''),(2624691,'1','180','934',414,'Retail Sale Id 1619659',4997.30,0.00,0.00,6.49,1090.32,'2022-06-18 15:16:03','',''),(2624692,'1','180','934',414,'Retail Sale Id 1619660',3003.00,0.00,0.00,3.90,655.20,'2022-06-18 15:35:34','',''),(2624693,'1','180','934',414,'Retail Sale Id 1619661',3080.00,0.00,0.00,4.00,672.00,'2022-06-18 15:39:57','',''),(2624694,'1','180','934',414,'Retail Sale Id 1619662',1540.00,0.00,0.00,2.00,336.00,'2022-06-18 16:25:26','',''),(2624695,'1','180','934',414,'Retail Sale Id 1619663',2310.00,0.00,0.00,3.00,504.00,'2022-06-18 17:06:39','',''),(2624696,'1','180','934',414,'Retail Sale Id 1619664',2002.00,0.00,0.00,2.60,436.80,'2022-06-18 17:14:57','',''),(2624697,'1','180','934',414,'Retail Sale Id 1619665',6999.30,0.00,0.00,9.09,1527.12,'2022-06-18 17:20:38','',''),(2624698,'1','180','934',414,'Retail Sale Id 1619666',1540.00,0.00,0.00,2.00,336.00,'2022-06-18 17:25:46','',''),(2624699,'1','180','934',414,'Retail Sale Id 1619667',1155.00,0.00,0.00,1.50,252.00,'2022-06-18 17:34:04','',''),(2624700,'1','180','934',414,'Retail Sale Id 1619668',2310.00,0.00,0.00,3.00,504.00,'2022-06-18 18:54:31','',''),(2624701,'1','180','934',414,'Retail Sale Id 1619669',770.00,0.00,0.00,1.00,168.00,'2022-06-18 18:55:29','',''),(2624702,'1','180','934',414,'Retail Sale Id 1619670',86400.00,0.00,0.00,120.00,14160.00,'2022-06-18 18:56:19','',''),(2624703,'1','180','934',414,'Retail Sale Id 1619671',2310.00,0.00,0.00,3.00,504.00,'2022-06-19 08:24:36','',''),(2624704,'1','180','934',414,'Retail Sale Id 1619672',3003.00,0.00,0.00,3.90,655.20,'2022-06-19 10:07:07','',''),(2624705,'1','180','934',414,'Retail Sale Id 1619673',2002.00,0.00,0.00,2.60,436.80,'2022-06-19 10:08:14','',''),(2624706,'1','180','934',414,'Retail Sale Id 1619674',2002.00,0.00,0.00,2.60,436.80,'2022-06-19 10:09:10','',''),(2624707,'1','180','934',414,'Retail Sale Id 1619675',1301.30,0.00,0.00,1.69,283.92,'2022-06-19 10:10:28','',''),(2624708,'1','180','934',414,'Retail Sale Id 1619676',9001.30,0.00,0.00,11.69,1963.92,'2022-06-19 12:24:25','',''),(2624709,'1','180','934',414,'Retail Sale Id 1619677',3850.00,0.00,0.00,5.00,840.00,'2022-06-19 12:25:19','',''),(2624710,'1','180','934',414,'Retail Sale Id 1619678',2002.00,0.00,0.00,2.60,436.80,'2022-06-19 12:26:23','',''),(2624711,'1','180','934',414,'Retail Sale Id 1619679',2002.00,0.00,0.00,2.60,436.80,'2022-06-19 12:27:33','',''),(2624712,'1','180','934',414,'Retail Sale Id 1619680',9240.00,0.00,0.00,12.00,2016.00,'2022-06-19 14:18:08','',''),(2624713,'1','180','934',414,'Retail Sale Id 1619681',3080.00,0.00,0.00,4.00,672.00,'2022-06-19 14:19:32','',''),(2624714,'1','180','934',414,'Retail Sale Id 1619682',2002.00,0.00,0.00,2.60,436.80,'2022-06-19 16:23:14','',''),(2624715,'1','180','934',414,'Retail Sale Id 1619683',1001.00,0.00,0.00,1.30,218.40,'2022-06-19 17:31:56','',''),(2624716,'1','180','934',414,'Retail Sale Id 1619684',1201.20,0.00,0.00,1.56,262.08,'2022-06-19 18:56:12','',''),(2624717,'1','180','934',414,'Retail Sale Id 1619685',9625.00,0.00,0.00,12.50,2100.00,'2022-06-20 12:15:11','',''),(2624718,'1','180','934',414,'Retail Sale Id 1619686',9625.00,0.00,0.00,12.50,2100.00,'2022-06-20 12:15:48','',''),(2624719,'1','180','934',414,'Retail Sale Id 1619687',1540.00,0.00,0.00,2.00,336.00,'2022-06-20 12:16:31','',''),(2624720,'1','180','934',414,'Retail Sale Id 1619688',1501.50,0.00,0.00,1.95,327.60,'2022-06-20 12:17:35','',''),(2624721,'1','180','934',414,'Retail Sale Id 1619689',3080.00,0.00,0.00,4.00,672.00,'2022-06-20 13:47:18','',''),(2624722,'1','180','934',414,'Retail Sale Id 1619690',3996.30,0.00,0.00,5.19,871.92,'2022-06-20 15:13:34','',''),(2624723,'1','180','934',414,'Retail Sale Id 1619691',4620.00,0.00,0.00,6.00,1008.00,'2022-06-20 18:11:54','',''),(2624724,'1','180','934',414,'Retail Sale Id 1619692',3003.00,0.00,0.00,3.90,655.20,'2022-06-20 18:31:55','',''),(2624725,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344950',75852.00,0.00,0.00,126.00,0.00,'2022-06-25 10:24:23','',''),(2624726,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,3529200.00,5100.00,0.00,0.00,'2022-06-25 10:28:30','',''),(2624727,'1','180',NULL,414,'Reception corrector for bridging 130294',0.00,0.00,0.00,5100.00,0.00,'2022-06-25 10:30:12','',''),(2624728,'1','180','934',414,'Received from bridging 130294',0.00,0.00,5100.00,0.00,0.00,'2022-06-25 10:30:12','',''),(2624729,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344951',55360.00,0.00,0.00,80.00,0.00,'2022-06-25 10:35:06','',''),(2624730,'1','180','934',414,'Retail Sale Id 1619693',3003.00,0.00,0.00,3.90,304.20,'2022-06-25 13:30:23','',''),(2624731,'1','180','934',414,'Retail Sale Id 1619694',4620.00,0.00,0.00,6.00,468.00,'2022-06-25 13:32:11','',''),(2624732,'1','180','934',414,'Retail Sale Id 1619695',3850.00,0.00,0.00,5.00,390.00,'2022-06-25 13:34:28','',''),(2624733,'1','180','934',414,'Retail Sale Id 1619696',4620.00,0.00,0.00,6.00,468.00,'2022-06-25 13:37:04','',''),(2624734,'1','180','934',414,'Retail Sale Id 1619697',4997.30,0.00,0.00,6.49,506.22,'2022-06-25 14:22:13','',''),(2624735,'1','180','934',414,'Retail Sale Id 1619698',1540.00,0.00,0.00,2.00,156.00,'2022-06-25 14:22:50','',''),(2624736,'1','180','934',414,'Retail Sale Id 1619699',13883.10,0.00,0.00,18.03,1406.34,'2022-06-25 18:48:20','',''),(2624737,'1','180','934',414,'Retail Sale Id 1619700',2002.00,0.00,0.00,2.60,202.80,'2022-06-25 18:51:47','',''),(2624738,'1','180','934',414,'Retail Sale Id 1619701',9625.00,0.00,0.00,12.50,975.00,'2022-06-26 12:39:34','',''),(2624739,'1','180','934',414,'Retail Sale Id 1619702',7700.00,0.00,0.00,10.00,780.00,'2022-06-26 12:40:04','',''),(2624740,'1','180','934',414,'Retail Sale Id 1619703',3080.00,0.00,0.00,4.00,312.00,'2022-06-26 12:40:35','',''),(2624741,'1','180','934',414,'Retail Sale Id 1619704',9240.00,0.00,0.00,12.00,936.00,'2022-06-26 12:41:06','',''),(2624742,'1','180','934',414,'Retail Sale Id 1619705',3996.30,0.00,0.00,5.19,404.82,'2022-06-26 12:41:40','',''),(2624743,'1','180','934',414,'Retail Sale Id 1619706',19250.00,0.00,0.00,25.00,1950.00,'2022-06-26 15:53:57','',''),(2624744,'1','180','934',414,'Retail Sale Id 1619707',2310.00,0.00,0.00,3.00,234.00,'2022-06-26 15:57:08','',''),(2624745,'1','180','934',414,'Retail Sale Id 1619708',4897.20,0.00,0.00,6.36,496.08,'2022-06-26 15:58:39','',''),(2624746,'1','180','934',414,'Retail Sale Id 1619709',1001.00,0.00,0.00,1.30,101.40,'2022-06-26 16:09:57','',''),(2624747,'1','180','934',414,'Retail Sale Id 1619710',2310.00,0.00,0.00,3.00,234.00,'2022-06-26 16:50:01','',''),(2624748,'1','180','934',414,'Retail Sale Id 1619711',1540.00,0.00,0.00,2.00,156.00,'2022-06-26 16:52:34','',''),(2624749,'1','180','934',414,'Retail Sale Id 1619712',2310.00,0.00,0.00,3.00,234.00,'2022-06-26 17:04:25','',''),(2624750,'1','180','934',414,'Retail Sale Id 1619713',4620.00,0.00,0.00,6.00,468.00,'2022-06-26 17:13:17','',''),(2624751,'1','180','934',414,'Retail Sale Id 1619714',2310.00,0.00,0.00,3.00,234.00,'2022-06-26 17:37:41','',''),(2624752,'1','180','934',414,'Retail Sale Id 1619715',4997.30,0.00,0.00,6.49,506.22,'2022-06-26 17:54:09','',''),(2624753,'1','180','934',414,'Retail Sale Id 1619716',2502.50,0.00,0.00,3.25,253.50,'2022-06-26 17:55:07','',''),(2624754,'1','180','934',414,'Retail Sale Id 1619717',2310.00,0.00,0.00,3.00,234.00,'2022-06-26 18:11:28','',''),(2624755,'1','180','934',414,'Retail Sale Id 1619718',700.70,0.00,0.00,0.91,70.98,'2022-06-26 18:17:44','',''),(2624756,'1','180','934',414,'Retail Sale Id 1619719',2502.50,0.00,0.00,3.25,253.50,'2022-06-26 18:26:55','',''),(2624757,'1','180','934',414,'Retail Sale Id 1619720',4620.00,0.00,0.00,6.00,468.00,'2022-06-27 09:41:32','',''),(2624758,'1','180','934',414,'Retail Sale Id 1619721',6930.00,0.00,0.00,9.00,702.00,'2022-06-27 14:34:10','',''),(2624759,'1','180','934',414,'Retail Sale Id 1619722',2002.00,0.00,0.00,2.60,202.80,'2022-06-27 14:34:56','',''),(2624760,'1','180','934',414,'Retail Sale Id 1619723',9240.00,0.00,0.00,12.00,936.00,'2022-06-27 14:56:17','',''),(2624761,'1','180','934',414,'Retail Sale Id 1619724',4620.00,0.00,0.00,6.00,468.00,'2022-06-27 14:56:55','',''),(2624762,'1','180','934',414,'Retail Sale Id 1619725',5197.50,0.00,0.00,6.75,526.50,'2022-06-27 18:01:27','',''),(2624763,'1','180','934',414,'Retail Sale Id 1619726',4620.00,0.00,0.00,6.00,468.00,'2022-06-27 18:04:16','',''),(2624764,'1','180','934',414,'Retail Sale Id 1619727',4620.00,0.00,0.00,6.00,468.00,'2022-06-27 18:23:22','',''),(2624765,'1','180','934',414,'Retail Sale Id 1619728',1501.50,0.00,0.00,1.95,152.10,'2022-06-27 18:23:56','',''),(2624766,'1','180','934',414,'Retail Sale Id 1619729',6930.00,0.00,0.00,9.00,702.00,'2022-06-27 19:34:29','',''),(2624767,'1','180','934',414,'Retail Sale Id 1619730',36000.00,0.00,0.00,50.00,1400.00,'2022-06-27 19:36:29','',''),(2624768,'1','180','934',414,'Retail Sale Id 1619731',3003.00,0.00,0.00,3.90,304.20,'2022-06-28 08:49:54','',''),(2624769,'1','180','934',414,'Retail Sale Id 1619732',4620.00,0.00,0.00,6.00,468.00,'2022-06-28 09:51:43','',''),(2624770,'1','180','934',414,'Retail Sale Id 1619733',2002.00,0.00,0.00,2.60,202.80,'2022-06-28 11:22:12','',''),(2624771,'1','180','934',414,'Retail Sale Id 1619734',2310.00,0.00,0.00,3.00,234.00,'2022-06-28 11:47:55','',''),(2624772,'1','180','934',414,'Retail Sale Id 1619735',1801.80,0.00,0.00,2.34,182.52,'2022-06-28 11:48:54','',''),(2624773,'1','180','934',414,'Retail Sale Id 1619736',1501.50,0.00,0.00,1.95,152.10,'2022-06-28 11:49:54','',''),(2624774,'1','180','934',414,'Retail Sale Id 1619737',2002.00,0.00,0.00,2.60,202.80,'2022-06-28 12:44:23','',''),(2624775,'1','180','934',414,'Retail Sale Id 1619738',2002.00,0.00,0.00,2.60,202.80,'2022-06-28 12:59:05','',''),(2624776,'1','180','934',414,'Retail Sale Id 1619739',4620.00,0.00,0.00,6.00,468.00,'2022-06-28 17:12:09','',''),(2624777,'1','180','934',414,'Retail Sale Id 1619740',4620.00,0.00,0.00,6.00,468.00,'2022-06-28 17:12:50','',''),(2624778,'1','180','934',414,'Retail Sale Id 1619741',3003.00,0.00,0.00,3.90,304.20,'2022-06-28 17:27:39','',''),(2624779,'1','180','934',414,'Retail Sale Id 1619742',3996.30,0.00,0.00,5.19,404.82,'2022-06-28 17:32:08','',''),(2624780,'1','180','934',414,'Retail Sale Id 1619743',36000.00,0.00,0.00,50.00,1400.00,'2022-06-28 19:34:53','',''),(2624781,'1','180','934',414,'Retail Sale Id 1619744',4620.00,0.00,0.00,6.00,468.00,'2022-06-29 12:04:59','',''),(2624782,'1','180','934',414,'Retail Sale Id 1619745',4620.00,0.00,0.00,6.00,468.00,'2022-06-29 15:48:39','',''),(2624783,'1','180','934',414,'Retail Sale Id 1619746',1501.50,0.00,0.00,1.95,152.10,'2022-06-29 15:49:18','',''),(2624784,'1','180','934',414,'Retail Sale Id 1619747',1001.00,0.00,0.00,1.30,101.40,'2022-06-29 16:20:40','',''),(2624785,'1','180','934',414,'Retail Sale Id 1619748',3503.50,0.00,0.00,4.55,354.90,'2022-06-29 18:11:38','',''),(2624786,'1','180','934',414,'Retail Sale Id 1619749',4620.00,0.00,0.00,6.00,468.00,'2022-06-29 18:12:12','',''),(2624787,'1','180','934',414,'Retail Sale Id 1619750',3503.50,0.00,0.00,4.55,354.90,'2022-06-29 18:12:44','',''),(2624788,'1','180','934',414,'Retail Sale Id 1619751',7700.00,0.00,0.00,10.00,780.00,'2022-06-29 19:04:12','',''),(2624789,'1','180','934',414,'Retail Sale Id 1619752',5390.00,0.00,0.00,7.00,546.00,'2022-06-30 07:38:27','',''),(2624790,'1','180','934',414,'Retail Sale Id 1619753',4620.00,0.00,0.00,6.00,468.00,'2022-06-30 08:36:43','',''),(2624791,'1','180','934',414,'Retail Sale Id 1619754',3850.00,0.00,0.00,5.00,390.00,'2022-06-30 08:37:31','',''),(2624792,'1','180','934',414,'Retail Sale Id 1619755',4620.00,0.00,0.00,6.00,468.00,'2022-06-30 09:23:26','',''),(2624793,'1','180','934',414,'Retail Sale Id 1619756',3850.00,0.00,0.00,5.00,390.00,'2022-06-30 09:24:20','',''),(2624794,'1','180','934',414,'Retail Sale Id 1619757',9625.00,0.00,0.00,12.50,975.00,'2022-06-30 09:54:53','',''),(2624795,'1','180','934',414,'Retail Sale Id 1619758',3850.00,0.00,0.00,5.00,390.00,'2022-06-30 09:55:47','',''),(2624796,'1','180','934',414,'Retail Sale Id 1619759',3003.00,0.00,0.00,3.90,304.20,'2022-06-30 09:57:03','',''),(2624797,'1','180','934',414,'Retail Sale Id 1619760',1501.50,0.00,0.00,1.95,152.10,'2022-06-30 09:58:12','',''),(2624798,'1','180','934',414,'Retail Sale Id 1619761',4620.00,0.00,0.00,6.00,468.00,'2022-06-30 10:32:58','',''),(2624799,'1','180','934',414,'Retail Sale Id 1619762',3850.00,0.00,0.00,5.00,390.00,'2022-06-30 10:34:05','',''),(2624800,'1','180','934',414,'Retail Sale Id 1619763',3649.80,0.00,0.00,4.74,369.72,'2022-06-30 10:35:21','',''),(2624801,'1','180','934',414,'Retail Sale Id 1619764',3080.00,0.00,0.00,4.00,312.00,'2022-06-30 14:10:25','',''),(2624802,'1','180','934',414,'Retail Sale Id 1619765',1001.00,0.00,0.00,1.30,101.40,'2022-06-30 14:11:48','',''),(2624803,'1','180','934',414,'Retail Sale Id 1619766',4620.00,0.00,0.00,6.00,468.00,'2022-06-30 14:27:59','',''),(2624804,'1','180','934',414,'Retail Sale Id 1619767',2502.50,0.00,0.00,3.25,253.50,'2022-06-30 15:07:54','',''),(2624805,'1','180','934',414,'Retail Sale Id 1619768',2310.00,0.00,0.00,3.00,234.00,'2022-06-30 15:09:02','',''),(2624806,'1','180','934',414,'Retail Sale Id 1619769',9001.30,0.00,0.00,11.69,911.82,'2022-06-30 15:10:21','',''),(2624807,'1','180','934',414,'Retail Sale Id 1619770',3996.30,0.00,0.00,5.19,404.82,'2022-06-30 16:03:17','',''),(2624808,'1','180','934',414,'Retail Sale Id 1619771',1540.00,0.00,0.00,2.00,156.00,'2022-06-30 16:19:16','',''),(2624809,'1','180','934',414,'Retail Sale Id 1619772',3080.00,0.00,0.00,4.00,312.00,'2022-06-30 17:34:06','',''),(2624810,'1','180','934',414,'Retail Sale Id 1619773',2002.00,0.00,0.00,2.60,202.80,'2022-06-30 17:55:41','',''),(2624811,'1','180','934',414,'Retail Sale Id 1619774',1540.00,0.00,0.00,2.00,156.00,'2022-06-30 17:58:36','',''),(2624812,'1','180','934',414,'Retail Sale Id 1619775',3996.30,0.00,0.00,5.19,404.82,'2022-06-30 18:14:46','',''),(2624813,'1','180','934',414,'Retail Sale Id 1619776',2502.50,0.00,0.00,3.25,253.50,'2022-06-30 18:22:39','',''),(2624814,'1','180','934',414,'Retail Sale Id 1619777',4620.00,0.00,0.00,6.00,468.00,'2022-06-30 18:29:07','',''),(2624815,'1','180','934',414,'Retail Sale Id 1619778',1001.00,0.00,0.00,1.30,101.40,'2022-06-30 18:30:24','',''),(2624816,'1','180','934',414,'Retail Sale Id 1619779',9625.00,0.00,0.00,12.50,975.00,'2022-07-01 09:29:09','',''),(2624817,'1','180','934',414,'Retail Sale Id 1619780',2310.00,0.00,0.00,3.00,234.00,'2022-07-01 09:42:28','',''),(2624818,'1','180','934',414,'Retail Sale Id 1619781',2310.00,0.00,0.00,3.00,234.00,'2022-07-01 10:41:23','',''),(2624819,'1','180','934',414,'Retail Sale Id 1619782',4620.00,0.00,0.00,6.00,468.00,'2022-07-01 11:39:53','',''),(2624820,'1','180','934',414,'Retail Sale Id 1619783',2310.00,0.00,0.00,3.00,234.00,'2022-07-01 11:40:57','',''),(2624821,'1','180','934',414,'Retail Sale Id 1619784',700.70,0.00,0.00,0.91,70.98,'2022-07-01 11:53:24','',''),(2624822,'1','180','934',414,'Retail Sale Id 1619785',9625.00,0.00,0.00,12.50,975.00,'2022-07-01 16:47:24','',''),(2624823,'1','180','934',414,'Retail Sale Id 1619786',3080.00,0.00,0.00,4.00,312.00,'2022-07-01 16:48:06','',''),(2624824,'1','180','934',414,'Retail Sale Id 1619787',1001.00,0.00,0.00,1.30,101.40,'2022-07-01 16:48:42','',''),(2624825,'1','180','934',414,'Retail Sale Id 1619788',38500.00,0.00,0.00,50.00,3900.00,'2022-07-01 21:11:27','',''),(2624826,'1','180','934',414,'Retail Sale Id 1619789',19250.00,0.00,0.00,25.00,1950.00,'2022-07-01 21:12:19','',''),(2624827,'1','180','934',414,'Retail Sale Id 1619790',9625.00,0.00,0.00,12.50,975.00,'2022-07-02 09:06:22','',''),(2624828,'1','180','934',414,'Retail Sale Id 1619791',9625.00,0.00,0.00,12.50,975.00,'2022-07-02 09:07:59','',''),(2624829,'1','180','934',414,'Retail Sale Id 1619792',7700.00,0.00,0.00,10.00,780.00,'2022-07-02 10:18:51','',''),(2624830,'1','180','934',414,'Retail Sale Id 1619793',1701.70,0.00,0.00,2.21,172.38,'2022-07-02 10:36:28','',''),(2624831,'1','180','934',414,'Retail Sale Id 1619794',4997.30,0.00,0.00,6.49,506.22,'2022-07-02 11:01:51','',''),(2624832,'1','180','934',414,'Retail Sale Id 1619795',2002.00,0.00,0.00,2.60,202.80,'2022-07-02 11:02:47','',''),(2624833,'1','180','934',414,'Retail Sale Id 1619796',2310.00,0.00,0.00,3.00,234.00,'2022-07-02 11:47:07','',''),(2624834,'1','180','934',414,'Retail Sale Id 1619797',669.90,0.00,0.00,0.87,67.86,'2022-07-02 11:48:38','',''),(2624835,'1','180','934',414,'Retail Sale Id 1619798',8470.00,0.00,0.00,11.00,858.00,'2022-07-02 13:25:07','',''),(2624836,'1','180','934',414,'Retail Sale Id 1619799',43200.00,0.00,0.00,60.00,1680.00,'2022-07-02 13:26:03','',''),(2624837,'1','180','934',414,'Retail Sale Id 1619800',4897.20,0.00,0.00,6.36,496.08,'2022-07-02 13:26:56','',''),(2624838,'1','180','934',414,'Retail Sale Id 1619801',9625.00,0.00,0.00,12.50,975.00,'2022-07-02 13:28:01','',''),(2624839,'1','180','934',414,'Retail Sale Id 1619802',5621.00,0.00,0.00,7.30,569.40,'2022-07-02 13:30:03','',''),(2624840,'1','180','934',414,'Retail Sale Id 1619803',2310.00,0.00,0.00,3.00,234.00,'2022-07-02 13:33:50','',''),(2624841,'1','180','934',414,'Retail Sale Id 1619804',8000.30,0.00,0.00,10.39,810.42,'2022-07-02 13:44:23','',''),(2624842,'1','180','934',414,'Retail Sale Id 1619805',3996.30,0.00,0.00,5.19,404.82,'2022-07-02 13:58:16','',''),(2624843,'1','180','934',414,'Retail Sale Id 1619806',7700.00,0.00,0.00,10.00,780.00,'2022-07-02 14:03:15','',''),(2624844,'1','180','934',414,'Retail Sale Id 1619807',19250.00,0.00,0.00,25.00,1950.00,'2022-07-02 14:26:11','',''),(2624845,'1','180','934',414,'Retail Sale Id 1619808',2695.00,0.00,0.00,3.50,273.00,'2022-07-02 14:54:16','',''),(2624846,'1','180','934',414,'Retail Sale Id 1619809',4620.00,0.00,0.00,6.00,468.00,'2022-07-02 15:37:37','',''),(2624847,'1','180','934',414,'Retail Sale Id 1619810',4620.00,0.00,0.00,6.00,468.00,'2022-07-02 16:43:27','',''),(2624848,'1','180','934',414,'Retail Sale Id 1619811',500.50,0.00,0.00,0.65,50.70,'2022-07-02 16:54:58','',''),(2624849,'1','180','934',414,'Retail Sale Id 1619812',9625.00,0.00,0.00,12.50,975.00,'2022-07-02 17:41:13','',''),(2624850,'1','180','934',414,'Retail Sale Id 1619813',800.80,0.00,0.00,1.04,81.12,'2022-07-02 17:48:00','',''),(2624851,'1','180','934',414,'Retail Sale Id 1619814',1540.00,0.00,0.00,2.00,156.00,'2022-07-02 17:49:21','',''),(2624852,'1','180','934',414,'Retail Sale Id 1619815',3003.00,0.00,0.00,3.90,304.20,'2022-07-02 18:02:15','',''),(2624853,'1','180','934',414,'Retail Sale Id 1619816',4620.00,0.00,0.00,6.00,468.00,'2022-07-02 18:08:59','',''),(2624854,'1','180','934',414,'Retail Sale Id 1619817',9625.00,0.00,0.00,12.50,975.00,'2022-07-03 10:20:32','',''),(2624855,'1','180','934',414,'Retail Sale Id 1619818',4620.00,0.00,0.00,6.00,468.00,'2022-07-03 10:21:20','',''),(2624856,'1','180','934',414,'Retail Sale Id 1619819',2002.00,0.00,0.00,2.60,202.80,'2022-07-03 11:04:45','',''),(2624857,'1','180','934',414,'Retail Sale Id 1619820',2502.50,0.00,0.00,3.25,253.50,'2022-07-03 11:09:46','',''),(2624858,'1','180','934',414,'Retail Sale Id 1619821',4620.00,0.00,0.00,6.00,468.00,'2022-07-03 11:50:22','',''),(2624859,'1','180','934',414,'Retail Sale Id 1619822',1501.50,0.00,0.00,1.95,152.10,'2022-07-03 11:52:29','',''),(2624860,'1','180','934',414,'Retail Sale Id 1619823',2502.50,0.00,0.00,3.25,253.50,'2022-07-03 12:48:23','',''),(2624861,'1','180','934',414,'Retail Sale Id 1619824',2002.00,0.00,0.00,2.60,202.80,'2022-07-03 13:56:04','',''),(2624862,'1','180','934',414,'Retail Sale Id 1619825',3003.00,0.00,0.00,3.90,304.20,'2022-07-03 13:59:28','',''),(2624863,'1','180','934',414,'Retail Sale Id 1619826',4620.00,0.00,0.00,6.00,468.00,'2022-07-03 14:48:48','',''),(2624864,'1','180','934',414,'Retail Sale Id 1619827',2002.00,0.00,0.00,2.60,202.80,'2022-07-03 17:03:43','',''),(2624865,'1','180','934',414,'Retail Sale Id 1619828',2310.00,0.00,0.00,3.00,234.00,'2022-07-03 17:16:00','',''),(2624866,'1','180','934',414,'Retail Sale Id 1619829',2310.00,0.00,0.00,3.00,234.00,'2022-07-03 17:58:00','',''),(2624867,'1','180','934',414,'Retail Sale Id 1619830',3003.00,0.00,0.00,3.90,304.20,'2022-07-03 18:33:48','',''),(2624868,'1','180','934',414,'Retail Sale Id 1619831',2002.00,0.00,0.00,2.60,202.80,'2022-07-03 18:36:57','',''),(2624869,'1','180','934',414,'Retail Sale Id 1619832',4920.30,0.00,0.00,6.39,498.42,'2022-07-03 18:52:48','',''),(2624870,'1','180','934',414,'Retail Sale Id 1619833',4620.00,0.00,0.00,6.00,468.00,'2022-07-04 10:31:28','',''),(2624871,'1','180','934',414,'Retail Sale Id 1619834',4396.70,0.00,0.00,5.71,445.38,'2022-07-04 11:02:55','',''),(2624872,'1','180','934',414,'Retail Sale Id 1619835',2002.00,0.00,0.00,2.60,202.80,'2022-07-04 11:03:45','',''),(2624873,'1','180','934',414,'Retail Sale Id 1619836',3003.00,0.00,0.00,3.90,304.20,'2022-07-04 11:33:22','',''),(2624874,'1','180','934',414,'Retail Sale Id 1619837',9625.00,0.00,0.00,12.50,975.00,'2022-07-04 12:24:28','',''),(2624875,'1','180','934',414,'Retail Sale Id 1619838',4620.00,0.00,0.00,6.00,468.00,'2022-07-04 12:25:37','',''),(2624876,'1','180','934',414,'Retail Sale Id 1619839',2148.30,0.00,0.00,2.79,217.62,'2022-07-04 12:41:27','',''),(2624877,'1','180','934',414,'Retail Sale Id 1619840',770.00,0.00,0.00,1.00,78.00,'2022-07-04 12:57:06','',''),(2624878,'1','180','934',414,'Retail Sale Id 1619841',2310.00,0.00,0.00,3.00,234.00,'2022-07-04 12:59:11','',''),(2624879,'1','180','934',414,'Retail Sale Id 1619842',2002.00,0.00,0.00,2.60,202.80,'2022-07-04 13:12:47','',''),(2624880,'1','180','934',414,'Retail Sale Id 1619843',4620.00,0.00,0.00,6.00,468.00,'2022-07-04 13:57:20','',''),(2624881,'1','180','934',414,'Retail Sale Id 1619844',4620.00,0.00,0.00,6.00,468.00,'2022-07-04 13:58:53','',''),(2624882,'1','180','934',414,'Retail Sale Id 1619845',3996.30,0.00,0.00,5.19,404.82,'2022-07-04 14:43:10','',''),(2624883,'1','180','934',414,'Retail Sale Id 1619846',2310.00,0.00,0.00,3.00,234.00,'2022-07-04 14:45:51','',''),(2624884,'1','180','934',414,'Retail Sale Id 1619847',2310.00,0.00,0.00,3.00,234.00,'2022-07-04 15:12:53','',''),(2624885,'1','180','934',414,'Retail Sale Id 1619848',2310.00,0.00,0.00,3.00,234.00,'2022-07-04 16:31:48','',''),(2624886,'1','180','934',414,'Retail Sale Id 1619849',2502.50,0.00,0.00,3.25,253.50,'2022-07-04 16:35:50','',''),(2624887,'1','180','934',414,'Retail Sale Id 1619850',3850.00,0.00,0.00,5.00,390.00,'2022-07-04 17:36:36','',''),(2624888,'1','180','934',414,'Retail Sale Id 1619851',2002.00,0.00,0.00,2.60,202.80,'2022-07-04 18:00:24','',''),(2624889,'1','180','934',414,'Retail Sale Id 1619852',1001.00,0.00,0.00,1.30,101.40,'2022-07-04 18:33:17','',''),(2624890,'1','180','934',414,'Retail Sale Id 1619853',1001.00,0.00,0.00,1.30,101.40,'2022-07-04 21:55:50','',''),(2624891,'1','180','934',414,'Retail Sale Id 1619854',4620.00,0.00,0.00,6.00,468.00,'2022-07-05 08:17:03','',''),(2624892,'1','180','934',414,'Retail Sale Id 1619855',2310.00,0.00,0.00,3.00,234.00,'2022-07-05 08:18:00','',''),(2624893,'1','180','934',414,'Retail Sale Id 1619856',3850.00,0.00,0.00,5.00,390.00,'2022-07-05 09:00:46','',''),(2624894,'1','180','934',414,'Retail Sale Id 1619857',4620.00,0.00,0.00,6.00,468.00,'2022-07-05 09:01:41','',''),(2624895,'1','180','934',414,'Retail Sale Id 1619858',2310.00,0.00,0.00,3.00,234.00,'2022-07-05 09:02:52','',''),(2624896,'1','180','934',414,'Retail Sale Id 1619859',2302.30,0.00,0.00,2.99,233.22,'2022-07-05 09:04:16','',''),(2624897,'1','180','934',414,'Retail Sale Id 1619860',4620.00,0.00,0.00,6.00,468.00,'2022-07-05 09:58:39','',''),(2624898,'1','180','934',414,'Retail Sale Id 1619861',3850.00,0.00,0.00,5.00,390.00,'2022-07-05 09:59:34','',''),(2624899,'1','180','934',414,'Retail Sale Id 1619862',3503.50,0.00,0.00,4.55,354.90,'2022-07-05 10:01:12','',''),(2624900,'1','180','934',414,'Retail Sale Id 1619863',3003.00,0.00,0.00,3.90,304.20,'2022-07-05 11:09:28','',''),(2624901,'1','180','934',414,'Retail Sale Id 1619864',43200.00,0.00,0.00,60.00,1680.00,'2022-07-05 12:02:36','',''),(2624902,'1','180','934',414,'Retail Sale Id 1619865',43200.00,0.00,0.00,60.00,1680.00,'2022-07-05 12:03:59','',''),(2624903,'1','180','934',414,'Retail Sale Id 1619866',4581.50,0.00,0.00,5.95,464.10,'2022-07-05 12:42:33','',''),(2624904,'1','180','934',414,'Retail Sale Id 1619867',2310.00,0.00,0.00,3.00,234.00,'2022-07-05 12:45:10','',''),(2624905,'1','180','934',414,'Retail Sale Id 1619868',700.70,0.00,0.00,0.91,70.98,'2022-07-05 12:53:56','',''),(2624906,'1','180','934',414,'Retail Sale Id 1619869',2310.00,0.00,0.00,3.00,234.00,'2022-07-05 13:10:18','',''),(2624907,'1','180','934',414,'Retail Sale Id 1619870',3850.00,0.00,0.00,5.00,390.00,'2022-07-05 15:47:32','',''),(2624908,'1','180','934',414,'Retail Sale Id 1619871',2202.20,0.00,0.00,2.86,223.08,'2022-07-05 15:49:42','',''),(2624909,'1','180','934',414,'Retail Sale Id 1619872',9001.30,0.00,0.00,11.69,911.82,'2022-07-05 15:53:02','',''),(2624910,'1','180','934',414,'Retail Sale Id 1619873',2310.00,0.00,0.00,3.00,234.00,'2022-07-05 16:19:20','',''),(2624911,'1','180','934',414,'Retail Sale Id 1619874',3850.00,0.00,0.00,5.00,390.00,'2022-07-05 16:34:17','',''),(2624912,'1','180','934',414,'Retail Sale Id 1619875',4620.00,0.00,0.00,6.00,468.00,'2022-07-06 08:39:35','',''),(2624913,'1','180','934',414,'Retail Sale Id 1619876',3003.00,0.00,0.00,3.90,304.20,'2022-07-06 08:40:59','',''),(2624914,'1','180','934',414,'Retail Sale Id 1619877',4620.00,0.00,0.00,6.00,468.00,'2022-07-06 09:59:43','',''),(2624915,'1','180','934',414,'Retail Sale Id 1619878',3850.00,0.00,0.00,5.00,390.00,'2022-07-06 12:03:50','',''),(2624916,'1','180','934',414,'Retail Sale Id 1619879',2002.00,0.00,0.00,2.60,202.80,'2022-07-06 12:04:47','',''),(2624917,'1','180','934',414,'Retail Sale Id 1619880',1540.00,0.00,0.00,2.00,156.00,'2022-07-06 12:10:49','',''),(2624918,'1','180','934',414,'Retail Sale Id 1619881',600.60,0.00,0.00,0.78,60.84,'2022-07-06 12:12:03','',''),(2624919,'1','180','934',414,'Retail Sale Id 1619882',2002.00,0.00,0.00,2.60,202.80,'2022-07-06 12:27:20','',''),(2624920,'1','180','934',414,'Retail Sale Id 1619883',2310.00,0.00,0.00,3.00,234.00,'2022-07-06 12:37:22','',''),(2624921,'1','180','934',414,'Retail Sale Id 1619884',2202.20,0.00,0.00,2.86,223.08,'2022-07-06 12:38:22','',''),(2624922,'1','180','934',414,'Retail Sale Id 1619885',12705.00,0.00,0.00,16.50,1287.00,'2022-07-06 13:28:58','',''),(2624923,'1','180','934',414,'Retail Sale Id 1619886',2310.00,0.00,0.00,3.00,234.00,'2022-07-06 13:39:09','',''),(2624924,'1','180','934',414,'Retail Sale Id 1619887',4620.00,0.00,0.00,6.00,468.00,'2022-07-06 16:35:31','',''),(2624925,'1','180','934',414,'Retail Sale Id 1619888',3850.00,0.00,0.00,5.00,390.00,'2022-07-07 07:58:41','',''),(2624926,'1','180','934',414,'Retail Sale Id 1619889',3080.00,0.00,0.00,4.00,312.00,'2022-07-07 08:50:00','',''),(2624927,'1','180','934',414,'Retail Sale Id 1619890',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 08:50:50','',''),(2624928,'1','180','934',414,'Retail Sale Id 1619891',9625.00,0.00,0.00,12.50,975.00,'2022-07-07 09:15:22','',''),(2624929,'1','180','934',414,'Retail Sale Id 1619892',1501.50,0.00,0.00,1.95,152.10,'2022-07-07 09:16:35','',''),(2624930,'1','180','934',414,'Retail Sale Id 1619893',4620.00,0.00,0.00,6.00,468.00,'2022-07-07 09:38:19','',''),(2624931,'1','180','934',414,'Retail Sale Id 1619894',5097.40,0.00,0.00,6.62,516.36,'2022-07-07 09:48:44','',''),(2624932,'1','180','934',414,'Retail Sale Id 1619895',6999.30,0.00,0.00,9.09,709.02,'2022-07-07 09:51:46','',''),(2624933,'1','180','934',414,'Retail Sale Id 1619896',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 09:54:08','',''),(2624934,'1','180','934',414,'Retail Sale Id 1619897',2002.00,0.00,0.00,2.60,202.80,'2022-07-07 09:55:06','',''),(2624935,'1','180','934',414,'Retail Sale Id 1619898',3996.30,0.00,0.00,5.19,404.82,'2022-07-07 12:36:31','',''),(2624936,'1','180','934',414,'Retail Sale Id 1619899',6930.00,0.00,0.00,9.00,702.00,'2022-07-07 12:41:06','',''),(2624937,'1','180','934',414,'Retail Sale Id 1619900',3850.00,0.00,0.00,5.00,390.00,'2022-07-07 12:41:51','',''),(2624938,'1','180','934',414,'Retail Sale Id 1619901',2002.00,0.00,0.00,2.60,202.80,'2022-07-07 12:42:33','',''),(2624939,'1','180','934',414,'Retail Sale Id 1619902',1501.50,0.00,0.00,1.95,152.10,'2022-07-07 12:52:44','',''),(2624940,'1','180','934',414,'Retail Sale Id 1619903',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 13:18:44','',''),(2624941,'1','180','934',414,'Retail Sale Id 1619904',43200.00,0.00,0.00,60.00,1680.00,'2022-07-07 13:20:18','',''),(2624942,'1','180','934',414,'Retail Sale Id 1619905',3003.00,0.00,0.00,3.90,304.20,'2022-07-07 13:32:01','',''),(2624943,'1','180','934',414,'Retail Sale Id 1619906',3850.00,0.00,0.00,5.00,390.00,'2022-07-07 14:02:38','',''),(2624944,'1','180','934',414,'Retail Sale Id 1619907',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 14:21:43','',''),(2624945,'1','180','934',414,'Retail Sale Id 1619908',2002.00,0.00,0.00,2.60,202.80,'2022-07-07 14:28:48','',''),(2624946,'1','180','934',414,'Retail Sale Id 1619910',6160.00,0.00,0.00,8.00,624.00,'2022-07-07 14:52:00','',''),(2624947,'1','180','934',414,'Retail Sale Id 1619911',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 15:10:55','',''),(2624948,'1','180','934',414,'Retail Sale Id 1619912',800.80,0.00,0.00,1.04,81.12,'2022-07-07 15:24:12','',''),(2624949,'1','180','934',414,'Retail Sale Id 1619913',4620.00,0.00,0.00,6.00,468.00,'2022-07-07 16:50:11','',''),(2624950,'1','180','934',414,'Retail Sale Id 1619914',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 16:57:48','',''),(2624951,'1','180','934',414,'Retail Sale Id 1619915',4620.00,0.00,0.00,6.00,468.00,'2022-07-07 17:09:02','',''),(2624952,'1','180','934',414,'Retail Sale Id 1619916',3003.00,0.00,0.00,3.90,304.20,'2022-07-07 17:34:01','',''),(2624953,'1','180','934',414,'Retail Sale Id 1619917',8000.30,0.00,0.00,10.39,810.42,'2022-07-07 17:44:23','',''),(2624954,'1','180','934',414,'Retail Sale Id 1619918',5390.00,0.00,0.00,7.00,546.00,'2022-07-07 17:48:10','',''),(2624955,'1','180','934',414,'Retail Sale Id 1619919',5497.80,0.00,0.00,7.14,556.92,'2022-07-07 18:02:35','',''),(2624956,'1','180','934',414,'Retail Sale Id 1619920',4997.30,0.00,0.00,6.49,506.22,'2022-07-07 18:03:28','',''),(2624957,'1','180','934',414,'Retail Sale Id 1619921',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 18:08:07','',''),(2624958,'1','180','934',414,'Retail Sale Id 1619922',1540.00,0.00,0.00,2.00,156.00,'2022-07-07 18:15:32','',''),(2624959,'1','180','934',414,'Retail Sale Id 1619923',2002.00,0.00,0.00,2.60,202.80,'2022-07-07 18:16:49','',''),(2624960,'1','180','934',414,'Retail Sale Id 1619924',2310.00,0.00,0.00,3.00,234.00,'2022-07-07 18:40:06','',''),(2624961,'1','180','934',414,'Retail Sale Id 1619925',2002.00,0.00,0.00,2.60,202.80,'2022-07-08 10:16:06','',''),(2624962,'1','180','934',414,'Retail Sale Id 1619926',5497.80,0.00,0.00,7.14,556.92,'2022-07-08 10:22:46','',''),(2624963,'1','180','934',414,'Retail Sale Id 1619927',3996.30,0.00,0.00,5.19,404.82,'2022-07-08 10:24:02','',''),(2624964,'1','180','934',414,'Retail Sale Id 1619928',3996.30,0.00,0.00,5.19,404.82,'2022-07-08 11:07:55','',''),(2624965,'1','180','934',414,'Retail Sale Id 1619929',72000.00,0.00,0.00,100.00,2800.00,'2022-07-08 11:09:24','',''),(2624966,'1','180','934',414,'Retail Sale Id 1619930',8000.30,0.00,0.00,10.39,810.42,'2022-07-08 11:10:46','',''),(2624967,'1','180','934',414,'Retail Sale Id 1619931',3996.30,0.00,0.00,5.19,404.82,'2022-07-08 11:12:15','',''),(2624968,'1','180','934',414,'Retail Sale Id 1619932',4496.80,0.00,0.00,5.84,455.52,'2022-07-08 11:13:42','',''),(2624969,'1','180','934',414,'Retail Sale Id 1619933',4797.10,0.00,0.00,6.23,485.94,'2022-07-08 11:15:02','',''),(2624970,'1','180','934',414,'Retail Sale Id 1619934',3996.30,0.00,0.00,5.19,404.82,'2022-07-08 11:21:00','',''),(2624971,'1','180','934',414,'Retail Sale Id 1619935',2202.20,0.00,0.00,2.86,223.08,'2022-07-08 11:22:12','',''),(2624972,'1','180','934',414,'Retail Sale Id 1619936',2310.00,0.00,0.00,3.00,234.00,'2022-07-08 11:23:25','',''),(2624973,'1','180','934',414,'Retail Sale Id 1619937',3850.00,0.00,0.00,5.00,390.00,'2022-07-08 11:24:44','',''),(2624974,'1','180','934',414,'Retail Sale Id 1619938',4620.00,0.00,0.00,6.00,468.00,'2022-07-08 11:44:20','',''),(2624975,'1','180','934',414,'Retail Sale Id 1619939',7700.00,0.00,0.00,10.00,780.00,'2022-07-08 11:45:27','',''),(2624976,'1','180','934',414,'Retail Sale Id 1619940',2302.30,0.00,0.00,2.99,233.22,'2022-07-08 11:51:13','',''),(2624977,'1','180','934',414,'Retail Sale Id 1619941',3996.30,0.00,0.00,5.19,404.82,'2022-07-08 12:05:03','',''),(2624978,'1','180','934',414,'Retail Sale Id 1619942',3850.00,0.00,0.00,5.00,390.00,'2022-07-08 12:32:47','',''),(2624979,'1','180','934',414,'Retail Sale Id 1619943',9625.00,0.00,0.00,12.50,975.00,'2022-07-08 15:30:24','',''),(2624980,'1','180','934',414,'Retail Sale Id 1619944',4620.00,0.00,0.00,6.00,468.00,'2022-07-08 15:31:27','',''),(2624981,'1','180','934',414,'Retail Sale Id 1619945',2310.00,0.00,0.00,3.00,234.00,'2022-07-08 17:25:39','',''),(2624982,'1','180','934',414,'Retail Sale Id 1619946',2310.00,0.00,0.00,3.00,234.00,'2022-07-08 17:26:48','',''),(2624983,'1','180','934',414,'Retail Sale Id 1619947',2310.00,0.00,0.00,3.00,234.00,'2022-07-08 17:33:26','',''),(2624984,'1','180','934',414,'Retail Sale Id 1619948',3003.00,0.00,0.00,3.90,304.20,'2022-07-08 17:50:04','',''),(2624985,'1','180','934',414,'Retail Sale Id 1619949',2002.00,0.00,0.00,2.60,202.80,'2022-07-08 17:51:18','',''),(2624986,'1','180','934',414,'Retail Sale Id 1619950',2002.00,0.00,0.00,2.60,202.80,'2022-07-08 17:58:31','',''),(2624987,'1','180','934',414,'Retail Sale Id 1619951',9625.00,0.00,0.00,12.50,975.00,'2022-07-08 18:04:01','',''),(2624988,'1','180','934',414,'Retail Sale Id 1619952',4997.30,0.00,0.00,6.49,506.22,'2022-07-08 18:24:30','',''),(2624989,'1','180','934',414,'Retail Sale Id 1619953',72000.00,0.00,0.00,100.00,2800.00,'2022-07-08 19:55:32','',''),(2624990,'1','180','934',414,'Retail Sale Id 1619954',79200.00,0.00,0.00,110.00,3080.00,'2022-07-08 19:57:01','',''),(2624991,'1','180','934',414,'Retail Sale Id 1619955',4620.00,0.00,0.00,6.00,468.00,'2022-07-09 13:35:34','',''),(2624992,'1','180','934',414,'Retail Sale Id 1619956',4620.00,0.00,0.00,6.00,468.00,'2022-07-09 13:36:12','',''),(2624993,'1','180','934',414,'Retail Sale Id 1619957',3850.00,0.00,0.00,5.00,390.00,'2022-07-09 15:22:05','',''),(2624994,'1','180','934',414,'Retail Sale Id 1619958',4620.00,0.00,0.00,6.00,468.00,'2022-07-09 15:22:44','',''),(2624995,'1','180','934',414,'Retail Sale Id 1619959',1925.00,0.00,0.00,2.50,195.00,'2022-07-09 15:23:24','',''),(2624996,'1','180','934',414,'Retail Sale Id 1619960',9625.00,0.00,0.00,12.50,975.00,'2022-07-09 22:29:38','',''),(2624997,'1','180','934',414,'Retail Sale Id 1619961',9625.00,0.00,0.00,12.50,975.00,'2022-07-09 22:30:51','',''),(2624998,'1','180','934',414,'Retail Sale Id 1619962',4997.30,0.00,0.00,6.49,506.22,'2022-07-10 09:51:43','',''),(2624999,'1','180','934',414,'Retail Sale Id 1619963',4997.30,0.00,0.00,6.49,506.22,'2022-07-10 09:52:43','',''),(2625000,'1','180','934',414,'Retail Sale Id 1619964',2310.00,0.00,0.00,3.00,234.00,'2022-07-10 10:42:04','',''),(2625001,'1','180','934',414,'Retail Sale Id 1619965',3996.30,0.00,0.00,5.19,404.82,'2022-07-10 10:43:17','',''),(2625002,'1','180','934',414,'Retail Sale Id 1619966',3003.00,0.00,0.00,3.90,304.20,'2022-07-10 10:44:23','',''),(2625003,'1','180','934',414,'Retail Sale Id 1619967',1540.00,0.00,0.00,2.00,156.00,'2022-07-10 12:28:22','',''),(2625004,'1','180','934',414,'Retail Sale Id 1619968',1501.50,0.00,0.00,1.95,152.10,'2022-07-10 12:29:47','',''),(2625005,'1','180','934',414,'Retail Sale Id 1619969',1801.80,0.00,0.00,2.34,182.52,'2022-07-10 12:31:08','',''),(2625006,'1','180','934',414,'Retail Sale Id 1619970',3850.00,0.00,0.00,5.00,390.00,'2022-07-10 14:14:23','',''),(2625007,'1','180','934',414,'Retail Sale Id 1619971',2002.00,0.00,0.00,2.60,202.80,'2022-07-10 14:15:48','',''),(2625008,'1','180','934',414,'Retail Sale Id 1619972',2310.00,0.00,0.00,3.00,234.00,'2022-07-10 14:17:05','',''),(2625009,'1','180','934',414,'Retail Sale Id 1619973',3996.30,0.00,0.00,5.19,404.82,'2022-07-10 14:25:56','',''),(2625010,'1','180','934',414,'Retail Sale Id 1619974',6930.00,0.00,0.00,9.00,702.00,'2022-07-10 14:41:21','',''),(2625011,'1','180','934',414,'Retail Sale Id 1619975',2310.00,0.00,0.00,3.00,234.00,'2022-07-10 15:23:45','',''),(2625012,'1','180','934',414,'Retail Sale Id 1619976',770.00,0.00,0.00,1.00,78.00,'2022-07-10 15:47:17','',''),(2625013,'1','180','934',414,'Retail Sale Id 1619977',1771.00,0.00,0.00,2.30,179.40,'2022-07-10 15:48:20','',''),(2625014,'1','180','934',414,'Retail Sale Id 1619978',1601.60,0.00,0.00,2.08,162.24,'2022-07-10 16:11:13','',''),(2625015,'1','180','934',414,'Retail Sale Id 1619979',43200.00,0.00,0.00,60.00,1680.00,'2022-07-10 19:21:29','',''),(2625016,'1','180','934',414,'Retail Sale Id 1619980',9625.00,0.00,0.00,12.50,975.00,'2022-07-11 09:06:20','',''),(2625017,'1','180','934',414,'Retail Sale Id 1619981',2310.00,0.00,0.00,3.00,234.00,'2022-07-11 09:07:26','',''),(2625018,'1','180','934',414,'Retail Sale Id 1619982',2310.00,0.00,0.00,3.00,234.00,'2022-07-11 09:08:41','',''),(2625019,'1','180','934',414,'Retail Sale Id 1619983',2002.00,0.00,0.00,2.60,202.80,'2022-07-11 09:09:41','',''),(2625020,'1','180','934',414,'Retail Sale Id 1619984',9625.00,0.00,0.00,12.50,975.00,'2022-07-11 10:46:14','',''),(2625021,'1','180','934',414,'Retail Sale Id 1619985',1540.00,0.00,0.00,2.00,156.00,'2022-07-11 10:47:10','',''),(2625022,'1','180','934',414,'Retail Sale Id 1619987',4620.00,0.00,0.00,6.00,468.00,'2022-07-11 11:23:29','',''),(2625023,'1','180','934',414,'Retail Sale Id 1619988',2310.00,0.00,0.00,3.00,234.00,'2022-07-11 12:32:42','',''),(2625024,'1','180','934',414,'Retail Sale Id 1619989',1801.80,0.00,0.00,2.34,182.52,'2022-07-11 12:34:12','',''),(2625025,'1','180','934',414,'Retail Sale Id 1619990',4620.00,0.00,0.00,6.00,468.00,'2022-07-11 12:35:05','',''),(2625026,'1','180','934',414,'Retail Sale Id 1619991',9625.00,0.00,0.00,12.50,975.00,'2022-07-11 14:44:44','',''),(2625027,'1','180','934',414,'Retail Sale Id 1619992',2310.00,0.00,0.00,3.00,234.00,'2022-07-11 14:45:35','',''),(2625028,'1','180','934',414,'Retail Sale Id 1619993',3703.70,0.00,0.00,4.81,375.18,'2022-07-11 14:46:29','',''),(2625029,'1','180','934',414,'Retail Sale Id 1619994',4620.00,0.00,0.00,6.00,468.00,'2022-07-11 16:30:43','',''),(2625030,'1','180','934',414,'Retail Sale Id 1619995',1501.50,0.00,0.00,1.95,152.10,'2022-07-11 16:31:41','',''),(2625031,'1','180','934',414,'Retail Sale Id 1619996',43200.00,0.00,0.00,60.00,1680.00,'2022-07-11 18:53:27','',''),(2625032,'1','180','934',414,'Retail Sale Id 1619997',43200.00,0.00,0.00,60.00,1680.00,'2022-07-11 18:54:40','',''),(2625033,'1','180','934',414,'Retail Sale Id 1619998',43200.00,0.00,0.00,60.00,1680.00,'2022-07-11 18:55:18','',''),(2625034,'1','180','934',414,'Retail Sale Id 1619999',72000.00,0.00,0.00,100.00,2800.00,'2022-07-12 09:54:58','',''),(2625035,'1','180','934',414,'Retail Sale Id 1620000',4620.00,0.00,0.00,6.00,468.00,'2022-07-12 09:56:21','',''),(2625036,'1','180','934',414,'Retail Sale Id 1620001',2002.00,0.00,0.00,2.60,202.80,'2022-07-12 09:57:33','',''),(2625037,'1','180','934',414,'Retail Sale Id 1620002',2310.00,0.00,0.00,3.00,234.00,'2022-07-12 09:58:21','',''),(2625038,'1','180','934',414,'Retail Sale Id 1620003',1001.00,0.00,0.00,1.30,101.40,'2022-07-12 09:59:17','',''),(2625039,'1','180','934',414,'Retail Sale Id 1620004',1001.00,0.00,0.00,1.30,101.40,'2022-07-12 14:25:19','',''),(2625040,'1','180','934',414,'Retail Sale Id 1620005',36000.00,0.00,0.00,50.00,1400.00,'2022-07-12 14:36:40','',''),(2625041,'1','180','934',414,'Retail Sale Id 1620006',8747.20,0.00,0.00,11.36,886.08,'2022-07-12 14:51:13','',''),(2625042,'1','180','934',414,'Retail Sale Id 1620007',10433.50,0.00,0.00,13.55,1056.90,'2022-07-12 20:41:15','',''),(2625043,'1','180','934',414,'Retail Sale Id 1620008',3850.00,0.00,0.00,5.00,390.00,'2022-07-13 09:21:16','',''),(2625044,'1','180','934',414,'Retail Sale Id 1620009',2310.00,0.00,0.00,3.00,234.00,'2022-07-13 09:22:26','',''),(2625045,'1','180','934',414,'Retail Sale Id 1620010',4620.00,0.00,0.00,6.00,468.00,'2022-07-13 10:08:11','',''),(2625046,'1','180','934',414,'Retail Sale Id 1620011',2310.00,0.00,0.00,3.00,234.00,'2022-07-13 10:09:21','',''),(2625047,'1','180','934',414,'Retail Sale Id 1620012',2002.00,0.00,0.00,2.60,202.80,'2022-07-13 10:19:06','',''),(2625048,'1','180','934',414,'Retail Sale Id 1620013',3996.30,0.00,0.00,5.19,404.82,'2022-07-13 10:27:42','',''),(2625049,'1','180','934',414,'Retail Sale Id 1620014',4496.80,0.00,0.00,5.84,455.52,'2022-07-13 10:49:43','',''),(2625050,'1','180','934',414,'Retail Sale Id 1620015',3850.00,0.00,0.00,5.00,390.00,'2022-07-13 11:52:34','',''),(2625051,'1','180','934',414,'Retail Sale Id 1620016',19250.00,0.00,0.00,25.00,1950.00,'2022-07-13 11:53:50','',''),(2625052,'1','180','934',414,'Retail Sale Id 1620017',1540.00,0.00,0.00,2.00,156.00,'2022-07-13 12:51:58','',''),(2625053,'1','180','934',414,'Retail Sale Id 1620018',1001.00,0.00,0.00,1.30,101.40,'2022-07-13 13:13:11','',''),(2625054,'1','180','934',414,'Retail Sale Id 1620019',3850.00,0.00,0.00,5.00,390.00,'2022-07-13 14:07:41','',''),(2625055,'1','180','934',414,'Retail Sale Id 1620021',2310.00,0.00,0.00,3.00,234.00,'2022-07-13 15:01:57','',''),(2625056,'1','180','934',414,'Retail Sale Id 1620022',25471.60,0.00,0.00,33.08,2580.24,'2022-07-13 18:51:26','',''),(2625057,'1','180','934',414,'Retail Sale Id 1620023',100800.00,0.00,0.00,140.00,3920.00,'2022-07-13 18:52:19','',''),(2625058,'1','180','934',414,'Retail Sale Id 1620024',43200.00,0.00,0.00,60.00,1680.00,'2022-07-14 09:24:24','',''),(2625059,'1','180','934',414,'Retail Sale Id 1620025',3850.00,0.00,0.00,5.00,390.00,'2022-07-14 09:25:31','',''),(2625060,'1','180','934',414,'Retail Sale Id 1620026',43200.00,0.00,0.00,60.00,1680.00,'2022-07-14 18:17:45','',''),(2625061,'1','180','934',414,'Retail Sale Id 1620027',2310.00,0.00,0.00,3.00,234.00,'2022-07-14 18:18:23','',''),(2625062,'1','180','934',414,'Retail Sale Id 1620028',9625.00,0.00,0.00,12.50,975.00,'2022-07-14 18:19:15','',''),(2625063,'1','180','934',414,'Retail Sale Id 1620029',5397.70,0.00,0.00,7.01,546.78,'2022-07-14 18:24:05','',''),(2625064,'1','180','934',414,'Retail Sale Id 1620030',2002.00,0.00,0.00,2.60,202.80,'2022-07-14 18:44:55','',''),(2625065,'1','180','934',414,'Retail Sale Id 1620031',4620.00,0.00,0.00,6.00,468.00,'2022-07-15 08:05:49','',''),(2625066,'1','180','934',414,'Retail Sale Id 1620032',5390.00,0.00,0.00,7.00,546.00,'2022-07-15 08:47:52','',''),(2625067,'1','180','934',414,'Retail Sale Id 1620033',9625.00,0.00,0.00,12.50,975.00,'2022-07-15 09:53:43','',''),(2625068,'1','180','934',414,'Retail Sale Id 1620034',9625.00,0.00,0.00,12.50,975.00,'2022-07-15 10:20:39','',''),(2625069,'1','180','934',414,'Retail Sale Id 1620035',1701.70,0.00,0.00,2.21,172.38,'2022-07-15 10:52:51','',''),(2625070,'1','180','934',414,'Retail Sale Id 1620036',4620.00,0.00,0.00,6.00,468.00,'2022-07-15 11:11:37','',''),(2625071,'1','180','934',414,'Retail Sale Id 1620037',2002.00,0.00,0.00,2.60,202.80,'2022-07-15 11:38:14','',''),(2625072,'1','180','934',414,'Retail Sale Id 1620038',3311.00,0.00,0.00,4.30,335.40,'2022-07-15 12:28:57','',''),(2625073,'1','180','934',414,'Retail Sale Id 1620039',31570.00,0.00,0.00,41.00,3198.00,'2022-07-15 21:12:50','',''),(2625074,'1','180','934',414,'Retail Sale Id 1620040',36000.00,0.00,0.00,50.00,1400.00,'2022-07-15 21:14:27','',''),(2625075,'1','180','934',414,'Retail Sale Id 1620041',86400.00,0.00,0.00,120.00,3360.00,'2022-07-16 09:52:52','',''),(2625076,'1','180','934',414,'Retail Sale Id 1620042',3850.00,0.00,0.00,5.00,390.00,'2022-07-16 10:12:46','',''),(2625077,'1','180','934',414,'Retail Sale Id 1620043',3080.00,0.00,0.00,4.00,312.00,'2022-07-16 10:31:27','',''),(2625078,'1','180','934',414,'Retail Sale Id 1620044',8470.00,0.00,0.00,11.00,858.00,'2022-07-16 10:42:17','',''),(2625079,'1','180','934',414,'Retail Sale Id 1620045',4620.00,0.00,0.00,6.00,468.00,'2022-07-16 11:10:28','',''),(2625080,'1','180','934',414,'Retail Sale Id 1620046',9625.00,0.00,0.00,12.50,975.00,'2022-07-16 11:24:02','',''),(2625081,'1','180','934',414,'Retail Sale Id 1620047',2310.00,0.00,0.00,3.00,234.00,'2022-07-16 12:49:00','',''),(2625082,'1','180','934',414,'Retail Sale Id 1620048',2502.50,0.00,0.00,3.25,253.50,'2022-07-16 12:50:46','',''),(2625083,'1','180','934',414,'Retail Sale Id 1620049',4620.00,0.00,0.00,6.00,468.00,'2022-07-16 13:09:36','',''),(2625084,'1','180','934',414,'Retail Sale Id 1620050',500.50,0.00,0.00,0.65,50.70,'2022-07-16 13:10:31','',''),(2625085,'1','180','934',414,'Retail Sale Id 1620051',4620.00,0.00,0.00,6.00,468.00,'2022-07-16 14:46:24','',''),(2625086,'1','180','934',414,'Retail Sale Id 1620052',2002.00,0.00,0.00,2.60,202.80,'2022-07-16 14:51:28','',''),(2625087,'1','180','934',414,'Retail Sale Id 1620053',2310.00,0.00,0.00,3.00,234.00,'2022-07-16 16:14:33','',''),(2625088,'1','180','934',414,'Retail Sale Id 1620054',5390.00,0.00,0.00,7.00,546.00,'2022-07-16 16:46:36','',''),(2625089,'1','180','934',414,'Retail Sale Id 1620055',3080.00,0.00,0.00,4.00,312.00,'2022-07-16 18:19:46','',''),(2625090,'1','180','934',414,'Retail Sale Id 1620056',3003.00,0.00,0.00,3.90,304.20,'2022-07-16 18:20:41','',''),(2625091,'1','180','934',414,'Retail Sale Id 1620057',770.00,0.00,0.00,1.00,78.00,'2022-07-16 18:26:28','',''),(2625092,'1','180','934',414,'Retail Sale Id 1620058',4997.30,0.00,0.00,6.49,506.22,'2022-07-17 08:53:43','',''),(2625093,'1','180','934',414,'Retail Sale Id 1620059',4620.00,0.00,0.00,6.00,468.00,'2022-07-17 11:17:45','',''),(2625094,'1','180','934',414,'Retail Sale Id 1620060',3996.30,0.00,0.00,5.19,404.82,'2022-07-17 11:18:44','',''),(2625095,'1','180','934',414,'Retail Sale Id 1620061',1901.90,0.00,0.00,2.47,192.66,'2022-07-17 11:19:54','',''),(2625096,'1','180','934',414,'Retail Sale Id 1620062',2310.00,0.00,0.00,3.00,234.00,'2022-07-17 11:20:56','',''),(2625097,'1','180','934',414,'Retail Sale Id 1620063',3996.30,0.00,0.00,5.19,404.82,'2022-07-17 11:22:16','',''),(2625098,'1','180','934',414,'Retail Sale Id 1620064',2279.20,0.00,0.00,2.96,230.88,'2022-07-17 12:17:24','',''),(2625099,'1','180','934',414,'Retail Sale Id 1620065',2002.00,0.00,0.00,2.60,202.80,'2022-07-17 12:18:38','',''),(2625100,'1','180','934',414,'Retail Sale Id 1620066',9625.00,0.00,0.00,12.50,975.00,'2022-07-17 12:20:08','',''),(2625101,'1','180','934',414,'Retail Sale Id 1620067',3996.30,0.00,0.00,5.19,404.82,'2022-07-17 12:21:07','',''),(2625102,'1','180','934',414,'Retail Sale Id 1620069',4620.00,0.00,0.00,6.00,468.00,'2022-07-17 12:22:05','',''),(2625103,'1','180','934',414,'Retail Sale Id 1620070',3003.00,0.00,0.00,3.90,304.20,'2022-07-17 14:13:44','',''),(2625104,'1','180','934',414,'Retail Sale Id 1620071',770.00,0.00,0.00,1.00,78.00,'2022-07-17 14:14:42','',''),(2625105,'1','180','934',414,'Retail Sale Id 1620072',86400.00,0.00,0.00,120.00,3360.00,'2022-07-17 15:25:14','',''),(2625106,'1','180','934',414,'Retail Sale Id 1620073',4196.50,0.00,0.00,5.45,425.10,'2022-07-17 16:06:34','',''),(2625107,'1','180','934',414,'Retail Sale Id 1620074',1540.00,0.00,0.00,2.00,156.00,'2022-07-17 16:56:06','',''),(2625108,'1','180','934',414,'Retail Sale Id 1620075',3850.00,0.00,0.00,5.00,390.00,'2022-07-17 17:42:21','',''),(2625109,'1','180','934',414,'Retail Sale Id 1620076',1001.00,0.00,0.00,1.30,101.40,'2022-07-17 17:44:36','',''),(2625110,'1','180','934',414,'Retail Sale Id 1620077',3003.00,0.00,0.00,3.90,304.20,'2022-07-17 18:21:44','',''),(2625111,'1','180','934',414,'Retail Sale Id 1620078',2310.00,0.00,0.00,3.00,234.00,'2022-07-17 18:41:41','',''),(2625112,'1','180','934',414,'Retail Sale Id 1620079',3080.00,0.00,0.00,4.00,312.00,'2022-07-18 10:52:35','',''),(2625113,'1','180','934',414,'Retail Sale Id 1620080',4620.00,0.00,0.00,6.00,468.00,'2022-07-18 10:53:31','',''),(2625114,'1','180','934',414,'Retail Sale Id 1620081',2310.00,0.00,0.00,3.00,234.00,'2022-07-18 12:08:32','',''),(2625115,'1','180','934',414,'Retail Sale Id 1620082',3503.50,0.00,0.00,4.55,354.90,'2022-07-18 13:34:37','',''),(2625116,'1','180','934',414,'Retail Sale Id 1620083',3080.00,0.00,0.00,4.00,312.00,'2022-07-18 14:12:12','',''),(2625117,'1','180','934',414,'Retail Sale Id 1620084',129600.00,0.00,0.00,180.00,5040.00,'2022-07-18 15:02:53','',''),(2625118,'1','180','934',414,'Retail Sale Id 1620085',4620.00,0.00,0.00,6.00,468.00,'2022-07-18 15:10:34','',''),(2625119,'1','180','934',414,'Retail Sale Id 1620086',2310.00,0.00,0.00,3.00,234.00,'2022-07-18 15:28:10','',''),(2625120,'1','180','934',414,'Retail Sale Id 1620087',1501.50,0.00,0.00,1.95,152.10,'2022-07-18 15:38:45','',''),(2625121,'1','180','934',414,'Retail Sale Id 1620088',4620.00,0.00,0.00,6.00,468.00,'2022-07-18 16:23:45','',''),(2625122,'1','180','934',414,'Retail Sale Id 1620089',4620.00,0.00,0.00,6.00,468.00,'2022-07-18 17:00:48','',''),(2625123,'1','180','934',414,'Retail Sale Id 1620090',1001.00,0.00,0.00,1.30,101.40,'2022-07-18 17:03:44','',''),(2625124,'1','180','934',414,'Retail Sale Id 1620091',9625.00,0.00,0.00,12.50,975.00,'2022-07-18 17:04:55','',''),(2625125,'1','180','934',414,'Retail Sale Id 1620092',3850.00,0.00,0.00,5.00,390.00,'2022-07-18 18:01:11','',''),(2625126,'1','180','934',414,'Retail Sale Id 1620093',9625.00,0.00,0.00,12.50,975.00,'2022-07-18 18:37:13','',''),(2625127,'1','180','934',414,'Retail Sale Id 1620094',3080.00,0.00,0.00,4.00,312.00,'2022-07-18 18:47:19','',''),(2625128,'1','180','934',414,'Retail Sale Id 1620095',4620.00,0.00,0.00,6.00,468.00,'2022-07-18 18:48:49','',''),(2625129,'1','180','934',414,'Retail Sale Id 1620096',4620.00,0.00,0.00,6.00,468.00,'2022-07-19 08:30:04','',''),(2625130,'1','180','934',414,'Retail Sale Id 1620097',9001.30,0.00,0.00,11.69,911.82,'2022-07-19 08:47:49','',''),(2625131,'1','180','934',414,'Retail Sale Id 1620098',3080.00,0.00,0.00,4.00,312.00,'2022-07-19 09:46:16','',''),(2625132,'1','180','934',414,'Retail Sale Id 1620099',4620.00,0.00,0.00,6.00,468.00,'2022-07-19 09:47:06','',''),(2625133,'1','180','934',414,'Retail Sale Id 1620100',4997.30,0.00,0.00,6.49,506.22,'2022-07-19 09:47:58','',''),(2625134,'1','180','934',414,'Retail Sale Id 1620101',2310.00,0.00,0.00,3.00,234.00,'2022-07-19 09:48:58','',''),(2625135,'1','180','934',414,'Retail Sale Id 1620102',3003.00,0.00,0.00,3.90,304.20,'2022-07-19 09:50:00','',''),(2625136,'1','180','934',414,'Retail Sale Id 1620103',3850.00,0.00,0.00,5.00,390.00,'2022-07-19 10:12:19','',''),(2625137,'1','180','934',414,'Retail Sale Id 1620104',4620.00,0.00,0.00,6.00,468.00,'2022-07-19 10:38:56','',''),(2625138,'1','180','934',414,'Retail Sale Id 1620105',2310.00,0.00,0.00,3.00,234.00,'2022-07-19 11:14:37','',''),(2625139,'1','180','934',414,'Retail Sale Id 1620106',2502.50,0.00,0.00,3.25,253.50,'2022-07-19 11:32:44','',''),(2625140,'1','180','934',414,'Retail Sale Id 1620107',9001.30,0.00,0.00,11.69,911.82,'2022-07-19 11:33:50','',''),(2625141,'1','180','934',414,'Retail Sale Id 1620108',5390.00,0.00,0.00,7.00,546.00,'2022-07-19 12:48:04','',''),(2625142,'1','180','934',414,'Retail Sale Id 1620109',1001.00,0.00,0.00,1.30,101.40,'2022-07-19 12:48:58','',''),(2625143,'1','180','934',414,'Retail Sale Id 1620110',2502.50,0.00,0.00,3.25,253.50,'2022-07-19 13:05:35','',''),(2625144,'1','180','934',414,'Retail Sale Id 1620111',2002.00,0.00,0.00,2.60,202.80,'2022-07-19 13:34:38','',''),(2625145,'1','180','934',414,'Retail Sale Id 1620112',1001.00,0.00,0.00,1.30,101.40,'2022-07-19 14:24:01','',''),(2625146,'1','180','934',414,'Retail Sale Id 1620113',2310.00,0.00,0.00,3.00,234.00,'2022-07-19 15:26:03','',''),(2625147,'1','180','934',414,'Retail Sale Id 1620114',50400.00,0.00,0.00,70.00,1960.00,'2022-07-19 16:10:04','',''),(2625148,'1','180','934',414,'Retail Sale Id 1620115',3080.00,0.00,0.00,4.00,312.00,'2022-07-19 16:16:23','',''),(2625149,'1','180','934',414,'Retail Sale Id 1620116',2310.00,0.00,0.00,3.00,234.00,'2022-07-19 16:36:14','',''),(2625150,'1','180','934',414,'Retail Sale Id 1620117',3080.00,0.00,0.00,4.00,312.00,'2022-07-19 17:02:32','',''),(2625151,'1','180','934',414,'Retail Sale Id 1620118',3003.00,0.00,0.00,3.90,304.20,'2022-07-20 08:18:23','',''),(2625152,'1','180','934',414,'Retail Sale Id 1620119',3850.00,0.00,0.00,5.00,390.00,'2022-07-20 09:03:19','',''),(2625153,'1','180','934',414,'Retail Sale Id 1620120',2310.00,0.00,0.00,3.00,234.00,'2022-07-20 09:04:25','',''),(2625154,'1','180','934',414,'Retail Sale Id 1620121',3850.00,0.00,0.00,5.00,390.00,'2022-07-20 10:48:39','',''),(2625155,'1','180','934',414,'Retail Sale Id 1620122',4620.00,0.00,0.00,6.00,468.00,'2022-07-20 11:25:01','',''),(2625156,'1','180','934',414,'Retail Sale Id 1620123',4620.00,0.00,0.00,6.00,468.00,'2022-07-20 11:40:19','',''),(2625157,'1','180','934',414,'Retail Sale Id 1620124',2002.00,0.00,0.00,2.60,202.80,'2022-07-20 12:05:31','',''),(2625158,'1','180','934',414,'Retail Sale Id 1620125',1001.00,0.00,0.00,1.30,101.40,'2022-07-20 14:10:53','',''),(2625159,'1','180','934',414,'Retail Sale Id 1620126',9625.00,0.00,0.00,12.50,975.00,'2022-07-20 16:01:25','',''),(2625160,'1','180','934',414,'Retail Sale Id 1620127',1501.50,0.00,0.00,1.95,152.10,'2022-07-20 17:16:31','',''),(2625161,'1','180','934',414,'Retail Sale Id 1620128',3996.30,0.00,0.00,5.19,404.82,'2022-07-20 17:48:30','',''),(2625162,'1','180','934',414,'Retail Sale Id 1620129',1201.20,0.00,0.00,1.56,121.68,'2022-07-20 18:07:57','',''),(2625163,'1','180','934',414,'Retail Sale Id 1620130',2310.00,0.00,0.00,3.00,234.00,'2022-07-20 18:14:11','',''),(2625164,'1','180','934',414,'Retail Sale Id 1620131',2002.00,0.00,0.00,2.60,202.80,'2022-07-20 18:34:31','',''),(2625165,'1','180','934',414,'Retail Sale Id 1620132',4620.00,0.00,0.00,6.00,468.00,'2022-07-20 18:52:22','',''),(2625166,'1','180','934',414,'Retail Sale Id 1620133',2310.00,0.00,0.00,3.00,234.00,'2022-07-21 08:57:59','',''),(2625167,'1','180','934',414,'Retail Sale Id 1620134',1001.00,0.00,0.00,1.30,101.40,'2022-07-21 08:59:11','',''),(2625168,'1','180','934',414,'Retail Sale Id 1620135',2002.00,0.00,0.00,2.60,202.80,'2022-07-21 09:33:33','',''),(2625169,'1','180','934',414,'Retail Sale Id 1620136',2310.00,0.00,0.00,3.00,234.00,'2022-07-21 10:22:04','',''),(2625170,'1','180','934',414,'Retail Sale Id 1620137',2202.20,0.00,0.00,2.86,223.08,'2022-07-21 11:03:58','',''),(2625171,'1','180','934',414,'Retail Sale Id 1620138',2310.00,0.00,0.00,3.00,234.00,'2022-07-21 12:54:31','',''),(2625172,'1','180','934',414,'Retail Sale Id 1620139',3703.70,0.00,0.00,4.81,375.18,'2022-07-21 12:55:52','',''),(2625173,'1','180','934',414,'Retail Sale Id 1620140',4620.00,0.00,0.00,6.00,468.00,'2022-07-21 13:56:00','',''),(2625174,'1','180','934',414,'Retail Sale Id 1620141',3996.30,0.00,0.00,5.19,404.82,'2022-07-21 16:55:59','',''),(2625175,'1','180','934',414,'Retail Sale Id 1620142',1540.00,0.00,0.00,2.00,156.00,'2022-07-21 16:56:59','',''),(2625176,'1','180','934',414,'Retail Sale Id 1620143',1001.00,0.00,0.00,1.30,101.40,'2022-07-21 16:58:17','',''),(2625177,'1','180','934',414,'Retail Sale Id 1620144',770.00,0.00,0.00,1.00,78.00,'2022-07-21 16:59:09','',''),(2625178,'1','180','934',414,'Retail Sale Id 1620145',2310.00,0.00,0.00,3.00,234.00,'2022-07-21 17:25:28','',''),(2625179,'1','180','934',414,'Retail Sale Id 1620146',2002.00,0.00,0.00,2.60,202.80,'2022-07-21 18:18:37','',''),(2625180,'1','180','934',414,'Retail Sale Id 1620147',800.80,0.00,0.00,1.04,81.12,'2022-07-21 18:20:34','',''),(2625181,'1','180','934',414,'Retail Sale Id 1620148',3703.70,0.00,0.00,4.81,375.18,'2022-07-21 18:32:39','',''),(2625182,'1','180','934',414,'Retail Sale Id 1620149',4620.00,0.00,0.00,6.00,468.00,'2022-07-22 08:53:52','',''),(2625183,'1','180','934',414,'Retail Sale Id 1620150',4620.00,0.00,0.00,6.00,468.00,'2022-07-22 08:55:46','',''),(2625184,'1','180','934',414,'Retail Sale Id 1620151',2002.00,0.00,0.00,2.60,202.80,'2022-07-22 08:56:57','',''),(2625185,'1','180','934',414,'Retail Sale Id 1620152',3003.00,0.00,0.00,3.90,304.20,'2022-07-22 08:58:25','',''),(2625186,'1','180','934',414,'Retail Sale Id 1620153',6930.00,0.00,0.00,9.00,702.00,'2022-07-22 10:15:50','',''),(2625187,'1','180','934',414,'Retail Sale Id 1620154',6999.30,0.00,0.00,9.09,709.02,'2022-07-22 10:43:55','',''),(2625188,'1','180','934',414,'Retail Sale Id 1620155',1540.00,0.00,0.00,2.00,156.00,'2022-07-22 10:46:09','',''),(2625189,'1','180','934',414,'Retail Sale Id 1620156',2310.00,0.00,0.00,3.00,234.00,'2022-07-22 11:53:39','',''),(2625190,'1','180','934',414,'Retail Sale Id 1620157',4620.00,0.00,0.00,6.00,468.00,'2022-07-22 13:03:29','',''),(2625191,'1','180','934',414,'Retail Sale Id 1620158',4620.00,0.00,0.00,6.00,468.00,'2022-07-22 16:43:59','',''),(2625192,'1','180','934',414,'Retail Sale Id 1620159',1601.60,0.00,0.00,2.08,162.24,'2022-07-22 16:52:17','',''),(2625193,'1','180','934',414,'Retail Sale Id 1620161',2310.00,0.00,0.00,3.00,234.00,'2022-07-22 16:53:15','',''),(2625194,'1','180','934',414,'Retail Sale Id 1620162',3080.00,0.00,0.00,4.00,312.00,'2022-07-22 16:55:24','',''),(2625195,'1','180','934',414,'Retail Sale Id 1620163',4620.00,0.00,0.00,6.00,468.00,'2022-07-22 16:56:44','',''),(2625196,'1','180','934',414,'Retail Sale Id 1620164',2502.50,0.00,0.00,3.25,253.50,'2022-07-22 17:00:28','',''),(2625197,'1','180','934',414,'Retail Sale Id 1620165',2702.70,0.00,0.00,3.51,273.78,'2022-07-22 18:05:59','',''),(2625198,'1','180','934',414,'Retail Sale Id 1620166',2310.00,0.00,0.00,3.00,234.00,'2022-07-22 18:22:31','',''),(2625199,'1','180','934',414,'Retail Sale Id 1620167',79200.00,0.00,0.00,110.00,3080.00,'2022-07-22 20:13:41','',''),(2625200,'1','180','934',414,'Retail Sale Id 1620168',3080.00,0.00,0.00,4.00,312.00,'2022-07-23 08:59:32','',''),(2625201,'1','180','934',414,'Retail Sale Id 1620169',2002.00,0.00,0.00,2.60,202.80,'2022-07-23 09:01:01','',''),(2625202,'1','180','934',414,'Retail Sale Id 1620170',3003.00,0.00,0.00,3.90,304.20,'2022-07-23 09:45:16','',''),(2625203,'1','180','934',414,'Retail Sale Id 1620171',9625.00,0.00,0.00,12.50,975.00,'2022-07-23 10:11:56','',''),(2625204,'1','180','934',414,'Retail Sale Id 1620172',19250.00,0.00,0.00,25.00,1950.00,'2022-07-23 11:47:27','',''),(2625205,'1','180','934',414,'Retail Sale Id 1620173',770.00,0.00,0.00,1.00,78.00,'2022-07-23 11:49:05','',''),(2625206,'1','180','934',414,'Retail Sale Id 1620174',2202.20,0.00,0.00,2.86,223.08,'2022-07-23 12:48:04','',''),(2625207,'1','180','934',414,'Retail Sale Id 1620175',2310.00,0.00,0.00,3.00,234.00,'2022-07-23 12:49:01','',''),(2625208,'1','180','934',414,'Retail Sale Id 1620176',3850.00,0.00,0.00,5.00,390.00,'2022-07-23 12:50:16','',''),(2625209,'1','180','934',414,'Retail Sale Id 1620177',2310.00,0.00,0.00,3.00,234.00,'2022-07-23 15:49:38','',''),(2625210,'1','180','934',414,'Retail Sale Id 1620178',2002.00,0.00,0.00,2.60,202.80,'2022-07-23 15:51:35','',''),(2625211,'1','180','934',414,'Retail Sale Id 1620179',2310.00,0.00,0.00,3.00,234.00,'2022-07-23 16:00:34','',''),(2625212,'1','180','934',414,'Retail Sale Id 1620180',4620.00,0.00,0.00,6.00,468.00,'2022-07-23 17:13:25','',''),(2625213,'1','180','934',414,'Retail Sale Id 1620181',2002.00,0.00,0.00,2.60,202.80,'2022-07-23 17:14:45','',''),(2625214,'1','180','934',414,'Retail Sale Id 1620182',770.00,0.00,0.00,1.00,78.00,'2022-07-23 17:16:19','',''),(2625215,'1','180','934',414,'Retail Sale Id 1620183',6999.30,0.00,0.00,9.09,709.02,'2022-07-23 18:12:36','',''),(2625216,'1','180','934',414,'Retail Sale Id 1620184',4496.80,0.00,0.00,5.84,455.52,'2022-07-23 18:20:45','',''),(2625217,'1','180','934',414,'Retail Sale Id 1620185',1001.00,0.00,0.00,1.30,101.40,'2022-07-23 18:57:30','',''),(2625218,'1','180','934',414,'Retail Sale Id 1620186',9625.00,0.00,0.00,12.50,975.00,'2022-07-23 18:58:32','',''),(2625219,'1','180','934',414,'Retail Sale Id 1620187',1501.50,0.00,0.00,1.95,152.10,'2022-07-23 18:59:30','',''),(2625220,'1','180','934',414,'Retail Sale Id 1620189',9001.30,0.00,0.00,11.69,911.82,'2022-07-23 19:08:08','',''),(2625221,'1','180','934',414,'Retail Sale Id 1620190',2502.50,0.00,0.00,3.25,253.50,'2022-07-23 19:08:56','',''),(2625222,'1','180','934',414,'Retail Sale Id 1620191',4620.00,0.00,0.00,6.00,468.00,'2022-07-23 19:09:46','',''),(2625223,'1','180','934',414,'Retail Sale Id 1620192',126000.00,0.00,0.00,175.00,4900.00,'2022-07-23 19:51:56','',''),(2625224,'1','180','934',414,'Retail Sale Id 1620193',3003.00,0.00,0.00,3.90,304.20,'2022-07-24 09:12:28','',''),(2625225,'1','180','934',414,'Retail Sale Id 1620194',3850.00,0.00,0.00,5.00,390.00,'2022-07-24 09:13:27','',''),(2625226,'1','180','934',414,'Retail Sale Id 1620196',600.60,0.00,0.00,0.78,60.84,'2022-07-24 11:33:31','',''),(2625227,'1','180','934',414,'Retail Sale Id 1620197',86400.00,0.00,0.00,120.00,3360.00,'2022-07-24 19:42:47','',''),(2625228,'1','180','934',414,'Retail Sale Id 1620198',36000.00,0.00,0.00,50.00,1400.00,'2022-07-24 19:43:51','',''),(2625229,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,3529200.00,5100.00,0.00,0.00,'2022-07-27 09:59:15','',''),(2625230,'1','180',NULL,414,'Reception corrector for bridging 130295',0.00,0.00,0.00,5100.00,0.00,'2022-07-27 10:00:42','',''),(2625231,'1','180','934',414,'Received from bridging 130295',0.00,0.00,5100.00,0.00,0.00,'2022-07-27 10:00:42','',''),(2625232,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344952',205966.88,0.00,0.00,297.64,0.00,'2022-07-27 10:08:36','',''),(2625233,'1','180','934',414,'Retail Sale Id 1620199',43200.00,0.00,0.00,60.00,1680.00,'2022-07-27 10:11:03','',''),(2625234,'1','180','934',414,'Retail Sale Id 1620200',2002.00,0.00,0.00,2.60,202.80,'2022-07-27 12:05:33','',''),(2625235,'1','180','934',414,'Retail Sale Id 1620201',9625.00,0.00,0.00,12.50,975.00,'2022-07-27 13:31:23','',''),(2625236,'1','180','934',414,'Retail Sale Id 1620203',2310.00,0.00,0.00,3.00,234.00,'2022-07-27 13:37:38','',''),(2625237,'1','180','934',414,'Retail Sale Id 1620204',4997.30,0.00,0.00,6.49,506.22,'2022-07-27 14:11:37','',''),(2625238,'1','180','934',414,'Retail Sale Id 1620205',1801.80,0.00,0.00,2.34,182.52,'2022-07-27 17:23:32','',''),(2625239,'1','180','934',414,'Retail Sale Id 1620206',3850.00,0.00,0.00,5.00,390.00,'2022-07-27 17:24:56','',''),(2625240,'1','180','934',414,'Retail Sale Id 1620207',1540.00,0.00,0.00,2.00,156.00,'2022-07-27 18:06:50','',''),(2625241,'1','180','934',414,'Retail Sale Id 1620208',5698.00,0.00,0.00,7.40,577.20,'2022-07-27 18:08:06','',''),(2625242,'1','180','934',414,'Retail Sale Id 1620210',4620.00,0.00,0.00,6.00,468.00,'2022-07-28 12:17:28','',''),(2625243,'1','180','934',414,'Retail Sale Id 1620211',1501.50,0.00,0.00,1.95,152.10,'2022-07-28 12:18:37','',''),(2625244,'1','180','934',414,'Retail Sale Id 1620212',4620.00,0.00,0.00,6.00,468.00,'2022-07-28 14:49:26','',''),(2625245,'1','180','934',414,'Retail Sale Id 1620213',5998.30,0.00,0.00,7.79,607.62,'2022-07-28 14:50:26','',''),(2625246,'1','180','934',414,'Retail Sale Id 1620214',2002.00,0.00,0.00,2.60,202.80,'2022-07-28 14:51:15','',''),(2625247,'1','180','934',414,'Retail Sale Id 1620215',4350.50,0.00,0.00,5.65,440.70,'2022-07-28 14:52:15','',''),(2625248,'1','180','934',414,'Retail Sale Id 1620216',1001.00,0.00,0.00,1.30,101.40,'2022-07-28 14:53:11','',''),(2625249,'1','180','934',414,'Retail Sale Id 1620218',8500.80,0.00,0.00,11.04,861.12,'2022-07-28 15:04:24','',''),(2625250,'1','180','934',414,'Retail Sale Id 1620219',2002.00,0.00,0.00,2.60,202.80,'2022-07-28 15:05:19','',''),(2625251,'1','180','934',414,'Retail Sale Id 1620220',10002.30,0.00,0.00,12.99,1013.22,'2022-07-28 15:07:12','',''),(2625252,'1','180','934',414,'Retail Sale Id 1620221',10002.30,0.00,0.00,12.99,1013.22,'2022-07-28 15:08:09','',''),(2625253,'1','180','934',414,'Retail Sale Id 1620222',8878.10,0.00,0.00,11.53,899.34,'2022-07-28 15:09:27','',''),(2625254,'1','180','934',414,'Retail Sale Id 1620223',2902.90,0.00,0.00,3.77,294.06,'2022-07-28 16:00:37','',''),(2625255,'1','180','934',414,'Retail Sale Id 1620224',1540.00,0.00,0.00,2.00,156.00,'2022-07-28 16:01:30','',''),(2625256,'1','180','934',414,'Retail Sale Id 1620225',2002.00,0.00,0.00,2.60,202.80,'2022-07-28 17:05:06','',''),(2625257,'1','180','934',414,'Retail Sale Id 1620226',1540.00,0.00,0.00,2.00,156.00,'2022-07-28 17:17:36','',''),(2625258,'1','180','934',414,'Retail Sale Id 1620227',3996.30,0.00,0.00,5.19,404.82,'2022-07-28 17:19:11','',''),(2625259,'1','180','934',414,'Retail Sale Id 1620228',4396.70,0.00,0.00,5.71,445.38,'2022-07-28 17:20:28','',''),(2625260,'1','180','934',414,'Retail Sale Id 1620229',3003.00,0.00,0.00,3.90,304.20,'2022-07-28 17:41:10','',''),(2625261,'1','180','934',414,'Retail Sale Id 1620230',7700.00,0.00,0.00,10.00,780.00,'2022-07-29 09:03:37','',''),(2625262,'1','180','934',414,'Retail Sale Id 1620231',2502.50,0.00,0.00,3.25,253.50,'2022-07-29 09:04:55','',''),(2625263,'1','180','934',414,'Retail Sale Id 1620232',1501.50,0.00,0.00,1.95,152.10,'2022-07-29 09:06:12','',''),(2625264,'1','180','934',414,'Retail Sale Id 1620233',3303.30,0.00,0.00,4.29,334.62,'2022-07-29 09:07:44','',''),(2625265,'1','180','934',414,'Retail Sale Id 1620234',2002.00,0.00,0.00,2.60,202.80,'2022-07-29 09:13:28','',''),(2625266,'1','180','934',414,'Retail Sale Id 1620235',3996.30,0.00,0.00,5.19,404.82,'2022-07-29 10:08:27','',''),(2625267,'1','180','934',414,'Retail Sale Id 1620236',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 10:09:55','',''),(2625268,'1','180','934',414,'Retail Sale Id 1620237',2310.00,0.00,0.00,3.00,234.00,'2022-07-29 10:31:26','',''),(2625269,'1','180','934',414,'Retail Sale Id 1620238',1848.00,0.00,0.00,2.40,187.20,'2022-07-29 10:32:58','',''),(2625270,'1','180','934',414,'Retail Sale Id 1620239',9625.00,0.00,0.00,12.50,975.00,'2022-07-29 11:01:41','',''),(2625271,'1','180','934',414,'Retail Sale Id 1620240',3850.00,0.00,0.00,5.00,390.00,'2022-07-29 11:24:56','',''),(2625272,'1','180','934',414,'Retail Sale Id 1620241',2248.40,0.00,0.00,2.92,227.76,'2022-07-29 11:34:11','',''),(2625273,'1','180','934',414,'Retail Sale Id 1620242',3850.00,0.00,0.00,5.00,390.00,'2022-07-29 12:00:26','',''),(2625274,'1','180','934',414,'Retail Sale Id 1620243',3003.00,0.00,0.00,3.90,304.20,'2022-07-29 12:01:19','',''),(2625275,'1','180','934',414,'Retail Sale Id 1620244',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 15:38:34','',''),(2625276,'1','180','934',414,'Retail Sale Id 1620245',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 15:41:41','',''),(2625277,'1','180','934',414,'Retail Sale Id 1620246',4997.30,0.00,0.00,6.49,506.22,'2022-07-29 15:53:21','',''),(2625278,'1','180','934',414,'Retail Sale Id 1620247',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 16:09:28','',''),(2625279,'1','180','934',414,'Retail Sale Id 1620248',2310.00,0.00,0.00,3.00,234.00,'2022-07-29 16:11:09','',''),(2625280,'1','180','934',414,'Retail Sale Id 1620249',2502.50,0.00,0.00,3.25,253.50,'2022-07-29 16:27:40','',''),(2625281,'1','180','934',414,'Retail Sale Id 1620250',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 16:40:46','',''),(2625282,'1','180','934',414,'Retail Sale Id 1620254',1001.00,0.00,0.00,1.30,101.40,'2022-07-29 16:42:32','',''),(2625283,'1','180','934',414,'Retail Sale Id 1620255',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 16:46:26','',''),(2625284,'1','180','934',414,'Retail Sale Id 1620256',4620.00,0.00,0.00,6.00,468.00,'2022-07-29 18:16:14','',''),(2625285,'1','180','934',414,'Retail Sale Id 1620257',9625.00,0.00,0.00,12.50,975.00,'2022-07-29 18:52:20','',''),(2625286,'1','180','934',414,'Retail Sale Id 1620258',3003.00,0.00,0.00,3.90,304.20,'2022-07-30 11:46:15','',''),(2625287,'1','180','934',414,'Retail Sale Id 1620259',3003.00,0.00,0.00,3.90,304.20,'2022-07-30 11:47:48','',''),(2625288,'1','180','934',414,'Retail Sale Id 1620260',4997.30,0.00,0.00,6.49,506.22,'2022-07-30 11:48:38','',''),(2625289,'1','180','934',414,'Retail Sale Id 1620261',4620.00,0.00,0.00,6.00,468.00,'2022-07-30 11:49:50','',''),(2625290,'1','180','934',414,'Retail Sale Id 1620262',2310.00,0.00,0.00,3.00,234.00,'2022-07-30 11:50:37','',''),(2625291,'1','180','934',414,'Retail Sale Id 1620263',4620.00,0.00,0.00,6.00,468.00,'2022-07-30 11:51:26','',''),(2625292,'1','180','934',414,'Retail Sale Id 1620264',2002.00,0.00,0.00,2.60,202.80,'2022-07-30 11:52:20','',''),(2625293,'1','180','934',414,'Retail Sale Id 1620265',9625.00,0.00,0.00,12.50,975.00,'2022-07-30 11:53:19','',''),(2625294,'1','180','934',414,'Retail Sale Id 1620266',1540.00,0.00,0.00,2.00,156.00,'2022-07-30 12:08:31','',''),(2625295,'1','180','934',414,'Retail Sale Id 1620267',2310.00,0.00,0.00,3.00,234.00,'2022-07-30 13:40:56','',''),(2625296,'1','180','934',414,'Retail Sale Id 1620268',2310.00,0.00,0.00,3.00,234.00,'2022-07-30 14:31:24','',''),(2625297,'1','180','934',414,'Retail Sale Id 1620269',4620.00,0.00,0.00,6.00,468.00,'2022-07-30 14:56:37','',''),(2625298,'1','180','934',414,'Retail Sale Id 1620270',2310.00,0.00,0.00,3.00,234.00,'2022-07-30 14:57:33','',''),(2625299,'1','180','934',414,'Retail Sale Id 1620271',3080.00,0.00,0.00,4.00,312.00,'2022-07-30 15:32:58','',''),(2625300,'1','180','934',414,'Retail Sale Id 1620272',4620.00,0.00,0.00,6.00,468.00,'2022-07-30 15:48:25','',''),(2625301,'1','180','934',414,'Retail Sale Id 1620273',2310.00,0.00,0.00,3.00,234.00,'2022-07-30 16:27:19','',''),(2625302,'1','180','934',414,'Retail Sale Id 1620274',2310.00,0.00,0.00,3.00,234.00,'2022-07-30 16:35:00','',''),(2625303,'1','180','934',414,'Retail Sale Id 1620275',4620.00,0.00,0.00,6.00,468.00,'2022-07-30 18:46:35','',''),(2625304,'1','180','934',414,'Retail Sale Id 1620276',4620.00,0.00,0.00,6.00,468.00,'2022-07-31 13:25:42','',''),(2625305,'1','180','934',414,'Retail Sale Id 1620277',3996.30,0.00,0.00,5.19,404.82,'2022-07-31 13:26:33','',''),(2625306,'1','180','934',414,'Retail Sale Id 1620278',4997.30,0.00,0.00,6.49,506.22,'2022-07-31 13:44:46','',''),(2625307,'1','180','934',414,'Retail Sale Id 1620281',9240.00,0.00,0.00,12.00,936.00,'2022-07-31 15:07:24','',''),(2625308,'1','180','934',414,'Retail Sale Id 1620282',2310.00,0.00,0.00,3.00,234.00,'2022-07-31 15:08:16','',''),(2625309,'1','180','934',414,'Retail Sale Id 1620283',2002.00,0.00,0.00,2.60,202.80,'2022-07-31 15:09:13','',''),(2625310,'1','180','934',414,'Retail Sale Id 1620284',4396.70,0.00,0.00,5.71,445.38,'2022-07-31 15:56:07','',''),(2625311,'1','180','934',414,'Retail Sale Id 1620285',3850.00,0.00,0.00,5.00,390.00,'2022-07-31 16:00:19','',''),(2625312,'1','180','934',414,'Retail Sale Id 1620286',4620.00,0.00,0.00,6.00,468.00,'2022-07-31 17:00:32','',''),(2625313,'1','180','934',414,'Retail Sale Id 1620287',2002.00,0.00,0.00,2.60,202.80,'2022-07-31 17:01:39','',''),(2625314,'1','180','934',414,'Retail Sale Id 1620288',2002.00,0.00,0.00,2.60,202.80,'2022-07-31 17:59:40','',''),(2625315,'1','180','934',414,'Retail Sale Id 1620289',1540.00,0.00,0.00,2.00,156.00,'2022-07-31 18:00:40','',''),(2625316,'1','180','934',414,'Retail Sale Id 1620290',3896.20,0.00,0.00,5.06,394.68,'2022-07-31 18:20:39','',''),(2625317,'1','180','934',414,'Retail Sale Id 1620291',4997.30,0.00,0.00,6.49,506.22,'2022-07-31 18:21:38','',''),(2625318,'1','180','934',414,'Retail Sale Id 1620292',7700.00,0.00,0.00,10.00,780.00,'2022-08-01 09:27:02','',''),(2625319,'1','180','934',414,'Retail Sale Id 1620293',7700.00,0.00,0.00,10.00,780.00,'2022-08-01 09:49:42','',''),(2625320,'1','180','934',414,'Retail Sale Id 1620294',2656.50,0.00,0.00,3.45,269.10,'2022-08-01 09:50:59','',''),(2625321,'1','180','934',414,'Retail Sale Id 1620295',1001.00,0.00,0.00,1.30,101.40,'2022-08-01 09:52:03','',''),(2625322,'1','180','934',414,'Retail Sale Id 1620296',9625.00,0.00,0.00,12.50,975.00,'2022-08-01 10:45:50','',''),(2625323,'1','180','934',414,'Retail Sale Id 1620297',9625.00,0.00,0.00,12.50,975.00,'2022-08-01 10:47:13','',''),(2625324,'1','180','934',414,'Retail Sale Id 1620298',4620.00,0.00,0.00,6.00,468.00,'2022-08-01 10:48:05','',''),(2625325,'1','180','934',414,'Retail Sale Id 1620299',2333.10,0.00,0.00,3.03,236.34,'2022-08-01 10:49:02','',''),(2625326,'1','180','934',414,'Retail Sale Id 1620300',6160.00,0.00,0.00,8.00,624.00,'2022-08-01 11:04:45','',''),(2625327,'1','180','934',414,'Retail Sale Id 1620301',1001.00,0.00,0.00,1.30,101.40,'2022-08-01 11:05:36','',''),(2625328,'1','180','934',414,'Retail Sale Id 1620302',4620.00,0.00,0.00,6.00,468.00,'2022-08-01 12:12:02','',''),(2625329,'1','180','934',414,'Retail Sale Id 1620303',3503.50,0.00,0.00,4.55,354.90,'2022-08-01 12:13:04','',''),(2625330,'1','180','934',414,'Retail Sale Id 1620304',3996.30,0.00,0.00,5.19,404.82,'2022-08-01 12:15:12','',''),(2625331,'1','180','934',414,'Retail Sale Id 1620305',4620.00,0.00,0.00,6.00,468.00,'2022-08-01 12:53:23','',''),(2625332,'1','180','934',414,'Retail Sale Id 1620306',5998.30,0.00,0.00,7.79,607.62,'2022-08-01 12:54:37','',''),(2625333,'1','180','934',414,'Retail Sale Id 1620307',2002.00,0.00,0.00,2.60,202.80,'2022-08-01 12:56:13','',''),(2625334,'1','180','934',414,'Retail Sale Id 1620308',3850.00,0.00,0.00,5.00,390.00,'2022-08-01 13:32:05','',''),(2625335,'1','180','934',414,'Retail Sale Id 1620309',3003.00,0.00,0.00,3.90,304.20,'2022-08-01 13:32:58','',''),(2625336,'1','180','934',414,'Retail Sale Id 1620310',3080.00,0.00,0.00,4.00,312.00,'2022-08-01 15:39:12','',''),(2625337,'1','180','934',414,'Retail Sale Id 1620311',500.50,0.00,0.00,0.65,50.70,'2022-08-01 16:37:04','',''),(2625338,'1','180','934',414,'Retail Sale Id 1620312',4620.00,0.00,0.00,6.00,468.00,'2022-08-01 17:18:49','',''),(2625339,'1','180','934',414,'Retail Sale Id 1620313',1540.00,0.00,0.00,2.00,156.00,'2022-08-01 17:23:32','',''),(2625340,'1','180','934',414,'Retail Sale Id 1620314',2310.00,0.00,0.00,3.00,234.00,'2022-08-01 18:05:17','',''),(2625341,'1','180','934',414,'Retail Sale Id 1620315',3996.30,0.00,0.00,5.19,404.82,'2022-08-01 18:08:39','',''),(2625342,'1','180','934',414,'Retail Sale Id 1620316',1540.00,0.00,0.00,2.00,156.00,'2022-08-01 18:17:15','',''),(2625343,'1','180','934',414,'Retail Sale Id 1620317',4620.00,0.00,0.00,6.00,468.00,'2022-08-01 18:33:08','',''),(2625344,'1','180','934',414,'Retail Sale Id 1620320',3850.00,0.00,0.00,5.00,390.00,'2022-08-01 19:09:26','',''),(2625345,'1','180','934',414,'Retail Sale Id 1620321',36000.00,0.00,0.00,50.00,1400.00,'2022-08-01 21:02:06','',''),(2625346,'1','180','934',414,'Retail Sale Id 1620322',3803.80,0.00,0.00,4.94,385.32,'2022-08-02 08:53:26','',''),(2625347,'1','180','934',414,'Retail Sale Id 1620323',2310.00,0.00,0.00,3.00,234.00,'2022-08-02 08:54:24','',''),(2625348,'1','180','934',414,'Retail Sale Id 1620324',5390.00,0.00,0.00,7.00,546.00,'2022-08-02 09:50:52','',''),(2625349,'1','180','934',414,'Retail Sale Id 1620325',4496.80,0.00,0.00,5.84,455.52,'2022-08-02 10:34:49','',''),(2625350,'1','180','934',414,'Retail Sale Id 1620326',4620.00,0.00,0.00,6.00,468.00,'2022-08-02 10:54:59','',''),(2625351,'1','180','934',414,'Retail Sale Id 1620327',2186.80,0.00,0.00,2.84,221.52,'2022-08-02 11:00:54','',''),(2625352,'1','180','934',414,'Retail Sale Id 1620328',3303.30,0.00,0.00,4.29,334.62,'2022-08-02 11:20:49','',''),(2625353,'1','180','934',414,'Retail Sale Id 1620329',4620.00,0.00,0.00,6.00,468.00,'2022-08-02 13:33:04','',''),(2625354,'1','180','934',414,'Retail Sale Id 1620331',1540.00,0.00,0.00,2.00,156.00,'2022-08-02 13:33:59','',''),(2625355,'1','180','934',414,'Retail Sale Id 1620332',5390.00,0.00,0.00,7.00,546.00,'2022-08-02 14:13:29','',''),(2625356,'1','180','934',414,'Retail Sale Id 1620333',2310.00,0.00,0.00,3.00,234.00,'2022-08-02 15:17:47','',''),(2625357,'1','180','934',414,'Retail Sale Id 1620334',2310.00,0.00,0.00,3.00,234.00,'2022-08-02 15:29:54','',''),(2625358,'1','180','934',414,'Retail Sale Id 1620335',2310.00,0.00,0.00,3.00,234.00,'2022-08-02 15:35:04','',''),(2625359,'1','180','934',414,'Retail Sale Id 1620336',1101.10,0.00,0.00,1.43,111.54,'2022-08-02 16:01:01','',''),(2625360,'1','180','934',414,'Retail Sale Id 1620337',2002.00,0.00,0.00,2.60,202.80,'2022-08-02 16:21:59','',''),(2625361,'1','180','934',414,'Retail Sale Id 1620338',4620.00,0.00,0.00,6.00,468.00,'2022-08-02 17:18:57','',''),(2625362,'1','180','934',414,'Retail Sale Id 1620339',1001.00,0.00,0.00,1.30,101.40,'2022-08-02 17:20:18','',''),(2625363,'1','180','934',414,'Retail Sale Id 1620340',2310.00,0.00,0.00,3.00,234.00,'2022-08-02 18:23:49','',''),(2625364,'1','180','934',414,'Retail Sale Id 1620341',43200.00,0.00,0.00,60.00,1680.00,'2022-08-02 20:01:35','',''),(2625365,'1','180','934',414,'Retail Sale Id 1620342',3080.00,0.00,0.00,4.00,312.00,'2022-08-03 11:42:33','',''),(2625366,'1','180','934',414,'Retail Sale Id 1620343',4997.30,0.00,0.00,6.49,506.22,'2022-08-03 11:43:31','',''),(2625367,'1','180','934',414,'Retail Sale Id 1620344',9625.00,0.00,0.00,12.50,975.00,'2022-08-03 11:44:32','',''),(2625368,'1','180','934',414,'Retail Sale Id 1620345',8470.00,0.00,0.00,11.00,858.00,'2022-08-03 11:45:31','',''),(2625369,'1','180','934',414,'Retail Sale Id 1620346',2310.00,0.00,0.00,3.00,234.00,'2022-08-03 11:55:35','',''),(2625370,'1','180','934',414,'Retail Sale Id 1620347',2310.00,0.00,0.00,3.00,234.00,'2022-08-03 13:12:08','',''),(2625371,'1','180','934',414,'Retail Sale Id 1620348',4620.00,0.00,0.00,6.00,468.00,'2022-08-03 14:29:43','',''),(2625372,'1','180','934',414,'Retail Sale Id 1620349',9625.00,0.00,0.00,12.50,975.00,'2022-08-03 16:40:26','',''),(2625373,'1','180','934',414,'Retail Sale Id 1620350',4620.00,0.00,0.00,6.00,468.00,'2022-08-03 16:41:18','',''),(2625374,'1','180','934',414,'Retail Sale Id 1620351',3850.00,0.00,0.00,5.00,390.00,'2022-08-03 16:42:22','',''),(2625375,'1','180','934',414,'Retail Sale Id 1620352',4620.00,0.00,0.00,6.00,468.00,'2022-08-03 16:43:28','',''),(2625376,'1','180','934',414,'Retail Sale Id 1620353',2310.00,0.00,0.00,3.00,234.00,'2022-08-03 16:46:16','',''),(2625377,'1','180','934',414,'Retail Sale Id 1620354',2310.00,0.00,0.00,3.00,234.00,'2022-08-03 16:54:08','',''),(2625378,'1','180','934',414,'Retail Sale Id 1620355',500.50,0.00,0.00,0.65,50.70,'2022-08-03 17:01:07','',''),(2625379,'1','180','934',414,'Retail Sale Id 1620356',3080.00,0.00,0.00,4.00,312.00,'2022-08-03 18:33:18','',''),(2625380,'1','180','934',414,'Retail Sale Id 1620357',500.50,0.00,0.00,0.65,50.70,'2022-08-03 18:34:06','',''),(2625381,'1','180','934',414,'Retail Sale Id 1620358',4620.00,0.00,0.00,6.00,468.00,'2022-08-04 14:12:11','',''),(2625382,'1','180','934',414,'Retail Sale Id 1620359',2310.00,0.00,0.00,3.00,234.00,'2022-08-04 14:12:58','',''),(2625383,'1','180','934',414,'Retail Sale Id 1620360',1001.00,0.00,0.00,1.30,101.40,'2022-08-04 14:13:51','',''),(2625384,'1','180','934',414,'Retail Sale Id 1620361',2310.00,0.00,0.00,3.00,234.00,'2022-08-04 14:46:06','',''),(2625385,'1','180','934',414,'Retail Sale Id 1620362',1540.00,0.00,0.00,2.00,156.00,'2022-08-04 14:47:34','',''),(2625386,'1','180','934',414,'Retail Sale Id 1620363',2002.00,0.00,0.00,2.60,202.80,'2022-08-04 14:49:41','',''),(2625387,'1','180','934',414,'Retail Sale Id 1620364',2502.50,0.00,0.00,3.25,253.50,'2022-08-04 14:59:51','',''),(2625388,'1','180','934',414,'Retail Sale Id 1620365',1501.50,0.00,0.00,1.95,152.10,'2022-08-04 15:01:04','',''),(2625389,'1','180','934',414,'Retail Sale Id 1620366',2002.00,0.00,0.00,2.60,202.80,'2022-08-04 15:02:25','',''),(2625390,'1','180','934',414,'Retail Sale Id 1620367',4620.00,0.00,0.00,6.00,468.00,'2022-08-04 15:27:56','',''),(2625391,'1','180','934',414,'Retail Sale Id 1620369',4596.90,0.00,0.00,5.97,465.66,'2022-08-04 15:46:56','',''),(2625392,'1','180','934',414,'Retail Sale Id 1620370',1501.50,0.00,0.00,1.95,152.10,'2022-08-04 15:59:53','',''),(2625393,'1','180','934',414,'Retail Sale Id 1620371',2002.00,0.00,0.00,2.60,202.80,'2022-08-04 17:21:55','',''),(2625394,'1','180','934',414,'Retail Sale Id 1620372',9625.00,0.00,0.00,12.50,975.00,'2022-08-04 17:40:18','',''),(2625395,'1','180','934',414,'Retail Sale Id 1620374',2502.50,0.00,0.00,3.25,253.50,'2022-08-04 18:42:21','',''),(2625396,'1','180','934',414,'Retail Sale Id 1620375',7700.00,0.00,0.00,10.00,780.00,'2022-08-04 18:44:27','',''),(2625397,'1','180','934',414,'Retail Sale Id 1620376',3850.00,0.00,0.00,5.00,390.00,'2022-08-05 08:54:34','',''),(2625398,'1','180','934',414,'Retail Sale Id 1620377',3080.00,0.00,0.00,4.00,312.00,'2022-08-05 08:55:37','',''),(2625399,'1','180','934',414,'Retail Sale Id 1620379',9625.00,0.00,0.00,12.50,975.00,'2022-08-05 09:36:16','',''),(2625400,'1','180','934',414,'Retail Sale Id 1620380',1001.00,0.00,0.00,1.30,101.40,'2022-08-05 09:37:23','',''),(2625401,'1','180','934',414,'Retail Sale Id 1620381',2849.00,0.00,0.00,3.70,288.60,'2022-08-05 10:41:39','',''),(2625402,'1','180','934',414,'Retail Sale Id 1620382',6999.30,0.00,0.00,9.09,709.02,'2022-08-05 10:42:34','',''),(2625403,'1','180','934',414,'Retail Sale Id 1620383',4997.30,0.00,0.00,6.49,506.22,'2022-08-05 10:43:28','',''),(2625404,'1','180','934',414,'Retail Sale Id 1620384',2002.00,0.00,0.00,2.60,202.80,'2022-08-05 10:49:38','',''),(2625405,'1','180','934',414,'Retail Sale Id 1620385',2310.00,0.00,0.00,3.00,234.00,'2022-08-05 11:00:56','',''),(2625406,'1','180','934',414,'Retail Sale Id 1620386',4496.80,0.00,0.00,5.84,455.52,'2022-08-05 11:45:46','',''),(2625407,'1','180','934',414,'Retail Sale Id 1620387',2202.20,0.00,0.00,2.86,223.08,'2022-08-05 11:50:38','',''),(2625408,'1','180','934',414,'Retail Sale Id 1620388',3850.00,0.00,0.00,5.00,390.00,'2022-08-05 12:16:16','',''),(2625409,'1','180','934',414,'Retail Sale Id 1620389',2310.00,0.00,0.00,3.00,234.00,'2022-08-05 12:17:21','',''),(2625410,'1','180','934',414,'Retail Sale Id 1620390',3003.00,0.00,0.00,3.90,304.20,'2022-08-05 12:42:26','',''),(2625411,'1','180','934',414,'Retail Sale Id 1620391',4496.80,0.00,0.00,5.84,455.52,'2022-08-05 13:21:58','',''),(2625412,'1','180','934',414,'Retail Sale Id 1620392',4620.00,0.00,0.00,6.00,468.00,'2022-08-05 13:31:15','',''),(2625413,'1','180','934',414,'Retail Sale Id 1620393',43200.00,0.00,0.00,60.00,1680.00,'2022-08-05 14:40:19','',''),(2625414,'1','180','934',414,'Retail Sale Id 1620394',83520.00,0.00,0.00,116.00,3248.00,'2022-08-05 14:40:58','',''),(2625415,'1','180','934',414,'Retail Sale Id 1620395',4620.00,0.00,0.00,6.00,468.00,'2022-08-05 15:07:57','',''),(2625416,'1','180','934',414,'Retail Sale Id 1620396',3850.00,0.00,0.00,5.00,390.00,'2022-08-05 15:10:22','',''),(2625417,'1','180','934',414,'Retail Sale Id 1620397',1001.00,0.00,0.00,1.30,101.40,'2022-08-05 15:30:24','',''),(2625418,'1','180','934',414,'Retail Sale Id 1620398',1001.00,0.00,0.00,1.30,101.40,'2022-08-05 15:38:40','',''),(2625419,'1','180','934',414,'Retail Sale Id 1620399',6999.30,0.00,0.00,9.09,709.02,'2022-08-05 15:41:54','',''),(2625420,'1','180','934',414,'Retail Sale Id 1620400',2310.00,0.00,0.00,3.00,234.00,'2022-08-05 15:52:47','',''),(2625421,'1','180','934',414,'Retail Sale Id 1620401',1540.00,0.00,0.00,2.00,156.00,'2022-08-05 16:09:03','',''),(2625422,'1','180','934',414,'Retail Sale Id 1620402',1547.70,0.00,0.00,2.01,156.78,'2022-08-05 16:10:54','',''),(2625423,'1','180','934',414,'Retail Sale Id 1620403',2310000.00,0.00,0.00,3000.00,234000.00,'2022-08-05 16:29:45','',''),(2625424,'1','180','934',414,'Retail Sale Id 1620404',3003.00,0.00,0.00,3.90,304.20,'2022-08-05 16:32:48','',''),(2625425,'1','180','934',414,'Return of Retail Sale Id 1620403',0.00,2310000.00,3000.00,0.00,-234000.00,'2022-08-05 16:59:10','',''),(2625426,'1','180','934',414,'Retail Sale Id 1620405',4620.00,0.00,0.00,6.00,468.00,'2022-08-05 17:08:23','',''),(2625427,'1','180','934',414,'Retail Sale Id 1620406',36000.00,0.00,0.00,50.00,1400.00,'2022-08-05 17:10:00','',''),(2625428,'1','180','934',414,'Retail Sale Id 1620407',3850.00,0.00,0.00,5.00,390.00,'2022-08-05 17:40:25','',''),(2625429,'1','180','934',414,'Retail Sale Id 1620408',1540.00,0.00,0.00,2.00,156.00,'2022-08-05 17:41:32','',''),(2625430,'1','180','934',414,'Retail Sale Id 1620409',4620.00,0.00,0.00,6.00,468.00,'2022-08-05 17:42:36','',''),(2625431,'1','180','934',414,'Retail Sale Id 1620410',9240.00,0.00,0.00,12.00,936.00,'2022-08-05 17:51:29','',''),(2625432,'1','180','934',414,'Retail Sale Id 1620411',9625.00,0.00,0.00,12.50,975.00,'2022-08-06 09:20:24','',''),(2625433,'1','180','934',414,'Retail Sale Id 1620412',7700.00,0.00,0.00,10.00,780.00,'2022-08-06 09:21:42','',''),(2625434,'1','180','934',414,'Retail Sale Id 1620413',3850.00,0.00,0.00,5.00,390.00,'2022-08-06 09:22:39','',''),(2625435,'1','180','934',414,'Retail Sale Id 1620414',8000.30,0.00,0.00,10.39,810.42,'2022-08-06 09:23:52','',''),(2625436,'1','180','934',414,'Retail Sale Id 1620415',5998.30,0.00,0.00,7.79,607.62,'2022-08-06 09:24:54','',''),(2625437,'1','180','934',414,'Retail Sale Id 1620416',8470.00,0.00,0.00,11.00,858.00,'2022-08-06 09:26:06','',''),(2625438,'1','180','934',414,'Retail Sale Id 1620417',1501.50,0.00,0.00,1.95,152.10,'2022-08-06 10:08:25','',''),(2625439,'1','180','934',414,'Retail Sale Id 1620418',3703.70,0.00,0.00,4.81,375.18,'2022-08-06 10:17:12','',''),(2625440,'1','180','934',414,'Retail Sale Id 1620419',3850.00,0.00,0.00,5.00,390.00,'2022-08-06 10:23:57','',''),(2625441,'1','180','934',414,'Retail Sale Id 1620420',500.50,0.00,0.00,0.65,50.70,'2022-08-06 11:06:16','',''),(2625442,'1','180','934',414,'Retail Sale Id 1620421',3850.00,0.00,0.00,5.00,390.00,'2022-08-06 11:51:21','',''),(2625443,'1','180','934',414,'Retail Sale Id 1620422',8000.30,0.00,0.00,10.39,810.42,'2022-08-06 11:53:13','',''),(2625444,'1','180','934',414,'Retail Sale Id 1620423',3996.30,0.00,0.00,5.19,404.82,'2022-08-06 11:55:31','',''),(2625445,'1','180','934',414,'Retail Sale Id 1620424',19250.00,0.00,0.00,25.00,1950.00,'2022-08-06 11:57:02','',''),(2625446,'1','180','934',414,'Retail Sale Id 1620425',41760.00,0.00,0.00,58.00,1624.00,'2022-08-06 11:58:51','',''),(2625447,'1','180','934',414,'Retail Sale Id 1620426',43200.00,0.00,0.00,60.00,1680.00,'2022-08-06 12:03:05','',''),(2625448,'1','180','934',414,'Retail Sale Id 1620427',43200.00,0.00,0.00,60.00,1680.00,'2022-08-06 12:04:56','',''),(2625449,'1','180','934',414,'Retail Sale Id 1620428',4496.80,0.00,0.00,5.84,455.52,'2022-08-06 12:09:47','',''),(2625450,'1','180','934',414,'Retail Sale Id 1620429',3850.00,0.00,0.00,5.00,390.00,'2022-08-06 12:45:00','',''),(2625451,'1','180','934',414,'Retail Sale Id 1620430',3996.30,0.00,0.00,5.19,404.82,'2022-08-06 12:53:48','',''),(2625452,'1','180','934',414,'Retail Sale Id 1620431',2310.00,0.00,0.00,3.00,234.00,'2022-08-06 13:49:39','',''),(2625453,'1','180','934',414,'Retail Sale Id 1620432',1001.00,0.00,0.00,1.30,101.40,'2022-08-06 14:11:03','',''),(2625454,'1','180','934',414,'Retail Sale Id 1620433',4620.00,0.00,0.00,6.00,468.00,'2022-08-06 14:11:55','',''),(2625455,'1','180','934',414,'Retail Sale Id 1620434',4997.30,0.00,0.00,6.49,506.22,'2022-08-06 16:54:03','',''),(2625456,'1','180','934',414,'Retail Sale Id 1620435',1501.50,0.00,0.00,1.95,152.10,'2022-08-06 17:26:44','',''),(2625457,'1','180','934',414,'Retail Sale Id 1620436',3996.30,0.00,0.00,5.19,404.82,'2022-08-06 17:27:34','',''),(2625458,'1','180','934',414,'Retail Sale Id 1620437',3996.30,0.00,0.00,5.19,404.82,'2022-08-06 17:28:21','',''),(2625459,'1','180','934',414,'Retail Sale Id 1620438',3996.30,0.00,0.00,5.19,404.82,'2022-08-06 17:31:55','',''),(2625460,'1','180','934',414,'Retail Sale Id 1620439',2648.80,0.00,0.00,3.44,268.32,'2022-08-06 17:40:22','',''),(2625461,'1','180','934',414,'Retail Sale Id 1620440',4620.00,0.00,0.00,6.00,468.00,'2022-08-06 19:02:18','',''),(2625462,'1','180','934',414,'Retail Sale Id 1620441',4620.00,0.00,0.00,6.00,468.00,'2022-08-07 11:25:05','',''),(2625463,'1','180','934',414,'Retail Sale Id 1620442',4620.00,0.00,0.00,6.00,468.00,'2022-08-07 11:26:05','',''),(2625464,'1','180','934',414,'Retail Sale Id 1620443',3996.30,0.00,0.00,5.19,404.82,'2022-08-07 11:27:05','',''),(2625465,'1','180','934',414,'Retail Sale Id 1620444',3996.30,0.00,0.00,5.19,404.82,'2022-08-07 11:28:03','',''),(2625466,'1','180','934',414,'Retail Sale Id 1620445',2502.50,0.00,0.00,3.25,253.50,'2022-08-07 11:29:06','',''),(2625467,'1','180','934',414,'Retail Sale Id 1620446',19250.00,0.00,0.00,25.00,1950.00,'2022-08-07 12:40:40','',''),(2625468,'1','180','934',414,'Retail Sale Id 1620447',3080.00,0.00,0.00,4.00,312.00,'2022-08-07 12:41:41','',''),(2625469,'1','180','934',414,'Retail Sale Id 1620448',2310.00,0.00,0.00,3.00,234.00,'2022-08-07 12:57:10','',''),(2625470,'1','180','934',414,'Retail Sale Id 1620449',3850.00,0.00,0.00,5.00,390.00,'2022-08-07 13:03:00','',''),(2625471,'1','180','934',414,'Retail Sale Id 1620450',4620.00,0.00,0.00,6.00,468.00,'2022-08-07 13:19:00','',''),(2625472,'1','180','934',414,'Retail Sale Id 1620451',2310.00,0.00,0.00,3.00,234.00,'2022-08-07 13:31:56','',''),(2625473,'1','180','934',414,'Retail Sale Id 1620452',4997.30,0.00,0.00,6.49,506.22,'2022-08-07 14:25:46','',''),(2625474,'1','180','934',414,'Retail Sale Id 1620453',3003.00,0.00,0.00,3.90,304.20,'2022-08-07 14:27:08','',''),(2625475,'1','180','934',414,'Retail Sale Id 1620454',4620.00,0.00,0.00,6.00,468.00,'2022-08-07 15:19:13','',''),(2625476,'1','180','934',414,'Retail Sale Id 1620455',1001.00,0.00,0.00,1.30,101.40,'2022-08-07 15:42:07','',''),(2625477,'1','180','934',414,'Retail Sale Id 1620456',1001.00,0.00,0.00,1.30,101.40,'2022-08-07 15:54:32','',''),(2625478,'1','180','934',414,'Retail Sale Id 1620457',2002.00,0.00,0.00,2.60,202.80,'2022-08-07 16:16:57','',''),(2625479,'1','180','934',414,'Retail Sale Id 1620458',1001.00,0.00,0.00,1.30,101.40,'2022-08-07 16:31:39','',''),(2625480,'1','180','934',414,'Retail Sale Id 1620459',2310.00,0.00,0.00,3.00,234.00,'2022-08-07 16:38:28','',''),(2625481,'1','180','934',414,'Retail Sale Id 1620460',2310.00,0.00,0.00,3.00,234.00,'2022-08-07 16:40:49','',''),(2625482,'1','180','934',414,'Retail Sale Id 1620461',1501.50,0.00,0.00,1.95,152.10,'2022-08-07 18:20:15','',''),(2625483,'1','180','934',414,'Retail Sale Id 1620462',5497.80,0.00,0.00,7.14,556.92,'2022-08-07 18:22:03','',''),(2625484,'1','180','934',414,'Retail Sale Id 1620463',4620.00,0.00,0.00,6.00,468.00,'2022-08-07 18:23:05','',''),(2625485,'1','180','934',414,'Retail Sale Id 1620464',3850.00,0.00,0.00,5.00,390.00,'2022-08-08 08:57:22','',''),(2625486,'1','180','934',414,'Retail Sale Id 1620465',4997.30,0.00,0.00,6.49,506.22,'2022-08-08 08:58:58','',''),(2625487,'1','180','934',414,'Retail Sale Id 1620466',4997.30,0.00,0.00,6.49,506.22,'2022-08-08 08:59:55','',''),(2625488,'1','180','934',414,'Retail Sale Id 1620467',800.80,0.00,0.00,1.04,81.12,'2022-08-08 09:00:55','',''),(2625489,'1','180','934',414,'Retail Sale Id 1620468',2902.90,0.00,0.00,3.77,294.06,'2022-08-08 09:53:17','',''),(2625490,'1','180','934',414,'Retail Sale Id 1620469',2002.00,0.00,0.00,2.60,202.80,'2022-08-08 09:54:15','',''),(2625491,'1','180','934',414,'Retail Sale Id 1620470',4620.00,0.00,0.00,6.00,468.00,'2022-08-08 11:03:40','',''),(2625492,'1','180','934',414,'Retail Sale Id 1620471',4997.30,0.00,0.00,6.49,506.22,'2022-08-08 14:01:04','',''),(2625493,'1','180','934',414,'Retail Sale Id 1620472',3203.20,0.00,0.00,4.16,324.48,'2022-08-08 15:08:52','',''),(2625494,'1','180','934',414,'Retail Sale Id 1620473',208800.00,0.00,0.00,290.00,8120.00,'2022-08-08 15:22:06','',''),(2625495,'1','180','934',414,'Retail Sale Id 1620474',4620.00,0.00,0.00,6.00,468.00,'2022-08-08 15:31:41','',''),(2625496,'1','180','934',414,'Retail Sale Id 1620475',1001.00,0.00,0.00,1.30,101.40,'2022-08-08 15:47:54','',''),(2625497,'1','180','934',414,'Retail Sale Id 1620476',3850.00,0.00,0.00,5.00,390.00,'2022-08-08 15:50:08','',''),(2625498,'1','180','934',414,'Retail Sale Id 1620477',2002.00,0.00,0.00,2.60,202.80,'2022-08-08 16:28:02','',''),(2625499,'1','180','934',414,'Retail Sale Id 1620478',2310.00,0.00,0.00,3.00,234.00,'2022-08-08 16:59:16','',''),(2625500,'1','180','934',414,'Retail Sale Id 1620479',2002.00,0.00,0.00,2.60,202.80,'2022-08-08 17:49:25','',''),(2625501,'1','180','934',414,'Retail Sale Id 1620480',9625.00,0.00,0.00,12.50,975.00,'2022-08-08 21:18:54','',''),(2625502,'1','180','934',414,'Retail Sale Id 1620481',9625.00,0.00,0.00,12.50,975.00,'2022-08-09 09:40:22','',''),(2625503,'1','180','934',414,'Retail Sale Id 1620482',6160.00,0.00,0.00,8.00,624.00,'2022-08-09 09:41:21','',''),(2625504,'1','180','934',414,'Retail Sale Id 1620483',4496.80,0.00,0.00,5.84,455.52,'2022-08-09 09:43:13','',''),(2625505,'1','180','934',414,'Retail Sale Id 1620484',2002.00,0.00,0.00,2.60,202.80,'2022-08-09 10:42:44','',''),(2625506,'1','180','934',414,'Retail Sale Id 1620485',4620.00,0.00,0.00,6.00,468.00,'2022-08-09 12:02:43','',''),(2625507,'1','180','934',414,'Retail Sale Id 1620486',4620.00,0.00,0.00,6.00,468.00,'2022-08-09 13:15:54','',''),(2625508,'1','180','934',414,'Retail Sale Id 1620487',9625.00,0.00,0.00,12.50,975.00,'2022-08-09 13:18:30','',''),(2625509,'1','180','934',414,'Retail Sale Id 1620488',2002.00,0.00,0.00,2.60,202.80,'2022-08-09 14:21:47','',''),(2625510,'1','180','934',414,'Retail Sale Id 1620489',2002.00,0.00,0.00,2.60,202.80,'2022-08-09 14:56:04','',''),(2625511,'1','180','934',414,'Retail Sale Id 1620490',2310.00,0.00,0.00,3.00,234.00,'2022-08-09 15:34:48','',''),(2625512,'1','180','934',414,'Retail Sale Id 1620491',19250.00,0.00,0.00,25.00,1950.00,'2022-08-09 16:32:29','',''),(2625513,'1','180','934',414,'Retail Sale Id 1620492',1501.50,0.00,0.00,1.95,152.10,'2022-08-09 16:33:26','',''),(2625514,'1','180','934',414,'Retail Sale Id 1620493',2310.00,0.00,0.00,3.00,234.00,'2022-08-09 16:37:07','',''),(2625515,'1','180','934',414,'Retail Sale Id 1620494',2310.00,0.00,0.00,3.00,234.00,'2022-08-09 17:19:59','',''),(2625516,'1','180','934',414,'Retail Sale Id 1620495',2310.00,0.00,0.00,3.00,234.00,'2022-08-09 17:24:31','',''),(2625517,'1','180','934',414,'Retail Sale Id 1620496',7700.00,0.00,0.00,10.00,780.00,'2022-08-09 17:25:37','',''),(2625518,'1','180','934',414,'Retail Sale Id 1620497',3003.00,0.00,0.00,3.90,304.20,'2022-08-09 17:26:32','',''),(2625519,'1','180','934',414,'Retail Sale Id 1620498',1001.00,0.00,0.00,1.30,101.40,'2022-08-09 18:10:54','',''),(2625520,'1','180','934',414,'Retail Sale Id 1620499',3080.00,0.00,0.00,4.00,312.00,'2022-08-09 18:30:28','',''),(2625521,'1','180','934',414,'Retail Sale Id 1620500',72000.00,0.00,0.00,100.00,2800.00,'2022-08-09 19:38:28','',''),(2625522,'1','180','934',414,'Retail Sale Id 1620501',4620.00,0.00,0.00,6.00,468.00,'2022-08-10 10:03:15','',''),(2625523,'1','180','934',414,'Retail Sale Id 1620502',2310.00,0.00,0.00,3.00,234.00,'2022-08-10 10:13:50','',''),(2625524,'1','180','934',414,'Retail Sale Id 1620503',2310.00,0.00,0.00,3.00,234.00,'2022-08-10 12:45:16','',''),(2625525,'1','180','934',414,'Retail Sale Id 1620505',2310.00,0.00,0.00,3.00,234.00,'2022-08-10 12:57:39','',''),(2625526,'1','180','934',414,'Retail Sale Id 1620506',1001.00,0.00,0.00,1.30,101.40,'2022-08-10 13:36:09','',''),(2625527,'1','180','934',414,'Retail Sale Id 1620507',41760.00,0.00,0.00,58.00,1624.00,'2022-08-10 13:49:52','',''),(2625528,'1','180','934',414,'Retail Sale Id 1620508',43200.00,0.00,0.00,60.00,1680.00,'2022-08-10 13:51:03','',''),(2625529,'1','180','934',414,'Retail Sale Id 1620509',72000.00,0.00,0.00,100.00,2800.00,'2022-08-10 13:52:07','',''),(2625530,'1','180','934',414,'Retail Sale Id 1620510',2002.00,0.00,0.00,2.60,202.80,'2022-08-10 16:12:36','',''),(2625531,'1','180','934',414,'Retail Sale Id 1620511',4620.00,0.00,0.00,6.00,468.00,'2022-08-10 16:14:03','',''),(2625532,'1','180','934',414,'Retail Sale Id 1620512',7.70,0.00,0.00,0.01,0.78,'2022-08-10 16:14:48','',''),(2625533,'1','180','934',414,'Retail Sale Id 1620513',3080.00,0.00,0.00,4.00,312.00,'2022-08-10 16:29:43','',''),(2625534,'1','180','934',414,'Retail Sale Id 1620514',2310.00,0.00,0.00,3.00,234.00,'2022-08-10 17:03:37','',''),(2625535,'1','180','934',414,'Retail Sale Id 1620515',3996.30,0.00,0.00,5.19,404.82,'2022-08-10 17:11:35','',''),(2625536,'1','180','934',414,'Retail Sale Id 1620516',9625.00,0.00,0.00,12.50,975.00,'2022-08-10 17:40:54','',''),(2625537,'1','180','934',414,'Retail Sale Id 1620517',2310.00,0.00,0.00,3.00,234.00,'2022-08-10 18:02:42','',''),(2625538,'1','180','934',414,'Retail Sale Id 1620518',1801.80,0.00,0.00,2.34,182.52,'2022-08-10 18:17:56','',''),(2625539,'1','180','934',414,'Retail Sale Id 1620519',3996.30,0.00,0.00,5.19,404.82,'2022-08-10 18:25:28','',''),(2625540,'1','180','934',414,'Retail Sale Id 1620520',2310.00,0.00,0.00,3.00,234.00,'2022-08-10 18:39:05','',''),(2625541,'1','180','934',414,'Retail Sale Id 1620521',79200.00,0.00,0.00,110.00,3080.00,'2022-08-10 20:05:09','',''),(2625542,'1','180','934',414,'Retail Sale Id 1620522',2002.00,0.00,0.00,2.60,202.80,'2022-08-11 11:01:25','',''),(2625543,'1','180','934',414,'Retail Sale Id 1620523',9625.00,0.00,0.00,12.50,975.00,'2022-08-11 12:18:52','',''),(2625544,'1','180','934',414,'Retail Sale Id 1620524',2502.50,0.00,0.00,3.25,253.50,'2022-08-11 12:19:42','',''),(2625545,'1','180','934',414,'Retail Sale Id 1620525',3850.00,0.00,0.00,5.00,390.00,'2022-08-11 13:24:05','',''),(2625546,'1','180','934',414,'Retail Sale Id 1620526',2310.00,0.00,0.00,3.00,234.00,'2022-08-11 14:03:34','',''),(2625547,'1','180','934',414,'Retail Sale Id 1620527',2502.50,0.00,0.00,3.25,253.50,'2022-08-11 14:04:28','',''),(2625548,'1','180','934',414,'Retail Sale Id 1620528',1540.00,0.00,0.00,2.00,156.00,'2022-08-11 14:21:14','',''),(2625549,'1','180','934',414,'Retail Sale Id 1620529',770.00,0.00,0.00,1.00,78.00,'2022-08-11 14:27:01','',''),(2625550,'1','180','934',414,'Retail Sale Id 1620530',4620.00,0.00,0.00,6.00,468.00,'2022-08-11 14:55:22','',''),(2625551,'1','180','934',414,'Retail Sale Id 1620531',2002.00,0.00,0.00,2.60,202.80,'2022-08-11 15:17:59','',''),(2625552,'1','180','934',414,'Retail Sale Id 1620532',3850.00,0.00,0.00,5.00,390.00,'2022-08-11 15:40:10','',''),(2625553,'1','180','934',414,'Retail Sale Id 1620533',9625.00,0.00,0.00,12.50,975.00,'2022-08-11 15:47:00','',''),(2625554,'1','180','934',414,'Retail Sale Id 1620534',25001.90,0.00,0.00,32.47,2532.66,'2022-08-11 15:49:23','',''),(2625555,'1','180','934',414,'Retail Sale Id 1620535',9625.00,0.00,0.00,12.50,975.00,'2022-08-11 15:56:25','',''),(2625556,'1','180','934',414,'Retail Sale Id 1620536',2310.00,0.00,0.00,3.00,234.00,'2022-08-11 16:19:13','',''),(2625557,'1','180','934',414,'Retail Sale Id 1620537',2310.00,0.00,0.00,3.00,234.00,'2022-08-11 17:04:19','',''),(2625558,'1','180','934',414,'Retail Sale Id 1620538',1001.00,0.00,0.00,1.30,101.40,'2022-08-11 17:42:24','',''),(2625559,'1','180','934',414,'Retail Sale Id 1620539',2002.00,0.00,0.00,2.60,202.80,'2022-08-11 17:51:22','',''),(2625560,'1','180','934',414,'Retail Sale Id 1620540',2502.50,0.00,0.00,3.25,253.50,'2022-08-11 18:33:12','',''),(2625561,'1','180','934',414,'Retail Sale Id 1620541',3503.50,0.00,0.00,4.55,354.90,'2022-08-11 18:59:02','',''),(2625562,'1','180','934',414,'Retail Sale Id 1620542',500.50,0.00,0.00,0.65,50.70,'2022-08-11 19:04:13','',''),(2625563,'1','180','934',414,'Retail Sale Id 1620543',41760.00,0.00,0.00,58.00,1624.00,'2022-08-11 20:09:22','',''),(2625564,'1','180','934',414,'Retail Sale Id 1620544',3850.00,0.00,0.00,5.00,390.00,'2022-08-12 10:09:21','',''),(2625565,'1','180','934',414,'Retail Sale Id 1620545',4620.00,0.00,0.00,6.00,468.00,'2022-08-12 10:25:10','',''),(2625566,'1','180','934',414,'Retail Sale Id 1620546',1401.40,0.00,0.00,1.82,141.96,'2022-08-12 10:55:19','',''),(2625567,'1','180','934',414,'Retail Sale Id 1620547',3003.00,0.00,0.00,3.90,304.20,'2022-08-12 11:09:20','',''),(2625568,'1','180','934',414,'Retail Sale Id 1620548',3403.40,0.00,0.00,4.42,344.76,'2022-08-12 11:22:22','',''),(2625569,'1','180','934',414,'Retail Sale Id 1620549',2002.00,0.00,0.00,2.60,202.80,'2022-08-12 12:07:56','',''),(2625570,'1','180','934',414,'Retail Sale Id 1620550',1501.50,0.00,0.00,1.95,152.10,'2022-08-12 13:02:53','',''),(2625571,'1','180','934',414,'Retail Sale Id 1620551',2310.00,0.00,0.00,3.00,234.00,'2022-08-12 14:56:53','',''),(2625572,'1','180','934',414,'Retail Sale Id 1620552',8500.80,0.00,0.00,11.04,861.12,'2022-08-12 14:57:53','',''),(2625573,'1','180','934',414,'Retail Sale Id 1620553',2002.00,0.00,0.00,2.60,202.80,'2022-08-12 15:12:15','',''),(2625574,'1','180','934',414,'Retail Sale Id 1620554',2502.50,0.00,0.00,3.25,253.50,'2022-08-12 15:16:21','',''),(2625575,'1','180','934',414,'Retail Sale Id 1620555',2502.50,0.00,0.00,3.25,253.50,'2022-08-12 15:17:40','',''),(2625576,'1','180','934',414,'Retail Sale Id 1620556',3850.00,0.00,0.00,5.00,390.00,'2022-08-12 15:56:18','',''),(2625577,'1','180','934',414,'Retail Sale Id 1620557',2310.00,0.00,0.00,3.00,234.00,'2022-08-12 16:41:40','',''),(2625578,'1','180','934',414,'Retail Sale Id 1620558',4620.00,0.00,0.00,6.00,468.00,'2022-08-12 16:50:39','',''),(2625579,'1','180','934',414,'Retail Sale Id 1620559',2310.00,0.00,0.00,3.00,234.00,'2022-08-12 17:49:08','',''),(2625580,'1','180','934',414,'Retail Sale Id 1620560',9240.00,0.00,0.00,12.00,936.00,'2022-08-12 18:17:32','',''),(2625581,'1','180','934',414,'Retail Sale Id 1620561',36000.00,0.00,0.00,50.00,1400.00,'2022-08-12 21:38:18','',''),(2625582,'1','180','934',414,'Retail Sale Id 1620563',1501.50,0.00,0.00,1.95,152.10,'2022-08-13 11:16:01','',''),(2625583,'1','180','934',414,'Retail Sale Id 1620564',3850.00,0.00,0.00,5.00,390.00,'2022-08-13 11:18:14','',''),(2625584,'1','180','934',414,'Retail Sale Id 1620565',9625.00,0.00,0.00,12.50,975.00,'2022-08-13 11:31:24','',''),(2625585,'1','180','934',414,'Retail Sale Id 1620566',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 11:48:00','',''),(2625586,'1','180','934',414,'Retail Sale Id 1620567',4620.00,0.00,0.00,6.00,468.00,'2022-08-13 12:17:21','',''),(2625587,'1','180','934',414,'Retail Sale Id 1620568',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 12:24:41','',''),(2625588,'1','180','934',414,'Retail Sale Id 1620569',2502.50,0.00,0.00,3.25,253.50,'2022-08-13 12:25:38','',''),(2625589,'1','180','934',414,'Retail Sale Id 1620570',19250.00,0.00,0.00,25.00,1950.00,'2022-08-13 14:52:03','',''),(2625590,'1','180','934',414,'Retail Sale Id 1620571',3003.00,0.00,0.00,3.90,304.20,'2022-08-13 15:08:55','',''),(2625591,'1','180','934',414,'Retail Sale Id 1620572',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 15:10:21','',''),(2625592,'1','180','934',414,'Retail Sale Id 1620573',3996.30,0.00,0.00,5.19,404.82,'2022-08-13 15:34:25','',''),(2625593,'1','180','934',414,'Retail Sale Id 1620574',43200.00,0.00,0.00,60.00,1680.00,'2022-08-13 15:35:31','',''),(2625594,'1','180','934',414,'Retail Sale Id 1620575',4620.00,0.00,0.00,6.00,468.00,'2022-08-13 15:54:59','',''),(2625595,'1','180','934',414,'Retail Sale Id 1620576',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 16:25:13','',''),(2625596,'1','180','934',414,'Retail Sale Id 1620577',2002.00,0.00,0.00,2.60,202.80,'2022-08-13 16:26:09','',''),(2625597,'1','180','934',414,'Retail Sale Id 1620578',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 16:32:02','',''),(2625598,'1','180','934',414,'Retail Sale Id 1620579',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 16:51:35','',''),(2625599,'1','180','934',414,'Retail Sale Id 1620580',1501.50,0.00,0.00,1.95,152.10,'2022-08-13 17:43:51','',''),(2625600,'1','180','934',414,'Retail Sale Id 1620581',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 18:05:19','',''),(2625601,'1','180','934',414,'Retail Sale Id 1620582',2310.00,0.00,0.00,3.00,234.00,'2022-08-13 18:12:15','',''),(2625602,'1','180','934',414,'Retail Sale Id 1620583',4997.30,0.00,0.00,6.49,506.22,'2022-08-14 10:06:48','',''),(2625603,'1','180','934',414,'Retail Sale Id 1620584',4496.80,0.00,0.00,5.84,455.52,'2022-08-14 10:15:07','',''),(2625604,'1','180','934',414,'Retail Sale Id 1620585',2310.00,0.00,0.00,3.00,234.00,'2022-08-14 10:16:18','',''),(2625605,'1','180','934',414,'Retail Sale Id 1620586',9625.00,0.00,0.00,12.50,975.00,'2022-08-14 10:31:42','',''),(2625606,'1','180','934',414,'Retail Sale Id 1620587',4620.00,0.00,0.00,6.00,468.00,'2022-08-14 10:41:29','',''),(2625607,'1','180','934',414,'Retail Sale Id 1620588',3850.00,0.00,0.00,5.00,390.00,'2022-08-14 10:43:14','',''),(2625608,'1','180','934',414,'Retail Sale Id 1620589',2310.00,0.00,0.00,3.00,234.00,'2022-08-14 11:19:46','',''),(2625609,'1','180','934',414,'Retail Sale Id 1620590',1540.00,0.00,0.00,2.00,156.00,'2022-08-14 11:42:44','',''),(2625610,'1','180','934',414,'Retail Sale Id 1620591',700.70,0.00,0.00,0.91,70.98,'2022-08-14 12:01:42','',''),(2625611,'1','180','934',414,'Retail Sale Id 1620592',4496.80,0.00,0.00,5.84,455.52,'2022-08-14 13:06:34','',''),(2625612,'1','180','934',414,'Retail Sale Id 1620593',3003.00,0.00,0.00,3.90,304.20,'2022-08-14 13:09:48','',''),(2625613,'1','180','934',414,'Retail Sale Id 1620594',3996.30,0.00,0.00,5.19,404.82,'2022-08-14 13:25:47','',''),(2625614,'1','180','934',414,'Retail Sale Id 1620595',4620.00,0.00,0.00,6.00,468.00,'2022-08-14 13:31:34','',''),(2625615,'1','180','934',414,'Retail Sale Id 1620596',2002.00,0.00,0.00,2.60,202.80,'2022-08-14 13:50:32','',''),(2625616,'1','180','934',414,'Retail Sale Id 1620597',4620.00,0.00,0.00,6.00,468.00,'2022-08-14 14:40:04','',''),(2625617,'1','180','934',414,'Retail Sale Id 1620598',3003.00,0.00,0.00,3.90,304.20,'2022-08-14 14:58:58','',''),(2625618,'1','180','934',414,'Retail Sale Id 1620599',9001.30,0.00,0.00,11.69,911.82,'2022-08-14 15:23:24','',''),(2625619,'1','180','934',414,'Retail Sale Id 1620600',9625.00,0.00,0.00,12.50,975.00,'2022-08-14 15:51:41','',''),(2625620,'1','180','934',414,'Retail Sale Id 1620601',2002.00,0.00,0.00,2.60,202.80,'2022-08-14 16:09:04','',''),(2625621,'1','180','934',414,'Retail Sale Id 1620602',4620.00,0.00,0.00,6.00,468.00,'2022-08-14 16:10:26','',''),(2625622,'1','180','934',414,'Retail Sale Id 1620603',86400.00,0.00,0.00,120.00,3360.00,'2022-08-14 20:18:50','',''),(2625623,'1','180','934',414,'Retail Sale Id 1620604',3803.80,0.00,0.00,4.94,385.32,'2022-08-15 08:28:15','',''),(2625624,'1','180','934',414,'Retail Sale Id 1620605',4620.00,0.00,0.00,6.00,468.00,'2022-08-15 09:26:39','',''),(2625625,'1','180','934',414,'Retail Sale Id 1620606',3996.30,0.00,0.00,5.19,404.82,'2022-08-15 09:28:00','',''),(2625626,'1','180','934',414,'Retail Sale Id 1620607',6999.30,0.00,0.00,9.09,709.02,'2022-08-15 09:29:09','',''),(2625627,'1','180','934',414,'Retail Sale Id 1620608',9625.00,0.00,0.00,12.50,975.00,'2022-08-15 10:22:20','',''),(2625628,'1','180','934',414,'Retail Sale Id 1620609',7700.00,0.00,0.00,10.00,780.00,'2022-08-15 11:16:32','',''),(2625629,'1','180','934',414,'Retail Sale Id 1620610',2310.00,0.00,0.00,3.00,234.00,'2022-08-15 11:19:57','',''),(2625630,'1','180','934',414,'Retail Sale Id 1620611',1501.50,0.00,0.00,1.95,152.10,'2022-08-15 12:52:20','',''),(2625631,'1','180','934',414,'Retail Sale Id 1620612',831.60,0.00,0.00,1.08,84.24,'2022-08-15 12:55:33','',''),(2625632,'1','180','934',414,'Retail Sale Id 1620613',3003.00,0.00,0.00,3.90,304.20,'2022-08-15 12:57:56','',''),(2625633,'1','180','934',414,'Retail Sale Id 1620614',3850.00,0.00,0.00,5.00,390.00,'2022-08-15 13:10:14','',''),(2625634,'1','180','934',414,'Retail Sale Id 1620615',1501.50,0.00,0.00,1.95,152.10,'2022-08-15 13:23:05','',''),(2625635,'1','180','934',414,'Retail Sale Id 1620616',1001.00,0.00,0.00,1.30,101.40,'2022-08-15 13:24:02','',''),(2625636,'1','180','934',414,'Retail Sale Id 1620617',3080.00,0.00,0.00,4.00,312.00,'2022-08-15 13:28:43','',''),(2625637,'1','180','934',414,'Retail Sale Id 1620618',4620.00,0.00,0.00,6.00,468.00,'2022-08-15 13:32:02','',''),(2625638,'1','180','934',414,'Retail Sale Id 1620619',2310.00,0.00,0.00,3.00,234.00,'2022-08-15 13:33:37','',''),(2625639,'1','180','934',414,'Retail Sale Id 1620620',1540.00,0.00,0.00,2.00,156.00,'2022-08-15 14:06:53','',''),(2625640,'1','180','934',414,'Retail Sale Id 1620621',4620.00,0.00,0.00,6.00,468.00,'2022-08-15 14:18:58','',''),(2625641,'1','180','934',414,'Retail Sale Id 1620622',125280.00,0.00,0.00,174.00,4872.00,'2022-08-15 14:20:20','',''),(2625642,'1','180','934',414,'Retail Sale Id 1620623',2002.00,0.00,0.00,2.60,202.80,'2022-08-15 14:43:59','',''),(2625643,'1','180','934',414,'Retail Sale Id 1620624',2310.00,0.00,0.00,3.00,234.00,'2022-08-15 15:09:32','',''),(2625644,'1','180','934',414,'Retail Sale Id 1620625',4620.00,0.00,0.00,6.00,468.00,'2022-08-15 15:23:49','',''),(2625645,'1','180','934',414,'Retail Sale Id 1620626',4620.00,0.00,0.00,6.00,468.00,'2022-08-15 15:26:44','',''),(2625646,'1','180','934',414,'Retail Sale Id 1620627',4620.00,0.00,0.00,6.00,468.00,'2022-08-15 15:36:00','',''),(2625647,'1','180','934',414,'Retail Sale Id 1620628',9625.00,0.00,0.00,12.50,975.00,'2022-08-15 15:36:51','',''),(2625648,'1','180','934',414,'Retail Sale Id 1620629',2002.00,0.00,0.00,2.60,202.80,'2022-08-15 15:50:04','',''),(2625649,'1','180','934',414,'Retail Sale Id 1620630',1540.00,0.00,0.00,2.00,156.00,'2022-08-15 16:13:14','',''),(2625650,'1','180','934',414,'Retail Sale Id 1620631',3503.50,0.00,0.00,4.55,354.90,'2022-08-15 17:26:20','',''),(2625651,'1','180','934',414,'Retail Sale Id 1620632',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 09:20:02','',''),(2625652,'1','180','934',414,'Retail Sale Id 1620633',3203.20,0.00,0.00,4.16,324.48,'2022-08-16 09:21:02','',''),(2625653,'1','180','934',414,'Retail Sale Id 1620634',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 09:22:44','',''),(2625654,'1','180','934',414,'Retail Sale Id 1620635',800.80,0.00,0.00,1.04,81.12,'2022-08-16 09:23:45','',''),(2625655,'1','180','934',414,'Retail Sale Id 1620636',1501.50,0.00,0.00,1.95,152.10,'2022-08-16 09:41:19','',''),(2625656,'1','180','934',414,'Retail Sale Id 1620637',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 10:55:57','',''),(2625657,'1','180','934',414,'Retail Sale Id 1620638',2310.00,0.00,0.00,3.00,234.00,'2022-08-16 10:56:53','',''),(2625658,'1','180','934',414,'Retail Sale Id 1620639',2902.90,0.00,0.00,3.77,294.06,'2022-08-16 10:58:03','',''),(2625659,'1','180','934',414,'Retail Sale Id 1620640',6930.00,0.00,0.00,9.00,702.00,'2022-08-16 11:29:39','',''),(2625660,'1','180','934',414,'Retail Sale Id 1620641',2002.00,0.00,0.00,2.60,202.80,'2022-08-16 11:34:35','',''),(2625661,'1','180','934',414,'Retail Sale Id 1620642',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 11:41:38','',''),(2625662,'1','180','934',414,'Retail Sale Id 1620643',4096.40,0.00,0.00,5.32,414.96,'2022-08-16 13:15:33','',''),(2625663,'1','180','934',414,'Retail Sale Id 1620644',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 13:31:57','',''),(2625664,'1','180','934',414,'Retail Sale Id 1620645',3850.00,0.00,0.00,5.00,390.00,'2022-08-16 13:34:00','',''),(2625665,'1','180','934',414,'Retail Sale Id 1620646',700.70,0.00,0.00,0.91,70.98,'2022-08-16 13:35:21','',''),(2625666,'1','180','934',414,'Retail Sale Id 1620647',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 14:03:59','',''),(2625667,'1','180','934',414,'Retail Sale Id 1620648',3850.00,0.00,0.00,5.00,390.00,'2022-08-16 14:04:49','',''),(2625668,'1','180','934',414,'Retail Sale Id 1620649',2310.00,0.00,0.00,3.00,234.00,'2022-08-16 14:05:40','',''),(2625669,'1','180','934',414,'Retail Sale Id 1620650',3080.00,0.00,0.00,4.00,312.00,'2022-08-16 15:38:48','',''),(2625670,'1','180','934',414,'Retail Sale Id 1620651',2356.20,0.00,0.00,3.06,238.68,'2022-08-16 15:43:14','',''),(2625671,'1','180','934',414,'Retail Sale Id 1620652',5390.00,0.00,0.00,7.00,546.00,'2022-08-16 15:44:03','',''),(2625672,'1','180','934',414,'Retail Sale Id 1620653',2310.00,0.00,0.00,3.00,234.00,'2022-08-16 18:24:31','',''),(2625673,'1','180','934',414,'Retail Sale Id 1620654',5497.80,0.00,0.00,7.14,556.92,'2022-08-16 18:26:03','',''),(2625674,'1','180','934',414,'Retail Sale Id 1620655',3857.70,0.00,0.00,5.01,390.78,'2022-08-16 18:27:26','',''),(2625675,'1','180','934',414,'Retail Sale Id 1620656',4620.00,0.00,0.00,6.00,468.00,'2022-08-16 18:28:23','',''),(2625676,'1','180','934',414,'Retail Sale Id 1620657',2102.10,0.00,0.00,2.73,212.94,'2022-08-16 18:36:58','',''),(2625677,'1','180','934',414,'Retail Sale Id 1620658',5297.60,0.00,0.00,6.88,536.64,'2022-08-17 08:35:15','',''),(2625678,'1','180','934',414,'Retail Sale Id 1620659',16940.00,0.00,0.00,22.00,1716.00,'2022-08-17 09:21:32','',''),(2625679,'1','180','934',414,'Retail Sale Id 1620660',9625.00,0.00,0.00,12.50,975.00,'2022-08-17 09:23:30','',''),(2625680,'1','180','934',414,'Retail Sale Id 1620661',9240.00,0.00,0.00,12.00,936.00,'2022-08-17 09:24:37','',''),(2625681,'1','180','934',414,'Retail Sale Id 1620662',2002.00,0.00,0.00,2.60,202.80,'2022-08-17 10:10:26','',''),(2625682,'1','180','934',414,'Retail Sale Id 1620663',3003.00,0.00,0.00,3.90,304.20,'2022-08-17 10:11:23','',''),(2625683,'1','180','934',414,'Retail Sale Id 1620664',2402.40,0.00,0.00,3.12,243.36,'2022-08-17 10:36:24','',''),(2625684,'1','180','934',414,'Retail Sale Id 1620665',3996.30,0.00,0.00,5.19,404.82,'2022-08-17 11:06:45','',''),(2625685,'1','180','934',414,'Retail Sale Id 1620666',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 11:19:35','',''),(2625686,'1','180','934',414,'Retail Sale Id 1620667',4620.00,0.00,0.00,6.00,468.00,'2022-08-17 11:34:14','',''),(2625687,'1','180','934',414,'Retail Sale Id 1620668',9625.00,0.00,0.00,12.50,975.00,'2022-08-17 11:35:17','',''),(2625688,'1','180','934',414,'Retail Sale Id 1620669',3103.10,0.00,0.00,4.03,314.34,'2022-08-17 11:36:18','',''),(2625689,'1','180','934',414,'Retail Sale Id 1620670',1501.50,0.00,0.00,1.95,152.10,'2022-08-17 11:37:14','',''),(2625690,'1','180','934',414,'Retail Sale Id 1620671',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 15:00:34','',''),(2625691,'1','180','934',414,'Retail Sale Id 1620672',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 15:01:57','',''),(2625692,'1','180','934',414,'Retail Sale Id 1620673',9240.00,0.00,0.00,12.00,936.00,'2022-08-17 15:03:47','',''),(2625693,'1','180','934',414,'Retail Sale Id 1620674',5236.00,0.00,0.00,6.80,530.40,'2022-08-17 15:04:31','',''),(2625694,'1','180','934',414,'Retail Sale Id 1620675',5998.30,0.00,0.00,7.79,607.62,'2022-08-17 15:05:16','',''),(2625695,'1','180','934',414,'Retail Sale Id 1620676',1201.20,0.00,0.00,1.56,121.68,'2022-08-17 15:06:05','',''),(2625696,'1','180','934',414,'Retail Sale Id 1620677',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 15:06:56','',''),(2625697,'1','180','934',414,'Retail Sale Id 1620678',3850.00,0.00,0.00,5.00,390.00,'2022-08-17 15:28:46','',''),(2625698,'1','180','934',414,'Retail Sale Id 1620679',3850.00,0.00,0.00,5.00,390.00,'2022-08-17 15:30:04','',''),(2625699,'1','180','934',414,'Retail Sale Id 1620680',3003.00,0.00,0.00,3.90,304.20,'2022-08-17 16:50:10','',''),(2625700,'1','180','934',414,'Retail Sale Id 1620681',2002.00,0.00,0.00,2.60,202.80,'2022-08-17 16:50:54','',''),(2625701,'1','180','934',414,'Retail Sale Id 1620682',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 16:51:49','',''),(2625702,'1','180','934',414,'Retail Sale Id 1620683',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 16:53:31','',''),(2625703,'1','180','934',414,'Retail Sale Id 1620684',4620.00,0.00,0.00,6.00,468.00,'2022-08-17 16:54:24','',''),(2625704,'1','180','934',414,'Retail Sale Id 1620685',1001.00,0.00,0.00,1.30,101.40,'2022-08-17 17:50:33','',''),(2625705,'1','180','934',414,'Retail Sale Id 1620686',500.50,0.00,0.00,0.65,50.70,'2022-08-17 17:52:45','',''),(2625706,'1','180','934',414,'Retail Sale Id 1620687',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 18:02:50','',''),(2625707,'1','180','934',414,'Retail Sale Id 1620688',2310.00,0.00,0.00,3.00,234.00,'2022-08-17 18:05:26','',''),(2625708,'1','180','934',414,'Retail Sale Id 1620689',1501.50,0.00,0.00,1.95,152.10,'2022-08-18 08:38:55','',''),(2625709,'1','180','934',414,'Retail Sale Id 1620690',1001.00,0.00,0.00,1.30,101.40,'2022-08-18 08:39:54','',''),(2625710,'1','180','934',414,'Retail Sale Id 1620691',3850.00,0.00,0.00,5.00,390.00,'2022-08-18 08:48:41','',''),(2625711,'1','180','934',414,'Retail Sale Id 1620692',1501.50,0.00,0.00,1.95,152.10,'2022-08-18 08:54:35','',''),(2625712,'1','180','934',414,'Retail Sale Id 1620693',6999.30,0.00,0.00,9.09,709.02,'2022-08-18 09:15:13','',''),(2625713,'1','180','934',414,'Retail Sale Id 1620694',9625.00,0.00,0.00,12.50,975.00,'2022-08-18 10:56:06','',''),(2625714,'1','180','934',414,'Retail Sale Id 1620695',3850.00,0.00,0.00,5.00,390.00,'2022-08-18 10:57:35','',''),(2625715,'1','180','934',414,'Retail Sale Id 1620696',2171.40,0.00,0.00,2.82,219.96,'2022-08-18 10:58:47','',''),(2625716,'1','180','934',414,'Retail Sale Id 1620697',770.00,0.00,0.00,1.00,78.00,'2022-08-18 10:59:40','',''),(2625717,'1','180','934',414,'Retail Sale Id 1620698',2310.00,0.00,0.00,3.00,234.00,'2022-08-18 11:07:19','',''),(2625718,'1','180','934',414,'Retail Sale Id 1620699',2202.20,0.00,0.00,2.86,223.08,'2022-08-18 11:20:48','',''),(2625719,'1','180','934',414,'Retail Sale Id 1620700',36000.00,0.00,0.00,50.00,1400.00,'2022-08-18 12:21:49','',''),(2625720,'1','180','934',414,'Retail Sale Id 1620701',2310.00,0.00,0.00,3.00,234.00,'2022-08-18 12:41:20','',''),(2625721,'1','180','934',414,'Retail Sale Id 1620702',3003.00,0.00,0.00,3.90,304.20,'2022-08-18 12:54:37','',''),(2625722,'1','180','934',414,'Retail Sale Id 1620703',4620.00,0.00,0.00,6.00,468.00,'2022-08-18 13:14:37','',''),(2625723,'1','180','934',414,'Retail Sale Id 1620704',2310.00,0.00,0.00,3.00,234.00,'2022-08-18 14:05:04','',''),(2625724,'1','180','934',414,'Retail Sale Id 1620705',1001.00,0.00,0.00,1.30,101.40,'2022-08-18 16:01:34','',''),(2625725,'1','180','934',414,'Retail Sale Id 1620706',2310.00,0.00,0.00,3.00,234.00,'2022-08-18 16:17:51','',''),(2625726,'1','180','934',414,'Retail Sale Id 1620707',6930.00,0.00,0.00,9.00,702.00,'2022-08-18 16:21:21','',''),(2625727,'1','180','934',414,'Retail Sale Id 1620708',2310.00,0.00,0.00,3.00,234.00,'2022-08-18 16:22:23','',''),(2625728,'1','180','934',414,'Retail Sale Id 1620709',1001.00,0.00,0.00,1.30,101.40,'2022-08-18 16:27:18','',''),(2625729,'1','180','934',414,'Retail Sale Id 1620710',3080.00,0.00,0.00,4.00,312.00,'2022-08-18 16:37:33','',''),(2625730,'1','180','934',414,'Retail Sale Id 1620711',3003.00,0.00,0.00,3.90,304.20,'2022-08-18 16:57:49','',''),(2625731,'1','180','934',414,'Retail Sale Id 1620712',1501.50,0.00,0.00,1.95,152.10,'2022-08-18 17:35:07','',''),(2625732,'1','180','934',414,'Retail Sale Id 1620713',2310.00,0.00,0.00,3.00,234.00,'2022-08-18 17:39:26','',''),(2625733,'1','180','934',414,'Retail Sale Id 1620714',1001.00,0.00,0.00,1.30,101.40,'2022-08-18 17:47:56','',''),(2625734,'1','180','934',414,'Retail Sale Id 1620715',9240.00,0.00,0.00,12.00,936.00,'2022-08-19 10:08:27','',''),(2625735,'1','180','934',414,'Retail Sale Id 1620716',2202.20,0.00,0.00,2.86,223.08,'2022-08-19 10:09:30','',''),(2625736,'1','180','934',414,'Retail Sale Id 1620717',4620.00,0.00,0.00,6.00,468.00,'2022-08-19 11:31:15','',''),(2625737,'1','180','934',414,'Retail Sale Id 1620718',9240.00,0.00,0.00,12.00,936.00,'2022-08-19 11:41:53','',''),(2625738,'1','180','934',414,'Retail Sale Id 1620719',1001.00,0.00,0.00,1.30,101.40,'2022-08-19 11:59:54','',''),(2625739,'1','180','934',414,'Retail Sale Id 1620720',3080.00,0.00,0.00,4.00,312.00,'2022-08-19 12:17:02','',''),(2625740,'1','180','934',414,'Retail Sale Id 1620721',1540.00,0.00,0.00,2.00,156.00,'2022-08-19 12:19:57','',''),(2625741,'1','180','934',414,'Retail Sale Id 1620722',4620.00,0.00,0.00,6.00,468.00,'2022-08-19 12:21:22','',''),(2625742,'1','180','934',414,'Retail Sale Id 1620723',1540.00,0.00,0.00,2.00,156.00,'2022-08-19 12:23:34','',''),(2625743,'1','180','934',414,'Retail Sale Id 1620724',4620.00,0.00,0.00,6.00,468.00,'2022-08-19 13:23:48','',''),(2625744,'1','180','934',414,'Retail Sale Id 1620725',4620.00,0.00,0.00,6.00,468.00,'2022-08-19 14:04:21','',''),(2625745,'1','180','934',414,'Retail Sale Id 1620726',4997.30,0.00,0.00,6.49,506.22,'2022-08-19 14:15:30','',''),(2625746,'1','180','934',414,'Retail Sale Id 1620727',3850.00,0.00,0.00,5.00,390.00,'2022-08-19 14:39:25','',''),(2625747,'1','180','934',414,'Retail Sale Id 1620728',2310.00,0.00,0.00,3.00,234.00,'2022-08-19 14:40:11','',''),(2625748,'1','180','934',414,'Retail Sale Id 1620729',1001.00,0.00,0.00,1.30,101.40,'2022-08-19 14:43:11','',''),(2625749,'1','180','934',414,'Retail Sale Id 1620730',700.70,0.00,0.00,0.91,70.98,'2022-08-19 14:44:23','',''),(2625750,'1','180','934',414,'Retail Sale Id 1620731',1001.00,0.00,0.00,1.30,101.40,'2022-08-19 14:45:21','',''),(2625751,'1','180','934',414,'Retail Sale Id 1620732',2002.00,0.00,0.00,2.60,202.80,'2022-08-19 14:47:03','',''),(2625752,'1','180','934',414,'Retail Sale Id 1620733',4496.80,0.00,0.00,5.84,455.52,'2022-08-19 14:55:19','',''),(2625753,'1','180','934',414,'Retail Sale Id 1620734',2310.00,0.00,0.00,3.00,234.00,'2022-08-19 15:53:23','',''),(2625754,'1','180','934',414,'Retail Sale Id 1620735',3003.00,0.00,0.00,3.90,304.20,'2022-08-19 16:05:37','',''),(2625755,'1','180','934',414,'Retail Sale Id 1620736',2310.00,0.00,0.00,3.00,234.00,'2022-08-19 16:15:21','',''),(2625756,'1','180','934',414,'Retail Sale Id 1620737',2310.00,0.00,0.00,3.00,234.00,'2022-08-19 16:16:34','',''),(2625757,'1','180','934',414,'Retail Sale Id 1620738',770.00,0.00,0.00,1.00,78.00,'2022-08-19 16:17:31','',''),(2625758,'1','180','934',414,'Retail Sale Id 1620739',1001.00,0.00,0.00,1.30,101.40,'2022-08-19 16:29:28','',''),(2625759,'1','180','934',414,'Retail Sale Id 1620740',4620.00,0.00,0.00,6.00,468.00,'2022-08-19 17:00:04','',''),(2625760,'1','180','934',414,'Retail Sale Id 1620742',2310.00,0.00,0.00,3.00,234.00,'2022-08-19 17:30:37','',''),(2625761,'1','180','934',414,'Retail Sale Id 1620743',2502.50,0.00,0.00,3.25,253.50,'2022-08-19 17:43:25','',''),(2625762,'1','180','934',414,'Retail Sale Id 1620744',5998.30,0.00,0.00,7.79,607.62,'2022-08-19 17:44:49','',''),(2625763,'1','180','934',414,'Retail Sale Id 1620745',3850.00,0.00,0.00,5.00,390.00,'2022-08-20 10:05:19','',''),(2625764,'1','180','934',414,'Retail Sale Id 1620746',3103.10,0.00,0.00,4.03,314.34,'2022-08-20 10:06:19','',''),(2625765,'1','180','934',414,'Retail Sale Id 1620747',1501.50,0.00,0.00,1.95,152.10,'2022-08-20 10:41:29','',''),(2625766,'1','180','934',414,'Retail Sale Id 1620748',1401.40,0.00,0.00,1.82,141.96,'2022-08-20 10:57:58','',''),(2625767,'1','180','934',414,'Retail Sale Id 1620749',2310.00,0.00,0.00,3.00,234.00,'2022-08-20 10:58:59','',''),(2625768,'1','180','934',414,'Retail Sale Id 1620750',2310.00,0.00,0.00,3.00,234.00,'2022-08-20 11:18:51','',''),(2625769,'1','180','934',414,'Retail Sale Id 1620751',6160.00,0.00,0.00,8.00,624.00,'2022-08-20 11:40:02','',''),(2625770,'1','180','934',414,'Retail Sale Id 1620752',2202.20,0.00,0.00,2.86,223.08,'2022-08-20 12:34:28','',''),(2625771,'1','180','934',414,'Retail Sale Id 1620753',4620.00,0.00,0.00,6.00,468.00,'2022-08-20 12:35:29','',''),(2625772,'1','180','934',414,'Retail Sale Id 1620754',2310.00,0.00,0.00,3.00,234.00,'2022-08-20 13:10:55','',''),(2625773,'1','180','934',414,'Retail Sale Id 1620755',2310.00,0.00,0.00,3.00,234.00,'2022-08-20 13:44:42','',''),(2625774,'1','180','934',414,'Retail Sale Id 1620756',3850.00,0.00,0.00,5.00,390.00,'2022-08-20 13:55:30','',''),(2625775,'1','180','934',414,'Retail Sale Id 1620757',4620.00,0.00,0.00,6.00,468.00,'2022-08-20 13:56:15','',''),(2625776,'1','180','934',414,'Retail Sale Id 1620758',2002.00,0.00,0.00,2.60,202.80,'2022-08-20 14:23:27','',''),(2625777,'1','180','934',414,'Retail Sale Id 1620759',2310.00,0.00,0.00,3.00,234.00,'2022-08-20 14:45:58','',''),(2625778,'1','180','934',414,'Retail Sale Id 1620760',2102.10,0.00,0.00,2.73,212.94,'2022-08-20 15:38:58','',''),(2625779,'1','180','934',414,'Retail Sale Id 1620761',3003.00,0.00,0.00,3.90,304.20,'2022-08-20 16:05:20','',''),(2625780,'1','180','934',414,'Retail Sale Id 1620762',3850.00,0.00,0.00,5.00,390.00,'2022-08-20 16:24:55','',''),(2625781,'1','180','934',414,'Retail Sale Id 1620763',4620.00,0.00,0.00,6.00,468.00,'2022-08-20 16:59:29','',''),(2625782,'1','180','934',414,'Retail Sale Id 1620764',4620.00,0.00,0.00,6.00,468.00,'2022-08-20 18:18:46','',''),(2625783,'1','180','934',414,'Retail Sale Id 1620765',3003.00,0.00,0.00,3.90,304.20,'2022-08-21 09:45:21','',''),(2625784,'1','180','934',414,'Retail Sale Id 1620766',9240.00,0.00,0.00,12.00,936.00,'2022-08-21 10:39:47','',''),(2625785,'1','180','934',414,'Retail Sale Id 1620767',1501.50,0.00,0.00,1.95,152.10,'2022-08-21 10:50:22','',''),(2625786,'1','180','934',414,'Retail Sale Id 1620768',2310.00,0.00,0.00,3.00,234.00,'2022-08-21 11:01:18','',''),(2625787,'1','180','934',414,'Retail Sale Id 1620770',4620.00,0.00,0.00,6.00,468.00,'2022-08-21 11:34:06','',''),(2625788,'1','180','934',414,'Retail Sale Id 1620771',1901.90,0.00,0.00,2.47,192.66,'2022-08-21 11:35:13','',''),(2625789,'1','180','934',414,'Retail Sale Id 1620773',2502.50,0.00,0.00,3.25,253.50,'2022-08-21 13:24:28','',''),(2625790,'1','180','934',414,'Retail Sale Id 1620774',2002.00,0.00,0.00,2.60,202.80,'2022-08-21 13:30:27','',''),(2625791,'1','180','934',414,'Retail Sale Id 1620775',2002.00,0.00,0.00,2.60,202.80,'2022-08-21 14:39:27','',''),(2625792,'1','180','934',414,'Retail Sale Id 1620776',36000.00,0.00,0.00,50.00,1400.00,'2022-08-21 14:40:22','',''),(2625793,'1','180','934',414,'Retail Sale Id 1620777',3850.00,0.00,0.00,5.00,390.00,'2022-08-21 14:45:24','',''),(2625794,'1','180','934',414,'Retail Sale Id 1620778',1540.00,0.00,0.00,2.00,156.00,'2022-08-21 16:11:39','',''),(2625795,'1','180','934',414,'Retail Sale Id 1620779',4620.00,0.00,0.00,6.00,468.00,'2022-08-21 16:24:44','',''),(2625796,'1','180','934',414,'Retail Sale Id 1620781',9625.00,0.00,0.00,12.50,975.00,'2022-08-21 16:46:19','',''),(2625797,'1','180','934',414,'Retail Sale Id 1620782',4620.00,0.00,0.00,6.00,468.00,'2022-08-21 16:57:49','',''),(2625798,'1','180','934',414,'Retail Sale Id 1620783',4620.00,0.00,0.00,6.00,468.00,'2022-08-21 18:29:20','',''),(2625799,'1','180','934',414,'Retail Sale Id 1620784',3003.00,0.00,0.00,3.90,304.20,'2022-08-21 18:34:34','',''),(2625800,'1','180','934',414,'Retail Sale Id 1620785',2310.00,0.00,0.00,3.00,234.00,'2022-08-21 18:43:19','',''),(2625801,'1','180','934',414,'Retail Sale Id 1620786',3850.00,0.00,0.00,5.00,390.00,'2022-08-22 09:31:31','',''),(2625802,'1','180','934',414,'Retail Sale Id 1620787',5390.00,0.00,0.00,7.00,546.00,'2022-08-22 09:32:20','',''),(2625803,'1','180','934',414,'Retail Sale Id 1620788',3349.50,0.00,0.00,4.35,339.30,'2022-08-22 09:33:28','',''),(2625804,'1','180','934',414,'Retail Sale Id 1620789',2310.00,0.00,0.00,3.00,234.00,'2022-08-22 09:34:31','',''),(2625805,'1','180','934',414,'Retail Sale Id 1620790',9625.00,0.00,0.00,12.50,975.00,'2022-08-22 09:35:28','',''),(2625806,'1','180','934',414,'Retail Sale Id 1620791',2202.20,0.00,0.00,2.86,223.08,'2022-08-22 09:36:31','',''),(2625807,'1','180','934',414,'Retail Sale Id 1620792',19250.00,0.00,0.00,25.00,1950.00,'2022-08-22 13:53:02','',''),(2625808,'1','180','934',414,'Retail Sale Id 1620793',1540.00,0.00,0.00,2.00,156.00,'2022-08-22 13:54:09','',''),(2625809,'1','180','934',414,'Retail Sale Id 1620794',9625.00,0.00,0.00,12.50,975.00,'2022-08-22 15:58:42','',''),(2625810,'1','180','934',414,'Retail Sale Id 1620795',19250.00,0.00,0.00,25.00,1950.00,'2022-08-22 15:59:42','',''),(2625811,'1','180','934',414,'Retail Sale Id 1620796',2002.00,0.00,0.00,2.60,202.80,'2022-08-22 16:00:35','',''),(2625812,'1','180','934',414,'Retail Sale Id 1620797',43200.00,0.00,0.00,60.00,1680.00,'2022-08-22 17:33:10','',''),(2625813,'1','180','934',414,'Retail Sale Id 1620798',1001.00,0.00,0.00,1.30,101.40,'2022-08-22 18:01:54','',''),(2625814,'1','180','934',414,'Retail Sale Id 1620799',3080.00,0.00,0.00,4.00,312.00,'2022-08-23 09:38:57','',''),(2625815,'1','180','934',414,'Retail Sale Id 1620800',2310.00,0.00,0.00,3.00,234.00,'2022-08-23 09:39:56','',''),(2625816,'1','180','934',414,'Retail Sale Id 1620801',4620.00,0.00,0.00,6.00,468.00,'2022-08-23 09:42:09','',''),(2625817,'1','180','934',414,'Retail Sale Id 1620802',1001.00,0.00,0.00,1.30,101.40,'2022-08-23 09:43:09','',''),(2625818,'1','180','934',414,'Retail Sale Id 1620803',36000.00,0.00,0.00,50.00,1400.00,'2022-08-23 19:31:44','',''),(2625819,'1','180','934',414,'Retail Sale Id 1620804',86400.00,0.00,0.00,120.00,3360.00,'2022-08-23 19:32:47','',''),(2625820,'1','180','934',414,'Distributed to OPERATIONAL LOSS for sales id:344953',136337.84,0.00,0.00,197.02,0.00,'2022-09-10 00:55:08','',''),(2625821,'1','180',NULL,414,'Purchased from AA RANO NIG. LIMITED',0.00,3493500.00,5100.00,0.00,0.00,'2022-09-10 00:58:55','',''),(2625822,'1','180',NULL,414,'Reception corrector for bridging 130296',0.00,0.00,0.00,5100.00,0.00,'2022-09-10 00:59:54','',''),(2625823,'1','180','934',414,'Received from bridging 130296',0.00,0.00,5100.00,0.00,0.00,'2022-09-10 00:59:54','',''),(2625824,'1','180','934',414,'Retail Sale Id 1620805',3850.00,0.00,0.00,5.00,425.00,'2022-09-10 14:55:05','',''),(2625825,'1','180','934',414,'Retail Sale Id 1620806',4620.00,0.00,0.00,6.00,510.00,'2022-09-10 15:04:41','',''),(2625826,'1','180','934',414,'Retail Sale Id 1620807',4620.00,0.00,0.00,6.00,510.00,'2022-09-10 15:11:29','',''),(2625827,'1','180','934',414,'Retail Sale Id 1620808',2502.50,0.00,0.00,3.25,276.25,'2022-09-10 15:35:49','',''),(2625828,'1','180','934',414,'Retail Sale Id 1620809',1540.00,0.00,0.00,2.00,170.00,'2022-09-10 16:41:07','',''),(2625829,'1','180','934',414,'Retail Sale Id 1620810',8470.00,0.00,0.00,11.00,935.00,'2022-09-10 17:38:39','',''),(2625830,'1','180','934',414,'Retail Sale Id 1620811',4620.00,0.00,0.00,6.00,510.00,'2022-09-10 17:55:11','',''),(2625831,'1','180','934',414,'Retail Sale Id 1620812',3003.00,0.00,0.00,3.90,331.50,'2022-09-10 21:01:49','',''),(2625832,'1','180','934',414,'Retail Sale Id 1620813',2310.00,0.00,0.00,3.00,255.00,'2022-09-11 12:22:57','',''),(2625833,'1','180','934',414,'Retail Sale Id 1620814',3003.00,0.00,0.00,3.90,331.50,'2022-09-11 12:23:57','',''),(2625834,'1','180','934',414,'Retail Sale Id 1620815',1701.70,0.00,0.00,2.21,187.85,'2022-09-11 12:24:48','',''),(2625835,'1','180','934',414,'Retail Sale Id 1620816',3996.30,0.00,0.00,5.19,441.15,'2022-09-11 12:25:36','',''),(2625836,'1','180','934',414,'Retail Sale Id 1620817',2802.80,0.00,0.00,3.64,309.40,'2022-09-11 12:31:31','',''),(2625837,'1','180','934',414,'Retail Sale Id 1620818',2310.00,0.00,0.00,3.00,255.00,'2022-09-11 16:37:13','',''),(2625838,'1','180','934',414,'Retail Sale Id 1620819',9240.00,0.00,0.00,12.00,1020.00,'2022-09-11 18:17:41','',''),(2625839,'1','180','934',414,'Retail Sale Id 1620820',4620.00,0.00,0.00,6.00,510.00,'2022-09-11 18:18:41','',''),(2625840,'1','180','934',414,'Retail Sale Id 1620821',3003.00,0.00,0.00,3.90,331.50,'2022-09-11 18:19:36','',''),(2625841,'1','180','934',414,'Retail Sale Id 1620822',2002.00,0.00,0.00,2.60,221.00,'2022-09-11 18:22:46','',''),(2625842,'1','180','934',414,'Retail Sale Id 1620823',2310.00,0.00,0.00,3.00,255.00,'2022-09-11 18:23:37','',''),(2625843,'1','180','934',414,'Retail Sale Id 1620824',3003.00,0.00,0.00,3.90,331.50,'2022-09-12 12:20:39','',''),(2625844,'1','180','934',414,'Retail Sale Id 1620825',3850.00,0.00,0.00,5.00,425.00,'2022-09-12 14:38:08','',''),(2625845,'1','180','934',414,'Retail Sale Id 1620826',3850.00,0.00,0.00,5.00,425.00,'2022-09-12 14:39:16','',''),(2625846,'1','180','934',414,'Retail Sale Id 1620827',41760.00,0.00,0.00,58.00,2030.00,'2022-09-12 14:40:39','',''),(2625847,'1','180','934',414,'Retail Sale Id 1620828',2310.00,0.00,0.00,3.00,255.00,'2022-09-12 15:13:37','',''),(2625848,'1','180','934',414,'Retail Sale Id 1620829',19250.00,0.00,0.00,25.00,2125.00,'2022-09-12 15:21:52','',''),(2625849,'1','180','934',414,'Retail Sale Id 1620830',2002.00,0.00,0.00,2.60,221.00,'2022-09-12 15:23:56','',''),(2625850,'1','180','934',414,'Retail Sale Id 1620831',4620.00,0.00,0.00,6.00,510.00,'2022-09-12 17:07:01','',''),(2625851,'1','180','934',414,'Retail Sale Id 1620832',1540.00,0.00,0.00,2.00,170.00,'2022-09-12 17:07:40','',''),(2625852,'1','180','934',414,'Retail Sale Id 1620833',1001.00,0.00,0.00,1.30,110.50,'2022-09-12 17:53:53','',''),(2625853,'1','180','934',414,'Retail Sale Id 1620834',9625.00,0.00,0.00,12.50,1062.50,'2022-09-13 08:06:09','',''),(2625854,'1','180','934',414,'Retail Sale Id 1620835',4620.00,0.00,0.00,6.00,510.00,'2022-09-13 11:11:43','',''),(2625855,'1','180','934',414,'Retail Sale Id 1620836',4620.00,0.00,0.00,6.00,510.00,'2022-09-13 11:13:43','',''),(2625856,'1','180','934',414,'Retail Sale Id 1620837',2002.00,0.00,0.00,2.60,221.00,'2022-09-13 11:15:24','',''),(2625857,'1','180','934',414,'Retail Sale Id 1620838',1925.00,0.00,0.00,2.50,212.50,'2022-09-13 11:16:53','',''),(2625858,'1','180','934',414,'Retail Sale Id 1620839',3850.00,0.00,0.00,5.00,425.00,'2022-09-13 11:49:23','',''),(2625859,'1','180','934',414,'Retail Sale Id 1620840',4620.00,0.00,0.00,6.00,510.00,'2022-09-13 12:51:41','',''),(2625860,'1','180','934',414,'Retail Sale Id 1620841',3003.00,0.00,0.00,3.90,331.50,'2022-09-13 13:39:41','',''),(2625861,'1','180','934',414,'Retail Sale Id 1620842',4620.00,0.00,0.00,6.00,510.00,'2022-09-13 13:41:40','',''),(2625862,'1','180','934',414,'Retail Sale Id 1620843',1540.00,0.00,0.00,2.00,170.00,'2022-09-13 13:44:09','',''),(2625863,'1','180','934',414,'Retail Sale Id 1620844',2310.00,0.00,0.00,3.00,255.00,'2022-09-13 16:32:05','',''),(2625864,'1','180','934',414,'Retail Sale Id 1620845',3003.00,0.00,0.00,3.90,331.50,'2022-09-13 16:33:08','',''),(2625865,'1','180','934',414,'Retail Sale Id 1620846',4620.00,0.00,0.00,6.00,510.00,'2022-09-13 16:33:48','',''),(2625866,'1','180','934',414,'Retail Sale Id 1620847',3850.00,0.00,0.00,5.00,425.00,'2022-09-13 16:39:43','',''),(2625867,'1','180','934',414,'Retail Sale Id 1620848',3850.00,0.00,0.00,5.00,425.00,'2022-09-13 16:46:02','',''),(2625868,'1','180','934',414,'Retail Sale Id 1620849',3003.00,0.00,0.00,3.90,331.50,'2022-09-13 18:17:39','',''),(2625869,'1','180','934',414,'Retail Sale Id 1620850',5497.80,0.00,0.00,7.14,606.90,'2022-09-14 09:05:46','',''),(2625870,'1','180','934',414,'Retail Sale Id 1620851',7499.80,0.00,0.00,9.74,827.90,'2022-09-14 11:24:21','',''),(2625871,'1','180','934',414,'Retail Sale Id 1620852',3003.00,0.00,0.00,3.90,331.50,'2022-09-14 11:25:16','',''),(2625872,'1','180','934',414,'Retail Sale Id 1620853',9001.30,0.00,0.00,11.69,993.65,'2022-09-14 12:57:51','',''),(2625873,'1','180','934',414,'Retail Sale Id 1620854',3341.80,0.00,0.00,4.34,368.90,'2022-09-14 12:59:09','',''),(2625874,'1','180','934',414,'Retail Sale Id 1620855',4620.00,0.00,0.00,6.00,510.00,'2022-09-14 12:59:59','',''),(2625875,'1','180','934',414,'Retail Sale Id 1620856',2310.00,0.00,0.00,3.00,255.00,'2022-09-14 14:31:53','',''),(2625876,'1','180','934',414,'Retail Sale Id 1620857',2002.00,0.00,0.00,2.60,221.00,'2022-09-14 15:16:33','',''),(2625877,'1','180','934',414,'Retail Sale Id 1620858',3850.00,0.00,0.00,5.00,425.00,'2022-09-14 15:39:06','',''),(2625878,'1','180','934',414,'Retail Sale Id 1620859',3503.50,0.00,0.00,4.55,386.75,'2022-09-14 20:24:13','',''),(2625879,'1','180','934',414,'Retail Sale Id 1620860',2310.00,0.00,0.00,3.00,255.00,'2022-09-14 20:24:59','',''),(2625880,'1','180','934',414,'Retail Sale Id 1620861',8470.00,0.00,0.00,11.00,935.00,'2022-09-15 08:38:52','',''),(2625881,'1','180','934',414,'Retail Sale Id 1620862',7700.00,0.00,0.00,10.00,850.00,'2022-09-15 13:53:15','',''),(2625882,'1','180','934',414,'Retail Sale Id 1620863',4620.00,0.00,0.00,6.00,510.00,'2022-09-15 16:28:18','',''),(2625883,'1','180','934',414,'Retail Sale Id 1620864',2310.00,0.00,0.00,3.00,255.00,'2022-09-15 17:11:24','',''),(2625884,'1','180','934',414,'Retail Sale Id 1620865',2310.00,0.00,0.00,3.00,255.00,'2022-09-15 17:24:24','',''),(2625885,'1','180','934',414,'Retail Sale Id 1620866',13875.40,0.00,0.00,18.02,1531.70,'2022-09-15 17:35:24','',''),(2625886,'1','180','934',414,'Retail Sale Id 1620867',6930.00,0.00,0.00,9.00,765.00,'2022-09-15 18:01:53','',''),(2625887,'1','180','934',414,'Retail Sale Id 1620868',4620.00,0.00,0.00,6.00,510.00,'2022-09-16 09:29:06','',''),(2625888,'1','180','934',414,'Retail Sale Id 1620869',3996.30,0.00,0.00,5.19,441.15,'2022-09-16 09:30:44','',''),(2625889,'1','180','934',414,'Retail Sale Id 1620870',4620.00,0.00,0.00,6.00,510.00,'2022-09-16 11:21:31','',''),(2625890,'1','180','934',414,'Retail Sale Id 1620871',3003.00,0.00,0.00,3.90,331.50,'2022-09-16 11:22:40','',''),(2625891,'1','180','934',414,'Retail Sale Id 1620872',1001.00,0.00,0.00,1.30,110.50,'2022-09-16 12:02:47','',''),(2625892,'1','180','934',414,'Retail Sale Id 1620873',1771.00,0.00,0.00,2.30,195.50,'2022-09-16 12:22:02','',''),(2625893,'1','180','934',414,'Retail Sale Id 1620874',3003.00,0.00,0.00,3.90,331.50,'2022-09-16 12:41:32','',''),(2625894,'1','180','934',414,'Retail Sale Id 1620875',4620.00,0.00,0.00,6.00,510.00,'2022-09-16 18:27:57','',''),(2625895,'1','180','934',414,'Retail Sale Id 1620876',2310.00,0.00,0.00,3.00,255.00,'2022-09-16 18:28:35','',''),(2625896,'1','180','934',414,'Retail Sale Id 1620877',43200.00,0.00,0.00,60.00,2100.00,'2022-09-16 18:29:31','',''),(2625897,'1','180','934',414,'Retail Sale Id 1620878',4620.00,0.00,0.00,6.00,510.00,'2022-09-16 18:36:42','',''),(2625898,'1','180','934',414,'Retail Sale Id 1620879',3003.00,0.00,0.00,3.90,331.50,'2022-09-16 18:37:20','',''),(2625899,'1','180','934',414,'Retail Sale Id 1620880',4620.00,0.00,0.00,6.00,510.00,'2022-09-17 09:42:40','',''),(2625900,'1','180','934',414,'Retail Sale Id 1620881',5497.80,0.00,0.00,7.14,606.90,'2022-09-17 11:42:40','',''),(2625901,'1','180','934',414,'Retail Sale Id 1620882',2310.00,0.00,0.00,3.00,255.00,'2022-09-17 12:10:42','',''),(2625902,'1','180','934',414,'Retail Sale Id 1620883',6160.00,0.00,0.00,8.00,680.00,'2022-09-17 13:03:30','',''),(2625903,'1','180','934',414,'Retail Sale Id 1620884',9625.00,0.00,0.00,12.50,1062.50,'2022-09-17 13:39:20','',''),(2625904,'1','180','934',414,'Retail Sale Id 1620885',2202.20,0.00,0.00,2.86,243.10,'2022-09-17 14:16:07','',''),(2625905,'1','180','934',414,'Retail Sale Id 1620886',43200.00,0.00,0.00,60.00,2100.00,'2022-09-17 17:48:35','',''),(2625906,'1','180','934',414,'Retail Sale Id 1620887',9625.00,0.00,0.00,12.50,1062.50,'2022-09-17 17:58:41','',''),(2625907,'1','180','934',414,'Retail Sale Id 1620888',4620.00,0.00,0.00,6.00,510.00,'2022-09-17 18:00:54','',''),(2625908,'1','180','934',414,'Retail Sale Id 1620889',1540.00,0.00,0.00,2.00,170.00,'2022-09-17 18:04:57','',''),(2625909,'1','180','934',414,'Retail Sale Id 1620890',6999.30,0.00,0.00,9.09,772.65,'2022-09-17 18:20:17','',''),(2625910,'1','180','934',414,'Retail Sale Id 1620891',4620.00,0.00,0.00,6.00,510.00,'2022-09-17 18:24:14','',''),(2625911,'1','180','934',414,'Retail Sale Id 1620892',4620.00,0.00,0.00,6.00,510.00,'2022-09-17 18:28:20','',''),(2625912,'1','180','934',414,'Retail Sale Id 1620893',26950.00,0.00,0.00,35.00,2975.00,'2022-09-17 18:38:09','',''),(2625913,'1','180','934',414,'Retail Sale Id 1620894',4620.00,0.00,0.00,6.00,510.00,'2022-09-17 18:38:50','',''),(2625914,'1','180','934',414,'Retail Sale Id 1620895',5998.30,0.00,0.00,7.79,662.15,'2022-09-18 09:32:16','',''),(2625915,'1','180','934',414,'Retail Sale Id 1620896',2202.20,0.00,0.00,2.86,243.10,'2022-09-18 09:33:20','',''),(2625916,'1','180','934',414,'Retail Sale Id 1620897',1001.00,0.00,0.00,1.30,110.50,'2022-09-18 10:36:41','',''),(2625917,'1','180','934',414,'Retail Sale Id 1620898',2202.20,0.00,0.00,2.86,243.10,'2022-09-18 10:56:33','',''),(2625918,'1','180','934',414,'Retail Sale Id 1620899',1001.00,0.00,0.00,1.30,110.50,'2022-09-18 11:00:03','',''),(2625919,'1','180','934',414,'Retail Sale Id 1620900',10002.30,0.00,0.00,12.99,1104.15,'2022-09-18 11:26:00','',''),(2625920,'1','180','934',414,'Retail Sale Id 1620901',2310.00,0.00,0.00,3.00,255.00,'2022-09-18 11:26:46','',''),(2625921,'1','180','934',414,'Retail Sale Id 1620902',1401.40,0.00,0.00,1.82,154.70,'2022-09-18 11:27:38','',''),(2625922,'1','180','934',414,'Retail Sale Id 1620903',2202.20,0.00,0.00,2.86,243.10,'2022-09-18 11:48:49','',''),(2625923,'1','180','934',414,'Retail Sale Id 1620904',2002.00,0.00,0.00,2.60,221.00,'2022-09-18 12:14:13','',''),(2625924,'1','180','934',414,'Retail Sale Id 1620905',3811.50,0.00,0.00,4.95,420.75,'2022-09-18 12:40:50','',''),(2625925,'1','180','934',414,'Retail Sale Id 1620906',6306.30,0.00,0.00,8.19,696.15,'2022-09-18 14:10:47','',''),(2625926,'1','180','934',414,'Retail Sale Id 1620907',15315.30,0.00,0.00,19.89,1690.65,'2022-09-18 18:32:46','',''),(2625927,'1','180','934',414,'Retail Sale Id 1620908',83520.00,0.00,0.00,116.00,4060.00,'2022-09-18 18:34:00','',''),(2625928,'1','180','934',414,'Retail Sale Id 1620909',9001.30,0.00,0.00,11.69,993.65,'2022-09-19 09:33:47','',''),(2625929,'1','180','934',414,'Retail Sale Id 1620910',3850.00,0.00,0.00,5.00,425.00,'2022-09-19 09:34:30','',''),(2625930,'1','180','934',414,'Retail Sale Id 1620911',9101.40,0.00,0.00,11.82,1004.70,'2022-09-19 10:58:52','',''),(2625931,'1','180','934',414,'Retail Sale Id 1620912',10310.30,0.00,0.00,13.39,1138.15,'2022-09-19 11:00:14','',''),(2625932,'1','180','934',414,'Retail Sale Id 1620913',2002.00,0.00,0.00,2.60,221.00,'2022-09-19 11:01:43','',''),(2625933,'1','180','934',414,'Retail Sale Id 1620914',6999.30,0.00,0.00,9.09,772.65,'2022-09-19 11:37:41','',''),(2625934,'1','180','934',414,'Retail Sale Id 1620915',19250.00,0.00,0.00,25.00,2125.00,'2022-09-19 11:38:31','',''),(2625935,'1','180','934',414,'Retail Sale Id 1620916',9625.00,0.00,0.00,12.50,1062.50,'2022-09-19 11:53:04','',''),(2625936,'1','180','934',414,'Retail Sale Id 1620917',2202.20,0.00,0.00,2.86,243.10,'2022-09-19 11:54:04','',''),(2625937,'1','180','934',414,'Retail Sale Id 1620918',9625.00,0.00,0.00,12.50,1062.50,'2022-09-19 12:36:26','',''),(2625938,'1','180','934',414,'Retail Sale Id 1620919',9625.00,0.00,0.00,12.50,1062.50,'2022-09-19 13:21:50','',''),(2625939,'1','180','934',414,'Retail Sale Id 1620920',6083.00,0.00,0.00,7.90,671.50,'2022-09-19 16:32:37','',''),(2625940,'1','180','934',414,'Retail Sale Id 1620921',4620.00,0.00,0.00,6.00,510.00,'2022-09-19 16:33:32','',''),(2625941,'1','180','934',414,'Retail Sale Id 1620922',9240.00,0.00,0.00,12.00,1020.00,'2022-09-19 16:43:58','',''),(2625942,'1','180','934',414,'Retail Sale Id 1620923',2002.00,0.00,0.00,2.60,221.00,'2022-09-19 16:44:50','',''),(2625943,'1','180','934',414,'Retail Sale Id 1620924',9625.00,0.00,0.00,12.50,1062.50,'2022-09-19 17:04:52','',''),(2625944,'1','180','934',414,'Retail Sale Id 1620925',2541.00,0.00,0.00,3.30,280.50,'2022-09-19 17:46:01','',''),(2625945,'1','180','934',414,'Retail Sale Id 1620926',4296.60,0.00,0.00,5.58,474.30,'2022-09-19 17:47:08','',''),(2625946,'1','180','934',414,'Retail Sale Id 1620927',9240.00,0.00,0.00,12.00,1020.00,'2022-09-20 09:15:29','',''),(2625947,'1','180','934',414,'Retail Sale Id 1620928',2502.50,0.00,0.00,3.25,276.25,'2022-09-20 09:16:21','',''),(2625948,'1','180','934',414,'Retail Sale Id 1620929',8470.00,0.00,0.00,11.00,935.00,'2022-09-20 09:59:07','',''),(2625949,'1','180','934',414,'Retail Sale Id 1620931',2002.00,0.00,0.00,2.60,221.00,'2022-09-20 10:01:12','',''),(2625950,'1','180','934',414,'Retail Sale Id 1620932',8616.30,0.00,0.00,11.19,951.15,'2022-09-20 13:44:59','',''),(2625951,'1','180','934',414,'Retail Sale Id 1620933',2002.00,0.00,0.00,2.60,221.00,'2022-09-20 14:18:57','',''),(2625952,'1','180','934',414,'Retail Sale Id 1620934',5497.80,0.00,0.00,7.14,606.90,'2022-09-20 16:33:57','',''),(2625953,'1','180','934',414,'Retail Sale Id 1620935',6160.00,0.00,0.00,8.00,680.00,'2022-09-20 16:34:56','',''),(2625954,'1','180','934',414,'Retail Sale Id 1620936',3041.50,0.00,0.00,3.95,335.75,'2022-09-20 18:09:29','',''),(2625955,'1','180','934',414,'Retail Sale Id 1620937',2502.50,0.00,0.00,3.25,276.25,'2022-09-20 18:11:07','',''),(2625956,'1','180','934',414,'Retail Sale Id 1620938',7499.80,0.00,0.00,9.74,827.90,'2022-09-21 09:16:44','',''),(2625957,'1','180','934',414,'Retail Sale Id 1620939',3850.00,0.00,0.00,5.00,425.00,'2022-09-21 09:34:07','',''),(2625958,'1','180','934',414,'Retail Sale Id 1620940',2002.00,0.00,0.00,2.60,221.00,'2022-09-21 10:23:12','',''),(2625959,'1','180','934',414,'Retail Sale Id 1620941',3080.00,0.00,0.00,4.00,340.00,'2022-09-21 10:24:04','',''),(2625960,'1','180','934',414,'Retail Sale Id 1620942',1001.00,0.00,0.00,1.30,110.50,'2022-09-21 11:06:48','',''),(2625961,'1','180','934',414,'Retail Sale Id 1620944',43200.00,0.00,0.00,60.00,2100.00,'2022-09-21 16:40:52','',''),(2625962,'1','180','934',414,'Retail Sale Id 1620945',7700.00,0.00,0.00,10.00,850.00,'2022-09-21 16:42:33','',''),(2625963,'1','180','934',414,'Retail Sale Id 1620946',3996.30,0.00,0.00,5.19,441.15,'2022-09-21 16:57:27','',''),(2625964,'1','180','934',414,'Retail Sale Id 1620947',2002.00,0.00,0.00,2.60,221.00,'2022-09-21 16:58:06','',''),(2625965,'1','180','934',414,'Retail Sale Id 1620948',4620.00,0.00,0.00,6.00,510.00,'2022-09-21 16:59:15','',''),(2625966,'1','180','934',414,'Retail Sale Id 1620949',6999.30,0.00,0.00,9.09,772.65,'2022-09-21 17:58:20','',''),(2625967,'1','180','934',414,'Retail Sale Id 1620950',15592.50,0.00,0.00,20.25,1721.25,'2022-09-21 18:10:37','',''),(2625968,'1','180','934',414,'Retail Sale Id 1620951',2310.00,0.00,0.00,3.00,255.00,'2022-09-22 09:12:34','',''),(2625969,'1','180','934',414,'Retail Sale Id 1620952',2202.20,0.00,0.00,2.86,243.10,'2022-09-22 12:38:39','',''),(2625970,'1','180','934',414,'Retail Sale Id 1620953',2310.00,0.00,0.00,3.00,255.00,'2022-09-22 13:22:04','',''),(2625971,'1','180','934',414,'Retail Sale Id 1620954',2310.00,0.00,0.00,3.00,255.00,'2022-09-22 13:41:01','',''),(2625972,'1','180','934',414,'Retail Sale Id 1620955',36000.00,0.00,0.00,50.00,1750.00,'2022-09-22 19:16:09','',''),(2625973,'1','180','934',414,'Retail Sale Id 1620956',4620.00,0.00,0.00,6.00,510.00,'2022-09-22 19:16:54','',''),(2625974,'1','180','934',414,'Retail Sale Id 1620957',7700.00,0.00,0.00,10.00,850.00,'2022-09-23 10:56:36','',''),(2625975,'1','180','934',414,'Retail Sale Id 1620958',3850.00,0.00,0.00,5.00,425.00,'2022-09-23 10:57:27','',''),(2625976,'1','180','934',414,'Retail Sale Id 1620959',6930.00,0.00,0.00,9.00,765.00,'2022-09-23 10:58:10','',''),(2625977,'1','180','934',414,'Retail Sale Id 1620960',3303.30,0.00,0.00,4.29,364.65,'2022-09-23 10:58:53','',''),(2625978,'1','180','934',414,'Retail Sale Id 1620961',2002.00,0.00,0.00,2.60,221.00,'2022-09-23 11:03:00','',''),(2625979,'1','180','934',414,'Retail Sale Id 1620962',3850.00,0.00,0.00,5.00,425.00,'2022-09-23 11:21:12','',''),(2625980,'1','180','934',414,'Retail Sale Id 1620963',500.50,0.00,0.00,0.65,55.25,'2022-09-23 12:57:21','',''),(2625981,'1','180','934',414,'Retail Sale Id 1620964',1001.00,0.00,0.00,1.30,110.50,'2022-09-23 13:38:38','',''),(2625982,'1','180','934',414,'Retail Sale Id 1620965',3003.00,0.00,0.00,3.90,331.50,'2022-09-23 14:22:38','',''),(2625983,'1','180','934',414,'Retail Sale Id 1620966',2310.00,0.00,0.00,3.00,255.00,'2022-09-23 14:40:25','',''),(2625984,'1','180','934',414,'Retail Sale Id 1620967',500.50,0.00,0.00,0.65,55.25,'2022-09-23 15:13:45','',''),(2625985,'1','180','934',414,'Retail Sale Id 1620968',3850.00,0.00,0.00,5.00,425.00,'2022-09-23 16:28:07','',''),(2625986,'1','180','934',414,'Retail Sale Id 1620969',2310.00,0.00,0.00,3.00,255.00,'2022-09-23 16:53:13','',''),(2625987,'1','180','934',414,'Retail Sale Id 1620970',9001.30,0.00,0.00,11.69,993.65,'2022-09-23 17:13:26','',''),(2625988,'1','180','934',414,'Retail Sale Id 1620971',36000.00,0.00,0.00,50.00,1750.00,'2022-09-23 18:31:02','',''),(2625989,'1','180','934',414,'Retail Sale Id 1620972',3850.00,0.00,0.00,5.00,425.00,'2022-09-24 10:08:01','',''),(2625990,'1','180','934',414,'Retail Sale Id 1620973',3850.00,0.00,0.00,5.00,425.00,'2022-09-24 10:08:39','',''),(2625991,'1','180','934',414,'Retail Sale Id 1620974',1540.00,0.00,0.00,2.00,170.00,'2022-09-24 10:51:16','',''),(2625992,'1','180','934',414,'Retail Sale Id 1620975',144000.00,0.00,0.00,200.00,7000.00,'2022-09-24 10:56:48','',''),(2625993,'1','180','934',414,'Retail Sale Id 1620976',7700.00,0.00,0.00,10.00,850.00,'2022-09-24 10:58:02','',''),(2625994,'1','180','934',414,'Retail Sale Id 1620977',3203.20,0.00,0.00,4.16,353.60,'2022-09-24 10:58:53','',''),(2625995,'1','180','934',414,'Retail Sale Id 1620978',9625.00,0.00,0.00,12.50,1062.50,'2022-09-24 10:59:37','',''),(2625996,'1','180','934',414,'Retail Sale Id 1620979',1801.80,0.00,0.00,2.34,198.90,'2022-09-24 11:19:35','',''),(2625997,'1','180','934',414,'Retail Sale Id 1620981',2002.00,0.00,0.00,2.60,221.00,'2022-09-24 11:21:35','',''),(2625998,'1','180','934',414,'Retail Sale Id 1620982',2002.00,0.00,0.00,2.60,221.00,'2022-09-24 11:28:43','',''),(2625999,'1','180','934',414,'Retail Sale Id 1620985',2310.00,0.00,0.00,3.00,255.00,'2022-09-25 10:24:59','',''),(2626000,'1','180','934',414,'Retail Sale Id 1620986',2440.90,0.00,0.00,3.17,269.45,'2022-09-25 10:26:39','',''),(2626001,'1','180','934',414,'Retail Sale Id 1620987',1101.10,0.00,0.00,1.43,121.55,'2022-09-25 10:28:05','',''),(2626002,'1','180','934',414,'Retail Sale Id 1620988',4620.00,0.00,0.00,6.00,510.00,'2022-09-25 10:58:45','',''),(2626003,'1','180','934',414,'Retail Sale Id 1620989',5898.20,0.00,0.00,7.66,651.10,'2022-09-25 11:37:59','',''),(2626004,'1','180','934',414,'Retail Sale Id 1620990',2310.00,0.00,0.00,3.00,255.00,'2022-09-25 14:31:06','',''),(2626005,'1','180','934',414,'Retail Sale Id 1620991',4496.80,0.00,0.00,5.84,496.40,'2022-09-25 14:53:28','',''),(2626006,'1','180','934',414,'Retail Sale Id 1620992',2310.00,0.00,0.00,3.00,255.00,'2022-09-25 15:56:41','',''),(2626007,'1','180','934',414,'Retail Sale Id 1620993',3003.00,0.00,0.00,3.90,331.50,'2022-09-25 16:43:53','',''),(2626008,'1','180','934',414,'Retail Sale Id 1620994',2002.00,0.00,0.00,2.60,221.00,'2022-09-25 17:13:21','',''),(2626009,'1','180','934',414,'Retail Sale Id 1620995',2310.00,0.00,0.00,3.00,255.00,'2022-09-25 17:47:10','',''),(2626010,'1','180','934',414,'Retail Sale Id 1620996',2002.00,0.00,0.00,2.60,221.00,'2022-09-25 17:58:21','',''),(2626011,'1','180','934',414,'Retail Sale Id 1620997',2310.00,0.00,0.00,3.00,255.00,'2022-09-25 18:19:07','',''),(2626012,'1','180','934',414,'Retail Sale Id 1620998',41760.00,0.00,0.00,58.00,2030.00,'2022-09-25 18:35:24','',''),(2626013,'1','180','934',414,'Retail Sale Id 1620999',1501.50,0.00,0.00,1.95,165.75,'2022-09-25 18:41:00','',''),(2626014,'1','180','934',414,'Retail Sale Id 1621000',4512.20,0.00,0.00,5.86,498.10,'2022-09-26 08:59:24','',''),(2626015,'1','180','934',414,'Retail Sale Id 1621001',1001.00,0.00,0.00,1.30,110.50,'2022-09-26 10:56:39','',''),(2626016,'1','180','934',414,'Retail Sale Id 1621002',2310.00,0.00,0.00,3.00,255.00,'2022-09-26 11:08:51','',''),(2626017,'1','180','934',414,'Retail Sale Id 1621003',2002.00,0.00,0.00,2.60,221.00,'2022-09-26 14:01:34','',''),(2626018,'1','180','934',414,'Retail Sale Id 1621004',2310.00,0.00,0.00,3.00,255.00,'2022-09-26 14:02:21','',''),(2626019,'1','180','934',414,'Retail Sale Id 1621005',6160.00,0.00,0.00,8.00,680.00,'2022-09-26 14:03:06','',''),(2626020,'1','180','934',414,'Retail Sale Id 1621006',4620.00,0.00,0.00,6.00,510.00,'2022-09-26 14:21:40','',''),(2626021,'1','180','934',414,'Retail Sale Id 1621007',1001.00,0.00,0.00,1.30,110.50,'2022-09-26 15:18:02','',''),(2626022,'1','180','934',414,'Retail Sale Id 1621008',2310.00,0.00,0.00,3.00,255.00,'2022-09-26 15:32:51','',''),(2626023,'1','180','934',414,'Retail Sale Id 1621009',4620.00,0.00,0.00,6.00,510.00,'2022-09-26 16:14:47','',''),(2626024,'1','180','934',414,'Retail Sale Id 1621010',2310.00,0.00,0.00,3.00,255.00,'2022-09-26 16:15:42','',''),(2626025,'1','180','934',414,'Retail Sale Id 1621011',108000.00,0.00,0.00,150.00,5250.00,'2022-09-26 16:19:30','',''),(2626026,'1','180','934',414,'Retail Sale Id 1621012',1001.00,0.00,0.00,1.30,110.50,'2022-09-26 16:29:56','',''),(2626027,'1','180','934',414,'Retail Sale Id 1621013',1540.00,0.00,0.00,2.00,170.00,'2022-09-26 16:33:39','',''),(2626028,'1','180','934',414,'Retail Sale Id 1621014',3996.30,0.00,0.00,5.19,441.15,'2022-09-26 16:42:29','',''),(2626029,'1','180','934',414,'Retail Sale Id 1621015',1001.00,0.00,0.00,1.30,110.50,'2022-09-26 16:46:02','',''),(2626030,'1','180','934',414,'Retail Sale Id 1621016',2310.00,0.00,0.00,3.00,255.00,'2022-09-26 17:28:02','',''),(2626031,'1','180','934',414,'Retail Sale Id 1621017',3080.00,0.00,0.00,4.00,340.00,'2022-09-26 17:54:07','',''),(2626032,'1','180','934',414,'Retail Sale Id 1621018',4620.00,0.00,0.00,6.00,510.00,'2022-09-26 18:01:02','',''),(2626033,'1','180','934',414,'Retail Sale Id 1621019',7700.00,0.00,0.00,10.00,850.00,'2022-09-27 09:27:56','',''),(2626034,'1','180','934',414,'Retail Sale Id 1621020',3080.00,0.00,0.00,4.00,340.00,'2022-09-27 09:29:12','',''),(2626035,'1','180','934',414,'Retail Sale Id 1621021',1001.00,0.00,0.00,1.30,110.50,'2022-09-27 09:30:23','',''),(2626036,'1','180','934',414,'Retail Sale Id 1621022',2748.90,0.00,0.00,3.57,303.45,'2022-09-27 10:47:36','',''),(2626037,'1','180','934',414,'Retail Sale Id 1621023',1501.50,0.00,0.00,1.95,165.75,'2022-09-27 11:55:05','',''),(2626038,'1','180','934',414,'Retail Sale Id 1621024',1547.70,0.00,0.00,2.01,170.85,'2022-09-27 12:02:18','',''),(2626039,'1','180','934',414,'Retail Sale Id 1621025',2310.00,0.00,0.00,3.00,255.00,'2022-09-27 12:33:47','',''),(2626040,'1','180','934',414,'Retail Sale Id 1621026',700.70,0.00,0.00,0.91,77.35,'2022-09-27 12:44:27','',''),(2626041,'1','180','934',414,'Retail Sale Id 1621027',4620.00,0.00,0.00,6.00,510.00,'2022-09-27 12:51:45','',''),(2626042,'1','180','934',414,'Retail Sale Id 1621028',2310.00,0.00,0.00,3.00,255.00,'2022-09-27 15:57:16','',''),(2626043,'1','180','934',414,'Retail Sale Id 1621029',2310.00,0.00,0.00,3.00,255.00,'2022-09-27 16:22:06','',''),(2626044,'1','180','934',414,'Retail Sale Id 1621030',7700.00,0.00,0.00,10.00,850.00,'2022-09-27 16:30:36','',''),(2626045,'1','180','934',414,'Retail Sale Id 1621031',4620.00,0.00,0.00,6.00,510.00,'2022-09-27 17:01:22','',''),(2626046,'1','180','934',414,'Retail Sale Id 1621032',2310.00,0.00,0.00,3.00,255.00,'2022-09-27 17:18:48','',''),(2626047,'1','180','934',414,'Retail Sale Id 1621033',1001.00,0.00,0.00,1.30,110.50,'2022-09-27 17:41:18','',''),(2626048,'1','180','934',414,'Retail Sale Id 1621034',3850.00,0.00,0.00,5.00,425.00,'2022-09-27 17:42:11','',''),(2626049,'1','180','934',414,'Retail Sale Id 1621035',800.80,0.00,0.00,1.04,88.40,'2022-09-27 17:44:15','',''),(2626050,'1','180','934',414,'Retail Sale Id 1621036',2002.00,0.00,0.00,2.60,221.00,'2022-09-27 17:44:57','',''),(2626051,'1','180','934',414,'Retail Sale Id 1621037',4620.00,0.00,0.00,6.00,510.00,'2022-09-28 10:43:44','',''),(2626052,'1','180','934',414,'Retail Sale Id 1621038',4997.30,0.00,0.00,6.49,551.65,'2022-09-28 10:44:51','',''),(2626053,'1','180','934',414,'Retail Sale Id 1621039',1439.90,0.00,0.00,1.87,158.95,'2022-09-28 10:46:07','',''),(2626054,'1','180','934',414,'Retail Sale Id 1621040',3080.00,0.00,0.00,4.00,340.00,'2022-09-28 11:01:34','',''),(2626055,'1','180','934',414,'Retail Sale Id 1621041',2310.00,0.00,0.00,3.00,255.00,'2022-09-28 16:24:57','',''),(2626056,'1','180','934',414,'Retail Sale Id 1621042',4620.00,0.00,0.00,6.00,510.00,'2022-09-28 16:25:40','',''),(2626057,'1','180','934',414,'Retail Sale Id 1621043',1001.00,0.00,0.00,1.30,110.50,'2022-09-28 16:33:32','',''),(2626058,'1','180','934',414,'Retail Sale Id 1621045',2502.50,0.00,0.00,3.25,276.25,'2022-09-28 17:45:45','',''),(2626059,'1','180','934',414,'Retail Sale Id 1621046',4620.00,0.00,0.00,6.00,510.00,'2022-09-28 17:46:33','',''),(2626060,'1','180','934',414,'Retail Sale Id 1621047',2310.00,0.00,0.00,3.00,255.00,'2022-09-28 18:13:38','',''),(2626061,'1','180','934',414,'Retail Sale Id 1621048',3003.00,0.00,0.00,3.90,331.50,'2022-09-29 09:11:37','',''),(2626062,'1','180','934',414,'Retail Sale Id 1621049',1001.00,0.00,0.00,1.30,110.50,'2022-09-29 09:38:37','',''),(2626063,'1','180','934',414,'Retail Sale Id 1621050',1540.00,0.00,0.00,2.00,170.00,'2022-09-29 10:06:38','',''),(2626064,'1','180','934',414,'Retail Sale Id 1621051',500.50,0.00,0.00,0.65,55.25,'2022-09-29 10:07:30','',''),(2626065,'1','180','934',414,'Retail Sale Id 1621052',14999.60,0.00,0.00,19.48,1655.80,'2022-09-29 14:37:34','',''),(2626066,'1','180','934',414,'Retail Sale Id 1621053',7700.00,0.00,0.00,10.00,850.00,'2022-09-29 14:47:58','',''),(2626067,'1','180','934',414,'Retail Sale Id 1621054',2002.00,0.00,0.00,2.60,221.00,'2022-09-29 15:37:11','',''),(2626068,'1','180','934',414,'Retail Sale Id 1621055',3503.50,0.00,0.00,4.55,386.75,'2022-09-29 15:38:03','',''),(2626069,'1','180','934',414,'Retail Sale Id 1621056',2310.00,0.00,0.00,3.00,255.00,'2022-09-29 15:39:00','',''),(2626070,'1','180','934',414,'Retail Sale Id 1621057',2002.00,0.00,0.00,2.60,221.00,'2022-09-29 15:39:43','',''),(2626071,'1','180','934',414,'Retail Sale Id 1621058',43200.00,0.00,0.00,60.00,2100.00,'2022-09-29 15:40:54','',''),(2626072,'1','180','934',414,'Retail Sale Id 1621059',3850.00,0.00,0.00,5.00,425.00,'2022-09-29 15:46:42','',''),(2626073,'1','180','934',414,'Retail Sale Id 1621060',4620.00,0.00,0.00,6.00,510.00,'2022-09-29 15:52:22','',''),(2626074,'1','180','934',414,'Retail Sale Id 1621061',4620.00,0.00,0.00,6.00,510.00,'2022-09-29 15:56:42','',''),(2626075,'1','180','934',414,'Retail Sale Id 1621062',1001.00,0.00,0.00,1.30,110.50,'2022-09-29 16:44:55','',''),(2626076,'1','180','934',414,'Retail Sale Id 1621063',2310.00,0.00,0.00,3.00,255.00,'2022-09-29 16:45:41','',''),(2626077,'1','180','934',414,'Retail Sale Id 1621064',1540.00,0.00,0.00,2.00,170.00,'2022-09-29 16:51:20','',''),(2626078,'1','180','934',414,'Retail Sale Id 1621065',1001.00,0.00,0.00,1.30,110.50,'2022-09-29 16:54:31','',''),(2626079,'1','180','934',414,'Retail Sale Id 1621066',1540.00,0.00,0.00,2.00,170.00,'2022-09-29 17:00:08','',''),(2626080,'1','180','934',414,'Retail Sale Id 1621067',2310.00,0.00,0.00,3.00,255.00,'2022-09-29 17:16:23','',''),(2626081,'1','180','934',414,'Retail Sale Id 1621068',2310.00,0.00,0.00,3.00,255.00,'2022-09-29 17:59:06','',''),(2626082,'1','180','934',414,'Retail Sale Id 1621069',9240.00,0.00,0.00,12.00,1020.00,'2022-09-30 17:15:35','',''),(2626083,'1','180','934',414,'Retail Sale Id 1621070',2310.00,0.00,0.00,3.00,255.00,'2022-09-30 17:21:32','',''),(2626084,'1','180','934',414,'Retail Sale Id 1621071',4897.20,0.00,0.00,6.36,540.60,'2022-09-30 17:23:05','',''),(2626085,'1','180','934',414,'Retail Sale Id 1621072',1501.50,0.00,0.00,1.95,165.75,'2022-09-30 17:23:58','',''),(2626086,'1','180','934',414,'Retail Sale Id 1621073',3311.00,0.00,0.00,4.30,365.50,'2022-09-30 17:40:05','',''),(2626087,'1','180','934',414,'Retail Sale Id 1621075',41760.00,0.00,0.00,58.00,2030.00,'2022-09-30 20:07:11','',''),(2626088,'1','180','934',414,'Retail Sale Id 1621076',4196.50,0.00,0.00,5.45,463.25,'2022-10-01 09:12:12','',''),(2626089,'1','180','934',414,'Retail Sale Id 1621077',2310.00,0.00,0.00,3.00,255.00,'2022-10-01 09:12:51','',''),(2626090,'1','180','934',414,'Retail Sale Id 1621079',9625.00,0.00,0.00,12.50,1062.50,'2022-10-01 09:29:05','',''),(2626091,'1','180','934',414,'Retail Sale Id 1621080',3003.00,0.00,0.00,3.90,331.50,'2022-10-01 10:41:56','',''),(2626092,'1','180','934',414,'Retail Sale Id 1621081',1878.80,0.00,0.00,2.44,207.40,'2022-10-01 11:33:36','',''),(2626093,'1','180','934',414,'Retail Sale Id 1621082',19250.00,0.00,0.00,25.00,2125.00,'2022-10-01 11:34:29','',''),(2626094,'1','180','934',414,'Retail Sale Id 1621083',4620.00,0.00,0.00,6.00,510.00,'2022-10-01 11:46:30','',''),(2626095,'1','180','934',414,'Retail Sale Id 1621084',1540.00,0.00,0.00,2.00,170.00,'2022-10-01 11:47:19','',''),(2626096,'1','180','934',414,'Retail Sale Id 1621085',1901.90,0.00,0.00,2.47,209.95,'2022-10-01 11:48:39','',''),(2626097,'1','180','934',414,'Retail Sale Id 1621086',2310.00,0.00,0.00,3.00,255.00,'2022-10-01 13:21:52','',''),(2626098,'1','180','934',414,'Retail Sale Id 1621087',2502.50,0.00,0.00,3.25,276.25,'2022-10-01 14:05:32','',''),(2626099,'1','180','934',414,'Retail Sale Id 1621088',86400.00,0.00,0.00,120.00,4200.00,'2022-10-01 15:00:34','',''),(2626100,'1','180','934',414,'Retail Sale Id 1621089',41760.00,0.00,0.00,58.00,2030.00,'2022-10-01 15:01:40','',''),(2626101,'1','180','934',414,'Retail Sale Id 1621090',9625.00,0.00,0.00,12.50,1062.50,'2022-10-01 16:12:44','',''),(2626102,'1','180','934',414,'Retail Sale Id 1621091',2310.00,0.00,0.00,3.00,255.00,'2022-10-01 16:13:28','',''),(2626103,'1','180','934',414,'Retail Sale Id 1621092',3080.00,0.00,0.00,4.00,340.00,'2022-10-01 16:26:46','',''),(2626104,'1','180','934',414,'Retail Sale Id 1621093',4620.00,0.00,0.00,6.00,510.00,'2022-10-01 17:16:57','',''),(2626105,'1','180','934',414,'Retail Sale Id 1621094',1155.00,0.00,0.00,1.50,127.50,'2022-10-01 17:21:49','',''),(2626106,'1','180','934',414,'Retail Sale Id 1621095',1540.00,0.00,0.00,2.00,170.00,'2022-10-01 17:23:02','',''),(2626107,'1','180','934',414,'Retail Sale Id 1621096',9625.00,0.00,0.00,12.50,1062.50,'2022-10-02 11:18:13','',''),(2626108,'1','180','934',414,'Retail Sale Id 1621097',3850.00,0.00,0.00,5.00,425.00,'2022-10-02 11:19:13','',''),(2626109,'1','180','934',414,'Retail Sale Id 1621098',4620.00,0.00,0.00,6.00,510.00,'2022-10-02 11:19:45','',''),(2626110,'1','180','934',414,'Retail Sale Id 1621099',2310.00,0.00,0.00,3.00,255.00,'2022-10-02 11:20:24','',''),(2626111,'1','180','934',414,'Retail Sale Id 1621100',3503.50,0.00,0.00,4.55,386.75,'2022-10-02 11:21:43','',''),(2626112,'1','180','934',414,'Retail Sale Id 1621101',2310.00,0.00,0.00,3.00,255.00,'2022-10-02 11:36:04','',''),(2626113,'1','180','934',414,'Retail Sale Id 1621102',1001.00,0.00,0.00,1.30,110.50,'2022-10-02 12:27:51','',''),(2626114,'1','180','934',414,'Retail Sale Id 1621103',1201.20,0.00,0.00,1.56,132.60,'2022-10-02 12:28:59','',''),(2626115,'1','180','934',414,'Retail Sale Id 1621104',2310.00,0.00,0.00,3.00,255.00,'2022-10-02 13:17:01','',''),(2626116,'1','180','934',414,'Retail Sale Id 1621105',1001.00,0.00,0.00,1.30,110.50,'2022-10-02 13:17:55','',''),(2626117,'1','180','934',414,'Retail Sale Id 1621106',3996.30,0.00,0.00,5.19,441.15,'2022-10-02 13:42:47','',''),(2626118,'1','180','934',414,'Retail Sale Id 1621107',5998.30,0.00,0.00,7.79,662.15,'2022-10-02 14:05:19','',''),(2626119,'1','180','934',414,'Retail Sale Id 1621108',9625.00,0.00,0.00,12.50,1062.50,'2022-10-02 14:17:30','',''),(2626120,'1','180','934',414,'Retail Sale Id 1621109',41760.00,0.00,0.00,58.00,2030.00,'2022-10-02 14:38:04','',''),(2626121,'1','180','934',414,'Retail Sale Id 1621110',1540.00,0.00,0.00,2.00,170.00,'2022-10-02 15:10:31','',''),(2626122,'1','180','934',414,'Retail Sale Id 1621111',2310.00,0.00,0.00,3.00,255.00,'2022-10-02 15:20:21','',''),(2626123,'1','180','934',414,'Retail Sale Id 1621112',7700.00,0.00,0.00,10.00,850.00,'2022-10-02 15:39:20','',''),(2626124,'1','180','934',414,'Retail Sale Id 1621113',1501.50,0.00,0.00,1.95,165.75,'2022-10-02 16:13:04','',''),(2626125,'1','180','934',414,'Retail Sale Id 1621114',3003.00,0.00,0.00,3.90,331.50,'2022-10-02 16:30:59','',''),(2626126,'1','180','934',414,'Retail Sale Id 1621115',2002.00,0.00,0.00,2.60,221.00,'2022-10-02 16:42:13','',''),(2626127,'1','180','934',414,'Retail Sale Id 1621116',2002.00,0.00,0.00,2.60,221.00,'2022-10-02 17:59:57','',''),(2626128,'1','180','934',414,'Retail Sale Id 1621117',4620.00,0.00,0.00,6.00,510.00,'2022-10-03 09:33:32','',''),(2626129,'1','180','934',414,'Retail Sale Id 1621118',8500.80,0.00,0.00,11.04,938.40,'2022-10-03 10:10:14','',''),(2626130,'1','180','934',414,'Retail Sale Id 1621119',1116.50,0.00,0.00,1.45,123.25,'2022-10-03 10:51:16','',''),(2626131,'1','180','934',414,'Retail Sale Id 1621120',500.50,0.00,0.00,0.65,55.25,'2022-10-03 11:32:27','',''),(2626132,'1','180','934',414,'Retail Sale Id 1621121',79200.00,0.00,0.00,110.00,3850.00,'2022-10-03 13:22:37','',''),(2626133,'1','180','934',414,'Retail Sale Id 1621122',2310.00,0.00,0.00,3.00,255.00,'2022-10-03 13:25:01','',''),(2626134,'1','180','934',414,'Retail Sale Id 1621123',9625.00,0.00,0.00,12.50,1062.50,'2022-10-03 15:22:14','',''),(2626135,'1','180','934',414,'Retail Sale Id 1621124',1001.00,0.00,0.00,1.30,110.50,'2022-10-03 16:10:58','',''),(2626136,'1','180','934',414,'Retail Sale Id 1621125',19250.00,0.00,0.00,25.00,2125.00,'2022-10-03 16:18:25','',''),(2626137,'1','180','934',414,'Retail Sale Id 1621126',36000.00,0.00,0.00,50.00,1750.00,'2022-10-03 16:20:15','',''),(2626138,'1','180','934',414,'Retail Sale Id 1621127',1001.00,0.00,0.00,1.30,110.50,'2022-10-03 16:39:22','',''),(2626139,'1','180','934',414,'Retail Sale Id 1621128',1540.00,0.00,0.00,2.00,170.00,'2022-10-03 16:53:41','',''),(2626140,'1','180','934',414,'Retail Sale Id 1621129',4620.00,0.00,0.00,6.00,510.00,'2022-10-03 17:00:21','',''),(2626141,'1','180','934',414,'Retail Sale Id 1621130',1001.00,0.00,0.00,1.30,110.50,'2022-10-03 17:03:24','',''),(2626142,'1','180','934',414,'Retail Sale Id 1621131',6930.00,0.00,0.00,9.00,765.00,'2022-10-03 17:20:18','',''),(2626143,'1','180','934',414,'Retail Sale Id 1621132',1001.00,0.00,0.00,1.30,110.50,'2022-10-03 17:25:35','',''),(2626144,'1','180','934',414,'Retail Sale Id 1621133',4620.00,0.00,0.00,6.00,510.00,'2022-10-03 17:37:35','',''),(2626145,'1','180','934',414,'Retail Sale Id 1621134',4620.00,0.00,0.00,6.00,510.00,'2022-10-03 17:58:37','',''),(2626146,'1','180','934',414,'Retail Sale Id 1621135',4620.00,0.00,0.00,6.00,510.00,'2022-10-03 18:10:15','',''),(2626147,'1','180','934',414,'Retail Sale Id 1621136',9625.00,0.00,0.00,12.50,1062.50,'2022-10-04 09:21:54','',''),(2626148,'1','180','934',414,'Retail Sale Id 1621137',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 09:22:48','',''),(2626149,'1','180','934',414,'Retail Sale Id 1621138',2618.00,0.00,0.00,3.40,289.00,'2022-10-04 09:24:43','',''),(2626150,'1','180','934',414,'Retail Sale Id 1621139',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 09:51:27','',''),(2626151,'1','180','934',414,'Retail Sale Id 1621140',3003.00,0.00,0.00,3.90,331.50,'2022-10-04 10:06:37','',''),(2626152,'1','180','934',414,'Retail Sale Id 1621141',2310.00,0.00,0.00,3.00,255.00,'2022-10-04 10:13:10','',''),(2626153,'1','180','934',414,'Retail Sale Id 1621142',3003.00,0.00,0.00,3.90,331.50,'2022-10-04 10:55:23','',''),(2626154,'1','180','934',414,'Retail Sale Id 1621143',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 10:58:38','',''),(2626155,'1','180','934',414,'Retail Sale Id 1621144',900.90,0.00,0.00,1.17,99.45,'2022-10-04 11:11:58','',''),(2626156,'1','180','934',414,'Retail Sale Id 1621145',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 13:38:52','',''),(2626157,'1','180','934',414,'Retail Sale Id 1621146',2310.00,0.00,0.00,3.00,255.00,'2022-10-04 13:45:06','',''),(2626158,'1','180','934',414,'Retail Sale Id 1621147',11935.00,0.00,0.00,15.50,1317.50,'2022-10-04 14:45:10','',''),(2626159,'1','180','934',414,'Retail Sale Id 1621148',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 14:45:50','',''),(2626160,'1','180','934',414,'Retail Sale Id 1621149',3996.30,0.00,0.00,5.19,441.15,'2022-10-04 14:46:36','',''),(2626161,'1','180','934',414,'Retail Sale Id 1621150',2310.00,0.00,0.00,3.00,255.00,'2022-10-04 14:47:11','',''),(2626162,'1','180','934',414,'Retail Sale Id 1621151',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 14:58:32','',''),(2626163,'1','180','934',414,'Retail Sale Id 1621152',4620.00,0.00,0.00,6.00,510.00,'2022-10-04 15:09:30','',''),(2626164,'1','180','934',414,'Retail Sale Id 1621153',3996.30,0.00,0.00,5.19,441.15,'2022-10-04 15:28:14','',''),(2626165,'1','180','934',414,'Retail Sale Id 1621154',1001.00,0.00,0.00,1.30,110.50,'2022-10-04 16:33:11','',''),(2626166,'1','180','934',414,'Retail Sale Id 1621155',4997.30,0.00,0.00,6.49,551.65,'2022-10-04 19:02:09','',''),(2626167,'1','180','934',414,'Retail Sale Id 1621156',2502.50,0.00,0.00,3.25,276.25,'2022-10-05 08:29:13','',''),(2626168,'1','180','934',414,'Retail Sale Id 1621157',2002.00,0.00,0.00,2.60,221.00,'2022-10-05 08:51:20','',''),(2626169,'1','180','934',414,'Retail Sale Id 1621158',4496.80,0.00,0.00,5.84,496.40,'2022-10-05 09:44:00','',''),(2626170,'1','180','934',414,'Retail Sale Id 1621159',6160.00,0.00,0.00,8.00,680.00,'2022-10-05 10:12:28','',''),(2626171,'1','180','934',414,'Retail Sale Id 1621160',3996.30,0.00,0.00,5.19,441.15,'2022-10-05 12:25:42','',''),(2626172,'1','180','934',414,'Retail Sale Id 1621161',2310.00,0.00,0.00,3.00,255.00,'2022-10-05 13:50:03','',''),(2626173,'1','180','934',414,'Retail Sale Id 1621162',3080.00,0.00,0.00,4.00,340.00,'2022-10-05 14:41:48','',''),(2626174,'1','180','934',414,'Retail Sale Id 1621163',6160.00,0.00,0.00,8.00,680.00,'2022-10-05 15:07:51','',''),(2626175,'1','180','934',414,'Retail Sale Id 1621164',9625.00,0.00,0.00,12.50,1062.50,'2022-10-05 15:16:59','',''),(2626176,'1','180','934',414,'Retail Sale Id 1621165',2002.00,0.00,0.00,2.60,221.00,'2022-10-05 16:19:56','',''),(2626177,'1','180','934',414,'Retail Sale Id 1621166',3850.00,0.00,0.00,5.00,425.00,'2022-10-05 17:40:56','',''),(2626178,'1','180','934',414,'Retail Sale Id 1621167',2502.50,0.00,0.00,3.25,276.25,'2022-10-05 17:41:31','',''),(2626179,'1','180','934',414,'Retail Sale Id 1621168',4596.90,0.00,0.00,5.97,507.45,'2022-10-06 09:11:47','',''),(2626180,'1','180','934',414,'Retail Sale Id 1621169',4620.00,0.00,0.00,6.00,510.00,'2022-10-06 09:39:00','',''),(2626181,'1','180','934',414,'Retail Sale Id 1621170',5313.00,0.00,0.00,6.90,586.50,'2022-10-06 11:15:41','',''),(2626182,'1','180','934',414,'Retail Sale Id 1621171',3850.00,0.00,0.00,5.00,425.00,'2022-10-06 11:54:38','',''),(2626183,'1','180','934',414,'Retail Sale Id 1621172',3003.00,0.00,0.00,3.90,331.50,'2022-10-06 13:35:52','',''),(2626184,'1','180','934',414,'Retail Sale Id 1621173',1001.00,0.00,0.00,1.30,110.50,'2022-10-06 14:28:18','',''),(2626185,'1','180','934',414,'Retail Sale Id 1621174',4620.00,0.00,0.00,6.00,510.00,'2022-10-06 17:09:52','',''),(2626186,'1','180','934',414,'Retail Sale Id 1621175',2002.00,0.00,0.00,2.60,221.00,'2022-10-06 18:06:57','',''),(2626187,'1','180','934',414,'Retail Sale Id 1621176',8000.30,0.00,0.00,10.39,883.15,'2022-10-06 18:22:46','',''),(2626188,'1','180','934',414,'Retail Sale Id 1621177',83520.00,0.00,0.00,116.00,4060.00,'2022-10-06 19:28:03','',''),(2626189,'1','180','934',414,'Retail Sale Id 1621178',36000.00,0.00,0.00,50.00,1750.00,'2022-10-06 19:28:42','',''),(2626190,'1','180','934',414,'Retail Sale Id 1621179',5998.30,0.00,0.00,7.79,662.15,'2022-10-07 09:10:27','',''),(2626191,'1','180','934',414,'Retail Sale Id 1621180',4997.30,0.00,0.00,6.49,551.65,'2022-10-07 11:29:45','',''),(2626192,'1','180','934',414,'Retail Sale Id 1621181',3003.00,0.00,0.00,3.90,331.50,'2022-10-07 13:00:10','',''),(2626193,'1','180','934',414,'Retail Sale Id 1621182',3003.00,0.00,0.00,3.90,331.50,'2022-10-07 13:00:49','',''),(2626194,'1','180','934',414,'Retail Sale Id 1621183',1501.50,0.00,0.00,1.95,165.75,'2022-10-07 13:01:32','',''),(2626195,'1','180','934',414,'Retail Sale Id 1621184',2310.00,0.00,0.00,3.00,255.00,'2022-10-07 14:40:21','',''),(2626196,'1','180','934',414,'Retail Sale Id 1621185',3003.00,0.00,0.00,3.90,331.50,'2022-10-07 14:40:55','',''),(2626197,'1','180','934',414,'Retail Sale Id 1621186',9625.00,0.00,0.00,12.50,1062.50,'2022-10-07 17:26:57','',''),(2626198,'1','180','934',414,'Retail Sale Id 1621187',4997.30,0.00,0.00,6.49,551.65,'2022-10-07 17:27:49','',''),(2626199,'1','180','934',414,'Retail Sale Id 1621188',4620.00,0.00,0.00,6.00,510.00,'2022-10-07 17:30:36','',''),(2626200,'1','180','934',414,'Retail Sale Id 1621189',2541.00,0.00,0.00,3.30,280.50,'2022-10-07 17:31:40','',''),(2626201,'1','180','934',414,'Retail Sale Id 1621190',2310.00,0.00,0.00,3.00,255.00,'2022-10-07 17:50:49','',''),(2626202,'1','180','934',414,'Retail Sale Id 1621191',2310.00,0.00,0.00,3.00,255.00,'2022-10-07 18:14:34','',''),(2626203,'1','180','934',414,'Retail Sale Id 1621192',43200.00,0.00,0.00,60.00,2100.00,'2022-10-07 23:03:55','',''),(2626204,'1','180','934',414,'Retail Sale Id 1621193',4620.00,0.00,0.00,6.00,510.00,'2022-10-08 09:56:27','',''),(2626205,'1','180','934',414,'Retail Sale Id 1621194',8000.30,0.00,0.00,10.39,883.15,'2022-10-08 09:57:33','',''),(2626206,'1','180','934',414,'Retail Sale Id 1621195',7700.00,0.00,0.00,10.00,850.00,'2022-10-08 09:58:31','',''),(2626207,'1','180','934',414,'Retail Sale Id 1621196',2310.00,0.00,0.00,3.00,255.00,'2022-10-08 09:59:46','',''),(2626208,'1','180','934',414,'Retail Sale Id 1621197',9625.00,0.00,0.00,12.50,1062.50,'2022-10-08 10:09:36','',''),(2626209,'1','180','934',414,'Retail Sale Id 1621198',3850.00,0.00,0.00,5.00,425.00,'2022-10-08 11:05:30','',''),(2626210,'1','180','934',414,'Retail Sale Id 1621199',5497.80,0.00,0.00,7.14,606.90,'2022-10-08 11:06:31','',''),(2626211,'1','180','934',414,'Retail Sale Id 1621200',4620.00,0.00,0.00,6.00,510.00,'2022-10-08 11:12:52','',''),(2626212,'1','180','934',414,'Retail Sale Id 1621202',4797.10,0.00,0.00,6.23,529.55,'2022-10-08 12:27:58','',''),(2626213,'1','180','934',414,'Retail Sale Id 1621203',2002.00,0.00,0.00,2.60,221.00,'2022-10-08 12:37:09','',''),(2626214,'1','180','934',414,'Retail Sale Id 1621204',2002.00,0.00,0.00,2.60,221.00,'2022-10-08 14:13:40','',''),(2626215,'1','180','934',414,'Retail Sale Id 1621205',2002.00,0.00,0.00,2.60,221.00,'2022-10-08 14:50:41','',''),(2626216,'1','180','934',414,'Retail Sale Id 1621206',2002.00,0.00,0.00,2.60,221.00,'2022-10-08 15:15:58','',''),(2626217,'1','180','934',414,'Retail Sale Id 1621207',4997.30,0.00,0.00,6.49,551.65,'2022-10-08 17:04:12','',''),(2626218,'1','180','934',414,'Retail Sale Id 1621208',2310.00,0.00,0.00,3.00,255.00,'2022-10-08 17:05:10','',''),(2626219,'1','180','934',414,'Retail Sale Id 1621209',3996.30,0.00,0.00,5.19,441.15,'2022-10-08 18:01:24','',''),(2626220,'1','180','934',414,'Retail Sale Id 1621210',3850.00,0.00,0.00,5.00,425.00,'2022-10-09 10:29:46','',''),(2626221,'1','180','934',414,'Retail Sale Id 1621211',2310.00,0.00,0.00,3.00,255.00,'2022-10-09 10:30:22','',''),(2626222,'1','180','934',414,'Retail Sale Id 1621212',8577.80,0.00,0.00,11.14,946.90,'2022-10-09 10:32:39','',''),(2626223,'1','180','934',414,'Retail Sale Id 1621213',2502.50,0.00,0.00,3.25,276.25,'2022-10-09 11:32:52','',''),(2626224,'1','180','934',414,'Retail Sale Id 1621214',9240.00,0.00,0.00,12.00,1020.00,'2022-10-09 11:34:03','',''),(2626225,'1','180','934',414,'Retail Sale Id 1621215',9625.00,0.00,0.00,12.50,1062.50,'2022-10-09 11:34:51','',''),(2626226,'1','180','934',414,'Retail Sale Id 1621216',8000.30,0.00,0.00,10.39,883.15,'2022-10-09 11:35:42','',''),(2626227,'1','180','934',414,'Retail Sale Id 1621217',3850.00,0.00,0.00,5.00,425.00,'2022-10-09 11:36:27','',''),(2626228,'1','180','934',414,'Retail Sale Id 1621218',1001.00,0.00,0.00,1.30,110.50,'2022-10-09 11:44:34','',''),(2626229,'1','180','934',414,'Retail Sale Id 1621219',6160.00,0.00,0.00,8.00,680.00,'2022-10-09 12:24:12','',''),(2626230,'1','180','934',414,'Retail Sale Id 1621220',9625.00,0.00,0.00,12.50,1062.50,'2022-10-09 13:34:14','',''),(2626231,'1','180','934',414,'Retail Sale Id 1621222',4620.00,0.00,0.00,6.00,510.00,'2022-10-09 13:55:42','',''),(2626232,'1','180','934',414,'Retail Sale Id 1621223',5998.30,0.00,0.00,7.79,662.15,'2022-10-09 15:04:33','',''),(2626233,'1','180','934',414,'Retail Sale Id 1621224',1201.20,0.00,0.00,1.56,132.60,'2022-10-09 15:52:03','',''),(2626234,'1','180','934',414,'Retail Sale Id 1621225',2310.00,0.00,0.00,3.00,255.00,'2022-10-09 16:15:15','',''),(2626235,'1','180','934',414,'Retail Sale Id 1621226',2310.00,0.00,0.00,3.00,255.00,'2022-10-09 16:19:17','',''),(2626236,'1','180','934',414,'Retail Sale Id 1621227',3003.00,0.00,0.00,3.90,331.50,'2022-10-09 16:25:53','',''),(2626237,'1','180','934',414,'Retail Sale Id 1621228',3003.00,0.00,0.00,3.90,331.50,'2022-10-09 16:27:34','',''),(2626238,'1','180','934',414,'Retail Sale Id 1621229',1540.00,0.00,0.00,2.00,170.00,'2022-10-09 17:00:45','',''),(2626239,'1','180','934',414,'Retail Sale Id 1621230',2310.00,0.00,0.00,3.00,255.00,'2022-10-09 17:02:00','',''),(2626240,'1','180','934',414,'Retail Sale Id 1621231',2310.00,0.00,0.00,3.00,255.00,'2022-10-09 17:08:58','',''),(2626241,'1','180','934',414,'Retail Sale Id 1621232',2310.00,0.00,0.00,3.00,255.00,'2022-10-09 17:11:45','',''),(2626242,'1','180','934',414,'Retail Sale Id 1621233',3080.00,0.00,0.00,4.00,340.00,'2022-10-09 17:14:17','',''),(2626243,'1','180','934',414,'Retail Sale Id 1621234',1201.20,0.00,0.00,1.56,132.60,'2022-10-09 17:28:04','',''),(2626244,'1','180','934',414,'Retail Sale Id 1621235',3080.00,0.00,0.00,4.00,340.00,'2022-10-09 17:51:46','',''),(2626245,'1','180','934',414,'Retail Sale Id 1621236',6930.00,0.00,0.00,9.00,765.00,'2022-10-10 09:05:19','',''),(2626246,'1','180','934',414,'Retail Sale Id 1621237',6930.00,0.00,0.00,9.00,765.00,'2022-10-10 09:33:04','',''),(2626247,'1','180','934',414,'Retail Sale Id 1621238',3003.00,0.00,0.00,3.90,331.50,'2022-10-10 10:31:36','',''),(2626248,'1','180','934',414,'Retail Sale Id 1621239',3003.00,0.00,0.00,3.90,331.50,'2022-10-10 10:57:28','',''),(2626249,'1','180','934',414,'Retail Sale Id 1621240',3850.00,0.00,0.00,5.00,425.00,'2022-10-10 11:44:36','',''),(2626250,'1','180','934',414,'Retail Sale Id 1621241',4620.00,0.00,0.00,6.00,510.00,'2022-10-10 13:34:06','',''),(2626251,'1','180','934',414,'Retail Sale Id 1621242',3003.00,0.00,0.00,3.90,331.50,'2022-10-10 14:26:04','',''),(2626252,'1','180','934',414,'Retail Sale Id 1621243',9625.00,0.00,0.00,12.50,1062.50,'2022-10-10 14:26:58','',''),(2626253,'1','180','934',414,'Retail Sale Id 1621244',3003.00,0.00,0.00,3.90,331.50,'2022-10-10 15:22:57','',''),(2626254,'1','180','934',414,'Retail Sale Id 1621245',2310.00,0.00,0.00,3.00,255.00,'2022-10-10 15:36:16','',''),(2626255,'1','180','934',414,'Retail Sale Id 1621246',1540.00,0.00,0.00,2.00,170.00,'2022-10-10 16:25:02','',''),(2626256,'1','180','934',414,'Retail Sale Id 1621247',3080.00,0.00,0.00,4.00,340.00,'2022-10-10 16:42:53','',''),(2626257,'1','180','934',414,'Retail Sale Id 1621248',1540.00,0.00,0.00,2.00,170.00,'2022-10-10 17:14:44','',''),(2626258,'1','180','934',414,'Retail Sale Id 1621249',2310.00,0.00,0.00,3.00,255.00,'2022-10-10 17:22:03','',''),(2626259,'1','180','934',414,'Retail Sale Id 1621250',1001.00,0.00,0.00,1.30,110.50,'2022-10-10 17:31:09','',''),(2626260,'1','180','934',414,'Retail Sale Id 1621251',2310.00,0.00,0.00,3.00,255.00,'2022-10-10 17:38:31','',''),(2626261,'1','180','934',414,'Retail Sale Id 1621252',7700.00,0.00,0.00,10.00,850.00,'2022-10-10 17:42:06','',''),(2626262,'1','180','934',414,'Retail Sale Id 1621253',1501.50,0.00,0.00,1.95,165.75,'2022-10-10 17:53:36','',''),(2626263,'1','180','934',414,'Retail Sale Id 1621255',2202.20,0.00,0.00,2.86,243.10,'2022-10-11 08:53:49','',''),(2626264,'1','180','934',414,'Retail Sale Id 1621256',11550.00,0.00,0.00,15.00,1275.00,'2022-10-11 09:39:23','',''),(2626265,'1','180','934',414,'Retail Sale Id 1621258',4496.80,0.00,0.00,5.84,496.40,'2022-10-11 09:49:52','',''),(2626266,'1','180','934',414,'Retail Sale Id 1621259',9240.00,0.00,0.00,12.00,1020.00,'2022-10-11 10:06:17','',''),(2626267,'1','180','934',414,'Retail Sale Id 1621260',4296.60,0.00,0.00,5.58,474.30,'2022-10-11 10:15:21','',''),(2626268,'1','180','934',414,'Retail Sale Id 1621261',4620.00,0.00,0.00,6.00,510.00,'2022-10-11 11:34:35','',''),(2626269,'1','180','934',414,'Retail Sale Id 1621262',2310.00,0.00,0.00,3.00,255.00,'2022-10-11 12:29:11','',''),(2626270,'1','180','934',414,'Retail Sale Id 1621263',3850.00,0.00,0.00,5.00,425.00,'2022-10-11 12:59:58','',''),(2626271,'1','180','934',414,'Retail Sale Id 1621264',4620.00,0.00,0.00,6.00,510.00,'2022-10-11 13:48:00','',''),(2626272,'1','180','934',414,'Retail Sale Id 1621265',4620.00,0.00,0.00,6.00,510.00,'2022-10-11 15:12:07','',''),(2626273,'1','180','934',414,'Retail Sale Id 1621266',2002.00,0.00,0.00,2.60,221.00,'2022-10-11 15:31:16','',''),(2626274,'1','180','934',414,'Retail Sale Id 1621267',1001.00,0.00,0.00,1.30,110.50,'2022-10-11 15:49:46','',''),(2626275,'1','180','934',414,'Retail Sale Id 1621268',2310.00,0.00,0.00,3.00,255.00,'2022-10-11 16:29:51','',''),(2626276,'1','180','934',414,'Retail Sale Id 1621269',1501.50,0.00,0.00,1.95,165.75,'2022-10-11 17:05:56','',''),(2626277,'1','180','934',414,'Retail Sale Id 1621270',2002.00,0.00,0.00,2.60,221.00,'2022-10-11 17:07:10','',''),(2626278,'1','180','934',414,'Retail Sale Id 1621271',3003.00,0.00,0.00,3.90,331.50,'2022-10-11 17:11:32','',''),(2626279,'1','180','934',414,'Retail Sale Id 1621272',3080.00,0.00,0.00,4.00,340.00,'2022-10-12 08:11:38','',''),(2626280,'1','180','934',414,'Retail Sale Id 1621273',4620.00,0.00,0.00,6.00,510.00,'2022-10-12 09:06:07','',''),(2626281,'1','180','934',414,'Retail Sale Id 1621274',2502.50,0.00,0.00,3.25,276.25,'2022-10-12 09:27:30','',''),(2626282,'1','180','934',414,'Retail Sale Id 1621275',4620.00,0.00,0.00,6.00,510.00,'2022-10-12 09:55:08','',''),(2626283,'1','180','934',414,'Retail Sale Id 1621276',2310.00,0.00,0.00,3.00,255.00,'2022-10-12 12:01:32','',''),(2626284,'1','180','934',414,'Retail Sale Id 1621277',1701.70,0.00,0.00,2.21,187.85,'2022-10-12 13:26:04','',''),(2626285,'1','180','934',414,'Retail Sale Id 1621278',9625.00,0.00,0.00,12.50,1062.50,'2022-10-12 14:53:22','',''),(2626286,'1','180','934',414,'Retail Sale Id 1621279',9625.00,0.00,0.00,12.50,1062.50,'2022-10-12 15:13:07','',''),(2626287,'1','180','934',414,'Retail Sale Id 1621280',900.90,0.00,0.00,1.17,99.45,'2022-10-12 15:18:21','',''),(2626288,'1','180','934',414,'Retail Sale Id 1621281',2502.50,0.00,0.00,3.25,276.25,'2022-10-12 15:45:26','',''),(2626289,'1','180','934',414,'Retail Sale Id 1621282',1001.00,0.00,0.00,1.30,110.50,'2022-10-12 15:50:59','',''),(2626290,'1','180','934',414,'Retail Sale Id 1621283',9001.30,0.00,0.00,11.69,993.65,'2022-10-12 17:06:06','',''),(2626291,'1','180','934',414,'Retail Sale Id 1621285',3003.00,0.00,0.00,3.90,331.50,'2022-10-12 17:07:42','',''),(2626292,'1','180','934',414,'Retail Sale Id 1621286',9625.00,0.00,0.00,12.50,1062.50,'2022-10-12 18:18:12','',''),(2626293,'1','180','934',414,'Retail Sale Id 1621287',83520.00,0.00,0.00,116.00,4060.00,'2022-10-12 18:30:34','',''),(2626294,'1','180','934',414,'Retail Sale Id 1621288',6930.00,0.00,0.00,9.00,765.00,'2022-10-13 11:35:18','',''),(2626295,'1','180','934',414,'Retail Sale Id 1621289',3003.00,0.00,0.00,3.90,331.50,'2022-10-13 11:36:17','',''),(2626296,'1','180','934',414,'Retail Sale Id 1621290',1540.00,0.00,0.00,2.00,170.00,'2022-10-13 11:36:52','',''),(2626297,'1','180','934',414,'Retail Sale Id 1621291',900.90,0.00,0.00,1.17,99.45,'2022-10-13 11:37:31','',''),(2626298,'1','180','934',414,'Retail Sale Id 1621292',3850.00,0.00,0.00,5.00,425.00,'2022-10-13 16:11:45','',''),(2626299,'1','180','934',414,'Retail Sale Id 1621293',9625.00,0.00,0.00,12.50,1062.50,'2022-10-13 18:47:14','',''),(2626300,'1','180','934',414,'Retail Sale Id 1621294',1701.70,0.00,0.00,2.21,187.85,'2022-10-13 18:48:12','',''),(2626301,'1','180','934',414,'Retail Sale Id 1621295',3996.30,0.00,0.00,5.19,441.15,'2022-10-14 10:04:02','',''),(2626302,'1','180','934',414,'Retail Sale Id 1621296',3003.00,0.00,0.00,3.90,331.50,'2022-10-14 10:04:59','',''),(2626303,'1','180','934',414,'Retail Sale Id 1621297',1801.80,0.00,0.00,2.34,198.90,'2022-10-14 10:05:58','',''),(2626304,'1','180','934',414,'Retail Sale Id 1621298',900.90,0.00,0.00,1.17,99.45,'2022-10-14 10:47:15','',''),(2626305,'1','180','934',414,'Retail Sale Id 1621299',3311.00,0.00,0.00,4.30,365.50,'2022-10-14 11:09:43','',''),(2626306,'1','180','934',414,'Retail Sale Id 1621300',2310.00,0.00,0.00,3.00,255.00,'2022-10-14 11:37:31','',''),(2626307,'1','180','934',414,'Retail Sale Id 1621301',9625.00,0.00,0.00,12.50,1062.50,'2022-10-14 11:51:16','',''),(2626308,'1','180','934',414,'Retail Sale Id 1621302',3003.00,0.00,0.00,3.90,331.50,'2022-10-14 11:53:29','',''),(2626309,'1','180','934',414,'Retail Sale Id 1621303',43200.00,0.00,0.00,60.00,2100.00,'2022-10-14 11:56:08','',''),(2626310,'1','180','934',414,'Retail Sale Id 1621304',4620.00,0.00,0.00,6.00,510.00,'2022-10-14 15:15:53','',''),(2626311,'1','180','934',414,'Retail Sale Id 1621305',4620.00,0.00,0.00,6.00,510.00,'2022-10-14 15:38:36','',''),(2626312,'1','180','934',414,'Retail Sale Id 1621306',36000.00,0.00,0.00,50.00,1750.00,'2022-10-14 16:41:36','',''),(2626313,'1','180','934',414,'Retail Sale Id 1621307',2310.00,0.00,0.00,3.00,255.00,'2022-10-14 17:29:14','',''),(2626314,'1','180','934',414,'Retail Sale Id 1621308',1201.20,0.00,0.00,1.56,132.60,'2022-10-14 17:31:48','',''),(2626315,'1','180','934',414,'Retail Sale Id 1621309',13860.00,0.00,0.00,18.00,1530.00,'2022-10-15 11:27:04','',''),(2626316,'1','180','934',414,'Retail Sale Id 1621310',216000.00,0.00,0.00,300.00,10500.00,'2022-10-15 17:52:38','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'1','180',414,449.08,'2023-02-01 13:10:49');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1817253 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (757341,'1','180',414,'Retail Sale Id 305942',0.00,4300.00,344.00,4300.00,0.00,'2021-05-09 11:33:56'),(758945,'1','180',414,'Retail Sale Id 307497',0.00,2064.00,344.00,2064.00,0.00,'2021-05-09 15:56:45'),(762429,'1','180',414,'Retail Sale Id 310874',0.00,1032.00,344.00,1032.00,0.00,'2021-05-10 16:56:20'),(762511,'1','180',414,'Retail Sale Id 310941',0.00,68800.00,322.00,64400.00,-4400.00,'2021-05-10 17:24:33'),(763233,'1','180',414,'Retail Sale Id 311623',0.00,4300.00,344.00,4300.00,0.00,'2021-05-11 08:22:40'),(763274,'1','180',414,'Retail Sale Id 311662',0.00,1032.00,344.00,1032.00,0.00,'2021-05-11 08:31:28'),(764211,'1','180',414,'Retail Sale Id 312626',0.00,137600.00,344.00,137600.00,0.00,'2021-05-11 11:43:38'),(764291,'1','180',414,'Retail Sale Id 312727',0.00,2064.00,344.00,2064.00,0.00,'2021-05-11 12:10:56'),(764344,'1','180',414,'Return of Retail Sale Id 312626',137600.00,0.00,344.00,-137600.00,0.00,'2021-05-11 12:26:39'),(764354,'1','180',414,'Retail Sale Id 312784',0.00,137600.00,322.00,128800.00,-8800.00,'2021-05-11 12:29:09'),(765583,'1','180',414,'Retail Sale Id 314052',0.00,1995.20,344.00,1995.20,0.00,'2021-05-11 16:15:04'),(765753,'1','180',414,'Retail Sale Id 314205',0.00,2752.00,344.00,2752.00,0.00,'2021-05-11 16:38:45'),(766918,'1','180',414,'Retail Sale Id 315409',0.00,1720.00,344.00,1720.00,0.00,'2021-05-12 09:00:31'),(767076,'1','180',414,'Retail Sale Id 315544',0.00,1032.00,344.00,1032.00,0.00,'2021-05-12 09:30:57'),(767160,'1','180',414,'Retail Sale Id 315618',0.00,2064.00,344.00,2064.00,0.00,'2021-05-12 09:42:56'),(767229,'1','180',414,'Retail Sale Id 315680',0.00,2064.00,344.00,2064.00,0.00,'2021-05-12 09:53:16'),(767956,'1','180',414,'Retail Sale Id 316385',0.00,498.80,344.00,498.80,0.00,'2021-05-12 12:05:03'),(769391,'1','180',414,'Retail Sale Id 317728',0.00,1032.00,344.00,1032.00,0.00,'2021-05-12 17:11:17'),(771006,'1','180',414,'Retail Sale Id 319277',0.00,2064.00,344.00,2064.00,0.00,'2021-05-13 17:29:20'),(772298,'1','180',414,'Retail Sale Id 320528',0.00,1720.00,344.00,1720.00,0.00,'2021-05-14 11:33:04'),(774041,'1','180',414,'Retail Sale Id 322210',0.00,5332.00,344.00,5332.00,0.00,'2021-05-16 10:41:39'),(774044,'1','180',414,'Retail Sale Id 322216',0.00,172000.00,322.00,161000.00,-11000.00,'2021-05-16 10:43:00'),(774053,'1','180',414,'Retail Sale Id 322220',0.00,2064.00,344.00,2064.00,0.00,'2021-05-16 10:53:18'),(775056,'1','180',414,'Retail Sale Id 323024',0.00,86000.00,322.00,80500.00,-5500.00,'2021-05-16 19:09:23'),(775525,'1','180',414,'Retail Sale Id 323370',0.00,4062.64,344.00,4062.64,0.00,'2021-05-17 09:31:28'),(776022,'1','180',414,'Retail Sale Id 323703',0.00,1200.56,344.00,1200.56,0.00,'2021-05-17 12:15:24'),(776029,'1','180',414,'Retail Sale Id 323706',0.00,120400.00,322.00,112700.00,-7700.00,'2021-05-17 12:20:39'),(776035,'1','180',414,'Retail Sale Id 323712',0.00,50568.00,322.00,47334.00,-3234.00,'2021-05-17 12:22:42'),(777111,'1','180',414,'Retail Sale Id 324651',0.00,1720.00,344.00,1720.00,0.00,'2021-05-17 16:50:02'),(777123,'1','180',414,'Retail Sale Id 324663',0.00,1032.00,344.00,1032.00,0.00,'2021-05-17 16:52:56'),(777129,'1','180',414,'Retail Sale Id 324667',0.00,1032.00,344.00,1032.00,0.00,'2021-05-17 16:54:06'),(777583,'1','180',414,'Retail Sale Id 324992',0.00,1032.00,344.00,1032.00,0.00,'2021-05-18 07:37:24'),(777603,'1','180',414,'Retail Sale Id 325013',0.00,2064.00,344.00,2064.00,0.00,'2021-05-18 07:41:33'),(777611,'1','180',414,'Retail Sale Id 325021',0.00,1032.00,344.00,1032.00,0.00,'2021-05-18 07:43:25'),(777941,'1','180',414,'Retail Sale Id 325318',0.00,1032.00,344.00,1032.00,0.00,'2021-05-18 08:57:12'),(778057,'1','180',414,'Retail Sale Id 325411',0.00,1032.00,344.00,1032.00,0.00,'2021-05-18 09:24:59'),(778120,'1','180',414,'Retail Sale Id 325461',0.00,1376.00,344.00,1376.00,0.00,'2021-05-18 09:43:53'),(778218,'1','180',414,'Retail Sale Id 325564',0.00,2064.00,344.00,2064.00,0.00,'2021-05-18 10:08:16'),(778383,'1','180',414,'Retail Sale Id 325730',0.00,4000.72,344.00,4000.72,0.00,'2021-05-18 10:53:04'),(779402,'1','180',414,'Retail Sale Id 326674',0.00,2064.00,344.00,2064.00,0.00,'2021-05-18 15:16:59'),(779886,'1','180',414,'Retail Sale Id 327122',0.00,1032.00,344.00,1032.00,0.00,'2021-05-18 16:32:45'),(780547,'1','180',414,'Retail Sale Id 327673',0.00,1720.00,344.00,1720.00,0.00,'2021-05-19 07:22:03'),(780633,'1','180',414,'Retail Sale Id 327762',0.00,1720.00,344.00,1720.00,0.00,'2021-05-19 07:50:07'),(781053,'1','180',414,'Retail Sale Id 328133',0.00,4300.00,344.00,4300.00,0.00,'2021-05-19 09:22:52'),(781080,'1','180',414,'Retail Sale Id 328156',0.00,1032.00,344.00,1032.00,0.00,'2021-05-19 09:29:17'),(781081,'1','180',414,'Retail Sale Id 328156',0.00,1032.00,344.00,1032.00,0.00,'2021-05-19 09:29:17'),(782006,'1','180',414,'Retail Sale Id 329030',0.00,172000.00,322.00,161000.00,-11000.00,'2021-05-19 13:37:56'),(784713,'1','180',414,'Retail Sale Id 331601',0.00,4000.72,344.00,4000.72,0.00,'2021-05-20 11:57:38'),(785564,'1','180',414,'Retail Sale Id 332386',0.00,2064.00,344.00,2064.00,0.00,'2021-05-20 14:56:21'),(785691,'1','180',414,'Retail Sale Id 332515',0.00,4300.00,344.00,4300.00,0.00,'2021-05-20 15:20:28'),(786026,'1','180',414,'Retail Sale Id 332890',0.00,2064.00,344.00,2064.00,0.00,'2021-05-20 16:12:44'),(786274,'1','180',414,'Retail Sale Id 333188',0.00,4300.00,344.00,4300.00,0.00,'2021-05-20 16:55:28'),(786847,'1','180',414,'Retail Sale Id 333700',0.00,1032.00,344.00,1032.00,0.00,'2021-05-21 07:22:14'),(787134,'1','180',414,'Retail Sale Id 333974',0.00,1998.64,344.00,1998.64,0.00,'2021-05-21 08:15:54'),(787611,'1','180',414,'Retail Sale Id 334541',0.00,4300.00,344.00,4300.00,0.00,'2021-05-21 10:07:37'),(787635,'1','180',414,'Retail Sale Id 334557',0.00,1032.00,344.00,1032.00,0.00,'2021-05-21 10:13:14'),(788789,'1','180',414,'Retail Sale Id 335679',0.00,2064.00,344.00,2064.00,0.00,'2021-05-21 15:05:55'),(789320,'1','180',414,'Retail Sale Id 336318',0.00,516.00,344.00,516.00,0.00,'2021-05-21 16:51:23'),(789998,'1','180',414,'Retail Sale Id 336999',0.00,2064.00,344.00,2064.00,0.00,'2021-05-22 07:46:54'),(790352,'1','180',414,'Retail Sale Id 337301',0.00,1720.00,344.00,1720.00,0.00,'2021-05-22 08:41:07'),(790465,'1','180',414,'Retail Sale Id 337411',0.00,4300.00,344.00,4300.00,0.00,'2021-05-22 08:58:35'),(790813,'1','180',414,'Retail Sale Id 337794',0.00,1032.00,344.00,1032.00,0.00,'2021-05-22 09:50:55'),(790830,'1','180',414,'Retail Sale Id 337816',0.00,103200.00,322.00,96600.00,-6600.00,'2021-05-22 09:53:47'),(790955,'1','180',414,'Retail Sale Id 337994',0.00,1720.00,344.00,1720.00,0.00,'2021-05-22 10:14:56'),(791011,'1','180',414,'Retail Sale Id 338057',0.00,2064.00,344.00,2064.00,0.00,'2021-05-22 10:27:51'),(793113,'1','180',414,'Retail Sale Id 340232',0.00,2064.00,344.00,2064.00,0.00,'2021-05-22 16:03:57'),(793141,'1','180',414,'Retail Sale Id 340262',0.00,1032.00,344.00,1032.00,0.00,'2021-05-22 16:08:03'),(793707,'1','180',414,'Retail Sale Id 340902',0.00,1720.00,344.00,1720.00,0.00,'2021-05-22 17:51:19'),(794021,'1','180',414,'Retail Sale Id 341201',0.00,1032.00,344.00,1032.00,0.00,'2021-05-23 07:18:23'),(795956,'1','180',414,'Retail Sale Id 343349',0.00,4300.00,344.00,4300.00,0.00,'2021-05-23 13:28:12'),(796444,'1','180',414,'Retail Sale Id 343830',0.00,56760.00,322.00,53130.00,-3630.00,'2021-05-23 14:59:48'),(796999,'1','180',414,'Retail Sale Id 344379',0.00,2064.00,344.00,2064.00,0.00,'2021-05-23 17:04:44'),(798006,'1','180',414,'Retail Sale Id 345195',0.00,2064.00,344.00,2064.00,0.00,'2021-05-24 09:37:15'),(798524,'1','180',414,'Retail Sale Id 345673',0.00,1032.00,344.00,1032.00,0.00,'2021-05-24 11:52:27'),(798701,'1','180',414,'Retail Sale Id 345844',0.00,2064.00,344.00,2064.00,0.00,'2021-05-24 12:48:04'),(798742,'1','180',414,'Retail Sale Id 345885',0.00,17200.00,322.00,16100.00,-1100.00,'2021-05-24 12:59:54'),(799681,'1','180',414,'Retail Sale Id 346617',0.00,4300.00,344.00,4300.00,0.00,'2021-05-24 16:04:59'),(799802,'1','180',414,'Retail Sale Id 346863',0.00,172000.00,322.00,161000.00,-11000.00,'2021-05-24 16:28:34'),(799894,'1','180',414,'Retail Sale Id 346957',0.00,4300.00,344.00,4300.00,0.00,'2021-05-24 16:41:55'),(800049,'1','180',414,'Retail Sale Id 347107',0.00,4300.00,344.00,4300.00,0.00,'2021-05-24 17:09:26'),(800994,'1','180',414,'Retail Sale Id 347867',0.00,1001.04,344.00,1001.04,0.00,'2021-05-25 08:53:49'),(801630,'1','180',414,'Retail Sale Id 348456',0.00,1200.56,344.00,1200.56,0.00,'2021-05-25 11:19:05'),(801738,'1','180',414,'Retail Sale Id 348564',0.00,2064.00,344.00,2064.00,0.00,'2021-05-25 11:43:10'),(802336,'1','180',414,'Retail Sale Id 349098',0.00,1001.04,344.00,1001.04,0.00,'2021-05-25 14:02:08'),(802870,'1','180',414,'Retail Sale Id 349644',0.00,2064.00,344.00,2064.00,0.00,'2021-05-25 15:45:56'),(802997,'1','180',414,'Retail Sale Id 349776',0.00,4300.00,344.00,4300.00,0.00,'2021-05-25 16:03:53'),(805371,'1','180',414,'Retail Sale Id 351974',0.00,4300.00,344.00,4300.00,0.00,'2021-05-26 12:24:52'),(805532,'1','180',414,'Retail Sale Id 352134',0.00,1720.00,344.00,1720.00,0.00,'2021-05-26 13:13:17'),(805534,'1','180',414,'Retail Sale Id 352136',0.00,1032.00,344.00,1032.00,0.00,'2021-05-26 13:14:13'),(805535,'1','180',414,'Retail Sale Id 352136',0.00,2064.00,344.00,2064.00,0.00,'2021-05-26 13:14:13'),(805888,'1','180',414,'Retail Sale Id 352436',0.00,1499.84,344.00,1499.84,0.00,'2021-05-26 14:40:04'),(806114,'1','180',414,'Retail Sale Id 352636',0.00,1720.00,344.00,1720.00,0.00,'2021-05-26 15:19:47'),(806596,'1','180',414,'Retail Sale Id 353115',0.00,2064.00,344.00,2064.00,0.00,'2021-05-26 16:37:35'),(806706,'1','180',414,'Retail Sale Id 353207',0.00,1032.00,344.00,1032.00,0.00,'2021-05-26 16:52:33'),(806723,'1','180',414,'Retail Sale Id 353225',0.00,2064.00,344.00,2064.00,0.00,'2021-05-26 16:55:18'),(806796,'1','180',414,'Retail Sale Id 353298',0.00,4300.00,344.00,4300.00,0.00,'2021-05-26 17:10:40'),(806945,'1','180',414,'Retail Sale Id 353446',0.00,121776.00,322.00,113988.00,-7788.00,'2021-05-26 17:49:35'),(806950,'1','180',414,'Retail Sale Id 353451',0.00,1032.00,344.00,1032.00,0.00,'2021-05-26 17:51:03'),(807574,'1','180',414,'Retail Sale Id 353966',0.00,1032.00,344.00,1032.00,0.00,'2021-05-27 08:10:28'),(807575,'1','180',414,'Retail Sale Id 353966',0.00,1032.00,344.00,1032.00,0.00,'2021-05-27 08:10:28'),(808256,'1','180',414,'Retail Sale Id 354606',0.00,6880.00,322.00,6440.00,-440.00,'2021-05-27 10:32:27'),(819533,'1','180',414,'Retail Sale Id 365420',0.00,1720.00,344.00,1720.00,0.00,'2021-05-30 14:37:28'),(819543,'1','180',414,'Retail Sale Id 365431',0.00,2064.00,344.00,2064.00,0.00,'2021-05-30 14:38:41'),(819548,'1','180',414,'Retail Sale Id 365437',0.00,2064.00,344.00,2064.00,0.00,'2021-05-30 14:39:52'),(819559,'1','180',414,'Retail Sale Id 365448',0.00,2064.00,344.00,2064.00,0.00,'2021-05-30 14:40:45'),(819564,'1','180',414,'Retail Sale Id 365453',0.00,688.00,344.00,688.00,0.00,'2021-05-30 14:41:44'),(819571,'1','180',414,'Retail Sale Id 365461',0.00,47472.00,322.00,44436.00,-3036.00,'2021-05-30 14:43:09'),(822091,'1','180',414,'Retail Sale Id 367985',0.00,3862.50,344.00,4300.00,437.50,'2021-05-31 11:18:43'),(822098,'1','180',414,'Retail Sale Id 367992',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 11:19:52'),(822102,'1','180',414,'Retail Sale Id 367999',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 11:20:52'),(822110,'1','180',414,'Retail Sale Id 368006',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 11:22:44'),(822114,'1','180',414,'Retail Sale Id 368010',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 11:23:54'),(822118,'1','180',414,'Retail Sale Id 368014',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 11:24:48'),(822129,'1','180',414,'Retail Sale Id 368025',0.00,12978.00,322.00,13524.00,546.00,'2021-05-31 11:26:55'),(822136,'1','180',414,'Retail Sale Id 368032',0.00,927.00,344.00,1032.00,105.00,'2021-05-31 11:28:20'),(822171,'1','180',414,'Retail Sale Id 368072',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 11:34:55'),(822287,'1','180',414,'Retail Sale Id 368195',0.00,3862.50,344.00,4300.00,437.50,'2021-05-31 12:07:05'),(822296,'1','180',414,'Retail Sale Id 368203',0.00,927.00,344.00,1032.00,105.00,'2021-05-31 12:09:01'),(822297,'1','180',414,'Retail Sale Id 368203',0.00,927.00,344.00,1032.00,105.00,'2021-05-31 12:09:01'),(822347,'1','180',414,'Retail Sale Id 368264',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 12:22:16'),(822712,'1','180',414,'Retail Sale Id 368601',0.00,1854.00,344.00,2064.00,210.00,'2021-05-31 13:46:29'),(823004,'1','180',414,'Retail Sale Id 368890',0.00,927.00,344.00,1032.00,105.00,'2021-05-31 14:28:56'),(823877,'1','180',414,'Retail Sale Id 369714',0.00,3862.50,344.00,4300.00,437.50,'2021-05-31 16:50:52'),(823915,'1','180',414,'Retail Sale Id 369749',0.00,185400.00,322.00,193200.00,7800.00,'2021-05-31 17:00:43'),(823957,'1','180',414,'Retail Sale Id 369790',0.00,927.00,344.00,1032.00,105.00,'2021-05-31 17:28:49'),(824472,'1','180',414,'Retail Sale Id 370256',0.00,1854.00,344.00,2064.00,210.00,'2021-06-01 07:53:12'),(824547,'1','180',414,'Retail Sale Id 370341',0.00,1545.00,344.00,1720.00,175.00,'2021-06-01 08:07:46'),(824580,'1','180',414,'Retail Sale Id 370376',0.00,1854.00,344.00,2064.00,210.00,'2021-06-01 08:13:12'),(824638,'1','180',414,'Retail Sale Id 370435',0.00,448.05,344.00,498.80,50.75,'2021-06-01 08:22:21'),(824820,'1','180',414,'Retail Sale Id 370649',0.00,1795.29,344.00,1998.64,203.35,'2021-06-01 08:59:28'),(824837,'1','180',414,'Retail Sale Id 370674',0.00,927.00,344.00,1032.00,105.00,'2021-06-01 09:04:56'),(825033,'1','180',414,'Retail Sale Id 370886',0.00,1854.00,344.00,2064.00,210.00,'2021-06-01 09:45:59'),(825454,'1','180',414,'Retail Sale Id 371361',0.00,927.00,344.00,1032.00,105.00,'2021-06-01 11:12:06'),(825938,'1','180',414,'Retail Sale Id 371862',0.00,3862.50,344.00,4300.00,437.50,'2021-06-01 12:35:49'),(827478,'1','180',414,'Retail Sale Id 373468',0.00,3862.50,344.00,4300.00,437.50,'2021-06-01 16:01:18'),(827700,'1','180',414,'Retail Sale Id 373695',0.00,1795.29,344.00,1998.64,203.35,'2021-06-01 16:24:07'),(827784,'1','180',414,'Retail Sale Id 373776',0.00,1854.00,344.00,2064.00,210.00,'2021-06-01 16:32:09'),(827855,'1','180',414,'Retail Sale Id 373853',0.00,3862.50,344.00,4300.00,437.50,'2021-06-01 16:40:03'),(828201,'1','180',414,'Retail Sale Id 374234',0.00,1854.00,344.00,2064.00,210.00,'2021-06-01 17:26:50'),(828209,'1','180',414,'Retail Sale Id 374244',0.00,719.97,344.00,801.52,81.55,'2021-06-01 17:28:05'),(828249,'1','180',414,'Retail Sale Id 374285',0.00,3862.50,344.00,4300.00,437.50,'2021-06-01 17:36:09'),(831917,'1','180',414,'Retail Sale Id 377955',0.00,896.10,344.00,997.60,101.50,'2021-06-02 15:47:39'),(831983,'1','180',414,'Retail Sale Id 378009',0.00,1545.00,344.00,1720.00,175.00,'2021-06-02 15:57:02'),(832398,'1','180',414,'Retail Sale Id 378402',0.00,1854.00,344.00,2064.00,210.00,'2021-06-02 17:07:19'),(832401,'1','180',414,'Retail Sale Id 378405',0.00,2781.00,344.00,3096.00,315.00,'2021-06-02 17:08:41'),(832407,'1','180',414,'Retail Sale Id 378411',0.00,1236.00,344.00,1376.00,140.00,'2021-06-02 17:10:12'),(832411,'1','180',414,'Retail Sale Id 378415',0.00,1854.00,344.00,2064.00,210.00,'2021-06-02 17:11:09'),(832486,'1','180',414,'Retail Sale Id 378486',0.00,927.00,344.00,1032.00,105.00,'2021-06-02 17:34:04'),(832504,'1','180',414,'Retail Sale Id 378507',0.00,1854.00,344.00,2064.00,210.00,'2021-06-02 17:40:34'),(832553,'1','180',414,'Retail Sale Id 378565',0.00,2781.00,344.00,3096.00,315.00,'2021-06-02 18:03:45'),(832560,'1','180',414,'Retail Sale Id 378572',0.00,3862.50,344.00,4300.00,437.50,'2021-06-02 18:10:34'),(832844,'1','180',414,'Retail Sale Id 378786',0.00,899.19,344.00,1001.04,101.85,'2021-06-03 07:17:50'),(833155,'1','180',414,'Retail Sale Id 379119',0.00,3862.50,344.00,4300.00,437.50,'2021-06-03 08:21:57'),(833591,'1','180',414,'Retail Sale Id 379537',0.00,1854.00,344.00,2064.00,210.00,'2021-06-03 09:30:40'),(833890,'1','180',414,'Retail Sale Id 379833',0.00,927.00,344.00,1032.00,105.00,'2021-06-03 10:25:52'),(834379,'1','180',414,'Retail Sale Id 380311',0.00,3862.50,344.00,4300.00,437.50,'2021-06-03 12:08:52'),(835469,'1','180',414,'Retail Sale Id 381429',0.00,67980.00,322.00,70840.00,2860.00,'2021-06-03 15:42:08'),(836095,'1','180',414,'Retail Sale Id 382081',0.00,14059.50,344.00,15652.00,1592.50,'2021-06-03 18:12:34'),(837475,'1','180',414,'Retail Sale Id 383417',0.00,1854.00,344.00,2064.00,210.00,'2021-06-04 10:04:02'),(837497,'1','180',414,'Retail Sale Id 383443',0.00,1545.00,344.00,1720.00,175.00,'2021-06-04 10:07:34'),(839830,'1','180',414,'Retail Sale Id 385827',0.00,899.19,344.00,1001.04,101.85,'2021-06-04 17:52:55'),(839831,'1','180',414,'Retail Sale Id 385828',0.00,1854.00,344.00,2064.00,210.00,'2021-06-04 17:53:59'),(839832,'1','180',414,'Retail Sale Id 385829',0.00,899.19,344.00,1001.04,101.85,'2021-06-04 17:55:07'),(841200,'1','180',414,'Retail Sale Id 387220',0.00,927.00,344.00,1032.00,105.00,'2021-06-05 09:47:51'),(841205,'1','180',414,'Retail Sale Id 387227',0.00,719.97,344.00,801.52,81.55,'2021-06-05 09:48:38'),(841299,'1','180',414,'Retail Sale Id 387334',0.00,77250.00,322.00,80500.00,3250.00,'2021-06-05 10:01:21'),(841323,'1','180',414,'Retail Sale Id 387350',0.00,927.00,344.00,1032.00,105.00,'2021-06-05 10:04:13'),(841680,'1','180',414,'Retail Sale Id 387732',0.00,1854.00,344.00,2064.00,210.00,'2021-06-05 10:53:47'),(841687,'1','180',414,'Retail Sale Id 387739',0.00,899.19,344.00,1001.04,101.85,'2021-06-05 10:55:07'),(844101,'1','180',414,'Retail Sale Id 390143',0.00,927.00,344.00,1032.00,105.00,'2021-06-05 17:35:50'),(844132,'1','180',414,'Retail Sale Id 390168',0.00,15450.00,322.00,16100.00,650.00,'2021-06-05 17:51:13'),(844216,'1','180',414,'Retail Sale Id 390231',0.00,927.00,344.00,1032.00,105.00,'2021-06-05 19:11:22'),(844217,'1','180',414,'Retail Sale Id 390232',0.00,1545.00,344.00,1720.00,175.00,'2021-06-05 19:12:05'),(844756,'1','180',414,'Retail Sale Id 390763',0.00,1854.00,344.00,2064.00,210.00,'2021-06-06 08:11:43'),(844761,'1','180',414,'Retail Sale Id 390768',0.00,899.19,344.00,1001.04,101.85,'2021-06-06 08:13:06'),(844901,'1','180',414,'Retail Sale Id 390902',0.00,1545.00,344.00,1720.00,175.00,'2021-06-06 08:35:11'),(844974,'1','180',414,'Retail Sale Id 390978',0.00,927.00,344.00,1032.00,105.00,'2021-06-06 08:46:23'),(845254,'1','180',414,'Retail Sale Id 391269',0.00,1854.00,344.00,2064.00,210.00,'2021-06-06 09:38:34'),(845588,'1','180',414,'Retail Sale Id 391639',0.00,1854.00,344.00,2064.00,210.00,'2021-06-06 10:45:43'),(847304,'1','180',414,'Retail Sale Id 393420',0.00,927.00,344.00,1032.00,105.00,'2021-06-06 16:09:16'),(847706,'1','180',414,'Retail Sale Id 393803',0.00,1854.00,344.00,2064.00,210.00,'2021-06-06 17:13:17'),(847783,'1','180',414,'Retail Sale Id 393876',0.00,1854.00,344.00,2064.00,210.00,'2021-06-06 17:33:43'),(847883,'1','180',414,'Retail Sale Id 393969',0.00,50985.00,322.00,53130.00,2145.00,'2021-06-06 18:21:22'),(847903,'1','180',414,'Retail Sale Id 393983',0.00,1854.00,344.00,2064.00,210.00,'2021-06-06 18:57:43'),(848295,'1','180',414,'Retail Sale Id 394283',0.00,1545.00,344.00,1720.00,175.00,'2021-06-07 07:34:06'),(848299,'1','180',414,'Retail Sale Id 394287',0.00,1854.00,344.00,2064.00,210.00,'2021-06-07 07:35:01'),(848458,'1','180',414,'Retail Sale Id 394473',0.00,1854.00,344.00,2064.00,210.00,'2021-06-07 08:10:07'),(857278,'1','180',414,'Retail Sale Id 403629',0.00,1854.00,344.00,2064.00,210.00,'2021-06-09 11:35:17'),(857377,'1','180',414,'Retail Sale Id 403681',0.00,2163.00,344.00,2408.00,245.00,'2021-06-09 11:51:41'),(859133,'1','180',414,'Retail Sale Id 405558',0.00,3862.50,344.00,4300.00,437.50,'2021-06-09 16:34:42'),(859146,'1','180',414,'Retail Sale Id 405566',0.00,1545.00,344.00,1720.00,175.00,'2021-06-09 16:36:10'),(859164,'1','180',414,'Retail Sale Id 405586',0.00,927.00,344.00,1032.00,105.00,'2021-06-09 16:38:40'),(859169,'1','180',414,'Retail Sale Id 405596',0.00,927.00,344.00,1032.00,105.00,'2021-06-09 16:39:48'),(859177,'1','180',414,'Retail Sale Id 405601',0.00,1854.00,344.00,2064.00,210.00,'2021-06-09 16:40:54'),(859185,'1','180',414,'Retail Sale Id 405609',0.00,3862.50,344.00,4300.00,437.50,'2021-06-09 16:41:59'),(859427,'1','180',414,'Retail Sale Id 405845',0.00,3862.50,344.00,4300.00,437.50,'2021-06-09 17:24:32'),(859547,'1','180',414,'Retail Sale Id 405944',0.00,30900.00,322.00,32200.00,1300.00,'2021-06-09 19:20:38'),(859809,'1','180',414,'Retail Sale Id 406145',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 07:06:13'),(859815,'1','180',414,'Retail Sale Id 406148',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 07:07:32'),(859818,'1','180',414,'Retail Sale Id 406155',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 07:08:30'),(859827,'1','180',414,'Retail Sale Id 406161',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 07:09:50'),(859834,'1','180',414,'Retail Sale Id 406168',0.00,1854.00,344.00,2064.00,210.00,'2021-06-10 07:10:50'),(860331,'1','180',414,'Retail Sale Id 406671',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 08:42:48'),(860340,'1','180',414,'Retail Sale Id 406680',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 08:44:30'),(860702,'1','180',414,'Retail Sale Id 407030',0.00,1854.00,344.00,2064.00,210.00,'2021-06-10 09:56:08'),(860713,'1','180',414,'Retail Sale Id 407042',0.00,18540.00,322.00,19320.00,780.00,'2021-06-10 09:58:54'),(860776,'1','180',414,'Retail Sale Id 407103',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 10:21:59'),(861005,'1','180',414,'Retail Sale Id 407328',0.00,2781.00,344.00,3096.00,315.00,'2021-06-10 11:21:02'),(861441,'1','180',414,'Retail Sale Id 407816',0.00,16995.00,322.00,17710.00,715.00,'2021-06-10 12:59:09'),(862783,'1','180',414,'Retail Sale Id 409064',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 16:34:07'),(862805,'1','180',414,'Retail Sale Id 409082',0.00,3862.50,344.00,4300.00,437.50,'2021-06-10 16:37:07'),(862815,'1','180',414,'Retail Sale Id 409093',0.00,1545.00,344.00,1720.00,175.00,'2021-06-10 16:38:29'),(863222,'1','180',414,'Retail Sale Id 409498',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 18:09:02'),(863254,'1','180',414,'Retail Sale Id 409524',0.00,927.00,344.00,1032.00,105.00,'2021-06-10 18:49:57'),(864472,'1','180',414,'Retail Sale Id 410752',0.00,15450.00,322.00,16100.00,650.00,'2021-06-11 09:32:51'),(866720,'1','180',414,'Retail Sale Id 413250',0.00,3862.50,344.00,4300.00,437.50,'2021-06-11 16:23:13'),(866724,'1','180',414,'Retail Sale Id 413254',0.00,3090.00,344.00,3440.00,350.00,'2021-06-11 16:24:22'),(866730,'1','180',414,'Retail Sale Id 413259',0.00,1545.00,344.00,1720.00,175.00,'2021-06-11 16:25:22'),(867064,'1','180',414,'Retail Sale Id 413628',0.00,1854.00,344.00,2064.00,210.00,'2021-06-11 17:53:06'),(867095,'1','180',414,'Retail Sale Id 413639',0.00,1854.00,344.00,2064.00,210.00,'2021-06-11 18:07:55'),(867961,'1','180',414,'Retail Sale Id 414616',0.00,1854.00,344.00,2064.00,210.00,'2021-06-12 08:48:45'),(868051,'1','180',414,'Retail Sale Id 414724',0.00,22248.00,322.00,23184.00,936.00,'2021-06-12 09:15:07'),(868667,'1','180',414,'Retail Sale Id 415363',0.00,927.00,344.00,1032.00,105.00,'2021-06-12 11:27:14'),(870567,'1','180',414,'Retail Sale Id 417433',0.00,1545.00,344.00,1720.00,175.00,'2021-06-12 18:24:22'),(870569,'1','180',414,'Retail Sale Id 417435',0.00,1854.00,344.00,2064.00,210.00,'2021-06-12 18:27:15'),(870584,'1','180',414,'Retail Sale Id 417441',0.00,123600.00,322.00,128800.00,5200.00,'2021-06-12 19:01:43'),(871927,'1','180',414,'Retail Sale Id 418769',0.00,1545.00,344.00,1720.00,175.00,'2021-06-13 10:13:58'),(873757,'1','180',414,'Retail Sale Id 420652',0.00,88065.00,322.00,91770.00,3705.00,'2021-06-13 14:48:17'),(873765,'1','180',414,'Retail Sale Id 420671',0.00,1545.00,344.00,1720.00,175.00,'2021-06-13 14:49:15'),(873768,'1','180',414,'Retail Sale Id 420675',0.00,309.00,344.00,344.00,35.00,'2021-06-13 14:50:00'),(873774,'1','180',414,'Retail Sale Id 420680',0.00,1792.20,344.00,1995.20,203.00,'2021-06-13 14:50:53'),(873782,'1','180',414,'Retail Sale Id 420688',0.00,1236.00,344.00,1376.00,140.00,'2021-06-13 14:51:53'),(873784,'1','180',414,'Retail Sale Id 420692',0.00,927.00,344.00,1032.00,105.00,'2021-06-13 14:52:29'),(873792,'1','180',414,'Retail Sale Id 420696',0.00,927.00,344.00,1032.00,105.00,'2021-06-13 14:53:29'),(873798,'1','180',414,'Retail Sale Id 420700',0.00,1854.00,344.00,2064.00,210.00,'2021-06-13 14:54:15'),(876077,'1','180',414,'Retail Sale Id 423029',0.00,1266.90,360.00,1476.00,209.10,'2021-06-14 10:01:15'),(876115,'1','180',414,'Retail Sale Id 423074',0.00,927.00,360.00,1080.00,153.00,'2021-06-14 10:06:52'),(876124,'1','180',414,'Retail Sale Id 423082',0.00,859.02,360.00,1000.80,141.78,'2021-06-14 10:09:00'),(876147,'1','180',414,'Retail Sale Id 423101',0.00,927.00,360.00,1080.00,153.00,'2021-06-14 10:12:41'),(876167,'1','180',414,'Retail Sale Id 423128',0.00,1854.00,360.00,2160.00,306.00,'2021-06-14 10:15:28'),(876186,'1','180',414,'Retail Sale Id 423138',0.00,859.02,360.00,1000.80,141.78,'2021-06-14 10:18:19'),(876218,'1','180',414,'Retail Sale Id 423178',0.00,927.00,360.00,1080.00,153.00,'2021-06-14 10:23:44'),(876392,'1','180',414,'Retail Sale Id 423358',0.00,1854.00,360.00,2160.00,306.00,'2021-06-14 10:53:34'),(876607,'1','180',414,'Retail Sale Id 423574',0.00,1854.00,360.00,2160.00,306.00,'2021-06-14 11:26:25'),(876691,'1','180',414,'Retail Sale Id 423663',0.00,859.02,360.00,1000.80,141.78,'2021-06-14 11:40:01'),(876929,'1','180',414,'Retail Sale Id 423905',0.00,1854.00,360.00,2160.00,306.00,'2021-06-14 12:23:09'),(877732,'1','180',414,'Retail Sale Id 424732',0.00,927.00,360.00,1080.00,153.00,'2021-06-14 14:48:24'),(878588,'1','180',414,'Retail Sale Id 425524',0.00,1854.00,360.00,2160.00,306.00,'2021-06-14 18:44:42'),(878589,'1','180',414,'Retail Sale Id 425525',0.00,1854.00,360.00,2160.00,306.00,'2021-06-14 18:45:33'),(878965,'1','180',414,'Retail Sale Id 425867',0.00,18540.00,322.00,19320.00,780.00,'2021-06-15 07:27:35'),(879010,'1','180',414,'Retail Sale Id 425931',0.00,927.00,360.00,1080.00,153.00,'2021-06-15 07:39:13'),(879406,'1','180',414,'Retail Sale Id 426398',0.00,927.00,360.00,1080.00,153.00,'2021-06-15 08:56:00'),(881709,'1','180',414,'Retail Sale Id 428934',0.00,859.02,360.00,1000.80,141.78,'2021-06-15 18:05:17'),(881717,'1','180',414,'Retail Sale Id 428942',0.00,2472.00,360.00,2880.00,408.00,'2021-06-15 18:17:55'),(881739,'1','180',414,'Retail Sale Id 428952',0.00,1545.00,360.00,1800.00,255.00,'2021-06-15 18:46:21'),(881742,'1','180',414,'Retail Sale Id 428953',0.00,1854.00,360.00,2160.00,306.00,'2021-06-15 18:47:34'),(881745,'1','180',414,'Retail Sale Id 428954',0.00,1854.00,360.00,2160.00,306.00,'2021-06-15 18:48:13'),(881747,'1','180',414,'Retail Sale Id 428956',0.00,463.50,360.00,540.00,76.50,'2021-06-15 18:49:22'),(881750,'1','180',414,'Retail Sale Id 428957',0.00,1854.00,360.00,2160.00,306.00,'2021-06-15 18:50:03'),(882419,'1','180',414,'Retail Sale Id 429531',0.00,927.00,360.00,1080.00,153.00,'2021-06-16 08:14:23'),(882451,'1','180',414,'Retail Sale Id 429560',0.00,3090.00,360.00,3600.00,510.00,'2021-06-16 08:19:51'),(882486,'1','180',414,'Retail Sale Id 429599',0.00,18540.00,322.00,19320.00,780.00,'2021-06-16 08:24:06'),(883598,'1','180',414,'Retail Sale Id 430757',0.00,927.00,360.00,1080.00,153.00,'2021-06-16 12:08:21'),(885121,'1','180',414,'Retail Sale Id 432386',0.00,1545.00,360.00,1800.00,255.00,'2021-06-16 16:28:00'),(885129,'1','180',414,'Retail Sale Id 432390',0.00,927.00,360.00,1080.00,153.00,'2021-06-16 16:29:29'),(885135,'1','180',414,'Retail Sale Id 432399',0.00,2317.50,360.00,2700.00,382.50,'2021-06-16 16:31:00'),(885143,'1','180',414,'Retail Sale Id 432411',0.00,1854.00,360.00,2160.00,306.00,'2021-06-16 16:32:05'),(885148,'1','180',414,'Retail Sale Id 432417',0.00,401.70,360.00,468.00,66.30,'2021-06-16 16:33:22'),(885160,'1','180',414,'Retail Sale Id 432427',0.00,927.00,360.00,1080.00,153.00,'2021-06-16 16:34:53'),(885177,'1','180',414,'Retail Sale Id 432443',0.00,859.02,360.00,1000.80,141.78,'2021-06-16 16:37:11'),(885443,'1','180',414,'Retail Sale Id 432718',0.00,3862.50,360.00,4500.00,637.50,'2021-06-16 17:36:26'),(885573,'1','180',414,'Retail Sale Id 432901',0.00,1854.00,360.00,2160.00,306.00,'2021-06-16 18:37:54'),(885903,'1','180',414,'Retail Sale Id 433198',0.00,1854.00,360.00,2160.00,306.00,'2021-06-17 07:02:49'),(886037,'1','180',414,'Retail Sale Id 433370',0.00,1718.04,360.00,2001.60,283.56,'2021-06-17 07:29:51'),(886353,'1','180',414,'Retail Sale Id 433767',0.00,1545.00,360.00,1800.00,255.00,'2021-06-17 08:22:01'),(886486,'1','180',414,'Retail Sale Id 433898',0.00,1458.48,360.00,1699.20,240.72,'2021-06-17 08:42:59'),(886490,'1','180',414,'Retail Sale Id 433902',0.00,599.46,360.00,698.40,98.94,'2021-06-17 08:43:54'),(886507,'1','180',414,'Retail Sale Id 433923',0.00,927.00,360.00,1080.00,153.00,'2021-06-17 08:48:24'),(886514,'1','180',414,'Retail Sale Id 433930',0.00,927.00,360.00,1080.00,153.00,'2021-06-17 08:49:36'),(886880,'1','180',414,'Retail Sale Id 434378',0.00,1854.00,360.00,2160.00,306.00,'2021-06-17 09:55:01'),(887127,'1','180',414,'Retail Sale Id 434669',0.00,927.00,360.00,1080.00,153.00,'2021-06-17 10:44:36'),(887132,'1','180',414,'Retail Sale Id 434673',0.00,927.00,360.00,1080.00,153.00,'2021-06-17 10:45:52'),(887390,'1','180',414,'Retail Sale Id 434960',0.00,927.00,360.00,1080.00,153.00,'2021-06-17 11:46:09'),(887874,'1','180',414,'Retail Sale Id 435567',0.00,1718.04,360.00,2001.60,283.56,'2021-06-17 13:25:44'),(888500,'1','180',414,'Retail Sale Id 436169',0.00,927.00,360.00,1080.00,153.00,'2021-06-17 15:17:21'),(889333,'1','180',414,'Retail Sale Id 437150',0.00,3862.50,360.00,4500.00,637.50,'2021-06-17 17:48:37'),(889347,'1','180',414,'Retail Sale Id 437164',0.00,1854.00,360.00,2160.00,306.00,'2021-06-17 17:54:46'),(889352,'1','180',414,'Retail Sale Id 437170',0.00,1854.00,360.00,2160.00,306.00,'2021-06-17 17:57:18'),(889355,'1','180',414,'Retail Sale Id 437172',0.00,1854.00,360.00,2160.00,306.00,'2021-06-17 17:58:07'),(889395,'1','180',414,'Retail Sale Id 437213',0.00,1854.00,360.00,2160.00,306.00,'2021-06-17 19:29:20'),(891636,'1','180',414,'Retail Sale Id 440007',0.00,1854.00,360.00,2160.00,306.00,'2021-06-18 13:37:36'),(891733,'1','180',414,'Retail Sale Id 440137',0.00,1718.04,360.00,2001.60,283.56,'2021-06-18 13:52:57'),(891739,'1','180',414,'Retail Sale Id 440144',0.00,927.00,360.00,1080.00,153.00,'2021-06-18 13:53:51'),(891743,'1','180',414,'Retail Sale Id 440150',0.00,927.00,360.00,1080.00,153.00,'2021-06-18 13:54:40'),(892926,'1','180',414,'Retail Sale Id 441399',0.00,927.00,360.00,1080.00,153.00,'2021-06-18 17:37:34'),(892942,'1','180',414,'Retail Sale Id 441415',0.00,1854.00,360.00,2160.00,306.00,'2021-06-18 17:43:46'),(892962,'1','180',414,'Retail Sale Id 441438',0.00,3862.50,360.00,4500.00,637.50,'2021-06-18 17:52:54'),(892966,'1','180',414,'Retail Sale Id 441443',0.00,834.30,360.00,972.00,137.70,'2021-06-18 17:54:12'),(892968,'1','180',414,'Retail Sale Id 441446',0.00,3862.50,360.00,4500.00,637.50,'2021-06-18 17:55:09'),(892971,'1','180',414,'Retail Sale Id 441450',0.00,30900.00,332.00,33200.00,2300.00,'2021-06-18 17:56:59'),(893707,'1','180',414,'Retail Sale Id 442389',0.00,1545.00,360.00,1800.00,255.00,'2021-06-19 08:40:18'),(893782,'1','180',414,'Retail Sale Id 442469',0.00,3862.50,360.00,4500.00,637.50,'2021-06-19 08:54:31'),(893978,'1','180',414,'Retail Sale Id 442708',0.00,3862.50,360.00,4500.00,637.50,'2021-06-19 09:33:56'),(894325,'1','180',414,'Retail Sale Id 443100',0.00,927.00,360.00,1080.00,153.00,'2021-06-19 10:30:43'),(894500,'1','180',414,'Retail Sale Id 443287',0.00,927.00,360.00,1080.00,153.00,'2021-06-19 11:07:42'),(894584,'1','180',414,'Retail Sale Id 443349',0.00,927.00,360.00,1080.00,153.00,'2021-06-19 11:24:13'),(894585,'1','180',414,'Retail Sale Id 443349',0.00,1854.00,360.00,2160.00,306.00,'2021-06-19 11:24:13'),(896033,'1','180',414,'Retail Sale Id 444869',0.00,927.00,360.00,1080.00,153.00,'2021-06-19 15:52:34'),(897670,'1','180',414,'Retail Sale Id 446586',0.00,18540.00,332.00,19920.00,1380.00,'2021-06-20 09:21:15'),(898178,'1','180',414,'Retail Sale Id 447108',0.00,3862.50,360.00,4500.00,637.50,'2021-06-20 10:47:43'),(898187,'1','180',414,'Retail Sale Id 447118',0.00,1854.00,360.00,2160.00,306.00,'2021-06-20 10:49:08'),(898188,'1','180',414,'Retail Sale Id 447118',0.00,1854.00,360.00,2160.00,306.00,'2021-06-20 10:49:08'),(898644,'1','180',414,'Retail Sale Id 447572',0.00,927.00,360.00,1080.00,153.00,'2021-06-20 12:04:50'),(900109,'1','180',414,'Retail Sale Id 449103',0.00,927.00,360.00,1080.00,153.00,'2021-06-20 16:58:38'),(900138,'1','180',414,'Retail Sale Id 449133',0.00,5562.00,360.00,6480.00,918.00,'2021-06-20 17:18:13'),(900194,'1','180',414,'Retail Sale Id 449192',0.00,927.00,360.00,1080.00,153.00,'2021-06-20 18:05:16'),(900195,'1','180',414,'Retail Sale Id 449193',0.00,834.30,360.00,972.00,137.70,'2021-06-20 18:06:27'),(901498,'1','180',414,'Retail Sale Id 450474',0.00,33990.00,332.00,36520.00,2530.00,'2021-06-21 11:25:50'),(901540,'1','180',414,'Retail Sale Id 450518',0.00,927.00,360.00,1080.00,153.00,'2021-06-21 11:43:49'),(903094,'1','180',414,'Retail Sale Id 452179',0.00,1854.00,360.00,2160.00,306.00,'2021-06-21 17:02:30'),(903260,'1','180',414,'Retail Sale Id 452349',0.00,17922.00,332.00,19256.00,1334.00,'2021-06-21 17:30:01'),(903417,'1','180',414,'Retail Sale Id 452508',0.00,1545.00,360.00,1800.00,255.00,'2021-06-21 19:02:56'),(903418,'1','180',414,'Retail Sale Id 452509',0.00,859.02,360.00,1000.80,141.78,'2021-06-21 19:03:52'),(903419,'1','180',414,'Retail Sale Id 452510',0.00,1266.90,360.00,1476.00,209.10,'2021-06-21 19:05:19'),(903941,'1','180',414,'Retail Sale Id 453039',0.00,927.00,360.00,1080.00,153.00,'2021-06-22 08:17:02'),(904652,'1','180',414,'Retail Sale Id 453755',0.00,3862.50,360.00,4500.00,637.50,'2021-06-22 10:59:43'),(904654,'1','180',414,'Retail Sale Id 453757',0.00,1854.00,360.00,2160.00,306.00,'2021-06-22 11:00:36'),(904663,'1','180',414,'Retail Sale Id 453776',0.00,4326.00,360.00,5040.00,714.00,'2021-06-22 11:01:43'),(904735,'1','180',414,'Retail Sale Id 453856',0.00,1854.00,360.00,2160.00,306.00,'2021-06-22 11:21:33'),(904811,'1','180',414,'Retail Sale Id 453945',0.00,1854.00,360.00,2160.00,306.00,'2021-06-22 11:40:31'),(906481,'1','180',414,'Retail Sale Id 455836',0.00,2997.30,360.00,3492.00,494.70,'2021-06-22 18:37:11'),(906482,'1','180',414,'Retail Sale Id 455839',0.00,556.20,360.00,648.00,91.80,'2021-06-22 18:39:36'),(907227,'1','180',414,'Retail Sale Id 456476',0.00,1854.00,360.00,2160.00,306.00,'2021-06-23 08:38:59'),(907239,'1','180',414,'Retail Sale Id 456485',0.00,18540.00,332.00,19920.00,1380.00,'2021-06-23 08:41:53'),(907544,'1','180',414,'Retail Sale Id 456804',0.00,463.50,360.00,540.00,76.50,'2021-06-23 09:45:15'),(910027,'1','180',414,'Retail Sale Id 459696',0.00,3862.50,360.00,4500.00,637.50,'2021-06-23 18:00:47'),(910033,'1','180',414,'Retail Sale Id 459703',0.00,130707.00,332.00,140436.00,9729.00,'2021-06-23 18:04:14'),(910037,'1','180',414,'Retail Sale Id 459707',0.00,927.00,360.00,1080.00,153.00,'2021-06-23 18:05:41'),(911803,'1','180',414,'Retail Sale Id 461504',0.00,24486.00,332.00,25564.00,1078.00,'2021-06-24 12:24:24'),(911904,'1','180',414,'Retail Sale Id 461600',0.00,55332.00,332.00,57768.00,2436.00,'2021-06-24 12:46:20'),(912612,'1','180',414,'Retail Sale Id 462283',0.00,1908.00,360.00,2160.00,252.00,'2021-06-24 14:56:15'),(912636,'1','180',414,'Retail Sale Id 462307',0.00,1908.00,360.00,2160.00,252.00,'2021-06-24 15:00:25'),(912644,'1','180',414,'Retail Sale Id 462316',0.00,3975.00,360.00,4500.00,525.00,'2021-06-24 15:01:40'),(912649,'1','180',414,'Retail Sale Id 462321',0.00,1590.00,360.00,1800.00,210.00,'2021-06-24 15:03:11'),(912664,'1','180',414,'Retail Sale Id 462329',0.00,954.00,360.00,1080.00,126.00,'2021-06-24 15:04:38'),(912675,'1','180',414,'Retail Sale Id 462338',0.00,954.00,360.00,1080.00,126.00,'2021-06-24 15:05:36'),(912848,'1','180',414,'Retail Sale Id 462522',0.00,1272.00,360.00,1440.00,168.00,'2021-06-24 15:34:25'),(913535,'1','180',414,'Retail Sale Id 463319',0.00,705.96,360.00,799.20,93.24,'2021-06-24 17:53:07'),(913563,'1','180',414,'Retail Sale Id 463363',0.00,954.00,360.00,1080.00,126.00,'2021-06-24 18:24:34'),(914122,'1','180',414,'Retail Sale Id 463843',0.00,954.00,360.00,1080.00,126.00,'2021-06-25 08:12:19'),(914146,'1','180',414,'Retail Sale Id 463870',0.00,954.00,360.00,1080.00,126.00,'2021-06-25 08:16:23'),(914151,'1','180',414,'Retail Sale Id 463875',0.00,954.00,360.00,1080.00,126.00,'2021-06-25 08:17:37'),(914213,'1','180',414,'Retail Sale Id 463940',0.00,19080.00,332.00,19920.00,840.00,'2021-06-25 08:30:06'),(914809,'1','180',414,'Retail Sale Id 464565',0.00,884.04,360.00,1000.80,116.76,'2021-06-25 10:42:02'),(914810,'1','180',414,'Retail Sale Id 464565',0.00,1326.06,360.00,1501.20,175.14,'2021-06-25 10:42:02'),(914943,'1','180',414,'Retail Sale Id 464704',0.00,954.00,360.00,1080.00,126.00,'2021-06-25 11:13:58'),(915083,'1','180',414,'Retail Sale Id 464844',0.00,1908.00,360.00,2160.00,252.00,'2021-06-25 11:53:30'),(915091,'1','180',414,'Retail Sale Id 464851',0.00,1590.00,360.00,1800.00,210.00,'2021-06-25 11:55:45'),(915233,'1','180',414,'Retail Sale Id 464996',0.00,1272.00,360.00,1440.00,168.00,'2021-06-25 12:46:49'),(916615,'1','180',414,'Retail Sale Id 466403',0.00,2544.00,360.00,2880.00,336.00,'2021-06-25 16:57:32'),(916627,'1','180',414,'Retail Sale Id 466418',0.00,1908.00,360.00,2160.00,252.00,'2021-06-25 16:59:33'),(916720,'1','180',414,'Retail Sale Id 466530',0.00,884.04,360.00,1000.80,116.76,'2021-06-25 17:14:26'),(916812,'1','180',414,'Retail Sale Id 466632',0.00,1908.00,360.00,2160.00,252.00,'2021-06-25 17:34:48'),(916894,'1','180',414,'Retail Sale Id 466717',0.00,3975.00,360.00,4500.00,525.00,'2021-06-25 18:14:01'),(916911,'1','180',414,'Retail Sale Id 466736',0.00,3975.00,360.00,4500.00,525.00,'2021-06-25 18:38:43'),(916913,'1','180',414,'Retail Sale Id 466738',0.00,1590.00,360.00,1800.00,210.00,'2021-06-25 18:39:40'),(916915,'1','180',414,'Retail Sale Id 466741',0.00,954.00,360.00,1080.00,126.00,'2021-06-25 18:46:05'),(916916,'1','180',414,'Retail Sale Id 466741',0.00,1590.00,360.00,1800.00,210.00,'2021-06-25 18:46:05'),(916917,'1','180',414,'Retail Sale Id 466742',0.00,954.00,360.00,1080.00,126.00,'2021-06-25 18:47:29'),(916918,'1','180',414,'Retail Sale Id 466743',0.00,1908.00,360.00,2160.00,252.00,'2021-06-25 18:48:28'),(920435,'1','180',414,'Retail Sale Id 470382',0.00,3975.00,360.00,4500.00,525.00,'2021-06-26 18:31:04'),(920436,'1','180',414,'Retail Sale Id 470383',0.00,1908.00,360.00,2160.00,252.00,'2021-06-26 18:32:22'),(920438,'1','180',414,'Retail Sale Id 470385',0.00,1272.00,360.00,1440.00,168.00,'2021-06-26 18:33:22'),(920439,'1','180',414,'Retail Sale Id 470386',0.00,954.00,360.00,1080.00,126.00,'2021-06-26 18:34:20'),(920440,'1','180',414,'Retail Sale Id 470387',0.00,884.04,360.00,1000.80,116.76,'2021-06-26 18:35:15'),(920441,'1','180',414,'Retail Sale Id 470388',0.00,3816.00,360.00,4320.00,504.00,'2021-06-26 18:36:11'),(922173,'1','180',414,'Retail Sale Id 472004',0.00,1768.08,360.00,2001.60,233.52,'2021-06-27 11:50:59'),(922197,'1','180',414,'Retail Sale Id 472028',0.00,1908.00,360.00,2160.00,252.00,'2021-06-27 11:55:11'),(922211,'1','180',414,'Retail Sale Id 472042',0.00,1908.00,360.00,2160.00,252.00,'2021-06-27 11:58:08'),(922368,'1','180',414,'Retail Sale Id 472221',0.00,1908.00,360.00,2160.00,252.00,'2021-06-27 12:33:36'),(922611,'1','180',414,'Retail Sale Id 472480',0.00,2862.00,360.00,3240.00,378.00,'2021-06-27 13:17:44'),(922640,'1','180',414,'Retail Sale Id 472504',0.00,954.00,360.00,1080.00,126.00,'2021-06-27 13:21:55'),(922857,'1','180',414,'Retail Sale Id 472731',0.00,954.00,360.00,1080.00,126.00,'2021-06-27 14:02:54'),(923959,'1','180',414,'Retail Sale Id 473754',0.00,1908.00,360.00,2160.00,252.00,'2021-06-27 16:53:29'),(924066,'1','180',414,'Retail Sale Id 473857',0.00,3975.00,360.00,4500.00,525.00,'2021-06-27 17:12:30'),(924249,'1','180',414,'Retail Sale Id 474044',0.00,1749.00,360.00,1980.00,231.00,'2021-06-27 18:34:35'),(924252,'1','180',414,'Retail Sale Id 474046',0.00,1272.00,360.00,1440.00,168.00,'2021-06-27 18:35:34'),(924256,'1','180',414,'Retail Sale Id 474048',0.00,954.00,360.00,1080.00,126.00,'2021-06-27 18:36:29'),(924260,'1','180',414,'Retail Sale Id 474050',0.00,890.40,360.00,1008.00,117.60,'2021-06-27 18:37:39'),(926102,'1','180',414,'Retail Sale Id 475807',0.00,52470.00,332.00,54780.00,2310.00,'2021-06-28 13:16:19'),(926128,'1','180',414,'Retail Sale Id 475832',0.00,36888.00,332.00,38512.00,1624.00,'2021-06-28 13:22:13'),(926831,'1','180',414,'Retail Sale Id 476539',0.00,3498.00,360.00,3960.00,462.00,'2021-06-28 14:59:47'),(926839,'1','180',414,'Retail Sale Id 476545',0.00,884.04,360.00,1000.80,116.76,'2021-06-28 15:01:05'),(926848,'1','180',414,'Retail Sale Id 476556',0.00,954.00,360.00,1080.00,126.00,'2021-06-28 15:02:06'),(927519,'1','180',414,'Retail Sale Id 477309',0.00,1908.00,360.00,2160.00,252.00,'2021-06-28 16:28:44'),(929171,'1','180',414,'Retail Sale Id 478984',0.00,954.00,360.00,1080.00,126.00,'2021-06-29 09:41:09'),(929179,'1','180',414,'Retail Sale Id 478993',0.00,19080.00,332.00,19920.00,840.00,'2021-06-29 09:42:19'),(931772,'1','180',414,'Retail Sale Id 481871',0.00,1590.00,360.00,1800.00,210.00,'2021-06-29 17:29:21'),(931912,'1','180',414,'Retail Sale Id 482003',0.00,884.04,360.00,1000.80,116.76,'2021-06-29 18:32:05'),(931913,'1','180',414,'Retail Sale Id 482004',0.00,954.00,360.00,1080.00,126.00,'2021-06-29 18:33:02'),(931914,'1','180',414,'Retail Sale Id 482005',0.00,1908.00,360.00,2160.00,252.00,'2021-06-29 18:34:12'),(931915,'1','180',414,'Retail Sale Id 482006',0.00,954.00,360.00,1080.00,126.00,'2021-06-29 18:35:10'),(931916,'1','180',414,'Retail Sale Id 482007',0.00,3975.00,360.00,4500.00,525.00,'2021-06-29 18:36:21'),(931918,'1','180',414,'Retail Sale Id 482009',0.00,1590.00,360.00,1800.00,210.00,'2021-06-29 18:37:20'),(933373,'1','180',414,'Retail Sale Id 483394',0.00,954.00,360.00,1080.00,126.00,'2021-06-30 10:51:26'),(933378,'1','180',414,'Retail Sale Id 483402',0.00,442.02,360.00,500.40,58.38,'2021-06-30 10:52:33'),(933575,'1','180',414,'Retail Sale Id 483630',0.00,442.02,360.00,500.40,58.38,'2021-06-30 11:23:36'),(933582,'1','180',414,'Retail Sale Id 483636',0.00,954.00,360.00,1080.00,126.00,'2021-06-30 11:24:37'),(933591,'1','180',414,'Retail Sale Id 483646',0.00,3180.00,360.00,3600.00,420.00,'2021-06-30 11:25:51'),(933595,'1','180',414,'Retail Sale Id 483650',0.00,954.00,360.00,1080.00,126.00,'2021-06-30 11:26:48'),(933601,'1','180',414,'Retail Sale Id 483656',0.00,1908.00,360.00,2160.00,252.00,'2021-06-30 11:27:42'),(933606,'1','180',414,'Retail Sale Id 483660',0.00,1749.00,360.00,1980.00,231.00,'2021-06-30 11:28:47'),(933770,'1','180',414,'Retail Sale Id 483817',0.00,3532.98,360.00,3999.60,466.62,'2021-06-30 11:59:49'),(934334,'1','180',414,'Retail Sale Id 484404',0.00,1809.42,360.00,2048.40,238.98,'2021-06-30 13:38:01'),(934843,'1','180',414,'Retail Sale Id 484911',0.00,954.00,360.00,1080.00,126.00,'2021-06-30 14:40:41'),(934921,'1','180',414,'Retail Sale Id 484993',0.00,1908.00,360.00,2160.00,252.00,'2021-06-30 14:49:38'),(935464,'1','180',414,'Retail Sale Id 485533',0.00,954.00,360.00,1080.00,126.00,'2021-06-30 15:52:53'),(937169,'1','180',414,'Retail Sale Id 487239',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 09:11:36'),(937223,'1','180',414,'Retail Sale Id 487292',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 09:19:50'),(937232,'1','180',414,'Retail Sale Id 487299',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 09:21:13'),(937237,'1','180',414,'Retail Sale Id 487305',0.00,1590.00,360.00,1800.00,210.00,'2021-07-01 09:22:31'),(937686,'1','180',414,'Retail Sale Id 487741',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 10:35:56'),(937693,'1','180',414,'Retail Sale Id 487746',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 10:36:58'),(937850,'1','180',414,'Retail Sale Id 487923',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 11:13:50'),(938076,'1','180',414,'Retail Sale Id 488173',0.00,36888.00,332.00,38512.00,1624.00,'2021-07-01 12:00:43'),(938125,'1','180',414,'Retail Sale Id 488223',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 12:11:10'),(938172,'1','180',414,'Retail Sale Id 488268',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 12:20:25'),(938266,'1','180',414,'Retail Sale Id 488367',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 12:42:58'),(938340,'1','180',414,'Retail Sale Id 488442',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 12:59:08'),(938344,'1','180',414,'Retail Sale Id 488446',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 13:00:05'),(938700,'1','180',414,'Retail Sale Id 488845',0.00,3975.00,360.00,4500.00,525.00,'2021-07-01 14:04:34'),(938871,'1','180',414,'Retail Sale Id 489003',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 14:31:39'),(938885,'1','180',414,'Retail Sale Id 489019',0.00,7950.00,360.00,9000.00,1050.00,'2021-07-01 14:34:17'),(939289,'1','180',414,'Retail Sale Id 489451',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 15:37:31'),(939301,'1','180',414,'Retail Sale Id 489461',0.00,2544.00,360.00,2880.00,336.00,'2021-07-01 15:38:47'),(939312,'1','180',414,'Retail Sale Id 489473',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 15:39:56'),(939321,'1','180',414,'Retail Sale Id 489484',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 15:41:02'),(939573,'1','180',414,'Retail Sale Id 489778',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 16:09:39'),(939832,'1','180',414,'Retail Sale Id 490063',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 16:39:07'),(939937,'1','180',414,'Retail Sale Id 490182',0.00,954.00,360.00,1080.00,126.00,'2021-07-01 16:52:32'),(940063,'1','180',414,'Retail Sale Id 490324',0.00,1908.00,360.00,2160.00,252.00,'2021-07-01 17:15:10'),(940152,'1','180',414,'Retail Sale Id 490416',0.00,3975.00,360.00,4500.00,525.00,'2021-07-01 17:35:12'),(941348,'1','180',414,'Retail Sale Id 491683',0.00,954.00,380.00,1140.00,186.00,'2021-07-02 09:49:58'),(941417,'1','180',414,'Retail Sale Id 491753',0.00,3498.00,380.00,4180.00,682.00,'2021-07-02 10:03:46'),(941424,'1','180',414,'Retail Sale Id 491759',0.00,858.60,380.00,1026.00,167.40,'2021-07-02 10:05:25'),(941429,'1','180',414,'Retail Sale Id 491766',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 10:06:22'),(941442,'1','180',414,'Retail Sale Id 491773',0.00,2544.00,380.00,3040.00,496.00,'2021-07-02 10:07:58'),(941451,'1','180',414,'Retail Sale Id 491785',0.00,3975.00,380.00,4750.00,775.00,'2021-07-02 10:09:07'),(941492,'1','180',414,'Retail Sale Id 491830',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 10:17:12'),(941496,'1','180',414,'Retail Sale Id 491835',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 10:18:33'),(941503,'1','180',414,'Retail Sale Id 491842',0.00,3975.00,380.00,4750.00,775.00,'2021-07-02 10:19:45'),(941510,'1','180',414,'Retail Sale Id 491850',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 10:21:17'),(941521,'1','180',414,'Retail Sale Id 491858',0.00,19080.00,355.00,21300.00,2220.00,'2021-07-02 10:23:31'),(942014,'1','180',414,'Retail Sale Id 492238',0.00,1590.00,380.00,1900.00,310.00,'2021-07-02 11:27:41'),(942089,'1','180',414,'Retail Sale Id 492318',0.00,1590.00,380.00,1900.00,310.00,'2021-07-02 11:42:28'),(942111,'1','180',414,'Retail Sale Id 492344',0.00,1590.00,380.00,1900.00,310.00,'2021-07-02 11:47:33'),(942183,'1','180',414,'Retail Sale Id 492436',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 12:01:57'),(942194,'1','180',414,'Retail Sale Id 492450',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 12:04:21'),(942295,'1','180',414,'Retail Sale Id 492567',0.00,3975.00,380.00,4750.00,775.00,'2021-07-02 12:29:55'),(943541,'1','180',414,'Retail Sale Id 493975',0.00,3765.12,380.00,4499.20,734.08,'2021-07-02 16:22:43'),(943569,'1','180',414,'Retail Sale Id 494008',0.00,836.34,380.00,999.40,163.06,'2021-07-02 16:29:17'),(943603,'1','180',414,'Retail Sale Id 494044',0.00,836.34,380.00,999.40,163.06,'2021-07-02 16:40:04'),(943658,'1','180',414,'Retail Sale Id 494099',0.00,1590.00,380.00,1900.00,310.00,'2021-07-02 16:56:20'),(943664,'1','180',414,'Retail Sale Id 494106',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 16:57:14'),(943668,'1','180',414,'Retail Sale Id 494111',0.00,954.00,380.00,1140.00,186.00,'2021-07-02 16:58:19'),(943669,'1','180',414,'Retail Sale Id 494111',0.00,954.00,380.00,1140.00,186.00,'2021-07-02 16:58:19'),(943676,'1','180',414,'Retail Sale Id 494117',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 17:01:15'),(943686,'1','180',414,'Retail Sale Id 494128',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 17:02:53'),(943916,'1','180',414,'Retail Sale Id 494399',0.00,1908.00,380.00,2280.00,372.00,'2021-07-02 18:46:33'),(945021,'1','180',414,'Retail Sale Id 495408',0.00,3975.00,380.00,4750.00,775.00,'2021-07-03 10:41:01'),(945451,'1','180',414,'Retail Sale Id 495866',0.00,1590.00,380.00,1900.00,310.00,'2021-07-03 11:42:10'),(945835,'1','180',414,'Retail Sale Id 496327',0.00,1908.00,380.00,2280.00,372.00,'2021-07-03 12:30:29'),(946319,'1','180',414,'Retail Sale Id 496838',0.00,1908.00,380.00,2280.00,372.00,'2021-07-03 13:43:36'),(946388,'1','180',414,'Retail Sale Id 497025',0.00,1908.00,380.00,2280.00,372.00,'2021-07-03 13:56:19'),(947585,'1','180',414,'Retail Sale Id 498266',0.00,954.00,380.00,1140.00,186.00,'2021-07-03 16:44:10'),(947596,'1','180',414,'Retail Sale Id 498274',0.00,3180.00,380.00,3800.00,620.00,'2021-07-03 16:45:43'),(947612,'1','180',414,'Retail Sale Id 498294',0.00,1908.00,380.00,2280.00,372.00,'2021-07-03 16:47:37'),(947632,'1','180',414,'Retail Sale Id 498313',0.00,1672.68,380.00,1998.80,326.12,'2021-07-03 16:49:36'),(947685,'1','180',414,'Retail Sale Id 498394',0.00,1590.00,380.00,1900.00,310.00,'2021-07-03 16:57:13'),(948061,'1','180',414,'Retail Sale Id 498784',0.00,954.00,380.00,1140.00,186.00,'2021-07-03 18:49:36'),(948075,'1','180',414,'Retail Sale Id 498796',0.00,34980.00,355.00,39050.00,4070.00,'2021-07-03 18:56:54'),(952074,'1','180',414,'Retail Sale Id 502878',0.00,1908.00,380.00,2280.00,372.00,'2021-07-04 17:39:17'),(952083,'1','180',414,'Retail Sale Id 502887',0.00,19080.00,355.00,21300.00,2220.00,'2021-07-04 17:44:08'),(952089,'1','180',414,'Retail Sale Id 502893',0.00,1908.00,380.00,2280.00,372.00,'2021-07-04 17:48:04'),(952095,'1','180',414,'Retail Sale Id 502896',0.00,1590.00,380.00,1900.00,310.00,'2021-07-04 17:49:50'),(952101,'1','180',414,'Retail Sale Id 502901',0.00,954.00,380.00,1140.00,186.00,'2021-07-04 17:51:31'),(952132,'1','180',414,'Retail Sale Id 502930',0.00,954.00,380.00,1140.00,186.00,'2021-07-04 18:04:50'),(952135,'1','180',414,'Retail Sale Id 502935',0.00,795.00,380.00,950.00,155.00,'2021-07-04 18:06:30'),(952143,'1','180',414,'Retail Sale Id 502943',0.00,1749.00,380.00,2090.00,341.00,'2021-07-04 18:12:32'),(952145,'1','180',414,'Retail Sale Id 502945',0.00,954.00,380.00,1140.00,186.00,'2021-07-04 18:14:20'),(952148,'1','180',414,'Retail Sale Id 502948',0.00,2544.00,380.00,3040.00,496.00,'2021-07-04 18:16:01'),(952151,'1','180',414,'Retail Sale Id 502951',0.00,1908.00,380.00,2280.00,372.00,'2021-07-04 18:17:54'),(952155,'1','180',414,'Retail Sale Id 502955',0.00,1272.00,380.00,1520.00,248.00,'2021-07-04 18:19:23'),(952160,'1','180',414,'Retail Sale Id 502959',0.00,1908.00,380.00,2280.00,372.00,'2021-07-04 18:20:33'),(952192,'1','180',414,'Retail Sale Id 502973',0.00,1908.00,380.00,2280.00,372.00,'2021-07-04 18:47:05'),(952200,'1','180',414,'Retail Sale Id 502979',0.00,1272.00,380.00,1520.00,248.00,'2021-07-04 19:08:18'),(952741,'1','180',414,'Retail Sale Id 503456',0.00,1908.00,380.00,2280.00,372.00,'2021-07-05 07:57:41'),(952974,'1','180',414,'Retail Sale Id 503678',0.00,3975.00,380.00,4750.00,775.00,'2021-07-05 08:41:01'),(953001,'1','180',414,'Retail Sale Id 503700',0.00,3975.00,380.00,4750.00,775.00,'2021-07-05 08:45:06'),(953506,'1','180',414,'Retail Sale Id 504202',0.00,836.34,380.00,999.40,163.06,'2021-07-05 10:21:20'),(953515,'1','180',414,'Retail Sale Id 504209',0.00,19080.00,355.00,21300.00,2220.00,'2021-07-05 10:23:21'),(953867,'1','180',414,'Retail Sale Id 504628',0.00,1908.00,380.00,2280.00,372.00,'2021-07-05 11:34:26'),(954072,'1','180',414,'Retail Sale Id 504855',0.00,36888.00,355.00,41180.00,4292.00,'2021-07-05 12:15:06'),(955405,'1','180',414,'Retail Sale Id 506229',0.00,2862.00,380.00,3420.00,558.00,'2021-07-05 15:50:08'),(956152,'1','180',414,'Retail Sale Id 507078',0.00,1590.00,380.00,1900.00,310.00,'2021-07-05 17:36:49'),(956166,'1','180',414,'Retail Sale Id 507094',0.00,836.34,380.00,999.40,163.06,'2021-07-05 17:38:51'),(956191,'1','180',414,'Retail Sale Id 507117',0.00,1908.00,380.00,2280.00,372.00,'2021-07-05 17:43:41'),(956194,'1','180',414,'Retail Sale Id 507120',0.00,836.34,380.00,999.40,163.06,'2021-07-05 17:44:54'),(956297,'1','180',414,'Retail Sale Id 507223',0.00,3975.00,380.00,4750.00,775.00,'2021-07-05 18:41:23'),(956299,'1','180',414,'Retail Sale Id 507225',0.00,1908.00,380.00,2280.00,372.00,'2021-07-05 18:42:24'),(956709,'1','180',414,'Retail Sale Id 507619',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 08:11:15'),(956749,'1','180',414,'Retail Sale Id 507660',0.00,1908.00,380.00,2280.00,372.00,'2021-07-06 08:18:17'),(957390,'1','180',414,'Retail Sale Id 508355',0.00,1590.00,380.00,1900.00,310.00,'2021-07-06 10:11:58'),(957429,'1','180',414,'Retail Sale Id 508399',0.00,1256.10,380.00,1501.00,244.90,'2021-07-06 10:20:21'),(957902,'1','180',414,'Retail Sale Id 508933',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 11:55:19'),(960119,'1','180',414,'Retail Sale Id 511630',0.00,3975.00,380.00,4750.00,775.00,'2021-07-06 17:44:24'),(960131,'1','180',414,'Retail Sale Id 511640',0.00,2862.00,380.00,3420.00,558.00,'2021-07-06 17:47:41'),(960146,'1','180',414,'Retail Sale Id 511656',0.00,1908.00,380.00,2280.00,372.00,'2021-07-06 17:50:53'),(960160,'1','180',414,'Retail Sale Id 511665',0.00,1272.00,380.00,1520.00,248.00,'2021-07-06 17:53:54'),(960166,'1','180',414,'Retail Sale Id 511677',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 17:55:08'),(960175,'1','180',414,'Retail Sale Id 511684',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 17:57:55'),(960182,'1','180',414,'Retail Sale Id 511691',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 18:00:12'),(960195,'1','180',414,'Retail Sale Id 511703',0.00,1653.60,380.00,1976.00,322.40,'2021-07-06 18:03:26'),(960201,'1','180',414,'Retail Sale Id 511711',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 18:05:07'),(960284,'1','180',414,'Retail Sale Id 511790',0.00,954.00,380.00,1140.00,186.00,'2021-07-06 19:33:04'),(961855,'1','180',414,'Retail Sale Id 513611',0.00,954.00,380.00,1140.00,186.00,'2021-07-07 11:04:32'),(962010,'1','180',414,'Retail Sale Id 513765',0.00,1908.00,380.00,2280.00,372.00,'2021-07-07 11:34:19'),(964371,'1','180',414,'Retail Sale Id 516315',0.00,1908.00,380.00,2280.00,372.00,'2021-07-07 18:05:24'),(964375,'1','180',414,'Retail Sale Id 516320',0.00,1908.00,380.00,2280.00,372.00,'2021-07-07 18:07:21'),(964376,'1','180',414,'Retail Sale Id 516321',0.00,836.34,380.00,999.40,163.06,'2021-07-07 18:08:24'),(964378,'1','180',414,'Retail Sale Id 516322',0.00,3975.00,380.00,4750.00,775.00,'2021-07-07 18:09:48'),(964380,'1','180',414,'Retail Sale Id 516325',0.00,1590.00,380.00,1900.00,310.00,'2021-07-07 18:11:14'),(964381,'1','180',414,'Retail Sale Id 516326',0.00,795.00,380.00,950.00,155.00,'2021-07-07 18:12:24'),(964385,'1','180',414,'Retail Sale Id 516329',0.00,2226.00,380.00,2660.00,434.00,'2021-07-07 18:14:36'),(964388,'1','180',414,'Retail Sale Id 516332',0.00,795.00,380.00,950.00,155.00,'2021-07-07 18:18:07'),(964390,'1','180',414,'Retail Sale Id 516335',0.00,1908.00,380.00,2280.00,372.00,'2021-07-07 18:19:01'),(964393,'1','180',414,'Retail Sale Id 516338',0.00,19080.00,355.00,21300.00,2220.00,'2021-07-07 18:21:47'),(964417,'1','180',414,'Retail Sale Id 516370',0.00,795.00,380.00,950.00,155.00,'2021-07-07 18:54:30'),(964420,'1','180',414,'Retail Sale Id 516371',0.00,1672.68,380.00,1998.80,326.12,'2021-07-07 18:55:21'),(966024,'1','180',414,'Retail Sale Id 518106',0.00,55332.00,355.00,61770.00,6438.00,'2021-07-08 12:08:35'),(966047,'1','180',414,'Retail Sale Id 518132',0.00,954.00,400.00,1200.00,246.00,'2021-07-08 12:12:08'),(966094,'1','180',414,'Retail Sale Id 518187',0.00,1908.00,400.00,2400.00,492.00,'2021-07-08 12:19:10'),(967067,'1','180',414,'Retail Sale Id 519293',0.00,1908.00,400.00,2400.00,492.00,'2021-07-08 14:43:52'),(967073,'1','180',414,'Retail Sale Id 519300',0.00,954.00,400.00,1200.00,246.00,'2021-07-08 14:44:44'),(967087,'1','180',414,'Retail Sale Id 519315',0.00,3021.00,400.00,3800.00,779.00,'2021-07-08 14:46:11'),(967100,'1','180',414,'Retail Sale Id 519326',0.00,1908.00,400.00,2400.00,492.00,'2021-07-08 14:47:18'),(967109,'1','180',414,'Retail Sale Id 519332',0.00,1908.00,400.00,2400.00,492.00,'2021-07-08 14:48:09'),(967117,'1','180',414,'Retail Sale Id 519341',0.00,795.00,400.00,1000.00,205.00,'2021-07-08 14:49:03'),(967130,'1','180',414,'Retail Sale Id 519353',0.00,954.00,400.00,1200.00,246.00,'2021-07-08 14:50:58'),(967139,'1','180',414,'Retail Sale Id 519358',0.00,1908.00,400.00,2400.00,492.00,'2021-07-08 14:52:03'),(967148,'1','180',414,'Retail Sale Id 519365',0.00,1908.00,400.00,2400.00,492.00,'2021-07-08 14:53:21'),(967153,'1','180',414,'Retail Sale Id 519371',0.00,954.00,400.00,1200.00,246.00,'2021-07-08 14:54:19'),(968433,'1','180',414,'Retail Sale Id 520807',0.00,3816.00,400.00,4800.00,984.00,'2021-07-08 17:57:42'),(968453,'1','180',414,'Retail Sale Id 520831',0.00,954.00,400.00,1200.00,246.00,'2021-07-08 18:05:11'),(968461,'1','180',414,'Retail Sale Id 520841',0.00,954.00,400.00,1200.00,246.00,'2021-07-08 18:10:11'),(968464,'1','180',414,'Retail Sale Id 520844',0.00,636.00,400.00,800.00,164.00,'2021-07-08 18:11:43'),(969613,'1','180',414,'Retail Sale Id 522186',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 10:33:54'),(969620,'1','180',414,'Retail Sale Id 522240',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 10:35:39'),(969635,'1','180',414,'Retail Sale Id 522253',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 10:39:29'),(969646,'1','180',414,'Retail Sale Id 522270',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 10:42:04'),(969926,'1','180',414,'Retail Sale Id 522559',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 11:28:29'),(970020,'1','180',414,'Retail Sale Id 522671',0.00,1590.00,400.00,2000.00,410.00,'2021-07-09 11:44:53'),(970028,'1','180',414,'Retail Sale Id 522683',0.00,795.00,400.00,1000.00,205.00,'2021-07-09 11:46:05'),(970188,'1','180',414,'Retail Sale Id 522885',0.00,7950.00,400.00,10000.00,2050.00,'2021-07-09 12:16:08'),(970574,'1','180',414,'Retail Sale Id 523331',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 13:44:03'),(970592,'1','180',414,'Retail Sale Id 523347',0.00,2862.00,400.00,3600.00,738.00,'2021-07-09 13:45:55'),(970695,'1','180',414,'Retail Sale Id 523461',0.00,795.00,400.00,1000.00,205.00,'2021-07-09 13:58:00'),(970819,'1','180',414,'Retail Sale Id 523613',0.00,1908.00,400.00,2400.00,492.00,'2021-07-09 14:14:57'),(970856,'1','180',414,'Retail Sale Id 523650',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 14:18:55'),(970950,'1','180',414,'Retail Sale Id 523727',0.00,2862.00,400.00,3600.00,738.00,'2021-07-09 14:30:33'),(970983,'1','180',414,'Retail Sale Id 523779',0.00,397.50,400.00,500.00,102.50,'2021-07-09 14:34:03'),(971000,'1','180',414,'Retail Sale Id 523799',0.00,3180.00,400.00,4000.00,820.00,'2021-07-09 14:36:42'),(971521,'1','180',414,'Retail Sale Id 524360',0.00,1590.00,400.00,2000.00,410.00,'2021-07-09 15:57:30'),(971601,'1','180',414,'Retail Sale Id 524444',0.00,954.00,400.00,1200.00,246.00,'2021-07-09 16:11:18'),(971760,'1','180',414,'Retail Sale Id 524609',0.00,397.50,400.00,500.00,102.50,'2021-07-09 16:34:57'),(971818,'1','180',414,'Retail Sale Id 524676',0.00,1908.00,400.00,2400.00,492.00,'2021-07-09 16:43:40'),(972140,'1','180',414,'Retail Sale Id 525012',0.00,1908.00,400.00,2400.00,492.00,'2021-07-09 17:50:27'),(972195,'1','180',414,'Retail Sale Id 525064',0.00,1908.00,400.00,2400.00,492.00,'2021-07-09 18:28:25'),(972199,'1','180',414,'Retail Sale Id 525068',0.00,85860.00,376.00,101520.00,15660.00,'2021-07-09 18:36:29'),(972203,'1','180',414,'Retail Sale Id 525070',0.00,19080.00,376.00,22560.00,3480.00,'2021-07-09 18:37:48'),(973425,'1','180',414,'Retail Sale Id 526397',0.00,2385.00,400.00,3000.00,615.00,'2021-07-10 09:08:18'),(973440,'1','180',414,'Retail Sale Id 526415',0.00,397.50,400.00,500.00,102.50,'2021-07-10 09:09:59'),(973441,'1','180',414,'Retail Sale Id 526415',0.00,1590.00,400.00,2000.00,410.00,'2021-07-10 09:09:59'),(973451,'1','180',414,'Retail Sale Id 526427',0.00,3975.00,400.00,5000.00,1025.00,'2021-07-10 09:11:48'),(973621,'1','180',414,'Retail Sale Id 526611',0.00,954.00,400.00,1200.00,246.00,'2021-07-10 09:34:49'),(973876,'1','180',414,'Retail Sale Id 526874',0.00,954.00,400.00,1200.00,246.00,'2021-07-10 10:14:37'),(974541,'1','180',414,'Retail Sale Id 527667',0.00,1590.00,400.00,2000.00,410.00,'2021-07-10 11:47:24'),(974564,'1','180',414,'Retail Sale Id 527695',0.00,1908.00,400.00,2400.00,492.00,'2021-07-10 11:50:46'),(974792,'1','180',414,'Retail Sale Id 527956',0.00,954.00,400.00,1200.00,246.00,'2021-07-10 12:22:38'),(975334,'1','180',414,'Retail Sale Id 528505',0.00,1908.00,400.00,2400.00,492.00,'2021-07-10 13:37:51'),(975376,'1','180',414,'Retail Sale Id 528545',0.00,954.00,400.00,1200.00,246.00,'2021-07-10 13:45:21'),(975401,'1','180',414,'Retail Sale Id 528571',0.00,1908.00,400.00,2400.00,492.00,'2021-07-10 13:49:41'),(975537,'1','180',414,'Retail Sale Id 528704',0.00,1908.00,400.00,2400.00,492.00,'2021-07-10 14:15:45'),(975650,'1','180',414,'Retail Sale Id 528834',0.00,3180.00,400.00,4000.00,820.00,'2021-07-10 14:34:37'),(975655,'1','180',414,'Retail Sale Id 528843',0.00,2862.00,400.00,3600.00,738.00,'2021-07-10 14:35:38'),(975716,'1','180',414,'Retail Sale Id 528917',0.00,1908.00,400.00,2400.00,492.00,'2021-07-10 14:45:18'),(975822,'1','180',414,'Retail Sale Id 529032',0.00,636.00,400.00,800.00,164.00,'2021-07-10 15:01:34'),(976137,'1','180',414,'Retail Sale Id 529376',0.00,636.00,400.00,800.00,164.00,'2021-07-10 15:54:34'),(976567,'1','180',414,'Retail Sale Id 529844',0.00,1908.00,400.00,2400.00,492.00,'2021-07-10 16:51:00'),(976684,'1','180',414,'Retail Sale Id 529964',0.00,3975.00,400.00,5000.00,1025.00,'2021-07-10 17:10:04'),(976772,'1','180',414,'Retail Sale Id 530056',0.00,954.00,400.00,1200.00,246.00,'2021-07-10 17:33:05'),(976850,'1','180',414,'Retail Sale Id 530138',0.00,4452.00,400.00,5600.00,1148.00,'2021-07-10 18:54:40'),(978295,'1','180',414,'Retail Sale Id 531738',0.00,19080.00,376.00,22560.00,3480.00,'2021-07-11 10:20:35'),(978311,'1','180',414,'Retail Sale Id 531757',0.00,36888.00,376.00,43616.00,6728.00,'2021-07-11 10:23:04'),(978343,'1','180',414,'Retail Sale Id 531790',0.00,1908.00,400.00,2400.00,492.00,'2021-07-11 10:27:41'),(978426,'1','180',414,'Retail Sale Id 531900',0.00,954.00,400.00,1200.00,246.00,'2021-07-11 10:42:50'),(978442,'1','180',414,'Retail Sale Id 531919',0.00,556.50,400.00,700.00,143.50,'2021-07-11 10:45:24'),(978467,'1','180',414,'Retail Sale Id 531949',0.00,954.00,400.00,1200.00,246.00,'2021-07-11 10:49:39'),(978491,'1','180',414,'Retail Sale Id 531976',0.00,1590.00,400.00,2000.00,410.00,'2021-07-11 10:53:05'),(978506,'1','180',414,'Retail Sale Id 531988',0.00,954.00,400.00,1200.00,246.00,'2021-07-11 10:55:53'),(980079,'1','180',414,'Retail Sale Id 533733',0.00,1908.00,400.00,2400.00,492.00,'2021-07-11 15:27:06'),(980977,'1','180',414,'Retail Sale Id 531958',0.00,954.00,400.00,1200.00,246.00,'2021-07-11 18:45:50'),(980978,'1','180',414,'Retail Sale Id 534648',0.00,5406.00,400.00,6800.00,1394.00,'2021-07-11 18:47:09'),(980979,'1','180',414,'Retail Sale Id 534649',0.00,3498.00,400.00,4400.00,902.00,'2021-07-11 18:48:27'),(980980,'1','180',414,'Retail Sale Id 534650',0.00,73776.00,376.00,87232.00,13456.00,'2021-07-11 18:54:19'),(980982,'1','180',414,'Retail Sale Id 534652',0.00,18444.00,376.00,21808.00,3364.00,'2021-07-11 18:55:48'),(980983,'1','180',414,'Retail Sale Id 534653',0.00,19080.00,376.00,22560.00,3480.00,'2021-07-11 18:57:24'),(983800,'1','180',414,'Retail Sale Id 537606',0.00,636.00,420.00,840.00,204.00,'2021-07-12 16:21:35'),(983810,'1','180',414,'Retail Sale Id 537617',0.00,1494.60,420.00,1974.00,479.40,'2021-07-12 16:22:53'),(983816,'1','180',414,'Retail Sale Id 537626',0.00,1513.68,420.00,1999.20,485.52,'2021-07-12 16:23:50'),(983867,'1','180',414,'Retail Sale Id 537682',0.00,954.00,420.00,1260.00,306.00,'2021-07-12 16:33:42'),(983901,'1','180',414,'Retail Sale Id 537720',0.00,1908.00,420.00,2520.00,612.00,'2021-07-12 16:38:25'),(984060,'1','180',414,'Retail Sale Id 537932',0.00,2544.00,420.00,3360.00,816.00,'2021-07-12 17:18:58'),(984109,'1','180',414,'Retail Sale Id 537996',0.00,1908.00,420.00,2520.00,612.00,'2021-07-12 17:38:59'),(984113,'1','180',414,'Retail Sale Id 538002',0.00,1666.32,420.00,2200.80,534.48,'2021-07-12 17:40:40'),(984119,'1','180',414,'Retail Sale Id 538012',0.00,2703.00,420.00,3570.00,867.00,'2021-07-12 17:42:05'),(984128,'1','180',414,'Retail Sale Id 538024',0.00,1272.00,420.00,1680.00,408.00,'2021-07-12 17:44:34'),(984131,'1','180',414,'Retail Sale Id 538027',0.00,1513.68,420.00,1999.20,485.52,'2021-07-12 17:46:14'),(984139,'1','180',414,'Retail Sale Id 538034',0.00,1908.00,420.00,2520.00,612.00,'2021-07-12 17:48:51'),(985826,'1','180',414,'Retail Sale Id 539929',0.00,2544.00,420.00,3360.00,816.00,'2021-07-13 11:31:01'),(985833,'1','180',414,'Retail Sale Id 539934',0.00,3816.00,420.00,5040.00,1224.00,'2021-07-13 11:32:45'),(985847,'1','180',414,'Retail Sale Id 539946',0.00,3816.00,420.00,5040.00,1224.00,'2021-07-13 11:34:08'),(985860,'1','180',414,'Retail Sale Id 539957',0.00,3816.00,420.00,5040.00,1224.00,'2021-07-13 11:35:41'),(985870,'1','180',414,'Retail Sale Id 539965',0.00,954.00,420.00,1260.00,306.00,'2021-07-13 11:37:17'),(985883,'1','180',414,'Retail Sale Id 539979',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 11:38:52'),(985889,'1','180',414,'Retail Sale Id 539986',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 11:40:07'),(985920,'1','180',414,'Retail Sale Id 540023',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 11:47:41'),(986020,'1','180',414,'Retail Sale Id 540127',0.00,3975.00,420.00,5250.00,1275.00,'2021-07-13 12:08:32'),(986070,'1','180',414,'Retail Sale Id 540196',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 12:20:36'),(986559,'1','180',414,'Retail Sale Id 540743',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 14:01:32'),(986828,'1','180',414,'Retail Sale Id 541018',0.00,3180.00,420.00,4200.00,1020.00,'2021-07-13 14:53:46'),(986844,'1','180',414,'Retail Sale Id 541035',0.00,1908.00,420.00,2520.00,612.00,'2021-07-13 14:57:38'),(987092,'1','180',414,'Retail Sale Id 541305',0.00,1272.00,420.00,1680.00,408.00,'2021-07-13 15:43:17'),(987135,'1','180',414,'Retail Sale Id 541357',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 15:51:49'),(987530,'1','180',414,'Retail Sale Id 541833',0.00,954.00,420.00,1260.00,306.00,'2021-07-13 16:52:29'),(987558,'1','180',414,'Retail Sale Id 541857',0.00,954.00,420.00,1260.00,306.00,'2021-07-13 16:55:51'),(987598,'1','180',414,'Retail Sale Id 541900',0.00,756.84,420.00,999.60,242.76,'2021-07-13 17:01:07'),(987624,'1','180',414,'Retail Sale Id 541928',0.00,954.00,420.00,1260.00,306.00,'2021-07-13 17:05:43'),(987928,'1','180',414,'Retail Sale Id 542279',0.00,1590.00,420.00,2100.00,510.00,'2021-07-13 18:39:58'),(989088,'1','180',414,'Retail Sale Id 543527',0.00,1513.68,420.00,1999.20,485.52,'2021-07-14 09:48:39'),(989096,'1','180',414,'Retail Sale Id 543533',0.00,1513.68,420.00,1999.20,485.52,'2021-07-14 09:49:43'),(989225,'1','180',414,'Retail Sale Id 543706',0.00,3975.00,420.00,5250.00,1275.00,'2021-07-14 10:10:58'),(989244,'1','180',414,'Retail Sale Id 543731',0.00,1590.00,420.00,2100.00,510.00,'2021-07-14 10:15:40'),(989638,'1','180',414,'Retail Sale Id 544207',0.00,954.00,420.00,1260.00,306.00,'2021-07-14 11:34:45'),(990226,'1','180',414,'Retail Sale Id 544934',0.00,20988.00,382.00,25212.00,4224.00,'2021-07-14 13:39:54'),(991259,'1','180',414,'Retail Sale Id 546091',0.00,3180.00,420.00,4200.00,1020.00,'2021-07-14 17:21:12'),(991262,'1','180',414,'Retail Sale Id 546095',0.00,36888.00,382.00,44312.00,7424.00,'2021-07-14 17:23:27'),(991263,'1','180',414,'Retail Sale Id 546096',0.00,1908.00,420.00,2520.00,612.00,'2021-07-14 17:24:37'),(991265,'1','180',414,'Retail Sale Id 546098',0.00,954.00,420.00,1260.00,306.00,'2021-07-14 17:25:38'),(991295,'1','180',414,'Retail Sale Id 546140',0.00,1908.00,420.00,2520.00,612.00,'2021-07-14 17:45:02'),(992943,'1','180',414,'Retail Sale Id 547947',0.00,1590.00,420.00,2100.00,510.00,'2021-07-15 12:52:54'),(992948,'1','180',414,'Retail Sale Id 547952',0.00,1908.00,420.00,2520.00,612.00,'2021-07-15 12:54:19'),(992960,'1','180',414,'Retail Sale Id 547971',0.00,954.00,420.00,1260.00,306.00,'2021-07-15 12:56:19'),(992964,'1','180',414,'Retail Sale Id 547981',0.00,756.84,420.00,999.60,242.76,'2021-07-15 12:57:29'),(992968,'1','180',414,'Retail Sale Id 547984',0.00,1590.00,420.00,2100.00,510.00,'2021-07-15 12:58:20'),(992973,'1','180',414,'Retail Sale Id 547998',0.00,1590.00,420.00,2100.00,510.00,'2021-07-15 12:59:15'),(992979,'1','180',414,'Retail Sale Id 548007',0.00,833.16,420.00,1100.40,267.24,'2021-07-15 13:00:30'),(992984,'1','180',414,'Retail Sale Id 548013',0.00,2544.00,420.00,3360.00,816.00,'2021-07-15 13:02:28'),(992987,'1','180',414,'Retail Sale Id 548018',0.00,3180.00,420.00,4200.00,1020.00,'2021-07-15 13:04:11'),(992994,'1','180',414,'Retail Sale Id 548030',0.00,954.00,420.00,1260.00,306.00,'2021-07-15 13:05:04'),(993004,'1','180',414,'Retail Sale Id 548048',0.00,18444.00,382.00,22156.00,3712.00,'2021-07-15 13:06:43'),(994127,'1','180',414,'Retail Sale Id 549364',0.00,4070.40,420.00,5376.00,1305.60,'2021-07-15 16:55:50'),(994135,'1','180',414,'Retail Sale Id 549371',0.00,3180.00,420.00,4200.00,1020.00,'2021-07-15 16:57:08'),(994142,'1','180',414,'Retail Sale Id 549379',0.00,3975.00,420.00,5250.00,1275.00,'2021-07-15 16:58:41'),(994150,'1','180',414,'Retail Sale Id 549386',0.00,3975.00,420.00,5250.00,1275.00,'2021-07-15 16:59:57'),(994156,'1','180',414,'Retail Sale Id 549394',0.00,3975.00,420.00,5250.00,1275.00,'2021-07-15 17:01:13'),(994162,'1','180',414,'Retail Sale Id 549401',0.00,1908.00,420.00,2520.00,612.00,'2021-07-15 17:02:16'),(994202,'1','180',414,'Retail Sale Id 549457',0.00,954.00,420.00,1260.00,306.00,'2021-07-15 17:08:39'),(994337,'1','180',414,'Retail Sale Id 549641',0.00,909.48,420.00,1201.20,291.72,'2021-07-15 17:41:29'),(994341,'1','180',414,'Retail Sale Id 549651',0.00,756.84,420.00,999.60,242.76,'2021-07-15 17:42:15'),(994378,'1','180',414,'Retail Sale Id 549694',0.00,1908.00,420.00,2520.00,612.00,'2021-07-15 17:57:58'),(994461,'1','180',414,'Retail Sale Id 548009',0.00,1908.00,420.00,2520.00,612.00,'2021-07-15 18:46:47'),(997803,'1','180',414,'Retail Sale Id 553509',0.00,2544.00,420.00,3360.00,816.00,'2021-07-16 17:25:15'),(997805,'1','180',414,'Retail Sale Id 553511',0.00,1590.00,420.00,2100.00,510.00,'2021-07-16 17:26:14'),(997813,'1','180',414,'Retail Sale Id 553515',0.00,2862.00,420.00,3780.00,918.00,'2021-07-16 17:27:57'),(997815,'1','180',414,'Retail Sale Id 553518',0.00,2432.70,420.00,3213.00,780.30,'2021-07-16 17:28:59'),(997821,'1','180',414,'Retail Sale Id 553522',0.00,19080.00,382.00,22920.00,3840.00,'2021-07-16 17:30:13'),(997827,'1','180',414,'Retail Sale Id 553526',0.00,3975.00,420.00,5250.00,1275.00,'2021-07-16 17:33:03'),(997832,'1','180',414,'Retail Sale Id 553528',0.00,1908.00,420.00,2520.00,612.00,'2021-07-16 17:34:14'),(997839,'1','180',414,'Retail Sale Id 553536',0.00,3816.00,420.00,5040.00,1224.00,'2021-07-16 17:35:20'),(997845,'1','180',414,'Retail Sale Id 553540',0.00,3180.00,420.00,4200.00,1020.00,'2021-07-16 17:36:47'),(997848,'1','180',414,'Retail Sale Id 553543',0.00,954.00,420.00,1260.00,306.00,'2021-07-16 17:37:45'),(997989,'1','180',414,'Retail Sale Id 553672',0.00,1590.00,420.00,2100.00,510.00,'2021-07-16 20:01:15'),(997990,'1','180',414,'Retail Sale Id 553673',0.00,2862.00,420.00,3780.00,918.00,'2021-07-16 20:02:07'),(1002283,'1','180',414,'Retail Sale Id 558630',0.00,954.00,420.00,1260.00,306.00,'2021-07-17 17:58:29'),(1002287,'1','180',414,'Retail Sale Id 558640',0.00,954.00,420.00,1260.00,306.00,'2021-07-17 17:59:43'),(1002292,'1','180',414,'Retail Sale Id 558646',0.00,1590.00,420.00,2100.00,510.00,'2021-07-17 18:02:08'),(1002295,'1','180',414,'Retail Sale Id 558649',0.00,1908.00,420.00,2520.00,612.00,'2021-07-17 18:03:27'),(1002297,'1','180',414,'Retail Sale Id 558651',0.00,795.00,420.00,1050.00,255.00,'2021-07-17 18:04:39'),(1004534,'1','180',414,'Sale Id 306169',0.00,181829.22,322.00,184116.38,2287.16,'2021-07-18 12:54:11'),(1004585,'1','180',414,'Sale Id 306172',0.00,161235.54,332.00,168333.96,7098.42,'2021-07-18 13:01:58'),(1004649,'1','180',414,'Sale Id 306173',0.00,164406.00,332.00,171644.00,7238.00,'2021-07-18 13:11:08'),(1004746,'1','180',414,'Retail Sale Id 561520',0.00,4775.00,420.00,5250.00,475.00,'2021-07-18 13:26:49'),(1004758,'1','180',414,'Retail Sale Id 561531',0.00,4775.00,420.00,5250.00,475.00,'2021-07-18 13:28:14'),(1004774,'1','180',414,'Retail Sale Id 561546',0.00,4775.00,420.00,5250.00,475.00,'2021-07-18 13:30:57'),(1004790,'1','180',414,'Retail Sale Id 561561',0.00,4775.00,420.00,5250.00,475.00,'2021-07-18 13:32:49'),(1004802,'1','180',414,'Retail Sale Id 561587',0.00,4584.00,420.00,5040.00,456.00,'2021-07-18 13:34:28'),(1004830,'1','180',414,'Retail Sale Id 561615',0.00,3820.00,420.00,4200.00,380.00,'2021-07-18 13:37:11'),(1004840,'1','180',414,'Retail Sale Id 561625',0.00,3820.00,420.00,4200.00,380.00,'2021-07-18 13:38:36'),(1004857,'1','180',414,'Retail Sale Id 561642',0.00,1146.00,420.00,1260.00,114.00,'2021-07-18 13:40:27'),(1004876,'1','180',414,'Retail Sale Id 561660',0.00,1146.00,420.00,1260.00,114.00,'2021-07-18 13:42:57'),(1004938,'1','180',414,'Retail Sale Id 561745',0.00,1146.00,420.00,1260.00,114.00,'2021-07-18 13:52:12'),(1004947,'1','180',414,'Retail Sale Id 561757',0.00,66468.00,382.00,66468.00,0.00,'2021-07-18 13:53:57'),(1004954,'1','180',414,'Retail Sale Id 561767',0.00,7067.00,420.00,7770.00,703.00,'2021-07-18 13:54:50'),(1004961,'1','180',414,'Retail Sale Id 561778',0.00,3056.00,420.00,3360.00,304.00,'2021-07-18 13:56:05'),(1004966,'1','180',414,'Retail Sale Id 561790',0.00,1910.00,420.00,2100.00,190.00,'2021-07-18 13:57:07'),(1004972,'1','180',414,'Retail Sale Id 561797',0.00,4584.00,420.00,5040.00,456.00,'2021-07-18 13:58:02'),(1004981,'1','180',414,'Retail Sale Id 561806',0.00,4927.80,420.00,5418.00,490.20,'2021-07-18 13:59:42'),(1004986,'1','180',414,'Retail Sale Id 561814',0.00,5730.00,420.00,6300.00,570.00,'2021-07-18 14:00:33'),(1004993,'1','180',414,'Retail Sale Id 561821',0.00,22920.00,382.00,22920.00,0.00,'2021-07-18 14:01:40'),(1005072,'1','180',414,'Retail Sale Id 561905',0.00,4053.02,424.00,4498.64,445.62,'2021-07-18 14:19:17'),(1005093,'1','180',414,'Retail Sale Id 561922',0.00,2292.00,424.00,2544.00,252.00,'2021-07-18 14:22:43'),(1005433,'1','180',414,'Retail Sale Id 562278',0.00,1146.00,424.00,1272.00,126.00,'2021-07-18 15:27:17'),(1005447,'1','180',414,'Retail Sale Id 562291',0.00,2292.00,424.00,2544.00,252.00,'2021-07-18 15:29:22'),(1005479,'1','180',414,'Retail Sale Id 562318',0.00,22156.00,395.00,22910.00,754.00,'2021-07-18 15:33:20'),(1005621,'1','180',414,'Retail Sale Id 562464',0.00,1146.00,424.00,1272.00,126.00,'2021-07-18 15:55:37'),(1005745,'1','180',414,'Retail Sale Id 562591',0.00,1146.00,424.00,1272.00,126.00,'2021-07-18 16:15:38'),(1005761,'1','180',414,'Retail Sale Id 562611',0.00,4775.00,424.00,5300.00,525.00,'2021-07-18 16:20:13'),(1006105,'1','180',414,'Retail Sale Id 563010',0.00,1081.06,424.00,1199.92,118.86,'2021-07-18 17:48:27'),(1006106,'1','180',414,'Retail Sale Id 563010',0.00,1081.06,424.00,1199.92,118.86,'2021-07-18 17:48:27'),(1006109,'1','180',414,'Retail Sale Id 563015',0.00,1081.06,424.00,1199.92,118.86,'2021-07-18 17:49:18'),(1006144,'1','180',414,'Retail Sale Id 563051',0.00,2292.00,424.00,2544.00,252.00,'2021-07-18 18:15:07'),(1006193,'1','180',414,'Retail Sale Id 563095',0.00,42020.00,395.00,43450.00,1430.00,'2021-07-18 19:03:06'),(1010191,'1','180',414,'Retail Sale Id 567554',0.00,32470.00,395.00,33575.00,1105.00,'2021-07-19 21:33:13'),(1010194,'1','180',414,'Retail Sale Id 567555',0.00,3820.00,424.00,4240.00,420.00,'2021-07-19 21:34:58'),(1010197,'1','180',414,'Retail Sale Id 567556',0.00,4775.00,424.00,5300.00,525.00,'2021-07-19 21:36:15'),(1010200,'1','180',414,'Retail Sale Id 567557',0.00,4584.00,424.00,5088.00,504.00,'2021-07-19 21:37:29'),(1010201,'1','180',414,'Retail Sale Id 567558',0.00,1910.00,424.00,2120.00,210.00,'2021-07-19 21:38:41'),(1010202,'1','180',414,'Retail Sale Id 567559',0.00,4584.00,424.00,5088.00,504.00,'2021-07-19 21:41:29'),(1010203,'1','180',414,'Retail Sale Id 567560',0.00,4775.00,424.00,5300.00,525.00,'2021-07-19 21:42:29'),(1010206,'1','180',414,'Retail Sale Id 567561',0.00,2674.00,424.00,2968.00,294.00,'2021-07-19 21:44:04'),(1010207,'1','180',414,'Retail Sale Id 567562',0.00,7258.00,424.00,8056.00,798.00,'2021-07-19 21:45:17'),(1010210,'1','180',414,'Retail Sale Id 567563',0.00,4584.00,424.00,5088.00,504.00,'2021-07-19 21:46:09'),(1010211,'1','180',414,'Retail Sale Id 567564',0.00,4584.00,424.00,5088.00,504.00,'2021-07-19 21:47:16'),(1010214,'1','180',414,'Retail Sale Id 567565',0.00,2292.00,424.00,2544.00,252.00,'2021-07-19 21:48:43'),(1010215,'1','180',414,'Retail Sale Id 567566',0.00,2062.80,424.00,2289.60,226.80,'2021-07-19 21:49:58'),(1010216,'1','180',414,'Retail Sale Id 567567',0.00,4316.60,424.00,4791.20,474.60,'2021-07-19 21:51:32'),(1010217,'1','180',414,'Retail Sale Id 567568',0.00,7640.00,424.00,8480.00,840.00,'2021-07-19 21:52:44'),(1010218,'1','180',414,'Retail Sale Id 567569',0.00,4584.00,424.00,5088.00,504.00,'2021-07-19 21:54:02'),(1010219,'1','180',414,'Retail Sale Id 567570',0.00,4698.60,424.00,5215.20,516.60,'2021-07-19 21:55:34'),(1010220,'1','180',414,'Retail Sale Id 567571',0.00,4775.00,424.00,5300.00,525.00,'2021-07-19 21:56:36'),(1010221,'1','180',414,'Retail Sale Id 567572',0.00,4584.00,424.00,5088.00,504.00,'2021-07-19 21:57:46'),(1010222,'1','180',414,'Retail Sale Id 567573',0.00,1719.00,424.00,1908.00,189.00,'2021-07-19 21:58:50'),(1010223,'1','180',414,'Retail Sale Id 567574',0.00,3208.80,424.00,3561.60,352.80,'2021-07-19 22:00:07'),(1010224,'1','180',414,'Retail Sale Id 567575',0.00,9168.00,424.00,10176.00,1008.00,'2021-07-19 22:01:00'),(1010225,'1','180',414,'Retail Sale Id 567576',0.00,22156.00,395.00,22910.00,754.00,'2021-07-19 22:02:01'),(1012536,'1','180',414,'Retail Sale Id 570292',0.00,2292.00,424.00,2544.00,252.00,'2021-07-20 21:31:44'),(1012537,'1','180',414,'Retail Sale Id 570293',0.00,4584.00,424.00,5088.00,504.00,'2021-07-20 21:32:37'),(1012538,'1','180',414,'Retail Sale Id 570294',0.00,3056.00,424.00,3392.00,336.00,'2021-07-20 21:33:28'),(1012539,'1','180',414,'Retail Sale Id 570295',0.00,4584.00,424.00,5088.00,504.00,'2021-07-20 21:34:34'),(1012540,'1','180',414,'Retail Sale Id 570296',0.00,1146.00,424.00,1272.00,126.00,'2021-07-20 21:35:27'),(1012543,'1','180',414,'Retail Sale Id 570297',0.00,1146.00,424.00,1272.00,126.00,'2021-07-20 21:36:16'),(1012546,'1','180',414,'Retail Sale Id 570298',0.00,2483.00,424.00,2756.00,273.00,'2021-07-20 21:37:11'),(1016003,'1','180',414,'Retail Sale Id 573879',0.00,4584.00,424.00,5088.00,504.00,'2021-07-21 18:47:25'),(1016004,'1','180',414,'Retail Sale Id 573880',0.00,4775.00,424.00,5300.00,525.00,'2021-07-21 18:49:33'),(1016005,'1','180',414,'Retail Sale Id 573881',0.00,4775.00,424.00,5300.00,525.00,'2021-07-21 18:50:18'),(1016006,'1','180',414,'Retail Sale Id 573882',0.00,1910.00,424.00,2120.00,210.00,'2021-07-21 18:51:40'),(1016007,'1','180',414,'Retail Sale Id 573883',0.00,1910.00,424.00,2120.00,210.00,'2021-07-21 18:53:31'),(1016009,'1','180',414,'Retail Sale Id 573885',0.00,1910.00,424.00,2120.00,210.00,'2021-07-21 18:57:49'),(1016010,'1','180',414,'Retail Sale Id 573886',0.00,2292.00,424.00,2544.00,252.00,'2021-07-21 18:59:15'),(1016013,'1','180',414,'Retail Sale Id 573887',0.00,3438.00,424.00,3816.00,378.00,'2021-07-21 19:00:58'),(1016014,'1','180',414,'Retail Sale Id 573888',0.00,2292.00,424.00,2544.00,252.00,'2021-07-21 19:01:50'),(1016017,'1','180',414,'Retail Sale Id 573889',0.00,4660.40,424.00,5172.80,512.40,'2021-07-21 19:02:47'),(1018977,'1','180',414,'Retail Sale Id 577010',0.00,4775.00,424.00,5300.00,525.00,'2021-07-22 20:00:14'),(1018979,'1','180',414,'Retail Sale Id 577013',0.00,22920.00,395.00,23700.00,780.00,'2021-07-22 20:02:55'),(1018980,'1','180',414,'Retail Sale Id 577016',0.00,4584.00,424.00,5088.00,504.00,'2021-07-22 20:05:34'),(1018981,'1','180',414,'Retail Sale Id 577017',0.00,2292.00,424.00,2544.00,252.00,'2021-07-22 20:09:53'),(1018982,'1','180',414,'Retail Sale Id 577018',0.00,840.40,424.00,932.80,92.40,'2021-07-22 20:13:12'),(1018983,'1','180',414,'Retail Sale Id 577019',0.00,3629.00,424.00,4028.00,399.00,'2021-07-22 20:14:34'),(1018984,'1','180',414,'Retail Sale Id 577020',0.00,4660.40,424.00,5172.80,512.40,'2021-07-22 20:17:02'),(1018985,'1','180',414,'Retail Sale Id 577021',0.00,1910.00,424.00,2120.00,210.00,'2021-07-22 20:18:15'),(1018986,'1','180',414,'Retail Sale Id 577022',0.00,3056.00,424.00,3392.00,336.00,'2021-07-22 20:20:48'),(1022257,'1','180',414,'Retail Sale Id 580521',0.00,1146.00,424.00,1272.00,126.00,'2021-07-23 20:08:31'),(1022258,'1','180',414,'Retail Sale Id 580522',0.00,2292.00,424.00,2544.00,252.00,'2021-07-23 20:09:23'),(1022259,'1','180',414,'Retail Sale Id 580523',0.00,2292.00,424.00,2544.00,252.00,'2021-07-23 20:10:37'),(1022260,'1','180',414,'Retail Sale Id 580524',0.00,2292.00,424.00,2544.00,252.00,'2021-07-23 20:11:41'),(1022261,'1','180',414,'Retail Sale Id 580525',0.00,3820.00,424.00,4240.00,420.00,'2021-07-23 20:13:01'),(1022262,'1','180',414,'Retail Sale Id 580526',0.00,4584.00,424.00,5088.00,504.00,'2021-07-23 20:13:57'),(1022263,'1','180',414,'Retail Sale Id 580527',0.00,955.00,424.00,1060.00,105.00,'2021-07-23 20:17:08'),(1022264,'1','180',414,'Retail Sale Id 580528',0.00,1375.20,424.00,1526.40,151.20,'2021-07-23 20:19:55'),(1022265,'1','180',414,'Retail Sale Id 580529',0.00,1719.00,424.00,1908.00,189.00,'2021-07-23 20:24:21'),(1022268,'1','180',414,'Retail Sale Id 580530',0.00,2521.20,424.00,2798.40,277.20,'2021-07-23 20:26:16'),(1022269,'1','180',414,'Retail Sale Id 580531',0.00,1337.00,424.00,1484.00,147.00,'2021-07-23 20:28:18'),(1022272,'1','180',414,'Retail Sale Id 580532',0.00,1031.40,424.00,1144.80,113.40,'2021-07-23 20:29:06'),(1025751,'1','180',414,'Retail Sale Id 584365',0.00,22920.00,395.00,23700.00,780.00,'2021-07-24 20:47:47'),(1025759,'1','180',414,'Retail Sale Id 584366',0.00,110780.00,395.00,114550.00,3770.00,'2021-07-24 20:52:51'),(1025761,'1','180',414,'Retail Sale Id 584367',0.00,4202.00,424.00,4664.00,462.00,'2021-07-24 20:53:48'),(1025765,'1','180',414,'Retail Sale Id 584368',0.00,2215.60,424.00,2459.20,243.60,'2021-07-24 20:54:52'),(1025767,'1','180',414,'Retail Sale Id 584369',0.00,1910.00,424.00,2120.00,210.00,'2021-07-24 20:55:53'),(1025770,'1','180',414,'Retail Sale Id 584370',0.00,4584.00,424.00,5088.00,504.00,'2021-07-24 20:56:43'),(1025772,'1','180',414,'Retail Sale Id 584371',0.00,4584.00,424.00,5088.00,504.00,'2021-07-24 20:57:17'),(1025775,'1','180',414,'Retail Sale Id 584372',0.00,2292.00,424.00,2544.00,252.00,'2021-07-24 20:58:11'),(1025778,'1','180',414,'Retail Sale Id 584373',0.00,2292.00,424.00,2544.00,252.00,'2021-07-24 20:58:55'),(1025781,'1','180',414,'Retail Sale Id 584375',0.00,2521.20,424.00,2798.40,277.20,'2021-07-24 21:00:13'),(1025783,'1','180',414,'Retail Sale Id 584377',0.00,3820.00,424.00,4240.00,420.00,'2021-07-24 21:01:10'),(1025785,'1','180',414,'Retail Sale Id 584379',0.00,1833.60,424.00,2035.20,201.60,'2021-07-24 21:01:52'),(1028871,'1','180',414,'Retail Sale Id 587670',0.00,4775.00,424.00,5300.00,525.00,'2021-07-25 20:01:32'),(1028872,'1','180',414,'Retail Sale Id 587671',0.00,1910.00,424.00,2120.00,210.00,'2021-07-25 20:03:46'),(1028873,'1','180',414,'Retail Sale Id 587672',0.00,1069.60,424.00,1187.20,117.60,'2021-07-25 20:05:13'),(1028875,'1','180',414,'Retail Sale Id 587673',0.00,1069.60,424.00,1187.20,117.60,'2021-07-25 20:08:05'),(1028876,'1','180',414,'Retail Sale Id 587675',0.00,4584.00,424.00,5088.00,504.00,'2021-07-25 20:08:49'),(1028877,'1','180',414,'Retail Sale Id 587676',0.00,3820.00,424.00,4240.00,420.00,'2021-07-25 20:09:32'),(1028878,'1','180',414,'Retail Sale Id 587677',0.00,4775.00,424.00,5300.00,525.00,'2021-07-25 20:10:35'),(1028880,'1','180',414,'Retail Sale Id 587678',0.00,3361.60,424.00,3731.20,369.60,'2021-07-25 20:12:00'),(1028881,'1','180',414,'Retail Sale Id 587679',0.00,3438.00,424.00,3816.00,378.00,'2021-07-25 20:12:48'),(1028883,'1','180',414,'Retail Sale Id 587681',0.00,1757.20,424.00,1950.40,193.20,'2021-07-25 20:13:45'),(1028884,'1','180',414,'Retail Sale Id 587682',0.00,1757.20,424.00,1950.40,193.20,'2021-07-25 20:14:27'),(1028886,'1','180',414,'Retail Sale Id 587684',0.00,1757.20,424.00,1950.40,193.20,'2021-07-25 20:15:19'),(1030056,'1','180',414,'Retail Sale Id 588882',0.00,1910.00,424.00,2120.00,210.00,'2021-07-26 10:49:33'),(1030135,'1','180',414,'Retail Sale Id 588963',0.00,2101.00,424.00,2332.00,231.00,'2021-07-26 11:08:13'),(1032017,'1','180',414,'Retail Sale Id 591135',0.00,1910.00,424.00,2120.00,210.00,'2021-07-26 18:32:30'),(1032018,'1','180',414,'Retail Sale Id 591136',0.00,1260.60,424.00,1399.20,138.60,'2021-07-26 18:33:24'),(1032020,'1','180',414,'Retail Sale Id 591138',0.00,4775.00,424.00,5300.00,525.00,'2021-07-26 18:34:34'),(1032021,'1','180',414,'Retail Sale Id 591139',0.00,1910.00,424.00,2120.00,210.00,'2021-07-26 18:35:34'),(1032022,'1','180',414,'Retail Sale Id 591140',0.00,3820.00,424.00,4240.00,420.00,'2021-07-26 18:36:22'),(1032023,'1','180',414,'Retail Sale Id 591141',0.00,2292.00,424.00,2544.00,252.00,'2021-07-26 18:37:19'),(1032024,'1','180',414,'Retail Sale Id 591142',0.00,1146.00,424.00,1272.00,126.00,'2021-07-26 18:39:02'),(1032025,'1','180',414,'Retail Sale Id 591143',0.00,4775.00,424.00,5300.00,525.00,'2021-07-26 18:39:37'),(1032026,'1','180',414,'Retail Sale Id 591144',0.00,1146.00,424.00,1272.00,126.00,'2021-07-26 18:40:57'),(1032035,'1','180',414,'Retail Sale Id 591145',0.00,2292.00,424.00,2544.00,252.00,'2021-07-26 18:43:47'),(1032037,'1','180',414,'Retail Sale Id 591149',0.00,2292.00,424.00,2544.00,252.00,'2021-07-26 18:44:22'),(1032042,'1','180',414,'Retail Sale Id 591152',0.00,22156.00,395.00,22910.00,754.00,'2021-07-26 18:46:36'),(1032046,'1','180',414,'Retail Sale Id 591154',0.00,22920.00,395.00,23700.00,780.00,'2021-07-26 18:47:40'),(1033928,'1','180',414,'Retail Sale Id 593159',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 12:21:37'),(1033972,'1','180',414,'Retail Sale Id 593203',0.00,1803.04,424.00,2001.28,198.24,'2021-07-27 12:30:54'),(1034007,'1','180',414,'Retail Sale Id 593232',0.00,1910.00,424.00,2120.00,210.00,'2021-07-27 12:37:47'),(1034025,'1','180',414,'Retail Sale Id 593249',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 12:40:56'),(1034035,'1','180',414,'Retail Sale Id 593258',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 12:42:14'),(1034041,'1','180',414,'Retail Sale Id 593264',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 12:43:14'),(1034108,'1','180',414,'Retail Sale Id 593342',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 12:57:12'),(1034130,'1','180',414,'Retail Sale Id 593356',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 13:01:16'),(1034196,'1','180',414,'Retail Sale Id 593408',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 13:12:54'),(1034234,'1','180',414,'Retail Sale Id 593446',0.00,1910.00,424.00,2120.00,210.00,'2021-07-27 13:17:28'),(1034255,'1','180',414,'Retail Sale Id 593493',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 13:20:09'),(1034268,'1','180',414,'Retail Sale Id 593506',0.00,1910.00,424.00,2120.00,210.00,'2021-07-27 13:22:36'),(1034295,'1','180',414,'Retail Sale Id 593526',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 13:26:57'),(1034315,'1','180',414,'Retail Sale Id 593548',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 13:29:19'),(1034347,'1','180',414,'Retail Sale Id 593588',0.00,1719.00,424.00,1908.00,189.00,'2021-07-27 13:36:04'),(1034389,'1','180',414,'Retail Sale Id 593647',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 13:42:38'),(1034435,'1','180',414,'Retail Sale Id 593698',0.00,4775.00,424.00,5300.00,525.00,'2021-07-27 13:50:01'),(1034526,'1','180',414,'Retail Sale Id 593805',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 14:04:02'),(1034618,'1','180',414,'Retail Sale Id 593924',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 14:19:49'),(1034719,'1','180',414,'Retail Sale Id 594031',0.00,1528.00,424.00,1696.00,168.00,'2021-07-27 14:35:40'),(1035254,'1','180',414,'Retail Sale Id 594605',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 15:47:41'),(1035357,'1','180',414,'Retail Sale Id 594715',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 16:01:04'),(1035446,'1','180',414,'Retail Sale Id 594829',0.00,2292.00,424.00,2544.00,252.00,'2021-07-27 16:15:55'),(1035586,'1','180',414,'Retail Sale Id 594999',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 16:37:05'),(1035602,'1','180',414,'Retail Sale Id 595022',0.00,2674.00,424.00,2968.00,294.00,'2021-07-27 16:39:56'),(1035610,'1','180',414,'Retail Sale Id 595036',0.00,2674.00,424.00,2968.00,294.00,'2021-07-27 16:41:17'),(1035639,'1','180',414,'Retail Sale Id 595044',0.00,901.52,424.00,1000.64,99.12,'2021-07-27 16:46:43'),(1035646,'1','180',414,'Retail Sale Id 595081',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 16:47:41'),(1035747,'1','180',414,'Retail Sale Id 595185',0.00,4775.00,424.00,5300.00,525.00,'2021-07-27 17:06:05'),(1035876,'1','180',414,'Retail Sale Id 595499',0.00,2704.56,424.00,3001.92,297.36,'2021-07-27 17:47:16'),(1035878,'1','180',414,'Retail Sale Id 595501',0.00,1146.00,424.00,1272.00,126.00,'2021-07-27 17:48:20'),(1035899,'1','180',414,'Retail Sale Id 595527',0.00,901.52,424.00,1000.64,99.12,'2021-07-27 17:55:49'),(1037467,'1','180',414,'Retail Sale Id 597426',0.00,22920.00,395.00,23700.00,780.00,'2021-07-28 11:03:44'),(1037670,'1','180',414,'Retail Sale Id 597817',0.00,3820.00,424.00,4240.00,420.00,'2021-07-28 11:48:57'),(1037706,'1','180',414,'Retail Sale Id 597870',0.00,3820.00,424.00,4240.00,420.00,'2021-07-28 11:54:01'),(1037735,'1','180',414,'Retail Sale Id 597897',0.00,2292.00,424.00,2544.00,252.00,'2021-07-28 11:58:36'),(1038982,'1','180',414,'Retail Sale Id 599413',0.00,2292.00,424.00,2544.00,252.00,'2021-07-28 16:41:56'),(1039008,'1','180',414,'Retail Sale Id 599447',0.00,4966.00,424.00,5512.00,546.00,'2021-07-28 16:49:53'),(1039013,'1','180',414,'Retail Sale Id 599452',0.00,2139.20,424.00,2374.40,235.20,'2021-07-28 16:51:02'),(1039014,'1','180',414,'Retail Sale Id 599454',0.00,2292.00,424.00,2544.00,252.00,'2021-07-28 16:51:44'),(1039017,'1','180',414,'Retail Sale Id 599457',0.00,1146.00,424.00,1272.00,126.00,'2021-07-28 16:52:40'),(1039021,'1','180',414,'Retail Sale Id 599461',0.00,1757.20,424.00,1950.40,193.20,'2021-07-28 16:53:40'),(1039025,'1','180',414,'Retail Sale Id 599465',0.00,2292.00,424.00,2544.00,252.00,'2021-07-28 16:54:41'),(1039029,'1','180',414,'Retail Sale Id 599471',0.00,1146.00,424.00,1272.00,126.00,'2021-07-28 16:55:43'),(1039039,'1','180',414,'Retail Sale Id 599480',0.00,1146.00,424.00,1272.00,126.00,'2021-07-28 16:57:39'),(1039046,'1','180',414,'Retail Sale Id 599486',0.00,1803.04,424.00,2001.28,198.24,'2021-07-28 16:58:43'),(1039050,'1','180',414,'Retail Sale Id 599488',0.00,1146.00,424.00,1272.00,126.00,'2021-07-28 16:59:27'),(1039102,'1','180',414,'Return of Retail Sale Id 599447',4966.00,0.00,424.00,-5512.00,-546.00,'2021-07-28 17:13:32'),(1039105,'1','180',414,'Retail Sale Id 597944',0.00,2292.00,424.00,2544.00,252.00,'2021-07-28 17:14:19'),(1041106,'1','180',414,'Retail Sale Id 601931',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 11:48:50'),(1041112,'1','180',414,'Retail Sale Id 601940',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 11:50:53'),(1041119,'1','180',414,'Retail Sale Id 601946',0.00,4775.00,424.00,5300.00,525.00,'2021-07-29 11:52:01'),(1041156,'1','180',414,'Retail Sale Id 601993',0.00,1910.00,424.00,2120.00,210.00,'2021-07-29 12:00:14'),(1041540,'1','180',414,'Retail Sale Id 602392',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 13:23:27'),(1041802,'1','180',414,'Retail Sale Id 602656',0.00,1352.28,424.00,1500.96,148.68,'2021-07-29 14:15:30'),(1041809,'1','180',414,'Retail Sale Id 602664',0.00,901.52,424.00,1000.64,99.12,'2021-07-29 14:16:31'),(1041848,'1','180',414,'Retail Sale Id 602704',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 14:23:28'),(1041908,'1','180',414,'Retail Sale Id 602766',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 14:34:47'),(1041919,'1','180',414,'Retail Sale Id 602776',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 14:36:19'),(1042099,'1','180',414,'Retail Sale Id 602951',0.00,2292.00,424.00,2544.00,252.00,'2021-07-29 15:06:18'),(1042171,'1','180',414,'Retail Sale Id 603204',0.00,88624.00,395.00,91640.00,3016.00,'2021-07-29 15:22:56'),(1042331,'1','180',414,'Retail Sale Id 603388',0.00,1982.58,424.00,2200.56,217.98,'2021-07-29 15:45:35'),(1042344,'1','180',414,'Retail Sale Id 603400',0.00,2292.00,424.00,2544.00,252.00,'2021-07-29 15:47:01'),(1042435,'1','180',414,'Retail Sale Id 603487',0.00,1910.00,424.00,2120.00,210.00,'2021-07-29 15:59:02'),(1043114,'1','180',414,'Retail Sale Id 604407',0.00,1146.00,424.00,1272.00,126.00,'2021-07-29 17:38:35'),(1044678,'1','180',414,'Retail Sale Id 606235',0.00,1146.00,424.00,1272.00,126.00,'2021-07-30 10:28:47'),(1044959,'1','180',414,'Retail Sale Id 606647',0.00,22920.00,400.00,24000.00,1080.00,'2021-07-30 11:15:02'),(1044998,'1','180',414,'Retail Sale Id 606695',0.00,2292.00,424.00,2544.00,252.00,'2021-07-30 11:22:24'),(1045006,'1','180',414,'Retail Sale Id 606709',0.00,3820.00,424.00,4240.00,420.00,'2021-07-30 11:23:53'),(1045012,'1','180',414,'Retail Sale Id 606723',0.00,2292.00,424.00,2544.00,252.00,'2021-07-30 11:24:45'),(1045020,'1','180',414,'Retail Sale Id 606729',0.00,2292.00,424.00,2544.00,252.00,'2021-07-30 11:25:34'),(1045027,'1','180',414,'Retail Sale Id 606736',0.00,2292.00,424.00,2544.00,252.00,'2021-07-30 11:26:39'),(1045039,'1','180',414,'Retail Sale Id 606746',0.00,4813.20,424.00,5342.40,529.20,'2021-07-30 11:27:45'),(1046083,'1','180',414,'Retail Sale Id 608243',0.00,1146.00,424.00,1272.00,126.00,'2021-07-30 14:48:04'),(1046092,'1','180',414,'Retail Sale Id 608251',0.00,3602.26,424.00,3998.32,396.06,'2021-07-30 14:49:30'),(1047007,'1','180',414,'Retail Sale Id 609621',0.00,4775.00,424.00,5300.00,525.00,'2021-07-30 17:51:42'),(1047012,'1','180',414,'Retail Sale Id 609642',0.00,2292.00,424.00,2544.00,252.00,'2021-07-30 17:52:47'),(1047016,'1','180',414,'Retail Sale Id 609724',0.00,2292.00,424.00,2544.00,252.00,'2021-07-30 17:54:06'),(1047019,'1','180',414,'Retail Sale Id 609728',0.00,1146.00,424.00,1272.00,126.00,'2021-07-30 17:54:57'),(1047033,'1','180',414,'Retail Sale Id 609743',0.00,901.52,424.00,1000.64,99.12,'2021-07-30 17:59:48'),(1048453,'1','180',414,'Retail Sale Id 611426',0.00,1803.04,424.00,2001.28,198.24,'2021-07-31 10:18:11'),(1048463,'1','180',414,'Retail Sale Id 611460',0.00,22920.00,400.00,24000.00,1080.00,'2021-07-31 10:19:31'),(1048561,'1','180',414,'Retail Sale Id 611586',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 10:32:57'),(1048576,'1','180',414,'Retail Sale Id 611601',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 10:34:37'),(1048580,'1','180',414,'Retail Sale Id 611611',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 10:35:42'),(1048586,'1','180',414,'Retail Sale Id 611618',0.00,2292.00,424.00,2544.00,252.00,'2021-07-31 10:36:30'),(1048591,'1','180',414,'Retail Sale Id 611623',0.00,2292.00,424.00,2544.00,252.00,'2021-07-31 10:37:14'),(1048898,'1','180',414,'Retail Sale Id 612046',0.00,2292.00,424.00,2544.00,252.00,'2021-07-31 11:23:40'),(1048913,'1','180',414,'Retail Sale Id 612063',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 11:25:53'),(1048939,'1','180',414,'Retail Sale Id 612102',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 11:29:02'),(1048952,'1','180',414,'Retail Sale Id 612147',0.00,901.52,424.00,1000.64,99.12,'2021-07-31 11:31:05'),(1049618,'1','180',414,'Retail Sale Id 613122',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 13:15:30'),(1050360,'1','180',414,'Retail Sale Id 613986',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 14:59:53'),(1050385,'1','180',414,'Retail Sale Id 614014',0.00,1910.00,424.00,2120.00,210.00,'2021-07-31 15:04:13'),(1050408,'1','180',414,'Retail Sale Id 614046',0.00,2249.98,424.00,2497.36,247.38,'2021-07-31 15:07:20'),(1050440,'1','180',414,'Retail Sale Id 614079',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 15:11:57'),(1050494,'1','180',414,'Retail Sale Id 614141',0.00,2249.98,424.00,2497.36,247.38,'2021-07-31 15:22:02'),(1050881,'1','180',414,'Retail Sale Id 614710',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 16:19:52'),(1050892,'1','180',414,'Retail Sale Id 614726',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 16:21:05'),(1050917,'1','180',414,'Retail Sale Id 614754',0.00,44312.00,400.00,46400.00,2088.00,'2021-07-31 16:24:50'),(1050924,'1','180',414,'Retail Sale Id 614766',0.00,2292.00,424.00,2544.00,252.00,'2021-07-31 16:26:49'),(1050930,'1','180',414,'Retail Sale Id 614772',0.00,4775.00,424.00,5300.00,525.00,'2021-07-31 16:28:01'),(1050964,'1','180',414,'Retail Sale Id 614810',0.00,38200.00,400.00,40000.00,1800.00,'2021-07-31 16:34:48'),(1051202,'1','180',414,'Retail Sale Id 615239',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 17:47:33'),(1051207,'1','180',414,'Retail Sale Id 615245',0.00,764.00,424.00,848.00,84.00,'2021-07-31 17:49:25'),(1051226,'1','180',414,'Retail Sale Id 615260',0.00,1146.00,424.00,1272.00,126.00,'2021-07-31 17:52:25'),(1051230,'1','180',414,'Retail Sale Id 615266',0.00,901.52,424.00,1000.64,99.12,'2021-07-31 17:53:21'),(1051317,'1','180',414,'Retail Sale Id 615335',0.00,2704.56,424.00,3001.92,297.36,'2021-07-31 18:48:09'),(1051323,'1','180',414,'Retail Sale Id 615340',0.00,1910.00,424.00,2120.00,210.00,'2021-07-31 18:55:42'),(1052958,'1','180',414,'Retail Sale Id 617155',0.00,1528.00,424.00,1696.00,168.00,'2021-08-01 11:12:53'),(1052990,'1','180',414,'Retail Sale Id 617200',0.00,2292.00,424.00,2544.00,252.00,'2021-08-01 11:17:04'),(1053002,'1','180',414,'Retail Sale Id 617218',0.00,1910.00,424.00,2120.00,210.00,'2021-08-01 11:18:55'),(1053016,'1','180',414,'Retail Sale Id 617242',0.00,1146.00,424.00,1272.00,126.00,'2021-08-01 11:20:13'),(1053028,'1','180',414,'Retail Sale Id 617252',0.00,1146.00,424.00,1272.00,126.00,'2021-08-01 11:21:14'),(1053040,'1','180',414,'Retail Sale Id 617261',0.00,4775.00,424.00,5300.00,525.00,'2021-08-01 11:22:35'),(1053048,'1','180',414,'Retail Sale Id 617269',0.00,1146.00,424.00,1272.00,126.00,'2021-08-01 11:24:08'),(1053055,'1','180',414,'Retail Sale Id 617275',0.00,2292.00,424.00,2544.00,252.00,'2021-08-01 11:25:26'),(1053066,'1','180',414,'Retail Sale Id 617286',0.00,1528.00,424.00,1696.00,168.00,'2021-08-01 11:27:08'),(1053292,'1','180',414,'Retail Sale Id 617661',0.00,1910.00,424.00,2120.00,210.00,'2021-08-01 12:01:38'),(1053413,'1','180',414,'Retail Sale Id 617810',0.00,1081.06,424.00,1199.92,118.86,'2021-08-01 12:21:27'),(1053561,'1','180',414,'Retail Sale Id 617984',0.00,1146.00,424.00,1272.00,126.00,'2021-08-01 12:46:12'),(1053899,'1','180',414,'Retail Sale Id 618331',0.00,3820.00,424.00,4240.00,420.00,'2021-08-01 13:37:23'),(1054107,'1','180',414,'Retail Sale Id 618559',0.00,1910.00,424.00,2120.00,210.00,'2021-08-01 14:17:13'),(1054927,'1','180',414,'Retail Sale Id 619546',0.00,1910.00,424.00,2120.00,210.00,'2021-08-01 17:27:21'),(1054930,'1','180',414,'Retail Sale Id 619550',0.00,4775.00,424.00,5300.00,525.00,'2021-08-01 17:28:42'),(1054933,'1','180',414,'Retail Sale Id 619554',0.00,1146.00,424.00,1272.00,126.00,'2021-08-01 17:29:32'),(1054944,'1','180',414,'Retail Sale Id 619564',0.00,2674.00,424.00,2968.00,294.00,'2021-08-01 17:31:58'),(1054955,'1','180',414,'Retail Sale Id 619572',0.00,3438.00,424.00,3816.00,378.00,'2021-08-01 17:36:20'),(1055030,'1','180',414,'Retail Sale Id 619649',0.00,901.52,424.00,1000.64,99.12,'2021-08-01 19:20:50'),(1055031,'1','180',414,'Retail Sale Id 619650',0.00,114600.00,400.00,120000.00,5400.00,'2021-08-01 19:22:23'),(1057212,'1','180',414,'Retail Sale Id 622282',0.00,901.52,424.00,1000.64,99.12,'2021-08-02 12:29:26'),(1057252,'1','180',414,'Retail Sale Id 622347',0.00,22920.00,400.00,24000.00,1080.00,'2021-08-02 12:34:25'),(1057362,'1','180',414,'Retail Sale Id 622488',0.00,4775.00,424.00,5300.00,525.00,'2021-08-02 12:56:09'),(1057394,'1','180',414,'Retail Sale Id 622522',0.00,1711.36,424.00,1899.52,188.16,'2021-08-02 13:03:36'),(1057401,'1','180',414,'Retail Sale Id 622531',0.00,4775.00,424.00,5300.00,525.00,'2021-08-02 13:04:50'),(1057410,'1','180',414,'Retail Sale Id 622538',0.00,2292.00,424.00,2544.00,252.00,'2021-08-02 13:05:55'),(1057415,'1','180',414,'Retail Sale Id 622545',0.00,2292.00,424.00,2544.00,252.00,'2021-08-02 13:06:47'),(1057514,'1','180',414,'Retail Sale Id 622651',0.00,1910.00,424.00,2120.00,210.00,'2021-08-02 13:26:03'),(1057519,'1','180',414,'Retail Sale Id 622662',0.00,382.00,424.00,424.00,42.00,'2021-08-02 13:27:16'),(1058977,'1','180',414,'Retail Sale Id 624426',0.00,1146.00,424.00,1272.00,126.00,'2021-08-02 16:57:53'),(1058985,'1','180',414,'Retail Sale Id 624435',0.00,4775.00,424.00,5300.00,525.00,'2021-08-02 16:59:15'),(1058990,'1','180',414,'Retail Sale Id 624440',0.00,4775.00,424.00,5300.00,525.00,'2021-08-02 17:00:03'),(1059001,'1','180',414,'Retail Sale Id 624450',0.00,4049.20,424.00,4494.40,445.20,'2021-08-02 17:01:59'),(1059003,'1','180',414,'Retail Sale Id 624462',0.00,3820.00,424.00,4240.00,420.00,'2021-08-02 17:03:49'),(1059013,'1','180',414,'Retail Sale Id 624523',0.00,4125.60,424.00,4579.20,453.60,'2021-08-02 17:05:18'),(1059022,'1','180',414,'Retail Sale Id 624531',0.00,2292.00,424.00,2544.00,252.00,'2021-08-02 17:06:30'),(1059024,'1','180',414,'Retail Sale Id 624549',0.00,2215.60,424.00,2459.20,243.60,'2021-08-02 17:08:39'),(1059161,'1','180',414,'Retail Sale Id 624728',0.00,1910.00,424.00,2120.00,210.00,'2021-08-02 17:47:59'),(1059164,'1','180',414,'Retail Sale Id 624731',0.00,2292.00,424.00,2544.00,252.00,'2021-08-02 17:48:54'),(1059169,'1','180',414,'Retail Sale Id 624746',0.00,764.00,424.00,848.00,84.00,'2021-08-02 17:50:28'),(1061420,'1','180',414,'Retail Sale Id 627342',0.00,44312.00,400.00,46400.00,2088.00,'2021-08-03 12:01:42'),(1061439,'1','180',414,'Retail Sale Id 627382',0.00,4775.00,424.00,5300.00,525.00,'2021-08-03 12:04:11'),(1061449,'1','180',414,'Retail Sale Id 627398',0.00,2292.00,424.00,2544.00,252.00,'2021-08-03 12:05:18'),(1061455,'1','180',414,'Retail Sale Id 627402',0.00,2292.00,424.00,2544.00,252.00,'2021-08-03 12:06:04'),(1061462,'1','180',414,'Retail Sale Id 627408',0.00,2292.00,424.00,2544.00,252.00,'2021-08-03 12:07:09'),(1061466,'1','180',414,'Retail Sale Id 627413',0.00,2215.60,424.00,2459.20,243.60,'2021-08-03 12:08:23'),(1061475,'1','180',414,'Retail Sale Id 627422',0.00,3896.40,424.00,4324.80,428.40,'2021-08-03 12:09:53'),(1061522,'1','180',414,'Retail Sale Id 627468',0.00,4202.00,424.00,4664.00,462.00,'2021-08-03 12:18:26'),(1063006,'1','180',414,'Retail Sale Id 628992',0.00,2292.00,424.00,2544.00,252.00,'2021-08-03 16:01:55'),(1063017,'1','180',414,'Retail Sale Id 629002',0.00,1146.00,424.00,1272.00,126.00,'2021-08-03 16:03:16'),(1063018,'1','180',414,'Retail Sale Id 629002',0.00,1146.00,424.00,1272.00,126.00,'2021-08-03 16:03:16'),(1063034,'1','180',414,'Retail Sale Id 629025',0.00,1910.00,424.00,2120.00,210.00,'2021-08-03 16:05:35'),(1063206,'1','180',414,'Retail Sale Id 629245',0.00,2292.00,424.00,2544.00,252.00,'2021-08-03 16:28:24'),(1063215,'1','180',414,'Retail Sale Id 629255',0.00,2292.00,424.00,2544.00,252.00,'2021-08-03 16:29:44'),(1063224,'1','180',414,'Retail Sale Id 629264',0.00,4278.40,424.00,4748.80,470.40,'2021-08-03 16:31:01'),(1063686,'1','180',414,'Retail Sale Id 629928',0.00,2559.40,424.00,2840.80,281.40,'2021-08-03 18:45:38'),(1063687,'1','180',414,'Retail Sale Id 629929',0.00,76400.00,400.00,80000.00,3600.00,'2021-08-03 18:47:15'),(1065784,'1','180',414,'Retail Sale Id 632953',0.00,3820.00,424.00,4240.00,420.00,'2021-08-04 12:46:09'),(1065787,'1','180',414,'Retail Sale Id 632955',0.00,3438.00,424.00,3816.00,378.00,'2021-08-04 12:47:32'),(1065790,'1','180',414,'Retail Sale Id 632961',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 12:48:35'),(1065794,'1','180',414,'Retail Sale Id 632963',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 12:49:26'),(1065806,'1','180',414,'Retail Sale Id 632975',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 12:51:45'),(1065816,'1','180',414,'Retail Sale Id 632986',0.00,3056.00,424.00,3392.00,336.00,'2021-08-04 12:52:45'),(1065818,'1','180',414,'Retail Sale Id 632988',0.00,1352.28,424.00,1500.96,148.68,'2021-08-04 12:53:41'),(1065824,'1','180',414,'Retail Sale Id 632994',0.00,22920.00,400.00,24000.00,1080.00,'2021-08-04 12:54:45'),(1065921,'1','180',414,'Retail Sale Id 633107',0.00,3151.50,424.00,3498.00,346.50,'2021-08-04 13:17:02'),(1065926,'1','180',414,'Retail Sale Id 633112',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 13:18:16'),(1066738,'1','180',414,'Retail Sale Id 634030',0.00,4775.00,424.00,5300.00,525.00,'2021-08-04 15:51:20'),(1066756,'1','180',414,'Retail Sale Id 634049',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 15:55:26'),(1066806,'1','180',414,'Retail Sale Id 634100',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 16:07:27'),(1066831,'1','180',414,'Retail Sale Id 634127',0.00,901.52,424.00,1000.64,99.12,'2021-08-04 16:12:22'),(1066992,'1','180',414,'Retail Sale Id 634301',0.00,7640.00,424.00,8480.00,840.00,'2021-08-04 16:38:08'),(1067001,'1','180',414,'Retail Sale Id 634311',0.00,1146.00,424.00,1272.00,126.00,'2021-08-04 16:39:22'),(1067027,'1','180',414,'Retail Sale Id 634338',0.00,1146.00,424.00,1272.00,126.00,'2021-08-04 16:44:41'),(1067039,'1','180',414,'Retail Sale Id 634349',0.00,1910.00,424.00,2120.00,210.00,'2021-08-04 16:46:14'),(1067045,'1','180',414,'Retail Sale Id 634356',0.00,1146.00,424.00,1272.00,126.00,'2021-08-04 16:48:04'),(1067054,'1','180',414,'Retail Sale Id 634363',0.00,2292.00,424.00,2544.00,252.00,'2021-08-04 16:49:28'),(1067063,'1','180',414,'Retail Sale Id 634375',0.00,1146.00,424.00,1272.00,126.00,'2021-08-04 16:50:55'),(1067067,'1','180',414,'Retail Sale Id 634379',0.00,1146.00,424.00,1272.00,126.00,'2021-08-04 16:52:20'),(1067074,'1','180',414,'Retail Sale Id 634385',0.00,573.00,424.00,636.00,63.00,'2021-08-04 16:53:52'),(1067240,'1','180',414,'Retail Sale Id 634590',0.00,22920.00,400.00,24000.00,1080.00,'2021-08-04 17:58:36'),(1068949,'1','180',414,'Retail Sale Id 636779',0.00,66468.00,400.00,69600.00,3132.00,'2021-08-05 12:48:25'),(1070328,'1','180',414,'Retail Sale Id 638592',0.00,3438.00,424.00,3816.00,378.00,'2021-08-05 17:28:53'),(1070336,'1','180',414,'Retail Sale Id 638598',0.00,2292.00,424.00,2544.00,252.00,'2021-08-05 17:29:53'),(1070347,'1','180',414,'Retail Sale Id 638609',0.00,3972.80,424.00,4409.60,436.80,'2021-08-05 17:31:16'),(1070352,'1','180',414,'Retail Sale Id 638615',0.00,2292.00,424.00,2544.00,252.00,'2021-08-05 17:33:03'),(1070355,'1','180',414,'Retail Sale Id 638619',0.00,4584.00,424.00,5088.00,504.00,'2021-08-05 17:34:51'),(1070359,'1','180',414,'Retail Sale Id 638624',0.00,3132.40,424.00,3476.80,344.40,'2021-08-05 17:36:03'),(1070364,'1','180',414,'Retail Sale Id 638629',0.00,4775.00,424.00,5300.00,525.00,'2021-08-05 17:36:58'),(1070366,'1','180',414,'Retail Sale Id 638633',0.00,2292.00,424.00,2544.00,252.00,'2021-08-05 17:37:53'),(1070378,'1','180',414,'Retail Sale Id 638646',0.00,2292.00,424.00,2544.00,252.00,'2021-08-05 17:42:53'),(1070400,'1','180',414,'Retail Sale Id 638667',0.00,1146.00,424.00,1272.00,126.00,'2021-08-05 17:53:09'),(1073194,'1','180',414,'Retail Sale Id 642190',0.00,3820.00,424.00,4240.00,420.00,'2021-08-06 13:34:00'),(1073200,'1','180',414,'Retail Sale Id 642208',0.00,1146.00,424.00,1272.00,126.00,'2021-08-06 13:35:00'),(1073208,'1','180',414,'Retail Sale Id 642224',0.00,2292.00,424.00,2544.00,252.00,'2021-08-06 13:36:03'),(1073219,'1','180',414,'Retail Sale Id 642232',0.00,840.40,424.00,932.80,92.40,'2021-08-06 13:37:02'),(1074580,'1','180',414,'Retail Sale Id 643940',0.00,450.76,424.00,500.32,49.56,'2021-08-06 17:40:59'),(1074607,'1','180',414,'Retail Sale Id 643965',0.00,1910.00,424.00,2120.00,210.00,'2021-08-06 17:48:34'),(1074610,'1','180',414,'Retail Sale Id 643968',0.00,4775.00,424.00,5300.00,525.00,'2021-08-06 17:49:24'),(1074613,'1','180',414,'Retail Sale Id 643973',0.00,1910.00,424.00,2120.00,210.00,'2021-08-06 17:50:21'),(1074618,'1','180',414,'Retail Sale Id 643976',0.00,2292.00,424.00,2544.00,252.00,'2021-08-06 17:51:32'),(1074619,'1','180',414,'Retail Sale Id 643979',0.00,1910.00,424.00,2120.00,210.00,'2021-08-06 17:52:34'),(1074627,'1','180',414,'Retail Sale Id 643987',0.00,2292.00,424.00,2544.00,252.00,'2021-08-06 17:54:33'),(1074631,'1','180',414,'Retail Sale Id 643991',0.00,1146.00,424.00,1272.00,126.00,'2021-08-06 17:55:35'),(1074637,'1','180',414,'Retail Sale Id 643997',0.00,3056.00,424.00,3392.00,336.00,'2021-08-06 17:57:53'),(1074639,'1','180',414,'Retail Sale Id 643999',0.00,4775.00,424.00,5300.00,525.00,'2021-08-06 17:58:48'),(1076201,'1','180',414,'Retail Sale Id 646438',0.00,901.52,424.00,1000.64,99.12,'2021-08-07 10:56:24'),(1076247,'1','180',414,'Retail Sale Id 646498',0.00,1910.00,424.00,2120.00,210.00,'2021-08-07 11:02:48'),(1076670,'1','180',414,'Retail Sale Id 647267',0.00,1146.00,424.00,1272.00,126.00,'2021-08-07 12:16:57'),(1076680,'1','180',414,'Retail Sale Id 647275',0.00,1146.00,424.00,1272.00,126.00,'2021-08-07 12:18:25'),(1076689,'1','180',414,'Retail Sale Id 647289',0.00,901.52,424.00,1000.64,99.12,'2021-08-07 12:19:32'),(1076700,'1','180',414,'Retail Sale Id 647306',0.00,4775.00,424.00,5300.00,525.00,'2021-08-07 12:20:43'),(1076706,'1','180',414,'Retail Sale Id 647312',0.00,3820.00,424.00,4240.00,420.00,'2021-08-07 12:21:49'),(1076721,'1','180',414,'Retail Sale Id 647326',0.00,2674.00,424.00,2968.00,294.00,'2021-08-07 12:22:54'),(1076727,'1','180',414,'Retail Sale Id 647333',0.00,901.52,424.00,1000.64,99.12,'2021-08-07 12:23:50'),(1076733,'1','180',414,'Retail Sale Id 647346',0.00,28650.00,400.00,30000.00,1350.00,'2021-08-07 12:25:09'),(1076740,'1','180',414,'Retail Sale Id 647371',0.00,22920.00,400.00,24000.00,1080.00,'2021-08-07 12:26:18'),(1078708,'1','180',414,'Retail Sale Id 650429',0.00,1910.00,424.00,2120.00,210.00,'2021-08-07 18:34:59'),(1078710,'1','180',414,'Retail Sale Id 650431',0.00,3056.00,424.00,3392.00,336.00,'2021-08-07 18:35:41'),(1078711,'1','180',414,'Retail Sale Id 650432',0.00,1146.00,424.00,1272.00,126.00,'2021-08-07 18:36:24'),(1078712,'1','180',414,'Retail Sale Id 650433',0.00,2292.00,424.00,2544.00,252.00,'2021-08-07 18:37:00'),(1078714,'1','180',414,'Retail Sale Id 650434',0.00,2704.56,424.00,3001.92,297.36,'2021-08-07 18:38:31'),(1078715,'1','180',414,'Retail Sale Id 650435',0.00,2292.00,424.00,2544.00,252.00,'2021-08-07 18:39:18'),(1078716,'1','180',414,'Retail Sale Id 650436',0.00,4584.00,424.00,5088.00,504.00,'2021-08-07 18:40:09'),(1078717,'1','180',414,'Retail Sale Id 647889',0.00,4775.00,424.00,5300.00,525.00,'2021-08-07 18:41:45'),(1078720,'1','180',414,'Retail Sale Id 650437',0.00,248300.00,400.00,260000.00,11700.00,'2021-08-07 18:44:17'),(1080707,'1','180',414,'Retail Sale Id 652581',0.00,4775.00,424.00,5300.00,525.00,'2021-08-08 12:22:21'),(1080717,'1','180',414,'Retail Sale Id 652591',0.00,2292.00,424.00,2544.00,252.00,'2021-08-08 12:23:28'),(1080720,'1','180',414,'Retail Sale Id 652594',0.00,1146.00,424.00,1272.00,126.00,'2021-08-08 12:24:09'),(1080725,'1','180',414,'Retail Sale Id 652599',0.00,1146.00,424.00,1272.00,126.00,'2021-08-08 12:24:55'),(1080730,'1','180',414,'Retail Sale Id 652605',0.00,2292.00,424.00,2544.00,252.00,'2021-08-08 12:25:32'),(1080734,'1','180',414,'Retail Sale Id 652606',0.00,1146.00,424.00,1272.00,126.00,'2021-08-08 12:26:08'),(1080769,'1','180',414,'Retail Sale Id 652642',0.00,1352.28,424.00,1500.96,148.68,'2021-08-08 12:32:34'),(1080777,'1','180',414,'Retail Sale Id 652648',0.00,1146.00,424.00,1272.00,126.00,'2021-08-08 12:33:50'),(1080886,'1','180',414,'Retail Sale Id 652765',0.00,1910.00,424.00,2120.00,210.00,'2021-08-08 12:52:16'),(1081100,'1','180',414,'Retail Sale Id 652987',0.00,4775.00,424.00,5300.00,525.00,'2021-08-08 13:27:50'),(1082474,'1','180',414,'Retail Sale Id 654388',0.00,1910.00,424.00,2120.00,210.00,'2021-08-08 18:02:53'),(1082479,'1','180',414,'Retail Sale Id 654393',0.00,1146.00,424.00,1272.00,126.00,'2021-08-08 18:05:23'),(1082480,'1','180',414,'Retail Sale Id 654394',0.00,901.52,424.00,1000.64,99.12,'2021-08-08 18:06:07'),(1082484,'1','180',414,'Retail Sale Id 654397',0.00,22920.00,400.00,24000.00,1080.00,'2021-08-08 18:07:54'),(1082514,'1','180',414,'Retail Sale Id 654419',0.00,3820.00,424.00,4240.00,420.00,'2021-08-08 18:35:55'),(1082515,'1','180',414,'Retail Sale Id 654420',0.00,2292.00,424.00,2544.00,252.00,'2021-08-08 18:37:36'),(1082516,'1','180',414,'Retail Sale Id 654421',0.00,2292.00,424.00,2544.00,252.00,'2021-08-08 18:38:20'),(1082518,'1','180',414,'Retail Sale Id 654423',0.00,1910.00,424.00,2120.00,210.00,'2021-08-08 18:39:01'),(1082519,'1','180',414,'Retail Sale Id 654424',0.00,2292.00,424.00,2544.00,252.00,'2021-08-08 18:39:47'),(1082520,'1','180',414,'Retail Sale Id 654425',0.00,1803.04,424.00,2001.28,198.24,'2021-08-08 18:40:26'),(1084786,'1','180',414,'Retail Sale Id 657289',0.00,4775.00,424.00,5300.00,525.00,'2021-08-09 13:06:45'),(1084797,'1','180',414,'Retail Sale Id 657299',0.00,2292.00,424.00,2544.00,252.00,'2021-08-09 13:07:28'),(1084802,'1','180',414,'Retail Sale Id 657305',0.00,2292.00,424.00,2544.00,252.00,'2021-08-09 13:08:06'),(1084810,'1','180',414,'Retail Sale Id 657314',0.00,2292.00,424.00,2544.00,252.00,'2021-08-09 13:08:47'),(1084814,'1','180',414,'Retail Sale Id 657318',0.00,1910.00,424.00,2120.00,210.00,'2021-08-09 13:09:24'),(1084819,'1','180',414,'Retail Sale Id 657324',0.00,2292.00,424.00,2544.00,252.00,'2021-08-09 13:10:05'),(1084836,'1','180',414,'Retail Sale Id 657341',0.00,22156.00,424.00,24592.00,2436.00,'2021-08-09 13:11:59'),(1086501,'1','180',414,'Retail Sale Id 659250',0.00,2292.00,424.00,2544.00,252.00,'2021-08-09 17:31:58'),(1086504,'1','180',414,'Retail Sale Id 659253',0.00,2292.00,424.00,2544.00,252.00,'2021-08-09 17:32:39'),(1086510,'1','180',414,'Retail Sale Id 659259',0.00,3820.00,424.00,4240.00,420.00,'2021-08-09 17:33:36'),(1086515,'1','180',414,'Retail Sale Id 659261',0.00,3438.00,424.00,3816.00,378.00,'2021-08-09 17:34:22'),(1086520,'1','180',414,'Retail Sale Id 659265',0.00,42020.00,400.00,44000.00,1980.00,'2021-08-09 17:35:19'),(1086567,'1','180',414,'Retail Sale Id 659311',0.00,4775.00,424.00,5300.00,525.00,'2021-08-09 17:54:02'),(1086593,'1','180',414,'Retail Sale Id 659342',0.00,1146.00,424.00,1272.00,126.00,'2021-08-09 18:26:35'),(1087802,'1','180',414,'Retail Sale Id 660868',0.00,2292.00,424.00,2544.00,252.00,'2021-08-10 10:27:12'),(1087818,'1','180',414,'Retail Sale Id 660889',0.00,3056.00,424.00,3392.00,336.00,'2021-08-10 10:30:06'),(1087824,'1','180',414,'Retail Sale Id 660896',0.00,2292.00,424.00,2544.00,252.00,'2021-08-10 10:30:49'),(1087827,'1','180',414,'Retail Sale Id 660899',0.00,2292.00,424.00,2544.00,252.00,'2021-08-10 10:31:28'),(1088177,'1','180',414,'Retail Sale Id 661453',0.00,2292.00,424.00,2544.00,252.00,'2021-08-10 11:36:33'),(1088405,'1','180',414,'Retail Sale Id 661727',0.00,573.00,424.00,636.00,63.00,'2021-08-10 12:14:49'),(1088454,'1','180',414,'Retail Sale Id 661783',0.00,4775.00,424.00,5300.00,525.00,'2021-08-10 12:24:11'),(1088500,'1','180',414,'Retail Sale Id 661836',0.00,22920.00,400.00,24000.00,1080.00,'2021-08-10 12:31:37'),(1088508,'1','180',414,'Retail Sale Id 661840',0.00,2292.00,424.00,2544.00,252.00,'2021-08-10 12:33:00'),(1089474,'1','180',414,'Retail Sale Id 663229',0.00,1146.00,424.00,1272.00,126.00,'2021-08-10 15:39:36'),(1089506,'1','180',414,'Retail Sale Id 663287',0.00,1146.00,424.00,1272.00,126.00,'2021-08-10 15:45:38'),(1090098,'1','180',414,'Retail Sale Id 664048',0.00,4775.00,424.00,5300.00,525.00,'2021-08-10 17:03:47'),(1090113,'1','180',414,'Retail Sale Id 664064',0.00,4775.00,424.00,5300.00,525.00,'2021-08-10 17:07:05'),(1090126,'1','180',414,'Retail Sale Id 664083',0.00,4775.00,424.00,5300.00,525.00,'2021-08-10 17:09:06'),(1090137,'1','180',414,'Retail Sale Id 664095',0.00,1803.04,424.00,2001.28,198.24,'2021-08-10 17:10:03'),(1090148,'1','180',414,'Retail Sale Id 664101',0.00,1081.06,424.00,1199.92,118.86,'2021-08-10 17:11:43'),(1104960,'1','180',414,'Retail Sale Id 686838',0.00,191000.00,400.00,200000.00,9000.00,'2021-08-14 16:27:38'),(1107889,'1','180',414,'Retail Sale Id 691935',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-15 13:16:12'),(1107901,'1','180',414,'Retail Sale Id 691946',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-15 13:17:17'),(1107908,'1','180',414,'Retail Sale Id 691988',0.00,2292.00,480.00,2880.00,588.00,'2021-08-15 13:18:20'),(1107916,'1','180',414,'Retail Sale Id 691998',0.00,1910.00,480.00,2400.00,490.00,'2021-08-15 13:19:07'),(1107924,'1','180',414,'Retail Sale Id 692010',0.00,2162.12,480.00,2716.80,554.68,'2021-08-15 13:19:58'),(1107934,'1','180',414,'Retail Sale Id 692021',0.00,38200.00,440.00,44000.00,5800.00,'2021-08-15 13:21:37'),(1107946,'1','180',414,'Retail Sale Id 692033',0.00,76400.00,440.00,88000.00,11600.00,'2021-08-15 13:23:31'),(1107956,'1','180',414,'Retail Sale Id 692064',0.00,22156.00,440.00,25520.00,3364.00,'2021-08-15 13:24:41'),(1111747,'1','180',414,'Retail Sale Id 698746',0.00,44312.00,440.00,51040.00,6728.00,'2021-08-16 12:39:09'),(1111753,'1','180',414,'Retail Sale Id 698755',0.00,2292.00,480.00,2880.00,588.00,'2021-08-16 12:40:11'),(1111760,'1','180',414,'Retail Sale Id 698769',0.00,1146.00,480.00,1440.00,294.00,'2021-08-16 12:40:55'),(1111767,'1','180',414,'Retail Sale Id 698783',0.00,1528.00,480.00,1920.00,392.00,'2021-08-16 12:41:54'),(1111984,'1','180',414,'Retail Sale Id 699222',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-16 13:22:42'),(1116590,'1','180',414,'Retail Sale Id 706750',0.00,45076.00,480.00,56640.00,11564.00,'2021-08-17 15:29:58'),(1117451,'1','180',414,'Retail Sale Id 707946',0.00,2292.00,480.00,2880.00,588.00,'2021-08-17 18:47:58'),(1117452,'1','180',414,'Retail Sale Id 707947',0.00,1910.00,480.00,2400.00,490.00,'2021-08-17 18:49:00'),(1117453,'1','180',414,'Retail Sale Id 707948',0.00,1528.00,480.00,1920.00,392.00,'2021-08-17 18:49:53'),(1117458,'1','180',414,'Retail Sale Id 707952',0.00,1910.00,480.00,2400.00,490.00,'2021-08-17 18:51:24'),(1117460,'1','180',414,'Retail Sale Id 707954',0.00,1146.00,480.00,1440.00,294.00,'2021-08-17 18:52:38'),(1117461,'1','180',414,'Retail Sale Id 707951',0.00,3182.06,480.00,3998.40,816.34,'2021-08-17 18:54:40'),(1120874,'1','180',414,'Retail Sale Id 712742',0.00,21010.00,440.00,24200.00,3190.00,'2021-08-18 17:07:44'),(1120877,'1','180',414,'Retail Sale Id 712753',0.00,3820.00,480.00,4800.00,980.00,'2021-08-18 17:08:41'),(1120880,'1','180',414,'Retail Sale Id 712756',0.00,2292.00,480.00,2880.00,588.00,'2021-08-18 17:09:56'),(1120888,'1','180',414,'Retail Sale Id 712764',0.00,3820.00,480.00,4800.00,980.00,'2021-08-18 17:11:19'),(1120894,'1','180',414,'Retail Sale Id 712770',0.00,1146.00,480.00,1440.00,294.00,'2021-08-18 17:12:19'),(1120898,'1','180',414,'Retail Sale Id 712774',0.00,1146.00,480.00,1440.00,294.00,'2021-08-18 17:13:04'),(1120900,'1','180',414,'Retail Sale Id 712776',0.00,794.56,480.00,998.40,203.84,'2021-08-18 17:13:46'),(1120925,'1','180',414,'Retail Sale Id 712912',0.00,1910.00,480.00,2400.00,490.00,'2021-08-18 17:32:52'),(1120971,'1','180',414,'Retail Sale Id 713075',0.00,3820.00,480.00,4800.00,980.00,'2021-08-18 18:37:39'),(1120974,'1','180',414,'Retail Sale Id 713078',0.00,3056.00,480.00,3840.00,784.00,'2021-08-18 18:39:48'),(1120976,'1','180',414,'Retail Sale Id 713080',0.00,2674.00,480.00,3360.00,686.00,'2021-08-18 18:42:19'),(1120980,'1','180',414,'Retail Sale Id 713081',0.00,3820.00,480.00,4800.00,980.00,'2021-08-18 18:45:33'),(1120981,'1','180',414,'Retail Sale Id 713083',0.00,2292.00,480.00,2880.00,588.00,'2021-08-18 18:46:06'),(1120982,'1','180',414,'Retail Sale Id 712911',0.00,1910.00,480.00,2400.00,490.00,'2021-08-18 18:52:47'),(1124382,'1','180',414,'Retail Sale Id 718154',0.00,1910.00,480.00,2400.00,490.00,'2021-08-19 15:47:00'),(1124408,'1','180',414,'Retail Sale Id 718161',0.00,2292.00,480.00,2880.00,588.00,'2021-08-19 15:50:04'),(1124458,'1','180',414,'Retail Sale Id 718247',0.00,2292.00,480.00,2880.00,588.00,'2021-08-19 15:57:32'),(1124474,'1','180',414,'Retail Sale Id 718254',0.00,2292.00,480.00,2880.00,588.00,'2021-08-19 15:59:34'),(1124487,'1','180',414,'Retail Sale Id 718271',0.00,2292.00,480.00,2880.00,588.00,'2021-08-19 16:01:20'),(1124533,'1','180',414,'Retail Sale Id 718291',0.00,1146.00,480.00,1440.00,294.00,'2021-08-19 16:07:28'),(1124548,'1','180',414,'Retail Sale Id 718368',0.00,1146.00,480.00,1440.00,294.00,'2021-08-19 16:09:31'),(1124573,'1','180',414,'Retail Sale Id 718385',0.00,794.56,480.00,998.40,203.84,'2021-08-19 16:13:03'),(1124877,'1','180',414,'Retail Sale Id 718729',0.00,3056.00,480.00,3840.00,784.00,'2021-08-19 17:02:23'),(1124906,'1','180',414,'Retail Sale Id 718763',0.00,22156.00,440.00,25520.00,3364.00,'2021-08-19 17:07:31'),(1125115,'1','180',414,'Retail Sale Id 718989',0.00,1146.00,480.00,1440.00,294.00,'2021-08-19 18:49:31'),(1127010,'1','180',414,'Retail Sale Id 721530',0.00,794.56,480.00,998.40,203.84,'2021-08-20 12:06:29'),(1127016,'1','180',414,'Retail Sale Id 721537',0.00,6303.00,480.00,7920.00,1617.00,'2021-08-20 12:07:28'),(1127021,'1','180',414,'Retail Sale Id 721543',0.00,1115.44,480.00,1401.60,286.16,'2021-08-20 12:08:30'),(1127026,'1','180',414,'Retail Sale Id 721547',0.00,874.78,480.00,1099.20,224.42,'2021-08-20 12:09:20'),(1127030,'1','180',414,'Retail Sale Id 721551',0.00,3820.00,480.00,4800.00,980.00,'2021-08-20 12:10:19'),(1127036,'1','180',414,'Retail Sale Id 721557',0.00,1910.00,480.00,2400.00,490.00,'2021-08-20 12:11:18'),(1127046,'1','180',414,'Retail Sale Id 721569',0.00,1146.00,480.00,1440.00,294.00,'2021-08-20 12:12:30'),(1127047,'1','180',414,'Retail Sale Id 721573',0.00,794.56,480.00,998.40,203.84,'2021-08-20 12:13:08'),(1127055,'1','180',414,'Retail Sale Id 721581',0.00,794.56,480.00,998.40,203.84,'2021-08-20 12:14:19'),(1127060,'1','180',414,'Retail Sale Id 721586',0.00,1146.00,480.00,1440.00,294.00,'2021-08-20 12:15:06'),(1127064,'1','180',414,'Retail Sale Id 721590',0.00,1910.00,480.00,2400.00,490.00,'2021-08-20 12:15:59'),(1127071,'1','180',414,'Retail Sale Id 721596',0.00,1719.00,480.00,2160.00,441.00,'2021-08-20 12:16:59'),(1127074,'1','180',414,'Retail Sale Id 721600',0.00,1035.22,480.00,1300.80,265.58,'2021-08-20 12:18:09'),(1127082,'1','180',414,'Retail Sale Id 721611',0.00,22920.00,440.00,26400.00,3480.00,'2021-08-20 12:20:37'),(1127119,'1','180',414,'Retail Sale Id 721651',0.00,1146.00,480.00,1440.00,294.00,'2021-08-20 12:31:11'),(1127200,'1','180',414,'Retail Sale Id 721751',0.00,1528.00,480.00,1920.00,392.00,'2021-08-20 12:56:31'),(1127456,'1','180',414,'Retail Sale Id 722044',0.00,1146.00,480.00,1440.00,294.00,'2021-08-20 13:53:40'),(1128335,'1','180',414,'Retail Sale Id 723175',0.00,1910.00,480.00,2400.00,490.00,'2021-08-20 16:14:40'),(1128342,'1','180',414,'Retail Sale Id 723182',0.00,3820.00,480.00,4800.00,980.00,'2021-08-20 16:15:36'),(1128346,'1','180',414,'Retail Sale Id 723186',0.00,1910.00,480.00,2400.00,490.00,'2021-08-20 16:16:25'),(1128357,'1','180',414,'Retail Sale Id 723196',0.00,874.78,480.00,1099.20,224.42,'2021-08-20 16:17:39'),(1128367,'1','180',414,'Retail Sale Id 723207',0.00,955.00,480.00,1200.00,245.00,'2021-08-20 16:19:17'),(1128428,'1','180',414,'Retail Sale Id 723333',0.00,1146.00,480.00,1440.00,294.00,'2021-08-20 16:31:00'),(1128749,'1','180',414,'Retail Sale Id 723752',0.00,1528.00,480.00,1920.00,392.00,'2021-08-20 18:07:03'),(1131084,'1','180',414,'Retail Sale Id 726487',0.00,1910.00,480.00,2400.00,490.00,'2021-08-21 12:52:32'),(1131093,'1','180',414,'Retail Sale Id 726501',0.00,2292.00,480.00,2880.00,588.00,'2021-08-21 12:53:33'),(1131105,'1','180',414,'Retail Sale Id 726515',0.00,2292.00,480.00,2880.00,588.00,'2021-08-21 12:54:36'),(1131115,'1','180',414,'Retail Sale Id 726522',0.00,1592.94,480.00,2001.60,408.66,'2021-08-21 12:55:29'),(1131124,'1','180',414,'Retail Sale Id 726527',0.00,3247.00,480.00,4080.00,833.00,'2021-08-21 12:56:36'),(1131129,'1','180',414,'Retail Sale Id 726530',0.00,1146.00,480.00,1440.00,294.00,'2021-08-21 12:57:30'),(1131135,'1','180',414,'Retail Sale Id 726539',0.00,2292.00,480.00,2880.00,588.00,'2021-08-21 12:58:20'),(1133089,'1','180',414,'Retail Sale Id 728785',0.00,2292.00,480.00,2880.00,588.00,'2021-08-21 18:34:28'),(1133093,'1','180',414,'Retail Sale Id 728786',0.00,1592.94,480.00,2001.60,408.66,'2021-08-21 18:35:14'),(1133095,'1','180',414,'Retail Sale Id 728788',0.00,2292.00,480.00,2880.00,588.00,'2021-08-21 18:35:59'),(1133096,'1','180',414,'Retail Sale Id 728790',0.00,794.56,480.00,998.40,203.84,'2021-08-21 18:36:40'),(1133101,'1','180',414,'Retail Sale Id 728793',0.00,1829.78,480.00,2299.20,469.42,'2021-08-21 18:38:16'),(1133104,'1','180',414,'Retail Sale Id 728796',0.00,286500.00,440.00,330000.00,43500.00,'2021-08-21 18:43:30'),(1137244,'1','180',414,'Retail Sale Id 734571',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-22 21:47:24'),(1137245,'1','180',414,'Retail Sale Id 734572',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-22 21:48:37'),(1137247,'1','180',414,'Retail Sale Id 734573',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-22 21:50:20'),(1137248,'1','180',414,'Retail Sale Id 734574',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-22 21:53:23'),(1137249,'1','180',414,'Retail Sale Id 734575',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-22 21:54:06'),(1137250,'1','180',414,'Retail Sale Id 734576',0.00,3934.60,480.00,4944.00,1009.40,'2021-08-22 21:56:10'),(1137251,'1','180',414,'Retail Sale Id 734577',0.00,5730.00,480.00,7200.00,1470.00,'2021-08-22 21:58:33'),(1137252,'1','180',414,'Retail Sale Id 734578',0.00,5730.00,480.00,7200.00,1470.00,'2021-08-22 21:59:42'),(1137253,'1','180',414,'Retail Sale Id 734579',0.00,3934.60,480.00,4944.00,1009.40,'2021-08-22 22:01:00'),(1137254,'1','180',414,'Retail Sale Id 734580',0.00,3820.00,480.00,4800.00,980.00,'2021-08-22 22:03:40'),(1137255,'1','180',414,'Retail Sale Id 734581',0.00,4584.00,480.00,5760.00,1176.00,'2021-08-22 22:06:13'),(1137256,'1','180',414,'Retail Sale Id 734582',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-22 22:07:53'),(1137257,'1','180',414,'Retail Sale Id 734583',0.00,5539.00,480.00,6960.00,1421.00,'2021-08-22 22:10:22'),(1137258,'1','180',414,'Return of Retail Sale Id 734575',4775.00,0.00,480.00,-6000.00,-1225.00,'2021-08-22 22:11:43'),(1141183,'1','180',414,'Retail Sale Id 739528',0.00,44312.00,440.00,51040.00,6728.00,'2021-08-23 19:48:57'),(1141184,'1','180',414,'Retail Sale Id 739529',0.00,382.00,480.00,480.00,98.00,'2021-08-23 19:49:51'),(1141185,'1','180',414,'Retail Sale Id 739530',0.00,2292.00,480.00,2880.00,588.00,'2021-08-23 19:52:15'),(1141186,'1','180',414,'Retail Sale Id 739531',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-23 19:52:58'),(1141187,'1','180',414,'Retail Sale Id 739532',0.00,4584.00,480.00,5760.00,1176.00,'2021-08-23 19:54:31'),(1141188,'1','180',414,'Retail Sale Id 739533',0.00,2292.00,480.00,2880.00,588.00,'2021-08-23 19:55:47'),(1141189,'1','180',414,'Retail Sale Id 739534',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-23 19:56:28'),(1141190,'1','180',414,'Retail Sale Id 739535',0.00,4775.00,480.00,6000.00,1225.00,'2021-08-23 19:58:03'),(1141191,'1','180',414,'Retail Sale Id 739536',0.00,2292.00,480.00,2880.00,588.00,'2021-08-23 19:58:53'),(1141194,'1','180',414,'Retail Sale Id 739538',0.00,3896.40,480.00,4896.00,999.60,'2021-08-23 20:00:11'),(1141195,'1','180',414,'Retail Sale Id 739539',0.00,2292.00,480.00,2880.00,588.00,'2021-08-23 20:01:28'),(1141196,'1','180',414,'Retail Sale Id 739540',0.00,45840.00,440.00,52800.00,6960.00,'2021-08-23 20:02:40'),(1149274,'1','180',414,'Retail Sale Id 751574',0.00,15280.00,440.00,17600.00,2320.00,'2021-08-26 07:44:23'),(1167246,'1','180',414,'Retail Sale Id 780915',0.00,1330.25,480.00,1502.40,172.15,'2021-08-30 15:19:04'),(1167313,'1','180',414,'Retail Sale Id 780997',0.00,2125.00,480.00,2400.00,275.00,'2021-08-30 15:28:17'),(1167397,'1','180',414,'Retail Sale Id 781141',0.00,5312.50,480.00,6000.00,687.50,'2021-08-30 15:40:17'),(1167720,'1','180',414,'Retail Sale Id 781596',0.00,85000.00,440.00,88000.00,3000.00,'2021-08-30 16:27:42'),(1168057,'1','180',414,'Retail Sale Id 782373',0.00,5100.00,480.00,5760.00,660.00,'2021-08-30 18:43:05'),(1168060,'1','180',414,'Retail Sale Id 782377',0.00,5100.00,480.00,5760.00,660.00,'2021-08-30 18:44:12'),(1168064,'1','180',414,'Retail Sale Id 782381',0.00,5312.50,480.00,6000.00,687.50,'2021-08-30 18:45:56'),(1168066,'1','180',414,'Retail Sale Id 782382',0.00,2125.00,480.00,2400.00,275.00,'2021-08-30 18:46:41'),(1168068,'1','180',414,'Retail Sale Id 782387',0.00,3646.50,480.00,4118.40,471.90,'2021-08-30 18:48:13'),(1168071,'1','180',414,'Retail Sale Id 782389',0.00,3400.00,480.00,3840.00,440.00,'2021-08-30 18:49:37'),(1168076,'1','180',414,'Retail Sale Id 782392',0.00,5312.50,480.00,6000.00,687.50,'2021-08-30 18:54:37'),(1168077,'1','180',414,'Retail Sale Id 782399',0.00,4505.00,480.00,5088.00,583.00,'2021-08-30 18:55:30'),(1168078,'1','180',414,'Retail Sale Id 782400',0.00,2550.00,480.00,2880.00,330.00,'2021-08-30 18:56:23'),(1168080,'1','180',414,'Retail Sale Id 782402',0.00,283050.00,440.00,293040.00,9990.00,'2021-08-30 18:58:10'),(1168084,'1','180',414,'Retail Sale Id 782419',0.00,2550.00,480.00,2880.00,330.00,'2021-08-30 19:08:54'),(1171806,'1','180',414,'Retail Sale Id 788533',0.00,2550.00,480.00,2880.00,330.00,'2021-08-31 16:55:16'),(1171813,'1','180',414,'Retail Sale Id 788547',0.00,1241.00,480.00,1401.60,160.60,'2021-08-31 16:56:36'),(1171820,'1','180',414,'Retail Sale Id 788562',0.00,2550.00,480.00,2880.00,330.00,'2021-08-31 16:57:32'),(1171824,'1','180',414,'Retail Sale Id 788565',0.00,1275.00,480.00,1440.00,165.00,'2021-08-31 16:58:17'),(1171830,'1','180',414,'Retail Sale Id 788575',0.00,2550.00,480.00,2880.00,330.00,'2021-08-31 16:59:37'),(1171840,'1','180',414,'Retail Sale Id 788586',0.00,2125.00,480.00,2400.00,275.00,'2021-08-31 17:01:09'),(1171845,'1','180',414,'Retail Sale Id 788591',0.00,2550.00,480.00,2880.00,330.00,'2021-08-31 17:02:17'),(1171855,'1','180',414,'Retail Sale Id 788601',0.00,1275.00,480.00,1440.00,165.00,'2021-08-31 17:03:24'),(1171860,'1','180',414,'Retail Sale Id 788613',0.00,2125.00,480.00,2400.00,275.00,'2021-08-31 17:04:25'),(1171869,'1','180',414,'Retail Sale Id 788625',0.00,1275.00,480.00,1440.00,165.00,'2021-08-31 17:05:28'),(1171881,'1','180',414,'Retail Sale Id 788660',0.00,1275.00,480.00,1440.00,165.00,'2021-08-31 17:08:41'),(1171986,'1','180',414,'Retail Sale Id 788871',0.00,42500.00,440.00,44000.00,1500.00,'2021-08-31 18:51:10'),(1171987,'1','180',414,'Retail Sale Id 788872',0.00,5312.50,480.00,6000.00,687.50,'2021-08-31 18:52:44'),(1174221,'1','180',414,'Retail Sale Id 791713',0.00,1772.25,480.00,2001.60,229.35,'2021-09-01 12:44:13'),(1174302,'1','180',414,'Retail Sale Id 791869',0.00,2550.00,480.00,2880.00,330.00,'2021-09-01 12:57:51'),(1175747,'1','180',414,'Retail Sale Id 793711',0.00,2125.00,480.00,2400.00,275.00,'2021-09-01 18:46:13'),(1175748,'1','180',414,'Retail Sale Id 793713',0.00,131750.00,440.00,136400.00,4650.00,'2021-09-01 18:48:12'),(1175750,'1','180',414,'Retail Sale Id 793714',0.00,5312.50,480.00,6000.00,687.50,'2021-09-01 18:49:38'),(1175752,'1','180',414,'Retail Sale Id 793716',0.00,2125.00,480.00,2400.00,275.00,'2021-09-01 18:50:34'),(1175753,'1','180',414,'Retail Sale Id 793717',0.00,2550.00,480.00,2880.00,330.00,'2021-09-01 18:51:25'),(1175754,'1','180',414,'Retail Sale Id 793718',0.00,4250.00,480.00,4800.00,550.00,'2021-09-01 18:52:24'),(1175755,'1','180',414,'Retail Sale Id 793720',0.00,5100.00,480.00,5760.00,660.00,'2021-09-01 18:55:11'),(1175759,'1','180',414,'Retail Sale Id 793725',0.00,884.00,480.00,998.40,114.40,'2021-09-01 19:03:01'),(1175760,'1','180',414,'Retail Sale Id 793726',0.00,24650.00,440.00,25520.00,870.00,'2021-09-01 19:07:21'),(1179474,'1','180',414,'Retail Sale Id 799555',0.00,2125.00,480.00,2400.00,275.00,'2021-09-02 16:12:37'),(1179483,'1','180',414,'Retail Sale Id 799570',0.00,4250.00,480.00,4800.00,550.00,'2021-09-02 16:14:56'),(1179489,'1','180',414,'Retail Sale Id 799588',0.00,2125.00,480.00,2400.00,275.00,'2021-09-02 16:16:13'),(1179494,'1','180',414,'Retail Sale Id 799593',0.00,2550.00,480.00,2880.00,330.00,'2021-09-02 16:17:11'),(1179499,'1','180',414,'Retail Sale Id 799598',0.00,2125.00,480.00,2400.00,275.00,'2021-09-02 16:18:07'),(1179572,'1','180',414,'Retail Sale Id 799682',0.00,1275.00,480.00,1440.00,165.00,'2021-09-02 16:31:17'),(1179627,'1','180',414,'Retail Sale Id 799940',0.00,884.00,480.00,998.40,114.40,'2021-09-02 16:48:06'),(1179889,'1','180',414,'Retail Sale Id 800307',0.00,1700.00,480.00,1920.00,220.00,'2021-09-02 18:03:38'),(1179893,'1','180',414,'Retail Sale Id 800311',0.00,161500.00,440.00,167200.00,5700.00,'2021-09-02 18:05:11'),(1181727,'1','180',414,'Retail Sale Id 803445',0.00,2550.00,480.00,2880.00,330.00,'2021-09-03 10:59:23'),(1181930,'1','180',414,'Retail Sale Id 803714',0.00,884.00,480.00,998.40,114.40,'2021-09-03 11:24:57'),(1184240,'1','180',414,'Retail Sale Id 806649',0.00,1241.00,480.00,1401.60,160.60,'2021-09-03 18:34:32'),(1184242,'1','180',414,'Retail Sale Id 806654',0.00,2550.00,480.00,2880.00,330.00,'2021-09-03 18:35:29'),(1184244,'1','180',414,'Retail Sale Id 806656',0.00,4250.00,480.00,4800.00,550.00,'2021-09-03 18:36:21'),(1184246,'1','180',414,'Retail Sale Id 806664',0.00,5100.00,480.00,5760.00,660.00,'2021-09-03 18:39:56'),(1184247,'1','180',414,'Retail Sale Id 806538',0.00,1772.25,480.00,2001.60,229.35,'2021-09-03 18:40:40'),(1184249,'1','180',414,'Retail Sale Id 806690',0.00,5312.50,480.00,6000.00,687.50,'2021-09-03 18:42:11'),(1184254,'1','180',414,'Retail Sale Id 806702',0.00,3825.00,480.00,4320.00,495.00,'2021-09-03 18:42:58'),(1184259,'1','180',414,'Retail Sale Id 806706',0.00,4250.00,480.00,4800.00,550.00,'2021-09-03 18:44:06'),(1184263,'1','180',414,'Retail Sale Id 806711',0.00,5312.50,480.00,6000.00,687.50,'2021-09-03 18:46:36'),(1184264,'1','180',414,'Retail Sale Id 806720',0.00,5312.50,480.00,6000.00,687.50,'2021-09-03 18:53:31'),(1184265,'1','180',414,'Retail Sale Id 806721',0.00,49300.00,440.00,51040.00,1740.00,'2021-09-03 18:57:33'),(1186644,'1','180',414,'Retail Sale Id 810185',0.00,4250.00,480.00,4800.00,550.00,'2021-09-04 13:01:34'),(1186650,'1','180',414,'Retail Sale Id 810191',0.00,4250.00,480.00,4800.00,550.00,'2021-09-04 13:02:30'),(1186656,'1','180',414,'Retail Sale Id 810196',0.00,2125.00,480.00,2400.00,275.00,'2021-09-04 13:03:17'),(1186662,'1','180',414,'Retail Sale Id 810209',0.00,4250.00,480.00,4800.00,550.00,'2021-09-04 13:04:08'),(1186685,'1','180',414,'Retail Sale Id 810232',0.00,25500.00,440.00,26400.00,900.00,'2021-09-04 13:07:45'),(1186882,'1','180',414,'Retail Sale Id 810460',0.00,2550.00,480.00,2880.00,330.00,'2021-09-04 13:35:37'),(1186898,'1','180',414,'Retail Sale Id 810474',0.00,1275.00,480.00,1440.00,165.00,'2021-09-04 13:37:48'),(1187087,'1','180',414,'Retail Sale Id 810688',0.00,2550.00,480.00,2880.00,330.00,'2021-09-04 14:02:21'),(1187092,'1','180',414,'Retail Sale Id 810693',0.00,2550.00,480.00,2880.00,330.00,'2021-09-04 14:03:16'),(1187405,'1','180',414,'Retail Sale Id 811061',0.00,2550.00,480.00,2880.00,330.00,'2021-09-04 14:47:03'),(1187421,'1','180',414,'Retail Sale Id 811076',0.00,1275.00,480.00,1440.00,165.00,'2021-09-04 14:51:49'),(1187789,'1','180',414,'Retail Sale Id 811669',0.00,2550.00,480.00,2880.00,330.00,'2021-09-04 15:50:38'),(1187887,'1','180',414,'Retail Sale Id 811837',0.00,2125.00,480.00,2400.00,275.00,'2021-09-04 16:02:01'),(1188209,'1','180',414,'Retail Sale Id 812512',0.00,140250.00,440.00,145200.00,4950.00,'2021-09-04 17:31:35'),(1188247,'1','180',414,'Retail Sale Id 812532',0.00,1912.50,480.00,2160.00,247.50,'2021-09-04 18:16:46'),(1191908,'1','180',414,'Retail Sale Id 816813',0.00,5312.50,480.00,6000.00,687.50,'2021-09-05 17:13:32'),(1191918,'1','180',414,'Retail Sale Id 816838',0.00,5100.00,480.00,5760.00,660.00,'2021-09-05 17:14:49'),(1191921,'1','180',414,'Retail Sale Id 816843',0.00,2550.00,480.00,2880.00,330.00,'2021-09-05 17:15:33'),(1191928,'1','180',414,'Retail Sale Id 816849',0.00,5312.50,480.00,6000.00,687.50,'2021-09-05 17:16:24'),(1191932,'1','180',414,'Retail Sale Id 816741',0.00,5312.50,480.00,6000.00,687.50,'2021-09-05 17:17:08'),(1191938,'1','180',414,'Retail Sale Id 816857',0.00,2550.00,480.00,2880.00,330.00,'2021-09-05 17:19:33'),(1191967,'1','180',414,'Retail Sale Id 816887',0.00,1275.00,480.00,1440.00,165.00,'2021-09-05 17:27:10'),(1191978,'1','180',414,'Retail Sale Id 816899',0.00,2550.00,480.00,2880.00,330.00,'2021-09-05 17:31:21'),(1192041,'1','180',414,'Retail Sale Id 816950',0.00,2550.00,480.00,2880.00,330.00,'2021-09-05 17:50:22'),(1192042,'1','180',414,'Retail Sale Id 816951',0.00,2550.00,480.00,2880.00,330.00,'2021-09-05 17:51:06'),(1192046,'1','180',414,'Retail Sale Id 816957',0.00,2550.00,480.00,2880.00,330.00,'2021-09-05 17:52:07'),(1192048,'1','180',414,'Retail Sale Id 816958',0.00,5312.50,480.00,6000.00,687.50,'2021-09-05 17:52:49'),(1192051,'1','180',414,'Retail Sale Id 816735',0.00,5312.50,480.00,6000.00,687.50,'2021-09-05 17:53:33'),(1195080,'1','180',414,'Retail Sale Id 821144',0.00,5312.50,480.00,6000.00,687.50,'2021-09-06 17:53:19'),(1195083,'1','180',414,'Retail Sale Id 821146',0.00,2656.25,480.00,3000.00,343.75,'2021-09-06 17:58:19'),(1195084,'1','180',414,'Retail Sale Id 821147',0.00,2550.00,480.00,2880.00,330.00,'2021-09-06 17:59:03'),(1195085,'1','180',414,'Retail Sale Id 821148',0.00,2550.00,480.00,2880.00,330.00,'2021-09-06 18:00:00'),(1195089,'1','180',414,'Retail Sale Id 821149',0.00,2550.00,480.00,2880.00,330.00,'2021-09-06 18:00:43'),(1195092,'1','180',414,'Retail Sale Id 821150',0.00,2550.00,480.00,2880.00,330.00,'2021-09-06 18:01:31'),(1195097,'1','180',414,'Retail Sale Id 821152',0.00,1772.25,480.00,2001.60,229.35,'2021-09-06 18:04:27'),(1195098,'1','180',414,'Retail Sale Id 821153',0.00,1772.25,480.00,2001.60,229.35,'2021-09-06 18:05:27'),(1195102,'1','180',414,'Retail Sale Id 821154',0.00,2762.50,480.00,3120.00,357.50,'2021-09-06 18:07:58'),(1195105,'1','180',414,'Retail Sale Id 821156',0.00,2337.50,480.00,2640.00,302.50,'2021-09-06 18:08:57'),(1195106,'1','180',414,'Retail Sale Id 821157',0.00,1275.00,480.00,1440.00,165.00,'2021-09-06 18:09:50'),(1195109,'1','180',414,'Retail Sale Id 821158',0.00,1275.00,480.00,1440.00,165.00,'2021-09-06 18:10:30'),(1195110,'1','180',414,'Retail Sale Id 821159',0.00,850.00,480.00,960.00,110.00,'2021-09-06 18:12:09'),(1195113,'1','180',414,'Retail Sale Id 821160',0.00,2550.00,480.00,2880.00,330.00,'2021-09-06 18:19:52'),(1195114,'1','180',414,'Retail Sale Id 821161',0.00,5312.50,480.00,6000.00,687.50,'2021-09-06 18:20:50'),(1195115,'1','180',414,'Retail Sale Id 821162',0.00,63750.00,440.00,66000.00,2250.00,'2021-09-06 18:25:05'),(1195116,'1','180',414,'Retail Sale Id 821163',0.00,24650.00,440.00,25520.00,870.00,'2021-09-06 18:26:23'),(1195117,'1','180',414,'Retail Sale Id 821164',0.00,884.00,480.00,998.40,114.40,'2021-09-06 18:33:25'),(1195124,'1','180',414,'Retail Sale Id 821172',0.00,425.00,480.00,480.00,55.00,'2021-09-06 18:52:22'),(1196473,'1','180',414,'Retail Sale Id 822438',0.00,884.00,480.00,998.40,114.40,'2021-09-07 17:40:53'),(1196476,'1','180',414,'Retail Sale Id 822439',0.00,5312.50,480.00,6000.00,687.50,'2021-09-07 17:41:58'),(1196480,'1','180',414,'Retail Sale Id 822441',0.00,4339.25,480.00,4900.80,561.55,'2021-09-07 17:44:59'),(1196481,'1','180',414,'Retail Sale Id 822442',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 17:46:06'),(1196483,'1','180',414,'Retail Sale Id 822443',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 17:47:41'),(1196484,'1','180',414,'Retail Sale Id 822445',0.00,2125.00,480.00,2400.00,275.00,'2021-09-07 17:49:10'),(1196486,'1','180',414,'Retail Sale Id 822447',0.00,2125.00,480.00,2400.00,275.00,'2021-09-07 17:50:09'),(1196488,'1','180',414,'Retail Sale Id 822449',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 17:52:34'),(1196489,'1','180',414,'Retail Sale Id 822450',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 17:54:30'),(1196491,'1','180',414,'Retail Sale Id 822453',0.00,2125.00,480.00,2400.00,275.00,'2021-09-07 17:56:14'),(1196492,'1','180',414,'Retail Sale Id 822454',0.00,5312.50,480.00,6000.00,687.50,'2021-09-07 17:57:40'),(1196494,'1','180',414,'Retail Sale Id 822456',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 17:59:18'),(1196498,'1','180',414,'Retail Sale Id 822459',0.00,2125.00,480.00,2400.00,275.00,'2021-09-07 18:01:15'),(1196499,'1','180',414,'Retail Sale Id 822460',0.00,1147.50,480.00,1296.00,148.50,'2021-09-07 18:03:23'),(1196500,'1','180',414,'Retail Sale Id 822461',0.00,1275.00,480.00,1440.00,165.00,'2021-09-07 18:05:12'),(1196501,'1','180',414,'Retail Sale Id 822462',0.00,7437.50,480.00,8400.00,962.50,'2021-09-07 18:06:56'),(1196502,'1','180',414,'Retail Sale Id 822463',0.00,1275.00,480.00,1440.00,165.00,'2021-09-07 18:08:30'),(1196509,'1','180',414,'Retail Sale Id 822467',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 18:37:54'),(1196510,'1','180',414,'Retail Sale Id 822468',0.00,884.00,480.00,998.40,114.40,'2021-09-07 18:38:46'),(1196516,'1','180',414,'Retail Sale Id 822451',0.00,2550.00,480.00,2880.00,330.00,'2021-09-07 18:45:57'),(1197773,'1','180',414,'Retail Sale Id 823681',0.00,212500.00,440.00,220000.00,7500.00,'2021-09-08 14:28:36'),(1197782,'1','180',414,'Retail Sale Id 823690',0.00,2550.00,480.00,2880.00,330.00,'2021-09-08 14:32:39'),(1197787,'1','180',414,'Retail Sale Id 823694',0.00,2550.00,480.00,2880.00,330.00,'2021-09-08 14:34:09'),(1197792,'1','180',414,'Retail Sale Id 823699',0.00,1700.00,480.00,1920.00,220.00,'2021-09-08 14:35:42'),(1198335,'1','180',414,'Retail Sale Id 824302',0.00,2550.00,480.00,2880.00,330.00,'2021-09-08 17:38:38'),(1198340,'1','180',414,'Retail Sale Id 824306',0.00,5312.50,480.00,6000.00,687.50,'2021-09-08 17:39:44'),(1198349,'1','180',414,'Retail Sale Id 824314',0.00,2125.00,480.00,2400.00,275.00,'2021-09-08 17:41:28'),(1198362,'1','180',414,'Retail Sale Id 824323',0.00,1275.00,480.00,1440.00,165.00,'2021-09-08 17:45:27'),(1198372,'1','180',414,'Retail Sale Id 824342',0.00,2550.00,480.00,2880.00,330.00,'2021-09-08 17:55:40'),(1198379,'1','180',414,'Retail Sale Id 824348',0.00,5312.50,480.00,6000.00,687.50,'2021-09-08 18:15:16'),(1198383,'1','180',414,'Retail Sale Id 824351',0.00,3400.00,480.00,3840.00,440.00,'2021-09-08 18:19:31'),(1198385,'1','180',414,'Retail Sale Id 824355',0.00,5100.00,480.00,5760.00,660.00,'2021-09-08 18:20:43'),(1198387,'1','180',414,'Retail Sale Id 824357',0.00,4250.00,480.00,4800.00,550.00,'2021-09-08 18:22:09'),(1198388,'1','180',414,'Retail Sale Id 824361',0.00,1275.00,480.00,1440.00,165.00,'2021-09-08 18:23:30'),(1200298,'1','180',414,'Retail Sale Id 826692',0.00,73950.00,440.00,76560.00,2610.00,'2021-09-09 12:58:38'),(1200328,'1','180',414,'Retail Sale Id 826716',0.00,42500.00,440.00,44000.00,1500.00,'2021-09-09 13:05:48'),(1201723,'1','180',414,'Retail Sale Id 828514',0.00,1275.00,480.00,1440.00,165.00,'2021-09-09 18:27:45'),(1201733,'1','180',414,'Retail Sale Id 828519',0.00,3825.00,480.00,4320.00,495.00,'2021-09-09 18:40:27'),(1201734,'1','180',414,'Retail Sale Id 828520',0.00,5100.00,480.00,5760.00,660.00,'2021-09-09 18:41:51'),(1201735,'1','180',414,'Retail Sale Id 828521',0.00,5312.50,480.00,6000.00,687.50,'2021-09-09 18:42:50'),(1201736,'1','180',414,'Retail Sale Id 828522',0.00,5312.50,480.00,6000.00,687.50,'2021-09-09 18:43:53'),(1201737,'1','180',414,'Retail Sale Id 828523',0.00,5312.50,480.00,6000.00,687.50,'2021-09-09 18:45:20'),(1201739,'1','180',414,'Retail Sale Id 828525',0.00,5100.00,480.00,5760.00,660.00,'2021-09-09 18:46:56'),(1201740,'1','180',414,'Retail Sale Id 828526',0.00,2550.00,480.00,2880.00,330.00,'2021-09-09 18:48:11'),(1203981,'1','180',414,'Retail Sale Id 831651',0.00,2550.00,480.00,2880.00,330.00,'2021-09-10 13:29:29'),(1204007,'1','180',414,'Retail Sale Id 831676',0.00,1330.25,480.00,1502.40,172.15,'2021-09-10 13:33:14'),(1204014,'1','180',414,'Retail Sale Id 831686',0.00,1330.25,480.00,1502.40,172.15,'2021-09-10 13:34:34'),(1204018,'1','180',414,'Retail Sale Id 831691',0.00,2125.00,480.00,2400.00,275.00,'2021-09-10 13:35:40'),(1204023,'1','180',414,'Retail Sale Id 831696',0.00,2550.00,480.00,2880.00,330.00,'2021-09-10 13:36:37'),(1204032,'1','180',414,'Retail Sale Id 831703',0.00,1062.50,480.00,1200.00,137.50,'2021-09-10 13:37:40'),(1204041,'1','180',414,'Retail Sale Id 831710',0.00,5100.00,480.00,5760.00,660.00,'2021-09-10 13:39:58'),(1204049,'1','180',414,'Retail Sale Id 831716',0.00,3825.00,480.00,4320.00,495.00,'2021-09-10 13:40:59'),(1204055,'1','180',414,'Retail Sale Id 831732',0.00,2550.00,480.00,2880.00,330.00,'2021-09-10 13:42:00'),(1204058,'1','180',414,'Retail Sale Id 831740',0.00,5312.50,480.00,6000.00,687.50,'2021-09-10 13:42:41'),(1204070,'1','180',414,'Retail Sale Id 831753',0.00,10625.00,480.00,12000.00,1375.00,'2021-09-10 13:43:59'),(1204985,'1','180',414,'Retail Sale Id 832968',0.00,2550.00,480.00,2880.00,330.00,'2021-09-10 16:43:29'),(1204993,'1','180',414,'Retail Sale Id 832977',0.00,1275.00,480.00,1440.00,165.00,'2021-09-10 16:45:33'),(1204997,'1','180',414,'Retail Sale Id 832983',0.00,1275.00,480.00,1440.00,165.00,'2021-09-10 16:46:19'),(1205006,'1','180',414,'Retail Sale Id 832989',0.00,2550.00,480.00,2880.00,330.00,'2021-09-10 16:47:15'),(1205192,'1','180',414,'Retail Sale Id 833356',0.00,2125.00,480.00,2400.00,275.00,'2021-09-10 17:42:05'),(1205195,'1','180',414,'Retail Sale Id 833358',0.00,1772.25,480.00,2001.60,229.35,'2021-09-10 17:43:17'),(1205204,'1','180',414,'Retail Sale Id 833364',0.00,2392.75,480.00,2702.40,309.65,'2021-09-10 17:46:22'),(1207143,'1','180',414,'Retail Sale Id 835754',0.00,49300.00,462.00,53592.00,4292.00,'2021-09-11 11:55:05'),(1207248,'1','180',414,'Retail Sale Id 835859',0.00,2550.00,480.00,2880.00,330.00,'2021-09-11 12:14:05'),(1207279,'1','180',414,'Retail Sale Id 835886',0.00,850.00,480.00,960.00,110.00,'2021-09-11 12:19:58'),(1207388,'1','180',414,'Retail Sale Id 836000',0.00,51000.00,462.00,55440.00,4440.00,'2021-09-11 12:35:56'),(1207421,'1','180',414,'Retail Sale Id 836031',0.00,63750.00,462.00,69300.00,5550.00,'2021-09-11 12:41:12'),(1207464,'1','180',414,'Retail Sale Id 836127',0.00,5312.50,480.00,6000.00,687.50,'2021-09-11 12:52:19'),(1207476,'1','180',414,'Retail Sale Id 836137',0.00,5100.00,480.00,5760.00,660.00,'2021-09-11 12:54:14'),(1207499,'1','180',414,'Retail Sale Id 836147',0.00,5312.50,480.00,6000.00,687.50,'2021-09-11 12:58:24'),(1207520,'1','180',414,'Retail Sale Id 836211',0.00,5100.00,480.00,5760.00,660.00,'2021-09-11 13:01:46'),(1207549,'1','180',414,'Retail Sale Id 836279',0.00,4590.00,480.00,5184.00,594.00,'2021-09-11 13:05:21'),(1207563,'1','180',414,'Retail Sale Id 836309',0.00,3825.00,480.00,4320.00,495.00,'2021-09-11 13:07:38'),(1207580,'1','180',414,'Retail Sale Id 836329',0.00,5100.00,480.00,5760.00,660.00,'2021-09-11 13:11:11'),(1207720,'1','180',414,'Retail Sale Id 836476',0.00,4250.00,480.00,4800.00,550.00,'2021-09-11 13:38:43'),(1208527,'1','180',414,'Retail Sale Id 837745',0.00,4250.00,480.00,4800.00,550.00,'2021-09-11 16:16:53'),(1208567,'1','180',414,'Retail Sale Id 837807',0.00,2125.00,480.00,2400.00,275.00,'2021-09-11 16:24:18'),(1208585,'1','180',414,'Retail Sale Id 837860',0.00,3825.00,480.00,4320.00,495.00,'2021-09-11 16:27:54'),(1208683,'1','180',414,'Retail Sale Id 837997',0.00,1275.00,480.00,1440.00,165.00,'2021-09-11 16:47:47'),(1208720,'1','180',414,'Retail Sale Id 838025',0.00,2550.00,480.00,2880.00,330.00,'2021-09-11 16:56:41'),(1208757,'1','180',414,'Retail Sale Id 838071',0.00,2550.00,480.00,2880.00,330.00,'2021-09-11 17:07:07'),(1208778,'1','180',414,'Retail Sale Id 838079',0.00,5312.50,480.00,6000.00,687.50,'2021-09-11 17:13:01'),(1208860,'1','180',414,'Retail Sale Id 838206',0.00,1275.00,480.00,1440.00,165.00,'2021-09-11 17:55:58'),(1208869,'1','180',414,'Retail Sale Id 838213',0.00,1275.00,480.00,1440.00,165.00,'2021-09-11 18:22:48'),(1211638,'1','180',414,'Retail Sale Id 841700',0.00,28050.00,462.00,30492.00,2442.00,'2021-09-12 15:12:20'),(1226858,'1','180',414,'Retail Sale Id 863210',0.00,1371.00,540.00,1620.00,249.00,'2021-09-16 16:27:43'),(1227018,'1','180',414,'Retail Sale Id 863382',0.00,2742.00,540.00,3240.00,498.00,'2021-09-16 17:05:04'),(1227022,'1','180',414,'Retail Sale Id 863386',0.00,2742.00,540.00,3240.00,498.00,'2021-09-16 17:06:42'),(1227029,'1','180',414,'Retail Sale Id 863393',0.00,4570.00,540.00,5400.00,830.00,'2021-09-16 17:08:21'),(1227032,'1','180',414,'Retail Sale Id 863397',0.00,2285.00,540.00,2700.00,415.00,'2021-09-16 17:09:49'),(1227042,'1','180',414,'Retail Sale Id 863408',0.00,2102.20,540.00,2484.00,381.80,'2021-09-16 17:13:12'),(1227051,'1','180',414,'Retail Sale Id 863415',0.00,2285.00,540.00,2700.00,415.00,'2021-09-16 17:14:53'),(1227055,'1','180',414,'Retail Sale Id 863419',0.00,2742.00,540.00,3240.00,498.00,'2021-09-16 17:16:08'),(1227061,'1','180',414,'Retail Sale Id 863425',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-16 17:17:25'),(1227066,'1','180',414,'Retail Sale Id 863431',0.00,1828.00,540.00,2160.00,332.00,'2021-09-16 17:18:37'),(1227075,'1','180',414,'Retail Sale Id 863438',0.00,3199.00,540.00,3780.00,581.00,'2021-09-16 17:20:19'),(1227081,'1','180',414,'Retail Sale Id 863445',0.00,73120.00,500.00,80000.00,6880.00,'2021-09-16 17:22:39'),(1227090,'1','180',414,'Retail Sale Id 863499',0.00,274200.00,500.00,300000.00,25800.00,'2021-09-16 17:30:10'),(1229410,'1','180',414,'Retail Sale Id 866688',0.00,2540.92,540.00,3002.40,461.48,'2021-09-17 13:42:31'),(1229455,'1','180',414,'Retail Sale Id 866700',0.00,2102.20,540.00,2484.00,381.80,'2021-09-17 13:51:00'),(1229464,'1','180',414,'Retail Sale Id 866737',0.00,5027.00,540.00,5940.00,913.00,'2021-09-17 13:53:00'),(1229473,'1','180',414,'Retail Sale Id 866744',0.00,2285.00,540.00,2700.00,415.00,'2021-09-17 13:54:34'),(1229480,'1','180',414,'Retail Sale Id 866750',0.00,2742.00,540.00,3240.00,498.00,'2021-09-17 13:56:15'),(1229945,'1','180',414,'Retail Sale Id 867346',0.00,685.50,540.00,810.00,124.50,'2021-09-17 15:26:27'),(1229968,'1','180',414,'Retail Sale Id 867373',0.00,2742.00,540.00,3240.00,498.00,'2021-09-17 15:32:39'),(1230094,'1','180',414,'Retail Sale Id 867619',0.00,2285.00,540.00,2700.00,415.00,'2021-09-17 15:55:08'),(1230207,'1','180',414,'Retail Sale Id 867998',0.00,1371.00,540.00,1620.00,249.00,'2021-09-17 16:53:02'),(1230236,'1','180',414,'Retail Sale Id 868117',0.00,2742.00,540.00,3240.00,498.00,'2021-09-17 17:13:57'),(1230252,'1','180',414,'Retail Sale Id 868143',0.00,3975.90,540.00,4698.00,722.10,'2021-09-17 17:25:26'),(1230259,'1','180',414,'Retail Sale Id 868150',0.00,1690.90,540.00,1998.00,307.10,'2021-09-17 17:30:14'),(1230264,'1','180',414,'Retail Sale Id 868184',0.00,1371.00,540.00,1620.00,249.00,'2021-09-17 17:40:14'),(1230351,'1','180',414,'Retail Sale Id 868239',0.00,1371.00,540.00,1620.00,249.00,'2021-09-17 18:54:03'),(1230352,'1','180',414,'Retail Sale Id 868240',0.00,411300.00,500.00,450000.00,38700.00,'2021-09-17 18:55:53'),(1233252,'1','180',414,'Retail Sale Id 873976',0.00,1690.90,540.00,1998.00,307.10,'2021-09-18 16:20:44'),(1233258,'1','180',414,'Retail Sale Id 873984',0.00,1828.00,540.00,2160.00,332.00,'2021-09-18 16:22:06'),(1233262,'1','180',414,'Retail Sale Id 873990',0.00,2285.00,540.00,2700.00,415.00,'2021-09-18 16:23:16'),(1233274,'1','180',414,'Retail Sale Id 874016',0.00,2742.00,540.00,3240.00,498.00,'2021-09-18 16:27:13'),(1233278,'1','180',414,'Retail Sale Id 874022',0.00,4570.00,540.00,5400.00,830.00,'2021-09-18 16:28:57'),(1233282,'1','180',414,'Retail Sale Id 874033',0.00,5255.50,540.00,6210.00,954.50,'2021-09-18 16:30:11'),(1233291,'1','180',414,'Retail Sale Id 874045',0.00,4113.00,540.00,4860.00,747.00,'2021-09-18 16:32:16'),(1233306,'1','180',414,'Retail Sale Id 874073',0.00,1371.00,540.00,1620.00,249.00,'2021-09-18 16:36:22'),(1233347,'1','180',414,'Retail Sale Id 874107',0.00,228500.00,500.00,250000.00,21500.00,'2021-09-18 16:44:29'),(1233365,'1','180',414,'Retail Sale Id 874126',0.00,150810.00,500.00,165000.00,14190.00,'2021-09-18 16:47:53'),(1233376,'1','180',414,'Retail Sale Id 874138',0.00,53012.00,500.00,58000.00,4988.00,'2021-09-18 16:50:57'),(1233380,'1','180',414,'Retail Sale Id 874142',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-18 16:52:41'),(1233394,'1','180',414,'Retail Sale Id 874153',0.00,2742.00,540.00,3240.00,498.00,'2021-09-18 16:59:01'),(1233431,'1','180',414,'Retail Sale Id 874186',0.00,763.19,540.00,901.80,138.61,'2021-09-18 17:16:40'),(1233440,'1','180',414,'Retail Sale Id 874195',0.00,2742.00,540.00,3240.00,498.00,'2021-09-18 17:23:09'),(1233540,'1','180',414,'Retail Sale Id 874276',0.00,2742.00,540.00,3240.00,498.00,'2021-09-18 18:32:26'),(1236858,'1','180',414,'Retail Sale Id 878724',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-19 17:47:46'),(1236860,'1','180',414,'Retail Sale Id 878726',0.00,2285.00,540.00,2700.00,415.00,'2021-09-19 17:49:10'),(1236861,'1','180',414,'Retail Sale Id 878727',0.00,2742.00,540.00,3240.00,498.00,'2021-09-19 17:50:28'),(1236862,'1','180',414,'Retail Sale Id 878729',0.00,2742.00,540.00,3240.00,498.00,'2021-09-19 17:51:44'),(1236865,'1','180',414,'Retail Sale Id 878738',0.00,4661.40,540.00,5508.00,846.60,'2021-09-19 17:53:20'),(1236866,'1','180',414,'Retail Sale Id 878739',0.00,141670.00,500.00,155000.00,13330.00,'2021-09-19 17:57:06'),(1240034,'1','180',414,'Retail Sale Id 882666',0.00,48670.50,540.00,57510.00,8839.50,'2021-09-20 18:54:24'),(1240035,'1','180',414,'Retail Sale Id 882667',0.00,22850.00,500.00,25000.00,2150.00,'2021-09-20 19:00:16'),(1243423,'1','180',414,'Retail Sale Id 887477',0.00,2742.00,540.00,3240.00,498.00,'2021-09-21 18:51:22'),(1243426,'1','180',414,'Retail Sale Id 887483',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-21 18:53:29'),(1243428,'1','180',414,'Retail Sale Id 887488',0.00,3656.00,540.00,4320.00,664.00,'2021-09-21 18:54:19'),(1243430,'1','180',414,'Retail Sale Id 887490',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-21 18:55:53'),(1243433,'1','180',414,'Retail Sale Id 887491',0.00,1690.90,540.00,1998.00,307.10,'2021-09-21 18:56:41'),(1243434,'1','180',414,'Retail Sale Id 887492',0.00,1828.00,540.00,2160.00,332.00,'2021-09-21 18:57:29'),(1243436,'1','180',414,'Retail Sale Id 887494',0.00,457.00,540.00,540.00,83.00,'2021-09-21 18:58:49'),(1243437,'1','180',414,'Retail Sale Id 887495',0.00,127960.00,500.00,140000.00,12040.00,'2021-09-21 18:59:46'),(1245514,'1','180',414,'Retail Sale Id 890173',0.00,2742.00,540.00,3240.00,498.00,'2021-09-22 15:33:26'),(1245523,'1','180',414,'Retail Sale Id 890182',0.00,2742.00,540.00,3240.00,498.00,'2021-09-22 15:35:06'),(1245535,'1','180',414,'Retail Sale Id 890194',0.00,845.45,540.00,999.00,153.55,'2021-09-22 15:36:55'),(1245542,'1','180',414,'Retail Sale Id 890202',0.00,1371.00,540.00,1620.00,249.00,'2021-09-22 15:38:26'),(1245549,'1','180',414,'Retail Sale Id 890210',0.00,1142.50,540.00,1350.00,207.50,'2021-09-22 15:40:21'),(1245563,'1','180',414,'Retail Sale Id 890221',0.00,1371.00,540.00,1620.00,249.00,'2021-09-22 15:42:34'),(1245569,'1','180',414,'Retail Sale Id 890228',0.00,845.45,540.00,999.00,153.55,'2021-09-22 15:43:42'),(1245574,'1','180',414,'Retail Sale Id 890235',0.00,2285.00,540.00,2700.00,415.00,'2021-09-22 15:44:53'),(1245722,'1','180',414,'Retail Sale Id 890399',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-22 16:13:36'),(1245730,'1','180',414,'Retail Sale Id 890405',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-22 16:15:01'),(1245742,'1','180',414,'Retail Sale Id 890422',0.00,2742.00,540.00,3240.00,498.00,'2021-09-22 16:18:18'),(1245744,'1','180',414,'Retail Sale Id 890426',0.00,2742.00,540.00,3240.00,498.00,'2021-09-22 16:19:10'),(1245759,'1','180',414,'Retail Sale Id 890444',0.00,22850.00,500.00,25000.00,2150.00,'2021-09-22 16:21:26'),(1245815,'1','180',414,'Retail Sale Id 890516',0.00,22850.00,500.00,25000.00,2150.00,'2021-09-22 16:31:59'),(1245833,'1','180',414,'Retail Sale Id 890536',0.00,2285.00,540.00,2700.00,415.00,'2021-09-22 16:33:55'),(1245994,'1','180',414,'Retail Sale Id 890932',0.00,2285.00,540.00,2700.00,415.00,'2021-09-22 17:19:17'),(1246035,'1','180',414,'Retail Sale Id 890981',0.00,2285.00,540.00,2700.00,415.00,'2021-09-22 17:35:01'),(1246047,'1','180',414,'Retail Sale Id 890997',0.00,26506.00,500.00,29000.00,2494.00,'2021-09-22 17:41:34'),(1246076,'1','180',414,'Retail Sale Id 891028',0.00,26506.00,500.00,29000.00,2494.00,'2021-09-22 17:57:24'),(1246094,'1','180',414,'Retail Sale Id 891055',0.00,1371.00,540.00,1620.00,249.00,'2021-09-22 18:16:46'),(1246101,'1','180',414,'Retail Sale Id 891061',0.00,1371.00,540.00,1620.00,249.00,'2021-09-22 18:26:33'),(1249446,'1','180',414,'Retail Sale Id 895178',0.00,2742.00,540.00,3240.00,498.00,'2021-09-23 17:15:32'),(1249597,'1','180',414,'Retail Sale Id 895316',0.00,33955.10,540.00,40122.00,6166.90,'2021-09-23 19:45:43'),(1249598,'1','180',414,'Retail Sale Id 895317',0.00,82260.00,500.00,90000.00,7740.00,'2021-09-23 19:46:40'),(1253124,'1','180',414,'Retail Sale Id 900495',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-24 18:42:02'),(1253125,'1','180',414,'Retail Sale Id 900496',0.00,11425.00,540.00,13500.00,2075.00,'2021-09-24 18:43:03'),(1253128,'1','180',414,'Retail Sale Id 900499',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-24 18:44:49'),(1253129,'1','180',414,'Retail Sale Id 900500',0.00,14395.50,540.00,17010.00,2614.50,'2021-09-24 18:45:45'),(1253130,'1','180',414,'Retail Sale Id 900501',0.00,1142.50,540.00,1350.00,207.50,'2021-09-24 18:47:40'),(1256620,'1','180',414,'Retail Sale Id 905092',0.00,191940.00,500.00,210000.00,18060.00,'2021-09-25 22:49:44'),(1256621,'1','180',414,'Retail Sale Id 905093',0.00,5712.50,540.00,6750.00,1037.50,'2021-09-25 22:52:43'),(1259600,'1','180',414,'Retail Sale Id 909687',0.00,4570.00,540.00,5400.00,830.00,'2021-09-26 18:23:59'),(1259601,'1','180',414,'Retail Sale Id 909688',0.00,5484.00,540.00,6480.00,996.00,'2021-09-26 18:25:34'),(1259604,'1','180',414,'Retail Sale Id 909691',0.00,4113.00,540.00,4860.00,747.00,'2021-09-26 18:27:04'),(1259606,'1','180',414,'Retail Sale Id 909693',0.00,2742.00,540.00,3240.00,498.00,'2021-09-26 18:28:42'),(1259614,'1','180',414,'Retail Sale Id 909719',0.00,45700.00,500.00,50000.00,4300.00,'2021-09-26 18:38:47'),(1259620,'1','180',414,'Retail Sale Id 909720',0.00,14395.50,540.00,17010.00,2614.50,'2021-09-26 18:45:30'),(1260669,'1','180',414,'Retail Sale Id 910975',0.00,24100.00,500.00,25000.00,900.00,'2021-09-27 10:11:51'),(1262336,'1','180',414,'Retail Sale Id 913285',0.00,2892.00,540.00,3240.00,348.00,'2021-09-27 15:39:04'),(1262497,'1','180',414,'Retail Sale Id 913666',0.00,1783.40,540.00,1998.00,214.60,'2021-09-27 16:10:23'),(1262534,'1','180',414,'Retail Sale Id 913735',0.00,5784.00,540.00,6480.00,696.00,'2021-09-27 16:22:51'),(1262729,'1','180',414,'Retail Sale Id 914307',0.00,58707.60,540.00,65772.00,7064.40,'2021-09-27 19:25:16'),(1265609,'1','180',414,'Retail Sale Id 918658',0.00,29932.20,540.00,33534.00,3601.80,'2021-09-28 18:32:12'),(1265611,'1','180',414,'Retail Sale Id 918700',0.00,79530.00,500.00,82500.00,2970.00,'2021-09-28 18:35:18'),(1265615,'1','180',414,'Retail Sale Id 918704',0.00,144600.00,500.00,150000.00,5400.00,'2021-09-28 18:36:50'),(1265616,'1','180',414,'Retail Sale Id 918708',0.00,120500.00,500.00,125000.00,4500.00,'2021-09-28 18:38:31'),(1268507,'1','180',414,'Retail Sale Id 921824',0.00,8194.00,540.00,9180.00,986.00,'2021-09-29 18:46:57'),(1268508,'1','180',414,'Retail Sale Id 921825',0.00,6555.20,540.00,7344.00,788.80,'2021-09-29 18:47:56'),(1268509,'1','180',414,'Retail Sale Id 921826',0.00,9640.00,540.00,10800.00,1160.00,'2021-09-29 18:49:11'),(1268510,'1','180',414,'Retail Sale Id 921827',0.00,16580.80,540.00,18576.00,1995.20,'2021-09-29 18:49:57'),(1268511,'1','180',414,'Retail Sale Id 921828',0.00,120500.00,500.00,125000.00,4500.00,'2021-09-29 18:51:07'),(1268513,'1','180',414,'Retail Sale Id 921831',0.00,48200.00,500.00,50000.00,1800.00,'2021-09-29 18:54:43'),(1271668,'1','180',414,'Retail Sale Id 925455',0.00,49453.20,540.00,55404.00,5950.80,'2021-09-30 20:58:05'),(1271669,'1','180',414,'Retail Sale Id 925456',0.00,24100.00,500.00,25000.00,900.00,'2021-09-30 20:59:25'),(1274956,'1','180',414,'Retail Sale Id 928955',0.00,56779.60,560.00,65968.00,9188.40,'2021-10-01 21:13:24'),(1277798,'1','180',414,'Retail Sale Id 932386',0.00,1446.00,560.00,1680.00,234.00,'2021-10-02 15:24:27'),(1277985,'1','180',414,'Retail Sale Id 932567',0.00,113270.00,518.00,121730.00,8460.00,'2021-10-02 15:53:23'),(1278602,'1','180',414,'Retail Sale Id 933303',0.00,53020.00,560.00,61600.00,8580.00,'2021-10-02 22:09:54'),(1281562,'1','180',414,'Retail Sale Id 936600',0.00,192800.00,518.00,207200.00,14400.00,'2021-10-03 20:35:11'),(1281564,'1','180',414,'Retail Sale Id 936602',0.00,34559.40,560.00,40152.00,5592.60,'2021-10-03 20:36:03'),(1281567,'1','180',414,'Retail Sale Id 936606',0.00,24100.00,518.00,25900.00,1800.00,'2021-10-03 20:38:30'),(1283038,'1','180',414,'Retail Sale Id 938099',0.00,1446.00,560.00,1680.00,234.00,'2021-10-04 12:19:02'),(1283042,'1','180',414,'Retail Sale Id 938102',0.00,2410.00,560.00,2800.00,390.00,'2021-10-04 12:19:46'),(1283052,'1','180',414,'Retail Sale Id 938111',0.00,2838.98,560.00,3298.40,459.42,'2021-10-04 12:21:20'),(1283176,'1','180',414,'Retail Sale Id 938241',0.00,2892.00,560.00,3360.00,468.00,'2021-10-04 12:52:32'),(1283184,'1','180',414,'Retail Sale Id 938249',0.00,1446.00,560.00,1680.00,234.00,'2021-10-04 12:54:42'),(1283431,'1','180',414,'Retail Sale Id 938493',0.00,1253.20,560.00,1456.00,202.80,'2021-10-04 13:47:40'),(1283442,'1','180',414,'Retail Sale Id 938501',0.00,1205.00,560.00,1400.00,195.00,'2021-10-04 13:48:55'),(1283450,'1','180',414,'Retail Sale Id 938510',0.00,6025.00,560.00,7000.00,975.00,'2021-10-04 13:49:59'),(1283454,'1','180',414,'Retail Sale Id 938514',0.00,771.20,560.00,896.00,124.80,'2021-10-04 13:51:31'),(1283456,'1','180',414,'Retail Sale Id 938518',0.00,2410.00,560.00,2800.00,390.00,'2021-10-04 13:52:23'),(1283463,'1','180',414,'Retail Sale Id 938521',0.00,1253.20,560.00,1456.00,202.80,'2021-10-04 13:53:15'),(1283469,'1','180',414,'Retail Sale Id 938526',0.00,1446.00,560.00,1680.00,234.00,'2021-10-04 13:54:03'),(1284501,'1','180',414,'Retail Sale Id 939955',0.00,214490.00,518.00,230510.00,16020.00,'2021-10-04 18:05:07'),(1288226,'1','180',414,'Retail Sale Id 944491',0.00,2410.00,560.00,2800.00,390.00,'2021-10-05 18:19:08'),(1288231,'1','180',414,'Retail Sale Id 944497',0.00,96400.00,518.00,103600.00,7200.00,'2021-10-05 18:20:57'),(1288235,'1','180',414,'Retail Sale Id 944498',0.00,77120.00,518.00,82880.00,5760.00,'2021-10-05 18:22:12'),(1288237,'1','180',414,'Retail Sale Id 944500',0.00,28727.20,560.00,33376.00,4648.80,'2021-10-05 18:23:47'),(1291272,'1','180',414,'Retail Sale Id 948364',0.00,135924.00,537.00,151434.00,15510.00,'2021-10-06 22:41:47'),(1291274,'1','180',414,'Retail Sale Id 948366',0.00,46995.00,584.00,56940.00,9945.00,'2021-10-06 22:42:42'),(1294423,'1','180',414,'Retail Sale Id 952571',0.00,2410.00,584.00,2920.00,510.00,'2021-10-07 17:39:24'),(1294427,'1','180',414,'Retail Sale Id 952574',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-07 17:40:43'),(1294430,'1','180',414,'Retail Sale Id 952578',0.00,2892.00,584.00,3504.00,612.00,'2021-10-07 17:41:53'),(1294431,'1','180',414,'Retail Sale Id 952579',0.00,2892.00,584.00,3504.00,612.00,'2021-10-07 17:43:13'),(1294434,'1','180',414,'Retail Sale Id 952581',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-07 17:44:39'),(1294435,'1','180',414,'Retail Sale Id 952582',0.00,6362.40,584.00,7708.80,1346.40,'2021-10-07 17:45:15'),(1294440,'1','180',414,'Retail Sale Id 952586',0.00,55912.00,537.00,62292.00,6380.00,'2021-10-07 17:46:31'),(1294447,'1','180',414,'Retail Sale Id 952591',0.00,2892.00,584.00,3504.00,612.00,'2021-10-07 17:51:56'),(1294449,'1','180',414,'Retail Sale Id 952596',0.00,5157.40,584.00,6248.80,1091.40,'2021-10-07 17:56:44'),(1294506,'1','180',414,'Retail Sale Id 952648',0.00,4820.00,584.00,5840.00,1020.00,'2021-10-07 18:43:04'),(1295222,'1','180',414,'Retail Sale Id 953863',0.00,2892.00,584.00,3504.00,612.00,'2021-10-08 08:12:19'),(1295452,'1','180',414,'Retail Sale Id 954234',0.00,2892.00,584.00,3504.00,612.00,'2021-10-08 08:55:48'),(1295457,'1','180',414,'Retail Sale Id 954244',0.00,3856.00,584.00,4672.00,816.00,'2021-10-08 08:57:01'),(1295580,'1','180',414,'Retail Sale Id 954406',0.00,2892.00,584.00,3504.00,612.00,'2021-10-08 09:25:21'),(1295781,'1','180',414,'Retail Sale Id 954674',0.00,2410.00,584.00,2920.00,510.00,'2021-10-08 09:59:31'),(1296402,'1','180',414,'Retail Sale Id 955743',0.00,1402.62,584.00,1699.44,296.82,'2021-10-08 12:08:38'),(1296406,'1','180',414,'Retail Sale Id 955747',0.00,1446.00,584.00,1752.00,306.00,'2021-10-08 12:09:33'),(1296408,'1','180',414,'Retail Sale Id 955751',0.00,1402.62,584.00,1699.44,296.82,'2021-10-08 12:10:20'),(1296424,'1','180',414,'Retail Sale Id 955772',0.00,24100.00,537.00,26850.00,2750.00,'2021-10-08 12:13:46'),(1298068,'1','180',414,'Retail Sale Id 958768',0.00,5784.00,584.00,7008.00,1224.00,'2021-10-08 18:01:44'),(1298070,'1','180',414,'Retail Sale Id 958779',0.00,5784.00,584.00,7008.00,1224.00,'2021-10-08 18:03:14'),(1298074,'1','180',414,'Retail Sale Id 958796',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-08 18:06:29'),(1298075,'1','180',414,'Retail Sale Id 958803',0.00,4820.00,584.00,5840.00,1020.00,'2021-10-08 18:07:08'),(1298077,'1','180',414,'Retail Sale Id 958809',0.00,5061.00,584.00,6132.00,1071.00,'2021-10-08 18:08:12'),(1298087,'1','180',414,'Retail Sale Id 958873',0.00,2892.00,584.00,3504.00,612.00,'2021-10-08 18:28:33'),(1300151,'1','180',414,'Retail Sale Id 962404',0.00,1648.44,584.00,1997.28,348.84,'2021-10-09 11:29:12'),(1300157,'1','180',414,'Retail Sale Id 962425',0.00,1928.00,584.00,2336.00,408.00,'2021-10-09 11:30:10'),(1300164,'1','180',414,'Retail Sale Id 962442',0.00,1446.00,584.00,1752.00,306.00,'2021-10-09 11:31:05'),(1300172,'1','180',414,'Retail Sale Id 962457',0.00,2892.00,584.00,3504.00,612.00,'2021-10-09 11:31:48'),(1300179,'1','180',414,'Retail Sale Id 962478',0.00,1446.00,584.00,1752.00,306.00,'2021-10-09 11:33:37'),(1300340,'1','180',414,'Retail Sale Id 962794',0.00,2892.00,584.00,3504.00,612.00,'2021-10-09 11:56:34'),(1300354,'1','180',414,'Retail Sale Id 962810',0.00,2892.00,584.00,3504.00,612.00,'2021-10-09 11:58:17'),(1300705,'1','180',414,'Retail Sale Id 963391',0.00,2062.96,584.00,2499.52,436.56,'2021-10-09 13:07:35'),(1301031,'1','180',414,'Retail Sale Id 964074',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-09 14:26:37'),(1301884,'1','180',414,'Retail Sale Id 965485',0.00,5302.00,584.00,6424.00,1122.00,'2021-10-09 19:09:58'),(1301885,'1','180',414,'Retail Sale Id 965487',0.00,1446.00,584.00,1752.00,306.00,'2021-10-09 19:10:59'),(1301888,'1','180',414,'Retail Sale Id 965488',0.00,72300.00,537.00,80550.00,8250.00,'2021-10-09 19:12:10'),(1302953,'1','180',414,'Retail Sale Id 967832',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-10 09:47:06'),(1302962,'1','180',414,'Retail Sale Id 967843',0.00,964.00,584.00,1168.00,204.00,'2021-10-10 09:48:22'),(1302976,'1','180',414,'Retail Sale Id 967869',0.00,2477.48,584.00,3001.76,524.28,'2021-10-10 09:49:51'),(1302980,'1','180',414,'Retail Sale Id 967875',0.00,2892.00,584.00,3504.00,612.00,'2021-10-10 09:50:28'),(1302987,'1','180',414,'Retail Sale Id 967883',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-10 09:51:12'),(1302993,'1','180',414,'Retail Sale Id 967893',0.00,964.00,584.00,1168.00,204.00,'2021-10-10 09:51:52'),(1303127,'1','180',414,'Retail Sale Id 968149',0.00,2892.00,584.00,3504.00,612.00,'2021-10-10 10:15:03'),(1303138,'1','180',414,'Retail Sale Id 968158',0.00,824.22,584.00,998.64,174.42,'2021-10-10 10:16:24'),(1303349,'1','180',414,'Retail Sale Id 968523',0.00,964.00,584.00,1168.00,204.00,'2021-10-10 10:53:43'),(1303363,'1','180',414,'Retail Sale Id 968540',0.00,1446.00,584.00,1752.00,306.00,'2021-10-10 10:55:56'),(1303739,'1','180',414,'Retail Sale Id 969105',0.00,6025.00,584.00,7300.00,1275.00,'2021-10-10 12:02:55'),(1304477,'1','180',414,'Retail Sale Id 970346',0.00,1446.00,584.00,1752.00,306.00,'2021-10-10 14:49:52'),(1304678,'1','180',414,'Retail Sale Id 970711',0.00,53020.00,537.00,59070.00,6050.00,'2021-10-10 15:34:17'),(1304687,'1','180',414,'Retail Sale Id 970723',0.00,24100.00,537.00,26850.00,2750.00,'2021-10-10 15:35:45'),(1307241,'1','180',414,'Sale Id 324082',0.00,250047.14,382.00,198170.14,-51877.00,'2021-10-11 12:56:46'),(1307282,'1','180',414,'Retail Sale Id 974540',0.00,250047.14,400.00,207508.00,-42539.14,'2021-10-11 13:02:46'),(1307567,'1','180',414,'Sale Id 324111',0.00,125874.30,384.00,100281.60,-25592.70,'2021-10-11 13:57:24'),(1308787,'1','180',414,'Retail Sale Id 976640',0.00,57420.00,537.00,59070.00,1650.00,'2021-10-11 18:34:23'),(1308790,'1','180',414,'Retail Sale Id 976643',0.00,99180.00,537.00,102030.00,2850.00,'2021-10-11 18:42:23'),(1308794,'1','180',414,'Retail Sale Id 976646',0.00,27457.20,584.00,30718.40,3261.20,'2021-10-11 18:45:39'),(1309845,'1','180',414,'Retail Sale Id 978751',0.00,3132.00,584.00,3504.00,372.00,'2021-10-12 09:46:32'),(1309876,'1','180',414,'Retail Sale Id 978879',0.00,3132.00,584.00,3504.00,372.00,'2021-10-12 09:56:53'),(1309904,'1','180',414,'Retail Sale Id 978912',0.00,3132.00,584.00,3504.00,372.00,'2021-10-12 10:06:11'),(1310674,'1','180',414,'Retail Sale Id 980295',0.00,2401.20,584.00,2686.40,285.20,'2021-10-12 13:41:32'),(1310679,'1','180',414,'Retail Sale Id 980302',0.00,2610.00,584.00,2920.00,310.00,'2021-10-12 13:43:18'),(1310689,'1','180',414,'Retail Sale Id 980311',0.00,1566.00,584.00,1752.00,186.00,'2021-10-12 13:45:03'),(1310696,'1','180',414,'Retail Sale Id 980321',0.00,4698.00,584.00,5256.00,558.00,'2021-10-12 13:46:39'),(1310717,'1','180',414,'Retail Sale Id 980353',0.00,1566.00,584.00,1752.00,186.00,'2021-10-12 13:49:35'),(1310727,'1','180',414,'Retail Sale Id 980370',0.00,1566.00,584.00,1752.00,186.00,'2021-10-12 13:51:35'),(1311185,'1','180',414,'Retail Sale Id 981376',0.00,1044.00,584.00,1168.00,124.00,'2021-10-12 15:45:19'),(1311193,'1','180',414,'Retail Sale Id 981397',0.00,2610.00,584.00,2920.00,310.00,'2021-10-12 15:46:50'),(1311202,'1','180',414,'Retail Sale Id 981423',0.00,6525.00,584.00,7300.00,775.00,'2021-10-12 15:48:45'),(1311207,'1','180',414,'Retail Sale Id 981450',0.00,1566.00,584.00,1752.00,186.00,'2021-10-12 15:50:33'),(1311663,'1','180',414,'Retail Sale Id 982949',0.00,2610.00,584.00,2920.00,310.00,'2021-10-12 18:15:52'),(1311667,'1','180',414,'Retail Sale Id 982959',0.00,3132.00,584.00,3504.00,372.00,'2021-10-12 18:17:13'),(1311669,'1','180',414,'Retail Sale Id 982964',0.00,1305.00,584.00,1460.00,155.00,'2021-10-12 18:18:04'),(1311672,'1','180',414,'Retail Sale Id 982967',0.00,6525.00,584.00,7300.00,775.00,'2021-10-12 18:18:57'),(1311675,'1','180',414,'Retail Sale Id 982993',0.00,3132.00,584.00,3504.00,372.00,'2021-10-12 18:23:58'),(1311676,'1','180',414,'Retail Sale Id 982996',0.00,4176.00,584.00,4672.00,496.00,'2021-10-12 18:24:55'),(1313249,'1','180',414,'Retail Sale Id 986300',0.00,2088.00,584.00,2336.00,248.00,'2021-10-13 12:29:28'),(1313253,'1','180',414,'Retail Sale Id 986305',0.00,6525.00,584.00,7300.00,775.00,'2021-10-13 12:30:21'),(1313258,'1','180',414,'Retail Sale Id 986312',0.00,2610.00,584.00,2920.00,310.00,'2021-10-13 12:31:11'),(1313261,'1','180',414,'Retail Sale Id 986315',0.00,3132.00,584.00,3504.00,372.00,'2021-10-13 12:31:53'),(1313266,'1','180',414,'Retail Sale Id 986321',0.00,1566.00,584.00,1752.00,186.00,'2021-10-13 12:32:48'),(1313273,'1','180',414,'Retail Sale Id 986328',0.00,5220.00,584.00,5840.00,620.00,'2021-10-13 12:33:47'),(1313278,'1','180',414,'Retail Sale Id 986333',0.00,1566.00,584.00,1752.00,186.00,'2021-10-13 12:34:42'),(1313284,'1','180',414,'Retail Sale Id 986342',0.00,2683.08,584.00,3001.76,318.68,'2021-10-13 12:36:27'),(1313368,'1','180',414,'Retail Sale Id 986453',0.00,2234.16,584.00,2499.52,265.36,'2021-10-13 12:55:26'),(1313421,'1','180',414,'Retail Sale Id 986513',0.00,1785.24,584.00,1997.28,212.04,'2021-10-13 13:04:45'),(1314282,'1','180',414,'Retail Sale Id 987798',0.00,6525.00,584.00,7300.00,775.00,'2021-10-13 16:17:52'),(1314292,'1','180',414,'Retail Sale Id 987811',0.00,3132.00,584.00,3504.00,372.00,'2021-10-13 16:19:50'),(1314611,'1','180',414,'Retail Sale Id 988535',0.00,451530.00,537.00,464505.00,12975.00,'2021-10-13 18:03:41'),(1314614,'1','180',414,'Retail Sale Id 988541',0.00,6525.00,584.00,7300.00,775.00,'2021-10-13 18:04:40'),(1317014,'1','180',414,'Retail Sale Id 992968',0.00,3575.70,584.00,4000.40,424.70,'2021-10-14 15:39:04'),(1317022,'1','180',414,'Retail Sale Id 992998',0.00,6525.00,584.00,7300.00,775.00,'2021-10-14 15:40:47'),(1317031,'1','180',414,'Retail Sale Id 993011',0.00,1827.00,584.00,2044.00,217.00,'2021-10-14 15:42:06'),(1317038,'1','180',414,'Retail Sale Id 993030',0.00,1566.00,584.00,1752.00,186.00,'2021-10-14 15:43:11'),(1317044,'1','180',414,'Retail Sale Id 993039',0.00,1827.00,584.00,2044.00,217.00,'2021-10-14 15:43:53'),(1317070,'1','180',414,'Retail Sale Id 993099',0.00,3132.00,584.00,3504.00,372.00,'2021-10-14 15:48:37'),(1317098,'1','180',414,'Retail Sale Id 993163',0.00,2088.00,584.00,2336.00,248.00,'2021-10-14 15:53:17'),(1317101,'1','180',414,'Retail Sale Id 993174',0.00,1566.00,584.00,1752.00,186.00,'2021-10-14 15:54:23'),(1317145,'1','180',414,'Retail Sale Id 993291',0.00,2610.00,584.00,2920.00,310.00,'2021-10-14 16:01:53'),(1317253,'1','180',414,'Retail Sale Id 993696',0.00,6264.00,584.00,7008.00,744.00,'2021-10-14 16:30:07'),(1317263,'1','180',414,'Retail Sale Id 993710',0.00,4437.00,584.00,4964.00,527.00,'2021-10-14 16:31:54'),(1317268,'1','180',414,'Retail Sale Id 993714',0.00,1305.00,584.00,1460.00,155.00,'2021-10-14 16:32:35'),(1317273,'1','180',414,'Retail Sale Id 993721',0.00,1305.00,584.00,1460.00,155.00,'2021-10-14 16:33:27'),(1317278,'1','180',414,'Retail Sale Id 993729',0.00,1566.00,584.00,1752.00,186.00,'2021-10-14 16:34:02'),(1317282,'1','180',414,'Retail Sale Id 993735',0.00,1566.00,584.00,1752.00,186.00,'2021-10-14 16:34:32'),(1317284,'1','180',414,'Retail Sale Id 993736',0.00,3132.00,584.00,3504.00,372.00,'2021-10-14 16:35:07'),(1317290,'1','180',414,'Retail Sale Id 993746',0.00,57420.00,537.00,59070.00,1650.00,'2021-10-14 16:36:19'),(1317380,'1','180',414,'Retail Sale Id 993858',0.00,2610.00,584.00,2920.00,310.00,'2021-10-14 16:50:02'),(1317446,'1','180',414,'Retail Sale Id 993975',0.00,1566.00,584.00,1752.00,186.00,'2021-10-14 17:08:18'),(1317547,'1','180',414,'Retail Sale Id 994262',0.00,3132.00,584.00,3504.00,372.00,'2021-10-14 18:17:51'),(1317555,'1','180',414,'Retail Sale Id 994292',0.00,3132.00,584.00,3504.00,372.00,'2021-10-14 18:31:16'),(1318183,'1','180',414,'Retail Sale Id 995377',0.00,3132.00,584.00,3504.00,372.00,'2021-10-15 08:12:38'),(1318196,'1','180',414,'Retail Sale Id 995399',0.00,3132.00,584.00,3504.00,372.00,'2021-10-15 08:14:03'),(1318265,'1','180',414,'Retail Sale Id 995500',0.00,3132.00,584.00,3504.00,372.00,'2021-10-15 08:26:05'),(1318328,'1','180',414,'Retail Sale Id 995574',0.00,3132.00,584.00,3504.00,372.00,'2021-10-15 08:38:01'),(1318333,'1','180',414,'Retail Sale Id 995616',0.00,1566.00,584.00,1752.00,186.00,'2021-10-15 08:38:52'),(1318457,'1','180',414,'Retail Sale Id 995846',0.00,6525.00,584.00,7300.00,775.00,'2021-10-15 09:02:02'),(1318682,'1','180',414,'Retail Sale Id 996124',0.00,1044.00,584.00,1168.00,124.00,'2021-10-15 09:46:06'),(1318958,'1','180',414,'Retail Sale Id 996520',0.00,6525.00,584.00,7300.00,775.00,'2021-10-15 10:40:26'),(1319198,'1','180',414,'Retail Sale Id 996896',0.00,2610.00,584.00,2920.00,310.00,'2021-10-15 11:36:16'),(1319291,'1','180',414,'Retail Sale Id 997032',0.00,4698.00,584.00,5256.00,558.00,'2021-10-15 11:56:14'),(1319756,'1','180',414,'Retail Sale Id 997592',0.00,3132.00,584.00,3504.00,372.00,'2021-10-15 13:52:59'),(1319931,'1','180',414,'Retail Sale Id 997858',0.00,1566.00,584.00,1752.00,186.00,'2021-10-15 14:28:06'),(1320225,'1','180',414,'Retail Sale Id 998311',0.00,86130.00,537.00,88605.00,2475.00,'2021-10-15 15:29:16'),(1320285,'1','180',414,'Retail Sale Id 998395',0.00,1566.00,584.00,1752.00,186.00,'2021-10-15 15:39:31'),(1320412,'1','180',414,'Retail Sale Id 998570',0.00,26100.00,537.00,26850.00,750.00,'2021-10-15 16:01:45'),(1320448,'1','180',414,'Retail Sale Id 998629',0.00,1566.00,584.00,1752.00,186.00,'2021-10-15 16:09:04'),(1320474,'1','180',414,'Retail Sale Id 998659',0.00,28710.00,537.00,29535.00,825.00,'2021-10-15 16:13:39'),(1320712,'1','180',414,'Retail Sale Id 999015',0.00,2610.00,584.00,2920.00,310.00,'2021-10-15 17:12:24'),(1320717,'1','180',414,'Retail Sale Id 999018',0.00,1044.00,584.00,1168.00,124.00,'2021-10-15 17:13:30'),(1320729,'1','180',414,'Retail Sale Id 999034',0.00,1566.00,584.00,1752.00,186.00,'2021-10-15 17:16:40'),(1320735,'1','180',414,'Retail Sale Id 999097',0.00,1519.02,584.00,1699.44,180.42,'2021-10-15 17:22:35'),(1320777,'1','180',414,'Retail Sale Id 999272',0.00,4698.00,584.00,5256.00,558.00,'2021-10-15 17:58:42'),(1320786,'1','180',414,'Retail Sale Id 999315',0.00,2610.00,584.00,2920.00,310.00,'2021-10-15 18:22:08'),(1321666,'1','180',414,'Retail Sale Id 1001096',0.00,1566.00,584.00,1752.00,186.00,'2021-10-16 09:28:30'),(1321774,'1','180',414,'Retail Sale Id 1001276',0.00,892.62,584.00,998.64,106.02,'2021-10-16 09:51:37'),(1321791,'1','180',414,'Retail Sale Id 1001294',0.00,1566.00,584.00,1752.00,186.00,'2021-10-16 09:54:51'),(1321947,'1','180',414,'Retail Sale Id 1001562',0.00,1566.00,584.00,1752.00,186.00,'2021-10-16 10:25:11'),(1322013,'1','180',414,'Retail Sale Id 1001705',0.00,1566.00,584.00,1752.00,186.00,'2021-10-16 10:37:59'),(1322067,'1','180',414,'Retail Sale Id 1001826',0.00,6258.78,584.00,7002.16,743.38,'2021-10-16 10:48:46'),(1322077,'1','180',414,'Retail Sale Id 100184