-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_179
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_179`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_179` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_179`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3338 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3319,400118,'',0,'22','1','179','PURCHASES','','2021-05-08 11:20:32',5,0.00,0.00,'','479','2021-05-08 11:20:32','479',0,1),(3320,20049,'',0,'20','1','179','SALES','','2021-05-08 11:53:37',5,0.00,0.00,'','479','2021-05-08 11:53:37','479',0,1),(3321,400310,'',0,'24','1','179','SALARIES & WAGES','','2021-05-08 11:54:20',5,0.00,0.00,'','479','2021-05-08 11:54:20','479',0,1),(3322,400311,'',0,'24','1','179','PURCHASES','','2021-05-08 11:54:46',5,0.00,0.00,'','479','2021-05-08 11:54:46','479',0,1),(3323,40049,'',0,'6.1','1','179','CASH','','2021-05-08 11:55:22',5,0.00,0.00,'','479','2021-05-08 11:55:22','479',0,1),(3324,400555,'',0,'2','1','179','ZB(LPG)1014471475','','2021-05-08 11:57:07',5,0.00,0.00,'','479','2021-05-08 11:57:07','479',0,1),(3325,400556,'',0,'2','1','179','FB(IBAL)2023855223','','2021-05-08 11:57:57',5,0.00,0.00,'','479','2021-05-08 11:57:57','479',0,1),(3326,400557,'',0,'2','1','179','ZB 1015394845','','2021-05-08 11:59:00',5,0.00,0.00,'','479','2021-05-08 11:59:00','479',0,1),(3327,400558,'',0,'2','1','179','ZB 1015965423','','2021-05-08 11:59:54',5,0.00,0.00,'','479','2021-05-08 11:59:54','479',0,1),(3328,400559,'',0,'2','1','179','ZB 1015965375','','2021-05-08 12:01:32',5,0.00,0.00,'','479','2021-05-08 12:01:32','479',0,1),(3329,400560,'',0,'2','1','179','E-Bills 1015372548','','2021-05-08 12:02:08',5,0.00,0.00,'','479','2021-05-08 12:02:08','479',0,1),(3330,400561,'',0,'2','1','179','E-BILLS IBAL 1015372548','','2021-05-08 12:03:01',5,0.00,0.00,'','479','2021-05-08 12:03:01','479',0,1),(3331,400562,'',0,'2','1','179','ZENITH BANK POS','','2021-05-08 12:03:33',5,0.00,0.00,'','479','2021-05-08 12:03:33','479',0,1),(3332,400563,'',0,'2','1','179','UNITY BANK-0024061656','','2021-05-08 12:04:19',5,0.00,0.00,'','479','2021-05-08 12:04:19','479',0,1),(3333,400564,'',0,'2','1','179','DANKANO-EBILLS(ZNB:1014717618)','','2021-05-08 12:05:37',5,0.00,0.00,'','479','2021-05-08 12:05:37','479',0,1),(3334,400565,'',0,'2','1','179','UBA YOLA-1021398099','','2021-05-08 12:06:12',5,0.00,0.00,'','479','2021-05-08 12:06:12','479',0,1),(3335,400566,'',0,'2','1','179','FID POS COLLECTION-5620141491','','2021-05-08 12:06:53',5,0.00,0.00,'','479','2021-05-08 12:06:53','479',0,1),(3336,400567,'',0,'2','1','179','UBA POS LPG :-1025923936','UBA POS LPG ACCOUNT','2023-03-10 16:56:18',5,0.00,0.00,'','792','2023-03-10 16:56:18','792',0,0),(3337,400568,'',0,'2','1','179','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-17 12:30:57',5,0.00,0.00,'','792','2023-03-17 12:30:57','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2765 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2671,'','1','179','COSTOMER','COSTOMER','0000000000','costomer@email.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-12 11:24:32',5,'623','2021-05-12 11:24:32','623'),(2742,'','1','179','OPERATIONAL LOSS','KANO','08069129774','hafiz@aaranonigeria.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-06-13 14:50:49',5,'623','2021-06-13 14:50:49','623'),(2743,'','1','179','KB GAS','SOKOTO','09029120300','kbgassokoto@gmail.com','SOKOTO','SOKOTO','SAMA ROAD SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-14 08:33:30',5,'623','2022-05-14 08:33:30','623'),(2744,'','1','179','S RUFAI GAS','SOKOTO','0000000000','costomer@email.com','SOKOTO','SOKOTO','SAMA ROAD SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-05-18 16:48:59',5,'623','2022-05-18 16:48:59','623'),(2745,'','1','179','AHMAD MAHE GAS','SOKOTO','08139221674','maheegaz@gmail.com','SOKOTO','SOKOTO','BAFARAWA ESTATE SOKOTO ','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-04 17:27:26',5,'623','2022-06-04 17:27:26','623'),(2746,'','1','179','BENNA GAS','KEBBI','09029120300','bennagaz@gmail.com','KEBBI','KEBBI','BENNA VILLAGE','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-11 12:52:37',5,'623','2022-06-11 12:52:37','623'),(2747,'','1','179','RAAFA GAZ','SOKOTO','08037921107','raafagaz@gmail.com','SOKOTO','SOKOTO','KASUWAN NAKASARI SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-06-18 11:42:44',5,'623','2022-06-18 11:42:44','623'),(2748,'','1','179','YAURI GAZ','KEBBI','08035917287','yaurigaz@gmail.com','KEBBI','KEBBI','MANDA LAYOUT  YAURI','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-21 11:35:12',5,'623','2022-07-21 11:35:12','623'),(2749,'','1','179','F.G.C','SOKOTO','09061349661','anaslpg@aaranonigeria.com','SOKOTO','SOKOTO','GUSAU ROAD,SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-08-24 16:25:06',5,'623','2022-08-24 16:25:06','623'),(2750,'','1','179','mai nasara','SOKOTO','09061349661','anaslpg@aaranonigeria.com','SOKOTO','SOKOTO','sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-06 17:47:36',5,'623','2022-09-06 17:47:36','623'),(2751,'','1','179','S BLUE GATE','SOKOTO','09132145212','sbluegategas@yahoo.com','SOKOTO','SOKOTO','kwannawa sokoto','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-11 15:53:59',5,'623','2022-09-11 15:53:59','623'),(2752,'','1','179','Victor zuru','KEBBI','07065543343','victorzuru@gmail.com','zuru','KEBBI','zuru town','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-23 12:46:12',5,'623','2023-01-22 11:08:43','623'),(2753,'','1','179','TOOBEST GAX','SOKOTO','08037461018','tobestgaz@gmail,com','SOKOTO','SOKOTO','ALU FLYOVER SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-09-24 13:49:12',5,'623','2022-09-24 13:49:12','623'),(2754,'','1','179','MAJI GAS','SOKOTO','08161163030','majigas@gmail.com','SOKOTO','SOKOTO','BODINGA AIPORT','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 09:45:27',5,'623','2022-10-27 09:45:27','623'),(2755,'','1','179','CHUKWUIDI GAS','SOKOTO','08145254565','chukuidigas@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-27 14:52:28',5,'623','2022-10-27 14:52:28','623'),(2756,'','1','179','BLUEFLAME GAS','SOKOTO','08038414073','blueflamegas@gmail.com','SOKOTO','SOKOTO','OLD AIRPORT SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-29 10:50:37',5,'623','2022-10-29 10:50:37','623'),(2757,'','1','179','PRECIUS 7','SOKOTO','08162957201','precius7gas@gmail.com','SOKOTO','SOKOTO','TAMAJE BESIDE ALUMINIUM COMPANY','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 09:17:44',5,'623','2022-10-31 09:17:44','623'),(2758,'','1','179','HUSSAINI GAS','SOKOTO','08103040804','hussainigas@gmail.com','SOKOTO','SOKOTO','Danbuwa plaza','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-10-31 10:14:39',5,'623','2022-10-31 10:14:39','623'),(2759,'','1','179','OPLET GAZ','SOKOTO','07031021201','opletgas@gmail.com','SOKOTO','SOKOTO','ILLELAH ROAD SOKTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-06 16:16:15',5,'623','2022-11-06 16:16:15','623'),(2760,'','1','179','OSCAR GAZ','SOKOTO','08036190758','oscargaz@yahoo.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-09 09:41:43',5,'623','2022-11-09 09:41:43','623'),(2761,'','1','179','EZEALOR GAZ','SOKOTO','07082424713','ezealorgax@gmail.com','SOKOTO','SOKOTO','CLOSED TO GIDAN JARIDA','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-10 10:32:03',5,'623','2022-11-10 10:32:03','623'),(2762,'','1','179','KEBSCO GAS','SOKOTO','07062757474','kebscogaz@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-21 10:39:09',5,'623','2022-11-21 10:39:09','623'),(2763,'','1','179','AKA GAS','SOKOTO','08065289557','akagas@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-21 13:36:57',5,'623','2022-11-21 13:36:57','623'),(2764,'','1','179','CHRISTOLIGHT GAS','SOKOTO','08105768221','christolightgaz@gmail.com','SOKOTO','SOKOTO','SOKOTO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-11-21 15:04:34',5,'623','2022-11-21 15:04:34','623');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16666 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','179',16376,'933',572.59,300.00,'2021-09-09','new','2021-09-09 11:50:15','483','483',2021,'483','2021-09-09 11:50:15',5),('1','179',16664,'933',4948.60,4950.00,'2021-09-29','NEW','2021-09-29 15:34:30','483','483',2021,'483','2021-09-29 15:34:30',5),('1','179',16665,'933',3777.97,3600.00,'2022-05-19','','2022-05-19 10:05:49','483','483',2022,'483','2022-05-19 10:05:49',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2744 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','179','933',2742,'5','LPG NOZZLE 1',62513.15,'LPG DISPENSER','',NULL,NULL,'',5,'2022-02-11 06:56:17','483'),('1','179','933',2743,'5','LPG NOZZLE 2',72861.48,'LPG DISPENSER.','',NULL,NULL,'',5,'2022-02-11 06:56:50','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257684 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','179',196042,'DAILY SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-09 08:40:48','623','2021-05-09 08:41:26',10,0),('1','179',196051,'DAILY SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-09 17:36:04','623','2021-05-09 17:36:35',10,0),('1','179',196262,'DAILY SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-11 09:56:20','623','2021-05-11 09:56:41',10,0),('1','179',196695,'DAILY SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-12 17:16:41','623','2021-05-12 17:17:14',10,0),('1','179',196902,'DAILY SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-13 17:40:23','623','2021-05-13 17:40:54',10,0),('1','179',197054,'DAILY SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-14 18:44:38','623','2021-05-14 18:45:19',10,0),('1','179',197304,'Daily','2021-05-15','2021-05-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-16 11:19:37','623','2021-05-16 11:20:09',10,0),('1','179',197314,'DAILY SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-16 18:33:14','623','2021-05-16 18:34:18',10,0),('1','179',197601,'DAILY SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-17 19:28:27','623','2021-05-17 19:29:08',10,0),('1','179',197889,'DAILY SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-18 21:50:06','623','2021-05-18 21:50:29',10,0),('1','179',198120,'DAILY SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-20 06:12:44','623','2021-05-20 06:13:06',10,0),('1','179',198348,'DAILY SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-20 18:56:08','623','2021-05-20 18:56:32',10,0),('1','179',198568,'DAILY SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-21 19:20:43','623','2021-05-21 19:21:08',10,0),('1','179',198779,'DAILY SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-22 19:30:29','623','2021-05-22 19:31:02',10,0),('1','179',198984,'DAILY SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-23 19:22:26','623','2021-05-23 19:22:48',10,0),('1','179',199212,'DAILY SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-24 19:43:16','623','2021-05-24 19:43:39',10,0),('1','179',199432,'DAILY SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-25 19:10:05','623','2021-05-25 19:10:29',10,0),('1','179',199645,'DAILY SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-26 19:39:10','623','2021-05-26 19:39:32',10,0),('1','179',199866,'DAILY SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-27 19:36:39','623','2021-05-27 19:37:09',10,0),('1','179',200089,'DAILY SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-28 19:19:34','623','2021-05-28 19:19:58',10,0),('1','179',200295,'DAILY SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-29 19:40:55','623','2021-05-29 19:41:18',10,0),('1','179',200489,'DAILY SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-30 19:46:46','623','2021-05-30 19:47:10',10,0),('1','179',200791,'Daily sale report','2021-05-31','2021-05-31 00:00:00',NULL,'623',0.00,0.00,'623','2021-05-31 19:36:49','623','2021-05-31 19:37:09',10,0),('1','179',200920,'DAILY SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-01 20:55:15','623','2021-06-01 20:55:37',10,0),('1','179',201108,'DAILY SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-02 21:24:27','623','2021-06-02 21:24:50',10,0),('1','179',201326,'DAILY SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-03 17:31:46','623','2021-06-03 17:32:14',10,0),('1','179',202674,'DAILY SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-09 19:43:15','623','2021-06-09 19:43:45',10,0),('1','179',202868,'DAILY SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-10 19:43:52','623','2021-06-10 19:44:31',10,0),('1','179',203195,'DAILY SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-11 19:52:03','623','2021-06-11 19:52:47',10,0),('1','179',203329,'DAILY SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-12 19:34:08','623','2021-06-12 19:34:49',10,0),('1','179',203651,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-13 14:58:02','623','2021-06-13 14:58:29',10,0),('1','179',203658,'DAILY SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-13 17:45:27','623','2021-06-13 17:46:03',10,0),('1','179',203898,'DAILY SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-14 19:45:51','623','2021-06-14 19:46:12',10,0),('1','179',203970,'DAILY SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-15 19:37:57','623','2021-06-15 19:38:47',10,0),('1','179',204194,'DAILY SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-16 19:43:10','623','2021-06-16 19:44:03',10,0),('1','179',204482,'DAILY SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-17 19:29:53','623','2021-06-17 19:30:14',10,0),('1','179',204638,'DAILY SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-18 19:47:01','623','2021-06-18 19:47:37',10,0),('1','179',204833,'DAILY SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-19 19:46:08','623','2021-06-19 19:46:33',10,0),('1','179',205043,'DAILY SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-20 19:41:21','623','2021-06-20 19:41:49',10,0),('1','179',205233,'DAILY SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-21 19:49:47','623','2021-06-21 19:50:13',10,0),('1','179',205477,'DAILY SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-22 19:39:03','623','2021-06-22 19:39:31',10,0),('1','179',205740,'DAILY SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-23 19:39:35','623','2021-06-23 19:39:59',10,0),('1','179',205948,'DAILY SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-24 19:10:44','623','2021-06-24 19:11:13',10,0),('1','179',206163,'DAILY SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-25 19:41:52','623','2021-06-25 19:42:21',10,0),('1','179',206365,'DAILY SHIFT','2021-06-26','2021-06-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-26 19:41:15','623','2021-06-26 19:41:39',10,0),('1','179',206571,'DAILY SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-27 19:42:01','623','2021-06-27 19:42:26',10,0),('1','179',206796,'DAILY SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-28 19:42:22','623','2021-06-28 19:42:40',10,0),('1','179',207023,'DAILY SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-29 19:27:00','623','2021-06-29 19:27:45',10,0),('1','179',207265,'DAILY SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-06-30 19:45:11','623','2021-06-30 19:45:45',10,0),('1','179',207516,'Daily shift','2021-07-01','2021-07-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-01 19:31:13','623','2021-07-01 19:31:46',10,0),('1','179',207714,'DAILY SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-02 21:31:36','623','2021-07-02 21:32:07',10,0),('1','179',207905,'DAILY SHIFT','2021-07-03','2021-07-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-03 19:59:14','623','2021-07-03 19:59:35',10,0),('1','179',208141,'DAILY SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-04 19:58:05','623','2021-07-04 19:58:38',10,0),('1','179',208412,'DAILY SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-05 17:26:14','623','2021-07-05 17:26:55',10,0),('1','179',210520,'Sales shift','2021-07-15','2021-07-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-15 20:35:04','623','2021-07-15 20:35:31',10,0),('1','179',210726,'DAILY SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-16 19:42:39','623','2021-07-16 19:43:17',10,0),('1','179',210978,'DAILY SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-17 21:46:59','623','2021-07-17 21:49:11',10,0),('1','179',211170,'DAILY SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-18 19:28:54','623','2021-07-18 19:29:18',10,0),('1','179',211408,'DAILY SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-19 19:40:01','623','2021-07-19 19:41:02',10,0),('1','179',211609,'DAILY SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-20 18:29:18','623','2021-07-20 18:34:13',10,0),('1','179',211788,'DAILY SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-21 18:31:56','623','2021-07-21 18:32:37',10,0),('1','179',211997,'DAILY SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-22 19:30:41','623','2021-07-22 19:31:16',10,0),('1','179',212238,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-23 19:29:59','623','2021-07-23 19:30:37',10,0),('1','179',212462,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-24 19:18:55','623','2021-07-24 19:19:21',10,0),('1','179',212674,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-25 19:32:12','623','2021-07-25 19:32:46',10,0),('1','179',212907,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-26 19:32:03','623','2021-07-26 19:32:31',10,0),('1','179',213163,'DAILY SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-27 19:25:59','623','2021-07-27 19:27:34',10,0),('1','179',213403,'DAILY SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-28 19:20:45','623','2021-07-28 19:21:10',10,0),('1','179',213638,'DAILY SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-29 19:48:38','623','2021-07-29 19:49:05',10,0),('1','179',213885,'DAILY SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-30 19:14:47','623','2021-07-30 19:19:16',10,0),('1','179',214108,'DAILY SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'623',0.00,0.00,'623','2021-07-31 19:48:49','623','2021-07-31 19:49:43',10,0),('1','179',214350,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-01 19:46:28','623','2021-08-01 19:46:55',10,0),('1','179',214525,'DAILY SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-02 06:09:19','623','2021-08-02 06:09:47',10,0),('1','179',214527,'DAILY SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-02 19:40:49','623','2021-08-02 19:42:31',10,0),('1','179',214778,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-03 10:25:05','623','2021-08-03 10:49:11',10,0),('1','179',214866,'DAILY SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-03 19:33:27','623','2021-08-03 19:33:54',10,0),('1','179',215008,'DAILY SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-04 19:38:24','623','2021-08-04 19:38:55',10,0),('1','179',215236,'Daily shift','2021-08-05','2021-08-05 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-05 18:44:07','623','2021-08-05 18:44:49',10,0),('1','179',215456,'DAILY SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-06 19:38:13','623','2021-08-06 19:38:42',10,0),('1','179',215699,'DAILY SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-07 19:38:16','623','2021-08-07 19:38:59',10,0),('1','179',215916,'DAILY SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-08 19:48:40','623','2021-08-08 19:49:08',10,0),('1','179',216109,'DAILY SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-10 07:02:01','623','2021-08-10 07:02:45',10,0),('1','179',216340,'DAILY SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-11 06:55:38','623','2021-08-11 06:56:04',10,0),('1','179',216566,'DAILY SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-11 19:12:09','623','2021-08-11 19:12:33',10,0),('1','179',216818,'DAILY SHIFT','2021-08-12','2021-08-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-12 19:31:37','623','2021-08-12 19:32:26',10,0),('1','179',217030,'DAILY SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-13 20:24:32','623','2021-08-13 20:25:07',10,0),('1','179',217288,'DAILY SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-14 19:30:08','623','2021-08-14 19:30:39',10,0),('1','179',217511,'DAILY SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-15 19:42:35','623','2021-08-15 19:44:05',10,0),('1','179',217715,'DAILY SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-16 19:43:54','623','2021-08-16 19:44:46',10,0),('1','179',217995,'DAILY SHIFT ','2021-08-17','2021-08-17 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-17 19:25:57','623','2021-08-17 19:27:36',10,0),('1','179',218242,'DAILY SHIFT','2021-08-18','2021-08-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-18 19:37:00','623','2021-08-18 19:37:27',10,0),('1','179',218464,'DAILY SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-19 19:33:11','623','2021-08-19 19:33:38',10,0),('1','179',218695,'DAILY SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-20 16:15:35','623','2021-08-20 16:16:20',10,0),('1','179',219378,'DAILY SHIFT ','2021-08-23','2021-08-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-23 08:05:30','623','2021-08-23 08:05:57',10,0),('1','179',219390,'DAILY SHIFT ','2021-08-22','2021-08-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-23 08:38:08','623','2021-08-23 08:42:54',10,0),('1','179',219408,'DAILY SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-23 18:10:45','623','2021-08-23 18:11:25',10,0),('1','179',219642,'DAILY SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-24 18:16:06','623','2021-08-24 18:16:39',10,0),('1','179',219837,'DAILY SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-25 19:25:49','623','2021-08-25 19:26:21',10,0),('1','179',220078,'DAILY SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-26 19:29:34','623','2021-08-26 19:31:21',10,0),('1','179',220294,'DAILY SHIFT ','2021-08-27','2021-08-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-27 19:33:17','623','2021-08-27 19:33:50',10,0),('1','179',220494,'DAILY SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-28 19:32:15','623','2021-08-28 19:32:40',10,0),('1','179',220700,'DAILY SHIFT','2021-08-29','2021-08-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-29 19:37:25','623','2021-08-29 19:37:58',10,0),('1','179',220984,'DAILY SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-30 19:38:24','623','2021-08-30 19:39:28',10,0),('1','179',221240,'DAILY SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'623',0.00,0.00,'623','2021-08-31 20:03:53','623','2021-08-31 20:04:41',10,0),('1','179',221392,'DAILY SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-01 19:40:33','623','2021-09-01 19:41:34',10,0),('1','179',221635,'DAILY SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-02 19:17:22','623','2021-09-02 19:18:05',10,0),('1','179',221840,'DAILY SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-03 19:46:46','623','2021-09-03 19:47:21',10,0),('1','179',222067,'DAILY SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-04 18:53:55','623','2021-09-04 18:54:16',10,0),('1','179',222278,'DAILY SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-05 19:15:31','623','2021-09-05 19:16:02',10,0),('1','179',222516,'DAILY SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-06 19:23:55','623','2021-09-06 19:24:24',10,0),('1','179',222751,'DAILY SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-07 18:49:30','623','2021-09-07 18:50:32',10,0),('1','179',222952,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-08 15:59:45','623','2021-09-08 16:01:24',10,0),('1','179',223132,'DAILY SHIFT','2021-09-08','2021-09-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-08 19:18:31','623','2021-09-08 19:19:55',10,0),('1','179',223289,'DAILY SHIFT ','2021-09-09','2021-09-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-09 19:11:20','623','2021-09-09 19:13:01',10,0),('1','179',223425,'DAILY SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-10 19:06:19','623','2021-09-10 19:06:57',10,0),('1','179',223649,'DAILY SHIFT','2021-09-11','2021-09-11 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-11 19:25:49','623','2021-09-11 19:26:30',10,0),('1','179',223881,'DAILY SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-12 19:07:12','623','2021-09-12 19:07:36',10,0),('1','179',224087,'DAILY SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-13 20:33:33','623','2021-09-13 20:34:41',10,0),('1','179',224318,'DAILY SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-14 18:14:12','623','2021-09-14 18:15:33',10,0),('1','179',224545,'DAILY SHIFT','2021-09-15','2021-09-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-15 19:27:12','623','2021-09-15 19:27:50',10,0),('1','179',224796,'DAILY SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-16 19:23:45','623','2021-09-16 19:24:49',10,0),('1','179',225072,'DAILY SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-17 19:33:01','623','2021-09-17 19:33:59',10,0),('1','179',225298,'DAILY SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-18 19:16:36','623','2021-09-18 19:17:13',10,0),('1','179',225497,'DAILY SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-19 19:00:41','623','2021-09-19 19:01:12',10,0),('1','179',225712,'DAILY SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-20 19:49:33','623','2021-09-20 19:50:03',10,0),('1','179',225996,'DAILY SHIFT','2021-09-21','2021-09-21 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-21 19:23:58','623','2021-09-21 19:24:32',10,0),('1','179',226241,'DAILY SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-22 19:25:55','623','2021-09-22 19:26:57',10,0),('1','179',226484,'DAILY SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-23 19:32:24','623','2021-09-23 19:33:25',10,0),('1','179',226748,'DAILY SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-24 19:21:04','623','2021-09-24 19:21:29',10,0),('1','179',226980,'DAILY SHIFT','2021-09-25','2021-09-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-25 19:32:43','623','2021-09-25 19:33:45',10,0),('1','179',227230,'DAILY SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-26 19:13:54','623','2021-09-26 19:14:20',10,0),('1','179',227391,'DAILY SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-27 17:11:33','623','2021-09-27 17:12:53',10,0),('1','179',227704,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-28 11:58:18','623','2021-09-28 11:58:48',10,0),('1','179',227730,'DAILY SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-29 15:41:19','623','2021-09-29 15:45:07',10,0),('1','179',228046,'DAILY SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-29 19:14:29','623','2021-09-29 19:18:47',10,0),('1','179',228134,'DAILY SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-09-30 19:26:16','623','2021-09-30 19:26:46',10,0),('1','179',228374,'DAILY SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-01 19:24:55','623','2021-10-01 19:25:37',10,0),('1','179',228538,'DAILY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-02 19:27:18','623','2021-10-02 19:28:40',10,0),('1','179',228764,'DAILY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-03 18:41:34','623','2021-10-03 18:42:14',10,0),('1','179',228957,'DAILY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-04 19:48:35','623','2021-10-04 19:49:18',10,0),('1','179',229186,'DAILY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-05 19:39:15','623','2021-10-05 19:40:34',10,0),('1','179',229440,'DAILY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-06 19:26:29','623','2021-10-06 19:27:13',10,0),('1','179',229671,'DAILY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-07 19:11:41','623','2021-10-07 19:13:45',10,0),('1','179',229898,'DAILY SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-08 19:36:43','623','2021-10-08 19:37:15',10,0),('1','179',230100,'DAILY SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-09 19:43:31','623','2021-10-09 19:44:07',10,0),('1','179',230294,'DAILY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-10 14:29:56','623','2021-10-10 14:30:43',10,0),('1','179',230802,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-12 07:16:11','623','2021-10-12 07:16:49',10,0),('1','179',230803,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-12 07:30:03','623','2021-10-12 07:31:15',10,0),('1','179',230892,'DAILY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-12 19:24:22','623','2021-10-12 19:24:55',10,0),('1','179',231074,'DAILY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-13 19:35:56','623','2021-10-13 19:36:25',10,0),('1','179',231394,'DAILY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-14 19:15:27','623','2021-10-14 19:15:56',10,0),('1','179',231662,'DAILY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-15 19:26:01','623','2021-10-15 19:26:36',10,0),('1','179',231906,'DAILY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-16 19:24:13','623','2021-10-16 19:24:44',10,0),('1','179',232432,'DAILY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-18 19:32:30','623','2021-10-18 19:33:32',10,0),('1','179',232609,'DAILY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-19 19:23:31','623','2021-10-19 19:24:22',10,0),('1','179',232872,'DAILY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-20 19:32:47','623','2021-10-20 19:33:27',10,0),('1','179',233121,'DAILY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-21 19:27:07','623','2021-10-21 19:27:49',10,0),('1','179',233414,'DAILY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-22 19:17:33','623','2021-10-22 19:19:21',10,0),('1','179',233625,'DAILY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-23 19:21:47','623','2021-10-23 19:22:16',10,0),('1','179',233856,'DAILY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-24 19:31:19','623','2021-10-24 19:31:58',10,0),('1','179',234083,'DAILY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-25 19:37:49','623','2021-10-25 19:38:30',10,0),('1','179',234346,'DAILY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-26 19:11:01','623','2021-10-26 19:12:25',10,0),('1','179',234595,'DAILY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-27 17:32:45','623','2021-10-27 17:33:22',10,0),('1','179',235238,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-29 16:11:14','623','2021-10-29 16:11:39',10,0),('1','179',235245,'DAILY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-29 19:36:32','623','2021-10-29 19:37:03',10,0),('1','179',235327,'DAILY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-30 19:06:48','623','2021-10-30 19:07:16',10,0),('1','179',235561,'DAILY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'623',0.00,0.00,'623','2021-10-31 19:27:18','623','2021-10-31 19:27:56',10,0),('1','179',235782,'DAILY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-01 19:42:45','623','2021-11-01 19:43:31',10,0),('1','179',236054,'DAILY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-02 19:27:48','623','2021-11-02 19:28:25',10,0),('1','179',236251,'DAILY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-03 19:15:27','623','2021-11-03 19:16:11',10,0),('1','179',236536,'DAILY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-04 19:23:21','623','2021-11-04 19:23:52',10,0),('1','179',236757,'DAILY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-05 19:18:43','623','2021-11-05 19:19:09',10,0),('1','179',236976,'DAILY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-06 19:40:55','623','2021-11-06 19:41:24',10,0),('1','179',237193,'DAILY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-07 19:15:43','623','2021-11-07 19:16:11',10,0),('1','179',237400,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-08 19:22:48','623','2021-11-08 19:23:18',10,0),('1','179',237651,'DAILY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-09 19:28:53','623','2021-11-09 19:29:15',10,0),('1','179',237889,'DAILY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-10 19:20:33','623','2021-11-10 19:21:08',10,0),('1','179',238139,'DAILY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-11 19:17:42','623','2021-11-11 19:18:21',10,0),('1','179',238385,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-12 18:00:14','623','2021-11-12 18:00:56',10,0),('1','179',241075,'DAILY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-23 21:52:20','623','2021-11-23 21:52:52',10,0),('1','179',241253,'DAILY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-24 18:57:30','623','2021-11-24 18:58:10',10,0),('1','179',241430,'DAILY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-24 19:12:34','623','2021-11-24 19:13:01',10,0),('1','179',241516,'DAILY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-25 18:54:41','623','2021-11-25 18:56:29',10,0),('1','179',241772,'DAILY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-26 19:07:49','623','2021-11-26 19:13:22',10,0),('1','179',241990,'DAILY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-27 19:03:06','623','2021-11-27 19:03:41',10,0),('1','179',242233,'DAILY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-28 18:59:18','623','2021-11-28 19:00:29',10,0),('1','179',242480,'DAILY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-29 19:03:08','623','2021-11-29 19:03:35',10,0),('1','179',242704,'DAILY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-11-30 19:22:39','623','2021-11-30 19:23:51',10,0),('1','179',242943,'DAILY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-01 19:12:05','623','2021-12-01 19:12:40',10,0),('1','179',243161,'DAILY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-02 19:33:10','623','2021-12-02 19:33:44',10,0),('1','179',243394,'DAILY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-03 19:09:18','623','2021-12-03 19:10:13',10,0),('1','179',243624,'DAILY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-04 19:08:56','623','2021-12-04 19:09:45',10,0),('1','179',243852,'DAILY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-05 19:01:09','623','2021-12-05 19:06:14',10,0),('1','179',244091,'DAILY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-06 19:16:51','623','2021-12-06 19:18:43',10,0),('1','179',244324,'DAILY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-07 19:07:40','623','2021-12-07 19:09:42',10,0),('1','179',244556,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-08 10:41:59','623','2021-12-08 10:42:25',10,0),('1','179',244903,'DAILY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-09 19:11:23','623','2021-12-09 19:11:53',10,0),('1','179',245014,'DAILY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-10 19:01:47','623','2021-12-10 19:02:22',10,0),('1','179',245241,'DAILY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-11 19:03:18','623','2021-12-11 19:04:02',10,0),('1','179',245452,'DAILY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-12 18:58:38','623','2021-12-12 18:59:04',10,0),('1','179',245702,'DAILY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-14 07:03:24','623','2021-12-14 07:03:52',10,0),('1','179',245972,'DAILY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-15 07:03:06','623','2021-12-15 07:03:50',10,0),('1','179',246217,'DAILY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-15 19:14:29','623','2021-12-15 19:15:00',10,0),('1','179',246481,'DAILY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-17 07:01:25','623','2021-12-17 07:02:00',10,0),('1','179',246731,'DAILY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-17 19:18:11','623','2021-12-17 19:18:30',10,0),('1','179',246975,'DAILY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-18 19:11:05','623','2021-12-18 19:11:36',10,0),('1','179',247203,'DAILY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-20 06:57:12','623','2021-12-20 06:57:41',10,0),('1','179',247439,'DAILY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-20 18:53:09','623','2021-12-20 18:53:43',10,0),('1','179',247701,'DAILY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-22 07:08:10','623','2021-12-22 07:08:33',10,0),('1','179',247940,'DAILY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-23 07:04:45','623','2021-12-23 07:05:12',10,0),('1','179',248189,'DAILY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-24 07:11:20','623','2021-12-24 07:11:51',10,0),('1','179',248432,'DAILY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-24 18:57:42','623','2021-12-24 18:58:30',10,0),('1','179',248677,'DAILY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-26 07:46:34','623','2021-12-26 07:47:00',10,0),('1','179',248912,'DAILY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-26 18:59:39','623','2021-12-26 19:00:08',10,0),('1','179',249140,'DAILY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-27 07:12:21','623','2021-12-27 07:12:48',10,0),('1','179',249143,'DAILY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-27 18:56:16','623','2021-12-27 18:56:45',10,0),('1','179',249382,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-28 09:11:51','623','2021-12-28 09:12:21',10,0),('1','179',249505,'DAILY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-28 19:02:53','623','2021-12-28 19:04:16',10,0),('1','179',249625,'DAILY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-29 18:40:54','623','2021-12-29 18:41:47',10,0),('1','179',249881,'DAILY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'623',0.00,0.00,'623','2021-12-30 19:05:35','623','2021-12-30 19:06:08',10,0),('1','179',250133,'DAILY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-01 07:23:10','623','2022-01-01 07:23:29',10,0),('1','179',250365,'DAILY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-01 19:13:22','623','2022-01-01 19:13:53',10,0),('1','179',250584,'DAILY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-02 18:40:48','623','2022-01-02 18:41:19',10,0),('1','179',250833,'DAILY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-03 19:02:28','623','2022-01-03 19:02:49',10,0),('1','179',251060,'DAILY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-04 18:56:51','623','2022-01-04 18:57:20',10,0),('1','179',251301,'DAILY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-05 20:05:21','623','2022-01-05 20:08:57',10,0),('1','179',251553,'DAILY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-07 08:23:58','623','2022-01-07 08:25:10',10,0),('1','179',251802,'DAILY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-07 20:12:01','623','2022-01-07 20:12:35',10,0),('1','179',252022,'DAILY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-08 20:09:14','623','2022-01-08 20:09:45',10,0),('1','179',252260,'DAILY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-09 20:12:57','623','2022-01-09 20:13:40',10,0),('1','179',252509,'DAILY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-10 20:11:53','623','2022-01-10 20:12:50',10,0),('1','179',252747,'DAILY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-11 20:13:56','623','2022-01-11 20:15:12',10,0),('1','179',253006,'DAILY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-12 20:14:08','623','2022-01-12 20:15:11',10,0),('1','179',253246,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-13 17:50:51','623','2022-01-13 17:51:25',10,0),('1','179',253508,'DAILY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-14 20:21:56','623','2022-01-14 20:22:25',10,0),('1','179',253741,'DAILY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-15 20:03:04','623','2022-01-15 20:04:28',10,0),('1','179',253991,'DAILY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-16 20:01:31','623','2022-01-16 20:02:04',10,0),('1','179',254242,'DAILY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-17 20:05:26','623','2022-01-17 20:06:49',10,0),('1','179',254479,'DAILY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-18 20:11:14','623','2022-01-18 20:11:40',10,0),('1','179',254743,'DAILY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-19 20:02:29','623','2022-01-19 20:04:43',10,0),('1','179',254984,'DAILY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-20 20:10:55','623','2022-01-20 20:12:20',10,0),('1','179',255226,'DAILY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-21 20:10:40','623','2022-01-21 20:12:11',10,0),('1','179',255489,'DAILY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-22 20:08:35','623','2022-01-22 20:09:12',10,0),('1','179',255733,'DAILY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-23 20:21:32','623','2022-01-23 20:22:07',10,0),('1','179',255990,'DAILY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-24 20:11:29','623','2022-01-24 20:12:09',10,0),('1','179',256239,'DAILY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-25 20:16:18','623','2022-01-25 20:17:23',10,0),('1','179',256519,'DAILY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-27 08:09:06','623','2022-01-27 08:09:36',10,0),('1','179',256756,'DAILY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-27 19:47:12','623','2022-01-27 19:47:31',10,0),('1','179',256999,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-28 19:43:24','623','2022-01-28 19:44:03',10,0),('1','179',257271,'DAILY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-29 09:57:34','623','2022-01-29 09:58:04',10,0),('1','179',257303,'DAILY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-29 10:15:31','623','2022-01-29 10:15:58',10,0),('1','179',257304,'DAILY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-29 10:26:10','623','2022-01-29 10:26:30',10,0),('1','179',257307,'DAILY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'623',0.00,0.00,'623','2022-01-29 10:34:24','623','2022-01-29 10:34:46',10,0),('1','179',257308,'DAILY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-02 20:13:08','623','2022-02-02 20:13:30',10,0),('1','179',257309,'DAILY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-03 20:11:18','623','2022-02-03 20:11:49',10,0),('1','179',257310,'DAILY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-04 20:23:45','623','2022-02-04 20:24:13',10,0),('1','179',257311,'DAILY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-05 19:48:03','623','2022-02-05 19:48:48',10,0),('1','179',257312,'DAILY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-06 19:40:34','623','2022-02-06 19:40:55',10,0),('1','179',257313,'DAILY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-07 19:46:36','623','2022-02-07 19:46:59',10,0),('1','179',257314,'DAILY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-08 20:16:51','623','2022-02-08 20:19:31',10,0),('1','179',257315,'DAILY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-09 20:36:21','623','2022-02-09 20:40:00',10,0),('1','179',257316,'DAILY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-10 19:30:38','623','2022-02-10 19:31:00',10,0),('1','179',257317,'DAILY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-11 19:33:11','623','2022-02-11 19:34:07',10,0),('1','179',257318,'DAILY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-12 19:37:17','623','2022-02-12 19:38:00',10,0),('1','179',257319,'DAILY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-13 20:22:12','623','2022-02-13 20:22:26',10,0),('1','179',257320,'DAILY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-15 08:20:52','623','2022-02-15 08:21:10',10,0),('1','179',257321,'DAILY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-15 19:53:35','623','2022-02-15 19:54:10',10,0),('1','179',257322,'DAILY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-16 19:43:36','623','2022-02-16 19:43:53',10,0),('1','179',257323,'DAILY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'623',0.00,0.00,'623','2022-02-18 08:46:53','623','2022-02-18 08:53:33',10,0),('1','179',257324,'DAILY SHIFT','2022-02-22','2022-02-22 08:20:06','2022-02-23 08:20:06','623',0.00,0.00,'623','2022-02-23 08:33:40','623','2022-02-23 08:34:18',10,0),('1','179',257325,'DAILY SHIFT','2022-02-23','2022-02-23 08:34:49','2022-02-24 08:34:49','623',0.00,0.00,'623','2022-02-23 20:10:29','623','2022-02-23 20:11:03',10,0),('1','179',257326,'DAILY SHIFT','2022-02-24','2022-02-24 09:40:14','2022-02-25 09:40:14','623',0.00,0.00,'623','2022-02-24 20:28:27','623','2022-02-24 20:28:47',10,0),('1','179',257327,'DAILY SHIFT','2022-02-25','2022-02-25 08:14:49','2022-02-26 08:14:49','623',0.00,0.00,'623','2022-02-25 20:15:52','623','2022-02-25 20:16:53',10,0),('1','179',257328,'DAILY SHIFT','2022-02-26','2022-02-26 08:11:57','2022-02-27 08:11:57','623',0.00,0.00,'623','2022-02-26 20:11:00','623','2022-02-26 20:11:18',10,0),('1','179',257329,'DAILY SHIFT','2022-02-27','2022-02-27 08:46:15','2022-02-28 08:46:15','623',0.00,0.00,'623','2022-02-27 20:13:02','623','2022-02-27 20:13:18',10,0),('1','179',257330,'DAILY SHIFT','2022-02-28','2022-02-28 08:03:20','2022-03-01 08:03:20','623',0.00,0.00,'623','2022-02-28 20:07:42','623','2022-02-28 20:08:12',10,0),('1','179',257331,'DAILY SHIFT','2022-03-01','2022-03-01 08:03:39','2022-03-02 08:03:39','623',0.00,0.00,'623','2022-03-01 20:45:00','623','2022-03-01 20:45:43',10,0),('1','179',257332,'DAILY SHIFT','2022-03-02','2022-03-02 08:05:11','2022-03-03 08:05:11','623',0.00,0.00,'623','2022-03-02 20:01:40','623','2022-03-02 20:02:01',10,0),('1','179',257333,'DAILY SHIFT','2022-03-03','2022-03-03 08:05:39','2022-03-04 08:05:39','623',0.00,0.00,'623','2022-03-03 20:20:33','623','2022-03-03 20:20:52',10,0),('1','179',257334,'DAILY SHIFT','2022-03-04','2022-03-04 08:21:13','2022-03-05 08:21:13','623',0.00,0.00,'623','2022-03-04 20:22:45','623','2022-03-04 20:23:03',10,0),('1','179',257335,'DAILY SHIFT','2022-03-05','2022-03-05 08:53:57','2022-03-06 08:53:57','623',0.00,0.00,'623','2022-03-05 19:42:13','623','2022-03-05 19:42:29',10,0),('1','179',257336,'DAILY SHIFT','2022-03-06','2022-03-06 08:54:18','2022-03-07 08:54:18','623',0.00,0.00,'623','2022-03-06 20:14:50','623','2022-03-06 20:15:26',10,0),('1','179',257337,'DAILY SHIFT','2022-03-07','2022-03-07 08:20:48','2022-03-08 08:20:48','623',0.00,0.00,'623','2022-03-07 20:12:37','623','2022-03-07 20:13:45',10,0),('1','179',257338,'DAILY SHIFT','2022-03-08','2022-03-08 08:13:37','2022-03-09 08:13:37','623',0.00,0.00,'623','2022-03-09 08:11:33','623','2022-03-09 08:11:53',10,0),('1','179',257339,'DAILY SHIFT','2022-03-17','2022-03-17 09:38:43','2022-03-18 09:38:43','623',0.00,0.00,'623','2022-03-17 19:55:50','623','2022-03-17 19:56:07',10,0),('1','179',257340,'DAILY SHIFT','2022-03-18','2022-03-18 09:27:12','2022-03-19 09:27:12','623',0.00,0.00,'623','2022-03-18 20:07:54','623','2022-03-18 20:08:15',10,0),('1','179',257341,'DAILY SHIFT','2022-03-19','2022-03-19 08:29:25','2022-03-20 08:29:25','623',0.00,0.00,'623','2022-03-19 20:18:32','623','2022-03-19 20:18:51',10,0),('1','179',257342,'DAILY SHIFT','2022-03-20','2022-03-20 08:09:22','2022-03-21 08:09:22','623',0.00,0.00,'623','2022-03-21 08:26:39','623','2022-03-21 08:26:57',10,0),('1','179',257343,'DAILY SHIFT','2022-03-21','2022-03-21 08:27:21','2022-03-22 08:27:21','623',0.00,0.00,'623','2022-03-21 20:17:01','623','2022-03-21 20:17:35',10,0),('1','179',257344,'DAILY SHIFT','2022-03-22','2022-03-22 08:52:13','2022-03-23 08:52:13','623',0.00,0.00,'623','2022-03-22 20:27:12','623','2022-03-22 20:27:57',10,0),('1','179',257345,'DAILY SHIFT','2022-03-23','2022-03-23 08:04:34','2022-03-24 08:04:34','623',0.00,0.00,'623','2022-03-23 20:10:39','623','2022-03-23 20:10:57',10,0),('1','179',257346,'DAILY SHIFT','2022-03-24','2022-03-24 08:32:02','2022-03-25 08:32:02','623',0.00,0.00,'623','2022-03-25 08:11:43','623','2022-03-25 08:12:27',10,0),('1','179',257347,'DAILY SHIFT','2022-03-25','2022-03-25 08:13:10','2022-03-26 08:13:10','623',0.00,0.00,'623','2022-03-25 21:28:22','623','2022-03-26 08:52:37',10,0),('1','179',257348,'DAILY SHIFT','2022-03-26','2022-03-26 08:52:59','2022-03-27 08:52:59','623',0.00,0.00,'623','2022-03-27 08:14:45','623','2022-03-27 08:15:06',10,0),('1','179',257349,'DAILY SHIFT','2022-03-27','2022-03-27 08:15:32','2022-03-28 08:15:32','623',0.00,0.00,'623','2022-03-28 13:40:05','623','2022-03-28 13:40:28',10,0),('1','179',257350,'DAILY SHIFT','2022-03-28','2022-03-28 13:41:02','2022-03-29 13:41:02','623',0.00,0.00,'623','2022-03-29 11:50:08','623','2022-03-29 11:50:28',10,0),('1','179',257351,'DAILY SHIFT','2022-03-30','2022-03-30 15:13:14','2022-03-31 15:13:14','623',0.00,0.00,'623','2022-03-30 20:25:30','623','2022-03-30 20:25:45',10,0),('1','179',257352,'DAILY SHIFT','2022-03-31','2022-03-31 08:24:54','2022-04-01 08:24:54','623',0.00,0.00,'623','2022-03-31 20:24:01','623','2022-03-31 20:24:20',10,0),('1','179',257353,'DAILY SHIFT','2022-04-01','2022-04-01 09:18:28','2022-04-02 09:18:28','623',0.00,0.00,'623','2022-04-02 08:55:26','623','2022-04-02 08:55:46',10,0),('1','179',257354,'DAILY SHIFT','2022-04-02','2022-04-02 08:57:17','2022-04-03 08:57:17','623',0.00,0.00,'623','2022-04-03 08:58:39','623','2022-04-03 08:58:55',10,0),('1','179',257355,'DAILY SHIFT','2022-04-03','2022-04-03 09:01:37','2022-04-04 09:01:37','623',0.00,0.00,'623','2022-04-03 13:11:36','623','2022-04-03 13:12:23',10,0),('1','179',257356,'DAILY SHIFT','2022-04-03','2022-04-03 13:12:53','2022-04-04 13:12:53','623',0.00,0.00,'623','2022-04-03 19:44:55','623','2022-04-03 19:45:17',10,0),('1','179',257357,'DAILY SHIFT','2022-04-04','2022-04-04 08:44:13','2022-04-05 08:44:13','623',0.00,0.00,'623','2022-04-05 08:42:04','623','2022-04-05 08:53:10',10,0),('1','179',257358,'DAILY SHIFT','2022-04-05','2022-04-05 08:53:34','2022-04-06 08:53:34','623',0.00,0.00,'623','2022-04-05 19:30:45','623','2022-04-05 19:31:01',10,0),('1','179',257359,'DAILY SHIFT','2022-04-06','2022-04-06 07:56:02','2022-04-07 07:56:02','623',0.00,0.00,'623','2022-04-07 07:57:18','623','2022-04-07 07:57:39',10,0),('1','179',257360,'DAILY SHIFT','2022-04-07','2022-04-07 07:58:03','2022-04-08 07:58:03','623',0.00,0.00,'623','2022-04-07 19:43:42','623','2022-04-07 19:44:04',10,0),('1','179',257361,'DAILY SHIFT','2022-04-08','2022-04-08 08:25:14','2022-04-09 08:25:14','623',0.00,0.00,'623','2022-04-09 08:06:10','623','2022-04-09 08:06:31',10,0),('1','179',257362,'DAILY SHIFT','2022-04-09','2022-04-09 08:08:05','2022-04-10 08:08:05','623',0.00,0.00,'623','2022-04-09 19:46:25','623','2022-04-09 19:46:55',10,0),('1','179',257363,'DAILY SHIFT','2022-04-10','2022-04-10 07:53:51','2022-04-11 07:53:51','623',0.00,0.00,'623','2022-04-10 19:35:44','623','2022-04-10 19:36:11',10,0),('1','179',257364,'DAILY SHIFT','2022-04-11','2022-04-11 08:16:53','2022-04-12 08:16:53','623',0.00,0.00,'623','2022-04-12 08:18:33','623','2022-04-12 08:18:52',10,0),('1','179',257365,'DAILY SHIFT','2022-04-12','2022-04-12 08:19:16','2022-04-13 08:19:16','623',0.00,0.00,'623','2022-04-13 08:46:48','623','2022-04-13 08:47:15',10,0),('1','179',257366,'DAILY SHIFT','2022-04-13','2022-04-13 08:48:06','2022-04-14 08:48:06','623',0.00,0.00,'623','2022-04-14 08:40:08','623','2022-04-14 08:40:31',10,0),('1','179',257367,'DAILY SHIFT','2022-04-14','2022-04-14 08:41:05','2022-04-15 08:41:05','623',0.00,0.00,'623','2022-04-14 19:16:47','623','2022-04-14 19:17:19',10,0),('1','179',257368,'DAILY SHIFT','2022-04-15','2022-04-15 08:06:22','2022-04-16 08:06:22','623',0.00,0.00,'623','2022-04-15 19:33:34','623','2022-04-15 19:34:03',10,0),('1','179',257369,'DAILY SHIFT','2022-04-16','2022-04-16 08:23:54','2022-04-17 08:23:54','623',0.00,0.00,'623','2022-04-16 19:32:27','623','2022-04-16 19:33:10',10,0),('1','179',257370,'DAILY SHIFT','2022-04-17','2022-04-17 08:15:21','2022-04-18 08:15:21','623',0.00,0.00,'623','2022-04-18 08:29:59','623','2022-04-18 08:30:16',10,0),('1','179',257371,'DAILY SHIFT','2022-04-18','2022-04-18 08:30:44','2022-04-19 08:30:44','623',0.00,0.00,'623','2022-04-19 08:28:32','623','2022-04-19 08:28:52',10,0),('1','179',257372,'DAILY SHIFT','2022-04-19','2022-04-19 08:29:13','2022-04-20 08:29:13','623',0.00,0.00,'623','2022-04-19 16:27:19','623','2022-04-19 16:35:45',10,0),('1','179',257373,'DAILY SHIFT','2022-04-19','2022-04-19 16:36:12','2022-04-20 16:36:12','623',0.00,0.00,'623','2022-04-19 19:26:52','623','2022-04-19 19:27:14',10,0),('1','179',257374,'DAILY SHIFT','2022-04-20','2022-04-20 08:06:16','2022-04-21 08:06:16','623',0.00,0.00,'623','2022-04-21 08:52:28','623','2022-04-21 08:52:50',10,0),('1','179',257375,'DAILY SHIFT','2022-04-21','2022-04-21 08:53:39','2022-04-22 08:53:39','623',0.00,0.00,'623','2022-04-21 19:27:33','623','2022-04-21 19:28:02',10,0),('1','179',257376,'DAILY SHIFT','2022-04-22','2022-04-22 08:05:16','2022-04-23 08:05:16','623',0.00,0.00,'623','2022-04-22 08:08:30','623','2022-04-22 08:08:46',10,0),('1','179',257377,'DAILY SHIFT','2021-01-17','2022-04-22 08:09:52','2022-04-23 08:09:52','623',0.00,0.00,'623','2022-04-22 08:13:24','623','2022-04-22 08:13:44',10,0),('1','179',257378,'DAILY SHIFT','2022-04-22','2022-04-22 08:14:03','2022-04-23 08:14:03','623',0.00,0.00,'623','2022-04-23 08:28:31','623','2022-04-23 08:28:51',10,0),('1','179',257379,'DAILY SHIFT','2022-04-23','2022-04-23 08:29:12','2022-04-24 08:29:12','623',0.00,0.00,'623','2022-04-24 08:36:27','623','2022-04-24 08:36:44',10,0),('1','179',257380,'DAILY SHIFT','2022-04-24','2022-04-24 08:37:00','2022-04-25 08:37:00','623',0.00,0.00,'623','2022-04-25 08:38:12','623','2022-04-25 08:38:38',10,0),('1','179',257381,'DAILY SHIFT','2022-04-25','2022-04-25 08:39:00','2022-04-26 08:39:00','623',0.00,0.00,'623','2022-04-25 19:31:34','623','2022-04-25 19:32:17',10,0),('1','179',257382,'DAILY SHIFT','2022-04-26','2022-04-26 08:26:14','2022-04-27 08:26:14','623',0.00,0.00,'623','2022-04-26 19:44:04','623','2022-04-26 19:44:23',10,0),('1','179',257383,'DAILY SHIFT','2022-04-27','2022-04-27 08:27:03','2022-04-28 08:27:03','623',0.00,0.00,'623','2022-04-27 18:32:17','623','2022-04-27 18:32:35',10,0),('1','179',257384,'DAILY SHIFT','2022-04-28','2022-04-28 09:31:25','2022-04-29 09:31:25','623',0.00,0.00,'623','2022-04-28 18:03:56','623','2022-04-28 18:04:24',10,0),('1','179',257385,'DAILY SHIFT','2022-04-29','2022-04-29 09:46:25','2022-04-30 09:46:25','623',0.00,0.00,'623','2022-04-29 18:00:41','623','2022-04-29 18:01:10',10,0),('1','179',257386,'DAILY SHIFT','2022-04-30','2022-04-30 09:52:46','2022-05-01 09:52:46','623',0.00,0.00,'623','2022-04-30 18:05:14','623','2022-04-30 18:06:42',10,0),('1','179',257387,'DAILY SHIFT','2022-05-01','2022-05-01 10:36:10','2022-05-02 10:36:10','623',0.00,0.00,'623','2022-05-01 18:25:52','623','2022-05-01 18:26:21',10,0),('1','179',257388,'DAILY SHIFT','2022-05-02','2022-05-02 11:16:38','2022-05-03 11:16:38','623',0.00,0.00,'623','2022-05-02 21:48:50','623','2022-05-02 21:49:24',10,0),('1','179',257389,'DAILY SHIFT','2022-05-03','2022-05-03 10:39:24','2022-05-04 10:39:24','623',0.00,0.00,'623','2022-05-03 20:36:33','623','2022-05-03 20:37:08',10,0),('1','179',257390,'DAILY SHIFT','2022-05-04','2022-05-04 13:29:09','2022-05-05 13:29:09','623',0.00,0.00,'623','2022-05-04 18:09:43','623','2022-05-04 18:17:12',10,0),('1','179',257391,'DAILY SHIFT','2022-05-05','2022-05-05 09:53:24','2022-05-06 09:53:24','623',0.00,0.00,'623','2022-05-05 18:27:40','623','2022-05-05 18:28:25',10,0),('1','179',257392,'DAILY SHIFT','2022-05-06','2022-05-06 10:15:24','2022-05-07 10:15:24','623',0.00,0.00,'623','2022-05-06 17:59:07','623','2022-05-06 18:00:10',10,0),('1','179',257393,'DAILY SHIFT','2022-05-07','2022-05-07 09:17:57','2022-05-08 09:17:57','623',0.00,0.00,'623','2022-05-07 17:56:02','623','2022-05-07 17:56:35',10,0),('1','179',257394,'DAILY SHIFT','2022-05-08','2022-05-08 08:24:53','2022-05-09 08:24:53','623',0.00,0.00,'623','2022-05-08 18:02:30','623','2022-05-08 18:03:21',10,0),('1','179',257395,'DAILY SHIFT','2022-05-09','2022-05-09 08:12:40','2022-05-10 08:12:40','623',0.00,0.00,'623','2022-05-11 14:29:40','623','2022-05-11 14:29:57',10,0),('1','179',257396,'DAILY SHIFT','2022-04-19','2022-05-11 14:30:39','2022-05-12 14:30:39','623',0.00,0.00,'623','2022-05-11 14:33:45','623','2022-05-11 14:34:00',10,0),('1','179',257397,'DAILY SHIFT','2022-05-08','2022-05-11 14:34:29','2022-05-12 14:34:29','623',0.00,0.00,'623','2022-05-11 14:37:27','623','2022-05-11 14:38:11',10,0),('1','179',257398,'DAILY SHIFT','2022-05-12','2022-05-12 07:51:02','2022-05-13 07:51:02','623',0.00,0.00,'623','2022-05-12 19:35:13','623','2022-05-12 19:35:29',10,0),('1','179',257399,'DAILY SHIFT','2022-05-13','2022-05-13 08:14:42','2022-05-14 08:14:42','623',0.00,0.00,'623','2022-05-13 19:28:54','623','2022-05-13 19:29:15',10,0),('1','179',257400,'DAILY SHIFT','2022-05-14','2022-05-14 08:17:49','2022-05-15 08:17:49','623',0.00,0.00,'623','2022-05-14 16:25:24','623','2022-05-14 16:25:46',10,0),('1','179',257401,'DAILY SHIFT','2022-05-16','2022-05-16 10:37:35','2022-05-17 10:37:35','623',0.00,0.00,'623','2022-05-17 08:34:10','623','2022-05-17 08:34:37',10,0),('1','179',257402,'DAILY SHIFT','2022-05-17','2022-05-17 08:35:11','2022-05-18 08:35:11','623',0.00,0.00,'623','2022-05-17 16:40:53','623','2022-05-17 16:41:12',10,0),('1','179',257403,'DAILY SHIFT','2022-05-18','2022-05-18 08:31:16','2022-05-19 08:31:16','623',0.00,0.00,'623','2022-05-18 16:58:22','623','2022-05-18 16:58:38',10,0),('1','179',257404,'DAILY SHIFT','2022-05-19','2022-05-19 08:14:06','2022-05-20 08:14:06','623',0.00,0.00,'623','2022-05-19 16:41:19','623','2022-05-19 16:41:36',10,0),('1','179',257405,'DAILY SHIFT','2022-05-20','2022-05-20 08:18:33','2022-05-21 08:18:33','623',0.00,0.00,'623','2022-05-20 16:32:48','623','2022-05-20 16:34:54',10,0),('1','179',257406,'DAILY SHIFT','2022-05-21','2022-05-21 08:22:02','2022-05-22 08:22:02','623',0.00,0.00,'623','2022-05-21 18:20:25','623','2022-05-21 18:20:42',10,0),('1','179',257407,'DAILY SHIFT','2022-05-22','2022-05-22 08:19:34','2022-05-23 08:19:34','623',0.00,0.00,'623','2022-05-22 18:02:16','623','2022-05-22 18:02:31',10,0),('1','179',257408,'DAILY SHIFT','2022-05-23','2022-05-23 09:09:36','2022-05-24 09:09:36','623',0.00,0.00,'623','2022-05-23 19:54:30','623','2022-05-23 19:54:54',10,0),('1','179',257409,'DAILY SHIFT','2022-05-24','2022-05-24 08:20:19','2022-05-25 08:20:19','623',0.00,0.00,'623','2022-05-24 20:02:11','623','2022-05-24 20:02:40',10,0),('1','179',257410,'DAILY SHIFT','2022-05-25','2022-05-25 07:55:53','2022-05-26 07:55:53','623',0.00,0.00,'623','2022-05-25 19:34:12','623','2022-05-25 19:34:40',10,0),('1','179',257411,'DAILY SHIFT','2022-05-26','2022-05-26 07:46:40','2022-05-27 07:46:40','623',0.00,0.00,'623','2022-05-26 19:53:06','623','2022-05-26 19:53:46',10,0),('1','179',257412,'DAILY SHIFT','2022-05-27','2022-05-27 08:10:10','2022-05-28 08:10:10','623',0.00,0.00,'623','2022-05-27 19:34:18','623','2022-05-27 19:34:41',10,0),('1','179',257413,'DAILY SHIFT','2022-05-28','2022-05-28 08:19:13','2022-05-29 08:19:13','623',0.00,0.00,'623','2022-05-29 08:01:00','623','2022-05-29 08:02:25',10,0),('1','179',257414,'DAILY SHIFT','2022-05-29','2022-05-29 08:02:49','2022-05-30 08:02:49','623',0.00,0.00,'623','2022-05-30 08:00:05','623','2022-05-30 08:00:25',10,0),('1','179',257415,'DAILY SHIFT','2022-05-30','2022-05-30 08:04:38','2022-05-31 08:04:38','623',0.00,0.00,'623','2022-05-30 20:42:20','623','2022-05-30 20:42:40',10,0),('1','179',257416,'DAILY SHIFT','2022-05-31','2022-05-31 08:04:13','2022-06-01 08:04:13','623',0.00,0.00,'623','2022-05-31 18:37:46','623','2022-05-31 18:38:47',10,0),('1','179',257417,'DAILY SHIFT','2022-06-01','2022-06-01 16:15:06','2022-06-02 16:15:06','623',0.00,0.00,'623','2022-06-01 16:17:49','623','2022-06-01 16:18:05',10,0),('1','179',257418,'DAILY SHIFT','2022-06-01','2022-06-04 15:01:14','2022-06-05 15:01:14','623',0.00,0.00,'623','2022-06-04 15:04:28','623','2022-06-04 15:04:47',10,0),('1','179',257419,'DAILY SHIFT','2022-06-04','2022-06-04 15:16:21','2022-06-05 15:16:21','623',0.00,0.00,'623','2022-06-04 19:33:40','623','2022-06-04 19:33:58',10,0),('1','179',257420,'DAILY SHIFT','2022-06-05','2022-06-05 08:07:04','2022-06-06 08:07:04','623',0.00,0.00,'623','2022-06-06 08:34:37','623','2022-06-06 08:34:59',10,0),('1','179',257421,'DAILY SHIFT','2022-06-07','2022-06-07 13:47:19','2022-06-08 13:47:19','623',0.00,0.00,'623','2022-06-08 08:39:10','623','2022-06-08 08:39:29',10,0),('1','179',257422,'DAILY SHIFT','2022-06-08','2022-06-08 08:39:58','2022-06-09 08:39:58','623',0.00,0.00,'623','2022-06-08 19:45:03','623','2022-06-08 19:45:25',10,0),('1','179',257423,'DAILY SHIFT','2022-06-09','2022-06-09 07:43:51','2022-06-10 07:43:51','623',0.00,0.00,'623','2022-06-10 08:07:06','623','2022-06-10 08:07:26',10,0),('1','179',257424,'DAILY SHIFT','2022-06-10','2022-06-10 08:11:49','2022-06-11 08:11:49','623',0.00,0.00,'623','2022-06-11 08:10:08','623','2022-06-11 08:10:37',10,0),('1','179',257425,'DAILY SHIFT','2022-06-11','2022-06-11 08:10:56','2022-06-12 08:10:56','623',0.00,0.00,'623','2022-06-12 07:59:57','623','2022-06-12 08:00:18',10,0),('1','179',257426,'DAILY SHIFT','2022-06-12','2022-06-12 08:00:43','2022-06-13 08:00:43','623',0.00,0.00,'623','2022-06-13 07:57:53','623','2022-06-13 07:58:19',10,0),('1','179',257427,'DAILY SHIFT','2022-06-13','2022-06-13 07:58:43','2022-06-14 07:58:43','623',0.00,0.00,'623','2022-06-13 19:56:45','623','2022-06-13 21:43:01',10,0),('1','179',257428,'DAILY SHIFT','2022-06-14','2022-06-14 07:42:02','2022-06-15 07:42:02','623',0.00,0.00,'623','2022-06-15 07:10:06','623','2022-06-15 07:10:37',10,0),('1','179',257429,'DAILY SHIFT','2022-06-15','2022-06-15 07:11:02','2022-06-16 07:11:02','623',0.00,0.00,'623','2022-06-15 22:02:44','623','2022-06-15 22:03:18',10,0),('1','179',257430,'DAILY SHIFT','2022-06-16','2022-06-16 08:21:41','2022-06-17 08:21:41','623',0.00,0.00,'623','2022-06-17 07:04:50','623','2022-06-17 07:05:17',10,0),('1','179',257431,'DAILY SHIFT','2022-06-17','2022-06-17 07:12:50','2022-06-18 07:12:50','623',0.00,0.00,'623','2022-06-18 06:58:20','623','2022-06-18 06:59:26',10,0),('1','179',257432,'DAILY SHIFT','2022-06-18','2022-06-18 07:00:09','2022-06-19 07:00:09','623',0.00,0.00,'623','2022-06-18 19:18:19','623','2022-06-18 19:18:35',10,0),('1','179',257433,'DAILY SHIFT','2022-06-19','2022-06-19 07:57:58','2022-06-20 07:57:58','623',0.00,0.00,'623','2022-06-19 19:20:17','623','2022-06-19 19:20:31',10,0),('1','179',257434,'DAILY SHIFT','2022-06-20','2022-06-20 08:27:46','2022-06-21 08:27:46','623',0.00,0.00,'623','2022-06-20 19:14:35','623','2022-06-20 19:14:52',10,0),('1','179',257435,'DAILY SHIFT','2022-06-21','2022-06-21 07:47:23','2022-06-22 07:47:23','623',0.00,0.00,'623','2022-06-21 21:07:05','623','2022-06-21 21:07:26',10,0),('1','179',257436,'DAILY SHIFT','2022-06-22','2022-06-22 08:13:00','2022-06-23 08:13:00','623',0.00,0.00,'623','2022-06-22 21:31:55','623','2022-06-22 21:33:52',10,0),('1','179',257437,'DAILY SHIFT','2022-06-23','2022-06-23 08:02:01','2022-06-24 08:02:01','623',0.00,0.00,'623','2022-06-23 19:10:48','623','2022-06-23 19:11:15',10,0),('1','179',257438,'DAILY SHIFT','2022-06-24','2022-06-24 07:58:56','2022-06-25 07:58:56','623',0.00,0.00,'623','2022-06-24 10:50:58','623','2022-06-24 10:52:27',10,0),('1','179',257439,'DAILY SHIFT','2022-06-24','2022-06-24 10:54:03','2022-06-25 10:54:03','623',0.00,0.00,'623','2022-06-25 08:11:12','623','2022-06-25 08:11:42',10,0),('1','179',257440,'DAILY SHIFT','2022-06-25','2022-06-25 08:17:02','2022-06-26 08:17:02','623',0.00,0.00,'623','2022-06-25 19:38:39','623','2022-06-25 19:39:01',10,0),('1','179',257441,'DAILY SHIFT','2022-06-26','2022-06-26 08:25:54','2022-06-27 08:25:54','623',0.00,0.00,'623','2022-06-26 19:04:45','623','2022-06-26 19:05:04',10,0),('1','179',257442,'DAILY SHIFT','2022-06-27','2022-06-27 08:35:09','2022-06-28 08:35:09','623',0.00,0.00,'623','2022-06-27 20:17:53','623','2022-06-27 20:18:15',10,0),('1','179',257443,'DAILY SHIFT','2022-06-28','2022-06-28 07:35:47','2022-06-29 07:35:47','623',0.00,0.00,'623','2022-06-28 19:44:53','623','2022-06-28 19:45:11',10,0),('1','179',257444,'DAILY SHIFT','2022-06-29','2022-06-29 08:25:48','2022-06-30 08:25:48','623',0.00,0.00,'623','2022-06-29 21:38:11','623','2022-06-29 21:39:27',10,0),('1','179',257445,'DAILY SHIFT','2022-06-30','2022-06-30 08:33:40','2022-07-01 08:33:40','623',0.00,0.00,'623','2022-06-30 19:47:26','623','2022-06-30 19:47:42',10,0),('1','179',257446,'DAILY SHIFT','2022-07-01','2022-07-01 08:12:03','2022-07-02 08:12:03','623',0.00,0.00,'623','2022-07-01 19:31:16','623','2022-07-01 19:31:45',10,0),('1','179',257447,'DAILY SHIFT','2022-07-02','2022-07-02 08:07:46','2022-07-03 08:07:46','623',0.00,0.00,'623','2022-07-02 19:41:46','623','2022-07-02 19:42:07',10,0),('1','179',257448,'DAILY SHIFT','2022-07-03','2022-07-03 08:18:17','2022-07-04 08:18:17','623',0.00,0.00,'623','2022-07-03 19:48:54','623','2022-07-03 19:49:11',10,0),('1','179',257449,'DAILY SHIFT','2022-07-04','2022-07-04 08:26:03','2022-07-05 08:26:03','623',0.00,0.00,'623','2022-07-04 19:44:14','623','2022-07-04 19:44:41',10,0),('1','179',257450,'DAILY SHIFT','2022-07-05','2022-07-05 07:50:32','2022-07-06 07:50:32','623',0.00,0.00,'623','2022-07-05 19:48:43','623','2022-07-05 19:49:03',10,0),('1','179',257451,'DAILY SHIFT','2022-07-06','2022-07-06 07:56:18','2022-07-07 07:56:18','623',0.00,0.00,'623','2022-07-06 19:55:25','623','2022-07-06 19:57:11',10,0),('1','179',257452,'DAILY SHIFT','2022-07-07','2022-07-07 08:05:06','2022-07-08 08:05:06','623',0.00,0.00,'623','2022-07-07 19:17:42','623','2022-07-07 19:18:00',10,0),('1','179',257453,'DAILY SHIFT','2022-07-08','2022-07-08 08:21:19','2022-07-09 08:21:19','623',0.00,0.00,'623','2022-07-08 19:51:31','623','2022-07-08 20:38:37',10,0),('1','179',257454,'DAILY SHIFT','2022-07-09','2022-07-09 11:13:38','2022-07-10 11:13:38','623',0.00,0.00,'623','2022-07-09 18:33:29','623','2022-07-09 18:34:02',10,0),('1','179',257455,'DAILY SHIFT','2022-07-10','2022-07-10 08:29:21','2022-07-11 08:29:21','623',0.00,0.00,'623','2022-07-10 18:49:12','623','2022-07-10 18:49:41',10,0),('1','179',257456,'DAILY SHIFT','2022-07-11','2022-07-11 08:42:06','2022-07-12 08:42:06','623',0.00,0.00,'623','2022-07-11 19:48:42','623','2022-07-11 19:49:03',10,0),('1','179',257457,'DAILY SHIFT','2022-07-12','2022-07-12 08:02:24','2022-07-13 08:02:24','623',0.00,0.00,'623','2022-07-12 19:17:19','623','2022-07-12 19:18:43',10,0),('1','179',257458,'DAILY SHIFT','2022-07-13','2022-07-13 08:20:59','2022-07-14 08:20:59','623',0.00,0.00,'623','2022-07-13 21:35:34','623','2022-07-13 21:36:07',10,0),('1','179',257459,'DAILY SHIFT','2022-07-14','2022-07-14 08:10:25','2022-07-15 08:10:25','623',0.00,0.00,'623','2022-07-15 08:19:58','623','2022-07-15 08:20:16',10,0),('1','179',257460,'DAILY SHIFT','2022-07-15','2022-07-15 08:20:43','2022-07-16 08:20:43','623',0.00,0.00,'623','2022-07-15 19:38:09','623','2022-07-15 19:39:26',10,0),('1','179',257461,'DAILY SHIFT','2022-07-16','2022-07-16 08:22:34','2022-07-17 08:22:34','623',0.00,0.00,'623','2022-07-16 19:09:46','623','2022-07-16 19:10:03',10,0),('1','179',257462,'DAILY SHIFT','2022-07-17','2022-07-17 08:25:07','2022-07-18 08:25:07','623',0.00,0.00,'623','2022-07-17 19:09:08','623','2022-07-17 19:09:25',10,0),('1','179',257463,'DAILY SHIFT','2022-07-18','2022-07-18 09:09:00','2022-07-19 09:09:00','623',0.00,0.00,'623','2022-07-18 19:09:34','623','2022-07-18 19:09:48',10,0),('1','179',257464,'DAILY SHIFT','2022-07-19','2022-07-19 09:01:59','2022-07-20 09:01:59','623',0.00,0.00,'623','2022-07-19 19:10:37','623','2022-07-19 19:10:53',10,0),('1','179',257465,'DAILY SHIFT','2022-07-20','2022-07-20 08:17:48','2022-07-21 08:17:48','623',0.00,0.00,'623','2022-07-20 19:11:58','623','2022-07-20 19:12:16',10,0),('1','179',257466,'DAILY SHIFT','2022-07-21','2022-07-21 08:00:08','2022-07-22 08:00:08','623',0.00,0.00,'623','2022-07-21 19:13:49','623','2022-07-21 19:14:41',10,0),('1','179',257467,'DAILY SHIFT','2022-07-22','2022-07-22 07:56:22','2022-07-23 07:56:22','623',0.00,0.00,'623','2022-07-22 18:42:01','623','2022-07-23 08:10:04',10,0),('1','179',257468,'DAILY SHIFT','2022-07-23','2022-07-23 08:10:24','2022-07-24 08:10:24','623',0.00,0.00,'623','2022-07-23 19:10:27','623','2022-07-23 19:10:44',10,0),('1','179',257469,'DAILY SHIFT','2022-07-24','2022-07-24 08:04:30','2022-07-25 08:04:30','623',0.00,0.00,'623','2022-07-24 19:02:04','623','2022-07-24 19:02:20',10,0),('1','179',257470,'DAILY SHIFT','2022-07-25','2022-07-25 08:14:19','2022-07-26 08:14:19','623',0.00,0.00,'623','2022-07-25 19:24:04','623','2022-07-25 19:24:18',10,0),('1','179',257471,'DAILY SHIFT','2022-07-26','2022-07-26 08:13:40','2022-07-27 08:13:40','623',0.00,0.00,'623','2022-07-26 18:09:26','623','2022-07-26 18:09:50',10,0),('1','179',257472,'DAILY SHIFT','2022-07-27','2022-07-27 08:04:49','2022-07-28 08:04:49','623',0.00,0.00,'623','2022-07-27 08:07:32','623','2022-07-27 08:07:54',10,0),('1','179',257473,'DAILY SHIFT','2022-07-27','2022-07-27 08:11:04','2022-07-28 08:11:04','623',0.00,0.00,'623','2022-07-27 19:09:02','623','2022-07-27 19:09:20',10,0),('1','179',257474,'DAILY SHIFT','2022-07-28','2022-07-28 11:19:00','2022-07-29 11:19:00','623',0.00,0.00,'623','2022-07-28 19:15:03','623','2022-07-28 19:15:16',10,0),('1','179',257475,'DAILY SHIFT','2022-07-29','2022-07-29 08:12:00','2022-07-30 08:12:00','623',0.00,0.00,'623','2022-07-29 19:07:44','623','2022-07-29 19:08:04',10,0),('1','179',257476,'DAILY SHIFT','2022-07-30','2022-07-30 08:14:40','2022-07-31 08:14:40','623',0.00,0.00,'623','2022-07-30 19:09:54','623','2022-07-30 19:10:10',10,0),('1','179',257477,'DAILY SHIFT','2022-07-31','2022-07-31 08:58:10','2022-08-01 08:58:10','623',0.00,0.00,'623','2022-07-31 19:05:02','623','2022-07-31 19:07:14',10,0),('1','179',257478,'DAILY SHIFT','2022-08-01','2022-08-01 08:25:07','2022-08-02 08:25:07','623',0.00,0.00,'623','2022-08-01 20:11:18','623','2022-08-01 20:11:33',10,0),('1','179',257479,'DAILY SHIFT','2022-08-02','2022-08-02 08:23:23','2022-08-03 08:23:23','623',0.00,0.00,'623','2022-08-02 19:55:45','623','2022-08-02 19:56:05',10,0),('1','179',257480,'DAILY SHIFT','2022-08-03','2022-08-03 07:59:38','2022-08-04 07:59:38','623',0.00,0.00,'623','2022-08-03 18:59:48','623','2022-08-03 19:00:34',10,0),('1','179',257481,'DAILY SHIFT','2022-08-04','2022-08-04 11:16:01','2022-08-05 11:16:01','623',0.00,0.00,'623','2022-08-05 09:39:55','623','2022-08-05 09:40:45',10,0),('1','179',257482,'DAILY SHIFT','2022-08-05','2022-08-05 09:41:29','2022-08-06 09:41:29','623',0.00,0.00,'623','2022-08-05 19:16:37','623','2022-08-05 19:17:38',10,0),('1','179',257483,'DAILY SHIFT','2022-08-06','2022-08-06 08:18:02','2022-08-07 08:18:02','623',0.00,0.00,'623','2022-08-06 19:37:48','623','2022-08-06 19:38:15',10,0),('1','179',257484,'DAILY SHIFT','2022-08-07','2022-08-07 09:31:07','2022-08-08 09:31:07','623',0.00,0.00,'623','2022-08-07 19:13:03','623','2022-08-07 19:13:30',10,0),('1','179',257485,'DAILY SHIFT','2022-08-08','2022-08-08 08:15:21','2022-08-09 08:15:21','623',0.00,0.00,'623','2022-08-08 19:38:53','623','2022-08-08 19:39:22',10,0),('1','179',257486,'DAILY SHIFT','2022-08-09','2022-08-09 08:17:55','2022-08-10 08:17:55','623',0.00,0.00,'623','2022-08-09 19:43:36','623','2022-08-09 19:43:50',10,0),('1','179',257487,'DAILY SHIFT','2022-08-22','2022-08-22 09:42:07','2022-08-23 09:42:07','623',0.00,0.00,'623','2022-08-22 19:04:17','623','2022-08-22 19:04:38',10,0),('1','179',257488,'DAILY SHIFT','2022-08-23','2022-08-23 08:31:52','2022-08-24 08:31:52','623',0.00,0.00,'623','2022-08-23 19:09:08','623','2022-08-23 19:09:37',10,0),('1','179',257489,'DAILY SHIFT','2022-08-24','2022-08-24 08:13:11','2022-08-25 08:13:11','623',0.00,0.00,'623','2022-08-24 19:28:31','623','2022-08-24 19:28:56',10,0),('1','179',257490,'DAILY SHIFT','2022-08-25','2022-08-25 08:08:18','2022-08-26 08:08:18','623',0.00,0.00,'623','2022-08-25 17:53:03','623','2022-08-25 17:53:28',10,0),('1','179',257491,'DAILY SHIFT','2022-08-25','2022-08-25 17:54:07','2022-08-26 17:54:07','623',0.00,0.00,'623','2022-08-25 19:03:28','623','2022-08-25 19:03:43',10,0),('1','179',257492,'DAILY SHIFT','2022-08-26','2022-08-26 08:00:36','2022-08-27 08:00:36','623',0.00,0.00,'623','2022-08-26 19:03:32','623','2022-08-26 19:04:01',10,0),('1','179',257493,'DAILY SHIFT','2022-08-27','2022-08-27 08:07:39','2022-08-28 08:07:39','623',0.00,0.00,'623','2022-08-28 08:15:01','623','2022-08-28 08:15:18',10,0),('1','179',257494,'DAILY SHIFT','2022-08-28','2022-08-28 08:15:41','2022-08-29 08:15:41','623',0.00,0.00,'623','2022-08-28 19:16:47','623','2022-08-28 19:17:02',10,0),('1','179',257495,'DAILY SHIFT','2022-08-29','2022-08-29 08:10:13','2022-08-30 08:10:13','623',0.00,0.00,'623','2022-08-29 18:21:15','623','2022-08-29 18:22:10',10,0),('1','179',257496,'DAILY SHIFT','2022-08-30','2022-08-30 11:14:22','2022-08-31 11:14:22','623',0.00,0.00,'623','2022-08-30 17:48:28','623','2022-08-30 17:49:05',10,0),('1','179',257497,'DAILY SHIFT','2022-08-31','2022-08-31 08:00:10','2022-09-01 08:00:10','623',0.00,0.00,'623','2022-08-31 16:59:04','623','2022-08-31 17:00:31',10,0),('1','179',257498,'DAILY SHIFT','2022-09-04','2022-09-04 10:55:10','2022-09-05 10:55:10','623',0.00,0.00,'623','2022-09-04 19:08:09','623','2022-09-04 19:08:29',10,0),('1','179',257499,'DAILY SHIFT','2022-09-05','2022-09-05 08:28:42','2022-09-06 08:28:42','623',0.00,0.00,'623','2022-09-05 19:15:19','623','2022-09-05 19:15:38',10,0),('1','179',257500,'DAILY SHIFT','2022-09-06','2022-09-06 08:27:26','2022-09-07 08:27:26','623',0.00,0.00,'623','2022-09-06 19:23:54','623','2022-09-07 08:31:06',10,0),('1','179',257501,'DAILY SHIFT','2022-09-07','2022-09-07 08:31:31','2022-09-08 08:31:31','623',0.00,0.00,'623','2022-09-07 19:10:16','623','2022-09-07 19:10:51',10,0),('1','179',257502,'DAILY SHIFT','2022-09-08','2022-09-08 08:35:55','2022-09-09 08:35:55','623',0.00,0.00,'623','2022-09-08 18:57:01','623','2022-09-08 18:57:14',10,0),('1','179',257503,'DAILY SHIFT','2022-09-09','2022-09-09 08:29:52','2022-09-10 08:29:52','623',0.00,0.00,'623','2022-09-09 18:55:11','623','2022-09-09 18:55:26',10,0),('1','179',257504,'DAILY SHIFT','2022-09-10','2022-09-10 08:19:49','2022-09-11 08:19:49','623',0.00,0.00,'623','2022-09-10 18:57:40','623','2022-09-10 18:57:59',10,0),('1','179',257505,'DAILY SHIFT','2022-09-11','2022-09-11 08:23:02','2022-09-12 08:23:02','623',0.00,0.00,'623','2022-09-11 19:00:04','623','2022-09-11 19:00:19',10,0),('1','179',257506,'DAILY SHIFT','2022-09-12','2022-09-12 08:30:24','2022-09-13 08:30:24','623',0.00,0.00,'623','2022-09-12 18:59:34','623','2022-09-12 19:00:04',10,0),('1','179',257507,'DAILY SHIFT','2022-09-13','2022-09-13 08:13:15','2022-09-14 08:13:15','623',0.00,0.00,'623','2022-09-13 19:16:10','623','2022-09-13 19:16:45',10,0),('1','179',257508,'DAILY SHIFT','2022-09-14','2022-09-14 08:36:42','2022-09-15 08:36:42','623',0.00,0.00,'623','2022-09-14 19:22:21','623','2022-09-14 19:22:36',10,0),('1','179',257509,'DAILY SHIFT','2022-09-15','2022-09-15 08:21:10','2022-09-16 08:21:10','623',0.00,0.00,'623','2022-09-15 18:39:32','623','2022-09-15 18:39:56',10,0),('1','179',257510,'DAILY SHIFT','2022-09-16','2022-09-16 08:21:22','2022-09-17 08:21:22','623',0.00,0.00,'623','2022-09-16 18:54:32','623','2022-09-16 18:54:48',10,0),('1','179',257511,'DAILY SHIFT','2022-09-17','2022-09-17 08:38:00','2022-09-18 08:38:00','623',0.00,0.00,'623','2022-09-17 18:51:25','623','2022-09-17 18:51:41',10,0),('1','179',257512,'DAILY SHIFT','2022-09-18','2022-09-18 08:28:18','2022-09-19 08:28:18','623',0.00,0.00,'623','2022-09-18 19:13:57','623','2022-09-18 19:14:16',10,0),('1','179',257513,'DAILY SHIFT','2022-09-19','2022-09-19 08:25:46','2022-09-20 08:25:46','623',0.00,0.00,'623','2022-09-19 16:38:58','623','2022-09-19 16:40:29',10,0),('1','179',257514,'DAILY SHIFT','2022-09-22','2022-09-22 11:03:08','2022-09-23 11:03:08','623',0.00,0.00,'623','2022-09-23 08:12:54','623','2022-09-23 08:13:08',10,0),('1','179',257515,'DAILY SHIFT','2022-09-23','2022-09-23 08:13:26','2022-09-24 08:13:26','623',0.00,0.00,'623','2022-09-23 18:51:03','623','2022-09-23 18:51:16',10,0),('1','179',257516,'DAILY SHIFT','2022-09-24','2022-09-24 08:10:46','2022-09-25 08:10:46','623',0.00,0.00,'623','2022-09-24 15:10:11','623','2022-09-24 15:10:26',10,0),('1','179',257517,'DAILY SHIFT','2022-09-25','2022-09-25 15:43:52','2022-09-26 15:43:52','623',0.00,0.00,'623','2022-09-25 16:36:29','623','2022-09-25 16:36:44',10,0),('1','179',257518,'DAILY SHIFT','2022-09-26','2022-09-26 08:20:24','2022-09-27 08:20:24','623',0.00,0.00,'623','2022-09-26 18:48:03','623','2022-09-26 18:48:46',10,0),('1','179',257519,'DAILY SHIFT','2022-09-27','2022-09-27 08:27:18','2022-09-28 08:27:18','623',0.00,0.00,'623','2022-09-27 18:48:10','623','2022-09-27 18:48:47',10,0),('1','179',257520,'DAILY SHIFT','2022-09-28','2022-09-28 08:35:32','2022-09-29 08:35:32','623',0.00,0.00,'623','2022-09-28 18:50:33','623','2022-09-28 18:50:52',10,0),('1','179',257521,'DAILY SHIFT','2022-09-29','2022-09-29 08:23:22','2022-09-30 08:23:22','623',0.00,0.00,'623','2022-09-30 08:27:31','623','2022-09-30 08:29:16',10,0),('1','179',257522,'DAILY SHIFT','2022-09-30','2022-09-30 08:29:44','2022-10-01 08:29:44','623',0.00,0.00,'623','2022-09-30 18:45:52','623','2022-09-30 18:46:13',10,0),('1','179',257523,'DAILY SHIFT','2022-10-01','2022-10-01 07:56:40','2022-10-02 07:56:40','623',0.00,0.00,'623','2022-10-01 19:10:13','623','2022-10-01 19:10:39',10,0),('1','179',257524,'DAILY SHIFT','2022-10-02','2022-10-02 08:28:46','2022-10-03 08:28:46','623',0.00,0.00,'623','2022-10-02 19:08:38','623','2022-10-02 19:09:16',10,0),('1','179',257525,'DAILY SHIFT','2022-10-03','2022-10-03 08:27:02','2022-10-04 08:27:02','623',0.00,0.00,'623','2022-10-03 18:48:45','623','2022-10-03 18:48:59',10,0),('1','179',257526,'DAILY SHIFT','2022-10-04','2022-10-04 08:38:47','2022-10-05 08:38:47','623',0.00,0.00,'623','2022-10-04 19:00:38','623','2022-10-04 19:00:55',10,0),('1','179',257527,'DAILY SHIFT','2022-10-05','2022-10-05 08:17:32','2022-10-06 08:17:32','623',0.00,0.00,'623','2022-10-05 19:34:52','623','2022-10-05 19:35:27',10,0),('1','179',257528,'DAILY SHIFT','2022-10-06','2022-10-06 08:14:51','2022-10-07 08:14:51','623',0.00,0.00,'623','2022-10-06 19:13:52','623','2022-10-06 19:14:36',10,0),('1','179',257529,'DAILY SHIFT','2022-10-07','2022-10-07 08:23:06','2022-10-08 08:23:06','623',0.00,0.00,'623','2022-10-07 12:39:52','623','2022-10-07 12:40:15',10,0),('1','179',257530,'DAILY SHIFT','2022-10-07','2022-10-11 13:05:58','2022-10-12 13:05:58','623',0.00,0.00,'623','2022-10-11 13:17:52','623','2022-10-11 13:18:40',10,0),('1','179',257531,'DAILY SHIFT','2022-10-11','2022-10-11 13:22:06','2022-10-12 13:22:06','623',0.00,0.00,'623','2022-10-11 19:09:27','623','2022-10-11 19:09:59',10,0),('1','179',257532,'DAILY SHIFT','2022-10-12','2022-10-12 08:18:21','2022-10-13 08:18:21','623',0.00,0.00,'623','2022-10-12 18:59:41','623','2022-10-12 19:00:08',10,0),('1','179',257533,'DAILY SHIFT','2022-10-13','2022-10-13 08:17:29','2022-10-14 08:17:29','623',0.00,0.00,'623','2022-10-13 19:56:39','623','2022-10-13 19:57:13',10,0),('1','179',257534,'DAILY SHIFT','2022-10-14','2022-10-14 09:00:55','2022-10-15 09:00:55','623',0.00,0.00,'623','2022-10-14 20:40:32','623','2022-10-14 20:41:09',10,0),('1','179',257535,'DAILY SHIFT','2022-10-15','2022-10-15 10:49:33','2022-10-16 10:49:33','623',0.00,0.00,'623','2022-10-15 10:50:00','623','2022-10-15 10:50:22',10,0),('1','179',257536,'DAILY SHIFT','2022-10-15','2022-10-15 10:52:45','2022-10-16 10:52:45','623',0.00,0.00,'623','2022-10-15 17:47:04','623','2022-10-15 17:47:33',10,0),('1','179',257537,'DAILY SHIFT','2022-10-16','2022-10-16 09:03:44','2022-10-17 09:03:44','623',0.00,0.00,'623','2022-10-16 20:27:28','623','2022-10-16 20:27:58',10,0),('1','179',257538,'DAILY SHIFT','2022-10-17','2022-10-17 13:54:28','2022-10-18 13:54:28','623',0.00,0.00,'623','2022-10-18 10:21:16','623','2022-10-18 10:22:15',10,0),('1','179',257539,'DAILY SHIFT','2022-10-18','2022-10-18 10:22:48','2022-10-19 10:22:48','623',0.00,0.00,'623','2022-10-18 12:23:01','623','2022-10-18 12:23:21',10,0),('1','179',257540,'DAILY SHIFT','2022-10-19','2022-10-19 16:48:18','2022-10-20 16:48:18','623',0.00,0.00,'623','2022-10-19 17:36:52','623','2022-10-19 17:37:21',10,0),('1','179',257541,'DAILY SHIFT','2022-10-20','2022-10-25 13:56:52','2022-10-26 13:56:52','623',0.00,0.00,'623','2022-10-25 16:01:54','623','2022-10-25 16:02:08',10,0),('1','179',257542,'DAILY SHIFT','2022-10-20','2022-10-26 08:36:31','2022-10-27 08:36:31','623',0.00,0.00,'623','2022-10-26 08:41:15','623','2022-10-26 08:41:31',10,0),('1','179',257543,'DAILY SHIFT','2022-10-26','2022-10-26 08:42:43','2022-10-27 08:42:43','623',0.00,0.00,'623','2022-10-26 19:00:54','623','2022-10-26 19:01:14',10,0),('1','179',257544,'DAILY SHIFT','2022-10-27','2022-10-27 09:24:24','2022-10-28 09:24:24','623',0.00,0.00,'623','2022-10-27 18:29:30','623','2022-10-27 18:29:56',10,0),('1','179',257545,'DAILY SHIFT','2022-10-28','2022-10-28 11:04:37','2022-10-29 11:04:37','623',0.00,0.00,'623','2022-10-28 18:56:04','623','2022-10-28 18:56:20',10,0),('1','179',257546,'DAILY SHIFT','2022-10-29','2022-10-29 09:36:15','2022-10-30 09:36:15','623',0.00,0.00,'623','2022-10-29 19:18:48','623','2022-10-29 19:22:23',10,0),('1','179',257547,'DAILY SHIFT','2022-10-30','2022-10-30 08:18:38','2022-10-31 08:18:38','623',0.00,0.00,'623','2022-10-30 18:59:38','623','2022-10-30 18:59:57',10,0),('1','179',257548,'DAILY SHIFT','2022-10-31','2022-10-31 08:31:28','2022-11-01 08:31:28','623',0.00,0.00,'623','2022-10-31 18:28:44','623','2022-10-31 18:29:05',10,0),('1','179',257549,'DAILY SHIFT','2022-11-01','2022-11-01 10:38:55','2022-11-02 10:38:55','623',0.00,0.00,'623','2022-11-01 14:14:39','623','2022-11-01 14:15:11',10,0),('1','179',257550,'DAILY SHIFT','2022-11-01','2022-11-05 09:21:24','2022-11-06 09:21:24','623',0.00,0.00,'623','2022-11-05 09:24:26','623','2022-11-05 09:24:43',10,0),('1','179',257551,'DAILY SHIFT','2022-11-05','2022-11-05 12:54:29','2022-11-06 12:54:29','623',0.00,0.00,'623','2022-11-05 18:55:34','623','2022-11-05 18:55:46',10,0),('1','179',257552,'DAILY SHIFT','2022-11-06','2022-11-06 08:27:47','2022-11-07 08:27:47','623',0.00,0.00,'623','2022-11-06 19:00:47','623','2022-11-06 19:01:00',10,0),('1','179',257553,'DAILY SHIFT','2022-11-07','2022-11-07 08:23:31','2022-11-08 08:23:31','623',0.00,0.00,'623','2022-11-08 08:15:51','623','2022-11-08 08:16:09',10,0),('1','179',257554,'DAILY SHIFT','2022-11-08','2022-11-08 08:16:29','2022-11-09 08:16:29','623',0.00,0.00,'623','2022-11-08 18:50:17','623','2022-11-08 18:50:35',10,0),('1','179',257555,'DAILY SHIFT','2022-11-09','2022-11-09 07:49:43','2022-11-10 07:49:43','623',0.00,0.00,'623','2022-11-09 18:45:22','623','2022-11-09 18:45:53',10,0),('1','179',257556,'DAILY SHIFT','2022-11-10','2022-11-10 08:01:12','2022-11-11 08:01:12','623',0.00,0.00,'623','2022-11-10 15:49:11','623','2022-11-10 15:49:34',10,0),('1','179',257557,'DAILY SHIFT','2022-11-10','2022-11-10 15:49:59','2022-11-11 15:49:59','623',0.00,0.00,'623','2022-11-10 19:10:52','623','2022-11-10 19:11:09',10,0),('1','179',257558,'DAILY SHIFT','2022-11-11','2022-11-11 08:07:28','2022-11-12 08:07:28','623',0.00,0.00,'623','2022-11-12 10:05:13','623','2022-11-12 10:08:44',10,0),('1','179',257559,'DAILY SHIFT','2022-11-12','2022-11-12 10:09:34','2022-11-13 10:09:34','623',0.00,0.00,'623','2022-11-12 18:53:47','623','2022-11-12 18:54:02',10,0),('1','179',257560,'DAILY SHIFT','2022-11-13','2022-11-13 08:13:04','2022-11-14 08:13:04','623',0.00,0.00,'623','2022-11-13 18:16:39','623','2022-11-13 18:16:56',10,0),('1','179',257561,'DAILY SHIFT','2022-11-14','2022-11-14 08:21:57','2022-11-15 08:21:57','623',0.00,0.00,'623','2022-11-14 18:56:21','623','2022-11-14 18:56:35',10,0),('1','179',257562,'DAILY SHIFT','2022-11-15','2022-11-15 10:31:12','2022-11-16 10:31:12','623',0.00,0.00,'623','2022-11-15 10:36:02','623','2022-11-15 10:37:02',10,0),('1','179',257563,'DAILY SHIFT','2022-11-17','2022-11-17 09:54:40','2022-11-18 09:54:40','623',0.00,0.00,'623','2022-11-17 19:26:36','623','2022-11-17 19:26:59',10,0),('1','179',257564,'DAILY SHIFT','2022-11-18','2022-11-18 08:27:54','2022-11-19 08:27:54','623',0.00,0.00,'623','2022-11-18 18:04:48','623','2022-11-18 18:05:02',10,0),('1','179',257565,'DAILY SHIFT','2022-11-19','2022-11-19 08:36:57','2022-11-20 08:36:57','623',0.00,0.00,'623','2022-11-19 18:18:37','623','2022-11-19 18:18:57',10,0),('1','179',257566,'DAILY SHIFT','2022-11-20','2022-11-20 08:27:26','2022-11-21 08:27:26','623',0.00,0.00,'623','2022-11-20 18:54:47','623','2022-11-20 18:55:15',10,0),('1','179',257567,'DAILY SHIFT','2022-11-21','2022-11-21 08:23:20','2022-11-22 08:23:20','623',0.00,0.00,'623','2022-11-21 21:37:43','623','2022-11-21 21:37:58',10,0),('1','179',257568,'DAILY SHIFT','2022-11-22','2022-11-22 08:42:57','2022-11-23 08:42:57','623',0.00,0.00,'623','2022-11-22 18:51:28','623','2022-11-22 18:51:41',10,0),('1','179',257569,'DAILY SHIFT','2022-11-23','2022-11-23 08:24:23','2022-11-24 08:24:23','623',0.00,0.00,'623','2022-11-23 09:20:04','623','2022-11-23 09:20:18',10,0),('1','179',257570,'DAILY SHIFT','2022-11-23','2022-11-23 09:32:15','2022-11-24 09:32:15','623',0.00,0.00,'623','2022-11-23 19:03:01','623','2022-11-23 19:03:18',10,0),('1','179',257571,'DAILY SHIFT','2022-11-24','2022-11-24 08:28:05','2022-11-25 08:28:05','623',0.00,0.00,'623','2022-11-24 18:19:00','623','2022-11-24 18:19:12',10,0),('1','179',257572,'DAILY SHIFT','2022-11-25','2022-11-25 08:17:12','2022-11-26 08:17:12','623',0.00,0.00,'623','2022-11-25 18:13:32','623','2022-11-25 18:13:48',10,0),('1','179',257573,'DAILY SHIFT','2022-11-26','2022-11-26 08:16:02','2022-11-27 08:16:02','623',0.00,0.00,'623','2022-11-26 18:15:04','623','2022-11-26 18:15:27',10,0),('1','179',257574,'DAILY SHIFT','2022-11-27','2022-11-27 07:57:40','2022-11-28 07:57:40','623',0.00,0.00,'623','2022-11-28 07:54:41','623','2022-11-28 07:54:54',10,0),('1','179',257575,'DAILY SHIFT','2022-11-28','2022-11-28 07:55:34','2022-11-29 07:55:34','623',0.00,0.00,'623','2022-11-28 18:19:16','623','2022-11-28 18:19:31',10,0),('1','179',257576,'DAILY SHIFT','2022-11-29','2022-11-29 07:46:18','2022-11-30 07:46:18','623',0.00,0.00,'623','2022-11-29 19:18:19','623','2022-11-29 19:18:34',10,0),('1','179',257577,'DAILY SHIFT','2022-11-30','2022-11-30 08:11:58','2022-12-01 08:11:58','623',0.00,0.00,'623','2022-11-30 18:52:22','623','2022-11-30 18:52:40',10,0),('1','179',257578,'DAILY SHIFT','2022-12-01','2022-12-01 08:12:54','2022-12-02 08:12:54','623',0.00,0.00,'623','2022-12-01 18:46:31','623','2022-12-01 18:46:48',10,0),('1','179',257579,'DAILY SHIFT','2022-12-02','2022-12-02 07:56:30','2022-12-03 07:56:30','623',0.00,0.00,'623','2022-12-02 18:09:01','623','2022-12-02 18:09:15',10,0),('1','179',257580,'DAILY SHIFT','2022-12-03','2022-12-03 08:11:46','2022-12-04 08:11:46','623',0.00,0.00,'623','2022-12-03 18:10:06','623','2022-12-03 18:10:18',10,0),('1','179',257581,'DAILY SHIFT','2022-12-04','2022-12-04 08:07:09','2022-12-05 08:07:09','623',0.00,0.00,'623','2022-12-04 18:16:10','623','2022-12-04 18:16:24',10,0),('1','179',257582,'DAILY SHIFT','2022-12-05','2022-12-05 08:39:21','2022-12-06 08:39:21','623',0.00,0.00,'623','2022-12-05 17:28:48','623','2022-12-05 17:29:01',10,0),('1','179',257583,'DAILY SHIFT','2022-12-09','2022-12-09 14:58:56','2022-12-10 14:58:56','623',0.00,0.00,'623','2022-12-09 18:13:50','623','2022-12-09 18:14:06',10,0),('1','179',257584,'DAILY SHIFT','2022-12-05','2022-12-10 08:25:32','2022-12-11 08:25:32','623',0.00,0.00,'623','2022-12-10 08:29:22','623','2022-12-10 08:29:38',10,0),('1','179',257585,'DAILY SHIFT','2022-12-10','2022-12-10 08:35:49','2022-12-11 08:35:49','623',0.00,0.00,'623','2022-12-10 18:08:59','623','2022-12-10 18:09:14',10,0),('1','179',257586,'DAILY SHIFT','2022-12-11','2022-12-11 08:15:18','2022-12-12 08:15:18','623',0.00,0.00,'623','2022-12-11 18:03:53','623','2022-12-11 18:04:11',10,0),('1','179',257587,'DAILY SHIFT','2022-12-12','2022-12-12 08:23:01','2022-12-13 08:23:01','623',0.00,0.00,'623','2022-12-12 18:21:19','623','2022-12-12 18:21:35',10,0),('1','179',257588,'DAILY SHIFT','2022-12-13','2022-12-13 08:13:26','2022-12-14 08:13:26','623',0.00,0.00,'623','2022-12-13 18:11:34','623','2022-12-13 18:11:53',10,0),('1','179',257589,'DAILY SHIFT','2022-12-14','2022-12-14 08:14:03','2022-12-15 08:14:03','623',0.00,0.00,'623','2022-12-14 19:12:17','623','2022-12-14 19:13:21',10,0),('1','179',257590,'DAILY SHIFT','2022-12-15','2022-12-15 08:09:58','2022-12-16 08:09:58','623',0.00,0.00,'623','2022-12-15 13:15:07','623','2022-12-15 13:15:26',10,0),('1','179',257591,'DAILY SHIFT','2022-12-18','2022-12-18 09:29:02','2022-12-19 09:29:02','623',0.00,0.00,'623','2022-12-19 08:07:43','623','2022-12-19 08:08:20',10,0),('1','179',257592,'DAILY SHIFT','2022-12-19','2022-12-19 08:09:26','2022-12-20 08:09:26','623',0.00,0.00,'623','2022-12-19 18:56:50','623','2022-12-19 18:57:11',10,0),('1','179',257593,'DAILY SHIFT','2022-12-20','2022-12-20 08:47:11','2022-12-21 08:47:11','623',0.00,0.00,'623','2022-12-20 18:15:02','623','2022-12-20 18:15:18',10,0),('1','179',257594,'DAILY SHIFT','2022-12-21','2022-12-21 08:18:31','2022-12-22 08:18:31','623',0.00,0.00,'623','2022-12-21 18:14:48','623','2022-12-21 18:15:16',10,0),('1','179',257595,'DAILY SHIFT','2022-12-22','2022-12-22 08:03:10','2022-12-23 08:03:10','623',0.00,0.00,'623','2022-12-22 18:51:25','623','2022-12-22 18:51:39',10,0),('1','179',257596,'DAILY SHIFT','2022-12-23','2022-12-23 08:19:03','2022-12-24 08:19:03','623',0.00,0.00,'623','2022-12-23 18:50:56','623','2022-12-23 18:51:13',10,0),('1','179',257597,'DAILY SHIFT','2022-12-24','2022-12-24 08:36:50','2022-12-25 08:36:50','623',0.00,0.00,'623','2022-12-24 18:25:16','623','2022-12-24 18:25:30',10,0),('1','179',257598,'DAILY SHIFT','2022-12-25','2022-12-25 12:14:10','2022-12-26 12:14:10','623',0.00,0.00,'623','2022-12-25 18:04:25','623','2022-12-25 18:04:40',10,0),('1','179',257599,'DAILY SHIFT','2022-12-26','2022-12-26 08:22:01','2022-12-27 08:22:01','623',0.00,0.00,'623','2022-12-26 18:03:43','623','2022-12-26 18:06:39',10,0),('1','179',257600,'DAILY SHIFT','2022-12-27','2022-12-27 08:11:05','2022-12-28 08:11:05','623',0.00,0.00,'623','2022-12-27 18:25:25','623','2022-12-27 18:25:44',10,0),('1','179',257601,'DAILY SHIFT','2022-12-28','2022-12-28 08:35:30','2022-12-29 08:35:30','623',0.00,0.00,'623','2022-12-28 13:27:45','623','2022-12-28 13:28:08',10,0),('1','179',257602,'DAILY SHIFT','2022-12-29','2022-12-29 10:38:54','2022-12-30 10:38:54','623',0.00,0.00,'623','2022-12-29 10:43:18','623','2022-12-29 10:43:53',10,0),('1','179',257603,'DAILY SHIFT','2022-12-29','2022-12-29 12:01:27','2022-12-30 12:01:27','623',0.00,0.00,'623','2022-12-29 18:24:35','623','2022-12-29 18:24:49',10,0),('1','179',257604,'DAILY SHIFT','2022-12-30','2022-12-30 08:20:04','2022-12-31 08:20:04','623',0.00,0.00,'623','2022-12-31 12:35:34','623','2022-12-31 12:35:49',10,0),('1','179',257605,'DAILY SHIFT','2022-12-31','2022-12-31 12:36:12','2023-01-01 12:36:12','623',0.00,0.00,'623','2022-12-31 18:19:16','623','2022-12-31 18:19:48',10,0),('1','179',257606,'DAILY SHIFT','2023-01-01','2023-01-01 08:24:37','2023-01-02 08:24:37','623',0.00,0.00,'623','2023-01-01 18:23:52','623','2023-01-01 18:24:18',10,0),('1','179',257607,'DAILY SHIFT','2023-01-02','2023-01-02 08:31:43','2023-01-03 08:31:43','623',0.00,0.00,'623','2023-01-02 18:28:27','623','2023-01-02 18:28:43',10,0),('1','179',257608,'DAILY SHIFT','2023-01-03','2023-01-03 08:48:07','2023-01-04 08:48:07','623',0.00,0.00,'623','2023-01-03 19:08:57','623','2023-01-03 19:09:49',10,0),('1','179',257609,'DAILY SHIFT','2023-01-04','2023-01-04 08:08:00','2023-01-05 08:08:00','623',0.00,0.00,'623','2023-01-04 18:21:45','623','2023-01-04 18:21:57',10,0),('1','179',257610,'DAILY SHIFT','2023-01-05','2023-01-05 08:33:42','2023-01-06 08:33:42','623',0.00,0.00,'623','2023-01-05 18:23:55','623','2023-01-05 18:24:25',10,0),('1','179',257611,'DAILY SHIFT','2023-01-06','2023-01-06 08:20:12','2023-01-07 08:20:12','623',0.00,0.00,'623','2023-01-06 18:06:55','623','2023-01-06 18:07:07',10,0),('1','179',257612,'DAILY SHIFT','2023-01-07','2023-01-07 08:12:40','2023-01-08 08:12:40','623',0.00,0.00,'623','2023-01-07 18:31:22','623','2023-01-07 18:31:43',10,0),('1','179',257613,'DAILY SHIFT','2023-01-08','2023-01-08 11:05:45','2023-01-09 11:05:45','623',0.00,0.00,'623','2023-01-08 11:09:42','623','2023-01-08 11:09:58',10,0),('1','179',257614,'DAILY SHIFT','2023-01-08','2023-01-08 11:10:22','2023-01-09 11:10:22','623',0.00,0.00,'623','2023-01-08 18:30:33','623','2023-01-08 18:30:51',10,0),('1','179',257615,'DAILY SHIFT','2023-01-09','2023-01-09 08:16:12','2023-01-10 08:16:12','623',0.00,0.00,'623','2023-01-09 18:19:05','623','2023-01-09 18:19:29',10,0),('1','179',257616,'DAILY SHIFT','2023-01-10','2023-01-10 08:08:00','2023-01-11 08:08:00','623',0.00,0.00,'623','2023-01-10 19:00:12','623','2023-01-10 19:01:18',10,0),('1','179',257617,'DAILY SHIFT','2023-01-11','2023-01-11 08:35:53','2023-01-12 08:35:53','623',0.00,0.00,'623','2023-01-11 18:31:54','623','2023-01-11 18:32:48',10,0),('1','179',257618,'DAILY SHIFT','2023-01-12','2023-01-12 08:10:01','2023-01-13 08:10:01','623',0.00,0.00,'623','2023-01-12 18:17:38','623','2023-01-12 18:17:52',10,0),('1','179',257619,'DAILY SHIFT','2023-01-13','2023-01-13 08:04:03','2023-01-14 08:04:03','623',0.00,0.00,'623','2023-01-13 18:31:07','623','2023-01-13 18:31:32',10,0),('1','179',257620,'DAILY SHIFT','2023-01-14','2023-01-14 08:13:26','2023-01-15 08:13:26','623',0.00,0.00,'623','2023-01-14 18:34:41','623','2023-01-14 18:34:58',10,0),('1','179',257621,'DAILY SHIFT','2023-01-15','2023-01-15 08:26:49','2023-01-16 08:26:49','623',0.00,0.00,'623','2023-01-15 18:55:37','623','2023-01-15 18:56:07',10,0),('1','179',257622,'DAILY SHIFT','2023-01-16','2023-01-16 08:29:04','2023-01-17 08:29:04','623',0.00,0.00,'623','2023-01-17 08:09:54','623','2023-01-17 08:11:10',10,0),('1','179',257623,'DAILY SHIFT','2023-01-17','2023-01-17 08:11:59','2023-01-18 08:11:59','623',0.00,0.00,'623','2023-01-17 18:41:37','623','2023-01-17 18:41:52',10,0),('1','179',257624,'DAILY SHIFT','2023-01-18','2023-01-18 08:25:28','2023-01-19 08:25:28','623',0.00,0.00,'623','2023-01-18 18:11:38','623','2023-01-18 18:12:00',10,0),('1','179',257625,'DAILY SHIFT','2023-01-19','2023-01-19 08:24:52','2023-01-20 08:24:52','623',0.00,0.00,'623','2023-01-19 19:02:49','623','2023-01-19 19:03:17',10,0),('1','179',257626,'DAILY SHIFT','2023-01-20','2023-01-20 08:24:45','2023-01-21 08:24:45','623',0.00,0.00,'623','2023-01-20 13:25:05','623','2023-01-20 13:26:01',10,0),('1','179',257627,'DAILY SHIFT','2023-01-20','2023-01-20 13:26:30','2023-01-21 13:26:30','623',0.00,0.00,'623','2023-01-20 18:25:17','623','2023-01-20 18:25:34',10,0),('1','179',257628,'DAILY SHIFT','2023-01-21','2023-01-21 08:19:03','2023-01-22 08:19:03','623',0.00,0.00,'623','2023-01-21 19:13:07','623','2023-01-21 19:13:20',10,0),('1','179',257629,'DAILY SHIFT','2023-01-22','2023-01-22 09:03:44','2023-01-23 09:03:44','623',0.00,0.00,'623','2023-01-22 18:57:12','623','2023-01-22 18:58:08',10,0),('1','179',257630,'DAILY SHIFT','2023-01-23','2023-01-23 08:32:31','2023-01-24 08:32:31','623',0.00,0.00,'623','2023-01-23 18:22:41','623','2023-01-23 18:23:02',10,0),('1','179',257631,'DAILY SHIFT','2023-01-24','2023-01-24 08:16:30','2023-01-25 08:16:30','623',0.00,0.00,'623','2023-01-24 19:10:14','623','2023-01-24 19:10:44',10,0),('1','179',257632,'DAILY SHIFT','2023-01-25','2023-01-25 07:58:03','2023-01-26 07:58:03','623',0.00,0.00,'623','2023-01-25 18:37:01','623','2023-01-25 18:37:16',10,0),('1','179',257633,'DAILY SHIFT','2023-01-26','2023-01-26 08:10:45','2023-01-27 08:10:45','623',0.00,0.00,'623','2023-01-26 18:32:14','623','2023-01-26 18:32:30',10,0),('1','179',257634,'DAILY SHIFT','2022-09-06','2023-01-26 19:11:56','2023-01-27 19:11:56','623',0.00,0.00,'623','2023-01-26 19:17:46','623','2023-01-26 19:18:53',10,0),('1','179',257635,'DAILY SHIFT','2023-01-27','2023-01-27 08:07:04','2023-01-28 08:07:04','623',0.00,0.00,'623','2023-01-28 08:14:31','623','2023-01-28 08:15:13',10,0),('1','179',257636,'DAILY SHIFT','2023-01-28','2023-01-28 08:15:52','2023-01-29 08:15:52','623',0.00,0.00,'623','2023-01-28 19:04:56','623','2023-01-28 19:05:10',10,0),('1','179',257637,'DAILY SHIFT','2023-01-29','2023-01-29 08:10:02','2023-01-30 08:10:02','623',0.00,0.00,'623','2023-01-29 19:28:13','623','2023-01-29 19:28:28',10,0),('1','179',257638,'DAILY SHIFT','2023-01-30','2023-01-30 08:14:54','2023-01-31 08:14:54','623',0.00,0.00,'623','2023-01-30 19:08:51','623','2023-01-30 19:09:57',10,0),('1','179',257639,'DAILY SHIFT','2023-01-31','2023-01-31 08:22:33','2023-02-01 08:22:33','623',0.00,0.00,'623','2023-01-31 19:35:12','623','2023-01-31 19:35:27',10,0),('1','179',257640,'DAILY SHIFT','2023-02-01','2023-02-01 09:28:43','2023-02-02 09:28:43','623',0.00,0.00,'623','2023-02-01 20:15:21','623','2023-02-01 20:15:57',10,0),('1','179',257641,'DAILY SHIFT','2023-02-02','2023-02-02 08:11:24','2023-02-03 08:11:24','623',0.00,0.00,'623','2023-02-02 19:30:28','623','2023-02-02 19:30:53',10,0),('1','179',257642,'DAILY SHIFT','2023-02-03','2023-02-03 08:21:42','2023-02-04 08:21:42','623',0.00,0.00,'623','2023-02-03 19:43:04','623','2023-02-03 19:43:20',10,0),('1','179',257643,'DAILY SHIFT','2023-02-04','2023-02-04 08:10:53','2023-02-05 08:10:53','623',0.00,0.00,'623','2023-02-04 19:33:37','623','2023-02-04 19:34:16',10,0),('1','179',257644,'DAILY SHIFT','2023-02-05','2023-02-05 07:52:44','2023-02-06 07:52:44','623',0.00,0.00,'623','2023-02-06 08:42:24','623','2023-02-06 08:42:55',10,0),('1','179',257645,'DAILY SHIFT','2023-02-06','2023-02-06 08:43:27','2023-02-07 08:43:27','623',0.00,0.00,'623','2023-02-06 20:05:13','623','2023-02-06 20:05:37',10,0),('1','179',257646,'DAILY SHIFT','2023-02-07','2023-02-07 08:15:25','2023-02-08 08:15:25','623',0.00,0.00,'623','2023-02-07 19:47:27','623','2023-02-07 19:47:51',10,0),('1','179',257647,'DAILY SHIFT','2023-02-08','2023-02-08 08:06:56','2023-02-09 08:06:56','623',0.00,0.00,'623','2023-02-08 19:55:32','623','2023-02-08 19:55:57',10,0),('1','179',257648,'DAILY SHIFT','2023-02-09','2023-02-09 08:17:13','2023-02-10 08:17:13','623',0.00,0.00,'623','2023-02-09 19:27:55','623','2023-02-09 19:28:46',10,0),('1','179',257649,'DAILY SHIFT','2023-02-10','2023-02-10 08:10:03','2023-02-11 08:10:03','623',0.00,0.00,'623','2023-02-10 19:33:20','623','2023-02-10 19:34:13',10,0),('1','179',257650,'DAILY SHIFT','2023-02-11','2023-02-11 08:15:43','2023-02-12 08:15:43','623',0.00,0.00,'623','2023-02-11 20:23:26','623','2023-02-11 20:24:20',10,0),('1','179',257651,'DAILY SHIFT','2023-02-12','2023-02-12 08:10:43','2023-02-13 08:10:43','623',0.00,0.00,'623','2023-02-12 19:48:36','623','2023-02-12 19:49:15',10,0),('1','179',257652,'DAILY SHIFT','2023-02-13','2023-02-13 08:02:45','2023-02-14 08:02:45','623',0.00,0.00,'623','2023-02-13 23:43:34','623','2023-02-13 23:43:55',10,0),('1','179',257653,'DAILY SHIFT','2023-01-30','2023-02-13 23:45:03','2023-02-14 23:45:03','623',0.00,0.00,'623','2023-02-13 23:49:20','623','2023-02-13 23:49:40',10,0),('1','179',257654,'DAILY SHIFT','2023-02-12','2023-02-13 23:50:40','2023-02-14 23:50:40','623',0.00,0.00,'623','2023-02-13 23:54:13','623','2023-02-13 23:54:43',10,0),('1','179',257655,'DAILY SHIFT','2023-02-14','2023-02-14 08:26:58','2023-02-15 08:26:58','623',0.00,0.00,'623','2023-02-14 20:21:59','623','2023-02-14 20:22:34',10,0),('1','179',257656,'DAILY SHIFT','2023-02-15','2023-02-15 08:06:30','2023-02-16 08:06:30','623',0.00,0.00,'623','2023-02-15 20:16:38','623','2023-02-15 20:16:57',10,0),('1','179',257657,'DAILY SHIFT','2023-02-16','2023-02-16 08:51:44','2023-02-17 08:51:44','623',0.00,0.00,'623','2023-02-16 18:49:38','623','2023-02-16 18:50:01',10,0),('1','179',257658,'DAILY SHIFT','2023-02-17','2023-02-17 08:14:56','2023-02-18 08:14:56','623',0.00,0.00,'623','2023-02-17 19:25:51','623','2023-02-17 19:26:39',10,0),('1','179',257659,'DAILY SHIFT','2023-02-18','2023-02-18 08:49:11','2023-02-19 08:49:11','623',0.00,0.00,'623','2023-02-19 08:35:38','623','2023-02-19 08:38:40',10,0),('1','179',257660,'DAILY SHIFT','2023-02-17','2023-02-19 08:47:57','2023-02-20 08:47:57','623',0.00,0.00,'623','2023-02-19 08:54:03','623','2023-02-19 08:55:27',10,0),('1','179',257661,'DAILY SHIFT','2023-02-19','2023-02-19 08:56:24','2023-02-20 08:56:24','623',0.00,0.00,'623','2023-02-19 19:09:15','623','2023-02-19 19:10:12',10,0),('1','179',257662,'DAILY SHIFT','2023-02-20','2023-02-20 08:22:38','2023-02-21 08:22:38','623',0.00,0.00,'623','2023-02-20 18:45:07','623','2023-02-20 18:45:39',10,0),('1','179',257663,'DAILY SHIFT','2023-02-21','2023-02-21 08:28:32','2023-02-22 08:28:32','623',0.00,0.00,'623','2023-02-21 19:18:55','623','2023-02-21 19:19:41',10,0),('1','179',257664,'DAILY SHIFT','2023-02-22','2023-02-22 08:23:12','2023-02-23 08:23:12','623',0.00,0.00,'623','2023-02-22 19:15:44','623','2023-02-22 19:16:49',10,0),('1','179',257665,'DAILY SHIFT','2023-02-23','2023-02-23 08:25:55','2023-02-24 08:25:55','623',0.00,0.00,'623','2023-02-23 19:24:13','623','2023-02-23 19:25:14',10,0),('1','179',257666,'DAILY SHIFT','2023-02-24','2023-02-24 08:29:19','2023-02-25 08:29:19','623',0.00,0.00,'623','2023-02-25 09:36:26','623','2023-02-25 09:37:01',10,0),('1','179',257667,'DAILY SHIFT','2023-02-26','2023-02-26 10:18:52','2023-02-27 10:18:52','623',0.00,0.00,'623','2023-02-26 19:41:59','623','2023-02-26 19:42:28',10,0),('1','179',257668,'DAILY SHIFT','2023-02-27','2023-02-27 08:34:20','2023-02-28 08:34:20','623',0.00,0.00,'623','2023-02-27 19:25:41','623','2023-02-27 19:26:00',10,0),('1','179',257669,'DAILY SHIFT','2023-02-28','2023-02-28 08:32:10','2023-03-01 08:32:10','623',0.00,0.00,'623','2023-02-28 19:49:58','623','2023-02-28 19:50:27',10,0),('1','179',257670,'DAILY SHIFT','2023-03-01','2023-03-01 08:38:56','2023-03-02 08:38:56','623',0.00,0.00,'623','2023-03-01 10:52:38','623','2023-03-01 10:53:43',10,0),('1','179',257671,'DAILY SHIFT','2023-03-07','2023-03-07 11:36:50','2023-03-08 11:36:50','623',0.00,0.00,'623','2023-03-07 20:59:35','623','2023-03-07 21:00:08',10,0),('1','179',257672,'DAILY SHIFT','2023-03-08','2023-03-08 08:18:08','2023-03-09 08:18:08','623',0.00,0.00,'623','2023-03-08 19:47:58','623','2023-03-08 19:48:27',10,0),('1','179',257673,'DAILY SHIFT','2023-03-09','2023-03-09 08:16:36','2023-03-10 08:16:36','623',0.00,0.00,'623','2023-03-10 08:16:45','623','2023-03-10 08:17:37',10,0),('1','179',257674,'DAILY SHIFT','2023-03-10','2023-03-10 08:18:15','2023-03-11 08:18:15','623',0.00,0.00,'623','2023-03-11 09:43:31','623','2023-03-11 09:44:02',10,0),('1','179',257675,'DAILY SHIFT','2023-03-11','2023-03-11 09:45:06','2023-03-12 09:45:06','623',0.00,0.00,'623','2023-03-11 19:01:03','623','2023-03-11 19:01:22',10,0),('1','179',257676,'DAILY SHIFT','2023-03-12','2023-03-12 08:07:14','2023-03-13 08:07:14','623',0.00,0.00,'623','2023-03-12 19:43:18','623','2023-03-12 19:43:42',10,0),('1','179',257677,'DAILY SHIFT','2023-03-13','2023-03-13 08:16:17','2023-03-14 08:16:17','623',0.00,0.00,'623','2023-03-14 08:12:05','623','2023-03-14 08:12:28',10,0),('1','179',257678,'DAILY SHIFT','2023-03-14','2023-03-14 08:12:56','2023-03-15 08:12:56','623',0.00,0.00,'623','2023-03-14 19:38:21','623','2023-03-14 19:38:34',10,0),('1','179',257679,'DAILY SHIFT','2023-03-15','2023-03-15 09:48:58','2023-03-16 09:48:58','623',0.00,0.00,'623','2023-03-15 19:31:12','623','2023-03-15 19:35:44',10,0),('1','179',257680,'DAILY SHIFT','2023-03-16','2023-03-16 10:15:31','2023-03-17 10:15:31','623',0.00,0.00,'623','2023-03-16 19:02:51','623','2023-03-16 19:03:04',10,0),('1','179',257681,'DAILY SHIFT','2023-03-17','2023-03-17 08:37:51','2023-03-18 08:37:51','623',0.00,0.00,'623','2023-03-19 07:03:05','623','2023-03-19 07:04:09',10,0),('1','179',257682,'DAILY SHIFT','2023-03-19','2023-03-19 07:21:37','2023-03-20 07:21:37','623',0.00,0.00,'623','2023-03-20 08:15:03','623','2023-03-20 08:16:04',10,0),('1','179',257683,'DAILY SHIFT','2023-03-20','2023-03-20 08:17:05','2023-03-21 08:17:05','623',0.00,0.00,'623','2023-03-20 19:06:02','623','2023-03-20 19:06:24',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4900991 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','179','933','196042',3826204,'2742','413',0.00,31.00,0.00,0.00,31.00,10664.00,0.00,0.00,0.00),('1','179','933','196051',3826324,'2742','413',31.00,58.10,0.00,0.00,27.10,9322.40,0.00,0.00,0.00),('1','179','933','196262',3830352,'2742','413',58.10,72.90,0.00,0.00,14.80,5091.20,0.00,0.00,0.00),('1','179','933','196695',3838066,'2742','413',72.90,146.90,0.00,0.00,74.00,24356.00,0.00,0.00,0.00),('1','179','933','196902',3841776,'2742','413',146.90,165.20,0.00,0.00,18.30,6295.20,0.00,0.00,0.00),('1','179','933','197054',3844530,'2742','413',165.20,231.20,0.00,0.00,66.00,22704.00,0.00,0.00,0.00),('1','179','933','197304',3849536,'2742','413',231.20,283.20,0.00,0.00,52.00,17888.00,0.00,0.00,0.00),('1','179','933','197314',3849693,'2742','413',283.20,341.70,0.00,0.00,58.50,20124.00,0.00,0.00,0.00),('1','179','933','197601',3853913,'2742','413',341.70,378.40,0.00,0.00,36.70,12624.80,0.00,0.00,0.00),('1','179','933','197889',3859051,'2742','413',378.40,442.90,0.00,0.00,64.50,22188.00,0.00,0.00,0.00),('1','179','933','198120',3863139,'2742','413',442.90,515.30,0.00,0.00,72.40,24905.60,0.00,0.00,0.00),('1','179','933','198348',3867047,'2742','413',515.30,598.96,0.00,0.00,83.66,28779.04,0.00,0.00,0.00),('1','179','933','198568',3870834,'2742','413',598.96,708.76,0.00,0.00,109.80,37771.20,0.00,0.00,0.00),('1','179','933','198779',3874331,'2742','413',708.76,809.19,0.00,0.00,100.43,34547.92,0.00,0.00,0.00),('1','179','933','198984',3877919,'2742','413',809.19,987.95,0.00,0.00,178.76,61493.44,0.00,0.00,0.00),('1','179','933','199212',3881950,'2742','413',987.95,1109.65,0.00,0.00,121.70,41864.80,0.00,0.00,0.00),('1','179','933','199432',3885494,'2742','413',1109.65,1200.91,0.00,0.00,91.26,31393.44,0.00,0.00,0.00),('1','179','933','199645',3889210,'2742','413',1200.91,1365.74,0.00,0.00,164.83,56701.52,0.00,0.00,0.00),('1','179','933','199866',3892479,'2742','413',1365.74,1546.64,0.00,0.00,180.90,62229.60,0.00,0.00,0.00),('1','179','933','200089',3896701,'2742','413',1546.64,1700.34,0.00,0.00,153.70,52872.80,0.00,0.00,0.00),('1','179','933','200295',3900207,'2742','413',1700.34,1937.18,0.00,0.00,236.84,81472.96,0.00,0.00,0.00),('1','179','933','200489',3903987,'2742','413',1937.18,2279.09,0.00,0.00,341.91,117617.04,0.00,0.00,0.00),('1','179','933','200791',3909134,'2742','413',2279.09,2417.09,0.00,0.00,138.00,47472.00,0.00,0.00,0.00),('1','179','933','200920',3911483,'2742','413',2417.09,2700.36,0.00,0.00,283.27,97444.88,0.00,0.00,0.00),('1','179','933','201108',3914637,'2742','413',2700.36,2959.47,0.00,0.00,259.11,89133.84,0.00,0.00,0.00),('1','179','933','201326',3918201,'2742','413',2959.47,3037.97,0.00,0.00,78.50,27004.00,0.00,0.00,0.00),('1','179','933','202674',3942524,'2742','413',3037.97,3264.18,0.00,0.00,226.21,77816.24,0.00,0.00,0.00),('1','179','933','202868',3946065,'2742','413',3264.18,3468.88,0.00,0.00,204.70,70416.80,0.00,0.00,0.00),('1','179','933','203195',3952300,'2742','413',3468.88,3601.54,0.00,0.00,132.66,45635.04,0.00,0.00,0.00),('1','179','933','203329',3954675,'2742','413',3601.54,3760.61,0.00,0.00,159.07,54720.08,0.00,0.00,0.00),('1','179','933','203651',3960732,'2742','413',3760.61,3760.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','203658',3960858,'2742','413',3760.61,3839.87,0.00,0.00,79.26,28533.60,0.00,0.00,0.00),('1','179','933','203898',3965147,'2742','413',3839.87,3873.87,0.00,0.00,34.00,12240.00,0.00,0.00,0.00),('1','179','933','203970',3966200,'2742','413',3873.87,3965.55,0.00,0.00,91.68,33004.80,0.00,0.00,0.00),('1','179','933','204194',3970388,'2742','413',3965.55,4189.19,0.00,0.00,223.64,80510.40,0.00,0.00,0.00),('1','179','933','204482',3975470,'2742','413',4189.19,4245.31,0.00,0.00,56.12,20203.20,0.00,0.00,0.00),('1','179','933','204638',3978254,'2742','413',4245.31,4385.62,0.00,0.00,140.31,50511.60,0.00,0.00,0.00),('1','179','933','204833',3981556,'2742','413',4385.62,4568.27,0.00,0.00,182.65,65754.00,0.00,0.00,0.00),('1','179','933','205043',3985239,'2742','413',4568.27,4954.20,0.00,0.00,385.93,138934.80,0.00,0.00,0.00),('1','179','933','205233',3988727,'2742','413',4954.20,5057.65,0.00,0.00,103.45,37242.00,0.00,0.00,0.00),('1','179','933','205477',3993129,'2742','413',5057.65,5269.13,0.00,0.00,211.48,76132.80,0.00,0.00,0.00),('1','179','933','205740',3997845,'2742','413',5269.13,5511.04,0.00,0.00,241.91,87087.60,0.00,0.00,0.00),('1','179','933','205948',4001627,'2742','413',5511.04,5705.04,0.00,0.00,194.00,69840.00,0.00,0.00,0.00),('1','179','933','206163',4005431,'2742','413',5705.04,5864.56,0.00,0.00,159.52,57427.20,0.00,0.00,0.00),('1','179','933','206365',4008914,'2742','413',5864.56,5981.42,0.00,0.00,116.86,42069.60,0.00,0.00,0.00),('1','179','933','206571',4012558,'2742','413',5981.42,6183.22,0.00,0.00,201.80,72648.00,0.00,0.00,0.00),('1','179','933','206796',4016513,'2742','413',6183.22,6443.73,0.00,0.00,260.51,93783.60,0.00,0.00,0.00),('1','179','933','207023',4020652,'2742','413',6443.73,6682.47,0.00,0.00,238.74,85946.40,0.00,0.00,0.00),('1','179','933','207265',4024875,'2742','413',6682.47,6868.51,0.00,0.00,186.04,66974.40,0.00,0.00,0.00),('1','179','933','207516',4029389,'2742','413',6868.51,7102.73,0.00,0.00,234.22,84319.20,0.00,0.00,0.00),('1','179','933','207714',4032702,'2742','413',7102.73,7385.65,0.00,0.00,282.92,107509.60,0.00,0.00,0.00),('1','179','933','207905',4036068,'2742','413',7385.65,7724.97,0.00,0.00,339.32,128941.60,0.00,0.00,0.00),('1','179','933','208141',4040047,'2742','413',7724.97,8013.04,0.00,0.00,288.07,109466.60,0.00,0.00,0.00),('1','179','933','208412',4044973,'2742','413',8013.04,8157.38,0.00,0.00,144.34,54849.20,0.00,0.00,0.00),('1','179','933','210520',4082256,'2742','413',8157.38,8414.81,0.00,0.00,257.43,108120.60,0.00,0.00,0.00),('1','179','933','210726',4085941,'2742','413',8414.81,8636.72,0.00,0.00,221.91,93202.20,0.00,0.00,0.00),('1','179','933','210978',4089984,'2742','413',8636.72,8886.54,0.00,0.00,249.82,104924.40,0.00,0.00,0.00),('1','179','933','211170',4093580,'2742','413',8886.54,9225.65,0.00,0.00,339.11,143654.36,0.00,0.00,0.00),('1','179','933','211408',4097759,'2742','413',9225.65,9740.54,0.00,0.00,514.89,218313.36,0.00,0.00,0.00),('1','179','933','211609',4101370,'2742','413',9740.54,9850.52,0.00,0.00,109.98,46631.52,0.00,0.00,0.00),('1','179','933','211788',4104172,'2742','413',9850.52,9977.10,0.00,0.00,126.58,53669.92,0.00,0.00,0.00),('1','179','933','211997',4107977,'2742','413',9977.10,10199.31,0.00,0.00,222.21,94217.04,0.00,0.00,0.00),('1','179','933','212238',4112219,'2742','413',10199.31,10406.29,0.00,0.00,206.98,87759.52,0.00,0.00,0.00),('1','179','933','212462',4116363,'2742','413',10406.29,10665.30,0.00,0.00,259.01,109820.24,0.00,0.00,0.00),('1','179','933','212674',4120153,'2742','413',10665.30,10892.88,0.00,0.00,227.58,96493.92,0.00,0.00,0.00),('1','179','933','212907',4124169,'2742','413',10892.88,11089.81,0.00,0.00,196.93,83498.32,0.00,0.00,0.00),('1','179','933','213163',4128594,'2742','413',11089.81,11347.72,0.00,0.00,257.91,109353.84,0.00,0.00,0.00),('1','179','933','213403',4132515,'2742','413',11347.72,11588.96,0.00,0.00,241.24,102285.76,0.00,0.00,0.00),('1','179','933','213638',4136493,'2742','413',11588.96,11918.20,0.00,0.00,329.24,139597.76,0.00,0.00,0.00),('1','179','933','213885',4140604,'2742','413',11918.20,12087.32,0.00,0.00,169.12,71706.88,0.00,0.00,0.00),('1','179','933','214108',4144237,'2742','413',12087.32,12349.27,0.00,0.00,261.95,111066.80,0.00,0.00,0.00),('1','179','933','214350',4148507,'2742','413',12349.27,12591.66,0.00,0.00,242.39,102773.36,0.00,0.00,0.00),('1','179','933','214525',4151541,'2742','413',12591.66,12615.75,0.00,0.00,24.09,10214.16,0.00,0.00,0.00),('1','179','933','214527',4151555,'2742','413',12615.75,12879.67,0.00,0.00,263.92,111902.08,0.00,0.00,0.00),('1','179','933','214778',4155879,'2742','413',12879.67,12879.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','214866',4157420,'2742','413',12879.67,13234.54,0.00,0.00,354.87,150464.88,0.00,0.00,0.00),('1','179','933','215008',4159703,'2742','413',13234.54,13471.77,0.00,0.00,237.23,100585.52,0.00,0.00,0.00),('1','179','933','215236',4163594,'2742','413',13471.77,13707.96,0.00,0.00,236.19,100144.56,0.00,0.00,0.00),('1','179','933','215456',4167174,'2742','413',13707.96,13970.66,0.00,0.00,262.70,111384.80,0.00,0.00,0.00),('1','179','933','215699',4171358,'2742','413',13970.66,14159.64,0.00,0.00,188.98,80127.52,0.00,0.00,0.00),('1','179','933','215916',4175205,'2742','413',14159.64,14442.33,0.00,0.00,282.69,119860.56,0.00,0.00,0.00),('1','179','933','216109',4178589,'2742','413',14442.33,14615.85,0.00,0.00,173.52,73572.48,0.00,0.00,0.00),('1','179','933','216340',4182442,'2742','413',14615.85,14852.81,0.00,0.00,236.96,100471.04,0.00,0.00,0.00),('1','179','933','216566',4186366,'2742','413',14852.81,15165.84,0.00,0.00,313.03,132724.72,0.00,0.00,0.00),('1','179','933','216818',4190869,'2742','413',15165.84,15375.68,0.00,0.00,209.84,88972.16,0.00,0.00,0.00),('1','179','933','217030',4194567,'2742','413',15375.68,15601.58,0.00,0.00,225.90,108432.00,0.00,0.00,0.00),('1','179','933','217288',4199489,'2742','413',15601.58,15847.49,0.00,0.00,245.91,118036.80,0.00,0.00,0.00),('1','179','933','217511',4203294,'2742','413',15847.49,16127.28,0.00,0.00,279.79,134299.20,0.00,0.00,0.00),('1','179','933','217715',4206714,'2742','413',16127.28,16324.12,0.00,0.00,196.84,94483.20,0.00,0.00,0.00),('1','179','933','217995',4211821,'2742','413',16324.12,16536.88,0.00,0.00,212.76,102124.80,0.00,0.00,0.00),('1','179','933','218242',4216075,'2742','413',16536.88,16791.93,0.00,0.00,255.05,122424.00,0.00,0.00,0.00),('1','179','933','218464',4219966,'2742','413',16791.93,16979.83,0.00,0.00,187.90,90192.00,0.00,0.00,0.00),('1','179','933','218695',4224157,'2742','413',16979.83,17118.01,0.00,0.00,138.18,66326.40,0.00,0.00,0.00),('1','179','933','219378',4235859,'2742','413',17118.01,17118.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','219390',4236093,'2742','413',17118.01,17435.11,0.00,0.00,317.10,152208.00,0.00,0.00,0.00),('1','179','933','219408',4236424,'2742','413',17435.11,17664.75,0.00,0.00,229.64,110227.20,0.00,0.00,0.00),('1','179','933','219642',4240484,'2742','413',17664.75,17814.78,0.00,0.00,150.03,72014.40,0.00,0.00,0.00),('1','179','933','219837',4244041,'2742','413',17814.78,17955.37,0.00,0.00,140.59,67483.20,0.00,0.00,0.00),('1','179','933','220078',4248397,'2742','413',17955.37,18204.71,0.00,0.00,249.34,119683.20,0.00,0.00,0.00),('1','179','933','220294',4252123,'2742','413',18204.71,18612.71,0.00,0.00,408.00,195840.00,0.00,0.00,0.00),('1','179','933','220494',4255830,'2742','413',18612.71,18963.45,0.00,0.00,350.74,168355.20,0.00,0.00,0.00),('1','179','933','220700',4259436,'2742','413',18963.45,19208.17,0.00,0.00,244.72,117465.60,0.00,0.00,0.00),('1','179','933','220984',4264575,'2742','413',19208.17,19516.69,0.00,0.00,308.52,148089.60,0.00,0.00,0.00),('1','179','933','221240',4268912,'2742','413',19516.69,19740.91,0.00,0.00,224.22,107625.60,0.00,0.00,0.00),('1','179','933','221392',4271828,'2742','413',19740.91,20047.67,0.00,0.00,306.76,147244.80,0.00,0.00,0.00),('1','179','933','221635',4276222,'2742','413',20047.67,20384.94,0.00,0.00,337.27,161889.60,0.00,0.00,0.00),('1','179','933','221840',4279868,'2742','413',20384.94,20654.32,0.00,0.00,269.38,129302.40,0.00,0.00,0.00),('1','179','933','222067',4284083,'2742','413',20654.32,20890.37,0.00,0.00,236.05,113304.00,0.00,0.00,0.00),('1','179','933','222278',4287593,'2742','413',20890.37,21378.89,0.00,0.00,488.52,234489.60,0.00,0.00,0.00),('1','179','933','222516',4291586,'2742','413',21378.89,21666.14,0.00,0.00,287.25,137880.00,0.00,0.00,0.00),('1','179','933','222751',4296006,'2742','413',21666.14,21963.56,0.00,0.00,297.42,142761.60,0.00,0.00,0.00),('1','179','933','222952',4299894,'2742','413',21963.56,22087.33,0.00,0.00,123.77,59409.60,0.00,0.00,0.00),('1','179','933','223132',4303206,'2742','413',22087.33,22089.41,0.00,0.00,2.08,998.40,0.00,0.00,0.00),('1','179','933','223289',4305319,'2742','413',22089.41,22524.34,0.00,0.00,434.93,208766.40,0.00,0.00,0.00),('1','179','933','223425',4308014,'2742','413',22524.34,22742.91,0.00,0.00,218.57,104913.60,0.00,0.00,0.00),('1','179','933','223649',4312114,'2742','413',22742.91,23014.66,0.00,0.00,271.75,130440.00,0.00,0.00,0.00),('1','179','933','223881',4316470,'2742','413',23014.66,23265.62,0.00,0.00,250.96,120460.80,0.00,0.00,0.00),('1','179','933','224087',4319970,'2742','413',23265.62,23485.46,0.00,0.00,219.84,105523.20,0.00,0.00,0.00),('1','179','933','224318',4324198,'2742','413',23485.46,23771.21,0.00,0.00,285.75,154305.00,0.00,0.00,0.00),('1','179','933','224545',4328073,'2742','413',23771.21,23985.63,0.00,0.00,214.42,115786.80,0.00,0.00,0.00),('1','179','933','224796',4332381,'2742','413',23985.63,24304.94,0.00,0.00,319.31,172427.40,0.00,0.00,0.00),('1','179','933','225072',4337351,'2742','413',24304.94,24519.34,0.00,0.00,214.40,115776.00,0.00,0.00,0.00),('1','179','933','225298',4341471,'2742','413',24519.34,24821.15,0.00,0.00,301.81,162977.40,0.00,0.00,0.00),('1','179','933','225497',4345225,'2742','413',24821.15,25161.60,0.00,0.00,340.45,183843.00,0.00,0.00,0.00),('1','179','933','225712',4348826,'2742','413',25161.60,25443.19,0.00,0.00,281.59,152058.60,0.00,0.00,0.00),('1','179','933','225996',4353726,'2742','413',25443.19,25675.55,0.00,0.00,232.36,125474.40,0.00,0.00,0.00),('1','179','933','226241',4358452,'2742','413',25675.55,25902.77,0.00,0.00,227.22,122698.80,0.00,0.00,0.00),('1','179','933','226484',4362633,'2742','413',25902.77,26124.87,0.00,0.00,222.10,119934.00,0.00,0.00,0.00),('1','179','933','226748',4367463,'2742','413',26124.87,26401.71,0.00,0.00,276.84,149493.60,0.00,0.00,0.00),('1','179','933','226980',4371541,'2742','413',26401.71,26716.66,0.00,0.00,314.95,170073.00,0.00,0.00,0.00),('1','179','933','227230',4375748,'2742','413',26716.66,26951.86,0.00,0.00,235.20,127008.00,0.00,0.00,0.00),('1','179','933','227391',4378760,'2742','413',26951.86,27078.96,0.00,0.00,127.10,68634.00,0.00,0.00,0.00),('1','179','933','227704',4384272,'2742','413',27078.96,27078.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','227730',4384761,'2742','413',27078.96,27511.86,0.00,0.00,432.90,233766.00,0.00,0.00,0.00),('1','179','933','228046',4390760,'2742','413',27511.86,27775.60,0.00,0.00,263.74,142419.60,0.00,0.00,0.00),('1','179','933','228134',4392218,'2742','413',27775.60,28099.33,0.00,0.00,323.73,174814.20,0.00,0.00,0.00),('1','179','933','228374',4396862,'2742','413',28099.33,28571.56,0.00,0.00,472.23,263168.80,0.00,0.00,0.00),('1','179','933','228538',4399893,'2742','413',28571.56,28977.02,0.00,0.00,405.46,227057.60,0.00,0.00,0.00),('1','179','933','228764',4404184,'2742','413',28977.02,29471.85,0.00,0.00,494.83,277104.80,0.00,0.00,0.00),('1','179','933','228957',4407608,'2742','413',29471.85,29857.28,0.00,0.00,385.43,215840.80,0.00,0.00,0.00),('1','179','933','229186',4412180,'2742','413',29857.28,30269.04,0.00,0.00,411.76,230585.60,0.00,0.00,0.00),('1','179','933','229440',4416596,'2742','413',30269.04,30531.92,0.00,0.00,262.88,153521.92,0.00,0.00,0.00),('1','179','933','229671',4421280,'2742','413',30531.92,30914.60,0.00,0.00,382.68,223485.12,0.00,0.00,0.00),('1','179','933','229898',4425735,'2742','413',30914.60,31193.10,0.00,0.00,278.50,162644.00,0.00,0.00,0.00),('1','179','933','230100',4429462,'2742','413',31193.10,31527.87,0.00,0.00,334.77,195505.68,0.00,0.00,0.00),('1','179','933','230294',4433176,'2742','413',31527.87,31722.92,0.00,0.00,195.05,113909.20,0.00,0.00,0.00),('1','179','933','230802',4442266,'2742','413',31722.92,31722.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','230803',4442267,'2742','413',31722.92,31722.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','230892',4443834,'2742','413',31722.92,32101.15,0.00,0.00,378.23,220886.32,0.00,0.00,0.00),('1','179','933','231074',4447042,'2742','413',32101.15,32448.35,0.00,0.00,347.20,202764.80,0.00,0.00,0.00),('1','179','933','231394',4452097,'2742','413',32448.35,32688.45,0.00,0.00,240.10,140218.40,0.00,0.00,0.00),('1','179','933','231662',4456709,'2742','413',32688.45,33005.50,0.00,0.00,317.05,185157.20,0.00,0.00,0.00),('1','179','933','231906',4461222,'2742','413',33005.50,33257.59,0.00,0.00,252.09,147220.56,0.00,0.00,0.00),('1','179','933','232432',4470655,'2742','413',33257.59,33460.36,0.00,0.00,202.77,118417.68,0.00,0.00,0.00),('1','179','933','232609',4473891,'2742','413',33460.36,33810.47,0.00,0.00,350.11,204464.24,0.00,0.00,0.00),('1','179','933','232872',4478530,'2742','413',33810.47,34027.89,0.00,0.00,217.42,126973.28,0.00,0.00,0.00),('1','179','933','233121',4483113,'2742','413',34027.89,34331.20,0.00,0.00,303.31,177133.04,0.00,0.00,0.00),('1','179','933','233414',4488326,'2742','413',34331.20,34638.15,0.00,0.00,306.95,191536.80,0.00,0.00,0.00),('1','179','933','233625',4492199,'2742','413',34638.15,35159.24,0.00,0.00,521.09,325160.16,0.00,0.00,0.00),('1','179','933','233856',4496342,'2742','413',35159.24,35689.33,0.00,0.00,530.09,330776.16,0.00,0.00,0.00),('1','179','933','234083',4500397,'2742','413',35689.33,35926.31,0.00,0.00,236.98,147875.52,0.00,0.00,0.00),('1','179','933','234346',4505196,'2742','413',35926.31,36183.65,0.00,0.00,257.34,160580.16,0.00,0.00,0.00),('1','179','933','234595',4509631,'2742','413',36183.65,36361.17,0.00,0.00,177.52,110772.48,0.00,0.00,0.00),('1','179','933','235238',4521111,'2742','413',36361.17,36361.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','235245',4521168,'2742','413',36361.17,36531.99,0.00,0.00,170.82,106591.68,0.00,0.00,0.00),('1','179','933','235327',4522540,'2742','413',36531.99,36796.72,0.00,0.00,264.73,165191.52,0.00,0.00,0.00),('1','179','933','235561',4526580,'2742','413',36796.72,37030.83,0.00,0.00,234.11,146084.64,0.00,0.00,0.00),('1','179','933','235782',4530537,'2742','413',37030.83,37393.95,0.00,0.00,363.12,226586.88,0.00,0.00,0.00),('1','179','933','236054',4535259,'2742','413',37393.95,37746.59,0.00,0.00,352.64,220047.36,0.00,0.00,0.00),('1','179','933','236251',4538816,'2742','413',37746.59,38060.19,0.00,0.00,313.60,195686.40,0.00,0.00,0.00),('1','179','933','236536',4543814,'2742','413',38060.19,38491.14,0.00,0.00,430.95,275808.00,0.00,0.00,0.00),('1','179','933','236757',4547488,'2742','413',38491.14,38790.91,0.00,0.00,299.77,191852.80,0.00,0.00,0.00),('1','179','933','236976',4551466,'2742','413',38790.91,39102.76,0.00,0.00,311.85,199584.00,0.00,0.00,0.00),('1','179','933','237193',4555178,'2742','413',39102.76,39455.28,0.00,0.00,352.52,225612.80,0.00,0.00,0.00),('1','179','933','237400',4559139,'2742','413',39455.28,39772.06,0.00,0.00,316.78,202739.20,0.00,0.00,0.00),('1','179','933','237651',4563397,'2742','413',39772.06,40077.35,0.00,0.00,305.29,196727.68,0.00,0.00,0.00),('1','179','933','237889',4567347,'2742','413',40077.35,40381.16,0.00,0.00,303.81,194438.40,0.00,0.00,0.00),('1','179','933','238139',4571329,'2742','413',40381.16,40637.29,0.00,0.00,256.13,163923.20,0.00,0.00,0.00),('1','179','933','238385',4575744,'2742','413',40637.29,40896.40,0.00,0.00,259.11,165830.40,0.00,0.00,0.00),('1','179','933','241075',4621836,'2742','413',40896.40,41074.68,0.00,0.00,178.28,116951.68,0.00,0.00,0.00),('1','179','933','241253',4624911,'2742','413',41074.68,41304.24,0.00,0.00,229.56,150591.36,0.00,0.00,0.00),('1','179','933','241430',4628140,'2742','413',41304.24,41304.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','241516',4629327,'2742','413',41304.24,41733.28,0.00,0.00,429.04,281450.24,0.00,0.00,0.00),('1','179','933','241772',4633902,'2742','413',41733.28,42132.38,0.00,0.00,399.10,261809.60,0.00,0.00,0.00),('1','179','933','241990',4637603,'2742','413',42132.38,42366.42,0.00,0.00,234.04,153530.24,0.00,0.00,0.00),('1','179','933','242233',4641882,'2742','413',42366.42,42758.95,0.00,0.00,392.53,257499.68,0.00,0.00,0.00),('1','179','933','242480',4646201,'2742','413',42758.95,43030.14,0.00,0.00,271.19,177900.64,0.00,0.00,0.00),('1','179','933','242704',4650204,'2742','413',43030.14,43311.48,0.00,0.00,281.34,184559.04,0.00,0.00,0.00),('1','179','933','242943',4654180,'2742','413',43311.48,43609.33,0.00,0.00,297.85,195389.60,0.00,0.00,0.00),('1','179','933','243161',4657959,'2742','413',43609.33,44003.02,0.00,0.00,393.69,258260.64,0.00,0.00,0.00),('1','179','933','243394',4662179,'2742','413',44003.02,44313.21,0.00,0.00,310.19,203484.64,0.00,0.00,0.00),('1','179','933','243624',4666128,'2742','413',44313.21,44603.45,0.00,0.00,290.24,190397.44,0.00,0.00,0.00),('1','179','933','243852',4670153,'2742','413',44603.45,45019.98,0.00,0.00,416.53,273243.68,0.00,0.00,0.00),('1','179','933','244091',4674333,'2742','413',45019.98,45285.90,0.00,0.00,265.92,174443.52,0.00,0.00,0.00),('1','179','933','244324',4678129,'2742','413',45285.90,45552.09,0.00,0.00,266.19,174620.64,0.00,0.00,0.00),('1','179','933','244556',4682203,'2742','413',45552.09,45634.71,0.00,0.00,82.62,54198.72,0.00,0.00,0.00),('1','179','933','244903',4688475,'2742','413',45634.71,45732.19,0.00,0.00,97.48,63946.88,0.00,0.00,0.00),('1','179','933','245014',4690046,'2742','413',45732.19,45934.36,0.00,0.00,202.17,126154.08,0.00,0.00,0.00),('1','179','933','245241',4694160,'2742','413',45934.36,46130.84,0.00,0.00,196.48,122603.52,0.00,0.00,0.00),('1','179','933','245452',4697825,'2742','413',46130.84,46383.69,0.00,0.00,252.85,157778.40,0.00,0.00,0.00),('1','179','933','245702',4702129,'2742','413',46383.69,46633.51,0.00,0.00,249.82,155887.68,0.00,0.00,0.00),('1','179','933','245972',4706273,'2742','413',46633.51,46912.22,0.00,0.00,278.71,171685.36,0.00,0.00,0.00),('1','179','933','246217',4710432,'2742','413',46912.22,47215.70,0.00,0.00,303.48,186943.68,0.00,0.00,0.00),('1','179','933','246481',4714952,'2742','413',47215.70,47482.50,0.00,0.00,266.80,164348.80,0.00,0.00,0.00),('1','179','933','246731',4719111,'2742','413',47482.50,47677.88,0.00,0.00,195.38,120354.08,0.00,0.00,0.00),('1','179','933','246975',4723505,'2742','413',47677.88,47950.15,0.00,0.00,272.27,167718.32,0.00,0.00,0.00),('1','179','933','247203',4727326,'2742','413',47950.15,48249.75,0.00,0.00,299.60,184553.60,0.00,0.00,0.00),('1','179','933','247439',4731618,'2742','413',48249.75,48548.35,0.00,0.00,298.60,183937.60,0.00,0.00,0.00),('1','179','933','247701',4736009,'2742','413',48548.35,48722.92,0.00,0.00,174.57,107535.12,0.00,0.00,0.00),('1','179','933','247940',4739896,'2742','413',48722.92,49026.49,0.00,0.00,303.57,186999.12,0.00,0.00,0.00),('1','179','933','248189',4744300,'2742','413',49026.49,49279.74,0.00,0.00,253.25,156002.00,0.00,0.00,0.00),('1','179','933','248432',4748313,'2742','413',49279.74,49640.79,0.00,0.00,361.05,222406.80,0.00,0.00,0.00),('1','179','933','248677',4752356,'2742','413',49640.79,50001.92,0.00,0.00,361.13,222456.08,0.00,0.00,0.00),('1','179','933','248912',4756441,'2742','413',50001.92,50289.65,0.00,0.00,287.73,172638.00,0.00,0.00,0.00),('1','179','933','249140',4760162,'2742','413',50289.65,50289.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','249143',4760181,'2742','413',50289.65,50595.59,0.00,0.00,305.94,183564.00,0.00,0.00,0.00),('1','179','933','249382',4764373,'2742','413',50595.59,50619.44,0.00,0.00,23.85,14310.00,0.00,0.00,0.00),('1','179','933','249505',4766672,'2742','413',50619.44,50740.44,0.00,0.00,121.00,72600.00,0.00,0.00,0.00),('1','179','933','249625',4768476,'2742','413',50740.44,51024.84,0.00,0.00,284.40,170640.00,0.00,0.00,0.00),('1','179','933','249881',4772839,'2742','413',51024.84,51279.45,0.00,0.00,254.61,152766.00,0.00,0.00,0.00),('1','179','933','250133',4776960,'2742','413',51279.45,51700.90,0.00,0.00,421.45,252870.00,0.00,0.00,0.00),('1','179','933','250365',4780948,'2742','413',51700.90,51994.66,0.00,0.00,293.76,176256.00,0.00,0.00,0.00),('1','179','933','250584',4784563,'2742','413',51994.66,52312.33,0.00,0.00,317.67,190602.00,0.00,0.00,0.00),('1','179','933','250833',4788926,'2742','413',52312.33,52567.65,0.00,0.00,255.32,153192.00,0.00,0.00,0.00),('1','179','933','251060',4793007,'2742','413',52567.65,52924.35,0.00,0.00,356.70,214020.00,0.00,0.00,0.00),('1','179','933','251301',4797199,'2742','413',52924.35,53176.01,0.00,0.00,251.66,150996.00,0.00,0.00,0.00),('1','179','933','251553',4801411,'2742','413',53176.01,53364.34,0.00,0.00,188.33,112998.00,0.00,0.00,0.00),('1','179','933','251802',4805903,'2742','413',53364.34,53673.61,0.00,0.00,309.27,185562.00,0.00,0.00,0.00),('1','179','933','252022',4809666,'2742','413',53673.61,54086.36,0.00,0.00,412.75,247650.00,0.00,0.00,0.00),('1','179','933','252260',4813820,'2742','413',54086.36,54440.94,0.00,0.00,354.58,212748.00,0.00,0.00,0.00),('1','179','933','252509',4818305,'2742','413',54440.94,54830.65,0.00,0.00,389.71,233826.00,0.00,0.00,0.00),('1','179','933','252747',4822438,'2742','413',54830.65,55251.57,0.00,0.00,420.92,252552.00,0.00,0.00,0.00),('1','179','933','253006',4826558,'2742','413',55251.57,55529.18,0.00,0.00,277.61,166566.00,0.00,0.00,0.00),('1','179','933','253246',4830697,'2742','413',55529.18,55663.19,0.00,0.00,134.01,80406.00,0.00,0.00,0.00),('1','179','933','253508',4835123,'2742','413',55663.19,55944.20,0.00,0.00,281.01,168606.00,0.00,0.00,0.00),('1','179','933','253741',4839057,'2742','413',55944.20,56224.87,0.00,0.00,280.67,168402.00,0.00,0.00,0.00),('1','179','933','253991',4843442,'2742','413',56224.87,56552.80,0.00,0.00,327.93,196758.00,0.00,0.00,0.00),('1','179','933','254242',4847987,'2742','413',56552.80,56968.31,0.00,0.00,415.51,249306.00,0.00,0.00,0.00),('1','179','933','254479',4852031,'2742','413',56968.31,57263.52,0.00,0.00,295.21,177126.00,0.00,0.00,0.00),('1','179','933','254743',4856584,'2742','413',57263.52,57690.24,0.00,0.00,426.72,256032.00,0.00,0.00,0.00),('1','179','933','254984',4860728,'2742','413',57690.24,58043.21,0.00,0.00,352.97,211782.00,0.00,0.00,0.00),('1','179','933','255226',4864875,'2742','413',58043.21,58297.61,0.00,0.00,254.40,152640.00,0.00,0.00,0.00),('1','179','933','255489',4869419,'2742','413',58297.61,58603.46,0.00,0.00,305.85,183510.00,0.00,0.00,0.00),('1','179','933','255733',4873502,'2742','413',58603.46,58994.32,0.00,0.00,390.86,234516.00,0.00,0.00,0.00),('1','179','933','255990',4877663,'2742','413',58994.32,59277.65,0.00,0.00,283.33,169998.00,0.00,0.00,0.00),('1','179','933','256239',4881524,'2742','413',59277.65,59610.93,0.00,0.00,333.28,199968.00,0.00,0.00,0.00),('1','179','933','256519',4886506,'2742','413',59610.93,59895.84,0.00,0.00,284.91,170946.00,0.00,0.00,0.00),('1','179','933','256756',4890294,'2742','413',59895.84,60189.94,0.00,0.00,294.10,176460.00,0.00,0.00,0.00),('1','179','933','256999',4894598,'2742','413',60189.94,60578.01,0.00,0.00,388.07,232842.00,0.00,0.00,0.00),('1','179','933','257271',4899563,'2742','413',60578.01,60645.68,0.00,0.00,67.67,40602.00,0.00,0.00,0.00),('1','179','933','257303',4900177,'2742','413',60645.68,60645.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257304',4900178,'2742','413',60645.68,60645.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257307',4900247,'2742','413',60645.68,60645.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257308',4900248,'2742','413',60645.68,60948.77,0.00,0.00,303.09,181854.00,0.00,0.00,0.00),('1','179','933','257309',4900249,'2742','413',60948.77,61310.05,0.00,0.00,361.28,216768.00,0.00,0.00,0.00),('1','179','933','257310',4900250,'2742','413',61310.05,61701.04,0.00,0.00,390.99,234594.00,0.00,0.00,0.00),('1','179','933','257311',4900251,'2742','413',61701.04,62044.86,0.00,0.00,343.82,206292.00,0.00,0.00,0.00),('1','179','933','257312',4900252,'2742','413',62044.86,62407.02,0.00,0.00,362.16,217296.00,0.00,0.00,0.00),('1','179','933','257313',4900253,'2742','413',62407.02,62752.29,0.00,0.00,345.27,207162.00,0.00,0.00,0.00),('1','179','933','257314',4900254,'2742','413',62752.29,63054.13,0.00,0.00,301.84,181104.00,0.00,0.00,0.00),('1','179','933','257315',4900255,'2742','413',63054.13,63358.29,0.00,0.00,304.16,182496.00,0.00,0.00,0.00),('1','179','933','257316',4900256,'2742','413',63358.29,63630.04,0.00,0.00,271.75,163050.00,0.00,0.00,0.00),('1','179','933','257317',4900257,'2742','413',720.99,924.66,0.00,0.00,203.67,122202.00,0.00,0.00,0.00),('1','179','933','257317',4900258,'2743','413',138.64,202.64,0.00,0.00,64.00,38400.00,0.00,0.00,0.00),('1','179','933','257318',4900259,'2742','413',924.66,986.24,0.00,0.00,61.58,36948.00,0.00,0.00,0.00),('1','179','933','257318',4900260,'2743','413',202.64,257.53,0.00,0.00,54.89,32934.00,0.00,0.00,0.00),('1','179','933','257319',4900261,'2742','413',986.24,1293.94,0.00,0.00,307.70,184620.00,0.00,0.00,0.00),('1','179','933','257319',4900262,'2743','413',257.53,408.92,0.00,0.00,151.39,90834.00,0.00,0.00,0.00),('1','179','933','257320',4900263,'2742','413',1293.94,1495.74,0.00,0.00,201.80,114622.40,0.00,0.00,0.00),('1','179','933','257320',4900264,'2743','413',408.92,588.15,0.00,0.00,179.23,101802.64,0.00,0.00,0.00),('1','179','933','257321',4900265,'2742','413',1495.74,1568.65,0.00,0.00,72.91,41412.88,0.00,0.00,0.00),('1','179','933','257321',4900266,'2743','413',588.15,830.48,0.00,0.00,242.33,137643.44,0.00,0.00,0.00),('1','179','933','257322',4900267,'2742','413',1568.65,1744.35,0.00,0.00,175.70,99797.60,0.00,0.00,0.00),('1','179','933','257322',4900268,'2743','413',830.48,952.06,0.00,0.00,121.58,69057.44,0.00,0.00,0.00),('1','179','933','257323',4900269,'2742','413',1744.35,1872.15,0.00,0.00,127.80,72590.40,0.00,0.00,0.00),('1','179','933','257323',4900270,'2743','413',952.06,1036.22,0.00,0.00,84.16,47802.88,0.00,0.00,0.00),('1','179','933','257324',4900271,'2742','413',1872.15,2133.50,0.00,0.00,261.35,148446.80,0.00,0.00,0.00),('1','179','933','257324',4900272,'2743','413',1036.22,1036.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257325',4900273,'2742','413',2133.50,2303.58,0.00,0.00,170.08,96605.44,0.00,0.00,0.00),('1','179','933','257325',4900274,'2743','413',1036.22,1087.68,0.00,0.00,51.46,29229.28,0.00,0.00,0.00),('1','179','933','257326',4900275,'2742','413',2303.58,2319.16,0.00,0.00,15.58,8849.44,0.00,0.00,0.00),('1','179','933','257326',4900276,'2743','413',1087.68,1439.66,0.00,0.00,351.98,199924.64,0.00,0.00,0.00),('1','179','933','257327',4900277,'2742','413',2319.16,2547.85,0.00,0.00,228.69,129895.92,0.00,0.00,0.00),('1','179','933','257327',4900278,'2743','413',1439.66,1439.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257328',4900279,'2742','413',2547.85,2547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257328',4900280,'2743','413',1439.66,1719.70,0.00,0.00,280.04,159062.72,0.00,0.00,0.00),('1','179','933','257329',4900281,'2742','413',2547.85,2547.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257329',4900282,'2743','413',1719.70,2167.29,0.00,0.00,447.59,254231.12,0.00,0.00,0.00),('1','179','933','257330',4900283,'2742','413',2547.85,2552.85,0.00,0.00,5.00,2840.00,0.00,0.00,0.00),('1','179','933','257330',4900284,'2743','413',2167.29,2553.11,0.00,0.00,385.82,219145.76,0.00,0.00,0.00),('1','179','933','257331',4900285,'2742','413',2552.85,2552.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257331',4900286,'2743','413',2553.11,2966.13,0.00,0.00,413.02,234595.36,0.00,0.00,0.00),('1','179','933','257332',4900287,'2742','413',2552.85,2565.17,0.00,0.00,12.32,6997.76,0.00,0.00,0.00),('1','179','933','257332',4900288,'2743','413',2966.13,3272.98,0.00,0.00,306.85,174290.80,0.00,0.00,0.00),('1','179','933','257333',4900289,'2742','413',2565.17,2565.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257333',4900290,'2743','413',3272.98,3604.09,0.00,0.00,331.11,188070.48,0.00,0.00,0.00),('1','179','933','257334',4900291,'2742','413',2565.17,2565.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257334',4900292,'2743','413',3604.09,3862.58,0.00,0.00,258.49,146822.32,0.00,0.00,0.00),('1','179','933','257335',4900293,'2742','413',2565.17,3035.85,0.00,0.00,470.68,267346.24,0.00,0.00,0.00),('1','179','933','257335',4900294,'2743','413',3862.58,3862.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257336',4900295,'2742','413',3035.85,3035.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257336',4900296,'2743','413',3862.58,4211.52,0.00,0.00,348.94,198197.92,0.00,0.00,0.00),('1','179','933','257337',4900297,'2742','413',3035.85,3035.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257337',4900298,'2743','413',4211.52,4674.77,0.00,0.00,463.25,263126.00,0.00,0.00,0.00),('1','179','933','257338',4900299,'2742','413',3035.85,3035.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257338',4900300,'2743','413',4674.77,4972.23,0.00,0.00,297.46,168957.28,0.00,0.00,0.00),('1','179','933','257339',4900301,'2742','413',3035.85,3035.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257339',4900302,'2743','413',4972.23,5241.18,0.00,0.00,268.95,180086.00,0.00,0.00,0.00),('1','179','933','257340',4900303,'2742','413',3035.85,3035.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257340',4900304,'2743','413',5241.18,5488.26,0.00,0.00,247.08,168014.40,0.00,0.00,0.00),('1','179','933','257341',4900305,'2742','413',3035.85,3035.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257341',4900306,'2743','413',5488.26,5870.37,0.00,0.00,382.11,259834.80,0.00,0.00,0.00),('1','179','933','257342',4900307,'2742','413',3035.85,3051.73,0.00,0.00,15.88,10798.40,0.00,0.00,0.00),('1','179','933','257342',4900308,'2743','413',5870.37,6147.99,0.00,0.00,277.62,188781.60,0.00,0.00,0.00),('1','179','933','257343',4900309,'2742','413',3051.73,3051.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257343',4900310,'2743','413',6147.99,6339.55,0.00,0.00,191.56,130260.80,0.00,0.00,0.00),('1','179','933','257344',4900311,'2742','413',3051.73,3051.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257344',4900312,'2743','413',6339.55,6568.75,0.00,0.00,229.20,155856.00,0.00,0.00,0.00),('1','179','933','257345',4900313,'2742','413',3051.73,3061.73,0.00,0.00,10.00,6800.00,0.00,0.00,0.00),('1','179','933','257345',4900314,'2743','413',6568.75,6845.68,0.00,0.00,276.93,188312.40,0.00,0.00,0.00),('1','179','933','257346',4900315,'2742','413',3061.73,3068.73,0.00,0.00,7.00,4760.00,0.00,0.00,0.00),('1','179','933','257346',4900316,'2743','413',6845.68,7005.45,0.00,0.00,159.77,108643.60,0.00,0.00,0.00),('1','179','933','257347',4900317,'2742','413',3068.73,3068.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257347',4900318,'2743','413',7005.45,7296.37,0.00,0.00,290.92,197825.60,0.00,0.00,0.00),('1','179','933','257348',4900319,'2742','413',3068.73,3081.23,0.00,0.00,12.50,8500.00,0.00,0.00,0.00),('1','179','933','257348',4900320,'2743','413',7296.37,7529.57,0.00,0.00,233.20,158576.00,0.00,0.00,0.00),('1','179','933','257349',4900321,'2742','413',3081.23,3152.10,0.00,0.00,70.87,48191.60,0.00,0.00,0.00),('1','179','933','257349',4900322,'2743','413',7529.57,7649.89,0.00,0.00,120.32,81817.60,0.00,0.00,0.00),('1','179','933','257350',4900323,'2742','413',3152.10,3160.92,0.00,0.00,8.82,5997.60,0.00,0.00,0.00),('1','179','933','257350',4900324,'2743','413',7649.89,7649.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257351',4900325,'2742','413',3160.92,3178.28,0.00,0.00,17.36,11804.80,0.00,0.00,0.00),('1','179','933','257351',4900326,'2743','413',7649.89,7871.44,0.00,0.00,221.55,150654.00,0.00,0.00,0.00),('1','179','933','257352',4900327,'2742','413',3178.28,3261.10,0.00,0.00,82.82,56317.60,0.00,0.00,0.00),('1','179','933','257352',4900328,'2743','413',7871.44,8219.72,0.00,0.00,348.28,236830.40,0.00,0.00,0.00),('1','179','933','257353',4900329,'2742','413',3261.10,3363.39,0.00,0.00,102.29,66488.50,0.00,0.00,0.00),('1','179','933','257353',4900330,'2743','413',8219.72,8658.97,0.00,0.00,439.25,285512.50,0.00,0.00,0.00),('1','179','933','257354',4900331,'2742','413',3363.39,3999.58,0.00,0.00,636.19,413523.50,0.00,0.00,0.00),('1','179','933','257354',4900332,'2743','413',8658.97,8970.62,0.00,0.00,311.65,202572.50,0.00,0.00,0.00),('1','179','933','257355',4900333,'2742','413',3999.58,4068.92,0.00,0.00,69.34,45071.00,0.00,0.00,0.00),('1','179','933','257355',4900334,'2743','413',8970.62,9034.85,0.00,0.00,64.23,41749.50,0.00,0.00,0.00),('1','179','933','257356',4900335,'2742','413',4068.92,4322.12,0.00,0.00,253.20,164580.00,0.00,0.00,0.00),('1','179','933','257356',4900336,'2743','413',9034.85,9041.77,0.00,0.00,6.92,4498.00,0.00,0.00,0.00),('1','179','933','257357',4900337,'2742','413',4322.12,4631.31,0.00,0.00,309.19,200973.50,0.00,0.00,0.00),('1','179','933','257357',4900338,'2743','413',9041.77,9069.92,0.00,0.00,28.15,18297.50,0.00,0.00,0.00),('1','179','933','257358',4900339,'2742','413',4631.31,4918.72,0.00,0.00,287.41,186816.50,0.00,0.00,0.00),('1','179','933','257358',4900340,'2743','413',9069.92,9203.25,0.00,0.00,133.33,86664.50,0.00,0.00,0.00),('1','179','933','257359',4900341,'2742','413',4918.72,5128.32,0.00,0.00,209.60,136240.00,0.00,0.00,0.00),('1','179','933','257359',4900342,'2743','413',9203.25,9293.44,0.00,0.00,90.19,58623.50,0.00,0.00,0.00),('1','179','933','257360',4900343,'2742','413',5128.32,5324.26,0.00,0.00,195.94,127361.00,0.00,0.00,0.00),('1','179','933','257360',4900344,'2743','413',9293.44,9557.79,0.00,0.00,264.35,171827.50,0.00,0.00,0.00),('1','179','933','257361',4900345,'2742','413',5324.26,5496.05,0.00,0.00,171.79,111663.50,0.00,0.00,0.00),('1','179','933','257361',4900346,'2743','413',9557.79,9648.69,0.00,0.00,90.90,59085.00,0.00,0.00,0.00),('1','179','933','257362',4900347,'2742','413',5496.05,5744.91,0.00,0.00,248.86,161759.00,0.00,0.00,0.00),('1','179','933','257362',4900348,'2743','413',9648.69,9716.73,0.00,0.00,68.04,44226.00,0.00,0.00,0.00),('1','179','933','257363',4900349,'2742','413',5744.91,6022.92,0.00,0.00,278.01,180706.50,0.00,0.00,0.00),('1','179','933','257363',4900350,'2743','413',9716.73,9770.32,0.00,0.00,53.59,34833.50,0.00,0.00,0.00),('1','179','933','257364',4900351,'2742','413',6022.92,6208.17,0.00,0.00,185.25,120412.50,0.00,0.00,0.00),('1','179','933','257364',4900352,'2743','413',9770.32,9856.59,0.00,0.00,86.27,56075.50,0.00,0.00,0.00),('1','179','933','257365',4900353,'2742','413',6208.17,6383.91,0.00,0.00,175.74,114231.00,0.00,0.00,0.00),('1','179','933','257365',4900354,'2743','413',9856.59,9962.75,0.00,0.00,106.16,69004.00,0.00,0.00,0.00),('1','179','933','257366',4900355,'2742','413',6383.91,6532.47,0.00,0.00,148.56,96564.00,0.00,0.00,0.00),('1','179','933','257366',4900356,'2743','413',9962.75,10080.44,0.00,0.00,117.69,76498.50,0.00,0.00,0.00),('1','179','933','257367',4900357,'2742','413',6532.47,6708.49,0.00,0.00,176.02,114413.00,0.00,0.00,0.00),('1','179','933','257367',4900358,'2743','413',10080.44,10154.56,0.00,0.00,74.12,48178.00,0.00,0.00,0.00),('1','179','933','257368',4900359,'2742','413',6708.49,6886.63,0.00,0.00,178.14,115791.00,0.00,0.00,0.00),('1','179','933','257368',4900360,'2743','413',10154.56,10324.92,0.00,0.00,170.36,110734.00,0.00,0.00,0.00),('1','179','933','257369',4900361,'2742','413',6886.63,6937.56,0.00,0.00,50.93,33104.50,0.00,0.00,0.00),('1','179','933','257369',4900362,'2743','413',10324.92,10409.84,0.00,0.00,84.92,55198.00,0.00,0.00,0.00),('1','179','933','257370',4900363,'2742','413',6937.56,7085.85,0.00,0.00,148.29,96388.50,0.00,0.00,0.00),('1','179','933','257370',4900364,'2743','413',10409.84,10552.89,0.00,0.00,143.05,92982.50,0.00,0.00,0.00),('1','179','933','257371',4900365,'2742','413',7085.85,7240.94,0.00,0.00,155.09,100808.50,0.00,0.00,0.00),('1','179','933','257371',4900366,'2743','413',10552.89,10660.97,0.00,0.00,108.08,70252.00,0.00,0.00,0.00),('1','179','933','257372',4900367,'2742','413',7240.94,7344.99,0.00,0.00,104.05,67632.50,0.00,0.00,0.00),('1','179','933','257372',4900368,'2743','413',10660.97,10712.59,0.00,0.00,51.62,33553.00,0.00,0.00,0.00),('1','179','933','257373',4900369,'2742','413',7344.99,7389.72,0.00,0.00,44.73,29074.50,0.00,0.00,0.00),('1','179','933','257373',4900370,'2743','413',10712.59,10733.14,0.00,0.00,20.55,13357.50,0.00,0.00,0.00),('1','179','933','257374',4900371,'2742','413',7389.72,7518.13,0.00,0.00,128.41,83466.50,0.00,0.00,0.00),('1','179','933','257374',4900372,'2743','413',10733.14,10855.96,0.00,0.00,122.82,79833.00,0.00,0.00,0.00),('1','179','933','257375',4900373,'2742','413',7518.13,7665.75,0.00,0.00,147.62,95953.00,0.00,0.00,0.00),('1','179','933','257375',4900374,'2743','413',10855.96,10986.74,0.00,0.00,130.78,85007.00,0.00,0.00,0.00),('1','179','933','257376',4900375,'2742','413',7665.75,7665.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257376',4900376,'2743','413',10986.74,10986.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257377',4900377,'2742','413',7665.75,7665.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257377',4900378,'2743','413',10986.74,10986.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257378',4900379,'2742','413',7665.75,7791.03,0.00,0.00,125.28,81432.00,0.00,0.00,0.00),('1','179','933','257378',4900380,'2743','413',10986.74,11132.78,0.00,0.00,146.04,94926.00,0.00,0.00,0.00),('1','179','933','257379',4900381,'2742','413',7791.03,7812.68,0.00,0.00,21.65,14072.50,0.00,0.00,0.00),('1','179','933','257379',4900382,'2743','413',11132.78,11472.25,0.00,0.00,339.47,220655.50,0.00,0.00,0.00),('1','179','933','257380',4900383,'2742','413',7812.68,7933.12,0.00,0.00,120.44,78286.00,0.00,0.00,0.00),('1','179','933','257380',4900384,'2743','413',11472.25,11660.82,0.00,0.00,188.57,122570.50,0.00,0.00,0.00),('1','179','933','257381',4900385,'2742','413',7933.12,8125.38,0.00,0.00,192.26,124969.00,0.00,0.00,0.00),('1','179','933','257381',4900386,'2743','413',11660.82,11779.78,0.00,0.00,118.96,77324.00,0.00,0.00,0.00),('1','179','933','257382',4900387,'2742','413',8125.38,8272.22,0.00,0.00,146.84,95446.00,0.00,0.00,0.00),('1','179','933','257382',4900388,'2743','413',11779.78,11893.71,0.00,0.00,113.93,74054.50,0.00,0.00,0.00),('1','179','933','257383',4900389,'2742','413',8272.22,8343.92,0.00,0.00,71.70,46605.00,0.00,0.00,0.00),('1','179','933','257383',4900390,'2743','413',11893.71,12103.95,0.00,0.00,210.24,136656.00,0.00,0.00,0.00),('1','179','933','257384',4900391,'2742','413',8343.92,8504.31,0.00,0.00,160.39,104253.50,0.00,0.00,0.00),('1','179','933','257384',4900392,'2743','413',12103.95,12269.53,0.00,0.00,165.58,107627.00,0.00,0.00,0.00),('1','179','933','257385',4900393,'2742','413',8504.31,8677.27,0.00,0.00,172.96,112424.00,0.00,0.00,0.00),('1','179','933','257385',4900394,'2743','413',12269.53,12401.92,0.00,0.00,132.39,86053.50,0.00,0.00,0.00),('1','179','933','257386',4900395,'2742','413',8677.27,8931.37,0.00,0.00,254.10,165165.00,0.00,0.00,0.00),('1','179','933','257386',4900396,'2743','413',12401.92,12588.88,0.00,0.00,186.96,121524.00,0.00,0.00,0.00),('1','179','933','257387',4900397,'2742','413',8931.37,9153.07,0.00,0.00,221.70,144105.00,0.00,0.00,0.00),('1','179','933','257387',4900398,'2743','413',12588.88,12721.54,0.00,0.00,132.66,86229.00,0.00,0.00,0.00),('1','179','933','257388',4900399,'2742','413',9153.07,9171.07,0.00,0.00,18.00,11700.00,0.00,0.00,0.00),('1','179','933','257388',4900400,'2743','413',12721.54,12731.70,0.00,0.00,10.16,6604.00,0.00,0.00,0.00),('1','179','933','257389',4900401,'2742','413',9171.07,9188.57,0.00,0.00,17.50,11375.00,0.00,0.00,0.00),('1','179','933','257389',4900402,'2743','413',12731.70,12755.20,0.00,0.00,23.50,15275.00,0.00,0.00,0.00),('1','179','933','257390',4900403,'2742','413',9188.57,9234.58,0.00,0.00,46.01,29906.50,0.00,0.00,0.00),('1','179','933','257390',4900404,'2743','413',12755.20,12799.86,0.00,0.00,44.66,29029.00,0.00,0.00,0.00),('1','179','933','257391',4900405,'2742','413',9234.58,9322.32,0.00,0.00,87.74,57031.00,0.00,0.00,0.00),('1','179','933','257391',4900406,'2743','413',12799.86,12866.24,0.00,0.00,66.38,43147.00,0.00,0.00,0.00),('1','179','933','257392',4900407,'2742','413',9322.32,9620.57,0.00,0.00,298.25,193862.50,0.00,0.00,0.00),('1','179','933','257392',4900408,'2743','413',12866.24,12890.24,0.00,0.00,24.00,15600.00,0.00,0.00,0.00),('1','179','933','257393',4900409,'2742','413',9620.57,9822.31,0.00,0.00,201.74,131131.00,0.00,0.00,0.00),('1','179','933','257393',4900410,'2743','413',12890.24,12890.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257394',4900411,'2742','413',9822.31,10138.43,0.00,0.00,316.12,205478.00,0.00,0.00,0.00),('1','179','933','257394',4900412,'2743','413',12890.24,12890.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257395',4900413,'2742','413',10138.43,10138.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257395',4900414,'2743','413',12890.24,12890.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257396',4900415,'2742','413',10138.43,10138.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257396',4900416,'2743','413',12890.24,12890.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257397',4900417,'2742','413',10138.43,10138.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257397',4900418,'2743','413',12890.24,12890.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257398',4900419,'2742','413',10138.43,10166.55,0.00,0.00,28.12,18278.00,0.00,0.00,0.00),('1','179','933','257398',4900420,'2743','413',12890.24,13098.65,0.00,0.00,208.41,135466.50,0.00,0.00,0.00),('1','179','933','257399',4900421,'2742','413',10166.55,10166.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257399',4900422,'2743','413',13098.65,13388.36,0.00,0.00,289.71,188311.50,0.00,0.00,0.00),('1','179','933','257400',4900423,'2742','413',10166.55,10166.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257400',4900424,'2743','413',13388.36,13631.86,0.00,0.00,243.50,155275.00,0.00,0.00,0.00),('1','179','933','257401',4900425,'2742','413',10166.55,10166.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257401',4900426,'2743','413',13631.86,13886.38,0.00,0.00,254.52,177145.92,0.00,0.00,0.00),('1','179','933','257402',4900427,'2742','413',10166.55,10166.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257402',4900428,'2743','413',13886.38,14154.45,0.00,0.00,268.07,184816.72,0.00,0.00,0.00),('1','179','933','257403',4900429,'2742','413',10166.55,10166.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257403',4900430,'2743','413',14154.45,14311.46,0.00,0.00,157.01,108178.96,0.00,0.00,0.00),('1','179','933','257404',4900431,'2742','413',10166.55,10221.27,0.00,0.00,54.72,38085.12,0.00,0.00,0.00),('1','179','933','257404',4900432,'2743','413',14311.46,14470.09,0.00,0.00,158.63,110406.48,0.00,0.00,0.00),('1','179','933','257405',4900433,'2742','413',10221.27,10358.90,0.00,0.00,137.63,95790.48,0.00,0.00,0.00),('1','179','933','257405',4900434,'2743','413',14470.09,14552.61,0.00,0.00,82.52,57433.92,0.00,0.00,0.00),('1','179','933','257406',4900435,'2742','413',10358.90,10549.27,0.00,0.00,190.37,130297.52,0.00,0.00,0.00),('1','179','933','257406',4900436,'2743','413',14552.61,14557.05,0.00,0.00,4.44,3090.24,0.00,0.00,0.00),('1','179','933','257407',4900437,'2742','413',10549.27,10812.03,0.00,0.00,262.76,180680.96,0.00,0.00,0.00),('1','179','933','257407',4900438,'2743','413',14557.05,14568.54,0.00,0.00,11.49,7997.04,0.00,0.00,0.00),('1','179','933','257408',4900439,'2742','413',10812.03,11104.02,0.00,0.00,291.99,199815.04,0.00,0.00,0.00),('1','179','933','257408',4900440,'2743','413',14568.54,14664.02,0.00,0.00,95.48,66454.08,0.00,0.00,0.00),('1','179','933','257409',4900441,'2742','413',11104.02,11273.71,0.00,0.00,169.69,118104.24,0.00,0.00,0.00),('1','179','933','257409',4900442,'2743','413',14664.02,14704.33,0.00,0.00,40.31,28055.76,0.00,0.00,0.00),('1','179','933','257410',4900443,'2742','413',11273.71,11442.31,0.00,0.00,168.60,124764.00,0.00,0.00,0.00),('1','179','933','257410',4900444,'2743','413',14704.33,14864.19,0.00,0.00,159.86,118296.40,0.00,0.00,0.00),('1','179','933','257411',4900445,'2742','413',11442.31,11586.76,0.00,0.00,144.45,106893.00,0.00,0.00,0.00),('1','179','933','257411',4900446,'2743','413',14864.19,15004.72,0.00,0.00,140.53,101792.20,0.00,0.00,0.00),('1','179','933','257412',4900447,'2742','413',11586.76,11761.26,0.00,0.00,174.50,129130.00,0.00,0.00,0.00),('1','179','933','257412',4900448,'2743','413',15004.72,15022.07,0.00,0.00,17.35,12839.00,0.00,0.00,0.00),('1','179','933','257413',4900449,'2742','413',11761.26,12008.71,0.00,0.00,247.45,180913.00,0.00,0.00,0.00),('1','179','933','257413',4900450,'2743','413',15022.07,15022.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257414',4900451,'2742','413',12008.71,12298.68,0.00,0.00,289.97,214577.80,0.00,0.00,0.00),('1','179','933','257414',4900452,'2743','413',15022.07,15033.56,0.00,0.00,11.49,8502.60,0.00,0.00,0.00),('1','179','933','257415',4900453,'2742','413',12298.68,12678.21,0.00,0.00,379.53,273812.20,0.00,0.00,0.00),('1','179','933','257415',4900454,'2743','413',15033.56,15145.20,0.00,0.00,111.64,82613.60,0.00,0.00,0.00),('1','179','933','257416',4900455,'2742','413',12678.21,12768.81,0.00,0.00,90.60,67044.00,0.00,0.00,0.00),('1','179','933','257416',4900456,'2743','413',15145.20,15270.40,0.00,0.00,125.20,92648.00,0.00,0.00,0.00),('1','179','933','257417',4900457,'2742','413',12768.81,12784.31,0.00,0.00,15.50,11470.00,0.00,0.00,0.00),('1','179','933','257417',4900458,'2743','413',15270.40,15270.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257418',4900459,'2742','413',12784.31,12784.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257418',4900460,'2743','413',15270.40,15270.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257419',4900461,'2742','413',12784.31,12958.78,0.00,0.00,174.47,127787.80,0.00,0.00,0.00),('1','179','933','257419',4900462,'2743','413',15270.40,15270.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257420',4900463,'2742','413',12958.78,13231.86,0.00,0.00,273.08,196051.20,0.00,0.00,0.00),('1','179','933','257420',4900464,'2743','413',15270.40,15270.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257421',4900465,'2742','413',13231.86,13417.76,0.00,0.00,185.90,135366.00,0.00,0.00,0.00),('1','179','933','257421',4900466,'2743','413',15270.40,15270.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257422',4900467,'2742','413',13417.76,13559.95,0.00,0.00,142.19,105220.60,0.00,0.00,0.00),('1','179','933','257422',4900468,'2743','413',15270.40,15509.40,0.00,0.00,239.00,168940.00,0.00,0.00,0.00),('1','179','933','257423',4900469,'2742','413',13559.95,13749.91,0.00,0.00,189.96,140570.40,0.00,0.00,0.00),('1','179','933','257423',4900470,'2743','413',15509.40,15603.26,0.00,0.00,93.86,69456.40,0.00,0.00,0.00),('1','179','933','257424',4900471,'2742','413',13749.91,13856.43,0.00,0.00,106.52,82020.40,0.00,0.00,0.00),('1','179','933','257424',4900472,'2743','413',15603.26,15622.21,0.00,0.00,18.95,14591.50,0.00,0.00,0.00),('1','179','933','257425',4900473,'2742','413',13856.43,14228.58,0.00,0.00,372.15,279055.50,0.00,0.00,0.00),('1','179','933','257425',4900474,'2743','413',15622.21,15622.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257426',4900475,'2742','413',14228.58,14412.62,0.00,0.00,184.04,141710.80,0.00,0.00,0.00),('1','179','933','257426',4900476,'2743','413',15622.21,15622.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257427',4900477,'2742','413',14412.62,14725.58,0.00,0.00,312.96,234479.20,0.00,0.00,0.00),('1','179','933','257427',4900478,'2743','413',15622.21,15699.31,0.00,0.00,77.10,59367.00,0.00,0.00,0.00),('1','179','933','257428',4900479,'2742','413',14725.58,14829.77,0.00,0.00,104.19,80226.30,0.00,0.00,0.00),('1','179','933','257428',4900480,'2743','413',15699.31,15771.42,0.00,0.00,72.11,55524.70,0.00,0.00,0.00),('1','179','933','257429',4900481,'2742','413',14829.77,14932.74,0.00,0.00,102.97,79286.90,0.00,0.00,0.00),('1','179','933','257429',4900482,'2743','413',15771.42,15880.11,0.00,0.00,108.69,83691.30,0.00,0.00,0.00),('1','179','933','257430',4900483,'2742','413',14932.74,15097.69,0.00,0.00,164.95,127011.50,0.00,0.00,0.00),('1','179','933','257430',4900484,'2743','413',15880.11,15974.16,0.00,0.00,94.05,72418.50,0.00,0.00,0.00),('1','179','933','257431',4900485,'2742','413',15097.69,15273.75,0.00,0.00,176.06,135566.20,0.00,0.00,0.00),('1','179','933','257431',4900486,'2743','413',15974.16,16078.07,0.00,0.00,103.91,80010.70,0.00,0.00,0.00),('1','179','933','257432',4900487,'2742','413',15273.75,15508.80,0.00,0.00,235.05,180988.50,0.00,0.00,0.00),('1','179','933','257432',4900488,'2743','413',16078.07,16278.07,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257433',4900489,'2742','413',15508.80,15781.20,0.00,0.00,272.40,204748.00,0.00,0.00,0.00),('1','179','933','257433',4900490,'2743','413',16278.07,16278.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257434',4900491,'2742','413',15781.20,15929.26,0.00,0.00,148.06,114006.20,0.00,0.00,0.00),('1','179','933','257434',4900492,'2743','413',16278.07,16358.29,0.00,0.00,80.22,61769.40,0.00,0.00,0.00),('1','179','933','257435',4900493,'2742','413',15929.26,16028.55,0.00,0.00,99.29,76453.30,0.00,0.00,0.00),('1','179','933','257435',4900494,'2743','413',16358.29,16410.44,0.00,0.00,52.15,40155.50,0.00,0.00,0.00),('1','179','933','257436',4900495,'2742','413',16028.55,16126.38,0.00,0.00,97.83,75329.10,0.00,0.00,0.00),('1','179','933','257436',4900496,'2743','413',16410.44,16509.69,0.00,0.00,99.25,76422.50,0.00,0.00,0.00),('1','179','933','257437',4900497,'2742','413',16126.38,16168.86,0.00,0.00,42.48,32709.60,0.00,0.00,0.00),('1','179','933','257437',4900498,'2743','413',16509.69,16568.87,0.00,0.00,59.18,45568.60,0.00,0.00,0.00),('1','179','933','257438',4900499,'2742','413',16168.86,16333.72,0.00,0.00,164.86,119299.20,0.00,0.00,0.00),('1','179','933','257438',4900500,'2743','413',16568.87,16568.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257439',4900501,'2742','413',16333.72,16333.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257439',4900502,'2743','413',16568.87,16568.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257440',4900503,'2742','413',16333.72,16479.99,0.00,0.00,146.27,112627.90,0.00,0.00,0.00),('1','179','933','257440',4900504,'2743','413',16568.87,16568.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257441',4900505,'2742','413',16479.99,16804.14,0.00,0.00,324.15,242095.50,0.00,0.00,0.00),('1','179','933','257441',4900506,'2743','413',16568.87,16568.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257442',4900507,'2742','413',16804.14,16997.65,0.00,0.00,193.51,148502.70,0.00,0.00,0.00),('1','179','933','257442',4900508,'2743','413',16568.87,16736.42,0.00,0.00,167.55,126513.50,0.00,0.00,0.00),('1','179','933','257443',4900509,'2742','413',16997.65,17239.96,0.00,0.00,242.31,186578.70,0.00,0.00,0.00),('1','179','933','257443',4900510,'2743','413',16736.42,16736.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257444',4900511,'2742','413',17239.96,17490.77,0.00,0.00,250.81,193123.70,0.00,0.00,0.00),('1','179','933','257444',4900512,'2743','413',16736.42,16744.92,0.00,0.00,8.50,6545.00,0.00,0.00,0.00),('1','179','933','257445',4900513,'2742','413',17490.77,18095.52,0.00,0.00,604.75,448157.50,0.00,0.00,0.00),('1','179','933','257445',4900514,'2743','413',16744.92,16744.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257446',4900515,'2742','413',18095.52,18356.34,0.00,0.00,260.82,200831.40,0.00,0.00,0.00),('1','179','933','257446',4900516,'2743','413',16744.92,16752.07,0.00,0.00,7.15,5505.50,0.00,0.00,0.00),('1','179','933','257447',4900517,'2742','413',18356.34,18612.37,0.00,0.00,256.03,194593.10,0.00,0.00,0.00),('1','179','933','257447',4900518,'2743','413',16752.07,16752.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257448',4900519,'2742','413',18612.37,19186.63,0.00,0.00,574.26,428221.70,0.00,0.00,0.00),('1','179','933','257448',4900520,'2743','413',16752.07,16752.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257449',4900521,'2742','413',19186.63,19402.30,0.00,0.00,215.67,166065.90,0.00,0.00,0.00),('1','179','933','257449',4900522,'2743','413',16752.07,16938.15,0.00,0.00,186.08,137781.60,0.00,0.00,0.00),('1','179','933','257450',4900523,'2742','413',19402.30,19935.78,0.00,0.00,533.48,405179.60,0.00,0.00,0.00),('1','179','933','257450',4900524,'2743','413',16938.15,16967.02,0.00,0.00,28.87,22229.90,0.00,0.00,0.00),('1','179','933','257451',4900525,'2742','413',19935.78,20270.32,0.00,0.00,334.54,257595.80,0.00,0.00,0.00),('1','179','933','257451',4900526,'2743','413',16967.02,16967.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257452',4900527,'2742','413',20270.32,20812.09,0.00,0.00,541.77,410412.90,0.00,0.00,0.00),('1','179','933','257452',4900528,'2743','413',16967.02,16967.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257453',4900529,'2742','413',20812.09,21022.02,0.00,0.00,209.93,161096.10,0.00,0.00,0.00),('1','179','933','257453',4900530,'2743','413',16967.02,16979.36,0.00,0.00,12.34,9501.80,0.00,0.00,0.00),('1','179','933','257454',4900531,'2742','413',21022.02,21115.13,0.00,0.00,93.11,71694.70,0.00,0.00,0.00),('1','179','933','257454',4900532,'2743','413',16979.36,16979.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257455',4900533,'2742','413',21115.13,21374.87,0.00,0.00,259.74,193974.80,0.00,0.00,0.00),('1','179','933','257455',4900534,'2743','413',16979.36,17001.70,0.00,0.00,22.34,17201.80,0.00,0.00,0.00),('1','179','933','257456',4900535,'2742','413',21374.87,21578.35,0.00,0.00,203.48,151679.60,0.00,0.00,0.00),('1','179','933','257456',4900536,'2743','413',17001.70,17001.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257457',4900537,'2742','413',21578.35,21747.94,0.00,0.00,169.59,130584.30,0.00,0.00,0.00),('1','179','933','257457',4900538,'2743','413',17001.70,17001.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257458',4900539,'2742','413',21747.94,22080.10,0.00,0.00,332.16,250763.20,0.00,0.00,0.00),('1','179','933','257458',4900540,'2743','413',17001.70,17001.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257459',4900541,'2742','413',22080.10,22252.01,0.00,0.00,171.91,132370.70,0.00,0.00,0.00),('1','179','933','257459',4900542,'2743','413',17001.70,17001.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257460',4900543,'2742','413',22252.01,22317.49,0.00,0.00,65.48,50419.60,0.00,0.00,0.00),('1','179','933','257460',4900544,'2743','413',17001.70,17084.89,0.00,0.00,83.19,64056.30,0.00,0.00,0.00),('1','179','933','257461',4900545,'2742','413',22317.49,22329.99,0.00,0.00,12.50,9625.00,0.00,0.00,0.00),('1','179','933','257461',4900546,'2743','413',17084.89,17401.24,0.00,0.00,316.35,236089.50,0.00,0.00,0.00),('1','179','933','257462',4900547,'2742','413',22329.99,22600.49,0.00,0.00,270.50,202035.00,0.00,0.00,0.00),('1','179','933','257462',4900548,'2743','413',17401.24,17496.22,0.00,0.00,94.98,73134.60,0.00,0.00,0.00),('1','179','933','257463',4900549,'2742','413',22600.49,22914.43,0.00,0.00,313.94,238024.30,0.00,0.00,0.00),('1','179','933','257463',4900550,'2743','413',17496.22,17497.52,0.00,0.00,1.30,1001.00,0.00,0.00,0.00),('1','179','933','257464',4900551,'2742','413',22914.43,23322.21,0.00,0.00,407.78,308990.60,0.00,0.00,0.00),('1','179','933','257464',4900552,'2743','413',17497.52,17497.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257465',4900553,'2742','413',23322.21,23513.66,0.00,0.00,191.45,147416.50,0.00,0.00,0.00),('1','179','933','257465',4900554,'2743','413',17497.52,17547.52,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257466',4900555,'2742','413',23513.66,23857.33,0.00,0.00,343.67,257125.90,0.00,0.00,0.00),('1','179','933','257466',4900556,'2743','413',17547.52,17816.02,0.00,0.00,268.50,193320.00,0.00,0.00,0.00),('1','179','933','257467',4900557,'2742','413',23857.33,24012.14,0.00,0.00,154.81,119203.70,0.00,0.00,0.00),('1','179','933','257467',4900558,'2743','413',17816.02,17816.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257468',4900559,'2742','413',24012.14,24334.24,0.00,0.00,322.10,242992.00,0.00,0.00,0.00),('1','179','933','257468',4900560,'2743','413',17816.02,17816.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257469',4900561,'2742','413',24334.24,24619.30,0.00,0.00,285.06,219496.20,0.00,0.00,0.00),('1','179','933','257469',4900562,'2743','413',17816.02,18006.02,0.00,0.00,190.00,136800.00,0.00,0.00,0.00),('1','179','933','257470',4900563,'2742','413',24619.30,24759.66,0.00,0.00,140.36,108077.20,0.00,0.00,0.00),('1','179','933','257470',4900564,'2743','413',18006.02,18006.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257471',4900565,'2742','413',24759.66,24762.61,0.00,0.00,2.95,2271.50,0.00,0.00,0.00),('1','179','933','257471',4900566,'2743','413',18006.02,18290.02,0.00,0.00,284.00,204480.00,0.00,0.00,0.00),('1','179','933','257472',4900567,'2742','413',24762.61,24762.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257472',4900568,'2743','413',18290.02,18290.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257473',4900569,'2742','413',24762.61,25004.86,0.00,0.00,242.25,183532.50,0.00,0.00,0.00),('1','179','933','257473',4900570,'2743','413',18290.02,18290.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257474',4900571,'2742','413',25004.86,25129.94,0.00,0.00,125.08,96311.60,0.00,0.00,0.00),('1','179','933','257474',4900572,'2743','413',18290.02,18299.58,0.00,0.00,9.56,7361.20,0.00,0.00,0.00),('1','179','933','257475',4900573,'2742','413',25129.94,25496.54,0.00,0.00,366.60,271282.00,0.00,0.00,0.00),('1','179','933','257475',4900574,'2743','413',18299.58,18299.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257476',4900575,'2742','413',25496.54,25806.07,0.00,0.00,309.53,235338.10,0.00,0.00,0.00),('1','179','933','257476',4900576,'2743','413',18299.58,18310.64,0.00,0.00,11.06,8516.20,0.00,0.00,0.00),('1','179','933','257477',4900577,'2742','413',25806.07,25966.13,0.00,0.00,160.06,123246.20,0.00,0.00,0.00),('1','179','933','257477',4900578,'2743','413',18310.64,18324.69,0.00,0.00,14.05,10818.50,0.00,0.00,0.00),('1','179','933','257478',4900579,'2742','413',25966.13,26090.26,0.00,0.00,124.13,95580.10,0.00,0.00,0.00),('1','179','933','257478',4900580,'2743','413',18324.69,18416.27,0.00,0.00,91.58,68516.60,0.00,0.00,0.00),('1','179','933','257479',4900581,'2742','413',26090.26,26299.43,0.00,0.00,209.17,161060.90,0.00,0.00,0.00),('1','179','933','257479',4900582,'2743','413',18416.27,18716.98,0.00,0.00,300.71,221796.70,0.00,0.00,0.00),('1','179','933','257480',4900583,'2742','413',26299.43,26510.87,0.00,0.00,211.44,162808.80,0.00,0.00,0.00),('1','179','933','257480',4900584,'2743','413',18716.98,18867.01,0.00,0.00,150.03,115523.10,0.00,0.00,0.00),('1','179','933','257481',4900585,'2742','413',26510.87,26731.87,0.00,0.00,221.00,170170.00,0.00,0.00,0.00),('1','179','933','257481',4900586,'2743','413',18867.01,19230.26,0.00,0.00,363.25,269052.50,0.00,0.00,0.00),('1','179','933','257482',4900587,'2742','413',26731.87,26920.88,0.00,0.00,189.01,145537.70,0.00,0.00,0.00),('1','179','933','257482',4900588,'2743','413',19230.26,19355.53,0.00,0.00,125.27,96457.90,0.00,0.00,0.00),('1','179','933','257483',4900589,'2742','413',26920.88,27261.32,0.00,0.00,340.44,262138.80,0.00,0.00,0.00),('1','179','933','257483',4900590,'2743','413',19355.53,19369.82,0.00,0.00,14.29,11003.30,0.00,0.00,0.00),('1','179','933','257484',4900591,'2742','413',27261.32,27490.92,0.00,0.00,229.60,176792.00,0.00,0.00,0.00),('1','179','933','257484',4900592,'2743','413',19369.82,19445.45,0.00,0.00,75.63,58235.10,0.00,0.00,0.00),('1','179','933','257485',4900593,'2742','413',27490.92,27550.30,0.00,0.00,59.38,45722.60,0.00,0.00,0.00),('1','179','933','257485',4900594,'2743','413',19445.45,19529.77,0.00,0.00,84.32,64926.40,0.00,0.00,0.00),('1','179','933','257486',4900595,'2742','413',27550.30,27567.25,0.00,0.00,16.95,13051.50,0.00,0.00,0.00),('1','179','933','257486',4900596,'2743','413',19529.77,19749.77,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','179','933','257487',4900597,'2742','413',27567.25,27694.39,0.00,0.00,127.14,97897.80,0.00,0.00,0.00),('1','179','933','257487',4900598,'2743','413',19749.77,19749.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257488',4900599,'2742','413',27694.39,27946.68,0.00,0.00,252.29,194263.30,0.00,0.00,0.00),('1','179','933','257488',4900600,'2743','413',19749.77,19749.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257489',4900601,'2742','413',27946.68,28144.88,0.00,0.00,198.20,152614.00,0.00,0.00,0.00),('1','179','933','257489',4900602,'2743','413',19749.77,19859.77,0.00,0.00,110.00,79200.00,0.00,0.00,0.00),('1','179','933','257490',4900603,'2742','413',28144.88,28263.87,0.00,0.00,118.99,91622.30,0.00,0.00,0.00),('1','179','933','257490',4900604,'2743','413',19859.77,19888.71,0.00,0.00,28.94,22283.80,0.00,0.00,0.00),('1','179','933','257491',4900605,'2742','413',28263.87,28270.87,0.00,0.00,7.00,5390.00,0.00,0.00,0.00),('1','179','933','257491',4900606,'2743','413',19888.71,19900.56,0.00,0.00,11.85,9124.50,0.00,0.00,0.00),('1','179','933','257492',4900607,'2742','413',28270.87,28313.44,0.00,0.00,42.57,32778.90,0.00,0.00,0.00),('1','179','933','257492',4900608,'2743','413',19900.56,19966.72,0.00,0.00,66.16,50943.20,0.00,0.00,0.00),('1','179','933','257493',4900609,'2742','413',28313.44,28484.01,0.00,0.00,170.57,131338.90,0.00,0.00,0.00),('1','179','933','257493',4900610,'2743','413',19966.72,20091.72,0.00,0.00,125.00,90000.00,0.00,0.00,0.00),('1','179','933','257494',4900611,'2742','413',28484.01,28720.73,0.00,0.00,236.72,182274.40,0.00,0.00,0.00),('1','179','933','257494',4900612,'2743','413',20091.72,20341.72,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','179','933','257495',4900613,'2742','413',28720.73,28866.23,0.00,0.00,145.50,112035.00,0.00,0.00,0.00),('1','179','933','257495',4900614,'2743','413',20341.72,20422.74,0.00,0.00,81.02,62385.40,0.00,0.00,0.00),('1','179','933','257496',4900615,'2742','413',28866.23,29014.07,0.00,0.00,147.84,113836.80,0.00,0.00,0.00),('1','179','933','257496',4900616,'2743','413',20422.74,20423.74,0.00,0.00,1.00,770.00,0.00,0.00,0.00),('1','179','933','257497',4900617,'2742','413',29014.07,29205.76,0.00,0.00,191.69,147601.30,0.00,0.00,0.00),('1','179','933','257497',4900618,'2743','413',20423.74,20494.24,0.00,0.00,70.50,50760.00,0.00,0.00,0.00),('1','179','933','257498',4900619,'2742','413',29205.76,29475.25,0.00,0.00,269.49,207507.30,0.00,0.00,0.00),('1','179','933','257498',4900620,'2743','413',20494.24,20556.74,0.00,0.00,62.50,45000.00,0.00,0.00,0.00),('1','179','933','257499',4900621,'2742','413',29475.25,29662.97,0.00,0.00,187.72,144544.40,0.00,0.00,0.00),('1','179','933','257499',4900622,'2743','413',20556.74,20556.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257500',4900623,'2742','413',29662.97,29764.59,0.00,0.00,101.62,78247.40,0.00,0.00,0.00),('1','179','933','257500',4900624,'2743','413',20556.74,20756.74,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257501',4900625,'2742','413',29764.59,29908.71,0.00,0.00,144.12,110972.40,0.00,0.00,0.00),('1','179','933','257501',4900626,'2743','413',20756.74,20762.74,0.00,0.00,6.00,4620.00,0.00,0.00,0.00),('1','179','933','257502',4900627,'2742','413',29908.71,30054.96,0.00,0.00,146.25,112612.50,0.00,0.00,0.00),('1','179','933','257502',4900628,'2743','413',20762.74,20762.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257503',4900629,'2742','413',30054.96,30251.52,0.00,0.00,196.56,151351.20,0.00,0.00,0.00),('1','179','933','257503',4900630,'2743','413',20762.74,21012.74,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','179','933','257504',4900631,'2742','413',30251.52,30407.60,0.00,0.00,156.08,120181.60,0.00,0.00,0.00),('1','179','933','257504',4900632,'2743','413',21012.74,21097.74,0.00,0.00,85.00,61200.00,0.00,0.00,0.00),('1','179','933','257505',4900633,'2742','413',30407.60,30576.24,0.00,0.00,168.64,129852.80,0.00,0.00,0.00),('1','179','933','257505',4900634,'2743','413',21097.74,21174.74,0.00,0.00,77.00,55440.00,0.00,0.00,0.00),('1','179','933','257506',4900635,'2742','413',30576.24,30703.38,0.00,0.00,127.14,97897.80,0.00,0.00,0.00),('1','179','933','257506',4900636,'2743','413',21174.74,21266.27,0.00,0.00,91.53,65901.60,0.00,0.00,0.00),('1','179','933','257507',4900637,'2742','413',30703.38,30830.31,0.00,0.00,126.93,97736.10,0.00,0.00,0.00),('1','179','933','257507',4900638,'2743','413',21266.27,21366.27,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257508',4900639,'2742','413',30830.31,30959.53,0.00,0.00,129.22,99499.40,0.00,0.00,0.00),('1','179','933','257508',4900640,'2743','413',21366.27,21366.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257509',4900641,'2742','413',30959.53,31084.92,0.00,0.00,125.39,96550.30,0.00,0.00,0.00),('1','179','933','257509',4900642,'2743','413',21366.27,21366.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257510',4900643,'2742','413',31084.92,31201.29,0.00,0.00,116.37,89604.90,0.00,0.00,0.00),('1','179','933','257510',4900644,'2743','413',21366.27,21566.27,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257511',4900645,'2742','413',31201.29,31329.94,0.00,0.00,128.65,99060.50,0.00,0.00,0.00),('1','179','933','257511',4900646,'2743','413',21566.27,21631.27,0.00,0.00,65.00,46800.00,0.00,0.00,0.00),('1','179','933','257512',4900647,'2742','413',31329.94,31387.14,0.00,0.00,57.20,44044.00,0.00,0.00,0.00),('1','179','933','257512',4900648,'2743','413',21631.27,21631.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257513',4900649,'2742','413',31387.14,31445.02,0.00,0.00,57.88,44567.60,0.00,0.00,0.00),('1','179','933','257513',4900650,'2743','413',21631.27,21731.27,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257514',4900651,'2742','413',31445.02,31523.27,0.00,0.00,78.25,60252.50,0.00,0.00,0.00),('1','179','933','257514',4900652,'2743','413',21731.27,21781.27,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257515',4900653,'2742','413',31523.27,31670.96,0.00,0.00,147.69,113721.30,0.00,0.00,0.00),('1','179','933','257515',4900654,'2743','413',21781.27,22481.27,0.00,0.00,700.00,504000.00,0.00,0.00,0.00),('1','179','933','257516',4900655,'2742','413',31670.96,31789.44,0.00,0.00,118.48,91229.60,0.00,0.00,0.00),('1','179','933','257516',4900656,'2743','413',22481.27,22691.27,0.00,0.00,210.00,151200.00,0.00,0.00,0.00),('1','179','933','257517',4900657,'2742','413',31789.44,31789.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257517',4900658,'2743','413',22691.27,22691.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257518',4900659,'2742','413',31789.44,31969.36,0.00,0.00,179.92,138538.40,0.00,0.00,0.00),('1','179','933','257518',4900660,'2743','413',22691.27,23058.27,0.00,0.00,367.00,264240.00,0.00,0.00,0.00),('1','179','933','257519',4900661,'2742','413',31969.36,32108.28,0.00,0.00,138.92,106968.40,0.00,0.00,0.00),('1','179','933','257519',4900662,'2743','413',23058.27,23390.27,0.00,0.00,332.00,239040.00,0.00,0.00,0.00),('1','179','933','257520',4900663,'2742','413',32108.28,32270.51,0.00,0.00,162.23,124917.10,0.00,0.00,0.00),('1','179','933','257520',4900664,'2743','413',23390.27,23390.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257521',4900665,'2742','413',32270.51,32458.93,0.00,0.00,188.42,145083.40,0.00,0.00,0.00),('1','179','933','257521',4900666,'2743','413',23390.27,24065.27,0.00,0.00,675.00,486000.00,0.00,0.00,0.00),('1','179','933','257522',4900667,'2742','413',32458.93,32690.55,0.00,0.00,231.62,178347.40,0.00,0.00,0.00),('1','179','933','257522',4900668,'2743','413',24065.27,24065.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257523',4900669,'2742','413',32690.55,32847.35,0.00,0.00,156.80,120736.00,0.00,0.00,0.00),('1','179','933','257523',4900670,'2743','413',24065.27,24165.27,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257524',4900671,'2742','413',32847.35,33099.26,0.00,0.00,251.91,193970.70,0.00,0.00,0.00),('1','179','933','257524',4900672,'2743','413',24165.27,24215.27,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257525',4900673,'2742','413',33099.26,33420.75,0.00,0.00,321.49,247547.30,0.00,0.00,0.00),('1','179','933','257525',4900674,'2743','413',24215.27,24331.77,0.00,0.00,116.50,83880.00,0.00,0.00,0.00),('1','179','933','257526',4900675,'2742','413',33420.75,33634.05,0.00,0.00,213.30,164241.00,0.00,0.00,0.00),('1','179','933','257526',4900676,'2743','413',24331.77,24386.77,0.00,0.00,55.00,39600.00,0.00,0.00,0.00),('1','179','933','257527',4900677,'2742','413',33634.05,33782.06,0.00,0.00,148.01,113967.70,0.00,0.00,0.00),('1','179','933','257527',4900678,'2743','413',24386.77,24480.76,0.00,0.00,93.99,72372.30,0.00,0.00,0.00),('1','179','933','257528',4900679,'2742','413',33782.06,34062.76,0.00,0.00,280.70,216139.00,0.00,0.00,0.00),('1','179','933','257528',4900680,'2743','413',24480.76,25125.76,0.00,0.00,645.00,464400.00,0.00,0.00,0.00),('1','179','933','257529',4900681,'2742','413',34062.76,34091.48,0.00,0.00,28.72,22114.40,0.00,0.00,0.00),('1','179','933','257529',4900682,'2743','413',25125.76,25369.26,0.00,0.00,243.50,175320.00,0.00,0.00,0.00),('1','179','933','257530',4900683,'2742','413',34091.48,34091.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257530',4900684,'2743','413',25369.26,25369.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257531',4900685,'2742','413',34091.48,34197.73,0.00,0.00,106.25,81812.50,0.00,0.00,0.00),('1','179','933','257531',4900686,'2743','413',25369.26,25369.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257532',4900687,'2742','413',34197.73,34322.65,0.00,0.00,124.92,96188.40,0.00,0.00,0.00),('1','179','933','257532',4900688,'2743','413',25369.26,25369.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257533',4900689,'2742','413',34322.65,34635.86,0.00,0.00,313.21,241171.70,0.00,0.00,0.00),('1','179','933','257533',4900690,'2743','413',25369.26,25646.26,0.00,0.00,277.00,199440.00,0.00,0.00,0.00),('1','179','933','257534',4900691,'2742','413',34635.86,34871.66,0.00,0.00,235.80,181566.00,0.00,0.00,0.00),('1','179','933','257534',4900692,'2743','413',25646.26,27443.26,0.00,0.00,1797.00,1293840.00,0.00,0.00,0.00),('1','179','933','257535',4900693,'2742','413',34871.66,34871.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257535',4900694,'2743','413',27443.26,27443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257536',4900695,'2742','413',34871.66,34983.42,0.00,0.00,111.76,86055.20,0.00,0.00,0.00),('1','179','933','257536',4900696,'2743','413',27443.26,27561.26,0.00,0.00,118.00,84960.00,0.00,0.00,0.00),('1','179','933','257537',4900697,'2742','413',34983.42,35017.27,0.00,0.00,33.85,26064.50,0.00,0.00,0.00),('1','179','933','257537',4900698,'2743','413',27561.26,27661.26,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257538',4900699,'2742','413',35017.27,35061.60,0.00,0.00,44.33,34134.10,0.00,0.00,0.00),('1','179','933','257538',4900700,'2743','413',27661.26,27711.26,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257539',4900701,'2742','413',35061.60,35075.89,0.00,0.00,14.29,11003.30,0.00,0.00,0.00),('1','179','933','257539',4900702,'2743','413',27711.26,28100.26,0.00,0.00,389.00,280080.00,0.00,0.00,0.00),('1','179','933','257540',4900703,'2742','413',35075.89,35075.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257540',4900704,'2743','413',28100.26,28992.26,0.00,0.00,892.00,642240.00,0.00,0.00,0.00),('1','179','933','257541',4900705,'2742','413',35075.89,35075.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257541',4900706,'2743','413',28992.26,29292.26,0.00,0.00,300.00,216000.00,0.00,0.00,0.00),('1','179','933','257542',4900707,'2742','413',35075.89,35075.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257542',4900708,'2743','413',29292.26,29292.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257543',4900709,'2742','413',35075.89,35277.75,0.00,0.00,201.86,159469.40,0.00,0.00,0.00),('1','179','933','257543',4900710,'2743','413',29292.26,30029.56,0.00,0.00,737.30,542602.00,0.00,0.00,0.00),('1','179','933','257544',4900711,'2742','413',35277.75,35390.22,0.00,0.00,112.47,88851.30,0.00,0.00,0.00),('1','179','933','257544',4900712,'2743','413',30029.56,30920.06,0.00,0.00,890.50,659270.00,0.00,0.00,0.00),('1','179','933','257545',4900713,'2742','413',35390.22,35541.04,0.00,0.00,150.82,119147.80,0.00,0.00,0.00),('1','179','933','257545',4900714,'2743','413',30920.06,31010.06,0.00,0.00,90.00,66600.00,0.00,0.00,0.00),('1','179','933','257546',4900715,'2742','413',35541.04,35870.42,0.00,0.00,329.38,260210.20,0.00,0.00,0.00),('1','179','933','257546',4900716,'2743','413',31010.06,31750.06,0.00,0.00,740.00,547600.00,0.00,0.00,0.00),('1','179','933','257547',4900717,'2742','413',35870.42,36100.72,0.00,0.00,230.30,181937.00,0.00,0.00,0.00),('1','179','933','257547',4900718,'2743','413',31750.06,32120.06,0.00,0.00,370.00,273800.00,0.00,0.00,0.00),('1','179','933','257548',4900719,'2742','413',36100.72,36292.22,0.00,0.00,191.50,151285.00,0.00,0.00,0.00),('1','179','933','257548',4900720,'2743','413',32120.06,32732.49,0.00,0.00,612.43,453198.20,0.00,0.00,0.00),('1','179','933','257549',4900721,'2742','413',36292.22,36292.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257549',4900722,'2743','413',32732.49,32952.49,0.00,0.00,220.00,162800.00,0.00,0.00,0.00),('1','179','933','257550',4900723,'2742','413',36292.22,36292.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257550',4900724,'2743','413',32952.49,32952.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257551',4900725,'2742','413',36292.22,36435.91,0.00,0.00,143.69,113515.10,0.00,0.00,0.00),('1','179','933','257551',4900726,'2743','413',32952.49,33176.14,0.00,0.00,223.65,165501.00,0.00,0.00,0.00),('1','179','933','257552',4900727,'2742','413',36435.91,36661.95,0.00,0.00,226.04,178571.60,0.00,0.00,0.00),('1','179','933','257552',4900728,'2743','413',33176.14,34226.14,0.00,0.00,1050.00,777000.00,0.00,0.00,0.00),('1','179','933','257553',4900729,'2742','413',36661.95,36931.91,0.00,0.00,269.96,213268.40,0.00,0.00,0.00),('1','179','933','257553',4900730,'2743','413',34226.14,35496.14,0.00,0.00,1270.00,939800.00,0.00,0.00,0.00),('1','179','933','257554',4900731,'2742','413',36931.91,37131.03,0.00,0.00,199.12,157304.80,0.00,0.00,0.00),('1','179','933','257554',4900732,'2743','413',35496.14,35796.14,0.00,0.00,300.00,222000.00,0.00,0.00,0.00),('1','179','933','257555',4900733,'2742','413',37131.03,37298.33,0.00,0.00,167.30,132167.00,0.00,0.00,0.00),('1','179','933','257555',4900734,'2743','413',35796.14,36183.14,0.00,0.00,387.00,286380.00,0.00,0.00,0.00),('1','179','933','257556',4900735,'2742','413',37298.33,37332.63,0.00,0.00,34.30,27097.00,0.00,0.00,0.00),('1','179','933','257556',4900736,'2743','413',36183.14,37093.14,0.00,0.00,910.00,673400.00,0.00,0.00,0.00),('1','179','933','257557',4900737,'2742','413',37332.63,37427.64,0.00,0.00,95.01,75057.90,0.00,0.00,0.00),('1','179','933','257557',4900738,'2743','413',37093.14,37426.04,0.00,0.00,332.90,246346.00,0.00,0.00,0.00),('1','179','933','257558',4900739,'2742','413',37427.64,37704.87,0.00,0.00,277.23,219011.70,0.00,0.00,0.00),('1','179','933','257558',4900740,'2743','413',37426.04,39453.04,0.00,0.00,2027.00,1493010.00,0.00,0.00,0.00),('1','179','933','257559',4900741,'2742','413',37704.87,37877.60,0.00,0.00,172.73,136456.70,0.00,0.00,0.00),('1','179','933','257559',4900742,'2743','413',39453.04,40215.07,0.00,0.00,762.03,563902.20,0.00,0.00,0.00),('1','179','933','257560',4900743,'2742','413',37877.60,38061.20,0.00,0.00,183.60,145044.00,0.00,0.00,0.00),('1','179','933','257560',4900744,'2743','413',40215.07,40995.07,0.00,0.00,780.00,577200.00,0.00,0.00,0.00),('1','179','933','257561',4900745,'2742','413',38061.20,38231.85,0.00,0.00,170.65,134813.50,0.00,0.00,0.00),('1','179','933','257561',4900746,'2743','413',40995.07,41318.04,0.00,0.00,322.97,238997.80,0.00,0.00,0.00),('1','179','933','257562',4900747,'2742','413',38231.85,38231.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257562',4900748,'2743','413',41318.04,41350.47,0.00,0.00,32.43,23998.20,0.00,0.00,0.00),('1','179','933','257563',4900749,'2742','413',38231.85,38409.57,0.00,0.00,177.72,140398.80,0.00,0.00,0.00),('1','179','933','257563',4900750,'2743','413',41350.47,42709.90,0.00,0.00,1359.43,1005978.20,0.00,0.00,0.00),('1','179','933','257564',4900751,'2742','413',38409.57,38523.35,0.00,0.00,113.78,89886.20,0.00,0.00,0.00),('1','179','933','257564',4900752,'2743','413',42709.90,43049.87,0.00,0.00,339.97,251577.80,0.00,0.00,0.00),('1','179','933','257565',4900753,'2742','413',38523.35,38654.24,0.00,0.00,130.89,103403.10,0.00,0.00,0.00),('1','179','933','257565',4900754,'2743','413',43049.87,43397.84,0.00,0.00,347.97,257497.80,0.00,0.00,0.00),('1','179','933','257566',4900755,'2742','413',38654.24,38834.63,0.00,0.00,180.39,142508.10,0.00,0.00,0.00),('1','179','933','257566',4900756,'2743','413',43397.84,43677.84,0.00,0.00,280.00,207200.00,0.00,0.00,0.00),('1','179','933','257567',4900757,'2742','413',38834.63,39031.92,0.00,0.00,197.29,155859.10,0.00,0.00,0.00),('1','179','933','257567',4900758,'2743','413',43677.84,46927.84,0.00,0.00,3250.00,2380350.00,0.00,0.00,0.00),('1','179','933','257568',4900759,'2742','413',39031.92,39232.37,0.00,0.00,200.45,158355.50,0.00,0.00,0.00),('1','179','933','257568',4900760,'2743','413',46927.84,47180.81,0.00,0.00,252.97,187197.80,0.00,0.00,0.00),('1','179','933','257569',4900761,'2742','413',39232.37,39258.42,0.00,0.00,26.05,20579.50,0.00,0.00,0.00),('1','179','933','257569',4900762,'2743','413',47180.81,47230.81,0.00,0.00,50.00,37000.00,0.00,0.00,0.00),('1','179','933','257570',4900763,'2742','413',39258.42,39387.95,0.00,0.00,129.53,102328.70,0.00,0.00,0.00),('1','179','933','257570',4900764,'2743','413',47230.81,47593.84,0.00,0.00,363.03,268642.20,0.00,0.00,0.00),('1','179','933','257571',4900765,'2742','413',39387.95,39819.98,0.00,0.00,432.03,319702.20,0.00,0.00,0.00),('1','179','933','257571',4900766,'2743','413',47593.84,47765.76,0.00,0.00,171.92,135816.80,0.00,0.00,0.00),('1','179','933','257572',4900767,'2742','413',39819.98,39819.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257572',4900768,'2743','413',47765.76,47927.89,0.00,0.00,162.13,128082.70,0.00,0.00,0.00),('1','179','933','257573',4900769,'2742','413',39819.98,40777.55,0.00,0.00,957.57,706101.80,0.00,0.00,0.00),('1','179','933','257573',4900770,'2743','413',47927.89,48132.10,0.00,0.00,204.21,161325.90,0.00,0.00,0.00),('1','179','933','257574',4900771,'2742','413',40777.55,41507.55,0.00,0.00,730.00,540200.00,0.00,0.00,0.00),('1','179','933','257574',4900772,'2743','413',48132.10,48301.57,0.00,0.00,169.47,133881.30,0.00,0.00,0.00),('1','179','933','257575',4900773,'2742','413',41507.55,41933.87,0.00,0.00,426.32,315476.80,0.00,0.00,0.00),('1','179','933','257575',4900774,'2743','413',48301.57,48492.52,0.00,0.00,190.95,150850.50,0.00,0.00,0.00),('1','179','933','257576',4900775,'2742','413',41933.87,42141.75,0.00,0.00,207.88,164225.20,0.00,0.00,0.00),('1','179','933','257576',4900776,'2743','413',48492.52,48931.44,0.00,0.00,438.92,324800.80,0.00,0.00,0.00),('1','179','933','257577',4900777,'2742','413',42141.75,42375.12,0.00,0.00,233.37,184362.30,0.00,0.00,0.00),('1','179','933','257577',4900778,'2743','413',48931.44,49055.76,0.00,0.00,124.32,91996.80,0.00,0.00,0.00),('1','179','933','257578',4900779,'2742','413',42375.12,42585.62,0.00,0.00,210.50,166295.00,0.00,0.00,0.00),('1','179','933','257578',4900780,'2743','413',49055.76,49240.49,0.00,0.00,184.73,136700.20,0.00,0.00,0.00),('1','179','933','257579',4900781,'2742','413',42585.62,42750.51,0.00,0.00,164.89,130263.10,0.00,0.00,0.00),('1','179','933','257579',4900782,'2743','413',49240.49,49290.49,0.00,0.00,50.00,37000.00,0.00,0.00,0.00),('1','179','933','257580',4900783,'2742','413',42750.51,42963.55,0.00,0.00,213.04,168301.60,0.00,0.00,0.00),('1','179','933','257580',4900784,'2743','413',49290.49,49606.71,0.00,0.00,316.22,234002.80,0.00,0.00,0.00),('1','179','933','257581',4900785,'2742','413',42963.55,43209.56,0.00,0.00,246.01,194347.90,0.00,0.00,0.00),('1','179','933','257581',4900786,'2743','413',49606.71,49738.33,0.00,0.00,131.62,97398.80,0.00,0.00,0.00),('1','179','933','257582',4900787,'2742','413',43209.56,43327.24,0.00,0.00,117.68,92967.20,0.00,0.00,0.00),('1','179','933','257582',4900788,'2743','413',49738.33,50528.33,0.00,0.00,790.00,584600.00,0.00,0.00,0.00),('1','179','933','257583',4900789,'2742','413',43327.24,43429.70,0.00,0.00,102.46,80943.40,0.00,0.00,0.00),('1','179','933','257583',4900790,'2743','413',50528.33,50528.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257584',4900791,'2742','413',43429.70,43429.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257584',4900792,'2743','413',50528.33,50528.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257585',4900793,'2742','413',43429.70,43620.74,0.00,0.00,191.04,150921.60,0.00,0.00,0.00),('1','179','933','257585',4900794,'2743','413',50528.33,51338.33,0.00,0.00,810.00,599400.00,0.00,0.00,0.00),('1','179','933','257586',4900795,'2742','413',43620.74,43790.92,0.00,0.00,170.18,134442.20,0.00,0.00,0.00),('1','179','933','257586',4900796,'2743','413',51338.33,51457.25,0.00,0.00,118.92,88000.80,0.00,0.00,0.00),('1','179','933','257587',4900797,'2742','413',43790.92,44018.16,0.00,0.00,227.24,179519.60,0.00,0.00,0.00),('1','179','933','257587',4900798,'2743','413',51457.25,51961.28,0.00,0.00,504.03,372982.20,0.00,0.00,0.00),('1','179','933','257588',4900799,'2742','413',44018.16,44280.44,0.00,0.00,262.28,201955.60,0.00,0.00,0.00),('1','179','933','257588',4900800,'2743','413',51961.28,53080.28,0.00,0.00,1119.00,805680.00,0.00,0.00,0.00),('1','179','933','257589',4900801,'2742','413',44280.44,44476.50,0.00,0.00,196.06,150966.20,0.00,0.00,0.00),('1','179','933','257589',4900802,'2743','413',53080.28,53995.28,0.00,0.00,915.00,655225.00,0.00,0.00,0.00),('1','179','933','257590',4900803,'2742','413',44476.50,44577.06,0.00,0.00,100.56,77431.20,0.00,0.00,0.00),('1','179','933','257590',4900804,'2743','413',53995.28,54495.28,0.00,0.00,500.00,360000.00,0.00,0.00,0.00),('1','179','933','257591',4900805,'2742','413',44577.06,44812.25,0.00,0.00,235.19,181096.30,0.00,0.00,0.00),('1','179','933','257591',4900806,'2743','413',54495.28,56194.28,0.00,0.00,1699.00,1215410.00,0.00,0.00,0.00),('1','179','933','257592',4900807,'2742','413',44812.25,44973.86,0.00,0.00,161.61,124439.70,0.00,0.00,0.00),('1','179','933','257592',4900808,'2743','413',56194.28,56479.28,0.00,0.00,285.00,205200.00,0.00,0.00,0.00),('1','179','933','257593',4900809,'2742','413',44973.86,45162.64,0.00,0.00,188.78,145360.60,0.00,0.00,0.00),('1','179','933','257593',4900810,'2743','413',56479.28,56529.28,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257594',4900811,'2742','413',45162.64,45380.46,0.00,0.00,217.82,167721.40,0.00,0.00,0.00),('1','179','933','257594',4900812,'2743','413',56529.28,56911.78,0.00,0.00,382.50,275400.00,0.00,0.00,0.00),('1','179','933','257595',4900813,'2742','413',45380.46,45675.98,0.00,0.00,295.52,227550.40,0.00,0.00,0.00),('1','179','933','257595',4900814,'2743','413',56911.78,57161.78,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','179','933','257596',4900815,'2742','413',45675.98,45853.86,0.00,0.00,177.88,136967.60,0.00,0.00,0.00),('1','179','933','257596',4900816,'2743','413',57161.78,58824.28,0.00,0.00,1662.50,1180825.00,0.00,0.00,0.00),('1','179','933','257597',4900817,'2742','413',45853.86,46086.22,0.00,0.00,232.36,178917.20,0.00,0.00,0.00),('1','179','933','257597',4900818,'2743','413',58824.28,59314.28,0.00,0.00,490.00,352800.00,0.00,0.00,0.00),('1','179','933','257598',4900819,'2742','413',46086.22,46293.17,0.00,0.00,206.95,159351.50,0.00,0.00,0.00),('1','179','933','257598',4900820,'2743','413',59314.28,59481.28,0.00,0.00,167.00,120240.00,0.00,0.00,0.00),('1','179','933','257599',4900821,'2742','413',46293.17,46457.42,0.00,0.00,164.25,126472.50,0.00,0.00,0.00),('1','179','933','257599',4900822,'2743','413',59481.28,59666.28,0.00,0.00,185.00,133200.00,0.00,0.00,0.00),('1','179','933','257600',4900823,'2742','413',46457.42,46652.79,0.00,0.00,195.37,150434.90,0.00,0.00,0.00),('1','179','933','257600',4900824,'2743','413',59666.28,59866.28,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257601',4900825,'2742','413',46652.79,46749.53,0.00,0.00,96.74,74489.80,0.00,0.00,0.00),('1','179','933','257601',4900826,'2743','413',59866.28,60116.28,0.00,0.00,250.00,180000.00,0.00,0.00,0.00),('1','179','933','257602',4900827,'2742','413',46749.53,46760.53,0.00,0.00,11.00,8470.00,0.00,0.00,0.00),('1','179','933','257602',4900828,'2743','413',60116.28,60169.98,0.00,0.00,53.70,38664.00,0.00,0.00,0.00),('1','179','933','257603',4900829,'2742','413',46760.53,46939.63,0.00,0.00,179.10,137907.00,0.00,0.00,0.00),('1','179','933','257603',4900830,'2743','413',60169.98,60219.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257604',4900831,'2742','413',46939.63,47180.77,0.00,0.00,241.14,185677.80,0.00,0.00,0.00),('1','179','933','257604',4900832,'2743','413',60219.98,60264.98,0.00,0.00,45.00,32400.00,0.00,0.00,0.00),('1','179','933','257605',4900833,'2742','413',47180.77,47471.18,0.00,0.00,290.41,223615.70,0.00,0.00,0.00),('1','179','933','257605',4900834,'2743','413',60264.98,60699.98,0.00,0.00,435.00,313200.00,0.00,0.00,0.00),('1','179','933','257606',4900835,'2742','413',47471.18,47674.44,0.00,0.00,203.26,156510.20,0.00,0.00,0.00),('1','179','933','257606',4900836,'2743','413',60699.98,61034.98,0.00,0.00,335.00,241200.00,0.00,0.00,0.00),('1','179','933','257607',4900837,'2742','413',47674.44,47904.04,0.00,0.00,229.60,176792.00,0.00,0.00,0.00),('1','179','933','257607',4900838,'2743','413',61034.98,61459.98,0.00,0.00,425.00,306000.00,0.00,0.00,0.00),('1','179','933','257608',4900839,'2742','413',47904.04,48071.48,0.00,0.00,167.44,128928.80,0.00,0.00,0.00),('1','179','933','257608',4900840,'2743','413',61459.98,61754.98,0.00,0.00,295.00,212400.00,0.00,0.00,0.00),('1','179','933','257609',4900841,'2742','413',48071.48,48269.52,0.00,0.00,198.04,152490.80,0.00,0.00,0.00),('1','179','933','257609',4900842,'2743','413',61754.98,61954.98,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257610',4900843,'2742','413',48269.52,48500.11,0.00,0.00,230.59,177554.30,0.00,0.00,0.00),('1','179','933','257610',4900844,'2743','413',61954.98,62034.98,0.00,0.00,80.00,57600.00,0.00,0.00,0.00),('1','179','933','257611',4900845,'2742','413',48500.11,48759.33,0.00,0.00,259.22,199599.40,0.00,0.00,0.00),('1','179','933','257611',4900846,'2743','413',62034.98,62529.98,0.00,0.00,495.00,356400.00,0.00,0.00,0.00),('1','179','933','257612',4900847,'2742','413',48759.33,48959.78,0.00,0.00,200.45,154346.50,0.00,0.00,0.00),('1','179','933','257612',4900848,'2743','413',62529.98,62965.98,0.00,0.00,436.00,313920.00,0.00,0.00,0.00),('1','179','933','257613',4900849,'2742','413',48959.78,48959.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257613',4900850,'2743','413',62965.98,62965.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257614',4900851,'2742','413',48959.78,49158.13,0.00,0.00,198.35,152729.50,0.00,0.00,0.00),('1','179','933','257614',4900852,'2743','413',62965.98,63118.98,0.00,0.00,153.00,110160.00,0.00,0.00,0.00),('1','179','933','257615',4900853,'2742','413',49158.13,49353.74,0.00,0.00,195.61,150619.70,0.00,0.00,0.00),('1','179','933','257615',4900854,'2743','413',63118.98,63468.98,0.00,0.00,350.00,252000.00,0.00,0.00,0.00),('1','179','933','257616',4900855,'2742','413',49353.74,49547.88,0.00,0.00,194.14,149487.80,0.00,0.00,0.00),('1','179','933','257616',4900856,'2743','413',63468.98,63917.98,0.00,0.00,449.00,323280.00,0.00,0.00,0.00),('1','179','933','257617',4900857,'2742','413',49547.88,49816.54,0.00,0.00,268.66,206868.20,0.00,0.00,0.00),('1','179','933','257617',4900858,'2743','413',63917.98,63992.98,0.00,0.00,75.00,54000.00,0.00,0.00,0.00),('1','179','933','257618',4900859,'2742','413',49816.54,50000.74,0.00,0.00,184.20,141834.00,0.00,0.00,0.00),('1','179','933','257618',4900860,'2743','413',63992.98,63992.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257619',4900861,'2742','413',50000.74,50216.71,0.00,0.00,215.97,166296.90,0.00,0.00,0.00),('1','179','933','257619',4900862,'2743','413',63992.98,63992.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257620',4900863,'2742','413',50216.71,50431.95,0.00,0.00,215.24,165734.80,0.00,0.00,0.00),('1','179','933','257620',4900864,'2743','413',63992.98,64042.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257621',4900865,'2742','413',50431.95,50658.71,0.00,0.00,226.76,174605.20,0.00,0.00,0.00),('1','179','933','257621',4900866,'2743','413',64042.98,64242.98,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257622',4900867,'2742','413',50658.71,50967.83,0.00,0.00,309.12,238022.40,0.00,0.00,0.00),('1','179','933','257622',4900868,'2743','413',64242.98,64462.98,0.00,0.00,220.00,158400.00,0.00,0.00,0.00),('1','179','933','257623',4900869,'2742','413',50967.83,51195.30,0.00,0.00,227.47,175151.90,0.00,0.00,0.00),('1','179','933','257623',4900870,'2743','413',64462.98,64587.98,0.00,0.00,125.00,90000.00,0.00,0.00,0.00),('1','179','933','257624',4900871,'2742','413',51195.30,51373.36,0.00,0.00,178.06,137106.20,0.00,0.00,0.00),('1','179','933','257624',4900872,'2743','413',64587.98,64587.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257625',4900873,'2742','413',51373.36,51557.58,0.00,0.00,184.22,141849.40,0.00,0.00,0.00),('1','179','933','257625',4900874,'2743','413',64587.98,64687.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257626',4900875,'2742','413',51557.58,51557.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257626',4900876,'2743','413',64687.98,65437.98,0.00,0.00,750.00,525000.00,0.00,0.00,0.00),('1','179','933','257627',4900877,'2742','413',51557.58,51701.77,0.00,0.00,144.19,111026.30,0.00,0.00,0.00),('1','179','933','257627',4900878,'2743','413',65437.98,65647.98,0.00,0.00,210.00,151200.00,0.00,0.00,0.00),('1','179','933','257628',4900879,'2742','413',51701.77,51945.54,0.00,0.00,243.77,187702.90,0.00,0.00,0.00),('1','179','933','257628',4900880,'2743','413',65647.98,65847.98,0.00,0.00,200.00,144000.00,0.00,0.00,0.00),('1','179','933','257629',4900881,'2742','413',51945.54,52168.60,0.00,0.00,223.06,171756.20,0.00,0.00,0.00),('1','179','933','257629',4900882,'2743','413',65847.98,66962.98,0.00,0.00,1115.00,791650.00,0.00,0.00,0.00),('1','179','933','257630',4900883,'2742','413',52168.60,52303.89,0.00,0.00,135.29,104173.30,0.00,0.00,0.00),('1','179','933','257630',4900884,'2743','413',66962.98,67112.98,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','179','933','257631',4900885,'2742','413',52303.89,52531.29,0.00,0.00,227.40,175098.00,0.00,0.00,0.00),('1','179','933','257631',4900886,'2743','413',67112.98,67612.98,0.00,0.00,500.00,355000.00,0.00,0.00,0.00),('1','179','933','257632',4900887,'2742','413',52531.29,52722.85,0.00,0.00,191.56,147501.20,0.00,0.00,0.00),('1','179','933','257632',4900888,'2743','413',67612.98,67712.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257633',4900889,'2742','413',52722.85,52935.35,0.00,0.00,212.50,163625.00,0.00,0.00,0.00),('1','179','933','257633',4900890,'2743','413',67712.98,67712.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257634',4900891,'2742','413',52935.35,52935.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257634',4900892,'2743','413',67712.98,67712.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257635',4900893,'2742','413',52935.35,53110.31,0.00,0.00,174.96,134719.20,0.00,0.00,0.00),('1','179','933','257635',4900894,'2743','413',67712.98,67762.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257636',4900895,'2742','413',53110.31,53310.46,0.00,0.00,200.15,154115.50,0.00,0.00,0.00),('1','179','933','257636',4900896,'2743','413',67762.98,68312.98,0.00,0.00,550.00,390500.00,0.00,0.00,0.00),('1','179','933','257637',4900897,'2742','413',53310.46,53499.82,0.00,0.00,189.36,145807.20,0.00,0.00,0.00),('1','179','933','257637',4900898,'2743','413',68312.98,68312.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257638',4900899,'2742','413',53499.82,53708.69,0.00,0.00,208.87,160829.90,0.00,0.00,0.00),('1','179','933','257638',4900900,'2743','413',68312.98,68312.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257639',4900901,'2742','413',53708.69,53843.48,0.00,0.00,134.79,103788.30,0.00,0.00,0.00),('1','179','933','257639',4900902,'2743','413',68312.98,68312.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257640',4900903,'2742','413',53843.48,54206.54,0.00,0.00,363.06,279556.20,0.00,0.00,0.00),('1','179','933','257640',4900904,'2743','413',68312.98,68312.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257641',4900905,'2742','413',54206.54,54408.25,0.00,0.00,201.71,155316.70,0.00,0.00,0.00),('1','179','933','257641',4900906,'2743','413',68312.98,68612.98,0.00,0.00,300.00,213000.00,0.00,0.00,0.00),('1','179','933','257642',4900907,'2742','413',54408.25,54604.87,0.00,0.00,196.62,151397.40,0.00,0.00,0.00),('1','179','933','257642',4900908,'2743','413',68612.98,68662.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257643',4900909,'2742','413',54604.87,54822.18,0.00,0.00,217.31,167328.70,0.00,0.00,0.00),('1','179','933','257643',4900910,'2743','413',68662.98,68708.98,0.00,0.00,46.00,33120.00,0.00,0.00,0.00),('1','179','933','257644',4900911,'2742','413',54822.18,55014.29,0.00,0.00,192.11,147924.70,0.00,0.00,0.00),('1','179','933','257644',4900912,'2743','413',68708.98,68708.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257645',4900913,'2742','413',55014.29,55270.77,0.00,0.00,256.48,197489.60,0.00,0.00,0.00),('1','179','933','257645',4900914,'2743','413',68708.98,69466.98,0.00,0.00,758.00,538180.00,0.00,0.00,0.00),('1','179','933','257646',4900915,'2742','413',55270.77,55505.21,0.00,0.00,234.44,180518.80,0.00,0.00,0.00),('1','179','933','257646',4900916,'2743','413',69466.98,69535.48,0.00,0.00,68.50,49320.00,0.00,0.00,0.00),('1','179','933','257647',4900917,'2742','413',55505.21,55719.49,0.00,0.00,214.28,164995.60,0.00,0.00,0.00),('1','179','933','257647',4900918,'2743','413',69535.48,69705.48,0.00,0.00,170.00,122400.00,0.00,0.00,0.00),('1','179','933','257648',4900919,'2742','413',55719.49,55982.90,0.00,0.00,263.41,202825.70,0.00,0.00,0.00),('1','179','933','257648',4900920,'2743','413',69705.48,69755.48,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257649',4900921,'2742','413',55982.90,56205.63,0.00,0.00,222.73,171502.10,0.00,0.00,0.00),('1','179','933','257649',4900922,'2743','413',69755.48,70005.48,0.00,0.00,250.00,177500.00,0.00,0.00,0.00),('1','179','933','257650',4900923,'2742','413',56205.63,56420.69,0.00,0.00,215.06,165596.20,0.00,0.00,0.00),('1','179','933','257650',4900924,'2743','413',70005.48,70170.48,0.00,0.00,165.00,118800.00,0.00,0.00,0.00),('1','179','933','257651',4900925,'2742','413',56420.69,56830.91,0.00,0.00,410.22,315869.40,0.00,0.00,0.00),('1','179','933','257651',4900926,'2743','413',70170.48,70225.48,0.00,0.00,55.00,39600.00,0.00,0.00,0.00),('1','179','933','257652',4900927,'2742','413',56830.91,57030.26,0.00,0.00,199.35,153499.50,0.00,0.00,0.00),('1','179','933','257652',4900928,'2743','413',70225.48,70225.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257653',4900929,'2742','413',57030.26,57030.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257653',4900930,'2743','413',70225.48,70225.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257654',4900931,'2742','413',57030.26,57030.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257654',4900932,'2743','413',70225.48,70225.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257655',4900933,'2742','413',57030.26,57216.13,0.00,0.00,185.87,143119.90,0.00,0.00,0.00),('1','179','933','257655',4900934,'2743','413',70225.48,70287.98,0.00,0.00,62.50,45000.00,0.00,0.00,0.00),('1','179','933','257656',4900935,'2742','413',57216.13,57465.36,0.00,0.00,249.23,191907.10,0.00,0.00,0.00),('1','179','933','257656',4900936,'2743','413',70287.98,70437.98,0.00,0.00,150.00,108000.00,0.00,0.00,0.00),('1','179','933','257657',4900937,'2742','413',57465.36,57612.75,0.00,0.00,147.39,113490.30,0.00,0.00,0.00),('1','179','933','257657',4900938,'2743','413',70437.98,70787.98,0.00,0.00,350.00,248500.00,0.00,0.00,0.00),('1','179','933','257658',4900939,'2742','413',57612.75,57751.75,0.00,0.00,139.00,107030.00,0.00,0.00,0.00),('1','179','933','257658',4900940,'2743','413',70787.98,70787.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257659',4900941,'2742','413',57751.75,57884.42,0.00,0.00,132.67,102155.90,0.00,0.00,0.00),('1','179','933','257659',4900942,'2743','413',70787.98,70887.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257660',4900943,'2742','413',57884.42,57892.36,0.00,0.00,7.94,6113.80,0.00,0.00,0.00),('1','179','933','257660',4900944,'2743','413',70887.98,70887.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257661',4900945,'2742','413',57892.36,58244.10,0.00,0.00,351.74,270839.80,0.00,0.00,0.00),('1','179','933','257661',4900946,'2743','413',70887.98,70887.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257662',4900947,'2742','413',58244.10,58499.11,0.00,0.00,255.01,196357.70,0.00,0.00,0.00),('1','179','933','257662',4900948,'2743','413',70887.98,70887.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257663',4900949,'2742','413',58499.11,58691.29,0.00,0.00,192.18,147978.60,0.00,0.00,0.00),('1','179','933','257663',4900950,'2743','413',70887.98,70937.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257664',4900951,'2742','413',58691.29,58863.88,0.00,0.00,172.59,132894.30,0.00,0.00,0.00),('1','179','933','257664',4900952,'2743','413',70937.98,70987.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257665',4900953,'2742','413',58863.88,59020.77,0.00,0.00,156.89,120805.30,0.00,0.00,0.00),('1','179','933','257665',4900954,'2743','413',70987.98,71037.98,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257666',4900955,'2742','413',59020.77,59275.32,0.00,0.00,254.55,196003.50,0.00,0.00,0.00),('1','179','933','257666',4900956,'2743','413',71037.98,71137.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257667',4900957,'2742','413',59275.32,59419.12,0.00,0.00,143.80,110726.00,0.00,0.00,0.00),('1','179','933','257667',4900958,'2743','413',71137.98,71137.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257668',4900959,'2742','413',59419.12,59580.34,0.00,0.00,161.22,124139.40,0.00,0.00,0.00),('1','179','933','257668',4900960,'2743','413',71137.98,71237.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257669',4900961,'2742','413',59580.34,59786.78,0.00,0.00,206.44,158958.80,0.00,0.00,0.00),('1','179','933','257669',4900962,'2743','413',71237.98,71337.98,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257670',4900963,'2742','413',59786.78,59841.46,0.00,0.00,54.68,42103.60,0.00,0.00,0.00),('1','179','933','257670',4900964,'2743','413',71337.98,71662.68,0.00,0.00,324.70,230537.00,0.00,0.00,0.00),('1','179','933','257671',4900965,'2742','413',59841.46,59941.09,0.00,0.00,99.63,76715.10,0.00,0.00,0.00),('1','179','933','257671',4900966,'2743','413',71662.68,71762.68,0.00,0.00,100.00,72000.00,0.00,0.00,0.00),('1','179','933','257672',4900967,'2742','413',59941.09,60126.26,0.00,0.00,185.17,142580.90,0.00,0.00,0.00),('1','179','933','257672',4900968,'2743','413',71762.68,71812.68,0.00,0.00,50.00,36000.00,0.00,0.00,0.00),('1','179','933','257673',4900969,'2742','413',60126.26,60351.00,0.00,0.00,224.74,173049.80,0.00,0.00,0.00),('1','179','933','257673',4900970,'2743','413',71812.68,71812.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257674',4900971,'2742','413',60351.00,60543.84,0.00,0.00,192.84,148486.80,0.00,0.00,0.00),('1','179','933','257674',4900972,'2743','413',71812.68,71892.68,0.00,0.00,80.00,61600.00,0.00,0.00,0.00),('1','179','933','257675',4900973,'2742','413',60543.84,60913.94,0.00,0.00,370.10,284977.00,0.00,0.00,0.00),('1','179','933','257675',4900974,'2743','413',71892.68,71947.68,0.00,0.00,55.00,39600.00,0.00,0.00,0.00),('1','179','933','257676',4900975,'2742','413',60913.94,61139.71,0.00,0.00,225.77,173842.90,0.00,0.00,0.00),('1','179','933','257676',4900976,'2743','413',71947.68,71947.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257677',4900977,'2742','413',61139.71,61377.22,0.00,0.00,237.51,182882.70,0.00,0.00,0.00),('1','179','933','257677',4900978,'2743','413',71947.68,71947.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257678',4900979,'2742','413',61377.22,61473.63,0.00,0.00,96.41,74235.70,0.00,0.00,0.00),('1','179','933','257678',4900980,'2743','413',71947.68,72030.70,0.00,0.00,83.02,63925.40,0.00,0.00,0.00),('1','179','933','257679',4900981,'2742','413',61473.63,61531.64,0.00,0.00,58.01,44667.70,0.00,0.00,0.00),('1','179','933','257679',4900982,'2743','413',72030.70,72161.48,0.00,0.00,130.78,100700.60,0.00,0.00,0.00),('1','179','933','257680',4900983,'2742','413',61531.64,61751.58,0.00,0.00,219.94,169353.80,0.00,0.00,0.00),('1','179','933','257680',4900984,'2743','413',72161.48,72161.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257681',4900985,'2742','413',61751.58,61960.37,0.00,0.00,208.79,160768.30,0.00,0.00,0.00),('1','179','933','257681',4900986,'2743','413',72161.48,72161.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','179','933','257682',4900987,'2742','413',61960.37,62287.09,0.00,0.00,326.72,251574.40,0.00,0.00,0.00),('1','179','933','257682',4900988,'2743','413',72161.48,72811.48,0.00,0.00,650.00,461500.00,0.00,0.00,0.00),('1','179','933','257683',4900989,'2742','413',62287.09,62513.15,0.00,0.00,226.06,174066.20,0.00,0.00,0.00),('1','179','933','257683',4900990,'2743','413',72811.48,72861.48,0.00,0.00,50.00,36000.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=729502 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','179','196042','413',309.50,344.00,0.00,31.00,0.00,10664.00,10664.00,570452),('1','179','196051','413',0.00,344.00,0.00,27.10,0.00,9322.40,9322.40,570474),('1','179','196262','413',0.00,344.00,0.00,14.80,0.00,5091.20,5091.20,570994),('1','179','196695','413',0.00,344.00,0.00,74.00,0.00,24356.00,24356.00,572112),('1','179','196902','413',0.00,344.00,0.00,18.30,0.00,6295.20,6295.20,572661),('1','179','197054','413',0.00,344.00,0.00,66.00,0.00,22704.00,22704.00,573049),('1','179','197304','413',0.00,344.00,0.00,52.00,0.00,17888.00,17888.00,573728),('1','179','197314','413',0.00,344.00,0.00,58.50,0.00,20124.00,20124.00,573752),('1','179','197601','413',0.00,344.00,0.00,36.70,0.00,12624.80,12624.80,574385),('1','179','197889','413',0.00,344.00,0.00,64.50,0.00,22188.00,22188.00,575161),('1','179','198120','413',0.00,344.00,0.00,72.40,0.00,24905.60,24905.60,575759),('1','179','198348','413',0.00,344.00,0.00,83.66,0.00,28779.04,28779.04,576354),('1','179','198568','413',0.00,344.00,0.00,109.80,0.00,37771.20,37771.20,576931),('1','179','198779','413',0.00,344.00,0.00,100.43,0.00,34547.92,34547.92,577442),('1','179','198984','413',0.00,344.00,0.00,178.76,0.00,61493.44,61493.44,577981),('1','179','199212','413',0.00,344.00,0.00,121.70,0.00,41864.80,41864.80,578545),('1','179','199432','413',0.00,344.00,0.00,91.26,0.00,31393.44,31393.44,579093),('1','179','199645','413',0.00,344.00,0.00,164.83,0.00,56701.52,56701.52,579633),('1','179','199866','413',0.00,344.00,0.00,180.90,0.00,62229.60,62229.60,580151),('1','179','200089','413',0.00,344.00,0.00,153.70,0.00,52872.80,52872.80,580746),('1','179','200295','413',0.00,344.00,0.00,236.84,0.00,81472.96,81472.96,581273),('1','179','200489','413',0.00,344.00,0.00,341.91,0.00,117617.04,117617.04,581785),('1','179','200791','413',0.00,344.00,0.00,138.00,0.00,47472.00,47472.00,582563),('1','179','200920','413',0.00,344.00,0.00,283.27,0.00,97444.88,97444.88,582891),('1','179','201108','413',0.00,344.00,0.00,259.11,0.00,89133.84,89133.84,583375),('1','179','201326','413',0.00,344.00,0.00,78.50,0.00,27004.00,27004.00,583928),('1','179','202674','413',0.00,344.00,0.00,226.21,0.00,77816.24,77816.24,587428),('1','179','202868','413',0.00,344.00,0.00,204.70,0.00,70416.80,70416.80,587929),('1','179','203195','413',0.00,344.00,0.00,132.66,0.00,45635.04,45635.04,588793),('1','179','203329','413',0.00,344.00,0.00,159.07,0.00,54720.08,54720.08,589138),('1','179','203651','413',0.00,344.00,0.00,0.00,0.00,0.00,0.00,589973),('1','179','203658','413',0.00,344.00,0.00,79.26,0.00,28533.60,28533.60,589990),('1','179','203898','413',0.00,360.00,0.00,34.00,0.00,12240.00,12240.00,590617),('1','179','203970','413',0.00,360.00,0.00,91.68,0.00,33004.80,33004.80,590782),('1','179','204194','413',0.00,360.00,0.00,223.64,0.00,80510.40,80510.40,591376),('1','179','204482','413',0.00,360.00,0.00,56.12,0.00,20203.20,20203.20,592120),('1','179','204638','413',0.00,360.00,0.00,140.31,0.00,50511.60,50511.60,592504),('1','179','204833','413',0.00,360.00,0.00,182.65,0.00,65754.00,65754.00,592983),('1','179','205043','413',0.00,360.00,0.00,385.93,0.00,138934.80,138934.80,593517),('1','179','205233','413',0.00,360.00,0.00,103.45,0.00,37242.00,37242.00,594017),('1','179','205477','413',0.00,360.00,0.00,211.48,0.00,76132.80,76132.80,594631),('1','179','205740','413',0.00,360.00,0.00,241.91,0.00,87087.60,87087.60,595319),('1','179','205948','413',0.00,360.00,0.00,194.00,0.00,69840.00,69840.00,595860),('1','179','206163','413',0.00,360.00,0.00,159.52,0.00,57427.20,57427.20,596406),('1','179','206365','413',0.00,360.00,0.00,116.86,0.00,42069.60,42069.60,596922),('1','179','206571','413',0.00,360.00,0.00,201.80,0.00,72648.00,72648.00,597449),('1','179','206796','413',0.00,360.00,0.00,260.51,0.00,93783.60,93783.60,598031),('1','179','207023','413',0.00,360.00,0.00,238.74,0.00,85946.40,85946.40,598621),('1','179','207265','413',0.00,360.00,0.00,186.04,0.00,66974.40,66974.40,599236),('1','179','207516','413',0.00,360.00,0.00,234.22,0.00,84319.20,84319.20,599888),('1','179','207714','413',380.00,380.00,0.00,282.92,107509.60,107509.60,0.00,600386),('1','179','207905','413',380.00,380.00,0.00,339.32,128941.60,128941.60,0.00,600876),('1','179','208141','413',380.00,380.00,0.00,288.07,109466.60,109466.60,0.00,601479),('1','179','208412','413',380.00,380.00,0.00,144.34,54849.20,54849.20,0.00,602177),('1','179','210520','413',420.00,420.00,0.00,257.43,108120.60,108120.60,0.00,607604),('1','179','210726','413',420.00,420.00,0.00,221.91,93202.20,93202.20,0.00,608149),('1','179','210978','413',420.00,420.00,0.00,249.82,104924.40,104924.40,0.00,608783),('1','179','211170','413',420.00,420.00,0.00,339.11,124003.80,143654.36,19650.56,609284),('1','179','211408','413',360.00,424.00,0.00,514.89,185360.40,218313.36,32952.96,609904),('1','179','211609','413',360.00,424.00,0.00,109.98,39592.80,46631.52,7038.72,610432),('1','179','211788','413',360.00,424.00,0.00,126.58,45568.80,53669.92,8101.12,610871),('1','179','211997','413',360.00,424.00,0.00,222.21,79995.60,94217.04,14221.44,611420),('1','179','212238','413',360.00,424.00,0.00,206.98,74512.80,87759.52,13246.72,612048),('1','179','212462','413',360.00,424.00,0.00,259.01,93243.60,109820.24,16576.64,612641),('1','179','212674','413',360.00,424.00,0.00,227.58,81928.80,96493.92,14565.12,613205),('1','179','212907','413',360.00,424.00,0.00,196.93,70894.80,83498.32,12603.52,613807),('1','179','213163','413',360.00,424.00,0.00,257.91,92847.60,109353.84,16506.24,614475),('1','179','213403','413',360.00,424.00,0.00,241.24,86846.40,102285.76,15439.36,615088),('1','179','213638','413',360.00,424.00,0.00,329.24,118526.40,139597.76,21071.36,615725),('1','179','213885','413',360.00,424.00,0.00,169.12,60883.20,71706.88,10823.68,616375),('1','179','214108','413',360.00,424.00,0.00,261.95,94302.00,111066.80,16764.80,616944),('1','179','214350','413',360.00,424.00,0.00,242.39,87260.40,102773.36,15512.96,617575),('1','179','214525','413',360.00,424.00,0.00,24.09,8672.40,10214.16,1541.76,618030),('1','179','214527','413',360.00,424.00,0.00,263.92,95011.20,111902.08,16890.88,618034),('1','179','214778','413',360.00,424.00,0.00,0.00,0.00,0.00,0.00,618688),('1','179','214866','413',424.00,424.00,0.00,354.87,139172.34,150464.88,11292.54,618921),('1','179','215008','413',382.00,424.00,0.00,237.23,90621.86,100585.52,9963.66,619290),('1','179','215236','413',382.00,424.00,0.00,236.19,90224.58,100144.56,9919.98,619866),('1','179','215456','413',382.00,424.00,0.00,262.70,100351.40,111384.80,11033.40,620428),('1','179','215699','413',382.00,424.00,0.00,188.98,72190.36,80127.52,7937.16,621061),('1','179','215916','413',382.00,424.00,0.00,282.69,107987.58,119860.56,11872.98,621618),('1','179','216109','413',382.00,424.00,0.00,173.52,66284.64,73572.48,7287.84,622127),('1','179','216340','413',382.00,424.00,0.00,236.96,90518.72,100471.04,9952.32,622716),('1','179','216566','413',382.00,424.00,0.00,313.03,119577.46,132724.72,13147.26,623317),('1','179','216818','413',382.00,424.00,0.00,209.84,80158.88,88972.16,8813.28,623981),('1','179','217030','413',480.00,480.00,0.00,225.90,108432.00,108432.00,0.00,624537),('1','179','217288','413',480.00,480.00,0.00,245.91,118036.80,118036.80,0.00,625213),('1','179','217511','413',480.00,480.00,0.00,279.79,134299.20,134299.20,0.00,625799),('1','179','217715','413',480.00,480.00,0.00,196.84,94483.20,94483.20,0.00,626326),('1','179','217995','413',480.00,480.00,0.00,212.76,102124.80,102124.80,0.00,627064),('1','179','218242','413',480.00,480.00,0.00,255.05,122424.00,122424.00,0.00,627715),('1','179','218464','413',480.00,480.00,0.00,187.90,90192.00,90192.00,0.00,628295),('1','179','218695','413',480.00,480.00,0.00,138.18,66326.40,66326.40,0.00,628894),('1','179','219378','413',425.00,480.00,0.00,0.00,0.00,0.00,0.00,630679),('1','179','219390','413',425.00,480.00,0.00,317.10,134767.50,152208.00,17440.50,630711),('1','179','219408','413',425.00,480.00,0.00,229.64,97597.00,110227.20,12630.20,630761),('1','179','219642','413',425.00,480.00,0.00,150.03,63762.75,72014.40,8251.65,631375),('1','179','219837','413',425.00,480.00,0.00,140.59,59750.75,67483.20,7732.45,631884),('1','179','220078','413',425.00,480.00,0.00,249.34,105969.50,119683.20,13713.70,632529),('1','179','220294','413',425.00,480.00,0.00,408.00,173400.00,195840.00,22440.00,633095),('1','179','220494','413',425.00,480.00,0.00,350.74,149064.50,168355.20,19290.70,633625),('1','179','220700','413',425.00,480.00,0.00,244.72,104006.00,117465.60,13459.60,634158),('1','179','220984','413',425.00,480.00,0.00,308.52,131121.00,148089.60,16968.60,634907),('1','179','221240','413',425.00,480.00,0.00,224.22,95293.50,107625.60,12332.10,635567),('1','179','221392','413',425.00,480.00,0.00,306.76,130373.00,147244.80,16871.80,635965),('1','179','221635','413',425.00,480.00,0.00,337.27,143339.75,161889.60,18549.85,636593),('1','179','221840','413',425.00,480.00,0.00,269.38,114486.50,129302.40,14815.90,637129),('1','179','222067','413',425.00,480.00,0.00,236.05,100321.25,113304.00,12982.75,637724),('1','179','222278','413',425.00,480.00,0.00,488.52,207621.00,234489.60,26868.60,638261),('1','179','222516','413',425.00,480.00,0.00,287.25,122081.25,137880.00,15798.75,638865),('1','179','222751','413',425.00,480.00,0.00,297.42,126403.50,142761.60,16358.10,639491),('1','179','222952','413',425.00,480.00,0.00,123.77,52602.25,59409.60,6807.35,640040),('1','179','223132','413',425.00,480.00,0.00,2.08,884.00,998.40,114.40,640529),('1','179','223289','413',425.00,480.00,0.00,434.93,185715.11,208766.40,23051.29,640881),('1','179','223425','413',427.00,480.00,0.00,218.57,93329.39,104913.60,11584.21,641226),('1','179','223649','413',427.00,480.00,0.00,271.75,116037.25,130440.00,14402.75,641795),('1','179','223881','413',427.00,480.00,0.00,250.96,107159.92,120460.80,13300.88,642395),('1','179','224087','413',427.00,480.00,0.00,219.84,93871.68,105523.20,11651.52,642929),('1','179','224318','413',427.00,480.00,0.00,285.75,154305.00,154305.00,0.00,643525),('1','179','224545','413',540.00,540.00,0.00,214.42,115786.80,115786.80,0.00,644126),('1','179','224796','413',540.00,540.00,0.00,319.31,172427.40,172427.40,0.00,644758),('1','179','225072','413',540.00,540.00,0.00,214.40,115776.00,115776.00,0.00,645474),('1','179','225298','413',540.00,540.00,0.00,301.81,162977.40,162977.40,0.00,646047),('1','179','225497','413',540.00,540.00,0.00,340.45,183843.00,183843.00,0.00,646572),('1','179','225712','413',540.00,540.00,0.00,281.59,152058.60,152058.60,0.00,647128),('1','179','225996','413',540.00,540.00,0.00,232.36,125474.40,125474.40,0.00,647871),('1','179','226241','413',540.00,540.00,0.00,227.22,122698.80,122698.80,0.00,648514),('1','179','226484','413',540.00,540.00,0.00,222.10,119934.00,119934.00,0.00,649127),('1','179','226748','413',540.00,540.00,0.00,276.84,149493.60,149493.60,0.00,649811),('1','179','226980','413',540.00,540.00,0.00,314.95,170073.00,170073.00,0.00,650427),('1','179','227230','413',540.00,540.00,0.00,235.20,127008.00,127008.00,0.00,651064),('1','179','227391','413',540.00,540.00,0.00,127.10,68634.00,68634.00,0.00,651478),('1','179','227704','413',540.00,540.00,0.00,0.00,0.00,0.00,0.00,652289),('1','179','227730','413',427.00,540.00,0.00,432.90,208657.80,233766.00,25108.20,652360),('1','179','228046','413',482.00,540.00,0.00,263.74,127122.68,142419.60,15296.92,653199),('1','179','228134','413',482.00,540.00,0.00,323.73,156037.86,174814.20,18776.34,653419),('1','179','228374','413',482.00,540.00,0.00,472.23,259456.80,263168.80,3712.00,654036),('1','179','228538','413',560.00,560.00,0.00,405.46,227057.60,227057.60,0.00,654451),('1','179','228764','413',560.00,560.00,0.00,494.83,277104.80,277104.80,0.00,655033),('1','179','228957','413',560.00,560.00,0.00,385.43,215840.80,215840.80,0.00,655519),('1','179','229186','413',560.00,560.00,0.00,411.76,230585.60,230585.60,0.00,656128),('1','179','229440','413',560.00,560.00,0.00,262.88,153521.92,153521.92,0.00,656779),('1','179','229671','413',584.00,584.00,0.00,382.68,223485.12,223485.12,0.00,657373),('1','179','229898','413',584.00,584.00,0.00,278.50,162644.00,162644.00,0.00,657952),('1','179','230100','413',584.00,584.00,0.00,334.77,195505.68,195505.68,0.00,658472),('1','179','230294','413',584.00,584.00,0.00,195.05,113909.20,113909.20,0.00,658974),('1','179','230802','413',584.00,584.00,0.00,0.00,0.00,0.00,0.00,660282),('1','179','230803','413',584.00,584.00,0.00,0.00,0.00,0.00,0.00,660283),('1','179','230892','413',522.00,584.00,0.00,378.23,197436.06,220886.32,23450.26,660525),('1','179','231074','413',522.00,584.00,0.00,347.20,181238.40,202764.80,21526.40,661018),('1','179','231394','413',522.00,584.00,0.00,240.10,125332.20,140218.40,14886.20,661871),('1','179','231662','413',522.00,584.00,0.00,317.05,165500.10,185157.20,19657.10,662572),('1','179','231906','413',522.00,584.00,0.00,252.09,131590.98,147220.56,15629.58,663240),('1','179','232432','413',522.00,584.00,0.00,202.77,105845.94,118417.68,12571.74,664618),('1','179','232609','413',522.00,584.00,0.00,350.11,182757.42,204464.24,21706.82,665083),('1','179','232872','413',522.00,584.00,0.00,217.42,113493.24,126973.28,13480.04,665778),('1','179','233121','413',522.00,584.00,0.00,303.31,158327.82,177133.04,18805.22,666426),('1','179','233414','413',624.00,624.00,0.00,306.95,191536.80,191536.80,0.00,667195),('1','179','233625','413',624.00,624.00,0.00,521.09,325160.16,325160.16,0.00,667746),('1','179','233856','413',624.00,624.00,0.00,530.09,330776.16,330776.16,0.00,668353),('1','179','234083','413',624.00,624.00,0.00,236.98,147875.52,147875.52,0.00,668954),('1','179','234346','413',624.00,624.00,0.00,257.34,160580.16,160580.16,0.00,669648),('1','179','234595','413',624.00,624.00,0.00,177.52,110772.48,110772.48,0.00,670312),('1','179','235238','413',624.00,624.00,0.00,0.00,0.00,0.00,0.00,672036),('1','179','235245','413',572.00,624.00,0.00,170.82,97709.04,106591.68,8882.64,672050),('1','179','235327','413',572.00,624.00,0.00,264.73,151425.56,165191.52,13765.96,672251),('1','179','235561','413',572.00,624.00,0.00,234.11,133910.92,146084.64,12173.72,672850),('1','179','235782','413',572.00,624.00,0.00,363.12,207704.64,226586.88,18882.24,673420),('1','179','236054','413',572.00,624.00,0.00,352.64,201710.08,220047.36,18337.28,674142),('1','179','236251','413',572.00,624.00,0.00,313.60,179379.20,195686.40,16307.20,674660),('1','179','236536','413',640.00,640.00,0.00,430.95,275808.00,275808.00,0.00,675411),('1','179','236757','413',640.00,640.00,0.00,299.77,191852.80,191852.80,0.00,675978),('1','179','236976','413',640.00,640.00,0.00,311.85,199584.00,199584.00,0.00,676553),('1','179','237193','413',640.00,640.00,0.00,352.52,225612.80,225612.80,0.00,677098),('1','179','237400','413',640.00,640.00,0.00,316.78,202739.20,202739.20,0.00,677641),('1','179','237651','413',572.00,664.00,0.00,305.29,174625.88,196727.68,22101.80,678286),('1','179','237889','413',572.00,640.00,0.00,303.81,173779.32,194438.40,20659.08,678912),('1','179','238139','413',572.00,640.00,0.00,256.13,146506.36,163923.20,17416.84,679562),('1','179','238385','413',572.00,640.00,0.00,259.11,148210.92,165830.40,17619.48,680190),('1','179','241075','413',656.00,656.00,0.00,178.28,116951.68,116951.68,0.00,687173),('1','179','241253','413',656.00,656.00,0.00,229.56,143757.12,150591.36,6834.24,687631),('1','179','241430','413',602.00,656.00,0.00,0.00,0.00,0.00,0.00,688126),('1','179','241516','413',602.00,656.00,0.00,429.04,258282.08,281450.24,23168.16,688332),('1','179','241772','413',602.00,656.00,0.00,399.10,240258.20,261809.60,21551.40,689018),('1','179','241990','413',602.00,656.00,0.00,234.04,140892.08,153530.24,12638.16,689584),('1','179','242233','413',602.00,656.00,0.00,392.53,236303.06,257499.68,21196.62,690211),('1','179','242480','413',602.00,656.00,0.00,271.19,163256.38,177900.64,14644.26,690838),('1','179','242704','413',602.00,656.00,0.00,281.34,169366.68,184559.04,15192.36,691424),('1','179','242943','413',602.00,656.00,0.00,297.85,179305.70,195389.60,16083.90,692048),('1','179','243161','413',602.00,656.00,0.00,393.69,237001.38,258260.64,21259.26,692616),('1','179','243394','413',602.00,656.00,0.00,310.19,186734.38,203484.64,16750.26,693234),('1','179','243624','413',602.00,656.00,0.00,290.24,174724.48,190397.44,15672.96,693826),('1','179','243852','413',602.00,656.00,0.00,416.53,250751.06,273243.68,22492.62,694419),('1','179','244091','413',602.00,656.00,0.00,265.92,160083.84,174443.52,14359.68,695029),('1','179','244324','413',602.00,656.00,0.00,266.19,160246.38,174620.64,14374.26,695640),('1','179','244556','413',602.00,656.00,0.00,82.62,49737.24,54198.72,4461.48,696237),('1','179','244903','413',602.00,656.00,0.00,97.48,58622.96,63946.88,5323.92,697161),('1','179','245014','413',624.00,624.00,0.00,202.17,126154.08,126154.08,0.00,697427),('1','179','245241','413',624.00,624.00,0.00,196.48,122603.52,122603.52,0.00,698020),('1','179','245452','413',624.00,624.00,0.00,252.85,157778.40,157778.40,0.00,698563),('1','179','245702','413',624.00,624.00,0.00,249.82,155887.68,155887.68,0.00,699202),('1','179','245972','413',0.00,616.00,0.00,278.71,0.00,171685.36,171685.36,699919),('1','179','246217','413',0.00,616.00,0.00,303.48,0.00,186943.68,186943.68,700537),('1','179','246481','413',0.00,616.00,0.00,266.80,0.00,164348.80,164348.80,701244),('1','179','246731','413',0.00,616.00,0.00,195.38,0.00,120354.08,120354.08,701894),('1','179','246975','413',0.00,616.00,0.00,272.27,0.00,167718.32,167718.32,702518),('1','179','247203','413',0.00,616.00,0.00,299.60,0.00,184553.60,184553.60,703112),('1','179','247439','413',0.00,616.00,0.00,298.60,0.00,183937.60,183937.60,703708),('1','179','247701','413',0.00,616.00,0.00,174.57,0.00,107535.12,107535.12,704402),('1','179','247940','413',0.00,616.00,0.00,303.57,0.00,186999.12,186999.12,705008),('1','179','248189','413',0.00,616.00,0.00,253.25,0.00,156002.00,156002.00,705664),('1','179','248432','413',0.00,616.00,0.00,361.05,0.00,222406.80,222406.80,706283),('1','179','248677','413',0.00,616.00,0.00,361.13,0.00,222456.08,222456.08,706907),('1','179','248912','413',0.00,616.00,0.00,287.73,0.00,172638.00,172638.00,707517),('1','179','249140','413',0.00,600.00,0.00,0.00,0.00,0.00,0.00,708091),('1','179','249143','413',0.00,600.00,0.00,305.94,0.00,183564.00,183564.00,708096),('1','179','249382','413',0.00,600.00,0.00,23.85,0.00,14310.00,14310.00,708710),('1','179','249505','413',0.00,600.00,0.00,121.00,64130.00,72600.00,8470.00,709045),('1','179','249625','413',530.00,600.00,0.00,284.40,150732.00,170640.00,19908.00,709336),('1','179','249881','413',530.00,600.00,0.00,254.61,134943.30,152766.00,17822.70,709999),('1','179','250133','413',530.00,600.00,0.00,421.45,223368.50,252870.00,29501.50,710638),('1','179','250365','413',530.00,600.00,0.00,293.76,155692.80,176256.00,20563.20,711226),('1','179','250584','413',530.00,600.00,0.00,317.67,168365.10,190602.00,22236.90,711785),('1','179','250833','413',530.00,600.00,0.00,255.32,135319.60,153192.00,17872.40,712434),('1','179','251060','413',530.00,600.00,0.00,356.70,189051.00,214020.00,24969.00,713022),('1','179','251301','413',530.00,600.00,0.00,251.66,133379.80,150996.00,17616.20,713649),('1','179','251553','413',530.00,600.00,0.00,188.33,99814.90,112998.00,13183.10,714312),('1','179','251802','413',530.00,600.00,0.00,309.27,163913.10,185562.00,21648.90,714960),('1','179','252022','413',530.00,600.00,0.00,412.75,218757.50,247650.00,28892.50,715538),('1','179','252260','413',530.00,600.00,0.00,354.58,187927.40,212748.00,24820.60,716165),('1','179','252509','413',530.00,600.00,0.00,389.71,206546.30,233826.00,27279.70,716797),('1','179','252747','413',530.00,600.00,0.00,420.92,223087.60,252552.00,29464.40,717420),('1','179','253006','413',530.00,600.00,0.00,277.61,147133.30,166566.00,19432.70,718089),('1','179','253246','413',530.00,600.00,0.00,134.01,71025.30,80406.00,9380.70,718724),('1','179','253508','413',530.00,600.00,0.00,281.01,148092.27,168606.00,20513.73,719398),('1','179','253741','413',527.00,600.00,0.00,280.67,147913.09,168402.00,20488.91,720002),('1','179','253991','413',527.00,600.00,0.00,327.93,172819.11,196758.00,23938.89,720656),('1','179','254242','413',527.00,600.00,0.00,415.51,218973.77,249306.00,30332.23,721304),('1','179','254479','413',527.00,600.00,0.00,295.21,155575.67,177126.00,21550.33,721919),('1','179','254743','413',527.00,600.00,0.00,426.72,224881.44,256032.00,31150.56,722581),('1','179','254984','413',527.00,600.00,0.00,352.97,186015.19,211782.00,25766.81,723196),('1','179','255226','413',527.00,600.00,0.00,254.40,134068.80,152640.00,18571.20,723817),('1','179','255489','413',527.00,600.00,0.00,305.85,161182.95,183510.00,22327.05,724474),('1','179','255733','413',527.00,600.00,0.00,390.86,205983.22,234516.00,28532.78,725089),('1','179','255990','413',527.00,600.00,0.00,283.33,149314.91,169998.00,20683.09,725741),('1','179','256239','413',527.00,600.00,0.00,333.28,175638.56,199968.00,24329.44,726343),('1','179','256519','413',527.00,600.00,0.00,284.91,150147.57,170946.00,20798.43,727082),('1','179','256756','413',527.00,600.00,0.00,294.10,154990.70,176460.00,21469.30,727683),('1','179','256999','413',527.00,600.00,0.00,388.07,204512.89,232842.00,28329.11,728324),('1','179','257271','413',527.00,600.00,0.00,67.67,35662.09,40602.00,4939.91,729039),('1','179','257303','413',527.00,600.00,0.00,0.00,0.00,0.00,0.00,729118),('1','179','257304','413',527.00,600.00,0.00,0.00,0.00,0.00,0.00,729119),('1','179','257307','413',527.00,600.00,0.00,0.00,0.00,0.00,0.00,729125),('1','179','257308','413',527.00,600.00,0.00,303.09,158272.43,181854.00,23581.57,729126),('1','179','257309','413',517.00,600.00,0.00,361.28,186781.76,216768.00,29986.24,729127),('1','179','257310','413',517.00,600.00,0.00,390.99,202141.83,234594.00,32452.17,729128),('1','179','257311','413',517.00,600.00,0.00,343.82,177754.94,206292.00,28537.06,729129),('1','179','257312','413',517.00,600.00,0.00,362.16,187236.72,217296.00,30059.28,729130),('1','179','257313','413',517.00,600.00,0.00,345.27,178504.59,207162.00,28657.41,729131),('1','179','257314','413',517.00,600.00,0.00,301.84,156051.28,181104.00,25052.72,729132),('1','179','257315','413',517.00,600.00,0.00,304.16,157250.72,182496.00,25245.28,729133),('1','179','257316','413',517.00,600.00,0.00,271.75,140494.75,163050.00,22555.25,729134),('1','179','257317','413',517.00,600.00,0.00,267.67,138385.39,160602.00,22216.61,729135),('1','179','257318','413',517.00,600.00,0.00,116.47,60214.99,69882.00,9667.01,729136),('1','179','257319','413',517.00,600.00,0.00,459.09,237349.53,275454.00,38104.47,729137),('1','179','257320','413',517.00,600.00,0.00,381.03,0.00,216425.04,216425.04,729138),('1','179','257321','413',0.00,568.00,0.00,315.24,0.00,179056.32,179056.32,729139),('1','179','257322','413',0.00,568.00,0.00,297.28,0.00,168855.04,168855.04,729140),('1','179','257323','413',0.00,568.00,0.00,211.96,0.00,120393.28,120393.28,729141),('1','179','257324','413',0.00,568.00,0.00,261.35,95221.06,148446.80,53225.74,729142),('1','179','257325','413',517.00,568.00,0.00,221.54,114536.18,125834.72,11298.54,729143),('1','179','257326','413',517.00,568.00,0.00,367.56,190028.52,208774.08,18745.56,729144),('1','179','257327','413',517.00,568.00,0.00,228.69,118232.73,129895.92,11663.19,729145),('1','179','257328','413',517.00,568.00,0.00,280.04,144780.68,159062.72,14282.04,729146),('1','179','257329','413',517.00,568.00,0.00,447.59,231404.03,254231.12,22827.09,729147),('1','179','257330','413',517.00,568.00,0.00,390.82,202053.94,221985.76,19931.82,729148),('1','179','257331','413',517.00,568.00,0.00,413.02,213531.34,234595.36,21064.02,729149),('1','179','257332','413',517.00,568.00,0.00,319.17,165010.89,181288.56,16277.67,729150),('1','179','257333','413',517.00,568.00,0.00,331.11,171183.87,188070.48,16886.61,729151),('1','179','257334','413',517.00,568.00,0.00,258.49,133639.33,146822.32,13182.99,729152),('1','179','257335','413',517.00,568.00,0.00,470.68,243341.56,267346.24,24004.68,729153),('1','179','257336','413',517.00,568.00,0.00,348.94,180401.98,198197.92,17795.94,729154),('1','179','257337','413',517.00,568.00,0.00,463.25,239500.25,263126.00,23625.75,729155),('1','179','257338','413',517.00,568.00,0.00,297.46,153786.82,168957.28,15170.46,729156),('1','179','257339','413',517.00,568.00,0.00,268.95,73911.24,180086.00,106174.76,729157),('1','179','257340','413',0.00,680.00,0.00,247.08,0.00,168014.40,168014.40,729158),('1','179','257341','413',0.00,680.00,0.00,382.11,0.00,259834.80,259834.80,729159),('1','179','257342','413',0.00,680.00,0.00,293.50,0.00,199580.00,199580.00,729160),('1','179','257343','413',0.00,680.00,0.00,191.56,0.00,130260.80,130260.80,729161),('1','179','257344','413',0.00,680.00,0.00,229.20,0.00,155856.00,155856.00,729162),('1','179','257345','413',0.00,680.00,0.00,286.93,0.00,195112.40,195112.40,729163),('1','179','257346','413',0.00,680.00,0.00,166.77,0.00,113403.60,113403.60,729164),('1','179','257347','413',0.00,680.00,0.00,290.92,0.00,197825.60,197825.60,729165),('1','179','257348','413',0.00,680.00,0.00,245.70,0.00,167076.00,167076.00,729166),('1','179','257349','413',0.00,680.00,0.00,191.19,0.00,130009.20,130009.20,729167),('1','179','257350','413',0.00,680.00,0.00,8.82,0.00,5997.60,5997.60,729168),('1','179','257351','413',0.00,680.00,0.00,238.91,0.00,162458.80,162458.80,729169),('1','179','257352','413',0.00,680.00,0.00,431.10,0.00,293148.00,293148.00,729170),('1','179','257353','413',0.00,680.00,0.00,541.54,352001.00,352001.00,0.00,729171),('1','179','257354','413',650.00,650.00,0.00,947.84,616096.00,616096.00,0.00,729172),('1','179','257355','413',650.00,650.00,0.00,133.57,86820.50,86820.50,0.00,729173),('1','179','257356','413',650.00,650.00,0.00,260.12,169078.00,169078.00,0.00,729174),('1','179','257357','413',650.00,650.00,0.00,337.34,209312.34,219271.00,9958.66,729175),('1','179','257358','413',612.00,650.00,0.00,420.74,257492.88,273481.00,15988.12,729176),('1','179','257359','413',612.00,650.00,0.00,299.79,183471.48,194863.50,11392.02,729177),('1','179','257360','413',612.00,650.00,0.00,460.29,281697.48,299188.50,17491.02,729178),('1','179','257361','413',612.00,650.00,0.00,262.69,160766.28,170748.50,9982.22,729179),('1','179','257362','413',612.00,650.00,0.00,316.90,193942.80,205985.00,12042.20,729180),('1','179','257363','413',612.00,650.00,0.00,331.60,202939.20,215540.00,12600.80,729181),('1','179','257364','413',612.00,650.00,0.00,271.52,166170.24,176488.00,10317.76,729182),('1','179','257365','413',612.00,650.00,0.00,281.90,172522.80,183235.00,10712.20,729183),('1','179','257366','413',612.00,650.00,0.00,266.25,162945.00,173062.50,10117.50,729184),('1','179','257367','413',612.00,650.00,0.00,250.14,153085.68,162591.00,9505.32,729185),('1','179','257368','413',612.00,650.00,0.00,348.50,213282.00,226525.00,13243.00,729186),('1','179','257369','413',612.00,650.00,0.00,135.85,83140.20,88302.50,5162.30,729187),('1','179','257370','413',612.00,650.00,0.00,291.34,178300.08,189371.00,11070.92,729188),('1','179','257371','413',612.00,650.00,0.00,263.17,161060.04,171060.50,10000.46,729189),('1','179','257372','413',612.00,650.00,0.00,155.67,95270.04,101185.50,5915.46,729190),('1','179','257373','413',612.00,650.00,0.00,65.28,39951.36,42432.00,2480.64,729191),('1','179','257374','413',612.00,650.00,0.00,251.23,153752.76,163299.50,9546.74,729192),('1','179','257375','413',602.00,650.00,0.00,278.40,167596.80,180960.00,13363.20,729193),('1','179','257376','413',602.00,600.00,0.00,0.00,0.00,0.00,0.00,729194),('1','179','257377','413',602.00,568.00,0.00,0.00,0.00,0.00,0.00,729195),('1','179','257378','413',602.00,650.00,0.00,271.32,163334.64,176358.00,13023.36,729196),('1','179','257379','413',602.00,650.00,0.00,361.12,217394.24,234728.00,17333.76,729197),('1','179','257380','413',602.00,650.00,0.00,309.01,186024.02,200856.50,14832.48,729198),('1','179','257381','413',602.00,650.00,0.00,311.22,187354.44,202293.00,14938.56,729199),('1','179','257382','413',602.00,650.00,0.00,260.77,156983.54,169500.50,12516.96,729200),('1','179','257383','413',602.00,650.00,0.00,281.94,169727.88,183261.00,13533.12,729201),('1','179','257384','413',602.00,650.00,0.00,325.97,196233.94,211880.50,15646.56,729202),('1','179','257385','413',602.00,650.00,0.00,305.35,183820.70,198477.50,14656.80,729203),('1','179','257386','413',602.00,650.00,0.00,441.06,265518.12,286689.00,21170.88,729204),('1','179','257387','413',602.00,650.00,0.00,354.36,213324.72,230334.00,17009.28,729205),('1','179','257388','413',602.00,650.00,0.00,28.16,16952.32,18304.00,1351.68,729206),('1','179','257389','413',602.00,650.00,0.00,41.00,24682.00,26650.00,1968.00,729207),('1','179','257390','413',602.00,650.00,0.00,90.67,54583.34,58935.50,4352.16,729208),('1','179','257391','413',602.00,650.00,0.00,154.12,92780.24,100178.00,7397.76,729209),('1','179','257392','413',602.00,650.00,0.00,322.25,193994.50,209462.50,15468.00,729210),('1','179','257393','413',602.00,650.00,0.00,201.74,121447.48,131131.00,9683.52,729211),('1','179','257394','413',602.00,650.00,0.00,316.12,190304.24,205478.00,15173.76,729212),('1','179','257395','413',602.00,650.00,0.00,0.00,0.00,0.00,0.00,729213),('1','179','257396','413',602.00,650.00,0.00,0.00,0.00,0.00,0.00,729214),('1','179','257397','413',602.00,650.00,0.00,0.00,0.00,0.00,0.00,729215),('1','179','257398','413',602.00,650.00,0.00,236.53,142391.06,153744.50,11353.44,729216),('1','179','257399','413',602.00,650.00,0.00,289.71,174405.42,188311.50,13906.08,729217),('1','179','257400','413',602.00,650.00,0.00,243.50,146587.00,155275.00,8688.00,729218),('1','179','257401','413',0.00,696.00,0.00,254.52,0.00,177145.92,177145.92,729219),('1','179','257402','413',0.00,696.00,0.00,268.07,0.00,184816.72,184816.72,729220),('1','179','257403','413',0.00,696.00,0.00,157.01,0.00,108178.96,108178.96,729221),('1','179','257404','413',0.00,696.00,0.00,213.35,0.00,148491.60,148491.60,729222),('1','179','257405','413',0.00,696.00,0.00,220.15,0.00,153224.40,153224.40,729223),('1','179','257406','413',0.00,696.00,0.00,194.81,0.00,133387.76,133387.76,729224),('1','179','257407','413',0.00,696.00,0.00,274.25,0.00,188678.00,188678.00,729225),('1','179','257408','413',0.00,696.00,0.00,387.47,0.00,266269.12,266269.12,729226),('1','179','257409','413',0.00,696.00,0.00,210.00,0.00,146160.00,146160.00,729227),('1','179','257410','413',740.00,740.00,0.00,328.46,243060.40,243060.40,0.00,729228),('1','179','257411','413',740.00,740.00,0.00,284.98,210885.20,208685.20,-2200.00,729229),('1','179','257412','413',740.00,740.00,0.00,191.85,141969.00,141969.00,0.00,729230),('1','179','257413','413',740.00,740.00,0.00,247.45,183113.00,180913.00,-2200.00,729231),('1','179','257414','413',740.00,740.00,0.00,301.46,223080.40,223080.40,0.00,729232),('1','179','257415','413',740.00,740.00,0.00,491.17,363465.80,356425.80,-7040.00,729233),('1','179','257416','413',740.00,740.00,0.00,215.80,159692.00,159692.00,0.00,729234),('1','179','257417','413',740.00,740.00,0.00,15.50,11470.00,11470.00,0.00,729235),('1','179','257418','413',740.00,740.00,0.00,0.00,0.00,0.00,0.00,729236),('1','179','257419','413',740.00,740.00,0.00,174.47,115499.14,127787.80,12288.66,729237),('1','179','257420','413',662.00,740.00,0.00,273.08,180778.96,196051.20,15272.24,729238),('1','179','257421','413',662.00,740.00,0.00,185.90,123065.80,135366.00,12300.20,729239),('1','179','257422','413',662.00,740.00,0.00,381.19,252347.78,274160.60,21812.82,729240),('1','179','257423','413',662.00,740.00,0.00,283.82,187888.84,210026.80,22137.96,729241),('1','179','257424','413',0.00,770.00,0.00,125.47,0.00,96611.90,96611.90,729242),('1','179','257425','413',0.00,770.00,0.00,372.15,0.00,279055.50,279055.50,729243),('1','179','257426','413',0.00,770.00,0.00,184.04,0.00,141710.80,141710.80,729244),('1','179','257427','413',0.00,770.00,0.00,390.06,0.00,293846.20,293846.20,729245),('1','179','257428','413',0.00,770.00,0.00,176.30,0.00,135751.00,135751.00,729246),('1','179','257429','413',0.00,770.00,0.00,211.66,0.00,162978.20,162978.20,729247),('1','179','257430','413',0.00,770.00,0.00,259.00,0.00,199430.00,199430.00,729248),('1','179','257431','413',0.00,770.00,0.00,279.97,0.00,215576.90,215576.90,729249),('1','179','257432','413',0.00,770.00,0.00,435.05,0.00,324988.50,324988.50,729250),('1','179','257433','413',0.00,770.00,0.00,272.40,0.00,204748.00,204748.00,729251),('1','179','257434','413',0.00,770.00,0.00,228.28,0.00,175775.60,175775.60,729252),('1','179','257435','413',0.00,770.00,0.00,151.44,0.00,116608.80,116608.80,729253),('1','179','257436','413',0.00,770.00,0.00,197.08,0.00,151751.60,151751.60,729254),('1','179','257437','413',0.00,770.00,0.00,101.66,0.00,78278.20,78278.20,729255),('1','179','257438','413',0.00,770.00,0.00,164.86,0.00,119299.20,119299.20,729256),('1','179','257439','413',0.00,770.00,0.00,0.00,0.00,0.00,0.00,729257),('1','179','257440','413',0.00,770.00,0.00,146.27,101218.84,112627.90,11409.06,729258),('1','179','257441','413',692.00,770.00,0.00,324.15,224311.80,242095.50,17783.70,729259),('1','179','257442','413',692.00,770.00,0.00,361.06,249853.52,275016.20,25162.68,729260),('1','179','257443','413',692.00,770.00,0.00,242.31,167678.52,186578.70,18900.18,729261),('1','179','257444','413',692.00,770.00,0.00,259.31,179442.52,199668.70,20226.18,729262),('1','179','257445','413',692.00,770.00,0.00,604.75,418487.00,448157.50,29670.50,729263),('1','179','257446','413',692.00,770.00,0.00,267.97,185435.24,206336.90,20901.66,729264),('1','179','257447','413',692.00,770.00,0.00,256.03,177172.76,194593.10,17420.34,729265),('1','179','257448','413',692.00,770.00,0.00,574.26,397387.92,428221.70,30833.78,729266),('1','179','257449','413',692.00,770.00,0.00,401.75,278011.00,303847.50,25836.50,729267),('1','179','257450','413',692.00,770.00,0.00,562.35,389146.20,427409.50,38263.30,729268),('1','179','257451','413',692.00,770.00,0.00,334.54,231501.68,257595.80,26094.12,729269),('1','179','257452','413',692.00,770.00,0.00,541.77,374904.84,410412.90,35508.06,729270),('1','179','257453','413',692.00,770.00,0.00,222.27,153810.84,170597.90,16787.06,729271),('1','179','257454','413',692.00,770.00,0.00,93.11,64432.12,71694.70,7262.58,729272),('1','179','257455','413',692.00,770.00,0.00,282.08,195199.36,211176.60,15977.24,729273),('1','179','257456','413',692.00,770.00,0.00,203.48,140808.16,151679.60,10871.44,729274),('1','179','257457','413',692.00,770.00,0.00,169.59,117356.28,130584.30,13228.02,729275),('1','179','257458','413',692.00,770.00,0.00,332.16,229854.72,250763.20,20908.48,729276),('1','179','257459','413',692.00,770.00,0.00,171.91,118961.72,132370.70,13408.98,729277),('1','179','257460','413',692.00,770.00,0.00,148.67,102879.64,114475.90,11596.26,729278),('1','179','257461','413',692.00,770.00,0.00,328.85,227564.20,245714.50,18150.30,729279),('1','179','257462','413',692.00,770.00,0.00,365.48,252912.16,275169.60,22257.44,729280),('1','179','257463','413',692.00,770.00,0.00,315.24,218146.08,239025.30,20879.22,729281),('1','179','257464','413',692.00,770.00,0.00,407.78,282183.76,308990.60,26806.84,729282),('1','179','257465','413',692.00,770.00,0.00,241.45,167083.40,183416.50,16333.10,729283),('1','179','257466','413',692.00,770.00,0.00,612.17,423621.64,450445.90,26824.26,729284),('1','179','257467','413',692.00,770.00,0.00,154.81,107128.52,119203.70,12075.18,729285),('1','179','257468','413',692.00,770.00,0.00,322.10,222893.20,242992.00,20098.80,729286),('1','179','257469','413',692.00,770.00,0.00,475.06,328741.52,356296.20,27554.68,729287),('1','179','257470','413',692.00,770.00,0.00,140.36,97129.12,108077.20,10948.08,729288),('1','179','257471','413',692.00,770.00,0.00,286.95,198569.40,206751.50,8182.10,729289),('1','179','257472','413',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729290),('1','179','257473','413',692.00,770.00,0.00,242.25,167637.00,183532.50,15895.50,729291),('1','179','257474','413',692.00,770.00,0.00,134.64,93170.88,103672.80,10501.92,729292),('1','179','257475','413',692.00,770.00,0.00,366.60,253687.20,271282.00,17594.80,729293),('1','179','257476','413',692.00,770.00,0.00,320.59,221848.28,243854.30,22006.02,729294),('1','179','257477','413',692.00,770.00,0.00,174.11,120484.12,134064.70,13580.58,729295),('1','179','257478','413',692.00,770.00,0.00,215.71,149271.32,164096.70,14825.38,729296),('1','179','257479','413',692.00,770.00,0.00,509.88,352836.96,382857.60,30020.64,729297),('1','179','257480','413',692.00,770.00,0.00,361.47,250137.24,278331.90,28194.66,729298),('1','179','257481','413',692.00,770.00,0.00,584.25,404301.00,439222.50,34921.50,729299),('1','179','257482','413',692.00,770.00,0.00,314.28,217481.76,241995.60,24513.84,729300),('1','179','257483','413',692.00,770.00,0.00,354.73,245473.16,273142.10,27668.94,729301),('1','179','257484','413',692.00,770.00,0.00,305.23,211219.16,235027.10,23807.94,729302),('1','179','257485','413',692.00,770.00,0.00,143.70,99440.40,110649.00,11208.60,729303),('1','179','257486','413',692.00,770.00,0.00,236.95,163969.40,171451.50,7482.10,729304),('1','179','257487','413',692.00,770.00,0.00,127.14,87980.88,97897.80,9916.92,729305),('1','179','257488','413',692.00,770.00,0.00,252.29,174584.68,194263.30,19678.62,729306),('1','179','257489','413',692.00,770.00,0.00,308.20,213274.40,231814.00,18539.60,729307),('1','179','257490','413',692.00,770.00,0.00,147.93,102367.56,113906.10,11538.54,729308),('1','179','257491','413',692.00,770.00,0.00,18.85,13044.20,14514.50,1470.30,729309),('1','179','257492','413',692.00,770.00,0.00,108.73,75241.16,83722.10,8480.94,729310),('1','179','257493','413',692.00,770.00,0.00,295.57,204534.44,221338.90,16804.46,729311),('1','179','257494','413',692.00,770.00,0.00,486.72,336810.24,362274.40,25464.16,729312),('1','179','257495','413',692.00,770.00,0.00,226.52,156751.84,174420.40,17668.56,729313),('1','179','257496','413',692.00,770.00,0.00,148.84,102997.28,114606.80,11609.52,729314),('1','179','257497','413',692.00,770.00,0.00,262.19,181435.48,198361.30,16925.82,729315),('1','179','257498','413',692.00,770.00,0.00,331.99,229737.08,252507.30,22770.22,729316),('1','179','257499','413',692.00,770.00,0.00,187.72,129902.24,144544.40,14642.16,729317),('1','179','257500','413',692.00,770.00,0.00,301.62,208721.04,222247.40,13526.36,729318),('1','179','257501','413',692.00,770.00,0.00,150.12,103883.04,115592.40,11709.36,729319),('1','179','257502','413',692.00,770.00,0.00,146.25,101205.00,112612.50,11407.50,729320),('1','179','257503','413',692.00,770.00,0.00,446.56,309019.52,331351.20,22331.68,729321),('1','179','257504','413',692.00,770.00,0.00,241.08,166827.36,181381.60,14554.24,729322),('1','179','257505','413',692.00,770.00,0.00,245.64,169982.88,185292.80,15309.92,729323),('1','179','257506','413',692.00,770.00,0.00,218.67,151319.64,163799.40,12479.76,729324),('1','179','257507','413',692.00,770.00,0.00,226.93,157035.56,169736.10,12700.54,729325),('1','179','257508','413',692.00,770.00,0.00,129.22,89420.24,99499.40,10079.16,729326),('1','179','257509','413',692.00,770.00,0.00,125.39,86769.88,96550.30,9780.42,729327),('1','179','257510','413',692.00,770.00,0.00,316.37,218928.04,233604.90,14676.86,729328),('1','179','257511','413',692.00,770.00,0.00,193.65,134005.80,145860.50,11854.70,729329),('1','179','257512','413',692.00,770.00,0.00,57.20,39582.40,44044.00,4461.60,729330),('1','179','257513','413',692.00,770.00,0.00,157.88,109252.96,116567.60,7314.64,729331),('1','179','257514','413',692.00,770.00,0.00,128.25,88749.00,96252.50,7503.50,729332),('1','179','257515','413',692.00,770.00,0.00,847.69,586601.48,617721.30,31119.82,729333),('1','179','257516','413',692.00,770.00,0.00,328.48,227308.16,242429.60,15121.44,729334),('1','179','257517','413',692.00,770.00,0.00,0.00,0.00,0.00,0.00,729335),('1','179','257518','413',692.00,770.00,0.00,546.92,370264.84,402778.40,32513.56,729336),('1','179','257519','413',677.00,770.00,0.00,470.92,318812.84,346008.40,27195.56,729337),('1','179','257520','413',677.00,770.00,0.00,162.23,109829.71,124917.10,15087.39,729338),('1','179','257521','413',677.00,770.00,0.00,863.42,584535.34,631083.40,46548.06,729339),('1','179','257522','413',677.00,770.00,0.00,231.62,156806.74,178347.40,21540.66,729340),('1','179','257523','413',677.00,770.00,0.00,256.80,173853.60,192736.00,18882.40,729341),('1','179','257524','413',677.00,770.00,0.00,301.91,204393.07,229970.70,25577.63,729342),('1','179','257525','413',677.00,770.00,0.00,437.99,296519.23,331427.30,34908.07,729343),('1','179','257526','413',677.00,770.00,0.00,268.30,181639.10,203841.00,22201.90,729344),('1','179','257527','413',677.00,770.00,0.00,242.00,163834.00,186340.00,22506.00,729345),('1','179','257528','413',677.00,770.00,0.00,925.70,626698.90,680539.00,53840.10,729346),('1','179','257529','413',677.00,770.00,0.00,272.22,184292.94,197434.40,13141.46,729347),('1','179','257530','413',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729348),('1','179','257531','413',677.00,770.00,0.00,106.25,71931.25,81812.50,9881.25,729349),('1','179','257532','413',677.00,770.00,0.00,124.92,84570.84,96188.40,11617.56,729350),('1','179','257533','413',677.00,770.00,0.00,590.21,399572.17,440611.70,41039.53,729351),('1','179','257534','413',677.00,770.00,0.00,2032.80,1376205.60,1475406.00,99200.40,729352),('1','179','257535','413',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729353),('1','179','257536','413',677.00,770.00,0.00,229.76,155547.52,171015.20,15467.68,729354),('1','179','257537','413',677.00,770.00,0.00,133.85,90616.45,98064.50,7448.05,729355),('1','179','257538','413',677.00,770.00,0.00,94.33,63861.41,70134.10,6272.69,729356),('1','179','257539','413',677.00,770.00,0.00,403.29,273027.33,291083.30,18055.97,729357),('1','179','257540','413',677.00,770.00,0.00,892.00,603884.00,642240.00,38356.00,729358),('1','179','257541','413',677.00,770.00,0.00,300.00,203100.00,216000.00,12900.00,729359),('1','179','257542','413',677.00,770.00,0.00,0.00,0.00,0.00,0.00,729360),('1','179','257543','413',677.00,770.00,0.00,939.16,15501.55,702071.40,686569.85,729361),('1','179','257544','413',0.00,790.00,0.00,1002.97,0.00,748121.30,748121.30,729362),('1','179','257545','413',0.00,790.00,0.00,240.82,0.00,185747.80,185747.80,729363),('1','179','257546','413',0.00,790.00,0.00,1069.38,0.00,807810.20,807810.20,729364),('1','179','257547','413',0.00,790.00,0.00,600.30,0.00,455737.00,455737.00,729365),('1','179','257548','413',0.00,790.00,0.00,803.93,0.00,604483.20,604483.20,729366),('1','179','257549','413',0.00,790.00,0.00,220.00,0.00,162800.00,162800.00,729367),('1','179','257550','413',0.00,790.00,0.00,0.00,0.00,0.00,0.00,729368),('1','179','257551','413',0.00,790.00,0.00,367.34,251627.90,279016.10,27388.20,729369),('1','179','257552','413',685.00,790.00,0.00,1276.04,874087.40,955571.60,81484.20,729370),('1','179','257553','413',685.00,790.00,0.00,1539.96,1054872.60,1153068.40,98195.80,729371),('1','179','257554','413',685.00,790.00,0.00,499.12,341897.20,379304.80,37407.60,729372),('1','179','257555','413',685.00,790.00,0.00,554.30,379695.50,418547.00,38851.50,729373),('1','179','257556','413',685.00,790.00,0.00,944.30,646845.50,700497.00,53651.50,729374),('1','179','257557','413',685.00,790.00,0.00,427.91,293118.35,321403.90,28285.55,729375),('1','179','257558','413',685.00,790.00,0.00,2304.23,1578397.55,1712021.70,133624.15,729376),('1','179','257559','413',685.00,790.00,0.00,934.76,640310.60,700358.90,60048.30,729377),('1','179','257560','413',685.00,790.00,0.00,963.60,660066.00,722244.00,62178.00,729378),('1','179','257561','413',685.00,790.00,0.00,493.62,338129.70,373811.30,35681.60,729379),('1','179','257562','413',685.00,790.00,0.00,32.43,22214.55,23998.20,1783.65,729380),('1','179','257563','413',685.00,790.00,0.00,1537.15,1051719.46,1146377.00,94657.54,729381),('1','179','257564','413',682.00,790.00,0.00,453.75,309457.50,341464.00,32006.50,729382),('1','179','257565','413',682.00,790.00,0.00,478.86,326582.52,360900.90,34318.38,729383),('1','179','257566','413',682.00,790.00,0.00,460.39,313985.98,349708.10,35722.12,729384),('1','179','257567','413',682.00,790.00,0.00,3447.29,2351051.78,2536209.10,185157.32,729385),('1','179','257568','413',682.00,790.00,0.00,453.42,309232.44,345553.30,36320.86,729386),('1','179','257569','413',682.00,790.00,0.00,76.05,51866.10,57579.50,5713.40,729387),('1','179','257570','413',682.00,790.00,0.00,492.56,335925.92,370970.90,35044.98,729388),('1','179','257571','413',682.00,790.00,0.00,603.95,411893.90,455519.00,43625.10,729389),('1','179','257572','413',682.00,790.00,0.00,162.13,110572.66,128082.70,17510.04,729390),('1','179','257573','413',682.00,790.00,0.00,1161.78,792333.96,867427.70,75093.74,729391),('1','179','257574','413',682.00,790.00,0.00,899.47,613438.54,674081.30,60642.76,729392),('1','179','257575','413',682.00,790.00,0.00,617.27,420978.14,466327.30,45349.16,729393),('1','179','257576','413',682.00,790.00,0.00,646.80,441117.60,489026.00,47908.40,729394),('1','179','257577','413',682.00,790.00,0.00,357.69,243944.58,276359.10,32414.52,729395),('1','179','257578','413',682.00,790.00,0.00,395.23,269546.86,302995.20,33448.34,729396),('1','179','257579','413',682.00,790.00,0.00,214.89,146554.98,167263.10,20708.12,729397),('1','179','257580','413',682.00,790.00,0.00,529.26,360955.32,402304.40,41349.08,729398),('1','179','257581','413',682.00,790.00,0.00,377.63,257543.66,291746.70,34203.04,729399),('1','179','257582','413',682.00,790.00,0.00,907.68,619037.76,677567.20,58529.44,729400),('1','179','257583','413',682.00,790.00,0.00,102.46,69877.72,80943.40,11065.68,729401),('1','179','257584','413',682.00,790.00,0.00,0.00,0.00,0.00,0.00,729402),('1','179','257585','413',682.00,790.00,0.00,1001.04,676703.04,750321.60,73618.56,729403),('1','179','257586','413',676.00,790.00,0.00,289.10,195431.60,222443.00,27011.40,729404),('1','179','257587','413',676.00,790.00,0.00,731.27,494338.52,552501.80,58163.28,729405),('1','179','257588','413',676.00,790.00,0.00,1381.28,0.00,1007635.60,1007635.60,729406),('1','179','257589','413',0.00,770.00,0.00,1111.06,0.00,806191.20,806191.20,729407),('1','179','257590','413',0.00,770.00,0.00,600.56,0.00,437431.20,437431.20,729408),('1','179','257591','413',0.00,770.00,0.00,1934.19,1152620.56,1396506.30,243885.74,729409),('1','179','257592','413',676.00,770.00,0.00,446.61,301908.36,329639.70,27731.34,729410),('1','179','257593','413',676.00,770.00,0.00,238.78,161415.28,181360.60,19945.32,729411),('1','179','257594','413',676.00,770.00,0.00,600.32,405816.32,443121.40,37305.08,729412),('1','179','257595','413',676.00,770.00,0.00,545.52,368771.52,407550.40,38778.88,729413),('1','179','257596','413',676.00,770.00,0.00,1840.38,1244096.88,1317792.60,73695.72,729414),('1','179','257597','413',676.00,770.00,0.00,722.36,488315.36,531717.20,43401.84,729415),('1','179','257598','413',676.00,770.00,0.00,373.95,252790.20,279591.50,26801.30,729416),('1','179','257599','413',676.00,770.00,0.00,349.25,236093.00,259672.50,23579.50,729417),('1','179','257600','413',676.00,770.00,0.00,395.37,267270.12,294434.90,27164.78,729418),('1','179','257601','413',676.00,770.00,0.00,346.74,234396.24,254489.80,20093.56,729419),('1','179','257602','413',676.00,770.00,0.00,64.70,43737.20,47134.00,3396.80,729420),('1','179','257603','413',676.00,770.00,0.00,229.10,154871.60,173907.00,19035.40,729421),('1','179','257604','413',676.00,770.00,0.00,286.14,193430.64,218077.80,24647.16,729422),('1','179','257605','413',676.00,770.00,0.00,725.41,490377.16,536815.70,46438.54,729423),('1','179','257606','413',676.00,770.00,0.00,538.26,363863.76,397710.20,33846.44,729424),('1','179','257607','413',676.00,770.00,0.00,654.60,442509.60,482792.00,40282.40,729425),('1','179','257608','413',676.00,770.00,0.00,462.44,312609.44,341328.80,28719.36,729426),('1','179','257609','413',676.00,770.00,0.00,398.04,269075.04,296490.80,27415.76,729427),('1','179','257610','413',676.00,770.00,0.00,310.59,209958.84,235154.30,25195.46,729428),('1','179','257611','413',676.00,770.00,0.00,754.22,509852.72,555999.40,46146.68,729429),('1','179','257612','413',676.00,770.00,0.00,636.45,430240.20,468266.50,38026.30,729430),('1','179','257613','413',676.00,770.00,0.00,0.00,0.00,0.00,0.00,729431),('1','179','257614','413',676.00,770.00,0.00,351.35,237512.60,262889.50,25376.90,729432),('1','179','257615','413',676.00,770.00,0.00,545.61,363741.32,402619.70,38878.38,729433),('1','179','257616','413',660.00,770.00,0.00,643.14,424472.40,472767.80,48295.40,729434),('1','179','257617','413',660.00,770.00,0.00,343.66,226815.60,260868.20,34052.60,729435),('1','179','257618','413',660.00,770.00,0.00,184.20,121572.00,141834.00,20262.00,729436),('1','179','257619','413',660.00,770.00,0.00,215.97,142540.20,166296.90,23756.70,729437),('1','179','257620','413',660.00,770.00,0.00,265.24,175058.40,201734.80,26676.40,729438),('1','179','257621','413',660.00,770.00,0.00,426.76,281661.60,318605.20,36943.60,729439),('1','179','257622','413',660.00,770.00,0.00,529.12,349219.20,396422.40,47203.20,729440),('1','179','257623','413',660.00,770.00,0.00,352.47,232630.20,265151.90,32521.70,729441),('1','179','257624','413',660.00,770.00,0.00,178.06,117519.60,137106.20,19586.60,729442),('1','179','257625','413',660.00,770.00,0.00,284.22,187585.20,213849.40,26264.20,729443),('1','179','257626','413',660.00,770.00,0.00,750.00,495000.00,525000.00,30000.00,729444),('1','179','257627','413',660.00,770.00,0.00,354.19,233765.40,262226.30,28460.90,729445),('1','179','257628','413',660.00,770.00,0.00,443.77,292888.20,331702.90,38814.70,729446),('1','179','257629','413',660.00,770.00,0.00,1338.06,883119.60,963406.20,80286.60,729447),('1','179','257630','413',660.00,770.00,0.00,285.29,188291.40,212173.30,23881.90,729448),('1','179','257631','413',660.00,770.00,0.00,727.40,480084.00,530098.00,50014.00,729449),('1','179','257632','413',660.00,770.00,0.00,291.56,192429.60,219501.20,27071.60,729450),('1','179','257633','413',660.00,770.00,0.00,212.50,140250.00,163625.00,23375.00,729451),('1','179','257634','413',660.00,770.00,0.00,0.00,0.00,0.00,0.00,729452),('1','179','257635','413',677.00,770.00,0.00,224.96,152297.92,170719.20,18421.28,729453),('1','179','257636','413',677.00,770.00,0.00,750.15,507851.55,544615.50,36763.95,729454),('1','179','257637','413',677.00,770.00,0.00,189.36,128196.72,145807.20,17610.48,729455),('1','179','257638','413',677.00,770.00,0.00,208.87,141404.99,160829.90,19424.91,729456),('1','179','257639','413',677.00,770.00,0.00,134.79,91040.33,103788.30,12747.97,729457),('1','179','257640','413',660.00,770.00,0.00,363.06,239619.60,279556.20,39936.60,729458),('1','179','257641','413',660.00,770.00,0.00,501.71,331128.60,368316.70,37188.10,729459),('1','179','257642','413',660.00,770.00,0.00,246.62,162769.20,187397.40,24628.20,729460),('1','179','257643','413',660.00,770.00,0.00,263.31,173784.60,200448.70,26664.10,729461),('1','179','257644','413',660.00,770.00,0.00,192.11,126792.60,147924.70,21132.10,729462),('1','179','257645','413',660.00,770.00,0.00,1014.48,669556.80,735669.60,66112.80,729463),('1','179','257646','413',660.00,770.00,0.00,302.94,199940.40,229838.80,29898.40,729464),('1','179','257647','413',660.00,770.00,0.00,384.28,253624.80,287395.60,33770.80,729465),('1','179','257648','413',660.00,770.00,0.00,313.41,206850.60,238825.70,31975.10,729466),('1','179','257649','413',660.00,770.00,0.00,472.73,312001.80,349002.10,37000.30,729467),('1','179','257650','413',660.00,770.00,0.00,380.06,250839.60,284396.20,33556.60,729468),('1','179','257651','413',660.00,770.00,0.00,465.22,307045.20,355469.40,48424.20,729469),('1','179','257652','413',660.00,770.00,0.00,199.35,131571.00,153499.50,21928.50,729470),('1','179','257653','413',660.00,770.00,0.00,0.00,0.00,0.00,0.00,729471),('1','179','257654','413',660.00,770.00,0.00,0.00,0.00,0.00,0.00,729472),('1','179','257655','413',660.00,770.00,0.00,248.37,163924.20,188119.90,24195.70,729473),('1','179','257656','413',660.00,770.00,0.00,399.23,263491.80,299907.10,36415.30,729474),('1','179','257657','413',660.00,770.00,0.00,497.39,328277.40,361990.30,33712.90,729475),('1','179','257658','413',660.00,770.00,0.00,139.00,91740.00,107030.00,15290.00,729476),('1','179','257659','413',660.00,770.00,0.00,232.67,153562.20,174155.90,20593.70,729477),('1','179','257660','413',660.00,770.00,0.00,7.94,5240.40,6113.80,873.40,729478),('1','179','257661','413',660.00,770.00,0.00,351.74,232148.40,270839.80,38691.40,729479),('1','179','257662','413',660.00,770.00,0.00,255.01,168306.60,196357.70,28051.10,729480),('1','179','257663','413',660.00,770.00,0.00,242.18,159838.80,183978.60,24139.80,729481),('1','179','257664','413',660.00,770.00,0.00,222.59,146909.40,168894.30,21984.90,729482),('1','179','257665','413',660.00,770.00,0.00,206.89,136547.40,156805.30,20257.90,729483),('1','179','257666','413',660.00,770.00,0.00,354.55,234003.00,268003.50,34000.50,729484),('1','179','257667','413',660.00,770.00,0.00,143.80,94908.00,110726.00,15818.00,729485),('1','179','257668','413',660.00,770.00,0.00,261.22,172405.20,196139.40,23734.20,729486),('1','179','257669','413',660.00,770.00,0.00,306.44,202250.40,230958.80,28708.40,729487),('1','179','257670','413',660.00,770.00,0.00,379.38,250390.80,272640.60,22249.80,729488),('1','179','257671','413',660.00,770.00,0.00,199.63,131755.80,148715.10,16959.30,729489),('1','179','257672','413',660.00,770.00,0.00,235.17,155212.20,178580.90,23368.70,729490),('1','179','257673','413',660.00,770.00,0.00,224.74,148328.40,173049.80,24721.40,729491),('1','179','257674','413',660.00,770.00,0.00,272.84,180074.40,210086.80,30012.40,729492),('1','179','257675','413',660.00,770.00,0.00,425.10,280566.00,324577.00,44011.00,729493),('1','179','257676','413',660.00,770.00,0.00,225.77,149008.20,173842.90,24834.70,729494),('1','179','257677','413',660.00,770.00,0.00,237.51,156756.60,182882.70,26126.10,729495),('1','179','257678','413',660.00,770.00,0.00,179.43,118423.80,138161.10,19737.30,729496),('1','179','257679','413',660.00,770.00,0.00,188.79,124601.40,145368.30,20766.90,729497),('1','179','257680','413',660.00,770.00,0.00,219.94,145160.40,169353.80,24193.40,729498),('1','179','257681','413',660.00,770.00,0.00,208.79,137801.40,160768.30,22966.90,729499),('1','179','257682','413',660.00,770.00,0.00,976.72,644635.20,713074.40,68439.20,729500),('1','179','257683','413',660.00,770.00,0.00,276.06,182199.60,210066.20,27866.60,729501);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=381 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',380,'179','LPG TANKS.','TANKS CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=934 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','179','380',933,1,'413','LPG TANK',6000.00,1.00,1204.98,'TANK CONTAINING LPG PRODUCT.','479','2021-05-08 11:00:16','2021-05-08 11:00:16','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','179',933,1351.63,'2023-03-20 18:45:57');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2645869 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2108595,'1','179','933',413,'Retail Sale Id 1254303',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 06:56:18','',''),(2108596,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:56:18','',''),(2109456,'1','179','933',413,'Retail Sale Id 1254697',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 07:37:42','',''),(2109457,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 07:37:42','',''),(2109500,'1','179','933',413,'Retail Sale Id 1254717',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 07:39:40','',''),(2109501,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:39:40','',''),(2109562,'1','179','933',413,'Retail Sale Id 1254732',5248.00,0.00,0.00,0.00,432.00,'2021-12-01 07:41:32','',''),(2109563,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 07:41:32','',''),(2110011,'1','179','933',413,'Retail Sale Id 1254949',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 08:02:59','',''),(2110012,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:02:59','',''),(2110048,'1','179','933',413,'Retail Sale Id 1254966',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 08:04:32','',''),(2110049,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 08:04:32','',''),(2110830,'1','179','933',413,'Retail Sale Id 1255353',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 08:49:45','',''),(2110831,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:49:45','',''),(2110848,'1','179','933',413,'Retail Sale Id 1255361',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 08:51:03','',''),(2110849,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 08:51:03','',''),(2110902,'1','179','933',413,'Retail Sale Id 1255391',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 08:54:14','',''),(2110903,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:54:14','',''),(2111880,'1','179','933',413,'Retail Sale Id 1255897',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 09:57:00','',''),(2111881,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 09:57:00','',''),(2111890,'1','179','933',413,'Retail Sale Id 1255903',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 09:57:46','',''),(2111891,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:57:46','',''),(2112491,'1','179','933',413,'Retail Sale Id 1256191',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 10:39:14','',''),(2112492,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 10:39:14','',''),(2112749,'1','179','933',413,'Retail Sale Id 1256326',7544.00,0.00,0.00,0.00,621.00,'2021-12-01 11:02:54','',''),(2112750,'1','179','933',413,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-01 11:02:54','',''),(2112960,'1','179','933',413,'Retail Sale Id 1256424',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 11:15:54','',''),(2112961,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:15:54','',''),(2113323,'1','179','933',413,'Retail Sale Id 1256600',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 11:39:32','',''),(2113324,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 11:39:32','',''),(2114172,'1','179','933',413,'Retail Sale Id 1257042',997.12,0.00,0.00,0.00,82.08,'2021-12-01 12:52:37','',''),(2114173,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 12:52:37','',''),(2114226,'1','179','933',413,'Retail Sale Id 1257052',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 12:59:36','',''),(2114227,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 12:59:36','',''),(2115552,'1','179','933',413,'Retail Sale Id 1257649',24272.00,0.00,0.00,0.00,1998.00,'2021-12-01 14:24:02','',''),(2115553,'1','179','933',413,'Retail sales',0.00,0.00,0.00,37.00,0.00,'2021-12-01 14:24:02','',''),(2115620,'1','179','933',413,'Retail Sale Id 1257753',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 14:28:12','',''),(2115621,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 14:28:12','',''),(2116606,'1','179','933',413,'Retail Sale Id 1258204',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 15:33:58','',''),(2116607,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:33:58','',''),(2117145,'1','179','933',413,'Retail Sale Id 1258461',997.12,0.00,0.00,0.00,82.08,'2021-12-01 16:00:04','',''),(2117146,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 16:00:04','',''),(2117512,'1','179','933',413,'Retail Sale Id 1258611',3936.00,0.00,0.00,0.00,324.00,'2021-12-01 16:14:35','',''),(2117513,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:14:35','',''),(2117539,'1','179','933',413,'Retail Sale Id 1258631',1502.24,0.00,0.00,0.00,123.66,'2021-12-01 16:15:50','',''),(2117540,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-01 16:15:50','',''),(2117613,'1','179','933',413,'Retail Sale Id 1258671',31160.00,0.00,0.00,0.00,2565.00,'2021-12-01 16:18:55','',''),(2117614,'1','179','933',413,'Retail sales',0.00,0.00,0.00,47.50,0.00,'2021-12-01 16:18:55','',''),(2117640,'1','179','933',413,'Retail Sale Id 1258685',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:20:08','',''),(2117641,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:20:08','',''),(2117680,'1','179','933',413,'Retail Sale Id 1258701',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:21:30','',''),(2117681,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:21:30','',''),(2118084,'1','179','933',413,'Retail Sale Id 1258933',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 16:41:02','',''),(2118085,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 16:41:02','',''),(2118454,'1','179','933',413,'Retail Sale Id 1259119',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:58:11','',''),(2118455,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:58:11','',''),(2118478,'1','179','933',413,'Retail Sale Id 1259132',1968.00,0.00,0.00,0.00,162.00,'2021-12-01 16:59:08','',''),(2118479,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:59:08','',''),(2118610,'1','179','933',413,'Retail Sale Id 1254684',656.00,0.00,0.00,0.00,54.00,'2021-12-01 17:05:26','',''),(2118611,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 17:05:26','',''),(2118736,'1','179','933',413,'Retail Sale Id 1259259',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 17:12:02','',''),(2118737,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:12:02','',''),(2118782,'1','179','933',413,'Retail Sale Id 1259277',2997.92,0.00,0.00,0.00,246.78,'2021-12-01 17:14:25','',''),(2118783,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-01 17:14:25','',''),(2118876,'1','179','933',413,'Retail Sale Id 1259329',3280.00,0.00,0.00,0.00,270.00,'2021-12-01 17:20:13','',''),(2118877,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:20:13','',''),(2118985,'1','179','933',413,'Retail Sale Id 1259387',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 17:28:09','',''),(2118986,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 17:28:09','',''),(2119185,'1','179','933',413,'Retail Sale Id 1259486',4001.60,0.00,0.00,0.00,329.40,'2021-12-01 17:42:19','',''),(2119186,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-01 17:42:19','',''),(2119274,'1','179','933',413,'Retail Sale Id 1259527',1312.00,0.00,0.00,0.00,108.00,'2021-12-01 17:50:16','',''),(2119275,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:50:16','',''),(2119376,'1','179','933',413,'Retail Sale Id 1259577',8200.00,0.00,0.00,0.00,675.00,'2021-12-01 18:04:33','',''),(2119377,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 18:04:33','',''),(2119423,'1','179','933',413,'Retail Sale Id 1259602',2000.80,0.00,0.00,0.00,164.70,'2021-12-01 18:11:03','',''),(2119424,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-01 18:11:03','',''),(2119433,'1','179','933',413,'Retail Sale Id 1259612',997.12,0.00,0.00,0.00,82.08,'2021-12-01 18:12:15','',''),(2119434,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 18:12:15','',''),(2119442,'1','179','933',413,'Retail Sale Id 1259617',3503.04,0.00,0.00,0.00,288.36,'2021-12-01 18:14:35','',''),(2119443,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-01 18:14:35','',''),(2119475,'1','179','933',413,'Retail Sale Id 1259633',8003.20,0.00,0.00,0.00,658.80,'2021-12-01 18:18:01','',''),(2119476,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.20,0.00,'2021-12-01 18:18:01','',''),(2119522,'1','179','933',413,'Retail Sale Id 1259656',997.12,0.00,0.00,0.00,82.08,'2021-12-01 18:23:22','',''),(2119523,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-01 18:23:22','',''),(2119736,'1','179','933',413,'Retail Sale Id 1259742',7498.08,0.00,0.00,0.00,617.22,'2021-12-01 18:57:59','',''),(2119737,'1','179','933',413,'Retail sales',0.00,0.00,0.00,11.43,0.00,'2021-12-01 18:57:59','',''),(2121090,'1','179','933',413,'Retail Sale Id 1260149',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 06:49:43','',''),(2121091,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 06:49:43','',''),(2121298,'1','179','933',413,'Retail Sale Id 1260244',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 07:02:13','',''),(2121299,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:02:13','',''),(2121334,'1','179','933',413,'Retail Sale Id 1260262',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 07:04:20','',''),(2121335,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:04:20','',''),(2121805,'1','179','933',413,'Retail Sale Id 1260481',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 07:27:13','',''),(2121806,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 07:27:13','',''),(2121929,'1','179','933',413,'Retail Sale Id 1260559',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 07:34:14','',''),(2121930,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 07:34:14','',''),(2122420,'1','179','933',413,'Retail Sale Id 1260797',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 07:55:12','',''),(2122421,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:55:12','',''),(2122502,'1','179','933',413,'Retail Sale Id 1260835',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 07:58:21','',''),(2122503,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:58:21','',''),(2123509,'1','179','933',413,'Retail Sale Id 1261313',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 08:48:44','',''),(2123510,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:48:44','',''),(2123647,'1','179','933',413,'Retail Sale Id 1261382',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 08:56:19','',''),(2123648,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:56:19','',''),(2123679,'1','179','933',413,'Retail Sale Id 1261398',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 08:58:16','',''),(2123680,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 08:58:16','',''),(2123719,'1','179','933',413,'Retail Sale Id 1261416',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:00:10','',''),(2123720,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:00:10','',''),(2124056,'1','179','933',413,'Retail Sale Id 1261587',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:16:02','',''),(2124057,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:16:02','',''),(2124380,'1','179','933',413,'Retail Sale Id 1261738',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 09:33:20','',''),(2124381,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:33:20','',''),(2124419,'1','179','933',413,'Retail Sale Id 1261758',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 09:36:02','',''),(2124420,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:36:02','',''),(2124489,'1','179','933',413,'Retail Sale Id 1261795',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 09:41:54','',''),(2124490,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 09:41:54','',''),(2124681,'1','179','933',413,'Retail Sale Id 1261898',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 09:51:15','',''),(2124682,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:51:15','',''),(2124711,'1','179','933',413,'Retail Sale Id 1261914',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:52:38','',''),(2124712,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:52:38','',''),(2124857,'1','179','933',413,'Retail Sale Id 1261990',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 09:59:44','',''),(2124858,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 09:59:44','',''),(2125021,'1','179','933',413,'Retail Sale Id 1262076',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 10:10:26','',''),(2125022,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:10:26','',''),(2125170,'1','179','933',413,'Retail Sale Id 1262145',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 10:18:36','',''),(2125171,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 10:18:36','',''),(2125245,'1','179','933',413,'Retail Sale Id 1262187',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 10:22:12','',''),(2125246,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 10:22:12','',''),(2125325,'1','179','933',413,'Retail Sale Id 1262221',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:26:09','',''),(2125326,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:26:09','',''),(2125408,'1','179','933',413,'Retail Sale Id 1262268',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 10:31:53','',''),(2125409,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:31:53','',''),(2125440,'1','179','933',413,'Retail Sale Id 1262286',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 10:34:04','',''),(2125441,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:34:04','',''),(2125482,'1','179','933',413,'Retail Sale Id 1262298',656.00,0.00,0.00,0.00,54.00,'2021-12-02 10:36:11','',''),(2125483,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 10:36:11','',''),(2126318,'1','179','933',413,'Retail Sale Id 1262733',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 11:27:51','',''),(2126319,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:27:51','',''),(2126344,'1','179','933',413,'Retail Sale Id 1262745',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 11:29:01','',''),(2126345,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 11:29:01','',''),(2126456,'1','179','933',413,'Retail Sale Id 1262792',3280.00,0.00,0.00,0.00,270.00,'2021-12-02 11:33:47','',''),(2126457,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 11:33:47','',''),(2127140,'1','179','933',413,'Retail Sale Id 1263120',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 12:25:39','',''),(2127141,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 12:25:39','',''),(2127174,'1','179','933',413,'Retail Sale Id 1263141',6560.00,0.00,0.00,0.00,540.00,'2021-12-02 12:27:30','',''),(2127175,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 12:27:30','',''),(2128039,'1','179','933',413,'Retail Sale Id 1263553',2499.36,0.00,0.00,0.00,205.74,'2021-12-02 13:29:13','',''),(2128040,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-02 13:29:13','',''),(2128061,'1','179','933',413,'Retail Sale Id 1263563',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 13:30:41','',''),(2128062,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 13:30:41','',''),(2128387,'1','179','933',413,'Retail Sale Id 1263708',997.12,0.00,0.00,0.00,82.08,'2021-12-02 13:51:50','',''),(2128388,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-02 13:51:50','',''),(2128535,'1','179','933',413,'Retail Sale Id 1263769',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 13:59:02','',''),(2128536,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 13:59:02','',''),(2128568,'1','179','933',413,'Retail Sale Id 1263783',1502.24,0.00,0.00,0.00,123.66,'2021-12-02 14:01:37','',''),(2128569,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-02 14:01:37','',''),(2128885,'1','179','933',413,'Retail Sale Id 1263930',32800.00,0.00,0.00,0.00,2700.00,'2021-12-02 14:20:09','',''),(2128886,'1','179','933',413,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-02 14:20:09','',''),(2128955,'1','179','933',413,'Retail Sale Id 1263961',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 14:23:27','',''),(2128956,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:23:27','',''),(2129284,'1','179','933',413,'Retail Sale Id 1264080',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 14:37:23','',''),(2129285,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:37:23','',''),(2129286,'1','179','933',413,'Retail Sale Id 1264080',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 14:37:23','',''),(2129287,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:37:23','',''),(2129755,'1','179','933',413,'Retail Sale Id 1264304',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 15:03:29','',''),(2129756,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:03:29','',''),(2130070,'1','179','933',413,'Retail Sale Id 1264466',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 15:22:06','',''),(2130071,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:22:06','',''),(2130080,'1','179','933',413,'Retail Sale Id 1264472',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 15:23:03','',''),(2130081,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:23:03','',''),(2130644,'1','179','933',413,'Retail Sale Id 1264755',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 15:47:59','',''),(2130645,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:47:59','',''),(2130674,'1','179','933',413,'Retail Sale Id 1264771',7872.00,0.00,0.00,0.00,648.00,'2021-12-02 15:49:14','',''),(2130675,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 15:49:14','',''),(2130794,'1','179','933',413,'Retail Sale Id 1264834',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 15:54:31','',''),(2130795,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 15:54:31','',''),(2130832,'1','179','933',413,'Retail Sale Id 1264855',2997.92,0.00,0.00,0.00,246.78,'2021-12-02 15:55:35','',''),(2130833,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-02 15:55:35','',''),(2131182,'1','179','933',413,'Retail Sale Id 1265016',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 16:10:57','',''),(2131183,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:10:57','',''),(2131317,'1','179','933',413,'Retail Sale Id 1265087',1699.04,0.00,0.00,0.00,139.86,'2021-12-02 16:17:47','',''),(2131318,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.59,0.00,'2021-12-02 16:17:47','',''),(2131402,'1','179','933',413,'Retail Sale Id 1265128',7872.00,0.00,0.00,0.00,648.00,'2021-12-02 16:22:26','',''),(2131403,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 16:22:26','',''),(2131722,'1','179','933',413,'Retail Sale Id 1265282',8200.00,0.00,0.00,0.00,675.00,'2021-12-02 16:34:52','',''),(2131723,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:34:52','',''),(2131806,'1','179','933',413,'Retail Sale Id 1265320',800.32,0.00,0.00,0.00,65.88,'2021-12-02 16:40:20','',''),(2131807,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.22,0.00,'2021-12-02 16:40:20','',''),(2131831,'1','179','933',413,'Retail Sale Id 1265336',1902.40,0.00,0.00,0.00,156.60,'2021-12-02 16:41:41','',''),(2131832,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-02 16:41:41','',''),(2132122,'1','179','933',413,'Retail Sale Id 1265484',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:57:34','',''),(2132123,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:57:34','',''),(2132144,'1','179','933',413,'Retail Sale Id 1265498',3936.00,0.00,0.00,0.00,324.00,'2021-12-02 16:58:44','',''),(2132145,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:58:44','',''),(2132585,'1','179','933',413,'Retail Sale Id 1265694',1298.88,0.00,0.00,0.00,106.92,'2021-12-02 17:24:35','',''),(2132586,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.98,0.00,'2021-12-02 17:24:35','',''),(2132850,'1','179','933',413,'Retail Sale Id 1265818',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 17:50:17','',''),(2132851,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:50:17','',''),(2132875,'1','179','933',413,'Retail Sale Id 1265827',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 17:53:10','',''),(2132876,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 17:53:10','',''),(2132937,'1','179','933',413,'Retail Sale Id 1265851',1312.00,0.00,0.00,0.00,108.00,'2021-12-02 17:59:34','',''),(2132938,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:59:34','',''),(2133003,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,788620.00,1310.00,0.00,0.00,'2021-12-02 18:04:30','',''),(2133030,'1','179',NULL,413,'Reception corrector for bridging 125975',0.00,0.00,0.00,1310.00,0.00,'2021-12-02 18:08:32','',''),(2133031,'1','179','933',413,'Received from bridging 125975',0.00,0.00,1310.00,0.00,0.00,'2021-12-02 18:08:32','',''),(2133147,'1','179','933',413,'Retail Sale Id 1265925',1968.00,0.00,0.00,0.00,162.00,'2021-12-02 18:22:28','',''),(2133148,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 18:22:28','',''),(2133157,'1','179','933',413,'Retail Sale Id 1265929',2000.80,0.00,0.00,0.00,164.70,'2021-12-02 18:24:22','',''),(2133158,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-02 18:24:22','',''),(2133184,'1','179','933',413,'Retail Sale Id 1265936',5248.00,0.00,0.00,0.00,432.00,'2021-12-02 18:26:25','',''),(2133185,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 18:26:25','',''),(2133439,'1','179','933',413,'Retail Sale Id 1266039',4001.60,0.00,0.00,0.00,329.40,'2021-12-02 19:32:18','',''),(2133440,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-02 19:32:18','',''),(2134879,'1','179','933',413,'Retail Sale Id 1266534',4001.60,0.00,0.00,0.00,329.40,'2021-12-03 07:09:56','',''),(2134880,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-03 07:09:56','',''),(2135032,'1','179','933',413,'Retail Sale Id 1266600',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 07:17:21','',''),(2135033,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:17:21','',''),(2135296,'1','179','933',413,'Retail Sale Id 1266723',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 07:33:06','',''),(2135297,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:33:06','',''),(2135392,'1','179','933',413,'Retail Sale Id 1266772',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 07:37:34','',''),(2135393,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 07:37:34','',''),(2135619,'1','179','933',413,'Retail Sale Id 1266871',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 07:49:48','',''),(2135620,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 07:49:48','',''),(2135937,'1','179','933',413,'Retail Sale Id 1267002',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 08:04:01','',''),(2135938,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:04:01','',''),(2135978,'1','179','933',413,'Retail Sale Id 1267026',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 08:05:52','',''),(2135979,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:05:52','',''),(2136002,'1','179','933',413,'Retail Sale Id 1267036',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 08:07:03','',''),(2136003,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 08:07:03','',''),(2136572,'1','179','933',413,'Retail Sale Id 1267283',4100.00,0.00,0.00,0.00,337.50,'2021-12-03 08:36:55','',''),(2136573,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-03 08:36:55','',''),(2136910,'1','179','933',413,'Retail Sale Id 1267417',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 08:52:37','',''),(2136911,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:52:37','',''),(2137314,'1','179','933',413,'Retail Sale Id 1267644',997.12,0.00,0.00,0.00,82.08,'2021-12-03 09:12:56','',''),(2137315,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 09:12:56','',''),(2137497,'1','179','933',413,'Retail Sale Id 1267741',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 09:22:27','',''),(2137498,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 09:22:27','',''),(2137527,'1','179','933',413,'Retail Sale Id 1267755',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 09:24:05','',''),(2137528,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 09:24:05','',''),(2137557,'1','179','933',413,'Retail Sale Id 1267776',2997.92,0.00,0.00,0.00,246.78,'2021-12-03 09:26:20','',''),(2137558,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-03 09:26:20','',''),(2137589,'1','179','933',413,'Retail Sale Id 1267788',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 09:27:49','',''),(2137590,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 09:27:49','',''),(2138173,'1','179','933',413,'Retail Sale Id 1268097',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 10:04:31','',''),(2138174,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 10:04:31','',''),(2138307,'1','179','933',413,'Retail Sale Id 1268161',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:10:48','',''),(2138309,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:10:48','',''),(2138389,'1','179','933',413,'Retail Sale Id 1268204',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 10:15:45','',''),(2138390,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:15:45','',''),(2138528,'1','179','933',413,'Retail Sale Id 1268273',2624.00,0.00,0.00,0.00,216.00,'2021-12-03 10:23:51','',''),(2138529,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 10:23:51','',''),(2138594,'1','179','933',413,'Retail Sale Id 1268304',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 10:27:46','',''),(2138595,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:27:46','',''),(2138839,'1','179','933',413,'Retail Sale Id 1268423',2624.00,0.00,0.00,0.00,216.00,'2021-12-03 10:43:06','',''),(2138840,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 10:43:06','',''),(2139125,'1','179','933',413,'Retail Sale Id 1268577',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:05:51','',''),(2139126,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:05:51','',''),(2139169,'1','179','933',413,'Retail Sale Id 1268603',6560.00,0.00,0.00,0.00,540.00,'2021-12-03 11:09:41','',''),(2139170,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 11:09:41','',''),(2139219,'1','179','933',413,'Retail Sale Id 1268628',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 11:13:47','',''),(2139220,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:13:47','',''),(2139548,'1','179','933',413,'Retail Sale Id 1268802',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 11:39:15','',''),(2139549,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 11:39:15','',''),(2139819,'1','179','933',413,'Retail Sale Id 1268953',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 11:59:54','',''),(2139820,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:59:54','',''),(2139929,'1','179','933',413,'Retail Sale Id 1269031',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 12:06:36','',''),(2139930,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 12:06:36','',''),(2139970,'1','179','933',413,'Retail Sale Id 1269053',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 12:08:50','',''),(2139971,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 12:08:50','',''),(2141009,'1','179','933',413,'Retail Sale Id 1269561',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 13:32:32','',''),(2141010,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:32:32','',''),(2141075,'1','179','933',413,'Retail Sale Id 1269599',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 13:36:58','',''),(2141076,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:36:58','',''),(2141401,'1','179','933',413,'Retail Sale Id 1269714',3601.44,0.00,0.00,0.00,296.46,'2021-12-03 13:49:43','',''),(2141402,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.49,0.00,'2021-12-03 13:49:43','',''),(2141760,'1','179','933',413,'Retail Sale Id 1269866',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 14:11:26','',''),(2141761,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:11:26','',''),(2141997,'1','179','933',413,'Retail Sale Id 1269953',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 14:25:18','',''),(2141998,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:25:18','',''),(2142164,'1','179','933',413,'Retail Sale Id 1270027',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 14:35:24','',''),(2142165,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:35:24','',''),(2142189,'1','179','933',413,'Retail Sale Id 1270032',997.12,0.00,0.00,0.00,82.08,'2021-12-03 14:36:58','',''),(2142190,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 14:36:58','',''),(2142325,'1','179','933',413,'Retail Sale Id 1270079',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 14:42:58','',''),(2142326,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:42:58','',''),(2142988,'1','179','933',413,'Retail Sale Id 1270410',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 15:15:41','',''),(2142989,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:15:41','',''),(2143035,'1','179','933',413,'Retail Sale Id 1270438',4998.72,0.00,0.00,0.00,411.48,'2021-12-03 15:18:18','',''),(2143036,'1','179','933',413,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-03 15:18:18','',''),(2143492,'1','179','933',413,'Retail Sale Id 1270670',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 15:39:31','',''),(2143493,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:39:31','',''),(2143965,'1','179','933',413,'Retail Sale Id 1270903',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 16:00:15','',''),(2143966,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:00:15','',''),(2144081,'1','179','933',413,'Retail Sale Id 1270962',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:05:20','',''),(2144082,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:05:20','',''),(2144131,'1','179','933',413,'Retail Sale Id 1270982',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 16:06:55','',''),(2144132,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 16:06:55','',''),(2144161,'1','179','933',413,'Retail Sale Id 1270995',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 16:08:04','',''),(2144162,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 16:08:04','',''),(2144190,'1','179','933',413,'Retail Sale Id 1271010',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:09:35','',''),(2144191,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:09:35','',''),(2144474,'1','179','933',413,'Retail Sale Id 1271158',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:24:35','',''),(2144475,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:24:35','',''),(2144508,'1','179','933',413,'Retail Sale Id 1271177',3280.00,0.00,0.00,0.00,270.00,'2021-12-03 16:26:32','',''),(2144509,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:26:32','',''),(2144564,'1','179','933',413,'Retail Sale Id 1271202',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 16:30:03','',''),(2144565,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:30:03','',''),(2144885,'1','179','933',413,'Retail Sale Id 1271364',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 16:45:01','',''),(2144886,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 16:45:01','',''),(2144953,'1','179','933',413,'Retail Sale Id 1271400',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:49:36','',''),(2144954,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:49:36','',''),(2144987,'1','179','933',413,'Retail Sale Id 1271414',4500.16,0.00,0.00,0.00,370.44,'2021-12-03 16:51:13','',''),(2144988,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.86,0.00,'2021-12-03 16:51:13','',''),(2145135,'1','179','933',413,'Retail Sale Id 1271464',997.12,0.00,0.00,0.00,82.08,'2021-12-03 16:56:20','',''),(2145136,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-03 16:56:20','',''),(2145163,'1','179','933',413,'Retail Sale Id 1271471',3936.00,0.00,0.00,0.00,324.00,'2021-12-03 16:57:15','',''),(2145164,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:57:15','',''),(2145351,'1','179','933',413,'Retail Sale Id 1271570',1640.00,0.00,0.00,0.00,135.00,'2021-12-03 17:11:44','',''),(2145352,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-03 17:11:44','',''),(2145410,'1','179','933',413,'Retail Sale Id 1271602',1312.00,0.00,0.00,0.00,108.00,'2021-12-03 17:17:14','',''),(2145411,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 17:17:14','',''),(2145575,'1','179','933',413,'Retail Sale Id 1271687',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 17:39:34','',''),(2145576,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:39:34','',''),(2145581,'1','179','933',413,'Retail Sale Id 1271701',8200.00,0.00,0.00,0.00,675.00,'2021-12-03 17:40:25','',''),(2145582,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:40:25','',''),(2145639,'1','179','933',413,'Retail Sale Id 1271726',2000.80,0.00,0.00,0.00,164.70,'2021-12-03 17:50:32','',''),(2145640,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-03 17:50:32','',''),(2145649,'1','179','933',413,'Retail Sale Id 1271731',1502.24,0.00,0.00,0.00,123.66,'2021-12-03 17:51:59','',''),(2145650,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-03 17:51:59','',''),(2145905,'1','179','933',413,'Retail Sale Id 1271816',1968.00,0.00,0.00,0.00,162.00,'2021-12-03 18:19:55','',''),(2145906,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 18:19:55','',''),(2147643,'1','179','933',413,'Retail Sale Id 1272409',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 07:04:41','',''),(2147644,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:04:41','',''),(2147976,'1','179','933',413,'Retail Sale Id 1272588',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 07:22:35','',''),(2147977,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:22:35','',''),(2147988,'1','179','933',413,'Retail Sale Id 1272595',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 07:23:18','',''),(2147989,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:23:18','',''),(2148044,'1','179','933',413,'Retail Sale Id 1272625',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 07:26:04','',''),(2148045,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:26:04','',''),(2148291,'1','179','933',413,'Retail Sale Id 1272759',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 07:37:29','',''),(2148292,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 07:37:29','',''),(2149017,'1','179','933',413,'Retail Sale Id 1273216',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 08:13:45','',''),(2149018,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:13:45','',''),(2149172,'1','179','933',413,'Retail Sale Id 1273278',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 08:20:11','',''),(2149173,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:20:11','',''),(2149366,'1','179','933',413,'Retail Sale Id 1273442',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 08:28:42','',''),(2149367,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:28:42','',''),(2149934,'1','179','933',413,'Retail Sale Id 1273749',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 08:50:46','',''),(2149935,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 08:50:46','',''),(2150051,'1','179','933',413,'Retail Sale Id 1273811',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 08:56:26','',''),(2150052,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:56:26','',''),(2150199,'1','179','933',413,'Retail Sale Id 1273889',4001.60,0.00,0.00,0.00,329.40,'2021-12-04 09:03:23','',''),(2150200,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-04 09:03:23','',''),(2150282,'1','179','933',413,'Retail Sale Id 1273938',2000.80,0.00,0.00,0.00,164.70,'2021-12-04 09:07:08','',''),(2150283,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-04 09:07:08','',''),(2150345,'1','179','933',413,'Retail Sale Id 1273971',6002.40,0.00,0.00,0.00,494.10,'2021-12-04 09:10:55','',''),(2150346,'1','179','933',413,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-04 09:10:55','',''),(2152402,'1','179','933',413,'Retail Sale Id 1274372',26568.00,0.00,0.00,0.00,2187.00,'2021-12-04 10:29:23','',''),(2152403,'1','179','933',413,'Retail sales',0.00,0.00,0.00,40.50,0.00,'2021-12-04 10:29:23','',''),(2152426,'1','179','933',413,'Retail Sale Id 1274380',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 10:31:01','',''),(2152427,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:31:01','',''),(2152612,'1','179','933',413,'Retail Sale Id 1274449',1502.24,0.00,0.00,0.00,123.66,'2021-12-04 10:45:17','',''),(2152613,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 10:45:17','',''),(2152646,'1','179','933',413,'Retail Sale Id 1274457',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 10:46:48','',''),(2152647,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 10:46:48','',''),(2153119,'1','179','933',413,'Retail Sale Id 1274668',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 11:11:54','',''),(2153120,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:11:54','',''),(2153180,'1','179','933',413,'Retail Sale Id 1274708',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 11:15:07','',''),(2153182,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:15:07','',''),(2153412,'1','179','933',413,'Retail Sale Id 1274829',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 11:27:16','',''),(2153413,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:27:16','',''),(2153942,'1','179','933',413,'Retail Sale Id 1275063',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 11:55:24','',''),(2153943,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:55:24','',''),(2153964,'1','179','933',413,'Retail Sale Id 1275072',4592.00,0.00,0.00,0.00,378.00,'2021-12-04 11:56:32','',''),(2153965,'1','179','933',413,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 11:56:32','',''),(2154061,'1','179','933',413,'Retail Sale Id 1275096',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 12:01:00','',''),(2154062,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 12:01:00','',''),(2154081,'1','179','933',413,'Retail Sale Id 1275103',3503.04,0.00,0.00,0.00,288.36,'2021-12-04 12:02:03','',''),(2154082,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-04 12:02:03','',''),(2154351,'1','179','933',413,'Retail Sale Id 1275206',1351.36,0.00,0.00,0.00,111.24,'2021-12-04 12:15:06','',''),(2154352,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.06,0.00,'2021-12-04 12:15:06','',''),(2154381,'1','179','933',413,'Retail Sale Id 1275223',997.12,0.00,0.00,0.00,82.08,'2021-12-04 12:17:31','',''),(2154382,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 12:17:31','',''),(2154399,'1','179','933',413,'Retail Sale Id 1275234',1102.08,0.00,0.00,0.00,90.72,'2021-12-04 12:19:12','',''),(2154400,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.68,0.00,'2021-12-04 12:19:12','',''),(2155170,'1','179','933',413,'Retail Sale Id 1275815',6560.00,0.00,0.00,0.00,540.00,'2021-12-04 13:14:28','',''),(2155171,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 13:14:28','',''),(2155386,'1','179','933',413,'Retail Sale Id 1275895',1312.00,0.00,0.00,0.00,108.00,'2021-12-04 13:25:59','',''),(2155387,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:25:59','',''),(2155448,'1','179','933',413,'Retail Sale Id 1275912',2499.36,0.00,0.00,0.00,205.74,'2021-12-04 13:28:01','',''),(2155449,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.81,0.00,'2021-12-04 13:28:01','',''),(2155486,'1','179','933',413,'Retail Sale Id 1275929',8200.00,0.00,0.00,0.00,675.00,'2021-12-04 13:30:10','',''),(2155487,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:30:10','',''),(2155716,'1','179','933',413,'Retail Sale Id 1276040',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 13:43:02','',''),(2155717,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:43:02','',''),(2156279,'1','179','933',413,'Retail Sale Id 1276286',6560.00,0.00,0.00,0.00,540.00,'2021-12-04 14:08:11','',''),(2156280,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 14:08:11','',''),(2156768,'1','179','933',413,'Retail Sale Id 1276530',1312.00,0.00,0.00,0.00,108.00,'2021-12-04 14:34:05','',''),(2156769,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 14:34:05','',''),(2157200,'1','179','933',413,'Retail Sale Id 1276691',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 14:55:03','',''),(2157201,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 14:55:03','',''),(2158032,'1','179','933',413,'Retail Sale Id 1277056',9512.00,0.00,0.00,0.00,783.00,'2021-12-04 15:35:30','',''),(2158033,'1','179','933',413,'Retail sales',0.00,0.00,0.00,14.50,0.00,'2021-12-04 15:35:30','',''),(2158658,'1','179','933',413,'Retail Sale Id 1277377',6560.00,0.00,0.00,0.00,540.00,'2021-12-04 16:06:12','',''),(2158659,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 16:06:12','',''),(2158702,'1','179','933',413,'Retail Sale Id 1277398',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 16:08:08','',''),(2158703,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 16:08:08','',''),(2158734,'1','179','933',413,'Retail Sale Id 1277415',1312.00,0.00,0.00,0.00,108.00,'2021-12-04 16:09:43','',''),(2158735,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:09:43','',''),(2158949,'1','179','933',413,'Retail Sale Id 1277527',997.12,0.00,0.00,0.00,82.08,'2021-12-04 16:19:25','',''),(2158950,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 16:19:25','',''),(2159581,'1','179','933',413,'Retail Sale Id 1277868',4100.00,0.00,0.00,0.00,337.50,'2021-12-04 16:48:13','',''),(2159582,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-04 16:48:13','',''),(2159605,'1','179','933',413,'Retail Sale Id 1277878',997.12,0.00,0.00,0.00,82.08,'2021-12-04 16:49:22','',''),(2159606,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 16:49:22','',''),(2160447,'1','179','933',413,'Retail Sale Id 1278264',997.12,0.00,0.00,0.00,82.08,'2021-12-04 17:39:37','',''),(2160448,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-04 17:39:38','',''),(2160469,'1','179','933',413,'Retail Sale Id 1278270',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 17:40:57','',''),(2160470,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:40:57','',''),(2160515,'1','179','933',413,'Retail Sale Id 1278279',3936.00,0.00,0.00,0.00,324.00,'2021-12-04 17:42:15','',''),(2160516,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:42:15','',''),(2160547,'1','179','933',413,'Retail Sale Id 1278285',2997.92,0.00,0.00,0.00,246.78,'2021-12-04 17:43:18','',''),(2160548,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-04 17:43:18','',''),(2160686,'1','179','933',413,'Retail Sale Id 1278328',1902.40,0.00,0.00,0.00,156.60,'2021-12-04 17:51:06','',''),(2160687,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-04 17:51:06','',''),(2160695,'1','179','933',413,'Retail Sale Id 1278337',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 17:52:19','',''),(2160696,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:52:19','',''),(2160713,'1','179','933',413,'Retail Sale Id 1278346',3280.00,0.00,0.00,0.00,270.00,'2021-12-04 17:53:46','',''),(2160714,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 17:53:46','',''),(2160944,'1','179','933',413,'Retail Sale Id 1278463',1502.24,0.00,0.00,0.00,123.66,'2021-12-04 18:22:51','',''),(2160945,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-04 18:22:51','',''),(2160960,'1','179','933',413,'Retail Sale Id 1278469',1968.00,0.00,0.00,0.00,162.00,'2021-12-04 18:25:08','',''),(2160961,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 18:25:08','',''),(2162831,'1','179','933',413,'Retail Sale Id 1279035',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 07:06:36','',''),(2162832,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 07:06:36','',''),(2162851,'1','179','933',413,'Retail Sale Id 1279042',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 07:07:46','',''),(2162852,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 07:07:46','',''),(2163084,'1','179','933',413,'Retail Sale Id 1279169',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 07:21:05','',''),(2163085,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 07:21:05','',''),(2163106,'1','179','933',413,'Retail Sale Id 1279200',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 07:23:07','',''),(2163107,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 07:23:07','',''),(2163132,'1','179','933',413,'Retail Sale Id 1279220',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 07:24:46','',''),(2163133,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:24:46','',''),(2163169,'1','179','933',413,'Retail Sale Id 1279234',656.00,0.00,0.00,0.00,54.00,'2021-12-05 07:26:19','',''),(2163170,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 07:26:19','',''),(2163344,'1','179','933',413,'Retail Sale Id 1279347',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 07:37:16','',''),(2163345,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 07:37:16','',''),(2163399,'1','179','933',413,'Retail Sale Id 1279385',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 07:39:35','',''),(2163400,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 07:39:35','',''),(2163445,'1','179','933',413,'Retail Sale Id 1279409',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 07:42:44','',''),(2163446,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 07:42:44','',''),(2163477,'1','179','933',413,'Retail Sale Id 1279423',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 07:44:32','',''),(2163478,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 07:44:32','',''),(2163596,'1','179','933',413,'Retail Sale Id 1279478',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 07:51:00','',''),(2163597,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 07:51:00','',''),(2163825,'1','179','933',413,'Retail Sale Id 1279604',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 08:03:28','',''),(2163826,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 08:03:28','',''),(2164088,'1','179','933',413,'Retail Sale Id 1279762',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 08:17:35','',''),(2164089,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 08:17:35','',''),(2164316,'1','179','933',413,'Retail Sale Id 1279881',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 08:27:06','',''),(2164317,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 08:27:06','',''),(2165482,'1','179','933',413,'Retail Sale Id 1280518',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 09:29:57','',''),(2165483,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:29:57','',''),(2165528,'1','179','933',413,'Retail Sale Id 1280548',23353.60,0.00,0.00,0.00,1922.40,'2021-12-05 09:32:25','',''),(2165529,'1','179','933',413,'Retail sales',0.00,0.00,0.00,35.60,0.00,'2021-12-05 09:32:25','',''),(2165568,'1','179','933',413,'Retail Sale Id 1280571',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 09:34:42','',''),(2165569,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 09:34:42','',''),(2165720,'1','179','933',413,'Retail Sale Id 1280637',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 09:42:00','',''),(2165721,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 09:42:00','',''),(2165758,'1','179','933',413,'Retail Sale Id 1280664',1502.24,0.00,0.00,0.00,123.66,'2021-12-05 09:43:48','',''),(2165759,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 09:43:48','',''),(2165760,'1','179','933',413,'Retail Sale Id 1280664',2000.80,0.00,0.00,0.00,164.70,'2021-12-05 09:43:48','',''),(2165761,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-05 09:43:48','',''),(2165805,'1','179','933',413,'Retail Sale Id 1280674',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 09:45:04','',''),(2165806,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 09:45:04','',''),(2166059,'1','179','933',413,'Retail Sale Id 1280785',2624.00,0.00,0.00,0.00,216.00,'2021-12-05 09:56:53','',''),(2166060,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 09:56:53','',''),(2166283,'1','179','933',413,'Retail Sale Id 1280901',16400.00,0.00,0.00,0.00,1350.00,'2021-12-05 10:11:38','',''),(2166284,'1','179','933',413,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 10:11:38','',''),(2166359,'1','179','933',413,'Retail Sale Id 1280941',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:16:47','',''),(2166360,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:16:47','',''),(2166524,'1','179','933',413,'Retail Sale Id 1281025',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:27:24','',''),(2166525,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:27:24','',''),(2166646,'1','179','933',413,'Retail Sale Id 1281089',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 10:35:12','',''),(2166647,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 10:35:12','',''),(2166648,'1','179','933',413,'Retail Sale Id 1281089',3503.04,0.00,0.00,0.00,288.36,'2021-12-05 10:35:12','',''),(2166649,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-05 10:35:12','',''),(2166989,'1','179','933',413,'Retail Sale Id 1281269',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:53:45','',''),(2166990,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:53:45','',''),(2167023,'1','179','933',413,'Retail Sale Id 1281290',997.12,0.00,0.00,0.00,82.08,'2021-12-05 10:56:21','',''),(2167024,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 10:56:21','',''),(2167092,'1','179','933',413,'Retail Sale Id 1281319',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 10:59:28','',''),(2167093,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:59:28','',''),(2167415,'1','179','933',413,'Retail Sale Id 1281495',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 11:19:24','',''),(2167416,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 11:19:24','',''),(2167417,'1','179','933',413,'Retail Sale Id 1281495',4001.60,0.00,0.00,0.00,329.40,'2021-12-05 11:19:24','',''),(2167418,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-05 11:19:24','',''),(2167437,'1','179','933',413,'Retail Sale Id 1281503',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 11:20:39','',''),(2167438,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:20:39','',''),(2167865,'1','179','933',413,'Retail Sale Id 1281759',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 11:45:44','',''),(2167866,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 11:45:44','',''),(2167955,'1','179','933',413,'Retail Sale Id 1281811',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 11:50:41','',''),(2167956,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 11:50:41','',''),(2168295,'1','179','933',413,'Retail Sale Id 1281990',3280.00,0.00,0.00,0.00,270.00,'2021-12-05 12:09:15','',''),(2168296,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 12:09:15','',''),(2168623,'1','179','933',413,'Retail Sale Id 1282145',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 12:23:21','',''),(2168624,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 12:23:22','',''),(2168712,'1','179','933',413,'Retail Sale Id 1282185',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 12:26:20','',''),(2168713,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:26:20','',''),(2169137,'1','179','933',413,'Retail Sale Id 1282428',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 12:49:36','',''),(2169138,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:49:36','',''),(2169153,'1','179','933',413,'Retail Sale Id 1282436',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 12:50:49','',''),(2169154,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:50:49','',''),(2169642,'1','179','933',413,'Retail Sale Id 1282700',4100.00,0.00,0.00,0.00,337.50,'2021-12-05 13:17:14','',''),(2169643,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 13:17:14','',''),(2169692,'1','179','933',413,'Retail Sale Id 1282712',1312.00,0.00,0.00,0.00,108.00,'2021-12-05 13:20:30','',''),(2169693,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:20:30','',''),(2169714,'1','179','933',413,'Retail Sale Id 1282742',2971.68,0.00,0.00,0.00,244.62,'2021-12-05 13:21:51','',''),(2169715,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.53,0.00,'2021-12-05 13:21:51','',''),(2170543,'1','179','933',413,'Retail Sale Id 1283094',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 14:05:11','',''),(2170544,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:05:11','',''),(2170775,'1','179','933',413,'Retail Sale Id 1283187',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 14:16:40','',''),(2170776,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:16:40','',''),(2170871,'1','179','933',413,'Retail Sale Id 1283224',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 14:20:26','',''),(2170872,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:20:26','',''),(2171607,'1','179','933',413,'Retail Sale Id 1283530',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 15:05:26','',''),(2171608,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:05:26','',''),(2171699,'1','179','933',413,'Retail Sale Id 1283578',4998.72,0.00,0.00,0.00,411.48,'2021-12-05 15:13:00','',''),(2171700,'1','179','933',413,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-05 15:13:00','',''),(2171715,'1','179','933',413,'Retail Sale Id 1283589',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 15:14:33','',''),(2171716,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:14:33','',''),(2171733,'1','179','933',413,'Retail Sale Id 1283599',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 15:15:49','',''),(2171734,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:15:49','',''),(2171762,'1','179','933',413,'Retail Sale Id 1283607',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 15:17:03','',''),(2171763,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:17:03','',''),(2171772,'1','179','933',413,'Retail Sale Id 1283612',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 15:18:05','',''),(2171773,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 15:18:05','',''),(2171796,'1','179','933',413,'Retail Sale Id 1283623',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 15:19:24','',''),(2171797,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:19:24','',''),(2172157,'1','179','933',413,'Retail Sale Id 1283800',3936.00,0.00,0.00,0.00,324.00,'2021-12-05 15:40:30','',''),(2172158,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:40:30','',''),(2172774,'1','179','933',413,'Retail Sale Id 1284123',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 16:14:56','',''),(2172775,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:14:56','',''),(2173031,'1','179','933',413,'Retail Sale Id 1284270',6002.40,0.00,0.00,0.00,494.10,'2021-12-05 16:32:19','',''),(2173032,'1','179','933',413,'Retail sales',0.00,0.00,0.00,9.15,0.00,'2021-12-05 16:32:19','',''),(2173049,'1','179','933',413,'Retail Sale Id 1284279',1502.24,0.00,0.00,0.00,123.66,'2021-12-05 16:33:18','',''),(2173050,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 16:33:18','',''),(2173071,'1','179','933',413,'Retail Sale Id 1284287',2997.92,0.00,0.00,0.00,246.78,'2021-12-05 16:34:11','',''),(2173072,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-05 16:34:11','',''),(2173097,'1','179','933',413,'Retail Sale Id 1284299',997.12,0.00,0.00,0.00,82.08,'2021-12-05 16:35:46','',''),(2173098,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-05 16:35:46','',''),(2173435,'1','179','933',413,'Retail Sale Id 1284476',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 16:56:28','',''),(2173436,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:56:28','',''),(2173541,'1','179','933',413,'Retail Sale Id 1284528',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 17:03:42','',''),(2173542,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:03:42','',''),(2173776,'1','179','933',413,'Retail Sale Id 1284634',1968.00,0.00,0.00,0.00,162.00,'2021-12-05 17:21:24','',''),(2173777,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 17:21:24','',''),(2174139,'1','179','933',413,'Retail Sale Id 1284810',8200.00,0.00,0.00,0.00,675.00,'2021-12-05 18:05:39','',''),(2174140,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 18:05:39','',''),(2174245,'1','179','933',413,'Retail Sale Id 1284843',1502.24,0.00,0.00,0.00,123.66,'2021-12-05 18:44:54','',''),(2174246,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-05 18:44:54','',''),(2175812,'1','179','933',413,'Retail Sale Id 1285364',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 07:28:05','',''),(2175813,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:28:05','',''),(2175850,'1','179','933',413,'Retail Sale Id 1285382',4998.72,0.00,0.00,0.00,411.48,'2021-12-06 07:30:58','',''),(2175851,'1','179','933',413,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-06 07:30:58','',''),(2176379,'1','179','933',413,'Retail Sale Id 1285623',997.12,0.00,0.00,0.00,82.08,'2021-12-06 07:55:22','',''),(2176380,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 07:55:22','',''),(2176410,'1','179','933',413,'Retail Sale Id 1285638',3503.04,0.00,0.00,0.00,288.36,'2021-12-06 07:56:50','',''),(2176411,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.34,0.00,'2021-12-06 07:56:50','',''),(2176473,'1','179','933',413,'Retail Sale Id 1285669',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 07:59:58','',''),(2176474,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 07:59:58','',''),(2176660,'1','179','933',413,'Retail Sale Id 1285772',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 08:09:58','',''),(2176661,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:09:58','',''),(2176686,'1','179','933',413,'Retail Sale Id 1285780',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 08:11:52','',''),(2176687,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:11:52','',''),(2176806,'1','179','933',413,'Retail Sale Id 1285850',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 08:21:09','',''),(2176807,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 08:21:09','',''),(2177457,'1','179','933',413,'Retail Sale Id 1286163',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 09:10:33','',''),(2177458,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:10:33','',''),(2177584,'1','179','933',413,'Retail Sale Id 1286217',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 09:19:33','',''),(2177585,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 09:19:33','',''),(2177602,'1','179','933',413,'Retail Sale Id 1286227',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 09:20:37','',''),(2177603,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 09:20:37','',''),(2178121,'1','179','933',413,'Retail Sale Id 1286452',3608.00,0.00,0.00,0.00,297.00,'2021-12-06 09:51:08','',''),(2178122,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.50,0.00,'2021-12-06 09:51:08','',''),(2178135,'1','179','933',413,'Retail Sale Id 1286461',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 09:51:58','',''),(2178136,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 09:51:58','',''),(2178147,'1','179','933',413,'Retail Sale Id 1286466',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 09:52:51','',''),(2178148,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 09:52:51','',''),(2178274,'1','179','933',413,'Retail Sale Id 1286534',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:01:52','',''),(2178275,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:01:52','',''),(2178292,'1','179','933',413,'Retail Sale Id 1286543',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 10:03:03','',''),(2178293,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 10:03:03','',''),(2178390,'1','179','933',413,'Retail Sale Id 1286583',4001.60,0.00,0.00,0.00,329.40,'2021-12-06 10:07:52','',''),(2178391,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-06 10:07:52','',''),(2178531,'1','179','933',413,'Retail Sale Id 1286649',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:15:45','',''),(2178532,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:15:45','',''),(2178755,'1','179','933',413,'Retail Sale Id 1286768',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 10:31:43','',''),(2178756,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 10:31:43','',''),(2178810,'1','179','933',413,'Retail Sale Id 1286797',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 10:35:51','',''),(2178811,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 10:35:51','',''),(2179365,'1','179','933',413,'Retail Sale Id 1287119',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 11:10:01','',''),(2179366,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 11:10:01','',''),(2179613,'1','179','933',413,'Retail Sale Id 1287254',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 11:25:22','',''),(2179614,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:25:22','',''),(2179968,'1','179','933',413,'Retail Sale Id 1287499',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 11:52:53','',''),(2179969,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 11:52:53','',''),(2180058,'1','179','933',413,'Retail Sale Id 1287536',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 11:58:32','',''),(2180059,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 11:58:32','',''),(2180368,'1','179','933',413,'Retail Sale Id 1287721',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 12:16:49','',''),(2180369,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:16:49','',''),(2180544,'1','179','933',413,'Retail Sale Id 1287813',5248.00,0.00,0.00,0.00,432.00,'2021-12-06 12:28:37','',''),(2180545,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 12:28:37','',''),(2181492,'1','179','933',413,'Retail Sale Id 1288272',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 13:21:24','',''),(2181493,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 13:21:24','',''),(2181532,'1','179','933',413,'Retail Sale Id 1288298',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 13:25:28','',''),(2181533,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 13:25:28','',''),(2181766,'1','179','933',413,'Retail Sale Id 1288403',997.12,0.00,0.00,0.00,82.08,'2021-12-06 13:39:31','',''),(2181767,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 13:39:31','',''),(2181993,'1','179','933',413,'Retail Sale Id 1288502',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 13:49:44','',''),(2181994,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:49:44','',''),(2182204,'1','179','933',413,'Retail Sale Id 1288598',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 14:00:08','',''),(2182205,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:00:08','',''),(2182527,'1','179','933',413,'Retail Sale Id 1288737',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 14:14:22','',''),(2182528,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 14:14:22','',''),(2182543,'1','179','933',413,'Retail Sale Id 1288744',1312.00,0.00,0.00,0.00,108.00,'2021-12-06 14:15:09','',''),(2182544,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 14:15:09','',''),(2182593,'1','179','933',413,'Retail Sale Id 1288763',997.12,0.00,0.00,0.00,82.08,'2021-12-06 14:16:57','',''),(2182594,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-06 14:16:57','',''),(2183868,'1','179','933',413,'Retail Sale Id 1289349',2099.20,0.00,0.00,0.00,172.80,'2021-12-06 15:22:55','',''),(2183869,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.20,0.00,'2021-12-06 15:22:55','',''),(2183947,'1','179','933',413,'Retail Sale Id 1289390',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 15:26:08','',''),(2183948,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:26:08','',''),(2184071,'1','179','933',413,'Retail Sale Id 1289455',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 15:32:50','',''),(2184072,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 15:32:50','',''),(2184089,'1','179','933',413,'Retail Sale Id 1289464',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 15:34:07','',''),(2184090,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:34:07','',''),(2184359,'1','179','933',413,'Retail Sale Id 1289557',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 15:43:52','',''),(2184360,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:43:52','',''),(2184454,'1','179','933',413,'Retail Sale Id 1289592',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 15:47:38','',''),(2184455,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 15:47:38','',''),(2184962,'1','179','933',413,'Retail Sale Id 1289825',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:17:14','',''),(2184963,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:17:14','',''),(2185005,'1','179','933',413,'Retail Sale Id 1289849',2997.92,0.00,0.00,0.00,246.78,'2021-12-06 16:19:23','',''),(2185006,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-06 16:19:23','',''),(2185041,'1','179','933',413,'Retail Sale Id 1289868',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:21:23','',''),(2185042,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:21:23','',''),(2185110,'1','179','933',413,'Retail Sale Id 1289891',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 16:24:29','',''),(2185111,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:24:29','',''),(2185706,'1','179','933',413,'Retail Sale Id 1290196',1968.00,0.00,0.00,0.00,162.00,'2021-12-06 16:56:37','',''),(2185707,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:56:37','',''),(2185822,'1','179','933',413,'Retail Sale Id 1290259',3280.00,0.00,0.00,0.00,270.00,'2021-12-06 17:04:09','',''),(2185823,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 17:04:09','',''),(2185861,'1','179','933',413,'Retail Sale Id 1290276',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 17:06:52','',''),(2185862,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:06:52','',''),(2185983,'1','179','933',413,'Retail Sale Id 1290342',3936.00,0.00,0.00,0.00,324.00,'2021-12-06 17:15:01','',''),(2185984,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 17:15:01','',''),(2185995,'1','179','933',413,'Retail Sale Id 1290348',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 17:16:04','',''),(2185996,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 17:16:04','',''),(2186263,'1','179','933',413,'Retail Sale Id 1290482',8200.00,0.00,0.00,0.00,675.00,'2021-12-06 17:44:24','',''),(2186264,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:44:24','',''),(2186275,'1','179','933',413,'Retail Sale Id 1290503',2000.80,0.00,0.00,0.00,164.70,'2021-12-06 17:45:46','',''),(2186276,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-06 17:45:46','',''),(2186291,'1','179','933',413,'Retail Sale Id 1290511',1502.24,0.00,0.00,0.00,123.66,'2021-12-06 17:47:19','',''),(2186292,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-06 17:47:19','',''),(2186501,'1','179','933',413,'Retail Sale Id 1290567',6560.00,0.00,0.00,0.00,540.00,'2021-12-06 18:24:34','',''),(2186502,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 18:24:34','',''),(2186554,'1','179','933',413,'Retail Sale Id 1290585',2624.00,0.00,0.00,0.00,216.00,'2021-12-06 19:01:21','',''),(2186555,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 19:01:21','',''),(2188420,'1','179','933',413,'Retail Sale Id 1291288',4100.00,0.00,0.00,0.00,337.50,'2021-12-07 07:23:38','',''),(2188421,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 07:23:38','',''),(2188472,'1','179','933',413,'Retail Sale Id 1291310',2624.00,0.00,0.00,0.00,216.00,'2021-12-07 07:25:35','',''),(2188473,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 07:25:35','',''),(2189163,'1','179','933',413,'Retail Sale Id 1291670',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:01:28','',''),(2189164,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:01:28','',''),(2189997,'1','179','933',413,'Retail Sale Id 1292042',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:46:44','',''),(2189998,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:46:44','',''),(2190152,'1','179','933',413,'Retail Sale Id 1292116',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 08:54:28','',''),(2190153,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 08:54:28','',''),(2190297,'1','179','933',413,'Retail Sale Id 1292191',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:05:11','',''),(2190298,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:05:11','',''),(2190341,'1','179','933',413,'Retail Sale Id 1292208',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 09:06:59','',''),(2190342,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 09:06:59','',''),(2190509,'1','179','933',413,'Retail Sale Id 1292298',7872.00,0.00,0.00,0.00,648.00,'2021-12-07 09:15:56','',''),(2190510,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 09:15:56','',''),(2190940,'1','179','933',413,'Retail Sale Id 1292501',7872.00,0.00,0.00,0.00,648.00,'2021-12-07 09:37:22','',''),(2190941,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-07 09:37:22','',''),(2191305,'1','179','933',413,'Retail Sale Id 1292701',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 10:02:27','',''),(2191306,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 10:02:27','',''),(2191333,'1','179','933',413,'Retail Sale Id 1292708',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 10:04:04','',''),(2191334,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 10:04:04','',''),(2191353,'1','179','933',413,'Retail Sale Id 1292719',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 10:05:25','',''),(2191354,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 10:05:25','',''),(2191599,'1','179','933',413,'Retail Sale Id 1292848',2296.00,0.00,0.00,0.00,189.00,'2021-12-07 10:21:40','',''),(2191600,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-07 10:21:40','',''),(2191653,'1','179','933',413,'Retail Sale Id 1292872',4001.60,0.00,0.00,0.00,329.40,'2021-12-07 10:26:31','',''),(2191654,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 10:26:31','',''),(2191827,'1','179','933',413,'Retail Sale Id 1292962',1502.24,0.00,0.00,0.00,123.66,'2021-12-07 10:39:43','',''),(2191828,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-07 10:39:43','',''),(2191865,'1','179','933',413,'Retail Sale Id 1292978',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 10:41:24','',''),(2191866,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 10:41:24','',''),(2191899,'1','179','933',413,'Retail Sale Id 1293000',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 10:43:51','',''),(2191900,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:43:51','',''),(2191986,'1','179','933',413,'Retail Sale Id 1293032',4998.72,0.00,0.00,0.00,411.48,'2021-12-07 10:47:29','',''),(2191987,'1','179','933',413,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 10:47:29','',''),(2193143,'1','179','933',413,'Retail Sale Id 1293637',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 12:02:13','',''),(2193144,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:02:13','',''),(2193497,'1','179','933',413,'Retail Sale Id 1293823',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 12:34:12','',''),(2193498,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:34:12','',''),(2194057,'1','179','933',413,'Retail Sale Id 1294119',997.12,0.00,0.00,0.00,82.08,'2021-12-07 13:12:50','',''),(2194058,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 13:12:50','',''),(2194304,'1','179','933',413,'Retail Sale Id 1294305',1902.40,0.00,0.00,0.00,156.60,'2021-12-07 13:27:17','',''),(2194305,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.90,0.00,'2021-12-07 13:27:17','',''),(2194540,'1','179','933',413,'Retail Sale Id 1294415',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 13:38:35','',''),(2194541,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:38:35','',''),(2194559,'1','179','933',413,'Retail Sale Id 1294424',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 13:39:59','',''),(2194560,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 13:39:59','',''),(2194577,'1','179','933',413,'Retail Sale Id 1294432',4001.60,0.00,0.00,0.00,329.40,'2021-12-07 13:40:53','',''),(2194578,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.10,0.00,'2021-12-07 13:40:53','',''),(2194879,'1','179','933',413,'Retail Sale Id 1294573',656.00,0.00,0.00,0.00,54.00,'2021-12-07 14:01:00','',''),(2194880,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-07 14:01:00','',''),(2194923,'1','179','933',413,'Retail Sale Id 1294598',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 14:04:00','',''),(2194924,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:04:00','',''),(2195234,'1','179','933',413,'Retail Sale Id 1294719',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 14:20:04','',''),(2195235,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 14:20:04','',''),(2195246,'1','179','933',413,'Retail Sale Id 1294724',4998.72,0.00,0.00,0.00,411.48,'2021-12-07 14:21:13','',''),(2195247,'1','179','933',413,'Retail sales',0.00,0.00,0.00,7.62,0.00,'2021-12-07 14:21:13','',''),(2195579,'1','179','933',413,'Retail Sale Id 1294905',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 14:40:14','',''),(2195580,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:40:14','',''),(2195734,'1','179','933',413,'Retail Sale Id 1294980',1312.00,0.00,0.00,0.00,108.00,'2021-12-07 14:47:43','',''),(2195735,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 14:47:43','',''),(2195826,'1','179','933',413,'Retail Sale Id 1295029',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 14:51:41','',''),(2195827,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:51:41','',''),(2195870,'1','179','933',413,'Retail Sale Id 1295055',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 14:53:55','',''),(2195871,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:53:55','',''),(2196034,'1','179','933',413,'Retail Sale Id 1295130',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 15:04:21','',''),(2196035,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:04:21','',''),(2196192,'1','179','933',413,'Retail Sale Id 1295209',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:12:45','',''),(2196193,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:12:45','',''),(2196428,'1','179','933',413,'Retail Sale Id 1295331',997.12,0.00,0.00,0.00,82.08,'2021-12-07 15:25:30','',''),(2196429,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:25:30','',''),(2196590,'1','179','933',413,'Retail Sale Id 1295412',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 15:33:03','',''),(2196591,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:33:03','',''),(2196713,'1','179','933',413,'Retail Sale Id 1295471',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 15:38:44','',''),(2196714,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:38:44','',''),(2196734,'1','179','933',413,'Retail Sale Id 1295483',997.12,0.00,0.00,0.00,82.08,'2021-12-07 15:39:42','',''),(2196735,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-07 15:39:42','',''),(2197070,'1','179','933',413,'Retail Sale Id 1295653',6560.00,0.00,0.00,0.00,540.00,'2021-12-07 15:55:25','',''),(2197071,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 15:55:25','',''),(2197088,'1','179','933',413,'Retail Sale Id 1295662',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 15:56:22','',''),(2197089,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 15:56:22','',''),(2197278,'1','179','933',413,'Retail Sale Id 1295754',5248.00,0.00,0.00,0.00,432.00,'2021-12-07 16:05:33','',''),(2197279,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 16:05:33','',''),(2197448,'1','179','933',413,'Retail Sale Id 1295844',8200.00,0.00,0.00,0.00,675.00,'2021-12-07 16:14:12','',''),(2197449,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:14:12','',''),(2197464,'1','179','933',413,'Retail Sale Id 1295855',3936.00,0.00,0.00,0.00,324.00,'2021-12-07 16:15:08','',''),(2197465,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:15:08','',''),(2197601,'1','179','933',413,'Retail Sale Id 1295932',3280.00,0.00,0.00,0.00,270.00,'2021-12-07 16:20:24','',''),(2197602,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:20:24','',''),(2198409,'1','179','933',413,'Retail Sale Id 1296342',1640.00,0.00,0.00,0.00,135.00,'2021-12-07 17:03:37','',''),(2198410,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-07 17:03:37','',''),(2198484,'1','179','933',413,'Retail Sale Id 1296381',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 17:08:24','',''),(2198485,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 17:08:24','',''),(2198533,'1','179','933',413,'Retail Sale Id 1296406',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 17:12:16','',''),(2198534,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 17:12:16','',''),(2198567,'1','179','933',413,'Retail Sale Id 1296440',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 17:15:09','',''),(2198568,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 17:15:09','',''),(2198830,'1','179','933',413,'Retail Sale Id 1296574',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 17:39:35','',''),(2198831,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 17:39:35','',''),(2199088,'1','179','933',413,'Retail Sale Id 1296667',2000.80,0.00,0.00,0.00,164.70,'2021-12-07 18:03:43','',''),(2199089,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-07 18:03:43','',''),(2199106,'1','179','933',413,'Retail Sale Id 1296673',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 18:05:52','',''),(2199107,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 18:05:52','',''),(2199114,'1','179','933',413,'Retail Sale Id 1296677',1968.00,0.00,0.00,0.00,162.00,'2021-12-07 18:07:24','',''),(2199115,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 18:07:24','',''),(2201015,'1','179','933',413,'Retail Sale Id 1297343',2000.80,0.00,0.00,0.00,164.70,'2021-12-08 07:33:34','',''),(2201016,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-08 07:33:34','',''),(2201053,'1','179','933',413,'Retail Sale Id 1297356',3280.00,0.00,0.00,0.00,270.00,'2021-12-08 07:34:43','',''),(2201054,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 07:34:43','',''),(2201240,'1','179','933',413,'Retail Sale Id 1297447',2997.92,0.00,0.00,0.00,246.78,'2021-12-08 07:45:46','',''),(2201241,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.57,0.00,'2021-12-08 07:45:46','',''),(2201750,'1','179','933',413,'Retail Sale Id 1297679',8200.00,0.00,0.00,0.00,675.00,'2021-12-08 08:12:39','',''),(2201751,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:12:39','',''),(2202492,'1','179','933',413,'Retail Sale Id 1297985',19352.00,0.00,0.00,0.00,1593.00,'2021-12-08 08:52:11','',''),(2202493,'1','179','933',413,'Retail sales',0.00,0.00,0.00,29.50,0.00,'2021-12-08 08:52:11','',''),(2203559,'1','179','933',413,'Retail Sale Id 1298503',7216.00,0.00,0.00,0.00,594.00,'2021-12-08 10:05:49','',''),(2203560,'1','179','933',413,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 10:05:49','',''),(2203963,'1','179','933',413,'Retail Sale Id 1298687',11152.00,0.00,0.00,0.00,918.00,'2021-12-08 10:30:28','',''),(2203964,'1','179','933',413,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-08 10:30:28','',''),(2221317,'1','179','933',413,'Returned bridging 125975',0.00,0.00,0.00,1310.00,0.00,'2021-12-09 14:51:31','',''),(2221318,'1','179',NULL,413,'Reception Return corrector for bridging 125975',0.00,0.00,1310.00,0.00,0.00,'2021-12-09 14:51:31','',''),(2222967,'1','179','933',413,'Retail Sale Id 1307600',26784.48,0.00,0.00,0.00,2204.82,'2021-12-09 16:16:44','',''),(2222968,'1','179','933',413,'Retail sales',0.00,0.00,0.00,40.83,0.00,'2021-12-09 16:16:44','',''),(2223154,'1','179','933',413,'Retail Sale Id 1307683',2000.80,0.00,0.00,0.00,164.70,'2021-12-09 16:26:59','',''),(2223155,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.05,0.00,'2021-12-09 16:26:59','',''),(2223430,'1','179','933',413,'Retail Sale Id 1307802',997.12,0.00,0.00,0.00,82.08,'2021-12-09 16:41:14','',''),(2223431,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-09 16:41:14','',''),(2223562,'1','179','933',413,'Retail Sale Id 1307854',3280.00,0.00,0.00,0.00,270.00,'2021-12-09 16:47:55','',''),(2223563,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 16:47:55','',''),(2223689,'1','179','933',413,'Retail Sale Id 1307913',8200.00,0.00,0.00,0.00,675.00,'2021-12-09 16:55:33','',''),(2223690,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:55:33','',''),(2223752,'1','179','933',413,'Retail Sale Id 1307942',11998.24,0.00,0.00,0.00,987.66,'2021-12-09 16:59:44','',''),(2223753,'1','179','933',413,'Retail sales',0.00,0.00,0.00,18.29,0.00,'2021-12-09 16:59:44','',''),(2223820,'1','179','933',413,'Retail Sale Id 1307974',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 17:03:18','',''),(2223821,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:03:18','',''),(2223922,'1','179','933',413,'Retail Sale Id 1308025',1968.00,0.00,0.00,0.00,162.00,'2021-12-09 17:11:03','',''),(2223923,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:11:03','',''),(2223936,'1','179','933',413,'Retail Sale Id 1308032',1502.24,0.00,0.00,0.00,123.66,'2021-12-09 17:12:09','',''),(2223937,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.29,0.00,'2021-12-09 17:12:09','',''),(2224197,'1','179','933',413,'Retail Sale Id 1308165',1312.00,0.00,0.00,0.00,108.00,'2021-12-09 17:49:01','',''),(2224198,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:49:01','',''),(2224232,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,3019200.00,5100.00,0.00,0.00,'2021-12-09 17:54:45','',''),(2224242,'1','179',NULL,413,'Reception corrector for bridging 126764',0.00,0.00,0.00,5100.00,0.00,'2021-12-09 17:55:49','',''),(2224243,'1','179','933',413,'Received from bridging 126764',0.00,0.00,5100.00,0.00,0.00,'2021-12-09 17:55:49','',''),(2224418,'1','179','933',413,'Retail Sale Id 1308266',3936.00,0.00,0.00,0.00,384.00,'2021-12-09 18:26:03','',''),(2224419,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 18:26:03','',''),(2226022,'1','179','933',413,'Retail Sale Id 1308812',3744.00,0.00,0.00,0.00,0.00,'2021-12-10 07:16:28','',''),(2226023,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 07:16:28','',''),(2227168,'1','179','933',413,'Retail Sale Id 1309310',1872.00,0.00,0.00,0.00,0.00,'2021-12-10 08:14:10','',''),(2227169,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:14:10','',''),(2227170,'1','179','933',413,'Retail Sale Id 1309310',3744.00,0.00,0.00,0.00,0.00,'2021-12-10 08:14:10','',''),(2227171,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:14:10','',''),(2227277,'1','179','933',413,'Retail Sale Id 1309369',3744.00,0.00,0.00,0.00,0.00,'2021-12-10 08:20:04','',''),(2227278,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:20:04','',''),(2228557,'1','179','933',413,'Retail Sale Id 1309957',1872.00,0.00,0.00,0.00,0.00,'2021-12-10 09:21:53','',''),(2228558,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 09:21:53','',''),(2228600,'1','179','933',413,'Retail Sale Id 1309980',1248.00,0.00,0.00,0.00,0.00,'2021-12-10 09:24:41','',''),(2228601,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 09:24:41','',''),(2228674,'1','179','933',413,'Retail Sale Id 1310014',3001.44,0.00,0.00,0.00,0.00,'2021-12-10 09:29:26','',''),(2228675,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 09:29:26','',''),(2228903,'1','179','933',413,'Retail Sale Id 1310122',3120.00,0.00,0.00,0.00,0.00,'2021-12-10 09:42:15','',''),(2228904,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:42:15','',''),(2228953,'1','179','933',413,'Retail Sale Id 1310151',2003.04,0.00,0.00,0.00,0.00,'2021-12-10 09:44:32','',''),(2228954,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 09:44:32','',''),(2228975,'1','179','933',413,'Retail Sale Id 1310165',998.40,0.00,0.00,0.00,0.00,'2021-12-10 09:45:41','',''),(2228976,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 09:45:41','',''),(2229083,'1','179','933',413,'Retail Sale Id 1310216',3120.00,0.00,0.00,0.00,0.00,'2021-12-10 09:52:39','',''),(2229084,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 09:52:39','',''),(2229697,'1','179','933',413,'Retail Sale Id 1310498',3120.00,0.00,0.00,0.00,0.00,'2021-12-10 10:25:56','',''),(2229698,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:25:56','',''),(2229893,'1','179','933',413,'Retail Sale Id 1310584',2496.00,0.00,0.00,0.00,0.00,'2021-12-10 10:37:58','',''),(2229894,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 10:37:58','',''),(2229911,'1','179','933',413,'Retail Sale Id 1310598',4998.24,0.00,0.00,0.00,0.00,'2021-12-10 10:39:12','',''),(2229912,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-10 10:39:12','',''),(2229997,'1','179','933',413,'Retail Sale Id 1310636',1872.00,0.00,0.00,0.00,0.00,'2021-12-10 10:44:46','',''),(2229998,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 10:44:46','',''),(2232767,'1','179','933',413,'Retail Sale Id 1311947',29702.40,0.00,0.00,0.00,0.00,'2021-12-10 13:46:05','',''),(2232768,'1','179','933',413,'Retail sales',0.00,0.00,0.00,47.60,0.00,'2021-12-10 13:46:05','',''),(2232777,'1','179','933',413,'Retail Sale Id 1311953',1872.00,0.00,0.00,0.00,0.00,'2021-12-10 13:46:51','',''),(2232778,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 13:46:51','',''),(2232957,'1','179','933',413,'Retail Sale Id 1312032',998.40,0.00,0.00,0.00,0.00,'2021-12-10 13:55:46','',''),(2232958,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-10 13:55:46','',''),(2233685,'1','179','933',413,'Retail Sale Id 1312330',7800.00,0.00,0.00,0.00,0.00,'2021-12-10 14:29:07','',''),(2233686,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 14:29:07','',''),(2233777,'1','179','933',413,'Retail Sale Id 1312378',5497.44,0.00,0.00,0.00,0.00,'2021-12-10 14:33:21','',''),(2233778,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.81,0.00,'2021-12-10 14:33:21','',''),(2233825,'1','179','933',413,'Retail Sale Id 1312399',2003.04,0.00,0.00,0.00,0.00,'2021-12-10 14:35:33','',''),(2233826,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-10 14:35:33','',''),(2234731,'1','179','933',413,'Retail Sale Id 1312810',798.72,0.00,0.00,0.00,0.00,'2021-12-10 15:16:44','',''),(2234732,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-10 15:16:44','',''),(2235794,'1','179','933',413,'Retail Sale Id 1313351',3744.00,0.00,0.00,0.00,0.00,'2021-12-10 16:01:29','',''),(2235795,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:01:29','',''),(2235828,'1','179','933',413,'Retail Sale Id 1313370',3744.00,0.00,0.00,0.00,0.00,'2021-12-10 16:03:29','',''),(2235829,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:03:29','',''),(2236353,'1','179','933',413,'Retail Sale Id 1313634',3001.44,0.00,0.00,0.00,0.00,'2021-12-10 16:26:34','',''),(2236354,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-10 16:26:34','',''),(2236385,'1','179','933',413,'Retail Sale Id 1313648',6002.88,0.00,0.00,0.00,0.00,'2021-12-10 16:27:46','',''),(2236386,'1','179','933',413,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-10 16:27:46','',''),(2236463,'1','179','933',413,'Retail Sale Id 1313678',7800.00,0.00,0.00,0.00,0.00,'2021-12-10 16:31:32','',''),(2236464,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:31:32','',''),(2237214,'1','179','933',413,'Retail Sale Id 1314046',3500.64,0.00,0.00,0.00,0.00,'2021-12-10 17:18:48','',''),(2237215,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-10 17:18:48','',''),(2237626,'1','179','933',413,'Retail Sale Id 1314252',1872.00,0.00,0.00,0.00,0.00,'2021-12-10 18:01:12','',''),(2237627,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 18:01:12','',''),(2237677,'1','179','933',413,'Retail Sale Id 1314278',3744.00,0.00,0.00,0.00,0.00,'2021-12-10 18:11:02','',''),(2237678,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 18:11:02','',''),(2237730,'1','179','933',413,'Retail Sale Id 1314301',1248.00,0.00,0.00,0.00,0.00,'2021-12-10 18:27:11','',''),(2237731,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 18:27:11','',''),(2237835,'1','179','933',413,'Retail Sale Id 1314340',1872.00,0.00,0.00,0.00,0.00,'2021-12-10 18:51:54','',''),(2237836,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 18:51:54','',''),(2240471,'1','179','933',413,'Retail Sale Id 1315426',1248.00,0.00,0.00,0.00,0.00,'2021-12-11 08:03:32','',''),(2240472,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 08:03:32','',''),(2240488,'1','179','933',413,'Retail Sale Id 1315431',998.40,0.00,0.00,0.00,0.00,'2021-12-11 08:04:17','',''),(2240489,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 08:04:17','',''),(2240516,'1','179','933',413,'Retail Sale Id 1315437',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 08:05:03','',''),(2240517,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 08:05:03','',''),(2240717,'1','179','933',413,'Retail Sale Id 1315521',1497.60,0.00,0.00,0.00,0.00,'2021-12-11 08:14:00','',''),(2240718,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 08:14:00','',''),(2240753,'1','179','933',413,'Retail Sale Id 1315544',2496.00,0.00,0.00,0.00,0.00,'2021-12-11 08:15:56','',''),(2240754,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 08:15:56','',''),(2242195,'1','179','933',413,'Retail Sale Id 1316220',1872.00,0.00,0.00,0.00,0.00,'2021-12-11 09:22:10','',''),(2242196,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:22:10','',''),(2242329,'1','179','933',413,'Retail Sale Id 1316285',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 09:30:36','',''),(2242330,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 09:30:36','',''),(2242504,'1','179','933',413,'Retail Sale Id 1316379',1797.12,0.00,0.00,0.00,0.00,'2021-12-11 09:38:30','',''),(2242505,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-11 09:38:30','',''),(2242522,'1','179','933',413,'Retail Sale Id 1316389',3120.00,0.00,0.00,0.00,0.00,'2021-12-11 09:39:27','',''),(2242523,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 09:39:27','',''),(2242646,'1','179','933',413,'Retail Sale Id 1316450',1872.00,0.00,0.00,0.00,0.00,'2021-12-11 09:44:46','',''),(2242647,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 09:44:46','',''),(2243882,'1','179','933',413,'Retail Sale Id 1317016',1872.00,0.00,0.00,0.00,0.00,'2021-12-11 10:45:42','',''),(2243883,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 10:45:42','',''),(2244113,'1','179','933',413,'Retail Sale Id 1317136',998.40,0.00,0.00,0.00,0.00,'2021-12-11 10:59:18','',''),(2244114,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 10:59:18','',''),(2244146,'1','179','933',413,'Retail Sale Id 1317145',3999.84,0.00,0.00,0.00,0.00,'2021-12-11 11:00:26','',''),(2244147,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-11 11:00:26','',''),(2244176,'1','179','933',413,'Retail Sale Id 1317156',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 11:01:41','',''),(2244177,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:01:41','',''),(2244311,'1','179','933',413,'Retail Sale Id 1317219',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 11:07:45','',''),(2244312,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 11:07:45','',''),(2244479,'1','179','933',413,'Retail Sale Id 1317301',2502.24,0.00,0.00,0.00,0.00,'2021-12-11 11:16:32','',''),(2244480,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-11 11:16:32','',''),(2244860,'1','179','933',413,'Retail Sale Id 1317491',1872.00,0.00,0.00,0.00,0.00,'2021-12-11 11:36:14','',''),(2244861,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 11:36:14','',''),(2245433,'1','179','933',413,'Retail Sale Id 1317828',1872.00,0.00,0.00,0.00,0.00,'2021-12-11 12:13:15','',''),(2245434,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 12:13:15','',''),(2246266,'1','179','933',413,'Retail Sale Id 1318260',2496.00,0.00,0.00,0.00,0.00,'2021-12-11 13:06:45','',''),(2246267,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-11 13:06:45','',''),(2246306,'1','179','933',413,'Retail Sale Id 1318281',7800.00,0.00,0.00,0.00,0.00,'2021-12-11 13:11:24','',''),(2246307,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 13:11:24','',''),(2246490,'1','179','933',413,'Retail Sale Id 1318370',3120.00,0.00,0.00,0.00,0.00,'2021-12-11 13:23:09','',''),(2246491,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-11 13:23:09','',''),(2247148,'1','179','933',413,'Retail Sale Id 1318666',7800.00,0.00,0.00,0.00,0.00,'2021-12-11 14:05:57','',''),(2247149,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-11 14:05:57','',''),(2247168,'1','179','933',413,'Retail Sale Id 1318675',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 14:07:18','',''),(2247169,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:07:18','',''),(2247296,'1','179','933',413,'Retail Sale Id 1318737',2003.04,0.00,0.00,0.00,0.00,'2021-12-11 14:13:35','',''),(2247297,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 14:13:35','',''),(2247454,'1','179','933',413,'Retail Sale Id 1318812',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 14:24:01','',''),(2247455,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:24:01','',''),(2247524,'1','179','933',413,'Retail Sale Id 1318843',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 14:29:37','',''),(2247525,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 14:29:37','',''),(2247914,'1','179','933',413,'Retail Sale Id 1319061',998.40,0.00,0.00,0.00,0.00,'2021-12-11 14:53:29','',''),(2247915,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 14:53:29','',''),(2248045,'1','179','933',413,'Retail Sale Id 1319127',998.40,0.00,0.00,0.00,0.00,'2021-12-11 14:59:56','',''),(2248046,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 14:59:56','',''),(2250128,'1','179','933',413,'Retail Sale Id 1320131',1872.00,0.00,0.00,0.00,0.00,'2021-12-11 16:41:46','',''),(2250129,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-11 16:41:46','',''),(2250212,'1','179','933',413,'Retail Sale Id 1320169',1248.00,0.00,0.00,0.00,0.00,'2021-12-11 16:47:36','',''),(2250213,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-11 16:47:36','',''),(2250250,'1','179','933',413,'Retail Sale Id 1320184',3744.00,0.00,0.00,0.00,0.00,'2021-12-11 16:49:10','',''),(2250251,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-11 16:49:10','',''),(2250284,'1','179','933',413,'Retail Sale Id 1320199',2003.04,0.00,0.00,0.00,0.00,'2021-12-11 16:51:53','',''),(2250285,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 16:51:53','',''),(2250394,'1','179','933',413,'Retail Sale Id 1320240',27424.80,0.00,0.00,0.00,0.00,'2021-12-11 16:56:50','',''),(2250395,'1','179','933',413,'Retail sales',0.00,0.00,0.00,43.95,0.00,'2021-12-11 16:56:50','',''),(2250412,'1','179','933',413,'Retail Sale Id 1320249',998.40,0.00,0.00,0.00,0.00,'2021-12-11 16:57:59','',''),(2250413,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-11 16:57:59','',''),(2250594,'1','179','933',413,'Retail Sale Id 1320339',1497.60,0.00,0.00,0.00,0.00,'2021-12-11 17:09:30','',''),(2250595,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-11 17:09:30','',''),(2250975,'1','179','933',413,'Retail Sale Id 1320524',2003.04,0.00,0.00,0.00,0.00,'2021-12-11 17:41:25','',''),(2250976,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-11 17:41:25','',''),(2251504,'1','179','933',413,'Retail Sale Id 1320746',2371.20,0.00,0.00,0.00,0.00,'2021-12-11 18:56:06','',''),(2251505,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-11 18:56:06','',''),(2252866,'1','179','933',413,'Retail Sale Id 1321168',1248.00,0.00,0.00,0.00,0.00,'2021-12-12 07:12:14','',''),(2252867,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 07:12:14','',''),(2252910,'1','179','933',413,'Retail Sale Id 1321189',624.00,0.00,0.00,0.00,0.00,'2021-12-12 07:15:12','',''),(2252911,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-12 07:15:12','',''),(2253306,'1','179','933',413,'Retail Sale Id 1321409',1697.28,0.00,0.00,0.00,0.00,'2021-12-12 07:41:36','',''),(2253307,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-12 07:41:36','',''),(2253379,'1','179','933',413,'Retail Sale Id 1321433',7800.00,0.00,0.00,0.00,0.00,'2021-12-12 07:46:05','',''),(2253380,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 07:46:05','',''),(2253703,'1','179','933',413,'Retail Sale Id 1321608',3744.00,0.00,0.00,0.00,0.00,'2021-12-12 08:06:24','',''),(2253704,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 08:06:24','',''),(2254037,'1','179','933',413,'Retail Sale Id 1321783',7500.48,0.00,0.00,0.00,0.00,'2021-12-12 08:29:18','',''),(2254038,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-12 08:29:18','',''),(2254178,'1','179','933',413,'Retail Sale Id 1321857',998.40,0.00,0.00,0.00,0.00,'2021-12-12 08:38:44','',''),(2254179,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 08:38:44','',''),(2254528,'1','179','933',413,'Retail Sale Id 1322017',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 08:57:51','',''),(2254529,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 08:57:51','',''),(2254697,'1','179','933',413,'Retail Sale Id 1322106',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 09:07:24','',''),(2254698,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 09:07:24','',''),(2254753,'1','179','933',413,'Retail Sale Id 1322131',6240.00,0.00,0.00,0.00,0.00,'2021-12-12 09:10:33','',''),(2254754,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-12 09:10:33','',''),(2254859,'1','179','933',413,'Retail Sale Id 1322189',2502.24,0.00,0.00,0.00,0.00,'2021-12-12 09:15:41','',''),(2254860,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-12 09:15:41','',''),(2256265,'1','179','933',413,'Retail Sale Id 1322878',16348.80,0.00,0.00,0.00,0.00,'2021-12-12 10:31:00','',''),(2256266,'1','179','933',413,'Retail sales',0.00,0.00,0.00,26.20,0.00,'2021-12-12 10:31:00','',''),(2257455,'1','179','933',413,'Retail Sale Id 1323481',6739.20,0.00,0.00,0.00,0.00,'2021-12-12 11:23:14','',''),(2257456,'1','179','933',413,'Retail sales',0.00,0.00,0.00,10.80,0.00,'2021-12-12 11:23:14','',''),(2257676,'1','179','933',413,'Retail Sale Id 1323599',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 11:33:42','',''),(2257677,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 11:33:42','',''),(2258536,'1','179','933',413,'Retail Sale Id 1324010',3120.00,0.00,0.00,0.00,0.00,'2021-12-12 12:16:36','',''),(2258537,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 12:16:36','',''),(2258921,'1','179','933',413,'Retail Sale Id 1324195',8361.60,0.00,0.00,0.00,0.00,'2021-12-12 12:33:52','',''),(2258922,'1','179','933',413,'Retail sales',0.00,0.00,0.00,13.40,0.00,'2021-12-12 12:33:52','',''),(2259368,'1','179','933',413,'Retail Sale Id 1324408',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 12:54:18','',''),(2259369,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:54:18','',''),(2259427,'1','179','933',413,'Retail Sale Id 1324435',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 12:56:52','',''),(2259428,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:56:52','',''),(2259447,'1','179','933',413,'Retail Sale Id 1324445',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 12:57:55','',''),(2259448,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 12:57:55','',''),(2259883,'1','179','933',413,'Retail Sale Id 1324653',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 13:22:06','',''),(2259884,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 13:22:06','',''),(2260426,'1','179','933',413,'Retail Sale Id 1324893',1248.00,0.00,0.00,0.00,0.00,'2021-12-12 13:47:46','',''),(2260427,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 13:47:46','',''),(2260605,'1','179','933',413,'Retail Sale Id 1324971',3744.00,0.00,0.00,0.00,0.00,'2021-12-12 13:56:08','',''),(2260606,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 13:56:08','',''),(2260847,'1','179','933',413,'Retail Sale Id 1325055',998.40,0.00,0.00,0.00,0.00,'2021-12-12 14:05:52','',''),(2260848,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 14:05:52','',''),(2260906,'1','179','933',413,'Retail Sale Id 1325072',7800.00,0.00,0.00,0.00,0.00,'2021-12-12 14:08:09','',''),(2260907,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 14:08:09','',''),(2261239,'1','179','933',413,'Retail Sale Id 1325213',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 14:25:12','',''),(2261240,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 14:25:12','',''),(2262636,'1','179','933',413,'Retail Sale Id 1325811',3744.00,0.00,0.00,0.00,0.00,'2021-12-12 15:39:45','',''),(2262637,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:39:45','',''),(2262680,'1','179','933',413,'Retail Sale Id 1325836',3744.00,0.00,0.00,0.00,0.00,'2021-12-12 15:41:53','',''),(2262681,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-12 15:41:53','',''),(2262731,'1','179','933',413,'Retail Sale Id 1325848',1872.00,0.00,0.00,0.00,0.00,'2021-12-12 15:43:24','',''),(2262732,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-12 15:43:24','',''),(2262764,'1','179','933',413,'Retail Sale Id 1325867',7800.00,0.00,0.00,0.00,0.00,'2021-12-12 15:45:35','',''),(2262765,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-12 15:45:35','',''),(2262800,'1','179','933',413,'Retail Sale Id 1325888',998.40,0.00,0.00,0.00,0.00,'2021-12-12 15:48:05','',''),(2262801,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 15:48:05','',''),(2262885,'1','179','933',413,'Retail Sale Id 1325932',14289.60,0.00,0.00,0.00,0.00,'2021-12-12 15:53:38','',''),(2262886,'1','179','933',413,'Retail sales',0.00,0.00,0.00,22.90,0.00,'2021-12-12 15:53:38','',''),(2263270,'1','179','933',413,'Retail Sale Id 1326120',2496.00,0.00,0.00,0.00,0.00,'2021-12-12 16:20:48','',''),(2263271,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-12 16:20:48','',''),(2264162,'1','179','933',413,'Retail Sale Id 1326511',1560.00,0.00,0.00,0.00,0.00,'2021-12-12 17:16:52','',''),(2264163,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-12 17:16:52','',''),(2264363,'1','179','933',413,'Retail Sale Id 1326603',3120.00,0.00,0.00,0.00,0.00,'2021-12-12 17:41:47','',''),(2264364,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-12 17:41:47','',''),(2264461,'1','179','933',413,'Retail Sale Id 1326650',1248.00,0.00,0.00,0.00,0.00,'2021-12-12 17:57:05','',''),(2264462,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-12 17:57:05','',''),(2264542,'1','179','933',413,'Retail Sale Id 1326674',20217.60,0.00,0.00,0.00,0.00,'2021-12-12 18:13:42','',''),(2264543,'1','179','933',413,'Retail sales',0.00,0.00,0.00,32.40,0.00,'2021-12-12 18:13:42','',''),(2264675,'1','179','933',413,'Retail Sale Id 1326731',998.40,0.00,0.00,0.00,0.00,'2021-12-12 18:56:44','',''),(2264676,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-12 18:56:44','',''),(2266570,'1','179','933',413,'Retail Sale Id 1327403',3120.00,0.00,0.00,0.00,0.00,'2021-12-13 07:49:32','',''),(2266571,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 07:49:32','',''),(2267001,'1','179','933',413,'Retail Sale Id 1327582',7800.00,0.00,0.00,0.00,0.00,'2021-12-13 08:09:58','',''),(2267002,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 08:09:58','',''),(2267046,'1','179','933',413,'Retail Sale Id 1327600',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 08:12:05','',''),(2267047,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 08:12:05','',''),(2267260,'1','179','933',413,'Retail Sale Id 1327668',4998.24,0.00,0.00,0.00,0.00,'2021-12-13 08:21:24','',''),(2267261,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-13 08:21:24','',''),(2267378,'1','179','933',413,'Retail Sale Id 1327728',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 08:29:16','',''),(2267379,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 08:29:16','',''),(2267601,'1','179','933',413,'Retail Sale Id 1327837',3120.00,0.00,0.00,0.00,0.00,'2021-12-13 08:38:55','',''),(2267602,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 08:38:55','',''),(2267623,'1','179','933',413,'Retail Sale Id 1327849',2496.00,0.00,0.00,0.00,0.00,'2021-12-13 08:39:51','',''),(2267624,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-13 08:39:51','',''),(2268187,'1','179','933',413,'Retail Sale Id 1328077',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 09:10:43','',''),(2268188,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 09:10:43','',''),(2268450,'1','179','933',413,'Retail Sale Id 1328195',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 09:25:40','',''),(2268451,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 09:25:40','',''),(2268590,'1','179','933',413,'Retail Sale Id 1328261',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 09:34:19','',''),(2268591,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 09:34:19','',''),(2268765,'1','179','933',413,'Retail Sale Id 1328356',7800.00,0.00,0.00,0.00,0.00,'2021-12-13 09:47:32','',''),(2268766,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 09:47:32','',''),(2268819,'1','179','933',413,'Retail Sale Id 1328389',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 09:50:24','',''),(2268820,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 09:50:24','',''),(2269515,'1','179','933',413,'Retail Sale Id 1328738',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 10:36:51','',''),(2269516,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:36:51','',''),(2269568,'1','179','933',413,'Retail Sale Id 1328764',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 10:40:15','',''),(2269569,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 10:40:15','',''),(2269618,'1','179','933',413,'Retail Sale Id 1328788',7800.00,0.00,0.00,0.00,0.00,'2021-12-13 10:42:50','',''),(2269619,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 10:42:50','',''),(2269702,'1','179','933',413,'Retail Sale Id 1328817',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 10:48:03','',''),(2269703,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 10:48:03','',''),(2269806,'1','179','933',413,'Retail Sale Id 1328879',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 10:52:42','',''),(2269807,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 10:52:42','',''),(2270336,'1','179','933',413,'Retail Sale Id 1329131',1297.92,0.00,0.00,0.00,0.00,'2021-12-13 11:30:48','',''),(2270337,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-13 11:30:48','',''),(2270449,'1','179','933',413,'Retail Sale Id 1329183',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 11:39:54','',''),(2270450,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 11:39:54','',''),(2270486,'1','179','933',413,'Retail Sale Id 1329205',624.00,0.00,0.00,0.00,0.00,'2021-12-13 11:42:17','',''),(2270487,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-13 11:42:17','',''),(2271126,'1','179','933',413,'Retail Sale Id 1329559',3001.44,0.00,0.00,0.00,0.00,'2021-12-13 12:36:27','',''),(2271127,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-13 12:36:27','',''),(2271619,'1','179','933',413,'Retail Sale Id 1329802',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 13:07:13','',''),(2271620,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:07:13','',''),(2271990,'1','179','933',413,'Retail Sale Id 1329951',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 13:26:55','',''),(2271991,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 13:26:55','',''),(2272108,'1','179','933',413,'Retail Sale Id 1330005',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 13:34:10','',''),(2272109,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 13:34:10','',''),(2272168,'1','179','933',413,'Retail Sale Id 1330023',3001.44,0.00,0.00,0.00,0.00,'2021-12-13 13:36:58','',''),(2272169,'1','179','933',413,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-13 13:36:58','',''),(2272616,'1','179','933',413,'Retail Sale Id 1330218',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 14:02:20','',''),(2272617,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 14:02:20','',''),(2273048,'1','179','933',413,'Retail Sale Id 1330495',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 14:28:55','',''),(2273049,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 14:28:55','',''),(2273447,'1','179','933',413,'Retail Sale Id 1330675',3120.00,0.00,0.00,0.00,0.00,'2021-12-13 14:52:43','',''),(2273448,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-13 14:52:43','',''),(2273818,'1','179','933',413,'Retail Sale Id 1330869',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 15:17:13','',''),(2273819,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 15:17:13','',''),(2273911,'1','179','933',413,'Retail Sale Id 1330910',9672.00,0.00,0.00,0.00,0.00,'2021-12-13 15:22:21','',''),(2273912,'1','179','933',413,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-13 15:22:21','',''),(2274325,'1','179','933',413,'Retail Sale Id 1331081',7800.00,0.00,0.00,0.00,0.00,'2021-12-13 15:38:42','',''),(2274326,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 15:38:42','',''),(2274555,'1','179','933',413,'Retail Sale Id 1331199',998.40,0.00,0.00,0.00,0.00,'2021-12-13 15:49:41','',''),(2274556,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-13 15:49:41','',''),(2274557,'1','179','933',413,'Retail Sale Id 1331199',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 15:49:41','',''),(2274558,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 15:49:41','',''),(2274853,'1','179','933',413,'Retail Sale Id 1331357',7488.00,0.00,0.00,0.00,0.00,'2021-12-13 16:06:28','',''),(2274854,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-13 16:06:28','',''),(2274869,'1','179','933',413,'Retail Sale Id 1331366',1497.60,0.00,0.00,0.00,0.00,'2021-12-13 16:07:20','',''),(2274870,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-13 16:07:20','',''),(2275143,'1','179','933',413,'Retail Sale Id 1331500',1497.60,0.00,0.00,0.00,0.00,'2021-12-13 16:21:06','',''),(2275144,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-13 16:21:06','',''),(2275376,'1','179','933',413,'Retail Sale Id 1331617',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 16:33:54','',''),(2275377,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:33:54','',''),(2275584,'1','179','933',413,'Retail Sale Id 1331729',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 16:47:04','',''),(2275585,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 16:47:04','',''),(2275684,'1','179','933',413,'Retail Sale Id 1331782',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 16:53:58','',''),(2275685,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 16:53:58','',''),(2275815,'1','179','933',413,'Retail Sale Id 1331841',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 17:03:30','',''),(2275816,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 17:03:30','',''),(2275973,'1','179','933',413,'Retail Sale Id 1331926',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 17:19:22','',''),(2275974,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 17:19:22','',''),(2275996,'1','179','933',413,'Retail Sale Id 1331936',1872.00,0.00,0.00,0.00,0.00,'2021-12-13 17:22:03','',''),(2275997,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-13 17:22:03','',''),(2276288,'1','179','933',413,'Retail Sale Id 1332046',7800.00,0.00,0.00,0.00,0.00,'2021-12-13 18:04:58','',''),(2276289,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 18:04:58','',''),(2276372,'1','179','933',413,'Retail Sale Id 1332060',3744.00,0.00,0.00,0.00,0.00,'2021-12-13 18:23:00','',''),(2276373,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-13 18:23:00','',''),(2276415,'1','179','933',413,'Retail Sale Id 1332067',7800.00,0.00,0.00,0.00,0.00,'2021-12-13 18:30:53','',''),(2276416,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-13 18:30:53','',''),(2276451,'1','179','933',413,'Retail Sale Id 1332080',1248.00,0.00,0.00,0.00,0.00,'2021-12-13 18:47:54','',''),(2276452,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-13 18:47:54','',''),(2276466,'1','179','933',413,'Retail Sale Id 1332085',2003.04,0.00,0.00,0.00,0.00,'2021-12-13 19:11:28','',''),(2276467,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-13 19:11:28','',''),(2277850,'1','179','933',413,'Retail Sale Id 1332508',2002.00,0.00,0.00,0.00,2002.00,'2021-12-14 07:08:33','',''),(2277851,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 07:08:33','',''),(2278039,'1','179','933',413,'Retail Sale Id 1332611',3080.00,0.00,0.00,0.00,3080.00,'2021-12-14 07:21:15','',''),(2278040,'1','179','933',413,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-14 07:21:15','',''),(2278464,'1','179','933',413,'Retail Sale Id 1332885',1848.00,0.00,0.00,0.00,1848.00,'2021-12-14 07:46:51','',''),(2278465,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:46:51','',''),(2278608,'1','179','933',413,'Retail Sale Id 1333007',1848.00,0.00,0.00,0.00,1848.00,'2021-12-14 07:54:34','',''),(2278609,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 07:54:34','',''),(2278622,'1','179','933',413,'Retail Sale Id 1333016',997.92,0.00,0.00,0.00,997.92,'2021-12-14 07:55:46','',''),(2278623,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 07:55:46','',''),(2279011,'1','179','933',413,'Retail Sale Id 1333199',2002.00,0.00,0.00,0.00,2002.00,'2021-12-14 08:14:35','',''),(2279012,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 08:14:35','',''),(2279257,'1','179','933',413,'Retail Sale Id 1333348',3696.00,0.00,0.00,0.00,3696.00,'2021-12-14 08:29:26','',''),(2279258,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 08:29:26','',''),(2279735,'1','179','933',413,'Retail Sale Id 1333589',997.92,0.00,0.00,0.00,997.92,'2021-12-14 08:54:25','',''),(2279736,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 08:54:25','',''),(2279959,'1','179','933',413,'Retail Sale Id 1333669',1232.00,0.00,0.00,0.00,1232.00,'2021-12-14 09:03:38','',''),(2279960,'1','179','933',413,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-14 09:03:38','',''),(2280045,'1','179','933',413,'Retail Sale Id 1333721',997.92,0.00,0.00,0.00,997.92,'2021-12-14 09:07:13','',''),(2280046,'1','179','933',413,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-14 09:07:13','',''),(2280786,'1','179','933',413,'Retail Sale Id 1334048',7700.00,0.00,0.00,0.00,7700.00,'2021-12-14 09:44:50','',''),(2280787,'1','179','933',413,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-14 09:44:50','',''),(2280832,'1','179','933',413,'Retail Sale Id 1334070',2002.00,0.00,0.00,0.00,2002.00,'2021-12-14 09:47:23','',''),(2280833,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 09:47:23','',''),(2280834,'1','179','933',413,'Retail Sale Id 1334070',2002.00,0.00,0.00,0.00,2002.00,'2021-12-14 09:47:23','',''),(2280835,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-14 09:47:23','',''),(2280858,'1','179','933',413,'Retail Sale Id 1334084',3696.00,0.00,0.00,0.00,3696.00,'2021-12-14 09:49:22','',''),(2280859,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 09:49:22','',''),(2281078,'1','179','933',413,'Retail Sale Id 1334200',1848.00,0.00,0.00,0.00,1848.00,'2021-12-14 10:02:55','',''),(2281079,'1','179','933',413,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-14 10:02:55','',''),(2281119,'1','179','933',413,'Retail Sale Id 1334221',3696.00,0.00,0.00,0.00,3696.00,'2021-12-14 10:05:45','',''),(2281120,'1','179','933',413,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-14 10:05:45','',''),(2281182,'1','179','933',413,'Retail Sale Id 1334258',5544.00,0.00,0.00,0.00,5544.00,'2021-12-14 10:09:54','',''),(2281183,'1','179','933',413,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-14 10:09:54','',''),(2281240,'1','179','933',413,'Retail Sale Id 1334286',4928.00,0.00,0.00,0.00,4928.00,'2021-12-14 10:12:18','',''),(2281241,'1','179','933',413,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-14 10:12:18','',''),(2282485,'1','179','933',413,'Retail Sale Id 1335371',7700.00,0.00,0.00,12.50,7700.00,'2021-12-14 12:28:59','',''),(2282659,'1','179','933',413,'Retail Sale Id 1335518',1897.28,0.00,0.00,3.08,1897.28,'2021-12-14 12:49:28','',''),(2282948,'1','179','933',413,'Retail Sale Id 1335774',6997.76,0.00,0.00,11.36,6997.76,'2021-12-14 13:27:27','',''),(2283253,'1','179','933',413,'Retail Sale Id 1335968',15892.80,0.00,0.00,25.80,15892.80,'2021-12-14 13:59:52','',''),(2283281,'1','179','933',413,'Retail Sale Id 1335995',1503.04,0.00,0.00,2.44,1503.04,'2021-12-14 14:03:18','',''),(2283467,'1','179','933',413,'Retail Sale Id 1336120',7700.00,0.00,0.00,12.50,7700.00,'2021-12-14 14:20:39','',''),(2283677,'1','179','933',413,'Retail Sale Id 1336274',1848.00,0.00,0.00,3.00,1848.00,'2021-12-14 14:43:52','',''),(2283826,'1','179','933',413,'Retail Sale Id 1336385',616.00,0.00,0.00,1.00,616.00,'2021-12-14 15:01:34','',''),(2283921,'1','179','933',413,'Retail Sale Id 1336484',2002.00,0.00,0.00,3.25,2002.00,'2021-12-14 15:19:11','',''),(2284068,'1','179','933',413,'Retail Sale Id 1336592',1798.72,0.00,0.00,2.92,1798.72,'2021-12-14 15:35:29','',''),(2284092,'1','179','933',413,'Retail Sale Id 1336607',3696.00,0.00,0.00,6.00,3696.00,'2021-12-14 15:37:59','',''),(2284182,'1','179','933',413,'Retail Sale Id 1336639',3696.00,0.00,0.00,6.00,3696.00,'2021-12-14 15:41:57','',''),(2284531,'1','179','933',413,'Retail Sale Id 1336925',1848.00,0.00,0.00,3.00,1848.00,'2021-12-14 16:16:18','',''),(2284652,'1','179','933',413,'Retail Sale Id 1337029',1503.04,0.00,0.00,2.44,1503.04,'2021-12-14 16:27:12','',''),(2284653,'1','179','933',413,'Retail Sale Id 1337029',7502.88,0.00,0.00,12.18,7502.88,'2021-12-14 16:27:12','',''),(2284748,'1','179','933',413,'Retail Sale Id 1337115',6997.76,0.00,0.00,11.36,6997.76,'2021-12-14 16:34:57','',''),(2284791,'1','179','933',413,'Retail Sale Id 1337146',997.92,0.00,0.00,1.62,997.92,'2021-12-14 16:37:40','',''),(2284984,'1','179','933',413,'Retail Sale Id 1337269',899.36,0.00,0.00,1.46,899.36,'2021-12-14 16:54:09','',''),(2284993,'1','179','933',413,'Retail Sale Id 1337276',2002.00,0.00,0.00,3.25,2002.00,'2021-12-14 16:55:12','',''),(2285051,'1','179','933',413,'Retail Sale Id 1337329',5001.92,0.00,0.00,8.12,5001.92,'2021-12-14 17:02:17','',''),(2285092,'1','179','933',413,'Retail Sale Id 1337375',1232.00,0.00,0.00,2.00,1232.00,'2021-12-14 17:07:34','',''),(2285131,'1','179','933',413,'Retail Sale Id 1337408',7515.20,0.00,0.00,12.20,7515.20,'2021-12-14 17:13:39','',''),(2285165,'1','179','933',413,'Retail Sale Id 1337436',7700.00,0.00,0.00,12.50,7700.00,'2021-12-14 17:18:23','',''),(2285211,'1','179','933',413,'Retail Sale Id 1337479',7700.00,0.00,0.00,12.50,7700.00,'2021-12-14 17:28:40','',''),(2285240,'1','179','933',413,'Retail Sale Id 1337501',3696.00,0.00,0.00,6.00,3696.00,'2021-12-14 17:34:46','',''),(2285298,'1','179','933',413,'Retail Sale Id 1337563',3696.00,0.00,0.00,6.00,3696.00,'2021-12-14 18:04:31','',''),(2285307,'1','179','933',413,'Retail Sale Id 1337573',2002.00,0.00,0.00,3.25,2002.00,'2021-12-14 18:10:16','',''),(2285308,'1','179','933',413,'Retail Sale Id 1337574',4928.00,0.00,0.00,8.00,4928.00,'2021-12-14 18:11:15','',''),(2285329,'1','179','933',413,'Retail Sale Id 1337593',997.92,0.00,0.00,1.62,997.92,'2021-12-14 18:23:08','',''),(2286363,'1','179','933',413,'Retail Sale Id 1338013',3080.00,0.00,0.00,5.00,3080.00,'2021-12-15 07:04:48','',''),(2286469,'1','179','933',413,'Retail Sale Id 1338135',3080.00,0.00,0.00,5.00,3080.00,'2021-12-15 07:18:14','',''),(2286721,'1','179','933',413,'Retail Sale Id 1338364',2002.00,0.00,0.00,3.25,2002.00,'2021-12-15 07:46:08','',''),(2286764,'1','179','933',413,'Retail Sale Id 1338390',3080.00,0.00,0.00,5.00,3080.00,'2021-12-15 07:49:27','',''),(2286859,'1','179','933',413,'Retail Sale Id 1338452',1232.00,0.00,0.00,2.00,1232.00,'2021-12-15 07:58:05','',''),(2286927,'1','179','933',413,'Retail Sale Id 1338502',3696.00,0.00,0.00,6.00,3696.00,'2021-12-15 08:03:32','',''),(2287066,'1','179','933',413,'Retail Sale Id 1338589',7700.00,0.00,0.00,12.50,7700.00,'2021-12-15 08:14:11','',''),(2287120,'1','179','933',413,'Retail Sale Id 1338638',7700.00,0.00,0.00,12.50,7700.00,'2021-12-15 08:19:00','',''),(2287280,'1','179','933',413,'Retail Sale Id 1338772',3696.00,0.00,0.00,6.00,3696.00,'2021-12-15 08:35:49','',''),(2287367,'1','179','933',413,'Retail Sale Id 1338850',3080.00,0.00,0.00,5.00,3080.00,'2021-12-15 08:45:49','',''),(2287460,'1','179','933',413,'Retail Sale Id 1338942',997.92,0.00,0.00,1.62,997.92,'2021-12-15 08:56:58','',''),(2287617,'1','179','933',413,'Retail Sale Id 1339042',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 09:11:48','',''),(2287929,'1','179','933',413,'Retail Sale Id 1339317',3696.00,0.00,0.00,6.00,3696.00,'2021-12-15 09:48:29','',''),(2288120,'1','179','933',413,'Retail Sale Id 1339473',2464.00,0.00,0.00,4.00,2464.00,'2021-12-15 10:12:00','',''),(2288212,'1','179','933',413,'Retail Sale Id 1339550',3997.84,0.00,0.00,6.49,3997.84,'2021-12-15 10:25:29','',''),(2288392,'1','179','933',413,'Retail Sale Id 1339702',3080.00,0.00,0.00,5.00,3080.00,'2021-12-15 10:50:31','',''),(2288415,'1','179','933',413,'Retail Sale Id 1339718',2002.00,0.00,0.00,3.25,2002.00,'2021-12-15 10:51:52','',''),(2288531,'1','179','933',413,'Retail Sale Id 1339819',3080.00,0.00,0.00,5.00,3080.00,'2021-12-15 11:05:10','',''),(2288619,'1','179','933',413,'Retail Sale Id 1339908',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 11:16:08','',''),(2288798,'1','179','933',413,'Retail Sale Id 1340048',2464.00,0.00,0.00,4.00,2464.00,'2021-12-15 11:34:12','',''),(2288932,'1','179','933',413,'Retail Sale Id 1340195',3696.00,0.00,0.00,6.00,3696.00,'2021-12-15 11:52:17','',''),(2289073,'1','179','933',413,'Retail Sale Id 1340331',15400.00,0.00,0.00,25.00,15400.00,'2021-12-15 12:13:02','',''),(2289132,'1','179','933',413,'Retail Sale Id 1340390',5482.40,0.00,0.00,8.90,5482.40,'2021-12-15 12:21:05','',''),(2289236,'1','179','933',413,'Retail Sale Id 1340496',15400.00,0.00,0.00,25.00,15400.00,'2021-12-15 12:37:11','',''),(2289524,'1','179','933',413,'Retail Sale Id 1340716',3696.00,0.00,0.00,6.00,3696.00,'2021-12-15 13:14:46','',''),(2289596,'1','179','933',413,'Retail Sale Id 1340770',1232.00,0.00,0.00,2.00,1232.00,'2021-12-15 13:21:46','',''),(2289606,'1','179','933',413,'Retail Sale Id 1340783',616.00,0.00,0.00,1.00,616.00,'2021-12-15 13:23:29','',''),(2289686,'1','179','933',413,'Retail Sale Id 1340860',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 13:34:44','',''),(2290411,'1','179','933',413,'Retail Sale Id 1341363',2002.00,0.00,0.00,3.25,2002.00,'2021-12-15 14:40:36','',''),(2290714,'1','179','933',413,'Retail Sale Id 1341591',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 15:06:52','',''),(2290891,'1','179','933',413,'Retail Sale Id 1341710',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 15:21:11','',''),(2290909,'1','179','933',413,'Retail Sale Id 1341733',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 15:22:35','',''),(2290985,'1','179','933',413,'Retail Sale Id 1341762',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 15:25:40','',''),(2291100,'1','179','933',413,'Retail Sale Id 1341841',6997.76,0.00,0.00,11.36,6997.76,'2021-12-15 15:34:19','',''),(2291520,'1','179','933',413,'Retail Sale Id 1342219',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 16:12:25','',''),(2291569,'1','179','933',413,'Retail Sale Id 1342255',5999.84,0.00,0.00,9.74,5999.84,'2021-12-15 16:17:06','',''),(2291796,'1','179','933',413,'Retail Sale Id 1342470',2002.00,0.00,0.00,3.25,2002.00,'2021-12-15 16:37:47','',''),(2291876,'1','179','933',413,'Retail Sale Id 1342526',1503.04,0.00,0.00,2.44,1503.04,'2021-12-15 16:43:07','',''),(2291884,'1','179','933',413,'Retail Sale Id 1342533',7700.00,0.00,0.00,12.50,7700.00,'2021-12-15 16:44:01','',''),(2291964,'1','179','933',413,'Retail Sale Id 1342613',1232.00,0.00,0.00,2.00,1232.00,'2021-12-15 16:50:41','',''),(2292135,'1','179','933',413,'Retail Sale Id 1342764',7700.00,0.00,0.00,12.50,7700.00,'2021-12-15 17:09:30','',''),(2292146,'1','179','933',413,'Retail Sale Id 1342775',1232.00,0.00,0.00,2.00,1232.00,'2021-12-15 17:11:02','',''),(2292242,'1','179','933',413,'Retail Sale Id 1342857',2500.96,0.00,0.00,4.06,2500.96,'2021-12-15 17:24:07','',''),(2292264,'1','179','933',413,'Retail Sale Id 1342872',7084.00,0.00,0.00,11.50,7084.00,'2021-12-15 17:28:08','',''),(2292279,'1','179','933',413,'Retail Sale Id 1342886',1848.00,0.00,0.00,3.00,1848.00,'2021-12-15 17:30:33','',''),(2292418,'1','179','933',413,'Retail Sale Id 1343009',3696.00,0.00,0.00,6.00,3696.00,'2021-12-15 17:58:22','',''),(2292568,'1','179','933',413,'Retail Sale Id 1343091',4312.00,0.00,0.00,7.00,4312.00,'2021-12-15 18:21:30','',''),(2292588,'1','179','933',413,'Retail Sale Id 1343105',2002.00,0.00,0.00,3.25,2002.00,'2021-12-15 18:25:27','',''),(2292622,'1','179','933',413,'Retail Sale Id 1343135',8697.92,0.00,0.00,14.12,8697.92,'2021-12-15 18:50:16','',''),(2294023,'1','179','933',413,'Retail Sale Id 1343986',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 07:43:22','',''),(2294215,'1','179','933',413,'Retail Sale Id 1344082',997.92,0.00,0.00,1.62,997.92,'2021-12-16 07:54:12','',''),(2294630,'1','179','933',413,'Retail Sale Id 1344393',5001.92,0.00,0.00,8.12,5001.92,'2021-12-16 08:24:21','',''),(2294984,'1','179','933',413,'Retail Sale Id 1344641',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 08:52:06','',''),(2295570,'1','179','933',413,'Retail Sale Id 1345156',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 09:46:30','',''),(2295621,'1','179','933',413,'Retail Sale Id 1345204',3696.00,0.00,0.00,6.00,3696.00,'2021-12-16 09:51:47','',''),(2295856,'1','179','933',413,'Retail Sale Id 1345330',3850.00,0.00,0.00,6.25,3850.00,'2021-12-16 10:08:10','',''),(2296158,'1','179','933',413,'Retail Sale Id 1345629',3080.00,0.00,0.00,5.00,3080.00,'2021-12-16 10:43:33','',''),(2296172,'1','179','933',413,'Retail Sale Id 1345647',2156.00,0.00,0.00,3.50,2156.00,'2021-12-16 10:45:12','',''),(2296416,'1','179','933',413,'Retail Sale Id 1345881',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 11:12:18','',''),(2296495,'1','179','933',413,'Retail Sale Id 1345942',1503.04,0.00,0.00,2.44,1503.04,'2021-12-16 11:20:52','',''),(2299082,'1','179','933',413,'Retail Sale Id 1348020',15030.40,0.00,0.00,24.40,15030.40,'2021-12-16 15:35:30','',''),(2299158,'1','179','933',413,'Retail Sale Id 1348098',25194.40,0.00,0.00,40.90,25194.40,'2021-12-16 15:42:06','',''),(2299227,'1','179','933',413,'Retail Sale Id 1348153',1848.00,0.00,0.00,3.00,1848.00,'2021-12-16 15:47:01','',''),(2299447,'1','179','933',413,'Retail Sale Id 1348301',3080.00,0.00,0.00,5.00,3080.00,'2021-12-16 16:00:56','',''),(2299485,'1','179','933',413,'Retail Sale Id 1348338',2999.92,0.00,0.00,4.87,2999.92,'2021-12-16 16:04:06','',''),(2299506,'1','179','933',413,'Retail Sale Id 1348354',1232.00,0.00,0.00,2.00,1232.00,'2021-12-16 16:06:00','',''),(2299747,'1','179','933',413,'Retail Sale Id 1348509',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 16:20:10','',''),(2299860,'1','179','933',413,'Retail Sale Id 1348619',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 16:29:45','',''),(2299882,'1','179','933',413,'Retail Sale Id 1348640',4447.52,0.00,0.00,7.22,4447.52,'2021-12-16 16:31:28','',''),(2299978,'1','179','933',413,'Retail Sale Id 1348732',3696.00,0.00,0.00,6.00,3696.00,'2021-12-16 16:41:32','',''),(2300032,'1','179','933',413,'Retail Sale Id 1348784',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 16:46:34','',''),(2300075,'1','179','933',413,'Retail Sale Id 1348827',2002.00,0.00,0.00,3.25,2002.00,'2021-12-16 16:51:09','',''),(2300121,'1','179','933',413,'Retail Sale Id 1348870',3080.00,0.00,0.00,5.00,3080.00,'2021-12-16 16:56:17','',''),(2300148,'1','179','933',413,'Retail Sale Id 1348881',5001.92,0.00,0.00,8.12,5001.92,'2021-12-16 16:57:43','',''),(2300195,'1','179','933',413,'Retail Sale Id 1348920',997.92,0.00,0.00,1.62,997.92,'2021-12-16 17:03:35','',''),(2300229,'1','179','933',413,'Retail Sale Id 1348949',3696.00,0.00,0.00,6.00,3696.00,'2021-12-16 17:09:15','',''),(2300237,'1','179','933',413,'Retail Sale Id 1348955',1232.00,0.00,0.00,2.00,1232.00,'2021-12-16 17:10:19','',''),(2300254,'1','179','933',413,'Retail Sale Id 1348966',997.92,0.00,0.00,1.62,997.92,'2021-12-16 17:11:44','',''),(2300265,'1','179','933',413,'Retail Sale Id 1348975',3696.00,0.00,0.00,6.00,3696.00,'2021-12-16 17:12:48','',''),(2300474,'1','179','933',413,'Retail Sale Id 1349128',2999.92,0.00,0.00,4.87,2999.92,'2021-12-16 17:40:42','',''),(2300514,'1','179','933',413,'Retail Sale Id 1349162',7700.00,0.00,0.00,12.50,7700.00,'2021-12-16 17:47:13','',''),(2300725,'1','179','933',413,'Retail Sale Id 1349323',1232.00,0.00,0.00,2.00,1232.00,'2021-12-16 18:50:46','',''),(2302020,'1','179','933',413,'Retail Sale Id 1349988',997.92,0.00,0.00,1.62,997.92,'2021-12-17 07:30:08','',''),(2302084,'1','179','933',413,'Retail Sale Id 1350052',3696.00,0.00,0.00,6.00,3696.00,'2021-12-17 07:37:32','',''),(2302259,'1','179','933',413,'Retail Sale Id 1350179',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 07:53:43','',''),(2302377,'1','179','933',413,'Retail Sale Id 1350269',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 08:03:05','',''),(2302387,'1','179','933',413,'Retail Sale Id 1350279',2999.92,0.00,0.00,4.87,2999.92,'2021-12-17 08:03:48','',''),(2302482,'1','179','933',413,'Retail Sale Id 1350380',3696.00,0.00,0.00,6.00,3696.00,'2021-12-17 08:15:33','',''),(2302689,'1','179','933',413,'Retail Sale Id 1350562',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 08:32:35','',''),(2302781,'1','179','933',413,'Retail Sale Id 1350638',2464.00,0.00,0.00,4.00,2464.00,'2021-12-17 08:40:57','',''),(2303231,'1','179','933',413,'Retail Sale Id 1350915',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 09:15:04','',''),(2303369,'1','179','933',413,'Retail Sale Id 1351024',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 09:27:57','',''),(2303467,'1','179','933',413,'Retail Sale Id 1351095',3080.00,0.00,0.00,5.00,3080.00,'2021-12-17 09:35:09','',''),(2304056,'1','179','933',413,'Retail Sale Id 1351634',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 10:35:33','',''),(2304072,'1','179','933',413,'Retail Sale Id 1351651',1232.00,0.00,0.00,2.00,1232.00,'2021-12-17 10:37:28','',''),(2304161,'1','179','933',413,'Retail Sale Id 1351745',2002.00,0.00,0.00,3.25,2002.00,'2021-12-17 10:48:57','',''),(2304234,'1','179','933',413,'Retail Sale Id 1351811',3080.00,0.00,0.00,5.00,3080.00,'2021-12-17 10:58:14','',''),(2304803,'1','179','933',413,'Retail Sale Id 1352345',997.92,0.00,0.00,1.62,997.92,'2021-12-17 11:54:44','',''),(2304804,'1','179','933',413,'Retail Sale Id 1352345',2002.00,0.00,0.00,3.25,2002.00,'2021-12-17 11:54:44','',''),(2304808,'1','179','933',413,'Retail Sale Id 1352350',3080.00,0.00,0.00,5.00,3080.00,'2021-12-17 11:55:36','',''),(2304815,'1','179','933',413,'Retail Sale Id 1352355',997.92,0.00,0.00,1.62,997.92,'2021-12-17 11:56:32','',''),(2304952,'1','179','933',413,'Retail Sale Id 1352460',9548.00,0.00,0.00,15.50,9548.00,'2021-12-17 12:13:40','',''),(2305210,'1','179','933',413,'Retail Sale Id 1352642',7700.00,0.00,0.00,12.50,7700.00,'2021-12-17 12:53:13','',''),(2305221,'1','179','933',413,'Retail Sale Id 1352735',2002.00,0.00,0.00,3.25,2002.00,'2021-12-17 12:55:31','',''),(2305336,'1','179','933',413,'Retail Sale Id 1352845',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 13:12:14','',''),(2306052,'1','179','933',413,'Retail Sale Id 1353438',2999.92,0.00,0.00,4.87,2999.92,'2021-12-17 14:32:38','',''),(2306218,'1','179','933',413,'Retail Sale Id 1353560',2002.00,0.00,0.00,3.25,2002.00,'2021-12-17 14:44:39','',''),(2306530,'1','179','933',413,'Retail Sale Id 1353803',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 15:12:07','',''),(2306542,'1','179','933',413,'Retail Sale Id 1353818',3696.00,0.00,0.00,6.00,3696.00,'2021-12-17 15:13:16','',''),(2306795,'1','179','933',413,'Retail Sale Id 1354004',997.92,0.00,0.00,1.62,997.92,'2021-12-17 15:31:27','',''),(2307007,'1','179','933',413,'Retail Sale Id 1351740',1232.00,0.00,0.00,2.00,1232.00,'2021-12-17 15:45:23','',''),(2307031,'1','179','933',413,'Retail Sale Id 1354171',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 15:46:51','',''),(2307063,'1','179','933',413,'Retail Sale Id 1354204',4681.60,0.00,0.00,7.60,4681.60,'2021-12-17 15:48:56','',''),(2307162,'1','179','933',413,'Retail Sale Id 1354318',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 15:58:05','',''),(2307181,'1','179','933',413,'Retail Sale Id 1354336',3696.00,0.00,0.00,6.00,3696.00,'2021-12-17 15:59:38','',''),(2307192,'1','179','933',413,'Retail Sale Id 1354347',1503.04,0.00,0.00,2.44,1503.04,'2021-12-17 16:01:02','',''),(2308122,'1','179','933',413,'Retail Sale Id 1355180',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 17:43:38','',''),(2308288,'1','179','933',413,'Retail Sale Id 1355280',3080.00,0.00,0.00,5.00,3080.00,'2021-12-17 18:05:40','',''),(2308292,'1','179','933',413,'Retail Sale Id 1355284',2999.92,0.00,0.00,4.87,2999.92,'2021-12-17 18:06:43','',''),(2308364,'1','179','933',413,'Retail Sale Id 1355339',2002.00,0.00,0.00,3.25,2002.00,'2021-12-17 18:25:38','',''),(2308374,'1','179','933',413,'Retail Sale Id 1355348',7700.00,0.00,0.00,12.50,7700.00,'2021-12-17 18:29:12','',''),(2308391,'1','179','933',413,'Retail Sale Id 1355361',616.00,0.00,0.00,1.00,616.00,'2021-12-17 18:33:57','',''),(2308394,'1','179','933',413,'Retail Sale Id 1355366',3080.00,0.00,0.00,5.00,3080.00,'2021-12-17 18:36:02','',''),(2308485,'1','179','933',413,'Retail Sale Id 1355399',1848.00,0.00,0.00,3.00,1848.00,'2021-12-17 18:58:25','',''),(2308512,'1','179','933',413,'Retail Sale Id 1355408',8316.00,0.00,0.00,13.50,8316.00,'2021-12-17 19:10:43','',''),(2309845,'1','179','933',413,'Retail Sale Id 1356114',997.92,0.00,0.00,1.62,997.92,'2021-12-18 07:30:07','',''),(2309851,'1','179','933',413,'Retail Sale Id 1356119',2999.92,0.00,0.00,4.87,2999.92,'2021-12-18 07:30:55','',''),(2310221,'1','179','933',413,'Retail Sale Id 1356428',9240.00,0.00,0.00,15.00,9240.00,'2021-12-18 08:03:01','',''),(2310254,'1','179','933',413,'Retail Sale Id 1356454',8999.76,0.00,0.00,14.61,8999.76,'2021-12-18 08:05:38','',''),(2310263,'1','179','933',413,'Retail Sale Id 1356462',997.92,0.00,0.00,1.62,997.92,'2021-12-18 08:06:33','',''),(2310577,'1','179','933',413,'Retail Sale Id 1356688',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 08:28:53','',''),(2310596,'1','179','933',413,'Retail Sale Id 1356702',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 08:30:20','',''),(2310806,'1','179','933',413,'Retail Sale Id 1356898',2002.00,0.00,0.00,3.25,2002.00,'2021-12-18 08:48:59','',''),(2311319,'1','179','933',413,'Retail Sale Id 1357332',3498.88,0.00,0.00,5.68,3498.88,'2021-12-18 09:31:05','',''),(2311343,'1','179','933',413,'Retail Sale Id 1357352',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 09:33:47','',''),(2311360,'1','179','933',413,'Retail Sale Id 1357379',6776.00,0.00,0.00,11.00,6776.00,'2021-12-18 09:35:25','',''),(2311547,'1','179','933',413,'Retail Sale Id 1357558',616.00,0.00,0.00,1.00,616.00,'2021-12-18 09:52:55','',''),(2311629,'1','179','933',413,'Retail Sale Id 1357600',3080.00,0.00,0.00,5.00,3080.00,'2021-12-18 09:57:07','',''),(2311953,'1','179','933',413,'Retail Sale Id 1357860',7700.00,0.00,0.00,12.50,7700.00,'2021-12-18 10:25:37','',''),(2312261,'1','179','933',413,'Retail Sale Id 1358146',6997.76,0.00,0.00,11.36,6997.76,'2021-12-18 10:50:34','',''),(2312330,'1','179','933',413,'Retail Sale Id 1358216',1503.04,0.00,0.00,2.44,1503.04,'2021-12-18 10:56:34','',''),(2312377,'1','179','933',413,'Retail Sale Id 1358253',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 11:00:12','',''),(2312412,'1','179','933',413,'Retail Sale Id 1358284',1503.04,0.00,0.00,2.44,1503.04,'2021-12-18 11:03:31','',''),(2312723,'1','179','933',413,'Retail Sale Id 1358540',1232.00,0.00,0.00,2.00,1232.00,'2021-12-18 11:25:48','',''),(2312837,'1','179','933',413,'Retail Sale Id 1358648',2156.00,0.00,0.00,3.50,2156.00,'2021-12-18 11:34:55','',''),(2313020,'1','179','933',413,'Retail Sale Id 1358830',997.92,0.00,0.00,1.62,997.92,'2021-12-18 11:54:28','',''),(2313166,'1','179','933',413,'Retail Sale Id 1358960',6160.00,0.00,0.00,10.00,6160.00,'2021-12-18 12:10:42','',''),(2313183,'1','179','933',413,'Retail Sale Id 1358979',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 12:11:55','',''),(2313257,'1','179','933',413,'Retail Sale Id 1359054',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 12:19:29','',''),(2313476,'1','179','933',413,'Retail Sale Id 1359244',1503.04,0.00,0.00,2.44,1503.04,'2021-12-18 12:41:45','',''),(2313489,'1','179','933',413,'Retail Sale Id 1359257',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 12:42:55','',''),(2313969,'1','179','933',413,'Retail Sale Id 1359682',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 13:25:29','',''),(2314092,'1','179','933',413,'Retail Sale Id 1359811',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 13:40:06','',''),(2314110,'1','179','933',413,'Retail Sale Id 1359829',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 13:41:29','',''),(2314155,'1','179','933',413,'Retail Sale Id 1359847',7700.00,0.00,0.00,12.50,7700.00,'2021-12-18 13:43:50','',''),(2314350,'1','179','933',413,'Retail Sale Id 1359953',3997.84,0.00,0.00,6.49,3997.84,'2021-12-18 13:54:01','',''),(2314446,'1','179','933',413,'Retail Sale Id 1360039',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 14:02:14','',''),(2314710,'1','179','933',413,'Retail Sale Id 1360265',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 14:23:56','',''),(2314895,'1','179','933',413,'Retail Sale Id 1360423',3080.00,0.00,0.00,5.00,3080.00,'2021-12-18 14:38:14','',''),(2315070,'1','179','933',413,'Retail Sale Id 1360559',997.92,0.00,0.00,1.62,997.92,'2021-12-18 14:52:26','',''),(2315341,'1','179','933',413,'Retail Sale Id 1360790',2999.92,0.00,0.00,4.87,2999.92,'2021-12-18 15:15:56','',''),(2315392,'1','179','933',413,'Retail Sale Id 1360835',2999.92,0.00,0.00,4.87,2999.92,'2021-12-18 15:20:05','',''),(2315843,'1','179','933',413,'Retail Sale Id 1361211',7700.00,0.00,0.00,12.50,7700.00,'2021-12-18 15:51:01','',''),(2315876,'1','179','933',413,'Retail Sale Id 1361233',616.00,0.00,0.00,1.00,616.00,'2021-12-18 15:52:47','',''),(2315932,'1','179','933',413,'Retail Sale Id 1361289',2002.00,0.00,0.00,3.25,2002.00,'2021-12-18 15:56:19','',''),(2316140,'1','179','933',413,'Retail Sale Id 1361463',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 16:08:38','',''),(2316184,'1','179','933',413,'Retail Sale Id 1361500',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 16:11:44','',''),(2316282,'1','179','933',413,'Retail Sale Id 1361585',3080.00,0.00,0.00,5.00,3080.00,'2021-12-18 16:18:04','',''),(2316473,'1','179','933',413,'Retail Sale Id 1361775',9997.68,0.00,0.00,16.23,9997.68,'2021-12-18 16:32:56','',''),(2316615,'1','179','933',413,'Retail Sale Id 1361926',3696.00,0.00,0.00,6.00,3696.00,'2021-12-18 16:44:08','',''),(2317166,'1','179','933',413,'Retail Sale Id 1362438',5001.92,0.00,0.00,8.12,5001.92,'2021-12-18 17:44:22','',''),(2317172,'1','179','933',413,'Retail Sale Id 1362441',1848.00,0.00,0.00,3.00,1848.00,'2021-12-18 17:45:13','',''),(2317404,'1','179','933',413,'Retail Sale Id 1362623',2999.92,0.00,0.00,4.87,2999.92,'2021-12-18 18:21:02','',''),(2317456,'1','179','933',413,'Retail Sale Id 1362663',3080.00,0.00,0.00,5.00,3080.00,'2021-12-18 18:37:04','',''),(2318742,'1','179','933',413,'Retail Sale Id 1363498',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 07:42:04','',''),(2319002,'1','179','933',413,'Retail Sale Id 1363681',9856.00,0.00,0.00,16.00,9856.00,'2021-12-19 08:02:47','',''),(2319032,'1','179','933',413,'Retail Sale Id 1363707',2002.00,0.00,0.00,3.25,2002.00,'2021-12-19 08:05:12','',''),(2319267,'1','179','933',413,'Retail Sale Id 1363889',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 08:25:57','',''),(2319287,'1','179','933',413,'Retail Sale Id 1363921',1201.20,0.00,0.00,1.95,1201.20,'2021-12-19 08:27:37','',''),(2319474,'1','179','933',413,'Retail Sale Id 1364039',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 08:38:29','',''),(2319749,'1','179','933',413,'Retail Sale Id 1364267',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 09:08:50','',''),(2319971,'1','179','933',413,'Retail Sale Id 1364387',2500.96,0.00,0.00,4.06,2500.96,'2021-12-19 09:21:03','',''),(2320008,'1','179','933',413,'Retail Sale Id 1364402',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 09:22:38','',''),(2320130,'1','179','933',413,'Retail Sale Id 1364468',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 09:27:26','',''),(2320872,'1','179','933',413,'Retail Sale Id 1365180',1503.04,0.00,0.00,2.44,1503.04,'2021-12-19 10:26:18','',''),(2320903,'1','179','933',413,'Retail Sale Id 1365217',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 10:28:51','',''),(2321356,'1','179','933',413,'Retail Sale Id 1365664',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 11:07:52','',''),(2321709,'1','179','933',413,'Retail Sale Id 1365991',1798.72,0.00,0.00,2.92,1798.72,'2021-12-19 11:36:31','',''),(2321917,'1','179','933',413,'Retail Sale Id 1366173',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 11:52:54','',''),(2322205,'1','179','933',413,'Retail Sale Id 1366466',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 12:18:21','',''),(2322245,'1','179','933',413,'Retail Sale Id 1366502',3080.00,0.00,0.00,5.00,3080.00,'2021-12-19 12:21:39','',''),(2322761,'1','179','933',413,'Retail Sale Id 1366984',997.92,0.00,0.00,1.62,997.92,'2021-12-19 13:09:54','',''),(2322779,'1','179','933',413,'Retail Sale Id 1366998',997.92,0.00,0.00,1.62,997.92,'2021-12-19 13:10:53','',''),(2322906,'1','179','933',413,'Retail Sale Id 1367110',2772.00,0.00,0.00,4.50,2772.00,'2021-12-19 13:22:55','',''),(2322956,'1','179','933',413,'Retail Sale Id 1367160',3080.00,0.00,0.00,5.00,3080.00,'2021-12-19 13:26:49','',''),(2323204,'1','179','933',413,'Retail Sale Id 1367334',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 13:43:36','',''),(2323250,'1','179','933',413,'Retail Sale Id 1367370',3498.88,0.00,0.00,5.68,3498.88,'2021-12-19 13:48:04','',''),(2323780,'1','179','933',413,'Retail Sale Id 1367808',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 14:27:26','',''),(2323821,'1','179','933',413,'Retail Sale Id 1367847',2002.00,0.00,0.00,3.25,2002.00,'2021-12-19 14:30:18','',''),(2323822,'1','179','933',413,'Retail Sale Id 1367847',2002.00,0.00,0.00,3.25,2002.00,'2021-12-19 14:30:18','',''),(2323836,'1','179','933',413,'Retail Sale Id 1367858',1232.00,0.00,0.00,2.00,1232.00,'2021-12-19 14:31:15','',''),(2323879,'1','179','933',413,'Retail Sale Id 1367899',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 14:35:45','',''),(2323984,'1','179','933',413,'Retail Sale Id 1367994',5001.92,0.00,0.00,8.12,5001.92,'2021-12-19 14:45:05','',''),(2324012,'1','179','933',413,'Retail Sale Id 1368021',2002.00,0.00,0.00,3.25,2002.00,'2021-12-19 14:47:32','',''),(2324092,'1','179','933',413,'Retail Sale Id 1368087',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 14:56:32','',''),(2324099,'1','179','933',413,'Retail Sale Id 1368112',3080.00,0.00,0.00,5.00,3080.00,'2021-12-19 14:57:35','',''),(2324604,'1','179','933',413,'Retail Sale Id 1368572',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 15:49:14','',''),(2324643,'1','179','933',413,'Retail Sale Id 1368615',2002.00,0.00,0.00,3.25,2002.00,'2021-12-19 15:52:05','',''),(2324776,'1','179','933',413,'Retail Sale Id 1368705',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 16:01:37','',''),(2325081,'1','179','933',413,'Retail Sale Id 1368934',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 16:30:29','',''),(2325134,'1','179','933',413,'Retail Sale Id 1368978',702.24,0.00,0.00,1.14,702.24,'2021-12-19 16:34:26','',''),(2325264,'1','179','933',413,'Retail Sale Id 1369090',997.92,0.00,0.00,1.62,997.92,'2021-12-19 16:48:06','',''),(2325299,'1','179','933',413,'Retail Sale Id 1369121',997.92,0.00,0.00,1.62,997.92,'2021-12-19 16:53:06','',''),(2325374,'1','179','933',413,'Retail Sale Id 1369167',1503.04,0.00,0.00,2.44,1503.04,'2021-12-19 16:59:26','',''),(2325384,'1','179','933',413,'Retail Sale Id 1369177',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 17:00:25','',''),(2325438,'1','179','933',413,'Retail Sale Id 1369230',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 17:07:29','',''),(2325457,'1','179','933',413,'Retail Sale Id 1369254',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 17:09:54','',''),(2325552,'1','179','933',413,'Retail Sale Id 1369328',997.92,0.00,0.00,1.62,997.92,'2021-12-19 17:21:44','',''),(2325567,'1','179','933',413,'Retail Sale Id 1369344',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 17:27:02','',''),(2325577,'1','179','933',413,'Retail Sale Id 1369353',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 17:28:35','',''),(2325583,'1','179','933',413,'Retail Sale Id 1369358',7700.00,0.00,0.00,12.50,7700.00,'2021-12-19 17:29:52','',''),(2325617,'1','179','933',413,'Retail Sale Id 1369374',4928.00,0.00,0.00,8.00,4928.00,'2021-12-19 17:35:37','',''),(2325634,'1','179','933',413,'Retail Sale Id 1369388',1232.00,0.00,0.00,2.00,1232.00,'2021-12-19 17:40:49','',''),(2325702,'1','179','933',413,'Retail Sale Id 1369490',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 18:00:42','',''),(2325750,'1','179','933',413,'Retail Sale Id 1369528',1232.00,0.00,0.00,2.00,1232.00,'2021-12-19 18:24:17','',''),(2325773,'1','179','933',413,'Retail Sale Id 1369540',1848.00,0.00,0.00,3.00,1848.00,'2021-12-19 18:37:00','',''),(2325783,'1','179','933',413,'Retail Sale Id 1369541',3696.00,0.00,0.00,6.00,3696.00,'2021-12-19 18:39:05','',''),(2326740,'1','179','933',413,'Retail Sale Id 1369987',5001.92,0.00,0.00,8.12,5001.92,'2021-12-20 07:25:39','',''),(2326758,'1','179','933',413,'Retail Sale Id 1370005',1700.16,0.00,0.00,2.76,1700.16,'2021-12-20 07:28:39','',''),(2327285,'1','179','933',413,'Retail Sale Id 1370435',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 08:28:36','',''),(2327391,'1','179','933',413,'Retail Sale Id 1370533',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 08:40:58','',''),(2327696,'1','179','933',413,'Retail Sale Id 1370787',2802.80,0.00,0.00,4.55,2802.80,'2021-12-20 09:18:41','',''),(2327788,'1','179','933',413,'Retail Sale Id 1370848',2999.92,0.00,0.00,4.87,2999.92,'2021-12-20 09:28:54','',''),(2327857,'1','179','933',413,'Retail Sale Id 1370898',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 09:37:29','',''),(2327990,'1','179','933',413,'Retail Sale Id 1371012',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 09:54:45','',''),(2328038,'1','179','933',413,'Retail Sale Id 1371037',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 09:59:26','',''),(2328215,'1','179','933',413,'Retail Sale Id 1371189',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 10:23:29','',''),(2328452,'1','179','933',413,'Retail Sale Id 1371403',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 10:47:42','',''),(2328492,'1','179','933',413,'Retail Sale Id 1371442',3696.00,0.00,0.00,6.00,3696.00,'2021-12-20 10:52:53','',''),(2328506,'1','179','933',413,'Retail Sale Id 1371456',2002.00,0.00,0.00,3.25,2002.00,'2021-12-20 10:54:04','',''),(2328762,'1','179','933',413,'Retail Sale Id 1371694',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 11:17:58','',''),(2328910,'1','179','933',413,'Retail Sale Id 1371834',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 11:34:07','',''),(2329050,'1','179','933',413,'Retail Sale Id 1371977',3696.00,0.00,0.00,6.00,3696.00,'2021-12-20 11:49:46','',''),(2329287,'1','179','933',413,'Retail Sale Id 1372201',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 12:18:12','',''),(2329335,'1','179','933',413,'Retail Sale Id 1372229',2464.00,0.00,0.00,4.00,2464.00,'2021-12-20 12:20:34','',''),(2329452,'1','179','933',413,'Retail Sale Id 1372346',924.00,0.00,0.00,1.50,924.00,'2021-12-20 12:35:08','',''),(2329653,'1','179','933',413,'Retail Sale Id 1372442',924.00,0.00,0.00,1.50,924.00,'2021-12-20 12:47:01','',''),(2329950,'1','179','933',413,'Retail Sale Id 1372678',2002.00,0.00,0.00,3.25,2002.00,'2021-12-20 13:19:34','',''),(2329990,'1','179','933',413,'Retail Sale Id 1372687',997.92,0.00,0.00,1.62,997.92,'2021-12-20 13:20:49','',''),(2330127,'1','179','933',413,'Retail Sale Id 1372782',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 13:31:23','',''),(2330211,'1','179','933',413,'Retail Sale Id 1372832',3696.00,0.00,0.00,6.00,3696.00,'2021-12-20 13:38:32','',''),(2330390,'1','179','933',413,'Retail Sale Id 1372919',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 13:52:31','',''),(2330867,'1','179','933',413,'Retail Sale Id 1373271',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 14:36:02','',''),(2330883,'1','179','933',413,'Retail Sale Id 1373283',2002.00,0.00,0.00,3.25,2002.00,'2021-12-20 14:37:05','',''),(2330981,'1','179','933',413,'Retail Sale Id 1373348',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 14:44:35','',''),(2331009,'1','179','933',413,'Retail Sale Id 1373358',3819.20,0.00,0.00,6.20,3819.20,'2021-12-20 14:46:09','',''),(2331393,'1','179','933',413,'Retail Sale Id 1373703',30800.00,0.00,0.00,50.00,30800.00,'2021-12-20 15:26:59','',''),(2331417,'1','179','933',413,'Retail Sale Id 1373727',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 15:28:56','',''),(2331431,'1','179','933',413,'Retail Sale Id 1373738',997.92,0.00,0.00,1.62,997.92,'2021-12-20 15:30:00','',''),(2331496,'1','179','933',413,'Retail Sale Id 1373778',3080.00,0.00,0.00,5.00,3080.00,'2021-12-20 15:34:35','',''),(2331678,'1','179','933',413,'Retail Sale Id 1373921',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 15:50:04','',''),(2331721,'1','179','933',413,'Retail Sale Id 1373964',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 15:55:14','',''),(2331848,'1','179','933',413,'Retail Sale Id 1374092',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 16:07:34','',''),(2332055,'1','179','933',413,'Retail Sale Id 1374275',3997.84,0.00,0.00,6.49,3997.84,'2021-12-20 16:29:45','',''),(2332062,'1','179','933',413,'Retail Sale Id 1374281',2002.00,0.00,0.00,3.25,2002.00,'2021-12-20 16:30:38','',''),(2332178,'1','179','933',413,'Retail Sale Id 1374393',3696.00,0.00,0.00,6.00,3696.00,'2021-12-20 16:41:40','',''),(2332192,'1','179','933',413,'Retail Sale Id 1374400',924.00,0.00,0.00,1.50,924.00,'2021-12-20 16:42:49','',''),(2332303,'1','179','933',413,'Retail Sale Id 1374507',2999.92,0.00,0.00,4.87,2999.92,'2021-12-20 16:55:19','',''),(2332491,'1','179','933',413,'Retail Sale Id 1374665',3696.00,0.00,0.00,6.00,3696.00,'2021-12-20 17:18:29','',''),(2332499,'1','179','933',413,'Retail Sale Id 1374672',2500.96,0.00,0.00,4.06,2500.96,'2021-12-20 17:20:25','',''),(2332502,'1','179','933',413,'Retail Sale Id 1374675',1503.04,0.00,0.00,2.44,1503.04,'2021-12-20 17:21:21','',''),(2332885,'1','179','933',413,'Retail Sale Id 1374893',7700.00,0.00,0.00,12.50,7700.00,'2021-12-20 18:21:06','',''),(2332912,'1','179','933',413,'Retail Sale Id 1374898',1848.00,0.00,0.00,3.00,1848.00,'2021-12-20 18:26:18','',''),(2332938,'1','179','933',413,'Retail Sale Id 1374906',3696.00,0.00,0.00,6.00,3696.00,'2021-12-20 18:46:56','',''),(2334095,'1','179','933',413,'Retail Sale Id 1375595',1201.20,0.00,0.00,1.95,1201.20,'2021-12-21 07:42:49','',''),(2334123,'1','179','933',413,'Retail Sale Id 1375622',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 07:46:26','',''),(2334639,'1','179','933',413,'Retail Sale Id 1376058',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 08:40:40','',''),(2334816,'1','179','933',413,'Retail Sale Id 1376193',997.92,0.00,0.00,1.62,997.92,'2021-12-21 09:01:10','',''),(2334830,'1','179','933',413,'Retail Sale Id 1376206',3080.00,0.00,0.00,5.00,3080.00,'2021-12-21 09:02:52','',''),(2334839,'1','179','933',413,'Retail Sale Id 1376215',997.92,0.00,0.00,1.62,997.92,'2021-12-21 09:04:13','',''),(2334847,'1','179','933',413,'Retail Sale Id 1376223',7700.00,0.00,0.00,12.50,7700.00,'2021-12-21 09:05:03','',''),(2334850,'1','179','933',413,'Retail Sale Id 1376226',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 09:05:46','',''),(2334890,'1','179','933',413,'Retail Sale Id 1376264',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 09:10:49','',''),(2335344,'1','179','933',413,'Retail Sale Id 1376650',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 09:58:18','',''),(2335518,'1','179','933',413,'Retail Sale Id 1376817',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 10:22:14','',''),(2335614,'1','179','933',413,'Retail Sale Id 1376865',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 10:28:58','',''),(2336068,'1','179','933',413,'Retail Sale Id 1377203',2156.00,0.00,0.00,3.50,2156.00,'2021-12-21 11:13:05','',''),(2336411,'1','179','933',413,'Retail Sale Id 1377509',3080.00,0.00,0.00,5.00,3080.00,'2021-12-21 11:55:08','',''),(2336644,'1','179','933',413,'Retail Sale Id 1377714',3080.00,0.00,0.00,5.00,3080.00,'2021-12-21 12:22:23','',''),(2336685,'1','179','933',413,'Retail Sale Id 1377755',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 12:27:46','',''),(2336691,'1','179','933',413,'Retail Sale Id 1377761',997.92,0.00,0.00,1.62,997.92,'2021-12-21 12:28:51','',''),(2336865,'1','179','933',413,'Retail Sale Id 1377919',2999.92,0.00,0.00,4.87,2999.92,'2021-12-21 12:48:16','',''),(2337149,'1','179','933',413,'Retail Sale Id 1378167',7700.00,0.00,0.00,12.50,7700.00,'2021-12-21 13:16:09','',''),(2337186,'1','179','933',413,'Retail Sale Id 1378195',2002.00,0.00,0.00,3.25,2002.00,'2021-12-21 13:19:12','',''),(2337701,'1','179','933',413,'Retail Sale Id 1378585',1503.04,0.00,0.00,2.44,1503.04,'2021-12-21 14:03:59','',''),(2337728,'1','179','933',413,'Retail Sale Id 1378610',1848.00,0.00,0.00,3.00,1848.00,'2021-12-21 14:06:29','',''),(2337910,'1','179','933',413,'Retail Sale Id 1378735',1848.00,0.00,0.00,3.00,1848.00,'2021-12-21 14:20:10','',''),(2338073,'1','179','933',413,'Retail Sale Id 1378882',1798.72,0.00,0.00,2.92,1798.72,'2021-12-21 14:33:52','',''),(2338122,'1','179','933',413,'Retail Sale Id 1378928',1848.00,0.00,0.00,3.00,1848.00,'2021-12-21 14:38:52','',''),(2338137,'1','179','933',413,'Retail Sale Id 1378959',1232.00,0.00,0.00,2.00,1232.00,'2021-12-21 14:40:51','',''),(2338546,'1','179','933',413,'Retail Sale Id 1379319',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 15:13:55','',''),(2338570,'1','179','933',413,'Retail Sale Id 1379332',3696.00,0.00,0.00,6.00,3696.00,'2021-12-21 15:15:03','',''),(2338957,'1','179','933',413,'Retail Sale Id 1379624',1299.76,0.00,0.00,2.11,1299.76,'2021-12-21 15:42:23','',''),(2339283,'1','179','933',413,'Retail Sale Id 1379916',7700.00,0.00,0.00,12.50,7700.00,'2021-12-21 16:04:19','',''),(2339515,'1','179','933',413,'Retail Sale Id 1380130',3498.88,0.00,0.00,5.68,3498.88,'2021-12-21 16:21:17','',''),(2339548,'1','179','933',413,'Retail Sale Id 1380163',1848.00,0.00,0.00,3.00,1848.00,'2021-12-21 16:23:47','',''),(2339882,'1','179','933',413,'Retail Sale Id 1380475',3080.00,0.00,0.00,5.00,3080.00,'2021-12-21 16:52:00','',''),(2339983,'1','179','933',413,'Retail Sale Id 1380575',997.92,0.00,0.00,1.62,997.92,'2021-12-21 17:01:43','',''),(2339998,'1','179','933',413,'Retail Sale Id 1380589',2999.92,0.00,0.00,4.87,2999.92,'2021-12-21 17:02:40','',''),(2340101,'1','179','933',413,'Retail Sale Id 1380685',1232.00,0.00,0.00,2.00,1232.00,'2021-12-21 17:13:20','',''),(2341698,'1','179','933',413,'Retail Sale Id 1381594',1848.00,0.00,0.00,3.00,1848.00,'2021-12-22 07:06:18','',''),(2342046,'1','179','933',413,'Retail Sale Id 1381886',997.92,0.00,0.00,1.62,997.92,'2021-12-22 07:34:42','',''),(2342072,'1','179','933',413,'Retail Sale Id 1381915',1503.04,0.00,0.00,2.44,1503.04,'2021-12-22 07:37:45','',''),(2342303,'1','179','933',413,'Retail Sale Id 1382071',6776.00,0.00,0.00,11.00,6776.00,'2021-12-22 07:51:30','',''),(2342335,'1','179','933',413,'Retail Sale Id 1382102',1848.00,0.00,0.00,3.00,1848.00,'2021-12-22 07:53:38','',''),(2342389,'1','179','933',413,'Retail Sale Id 1382143',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 07:56:48','',''),(2342608,'1','179','933',413,'Retail Sale Id 1382322',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 08:10:42','',''),(2342675,'1','179','933',413,'Retail Sale Id 1382370',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 08:14:29','',''),(2342970,'1','179','933',413,'Retail Sale Id 1382601',997.92,0.00,0.00,1.62,997.92,'2021-12-22 08:33:17','',''),(2343168,'1','179','933',413,'Retail Sale Id 1382775',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 08:51:37','',''),(2343229,'1','179','933',413,'Retail Sale Id 1382836',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 08:57:25','',''),(2343280,'1','179','933',413,'Retail Sale Id 1382883',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 09:02:24','',''),(2343901,'1','179','933',413,'Retail Sale Id 1383458',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 09:55:35','',''),(2343937,'1','179','933',413,'Retail Sale Id 1383491',1848.00,0.00,0.00,3.00,1848.00,'2021-12-22 09:58:27','',''),(2344167,'1','179','933',413,'Retail Sale Id 1383723',5001.92,0.00,0.00,8.12,5001.92,'2021-12-22 10:20:51','',''),(2344449,'1','179','933',413,'Retail Sale Id 1384005',5001.92,0.00,0.00,8.12,5001.92,'2021-12-22 10:50:16','',''),(2344475,'1','179','933',413,'Retail Sale Id 1384033',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 10:52:19','',''),(2344599,'1','179','933',413,'Retail Sale Id 1384151',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 11:02:56','',''),(2344632,'1','179','933',413,'Retail Sale Id 1384183',6160.00,0.00,0.00,10.00,6160.00,'2021-12-22 11:06:39','',''),(2344764,'1','179','933',413,'Retail Sale Id 1384308',3080.00,0.00,0.00,5.00,3080.00,'2021-12-22 11:19:34','',''),(2344923,'1','179','933',413,'Retail Sale Id 1384464',2464.00,0.00,0.00,4.00,2464.00,'2021-12-22 11:35:04','',''),(2345096,'1','179','933',413,'Retail Sale Id 1384624',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 11:52:03','',''),(2345110,'1','179','933',413,'Retail Sale Id 1384643',3080.00,0.00,0.00,5.00,3080.00,'2021-12-22 11:53:25','',''),(2345269,'1','179','933',413,'Retail Sale Id 1384795',15400.00,0.00,0.00,25.00,15400.00,'2021-12-22 12:10:12','',''),(2345644,'1','179','933',413,'Retail Sale Id 1385115',6776.00,0.00,0.00,11.00,6776.00,'2021-12-22 12:50:34','',''),(2346562,'1','179','933',413,'Retail Sale Id 1385764',2999.92,0.00,0.00,4.87,2999.92,'2021-12-22 14:10:05','',''),(2346715,'1','179','933',413,'Retail Sale Id 1385897',3080.00,0.00,0.00,5.00,3080.00,'2021-12-22 14:27:22','',''),(2347220,'1','179','933',413,'Retail Sale Id 1386308',1848.00,0.00,0.00,3.00,1848.00,'2021-12-22 15:16:46','',''),(2347235,'1','179','933',413,'Retail Sale Id 1386316',3997.84,0.00,0.00,6.49,3997.84,'2021-12-22 15:17:57','',''),(2347240,'1','179','933',413,'Retail Sale Id 1386325',1848.00,0.00,0.00,3.00,1848.00,'2021-12-22 15:18:34','',''),(2347333,'1','179','933',413,'Retail Sale Id 1386382',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 15:25:41','',''),(2347361,'1','179','933',413,'Retail Sale Id 1386396',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 15:27:06','',''),(2347497,'1','179','933',413,'Retail Sale Id 1386490',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 15:36:24','',''),(2347540,'1','179','933',413,'Retail Sale Id 1386528',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 15:39:13','',''),(2347562,'1','179','933',413,'Retail Sale Id 1386550',7700.00,0.00,0.00,12.50,7700.00,'2021-12-22 15:41:06','',''),(2347713,'1','179','933',413,'Retail Sale Id 1386688',3800.72,0.00,0.00,6.17,3800.72,'2021-12-22 15:54:27','',''),(2347950,'1','179','933',413,'Retail Sale Id 1386883',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 16:15:19','',''),(2347957,'1','179','933',413,'Retail Sale Id 1386891',997.92,0.00,0.00,1.62,997.92,'2021-12-22 16:16:09','',''),(2348337,'1','179','933',413,'Retail Sale Id 1387224',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 16:55:25','',''),(2348348,'1','179','933',413,'Retail Sale Id 1387234',1848.00,0.00,0.00,3.00,1848.00,'2021-12-22 16:56:29','',''),(2348360,'1','179','933',413,'Retail Sale Id 1387247',3080.00,0.00,0.00,5.00,3080.00,'2021-12-22 16:57:45','',''),(2348777,'1','179','933',413,'Retail Sale Id 1387580',3696.00,0.00,0.00,6.00,3696.00,'2021-12-22 18:03:09','',''),(2350021,'1','179','933',413,'Retail Sale Id 1388235',3080.00,0.00,0.00,5.00,3080.00,'2021-12-23 07:14:37','',''),(2350068,'1','179','933',413,'Retail Sale Id 1388260',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 07:17:54','',''),(2350106,'1','179','933',413,'Retail Sale Id 1388273',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 07:19:02','',''),(2350147,'1','179','933',413,'Retail Sale Id 1388291',1848.00,0.00,0.00,3.00,1848.00,'2021-12-23 07:21:10','',''),(2350188,'1','179','933',413,'Retail Sale Id 1388314',7700.00,0.00,0.00,12.50,7700.00,'2021-12-23 07:23:07','',''),(2350401,'1','179','933',413,'Retail Sale Id 1388460',3080.00,0.00,0.00,5.00,3080.00,'2021-12-23 07:36:34','',''),(2350485,'1','179','933',413,'Retail Sale Id 1388512',7700.00,0.00,0.00,12.50,7700.00,'2021-12-23 07:41:25','',''),(2350765,'1','179','933',413,'Retail Sale Id 1388747',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 08:06:09','',''),(2351154,'1','179','933',413,'Retail Sale Id 1389088',2500.96,0.00,0.00,4.06,2500.96,'2021-12-23 08:42:10','',''),(2351431,'1','179','933',413,'Retail Sale Id 1389350',1848.00,0.00,0.00,3.00,1848.00,'2021-12-23 09:09:41','',''),(2351812,'1','179','933',413,'Retail Sale Id 1389686',3080.00,0.00,0.00,5.00,3080.00,'2021-12-23 09:40:30','',''),(2351821,'1','179','933',413,'Retail Sale Id 1389696',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 09:41:22','',''),(2351858,'1','179','933',413,'Retail Sale Id 1389725',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 09:43:06','',''),(2351877,'1','179','933',413,'Retail Sale Id 1389744',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 09:44:43','',''),(2352179,'1','179','933',413,'Retail Sale Id 1389917',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 10:01:35','',''),(2352392,'1','179','933',413,'Retail Sale Id 1390132',7700.00,0.00,0.00,12.50,7700.00,'2021-12-23 10:21:44','',''),(2352885,'1','179','933',413,'Retail Sale Id 1390639',3080.00,0.00,0.00,5.00,3080.00,'2021-12-23 11:06:36','',''),(2352891,'1','179','933',413,'Retail Sale Id 1390646',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 11:07:35','',''),(2353177,'1','179','933',413,'Retail Sale Id 1390924',3080.00,0.00,0.00,5.00,3080.00,'2021-12-23 11:35:13','',''),(2353187,'1','179','933',413,'Retail Sale Id 1390934',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 11:36:12','',''),(2353495,'1','179','933',413,'Retail Sale Id 1391222',924.00,0.00,0.00,1.50,924.00,'2021-12-23 12:05:35','',''),(2353496,'1','179','933',413,'Retail Sale Id 1391222',1848.00,0.00,0.00,3.00,1848.00,'2021-12-23 12:05:35','',''),(2353649,'1','179','933',413,'Retail Sale Id 1391356',5001.92,0.00,0.00,8.12,5001.92,'2021-12-23 12:19:58','',''),(2353727,'1','179','933',413,'Retail Sale Id 1391420',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 12:25:49','',''),(2354319,'1','179','933',413,'Retail Sale Id 1391947',2002.00,0.00,0.00,3.25,2002.00,'2021-12-23 13:18:49','',''),(2354344,'1','179','933',413,'Retail Sale Id 1391983',2002.00,0.00,0.00,3.25,2002.00,'2021-12-23 13:20:43','',''),(2354421,'1','179','933',413,'Retail Sale Id 1392056',2002.00,0.00,0.00,3.25,2002.00,'2021-12-23 13:28:02','',''),(2354568,'1','179','933',413,'Retail Sale Id 1392176',1848.00,0.00,0.00,3.00,1848.00,'2021-12-23 13:39:29','',''),(2354615,'1','179','933',413,'Retail Sale Id 1392217',1232.00,0.00,0.00,2.00,1232.00,'2021-12-23 13:43:23','',''),(2354633,'1','179','933',413,'Retail Sale Id 1392244',1503.04,0.00,0.00,2.44,1503.04,'2021-12-23 13:45:01','',''),(2354721,'1','179','933',413,'Retail Sale Id 1392316',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 13:50:33','',''),(2354932,'1','179','933',413,'Retail Sale Id 1392450',2002.00,0.00,0.00,3.25,2002.00,'2021-12-23 14:04:34','',''),(2355431,'1','179','933',413,'Retail Sale Id 1392768',1503.04,0.00,0.00,2.44,1503.04,'2021-12-23 14:38:29','',''),(2355594,'1','179','933',413,'Retail Sale Id 1392925',7700.00,0.00,0.00,12.50,7700.00,'2021-12-23 14:56:21','',''),(2356020,'1','179','933',413,'Retail Sale Id 1393324',616.00,0.00,0.00,1.00,616.00,'2021-12-23 15:34:11','',''),(2356037,'1','179','933',413,'Retail Sale Id 1393343',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 15:35:47','',''),(2356047,'1','179','933',413,'Retail Sale Id 1393352',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 15:36:54','',''),(2356085,'1','179','933',413,'Retail Sale Id 1393369',997.92,0.00,0.00,1.62,997.92,'2021-12-23 15:39:18','',''),(2356143,'1','179','933',413,'Retail Sale Id 1393436',997.92,0.00,0.00,1.62,997.92,'2021-12-23 15:45:14','',''),(2356166,'1','179','933',413,'Retail Sale Id 1393459',1503.04,0.00,0.00,2.44,1503.04,'2021-12-23 15:47:07','',''),(2356183,'1','179','933',413,'Retail Sale Id 1393475',2002.00,0.00,0.00,3.25,2002.00,'2021-12-23 15:48:28','',''),(2356197,'1','179','933',413,'Retail Sale Id 1393494',1798.72,0.00,0.00,2.92,1798.72,'2021-12-23 15:49:45','',''),(2356262,'1','179','933',413,'Retail Sale Id 1393561',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 15:55:18','',''),(2356312,'1','179','933',413,'Retail Sale Id 1393608',3696.00,0.00,0.00,6.00,3696.00,'2021-12-23 16:00:17','',''),(2356325,'1','179','933',413,'Retail Sale Id 1393622',1848.00,0.00,0.00,3.00,1848.00,'2021-12-23 16:01:14','',''),(2356961,'1','179','933',413,'Retail Sale Id 1394259',2002.00,0.00,0.00,3.25,2002.00,'2021-12-23 16:59:01','',''),(2357057,'1','179','933',413,'Retail Sale Id 1394341',6160.00,0.00,0.00,10.00,6160.00,'2021-12-23 17:07:31','',''),(2357562,'1','179','933',413,'Retail Sale Id 1394712',2999.92,0.00,0.00,4.87,2999.92,'2021-12-23 18:05:38','',''),(2357606,'1','179','933',413,'Retail Sale Id 1394760',7700.00,0.00,0.00,12.50,7700.00,'2021-12-23 18:12:57','',''),(2357642,'1','179','933',413,'Retail Sale Id 1394780',1848.00,0.00,0.00,3.00,1848.00,'2021-12-23 18:17:56','',''),(2359269,'1','179','933',413,'Retail Sale Id 1395726',6160.00,0.00,0.00,10.00,6160.00,'2021-12-24 07:38:06','',''),(2359375,'1','179','933',413,'Retail Sale Id 1395834',7700.00,0.00,0.00,12.50,7700.00,'2021-12-24 07:48:28','',''),(2359654,'1','179','933',413,'Retail Sale Id 1396067',1540.00,0.00,0.00,2.50,1540.00,'2021-12-24 08:08:35','',''),(2360190,'1','179','933',413,'Retail Sale Id 1396517',7700.00,0.00,0.00,12.50,7700.00,'2021-12-24 08:48:10','',''),(2360203,'1','179','933',413,'Retail Sale Id 1396527',2199.12,0.00,0.00,3.57,2199.12,'2021-12-24 08:49:41','',''),(2360232,'1','179','933',413,'Retail Sale Id 1396567',1503.04,0.00,0.00,2.44,1503.04,'2021-12-24 08:51:41','',''),(2360822,'1','179','933',413,'Retail Sale Id 1397065',7700.00,0.00,0.00,12.50,7700.00,'2021-12-24 09:33:05','',''),(2360845,'1','179','933',413,'Retail Sale Id 1397087',2002.00,0.00,0.00,3.25,2002.00,'2021-12-24 09:34:56','',''),(2361022,'1','179','933',413,'Retail Sale Id 1397243',7700.00,0.00,0.00,12.50,7700.00,'2021-12-24 09:46:41','',''),(2361203,'1','179','933',413,'Retail Sale Id 1397361',1848.00,0.00,0.00,3.00,1848.00,'2021-12-24 09:55:25','',''),(2364366,'1','179','933',413,'Retail Sale Id 1400259',99915.20,0.00,0.00,162.20,99915.20,'2021-12-24 14:27:05','',''),(2364478,'1','179','933',413,'Retail Sale Id 1400340',677.60,0.00,0.00,1.10,677.60,'2021-12-24 14:36:18','',''),(2364989,'1','179','933',413,'Retail Sale Id 1400719',2999.92,0.00,0.00,4.87,2999.92,'2021-12-24 15:12:38','',''),(2365071,'1','179','933',413,'Retail Sale Id 1400765',3696.00,0.00,0.00,6.00,3696.00,'2021-12-24 15:16:27','',''),(2365315,'1','179','933',413,'Retail Sale Id 1401002',8001.84,0.00,0.00,12.99,8001.84,'2021-12-24 15:36:06','',''),(2365334,'1','179','933',413,'Retail Sale Id 1401022',1299.76,0.00,0.00,2.11,1299.76,'2021-12-24 15:37:28','',''),(2365359,'1','179','933',413,'Retail Sale Id 1401056',5236.00,0.00,0.00,8.50,5236.00,'2021-12-24 15:40:05','',''),(2365373,'1','179','933',413,'Retail Sale Id 1401073',7700.00,0.00,0.00,12.50,7700.00,'2021-12-24 15:41:26','',''),(2365617,'1','179','933',413,'Retail Sale Id 1401303',1848.00,0.00,0.00,3.00,1848.00,'2021-12-24 16:03:42','',''),(2365907,'1','179','933',413,'Retail Sale Id 1401468',7700.00,0.00,0.00,12.50,7700.00,'2021-12-24 16:17:07','',''),(2366035,'1','179','933',413,'Retail Sale Id 1401597',3080.00,0.00,0.00,5.00,3080.00,'2021-12-24 16:28:12','',''),(2366165,'1','179','933',413,'Retail Sale Id 1401722',3080.00,0.00,0.00,5.00,3080.00,'2021-12-24 16:37:18','',''),(2366231,'1','179','933',413,'Retail Sale Id 1401792',997.92,0.00,0.00,1.62,997.92,'2021-12-24 16:42:27','',''),(2366290,'1','179','933',413,'Retail Sale Id 1401834',3080.00,0.00,0.00,5.00,3080.00,'2021-12-24 16:45:50','',''),(2366493,'1','179','933',413,'Retail Sale Id 1402026',3696.00,0.00,0.00,6.00,3696.00,'2021-12-24 16:59:55','',''),(2366608,'1','179','933',413,'Retail Sale Id 1402133',1848.00,0.00,0.00,3.00,1848.00,'2021-12-24 17:07:37','',''),(2366643,'1','179','933',413,'Retail Sale Id 1402163',3080.00,0.00,0.00,5.00,3080.00,'2021-12-24 17:09:23','',''),(2367023,'1','179','933',413,'Retail Sale Id 1402498',2999.92,0.00,0.00,4.87,2999.92,'2021-12-24 17:45:06','',''),(2367032,'1','179','933',413,'Retail Sale Id 1402504',2500.96,0.00,0.00,4.06,2500.96,'2021-12-24 17:46:13','',''),(2367063,'1','179','933',413,'Retail Sale Id 1402535',997.92,0.00,0.00,1.62,997.92,'2021-12-24 17:49:43','',''),(2367170,'1','179','933',413,'Retail Sale Id 1402621',9116.80,0.00,0.00,14.80,9116.80,'2021-12-24 18:00:45','',''),(2367254,'1','179','933',413,'Retail Sale Id 1402661',800.80,0.00,0.00,1.30,800.80,'2021-12-24 18:07:48','',''),(2367412,'1','179','933',413,'Retail Sale Id 1402790',2002.00,0.00,0.00,3.25,2002.00,'2021-12-24 18:35:43','',''),(2368762,'1','179','933',413,'Retail Sale Id 1403616',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 07:28:38','',''),(2368795,'1','179','933',413,'Retail Sale Id 1403635',2464.00,0.00,0.00,4.00,2464.00,'2021-12-25 07:30:49','',''),(2368820,'1','179','933',413,'Retail Sale Id 1403664',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 07:33:28','',''),(2369023,'1','179','933',413,'Retail Sale Id 1403869',2999.92,0.00,0.00,4.87,2999.92,'2021-12-25 07:54:36','',''),(2369099,'1','179','933',413,'Retail Sale Id 1403940',4312.00,0.00,0.00,7.00,4312.00,'2021-12-25 08:01:14','',''),(2369116,'1','179','933',413,'Retail Sale Id 1403957',1503.04,0.00,0.00,2.44,1503.04,'2021-12-25 08:02:32','',''),(2369216,'1','179','933',413,'Retail Sale Id 1404048',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 08:10:42','',''),(2369262,'1','179','933',413,'Retail Sale Id 1404101',6160.00,0.00,0.00,10.00,6160.00,'2021-12-25 08:13:58','',''),(2369269,'1','179','933',413,'Retail Sale Id 1404106',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 08:14:56','',''),(2369442,'1','179','933',413,'Retail Sale Id 1404241',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 08:25:44','',''),(2369456,'1','179','933',413,'Retail Sale Id 1404252',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 08:26:47','',''),(2369466,'1','179','933',413,'Retail Sale Id 1404264',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 08:27:46','',''),(2369500,'1','179','933',413,'Retail Sale Id 1404289',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 08:29:59','',''),(2369799,'1','179','933',413,'Retail Sale Id 1404573',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 08:54:03','',''),(2369828,'1','179','933',413,'Retail Sale Id 1404594',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 08:55:49','',''),(2369857,'1','179','933',413,'Retail Sale Id 1404625',1503.04,0.00,0.00,2.44,1503.04,'2021-12-25 08:57:55','',''),(2369993,'1','179','933',413,'Retail Sale Id 1404769',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 09:11:39','',''),(2370224,'1','179','933',413,'Retail Sale Id 1404907',3080.00,0.00,0.00,5.00,3080.00,'2021-12-25 09:24:56','',''),(2370313,'1','179','933',413,'Retail Sale Id 1405009',2002.00,0.00,0.00,3.25,2002.00,'2021-12-25 09:34:12','',''),(2370327,'1','179','933',413,'Retail Sale Id 1405020',4502.96,0.00,0.00,7.31,4502.96,'2021-12-25 09:35:22','',''),(2370556,'1','179','933',413,'Retail Sale Id 1405237',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 09:57:51','',''),(2370586,'1','179','933',413,'Retail Sale Id 1405264',2999.92,0.00,0.00,4.87,2999.92,'2021-12-25 09:59:49','',''),(2370807,'1','179','933',413,'Retail Sale Id 1405458',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 10:23:02','',''),(2370850,'1','179','933',413,'Retail Sale Id 1405495',2500.96,0.00,0.00,4.06,2500.96,'2021-12-25 10:27:25','',''),(2370870,'1','179','933',413,'Retail Sale Id 1405508',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 10:29:02','',''),(2370941,'1','179','933',413,'Retail Sale Id 1405569',1232.00,0.00,0.00,2.00,1232.00,'2021-12-25 10:35:43','',''),(2370949,'1','179','933',413,'Retail Sale Id 1405579',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 10:36:34','',''),(2371049,'1','179','933',413,'Retail Sale Id 1405689',3997.84,0.00,0.00,6.49,3997.84,'2021-12-25 10:47:16','',''),(2371060,'1','179','933',413,'Retail Sale Id 1405701',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 10:48:40','',''),(2371228,'1','179','933',413,'Retail Sale Id 1405873',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 11:06:04','',''),(2371269,'1','179','933',413,'Retail Sale Id 1405907',3080.00,0.00,0.00,5.00,3080.00,'2021-12-25 11:09:00','',''),(2371286,'1','179','933',413,'Retail Sale Id 1405932',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 11:10:35','',''),(2371324,'1','179','933',413,'Retail Sale Id 1405973',7392.00,0.00,0.00,12.00,7392.00,'2021-12-25 11:14:29','',''),(2371341,'1','179','933',413,'Retail Sale Id 1405991',6160.00,0.00,0.00,10.00,6160.00,'2021-12-25 11:16:08','',''),(2371388,'1','179','933',413,'Retail Sale Id 1406044',1503.04,0.00,0.00,2.44,1503.04,'2021-12-25 11:20:36','',''),(2371401,'1','179','933',413,'Retail Sale Id 1406055',997.92,0.00,0.00,1.62,997.92,'2021-12-25 11:21:26','',''),(2371520,'1','179','933',413,'Retail Sale Id 1406252',997.92,0.00,0.00,1.62,997.92,'2021-12-25 11:36:53','',''),(2371838,'1','179','933',413,'Retail Sale Id 1406548',2002.00,0.00,0.00,3.25,2002.00,'2021-12-25 12:15:39','',''),(2371870,'1','179','933',413,'Retail Sale Id 1406579',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 12:19:12','',''),(2372027,'1','179','933',413,'Retail Sale Id 1406738',6160.00,0.00,0.00,10.00,6160.00,'2021-12-25 12:36:36','',''),(2372214,'1','179','933',413,'Retail Sale Id 1406900',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 12:56:45','',''),(2372525,'1','179','933',413,'Retail Sale Id 1407120',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 13:24:16','',''),(2372573,'1','179','933',413,'Retail Sale Id 1407146',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 13:27:28','',''),(2372663,'1','179','933',413,'Retail Sale Id 1407196',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 13:36:08','',''),(2372687,'1','179','933',413,'Retail Sale Id 1407212',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 13:38:37','',''),(2372749,'1','179','933',413,'Retail Sale Id 1407256',2002.00,0.00,0.00,3.25,2002.00,'2021-12-25 13:45:30','',''),(2372876,'1','179','933',413,'Retail Sale Id 1407303',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 13:52:44','',''),(2372913,'1','179','933',413,'Retail Sale Id 1407332',2002.00,0.00,0.00,3.25,2002.00,'2021-12-25 13:56:59','',''),(2372929,'1','179','933',413,'Retail Sale Id 1407346',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 13:59:41','',''),(2372962,'1','179','933',413,'Retail Sale Id 1407368',3080.00,0.00,0.00,5.00,3080.00,'2021-12-25 14:03:26','',''),(2372989,'1','179','933',413,'Retail Sale Id 1407389',3080.00,0.00,0.00,5.00,3080.00,'2021-12-25 14:06:40','',''),(2373015,'1','179','933',413,'Retail Sale Id 1407394',2500.96,0.00,0.00,4.06,2500.96,'2021-12-25 14:07:44','',''),(2373097,'1','179','933',413,'Retail Sale Id 1407426',1798.72,0.00,0.00,2.92,1798.72,'2021-12-25 14:13:28','',''),(2373608,'1','179','933',413,'Retail Sale Id 1407828',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 15:35:56','',''),(2373774,'1','179','933',413,'Retail Sale Id 1407970',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 15:56:04','',''),(2373904,'1','179','933',413,'Retail Sale Id 1408053',3080.00,0.00,0.00,5.00,3080.00,'2021-12-25 16:08:23','',''),(2373968,'1','179','933',413,'Retail Sale Id 1408118',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 16:19:25','',''),(2374022,'1','179','933',413,'Retail Sale Id 1408172',6776.00,0.00,0.00,11.00,6776.00,'2021-12-25 16:30:41','',''),(2374035,'1','179','933',413,'Retail Sale Id 1408183',1232.00,0.00,0.00,2.00,1232.00,'2021-12-25 16:33:51','',''),(2374040,'1','179','933',413,'Retail Sale Id 1408188',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 16:34:53','',''),(2374107,'1','179','933',413,'Retail Sale Id 1408246',1232.00,0.00,0.00,2.00,1232.00,'2021-12-25 16:53:35','',''),(2374184,'1','179','933',413,'Retail Sale Id 1408299',3850.00,0.00,0.00,6.25,3850.00,'2021-12-25 17:11:07','',''),(2374197,'1','179','933',413,'Retail Sale Id 1408311',7700.00,0.00,0.00,12.50,7700.00,'2021-12-25 17:16:40','',''),(2374256,'1','179','933',413,'Retail Sale Id 1408366',997.92,0.00,0.00,1.62,997.92,'2021-12-25 17:43:50','',''),(2374259,'1','179','933',413,'Retail Sale Id 1408368',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 17:44:45','',''),(2374267,'1','179','933',413,'Retail Sale Id 1408376',997.92,0.00,0.00,1.62,997.92,'2021-12-25 17:58:35','',''),(2374271,'1','179','933',413,'Retail Sale Id 1408378',3696.00,0.00,0.00,6.00,3696.00,'2021-12-25 18:00:50','',''),(2374276,'1','179','933',413,'Retail Sale Id 1408382',1848.00,0.00,0.00,3.00,1848.00,'2021-12-25 18:06:49','',''),(2375380,'1','179','933',413,'Retail Sale Id 1408850',1950.00,0.00,0.00,3.25,1950.00,'2021-12-26 07:50:58','',''),(2375388,'1','179','933',413,'Retail Sale Id 1408860',1800.00,0.00,0.00,3.00,1800.00,'2021-12-26 07:51:50','',''),(2375399,'1','179','933',413,'Retail Sale Id 1408870',3000.00,0.00,0.00,5.00,3000.00,'2021-12-26 07:53:17','',''),(2375424,'1','179','933',413,'Retail Sale Id 1408883',4800.00,0.00,0.00,8.00,4800.00,'2021-12-26 07:54:43','',''),(2375502,'1','179','933',413,'Retail Sale Id 1408922',3600.00,0.00,0.00,6.00,3600.00,'2021-12-26 07:58:18','',''),(2375536,'1','179','933',413,'Retail Sale Id 1408937',1950.00,0.00,0.00,3.25,1950.00,'2021-12-26 07:59:35','',''),(2375554,'1','179','933',413,'Retail Sale Id 1408958',2400.00,0.00,0.00,4.00,2400.00,'2021-12-26 08:01:50','',''),(2375762,'1','179','933',413,'Retail Sale Id 1409102',2400.00,0.00,0.00,4.00,2400.00,'2021-12-26 08:22:30','',''),(2375947,'1','179','933',413,'Retail Sale Id 1409274',3000.00,0.00,0.00,5.00,3000.00,'2021-12-26 08:43:48','',''),(2376025,'1','179','933',413,'Retail Sale Id 1409339',3600.00,0.00,0.00,6.00,3600.00,'2021-12-26 08:52:19','',''),(2376590,'1','179','933',413,'Retail Sale Id 1409774',6000.00,0.00,0.00,10.00,6000.00,'2021-12-26 09:51:35','',''),(2376602,'1','179','933',413,'Retail Sale Id 1409781',1998.00,0.00,0.00,3.33,1998.00,'2021-12-26 09:52:53','',''),(2376614,'1','179','933',413,'Retail Sale Id 1409793',6000.00,0.00,0.00,10.00,6000.00,'2021-12-26 09:54:12','',''),(2376796,'1','179','933',413,'Retail Sale Id 1409975',3498.00,0.00,0.00,5.83,3498.00,'2021-12-26 10:20:18','',''),(2376847,'1','179','933',413,'Retail Sale Id 1410022',2400.00,0.00,0.00,4.00,2400.00,'2021-12-26 10:26:46','',''),(2377029,'1','179','933',413,'Retail Sale Id 1410174',4002.00,0.00,0.00,6.67,4002.00,'2021-12-26 10:44:05','',''),(2377104,'1','179','933',413,'Retail Sale Id 1410253',1002.00,0.00,0.00,1.67,1002.00,'2021-12-26 10:54:34','',''),(2377375,'1','179','933',413,'Retail Sale Id 1410497',2400.00,0.00,0.00,4.00,2400.00,'2021-12-26 11:26:05','',''),(2377382,'1','179','933',413,'Retail Sale Id 1410504',7500.00,0.00,0.00,12.50,7500.00,'2021-12-26 11:27:09','',''),(2377435,'1','179','933',413,'Retail Sale Id 1410548',6498.00,0.00,0.00,10.83,6498.00,'2021-12-26 11:33:42','',''),(2377471,'1','179','933',413,'Retail Sale Id 1410583',2100.00,0.00,0.00,3.50,2100.00,'2021-12-26 11:38:09','',''),(2377544,'1','179','933',413,'Retail Sale Id 1410651',7500.00,0.00,0.00,12.50,7500.00,'2021-12-26 11:48:19','',''),(2377615,'1','179','933',413,'Retail Sale Id 1410696',1998.00,0.00,0.00,3.33,1998.00,'2021-12-26 11:55:50','',''),(2377903,'1','179','933',413,'Retail Sale Id 1410942',3600.00,0.00,0.00,6.00,3600.00,'2021-12-26 12:32:46','',''),(2377992,'1','179','933',413,'Retail Sale Id 1410994',1800.00,0.00,0.00,3.00,1800.00,'2021-12-26 12:39:30','',''),(2378002,'1','179','933',413,'Retail Sale Id 1411004',4998.00,0.00,0.00,8.33,4998.00,'2021-12-26 12:40:25','',''),(2378009,'1','179','933',413,'Retail Sale Id 1411012',1002.00,0.00,0.00,1.67,1002.00,'2021-12-26 12:41:17','',''),(2378040,'1','179','933',413,'Retail Sale Id 1411044',7500.00,0.00,0.00,12.50,7500.00,'2021-12-26 12:44:41','',''),(2378062,'1','179','933',413,'Retail Sale Id 1411067',1800.00,0.00,0.00,3.00,1800.00,'2021-12-26 12:47:48','',''),(2378208,'1','179','933',413,'Retail Sale Id 1411210',3600.00,0.00,0.00,6.00,3600.00,'2021-12-26 13:12:31','',''),(2378270,'1','179','933',413,'Retail Sale Id 1411254',1500.00,0.00,0.00,2.50,1500.00,'2021-12-26 13:19:55','',''),(2379920,'1','179','933',413,'Retail Sale Id 1412482',53040.00,0.00,0.00,88.40,53040.00,'2021-12-26 17:15:25','',''),(2379946,'1','179','933',413,'Retail Sale Id 1412513',2202.00,0.00,0.00,3.67,2202.00,'2021-12-26 17:29:45','',''),(2379990,'1','179','933',413,'Retail Sale Id 1412523',3600.00,0.00,0.00,6.00,3600.00,'2021-12-26 17:50:55','',''),(2379993,'1','179','933',413,'Retail Sale Id 1412525',1800.00,0.00,0.00,3.00,1800.00,'2021-12-26 17:52:52','',''),(2380004,'1','179','933',413,'Retail Sale Id 1412529',1800.00,0.00,0.00,3.00,1800.00,'2021-12-26 17:59:26','',''),(2380046,'1','179','933',413,'Retail Sale Id 1412562',3000.00,0.00,0.00,5.00,3000.00,'2021-12-26 18:36:45','',''),(2380724,'1','179',NULL,413,'Distributed to OPERATIONAL LOSS for sales id:342516',0.00,0.00,0.00,261.69,0.00,'2021-12-27 07:10:06','',''),(2380850,'1','179','933',413,'Retail Sale Id 1412883',7500.00,0.00,0.00,12.50,7500.00,'2021-12-27 07:28:02','',''),(2381198,'1','179','933',413,'Retail Sale Id 1413084',4800.00,0.00,0.00,8.00,4800.00,'2021-12-27 07:53:21','',''),(2381216,'1','179','933',413,'Retail Sale Id 1413101',3000.00,0.00,0.00,5.00,3000.00,'2021-12-27 07:55:04','',''),(2381535,'1','179','933',413,'Retail Sale Id 1413366',1002.00,0.00,0.00,1.67,1002.00,'2021-12-27 08:25:26','',''),(2381544,'1','179','933',413,'Retail Sale Id 1413377',1002.00,0.00,0.00,1.67,1002.00,'2021-12-27 08:26:21','',''),(2381564,'1','179','933',413,'Retail Sale Id 1413395',1200.00,0.00,0.00,2.00,1200.00,'2021-12-27 08:28:10','',''),(2381869,'1','179','933',413,'Retail Sale Id 1413675',1800.00,0.00,0.00,3.00,1800.00,'2021-12-27 08:53:47','',''),(2385083,'1','179','933',413,'Retail Sale Id 1416416',101160.00,0.00,0.00,168.60,101160.00,'2021-12-27 15:01:59','',''),(2385980,'1','179','933',413,'Retail Sale Id 1417182',53400.00,0.00,0.00,89.00,53400.00,'2021-12-27 17:24:15','',''),(2386141,'1','179','933',413,'Retail Sale Id 1417259',7500.00,0.00,0.00,12.50,7500.00,'2021-12-27 18:12:06','',''),(2386174,'1','179','933',413,'Retail Sale Id 1417265',1200.00,0.00,0.00,2.00,1200.00,'2021-12-27 18:19:21','',''),(2388067,'1','179','933',413,'Retail Sale Id 1418496',14310.00,0.00,0.00,23.85,14310.00,'2021-12-28 09:08:45','',''),(2391358,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,2703000.00,5100.00,0.00,0.00,'2021-12-28 14:40:58','',''),(2391364,'1','179',NULL,413,'Reception corrector for bridging 129015',0.00,0.00,0.00,5100.00,0.00,'2021-12-28 14:42:05','',''),(2391365,'1','179','933',413,'Received from bridging 129015',0.00,0.00,5100.00,0.00,0.00,'2021-12-28 14:42:05','',''),(2391428,'1','179','933',413,'Retail Sale Id 1421278',3600.00,0.00,0.00,6.00,420.00,'2021-12-28 14:50:31','',''),(2391482,'1','179','933',413,'Retail Sale Id 1421334',1800.00,0.00,0.00,3.00,210.00,'2021-12-28 14:59:09','',''),(2392748,'1','179','933',413,'Retail Sale Id 1421483',1998.00,0.00,0.00,3.33,233.10,'2021-12-28 17:24:45','',''),(2392771,'1','179','933',413,'Retail Sale Id 1422332',44400.00,0.00,0.00,74.00,5180.00,'2021-12-28 17:30:51','',''),(2392775,'1','179','933',413,'Retail Sale Id 1422334',7500.00,0.00,0.00,12.50,875.00,'2021-12-28 17:32:54','',''),(2392821,'1','179','933',413,'Retail Sale Id 1422365',3000.00,0.00,0.00,5.00,350.00,'2021-12-28 17:56:37','',''),(2392840,'1','179','933',413,'Retail Sale Id 1422375',1002.00,0.00,0.00,1.67,116.90,'2021-12-28 18:03:53','',''),(2392868,'1','179','933',413,'Retail Sale Id 1422387',7500.00,0.00,0.00,12.50,875.00,'2021-12-28 18:16:59','',''),(2392890,'1','179','933',413,'Retail Sale Id 1422399',1800.00,0.00,0.00,3.00,210.00,'2021-12-28 18:46:13','',''),(2393760,'1','179','933',413,'Retail Sale Id 1422754',1998.00,0.00,0.00,3.33,233.10,'2021-12-29 07:15:36','',''),(2394134,'1','179','933',413,'Retail Sale Id 1423021',3600.00,0.00,0.00,6.00,420.00,'2021-12-29 07:50:43','',''),(2394263,'1','179','933',413,'Retail Sale Id 1423109',4800.00,0.00,0.00,8.00,560.00,'2021-12-29 08:02:40','',''),(2394275,'1','179','933',413,'Retail Sale Id 1423118',1800.00,0.00,0.00,3.00,210.00,'2021-12-29 08:03:40','',''),(2394414,'1','179','933',413,'Retail Sale Id 1423233',3000.00,0.00,0.00,5.00,350.00,'2021-12-29 08:19:32','',''),(2395237,'1','179','933',413,'Retail Sale Id 1423915',3000.00,0.00,0.00,5.00,350.00,'2021-12-29 09:43:43','',''),(2395364,'1','179','933',413,'Retail Sale Id 1424025',7002.00,0.00,0.00,11.67,816.90,'2021-12-29 09:55:59','',''),(2399592,'1','179','933',413,'Retail Sale Id 1427345',75060.00,0.00,0.00,125.10,8757.00,'2021-12-29 18:27:50','',''),(2399594,'1','179','933',413,'Retail Sale Id 1427347',50580.00,0.00,0.00,84.30,5901.00,'2021-12-29 18:29:10','',''),(2399595,'1','179','933',413,'Retail Sale Id 1427349',3000.00,0.00,0.00,5.00,350.00,'2021-12-29 18:30:27','',''),(2399596,'1','179','933',413,'Retail Sale Id 1427350',1800.00,0.00,0.00,3.00,210.00,'2021-12-29 18:31:13','',''),(2399598,'1','179','933',413,'Retail Sale Id 1427351',15000.00,0.00,0.00,25.00,1750.00,'2021-12-29 18:34:52','',''),(2400564,'1','179','933',413,'Retail Sale Id 1427758',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 07:21:57','',''),(2400846,'1','179','933',413,'Retail Sale Id 1427971',1002.00,0.00,0.00,1.67,116.90,'2021-12-30 07:50:17','',''),(2400939,'1','179','933',413,'Retail Sale Id 1428057',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 08:00:30','',''),(2401235,'1','179','933',413,'Retail Sale Id 1428266',7500.00,0.00,0.00,12.50,875.00,'2021-12-30 08:25:19','',''),(2401367,'1','179','933',413,'Retail Sale Id 1428374',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 08:38:16','',''),(2401682,'1','179','933',413,'Retail Sale Id 1428581',1500.00,0.00,0.00,2.50,175.00,'2021-12-30 08:57:51','',''),(2401712,'1','179','933',413,'Retail Sale Id 1428599',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 09:00:13','',''),(2401965,'1','179','933',413,'Retail Sale Id 1428817',1398.00,0.00,0.00,2.33,163.10,'2021-12-30 09:24:00','',''),(2402004,'1','179','933',413,'Retail Sale Id 1428856',3000.00,0.00,0.00,5.00,350.00,'2021-12-30 09:27:31','',''),(2402023,'1','179','933',413,'Retail Sale Id 1428874',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 09:29:19','',''),(2402053,'1','179','933',413,'Retail Sale Id 1428900',1500.00,0.00,0.00,2.50,175.00,'2021-12-30 09:32:31','',''),(2402307,'1','179','933',413,'Retail Sale Id 1429116',3000.00,0.00,0.00,5.00,350.00,'2021-12-30 09:55:20','',''),(2402416,'1','179','933',413,'Retail Sale Id 1429227',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 10:05:48','',''),(2402430,'1','179','933',413,'Retail Sale Id 1429246',2502.00,0.00,0.00,4.17,291.90,'2021-12-30 10:07:20','',''),(2402459,'1','179','933',413,'Retail Sale Id 1429274',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 10:10:25','',''),(2402582,'1','179','933',413,'Retail Sale Id 1429396',1500.00,0.00,0.00,2.50,175.00,'2021-12-30 10:23:20','',''),(2402772,'1','179','933',413,'Retail Sale Id 1429541',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 10:39:06','',''),(2402793,'1','179','933',413,'Retail Sale Id 1429563',3498.00,0.00,0.00,5.83,408.10,'2021-12-30 10:41:49','',''),(2402881,'1','179','933',413,'Retail Sale Id 1429638',1998.00,0.00,0.00,3.33,233.10,'2021-12-30 10:51:08','',''),(2403063,'1','179','933',413,'Retail Sale Id 1429799',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 11:09:20','',''),(2403078,'1','179','933',413,'Retail Sale Id 1429811',10500.00,0.00,0.00,17.50,1225.00,'2021-12-30 11:11:12','',''),(2403203,'1','179','933',413,'Retail Sale Id 1429924',600.00,0.00,0.00,1.00,70.00,'2021-12-30 11:26:17','',''),(2403229,'1','179','933',413,'Retail Sale Id 1429947',2100.00,0.00,0.00,3.50,245.00,'2021-12-30 11:30:23','',''),(2403285,'1','179','933',413,'Retail Sale Id 1430004',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 11:38:32','',''),(2404577,'1','179','933',413,'Retail Sale Id 1431015',8580.00,0.00,0.00,14.30,1001.00,'2021-12-30 13:59:14','',''),(2404700,'1','179','933',413,'Retail Sale Id 1431117',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 14:12:54','',''),(2405066,'1','179','933',413,'Retail Sale Id 1431466',1398.00,0.00,0.00,2.33,163.10,'2021-12-30 14:53:27','',''),(2405633,'1','179','933',413,'Retail Sale Id 1431951',2400.00,0.00,0.00,4.00,280.00,'2021-12-30 15:51:44','',''),(2405761,'1','179','933',413,'Retail Sale Id 1432082',3498.00,0.00,0.00,5.83,408.10,'2021-12-30 16:03:39','',''),(2405768,'1','179','933',413,'Retail Sale Id 1432090',4998.00,0.00,0.00,8.33,583.10,'2021-12-30 16:04:40','',''),(2405843,'1','179','933',413,'Retail Sale Id 1432157',8100.00,0.00,0.00,13.50,945.00,'2021-12-30 16:10:34','',''),(2405905,'1','179','933',413,'Retail Sale Id 1432217',3000.00,0.00,0.00,5.00,350.00,'2021-12-30 16:16:09','',''),(2405960,'1','179','933',413,'Retail Sale Id 1432268',2400.00,0.00,0.00,4.00,280.00,'2021-12-30 16:21:31','',''),(2405966,'1','179','933',413,'Retail Sale Id 1432278',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 16:22:35','',''),(2406456,'1','179','933',413,'Retail Sale Id 1432672',4998.00,0.00,0.00,8.33,583.10,'2021-12-30 17:07:34','',''),(2406513,'1','179','933',413,'Retail Sale Id 1432707',9600.00,0.00,0.00,16.00,1120.00,'2021-12-30 17:15:23','',''),(2406536,'1','179','933',413,'Retail Sale Id 1432733',6000.00,0.00,0.00,10.00,700.00,'2021-12-30 17:18:33','',''),(2406636,'1','179','933',413,'Retail Sale Id 1432832',4998.00,0.00,0.00,8.33,583.10,'2021-12-30 17:51:06','',''),(2406649,'1','179','933',413,'Retail Sale Id 1432837',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 17:53:45','',''),(2406652,'1','179','933',413,'Retail Sale Id 1432838',1800.00,0.00,0.00,3.00,210.00,'2021-12-30 17:55:05','',''),(2406683,'1','179','933',413,'Retail Sale Id 1432856',6000.00,0.00,0.00,10.00,700.00,'2021-12-30 18:04:07','',''),(2406719,'1','179','933',413,'Retail Sale Id 1432871',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 18:17:58','',''),(2406755,'1','179','933',413,'Retail Sale Id 1432877',3600.00,0.00,0.00,6.00,420.00,'2021-12-30 18:24:25','',''),(2406766,'1','179','933',413,'Retail Sale Id 1432883',1998.00,0.00,0.00,3.33,233.10,'2021-12-30 18:57:38','',''),(2408139,'1','179','933',413,'Retail Sale Id 1433589',11400.00,0.00,0.00,19.00,1330.00,'2021-12-31 07:45:04','',''),(2408311,'1','179','933',413,'Retail Sale Id 1433715',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 08:00:00','',''),(2408379,'1','179','933',413,'Retail Sale Id 1433768',1002.00,0.00,0.00,1.67,116.90,'2021-12-31 08:05:30','',''),(2408592,'1','179','933',413,'Retail Sale Id 1433960',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 08:22:43','',''),(2408622,'1','179','933',413,'Retail Sale Id 1433986',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 08:25:23','',''),(2410134,'1','179','933',413,'Retail Sale Id 1435323',17700.00,0.00,0.00,29.50,2065.00,'2021-12-31 10:52:07','',''),(2410145,'1','179','933',413,'Retail Sale Id 1435334',7500.00,0.00,0.00,12.50,875.00,'2021-12-31 10:53:37','',''),(2410152,'1','179','933',413,'Retail Sale Id 1435341',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 10:54:45','',''),(2410196,'1','179','933',413,'Retail Sale Id 1435384',16500.00,0.00,0.00,27.50,1925.00,'2021-12-31 10:58:53','',''),(2410203,'1','179','933',413,'Retail Sale Id 1435390',5760.00,0.00,0.00,9.60,672.00,'2021-12-31 10:59:37','',''),(2410219,'1','179','933',413,'Retail Sale Id 1435406',1500.00,0.00,0.00,2.50,175.00,'2021-12-31 11:01:26','',''),(2410244,'1','179','933',413,'Retail Sale Id 1435432',12000.00,0.00,0.00,20.00,1400.00,'2021-12-31 11:04:58','',''),(2410302,'1','179','933',413,'Retail Sale Id 1435487',4002.00,0.00,0.00,6.67,466.90,'2021-12-31 11:12:34','',''),(2410506,'1','179','933',413,'Retail Sale Id 1435665',1500.00,0.00,0.00,2.50,175.00,'2021-12-31 11:33:59','',''),(2410812,'1','179','933',413,'Retail Sale Id 1435954',66000.00,0.00,0.00,110.00,7700.00,'2021-12-31 12:09:12','',''),(2411289,'1','179','933',413,'Retail Sale Id 1436430',3600.00,0.00,0.00,6.00,420.00,'2021-12-31 13:28:28','',''),(2411295,'1','179','933',413,'Retail Sale Id 1436439',8400.00,0.00,0.00,14.00,980.00,'2021-12-31 13:29:36','',''),(2411304,'1','179','933',413,'Retail Sale Id 1436446',7500.00,0.00,0.00,12.50,875.00,'2021-12-31 13:30:27','',''),(2411693,'1','179','933',413,'Retail Sale Id 1436786',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 14:07:17','',''),(2411724,'1','179','933',413,'Retail Sale Id 1436805',6600.00,0.00,0.00,11.00,770.00,'2021-12-31 14:09:27','',''),(2411785,'1','179','933',413,'Retail Sale Id 1436855',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 14:14:25','',''),(2412053,'1','179','933',413,'Retail Sale Id 1437048',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 14:38:16','',''),(2412067,'1','179','933',413,'Retail Sale Id 1437061',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 14:39:16','',''),(2412137,'1','179','933',413,'Retail Sale Id 1437124',7500.00,0.00,0.00,12.50,875.00,'2021-12-31 14:47:48','',''),(2412375,'1','179','933',413,'Retail Sale Id 1437328',1398.00,0.00,0.00,2.33,163.10,'2021-12-31 15:10:38','',''),(2412388,'1','179','933',413,'Retail Sale Id 1437340',7002.00,0.00,0.00,11.67,816.90,'2021-12-31 15:12:18','',''),(2412595,'1','179','933',413,'Retail Sale Id 1437480',2502.00,0.00,0.00,4.17,291.90,'2021-12-31 15:26:15','',''),(2412612,'1','179','933',413,'Retail Sale Id 1437525',3600.00,0.00,0.00,6.00,420.00,'2021-12-31 15:27:53','',''),(2412664,'1','179','933',413,'Retail Sale Id 1437566',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 15:30:37','',''),(2412962,'1','179','933',413,'Retail Sale Id 1437775',3600.00,0.00,0.00,6.00,420.00,'2021-12-31 15:50:16','',''),(2413041,'1','179','933',413,'Retail Sale Id 1437846',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 15:56:40','',''),(2413165,'1','179','933',413,'Retail Sale Id 1437942',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 16:07:00','',''),(2413268,'1','179','933',413,'Retail Sale Id 1438040',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 16:18:03','',''),(2413510,'1','179','933',413,'Retail Sale Id 1438293',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 16:39:42','',''),(2413703,'1','179','933',413,'Retail Sale Id 1438485',1002.00,0.00,0.00,1.67,116.90,'2021-12-31 16:57:05','',''),(2413743,'1','179','933',413,'Retail Sale Id 1438606',7500.00,0.00,0.00,12.50,875.00,'2021-12-31 17:03:24','',''),(2413862,'1','179','933',413,'Retail Sale Id 1438720',1998.00,0.00,0.00,3.33,233.10,'2021-12-31 17:23:59','',''),(2413867,'1','179','933',413,'Retail Sale Id 1438725',3600.00,0.00,0.00,6.00,420.00,'2021-12-31 17:26:08','',''),(2413869,'1','179','933',413,'Retail Sale Id 1438727',3600.00,0.00,0.00,6.00,420.00,'2021-12-31 17:27:17','',''),(2413958,'1','179','933',413,'Retail Sale Id 1438766',3000.00,0.00,0.00,5.00,350.00,'2021-12-31 17:52:38','',''),(2414004,'1','179','933',413,'Retail Sale Id 1438773',1002.00,0.00,0.00,1.67,116.90,'2021-12-31 17:57:26','',''),(2414033,'1','179','933',413,'Retail Sale Id 1438778',1800.00,0.00,0.00,3.00,210.00,'2021-12-31 18:08:59','',''),(2414044,'1','179','933',413,'Retail Sale Id 1438784',1002.00,0.00,0.00,1.67,116.90,'2021-12-31 18:17:28','',''),(2415147,'1','179','933',413,'Retail Sale Id 1439409',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 07:47:28','',''),(2415310,'1','179','933',413,'Retail Sale Id 1439490',3000.00,0.00,0.00,5.00,350.00,'2022-01-01 07:57:32','',''),(2415364,'1','179','933',413,'Retail Sale Id 1439541',2502.00,0.00,0.00,4.17,291.90,'2022-01-01 08:03:27','',''),(2415387,'1','179','933',413,'Retail Sale Id 1439566',1500.00,0.00,0.00,2.50,175.00,'2022-01-01 08:05:38','',''),(2415396,'1','179','933',413,'Retail Sale Id 1439572',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 08:06:20','',''),(2415420,'1','179','933',413,'Retail Sale Id 1439600',3000.00,0.00,0.00,5.00,350.00,'2022-01-01 08:08:33','',''),(2415488,'1','179','933',413,'Retail Sale Id 1439663',1500.00,0.00,0.00,2.50,175.00,'2022-01-01 08:13:36','',''),(2415523,'1','179','933',413,'Retail Sale Id 1439702',3000.00,0.00,0.00,5.00,350.00,'2022-01-01 08:17:21','',''),(2415540,'1','179','933',413,'Retail Sale Id 1439720',4002.00,0.00,0.00,6.67,466.90,'2022-01-01 08:18:58','',''),(2415547,'1','179','933',413,'Retail Sale Id 1439727',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 08:19:50','',''),(2415614,'1','179','933',413,'Retail Sale Id 1439784',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 08:26:05','',''),(2416272,'1','179','933',413,'Retail Sale Id 1440376',1002.00,0.00,0.00,1.67,116.90,'2022-01-01 09:26:57','',''),(2416299,'1','179','933',413,'Retail Sale Id 1440399',7500.00,0.00,0.00,12.50,875.00,'2022-01-01 09:28:34','',''),(2416317,'1','179','933',413,'Retail Sale Id 1440415',6000.00,0.00,0.00,10.00,700.00,'2022-01-01 09:30:14','',''),(2416330,'1','179','933',413,'Retail Sale Id 1440426',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 09:31:32','',''),(2416359,'1','179','933',413,'Retail Sale Id 1440455',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 09:34:29','',''),(2416376,'1','179','933',413,'Retail Sale Id 1440470',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 09:35:58','',''),(2416454,'1','179','933',413,'Retail Sale Id 1440532',1998.00,0.00,0.00,3.33,233.10,'2022-01-01 09:44:23','',''),(2416463,'1','179','933',413,'Retail Sale Id 1440541',4002.00,0.00,0.00,6.67,466.90,'2022-01-01 09:45:06','',''),(2416598,'1','179','933',413,'Retail Sale Id 1440656',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 09:58:11','',''),(2416615,'1','179','933',413,'Retail Sale Id 1440668',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 09:59:16','',''),(2416750,'1','179','933',413,'Retail Sale Id 1440786',7500.00,0.00,0.00,12.50,875.00,'2022-01-01 10:13:49','',''),(2416759,'1','179','933',413,'Retail Sale Id 1440797',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 10:14:59','',''),(2416890,'1','179','933',413,'Retail Sale Id 1440918',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 10:28:26','',''),(2417072,'1','179','933',413,'Retail Sale Id 1441078',2400.00,0.00,0.00,4.00,280.00,'2022-01-01 10:47:41','',''),(2417149,'1','179','933',413,'Retail Sale Id 1441145',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 10:55:58','',''),(2417334,'1','179','933',413,'Retail Sale Id 1441314',4002.00,0.00,0.00,6.67,466.90,'2022-01-01 11:15:01','',''),(2417342,'1','179','933',413,'Retail Sale Id 1441319',3000.00,0.00,0.00,5.00,350.00,'2022-01-01 11:15:55','',''),(2417439,'1','179','933',413,'Retail Sale Id 1441418',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 11:28:55','',''),(2417549,'1','179','933',413,'Retail Sale Id 1441517',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 11:39:29','',''),(2417571,'1','179','933',413,'Retail Sale Id 1441545',4998.00,0.00,0.00,8.33,583.10,'2022-01-01 11:41:34','',''),(2417791,'1','179','933',413,'Retail Sale Id 1441760',3000.00,0.00,0.00,5.00,350.00,'2022-01-01 12:07:00','',''),(2417823,'1','179','933',413,'Retail Sale Id 1441789',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 12:11:20','',''),(2417874,'1','179','933',413,'Retail Sale Id 1441844',3498.00,0.00,0.00,5.83,408.10,'2022-01-01 12:18:33','',''),(2418129,'1','179','933',413,'Retail Sale Id 1442082',1800.00,0.00,0.00,3.00,210.00,'2022-01-01 12:44:02','',''),(2418146,'1','179','933',413,'Retail Sale Id 1442094',1002.00,0.00,0.00,1.67,116.90,'2022-01-01 12:45:39','',''),(2418155,'1','179','933',413,'Retail Sale Id 1442103',7500.00,0.00,0.00,12.50,875.00,'2022-01-01 12:46:56','',''),(2418248,'1','179','933',413,'Retail Sale Id 1442193',7500.00,0.00,0.00,12.50,875.00,'2022-01-01 13:00:13','',''),(2418616,'1','179','933',413,'Retail Sale Id 1442489',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 13:45:25','',''),(2418650,'1','179','933',413,'Retail Sale Id 1442514',1998.00,0.00,0.00,3.33,233.10,'2022-01-01 13:49:52','',''),(2418832,'1','179','933',413,'Retail Sale Id 1442669',7500.00,0.00,0.00,12.50,875.00,'2022-01-01 14:20:22','',''),(2418841,'1','179','933',413,'Retail Sale Id 1442677',1398.00,0.00,0.00,2.33,163.10,'2022-01-01 14:22:00','',''),(2418879,'1','179','933',413,'Retail Sale Id 1442693',1998.00,0.00,0.00,3.33,233.10,'2022-01-01 14:25:15','',''),(2419045,'1','179','933',413,'Retail Sale Id 1442797',3000.00,0.00,0.00,5.00,350.00,'2022-01-01 14:43:50','',''),(2420116,'1','179','933',413,'Retail Sale Id 1443676',3600.00,0.00,0.00,6.00,420.00,'2022-01-01 17:25:07','',''),(2420123,'1','179','933',413,'Retail Sale Id 1443684',1200.00,0.00,0.00,2.00,140.00,'2022-01-01 17:27:05','',''),(2420129,'1','179','933',413,'Retail Sale Id 1443679',20460.00,0.00,0.00,34.10,2387.00,'2022-01-01 17:28:27','',''),(2420260,'1','179','933',413,'Retail Sale Id 1443729',1500.00,0.00,0.00,2.50,175.00,'2022-01-01 17:56:41','',''),(2420284,'1','179','933',413,'Retail Sale Id 1443740',1998.00,0.00,0.00,3.33,233.10,'2022-01-01 18:03:31','',''),(2420294,'1','179','933',413,'Retail Sale Id 1443745',4998.00,0.00,0.00,8.33,583.10,'2022-01-01 18:09:01','',''),(2421542,'1','179','933',413,'Retail Sale Id 1444447',7500.00,0.00,0.00,12.50,875.00,'2022-01-02 08:20:26','',''),(2421666,'1','179','933',413,'Retail Sale Id 1444563',7500.00,0.00,0.00,12.50,875.00,'2022-01-02 08:36:41','',''),(2421720,'1','179','933',413,'Retail Sale Id 1444613',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 08:42:51','',''),(2422062,'1','179','933',413,'Retail Sale Id 1444950',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 09:31:17','',''),(2422256,'1','179','933',413,'Retail Sale Id 1445104',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 09:49:54','',''),(2422516,'1','179','933',413,'Retail Sale Id 1445332',5400.00,0.00,0.00,9.00,630.00,'2022-01-02 10:20:32','',''),(2422521,'1','179','933',413,'Retail Sale Id 1445338',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 10:21:13','',''),(2422532,'1','179','933',413,'Retail Sale Id 1445347',6498.00,0.00,0.00,10.83,758.10,'2022-01-02 10:22:05','',''),(2422692,'1','179','933',413,'Retail Sale Id 1445473',1998.00,0.00,0.00,3.33,233.10,'2022-01-02 10:37:18','',''),(2422758,'1','179','933',413,'Retail Sale Id 1445547',11100.00,0.00,0.00,18.50,1295.00,'2022-01-02 10:44:05','',''),(2422771,'1','179','933',413,'Retail Sale Id 1445560',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 10:45:31','',''),(2422923,'1','179','933',413,'Retail Sale Id 1445704',1998.00,0.00,0.00,3.33,233.10,'2022-01-02 11:02:33','',''),(2423221,'1','179','933',413,'Retail Sale Id 1445998',2100.00,0.00,0.00,3.50,245.00,'2022-01-02 11:32:36','',''),(2423257,'1','179','933',413,'Retail Sale Id 1446032',1500.00,0.00,0.00,2.50,175.00,'2022-01-02 11:36:31','',''),(2423297,'1','179','933',413,'Retail Sale Id 1446076',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 11:42:17','',''),(2423399,'1','179','933',413,'Retail Sale Id 1446178',10200.00,0.00,0.00,17.00,1190.00,'2022-01-02 11:56:35','',''),(2423464,'1','179','933',413,'Retail Sale Id 1446229',1500.00,0.00,0.00,2.50,175.00,'2022-01-02 12:04:46','',''),(2423951,'1','179','933',413,'Retail Sale Id 1446748',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 13:05:22','',''),(2424058,'1','179','933',413,'Retail Sale Id 1446846',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 13:20:53','',''),(2424094,'1','179','933',413,'Retail Sale Id 1446882',1998.00,0.00,0.00,3.33,233.10,'2022-01-02 13:25:25','',''),(2424258,'1','179','933',413,'Retail Sale Id 1447049',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 13:47:51','',''),(2424263,'1','179','933',413,'Retail Sale Id 1447053',1998.00,0.00,0.00,3.33,233.10,'2022-01-02 13:48:40','',''),(2424266,'1','179','933',413,'Retail Sale Id 1447056',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 13:49:33','',''),(2424277,'1','179','933',413,'Retail Sale Id 1447067',7500.00,0.00,0.00,12.50,875.00,'2022-01-02 13:51:15','',''),(2424311,'1','179','933',413,'Retail Sale Id 1447082',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 13:54:10','',''),(2424345,'1','179','933',413,'Retail Sale Id 1447104',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 13:57:35','',''),(2424365,'1','179','933',413,'Retail Sale Id 1447113',1902.00,0.00,0.00,3.17,221.90,'2022-01-02 13:59:15','',''),(2424589,'1','179','933',413,'Retail Sale Id 1447255',12000.00,0.00,0.00,20.00,1400.00,'2022-01-02 14:17:59','',''),(2424604,'1','179','933',413,'Retail Sale Id 1447261',600.00,0.00,0.00,1.00,70.00,'2022-01-02 14:18:48','',''),(2424940,'1','179','933',413,'Retail Sale Id 1447544',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 14:58:27','',''),(2425058,'1','179','933',413,'Retail Sale Id 1447632',4002.00,0.00,0.00,6.67,466.90,'2022-01-02 15:11:22','',''),(2425065,'1','179','933',413,'Retail Sale Id 1447639',7500.00,0.00,0.00,12.50,875.00,'2022-01-02 15:12:42','',''),(2425068,'1','179','933',413,'Retail Sale Id 1447642',4800.00,0.00,0.00,8.00,560.00,'2022-01-02 15:13:29','',''),(2425247,'1','179','933',413,'Retail Sale Id 1447825',7002.00,0.00,0.00,11.67,816.90,'2022-01-02 15:43:32','',''),(2425257,'1','179','933',413,'Retail Sale Id 1447836',4002.00,0.00,0.00,6.67,466.90,'2022-01-02 15:44:44','',''),(2425319,'1','179','933',413,'Retail Sale Id 1447886',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 15:52:32','',''),(2425516,'1','179','933',413,'Retail Sale Id 1448066',1500.00,0.00,0.00,2.50,175.00,'2022-01-02 16:14:50','',''),(2425567,'1','179','933',413,'Retail Sale Id 1448111',1800.00,0.00,0.00,3.00,210.00,'2022-01-02 16:20:32','',''),(2425654,'1','179','933',413,'Retail Sale Id 1448164',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 16:31:16','',''),(2425796,'1','179','933',413,'Retail Sale Id 1448302',3702.00,0.00,0.00,6.17,431.90,'2022-01-02 17:01:12','',''),(2425825,'1','179','933',413,'Retail Sale Id 1448332',4002.00,0.00,0.00,6.67,466.90,'2022-01-02 17:10:56','',''),(2425883,'1','179','933',413,'Retail Sale Id 1448447',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 17:52:52','',''),(2425884,'1','179','933',413,'Retail Sale Id 1448448',7500.00,0.00,0.00,12.50,875.00,'2022-01-02 17:53:35','',''),(2425891,'1','179','933',413,'Retail Sale Id 1448456',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 18:01:21','',''),(2425892,'1','179','933',413,'Retail Sale Id 1448457',3600.00,0.00,0.00,6.00,420.00,'2022-01-02 18:02:37','',''),(2425914,'1','179','933',413,'Retail Sale Id 1448475',7500.00,0.00,0.00,12.50,875.00,'2022-01-02 18:15:22','',''),(2427098,'1','179','933',413,'Retail Sale Id 1449123',1998.00,0.00,0.00,3.33,233.10,'2022-01-03 08:09:39','',''),(2427127,'1','179','933',413,'Retail Sale Id 1449154',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 08:13:09','',''),(2427203,'1','179','933',413,'Retail Sale Id 1449231',1500.00,0.00,0.00,2.50,175.00,'2022-01-03 08:24:21','',''),(2427210,'1','179','933',413,'Retail Sale Id 1449238',1002.00,0.00,0.00,1.67,116.90,'2022-01-03 08:25:32','',''),(2427219,'1','179','933',413,'Retail Sale Id 1449247',1500.00,0.00,0.00,2.50,175.00,'2022-01-03 08:26:40','',''),(2427335,'1','179','933',413,'Retail Sale Id 1449369',1998.00,0.00,0.00,3.33,233.10,'2022-01-03 08:40:35','',''),(2427381,'1','179','933',413,'Retail Sale Id 1449411',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 08:45:37','',''),(2427677,'1','179','933',413,'Retail Sale Id 1449666',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 09:12:59','',''),(2427911,'1','179','933',413,'Retail Sale Id 1449905',1998.00,0.00,0.00,3.33,233.10,'2022-01-03 09:41:14','',''),(2427990,'1','179','933',413,'Retail Sale Id 1449981',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 09:50:36','',''),(2428104,'1','179','933',413,'Retail Sale Id 1450091',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 10:04:35','',''),(2428115,'1','179','933',413,'Retail Sale Id 1450101',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 10:05:23','',''),(2428777,'1','179','933',413,'Retail Sale Id 1450714',2802.00,0.00,0.00,4.67,326.90,'2022-01-03 11:22:31','',''),(2429010,'1','179','933',413,'Retail Sale Id 1450920',6000.00,0.00,0.00,10.00,700.00,'2022-01-03 11:52:19','',''),(2429098,'1','179','933',413,'Retail Sale Id 1451004',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 12:03:02','',''),(2429174,'1','179','933',413,'Retail Sale Id 1451083',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 12:15:47','',''),(2429431,'1','179','933',413,'Retail Sale Id 1451308',1998.00,0.00,0.00,3.33,233.10,'2022-01-03 12:46:52','',''),(2429748,'1','179','933',413,'Retail Sale Id 1451592',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 13:19:29','',''),(2430135,'1','179','933',413,'Retail Sale Id 1451885',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 13:50:34','',''),(2430147,'1','179','933',413,'Retail Sale Id 1451899',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 13:51:56','',''),(2430165,'1','179','933',413,'Retail Sale Id 1451914',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 13:53:20','',''),(2430254,'1','179','933',413,'Retail Sale Id 1451970',1200.00,0.00,0.00,2.00,140.00,'2022-01-03 13:58:58','',''),(2430337,'1','179','933',413,'Retail Sale Id 1452034',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 14:05:42','',''),(2430546,'1','179','933',413,'Retail Sale Id 1452157',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 14:21:52','',''),(2430650,'1','179','933',413,'Retail Sale Id 1452265',3000.00,0.00,0.00,5.00,350.00,'2022-01-03 14:36:58','',''),(2431041,'1','179','933',413,'Retail Sale Id 1452563',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 15:11:19','',''),(2431272,'1','179','933',413,'Retail Sale Id 1452697',3498.00,0.00,0.00,5.83,408.10,'2022-01-03 15:28:00','',''),(2431279,'1','179','933',413,'Retail Sale Id 1452705',4002.00,0.00,0.00,6.67,466.90,'2022-01-03 15:28:53','',''),(2431298,'1','179','933',413,'Retail Sale Id 1452724',4002.00,0.00,0.00,6.67,466.90,'2022-01-03 15:31:44','',''),(2431430,'1','179','933',413,'Retail Sale Id 1452857',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 15:44:07','',''),(2431496,'1','179','933',413,'Retail Sale Id 1452923',1998.00,0.00,0.00,3.33,233.10,'2022-01-03 15:50:38','',''),(2431510,'1','179','933',413,'Retail Sale Id 1452935',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 15:51:57','',''),(2431615,'1','179','933',413,'Retail Sale Id 1453039',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 16:01:13','',''),(2431655,'1','179','933',413,'Retail Sale Id 1453078',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 16:04:57','',''),(2431674,'1','179','933',413,'Retail Sale Id 1453098',1500.00,0.00,0.00,2.50,175.00,'2022-01-03 16:06:49','',''),(2431712,'1','179','933',413,'Retail Sale Id 1453135',1998.00,0.00,0.00,3.33,233.10,'2022-01-03 16:10:38','',''),(2431742,'1','179','933',413,'Retail Sale Id 1453164',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 16:13:23','',''),(2431971,'1','179','933',413,'Retail Sale Id 1453384',900.00,0.00,0.00,1.50,105.00,'2022-01-03 16:34:06','',''),(2432127,'1','179','933',413,'Retail Sale Id 1453520',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 16:53:47','',''),(2432192,'1','179','933',413,'Retail Sale Id 1453568',1800.00,0.00,0.00,3.00,210.00,'2022-01-03 17:01:17','',''),(2432249,'1','179','933',413,'Retail Sale Id 1453623',1500.00,0.00,0.00,2.50,175.00,'2022-01-03 17:12:04','',''),(2432278,'1','179','933',413,'Retail Sale Id 1453649',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 17:20:44','',''),(2432320,'1','179','933',413,'Retail Sale Id 1453684',4998.00,0.00,0.00,8.33,583.10,'2022-01-03 17:49:06','',''),(2432340,'1','179','933',413,'Retail Sale Id 1453697',7500.00,0.00,0.00,12.50,875.00,'2022-01-03 17:55:32','',''),(2432378,'1','179','933',413,'Retail Sale Id 1453707',4500.00,0.00,0.00,7.50,525.00,'2022-01-03 18:07:52','',''),(2432420,'1','179','933',413,'Retail Sale Id 1453725',3600.00,0.00,0.00,6.00,420.00,'2022-01-03 18:19:47','',''),(2433331,'1','179','933',413,'Retail Sale Id 1454027',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 07:13:20','',''),(2433830,'1','179','933',413,'Retail Sale Id 1454491',6720.00,0.00,0.00,11.20,784.00,'2022-01-04 08:09:54','',''),(2433842,'1','179','933',413,'Retail Sale Id 1454503',1500.00,0.00,0.00,2.50,175.00,'2022-01-04 08:10:53','',''),(2433873,'1','179','933',413,'Retail Sale Id 1454533',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 08:14:01','',''),(2433879,'1','179','933',413,'Retail Sale Id 1454538',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 08:14:29','',''),(2434174,'1','179','933',413,'Retail Sale Id 1454757',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 08:37:37','',''),(2434181,'1','179','933',413,'Retail Sale Id 1454765',1500.00,0.00,0.00,2.50,175.00,'2022-01-04 08:38:05','',''),(2434364,'1','179','933',413,'Retail Sale Id 1454928',1500.00,0.00,0.00,2.50,175.00,'2022-01-04 08:55:02','',''),(2434473,'1','179','933',413,'Retail Sale Id 1455043',7500.00,0.00,0.00,12.50,875.00,'2022-01-04 09:06:42','',''),(2434492,'1','179','933',413,'Retail Sale Id 1455062',4998.00,0.00,0.00,8.33,583.10,'2022-01-04 09:08:51','',''),(2434515,'1','179','933',413,'Retail Sale Id 1455084',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 09:10:51','',''),(2434631,'1','179','933',413,'Retail Sale Id 1455200',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 09:24:49','',''),(2434644,'1','179','933',413,'Retail Sale Id 1455213',15000.00,0.00,0.00,25.00,1750.00,'2022-01-04 09:26:18','',''),(2434964,'1','179','933',413,'Retail Sale Id 1455465',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 09:52:41','',''),(2435003,'1','179','933',413,'Retail Sale Id 1455061',1998.00,0.00,0.00,3.33,233.10,'2022-01-04 09:54:39','',''),(2435252,'1','179','933',413,'Retail Sale Id 1455699',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 10:19:45','',''),(2435346,'1','179','933',413,'Retail Sale Id 1455771',2502.00,0.00,0.00,4.17,291.90,'2022-01-04 10:29:29','',''),(2435427,'1','179','933',413,'Retail Sale Id 1455834',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 10:36:04','',''),(2435615,'1','179','933',413,'Retail Sale Id 1456018',6000.00,0.00,0.00,10.00,700.00,'2022-01-04 10:52:38','',''),(2435795,'1','179','933',413,'Retail Sale Id 1456201',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 11:09:59','',''),(2435899,'1','179','933',413,'Retail Sale Id 1456291',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 11:18:54','',''),(2436108,'1','179','933',413,'Retail Sale Id 1456475',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 11:37:26','',''),(2436126,'1','179','933',413,'Retail Sale Id 1456490',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 11:38:53','',''),(2436140,'1','179','933',413,'Retail Sale Id 1456499',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 11:39:54','',''),(2436219,'1','179','933',413,'Retail Sale Id 1456572',2802.00,0.00,0.00,4.67,326.90,'2022-01-04 11:48:47','',''),(2436534,'1','179','933',413,'Retail Sale Id 1456908',6000.00,0.00,0.00,10.00,700.00,'2022-01-04 12:24:49','',''),(2436587,'1','179','933',413,'Retail Sale Id 1456959',1998.00,0.00,0.00,3.33,233.10,'2022-01-04 12:30:50','',''),(2436617,'1','179','933',413,'Retail Sale Id 1456990',6600.00,0.00,0.00,11.00,770.00,'2022-01-04 12:33:43','',''),(2436625,'1','179','933',413,'Retail Sale Id 1456997',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 12:34:33','',''),(2436657,'1','179','933',413,'Retail Sale Id 1457031',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 12:37:37','',''),(2437244,'1','179','933',413,'Retail Sale Id 1457622',7500.00,0.00,0.00,12.50,875.00,'2022-01-04 13:37:13','',''),(2437257,'1','179','933',413,'Retail Sale Id 1457635',1200.00,0.00,0.00,2.00,140.00,'2022-01-04 13:37:45','',''),(2437358,'1','179','933',413,'Retail Sale Id 1457695',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 13:44:31','',''),(2437377,'1','179','933',413,'Retail Sale Id 1457709',1002.00,0.00,0.00,1.67,116.90,'2022-01-04 13:46:08','',''),(2437505,'1','179','933',413,'Retail Sale Id 1457801',7500.00,0.00,0.00,12.50,875.00,'2022-01-04 13:55:57','',''),(2437594,'1','179','933',413,'Retail Sale Id 1457898',7500.00,0.00,0.00,12.50,875.00,'2022-01-04 14:05:22','',''),(2437645,'1','179','933',413,'Retail Sale Id 1457936',1500.00,0.00,0.00,2.50,175.00,'2022-01-04 14:09:17','',''),(2438052,'1','179','933',413,'Retail Sale Id 1458218',7500.00,0.00,0.00,12.50,875.00,'2022-01-04 14:42:58','',''),(2438201,'1','179','933',413,'Retail Sale Id 1458326',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 14:54:43','',''),(2438256,'1','179','933',413,'Retail Sale Id 1458378',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 15:00:21','',''),(2438996,'1','179','933',413,'Retail Sale Id 1458986',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 15:56:47','',''),(2439001,'1','179','933',413,'Retail Sale Id 1458991',7500.00,0.00,0.00,12.50,875.00,'2022-01-04 15:57:26','',''),(2439012,'1','179','933',413,'Retail Sale Id 1459002',6600.00,0.00,0.00,11.00,770.00,'2022-01-04 15:58:19','',''),(2439186,'1','179','933',413,'Retail Sale Id 1459161',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 16:13:29','',''),(2439198,'1','179','933',413,'Retail Sale Id 1459175',1200.00,0.00,0.00,2.00,140.00,'2022-01-04 16:14:12','',''),(2439420,'1','179','933',413,'Retail Sale Id 1459413',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 16:38:54','',''),(2439429,'1','179','933',413,'Retail Sale Id 1459423',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 16:40:03','',''),(2439490,'1','179','933',413,'Retail Sale Id 1459488',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 16:45:59','',''),(2439495,'1','179','933',413,'Retail Sale Id 1459492',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 16:46:48','',''),(2439511,'1','179','933',413,'Retail Sale Id 1459504',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 16:48:31','',''),(2439547,'1','179','933',413,'Retail Sale Id 1459542',11100.00,0.00,0.00,18.50,1295.00,'2022-01-04 16:54:38','',''),(2439560,'1','179','933',413,'Retail Sale Id 1459552',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 16:56:58','',''),(2439601,'1','179','933',413,'Retail Sale Id 1459599',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 17:02:19','',''),(2439652,'1','179','933',413,'Retail Sale Id 1459655',1200.00,0.00,0.00,2.00,140.00,'2022-01-04 17:12:55','',''),(2439707,'1','179','933',413,'Retail Sale Id 1459698',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 17:23:21','',''),(2439751,'1','179','933',413,'Retail Sale Id 1459749',3000.00,0.00,0.00,5.00,350.00,'2022-01-04 17:36:39','',''),(2439867,'1','179','933',413,'Retail Sale Id 1459842',1500.00,0.00,0.00,2.50,175.00,'2022-01-04 18:19:28','',''),(2439871,'1','179','933',413,'Retail Sale Id 1459844',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 18:21:27','',''),(2439875,'1','179','933',413,'Retail Sale Id 1459846',1800.00,0.00,0.00,3.00,210.00,'2022-01-04 18:28:20','',''),(2439879,'1','179','933',413,'Retail Sale Id 1459849',3600.00,0.00,0.00,6.00,420.00,'2022-01-04 18:31:56','',''),(2441091,'1','179','933',413,'Retail Sale Id 1460402',7200.00,0.00,0.00,12.00,840.00,'2022-01-05 07:46:13','',''),(2441149,'1','179','933',413,'Retail Sale Id 1460443',7500.00,0.00,0.00,12.50,875.00,'2022-01-05 07:51:10','',''),(2441299,'1','179','933',413,'Retail Sale Id 1460536',7500.00,0.00,0.00,12.50,875.00,'2022-01-05 08:03:10','',''),(2441504,'1','179','933',413,'Retail Sale Id 1460711',1998.00,0.00,0.00,3.33,233.10,'2022-01-05 08:21:51','',''),(2441637,'1','179','933',413,'Retail Sale Id 1460793',1002.00,0.00,0.00,1.67,116.90,'2022-01-05 09:31:18','',''),(2441915,'1','179','933',413,'Retail Sale Id 1461026',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 09:56:11','',''),(2442086,'1','179','933',413,'Retail Sale Id 1461176',5400.00,0.00,0.00,9.00,630.00,'2022-01-05 10:10:53','',''),(2442101,'1','179','933',413,'Retail Sale Id 1461185',1200.00,0.00,0.00,2.00,140.00,'2022-01-05 10:11:57','',''),(2442280,'1','179','933',413,'Retail Sale Id 1461346',3600.00,0.00,0.00,6.00,420.00,'2022-01-05 10:29:27','',''),(2442301,'1','179','933',413,'Retail Sale Id 1461367',3600.00,0.00,0.00,6.00,420.00,'2022-01-05 10:31:21','',''),(2443732,'1','179','933',413,'Retail Sale Id 1462671',6498.00,0.00,0.00,10.83,758.10,'2022-01-05 12:38:41','',''),(2444198,'1','179','933',413,'Retail Sale Id 1463128',1998.00,0.00,0.00,3.33,233.10,'2022-01-05 13:31:02','',''),(2444858,'1','179','933',413,'Retail Sale Id 1463635',1500.00,0.00,0.00,2.50,175.00,'2022-01-05 14:37:49','',''),(2444867,'1','179','933',413,'Retail Sale Id 1463646',3600.00,0.00,0.00,6.00,420.00,'2022-01-05 14:39:24','',''),(2445052,'1','179','933',413,'Retail Sale Id 1463789',4002.00,0.00,0.00,6.67,466.90,'2022-01-05 14:59:21','',''),(2445093,'1','179','933',413,'Retail Sale Id 1463817',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 15:02:59','',''),(2445684,'1','179','933',413,'Retail Sale Id 1464190',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 15:49:02','',''),(2445699,'1','179','933',413,'Retail Sale Id 1464199',7200.00,0.00,0.00,12.00,840.00,'2022-01-05 15:50:29','',''),(2445718,'1','179','933',413,'Retail Sale Id 1464212',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 15:51:54','',''),(2445733,'1','179','933',413,'Retail Sale Id 1464228',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 15:52:46','',''),(2445744,'1','179','933',413,'Retail Sale Id 1464236',1998.00,0.00,0.00,3.33,233.10,'2022-01-05 15:53:48','',''),(2445949,'1','179','933',413,'Retail Sale Id 1464396',3600.00,0.00,0.00,6.00,420.00,'2022-01-05 16:14:25','',''),(2446005,'1','179','933',413,'Retail Sale Id 1464422',1998.00,0.00,0.00,3.33,233.10,'2022-01-05 16:17:49','',''),(2446117,'1','179','933',413,'Retail Sale Id 1464520',1002.00,0.00,0.00,1.67,116.90,'2022-01-05 16:28:49','',''),(2446225,'1','179','933',413,'Retail Sale Id 1464624',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 16:39:10','',''),(2446307,'1','179','933',413,'Retail Sale Id 1464705',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 16:48:08','',''),(2446325,'1','179','933',413,'Retail Sale Id 1464719',2502.00,0.00,0.00,4.17,291.90,'2022-01-05 16:49:05','',''),(2446335,'1','179','933',413,'Retail Sale Id 1464730',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 16:49:50','',''),(2446339,'1','179','933',413,'Retail Sale Id 1464733',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 16:50:32','',''),(2446717,'1','179','933',413,'Retail Sale Id 1465058',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 17:21:19','',''),(2447124,'1','179','933',413,'Retail Sale Id 1465423',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 17:55:14','',''),(2447165,'1','179','933',413,'Retail Sale Id 1465452',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 17:58:46','',''),(2447210,'1','179','933',413,'Retail Sale Id 1465492',3600.00,0.00,0.00,6.00,420.00,'2022-01-05 18:06:29','',''),(2447327,'1','179','933',413,'Retail Sale Id 1465566',1302.00,0.00,0.00,2.17,151.90,'2022-01-05 18:19:39','',''),(2447334,'1','179','933',413,'Retail Sale Id 1465574',7500.00,0.00,0.00,12.50,875.00,'2022-01-05 18:20:49','',''),(2447401,'1','179','933',413,'Retail Sale Id 1465616',7500.00,0.00,0.00,12.50,875.00,'2022-01-05 18:28:16','',''),(2447409,'1','179','933',413,'Retail Sale Id 1465623',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 18:29:53','',''),(2447431,'1','179','933',413,'Retail Sale Id 1465646',6000.00,0.00,0.00,10.00,700.00,'2022-01-05 18:34:42','',''),(2447525,'1','179','933',413,'Retail Sale Id 1465705',3000.00,0.00,0.00,5.00,350.00,'2022-01-05 18:55:56','',''),(2447528,'1','179','933',413,'Retail Sale Id 1465708',1998.00,0.00,0.00,3.33,233.10,'2022-01-05 18:56:46','',''),(2447533,'1','179','933',413,'Retail Sale Id 1465714',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 18:57:27','',''),(2447538,'1','179','933',413,'Retail Sale Id 1465717',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 18:58:38','',''),(2447576,'1','179','933',413,'Retail Sale Id 1465722',1800.00,0.00,0.00,3.00,210.00,'2022-01-05 18:59:53','',''),(2447619,'1','179','933',413,'Retail Sale Id 1465760',3600.00,0.00,0.00,6.00,420.00,'2022-01-05 19:13:07','',''),(2447664,'1','179','933',413,'Retail Sale Id 1465805',1998.00,0.00,0.00,3.33,233.10,'2022-01-05 20:03:46','',''),(2448938,'1','179','933',413,'Retail Sale Id 1466448',6000.00,0.00,0.00,10.00,700.00,'2022-01-06 08:43:29','',''),(2449146,'1','179','933',413,'Retail Sale Id 1466566',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 09:00:29','',''),(2450063,'1','179','933',413,'Retail Sale Id 1467451',600.00,0.00,0.00,1.00,70.00,'2022-01-06 10:26:37','',''),(2450171,'1','179','933',413,'Retail Sale Id 1467488',1200.00,0.00,0.00,2.00,140.00,'2022-01-06 10:31:38','',''),(2450434,'1','179','933',413,'Retail Sale Id 1467715',11100.00,0.00,0.00,18.50,1295.00,'2022-01-06 10:57:05','',''),(2450745,'1','179','933',413,'Retail Sale Id 1468023',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 11:29:31','',''),(2450755,'1','179','933',413,'Retail Sale Id 1468032',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 11:30:20','',''),(2450911,'1','179','933',413,'Retail Sale Id 1468197',1200.00,0.00,0.00,2.00,140.00,'2022-01-06 11:44:11','',''),(2451066,'1','179','933',413,'Retail Sale Id 1468379',2400.00,0.00,0.00,4.00,280.00,'2022-01-06 11:58:54','',''),(2451073,'1','179','933',413,'Retail Sale Id 1468388',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 11:59:56','',''),(2451569,'1','179','933',413,'Retail Sale Id 1468891',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 12:55:54','',''),(2451660,'1','179','933',413,'Retail Sale Id 1468965',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 13:07:19','',''),(2451920,'1','179','933',413,'Retail Sale Id 1469235',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 13:36:36','',''),(2452093,'1','179','933',413,'Retail Sale Id 1469430',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 14:00:02','',''),(2452102,'1','179','933',413,'Retail Sale Id 1469440',9600.00,0.00,0.00,16.00,1120.00,'2022-01-06 14:01:09','',''),(2452117,'1','179','933',413,'Retail Sale Id 1469452',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 14:03:02','',''),(2452124,'1','179','933',413,'Retail Sale Id 1469465',3000.00,0.00,0.00,5.00,350.00,'2022-01-06 14:03:52','',''),(2452859,'1','179','933',413,'Retail Sale Id 1469920',1998.00,0.00,0.00,3.33,233.10,'2022-01-06 15:03:06','',''),(2453064,'1','179','933',413,'Retail Sale Id 1470059',3000.00,0.00,0.00,5.00,350.00,'2022-01-06 15:19:20','',''),(2453268,'1','179','933',413,'Retail Sale Id 1470252',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 15:40:22','',''),(2453396,'1','179','933',413,'Retail Sale Id 1470362',3000.00,0.00,0.00,5.00,350.00,'2022-01-06 15:53:42','',''),(2453408,'1','179','933',413,'Retail Sale Id 1470369',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 15:54:42','',''),(2454187,'1','179','933',413,'Retail Sale Id 1471145',3000.00,0.00,0.00,5.00,350.00,'2022-01-06 17:11:03','',''),(2454223,'1','179','933',413,'Retail Sale Id 1471169',3000.00,0.00,0.00,5.00,350.00,'2022-01-06 17:12:15','',''),(2454383,'1','179','933',413,'Retail Sale Id 1471330',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 17:28:41','',''),(2454511,'1','179','933',413,'Retail Sale Id 1471453',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 17:38:19','',''),(2454644,'1','179','933',413,'Retail Sale Id 1471579',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 17:50:08','',''),(2455049,'1','179','933',413,'Retail Sale Id 1471912',9600.00,0.00,0.00,16.00,1120.00,'2022-01-06 18:36:54','',''),(2455052,'1','179','933',413,'Retail Sale Id 1471916',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 18:38:03','',''),(2455110,'1','179','933',413,'Retail Sale Id 1471946',3000.00,0.00,0.00,5.00,350.00,'2022-01-06 18:48:17','',''),(2455192,'1','179','933',413,'Retail Sale Id 1471970',3600.00,0.00,0.00,6.00,420.00,'2022-01-06 18:54:02','',''),(2455196,'1','179','933',413,'Retail Sale Id 1471976',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 18:54:53','',''),(2455296,'1','179','933',413,'Retail Sale Id 1472075',1800.00,0.00,0.00,3.00,210.00,'2022-01-06 19:28:26','',''),(2455298,'1','179','933',413,'Retail Sale Id 1472077',1998.00,0.00,0.00,3.33,233.10,'2022-01-06 19:29:46','',''),(2455314,'1','179','933',413,'Retail Sale Id 1472085',2502.00,0.00,0.00,4.17,291.90,'2022-01-06 19:35:02','',''),(2456454,'1','179','933',413,'Retail Sale Id 1472582',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 08:27:57','',''),(2457346,'1','179','933',413,'Retail Sale Id 1473355',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 09:41:29','',''),(2457454,'1','179','933',413,'Retail Sale Id 1473458',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 09:52:36','',''),(2457474,'1','179','933',413,'Retail Sale Id 1473472',7500.00,0.00,0.00,12.50,875.00,'2022-01-07 09:54:39','',''),(2457480,'1','179','933',413,'Retail Sale Id 1473476',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 09:55:23','',''),(2457489,'1','179','933',413,'Retail Sale Id 1473486',1998.00,0.00,0.00,3.33,233.10,'2022-01-07 09:56:20','',''),(2457491,'1','179','933',413,'Retail Sale Id 1473488',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 09:56:56','',''),(2457506,'1','179','933',413,'Retail Sale Id 1473501',1002.00,0.00,0.00,1.67,116.90,'2022-01-07 09:58:52','',''),(2457512,'1','179','933',413,'Retail Sale Id 1473507',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 09:59:34','',''),(2457632,'1','179','933',413,'Retail Sale Id 1473608',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 10:15:32','',''),(2457884,'1','179','933',413,'Retail Sale Id 1473868',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 10:41:38','',''),(2457948,'1','179','933',413,'Retail Sale Id 1473924',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 10:48:51','',''),(2457958,'1','179','933',413,'Retail Sale Id 1473937',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 10:49:56','',''),(2458086,'1','179','933',413,'Retail Sale Id 1474068',4002.00,0.00,0.00,6.67,466.90,'2022-01-07 11:03:43','',''),(2458303,'1','179','933',413,'Retail Sale Id 1474195',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 11:18:05','',''),(2458344,'1','179','933',413,'Retail Sale Id 1474237',1002.00,0.00,0.00,1.67,116.90,'2022-01-07 11:22:09','',''),(2458412,'1','179','933',413,'Retail Sale Id 1474311',1998.00,0.00,0.00,3.33,233.10,'2022-01-07 11:29:08','',''),(2458873,'1','179','933',413,'Retail Sale Id 1474756',7500.00,0.00,0.00,12.50,875.00,'2022-01-07 12:17:43','',''),(2459353,'1','179','933',413,'Retail Sale Id 1475227',600.00,0.00,0.00,1.00,70.00,'2022-01-07 13:23:04','',''),(2459457,'1','179','933',413,'Retail Sale Id 1475335',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 13:42:00','',''),(2459645,'1','179','933',413,'Retail Sale Id 1475516',1398.00,0.00,0.00,2.33,163.10,'2022-01-07 14:08:14','',''),(2459657,'1','179','933',413,'Retail Sale Id 1475524',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 14:08:59','',''),(2459664,'1','179','933',413,'Retail Sale Id 1475528',1302.00,0.00,0.00,2.17,151.90,'2022-01-07 14:09:37','',''),(2459668,'1','179','933',413,'Retail Sale Id 1475533',6000.00,0.00,0.00,10.00,700.00,'2022-01-07 14:10:31','',''),(2459678,'1','179','933',413,'Retail Sale Id 1475542',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 14:12:10','',''),(2459741,'1','179','933',413,'Retail Sale Id 1475593',1200.00,0.00,0.00,2.00,140.00,'2022-01-07 14:20:48','',''),(2459932,'1','179','933',413,'Retail Sale Id 1475772',4002.00,0.00,0.00,6.67,466.90,'2022-01-07 14:43:39','',''),(2459935,'1','179','933',413,'Retail Sale Id 1475779',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 14:44:24','',''),(2459945,'1','179','933',413,'Retail Sale Id 1475787',4998.00,0.00,0.00,8.33,583.10,'2022-01-07 14:45:40','',''),(2460052,'1','179','933',413,'Retail Sale Id 1475845',14400.00,0.00,0.00,24.00,1680.00,'2022-01-07 14:53:16','',''),(2460135,'1','179','933',413,'Retail Sale Id 1475915',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 15:00:42','',''),(2460224,'1','179','933',413,'Retail Sale Id 1475976',1500.00,0.00,0.00,2.50,175.00,'2022-01-07 15:07:12','',''),(2460345,'1','179','933',413,'Retail Sale Id 1476078',1500.00,0.00,0.00,2.50,175.00,'2022-01-07 15:17:25','',''),(2460410,'1','179','933',413,'Retail Sale Id 1476122',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 15:22:54','',''),(2460460,'1','179','933',413,'Retail Sale Id 1476169',14160.00,0.00,0.00,23.60,1652.00,'2022-01-07 15:27:33','',''),(2460572,'1','179','933',413,'Retail Sale Id 1476240',600.00,0.00,0.00,1.00,70.00,'2022-01-07 15:33:34','',''),(2460894,'1','179','933',413,'Retail Sale Id 1476484',1200.00,0.00,0.00,2.00,140.00,'2022-01-07 15:58:50','',''),(2461152,'1','179','933',413,'Retail Sale Id 1476721',11100.00,0.00,0.00,18.50,1295.00,'2022-01-07 16:29:05','',''),(2461239,'1','179','933',413,'Retail Sale Id 1476763',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 16:33:51','',''),(2461339,'1','179','933',413,'Retail Sale Id 1476839',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 16:42:14','',''),(2461379,'1','179','933',413,'Retail Sale Id 1476877',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 16:46:54','',''),(2461690,'1','179','933',413,'Retail Sale Id 1477176',7500.00,0.00,0.00,12.50,875.00,'2022-01-07 17:17:09','',''),(2461741,'1','179','933',413,'Retail Sale Id 1477221',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 17:23:04','',''),(2461887,'1','179','933',413,'Retail Sale Id 1477282',7500.00,0.00,0.00,12.50,875.00,'2022-01-07 17:30:26','',''),(2461894,'1','179','933',413,'Retail Sale Id 1477290',1800.00,0.00,0.00,3.00,210.00,'2022-01-07 17:31:21','',''),(2461992,'1','179','933',413,'Retail Sale Id 1477380',4002.00,0.00,0.00,6.67,466.90,'2022-01-07 17:41:14','',''),(2462251,'1','179','933',413,'Retail Sale Id 1477615',3600.00,0.00,0.00,6.00,420.00,'2022-01-07 18:15:04','',''),(2462265,'1','179','933',413,'Retail Sale Id 1477631',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 18:16:53','',''),(2462330,'1','179','933',413,'Retail Sale Id 1477659',1998.00,0.00,0.00,3.33,233.10,'2022-01-07 18:24:27','',''),(2462549,'1','179','933',413,'Retail Sale Id 1477837',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 19:24:39','',''),(2462652,'1','179','933',413,'Retail Sale Id 1477860',3000.00,0.00,0.00,5.00,350.00,'2022-01-07 20:11:10','',''),(2463664,'1','179','933',413,'Retail Sale Id 1478395',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 08:24:15','',''),(2463787,'1','179','933',413,'Retail Sale Id 1478537',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 08:35:52','',''),(2464082,'1','179','933',413,'Retail Sale Id 1478827',1998.00,0.00,0.00,3.33,233.10,'2022-01-08 09:06:14','',''),(2464307,'1','179','933',413,'Retail Sale Id 1479059',4200.00,0.00,0.00,7.00,490.00,'2022-01-08 09:28:04','',''),(2464413,'1','179','933',413,'Retail Sale Id 1479177',6000.00,0.00,0.00,10.00,700.00,'2022-01-08 09:36:39','',''),(2464499,'1','179','933',413,'Retail Sale Id 1479264',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 09:44:23','',''),(2464675,'1','179','933',413,'Retail Sale Id 1479409',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 09:57:28','',''),(2464777,'1','179','933',413,'Retail Sale Id 1479484',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 10:05:08','',''),(2465149,'1','179','933',413,'Retail Sale Id 1479792',1998.00,0.00,0.00,3.33,233.10,'2022-01-08 10:38:09','',''),(2465428,'1','179','933',413,'Retail Sale Id 1480028',1500.00,0.00,0.00,2.50,175.00,'2022-01-08 10:59:48','',''),(2465813,'1','179','933',413,'Retail Sale Id 1480374',15000.00,0.00,0.00,25.00,1750.00,'2022-01-08 11:31:25','',''),(2465833,'1','179','933',413,'Retail Sale Id 1480402',1500.00,0.00,0.00,2.50,175.00,'2022-01-08 11:33:11','',''),(2465905,'1','179','933',413,'Retail Sale Id 1480489',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 11:40:17','',''),(2465916,'1','179','933',413,'Retail Sale Id 1480504',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 11:41:08','',''),(2466155,'1','179','933',413,'Retail Sale Id 1480707',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 12:01:51','',''),(2466277,'1','179','933',413,'Retail Sale Id 1480812',3000.00,0.00,0.00,5.00,350.00,'2022-01-08 12:13:07','',''),(2466485,'1','179','933',413,'Retail Sale Id 1480976',15000.00,0.00,0.00,25.00,1750.00,'2022-01-08 12:32:41','',''),(2466495,'1','179','933',413,'Retail Sale Id 1480988',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 12:33:57','',''),(2466526,'1','179','933',413,'Retail Sale Id 1481017',2100.00,0.00,0.00,3.50,245.00,'2022-01-08 12:37:14','',''),(2466578,'1','179','933',413,'Retail Sale Id 1481075',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 12:42:50','',''),(2466614,'1','179','933',413,'Retail Sale Id 1481107',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 12:46:33','',''),(2466637,'1','179','933',413,'Retail Sale Id 1481131',10002.00,0.00,0.00,16.67,1166.90,'2022-01-08 12:49:07','',''),(2466756,'1','179','933',413,'Retail Sale Id 1481252',3000.00,0.00,0.00,5.00,350.00,'2022-01-08 13:01:10','',''),(2466830,'1','179','933',413,'Retail Sale Id 1481338',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 13:09:19','',''),(2466843,'1','179','933',413,'Retail Sale Id 1481354',2502.00,0.00,0.00,4.17,291.90,'2022-01-08 13:11:05','',''),(2467182,'1','179','933',413,'Retail Sale Id 1481641',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 13:41:38','',''),(2467201,'1','179','933',413,'Retail Sale Id 1481649',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 13:42:40','',''),(2467242,'1','179','933',413,'Retail Sale Id 1481681',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 13:46:04','',''),(2467707,'1','179','933',413,'Retail Sale Id 1482005',4800.00,0.00,0.00,8.00,560.00,'2022-01-08 14:24:21','',''),(2467867,'1','179','933',413,'Retail Sale Id 1482147',5400.00,0.00,0.00,9.00,630.00,'2022-01-08 14:38:30','',''),(2467926,'1','179','933',413,'Retail Sale Id 1482182',1998.00,0.00,0.00,3.33,233.10,'2022-01-08 14:42:38','',''),(2468023,'1','179','933',413,'Retail Sale Id 1482264',1200.00,0.00,0.00,2.00,140.00,'2022-01-08 14:51:06','',''),(2468269,'1','179','933',413,'Retail Sale Id 1482458',7200.00,0.00,0.00,12.00,840.00,'2022-01-08 15:12:29','',''),(2468326,'1','179','933',413,'Retail Sale Id 1482514',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 15:20:22','',''),(2468339,'1','179','933',413,'Retail Sale Id 1482526',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 15:21:41','',''),(2468358,'1','179','933',413,'Retail Sale Id 1482553',1998.00,0.00,0.00,3.33,233.10,'2022-01-08 15:23:52','',''),(2468409,'1','179','933',413,'Retail Sale Id 1482586',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 15:28:06','',''),(2468483,'1','179','933',413,'Retail Sale Id 1482665',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 15:35:24','',''),(2468505,'1','179','933',413,'Retail Sale Id 1482691',1500.00,0.00,0.00,2.50,175.00,'2022-01-08 15:37:45','',''),(2468688,'1','179','933',413,'Retail Sale Id 1482814',4002.00,0.00,0.00,6.67,466.90,'2022-01-08 15:49:09','',''),(2468731,'1','179','933',413,'Retail Sale Id 1482840',6000.00,0.00,0.00,10.00,700.00,'2022-01-08 15:51:29','',''),(2468768,'1','179','933',413,'Retail Sale Id 1482864',5502.00,0.00,0.00,9.17,641.90,'2022-01-08 15:53:35','',''),(2468784,'1','179','933',413,'Retail Sale Id 1482877',3000.00,0.00,0.00,5.00,350.00,'2022-01-08 15:54:10','',''),(2469176,'1','179','933',413,'Retail Sale Id 1483221',600.00,0.00,0.00,1.00,70.00,'2022-01-08 16:22:08','',''),(2469257,'1','179','933',413,'Retail Sale Id 1483297',3750.00,0.00,0.00,6.25,437.50,'2022-01-08 16:28:08','',''),(2469312,'1','179','933',413,'Retail Sale Id 1483348',1200.00,0.00,0.00,2.00,140.00,'2022-01-08 16:31:24','',''),(2469470,'1','179','933',413,'Retail Sale Id 1483448',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 16:40:50','',''),(2469595,'1','179','933',413,'Retail Sale Id 1483571',4500.00,0.00,0.00,7.50,525.00,'2022-01-08 16:51:33','',''),(2469616,'1','179','933',413,'Retail Sale Id 1483595',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 16:53:40','',''),(2469791,'1','179','933',413,'Retail Sale Id 1483762',1998.00,0.00,0.00,3.33,233.10,'2022-01-08 17:07:01','',''),(2470312,'1','179','933',413,'Retail Sale Id 1484262',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 17:47:08','',''),(2470328,'1','179','933',413,'Retail Sale Id 1484275',600.00,0.00,0.00,1.00,70.00,'2022-01-08 17:48:48','',''),(2470404,'1','179','933',413,'Retail Sale Id 1484393',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 17:56:50','',''),(2470412,'1','179','933',413,'Retail Sale Id 1484434',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 17:57:36','',''),(2470467,'1','179','933',413,'Retail Sale Id 1484514',1002.00,0.00,0.00,1.67,116.90,'2022-01-08 18:03:00','',''),(2470483,'1','179','933',413,'Retail Sale Id 1484529',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 18:04:27','',''),(2470531,'1','179','933',413,'Retail Sale Id 1484588',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 18:09:43','',''),(2470584,'1','179','933',413,'Retail Sale Id 1484654',3000.00,0.00,0.00,5.00,350.00,'2022-01-08 18:16:53','',''),(2470644,'1','179','933',413,'Retail Sale Id 1484708',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 18:25:17','',''),(2470666,'1','179','933',413,'Retail Sale Id 1484727',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 18:28:08','',''),(2470823,'1','179','933',413,'Retail Sale Id 1484848',1800.00,0.00,0.00,3.00,210.00,'2022-01-08 18:51:30','',''),(2470848,'1','179','933',413,'Retail Sale Id 1484871',3000.00,0.00,0.00,5.00,350.00,'2022-01-08 18:56:04','',''),(2470922,'1','179','933',413,'Retail Sale Id 1485061',7500.00,0.00,0.00,12.50,875.00,'2022-01-08 19:10:05','',''),(2470937,'1','179','933',413,'Retail Sale Id 1485076',3600.00,0.00,0.00,6.00,420.00,'2022-01-08 19:12:11','',''),(2471894,'1','179','933',413,'Retail Sale Id 1485567',9000.00,0.00,0.00,15.00,1050.00,'2022-01-09 08:19:10','',''),(2472173,'1','179','933',413,'Retail Sale Id 1485806',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 08:42:53','',''),(2472243,'1','179','933',413,'Retail Sale Id 1485877',3000.00,0.00,0.00,5.00,350.00,'2022-01-09 08:51:16','',''),(2472561,'1','179','933',413,'Retail Sale Id 1486199',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 09:20:00','',''),(2472748,'1','179','933',413,'Retail Sale Id 1486410',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 09:40:57','',''),(2472967,'1','179','933',413,'Retail Sale Id 1486627',4800.00,0.00,0.00,8.00,560.00,'2022-01-09 10:01:22','',''),(2472981,'1','179','933',413,'Retail Sale Id 1486645',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 10:02:50','',''),(2473033,'1','179','933',413,'Retail Sale Id 1486704',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 10:08:23','',''),(2473065,'1','179','933',413,'Retail Sale Id 1486739',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 10:11:37','',''),(2473142,'1','179','933',413,'Retail Sale Id 1486825',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 10:18:33','',''),(2473158,'1','179','933',413,'Retail Sale Id 1486839',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 10:19:48','',''),(2473191,'1','179','933',413,'Retail Sale Id 1486869',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 10:22:23','',''),(2473457,'1','179','933',413,'Retail Sale Id 1487059',1200.00,0.00,0.00,2.00,140.00,'2022-01-09 10:40:57','',''),(2473528,'1','179','933',413,'Retail Sale Id 1487133',3000.00,0.00,0.00,5.00,350.00,'2022-01-09 10:47:10','',''),(2473862,'1','179','933',413,'Retail Sale Id 1487411',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 11:11:24','',''),(2473934,'1','179','933',413,'Retail Sale Id 1487489',1998.00,0.00,0.00,3.33,233.10,'2022-01-09 11:19:52','',''),(2474066,'1','179','933',413,'Retail Sale Id 1487605',1998.00,0.00,0.00,3.33,233.10,'2022-01-09 11:27:51','',''),(2474161,'1','179','933',413,'Retail Sale Id 1487689',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 11:34:08','',''),(2474200,'1','179','933',413,'Retail Sale Id 1487715',3750.00,0.00,0.00,6.25,437.50,'2022-01-09 11:36:54','',''),(2474278,'1','179','933',413,'Retail Sale Id 1487780',7200.00,0.00,0.00,12.00,840.00,'2022-01-09 11:43:12','',''),(2474286,'1','179','933',413,'Retail Sale Id 1487786',1002.00,0.00,0.00,1.67,116.90,'2022-01-09 11:43:52','',''),(2474524,'1','179','933',413,'Retail Sale Id 1487995',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 12:03:13','',''),(2474571,'1','179','933',413,'Retail Sale Id 1488051',1002.00,0.00,0.00,1.67,116.90,'2022-01-09 12:07:38','',''),(2474757,'1','179','933',413,'Retail Sale Id 1488253',1998.00,0.00,0.00,3.33,233.10,'2022-01-09 12:26:18','',''),(2474799,'1','179','933',413,'Retail Sale Id 1488297',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 12:30:10','',''),(2474840,'1','179','933',413,'Retail Sale Id 1488342',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 12:33:38','',''),(2475032,'1','179','933',413,'Retail Sale Id 1488495',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 12:44:50','',''),(2475310,'1','179','933',413,'Retail Sale Id 1488770',1998.00,0.00,0.00,3.33,233.10,'2022-01-09 13:07:45','',''),(2475357,'1','179','933',413,'Retail Sale Id 1488819',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 13:13:50','',''),(2475405,'1','179','933',413,'Retail Sale Id 1488866',3000.00,0.00,0.00,5.00,350.00,'2022-01-09 13:17:56','',''),(2475580,'1','179','933',413,'Retail Sale Id 1489035',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 13:31:43','',''),(2475919,'1','179','933',413,'Retail Sale Id 1489399',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 14:04:10','',''),(2475929,'1','179','933',413,'Retail Sale Id 1489409',1500.00,0.00,0.00,2.50,175.00,'2022-01-09 14:04:56','',''),(2475940,'1','179','933',413,'Retail Sale Id 1489419',1500.00,0.00,0.00,2.50,175.00,'2022-01-09 14:05:55','',''),(2476172,'1','179','933',413,'Retail Sale Id 1489643',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 14:29:12','',''),(2476188,'1','179','933',413,'Retail Sale Id 1489656',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 14:30:54','',''),(2476332,'1','179','933',413,'Retail Sale Id 1489754',3000.00,0.00,0.00,5.00,350.00,'2022-01-09 14:41:31','',''),(2476342,'1','179','933',413,'Retail Sale Id 1489765',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 14:42:22','',''),(2476352,'1','179','933',413,'Retail Sale Id 1489774',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 14:43:58','',''),(2476523,'1','179','933',413,'Retail Sale Id 1489886',1998.00,0.00,0.00,3.33,233.10,'2022-01-09 14:55:31','',''),(2476556,'1','179','933',413,'Retail Sale Id 1489913',1500.00,0.00,0.00,2.50,175.00,'2022-01-09 14:58:00','',''),(2476700,'1','179','933',413,'Retail Sale Id 1490047',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 15:12:27','',''),(2477055,'1','179','933',413,'Retail Sale Id 1490366',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 15:48:00','',''),(2477326,'1','179','933',413,'Retail Sale Id 1490574',7002.00,0.00,0.00,11.67,816.90,'2022-01-09 16:12:43','',''),(2477340,'1','179','933',413,'Retail Sale Id 1490585',4002.00,0.00,0.00,6.67,466.90,'2022-01-09 16:13:38','',''),(2477487,'1','179','933',413,'Retail Sale Id 1490695',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 16:28:09','',''),(2477575,'1','179','933',413,'Retail Sale Id 1490890',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 16:39:03','',''),(2477597,'1','179','933',413,'Retail Sale Id 1490985',3000.00,0.00,0.00,5.00,350.00,'2022-01-09 16:40:59','',''),(2478008,'1','179','933',413,'Retail Sale Id 1491429',1800.00,0.00,0.00,3.00,210.00,'2022-01-09 17:16:05','',''),(2478061,'1','179','933',413,'Retail Sale Id 1491476',1998.00,0.00,0.00,3.33,233.10,'2022-01-09 17:23:08','',''),(2478636,'1','179','933',413,'Retail Sale Id 1491904',2100.00,0.00,0.00,3.50,245.00,'2022-01-09 18:26:58','',''),(2478642,'1','179','933',413,'Retail Sale Id 1491913',1200.00,0.00,0.00,2.00,140.00,'2022-01-09 18:28:47','',''),(2478645,'1','179','933',413,'Retail Sale Id 1491917',3000.00,0.00,0.00,5.00,350.00,'2022-01-09 18:30:09','',''),(2478733,'1','179','933',413,'Retail Sale Id 1491978',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 18:51:09','',''),(2478738,'1','179','933',413,'Retail Sale Id 1491982',7500.00,0.00,0.00,12.50,875.00,'2022-01-09 18:52:55','',''),(2478743,'1','179','933',413,'Retail Sale Id 1491986',6000.00,0.00,0.00,10.00,700.00,'2022-01-09 18:53:47','',''),(2478790,'1','179','933',413,'Retail Sale Id 1492000',6000.00,0.00,0.00,10.00,700.00,'2022-01-09 19:00:16','',''),(2478848,'1','179','933',413,'Retail Sale Id 1492059',2502.00,0.00,0.00,4.17,291.90,'2022-01-09 19:18:44','',''),(2478876,'1','179','933',413,'Retail Sale Id 1492070',3600.00,0.00,0.00,6.00,420.00,'2022-01-09 19:33:15','',''),(2479863,'1','179','933',413,'Retail Sale Id 1492455',3600.00,0.00,0.00,6.00,420.00,'2022-01-10 08:15:01','',''),(2479929,'1','179','933',413,'Retail Sale Id 1492525',7500.00,0.00,0.00,12.50,875.00,'2022-01-10 08:23:32','',''),(2480047,'1','179','933',413,'Retail Sale Id 1492644',7500.00,0.00,0.00,12.50,875.00,'2022-01-10 08:37:11','',''),(2480086,'1','179','933',413,'Retail Sale Id 1492678',1200.00,0.00,0.00,2.00,140.00,'2022-01-10 08:40:01','',''),(2480235,'1','179','933',413,'Retail Sale Id 1492811',1800.00,0.00,0.00,3.00,210.00,'2022-01-10 08:55:51','',''),(2480327,'1','179','933',413,'Retail Sale Id 1492887',1800.00,0.00,0.00,3.00,210.00,'2022-01-10 09:03:57','',''),(2480647,'1','179','933',413,'Retail Sale Id 1493107',7500.00,0.00,0.00,12.50,875.00,'2022-01-10 09:28:08','',''),(2480799,'1','179','933',413,'Retail Sale Id 1493255',1800.00,0.00,0.00,3.00,210.00,'2022-01-10 09:44:23','',''),(2480903,'1','179','933',413,'Retail Sale Id 1493316',1002.00,0.00,0.00,1.67,116.90,'2022-01-10 09:53:54','',''),(2480965,'1','179','933',413,'Retail Sale Id 1493378',1002.00,0.00,0.00,1.67,116.90,'2022-01-10 10:00:26','',''),(2482258,'1','179','933',413,'Retail Sale Id 1494554',7500.00,0.00,0.00,12.50,875.00,'2022-01-10 12:25:05','',''),(2485688,'1','179','933',413,'Retail Sale Id 1497661',163020.00,0.00,0.00,271.70,19019.00,'2022-01-10 18:24:21','',''),(2485760,'1','179','933',413,'Retail Sale Id 1497726',7500.00,0.00,0.00,12.50,875.00,'2022-01-10 18:33:25','',''),(2485783,'1','179','933',413,'Retail Sale Id 1497804',1800.00,0.00,0.00,3.00,210.00,'2022-01-10 18:39:01','',''),(2485789,'1','179','933',413,'Retail Sale Id 1497818',3600.00,0.00,0.00,6.00,420.00,'2022-01-10 18:39:42','',''),(2485952,'1','179','933',413,'Retail Sale Id 1497946',4800.00,0.00,0.00,8.00,560.00,'2022-01-10 19:17:37','',''),(2485956,'1','179','933',413,'Retail Sale Id 1497960',1800.00,0.00,0.00,3.00,210.00,'2022-01-10 19:18:55','',''),(2485981,'1','179','933',413,'Retail Sale Id 1497975',8100.00,0.00,0.00,13.50,945.00,'2022-01-10 19:25:01','',''),(2485994,'1','179','933',413,'Retail Sale Id 1497996',1002.00,0.00,0.00,1.67,116.90,'2022-01-10 19:39:26','',''),(2486976,'1','179','933',413,'Retail Sale Id 1498636',1002.00,0.00,0.00,1.67,116.90,'2022-01-11 08:28:52','',''),(2486996,'1','179','933',413,'Retail Sale Id 1498654',7500.00,0.00,0.00,12.50,875.00,'2022-01-11 08:30:52','',''),(2487056,'1','179','933',413,'Retail Sale Id 1498684',11298.00,0.00,0.00,18.83,1318.10,'2022-01-11 08:35:01','',''),(2487087,'1','179','933',413,'Retail Sale Id 1498691',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 08:35:59','',''),(2487120,'1','179','933',413,'Retail Sale Id 1498709',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 08:37:39','',''),(2487262,'1','179','933',413,'Retail Sale Id 1498767',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 08:43:18','',''),(2487480,'1','179','933',413,'Retail Sale Id 1498981',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 09:07:37','',''),(2487577,'1','179','933',413,'Retail Sale Id 1499075',3000.00,0.00,0.00,5.00,350.00,'2022-01-11 09:20:40','',''),(2487697,'1','179','933',413,'Retail Sale Id 1499152',798.00,0.00,0.00,1.33,93.10,'2022-01-11 09:29:23','',''),(2487807,'1','179','933',413,'Retail Sale Id 1499220',7500.00,0.00,0.00,12.50,875.00,'2022-01-11 09:38:02','',''),(2487951,'1','179','933',413,'Retail Sale Id 1499359',1800.00,0.00,0.00,3.00,210.00,'2022-01-11 09:52:07','',''),(2487996,'1','179','933',413,'Retail Sale Id 1499409',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 09:57:16','',''),(2488014,'1','179','933',413,'Retail Sale Id 1499423',1800.00,0.00,0.00,3.00,210.00,'2022-01-11 09:59:16','',''),(2488444,'1','179','933',413,'Retail Sale Id 1499769',1998.00,0.00,0.00,3.33,233.10,'2022-01-11 10:41:15','',''),(2488463,'1','179','933',413,'Retail Sale Id 1499790',4002.00,0.00,0.00,6.67,466.90,'2022-01-11 10:43:11','',''),(2488554,'1','179','933',413,'Retail Sale Id 1499852',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 10:50:56','',''),(2488915,'1','179','933',413,'Retail Sale Id 1500221',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 11:29:17','',''),(2488931,'1','179','933',413,'Retail Sale Id 1500234',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 11:30:39','',''),(2488946,'1','179','933',413,'Retail Sale Id 1500250',1002.00,0.00,0.00,1.67,116.90,'2022-01-11 11:32:09','',''),(2488984,'1','179','933',413,'Retail Sale Id 1500286',7500.00,0.00,0.00,12.50,875.00,'2022-01-11 11:35:51','',''),(2489000,'1','179','933',413,'Retail Sale Id 1500300',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 11:37:49','',''),(2489009,'1','179','933',413,'Retail Sale Id 1500317',1500.00,0.00,0.00,2.50,175.00,'2022-01-11 11:39:31','',''),(2489143,'1','179','933',413,'Retail Sale Id 1500370',1002.00,0.00,0.00,1.67,116.90,'2022-01-11 11:47:56','',''),(2489205,'1','179','933',413,'Retail Sale Id 1500423',3600.00,0.00,0.00,6.00,420.00,'2022-01-11 11:55:17','',''),(2493422,'1','179','933',413,'Retail Sale Id 1504161',4200.00,0.00,0.00,7.00,490.00,'2022-01-11 19:17:16','',''),(2493430,'1','179','933',413,'Retail Sale Id 1504165',1200.00,0.00,0.00,2.00,140.00,'2022-01-11 19:18:58','',''),(2493438,'1','179','933',413,'Retail Sale Id 1504172',150450.00,0.00,0.00,250.75,17552.50,'2022-01-11 19:22:25','',''),(2493464,'1','179','933',413,'Retail Sale Id 1504193',1800.00,0.00,0.00,3.00,210.00,'2022-01-11 19:31:27','',''),(2493480,'1','179','933',413,'Retail Sale Id 1504206',7200.00,0.00,0.00,12.00,840.00,'2022-01-11 19:37:39','',''),(2494737,'1','179','933',413,'Retail Sale Id 1504880',3600.00,0.00,0.00,6.00,420.00,'2022-01-12 08:40:10','',''),(2494820,'1','179','933',413,'Retail Sale Id 1504955',1200.00,0.00,0.00,2.00,140.00,'2022-01-12 08:47:48','',''),(2495436,'1','179','933',413,'Retail Sale Id 1505488',7500.00,0.00,0.00,12.50,875.00,'2022-01-12 09:38:56','',''),(2495734,'1','179','933',413,'Retail Sale Id 1505700',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 10:01:06','',''),(2495949,'1','179','933',413,'Retail Sale Id 1505922',1200.00,0.00,0.00,2.00,140.00,'2022-01-12 10:17:38','',''),(2496099,'1','179','933',413,'Retail Sale Id 1506098',2400.00,0.00,0.00,4.00,280.00,'2022-01-12 10:32:07','',''),(2496294,'1','179','933',413,'Retail Sale Id 1506331',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 10:53:15','',''),(2496401,'1','179','933',413,'Retail Sale Id 1506421',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 11:01:26','',''),(2496445,'1','179','933',413,'Retail Sale Id 1506476',1500.00,0.00,0.00,2.50,175.00,'2022-01-12 11:06:10','',''),(2496958,'1','179','933',413,'Retail Sale Id 1506912',7500.00,0.00,0.00,12.50,875.00,'2022-01-12 11:54:31','',''),(2497679,'1','179','933',413,'Retail Sale Id 1507658',26160.00,0.00,0.00,43.60,3052.00,'2022-01-12 13:21:16','',''),(2497796,'1','179','933',413,'Retail Sale Id 1507771',4002.00,0.00,0.00,6.67,466.90,'2022-01-12 13:34:46','',''),(2497808,'1','179','933',413,'Retail Sale Id 1507784',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 13:36:18','',''),(2497837,'1','179','933',413,'Retail Sale Id 1507804',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 13:39:41','',''),(2498228,'1','179','933',413,'Retail Sale Id 1508176',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 14:22:10','',''),(2498380,'1','179','933',413,'Retail Sale Id 1508319',3600.00,0.00,0.00,6.00,420.00,'2022-01-12 14:33:57','',''),(2499086,'1','179','933',413,'Retail Sale Id 1508896',6498.00,0.00,0.00,10.83,758.10,'2022-01-12 15:31:09','',''),(2499216,'1','179','933',413,'Retail Sale Id 1508999',7500.00,0.00,0.00,12.50,875.00,'2022-01-12 15:44:22','',''),(2499377,'1','179','933',413,'Retail Sale Id 1509160',7500.00,0.00,0.00,12.50,875.00,'2022-01-12 16:03:49','',''),(2499409,'1','179','933',413,'Retail Sale Id 1509193',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 16:08:01','',''),(2499431,'1','179','933',413,'Retail Sale Id 1509218',7500.00,0.00,0.00,12.50,875.00,'2022-01-12 16:10:21','',''),(2499601,'1','179','933',413,'Retail Sale Id 1509375',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 16:26:05','',''),(2499766,'1','179','933',413,'Retail Sale Id 1509531',5400.00,0.00,0.00,9.00,630.00,'2022-01-12 16:40:27','',''),(2499784,'1','179','933',413,'Retail Sale Id 1509546',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 16:42:09','',''),(2499921,'1','179','933',413,'Retail Sale Id 1509651',3600.00,0.00,0.00,6.00,420.00,'2022-01-12 16:51:09','',''),(2499950,'1','179','933',413,'Retail Sale Id 1509688',1200.00,0.00,0.00,2.00,140.00,'2022-01-12 16:53:34','',''),(2499984,'1','179','933',413,'Retail Sale Id 1509721',4002.00,0.00,0.00,6.67,466.90,'2022-01-12 16:56:37','',''),(2499997,'1','179','933',413,'Retail Sale Id 1509731',3600.00,0.00,0.00,6.00,420.00,'2022-01-12 16:57:34','',''),(2500185,'1','179','933',413,'Retail Sale Id 1509921',1500.00,0.00,0.00,2.50,175.00,'2022-01-12 17:15:59','',''),(2500206,'1','179','933',413,'Retail Sale Id 1509930',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 17:16:38','',''),(2500466,'1','179','933',413,'Retail Sale Id 1510172',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 17:40:51','',''),(2500629,'1','179','933',413,'Retail Sale Id 1510318',2502.00,0.00,0.00,4.17,291.90,'2022-01-12 17:55:32','',''),(2500703,'1','179','933',413,'Retail Sale Id 1510388',3600.00,0.00,0.00,6.00,420.00,'2022-01-12 18:02:44','',''),(2500735,'1','179','933',413,'Retail Sale Id 1510437',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 18:06:30','',''),(2500736,'1','179','933',413,'Retail Sale Id 1510437',3000.00,0.00,0.00,5.00,350.00,'2022-01-12 18:06:30','',''),(2500737,'1','179','933',413,'Retail Sale Id 1510437',7500.00,0.00,0.00,12.50,875.00,'2022-01-12 18:06:30','',''),(2500808,'1','179','933',413,'Retail Sale Id 1510542',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 18:10:21','',''),(2500863,'1','179','933',413,'Retail Sale Id 1510595',5400.00,0.00,0.00,9.00,630.00,'2022-01-12 18:17:21','',''),(2500896,'1','179','933',413,'Retail Sale Id 1510624',3600.00,0.00,0.00,6.00,420.00,'2022-01-12 18:22:03','',''),(2501007,'1','179','933',413,'Retail Sale Id 1510773',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 18:41:38','',''),(2501021,'1','179','933',413,'Retail Sale Id 1510786',4002.00,0.00,0.00,6.67,466.90,'2022-01-12 18:44:18','',''),(2501025,'1','179','933',413,'Retail Sale Id 1510791',1002.00,0.00,0.00,1.67,116.90,'2022-01-12 18:45:11','',''),(2501205,'1','179','933',413,'Retail Sale Id 1510957',1998.00,0.00,0.00,3.33,233.10,'2022-01-12 19:15:22','',''),(2501262,'1','179','933',413,'Retail Sale Id 1510997',1800.00,0.00,0.00,3.00,210.00,'2022-01-12 19:25:48','',''),(2502611,'1','179','933',413,'Retail Sale Id 1511826',1200.00,0.00,0.00,2.00,140.00,'2022-01-13 08:59:01','',''),(2502632,'1','179','933',413,'Retail Sale Id 1511848',5802.00,0.00,0.00,9.67,676.90,'2022-01-13 09:02:04','',''),(2503102,'1','179','933',413,'Retail Sale Id 1512183',1800.00,0.00,0.00,3.00,210.00,'2022-01-13 09:43:49','',''),(2506463,'1','179','933',413,'Retail Sale Id 1515078',48000.00,0.00,0.00,80.00,5600.00,'2022-01-13 15:18:28','',''),(2507646,'1','179','933',413,'Retail Sale Id 1516091',15000.00,0.00,0.00,25.00,1750.00,'2022-01-13 17:06:39','',''),(2507726,'1','179','933',413,'Retail Sale Id 1516182',1002.00,0.00,0.00,1.67,116.90,'2022-01-13 17:13:58','',''),(2507981,'1','179','933',413,'Retail Sale Id 1516501',7602.00,0.00,0.00,12.67,886.90,'2022-01-13 17:40:09','',''),(2509958,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,2687700.00,5100.00,0.00,0.00,'2022-01-14 08:30:05','',''),(2509967,'1','179',NULL,413,'Reception corrector for bridging 130819',0.00,0.00,0.00,5100.00,0.00,'2022-01-14 08:31:18','',''),(2509968,'1','179','933',413,'Received from bridging 130819',0.00,0.00,5100.00,0.00,0.00,'2022-01-14 08:31:18','',''),(2510014,'1','179','933',413,'Retail Sale Id 1517931',10800.00,0.00,0.00,18.00,1314.00,'2022-01-14 08:33:36','',''),(2510344,'1','179','933',413,'Retail Sale Id 1518205',3600.00,0.00,0.00,6.00,438.00,'2022-01-14 09:02:21','',''),(2510431,'1','179','933',413,'Retail Sale Id 1518306',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 09:11:33','',''),(2510730,'1','179','933',413,'Retail Sale Id 1518602',1002.00,0.00,0.00,1.67,121.91,'2022-01-14 09:34:43','',''),(2511153,'1','179','933',413,'Retail Sale Id 1518914',2400.00,0.00,0.00,4.00,292.00,'2022-01-14 10:03:16','',''),(2511251,'1','179','933',413,'Retail Sale Id 1519031',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 10:12:57','',''),(2511438,'1','179','933',413,'Retail Sale Id 1519249',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 10:33:48','',''),(2511497,'1','179','933',413,'Retail Sale Id 1519332',1002.00,0.00,0.00,1.67,121.91,'2022-01-14 10:40:58','',''),(2511919,'1','179','933',413,'Retail Sale Id 1519675',600000.00,0.00,0.00,1000.00,73000.00,'2022-01-14 11:21:23','',''),(2512066,'1','179','933',413,'Retail Sale Id 1519851',3000.00,0.00,0.00,5.00,365.00,'2022-01-14 11:37:49','',''),(2512125,'1','179','933',413,'Retail Sale Id 1519912',1002.00,0.00,0.00,1.67,121.91,'2022-01-14 11:45:21','',''),(2512504,'1','179','933',413,'Retail Sale Id 1520246',15300.00,0.00,0.00,25.50,1861.50,'2022-01-14 12:30:38','',''),(2512524,'1','179','933',413,'Retail Sale Id 1520267',4002.00,0.00,0.00,6.67,486.91,'2022-01-14 12:33:09','',''),(2512751,'1','179','933',413,'Retail Sale Id 1520463',1500.00,0.00,0.00,2.50,182.50,'2022-01-14 13:04:26','',''),(2512825,'1','179','933',413,'Retail Sale Id 1520529',3600.00,0.00,0.00,6.00,438.00,'2022-01-14 13:19:25','',''),(2512837,'1','179','933',413,'Retail Sale Id 1520540',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 13:23:07','',''),(2512904,'1','179','933',413,'Return of Retail Sale Id 1519675',0.00,600000.00,1000.00,0.00,-73000.00,'2022-01-14 13:33:58','',''),(2512926,'1','179','933',413,'Retail Sale Id 1520620',1500.00,0.00,0.00,2.50,182.50,'2022-01-14 13:38:27','',''),(2513166,'1','179','933',413,'Retail Sale Id 1520815',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 14:11:25','',''),(2513501,'1','179','933',413,'Retail Sale Id 1521050',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 14:42:53','',''),(2513661,'1','179','933',413,'Retail Sale Id 1521234',3600.00,0.00,0.00,6.00,438.00,'2022-01-14 14:58:56','',''),(2513738,'1','179','933',413,'Retail Sale Id 1521366',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 15:06:53','',''),(2513796,'1','179','933',413,'Retail Sale Id 1521420',3000.00,0.00,0.00,5.00,365.00,'2022-01-14 15:11:55','',''),(2513810,'1','179','933',413,'Retail Sale Id 1521426',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 15:14:03','',''),(2513819,'1','179','933',413,'Retail Sale Id 1521441',9300.00,0.00,0.00,15.50,1131.50,'2022-01-14 15:15:36','',''),(2513951,'1','179','933',413,'Retail Sale Id 1521556',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 15:27:42','',''),(2514226,'1','179','933',413,'Retail Sale Id 1521838',3600.00,0.00,0.00,6.00,438.00,'2022-01-14 15:53:14','',''),(2514501,'1','179','933',413,'Retail Sale Id 1522059',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 16:16:04','',''),(2514512,'1','179','933',413,'Retail Sale Id 1522068',1002.00,0.00,0.00,1.67,121.91,'2022-01-14 16:17:51','',''),(2515128,'1','179','933',413,'Retail Sale Id 1522766',9000.00,0.00,0.00,15.00,1095.00,'2022-01-14 17:17:43','',''),(2515146,'1','179','933',413,'Retail Sale Id 1522791',3600.00,0.00,0.00,6.00,438.00,'2022-01-14 17:19:24','',''),(2515231,'1','179','933',413,'Retail Sale Id 1522885',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 17:26:58','',''),(2515403,'1','179','933',413,'Retail Sale Id 1523072',4800.00,0.00,0.00,8.00,584.00,'2022-01-14 17:42:21','',''),(2515570,'1','179','933',413,'Retail Sale Id 1523279',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 17:58:06','',''),(2515707,'1','179','933',413,'Retail Sale Id 1523379',1998.00,0.00,0.00,3.33,243.09,'2022-01-14 18:09:44','',''),(2515755,'1','179','933',413,'Retail Sale Id 1523429',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 18:16:13','',''),(2515802,'1','179','933',413,'Retail Sale Id 1523476',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 18:24:54','',''),(2515809,'1','179','933',413,'Retail Sale Id 1523483',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 18:26:17','',''),(2515960,'1','179','933',413,'Retail Sale Id 1523734',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 18:59:12','',''),(2516235,'1','179','933',413,'Retail Sale Id 1523873',1998.00,0.00,0.00,3.33,243.09,'2022-01-14 19:29:23','',''),(2516238,'1','179','933',413,'Retail Sale Id 1523876',1800.00,0.00,0.00,3.00,219.00,'2022-01-14 19:30:31','',''),(2516272,'1','179','933',413,'Retail Sale Id 1523900',7500.00,0.00,0.00,12.50,912.50,'2022-01-14 19:41:57','',''),(2517369,'1','179','933',413,'Retail Sale Id 1524430',6000.00,0.00,0.00,10.00,730.00,'2022-01-15 08:20:01','',''),(2517761,'1','179','933',413,'Retail Sale Id 1524774',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 08:55:57','',''),(2518121,'1','179','933',413,'Retail Sale Id 1525099',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 09:25:10','',''),(2518165,'1','179','933',413,'Retail Sale Id 1525124',2502.00,0.00,0.00,4.17,304.41,'2022-01-15 09:26:54','',''),(2518483,'1','179','933',413,'Retail Sale Id 1525379',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 09:48:36','',''),(2518508,'1','179','933',413,'Retail Sale Id 1525405',6000.00,0.00,0.00,10.00,730.00,'2022-01-15 09:51:08','',''),(2518520,'1','179','933',413,'Retail Sale Id 1525415',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 09:52:07','',''),(2518989,'1','179','933',413,'Retail Sale Id 1525889',4398.00,0.00,0.00,7.33,535.09,'2022-01-15 10:30:35','',''),(2519160,'1','179','933',413,'Retail Sale Id 1526026',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 10:41:46','',''),(2519268,'1','179','933',413,'Retail Sale Id 1526119',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 10:49:46','',''),(2519422,'1','179','933',413,'Retail Sale Id 1526241',1200.00,0.00,0.00,2.00,146.00,'2022-01-15 10:59:57','',''),(2519456,'1','179','933',413,'Retail Sale Id 1526272',1002.00,0.00,0.00,1.67,121.91,'2022-01-15 11:03:24','',''),(2519537,'1','179','933',413,'Retail Sale Id 1526339',7500.00,0.00,0.00,12.50,912.50,'2022-01-15 11:10:25','',''),(2519546,'1','179','933',413,'Retail Sale Id 1526349',6900.00,0.00,0.00,11.50,839.50,'2022-01-15 11:11:20','',''),(2519620,'1','179','933',413,'Retail Sale Id 1526405',4002.00,0.00,0.00,6.67,486.91,'2022-01-15 11:16:47','',''),(2519681,'1','179','933',413,'Retail Sale Id 1526469',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 11:21:41','',''),(2519748,'1','179','933',413,'Retail Sale Id 1526539',1500.00,0.00,0.00,2.50,182.50,'2022-01-15 11:27:06','',''),(2520032,'1','179','933',413,'Retail Sale Id 1526800',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 11:51:10','',''),(2520628,'1','179','933',413,'Retail Sale Id 1527388',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 12:40:51','',''),(2520791,'1','179','933',413,'Retail Sale Id 1527526',7500.00,0.00,0.00,12.50,912.50,'2022-01-15 12:55:53','',''),(2520822,'1','179','933',413,'Retail Sale Id 1527558',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 12:58:59','',''),(2521753,'1','179','933',413,'Retail Sale Id 1528142',8502.00,0.00,0.00,14.17,1034.41,'2022-01-15 14:18:48','',''),(2521763,'1','179','933',413,'Retail Sale Id 1528376',7500.00,0.00,0.00,12.50,912.50,'2022-01-15 14:19:42','',''),(2521930,'1','179','933',413,'Retail Sale Id 1528518',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 14:34:47','',''),(2522016,'1','179','933',413,'Retail Sale Id 1528602',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 14:44:09','',''),(2522046,'1','179','933',413,'Retail Sale Id 1528636',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 14:46:53','',''),(2522402,'1','179','933',413,'Retail Sale Id 1528859',1998.00,0.00,0.00,3.33,243.09,'2022-01-15 15:05:46','',''),(2522410,'1','179','933',413,'Retail Sale Id 1528874',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 15:06:40','',''),(2522443,'1','179','933',413,'Retail Sale Id 1528907',1500.00,0.00,0.00,2.50,182.50,'2022-01-15 15:09:14','',''),(2522479,'1','179','933',413,'Retail Sale Id 1528920',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 15:11:31','',''),(2522501,'1','179','933',413,'Retail Sale Id 1528931',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 15:12:44','',''),(2522624,'1','179','933',413,'Retail Sale Id 1529011',1998.00,0.00,0.00,3.33,243.09,'2022-01-15 15:22:52','',''),(2522681,'1','179','933',413,'Retail Sale Id 1529065',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 15:29:47','',''),(2522697,'1','179','933',413,'Retail Sale Id 1529080',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 15:31:28','',''),(2522794,'1','179','933',413,'Retail Sale Id 1529213',4998.00,0.00,0.00,8.33,608.09,'2022-01-15 15:40:33','',''),(2522869,'1','179','933',413,'Retail Sale Id 1529274',1500.00,0.00,0.00,2.50,182.50,'2022-01-15 15:47:11','',''),(2522895,'1','179','933',413,'Retail Sale Id 1529294',1500.00,0.00,0.00,2.50,182.50,'2022-01-15 15:50:02','',''),(2523250,'1','179','933',413,'Retail Sale Id 1529674',3600.00,0.00,0.00,6.00,438.00,'2022-01-15 16:26:39','',''),(2523375,'1','179','933',413,'Retail Sale Id 1529768',1998.00,0.00,0.00,3.33,243.09,'2022-01-15 16:34:16','',''),(2523544,'1','179','933',413,'Retail Sale Id 1529909',1002.00,0.00,0.00,1.67,121.91,'2022-01-15 16:45:18','',''),(2524215,'1','179','933',413,'Retail Sale Id 1530470',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 17:28:09','',''),(2524228,'1','179','933',413,'Retail Sale Id 1530484',1800.00,0.00,0.00,3.00,219.00,'2022-01-15 17:28:54','',''),(2524243,'1','179','933',413,'Retail Sale Id 1530497',1002.00,0.00,0.00,1.67,121.91,'2022-01-15 17:30:09','',''),(2524401,'1','179','933',413,'Retail Sale Id 1530656',4002.00,0.00,0.00,6.67,486.91,'2022-01-15 17:41:55','',''),(2524615,'1','179','933',413,'Retail Sale Id 1530840',1998.00,0.00,0.00,3.33,243.09,'2022-01-15 17:56:53','',''),(2524831,'1','179','933',413,'Retail Sale Id 1531054',1200.00,0.00,0.00,2.00,146.00,'2022-01-15 18:19:35','',''),(2525317,'1','179','933',413,'Retail Sale Id 1531451',3000.00,0.00,0.00,5.00,365.00,'2022-01-15 19:38:31','',''),(2525333,'1','179','933',413,'Retail Sale Id 1531468',15600.00,0.00,0.00,26.00,1898.00,'2022-01-15 19:47:10','',''),(2525365,'1','179','933',413,'Retail Sale Id 1531491',6000.00,0.00,0.00,10.00,730.00,'2022-01-15 20:00:07','',''),(2526428,'1','179','933',413,'Retail Sale Id 1532057',1998.00,0.00,0.00,3.33,243.09,'2022-01-16 08:28:08','',''),(2526959,'1','179','933',413,'Retail Sale Id 1532557',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 09:15:17','',''),(2526977,'1','179','933',413,'Retail Sale Id 1532579',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 09:16:53','',''),(2527014,'1','179','933',413,'Retail Sale Id 1532597',4002.00,0.00,0.00,6.67,486.91,'2022-01-16 09:18:52','',''),(2527396,'1','179','933',413,'Retail Sale Id 1532947',1998.00,0.00,0.00,3.33,243.09,'2022-01-16 09:48:27','',''),(2527574,'1','179','933',413,'Retail Sale Id 1533143',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 10:03:53','',''),(2527845,'1','179','933',413,'Retail Sale Id 1533355',3702.00,0.00,0.00,6.17,450.41,'2022-01-16 10:20:59','',''),(2528620,'1','179','933',413,'Retail Sale Id 1534068',28998.00,0.00,0.00,48.33,3528.09,'2022-01-16 11:22:07','',''),(2528631,'1','179','933',413,'Retail Sale Id 1534110',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 11:22:58','',''),(2529668,'1','179','933',413,'Retail Sale Id 1535185',54498.00,0.00,0.00,90.83,6630.59,'2022-01-16 13:01:34','',''),(2529673,'1','179','933',413,'Retail Sale Id 1535204',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 13:02:22','',''),(2529801,'1','179','933',413,'Retail Sale Id 1535333',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 13:14:52','',''),(2530171,'1','179','933',413,'Retail Sale Id 1535777',19002.00,0.00,0.00,31.67,2311.91,'2022-01-16 13:52:15','',''),(2530185,'1','179','933',413,'Retail Sale Id 1535825',1602.00,0.00,0.00,2.67,194.91,'2022-01-16 13:53:30','',''),(2530250,'1','179','933',413,'Retail Sale Id 1535867',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 13:58:29','',''),(2530310,'1','179','933',413,'Retail Sale Id 1535930',1500.00,0.00,0.00,2.50,182.50,'2022-01-16 14:03:58','',''),(2530350,'1','179','933',413,'Retail Sale Id 1535983',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 14:08:58','',''),(2530438,'1','179','933',413,'Retail Sale Id 1536066',1002.00,0.00,0.00,1.67,121.91,'2022-01-16 14:18:47','',''),(2530671,'1','179','933',413,'Retail Sale Id 1536243',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 14:38:07','',''),(2530999,'1','179','933',413,'Retail Sale Id 1536484',1002.00,0.00,0.00,1.67,121.91,'2022-01-16 15:03:46','',''),(2531547,'1','179','933',413,'Retail Sale Id 1536891',1998.00,0.00,0.00,3.33,243.09,'2022-01-16 15:53:38','',''),(2531556,'1','179','933',413,'Retail Sale Id 1536900',1698.00,0.00,0.00,2.83,206.59,'2022-01-16 15:54:58','',''),(2531566,'1','179','933',413,'Retail Sale Id 1536911',2502.00,0.00,0.00,4.17,304.41,'2022-01-16 15:56:25','',''),(2531696,'1','179','933',413,'Retail Sale Id 1537055',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 16:11:24','',''),(2531757,'1','179','933',413,'Retail Sale Id 1537123',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 16:18:16','',''),(2531890,'1','179','933',413,'Retail Sale Id 1537214',3552.00,0.00,0.00,5.92,432.16,'2022-01-16 16:28:45','',''),(2532318,'1','179','933',413,'Retail Sale Id 1537572',2400.00,0.00,0.00,4.00,292.00,'2022-01-16 17:00:50','',''),(2532505,'1','179','933',413,'Retail Sale Id 1537749',3000.00,0.00,0.00,5.00,365.00,'2022-01-16 17:14:26','',''),(2532772,'1','179','933',413,'Retail Sale Id 1538103',1500.00,0.00,0.00,2.50,182.50,'2022-01-16 17:37:31','',''),(2532789,'1','179','933',413,'Retail Sale Id 1538120',1998.00,0.00,0.00,3.33,243.09,'2022-01-16 17:39:06','',''),(2532806,'1','179','933',413,'Retail Sale Id 1538138',1002.00,0.00,0.00,1.67,121.91,'2022-01-16 17:40:17','',''),(2532983,'1','179','933',413,'Retail Sale Id 1538287',2502.00,0.00,0.00,4.17,304.41,'2022-01-16 17:53:47','',''),(2533017,'1','179','933',413,'Retail Sale Id 1538325',7200.00,0.00,0.00,12.00,876.00,'2022-01-16 17:57:31','',''),(2533041,'1','179','933',413,'Retail Sale Id 1538352',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 18:00:35','',''),(2533049,'1','179','933',413,'Retail Sale Id 1538359',7500.00,0.00,0.00,12.50,912.50,'2022-01-16 18:01:30','',''),(2533187,'1','179','933',413,'Retail Sale Id 1538458',2802.00,0.00,0.00,4.67,340.91,'2022-01-16 18:12:28','',''),(2533269,'1','179','933',413,'Retail Sale Id 1538517',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 18:20:08','',''),(2533584,'1','179','933',413,'Retail Sale Id 1538753',1800.00,0.00,0.00,3.00,219.00,'2022-01-16 19:06:25','',''),(2533592,'1','179','933',413,'Retail Sale Id 1538760',3600.00,0.00,0.00,6.00,438.00,'2022-01-16 19:07:49','',''),(2534745,'1','179','933',413,'Retail Sale Id 1539412',9300.00,0.00,0.00,15.50,1131.50,'2022-01-17 08:31:42','',''),(2534906,'1','179','933',413,'Retail Sale Id 1539589',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 08:51:14','',''),(2534928,'1','179','933',413,'Retail Sale Id 1539612',12000.00,0.00,0.00,20.00,1460.00,'2022-01-17 08:54:47','',''),(2535250,'1','179','933',413,'Retail Sale Id 1539847',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 09:27:35','',''),(2535501,'1','179','933',413,'Retail Sale Id 1540080',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 09:56:27','',''),(2535558,'1','179','933',413,'Retail Sale Id 1540128',15000.00,0.00,0.00,25.00,1825.00,'2022-01-17 10:03:34','',''),(2535778,'1','179','933',413,'Retail Sale Id 1540271',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 10:22:51','',''),(2535823,'1','179','933',413,'Retail Sale Id 1540314',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 10:29:46','',''),(2536104,'1','179','933',413,'Retail Sale Id 1540491',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 10:58:42','',''),(2536149,'1','179','933',413,'Retail Sale Id 1540560',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 11:04:25','',''),(2536475,'1','179','933',413,'Retail Sale Id 1540857',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 11:44:09','',''),(2536591,'1','179','933',413,'Retail Sale Id 1540982',4002.00,0.00,0.00,6.67,486.91,'2022-01-17 11:59:53','',''),(2536647,'1','179','933',413,'Retail Sale Id 1541051',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 12:07:32','',''),(2536828,'1','179','933',413,'Retail Sale Id 1541239',6000.00,0.00,0.00,10.00,730.00,'2022-01-17 12:31:53','',''),(2536878,'1','179','933',413,'Retail Sale Id 1541286',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 12:38:03','',''),(2536899,'1','179','933',413,'Retail Sale Id 1541302',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 12:40:29','',''),(2536902,'1','179','933',413,'Retail Sale Id 1541307',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 12:41:20','',''),(2536964,'1','179','933',413,'Retail Sale Id 1541363',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 12:49:52','',''),(2537117,'1','179','933',413,'Retail Sale Id 1541506',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 13:13:12','',''),(2537128,'1','179','933',413,'Retail Sale Id 1541518',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 13:14:51','',''),(2537134,'1','179','933',413,'Retail Sale Id 1541525',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 13:15:49','',''),(2537154,'1','179','933',413,'Retail Sale Id 1541545',1200.00,0.00,0.00,2.00,146.00,'2022-01-17 13:18:26','',''),(2537168,'1','179','933',413,'Retail Sale Id 1541558',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 13:20:03','',''),(2537201,'1','179','933',413,'Retail Sale Id 1541585',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 13:24:49','',''),(2537267,'1','179','933',413,'Retail Sale Id 1541643',1500.00,0.00,0.00,2.50,182.50,'2022-01-17 13:32:38','',''),(2537429,'1','179','933',413,'Retail Sale Id 1541796',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 13:53:12','',''),(2537449,'1','179','933',413,'Retail Sale Id 1541827',2502.00,0.00,0.00,4.17,304.41,'2022-01-17 13:55:31','',''),(2537754,'1','179','933',413,'Retail Sale Id 1541837',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 14:25:57','',''),(2537913,'1','179','933',413,'Retail Sale Id 1542192',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 14:43:22','',''),(2538031,'1','179','933',413,'Retail Sale Id 1542277',6000.00,0.00,0.00,10.00,730.00,'2022-01-17 14:53:51','',''),(2538293,'1','179','933',413,'Retail Sale Id 1542440',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 15:13:06','',''),(2538320,'1','179','933',413,'Retail Sale Id 1542464',1998.00,0.00,0.00,3.33,243.09,'2022-01-17 15:14:20','',''),(2538717,'1','179','933',413,'Retail Sale Id 1542819',3498.00,0.00,0.00,5.83,425.59,'2022-01-17 15:54:50','',''),(2538836,'1','179','933',413,'Retail Sale Id 1542910',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 16:06:33','',''),(2538851,'1','179','933',413,'Retail Sale Id 1542921',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 16:07:37','',''),(2539343,'1','179','933',413,'Retail Sale Id 1543436',1500.00,0.00,0.00,2.50,182.50,'2022-01-17 16:54:43','',''),(2539344,'1','179','933',413,'Retail Sale Id 1543436',1500.00,0.00,0.00,2.50,182.50,'2022-01-17 16:54:43','',''),(2539656,'1','179','933',413,'Retail Sale Id 1543759',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 17:17:11','',''),(2539835,'1','179','933',413,'Retail Sale Id 1543947',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 17:30:15','',''),(2539852,'1','179','933',413,'Retail Sale Id 1543962',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 17:31:27','',''),(2539878,'1','179','933',413,'Retail Sale Id 1543989',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 17:33:25','',''),(2539890,'1','179','933',413,'Retail Sale Id 1544000',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 17:34:20','',''),(2539974,'1','179','933',413,'Retail Sale Id 1544080',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 17:40:45','',''),(2539987,'1','179','933',413,'Retail Sale Id 1544096',1998.00,0.00,0.00,3.33,243.09,'2022-01-17 17:41:42','',''),(2540037,'1','179','933',413,'Retail Sale Id 1544144',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 17:45:02','',''),(2540048,'1','179','933',413,'Retail Sale Id 1544157',1200.00,0.00,0.00,2.00,146.00,'2022-01-17 17:46:16','',''),(2540059,'1','179','933',413,'Retail Sale Id 1544167',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 17:46:55','',''),(2540065,'1','179','933',413,'Retail Sale Id 1544172',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 17:47:57','',''),(2540083,'1','179','933',413,'Retail Sale Id 1544189',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 17:49:28','',''),(2540114,'1','179','933',413,'Retail Sale Id 1544199',3600.00,0.00,0.00,6.00,438.00,'2022-01-17 17:50:35','',''),(2540195,'1','179','933',413,'Retail Sale Id 1544252',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 17:55:29','',''),(2540242,'1','179','933',413,'Retail Sale Id 1544286',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 17:58:45','',''),(2540255,'1','179','933',413,'Retail Sale Id 1544302',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 18:00:02','',''),(2540359,'1','179','933',413,'Retail Sale Id 1544593',1002.00,0.00,0.00,1.67,121.91,'2022-01-17 18:13:08','',''),(2540421,'1','179','933',413,'Retail Sale Id 1544656',1800.00,0.00,0.00,3.00,219.00,'2022-01-17 18:23:30','',''),(2540436,'1','179','933',413,'Retail Sale Id 1544674',7500.00,0.00,0.00,12.50,912.50,'2022-01-17 18:26:41','',''),(2540521,'1','179','933',413,'Retail Sale Id 1544788',8298.00,0.00,0.00,13.83,1009.59,'2022-01-17 18:54:03','',''),(2540625,'1','179','933',413,'Retail Sale Id 1544870',3000.00,0.00,0.00,5.00,365.00,'2022-01-17 19:46:09','',''),(2540634,'1','179','933',413,'Retail Sale Id 1544874',10500.00,0.00,0.00,17.50,1277.50,'2022-01-17 19:54:33','',''),(2541680,'1','179','933',413,'Retail Sale Id 1545479',1002.00,0.00,0.00,1.67,121.91,'2022-01-18 08:49:33','',''),(2541889,'1','179','933',413,'Retail Sale Id 1545646',3600.00,0.00,0.00,6.00,438.00,'2022-01-18 09:12:14','',''),(2542047,'1','179','933',413,'Retail Sale Id 1545730',1500.00,0.00,0.00,2.50,182.50,'2022-01-18 09:26:11','',''),(2542183,'1','179','933',413,'Retail Sale Id 1545810',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 09:37:54','',''),(2542208,'1','179','933',413,'Retail Sale Id 1545838',6000.00,0.00,0.00,10.00,730.00,'2022-01-18 09:40:38','',''),(2542287,'1','179','933',413,'Retail Sale Id 1545892',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 09:46:19','',''),(2542392,'1','179','933',413,'Retail Sale Id 1545983',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 09:58:59','',''),(2542513,'1','179','933',413,'Retail Sale Id 1546045',1200.00,0.00,0.00,2.00,146.00,'2022-01-18 10:05:24','',''),(2542534,'1','179','933',413,'Retail Sale Id 1546064',7002.00,0.00,0.00,11.67,851.91,'2022-01-18 10:08:33','',''),(2542625,'1','179','933',413,'Retail Sale Id 1546133',3498.00,0.00,0.00,5.83,425.59,'2022-01-18 10:15:54','',''),(2542778,'1','179','933',413,'Retail Sale Id 1546244',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 10:28:22','',''),(2542851,'1','179','933',413,'Retail Sale Id 1546302',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 10:36:05','',''),(2542865,'1','179','933',413,'Retail Sale Id 1546315',2400.00,0.00,0.00,4.00,292.00,'2022-01-18 10:37:45','',''),(2543038,'1','179','933',413,'Retail Sale Id 1546438',1998.00,0.00,0.00,3.33,243.09,'2022-01-18 10:50:06','',''),(2543555,'1','179','933',413,'Retail Sale Id 1546904',1200.00,0.00,0.00,2.00,146.00,'2022-01-18 11:48:19','',''),(2543557,'1','179','933',413,'Retail Sale Id 1546907',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 11:49:13','',''),(2543940,'1','179','933',413,'Retail Sale Id 1547294',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 12:37:53','',''),(2544046,'1','179','933',413,'Retail Sale Id 1547398',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 12:49:31','',''),(2544199,'1','179','933',413,'Retail Sale Id 1547557',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 13:12:05','',''),(2544298,'1','179','933',413,'Retail Sale Id 1547668',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 13:23:16','',''),(2544327,'1','179','933',413,'Retail Sale Id 1547696',4002.00,0.00,0.00,6.67,486.91,'2022-01-18 13:27:33','',''),(2544477,'1','179','933',413,'Retail Sale Id 1547854',1200.00,0.00,0.00,2.00,146.00,'2022-01-18 13:44:28','',''),(2544540,'1','179','933',413,'Retail Sale Id 1547910',7500.00,0.00,0.00,12.50,912.50,'2022-01-18 13:52:26','',''),(2544655,'1','179','933',413,'Retail Sale Id 1548017',3600.00,0.00,0.00,6.00,438.00,'2022-01-18 14:04:30','',''),(2544736,'1','179','933',413,'Retail Sale Id 1548099',5502.00,0.00,0.00,9.17,669.41,'2022-01-18 14:13:45','',''),(2544853,'1','179','933',413,'Retail Sale Id 1548189',2400.00,0.00,0.00,4.00,292.00,'2022-01-18 14:25:49','',''),(2544862,'1','179','933',413,'Retail Sale Id 1548198',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 14:27:15','',''),(2544892,'1','179','933',413,'Retail Sale Id 1548222',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 14:30:37','',''),(2545218,'1','179','933',413,'Retail Sale Id 1548473',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 14:57:11','',''),(2545227,'1','179','933',413,'Retail Sale Id 1548484',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 14:58:08','',''),(2545239,'1','179','933',413,'Retail Sale Id 1548502',2502.00,0.00,0.00,4.17,304.41,'2022-01-18 14:59:21','',''),(2545368,'1','179','933',413,'Retail Sale Id 1548605',1002.00,0.00,0.00,1.67,121.91,'2022-01-18 15:09:58','',''),(2546468,'1','179','933',413,'Retail Sale Id 1549560',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 16:48:53','',''),(2546504,'1','179','933',413,'Retail Sale Id 1549594',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 16:52:01','',''),(2546658,'1','179','933',413,'Retail Sale Id 1549698',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 17:01:15','',''),(2546700,'1','179','933',413,'Retail Sale Id 1549720',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:02:59','',''),(2546844,'1','179','933',413,'Retail Sale Id 1549878',21660.00,0.00,0.00,36.10,2635.30,'2022-01-18 17:14:07','',''),(2546975,'1','179','933',413,'Retail Sale Id 1550010',1500.00,0.00,0.00,2.50,182.50,'2022-01-18 17:23:55','',''),(2547033,'1','179','933',413,'Retail Sale Id 1550067',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:27:58','',''),(2547046,'1','179','933',413,'Retail Sale Id 1550084',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:29:15','',''),(2547103,'1','179','933',413,'Retail Sale Id 1550130',1002.00,0.00,0.00,1.67,121.91,'2022-01-18 17:33:23','',''),(2547118,'1','179','933',413,'Retail Sale Id 1550146',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:34:45','',''),(2547137,'1','179','933',413,'Retail Sale Id 1550163',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:36:14','',''),(2547284,'1','179','933',413,'Retail Sale Id 1550295',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 17:48:37','',''),(2547311,'1','179','933',413,'Retail Sale Id 1550326',1002.00,0.00,0.00,1.67,121.91,'2022-01-18 17:50:29','',''),(2547323,'1','179','933',413,'Retail Sale Id 1550334',2100.00,0.00,0.00,3.50,255.50,'2022-01-18 17:51:31','',''),(2547429,'1','179','933',413,'Retail Sale Id 1550449',3600.00,0.00,0.00,6.00,438.00,'2022-01-18 18:02:02','',''),(2547469,'1','179','933',413,'Retail Sale Id 1550492',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 18:06:24','',''),(2547517,'1','179','933',413,'Retail Sale Id 1550548',1002.00,0.00,0.00,1.67,121.91,'2022-01-18 18:11:35','',''),(2547528,'1','179','933',413,'Retail Sale Id 1550561',1200.00,0.00,0.00,2.00,146.00,'2022-01-18 18:12:33','',''),(2547539,'1','179','933',413,'Retail Sale Id 1550573',3600.00,0.00,0.00,6.00,438.00,'2022-01-18 18:13:36','',''),(2547557,'1','179','933',413,'Retail Sale Id 1550587',1800.00,0.00,0.00,3.00,219.00,'2022-01-18 18:15:14','',''),(2547616,'1','179','933',413,'Retail Sale Id 1550656',3000.00,0.00,0.00,5.00,365.00,'2022-01-18 18:23:43','',''),(2547664,'1','179','933',413,'Retail Sale Id 1550714',798.00,0.00,0.00,1.33,97.09,'2022-01-18 18:32:56','',''),(2547821,'1','179','933',413,'Retail Sale Id 1550938',1152.00,0.00,0.00,1.92,140.16,'2022-01-18 19:05:34','',''),(2547885,'1','179','933',413,'Retail Sale Id 1550981',4002.00,0.00,0.00,6.67,486.91,'2022-01-18 19:23:33','',''),(2547944,'1','179','933',413,'Retail Sale Id 1551035',3900.00,0.00,0.00,6.50,474.50,'2022-01-18 19:53:02','',''),(2549273,'1','179','933',413,'Retail Sale Id 1551807',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 08:45:56','',''),(2549534,'1','179','933',413,'Retail Sale Id 1552043',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 09:06:02','',''),(2549563,'1','179','933',413,'Retail Sale Id 1552058',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 09:07:24','',''),(2549686,'1','179','933',413,'Retail Sale Id 1552161',1200.00,0.00,0.00,2.00,146.00,'2022-01-19 09:17:00','',''),(2549749,'1','179','933',413,'Retail Sale Id 1552209',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 09:22:43','',''),(2549799,'1','179','933',413,'Retail Sale Id 1552263',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 09:27:02','',''),(2549842,'1','179','933',413,'Retail Sale Id 1552301',6000.00,0.00,0.00,10.00,730.00,'2022-01-19 09:30:32','',''),(2550093,'1','179','933',413,'Retail Sale Id 1552548',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 09:54:16','',''),(2550112,'1','179','933',413,'Retail Sale Id 1552568',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 09:56:07','',''),(2550136,'1','179','933',413,'Retail Sale Id 1552595',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 09:58:22','',''),(2550184,'1','179','933',413,'Retail Sale Id 1552635',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 10:03:38','',''),(2550265,'1','179','933',413,'Retail Sale Id 1552728',2400.00,0.00,0.00,4.00,292.00,'2022-01-19 10:11:25','',''),(2550450,'1','179','933',413,'Retail Sale Id 1552916',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 10:31:36','',''),(2550578,'1','179','933',413,'Retail Sale Id 1553041',1200.00,0.00,0.00,2.00,146.00,'2022-01-19 10:44:06','',''),(2550618,'1','179','933',413,'Retail Sale Id 1553086',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 10:48:23','',''),(2550770,'1','179','933',413,'Retail Sale Id 1553206',7002.00,0.00,0.00,11.67,851.91,'2022-01-19 11:00:21','',''),(2550864,'1','179','933',413,'Retail Sale Id 1553300',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 11:11:23','',''),(2552828,'1','179','933',413,'Retail Sale Id 1555181',3498.00,0.00,0.00,5.83,425.59,'2022-01-19 14:51:38','',''),(2552928,'1','179','933',413,'Retail Sale Id 1555293',6600.00,0.00,0.00,11.00,803.00,'2022-01-19 15:01:24','',''),(2552946,'1','179','933',413,'Retail Sale Id 1555312',35640.00,0.00,0.00,59.40,4336.20,'2022-01-19 15:03:53','',''),(2553089,'1','179','933',413,'Retail Sale Id 1555447',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 15:18:21','',''),(2553106,'1','179','933',413,'Retail Sale Id 1555462',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 15:19:42','',''),(2553125,'1','179','933',413,'Retail Sale Id 1555480',3000.00,0.00,0.00,5.00,365.00,'2022-01-19 15:21:39','',''),(2553212,'1','179','933',413,'Retail Sale Id 1555567',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 15:30:08','',''),(2553260,'1','179','933',413,'Retail Sale Id 1555599',1998.00,0.00,0.00,3.33,243.09,'2022-01-19 15:33:55','',''),(2553439,'1','179','933',413,'Retail Sale Id 1555696',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 15:44:01','',''),(2553558,'1','179','933',413,'Retail Sale Id 1555768',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 15:51:14','',''),(2553599,'1','179','933',413,'Retail Sale Id 1555783',6000.00,0.00,0.00,10.00,730.00,'2022-01-19 15:52:59','',''),(2553706,'1','179','933',413,'Retail Sale Id 1555871',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 16:03:24','',''),(2553715,'1','179','933',413,'Retail Sale Id 1555879',600.00,0.00,0.00,1.00,73.00,'2022-01-19 16:04:43','',''),(2553867,'1','179','933',413,'Retail Sale Id 1556017',4998.00,0.00,0.00,8.33,608.09,'2022-01-19 16:19:19','',''),(2554098,'1','179','933',413,'Retail Sale Id 1556194',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 16:34:35','',''),(2554110,'1','179','933',413,'Retail Sale Id 1556205',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 16:35:37','',''),(2554125,'1','179','933',413,'Retail Sale Id 1556219',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 16:36:43','',''),(2554143,'1','179','933',413,'Retail Sale Id 1556239',1998.00,0.00,0.00,3.33,243.09,'2022-01-19 16:38:14','',''),(2554265,'1','179','933',413,'Retail Sale Id 1556373',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 16:48:58','',''),(2554308,'1','179','933',413,'Retail Sale Id 1556421',1998.00,0.00,0.00,3.33,243.09,'2022-01-19 16:51:56','',''),(2554329,'1','179','933',413,'Retail Sale Id 1556443',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 16:53:12','',''),(2554663,'1','179','933',413,'Retail Sale Id 1556806',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 17:17:23','',''),(2554774,'1','179','933',413,'Retail Sale Id 1556907',3000.00,0.00,0.00,5.00,365.00,'2022-01-19 17:25:07','',''),(2554898,'1','179','933',413,'Retail Sale Id 1557025',1998.00,0.00,0.00,3.33,243.09,'2022-01-19 17:35:36','',''),(2554930,'1','179','933',413,'Retail Sale Id 1557061',1200.00,0.00,0.00,2.00,146.00,'2022-01-19 17:38:08','',''),(2554950,'1','179','933',413,'Retail Sale Id 1557078',15000.00,0.00,0.00,25.00,1825.00,'2022-01-19 17:39:35','',''),(2554960,'1','179','933',413,'Retail Sale Id 1557089',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 17:40:44','',''),(2555035,'1','179','933',413,'Retail Sale Id 1557165',1998.00,0.00,0.00,3.33,243.09,'2022-01-19 17:46:46','',''),(2555172,'1','179','933',413,'Retail Sale Id 1557309',1002.00,0.00,0.00,1.67,121.91,'2022-01-19 17:59:23','',''),(2555466,'1','179','933',413,'Retail Sale Id 1557571',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 18:35:33','',''),(2555479,'1','179','933',413,'Retail Sale Id 1557580',1500.00,0.00,0.00,2.50,182.50,'2022-01-19 18:37:04','',''),(2555489,'1','179','933',413,'Retail Sale Id 1557592',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 18:39:08','',''),(2555516,'1','179','933',413,'Retail Sale Id 1557615',2400.00,0.00,0.00,4.00,292.00,'2022-01-19 18:45:26','',''),(2555535,'1','179','933',413,'Retail Sale Id 1557634',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 18:49:47','',''),(2555540,'1','179','933',413,'Retail Sale Id 1557640',600.00,0.00,0.00,1.00,73.00,'2022-01-19 18:50:53','',''),(2555558,'1','179','933',413,'Retail Sale Id 1557659',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 18:55:13','',''),(2555565,'1','179','933',413,'Retail Sale Id 1557665',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 18:56:37','',''),(2555569,'1','179','933',413,'Retail Sale Id 1557669',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 18:57:26','',''),(2555661,'1','179','933',413,'Retail Sale Id 1557730',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 19:12:22','',''),(2555665,'1','179','933',413,'Retail Sale Id 1557734',3000.00,0.00,0.00,5.00,365.00,'2022-01-19 19:13:25','',''),(2555667,'1','179','933',413,'Retail Sale Id 1557737',600.00,0.00,0.00,1.00,73.00,'2022-01-19 19:14:09','',''),(2555673,'1','179','933',413,'Retail Sale Id 1557767',3600.00,0.00,0.00,6.00,438.00,'2022-01-19 19:19:25','',''),(2555680,'1','179','933',413,'Retail Sale Id 1557784',7500.00,0.00,0.00,12.50,912.50,'2022-01-19 19:22:41','',''),(2555684,'1','179','933',413,'Retail Sale Id 1557789',3000.00,0.00,0.00,5.00,365.00,'2022-01-19 19:24:16','',''),(2555698,'1','179','933',413,'Retail Sale Id 1557812',2502.00,0.00,0.00,4.17,304.41,'2022-01-19 19:32:27','',''),(2555729,'1','179','933',413,'Retail Sale Id 1557820',1800.00,0.00,0.00,3.00,219.00,'2022-01-19 19:42:29','',''),(2556654,'1','179','933',413,'Retail Sale Id 1558299',6000.00,0.00,0.00,10.00,730.00,'2022-01-20 08:18:46','',''),(2556780,'1','179','933',413,'Retail Sale Id 1558406',1002.00,0.00,0.00,1.67,121.91,'2022-01-20 08:32:34','',''),(2557082,'1','179','933',413,'Retail Sale Id 1558653',4800.00,0.00,0.00,8.00,584.00,'2022-01-20 08:56:38','',''),(2557165,'1','179','933',413,'Retail Sale Id 1558730',4002.00,0.00,0.00,6.67,486.91,'2022-01-20 09:01:33','',''),(2557182,'1','179','933',413,'Retail Sale Id 1558738',7500.00,0.00,0.00,12.50,912.50,'2022-01-20 09:02:35','',''),(2557318,'1','179','933',413,'Retail Sale Id 1558826',2400.00,0.00,0.00,4.00,292.00,'2022-01-20 09:09:55','',''),(2557459,'1','179','933',413,'Retail Sale Id 1558947',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 09:21:32','',''),(2559837,'1','179','933',413,'Retail Sale Id 1561281',4998.00,0.00,0.00,8.33,608.09,'2022-01-20 13:00:11','',''),(2559936,'1','179','933',413,'Retail Sale Id 1561420',40680.00,0.00,0.00,67.80,4949.40,'2022-01-20 13:11:04','',''),(2559946,'1','179','933',413,'Retail Sale Id 1561434',1998.00,0.00,0.00,3.33,243.09,'2022-01-20 13:11:59','',''),(2560084,'1','179','933',413,'Retail Sale Id 1561578',2400.00,0.00,0.00,4.00,292.00,'2022-01-20 13:24:15','',''),(2560261,'1','179','933',413,'Retail Sale Id 1561777',3000.00,0.00,0.00,5.00,365.00,'2022-01-20 13:45:05','',''),(2560358,'1','179','933',413,'Retail Sale Id 1561859',4002.00,0.00,0.00,6.67,486.91,'2022-01-20 13:53:29','',''),(2561086,'1','179','933',413,'Retail Sale Id 1562554',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 14:58:54','',''),(2561102,'1','179','933',413,'Retail Sale Id 1562572',9600.00,0.00,0.00,16.00,1168.00,'2022-01-20 15:00:14','',''),(2561119,'1','179','933',413,'Retail Sale Id 1562588',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 15:01:28','',''),(2561770,'1','179','933',413,'Retail Sale Id 1563397',7500.00,0.00,0.00,12.50,912.50,'2022-01-20 16:02:13','',''),(2562216,'1','179','933',413,'Retail Sale Id 1563815',22500.00,0.00,0.00,37.50,2737.50,'2022-01-20 16:35:06','',''),(2562770,'1','179','933',413,'Retail Sale Id 1564323',6000.00,0.00,0.00,10.00,730.00,'2022-01-20 17:09:24','',''),(2562855,'1','179','933',413,'Retail Sale Id 1564412',30000.00,0.00,0.00,50.00,3650.00,'2022-01-20 17:14:22','',''),(2562936,'1','179','933',413,'Retail Sale Id 1564510',6600.00,0.00,0.00,11.00,803.00,'2022-01-20 17:19:03','',''),(2562956,'1','179','933',413,'Retail Sale Id 1564534',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 17:20:57','',''),(2563082,'1','179','933',413,'Retail Sale Id 1564705',6000.00,0.00,0.00,10.00,730.00,'2022-01-20 17:31:37','',''),(2563136,'1','179','933',413,'Retail Sale Id 1564764',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 17:35:14','',''),(2563158,'1','179','933',413,'Retail Sale Id 1564785',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 17:36:51','',''),(2563220,'1','179','933',413,'Retail Sale Id 1564849',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 17:42:35','',''),(2563242,'1','179','933',413,'Retail Sale Id 1564875',1200.00,0.00,0.00,2.00,146.00,'2022-01-20 17:44:29','',''),(2563300,'1','179','933',413,'Retail Sale Id 1564939',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 17:49:09','',''),(2563323,'1','179','933',413,'Retail Sale Id 1564975',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 17:51:09','',''),(2563341,'1','179','933',413,'Retail Sale Id 1564997',1200.00,0.00,0.00,2.00,146.00,'2022-01-20 17:52:24','',''),(2563445,'1','179','933',413,'Retail Sale Id 1565121',1002.00,0.00,0.00,1.67,121.91,'2022-01-20 18:00:06','',''),(2563468,'1','179','933',413,'Retail Sale Id 1565140',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 18:01:44','',''),(2563534,'1','179','933',413,'Retail Sale Id 1565265',3600.00,0.00,0.00,6.00,438.00,'2022-01-20 18:06:39','',''),(2563552,'1','179','933',413,'Retail Sale Id 1565291',1200.00,0.00,0.00,2.00,146.00,'2022-01-20 18:08:15','',''),(2563803,'1','179','933',413,'Retail Sale Id 1565560',4800.00,0.00,0.00,8.00,584.00,'2022-01-20 18:38:33','',''),(2564043,'1','179','933',413,'Retail Sale Id 1565819',798.00,0.00,0.00,1.33,97.09,'2022-01-20 19:31:27','',''),(2564063,'1','179','933',413,'Retail Sale Id 1565834',1800.00,0.00,0.00,3.00,219.00,'2022-01-20 19:45:53','',''),(2565299,'1','179','933',413,'Retail Sale Id 1566569',3000.00,0.00,0.00,5.00,365.00,'2022-01-21 08:36:33','',''),(2565602,'1','179','933',413,'Retail Sale Id 1566874',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 09:03:58','',''),(2565741,'1','179','933',413,'Retail Sale Id 1567029',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 09:17:48','',''),(2565918,'1','179','933',413,'Retail Sale Id 1567168',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 09:31:16','',''),(2566428,'1','179','933',413,'Retail Sale Id 1567603',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 10:17:16','',''),(2566815,'1','179','933',413,'Retail Sale Id 1567870',6600.00,0.00,0.00,11.00,803.00,'2022-01-21 10:48:00','',''),(2567098,'1','179','933',413,'Retail Sale Id 1568147',6600.00,0.00,0.00,11.00,803.00,'2022-01-21 11:19:35','',''),(2567120,'1','179','933',413,'Retail Sale Id 1568170',1200.00,0.00,0.00,2.00,146.00,'2022-01-21 11:21:31','',''),(2572188,'1','179','933',413,'Retail Sale Id 1573110',12102.00,0.00,0.00,20.17,1472.41,'2022-01-21 18:58:03','',''),(2572228,'1','179','933',413,'Retail Sale Id 1573130',66000.00,0.00,0.00,110.00,8030.00,'2022-01-21 19:02:09','',''),(2572263,'1','179','933',413,'Retail Sale Id 1573174',1800.00,0.00,0.00,3.00,219.00,'2022-01-21 19:09:03','',''),(2572283,'1','179','933',413,'Retail Sale Id 1573221',15240.00,0.00,0.00,25.40,1854.20,'2022-01-21 19:14:43','',''),(2572384,'1','179','933',413,'Retail Sale Id 1573284',3600.00,0.00,0.00,6.00,438.00,'2022-01-21 19:30:51','',''),(2572400,'1','179','933',413,'Retail Sale Id 1573296',7500.00,0.00,0.00,12.50,912.50,'2022-01-21 19:37:12','',''),(2572409,'1','179','933',413,'Retail Sale Id 1573304',7200.00,0.00,0.00,12.00,876.00,'2022-01-21 19:41:04','',''),(2572422,'1','179','933',413,'Retail Sale Id 1573318',1500.00,0.00,0.00,2.50,182.50,'2022-01-21 19:46:23','',''),(2572425,'1','179','933',413,'Retail Sale Id 1573319',1998.00,0.00,0.00,3.33,243.09,'2022-01-21 19:49:08','',''),(2572430,'1','179','933',413,'Retail Sale Id 1573323',7500.00,0.00,0.00,12.50,912.50,'2022-01-21 19:51:35','',''),(2573337,'1','179','933',413,'Retail Sale Id 1573802',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 08:10:18','',''),(2573526,'1','179','933',413,'Retail Sale Id 1573964',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 08:29:56','',''),(2573561,'1','179','933',413,'Retail Sale Id 1573990',3702.00,0.00,0.00,6.17,450.41,'2022-01-22 08:34:26','',''),(2573634,'1','179','933',413,'Retail Sale Id 1574063',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 08:41:26','',''),(2575206,'1','179','933',413,'Retail Sale Id 1575681',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 10:58:25','',''),(2575472,'1','179','933',413,'Retail Sale Id 1575893',6000.00,0.00,0.00,10.00,730.00,'2022-01-22 11:14:44','',''),(2575556,'1','179','933',413,'Retail Sale Id 1575982',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 11:20:44','',''),(2575722,'1','179','933',413,'Retail Sale Id 1576158',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 11:34:16','',''),(2575776,'1','179','933',413,'Retail Sale Id 1576209',2502.00,0.00,0.00,4.17,304.41,'2022-01-22 11:38:24','',''),(2575819,'1','179','933',413,'Retail Sale Id 1576238',1998.00,0.00,0.00,3.33,243.09,'2022-01-22 11:40:27','',''),(2576219,'1','179','933',413,'Retail Sale Id 1576583',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 12:07:50','',''),(2576232,'1','179','933',413,'Retail Sale Id 1576597',1500.00,0.00,0.00,2.50,182.50,'2022-01-22 12:08:44','',''),(2576628,'1','179','933',413,'Retail Sale Id 1576968',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 12:37:10','',''),(2576658,'1','179','933',413,'Retail Sale Id 1576990',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 12:38:22','',''),(2576817,'1','179','933',413,'Retail Sale Id 1577130',1002.00,0.00,0.00,1.67,121.91,'2022-01-22 12:48:58','',''),(2576939,'1','179','933',413,'Retail Sale Id 1577305',1998.00,0.00,0.00,3.33,243.09,'2022-01-22 12:58:01','',''),(2577644,'1','179','933',413,'Retail Sale Id 1577946',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 14:03:54','',''),(2577795,'1','179','933',413,'Retail Sale Id 1577983',13500.00,0.00,0.00,22.50,1642.50,'2022-01-22 14:12:53','',''),(2579094,'1','179','933',413,'Retail Sale Id 1579194',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 16:00:56','',''),(2579164,'1','179','933',413,'Retail Sale Id 1578088',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 16:06:46','',''),(2579171,'1','179','933',413,'Retail Sale Id 1579268',702.00,0.00,0.00,1.17,85.41,'2022-01-22 16:07:38','',''),(2579189,'1','179','933',413,'Retail Sale Id 1579286',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 16:08:55','',''),(2579393,'1','179','933',413,'Retail Sale Id 1579502',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 16:26:51','',''),(2579411,'1','179','933',413,'Retail Sale Id 1579520',1500.00,0.00,0.00,2.50,182.50,'2022-01-22 16:28:25','',''),(2579482,'1','179','933',413,'Retail Sale Id 1579587',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 16:36:09','',''),(2579499,'1','179','933',413,'Retail Sale Id 1579604',25500.00,0.00,0.00,42.50,3102.50,'2022-01-22 16:37:35','',''),(2579557,'1','179','933',413,'Retail Sale Id 1579704',1500.00,0.00,0.00,2.50,182.50,'2022-01-22 16:43:36','',''),(2579746,'1','179','933',413,'Retail Sale Id 1579841',9300.00,0.00,0.00,15.50,1131.50,'2022-01-22 16:54:47','',''),(2579787,'1','179','933',413,'Retail Sale Id 1579885',1002.00,0.00,0.00,1.67,121.91,'2022-01-22 16:58:11','',''),(2579829,'1','179','933',413,'Retail Sale Id 1579929',4998.00,0.00,0.00,8.33,608.09,'2022-01-22 17:01:13','',''),(2579913,'1','179','933',413,'Retail Sale Id 1580012',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 17:07:10','',''),(2580003,'1','179','933',413,'Retail Sale Id 1580061',1500.00,0.00,0.00,2.50,182.50,'2022-01-22 17:10:24','',''),(2580039,'1','179','933',413,'Retail Sale Id 1580083',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 17:12:03','',''),(2580059,'1','179','933',413,'Retail Sale Id 1580096',600.00,0.00,0.00,1.00,73.00,'2022-01-22 17:13:03','',''),(2580135,'1','179','933',413,'Retail Sale Id 1580162',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 17:18:34','',''),(2580157,'1','179','933',413,'Retail Sale Id 1580181',1002.00,0.00,0.00,1.67,121.91,'2022-01-22 17:20:13','',''),(2580268,'1','179','933',413,'Retail Sale Id 1580297',4002.00,0.00,0.00,6.67,486.91,'2022-01-22 17:30:23','',''),(2580298,'1','179','933',413,'Retail Sale Id 1580322',798.00,0.00,0.00,1.33,97.09,'2022-01-22 17:32:45','',''),(2580338,'1','179','933',413,'Retail Sale Id 1580365',3000.00,0.00,0.00,5.00,365.00,'2022-01-22 17:36:14','',''),(2580403,'1','179','933',413,'Retail Sale Id 1580431',3600.00,0.00,0.00,6.00,438.00,'2022-01-22 17:40:46','',''),(2580443,'1','179','933',413,'Retail Sale Id 1580471',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 17:43:25','',''),(2580459,'1','179','933',413,'Retail Sale Id 1580488',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 17:44:25','',''),(2580481,'1','179','933',413,'Retail Sale Id 1580508',1200.00,0.00,0.00,2.00,146.00,'2022-01-22 17:45:53','',''),(2580508,'1','179','933',413,'Retail Sale Id 1580534',1002.00,0.00,0.00,1.67,121.91,'2022-01-22 17:47:39','',''),(2580669,'1','179','933',413,'Retail Sale Id 1580678',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 17:59:36','',''),(2580709,'1','179','933',413,'Retail Sale Id 1580757',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 18:04:18','',''),(2580873,'1','179','933',413,'Retail Sale Id 1581079',1200.00,0.00,0.00,2.00,146.00,'2022-01-22 18:25:24','',''),(2580947,'1','179','933',413,'Retail Sale Id 1581187',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 18:33:51','',''),(2581216,'1','179','933',413,'Retail Sale Id 1581505',4002.00,0.00,0.00,6.67,486.91,'2022-01-22 19:18:46','',''),(2581310,'1','179','933',413,'Retail Sale Id 1581590',1800.00,0.00,0.00,3.00,219.00,'2022-01-22 19:33:13','',''),(2581373,'1','179','933',413,'Retail Sale Id 1581644',7500.00,0.00,0.00,12.50,912.50,'2022-01-22 19:48:50','',''),(2582754,'1','179','933',413,'Retail Sale Id 1582469',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 08:55:27','',''),(2582801,'1','179','933',413,'Retail Sale Id 1582509',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 08:59:56','',''),(2582991,'1','179','933',413,'Retail Sale Id 1582642',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 09:12:36','',''),(2583353,'1','179','933',413,'Retail Sale Id 1583031',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 09:46:30','',''),(2583437,'1','179','933',413,'Retail Sale Id 1583118',1998.00,0.00,0.00,3.33,243.09,'2022-01-23 09:53:27','',''),(2583567,'1','179','933',413,'Retail Sale Id 1583249',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 10:07:24','',''),(2583852,'1','179','933',413,'Retail Sale Id 1583538',1200.00,0.00,0.00,2.00,146.00,'2022-01-23 10:32:29','',''),(2584049,'1','179','933',413,'Retail Sale Id 1583690',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 10:48:48','',''),(2584229,'1','179','933',413,'Retail Sale Id 1583868',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 11:04:02','',''),(2584316,'1','179','933',413,'Retail Sale Id 1583953',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 11:10:54','',''),(2584482,'1','179','933',413,'Retail Sale Id 1584124',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 11:27:05','',''),(2584495,'1','179','933',413,'Retail Sale Id 1584136',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 11:28:11','',''),(2584505,'1','179','933',413,'Retail Sale Id 1584147',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 11:29:03','',''),(2584594,'1','179','933',413,'Retail Sale Id 1584243',1752.00,0.00,0.00,2.92,213.16,'2022-01-23 11:39:33','',''),(2584684,'1','179','933',413,'Retail Sale Id 1584345',6000.00,0.00,0.00,10.00,730.00,'2022-01-23 11:48:52','',''),(2584807,'1','179','933',413,'Retail Sale Id 1584458',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 12:00:17','',''),(2584818,'1','179','933',413,'Retail Sale Id 1584489',1500.00,0.00,0.00,2.50,182.50,'2022-01-23 12:01:11','',''),(2584831,'1','179','933',413,'Retail Sale Id 1584502',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 12:02:49','',''),(2584847,'1','179','933',413,'Retail Sale Id 1584520',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 12:04:01','',''),(2584858,'1','179','933',413,'Retail Sale Id 1584530',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 12:05:05','',''),(2584889,'1','179','933',413,'Retail Sale Id 1584559',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 12:08:19','',''),(2584956,'1','179','933',413,'Retail Sale Id 1584634',2100.00,0.00,0.00,3.50,255.50,'2022-01-23 12:17:06','',''),(2585024,'1','179','933',413,'Retail Sale Id 1584707',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 12:24:22','',''),(2585042,'1','179','933',413,'Retail Sale Id 1584727',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 12:25:56','',''),(2585067,'1','179','933',413,'Retail Sale Id 1584752',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 12:27:36','',''),(2585175,'1','179','933',413,'Retail Sale Id 1584872',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 12:38:36','',''),(2585189,'1','179','933',413,'Retail Sale Id 1584884',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 12:39:37','',''),(2585205,'1','179','933',413,'Retail Sale Id 1584900',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 12:40:34','',''),(2585342,'1','179','933',413,'Retail Sale Id 1585014',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 12:50:34','',''),(2585393,'1','179','933',413,'Retail Sale Id 1585076',6000.00,0.00,0.00,10.00,730.00,'2022-01-23 12:54:36','',''),(2585412,'1','179','933',413,'Retail Sale Id 1585095',3750.00,0.00,0.00,6.25,456.25,'2022-01-23 12:56:13','',''),(2585606,'1','179','933',413,'Retail Sale Id 1585299',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 13:14:18','',''),(2585992,'1','179','933',413,'Retail Sale Id 1585645',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 13:43:46','',''),(2586047,'1','179','933',413,'Retail Sale Id 1585697',6000.00,0.00,0.00,10.00,730.00,'2022-01-23 13:47:08','',''),(2586103,'1','179','933',413,'Retail Sale Id 1585760',2802.00,0.00,0.00,4.67,340.91,'2022-01-23 13:50:30','',''),(2586119,'1','179','933',413,'Retail Sale Id 1585786',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 13:51:45','',''),(2586127,'1','179','933',413,'Retail Sale Id 1585791',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 13:52:33','',''),(2586427,'1','179','933',413,'Retail Sale Id 1585995',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 14:12:05','',''),(2586441,'1','179','933',413,'Retail Sale Id 1586007',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 14:13:27','',''),(2586474,'1','179','933',413,'Retail Sale Id 1586043',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 14:16:57','',''),(2586498,'1','179','933',413,'Retail Sale Id 1586065',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 14:19:18','',''),(2587033,'1','179','933',413,'Retail Sale Id 1586566',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 14:59:43','',''),(2587325,'1','179','933',413,'Retail Sale Id 1586787',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 15:21:57','',''),(2587424,'1','179','933',413,'Retail Sale Id 1586878',4800.00,0.00,0.00,8.00,584.00,'2022-01-23 15:32:21','',''),(2587565,'1','179','933',413,'Retail Sale Id 1587020',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 15:46:17','',''),(2587766,'1','179','933',413,'Retail Sale Id 1587140',1500.00,0.00,0.00,2.50,182.50,'2022-01-23 16:01:01','',''),(2587821,'1','179','933',413,'Retail Sale Id 1587195',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 16:10:36','',''),(2588059,'1','179','933',413,'Retail Sale Id 1587358',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 16:34:24','',''),(2588078,'1','179','933',413,'Retail Sale Id 1587365',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 16:36:05','',''),(2588100,'1','179','933',413,'Retail Sale Id 1587391',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 16:38:18','',''),(2588146,'1','179','933',413,'Retail Sale Id 1587411',1200.00,0.00,0.00,2.00,146.00,'2022-01-23 16:43:08','',''),(2588160,'1','179','933',413,'Retail Sale Id 1587439',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 16:44:05','',''),(2588171,'1','179','933',413,'Retail Sale Id 1587447',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 16:44:53','',''),(2588290,'1','179','933',413,'Retail Sale Id 1587559',1998.00,0.00,0.00,3.33,243.09,'2022-01-23 16:58:09','',''),(2588518,'1','179','933',413,'Retail Sale Id 1587777',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 17:19:12','',''),(2588532,'1','179','933',413,'Retail Sale Id 1587789',1500.00,0.00,0.00,2.50,182.50,'2022-01-23 17:20:07','',''),(2588586,'1','179','933',413,'Retail Sale Id 1587825',4998.00,0.00,0.00,8.33,608.09,'2022-01-23 17:23:06','',''),(2588748,'1','179','933',413,'Retail Sale Id 1587909',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 17:30:42','',''),(2588866,'1','179','933',413,'Retail Sale Id 1587995',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 17:41:16','',''),(2588887,'1','179','933',413,'Retail Sale Id 1588043',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 17:43:28','',''),(2588910,'1','179','933',413,'Retail Sale Id 1588086',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 17:45:35','',''),(2589060,'1','179','933',413,'Retail Sale Id 1588246',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 17:59:55','',''),(2589073,'1','179','933',413,'Retail Sale Id 1588257',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 18:01:05','',''),(2589144,'1','179','933',413,'Retail Sale Id 1588330',1500.00,0.00,0.00,2.50,182.50,'2022-01-23 18:08:09','',''),(2589235,'1','179','933',413,'Retail Sale Id 1588415',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 18:19:33','',''),(2589340,'1','179','933',413,'Retail Sale Id 1588525',600.00,0.00,0.00,1.00,73.00,'2022-01-23 18:41:15','',''),(2589349,'1','179','933',413,'Retail Sale Id 1588530',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 18:43:16','',''),(2589358,'1','179','933',413,'Retail Sale Id 1588537',7500.00,0.00,0.00,12.50,912.50,'2022-01-23 18:44:42','',''),(2589365,'1','179','933',413,'Retail Sale Id 1588544',1998.00,0.00,0.00,3.33,243.09,'2022-01-23 18:45:56','',''),(2589412,'1','179','933',413,'Retail Sale Id 1588587',1500.00,0.00,0.00,2.50,182.50,'2022-01-23 18:59:25','',''),(2589443,'1','179','933',413,'Retail Sale Id 1588605',1998.00,0.00,0.00,3.33,243.09,'2022-01-23 19:08:26','',''),(2589484,'1','179','933',413,'Retail Sale Id 1588640',3000.00,0.00,0.00,5.00,365.00,'2022-01-23 19:22:48','',''),(2589487,'1','179','933',413,'Retail Sale Id 1588643',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 19:23:33','',''),(2589519,'1','179','933',413,'Retail Sale Id 1588648',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 19:29:53','',''),(2589522,'1','179','933',413,'Retail Sale Id 1588651',3600.00,0.00,0.00,6.00,438.00,'2022-01-23 19:30:50','',''),(2589523,'1','179','933',413,'Retail Sale Id 1588653',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 19:32:37','',''),(2589527,'1','179','933',413,'Retail Sale Id 1588656',1002.00,0.00,0.00,1.67,121.91,'2022-01-23 19:35:30','',''),(2589566,'1','179','933',413,'Retail Sale Id 1588677',1800.00,0.00,0.00,3.00,219.00,'2022-01-23 19:52:07','',''),(2589628,'1','179','933',413,'Retail Sale Id 1588685',600.00,0.00,0.00,1.00,73.00,'2022-01-23 20:13:54','',''),(2590453,'1','179','933',413,'Retail Sale Id 1589129',1500.00,0.00,0.00,2.50,182.50,'2022-01-24 08:21:46','',''),(2590611,'1','179','933',413,'Retail Sale Id 1589218',7500.00,0.00,0.00,12.50,912.50,'2022-01-24 08:35:01','',''),(2590660,'1','179','933',413,'Retail Sale Id 1589255',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 08:39:23','',''),(2590735,'1','179','933',413,'Retail Sale Id 1589360',4500.00,0.00,0.00,7.50,547.50,'2022-01-24 08:53:23','',''),(2590753,'1','179','933',413,'Retail Sale Id 1589380',1200.00,0.00,0.00,2.00,146.00,'2022-01-24 08:54:57','',''),(2591392,'1','179','933',413,'Retail Sale Id 1589829',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 09:58:30','',''),(2591585,'1','179','933',413,'Retail Sale Id 1590009',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 10:22:40','',''),(2591808,'1','179','933',413,'Retail Sale Id 1590225',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 10:47:22','',''),(2591911,'1','179','933',413,'Retail Sale Id 1590325',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 10:59:03','',''),(2592161,'1','179','933',413,'Retail Sale Id 1590487',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 11:19:23','',''),(2592172,'1','179','933',413,'Retail Sale Id 1590503',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 11:20:34','',''),(2592220,'1','179','933',413,'Retail Sale Id 1590554',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 11:27:25','',''),(2592285,'1','179','933',413,'Retail Sale Id 1590621',900.00,0.00,0.00,1.50,109.50,'2022-01-24 11:34:02','',''),(2592814,'1','179','933',413,'Retail Sale Id 1591117',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 12:36:01','',''),(2592835,'1','179','933',413,'Retail Sale Id 1591138',6000.00,0.00,0.00,10.00,730.00,'2022-01-24 12:39:14','',''),(2592875,'1','179','933',413,'Retail Sale Id 1591171',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 12:43:03','',''),(2593231,'1','179','933',413,'Retail Sale Id 1591499',7500.00,0.00,0.00,12.50,912.50,'2022-01-24 13:23:08','',''),(2593391,'1','179','933',413,'Retail Sale Id 1591638',1698.00,0.00,0.00,2.83,206.59,'2022-01-24 13:42:34','',''),(2593403,'1','179','933',413,'Retail Sale Id 1591648',1002.00,0.00,0.00,1.67,121.91,'2022-01-24 13:44:06','',''),(2593462,'1','179','933',413,'Retail Sale Id 1591693',1002.00,0.00,0.00,1.67,121.91,'2022-01-24 13:50:54','',''),(2593463,'1','179','933',413,'Retail Sale Id 1591693',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 13:50:54','',''),(2593533,'1','179','933',413,'Retail Sale Id 1591772',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 13:58:36','',''),(2593768,'1','179','933',413,'Retail Sale Id 1592014',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 14:25:31','',''),(2593831,'1','179','933',413,'Retail Sale Id 1592092',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 14:32:46','',''),(2593876,'1','179','933',413,'Retail Sale Id 1592139',600.00,0.00,0.00,1.00,73.00,'2022-01-24 14:36:53','',''),(2594387,'1','179','933',413,'Retail Sale Id 1592505',15000.00,0.00,0.00,25.00,1825.00,'2022-01-24 15:17:54','',''),(2594565,'1','179','933',413,'Retail Sale Id 1592630',6000.00,0.00,0.00,10.00,730.00,'2022-01-24 15:30:40','',''),(2594583,'1','179','933',413,'Retail Sale Id 1592649',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 15:31:51','',''),(2594607,'1','179','933',413,'Retail Sale Id 1592670',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 15:33:46','',''),(2594780,'1','179','933',413,'Retail Sale Id 1592851',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 15:50:52','',''),(2594814,'1','179','933',413,'Retail Sale Id 1592886',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 15:54:53','',''),(2594981,'1','179','933',413,'Retail Sale Id 1593085',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 16:13:28','',''),(2595243,'1','179','933',413,'Retail Sale Id 1593508',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 16:44:33','',''),(2595250,'1','179','933',413,'Retail Sale Id 1593525',1500.00,0.00,0.00,2.50,182.50,'2022-01-24 16:45:50','',''),(2595309,'1','179','933',413,'Retail Sale Id 1593708',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 16:56:26','',''),(2595514,'1','179','933',413,'Retail Sale Id 1593997',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 17:19:56','',''),(2595533,'1','179','933',413,'Retail Sale Id 1594032',1200.00,0.00,0.00,2.00,146.00,'2022-01-24 17:22:37','',''),(2595534,'1','179','933',413,'Retail Sale Id 1594032',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:22:37','',''),(2595636,'1','179','933',413,'Retail Sale Id 1594135',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 17:30:26','',''),(2595664,'1','179','933',413,'Retail Sale Id 1594158',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 17:32:04','',''),(2595706,'1','179','933',413,'Retail Sale Id 1594196',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:35:47','',''),(2595707,'1','179','933',413,'Retail Sale Id 1594196',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 17:35:47','',''),(2595708,'1','179','933',413,'Retail Sale Id 1594196',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 17:35:47','',''),(2595732,'1','179','933',413,'Retail Sale Id 1594207',1002.00,0.00,0.00,1.67,121.91,'2022-01-24 17:36:53','',''),(2595789,'1','179','933',413,'Retail Sale Id 1594256',1002.00,0.00,0.00,1.67,121.91,'2022-01-24 17:41:24','',''),(2595818,'1','179','933',413,'Retail Sale Id 1594287',3600.00,0.00,0.00,6.00,438.00,'2022-01-24 17:44:02','',''),(2595847,'1','179','933',413,'Retail Sale Id 1594314',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 17:46:42','',''),(2595869,'1','179','933',413,'Retail Sale Id 1594334',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 17:49:00','',''),(2595888,'1','179','933',413,'Retail Sale Id 1594359',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 17:50:56','',''),(2596017,'1','179','933',413,'Retail Sale Id 1594465',600.00,0.00,0.00,1.00,73.00,'2022-01-24 18:01:37','',''),(2596084,'1','179','933',413,'Retail Sale Id 1594609',4998.00,0.00,0.00,8.33,608.09,'2022-01-24 18:06:22','',''),(2596216,'1','179','933',413,'Retail Sale Id 1594759',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 18:23:25','',''),(2596239,'1','179','933',413,'Retail Sale Id 1594783',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 18:26:04','',''),(2596255,'1','179','933',413,'Retail Sale Id 1594799',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 18:28:19','',''),(2596302,'1','179','933',413,'Retail Sale Id 1594843',600.00,0.00,0.00,1.00,73.00,'2022-01-24 18:37:36','',''),(2596489,'1','179','933',413,'Retail Sale Id 1594926',1800.00,0.00,0.00,3.00,219.00,'2022-01-24 19:00:43','',''),(2596499,'1','179','933',413,'Retail Sale Id 1594931',3000.00,0.00,0.00,5.00,365.00,'2022-01-24 19:01:45','',''),(2596549,'1','179','933',413,'Retail Sale Id 1594983',1998.00,0.00,0.00,3.33,243.09,'2022-01-24 19:12:32','',''),(2596579,'1','179','933',413,'Retail Sale Id 1595026',1500.00,0.00,0.00,2.50,182.50,'2022-01-24 19:19:55','',''),(2596622,'1','179','933',413,'Retail Sale Id 1595055',1002.00,0.00,0.00,1.67,121.91,'2022-01-24 19:28:09','',''),(2597426,'1','179','933',413,'Retail Sale Id 1595523',6000.00,0.00,0.00,10.00,730.00,'2022-01-25 08:06:00','',''),(2597432,'1','179','933',413,'Retail Sale Id 1595529',3000.00,0.00,0.00,5.00,365.00,'2022-01-25 08:06:38','',''),(2597536,'1','179','933',413,'Retail Sale Id 1595610',1998.00,0.00,0.00,3.33,243.09,'2022-01-25 08:16:34','',''),(2598126,'1','179','933',413,'Retail Sale Id 1596202',1998.00,0.00,0.00,3.33,243.09,'2022-01-25 09:09:46','',''),(2598207,'1','179','933',413,'Retail Sale Id 1596272',1998.00,0.00,0.00,3.33,243.09,'2022-01-25 09:15:24','',''),(2598982,'1','179','933',413,'Retail Sale Id 1597011',7500.00,0.00,0.00,12.50,912.50,'2022-01-25 10:26:15','',''),(2599240,'1','179','933',413,'Retail Sale Id 1597270',4998.00,0.00,0.00,8.33,608.09,'2022-01-25 10:51:27','',''),(2599256,'1','179','933',413,'Retail Sale Id 1597288',3000.00,0.00,0.00,5.00,365.00,'2022-01-25 10:52:45','',''),(2599265,'1','179','933',413,'Retail Sale Id 1597297',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 10:53:53','',''),(2603509,'1','179','933',413,'Retail Sale Id 1601265',49680.00,0.00,0.00,82.80,6044.40,'2022-01-25 17:05:59','',''),(2603961,'1','179','933',413,'Retail Sale Id 1601781',66720.00,0.00,0.00,111.20,8117.60,'2022-01-25 17:42:29','',''),(2604806,'1','179','933',413,'Retail Sale Id 1602605',600.00,0.00,0.00,1.00,73.00,'2022-01-25 19:09:40','',''),(2604856,'1','179','933',413,'Retail Sale Id 1602648',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 19:16:07','',''),(2604900,'1','179','933',413,'Retail Sale Id 1602683',7500.00,0.00,0.00,12.50,912.50,'2022-01-25 19:21:44','',''),(2604913,'1','179','933',413,'Retail Sale Id 1602701',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 19:24:57','',''),(2604919,'1','179','933',413,'Retail Sale Id 1602708',32676.00,0.00,0.00,54.46,3975.58,'2022-01-25 19:26:53','',''),(2604929,'1','179','933',413,'Retail Sale Id 1602721',1800.00,0.00,0.00,3.00,219.00,'2022-01-25 19:30:48','',''),(2605013,'1','179','933',413,'Retail Sale Id 1602767',3600.00,0.00,0.00,6.00,438.00,'2022-01-25 19:43:23','',''),(2605049,'1','179','933',413,'Retail Sale Id 1602784',1500.00,0.00,0.00,2.50,182.50,'2022-01-25 19:45:34','',''),(2606283,'1','179','933',413,'Retail Sale Id 1603485',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 08:19:33','',''),(2606453,'1','179','933',413,'Retail Sale Id 1603641',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 08:35:20','',''),(2606666,'1','179','933',413,'Retail Sale Id 1603860',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 08:59:36','',''),(2606881,'1','179','933',413,'Retail Sale Id 1604026',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 09:17:14','',''),(2606976,'1','179','933',413,'Retail Sale Id 1604082',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 09:27:14','',''),(2607233,'1','179','933',413,'Retail Sale Id 1604386',2502.00,0.00,0.00,4.17,304.41,'2022-01-26 09:48:48','',''),(2607286,'1','179','933',413,'Retail Sale Id 1604437',1800.00,0.00,0.00,3.00,219.00,'2022-01-26 09:54:09','',''),(2608023,'1','179','933',413,'Retail Sale Id 1605083',3600.00,0.00,0.00,6.00,438.00,'2022-01-26 11:09:08','',''),(2609773,'1','179','933',413,'Retail Sale Id 1607507',48660.00,0.00,0.00,81.10,5920.30,'2022-01-26 14:55:36','',''),(2609858,'1','179','933',413,'Retail Sale Id 1607591',7500.00,0.00,0.00,12.50,912.50,'2022-01-26 15:03:44','',''),(2610090,'1','179','933',413,'Retail Sale Id 1607858',4002.00,0.00,0.00,6.67,486.91,'2022-01-26 15:34:41','',''),(2610195,'1','179','933',413,'Retail Sale Id 1607949',4380.00,0.00,0.00,7.30,532.90,'2022-01-26 15:46:15','',''),(2611973,'1','179','933',413,'Retail Sale Id 1609937',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 18:40:10','',''),(2612098,'1','179','933',413,'Retail Sale Id 1610057',6000.00,0.00,0.00,10.00,730.00,'2022-01-26 19:00:11','',''),(2612275,'1','179','933',413,'Retail Sale Id 1610202',56100.00,0.00,0.00,93.50,6825.50,'2022-01-26 19:24:22','',''),(2612279,'1','179','933',413,'Retail Sale Id 1610207',7500.00,0.00,0.00,12.50,912.50,'2022-01-26 19:25:05','',''),(2612330,'1','179','933',413,'Retail Sale Id 1610266',1002.00,0.00,0.00,1.67,121.91,'2022-01-26 19:40:26','',''),(2612389,'1','179','933',413,'Retail Sale Id 1610327',8100.00,0.00,0.00,13.50,985.50,'2022-01-26 20:16:12','',''),(2612391,'1','179','933',413,'Retail Sale Id 1610329',3000.00,0.00,0.00,5.00,365.00,'2022-01-26 20:17:06','',''),(2613121,'1','179',NULL,413,'Balance from closing inventory values 2021-11-31 23:59:59',28856687.97,31341095.44,101021.35,92434.41,3703342.21,'2021-11-30 23:59:59','',''),(2613164,'1','179','933',0,'Balance from closing inventory values 2021-11-31 23:59:59',24674277.97,1493285.44,39073.34,36486.85,3703342.21,'2021-11-30 23:59:59','',''),(2614581,'1','179','933',413,'Retail Sale Id 1610783',2400.00,0.00,0.00,4.00,292.00,'2022-01-27 08:15:56','',''),(2615055,'1','179','933',413,'Retail Sale Id 1611110',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 08:47:28','',''),(2615248,'1','179','933',413,'Retail Sale Id 1611268',4800.00,0.00,0.00,8.00,584.00,'2022-01-27 09:04:40','',''),(2615400,'1','179','933',413,'Retail Sale Id 1611387',3000.00,0.00,0.00,5.00,365.00,'2022-01-27 09:18:32','',''),(2615909,'1','179','933',413,'Retail Sale Id 1611827',3000.00,0.00,0.00,5.00,365.00,'2022-01-27 10:00:16','',''),(2616389,'1','179','933',413,'Retail Sale Id 1612196',1200.00,0.00,0.00,2.00,146.00,'2022-01-27 10:34:32','',''),(2620332,'1','179','933',413,'Retail Sale Id 1615731',90720.00,0.00,0.00,151.20,11037.60,'2022-01-27 16:41:30','',''),(2620391,'1','179','933',413,'Retail Sale Id 1615755',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 16:46:50','',''),(2621100,'1','179','933',413,'Retail Sale Id 1616348',3600.00,0.00,0.00,6.00,438.00,'2022-01-27 17:32:27','',''),(2621179,'1','179','933',413,'Retail Sale Id 1616491',17100.00,0.00,0.00,28.50,2080.50,'2022-01-27 17:37:38','',''),(2621311,'1','179','933',413,'Retail Sale Id 1616583',7500.00,0.00,0.00,12.50,912.50,'2022-01-27 17:47:00','',''),(2621783,'1','179','933',413,'Retail Sale Id 1617016',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 18:31:36','',''),(2621864,'1','179','933',413,'Retail Sale Id 1617084',1800.00,0.00,0.00,3.00,219.00,'2022-01-27 18:41:07','',''),(2621879,'1','179','933',413,'Retail Sale Id 1617100',3000.00,0.00,0.00,5.00,365.00,'2022-01-27 18:42:55','',''),(2622043,'1','179','933',413,'Retail Sale Id 1617223',7200.00,0.00,0.00,12.00,876.00,'2022-01-27 19:02:36','',''),(2622051,'1','179','933',413,'Retail Sale Id 1617230',25740.00,0.00,0.00,42.90,3131.70,'2022-01-27 19:04:42','',''),(2623590,'1','179','933',413,'Retail Sale Id 1618071',7500.00,0.00,0.00,12.50,912.50,'2022-01-28 08:30:41','',''),(2623611,'1','179','933',413,'Retail Sale Id 1618083',7500.00,0.00,0.00,12.50,912.50,'2022-01-28 08:32:18','',''),(2623858,'1','179','933',413,'Retail Sale Id 1618424',2400.00,0.00,0.00,4.00,292.00,'2022-01-28 08:55:16','',''),(2624145,'1','179','933',413,'Retail Sale Id 1618637',1800.00,0.00,0.00,3.00,219.00,'2022-01-28 09:14:06','',''),(2628977,'1','179','933',413,'Retail Sale Id 1623135',173820.00,0.00,0.00,289.70,21148.10,'2022-01-28 16:38:57','',''),(2629205,'1','179','933',413,'Retail Sale Id 1623346',3600.00,0.00,0.00,6.00,438.00,'2022-01-28 16:56:58','',''),(2630347,'1','179','933',413,'Retail Sale Id 1624377',26820.00,0.00,0.00,44.70,3263.10,'2022-01-28 18:20:05','',''),(2630587,'1','179','933',413,'Retail Sale Id 1624577',1800.00,0.00,0.00,3.00,219.00,'2022-01-28 18:45:31','',''),(2630607,'1','179','933',413,'Retail Sale Id 1624589',2502.00,0.00,0.00,4.17,304.41,'2022-01-28 18:47:12','',''),(2630765,'1','179','933',413,'Retail Sale Id 1624714',3600.00,0.00,0.00,6.00,438.00,'2022-01-28 19:12:44','',''),(2630821,'1','179','933',413,'Retail Sale Id 1624780',1500.00,0.00,0.00,2.50,182.50,'2022-01-28 19:27:10','',''),(2631927,'1','179','933',413,'Retail Sale Id 1625240',3600.00,0.00,0.00,6.00,438.00,'2022-01-29 08:48:29','',''),(2631936,'1','179','933',413,'Retail Sale Id 1625251',4800.00,0.00,0.00,8.00,584.00,'2022-01-29 08:49:36','',''),(2631966,'1','179','933',413,'Retail Sale Id 1625261',2502.00,0.00,0.00,4.17,304.41,'2022-01-29 08:50:41','',''),(2632305,'1','179','933',413,'Retail Sale Id 1625580',24900.00,0.00,0.00,41.50,3029.50,'2022-01-29 09:35:52','',''),(2632366,'1','179','933',413,'Retail Sale Id 1625616',3000.00,0.00,0.00,5.00,365.00,'2022-01-29 09:40:13','',''),(2632484,'1','179','933',413,'Retail Sale Id 1625714',1800.00,0.00,0.00,3.00,219.00,'2022-01-29 09:50:07','',''),(2632785,'1','179','933',413,'Distributed to OPERATIONAL LOSS for sales id:350078',137910.63,0.00,0.00,261.69,0.00,'2022-01-29 10:14:54','',''),(2632940,'1','179',NULL,413,'Distributed to OPERATIONAL LOSS for sales id:350086',60747.29,0.00,0.00,115.27,0.00,'2022-01-29 10:25:20','',''),(2633036,'1','179',NULL,413,'Distributed to OPERATIONAL LOSS for sales id:350087',29643.75,0.00,0.00,56.25,0.00,'2022-01-29 10:32:07','',''),(2633037,'1','179','933',413,'Retail Sale Id 1625715',1998.00,0.00,0.00,3.33,243.09,'2022-02-02 11:03:10','',''),(2633038,'1','179','933',413,'Retail Sale Id 1625716',1800.00,0.00,0.00,3.00,219.00,'2022-02-02 11:04:11','',''),(2633039,'1','179','933',413,'Retail Sale Id 1625717',3600.00,0.00,0.00,6.00,438.00,'2022-02-02 11:27:05','',''),(2633040,'1','179','933',413,'Retail Sale Id 1625718',3600.00,0.00,0.00,6.00,438.00,'2022-02-02 11:34:07','',''),(2633041,'1','179','933',413,'Retail Sale Id 1625719',1800.00,0.00,0.00,3.00,219.00,'2022-02-02 11:50:53','',''),(2633042,'1','179','933',413,'Retail Sale Id 1625720',3000.00,0.00,0.00,5.00,365.00,'2022-02-02 11:53:22','',''),(2633043,'1','179','933',413,'Retail Sale Id 1625721',7500.00,0.00,0.00,12.50,912.50,'2022-02-02 12:08:40','',''),(2633044,'1','179','933',413,'Retail Sale Id 1625722',2100.00,0.00,0.00,3.50,255.50,'2022-02-02 12:11:47','',''),(2633045,'1','179','933',413,'Retail Sale Id 1625723',6000.00,0.00,0.00,10.00,730.00,'2022-02-02 12:12:31','',''),(2633046,'1','179','933',413,'Retail Sale Id 1625724',3000.00,0.00,0.00,5.00,365.00,'2022-02-02 12:36:29','',''),(2633047,'1','179','933',413,'Retail Sale Id 1625725',1698.00,0.00,0.00,2.83,206.59,'2022-02-02 12:37:44','',''),(2633048,'1','179','933',413,'Retail Sale Id 1625726',27000.00,0.00,0.00,45.00,3285.00,'2022-02-02 14:08:58','',''),(2633049,'1','179','933',413,'Retail Sale Id 1625727',12000.00,0.00,0.00,20.00,1460.00,'2022-02-02 14:10:03','',''),(2633050,'1','179','933',413,'Retail Sale Id 1625728',1800.00,0.00,0.00,3.00,219.00,'2022-02-02 14:11:23','',''),(2633051,'1','179','933',413,'Retail Sale Id 1625729',3000.00,0.00,0.00,5.00,365.00,'2022-02-02 14:38:23','',''),(2633052,'1','179','933',413,'Retail Sale Id 1625730',3798.00,0.00,0.00,6.33,462.09,'2022-02-02 14:39:21','',''),(2633053,'1','179','933',413,'Retail Sale Id 1625731',3600.00,0.00,0.00,6.00,438.00,'2022-02-02 14:40:31','',''),(2633054,'1','179','933',413,'Retail Sale Id 1625732',7200.00,0.00,0.00,12.00,876.00,'2022-02-02 14:43:30','',''),(2633055,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,2636700.00,5100.00,0.00,0.00,'2022-02-02 14:47:26','',''),(2633056,'1','179',NULL,413,'Reception corrector for bridging 132512',0.00,0.00,0.00,5100.00,0.00,'2022-02-02 14:48:39','',''),(2633057,'1','179','933',413,'Received from bridging 132512',0.00,0.00,5100.00,0.00,0.00,'2022-02-02 14:48:39','',''),(2633058,'1','179','933',413,'Retail Sale Id 1625733',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 15:26:44','',''),(2633059,'1','179','933',413,'Retail Sale Id 1625734',1800.00,0.00,0.00,3.00,249.00,'2022-02-02 15:33:31','',''),(2633060,'1','179','933',413,'Retail Sale Id 1625735',7500.00,0.00,0.00,12.50,1037.50,'2022-02-02 15:49:00','',''),(2633061,'1','179','933',413,'Retail Sale Id 1625736',3000.00,0.00,0.00,5.00,415.00,'2022-02-02 15:54:05','',''),(2633062,'1','179','933',413,'Retail Sale Id 1625737',3000.00,0.00,0.00,5.00,415.00,'2022-02-02 15:55:05','',''),(2633063,'1','179','933',413,'Retail Sale Id 1625738',7500.00,0.00,0.00,12.50,1037.50,'2022-02-02 16:04:34','',''),(2633064,'1','179','933',413,'Retail Sale Id 1625739',7500.00,0.00,0.00,12.50,1037.50,'2022-02-02 16:21:33','',''),(2633065,'1','179','933',413,'Retail Sale Id 1625740',1002.00,0.00,0.00,1.67,138.61,'2022-02-02 16:22:39','',''),(2633066,'1','179','933',413,'Retail Sale Id 1625741',4998.00,0.00,0.00,8.33,691.39,'2022-02-02 16:24:11','',''),(2633067,'1','179','933',413,'Retail Sale Id 1625742',3600.00,0.00,0.00,6.00,498.00,'2022-02-02 16:26:11','',''),(2633068,'1','179','933',413,'Retail Sale Id 1625743',1002.00,0.00,0.00,1.67,138.61,'2022-02-02 16:26:48','',''),(2633069,'1','179','933',413,'Retail Sale Id 1625744',2298.00,0.00,0.00,3.83,317.89,'2022-02-02 16:27:38','',''),(2633070,'1','179','933',413,'Retail Sale Id 1625745',10200.00,0.00,0.00,17.00,1411.00,'2022-02-02 19:29:34','',''),(2633071,'1','179','933',413,'Retail Sale Id 1625746',24660.00,0.00,0.00,41.10,3411.30,'2022-02-02 19:30:05','',''),(2633072,'1','179','933',413,'Retail Sale Id 1625747',7500.00,0.00,0.00,12.50,1037.50,'2022-02-02 20:11:30','',''),(2633073,'1','179','933',413,'Retail Sale Id 1625748',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 08:04:55','',''),(2633074,'1','179','933',413,'Retail Sale Id 1625749',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 08:05:52','',''),(2633075,'1','179','933',413,'Retail Sale Id 1625750',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 08:12:55','',''),(2633076,'1','179','933',413,'Retail Sale Id 1625751',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 08:24:01','',''),(2633077,'1','179','933',413,'Retail Sale Id 1625752',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 08:26:02','',''),(2633078,'1','179','933',413,'Retail Sale Id 1625753',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 08:32:20','',''),(2633079,'1','179','933',413,'Retail Sale Id 1625754',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 08:33:08','',''),(2633080,'1','179','933',413,'Retail Sale Id 1625755',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 09:11:04','',''),(2633081,'1','179','933',413,'Retail Sale Id 1625756',1998.00,0.00,0.00,3.33,276.39,'2022-02-03 09:12:06','',''),(2633082,'1','179','933',413,'Retail Sale Id 1625757',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 09:19:51','',''),(2633083,'1','179','933',413,'Retail Sale Id 1625758',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 09:26:16','',''),(2633084,'1','179','933',413,'Retail Sale Id 1625759',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 09:30:34','',''),(2633085,'1','179','933',413,'Retail Sale Id 1625760',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 09:31:38','',''),(2633086,'1','179','933',413,'Retail Sale Id 1625761',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 09:40:15','',''),(2633087,'1','179','933',413,'Retail Sale Id 1625762',1200.00,0.00,0.00,2.00,166.00,'2022-02-03 09:42:41','',''),(2633088,'1','179','933',413,'Retail Sale Id 1625763',1998.00,0.00,0.00,3.33,276.39,'2022-02-03 10:06:59','',''),(2633089,'1','179','933',413,'Retail Sale Id 1625765',1200.00,0.00,0.00,2.00,166.00,'2022-02-03 10:15:24','',''),(2633090,'1','179','933',413,'Retail Sale Id 1625766',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 10:36:56','',''),(2633091,'1','179','933',413,'Retail Sale Id 1625767',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 10:37:45','',''),(2633092,'1','179','933',413,'Retail Sale Id 1625768',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 10:57:13','',''),(2633093,'1','179','933',413,'Retail Sale Id 1625769',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 10:58:49','',''),(2633094,'1','179','933',413,'Retail Sale Id 1625770',600.00,0.00,0.00,1.00,83.00,'2022-02-03 11:26:26','',''),(2633095,'1','179','933',413,'Retail Sale Id 1625772',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 11:35:47','',''),(2633096,'1','179','933',413,'Retail Sale Id 1625773',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 11:59:57','',''),(2633097,'1','179','933',413,'Retail Sale Id 1625774',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 12:15:07','',''),(2633098,'1','179','933',413,'Retail Sale Id 1625775',1998.00,0.00,0.00,3.33,276.39,'2022-02-03 12:40:34','',''),(2633099,'1','179','933',413,'Retail Sale Id 1625776',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 12:49:14','',''),(2633100,'1','179','933',413,'Retail Sale Id 1625777',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 12:55:30','',''),(2633101,'1','179','933',413,'Retail Sale Id 1625778',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 13:01:38','',''),(2633102,'1','179','933',413,'Retail Sale Id 1625779',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 13:06:37','',''),(2633103,'1','179','933',413,'Retail Sale Id 1625780',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 13:09:11','',''),(2633104,'1','179','933',413,'Retail Sale Id 1625782',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 17:31:51','',''),(2633105,'1','179','933',413,'Retail Sale Id 1625783',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 17:41:32','',''),(2633106,'1','179','933',413,'Retail Sale Id 1625784',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 17:42:52','',''),(2633107,'1','179','933',413,'Retail Sale Id 1625785',7500.00,0.00,0.00,12.50,1037.50,'2022-02-03 17:43:39','',''),(2633108,'1','179','933',413,'Retail Sale Id 1625786',1500.00,0.00,0.00,2.50,207.50,'2022-02-03 17:44:07','',''),(2633109,'1','179','933',413,'Retail Sale Id 1625787',1998.00,0.00,0.00,3.33,276.39,'2022-02-03 17:45:14','',''),(2633110,'1','179','933',413,'Retail Sale Id 1625788',54180.00,0.00,0.00,90.30,7494.90,'2022-02-03 17:56:03','',''),(2633111,'1','179','933',413,'Retail Sale Id 1625789',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 18:17:02','',''),(2633112,'1','179','933',413,'Retail Sale Id 1625790',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 18:18:17','',''),(2633113,'1','179','933',413,'Retail Sale Id 1625791',2502.00,0.00,0.00,4.17,346.11,'2022-02-03 18:24:05','',''),(2633114,'1','179','933',413,'Retail Sale Id 1625792',1998.00,0.00,0.00,3.33,276.39,'2022-02-03 18:25:01','',''),(2633115,'1','179','933',413,'Retail Sale Id 1625793',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 18:29:46','',''),(2633116,'1','179','933',413,'Retail Sale Id 1625794',600.00,0.00,0.00,1.00,83.00,'2022-02-03 18:31:30','',''),(2633117,'1','179','933',413,'Retail Sale Id 1625795',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 18:36:29','',''),(2633118,'1','179','933',413,'Retail Sale Id 1625796',1800.00,0.00,0.00,3.00,249.00,'2022-02-03 18:37:01','',''),(2633119,'1','179','933',413,'Retail Sale Id 1625797',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 18:41:25','',''),(2633120,'1','179','933',413,'Retail Sale Id 1625798',3000.00,0.00,0.00,5.00,415.00,'2022-02-03 19:13:11','',''),(2633121,'1','179','933',413,'Retail Sale Id 1625799',4998.00,0.00,0.00,8.33,691.39,'2022-02-03 19:40:50','',''),(2633122,'1','179','933',413,'Retail Sale Id 1625800',1998.00,0.00,0.00,3.33,276.39,'2022-02-03 19:42:33','',''),(2633123,'1','179','933',413,'Retail Sale Id 1625801',3600.00,0.00,0.00,6.00,498.00,'2022-02-03 19:44:26','',''),(2633124,'1','179','933',413,'Retail Sale Id 1625802',9000.00,0.00,0.00,15.00,1245.00,'2022-02-04 08:18:58','',''),(2633125,'1','179','933',413,'Retail Sale Id 1625803',1998.00,0.00,0.00,3.33,276.39,'2022-02-04 08:33:09','',''),(2633126,'1','179','933',413,'Retail Sale Id 1625804',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 08:34:38','',''),(2633127,'1','179','933',413,'Retail Sale Id 1625805',1200.00,0.00,0.00,2.00,166.00,'2022-02-04 08:48:06','',''),(2633128,'1','179','933',413,'Retail Sale Id 1625806',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 09:16:20','',''),(2633129,'1','179','933',413,'Retail Sale Id 1625807',4800.00,0.00,0.00,8.00,664.00,'2022-02-04 09:23:54','',''),(2633130,'1','179','933',413,'Retail Sale Id 1625808',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 09:37:32','',''),(2633131,'1','179','933',413,'Retail Sale Id 1625809',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 10:06:26','',''),(2633132,'1','179','933',413,'Retail Sale Id 1625810',1200.00,0.00,0.00,2.00,166.00,'2022-02-04 10:07:55','',''),(2633133,'1','179','933',413,'Retail Sale Id 1625811',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 10:09:35','',''),(2633134,'1','179','933',413,'Retail Sale Id 1625812',1200.00,0.00,0.00,2.00,166.00,'2022-02-04 10:10:37','',''),(2633135,'1','179','933',413,'Retail Sale Id 1625813',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 10:25:50','',''),(2633136,'1','179','933',413,'Retail Sale Id 1625814',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 10:30:59','',''),(2633137,'1','179','933',413,'Retail Sale Id 1625815',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 10:36:29','',''),(2633138,'1','179','933',413,'Retail Sale Id 1625816',19500.00,0.00,0.00,32.50,2697.50,'2022-02-04 11:10:09','',''),(2633139,'1','179','933',413,'Retail Sale Id 1625817',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 11:21:11','',''),(2633140,'1','179','933',413,'Retail Sale Id 1625818',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 11:23:08','',''),(2633141,'1','179','933',413,'Retail Sale Id 1625819',1500.00,0.00,0.00,2.50,207.50,'2022-02-04 11:59:10','',''),(2633142,'1','179','933',413,'Retail Sale Id 1625821',6000.00,0.00,0.00,10.00,830.00,'2022-02-04 12:03:55','',''),(2633143,'1','179','933',413,'Retail Sale Id 1625822',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 12:16:21','',''),(2633144,'1','179','933',413,'Retail Sale Id 1625823',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 12:19:26','',''),(2633145,'1','179','933',413,'Retail Sale Id 1625824',6000.00,0.00,0.00,10.00,830.00,'2022-02-04 12:30:17','',''),(2633146,'1','179','933',413,'Retail Sale Id 1625825',4602.00,0.00,0.00,7.67,636.61,'2022-02-04 12:53:08','',''),(2633147,'1','179','933',413,'Retail Sale Id 1625826',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 13:00:29','',''),(2633148,'1','179','933',413,'Retail Sale Id 1625827',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 13:07:04','',''),(2633149,'1','179','933',413,'Retail Sale Id 1625828',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 14:19:48','',''),(2633150,'1','179','933',413,'Retail Sale Id 1625829',3498.00,0.00,0.00,5.83,483.89,'2022-02-04 14:25:57','',''),(2633151,'1','179','933',413,'Retail Sale Id 1625830',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 14:26:39','',''),(2633152,'1','179','933',413,'Retail Sale Id 1625831',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 14:32:23','',''),(2633153,'1','179','933',413,'Retail Sale Id 1625832',4500.00,0.00,0.00,7.50,622.50,'2022-02-04 14:38:21','',''),(2633154,'1','179','933',413,'Retail Sale Id 1625833',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 14:39:11','',''),(2633155,'1','179','933',413,'Retail Sale Id 1625834',1698.00,0.00,0.00,2.83,234.89,'2022-02-04 14:50:34','',''),(2633156,'1','179','933',413,'Retail Sale Id 1625835',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 14:54:39','',''),(2633157,'1','179','933',413,'Retail Sale Id 1625836',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 15:09:35','',''),(2633158,'1','179','933',413,'Retail Sale Id 1625837',4998.00,0.00,0.00,8.33,691.39,'2022-02-04 15:15:07','',''),(2633159,'1','179','933',413,'Retail Sale Id 1625838',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 15:20:50','',''),(2633160,'1','179','933',413,'Retail Sale Id 1625839',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 15:43:58','',''),(2633161,'1','179','933',413,'Retail Sale Id 1625840',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 15:48:42','',''),(2633162,'1','179','933',413,'Retail Sale Id 1625841',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 15:50:43','',''),(2633163,'1','179','933',413,'Retail Sale Id 1625842',3498.00,0.00,0.00,5.83,483.89,'2022-02-04 16:11:48','',''),(2633164,'1','179','933',413,'Retail Sale Id 1625843',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 16:53:33','',''),(2633165,'1','179','933',413,'Retail Sale Id 1625844',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 16:57:16','',''),(2633166,'1','179','933',413,'Retail Sale Id 1625845',1200.00,0.00,0.00,2.00,166.00,'2022-02-04 16:57:57','',''),(2633167,'1','179','933',413,'Retail Sale Id 1625846',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 17:01:05','',''),(2633168,'1','179','933',413,'Retail Sale Id 1625847',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 17:08:14','',''),(2633169,'1','179','933',413,'Retail Sale Id 1625848',900.00,0.00,0.00,1.50,124.50,'2022-02-04 17:10:18','',''),(2633170,'1','179','933',413,'Retail Sale Id 1625849',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 17:15:47','',''),(2633171,'1','179','933',413,'Retail Sale Id 1625850',1998.00,0.00,0.00,3.33,276.39,'2022-02-04 17:21:25','',''),(2633172,'1','179','933',413,'Retail Sale Id 1625851',3600.00,0.00,0.00,6.00,498.00,'2022-02-04 17:35:17','',''),(2633173,'1','179','933',413,'Retail Sale Id 1625852',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 17:53:34','',''),(2633174,'1','179','933',413,'Retail Sale Id 1625853',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 17:57:16','',''),(2633175,'1','179','933',413,'Retail Sale Id 1625854',1200.00,0.00,0.00,2.00,166.00,'2022-02-04 17:58:13','',''),(2633176,'1','179','933',413,'Retail Sale Id 1625855',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 18:05:09','',''),(2633177,'1','179','933',413,'Retail Sale Id 1625856',4002.00,0.00,0.00,6.67,553.61,'2022-02-04 18:06:34','',''),(2633178,'1','179','933',413,'Retail Sale Id 1625857',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 18:16:34','',''),(2633179,'1','179','933',413,'Retail Sale Id 1625858',6000.00,0.00,0.00,10.00,830.00,'2022-02-04 18:17:47','',''),(2633180,'1','179','933',413,'Retail Sale Id 1625859',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 18:46:24','',''),(2633181,'1','179','933',413,'Retail Sale Id 1625860',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 19:13:37','',''),(2633182,'1','179','933',413,'Retail Sale Id 1625861',1002.00,0.00,0.00,1.67,138.61,'2022-02-04 19:14:34','',''),(2633183,'1','179','933',413,'Retail Sale Id 1625862',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 19:24:42','',''),(2633184,'1','179','933',413,'Retail Sale Id 1625863',15000.00,0.00,0.00,25.00,2075.00,'2022-02-04 19:33:08','',''),(2633185,'1','179','933',413,'Retail Sale Id 1625864',7500.00,0.00,0.00,12.50,1037.50,'2022-02-04 19:34:28','',''),(2633186,'1','179','933',413,'Retail Sale Id 1625865',1800.00,0.00,0.00,3.00,249.00,'2022-02-04 19:50:43','',''),(2633187,'1','179','933',413,'Retail Sale Id 1625866',3000.00,0.00,0.00,5.00,415.00,'2022-02-04 20:04:39','',''),(2633188,'1','179','933',413,'Retail Sale Id 1625867',3498.00,0.00,0.00,5.83,483.89,'2022-02-05 08:56:32','',''),(2633189,'1','179','933',413,'Retail Sale Id 1625868',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 09:20:39','',''),(2633190,'1','179','933',413,'Retail Sale Id 1625869',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 09:40:15','',''),(2633191,'1','179','933',413,'Retail Sale Id 1625870',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 10:34:59','',''),(2633192,'1','179','933',413,'Retail Sale Id 1625871',4002.00,0.00,0.00,6.67,553.61,'2022-02-05 10:35:49','',''),(2633193,'1','179','933',413,'Retail Sale Id 1625872',2502.00,0.00,0.00,4.17,346.11,'2022-02-05 10:40:18','',''),(2633194,'1','179','933',413,'Retail Sale Id 1625873',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 10:44:24','',''),(2633195,'1','179','933',413,'Retail Sale Id 1625874',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 10:47:55','',''),(2633196,'1','179','933',413,'Retail Sale Id 1625875',1998.00,0.00,0.00,3.33,276.39,'2022-02-05 10:48:58','',''),(2633197,'1','179','933',413,'Retail Sale Id 1625876',1998.00,0.00,0.00,3.33,276.39,'2022-02-05 10:59:10','',''),(2633198,'1','179','933',413,'Retail Sale Id 1625877',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 11:00:24','',''),(2633199,'1','179','933',413,'Retail Sale Id 1625878',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 11:28:04','',''),(2633200,'1','179','933',413,'Retail Sale Id 1625879',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 11:42:33','',''),(2633201,'1','179','933',413,'Retail Sale Id 1625880',6000.00,0.00,0.00,10.00,830.00,'2022-02-05 11:57:51','',''),(2633202,'1','179','933',413,'Retail Sale Id 1625881',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 11:58:40','',''),(2633203,'1','179','933',413,'Retail Sale Id 1625882',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 12:07:43','',''),(2633204,'1','179','933',413,'Retail Sale Id 1625883',4800.00,0.00,0.00,8.00,664.00,'2022-02-05 12:15:40','',''),(2633205,'1','179','933',413,'Retail Sale Id 1625884',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 12:17:02','',''),(2633206,'1','179','933',413,'Retail Sale Id 1625885',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 12:19:02','',''),(2633207,'1','179','933',413,'Retail Sale Id 1625886',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 12:39:01','',''),(2633208,'1','179','933',413,'Retail Sale Id 1625887',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 12:51:44','',''),(2633209,'1','179','933',413,'Retail Sale Id 1625888',1998.00,0.00,0.00,3.33,276.39,'2022-02-05 13:00:54','',''),(2633210,'1','179','933',413,'Retail Sale Id 1625889',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 13:04:26','',''),(2633211,'1','179','933',413,'Retail Sale Id 1625890',2100.00,0.00,0.00,3.50,290.50,'2022-02-05 13:13:15','',''),(2633212,'1','179','933',413,'Retail Sale Id 1625891',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 13:22:10','',''),(2633213,'1','179','933',413,'Retail Sale Id 1625892',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 13:26:17','',''),(2633214,'1','179','933',413,'Retail Sale Id 1625893',6600.00,0.00,0.00,11.00,913.00,'2022-02-05 13:29:58','',''),(2633215,'1','179','933',413,'Retail Sale Id 1625894',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 13:47:16','',''),(2633216,'1','179','933',413,'Retail Sale Id 1625895',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 13:47:57','',''),(2633217,'1','179','933',413,'Retail Sale Id 1625896',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 14:10:39','',''),(2633218,'1','179','933',413,'Retail Sale Id 1625897',1200.00,0.00,0.00,2.00,166.00,'2022-02-05 14:12:15','',''),(2633219,'1','179','933',413,'Retail Sale Id 1625898',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 14:13:13','',''),(2633220,'1','179','933',413,'Retail Sale Id 1625899',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 14:14:54','',''),(2633221,'1','179','933',413,'Retail Sale Id 1625900',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 14:19:27','',''),(2633222,'1','179','933',413,'Retail Sale Id 1625901',2502.00,0.00,0.00,4.17,346.11,'2022-02-05 14:20:38','',''),(2633223,'1','179','933',413,'Retail Sale Id 1625902',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 14:21:28','',''),(2633224,'1','179','933',413,'Retail Sale Id 1625903',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 14:22:45','',''),(2633225,'1','179','933',413,'Retail Sale Id 1625904',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 14:28:55','',''),(2633226,'1','179','933',413,'Retail Sale Id 1625905',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 14:49:42','',''),(2633227,'1','179','933',413,'Retail Sale Id 1625906',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 14:50:28','',''),(2633228,'1','179','933',413,'Retail Sale Id 1625907',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 14:56:07','',''),(2633229,'1','179','933',413,'Retail Sale Id 1625908',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 15:00:31','',''),(2633230,'1','179','933',413,'Retail Sale Id 1625909',600.00,0.00,0.00,1.00,83.00,'2022-02-05 15:07:53','',''),(2633231,'1','179','933',413,'Retail Sale Id 1625910',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 15:10:59','',''),(2633232,'1','179','933',413,'Retail Sale Id 1625911',1998.00,0.00,0.00,3.33,276.39,'2022-02-05 15:11:57','',''),(2633233,'1','179','933',413,'Retail Sale Id 1625912',2400.00,0.00,0.00,4.00,332.00,'2022-02-05 15:27:27','',''),(2633234,'1','179','933',413,'Retail Sale Id 1625913',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 15:47:21','',''),(2633235,'1','179','933',413,'Retail Sale Id 1625915',4998.00,0.00,0.00,8.33,691.39,'2022-02-05 15:48:48','',''),(2633236,'1','179','933',413,'Retail Sale Id 1625916',2400.00,0.00,0.00,4.00,332.00,'2022-02-05 16:18:18','',''),(2633237,'1','179','933',413,'Retail Sale Id 1625917',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:19:33','',''),(2633238,'1','179','933',413,'Retail Sale Id 1625918',7200.00,0.00,0.00,12.00,996.00,'2022-02-05 16:26:52','',''),(2633239,'1','179','933',413,'Retail Sale Id 1625919',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 16:47:07','',''),(2633240,'1','179','933',413,'Retail Sale Id 1625920',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:48:11','',''),(2633241,'1','179','933',413,'Retail Sale Id 1625921',1500.00,0.00,0.00,2.50,207.50,'2022-02-05 16:53:23','',''),(2633242,'1','179','933',413,'Retail Sale Id 1625922',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 16:57:55','',''),(2633243,'1','179','933',413,'Retail Sale Id 1625923',1698.00,0.00,0.00,2.83,234.89,'2022-02-05 16:59:55','',''),(2633244,'1','179','933',413,'Retail Sale Id 1625924',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 17:10:22','',''),(2633245,'1','179','933',413,'Retail Sale Id 1625925',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 17:11:44','',''),(2633246,'1','179','933',413,'Retail Sale Id 1625926',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 17:16:59','',''),(2633247,'1','179','933',413,'Retail Sale Id 1625927',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 17:18:01','',''),(2633248,'1','179','933',413,'Retail Sale Id 1625928',3300.00,0.00,0.00,5.50,456.50,'2022-02-05 17:29:14','',''),(2633249,'1','179','933',413,'Retail Sale Id 1625929',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 17:54:19','',''),(2633250,'1','179','933',413,'Retail Sale Id 1625930',3000.00,0.00,0.00,5.00,415.00,'2022-02-05 18:02:46','',''),(2633251,'1','179','933',413,'Retail Sale Id 1625931',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 18:18:14','',''),(2633252,'1','179','933',413,'Retail Sale Id 1625932',600.00,0.00,0.00,1.00,83.00,'2022-02-05 18:32:12','',''),(2633253,'1','179','933',413,'Retail Sale Id 1625933',1200.00,0.00,0.00,2.00,166.00,'2022-02-05 18:36:40','',''),(2633254,'1','179','933',413,'Retail Sale Id 1625935',600.00,0.00,0.00,1.00,83.00,'2022-02-05 18:37:37','',''),(2633255,'1','179','933',413,'Retail Sale Id 1625936',1800.00,0.00,0.00,3.00,249.00,'2022-02-05 19:12:34','',''),(2633256,'1','179','933',413,'Retail Sale Id 1625937',3600.00,0.00,0.00,6.00,498.00,'2022-02-05 19:13:33','',''),(2633257,'1','179','933',413,'Retail Sale Id 1625938',7500.00,0.00,0.00,12.50,1037.50,'2022-02-05 19:23:47','',''),(2633258,'1','179','933',413,'Return of Retail Sale Id 1625937',0.00,3600.00,6.00,0.00,-498.00,'2022-02-05 19:36:57','',''),(2633259,'1','179','933',413,'Retail Sale Id 1625939',1200.00,0.00,0.00,2.00,166.00,'2022-02-05 19:42:06','',''),(2633260,'1','179','933',413,'Retail Sale Id 1625940',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 08:04:04','',''),(2633261,'1','179','933',413,'Retail Sale Id 1625941',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 08:37:09','',''),(2633262,'1','179','933',413,'Retail Sale Id 1625942',7500.00,0.00,0.00,12.50,1037.50,'2022-02-06 08:51:50','',''),(2633263,'1','179','933',413,'Retail Sale Id 1625943',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 08:56:18','',''),(2633264,'1','179','933',413,'Retail Sale Id 1625944',1998.00,0.00,0.00,3.33,276.39,'2022-02-06 08:57:30','',''),(2633265,'1','179','933',413,'Retail Sale Id 1625945',1998.00,0.00,0.00,3.33,276.39,'2022-02-06 09:23:55','',''),(2633266,'1','179','933',413,'Retail Sale Id 1625946',7500.00,0.00,0.00,12.50,1037.50,'2022-02-06 09:42:13','',''),(2633267,'1','179','933',413,'Retail Sale Id 1625947',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 10:04:11','',''),(2633268,'1','179','933',413,'Retail Sale Id 1625948',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 10:18:21','',''),(2633269,'1','179','933',413,'Retail Sale Id 1625949',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 10:22:24','',''),(2633270,'1','179','933',413,'Retail Sale Id 1625950',1200.00,0.00,0.00,2.00,166.00,'2022-02-06 10:28:04','',''),(2633271,'1','179','933',413,'Retail Sale Id 1625951',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 11:25:55','',''),(2633272,'1','179','933',413,'Retail Sale Id 1625952',1500.00,0.00,0.00,2.50,207.50,'2022-02-06 11:30:15','',''),(2633273,'1','179','933',413,'Retail Sale Id 1625953',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 11:36:42','',''),(2633274,'1','179','933',413,'Retail Sale Id 1625954',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 11:39:17','',''),(2633275,'1','179','933',413,'Retail Sale Id 1625955',1500.00,0.00,0.00,2.50,207.50,'2022-02-06 11:49:48','',''),(2633276,'1','179','933',413,'Retail Sale Id 1625956',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 11:59:35','',''),(2633277,'1','179','933',413,'Retail Sale Id 1625957',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 12:07:10','',''),(2633278,'1','179','933',413,'Retail Sale Id 1625958',7800.00,0.00,0.00,13.00,1079.00,'2022-02-06 12:15:02','',''),(2633279,'1','179','933',413,'Retail Sale Id 1625959',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 12:17:23','',''),(2633280,'1','179','933',413,'Retail Sale Id 1625960',798.00,0.00,0.00,1.33,110.39,'2022-02-06 12:32:41','',''),(2633281,'1','179','933',413,'Retail Sale Id 1625961',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 12:34:18','',''),(2633282,'1','179','933',413,'Retail Sale Id 1625962',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 12:42:27','',''),(2633283,'1','179','933',413,'Retail Sale Id 1625963',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 12:46:47','',''),(2633284,'1','179','933',413,'Retail Sale Id 1625964',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 12:48:44','',''),(2633285,'1','179','933',413,'Retail Sale Id 1625965',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 12:49:47','',''),(2633286,'1','179','933',413,'Retail Sale Id 1625966',2400.00,0.00,0.00,4.00,332.00,'2022-02-06 12:50:32','',''),(2633287,'1','179','933',413,'Retail Sale Id 1625967',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 12:53:57','',''),(2633288,'1','179','933',413,'Retail Sale Id 1625968',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 12:54:56','',''),(2633289,'1','179','933',413,'Retail Sale Id 1625969',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 13:11:04','',''),(2633290,'1','179','933',413,'Retail Sale Id 1625970',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 13:31:23','',''),(2633291,'1','179','933',413,'Retail Sale Id 1625971',6000.00,0.00,0.00,10.00,830.00,'2022-02-06 13:34:17','',''),(2633292,'1','179','933',413,'Retail Sale Id 1625972',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 14:08:22','',''),(2633293,'1','179','933',413,'Retail Sale Id 1625973',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 14:14:49','',''),(2633294,'1','179','933',413,'Retail Sale Id 1625974',7500.00,0.00,0.00,12.50,1037.50,'2022-02-06 14:17:40','',''),(2633295,'1','179','933',413,'Retail Sale Id 1625975',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 14:42:43','',''),(2633296,'1','179','933',413,'Retail Sale Id 1625976',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 14:54:46','',''),(2633297,'1','179','933',413,'Retail Sale Id 1625978',2400.00,0.00,0.00,4.00,332.00,'2022-02-06 15:12:12','',''),(2633298,'1','179','933',413,'Retail Sale Id 1625979',6000.00,0.00,0.00,10.00,830.00,'2022-02-06 15:30:47','',''),(2633299,'1','179','933',413,'Retail Sale Id 1625980',1002.00,0.00,0.00,1.67,138.61,'2022-02-06 15:31:54','',''),(2633300,'1','179','933',413,'Retail Sale Id 1625981',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 15:53:19','',''),(2633301,'1','179','933',413,'Retail Sale Id 1625982',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 15:57:16','',''),(2633302,'1','179','933',413,'Retail Sale Id 1625983',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 16:16:32','',''),(2633303,'1','179','933',413,'Retail Sale Id 1625984',15000.00,0.00,0.00,25.00,2075.00,'2022-02-06 16:17:29','',''),(2633304,'1','179','933',413,'Retail Sale Id 1625985',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 16:18:16','',''),(2633305,'1','179','933',413,'Retail Sale Id 1625986',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 16:50:35','',''),(2633306,'1','179','933',413,'Retail Sale Id 1625987',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 16:58:54','',''),(2633307,'1','179','933',413,'Retail Sale Id 1625988',1998.00,0.00,0.00,3.33,276.39,'2022-02-06 17:04:40','',''),(2633308,'1','179','933',413,'Retail Sale Id 1625989',9600.00,0.00,0.00,16.00,1328.00,'2022-02-06 17:07:16','',''),(2633309,'1','179','933',413,'Retail Sale Id 1625990',1998.00,0.00,0.00,3.33,276.39,'2022-02-06 17:14:44','',''),(2633310,'1','179','933',413,'Retail Sale Id 1625991',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 17:15:38','',''),(2633311,'1','179','933',413,'Retail Sale Id 1625992',600.00,0.00,0.00,1.00,83.00,'2022-02-06 17:16:27','',''),(2633312,'1','179','933',413,'Retail Sale Id 1625993',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 17:19:27','',''),(2633313,'1','179','933',413,'Retail Sale Id 1625994',3000.00,0.00,0.00,5.00,415.00,'2022-02-06 17:22:36','',''),(2633314,'1','179','933',413,'Retail Sale Id 1625995',7500.00,0.00,0.00,12.50,1037.50,'2022-02-06 17:23:27','',''),(2633315,'1','179','933',413,'Retail Sale Id 1625996',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 17:34:25','',''),(2633316,'1','179','933',413,'Retail Sale Id 1625997',1002.00,0.00,0.00,1.67,138.61,'2022-02-06 17:40:01','',''),(2633317,'1','179','933',413,'Retail Sale Id 1625998',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 17:50:25','',''),(2633318,'1','179','933',413,'Retail Sale Id 1625999',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 17:54:12','',''),(2633319,'1','179','933',413,'Retail Sale Id 1626000',1002.00,0.00,0.00,1.67,138.61,'2022-02-06 17:54:55','',''),(2633320,'1','179','933',413,'Retail Sale Id 1626001',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 18:02:03','',''),(2633321,'1','179','933',413,'Retail Sale Id 1626002',1398.00,0.00,0.00,2.33,193.39,'2022-02-06 18:29:00','',''),(2633322,'1','179','933',413,'Retail Sale Id 1626004',1002.00,0.00,0.00,1.67,138.61,'2022-02-06 18:29:45','',''),(2633323,'1','179','933',413,'Retail Sale Id 1626005',7500.00,0.00,0.00,12.50,1037.50,'2022-02-06 18:40:28','',''),(2633324,'1','179','933',413,'Retail Sale Id 1626006',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 19:00:08','',''),(2633325,'1','179','933',413,'Retail Sale Id 1626007',1800.00,0.00,0.00,3.00,249.00,'2022-02-06 19:05:32','',''),(2633326,'1','179','933',413,'Retail Sale Id 1626008',3600.00,0.00,0.00,6.00,498.00,'2022-02-06 19:20:03','',''),(2633327,'1','179','933',413,'Retail Sale Id 1626009',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 10:56:48','',''),(2633328,'1','179','933',413,'Retail Sale Id 1626010',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 10:57:31','',''),(2633329,'1','179','933',413,'Retail Sale Id 1626011',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 10:58:10','',''),(2633330,'1','179','933',413,'Retail Sale Id 1626012',7002.00,0.00,0.00,11.67,968.61,'2022-02-07 10:59:20','',''),(2633331,'1','179','933',413,'Retail Sale Id 1626013',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 11:00:28','',''),(2633332,'1','179','933',413,'Retail Sale Id 1626014',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 11:09:50','',''),(2633333,'1','179','933',413,'Retail Sale Id 1626015',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 11:29:30','',''),(2633334,'1','179','933',413,'Retail Sale Id 1626016',3258.00,0.00,0.00,5.43,450.69,'2022-02-07 13:18:17','',''),(2633335,'1','179','933',413,'Retail Sale Id 1626017',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 13:26:16','',''),(2633336,'1','179','933',413,'Retail Sale Id 1626018',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 13:26:53','',''),(2633337,'1','179','933',413,'Retail Sale Id 1626019',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 13:27:40','',''),(2633338,'1','179','933',413,'Retail Sale Id 1626020',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 13:29:25','',''),(2633339,'1','179','933',413,'Retail Sale Id 1626021',1200.00,0.00,0.00,2.00,166.00,'2022-02-07 14:07:06','',''),(2633340,'1','179','933',413,'Retail Sale Id 1626022',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 14:13:06','',''),(2633341,'1','179','933',413,'Retail Sale Id 1626023',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 15:00:39','',''),(2633342,'1','179','933',413,'Retail Sale Id 1626024',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 15:01:50','',''),(2633343,'1','179','933',413,'Retail Sale Id 1626025',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 15:06:19','',''),(2633344,'1','179','933',413,'Retail Sale Id 1626026',12600.00,0.00,0.00,21.00,1743.00,'2022-02-07 15:13:56','',''),(2633345,'1','179','933',413,'Retail Sale Id 1626027',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 15:32:24','',''),(2633346,'1','179','933',413,'Retail Sale Id 1626028',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 15:43:59','',''),(2633347,'1','179','933',413,'Retail Sale Id 1626029',6600.00,0.00,0.00,11.00,913.00,'2022-02-07 15:54:06','',''),(2633348,'1','179','933',413,'Retail Sale Id 1626030',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 16:03:52','',''),(2633349,'1','179','933',413,'Retail Sale Id 1626031',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 16:04:32','',''),(2633350,'1','179','933',413,'Retail Sale Id 1626032',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 16:33:22','',''),(2633351,'1','179','933',413,'Retail Sale Id 1626033',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 16:42:05','',''),(2633352,'1','179','933',413,'Retail Sale Id 1626034',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 16:55:00','',''),(2633353,'1','179','933',413,'Retail Sale Id 1626035',6600.00,0.00,0.00,11.00,913.00,'2022-02-07 16:59:45','',''),(2633354,'1','179','933',413,'Retail Sale Id 1626036',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 17:00:41','',''),(2633355,'1','179','933',413,'Retail Sale Id 1626037',1500.00,0.00,0.00,2.50,207.50,'2022-02-07 17:02:34','',''),(2633356,'1','179','933',413,'Retail Sale Id 1626038',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 17:10:01','',''),(2633357,'1','179','933',413,'Retail Sale Id 1626039',1500.00,0.00,0.00,2.50,207.50,'2022-02-07 17:15:05','',''),(2633358,'1','179','933',413,'Retail Sale Id 1626040',6000.00,0.00,0.00,10.00,830.00,'2022-02-07 17:15:43','',''),(2633359,'1','179','933',413,'Retail Sale Id 1626041',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 17:17:57','',''),(2633360,'1','179','933',413,'Retail Sale Id 1626042',2502.00,0.00,0.00,4.17,346.11,'2022-02-07 17:20:29','',''),(2633361,'1','179','933',413,'Retail Sale Id 1626043',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 17:34:12','',''),(2633362,'1','179','933',413,'Retail Sale Id 1626044',3600.00,0.00,0.00,6.00,498.00,'2022-02-07 17:55:09','',''),(2633363,'1','179','933',413,'Retail Sale Id 1626045',4800.00,0.00,0.00,8.00,664.00,'2022-02-07 17:56:05','',''),(2633364,'1','179','933',413,'Retail Sale Id 1626046',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 18:03:15','',''),(2633365,'1','179','933',413,'Retail Sale Id 1626047',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 18:06:34','',''),(2633366,'1','179','933',413,'Retail Sale Id 1626048',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 18:08:22','',''),(2633367,'1','179','933',413,'Retail Sale Id 1626049',1998.00,0.00,0.00,3.33,276.39,'2022-02-07 18:09:36','',''),(2633368,'1','179','933',413,'Retail Sale Id 1626050',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 18:11:34','',''),(2633369,'1','179','933',413,'Retail Sale Id 1626051',1200.00,0.00,0.00,2.00,166.00,'2022-02-07 18:12:14','',''),(2633370,'1','179','933',413,'Retail Sale Id 1626052',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 18:15:44','',''),(2633371,'1','179','933',413,'Retail Sale Id 1626053',2502.00,0.00,0.00,4.17,346.11,'2022-02-07 18:17:01','',''),(2633372,'1','179','933',413,'Retail Sale Id 1626054',4200.00,0.00,0.00,7.00,581.00,'2022-02-07 18:21:54','',''),(2633373,'1','179','933',413,'Retail Sale Id 1626055',2400.00,0.00,0.00,4.00,332.00,'2022-02-07 18:23:12','',''),(2633374,'1','179','933',413,'Retail Sale Id 1626056',2400.00,0.00,0.00,4.00,332.00,'2022-02-07 18:24:56','',''),(2633375,'1','179','933',413,'Retail Sale Id 1626057',1002.00,0.00,0.00,1.67,138.61,'2022-02-07 18:33:25','',''),(2633376,'1','179','933',413,'Retail Sale Id 1626058',4998.00,0.00,0.00,8.33,691.39,'2022-02-07 18:34:53','',''),(2633377,'1','179','933',413,'Retail Sale Id 1626059',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 18:35:35','',''),(2633378,'1','179','933',413,'Retail Sale Id 1626060',900.00,0.00,0.00,1.50,124.50,'2022-02-07 18:36:32','',''),(2633379,'1','179','933',413,'Retail Sale Id 1626061',3000.00,0.00,0.00,5.00,415.00,'2022-02-07 18:37:29','',''),(2633380,'1','179','933',413,'Retail Sale Id 1626062',1500.00,0.00,0.00,2.50,207.50,'2022-02-07 18:52:12','',''),(2633381,'1','179','933',413,'Retail Sale Id 1626063',600.00,0.00,0.00,1.00,83.00,'2022-02-07 19:03:56','',''),(2633382,'1','179','933',413,'Retail Sale Id 1626064',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 19:10:38','',''),(2633383,'1','179','933',413,'Retail Sale Id 1626065',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 19:23:37','',''),(2633384,'1','179','933',413,'Retail Sale Id 1626067',7500.00,0.00,0.00,12.50,1037.50,'2022-02-07 19:24:30','',''),(2633385,'1','179','933',413,'Retail Sale Id 1626068',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 19:25:50','',''),(2633386,'1','179','933',413,'Retail Sale Id 1626069',1200.00,0.00,0.00,2.00,166.00,'2022-02-07 19:28:43','',''),(2633387,'1','179','933',413,'Retail Sale Id 1626070',600.00,0.00,0.00,1.00,83.00,'2022-02-07 19:29:24','',''),(2633388,'1','179','933',413,'Retail Sale Id 1626071',1800.00,0.00,0.00,3.00,249.00,'2022-02-07 19:41:23','',''),(2633389,'1','179','933',413,'Retail Sale Id 1626072',6000.00,0.00,0.00,10.00,830.00,'2022-02-08 08:19:17','',''),(2633390,'1','179','933',413,'Retail Sale Id 1626073',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 08:20:42','',''),(2633391,'1','179','933',413,'Retail Sale Id 1626074',1200.00,0.00,0.00,2.00,166.00,'2022-02-08 08:21:12','',''),(2633392,'1','179','933',413,'Retail Sale Id 1626075',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 08:27:44','',''),(2633393,'1','179','933',413,'Retail Sale Id 1626076',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 08:28:38','',''),(2633394,'1','179','933',413,'Retail Sale Id 1626077',4002.00,0.00,0.00,6.67,553.61,'2022-02-08 08:45:27','',''),(2633395,'1','179','933',413,'Retail Sale Id 1626078',7200.00,0.00,0.00,12.00,996.00,'2022-02-08 09:12:26','',''),(2633396,'1','179','933',413,'Retail Sale Id 1626079',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 09:14:06','',''),(2633397,'1','179','933',413,'Retail Sale Id 1626080',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 09:59:03','',''),(2633398,'1','179','933',413,'Retail Sale Id 1626081',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 10:23:13','',''),(2633399,'1','179','933',413,'Retail Sale Id 1626082',1002.00,0.00,0.00,1.67,138.61,'2022-02-08 10:24:01','',''),(2633400,'1','179','933',413,'Retail Sale Id 1626083',3000.00,0.00,0.00,5.00,415.00,'2022-02-08 10:44:51','',''),(2633401,'1','179','933',413,'Retail Sale Id 1626084',7500.00,0.00,0.00,12.50,1037.50,'2022-02-08 10:58:30','',''),(2633402,'1','179','933',413,'Retail Sale Id 1626085',3000.00,0.00,0.00,5.00,415.00,'2022-02-08 11:03:33','',''),(2633403,'1','179','933',413,'Retail Sale Id 1626086',4998.00,0.00,0.00,8.33,691.39,'2022-02-08 11:10:19','',''),(2633404,'1','179','933',413,'Retail Sale Id 1626087',1500.00,0.00,0.00,2.50,207.50,'2022-02-08 11:10:59','',''),(2633405,'1','179','933',413,'Retail Sale Id 1626088',2400.00,0.00,0.00,4.00,332.00,'2022-02-08 11:11:40','',''),(2633406,'1','179','933',413,'Retail Sale Id 1626089',4800.00,0.00,0.00,8.00,664.00,'2022-02-08 11:13:20','',''),(2633407,'1','179','933',413,'Retail Sale Id 1626090',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 11:30:53','',''),(2633408,'1','179','933',413,'Retail Sale Id 1626091',2100.00,0.00,0.00,3.50,290.50,'2022-02-08 11:32:04','',''),(2633409,'1','179','933',413,'Retail Sale Id 1626092',7500.00,0.00,0.00,12.50,1037.50,'2022-02-08 11:34:03','',''),(2633410,'1','179','933',413,'Retail Sale Id 1626093',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 12:30:27','',''),(2633411,'1','179','933',413,'Retail Sale Id 1626094',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 13:03:21','',''),(2633412,'1','179','933',413,'Retail Sale Id 1626095',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 13:06:52','',''),(2633413,'1','179','933',413,'Retail Sale Id 1626096',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 13:24:54','',''),(2633414,'1','179','933',413,'Retail Sale Id 1626097',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 14:50:41','',''),(2633415,'1','179','933',413,'Retail Sale Id 1626098',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 14:51:23','',''),(2633416,'1','179','933',413,'Retail Sale Id 1626099',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 14:52:13','',''),(2633417,'1','179','933',413,'Retail Sale Id 1626100',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 16:36:39','',''),(2633418,'1','179','933',413,'Retail Sale Id 1626101',4998.00,0.00,0.00,8.33,691.39,'2022-02-08 16:45:20','',''),(2633419,'1','179','933',413,'Retail Sale Id 1626102',600.00,0.00,0.00,1.00,83.00,'2022-02-08 16:45:58','',''),(2633420,'1','179','933',413,'Retail Sale Id 1626103',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 16:47:33','',''),(2633421,'1','179','933',413,'Retail Sale Id 1626104',1998.00,0.00,0.00,3.33,276.39,'2022-02-08 16:55:50','',''),(2633422,'1','179','933',413,'Retail Sale Id 1626105',7500.00,0.00,0.00,12.50,1037.50,'2022-02-08 17:09:17','',''),(2633423,'1','179','933',413,'Retail Sale Id 1626106',6000.00,0.00,0.00,10.00,830.00,'2022-02-08 17:19:24','',''),(2633424,'1','179','933',413,'Retail Sale Id 1626107',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 17:20:05','',''),(2633425,'1','179','933',413,'Retail Sale Id 1626108',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 17:28:51','',''),(2633426,'1','179','933',413,'Retail Sale Id 1626109',4002.00,0.00,0.00,6.67,553.61,'2022-02-08 17:35:17','',''),(2633427,'1','179','933',413,'Retail Sale Id 1626110',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 17:35:53','',''),(2633428,'1','179','933',413,'Retail Sale Id 1626111',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 17:41:48','',''),(2633429,'1','179','933',413,'Retail Sale Id 1626112',5502.00,0.00,0.00,9.17,761.11,'2022-02-08 17:43:24','',''),(2633430,'1','179','933',413,'Retail Sale Id 1626114',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 17:44:55','',''),(2633431,'1','179','933',413,'Retail Sale Id 1626115',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 17:47:05','',''),(2633432,'1','179','933',413,'Retail Sale Id 1626116',1998.00,0.00,0.00,3.33,276.39,'2022-02-08 17:49:52','',''),(2633433,'1','179','933',413,'Retail Sale Id 1626117',1002.00,0.00,0.00,1.67,138.61,'2022-02-08 17:51:11','',''),(2633434,'1','179','933',413,'Retail Sale Id 1626118',3000.00,0.00,0.00,5.00,415.00,'2022-02-08 17:53:16','',''),(2633435,'1','179','933',413,'Retail Sale Id 1626119',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 17:54:46','',''),(2633436,'1','179','933',413,'Retail Sale Id 1626120',7500.00,0.00,0.00,12.50,1037.50,'2022-02-08 18:00:28','',''),(2633437,'1','179','933',413,'Retail Sale Id 1626121',2400.00,0.00,0.00,4.00,332.00,'2022-02-08 18:12:14','',''),(2633438,'1','179','933',413,'Retail Sale Id 1626122',1002.00,0.00,0.00,1.67,138.61,'2022-02-08 18:15:38','',''),(2633439,'1','179','933',413,'Retail Sale Id 1626123',600.00,0.00,0.00,1.00,83.00,'2022-02-08 18:16:30','',''),(2633440,'1','179','933',413,'Retail Sale Id 1626124',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 18:17:18','',''),(2633441,'1','179','933',413,'Retail Sale Id 1626125',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 18:20:35','',''),(2633442,'1','179','933',413,'Retail Sale Id 1626126',8400.00,0.00,0.00,14.00,1162.00,'2022-02-08 18:37:56','',''),(2633443,'1','179','933',413,'Retail Sale Id 1626127',900.00,0.00,0.00,1.50,124.50,'2022-02-08 18:42:18','',''),(2633444,'1','179','933',413,'Retail Sale Id 1626128',1800.00,0.00,0.00,3.00,249.00,'2022-02-08 18:43:22','',''),(2633445,'1','179','933',413,'Retail Sale Id 1626129',3600.00,0.00,0.00,6.00,498.00,'2022-02-08 18:46:07','',''),(2633446,'1','179','933',413,'Retail Sale Id 1626130',1200.00,0.00,0.00,2.00,166.00,'2022-02-08 19:10:08','',''),(2633447,'1','179','933',413,'Retail Sale Id 1626131',5100.00,0.00,0.00,8.50,705.50,'2022-02-08 19:11:13','',''),(2633448,'1','179','933',413,'Retail Sale Id 1626132',600.00,0.00,0.00,1.00,83.00,'2022-02-08 19:16:45','',''),(2633449,'1','179','933',413,'Retail Sale Id 1626133',3000.00,0.00,0.00,5.00,415.00,'2022-02-08 19:29:46','',''),(2633450,'1','179','933',413,'Retail Sale Id 1626134',6600.00,0.00,0.00,11.00,913.00,'2022-02-09 10:08:54','',''),(2633451,'1','179','933',413,'Retail Sale Id 1626135',7200.00,0.00,0.00,12.00,996.00,'2022-02-09 10:10:19','',''),(2633452,'1','179','933',413,'Retail Sale Id 1626136',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 10:11:27','',''),(2633453,'1','179','933',413,'Retail Sale Id 1626137',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 10:17:51','',''),(2633454,'1','179','933',413,'Retail Sale Id 1626138',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 10:18:48','',''),(2633455,'1','179','933',413,'Retail Sale Id 1626139',1200000.00,0.00,0.00,2000.00,166000.00,'2022-02-09 10:34:18','',''),(2633456,'1','179','933',413,'Retail Sale Id 1626140',1998.00,0.00,0.00,3.33,276.39,'2022-02-09 10:36:49','',''),(2633457,'1','179','933',413,'Retail Sale Id 1626141',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 10:43:27','',''),(2633458,'1','179','933',413,'Retail Sale Id 1626142',2400.00,0.00,0.00,4.00,332.00,'2022-02-09 10:45:18','',''),(2633459,'1','179','933',413,'Retail Sale Id 1626143',9000.00,0.00,0.00,15.00,1245.00,'2022-02-09 11:06:11','',''),(2633460,'1','179','933',413,'Retail Sale Id 1626144',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 11:10:44','',''),(2633461,'1','179','933',413,'Retail Sale Id 1626145',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 11:17:20','',''),(2633462,'1','179','933',413,'Retail Sale Id 1626146',7002.00,0.00,0.00,11.67,968.61,'2022-02-09 11:26:53','',''),(2633463,'1','179','933',413,'Retail Sale Id 1626147',1500.00,0.00,0.00,2.50,207.50,'2022-02-09 11:30:41','',''),(2633464,'1','179','933',413,'Retail Sale Id 1626149',1500.00,0.00,0.00,2.50,207.50,'2022-02-09 12:04:56','',''),(2633465,'1','179','933',413,'Retail Sale Id 1626151',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 12:32:18','',''),(2633466,'1','179','933',413,'Retail Sale Id 1626152',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 12:35:22','',''),(2633467,'1','179','933',413,'Retail Sale Id 1626153',1998.00,0.00,0.00,3.33,276.39,'2022-02-09 12:39:03','',''),(2633468,'1','179','933',413,'Return of Retail Sale Id 1626139',0.00,1200000.00,2000.00,0.00,-166000.00,'2022-02-09 12:44:54','',''),(2633469,'1','179','933',413,'Retail Sale Id 1626154',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 13:07:01','',''),(2633470,'1','179','933',413,'Retail Sale Id 1626155',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 13:10:19','',''),(2633471,'1','179','933',413,'Retail Sale Id 1626156',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 13:25:35','',''),(2633472,'1','179','933',413,'Retail Sale Id 1626157',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 13:45:11','',''),(2633473,'1','179','933',413,'Retail Sale Id 1626158',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 14:10:04','',''),(2633474,'1','179','933',413,'Retail Sale Id 1626159',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 14:19:49','',''),(2633475,'1','179','933',413,'Retail Sale Id 1626160',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 14:23:46','',''),(2633476,'1','179','933',413,'Retail Sale Id 1626161',1500.00,0.00,0.00,2.50,207.50,'2022-02-09 14:45:34','',''),(2633477,'1','179','933',413,'Retail Sale Id 1626162',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 14:51:17','',''),(2633478,'1','179','933',413,'Retail Sale Id 1626163',1200.00,0.00,0.00,2.00,166.00,'2022-02-09 15:14:27','',''),(2633479,'1','179','933',413,'Retail Sale Id 1626164',2400.00,0.00,0.00,4.00,332.00,'2022-02-09 15:20:25','',''),(2633480,'1','179','933',413,'Retail Sale Id 1626165',7500.00,0.00,0.00,12.50,1037.50,'2022-02-09 15:34:03','',''),(2633481,'1','179','933',413,'Retail Sale Id 1626166',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 15:37:49','',''),(2633482,'1','179','933',413,'Retail Sale Id 1626167',5400.00,0.00,0.00,9.00,747.00,'2022-02-09 15:42:34','',''),(2633483,'1','179','933',413,'Retail Sale Id 1626168',2502.00,0.00,0.00,4.17,346.11,'2022-02-09 15:57:28','',''),(2633484,'1','179','933',413,'Retail Sale Id 1626169',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 16:35:18','',''),(2633485,'1','179','933',413,'Retail Sale Id 1626170',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 16:51:02','',''),(2633486,'1','179','933',413,'Retail Sale Id 1626171',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 16:58:34','',''),(2633487,'1','179','933',413,'Retail Sale Id 1626172',2400.00,0.00,0.00,4.00,332.00,'2022-02-09 17:00:27','',''),(2633488,'1','179','933',413,'Retail Sale Id 1626173',600.00,0.00,0.00,1.00,83.00,'2022-02-09 17:01:10','',''),(2633489,'1','179','933',413,'Retail Sale Id 1626174',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 17:03:08','',''),(2633490,'1','179','933',413,'Retail Sale Id 1626175',6000.00,0.00,0.00,10.00,830.00,'2022-02-09 17:04:53','',''),(2633491,'1','179','933',413,'Retail Sale Id 1626176',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 17:17:23','',''),(2633492,'1','179','933',413,'Retail Sale Id 1626177',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 17:30:06','',''),(2633493,'1','179','933',413,'Retail Sale Id 1626178',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 17:33:16','',''),(2633494,'1','179','933',413,'Retail Sale Id 1626179',1998.00,0.00,0.00,3.33,276.39,'2022-02-09 17:42:35','',''),(2633495,'1','179','933',413,'Retail Sale Id 1626180',1500.00,0.00,0.00,2.50,207.50,'2022-02-09 17:45:09','',''),(2633496,'1','179','933',413,'Retail Sale Id 1626181',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 17:47:13','',''),(2633497,'1','179','933',413,'Retail Sale Id 1626182',4998.00,0.00,0.00,8.33,691.39,'2022-02-09 17:51:34','',''),(2633498,'1','179','933',413,'Retail Sale Id 1626183',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 17:54:53','',''),(2633499,'1','179','933',413,'Retail Sale Id 1626184',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 18:03:43','',''),(2633500,'1','179','933',413,'Retail Sale Id 1626185',1998.00,0.00,0.00,3.33,276.39,'2022-02-09 18:14:11','',''),(2633501,'1','179','933',413,'Retail Sale Id 1626186',2400.00,0.00,0.00,4.00,332.00,'2022-02-09 18:25:16','',''),(2633502,'1','179','933',413,'Retail Sale Id 1626187',3600.00,0.00,0.00,6.00,498.00,'2022-02-09 18:27:44','',''),(2633503,'1','179','933',413,'Retail Sale Id 1626188',6000.00,0.00,0.00,10.00,830.00,'2022-02-09 18:36:24','',''),(2633504,'1','179','933',413,'Retail Sale Id 1626189',1800.00,0.00,0.00,3.00,249.00,'2022-02-09 18:40:31','',''),(2633505,'1','179','933',413,'Retail Sale Id 1626190',3000.00,0.00,0.00,5.00,415.00,'2022-02-09 18:41:57','',''),(2633506,'1','179','933',413,'Retail Sale Id 1626191',1200.00,0.00,0.00,2.00,166.00,'2022-02-09 19:40:13','',''),(2633507,'1','179','933',413,'Retail Sale Id 1626192',13500.00,0.00,0.00,22.50,1867.50,'2022-02-09 20:13:48','',''),(2633508,'1','179','933',413,'Retail Sale Id 1626193',1002.00,0.00,0.00,1.67,138.61,'2022-02-09 20:14:33','',''),(2633509,'1','179','933',413,'Retail Sale Id 1626194',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 08:13:50','',''),(2633510,'1','179','933',413,'Retail Sale Id 1626195',7500.00,0.00,0.00,12.50,1037.50,'2022-02-10 08:27:54','',''),(2633511,'1','179','933',413,'Retail Sale Id 1626196',4998.00,0.00,0.00,8.33,691.39,'2022-02-10 08:28:48','',''),(2633512,'1','179','933',413,'Retail Sale Id 1626197',2400.00,0.00,0.00,4.00,332.00,'2022-02-10 08:32:58','',''),(2633513,'1','179','933',413,'Retail Sale Id 1626198',900.00,0.00,0.00,1.50,124.50,'2022-02-10 08:56:04','',''),(2633514,'1','179','933',413,'Retail Sale Id 1626199',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 09:04:18','',''),(2633515,'1','179','933',413,'Retail Sale Id 1626200',1998.00,0.00,0.00,3.33,276.39,'2022-02-10 09:15:28','',''),(2633516,'1','179','933',413,'Retail Sale Id 1626201',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 09:58:24','',''),(2633517,'1','179','933',413,'Retail Sale Id 1626202',1200.00,0.00,0.00,2.00,166.00,'2022-02-10 10:08:49','',''),(2633518,'1','179','933',413,'Retail Sale Id 1626203',4800.00,0.00,0.00,8.00,664.00,'2022-02-10 10:24:42','',''),(2633519,'1','179','933',413,'Retail Sale Id 1626204',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 11:09:41','',''),(2633520,'1','179','933',413,'Retail Sale Id 1626205',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 11:19:31','',''),(2633521,'1','179','933',413,'Retail Sale Id 1626207',6000.00,0.00,0.00,10.00,830.00,'2022-02-10 11:22:35','',''),(2633522,'1','179','933',413,'Retail Sale Id 1626208',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 11:31:42','',''),(2633523,'1','179','933',413,'Retail Sale Id 1626209',1200.00,0.00,0.00,2.00,166.00,'2022-02-10 11:39:58','',''),(2633524,'1','179','933',413,'Retail Sale Id 1626210',750.00,0.00,0.00,1.25,103.75,'2022-02-10 11:49:15','',''),(2633525,'1','179','933',413,'Retail Sale Id 1626211',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 11:56:21','',''),(2633526,'1','179','933',413,'Retail Sale Id 1626212',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 12:16:29','',''),(2633527,'1','179','933',413,'Retail Sale Id 1626213',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 12:23:01','',''),(2633528,'1','179','933',413,'Retail Sale Id 1626214',2400.00,0.00,0.00,4.00,332.00,'2022-02-10 13:22:43','',''),(2633529,'1','179','933',413,'Retail Sale Id 1626215',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 13:24:22','',''),(2633530,'1','179','933',413,'Retail Sale Id 1626216',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 13:54:23','',''),(2633531,'1','179','933',413,'Retail Sale Id 1626217',1998.00,0.00,0.00,3.33,276.39,'2022-02-10 14:04:49','',''),(2633532,'1','179','933',413,'Retail Sale Id 1626218',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 14:11:43','',''),(2633533,'1','179','933',413,'Retail Sale Id 1626219',7500.00,0.00,0.00,12.50,1037.50,'2022-02-10 14:12:59','',''),(2633534,'1','179','933',413,'Retail Sale Id 1626220',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 14:35:24','',''),(2633535,'1','179','933',413,'Retail Sale Id 1626221',7500.00,0.00,0.00,12.50,1037.50,'2022-02-10 14:43:50','',''),(2633536,'1','179','933',413,'Retail Sale Id 1626222',3000.00,0.00,0.00,5.00,415.00,'2022-02-10 14:45:18','',''),(2633537,'1','179','933',413,'Retail Sale Id 1626223',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 15:14:06','',''),(2633538,'1','179','933',413,'Retail Sale Id 1626224',4998.00,0.00,0.00,8.33,691.39,'2022-02-10 15:22:39','',''),(2633539,'1','179','933',413,'Retail Sale Id 1626226',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 15:44:47','',''),(2633540,'1','179','933',413,'Retail Sale Id 1626227',4998.00,0.00,0.00,8.33,691.39,'2022-02-10 15:45:26','',''),(2633541,'1','179','933',413,'Retail Sale Id 1626230',7500.00,0.00,0.00,12.50,1037.50,'2022-02-10 15:48:31','',''),(2633542,'1','179','933',413,'Retail Sale Id 1626231',3000.00,0.00,0.00,5.00,415.00,'2022-02-10 15:57:57','',''),(2633543,'1','179','933',413,'Retail Sale Id 1626232',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 16:25:06','',''),(2633544,'1','179','933',413,'Retail Sale Id 1626233',7500.00,0.00,0.00,12.50,1037.50,'2022-02-10 16:26:36','',''),(2633545,'1','179','933',413,'Retail Sale Id 1626234',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 16:30:05','',''),(2633546,'1','179','933',413,'Retail Sale Id 1626235',2400.00,0.00,0.00,4.00,332.00,'2022-02-10 16:43:22','',''),(2633547,'1','179','933',413,'Retail Sale Id 1626236',3000.00,0.00,0.00,5.00,415.00,'2022-02-10 16:46:02','',''),(2633548,'1','179','933',413,'Retail Sale Id 1626237',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 16:55:42','',''),(2633549,'1','179','933',413,'Retail Sale Id 1626238',6000.00,0.00,0.00,10.00,830.00,'2022-02-10 17:08:35','',''),(2633550,'1','179','933',413,'Retail Sale Id 1626239',7002.00,0.00,0.00,11.67,968.61,'2022-02-10 17:17:44','',''),(2633551,'1','179','933',413,'Retail Sale Id 1626240',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 17:43:09','',''),(2633552,'1','179','933',413,'Retail Sale Id 1626241',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 17:55:37','',''),(2633553,'1','179','933',413,'Retail Sale Id 1626242',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 17:57:29','',''),(2633554,'1','179','933',413,'Retail Sale Id 1626243',1800.00,0.00,0.00,3.00,249.00,'2022-02-10 17:59:22','',''),(2633555,'1','179','933',413,'Retail Sale Id 1626244',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 18:05:15','',''),(2633556,'1','179','933',413,'Retail Sale Id 1626245',1500.00,0.00,0.00,2.50,207.50,'2022-02-10 18:05:57','',''),(2633557,'1','179','933',413,'Retail Sale Id 1626246',1500.00,0.00,0.00,2.50,207.50,'2022-02-10 18:09:35','',''),(2633558,'1','179','933',413,'Retail Sale Id 1626247',1002.00,0.00,0.00,1.67,138.61,'2022-02-10 18:29:06','',''),(2633559,'1','179','933',413,'Retail Sale Id 1626248',3600.00,0.00,0.00,6.00,498.00,'2022-02-10 19:13:30','',''),(2633560,'1','179','933',413,'Retail Sale Id 1626249',1500.00,0.00,0.00,2.50,207.50,'2022-02-10 19:20:31','',''),(2633561,'1','179','933',413,'Retail Sale Id 1626250',4800.00,0.00,0.00,8.00,664.00,'2022-02-11 08:37:52','',''),(2633562,'1','179','933',413,'Retail Sale Id 1626251',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 09:24:39','',''),(2633563,'1','179','933',413,'Retail Sale Id 1626252',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 09:25:28','',''),(2633564,'1','179','933',413,'Retail Sale Id 1626253',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 09:33:45','',''),(2633565,'1','179','933',413,'Retail Sale Id 1626254',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 09:42:51','',''),(2633566,'1','179','933',413,'Retail Sale Id 1626255',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 09:54:08','',''),(2633567,'1','179','933',413,'Retail Sale Id 1626256',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 10:57:25','',''),(2633568,'1','179','933',413,'Retail Sale Id 1626257',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 11:06:52','',''),(2633569,'1','179','933',413,'Retail Sale Id 1626258',6000.00,0.00,0.00,10.00,830.00,'2022-02-11 11:21:19','',''),(2633570,'1','179','933',413,'Retail Sale Id 1626259',1200.00,0.00,0.00,2.00,166.00,'2022-02-11 11:22:52','',''),(2633571,'1','179','933',413,'Retail Sale Id 1626260',7500.00,0.00,0.00,12.50,1037.50,'2022-02-11 11:23:43','',''),(2633572,'1','179','933',413,'Retail Sale Id 1626261',1200.00,0.00,0.00,2.00,166.00,'2022-02-11 11:27:46','',''),(2633573,'1','179','933',413,'Retail Sale Id 1626262',2100.00,0.00,0.00,3.50,290.50,'2022-02-11 11:28:49','',''),(2633574,'1','179','933',413,'Retail Sale Id 1626263',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 11:33:49','',''),(2633575,'1','179','933',413,'Retail Sale Id 1626264',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 11:44:23','',''),(2633576,'1','179','933',413,'Retail Sale Id 1626265',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 12:30:14','',''),(2633577,'1','179','933',413,'Retail Sale Id 1626266',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 12:39:15','',''),(2633578,'1','179','933',413,'Retail Sale Id 1626267',7500.00,0.00,0.00,12.50,1037.50,'2022-02-11 12:40:31','',''),(2633579,'1','179','933',413,'Retail Sale Id 1626268',7500.00,0.00,0.00,12.50,1037.50,'2022-02-11 12:44:07','',''),(2633580,'1','179','933',413,'Retail Sale Id 1626269',1002.00,0.00,0.00,1.67,138.61,'2022-02-11 13:14:31','',''),(2633581,'1','179','933',413,'Retail Sale Id 1626270',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 13:27:07','',''),(2633582,'1','179','933',413,'Retail Sale Id 1626271',1998.00,0.00,0.00,3.33,276.39,'2022-02-11 14:10:41','',''),(2633583,'1','179','933',413,'Retail Sale Id 1626272',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 14:11:36','',''),(2633584,'1','179','933',413,'Retail Sale Id 1626273',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 14:12:42','',''),(2633585,'1','179','933',413,'Retail Sale Id 1626274',1998.00,0.00,0.00,3.33,276.39,'2022-02-11 14:13:42','',''),(2633586,'1','179','933',413,'Retail Sale Id 1626275',1002.00,0.00,0.00,1.67,138.61,'2022-02-11 14:27:16','',''),(2633587,'1','179','933',413,'Retail Sale Id 1626276',1500.00,0.00,0.00,2.50,207.50,'2022-02-11 14:30:40','',''),(2633588,'1','179','933',413,'Retail Sale Id 1626277',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 14:41:25','',''),(2633589,'1','179','933',413,'Retail Sale Id 1626278',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 14:42:33','',''),(2633590,'1','179','933',413,'Retail Sale Id 1626279',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 14:48:15','',''),(2633591,'1','179','933',413,'Retail Sale Id 1626280',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 15:07:30','',''),(2633592,'1','179','933',413,'Retail Sale Id 1626281',1500.00,0.00,0.00,2.50,207.50,'2022-02-11 15:15:56','',''),(2633593,'1','179','933',413,'Retail Sale Id 1626282',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 15:22:47','',''),(2633594,'1','179','933',413,'Retail Sale Id 1626283',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 15:34:48','',''),(2633595,'1','179','933',413,'Retail Sale Id 1626284',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 15:43:51','',''),(2633596,'1','179','933',413,'Retail Sale Id 1626285',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 15:57:08','',''),(2633597,'1','179','933',413,'Retail Sale Id 1626286',30000.00,0.00,0.00,50.00,4150.00,'2022-02-11 16:23:42','',''),(2633598,'1','179','933',413,'Retail Sale Id 1626287',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 16:42:20','',''),(2633599,'1','179','933',413,'Return of Retail Sale Id 1626286',0.00,30000.00,50.00,0.00,-4150.00,'2022-02-11 16:43:06','',''),(2633600,'1','179','933',413,'Retail Sale Id 1626288',30000.00,0.00,0.00,50.00,4150.00,'2022-02-11 16:43:48','',''),(2633601,'1','179','933',413,'Retail Sale Id 1626289',3000.00,0.00,0.00,5.00,415.00,'2022-02-11 17:03:55','',''),(2633602,'1','179','933',413,'Retail Sale Id 1626290',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 18:14:48','',''),(2633603,'1','179','933',413,'Retail Sale Id 1626291',6000.00,0.00,0.00,10.00,830.00,'2022-02-11 18:22:39','',''),(2633604,'1','179','933',413,'Retail Sale Id 1626292',5400.00,0.00,0.00,9.00,747.00,'2022-02-11 18:27:36','',''),(2633605,'1','179','933',413,'Retail Sale Id 1626293',2400.00,0.00,0.00,4.00,332.00,'2022-02-11 18:48:32','',''),(2633606,'1','179','933',413,'Retail Sale Id 1626294',4002.00,0.00,0.00,6.67,553.61,'2022-02-11 18:50:28','',''),(2633607,'1','179','933',413,'Retail Sale Id 1626295',1800.00,0.00,0.00,3.00,249.00,'2022-02-11 18:51:17','',''),(2633608,'1','179','933',413,'Retail Sale Id 1626296',3600.00,0.00,0.00,6.00,498.00,'2022-02-11 19:23:13','',''),(2633609,'1','179','933',413,'Retail Sale Id 1626297',7500.00,0.00,0.00,12.50,1037.50,'2022-02-12 08:47:57','',''),(2633610,'1','179','933',413,'Retail Sale Id 1626298',11502.00,0.00,0.00,19.17,1591.11,'2022-02-12 08:48:48','',''),(2633611,'1','179','933',413,'Retail Sale Id 1626299',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 09:27:32','',''),(2633612,'1','179','933',413,'Retail Sale Id 1626300',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 09:55:33','',''),(2633613,'1','179','933',413,'Retail Sale Id 1626301',3000.00,0.00,0.00,5.00,415.00,'2022-02-12 10:14:17','',''),(2633614,'1','179','933',413,'Retail Sale Id 1626302',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 10:35:53','',''),(2633615,'1','179','933',413,'Retail Sale Id 1626303',7500.00,0.00,0.00,12.50,1037.50,'2022-02-12 10:36:29','',''),(2633616,'1','179','933',413,'Retail Sale Id 1626304',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 10:53:32','',''),(2633617,'1','179','933',413,'Retail Sale Id 1626305',1800.00,0.00,0.00,3.00,249.00,'2022-02-12 11:02:04','',''),(2633618,'1','179','933',413,'Retail Sale Id 1626306',1998.00,0.00,0.00,3.33,276.39,'2022-02-12 11:02:52','',''),(2633619,'1','179','933',413,'Return of Retail Sale Id 1626306',0.00,1998.00,3.33,0.00,-276.39,'2022-02-12 11:24:50','',''),(2633620,'1','179','933',413,'Return of Retail Sale Id 1626305',0.00,1800.00,3.00,0.00,-249.00,'2022-02-12 11:25:16','',''),(2633621,'1','179','933',413,'Retail Sale Id 1626307',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 17:42:24','',''),(2633622,'1','179','933',413,'Retail Sale Id 1626308',4200.00,0.00,0.00,7.00,581.00,'2022-02-12 17:43:37','',''),(2633623,'1','179','933',413,'Return of Retail Sale Id 1626308',0.00,4200.00,7.00,0.00,-581.00,'2022-02-12 17:52:35','',''),(2633624,'1','179','933',413,'Retail Sale Id 1626309',4200.00,0.00,0.00,7.00,581.00,'2022-02-12 17:53:26','',''),(2633625,'1','179','933',413,'Retail Sale Id 1626310',3000.00,0.00,0.00,5.00,415.00,'2022-02-12 18:04:25','',''),(2633626,'1','179','933',413,'Retail Sale Id 1626311',7500.00,0.00,0.00,12.50,1037.50,'2022-02-12 18:11:40','',''),(2633627,'1','179','933',413,'Retail Sale Id 1626312',3600.00,0.00,0.00,6.00,498.00,'2022-02-12 18:20:55','',''),(2633628,'1','179','933',413,'Retail Sale Id 1626313',1200.00,0.00,0.00,2.00,166.00,'2022-02-12 18:51:00','',''),(2633629,'1','179','933',413,'Retail Sale Id 1626314',3750.00,0.00,0.00,6.25,518.75,'2022-02-12 18:52:04','',''),(2633630,'1','179','933',413,'Retail Sale Id 1626315',2400.00,0.00,0.00,4.00,332.00,'2022-02-12 18:54:22','',''),(2633631,'1','179','933',413,'Retail Sale Id 1626316',798.00,0.00,0.00,1.33,110.39,'2022-02-12 19:10:00','',''),(2633632,'1','179','933',413,'Retail Sale Id 1626317',1332.00,0.00,0.00,2.22,184.26,'2022-02-12 19:27:16','',''),(2633633,'1','179','933',413,'Retail Sale Id 1626318',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 08:05:06','',''),(2633634,'1','179','933',413,'Retail Sale Id 1626319',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 08:41:12','',''),(2633635,'1','179','933',413,'Retail Sale Id 1626320',4998.00,0.00,0.00,8.33,691.39,'2022-02-13 08:52:19','',''),(2633636,'1','179','933',413,'Retail Sale Id 1626321',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 08:54:10','',''),(2633637,'1','179','933',413,'Retail Sale Id 1626322',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 09:13:38','',''),(2633638,'1','179','933',413,'Retail Sale Id 1626323',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 09:25:37','',''),(2633639,'1','179','933',413,'Retail Sale Id 1626324',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 09:35:14','',''),(2633640,'1','179','933',413,'Retail Sale Id 1626325',2400.00,0.00,0.00,4.00,332.00,'2022-02-13 09:39:09','',''),(2633641,'1','179','933',413,'Retail Sale Id 1626326',6000.00,0.00,0.00,10.00,830.00,'2022-02-13 09:45:16','',''),(2633642,'1','179','933',413,'Retail Sale Id 1626327',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 10:21:59','',''),(2633643,'1','179','933',413,'Retail Sale Id 1626328',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 10:44:08','',''),(2633644,'1','179','933',413,'Retail Sale Id 1626329',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 10:58:17','',''),(2633645,'1','179','933',413,'Retail Sale Id 1626330',600.00,0.00,0.00,1.00,83.00,'2022-02-13 11:07:39','',''),(2633646,'1','179','933',413,'Retail Sale Id 1626331',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 11:09:32','',''),(2633647,'1','179','933',413,'Retail Sale Id 1626332',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 11:22:28','',''),(2633648,'1','179','933',413,'Retail Sale Id 1626333',2502.00,0.00,0.00,4.17,346.11,'2022-02-13 11:48:33','',''),(2633649,'1','179','933',413,'Retail Sale Id 1626334',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 11:50:06','',''),(2633650,'1','179','933',413,'Retail Sale Id 1626335',1998.00,0.00,0.00,3.33,276.39,'2022-02-13 11:55:31','',''),(2633651,'1','179','933',413,'Retail Sale Id 1626336',6000.00,0.00,0.00,10.00,830.00,'2022-02-13 11:56:38','',''),(2633652,'1','179','933',413,'Retail Sale Id 1626337',1998.00,0.00,0.00,3.33,276.39,'2022-02-13 12:11:39','',''),(2633653,'1','179','933',413,'Retail Sale Id 1626338',2502.00,0.00,0.00,4.17,346.11,'2022-02-13 12:24:29','',''),(2633654,'1','179','933',413,'Retail Sale Id 1626339',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 12:29:00','',''),(2633655,'1','179','933',413,'Retail Sale Id 1626340',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 12:32:25','',''),(2633656,'1','179','933',413,'Retail Sale Id 1626341',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 12:33:40','',''),(2633657,'1','179','933',413,'Retail Sale Id 1626342',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 12:46:12','',''),(2633658,'1','179','933',413,'Retail Sale Id 1626343',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 13:04:17','',''),(2633659,'1','179','933',413,'Retail Sale Id 1626344',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 13:05:22','',''),(2633660,'1','179','933',413,'Retail Sale Id 1626345',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 13:06:35','',''),(2633661,'1','179','933',413,'Retail Sale Id 1626346',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 13:10:59','',''),(2633662,'1','179','933',413,'Retail Sale Id 1626347',13500.00,0.00,0.00,22.50,1867.50,'2022-02-13 13:17:27','',''),(2633663,'1','179','933',413,'Retail Sale Id 1626348',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 13:21:03','',''),(2633664,'1','179','933',413,'Retail Sale Id 1626349',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 13:22:06','',''),(2633665,'1','179','933',413,'Retail Sale Id 1626350',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 13:23:11','',''),(2633666,'1','179','933',413,'Retail Sale Id 1626351',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 13:40:20','',''),(2633667,'1','179','933',413,'Retail Sale Id 1626352',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 14:02:01','',''),(2633668,'1','179','933',413,'Retail Sale Id 1626353',1998.00,0.00,0.00,3.33,276.39,'2022-02-13 14:20:01','',''),(2633669,'1','179','933',413,'Retail Sale Id 1626354',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 14:32:02','',''),(2633670,'1','179','933',413,'Retail Sale Id 1626355',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 14:32:36','',''),(2633671,'1','179','933',413,'Retail Sale Id 1626356',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 14:39:32','',''),(2633672,'1','179','933',413,'Retail Sale Id 1626357',1998.00,0.00,0.00,3.33,276.39,'2022-02-13 15:29:02','',''),(2633673,'1','179','933',413,'Retail Sale Id 1626358',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 15:32:08','',''),(2633674,'1','179','933',413,'Retail Sale Id 1626359',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 15:36:57','',''),(2633675,'1','179','933',413,'Retail Sale Id 1626360',2400.00,0.00,0.00,4.00,332.00,'2022-02-13 15:51:47','',''),(2633676,'1','179','933',413,'Retail Sale Id 1626361',1602.00,0.00,0.00,2.67,221.61,'2022-02-13 15:53:29','',''),(2633677,'1','179','933',413,'Retail Sale Id 1626362',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 16:00:53','',''),(2633678,'1','179','933',413,'Retail Sale Id 1626363',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 16:29:27','',''),(2633679,'1','179','933',413,'Retail Sale Id 1626364',1998.00,0.00,0.00,3.33,276.39,'2022-02-13 16:36:02','',''),(2633680,'1','179','933',413,'Retail Sale Id 1626365',3498.00,0.00,0.00,5.83,483.89,'2022-02-13 16:37:02','',''),(2633681,'1','179','933',413,'Retail Sale Id 1626366',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 16:47:13','',''),(2633682,'1','179','933',413,'Retail Sale Id 1626367',1500.00,0.00,0.00,2.50,207.50,'2022-02-13 16:59:10','',''),(2633683,'1','179','933',413,'Retail Sale Id 1626368',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 17:20:25','',''),(2633684,'1','179','933',413,'Retail Sale Id 1626369',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 17:30:32','',''),(2633685,'1','179','933',413,'Retail Sale Id 1626370',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 17:32:36','',''),(2633686,'1','179','933',413,'Retail Sale Id 1626371',3000.00,0.00,0.00,5.00,415.00,'2022-02-13 17:38:31','',''),(2633687,'1','179','933',413,'Retail Sale Id 1626372',7998.00,0.00,0.00,13.33,1106.39,'2022-02-13 17:41:40','',''),(2633688,'1','179','933',413,'Retail Sale Id 1626373',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 17:42:27','',''),(2633689,'1','179','933',413,'Retail Sale Id 1626374',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 17:45:31','',''),(2633690,'1','179','933',413,'Retail Sale Id 1626375',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 17:46:38','',''),(2633691,'1','179','933',413,'Retail Sale Id 1626376',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 17:57:11','',''),(2633692,'1','179','933',413,'Retail Sale Id 1626377',1800.00,0.00,0.00,3.00,249.00,'2022-02-13 18:05:18','',''),(2633693,'1','179','933',413,'Retail Sale Id 1626378',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 18:10:28','',''),(2633694,'1','179','933',413,'Retail Sale Id 1626379',6000.00,0.00,0.00,10.00,830.00,'2022-02-13 18:15:08','',''),(2633695,'1','179','933',413,'Retail Sale Id 1626380',6000.00,0.00,0.00,10.00,830.00,'2022-02-13 18:18:15','',''),(2633696,'1','179','933',413,'Retail Sale Id 1626381',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 18:21:30','',''),(2633697,'1','179','933',413,'Retail Sale Id 1626382',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 18:33:52','',''),(2633698,'1','179','933',413,'Retail Sale Id 1626383',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 18:53:42','',''),(2633699,'1','179','933',413,'Retail Sale Id 1626384',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 18:58:17','',''),(2633700,'1','179','933',413,'Retail Sale Id 1626385',3600.00,0.00,0.00,6.00,498.00,'2022-02-13 18:58:48','',''),(2633701,'1','179','933',413,'Return of Retail Sale Id 1626382',0.00,1002.00,1.67,0.00,-138.61,'2022-02-13 19:18:43','',''),(2633702,'1','179','933',413,'Return of Retail Sale Id 1626381',0.00,1002.00,1.67,0.00,-138.61,'2022-02-13 19:19:36','',''),(2633703,'1','179','933',413,'Retail Sale Id 1626386',1998.00,0.00,0.00,3.33,276.39,'2022-02-13 19:20:09','',''),(2633704,'1','179','933',413,'Return of Retail Sale Id 1626386',0.00,1998.00,3.33,0.00,-276.39,'2022-02-13 19:22:05','',''),(2633705,'1','179','933',413,'Retail Sale Id 1626387',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 19:22:40','',''),(2633706,'1','179','933',413,'Retail Sale Id 1626388',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 19:23:09','',''),(2633707,'1','179','933',413,'Return of Retail Sale Id 1626388',0.00,1002.00,1.67,0.00,-138.61,'2022-02-13 19:26:50','',''),(2633708,'1','179','933',413,'Retail Sale Id 1626389',1002.00,0.00,0.00,1.67,138.61,'2022-02-13 19:28:36','',''),(2633709,'1','179','933',413,'Return of Retail Sale Id 1626365',0.00,3498.00,5.83,0.00,-483.89,'2022-02-13 19:31:40','',''),(2633710,'1','179','933',413,'Retail Sale Id 1626390',3498.00,0.00,0.00,5.83,483.89,'2022-02-13 19:32:28','',''),(2633711,'1','179','933',413,'Return of Retail Sale Id 1626389',0.00,1002.00,1.67,0.00,-138.61,'2022-02-13 19:39:33','',''),(2633712,'1','179','933',413,'Retail Sale Id 1626391',984.00,0.00,0.00,1.64,136.12,'2022-02-13 19:40:33','',''),(2633713,'1','179','933',413,'Return of Retail Sale Id 1626391',0.00,984.00,1.64,0.00,-136.12,'2022-02-13 19:43:42','',''),(2633714,'1','179','933',413,'Retail Sale Id 1626392',822.00,0.00,0.00,1.37,113.71,'2022-02-13 19:45:49','',''),(2633715,'1','179','933',413,'Retail Sale Id 1626393',36.00,0.00,0.00,0.06,4.98,'2022-02-13 19:48:01','',''),(2633716,'1','179','933',413,'Retail Sale Id 1626394',1200.00,0.00,0.00,2.00,166.00,'2022-02-13 19:53:27','',''),(2633717,'1','179','933',413,'Retail Sale Id 1626395',7500.00,0.00,0.00,12.50,1037.50,'2022-02-13 19:54:00','',''),(2633718,'1','179','933',413,'Retail Sale Id 1626396',6798.00,0.00,0.00,11.33,940.39,'2022-02-14 08:05:44','',''),(2633719,'1','179','933',413,'Retail Sale Id 1626397',3798.00,0.00,0.00,6.33,525.39,'2022-02-14 09:13:07','',''),(2633720,'1','179','933',413,'Return of Retail Sale Id 1626397',0.00,3798.00,6.33,0.00,-525.39,'2022-02-14 09:52:51','',''),(2633721,'1','179','933',413,'Return of Retail Sale Id 1626396',0.00,6798.00,11.33,0.00,-940.39,'2022-02-14 09:53:31','',''),(2633722,'1','179','933',413,'Retail Sale Id 1626398',41935.44,0.00,0.00,73.83,41935.44,'2022-02-14 10:48:16','',''),(2633723,'1','179','933',413,'Retail Sale Id 1626399',42503.44,0.00,0.00,74.83,42503.44,'2022-02-14 10:49:14','',''),(2633724,'1','179','933',413,'Retail Sale Id 1626400',1704.00,0.00,0.00,3.00,1704.00,'2022-02-14 10:58:48','',''),(2633725,'1','179','933',413,'Retail Sale Id 1626401',3408.00,0.00,0.00,6.00,3408.00,'2022-02-14 11:15:18','',''),(2633726,'1','179','933',413,'Retail Sale Id 1626402',3158.08,0.00,0.00,5.56,3158.08,'2022-02-14 11:17:38','',''),(2633727,'1','179','933',413,'Retail Sale Id 1626403',1499.52,0.00,0.00,2.64,1499.52,'2022-02-14 11:39:34','',''),(2633728,'1','179','933',413,'Retail Sale Id 1626404',1101.92,0.00,0.00,1.94,1101.92,'2022-02-14 12:12:33','',''),(2633729,'1','179','933',413,'Retail Sale Id 1626405',13160.56,0.00,0.00,23.17,13160.56,'2022-02-14 13:34:35','',''),(2633730,'1','179','933',413,'Retail Sale Id 1626406',6816.00,0.00,0.00,12.00,6816.00,'2022-02-14 14:24:07','',''),(2633731,'1','179','933',413,'Retail Sale Id 1626407',17704.56,0.00,0.00,31.17,17704.56,'2022-02-14 15:48:41','',''),(2633732,'1','179','933',413,'Retail Sale Id 1626408',9940.00,0.00,0.00,17.50,9940.00,'2022-02-14 15:49:36','',''),(2633733,'1','179','933',413,'Retail Sale Id 1626409',1891.44,0.00,0.00,3.33,1891.44,'2022-02-14 16:26:02','',''),(2633734,'1','179','933',413,'Retail Sale Id 1626410',2840.00,0.00,0.00,5.00,2840.00,'2022-02-14 16:26:37','',''),(2633735,'1','179','933',413,'Retail Sale Id 1626411',20164.00,0.00,0.00,35.50,20164.00,'2022-02-14 17:19:09','',''),(2633736,'1','179','933',413,'Retail Sale Id 1626412',7952.00,0.00,0.00,14.00,7952.00,'2022-02-14 17:20:59','',''),(2633737,'1','179','933',413,'Retail Sale Id 1626414',56.80,0.00,0.00,0.10,56.80,'2022-02-14 17:23:32','',''),(2633738,'1','179','933',413,'Retail Sale Id 1626415',10224.00,0.00,0.00,18.00,10224.00,'2022-02-14 18:13:23','',''),(2633739,'1','179','933',413,'Retail Sale Id 1626416',5680.00,0.00,0.00,10.00,5680.00,'2022-02-14 18:14:08','',''),(2633740,'1','179','933',413,'Retail Sale Id 1626417',16472.00,0.00,0.00,29.00,16472.00,'2022-02-14 18:15:43','',''),(2633741,'1','179','933',413,'Retail Sale Id 1626418',3976.00,0.00,0.00,7.00,3976.00,'2022-02-14 18:16:51','',''),(2633742,'1','179','933',413,'Retail Sale Id 1626419',4260.00,0.00,0.00,7.50,4260.00,'2022-02-14 18:48:38','',''),(2633743,'1','179','933',413,'Return of Retail Sale Id 1626419',0.00,4260.00,7.50,0.00,-4260.00,'2022-02-14 19:11:56','',''),(2633744,'1','179','933',413,'Retail Sale Id 1626420',4237.28,0.00,0.00,7.46,4237.28,'2022-02-14 19:12:48','',''),(2633745,'1','179','933',413,'Retail Sale Id 1626421',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 08:22:21','',''),(2633746,'1','179','933',413,'Retail Sale Id 1626422',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 08:40:03','',''),(2633747,'1','179','933',413,'Retail Sale Id 1626423',7100.00,0.00,0.00,12.50,7100.00,'2022-02-15 08:40:37','',''),(2633748,'1','179','933',413,'Retail Sale Id 1626424',8804.00,0.00,0.00,15.50,8804.00,'2022-02-15 08:41:23','',''),(2633749,'1','179','933',413,'Retail Sale Id 1626425',1420.00,0.00,0.00,2.50,1420.00,'2022-02-15 08:56:01','',''),(2633750,'1','179','933',413,'Retail Sale Id 1626426',1704.00,0.00,0.00,3.00,1704.00,'2022-02-15 09:17:17','',''),(2633751,'1','179','933',413,'Retail Sale Id 1626427',3550.00,0.00,0.00,6.25,3550.00,'2022-02-15 10:09:18','',''),(2633752,'1','179','933',413,'Retail Sale Id 1626428',7100.00,0.00,0.00,12.50,7100.00,'2022-02-15 10:36:15','',''),(2633753,'1','179','933',413,'Retail Sale Id 1626429',4447.44,0.00,0.00,7.83,4447.44,'2022-02-15 10:37:21','',''),(2633754,'1','179','933',413,'Retail Sale Id 1626430',4544.00,0.00,0.00,8.00,4544.00,'2022-02-15 10:51:19','',''),(2633755,'1','179','933',413,'Retail Sale Id 1626431',7100.00,0.00,0.00,12.50,7100.00,'2022-02-15 11:02:22','',''),(2633756,'1','179','933',413,'Retail Sale Id 1626432',1704.00,0.00,0.00,3.00,1704.00,'2022-02-15 11:24:43','',''),(2633757,'1','179','933',413,'Retail Sale Id 1626433',1136.00,0.00,0.00,2.00,1136.00,'2022-02-15 12:05:31','',''),(2633758,'1','179','933',413,'Retail Sale Id 1626434',4731.44,0.00,0.00,8.33,4731.44,'2022-02-15 12:05:58','',''),(2633759,'1','179','933',413,'Retail Sale Id 1626435',1891.44,0.00,0.00,3.33,1891.44,'2022-02-15 13:36:51','',''),(2633760,'1','179','933',413,'Retail Sale Id 1626436',9372.00,0.00,0.00,16.50,9372.00,'2022-02-15 13:37:38','',''),(2633761,'1','179','933',413,'Retail Sale Id 1626437',1704.00,0.00,0.00,3.00,1704.00,'2022-02-15 13:54:25','',''),(2633762,'1','179','933',413,'Retail Sale Id 1626438',8804.00,0.00,0.00,15.50,8804.00,'2022-02-15 14:24:43','',''),(2633763,'1','179','933',413,'Retail Sale Id 1626439',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 14:35:56','',''),(2633764,'1','179','933',413,'Retail Sale Id 1626440',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 14:50:13','',''),(2633765,'1','179','933',413,'Retail Sale Id 1626441',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 15:27:37','',''),(2633766,'1','179','933',413,'Retail Sale Id 1626442',2652.56,0.00,0.00,4.67,2652.56,'2022-02-15 16:41:54','',''),(2633767,'1','179','933',413,'Retail Sale Id 1626443',4924.56,0.00,0.00,8.67,4924.56,'2022-02-15 17:09:35','',''),(2633768,'1','179','933',413,'Retail Sale Id 1626444',1704.00,0.00,0.00,3.00,1704.00,'2022-02-15 17:21:46','',''),(2633769,'1','179','933',413,'Retail Sale Id 1626445',7100.00,0.00,0.00,12.50,7100.00,'2022-02-15 17:44:04','',''),(2633770,'1','179','933',413,'Retail Sale Id 1626446',1891.44,0.00,0.00,3.33,1891.44,'2022-02-15 17:51:19','',''),(2633771,'1','179','933',413,'Retail Sale Id 1626447',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 18:09:14','',''),(2633772,'1','179','933',413,'Retail Sale Id 1626448',8804.00,0.00,0.00,15.50,8804.00,'2022-02-15 18:09:53','',''),(2633773,'1','179','933',413,'Retail Sale Id 1626449',3408.00,0.00,0.00,6.00,3408.00,'2022-02-15 18:21:50','',''),(2633774,'1','179','933',413,'Retail Sale Id 1626450',1704.00,0.00,0.00,3.00,1704.00,'2022-02-15 18:37:08','',''),(2633775,'1','179','933',413,'Retail Sale Id 1626451',2840.00,0.00,0.00,5.00,2840.00,'2022-02-15 18:38:41','',''),(2633776,'1','179','933',413,'Retail Sale Id 1626452',9372.00,0.00,0.00,16.50,9372.00,'2022-02-15 19:12:11','',''),(2633777,'1','179','933',413,'Retail Sale Id 1626453',8804.00,0.00,0.00,15.50,8804.00,'2022-02-15 19:12:53','',''),(2633778,'1','179','933',413,'Retail Sale Id 1626454',1891.44,0.00,0.00,3.33,1891.44,'2022-02-15 19:35:38','',''),(2633779,'1','179','933',413,'Retail Sale Id 1626455',28400.00,0.00,0.00,50.00,28400.00,'2022-02-15 19:36:15','',''),(2633780,'1','179','933',413,'Retail Sale Id 1626456',14200.00,0.00,0.00,25.00,14200.00,'2022-02-16 08:57:58','',''),(2633781,'1','179','933',413,'Retail Sale Id 1626457',948.56,0.00,0.00,1.67,948.56,'2022-02-16 08:58:34','',''),(2633782,'1','179','933',413,'Retail Sale Id 1626458',10508.00,0.00,0.00,18.50,10508.00,'2022-02-16 08:59:11','',''),(2633783,'1','179','933',413,'Retail Sale Id 1626459',2840.00,0.00,0.00,5.00,2840.00,'2022-02-16 09:19:02','',''),(2633784,'1','179','933',413,'Retail Sale Id 1626460',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 09:52:19','',''),(2633785,'1','179','933',413,'Retail Sale Id 1626461',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 10:08:16','',''),(2633786,'1','179','933',413,'Retail Sale Id 1626462',3998.72,0.00,0.00,7.04,3998.72,'2022-02-16 10:23:34','',''),(2633787,'1','179','933',413,'Retail Sale Id 1626463',2999.04,0.00,0.00,5.28,2999.04,'2022-02-16 10:55:45','',''),(2633788,'1','179','933',413,'Retail Sale Id 1626464',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 10:59:41','',''),(2633789,'1','179','933',413,'Retail Sale Id 1626465',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 11:16:53','',''),(2633790,'1','179','933',413,'Retail Sale Id 1626466',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 12:14:14','',''),(2633791,'1','179','933',413,'Retail Sale Id 1626467',1999.36,0.00,0.00,3.52,1999.36,'2022-02-16 12:30:15','',''),(2633792,'1','179','933',413,'Retail Sale Id 1626468',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 12:38:04','',''),(2633793,'1','179','933',413,'Retail Sale Id 1626470',2272.00,0.00,0.00,4.00,2272.00,'2022-02-16 13:13:25','',''),(2633794,'1','179','933',413,'Retail Sale Id 1626471',2499.20,0.00,0.00,4.40,2499.20,'2022-02-16 13:24:53','',''),(2633795,'1','179','933',413,'Retail Sale Id 1626472',1698.32,0.00,0.00,2.99,1698.32,'2022-02-16 13:27:46','',''),(2633796,'1','179','933',413,'Retail Sale Id 1626473',1136.00,0.00,0.00,2.00,1136.00,'2022-02-16 13:29:33','',''),(2633797,'1','179','933',413,'Return of Retail Sale Id 1626472',0.00,1698.32,2.99,0.00,-1698.32,'2022-02-16 13:31:01','',''),(2633798,'1','179','933',413,'Retail Sale Id 1626474',1704.00,0.00,0.00,3.00,1704.00,'2022-02-16 13:31:32','',''),(2633799,'1','179','933',413,'Retail Sale Id 1626475',3498.88,0.00,0.00,6.16,3498.88,'2022-02-16 13:33:55','',''),(2633800,'1','179','933',413,'Retail Sale Id 1626476',2840.00,0.00,0.00,5.00,2840.00,'2022-02-16 13:41:09','',''),(2633801,'1','179','933',413,'Retail Sale Id 1626477',1999.36,0.00,0.00,3.52,1999.36,'2022-02-16 14:48:23','',''),(2633802,'1','179','933',413,'Retail Sale Id 1626478',1999.36,0.00,0.00,3.52,1999.36,'2022-02-16 14:49:05','',''),(2633803,'1','179','933',413,'Retail Sale Id 1626479',7100.00,0.00,0.00,12.50,7100.00,'2022-02-16 15:04:40','',''),(2633804,'1','179','933',413,'Retail Sale Id 1626480',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 15:06:36','',''),(2633805,'1','179','933',413,'Retail Sale Id 1626482',7100.00,0.00,0.00,12.50,7100.00,'2022-02-16 15:19:45','',''),(2633806,'1','179','933',413,'Retail Sale Id 1626483',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 15:21:24','',''),(2633807,'1','179','933',413,'Retail Sale Id 1626484',5998.08,0.00,0.00,10.56,5998.08,'2022-02-16 15:33:37','',''),(2633808,'1','179','933',413,'Retail Sale Id 1626485',2999.04,0.00,0.00,5.28,2999.04,'2022-02-16 15:42:47','',''),(2633809,'1','179','933',413,'Retail Sale Id 1626486',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 15:50:04','',''),(2633810,'1','179','933',413,'Retail Sale Id 1626487',2999.04,0.00,0.00,5.28,2999.04,'2022-02-16 16:16:33','',''),(2633811,'1','179','933',413,'Retail Sale Id 1626488',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 16:30:15','',''),(2633812,'1','179','933',413,'Retail Sale Id 1626489',1999.36,0.00,0.00,3.52,1999.36,'2022-02-16 16:45:18','',''),(2633813,'1','179','933',413,'Retail Sale Id 1626490',1198.48,0.00,0.00,2.11,1198.48,'2022-02-16 16:58:40','',''),(2633814,'1','179','933',413,'Retail Sale Id 1626491',5112.00,0.00,0.00,9.00,5112.00,'2022-02-16 17:04:28','',''),(2633815,'1','179','933',413,'Retail Sale Id 1626492',7100.00,0.00,0.00,12.50,7100.00,'2022-02-16 17:12:25','',''),(2633816,'1','179','933',413,'Retail Sale Id 1626493',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 17:13:43','',''),(2633817,'1','179','933',413,'Retail Sale Id 1626494',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 17:15:59','',''),(2633818,'1','179','933',413,'Return of Retail Sale Id 1626492',0.00,7100.00,12.50,0.00,-7100.00,'2022-02-16 17:17:02','',''),(2633819,'1','179','933',413,'Retail Sale Id 1626495',7100.00,0.00,0.00,12.50,7100.00,'2022-02-16 17:17:34','',''),(2633820,'1','179','933',413,'Retail Sale Id 1626496',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 17:17:59','',''),(2633821,'1','179','933',413,'Retail Sale Id 1626497',4998.40,0.00,0.00,8.80,4998.40,'2022-02-16 17:27:08','',''),(2633822,'1','179','933',413,'Return of Retail Sale Id 1626497',0.00,4998.40,8.80,0.00,-4998.40,'2022-02-16 17:27:34','',''),(2633823,'1','179','933',413,'Retail Sale Id 1626498',5998.08,0.00,0.00,10.56,5998.08,'2022-02-16 17:28:14','',''),(2633824,'1','179','933',413,'Retail Sale Id 1626499',7100.00,0.00,0.00,12.50,7100.00,'2022-02-16 17:37:45','',''),(2633825,'1','179','933',413,'Retail Sale Id 1626500',2840.00,0.00,0.00,5.00,2840.00,'2022-02-16 17:38:11','',''),(2633826,'1','179','933',413,'Retail Sale Id 1626501',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 17:44:12','',''),(2633827,'1','179','933',413,'Retail Sale Id 1626502',897.44,0.00,0.00,1.58,897.44,'2022-02-16 17:48:14','',''),(2633828,'1','179','933',413,'Retail Sale Id 1626503',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 18:03:30','',''),(2633829,'1','179','933',413,'Retail Sale Id 1626504',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 18:10:16','',''),(2633830,'1','179','933',413,'Retail Sale Id 1626505',999.68,0.00,0.00,1.76,999.68,'2022-02-16 18:27:17','',''),(2633831,'1','179','933',413,'Retail Sale Id 1626506',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 18:40:23','',''),(2633832,'1','179','933',413,'Retail Sale Id 1626507',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 19:08:55','',''),(2633833,'1','179','933',413,'Retail Sale Id 1626509',1749.44,0.00,0.00,3.08,1749.44,'2022-02-16 19:13:00','',''),(2633834,'1','179','933',413,'Retail Sale Id 1626510',3408.00,0.00,0.00,6.00,3408.00,'2022-02-16 19:14:21','',''),(2633835,'1','179','933',413,'Retail Sale Id 1626511',999.68,0.00,0.00,1.76,999.68,'2022-02-16 19:31:34','',''),(2633836,'1','179','933',413,'Retail Sale Id 1626512',1397.28,0.00,0.00,2.46,1397.28,'2022-02-16 19:35:53','',''),(2633837,'1','179','933',413,'Retail Sale Id 1626513',999.68,0.00,0.00,1.76,999.68,'2022-02-17 08:28:18','',''),(2633838,'1','179','933',413,'Retail Sale Id 1626514',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 08:29:05','',''),(2633839,'1','179','933',413,'Retail Sale Id 1626515',2999.04,0.00,0.00,5.28,2999.04,'2022-02-17 08:30:16','',''),(2633840,'1','179','933',413,'Retail Sale Id 1626516',2840.00,0.00,0.00,5.00,2840.00,'2022-02-17 08:34:08','',''),(2633841,'1','179','933',413,'Retail Sale Id 1626518',2272.00,0.00,0.00,4.00,2272.00,'2022-02-17 09:03:44','',''),(2633842,'1','179','933',413,'Retail Sale Id 1626519',1749.44,0.00,0.00,3.08,1749.44,'2022-02-17 09:04:50','',''),(2633843,'1','179','933',413,'Retail Sale Id 1626520',1999.36,0.00,0.00,3.52,1999.36,'2022-02-17 09:19:03','',''),(2633844,'1','179','933',413,'Retail Sale Id 1626521',1749.44,0.00,0.00,3.08,1749.44,'2022-02-17 09:45:58','',''),(2633845,'1','179','933',413,'Retail Sale Id 1626522',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 09:49:49','',''),(2633846,'1','179','933',413,'Retail Sale Id 1626523',7100.00,0.00,0.00,12.50,7100.00,'2022-02-17 10:27:03','',''),(2633847,'1','179','933',413,'Retail Sale Id 1626524',999.68,0.00,0.00,1.76,999.68,'2022-02-17 10:49:40','',''),(2633848,'1','179','933',413,'Retail Sale Id 1626525',1999.36,0.00,0.00,3.52,1999.36,'2022-02-17 11:16:21','',''),(2633849,'1','179','933',413,'Retail Sale Id 1626526',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 11:31:37','',''),(2633850,'1','179','933',413,'Retail Sale Id 1626527',999.68,0.00,0.00,1.76,999.68,'2022-02-17 11:32:51','',''),(2633851,'1','179','933',413,'Retail Sale Id 1626528',7100.00,0.00,0.00,12.50,7100.00,'2022-02-17 11:39:57','',''),(2633852,'1','179','933',413,'Retail Sale Id 1626529',1749.44,0.00,0.00,3.08,1749.44,'2022-02-17 12:17:47','',''),(2633853,'1','179','933',413,'Retail Sale Id 1626530',1749.44,0.00,0.00,3.08,1749.44,'2022-02-17 12:39:13','',''),(2633854,'1','179','933',413,'Retail Sale Id 1626531',1749.44,0.00,0.00,3.08,1749.44,'2022-02-17 14:36:16','',''),(2633855,'1','179','933',413,'Retail Sale Id 1626532',2840.00,0.00,0.00,5.00,2840.00,'2022-02-17 14:37:03','',''),(2633856,'1','179','933',413,'Return of Retail Sale Id 1626532',0.00,2840.00,5.00,0.00,-2840.00,'2022-02-17 15:02:31','',''),(2633857,'1','179','933',413,'Retail Sale Id 1626533',2840.00,0.00,0.00,5.00,2840.00,'2022-02-17 15:03:12','',''),(2633858,'1','179','933',413,'Retail Sale Id 1626534',8804.00,0.00,0.00,15.50,8804.00,'2022-02-17 15:04:11','',''),(2633859,'1','179','933',413,'Retail Sale Id 1626535',1999.36,0.00,0.00,3.52,1999.36,'2022-02-17 15:18:26','',''),(2633860,'1','179','933',413,'Retail Sale Id 1626536',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 15:22:01','',''),(2633861,'1','179','933',413,'Retail Sale Id 1626537',2300.40,0.00,0.00,4.05,2300.40,'2022-02-17 15:51:11','',''),(2633862,'1','179','933',413,'Retail Sale Id 1626538',2999.04,0.00,0.00,5.28,2999.04,'2022-02-17 16:41:14','',''),(2633863,'1','179','933',413,'Retail Sale Id 1626539',2272.00,0.00,0.00,4.00,2272.00,'2022-02-17 16:49:13','',''),(2633864,'1','179','933',413,'Retail Sale Id 1626540',7100.00,0.00,0.00,12.50,7100.00,'2022-02-17 16:51:04','',''),(2633865,'1','179','933',413,'Retail Sale Id 1626541',1499.52,0.00,0.00,2.64,1499.52,'2022-02-17 17:00:07','',''),(2633866,'1','179','933',413,'Retail Sale Id 1626542',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 17:27:39','',''),(2633867,'1','179','933',413,'Retail Sale Id 1626543',2272.00,0.00,0.00,4.00,2272.00,'2022-02-17 17:30:38','',''),(2633868,'1','179','933',413,'Retail Sale Id 1626544',1499.52,0.00,0.00,2.64,1499.52,'2022-02-17 17:35:01','',''),(2633869,'1','179','933',413,'Retail Sale Id 1626545',999.68,0.00,0.00,1.76,999.68,'2022-02-17 17:40:31','',''),(2633870,'1','179','933',413,'Retail Sale Id 1626546',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 17:41:19','',''),(2633871,'1','179','933',413,'Retail Sale Id 1626547',7100.00,0.00,0.00,12.50,7100.00,'2022-02-17 17:42:32','',''),(2633872,'1','179','933',413,'Retail Sale Id 1626548',1749.44,0.00,0.00,3.08,1749.44,'2022-02-17 17:46:43','',''),(2633873,'1','179','933',413,'Retail Sale Id 1626549',897.44,0.00,0.00,1.58,897.44,'2022-02-17 18:00:53','',''),(2633874,'1','179','933',413,'Retail Sale Id 1626550',7100.00,0.00,0.00,12.50,7100.00,'2022-02-17 18:01:47','',''),(2633875,'1','179','933',413,'Retail Sale Id 1626551',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 18:02:46','',''),(2633876,'1','179','933',413,'Retail Sale Id 1626552',2999.04,0.00,0.00,5.28,2999.04,'2022-02-17 18:07:44','',''),(2633877,'1','179','933',413,'Retail Sale Id 1626553',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 18:08:25','',''),(2633878,'1','179','933',413,'Retail Sale Id 1626554',1499.52,0.00,0.00,2.64,1499.52,'2022-02-17 18:16:28','',''),(2633879,'1','179','933',413,'Retail Sale Id 1626555',1999.36,0.00,0.00,3.52,1999.36,'2022-02-17 18:19:04','',''),(2633880,'1','179','933',413,'Retail Sale Id 1626556',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 18:30:00','',''),(2633881,'1','179','933',413,'Retail Sale Id 1626557',3408.00,0.00,0.00,6.00,3408.00,'2022-02-17 18:31:40','',''),(2633882,'1','179','933',413,'Retail Sale Id 1626558',3748.80,0.00,0.00,6.60,3748.80,'2022-02-17 19:21:30','',''),(2633883,'1','179','933',413,'Retail Sale Id 1626559',732.72,0.00,0.00,1.29,732.72,'2022-02-18 08:26:46','',''),(2633884,'1','179','933',413,'Retail Sale Id 1626560',45.44,0.00,0.00,0.08,45.44,'2022-02-18 08:27:27','',''),(2633885,'1','179','933',413,'Return of Retail Sale Id 1626547',0.00,7100.00,12.50,0.00,-7100.00,'2022-02-18 08:30:36','',''),(2633886,'1','179','933',413,'Return of Retail Sale Id 1626523',0.00,7100.00,12.50,0.00,-7100.00,'2022-02-18 08:35:28','',''),(2633887,'1','179','933',413,'Retail Sale Id 1626561',999.68,0.00,0.00,1.76,999.68,'2022-02-22 08:22:27','',''),(2633888,'1','179','933',413,'Retail Sale Id 1626562',999.68,0.00,0.00,1.76,999.68,'2022-02-22 08:45:42','',''),(2633889,'1','179','933',413,'Retail Sale Id 1626563',5112.00,0.00,0.00,9.00,5112.00,'2022-02-22 08:59:33','',''),(2633890,'1','179','933',413,'Retail Sale Id 1626564',1999.36,0.00,0.00,3.52,1999.36,'2022-02-22 09:03:04','',''),(2633891,'1','179','933',413,'Retail Sale Id 1626565',2300.40,0.00,0.00,4.05,2300.40,'2022-02-22 09:14:14','',''),(2633892,'1','179','933',413,'Retail Sale Id 1626566',1704.00,0.00,0.00,3.00,1704.00,'2022-02-22 09:22:39','',''),(2633893,'1','179','933',413,'Retail Sale Id 1626567',1136.00,0.00,0.00,2.00,1136.00,'2022-02-22 09:43:54','',''),(2633894,'1','179','933',413,'Retail Sale Id 1626568',4998.40,0.00,0.00,8.80,4998.40,'2022-02-22 09:47:25','',''),(2633895,'1','179','933',413,'Retail Sale Id 1626569',3408.00,0.00,0.00,6.00,3408.00,'2022-02-22 09:48:38','',''),(2633896,'1','179','933',413,'Retail Sale Id 1626570',3408.00,0.00,0.00,6.00,3408.00,'2022-02-22 10:00:19','',''),(2633897,'1','179','933',413,'Retail Sale Id 1626571',3408.00,0.00,0.00,6.00,3408.00,'2022-02-22 10:15:11','',''),(2633898,'1','179','933',413,'Retail Sale Id 1626572',3408.00,0.00,0.00,6.00,3408.00,'2022-02-22 10:26:38','',''),(2633899,'1','179','933',413,'Retail Sale Id 1626573',1704.00,0.00,0.00,3.00,1704.00,'2022-02-22 10:35:24','',''),(2633900,'1','179','933',413,'Retail Sale Id 1626574',2840.00,0.00,0.00,5.00,2840.00,'2022-02-22 10:46:34','',''),(2633901,'1','179','933',413,'Retail Sale Id 1626575',1704.00,0.00,0.00,3.00,1704.00,'2022-02-22 10:49:02','',''),(2633902,'1','179','933',413,'Retail Sale Id 1626576',999.68,0.00,0.00,1.76,999.68,'2022-02-22 10:51:47','',''),(2633903,'1','179','933',413,'Retail Sale Id 1626577',1704.00,0.00,0.00,3.00,1704.00,'2022-02-22 10:53:08','',''),(2633904,'1','179','933',413,'Retail Sale Id 1626578',1999.36,0.00,0.00,3.52,1999.36,'2022-02-22 11:12:04','',''),(2633905,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,2636700.00,5100.00,0.00,0.00,'2022-02-22 12:19:15','',''),(2633906,'1','179',NULL,413,'Reception corrector for bridging 132513',0.00,0.00,0.00,5100.00,0.00,'2022-02-22 12:21:49','',''),(2633907,'1','179','933',413,'Received from bridging 132513',0.00,0.00,5100.00,0.00,0.00,'2022-02-22 12:21:49','',''),(2633908,'1','179','933',413,'Retail Sale Id 1626579',7100.00,0.00,0.00,12.50,637.50,'2022-02-22 12:39:02','',''),(2633909,'1','179','933',413,'Retail Sale Id 1626580',1704.00,0.00,0.00,3.00,153.00,'2022-02-22 12:51:31','',''),(2633910,'1','179','933',413,'Retail Sale Id 1626581',6997.76,0.00,0.00,12.32,628.32,'2022-02-22 13:41:53','',''),(2633911,'1','179','933',413,'Retail Sale Id 1626582',1749.44,0.00,0.00,3.08,157.08,'2022-02-22 13:42:47','',''),(2633912,'1','179','933',413,'Retail Sale Id 1626583',5680.00,0.00,0.00,10.00,510.00,'2022-02-22 15:00:33','',''),(2633913,'1','179','933',413,'Retail Sale Id 1626584',2840.00,0.00,0.00,5.00,255.00,'2022-02-22 15:02:27','',''),(2633914,'1','179','933',413,'Retail Sale Id 1626585',1136.00,0.00,0.00,2.00,102.00,'2022-02-22 15:04:34','',''),(2633915,'1','179','933',413,'Retail Sale Id 1626586',1704.00,0.00,0.00,3.00,153.00,'2022-02-22 15:09:58','',''),(2633916,'1','179','933',413,'Retail Sale Id 1626587',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 15:19:08','',''),(2633917,'1','179','933',413,'Retail Sale Id 1626588',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 15:33:43','',''),(2633918,'1','179','933',413,'Retail Sale Id 1626589',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 15:47:10','',''),(2633919,'1','179','933',413,'Retail Sale Id 1626590',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 15:51:32','',''),(2633920,'1','179','933',413,'Retail Sale Id 1626591',2840.00,0.00,0.00,5.00,255.00,'2022-02-22 15:56:51','',''),(2633921,'1','179','933',413,'Retail Sale Id 1626592',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 16:14:56','',''),(2633922,'1','179','933',413,'Retail Sale Id 1626593',1704.00,0.00,0.00,3.00,153.00,'2022-02-22 16:39:01','',''),(2633923,'1','179','933',413,'Retail Sale Id 1626594',14200.00,0.00,0.00,25.00,1275.00,'2022-02-22 16:57:23','',''),(2633924,'1','179','933',413,'Retail Sale Id 1626595',1704.00,0.00,0.00,3.00,153.00,'2022-02-22 17:11:23','',''),(2633925,'1','179','933',413,'Retail Sale Id 1626596',7100.00,0.00,0.00,12.50,637.50,'2022-02-22 17:16:23','',''),(2633926,'1','179','933',413,'Retail Sale Id 1626597',7100.00,0.00,0.00,12.50,637.50,'2022-02-22 17:17:58','',''),(2633927,'1','179','933',413,'Retail Sale Id 1626598',2840.00,0.00,0.00,5.00,255.00,'2022-02-22 17:20:29','',''),(2633928,'1','179','933',413,'Retail Sale Id 1626599',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 17:32:12','',''),(2633929,'1','179','933',413,'Retail Sale Id 1626600',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 17:39:15','',''),(2633930,'1','179','933',413,'Retail Sale Id 1626601',4544.00,0.00,0.00,8.00,408.00,'2022-02-22 17:42:54','',''),(2633931,'1','179','933',413,'Retail Sale Id 1626602',2999.04,0.00,0.00,5.28,269.28,'2022-02-22 17:59:04','',''),(2633932,'1','179','933',413,'Retail Sale Id 1626603',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 18:01:53','',''),(2633933,'1','179','933',413,'Retail Sale Id 1626604',3408.00,0.00,0.00,6.00,306.00,'2022-02-22 18:44:59','',''),(2633934,'1','179','933',413,'Retail Sale Id 1626605',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 08:35:31','',''),(2633935,'1','179','933',413,'Retail Sale Id 1626606',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 08:48:16','',''),(2633936,'1','179','933',413,'Retail Sale Id 1626607',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 08:55:34','',''),(2633937,'1','179','933',413,'Retail Sale Id 1626608',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 10:25:31','',''),(2633938,'1','179','933',413,'Retail Sale Id 1626609',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 10:45:56','',''),(2633939,'1','179','933',413,'Retail Sale Id 1626610',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 11:17:16','',''),(2633940,'1','179','933',413,'Retail Sale Id 1626611',1499.52,0.00,0.00,2.64,134.64,'2022-02-23 11:38:26','',''),(2633941,'1','179','933',413,'Retail Sale Id 1626612',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 11:40:05','',''),(2633942,'1','179','933',413,'Retail Sale Id 1626613',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 12:30:09','',''),(2633943,'1','179','933',413,'Retail Sale Id 1626614',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 12:33:36','',''),(2633944,'1','179','933',413,'Retail Sale Id 1626615',5998.08,0.00,0.00,10.56,538.56,'2022-02-23 12:55:03','',''),(2633945,'1','179','933',413,'Retail Sale Id 1626616',7100.00,0.00,0.00,12.50,637.50,'2022-02-23 15:45:58','',''),(2633946,'1','179','933',413,'Retail Sale Id 1626617',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 15:51:29','',''),(2633947,'1','179','933',413,'Retail Sale Id 1626618',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 15:59:53','',''),(2633948,'1','179','933',413,'Retail Sale Id 1626619',999.68,0.00,0.00,1.76,89.76,'2022-02-23 16:00:41','',''),(2633949,'1','179','933',413,'Retail Sale Id 1626620',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 16:38:27','',''),(2633950,'1','179','933',413,'Return of Retail Sale Id 1626617',0.00,1704.00,3.00,0.00,-153.00,'2022-02-23 16:42:30','',''),(2633951,'1','179','933',413,'Return of Retail Sale Id 1626616',0.00,7100.00,12.50,0.00,-637.50,'2022-02-23 16:43:45','',''),(2633952,'1','179','933',413,'Retail Sale Id 1626621',31353.60,0.00,0.00,55.20,2815.20,'2022-02-23 16:45:29','',''),(2633953,'1','179','933',413,'Retail Sale Id 1626622',2840.00,0.00,0.00,5.00,255.00,'2022-02-23 16:52:27','',''),(2633954,'1','179','933',413,'Retail Sale Id 1626625',1499.52,0.00,0.00,2.64,134.64,'2022-02-23 16:58:15','',''),(2633955,'1','179','933',413,'Retail Sale Id 1626625',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 16:58:15','',''),(2633956,'1','179','933',413,'Retail Sale Id 1626626',6497.92,0.00,0.00,11.44,583.44,'2022-02-23 17:20:29','',''),(2633957,'1','179','933',413,'Retail Sale Id 1626627',5680.00,0.00,0.00,10.00,510.00,'2022-02-23 17:29:45','',''),(2633958,'1','179','933',413,'Retail Sale Id 1626628',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 17:32:47','',''),(2633959,'1','179','933',413,'Retail Sale Id 1626629',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 17:37:12','',''),(2633960,'1','179','933',413,'Retail Sale Id 1626630',6816.00,0.00,0.00,12.00,612.00,'2022-02-23 17:40:06','',''),(2633961,'1','179','933',413,'Retail Sale Id 1626631',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 17:42:33','',''),(2633962,'1','179','933',413,'Retail Sale Id 1626632',3498.88,0.00,0.00,6.16,314.16,'2022-02-23 18:15:45','',''),(2633963,'1','179','933',413,'Retail Sale Id 1626633',2840.00,0.00,0.00,5.00,255.00,'2022-02-23 18:18:56','',''),(2633964,'1','179','933',413,'Retail Sale Id 1626634',2840.00,0.00,0.00,5.00,255.00,'2022-02-23 18:20:50','',''),(2633965,'1','179','933',413,'Retail Sale Id 1626635',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 18:25:07','',''),(2633966,'1','179','933',413,'Retail Sale Id 1626636',1704.00,0.00,0.00,3.00,153.00,'2022-02-23 18:36:49','',''),(2633967,'1','179','933',413,'Retail Sale Id 1626637',1499.52,0.00,0.00,2.64,134.64,'2022-02-23 18:49:46','',''),(2633968,'1','179','933',413,'Retail Sale Id 1626638',3408.00,0.00,0.00,6.00,306.00,'2022-02-23 19:16:10','',''),(2633969,'1','179','933',413,'Retail Sale Id 1626641',8849.44,0.00,0.00,15.58,794.58,'2022-02-24 09:47:38','',''),(2633970,'1','179','933',413,'Retail Sale Id 1626642',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 09:57:10','',''),(2633971,'1','179','933',413,'Retail Sale Id 1626643',999.68,0.00,0.00,1.76,89.76,'2022-02-24 10:09:13','',''),(2633972,'1','179','933',413,'Retail Sale Id 1626644',32489.60,0.00,0.00,57.20,2917.20,'2022-02-24 10:12:06','',''),(2633973,'1','179','933',413,'Retail Sale Id 1626645',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 10:41:53','',''),(2633974,'1','179','933',413,'Retail Sale Id 1626645',1999.36,0.00,0.00,3.52,179.52,'2022-02-24 10:41:53','',''),(2633975,'1','179','933',413,'Retail Sale Id 1626646',2300.40,0.00,0.00,4.05,206.55,'2022-02-24 11:43:12','',''),(2633976,'1','179','933',413,'Retail Sale Id 1626647',3408.00,0.00,0.00,6.00,306.00,'2022-02-24 11:44:25','',''),(2633977,'1','179','933',413,'Retail Sale Id 1626648',1704.00,0.00,0.00,3.00,153.00,'2022-02-24 11:45:34','',''),(2633978,'1','179','933',413,'Retail Sale Id 1626649',1499.52,0.00,0.00,2.64,134.64,'2022-02-24 11:47:45','',''),(2633979,'1','179','933',413,'Retail Sale Id 1626650',137671.84,0.00,0.00,242.38,12361.38,'2022-02-24 19:27:34','',''),(2633980,'1','179','933',413,'Retail Sale Id 1626651',1499.52,0.00,0.00,2.64,134.64,'2022-02-24 19:35:49','',''),(2633981,'1','179','933',413,'Retail Sale Id 1626652',7100.00,0.00,0.00,12.50,637.50,'2022-02-24 19:50:47','',''),(2633982,'1','179','933',413,'Retail Sale Id 1626653',1698.32,0.00,0.00,2.99,152.49,'2022-02-24 20:21:30','',''),(2633983,'1','179','933',413,'Retail Sale Id 1626654',4146.40,0.00,0.00,7.30,372.30,'2022-02-24 20:23:00','',''),(2633984,'1','179','933',413,'Retail Sale Id 1626655',7100.00,0.00,0.00,12.50,637.50,'2022-02-25 08:16:08','',''),(2633985,'1','179','933',413,'Retail Sale Id 1626656',11002.16,0.00,0.00,19.37,987.87,'2022-02-25 14:35:30','',''),(2633986,'1','179','933',413,'Retail Sale Id 1626657',30388.00,0.00,0.00,53.50,2728.50,'2022-02-25 14:36:45','',''),(2633987,'1','179','933',413,'Retail Sale Id 1626658',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 14:38:38','',''),(2633988,'1','179','933',413,'Retail Sale Id 1626659',2840.00,0.00,0.00,5.00,255.00,'2022-02-25 14:52:12','',''),(2633989,'1','179','933',413,'Retail Sale Id 1626660',1136.00,0.00,0.00,2.00,102.00,'2022-02-25 15:32:02','',''),(2633990,'1','179','933',413,'Retail Sale Id 1626661',2840.00,0.00,0.00,5.00,255.00,'2022-02-25 15:45:11','',''),(2633991,'1','179','933',413,'Retail Sale Id 1626662',999.68,0.00,0.00,1.76,89.76,'2022-02-25 15:51:34','',''),(2633992,'1','179','933',413,'Retail Sale Id 1626662',1499.52,0.00,0.00,2.64,134.64,'2022-02-25 15:51:34','',''),(2633993,'1','179','933',413,'Retail Sale Id 1626663',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 15:53:04','',''),(2633994,'1','179','933',413,'Retail Sale Id 1626664',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 15:53:50','',''),(2633995,'1','179','933',413,'Retail Sale Id 1626665',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 16:02:12','',''),(2633996,'1','179','933',413,'Retail Sale Id 1626666',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 16:27:04','',''),(2633997,'1','179','933',413,'Retail Sale Id 1626667',7100.00,0.00,0.00,12.50,637.50,'2022-02-25 16:28:08','',''),(2633998,'1','179','933',413,'Retail Sale Id 1626668',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 16:30:33','',''),(2633999,'1','179','933',413,'Retail Sale Id 1626669',7100.00,0.00,0.00,12.50,637.50,'2022-02-25 16:37:04','',''),(2634000,'1','179','933',413,'Retail Sale Id 1626670',1499.52,0.00,0.00,2.64,134.64,'2022-02-25 16:38:52','',''),(2634001,'1','179','933',413,'Retail Sale Id 1626671',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 16:40:00','',''),(2634002,'1','179','933',413,'Retail Sale Id 1626672',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 16:59:38','',''),(2634003,'1','179','933',413,'Retail Sale Id 1626673',999.68,0.00,0.00,1.76,89.76,'2022-02-25 17:19:12','',''),(2634004,'1','179','933',413,'Retail Sale Id 1626674',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 17:20:55','',''),(2634005,'1','179','933',413,'Retail Sale Id 1626675',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 17:31:00','',''),(2634006,'1','179','933',413,'Retail Sale Id 1626680',999.68,0.00,0.00,1.76,89.76,'2022-02-25 17:48:37','',''),(2634007,'1','179','933',413,'Retail Sale Id 1626681',2272.00,0.00,0.00,4.00,204.00,'2022-02-25 17:50:20','',''),(2634008,'1','179','933',413,'Retail Sale Id 1626683',7100.00,0.00,0.00,12.50,637.50,'2022-02-25 18:09:27','',''),(2634009,'1','179','933',413,'Retail Sale Id 1626684',3408.00,0.00,0.00,6.00,306.00,'2022-02-25 18:32:10','',''),(2634010,'1','179','933',413,'Retail Sale Id 1626685',999.68,0.00,0.00,1.76,89.76,'2022-02-25 18:33:11','',''),(2634011,'1','179','933',413,'Retail Sale Id 1626686',3124.00,0.00,0.00,5.50,280.50,'2022-02-25 18:34:59','',''),(2634012,'1','179','933',413,'Return of Retail Sale Id 1626685',0.00,999.68,1.76,0.00,-89.76,'2022-02-25 18:42:51','',''),(2634013,'1','179','933',413,'Retail Sale Id 1626687',1704.00,0.00,0.00,3.00,153.00,'2022-02-25 18:43:57','',''),(2634014,'1','179','933',413,'Retail Sale Id 1626689',10224.00,0.00,0.00,18.00,918.00,'2022-02-25 19:41:44','',''),(2634015,'1','179','933',413,'Retail Sale Id 1626690',999.68,0.00,0.00,1.76,89.76,'2022-02-25 19:47:08','',''),(2634016,'1','179','933',413,'Retail Sale Id 1626691',1749.44,0.00,0.00,3.08,157.08,'2022-02-26 08:34:46','',''),(2634017,'1','179','933',413,'Retail Sale Id 1626692',6248.00,0.00,0.00,11.00,561.00,'2022-02-26 08:47:03','',''),(2634018,'1','179','933',413,'Retail Sale Id 1626693',1420.00,0.00,0.00,2.50,127.50,'2022-02-26 09:11:29','',''),(2634019,'1','179','933',413,'Retail Sale Id 1626694',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 09:13:48','',''),(2634020,'1','179','933',413,'Retail Sale Id 1626695',1749.44,0.00,0.00,3.08,157.08,'2022-02-26 09:16:03','',''),(2634021,'1','179','933',413,'Retail Sale Id 1626696',8520.00,0.00,0.00,15.00,765.00,'2022-02-26 10:18:47','',''),(2634022,'1','179','933',413,'Retail Sale Id 1626697',6747.84,0.00,0.00,11.88,605.88,'2022-02-26 10:19:46','',''),(2634023,'1','179','933',413,'Retail Sale Id 1626698',1420.00,0.00,0.00,2.50,127.50,'2022-02-26 10:20:18','',''),(2634024,'1','179','933',413,'Retail Sale Id 1626699',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 10:29:59','',''),(2634025,'1','179','933',413,'Retail Sale Id 1626700',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 10:33:45','',''),(2634026,'1','179','933',413,'Retail Sale Id 1626701',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 10:45:54','',''),(2634027,'1','179','933',413,'Retail Sale Id 1626702',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 11:05:14','',''),(2634028,'1','179','933',413,'Retail Sale Id 1626703',3550.00,0.00,0.00,6.25,318.75,'2022-02-26 11:14:32','',''),(2634029,'1','179','933',413,'Retail Sale Id 1626704',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 11:59:37','',''),(2634030,'1','179','933',413,'Retail Sale Id 1626705',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 12:05:36','',''),(2634031,'1','179','933',413,'Retail Sale Id 1626706',2499.20,0.00,0.00,4.40,224.40,'2022-02-26 12:17:56','',''),(2634032,'1','179','933',413,'Retail Sale Id 1626707',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 12:31:27','',''),(2634033,'1','179','933',413,'Retail Sale Id 1626708',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 12:35:05','',''),(2634034,'1','179','933',413,'Retail Sale Id 1626709',5901.52,0.00,0.00,10.39,529.89,'2022-02-26 12:36:58','',''),(2634035,'1','179','933',413,'Retail Sale Id 1626710',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 13:46:03','',''),(2634036,'1','179','933',413,'Retail Sale Id 1626711',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 14:22:01','',''),(2634037,'1','179','933',413,'Retail Sale Id 1626712',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 14:29:11','',''),(2634038,'1','179','933',413,'Retail Sale Id 1626713',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 14:48:45','',''),(2634039,'1','179','933',413,'Retail Sale Id 1626714',4544.00,0.00,0.00,8.00,408.00,'2022-02-26 16:21:23','',''),(2634040,'1','179','933',413,'Retail Sale Id 1626715',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 16:52:12','',''),(2634041,'1','179','933',413,'Retail Sale Id 1626716',999.68,0.00,0.00,1.76,89.76,'2022-02-26 16:52:57','',''),(2634042,'1','179','933',413,'Retail Sale Id 1626717',1999.36,0.00,0.00,3.52,179.52,'2022-02-26 17:12:00','',''),(2634043,'1','179','933',413,'Retail Sale Id 1626718',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 17:17:01','',''),(2634044,'1','179','933',413,'Retail Sale Id 1626719',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 17:18:26','',''),(2634045,'1','179','933',413,'Retail Sale Id 1626720',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 17:22:09','',''),(2634046,'1','179','933',413,'Retail Sale Id 1626721',5112.00,0.00,0.00,9.00,459.00,'2022-02-26 17:24:17','',''),(2634047,'1','179','933',413,'Retail Sale Id 1626722',1499.52,0.00,0.00,2.64,134.64,'2022-02-26 17:44:56','',''),(2634048,'1','179','933',413,'Retail Sale Id 1626723',1704.00,0.00,0.00,3.00,153.00,'2022-02-26 18:07:25','',''),(2634049,'1','179','933',413,'Retail Sale Id 1626724',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 18:09:53','',''),(2634050,'1','179','933',413,'Retail Sale Id 1626725',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 18:10:49','',''),(2634051,'1','179','933',413,'Retail Sale Id 1626727',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 18:24:10','',''),(2634052,'1','179','933',413,'Retail Sale Id 1626729',7100.00,0.00,0.00,12.50,637.50,'2022-02-26 18:29:34','',''),(2634053,'1','179','933',413,'Retail Sale Id 1626730',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 18:46:52','',''),(2634054,'1','179','933',413,'Retail Sale Id 1626731',2840.00,0.00,0.00,5.00,255.00,'2022-02-26 19:12:21','',''),(2634055,'1','179','933',413,'Retail Sale Id 1626732',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 19:18:16','',''),(2634056,'1','179','933',413,'Retail Sale Id 1626733',3408.00,0.00,0.00,6.00,306.00,'2022-02-26 19:22:23','',''),(2634057,'1','179','933',413,'Retail Sale Id 1626734',6816.00,0.00,0.00,12.00,612.00,'2022-02-27 08:47:05','',''),(2634058,'1','179','933',413,'Retail Sale Id 1626735',6997.76,0.00,0.00,12.32,628.32,'2022-02-27 08:47:45','',''),(2634059,'1','179','933',413,'Retail Sale Id 1626736',6895.52,0.00,0.00,12.14,619.14,'2022-02-27 08:48:43','',''),(2634060,'1','179','933',413,'Retail Sale Id 1626737',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 08:50:59','',''),(2634061,'1','179','933',413,'Retail Sale Id 1626738',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 09:06:12','',''),(2634062,'1','179','933',413,'Retail Sale Id 1626739',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 09:27:30','',''),(2634063,'1','179','933',413,'Retail Sale Id 1626740',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 09:31:47','',''),(2634064,'1','179','933',413,'Retail Sale Id 1626741',2499.20,0.00,0.00,4.40,224.40,'2022-02-27 09:51:54','',''),(2634065,'1','179','933',413,'Retail Sale Id 1626742',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 09:53:33','',''),(2634066,'1','179','933',413,'Retail Sale Id 1626743',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 10:14:37','',''),(2634067,'1','179','933',413,'Retail Sale Id 1626744',1800.56,0.00,0.00,3.17,161.67,'2022-02-27 10:41:06','',''),(2634068,'1','179','933',413,'Retail Sale Id 1626745',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 10:42:33','',''),(2634069,'1','179','933',413,'Retail Sale Id 1626746',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 10:53:03','',''),(2634070,'1','179','933',413,'Retail Sale Id 1626747',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 10:58:32','',''),(2634071,'1','179','933',413,'Retail Sale Id 1626748',9440.16,0.00,0.00,16.62,847.62,'2022-02-27 11:58:55','',''),(2634072,'1','179','933',413,'Retail Sale Id 1626749',4998.40,0.00,0.00,8.80,448.80,'2022-02-27 12:04:39','',''),(2634073,'1','179','933',413,'Retail Sale Id 1626750',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 12:07:29','',''),(2634074,'1','179','933',413,'Retail Sale Id 1626751',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 12:12:29','',''),(2634075,'1','179','933',413,'Retail Sale Id 1626752',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 12:14:00','',''),(2634076,'1','179','933',413,'Retail Sale Id 1626753',999.68,0.00,0.00,1.76,89.76,'2022-02-27 12:28:40','',''),(2634077,'1','179','933',413,'Retail Sale Id 1626754',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 12:30:43','',''),(2634078,'1','179','933',413,'Retail Sale Id 1626755',4549.68,0.00,0.00,8.01,408.51,'2022-02-27 12:37:14','',''),(2634079,'1','179','933',413,'Retail Sale Id 1626756',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 12:38:09','',''),(2634080,'1','179','933',413,'Retail Sale Id 1626757',3550.00,0.00,0.00,6.25,318.75,'2022-02-27 12:39:48','',''),(2634081,'1','179','933',413,'Retail Sale Id 1626758',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 12:54:55','',''),(2634082,'1','179','933',413,'Retail Sale Id 1626759',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 13:26:24','',''),(2634083,'1','179','933',413,'Retail Sale Id 1626761',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 13:32:32','',''),(2634084,'1','179','933',413,'Retail Sale Id 1626762',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 13:41:57','',''),(2634085,'1','179','933',413,'Retail Sale Id 1626763',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 13:44:55','',''),(2634086,'1','179','933',413,'Retail Sale Id 1626764',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 14:04:20','',''),(2634087,'1','179','933',413,'Retail Sale Id 1626765',999.68,0.00,0.00,1.76,89.76,'2022-02-27 14:05:13','',''),(2634088,'1','179','933',413,'Retail Sale Id 1626766',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 14:06:04','',''),(2634089,'1','179','933',413,'Retail Sale Id 1626767',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 14:17:20','',''),(2634090,'1','179','933',413,'Retail Sale Id 1626768',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 14:19:03','',''),(2634091,'1','179','933',413,'Retail Sale Id 1626769',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 14:21:46','',''),(2634092,'1','179','933',413,'Retail Sale Id 1626770',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 14:22:48','',''),(2634093,'1','179','933',413,'Retail Sale Id 1626771',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 14:24:44','',''),(2634094,'1','179','933',413,'Retail Sale Id 1626772',568.00,0.00,0.00,1.00,51.00,'2022-02-27 14:26:12','',''),(2634095,'1','179','933',413,'Retail Sale Id 1626773',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 14:39:41','',''),(2634096,'1','179','933',413,'Retail Sale Id 1626774',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 14:55:27','',''),(2634097,'1','179','933',413,'Retail Sale Id 1626775',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 15:01:53','',''),(2634098,'1','179','933',413,'Retail Sale Id 1626776',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 15:03:53','',''),(2634099,'1','179','933',413,'Retail Sale Id 1626777',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 15:16:36','',''),(2634100,'1','179','933',413,'Retail Sale Id 1626778',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 15:18:11','',''),(2634101,'1','179','933',413,'Retail Sale Id 1626779',999.68,0.00,0.00,1.76,89.76,'2022-02-27 15:19:26','',''),(2634102,'1','179','933',413,'Retail Sale Id 1626780',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 15:20:27','',''),(2634103,'1','179','933',413,'Retail Sale Id 1626781',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 15:29:13','',''),(2634104,'1','179','933',413,'Retail Sale Id 1626782',6816.00,0.00,0.00,12.00,612.00,'2022-02-27 15:35:02','',''),(2634105,'1','179','933',413,'Retail Sale Id 1626784',999.68,0.00,0.00,1.76,89.76,'2022-02-27 15:38:25','',''),(2634106,'1','179','933',413,'Retail Sale Id 1626785',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 15:39:42','',''),(2634107,'1','179','933',413,'Retail Sale Id 1626786',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 15:41:55','',''),(2634108,'1','179','933',413,'Retail Sale Id 1626787',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 15:59:27','',''),(2634109,'1','179','933',413,'Retail Sale Id 1626788',2272.00,0.00,0.00,4.00,204.00,'2022-02-27 16:05:19','',''),(2634110,'1','179','933',413,'Retail Sale Id 1626789',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 16:06:36','',''),(2634111,'1','179','933',413,'Retail Sale Id 1626790',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 16:11:09','',''),(2634112,'1','179','933',413,'Retail Sale Id 1626791',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 16:42:26','',''),(2634113,'1','179','933',413,'Retail Sale Id 1626792',7100.00,0.00,0.00,12.50,637.50,'2022-02-27 16:43:33','',''),(2634114,'1','179','933',413,'Retail Sale Id 1626793',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 16:49:19','',''),(2634115,'1','179','933',413,'Retail Sale Id 1626794',3998.72,0.00,0.00,7.04,359.04,'2022-02-27 17:09:19','',''),(2634116,'1','179','933',413,'Retail Sale Id 1626795',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 17:11:05','',''),(2634117,'1','179','933',413,'Retail Sale Id 1626796',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 17:15:20','',''),(2634118,'1','179','933',413,'Retail Sale Id 1626797',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 17:17:59','',''),(2634119,'1','179','933',413,'Retail Sale Id 1626798',999.68,0.00,0.00,1.76,89.76,'2022-02-27 17:24:25','',''),(2634120,'1','179','933',413,'Retail Sale Id 1626799',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 17:28:04','',''),(2634121,'1','179','933',413,'Retail Sale Id 1626800',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 17:29:31','',''),(2634122,'1','179','933',413,'Retail Sale Id 1626801',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 17:32:28','',''),(2634123,'1','179','933',413,'Retail Sale Id 1626802',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 17:33:20','',''),(2634124,'1','179','933',413,'Retail Sale Id 1626803',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 17:35:48','',''),(2634125,'1','179','933',413,'Retail Sale Id 1626804',1136.00,0.00,0.00,2.00,102.00,'2022-02-27 17:43:22','',''),(2634126,'1','179','933',413,'Retail Sale Id 1626805',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 17:45:12','',''),(2634127,'1','179','933',413,'Retail Sale Id 1626806',897.44,0.00,0.00,1.58,80.58,'2022-02-27 17:55:40','',''),(2634128,'1','179','933',413,'Retail Sale Id 1626806',897.44,0.00,0.00,1.58,80.58,'2022-02-27 17:55:40','',''),(2634129,'1','179','933',413,'Retail Sale Id 1626807',1499.52,0.00,0.00,2.64,134.64,'2022-02-27 18:05:13','',''),(2634130,'1','179','933',413,'Retail Sale Id 1626808',999.68,0.00,0.00,1.76,89.76,'2022-02-27 18:15:17','',''),(2634131,'1','179','933',413,'Retail Sale Id 1626809',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 18:27:38','',''),(2634132,'1','179','933',413,'Retail Sale Id 1626810',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 18:28:30','',''),(2634133,'1','179','933',413,'Retail Sale Id 1626811',1136.00,0.00,0.00,2.00,102.00,'2022-02-27 18:40:43','',''),(2634134,'1','179','933',413,'Retail Sale Id 1626812',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 18:42:48','',''),(2634135,'1','179','933',413,'Retail Sale Id 1626813',2840.00,0.00,0.00,5.00,255.00,'2022-02-27 18:43:43','',''),(2634136,'1','179','933',413,'Retail Sale Id 1626814',5680.00,0.00,0.00,10.00,510.00,'2022-02-27 18:45:23','',''),(2634137,'1','179','933',413,'Retail Sale Id 1626815',13348.00,0.00,0.00,23.50,1198.50,'2022-02-27 18:50:49','',''),(2634138,'1','179','933',413,'Retail Sale Id 1626816',1704.00,0.00,0.00,3.00,153.00,'2022-02-27 18:52:57','',''),(2634139,'1','179','933',413,'Retail Sale Id 1626817',568.00,0.00,0.00,1.00,51.00,'2022-02-27 18:56:20','',''),(2634140,'1','179','933',413,'Retail Sale Id 1626818',3408.00,0.00,0.00,6.00,306.00,'2022-02-27 19:16:29','',''),(2634141,'1','179','933',413,'Retail Sale Id 1626819',1999.36,0.00,0.00,3.52,179.52,'2022-02-27 19:27:11','',''),(2634142,'1','179','933',413,'Retail Sale Id 1626820',2999.04,0.00,0.00,5.28,269.28,'2022-02-27 19:38:34','',''),(2634143,'1','179','933',413,'Return of Retail Sale Id 1626801',0.00,3408.00,6.00,0.00,-306.00,'2022-02-27 20:06:48','',''),(2634144,'1','179','933',413,'Retail Sale Id 1626821',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 08:13:35','',''),(2634145,'1','179','933',413,'Retail Sale Id 1626822',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 08:15:03','',''),(2634146,'1','179','933',413,'Retail Sale Id 1626823',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 08:39:25','',''),(2634147,'1','179','933',413,'Retail Sale Id 1626824',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 08:41:52','',''),(2634148,'1','179','933',413,'Return of Retail Sale Id 1626822',0.00,1704.00,3.00,0.00,-153.00,'2022-02-28 08:42:51','',''),(2634149,'1','179','933',413,'Retail Sale Id 1626825',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 08:44:03','',''),(2634150,'1','179','933',413,'Retail Sale Id 1626826',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 08:49:27','',''),(2634151,'1','179','933',413,'Retail Sale Id 1626827',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 09:09:14','',''),(2634152,'1','179','933',413,'Retail Sale Id 1626828',1999.36,0.00,0.00,3.52,179.52,'2022-02-28 09:13:25','',''),(2634153,'1','179','933',413,'Retail Sale Id 1626829',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 09:21:04','',''),(2634154,'1','179','933',413,'Retail Sale Id 1626830',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 09:22:16','',''),(2634155,'1','179','933',413,'Retail Sale Id 1626831',999.68,0.00,0.00,1.76,89.76,'2022-02-28 09:23:54','',''),(2634156,'1','179','933',413,'Retail Sale Id 1626832',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 09:36:34','',''),(2634157,'1','179','933',413,'Retail Sale Id 1626833',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 09:37:52','',''),(2634158,'1','179','933',413,'Retail Sale Id 1626834',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 09:58:37','',''),(2634159,'1','179','933',413,'Retail Sale Id 1626835',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 10:22:00','',''),(2634160,'1','179','933',413,'Retail Sale Id 1626836',5680.00,0.00,0.00,10.00,510.00,'2022-02-28 10:33:59','',''),(2634161,'1','179','933',413,'Retail Sale Id 1626837',999.68,0.00,0.00,1.76,89.76,'2022-02-28 10:34:50','',''),(2634162,'1','179','933',413,'Retail Sale Id 1626838',999.68,0.00,0.00,1.76,89.76,'2022-02-28 10:35:36','',''),(2634163,'1','179','933',413,'Retail Sale Id 1626839',6816.00,0.00,0.00,12.00,612.00,'2022-02-28 10:36:49','',''),(2634164,'1','179','933',413,'Retail Sale Id 1626840',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 10:43:36','',''),(2634165,'1','179','933',413,'Retail Sale Id 1626841',5680.00,0.00,0.00,10.00,510.00,'2022-02-28 11:04:19','',''),(2634166,'1','179','933',413,'Retail Sale Id 1626842',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 11:30:30','',''),(2634167,'1','179','933',413,'Retail Sale Id 1626843',2999.04,0.00,0.00,5.28,269.28,'2022-02-28 11:32:58','',''),(2634168,'1','179','933',413,'Retail Sale Id 1626844',800.88,0.00,0.00,1.41,71.91,'2022-02-28 11:37:17','',''),(2634169,'1','179','933',413,'Retail Sale Id 1626845',1999.36,0.00,0.00,3.52,179.52,'2022-02-28 11:47:20','',''),(2634170,'1','179','933',413,'Retail Sale Id 1626846',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 11:54:48','',''),(2634171,'1','179','933',413,'Retail Sale Id 1626847',1999.36,0.00,0.00,3.52,179.52,'2022-02-28 11:56:32','',''),(2634172,'1','179','933',413,'Retail Sale Id 1626848',1136.00,0.00,0.00,2.00,102.00,'2022-02-28 11:59:14','',''),(2634173,'1','179','933',413,'Retail Sale Id 1626849',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 12:06:31','',''),(2634174,'1','179','933',413,'Retail Sale Id 1626850',999.68,0.00,0.00,1.76,89.76,'2022-02-28 12:11:16','',''),(2634175,'1','179','933',413,'Retail Sale Id 1626851',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 12:12:24','',''),(2634176,'1','179','933',413,'Retail Sale Id 1626852',8804.00,0.00,0.00,15.50,790.50,'2022-02-28 12:19:11','',''),(2634177,'1','179','933',413,'Retail Sale Id 1626853',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 12:22:47','',''),(2634178,'1','179','933',413,'Retail Sale Id 1626854',999.68,0.00,0.00,1.76,89.76,'2022-02-28 12:24:22','',''),(2634179,'1','179','933',413,'Retail Sale Id 1626855',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 12:30:43','',''),(2634180,'1','179','933',413,'Retail Sale Id 1626856',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 12:53:56','',''),(2634181,'1','179','933',413,'Retail Sale Id 1626857',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 12:57:14','',''),(2634182,'1','179','933',413,'Retail Sale Id 1626858',2272.00,0.00,0.00,4.00,204.00,'2022-02-28 13:25:14','',''),(2634183,'1','179','933',413,'Retail Sale Id 1626859',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 13:56:12','',''),(2634184,'1','179','933',413,'Retail Sale Id 1626860',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 14:17:40','',''),(2634185,'1','179','933',413,'Retail Sale Id 1626861',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 14:19:38','',''),(2634186,'1','179','933',413,'Retail Sale Id 1626862',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 14:33:24','',''),(2634187,'1','179','933',413,'Retail Sale Id 1626863',1136.00,0.00,0.00,2.00,102.00,'2022-02-28 14:42:05','',''),(2634188,'1','179','933',413,'Retail Sale Id 1626863',1136.00,0.00,0.00,2.00,102.00,'2022-02-28 14:42:05','',''),(2634189,'1','179','933',413,'Retail Sale Id 1626864',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 15:19:42','',''),(2634190,'1','179','933',413,'Retail Sale Id 1626865',4998.40,0.00,0.00,8.80,448.80,'2022-02-28 15:29:26','',''),(2634191,'1','179','933',413,'Retail Sale Id 1626866',852.00,0.00,0.00,1.50,76.50,'2022-02-28 15:32:25','',''),(2634192,'1','179','933',413,'Retail Sale Id 1626867',999.68,0.00,0.00,1.76,89.76,'2022-02-28 15:50:18','',''),(2634193,'1','179','933',413,'Retail Sale Id 1626868',897.44,0.00,0.00,1.58,80.58,'2022-02-28 16:03:37','',''),(2634194,'1','179','933',413,'Retail Sale Id 1626869',11360.00,0.00,0.00,20.00,1020.00,'2022-02-28 16:05:22','',''),(2634195,'1','179','933',413,'Retail Sale Id 1626870',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 16:18:02','',''),(2634196,'1','179','933',413,'Retail Sale Id 1626871',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 16:26:46','',''),(2634197,'1','179','933',413,'Retail Sale Id 1626872',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 16:37:53','',''),(2634198,'1','179','933',413,'Retail Sale Id 1626873',2840.00,0.00,0.00,5.00,255.00,'2022-02-28 16:47:24','',''),(2634199,'1','179','933',413,'Retail Sale Id 1626874',3998.72,0.00,0.00,7.04,359.04,'2022-02-28 16:57:17','',''),(2634200,'1','179','933',413,'Retail Sale Id 1626875',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 17:01:30','',''),(2634201,'1','179','933',413,'Retail Sale Id 1626876',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 17:05:23','',''),(2634202,'1','179','933',413,'Retail Sale Id 1626877',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 17:24:23','',''),(2634203,'1','179','933',413,'Retail Sale Id 1626878',1499.52,0.00,0.00,2.64,134.64,'2022-02-28 17:28:44','',''),(2634204,'1','179','933',413,'Retail Sale Id 1626879',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 17:30:54','',''),(2634205,'1','179','933',413,'Retail Sale Id 1626880',5998.08,0.00,0.00,10.56,538.56,'2022-02-28 17:31:51','',''),(2634206,'1','179','933',413,'Retail Sale Id 1626881',3408.00,0.00,0.00,6.00,306.00,'2022-02-28 17:35:27','',''),(2634207,'1','179','933',413,'Retail Sale Id 1626882',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 17:39:48','',''),(2634208,'1','179','933',413,'Retail Sale Id 1626883',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 17:42:26','',''),(2634209,'1','179','933',413,'Retail Sale Id 1626884',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 17:51:24','',''),(2634210,'1','179','933',413,'Retail Sale Id 1626885',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 18:09:09','',''),(2634211,'1','179','933',413,'Retail Sale Id 1626886',999.68,0.00,0.00,1.76,89.76,'2022-02-28 18:10:21','',''),(2634212,'1','179','933',413,'Retail Sale Id 1626887',1999.36,0.00,0.00,3.52,179.52,'2022-02-28 18:10:59','',''),(2634213,'1','179','933',413,'Retail Sale Id 1626888',1704.00,0.00,0.00,3.00,153.00,'2022-02-28 18:24:13','',''),(2634214,'1','179','933',413,'Retail Sale Id 1626889',7100.00,0.00,0.00,12.50,637.50,'2022-02-28 18:29:06','',''),(2634215,'1','179','933',413,'Return of Retail Sale Id 1626888',0.00,1704.00,3.00,0.00,-153.00,'2022-02-28 18:47:25','',''),(2634216,'1','179','933',413,'Retail Sale Id 1626890',1624.48,0.00,0.00,2.86,145.86,'2022-02-28 18:48:02','',''),(2634217,'1','179','933',413,'Retail Sale Id 1626891',1198.48,0.00,0.00,2.11,107.61,'2022-02-28 19:42:21','',''),(2634218,'1','179','933',413,'Retail Sale Id 1626892',1999.36,0.00,0.00,3.52,179.52,'2022-03-01 08:19:53','',''),(2634219,'1','179','933',413,'Retail Sale Id 1626893',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 08:21:23','',''),(2634220,'1','179','933',413,'Retail Sale Id 1626894',10508.00,0.00,0.00,18.50,943.50,'2022-03-01 08:22:13','',''),(2634221,'1','179','933',413,'Retail Sale Id 1626895',2840.00,0.00,0.00,5.00,255.00,'2022-03-01 08:32:15','',''),(2634222,'1','179','933',413,'Retail Sale Id 1626896',3998.72,0.00,0.00,7.04,359.04,'2022-03-01 08:52:56','',''),(2634223,'1','179','933',413,'Retail Sale Id 1626897',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 08:59:35','',''),(2634224,'1','179','933',413,'Retail Sale Id 1626898',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 09:14:35','',''),(2634225,'1','179','933',413,'Retail Sale Id 1626899',2840.00,0.00,0.00,5.00,255.00,'2022-03-01 09:15:57','',''),(2634226,'1','179','933',413,'Retail Sale Id 1626900',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 09:27:58','',''),(2634227,'1','179','933',413,'Retail Sale Id 1626901',1136.00,0.00,0.00,2.00,102.00,'2022-03-01 09:49:04','',''),(2634228,'1','179','933',413,'Retail Sale Id 1626902',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 10:03:19','',''),(2634229,'1','179','933',413,'Retail Sale Id 1626903',7100.00,0.00,0.00,12.50,637.50,'2022-03-01 10:05:47','',''),(2634230,'1','179','933',413,'Retail Sale Id 1626904',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 10:43:31','',''),(2634231,'1','179','933',413,'Retail Sale Id 1626905',2840.00,0.00,0.00,5.00,255.00,'2022-03-01 10:46:19','',''),(2634232,'1','179','933',413,'Retail Sale Id 1626906',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 12:38:14','',''),(2634233,'1','179','933',413,'Retail Sale Id 1626907',6816.00,0.00,0.00,12.00,612.00,'2022-03-01 19:40:54','',''),(2634234,'1','179','933',413,'Retail Sale Id 1626908',14200.00,0.00,0.00,25.00,1275.00,'2022-03-01 19:42:19','',''),(2634235,'1','179','933',413,'Retail Sale Id 1626909',82928.00,0.00,0.00,146.00,7446.00,'2022-03-01 19:45:41','',''),(2634236,'1','179','933',413,'Retail Sale Id 1626910',13200.32,0.00,0.00,23.24,1185.24,'2022-03-01 19:47:16','',''),(2634237,'1','179','933',413,'Retail Sale Id 1626911',29536.00,0.00,0.00,52.00,2652.00,'2022-03-01 19:48:52','',''),(2634238,'1','179','933',413,'Retail Sale Id 1626912',9099.36,0.00,0.00,16.02,817.02,'2022-03-01 19:51:01','',''),(2634239,'1','179','933',413,'Retail Sale Id 1626913',5702.72,0.00,0.00,10.04,512.04,'2022-03-01 19:54:16','',''),(2634240,'1','179','933',413,'Retail Sale Id 1626914',3408.00,0.00,0.00,6.00,306.00,'2022-03-01 20:07:04','',''),(2634241,'1','179','933',413,'Retail Sale Id 1626915',1704.00,0.00,0.00,3.00,153.00,'2022-03-01 20:20:51','',''),(2634242,'1','179','933',413,'Retail Sale Id 1626916',3498.88,0.00,0.00,6.16,314.16,'2022-03-01 20:22:21','',''),(2634243,'1','179','933',413,'Retail Sale Id 1626917',6816.00,0.00,0.00,12.00,612.00,'2022-03-01 20:27:31','',''),(2634244,'1','179','933',413,'Retail Sale Id 1626918',4544.00,0.00,0.00,8.00,408.00,'2022-03-02 08:07:08','',''),(2634245,'1','179','933',413,'Retail Sale Id 1626919',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 09:08:07','',''),(2634246,'1','179','933',413,'Retail Sale Id 1626920',1999.36,0.00,0.00,3.52,179.52,'2022-03-02 09:43:03','',''),(2634247,'1','179','933',413,'Retail Sale Id 1626923',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 10:31:44','',''),(2634248,'1','179','933',413,'Retail Sale Id 1626924',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 10:33:38','',''),(2634249,'1','179','933',413,'Retail Sale Id 1626925',1499.52,0.00,0.00,2.64,134.64,'2022-03-02 10:35:46','',''),(2634250,'1','179','933',413,'Retail Sale Id 1626926',14200.00,0.00,0.00,25.00,1275.00,'2022-03-02 11:08:42','',''),(2634251,'1','179','933',413,'Retail Sale Id 1626927',6997.76,0.00,0.00,12.32,628.32,'2022-03-02 11:10:30','',''),(2634252,'1','179','933',413,'Return of Retail Sale Id 1626927',0.00,6997.76,12.32,0.00,-628.32,'2022-03-02 11:22:08','',''),(2634253,'1','179','933',413,'Retail Sale Id 1626928',6997.76,0.00,0.00,12.32,628.32,'2022-03-02 11:23:28','',''),(2634254,'1','179','933',413,'Retail Sale Id 1626929',14200.00,0.00,0.00,25.00,1275.00,'2022-03-02 11:24:10','',''),(2634255,'1','179','933',413,'Retail Sale Id 1626930',2272.00,0.00,0.00,4.00,204.00,'2022-03-02 11:34:37','',''),(2634256,'1','179','933',413,'Retail Sale Id 1626931',999.68,0.00,0.00,1.76,89.76,'2022-03-02 11:49:11','',''),(2634257,'1','179','933',413,'Retail Sale Id 1626932',2272.00,0.00,0.00,4.00,204.00,'2022-03-02 11:54:49','',''),(2634258,'1','179','933',413,'Retail Sale Id 1626933',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 11:55:36','',''),(2634259,'1','179','933',413,'Retail Sale Id 1626934',3101.28,0.00,0.00,5.46,278.46,'2022-03-02 12:37:08','',''),(2634260,'1','179','933',413,'Retail Sale Id 1626935',1136.00,0.00,0.00,2.00,102.00,'2022-03-02 12:55:32','',''),(2634261,'1','179','933',413,'Retail Sale Id 1626936',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 13:09:11','',''),(2634262,'1','179','933',413,'Retail Sale Id 1626937',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 13:10:28','',''),(2634263,'1','179','933',413,'Retail Sale Id 1626938',3408.00,0.00,0.00,6.00,306.00,'2022-03-02 15:01:20','',''),(2634264,'1','179','933',413,'Retail Sale Id 1626939',7100.00,0.00,0.00,12.50,637.50,'2022-03-02 19:20:16','',''),(2634265,'1','179','933',413,'Retail Sale Id 1626940',40044.00,0.00,0.00,70.50,3595.50,'2022-03-02 19:23:15','',''),(2634266,'1','179','933',413,'Retail Sale Id 1626942',32092.00,0.00,0.00,56.50,2881.50,'2022-03-02 19:26:07','',''),(2634267,'1','179','933',413,'Retail Sale Id 1626943',1704.00,0.00,0.00,3.00,153.00,'2022-03-02 19:26:51','',''),(2634268,'1','179','933',413,'Retail Sale Id 1626944',20998.96,0.00,0.00,36.97,1885.47,'2022-03-02 19:28:40','',''),(2634269,'1','179','933',413,'Retail Sale Id 1626945',3998.72,0.00,0.00,7.04,359.04,'2022-03-03 08:15:13','',''),(2634270,'1','179','933',413,'Retail Sale Id 1626946',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 08:16:02','',''),(2634271,'1','179','933',413,'Retail Sale Id 1626947',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 12:39:46','',''),(2634272,'1','179','933',413,'Retail Sale Id 1626948',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 12:43:14','',''),(2634273,'1','179','933',413,'Retail Sale Id 1626949',1999.36,0.00,0.00,3.52,179.52,'2022-03-03 12:55:48','',''),(2634274,'1','179','933',413,'Retail Sale Id 1626950',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 12:56:33','',''),(2634275,'1','179','933',413,'Retail Sale Id 1626951',2499.20,0.00,0.00,4.40,224.40,'2022-03-03 13:07:20','',''),(2634276,'1','179','933',413,'Retail Sale Id 1626952',1499.52,0.00,0.00,2.64,134.64,'2022-03-03 13:36:43','',''),(2634277,'1','179','933',413,'Retail Sale Id 1626953',1499.52,0.00,0.00,2.64,134.64,'2022-03-03 14:37:32','',''),(2634278,'1','179','933',413,'Retail Sale Id 1626954',55096.00,0.00,0.00,97.00,4947.00,'2022-03-03 14:41:54','',''),(2634279,'1','179','933',413,'Retail Sale Id 1626955',11502.00,0.00,0.00,20.25,1032.75,'2022-03-03 14:43:24','',''),(2634280,'1','179','933',413,'Retail Sale Id 1626956',5680.00,0.00,0.00,10.00,510.00,'2022-03-03 14:44:26','',''),(2634281,'1','179','933',413,'Retail Sale Id 1626958',1499.52,0.00,0.00,2.64,134.64,'2022-03-03 15:09:26','',''),(2634282,'1','179','933',413,'Retail Sale Id 1626959',2840.00,0.00,0.00,5.00,255.00,'2022-03-03 15:10:22','',''),(2634283,'1','179','933',413,'Retail Sale Id 1626960',1499.52,0.00,0.00,2.64,134.64,'2022-03-03 15:20:12','',''),(2634284,'1','179','933',413,'Retail Sale Id 1626960',2999.04,0.00,0.00,5.28,269.28,'2022-03-03 15:20:12','',''),(2634285,'1','179','933',413,'Retail Sale Id 1626961',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 15:35:29','',''),(2634286,'1','179','933',413,'Retail Sale Id 1626962',7100.00,0.00,0.00,12.50,637.50,'2022-03-03 15:58:26','',''),(2634287,'1','179','933',413,'Retail Sale Id 1626963',14001.20,0.00,0.00,24.65,1257.15,'2022-03-03 16:32:56','',''),(2634288,'1','179','933',413,'Retail Sale Id 1626964',1198.48,0.00,0.00,2.11,107.61,'2022-03-03 16:34:14','',''),(2634289,'1','179','933',413,'Retail Sale Id 1626965',999.68,0.00,0.00,1.76,89.76,'2022-03-03 16:49:28','',''),(2634290,'1','179','933',413,'Retail Sale Id 1626967',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 16:57:25','',''),(2634291,'1','179','933',413,'Retail Sale Id 1626968',18198.72,0.00,0.00,32.04,1634.04,'2022-03-03 19:24:26','',''),(2634292,'1','179','933',413,'Retail Sale Id 1626968',22720.00,0.00,0.00,40.00,2040.00,'2022-03-03 19:24:26','',''),(2634293,'1','179','933',413,'Retail Sale Id 1626969',7100.00,0.00,0.00,12.50,637.50,'2022-03-03 19:30:27','',''),(2634294,'1','179','933',413,'Return of Retail Sale Id 1626969',0.00,7100.00,12.50,0.00,-637.50,'2022-03-03 19:31:48','',''),(2634295,'1','179','933',413,'Retail Sale Id 1626970',5680.00,0.00,0.00,10.00,510.00,'2022-03-03 19:32:17','',''),(2634296,'1','179','933',413,'Retail Sale Id 1626971',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 19:51:01','',''),(2634297,'1','179','933',413,'Retail Sale Id 1626972',3408.00,0.00,0.00,6.00,306.00,'2022-03-03 19:52:21','',''),(2634298,'1','179','933',413,'Retail Sale Id 1626973',1704.00,0.00,0.00,3.00,153.00,'2022-03-03 19:59:17','',''),(2634299,'1','179','933',413,'Retail Sale Id 1626974',2840.00,0.00,0.00,5.00,255.00,'2022-03-04 08:25:56','',''),(2634300,'1','179','933',413,'Retail Sale Id 1626975',2999.04,0.00,0.00,5.28,269.28,'2022-03-04 08:28:43','',''),(2634301,'1','179','933',413,'Retail Sale Id 1626976',3408.00,0.00,0.00,6.00,306.00,'2022-03-04 08:30:28','',''),(2634302,'1','179','933',413,'Retail Sale Id 1626977',2840.00,0.00,0.00,5.00,255.00,'2022-03-04 08:36:51','',''),(2634303,'1','179','933',413,'Retail Sale Id 1626978',3408.00,0.00,0.00,6.00,306.00,'2022-03-04 09:01:15','',''),(2634304,'1','179','933',413,'Retail Sale Id 1626979',3408.00,0.00,0.00,6.00,306.00,'2022-03-04 09:02:38','',''),(2634305,'1','179','933',413,'Retail Sale Id 1626980',568.00,0.00,0.00,1.00,51.00,'2022-03-04 09:15:04','',''),(2634306,'1','179','933',413,'Retail Sale Id 1626982',21328.40,0.00,0.00,37.55,1915.05,'2022-03-04 18:39:56','',''),(2634307,'1','179','933',413,'Retail Sale Id 1626982',94856.00,0.00,0.00,167.00,8517.00,'2022-03-04 18:39:56','',''),(2634308,'1','179','933',413,'Retail Sale Id 1626983',7100.00,0.00,0.00,12.50,637.50,'2022-03-04 18:47:33','',''),(2634309,'1','179','933',413,'Retail Sale Id 1626984',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 18:48:39','',''),(2634310,'1','179','933',413,'Retail Sale Id 1626985',3408.00,0.00,0.00,6.00,306.00,'2022-03-04 19:20:37','',''),(2634311,'1','179','933',413,'Retail Sale Id 1626986',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 19:24:29','',''),(2634312,'1','179','933',413,'Retail Sale Id 1626986',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 19:24:29','',''),(2634313,'1','179','933',413,'Return of Retail Sale Id 1626986',0.00,1704.00,3.00,0.00,-153.00,'2022-03-04 19:32:26','',''),(2634314,'1','179','933',413,'Return of Retail Sale Id 1626986',0.00,1704.00,3.00,0.00,-153.00,'2022-03-04 19:32:26','',''),(2634315,'1','179','933',413,'Retail Sale Id 1626987',1704.00,0.00,0.00,3.00,153.00,'2022-03-04 19:33:59','',''),(2634316,'1','179','933',413,'Return of Retail Sale Id 1626979',0.00,3408.00,6.00,0.00,-306.00,'2022-03-04 20:14:50','',''),(2634317,'1','179','933',413,'Retail Sale Id 1626988',658.88,0.00,0.00,1.16,59.16,'2022-03-04 20:15:42','',''),(2634318,'1','179','933',413,'Retail Sale Id 1626989',999.68,0.00,0.00,1.76,89.76,'2022-03-05 08:55:38','',''),(2634319,'1','179','933',413,'Retail Sale Id 1626989',13916.00,0.00,0.00,24.50,1249.50,'2022-03-05 08:55:38','',''),(2634320,'1','179','933',413,'Retail Sale Id 1626990',3998.72,0.00,0.00,7.04,359.04,'2022-03-05 08:57:26','',''),(2634321,'1','179','933',413,'Retail Sale Id 1626991',4998.40,0.00,0.00,8.80,448.80,'2022-03-05 09:06:37','',''),(2634322,'1','179','933',413,'Retail Sale Id 1626992',14200.00,0.00,0.00,25.00,1275.00,'2022-03-05 09:19:44','',''),(2634323,'1','179','933',413,'Retail Sale Id 1626993',999.68,0.00,0.00,1.76,89.76,'2022-03-05 11:17:35','',''),(2634324,'1','179','933',413,'Retail Sale Id 1626994',2999.04,0.00,0.00,5.28,269.28,'2022-03-05 11:20:02','',''),(2634325,'1','179','933',413,'Retail Sale Id 1626995',1198.48,0.00,0.00,2.11,107.61,'2022-03-05 11:20:37','',''),(2634326,'1','179','933',413,'Retail Sale Id 1626997',10002.48,0.00,0.00,17.61,898.11,'2022-03-05 12:03:51','',''),(2634327,'1','179','933',413,'Retail Sale Id 1626997',50552.00,0.00,0.00,89.00,4539.00,'2022-03-05 12:03:51','',''),(2634328,'1','179','933',413,'Retail Sale Id 1626998',5112.00,0.00,0.00,9.00,459.00,'2022-03-05 12:18:51','',''),(2634329,'1','179','933',413,'Retail Sale Id 1626999',7798.64,0.00,0.00,13.73,700.23,'2022-03-05 14:36:53','',''),(2634330,'1','179','933',413,'Retail Sale Id 1626999',50268.00,0.00,0.00,88.50,4513.50,'2022-03-05 14:36:53','',''),(2634331,'1','179','933',413,'Retail Sale Id 1627000',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 14:41:48','',''),(2634332,'1','179','933',413,'Retail Sale Id 1627001',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 14:47:49','',''),(2634333,'1','179','933',413,'Retail Sale Id 1627002',999.68,0.00,0.00,1.76,89.76,'2022-03-05 14:57:07','',''),(2634334,'1','179','933',413,'Retail Sale Id 1627003',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 15:10:18','',''),(2634335,'1','179','933',413,'Retail Sale Id 1627004',6248.00,0.00,0.00,11.00,561.00,'2022-03-05 15:16:58','',''),(2634336,'1','179','933',413,'Retail Sale Id 1627005',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 15:19:49','',''),(2634337,'1','179','933',413,'Retail Sale Id 1627006',2840.00,0.00,0.00,5.00,255.00,'2022-03-05 15:31:35','',''),(2634338,'1','179','933',413,'Retail Sale Id 1627007',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 16:28:14','',''),(2634339,'1','179','933',413,'Retail Sale Id 1627008',4998.40,0.00,0.00,8.80,448.80,'2022-03-05 16:47:00','',''),(2634340,'1','179','933',413,'Retail Sale Id 1627008',9656.00,0.00,0.00,17.00,867.00,'2022-03-05 16:47:00','',''),(2634341,'1','179','933',413,'Retail Sale Id 1627009',4998.40,0.00,0.00,8.80,448.80,'2022-03-05 16:55:04','',''),(2634342,'1','179','933',413,'Retail Sale Id 1627010',2840.00,0.00,0.00,5.00,255.00,'2022-03-05 16:56:12','',''),(2634343,'1','179','933',413,'Retail Sale Id 1627011',2300.40,0.00,0.00,4.05,206.55,'2022-03-05 17:06:02','',''),(2634344,'1','179','933',413,'Retail Sale Id 1627012',1499.52,0.00,0.00,2.64,134.64,'2022-03-05 17:14:24','',''),(2634345,'1','179','933',413,'Retail Sale Id 1627013',2840.00,0.00,0.00,5.00,255.00,'2022-03-05 17:15:41','',''),(2634346,'1','179','933',413,'Retail Sale Id 1627014',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 17:28:29','',''),(2634347,'1','179','933',413,'Retail Sale Id 1627015',2840.00,0.00,0.00,5.00,255.00,'2022-03-05 17:30:04','',''),(2634348,'1','179','933',413,'Retail Sale Id 1627016',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 17:44:36','',''),(2634349,'1','179','933',413,'Retail Sale Id 1627017',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 17:46:34','',''),(2634350,'1','179','933',413,'Retail Sale Id 1627018',7100.00,0.00,0.00,12.50,637.50,'2022-03-05 18:00:31','',''),(2634351,'1','179','933',413,'Retail Sale Id 1627019',2999.04,0.00,0.00,5.28,269.28,'2022-03-05 18:02:12','',''),(2634352,'1','179','933',413,'Retail Sale Id 1627020',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 18:15:08','',''),(2634353,'1','179','933',413,'Retail Sale Id 1627021',999.68,0.00,0.00,1.76,89.76,'2022-03-05 18:20:39','',''),(2634354,'1','179','933',413,'Retail Sale Id 1627022',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 18:23:04','',''),(2634355,'1','179','933',413,'Retail Sale Id 1627023',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 18:35:05','',''),(2634356,'1','179','933',413,'Retail Sale Id 1627024',2272.00,0.00,0.00,4.00,204.00,'2022-03-05 19:08:47','',''),(2634357,'1','179','933',413,'Retail Sale Id 1627026',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 19:09:41','',''),(2634358,'1','179','933',413,'Retail Sale Id 1627028',3408.00,0.00,0.00,6.00,306.00,'2022-03-05 19:11:25','',''),(2634359,'1','179','933',413,'Retail Sale Id 1627029',1704.00,0.00,0.00,3.00,153.00,'2022-03-05 19:21:22','',''),(2634360,'1','179','933',413,'Retail Sale Id 1627030',73840.00,0.00,0.00,130.00,6630.00,'2022-03-06 11:37:28','',''),(2634361,'1','179','933',413,'Retail Sale Id 1627031',1704.00,0.00,0.00,3.00,153.00,'2022-03-06 13:02:59','',''),(2634362,'1','179','933',413,'Retail Sale Id 1627032',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 13:07:25','',''),(2634363,'1','179','933',413,'Retail Sale Id 1627033',53108.00,0.00,0.00,93.50,4768.50,'2022-03-06 17:00:52','',''),(2634364,'1','179','933',413,'Retail Sale Id 1627034',19198.40,0.00,0.00,33.80,1723.80,'2022-03-06 17:04:03','',''),(2634365,'1','179','933',413,'Retail Sale Id 1627035',1704.00,0.00,0.00,3.00,153.00,'2022-03-06 17:10:47','',''),(2634366,'1','179','933',413,'Retail Sale Id 1627036',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 17:16:30','',''),(2634367,'1','179','933',413,'Retail Sale Id 1627037',8804.00,0.00,0.00,15.50,790.50,'2022-03-06 19:19:07','',''),(2634368,'1','179','933',413,'Retail Sale Id 1627038',13802.40,0.00,0.00,24.30,1239.30,'2022-03-06 19:26:56','',''),(2634369,'1','179','933',413,'Retail Sale Id 1627038',15336.00,0.00,0.00,27.00,1377.00,'2022-03-06 19:26:56','',''),(2634370,'1','179','933',413,'Retail Sale Id 1627039',477.12,0.00,0.00,0.84,42.84,'2022-03-06 19:29:36','',''),(2634371,'1','179','933',413,'Retail Sale Id 1627040',3408.00,0.00,0.00,6.00,306.00,'2022-03-06 19:52:52','',''),(2634372,'1','179','933',413,'Retail Sale Id 1627041',1704.00,0.00,0.00,3.00,153.00,'2022-03-07 08:21:31','',''),(2634373,'1','179','933',413,'Retail Sale Id 1627042',3408.00,0.00,0.00,6.00,306.00,'2022-03-07 08:25:20','',''),(2634374,'1','179','933',413,'Retail Sale Id 1627043',1704.00,0.00,0.00,3.00,153.00,'2022-03-07 12:57:45','',''),(2634375,'1','179','933',413,'Retail Sale Id 1627044',26696.00,0.00,0.00,47.00,2397.00,'2022-03-07 12:59:19','',''),(2634376,'1','179','933',413,'Retail Sale Id 1627045',14501.04,0.00,0.00,25.53,1302.03,'2022-03-07 13:12:28','',''),(2634377,'1','179','933',413,'Retail Sale Id 1627046',30672.00,0.00,0.00,54.00,2754.00,'2022-03-07 13:14:40','',''),(2634378,'1','179','933',413,'Retail Sale Id 1627047',27502.56,0.00,0.00,48.42,2469.42,'2022-03-07 19:13:49','',''),(2634379,'1','179','933',413,'Retail Sale Id 1627048',9940.00,0.00,0.00,17.50,892.50,'2022-03-07 19:17:00','',''),(2634380,'1','179','933',413,'Retail Sale Id 1627049',7100.00,0.00,0.00,12.50,637.50,'2022-03-07 19:18:24','',''),(2634381,'1','179','933',413,'Retail Sale Id 1627050',31001.44,0.00,0.00,54.58,2783.58,'2022-03-07 19:27:51','',''),(2634382,'1','179','933',413,'Retail Sale Id 1627050',104796.00,0.00,0.00,184.50,9409.50,'2022-03-07 19:27:51','',''),(2634383,'1','179','933',413,'Retail Sale Id 1627051',1198.48,0.00,0.00,2.11,107.61,'2022-03-07 19:36:01','',''),(2634384,'1','179','933',413,'Retail Sale Id 1627052',1198.48,0.00,0.00,2.11,107.61,'2022-03-07 19:54:30','',''),(2634385,'1','179','933',413,'Retail Sale Id 1627053',1704.00,0.00,0.00,3.00,153.00,'2022-03-07 19:55:21','',''),(2634386,'1','179','933',413,'Retail Sale Id 1627054',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 08:35:06','',''),(2634387,'1','179','933',413,'Retail Sale Id 1627055',2499.20,0.00,0.00,4.40,224.40,'2022-03-08 08:50:48','',''),(2634388,'1','179','933',413,'Retail Sale Id 1627055',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 08:50:48','',''),(2634389,'1','179','933',413,'Retail Sale Id 1627056',1704.00,0.00,0.00,3.00,153.00,'2022-03-08 09:14:36','',''),(2634390,'1','179','933',413,'Retail Sale Id 1627057',7100.00,0.00,0.00,12.50,637.50,'2022-03-08 09:59:00','',''),(2634391,'1','179','933',413,'Retail Sale Id 1627058',1704.00,0.00,0.00,3.00,153.00,'2022-03-08 10:03:58','',''),(2634392,'1','179','933',413,'Retail Sale Id 1627059',5680.00,0.00,0.00,10.00,510.00,'2022-03-08 10:08:09','',''),(2634393,'1','179','933',413,'Retail Sale Id 1627060',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 10:14:16','',''),(2634394,'1','179','933',413,'Retail Sale Id 1627061',1499.52,0.00,0.00,2.64,134.64,'2022-03-08 10:20:08','',''),(2634395,'1','179','933',413,'Retail Sale Id 1627062',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 10:56:38','',''),(2634396,'1','179','933',413,'Retail Sale Id 1627063',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 11:28:03','',''),(2634397,'1','179','933',413,'Retail Sale Id 1627064',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 11:43:04','',''),(2634398,'1','179','933',413,'Retail Sale Id 1627065',6248.00,0.00,0.00,11.00,561.00,'2022-03-08 12:23:56','',''),(2634399,'1','179','933',413,'Retail Sale Id 1627066',19397.20,0.00,0.00,34.15,1741.65,'2022-03-08 19:40:02','',''),(2634400,'1','179','933',413,'Retail Sale Id 1627067',99400.00,0.00,0.00,175.00,8925.00,'2022-03-08 19:44:09','',''),(2634401,'1','179','933',413,'Retail Sale Id 1627068',19999.28,0.00,0.00,35.21,1795.71,'2022-03-08 19:44:59','',''),(2634402,'1','179','933',413,'Retail Sale Id 1627069',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 19:45:47','',''),(2634403,'1','179','933',413,'Retail Sale Id 1627070',2999.04,0.00,0.00,5.28,269.28,'2022-03-08 20:22:12','',''),(2634404,'1','179','933',413,'Retail Sale Id 1627070',3408.00,0.00,0.00,6.00,306.00,'2022-03-08 20:22:12','',''),(2634405,'1','179','933',413,'Retail Sale Id 1627071',2840.00,0.00,0.00,5.00,255.00,'2022-03-08 20:36:35','',''),(2634406,'1','179','933',413,'Return of Retail Sale Id 1627070',0.00,2999.04,5.28,0.00,-269.28,'2022-03-09 08:02:40','',''),(2634407,'1','179','933',413,'Return of Retail Sale Id 1627070',0.00,3408.00,6.00,0.00,-306.00,'2022-03-09 08:02:40','',''),(2634408,'1','179','933',413,'Retail Sale Id 1627072',1863.04,0.00,0.00,3.28,167.28,'2022-03-09 08:03:26','',''),(2634409,'1','179','933',413,'Retail Sale Id 1627073',2999.04,0.00,0.00,5.28,269.28,'2022-03-09 08:06:15','',''),(2634410,'1','179','933',413,'Return of Retail Sale Id 1627067',0.00,99400.00,175.00,0.00,-8925.00,'2022-03-09 08:09:50','',''),(2634411,'1','179','933',413,'Retail Sale Id 1627074',65320.00,0.00,0.00,115.00,5865.00,'2022-03-09 08:10:35','',''),(2634412,'1','179','933',413,'Retail Sale Id 1627075',8500.00,0.00,0.00,12.50,8500.00,'2022-03-17 09:41:50','',''),(2634413,'1','179','933',413,'Retail Sale Id 1627076',8500.00,0.00,0.00,12.50,8500.00,'2022-03-17 09:42:30','',''),(2634414,'1','179','933',413,'Retail Sale Id 1627077',8500.00,0.00,0.00,12.50,8500.00,'2022-03-17 09:43:32','',''),(2634415,'1','179','933',413,'Retail Sale Id 1627078',4522.00,0.00,0.00,6.65,4522.00,'2022-03-17 09:44:12','',''),(2634416,'1','179','933',413,'Retail Sale Id 1627079',2040.00,0.00,0.00,3.00,2040.00,'2022-03-17 09:54:30','',''),(2634417,'1','179','933',413,'Retail Sale Id 1627080',4998.00,0.00,0.00,7.35,4998.00,'2022-03-17 10:27:28','',''),(2634418,'1','179','933',413,'Retail Sale Id 1627081',1802.00,0.00,0.00,2.65,1802.00,'2022-03-17 10:43:24','',''),(2634419,'1','179','933',413,'Retail Sale Id 1627082',3502.00,0.00,0.00,5.15,3502.00,'2022-03-17 10:48:51','',''),(2634420,'1','179','933',413,'Retail Sale Id 1627083',1502.80,0.00,0.00,2.21,1502.80,'2022-03-17 10:57:43','',''),(2634421,'1','179','933',413,'Retail Sale Id 1627084',999.60,0.00,0.00,1.47,999.60,'2022-03-17 11:04:25','',''),(2634422,'1','179','933',413,'Retail Sale Id 1627085',3998.40,0.00,0.00,5.88,3998.40,'2022-03-17 11:28:55','',''),(2634423,'1','179','933',413,'Retail Sale Id 1627086',2040.00,0.00,0.00,3.00,2040.00,'2022-03-17 12:04:42','',''),(2634424,'1','179','933',413,'Retail Sale Id 1627087',2040.00,0.00,0.00,3.00,2040.00,'2022-03-17 12:06:48','',''),(2634425,'1','179','933',413,'Retail Sale Id 1627088',3998.40,0.00,0.00,5.88,3998.40,'2022-03-17 12:29:06','',''),(2634426,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,3121200.00,5100.00,0.00,0.00,'2022-03-17 16:29:10','',''),(2634427,'1','179',NULL,413,'Reception corrector for bridging 132514',0.00,0.00,0.00,5100.00,0.00,'2022-03-17 16:30:09','',''),(2634428,'1','179','933',413,'Received from bridging 132514',0.00,0.00,5100.00,0.00,0.00,'2022-03-17 16:30:09','',''),(2634429,'1','179','933',413,'Retail Sale Id 1627089',36040.00,0.00,0.00,53.00,3604.00,'2022-03-17 17:18:00','',''),(2634430,'1','179','933',413,'Retail Sale Id 1627090',12022.40,0.00,0.00,17.68,1202.24,'2022-03-17 17:18:47','',''),(2634431,'1','179','933',413,'Retail Sale Id 1627091',4080.00,0.00,0.00,6.00,408.00,'2022-03-17 17:26:05','',''),(2634432,'1','179','933',413,'Retail Sale Id 1627092',6800.00,0.00,0.00,10.00,680.00,'2022-03-17 17:34:55','',''),(2634433,'1','179','933',413,'Retail Sale Id 1627093',1502.80,0.00,0.00,2.21,150.28,'2022-03-17 17:37:09','',''),(2634434,'1','179','933',413,'Retail Sale Id 1627094',3400.00,0.00,0.00,5.00,340.00,'2022-03-17 17:39:36','',''),(2634435,'1','179','933',413,'Retail Sale Id 1627095',6800.00,0.00,0.00,10.00,680.00,'2022-03-17 17:41:06','',''),(2634436,'1','179','933',413,'Retail Sale Id 1627096',5440.00,0.00,0.00,8.00,544.00,'2022-03-17 17:50:47','',''),(2634437,'1','179','933',413,'Retail Sale Id 1627097',2040.00,0.00,0.00,3.00,204.00,'2022-03-17 18:17:17','',''),(2634438,'1','179','933',413,'Retail Sale Id 1627098',999.60,0.00,0.00,1.47,99.96,'2022-03-17 18:22:10','',''),(2634439,'1','179','933',413,'Retail Sale Id 1627099',2998.80,0.00,0.00,4.41,299.88,'2022-03-17 18:34:19','',''),(2634440,'1','179','933',413,'Retail Sale Id 1627100',14200.00,0.00,0.00,25.00,14200.00,'2022-03-17 18:39:34','',''),(2634441,'1','179','933',413,'Retail Sale Id 1627101',1999.20,0.00,0.00,2.94,1999.20,'2022-03-17 18:43:20','',''),(2634442,'1','179','933',413,'Retail Sale Id 1627101',6120.00,0.00,0.00,9.00,6120.00,'2022-03-17 18:43:20','',''),(2634443,'1','179','933',413,'Retail Sale Id 1627102',6800.00,0.00,0.00,10.00,6800.00,'2022-03-17 18:46:30','',''),(2634444,'1','179','933',413,'Retail Sale Id 1627103',8500.00,0.00,0.00,12.50,8500.00,'2022-03-17 19:20:03','',''),(2634445,'1','179','933',413,'Retail Sale Id 1627104',1502.80,0.00,0.00,2.21,1502.80,'2022-03-17 19:20:58','',''),(2634446,'1','179','933',413,'Retail Sale Id 1627105',1897.20,0.00,0.00,2.79,1897.20,'2022-03-17 19:32:53','',''),(2634447,'1','179','933',413,'Retail Sale Id 1627106',8500.00,0.00,0.00,12.50,8500.00,'2022-03-18 10:02:31','',''),(2634448,'1','179','933',413,'Retail Sale Id 1627107',999.60,0.00,0.00,1.47,999.60,'2022-03-18 16:57:12','',''),(2634449,'1','179','933',413,'Retail Sale Id 1627107',1999.20,0.00,0.00,2.94,1999.20,'2022-03-18 16:57:12','',''),(2634450,'1','179','933',413,'Retail Sale Id 1627108',2040.00,0.00,0.00,3.00,2040.00,'2022-03-18 16:58:07','',''),(2634451,'1','179','933',413,'Retail Sale Id 1627109',4080.00,0.00,0.00,6.00,4080.00,'2022-03-18 17:09:43','',''),(2634452,'1','179','933',413,'Retail Sale Id 1627110',2040.00,0.00,0.00,3.00,2040.00,'2022-03-18 17:15:40','',''),(2634453,'1','179','933',413,'Retail Sale Id 1627111',15000.80,0.00,0.00,22.06,15000.80,'2022-03-18 17:24:12','',''),(2634454,'1','179','933',413,'Retail Sale Id 1627111',96492.00,0.00,0.00,141.90,96492.00,'2022-03-18 17:24:12','',''),(2634455,'1','179','933',413,'Retail Sale Id 1627112',9520.00,0.00,0.00,14.00,9520.00,'2022-03-18 17:37:32','',''),(2634456,'1','179','933',413,'Retail Sale Id 1627113',3400.00,0.00,0.00,5.00,3400.00,'2022-03-18 17:38:48','',''),(2634457,'1','179','933',413,'Retail Sale Id 1627114',2040.00,0.00,0.00,3.00,2040.00,'2022-03-18 17:40:49','',''),(2634458,'1','179','933',413,'Retail Sale Id 1627115',4080.00,0.00,0.00,6.00,4080.00,'2022-03-18 17:41:43','',''),(2634459,'1','179','933',413,'Retail Sale Id 1627116',5440.00,0.00,0.00,8.00,5440.00,'2022-03-18 17:43:54','',''),(2634460,'1','179','933',413,'Retail Sale Id 1627117',1360.00,0.00,0.00,2.00,1360.00,'2022-03-18 17:48:55','',''),(2634461,'1','179','933',413,'Retail Sale Id 1627118',2040.00,0.00,0.00,3.00,2040.00,'2022-03-18 17:58:31','',''),(2634462,'1','179','933',413,'Retail Sale Id 1627118',4080.00,0.00,0.00,6.00,4080.00,'2022-03-18 17:58:31','',''),(2634463,'1','179','933',413,'Retail Sale Id 1627119',1360.00,0.00,0.00,2.00,1360.00,'2022-03-18 18:48:59','',''),(2634464,'1','179','933',413,'Retail Sale Id 1627121',2040.00,0.00,0.00,3.00,2040.00,'2022-03-18 18:52:07','',''),(2634465,'1','179','933',413,'Retail Sale Id 1627122',1502.80,0.00,0.00,2.21,1502.80,'2022-03-18 19:19:01','',''),(2634466,'1','179','933',413,'Retail Sale Id 1627123',4998.00,0.00,0.00,7.35,4998.00,'2022-03-19 10:16:40','',''),(2634467,'1','179','933',413,'Retail Sale Id 1627124',4080.00,0.00,0.00,6.00,4080.00,'2022-03-19 10:24:24','',''),(2634468,'1','179','933',413,'Retail Sale Id 1627125',4080.00,0.00,0.00,6.00,4080.00,'2022-03-19 10:31:31','',''),(2634469,'1','179','933',413,'Retail Sale Id 1627126',3400.00,0.00,0.00,5.00,3400.00,'2022-03-19 10:32:33','',''),(2634470,'1','179','933',413,'Retail Sale Id 1627127',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 10:35:17','',''),(2634471,'1','179','933',413,'Retail Sale Id 1627128',4080.00,0.00,0.00,6.00,4080.00,'2022-03-19 10:36:12','',''),(2634472,'1','179','933',413,'Retail Sale Id 1627129',6997.20,0.00,0.00,10.29,6997.20,'2022-03-19 10:43:01','',''),(2634473,'1','179','933',413,'Retail Sale Id 1627130',1360.00,0.00,0.00,2.00,1360.00,'2022-03-19 10:51:29','',''),(2634474,'1','179','933',413,'Retail Sale Id 1627131',12580.00,0.00,0.00,18.50,12580.00,'2022-03-19 11:08:22','',''),(2634475,'1','179','933',413,'Retail Sale Id 1627132',3998.40,0.00,0.00,5.88,3998.40,'2022-03-19 11:12:43','',''),(2634476,'1','179','933',413,'Retail Sale Id 1627133',999.60,0.00,0.00,1.47,999.60,'2022-03-19 11:22:53','',''),(2634477,'1','179','933',413,'Retail Sale Id 1627134',5997.60,0.00,0.00,8.82,5997.60,'2022-03-19 11:46:46','',''),(2634478,'1','179','933',413,'Retail Sale Id 1627135',3400.00,0.00,0.00,5.00,3400.00,'2022-03-19 11:48:18','',''),(2634479,'1','179','933',413,'Retail Sale Id 1627136',1360.00,0.00,0.00,2.00,1360.00,'2022-03-19 11:49:53','',''),(2634480,'1','179','933',413,'Retail Sale Id 1627138',1502.80,0.00,0.00,2.21,1502.80,'2022-03-19 11:52:44','',''),(2634481,'1','179','933',413,'Retail Sale Id 1627139',999.60,0.00,0.00,1.47,999.60,'2022-03-19 11:55:30','',''),(2634482,'1','179','933',413,'Retail Sale Id 1627140',1502.80,0.00,0.00,2.21,1502.80,'2022-03-19 12:08:52','',''),(2634483,'1','179','933',413,'Retail Sale Id 1627141',3998.40,0.00,0.00,5.88,3998.40,'2022-03-19 12:14:07','',''),(2634484,'1','179','933',413,'Retail Sale Id 1627142',4080.00,0.00,0.00,6.00,4080.00,'2022-03-19 12:29:21','',''),(2634485,'1','179','933',413,'Retail Sale Id 1627143',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 12:30:59','',''),(2634486,'1','179','933',413,'Retail Sale Id 1627144',3400.00,0.00,0.00,5.00,3400.00,'2022-03-19 12:32:06','',''),(2634487,'1','179','933',413,'Retail Sale Id 1627145',3400.00,0.00,0.00,5.00,3400.00,'2022-03-19 12:32:58','',''),(2634488,'1','179','933',413,'Retail Sale Id 1627146',1999.20,0.00,0.00,2.94,1999.20,'2022-03-19 12:33:55','',''),(2634489,'1','179','933',413,'Retail Sale Id 1627147',1802.00,0.00,0.00,2.65,1802.00,'2022-03-19 12:43:29','',''),(2634490,'1','179','933',413,'Retail Sale Id 1627148',999.60,0.00,0.00,1.47,999.60,'2022-03-19 13:01:54','',''),(2634491,'1','179','933',413,'Retail Sale Id 1627149',1360.00,0.00,0.00,2.00,1360.00,'2022-03-19 13:10:54','',''),(2634492,'1','179','933',413,'Retail Sale Id 1627150',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 13:15:06','',''),(2634493,'1','179','933',413,'Retail Sale Id 1627151',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 13:26:44','',''),(2634494,'1','179','933',413,'Retail Sale Id 1627152',3400.00,0.00,0.00,5.00,3400.00,'2022-03-19 13:30:20','',''),(2634495,'1','179','933',413,'Retail Sale Id 1627153',2720.00,0.00,0.00,4.00,2720.00,'2022-03-19 13:43:03','',''),(2634496,'1','179','933',413,'Retail Sale Id 1627154',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 14:21:03','',''),(2634497,'1','179','933',413,'Retail Sale Id 1627155',6997.20,0.00,0.00,10.29,6997.20,'2022-03-19 14:26:07','',''),(2634498,'1','179','933',413,'Retail Sale Id 1627156',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 14:59:36','',''),(2634499,'1','179','933',413,'Retail Sale Id 1627157',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 15:04:33','',''),(2634500,'1','179','933',413,'Retail Sale Id 1627158',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 15:13:06','',''),(2634501,'1','179','933',413,'Retail Sale Id 1627159',1360.00,0.00,0.00,2.00,1360.00,'2022-03-19 15:31:35','',''),(2634502,'1','179','933',413,'Retail Sale Id 1627160',4080.00,0.00,0.00,6.00,4080.00,'2022-03-19 15:35:03','',''),(2634503,'1','179','933',413,'Retail Sale Id 1627161',5501.20,0.00,0.00,8.09,5501.20,'2022-03-19 15:42:54','',''),(2634504,'1','179','933',413,'Retail Sale Id 1627161',15300.00,0.00,0.00,22.50,15300.00,'2022-03-19 15:42:54','',''),(2634505,'1','179','933',413,'Retail Sale Id 1627162',1502.80,0.00,0.00,2.21,1502.80,'2022-03-19 16:49:27','',''),(2634506,'1','179','933',413,'Retail Sale Id 1627163',1999.20,0.00,0.00,2.94,1999.20,'2022-03-19 16:51:51','',''),(2634507,'1','179','933',413,'Retail Sale Id 1627164',1360.00,0.00,0.00,2.00,1360.00,'2022-03-19 16:52:52','',''),(2634508,'1','179','933',413,'Retail Sale Id 1627165',4998.00,0.00,0.00,7.35,4998.00,'2022-03-19 17:10:57','',''),(2634509,'1','179','933',413,'Retail Sale Id 1627166',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 17:13:07','',''),(2634510,'1','179','933',413,'Retail Sale Id 1627168',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 17:20:27','',''),(2634511,'1','179','933',413,'Retail Sale Id 1627169',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 17:21:04','',''),(2634512,'1','179','933',413,'Retail Sale Id 1627172',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 17:42:23','',''),(2634513,'1','179','933',413,'Retail Sale Id 1627172',2862.80,0.00,0.00,4.21,2862.80,'2022-03-19 17:42:23','',''),(2634514,'1','179','933',413,'Retail Sale Id 1627173',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 17:43:21','',''),(2634515,'1','179','933',413,'Retail Sale Id 1627174',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 17:46:25','',''),(2634516,'1','179','933',413,'Retail Sale Id 1627175',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 17:53:18','',''),(2634517,'1','179','933',413,'Retail Sale Id 1627176',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 17:56:25','',''),(2634518,'1','179','933',413,'Retail Sale Id 1627177',15497.20,0.00,0.00,22.79,15497.20,'2022-03-19 18:03:20','',''),(2634519,'1','179','933',413,'Retail Sale Id 1627178',802.40,0.00,0.00,1.18,802.40,'2022-03-19 18:48:11','',''),(2634520,'1','179','933',413,'Retail Sale Id 1627179',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 19:00:07','',''),(2634521,'1','179','933',413,'Retail Sale Id 1627180',6800.00,0.00,0.00,10.00,6800.00,'2022-03-19 19:17:48','',''),(2634522,'1','179','933',413,'Retail Sale Id 1627181',5440.00,0.00,0.00,8.00,5440.00,'2022-03-19 19:25:59','',''),(2634523,'1','179','933',413,'Retail Sale Id 1627182',999.60,0.00,0.00,1.47,999.60,'2022-03-19 19:33:40','',''),(2634524,'1','179','933',413,'Retail Sale Id 1627182',3400.00,0.00,0.00,5.00,3400.00,'2022-03-19 19:33:40','',''),(2634525,'1','179','933',413,'Retail Sale Id 1627183',1999.20,0.00,0.00,2.94,1999.20,'2022-03-19 19:38:09','',''),(2634526,'1','179','933',413,'Retail Sale Id 1627184',8500.00,0.00,0.00,12.50,8500.00,'2022-03-19 19:49:48','',''),(2634527,'1','179','933',413,'Retail Sale Id 1627185',2040.00,0.00,0.00,3.00,2040.00,'2022-03-19 20:10:45','',''),(2634528,'1','179','933',413,'Retail Sale Id 1627186',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 08:16:27','',''),(2634529,'1','179','933',413,'Retail Sale Id 1627187',1700.00,0.00,0.00,2.50,1700.00,'2022-03-20 08:35:09','',''),(2634530,'1','179','933',413,'Retail Sale Id 1627187',6120.00,0.00,0.00,9.00,6120.00,'2022-03-20 08:35:09','',''),(2634531,'1','179','933',413,'Retail Sale Id 1627188',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 08:42:59','',''),(2634532,'1','179','933',413,'Retail Sale Id 1627189',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 08:58:47','',''),(2634533,'1','179','933',413,'Retail Sale Id 1627190',2998.80,0.00,0.00,4.41,2998.80,'2022-03-20 09:16:59','',''),(2634534,'1','179','933',413,'Retail Sale Id 1627191',1999.20,0.00,0.00,2.94,1999.20,'2022-03-20 09:26:27','',''),(2634535,'1','179','933',413,'Retail Sale Id 1627192',6800.00,0.00,0.00,10.00,6800.00,'2022-03-20 10:09:30','',''),(2634536,'1','179','933',413,'Retail Sale Id 1627193',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 10:23:03','',''),(2634537,'1','179','933',413,'Retail Sale Id 1627194',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 10:41:38','',''),(2634538,'1','179','933',413,'Retail Sale Id 1627195',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 10:44:51','',''),(2634539,'1','179','933',413,'Retail Sale Id 1627196',3400.00,0.00,0.00,5.00,3400.00,'2022-03-20 11:07:46','',''),(2634540,'1','179','933',413,'Retail Sale Id 1627197',8500.00,0.00,0.00,12.50,8500.00,'2022-03-20 11:09:32','',''),(2634541,'1','179','933',413,'Retail Sale Id 1627198',3998.40,0.00,0.00,5.88,3998.40,'2022-03-20 11:10:23','',''),(2634542,'1','179','933',413,'Retail Sale Id 1627199',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 11:30:48','',''),(2634543,'1','179','933',413,'Retail Sale Id 1627200',1700.00,0.00,0.00,2.50,1700.00,'2022-03-20 11:33:44','',''),(2634544,'1','179','933',413,'Retail Sale Id 1627201',1502.80,0.00,0.00,2.21,1502.80,'2022-03-20 11:59:07','',''),(2634545,'1','179','933',413,'Retail Sale Id 1627202',1999.20,0.00,0.00,2.94,1999.20,'2022-03-20 12:00:40','',''),(2634546,'1','179','933',413,'Retail Sale Id 1627203',1196.80,0.00,0.00,1.76,1196.80,'2022-03-20 12:17:37','',''),(2634547,'1','179','933',413,'Retail Sale Id 1627204',1360.00,0.00,0.00,2.00,1360.00,'2022-03-20 12:25:30','',''),(2634548,'1','179','933',413,'Retail Sale Id 1627205',8500.00,0.00,0.00,12.50,8500.00,'2022-03-20 12:42:31','',''),(2634549,'1','179','933',413,'Retail Sale Id 1627206',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 12:49:00','',''),(2634550,'1','179','933',413,'Retail Sale Id 1627207',3400.00,0.00,0.00,5.00,3400.00,'2022-03-20 13:10:20','',''),(2634551,'1','179','933',413,'Retail Sale Id 1627208',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 14:14:34','',''),(2634552,'1','179','933',413,'Retail Sale Id 1627209',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 14:23:10','',''),(2634553,'1','179','933',413,'Retail Sale Id 1627210',8500.00,0.00,0.00,12.50,8500.00,'2022-03-20 14:30:34','',''),(2634554,'1','179','933',413,'Retail Sale Id 1627211',1999.20,0.00,0.00,2.94,1999.20,'2022-03-20 14:34:08','',''),(2634555,'1','179','933',413,'Retail Sale Id 1627212',2998.80,0.00,0.00,4.41,2998.80,'2022-03-20 14:43:54','',''),(2634556,'1','179','933',413,'Retail Sale Id 1627213',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 15:09:56','',''),(2634557,'1','179','933',413,'Retail Sale Id 1627214',2502.40,0.00,0.00,3.68,2502.40,'2022-03-20 15:40:28','',''),(2634558,'1','179','933',413,'Retail Sale Id 1627215',8500.00,0.00,0.00,12.50,8500.00,'2022-03-20 15:43:06','',''),(2634559,'1','179','933',413,'Return of Retail Sale Id 1627215',0.00,8500.00,12.50,0.00,-8500.00,'2022-03-20 15:43:42','',''),(2634560,'1','179','933',413,'Retail Sale Id 1627216',5997.60,0.00,0.00,8.82,5997.60,'2022-03-20 15:44:23','',''),(2634561,'1','179','933',413,'Retail Sale Id 1627217',999.60,0.00,0.00,1.47,999.60,'2022-03-20 15:52:47','',''),(2634562,'1','179','933',413,'Retail Sale Id 1627218',2720.00,0.00,0.00,4.00,2720.00,'2022-03-20 16:37:13','',''),(2634563,'1','179','933',413,'Retail Sale Id 1627219',999.60,0.00,0.00,1.47,999.60,'2022-03-20 16:38:49','',''),(2634564,'1','179','933',413,'Retail Sale Id 1627220',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 16:55:50','',''),(2634565,'1','179','933',413,'Retail Sale Id 1627221',4080.00,0.00,0.00,6.00,4080.00,'2022-03-20 17:06:19','',''),(2634566,'1','179','933',413,'Retail Sale Id 1627222',1999.20,0.00,0.00,2.94,1999.20,'2022-03-20 17:07:56','',''),(2634567,'1','179','933',413,'Retail Sale Id 1627223',6120.00,0.00,0.00,9.00,6120.00,'2022-03-20 17:13:12','',''),(2634568,'1','179','933',413,'Retail Sale Id 1627224',1700.00,0.00,0.00,2.50,1700.00,'2022-03-20 17:14:04','',''),(2634569,'1','179','933',413,'Retail Sale Id 1627225',7480.00,0.00,0.00,11.00,7480.00,'2022-03-20 17:18:55','',''),(2634570,'1','179','933',413,'Retail Sale Id 1627226',3998.40,0.00,0.00,5.88,3998.40,'2022-03-20 17:38:55','',''),(2634571,'1','179','933',413,'Retail Sale Id 1627227',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 17:55:33','',''),(2634572,'1','179','933',413,'Retail Sale Id 1627228',8500.00,0.00,0.00,12.50,8500.00,'2022-03-20 17:57:54','',''),(2634573,'1','179','933',413,'Retail Sale Id 1627229',6800.00,0.00,0.00,10.00,6800.00,'2022-03-20 18:07:26','',''),(2634574,'1','179','933',413,'Retail Sale Id 1627230',8500.00,0.00,0.00,12.50,8500.00,'2022-03-20 18:08:30','',''),(2634575,'1','179','933',413,'Retail Sale Id 1627232',4222.80,0.00,0.00,6.21,4222.80,'2022-03-20 18:22:32','',''),(2634576,'1','179','933',413,'Retail Sale Id 1627233',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 18:23:16','',''),(2634577,'1','179','933',413,'Return of Retail Sale Id 1627229',0.00,6800.00,10.00,0.00,-6800.00,'2022-03-20 18:24:11','',''),(2634578,'1','179','933',413,'Retail Sale Id 1627234',6800.00,0.00,0.00,10.00,6800.00,'2022-03-20 18:24:40','',''),(2634579,'1','179','933',413,'Retail Sale Id 1627235',2720.00,0.00,0.00,4.00,2720.00,'2022-03-20 18:25:15','',''),(2634580,'1','179','933',413,'Retail Sale Id 1627236',1802.00,0.00,0.00,2.65,1802.00,'2022-03-20 18:27:12','',''),(2634581,'1','179','933',413,'Retail Sale Id 1627237',802.40,0.00,0.00,1.18,802.40,'2022-03-20 18:31:00','',''),(2634582,'1','179','933',413,'Retail Sale Id 1627238',2502.40,0.00,0.00,3.68,2502.40,'2022-03-20 18:40:21','',''),(2634583,'1','179','933',413,'Retail Sale Id 1627239',1502.80,0.00,0.00,2.21,1502.80,'2022-03-20 18:45:18','',''),(2634584,'1','179','933',413,'Retail Sale Id 1627243',2040.00,0.00,0.00,3.00,2040.00,'2022-03-20 19:17:31','',''),(2634585,'1','179','933',413,'Retail Sale Id 1627243',3998.40,0.00,0.00,5.88,3998.40,'2022-03-20 19:17:31','',''),(2634586,'1','179','933',413,'Retail Sale Id 1627244',1999.20,0.00,0.00,2.94,1999.20,'2022-03-20 19:18:52','',''),(2634587,'1','179','933',413,'Retail Sale Id 1627245',1400.80,0.00,0.00,2.06,1400.80,'2022-03-20 19:19:34','',''),(2634588,'1','179','933',413,'Retail Sale Id 1627246',639.20,0.00,0.00,0.94,639.20,'2022-03-20 19:24:06','',''),(2634589,'1','179','933',413,'Retail Sale Id 1627247',999.60,0.00,0.00,1.47,999.60,'2022-03-21 08:28:19','',''),(2634590,'1','179','933',413,'Retail Sale Id 1627247',2040.00,0.00,0.00,3.00,2040.00,'2022-03-21 08:28:19','',''),(2634591,'1','179','933',413,'Retail Sale Id 1627248',2040.00,0.00,0.00,3.00,2040.00,'2022-03-21 08:53:20','',''),(2634592,'1','179','933',413,'Retail Sale Id 1627249',4080.00,0.00,0.00,6.00,4080.00,'2022-03-21 08:59:22','',''),(2634593,'1','179','933',413,'Retail Sale Id 1627250',2040.00,0.00,0.00,3.00,2040.00,'2022-03-21 09:16:59','',''),(2634594,'1','179','933',413,'Retail Sale Id 1627251',1700.00,0.00,0.00,2.50,1700.00,'2022-03-21 09:49:44','',''),(2634595,'1','179','933',413,'Retail Sale Id 1627252',2040.00,0.00,0.00,3.00,2040.00,'2022-03-21 10:09:30','',''),(2634596,'1','179','933',413,'Retail Sale Id 1627253',1020.00,0.00,0.00,1.50,1020.00,'2022-03-21 10:59:31','',''),(2634597,'1','179','933',413,'Retail Sale Id 1627254',4501.60,0.00,0.00,6.62,4501.60,'2022-03-21 13:05:43','',''),(2634598,'1','179','933',413,'Retail Sale Id 1627255',2040.00,0.00,0.00,3.00,2040.00,'2022-03-21 13:06:24','',''),(2634599,'1','179','933',413,'Retail Sale Id 1627256',8500.00,0.00,0.00,12.50,8500.00,'2022-03-21 18:03:36','',''),(2634600,'1','179','933',413,'Retail Sale Id 1627257',59840.00,0.00,0.00,88.00,59840.00,'2022-03-21 18:15:20','',''),(2634601,'1','179','933',413,'Retail Sale Id 1627258',14001.20,0.00,0.00,20.59,14001.20,'2022-03-21 18:16:51','',''),(2634602,'1','179','933',413,'Retail Sale Id 1627259',4080.00,0.00,0.00,6.00,4080.00,'2022-03-21 18:18:40','',''),(2634603,'1','179','933',413,'Retail Sale Id 1627260',2720.00,0.00,0.00,4.00,2720.00,'2022-03-21 18:20:31','',''),(2634604,'1','179','933',413,'Retail Sale Id 1627261',2040.00,0.00,0.00,3.00,2040.00,'2022-03-21 18:33:38','',''),(2634605,'1','179','933',413,'Retail Sale Id 1627262',8500.00,0.00,0.00,12.50,8500.00,'2022-03-21 18:38:26','',''),(2634606,'1','179','933',413,'Retail Sale Id 1627263',4080.00,0.00,0.00,6.00,4080.00,'2022-03-21 18:49:11','',''),(2634607,'1','179','933',413,'Retail Sale Id 1627264',1999.20,0.00,0.00,2.94,1999.20,'2022-03-21 19:19:27','',''),(2634608,'1','179','933',413,'Retail Sale Id 1627265',1999.20,0.00,0.00,2.94,1999.20,'2022-03-21 20:03:39','',''),(2634609,'1','179','933',413,'Retail Sale Id 1627266',4080.00,0.00,0.00,6.00,4080.00,'2022-03-22 09:18:12','',''),(2634610,'1','179','933',413,'Retail Sale Id 1627267',8500.00,0.00,0.00,12.50,8500.00,'2022-03-22 09:20:45','',''),(2634611,'1','179','933',413,'Retail Sale Id 1627268',9520.00,0.00,0.00,14.00,9520.00,'2022-03-22 09:42:10','',''),(2634612,'1','179','933',413,'Retail Sale Id 1627269',2040.00,0.00,0.00,3.00,2040.00,'2022-03-22 10:15:19','',''),(2634613,'1','179','933',413,'Retail Sale Id 1627270',3400.00,0.00,0.00,5.00,3400.00,'2022-03-22 10:21:39','',''),(2634614,'1','179','933',413,'Retail Sale Id 1627271',8500.00,0.00,0.00,12.50,8500.00,'2022-03-22 10:26:37','',''),(2634615,'1','179','933',413,'Retail Sale Id 1627272',2040.00,0.00,0.00,3.00,2040.00,'2022-03-22 10:27:09','',''),(2634616,'1','179','933',413,'Retail Sale Id 1627273',8500.00,0.00,0.00,12.50,8500.00,'2022-03-22 10:44:52','',''),(2634617,'1','179','933',413,'Retail Sale Id 1627274',11900.00,0.00,0.00,17.50,11900.00,'2022-03-22 12:51:58','',''),(2634618,'1','179','933',413,'Retail Sale Id 1627275',6698.00,0.00,0.00,9.85,6698.00,'2022-03-22 12:52:43','',''),(2634619,'1','179','933',413,'Retail Sale Id 1627276',3400.00,0.00,0.00,5.00,3400.00,'2022-03-22 13:11:05','',''),(2634620,'1','179','933',413,'Retail Sale Id 1627277',3502.00,0.00,0.00,5.15,3502.00,'2022-03-22 13:20:56','',''),(2634621,'1','179','933',413,'Retail Sale Id 1627278',31620.00,0.00,0.00,46.50,31620.00,'2022-03-22 18:30:45','',''),(2634622,'1','179','933',413,'Retail Sale Id 1627279',36998.80,0.00,0.00,54.41,36998.80,'2022-03-22 18:35:28','',''),(2634623,'1','179','933',413,'Retail Sale Id 1627280',4080.00,0.00,0.00,6.00,4080.00,'2022-03-22 19:38:33','',''),(2634624,'1','179','933',413,'Retail Sale Id 1627281',9037.20,0.00,0.00,13.29,9037.20,'2022-03-22 19:48:13','',''),(2634625,'1','179','933',413,'Retail Sale Id 1627282',2040.00,0.00,0.00,3.00,2040.00,'2022-03-22 19:49:29','',''),(2634626,'1','179','933',413,'Retail Sale Id 1627283',999.60,0.00,0.00,1.47,999.60,'2022-03-23 08:22:15','',''),(2634627,'1','179','933',413,'Retail Sale Id 1627284',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 08:29:09','',''),(2634628,'1','179','933',413,'Retail Sale Id 1627285',3400.00,0.00,0.00,5.00,3400.00,'2022-03-23 09:06:21','',''),(2634629,'1','179','933',413,'Retail Sale Id 1627286',6800.00,0.00,0.00,10.00,6800.00,'2022-03-23 09:29:34','',''),(2634630,'1','179','933',413,'Retail Sale Id 1627287',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 09:36:09','',''),(2634631,'1','179','933',413,'Retail Sale Id 1627288',4080.00,0.00,0.00,6.00,4080.00,'2022-03-23 09:37:08','',''),(2634632,'1','179','933',413,'Return of Retail Sale Id 1627286',0.00,6800.00,10.00,0.00,-6800.00,'2022-03-23 09:43:00','',''),(2634633,'1','179','933',413,'Retail Sale Id 1627290',6800.00,0.00,0.00,10.00,6800.00,'2022-03-23 09:45:57','',''),(2634634,'1','179','933',413,'Retail Sale Id 1627291',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 09:53:23','',''),(2634635,'1','179','933',413,'Retail Sale Id 1627292',2998.80,0.00,0.00,4.41,2998.80,'2022-03-23 09:54:32','',''),(2634636,'1','179','933',413,'Retail Sale Id 1627293',999.60,0.00,0.00,1.47,999.60,'2022-03-23 10:12:20','',''),(2634637,'1','179','933',413,'Retail Sale Id 1627294',6800.00,0.00,0.00,10.00,6800.00,'2022-03-23 10:25:36','',''),(2634638,'1','179','933',413,'Retail Sale Id 1627295',4080.00,0.00,0.00,6.00,4080.00,'2022-03-23 10:27:42','',''),(2634639,'1','179','933',413,'Retail Sale Id 1627296',8160.00,0.00,0.00,12.00,8160.00,'2022-03-23 10:34:48','',''),(2634640,'1','179','933',413,'Retail Sale Id 1627297',999.60,0.00,0.00,1.47,999.60,'2022-03-23 11:23:57','',''),(2634641,'1','179','933',413,'Retail Sale Id 1627298',4080.00,0.00,0.00,6.00,4080.00,'2022-03-23 11:48:18','',''),(2634642,'1','179','933',413,'Retail Sale Id 1627299',1999.20,0.00,0.00,2.94,1999.20,'2022-03-23 12:41:18','',''),(2634643,'1','179','933',413,'Retail Sale Id 1627299',6997.20,0.00,0.00,10.29,6997.20,'2022-03-23 12:41:18','',''),(2634644,'1','179','933',413,'Retail Sale Id 1627300',4080.00,0.00,0.00,6.00,4080.00,'2022-03-23 12:42:33','',''),(2634645,'1','179','933',413,'Retail Sale Id 1627301',2040.00,0.00,0.00,3.00,2040.00,'2022-03-23 13:04:36','',''),(2634646,'1','179','933',413,'Retail Sale Id 1627302',2040.00,0.00,0.00,3.00,2040.00,'2022-03-23 13:48:01','',''),(2634647,'1','179','933',413,'Retail Sale Id 1627303',4080.00,0.00,0.00,6.00,4080.00,'2022-03-23 14:13:41','',''),(2634648,'1','179','933',413,'Retail Sale Id 1627304',41140.00,0.00,0.00,60.50,41140.00,'2022-03-23 16:38:02','',''),(2634649,'1','179','933',413,'Retail Sale Id 1627305',16496.80,0.00,0.00,24.26,16496.80,'2022-03-23 16:45:39','',''),(2634650,'1','179','933',413,'Retail Sale Id 1627306',6800.00,0.00,0.00,10.00,6800.00,'2022-03-23 16:47:43','',''),(2634651,'1','179','933',413,'Retail Sale Id 1627307',3202.80,0.00,0.00,4.71,3202.80,'2022-03-23 17:01:12','',''),(2634652,'1','179','933',413,'Retail Sale Id 1627308',999.60,0.00,0.00,1.47,999.60,'2022-03-23 18:46:50','',''),(2634653,'1','179','933',413,'Retail Sale Id 1627309',10540.00,0.00,0.00,15.50,10540.00,'2022-03-23 19:17:14','',''),(2634654,'1','179','933',413,'Retail Sale Id 1627310',22399.20,0.00,0.00,32.94,22399.20,'2022-03-23 19:43:10','',''),(2634655,'1','179','933',413,'Retail Sale Id 1627311',8500.00,0.00,0.00,12.50,8500.00,'2022-03-23 19:43:42','',''),(2634656,'1','179','933',413,'Retail Sale Id 1627312',2040.00,0.00,0.00,3.00,2040.00,'2022-03-24 08:46:01','',''),(2634657,'1','179','933',413,'Retail Sale Id 1627313',4080.00,0.00,0.00,6.00,4080.00,'2022-03-24 09:02:01','',''),(2634658,'1','179','933',413,'Retail Sale Id 1627314',2040.00,0.00,0.00,3.00,2040.00,'2022-03-24 09:07:23','',''),(2634659,'1','179','933',413,'Retail Sale Id 1627315',1502.80,0.00,0.00,2.21,1502.80,'2022-03-24 09:08:21','',''),(2634660,'1','179','933',413,'Retail Sale Id 1627316',4080.00,0.00,0.00,6.00,4080.00,'2022-03-24 09:14:10','',''),(2634661,'1','179','933',413,'Retail Sale Id 1627317',2040.00,0.00,0.00,3.00,2040.00,'2022-03-24 09:21:12','',''),(2634662,'1','179','933',413,'Retail Sale Id 1627318',3400.00,0.00,0.00,5.00,3400.00,'2022-03-24 09:26:18','',''),(2634663,'1','179','933',413,'Retail Sale Id 1627319',4080.00,0.00,0.00,6.00,4080.00,'2022-03-24 09:46:20','',''),(2634664,'1','179','933',413,'Retail Sale Id 1627320',1360.00,0.00,0.00,2.00,1360.00,'2022-03-24 09:57:20','',''),(2634665,'1','179','933',413,'Retail Sale Id 1627321',1502.80,0.00,0.00,2.21,1502.80,'2022-03-24 10:00:23','',''),(2634666,'1','179','933',413,'Retail Sale Id 1627322',1360.00,0.00,0.00,2.00,1360.00,'2022-03-24 10:17:20','',''),(2634667,'1','179','933',413,'Retail Sale Id 1627323',8500.00,0.00,0.00,12.50,8500.00,'2022-03-24 15:15:19','',''),(2634668,'1','179','933',413,'Retail Sale Id 1627324',1360.00,0.00,0.00,2.00,1360.00,'2022-03-24 15:46:50','',''),(2634669,'1','179','933',413,'Retail Sale Id 1627325',20060.00,0.00,0.00,29.50,20060.00,'2022-03-24 15:48:59','',''),(2634670,'1','179','933',413,'Retail Sale Id 1627326',2040.00,0.00,0.00,3.00,2040.00,'2022-03-24 15:50:19','',''),(2634671,'1','179','933',413,'Retail Sale Id 1627327',2998.80,0.00,0.00,4.41,2998.80,'2022-03-24 15:51:18','',''),(2634672,'1','179','933',413,'Retail Sale Id 1627328',4080.00,0.00,0.00,6.00,4080.00,'2022-03-24 15:58:23','',''),(2634673,'1','179','933',413,'Retail Sale Id 1627329',14620.00,0.00,0.00,21.50,14620.00,'2022-03-24 18:25:13','',''),(2634674,'1','179','933',413,'Retail Sale Id 1627330',2998.80,0.00,0.00,4.41,2998.80,'2022-03-24 18:34:20','',''),(2634675,'1','179','933',413,'Retail Sale Id 1627331',8160.00,0.00,0.00,12.00,8160.00,'2022-03-24 18:36:48','',''),(2634676,'1','179','933',413,'Retail Sale Id 1627333',2040.00,0.00,0.00,3.00,2040.00,'2022-03-24 18:47:37','',''),(2634677,'1','179','933',413,'Retail Sale Id 1627333',4760.00,0.00,0.00,7.00,4760.00,'2022-03-24 18:47:37','',''),(2634678,'1','179','933',413,'Retail Sale Id 1627334',4080.00,0.00,0.00,6.00,4080.00,'2022-03-24 18:48:40','',''),(2634679,'1','179','933',413,'Retail Sale Id 1627335',2998.80,0.00,0.00,4.41,2998.80,'2022-03-24 18:55:23','',''),(2634680,'1','179','933',413,'Retail Sale Id 1627336',7221.60,0.00,0.00,10.62,7221.60,'2022-03-24 19:28:48','',''),(2634681,'1','179','933',413,'Retail Sale Id 1627338',3400.00,0.00,0.00,5.00,3400.00,'2022-03-25 08:14:36','',''),(2634682,'1','179','933',413,'Retail Sale Id 1627339',2040.00,0.00,0.00,3.00,2040.00,'2022-03-25 08:29:17','',''),(2634683,'1','179','933',413,'Retail Sale Id 1627340',2720.00,0.00,0.00,4.00,2720.00,'2022-03-25 08:49:03','',''),(2634684,'1','179','933',413,'Retail Sale Id 1627341',4501.60,0.00,0.00,6.62,4501.60,'2022-03-25 08:55:53','',''),(2634685,'1','179','933',413,'Retail Sale Id 1627342',2040.00,0.00,0.00,3.00,2040.00,'2022-03-25 08:57:28','',''),(2634686,'1','179','933',413,'Retail Sale Id 1627343',65280.00,0.00,0.00,96.00,65280.00,'2022-03-25 13:07:49','',''),(2634687,'1','179','933',413,'Retail Sale Id 1627344',17503.20,0.00,0.00,25.74,17503.20,'2022-03-25 13:09:10','',''),(2634688,'1','179','933',413,'Retail Sale Id 1627345',2040.00,0.00,0.00,3.00,2040.00,'2022-03-25 18:50:22','',''),(2634689,'1','179','933',413,'Retail Sale Id 1627346',32000.80,0.00,0.00,47.06,32000.80,'2022-03-25 18:53:27','',''),(2634690,'1','179','933',413,'Retail Sale Id 1627346',60180.00,0.00,0.00,88.50,60180.00,'2022-03-25 18:53:27','',''),(2634691,'1','179','933',413,'Retail Sale Id 1627347',4080.00,0.00,0.00,6.00,4080.00,'2022-03-25 18:54:06','',''),(2634692,'1','179','933',413,'Retail Sale Id 1627348',2040.00,0.00,0.00,3.00,2040.00,'2022-03-25 21:21:11','',''),(2634693,'1','179','933',413,'Retail Sale Id 1627349',2040.00,0.00,0.00,3.00,2040.00,'2022-03-26 08:53:34','',''),(2634694,'1','179','933',413,'Retail Sale Id 1627350',17000.00,0.00,0.00,25.00,17000.00,'2022-03-26 12:13:47','',''),(2634695,'1','179','933',413,'Retail Sale Id 1627351',32837.20,0.00,0.00,48.29,32837.20,'2022-03-26 12:15:45','',''),(2634696,'1','179','933',413,'Retail Sale Id 1627352',4080.00,0.00,0.00,6.00,4080.00,'2022-03-26 12:37:09','',''),(2634697,'1','179','933',413,'Retail Sale Id 1627353',3998.40,0.00,0.00,5.88,3998.40,'2022-03-26 12:55:17','',''),(2634698,'1','179','933',413,'Retail Sale Id 1627354',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 13:14:33','',''),(2634699,'1','179','933',413,'Retail Sale Id 1627355',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 13:18:37','',''),(2634700,'1','179','933',413,'Retail Sale Id 1627356',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 13:20:01','',''),(2634701,'1','179','933',413,'Retail Sale Id 1627357',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 13:28:13','',''),(2634702,'1','179','933',413,'Retail Sale Id 1627358',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 13:57:25','',''),(2634703,'1','179','933',413,'Retail Sale Id 1627359',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 14:10:57','',''),(2634704,'1','179','933',413,'Retail Sale Id 1627360',2040.00,0.00,0.00,3.00,2040.00,'2022-03-26 14:22:20','',''),(2634705,'1','179','933',413,'Retail Sale Id 1627361',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 14:53:09','',''),(2634706,'1','179','933',413,'Retail Sale Id 1627362',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 15:49:16','',''),(2634707,'1','179','933',413,'Retail Sale Id 1627363',4080.00,0.00,0.00,6.00,4080.00,'2022-03-26 16:34:51','',''),(2634708,'1','179','933',413,'Retail Sale Id 1627363',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 16:34:51','',''),(2634709,'1','179','933',413,'Retail Sale Id 1627364',2040.00,0.00,0.00,3.00,2040.00,'2022-03-26 16:35:39','',''),(2634710,'1','179','933',413,'Retail Sale Id 1627365',2040.00,0.00,0.00,3.00,2040.00,'2022-03-26 16:40:42','',''),(2634711,'1','179','933',413,'Retail Sale Id 1627366',1502.80,0.00,0.00,2.21,1502.80,'2022-03-26 16:56:27','',''),(2634712,'1','179','933',413,'Retail Sale Id 1627367',3400.00,0.00,0.00,5.00,3400.00,'2022-03-26 17:56:59','',''),(2634713,'1','179','933',413,'Retail Sale Id 1627368',2040.00,0.00,0.00,3.00,2040.00,'2022-03-26 17:58:59','',''),(2634714,'1','179','933',413,'Retail Sale Id 1627369',4080.00,0.00,0.00,6.00,4080.00,'2022-03-26 18:24:05','',''),(2634715,'1','179','933',413,'Retail Sale Id 1627370',3400.00,0.00,0.00,5.00,3400.00,'2022-03-26 18:31:13','',''),(2634716,'1','179','933',413,'Retail Sale Id 1627371',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 18:47:30','',''),(2634717,'1','179','933',413,'Retail Sale Id 1627372',8500.00,0.00,0.00,12.50,8500.00,'2022-03-26 19:14:07','',''),(2634718,'1','179','933',413,'Retail Sale Id 1627373',999.60,0.00,0.00,1.47,999.60,'2022-03-26 19:15:29','',''),(2634719,'1','179','933',413,'Retail Sale Id 1627374',2998.80,0.00,0.00,4.41,2998.80,'2022-03-26 19:16:16','',''),(2634720,'1','179','933',413,'Retail Sale Id 1627375',8500.00,0.00,0.00,12.50,8500.00,'2022-03-27 08:14:18','',''),(2634721,'1','179','933',413,'Retail Sale Id 1627376',680.00,0.00,0.00,1.00,680.00,'2022-03-27 08:26:02','',''),(2634722,'1','179','933',413,'Retail Sale Id 1627377',3998.40,0.00,0.00,5.88,3998.40,'2022-03-27 09:03:24','',''),(2634723,'1','179','933',413,'Retail Sale Id 1627378',5997.60,0.00,0.00,8.82,5997.60,'2022-03-27 09:31:38','',''),(2634724,'1','179','933',413,'Retail Sale Id 1627379',1360.00,0.00,0.00,2.00,1360.00,'2022-03-27 10:32:51','',''),(2634725,'1','179','933',413,'Retail Sale Id 1627380',4080.00,0.00,0.00,6.00,4080.00,'2022-03-27 10:57:04','',''),(2634726,'1','179','933',413,'Retail Sale Id 1627381',2998.80,0.00,0.00,4.41,2998.80,'2022-03-27 11:21:57','',''),(2634727,'1','179','933',413,'Retail Sale Id 1627382',2040.00,0.00,0.00,3.00,2040.00,'2022-03-27 11:41:13','',''),(2634728,'1','179','933',413,'Retail Sale Id 1627383',680.00,0.00,0.00,1.00,680.00,'2022-03-27 11:42:22','',''),(2634729,'1','179','933',413,'Retail Sale Id 1627383',2040.00,0.00,0.00,3.00,2040.00,'2022-03-27 11:42:22','',''),(2634730,'1','179','933',413,'Retail Sale Id 1627384',2998.80,0.00,0.00,4.41,2998.80,'2022-03-27 11:55:44','',''),(2634731,'1','179','933',413,'Retail Sale Id 1627385',3400.00,0.00,0.00,5.00,3400.00,'2022-03-27 12:02:30','',''),(2634732,'1','179','933',413,'Retail Sale Id 1627386',1999.20,0.00,0.00,2.94,1999.20,'2022-03-27 12:04:47','',''),(2634733,'1','179','933',413,'Retail Sale Id 1627387',8500.00,0.00,0.00,12.50,8500.00,'2022-03-27 12:21:26','',''),(2634734,'1','179','933',413,'Retail Sale Id 1627388',999.60,0.00,0.00,1.47,999.60,'2022-03-27 12:22:15','',''),(2634735,'1','179','933',413,'Retail Sale Id 1627389',8500.00,0.00,0.00,12.50,8500.00,'2022-03-27 12:28:40','',''),(2634736,'1','179','933',413,'Retail Sale Id 1627390',4080.00,0.00,0.00,6.00,4080.00,'2022-03-27 12:34:36','',''),(2634737,'1','179','933',413,'Retail Sale Id 1627391',1999.20,0.00,0.00,2.94,1999.20,'2022-03-27 13:01:25','',''),(2634738,'1','179','933',413,'Retail Sale Id 1627392',2502.40,0.00,0.00,3.68,2502.40,'2022-03-27 13:04:19','',''),(2634739,'1','179','933',413,'Retail Sale Id 1627393',3400.00,0.00,0.00,5.00,3400.00,'2022-03-27 13:13:03','',''),(2634740,'1','179','933',413,'Retail Sale Id 1627394',4080.00,0.00,0.00,6.00,4080.00,'2022-03-27 13:22:48','',''),(2634741,'1','179','933',413,'Retail Sale Id 1627395',999.60,0.00,0.00,1.47,999.60,'2022-03-27 14:02:47','',''),(2634742,'1','179','933',413,'Retail Sale Id 1627396',2040.00,0.00,0.00,3.00,2040.00,'2022-03-27 14:13:01','',''),(2634743,'1','179','933',413,'Retail Sale Id 1627397',1502.80,0.00,0.00,2.21,1502.80,'2022-03-27 14:15:17','',''),(2634744,'1','179','933',413,'Retail Sale Id 1627398',8500.00,0.00,0.00,12.50,8500.00,'2022-03-27 16:46:44','',''),(2634745,'1','179','933',413,'Return of Retail Sale Id 1627397',0.00,1502.80,2.21,0.00,-1502.80,'2022-03-27 16:47:06','',''),(2634746,'1','179','933',413,'Retail Sale Id 1627399',1502.80,0.00,0.00,2.21,1502.80,'2022-03-27 16:47:35','',''),(2634747,'1','179','933',413,'Retail Sale Id 1627400',2998.80,0.00,0.00,4.41,2998.80,'2022-03-27 17:04:19','',''),(2634748,'1','179','933',413,'Retail Sale Id 1627402',7996.80,0.00,0.00,11.76,7996.80,'2022-03-27 17:08:41','',''),(2634749,'1','179','933',413,'Return of Retail Sale Id 1627402',0.00,7996.80,11.76,0.00,-7996.80,'2022-03-27 17:19:25','',''),(2634750,'1','179','933',413,'Return of Retail Sale Id 1627400',0.00,2998.80,4.41,0.00,-2998.80,'2022-03-27 17:19:53','',''),(2634751,'1','179','933',413,'Retail Sale Id 1627403',3400.00,0.00,0.00,5.00,3400.00,'2022-03-27 17:20:37','',''),(2634752,'1','179','933',413,'Retail Sale Id 1627404',2040.00,0.00,0.00,3.00,2040.00,'2022-03-27 17:22:21','',''),(2634753,'1','179','933',413,'Retail Sale Id 1627405',11900.00,0.00,0.00,17.50,11900.00,'2022-03-27 17:23:58','',''),(2634754,'1','179','933',413,'Retail Sale Id 1627406',346.80,0.00,0.00,0.51,346.80,'2022-03-27 17:26:44','',''),(2634755,'1','179','933',413,'Retail Sale Id 1627406',10648.80,0.00,0.00,15.66,10648.80,'2022-03-27 17:26:44','',''),(2634756,'1','179','933',413,'Retail Sale Id 1627407',1360.00,0.00,0.00,2.00,1360.00,'2022-03-27 17:28:14','',''),(2634757,'1','179','933',413,'Retail Sale Id 1627408',2040.00,0.00,0.00,3.00,2040.00,'2022-03-27 17:29:48','',''),(2634758,'1','179','933',413,'Retail Sale Id 1627409',4080.00,0.00,0.00,6.00,4080.00,'2022-03-27 17:30:15','',''),(2634759,'1','179','933',413,'Retail Sale Id 1627410',3400.00,0.00,0.00,5.00,3400.00,'2022-03-27 17:53:01','',''),(2634760,'1','179','933',413,'Retail Sale Id 1627411',8697.20,0.00,0.00,12.79,8697.20,'2022-03-27 18:47:15','',''),(2634761,'1','179','933',413,'Return of Retail Sale Id 1627398',0.00,8500.00,12.50,0.00,-8500.00,'2022-03-27 18:52:04','',''),(2634762,'1','179','933',413,'Retail Sale Id 1627412',8500.00,0.00,0.00,12.50,8500.00,'2022-03-27 18:52:34','',''),(2634763,'1','179','933',413,'Retail Sale Id 1627413',2720.00,0.00,0.00,4.00,2720.00,'2022-03-27 19:00:55','',''),(2634764,'1','179','933',413,'Retail Sale Id 1627414',5997.60,0.00,0.00,8.82,5997.60,'2022-03-29 11:49:47','',''),(2634765,'1','179','933',413,'Retail Sale Id 1627415',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 15:14:57','',''),(2634766,'1','179','933',413,'Retail Sale Id 1627416',10540.00,0.00,0.00,15.50,10540.00,'2022-03-30 15:21:14','',''),(2634767,'1','179','933',413,'Retail Sale Id 1627417',1196.80,0.00,0.00,1.76,1196.80,'2022-03-30 15:27:30','',''),(2634768,'1','179','933',413,'Retail Sale Id 1627418',2040.00,0.00,0.00,3.00,2040.00,'2022-03-30 15:35:43','',''),(2634769,'1','179','933',413,'Retail Sale Id 1627419',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 15:38:31','',''),(2634770,'1','179','933',413,'Retail Sale Id 1627420',4080.00,0.00,0.00,6.00,4080.00,'2022-03-30 16:03:14','',''),(2634771,'1','179','933',413,'Retail Sale Id 1627421',3998.40,0.00,0.00,5.88,3998.40,'2022-03-30 16:25:37','',''),(2634772,'1','179','933',413,'Retail Sale Id 1627422',3998.40,0.00,0.00,5.88,3998.40,'2022-03-30 16:26:56','',''),(2634773,'1','179','933',413,'Retail Sale Id 1627423',4080.00,0.00,0.00,6.00,4080.00,'2022-03-30 16:53:29','',''),(2634774,'1','179','933',413,'Retail Sale Id 1627424',1700.00,0.00,0.00,2.50,1700.00,'2022-03-30 16:57:35','',''),(2634775,'1','179','933',413,'Retail Sale Id 1627425',2040.00,0.00,0.00,3.00,2040.00,'2022-03-30 17:37:49','',''),(2634776,'1','179','933',413,'Retail Sale Id 1627426',4998.00,0.00,0.00,7.35,4998.00,'2022-03-30 17:38:44','',''),(2634777,'1','179','933',413,'Retail Sale Id 1627427',4080.00,0.00,0.00,6.00,4080.00,'2022-03-30 17:39:42','',''),(2634778,'1','179','933',413,'Retail Sale Id 1627428',5501.20,0.00,0.00,8.09,5501.20,'2022-03-30 17:43:32','',''),(2634779,'1','179','933',413,'Retail Sale Id 1627429',3400.00,0.00,0.00,5.00,3400.00,'2022-03-30 17:44:35','',''),(2634780,'1','179','933',413,'Retail Sale Id 1627430',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 17:46:46','',''),(2634781,'1','179','933',413,'Retail Sale Id 1627431',1502.80,0.00,0.00,2.21,1502.80,'2022-03-30 17:50:26','',''),(2634782,'1','179','933',413,'Retail Sale Id 1627432',4080.00,0.00,0.00,6.00,4080.00,'2022-03-30 17:58:59','',''),(2634783,'1','179','933',413,'Retail Sale Id 1627433',2040.00,0.00,0.00,3.00,2040.00,'2022-03-30 17:59:26','',''),(2634784,'1','179','933',413,'Retail Sale Id 1627435',1999.20,0.00,0.00,2.94,1999.20,'2022-03-30 18:01:31','',''),(2634785,'1','179','933',413,'Retail Sale Id 1627436',999.60,0.00,0.00,1.47,999.60,'2022-03-30 18:02:32','',''),(2634786,'1','179','933',413,'Retail Sale Id 1627437',1502.80,0.00,0.00,2.21,1502.80,'2022-03-30 18:03:17','',''),(2634787,'1','179','933',413,'Retail Sale Id 1627438',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 18:04:29','',''),(2634788,'1','179','933',413,'Retail Sale Id 1627439',2040.00,0.00,0.00,3.00,2040.00,'2022-03-30 18:06:15','',''),(2634789,'1','179','933',413,'Retail Sale Id 1627440',999.60,0.00,0.00,1.47,999.60,'2022-03-30 18:07:46','',''),(2634790,'1','179','933',413,'Return of Retail Sale Id 1627438',0.00,8500.00,12.50,0.00,-8500.00,'2022-03-30 18:11:38','',''),(2634791,'1','179','933',413,'Retail Sale Id 1627441',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 18:12:15','',''),(2634792,'1','179','933',413,'Retail Sale Id 1627442',3502.00,0.00,0.00,5.15,3502.00,'2022-03-30 18:26:17','',''),(2634793,'1','179','933',413,'Retail Sale Id 1627443',7099.20,0.00,0.00,10.44,7099.20,'2022-03-30 18:31:13','',''),(2634794,'1','179','933',413,'Retail Sale Id 1627444',1999.20,0.00,0.00,2.94,1999.20,'2022-03-30 18:36:58','',''),(2634795,'1','179','933',413,'Retail Sale Id 1627445',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 18:51:51','',''),(2634796,'1','179','933',413,'Retail Sale Id 1627446',4080.00,0.00,0.00,6.00,4080.00,'2022-03-30 18:53:02','',''),(2634797,'1','179','933',413,'Retail Sale Id 1627447',7500.40,0.00,0.00,11.03,7500.40,'2022-03-30 19:27:23','',''),(2634798,'1','179','933',413,'Retail Sale Id 1627448',4080.00,0.00,0.00,6.00,4080.00,'2022-03-30 19:28:15','',''),(2634799,'1','179','933',413,'Retail Sale Id 1627449',7480.00,0.00,0.00,11.00,7480.00,'2022-03-30 19:33:44','',''),(2634800,'1','179','933',413,'Retail Sale Id 1627449',8500.00,0.00,0.00,12.50,8500.00,'2022-03-30 19:33:44','',''),(2634801,'1','179','933',413,'Retail Sale Id 1627450',1802.00,0.00,0.00,2.65,1802.00,'2022-03-30 19:38:39','',''),(2634802,'1','179','933',413,'Retail Sale Id 1627451',7099.20,0.00,0.00,10.44,7099.20,'2022-03-30 20:21:07','',''),(2634803,'1','179','933',413,'Retail Sale Id 1627452',4080.00,0.00,0.00,6.00,4080.00,'2022-03-31 08:25:49','',''),(2634804,'1','179','933',413,'Retail Sale Id 1627453',6997.20,0.00,0.00,10.29,6997.20,'2022-03-31 14:40:08','',''),(2634805,'1','179','933',413,'Retail Sale Id 1627454',2040.00,0.00,0.00,3.00,2040.00,'2022-03-31 15:34:00','',''),(2634806,'1','179','933',413,'Retail Sale Id 1627455',3400.00,0.00,0.00,5.00,3400.00,'2022-03-31 15:38:40','',''),(2634807,'1','179','933',413,'Retail Sale Id 1627456',2998.80,0.00,0.00,4.41,2998.80,'2022-03-31 15:52:24','',''),(2634808,'1','179','933',413,'Retail Sale Id 1627457',2040.00,0.00,0.00,3.00,2040.00,'2022-03-31 15:57:31','',''),(2634809,'1','179','933',413,'Retail Sale Id 1627458',4080.00,0.00,0.00,6.00,4080.00,'2022-03-31 16:27:48','',''),(2634810,'1','179','933',413,'Retail Sale Id 1627459',2502.40,0.00,0.00,3.68,2502.40,'2022-03-31 16:29:14','',''),(2634811,'1','179','933',413,'Retail Sale Id 1627460',8500.00,0.00,0.00,12.50,8500.00,'2022-03-31 16:44:16','',''),(2634812,'1','179','933',413,'Retail Sale Id 1627461',6997.20,0.00,0.00,10.29,6997.20,'2022-03-31 17:12:03','',''),(2634813,'1','179','933',413,'Retail Sale Id 1627462',4080.00,0.00,0.00,6.00,4080.00,'2022-03-31 17:27:08','',''),(2634814,'1','179','933',413,'Retail Sale Id 1627463',1999.20,0.00,0.00,2.94,1999.20,'2022-03-31 17:28:37','',''),(2634815,'1','179','933',413,'Retail Sale Id 1627463',3400.00,0.00,0.00,5.00,3400.00,'2022-03-31 17:28:37','',''),(2634816,'1','179','933',413,'Retail Sale Id 1627464',8500.00,0.00,0.00,12.50,8500.00,'2022-03-31 17:32:37','',''),(2634817,'1','179','933',413,'Retail Sale Id 1627465',8500.00,0.00,0.00,12.50,8500.00,'2022-03-31 17:34:14','',''),(2634818,'1','179','933',413,'Retail Sale Id 1627466',7480.00,0.00,0.00,11.00,7480.00,'2022-03-31 17:36:53','',''),(2634819,'1','179','933',413,'Retail Sale Id 1627467',90100.00,0.00,0.00,132.50,90100.00,'2022-03-31 18:14:02','',''),(2634820,'1','179','933',413,'Retail Sale Id 1627468',12498.40,0.00,0.00,18.38,12498.40,'2022-03-31 18:15:29','',''),(2634821,'1','179','933',413,'Retail Sale Id 1627469',14960.00,0.00,0.00,22.00,14960.00,'2022-03-31 18:36:04','',''),(2634822,'1','179','933',413,'Retail Sale Id 1627469',14960.00,0.00,0.00,22.00,14960.00,'2022-03-31 18:36:04','',''),(2634823,'1','179','933',413,'Retail Sale Id 1627470',6800.00,0.00,0.00,10.00,6800.00,'2022-03-31 18:37:09','',''),(2634824,'1','179','933',413,'Retail Sale Id 1627471',2040.00,0.00,0.00,3.00,2040.00,'2022-03-31 18:38:17','',''),(2634825,'1','179','933',413,'Retail Sale Id 1627472',2040.00,0.00,0.00,3.00,2040.00,'2022-03-31 18:39:11','',''),(2634826,'1','179','933',413,'Retail Sale Id 1627473',3400.00,0.00,0.00,5.00,3400.00,'2022-03-31 18:40:12','',''),(2634827,'1','179','933',413,'Retail Sale Id 1627474',5997.60,0.00,0.00,8.82,5997.60,'2022-03-31 18:43:52','',''),(2634828,'1','179','933',413,'Retail Sale Id 1627475',2040.00,0.00,0.00,3.00,2040.00,'2022-03-31 18:45:08','',''),(2634829,'1','179','933',413,'Retail Sale Id 1627476',2040.00,0.00,0.00,3.00,2040.00,'2022-03-31 18:45:52','',''),(2634830,'1','179','933',413,'Retail Sale Id 1627477',4080.00,0.00,0.00,6.00,4080.00,'2022-03-31 18:46:52','',''),(2634831,'1','179','933',413,'Retail Sale Id 1627478',3400.00,0.00,0.00,5.00,3400.00,'2022-03-31 18:47:44','',''),(2634832,'1','179','933',413,'Retail Sale Id 1627479',8500.00,0.00,0.00,12.50,8500.00,'2022-03-31 18:51:18','',''),(2634833,'1','179','933',413,'Retail Sale Id 1627480',6997.20,0.00,0.00,10.29,6997.20,'2022-03-31 18:53:03','',''),(2634834,'1','179','933',413,'Return of Retail Sale Id 1627474',0.00,5997.60,8.82,0.00,-5997.60,'2022-03-31 18:54:48','',''),(2634835,'1','179','933',413,'Retail Sale Id 1627481',6800.00,0.00,0.00,10.00,6800.00,'2022-03-31 18:56:25','',''),(2634836,'1','179','933',413,'Retail Sale Id 1627482',5997.60,0.00,0.00,8.82,5997.60,'2022-03-31 18:57:28','',''),(2634837,'1','179','933',413,'Retail Sale Id 1627483',4080.00,0.00,0.00,6.00,4080.00,'2022-03-31 18:59:20','',''),(2634838,'1','179','933',413,'Return of Retail Sale Id 1627481',0.00,6800.00,10.00,0.00,-6800.00,'2022-03-31 19:01:46','',''),(2634839,'1','179','933',413,'Return of Retail Sale Id 1627478',0.00,3400.00,5.00,0.00,-3400.00,'2022-03-31 19:03:02','',''),(2634840,'1','179','933',413,'Retail Sale Id 1627484',10200.00,0.00,0.00,15.00,10200.00,'2022-03-31 19:04:26','',''),(2634841,'1','179','933',413,'Retail Sale Id 1627485',3400.00,0.00,0.00,5.00,3400.00,'2022-03-31 19:07:04','',''),(2634842,'1','179','933',413,'Retail Sale Id 1627486',8500.00,0.00,0.00,12.50,8500.00,'2022-03-31 19:10:45','',''),(2634843,'1','179','933',413,'Return of Retail Sale Id 1627483',0.00,4080.00,6.00,0.00,-4080.00,'2022-03-31 19:11:56','',''),(2634844,'1','179','933',413,'Retail Sale Id 1627487',3502.00,0.00,0.00,5.15,3502.00,'2022-03-31 19:37:03','',''),(2634845,'1','179','933',413,'Retail Sale Id 1627488',999.60,0.00,0.00,1.47,999.60,'2022-03-31 19:38:09','',''),(2634846,'1','179','933',413,'Retail Sale Id 1627489',8500.00,0.00,0.00,12.50,8500.00,'2022-03-31 19:43:50','',''),(2634847,'1','179','933',413,'Retail Sale Id 1627491',3998.40,0.00,0.00,5.88,3998.40,'2022-03-31 20:08:40','',''),(2634848,'1','179','933',413,'Retail Sale Id 1627492',8125.00,0.00,0.00,12.50,0.00,'2022-04-01 09:27:13','',''),(2634849,'1','179','933',413,'Retail Sale Id 1627493',2866.50,0.00,0.00,4.41,0.00,'2022-04-01 11:35:06','',''),(2634850,'1','179','933',413,'Retail Sale Id 1627494',6500.00,0.00,0.00,10.00,0.00,'2022-04-01 12:22:53','',''),(2634851,'1','179','933',413,'Retail Sale Id 1627495',7800.00,0.00,0.00,12.00,0.00,'2022-04-01 12:23:26','',''),(2634852,'1','179','933',413,'Retail Sale Id 1627496',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 12:24:03','',''),(2634853,'1','179','933',413,'Retail Sale Id 1627497',1950.00,0.00,0.00,3.00,0.00,'2022-04-01 12:24:36','',''),(2634854,'1','179','933',413,'Retail Sale Id 1627498',5200.00,0.00,0.00,8.00,0.00,'2022-04-01 12:25:24','',''),(2634855,'1','179','933',413,'Retail Sale Id 1627499',7800.00,0.00,0.00,12.00,0.00,'2022-04-01 12:25:58','',''),(2634856,'1','179','933',413,'Retail Sale Id 1627500',3250.00,0.00,0.00,5.00,0.00,'2022-04-01 12:28:06','',''),(2634857,'1','179','933',413,'Retail Sale Id 1627500',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 12:28:06','',''),(2634858,'1','179','933',413,'Retail Sale Id 1627501',5200.00,0.00,0.00,8.00,0.00,'2022-04-01 12:28:35','',''),(2634859,'1','179','933',413,'Retail Sale Id 1627502',1950.00,0.00,0.00,3.00,0.00,'2022-04-01 12:31:00','',''),(2634860,'1','179','933',413,'Retail Sale Id 1627502',8125.00,0.00,0.00,12.50,0.00,'2022-04-01 12:31:00','',''),(2634861,'1','179','933',413,'Retail Sale Id 1627503',5850.00,0.00,0.00,9.00,0.00,'2022-04-01 12:32:08','',''),(2634862,'1','179','933',413,'Retail Sale Id 1627503',8125.00,0.00,0.00,12.50,0.00,'2022-04-01 12:32:08','',''),(2634863,'1','179','933',413,'Return of Retail Sale Id 1627492',0.00,8125.00,12.50,0.00,0.00,'2022-04-01 12:32:45','',''),(2634864,'1','179','933',413,'Retail Sale Id 1627504',10686.00,0.00,0.00,16.44,0.00,'2022-04-01 12:36:26','',''),(2634865,'1','179','933',413,'Retail Sale Id 1627505',18642.00,0.00,0.00,28.68,0.00,'2022-04-01 12:38:30','',''),(2634866,'1','179','933',413,'Retail Sale Id 1627506',11375.00,0.00,0.00,17.50,0.00,'2022-04-01 12:51:16','',''),(2634867,'1','179','933',413,'Retail Sale Id 1627507',3003.00,0.00,0.00,4.62,0.00,'2022-04-01 13:13:43','',''),(2634868,'1','179','933',413,'Return of Retail Sale Id 1627507',0.00,3003.00,4.62,0.00,0.00,'2022-04-01 14:40:37','',''),(2634869,'1','179','933',413,'Retail Sale Id 1627508',2866.50,0.00,0.00,4.41,0.00,'2022-04-01 14:41:29','',''),(2634870,'1','179','933',413,'Retail Sale Id 1627509',1950.00,0.00,0.00,3.00,0.00,'2022-04-01 14:42:29','',''),(2634871,'1','179','933',413,'Retail Sale Id 1627509',4225.00,0.00,0.00,6.50,0.00,'2022-04-01 14:42:29','',''),(2634872,'1','179','933',413,'Retail Sale Id 1627510',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 14:43:24','',''),(2634873,'1','179','933',413,'Retail Sale Id 1627511',1501.50,0.00,0.00,2.31,0.00,'2022-04-01 14:43:56','',''),(2634874,'1','179','933',413,'Retail Sale Id 1627512',1950.00,0.00,0.00,3.00,0.00,'2022-04-01 14:53:03','',''),(2634875,'1','179','933',413,'Retail Sale Id 1627513',1950.00,0.00,0.00,3.00,0.00,'2022-04-01 16:58:15','',''),(2634876,'1','179','933',413,'Retail Sale Id 1627513',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 16:58:15','',''),(2634877,'1','179','933',413,'Retail Sale Id 1627513',8125.00,0.00,0.00,12.50,0.00,'2022-04-01 16:58:15','',''),(2634878,'1','179','933',413,'Retail Sale Id 1627514',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 16:59:17','',''),(2634879,'1','179','933',413,'Retail Sale Id 1627515',7150.00,0.00,0.00,11.00,0.00,'2022-04-01 17:00:00','',''),(2634880,'1','179','933',413,'Retail Sale Id 1627516',7800.00,0.00,0.00,12.00,0.00,'2022-04-01 17:00:35','',''),(2634881,'1','179','933',413,'Retail Sale Id 1627517',8775.00,0.00,0.00,13.50,0.00,'2022-04-01 17:01:17','',''),(2634882,'1','179','933',413,'Retail Sale Id 1627518',18642.00,0.00,0.00,28.68,0.00,'2022-04-01 17:02:33','',''),(2634883,'1','179','933',413,'Retail Sale Id 1627519',7800.00,0.00,0.00,12.00,0.00,'2022-04-01 17:40:51','',''),(2634884,'1','179','933',413,'Retail Sale Id 1627520',5850.00,0.00,0.00,9.00,0.00,'2022-04-01 17:41:28','',''),(2634885,'1','179','933',413,'Retail Sale Id 1627521',7800.00,0.00,0.00,12.00,0.00,'2022-04-01 17:42:21','',''),(2634886,'1','179','933',413,'Retail Sale Id 1627522',9425.00,0.00,0.00,14.50,0.00,'2022-04-01 17:43:29','',''),(2634887,'1','179','933',413,'Retail Sale Id 1627523',12902.50,0.00,0.00,19.85,0.00,'2022-04-01 17:44:53','',''),(2634888,'1','179','933',413,'Retail Sale Id 1627524',4017.00,0.00,0.00,6.18,0.00,'2022-04-01 17:45:49','',''),(2634889,'1','179','933',413,'Retail Sale Id 1627525',12025.00,0.00,0.00,18.50,0.00,'2022-04-01 17:46:41','',''),(2634890,'1','179','933',413,'Retail Sale Id 1627526',2600.00,0.00,0.00,4.00,0.00,'2022-04-01 17:54:54','',''),(2634891,'1','179','933',413,'Retail Sale Id 1627526',3250.00,0.00,0.00,5.00,0.00,'2022-04-01 17:54:54','',''),(2634892,'1','179','933',413,'Retail Sale Id 1627526',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 17:54:54','',''),(2634893,'1','179','933',413,'Retail Sale Id 1627527',4303.00,0.00,0.00,6.62,0.00,'2022-04-01 17:55:55','',''),(2634894,'1','179','933',413,'Retail Sale Id 1627528',5733.00,0.00,0.00,8.82,0.00,'2022-04-01 18:24:07','',''),(2634895,'1','179','933',413,'Retail Sale Id 1627529',7644.00,0.00,0.00,11.76,0.00,'2022-04-01 18:26:13','',''),(2634896,'1','179','933',413,'Retail Sale Id 1627529',13975.00,0.00,0.00,21.50,0.00,'2022-04-01 18:26:13','',''),(2634897,'1','179','933',413,'Retail Sale Id 1627530',3900.00,0.00,0.00,6.00,0.00,'2022-04-01 18:27:17','',''),(2634898,'1','179','933',413,'Retail Sale Id 1627531',15808.00,0.00,0.00,24.32,0.00,'2022-04-01 19:37:59','',''),(2634899,'1','179','933',413,'Retail Sale Id 1627532',11050.00,0.00,0.00,17.00,0.00,'2022-04-01 19:39:09','',''),(2634900,'1','179','933',413,'Retail Sale Id 1627533',21775.00,0.00,0.00,33.50,0.00,'2022-04-01 19:40:20','',''),(2634901,'1','179','933',413,'Retail Sale Id 1627534',4589.00,0.00,0.00,7.06,0.00,'2022-04-01 19:41:18','',''),(2634902,'1','179','933',413,'Retail Sale Id 1627535',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 08:18:18','',''),(2634903,'1','179','933',413,'Retail Sale Id 1627536',22100.00,0.00,0.00,32.50,975.00,'2022-04-02 08:58:06','',''),(2634904,'1','179','933',413,'Return of Retail Sale Id 1627536',0.00,22100.00,32.50,0.00,-975.00,'2022-04-02 08:58:25','',''),(2634905,'1','179','933',413,'Retail Sale Id 1627537',21125.00,0.00,0.00,32.50,0.00,'2022-04-02 09:00:04','',''),(2634906,'1','179','933',413,'Retail Sale Id 1627538',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 09:03:39','',''),(2634907,'1','179','933',413,'Retail Sale Id 1627539',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 09:04:08','',''),(2634908,'1','179','933',413,'Retail Sale Id 1627540',6500.00,0.00,0.00,10.00,0.00,'2022-04-02 09:05:40','',''),(2634909,'1','179','933',413,'Return of Retail Sale Id 1627537',0.00,21125.00,32.50,0.00,0.00,'2022-04-02 09:06:23','',''),(2634910,'1','179','933',413,'Retail Sale Id 1627541',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 09:06:59','',''),(2634911,'1','179','933',413,'Retail Sale Id 1627542',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 09:08:07','',''),(2634912,'1','179','933',413,'Retail Sale Id 1627542',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 09:08:07','',''),(2634913,'1','179','933',413,'Retail Sale Id 1627542',13000.00,0.00,0.00,20.00,0.00,'2022-04-02 09:08:07','',''),(2634914,'1','179','933',413,'Retail Sale Id 1627543',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 09:15:53','',''),(2634915,'1','179','933',413,'Retail Sale Id 1627544',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 09:47:35','',''),(2634916,'1','179','933',413,'Retail Sale Id 1627545',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 10:19:03','',''),(2634917,'1','179','933',413,'Retail Sale Id 1627546',5200.00,0.00,0.00,8.00,0.00,'2022-04-02 10:20:01','',''),(2634918,'1','179','933',413,'Retail Sale Id 1627547',3822.00,0.00,0.00,5.88,0.00,'2022-04-02 10:21:03','',''),(2634919,'1','179','933',413,'Retail Sale Id 1627548',7169.50,0.00,0.00,11.03,0.00,'2022-04-02 11:05:53','',''),(2634920,'1','179','933',413,'Retail Sale Id 1627549',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 11:06:29','',''),(2634921,'1','179','933',413,'Retail Sale Id 1627550',8606.00,0.00,0.00,13.24,0.00,'2022-04-02 11:07:46','',''),(2634922,'1','179','933',413,'Retail Sale Id 1627551',32500.00,0.00,0.00,50.00,0.00,'2022-04-02 11:08:35','',''),(2634923,'1','179','933',413,'Retail Sale Id 1627552',1001.00,0.00,0.00,1.54,0.00,'2022-04-02 11:09:17','',''),(2634924,'1','179','933',413,'Retail Sale Id 1627553',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 11:10:19','',''),(2634925,'1','179','933',413,'Retail Sale Id 1627554',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 11:11:37','',''),(2634926,'1','179','933',413,'Retail Sale Id 1627556',2392.00,0.00,0.00,3.68,0.00,'2022-04-02 11:12:55','',''),(2634927,'1','179','933',413,'Retail Sale Id 1627557',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 11:24:29','',''),(2634928,'1','179','933',413,'Retail Sale Id 1627558',3997.50,0.00,0.00,6.15,0.00,'2022-04-02 12:34:05','',''),(2634929,'1','179','933',413,'Retail Sale Id 1627559',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 12:35:19','',''),(2634930,'1','179','933',413,'Retail Sale Id 1627560',1001.00,0.00,0.00,1.54,0.00,'2022-04-02 12:36:28','',''),(2634931,'1','179','933',413,'Retail Sale Id 1627561',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 12:37:59','',''),(2634932,'1','179','933',413,'Retail Sale Id 1627562',34450.00,0.00,0.00,53.00,0.00,'2022-04-02 12:38:45','',''),(2634933,'1','179','933',413,'Retail Sale Id 1627563',10991.50,0.00,0.00,16.91,0.00,'2022-04-02 12:39:47','',''),(2634934,'1','179','933',413,'Retail Sale Id 1627564',5200.00,0.00,0.00,8.00,0.00,'2022-04-02 12:40:22','',''),(2634935,'1','179','933',413,'Retail Sale Id 1627565',12025.00,0.00,0.00,18.50,0.00,'2022-04-02 12:41:10','',''),(2634936,'1','179','933',413,'Retail Sale Id 1627566',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 12:41:37','',''),(2634937,'1','179','933',413,'Retail Sale Id 1627567',3198.00,0.00,0.00,4.92,0.00,'2022-04-02 12:42:08','',''),(2634938,'1','179','933',413,'Retail Sale Id 1627568',2002.00,0.00,0.00,3.08,0.00,'2022-04-02 12:57:18','',''),(2634939,'1','179','933',413,'Retail Sale Id 1627568',5200.00,0.00,0.00,8.00,0.00,'2022-04-02 12:57:18','',''),(2634940,'1','179','933',413,'Retail Sale Id 1627569',9620.00,0.00,0.00,14.80,0.00,'2022-04-02 12:59:59','',''),(2634941,'1','179','933',413,'Retail Sale Id 1627570',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 13:01:42','',''),(2634942,'1','179','933',413,'Retail Sale Id 1627571',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 13:02:50','',''),(2634943,'1','179','933',413,'Return of Retail Sale Id 1627569',0.00,9620.00,14.80,0.00,0.00,'2022-04-02 13:04:16','',''),(2634944,'1','179','933',413,'Retail Sale Id 1627572',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 13:04:47','',''),(2634945,'1','179','933',413,'Retail Sale Id 1627573',4998.50,0.00,0.00,7.69,0.00,'2022-04-02 13:08:04','',''),(2634946,'1','179','933',413,'Retail Sale Id 1627574',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 13:10:09','',''),(2634947,'1','179','933',413,'Retail Sale Id 1627575',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 13:17:11','',''),(2634948,'1','179','933',413,'Retail Sale Id 1627576',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 13:23:14','',''),(2634949,'1','179','933',413,'Retail Sale Id 1627578',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 13:28:39','',''),(2634950,'1','179','933',413,'Retail Sale Id 1627578',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 13:28:39','',''),(2634951,'1','179','933',413,'Retail Sale Id 1627579',10400.00,0.00,0.00,16.00,0.00,'2022-04-02 13:29:51','',''),(2634952,'1','179','933',413,'Retail Sale Id 1627580',3250.00,0.00,0.00,5.00,0.00,'2022-04-02 13:31:08','',''),(2634953,'1','179','933',413,'Retail Sale Id 1627581',8001.50,0.00,0.00,12.31,0.00,'2022-04-02 13:33:43','',''),(2634954,'1','179','933',413,'Retail Sale Id 1627582',7800.00,0.00,0.00,12.00,0.00,'2022-04-02 13:35:36','',''),(2634955,'1','179','933',413,'Retail Sale Id 1627583',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 13:47:21','',''),(2634956,'1','179','933',413,'Retail Sale Id 1627584',7800.00,0.00,0.00,12.00,0.00,'2022-04-02 14:23:46','',''),(2634957,'1','179','933',413,'Retail Sale Id 1627585',7800.00,0.00,0.00,12.00,0.00,'2022-04-02 14:24:33','',''),(2634958,'1','179','933',413,'Retail Sale Id 1627586',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 14:25:03','',''),(2634959,'1','179','933',413,'Retail Sale Id 1627587',4550.00,0.00,0.00,7.00,0.00,'2022-04-02 14:26:02','',''),(2634960,'1','179','933',413,'Retail Sale Id 1627588',7800.00,0.00,0.00,12.00,0.00,'2022-04-02 14:27:00','',''),(2634961,'1','179','933',413,'Retail Sale Id 1627589',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 14:28:09','',''),(2634962,'1','179','933',413,'Retail Sale Id 1627590',5999.50,0.00,0.00,9.23,0.00,'2022-04-02 14:28:56','',''),(2634963,'1','179','933',413,'Retail Sale Id 1627591',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 14:29:49','',''),(2634964,'1','179','933',413,'Retail Sale Id 1627592',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 14:30:27','',''),(2634965,'1','179','933',413,'Retail Sale Id 1627593',2002.00,0.00,0.00,3.08,0.00,'2022-04-02 14:31:24','',''),(2634966,'1','179','933',413,'Retail Sale Id 1627594',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 14:32:15','',''),(2634967,'1','179','933',413,'Retail Sale Id 1627595',6500.00,0.00,0.00,10.00,0.00,'2022-04-02 14:39:42','',''),(2634968,'1','179','933',413,'Retail Sale Id 1627596',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 14:42:08','',''),(2634969,'1','179','933',413,'Retail Sale Id 1627597',8450.00,0.00,0.00,13.00,0.00,'2022-04-02 14:43:43','',''),(2634970,'1','179','933',413,'Retail Sale Id 1627598',2002.00,0.00,0.00,3.08,0.00,'2022-04-02 14:44:25','',''),(2634971,'1','179','933',413,'Retail Sale Id 1627599',3997.50,0.00,0.00,6.15,0.00,'2022-04-02 15:02:49','',''),(2634972,'1','179','933',413,'Retail Sale Id 1627600',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 15:03:45','',''),(2634973,'1','179','933',413,'Retail Sale Id 1627601',5200.00,0.00,0.00,8.00,0.00,'2022-04-02 15:17:00','',''),(2634974,'1','179','933',413,'Retail Sale Id 1627602',3997.50,0.00,0.00,6.15,0.00,'2022-04-02 15:18:25','',''),(2634975,'1','179','933',413,'Retail Sale Id 1627603',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 15:19:34','',''),(2634976,'1','179','933',413,'Retail Sale Id 1627604',8450.00,0.00,0.00,13.00,0.00,'2022-04-02 15:24:53','',''),(2634977,'1','179','933',413,'Retail Sale Id 1627605',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 15:31:06','',''),(2634978,'1','179','933',413,'Retail Sale Id 1627606',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 15:36:56','',''),(2634979,'1','179','933',413,'Retail Sale Id 1627607',3802.50,0.00,0.00,5.85,0.00,'2022-04-02 15:38:07','',''),(2634980,'1','179','933',413,'Retail Sale Id 1627608',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 15:45:41','',''),(2634981,'1','179','933',413,'Retail Sale Id 1627609',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 16:00:33','',''),(2634982,'1','179','933',413,'Retail Sale Id 1627610',5200.00,0.00,0.00,8.00,0.00,'2022-04-02 16:01:41','',''),(2634983,'1','179','933',413,'Retail Sale Id 1627611',7800.00,0.00,0.00,12.00,0.00,'2022-04-02 16:28:45','',''),(2634984,'1','179','933',413,'Retail Sale Id 1627612',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 16:29:33','',''),(2634985,'1','179','933',413,'Retail Sale Id 1627613',3250.00,0.00,0.00,5.00,0.00,'2022-04-02 16:30:58','',''),(2634986,'1','179','933',413,'Retail Sale Id 1627614',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 16:31:50','',''),(2634987,'1','179','933',413,'Retail Sale Id 1627615',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 16:32:37','',''),(2634988,'1','179','933',413,'Retail Sale Id 1627616',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 16:33:07','',''),(2634989,'1','179','933',413,'Retail Sale Id 1627617',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 16:34:10','',''),(2634990,'1','179','933',413,'Retail Sale Id 1627619',702.00,0.00,0.00,1.08,0.00,'2022-04-02 16:35:58','',''),(2634991,'1','179','933',413,'Retail Sale Id 1627620',4998.50,0.00,0.00,7.69,0.00,'2022-04-02 16:36:58','',''),(2634992,'1','179','933',413,'Retail Sale Id 1627621',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 16:50:34','',''),(2634993,'1','179','933',413,'Retail Sale Id 1627622',1300.00,0.00,0.00,2.00,0.00,'2022-04-02 16:51:17','',''),(2634994,'1','179','933',413,'Retail Sale Id 1627623',2002.00,0.00,0.00,3.08,0.00,'2022-04-02 16:52:03','',''),(2634995,'1','179','933',413,'Retail Sale Id 1627624',3250.00,0.00,0.00,5.00,0.00,'2022-04-02 16:52:46','',''),(2634996,'1','179','933',413,'Retail Sale Id 1627625',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 16:53:58','',''),(2634997,'1','179','933',413,'Retail Sale Id 1627626',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 17:07:14','',''),(2634998,'1','179','933',413,'Retail Sale Id 1627627',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 17:08:08','',''),(2634999,'1','179','933',413,'Retail Sale Id 1627628',7000.50,0.00,0.00,10.77,0.00,'2022-04-02 17:09:19','',''),(2635000,'1','179','933',413,'Retail Sale Id 1627629',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 17:11:57','',''),(2635001,'1','179','933',413,'Retail Sale Id 1627630',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 17:12:30','',''),(2635002,'1','179','933',413,'Retail Sale Id 1627633',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 17:13:50','',''),(2635003,'1','179','933',413,'Retail Sale Id 1627634',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 17:14:35','',''),(2635004,'1','179','933',413,'Retail Sale Id 1627635',3250.00,0.00,0.00,5.00,0.00,'2022-04-02 17:17:02','',''),(2635005,'1','179','933',413,'Retail Sale Id 1627636',3250.00,0.00,0.00,5.00,0.00,'2022-04-02 17:17:55','',''),(2635006,'1','179','933',413,'Retail Sale Id 1627637',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 17:25:11','',''),(2635007,'1','179','933',413,'Retail Sale Id 1627638',1001.00,0.00,0.00,1.54,0.00,'2022-04-02 17:30:47','',''),(2635008,'1','179','933',413,'Retail Sale Id 1627639',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 17:33:23','',''),(2635009,'1','179','933',413,'Retail Sale Id 1627640',16250.00,0.00,0.00,25.00,0.00,'2022-04-02 17:34:33','',''),(2635010,'1','179','933',413,'Retail Sale Id 1627641',7800.00,0.00,0.00,12.00,0.00,'2022-04-02 17:35:52','',''),(2635011,'1','179','933',413,'Retail Sale Id 1627642',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 17:36:59','',''),(2635012,'1','179','933',413,'Retail Sale Id 1627643',3250.00,0.00,0.00,5.00,0.00,'2022-04-02 17:39:24','',''),(2635013,'1','179','933',413,'Retail Sale Id 1627644',8125.00,0.00,0.00,12.50,0.00,'2022-04-02 17:40:40','',''),(2635014,'1','179','933',413,'Retail Sale Id 1627645',2002.00,0.00,0.00,3.08,0.00,'2022-04-02 17:41:56','',''),(2635015,'1','179','933',413,'Retail Sale Id 1627646',2002.00,0.00,0.00,3.08,0.00,'2022-04-02 17:44:08','',''),(2635016,'1','179','933',413,'Retail Sale Id 1627647',1001.00,0.00,0.00,1.54,0.00,'2022-04-02 17:48:14','',''),(2635017,'1','179','933',413,'Retail Sale Id 1627648',1501.50,0.00,0.00,2.31,0.00,'2022-04-02 17:51:56','',''),(2635018,'1','179','933',413,'Retail Sale Id 1627649',3302.00,0.00,0.00,5.08,0.00,'2022-04-02 17:53:04','',''),(2635019,'1','179','933',413,'Retail Sale Id 1627650',3003.00,0.00,0.00,4.62,0.00,'2022-04-02 17:54:26','',''),(2635020,'1','179','933',413,'Retail Sale Id 1627651',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 17:55:00','',''),(2635021,'1','179','933',413,'Retail Sale Id 1627652',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 17:56:21','',''),(2635022,'1','179','933',413,'Retail Sale Id 1627653',897.00,0.00,0.00,1.38,0.00,'2022-04-02 18:01:57','',''),(2635023,'1','179','933',413,'Retail Sale Id 1627654',1300.00,0.00,0.00,2.00,0.00,'2022-04-02 18:04:54','',''),(2635024,'1','179','933',413,'Retail Sale Id 1627655',3900.00,0.00,0.00,6.00,0.00,'2022-04-02 18:09:54','',''),(2635025,'1','179','933',413,'Retail Sale Id 1627656',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 18:12:53','',''),(2635026,'1','179','933',413,'Retail Sale Id 1627657',1300.00,0.00,0.00,2.00,0.00,'2022-04-02 18:13:47','',''),(2635027,'1','179','933',413,'Retail Sale Id 1627658',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 18:17:41','',''),(2635028,'1','179','933',413,'Retail Sale Id 1627662',16250.00,0.00,0.00,25.00,0.00,'2022-04-02 18:19:34','',''),(2635029,'1','179','933',413,'Retail Sale Id 1627664',1950.00,0.00,0.00,3.00,0.00,'2022-04-02 18:20:24','',''),(2635030,'1','179','933',413,'Return of Retail Sale Id 1627662',0.00,16250.00,25.00,0.00,0.00,'2022-04-02 18:22:09','',''),(2635031,'1','179','933',413,'Return of Retail Sale Id 1627657',0.00,1300.00,2.00,0.00,0.00,'2022-04-02 18:23:50','',''),(2635032,'1','179','933',413,'Return of Retail Sale Id 1627658',0.00,1950.00,3.00,0.00,0.00,'2022-04-02 18:25:00','',''),(2635033,'1','179','933',413,'Return of Retail Sale Id 1627655',0.00,3900.00,6.00,0.00,0.00,'2022-04-02 18:25:56','',''),(2635034,'1','179','933',413,'Return of Retail Sale Id 1627656',0.00,1950.00,3.00,0.00,0.00,'2022-04-02 18:26:56','',''),(2635035,'1','179','933',413,'Return of Retail Sale Id 1627654',0.00,1300.00,2.00,0.00,0.00,'2022-04-02 18:27:47','',''),(2635036,'1','179','933',413,'Return of Retail Sale Id 1627664',0.00,1950.00,3.00,0.00,0.00,'2022-04-02 18:29:23','',''),(2635037,'1','179','933',413,'Retail Sale Id 1627665',8125.00,0.00,0.00,12.50,0.00,'2022-04-03 08:53:00','',''),(2635038,'1','179','933',413,'Retail Sale Id 1627666',18999.50,0.00,0.00,29.23,0.00,'2022-04-03 11:43:09','',''),(2635039,'1','179','933',413,'Retail Sale Id 1627667',949.00,0.00,0.00,1.46,0.00,'2022-04-03 11:45:11','',''),(2635040,'1','179','933',413,'Retail Sale Id 1627667',4998.50,0.00,0.00,7.69,0.00,'2022-04-03 11:45:11','',''),(2635041,'1','179','933',413,'Retail Sale Id 1627667',8125.00,0.00,0.00,12.50,0.00,'2022-04-03 11:45:11','',''),(2635042,'1','179','933',413,'Retail Sale Id 1627668',22750.00,0.00,0.00,35.00,0.00,'2022-04-03 11:54:32','',''),(2635043,'1','179','933',413,'Retail Sale Id 1627669',34001.50,0.00,0.00,52.31,0.00,'2022-04-03 13:04:56','',''),(2635044,'1','179','933',413,'Return of Retail Sale Id 1627669',0.00,34001.50,52.31,0.00,0.00,'2022-04-03 13:05:51','',''),(2635045,'1','179','933',413,'Retail Sale Id 1627670',30998.50,0.00,0.00,47.69,0.00,'2022-04-03 13:06:33','',''),(2635046,'1','179','933',413,'Retail Sale Id 1627671',65201.50,0.00,0.00,100.31,0.00,'2022-04-03 14:27:01','',''),(2635047,'1','179','933',413,'Retail Sale Id 1627672',4498.00,0.00,0.00,6.92,0.00,'2022-04-03 14:27:48','',''),(2635048,'1','179','933',413,'Retail Sale Id 1627673',8125.00,0.00,0.00,12.50,0.00,'2022-04-03 14:29:05','',''),(2635049,'1','179','933',413,'Retail Sale Id 1627675',461.50,0.00,0.00,0.71,0.00,'2022-04-03 14:30:05','',''),(2635050,'1','179','933',413,'Retail Sale Id 1627676',1950.00,0.00,0.00,3.00,0.00,'2022-04-03 14:30:41','',''),(2635051,'1','179','933',413,'Retail Sale Id 1627677',11128.00,0.00,0.00,17.12,0.00,'2022-04-03 14:48:04','',''),(2635052,'1','179','933',413,'Retail Sale Id 1627678',8125.00,0.00,0.00,12.50,0.00,'2022-04-03 14:48:44','',''),(2635053,'1','179','933',413,'Retail Sale Id 1627679',1703.00,0.00,0.00,2.62,0.00,'2022-04-03 15:07:56','',''),(2635054,'1','179','933',413,'Retail Sale Id 1627679',3250.00,0.00,0.00,5.00,0.00,'2022-04-03 15:07:56','',''),(2635055,'1','179','933',413,'Retail Sale Id 1627679',8125.00,0.00,0.00,12.50,0.00,'2022-04-03 15:07:56','',''),(2635056,'1','179','933',413,'Retail Sale Id 1627680',11557.00,0.00,0.00,17.78,0.00,'2022-04-03 15:21:19','',''),(2635057,'1','179','933',413,'Retail Sale Id 1627681',23699.00,0.00,0.00,36.46,0.00,'2022-04-03 16:13:12','',''),(2635058,'1','179','933',413,'Retail Sale Id 1627682',16250.00,0.00,0.00,25.00,0.00,'2022-04-03 16:28:42','',''),(2635059,'1','179','933',413,'Return of Retail Sale Id 1627681',0.00,23699.00,36.46,0.00,0.00,'2022-04-03 16:51:47','',''),(2635060,'1','179','933',413,'Retail Sale Id 1627683',20579.00,0.00,0.00,31.66,0.00,'2022-04-03 16:52:31','',''),(2635061,'1','179','933',413,'Retail Sale Id 1627684',8125.00,0.00,0.00,12.50,0.00,'2022-04-03 19:36:10','',''),(2635062,'1','179','933',413,'Retail Sale Id 1627685',7000.50,0.00,0.00,10.77,0.00,'2022-04-04 08:45:15','',''),(2635063,'1','179','933',413,'Retail Sale Id 1627685',9100.00,0.00,0.00,14.00,0.00,'2022-04-04 08:45:15','',''),(2635064,'1','179','933',413,'Retail Sale Id 1627686',2600.00,0.00,0.00,4.00,0.00,'2022-04-04 08:45:41','',''),(2635065,'1','179','933',413,'Retail Sale Id 1627687',1950.00,0.00,0.00,3.00,0.00,'2022-04-04 09:27:23','',''),(2635066,'1','179','933',413,'Retail Sale Id 1627688',3250.00,0.00,0.00,5.00,0.00,'2022-04-04 10:05:40','',''),(2635067,'1','179','933',413,'Retail Sale Id 1627689',6500.00,0.00,0.00,10.00,0.00,'2022-04-04 10:21:00','',''),(2635068,'1','179','933',413,'Retail Sale Id 1627690',8125.00,0.00,0.00,12.50,0.00,'2022-04-04 10:23:49','',''),(2635069,'1','179','933',413,'Retail Sale Id 1627691',1950.00,0.00,0.00,3.00,0.00,'2022-04-04 10:52:37','',''),(2635070,'1','179','933',413,'Retail Sale Id 1627692',3250.00,0.00,0.00,5.00,0.00,'2022-04-04 11:07:43','',''),(2635071,'1','179','933',413,'Retail Sale Id 1627693',1950.00,0.00,0.00,3.00,0.00,'2022-04-04 11:16:02','',''),(2635072,'1','179','933',413,'Retail Sale Id 1627694',3250.00,0.00,0.00,5.00,0.00,'2022-04-04 11:28:02','',''),(2635073,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,3121200.00,5100.00,0.00,0.00,'2022-04-04 12:00:45','',''),(2635074,'1','179',NULL,413,'Reception corrector for bridging 132515',0.00,0.00,0.00,5100.00,0.00,'2022-04-04 12:02:25','',''),(2635075,'1','179','933',413,'Received from bridging 132515',0.00,0.00,5100.00,0.00,0.00,'2022-04-04 12:02:25','',''),(2635076,'1','179','933',413,'Retail Sale Id 1627695',3997.50,0.00,0.00,6.15,233.70,'2022-04-04 12:06:44','',''),(2635077,'1','179','933',413,'Retail Sale Id 1627696',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 12:17:31','',''),(2635078,'1','179','933',413,'Retail Sale Id 1627697',7299.50,0.00,0.00,11.23,426.74,'2022-04-04 12:35:09','',''),(2635079,'1','179','933',413,'Retail Sale Id 1627698',7800.00,0.00,0.00,12.00,456.00,'2022-04-04 12:37:38','',''),(2635080,'1','179','933',413,'Retail Sale Id 1627699',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 12:38:33','',''),(2635081,'1','179','933',413,'Retail Sale Id 1627700',4062.50,0.00,0.00,6.25,237.50,'2022-04-04 12:40:07','',''),(2635082,'1','179','933',413,'Retail Sale Id 1627701',3997.50,0.00,0.00,6.15,233.70,'2022-04-04 12:49:21','',''),(2635083,'1','179','933',413,'Retail Sale Id 1627702',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 13:20:21','',''),(2635084,'1','179','933',413,'Retail Sale Id 1627703',3997.50,0.00,0.00,6.15,233.70,'2022-04-04 13:26:15','',''),(2635085,'1','179','933',413,'Retail Sale Id 1627704',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 13:59:02','',''),(2635086,'1','179','933',413,'Retail Sale Id 1627706',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 14:03:35','',''),(2635087,'1','179','933',413,'Retail Sale Id 1627707',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 14:13:45','',''),(2635088,'1','179','933',413,'Retail Sale Id 1627708',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 14:18:44','',''),(2635089,'1','179','933',413,'Retail Sale Id 1627710',3003.00,0.00,0.00,4.62,175.56,'2022-04-04 14:24:32','',''),(2635090,'1','179','933',413,'Retail Sale Id 1627711',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 15:36:12','',''),(2635091,'1','179','933',413,'Retail Sale Id 1627712',6500.00,0.00,0.00,10.00,380.00,'2022-04-04 15:39:34','',''),(2635092,'1','179','933',413,'Retail Sale Id 1627713',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 15:46:50','',''),(2635093,'1','179','933',413,'Retail Sale Id 1627714',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 15:55:49','',''),(2635094,'1','179','933',413,'Retail Sale Id 1627715',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:30:08','',''),(2635095,'1','179','933',413,'Retail Sale Id 1627716',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:37:10','',''),(2635096,'1','179','933',413,'Retail Sale Id 1627717',5999.50,0.00,0.00,9.23,350.74,'2022-04-04 16:41:32','',''),(2635097,'1','179','933',413,'Retail Sale Id 1627719',1501.50,0.00,0.00,2.31,87.78,'2022-04-04 16:50:34','',''),(2635098,'1','179','933',413,'Retail Sale Id 1627720',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 16:53:00','',''),(2635099,'1','179','933',413,'Retail Sale Id 1627720',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 16:53:00','',''),(2635100,'1','179','933',413,'Retail Sale Id 1627721',1950.00,0.00,0.00,3.00,114.00,'2022-04-04 16:56:44','',''),(2635101,'1','179','933',413,'Retail Sale Id 1627722',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 17:08:18','',''),(2635102,'1','179','933',413,'Retail Sale Id 1627723',3250.00,0.00,0.00,5.00,190.00,'2022-04-04 17:22:42','',''),(2635103,'1','179','933',413,'Retail Sale Id 1627724',1001.00,0.00,0.00,1.54,58.52,'2022-04-04 17:26:07','',''),(2635104,'1','179','933',413,'Retail Sale Id 1627725',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 17:34:54','',''),(2635105,'1','179','933',413,'Retail Sale Id 1627726',2502.50,0.00,0.00,3.85,146.30,'2022-04-04 17:39:58','',''),(2635106,'1','179','933',413,'Retail Sale Id 1627727',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 17:41:58','',''),(2635107,'1','179','933',413,'Retail Sale Id 1627728',2002.00,0.00,0.00,3.08,117.04,'2022-04-04 17:44:58','',''),(2635108,'1','179','933',413,'Retail Sale Id 1627729',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 17:46:53','',''),(2635109,'1','179','933',413,'Retail Sale Id 1627730',7501.00,0.00,0.00,11.54,438.52,'2022-04-04 17:54:23','',''),(2635110,'1','179','933',413,'Retail Sale Id 1627731',3900.00,0.00,0.00,6.00,228.00,'2022-04-04 17:55:18','',''),(2635111,'1','179','933',413,'Retail Sale Id 1627732',8125.00,0.00,0.00,12.50,475.00,'2022-04-04 17:57:20','',''),(2635112,'1','179','933',413,'Retail Sale Id 1627733',18297.50,0.00,0.00,28.15,1069.70,'2022-04-04 18:27:40','',''),(2635113,'1','179','933',413,'Retail Sale Id 1627734',3997.50,0.00,0.00,6.15,233.70,'2022-04-05 08:54:33','',''),(2635114,'1','179','933',413,'Retail Sale Id 1627735',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 08:56:33','',''),(2635115,'1','179','933',413,'Retail Sale Id 1627736',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 08:59:01','',''),(2635116,'1','179','933',413,'Retail Sale Id 1627737',16601.00,0.00,0.00,25.54,970.52,'2022-04-05 10:49:13','',''),(2635117,'1','179','933',413,'Retail Sale Id 1627738',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 10:50:00','',''),(2635118,'1','179','933',413,'Retail Sale Id 1627739',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 11:19:41','',''),(2635119,'1','179','933',413,'Retail Sale Id 1627740',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 11:22:13','',''),(2635120,'1','179','933',413,'Retail Sale Id 1627741',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 11:27:02','',''),(2635121,'1','179','933',413,'Retail Sale Id 1627742',4998.50,0.00,0.00,7.69,292.22,'2022-04-05 11:32:00','',''),(2635122,'1','179','933',413,'Retail Sale Id 1627743',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 11:37:44','',''),(2635123,'1','179','933',413,'Retail Sale Id 1627744',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 11:39:02','',''),(2635124,'1','179','933',413,'Retail Sale Id 1627745',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 11:52:09','',''),(2635125,'1','179','933',413,'Retail Sale Id 1627746',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 12:08:52','',''),(2635126,'1','179','933',413,'Retail Sale Id 1627747',799.50,0.00,0.00,1.23,46.74,'2022-04-05 12:24:51','',''),(2635127,'1','179','933',413,'Retail Sale Id 1627748',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 12:39:10','',''),(2635128,'1','179','933',413,'Retail Sale Id 1627749',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 12:40:11','',''),(2635129,'1','179','933',413,'Retail Sale Id 1627750',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 13:04:35','',''),(2635130,'1','179','933',413,'Retail Sale Id 1627751',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 13:06:50','',''),(2635131,'1','179','933',413,'Retail Sale Id 1627752',26000.00,0.00,0.00,40.00,1520.00,'2022-04-05 13:16:01','',''),(2635132,'1','179','933',413,'Retail Sale Id 1627753',29997.50,0.00,0.00,46.15,1753.70,'2022-04-05 13:19:17','',''),(2635133,'1','179','933',413,'Return of Retail Sale Id 1627753',0.00,29997.50,46.15,0.00,-1753.70,'2022-04-05 13:19:45','',''),(2635134,'1','179','933',413,'Retail Sale Id 1627754',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 13:43:03','',''),(2635135,'1','179','933',413,'Retail Sale Id 1627755',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 13:43:54','',''),(2635136,'1','179','933',413,'Retail Sale Id 1627756',1501.50,0.00,0.00,2.31,87.78,'2022-04-05 13:56:55','',''),(2635137,'1','179','933',413,'Retail Sale Id 1627757',650.00,0.00,0.00,1.00,38.00,'2022-04-05 14:01:26','',''),(2635138,'1','179','933',413,'Retail Sale Id 1627757',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 14:01:26','',''),(2635139,'1','179','933',413,'Retail Sale Id 1627758',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 14:33:26','',''),(2635140,'1','179','933',413,'Retail Sale Id 1627759',7150.00,0.00,0.00,11.00,418.00,'2022-04-05 14:37:08','',''),(2635141,'1','179','933',413,'Retail Sale Id 1627760',2600.00,0.00,0.00,4.00,152.00,'2022-04-05 14:40:22','',''),(2635142,'1','179','933',413,'Retail Sale Id 1627761',7000.50,0.00,0.00,10.77,409.26,'2022-04-05 14:41:49','',''),(2635143,'1','179','933',413,'Retail Sale Id 1627762',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 14:43:43','',''),(2635144,'1','179','933',413,'Retail Sale Id 1627763',5999.50,0.00,0.00,9.23,350.74,'2022-04-05 14:44:38','',''),(2635145,'1','179','933',413,'Retail Sale Id 1627764',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 14:45:51','',''),(2635146,'1','179','933',413,'Retail Sale Id 1627765',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 14:48:42','',''),(2635147,'1','179','933',413,'Retail Sale Id 1627766',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 14:53:58','',''),(2635148,'1','179','933',413,'Retail Sale Id 1627767',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 15:06:41','',''),(2635149,'1','179','933',413,'Retail Sale Id 1627768',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 15:08:32','',''),(2635150,'1','179','933',413,'Retail Sale Id 1627769',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 15:19:46','',''),(2635151,'1','179','933',413,'Retail Sale Id 1627770',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 15:28:08','',''),(2635152,'1','179','933',413,'Retail Sale Id 1627771',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 15:30:04','',''),(2635153,'1','179','933',413,'Retail Sale Id 1627777',2600.00,0.00,0.00,4.00,152.00,'2022-04-05 15:40:05','',''),(2635154,'1','179','933',413,'Retail Sale Id 1627778',1001.00,0.00,0.00,1.54,58.52,'2022-04-05 15:49:07','',''),(2635155,'1','179','933',413,'Retail Sale Id 1627778',4998.50,0.00,0.00,7.69,292.22,'2022-04-05 15:49:07','',''),(2635156,'1','179','933',413,'Retail Sale Id 1627779',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 15:51:48','',''),(2635157,'1','179','933',413,'Retail Sale Id 1627780',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 15:58:34','',''),(2635158,'1','179','933',413,'Retail Sale Id 1627782',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 16:07:30','',''),(2635159,'1','179','933',413,'Retail Sale Id 1627783',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 16:29:30','',''),(2635160,'1','179','933',413,'Retail Sale Id 1627784',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 16:30:38','',''),(2635161,'1','179','933',413,'Retail Sale Id 1627785',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 16:31:23','',''),(2635162,'1','179','933',413,'Retail Sale Id 1627786',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 16:32:53','',''),(2635163,'1','179','933',413,'Retail Sale Id 1627788',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 16:38:11','',''),(2635164,'1','179','933',413,'Retail Sale Id 1627789',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 17:00:44','',''),(2635165,'1','179','933',413,'Retail Sale Id 1627790',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 17:03:52','',''),(2635166,'1','179','933',413,'Retail Sale Id 1627791',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 17:22:27','',''),(2635167,'1','179','933',413,'Retail Sale Id 1627792',3003.00,0.00,0.00,4.62,175.56,'2022-04-05 17:23:43','',''),(2635168,'1','179','933',413,'Retail Sale Id 1627793',3250.00,0.00,0.00,5.00,190.00,'2022-04-05 17:25:10','',''),(2635169,'1','179','933',413,'Retail Sale Id 1627794',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 17:39:35','',''),(2635170,'1','179','933',413,'Retail Sale Id 1627795',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 17:41:18','',''),(2635171,'1','179','933',413,'Retail Sale Id 1627796',1001.00,0.00,0.00,1.54,58.52,'2022-04-05 17:44:09','',''),(2635172,'1','179','933',413,'Retail Sale Id 1627797',2002.00,0.00,0.00,3.08,117.04,'2022-04-05 17:45:36','',''),(2635173,'1','179','933',413,'Retail Sale Id 1627798',7000.50,0.00,0.00,10.77,409.26,'2022-04-05 17:46:48','',''),(2635174,'1','179','933',413,'Retail Sale Id 1627799',3900.00,0.00,0.00,6.00,228.00,'2022-04-05 17:48:29','',''),(2635175,'1','179','933',413,'Retail Sale Id 1627800',2600.00,0.00,0.00,4.00,152.00,'2022-04-05 17:55:35','',''),(2635176,'1','179','933',413,'Retail Sale Id 1627801',8125.00,0.00,0.00,12.50,475.00,'2022-04-05 18:10:30','',''),(2635177,'1','179','933',413,'Retail Sale Id 1627802',1950.00,0.00,0.00,3.00,114.00,'2022-04-05 18:12:36','',''),(2635178,'1','179','933',413,'Retail Sale Id 1627803',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 07:56:38','',''),(2635179,'1','179','933',413,'Retail Sale Id 1627804',2502.50,0.00,0.00,3.85,146.30,'2022-04-06 09:01:20','',''),(2635180,'1','179','933',413,'Retail Sale Id 1627805',2002.00,0.00,0.00,3.08,117.04,'2022-04-06 09:02:18','',''),(2635181,'1','179','933',413,'Retail Sale Id 1627805',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 09:02:18','',''),(2635182,'1','179','933',413,'Retail Sale Id 1627806',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 09:14:32','',''),(2635183,'1','179','933',413,'Retail Sale Id 1627807',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 09:32:29','',''),(2635184,'1','179','933',413,'Retail Sale Id 1627808',1300.00,0.00,0.00,2.00,76.00,'2022-04-06 09:49:07','',''),(2635185,'1','179','933',413,'Retail Sale Id 1627809',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 09:50:30','',''),(2635186,'1','179','933',413,'Retail Sale Id 1627810',1001.00,0.00,0.00,1.54,58.52,'2022-04-06 09:53:58','',''),(2635187,'1','179','933',413,'Retail Sale Id 1627811',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 09:54:43','',''),(2635188,'1','179','933',413,'Retail Sale Id 1627812',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 10:01:26','',''),(2635189,'1','179','933',413,'Retail Sale Id 1627813',13000.00,0.00,0.00,20.00,760.00,'2022-04-06 10:14:54','',''),(2635190,'1','179','933',413,'Retail Sale Id 1627814',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 10:30:27','',''),(2635191,'1','179','933',413,'Retail Sale Id 1627815',3003.00,0.00,0.00,4.62,175.56,'2022-04-06 10:47:30','',''),(2635192,'1','179','933',413,'Retail Sale Id 1627816',5200.00,0.00,0.00,8.00,304.00,'2022-04-06 11:25:09','',''),(2635193,'1','179','933',413,'Retail Sale Id 1627817',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 12:10:40','',''),(2635194,'1','179','933',413,'Retail Sale Id 1627818',3250.00,0.00,0.00,5.00,190.00,'2022-04-06 12:11:24','',''),(2635195,'1','179','933',413,'Retail Sale Id 1627819',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 12:46:11','',''),(2635196,'1','179','933',413,'Retail Sale Id 1627819',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 12:46:11','',''),(2635197,'1','179','933',413,'Retail Sale Id 1627820',8001.50,0.00,0.00,12.31,467.78,'2022-04-06 12:54:39','',''),(2635198,'1','179','933',413,'Retail Sale Id 1627821',3997.50,0.00,0.00,6.15,233.70,'2022-04-06 12:56:58','',''),(2635199,'1','179','933',413,'Retail Sale Id 1627822',3250.00,0.00,0.00,5.00,190.00,'2022-04-06 12:59:23','',''),(2635200,'1','179','933',413,'Retail Sale Id 1627823',10075.00,0.00,0.00,15.50,589.00,'2022-04-06 13:18:53','',''),(2635201,'1','179','933',413,'Retail Sale Id 1627824',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 14:44:55','',''),(2635202,'1','179','933',413,'Retail Sale Id 1627825',2002.00,0.00,0.00,3.08,117.04,'2022-04-06 14:55:43','',''),(2635203,'1','179','933',413,'Retail Sale Id 1627826',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 15:03:14','',''),(2635204,'1','179','933',413,'Retail Sale Id 1627826',13000.00,0.00,0.00,20.00,760.00,'2022-04-06 15:03:14','',''),(2635205,'1','179','933',413,'Retail Sale Id 1627827',1300.00,0.00,0.00,2.00,76.00,'2022-04-06 15:32:47','',''),(2635206,'1','179','933',413,'Retail Sale Id 1627828',2002.00,0.00,0.00,3.08,117.04,'2022-04-06 15:38:00','',''),(2635207,'1','179','933',413,'Retail Sale Id 1627829',6500.00,0.00,0.00,10.00,380.00,'2022-04-06 15:44:46','',''),(2635208,'1','179','933',413,'Retail Sale Id 1627830',2502.50,0.00,0.00,3.85,146.30,'2022-04-06 16:00:38','',''),(2635209,'1','179','933',413,'Retail Sale Id 1627831',8001.50,0.00,0.00,12.31,467.78,'2022-04-06 16:39:06','',''),(2635210,'1','179','933',413,'Retail Sale Id 1627832',2002.00,0.00,0.00,3.08,117.04,'2022-04-06 16:40:38','',''),(2635211,'1','179','933',413,'Retail Sale Id 1627833',10075.00,0.00,0.00,15.50,589.00,'2022-04-06 16:47:16','',''),(2635212,'1','179','933',413,'Retail Sale Id 1627834',3250.00,0.00,0.00,5.00,190.00,'2022-04-06 16:58:01','',''),(2635213,'1','179','933',413,'Retail Sale Id 1627835',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 17:00:16','',''),(2635214,'1','179','933',413,'Return of Retail Sale Id 1627833',0.00,10075.00,15.50,0.00,-589.00,'2022-04-06 17:01:10','',''),(2635215,'1','179','933',413,'Retail Sale Id 1627836',1950.00,0.00,0.00,3.00,114.00,'2022-04-06 17:02:33','',''),(2635216,'1','179','933',413,'Retail Sale Id 1627836',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 17:02:33','',''),(2635217,'1','179','933',413,'Retail Sale Id 1627837',1625.00,0.00,0.00,2.50,95.00,'2022-04-06 17:05:43','',''),(2635218,'1','179','933',413,'Retail Sale Id 1627838',1599.00,0.00,0.00,2.46,93.48,'2022-04-06 17:13:26','',''),(2635219,'1','179','933',413,'Retail Sale Id 1627839',8125.00,0.00,0.00,12.50,475.00,'2022-04-06 17:40:35','',''),(2635220,'1','179','933',413,'Retail Sale Id 1627840',1001.00,0.00,0.00,1.54,58.52,'2022-04-06 17:42:49','',''),(2635221,'1','179','933',413,'Retail Sale Id 1627841',3497.00,0.00,0.00,5.38,204.44,'2022-04-06 17:44:28','',''),(2635222,'1','179','933',413,'Retail Sale Id 1627842',1300.00,0.00,0.00,2.00,76.00,'2022-04-06 17:45:32','',''),(2635223,'1','179','933',413,'Retail Sale Id 1627843',650.00,0.00,0.00,1.00,38.00,'2022-04-06 17:55:02','',''),(2635224,'1','179','933',413,'Retail Sale Id 1627844',1001.00,0.00,0.00,1.54,58.52,'2022-04-06 18:01:00','',''),(2635225,'1','179','933',413,'Retail Sale Id 1627844',3198.00,0.00,0.00,4.92,186.96,'2022-04-06 18:01:00','',''),(2635226,'1','179','933',413,'Retail Sale Id 1627845',3900.00,0.00,0.00,6.00,228.00,'2022-04-06 18:07:33','',''),(2635227,'1','179','933',413,'Retail Sale Id 1627846',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 08:34:35','',''),(2635228,'1','179','933',413,'Retail Sale Id 1627847',1300.00,0.00,0.00,2.00,76.00,'2022-04-07 08:35:12','',''),(2635229,'1','179','933',413,'Retail Sale Id 1627848',12025.00,0.00,0.00,18.50,703.00,'2022-04-07 09:01:16','',''),(2635230,'1','179','933',413,'Retail Sale Id 1627849',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 09:02:44','',''),(2635231,'1','179','933',413,'Retail Sale Id 1627850',1001.00,0.00,0.00,1.54,58.52,'2022-04-07 09:05:01','',''),(2635232,'1','179','933',413,'Retail Sale Id 1627851',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 09:15:22','',''),(2635233,'1','179','933',413,'Retail Sale Id 1627852',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 09:40:28','',''),(2635234,'1','179','933',413,'Retail Sale Id 1627853',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 10:08:16','',''),(2635235,'1','179','933',413,'Retail Sale Id 1627854',74750.00,0.00,0.00,115.00,4370.00,'2022-04-07 10:10:34','',''),(2635236,'1','179','933',413,'Retail Sale Id 1627855',8001.50,0.00,0.00,12.31,467.78,'2022-04-07 10:56:52','',''),(2635237,'1','179','933',413,'Retail Sale Id 1627856',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 10:58:14','',''),(2635238,'1','179','933',413,'Retail Sale Id 1627857',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 10:59:53','',''),(2635239,'1','179','933',413,'Retail Sale Id 1627858',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 11:07:03','',''),(2635240,'1','179','933',413,'Retail Sale Id 1627859',1001.00,0.00,0.00,1.54,58.52,'2022-04-07 11:26:57','',''),(2635241,'1','179','933',413,'Retail Sale Id 1627860',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 11:30:50','',''),(2635242,'1','179','933',413,'Retail Sale Id 1627861',3997.50,0.00,0.00,6.15,233.70,'2022-04-07 11:59:51','',''),(2635243,'1','179','933',413,'Retail Sale Id 1627862',1300.00,0.00,0.00,2.00,76.00,'2022-04-07 12:05:54','',''),(2635244,'1','179','933',413,'Retail Sale Id 1627863',1501.50,0.00,0.00,2.31,87.78,'2022-04-07 12:18:32','',''),(2635245,'1','179','933',413,'Retail Sale Id 1627864',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 12:22:10','',''),(2635246,'1','179','933',413,'Retail Sale Id 1627865',3003.00,0.00,0.00,4.62,175.56,'2022-04-07 12:23:50','',''),(2635247,'1','179','933',413,'Retail Sale Id 1627866',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 12:24:59','',''),(2635248,'1','179','933',413,'Retail Sale Id 1627867',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 12:44:32','',''),(2635249,'1','179','933',413,'Retail Sale Id 1627868',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 12:45:30','',''),(2635250,'1','179','933',413,'Retail Sale Id 1627869',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 12:56:13','',''),(2635251,'1','179','933',413,'Retail Sale Id 1627870',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 13:01:21','',''),(2635252,'1','179','933',413,'Retail Sale Id 1627871',2600.00,0.00,0.00,4.00,152.00,'2022-04-07 13:30:46','',''),(2635253,'1','179','933',413,'Retail Sale Id 1627872',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 13:32:08','',''),(2635254,'1','179','933',413,'Retail Sale Id 1627873',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 14:17:05','',''),(2635255,'1','179','933',413,'Retail Sale Id 1627874',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 14:18:18','',''),(2635256,'1','179','933',413,'Retail Sale Id 1627875',2600.00,0.00,0.00,4.00,152.00,'2022-04-07 14:28:57','',''),(2635257,'1','179','933',413,'Retail Sale Id 1627876',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 14:51:29','',''),(2635258,'1','179','933',413,'Retail Sale Id 1627877',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 15:04:18','',''),(2635259,'1','179','933',413,'Retail Sale Id 1627878',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 15:17:30','',''),(2635260,'1','179','933',413,'Retail Sale Id 1627879',2002.00,0.00,0.00,3.08,117.04,'2022-04-07 15:22:57','',''),(2635261,'1','179','933',413,'Retail Sale Id 1627880',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 15:35:44','',''),(2635262,'1','179','933',413,'Retail Sale Id 1627881',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 15:57:58','',''),(2635263,'1','179','933',413,'Retail Sale Id 1627882',1501.50,0.00,0.00,2.31,87.78,'2022-04-07 15:58:52','',''),(2635264,'1','179','933',413,'Retail Sale Id 1627883',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 16:15:28','',''),(2635265,'1','179','933',413,'Retail Sale Id 1627884',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 16:16:19','',''),(2635266,'1','179','933',413,'Retail Sale Id 1627885',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 16:17:35','',''),(2635267,'1','179','933',413,'Retail Sale Id 1627886',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 16:34:08','',''),(2635268,'1','179','933',413,'Retail Sale Id 1627887',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 16:44:40','',''),(2635269,'1','179','933',413,'Retail Sale Id 1627888',4998.50,0.00,0.00,7.69,292.22,'2022-04-07 16:47:19','',''),(2635270,'1','179','933',413,'Retail Sale Id 1627889',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 16:59:43','',''),(2635271,'1','179','933',413,'Retail Sale Id 1627890',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 17:13:23','',''),(2635272,'1','179','933',413,'Retail Sale Id 1627891',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 17:15:15','',''),(2635273,'1','179','933',413,'Retail Sale Id 1627892',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 17:24:32','',''),(2635274,'1','179','933',413,'Retail Sale Id 1627893',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 17:25:30','',''),(2635275,'1','179','933',413,'Retail Sale Id 1627894',2002.00,0.00,0.00,3.08,117.04,'2022-04-07 17:28:58','',''),(2635276,'1','179','933',413,'Retail Sale Id 1627895',1001.00,0.00,0.00,1.54,58.52,'2022-04-07 17:30:04','',''),(2635277,'1','179','933',413,'Retail Sale Id 1627896',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 17:36:08','',''),(2635278,'1','179','933',413,'Retail Sale Id 1627897',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 17:37:18','',''),(2635279,'1','179','933',413,'Retail Sale Id 1627898',3003.00,0.00,0.00,4.62,175.56,'2022-04-07 17:41:11','',''),(2635280,'1','179','933',413,'Retail Sale Id 1627899',650.00,0.00,0.00,1.00,38.00,'2022-04-07 18:04:24','',''),(2635281,'1','179','933',413,'Retail Sale Id 1627900',1950.00,0.00,0.00,3.00,114.00,'2022-04-07 18:15:26','',''),(2635282,'1','179','933',413,'Retail Sale Id 1627901',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 18:17:03','',''),(2635283,'1','179','933',413,'Retail Sale Id 1627902',3900.00,0.00,0.00,6.00,228.00,'2022-04-07 18:17:38','',''),(2635284,'1','179','933',413,'Return of Retail Sale Id 1627902',0.00,3900.00,6.00,0.00,-228.00,'2022-04-07 18:18:19','',''),(2635285,'1','179','933',413,'Retail Sale Id 1627903',3250.00,0.00,0.00,5.00,190.00,'2022-04-07 18:21:11','',''),(2635286,'1','179','933',413,'Retail Sale Id 1627904',8125.00,0.00,0.00,12.50,475.00,'2022-04-07 18:22:37','',''),(2635287,'1','179','933',413,'Retail Sale Id 1627905',2002.00,0.00,0.00,3.08,117.04,'2022-04-08 08:25:55','',''),(2635288,'1','179','933',413,'Retail Sale Id 1627906',2002.00,0.00,0.00,3.08,117.04,'2022-04-08 08:58:37','',''),(2635289,'1','179','933',413,'Retail Sale Id 1627906',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 08:58:37','',''),(2635290,'1','179','933',413,'Retail Sale Id 1627907',1501.50,0.00,0.00,2.31,87.78,'2022-04-08 10:06:25','',''),(2635291,'1','179','933',413,'Retail Sale Id 1627908',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 10:29:57','',''),(2635292,'1','179','933',413,'Retail Sale Id 1627909',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 10:33:44','',''),(2635293,'1','179','933',413,'Retail Sale Id 1627910',3250.00,0.00,0.00,5.00,190.00,'2022-04-08 10:34:50','',''),(2635294,'1','179','933',413,'Retail Sale Id 1627911',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 10:35:38','',''),(2635295,'1','179','933',413,'Retail Sale Id 1627912',3003.00,0.00,0.00,4.62,175.56,'2022-04-08 10:42:47','',''),(2635296,'1','179','933',413,'Retail Sale Id 1627913',2600.00,0.00,0.00,4.00,152.00,'2022-04-08 10:52:38','',''),(2635297,'1','179','933',413,'Retail Sale Id 1627914',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 10:53:51','',''),(2635298,'1','179','933',413,'Retail Sale Id 1627915',3003.00,0.00,0.00,4.62,175.56,'2022-04-08 10:57:57','',''),(2635299,'1','179','933',413,'Retail Sale Id 1627916',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 11:07:31','',''),(2635300,'1','179','933',413,'Retail Sale Id 1627917',2502.50,0.00,0.00,3.85,146.30,'2022-04-08 11:45:55','',''),(2635301,'1','179','933',413,'Retail Sale Id 1627918',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 12:01:10','',''),(2635302,'1','179','933',413,'Retail Sale Id 1627919',1501.50,0.00,0.00,2.31,87.78,'2022-04-08 12:03:34','',''),(2635303,'1','179','933',413,'Retail Sale Id 1627920',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 12:43:42','',''),(2635304,'1','179','933',413,'Retail Sale Id 1627921',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 12:45:03','',''),(2635305,'1','179','933',413,'Retail Sale Id 1627922',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 14:15:40','',''),(2635306,'1','179','933',413,'Retail Sale Id 1627923',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 14:49:29','',''),(2635307,'1','179','933',413,'Retail Sale Id 1627924',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 14:57:20','',''),(2635308,'1','179','933',413,'Retail Sale Id 1627924',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 14:57:20','',''),(2635309,'1','179','933',413,'Retail Sale Id 1627925',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 14:59:56','',''),(2635310,'1','179','933',413,'Retail Sale Id 1627926',3250.00,0.00,0.00,5.00,190.00,'2022-04-08 15:06:53','',''),(2635311,'1','179','933',413,'Retail Sale Id 1627927',4498.00,0.00,0.00,6.92,262.96,'2022-04-08 15:24:58','',''),(2635312,'1','179','933',413,'Retail Sale Id 1627928',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 15:32:22','',''),(2635313,'1','179','933',413,'Retail Sale Id 1627929',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 15:39:55','',''),(2635314,'1','179','933',413,'Retail Sale Id 1627930',3250.00,0.00,0.00,5.00,190.00,'2022-04-08 16:28:02','',''),(2635315,'1','179','933',413,'Retail Sale Id 1627931',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 16:28:55','',''),(2635316,'1','179','933',413,'Retail Sale Id 1627932',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 16:32:41','',''),(2635317,'1','179','933',413,'Retail Sale Id 1627933',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 16:36:33','',''),(2635318,'1','179','933',413,'Retail Sale Id 1627934',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 16:48:20','',''),(2635319,'1','179','933',413,'Retail Sale Id 1627935',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 16:49:56','',''),(2635320,'1','179','933',413,'Retail Sale Id 1627936',3900.00,0.00,0.00,6.00,228.00,'2022-04-08 16:51:54','',''),(2635321,'1','179','933',413,'Retail Sale Id 1627937',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 16:59:15','',''),(2635322,'1','179','933',413,'Retail Sale Id 1627938',2002.00,0.00,0.00,3.08,117.04,'2022-04-08 17:11:21','',''),(2635323,'1','179','933',413,'Retail Sale Id 1627939',1001.00,0.00,0.00,1.54,58.52,'2022-04-08 17:12:18','',''),(2635324,'1','179','933',413,'Retail Sale Id 1627940',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 17:27:19','',''),(2635325,'1','179','933',413,'Retail Sale Id 1627941',1001.00,0.00,0.00,1.54,58.52,'2022-04-08 17:28:45','',''),(2635326,'1','179','933',413,'Retail Sale Id 1627943',1001.00,0.00,0.00,1.54,58.52,'2022-04-08 17:33:57','',''),(2635327,'1','179','933',413,'Retail Sale Id 1627944',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 17:44:30','',''),(2635328,'1','179','933',413,'Retail Sale Id 1627945',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 17:49:18','',''),(2635329,'1','179','933',413,'Retail Sale Id 1627946',1950.00,0.00,0.00,3.00,114.00,'2022-04-08 17:55:28','',''),(2635330,'1','179','933',413,'Retail Sale Id 1627947',1001.00,0.00,0.00,1.54,58.52,'2022-04-08 17:56:57','',''),(2635331,'1','179','933',413,'Retail Sale Id 1627948',1001.00,0.00,0.00,1.54,58.52,'2022-04-08 17:59:32','',''),(2635332,'1','179','933',413,'Retail Sale Id 1627949',6500.00,0.00,0.00,10.00,380.00,'2022-04-08 18:07:09','',''),(2635333,'1','179','933',413,'Retail Sale Id 1627950',8125.00,0.00,0.00,12.50,475.00,'2022-04-08 18:24:51','',''),(2635334,'1','179','933',413,'Retail Sale Id 1627951',1501.50,0.00,0.00,2.31,87.78,'2022-04-08 18:25:32','',''),(2635335,'1','179','933',413,'Retail Sale Id 1627952',8001.50,0.00,0.00,12.31,467.78,'2022-04-08 18:31:46','',''),(2635336,'1','179','933',413,'Retail Sale Id 1627953',3997.50,0.00,0.00,6.15,233.70,'2022-04-09 08:26:56','',''),(2635337,'1','179','933',413,'Retail Sale Id 1627954',1950.00,0.00,0.00,3.00,114.00,'2022-04-09 08:46:13','',''),(2635338,'1','179','933',413,'Retail Sale Id 1627955',1001.00,0.00,0.00,1.54,58.52,'2022-04-09 08:47:13','',''),(2635339,'1','179','933',413,'Retail Sale Id 1627956',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 08:50:38','',''),(2635340,'1','179','933',413,'Retail Sale Id 1627957',6552.00,0.00,0.00,10.08,383.04,'2022-04-09 09:33:17','',''),(2635341,'1','179','933',413,'Retail Sale Id 1627958',8001.50,0.00,0.00,12.31,467.78,'2022-04-09 09:38:34','',''),(2635342,'1','179','933',413,'Retail Sale Id 1627959',4550.00,0.00,0.00,7.00,266.00,'2022-04-09 10:05:59','',''),(2635343,'1','179','933',413,'Retail Sale Id 1627960',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 10:16:20','',''),(2635344,'1','179','933',413,'Retail Sale Id 1627961',1950.00,0.00,0.00,3.00,114.00,'2022-04-09 10:31:41','',''),(2635345,'1','179','933',413,'Retail Sale Id 1627962',1300.00,0.00,0.00,2.00,76.00,'2022-04-09 11:30:43','',''),(2635346,'1','179','933',413,'Retail Sale Id 1627963',3497.00,0.00,0.00,5.38,204.44,'2022-04-09 12:13:04','',''),(2635347,'1','179','933',413,'Return of Retail Sale Id 1627963',0.00,3497.00,5.38,0.00,-204.44,'2022-04-09 12:13:45','',''),(2635348,'1','179','933',413,'Return of Retail Sale Id 1627962',0.00,1300.00,2.00,0.00,-76.00,'2022-04-09 12:14:20','',''),(2635349,'1','179','933',413,'Retail Sale Id 1627964',5200.00,0.00,0.00,8.00,304.00,'2022-04-09 13:05:01','',''),(2635350,'1','179','933',413,'Return of Retail Sale Id 1627964',0.00,5200.00,8.00,0.00,-304.00,'2022-04-09 13:06:00','',''),(2635351,'1','179','933',413,'Retail Sale Id 1627965',5999.50,0.00,0.00,9.23,350.74,'2022-04-09 13:33:27','',''),(2635352,'1','179','933',413,'Return of Retail Sale Id 1627965',0.00,5999.50,9.23,0.00,-350.74,'2022-04-09 13:33:58','',''),(2635353,'1','179','933',413,'Retail Sale Id 1627966',1001.00,0.00,0.00,1.54,58.52,'2022-04-09 14:27:28','',''),(2635354,'1','179','933',413,'Retail Sale Id 1627967',3250.00,0.00,0.00,5.00,190.00,'2022-04-09 14:28:08','',''),(2635355,'1','179','933',413,'Retail Sale Id 1627968',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 14:28:32','',''),(2635356,'1','179','933',413,'Retail Sale Id 1627969',3003.00,0.00,0.00,4.62,175.56,'2022-04-09 14:30:21','',''),(2635357,'1','179','933',413,'Retail Sale Id 1627970',1950.00,0.00,0.00,3.00,114.00,'2022-04-09 14:31:01','',''),(2635358,'1','179','933',413,'Retail Sale Id 1627971',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 14:42:48','',''),(2635359,'1','179','933',413,'Retail Sale Id 1627974',3003.00,0.00,0.00,4.62,175.56,'2022-04-09 14:51:21','',''),(2635360,'1','179','933',413,'Retail Sale Id 1627975',2002.00,0.00,0.00,3.08,117.04,'2022-04-09 14:52:38','',''),(2635361,'1','179','933',413,'Retail Sale Id 1627976',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 15:05:02','',''),(2635362,'1','179','933',413,'Retail Sale Id 1627977',2600.00,0.00,0.00,4.00,152.00,'2022-04-09 15:06:16','',''),(2635363,'1','179','933',413,'Retail Sale Id 1627979',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 15:15:11','',''),(2635364,'1','179','933',413,'Retail Sale Id 1627980',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 15:29:58','',''),(2635365,'1','179','933',413,'Retail Sale Id 1627981',5499.00,0.00,0.00,8.46,321.48,'2022-04-09 15:50:47','',''),(2635366,'1','179','933',413,'Retail Sale Id 1627982',2600.00,0.00,0.00,4.00,152.00,'2022-04-09 16:44:10','',''),(2635367,'1','179','933',413,'Retail Sale Id 1627983',1950.00,0.00,0.00,3.00,114.00,'2022-04-09 16:44:46','',''),(2635368,'1','179','933',413,'Retail Sale Id 1627984',3997.50,0.00,0.00,6.15,233.70,'2022-04-09 17:06:06','',''),(2635369,'1','179','933',413,'Retail Sale Id 1627984',5850.00,0.00,0.00,9.00,342.00,'2022-04-09 17:06:06','',''),(2635370,'1','179','933',413,'Retail Sale Id 1627984',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 17:06:06','',''),(2635371,'1','179','933',413,'Retail Sale Id 1627985',3997.50,0.00,0.00,6.15,233.70,'2022-04-09 17:07:03','',''),(2635372,'1','179','933',413,'Retail Sale Id 1627986',3250.00,0.00,0.00,5.00,190.00,'2022-04-09 17:08:22','',''),(2635373,'1','179','933',413,'Retail Sale Id 1627987',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 17:09:58','',''),(2635374,'1','179','933',413,'Retail Sale Id 1627988',6500.00,0.00,0.00,10.00,380.00,'2022-04-09 17:29:56','',''),(2635375,'1','179','933',413,'Retail Sale Id 1627989',5999.50,0.00,0.00,9.23,350.74,'2022-04-09 17:33:07','',''),(2635376,'1','179','933',413,'Retail Sale Id 1627989',7150.00,0.00,0.00,11.00,418.00,'2022-04-09 17:33:07','',''),(2635377,'1','179','933',413,'Retail Sale Id 1627989',7800.00,0.00,0.00,12.00,456.00,'2022-04-09 17:33:07','',''),(2635378,'1','179','933',413,'Retail Sale Id 1627989',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 17:33:07','',''),(2635379,'1','179','933',413,'Retail Sale Id 1627990',3003.00,0.00,0.00,4.62,175.56,'2022-04-09 17:36:17','',''),(2635380,'1','179','933',413,'Retail Sale Id 1627991',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 17:38:25','',''),(2635381,'1','179','933',413,'Retail Sale Id 1627992',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 17:39:19','',''),(2635382,'1','179','933',413,'Retail Sale Id 1627993',2002.00,0.00,0.00,3.08,117.04,'2022-04-09 17:52:40','',''),(2635383,'1','179','933',413,'Retail Sale Id 1627994',8125.00,0.00,0.00,12.50,475.00,'2022-04-09 17:53:18','',''),(2635384,'1','179','933',413,'Retail Sale Id 1627995',7949.50,0.00,0.00,12.23,464.74,'2022-04-09 18:05:41','',''),(2635385,'1','179','933',413,'Retail Sale Id 1627996',3900.00,0.00,0.00,6.00,228.00,'2022-04-09 18:06:52','',''),(2635386,'1','179','933',413,'Retail Sale Id 1627997',3250.00,0.00,0.00,5.00,190.00,'2022-04-09 18:07:51','',''),(2635387,'1','179','933',413,'Retail Sale Id 1627998',2002.00,0.00,0.00,3.08,117.04,'2022-04-09 18:09:20','',''),(2635388,'1','179','933',413,'Retail Sale Id 1627999',4199.00,0.00,0.00,6.46,245.48,'2022-04-09 18:40:24','',''),(2635389,'1','179','933',413,'Retail Sale Id 1628000',3302.00,0.00,0.00,5.08,193.04,'2022-04-10 07:55:26','',''),(2635390,'1','179','933',413,'Retail Sale Id 1628001',10075.00,0.00,0.00,15.50,589.00,'2022-04-10 07:58:00','',''),(2635391,'1','179','933',413,'Retail Sale Id 1628002',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 08:24:09','',''),(2635392,'1','179','933',413,'Retail Sale Id 1628003',1001.00,0.00,0.00,1.54,58.52,'2022-04-10 08:55:58','',''),(2635393,'1','179','933',413,'Retail Sale Id 1628004',3250.00,0.00,0.00,5.00,190.00,'2022-04-10 09:37:38','',''),(2635394,'1','179','933',413,'Retail Sale Id 1628005',1501.50,0.00,0.00,2.31,87.78,'2022-04-10 09:40:39','',''),(2635395,'1','179','933',413,'Retail Sale Id 1628006',8125.00,0.00,0.00,12.50,475.00,'2022-04-10 09:42:08','',''),(2635396,'1','179','933',413,'Retail Sale Id 1628007',3848.00,0.00,0.00,5.92,224.96,'2022-04-10 10:09:24','',''),(2635397,'1','179','933',413,'Retail Sale Id 1628008',4550.00,0.00,0.00,7.00,266.00,'2022-04-10 10:11:05','',''),(2635398,'1','179','933',413,'Retail Sale Id 1628009',2600.00,0.00,0.00,4.00,152.00,'2022-04-10 10:23:45','',''),(2635399,'1','179','933',413,'Retail Sale Id 1628010',1950.00,0.00,0.00,3.00,114.00,'2022-04-10 10:27:56','',''),(2635400,'1','179','933',413,'Retail Sale Id 1628011',9100.00,0.00,0.00,14.00,532.00,'2022-04-10 10:30:22','',''),(2635401,'1','179','933',413,'Retail Sale Id 1628012',1300.00,0.00,0.00,2.00,76.00,'2022-04-10 10:34:01','',''),(2635402,'1','179','933',413,'Retail Sale Id 1628013',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 10:40:03','',''),(2635403,'1','179','933',413,'Retail Sale Id 1628014',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 10:44:25','',''),(2635404,'1','179','933',413,'Retail Sale Id 1628015',1950.00,0.00,0.00,3.00,114.00,'2022-04-10 11:28:55','',''),(2635405,'1','179','933',413,'Retail Sale Id 1628016',8203.00,0.00,0.00,12.62,479.56,'2022-04-10 11:33:25','',''),(2635406,'1','179','933',413,'Retail Sale Id 1628017',8125.00,0.00,0.00,12.50,475.00,'2022-04-10 11:35:48','',''),(2635407,'1','179','933',413,'Retail Sale Id 1628018',8001.50,0.00,0.00,12.31,467.78,'2022-04-10 11:41:09','',''),(2635408,'1','179','933',413,'Retail Sale Id 1628019',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 11:42:21','',''),(2635409,'1','179','933',413,'Retail Sale Id 1628020',3302.00,0.00,0.00,5.08,193.04,'2022-04-10 12:07:04','',''),(2635410,'1','179','933',413,'Retail Sale Id 1628021',3003.00,0.00,0.00,4.62,175.56,'2022-04-10 12:20:50','',''),(2635411,'1','179','933',413,'Retail Sale Id 1628021',4998.50,0.00,0.00,7.69,292.22,'2022-04-10 12:20:50','',''),(2635412,'1','179','933',413,'Retail Sale Id 1628022',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 12:22:23','',''),(2635413,'1','179','933',413,'Retail Sale Id 1628023',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 12:24:32','',''),(2635414,'1','179','933',413,'Retail Sale Id 1628024',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 12:26:22','',''),(2635415,'1','179','933',413,'Retail Sale Id 1628025',1300.00,0.00,0.00,2.00,76.00,'2022-04-10 12:36:48','',''),(2635416,'1','179','933',413,'Return of Retail Sale Id 1628022',0.00,3900.00,6.00,0.00,-228.00,'2022-04-10 12:38:08','',''),(2635417,'1','179','933',413,'Retail Sale Id 1628026',2600.00,0.00,0.00,4.00,152.00,'2022-04-10 12:38:38','',''),(2635418,'1','179','933',413,'Retail Sale Id 1628027',3003.00,0.00,0.00,4.62,175.56,'2022-04-10 12:39:29','',''),(2635419,'1','179','933',413,'Retail Sale Id 1628028',3302.00,0.00,0.00,5.08,193.04,'2022-04-10 12:40:17','',''),(2635420,'1','179','933',413,'Retail Sale Id 1628029',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 14:05:34','',''),(2635421,'1','179','933',413,'Retail Sale Id 1628030',1300.00,0.00,0.00,2.00,76.00,'2022-04-10 14:13:51','',''),(2635422,'1','179','933',413,'Retail Sale Id 1628031',7000.50,0.00,0.00,10.77,409.26,'2022-04-10 14:20:08','',''),(2635423,'1','179','933',413,'Retail Sale Id 1628032',1001.00,0.00,0.00,1.54,58.52,'2022-04-10 14:22:43','',''),(2635424,'1','179','933',413,'Retail Sale Id 1628033',8203.00,0.00,0.00,12.62,479.56,'2022-04-10 14:26:10','',''),(2635425,'1','179','933',413,'Retail Sale Id 1628034',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 14:31:45','',''),(2635426,'1','179','933',413,'Retail Sale Id 1628035',3250.00,0.00,0.00,5.00,190.00,'2022-04-10 14:34:41','',''),(2635427,'1','179','933',413,'Retail Sale Id 1628036',6500.00,0.00,0.00,10.00,380.00,'2022-04-10 15:40:07','',''),(2635428,'1','179','933',413,'Retail Sale Id 1628038',3250.00,0.00,0.00,5.00,190.00,'2022-04-10 15:53:25','',''),(2635429,'1','179','933',413,'Retail Sale Id 1628039',2502.50,0.00,0.00,3.85,146.30,'2022-04-10 16:24:03','',''),(2635430,'1','179','933',413,'Retail Sale Id 1628040',1300.00,0.00,0.00,2.00,76.00,'2022-04-10 16:31:43','',''),(2635431,'1','179','933',413,'Return of Retail Sale Id 1628040',0.00,1300.00,2.00,0.00,-76.00,'2022-04-10 16:32:21','',''),(2635432,'1','179','933',413,'Retail Sale Id 1628041',1950.00,0.00,0.00,3.00,114.00,'2022-04-10 16:33:11','',''),(2635433,'1','179','933',413,'Retail Sale Id 1628042',7150.00,0.00,0.00,11.00,418.00,'2022-04-10 16:34:03','',''),(2635434,'1','179','933',413,'Retail Sale Id 1628043',3997.50,0.00,0.00,6.15,233.70,'2022-04-10 16:39:00','',''),(2635435,'1','179','933',413,'Return of Retail Sale Id 1628043',0.00,3997.50,6.15,0.00,-233.70,'2022-04-10 16:41:44','',''),(2635436,'1','179','933',413,'Retail Sale Id 1628044',3997.50,0.00,0.00,6.15,233.70,'2022-04-10 16:42:11','',''),(2635437,'1','179','933',413,'Retail Sale Id 1628045',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 16:52:58','',''),(2635438,'1','179','933',413,'Retail Sale Id 1628046',2697.50,0.00,0.00,4.15,157.70,'2022-04-10 16:54:00','',''),(2635439,'1','179','933',413,'Retail Sale Id 1628047',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 16:58:35','',''),(2635440,'1','179','933',413,'Retail Sale Id 1628048',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 17:26:46','',''),(2635441,'1','179','933',413,'Retail Sale Id 1628049',8125.00,0.00,0.00,12.50,475.00,'2022-04-10 17:32:17','',''),(2635442,'1','179','933',413,'Retail Sale Id 1628050',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 17:34:59','',''),(2635443,'1','179','933',413,'Retail Sale Id 1628051',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 17:38:21','',''),(2635444,'1','179','933',413,'Retail Sale Id 1628052',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 17:40:15','',''),(2635445,'1','179','933',413,'Retail Sale Id 1628053',1001.00,0.00,0.00,1.54,58.52,'2022-04-10 17:43:38','',''),(2635446,'1','179','933',413,'Retail Sale Id 1628054',1300.00,0.00,0.00,2.00,76.00,'2022-04-10 17:48:25','',''),(2635447,'1','179','933',413,'Retail Sale Id 1628055',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 17:52:48','',''),(2635448,'1','179','933',413,'Retail Sale Id 1628056',2600.00,0.00,0.00,4.00,152.00,'2022-04-10 18:04:10','',''),(2635449,'1','179','933',413,'Retail Sale Id 1628057',2002.00,0.00,0.00,3.08,117.04,'2022-04-10 18:25:04','',''),(2635450,'1','179','933',413,'Retail Sale Id 1628058',3003.00,0.00,0.00,4.62,175.56,'2022-04-10 18:31:08','',''),(2635451,'1','179','933',413,'Retail Sale Id 1628059',1001.00,0.00,0.00,1.54,58.52,'2022-04-10 18:34:35','',''),(2635452,'1','179','933',413,'Retail Sale Id 1628060',3900.00,0.00,0.00,6.00,228.00,'2022-04-10 18:38:33','',''),(2635453,'1','179','933',413,'Retail Sale Id 1628061',3997.50,0.00,0.00,6.15,233.70,'2022-04-10 19:12:27','',''),(2635454,'1','179','933',413,'Retail Sale Id 1628062',3900.00,0.00,0.00,6.00,228.00,'2022-04-11 08:19:13','',''),(2635455,'1','179','933',413,'Retail Sale Id 1628063',8125.00,0.00,0.00,12.50,475.00,'2022-04-11 09:01:00','',''),(2635456,'1','179','933',413,'Retail Sale Id 1628064',3997.50,0.00,0.00,6.15,233.70,'2022-04-11 09:05:35','',''),(2635457,'1','179','933',413,'Retail Sale Id 1628065',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 09:15:37','',''),(2635458,'1','179','933',413,'Retail Sale Id 1628066',5850.00,0.00,0.00,9.00,342.00,'2022-04-11 09:17:00','',''),(2635459,'1','179','933',413,'Retail Sale Id 1628067',1300.00,0.00,0.00,2.00,76.00,'2022-04-11 09:30:21','',''),(2635460,'1','179','933',413,'Retail Sale Id 1628068',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 09:43:35','',''),(2635461,'1','179','933',413,'Retail Sale Id 1628069',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 09:46:52','',''),(2635462,'1','179','933',413,'Retail Sale Id 1628070',3900.00,0.00,0.00,6.00,228.00,'2022-04-11 10:36:45','',''),(2635463,'1','179','933',413,'Retail Sale Id 1628071',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 10:38:11','',''),(2635464,'1','179','933',413,'Retail Sale Id 1628072',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 10:39:53','',''),(2635465,'1','179','933',413,'Retail Sale Id 1628073',8125.00,0.00,0.00,12.50,475.00,'2022-04-11 10:42:01','',''),(2635466,'1','179','933',413,'Retail Sale Id 1628074',3900.00,0.00,0.00,6.00,228.00,'2022-04-11 10:53:18','',''),(2635467,'1','179','933',413,'Retail Sale Id 1628076',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 11:10:25','',''),(2635468,'1','179','933',413,'Retail Sale Id 1628077',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 11:37:51','',''),(2635469,'1','179','933',413,'Retail Sale Id 1628078',8125.00,0.00,0.00,12.50,475.00,'2022-04-11 12:16:38','',''),(2635470,'1','179','933',413,'Retail Sale Id 1628079',2002.00,0.00,0.00,3.08,117.04,'2022-04-11 12:25:46','',''),(2635471,'1','179','933',413,'Retail Sale Id 1628080',2600.00,0.00,0.00,4.00,152.00,'2022-04-11 12:27:18','',''),(2635472,'1','179','933',413,'Retail Sale Id 1628081',2002.00,0.00,0.00,3.08,117.04,'2022-04-11 12:39:02','',''),(2635473,'1','179','933',413,'Retail Sale Id 1628082',3900.00,0.00,0.00,6.00,228.00,'2022-04-11 12:40:28','',''),(2635474,'1','179','933',413,'Retail Sale Id 1628083',3997.50,0.00,0.00,6.15,233.70,'2022-04-11 12:43:44','',''),(2635475,'1','179','933',413,'Retail Sale Id 1628084',3003.00,0.00,0.00,4.62,175.56,'2022-04-11 14:01:25','',''),(2635476,'1','179','933',413,'Retail Sale Id 1628086',11375.00,0.00,0.00,17.50,665.00,'2022-04-11 14:37:12','',''),(2635477,'1','179','933',413,'Retail Sale Id 1628087',2002.00,0.00,0.00,3.08,117.04,'2022-04-11 14:38:26','',''),(2635478,'1','179','933',413,'Retail Sale Id 1628088',5200.00,0.00,0.00,8.00,304.00,'2022-04-11 15:05:45','',''),(2635479,'1','179','933',413,'Retail Sale Id 1628089',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 15:21:09','',''),(2635480,'1','179','933',413,'Retail Sale Id 1628090',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 15:28:49','',''),(2635481,'1','179','933',413,'Retail Sale Id 1628090',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 15:28:49','',''),(2635482,'1','179','933',413,'Retail Sale Id 1628091',1300.00,0.00,0.00,2.00,76.00,'2022-04-11 15:36:47','',''),(2635483,'1','179','933',413,'Retail Sale Id 1628092',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 15:43:16','',''),(2635484,'1','179','933',413,'Retail Sale Id 1628093',1001.00,0.00,0.00,1.54,58.52,'2022-04-11 15:45:25','',''),(2635485,'1','179','933',413,'Retail Sale Id 1628094',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 15:46:29','',''),(2635486,'1','179','933',413,'Retail Sale Id 1628095',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 15:47:16','',''),(2635487,'1','179','933',413,'Retail Sale Id 1628096',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 15:49:07','',''),(2635488,'1','179','933',413,'Retail Sale Id 1628097',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 15:50:50','',''),(2635489,'1','179','933',413,'Retail Sale Id 1628098',3900.00,0.00,0.00,6.00,228.00,'2022-04-11 16:08:02','',''),(2635490,'1','179','933',413,'Retail Sale Id 1628099',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 16:10:39','',''),(2635491,'1','179','933',413,'Retail Sale Id 1628100',3250.00,0.00,0.00,5.00,190.00,'2022-04-11 16:30:01','',''),(2635492,'1','179','933',413,'Retail Sale Id 1628101',3900.00,0.00,0.00,6.00,228.00,'2022-04-11 16:33:50','',''),(2635493,'1','179','933',413,'Retail Sale Id 1628102',8125.00,0.00,0.00,12.50,475.00,'2022-04-11 16:35:01','',''),(2635494,'1','179','933',413,'Retail Sale Id 1628103',8125.00,0.00,0.00,12.50,475.00,'2022-04-11 16:40:56','',''),(2635495,'1','179','933',413,'Retail Sale Id 1628104',8125.00,0.00,0.00,12.50,475.00,'2022-04-11 17:01:11','',''),(2635496,'1','179','933',413,'Retail Sale Id 1628105',2002.00,0.00,0.00,3.08,117.04,'2022-04-11 17:03:55','',''),(2635497,'1','179','933',413,'Retail Sale Id 1628106',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 17:27:57','',''),(2635498,'1','179','933',413,'Retail Sale Id 1628107',1001.00,0.00,0.00,1.54,58.52,'2022-04-11 17:29:05','',''),(2635499,'1','179','933',413,'Retail Sale Id 1628108',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 17:31:17','',''),(2635500,'1','179','933',413,'Retail Sale Id 1628109',1300.00,0.00,0.00,2.00,76.00,'2022-04-11 17:32:46','',''),(2635501,'1','179','933',413,'Retail Sale Id 1628110',1950.00,0.00,0.00,3.00,114.00,'2022-04-11 17:42:38','',''),(2635502,'1','179','933',413,'Retail Sale Id 1628111',2002.00,0.00,0.00,3.08,117.04,'2022-04-11 17:50:52','',''),(2635503,'1','179','933',413,'Retail Sale Id 1628111',2002.00,0.00,0.00,3.08,117.04,'2022-04-11 17:50:52','',''),(2635504,'1','179','933',413,'Retail Sale Id 1628112',1001.00,0.00,0.00,1.54,58.52,'2022-04-11 18:17:23','',''),(2635505,'1','179','933',413,'Retail Sale Id 1628113',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 08:36:27','',''),(2635506,'1','179','933',413,'Retail Sale Id 1628114',1001.00,0.00,0.00,1.54,58.52,'2022-04-12 08:55:14','',''),(2635507,'1','179','933',413,'Retail Sale Id 1628115',1300.00,0.00,0.00,2.00,76.00,'2022-04-12 09:27:29','',''),(2635508,'1','179','933',413,'Retail Sale Id 1628116',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 09:28:21','',''),(2635509,'1','179','933',413,'Retail Sale Id 1628117',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 09:39:47','',''),(2635510,'1','179','933',413,'Retail Sale Id 1628118',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 09:44:29','',''),(2635511,'1','179','933',413,'Retail Sale Id 1628119',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 10:04:29','',''),(2635512,'1','179','933',413,'Retail Sale Id 1628120',7475.00,0.00,0.00,11.50,437.00,'2022-04-12 10:11:39','',''),(2635513,'1','179','933',413,'Retail Sale Id 1628121',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 10:12:57','',''),(2635514,'1','179','933',413,'Retail Sale Id 1628122',1300.00,0.00,0.00,2.00,76.00,'2022-04-12 10:41:53','',''),(2635515,'1','179','933',413,'Retail Sale Id 1628123',3003.00,0.00,0.00,4.62,175.56,'2022-04-12 10:49:49','',''),(2635516,'1','179','933',413,'Retail Sale Id 1628124',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 10:59:00','',''),(2635517,'1','179','933',413,'Retail Sale Id 1628125',7000.50,0.00,0.00,10.77,409.26,'2022-04-12 11:27:59','',''),(2635518,'1','179','933',413,'Retail Sale Id 1628126',8125.00,0.00,0.00,12.50,475.00,'2022-04-12 11:29:08','',''),(2635519,'1','179','933',413,'Retail Sale Id 1628127',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 11:58:11','',''),(2635520,'1','179','933',413,'Retail Sale Id 1628128',2002.00,0.00,0.00,3.08,117.04,'2022-04-12 12:17:54','',''),(2635521,'1','179','933',413,'Retail Sale Id 1628129',1001.00,0.00,0.00,1.54,58.52,'2022-04-12 12:21:03','',''),(2635522,'1','179','933',413,'Retail Sale Id 1628130',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 12:40:59','',''),(2635523,'1','179','933',413,'Retail Sale Id 1628131',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 12:42:42','',''),(2635524,'1','179','933',413,'Retail Sale Id 1628132',2600.00,0.00,0.00,4.00,152.00,'2022-04-12 12:53:44','',''),(2635525,'1','179','933',413,'Retail Sale Id 1628133',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 12:57:03','',''),(2635526,'1','179','933',413,'Retail Sale Id 1628134',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 13:11:37','',''),(2635527,'1','179','933',413,'Retail Sale Id 1628134',3250.00,0.00,0.00,5.00,190.00,'2022-04-12 13:11:37','',''),(2635528,'1','179','933',413,'Retail Sale Id 1628135',8125.00,0.00,0.00,12.50,475.00,'2022-04-12 13:26:10','',''),(2635529,'1','179','933',413,'Retail Sale Id 1628136',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 13:27:40','',''),(2635530,'1','179','933',413,'Retail Sale Id 1628137',1300.00,0.00,0.00,2.00,76.00,'2022-04-12 13:41:06','',''),(2635531,'1','179','933',413,'Retail Sale Id 1628138',2847.00,0.00,0.00,4.38,166.44,'2022-04-12 13:42:28','',''),(2635532,'1','179','933',413,'Retail Sale Id 1628139',8125.00,0.00,0.00,12.50,475.00,'2022-04-12 13:50:30','',''),(2635533,'1','179','933',413,'Retail Sale Id 1628140',8125.00,0.00,0.00,12.50,475.00,'2022-04-12 13:56:59','',''),(2635534,'1','179','933',413,'Retail Sale Id 1628141',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 14:34:20','',''),(2635535,'1','179','933',413,'Retail Sale Id 1628142',2600.00,0.00,0.00,4.00,152.00,'2022-04-12 14:52:50','',''),(2635536,'1','179','933',413,'Retail Sale Id 1628143',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 14:57:54','',''),(2635537,'1','179','933',413,'Retail Sale Id 1628144',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 15:00:51','',''),(2635538,'1','179','933',413,'Retail Sale Id 1628145',8125.00,0.00,0.00,12.50,475.00,'2022-04-12 15:12:49','',''),(2635539,'1','179','933',413,'Retail Sale Id 1628146',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 15:14:15','',''),(2635540,'1','179','933',413,'Retail Sale Id 1628147',7800.00,0.00,0.00,12.00,456.00,'2022-04-12 15:49:37','',''),(2635541,'1','179','933',413,'Retail Sale Id 1628149',3250.00,0.00,0.00,5.00,190.00,'2022-04-12 16:30:04','',''),(2635542,'1','179','933',413,'Retail Sale Id 1628150',3601.00,0.00,0.00,5.54,210.52,'2022-04-12 16:31:58','',''),(2635543,'1','179','933',413,'Retail Sale Id 1628151',8125.00,0.00,0.00,12.50,475.00,'2022-04-12 16:39:02','',''),(2635544,'1','179','933',413,'Retail Sale Id 1628152',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 16:39:59','',''),(2635545,'1','179','933',413,'Retail Sale Id 1628153',1950.00,0.00,0.00,3.00,114.00,'2022-04-12 16:44:51','',''),(2635546,'1','179','933',413,'Retail Sale Id 1628154',3900.00,0.00,0.00,6.00,228.00,'2022-04-12 16:52:50','',''),(2635547,'1','179','933',413,'Retail Sale Id 1628155',3997.50,0.00,0.00,6.15,233.70,'2022-04-12 17:09:41','',''),(2635548,'1','179','933',413,'Retail Sale Id 1628156',3003.00,0.00,0.00,4.62,175.56,'2022-04-12 17:24:12','',''),(2635549,'1','179','933',413,'Retail Sale Id 1628157',3997.50,0.00,0.00,6.15,233.70,'2022-04-12 17:33:20','',''),(2635550,'1','179','933',413,'Retail Sale Id 1628158',2002.00,0.00,0.00,3.08,117.04,'2022-04-12 17:34:17','',''),(2635551,'1','179','933',413,'Retail Sale Id 1628159',1001.00,0.00,0.00,1.54,58.52,'2022-04-12 17:35:11','',''),(2635552,'1','179','933',413,'Retail Sale Id 1628160',2002.00,0.00,0.00,3.08,117.04,'2022-04-12 17:38:48','',''),(2635553,'1','179','933',413,'Retail Sale Id 1628161',2002.00,0.00,0.00,3.08,117.04,'2022-04-12 17:57:55','',''),(2635554,'1','179','933',413,'Retail Sale Id 1628162',650.00,0.00,0.00,1.00,38.00,'2022-04-12 18:06:27','',''),(2635555,'1','179','933',413,'Retail Sale Id 1628163',9899.50,0.00,0.00,15.23,578.74,'2022-04-12 18:29:08','',''),(2635556,'1','179','933',413,'Retail Sale Id 1628164',5999.50,0.00,0.00,9.23,350.74,'2022-04-13 08:50:13','',''),(2635557,'1','179','933',413,'Retail Sale Id 1628164',13000.00,0.00,0.00,20.00,760.00,'2022-04-13 08:50:13','',''),(2635558,'1','179','933',413,'Retail Sale Id 1628165',2002.00,0.00,0.00,3.08,117.04,'2022-04-13 09:03:27','',''),(2635559,'1','179','933',413,'Retail Sale Id 1628166',1501.50,0.00,0.00,2.31,87.78,'2022-04-13 09:04:16','',''),(2635560,'1','179','933',413,'Retail Sale Id 1628167',3900.00,0.00,0.00,6.00,228.00,'2022-04-13 10:06:42','',''),(2635561,'1','179','933',413,'Retail Sale Id 1628168',3997.50,0.00,0.00,6.15,233.70,'2022-04-13 10:07:25','',''),(2635562,'1','179','933',413,'Retail Sale Id 1628169',7800.00,0.00,0.00,12.00,456.00,'2022-04-13 10:28:32','',''),(2635563,'1','179','933',413,'Retail Sale Id 1628169',8125.00,0.00,0.00,12.50,475.00,'2022-04-13 10:28:32','',''),(2635564,'1','179','933',413,'Retail Sale Id 1628170',5200.00,0.00,0.00,8.00,304.00,'2022-04-13 10:41:57','',''),(2635565,'1','179','933',413,'Retail Sale Id 1628171',3900.00,0.00,0.00,6.00,228.00,'2022-04-13 10:50:48','',''),(2635566,'1','179','933',413,'Retail Sale Id 1628172',3250.00,0.00,0.00,5.00,190.00,'2022-04-13 10:51:56','',''),(2635567,'1','179','933',413,'Retail Sale Id 1628173',1501.50,0.00,0.00,2.31,87.78,'2022-04-13 11:22:35','',''),(2635568,'1','179','933',413,'Retail Sale Id 1628174',4998.50,0.00,0.00,7.69,292.22,'2022-04-13 11:32:47','',''),(2635569,'1','179','933',413,'Retail Sale Id 1628175',1950.00,0.00,0.00,3.00,114.00,'2022-04-13 11:44:19','',''),(2635570,'1','179','933',413,'Retail Sale Id 1628176',5499.00,0.00,0.00,8.46,321.48,'2022-04-13 12:16:44','',''),(2635571,'1','179','933',413,'Retail Sale Id 1628178',2002.00,0.00,0.00,3.08,117.04,'2022-04-13 12:23:42','',''),(2635572,'1','179','933',413,'Retail Sale Id 1628179',8125.00,0.00,0.00,12.50,475.00,'2022-04-13 12:25:34','',''),(2635573,'1','179','933',413,'Retail Sale Id 1628180',8125.00,0.00,0.00,12.50,475.00,'2022-04-13 12:52:16','',''),(2635574,'1','179','933',413,'Retail Sale Id 1628181',6500.00,0.00,0.00,10.00,380.00,'2022-04-13 13:19:19','',''),(2635575,'1','179','933',413,'Retail Sale Id 1628182',3250.00,0.00,0.00,5.00,190.00,'2022-04-13 13:26:24','',''),(2635576,'1','179','933',413,'Retail Sale Id 1628183',6500.00,0.00,0.00,10.00,380.00,'2022-04-13 14:00:24','',''),(2635577,'1','179','933',413,'Retail Sale Id 1628184',975.00,0.00,0.00,1.50,57.00,'2022-04-13 14:05:37','',''),(2635578,'1','179','933',413,'Retail Sale Id 1628185',2600.00,0.00,0.00,4.00,152.00,'2022-04-13 14:12:10','',''),(2635579,'1','179','933',413,'Retail Sale Id 1628186',1950.00,0.00,0.00,3.00,114.00,'2022-04-13 14:23:11','',''),(2635580,'1','179','933',413,'Retail Sale Id 1628187',3003.00,0.00,0.00,4.62,175.56,'2022-04-13 14:57:53','',''),(2635581,'1','179','933',413,'Retail Sale Id 1628188',3997.50,0.00,0.00,6.15,233.70,'2022-04-13 14:58:58','',''),(2635582,'1','179','933',413,'Retail Sale Id 1628189',3003.00,0.00,0.00,4.62,175.56,'2022-04-13 15:04:33','',''),(2635583,'1','179','933',413,'Retail Sale Id 1628190',2002.00,0.00,0.00,3.08,117.04,'2022-04-13 15:08:44','',''),(2635584,'1','179','933',413,'Retail Sale Id 1628191',2002.00,0.00,0.00,3.08,117.04,'2022-04-13 15:36:22','',''),(2635585,'1','179','933',413,'Retail Sale Id 1628192',3003.00,0.00,0.00,4.62,175.56,'2022-04-13 16:00:37','',''),(2635586,'1','179','933',413,'Retail Sale Id 1628193',2600.00,0.00,0.00,4.00,152.00,'2022-04-13 16:09:44','',''),(2635587,'1','179','933',413,'Retail Sale Id 1628194',8125.00,0.00,0.00,12.50,475.00,'2022-04-13 16:15:49','',''),(2635588,'1','179','933',413,'Retail Sale Id 1628195',3997.50,0.00,0.00,6.15,233.70,'2022-04-13 16:29:14','',''),(2635589,'1','179','933',413,'Retail Sale Id 1628197',3900.00,0.00,0.00,6.00,228.00,'2022-04-13 16:54:55','',''),(2635590,'1','179','933',413,'Retail Sale Id 1628198',1001.00,0.00,0.00,1.54,58.52,'2022-04-13 17:13:46','',''),(2635591,'1','179','933',413,'Retail Sale Id 1628199',3250.00,0.00,0.00,5.00,190.00,'2022-04-13 17:20:39','',''),(2635592,'1','179','933',413,'Retail Sale Id 1628200',3250.00,0.00,0.00,5.00,190.00,'2022-04-13 17:21:49','',''),(2635593,'1','179','933',413,'Retail Sale Id 1628201',3250.00,0.00,0.00,5.00,190.00,'2022-04-13 17:50:22','',''),(2635594,'1','179','933',413,'Retail Sale Id 1628202',2002.00,0.00,0.00,3.08,117.04,'2022-04-13 17:51:10','',''),(2635595,'1','179','933',413,'Retail Sale Id 1628203',3900.00,0.00,0.00,6.00,228.00,'2022-04-13 17:59:13','',''),(2635596,'1','179','933',413,'Retail Sale Id 1628204',8125.00,0.00,0.00,12.50,475.00,'2022-04-13 18:02:16','',''),(2635597,'1','179','933',413,'Retail Sale Id 1628205',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 08:41:34','',''),(2635598,'1','179','933',413,'Retail Sale Id 1628206',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 08:56:27','',''),(2635599,'1','179','933',413,'Retail Sale Id 1628207',1703.00,0.00,0.00,2.62,99.56,'2022-04-14 09:39:05','',''),(2635600,'1','179','933',413,'Retail Sale Id 1628208',2002.00,0.00,0.00,3.08,117.04,'2022-04-14 09:43:18','',''),(2635601,'1','179','933',413,'Retail Sale Id 1628209',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 09:54:29','',''),(2635602,'1','179','933',413,'Retail Sale Id 1628210',3250.00,0.00,0.00,5.00,190.00,'2022-04-14 10:03:28','',''),(2635603,'1','179','933',413,'Retail Sale Id 1628211',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 10:06:27','',''),(2635604,'1','179','933',413,'Retail Sale Id 1628212',3003.00,0.00,0.00,4.62,175.56,'2022-04-14 10:30:48','',''),(2635605,'1','179','933',413,'Retail Sale Id 1628213',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 10:47:00','',''),(2635606,'1','179','933',413,'Retail Sale Id 1628214',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 10:55:59','',''),(2635607,'1','179','933',413,'Retail Sale Id 1628215',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 13:53:24','',''),(2635608,'1','179','933',413,'Retail Sale Id 1628216',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 13:56:36','',''),(2635609,'1','179','933',413,'Retail Sale Id 1628217',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 14:26:45','',''),(2635610,'1','179','933',413,'Retail Sale Id 1628218',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 14:37:56','',''),(2635611,'1','179','933',413,'Retail Sale Id 1628219',8502.00,0.00,0.00,13.08,497.04,'2022-04-14 14:42:11','',''),(2635612,'1','179','933',413,'Retail Sale Id 1628220',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 14:43:06','',''),(2635613,'1','179','933',413,'Retail Sale Id 1628221',2002.00,0.00,0.00,3.08,117.04,'2022-04-14 15:02:01','',''),(2635614,'1','179','933',413,'Retail Sale Id 1628222',3003.00,0.00,0.00,4.62,175.56,'2022-04-14 15:12:26','',''),(2635615,'1','179','933',413,'Retail Sale Id 1628223',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 15:33:50','',''),(2635616,'1','179','933',413,'Retail Sale Id 1628224',8001.50,0.00,0.00,12.31,467.78,'2022-04-14 15:35:26','',''),(2635617,'1','179','933',413,'Retail Sale Id 1628225',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 15:47:44','',''),(2635618,'1','179','933',413,'Retail Sale Id 1628226',1898.00,0.00,0.00,2.92,110.96,'2022-04-14 16:08:17','',''),(2635619,'1','179','933',413,'Retail Sale Id 1628227',7202.00,0.00,0.00,11.08,421.04,'2022-04-14 16:23:55','',''),(2635620,'1','179','933',413,'Retail Sale Id 1628228',2002.00,0.00,0.00,3.08,117.04,'2022-04-14 16:26:14','',''),(2635621,'1','179','933',413,'Retail Sale Id 1628229',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 16:39:29','',''),(2635622,'1','179','933',413,'Retail Sale Id 1628230',3997.50,0.00,0.00,6.15,233.70,'2022-04-14 16:40:22','',''),(2635623,'1','179','933',413,'Retail Sale Id 1628231',29250.00,0.00,0.00,45.00,1710.00,'2022-04-14 16:46:14','',''),(2635624,'1','179','933',413,'Retail Sale Id 1628232',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 16:48:44','',''),(2635625,'1','179','933',413,'Retail Sale Id 1628233',3900.00,0.00,0.00,6.00,228.00,'2022-04-14 16:51:23','',''),(2635626,'1','179','933',413,'Retail Sale Id 1628234',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 17:01:33','',''),(2635627,'1','179','933',413,'Retail Sale Id 1628235',2600.00,0.00,0.00,4.00,152.00,'2022-04-14 17:12:44','',''),(2635628,'1','179','933',413,'Retail Sale Id 1628236',650.00,0.00,0.00,1.00,38.00,'2022-04-14 17:19:18','',''),(2635629,'1','179','933',413,'Retail Sale Id 1628237',8125.00,0.00,0.00,12.50,475.00,'2022-04-14 17:48:02','',''),(2635630,'1','179','933',413,'Retail Sale Id 1628238',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 18:12:58','',''),(2635631,'1','179','933',413,'Retail Sale Id 1628239',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 18:14:13','',''),(2635632,'1','179','933',413,'Retail Sale Id 1628240',1950.00,0.00,0.00,3.00,114.00,'2022-04-14 18:22:37','',''),(2635633,'1','179','933',413,'Retail Sale Id 1628241',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 08:45:26','',''),(2635634,'1','179','933',413,'Retail Sale Id 1628242',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 09:00:35','',''),(2635635,'1','179','933',413,'Retail Sale Id 1628243',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 09:20:27','',''),(2635636,'1','179','933',413,'Retail Sale Id 1628244',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 10:52:24','',''),(2635637,'1','179','933',413,'Retail Sale Id 1628245',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 11:30:43','',''),(2635638,'1','179','933',413,'Retail Sale Id 1628246',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 11:43:48','',''),(2635639,'1','179','933',413,'Retail Sale Id 1628247',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 11:44:59','',''),(2635640,'1','179','933',413,'Retail Sale Id 1628248',4998.50,0.00,0.00,7.69,292.22,'2022-04-15 11:51:41','',''),(2635641,'1','179','933',413,'Retail Sale Id 1628249',6500.00,0.00,0.00,10.00,380.00,'2022-04-15 11:58:11','',''),(2635642,'1','179','933',413,'Retail Sale Id 1628250',5850.00,0.00,0.00,9.00,342.00,'2022-04-15 11:58:53','',''),(2635643,'1','179','933',413,'Retail Sale Id 1628251',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 11:59:36','',''),(2635644,'1','179','933',413,'Retail Sale Id 1628253',8001.50,0.00,0.00,12.31,467.78,'2022-04-15 12:50:05','',''),(2635645,'1','179','933',413,'Retail Sale Id 1628254',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 12:50:44','',''),(2635646,'1','179','933',413,'Retail Sale Id 1628255',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 12:57:54','',''),(2635647,'1','179','933',413,'Retail Sale Id 1628256',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 13:00:10','',''),(2635648,'1','179','933',413,'Retail Sale Id 1628257',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 13:17:23','',''),(2635649,'1','179','933',413,'Retail Sale Id 1628258',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 13:36:22','',''),(2635650,'1','179','933',413,'Retail Sale Id 1628259',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 14:09:06','',''),(2635651,'1','179','933',413,'Retail Sale Id 1628260',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 14:10:05','',''),(2635652,'1','179','933',413,'Retail Sale Id 1628261',3997.50,0.00,0.00,6.15,233.70,'2022-04-15 14:12:15','',''),(2635653,'1','179','933',413,'Retail Sale Id 1628262',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 14:33:25','',''),(2635654,'1','179','933',413,'Retail Sale Id 1628263',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 14:40:47','',''),(2635655,'1','179','933',413,'Retail Sale Id 1628264',8001.50,0.00,0.00,12.31,467.78,'2022-04-15 14:42:18','',''),(2635656,'1','179','933',413,'Retail Sale Id 1628265',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 14:48:41','',''),(2635657,'1','179','933',413,'Retail Sale Id 1628266',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 14:49:42','',''),(2635658,'1','179','933',413,'Retail Sale Id 1628267',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 14:50:50','',''),(2635659,'1','179','933',413,'Retail Sale Id 1628268',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 14:53:08','',''),(2635660,'1','179','933',413,'Retail Sale Id 1628269',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 14:55:29','',''),(2635661,'1','179','933',413,'Retail Sale Id 1628270',7000.50,0.00,0.00,10.77,409.26,'2022-04-15 15:00:07','',''),(2635662,'1','179','933',413,'Retail Sale Id 1628271',3003.00,0.00,0.00,4.62,175.56,'2022-04-15 15:06:29','',''),(2635663,'1','179','933',413,'Retail Sale Id 1628272',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 15:47:24','',''),(2635664,'1','179','933',413,'Retail Sale Id 1628273',7000.50,0.00,0.00,10.77,409.26,'2022-04-15 15:52:18','',''),(2635665,'1','179','933',413,'Retail Sale Id 1628274',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 15:54:32','',''),(2635666,'1','179','933',413,'Retail Sale Id 1628274',7000.50,0.00,0.00,10.77,409.26,'2022-04-15 15:54:32','',''),(2635667,'1','179','933',413,'Retail Sale Id 1628275',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:23:48','',''),(2635668,'1','179','933',413,'Retail Sale Id 1628276',3152.50,0.00,0.00,4.85,184.30,'2022-04-15 16:34:47','',''),(2635669,'1','179','933',413,'Retail Sale Id 1628277',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 16:35:35','',''),(2635670,'1','179','933',413,'Retail Sale Id 1628278',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:42:01','',''),(2635671,'1','179','933',413,'Retail Sale Id 1628279',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 16:46:09','',''),(2635672,'1','179','933',413,'Retail Sale Id 1628280',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 17:01:42','',''),(2635673,'1','179','933',413,'Retail Sale Id 1628281',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 17:06:34','',''),(2635674,'1','179','933',413,'Retail Sale Id 1628282',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 17:11:30','',''),(2635675,'1','179','933',413,'Retail Sale Id 1628283',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 17:17:46','',''),(2635676,'1','179','933',413,'Retail Sale Id 1628284',7800.00,0.00,0.00,12.00,456.00,'2022-04-15 17:20:12','',''),(2635677,'1','179','933',413,'Retail Sale Id 1628285',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 17:22:01','',''),(2635678,'1','179','933',413,'Retail Sale Id 1628285',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 17:22:01','',''),(2635679,'1','179','933',413,'Retail Sale Id 1628286',1300.00,0.00,0.00,2.00,76.00,'2022-04-15 17:23:56','',''),(2635680,'1','179','933',413,'Retail Sale Id 1628287',8125.00,0.00,0.00,12.50,475.00,'2022-04-15 17:30:11','',''),(2635681,'1','179','933',413,'Retail Sale Id 1628288',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 17:31:29','',''),(2635682,'1','179','933',413,'Retail Sale Id 1628289',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 17:39:41','',''),(2635683,'1','179','933',413,'Retail Sale Id 1628290',1001.00,0.00,0.00,1.54,58.52,'2022-04-15 17:40:33','',''),(2635684,'1','179','933',413,'Retail Sale Id 1628291',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 17:41:39','',''),(2635685,'1','179','933',413,'Retail Sale Id 1628292',3250.00,0.00,0.00,5.00,190.00,'2022-04-15 17:42:44','',''),(2635686,'1','179','933',413,'Retail Sale Id 1628293',3900.00,0.00,0.00,6.00,228.00,'2022-04-15 17:43:42','',''),(2635687,'1','179','933',413,'Retail Sale Id 1628294',1950.00,0.00,0.00,3.00,114.00,'2022-04-15 17:45:24','',''),(2635688,'1','179','933',413,'Retail Sale Id 1628295',3003.00,0.00,0.00,4.62,175.56,'2022-04-15 17:55:53','',''),(2635689,'1','179','933',413,'Retail Sale Id 1628296',3997.50,0.00,0.00,6.15,233.70,'2022-04-15 17:56:50','',''),(2635690,'1','179','933',413,'Retail Sale Id 1628297',1501.50,0.00,0.00,2.31,87.78,'2022-04-15 18:12:47','',''),(2635691,'1','179','933',413,'Retail Sale Id 1628298',2002.00,0.00,0.00,3.08,117.04,'2022-04-15 18:19:35','',''),(2635692,'1','179','933',413,'Retail Sale Id 1628299',3997.50,0.00,0.00,6.15,233.70,'2022-04-15 18:20:53','',''),(2635693,'1','179','933',413,'Retail Sale Id 1628300',2002.00,0.00,0.00,3.08,117.04,'2022-04-16 08:29:50','',''),(2635694,'1','179','933',413,'Retail Sale Id 1628301',2002.00,0.00,0.00,3.08,117.04,'2022-04-16 09:29:55','',''),(2635695,'1','179','933',413,'Retail Sale Id 1628301',11375.00,0.00,0.00,17.50,665.00,'2022-04-16 09:29:55','',''),(2635696,'1','179','933',413,'Retail Sale Id 1628302',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 09:51:31','',''),(2635697,'1','179','933',413,'Retail Sale Id 1628303',3997.50,0.00,0.00,6.15,233.70,'2022-04-16 10:05:07','',''),(2635698,'1','179','933',413,'Retail Sale Id 1628304',1703.00,0.00,0.00,2.62,99.56,'2022-04-16 10:11:10','',''),(2635699,'1','179','933',413,'Retail Sale Id 1628305',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 10:20:02','',''),(2635700,'1','179','933',413,'Retail Sale Id 1628307',7150.00,0.00,0.00,11.00,418.00,'2022-04-16 10:31:25','',''),(2635701,'1','179','933',413,'Retail Sale Id 1628308',6500.00,0.00,0.00,10.00,380.00,'2022-04-16 10:32:08','',''),(2635702,'1','179','933',413,'Retail Sale Id 1628309',1950.00,0.00,0.00,3.00,114.00,'2022-04-16 10:45:38','',''),(2635703,'1','179','933',413,'Retail Sale Id 1628310',3900.00,0.00,0.00,6.00,228.00,'2022-04-16 10:57:07','',''),(2635704,'1','179','933',413,'Retail Sale Id 1628311',1501.50,0.00,0.00,2.31,87.78,'2022-04-16 11:19:23','',''),(2635705,'1','179','933',413,'Retail Sale Id 1628312',3997.50,0.00,0.00,6.15,233.70,'2022-04-16 17:57:52','',''),(2635706,'1','179','933',413,'Retail Sale Id 1628313',13325.00,0.00,0.00,20.50,779.00,'2022-04-16 17:58:59','',''),(2635707,'1','179','933',413,'Retail Sale Id 1628314',10998.00,0.00,0.00,16.92,642.96,'2022-04-16 17:59:58','',''),(2635708,'1','179','933',413,'Retail Sale Id 1628315',11999.00,0.00,0.00,18.46,701.48,'2022-04-16 18:32:49','',''),(2635709,'1','179','933',413,'Retail Sale Id 1628316',2002.00,0.00,0.00,3.08,117.04,'2022-04-16 18:33:43','',''),(2635710,'1','179','933',413,'Retail Sale Id 1628317',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 08:18:03','',''),(2635711,'1','179','933',413,'Retail Sale Id 1628318',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 08:32:43','',''),(2635712,'1','179','933',413,'Retail Sale Id 1628319',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 08:35:32','',''),(2635713,'1','179','933',413,'Retail Sale Id 1628320',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 09:14:51','',''),(2635714,'1','179','933',413,'Retail Sale Id 1628321',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 09:16:48','',''),(2635715,'1','179','933',413,'Retail Sale Id 1628322',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 09:34:41','',''),(2635716,'1','179','933',413,'Retail Sale Id 1628323',7150.00,0.00,0.00,11.00,418.00,'2022-04-17 09:42:45','',''),(2635717,'1','179','933',413,'Return of Retail Sale Id 1628323',0.00,7150.00,11.00,0.00,-418.00,'2022-04-17 09:43:39','',''),(2635718,'1','179','933',413,'Retail Sale Id 1628324',7000.50,0.00,0.00,10.77,409.26,'2022-04-17 09:44:05','',''),(2635719,'1','179','933',413,'Retail Sale Id 1628325',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 09:44:50','',''),(2635720,'1','179','933',413,'Retail Sale Id 1628326',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 09:52:33','',''),(2635721,'1','179','933',413,'Retail Sale Id 1628327',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 09:57:03','',''),(2635722,'1','179','933',413,'Retail Sale Id 1628328',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 09:58:17','',''),(2635723,'1','179','933',413,'Retail Sale Id 1628329',8125.00,0.00,0.00,12.50,475.00,'2022-04-17 10:17:48','',''),(2635724,'1','179','933',413,'Return of Retail Sale Id 1628329',0.00,8125.00,12.50,0.00,-475.00,'2022-04-17 10:24:10','',''),(2635725,'1','179','933',413,'Retail Sale Id 1628330',5850.00,0.00,0.00,9.00,342.00,'2022-04-17 10:25:09','',''),(2635726,'1','179','933',413,'Retail Sale Id 1628331',2002.00,0.00,0.00,3.08,117.04,'2022-04-17 10:47:38','',''),(2635727,'1','179','933',413,'Retail Sale Id 1628332',1300.00,0.00,0.00,2.00,76.00,'2022-04-17 10:48:18','',''),(2635728,'1','179','933',413,'Retail Sale Id 1628333',3003.00,0.00,0.00,4.62,175.56,'2022-04-17 11:01:29','',''),(2635729,'1','179','933',413,'Retail Sale Id 1628334',799.50,0.00,0.00,1.23,46.74,'2022-04-17 11:16:39','',''),(2635730,'1','179','933',413,'Retail Sale Id 1628335',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 11:24:26','',''),(2635731,'1','179','933',413,'Retail Sale Id 1628336',1501.50,0.00,0.00,2.31,87.78,'2022-04-17 11:35:31','',''),(2635732,'1','179','933',413,'Retail Sale Id 1628337',6500.00,0.00,0.00,10.00,380.00,'2022-04-17 11:43:12','',''),(2635733,'1','179','933',413,'Retail Sale Id 1628338',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 11:53:05','',''),(2635734,'1','179','933',413,'Retail Sale Id 1628338',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 11:53:05','',''),(2635735,'1','179','933',413,'Retail Sale Id 1628339',3250.00,0.00,0.00,5.00,190.00,'2022-04-17 11:58:43','',''),(2635736,'1','179','933',413,'Retail Sale Id 1628341',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 12:00:28','',''),(2635737,'1','179','933',413,'Retail Sale Id 1628342',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 12:07:01','',''),(2635738,'1','179','933',413,'Retail Sale Id 1628343',2600.00,0.00,0.00,4.00,152.00,'2022-04-17 12:41:41','',''),(2635739,'1','179','933',413,'Retail Sale Id 1628344',2002.00,0.00,0.00,3.08,117.04,'2022-04-17 12:45:25','',''),(2635740,'1','179','933',413,'Retail Sale Id 1628345',1501.50,0.00,0.00,2.31,87.78,'2022-04-17 12:49:44','',''),(2635741,'1','179','933',413,'Retail Sale Id 1628346',2002.00,0.00,0.00,3.08,117.04,'2022-04-17 12:53:04','',''),(2635742,'1','179','933',413,'Retail Sale Id 1628347',8125.00,0.00,0.00,12.50,475.00,'2022-04-17 13:12:47','',''),(2635743,'1','179','933',413,'Retail Sale Id 1628348',4550.00,0.00,0.00,7.00,266.00,'2022-04-17 13:41:20','',''),(2635744,'1','179','933',413,'Retail Sale Id 1628349',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 13:42:10','',''),(2635745,'1','179','933',413,'Retail Sale Id 1628350',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 14:17:08','',''),(2635746,'1','179','933',413,'Retail Sale Id 1628351',6500.00,0.00,0.00,10.00,380.00,'2022-04-17 14:46:26','',''),(2635747,'1','179','933',413,'Retail Sale Id 1628352',3250.00,0.00,0.00,5.00,190.00,'2022-04-17 15:15:14','',''),(2635748,'1','179','933',413,'Retail Sale Id 1628353',3003.00,0.00,0.00,4.62,175.56,'2022-04-17 15:16:22','',''),(2635749,'1','179','933',413,'Retail Sale Id 1628355',3997.50,0.00,0.00,6.15,233.70,'2022-04-17 15:26:37','',''),(2635750,'1','179','933',413,'Retail Sale Id 1628356',10075.00,0.00,0.00,15.50,589.00,'2022-04-17 15:35:24','',''),(2635751,'1','179','933',413,'Retail Sale Id 1628357',1300.00,0.00,0.00,2.00,76.00,'2022-04-17 15:40:08','',''),(2635752,'1','179','933',413,'Return of Retail Sale Id 1628357',0.00,1300.00,2.00,0.00,-76.00,'2022-04-17 15:40:22','',''),(2635753,'1','179','933',413,'Retail Sale Id 1628358',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 15:41:00','',''),(2635754,'1','179','933',413,'Retail Sale Id 1628359',7000.50,0.00,0.00,10.77,409.26,'2022-04-17 15:42:07','',''),(2635755,'1','179','933',413,'Retail Sale Id 1628360',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 15:43:03','',''),(2635756,'1','179','933',413,'Retail Sale Id 1628361',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 16:16:14','',''),(2635757,'1','179','933',413,'Retail Sale Id 1628362',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 16:30:36','',''),(2635758,'1','179','933',413,'Retail Sale Id 1628363',5999.50,0.00,0.00,9.23,350.74,'2022-04-17 16:33:05','',''),(2635759,'1','179','933',413,'Retail Sale Id 1628364',650.00,0.00,0.00,1.00,38.00,'2022-04-17 16:36:34','',''),(2635760,'1','179','933',413,'Retail Sale Id 1628365',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 16:50:01','',''),(2635761,'1','179','933',413,'Retail Sale Id 1628366',3250.00,0.00,0.00,5.00,190.00,'2022-04-17 17:07:46','',''),(2635762,'1','179','933',413,'Retail Sale Id 1628367',7800.00,0.00,0.00,12.00,456.00,'2022-04-17 17:08:29','',''),(2635763,'1','179','933',413,'Retail Sale Id 1628368',2002.00,0.00,0.00,3.08,117.04,'2022-04-17 17:10:37','',''),(2635764,'1','179','933',413,'Retail Sale Id 1628369',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 17:23:10','',''),(2635765,'1','179','933',413,'Retail Sale Id 1628370',3250.00,0.00,0.00,5.00,190.00,'2022-04-17 17:35:53','',''),(2635766,'1','179','933',413,'Retail Sale Id 1628371',1501.50,0.00,0.00,2.31,87.78,'2022-04-17 17:39:19','',''),(2635767,'1','179','933',413,'Retail Sale Id 1628372',1001.00,0.00,0.00,1.54,58.52,'2022-04-17 17:41:08','',''),(2635768,'1','179','933',413,'Retail Sale Id 1628373',1950.00,0.00,0.00,3.00,114.00,'2022-04-17 17:43:24','',''),(2635769,'1','179','933',413,'Retail Sale Id 1628374',2002.00,0.00,0.00,3.08,117.04,'2022-04-17 17:55:41','',''),(2635770,'1','179','933',413,'Retail Sale Id 1628375',3900.00,0.00,0.00,6.00,228.00,'2022-04-17 18:04:06','',''),(2635771,'1','179','933',413,'Retail Sale Id 1628376',2002.00,0.00,0.00,3.08,117.04,'2022-04-17 18:05:13','',''),(2635772,'1','179','933',413,'Retail Sale Id 1628377',10998.00,0.00,0.00,16.92,642.96,'2022-04-18 08:31:44','',''),(2635773,'1','179','933',413,'Retail Sale Id 1628378',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 09:22:01','',''),(2635774,'1','179','933',413,'Return of Retail Sale Id 1628378',0.00,3900.00,6.00,0.00,-228.00,'2022-04-18 09:22:39','',''),(2635775,'1','179','933',413,'Retail Sale Id 1628379',3302.00,0.00,0.00,5.08,193.04,'2022-04-18 09:23:28','',''),(2635776,'1','179','933',413,'Retail Sale Id 1628380',8001.50,0.00,0.00,12.31,467.78,'2022-04-18 09:46:40','',''),(2635777,'1','179','933',413,'Retail Sale Id 1628381',3997.50,0.00,0.00,6.15,233.70,'2022-04-18 09:58:45','',''),(2635778,'1','179','933',413,'Retail Sale Id 1628383',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 10:27:48','',''),(2635779,'1','179','933',413,'Retail Sale Id 1628384',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 10:29:24','',''),(2635780,'1','179','933',413,'Retail Sale Id 1628385',2002.00,0.00,0.00,3.08,117.04,'2022-04-18 10:30:52','',''),(2635781,'1','179','933',413,'Retail Sale Id 1628386',8125.00,0.00,0.00,12.50,475.00,'2022-04-18 11:04:27','',''),(2635782,'1','179','933',413,'Retail Sale Id 1628387',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 11:24:16','',''),(2635783,'1','179','933',413,'Retail Sale Id 1628388',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 11:38:32','',''),(2635784,'1','179','933',413,'Retail Sale Id 1628390',1501.50,0.00,0.00,2.31,87.78,'2022-04-18 11:57:58','',''),(2635785,'1','179','933',413,'Retail Sale Id 1628391',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 12:40:54','',''),(2635786,'1','179','933',413,'Retail Sale Id 1628392',2002.00,0.00,0.00,3.08,117.04,'2022-04-18 12:47:20','',''),(2635787,'1','179','933',413,'Retail Sale Id 1628393',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 12:56:01','',''),(2635788,'1','179','933',413,'Retail Sale Id 1628394',8125.00,0.00,0.00,12.50,475.00,'2022-04-18 13:41:46','',''),(2635789,'1','179','933',413,'Retail Sale Id 1628395',42997.50,0.00,0.00,66.15,2513.70,'2022-04-18 15:18:46','',''),(2635790,'1','179','933',413,'Retail Sale Id 1628396',8001.50,0.00,0.00,12.31,467.78,'2022-04-18 15:52:39','',''),(2635791,'1','179','933',413,'Retail Sale Id 1628397',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 16:43:19','',''),(2635792,'1','179','933',413,'Retail Sale Id 1628398',1001.00,0.00,0.00,1.54,58.52,'2022-04-18 17:20:39','',''),(2635793,'1','179','933',413,'Retail Sale Id 1628399',1001.00,0.00,0.00,1.54,58.52,'2022-04-18 17:22:41','',''),(2635794,'1','179','933',413,'Retail Sale Id 1628400',16627.00,0.00,0.00,25.58,972.04,'2022-04-18 17:32:55','',''),(2635795,'1','179','933',413,'Retail Sale Id 1628401',13598.00,0.00,0.00,20.92,794.96,'2022-04-18 17:33:53','',''),(2635796,'1','179','933',413,'Retail Sale Id 1628402',2002.00,0.00,0.00,3.08,117.04,'2022-04-18 17:42:27','',''),(2635797,'1','179','933',413,'Retail Sale Id 1628403',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 17:46:32','',''),(2635798,'1','179','933',413,'Return of Retail Sale Id 1628402',0.00,2002.00,3.08,0.00,-117.04,'2022-04-18 17:48:12','',''),(2635799,'1','179','933',413,'Retail Sale Id 1628404',1300.00,0.00,0.00,2.00,76.00,'2022-04-18 17:48:56','',''),(2635800,'1','179','933',413,'Retail Sale Id 1628405',2730.00,0.00,0.00,4.20,159.60,'2022-04-18 18:08:08','',''),(2635801,'1','179','933',413,'Retail Sale Id 1628406',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 18:11:48','',''),(2635802,'1','179','933',413,'Retail Sale Id 1628407',3250.00,0.00,0.00,5.00,190.00,'2022-04-18 18:15:28','',''),(2635803,'1','179','933',413,'Retail Sale Id 1628408',1950.00,0.00,0.00,3.00,114.00,'2022-04-18 18:16:44','',''),(2635804,'1','179','933',413,'Retail Sale Id 1628409',3900.00,0.00,0.00,6.00,228.00,'2022-04-18 18:28:51','',''),(2635805,'1','179','933',413,'Retail Sale Id 1628410',8450.00,0.00,0.00,13.00,494.00,'2022-04-19 08:30:14','',''),(2635806,'1','179','933',413,'Retail Sale Id 1628411',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 08:31:25','',''),(2635807,'1','179','933',413,'Retail Sale Id 1628412',1800.50,0.00,0.00,2.77,105.26,'2022-04-19 08:32:14','',''),(2635808,'1','179','933',413,'Retail Sale Id 1628413',7800.00,0.00,0.00,12.00,456.00,'2022-04-19 09:09:10','',''),(2635809,'1','179','933',413,'Retail Sale Id 1628414',2002.00,0.00,0.00,3.08,117.04,'2022-04-19 10:53:01','',''),(2635810,'1','179','933',413,'Retail Sale Id 1628415',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 11:01:19','',''),(2635811,'1','179','933',413,'Retail Sale Id 1628416',1300.00,0.00,0.00,2.00,76.00,'2022-04-19 11:02:07','',''),(2635812,'1','179','933',413,'Retail Sale Id 1628417',7800.00,0.00,0.00,12.00,456.00,'2022-04-19 11:07:42','',''),(2635813,'1','179','933',413,'Retail Sale Id 1628418',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 11:30:14','',''),(2635814,'1','179','933',413,'Retail Sale Id 1628419',702.00,0.00,0.00,1.08,41.04,'2022-04-19 12:13:06','',''),(2635815,'1','179','933',413,'Retail Sale Id 1628420',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 12:38:15','',''),(2635816,'1','179','933',413,'Retail Sale Id 1628421',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 13:54:48','',''),(2635817,'1','179','933',413,'Retail Sale Id 1628422',2899.00,0.00,0.00,4.46,169.48,'2022-04-19 13:57:24','',''),(2635818,'1','179','933',413,'Retail Sale Id 1628423',1501.50,0.00,0.00,2.31,87.78,'2022-04-19 13:58:05','',''),(2635819,'1','179','933',413,'Retail Sale Id 1628424',3003.00,0.00,0.00,4.62,175.56,'2022-04-19 14:06:46','',''),(2635820,'1','179','933',413,'Retail Sale Id 1628425',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 14:17:19','',''),(2635821,'1','179','933',413,'Retail Sale Id 1628426',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 14:18:10','',''),(2635822,'1','179','933',413,'Retail Sale Id 1628427',8099.00,0.00,0.00,12.46,473.48,'2022-04-19 14:19:56','',''),(2635823,'1','179','933',413,'Retail Sale Id 1628428',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 14:21:58','',''),(2635824,'1','179','933',413,'Retail Sale Id 1628429',1800.50,0.00,0.00,2.77,105.26,'2022-04-19 14:33:24','',''),(2635825,'1','179','933',413,'Retail Sale Id 1628430',2002.00,0.00,0.00,3.08,117.04,'2022-04-19 14:38:18','',''),(2635826,'1','179','933',413,'Retail Sale Id 1628431',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 14:58:09','',''),(2635827,'1','179','933',413,'Retail Sale Id 1628432',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 15:34:43','',''),(2635828,'1','179','933',413,'Retail Sale Id 1628433',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 16:23:10','',''),(2635829,'1','179','933',413,'Retail Sale Id 1628434',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:23:47','',''),(2635830,'1','179','933',413,'Retail Sale Id 1628435',1001.00,0.00,0.00,1.54,58.52,'2022-04-19 16:39:54','',''),(2635831,'1','179','933',413,'Retail Sale Id 1628436',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:40:45','',''),(2635832,'1','179','933',413,'Retail Sale Id 1628437',702.00,0.00,0.00,1.08,41.04,'2022-04-19 16:47:33','',''),(2635833,'1','179','933',413,'Retail Sale Id 1628437',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 16:47:33','',''),(2635834,'1','179','933',413,'Retail Sale Id 1628438',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 16:51:27','',''),(2635835,'1','179','933',413,'Retail Sale Id 1628439',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 17:09:54','',''),(2635836,'1','179','933',413,'Retail Sale Id 1628440',3250.00,0.00,0.00,5.00,190.00,'2022-04-19 17:26:59','',''),(2635837,'1','179','933',413,'Retail Sale Id 1628441',702.00,0.00,0.00,1.08,41.04,'2022-04-19 17:45:59','',''),(2635838,'1','179','933',413,'Retail Sale Id 1628442',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 17:48:07','',''),(2635839,'1','179','933',413,'Retail Sale Id 1628443',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 17:55:24','',''),(2635840,'1','179','933',413,'Retail Sale Id 1628444',3900.00,0.00,0.00,6.00,228.00,'2022-04-19 18:08:36','',''),(2635841,'1','179','933',413,'Retail Sale Id 1628445',1501.50,0.00,0.00,2.31,87.78,'2022-04-19 18:13:36','',''),(2635842,'1','179','933',413,'Retail Sale Id 1628446',8125.00,0.00,0.00,12.50,475.00,'2022-04-19 18:20:25','',''),(2635843,'1','179','933',413,'Retail Sale Id 1628447',2002.00,0.00,0.00,3.08,117.04,'2022-04-19 18:21:16','',''),(2635844,'1','179','933',413,'Retail Sale Id 1628448',1950.00,0.00,0.00,3.00,114.00,'2022-04-19 18:29:46','',''),(2635845,'1','179','933',413,'Retail Sale Id 1628448',4998.50,0.00,0.00,7.69,292.22,'2022-04-19 18:29:46','',''),(2635846,'1','179','933',413,'Retail Sale Id 1628449',3003.00,0.00,0.00,4.62,175.56,'2022-04-20 08:17:39','',''),(2635847,'1','179','933',413,'Retail Sale Id 1628450',3997.50,0.00,0.00,6.15,233.70,'2022-04-20 08:27:52','',''),(2635848,'1','179','933',413,'Retail Sale Id 1628451',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 09:16:56','',''),(2635849,'1','179','933',413,'Retail Sale Id 1628452',650.00,0.00,0.00,1.00,38.00,'2022-04-20 10:06:23','',''),(2635850,'1','179','933',413,'Retail Sale Id 1628453',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 10:19:54','',''),(2635851,'1','179','933',413,'Retail Sale Id 1628454',1001.00,0.00,0.00,1.54,58.52,'2022-04-20 10:44:56','',''),(2635852,'1','179','933',413,'Retail Sale Id 1628456',5999.50,0.00,0.00,9.23,350.74,'2022-04-20 11:11:02','',''),(2635853,'1','179','933',413,'Retail Sale Id 1628457',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 11:27:57','',''),(2635854,'1','179','933',413,'Retail Sale Id 1628458',3497.00,0.00,0.00,5.38,204.44,'2022-04-20 11:37:29','',''),(2635855,'1','179','933',413,'Retail Sale Id 1628459',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 12:04:46','',''),(2635856,'1','179','933',413,'Retail Sale Id 1628460',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 12:08:35','',''),(2635857,'1','179','933',413,'Retail Sale Id 1628461',6500.00,0.00,0.00,10.00,380.00,'2022-04-20 12:27:55','',''),(2635858,'1','179','933',413,'Retail Sale Id 1628462',1599.00,0.00,0.00,2.46,93.48,'2022-04-20 12:36:42','',''),(2635859,'1','179','933',413,'Retail Sale Id 1628463',8125.00,0.00,0.00,12.50,475.00,'2022-04-20 12:56:34','',''),(2635860,'1','179','933',413,'Retail Sale Id 1628464',8125.00,0.00,0.00,12.50,475.00,'2022-04-20 13:00:54','',''),(2635861,'1','179','933',413,'Retail Sale Id 1628465',2600.00,0.00,0.00,4.00,152.00,'2022-04-20 13:14:37','',''),(2635862,'1','179','933',413,'Retail Sale Id 1628466',1501.50,0.00,0.00,2.31,87.78,'2022-04-20 13:16:34','',''),(2635863,'1','179','933',413,'Retail Sale Id 1628468',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 13:52:00','',''),(2635864,'1','179','933',413,'Retail Sale Id 1628469',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 13:57:49','',''),(2635865,'1','179','933',413,'Retail Sale Id 1628470',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 13:59:34','',''),(2635866,'1','179','933',413,'Retail Sale Id 1628471',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 14:18:45','',''),(2635867,'1','179','933',413,'Retail Sale Id 1628472',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 14:20:55','',''),(2635868,'1','179','933',413,'Retail Sale Id 1628473',8125.00,0.00,0.00,12.50,475.00,'2022-04-20 14:29:54','',''),(2635869,'1','179','933',413,'Retail Sale Id 1628474',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 14:32:33','',''),(2635870,'1','179','933',413,'Retail Sale Id 1628475',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 14:55:20','',''),(2635871,'1','179','933',413,'Retail Sale Id 1628476',8125.00,0.00,0.00,12.50,475.00,'2022-04-20 14:56:58','',''),(2635872,'1','179','933',413,'Retail Sale Id 1628477',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 15:08:44','',''),(2635873,'1','179','933',413,'Retail Sale Id 1628478',8450.00,0.00,0.00,13.00,494.00,'2022-04-20 15:42:35','',''),(2635874,'1','179','933',413,'Retail Sale Id 1628479',1001.00,0.00,0.00,1.54,58.52,'2022-04-20 16:35:59','',''),(2635875,'1','179','933',413,'Retail Sale Id 1628480',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 16:36:38','',''),(2635876,'1','179','933',413,'Retail Sale Id 1628481',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 16:54:39','',''),(2635877,'1','179','933',413,'Retail Sale Id 1628482',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 16:55:33','',''),(2635878,'1','179','933',413,'Retail Sale Id 1628483',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 17:06:36','',''),(2635879,'1','179','933',413,'Retail Sale Id 1628484',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 17:08:19','',''),(2635880,'1','179','933',413,'Retail Sale Id 1628485',3003.00,0.00,0.00,4.62,175.56,'2022-04-20 17:15:34','',''),(2635881,'1','179','933',413,'Retail Sale Id 1628486',2002.00,0.00,0.00,3.08,117.04,'2022-04-20 17:21:32','',''),(2635882,'1','179','933',413,'Retail Sale Id 1628487',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 17:24:53','',''),(2635883,'1','179','933',413,'Retail Sale Id 1628488',1501.50,0.00,0.00,2.31,87.78,'2022-04-20 17:26:42','',''),(2635884,'1','179','933',413,'Retail Sale Id 1628489',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 17:30:13','',''),(2635885,'1','179','933',413,'Retail Sale Id 1628490',1300.00,0.00,0.00,2.00,76.00,'2022-04-20 17:34:36','',''),(2635886,'1','179','933',413,'Retail Sale Id 1628491',8001.50,0.00,0.00,12.31,467.78,'2022-04-20 17:35:46','',''),(2635887,'1','179','933',413,'Retail Sale Id 1628492',1001.00,0.00,0.00,1.54,58.52,'2022-04-20 17:37:48','',''),(2635888,'1','179','933',413,'Retail Sale Id 1628493',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 17:46:25','',''),(2635889,'1','179','933',413,'Retail Sale Id 1628494',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 17:53:19','',''),(2635890,'1','179','933',413,'Retail Sale Id 1628495',3900.00,0.00,0.00,6.00,228.00,'2022-04-20 18:02:30','',''),(2635891,'1','179','933',413,'Retail Sale Id 1628496',8125.00,0.00,0.00,12.50,475.00,'2022-04-20 18:07:19','',''),(2635892,'1','179','933',413,'Retail Sale Id 1628497',1950.00,0.00,0.00,3.00,114.00,'2022-04-20 18:08:06','',''),(2635893,'1','179','933',413,'Retail Sale Id 1628498',2600.00,0.00,0.00,4.00,152.00,'2022-04-20 18:08:52','',''),(2635894,'1','179','933',413,'Retail Sale Id 1628499',3250.00,0.00,0.00,5.00,190.00,'2022-04-20 18:12:01','',''),(2635895,'1','179',NULL,413,'Purchased from AA RANO NIG. LIMITED',0.00,3070200.00,5100.00,0.00,0.00,'2022-04-21 08:45:37','',''),(2635896,'1','179',NULL,413,'Reception corrector for bridging 132516',0.00,0.00,0.00,5100.00,0.00,'2022-04-21 08:47:04','',''),(2635897,'1','179','933',413,'Received from bridging 132516',0.00,0.00,5100.00,0.00,0.00,'2022-04-21 08:47:04','',''),(2635898,'1','179','933',413,'Retail Sale Id 1628500',5999.50,0.00,0.00,9.23,443.04,'2022-04-21 08:54:30','',''),(2635899,'1','179','933',413,'Retail Sale Id 1628501',4998.50,0.00,0.00,7.69,369.12,'2022-04-21 08:58:00','',''),(2635900,'1','179','933',413,'Retail Sale Id 1628502',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 10:18:43','',''),(2635901,'1','179','933',413,'Retail Sale Id 1628502',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 10:18:43','',''),(2635902,'1','179','933',413,'Retail Sale Id 1628503',3003.00,0.00,0.00,4.62,221.76,'2022-04-21 10:38:42','',''),(2635903,'1','179','933',413,'Retail Sale Id 1628504',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 11:16:21','',''),(2635904,'1','179','933',413,'Retail Sale Id 1628505',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 11:17:08','',''),(2635905,'1','179','933',413,'Retail Sale Id 1628506',1001.00,0.00,0.00,1.54,73.92,'2022-04-21 11:49:42','',''),(2635906,'1','179','933',413,'Retail Sale Id 1628507',8125.00,0.00,0.00,12.50,600.00,'2022-04-21 11:53:00','',''),(2635907,'1','179','933',413,'Retail Sale Id 1628508',7000.50,0.00,0.00,10.77,516.96,'2022-04-21 11:54:33','',''),(2635908,'1','179','933',413,'Retail Sale Id 1628509',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 12:20:19','',''),(2635909,'1','179','933',413,'Retail Sale Id 1628510',3250.00,0.00,0.00,5.00,240.00,'2022-04-21 12:34:01','',''),(2635910,'1','179','933',413,'Retail Sale Id 1628511',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 12:38:10','',''),(2635911,'1','179','933',413,'Retail Sale Id 1628512',3250.00,0.00,0.00,5.00,240.00,'2022-04-21 12:40:38','',''),(2635912,'1','179','933',413,'Retail Sale Id 1628513',10998.00,0.00,0.00,16.92,812.16,'2022-04-21 12:44:46','',''),(2635913,'1','179','933',413,'Retail Sale Id 1628514',15002.00,0.00,0.00,23.08,1107.84,'2022-04-21 12:48:04','',''),(2635914,'1','179','933',413,'Retail Sale Id 1628515',1397.50,0.00,0.00,2.15,103.20,'2022-04-21 12:50:40','',''),(2635915,'1','179','933',413,'Retail Sale Id 1628516',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 13:34:04','',''),(2635916,'1','179','933',413,'Retail Sale Id 1628517',6500.00,0.00,0.00,10.00,480.00,'2022-04-21 14:07:56','',''),(2635917,'1','179','933',413,'Retail Sale Id 1628518',1501.50,0.00,0.00,2.31,110.88,'2022-04-21 14:10:20','',''),(2635918,'1','179','933',413,'Retail Sale Id 1628519',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 14:22:39','',''),(2635919,'1','179','933',413,'Retail Sale Id 1628520',7000.50,0.00,0.00,10.77,516.96,'2022-04-21 14:25:06','',''),(2635920,'1','179','933',413,'Retail Sale Id 1628521',1501.50,0.00,0.00,2.31,110.88,'2022-04-21 14:41:38','',''),(2635921,'1','179','933',413,'Retail Sale Id 1628522',1001.00,0.00,0.00,1.54,73.92,'2022-04-21 14:59:03','',''),(2635922,'1','179','933',413,'Retail Sale Id 1628523',3250.00,0.00,0.00,5.00,240.00,'2022-04-21 15:04:07','',''),(2635923,'1','179','933',413,'Retail Sale Id 1628524',7800.00,0.00,0.00,12.00,576.00,'2022-04-21 15:59:11','',''),(2635924,'1','179','933',413,'Retail Sale Id 1628525',2502.50,0.00,0.00,3.85,184.80,'2022-04-21 16:00:30','',''),(2635925,'1','179','933',413,'Retail Sale Id 1628526',2002.00,0.00,0.00,3.08,147.84,'2022-04-21 16:01:43','',''),(2635926,'1','179','933',413,'Retail Sale Id 1628527',8125.00,0.00,0.00,12.50,600.00,'2022-04-21 16:39:19','',''),(2635927,'1','179','933',413,'Retail Sale Id 1628528',8125.00,0.00,0.00,12.50,600.00,'2022-04-21 16:40:32','',''),(2635928,'1','179','933',413,'Retail Sale Id 1628529',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 16:41:51','',''),(2635929,'1','179','933',413,'Retail Sale Id 1628530',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 16:54:04','',''),(2635930,'1','179','933',413,'Retail Sale Id 1628531',8125.00,0.00,0.00,12.50,600.00,'2022-04-21 17:13:27','',''),(2635931,'1','179','933',413,'Retail Sale Id 1628532',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 17:20:51','',''),(2635932,'1','179','933',413,'Retail Sale Id 1628533',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 17:34:05','',''),(2635933,'1','179','933',413,'Retail Sale Id 1628534',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 17:35:15','',''),(2635934,'1','179','933',413,'Retail Sale Id 1628535',6500.00,0.00,0.00,10.00,480.00,'2022-04-21 17:38:21','',''),(2635935,'1','179','933',413,'Retail Sale Id 1628536',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 17:46:46','',''),(2635936,'1','179','933',413,'Retail Sale Id 1628537',3900.00,0.00,0.00,6.00,288.00,'2022-04-21 17:50:06','',''),(2635937,'1','179','933',413,'Retail Sale Id 1628538',1950.00,0.00,0.00,3.00,144.00,'2022-04-21 17:52:09','',''),(2635938,'1','179','933',413,'Retail Sale Id 1628539',7150.00,0.00,0.00,11.00,528.00,'2022-04-21 17:59:40','',''),(2635939,'1','179','933',413,'Retail Sale Id 1628540',1001.00,0.00,0.00,1.54,73.92,'2022-04-21 18:20:52','',''),(2635940,'1','179','933',413,'Distributed to OPERATIONAL LOSS for sales id:350088',70741.02,0.00,0.00,117.51,0.00,'2022-04-22 08:08:09','',''),(2635941,'1','179','933',413,'Distributed to OPERATIONAL LOSS for sales id:350089',40273.80,0.00,0.00,66.90,0.00,'2022-04-22 08:12:22','',''),(2635942,'1','179','933',413,'Retail Sale Id 1628541',1300.00,0.00,0.00,2.00,96.00,'2022-04-22 08:14:45','',''),(2635943,'1','179','933',413,'Retail Sale Id 1628542',2600.00,0.00,0.00,4.00,192.00,'2022-04-22 08:30:20','',''),(2635944,'1','179','933',413,'Retail Sale Id 1628543',3003.00,0.00,0.00,4.62,221.76,'2022-04-22 09:29:58','',''),(2635945,'1','179','933',413,'Return of Retail Sale Id 1628543',0.00,3003.00,4.62,0.00,-221.76,'2022-04-22 09:30:21','',''),(2635946,'1','179','933',413,'Retail Sale Id 1628544',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 09:31:03','',''),(2635947,'1','179','933',413,'Retail Sale Id 1628545',1001.00,0.00,0.00,1.54,73.92,'2022-04-22 09:34:24','',''),(2635948,'1','179','933',413,'Retail Sale Id 1628546',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 09:35:47','',''),(2635949,'1','179','933',413,'Retail Sale Id 1628547',650.00,0.00,0.00,1.00,48.00,'2022-04-22 09:49:01','',''),(2635950,'1','179','933',413,'Retail Sale Id 1628548',650.00,0.00,0.00,1.00,48.00,'2022-04-22 09:56:09','',''),(2635951,'1','179','933',413,'Retail Sale Id 1628549',650.00,0.00,0.00,1.00,48.00,'2022-04-22 10:06:23','',''),(2635952,'1','179','933',413,'Retail Sale Id 1628550',6500.00,0.00,0.00,10.00,480.00,'2022-04-22 10:10:33','',''),(2635953,'1','179','933',413,'Retail Sale Id 1628551',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 10:25:36','',''),(2635954,'1','179','933',413,'Retail Sale Id 1628551',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 10:25:36','',''),(2635955,'1','179','933',413,'Retail Sale Id 1628552',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 10:37:26','',''),(2635956,'1','179','933',413,'Retail Sale Id 1628553',2002.00,0.00,0.00,3.08,147.84,'2022-04-22 10:38:00','',''),(2635957,'1','179','933',413,'Retail Sale Id 1628554',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 10:39:05','',''),(2635958,'1','179','933',413,'Retail Sale Id 1628555',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 10:47:59','',''),(2635959,'1','179','933',413,'Retail Sale Id 1628556',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 11:37:55','',''),(2635960,'1','179','933',413,'Retail Sale Id 1628557',5850.00,0.00,0.00,9.00,432.00,'2022-04-22 11:43:24','',''),(2635961,'1','179','933',413,'Retail Sale Id 1628558',8125.00,0.00,0.00,12.50,600.00,'2022-04-22 11:49:26','',''),(2635962,'1','179','933',413,'Retail Sale Id 1628559',1001.00,0.00,0.00,1.54,73.92,'2022-04-22 12:03:46','',''),(2635963,'1','179','933',413,'Retail Sale Id 1628560',4998.50,0.00,0.00,7.69,369.12,'2022-04-22 12:20:30','',''),(2635964,'1','179','933',413,'Retail Sale Id 1628561',3003.00,0.00,0.00,4.62,221.76,'2022-04-22 12:46:30','',''),(2635965,'1','179','933',413,'Retail Sale Id 1628562',6500.00,0.00,0.00,10.00,480.00,'2022-04-22 12:51:42','',''),(2635966,'1','179','933',413,'Retail Sale Id 1628563',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 13:00:32','',''),(2635967,'1','179','933',413,'Retail Sale Id 1628564',897.00,0.00,0.00,1.38,66.24,'2022-04-22 13:01:48','',''),(2635968,'1','179','933',413,'Retail Sale Id 1628565',2002.00,0.00,0.00,3.08,147.84,'2022-04-22 14:43:00','',''),(2635969,'1','179','933',413,'Retail Sale Id 1628566',1300.00,0.00,0.00,2.00,96.00,'2022-04-22 14:44:33','',''),(2635970,'1','179','933',413,'Retail Sale Id 1628567',4498.00,0.00,0.00,6.92,332.16,'2022-04-22 14:45:43','',''),(2635971,'1','179','933',413,'Retail Sale Id 1628568',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 14:55:58','',''),(2635972,'1','179','933',413,'Retail Sale Id 1628569',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 15:17:32','',''),(2635973,'1','179','933',413,'Retail Sale Id 1628570',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 15:20:38','',''),(2635974,'1','179','933',413,'Retail Sale Id 1628571',8125.00,0.00,0.00,12.50,600.00,'2022-04-22 15:29:06','',''),(2635975,'1','179','933',413,'Retail Sale Id 1628572',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 15:36:33','',''),(2635976,'1','179','933',413,'Retail Sale Id 1628573',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 15:38:06','',''),(2635977,'1','179','933',413,'Retail Sale Id 1628574',2002.00,0.00,0.00,3.08,147.84,'2022-04-22 15:44:25','',''),(2635978,'1','179','933',413,'Retail Sale Id 1628575',1950.00,0.00,0.00,3.00,144.00,'2022-04-22 16:04:40','',''),(2635979,'1','179','933',413,'Retail Sale Id 1628576',2002.00,0.00,0.00,3.08,147.84,'2022-04-22 16:16:13','',''),(2635980,'1','179','933',413,'Retail Sale Id 1628577',8125.00,0.00,0.00,12.50,600.00,'2022-04-22 16:29:36','',''),(2635981,'1','179','933',413,'Retail Sale Id 1628578',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 16:36:20','',''),(2635982,'1','179','933',413,'Retail Sale Id 1628579',7000.50,0.00,0.00,10.77,516.96,'2022-04-22 16:45:19','',''),(2635983,'1','179','933',413,'Retail Sale Id 1628580',1501.50,0.00,0.00,2.31,110.88,'2022-04-22 16:46:03','',''),(2635984,'1','179','933',413,'Retail Sale Id 1628581',3250.00,0.00,0.00,5.00,240.00,'2022-04-22 16:48:01','',''),(2635985,'1','179','933',413,'Retail Sale Id 1628582',2600.00,0.00,0.00,4.00,192.00,'2022-04-22 17:07:31','',''),(2635986,'1','179','933',413,'Retail Sale Id 1628583',3575.00,0.00,0.00,5.50,264.00,'2022-04-22 17:09:24','',''),(2635987,'1','179','933',413,'Retail Sale Id 1628584',8125.00,0.00,0.00,12.50,600.00,'2022-04-22 17:15:09','',''),(2635988,'1','179','933',413,'Retail Sale Id 1628585',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 17:17:49','',''),(2635989,'1','179','933',413,'Retail Sale Id 1628586',3900.00,0.00,0.00,6.00,288.00,'2022-04-22 17:18:32','',''),(2635990,'1','179','933',413,'Retail Sale Id 1628587',8125.00,0.00,0.00,12.50,600.00,'2022-04-22 17:38:16','',''),(2635991,'1','179','933',413,'Retail Sale Id 1628588',1001.00,0.00,0.00,1.54,73.92,'2022-04-22 17:40:08','',''),(2635992,'1','179','933',413,'Retail Sale Id 1628589',1300.00,0.00,0.00,2.00,96.00,'2022-04-22 17:48:43','',''),(2635993,'1','179','933',413,'Retail Sale Id 1628590',2600.00,0.00,0.00,4.00,192.00,'2022-04-22 17:54:03','',''),(2635994,'1','179','933',413,'Retail Sale Id 1628591',6500.00,0.00,0.00,10.00,480.00,'2022-04-22 17:55:23','',''),(2635995,'1','179','933',413,'Retail Sale Id 1628592',4998.50,0.00,0.00,7.69,369.12,'2022-04-22 17:59:02','',''),(2635996,'1','179','933',413,'Retail Sale Id 1628594',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 08:32:10','',''),(2635997,'1','179','933',413,'Retail Sale Id 1628594',3997.50,0.00,0.00,6.15,295.20,'2022-04-23 08:32:10','',''),(2635998,'1','179','933',413,'Retail Sale Id 1628594',8125.00,0.00,0.00,12.50,600.00,'2022-04-23 08:32:10','',''),(2635999,'1','179','933',413,'Retail Sale Id 1628595',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 08:39:13','',''),(2636000,'1','179','933',413,'Retail Sale Id 1628596',8203.00,0.00,0.00,12.62,605.76,'2022-04-23 09:14:02','',''),(2636001,'1','179','933',413,'Retail Sale Id 1628597',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 09:15:13','',''),(2636002,'1','179','933',413,'Retail Sale Id 1628598',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 09:17:41','',''),(2636003,'1','179','933',413,'Retail Sale Id 1628599',1300.00,0.00,0.00,2.00,96.00,'2022-04-23 09:27:05','',''),(2636004,'1','179','933',413,'Retail Sale Id 1628600',2600.00,0.00,0.00,4.00,192.00,'2022-04-23 09:36:55','',''),(2636005,'1','179','933',413,'Retail Sale Id 1628601',1300.00,0.00,0.00,2.00,96.00,'2022-04-23 10:04:27','',''),(2636006,'1','179','933',413,'Retail Sale Id 1628602',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 10:05:51','',''),(2636007,'1','179','933',413,'Retail Sale Id 1628603',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 10:07:18','',''),(2636008,'1','179','933',413,'Retail Sale Id 1628604',8125.00,0.00,0.00,12.50,600.00,'2022-04-23 10:08:59','',''),(2636009,'1','179','933',413,'Retail Sale Id 1628605',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 10:10:16','',''),(2636010,'1','179','933',413,'Retail Sale Id 1628606',1001.00,0.00,0.00,1.54,73.92,'2022-04-23 10:40:46','',''),(2636011,'1','179','933',413,'Retail Sale Id 1628607',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 10:45:11','',''),(2636012,'1','179','933',413,'Retail Sale Id 1628608',8125.00,0.00,0.00,12.50,600.00,'2022-04-23 10:53:26','',''),(2636013,'1','179','933',413,'Retail Sale Id 1628609',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 10:55:51','',''),(2636014,'1','179','933',413,'Retail Sale Id 1628610',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 11:26:07','',''),(2636015,'1','179','933',413,'Retail Sale Id 1628611',16250.00,0.00,0.00,25.00,1200.00,'2022-04-23 11:49:59','',''),(2636016,'1','179','933',413,'Retail Sale Id 1628612',4998.50,0.00,0.00,7.69,369.12,'2022-04-23 12:20:01','',''),(2636017,'1','179','933',413,'Retail Sale Id 1628613',1001.00,0.00,0.00,1.54,73.92,'2022-04-23 12:27:49','',''),(2636018,'1','179','933',413,'Retail Sale Id 1628614',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 12:34:41','',''),(2636019,'1','179','933',413,'Retail Sale Id 1628615',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 12:41:24','',''),(2636020,'1','179','933',413,'Retail Sale Id 1628616',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 12:43:21','',''),(2636021,'1','179','933',413,'Retail Sale Id 1628617',4998.50,0.00,0.00,7.69,369.12,'2022-04-23 12:44:14','',''),(2636022,'1','179','933',413,'Retail Sale Id 1628618',3997.50,0.00,0.00,6.15,295.20,'2022-04-23 13:01:17','',''),(2636023,'1','179','933',413,'Retail Sale Id 1628619',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 13:02:52','',''),(2636024,'1','179','933',413,'Retail Sale Id 1628620',3900.00,0.00,0.00,6.00,288.00,'2022-04-23 13:16:42','',''),(2636025,'1','179','933',413,'Retail Sale Id 1628621',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 13:24:00','',''),(2636026,'1','179','933',413,'Retail Sale Id 1628622',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 13:29:17','',''),(2636027,'1','179','933',413,'Retail Sale Id 1628623',2002.00,0.00,0.00,3.08,147.84,'2022-04-23 13:38:41','',''),(2636028,'1','179','933',413,'Retail Sale Id 1628624',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 14:05:42','',''),(2636029,'1','179','933',413,'Retail Sale Id 1628625',1950.00,0.00,0.00,3.00,144.00,'2022-04-23 14:13:30','',''),(2636030,'1','179','933',413,'Retail Sale Id 1628626',3601.00,0.00,0.00,5.54,265.92,'2022-04-23 14:56:10','',''),(2636031,'1','179','933',413,'Retail Sale Id 1628627',8125.00,0.00,0.00,12.50,600.00,'2022-04-23 15:03:55','',''),(2636032,'1','179','933',413,'Retail Sale Id 1628628',1397.50,0.00,0.00,2.15,103.20,'2022-04-23 15:07:19','',''),(2636033,'1','179','933',413,'Retail Sale Id 1628629',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 15:41:27','',''),(2636034,'1','179','933',413,'Retail Sale Id 1628630',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 15:50:09','',''),(2636035,'1','179','933',413,'Retail Sale Id 1628631',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 15:57:33','',''),(2636036,'1','179','933',413,'Retail Sale Id 1628632',3250.00,0.00,0.00,5.00,240.00,'2022-04-23 16:37:03','',''),(2636037,'1','179','933',413,'Retail Sale Id 1628633',27820.00,0.00,0.00,42.80,2054.40,'2022-04-23 16:40:05','',''),(2636038,'1','