-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_1_station_177
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_1_station_177`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_1_station_177` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_1_station_177`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3266 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (3256,20047,'',0,'20','1','177','SALES','','2021-03-18 16:09:18',5,0.00,0.00,'','479','2021-03-18 16:09:18','479',0,1),(3257,40047,'',0,'6.1','1','177','CASH','','2021-03-18 16:09:34',5,0.00,0.00,'','479','2021-03-18 16:09:34','479',0,1),(3258,400303,'',0,'24','1','177','SALARIES & WAGES','','2021-03-18 16:14:57',5,0.00,0.00,'','479','2021-03-18 16:14:57','479',0,1),(3259,400304,'',0,'24','1','177','PURCHASES','','2021-03-18 16:15:23',5,0.00,0.00,'','479','2021-03-18 16:15:23','479',0,1),(3260,400512,'',0,'2','1','177','ZBN E-BILLS: 1015372548','','2021-03-18 16:17:23',5,0.00,0.00,'','479','2021-03-18 16:17:23','479',0,1),(3261,400513,'',0,'2','1','177','ZBN(POS):1015965368','','2021-03-18 16:18:18',5,0.00,0.00,'','479','2021-03-18 16:18:18','479',0,1),(3262,400514,'',0,'2','1','177','DANKANO-EBILLS(ZNB:1014717618)','','2021-03-18 16:19:22',5,0.00,0.00,'','479','2021-03-18 16:19:22','479',0,1),(3263,400515,'',0,'2','1','177','FIDPOS COLLECTION-5620141491','','2021-03-18 16:35:56',5,0.00,0.00,'','479','2021-03-18 16:35:56','479',0,1),(3264,400516,'',0,'2','1','177','UBA LPG POS COLL ACCT:-1025923','UBA LPG POS COLLECTION ACCOUNT','2023-02-20 14:08:50',5,0.00,0.00,'','792','2023-02-20 14:08:50','792',0,0),(3265,400517,'',0,'2','1','177','MONIE POINT COLL ACCT:-8238303','MONIE POINT AA RANO LPG COLL ACCT:-8238303237','2023-03-15 17:22:46',5,0.00,0.00,'2023-03-15','792','2023-03-17 12:25:09','792',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4103 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (3481,'','1','177','OPERATIONAL LOSS','OPERATIONAL LOSS','0000000000','hhha2@gmail.com','ABUJA','abuja','jabi','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-10-18 11:05:36',5,'610','2021-10-18 11:05:36','610'),(3742,'','1','177','baba yalo','central area','08029569174','babayalo@gmailcom','ABUJA','abuja','central area','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-13 11:02:31',5,'610','2021-11-13 11:02:31','610'),(3874,'','1','177','ZEUS PARADISE H0TEL','NO 1 DOMENCO GITTO STREET','08064590184','funkejoyade@gmailcom','ABUJA','abuja','NO 1 DOMENCO GITTO STREET','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-11-27 14:25:49',5,'610','2021-11-27 14:25:49','610'),(4102,'','1','177','LEGION OIL AND GAS','NO 9 EBITU UKIWE STREET JABI','08065234844','legionoil&gas@gmailcom','ABUJA','abuja','NO9 EBITU UKIWE STREET JABI','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-12-27 18:14:18',5,'610','2021-12-27 18:14:18','610');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=16350 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('1','177',16349,'919',7.92,508.00,'2021-09-08','new dipping','2021-09-08 13:44:48','483','483',2021,'483','2021-09-08 13:44:48',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2720 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('1','177','919',2716,'5','LPG NOZZLE 1',35606.59,'LPG DESPENSER',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('1','177','919',2717,'5','LPG NOZZLE 2',92488.40,'LPG DESPENSER','',NULL,NULL,'',5,'2021-03-21 05:44:55','483'),('1','177','919',2718,'5','LPG NOZZLE 3',422496.60,'LPG DESPENSER','',NULL,NULL,'',5,'2021-03-21 05:45:46','483'),('1','177','919',2719,'5','LPG NOZZLE 4',586956.33,'LPG DESPENSER','',NULL,NULL,'',5,'2021-03-21 05:46:40','483');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257991 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('1','177',185575,'DAILY SALES SHIFT','2021-03-20','2021-03-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-21 05:42:08','610','2021-03-21 05:42:24',10,0),('1','177',185703,'DAILY SALES SHIFT','2021-03-21','2021-03-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-21 18:20:07','610','2021-03-21 18:24:46',10,0),('1','177',185892,'DAILY SALES SHIFT','2021-03-22','2021-03-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-22 17:48:20','610','2021-03-22 17:48:35',10,0),('1','177',186122,'DAILY SALES SHIFT','2021-03-23','2021-03-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-23 17:51:06','610','2021-03-23 17:51:25',10,0),('1','177',186332,'DAILY SALES SHIFT','2021-03-24','2021-03-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-24 18:02:04','610','2021-03-24 18:02:57',10,0),('1','177',186531,'DAILY SALES SHIFT','2021-03-25','2021-03-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-25 18:00:44','610','2021-03-25 18:00:59',10,0),('1','177',186773,'DAILY SHIFT','2021-03-26','2021-03-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-26 18:37:54','610','2021-03-26 18:38:29',10,0),('1','177',186983,'DAILY SALES SHIFT','2021-03-27','2021-03-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-27 18:19:00','610','2021-03-27 18:19:29',10,0),('1','177',187197,'DAILY SALES SHIFT','2021-03-28','2021-03-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-28 18:08:46','610','2021-03-28 18:18:24',10,0),('1','177',187339,'DAILY SHIFT','2021-03-29','2021-03-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-29 18:20:01','610','2021-03-29 18:20:31',10,0),('1','177',187597,'DAILY SHIFT','2021-03-30','2021-03-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-30 18:12:21','610','2021-03-30 18:12:45',10,0),('1','177',187799,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-03-31 18:27:50','610','2021-03-31 18:28:15',10,0),('1','177',187998,'DAILY SHIFT','2021-03-31','2021-03-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-01 07:38:45','610','2021-04-01 07:39:05',10,0),('1','177',188033,'DAILY SHIFT','2021-04-01','2021-04-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-01 18:25:57','610','2021-04-01 18:26:24',10,0),('1','177',188198,'DAILY SHIFT','2021-04-02','2021-04-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-02 18:29:52','610','2021-04-02 18:30:46',10,0),('1','177',188411,'DAILY SHIFT','2021-04-03','2021-04-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-03 18:33:31','610','2021-04-03 18:37:46',10,0),('1','177',188617,'DAILY SHIFT','2021-04-04','2021-04-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-04 18:48:39','610','2021-04-04 18:49:06',10,0),('1','177',188797,'DAILY SHIFT23700','2021-04-05','2021-04-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-05 18:07:22','610','2021-04-05 18:07:47',10,0),('1','177',189039,'DAILY SHIFT','2021-04-06','2021-04-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-06 17:53:53','610','2021-04-06 17:55:21',10,0),('1','177',189197,'DAILY SHIFT','2021-04-07','2021-04-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-07 18:01:00','610','2021-04-07 18:01:24',10,0),('1','177',189415,'DAILY SHIFT','2021-04-08','2021-04-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-08 17:55:25','610','2021-04-08 17:55:49',10,0),('1','177',189618,'DAILY SHIFT','2021-04-09','2021-04-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-09 15:52:53','610','2021-04-09 15:53:09',10,0),('1','177',189966,'DAILY SALES SHIFT','2021-04-10','2021-04-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-10 17:42:27','610','2021-04-10 17:42:49',10,0),('1','177',190042,'DAILY SALES SHIFT','2021-04-11','2021-04-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-11 17:48:32','610','2021-04-11 17:49:05',10,0),('1','177',190206,'DAILY SHIFT','2021-04-12','2021-04-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-12 18:14:26','610','2021-04-12 18:14:39',10,0),('1','177',190437,'DAILY SALES SHIFT','2021-04-13','2021-04-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-13 18:13:30','610','2021-04-13 18:14:31',10,0),('1','177',190664,'DAILY SALES SHIFT','2021-04-14','2021-04-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-14 17:30:47','610','2021-04-14 17:31:17',10,0),('1','177',190888,'DAILY SALES SHIFT','2021-04-15','2021-04-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-15 17:51:26','610','2021-04-15 17:52:17',10,0),('1','177',191073,'DAILY SALES SHIFT','2021-04-16','2021-04-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-16 17:48:02','610','2021-04-16 17:48:35',10,0),('1','177',191291,'DAILY SALES SHIFT','2021-04-17','2021-04-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-17 18:01:40','610','2021-04-17 18:03:01',10,0),('1','177',191492,'DAILY SALES SHIFT','2021-04-18','2021-04-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-18 17:40:13','610','2021-04-18 17:40:38',10,0),('1','177',191716,'DAILY SALES SHIFT','2021-04-19','2021-04-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-19 18:16:53','610','2021-04-19 18:17:23',10,0),('1','177',191953,'DAILY SALES SHIFT','2021-04-20','2021-04-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-20 18:02:37','610','2021-04-20 18:03:43',10,0),('1','177',192130,'DAILY SALES SHIFT','2021-04-21','2021-04-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-21 18:01:11','610','2021-04-21 18:01:38',10,0),('1','177',192344,'DAILY SALES SHIFT','2021-04-22','2021-04-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-22 17:55:26','610','2021-04-22 17:56:02',10,0),('1','177',192567,'DAILY SALES SHIFT','2021-04-23','2021-04-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-23 18:04:40','610','2021-04-23 18:05:04',10,0),('1','177',192777,'DAILY SALES SHIFT','2021-04-24','2021-04-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-24 17:58:19','610','2021-04-24 17:58:42',10,0),('1','177',192957,'DAILY SALES SHIFT','2021-04-25','2021-04-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-25 17:49:22','610','2021-04-25 17:49:44',10,0),('1','177',193157,'DAILY SALES SHIFT','2021-04-26','2021-04-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-26 17:44:39','610','2021-04-26 17:45:08',10,0),('1','177',193410,'DAILY SALES SHIFT','2021-04-27','2021-04-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-27 17:40:39','610','2021-04-27 17:41:05',10,0),('1','177',193634,'DAILY SALES SHIFT','2021-04-28','2021-04-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-28 17:49:35','610','2021-04-28 17:49:50',10,0),('1','177',193857,'DAILY SALES SHIFT','2021-04-29','2021-04-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-29 17:53:17','610','2021-04-29 17:55:14',10,0),('1','177',194093,'DAILY SALES SHIFT','2021-04-30','2021-04-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-04-30 18:31:18','610','2021-04-30 18:32:55',10,0),('1','177',194295,'DAILY SALES SHIFT','2021-05-01','2021-05-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-01 18:16:09','610','2021-05-01 18:16:36',10,0),('1','177',194499,'DAILY SALES SHIFT','2021-05-02','2021-05-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-02 18:05:19','610','2021-05-02 18:05:38',10,0),('1','177',194678,'DAILY SALES SHIFT','2021-05-03','2021-05-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-03 13:52:09','610','2021-05-03 13:52:32',10,0),('1','177',194813,'DAILY SALES SHIFT SECOND SALES','2021-05-03','2021-05-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-03 17:40:04','610','2021-05-03 17:40:25',10,0),('1','177',194887,'DAILY SALES SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-04 17:53:33','610','2021-05-04 17:53:55',10,0),('1','177',195088,'DAILY SALES SHIFT','2021-05-05','2021-05-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-05 17:52:54','610','2021-05-05 17:53:15',10,0),('1','177',195308,'DAILY SALES SHIFT','2021-05-06','2021-05-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-06 17:52:23','610','2021-05-06 17:53:00',10,0),('1','177',195534,'DAILY SALES SHIFT','2021-05-07','2021-05-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-07 17:55:22','610','2021-05-07 17:56:10',10,0),('1','177',195793,'DAILY SALES SHIFT','2021-05-08','2021-05-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-08 17:54:12','610','2021-05-08 17:54:42',10,0),('1','177',196020,'DAILY SALES SHIFT','2021-05-09','2021-05-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-09 17:47:11','610','2021-05-09 17:47:36',10,0),('1','177',196243,'DAILY SALES SHIFT','2021-05-10','2021-05-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-10 18:14:00','610','2021-05-10 18:14:19',10,0),('1','177',196467,'DAILY SALES SHIFT','2021-05-11','2021-05-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-11 17:51:54','610','2021-05-11 17:52:19',10,0),('1','177',196668,'DAILY SALES SHIFT','2021-05-12','2021-05-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-12 17:47:49','610','2021-05-12 17:48:13',10,0),('1','177',196885,'DAILY SALES SHIFT','2021-05-13','2021-05-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-13 17:52:45','610','2021-05-13 17:52:58',10,0),('1','177',197038,'DAILY SALES SHIFT','2021-05-14','2021-05-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-14 17:37:23','610','2021-05-14 17:37:46',10,0),('1','177',197333,'DAILY SALES SHIFT  FIRST SALES','2021-05-15','2021-05-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-16 12:15:45','610','2021-05-16 12:16:05',10,0),('1','177',197336,'DAILY SALES SHIFT SECOND SALES','2021-05-15','2021-05-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-16 13:08:08','610','2021-05-16 13:08:29',10,0),('1','177',197396,'DAILY SALES SHIFT','2021-05-16','2021-05-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-16 17:54:30','610','2021-05-16 17:55:09',10,0),('1','177',197524,'DAILY SALES SHIFT','2021-05-17','2021-05-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-17 17:46:23','610','2021-05-17 17:47:54',10,0),('1','177',197885,'DAILY SALES SHIFT','2021-05-18','2021-05-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-18 18:01:33','610','2021-05-18 18:01:52',10,0),('1','177',198131,'DAILY SALES SHIFT','2021-05-19','2021-05-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-19 17:59:18','610','2021-05-19 18:00:00',10,0),('1','177',198363,'DAILY SALES SHIFT','2021-05-20','2021-05-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-20 18:01:45','610','2021-05-20 18:02:06',10,0),('1','177',198581,'DAILY SALES SHIFT','2021-05-21','2021-05-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-21 17:57:22','610','2021-05-21 17:57:42',10,0),('1','177',198784,'DAILY SALES SHIFT','2021-05-22','2021-05-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-22 17:53:22','610','2021-05-22 17:53:40',10,0),('1','177',198999,'DAILY SALES SHIFT','2021-05-23','2021-05-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-23 17:43:39','610','2021-05-23 17:43:57',10,0),('1','177',199227,'DAILY SALES SHIFT','2021-05-24','2021-05-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-24 18:00:19','610','2021-05-24 18:00:37',10,0),('1','177',199447,'DAILY SALES SHIFT','2021-05-25','2021-05-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-25 10:25:03','610','2021-05-25 10:25:21',10,0),('1','177',199526,'DAILY SALES SHIFT SECOND SALES','2021-05-25','2021-05-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-25 17:49:18','610','2021-05-25 17:49:38',10,0),('1','177',199716,'DAILY SALES SHIFT','2021-05-26','2021-05-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-26 17:59:23','610','2021-05-26 17:59:39',10,0),('1','177',199901,'DAILY SALES SHIFT','2021-05-27','2021-05-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-27 18:32:52','610','2021-05-27 18:33:11',10,0),('1','177',200134,'DAILY SALES SHIFT','2021-05-28','2021-05-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-28 19:09:09','610','2021-05-28 19:09:27',10,0),('1','177',200289,'DAILY SALES SHIFT','2021-05-29','2021-05-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-29 19:01:00','610','2021-05-29 19:01:23',10,0),('1','177',200499,'DAILY SALES SHIFT','2021-05-30','2021-05-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-30 19:02:30','610','2021-05-30 19:02:48',10,0),('1','177',200685,'DAILY SALES SHIFT','2021-05-31','2021-05-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-05-31 18:44:21','610','2021-05-31 18:44:37',10,0),('1','177',200934,'DAILY SALES SHIFT','2021-06-01','2021-06-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-01 19:06:40','610','2021-06-01 19:06:58',10,0),('1','177',201109,'DAILY SALES SHIFT','2021-06-02','2021-06-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-02 18:31:31','610','2021-06-02 18:31:52',10,0),('1','177',201337,'DAILY SALES SHIFT','2021-06-03','2021-06-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-03 18:32:13','610','2021-06-03 18:32:41',10,0),('1','177',201513,'DAILY SALES SHIFT','2021-06-04','2021-06-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-04 08:16:25','610','2021-06-04 08:16:44',10,0),('1','177',201531,'DAILY SALES SHIFT SECOND SALES','2021-06-04','2021-06-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-04 18:26:21','610','2021-06-04 18:26:40',10,0),('1','177',201778,'DAILY SALES SHIFT','2021-06-05','2021-06-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-05 19:02:11','610','2021-06-05 19:02:34',10,0),('1','177',202034,'DAILY SALES SHIFT','2021-06-06','2021-06-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-06 18:15:28','610','2021-06-06 18:18:05',10,0),('1','177',202234,'DAILY SALES SHIFT','2021-06-07','2021-06-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-07 18:21:30','610','2021-06-07 18:21:50',10,0),('1','177',202449,'DAILY SALES SHIFT','2021-06-08','2021-06-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-08 18:06:22','610','2021-06-08 18:06:41',10,0),('1','177',202635,'DAILY SALES SHIFT','2021-06-09','2021-06-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-09 18:18:38','610','2021-06-09 18:18:58',10,0),('1','177',202863,'DAILY SALES SHIFT','2021-06-10','2021-06-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-10 18:26:22','610','2021-06-10 18:26:40',10,0),('1','177',203140,'DAILY SALES SHIFT','2021-06-11','2021-06-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-11 17:43:35','610','2021-06-11 17:43:58',10,0),('1','177',203317,'DAILY SALES SHIFT','2021-06-12','2021-06-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-12 18:01:35','610','2021-06-12 18:01:50',10,0),('1','177',203519,'DAILY SALES SHIFT','2021-06-13','2021-06-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-13 18:24:14','610','2021-06-13 18:25:00',10,0),('1','177',203693,'DAILY SALES SHIFT 2nd shift of 5/6/2021 ','2021-06-05','2021-06-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-13 18:54:03','610','2021-06-13 18:54:19',10,0),('1','177',203739,'DAILY SALES SHIFT','2021-06-14','2021-06-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-14 18:13:39','610','2021-06-14 18:14:04',10,0),('1','177',203960,'DAILY SALES SHIFT','2021-06-15','2021-06-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-15 17:56:13','610','2021-06-15 17:56:42',10,0),('1','177',204208,'DAILY SALES SHIFT','2021-06-16','2021-06-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-16 18:12:47','610','2021-06-16 18:13:19',10,0),('1','177',204387,'DAILY SALES SHIFT','2021-06-17','2021-06-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-17 18:17:12','610','2021-06-17 18:17:42',10,0),('1','177',204665,'DAILY SALES SHIFT','2021-06-18','2021-06-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-18 18:28:41','610','2021-06-18 18:29:36',10,0),('1','177',204838,'DAILY SALES SHIFT','2021-06-19','2021-06-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-19 12:37:39','610','2021-06-19 12:37:57',10,0),('1','177',204948,'DAILY SALES SHIFT SECOND SALES','2021-06-19','2021-06-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-19 18:22:53','610','2021-06-19 18:23:15',10,0),('1','177',205048,'DAILY SALES SHIFT','2021-06-20','2021-06-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-20 17:51:40','610','2021-06-20 17:51:56',10,0),('1','177',205216,'DAILY SALES SHIFT','2021-06-21','2021-06-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-21 18:25:08','610','2021-06-21 18:25:28',10,0),('1','177',205465,'DAILY SALES SHIFT','2021-06-22','2021-06-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-22 18:11:34','610','2021-06-22 18:12:04',10,0),('1','177',205713,'DAILY SALES SHIFT','2021-06-23','2021-06-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-23 19:51:33','610','2021-06-23 19:52:31',10,0),('1','177',205951,'DAILY SALES SHIFT','2021-06-24','2021-06-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-24 19:09:09','610','2021-06-24 19:09:56',10,0),('1','177',206131,'DAILY SALES SHIFT','2021-06-25','2021-06-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-25 18:13:58','610','2021-06-25 18:14:21',10,0),('1','177',206377,'DAILY SALES SHIFT, FIRST SALES ','2021-06-26','2021-06-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-26 12:10:29','610','2021-06-26 12:11:00',10,0),('1','177',206466,'DAILY SALES SHIFT SECOND SALES','2021-06-26','2021-06-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-26 18:36:50','610','2021-06-26 18:37:19',10,0),('1','177',206627,'DAILY SALES SHIFT','2021-06-27','2021-06-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-27 18:29:59','610','2021-06-27 18:30:16',10,0),('1','177',206792,'DAILY SALES SHIFT','2021-06-28','2021-06-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-28 18:22:18','610','2021-06-28 18:22:46',10,0),('1','177',207037,'DAILY SALES SHIFT','2021-06-29','2021-06-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-29 21:50:33','610','2021-06-29 21:50:52',10,0),('1','177',207317,'DAILY SALES SHIFT','2021-06-30','2021-06-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-06-30 18:21:50','610','2021-06-30 18:22:41',10,0),('1','177',207489,'DAILY SALES SHIFT','2021-07-01','2021-07-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-01 18:42:45','610','2021-07-01 18:43:10',10,0),('1','177',207718,'DAILY SALES SHIFT','2021-07-02','2021-07-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-02 19:13:45','610','2021-07-02 19:14:09',10,0),('1','177',207904,'DAILY SALES SHIFT  FIRST SALES','2021-07-03','2021-07-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-03 10:45:46','610','2021-07-03 10:46:45',10,0),('1','177',207990,'DAILY SALES SHIFT SECOND SALES','2021-07-03','2021-07-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-03 18:38:36','610','2021-07-03 18:38:56',10,0),('1','177',208115,'DAILY SALES SHIFT','2021-07-04','2021-07-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-04 18:10:52','610','2021-07-04 18:12:15',10,0),('1','177',208323,'DAILY SALES SHIFT','2021-07-05','2021-07-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-06 07:03:04','610','2021-07-06 07:04:02',10,0),('1','177',208547,'DAILY SALES SHIFT','2021-07-06','2021-07-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-06 18:16:29','610','2021-07-06 18:17:01',10,0),('1','177',208794,'DAILY SALES SHIFT','2021-07-07','2021-07-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-07 18:32:29','610','2021-07-07 18:33:56',10,0),('1','177',209007,'DAILY SALES SHIFT','2021-07-08','2021-07-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-08 18:16:31','610','2021-07-08 18:16:50',10,0),('1','177',209205,'DAILY Shift FIRST SALE','2021-07-09','2021-07-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-09 09:29:34','610','2021-07-09 09:29:50',10,0),('1','177',209280,'DAILY SALES SHIFT SECOND SALES','2021-07-09','2021-07-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-09 18:38:35','610','2021-07-09 18:38:50',10,0),('1','177',209443,'DAILY SALES SHIFT','2021-07-10','2021-07-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-10 18:35:22','610','2021-07-10 18:35:55',10,0),('1','177',209632,'DAILY SALES SHIFT','2021-07-11','2021-07-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-11 18:16:41','610','2021-07-11 18:17:31',10,0),('1','177',209850,'DAILY SALES SHIFT','2021-07-12','2021-07-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-12 18:49:13','610','2021-07-12 18:49:44',10,0),('1','177',210100,'DAILY SALES SHIFT','2021-07-13','2021-07-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-13 18:19:26','610','2021-07-13 18:19:43',10,0),('1','177',210330,'DAILY SALES SHIFT','2021-07-14','2021-07-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-14 18:37:14','610','2021-07-14 18:37:30',10,0),('1','177',210484,'DAILY SALES SHIFT SECOND SALES','2021-07-14','2021-07-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-14 18:41:24','610','2021-07-14 18:41:40',10,0),('1','177',210530,'DAILY SALES SHIFT','2021-07-15','2021-07-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-15 18:30:48','610','2021-07-15 18:31:07',10,0),('1','177',210745,'DAILY SALES SHIFT','2021-07-16','2021-07-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-16 18:35:48','610','2021-07-16 18:36:02',10,0),('1','177',210956,'DAILY SALES SHIFT','2021-07-17','2021-07-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-17 14:37:29','610','2021-07-17 14:37:52',10,0),('1','177',211084,'DAILY SALES SHIFT SECOND SALES','2021-07-17','2021-07-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-17 18:38:35','610','2021-07-17 18:39:24',10,0),('1','177',211182,'DAILY SALES SHIFT','2021-07-18','2021-07-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-18 18:20:29','610','2021-07-18 18:20:49',10,0),('1','177',211448,'DAILY SALES SHIFT','2021-07-19','2021-07-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-19 18:47:31','610','2021-07-19 18:48:01',10,0),('1','177',211668,'DAILY SALES SHIFT','2021-07-20','2021-07-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-20 17:46:15','610','2021-07-20 17:46:31',10,0),('1','177',211811,'DAILY SALES SHIFT','2021-07-21','2021-07-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-21 18:41:17','610','2021-07-21 18:41:39',10,0),('1','177',212010,'DAILY SALES SHIFT','2021-07-22','2021-07-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-22 15:38:59','610','2021-07-22 15:39:17',10,0),('1','177',212190,'DAILY SALES SHIFT SECOND SALES','2021-07-22','2021-07-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-22 18:32:56','610','2021-07-22 18:33:09',10,0),('1','177',212442,'DAILY SALES SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-23 22:25:37','610','2021-07-23 22:25:53',10,0),('1','177',212649,'DAILY SALES SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-24 23:02:10','610','2021-07-24 23:02:30',10,0),('1','177',212681,'DAILY SALES SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-25 18:07:15','610','2021-07-25 18:07:47',10,0),('1','177',212896,'DAILY SALES SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-26 18:46:25','610','2021-07-26 18:46:44',10,0),('1','177',213092,'DAILY SALES SHIFT SECOND SALES','2021-07-26','2021-07-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-26 18:52:03','610','2021-07-26 18:52:25',10,0),('1','177',213159,'DAILY SALES SHIFT','2021-07-27','2021-07-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-27 18:57:36','610','2021-07-27 18:57:56',10,0),('1','177',213412,'DAILY SALES SHIFT','2021-07-28','2021-07-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-28 18:22:34','610','2021-07-28 18:22:53',10,0),('1','177',213645,'DAILY SALES SHIFT','2021-07-29','2021-07-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-29 14:31:33','610','2021-07-29 14:31:52',10,0),('1','177',213781,'DAILY SALES SHIFT SECOND SALES','2021-07-29','2021-07-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-29 18:57:40','610','2021-07-29 18:57:58',10,0),('1','177',213926,'DAILY SALES SHIFT','2021-07-30','2021-07-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-30 18:36:46','610','2021-07-30 18:37:05',10,0),('1','177',214096,'DAILY SALES SHIFT','2021-07-31','2021-07-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-07-31 18:18:07','610','2021-07-31 18:18:37',10,0),('1','177',214357,'DAILY SALES SHIFT','2021-08-01','2021-08-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-01 19:01:06','610','2021-08-01 19:01:24',10,0),('1','177',214556,'DAILY SALES SHIFT','2021-08-02','2021-08-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-02 21:52:08','610','2021-08-02 21:52:52',10,0),('1','177',214784,'DAILY SALES SHIFT','2021-08-03','2021-08-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-03 18:36:59','610','2021-08-03 18:37:16',10,0),('1','177',215003,'DAILY SALES SHIFT','2021-08-04','2021-08-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-04 10:06:41','610','2021-08-04 10:07:14',10,0),('1','177',215093,'DAILY SALES SHIFT SECOND SALES','2021-08-04','2021-08-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-04 18:17:08','610','2021-08-04 18:17:37',10,0),('1','177',215233,'DAILY SALES SHIFT','2021-08-05','2021-08-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-05 09:37:35','610','2021-08-05 09:38:18',10,0),('1','177',215296,'DAILY SALES SHIFT SECOND SALES','2021-08-05','2021-08-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-05 18:26:18','610','2021-08-05 18:27:06',10,0),('1','177',215447,'DAILY SALES SHIFT','2021-08-06','2021-08-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-06 18:31:38','610','2021-08-06 18:32:25',10,0),('1','177',215677,'DAILY SALES SHIFT','2021-08-07','2021-08-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-07 18:32:56','610','2021-08-07 18:34:29',10,0),('1','177',215869,'DAILY SALES SHIFT SECOND SALES','2021-08-07','2021-08-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-07 18:56:06','610','2021-08-07 18:56:31',10,0),('1','177',215906,'DAILY SALES SHIFT','2021-08-08','2021-08-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-08 18:03:14','610','2021-08-08 18:03:29',10,0),('1','177',216119,'DAILY SALES SHIFT','2021-08-09','2021-08-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-09 18:18:17','610','2021-08-09 18:18:39',10,0),('1','177',216334,'DAILY SALES SHIFT','2021-08-10','2021-08-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-10 18:28:43','610','2021-08-10 18:29:21',10,0),('1','177',216559,'DAILY SALES SHIFT','2021-08-11','2021-08-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-11 18:20:44','610','2021-08-11 18:21:51',10,0),('1','177',216794,'DAILY SALES SHIFT  FIRST SALES','2021-08-12','2021-08-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-12 09:56:44','610','2021-08-12 09:57:07',10,0),('1','177',216866,'DAILY SALES SHIFT SECOND SALES','2021-08-12','2021-08-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-12 18:31:06','610','2021-08-12 18:31:48',10,0),('1','177',217013,'DAILY SALES SHIFT','2021-08-13','2021-08-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-13 18:26:36','610','2021-08-13 18:27:07',10,0),('1','177',217274,'DAILY SALES SHIFT','2021-08-14','2021-08-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-14 15:29:49','610','2021-08-14 15:30:28',10,0),('1','177',217443,'DAILY SALES SHIFT SECOND SALES','2021-08-14','2021-08-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-14 18:28:46','610','2021-08-14 18:29:21',10,0),('1','177',217507,'DAILY SALES SHIFT','2021-08-15','2021-08-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-15 18:14:59','610','2021-08-15 18:16:20',10,0),('1','177',217728,'DAILY SALES SHIFT','2021-08-16','2021-08-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-16 18:28:51','610','2021-08-16 18:30:25',10,0),('1','177',217978,'DAILY SALES SHIFT','2021-08-17','2021-08-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-17 18:43:45','610','2021-08-17 18:44:17',10,0),('1','177',218231,'DAILY Shift FIRST SALE','2021-08-18','2021-08-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-18 11:53:04','610','2021-08-18 11:54:33',10,0),('1','177',218329,'DAILY SALES SHIFT SECOND SALES','2021-08-18','2021-08-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-18 18:35:16','610','2021-08-18 18:36:23',10,0),('1','177',218451,'DAILY SALES SHIFT','2021-08-19','2021-08-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-19 18:12:52','610','2021-08-19 18:13:58',10,0),('1','177',218682,'DAILY SALES SHIFT','2021-08-20','2021-08-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-20 18:56:37','610','2021-08-20 18:57:15',10,0),('1','177',218905,'DAILY SALES SHIFT','2021-08-21','2021-08-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-21 18:16:43','610','2021-08-21 18:17:17',10,0),('1','177',219124,'DAILY SALES SHIFT','2021-08-22','2021-08-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-22 08:52:53','610','2021-08-22 08:58:29',10,0),('1','177',219168,'DAILY SALES SHIFT SECOND SALES','2021-08-22','2021-08-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-22 18:31:14','610','2021-08-22 18:34:55',10,0),('1','177',219325,'DAILY SALES SHIFT','2021-08-23','2021-08-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-23 11:51:43','610','2021-08-23 11:52:02',10,0),('1','177',219471,'DAILY SALES SHIFT SECOND SALES','2021-08-23','2021-08-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-23 18:23:24','610','2021-08-23 18:32:24',10,0),('1','177',219605,'DAILY SALES SHIFT','2021-08-24','2021-08-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-24 18:19:08','610','2021-08-24 18:24:39',10,0),('1','177',219811,'DAILY SALES SHIFT','2021-08-25','2021-08-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-25 18:16:51','610','2021-08-25 18:17:26',10,0),('1','177',220055,'DAILY SALES SHIFT','2021-08-26','2021-08-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-26 13:58:06','610','2021-08-26 14:00:32',10,0),('1','177',220159,'DAILY SALES SHIFT SECOND SALES','2021-08-26','2021-08-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-26 18:44:24','610','2021-08-26 18:45:06',10,0),('1','177',220260,'DAILY SALES SHIFT','2021-08-27','2021-08-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-27 18:19:03','610','2021-08-27 18:32:00',10,0),('1','177',220463,'DAILY SALES SHIFT','2021-08-28','2021-08-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-28 18:21:10','610','2021-08-28 18:25:33',10,0),('1','177',220692,'DAILY SALES SHIFT  FIRST SALES','2021-08-29','2021-08-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-29 09:52:50','610','2021-08-29 09:55:01',10,0),('1','177',220742,'DAILY SALES SHIFT SECOND SALES','2021-08-29','2021-08-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-29 18:57:55','610','2021-08-29 18:58:59',10,0),('1','177',220908,'DAILY SALES SHIFT','2021-08-30','2021-08-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-30 18:52:54','610','2021-08-30 18:54:07',10,0),('1','177',221149,'DAILY SALES SHIFT','2021-08-31','2021-08-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-08-31 18:37:35','610','2021-08-31 18:40:06',10,0),('1','177',221402,'DAILY SALES SHIFT','2021-09-01','2021-09-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-01 16:46:35','610','2021-09-01 16:48:16',10,0),('1','177',221608,'DAILY SALES SHIFT','2021-09-02','2021-09-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-02 19:07:40','610','2021-09-02 19:09:46',10,0),('1','177',221841,'DAILY SALES SHIFT','2021-09-03','2021-09-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-03 18:38:50','610','2021-09-03 18:40:58',10,0),('1','177',222071,'DAILY SALES SHIFT','2021-09-04','2021-09-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-04 18:48:13','610','2021-09-04 18:55:05',10,0),('1','177',222286,'DAILY SALES SHIFT','2021-09-05','2021-09-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-05 14:48:32','610','2021-09-05 14:49:38',10,0),('1','177',222417,'DAILY SALES SHIFT SECOND SALES','2021-09-05','2021-09-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-05 18:46:33','610','2021-09-05 18:47:13',10,0),('1','177',222524,'DAILY SALES SHIFT','2021-09-06','2021-09-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-06 18:40:45','610','2021-09-06 18:41:39',10,0),('1','177',222726,'DAILY SALES SHIFT','2021-09-07','2021-09-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-08 10:59:05','610','2021-09-08 11:00:00',10,0),('1','177',223029,'DAILY SALES SHIFT  FIRST SALES','2021-09-08','2021-09-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-08 13:52:06','610','2021-09-08 13:52:24',10,0),('1','177',223073,'DAILY SALES SHIFT SECOND SALES','2021-09-08','2021-09-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-08 18:20:24','610','2021-09-08 18:20:56',10,0),('1','177',223261,'DAILY SALES SHIFT','2021-09-09','2021-09-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-09 18:19:15','610','2021-09-09 18:20:31',10,0),('1','177',223429,'DAILY SALES SHIFT','2021-09-10','2021-09-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-10 18:30:19','610','2021-09-10 18:32:48',10,0),('1','177',223628,'DAILY SHIFT FIRST SALE','2021-09-11','2021-09-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-11 10:28:19','610','2021-09-11 10:28:46',10,0),('1','177',223724,'OPERATIONAL LOST','2021-09-11','2021-09-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-11 10:38:57','610','2021-09-11 10:39:17',10,0),('1','177',223728,'DAILY SALES SHIFT SECOND SALES','2021-09-11','2021-09-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-11 18:46:33','610','2021-09-11 18:47:37',10,0),('1','177',223844,'DAILY SALES SHIFT(operational lost)','2021-09-11','2021-09-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-11 19:44:05','610','2021-09-11 19:44:23',10,0),('1','177',223902,'DAILY SALES SHIFT','2021-09-12','2021-09-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-12 18:25:04','610','2021-09-12 18:26:11',10,0),('1','177',224065,'DAILY SALES SHIFT','2021-09-13','2021-09-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-13 18:14:27','610','2021-09-13 18:16:49',10,0),('1','177',224295,'DAILY SALES SHIFT','2021-09-14','2021-09-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-14 18:28:10','610','2021-09-14 18:28:55',10,0),('1','177',224535,'DAILY SALES SHIFT, FIRST SALES ','2021-09-15','2021-09-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-15 12:45:20','610','2021-09-15 12:45:56',10,0),('1','177',224662,'DAILY SALES SHIFT SECOND SALES','2021-09-15','2021-09-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-15 18:26:12','610','2021-09-15 18:27:41',10,0),('1','177',224773,'DAILY SALES SHIFT','2021-09-16','2021-09-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-16 18:25:47','610','2021-09-16 18:26:14',10,0),('1','177',225001,'DAILY SALES SHIFT','2021-09-17','2021-09-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-17 18:09:49','610','2021-09-17 18:11:31',10,0),('1','177',225249,'DAILY SALES SHIFT','2021-09-18','2021-09-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-18 12:32:10','610','2021-09-18 12:35:48',10,0),('1','177',225387,'DAILY SALES SHIFT SECOND SALES','2021-09-18','2021-09-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-18 18:31:34','610','2021-09-18 18:32:10',10,0),('1','177',225480,'DAILY SALES SHIFT','2021-09-19','2021-09-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-19 18:25:44','610','2021-09-19 18:31:03',10,0),('1','177',225679,'DAILY SALES SHIFT','2021-09-20','2021-09-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-20 18:38:00','610','2021-09-20 18:38:18',10,0),('1','177',226018,'DAILY SALES SHIFT  FIRST SALES','2021-09-21','2021-09-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-21 12:16:57','610','2021-09-21 12:17:55',10,0),('1','177',226106,'DAILY SALES SHIFT SECOND SALES','2021-09-21','2021-09-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-21 18:52:44','610','2021-09-21 18:54:23',10,0),('1','177',226233,'DAILY SALES SHIFT','2021-09-22','2021-09-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-22 18:04:00','610','2021-09-22 18:04:49',10,0),('1','177',226463,'DAILY SALES SHIFT','2021-09-23','2021-09-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-23 20:00:50','610','2021-09-23 20:01:30',10,0),('1','177',226749,'DAILY SALES SHIFT','2021-09-24','2021-09-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-24 18:47:45','610','2021-09-24 18:48:46',10,0),('1','177',226944,'DAILY SALES SHIFT, FIRST SALES ','2021-09-25','2021-09-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-25 11:46:48','610','2021-09-25 11:47:20',10,0),('1','177',227062,'DAILY SALES SHIFT SECOND SALES','2021-09-25','2021-09-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-25 18:29:45','610','2021-09-25 18:30:01',10,0),('1','177',227181,'DAILY SALES SHIFT','2021-09-26','2021-09-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-26 18:20:06','610','2021-09-26 18:21:04',10,0),('1','177',227409,'DAILY SALES SHIFT','2021-09-27','2021-09-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-27 18:17:41','610','2021-09-27 18:18:40',10,0),('1','177',227597,'DAILY SALES SHIFT','2021-09-28','2021-09-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-28 18:44:47','610','2021-09-28 18:45:44',10,0),('1','177',227813,'DAILY SALES SHIFT SECOND SALES','2021-09-28','2021-09-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-28 18:50:41','610','2021-09-28 18:50:58',10,0),('1','177',227840,'DAILY SALES SHIFT','2021-09-29','2021-09-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-29 18:10:13','610','2021-09-29 18:14:04',10,0),('1','177',228127,'DAILY SALES SHIFT','2021-09-30','2021-09-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-09-30 18:15:52','610','2021-09-30 18:16:47',10,0),('1','177',228351,'DAILY SALES SHIFT','2021-10-01','2021-10-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-01 19:03:10','610','2021-10-01 19:04:20',10,0),('1','177',228529,'DAILY SALES SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-02 18:23:46','610','2021-10-02 18:24:35',10,0),('1','177',228758,'DAILY SALES SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-03 18:32:55','610','2021-10-03 18:33:21',10,0),('1','177',228938,'DAILY SALES SHIFT, FIRST SALES ','2021-10-04','2021-10-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-04 10:05:36','610','2021-10-04 10:06:08',10,0),('1','177',229013,'DAILY SALES SHIFT SECOND SALES','2021-10-04','2021-10-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-04 18:03:16','610','2021-10-04 18:04:04',10,0),('1','177',229177,'DAILY SALES SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-05 17:56:41','610','2021-10-05 17:57:38',10,0),('1','177',229411,'DAILY SALES SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-06 17:58:30','610','2021-10-06 17:59:17',10,0),('1','177',229664,'DAILY SALES SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-07 09:42:00','610','2021-10-07 09:42:26',10,0),('1','177',229724,'DAILY SALES SHIFT SECOND SALES','2021-10-07','2021-10-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-07 21:23:28','610','2021-10-07 21:24:30',10,0),('1','177',229873,'DAILY SALES SHIFT','2021-10-08','2021-10-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-08 21:48:33','610','2021-10-08 22:14:32',10,0),('1','177',230075,'DAILY SALES SHIFT','2021-10-09','2021-10-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-10 04:14:40','610','2021-10-10 04:15:28',10,0),('1','177',230273,'DAILY SALES SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-10 16:32:51','610','2021-10-10 16:34:52',10,0),('1','177',230473,'DAILY SALES SHIFT SECOND SALES','2021-10-10','2021-10-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-10 19:25:07','610','2021-10-10 19:27:12',10,0),('1','177',230544,'DAILY SALES SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-11 14:45:57','610','2021-10-11 14:48:01',10,0),('1','177',230703,'DAILY SALES SHIFT SECOND SALES','2021-10-11','2021-10-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-11 19:26:18','610','2021-10-11 19:26:52',10,0),('1','177',230780,'DAILY SALES SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-12 19:01:26','610','2021-10-12 19:09:00',10,0),('1','177',231050,'DAILY SALES SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-13 21:09:16','610','2021-10-13 21:12:52',10,0),('1','177',231358,'DAILY SALES SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-14 15:19:45','610','2021-10-14 15:20:51',10,0),('1','177',231565,'DAILY SALES SHIFT SECOND SALES','2021-10-14','2021-10-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-14 19:27:24','610','2021-10-14 19:33:31',10,0),('1','177',231628,'DAILY SALES SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-15 19:41:52','610','2021-10-15 19:42:44',10,0),('1','177',231875,'DAILY SALES SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-16 21:19:22','610','2021-10-16 21:25:47',10,0),('1','177',232102,'DAILY SALES SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-17 12:21:31','610','2021-10-17 12:22:44',10,0),('1','177',232213,'DAILY SALES SHIFT SECOND SALES','2021-10-17','2021-10-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-17 19:57:07','610','2021-10-17 19:57:56',10,0),('1','177',232301,'Operational lost','2021-10-17','2021-10-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-17 20:34:37','610','2021-10-17 20:34:59',10,0),('1','177',232318,'DAILY SALES SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-18 19:49:14','610','2021-10-18 19:51:20',10,0),('1','177',232559,'OPERATIONAL LOSS','2021-10-18','2021-10-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-18 19:58:40','610','2021-10-18 19:58:56',10,0),('1','177',232573,'DAILY SALES SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-19 19:54:28','610','2021-10-19 20:08:07',10,0),('1','177',232827,'DAILY SALES SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-20 19:53:19','610','2021-10-20 19:56:07',10,0),('1','177',233073,'OPERATIONAL LOSS','2021-10-20','2021-10-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-20 20:00:23','610','2021-10-20 20:00:38',10,0),('1','177',233107,'DAILY SALES SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-21 19:46:28','610','2021-10-21 19:47:39',10,0),('1','177',233356,'DAILY SALES SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-22 21:00:09','610','2021-10-22 21:02:01',10,0),('1','177',233591,'DAILY SALES SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-23 20:06:05','610','2021-10-23 20:12:45',10,0),('1','177',233824,'DAILY SALES SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-24 16:48:12','610','2021-10-24 16:49:08',10,0),('1','177',233987,'DAILY SALES SHIFT SECOND SALES','2021-10-24','2021-10-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-24 19:33:28','610','2021-10-24 19:34:17',10,0),('1','177',234038,'DAILY SALES SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-25 11:00:48','610','2021-10-25 11:01:45',10,0),('1','177',234169,'DAILY SALES SHIFT PRICE CHANGE 600/KG','2021-10-25','2021-10-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-25 20:03:09','610','2021-10-25 20:04:07',10,0),('1','177',234292,'DAILY SALES SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-26 19:59:53','610','2021-10-26 20:01:36',10,0),('1','177',234567,'DAILY SALES SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-27 19:43:17','610','2021-10-27 19:44:04',10,0),('1','177',234802,'DAILY SALES SHIFT, FIRST SALES ','2021-10-28','2021-10-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-28 16:25:37','610','2021-10-28 16:31:29',10,0),('1','177',235047,'DAILY SALES SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-29 19:40:04','610','2021-10-29 19:41:33',10,0),('1','177',235282,'DAILY SALES SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-30 18:59:45','610','2021-10-30 19:00:10',10,0),('1','177',235507,'DAILY SALES SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-10-31 19:05:57','610','2021-10-31 19:08:59',10,0),('1','177',235735,'DAILY SALES SHIFT, FIRST SALES ','2021-11-01','2021-11-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-01 11:56:17','610','2021-11-01 11:57:29',10,0),('1','177',235889,'DAILY SALES SHIFT SECOND SALES','2021-11-01','2021-11-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-01 19:38:19','610','2021-11-01 19:39:04',10,0),('1','177',235995,'DAILY SALES SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-02 19:08:40','610','2021-11-02 19:10:22',10,0),('1','177',236218,'DAILY SALES SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-03 19:13:36','610','2021-11-03 19:14:48',10,0),('1','177',236486,'DAILY SALES SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-04 19:25:02','610','2021-11-04 19:25:56',10,0),('1','177',236711,'DAILY SALES SHIFT, FIRST SALES ','2021-11-05','2021-11-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-05 09:16:23','610','2021-11-05 09:16:56',10,0),('1','177',236811,'DAILY SALES SHIFT SECOND SALES','2021-11-05','2021-11-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-05 19:43:26','610','2021-11-05 19:44:06',10,0),('1','177',236938,'DAILY SALES SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-06 19:21:24','610','2021-11-06 19:21:52',10,0),('1','177',237150,'DAILY SALES SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-07 19:15:59','610','2021-11-07 19:16:54',10,0),('1','177',237362,'DAILY SALES SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-08 19:12:21','610','2021-11-08 19:13:09',10,0),('1','177',237588,'DAILY SALES SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-09 14:02:27','610','2021-11-09 14:03:08',10,0),('1','177',237753,'OPERATIONAL LOSS','2021-11-09','2021-11-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-09 14:08:22','610','2021-11-09 14:08:37',10,0),('1','177',237755,'DAILY SALES SHIFT SECOND SALES','2021-11-09','2021-11-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-09 18:56:02','610','2021-11-09 18:56:39',10,0),('1','177',237850,'DAILY SALES SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-10 19:01:05','610','2021-11-10 19:01:32',10,0),('1','177',238104,'DAILY SALES SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-11 19:03:26','610','2021-11-11 19:03:52',10,0),('1','177',238337,'DAILY SALES SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-12 18:58:54','610','2021-11-12 18:59:35',10,0),('1','177',238596,'DAILY SALES SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-13 19:09:33','610','2021-11-13 19:10:01',10,0),('1','177',238821,'DAILY SALES SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-14 19:02:06','610','2021-11-14 19:02:31',10,0),('1','177',239055,'DAILY SALES SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-15 19:10:23','610','2021-11-15 19:11:50',10,0),('1','177',239300,'DAILY SALES SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-16 12:32:46','610','2021-11-16 12:33:29',10,0),('1','177',239402,'DAILY SALES SHIFT SECOND SALES','2021-11-16','2021-11-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-16 19:08:36','610','2021-11-16 19:09:26',10,0),('1','177',239539,'DAILY SALES SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-17 19:43:14','610','2021-11-17 19:44:05',10,0),('1','177',239742,'DAILY SALES SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-18 19:02:19','610','2021-11-18 19:02:45',10,0),('1','177',239990,'DAILY SALES SHIFT, FIRST SALES ','2021-11-19','2021-11-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-19 10:22:21','610','2021-11-19 10:22:44',10,0),('1','177',240072,'DAILY SALES SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-19 19:35:58','610','2021-11-19 19:36:23',10,0),('1','177',240174,'DAILY SALES SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-20 19:10:20','610','2021-11-20 19:10:53',10,0),('1','177',240432,'DAILY SALES SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-21 19:44:51','610','2021-11-21 19:45:28',10,0),('1','177',240665,'DAILY SALES SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-22 17:58:54','610','2021-11-22 17:59:47',10,0),('1','177',240898,'DAILY SALES SHIFT SECOND SALES','2021-11-22','2021-11-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-22 19:11:19','610','2021-11-22 19:11:39',10,0),('1','177',240948,'DAILY SALES SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-23 19:05:28','610','2021-11-23 19:06:00',10,0),('1','177',241200,'DAILY SALES SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-24 19:04:40','610','2021-11-24 19:05:01',10,0),('1','177',241469,'DAILY SALES SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-25 19:14:43','610','2021-11-25 19:15:05',10,0),('1','177',241712,'DAILY SALES SHIFT, FIRST SALES ','2021-11-26','2021-11-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-26 12:13:19','610','2021-11-26 12:14:03',10,0),('1','177',241852,'DAILY SALES SHIFT SECOND SALES','2021-11-26','2021-11-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-26 19:23:09','610','2021-11-26 19:23:29',10,0),('1','177',241962,'DAILY SALES SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-27 19:08:30','610','2021-11-27 19:08:52',10,0),('1','177',242180,'DAILY SALES SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-28 19:01:48','610','2021-11-28 19:02:15',10,0),('1','177',242408,'DAILY SALES SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-29 19:11:13','610','2021-11-29 19:11:50',10,0),('1','177',242620,'DAILY SALES SHIFT SECOND SALES','2021-11-29','2021-11-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-29 19:26:01','610','2021-11-29 19:26:21',10,0),('1','177',242650,'DAILY SALES SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-11-30 18:55:20','610','2021-11-30 18:56:04',10,0),('1','177',242899,'DAILY SALES SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-01 19:19:18','610','2021-12-01 19:20:03',10,0),('1','177',243116,'DAILY SALES SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-02 19:19:06','610','2021-12-02 19:19:56',10,0),('1','177',243338,'DAILY SALES SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-03 16:01:31','610','2021-12-03 16:02:05',10,0),('1','177',243524,'DAILY SALES SHIFT SECOND SALES','2021-12-03','2021-12-03 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-03 19:12:37','610','2021-12-03 19:13:04',10,0),('1','177',243574,'DAILY SALES SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-04 19:38:02','610','2021-12-04 19:38:40',10,0),('1','177',243807,'DAILY SALES SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-05 19:47:46','610','2021-12-05 19:49:26',10,0),('1','177',244031,'DAILY SALES SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-06 19:50:04','610','2021-12-06 19:50:55',10,0),('1','177',244266,'DAILY SALES SHIFT, FIRST SALES ','2021-12-07','2021-12-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-07 10:35:36','610','2021-12-07 10:35:55',10,0),('1','177',244383,'DAILY SALES SHIFT SECOND SALES','2021-12-07','2021-12-07 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-07 19:56:16','610','2021-12-07 20:02:07',10,0),('1','177',244495,'DAILY SALES SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-08 19:58:42','610','2021-12-08 19:59:48',10,0),('1','177',244731,'DAILY SALES SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-09 19:15:27','610','2021-12-09 19:15:57',10,0),('1','177',244953,'DAILY SALES SHIFT, FIRST SALES ','2021-12-10','2021-12-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-10 11:57:48','610','2021-12-10 11:58:49',10,0),('1','177',245087,'DAILY SALES SHIFT SECOND SALES','2021-12-10','2021-12-10 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-10 19:34:41','610','2021-12-10 19:35:10',10,0),('1','177',245194,'DAILY SALES SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-11 19:29:20','610','2021-12-11 19:32:14',10,0),('1','177',245420,'DAILY SALES SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-12 19:24:21','610','2021-12-12 19:24:46',10,0),('1','177',245663,'DAILY SALES SHIFT, FIRST SALES ','2021-12-13','2021-12-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-13 15:58:27','610','2021-12-13 15:59:09',10,0),('1','177',245858,'DAILY SALES SHIFT SECOND SALES','2021-12-13','2021-12-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-13 19:19:10','610','2021-12-13 19:19:30',10,0),('1','177',245890,'OPERATIONAL LOSS','2021-12-13','2021-12-13 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-13 19:34:59','610','2021-12-13 19:35:16',10,0),('1','177',245921,'DAILY SALES SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-14 19:54:01','610','2021-12-14 19:54:51',10,0),('1','177',246168,'DAILY SALES SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-15 20:00:15','610','2021-12-15 20:00:48',10,0),('1','177',246437,'DAILY SALES SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-16 19:22:36','610','2021-12-16 19:23:09',10,0),('1','177',246686,'DAILY SALES SHIFT, FIRST SALES ','2021-12-17','2021-12-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-17 08:19:30','610','2021-12-17 08:19:57',10,0),('1','177',246761,'DAILY SALES SHIFT SECOND SALES','2021-12-17','2021-12-17 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-17 19:24:05','610','2021-12-17 19:24:58',10,0),('1','177',246917,'DAILY SALES SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-18 19:19:52','610','2021-12-18 19:20:48',10,0),('1','177',247152,'DAILY SALES SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-19 19:04:31','610','2021-12-19 19:05:15',10,0),('1','177',247380,'DAILY SALES SHIFT  FIRST SALES','2021-12-20','2021-12-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-20 07:48:04','610','2021-12-20 07:48:37',10,0),('1','177',247454,'DAILY SALES SHIFT SECOND SALES','2021-12-20','2021-12-20 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-20 19:07:16','610','2021-12-20 19:07:47',10,0),('1','177',247651,'DAILY SALES SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-21 10:46:18','610','2021-12-21 10:46:41',10,0),('1','177',247751,'DAILY SALES SHIFT SECOND SALES PRICE CHANGE TO 592','2021-12-21','2021-12-21 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-21 19:39:01','610','2021-12-21 19:39:42',10,0),('1','177',247886,'DAILY SALES SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-22 18:59:36','610','2021-12-22 19:00:13',10,0),('1','177',248136,'DAILY SALES SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-23 19:18:27','610','2021-12-23 19:19:41',10,0),('1','177',248391,'DAILY SALES SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-24 19:32:19','610','2021-12-24 19:33:00',10,0),('1','177',248624,'DAILY SALES SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-25 12:27:28','610','2021-12-25 12:27:54',10,0),('1','177',248741,'DAILY SALES SHIFT SECOND SALES','2021-12-25','2021-12-25 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-25 18:59:27','610','2021-12-25 18:59:53',10,0),('1','177',248896,'DAILY SALES','2021-12-26','2021-12-26 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-26 19:08:33','610','2021-12-26 19:09:10',10,0),('1','177',249094,'DAILY SALES SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-27 19:03:19','610','2021-12-27 19:07:10',10,0),('1','177',249331,'DAILY SALES SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-28 19:10:09','610','2021-12-28 19:10:41',10,0),('1','177',249575,'DAILY SALES SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-29 16:09:23','610','2021-12-29 16:09:44',10,0),('1','177',249772,'DAILY SALES SHIFT SECOND SALES','2021-12-29','2021-12-29 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-29 19:04:36','610','2021-12-29 19:05:02',10,0),('1','177',249839,'DAILY SALES SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-30 19:01:07','610','2021-12-30 19:01:45',10,0),('1','177',250087,'DAILY SALES SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'610',0.00,0.00,'610','2021-12-31 19:13:43','610','2021-12-31 19:14:15',10,0),('1','177',250324,'DAILY SALES SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-01 19:52:32','610','2022-01-01 19:53:02',10,0),('1','177',250555,'DAILY SALES SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-02 13:19:18','610','2022-01-02 13:19:50',10,0),('1','177',250680,'DAILY SALES SHIFT SECOND SALES','2022-01-02','2022-01-02 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-02 19:02:22','610','2022-01-02 19:02:47',10,0),('1','177',250789,'DAILY SALES SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-03 19:03:41','610','2022-01-03 19:04:08',10,0),('1','177',251003,'DAILY SALES SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-04 19:20:37','610','2022-01-04 19:21:00',10,0),('1','177',251264,'DAILY SALES SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-05 20:29:36','610','2022-01-05 20:29:58',10,0),('1','177',251499,'DAILY SALES SHIFT, FIRST SALES ','2022-01-06','2022-01-06 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-06 08:28:45','610','2022-01-06 08:29:17',10,0),('1','177',251559,'DAILY SALES SHIFT SECOND SALES','2022-01-06','2022-01-06 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-06 20:11:28','610','2022-01-06 20:12:16',10,0),('1','177',251748,'DAILY SALES SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-07 19:59:35','610','2022-01-07 20:00:53',10,0),('1','177',251977,'DAILY SALES SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-08 20:14:34','610','2022-01-08 20:15:49',10,0),('1','177',252225,'DAILY SALES SHIFT NEW PRODUCTS ','2022-01-09','2022-01-09 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-09 20:11:37','610','2022-01-09 20:12:40',10,0),('1','177',252457,'DAILY SALES SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-10 20:26:48','610','2022-01-10 20:27:22',10,0),('1','177',252700,'DAILY SALES SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-11 20:25:57','610','2022-01-11 20:27:19',10,0),('1','177',252957,'DAILY SALES SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-12 15:12:45','610','2022-01-12 15:13:56',10,0),('1','177',253116,'DAILY SALES SHIFT SECOND SALES','2022-01-12','2022-01-12 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-12 20:29:36','610','2022-01-12 20:36:43',10,0),('1','177',253202,'DAILY SALES SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-13 20:29:01','610','2022-01-13 20:30:10',10,0),('1','177',253461,'DAILY SALES SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-14 20:22:16','610','2022-01-14 20:25:25',10,0),('1','177',253704,'DAILY SALES SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-15 20:35:02','610','2022-01-15 20:36:15',10,0),('1','177',253940,'Operational loss','2022-01-16','2022-01-16 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-16 05:39:36','610','2022-01-16 05:40:03',10,0),('1','177',253942,'DAILY SALES SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-16 20:09:46','610','2022-01-16 20:11:10',10,0),('1','177',254180,'DAILY SALES SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-17 20:42:41','610','2022-01-17 20:44:32',10,0),('1','177',254429,'DAILY SALES SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-18 20:17:48','610','2022-01-18 20:18:40',10,0),('1','177',254687,'DAILY SALES SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-19 20:23:44','610','2022-01-19 20:24:29',10,0),('1','177',254928,'DAILY SALES SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-20 15:50:27','610','2022-01-20 15:51:20',10,0),('1','177',255111,'DAILY SALES SHIFT SECOND SALES','2022-01-20','2022-01-20 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-20 20:29:13','610','2022-01-20 20:30:27',10,0),('1','177',255175,'DAILY SALES SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-21 20:25:38','610','2022-01-22 06:45:25',10,0),('1','177',255452,'DAILY SALES SHIFT, FIRST SALES ','2022-01-22','2022-01-22 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-22 18:09:30','610','2022-01-22 18:13:09',10,0),('1','177',255644,'DAILY SALES SHIFT, SECOND SALES','2022-01-22','2022-01-22 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-22 20:28:49','610','2022-01-22 20:30:03',10,0),('1','177',255702,'DAILY SALES SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-23 20:20:33','610','2022-01-23 20:21:25',10,0),('1','177',255928,'DAILY SALES SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-25 06:25:11','610','2022-01-25 06:26:12',10,0),('1','177',256208,'DAILY SHIFT FIRST SALES','2022-01-25','2022-01-25 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-25 09:07:53','610','2022-01-25 09:10:08',10,0),('1','177',256264,'DAILY SALES SHIFT SECOND SALES','2022-01-25','2022-01-25 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-25 20:40:42','610','2022-01-25 20:41:57',10,0),('1','177',256471,'DAILY SALES SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-26 20:18:58','610','2022-01-26 20:23:01',10,0),('1','177',256705,'DAILY SALES SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-27 20:24:27','610','2022-01-27 20:24:57',10,0),('1','177',256949,'DAILY SALES SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-28 17:50:55','610','2022-01-28 17:52:05',10,0),('1','177',257167,'DAILY SALES SHIFT, SECOND SALES','2022-01-28','2022-01-28 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-29 05:33:01','610','2022-01-29 05:33:22',10,0),('1','177',257221,'DAILY SALES SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-30 05:00:04','610','2022-01-30 05:00:52',10,0),('1','177',257472,'DAILY SALES SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-31 09:12:26','610','2022-01-31 09:12:57',10,0),('1','177',257473,'DAILY SALES SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-31 21:40:08','610','2022-01-31 21:40:24',10,0),('1','177',257474,'DAILY SALES SHIFT SECOND SALES','2022-01-31','2022-01-31 00:00:00',NULL,'610',0.00,0.00,'610','2022-01-31 21:55:00','610','2022-01-31 21:55:16',10,0),('1','177',257475,'DAILY SALES SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-01 20:47:06','610','2022-02-01 20:47:20',10,0),('1','177',257476,'DAILY SALES SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-02 20:15:55','610','2022-02-02 20:16:12',10,0),('1','177',257477,'DAILY SALES SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-03 20:37:59','610','2022-02-03 20:38:23',10,0),('1','177',257478,'DAILY SALES SHIFT SECOND SALES','2022-02-03','2022-02-03 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-03 20:44:37','610','2022-02-03 20:45:03',10,0),('1','177',257479,'DAILY SALES SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-04 20:43:51','610','2022-02-04 20:44:23',10,0),('1','177',257480,'DAILY SALES SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-05 19:59:04','610','2022-02-05 19:59:33',10,0),('1','177',257481,'DAILY SALES SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-06 14:24:30','610','2022-02-06 14:26:23',10,0),('1','177',257482,'DAILY SALES SHIFT OVERAGE','2022-02-06','2022-02-06 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-06 14:27:43','610','2022-02-06 14:27:56',10,0),('1','177',257483,'DAILY SALES SHIFT SECOND SALES','2022-02-06','2022-02-06 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-06 20:05:09','610','2022-02-06 20:05:22',10,0),('1','177',257484,'DAILY SALES SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-07 20:07:55','610','2022-02-07 20:08:18',10,0),('1','177',257485,'DAILY SALES SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-08 20:21:32','610','2022-02-08 20:21:59',10,0),('1','177',257486,'DAILY SALES SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-09 18:14:07','610','2022-02-09 18:14:20',10,0),('1','177',257487,'DAILY SALES SHIFT SECOND SALES','2022-02-09','2022-02-09 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-09 20:42:12','610','2022-02-09 20:42:33',10,0),('1','177',257488,'DAILY SALES SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-10 20:38:31','610','2022-02-10 20:39:06',10,0),('1','177',257489,'DAILY SALES SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-11 20:26:20','610','2022-02-11 20:26:35',10,0),('1','177',257490,'DAILY SALES SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-12 19:32:28','610','2022-02-12 19:32:48',10,0),('1','177',257491,'DAILY SALES SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-14 06:21:30','610','2022-02-14 06:22:38',10,0),('1','177',257492,'DAILY SALES SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-14 20:30:17','610','2022-02-14 20:30:37',10,0),('1','177',257493,'DAILY SALES SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-15 11:46:26','610','2022-02-15 11:46:46',10,0),('1','177',257494,'DAILY SALES SHIFT SECOND SALES','2022-02-15','2022-02-15 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-15 20:29:01','610','2022-02-15 20:29:23',10,0),('1','177',257495,'DAILY SALES SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-16 19:56:33','610','2022-02-16 19:56:57',10,0),('1','177',257496,'DAILY SALES SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-17 20:02:35','610','2022-02-17 20:02:56',10,0),('1','177',257497,'DAILY SALES SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-18 15:05:17','610','2022-02-18 15:05:32',10,0),('1','177',257498,'DAILY SALES SHIFT SECOND SALES','2022-02-18','2022-02-18 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-18 21:13:18','610','2022-02-18 21:13:38',10,0),('1','177',257499,'DAILY SALES SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-19 20:35:59','610','2022-02-19 20:36:21',10,0),('1','177',257500,'DAILY SALES SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-20 19:59:36','610','2022-02-20 19:59:56',10,0),('1','177',257501,'DAILY SALES SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-21 14:26:48','610','2022-02-21 14:27:05',10,0),('1','177',257502,'DAILY SALES SHIFT SECOND SALES','2022-02-21','2022-02-21 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-21 20:16:55','610','2022-02-21 20:17:14',10,0),('1','177',257503,'DAILY SALES SHIFT','2022-02-22','2022-02-22 00:00:00',NULL,'610',0.00,0.00,'610','2022-02-22 20:15:57','610','2022-02-22 20:16:15',10,0),('1','177',257504,'DAILY SALES SHIFT','2022-02-23','2022-02-23 05:40:59','2022-02-24 05:40:59','610',0.00,0.00,'610','2022-02-23 20:04:58','610','2022-02-23 20:05:16',10,0),('1','177',257505,'DAILY SALES SHIFT','2022-02-24','2022-02-24 06:21:54','2022-02-25 06:21:54','610',0.00,0.00,'610','2022-02-24 13:07:10','610','2022-02-24 13:07:23',10,0),('1','177',257506,'OPERATIONAL LOSS','2022-02-24','2022-02-24 13:07:46','2022-02-25 13:07:46','610',0.00,0.00,'610','2022-02-24 13:10:26','610','2022-02-24 13:10:41',10,0),('1','177',257507,'DAILY SALES SHIFT SECOND SALES','2022-02-24','2022-02-24 13:12:29','2022-02-25 13:12:29','610',0.00,0.00,'610','2022-02-24 19:41:52','610','2022-02-24 19:42:20',10,0),('1','177',257508,'DAILY SALES SHIFT','2022-02-25','2022-02-25 06:13:34','2022-02-26 06:13:34','610',0.00,0.00,'610','2022-02-25 20:15:04','610','2022-02-25 20:15:33',10,0),('1','177',257509,'DAILY SALES SHIFT','2022-02-26','2022-02-26 05:35:41','2022-02-27 05:35:41','610',0.00,0.00,'610','2022-02-26 20:13:22','610','2022-02-26 20:14:03',10,0),('1','177',257510,'DAILY SALES SHIFT','2022-02-27','2022-02-27 05:37:41','2022-02-28 05:37:41','610',0.00,0.00,'610','2022-02-27 18:15:48','610','2022-02-27 18:16:05',10,0),('1','177',257511,'DAILY SALES SHIFT, SECOND SALES','2022-02-27','2022-02-27 18:18:10','2022-02-28 18:18:10','610',0.00,0.00,'610','2022-02-27 20:07:03','610','2022-02-27 20:07:37',10,0),('1','177',257512,'DAILY SALES SHIFT','2022-02-28','2022-02-28 06:18:46','2022-03-01 06:18:46','610',0.00,0.00,'610','2022-02-28 20:25:21','610','2022-02-28 20:25:45',10,0),('1','177',257513,'DAILY SALES SHIFT','2022-03-01','2022-03-01 05:44:37','2022-03-02 05:44:37','610',0.00,0.00,'610','2022-03-01 20:19:50','610','2022-03-01 20:20:10',10,0),('1','177',257514,'DAILY SALES SHIFT','2022-03-02','2022-03-02 05:48:14','2022-03-03 05:48:14','610',0.00,0.00,'610','2022-03-02 15:36:29','610','2022-03-02 15:36:48',10,0),('1','177',257515,'DAILY SALES SHIFT SECOND SALES','2022-03-02','2022-03-02 15:37:03','2022-03-03 15:37:03','610',0.00,0.00,'610','2022-03-02 20:05:06','610','2022-03-02 20:05:28',10,0),('1','177',257516,'DAILY SALES SHIFT','2022-03-03','2022-03-03 06:06:40','2022-03-04 06:06:40','610',0.00,0.00,'610','2022-03-03 20:28:48','610','2022-03-03 20:29:09',10,0),('1','177',257517,'DAILY SALES SHIFT','2022-03-04','2022-03-04 06:35:55','2022-03-05 06:35:55','610',0.00,0.00,'610','2022-03-04 20:44:00','610','2022-03-04 20:44:25',10,0),('1','177',257518,'DAILY SALES SHIFT','2022-03-05','2022-03-05 06:30:45','2022-03-06 06:30:45','610',0.00,0.00,'610','2022-03-05 17:21:17','610','2022-03-05 17:21:32',10,0),('1','177',257519,'DAILY SALES SHIFT SECOND SALES','2022-03-05','2022-03-05 17:23:04','2022-03-06 17:23:04','610',0.00,0.00,'610','2022-03-05 20:12:43','610','2022-03-05 20:12:57',10,0),('1','177',257520,'DAILY SALES SHIFT','2022-03-06','2022-03-06 05:34:43','2022-03-07 05:34:43','610',0.00,0.00,'610','2022-03-06 20:45:09','610','2022-03-06 20:45:45',10,0),('1','177',257521,'DAILY SALES SHIFT','2022-03-07','2022-03-07 06:11:13','2022-03-08 06:11:13','610',0.00,0.00,'610','2022-03-07 20:20:12','610','2022-03-07 20:20:35',10,0),('1','177',257522,'DAILY SALES SHIFT','2022-03-08','2022-03-08 06:17:14','2022-03-09 06:17:14','610',0.00,0.00,'610','2022-03-08 17:24:39','610','2022-03-08 17:24:54',10,0),('1','177',257523,'DAILY SALES SHIFT SECOND SALES','2022-03-08','2022-03-08 17:25:10','2022-03-09 17:25:10','610',0.00,0.00,'610','2022-03-09 00:08:27','610','2022-03-09 00:08:43',10,0),('1','177',257524,'DAILY SALES SHIFT','2022-03-09','2022-03-09 06:12:42','2022-03-10 06:12:42','610',0.00,0.00,'610','2022-03-09 21:10:10','610','2022-03-09 21:10:27',10,0),('1','177',257525,'DAILY SALES SHIFT','2022-03-10','2022-03-10 06:25:10','2022-03-11 06:25:10','610',0.00,0.00,'610','2022-03-10 20:01:41','610','2022-03-10 20:02:04',10,0),('1','177',257526,'DAILY SALES SHIFT','2022-03-11','2022-03-11 06:07:54','2022-03-12 06:07:54','610',0.00,0.00,'610','2022-03-11 16:08:39','610','2022-03-11 16:08:52',10,0),('1','177',257527,'DAILY SALES SHIFT, SECOND SALES','2022-03-11','2022-03-11 16:10:49','2022-03-12 16:10:49','610',0.00,0.00,'610','2022-03-11 20:14:39','610','2022-03-11 20:15:32',10,0),('1','177',257528,'DAILY SALES SHIFT','2022-03-12','2022-03-12 06:29:50','2022-03-13 06:29:50','610',0.00,0.00,'610','2022-03-12 20:00:33','610','2022-03-12 20:00:57',10,0),('1','177',257529,'DAILY SALES SHIFT','2022-03-13','2022-03-13 05:46:44','2022-03-14 05:46:44','610',0.00,0.00,'610','2022-03-13 20:22:04','610','2022-03-13 20:22:30',10,0),('1','177',257530,'DAILY SALES SHIFT','2022-03-14','2022-03-14 05:57:38','2022-03-15 05:57:38','610',0.00,0.00,'610','2022-03-14 16:29:41','610','2022-03-14 16:29:59',10,0),('1','177',257531,'DAILY SALES SHIFT, SECOND SALES','2022-03-14','2022-03-14 16:30:38','2022-03-15 16:30:38','610',0.00,0.00,'610','2022-03-14 19:53:46','610','2022-03-14 19:54:07',10,0),('1','177',257532,'DAILY SALES SHIFT','2022-03-15','2022-03-15 05:54:09','2022-03-16 05:54:09','610',0.00,0.00,'610','2022-03-15 22:45:10','610','2022-03-15 22:45:27',10,0),('1','177',257533,'DAILY SALES SHIFT','2022-03-16','2022-03-16 05:43:58','2022-03-17 05:43:58','610',0.00,0.00,'610','2022-03-16 19:55:16','610','2022-03-16 19:55:37',10,0),('1','177',257534,'DAILY SALES SHIFT','2022-03-17','2022-03-17 06:08:42','2022-03-18 06:08:42','610',0.00,0.00,'610','2022-03-17 19:02:26','610','2022-03-17 19:02:52',10,0),('1','177',257535,'DAILY SALES SHIFT SECOND SALES','2022-03-17','2022-03-17 19:24:30','2022-03-18 19:24:30','610',0.00,0.00,'610','2022-03-17 21:21:48','610','2022-03-17 21:22:06',10,0),('1','177',257536,'DAILY SALES SHIFT','2022-03-18','2022-03-18 06:01:12','2022-03-19 06:01:12','610',0.00,0.00,'610','2022-03-18 20:55:14','610','2022-03-18 20:55:34',10,0),('1','177',257537,'DAILY SALES SHIFT','2022-03-19','2022-03-19 05:41:02','2022-03-20 05:41:02','610',0.00,0.00,'610','2022-03-19 21:21:22','610','2022-03-19 21:21:43',10,0),('1','177',257538,'DAILY SALES SHIFT','2022-03-20','2022-03-20 05:50:09','2022-03-21 05:50:09','610',0.00,0.00,'610','2022-03-20 15:20:40','610','2022-03-20 15:20:55',10,0),('1','177',257539,'DAILY SALES SHIFT SECOND SALES','2022-03-20','2022-03-20 15:26:41','2022-03-21 15:26:41','610',0.00,0.00,'610','2022-03-20 19:52:33','610','2022-03-20 19:52:53',10,0),('1','177',257540,'DAILY SALES SHIFT','2022-03-21','2022-03-21 05:30:22','2022-03-22 05:30:22','610',0.00,0.00,'610','2022-03-21 20:29:37','610','2022-03-21 20:29:59',10,0),('1','177',257541,'DAILY SALES SHIFT','2022-03-22','2022-03-22 05:45:26','2022-03-23 05:45:26','610',0.00,0.00,'610','2022-03-22 20:39:20','610','2022-03-22 20:40:52',10,0),('1','177',257542,'DAILY SALES SHIFT','2022-03-23','2022-03-23 05:44:47','2022-03-24 05:44:47','610',0.00,0.00,'610','2022-03-23 18:47:49','610','2022-03-23 18:48:13',10,0),('1','177',257543,'DAILY SALES SHIFT','2022-03-24','2022-03-24 05:42:46','2022-03-25 05:42:46','610',0.00,0.00,'610','2022-03-24 20:33:01','610','2022-03-24 20:33:22',10,0),('1','177',257544,'DAILY SALES SHIFT','2022-03-25','2022-03-25 05:49:19','2022-03-26 05:49:19','610',0.00,0.00,'610','2022-03-25 20:26:54','610','2022-03-25 20:27:28',10,0),('1','177',257545,'DAILY SALES SHIFT','2022-03-26','2022-03-26 05:46:59','2022-03-27 05:46:59','610',0.00,0.00,'610','2022-03-26 15:10:47','610','2022-03-26 15:11:05',10,0),('1','177',257546,'DAILY SALES SHIFT SECOND SALES','2022-03-26','2022-03-26 15:14:16','2022-03-27 15:14:16','610',0.00,0.00,'610','2022-03-26 20:35:58','610','2022-03-26 20:36:20',10,0),('1','177',257547,'DAILY SALES SHIFT','2022-03-27','2022-03-27 05:59:20','2022-03-28 05:59:20','610',0.00,0.00,'610','2022-03-27 10:41:54','610','2022-03-27 10:42:10',10,0),('1','177',257548,'DAILY SALES SHIFT NEW PRICE 688/KG','2022-03-27','2022-03-27 10:42:39','2022-03-28 10:42:39','610',0.00,0.00,'610','2022-03-27 20:50:51','610','2022-03-27 20:51:19',10,0),('1','177',257549,'DAILY SALES SHIFT','2022-03-28','2022-03-28 05:59:02','2022-03-29 05:59:02','610',0.00,0.00,'610','2022-03-28 20:08:31','610','2022-03-28 20:08:56',10,0),('1','177',257550,'DAILY SALES SHIFT','2022-03-29','2022-03-29 06:16:04','2022-03-30 06:16:04','610',0.00,0.00,'610','2022-03-29 22:33:25','610','2022-03-29 22:33:43',10,0),('1','177',257551,'DAILY SALES SHIFT','2022-03-30','2022-03-30 05:58:42','2022-03-31 05:58:42','610',0.00,0.00,'610','2022-03-30 21:03:17','610','2022-03-30 21:03:49',10,0),('1','177',257552,'DAILY SALES SHIFT','2022-03-31','2022-03-31 06:14:18','2022-04-01 06:14:18','610',0.00,0.00,'610','2022-03-31 20:15:24','610','2022-03-31 20:15:39',10,0),('1','177',257553,'DAILY SALES SHIFT','2022-04-01','2022-04-01 06:02:12','2022-04-02 06:02:12','610',0.00,0.00,'610','2022-04-01 18:02:04','610','2022-04-01 18:02:23',10,0),('1','177',257554,'DAILY SALES SHIFT SECOND SALES','2022-04-01','2022-04-01 18:02:44','2022-04-02 18:02:44','610',0.00,0.00,'610','2022-04-01 20:16:38','610','2022-04-01 20:17:00',10,0),('1','177',257555,'DAILY SALES SHIFT','2022-04-02','2022-04-02 06:00:15','2022-04-03 06:00:15','610',0.00,0.00,'610','2022-04-02 19:45:52','610','2022-04-02 19:46:56',10,0),('1','177',257556,'DAILY SALES SHIFT','2022-04-03','2022-04-03 05:53:13','2022-04-04 05:53:13','610',0.00,0.00,'610','2022-04-03 19:39:52','610','2022-04-03 19:40:14',10,0),('1','177',257557,'DAILY SALES SHIFT','2022-04-04','2022-04-04 05:44:26','2022-04-05 05:44:26','610',0.00,0.00,'610','2022-04-04 10:41:48','610','2022-04-04 10:42:14',10,0),('1','177',257558,'DAILY SALES SHIFT SECOND SALES','2022-04-04','2022-04-04 10:42:46','2022-04-05 10:42:46','610',0.00,0.00,'610','2022-04-04 19:45:18','610','2022-04-04 19:45:38',10,0),('1','177',257559,'DAILY SALES SHIFT','2022-04-05','2022-04-05 05:57:48','2022-04-06 05:57:48','610',0.00,0.00,'610','2022-04-05 19:45:49','610','2022-04-05 19:46:12',10,0),('1','177',257560,'DAILY SALES SHIFT','2022-04-06','2022-04-06 05:47:32','2022-04-07 05:47:32','610',0.00,0.00,'610','2022-04-06 20:02:41','610','2022-04-06 20:03:01',10,0),('1','177',257561,'DAILY SALES SHIFT','2022-04-07','2022-04-07 05:41:35','2022-04-08 05:41:35','610',0.00,0.00,'610','2022-04-07 12:54:04','610','2022-04-07 12:55:22',10,0),('1','177',257562,'DAILY SALES SHIFT SECOND SALES','2022-04-07','2022-04-07 13:00:37','2022-04-08 13:00:37','610',0.00,0.00,'610','2022-04-07 20:05:18','610','2022-04-07 20:05:37',10,0),('1','177',257563,'DAILY SALES SHIFT','2022-04-08','2022-04-08 05:44:24','2022-04-09 05:44:24','610',0.00,0.00,'610','2022-04-08 20:03:48','610','2022-04-08 20:04:30',10,0),('1','177',257564,'DAILY SALES SHIFT','2022-04-09','2022-04-09 05:45:16','2022-04-10 05:45:16','610',0.00,0.00,'610','2022-04-09 19:53:47','610','2022-04-09 19:54:21',10,0),('1','177',257565,'DAILY SALES SHIFT, SECOND SALES','2022-04-10','2022-04-10 06:17:29','2022-04-11 06:17:29','610',0.00,0.00,'610','2022-04-10 06:19:23','610','2022-04-10 06:19:39',10,0),('1','177',257566,'DAILY SALES SHIFT SECOND SALES','2022-04-10','2022-04-10 06:53:49','2022-04-11 06:53:49','610',0.00,0.00,'610','2022-04-10 20:06:37','610','2022-04-10 20:07:00',10,0),('1','177',257567,'DAILY SALES SHIFT','2022-04-11','2022-04-11 05:56:18','2022-04-12 05:56:18','610',0.00,0.00,'610','2022-04-11 20:26:48','610','2022-04-11 20:27:08',10,0),('1','177',257568,'DAILY SALES SHIFT','2022-04-12','2022-04-12 05:49:04','2022-04-13 05:49:04','610',0.00,0.00,'610','2022-04-12 17:46:14','610','2022-04-12 17:46:33',10,0),('1','177',257569,'DAILY SALES SHIFT','2022-04-13','2022-04-13 07:39:52','2022-04-14 07:39:52','610',0.00,0.00,'610','2022-04-13 21:01:38','610','2022-04-13 21:02:00',10,0),('1','177',257570,'DAILY SALES SHIFT47013','2022-04-14','2022-04-14 06:25:46','2022-04-15 06:25:46','610',0.00,0.00,'610','2022-04-14 21:19:11','610','2022-04-14 21:19:30',10,0),('1','177',257571,'DAILY SALES SHIFT','2022-04-15','2022-04-15 06:34:11','2022-04-16 06:34:11','610',0.00,0.00,'610','2022-04-15 15:16:06','610','2022-04-15 15:16:24',10,0),('1','177',257572,'DAILY SALES SHIFT SECOND SALES','2022-04-15','2022-04-15 16:55:07','2022-04-16 16:55:07','610',0.00,0.00,'610','2022-04-15 21:06:24','610','2022-04-15 21:06:43',10,0),('1','177',257573,'DAILY SALES SHIFT','2022-04-16','2022-04-16 06:03:36','2022-04-17 06:03:36','610',0.00,0.00,'610','2022-04-16 20:03:32','610','2022-04-16 20:03:50',10,0),('1','177',257574,'DAILY SALES SHIFT','2022-04-17','2022-04-17 06:17:16','2022-04-18 06:17:16','610',0.00,0.00,'610','2022-04-17 20:41:29','610','2022-04-17 20:42:35',10,0),('1','177',257575,'DAILY SALES SHIFT','2022-04-18','2022-04-18 05:47:34','2022-04-19 05:47:34','610',0.00,0.00,'610','2022-04-18 12:37:36','610','2022-04-18 12:37:55',10,0),('1','177',257576,'DAILY SALES SHIFT SECOND SALES','2022-04-18','2022-04-18 13:28:40','2022-04-19 13:28:40','610',0.00,0.00,'610','2022-04-19 07:06:00','610','2022-04-19 07:06:19',10,0),('1','177',257577,'DAILY SALES SHIFT','2022-04-19','2022-04-19 07:06:54','2022-04-20 07:06:54','610',0.00,0.00,'610','2022-04-19 20:06:42','610','2022-04-19 20:07:02',10,0),('1','177',257578,'DAILY SALES SHIFT','2022-04-20','2022-04-20 05:52:13','2022-04-21 05:52:13','610',0.00,0.00,'610','2022-04-20 20:10:16','610','2022-04-20 20:10:34',10,0),('1','177',257579,'DAILY SALES SHIFT','2022-04-21','2022-04-21 05:29:56','2022-04-22 05:29:56','610',0.00,0.00,'610','2022-04-21 20:31:11','610','2022-04-21 20:31:28',10,0),('1','177',257580,'DAILY SALES SHIFT','2022-04-22','2022-04-22 05:45:08','2022-04-23 05:45:08','610',0.00,0.00,'610','2022-04-22 20:27:13','610','2022-04-22 20:27:28',10,0),('1','177',257581,'DAILY SALES SHIFT','2022-04-23','2022-04-23 04:27:24','2022-04-24 04:27:24','610',0.00,0.00,'610','2022-04-23 17:28:38','610','2022-04-23 17:28:54',10,0),('1','177',257582,'DAILY SALES SHIFT SECOND SALES','2022-04-23','2022-04-23 17:30:39','2022-04-24 17:30:39','610',0.00,0.00,'610','2022-04-23 20:16:00','610','2022-04-23 20:16:24',10,0),('1','177',257583,'DAILY SALES SHIFT','2022-04-24','2022-04-24 07:14:11','2022-04-25 07:14:11','610',0.00,0.00,'610','2022-04-24 19:57:37','610','2022-04-24 19:57:55',10,0),('1','177',257584,'DAILY SALES SHIFT','2022-04-25','2022-04-25 05:36:28','2022-04-26 05:36:28','610',0.00,0.00,'610','2022-04-25 20:21:24','610','2022-04-25 20:21:42',10,0),('1','177',257585,'DAILY SALES SHIFT','2022-04-26','2022-04-26 05:40:59','2022-04-27 05:40:59','610',0.00,0.00,'610','2022-04-26 10:42:04','610','2022-04-26 10:42:17',10,0),('1','177',257586,'DAILY SALES SHIFT SECOND SALES','2022-04-26','2022-04-26 10:44:48','2022-04-27 10:44:48','610',0.00,0.00,'610','2022-04-26 21:15:24','610','2022-04-26 21:16:13',10,0),('1','177',257587,'DAILY SALES SHIFT','2022-04-27','2022-04-27 07:29:54','2022-04-28 07:29:54','610',0.00,0.00,'610','2022-04-28 06:04:00','610','2022-04-28 06:04:16',10,0),('1','177',257588,'DAILY SALES SHIFT','2022-04-28','2022-04-28 06:04:36','2022-04-29 06:04:36','610',0.00,0.00,'610','2022-04-28 21:18:38','610','2022-04-28 21:19:01',10,0),('1','177',257589,'DAILY SALES','2022-04-29','2022-04-29 05:40:52','2022-04-30 05:40:52','610',0.00,0.00,'610','2022-04-29 10:19:58','610','2022-04-29 10:20:14',10,0),('1','177',257590,'DAILY SALES SHIFT SECOND SALES','2022-04-29','2022-04-29 10:22:38','2022-04-30 10:22:38','610',0.00,0.00,'610','2022-04-29 20:58:07','610','2022-04-29 20:58:23',10,0),('1','177',257591,'DAILY SALES','2022-04-30','2022-04-30 07:17:39','2022-05-01 07:17:39','610',0.00,0.00,'610','2022-04-30 22:09:07','610','2022-04-30 22:09:33',10,0),('1','177',257592,'DAILY SALES','2022-05-01','2022-05-01 07:35:41','2022-05-02 07:35:41','610',0.00,0.00,'610','2022-05-01 20:17:32','610','2022-05-01 20:18:03',10,0),('1','177',257593,'DAILY SALES SHIFT','2022-05-02','2022-05-02 10:00:19','2022-05-03 10:00:19','610',0.00,0.00,'610','2022-05-02 20:18:56','610','2022-05-02 20:19:18',10,0),('1','177',257594,'DAILY SALES','2022-05-03','2022-05-03 06:08:05','2022-05-04 06:08:05','610',0.00,0.00,'610','2022-05-03 20:21:29','610','2022-05-03 20:21:57',10,0),('1','177',257595,'DAILY SALES','2022-05-04','2022-05-04 05:52:47','2022-05-05 05:52:47','610',0.00,0.00,'610','2022-05-04 13:04:53','610','2022-05-04 13:05:19',10,0),('1','177',257596,'DAILY SALES SHIFT SECOND SALES','2022-05-04','2022-05-04 13:19:59','2022-05-05 13:19:59','610',0.00,0.00,'610','2022-05-04 20:27:31','610','2022-05-04 20:27:53',10,0),('1','177',257597,'DAILY SALES','2022-05-05','2022-05-05 06:00:22','2022-05-06 06:00:22','610',0.00,0.00,'610','2022-05-05 22:22:16','610','2022-05-05 22:22:33',10,0),('1','177',257598,'DAILY SALES','2022-05-06','2022-05-06 05:46:36','2022-05-07 05:46:36','610',0.00,0.00,'610','2022-05-06 19:50:13','610','2022-05-06 19:50:37',10,0),('1','177',257599,'DAILY SALES','2022-05-07','2022-05-07 06:35:35','2022-05-08 06:35:35','610',0.00,0.00,'610','2022-05-07 09:26:52','610','2022-05-07 09:27:25',10,0),('1','177',257600,'DAILY  2ND SALES NEW STOCK','2022-05-07','2022-05-07 11:05:53','2022-05-08 11:05:53','610',0.00,0.00,'610','2022-05-07 20:15:43','610','2022-05-07 20:16:01',10,0),('1','177',257601,'DAILY SALES','2022-05-08','2022-05-08 05:35:14','2022-05-09 05:35:14','610',0.00,0.00,'610','2022-05-08 20:09:15','610','2022-05-08 20:09:41',10,0),('1','177',257602,'DAILY SALES','2022-05-09','2022-05-09 05:57:45','2022-05-10 05:57:45','610',0.00,0.00,'610','2022-05-09 20:22:30','610','2022-05-09 20:22:51',10,0),('1','177',257603,'DAILY SALES','2022-05-10','2022-05-10 05:38:18','2022-05-11 05:38:18','610',0.00,0.00,'610','2022-05-10 16:13:59','610','2022-05-10 16:14:19',10,0),('1','177',257604,'DAILY SALES','2022-05-11','2022-05-11 18:19:09','2022-05-12 18:19:09','610',0.00,0.00,'610','2022-05-11 20:34:59','610','2022-05-11 20:35:19',10,0),('1','177',257605,'DAILY SALES SHIFT','2022-05-12','2022-05-12 05:39:04','2022-05-13 05:39:04','610',0.00,0.00,'610','2022-05-12 20:44:40','610','2022-05-12 20:45:20',10,0),('1','177',257606,'DAILY SALES SHIFT','2022-05-13','2022-05-13 05:43:45','2022-05-14 05:43:45','610',0.00,0.00,'610','2022-05-13 21:02:33','610','2022-05-13 21:03:03',10,0),('1','177',257607,'DAILY SALES','2022-05-14','2022-05-14 05:55:17','2022-05-15 05:55:17','610',0.00,0.00,'610','2022-05-14 20:30:47','610','2022-05-14 20:31:04',10,0),('1','177',257608,'DAILY SALES','2022-05-15','2022-05-15 05:45:52','2022-05-16 05:45:52','610',0.00,0.00,'610','2022-05-15 20:15:44','610','2022-05-15 20:16:13',10,0),('1','177',257609,'DAILY SALES','2022-05-16','2022-05-16 06:30:46','2022-05-17 06:30:46','610',0.00,0.00,'610','2022-05-16 12:31:25','610','2022-05-16 12:31:49',10,0),('1','177',257610,'DAILY SALES','2022-05-17','2022-05-17 09:06:34','2022-05-18 09:06:34','610',0.00,0.00,'610','2022-05-17 20:54:13','610','2022-05-17 20:54:39',10,0),('1','177',257611,'DAILY SALES','2022-05-18','2022-05-18 05:45:43','2022-05-19 05:45:43','610',0.00,0.00,'610','2022-05-18 17:37:12','610','2022-05-18 17:37:34',10,0),('1','177',257612,'DAILY  2ND SALES NEW STOCK','2022-05-18','2022-05-18 17:41:39','2022-05-19 17:41:39','610',0.00,0.00,'610','2022-05-18 20:29:20','610','2022-05-18 20:29:39',10,0),('1','177',257613,'DAILY SALES','2022-05-19','2022-05-19 05:48:22','2022-05-20 05:48:22','610',0.00,0.00,'610','2022-05-19 20:44:09','610','2022-05-19 20:44:28',10,0),('1','177',257614,'DAILY SALES','2022-05-20','2022-05-20 05:45:27','2022-05-21 05:45:27','610',0.00,0.00,'610','2022-05-20 12:46:50','610','2022-05-20 12:47:11',10,0),('1','177',257615,'DAILY SALES SHIFT SECOND SALES','2022-05-20','2022-05-20 12:50:05','2022-05-21 12:50:05','610',0.00,0.00,'610','2022-05-20 19:49:46','610','2022-05-20 19:50:07',10,0),('1','177',257616,'DAILY SALES','2022-05-21','2022-05-21 05:52:02','2022-05-22 05:52:02','610',0.00,0.00,'610','2022-05-21 20:45:29','610','2022-05-21 20:46:24',10,0),('1','177',257617,'DAILY SALES','2022-05-22','2022-05-22 05:42:22','2022-05-23 05:42:22','610',0.00,0.00,'610','2022-05-22 20:41:42','610','2022-05-22 20:42:03',10,0),('1','177',257618,'DAILY SALES','2022-05-23','2022-05-23 06:06:03','2022-05-24 06:06:03','610',0.00,0.00,'610','2022-05-23 11:36:41','610','2022-05-23 11:37:03',10,0),('1','177',257619,'DAILY  2ND SALES NEW STOCK','2022-05-23','2022-05-23 11:38:50','2022-05-24 11:38:50','610',0.00,0.00,'610','2022-05-23 20:30:31','610','2022-05-23 20:30:48',10,0),('1','177',257620,'DAILY SALES SHIFT','2022-05-24','2022-05-24 06:17:00','2022-05-25 06:17:00','610',0.00,0.00,'610','2022-05-24 20:28:02','610','2022-05-24 20:28:21',10,0),('1','177',257621,'DAILY SALES SHIFT','2022-05-25','2022-05-25 05:52:58','2022-05-26 05:52:58','610',0.00,0.00,'610','2022-05-25 21:04:34','610','2022-05-25 21:04:58',10,0),('1','177',257622,'DAILY SALES','2022-05-26','2022-05-26 05:45:36','2022-05-27 05:45:36','610',0.00,0.00,'610','2022-05-26 20:42:43','610','2022-05-26 20:43:05',10,0),('1','177',257623,'DAILY SALES','2022-05-27','2022-05-27 05:45:57','2022-05-28 05:45:57','610',0.00,0.00,'610','2022-05-27 21:04:55','610','2022-05-27 21:05:38',10,0),('1','177',257624,'DAILY SALES','2022-05-28','2022-05-28 05:42:27','2022-05-29 05:42:27','610',0.00,0.00,'610','2022-05-28 20:32:12','610','2022-05-28 20:32:37',10,0),('1','177',257625,'DAILY SALES','2022-05-29','2022-05-29 05:48:27','2022-05-30 05:48:27','610',0.00,0.00,'610','2022-05-29 20:26:28','610','2022-05-29 20:26:48',10,0),('1','177',257626,'DAILY SALES','2022-05-30','2022-05-30 05:42:24','2022-05-31 05:42:24','610',0.00,0.00,'610','2022-05-30 11:01:50','610','2022-05-30 11:02:23',10,0),('1','177',257627,'DAILY SALES SHIFT SECOND SALES','2022-05-30','2022-05-30 14:26:33','2022-05-31 14:26:33','610',0.00,0.00,'610','2022-05-30 20:41:28','610','2022-05-30 20:41:55',10,0),('1','177',257628,'DAILY SALES','2022-05-31','2022-05-31 05:46:48','2022-06-01 05:46:48','610',0.00,0.00,'610','2022-05-31 21:10:34','610','2022-05-31 21:11:00',10,0),('1','177',257629,'DAILY SALES','2022-06-01','2022-06-01 05:28:02','2022-06-02 05:28:02','610',0.00,0.00,'610','2022-06-01 16:19:56','610','2022-06-01 16:20:17',10,0),('1','177',257630,'DAILY SALES SHIFT SECOND SALES','2022-06-01','2022-06-01 16:33:29','2022-06-02 16:33:29','610',0.00,0.00,'610','2022-06-01 21:22:06','610','2022-06-01 21:22:26',10,0),('1','177',257631,'DAILY SALES SHIFT','2022-06-02','2022-06-02 05:32:49','2022-06-03 05:32:49','610',0.00,0.00,'610','2022-06-02 20:49:53','610','2022-06-02 20:50:15',10,0),('1','177',257632,'DAILY SALES','2022-06-03','2022-06-03 05:37:51','2022-06-04 05:37:51','610',0.00,0.00,'610','2022-06-03 21:36:38','610','2022-06-03 21:37:11',10,0),('1','177',257633,'DAILY SALES','2022-06-04','2022-06-04 05:51:22','2022-06-05 05:51:22','610',0.00,0.00,'610','2022-06-04 11:15:57','610','2022-06-04 11:16:24',10,0),('1','177',257634,'DAILY SALES SHIFT SECOND SALES','2022-06-04','2022-06-04 17:19:16','2022-06-05 17:19:16','610',0.00,0.00,'610','2022-06-04 21:16:34','610','2022-06-04 21:16:51',10,0),('1','177',257635,'DAILY SALES','2022-06-05','2022-06-05 05:42:16','2022-06-06 05:42:16','610',0.00,0.00,'610','2022-06-05 20:25:12','610','2022-06-05 20:25:31',10,0),('1','177',257636,'DAILY SALES','2022-06-06','2022-06-06 05:28:17','2022-06-07 05:28:17','610',0.00,0.00,'610','2022-06-06 21:19:41','610','2022-06-06 21:20:04',10,0),('1','177',257637,'DAILY SALES','2022-06-07','2022-06-07 05:38:16','2022-06-08 05:38:16','610',0.00,0.00,'610','2022-06-07 21:41:30','610','2022-06-07 21:41:53',10,0),('1','177',257638,'DAILY SALES SHIFT SECOND SALES','2022-06-07','2022-06-07 21:42:22','2022-06-08 21:42:22','610',0.00,0.00,'610','2022-06-07 21:43:46','610','2022-06-07 21:44:08',10,0),('1','177',257639,'DAILY SALES','2022-06-08','2022-06-08 05:46:01','2022-06-09 05:46:01','610',0.00,0.00,'610','2022-06-08 20:51:04','610','2022-06-08 20:51:24',10,0),('1','177',257640,'DAILY SALES','2022-06-09','2022-06-09 05:26:11','2022-06-10 05:26:11','610',0.00,0.00,'610','2022-06-09 14:21:35','610','2022-06-09 14:21:56',10,0),('1','177',257641,'DAILY  2ND SALES NEW STOCK','2022-06-09','2022-06-09 14:22:17','2022-06-10 14:22:17','610',0.00,0.00,'610','2022-06-09 20:25:22','610','2022-06-09 20:26:59',10,0),('1','177',257642,'DAILY SALES','2022-06-10','2022-06-10 05:50:34','2022-06-11 05:50:34','610',0.00,0.00,'610','2022-06-10 21:09:15','610','2022-06-10 21:09:40',10,0),('1','177',257643,'DAILY SALES','2022-06-11','2022-06-11 05:43:11','2022-06-12 05:43:11','610',0.00,0.00,'610','2022-06-11 14:58:02','610','2022-06-11 14:58:20',10,0),('1','177',257644,'DAILY  2ND SALES NEW STOCK','2022-06-11','2022-06-11 14:58:35','2022-06-12 14:58:35','610',0.00,0.00,'610','2022-06-11 21:05:04','610','2022-06-11 21:05:23',10,0),('1','177',257645,'DAILY SALES','2022-06-12','2022-06-12 05:39:58','2022-06-13 05:39:58','610',0.00,0.00,'610','2022-06-12 20:51:20','610','2022-06-12 20:51:39',10,0),('1','177',257646,'DAILY SALES','2022-06-13','2022-06-13 05:43:50','2022-06-14 05:43:50','610',0.00,0.00,'610','2022-06-13 22:00:41','610','2022-06-13 22:01:02',10,0),('1','177',257647,'DAILY SALES SHIFT SECOND SALES','2022-06-13','2022-06-13 22:01:54','2022-06-14 22:01:54','610',0.00,0.00,'610','2022-06-13 22:10:13','610','2022-06-13 22:10:34',10,0),('1','177',257648,'DAILY SALES','2022-06-14','2022-06-14 05:49:09','2022-06-15 05:49:09','610',0.00,0.00,'610','2022-06-14 21:24:25','610','2022-06-14 21:24:46',10,0),('1','177',257649,'DAILY SALES','2022-06-15','2022-06-15 05:46:51','2022-06-16 05:46:51','610',0.00,0.00,'610','2022-06-15 20:04:19','610','2022-06-15 20:04:39',10,0),('1','177',257650,'DAILY SALES SHIFT NEW PRODUCTS ','2022-06-16','2022-06-16 07:56:27','2022-06-17 07:56:27','610',0.00,0.00,'610','2022-06-16 20:47:43','610','2022-06-16 20:48:06',10,0),('1','177',257651,'DAILY  SALES','2022-06-17','2022-06-17 05:54:54','2022-06-18 05:54:54','610',0.00,0.00,'610','2022-06-17 20:57:20','610','2022-06-17 20:58:01',10,0),('1','177',257652,'DAILY  SALES','2022-06-18','2022-06-18 05:51:57','2022-06-19 05:51:57','610',0.00,0.00,'610','2022-06-18 16:46:37','610','2022-06-18 16:46:59',10,0),('1','177',257653,'DAILY SALES OF 18-6-2022 SECOND SALES','2022-06-18','2022-06-18 16:47:55','2022-06-19 16:47:55','610',0.00,0.00,'610','2022-06-18 20:36:57','610','2022-06-18 20:37:21',10,0),('1','177',257654,'DAILY  SALES','2022-06-19','2022-06-19 05:53:57','2022-06-20 05:53:57','610',0.00,0.00,'610','2022-06-19 20:22:31','610','2022-06-19 20:23:25',10,0),('1','177',257655,'DAILY  SALES','2022-06-20','2022-06-20 05:56:12','2022-06-21 05:56:12','610',0.00,0.00,'610','2022-06-20 20:18:21','610','2022-06-20 20:18:40',10,0),('1','177',257656,'DAILY  SALES','2022-06-21','2022-06-21 05:50:13','2022-06-22 05:50:13','610',0.00,0.00,'610','2022-06-21 17:30:45','610','2022-06-21 17:31:22',10,0),('1','177',257657,'DAILY SALES OF 21/6/2022 SECOND SALES','2022-06-21','2022-06-21 18:06:18','2022-06-22 18:06:18','610',0.00,0.00,'610','2022-06-21 20:56:50','610','2022-06-21 20:57:08',10,0),('1','177',257658,'DAILY  SALES','2022-06-22','2022-06-22 06:07:01','2022-06-23 06:07:01','610',0.00,0.00,'610','2022-06-22 20:28:38','610','2022-06-22 20:28:56',10,0),('1','177',257659,'DAILY  SALES','2022-06-23','2022-06-23 06:07:08','2022-06-24 06:07:08','610',0.00,0.00,'610','2022-06-23 21:28:17','610','2022-06-23 21:28:48',10,0),('1','177',257660,'DAILY  SALES','2022-06-24','2022-06-24 05:51:09','2022-06-25 05:51:09','610',0.00,0.00,'610','2022-06-24 16:26:28','610','2022-06-24 16:26:51',10,0),('1','177',257661,'NEW SALES 2ND SHIFT','2022-06-24','2022-06-24 16:28:54','2022-06-25 16:28:54','610',0.00,0.00,'610','2022-06-24 20:00:35','610','2022-06-24 20:01:01',10,0),('1','177',257662,'DAILY  SALES','2022-06-25','2022-06-25 06:01:47','2022-06-26 06:01:47','610',0.00,0.00,'610','2022-06-25 21:30:45','610','2022-06-25 21:31:04',10,0),('1','177',257663,'DAILY  SALES','2022-06-26','2022-06-26 05:49:20','2022-06-27 05:49:20','610',0.00,0.00,'610','2022-06-26 20:08:38','610','2022-06-26 20:08:58',10,0),('1','177',257664,'DAILY  SALES','2022-06-27','2022-06-27 05:49:05','2022-06-28 05:49:05','610',0.00,0.00,'610','2022-06-27 11:28:14','610','2022-06-27 11:28:31',10,0),('1','177',257665,'DAILY SALES SECOND SALES','2022-06-27','2022-06-27 11:31:46','2022-06-28 11:31:46','610',0.00,0.00,'610','2022-06-27 20:10:19','610','2022-06-27 20:10:37',10,0),('1','177',257666,'DAILY  SALES','2022-06-28','2022-06-28 05:56:45','2022-06-29 05:56:45','610',0.00,0.00,'610','2022-06-28 20:04:57','610','2022-06-28 20:05:19',10,0),('1','177',257667,'DAILY  SALES','2022-06-29','2022-06-29 05:46:30','2022-06-30 05:46:30','610',0.00,0.00,'610','2022-06-29 19:46:21','610','2022-06-29 19:46:41',10,0),('1','177',257668,'DAILY SALES SECOND SALES','2022-06-29','2022-06-29 19:48:39','2022-06-30 19:48:39','610',0.00,0.00,'610','2022-06-29 20:41:14','610','2022-06-29 20:41:34',10,0),('1','177',257669,'DAILY  SALES','2022-06-30','2022-06-30 05:52:43','2022-07-01 05:52:43','610',0.00,0.00,'610','2022-06-30 20:06:40','610','2022-06-30 20:07:01',10,0),('1','177',257670,'DAILY  SALES','2022-07-01','2022-07-01 05:39:32','2022-07-02 05:39:32','610',0.00,0.00,'610','2022-07-01 20:43:41','610','2022-07-01 20:44:19',10,0),('1','177',257671,'DAILY  SALES','2022-07-02','2022-07-02 05:57:39','2022-07-03 05:57:39','610',0.00,0.00,'610','2022-07-02 16:48:56','610','2022-07-02 16:49:14',10,0),('1','177',257672,'DAILY SALES SECOND SALES','2022-07-02','2022-07-02 16:53:32','2022-07-03 16:53:32','610',0.00,0.00,'610','2022-07-02 20:32:54','610','2022-07-02 20:33:19',10,0),('1','177',257673,'DAILY  SALES','2022-07-03','2022-07-03 05:56:15','2022-07-04 05:56:15','610',0.00,0.00,'610','2022-07-03 20:42:01','610','2022-07-03 20:42:24',10,0),('1','177',257674,'DAILY  SALES','2022-07-04','2022-07-04 05:52:29','2022-07-05 05:52:29','610',0.00,0.00,'610','2022-07-04 20:25:06','610','2022-07-04 20:25:45',10,0),('1','177',257675,'DAILY  SALES','2022-07-05','2022-07-05 05:55:58','2022-07-06 05:55:58','610',0.00,0.00,'610','2022-07-05 12:37:58','610','2022-07-05 12:38:26',10,0),('1','177',257676,'DAILY SALES SECOND SALES','2022-07-05','2022-07-05 12:40:38','2022-07-06 12:40:38','610',0.00,0.00,'610','2022-07-05 20:24:19','610','2022-07-05 20:24:46',10,0),('1','177',257677,'DAILY  SALES','2022-07-06','2022-07-06 05:36:30','2022-07-07 05:36:30','610',0.00,0.00,'610','2022-07-06 22:15:21','610','2022-07-06 22:15:44',10,0),('1','177',257678,'DAILY  SALES','2022-07-07','2022-07-07 05:43:32','2022-07-08 05:43:32','610',0.00,0.00,'610','2022-07-07 21:56:50','610','2022-07-07 21:57:09',10,0),('1','177',257679,'DAILY  SALES','2022-07-08','2022-07-08 05:42:18','2022-07-09 05:42:18','610',0.00,0.00,'610','2022-07-08 10:14:20','610','2022-07-08 10:14:50',10,0),('1','177',257680,'DAILY SALES.....SECOND SALES SHIFT','2022-07-08','2022-07-08 10:18:21','2022-07-09 10:18:21','610',0.00,0.00,'610','2022-07-08 21:23:40','610','2022-07-08 21:23:56',10,0),('1','177',257681,'DAILY SALES SHIFT','2022-07-09','2022-07-09 08:08:56','2022-07-10 08:08:56','610',0.00,0.00,'610','2022-07-09 20:43:34','610','2022-07-09 20:43:50',10,0),('1','177',257682,'DAILY  SALES','2022-07-10','2022-07-10 05:40:34','2022-07-11 05:40:34','610',0.00,0.00,'610','2022-07-10 20:05:59','610','2022-07-10 20:06:15',10,0),('1','177',257683,'DAILY  SALES','2022-07-11','2022-07-11 05:43:39','2022-07-12 05:43:39','610',0.00,0.00,'610','2022-07-11 08:42:00','610','2022-07-11 08:42:16',10,0),('1','177',257684,'DAILY SALES.....SECOND SALES SHIFT','2022-07-11','2022-07-11 08:44:23','2022-07-12 08:44:23','610',0.00,0.00,'610','2022-07-11 20:55:49','610','2022-07-11 20:56:06',10,0),('1','177',257685,'DAILY  SALES','2022-07-12','2022-07-12 06:00:24','2022-07-13 06:00:24','610',0.00,0.00,'610','2022-07-12 20:21:50','610','2022-07-12 20:22:08',10,0),('1','177',257686,'DAILY  SALES','2022-07-13','2022-07-13 05:19:00','2022-07-14 05:19:00','610',0.00,0.00,'610','2022-07-13 20:04:57','610','2022-07-13 20:05:20',10,0),('1','177',257687,'DAILY  SALES','2022-07-14','2022-07-14 05:58:35','2022-07-15 05:58:35','610',0.00,0.00,'610','2022-07-14 20:20:08','610','2022-07-14 20:20:27',10,0),('1','177',257688,'DAILY  SALES','2022-07-15','2022-07-15 05:36:45','2022-07-16 05:36:45','610',0.00,0.00,'610','2022-07-15 20:24:37','610','2022-07-15 20:24:55',10,0),('1','177',257689,'DAILY  SALES','2022-07-16','2022-07-16 06:14:15','2022-07-17 06:14:15','610',0.00,0.00,'610','2022-07-16 19:26:29','610','2022-07-16 19:26:46',10,0),('1','177',257690,'DAILY SALES.....SECOND SALES SHIFT','2022-07-16','2022-07-16 19:28:29','2022-07-17 19:28:29','610',0.00,0.00,'610','2022-07-16 20:20:48','610','2022-07-16 20:21:05',10,0),('1','177',257691,'DAILY  SALES','2022-07-17','2022-07-17 05:08:01','2022-07-18 05:08:01','610',0.00,0.00,'610','2022-07-17 20:47:10','610','2022-07-17 20:47:26',10,0),('1','177',257692,'DAILY  SALES','2022-07-18','2022-07-18 05:07:39','2022-07-19 05:07:39','610',0.00,0.00,'610','2022-07-18 20:33:30','610','2022-07-18 20:33:52',10,0),('1','177',257693,'DAILY  SALES','2022-07-19','2022-07-19 05:40:09','2022-07-20 05:40:09','610',0.00,0.00,'610','2022-07-19 13:44:45','610','2022-07-19 13:45:00',10,0),('1','177',257694,'DAILY SALES SECOND SALES','2022-07-19','2022-07-19 13:46:51','2022-07-20 13:46:51','610',0.00,0.00,'610','2022-07-19 22:51:18','610','2022-07-19 22:51:40',10,0),('1','177',257695,'DAILY  SALES','2022-07-20','2022-07-20 06:04:53','2022-07-21 06:04:53','610',0.00,0.00,'610','2022-07-20 21:08:00','610','2022-07-20 21:08:16',10,0),('1','177',257696,'DAILY  SALES','2022-07-21','2022-07-21 05:14:40','2022-07-22 05:14:40','610',0.00,0.00,'610','2022-07-21 20:41:31','610','2022-07-21 20:41:47',10,0),('1','177',257697,'DAILY  SALES','2022-07-22','2022-07-22 05:50:05','2022-07-23 05:50:05','610',0.00,0.00,'610','2022-07-22 11:01:39','610','2022-07-22 11:01:57',10,0),('1','177',257698,'DAILY SALES SECOND SALES','2022-07-22','2022-07-22 11:08:46','2022-07-23 11:08:46','610',0.00,0.00,'610','2022-07-22 20:50:36','610','2022-07-22 20:51:11',10,0),('1','177',257699,'DAILY  SALES','2022-07-23','2022-07-23 05:41:30','2022-07-24 05:41:30','610',0.00,0.00,'610','2022-07-23 20:10:47','610','2022-07-23 20:11:15',10,0),('1','177',257700,'DAILY  SALES','2022-07-24','2022-07-24 05:47:17','2022-07-25 05:47:17','610',0.00,0.00,'610','2022-07-24 20:17:54','610','2022-07-24 20:18:22',10,0),('1','177',257701,'DAILY  SALES','2022-07-25','2022-07-25 05:27:30','2022-07-26 05:27:30','610',0.00,0.00,'610','2022-07-25 13:41:44','610','2022-07-25 14:18:02',10,0),('1','177',257702,'DAILY SALES SECOND SALES','2022-07-25','2022-07-25 14:18:51','2022-07-26 14:18:51','610',0.00,0.00,'610','2022-07-25 20:50:47','610','2022-07-25 20:51:09',10,0),('1','177',257703,'DAILY  SALES','2022-07-26','2022-07-26 05:24:07','2022-07-27 05:24:07','610',0.00,0.00,'610','2022-07-26 20:32:50','610','2022-07-26 20:33:22',10,0),('1','177',257704,'DAILY  SALES','2022-07-27','2022-07-27 06:03:18','2022-07-28 06:03:18','610',0.00,0.00,'610','2022-07-27 20:25:09','610','2022-07-27 20:25:44',10,0),('1','177',257705,'DAILY  SALES','2022-07-28','2022-07-28 05:38:46','2022-07-29 05:38:46','610',0.00,0.00,'610','2022-07-28 11:27:50','610','2022-07-28 11:28:09',10,0),('1','177',257706,'DAILY SALES SECOND SALES','2022-07-28','2022-07-28 11:28:33','2022-07-29 11:28:33','610',0.00,0.00,'610','2022-07-28 20:03:25','610','2022-07-28 20:04:06',10,0),('1','177',257707,'DAILY  SALES','2022-07-29','2022-07-29 05:41:52','2022-07-30 05:41:52','610',0.00,0.00,'610','2022-07-29 20:57:13','610','2022-07-29 20:57:45',10,0),('1','177',257708,'DAILY  SALES','2022-07-30','2022-07-30 05:10:43','2022-07-31 05:10:43','610',0.00,0.00,'610','2022-07-30 20:43:42','610','2022-07-30 20:44:14',10,0),('1','177',257709,'DAILY  SALES','2022-07-31','2022-07-31 05:29:11','2022-08-01 05:29:11','610',0.00,0.00,'610','2022-07-31 20:41:04','610','2022-07-31 20:41:45',10,0),('1','177',257710,'DAILY  SALES','2022-08-01','2022-08-01 04:34:05','2022-08-02 04:34:05','610',0.00,0.00,'610','2022-08-01 20:07:00','610','2022-08-01 20:07:34',10,0),('1','177',257711,'DAILY  SALES','2022-08-02','2022-08-02 05:10:29','2022-08-03 05:10:29','610',0.00,0.00,'610','2022-08-02 15:32:26','610','2022-08-02 15:32:51',10,0),('1','177',257712,'DAILY  SALES','2022-08-02','2022-08-02 15:40:37','2022-08-03 15:40:37','610',0.00,0.00,'610','2022-08-02 20:24:47','610','2022-08-02 20:25:23',10,0),('1','177',257713,'DAILY  SALES','2022-08-03','2022-08-03 05:19:04','2022-08-04 05:19:04','610',0.00,0.00,'610','2022-08-03 20:48:36','610','2022-08-03 20:49:02',10,0),('1','177',257714,'DAILY  SALES','2022-08-04','2022-08-04 05:40:08','2022-08-05 05:40:08','610',0.00,0.00,'610','2022-08-04 20:53:43','610','2022-08-04 20:54:04',10,0),('1','177',257715,'DAILY  SALES','2022-08-05','2022-08-05 06:02:18','2022-08-06 06:02:18','610',0.00,0.00,'610','2022-08-05 21:10:21','610','2022-08-05 21:10:40',10,0),('1','177',257716,'DAILY  SALES','2022-08-06','2022-08-06 05:16:47','2022-08-07 05:16:47','610',0.00,0.00,'610','2022-08-06 20:23:59','610','2022-08-06 20:24:25',10,0),('1','177',257717,'DAILY  SALES+','2022-08-07','2022-08-07 04:55:20','2022-08-08 04:55:20','610',0.00,0.00,'610','2022-08-07 10:44:14','610','2022-08-07 10:44:32',10,0),('1','177',257718,'DAILY SALES SECOND SALES','2022-08-07','2022-08-07 10:48:22','2022-08-08 10:48:22','610',0.00,0.00,'610','2022-08-07 20:15:49','610','2022-08-07 20:16:19',10,0),('1','177',257719,'DAILY  SALES','2022-08-08','2022-08-08 04:42:59','2022-08-09 04:42:59','610',0.00,0.00,'610','2022-08-08 20:48:31','610','2022-08-08 20:49:01',10,0),('1','177',257720,'DAILY  SALES','2022-08-09','2022-08-09 04:03:02','2022-08-10 04:03:02','610',0.00,0.00,'610','2022-08-09 14:11:13','610','2022-08-09 14:11:38',10,0),('1','177',257721,'DAILY SALES.....SECOND SALES SHIFT','2022-08-09','2022-08-09 14:12:21','2022-08-10 14:12:21','610',0.00,0.00,'610','2022-08-09 21:31:18','610','2022-08-09 21:31:39',10,0),('1','177',257722,'DAILY  SALES','2022-08-10','2022-08-10 05:15:18','2022-08-11 05:15:18','610',0.00,0.00,'610','2022-08-10 20:43:54','610','2022-08-10 20:44:52',10,0),('1','177',257723,'DAILY  SALES','2022-08-11','2022-08-11 05:25:49','2022-08-12 05:25:49','610',0.00,0.00,'610','2022-08-11 19:41:49','610','2022-08-11 19:42:18',10,0),('1','177',257724,'DAILY  SALES','2022-08-12','2022-08-12 05:42:03','2022-08-13 05:42:03','610',0.00,0.00,'610','2022-08-12 20:42:47','610','2022-08-12 20:43:09',10,0),('1','177',257725,'DAILY  SALES','2022-08-13','2022-08-13 05:30:10','2022-08-14 05:30:10','610',0.00,0.00,'610','2022-08-13 19:57:21','610','2022-08-13 19:57:47',10,0),('1','177',257726,'DAILY  SALES','2022-08-14','2022-08-14 05:22:09','2022-08-15 05:22:09','610',0.00,0.00,'610','2022-08-14 12:29:55','610','2022-08-14 12:30:39',10,0),('1','177',257727,'OPERATIONAL LOSS','2022-08-14','2022-08-14 12:41:00','2022-08-15 12:41:00','610',0.00,0.00,'610','2022-08-14 12:44:25','610','2022-08-14 12:44:43',10,0),('1','177',257728,'DAILY SALES SECOND SALES','2022-08-14','2022-08-14 13:21:21','2022-08-15 13:21:21','610',0.00,0.00,'610','2022-08-14 20:27:44','610','2022-08-14 20:28:09',10,0),('1','177',257729,'DAILY  SALES','2022-08-15','2022-08-15 03:40:04','2022-08-16 03:40:04','610',0.00,0.00,'610','2022-08-15 21:08:52','610','2022-08-15 21:09:22',10,0),('1','177',257730,'DAILY  SALES','2022-08-16','2022-08-16 05:14:47','2022-08-17 05:14:47','610',0.00,0.00,'610','2022-08-16 16:49:20','610','2022-08-16 16:49:39',10,0),('1','177',257731,'DAILY SALES SECOND SALES','2022-08-16','2022-08-16 16:50:02','2022-08-17 16:50:02','610',0.00,0.00,'610','2022-08-16 21:44:54','610','2022-08-16 21:45:22',10,0),('1','177',257732,'DAILY  SALES','2022-08-17','2022-08-17 04:58:02','2022-08-18 04:58:02','610',0.00,0.00,'610','2022-08-17 20:30:18','610','2022-08-17 20:30:45',10,0),('1','177',257733,'DAILY SALES SHIFT','2022-08-18','2022-08-18 05:47:47','2022-08-19 05:47:47','610',0.00,0.00,'610','2022-08-18 20:32:49','610','2022-08-18 20:33:19',10,0),('1','177',257734,'DAILY  SALES','2022-08-19','2022-08-19 05:27:07','2022-08-20 05:27:07','610',0.00,0.00,'610','2022-08-19 20:23:56','610','2022-08-19 20:25:35',10,0),('1','177',257735,'DAILY  SALES','2022-08-20','2022-08-20 05:20:57','2022-08-21 05:20:57','610',0.00,0.00,'610','2022-08-20 20:26:16','610','2022-08-20 20:26:38',10,0),('1','177',257736,'DAILY  SALES','2022-08-21','2022-08-21 05:39:00','2022-08-22 05:39:00','610',0.00,0.00,'610','2022-08-21 20:19:57','610','2022-08-21 20:20:24',10,0),('1','177',257737,'DAILY  SALES','2022-08-22','2022-08-22 05:33:21','2022-08-23 05:33:21','610',0.00,0.00,'610','2022-08-22 16:30:12','610','2022-08-22 16:30:30',10,0),('1','177',257738,'DAILY SALES SHIFT, SECOND SALES','2022-08-22','2022-08-22 16:30:57','2022-08-23 16:30:57','610',0.00,0.00,'610','2022-08-22 20:45:03','610','2022-08-22 20:45:29',10,0),('1','177',257739,'DAILY  SALES','2022-08-23','2022-08-23 06:12:43','2022-08-24 06:12:43','610',0.00,0.00,'610','2022-08-23 20:13:25','610','2022-08-23 20:14:31',10,0),('1','177',257740,'DAILY  SALES','2022-08-24','2022-08-24 05:26:56','2022-08-25 05:26:56','610',0.00,0.00,'610','2022-08-24 20:14:43','610','2022-08-24 20:15:02',10,0),('1','177',257741,'DAILY  SALES','2022-08-25','2022-08-25 05:50:15','2022-08-26 05:50:15','610',0.00,0.00,'610','2022-08-25 12:03:42','610','2022-08-25 12:03:57',10,0),('1','177',257742,'OPERATIONAL LOSS','2022-08-25','2022-08-25 22:01:35','2022-08-26 22:01:35','610',0.00,0.00,'610','2022-08-26 06:28:11','610','2022-08-26 06:28:38',10,0),('1','177',257743,'DAILY  SALES','2022-08-27','2022-08-27 08:57:33','2022-08-28 08:57:33','610',0.00,0.00,'610','2022-08-27 20:37:39','610','2022-08-27 20:38:32',10,0),('1','177',257744,'DAILY  SALES','2022-08-28','2022-08-28 06:08:15','2022-08-29 06:08:15','610',0.00,0.00,'610','2022-08-28 19:26:53','610','2022-08-28 19:27:31',10,0),('1','177',257745,'DAILY  SALES','2022-08-29','2022-08-29 05:51:02','2022-08-30 05:51:02','610',0.00,0.00,'610','2022-08-29 10:55:39','610','2022-08-29 10:55:54',10,0),('1','177',257746,'DAILY SALES SECOND SALES','2022-08-29','2022-08-29 10:56:14','2022-08-30 10:56:14','610',0.00,0.00,'610','2022-08-29 20:58:55','610','2022-08-29 20:59:54',10,0),('1','177',257747,'DAILY  SALES','2022-08-30','2022-08-30 05:12:05','2022-08-31 05:12:05','610',0.00,0.00,'610','2022-08-30 20:34:08','610','2022-08-30 20:34:35',10,0),('1','177',257748,'DAILY  SALES','2022-08-31','2022-08-31 05:41:16','2022-09-01 05:41:16','610',0.00,0.00,'610','2022-08-31 17:33:08','610','2022-08-31 17:34:08',10,0),('1','177',257749,'DAILY SALES SECOND SALES','2022-08-31','2022-08-31 18:06:07','2022-09-01 18:06:07','610',0.00,0.00,'610','2022-08-31 20:13:45','610','2022-08-31 20:14:08',10,0),('1','177',257750,'DAILY  SALES','2022-09-01','2022-09-01 06:09:59','2022-09-02 06:09:59','610',0.00,0.00,'610','2022-09-01 20:41:47','610','2022-09-01 20:42:54',10,0),('1','177',257751,'DAILY  SALES','2022-09-02','2022-09-02 05:30:01','2022-09-03 05:30:01','610',0.00,0.00,'610','2022-09-02 20:27:05','610','2022-09-02 20:27:33',10,0),('1','177',257752,'DAILY  SALES','2022-09-03','2022-09-03 06:25:50','2022-09-04 06:25:50','610',0.00,0.00,'610','2022-09-03 13:48:33','610','2022-09-03 13:48:55',10,0),('1','177',257753,'DAILY SALES SECOND SALES','2022-09-03','2022-09-03 15:26:59','2022-09-04 15:26:59','610',0.00,0.00,'610','2022-09-03 20:06:34','610','2022-09-03 20:06:50',10,0),('1','177',257754,'DAILY  SALES','2022-09-04','2022-09-04 05:35:40','2022-09-05 05:35:40','610',0.00,0.00,'610','2022-09-04 19:59:08','610','2022-09-04 20:00:08',10,0),('1','177',257755,'DAILY  SALES','2022-09-05','2022-09-05 05:37:53','2022-09-06 05:37:53','610',0.00,0.00,'610','2022-09-05 21:19:09','610','2022-09-05 21:19:41',10,0),('1','177',257756,'DAILY  SALES','2022-09-06','2022-09-06 06:06:47','2022-09-07 06:06:47','610',0.00,0.00,'610','2022-09-06 13:27:08','610','2022-09-06 13:27:27',10,0),('1','177',257757,'DAILY SALES SECOND SALES','2022-09-06','2022-09-06 13:27:51','2022-09-07 13:27:51','610',0.00,0.00,'610','2022-09-06 20:35:46','610','2022-09-06 20:36:08',10,0),('1','177',257758,'DAILY  SALES','2022-09-07','2022-09-07 05:42:30','2022-09-08 05:42:30','610',0.00,0.00,'610','2022-09-07 20:13:02','610','2022-09-07 20:13:22',10,0),('1','177',257759,'DAILY  SALES','2022-09-08','2022-09-08 05:51:54','2022-09-09 05:51:54','610',0.00,0.00,'610','2022-09-08 15:21:11','610','2022-09-08 15:21:29',10,0),('1','177',257760,'DAILY  SALES','2022-09-08','2022-09-08 15:23:02','2022-09-09 15:23:02','610',0.00,0.00,'610','2022-09-08 20:21:23','610','2022-09-08 20:21:41',10,0),('1','177',257761,'DAILY  SALES','2022-09-09','2022-09-09 06:14:09','2022-09-10 06:14:09','610',0.00,0.00,'610','2022-09-09 20:31:46','610','2022-09-09 20:32:04',10,0),('1','177',257762,'DAILY  SALES','2022-09-10','2022-09-10 06:41:11','2022-09-11 06:41:11','610',0.00,0.00,'610','2022-09-10 20:01:43','610','2022-09-10 20:02:05',10,0),('1','177',257763,'DAILY  SALES','2022-09-12','2022-09-12 11:50:08','2022-09-13 11:50:08','610',0.00,0.00,'610','2022-09-12 20:04:03','610','2022-09-12 20:04:24',10,0),('1','177',257764,'DAILY  SALES','2022-09-13','2022-09-13 05:55:00','2022-09-14 05:55:00','610',0.00,0.00,'610','2022-09-13 20:18:50','610','2022-09-13 20:19:14',10,0),('1','177',257765,'DAILY  SALES','2022-09-14','2022-09-14 05:51:55','2022-09-15 05:51:55','610',0.00,0.00,'610','2022-09-14 16:28:12','610','2022-09-14 16:28:48',10,0),('1','177',257766,'OPERATIONAL LOSS','2022-09-14','2022-09-14 16:33:03','2022-09-15 16:33:03','610',0.00,0.00,'610','2022-09-14 16:42:45','610','2022-09-14 16:43:25',10,0),('1','177',257767,'DAILY SALES SECOND SALES','2022-09-14','2022-09-14 16:44:04','2022-09-15 16:44:04','610',0.00,0.00,'610','2022-09-14 19:56:25','610','2022-09-14 19:56:49',10,0),('1','177',257768,'DAILY  SALES','2022-09-15','2022-09-15 05:43:02','2022-09-16 05:43:02','610',0.00,0.00,'610','2022-09-15 20:00:42','610','2022-09-15 20:00:59',10,0),('1','177',257769,'DAILY  SALES','2022-09-16','2022-09-16 05:44:12','2022-09-17 05:44:12','610',0.00,0.00,'610','2022-09-16 20:03:18','610','2022-09-16 20:04:20',10,0),('1','177',257770,'DAILY  SALES','2022-09-17','2022-09-17 05:45:13','2022-09-18 05:45:13','610',0.00,0.00,'610','2022-09-17 08:56:21','610','2022-09-17 08:56:39',10,0),('1','177',257771,'DAILY SALES SECOND SALES','2022-09-17','2022-09-17 08:57:00','2022-09-18 08:57:00','610',0.00,0.00,'610','2022-09-17 20:00:28','610','2022-09-17 20:00:52',10,0),('1','177',257772,'DAILY  SALES','2022-09-18','2022-09-18 06:05:10','2022-09-19 06:05:10','610',0.00,0.00,'610','2022-09-18 19:44:09','610','2022-09-18 19:44:37',10,0),('1','177',257773,'DAILY  SALES','2022-09-19','2022-09-19 05:41:19','2022-09-20 05:41:19','610',0.00,0.00,'610','2022-09-19 09:53:43','610','2022-09-19 09:54:03',10,0),('1','177',257774,'DAILY SALES SECOND SALES','2022-09-19','2022-09-19 15:39:32','2022-09-20 15:39:32','610',0.00,0.00,'610','2022-09-19 20:07:02','610','2022-09-19 20:13:50',10,0),('1','177',257775,'DAILY  SALES','2022-09-20','2022-09-20 05:55:01','2022-09-21 05:55:01','610',0.00,0.00,'610','2022-09-20 20:19:17','610','2022-09-20 20:19:45',10,0),('1','177',257776,'DAILY  SALES','2022-09-21','2022-09-21 06:27:53','2022-09-22 06:27:53','610',0.00,0.00,'610','2022-09-21 20:06:24','610','2022-09-21 20:06:56',10,0),('1','177',257777,'DAILY  SALES','2022-09-22','2022-09-22 05:52:05','2022-09-23 05:52:05','610',0.00,0.00,'610','2022-09-22 09:36:43','610','2022-09-22 09:37:31',10,0),('1','177',257778,'DAILY SALES SECOND SALES','2022-09-22','2022-09-22 09:42:36','2022-09-23 09:42:36','610',0.00,0.00,'610','2022-09-22 20:20:41','610','2022-09-22 20:21:00',10,0),('1','177',257779,'DAILY  SALES','2022-09-23','2022-09-23 06:13:33','2022-09-24 06:13:33','610',0.00,0.00,'610','2022-09-23 20:15:51','610','2022-09-23 20:16:08',10,0),('1','177',257780,'DAILY  SALES','2022-09-24','2022-09-24 05:51:21','2022-09-25 05:51:21','610',0.00,0.00,'610','2022-09-24 12:04:07','610','2022-09-24 12:04:24',10,0),('1','177',257781,'DAILY SALES SECOND SALES','2022-09-24','2022-09-24 12:04:41','2022-09-25 12:04:41','610',0.00,0.00,'610','2022-09-24 20:11:48','610','2022-09-24 20:12:16',10,0),('1','177',257782,'DAILY  SALES','2022-09-25','2022-09-25 05:56:08','2022-09-26 05:56:08','610',0.00,0.00,'610','2022-09-25 20:15:36','610','2022-09-25 20:15:53',10,0),('1','177',257783,'DAILY  SALES','2022-09-26','2022-09-26 05:50:42','2022-09-27 05:50:42','610',0.00,0.00,'610','2022-09-26 14:00:35','610','2022-09-26 14:00:52',10,0),('1','177',257784,'DAILY SALES SECOND SALES','2022-09-26','2022-09-26 14:01:23','2022-09-27 14:01:23','610',0.00,0.00,'610','2022-09-26 20:31:41','610','2022-09-26 20:32:25',10,0),('1','177',257785,'DAILY  SALES','2022-09-27','2022-09-27 05:51:00','2022-09-28 05:51:00','610',0.00,0.00,'610','2022-09-27 20:38:03','610','2022-09-27 20:38:56',10,0),('1','177',257786,'DAILY  SALES','2022-09-28','2022-09-28 06:10:49','2022-09-29 06:10:49','610',0.00,0.00,'610','2022-09-28 17:47:14','610','2022-09-28 17:47:38',10,0),('1','177',257787,'DAILY SALES SECOND SALES','2022-09-28','2022-09-28 17:49:22','2022-09-29 17:49:22','610',0.00,0.00,'610','2022-09-28 20:33:27','610','2022-09-28 20:33:49',10,0),('1','177',257788,'DAILY  SALES','2022-09-29','2022-09-29 06:04:34','2022-09-30 06:04:34','610',0.00,0.00,'610','2022-09-29 20:07:01','610','2022-09-29 20:07:33',10,0),('1','177',257789,'DAILY  SALES','2022-09-30','2022-09-30 06:15:24','2022-10-01 06:15:24','610',0.00,0.00,'610','2022-09-30 20:41:30','610','2022-09-30 20:41:56',10,0),('1','177',257790,'DAILY  SALES','2022-10-01','2022-10-01 06:04:18','2022-10-02 06:04:18','610',0.00,0.00,'610','2022-10-01 12:18:13','610','2022-10-01 12:18:32',10,0),('1','177',257791,'DAILY SALES SECOND SALES','2022-10-01','2022-10-01 12:18:52','2022-10-02 12:18:52','610',0.00,0.00,'610','2022-10-01 20:00:46','610','2022-10-01 20:01:05',10,0),('1','177',257792,'DAILY  SALES','2022-10-02','2022-10-02 06:03:42','2022-10-03 06:03:42','610',0.00,0.00,'610','2022-10-02 19:52:33','610','2022-10-02 19:52:50',10,0),('1','177',257793,'DAILY  SALES','2022-10-03','2022-10-03 05:52:50','2022-10-04 05:52:50','610',0.00,0.00,'610','2022-10-03 18:24:50','610','2022-10-03 18:25:16',10,0),('1','177',257794,'DAILY  SALES','2022-10-04','2022-10-04 06:19:01','2022-10-05 06:19:01','610',0.00,0.00,'610','2022-10-04 20:56:29','610','2022-10-04 20:56:50',10,0),('1','177',257795,'DAILY  SALES','2022-10-05','2022-10-05 06:12:30','2022-10-06 06:12:30','610',0.00,0.00,'610','2022-10-05 18:16:18','610','2022-10-05 18:18:10',10,0),('1','177',257796,'DAILY  SALES5','2022-10-06','2022-10-06 12:27:42','2022-10-07 12:27:42','610',0.00,0.00,'610','2022-10-06 19:56:28','610','2022-10-06 19:56:49',10,0),('1','177',257797,'DAILY  SALES','2022-10-07','2022-10-07 05:55:34','2022-10-08 05:55:34','610',0.00,0.00,'610','2022-10-07 19:40:29','610','2022-10-07 19:40:47',10,0),('1','177',257798,'DAILY SALES SHIFT','2022-10-08','2022-10-08 06:41:32','2022-10-09 06:41:32','610',0.00,0.00,'610','2022-10-08 11:47:05','610','2022-10-08 11:47:24',10,0),('1','177',257799,'DAILY SALES SHIFT','2022-10-09','2022-10-09 07:03:11','2022-10-10 07:03:11','610',0.00,0.00,'610','2022-10-09 21:18:48','610','2022-10-09 21:19:07',10,0),('1','177',257800,'DAILY SALES','2022-10-10','2022-10-10 13:44:09','2022-10-11 13:44:09','610',0.00,0.00,'610','2022-10-10 17:53:25','610','2022-10-10 17:53:44',10,0),('1','177',257801,'OPERATIONAL LOSS','2022-10-10','2022-10-10 17:54:49','2022-10-11 17:54:49','610',0.00,0.00,'610','2022-10-10 17:57:07','610','2022-10-10 17:57:32',10,0),('1','177',257802,'OPERATIONAL LOSS','2022-10-10','2022-10-10 18:02:09','2022-10-11 18:02:09','610',0.00,0.00,'610','2022-10-10 18:04:42','610','2022-10-10 18:04:59',10,0),('1','177',257803,'DAILY SALES','2022-10-12','2022-10-12 11:25:09','2022-10-13 11:25:09','610',0.00,0.00,'610','2022-10-12 20:11:08','610','2022-10-12 20:11:30',10,0),('1','177',257804,'DAILY SALES','2022-10-13','2022-10-13 05:54:40','2022-10-14 05:54:40','610',0.00,0.00,'610','2022-10-13 19:56:21','610','2022-10-13 19:56:58',10,0),('1','177',257805,'DAILY SALES','2022-10-14','2022-10-14 08:30:36','2022-10-15 08:30:36','610',0.00,0.00,'610','2022-10-14 19:56:56','610','2022-10-14 19:57:18',10,0),('1','177',257806,'DAILY SALES','2022-10-15','2022-10-15 06:07:56','2022-10-16 06:07:56','610',0.00,0.00,'610','2022-10-15 18:52:09','610','2022-10-15 18:52:34',10,0),('1','177',257807,'DAILY SALES','2022-10-16','2022-10-16 06:22:42','2022-10-17 06:22:42','610',0.00,0.00,'610','2022-10-16 19:54:23','610','2022-10-16 19:54:45',10,0),('1','177',257808,'DAILY SALES','2022-10-17','2022-10-17 06:15:09','2022-10-18 06:15:09','610',0.00,0.00,'610','2022-10-17 20:03:03','610','2022-10-17 20:03:30',10,0),('1','177',257809,'DAILY SALES','2022-10-18','2022-10-18 06:07:40','2022-10-19 06:07:40','610',0.00,0.00,'610','2022-10-18 12:12:57','610','2022-10-18 12:13:17',10,0),('1','177',257810,'DAILY SALES','2022-10-18','2022-10-18 12:17:05','2022-10-19 12:17:05','610',0.00,0.00,'610','2022-10-18 20:10:16','610','2022-10-18 20:10:34',10,0),('1','177',257811,'DAILY SALES SHIFT','2022-10-19','2022-10-19 05:43:53','2022-10-20 05:43:53','610',0.00,0.00,'610','2022-10-19 20:30:06','610','2022-10-19 20:30:30',10,0),('1','177',257812,'DAILY SALES','2022-10-20','2022-10-20 06:24:12','2022-10-21 06:24:12','610',0.00,0.00,'610','2022-10-20 17:17:58','610','2022-10-20 17:18:37',10,0),('1','177',257813,'DAILY SALES','2022-10-20','2022-10-20 17:19:02','2022-10-21 17:19:02','610',0.00,0.00,'610','2022-10-20 20:00:14','610','2022-10-20 20:00:35',10,0),('1','177',257814,'DAILY SALES','2022-10-21','2022-10-21 06:26:32','2022-10-22 06:26:32','610',0.00,0.00,'610','2022-10-21 20:17:11','610','2022-10-21 20:17:32',10,0),('1','177',257815,'DAILY SALES','2022-10-22','2022-10-22 06:40:01','2022-10-23 06:40:01','610',0.00,0.00,'610','2022-10-22 14:35:39','610','2022-10-22 14:36:00',10,0),('1','177',257816,'DAILY SALES SECOND SALES','2022-10-22','2022-10-22 16:45:46','2022-10-23 16:45:46','610',0.00,0.00,'610','2022-10-22 20:01:35','610','2022-10-22 20:01:54',10,0),('1','177',257817,'DAILY SALES','2022-10-23','2022-10-23 06:12:57','2022-10-24 06:12:57','610',0.00,0.00,'610','2022-10-23 19:51:35','610','2022-10-23 19:52:00',10,0),('1','177',257818,'DAILY SALES','2022-10-24','2022-10-24 06:20:15','2022-10-25 06:20:15','610',0.00,0.00,'610','2022-10-24 10:21:40','610','2022-10-24 10:21:58',10,0),('1','177',257819,'DAILY SALES SECOND SALES','2022-10-24','2022-10-24 10:22:27','2022-10-25 10:22:27','610',0.00,0.00,'610','2022-10-24 21:29:28','610','2022-10-24 21:30:58',10,0),('1','177',257820,'DAILY SALES SHIFT','2022-10-25','2022-10-25 06:09:43','2022-10-26 06:09:43','610',0.00,0.00,'610','2022-10-25 20:08:23','610','2022-10-25 20:08:45',10,0),('1','177',257821,'DAILY SALES','2022-10-26','2022-10-26 06:21:16','2022-10-27 06:21:16','610',0.00,0.00,'610','2022-10-26 18:25:48','610','2022-10-26 18:26:23',10,0),('1','177',257822,'DAILY SALES SECOND SALES','2022-10-26','2022-10-26 18:26:53','2022-10-27 18:26:53','610',0.00,0.00,'610','2022-10-26 20:20:08','610','2022-10-26 20:20:26',10,0),('1','177',257823,'DAILY SALES SHIFT','2022-10-27','2022-10-27 06:10:29','2022-10-28 06:10:29','610',0.00,0.00,'610','2022-10-27 19:51:57','610','2022-10-27 19:52:30',10,0),('1','177',257824,'DAILY SALES','2022-10-28','2022-10-28 06:20:29','2022-10-29 06:20:29','610',0.00,0.00,'610','2022-10-28 20:46:01','610','2022-10-28 20:46:19',10,0),('1','177',257825,'DAILY SALES','2022-10-29','2022-10-29 05:46:19','2022-10-30 05:46:19','610',0.00,0.00,'610','2022-10-29 12:15:13','610','2022-10-29 12:15:34',10,0),('1','177',257826,'DAILY SALES SECOND SALES','2022-10-29','2022-10-29 12:17:53','2022-10-30 12:17:53','610',0.00,0.00,'610','2022-10-29 20:10:05','610','2022-10-29 20:10:27',10,0),('1','177',257827,'DAILY SALES','2022-10-30','2022-10-30 06:00:01','2022-10-31 06:00:01','610',0.00,0.00,'610','2022-10-30 20:50:08','610','2022-10-30 20:50:30',10,0),('1','177',257828,'DAILY SALES SHIFT','2022-10-31','2022-10-31 05:54:45','2022-11-01 05:54:45','610',0.00,0.00,'610','2022-10-31 19:01:45','610','2022-10-31 19:02:10',10,0),('1','177',257829,'OPERATIONAL LOSS','2022-10-31','2022-10-31 19:05:22','2022-11-01 19:05:22','610',0.00,0.00,'610','2022-10-31 19:08:23','610','2022-10-31 19:08:41',10,0),('1','177',257830,'DAILY SALES','2022-11-04','2022-11-04 05:54:35','2022-11-05 05:54:35','610',0.00,0.00,'610','2022-11-04 19:57:17','610','2022-11-04 19:57:39',10,0),('1','177',257831,'DAILY SALES','2022-11-05','2022-11-05 08:40:29','2022-11-06 08:40:29','610',0.00,0.00,'610','2022-11-05 20:14:40','610','2022-11-05 20:15:01',10,0),('1','177',257832,'DAILY SALES','2022-11-06','2022-11-06 08:34:27','2022-11-07 08:34:27','610',0.00,0.00,'610','2022-11-06 13:58:09','610','2022-11-06 13:58:46',10,0),('1','177',257833,'DAILY SALES SECOND SALES','2022-11-06','2022-11-06 13:59:12','2022-11-07 13:59:12','610',0.00,0.00,'610','2022-11-06 21:05:11','610','2022-11-06 21:05:31',10,0),('1','177',257834,'DAILY SALES SHIFT','2022-11-07','2022-11-07 05:55:41','2022-11-08 05:55:41','610',0.00,0.00,'610','2022-11-07 20:20:17','610','2022-11-07 20:20:38',10,0),('1','177',257835,'DAILY SALES','2022-11-08','2022-11-08 06:11:51','2022-11-09 06:11:51','610',0.00,0.00,'610','2022-11-08 20:24:59','610','2022-11-08 20:25:20',10,0),('1','177',257836,'DAILY SALES','2022-11-09','2022-11-09 05:52:35','2022-11-10 05:52:35','610',0.00,0.00,'610','2022-11-09 10:49:51','610','2022-11-09 10:50:09',10,0),('1','177',257837,'OPERATIONAL LOSS','2022-11-09','2022-11-09 10:50:38','2022-11-10 10:50:38','610',0.00,0.00,'610','2022-11-09 10:54:24','610','2022-11-09 10:54:42',10,0),('1','177',257838,'DAILY SALES SECOND SALES','2022-11-09','2022-11-09 10:55:07','2022-11-10 10:55:07','610',0.00,0.00,'610','2022-11-09 19:51:16','610','2022-11-09 19:51:49',10,0),('1','177',257839,'DAILY SALES','2022-11-10','2022-11-10 06:07:42','2022-11-11 06:07:42','610',0.00,0.00,'610','2022-11-10 19:56:46','610','2022-11-10 19:57:06',10,0),('1','177',257840,'DAILY SALES','2022-11-11','2022-11-11 06:03:15','2022-11-12 06:03:15','610',0.00,0.00,'610','2022-11-11 16:24:45','610','2022-11-11 16:25:04',10,0),('1','177',257841,'OPERATIONAL LOSS','2022-11-11','2022-11-11 16:25:44','2022-11-12 16:25:44','610',0.00,0.00,'610','2022-11-11 16:28:09','610','2022-11-11 16:28:27',10,0),('1','177',257842,'DAILY SALES SECOND SALES','2022-11-11','2022-11-11 16:30:45','2022-11-12 16:30:45','610',0.00,0.00,'610','2022-11-11 20:17:30','610','2022-11-11 20:17:54',10,0),('1','177',257843,'DAILY SALES','2022-11-12','2022-11-12 06:18:31','2022-11-13 06:18:31','610',0.00,0.00,'610','2022-11-12 20:01:04','610','2022-11-12 20:01:26',10,0),('1','177',257844,'DAILY SALES','2022-11-13','2022-11-13 06:24:20','2022-11-14 06:24:20','610',0.00,0.00,'610','2022-11-13 20:07:30','610','2022-11-13 20:07:51',10,0),('1','177',257845,'DAILY SALES','2022-11-14','2022-11-14 06:03:48','2022-11-15 06:03:48','610',0.00,0.00,'610','2022-11-14 14:27:20','610','2022-11-14 14:27:39',10,0),('1','177',257846,'DAILY SALES SECOND SALES','2022-11-14','2022-11-14 14:28:06','2022-11-15 14:28:06','610',0.00,0.00,'610','2022-11-14 20:17:11','610','2022-11-14 20:17:33',10,0),('1','177',257847,'DAILY SALES','2022-11-15','2022-11-15 05:58:47','2022-11-16 05:58:47','610',0.00,0.00,'610','2022-11-15 19:55:09','610','2022-11-15 19:55:30',10,0),('1','177',257848,'DAILY SALES','2022-11-16','2022-11-16 06:18:42','2022-11-17 06:18:42','610',0.00,0.00,'610','2022-11-16 20:00:17','610','2022-11-16 20:01:12',10,0),('1','177',257849,'DAILY SALES','2022-11-17','2022-11-17 06:01:00','2022-11-18 06:01:00','610',0.00,0.00,'610','2022-11-17 10:54:06','610','2022-11-17 10:54:41',10,0),('1','177',257850,'DAILY SALES SECOND SALES','2022-11-17','2022-11-17 11:27:04','2022-11-18 11:27:04','610',0.00,0.00,'610','2022-11-17 20:29:58','610','2022-11-17 20:30:20',10,0),('1','177',257851,'DAILY SALES','2022-11-18','2022-11-18 06:06:56','2022-11-19 06:06:56','610',0.00,0.00,'610','2022-11-18 20:37:41','610','2022-11-18 20:38:13',10,0),('1','177',257852,'DAILY SALES','2022-11-19','2022-11-19 05:44:29','2022-11-20 05:44:29','610',0.00,0.00,'610','2022-11-19 19:17:02','610','2022-11-19 19:17:19',10,0),('1','177',257853,'DAILY SALES','2022-11-20','2022-11-20 06:24:56','2022-11-21 06:24:56','610',0.00,0.00,'610','2022-11-20 20:11:01','610','2022-11-20 20:11:26',10,0),('1','177',257854,'DAILY SALES','2022-11-21','2022-11-21 06:03:38','2022-11-22 06:03:38','610',0.00,0.00,'610','2022-11-21 20:07:03','610','2022-11-21 20:07:25',10,0),('1','177',257855,'DAILY SALES','2022-11-22','2022-11-22 06:27:46','2022-11-23 06:27:46','610',0.00,0.00,'610','2022-11-22 20:25:26','610','2022-11-22 20:25:53',10,0),('1','177',257856,'DAILY SALES','2022-11-23','2022-11-23 05:52:57','2022-11-24 05:52:57','610',0.00,0.00,'610','2022-11-23 20:09:46','610','2022-11-23 20:10:04',10,0),('1','177',257857,'DAILY SALES','2022-11-24','2022-11-24 06:13:13','2022-11-25 06:13:13','610',0.00,0.00,'610','2022-11-24 19:58:19','610','2022-11-24 19:58:50',10,0),('1','177',257858,'DAILY SALES','2022-11-25','2022-11-25 06:09:49','2022-11-26 06:09:49','610',0.00,0.00,'610','2022-11-25 15:38:08','610','2022-11-25 15:38:50',10,0),('1','177',257859,'DAILY SALES SECOND SALES','2022-11-25','2022-11-25 15:42:40','2022-11-26 15:42:40','610',0.00,0.00,'610','2022-11-25 20:10:21','610','2022-11-25 20:11:20',10,0),('1','177',257860,'DAILY SALES','2022-11-26','2022-11-26 06:11:59','2022-11-27 06:11:59','610',0.00,0.00,'610','2022-11-26 20:49:42','610','2022-11-26 21:18:20',10,0),('1','177',257861,'DAILY SALES','2022-11-27','2022-11-27 06:01:55','2022-11-28 06:01:55','610',0.00,0.00,'610','2022-11-27 20:05:03','610','2022-11-27 20:05:25',10,0),('1','177',257862,'DAILY SALES','2022-11-28','2022-11-28 06:14:02','2022-11-29 06:14:02','610',0.00,0.00,'610','2022-11-28 09:38:29','610','2022-11-28 09:38:49',10,0),('1','177',257863,'DAILY SALES SECOND SALES','2022-11-28','2022-11-28 09:39:20','2022-11-29 09:39:20','610',0.00,0.00,'610','2022-11-28 20:44:29','610','2022-11-28 20:45:11',10,0),('1','177',257864,'DAILY SALES','2022-11-29','2022-11-29 06:13:36','2022-11-30 06:13:36','610',0.00,0.00,'610','2022-11-29 19:56:14','610','2022-11-29 19:56:47',10,0),('1','177',257865,'DAILY SALES SHIFT','2022-11-30','2022-11-30 06:05:03','2022-12-01 06:05:03','610',0.00,0.00,'610','2022-11-30 11:18:54','610','2022-11-30 11:19:19',10,0),('1','177',257866,'DAILY SALES SECOND SALES','2022-11-30','2022-11-30 11:21:32','2022-12-01 11:21:32','610',0.00,0.00,'610','2022-11-30 20:14:51','610','2022-11-30 20:15:12',10,0),('1','177',257867,'DAILY SALES SHIFT','2022-12-01','2022-12-01 06:44:57','2022-12-02 06:44:57','610',0.00,0.00,'610','2022-12-01 19:56:33','610','2022-12-01 19:56:52',10,0),('1','177',257868,'DAILY SALES SHIFT','2022-12-02','2022-12-02 05:43:09','2022-12-03 05:43:09','610',0.00,0.00,'610','2022-12-02 13:09:21','610','2022-12-02 13:09:48',10,0),('1','177',257869,'DAILY SALES SECOND SALES','2022-12-02','2022-12-02 13:10:04','2022-12-03 13:10:04','610',0.00,0.00,'610','2022-12-02 20:24:10','610','2022-12-02 20:24:32',10,0),('1','177',257870,'DAILY SALES','2022-12-03','2022-12-03 05:51:56','2022-12-04 05:51:56','610',0.00,0.00,'610','2022-12-03 19:59:15','610','2022-12-03 19:59:58',10,0),('1','177',257871,'DAILY SALES SHIFT','2022-12-04','2022-12-04 06:02:51','2022-12-05 06:02:51','610',0.00,0.00,'610','2022-12-04 15:53:22','610','2022-12-04 15:53:43',10,0),('1','177',257872,'DAILY SALES SECOND SALES','2022-12-04','2022-12-04 17:06:49','2022-12-05 17:06:49','610',0.00,0.00,'610','2022-12-05 05:19:57','610','2022-12-05 05:20:19',10,0),('1','177',257873,'DAILY SALES SHIFT','2022-12-05','2022-12-05 05:20:35','2022-12-06 05:20:35','610',0.00,0.00,'610','2022-12-05 20:42:20','610','2022-12-05 20:42:55',10,0),('1','177',257874,'DAILY SALES','2022-12-06','2022-12-06 05:51:13','2022-12-07 05:51:13','610',0.00,0.00,'610','2022-12-06 20:51:30','610','2022-12-06 20:51:51',10,0),('1','177',257875,'DAILY SALES','2022-12-07','2022-12-07 05:53:17','2022-12-08 05:53:17','610',0.00,0.00,'610','2022-12-07 16:51:46','610','2022-12-07 16:52:06',10,0),('1','177',257876,'DAILY SALES SHIFT','2022-12-08','2022-12-08 05:59:37','2022-12-09 05:59:37','610',0.00,0.00,'610','2022-12-08 16:06:30','610','2022-12-08 16:06:47',10,0),('1','177',257877,'DAILY SALES SECOND SALES','2022-12-08','2022-12-08 16:07:06','2022-12-09 16:07:06','610',0.00,0.00,'610','2022-12-08 19:50:26','610','2022-12-08 19:50:48',10,0),('1','177',257878,'DAILY SALES','2022-12-09','2022-12-09 06:53:29','2022-12-10 06:53:29','610',0.00,0.00,'610','2022-12-09 09:51:18','610','2022-12-09 09:51:40',10,0),('1','177',257879,'DAILY SALES SECOND SALES','2022-12-09','2022-12-09 09:52:21','2022-12-10 09:52:21','610',0.00,0.00,'610','2022-12-09 20:00:38','610','2022-12-09 20:00:55',10,0),('1','177',257880,'DAILY SALES','2022-12-10','2022-12-10 05:44:03','2022-12-11 05:44:03','610',0.00,0.00,'610','2022-12-10 11:54:25','610','2022-12-10 11:55:12',10,0),('1','177',257881,'DAILY SALES SECOND SALES','2022-12-10','2022-12-10 11:56:30','2022-12-11 11:56:30','610',0.00,0.00,'610','2022-12-10 19:50:44','610','2022-12-10 19:51:12',10,0),('1','177',257882,'DAILY SALES','2022-12-11','2022-12-11 05:38:56','2022-12-12 05:38:56','610',0.00,0.00,'610','2022-12-11 19:58:57','610','2022-12-11 19:59:22',10,0),('1','177',257883,'DAILY SALES','2022-12-12','2022-12-12 05:31:11','2022-12-13 05:31:11','610',0.00,0.00,'610','2022-12-12 17:19:58','610','2022-12-12 17:20:16',10,0),('1','177',257884,'DAILY SALES SECOND SALES','2022-12-12','2022-12-12 17:20:34','2022-12-13 17:20:34','610',0.00,0.00,'610','2022-12-12 20:19:42','610','2022-12-12 20:20:00',10,0),('1','177',257885,'DAILY SALES','2022-12-13','2022-12-13 06:28:53','2022-12-14 06:28:53','610',0.00,0.00,'610','2022-12-13 20:27:31','610','2022-12-13 20:27:53',10,0),('1','177',257886,'DAILY SALES','2022-12-14','2022-12-14 06:34:29','2022-12-15 06:34:29','610',0.00,0.00,'610','2022-12-14 20:00:41','610','2022-12-14 20:00:58',10,0),('1','177',257887,'DAILY SALES','2022-12-15','2022-12-15 05:50:44','2022-12-16 05:50:44','610',0.00,0.00,'610','2022-12-15 13:12:21','610','2022-12-15 13:12:36',10,0),('1','177',257888,'DAILY SALES SECOND SALES','2022-12-15','2022-12-15 13:12:51','2022-12-16 13:12:51','610',0.00,0.00,'610','2022-12-15 19:46:00','610','2022-12-15 19:47:14',10,0),('1','177',257889,'DAILY SALES','2022-12-16','2022-12-16 05:54:01','2022-12-17 05:54:01','610',0.00,0.00,'610','2022-12-16 20:18:12','610','2022-12-16 20:18:32',10,0),('1','177',257890,'DAILY SALES','2022-12-17','2022-12-17 05:57:37','2022-12-18 05:57:37','610',0.00,0.00,'610','2022-12-17 19:51:05','610','2022-12-17 19:51:33',10,0),('1','177',257891,'DAILY SALES','2022-12-18','2022-12-18 06:06:04','2022-12-19 06:06:04','610',0.00,0.00,'610','2022-12-18 19:57:47','610','2022-12-18 19:58:07',10,0),('1','177',257892,'DAILY SALES','2022-12-19','2022-12-19 05:55:25','2022-12-20 05:55:25','610',0.00,0.00,'610','2022-12-19 20:08:42','610','2022-12-19 20:09:01',10,0),('1','177',257893,'DAILY SALES','2022-12-20','2022-12-20 05:44:34','2022-12-21 05:44:34','610',0.00,0.00,'610','2022-12-20 12:35:56','610','2022-12-20 12:36:23',10,0),('1','177',257894,'DAILY SALES SECOND SALES','2022-12-20','2022-12-20 12:36:41','2022-12-21 12:36:41','610',0.00,0.00,'610','2022-12-20 20:35:34','610','2022-12-20 20:35:55',10,0),('1','177',257895,'DAILY SALES','2022-12-21','2022-12-21 05:57:25','2022-12-22 05:57:25','610',0.00,0.00,'610','2022-12-21 20:25:36','610','2022-12-21 20:25:56',10,0),('1','177',257896,'DAILY SALES','2022-12-22','2022-12-22 06:23:21','2022-12-23 06:23:21','610',0.00,0.00,'610','2022-12-22 15:40:09','610','2022-12-22 15:40:37',10,0),('1','177',257897,'DAILY SALES SECOND SALES','2022-12-22','2022-12-22 16:35:47','2022-12-23 16:35:47','610',0.00,0.00,'610','2022-12-22 19:59:09','610','2022-12-22 19:59:33',10,0),('1','177',257898,'DAILY SALES','2022-12-23','2022-12-23 06:44:46','2022-12-24 06:44:46','610',0.00,0.00,'610','2022-12-23 20:09:08','610','2022-12-23 20:09:27',10,0),('1','177',257899,'DAILY SALES','2022-12-24','2022-12-24 05:34:38','2022-12-25 05:34:38','610',0.00,0.00,'610','2022-12-24 09:47:49','610','2022-12-24 09:48:21',10,0),('1','177',257900,'DAILY SALES SECOND SALES','2022-12-24','2022-12-24 11:59:09','2022-12-25 11:59:09','610',0.00,0.00,'610','2022-12-24 20:28:12','610','2022-12-24 20:28:31',10,0),('1','177',257901,'DAILY SALES','2022-12-25','2022-12-25 06:20:32','2022-12-26 06:20:32','610',0.00,0.00,'610','2022-12-25 19:53:56','610','2022-12-25 19:54:16',10,0),('1','177',257902,'DAILY SALES','2022-12-26','2022-12-26 06:20:49','2022-12-27 06:20:49','610',0.00,0.00,'610','2022-12-26 12:52:13','610','2022-12-26 12:52:35',10,0),('1','177',257903,'DAILY SALES SECOND SALES','2022-12-26','2022-12-26 13:26:13','2022-12-27 13:26:13','610',0.00,0.00,'610','2022-12-26 19:58:10','610','2022-12-26 19:58:34',10,0),('1','177',257904,'DAILY SALES','2022-12-27','2022-12-27 06:24:45','2022-12-28 06:24:45','610',0.00,0.00,'610','2022-12-27 19:55:01','610','2022-12-27 19:55:20',10,0),('1','177',257905,'DAILY SALES','2022-12-28','2022-12-28 06:18:37','2022-12-29 06:18:37','610',0.00,0.00,'610','2022-12-28 19:51:13','610','2022-12-28 19:51:33',10,0),('1','177',257906,'DAILY SALES','2022-12-29','2022-12-29 06:33:00','2022-12-30 06:33:00','610',0.00,0.00,'610','2022-12-29 14:38:58','610','2022-12-29 14:39:16',10,0),('1','177',257907,'DAILY SALES SECOND SALES','2022-12-29','2022-12-29 14:39:32','2022-12-30 14:39:32','610',0.00,0.00,'610','2022-12-29 19:51:19','610','2022-12-29 19:51:57',10,0),('1','177',257908,'DAILY SALES','2022-12-30','2022-12-30 05:48:29','2022-12-31 05:48:29','610',0.00,0.00,'610','2022-12-30 20:25:11','610','2022-12-30 20:25:30',10,0),('1','177',257909,'DAILY SALES','2022-12-31','2022-12-31 06:44:37','2023-01-01 06:44:37','610',0.00,0.00,'610','2022-12-31 20:55:57','610','2022-12-31 20:56:17',10,0),('1','177',257910,'DAILY SALES','2023-01-01','2023-01-01 05:38:28','2023-01-02 05:38:28','610',0.00,0.00,'610','2023-01-01 16:43:37','610','2023-01-01 16:43:56',10,0),('1','177',257911,'DAILY SALES SECOND SALES','2023-01-01','2023-01-01 16:44:17','2023-01-02 16:44:17','610',0.00,0.00,'610','2023-01-01 20:04:32','610','2023-01-01 20:04:49',10,0),('1','177',257912,'DAILY SALES','2023-01-02','2023-01-02 05:13:26','2023-01-03 05:13:26','610',0.00,0.00,'610','2023-01-02 19:51:45','610','2023-01-02 19:52:16',10,0),('1','177',257913,'DAILY SALES','2023-01-03','2023-01-03 05:40:31','2023-01-04 05:40:31','610',0.00,0.00,'610','2023-01-03 19:53:09','610','2023-01-03 19:53:36',10,0),('1','177',257914,'DAILY SALES','2023-01-04','2023-01-04 05:29:38','2023-01-05 05:29:38','610',0.00,0.00,'610','2023-01-04 13:53:04','610','2023-01-04 13:53:21',10,0),('1','177',257915,'DAILY SALES SECOND SALES','2023-01-04','2023-01-04 13:53:38','2023-01-05 13:53:38','610',0.00,0.00,'610','2023-01-04 19:55:51','610','2023-01-04 19:56:16',10,0),('1','177',257916,'DAILY SALES','2023-01-05','2023-01-05 05:35:45','2023-01-06 05:35:45','610',0.00,0.00,'610','2023-01-05 19:53:03','610','2023-01-05 19:53:21',10,0),('1','177',257917,'DAILY SALES','2023-01-06','2023-01-06 05:19:55','2023-01-07 05:19:55','610',0.00,0.00,'610','2023-01-06 20:43:59','610','2023-01-06 20:44:25',10,0),('1','177',257918,'DAILY SALES','2023-01-07','2023-01-07 05:39:01','2023-01-08 05:39:01','610',0.00,0.00,'610','2023-01-07 10:44:20','610','2023-01-07 10:44:55',10,0),('1','177',257919,'DAILY SALES SECOND SALES','2023-01-07','2023-01-07 11:17:40','2023-01-08 11:17:40','610',0.00,0.00,'610','2023-01-07 20:34:37','610','2023-01-07 20:35:19',10,0),('1','177',257920,'DAILY SALES','2023-01-08','2023-01-08 05:21:38','2023-01-09 05:21:38','610',0.00,0.00,'610','2023-01-08 19:52:45','610','2023-01-08 19:53:28',10,0),('1','177',257921,'DAILY SALES','2023-01-09','2023-01-09 06:02:21','2023-01-10 06:02:21','610',0.00,0.00,'610','2023-01-09 20:29:38','610','2023-01-09 20:30:08',10,0),('1','177',257922,'DAILY SALES','2023-01-10','2023-01-10 05:45:27','2023-01-11 05:45:27','610',0.00,0.00,'610','2023-01-10 16:38:05','610','2023-01-10 16:38:53',10,0),('1','177',257923,'OPERATIONAL LOSS','2023-01-10','2023-01-10 16:41:26','2023-01-11 16:41:26','610',0.00,0.00,'610','2023-01-10 16:45:16','610','2023-01-10 16:45:45',10,0),('1','177',257924,'DAILY SALES SECOND SALES','2023-01-10','2023-01-10 16:46:18','2023-01-11 16:46:18','610',0.00,0.00,'610','2023-01-10 20:27:49','610','2023-01-10 20:28:10',10,0),('1','177',257925,'DAILY SALES','2023-01-11','2023-01-11 07:07:36','2023-01-12 07:07:36','610',0.00,0.00,'610','2023-01-11 20:06:48','610','2023-01-11 20:07:05',10,0),('1','177',257926,'DAILY SALES SHIFT','2023-01-12','2023-01-12 06:02:26','2023-01-13 06:02:26','610',0.00,0.00,'610','2023-01-12 20:06:23','610','2023-01-12 20:06:48',10,0),('1','177',257927,'DAILY SALES','2023-01-13','2023-01-13 05:33:27','2023-01-14 05:33:27','610',0.00,0.00,'610','2023-01-13 17:28:35','610','2023-01-13 17:28:54',10,0),('1','177',257928,'OPERATIONAL LOSS','2023-01-13','2023-01-13 17:29:11','2023-01-14 17:29:11','610',0.00,0.00,'610','2023-01-13 17:33:39','610','2023-01-13 17:33:58',10,0),('1','177',257929,'DAILY SALES SECOND SALES','2023-01-13','2023-01-13 17:34:21','2023-01-14 17:34:21','610',0.00,0.00,'610','2023-01-13 20:36:16','610','2023-01-13 20:36:34',10,0),('1','177',257930,'DAILY SALES','2023-01-14','2023-01-14 05:47:38','2023-01-15 05:47:38','610',0.00,0.00,'610','2023-01-14 19:43:07','610','2023-01-14 19:43:41',10,0),('1','177',257931,'DAILY SALES','2023-01-15','2023-01-15 06:06:40','2023-01-16 06:06:40','610',0.00,0.00,'610','2023-01-15 20:54:34','610','2023-01-15 20:54:53',10,0),('1','177',257932,'DAILY SALES','2023-01-16','2023-01-16 05:29:46','2023-01-17 05:29:46','610',0.00,0.00,'610','2023-01-16 10:17:41','610','2023-01-16 10:18:15',10,0),('1','177',257933,'DAILY SALES SECOND SALES','2023-01-16','2023-01-16 10:24:41','2023-01-17 10:24:41','610',0.00,0.00,'610','2023-01-16 20:14:24','610','2023-01-16 20:14:43',10,0),('1','177',257934,'DAILY SALES','2023-01-17','2023-01-17 05:44:15','2023-01-18 05:44:15','610',0.00,0.00,'610','2023-01-17 20:34:16','610','2023-01-17 20:34:39',10,0),('1','177',257935,'DAILY SALES','2023-01-18','2023-01-18 05:20:14','2023-01-19 05:20:14','610',0.00,0.00,'610','2023-01-18 11:28:39','610','2023-01-18 11:29:01',10,0),('1','177',257936,'DAILY SALES SECOND SALES','2023-01-18','2023-01-18 11:29:26','2023-01-19 11:29:26','610',0.00,0.00,'610','2023-01-18 22:04:11','610','2023-01-18 22:05:18',10,0),('1','177',257937,'DAILY SALES','2023-01-19','2023-01-19 05:34:30','2023-01-20 05:34:30','610',0.00,0.00,'610','2023-01-19 20:04:44','610','2023-01-19 20:05:03',10,0),('1','177',257938,'DAILY SALES','2023-01-20','2023-01-20 06:22:38','2023-01-21 06:22:38','610',0.00,0.00,'610','2023-01-20 20:21:41','610','2023-01-20 20:22:00',10,0),('1','177',257939,'DAILY SALES','2023-01-21','2023-01-21 05:36:54','2023-01-22 05:36:54','610',0.00,0.00,'610','2023-01-21 11:11:48','610','2023-01-21 11:12:07',10,0),('1','177',257940,'OPERATIONAL LOSS','2023-01-21','2023-01-21 11:14:26','2023-01-22 11:14:26','610',0.00,0.00,'610','2023-01-21 11:17:39','610','2023-01-21 11:17:58',10,0),('1','177',257941,'DAILY SALES SECOND SALES','2023-01-21','2023-01-21 11:18:15','2023-01-22 11:18:15','610',0.00,0.00,'610','2023-01-21 20:33:05','610','2023-01-21 20:33:22',10,0),('1','177',257942,'DAILY SALES','2023-01-22','2023-01-22 05:28:54','2023-01-23 05:28:54','610',0.00,0.00,'610','2023-01-22 20:14:19','610','2023-01-22 20:14:38',10,0),('1','177',257943,'DAILY SALES SHIFT','2023-01-23','2023-01-23 06:06:39','2023-01-24 06:06:39','610',0.00,0.00,'610','2023-01-23 18:25:53','610','2023-01-23 18:26:11',10,0),('1','177',257944,'OPERATIONAL LOSS','2023-01-23','2023-01-23 18:26:44','2023-01-24 18:26:44','610',0.00,0.00,'610','2023-01-23 19:52:31','610','2023-01-23 19:52:58',10,0),('1','177',257945,'DAILY SALES SECOND SALES','2023-01-23','2023-01-23 19:53:49','2023-01-24 19:53:49','610',0.00,0.00,'610','2023-01-23 20:03:52','610','2023-01-23 20:04:12',10,0),('1','177',257946,'DAILY SALES','2023-01-24','2023-01-24 05:41:24','2023-01-25 05:41:24','610',0.00,0.00,'610','2023-01-24 19:59:59','610','2023-01-24 20:01:11',10,0),('1','177',257947,'DAILY SALES','2023-01-25','2023-01-25 06:03:53','2023-01-26 06:03:53','610',0.00,0.00,'610','2023-01-25 19:55:54','610','2023-01-25 19:56:14',10,0),('1','177',257948,'DAILY SALES','2023-01-26','2023-01-26 05:37:03','2023-01-27 05:37:03','610',0.00,0.00,'610','2023-01-26 13:25:47','610','2023-01-26 13:26:22',10,0),('1','177',257949,'DAILY SALES SECOND SALES','2023-01-26','2023-01-26 13:26:53','2023-01-27 13:26:53','610',0.00,0.00,'610','2023-01-26 19:28:13','610','2023-01-26 19:28:44',10,0),('1','177',257950,'DAILY SALES','2023-01-27','2023-01-27 05:48:10','2023-01-28 05:48:10','610',0.00,0.00,'610','2023-01-27 20:01:44','610','2023-01-27 20:02:04',10,0),('1','177',257951,'DAILY SALES','2023-01-28','2023-01-28 05:49:29','2023-01-29 05:49:29','610',0.00,0.00,'610','2023-01-28 20:04:37','610','2023-01-28 20:04:58',10,0),('1','177',257952,'DAILY SALES SHIFT','2023-01-29','2023-01-29 06:21:55','2023-01-30 06:21:55','610',0.00,0.00,'610','2023-01-29 11:27:06','610','2023-01-29 11:27:42',10,0),('1','177',257953,'DAILY SALES SECOND SALES','2023-01-29','2023-01-29 11:28:02','2023-01-30 11:28:02','610',0.00,0.00,'610','2023-01-29 20:06:07','610','2023-01-29 20:06:42',10,0),('1','177',257954,'DAILY SALES SHIFT','2023-01-30','2023-01-30 06:13:16','2023-01-31 06:13:16','610',0.00,0.00,'610','2023-01-30 19:47:09','610','2023-01-30 19:47:30',10,0),('1','177',257955,'DAILY SALES SHIFT','2023-01-31','2023-01-31 06:16:27','2023-02-01 06:16:27','610',0.00,0.00,'610','2023-01-31 19:02:53','610','2023-01-31 19:03:17',10,0),('1','177',257956,'DAILY SALES','2023-02-01','2023-02-01 06:52:00','2023-02-02 06:52:00','610',0.00,0.00,'610','2023-02-01 21:20:51','610','2023-02-01 21:21:12',10,0),('1','177',257957,'DAILY SALES','2023-02-02','2023-02-02 07:34:40','2023-02-03 07:34:40','610',0.00,0.00,'610','2023-02-02 20:38:17','610','2023-02-02 20:38:40',10,0),('1','177',257958,'DAILY SALES','2023-02-03','2023-02-03 06:08:29','2023-02-04 06:08:29','610',0.00,0.00,'610','2023-02-03 14:34:59','610','2023-02-03 14:35:17',10,0),('1','177',257959,'DAILY SALES SECOND SALES','2023-02-03','2023-02-03 14:38:32','2023-02-04 14:38:32','610',0.00,0.00,'610','2023-02-03 20:19:30','610','2023-02-03 20:20:02',10,0),('1','177',257960,'DAILY SALES','2023-02-04','2023-02-04 06:48:07','2023-02-05 06:48:07','610',0.00,0.00,'610','2023-02-04 21:05:21','610','2023-02-04 21:05:46',10,0),('1','177',257961,'DAILY SALES','2023-02-05','2023-02-05 06:07:22','2023-02-06 06:07:22','610',0.00,0.00,'610','2023-02-05 20:04:05','610','2023-02-05 20:04:26',10,0),('1','177',257962,'DAILY SALES SHIFT','2023-02-06','2023-02-06 06:22:26','2023-02-07 06:22:26','610',0.00,0.00,'610','2023-02-06 20:27:59','610','2023-02-06 20:28:22',10,0),('1','177',257963,'DAILY SALES','2023-02-07','2023-02-07 06:32:58','2023-02-08 06:32:58','610',0.00,0.00,'610','2023-02-07 19:56:27','610','2023-02-07 19:56:48',10,0),('1','177',257964,'DAILY SALES SHIFT','2023-02-08','2023-02-08 07:40:24','2023-02-09 07:40:24','610',0.00,0.00,'610','2023-02-08 13:30:11','610','2023-02-08 13:31:40',10,0),('1','177',257965,'DAILY SALES SECOND SALES','2023-02-08','2023-02-08 13:50:46','2023-02-09 13:50:46','610',0.00,0.00,'610','2023-02-08 20:08:30','610','2023-02-08 20:08:53',10,0),('1','177',257966,'DAILY SALES','2023-02-09','2023-02-09 06:19:48','2023-02-10 06:19:48','610',0.00,0.00,'610','2023-02-09 20:04:16','610','2023-02-09 20:04:51',10,0),('1','177',257967,'DAILY SALES SHIFT','2023-02-10','2023-02-10 06:09:36','2023-02-11 06:09:36','610',0.00,0.00,'610','2023-02-10 20:00:33','610','2023-02-10 20:02:04',10,0),('1','177',257968,'DAILY SALES SHIFT','2023-02-11','2023-02-11 06:11:44','2023-02-12 06:11:44','610',0.00,0.00,'610','2023-02-11 21:43:51','610','2023-02-11 21:44:12',10,0),('1','177',257969,'DAILY SALES','2023-02-12','2023-02-12 07:02:01','2023-02-13 07:02:01','610',0.00,0.00,'610','2023-02-12 20:29:22','610','2023-02-12 20:29:52',10,0),('1','177',257970,'DAILY SALES','2023-02-13','2023-02-13 06:58:21','2023-02-14 06:58:21','610',0.00,0.00,'610','2023-02-13 17:36:24','610','2023-02-13 17:36:45',10,0),('1','177',257971,'DAILY SALES','2023-02-13','2023-02-13 17:37:04','2023-02-14 17:37:04','610',0.00,0.00,'610','2023-02-13 20:10:29','610','2023-02-13 20:10:50',10,0),('1','177',257972,'DAILY SALES','2023-02-14','2023-02-14 07:30:53','2023-02-15 07:30:53','610',0.00,0.00,'610','2023-02-14 21:05:07','610','2023-02-14 21:05:30',10,0),('1','177',257973,'DAILY SALES','2023-02-15','2023-02-15 06:06:28','2023-02-16 06:06:28','610',0.00,0.00,'610','2023-02-15 19:24:52','610','2023-02-15 19:25:18',10,0),('1','177',257974,'DAILY SALES SHIFT','2023-02-16','2023-02-16 06:29:32','2023-02-17 06:29:32','610',0.00,0.00,'610','2023-02-16 19:39:05','610','2023-02-16 19:39:29',10,0),('1','177',257975,'DAILY SALES','2023-02-17','2023-02-17 06:12:58','2023-02-18 06:12:58','610',0.00,0.00,'610','2023-02-17 21:25:08','610','2023-02-17 21:25:29',10,0),('1','177',257976,'DAILY SALES','2023-02-18','2023-02-18 06:32:25','2023-02-19 06:32:25','610',0.00,0.00,'610','2023-02-18 12:23:45','610','2023-02-18 12:24:22',10,0),('1','177',257977,'DAILY SALES SECOND SALES','2023-02-18','2023-02-18 12:25:05','2023-02-19 12:25:05','610',0.00,0.00,'610','2023-02-18 21:05:32','610','2023-02-18 21:05:54',10,0),('1','177',257978,'DAILY SALES SHIFT','2023-02-19','2023-02-19 06:41:55','2023-02-20 06:41:55','610',0.00,0.00,'610','2023-02-19 22:15:28','610','2023-02-19 22:15:48',10,0),('1','177',257979,'DAILY SALES','2023-02-20','2023-02-20 06:20:35','2023-02-21 06:20:35','610',0.00,0.00,'610','2023-02-20 12:48:32','610','2023-02-20 12:48:51',10,0),('1','177',257980,'DAILY SALES SECOND SALES','2023-02-20','2023-02-20 12:49:11','2023-02-21 12:49:11','610',0.00,0.00,'610','2023-02-20 19:38:38','610','2023-02-20 19:39:24',10,0),('1','177',257981,'DAILY SALES','2023-02-21','2023-02-21 05:50:19','2023-02-22 05:50:19','610',0.00,0.00,'610','2023-02-21 17:40:14','610','2023-02-21 17:40:38',10,0),('1','177',257982,'DAILY SALES SHIFT','2023-03-14','2023-03-14 20:40:49','2023-03-15 20:40:49','610',0.00,0.00,'610','2023-03-14 20:44:45','610','2023-03-14 20:45:06',10,0),('1','177',257983,'DAILY SALES SHIFT','2023-03-15','2023-03-15 06:25:20','2023-03-16 06:25:20','610',0.00,0.00,'610','2023-03-15 19:39:52','610','2023-03-15 19:40:22',10,0),('1','177',257984,'DAILY SALES SHIFT','2023-03-16','2023-03-16 06:26:43','2023-03-17 06:26:43','610',0.00,0.00,'610','2023-03-16 17:30:28','610','2023-03-16 17:31:03',10,0),('1','177',257985,'DAILY SALES SECOND SALES','2023-03-16','2023-03-16 17:31:18','2023-03-17 17:31:18','610',0.00,0.00,'610','2023-03-16 19:44:39','610','2023-03-16 19:45:04',10,0),('1','177',257986,'DAILY SALES','2023-03-17','2023-03-17 06:36:42','2023-03-18 06:36:42','610',0.00,0.00,'610','2023-03-17 20:11:38','610','2023-03-17 20:12:03',10,0),('1','177',257987,'DAILY SALES','2023-03-18','2023-03-18 06:50:53','2023-03-19 06:50:53','610',0.00,0.00,'610','2023-03-18 19:21:53','610','2023-03-18 19:22:16',10,0),('1','177',257988,'DAILY SALES','2023-03-19','2023-03-19 07:13:25','2023-03-20 07:13:25','610',0.00,0.00,'610','2023-03-19 12:00:49','610','2023-03-19 12:01:29',10,0),('1','177',257989,'DAILY SALES SECOND SALES','2023-03-19','2023-03-19 12:05:09','2023-03-20 12:05:09','610',0.00,0.00,'610','2023-03-19 19:06:45','610','2023-03-19 19:38:47',10,0),('1','177',257990,'DAILY SALES','2023-03-20','2023-03-20 07:35:01','2023-03-21 07:35:01','610',0.00,0.00,'610','2023-03-20 21:06:09','610','2023-03-20 21:06:30',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905449 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('1','177','919','185575',3637789,'2716','408',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','185575',3637790,'2717','408',0.00,118.39,0.00,0.00,118.39,42146.84,0.00,0.00,0.00),('1','177','919','185575',3637791,'2718','408',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','185575',3637792,'2719','408',0.00,20.96,0.00,0.00,20.96,7461.76,0.00,0.00,0.00),('1','177','919','185703',3639888,'2716','408',0.00,201.60,0.00,0.00,201.60,71769.60,0.00,0.00,0.00),('1','177','919','185703',3639889,'2717','408',434.38,456.78,0.00,0.00,22.40,7974.40,0.00,0.00,0.00),('1','177','919','185703',3639890,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','185703',3639891,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','185892',3643298,'2716','408',201.60,305.60,0.00,0.00,104.00,37024.00,0.00,0.00,0.00),('1','177','919','185892',3643299,'2717','408',456.78,514.78,0.00,0.00,58.00,20648.00,0.00,0.00,0.00),('1','177','919','185892',3643300,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','185892',3643301,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186122',3647430,'2716','408',305.60,309.81,0.00,0.00,4.21,1498.76,0.00,0.00,0.00),('1','177','919','186122',3647431,'2717','408',514.78,588.49,0.00,0.00,73.71,26240.76,0.00,0.00,0.00),('1','177','919','186122',3647432,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186122',3647433,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186332',3650891,'2716','408',309.81,401.45,0.00,0.00,91.64,32623.84,0.00,0.00,0.00),('1','177','919','186332',3650892,'2717','408',588.49,588.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186332',3650893,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186332',3650894,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186531',3654374,'2716','408',401.45,501.06,0.00,0.00,99.61,35461.16,0.00,0.00,0.00),('1','177','919','186531',3654375,'2717','408',588.49,651.89,0.00,0.00,63.40,22570.40,0.00,0.00,0.00),('1','177','919','186531',3654376,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186531',3654377,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186773',3658432,'2716','408',501.06,501.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186773',3658433,'2717','408',651.89,885.32,0.00,0.00,233.43,83101.08,0.00,0.00,0.00),('1','177','919','186773',3658434,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186773',3658435,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186983',3661961,'2716','408',501.06,501.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186983',3661962,'2717','408',885.32,1094.89,0.00,0.00,209.57,74606.92,0.00,0.00,0.00),('1','177','919','186983',3661963,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','186983',3661964,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187197',3665570,'2716','408',501.06,501.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187197',3665571,'2717','408',1094.89,1389.32,0.00,0.00,294.43,104817.08,0.00,0.00,0.00),('1','177','919','187197',3665572,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187197',3665573,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187339',3668313,'2716','408',501.06,501.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187339',3668314,'2717','408',1389.32,1529.07,0.00,0.00,139.75,49751.00,0.00,0.00,0.00),('1','177','919','187339',3668315,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187339',3668316,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187597',3672746,'2716','408',501.06,517.54,0.00,0.00,16.48,5800.96,0.00,0.00,0.00),('1','177','919','187597',3672747,'2717','408',1529.07,1691.35,0.00,0.00,162.28,57122.56,0.00,0.00,0.00),('1','177','919','187597',3672748,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187597',3672749,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187799',3676439,'2716','408',517.54,565.54,0.00,0.00,48.00,16896.00,0.00,0.00,0.00),('1','177','919','187799',3676440,'2717','408',1691.35,1952.61,0.00,0.00,261.26,91963.52,0.00,0.00,0.00),('1','177','919','187799',3676441,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187799',3676442,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187998',3680008,'2716','408',565.54,565.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187998',3680009,'2717','408',1952.61,1952.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187998',3680010,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','187998',3680011,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188033',3680442,'2716','408',565.54,620.54,0.00,0.00,55.00,19360.00,0.00,0.00,0.00),('1','177','919','188033',3680443,'2717','408',1952.61,2170.03,0.00,0.00,217.42,76531.84,0.00,0.00,0.00),('1','177','919','188033',3680444,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188033',3680445,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188198',3683463,'2716','408',620.54,685.54,0.00,0.00,65.00,22880.00,0.00,0.00,0.00),('1','177','919','188198',3683464,'2717','408',2170.03,2417.81,0.00,0.00,247.78,87218.56,0.00,0.00,0.00),('1','177','919','188198',3683465,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188198',3683466,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188411',3687085,'2716','408',685.54,765.54,0.00,0.00,80.00,28160.00,0.00,0.00,0.00),('1','177','919','188411',3687086,'2717','408',2417.81,2692.93,0.00,0.00,275.12,96842.24,0.00,0.00,0.00),('1','177','919','188411',3687087,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188411',3687088,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188617',3690517,'2716','408',765.54,765.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188617',3690518,'2717','408',2692.93,2961.56,0.00,0.00,268.63,94557.76,0.00,0.00,0.00),('1','177','919','188617',3690519,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188617',3690520,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188797',3693893,'2716','408',765.54,818.54,0.00,0.00,53.00,18656.00,0.00,0.00,0.00),('1','177','919','188797',3693894,'2717','408',2961.56,3245.30,0.00,0.00,283.74,99876.48,0.00,0.00,0.00),('1','177','919','188797',3693895,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','188797',3693896,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189039',3698048,'2716','408',818.54,831.04,0.00,0.00,12.50,4400.00,0.00,0.00,0.00),('1','177','919','189039',3698049,'2717','408',3245.30,3654.28,0.00,0.00,408.98,143960.96,0.00,0.00,0.00),('1','177','919','189039',3698050,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189039',3698051,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189197',3700974,'2716','408',831.04,858.04,0.00,0.00,27.00,9504.00,0.00,0.00,0.00),('1','177','919','189197',3700975,'2717','408',3654.28,3914.97,0.00,0.00,260.69,91762.88,0.00,0.00,0.00),('1','177','919','189197',3700976,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189197',3700977,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189415',3705021,'2716','408',858.04,1058.04,0.00,0.00,200.00,70400.00,0.00,0.00,0.00),('1','177','919','189415',3705022,'2717','408',3914.97,4122.94,0.00,0.00,207.97,73205.44,0.00,0.00,0.00),('1','177','919','189415',3705023,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189415',3705024,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189618',3708474,'2716','408',1058.04,1058.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189618',3708475,'2717','408',4122.94,4272.71,0.00,0.00,149.77,52719.04,0.00,0.00,0.00),('1','177','919','189618',3708476,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189618',3708477,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189966',3714911,'2716','408',1058.04,1058.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189966',3714912,'2717','408',4272.71,4295.31,0.00,0.00,22.60,7955.20,0.00,0.00,0.00),('1','177','919','189966',3714913,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','189966',3714914,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190042',3716315,'2716','408',1058.04,1083.04,0.00,0.00,25.00,8800.00,0.00,0.00,0.00),('1','177','919','190042',3716316,'2717','408',4295.31,4551.47,0.00,0.00,256.16,90168.32,0.00,0.00,0.00),('1','177','919','190042',3716317,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190042',3716318,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190206',3719656,'2716','408',1083.04,1083.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190206',3719657,'2717','408',4551.47,4934.16,0.00,0.00,382.69,134706.88,0.00,0.00,0.00),('1','177','919','190206',3719658,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190206',3719659,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190437',3723806,'2716','408',1083.04,1305.48,0.00,0.00,222.44,78298.88,0.00,0.00,0.00),('1','177','919','190437',3723807,'2717','408',4934.16,5467.11,0.00,0.00,532.95,187598.40,0.00,0.00,0.00),('1','177','919','190437',3723808,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190437',3723809,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190664',3728123,'2716','408',1305.48,1476.48,0.00,0.00,171.00,60192.00,0.00,0.00,0.00),('1','177','919','190664',3728124,'2717','408',5467.11,5917.00,0.00,0.00,449.89,158361.28,0.00,0.00,0.00),('1','177','919','190664',3728125,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190664',3728126,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190888',3732191,'2716','408',1476.48,1476.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190888',3732192,'2717','408',5917.00,6338.79,0.00,0.00,421.79,148470.08,0.00,0.00,0.00),('1','177','919','190888',3732193,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','190888',3732194,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191073',3735450,'2716','408',1476.48,1537.48,0.00,0.00,61.00,21472.00,0.00,0.00,0.00),('1','177','919','191073',3735451,'2717','408',6338.79,6722.05,0.00,0.00,383.26,134907.52,0.00,0.00,0.00),('1','177','919','191073',3735452,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191073',3735453,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191291',3739278,'2716','408',1537.48,1674.63,0.00,0.00,137.15,48276.80,0.00,0.00,0.00),('1','177','919','191291',3739279,'2717','408',6722.05,7170.49,0.00,0.00,448.44,157850.88,0.00,0.00,0.00),('1','177','919','191291',3739280,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191291',3739281,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191492',3742918,'2716','408',1674.63,1724.63,0.00,0.00,50.00,17600.00,0.00,0.00,0.00),('1','177','919','191492',3742919,'2717','408',7170.49,7591.95,0.00,0.00,421.46,148353.92,0.00,0.00,0.00),('1','177','919','191492',3742920,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191492',3742921,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191716',3747252,'2716','408',1724.63,1831.63,0.00,0.00,107.00,37664.00,0.00,0.00,0.00),('1','177','919','191716',3747253,'2717','408',7591.95,8110.26,0.00,0.00,518.31,182445.12,0.00,0.00,0.00),('1','177','919','191716',3747254,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191716',3747255,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191953',3751731,'2716','408',1831.63,1861.63,0.00,0.00,30.00,10560.00,0.00,0.00,0.00),('1','177','919','191953',3751732,'2717','408',8110.26,8357.52,0.00,0.00,247.26,87035.52,0.00,0.00,0.00),('1','177','919','191953',3751733,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','191953',3751734,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192130',3754926,'2716','408',1861.63,1894.63,0.00,0.00,33.00,11616.00,0.00,0.00,0.00),('1','177','919','192130',3754927,'2717','408',8357.52,8556.10,0.00,0.00,198.58,69900.16,0.00,0.00,0.00),('1','177','919','192130',3754928,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192130',3754929,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192344',3758906,'2716','408',1894.63,1974.63,0.00,0.00,80.00,28160.00,0.00,0.00,0.00),('1','177','919','192344',3758907,'2717','408',8556.10,8859.10,0.00,0.00,303.00,106656.00,0.00,0.00,0.00),('1','177','919','192344',3758908,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192344',3758909,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192567',3762876,'2716','408',1974.63,2073.63,0.00,0.00,99.00,34848.00,0.00,0.00,0.00),('1','177','919','192567',3762877,'2717','408',8859.10,9226.94,0.00,0.00,367.84,129479.68,0.00,0.00,0.00),('1','177','919','192567',3762878,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192567',3762879,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192777',3766532,'2716','408',2073.63,2161.13,0.00,0.00,87.50,30800.00,0.00,0.00,0.00),('1','177','919','192777',3766533,'2717','408',9226.94,9744.52,0.00,0.00,517.58,182188.16,0.00,0.00,0.00),('1','177','919','192777',3766534,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192777',3766535,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192957',3769926,'2716','408',2161.13,2235.13,0.00,0.00,74.00,26048.00,0.00,0.00,0.00),('1','177','919','192957',3769927,'2717','408',9744.52,10254.32,0.00,0.00,509.80,179449.60,0.00,0.00,0.00),('1','177','919','192957',3769928,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','192957',3769929,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193157',3773889,'2716','408',2235.13,2328.82,0.00,0.00,93.69,32978.88,0.00,0.00,0.00),('1','177','919','193157',3773890,'2717','408',10254.32,10669.22,0.00,0.00,414.90,146044.80,0.00,0.00,0.00),('1','177','919','193157',3773891,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193157',3773892,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193410',3778854,'2716','408',2328.82,2378.82,0.00,0.00,50.00,17600.00,0.00,0.00,0.00),('1','177','919','193410',3778855,'2717','408',10669.22,10925.63,0.00,0.00,256.41,90256.32,0.00,0.00,0.00),('1','177','919','193410',3778856,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193410',3778857,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193634',3782925,'2716','408',2378.82,2400.82,0.00,0.00,22.00,7744.00,0.00,0.00,0.00),('1','177','919','193634',3782926,'2717','408',10925.63,11281.09,0.00,0.00,355.46,125121.92,0.00,0.00,0.00),('1','177','919','193634',3782927,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193634',3782928,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193857',3786901,'2716','408',2400.82,2432.18,0.00,0.00,31.36,11038.72,0.00,0.00,0.00),('1','177','919','193857',3786902,'2717','408',11281.09,11530.09,0.00,0.00,249.00,87648.00,0.00,0.00,0.00),('1','177','919','193857',3786903,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','193857',3786904,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194093',3791010,'2716','408',2432.18,2465.18,0.00,0.00,33.00,11616.00,0.00,0.00,0.00),('1','177','919','194093',3791011,'2717','408',11530.09,11892.23,0.00,0.00,362.14,127473.28,0.00,0.00,0.00),('1','177','919','194093',3791012,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194093',3791013,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194295',3794868,'2716','408',2465.18,2473.70,0.00,0.00,8.52,2999.04,0.00,0.00,0.00),('1','177','919','194295',3794869,'2717','408',11892.23,12087.17,0.00,0.00,194.94,68618.88,0.00,0.00,0.00),('1','177','919','194295',3794870,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194295',3794871,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194499',3798447,'2716','408',2473.70,2536.20,0.00,0.00,62.50,22000.00,0.00,0.00,0.00),('1','177','919','194499',3798448,'2717','408',12087.17,12710.44,0.00,0.00,623.27,219391.04,0.00,0.00,0.00),('1','177','919','194499',3798449,'2718','408',259.08,259.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194499',3798450,'2719','408',252.93,252.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194678',3801720,'2716','408',2536.20,2536.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194678',3801721,'2717','408',12710.44,12710.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194678',3801722,'2718','408',259.08,283.71,0.00,0.00,24.63,8669.76,0.00,0.00,0.00),('1','177','919','194678',3801723,'2719','408',252.93,476.10,0.00,0.00,223.17,78555.84,0.00,0.00,0.00),('1','177','919','194813',3804449,'2716','408',2536.20,2536.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194813',3804450,'2717','408',12710.44,12824.47,0.00,0.00,114.03,40138.56,0.00,0.00,0.00),('1','177','919','194813',3804451,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194813',3804452,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194887',3805969,'2716','408',2536.20,2556.20,0.00,0.00,20.00,7040.00,0.00,0.00,0.00),('1','177','919','194887',3805970,'2717','408',12824.47,13385.29,0.00,0.00,560.82,197408.64,0.00,0.00,0.00),('1','177','919','194887',3805971,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','194887',3805972,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195088',3809460,'2716','408',2556.20,2621.20,0.00,0.00,65.00,22880.00,0.00,0.00,0.00),('1','177','919','195088',3809461,'2717','408',13385.29,13690.69,0.00,0.00,305.40,107500.80,0.00,0.00,0.00),('1','177','919','195088',3809462,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195088',3809463,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195308',3813410,'2716','408',2621.20,2707.70,0.00,0.00,86.50,30448.00,0.00,0.00,0.00),('1','177','919','195308',3813411,'2717','408',13690.69,14016.26,0.00,0.00,325.57,114600.64,0.00,0.00,0.00),('1','177','919','195308',3813412,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195308',3813413,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195534',3817321,'2716','408',2707.70,2802.70,0.00,0.00,95.00,33440.00,0.00,0.00,0.00),('1','177','919','195534',3817322,'2717','408',14016.26,14520.36,0.00,0.00,504.10,177443.20,0.00,0.00,0.00),('1','177','919','195534',3817323,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195534',3817324,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195793',3821555,'2716','408',2802.70,2943.60,0.00,0.00,140.90,49596.80,0.00,0.00,0.00),('1','177','919','195793',3821556,'2717','408',14520.36,15135.94,0.00,0.00,615.58,216684.16,0.00,0.00,0.00),('1','177','919','195793',3821557,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','195793',3821558,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196020',3825809,'2716','408',2943.60,2943.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196020',3825810,'2717','408',15135.94,15638.23,0.00,0.00,502.29,176806.08,0.00,0.00,0.00),('1','177','919','196020',3825811,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196020',3825812,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196243',3830070,'2716','408',2943.60,2963.60,0.00,0.00,20.00,7040.00,0.00,0.00,0.00),('1','177','919','196243',3830071,'2717','408',15638.23,16140.90,0.00,0.00,502.67,176939.84,0.00,0.00,0.00),('1','177','919','196243',3830072,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196243',3830073,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196467',3834046,'2716','408',2963.60,2966.10,0.00,0.00,2.50,880.00,0.00,0.00,0.00),('1','177','919','196467',3834047,'2717','408',16140.90,16509.18,0.00,0.00,368.28,129634.56,0.00,0.00,0.00),('1','177','919','196467',3834048,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196467',3834049,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196668',3837670,'2716','408',2966.10,3028.60,0.00,0.00,62.50,22000.00,0.00,0.00,0.00),('1','177','919','196668',3837671,'2717','408',16509.18,16992.29,0.00,0.00,483.11,170054.72,0.00,0.00,0.00),('1','177','919','196668',3837672,'2718','408',283.71,283.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196668',3837673,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196885',3841591,'2716','408',3028.60,3028.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','196885',3841592,'2717','408',16992.29,17067.13,0.00,0.00,74.84,26343.68,0.00,0.00,0.00),('1','177','919','196885',3841593,'2718','408',283.71,295.07,0.00,0.00,11.36,3998.72,0.00,0.00,0.00),('1','177','919','196885',3841594,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197038',3844318,'2716','408',3028.60,3051.60,0.00,0.00,23.00,8096.00,0.00,0.00,0.00),('1','177','919','197038',3844319,'2717','408',17067.13,17332.31,0.00,0.00,265.18,93343.36,0.00,0.00,0.00),('1','177','919','197038',3844320,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197038',3844321,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197333',3850020,'2716','408',3051.60,3051.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197333',3850021,'2717','408',17332.31,17596.41,0.00,0.00,264.10,92963.20,0.00,0.00,0.00),('1','177','919','197333',3850022,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197333',3850023,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197336',3850027,'2716','408',3051.60,3051.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197336',3850028,'2717','408',17596.41,17759.50,0.00,0.00,163.09,57407.68,0.00,0.00,0.00),('1','177','919','197336',3850029,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197336',3850030,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197396',3850374,'2716','408',3051.60,3051.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197396',3850375,'2717','408',17759.50,18186.49,0.00,0.00,426.99,150300.48,0.00,0.00,0.00),('1','177','919','197396',3850376,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197396',3850377,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197524',3852540,'2716','408',3051.60,3051.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197524',3852541,'2717','408',18186.49,18632.44,0.00,0.00,445.95,156974.40,0.00,0.00,0.00),('1','177','919','197524',3852542,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197524',3852543,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197885',3859011,'2716','408',3051.60,3087.60,0.00,0.00,36.00,12672.00,0.00,0.00,0.00),('1','177','919','197885',3859012,'2717','408',18632.44,19183.87,0.00,0.00,551.43,194103.36,0.00,0.00,0.00),('1','177','919','197885',3859013,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','197885',3859014,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198131',3863244,'2716','408',3087.60,3143.10,0.00,0.00,55.50,19536.00,0.00,0.00,0.00),('1','177','919','198131',3863245,'2717','408',19183.87,19609.35,0.00,0.00,425.48,149768.96,0.00,0.00,0.00),('1','177','919','198131',3863246,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198131',3863247,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198363',3867212,'2716','408',3143.10,3158.10,0.00,0.00,15.00,5280.00,0.00,0.00,0.00),('1','177','919','198363',3867213,'2717','408',19609.35,19964.24,0.00,0.00,354.89,124921.28,0.00,0.00,0.00),('1','177','919','198363',3867214,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198363',3867215,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198581',3870918,'2716','408',3158.10,3190.36,0.00,0.00,32.26,11355.52,0.00,0.00,0.00),('1','177','919','198581',3870919,'2717','408',19964.24,20557.45,0.00,0.00,593.21,208809.92,0.00,0.00,0.00),('1','177','919','198581',3870920,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198581',3870921,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198784',3874391,'2716','408',3190.36,3282.36,0.00,0.00,92.00,32384.00,0.00,0.00,0.00),('1','177','919','198784',3874392,'2717','408',20557.45,21313.52,0.00,0.00,756.07,266136.64,0.00,0.00,0.00),('1','177','919','198784',3874393,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198784',3874394,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198999',3878077,'2716','408',3282.36,3378.36,0.00,0.00,96.00,33792.00,0.00,0.00,0.00),('1','177','919','198999',3878078,'2717','408',21313.52,21763.35,0.00,0.00,449.83,158340.16,0.00,0.00,0.00),('1','177','919','198999',3878079,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','198999',3878080,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199227',3882128,'2716','408',3378.36,3552.29,0.00,0.00,173.93,61223.36,0.00,0.00,0.00),('1','177','919','199227',3882129,'2717','408',21763.35,22126.87,0.00,0.00,363.52,127959.04,0.00,0.00,0.00),('1','177','919','199227',3882130,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199227',3882131,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199447',3885595,'2716','408',3552.29,3552.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199447',3885596,'2717','408',22126.87,22229.17,0.00,0.00,102.30,36009.60,0.00,0.00,0.00),('1','177','919','199447',3885597,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199447',3885598,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199526',3886984,'2716','408',3552.29,3589.09,0.00,0.00,36.80,12953.60,0.00,0.00,0.00),('1','177','919','199526',3886985,'2717','408',22229.17,22543.75,0.00,0.00,314.58,110732.16,0.00,0.00,0.00),('1','177','919','199526',3886986,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199526',3886987,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199716',3889968,'2716','408',3589.09,3647.59,0.00,0.00,58.50,20592.00,0.00,0.00,0.00),('1','177','919','199716',3889969,'2717','408',22543.75,22989.04,0.00,0.00,445.29,156742.08,0.00,0.00,0.00),('1','177','919','199716',3889970,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199716',3889971,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199901',3892945,'2716','408',3647.59,3772.93,0.00,0.00,125.34,44119.68,0.00,0.00,0.00),('1','177','919','199901',3892946,'2717','408',22989.04,23390.14,0.00,0.00,401.10,141187.20,0.00,0.00,0.00),('1','177','919','199901',3892947,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','199901',3892948,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200134',3897274,'2716','408',3772.93,3812.93,0.00,0.00,40.00,14080.00,0.00,0.00,0.00),('1','177','919','200134',3897275,'2717','408',23390.14,23871.05,0.00,0.00,480.91,169280.32,0.00,0.00,0.00),('1','177','919','200134',3897276,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200134',3897277,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200289',3900196,'2716','408',3812.93,3825.43,0.00,0.00,12.50,4400.00,0.00,0.00,0.00),('1','177','919','200289',3900197,'2717','408',23871.05,24594.79,0.00,0.00,723.74,254756.48,0.00,0.00,0.00),('1','177','919','200289',3900198,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200289',3900199,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200499',3904046,'2716','408',3825.43,3825.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200499',3904047,'2717','408',24594.79,25116.87,0.00,0.00,522.08,183772.16,0.00,0.00,0.00),('1','177','919','200499',3904048,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200499',3904049,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200685',3907440,'2716','408',3825.43,3845.43,0.00,0.00,20.00,7040.00,0.00,0.00,0.00),('1','177','919','200685',3907441,'2717','408',25116.87,25727.27,0.00,0.00,610.40,214860.80,0.00,0.00,0.00),('1','177','919','200685',3907442,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200685',3907443,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200934',3911646,'2716','408',3845.43,3890.40,0.00,0.00,44.97,15829.44,0.00,0.00,0.00),('1','177','919','200934',3911647,'2717','408',25727.27,26173.45,0.00,0.00,446.18,157055.36,0.00,0.00,0.00),('1','177','919','200934',3911648,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','200934',3911649,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201109',3914638,'2716','408',3890.40,3925.40,0.00,0.00,35.00,12320.00,0.00,0.00,0.00),('1','177','919','201109',3914639,'2717','408',26173.45,26719.77,0.00,0.00,546.32,192304.64,0.00,0.00,0.00),('1','177','919','201109',3914640,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201109',3914641,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201337',3918330,'2716','408',3925.40,3945.40,0.00,0.00,20.00,7040.00,0.00,0.00,0.00),('1','177','919','201337',3918331,'2717','408',26719.77,27247.61,0.00,0.00,527.84,185799.68,0.00,0.00,0.00),('1','177','919','201337',3918332,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201337',3918333,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201513',3921611,'2716','408',3945.40,3960.40,0.00,0.00,15.00,5280.00,0.00,0.00,0.00),('1','177','919','201513',3921612,'2717','408',27247.61,27313.10,0.00,0.00,65.49,23052.48,0.00,0.00,0.00),('1','177','919','201513',3921613,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201513',3921614,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201531',3921865,'2716','408',3960.40,4102.40,0.00,0.00,142.00,49984.00,0.00,0.00,0.00),('1','177','919','201531',3921866,'2717','408',27313.10,27721.64,0.00,0.00,408.54,143806.08,0.00,0.00,0.00),('1','177','919','201531',3921867,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201531',3921868,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201778',3926776,'2716','408',4102.40,4132.40,0.00,0.00,30.00,10560.00,0.00,0.00,0.00),('1','177','919','201778',3926777,'2717','408',27721.64,27724.48,0.00,0.00,2.84,999.68,0.00,0.00,0.00),('1','177','919','201778',3926778,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','201778',3926779,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202034',3931668,'2716','408',4132.40,4132.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202034',3931669,'2717','408',27724.48,28316.27,0.00,0.00,591.79,208310.08,0.00,0.00,0.00),('1','177','919','202034',3931670,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202034',3931671,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202234',3934984,'2716','408',4132.40,4262.40,0.00,0.00,130.00,45760.00,0.00,0.00,0.00),('1','177','919','202234',3934985,'2717','408',28316.27,28967.96,0.00,0.00,651.69,229394.88,0.00,0.00,0.00),('1','177','919','202234',3934986,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202234',3934987,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202449',3938678,'2716','408',4262.40,4334.40,0.00,0.00,72.00,25344.00,0.00,0.00,0.00),('1','177','919','202449',3938679,'2717','408',28967.96,29485.25,0.00,0.00,517.29,182086.08,0.00,0.00,0.00),('1','177','919','202449',3938680,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202449',3938681,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202635',3942097,'2716','408',4334.40,4415.40,0.00,0.00,81.00,28512.00,0.00,0.00,0.00),('1','177','919','202635',3942098,'2717','408',29485.25,30036.18,0.00,0.00,550.93,193927.36,0.00,0.00,0.00),('1','177','919','202635',3942099,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202635',3942100,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202863',3946049,'2716','408',4415.40,4630.40,0.00,0.00,215.00,75680.00,0.00,0.00,0.00),('1','177','919','202863',3946050,'2717','408',30036.18,30612.80,0.00,0.00,576.62,202970.24,0.00,0.00,0.00),('1','177','919','202863',3946051,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','202863',3946052,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203140',3951229,'2716','408',4630.40,4630.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203140',3951230,'2717','408',30612.80,31129.96,0.00,0.00,517.16,182040.32,0.00,0.00,0.00),('1','177','919','203140',3951231,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203140',3951232,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203317',3954575,'2716','408',4630.40,4870.40,0.00,0.00,240.00,84480.00,0.00,0.00,0.00),('1','177','919','203317',3954576,'2717','408',31129.96,31782.79,0.00,0.00,652.83,229796.16,0.00,0.00,0.00),('1','177','919','203317',3954577,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203317',3954578,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203519',3958262,'2716','408',4870.40,4870.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203519',3958263,'2717','408',31782.79,32501.29,0.00,0.00,718.50,252912.00,0.00,0.00,0.00),('1','177','919','203519',3958264,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203519',3958265,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203693',3961528,'2716','408',4870.40,4870.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203693',3961529,'2717','408',32501.29,33211.07,0.00,0.00,709.78,249842.56,0.00,0.00,0.00),('1','177','919','203693',3961530,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203693',3961531,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203739',3962140,'2716','408',4870.40,4888.40,0.00,0.00,18.00,6336.00,0.00,0.00,0.00),('1','177','919','203739',3962141,'2717','408',33211.07,33920.04,0.00,0.00,708.97,249557.44,0.00,0.00,0.00),('1','177','919','203739',3962142,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203739',3962143,'2719','408',476.10,476.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203960',3966103,'2716','408',4888.40,4963.40,0.00,0.00,75.00,26400.00,0.00,0.00,0.00),('1','177','919','203960',3966104,'2717','408',33920.04,34122.87,0.00,0.00,202.83,71396.16,0.00,0.00,0.00),('1','177','919','203960',3966105,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','203960',3966106,'2719','408',476.10,827.34,0.00,0.00,351.24,123636.48,0.00,0.00,0.00),('1','177','919','204208',3970528,'2716','408',4963.40,4986.40,0.00,0.00,23.00,8096.00,0.00,0.00,0.00),('1','177','919','204208',3970529,'2717','408',34122.87,34788.96,0.00,0.00,666.09,234463.68,0.00,0.00,0.00),('1','177','919','204208',3970530,'2718','408',295.07,295.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204208',3970531,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204387',3973931,'2716','408',4986.40,4998.90,0.00,0.00,12.50,4400.00,0.00,0.00,0.00),('1','177','919','204387',3973932,'2717','408',34788.96,35185.23,0.00,0.00,396.27,139487.04,0.00,0.00,0.00),('1','177','919','204387',3973933,'2718','408',295.07,463.50,0.00,0.00,168.43,59287.36,0.00,0.00,0.00),('1','177','919','204387',3973934,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204665',3978633,'2716','408',4998.90,5048.90,0.00,0.00,50.00,17600.00,0.00,0.00,0.00),('1','177','919','204665',3978634,'2717','408',35185.23,35736.02,0.00,0.00,550.79,193878.08,0.00,0.00,0.00),('1','177','919','204665',3978635,'2718','408',463.50,463.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204665',3978636,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204838',3981591,'2716','408',5048.90,5051.90,0.00,0.00,3.00,1056.00,0.00,0.00,0.00),('1','177','919','204838',3981592,'2717','408',35736.02,36162.24,0.00,0.00,426.22,150029.44,0.00,0.00,0.00),('1','177','919','204838',3981593,'2718','408',463.50,463.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204838',3981594,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','204948',3983425,'2716','408',5051.90,5112.03,0.00,0.00,60.13,21165.76,0.00,0.00,0.00),('1','177','919','204948',3983426,'2717','408',36162.24,36754.99,0.00,0.00,592.75,208648.00,0.00,0.00,0.00),('1','177','919','204948',3983427,'2718','408',463.50,471.00,0.00,0.00,7.50,2640.00,0.00,0.00,0.00),('1','177','919','204948',3983428,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205048',3985271,'2716','408',5112.03,5117.03,0.00,0.00,5.00,1760.00,0.00,0.00,0.00),('1','177','919','205048',3985272,'2717','408',36754.99,37227.43,0.00,0.00,472.44,166298.88,0.00,0.00,0.00),('1','177','919','205048',3985273,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205048',3985274,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205216',3988587,'2716','408',5117.03,5270.39,0.00,0.00,153.36,53982.72,0.00,0.00,0.00),('1','177','919','205216',3988588,'2717','408',37227.43,37932.32,0.00,0.00,704.89,248121.28,0.00,0.00,0.00),('1','177','919','205216',3988589,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205216',3988590,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205465',3993039,'2716','408',5270.39,5325.39,0.00,0.00,55.00,19360.00,0.00,0.00,0.00),('1','177','919','205465',3993040,'2717','408',37932.32,38687.57,0.00,0.00,755.25,265848.00,0.00,0.00,0.00),('1','177','919','205465',3993041,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205465',3993042,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205713',3997621,'2716','408',5325.39,5556.03,0.00,0.00,230.64,81185.28,0.00,0.00,0.00),('1','177','919','205713',3997622,'2717','408',38687.57,39128.31,0.00,0.00,440.74,155140.48,0.00,0.00,0.00),('1','177','919','205713',3997623,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205713',3997624,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205951',4001662,'2716','408',5556.03,5599.53,0.00,0.00,43.50,15312.00,0.00,0.00,0.00),('1','177','919','205951',4001663,'2717','408',39128.31,39901.56,0.00,0.00,773.25,272184.00,0.00,0.00,0.00),('1','177','919','205951',4001664,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','205951',4001665,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206131',4005004,'2716','408',5599.53,5978.77,0.00,0.00,379.24,133492.48,0.00,0.00,0.00),('1','177','919','206131',4005005,'2717','408',39901.56,40255.33,0.00,0.00,353.77,124527.04,0.00,0.00,0.00),('1','177','919','206131',4005006,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206131',4005007,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206377',4009033,'2716','408',5978.77,6008.77,0.00,0.00,30.00,10560.00,0.00,0.00,0.00),('1','177','919','206377',4009034,'2717','408',40255.33,40786.13,0.00,0.00,530.80,186841.60,0.00,0.00,0.00),('1','177','919','206377',4009035,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206377',4009036,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206466',4010622,'2716','408',6008.77,6029.61,0.00,0.00,20.84,7335.68,0.00,0.00,0.00),('1','177','919','206466',4010623,'2717','408',40786.13,41209.87,0.00,0.00,423.74,149156.48,0.00,0.00,0.00),('1','177','919','206466',4010624,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206466',4010625,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206627',4013429,'2716','408',6029.61,6029.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206627',4013430,'2717','408',41209.87,41768.88,0.00,0.00,559.01,196771.52,0.00,0.00,0.00),('1','177','919','206627',4013431,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206627',4013432,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206792',4016486,'2716','408',6029.61,6037.61,0.00,0.00,8.00,2816.00,0.00,0.00,0.00),('1','177','919','206792',4016487,'2717','408',41768.88,42538.39,0.00,0.00,769.51,270867.52,0.00,0.00,0.00),('1','177','919','206792',4016488,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','206792',4016489,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207037',4020773,'2716','408',6037.61,6106.31,0.00,0.00,68.70,24182.40,0.00,0.00,0.00),('1','177','919','207037',4020774,'2717','408',42538.39,43260.55,0.00,0.00,722.16,254200.32,0.00,0.00,0.00),('1','177','919','207037',4020775,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207037',4020776,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207317',4025811,'2716','408',6106.31,6229.45,0.00,0.00,123.14,43345.28,0.00,0.00,0.00),('1','177','919','207317',4025812,'2717','408',43260.55,43802.49,0.00,0.00,541.94,190762.88,0.00,0.00,0.00),('1','177','919','207317',4025813,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207317',4025814,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207489',4028906,'2716','408',6229.45,6546.22,0.00,0.00,316.77,111503.04,0.00,0.00,0.00),('1','177','919','207489',4028907,'2717','408',43802.49,44304.35,0.00,0.00,501.86,176654.72,0.00,0.00,0.00),('1','177','919','207489',4028908,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207489',4028909,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207718',4032775,'2716','408',6546.22,6646.09,0.00,0.00,99.87,35154.24,0.00,0.00,0.00),('1','177','919','207718',4032776,'2717','408',44304.35,45167.92,0.00,0.00,863.57,303976.64,0.00,0.00,0.00),('1','177','919','207718',4032777,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207718',4032778,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207904',4036064,'2716','408',6646.09,6693.98,0.00,0.00,47.89,16857.28,0.00,0.00,0.00),('1','177','919','207904',4036065,'2717','408',45167.92,45298.68,0.00,0.00,130.76,46027.52,0.00,0.00,0.00),('1','177','919','207904',4036066,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207904',4036067,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207990',4037473,'2716','408',6693.98,7011.10,0.00,0.00,317.12,111626.24,0.00,0.00,0.00),('1','177','919','207990',4037474,'2717','408',45298.68,45804.07,0.00,0.00,505.39,177897.28,0.00,0.00,0.00),('1','177','919','207990',4037475,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','207990',4037476,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208115',4039651,'2716','408',7011.10,7169.77,0.00,0.00,158.67,57755.88,0.00,0.00,0.00),('1','177','919','208115',4039652,'2717','408',45804.07,46372.80,0.00,0.00,568.73,207017.72,0.00,0.00,0.00),('1','177','919','208115',4039653,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208115',4039654,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208323',4043487,'2716','408',7169.77,7523.29,0.00,0.00,353.52,128681.28,0.00,0.00,0.00),('1','177','919','208323',4043488,'2717','408',46372.80,46935.38,0.00,0.00,562.58,204779.12,0.00,0.00,0.00),('1','177','919','208323',4043489,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208323',4043490,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208547',4047438,'2716','408',7523.29,7764.24,0.00,0.00,240.95,87705.80,0.00,0.00,0.00),('1','177','919','208547',4047439,'2717','408',46935.38,47595.34,0.00,0.00,659.96,240225.44,0.00,0.00,0.00),('1','177','919','208547',4047440,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208547',4047441,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208794',4051421,'2716','408',7764.24,8171.12,0.00,0.00,406.88,148104.32,0.00,0.00,0.00),('1','177','919','208794',4051422,'2717','408',47595.34,48075.59,0.00,0.00,480.25,174811.00,0.00,0.00,0.00),('1','177','919','208794',4051423,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','208794',4051424,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209007',4055214,'2716','408',8171.12,8276.50,0.00,0.00,105.38,38358.32,0.00,0.00,0.00),('1','177','919','209007',4055215,'2717','408',48075.59,48557.17,0.00,0.00,481.58,175295.12,0.00,0.00,0.00),('1','177','919','209007',4055216,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209007',4055217,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209205',4058899,'2716','408',8276.50,8448.63,0.00,0.00,172.13,62655.32,0.00,0.00,0.00),('1','177','919','209205',4058900,'2717','408',48557.17,48653.78,0.00,0.00,96.61,35166.04,0.00,0.00,0.00),('1','177','919','209205',4058901,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209205',4058902,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209280',4060047,'2716','408',8448.63,8520.78,0.00,0.00,72.15,26262.60,0.00,0.00,0.00),('1','177','919','209280',4060048,'2717','408',48653.78,49228.40,0.00,0.00,574.62,209161.68,0.00,0.00,0.00),('1','177','919','209280',4060049,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209280',4060050,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209443',4062924,'2716','408',8520.78,8649.78,0.00,0.00,129.00,46956.00,0.00,0.00,0.00),('1','177','919','209443',4062925,'2717','408',49228.40,49906.32,0.00,0.00,677.92,246762.88,0.00,0.00,0.00),('1','177','919','209443',4062926,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209443',4062927,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209632',4066503,'2716','408',8649.78,8813.48,0.00,0.00,163.70,59586.80,0.00,0.00,0.00),('1','177','919','209632',4066504,'2717','408',49906.32,50624.32,0.00,0.00,718.00,261352.00,0.00,0.00,0.00),('1','177','919','209632',4066505,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209632',4066506,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209850',4070323,'2716','408',8813.48,9352.07,0.00,0.00,538.59,196046.76,0.00,0.00,0.00),('1','177','919','209850',4070324,'2717','408',50624.32,51089.16,0.00,0.00,464.84,169201.76,0.00,0.00,0.00),('1','177','919','209850',4070325,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','209850',4070326,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210100',4074753,'2716','408',9352.07,9456.23,0.00,0.00,104.16,40830.72,0.00,0.00,0.00),('1','177','919','210100',4074754,'2717','408',51089.16,52094.88,0.00,0.00,1005.72,394242.24,0.00,0.00,0.00),('1','177','919','210100',4074755,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210100',4074756,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210330',4078667,'2716','408',9456.23,10015.33,0.00,0.00,559.10,219167.20,0.00,0.00,0.00),('1','177','919','210330',4078668,'2717','408',52094.88,52227.32,0.00,0.00,132.44,51916.48,0.00,0.00,0.00),('1','177','919','210330',4078669,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210330',4078670,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210484',4081652,'2716','408',10015.33,10015.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210484',4081653,'2717','408',52227.32,52726.81,0.00,0.00,499.49,195800.08,0.00,0.00,0.00),('1','177','919','210484',4081654,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210484',4081655,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210530',4082334,'2716','408',10015.33,10472.38,0.00,0.00,457.05,179163.60,0.00,0.00,0.00),('1','177','919','210530',4082335,'2717','408',52726.81,53814.25,0.00,0.00,1087.44,426276.48,0.00,0.00,0.00),('1','177','919','210530',4082336,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210530',4082337,'2719','408',827.34,827.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210745',4086138,'2716','408',10472.38,11415.07,0.00,0.00,942.69,369534.48,0.00,0.00,0.00),('1','177','919','210745',4086139,'2717','408',53814.25,54841.37,0.00,0.00,1027.12,402631.04,0.00,0.00,0.00),('1','177','919','210745',4086140,'2718','408',471.00,471.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210745',4086141,'2719','408',827.34,1102.99,0.00,0.00,275.65,108054.80,0.00,0.00,0.00),('1','177','919','210956',4089716,'2716','408',11415.07,11415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','210956',4089717,'2717','408',54841.37,54893.87,0.00,0.00,52.50,20580.00,0.00,0.00,0.00),('1','177','919','210956',4089718,'2718','408',471.00,1341.54,0.00,0.00,870.54,341251.68,0.00,0.00,0.00),('1','177','919','210956',4089719,'2719','408',1102.99,1102.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','211084',4092079,'2716','408',11415.07,11474.18,0.00,0.00,59.11,23171.12,0.00,0.00,0.00),('1','177','919','211084',4092080,'2717','408',54893.87,55431.51,0.00,0.00,537.64,210754.88,0.00,0.00,0.00),('1','177','919','211084',4092081,'2718','408',1341.54,1391.54,0.00,0.00,50.00,19600.00,0.00,0.00,0.00),('1','177','919','211084',4092082,'2719','408',1102.99,1111.92,0.00,0.00,8.93,3500.56,0.00,0.00,0.00),('1','177','919','211182',4093721,'2716','408',11474.18,11694.07,0.00,0.00,219.89,86196.88,0.00,0.00,0.00),('1','177','919','211182',4093722,'2717','408',55431.51,55529.46,0.00,0.00,97.95,38396.40,0.00,0.00,0.00),('1','177','919','211182',4093723,'2718','408',1391.54,1605.78,0.00,0.00,214.24,83982.08,0.00,0.00,0.00),('1','177','919','211182',4093724,'2719','408',1111.92,1727.78,0.00,0.00,615.86,241417.12,0.00,0.00,0.00),('1','177','919','211448',4098519,'2716','408',11694.07,11969.35,0.00,0.00,275.28,107909.76,0.00,0.00,0.00),('1','177','919','211448',4098520,'2717','408',55529.46,55622.93,0.00,0.00,93.47,36640.24,0.00,0.00,0.00),('1','177','919','211448',4098521,'2718','408',1605.78,1737.88,0.00,0.00,132.10,51783.20,0.00,0.00,0.00),('1','177','919','211448',4098522,'2719','408',1727.78,2354.66,0.00,0.00,626.88,245736.96,0.00,0.00,0.00),('1','177','919','211668',4102241,'2716','408',11969.35,11969.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','211668',4102242,'2717','408',55622.93,55828.25,0.00,0.00,205.32,80485.44,0.00,0.00,0.00),('1','177','919','211668',4102243,'2718','408',1737.88,1737.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','211668',4102244,'2719','408',2354.66,2621.81,0.00,0.00,267.15,104722.80,0.00,0.00,0.00),('1','177','919','211811',4104581,'2716','408',11969.35,12017.35,0.00,0.00,48.00,18816.00,0.00,0.00,0.00),('1','177','919','211811',4104582,'2717','408',55828.25,56673.47,0.00,0.00,845.22,331326.24,0.00,0.00,0.00),('1','177','919','211811',4104583,'2718','408',1737.88,1737.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','211811',4104584,'2719','408',2621.81,2621.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212010',4108151,'2716','408',12017.35,12244.63,0.00,0.00,227.28,89093.76,0.00,0.00,0.00),('1','177','919','212010',4108152,'2717','408',56673.47,56979.90,0.00,0.00,306.43,120120.56,0.00,0.00,0.00),('1','177','919','212010',4108153,'2718','408',1737.88,1737.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212010',4108154,'2719','408',2621.81,2948.43,0.00,0.00,326.62,128035.04,0.00,0.00,0.00),('1','177','919','212190',4111501,'2716','408',12244.63,12381.37,0.00,0.00,136.74,53602.08,0.00,0.00,0.00),('1','177','919','212190',4111502,'2717','408',56979.90,56993.92,0.00,0.00,14.02,5495.84,0.00,0.00,0.00),('1','177','919','212190',4111503,'2718','408',1737.88,2053.11,0.00,0.00,315.23,123570.16,0.00,0.00,0.00),('1','177','919','212190',4111504,'2719','408',2948.43,3107.44,0.00,0.00,159.01,62331.92,0.00,0.00,0.00),('1','177','919','212442',4116165,'2716','408',12381.37,12381.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212442',4116166,'2717','408',56993.92,56993.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212442',4116167,'2718','408',2053.11,2053.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212442',4116168,'2719','408',3107.44,4511.76,0.00,0.00,1404.32,550493.44,0.00,0.00,0.00),('1','177','919','212649',4119892,'2716','408',12381.37,12616.09,0.00,0.00,234.72,92010.24,0.00,0.00,0.00),('1','177','919','212649',4119893,'2717','408',56993.92,57065.59,0.00,0.00,71.67,28094.64,0.00,0.00,0.00),('1','177','919','212649',4119894,'2718','408',2053.11,2855.11,0.00,0.00,802.00,314384.00,0.00,0.00,0.00),('1','177','919','212649',4119895,'2719','408',4511.76,5141.38,0.00,0.00,629.62,246811.04,0.00,0.00,0.00),('1','177','919','212681',4120243,'2716','408',12616.09,12704.09,0.00,0.00,88.00,34496.00,0.00,0.00,0.00),('1','177','919','212681',4120244,'2717','408',57065.59,57674.91,0.00,0.00,609.32,238853.44,0.00,0.00,0.00),('1','177','919','212681',4120245,'2718','408',2855.11,2861.11,0.00,0.00,6.00,2352.00,0.00,0.00,0.00),('1','177','919','212681',4120246,'2719','408',5141.38,5428.40,0.00,0.00,287.02,112511.84,0.00,0.00,0.00),('1','177','919','212896',4123975,'2716','408',12704.09,12704.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212896',4123976,'2717','408',57674.91,58148.39,0.00,0.00,473.48,185604.16,0.00,0.00,0.00),('1','177','919','212896',4123977,'2718','408',2861.11,2861.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','212896',4123978,'2719','408',5428.40,5428.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213092',4127582,'2716','408',12704.09,12704.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213092',4127583,'2717','408',58148.39,59550.38,0.00,0.00,1401.99,549580.08,0.00,0.00,0.00),('1','177','919','213092',4127584,'2718','408',2861.11,2861.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213092',4127585,'2719','408',5428.40,5428.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213159',4128518,'2716','408',12704.09,12725.98,0.00,0.00,21.89,8580.88,0.00,0.00,0.00),('1','177','919','213159',4128519,'2717','408',59550.38,59589.93,0.00,0.00,39.55,15503.60,0.00,0.00,0.00),('1','177','919','213159',4128520,'2718','408',2861.11,3592.84,0.00,0.00,731.73,286838.16,0.00,0.00,0.00),('1','177','919','213159',4128521,'2719','408',5428.40,6368.90,0.00,0.00,940.50,368676.00,0.00,0.00,0.00),('1','177','919','213412',4132660,'2716','408',12725.98,12725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213412',4132661,'2717','408',59589.93,59602.43,0.00,0.00,12.50,4900.00,0.00,0.00,0.00),('1','177','919','213412',4132662,'2718','408',3592.84,4150.34,0.00,0.00,557.50,218540.00,0.00,0.00,0.00),('1','177','919','213412',4132663,'2719','408',6368.90,7519.25,0.00,0.00,1150.35,450937.20,0.00,0.00,0.00),('1','177','919','213645',4136602,'2716','408',12725.98,12725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213645',4136603,'2717','408',59602.43,59602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213645',4136604,'2718','408',4150.34,4150.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213645',4136605,'2719','408',7519.25,7912.06,0.00,0.00,392.81,153981.52,0.00,0.00,0.00),('1','177','919','213781',4138961,'2716','408',12725.98,12725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213781',4138962,'2717','408',59602.43,59602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213781',4138963,'2718','408',4150.34,5700.27,0.00,0.00,1549.93,607572.56,0.00,0.00,0.00),('1','177','919','213781',4138964,'2719','408',7912.06,7912.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213926',4141088,'2716','408',12725.98,12725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213926',4141089,'2717','408',59602.43,59602.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','213926',4141090,'2718','408',5700.27,7730.92,0.00,0.00,2030.65,796014.80,0.00,0.00,0.00),('1','177','919','213926',4141091,'2719','408',7912.06,7912.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','214096',4144146,'2716','408',12725.98,12725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','214096',4144147,'2717','408',59602.43,59614.93,0.00,0.00,12.50,4900.00,0.00,0.00,0.00),('1','177','919','214096',4144148,'2718','408',7730.92,9150.40,0.00,0.00,1419.48,556436.16,0.00,0.00,0.00),('1','177','919','214096',4144149,'2719','408',7912.06,7912.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','214357',4148572,'2716','408',12725.98,12725.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','214357',4148573,'2717','408',59614.93,59614.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','214357',4148574,'2718','408',9150.40,9150.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','214357',4148575,'2719','408',7912.06,8996.01,0.00,0.00,1083.95,424908.40,0.00,0.00,0.00),('1','177','919','214556',4151871,'2716','408',12725.98,12842.77,0.00,0.00,116.79,45781.68,0.00,0.00,0.00),('1','177','919','214556',4151872,'2717','408',59614.93,59633.43,0.00,0.00,18.50,7252.00,0.00,0.00,0.00),('1','177','919','214556',4151873,'2718','408',9150.40,10611.45,0.00,0.00,1461.05,572731.60,0.00,0.00,0.00),('1','177','919','214556',4151874,'2719','408',8996.01,9150.16,0.00,0.00,154.15,60426.80,0.00,0.00,0.00),('1','177','919','214784',4155958,'2716','408',12842.77,12955.73,0.00,0.00,112.96,44280.32,0.00,0.00,0.00),('1','177','919','214784',4155959,'2717','408',59633.43,59638.43,0.00,0.00,5.00,1960.00,0.00,0.00,0.00),('1','177','919','214784',4155960,'2718','408',10611.45,11791.27,0.00,0.00,1179.82,462489.44,0.00,0.00,0.00),('1','177','919','214784',4155961,'2719','408',9150.16,9664.61,0.00,0.00,514.45,201664.40,0.00,0.00,0.00),('1','177','919','215003',4159600,'2716','408',12955.73,13093.79,0.00,0.00,138.06,54119.52,0.00,0.00,0.00),('1','177','919','215003',4159601,'2717','408',59638.43,59638.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215003',4159602,'2718','408',11791.27,12066.27,0.00,0.00,275.00,107800.00,0.00,0.00,0.00),('1','177','919','215003',4159603,'2719','408',9664.61,9760.11,0.00,0.00,95.50,37436.00,0.00,0.00,0.00),('1','177','919','215093',4161113,'2716','408',13093.79,13105.79,0.00,0.00,12.00,4704.00,0.00,0.00,0.00),('1','177','919','215093',4161114,'2717','408',59638.43,59638.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215093',4161115,'2718','408',12066.27,12116.27,0.00,0.00,50.00,19600.00,0.00,0.00,0.00),('1','177','919','215093',4161116,'2719','408',9760.11,10628.54,0.00,0.00,868.43,340424.56,0.00,0.00,0.00),('1','177','919','215233',4163568,'2716','408',13105.79,13172.60,0.00,0.00,66.81,27783.44,0.00,0.00,0.00),('1','177','919','215233',4163569,'2717','408',59638.43,59638.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215233',4163570,'2718','408',12116.27,12365.27,0.00,0.00,249.00,97608.00,0.00,0.00,0.00),('1','177','919','215233',4163571,'2719','408',10628.54,10818.19,0.00,0.00,189.65,74342.80,0.00,0.00,0.00),('1','177','919','215296',4164610,'2716','408',13172.60,13306.60,0.00,0.00,134.00,56816.00,0.00,0.00,0.00),('1','177','919','215296',4164611,'2717','408',59638.43,59638.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215296',4164612,'2718','408',12365.27,12450.08,0.00,0.00,84.81,35959.44,0.00,0.00,0.00),('1','177','919','215296',4164613,'2719','408',10818.19,11658.73,0.00,0.00,840.54,356388.96,0.00,0.00,0.00),('1','177','919','215447',4167091,'2716','408',13306.60,13408.66,0.00,0.00,102.06,43273.44,0.00,0.00,0.00),('1','177','919','215447',4167092,'2717','408',59638.43,59650.93,0.00,0.00,12.50,5300.00,0.00,0.00,0.00),('1','177','919','215447',4167093,'2718','408',12450.08,12801.31,0.00,0.00,351.23,148921.52,0.00,0.00,0.00),('1','177','919','215447',4167094,'2719','408',11658.73,12438.99,0.00,0.00,780.26,330830.24,0.00,0.00,0.00),('1','177','919','215677',4171117,'2716','408',13408.66,13783.30,0.00,0.00,374.64,158847.36,0.00,0.00,0.00),('1','177','919','215677',4171118,'2717','408',59650.93,59667.93,0.00,0.00,17.00,7208.00,0.00,0.00,0.00),('1','177','919','215677',4171119,'2718','408',12801.31,13014.94,0.00,0.00,213.63,90579.12,0.00,0.00,0.00),('1','177','919','215677',4171120,'2719','408',12438.99,13186.08,0.00,0.00,747.09,316766.16,0.00,0.00,0.00),('1','177','919','215869',4174516,'2716','408',13783.30,13933.86,0.00,0.00,150.56,63837.44,0.00,0.00,0.00),('1','177','919','215869',4174517,'2717','408',59667.93,59667.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215869',4174518,'2718','408',13014.94,13014.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215869',4174519,'2719','408',13186.08,13186.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','215906',4175062,'2716','408',13933.86,14186.63,0.00,0.00,252.77,107174.48,0.00,0.00,0.00),('1','177','919','215906',4175063,'2717','408',59667.93,59697.65,0.00,0.00,29.72,12601.28,0.00,0.00,0.00),('1','177','919','215906',4175064,'2718','408',13014.94,13484.75,0.00,0.00,469.81,199199.44,0.00,0.00,0.00),('1','177','919','215906',4175065,'2719','408',13186.08,13965.62,0.00,0.00,779.54,330524.96,0.00,0.00,0.00),('1','177','919','216119',4178664,'2716','408',14186.63,14283.31,0.00,0.00,96.68,40992.32,0.00,0.00,0.00),('1','177','919','216119',4178665,'2717','408',59697.65,60147.44,0.00,0.00,449.79,190710.96,0.00,0.00,0.00),('1','177','919','216119',4178666,'2718','408',13484.75,13930.46,0.00,0.00,445.71,188981.04,0.00,0.00,0.00),('1','177','919','216119',4178667,'2719','408',13965.62,14246.12,0.00,0.00,280.50,118932.00,0.00,0.00,0.00),('1','177','919','216334',4182409,'2716','408',14283.31,14320.31,0.00,0.00,37.00,15836.00,0.00,0.00,0.00),('1','177','919','216334',4182410,'2717','408',60147.44,60877.58,0.00,0.00,730.14,312499.92,0.00,0.00,0.00),('1','177','919','216334',4182411,'2718','408',13930.46,14541.53,0.00,0.00,611.07,261537.96,0.00,0.00,0.00),('1','177','919','216334',4182412,'2719','408',14246.12,14278.41,0.00,0.00,32.29,13820.12,0.00,0.00,0.00),('1','177','919','216559',4186312,'2716','408',14320.31,14760.26,0.00,0.00,439.95,188298.60,0.00,0.00,0.00),('1','177','919','216559',4186313,'2717','408',60877.58,60883.58,0.00,0.00,6.00,2568.00,0.00,0.00,0.00),('1','177','919','216559',4186314,'2718','408',14541.53,14668.65,0.00,0.00,127.12,54407.36,0.00,0.00,0.00),('1','177','919','216559',4186315,'2719','408',14278.41,14727.50,0.00,0.00,449.09,192210.52,0.00,0.00,0.00),('1','177','919','216794',4190551,'2716','408',14760.26,14763.76,0.00,0.00,3.50,1498.00,0.00,0.00,0.00),('1','177','919','216794',4190552,'2717','408',60883.58,60976.79,0.00,0.00,93.21,39893.88,0.00,0.00,0.00),('1','177','919','216794',4190553,'2718','408',14668.65,14671.65,0.00,0.00,3.00,1284.00,0.00,0.00,0.00),('1','177','919','216794',4190554,'2719','408',14727.50,14960.94,0.00,0.00,233.44,99912.32,0.00,0.00,0.00),('1','177','919','216866',4191714,'2716','408',14763.76,14970.60,0.00,0.00,206.84,88527.52,0.00,0.00,0.00),('1','177','919','216866',4191715,'2717','408',60976.79,62169.69,0.00,0.00,1192.90,510561.20,0.00,0.00,0.00),('1','177','919','216866',4191716,'2718','408',14671.65,14732.67,0.00,0.00,61.02,26116.56,0.00,0.00,0.00),('1','177','919','216866',4191717,'2719','408',14960.94,15005.98,0.00,0.00,45.04,19277.12,0.00,0.00,0.00),('1','177','919','217013',4194435,'2716','408',14970.60,15094.27,0.00,0.00,123.67,58372.24,0.00,0.00,0.00),('1','177','919','217013',4194436,'2717','408',62169.69,62848.80,0.00,0.00,679.11,320539.92,0.00,0.00,0.00),('1','177','919','217013',4194437,'2718','408',14732.67,14734.58,0.00,0.00,1.91,901.52,0.00,0.00,0.00),('1','177','919','217013',4194438,'2719','408',15005.98,15064.45,0.00,0.00,58.47,27597.84,0.00,0.00,0.00),('1','177','919','217274',4199334,'2716','408',15094.27,15398.97,0.00,0.00,304.70,143818.40,0.00,0.00,0.00),('1','177','919','217274',4199335,'2717','408',62848.80,62850.92,0.00,0.00,2.12,1000.64,0.00,0.00,0.00),('1','177','919','217274',4199336,'2718','408',14734.58,15460.47,0.00,0.00,725.89,342620.08,0.00,0.00,0.00),('1','177','919','217274',4199337,'2719','408',15064.45,15393.81,0.00,0.00,329.36,155457.92,0.00,0.00,0.00),('1','177','919','217443',4202218,'2716','408',15398.97,15559.08,0.00,0.00,160.11,75571.92,0.00,0.00,0.00),('1','177','919','217443',4202219,'2717','408',62850.92,62850.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','217443',4202220,'2718','408',15460.47,15460.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','217443',4202221,'2719','408',15393.81,15582.86,0.00,0.00,189.05,89231.60,0.00,0.00,0.00),('1','177','919','217507',4203270,'2716','408',15559.08,15954.36,0.00,0.00,395.28,186572.16,0.00,0.00,0.00),('1','177','919','217507',4203271,'2717','408',62850.92,62853.04,0.00,0.00,2.12,1000.64,0.00,0.00,0.00),('1','177','919','217507',4203272,'2718','408',15460.47,15580.97,0.00,0.00,120.50,56876.00,0.00,0.00,0.00),('1','177','919','217507',4203273,'2719','408',15582.86,15973.00,0.00,0.00,390.14,184146.08,0.00,0.00,0.00),('1','177','919','217728',4206955,'2716','408',15954.36,16036.95,0.00,0.00,82.59,38982.48,0.00,0.00,0.00),('1','177','919','217728',4206956,'2717','408',62853.04,63612.28,0.00,0.00,759.24,358361.28,0.00,0.00,0.00),('1','177','919','217728',4206957,'2718','408',15580.97,16328.13,0.00,0.00,747.16,352659.52,0.00,0.00,0.00),('1','177','919','217728',4206958,'2719','408',15973.00,16079.74,0.00,0.00,106.74,50381.28,0.00,0.00,0.00),('1','177','919','217978',4211700,'2716','408',16036.95,16441.14,0.00,0.00,404.19,190777.68,0.00,0.00,0.00),('1','177','919','217978',4211701,'2717','408',63612.28,63625.78,0.00,0.00,13.50,6372.00,0.00,0.00,0.00),('1','177','919','217978',4211702,'2718','408',16328.13,17124.13,0.00,0.00,796.00,375712.00,0.00,0.00,0.00),('1','177','919','217978',4211703,'2719','408',16079.74,16516.87,0.00,0.00,437.13,206325.36,0.00,0.00,0.00),('1','177','919','218231',4215925,'2716','408',16441.14,16500.95,0.00,0.00,59.81,28230.32,0.00,0.00,0.00),('1','177','919','218231',4215926,'2717','408',63625.78,63964.00,0.00,0.00,338.22,159639.84,0.00,0.00,0.00),('1','177','919','218231',4215927,'2718','408',17124.13,17124.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','218231',4215928,'2719','408',16516.87,16753.42,0.00,0.00,236.55,111651.60,0.00,0.00,0.00),('1','177','919','218329',4217614,'2716','408',16500.95,16538.23,0.00,0.00,37.28,17596.16,0.00,0.00,0.00),('1','177','919','218329',4217615,'2717','408',63964.00,64628.60,0.00,0.00,664.60,313691.20,0.00,0.00,0.00),('1','177','919','218329',4217616,'2718','408',17124.13,17172.82,0.00,0.00,48.69,22981.68,0.00,0.00,0.00),('1','177','919','218329',4217617,'2719','408',16753.42,17154.17,0.00,0.00,400.75,189154.00,0.00,0.00,0.00),('1','177','919','218451',4219858,'2716','408',16538.23,16892.01,0.00,0.00,353.78,166984.16,0.00,0.00,0.00),('1','177','919','218451',4219859,'2717','408',64628.60,64668.60,0.00,0.00,40.00,18880.00,0.00,0.00,0.00),('1','177','919','218451',4219860,'2718','408',17172.82,17860.79,0.00,0.00,687.97,324721.84,0.00,0.00,0.00),('1','177','919','218451',4219861,'2719','408',17154.17,17453.32,0.00,0.00,299.15,141198.80,0.00,0.00,0.00),('1','177','919','218682',4224042,'2716','408',16892.01,17009.51,0.00,0.00,117.50,55460.00,0.00,0.00,0.00),('1','177','919','218682',4224043,'2717','408',64668.60,65392.05,0.00,0.00,723.45,341468.40,0.00,0.00,0.00),('1','177','919','218682',4224044,'2718','408',17860.79,17980.00,0.00,0.00,119.21,56267.12,0.00,0.00,0.00),('1','177','919','218682',4224045,'2719','408',17453.32,17460.15,0.00,0.00,6.83,3223.76,0.00,0.00,0.00),('1','177','919','218905',4227993,'2716','408',17009.51,17323.90,0.00,0.00,314.39,148392.08,0.00,0.00,0.00),('1','177','919','218905',4227994,'2717','408',65392.05,65404.05,0.00,0.00,12.00,5664.00,0.00,0.00,0.00),('1','177','919','218905',4227995,'2718','408',17980.00,18042.00,0.00,0.00,62.00,29264.00,0.00,0.00,0.00),('1','177','919','218905',4227996,'2719','408',17460.15,18066.53,0.00,0.00,606.38,286211.36,0.00,0.00,0.00),('1','177','919','219124',4231607,'2716','408',17323.90,17377.22,0.00,0.00,53.32,25167.04,0.00,0.00,0.00),('1','177','919','219124',4231608,'2717','408',65404.05,65404.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','219124',4231609,'2718','408',18042.00,18042.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','219124',4231610,'2719','408',18066.53,18115.50,0.00,0.00,48.97,23113.84,0.00,0.00,0.00),('1','177','919','219168',4232206,'2716','408',17377.22,17609.58,0.00,0.00,232.36,109673.92,0.00,0.00,0.00),('1','177','919','219168',4232207,'2717','408',65404.05,65453.32,0.00,0.00,49.27,23255.44,0.00,0.00,0.00),('1','177','919','219168',4232208,'2718','408',18042.00,18152.36,0.00,0.00,110.36,52089.92,0.00,0.00,0.00),('1','177','919','219168',4232209,'2719','408',18115.50,18592.00,0.00,0.00,476.50,224908.00,0.00,0.00,0.00),('1','177','919','219325',4235277,'2716','408',17609.58,17609.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','219325',4235278,'2717','408',65453.32,65594.55,0.00,0.00,141.23,66660.56,0.00,0.00,0.00),('1','177','919','219325',4235279,'2718','408',18152.36,18152.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','219325',4235280,'2719','408',18592.00,18804.70,0.00,0.00,212.70,100394.40,0.00,0.00,0.00),('1','177','919','219471',4237669,'2716','408',17609.58,17629.81,0.00,0.00,20.23,8901.20,0.00,0.00,0.00),('1','177','919','219471',4237670,'2717','408',65594.55,66067.87,0.00,0.00,473.32,208260.80,0.00,0.00,0.00),('1','177','919','219471',4237671,'2718','408',18152.36,18170.86,0.00,0.00,18.50,8140.00,0.00,0.00,0.00),('1','177','919','219471',4237672,'2719','408',18804.70,18856.35,0.00,0.00,51.65,22726.00,0.00,0.00,0.00),('1','177','919','219605',4239875,'2716','408',17629.81,17901.37,0.00,0.00,271.56,119486.40,0.00,0.00,0.00),('1','177','919','219605',4239876,'2717','408',66067.87,66096.37,0.00,0.00,28.50,12540.00,0.00,0.00,0.00),('1','177','919','219605',4239877,'2718','408',18170.86,18713.36,0.00,0.00,542.50,238700.00,0.00,0.00,0.00),('1','177','919','219605',4239878,'2719','408',18856.35,19348.11,0.00,0.00,491.76,216374.40,0.00,0.00,0.00),('1','177','919','219811',4243735,'2716','408',17901.37,18278.05,0.00,0.00,376.68,165739.20,0.00,0.00,0.00),('1','177','919','219811',4243736,'2717','408',66096.37,66120.28,0.00,0.00,23.91,10520.40,0.00,0.00,0.00),('1','177','919','219811',4243737,'2718','408',18713.36,19494.36,0.00,0.00,781.00,343640.00,0.00,0.00,0.00),('1','177','919','219811',4243738,'2719','408',19348.11,19852.77,0.00,0.00,504.66,222050.40,0.00,0.00,0.00),('1','177','919','220055',4248010,'2716','408',18278.05,18304.05,0.00,0.00,26.00,11440.00,0.00,0.00,0.00),('1','177','919','220055',4248011,'2717','408',66120.28,66392.92,0.00,0.00,272.64,119961.60,0.00,0.00,0.00),('1','177','919','220055',4248012,'2718','408',19494.36,19649.36,0.00,0.00,155.00,68200.00,0.00,0.00,0.00),('1','177','919','220055',4248013,'2719','408',19852.77,19948.63,0.00,0.00,95.86,42178.40,0.00,0.00,0.00),('1','177','919','220159',4249901,'2716','408',18304.05,18315.05,0.00,0.00,11.00,4840.00,0.00,0.00,0.00),('1','177','919','220159',4249902,'2717','408',66392.92,66657.96,0.00,0.00,265.04,116617.60,0.00,0.00,0.00),('1','177','919','220159',4249903,'2718','408',19649.36,20347.91,0.00,0.00,698.55,307362.00,0.00,0.00,0.00),('1','177','919','220159',4249904,'2719','408',19948.63,19948.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','220260',4251636,'2716','408',18315.05,18363.48,0.00,0.00,48.43,21309.20,0.00,0.00,0.00),('1','177','919','220260',4251637,'2717','408',66657.96,67648.44,0.00,0.00,990.48,435811.20,0.00,0.00,0.00),('1','177','919','220260',4251638,'2718','408',20347.91,20583.18,0.00,0.00,235.27,103518.80,0.00,0.00,0.00),('1','177','919','220260',4251639,'2719','408',19948.63,20327.80,0.00,0.00,379.17,166834.80,0.00,0.00,0.00),('1','177','919','220463',4255560,'2716','408',18363.48,19006.32,0.00,0.00,642.84,282849.60,0.00,0.00,0.00),('1','177','919','220463',4255561,'2717','408',67648.44,67773.62,0.00,0.00,125.18,55079.20,0.00,0.00,0.00),('1','177','919','220463',4255562,'2718','408',20583.18,21831.12,0.00,0.00,1247.94,549093.60,0.00,0.00,0.00),('1','177','919','220463',4255563,'2719','408',20327.80,20809.93,0.00,0.00,482.13,212137.20,0.00,0.00,0.00),('1','177','919','220692',4259339,'2716','408',19006.32,19166.98,0.00,0.00,160.66,70690.40,0.00,0.00,0.00),('1','177','919','220692',4259340,'2717','408',67773.62,67788.62,0.00,0.00,15.00,6600.00,0.00,0.00,0.00),('1','177','919','220692',4259341,'2718','408',21831.12,21881.12,0.00,0.00,50.00,22000.00,0.00,0.00,0.00),('1','177','919','220692',4259342,'2719','408',20809.93,20872.43,0.00,0.00,62.50,27500.00,0.00,0.00,0.00),('1','177','919','220742',4260055,'2716','408',19166.98,19710.29,0.00,0.00,543.31,239056.40,0.00,0.00,0.00),('1','177','919','220742',4260056,'2717','408',67788.62,67910.71,0.00,0.00,122.09,53719.60,0.00,0.00,0.00),('1','177','919','220742',4260057,'2718','408',21881.12,22189.39,0.00,0.00,308.27,135638.80,0.00,0.00,0.00),('1','177','919','220742',4260058,'2719','408',20872.43,20947.43,0.00,0.00,75.00,33000.00,0.00,0.00,0.00),('1','177','919','220908',4263254,'2716','408',19710.29,19930.43,0.00,0.00,220.14,96861.60,0.00,0.00,0.00),('1','177','919','220908',4263255,'2717','408',67910.71,69103.04,0.00,0.00,1192.33,524625.20,0.00,0.00,0.00),('1','177','919','220908',4263256,'2718','408',22189.39,22279.05,0.00,0.00,89.66,39450.40,0.00,0.00,0.00),('1','177','919','220908',4263257,'2719','408',20947.43,20947.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','221149',4267423,'2716','408',19930.43,20359.22,0.00,0.00,428.79,188667.60,0.00,0.00,0.00),('1','177','919','221149',4267424,'2717','408',69103.04,69278.95,0.00,0.00,175.91,77400.40,0.00,0.00,0.00),('1','177','919','221149',4267425,'2718','408',22279.05,23068.59,0.00,0.00,789.54,347397.60,0.00,0.00,0.00),('1','177','919','221149',4267426,'2719','408',20947.43,21247.43,0.00,0.00,300.00,132000.00,0.00,0.00,0.00),('1','177','919','221402',4271892,'2716','408',20359.22,21119.89,0.00,0.00,760.67,334694.80,0.00,0.00,0.00),('1','177','919','221402',4271893,'2717','408',69278.95,69377.53,0.00,0.00,98.58,43375.20,0.00,0.00,0.00),('1','177','919','221402',4271894,'2718','408',23068.59,23273.51,0.00,0.00,204.92,90164.80,0.00,0.00,0.00),('1','177','919','221402',4271895,'2719','408',21247.43,21250.43,0.00,0.00,3.00,1320.00,0.00,0.00,0.00),('1','177','919','221608',4276013,'2716','408',21119.89,21696.08,0.00,0.00,576.19,267352.16,0.00,0.00,0.00),('1','177','919','221608',4276014,'2717','408',69377.53,69541.15,0.00,0.00,163.62,75919.68,0.00,0.00,0.00),('1','177','919','221608',4276015,'2718','408',23273.51,23538.82,0.00,0.00,265.31,123103.84,0.00,0.00,0.00),('1','177','919','221608',4276016,'2719','408',21250.43,21645.05,0.00,0.00,394.62,183103.68,0.00,0.00,0.00),('1','177','919','221841',4279869,'2716','408',21696.08,21696.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','221841',4279870,'2717','408',69541.15,70491.06,0.00,0.00,949.91,440758.24,0.00,0.00,0.00),('1','177','919','221841',4279871,'2718','408',23538.82,23733.18,0.00,0.00,194.36,90183.04,0.00,0.00,0.00),('1','177','919','221841',4279872,'2719','408',21645.05,21645.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','222071',4284139,'2716','408',21696.08,22653.06,0.00,0.00,956.98,444038.72,0.00,0.00,0.00),('1','177','919','222071',4284140,'2717','408',70491.06,70578.88,0.00,0.00,87.82,40748.48,0.00,0.00,0.00),('1','177','919','222071',4284141,'2718','408',23733.18,24297.39,0.00,0.00,564.21,261793.44,0.00,0.00,0.00),('1','177','919','222071',4284142,'2719','408',21645.05,21993.77,0.00,0.00,348.72,161806.08,0.00,0.00,0.00),('1','177','919','222286',4287656,'2716','408',22653.06,22865.50,0.00,0.00,212.44,98572.16,0.00,0.00,0.00),('1','177','919','222286',4287657,'2717','408',70578.88,70582.12,0.00,0.00,3.24,1503.36,0.00,0.00,0.00),('1','177','919','222286',4287658,'2718','408',24297.39,24407.39,0.00,0.00,110.00,51040.00,0.00,0.00,0.00),('1','177','919','222286',4287659,'2719','408',21993.77,22337.60,0.00,0.00,343.83,159537.12,0.00,0.00,0.00),('1','177','919','222417',4289944,'2716','408',22865.50,22882.32,0.00,0.00,16.82,7804.48,0.00,0.00,0.00),('1','177','919','222417',4289945,'2717','408',70582.12,70585.12,0.00,0.00,3.00,1392.00,0.00,0.00,0.00),('1','177','919','222417',4289946,'2718','408',24407.39,24425.39,0.00,0.00,18.00,8352.00,0.00,0.00,0.00),('1','177','919','222417',4289947,'2719','408',22337.60,22684.60,0.00,0.00,347.00,161008.00,0.00,0.00,0.00),('1','177','919','222524',4291698,'2716','408',22882.32,22941.18,0.00,0.00,58.86,27311.04,0.00,0.00,0.00),('1','177','919','222524',4291699,'2717','408',70585.12,71136.11,0.00,0.00,550.99,255659.36,0.00,0.00,0.00),('1','177','919','222524',4291700,'2718','408',24425.39,24478.70,0.00,0.00,53.31,24735.84,0.00,0.00,0.00),('1','177','919','222524',4291701,'2719','408',22684.60,23695.40,0.00,0.00,1010.80,469011.20,0.00,0.00,0.00),('1','177','919','222726',4295732,'2716','408',22941.18,22941.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','222726',4295733,'2717','408',71136.11,71210.77,0.00,0.00,74.66,34642.24,0.00,0.00,0.00),('1','177','919','222726',4295734,'2718','408',24478.70,24502.70,0.00,0.00,24.00,11136.00,0.00,0.00,0.00),('1','177','919','222726',4295735,'2719','408',23695.40,25369.61,0.00,0.00,1674.21,776833.44,0.00,0.00,0.00),('1','177','919','223029',4301242,'2716','408',22941.18,23010.80,0.00,0.00,69.62,32303.68,0.00,0.00,0.00),('1','177','919','223029',4301243,'2717','408',71210.77,71210.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223029',4301244,'2718','408',24502.70,24552.70,0.00,0.00,50.00,23200.00,0.00,0.00,0.00),('1','177','919','223029',4301245,'2719','408',25369.61,25946.43,0.00,0.00,576.82,267644.48,0.00,0.00,0.00),('1','177','919','223073',4302160,'2716','408',23010.80,23108.50,0.00,0.00,97.70,45332.80,0.00,0.00,0.00),('1','177','919','223073',4302161,'2717','408',71210.77,71244.27,0.00,0.00,33.50,15544.00,0.00,0.00,0.00),('1','177','919','223073',4302162,'2718','408',24552.70,24681.20,0.00,0.00,128.50,59624.00,0.00,0.00,0.00),('1','177','919','223073',4302163,'2719','408',25946.43,26524.21,0.00,0.00,577.78,268089.92,0.00,0.00,0.00),('1','177','919','223261',4304893,'2716','408',23108.50,23469.21,0.00,0.00,360.71,167369.44,0.00,0.00,0.00),('1','177','919','223261',4304894,'2717','408',71244.27,71294.24,0.00,0.00,49.97,23186.08,0.00,0.00,0.00),('1','177','919','223261',4304895,'2718','408',24681.20,25006.86,0.00,0.00,325.66,151106.24,0.00,0.00,0.00),('1','177','919','223261',4304896,'2719','408',26524.21,27228.72,0.00,0.00,704.51,326892.64,0.00,0.00,0.00),('1','177','919','223429',4308019,'2716','408',23469.21,23489.87,0.00,0.00,20.66,9586.24,0.00,0.00,0.00),('1','177','919','223429',4308020,'2717','408',71294.24,72026.26,0.00,0.00,732.02,339657.28,0.00,0.00,0.00),('1','177','919','223429',4308021,'2718','408',25006.86,25150.21,0.00,0.00,143.35,66514.40,0.00,0.00,0.00),('1','177','919','223429',4308022,'2719','408',27228.72,27523.00,0.00,0.00,294.28,136545.92,0.00,0.00,0.00),('1','177','919','223628',4311921,'2716','408',23489.87,23498.97,0.00,0.00,9.10,4440.80,0.00,0.00,0.00),('1','177','919','223628',4311922,'2717','408',72026.26,72408.22,0.00,0.00,381.96,186396.48,0.00,0.00,0.00),('1','177','919','223628',4311923,'2718','408',25150.21,25153.21,0.00,0.00,3.00,1464.00,0.00,0.00,0.00),('1','177','919','223628',4311924,'2719','408',27523.00,27610.05,0.00,0.00,87.05,42480.40,0.00,0.00,0.00),('1','177','919','223724',4313427,'2716','408',23498.97,23498.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223724',4313428,'2717','408',72408.22,72408.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223724',4313429,'2718','408',25153.21,25153.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223724',4313430,'2719','408',27610.05,27610.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223728',4313493,'2716','408',23498.97,23585.49,0.00,0.00,86.52,42221.76,0.00,0.00,0.00),('1','177','919','223728',4313494,'2717','408',72408.22,73144.29,0.00,0.00,736.07,359202.16,0.00,0.00,0.00),('1','177','919','223728',4313495,'2718','408',25153.21,25202.71,0.00,0.00,49.50,24156.00,0.00,0.00,0.00),('1','177','919','223728',4313496,'2719','408',27610.05,27810.31,0.00,0.00,200.26,97726.88,0.00,0.00,0.00),('1','177','919','223844',4315952,'2716','408',23585.49,23585.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223844',4315953,'2717','408',73144.29,73144.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223844',4315954,'2718','408',25202.71,25202.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223844',4315955,'2719','408',27810.31,27810.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223902',4316733,'2716','408',23585.49,23888.10,0.00,0.00,302.61,147673.68,0.00,0.00,0.00),('1','177','919','223902',4316734,'2717','408',73144.29,73144.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','223902',4316735,'2718','408',25202.71,25408.79,0.00,0.00,206.08,100567.04,0.00,0.00,0.00),('1','177','919','223902',4316736,'2719','408',27810.31,28404.23,0.00,0.00,593.92,289832.96,0.00,0.00,0.00),('1','177','919','224065',4319783,'2716','408',23888.10,24164.79,0.00,0.00,276.69,135024.72,0.00,0.00,0.00),('1','177','919','224065',4319784,'2717','408',73144.29,73257.39,0.00,0.00,113.10,55192.80,0.00,0.00,0.00),('1','177','919','224065',4319785,'2718','408',25408.79,25647.63,0.00,0.00,238.84,116553.92,0.00,0.00,0.00),('1','177','919','224065',4319786,'2719','408',28404.23,29072.18,0.00,0.00,667.95,325959.60,0.00,0.00,0.00),('1','177','919','224295',4324006,'2716','408',24164.79,24204.55,0.00,0.00,39.76,20198.08,0.00,0.00,0.00),('1','177','919','224295',4324007,'2717','408',73257.39,74150.22,0.00,0.00,892.83,453557.64,0.00,0.00,0.00),('1','177','919','224295',4324008,'2718','408',25647.63,25658.63,0.00,0.00,11.00,5588.00,0.00,0.00,0.00),('1','177','919','224295',4324009,'2719','408',29072.18,29082.18,0.00,0.00,10.00,5080.00,0.00,0.00,0.00),('1','177','919','224535',4327947,'2716','408',24204.55,24314.25,0.00,0.00,109.70,55727.60,0.00,0.00,0.00),('1','177','919','224535',4327948,'2717','408',74150.22,74219.99,0.00,0.00,69.77,35443.16,0.00,0.00,0.00),('1','177','919','224535',4327949,'2718','408',25658.63,25708.63,0.00,0.00,50.00,25400.00,0.00,0.00,0.00),('1','177','919','224535',4327950,'2719','408',29082.18,29322.72,0.00,0.00,240.54,122194.32,0.00,0.00,0.00),('1','177','919','224662',4330155,'2716','408',24314.25,24445.48,0.00,0.00,131.23,66664.84,0.00,0.00,0.00),('1','177','919','224662',4330156,'2717','408',74219.99,74295.62,0.00,0.00,75.63,38420.04,0.00,0.00,0.00),('1','177','919','224662',4330157,'2718','408',25708.63,26008.63,0.00,0.00,300.00,152400.00,0.00,0.00,0.00),('1','177','919','224662',4330158,'2719','408',29322.72,29638.37,0.00,0.00,315.65,160350.20,0.00,0.00,0.00),('1','177','919','224773',4332214,'2716','408',24445.48,24539.20,0.00,0.00,93.72,47609.76,0.00,0.00,0.00),('1','177','919','224773',4332215,'2717','408',74295.62,75252.39,0.00,0.00,956.77,486039.16,0.00,0.00,0.00),('1','177','919','224773',4332216,'2718','408',26008.63,26359.25,0.00,0.00,350.62,178114.96,0.00,0.00,0.00),('1','177','919','224773',4332217,'2719','408',29638.37,29837.94,0.00,0.00,199.57,101381.56,0.00,0.00,0.00),('1','177','919','225001',4336435,'2716','408',24539.20,24820.32,0.00,0.00,281.12,142808.96,0.00,0.00,0.00),('1','177','919','225001',4336436,'2717','408',75252.39,75532.63,0.00,0.00,280.24,142361.92,0.00,0.00,0.00),('1','177','919','225001',4336437,'2718','408',26359.25,27168.34,0.00,0.00,809.09,411017.72,0.00,0.00,0.00),('1','177','919','225001',4336438,'2719','408',29837.94,30234.44,0.00,0.00,396.50,201422.00,0.00,0.00,0.00),('1','177','919','225249',4340904,'2716','408',24820.32,24975.87,0.00,0.00,155.55,79019.40,0.00,0.00,0.00),('1','177','919','225249',4340905,'2717','408',75532.63,75831.44,0.00,0.00,298.81,151795.48,0.00,0.00,0.00),('1','177','919','225249',4340906,'2718','408',27168.34,27564.25,0.00,0.00,395.91,201122.28,0.00,0.00,0.00),('1','177','919','225249',4340907,'2719','408',30234.44,30460.39,0.00,0.00,225.95,114782.60,0.00,0.00,0.00),('1','177','919','225387',4343256,'2716','408',24975.87,25089.67,0.00,0.00,113.80,57810.40,0.00,0.00,0.00),('1','177','919','225387',4343257,'2717','408',75831.44,76025.48,0.00,0.00,194.04,98572.32,0.00,0.00,0.00),('1','177','919','225387',4343258,'2718','408',27564.25,27928.25,0.00,0.00,364.00,184912.00,0.00,0.00,0.00),('1','177','919','225387',4343259,'2719','408',30460.39,30949.12,0.00,0.00,488.73,248274.84,0.00,0.00,0.00),('1','177','919','225480',4345063,'2716','408',25089.67,25610.30,0.00,0.00,520.63,264480.04,0.00,0.00,0.00),('1','177','919','225480',4345064,'2717','408',76025.48,76400.98,0.00,0.00,375.50,190754.00,0.00,0.00,0.00),('1','177','919','225480',4345065,'2718','408',27928.25,28128.10,0.00,0.00,199.85,101523.80,0.00,0.00,0.00),('1','177','919','225480',4345066,'2719','408',30949.12,31139.68,0.00,0.00,190.56,96804.48,0.00,0.00,0.00),('1','177','919','225679',4348583,'2716','408',25610.30,25830.16,0.00,0.00,219.86,111688.88,0.00,0.00,0.00),('1','177','919','225679',4348584,'2717','408',76400.98,77169.58,0.00,0.00,768.60,390448.80,0.00,0.00,0.00),('1','177','919','225679',4348585,'2718','408',28128.10,28562.04,0.00,0.00,433.94,220441.52,0.00,0.00,0.00),('1','177','919','225679',4348586,'2719','408',31139.68,31442.67,0.00,0.00,302.99,153918.92,0.00,0.00,0.00),('1','177','919','226018',4354058,'2716','408',25830.16,25904.97,0.00,0.00,74.81,38901.20,0.00,0.00,0.00),('1','177','919','226018',4354059,'2717','408',77169.58,77274.12,0.00,0.00,104.54,54360.80,0.00,0.00,0.00),('1','177','919','226018',4354060,'2718','408',28562.04,28622.04,0.00,0.00,60.00,31200.00,0.00,0.00,0.00),('1','177','919','226018',4354061,'2719','408',31442.67,32048.02,0.00,0.00,605.35,314782.00,0.00,0.00,0.00),('1','177','919','226106',4355822,'2716','408',25904.97,26040.90,0.00,0.00,135.93,70683.60,0.00,0.00,0.00),('1','177','919','226106',4355823,'2717','408',77274.12,77683.89,0.00,0.00,409.77,213080.40,0.00,0.00,0.00),('1','177','919','226106',4355824,'2718','408',28622.04,28665.54,0.00,0.00,43.50,22620.00,0.00,0.00,0.00),('1','177','919','226106',4355825,'2719','408',32048.02,32212.96,0.00,0.00,164.94,85768.80,0.00,0.00,0.00),('1','177','919','226233',4358377,'2716','408',26040.90,26413.38,0.00,0.00,372.48,193689.60,0.00,0.00,0.00),('1','177','919','226233',4358378,'2717','408',77683.89,78238.31,0.00,0.00,554.42,288298.40,0.00,0.00,0.00),('1','177','919','226233',4358379,'2718','408',28665.54,29125.25,0.00,0.00,459.71,239049.20,0.00,0.00,0.00),('1','177','919','226233',4358380,'2719','408',32212.96,32452.65,0.00,0.00,239.69,124638.80,0.00,0.00,0.00),('1','177','919','226463',4362476,'2716','408',26413.38,26734.95,0.00,0.00,321.57,167216.40,0.00,0.00,0.00),('1','177','919','226463',4362477,'2717','408',78238.31,78448.50,0.00,0.00,210.19,109298.80,0.00,0.00,0.00),('1','177','919','226463',4362478,'2718','408',29125.25,29304.10,0.00,0.00,178.85,93002.00,0.00,0.00,0.00),('1','177','919','226463',4362479,'2719','408',32452.65,32863.36,0.00,0.00,410.71,213569.20,0.00,0.00,0.00),('1','177','919','226749',4367464,'2716','408',26734.95,26909.57,0.00,0.00,174.62,90802.40,0.00,0.00,0.00),('1','177','919','226749',4367465,'2717','408',78448.50,79036.62,0.00,0.00,588.12,305822.40,0.00,0.00,0.00),('1','177','919','226749',4367466,'2718','408',29304.10,29454.02,0.00,0.00,149.92,77958.40,0.00,0.00,0.00),('1','177','919','226749',4367467,'2719','408',32863.36,33300.22,0.00,0.00,436.86,227167.20,0.00,0.00,0.00),('1','177','919','226944',4371180,'2716','408',26909.57,26960.49,0.00,0.00,50.92,26478.40,0.00,0.00,0.00),('1','177','919','226944',4371181,'2717','408',79036.62,79222.41,0.00,0.00,185.79,96610.80,0.00,0.00,0.00),('1','177','919','226944',4371182,'2718','408',29454.02,29493.14,0.00,0.00,39.12,20342.40,0.00,0.00,0.00),('1','177','919','226944',4371183,'2719','408',33300.22,33366.41,0.00,0.00,66.19,34418.80,0.00,0.00,0.00),('1','177','919','227062',4372935,'2716','408',26960.49,27016.54,0.00,0.00,56.05,29146.00,0.00,0.00,0.00),('1','177','919','227062',4372936,'2717','408',79222.41,79597.74,0.00,0.00,375.33,195171.60,0.00,0.00,0.00),('1','177','919','227062',4372937,'2718','408',29493.14,29879.07,0.00,0.00,385.93,200683.60,0.00,0.00,0.00),('1','177','919','227062',4372938,'2719','408',33366.41,33790.77,0.00,0.00,424.36,220667.20,0.00,0.00,0.00),('1','177','919','227181',4375237,'2716','408',27016.54,27196.90,0.00,0.00,180.36,93787.20,0.00,0.00,0.00),('1','177','919','227181',4375238,'2717','408',79597.74,80077.04,0.00,0.00,479.30,249236.00,0.00,0.00,0.00),('1','177','919','227181',4375239,'2718','408',29879.07,29977.34,0.00,0.00,98.27,51100.40,0.00,0.00,0.00),('1','177','919','227181',4375240,'2719','408',33790.77,34223.08,0.00,0.00,432.31,224801.20,0.00,0.00,0.00),('1','177','919','227409',4379059,'2716','408',27196.90,27289.95,0.00,0.00,93.05,48386.00,0.00,0.00,0.00),('1','177','919','227409',4379060,'2717','408',80077.04,80489.80,0.00,0.00,412.76,214635.20,0.00,0.00,0.00),('1','177','919','227409',4379061,'2718','408',29977.34,30126.71,0.00,0.00,149.37,77672.40,0.00,0.00,0.00),('1','177','919','227409',4379062,'2719','408',34223.08,34888.64,0.00,0.00,665.56,346091.20,0.00,0.00,0.00),('1','177','919','227597',4382478,'2716','408',27289.95,27459.63,0.00,0.00,169.68,88233.60,0.00,0.00,0.00),('1','177','919','227597',4382479,'2717','408',80489.80,80662.11,0.00,0.00,172.31,89601.20,0.00,0.00,0.00),('1','177','919','227597',4382480,'2718','408',30126.71,30298.71,0.00,0.00,172.00,89440.00,0.00,0.00,0.00),('1','177','919','227597',4382481,'2719','408',34888.64,35541.99,0.00,0.00,653.35,339742.00,0.00,0.00,0.00),('1','177','919','227813',4386391,'2716','408',27459.63,27459.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','227813',4386392,'2717','408',80662.11,80662.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','227813',4386393,'2718','408',30298.71,30298.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','227813',4386394,'2719','408',35541.99,35776.88,0.00,0.00,234.89,122142.80,0.00,0.00,0.00),('1','177','919','227840',4386841,'2716','408',27459.63,27672.84,0.00,0.00,213.21,110869.20,0.00,0.00,0.00),('1','177','919','227840',4386842,'2717','408',80662.11,81049.45,0.00,0.00,387.34,201416.80,0.00,0.00,0.00),('1','177','919','227840',4386843,'2718','408',30298.71,31329.33,0.00,0.00,1030.62,535922.40,0.00,0.00,0.00),('1','177','919','227840',4386844,'2719','408',35776.88,36587.38,0.00,0.00,810.50,421460.00,0.00,0.00,0.00),('1','177','919','228127',4392136,'2716','408',27672.84,28083.52,0.00,0.00,410.68,213553.60,0.00,0.00,0.00),('1','177','919','228127',4392137,'2717','408',81049.45,81644.75,0.00,0.00,595.30,309556.00,0.00,0.00,0.00),('1','177','919','228127',4392138,'2718','408',31329.33,32010.67,0.00,0.00,681.34,354296.80,0.00,0.00,0.00),('1','177','919','228127',4392139,'2719','408',36587.38,37418.38,0.00,0.00,831.00,432120.00,0.00,0.00,0.00),('1','177','919','228351',4396470,'2716','408',28083.52,28421.25,0.00,0.00,337.73,189128.80,0.00,0.00,0.00),('1','177','919','228351',4396471,'2717','408',81644.75,82397.42,0.00,0.00,752.67,421495.20,0.00,0.00,0.00),('1','177','919','228351',4396472,'2718','408',32010.67,32688.56,0.00,0.00,677.89,379618.40,0.00,0.00,0.00),('1','177','919','228351',4396473,'2719','408',37418.38,37538.31,0.00,0.00,119.93,67160.80,0.00,0.00,0.00),('1','177','919','228529',4399844,'2716','408',28421.25,28677.97,0.00,0.00,256.72,143763.20,0.00,0.00,0.00),('1','177','919','228529',4399845,'2717','408',82397.42,83194.92,0.00,0.00,797.50,446600.00,0.00,0.00,0.00),('1','177','919','228529',4399846,'2718','408',32688.56,32959.88,0.00,0.00,271.32,151939.20,0.00,0.00,0.00),('1','177','919','228529',4399847,'2719','408',37538.31,37712.95,0.00,0.00,174.64,97798.40,0.00,0.00,0.00),('1','177','919','228758',4404119,'2716','408',28677.97,28746.06,0.00,0.00,68.09,38130.40,0.00,0.00,0.00),('1','177','919','228758',4404120,'2717','408',83194.92,84577.71,0.00,0.00,1382.79,774362.40,0.00,0.00,0.00),('1','177','919','228758',4404121,'2718','408',32959.88,32989.95,0.00,0.00,30.07,16839.20,0.00,0.00,0.00),('1','177','919','228758',4404122,'2719','408',37712.95,37712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','228938',4407419,'2716','408',28746.06,28792.19,0.00,0.00,46.13,25832.80,0.00,0.00,0.00),('1','177','919','228938',4407420,'2717','408',84577.71,84619.07,0.00,0.00,41.36,23161.60,0.00,0.00,0.00),('1','177','919','228938',4407421,'2718','408',32989.95,32989.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','228938',4407422,'2719','408',37712.95,37712.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','229013',4408832,'2716','408',28792.19,29181.88,0.00,0.00,389.69,218226.40,0.00,0.00,0.00),('1','177','919','229013',4408833,'2717','408',84619.07,85090.54,0.00,0.00,471.47,264023.20,0.00,0.00,0.00),('1','177','919','229013',4408834,'2718','408',32989.95,33165.28,0.00,0.00,175.33,98184.80,0.00,0.00,0.00),('1','177','919','229013',4408835,'2719','408',37712.95,37833.45,0.00,0.00,120.50,67480.00,0.00,0.00,0.00),('1','177','919','229177',4412054,'2716','408',29181.88,29504.11,0.00,0.00,322.23,180448.80,0.00,0.00,0.00),('1','177','919','229177',4412055,'2717','408',85090.54,85872.65,0.00,0.00,782.11,437981.60,0.00,0.00,0.00),('1','177','919','229177',4412056,'2718','408',33165.28,33175.10,0.00,0.00,9.82,5499.20,0.00,0.00,0.00),('1','177','919','229177',4412057,'2719','408',37833.45,38579.54,0.00,0.00,746.09,417810.40,0.00,0.00,0.00),('1','177','919','229411',4416285,'2716','408',29504.11,29798.17,0.00,0.00,294.06,171731.04,0.00,0.00,0.00),('1','177','919','229411',4416286,'2717','408',85872.65,86331.12,0.00,0.00,458.47,267746.48,0.00,0.00,0.00),('1','177','919','229411',4416287,'2718','408',33175.10,33374.10,0.00,0.00,199.00,116216.00,0.00,0.00,0.00),('1','177','919','229411',4416288,'2719','408',38579.54,38933.67,0.00,0.00,354.13,206811.92,0.00,0.00,0.00),('1','177','919','229664',4421204,'2716','408',29798.17,29862.80,0.00,0.00,64.63,37743.92,0.00,0.00,0.00),('1','177','919','229664',4421205,'2717','408',86331.12,86475.96,0.00,0.00,144.84,84586.56,0.00,0.00,0.00),('1','177','919','229664',4421206,'2718','408',33374.10,33424.10,0.00,0.00,50.00,29200.00,0.00,0.00,0.00),('1','177','919','229664',4421207,'2719','408',38933.67,39253.17,0.00,0.00,319.50,186588.00,0.00,0.00,0.00),('1','177','919','229724',4422209,'2716','408',29862.80,29971.00,0.00,0.00,108.20,63188.80,0.00,0.00,0.00),('1','177','919','229724',4422210,'2717','408',86475.96,86722.15,0.00,0.00,246.19,143774.96,0.00,0.00,0.00),('1','177','919','229724',4422211,'2718','408',33424.10,33534.80,0.00,0.00,110.70,64648.80,0.00,0.00,0.00),('1','177','919','229724',4422212,'2719','408',39253.17,39803.41,0.00,0.00,550.24,321340.16,0.00,0.00,0.00),('1','177','919','229873',4425546,'2716','408',29971.00,30352.63,0.00,0.00,381.63,222871.92,0.00,0.00,0.00),('1','177','919','229873',4425547,'2717','408',86722.15,87589.40,0.00,0.00,867.25,506474.00,0.00,0.00,0.00),('1','177','919','229873',4425548,'2718','408',33534.80,33740.25,0.00,0.00,205.45,119982.80,0.00,0.00,0.00),('1','177','919','229873',4425549,'2719','408',39803.41,40179.59,0.00,0.00,376.18,219689.12,0.00,0.00,0.00),('1','177','919','230075',4429256,'2716','408',30352.63,30428.44,0.00,0.00,75.81,44273.04,0.00,0.00,0.00),('1','177','919','230075',4429257,'2717','408',87589.40,87699.80,0.00,0.00,110.40,64473.60,0.00,0.00,0.00),('1','177','919','230075',4429258,'2718','408',33740.25,33814.50,0.00,0.00,74.25,43362.00,0.00,0.00,0.00),('1','177','919','230075',4429259,'2719','408',40179.59,41361.45,0.00,0.00,1181.86,690206.24,0.00,0.00,0.00),('1','177','919','230273',4432979,'2716','408',30428.44,30505.65,0.00,0.00,77.21,45090.64,0.00,0.00,0.00),('1','177','919','230273',4432980,'2717','408',87699.80,87859.56,0.00,0.00,159.76,93299.84,0.00,0.00,0.00),('1','177','919','230273',4432981,'2718','408',33814.50,33815.53,0.00,0.00,1.03,601.52,0.00,0.00,0.00),('1','177','919','230273',4432982,'2719','408',41361.45,42121.67,0.00,0.00,760.22,443968.48,0.00,0.00,0.00),('1','177','919','230473',4436732,'2716','408',30505.65,30516.41,0.00,0.00,10.76,6283.84,0.00,0.00,0.00),('1','177','919','230473',4436733,'2717','408',87859.56,87895.76,0.00,0.00,36.20,21140.80,0.00,0.00,0.00),('1','177','919','230473',4436734,'2718','408',33815.53,33815.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','230473',4436735,'2719','408',42121.67,42238.78,0.00,0.00,117.11,68392.24,0.00,0.00,0.00),('1','177','919','230544',4437745,'2716','408',30516.41,30519.41,0.00,0.00,3.00,1752.00,0.00,0.00,0.00),('1','177','919','230544',4437746,'2717','408',87895.76,88004.34,0.00,0.00,108.58,63410.72,0.00,0.00,0.00),('1','177','919','230544',4437747,'2718','408',33815.53,33889.53,0.00,0.00,74.00,43216.00,0.00,0.00,0.00),('1','177','919','230544',4437748,'2719','408',42238.78,42715.05,0.00,0.00,476.27,278141.68,0.00,0.00,0.00),('1','177','919','230703',4441043,'2716','408',30519.41,30612.58,0.00,0.00,93.17,54411.28,0.00,0.00,0.00),('1','177','919','230703',4441044,'2717','408',88004.34,88130.75,0.00,0.00,126.41,73823.44,0.00,0.00,0.00),('1','177','919','230703',4441045,'2718','408',33889.53,33939.53,0.00,0.00,50.00,29200.00,0.00,0.00,0.00),('1','177','919','230703',4441046,'2719','408',42715.05,42982.18,0.00,0.00,267.13,156003.92,0.00,0.00,0.00),('1','177','919','230780',4442101,'2716','408',30612.58,30836.71,0.00,0.00,224.13,130891.92,0.00,0.00,0.00),('1','177','919','230780',4442102,'2717','408',88130.75,88146.25,0.00,0.00,15.50,9052.00,0.00,0.00,0.00),('1','177','919','230780',4442103,'2718','408',33939.53,33973.03,0.00,0.00,33.50,19564.00,0.00,0.00,0.00),('1','177','919','230780',4442104,'2719','408',42982.18,44281.60,0.00,0.00,1299.42,758861.28,0.00,0.00,0.00),('1','177','919','231050',4446858,'2716','408',30836.71,31126.61,0.00,0.00,289.90,169301.60,0.00,0.00,0.00),('1','177','919','231050',4446859,'2717','408',88146.25,88762.93,0.00,0.00,616.68,360141.12,0.00,0.00,0.00),('1','177','919','231050',4446860,'2718','408',33973.03,33973.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','231050',4446861,'2719','408',44281.60,44465.85,0.00,0.00,184.25,107602.00,0.00,0.00,0.00),('1','177','919','231358',4451720,'2716','408',31126.61,31385.24,0.00,0.00,258.63,151039.92,0.00,0.00,0.00),('1','177','919','231358',4451721,'2717','408',88762.93,88764.64,0.00,0.00,1.71,998.64,0.00,0.00,0.00),('1','177','919','231358',4451722,'2718','408',33973.03,33987.53,0.00,0.00,14.50,8468.00,0.00,0.00,0.00),('1','177','919','231358',4451723,'2719','408',44465.85,45299.14,0.00,0.00,833.29,486641.36,0.00,0.00,0.00),('1','177','919','231565',4455228,'2716','408',31385.24,31501.23,0.00,0.00,115.99,67738.16,0.00,0.00,0.00),('1','177','919','231565',4455229,'2717','408',88764.64,88769.78,0.00,0.00,5.14,3001.76,0.00,0.00,0.00),('1','177','919','231565',4455230,'2718','408',33987.53,34135.53,0.00,0.00,148.00,86432.00,0.00,0.00,0.00),('1','177','919','231565',4455231,'2719','408',45299.14,45653.04,0.00,0.00,353.90,206677.60,0.00,0.00,0.00),('1','177','919','231628',4456356,'2716','408',31501.23,31705.87,0.00,0.00,204.64,119509.76,0.00,0.00,0.00),('1','177','919','231628',4456357,'2717','408',88769.78,89655.18,0.00,0.00,885.40,517073.60,0.00,0.00,0.00),('1','177','919','231628',4456358,'2718','408',34135.53,34191.03,0.00,0.00,55.50,32412.00,0.00,0.00,0.00),('1','177','919','231628',4456359,'2719','408',45653.04,46141.68,0.00,0.00,488.64,285365.76,0.00,0.00,0.00),('1','177','919','231875',4460899,'2716','408',31705.87,32010.23,0.00,0.00,304.36,177746.24,0.00,0.00,0.00),('1','177','919','231875',4460900,'2717','408',89655.18,89753.70,0.00,0.00,98.52,57535.68,0.00,0.00,0.00),('1','177','919','231875',4460901,'2718','408',34191.03,34341.03,0.00,0.00,150.00,87600.00,0.00,0.00,0.00),('1','177','919','231875',4460902,'2719','408',46141.68,47208.87,0.00,0.00,1067.19,623238.96,0.00,0.00,0.00),('1','177','919','232102',4464908,'2716','408',32010.23,32204.46,0.00,0.00,194.23,113430.32,0.00,0.00,0.00),('1','177','919','232102',4464909,'2717','408',89753.70,89753.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232102',4464910,'2718','408',34341.03,34468.03,0.00,0.00,127.00,74168.00,0.00,0.00,0.00),('1','177','919','232102',4464911,'2719','408',47208.87,47843.80,0.00,0.00,634.93,370799.12,0.00,0.00,0.00),('1','177','919','232213',4466902,'2716','408',32204.46,32497.21,0.00,0.00,292.75,170966.00,0.00,0.00,0.00),('1','177','919','232213',4466903,'2717','408',89753.70,89777.91,0.00,0.00,24.21,14138.64,0.00,0.00,0.00),('1','177','919','232213',4466904,'2718','408',34468.03,34912.43,0.00,0.00,444.40,259529.60,0.00,0.00,0.00),('1','177','919','232213',4466905,'2719','408',47843.80,48329.49,0.00,0.00,485.69,283642.96,0.00,0.00,0.00),('1','177','919','232301',4468538,'2716','408',32497.21,32497.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232301',4468539,'2717','408',89777.91,89777.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232301',4468540,'2718','408',34912.43,34912.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232301',4468541,'2719','408',48329.49,48329.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232318',4468780,'2716','408',32497.21,32869.53,0.00,0.00,372.32,217434.88,0.00,0.00,0.00),('1','177','919','232318',4468781,'2717','408',89777.91,90489.98,0.00,0.00,712.07,415848.88,0.00,0.00,0.00),('1','177','919','232318',4468782,'2718','408',34912.43,34967.19,0.00,0.00,54.76,31979.84,0.00,0.00,0.00),('1','177','919','232318',4468783,'2719','408',48329.49,48618.70,0.00,0.00,289.21,168898.64,0.00,0.00,0.00),('1','177','919','232559',4473335,'2716','408',32869.53,32869.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232559',4473336,'2717','408',90489.98,90489.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232559',4473337,'2718','408',34967.19,34967.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232559',4473338,'2719','408',48618.70,48618.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','232573',4473534,'2716','408',32869.53,33552.38,0.00,0.00,682.85,409710.00,0.00,0.00,0.00),('1','177','919','232573',4473535,'2717','408',90489.98,90560.81,0.00,0.00,70.83,42498.00,0.00,0.00,0.00),('1','177','919','232573',4473536,'2718','408',34967.19,35189.69,0.00,0.00,222.50,133500.00,0.00,0.00,0.00),('1','177','919','232573',4473537,'2719','408',48618.70,49140.18,0.00,0.00,521.48,312888.00,0.00,0.00,0.00),('1','177','919','232827',4478037,'2716','408',33552.38,33945.22,0.00,0.00,392.84,235704.00,0.00,0.00,0.00),('1','177','919','232827',4478038,'2717','408',90560.81,90605.64,0.00,0.00,44.83,26898.00,0.00,0.00,0.00),('1','177','919','232827',4478039,'2718','408',35189.69,35272.52,0.00,0.00,82.83,49698.00,0.00,0.00,0.00),('1','177','919','232827',4478040,'2719','408',49140.18,49803.21,0.00,0.00,663.03,397818.00,0.00,0.00,0.00),('1','177','919','233073',4482446,'2716','408',33945.22,33945.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','233073',4482447,'2717','408',90605.64,90605.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','233073',4482448,'2718','408',35272.52,35272.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','233073',4482449,'2719','408',49803.21,49803.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','233107',4482966,'2716','408',33945.22,34250.32,0.00,0.00,305.10,183060.00,0.00,0.00,0.00),('1','177','919','233107',4482967,'2717','408',90605.64,90852.33,0.00,0.00,246.69,148014.00,0.00,0.00,0.00),('1','177','919','233107',4482968,'2718','408',35272.52,35407.52,0.00,0.00,135.00,81000.00,0.00,0.00,0.00),('1','177','919','233107',4482969,'2719','408',49803.21,50184.38,0.00,0.00,381.17,228702.00,0.00,0.00,0.00),('1','177','919','233356',4487561,'2716','408',34250.32,34655.06,0.00,0.00,404.74,252277.68,0.00,0.00,0.00),('1','177','919','233356',4487562,'2717','408',90852.33,90946.02,0.00,0.00,93.69,58162.56,0.00,0.00,0.00),('1','177','919','233356',4487563,'2718','408',35407.52,35434.03,0.00,0.00,26.51,16542.24,0.00,0.00,0.00),('1','177','919','233356',4487564,'2719','408',50184.38,51173.20,0.00,0.00,988.82,617023.68,0.00,0.00,0.00),('1','177','919','233591',4491875,'2716','408',34655.06,34945.19,0.00,0.00,290.13,181041.12,0.00,0.00,0.00),('1','177','919','233591',4491876,'2717','408',90946.02,91005.67,0.00,0.00,59.65,37221.60,0.00,0.00,0.00),('1','177','919','233591',4491877,'2718','408',35434.03,35434.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','233591',4491878,'2719','408',51173.20,52542.57,0.00,0.00,1369.37,854486.88,0.00,0.00,0.00),('1','177','919','233824',4496028,'2716','408',34945.19,35166.31,0.00,0.00,221.12,137978.88,0.00,0.00,0.00),('1','177','919','233824',4496029,'2717','408',91005.67,91328.67,0.00,0.00,323.00,201552.00,0.00,0.00,0.00),('1','177','919','233824',4496030,'2718','408',35434.03,35580.49,0.00,0.00,146.46,91391.04,0.00,0.00,0.00),('1','177','919','233824',4496031,'2719','408',52542.57,53053.75,0.00,0.00,511.18,318976.32,0.00,0.00,0.00),('1','177','919','233987',4498924,'2716','408',35166.31,35191.52,0.00,0.00,25.21,15731.04,0.00,0.00,0.00),('1','177','919','233987',4498925,'2717','408',91328.67,91430.59,0.00,0.00,101.92,63598.08,0.00,0.00,0.00),('1','177','919','233987',4498926,'2718','408',35580.49,35580.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','233987',4498927,'2719','408',53053.75,53101.25,0.00,0.00,47.50,29640.00,0.00,0.00,0.00),('1','177','919','234038',4499742,'2716','408',35191.52,35248.12,0.00,0.00,56.60,35318.40,0.00,0.00,0.00),('1','177','919','234038',4499743,'2717','408',91430.59,91466.51,0.00,0.00,35.92,22414.08,0.00,0.00,0.00),('1','177','919','234038',4499744,'2718','408',35580.49,35631.84,0.00,0.00,51.35,32042.40,0.00,0.00,0.00),('1','177','919','234038',4499745,'2719','408',53101.25,53214.47,0.00,0.00,113.22,70649.28,0.00,0.00,0.00),('1','177','919','234169',4502273,'2716','408',35248.12,35463.62,0.00,0.00,215.50,129300.00,0.00,0.00,0.00),('1','177','919','234169',4502274,'2717','408',91466.51,91527.01,0.00,0.00,60.50,36300.00,0.00,0.00,0.00),('1','177','919','234169',4502275,'2718','408',35631.84,35699.67,0.00,0.00,67.83,40698.00,0.00,0.00,0.00),('1','177','919','234169',4502276,'2719','408',53214.47,53632.32,0.00,0.00,417.85,250710.00,0.00,0.00,0.00),('1','177','919','234292',4504507,'2716','408',35463.62,35476.12,0.00,0.00,12.50,7500.00,0.00,0.00,0.00),('1','177','919','234292',4504508,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','234292',4504509,'2718','408',35699.67,35832.85,0.00,0.00,133.18,79908.00,0.00,0.00,0.00),('1','177','919','234292',4504510,'2719','408',53632.32,54878.15,0.00,0.00,1245.83,747498.00,0.00,0.00,0.00),('1','177','919','234567',4509253,'2716','408',35476.12,35476.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','234567',4509254,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','234567',4509255,'2718','408',35832.85,35981.57,0.00,0.00,148.72,89232.00,0.00,0.00,0.00),('1','177','919','234567',4509256,'2719','408',54878.15,56187.73,0.00,0.00,1309.58,785748.00,0.00,0.00,0.00),('1','177','919','234802',4513603,'2716','408',35476.12,35546.95,0.00,0.00,70.83,42498.00,0.00,0.00,0.00),('1','177','919','234802',4513604,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','234802',4513605,'2718','408',35981.57,36080.90,0.00,0.00,99.33,59598.00,0.00,0.00,0.00),('1','177','919','234802',4513606,'2719','408',56187.73,56968.00,0.00,0.00,780.27,468162.00,0.00,0.00,0.00),('1','177','919','235047',4517939,'2716','408',35546.95,35546.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235047',4517940,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235047',4517941,'2718','408',36080.90,36130.90,0.00,0.00,50.00,30000.00,0.00,0.00,0.00),('1','177','919','235047',4517942,'2719','408',56968.00,58713.87,0.00,0.00,1745.87,1047522.00,0.00,0.00,0.00),('1','177','919','235282',4521901,'2716','408',35546.95,35579.95,0.00,0.00,33.00,19800.00,0.00,0.00,0.00),('1','177','919','235282',4521902,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235282',4521903,'2718','408',36130.90,36403.90,0.00,0.00,273.00,163800.00,0.00,0.00,0.00),('1','177','919','235282',4521904,'2719','408',58713.87,60047.80,0.00,0.00,1333.93,800358.00,0.00,0.00,0.00),('1','177','919','235507',4525884,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235507',4525885,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235507',4525886,'2718','408',36403.90,37084.64,0.00,0.00,680.74,408444.00,0.00,0.00,0.00),('1','177','919','235507',4525887,'2719','408',60047.80,60532.63,0.00,0.00,484.83,290898.00,0.00,0.00,0.00),('1','177','919','235735',4529957,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235735',4529958,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235735',4529959,'2718','408',37084.64,37084.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235735',4529960,'2719','408',60532.63,61027.18,0.00,0.00,494.55,316512.00,0.00,0.00,0.00),('1','177','919','235889',4532383,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235889',4532384,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235889',4532385,'2718','408',37084.64,37137.64,0.00,0.00,53.00,33072.00,0.00,0.00,0.00),('1','177','919','235889',4532386,'2719','408',61027.18,61790.77,0.00,0.00,763.59,476480.16,0.00,0.00,0.00),('1','177','919','235995',4534459,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235995',4534460,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','235995',4534461,'2718','408',37137.64,37148.64,0.00,0.00,11.00,6864.00,0.00,0.00,0.00),('1','177','919','235995',4534462,'2719','408',61790.77,63104.32,0.00,0.00,1313.55,819655.20,0.00,0.00,0.00),('1','177','919','236218',4538531,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236218',4538532,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236218',4538533,'2718','408',37148.64,37231.10,0.00,0.00,82.46,51455.04,0.00,0.00,0.00),('1','177','919','236218',4538534,'2719','408',63104.32,64095.85,0.00,0.00,991.53,618714.72,0.00,0.00,0.00),('1','177','919','236486',4543228,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236486',4543229,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236486',4543230,'2718','408',37231.10,37833.21,0.00,0.00,602.11,375716.64,0.00,0.00,0.00),('1','177','919','236486',4543231,'2719','408',64095.85,65216.01,0.00,0.00,1120.16,698979.84,0.00,0.00,0.00),('1','177','919','236711',4546983,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236711',4546984,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236711',4546985,'2718','408',37833.21,37847.00,0.00,0.00,13.79,8604.96,0.00,0.00,0.00),('1','177','919','236711',4546986,'2719','408',65216.01,65613.56,0.00,0.00,397.55,248071.20,0.00,0.00,0.00),('1','177','919','236811',4548625,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236811',4548626,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236811',4548627,'2718','408',37847.00,37997.43,0.00,0.00,150.43,93868.32,0.00,0.00,0.00),('1','177','919','236811',4548628,'2719','408',65613.56,66397.82,0.00,0.00,784.26,489378.24,0.00,0.00,0.00),('1','177','919','236938',4550981,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236938',4550982,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','236938',4550983,'2718','408',37997.43,38259.74,0.00,0.00,262.31,163681.44,0.00,0.00,0.00),('1','177','919','236938',4550984,'2719','408',66397.82,67801.97,0.00,0.00,1404.15,876189.60,0.00,0.00,0.00),('1','177','919','237150',4554764,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237150',4554765,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237150',4554766,'2718','408',38259.74,38344.87,0.00,0.00,85.13,53121.12,0.00,0.00,0.00),('1','177','919','237150',4554767,'2719','408',67801.97,68950.43,0.00,0.00,1148.46,716639.04,0.00,0.00,0.00),('1','177','919','237362',4558622,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237362',4558623,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237362',4558624,'2718','408',38344.87,38489.77,0.00,0.00,144.90,90417.60,0.00,0.00,0.00),('1','177','919','237362',4558625,'2719','408',68950.43,70224.11,0.00,0.00,1273.68,794776.32,0.00,0.00,0.00),('1','177','919','237588',4562661,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237588',4562662,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237588',4562663,'2718','408',38489.77,38530.77,0.00,0.00,41.00,25584.00,0.00,0.00,0.00),('1','177','919','237588',4562664,'2719','408',70224.11,70381.30,0.00,0.00,157.19,98086.56,0.00,0.00,0.00),('1','177','919','237753',4565234,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237753',4565235,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237753',4565236,'2718','408',38530.77,38530.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237753',4565237,'2719','408',70381.30,70381.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237755',4565244,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237755',4565245,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237755',4565246,'2718','408',38530.77,38628.79,0.00,0.00,98.02,61164.48,0.00,0.00,0.00),('1','177','919','237755',4565247,'2719','408',70381.30,71314.99,0.00,0.00,933.69,582622.56,0.00,0.00,0.00),('1','177','919','237850',4566976,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237850',4566977,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','237850',4566978,'2718','408',38628.79,38964.22,0.00,0.00,335.43,209308.32,0.00,0.00,0.00),('1','177','919','237850',4566979,'2719','408',71314.99,72216.68,0.00,0.00,901.69,562654.56,0.00,0.00,0.00),('1','177','919','238104',4570987,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238104',4570988,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238104',4570989,'2718','408',38964.22,39155.55,0.00,0.00,191.33,119389.92,0.00,0.00,0.00),('1','177','919','238104',4570990,'2719','408',72216.68,73555.93,0.00,0.00,1339.25,835692.00,0.00,0.00,0.00),('1','177','919','238337',4575126,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238337',4575127,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238337',4575128,'2718','408',39155.55,39562.00,0.00,0.00,406.45,253624.80,0.00,0.00,0.00),('1','177','919','238337',4575129,'2719','408',73555.93,74627.86,0.00,0.00,1071.93,668884.32,0.00,0.00,0.00),('1','177','919','238596',4579324,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238596',4579325,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238596',4579326,'2718','408',39562.00,40029.49,0.00,0.00,467.49,291713.76,0.00,0.00,0.00),('1','177','919','238596',4579327,'2719','408',74627.86,75976.60,0.00,0.00,1348.74,841613.76,0.00,0.00,0.00),('1','177','919','238821',4583325,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238821',4583326,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','238821',4583327,'2718','408',40029.49,40535.03,0.00,0.00,505.54,315456.96,0.00,0.00,0.00),('1','177','919','238821',4583328,'2719','408',75976.60,76903.48,0.00,0.00,926.88,578373.12,0.00,0.00,0.00),('1','177','919','239055',4587504,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239055',4587505,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239055',4587506,'2718','408',40535.03,40723.49,0.00,0.00,188.46,117599.04,0.00,0.00,0.00),('1','177','919','239055',4587507,'2719','408',76903.48,78281.48,0.00,0.00,1378.00,859872.00,0.00,0.00,0.00),('1','177','919','239300',4591590,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239300',4591591,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239300',4591592,'2718','408',40723.49,40909.37,0.00,0.00,185.88,115989.12,0.00,0.00,0.00),('1','177','919','239300',4591593,'2719','408',78281.48,78591.63,0.00,0.00,310.15,193533.60,0.00,0.00,0.00),('1','177','919','239402',4593399,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239402',4593400,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239402',4593401,'2718','408',40909.37,41125.28,0.00,0.00,215.91,134727.84,0.00,0.00,0.00),('1','177','919','239402',4593402,'2719','408',78591.63,79485.42,0.00,0.00,893.79,557724.96,0.00,0.00,0.00),('1','177','919','239539',4595634,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239539',4595635,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239539',4595636,'2718','408',41125.28,42181.92,0.00,0.00,1056.64,659343.36,0.00,0.00,0.00),('1','177','919','239539',4595637,'2719','408',79485.42,80527.24,0.00,0.00,1041.82,650095.68,0.00,0.00,0.00),('1','177','919','239742',4599422,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239742',4599423,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239742',4599424,'2718','408',42181.92,42408.08,0.00,0.00,226.16,141123.84,0.00,0.00,0.00),('1','177','919','239742',4599425,'2719','408',80527.24,81879.63,0.00,0.00,1352.39,843891.36,0.00,0.00,0.00),('1','177','919','239990',4603565,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239990',4603566,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','239990',4603567,'2718','408',42408.08,42534.79,0.00,0.00,126.71,79067.04,0.00,0.00,0.00),('1','177','919','239990',4603568,'2719','408',81879.63,82197.77,0.00,0.00,318.14,198519.36,0.00,0.00,0.00),('1','177','919','240072',4605046,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240072',4605047,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240072',4605048,'2718','408',42534.79,42952.51,0.00,0.00,417.72,260657.28,0.00,0.00,0.00),('1','177','919','240072',4605049,'2719','408',82197.77,82832.57,0.00,0.00,634.80,396115.20,0.00,0.00,0.00),('1','177','919','240174',4606935,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240174',4606936,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240174',4606937,'2718','408',42952.51,43393.00,0.00,0.00,440.49,274865.76,0.00,0.00,0.00),('1','177','919','240174',4606938,'2719','408',82832.57,83860.25,0.00,0.00,1027.68,641272.32,0.00,0.00,0.00),('1','177','919','240432',4611141,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240432',4611142,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240432',4611143,'2718','408',43393.00,43563.87,0.00,0.00,170.87,106622.88,0.00,0.00,0.00),('1','177','919','240432',4611144,'2719','408',83860.25,85227.75,0.00,0.00,1367.50,853320.00,0.00,0.00,0.00),('1','177','919','240665',4614689,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240665',4614690,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240665',4614691,'2718','408',43563.87,43999.60,0.00,0.00,435.73,271895.52,0.00,0.00,0.00),('1','177','919','240665',4614692,'2719','408',85227.75,85972.38,0.00,0.00,744.63,464649.12,0.00,0.00,0.00),('1','177','919','240898',4618657,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240898',4618658,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240898',4618659,'2718','408',43999.60,44130.00,0.00,0.00,130.40,81369.60,0.00,0.00,0.00),('1','177','919','240898',4618660,'2719','408',85972.38,86058.25,0.00,0.00,85.87,53582.88,0.00,0.00,0.00),('1','177','919','240948',4619717,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240948',4619718,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','240948',4619719,'2718','408',44130.00,44520.83,0.00,0.00,390.83,243877.92,0.00,0.00,0.00),('1','177','919','240948',4619720,'2719','408',86058.25,87006.60,0.00,0.00,948.35,591770.40,0.00,0.00,0.00),('1','177','919','241200',4624309,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241200',4624310,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241200',4624311,'2718','408',44520.83,44720.64,0.00,0.00,199.81,124681.44,0.00,0.00,0.00),('1','177','919','241200',4624312,'2719','408',87006.60,88449.40,0.00,0.00,1442.80,900307.20,0.00,0.00,0.00),('1','177','919','241469',4628863,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241469',4628864,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241469',4628865,'2718','408',44720.64,44997.32,0.00,0.00,276.68,172648.32,0.00,0.00,0.00),('1','177','919','241469',4628866,'2719','408',88449.40,89626.09,0.00,0.00,1176.69,734254.56,0.00,0.00,0.00),('1','177','919','241712',4633064,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241712',4633065,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241712',4633066,'2718','408',44997.32,45373.33,0.00,0.00,376.01,234630.24,0.00,0.00,0.00),('1','177','919','241712',4633067,'2719','408',89626.09,89914.38,0.00,0.00,288.29,179892.96,0.00,0.00,0.00),('1','177','919','241852',4635146,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241852',4635147,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241852',4635148,'2718','408',45373.33,45759.41,0.00,0.00,386.08,240913.92,0.00,0.00,0.00),('1','177','919','241852',4635149,'2719','408',89914.38,90574.15,0.00,0.00,659.77,411696.48,0.00,0.00,0.00),('1','177','919','241962',4637292,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241962',4637293,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','241962',4637294,'2718','408',45759.41,45863.37,0.00,0.00,103.96,64871.04,0.00,0.00,0.00),('1','177','919','241962',4637295,'2719','408',90574.15,92074.54,0.00,0.00,1500.39,936243.36,0.00,0.00,0.00),('1','177','919','242180',4641292,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242180',4641293,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242180',4641294,'2718','408',45863.37,45957.27,0.00,0.00,93.90,58593.60,0.00,0.00,0.00),('1','177','919','242180',4641295,'2719','408',92074.54,93571.84,0.00,0.00,1497.30,934315.20,0.00,0.00,0.00),('1','177','919','242408',4645281,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242408',4645282,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242408',4645283,'2718','408',45957.27,46266.75,0.00,0.00,309.48,193115.52,0.00,0.00,0.00),('1','177','919','242408',4645284,'2719','408',93571.84,94410.64,0.00,0.00,838.80,523411.20,0.00,0.00,0.00),('1','177','919','242620',4648872,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242620',4648873,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242620',4648874,'2718','408',46266.75,46266.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242620',4648875,'2719','408',94410.64,94611.76,0.00,0.00,201.12,125498.88,0.00,0.00,0.00),('1','177','919','242650',4649503,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242650',4649504,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242650',4649505,'2718','408',46266.75,46851.80,0.00,0.00,585.05,365071.20,0.00,0.00,0.00),('1','177','919','242650',4649506,'2719','408',94611.76,95883.78,0.00,0.00,1272.02,793740.48,0.00,0.00,0.00),('1','177','919','242899',4653679,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242899',4653680,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','242899',4653681,'2718','408',46851.80,46985.61,0.00,0.00,133.81,83497.44,0.00,0.00,0.00),('1','177','919','242899',4653682,'2719','408',95883.78,96880.71,0.00,0.00,996.93,622084.32,0.00,0.00,0.00),('1','177','919','243116',4657533,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243116',4657534,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243116',4657535,'2718','408',46985.61,47013.11,0.00,0.00,27.50,17160.00,0.00,0.00,0.00),('1','177','919','243116',4657536,'2719','408',96880.71,98058.70,0.00,0.00,1177.99,735065.76,0.00,0.00,0.00),('1','177','919','243338',4661540,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243338',4661541,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243338',4661542,'2718','408',47013.11,47086.51,0.00,0.00,73.40,45801.60,0.00,0.00,0.00),('1','177','919','243338',4661543,'2719','408',98058.70,99033.74,0.00,0.00,975.04,608424.96,0.00,0.00,0.00),('1','177','919','243524',4664520,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243524',4664521,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243524',4664522,'2718','408',47086.51,47173.59,0.00,0.00,87.08,54337.92,0.00,0.00,0.00),('1','177','919','243524',4664523,'2719','408',99033.74,99478.71,0.00,0.00,444.97,277661.28,0.00,0.00,0.00),('1','177','919','243574',4665518,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243574',4665519,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243574',4665520,'2718','408',47173.59,47766.73,0.00,0.00,593.14,370119.36,0.00,0.00,0.00),('1','177','919','243574',4665521,'2719','408',99478.71,100826.51,0.00,0.00,1347.80,841027.20,0.00,0.00,0.00),('1','177','919','243807',4669664,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243807',4669665,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','243807',4669666,'2718','408',47766.73,47846.00,0.00,0.00,79.27,49464.48,0.00,0.00,0.00),('1','177','919','243807',4669667,'2719','408',100826.51,101997.53,0.00,0.00,1171.02,730716.48,0.00,0.00,0.00),('1','177','919','244031',4673489,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244031',4673490,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244031',4673491,'2718','408',47846.00,47998.50,0.00,0.00,152.50,95160.00,0.00,0.00,0.00),('1','177','919','244031',4673492,'2719','408',101997.53,103284.63,0.00,0.00,1287.10,803150.40,0.00,0.00,0.00),('1','177','919','244266',4677472,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244266',4677473,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244266',4677474,'2718','408',47998.50,48095.90,0.00,0.00,97.40,60777.60,0.00,0.00,0.00),('1','177','919','244266',4677475,'2719','408',103284.63,103352.05,0.00,0.00,67.42,42070.08,0.00,0.00,0.00),('1','177','919','244383',4679444,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244383',4679445,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244383',4679446,'2718','408',48095.90,48391.48,0.00,0.00,295.58,184441.92,0.00,0.00,0.00),('1','177','919','244383',4679447,'2719','408',103352.05,104774.67,0.00,0.00,1422.62,887714.88,0.00,0.00,0.00),('1','177','919','244495',4681505,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244495',4681506,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244495',4681507,'2718','408',48391.48,48523.98,0.00,0.00,132.50,82680.00,0.00,0.00,0.00),('1','177','919','244495',4681508,'2719','408',104774.67,106120.69,0.00,0.00,1346.02,839916.48,0.00,0.00,0.00),('1','177','919','244731',4685342,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244731',4685343,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244731',4685344,'2718','408',48523.98,48764.40,0.00,0.00,240.42,150022.08,0.00,0.00,0.00),('1','177','919','244731',4685345,'2719','408',106120.69,107288.35,0.00,0.00,1167.66,728619.84,0.00,0.00,0.00),('1','177','919','244953',4689462,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244953',4689463,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','244953',4689464,'2718','408',48764.40,48809.40,0.00,0.00,45.00,27720.00,0.00,0.00,0.00),('1','177','919','244953',4689465,'2719','408',107288.35,107706.58,0.00,0.00,418.23,257729.68,0.00,0.00,0.00),('1','177','919','245087',4691626,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245087',4691627,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245087',4691628,'2718','408',48809.40,49633.43,0.00,0.00,824.03,507602.48,0.00,0.00,0.00),('1','177','919','245087',4691629,'2719','408',107706.58,108340.72,0.00,0.00,634.14,390630.24,0.00,0.00,0.00),('1','177','919','245194',4693645,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245194',4693646,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245194',4693647,'2718','408',49633.43,49777.68,0.00,0.00,144.25,88858.00,0.00,0.00,0.00),('1','177','919','245194',4693648,'2719','408',108340.72,109740.90,0.00,0.00,1400.18,862510.88,0.00,0.00,0.00),('1','177','919','245420',4697552,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245420',4697553,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245420',4697554,'2718','408',49777.68,49869.53,0.00,0.00,91.85,56579.60,0.00,0.00,0.00),('1','177','919','245420',4697555,'2719','408',109740.90,110939.01,0.00,0.00,1198.11,738035.76,0.00,0.00,0.00),('1','177','919','245663',4701760,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245663',4701761,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245663',4701762,'2718','408',49869.53,49878.53,0.00,0.00,9.00,5544.00,0.00,0.00,0.00),('1','177','919','245663',4701763,'2719','408',110939.01,111789.11,0.00,0.00,850.10,523661.60,0.00,0.00,0.00),('1','177','919','245858',4704815,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245858',4704816,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245858',4704817,'2718','408',49878.53,49894.76,0.00,0.00,16.23,9997.68,0.00,0.00,0.00),('1','177','919','245858',4704818,'2719','408',111789.11,112168.02,0.00,0.00,378.91,233408.56,0.00,0.00,0.00),('1','177','919','245890',4705245,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245890',4705246,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245890',4705247,'2718','408',49894.76,49894.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245890',4705248,'2719','408',112168.02,112168.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245921',4705743,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245921',4705744,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','245921',4705745,'2718','408',49894.76,50073.13,0.00,0.00,178.37,109875.92,0.00,0.00,0.00),('1','177','919','245921',4705746,'2719','408',112168.02,113536.42,0.00,0.00,1368.40,842934.40,0.00,0.00,0.00),('1','177','919','246168',4709905,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246168',4709906,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246168',4709907,'2718','408',50073.13,50406.68,0.00,0.00,333.55,205466.80,0.00,0.00,0.00),('1','177','919','246168',4709908,'2719','408',113536.42,114419.55,0.00,0.00,883.13,544008.08,0.00,0.00,0.00),('1','177','919','246437',4714394,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246437',4714395,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246437',4714396,'2718','408',50406.68,50653.87,0.00,0.00,247.19,152269.04,0.00,0.00,0.00),('1','177','919','246437',4714397,'2719','408',114419.55,115990.68,0.00,0.00,1571.13,967816.08,0.00,0.00,0.00),('1','177','919','246686',4718687,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246686',4718688,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246686',4718689,'2718','408',50653.87,50653.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246686',4718690,'2719','408',115990.68,116341.65,0.00,0.00,350.97,216197.52,0.00,0.00,0.00),('1','177','919','246761',4719764,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246761',4719765,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246761',4719766,'2718','408',50653.87,50653.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246761',4719767,'2719','408',116341.65,117828.43,0.00,0.00,1486.78,915856.48,0.00,0.00,0.00),('1','177','919','246917',4722865,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246917',4722866,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','246917',4722867,'2718','408',50653.87,50882.61,0.00,0.00,228.74,140903.84,0.00,0.00,0.00),('1','177','919','246917',4722868,'2719','408',117828.43,119435.34,0.00,0.00,1606.91,989856.56,0.00,0.00,0.00),('1','177','919','247152',4726830,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247152',4726831,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247152',4726832,'2718','408',50882.61,50957.05,0.00,0.00,74.44,45855.04,0.00,0.00,0.00),('1','177','919','247152',4726833,'2719','408',119435.34,120753.30,0.00,0.00,1317.96,811863.36,0.00,0.00,0.00),('1','177','919','247380',4730872,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247380',4730873,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247380',4730874,'2718','408',50957.05,50962.73,0.00,0.00,5.68,3498.88,0.00,0.00,0.00),('1','177','919','247380',4730875,'2719','408',120753.30,120810.16,0.00,0.00,56.86,35025.76,0.00,0.00,0.00),('1','177','919','247454',4731926,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247454',4731927,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247454',4731928,'2718','408',50962.73,51245.94,0.00,0.00,283.21,174457.36,0.00,0.00,0.00),('1','177','919','247454',4731929,'2719','408',120810.16,122149.09,0.00,0.00,1338.93,824780.88,0.00,0.00,0.00),('1','177','919','247651',4735370,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247651',4735371,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247651',4735372,'2718','408',51245.94,51308.82,0.00,0.00,62.88,38734.08,0.00,0.00,0.00),('1','177','919','247651',4735373,'2719','408',122149.09,122612.68,0.00,0.00,463.59,285571.44,0.00,0.00,0.00),('1','177','919','247751',4736999,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247751',4737000,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247751',4737001,'2718','408',51308.82,51490.03,0.00,0.00,181.21,107276.32,0.00,0.00,0.00),('1','177','919','247751',4737002,'2719','408',122612.68,123484.40,0.00,0.00,871.72,516058.24,0.00,0.00,0.00),('1','177','919','247886',4739437,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247886',4739438,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','247886',4739439,'2718','408',51490.03,51693.17,0.00,0.00,203.14,120258.88,0.00,0.00,0.00),('1','177','919','247886',4739440,'2719','408',123484.40,125060.19,0.00,0.00,1575.79,932867.68,0.00,0.00,0.00),('1','177','919','248136',4743648,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248136',4743649,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248136',4743650,'2718','408',51693.17,51843.40,0.00,0.00,150.23,88936.16,0.00,0.00,0.00),('1','177','919','248136',4743651,'2719','408',125060.19,126809.45,0.00,0.00,1749.26,1035561.92,0.00,0.00,0.00),('1','177','919','248391',4747883,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248391',4747884,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248391',4747885,'2718','408',51843.40,52416.14,0.00,0.00,572.74,339062.08,0.00,0.00,0.00),('1','177','919','248391',4747886,'2719','408',126809.45,128216.71,0.00,0.00,1407.26,833097.92,0.00,0.00,0.00),('1','177','919','248624',4751800,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248624',4751801,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248624',4751802,'2718','408',52416.14,52624.14,0.00,0.00,208.00,123136.00,0.00,0.00,0.00),('1','177','919','248624',4751803,'2719','408',128216.71,129431.26,0.00,0.00,1214.55,719013.60,0.00,0.00,0.00),('1','177','919','248741',4753724,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248741',4753725,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248741',4753726,'2718','408',52624.14,52647.39,0.00,0.00,23.25,13764.00,0.00,0.00,0.00),('1','177','919','248741',4753727,'2719','408',129431.26,130137.12,0.00,0.00,705.86,417869.12,0.00,0.00,0.00),('1','177','919','248896',4756276,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248896',4756277,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','248896',4756278,'2718','408',52647.39,52754.95,0.00,0.00,107.56,63675.52,0.00,0.00,0.00),('1','177','919','248896',4756279,'2719','408',130137.12,130941.02,0.00,0.00,803.90,475908.80,0.00,0.00,0.00),('1','177','919','249094',4759755,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249094',4759756,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249094',4759757,'2718','408',52754.95,53053.29,0.00,0.00,298.34,176617.28,0.00,0.00,0.00),('1','177','919','249094',4759758,'2719','408',130941.02,132217.00,0.00,0.00,1275.98,755380.16,0.00,0.00,0.00),('1','177','919','249331',4763823,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249331',4763824,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249331',4763825,'2718','408',53053.29,53345.76,0.00,0.00,292.47,173142.24,0.00,0.00,0.00),('1','177','919','249331',4763826,'2719','408',132217.00,132969.11,0.00,0.00,752.11,445249.12,0.00,0.00,0.00),('1','177','919','249575',4767903,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249575',4767904,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249575',4767905,'2718','408',53345.76,53914.22,0.00,0.00,568.46,336528.32,0.00,0.00,0.00),('1','177','919','249575',4767906,'2719','408',132969.11,133397.18,0.00,0.00,428.07,253417.44,0.00,0.00,0.00),('1','177','919','249772',4771133,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249772',4771134,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249772',4771135,'2718','408',53914.22,54081.87,0.00,0.00,167.65,99248.80,0.00,0.00,0.00),('1','177','919','249772',4771136,'2719','408',133397.18,133515.13,0.00,0.00,117.95,69826.40,0.00,0.00,0.00),('1','177','919','249839',4772379,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249839',4772380,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','249839',4772381,'2718','408',54081.87,54970.22,0.00,0.00,888.35,525903.20,0.00,0.00,0.00),('1','177','919','249839',4772382,'2719','408',133515.13,133824.99,0.00,0.00,309.86,183437.12,0.00,0.00,0.00),('1','177','919','250087',4776461,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250087',4776462,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250087',4776463,'2718','408',54970.22,55468.28,0.00,0.00,498.06,294851.52,0.00,0.00,0.00),('1','177','919','250087',4776464,'2719','408',133824.99,134706.48,0.00,0.00,881.49,521842.08,0.00,0.00,0.00),('1','177','919','250324',4780563,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250324',4780564,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250324',4780565,'2718','408',55468.28,56431.24,0.00,0.00,962.96,570072.32,0.00,0.00,0.00),('1','177','919','250324',4780566,'2719','408',134706.48,135376.18,0.00,0.00,669.70,396462.40,0.00,0.00,0.00),('1','177','919','250555',4784293,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250555',4784294,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250555',4784295,'2718','408',56431.24,56836.18,0.00,0.00,404.94,239724.48,0.00,0.00,0.00),('1','177','919','250555',4784296,'2719','408',135376.18,135624.50,0.00,0.00,248.32,147005.44,0.00,0.00,0.00),('1','177','919','250680',4786349,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250680',4786350,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250680',4786351,'2718','408',56836.18,57134.40,0.00,0.00,298.22,176546.24,0.00,0.00,0.00),('1','177','919','250680',4786352,'2719','408',135624.50,135822.90,0.00,0.00,198.40,117452.80,0.00,0.00,0.00),('1','177','919','250789',4788372,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250789',4788373,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','250789',4788374,'2718','408',57134.40,58279.42,0.00,0.00,1145.02,677851.84,0.00,0.00,0.00),('1','177','919','250789',4788375,'2719','408',135822.90,136765.67,0.00,0.00,942.77,558119.84,0.00,0.00,0.00),('1','177','919','251003',4792274,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251003',4792275,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251003',4792276,'2718','408',58279.42,58737.19,0.00,0.00,457.77,270999.84,0.00,0.00,0.00),('1','177','919','251003',4792277,'2719','408',136765.67,137904.63,0.00,0.00,1138.96,674264.32,0.00,0.00,0.00),('1','177','919','251264',4796747,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251264',4796748,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251264',4796749,'2718','408',58737.19,59126.66,0.00,0.00,389.47,230566.24,0.00,0.00,0.00),('1','177','919','251264',4796750,'2719','408',137904.63,138463.85,0.00,0.00,559.22,331058.24,0.00,0.00,0.00),('1','177','919','251499',4800778,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251499',4800779,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251499',4800780,'2718','408',59126.66,59213.13,0.00,0.00,86.47,51190.24,0.00,0.00,0.00),('1','177','919','251499',4800781,'2719','408',138463.85,138484.08,0.00,0.00,20.23,11976.16,0.00,0.00,0.00),('1','177','919','251559',4801448,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251559',4801449,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251559',4801450,'2718','408',59213.13,59711.09,0.00,0.00,497.96,294792.32,0.00,0.00,0.00),('1','177','919','251559',4801451,'2719','408',138484.08,139369.87,0.00,0.00,885.79,524387.68,0.00,0.00,0.00),('1','177','919','251748',4805290,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251748',4805291,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251748',4805292,'2718','408',59711.09,59814.31,0.00,0.00,103.22,61106.24,0.00,0.00,0.00),('1','177','919','251748',4805293,'2719','408',139369.87,140656.07,0.00,0.00,1286.20,761430.40,0.00,0.00,0.00),('1','177','919','251977',4809178,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251977',4809179,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','251977',4809180,'2718','408',59814.31,60027.24,0.00,0.00,212.93,126054.56,0.00,0.00,0.00),('1','177','919','251977',4809181,'2719','408',140656.07,141862.79,0.00,0.00,1206.72,714378.24,0.00,0.00,0.00),('1','177','919','252225',4813441,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','252225',4813442,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','252225',4813443,'2718','408',60027.24,60294.65,0.00,0.00,267.41,158306.72,0.00,0.00,0.00),('1','177','919','252225',4813444,'2719','408',141862.79,142912.47,0.00,0.00,1049.68,621410.56,0.00,0.00,0.00),('1','177','919','252457',4817721,'2716','408',35579.95,35579.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','252457',4817722,'2717','408',91527.01,91527.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','252457',4817723,'2718','408',60294.65,60417.49,0.00,0.00,122.84,72721.28,0.00,0.00,0.00),('1','177','919','252457',4817724,'2719','408',142912.47,144066.46,0.00,0.00,1153.99,683162.08,0.00,0.00,0.00),('1','177','919','252700',4821903,'2716','408',35579.95,35581.64,0.00,0.00,1.69,1000.48,0.00,0.00,0.00),('1','177','919','252700',4821904,'2717','408',91527.01,91533.77,0.00,0.00,6.76,4001.92,0.00,0.00,0.00),('1','177','919','252700',4821905,'2718','408',60417.49,60495.63,0.00,0.00,78.14,46258.88,0.00,0.00,0.00),('1','177','919','252700',4821906,'2719','408',144066.46,145823.49,0.00,0.00,1757.03,1040161.76,0.00,0.00,0.00),('1','177','919','252957',4826033,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','252957',4826034,'2717','408',91533.77,91545.84,0.00,0.00,12.07,7145.44,0.00,0.00,0.00),('1','177','919','252957',4826035,'2718','408',60495.63,60545.63,0.00,0.00,50.00,29600.00,0.00,0.00,0.00),('1','177','919','252957',4826036,'2719','408',145823.49,146583.20,0.00,0.00,759.71,449748.32,0.00,0.00,0.00),('1','177','919','253116',4828746,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253116',4828747,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253116',4828748,'2718','408',60545.63,60687.52,0.00,0.00,141.89,83998.88,0.00,0.00,0.00),('1','177','919','253116',4828749,'2719','408',146583.20,147145.39,0.00,0.00,562.19,332816.48,0.00,0.00,0.00),('1','177','919','253202',4830219,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253202',4830220,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253202',4830221,'2718','408',60687.52,60966.80,0.00,0.00,279.28,165333.76,0.00,0.00,0.00),('1','177','919','253202',4830222,'2719','408',147145.39,148181.97,0.00,0.00,1036.58,613655.36,0.00,0.00,0.00),('1','177','919','253461',4834636,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253461',4834637,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253461',4834638,'2718','408',60966.80,61088.51,0.00,0.00,121.71,72052.32,0.00,0.00,0.00),('1','177','919','253461',4834639,'2719','408',148181.97,149589.51,0.00,0.00,1407.54,833263.68,0.00,0.00,0.00),('1','177','919','253704',4838701,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253704',4838702,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253704',4838703,'2718','408',61088.51,61765.65,0.00,0.00,677.14,400866.88,0.00,0.00,0.00),('1','177','919','253704',4838704,'2719','408',149589.51,150782.28,0.00,0.00,1192.77,706119.84,0.00,0.00,0.00),('1','177','919','253940',4842984,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253940',4842985,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253940',4842986,'2718','408',61765.65,61765.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253940',4842987,'2719','408',150782.28,150782.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253942',4842995,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253942',4842996,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','253942',4842997,'2718','408',61765.65,62084.11,0.00,0.00,318.46,188528.32,0.00,0.00,0.00),('1','177','919','253942',4842998,'2719','408',150782.28,152284.35,0.00,0.00,1502.07,889225.44,0.00,0.00,0.00),('1','177','919','254180',4847266,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254180',4847267,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254180',4847268,'2718','408',62084.11,62314.11,0.00,0.00,230.00,136160.00,0.00,0.00,0.00),('1','177','919','254180',4847269,'2719','408',152284.35,153707.00,0.00,0.00,1422.65,842208.80,0.00,0.00,0.00),('1','177','919','254429',4851468,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254429',4851469,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254429',4851470,'2718','408',62314.11,62439.11,0.00,0.00,125.00,74000.00,0.00,0.00,0.00),('1','177','919','254429',4851471,'2719','408',153707.00,155384.61,0.00,0.00,1677.61,993145.12,0.00,0.00,0.00),('1','177','919','254687',4856001,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254687',4856002,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254687',4856003,'2718','408',62439.11,62589.12,0.00,0.00,150.01,88805.92,0.00,0.00,0.00),('1','177','919','254687',4856004,'2719','408',155384.61,156793.95,0.00,0.00,1409.34,834329.28,0.00,0.00,0.00),('1','177','919','254928',4860148,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254928',4860149,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','254928',4860150,'2718','408',62589.12,62998.30,0.00,0.00,409.18,242234.56,0.00,0.00,0.00),('1','177','919','254928',4860151,'2719','408',156793.95,158158.83,0.00,0.00,1364.88,808008.96,0.00,0.00,0.00),('1','177','919','255111',4863224,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255111',4863225,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255111',4863226,'2718','408',62998.30,63285.88,0.00,0.00,287.58,170247.36,0.00,0.00,0.00),('1','177','919','255111',4863227,'2719','408',158158.83,158610.19,0.00,0.00,451.36,267205.12,0.00,0.00,0.00),('1','177','919','255175',4864382,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255175',4864383,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255175',4864384,'2718','408',63285.88,63475.07,0.00,0.00,189.19,112000.48,0.00,0.00,0.00),('1','177','919','255175',4864385,'2719','408',158610.19,160414.73,0.00,0.00,1804.54,1068287.68,0.00,0.00,0.00),('1','177','919','255452',4869039,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255452',4869040,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255452',4869041,'2718','408',63475.07,63776.22,0.00,0.00,301.15,178280.80,0.00,0.00,0.00),('1','177','919','255452',4869042,'2719','408',160414.73,161422.29,0.00,0.00,1007.56,596475.52,0.00,0.00,0.00),('1','177','919','255644',4872086,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255644',4872087,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255644',4872088,'2718','408',63776.22,63943.59,0.00,0.00,167.37,99083.04,0.00,0.00,0.00),('1','177','919','255644',4872089,'2719','408',161422.29,161588.06,0.00,0.00,165.77,98135.84,0.00,0.00,0.00),('1','177','919','255702',4873188,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255702',4873189,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255702',4873190,'2718','408',63943.59,64309.79,0.00,0.00,366.20,216790.40,0.00,0.00,0.00),('1','177','919','255702',4873191,'2719','408',161588.06,163010.72,0.00,0.00,1422.66,842214.72,0.00,0.00,0.00),('1','177','919','255928',4876867,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255928',4876868,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255928',4876869,'2718','408',64309.79,64309.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','255928',4876870,'2719','408',163010.72,164359.43,0.00,0.00,1348.71,798436.32,0.00,0.00,0.00),('1','177','919','256208',4881217,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256208',4881218,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256208',4881219,'2718','408',64309.79,64343.34,0.00,0.00,33.55,19861.60,0.00,0.00,0.00),('1','177','919','256208',4881220,'2719','408',164359.43,164480.46,0.00,0.00,121.03,71649.76,0.00,0.00,0.00),('1','177','919','256264',4881928,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256264',4881929,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256264',4881930,'2718','408',64343.34,64410.23,0.00,0.00,66.89,39598.88,0.00,0.00,0.00),('1','177','919','256264',4881931,'2719','408',164480.46,165605.16,0.00,0.00,1124.70,665822.40,0.00,0.00,0.00),('1','177','919','256471',4885919,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256471',4885920,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256471',4885921,'2718','408',64410.23,64879.46,0.00,0.00,469.23,277784.16,0.00,0.00,0.00),('1','177','919','256471',4885922,'2719','408',165605.16,166426.55,0.00,0.00,821.39,486262.88,0.00,0.00,0.00),('1','177','919','256705',4889776,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256705',4889777,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256705',4889778,'2718','408',64879.46,65206.03,0.00,0.00,326.57,193329.44,0.00,0.00,0.00),('1','177','919','256705',4889779,'2719','408',166426.55,167608.64,0.00,0.00,1182.09,699797.28,0.00,0.00,0.00),('1','177','919','256949',4894020,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256949',4894021,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','256949',4894022,'2718','408',65206.03,65231.03,0.00,0.00,25.00,14800.00,0.00,0.00,0.00),('1','177','919','256949',4894023,'2719','408',167608.64,169154.75,0.00,0.00,1546.11,915297.12,0.00,0.00,0.00),('1','177','919','257167',4897943,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257167',4897944,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257167',4897945,'2718','408',65231.03,65231.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257167',4897946,'2719','408',169154.75,169421.86,0.00,0.00,267.11,158129.12,0.00,0.00,0.00),('1','177','919','257221',4898979,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257221',4898980,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257221',4898981,'2718','408',65231.03,65487.53,0.00,0.00,256.50,151848.00,0.00,0.00,0.00),('1','177','919','257221',4898982,'2719','408',169421.86,170969.86,0.00,0.00,1548.00,916416.00,0.00,0.00,0.00),('1','177','919','257472',4903373,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257472',4903374,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257472',4903375,'2718','408',65487.53,65598.17,0.00,0.00,110.64,63398.88,0.00,0.00,0.00),('1','177','919','257472',4903376,'2719','408',170969.86,172603.96,0.00,0.00,1634.10,938699.52,0.00,0.00,0.00),('1','177','919','257473',4903377,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257473',4903378,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257473',4903379,'2718','408',65598.17,65829.78,0.00,0.00,231.61,131554.48,0.00,0.00,0.00),('1','177','919','257473',4903380,'2719','408',172603.96,174118.87,0.00,0.00,1514.91,860468.88,0.00,0.00,0.00),('1','177','919','257474',4903381,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257474',4903382,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257474',4903383,'2718','408',65829.78,65829.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257474',4903384,'2719','408',174118.87,174269.89,0.00,0.00,151.02,85779.36,0.00,0.00,0.00),('1','177','919','257475',4903385,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257475',4903386,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257475',4903387,'2718','408',65829.78,65897.46,0.00,0.00,67.68,38442.24,0.00,0.00,0.00),('1','177','919','257475',4903388,'2719','408',174269.89,175848.20,0.00,0.00,1578.31,896480.08,0.00,0.00,0.00),('1','177','919','257476',4903389,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257476',4903390,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257476',4903391,'2718','408',65897.46,65897.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257476',4903392,'2719','408',175848.20,177520.25,0.00,0.00,1672.05,949724.40,0.00,0.00,0.00),('1','177','919','257477',4903393,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257477',4903394,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257477',4903395,'2718','408',65897.46,66115.24,0.00,0.00,217.78,123699.04,0.00,0.00,0.00),('1','177','919','257477',4903396,'2719','408',177520.25,179262.32,0.00,0.00,1742.07,989495.76,0.00,0.00,0.00),('1','177','919','257478',4903397,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257478',4903398,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257478',4903399,'2718','408',66115.24,66115.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257478',4903400,'2719','408',179262.32,179507.40,0.00,0.00,245.08,139205.44,0.00,0.00,0.00),('1','177','919','257479',4903401,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257479',4903402,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257479',4903403,'2718','408',66115.24,66150.24,0.00,0.00,35.00,19880.00,0.00,0.00,0.00),('1','177','919','257479',4903404,'2719','408',179507.40,181563.61,0.00,0.00,2056.21,1167927.28,0.00,0.00,0.00),('1','177','919','257480',4903405,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257480',4903406,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257480',4903407,'2718','408',66150.24,66375.86,0.00,0.00,225.62,128152.16,0.00,0.00,0.00),('1','177','919','257480',4903408,'2719','408',181563.61,183152.29,0.00,0.00,1588.68,902370.24,0.00,0.00,0.00),('1','177','919','257481',4903409,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257481',4903410,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257481',4903411,'2718','408',66375.86,66383.50,0.00,0.00,7.64,4339.52,0.00,0.00,0.00),('1','177','919','257481',4903412,'2719','408',183152.29,184170.66,0.00,0.00,1018.37,578434.16,0.00,0.00,0.00),('1','177','919','257482',4903413,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257482',4903414,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257482',4903415,'2718','408',66383.50,66383.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257482',4903416,'2719','408',184170.66,184267.50,0.00,0.00,96.84,55005.12,0.00,0.00,0.00),('1','177','919','257483',4903417,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257483',4903418,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257483',4903419,'2718','408',66383.50,66383.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257483',4903420,'2719','408',184267.50,184942.86,0.00,0.00,675.36,383604.48,0.00,0.00,0.00),('1','177','919','257484',4903421,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257484',4903422,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257484',4903423,'2718','408',66383.50,66592.30,0.00,0.00,208.80,118598.40,0.00,0.00,0.00),('1','177','919','257484',4903424,'2719','408',184942.86,186228.53,0.00,0.00,1285.67,730260.56,0.00,0.00,0.00),('1','177','919','257485',4903425,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257485',4903426,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257485',4903427,'2718','408',66592.30,67146.35,0.00,0.00,554.05,314700.40,0.00,0.00,0.00),('1','177','919','257485',4903428,'2719','408',186228.53,187332.16,0.00,0.00,1103.63,626861.84,0.00,0.00,0.00),('1','177','919','257486',4903429,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257486',4903430,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257486',4903431,'2718','408',67146.35,67595.49,0.00,0.00,449.14,255111.52,0.00,0.00,0.00),('1','177','919','257486',4903432,'2719','408',187332.16,188414.34,0.00,0.00,1082.18,614678.24,0.00,0.00,0.00),('1','177','919','257487',4903433,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257487',4903434,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257487',4903435,'2718','408',67595.49,67638.33,0.00,0.00,42.84,24333.12,0.00,0.00,0.00),('1','177','919','257487',4903436,'2719','408',188414.34,188723.36,0.00,0.00,309.02,175523.36,0.00,0.00,0.00),('1','177','919','257488',4903437,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257488',4903438,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257488',4903439,'2718','408',67638.33,67712.09,0.00,0.00,73.76,41895.68,0.00,0.00,0.00),('1','177','919','257488',4903440,'2719','408',188723.36,190296.33,0.00,0.00,1572.97,893446.96,0.00,0.00,0.00),('1','177','919','257489',4903441,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257489',4903442,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257489',4903443,'2718','408',67712.09,67729.09,0.00,0.00,17.00,9656.00,0.00,0.00,0.00),('1','177','919','257489',4903444,'2719','408',190296.33,192217.20,0.00,0.00,1920.87,1091054.16,0.00,0.00,0.00),('1','177','919','257490',4903445,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257490',4903446,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257490',4903447,'2718','408',67729.09,68395.80,0.00,0.00,666.71,378691.28,0.00,0.00,0.00),('1','177','919','257490',4903448,'2719','408',192217.20,193005.66,0.00,0.00,788.46,447845.28,0.00,0.00,0.00),('1','177','919','257491',4903449,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257491',4903450,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257491',4903451,'2718','408',68395.80,69363.98,0.00,0.00,968.18,549926.24,0.00,0.00,0.00),('1','177','919','257491',4903452,'2719','408',193005.66,193959.49,0.00,0.00,953.83,541775.44,0.00,0.00,0.00),('1','177','919','257492',4903453,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257492',4903454,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257492',4903455,'2718','408',69363.98,69388.98,0.00,0.00,25.00,14200.00,0.00,0.00,0.00),('1','177','919','257492',4903456,'2719','408',193959.49,195692.19,0.00,0.00,1732.70,984173.60,0.00,0.00,0.00),('1','177','919','257493',4903457,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257493',4903458,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257493',4903459,'2718','408',69388.98,69458.35,0.00,0.00,69.37,39402.16,0.00,0.00,0.00),('1','177','919','257493',4903460,'2719','408',195692.19,196220.46,0.00,0.00,528.27,300057.36,0.00,0.00,0.00),('1','177','919','257494',4903461,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257494',4903462,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257494',4903463,'2718','408',69458.35,69483.35,0.00,0.00,25.00,14200.00,0.00,0.00,0.00),('1','177','919','257494',4903464,'2719','408',196220.46,197483.68,0.00,0.00,1263.22,717508.96,0.00,0.00,0.00),('1','177','919','257495',4903465,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257495',4903466,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257495',4903467,'2718','408',69483.35,70433.37,0.00,0.00,950.02,539611.36,0.00,0.00,0.00),('1','177','919','257495',4903468,'2719','408',197483.68,198200.11,0.00,0.00,716.43,406932.24,0.00,0.00,0.00),('1','177','919','257496',4903469,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257496',4903470,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257496',4903471,'2718','408',70433.37,71393.29,0.00,0.00,959.92,545234.56,0.00,0.00,0.00),('1','177','919','257496',4903472,'2719','408',198200.11,198826.94,0.00,0.00,626.83,356039.44,0.00,0.00,0.00),('1','177','919','257497',4903473,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257497',4903474,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257497',4903475,'2718','408',71393.29,71408.79,0.00,0.00,15.50,8804.00,0.00,0.00,0.00),('1','177','919','257497',4903476,'2719','408',198826.94,199731.83,0.00,0.00,904.89,513977.52,0.00,0.00,0.00),('1','177','919','257498',4903477,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257498',4903478,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257498',4903479,'2718','408',71408.79,71478.79,0.00,0.00,70.00,39760.00,0.00,0.00,0.00),('1','177','919','257498',4903480,'2719','408',199731.83,200714.95,0.00,0.00,983.12,558412.16,0.00,0.00,0.00),('1','177','919','257499',4903481,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257499',4903482,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257499',4903483,'2718','408',71478.79,72484.02,0.00,0.00,1005.23,570970.64,0.00,0.00,0.00),('1','177','919','257499',4903484,'2719','408',200714.95,201544.74,0.00,0.00,829.79,471320.72,0.00,0.00,0.00),('1','177','919','257500',4903485,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257500',4903486,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257500',4903487,'2718','408',72484.02,73670.23,0.00,0.00,1186.21,673767.28,0.00,0.00,0.00),('1','177','919','257500',4903488,'2719','408',201544.74,202140.92,0.00,0.00,596.18,338630.24,0.00,0.00,0.00),('1','177','919','257501',4903489,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257501',4903490,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257501',4903491,'2718','408',73670.23,73670.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257501',4903492,'2719','408',202140.92,202851.77,0.00,0.00,710.85,403762.80,0.00,0.00,0.00),('1','177','919','257502',4903493,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257502',4903494,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257502',4903495,'2718','408',73670.23,73670.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257502',4903496,'2719','408',202851.77,204056.98,0.00,0.00,1205.21,684559.28,0.00,0.00,0.00),('1','177','919','257503',4903497,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257503',4903498,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257503',4903499,'2718','408',73670.23,73688.73,0.00,0.00,18.50,10508.00,0.00,0.00,0.00),('1','177','919','257503',4903500,'2719','408',204056.98,205711.14,0.00,0.00,1654.16,939562.88,0.00,0.00,0.00),('1','177','919','257504',4903501,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257504',4903502,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257504',4903503,'2718','408',73688.73,74759.01,0.00,0.00,1070.28,607919.04,0.00,0.00,0.00),('1','177','919','257504',4903504,'2719','408',205711.14,206143.51,0.00,0.00,432.37,245586.16,0.00,0.00,0.00),('1','177','919','257505',4903505,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257505',4903506,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257505',4903507,'2718','408',74759.01,75504.03,0.00,0.00,745.02,423171.36,0.00,0.00,0.00),('1','177','919','257505',4903508,'2719','408',206143.51,206237.85,0.00,0.00,94.34,53585.12,0.00,0.00,0.00),('1','177','919','257506',4903509,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257506',4903510,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257506',4903511,'2718','408',75504.03,75504.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257506',4903512,'2719','408',206237.85,206237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257507',4903513,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257507',4903514,'2717','408',91545.84,91545.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257507',4903515,'2718','408',75504.03,76081.59,0.00,0.00,577.56,328054.08,0.00,0.00,0.00),('1','177','919','257507',4903516,'2719','408',206237.85,206735.07,0.00,0.00,497.22,282420.96,0.00,0.00,0.00),('1','177','919','257508',4903517,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257508',4903518,'2717','408',91545.84,91558.34,0.00,0.00,12.50,7100.00,0.00,0.00,0.00),('1','177','919','257508',4903519,'2718','408',76081.59,76858.51,0.00,0.00,776.92,441290.56,0.00,0.00,0.00),('1','177','919','257508',4903520,'2719','408',206735.07,207398.00,0.00,0.00,662.93,376544.24,0.00,0.00,0.00),('1','177','919','257509',4903521,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257509',4903522,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257509',4903523,'2718','408',76858.51,77685.14,0.00,0.00,826.63,469525.84,0.00,0.00,0.00),('1','177','919','257509',4903524,'2719','408',207398.00,208055.78,0.00,0.00,657.78,373619.04,0.00,0.00,0.00),('1','177','919','257510',4903525,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257510',4903526,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257510',4903527,'2718','408',77685.14,78407.26,0.00,0.00,722.12,410164.16,0.00,0.00,0.00),('1','177','919','257510',4903528,'2719','408',208055.78,208770.71,0.00,0.00,714.93,406080.24,0.00,0.00,0.00),('1','177','919','257511',4903529,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257511',4903530,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257511',4903531,'2718','408',78407.26,78665.80,0.00,0.00,258.54,146850.72,0.00,0.00,0.00),('1','177','919','257511',4903532,'2719','408',208770.71,208842.71,0.00,0.00,72.00,40896.00,0.00,0.00,0.00),('1','177','919','257512',4903533,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257512',4903534,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257512',4903535,'2718','408',78665.80,79757.57,0.00,0.00,1091.77,620125.36,0.00,0.00,0.00),('1','177','919','257512',4903536,'2719','408',208842.71,209324.13,0.00,0.00,481.42,273446.56,0.00,0.00,0.00),('1','177','919','257513',4903537,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257513',4903538,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257513',4903539,'2718','408',79757.57,81079.38,0.00,0.00,1321.81,750788.08,0.00,0.00,0.00),('1','177','919','257513',4903540,'2719','408',209324.13,210340.25,0.00,0.00,1016.12,577156.16,0.00,0.00,0.00),('1','177','919','257514',4903541,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257514',4903542,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257514',4903543,'2718','408',81079.38,81889.48,0.00,0.00,810.10,460136.80,0.00,0.00,0.00),('1','177','919','257514',4903544,'2719','408',210340.25,210539.89,0.00,0.00,199.64,113395.52,0.00,0.00,0.00),('1','177','919','257515',4903545,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257515',4903546,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257515',4903547,'2718','408',81889.48,82426.47,0.00,0.00,536.99,305010.32,0.00,0.00,0.00),('1','177','919','257515',4903548,'2719','408',210539.89,210702.86,0.00,0.00,162.97,92566.96,0.00,0.00,0.00),('1','177','919','257516',4903549,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257516',4903550,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257516',4903551,'2718','408',82426.47,83589.51,0.00,0.00,1163.04,674563.20,0.00,0.00,0.00),('1','177','919','257516',4903552,'2719','408',210702.86,211144.04,0.00,0.00,441.18,255884.40,0.00,0.00,0.00),('1','177','919','257517',4903553,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257517',4903554,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257517',4903555,'2718','408',83589.51,84377.38,0.00,0.00,787.87,456964.60,0.00,0.00,0.00),('1','177','919','257517',4903556,'2719','408',211144.04,212098.60,0.00,0.00,954.56,553644.80,0.00,0.00,0.00),('1','177','919','257518',4903557,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257518',4903558,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257518',4903559,'2718','408',84377.38,84530.44,0.00,0.00,153.06,88774.80,0.00,0.00,0.00),('1','177','919','257518',4903560,'2719','408',212098.60,213148.48,0.00,0.00,1049.88,608930.40,0.00,0.00,0.00),('1','177','919','257519',4903561,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257519',4903562,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257519',4903563,'2718','408',84530.44,84650.21,0.00,0.00,119.77,69466.60,0.00,0.00,0.00),('1','177','919','257519',4903564,'2719','408',213148.48,213591.80,0.00,0.00,443.32,257125.60,0.00,0.00,0.00),('1','177','919','257520',4903565,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257520',4903566,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257520',4903567,'2718','408',84650.21,85756.69,0.00,0.00,1106.48,641758.40,0.00,0.00,0.00),('1','177','919','257520',4903568,'2719','408',213591.80,214259.18,0.00,0.00,667.38,387080.40,0.00,0.00,0.00),('1','177','919','257521',4903569,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257521',4903570,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257521',4903571,'2718','408',85756.69,85854.28,0.00,0.00,97.59,56602.20,0.00,0.00,0.00),('1','177','919','257521',4903572,'2719','408',214259.18,215830.52,0.00,0.00,1571.34,911377.20,0.00,0.00,0.00),('1','177','919','257522',4903573,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257522',4903574,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257522',4903575,'2718','408',85854.28,85897.56,0.00,0.00,43.28,25102.40,0.00,0.00,0.00),('1','177','919','257522',4903576,'2719','408',215830.52,216979.48,0.00,0.00,1148.96,666396.80,0.00,0.00,0.00),('1','177','919','257523',4903577,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257523',4903578,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257523',4903579,'2718','408',85897.56,85897.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257523',4903580,'2719','408',216979.48,216979.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257524',4903581,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257524',4903582,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257524',4903583,'2718','408',85897.56,85984.69,0.00,0.00,87.13,55763.20,0.00,0.00,0.00),('1','177','919','257524',4903584,'2719','408',216979.48,218518.67,0.00,0.00,1539.19,985081.60,0.00,0.00,0.00),('1','177','919','257525',4903585,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257525',4903586,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257525',4903587,'2718','408',85984.69,87019.99,0.00,0.00,1035.30,662592.00,0.00,0.00,0.00),('1','177','919','257525',4903588,'2719','408',218518.67,219285.03,0.00,0.00,766.36,490470.40,0.00,0.00,0.00),('1','177','919','257526',4903589,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257526',4903590,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257526',4903591,'2718','408',87019.99,87161.69,0.00,0.00,141.70,90688.00,0.00,0.00,0.00),('1','177','919','257526',4903592,'2719','408',219285.03,220530.34,0.00,0.00,1245.31,796998.40,0.00,0.00,0.00),('1','177','919','257527',4903593,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257527',4903594,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257527',4903595,'2718','408',87161.69,87171.50,0.00,0.00,9.81,6278.40,0.00,0.00,0.00),('1','177','919','257527',4903596,'2719','408',220530.34,220907.36,0.00,0.00,377.02,241292.80,0.00,0.00,0.00),('1','177','919','257528',4903597,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257528',4903598,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257528',4903599,'2718','408',87171.50,88301.23,0.00,0.00,1129.73,723027.20,0.00,0.00,0.00),('1','177','919','257528',4903600,'2719','408',220907.36,221815.95,0.00,0.00,908.59,581497.60,0.00,0.00,0.00),('1','177','919','257529',4903601,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257529',4903602,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257529',4903603,'2718','408',88301.23,89169.16,0.00,0.00,867.93,555475.20,0.00,0.00,0.00),('1','177','919','257529',4903604,'2719','408',221815.95,222972.44,0.00,0.00,1156.49,740153.60,0.00,0.00,0.00),('1','177','919','257530',4903605,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257530',4903606,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257530',4903607,'2718','408',89169.16,89263.84,0.00,0.00,94.68,60595.20,0.00,0.00,0.00),('1','177','919','257530',4903608,'2719','408',222972.44,223948.57,0.00,0.00,976.13,624723.20,0.00,0.00,0.00),('1','177','919','257531',4903609,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257531',4903610,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257531',4903611,'2718','408',89263.84,89272.13,0.00,0.00,8.29,5305.60,0.00,0.00,0.00),('1','177','919','257531',4903612,'2719','408',223948.57,224160.80,0.00,0.00,212.23,135827.20,0.00,0.00,0.00),('1','177','919','257532',4903613,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257532',4903614,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257532',4903615,'2718','408',89272.13,89361.63,0.00,0.00,89.50,60860.00,0.00,0.00,0.00),('1','177','919','257532',4903616,'2719','408',224160.80,226352.07,0.00,0.00,2191.27,1490063.60,0.00,0.00,0.00),('1','177','919','257533',4903617,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257533',4903618,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257533',4903619,'2718','408',89361.63,89929.52,0.00,0.00,567.89,386165.20,0.00,0.00,0.00),('1','177','919','257533',4903620,'2719','408',226352.07,227302.16,0.00,0.00,950.09,646061.20,0.00,0.00,0.00),('1','177','919','257534',4903621,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257534',4903622,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257534',4903623,'2718','408',89929.52,90113.53,0.00,0.00,184.01,125126.80,0.00,0.00,0.00),('1','177','919','257534',4903624,'2719','408',227302.16,228273.02,0.00,0.00,970.86,660184.80,0.00,0.00,0.00),('1','177','919','257535',4903625,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257535',4903626,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257535',4903627,'2718','408',90113.53,90113.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257535',4903628,'2719','408',228273.02,228806.78,0.00,0.00,533.76,362956.80,0.00,0.00,0.00),('1','177','919','257536',4903629,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257536',4903630,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257536',4903631,'2718','408',90113.53,90144.53,0.00,0.00,31.00,20336.00,0.00,0.00,0.00),('1','177','919','257536',4903632,'2719','408',228806.78,230798.67,0.00,0.00,1991.89,1306679.84,0.00,0.00,0.00),('1','177','919','257537',4903633,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257537',4903634,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257537',4903635,'2718','408',90144.53,90163.10,0.00,0.00,18.57,12181.92,0.00,0.00,0.00),('1','177','919','257537',4903636,'2719','408',230798.67,232825.78,0.00,0.00,2027.11,1329784.16,0.00,0.00,0.00),('1','177','919','257538',4903637,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257538',4903638,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257538',4903639,'2718','408',90163.10,90347.72,0.00,0.00,184.62,121110.72,0.00,0.00,0.00),('1','177','919','257538',4903640,'2719','408',232825.78,233672.45,0.00,0.00,846.67,555415.52,0.00,0.00,0.00),('1','177','919','257539',4903641,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257539',4903642,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257539',4903643,'2718','408',90347.72,90353.82,0.00,0.00,6.10,4001.60,0.00,0.00,0.00),('1','177','919','257539',4903644,'2719','408',233672.45,234256.59,0.00,0.00,584.14,383195.84,0.00,0.00,0.00),('1','177','919','257540',4903645,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257540',4903646,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257540',4903647,'2718','408',90353.82,90359.04,0.00,0.00,5.22,3424.32,0.00,0.00,0.00),('1','177','919','257540',4903648,'2719','408',234256.59,235758.34,0.00,0.00,1501.75,985148.00,0.00,0.00,0.00),('1','177','919','257541',4903649,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257541',4903650,'2717','408',91558.34,91558.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257541',4903651,'2718','408',90359.04,90379.56,0.00,0.00,20.52,13461.12,0.00,0.00,0.00),('1','177','919','257541',4903652,'2719','408',235758.34,237593.36,0.00,0.00,1835.02,1203773.12,0.00,0.00,0.00),('1','177','919','257542',4903653,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257542',4903654,'2717','408',91558.34,91590.35,0.00,0.00,32.01,20998.56,0.00,0.00,0.00),('1','177','919','257542',4903655,'2718','408',90379.56,90479.58,0.00,0.00,100.02,65613.12,0.00,0.00,0.00),('1','177','919','257542',4903656,'2719','408',237593.36,238753.00,0.00,0.00,1159.64,760723.84,0.00,0.00,0.00),('1','177','919','257543',4903657,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257543',4903658,'2717','408',91590.35,91590.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257543',4903659,'2718','408',90479.58,90603.23,0.00,0.00,123.65,81114.40,0.00,0.00,0.00),('1','177','919','257543',4903660,'2719','408',238753.00,240642.68,0.00,0.00,1889.68,1239630.08,0.00,0.00,0.00),('1','177','919','257544',4903661,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257544',4903662,'2717','408',91590.35,91604.84,0.00,0.00,14.49,9505.44,0.00,0.00,0.00),('1','177','919','257544',4903663,'2718','408',90603.23,91602.39,0.00,0.00,999.16,655448.96,0.00,0.00,0.00),('1','177','919','257544',4903664,'2719','408',240642.68,241439.63,0.00,0.00,796.95,522799.20,0.00,0.00,0.00),('1','177','919','257545',4903665,'2716','408',35581.64,35581.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257545',4903666,'2717','408',91604.84,91604.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257545',4903667,'2718','408',91602.39,92216.69,0.00,0.00,614.30,402980.80,0.00,0.00,0.00),('1','177','919','257545',4903668,'2719','408',241439.63,241805.69,0.00,0.00,366.06,240135.36,0.00,0.00,0.00),('1','177','919','257546',4903669,'2716','408',35581.64,35583.64,0.00,0.00,2.00,1312.00,0.00,0.00,0.00),('1','177','919','257546',4903670,'2717','408',91604.84,91604.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257546',4903671,'2718','408',92216.69,93035.93,0.00,0.00,819.24,537421.44,0.00,0.00,0.00),('1','177','919','257546',4903672,'2719','408',241805.69,242100.13,0.00,0.00,294.44,193152.64,0.00,0.00,0.00),('1','177','919','257547',4903673,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257547',4903674,'2717','408',91604.84,91604.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257547',4903675,'2718','408',93035.93,93360.95,0.00,0.00,325.02,215390.72,0.00,0.00,0.00),('1','177','919','257547',4903676,'2719','408',242100.13,242186.98,0.00,0.00,86.85,56973.60,0.00,0.00,0.00),('1','177','919','257548',4903677,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257548',4903678,'2717','408',91604.84,91604.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257548',4903679,'2718','408',93360.95,94193.80,0.00,0.00,832.85,573000.80,0.00,0.00,0.00),('1','177','919','257548',4903680,'2719','408',242186.98,242710.08,0.00,0.00,523.10,359892.80,0.00,0.00,0.00),('1','177','919','257549',4903681,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257549',4903682,'2717','408',91604.84,91604.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257549',4903683,'2718','408',94193.80,94973.27,0.00,0.00,779.47,536275.36,0.00,0.00,0.00),('1','177','919','257549',4903684,'2719','408',242710.08,243569.12,0.00,0.00,859.04,591019.52,0.00,0.00,0.00),('1','177','919','257550',4903685,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257550',4903686,'2717','408',91604.84,91604.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257550',4903687,'2718','408',94973.27,95117.06,0.00,0.00,143.79,98927.52,0.00,0.00,0.00),('1','177','919','257550',4903688,'2719','408',243569.12,244969.10,0.00,0.00,1399.98,963186.24,0.00,0.00,0.00),('1','177','919','257551',4903689,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257551',4903690,'2717','408',91604.84,91606.29,0.00,0.00,1.45,997.60,0.00,0.00,0.00),('1','177','919','257551',4903691,'2718','408',95117.06,96724.45,0.00,0.00,1607.39,1105884.32,0.00,0.00,0.00),('1','177','919','257551',4903692,'2719','408',244969.10,245387.24,0.00,0.00,418.14,287680.32,0.00,0.00,0.00),('1','177','919','257552',4903693,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257552',4903694,'2717','408',91606.29,91606.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257552',4903695,'2718','408',96724.45,97969.55,0.00,0.00,1245.10,826746.40,0.00,0.00,0.00),('1','177','919','257552',4903696,'2719','408',245387.24,245927.95,0.00,0.00,540.71,359031.44,0.00,0.00,0.00),('1','177','919','257553',4903697,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257553',4903698,'2717','408',91606.29,91606.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257553',4903699,'2718','408',97969.55,98888.81,0.00,0.00,919.26,610388.64,0.00,0.00,0.00),('1','177','919','257553',4903700,'2719','408',245927.95,246247.77,0.00,0.00,319.82,212360.48,0.00,0.00,0.00),('1','177','919','257554',4903701,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257554',4903702,'2717','408',91606.29,91606.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257554',4903703,'2718','408',98888.81,99018.07,0.00,0.00,129.26,85828.64,0.00,0.00,0.00),('1','177','919','257554',4903704,'2719','408',246247.77,246509.68,0.00,0.00,261.91,173908.24,0.00,0.00,0.00),('1','177','919','257555',4903705,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257555',4903706,'2717','408',91606.29,91612.31,0.00,0.00,6.02,3997.28,0.00,0.00,0.00),('1','177','919','257555',4903707,'2718','408',99018.07,100919.70,0.00,0.00,1901.63,1262682.32,0.00,0.00,0.00),('1','177','919','257555',4903708,'2719','408',246509.68,247253.38,0.00,0.00,743.70,493816.80,0.00,0.00,0.00),('1','177','919','257556',4903709,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257556',4903710,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257556',4903711,'2718','408',100919.70,102461.63,0.00,0.00,1541.93,1023841.52,0.00,0.00,0.00),('1','177','919','257556',4903712,'2719','408',247253.38,247687.78,0.00,0.00,434.40,288441.60,0.00,0.00,0.00),('1','177','919','257557',4903713,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257557',4903714,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257557',4903715,'2718','408',102461.63,102668.83,0.00,0.00,207.20,137580.80,0.00,0.00,0.00),('1','177','919','257557',4903716,'2719','408',247687.78,247752.54,0.00,0.00,64.76,43000.64,0.00,0.00,0.00),('1','177','919','257558',4903717,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257558',4903718,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257558',4903719,'2718','408',102668.83,104078.89,0.00,0.00,1410.06,936279.84,0.00,0.00,0.00),('1','177','919','257558',4903720,'2719','408',247752.54,248089.56,0.00,0.00,337.02,223781.28,0.00,0.00,0.00),('1','177','919','257559',4903721,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257559',4903722,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257559',4903723,'2718','408',104078.89,105378.17,0.00,0.00,1299.28,862721.92,0.00,0.00,0.00),('1','177','919','257559',4903724,'2719','408',248089.56,248587.03,0.00,0.00,497.47,330320.08,0.00,0.00,0.00),('1','177','919','257560',4903725,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257560',4903726,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257560',4903727,'2718','408',105378.17,106591.12,0.00,0.00,1212.95,805398.80,0.00,0.00,0.00),('1','177','919','257560',4903728,'2719','408',248587.03,249038.24,0.00,0.00,451.21,299603.44,0.00,0.00,0.00),('1','177','919','257561',4903729,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257561',4903730,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257561',4903731,'2718','408',106591.12,106806.38,0.00,0.00,215.26,142932.64,0.00,0.00,0.00),('1','177','919','257561',4903732,'2719','408',249038.24,249128.87,0.00,0.00,90.63,60178.32,0.00,0.00,0.00),('1','177','919','257562',4903733,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257562',4903734,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257562',4903735,'2718','408',106806.38,107666.24,0.00,0.00,859.86,570947.04,0.00,0.00,0.00),('1','177','919','257562',4903736,'2719','408',249128.87,249478.82,0.00,0.00,349.95,232366.80,0.00,0.00,0.00),('1','177','919','257563',4903737,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257563',4903738,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257563',4903739,'2718','408',107666.24,108765.71,0.00,0.00,1099.47,730048.08,0.00,0.00,0.00),('1','177','919','257563',4903740,'2719','408',249478.82,250144.07,0.00,0.00,665.25,441726.00,0.00,0.00,0.00),('1','177','919','257564',4903741,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257564',4903742,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257564',4903743,'2718','408',108765.71,110280.77,0.00,0.00,1515.06,1005999.84,0.00,0.00,0.00),('1','177','919','257564',4903744,'2719','408',250144.07,250748.83,0.00,0.00,604.76,401560.64,0.00,0.00,0.00),('1','177','919','257565',4903745,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257565',4903746,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257565',4903747,'2718','408',110280.77,110280.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257565',4903748,'2719','408',250748.83,250767.33,0.00,0.00,18.50,12284.00,0.00,0.00,0.00),('1','177','919','257566',4903749,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257566',4903750,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257566',4903751,'2718','408',110280.77,111566.20,0.00,0.00,1285.43,853525.52,0.00,0.00,0.00),('1','177','919','257566',4903752,'2719','408',250767.33,251511.84,0.00,0.00,744.51,494354.64,0.00,0.00,0.00),('1','177','919','257567',4903753,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257567',4903754,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257567',4903755,'2718','408',111566.20,111657.60,0.00,0.00,91.40,60689.60,0.00,0.00,0.00),('1','177','919','257567',4903756,'2719','408',251511.84,253341.75,0.00,0.00,1829.91,1215060.24,0.00,0.00,0.00),('1','177','919','257568',4903757,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257568',4903758,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257568',4903759,'2718','408',111657.60,111828.21,0.00,0.00,170.61,113285.04,0.00,0.00,0.00),('1','177','919','257568',4903760,'2719','408',253341.75,254468.99,0.00,0.00,1127.24,748487.36,0.00,0.00,0.00),('1','177','919','257569',4903761,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257569',4903762,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257569',4903763,'2718','408',111828.21,112091.61,0.00,0.00,263.40,174897.60,0.00,0.00,0.00),('1','177','919','257569',4903764,'2719','408',254468.99,256219.02,0.00,0.00,1750.03,1162019.92,0.00,0.00,0.00),('1','177','919','257570',4903765,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257570',4903766,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257570',4903767,'2718','408',112091.61,112233.15,0.00,0.00,141.54,93982.56,0.00,0.00,0.00),('1','177','919','257570',4903768,'2719','408',256219.02,257994.35,0.00,0.00,1775.33,1178819.12,0.00,0.00,0.00),('1','177','919','257571',4903769,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257571',4903770,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257571',4903771,'2718','408',112233.15,113299.70,0.00,0.00,1066.55,708189.20,0.00,0.00,0.00),('1','177','919','257571',4903772,'2719','408',257994.35,258189.50,0.00,0.00,195.15,129579.60,0.00,0.00,0.00),('1','177','919','257572',4903773,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257572',4903774,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257572',4903775,'2718','408',113299.70,113819.76,0.00,0.00,520.06,345319.84,0.00,0.00,0.00),('1','177','919','257572',4903776,'2719','408',258189.50,258212.09,0.00,0.00,22.59,14999.76,0.00,0.00,0.00),('1','177','919','257573',4903777,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257573',4903778,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257573',4903779,'2718','408',113819.76,115286.14,0.00,0.00,1466.38,973676.32,0.00,0.00,0.00),('1','177','919','257573',4903780,'2719','408',258212.09,258642.74,0.00,0.00,430.65,285951.60,0.00,0.00,0.00),('1','177','919','257574',4903781,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257574',4903782,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257574',4903783,'2718','408',115286.14,116780.99,0.00,0.00,1494.85,992580.40,0.00,0.00,0.00),('1','177','919','257574',4903784,'2719','408',258642.74,259208.19,0.00,0.00,565.45,375458.80,0.00,0.00,0.00),('1','177','919','257575',4903785,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257575',4903786,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257575',4903787,'2718','408',116780.99,117259.81,0.00,0.00,478.82,317936.48,0.00,0.00,0.00),('1','177','919','257575',4903788,'2719','408',259208.19,259565.19,0.00,0.00,357.00,237048.00,0.00,0.00,0.00),('1','177','919','257576',4903789,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257576',4903790,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257576',4903791,'2718','408',117259.81,118372.71,0.00,0.00,1112.90,738965.60,0.00,0.00,0.00),('1','177','919','257576',4903792,'2719','408',259565.19,259765.64,0.00,0.00,200.45,133098.80,0.00,0.00,0.00),('1','177','919','257577',4903793,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257577',4903794,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257577',4903795,'2718','408',118372.71,118449.03,0.00,0.00,76.32,50676.48,0.00,0.00,0.00),('1','177','919','257577',4903796,'2719','408',259765.64,261441.61,0.00,0.00,1675.97,1112844.08,0.00,0.00,0.00),('1','177','919','257578',4903797,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257578',4903798,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257578',4903799,'2718','408',118449.03,118869.98,0.00,0.00,420.95,279510.80,0.00,0.00,0.00),('1','177','919','257578',4903800,'2719','408',261441.61,263138.86,0.00,0.00,1697.25,1126974.00,0.00,0.00,0.00),('1','177','919','257579',4903801,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257579',4903802,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257579',4903803,'2718','408',118869.98,120240.13,0.00,0.00,1370.15,909779.60,0.00,0.00,0.00),('1','177','919','257579',4903804,'2719','408',263138.86,263454.22,0.00,0.00,315.36,209399.04,0.00,0.00,0.00),('1','177','919','257580',4903805,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257580',4903806,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257580',4903807,'2718','408',120240.13,120345.75,0.00,0.00,105.62,70131.68,0.00,0.00,0.00),('1','177','919','257580',4903808,'2719','408',263454.22,265228.00,0.00,0.00,1773.78,1177789.92,0.00,0.00,0.00),('1','177','919','257581',4903809,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257581',4903810,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257581',4903811,'2718','408',120345.75,121790.52,0.00,0.00,1444.77,959327.28,0.00,0.00,0.00),('1','177','919','257581',4903812,'2719','408',265228.00,265553.58,0.00,0.00,325.58,216185.12,0.00,0.00,0.00),('1','177','919','257582',4903813,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257582',4903814,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257582',4903815,'2718','408',121790.52,121968.39,0.00,0.00,177.87,118105.68,0.00,0.00,0.00),('1','177','919','257582',4903816,'2719','408',265553.58,265660.77,0.00,0.00,107.19,71174.16,0.00,0.00,0.00),('1','177','919','257583',4903817,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257583',4903818,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257583',4903819,'2718','408',121968.39,123949.66,0.00,0.00,1981.27,1315563.28,0.00,0.00,0.00),('1','177','919','257583',4903820,'2719','408',265660.77,266181.00,0.00,0.00,520.23,345432.72,0.00,0.00,0.00),('1','177','919','257584',4903821,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257584',4903822,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257584',4903823,'2718','408',123949.66,124053.69,0.00,0.00,104.03,69075.92,0.00,0.00,0.00),('1','177','919','257584',4903824,'2719','408',266181.00,267861.49,0.00,0.00,1680.49,1115845.36,0.00,0.00,0.00),('1','177','919','257585',4903825,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257585',4903826,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257585',4903827,'2718','408',124053.69,124055.20,0.00,0.00,1.51,1002.64,0.00,0.00,0.00),('1','177','919','257585',4903828,'2719','408',267861.49,268343.16,0.00,0.00,481.67,319828.88,0.00,0.00,0.00),('1','177','919','257586',4903829,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257586',4903830,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257586',4903831,'2718','408',124055.20,124186.99,0.00,0.00,131.79,87508.56,0.00,0.00,0.00),('1','177','919','257586',4903832,'2719','408',268343.16,269393.12,0.00,0.00,1049.96,697173.44,0.00,0.00,0.00),('1','177','919','257587',4903833,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257587',4903834,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257587',4903835,'2718','408',124186.99,124186.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257587',4903836,'2719','408',269393.12,271238.29,0.00,0.00,1845.17,1225192.88,0.00,0.00,0.00),('1','177','919','257588',4903837,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257588',4903838,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257588',4903839,'2718','408',124186.99,125782.43,0.00,0.00,1595.44,1059372.16,0.00,0.00,0.00),('1','177','919','257588',4903840,'2719','408',271238.29,271490.81,0.00,0.00,252.52,167673.28,0.00,0.00,0.00),('1','177','919','257589',4903841,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257589',4903842,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257589',4903843,'2718','408',125782.43,125782.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257589',4903844,'2719','408',271490.81,272021.03,0.00,0.00,530.22,352066.08,0.00,0.00,0.00),('1','177','919','257590',4903845,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257590',4903846,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257590',4903847,'2718','408',125782.43,125830.13,0.00,0.00,47.70,31672.80,0.00,0.00,0.00),('1','177','919','257590',4903848,'2719','408',272021.03,273870.07,0.00,0.00,1849.04,1227762.56,0.00,0.00,0.00),('1','177','919','257591',4903849,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257591',4903850,'2717','408',91612.31,91612.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257591',4903851,'2718','408',125830.13,128063.54,0.00,0.00,2233.41,1482984.24,0.00,0.00,0.00),('1','177','919','257591',4903852,'2719','408',273870.07,274850.49,0.00,0.00,980.42,650998.88,0.00,0.00,0.00),('1','177','919','257592',4903853,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257592',4903854,'2717','408',91612.31,91617.31,0.00,0.00,5.00,3320.00,0.00,0.00,0.00),('1','177','919','257592',4903855,'2718','408',128063.54,129349.81,0.00,0.00,1286.27,854083.28,0.00,0.00,0.00),('1','177','919','257592',4903856,'2719','408',274850.49,275424.28,0.00,0.00,573.79,380996.56,0.00,0.00,0.00),('1','177','919','257593',4903857,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257593',4903858,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257593',4903859,'2718','408',129349.81,129371.11,0.00,0.00,21.30,14143.20,0.00,0.00,0.00),('1','177','919','257593',4903860,'2719','408',275424.28,276744.35,0.00,0.00,1320.07,876526.48,0.00,0.00,0.00),('1','177','919','257594',4903861,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257594',4903862,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257594',4903863,'2718','408',129371.11,129407.89,0.00,0.00,36.78,24421.92,0.00,0.00,0.00),('1','177','919','257594',4903864,'2719','408',276744.35,278373.33,0.00,0.00,1628.98,1081642.72,0.00,0.00,0.00),('1','177','919','257595',4903865,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257595',4903866,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257595',4903867,'2718','408',129407.89,129445.39,0.00,0.00,37.50,24900.00,0.00,0.00,0.00),('1','177','919','257595',4903868,'2719','408',278373.33,278849.14,0.00,0.00,475.81,315937.84,0.00,0.00,0.00),('1','177','919','257596',4903869,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257596',4903870,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257596',4903871,'2718','408',129445.39,129498.98,0.00,0.00,53.59,35583.76,0.00,0.00,0.00),('1','177','919','257596',4903872,'2719','408',278849.14,279833.94,0.00,0.00,984.80,653907.20,0.00,0.00,0.00),('1','177','919','257597',4903873,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257597',4903874,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257597',4903875,'2718','408',129498.98,129611.73,0.00,0.00,112.75,74866.00,0.00,0.00,0.00),('1','177','919','257597',4903876,'2719','408',279833.94,281831.46,0.00,0.00,1997.52,1326353.28,0.00,0.00,0.00),('1','177','919','257598',4903877,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257598',4903878,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257598',4903879,'2718','408',129611.73,130963.72,0.00,0.00,1351.99,897721.36,0.00,0.00,0.00),('1','177','919','257598',4903880,'2719','408',281831.46,282527.68,0.00,0.00,696.22,462290.08,0.00,0.00,0.00),('1','177','919','257599',4903881,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257599',4903882,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257599',4903883,'2718','408',130963.72,131181.02,0.00,0.00,217.30,144287.20,0.00,0.00,0.00),('1','177','919','257599',4903884,'2719','408',282527.68,282548.44,0.00,0.00,20.76,13784.64,0.00,0.00,0.00),('1','177','919','257600',4903885,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257600',4903886,'2717','408',91617.31,91617.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257600',4903887,'2718','408',131181.02,132367.33,0.00,0.00,1186.31,787709.84,0.00,0.00,0.00),('1','177','919','257600',4903888,'2719','408',282548.44,283342.83,0.00,0.00,794.39,527474.96,0.00,0.00,0.00),('1','177','919','257601',4903889,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257601',4903890,'2717','408',91617.31,91629.81,0.00,0.00,12.50,8300.00,0.00,0.00,0.00),('1','177','919','257601',4903891,'2718','408',132367.33,133497.85,0.00,0.00,1130.52,750665.28,0.00,0.00,0.00),('1','177','919','257601',4903892,'2719','408',283342.83,283842.79,0.00,0.00,499.96,331973.44,0.00,0.00,0.00),('1','177','919','257602',4903893,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257602',4903894,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257602',4903895,'2718','408',133497.85,133701.20,0.00,0.00,203.35,135024.40,0.00,0.00,0.00),('1','177','919','257602',4903896,'2719','408',283842.79,285298.95,0.00,0.00,1456.16,966890.24,0.00,0.00,0.00),('1','177','919','257603',4903897,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257603',4903898,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257603',4903899,'2718','408',133701.20,133851.63,0.00,0.00,150.43,99885.52,0.00,0.00,0.00),('1','177','919','257603',4903900,'2719','408',285298.95,286038.30,0.00,0.00,739.35,490928.40,0.00,0.00,0.00),('1','177','919','257604',4903901,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257604',4903902,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257604',4903903,'2718','408',133851.63,134271.16,0.00,0.00,419.53,278567.92,0.00,0.00,0.00),('1','177','919','257604',4903904,'2719','408',286038.30,286097.86,0.00,0.00,59.56,39547.84,0.00,0.00,0.00),('1','177','919','257605',4903905,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257605',4903906,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257605',4903907,'2718','408',134271.16,134820.96,0.00,0.00,549.80,365067.20,0.00,0.00,0.00),('1','177','919','257605',4903908,'2719','408',286097.86,287978.88,0.00,0.00,1881.02,1248997.28,0.00,0.00,0.00),('1','177','919','257606',4903909,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257606',4903910,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257606',4903911,'2718','408',134820.96,134856.96,0.00,0.00,36.00,23904.00,0.00,0.00,0.00),('1','177','919','257606',4903912,'2719','408',287978.88,289650.77,0.00,0.00,1671.89,1110134.96,0.00,0.00,0.00),('1','177','919','257607',4903913,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257607',4903914,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257607',4903915,'2718','408',134856.96,135120.95,0.00,0.00,263.99,175289.36,0.00,0.00,0.00),('1','177','919','257607',4903916,'2719','408',289650.77,291931.19,0.00,0.00,2280.42,1514198.88,0.00,0.00,0.00),('1','177','919','257608',4903917,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257608',4903918,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257608',4903919,'2718','408',135120.95,135378.43,0.00,0.00,257.48,175086.40,0.00,0.00,0.00),('1','177','919','257608',4903920,'2719','408',291931.19,293360.35,0.00,0.00,1429.16,971828.80,0.00,0.00,0.00),('1','177','919','257609',4903921,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257609',4903922,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257609',4903923,'2718','408',135378.43,135418.85,0.00,0.00,40.42,27485.60,0.00,0.00,0.00),('1','177','919','257609',4903924,'2719','408',293360.35,294095.75,0.00,0.00,735.40,500072.00,0.00,0.00,0.00),('1','177','919','257610',4903925,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257610',4903926,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257610',4903927,'2718','408',135418.85,135620.87,0.00,0.00,202.02,137373.60,0.00,0.00,0.00),('1','177','919','257610',4903928,'2719','408',294095.75,295870.15,0.00,0.00,1774.40,1206592.00,0.00,0.00,0.00),('1','177','919','257611',4903929,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257611',4903930,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257611',4903931,'2718','408',135620.87,135763.31,0.00,0.00,142.44,96859.20,0.00,0.00,0.00),('1','177','919','257611',4903932,'2719','408',295870.15,297062.03,0.00,0.00,1191.88,810478.40,0.00,0.00,0.00),('1','177','919','257612',4903933,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257612',4903934,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257612',4903935,'2718','408',135763.31,135772.67,0.00,0.00,9.36,6364.80,0.00,0.00,0.00),('1','177','919','257612',4903936,'2719','408',297062.03,297462.55,0.00,0.00,400.52,272353.60,0.00,0.00,0.00),('1','177','919','257613',4903937,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257613',4903938,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257613',4903939,'2718','408',135772.67,135837.64,0.00,0.00,64.97,44179.60,0.00,0.00,0.00),('1','177','919','257613',4903940,'2719','408',297462.55,299370.66,0.00,0.00,1908.11,1297514.80,0.00,0.00,0.00),('1','177','919','257614',4903941,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257614',4903942,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257614',4903943,'2718','408',135837.64,135900.81,0.00,0.00,63.17,42955.60,0.00,0.00,0.00),('1','177','919','257614',4903944,'2719','408',299370.66,300367.70,0.00,0.00,997.04,677987.20,0.00,0.00,0.00),('1','177','919','257615',4903945,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257615',4903946,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257615',4903947,'2718','408',135900.81,135964.26,0.00,0.00,63.45,43146.00,0.00,0.00,0.00),('1','177','919','257615',4903948,'2719','408',300367.70,300867.00,0.00,0.00,499.30,339524.00,0.00,0.00,0.00),('1','177','919','257616',4903949,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257616',4903950,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257616',4903951,'2718','408',135964.26,136002.74,0.00,0.00,38.48,26166.40,0.00,0.00,0.00),('1','177','919','257616',4903952,'2719','408',300867.00,303206.03,0.00,0.00,2339.03,1590540.40,0.00,0.00,0.00),('1','177','919','257617',4903953,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257617',4903954,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257617',4903955,'2718','408',136002.74,136525.63,0.00,0.00,522.89,355565.20,0.00,0.00,0.00),('1','177','919','257617',4903956,'2719','408',303206.03,304628.31,0.00,0.00,1422.28,967150.40,0.00,0.00,0.00),('1','177','919','257618',4903957,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257618',4903958,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257618',4903959,'2718','408',136525.63,136594.51,0.00,0.00,68.88,46838.40,0.00,0.00,0.00),('1','177','919','257618',4903960,'2719','408',304628.31,304842.51,0.00,0.00,214.20,145656.00,0.00,0.00,0.00),('1','177','919','257619',4903961,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257619',4903962,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257619',4903963,'2718','408',136594.51,136632.00,0.00,0.00,37.49,25493.20,0.00,0.00,0.00),('1','177','919','257619',4903964,'2719','408',304842.51,306262.19,0.00,0.00,1419.68,965382.40,0.00,0.00,0.00),('1','177','919','257620',4903965,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257620',4903966,'2717','408',91629.81,91629.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257620',4903967,'2718','408',136632.00,136826.79,0.00,0.00,194.79,132457.20,0.00,0.00,0.00),('1','177','919','257620',4903968,'2719','408',306262.19,308894.70,0.00,0.00,2632.51,1790106.80,0.00,0.00,0.00),('1','177','919','257621',4903969,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257621',4903970,'2717','408',91629.81,91632.59,0.00,0.00,2.78,2001.60,0.00,0.00,0.00),('1','177','919','257621',4903971,'2718','408',136826.79,136968.59,0.00,0.00,141.80,102096.00,0.00,0.00,0.00),('1','177','919','257621',4903972,'2719','408',308894.70,310283.74,0.00,0.00,1389.04,1000108.80,0.00,0.00,0.00),('1','177','919','257622',4903973,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257622',4903974,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257622',4903975,'2718','408',136968.59,138087.18,0.00,0.00,1118.59,805384.80,0.00,0.00,0.00),('1','177','919','257622',4903976,'2719','408',310283.74,311335.39,0.00,0.00,1051.65,757188.00,0.00,0.00,0.00),('1','177','919','257623',4903977,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257623',4903978,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257623',4903979,'2718','408',138087.18,138684.33,0.00,0.00,597.15,429948.00,0.00,0.00,0.00),('1','177','919','257623',4903980,'2719','408',311335.39,312467.80,0.00,0.00,1132.41,815335.20,0.00,0.00,0.00),('1','177','919','257624',4903981,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257624',4903982,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257624',4903983,'2718','408',138684.33,139690.41,0.00,0.00,1006.08,724377.60,0.00,0.00,0.00),('1','177','919','257624',4903984,'2719','408',312467.80,313923.31,0.00,0.00,1455.51,1047967.20,0.00,0.00,0.00),('1','177','919','257625',4903985,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257625',4903986,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257625',4903987,'2718','408',139690.41,140457.04,0.00,0.00,766.63,551973.60,0.00,0.00,0.00),('1','177','919','257625',4903988,'2719','408',313923.31,315205.98,0.00,0.00,1282.67,923522.40,0.00,0.00,0.00),('1','177','919','257626',4903989,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257626',4903990,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257626',4903991,'2718','408',140457.04,140486.08,0.00,0.00,29.04,20908.80,0.00,0.00,0.00),('1','177','919','257626',4903992,'2719','408',315205.98,315571.41,0.00,0.00,365.43,263109.60,0.00,0.00,0.00),('1','177','919','257627',4903993,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257627',4903994,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257627',4903995,'2718','408',140486.08,140560.11,0.00,0.00,74.03,53301.60,0.00,0.00,0.00),('1','177','919','257627',4903996,'2719','408',315571.41,316339.26,0.00,0.00,767.85,552852.00,0.00,0.00,0.00),('1','177','919','257628',4903997,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257628',4903998,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257628',4903999,'2718','408',140560.11,140818.29,0.00,0.00,258.18,196216.80,0.00,0.00,0.00),('1','177','919','257628',4904000,'2719','408',316339.26,318066.34,0.00,0.00,1727.08,1312580.80,0.00,0.00,0.00),('1','177','919','257629',4904001,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257629',4904002,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257629',4904003,'2718','408',140818.29,140818.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257629',4904004,'2719','408',318066.34,319306.08,0.00,0.00,1239.74,942202.40,0.00,0.00,0.00),('1','177','919','257630',4904005,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257630',4904006,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257630',4904007,'2718','408',140818.29,141382.99,0.00,0.00,564.70,429172.00,0.00,0.00,0.00),('1','177','919','257630',4904008,'2719','408',319306.08,319496.06,0.00,0.00,189.98,144384.80,0.00,0.00,0.00),('1','177','919','257631',4904009,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257631',4904010,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257631',4904011,'2718','408',141382.99,143000.74,0.00,0.00,1617.75,1229490.00,0.00,0.00,0.00),('1','177','919','257631',4904012,'2719','408',319496.06,319821.05,0.00,0.00,324.99,246992.40,0.00,0.00,0.00),('1','177','919','257632',4904013,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257632',4904014,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257632',4904015,'2718','408',143000.74,143159.38,0.00,0.00,158.64,120566.40,0.00,0.00,0.00),('1','177','919','257632',4904016,'2719','408',319821.05,321663.59,0.00,0.00,1842.54,1400330.40,0.00,0.00,0.00),('1','177','919','257633',4904017,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257633',4904018,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257633',4904019,'2718','408',143159.38,143497.97,0.00,0.00,338.59,257328.40,0.00,0.00,0.00),('1','177','919','257633',4904020,'2719','408',321663.59,321735.46,0.00,0.00,71.87,54621.20,0.00,0.00,0.00),('1','177','919','257634',4904021,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257634',4904022,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257634',4904023,'2718','408',143497.97,144057.48,0.00,0.00,559.51,425227.60,0.00,0.00,0.00),('1','177','919','257634',4904024,'2719','408',321735.46,322028.51,0.00,0.00,293.05,222718.00,0.00,0.00,0.00),('1','177','919','257635',4904025,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257635',4904026,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257635',4904027,'2718','408',144057.48,145470.66,0.00,0.00,1413.18,1074016.80,0.00,0.00,0.00),('1','177','919','257635',4904028,'2719','408',322028.51,322382.21,0.00,0.00,353.70,268812.00,0.00,0.00,0.00),('1','177','919','257636',4904029,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257636',4904030,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257636',4904031,'2718','408',145470.66,145628.87,0.00,0.00,158.21,120239.60,0.00,0.00,0.00),('1','177','919','257636',4904032,'2719','408',322382.21,324057.99,0.00,0.00,1675.78,1273592.80,0.00,0.00,0.00),('1','177','919','257637',4904033,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257637',4904034,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257637',4904035,'2718','408',145628.87,145968.74,0.00,0.00,339.87,258301.20,0.00,0.00,0.00),('1','177','919','257637',4904036,'2719','408',324057.99,326083.54,0.00,0.00,2025.55,1539418.00,0.00,0.00,0.00),('1','177','919','257638',4904037,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257638',4904038,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257638',4904039,'2718','408',145968.74,146030.75,0.00,0.00,62.01,47127.60,0.00,0.00,0.00),('1','177','919','257638',4904040,'2719','408',326083.54,326083.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257639',4904041,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257639',4904042,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257639',4904043,'2718','408',146030.75,146472.14,0.00,0.00,441.39,335456.40,0.00,0.00,0.00),('1','177','919','257639',4904044,'2719','408',326083.54,327859.99,0.00,0.00,1776.45,1350102.00,0.00,0.00,0.00),('1','177','919','257640',4904045,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257640',4904046,'2717','408',91632.59,91632.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257640',4904047,'2718','408',146472.14,147216.57,0.00,0.00,744.43,565766.80,0.00,0.00,0.00),('1','177','919','257640',4904048,'2719','408',327859.99,328446.72,0.00,0.00,586.73,445914.80,0.00,0.00,0.00),('1','177','919','257641',4904049,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257641',4904050,'2717','408',91632.59,91638.59,0.00,0.00,6.00,4560.00,0.00,0.00,0.00),('1','177','919','257641',4904051,'2718','408',147216.57,148038.88,0.00,0.00,822.31,624955.60,0.00,0.00,0.00),('1','177','919','257641',4904052,'2719','408',328446.72,328785.95,0.00,0.00,339.23,257814.80,0.00,0.00,0.00),('1','177','919','257642',4904053,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257642',4904054,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257642',4904055,'2718','408',148038.88,149916.70,0.00,0.00,1877.82,1427143.20,0.00,0.00,0.00),('1','177','919','257642',4904056,'2719','408',328785.95,329141.17,0.00,0.00,355.22,269967.20,0.00,0.00,0.00),('1','177','919','257643',4904057,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257643',4904058,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257643',4904059,'2718','408',149916.70,150846.91,0.00,0.00,930.21,706959.60,0.00,0.00,0.00),('1','177','919','257643',4904060,'2719','408',329141.17,329881.98,0.00,0.00,740.81,563015.60,0.00,0.00,0.00),('1','177','919','257644',4904061,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257644',4904062,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257644',4904063,'2718','408',150846.91,151538.48,0.00,0.00,691.57,525593.20,0.00,0.00,0.00),('1','177','919','257644',4904064,'2719','408',329881.98,330490.50,0.00,0.00,608.52,462475.20,0.00,0.00,0.00),('1','177','919','257645',4904065,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257645',4904066,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257645',4904067,'2718','408',151538.48,153162.52,0.00,0.00,1624.04,1234270.40,0.00,0.00,0.00),('1','177','919','257645',4904068,'2719','408',330490.50,331273.86,0.00,0.00,783.36,595353.60,0.00,0.00,0.00),('1','177','919','257646',4904069,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257646',4904070,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257646',4904071,'2718','408',153162.52,154525.03,0.00,0.00,1362.51,1035507.60,0.00,0.00,0.00),('1','177','919','257646',4904072,'2719','408',331273.86,331341.76,0.00,0.00,67.90,51604.00,0.00,0.00,0.00),('1','177','919','257647',4904073,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257647',4904074,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257647',4904075,'2718','408',154525.03,155333.92,0.00,0.00,808.89,614756.40,0.00,0.00,0.00),('1','177','919','257647',4904076,'2719','408',331341.76,331341.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257648',4904077,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257648',4904078,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257648',4904079,'2718','408',155333.92,155506.90,0.00,0.00,172.98,131464.80,0.00,0.00,0.00),('1','177','919','257648',4904080,'2719','408',331341.76,333741.79,0.00,0.00,2400.03,1824022.80,0.00,0.00,0.00),('1','177','919','257649',4904081,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257649',4904082,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257649',4904083,'2718','408',155506.90,155703.22,0.00,0.00,196.32,149203.20,0.00,0.00,0.00),('1','177','919','257649',4904084,'2719','408',333741.79,335411.68,0.00,0.00,1669.89,1269116.40,0.00,0.00,0.00),('1','177','919','257650',4904085,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257650',4904086,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257650',4904087,'2718','408',155703.22,156994.07,0.00,0.00,1290.85,981046.00,0.00,0.00,0.00),('1','177','919','257650',4904088,'2719','408',335411.68,336574.35,0.00,0.00,1162.67,883629.20,0.00,0.00,0.00),('1','177','919','257651',4904089,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257651',4904090,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257651',4904091,'2718','408',156994.07,157170.35,0.00,0.00,176.28,133972.80,0.00,0.00,0.00),('1','177','919','257651',4904092,'2719','408',336574.35,338429.29,0.00,0.00,1854.94,1409754.40,0.00,0.00,0.00),('1','177','919','257652',4904093,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257652',4904094,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257652',4904095,'2718','408',157170.35,157947.34,0.00,0.00,776.99,590512.40,0.00,0.00,0.00),('1','177','919','257652',4904096,'2719','408',338429.29,339086.82,0.00,0.00,657.53,499722.80,0.00,0.00,0.00),('1','177','919','257653',4904097,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257653',4904098,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257653',4904099,'2718','408',157947.34,158339.65,0.00,0.00,392.31,298155.60,0.00,0.00,0.00),('1','177','919','257653',4904100,'2719','408',339086.82,339467.56,0.00,0.00,380.74,289362.40,0.00,0.00,0.00),('1','177','919','257654',4904101,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257654',4904102,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257654',4904103,'2718','408',158339.65,160021.10,0.00,0.00,1681.45,1277902.00,0.00,0.00,0.00),('1','177','919','257654',4904104,'2719','408',339467.56,340078.60,0.00,0.00,611.04,464390.40,0.00,0.00,0.00),('1','177','919','257655',4904105,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257655',4904106,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257655',4904107,'2718','408',160021.10,160977.67,0.00,0.00,956.57,726993.20,0.00,0.00,0.00),('1','177','919','257655',4904108,'2719','408',340078.60,340858.58,0.00,0.00,779.98,592784.80,0.00,0.00,0.00),('1','177','919','257656',4904109,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257656',4904110,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257656',4904111,'2718','408',160977.67,161128.17,0.00,0.00,150.50,114380.00,0.00,0.00,0.00),('1','177','919','257656',4904112,'2719','408',340858.58,342421.27,0.00,0.00,1562.69,1187644.40,0.00,0.00,0.00),('1','177','919','257657',4904113,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257657',4904114,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257657',4904115,'2718','408',161128.17,161178.17,0.00,0.00,50.00,38000.00,0.00,0.00,0.00),('1','177','919','257657',4904116,'2719','408',342421.27,342855.33,0.00,0.00,434.06,329885.60,0.00,0.00,0.00),('1','177','919','257658',4904117,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257658',4904118,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257658',4904119,'2718','408',161178.17,161352.32,0.00,0.00,174.15,132354.00,0.00,0.00,0.00),('1','177','919','257658',4904120,'2719','408',342855.33,345127.55,0.00,0.00,2272.22,1726887.20,0.00,0.00,0.00),('1','177','919','257659',4904121,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257659',4904122,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257659',4904123,'2718','408',161352.32,161538.55,0.00,0.00,186.23,141534.80,0.00,0.00,0.00),('1','177','919','257659',4904124,'2719','408',345127.55,346734.59,0.00,0.00,1607.04,1221350.40,0.00,0.00,0.00),('1','177','919','257660',4904125,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257660',4904126,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257660',4904127,'2718','408',161538.55,162000.36,0.00,0.00,461.81,350975.60,0.00,0.00,0.00),('1','177','919','257660',4904128,'2719','408',346734.59,347070.08,0.00,0.00,335.49,254972.40,0.00,0.00,0.00),('1','177','919','257661',4904129,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257661',4904130,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257661',4904131,'2718','408',162000.36,162127.11,0.00,0.00,126.75,96330.00,0.00,0.00,0.00),('1','177','919','257661',4904132,'2719','408',347070.08,347687.66,0.00,0.00,617.58,469360.80,0.00,0.00,0.00),('1','177','919','257662',4904133,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257662',4904134,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257662',4904135,'2718','408',162127.11,162339.61,0.00,0.00,212.50,161500.00,0.00,0.00,0.00),('1','177','919','257662',4904136,'2719','408',347687.66,350358.94,0.00,0.00,2671.28,2030172.80,0.00,0.00,0.00),('1','177','919','257663',4904137,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257663',4904138,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257663',4904139,'2718','408',162339.61,163145.95,0.00,0.00,806.34,612818.40,0.00,0.00,0.00),('1','177','919','257663',4904140,'2719','408',350358.94,351367.85,0.00,0.00,1008.91,766771.60,0.00,0.00,0.00),('1','177','919','257664',4904141,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257664',4904142,'2717','408',91638.59,91638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257664',4904143,'2718','408',163145.95,163413.88,0.00,0.00,267.93,203626.80,0.00,0.00,0.00),('1','177','919','257664',4904144,'2719','408',351367.85,351566.76,0.00,0.00,198.91,151171.60,0.00,0.00,0.00),('1','177','919','257665',4904145,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257665',4904146,'2717','408',91638.59,91641.62,0.00,0.00,3.03,2302.80,0.00,0.00,0.00),('1','177','919','257665',4904147,'2718','408',163413.88,164187.69,0.00,0.00,773.81,588095.60,0.00,0.00,0.00),('1','177','919','257665',4904148,'2719','408',351566.76,352298.00,0.00,0.00,731.24,555742.40,0.00,0.00,0.00),('1','177','919','257666',4904149,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257666',4904150,'2717','408',91641.62,91642.28,0.00,0.00,0.66,501.60,0.00,0.00,0.00),('1','177','919','257666',4904151,'2718','408',164187.69,165514.72,0.00,0.00,1327.03,1008542.80,0.00,0.00,0.00),('1','177','919','257666',4904152,'2719','408',352298.00,353064.93,0.00,0.00,766.93,582866.80,0.00,0.00,0.00),('1','177','919','257667',4904153,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257667',4904154,'2717','408',91642.28,91644.25,0.00,0.00,1.97,1497.20,0.00,0.00,0.00),('1','177','919','257667',4904155,'2718','408',165514.72,166491.11,0.00,0.00,976.39,742056.40,0.00,0.00,0.00),('1','177','919','257667',4904156,'2719','408',353064.93,353580.07,0.00,0.00,515.14,391506.40,0.00,0.00,0.00),('1','177','919','257668',4904157,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257668',4904158,'2717','408',91644.25,91644.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257668',4904159,'2718','408',166491.11,166513.90,0.00,0.00,22.79,17320.40,0.00,0.00,0.00),('1','177','919','257668',4904160,'2719','408',353580.07,353616.97,0.00,0.00,36.90,28044.00,0.00,0.00,0.00),('1','177','919','257669',4904161,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257669',4904162,'2717','408',91644.25,91644.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257669',4904163,'2718','408',166513.90,167410.50,0.00,0.00,896.60,681416.00,0.00,0.00,0.00),('1','177','919','257669',4904164,'2719','408',353616.97,354380.51,0.00,0.00,763.54,580290.40,0.00,0.00,0.00),('1','177','919','257670',4904165,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257670',4904166,'2717','408',91644.25,91669.25,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('1','177','919','257670',4904167,'2718','408',167410.50,168385.38,0.00,0.00,974.88,740908.80,0.00,0.00,0.00),('1','177','919','257670',4904168,'2719','408',354380.51,355606.78,0.00,0.00,1226.27,931965.20,0.00,0.00,0.00),('1','177','919','257671',4904169,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257671',4904170,'2717','408',91669.25,91669.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257671',4904171,'2718','408',168385.38,169426.86,0.00,0.00,1041.48,791524.80,0.00,0.00,0.00),('1','177','919','257671',4904172,'2719','408',355606.78,356513.44,0.00,0.00,906.66,689061.60,0.00,0.00,0.00),('1','177','919','257672',4904173,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257672',4904174,'2717','408',91669.25,91671.25,0.00,0.00,2.00,1520.00,0.00,0.00,0.00),('1','177','919','257672',4904175,'2718','408',169426.86,169761.39,0.00,0.00,334.53,254242.80,0.00,0.00,0.00),('1','177','919','257672',4904176,'2719','408',356513.44,356782.39,0.00,0.00,268.95,204402.00,0.00,0.00,0.00),('1','177','919','257673',4904177,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257673',4904178,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257673',4904179,'2718','408',169761.39,170877.95,0.00,0.00,1116.56,848585.60,0.00,0.00,0.00),('1','177','919','257673',4904180,'2719','408',356782.39,357651.80,0.00,0.00,869.41,660751.60,0.00,0.00,0.00),('1','177','919','257674',4904181,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257674',4904182,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257674',4904183,'2718','408',170877.95,171622.80,0.00,0.00,744.85,566086.00,0.00,0.00,0.00),('1','177','919','257674',4904184,'2719','408',357651.80,358652.46,0.00,0.00,1000.66,760501.60,0.00,0.00,0.00),('1','177','919','257675',4904185,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257675',4904186,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257675',4904187,'2718','408',171622.80,171903.16,0.00,0.00,280.36,213073.60,0.00,0.00,0.00),('1','177','919','257675',4904188,'2719','408',358652.46,359113.69,0.00,0.00,461.23,350534.80,0.00,0.00,0.00),('1','177','919','257676',4904189,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257676',4904190,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257676',4904191,'2718','408',171903.16,172321.24,0.00,0.00,418.08,317740.80,0.00,0.00,0.00),('1','177','919','257676',4904192,'2719','408',359113.69,359949.06,0.00,0.00,835.37,634881.20,0.00,0.00,0.00),('1','177','919','257677',4904193,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257677',4904194,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257677',4904195,'2718','408',172321.24,172892.60,0.00,0.00,571.36,434233.60,0.00,0.00,0.00),('1','177','919','257677',4904196,'2719','408',359949.06,361078.00,0.00,0.00,1128.94,857994.40,0.00,0.00,0.00),('1','177','919','257678',4904197,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257678',4904198,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257678',4904199,'2718','408',172892.60,173077.33,0.00,0.00,184.73,140394.80,0.00,0.00,0.00),('1','177','919','257678',4904200,'2719','408',361078.00,362986.23,0.00,0.00,1908.23,1450254.80,0.00,0.00,0.00),('1','177','919','257679',4904201,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257679',4904202,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257679',4904203,'2718','408',173077.33,173077.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257679',4904204,'2719','408',362986.23,363292.34,0.00,0.00,306.11,232643.60,0.00,0.00,0.00),('1','177','919','257680',4904205,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257680',4904206,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257680',4904207,'2718','408',173077.33,173099.78,0.00,0.00,22.45,17062.00,0.00,0.00,0.00),('1','177','919','257680',4904208,'2719','408',363292.34,365252.57,0.00,0.00,1960.23,1489774.80,0.00,0.00,0.00),('1','177','919','257681',4904209,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257681',4904210,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257681',4904211,'2718','408',173099.78,173303.42,0.00,0.00,203.64,154766.40,0.00,0.00,0.00),('1','177','919','257681',4904212,'2719','408',365252.57,367000.59,0.00,0.00,1748.02,1328495.20,0.00,0.00,0.00),('1','177','919','257682',4904213,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257682',4904214,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257682',4904215,'2718','408',173303.42,173346.92,0.00,0.00,43.50,33060.00,0.00,0.00,0.00),('1','177','919','257682',4904216,'2719','408',367000.59,368422.64,0.00,0.00,1422.05,1080758.00,0.00,0.00,0.00),('1','177','919','257683',4904217,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257683',4904218,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257683',4904219,'2718','408',173346.92,173346.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257683',4904220,'2719','408',368422.64,368518.09,0.00,0.00,95.45,72542.00,0.00,0.00,0.00),('1','177','919','257684',4904221,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257684',4904222,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257684',4904223,'2718','408',173346.92,173446.92,0.00,0.00,100.00,76000.00,0.00,0.00,0.00),('1','177','919','257684',4904224,'2719','408',368518.09,369575.48,0.00,0.00,1057.39,803616.40,0.00,0.00,0.00),('1','177','919','257685',4904225,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257685',4904226,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257685',4904227,'2718','408',173446.92,173499.92,0.00,0.00,53.00,40280.00,0.00,0.00,0.00),('1','177','919','257685',4904228,'2719','408',369575.48,370726.90,0.00,0.00,1151.42,875079.20,0.00,0.00,0.00),('1','177','919','257686',4904229,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257686',4904230,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257686',4904231,'2718','408',173499.92,173538.74,0.00,0.00,38.82,29503.20,0.00,0.00,0.00),('1','177','919','257686',4904232,'2719','408',370726.90,372554.51,0.00,0.00,1827.61,1388983.60,0.00,0.00,0.00),('1','177','919','257687',4904233,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257687',4904234,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257687',4904235,'2718','408',173538.74,173588.74,0.00,0.00,50.00,38000.00,0.00,0.00,0.00),('1','177','919','257687',4904236,'2719','408',372554.51,374064.23,0.00,0.00,1509.72,1147387.20,0.00,0.00,0.00),('1','177','919','257688',4904237,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257688',4904238,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257688',4904239,'2718','408',173588.74,173653.87,0.00,0.00,65.13,49498.80,0.00,0.00,0.00),('1','177','919','257688',4904240,'2719','408',374064.23,375554.53,0.00,0.00,1490.30,1132628.00,0.00,0.00,0.00),('1','177','919','257689',4904241,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257689',4904242,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257689',4904243,'2718','408',173653.87,173864.37,0.00,0.00,210.50,159980.00,0.00,0.00,0.00),('1','177','919','257689',4904244,'2719','408',375554.53,377360.69,0.00,0.00,1806.16,1372681.60,0.00,0.00,0.00),('1','177','919','257690',4904245,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257690',4904246,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257690',4904247,'2718','408',173864.37,173864.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257690',4904248,'2719','408',377360.69,377810.51,0.00,0.00,449.82,341863.20,0.00,0.00,0.00),('1','177','919','257691',4904249,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257691',4904250,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257691',4904251,'2718','408',173864.37,174008.87,0.00,0.00,144.50,109820.00,0.00,0.00,0.00),('1','177','919','257691',4904252,'2719','408',377810.51,379787.15,0.00,0.00,1976.64,1502246.40,0.00,0.00,0.00),('1','177','919','257692',4904253,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257692',4904254,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257692',4904255,'2718','408',174008.87,174029.74,0.00,0.00,20.87,15861.20,0.00,0.00,0.00),('1','177','919','257692',4904256,'2719','408',379787.15,381391.18,0.00,0.00,1604.03,1219062.80,0.00,0.00,0.00),('1','177','919','257693',4904257,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257693',4904258,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257693',4904259,'2718','408',174029.74,174029.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257693',4904260,'2719','408',381391.18,382318.74,0.00,0.00,927.56,704945.60,0.00,0.00,0.00),('1','177','919','257694',4904261,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257694',4904262,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257694',4904263,'2718','408',174029.74,174029.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257694',4904264,'2719','408',382318.74,383450.67,0.00,0.00,1131.93,860266.80,0.00,0.00,0.00),('1','177','919','257695',4904265,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257695',4904266,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257695',4904267,'2718','408',174029.74,174379.10,0.00,0.00,349.36,265513.60,0.00,0.00,0.00),('1','177','919','257695',4904268,'2719','408',383450.67,385090.96,0.00,0.00,1640.29,1246620.40,0.00,0.00,0.00),('1','177','919','257696',4904269,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257696',4904270,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257696',4904271,'2718','408',174379.10,174442.78,0.00,0.00,63.68,48396.80,0.00,0.00,0.00),('1','177','919','257696',4904272,'2719','408',385090.96,386809.47,0.00,0.00,1718.51,1306067.60,0.00,0.00,0.00),('1','177','919','257697',4904273,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257697',4904274,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257697',4904275,'2718','408',174442.78,174475.16,0.00,0.00,32.38,24608.80,0.00,0.00,0.00),('1','177','919','257697',4904276,'2719','408',386809.47,387182.12,0.00,0.00,372.65,283214.00,0.00,0.00,0.00),('1','177','919','257698',4904277,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257698',4904278,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257698',4904279,'2718','408',174475.16,174632.88,0.00,0.00,157.72,119867.20,0.00,0.00,0.00),('1','177','919','257698',4904280,'2719','408',387182.12,388550.61,0.00,0.00,1368.49,1040052.40,0.00,0.00,0.00),('1','177','919','257699',4904281,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257699',4904282,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257699',4904283,'2718','408',174632.88,175027.35,0.00,0.00,394.47,293485.68,0.00,0.00,0.00),('1','177','919','257699',4904284,'2719','408',388550.61,389953.61,0.00,0.00,1403.00,1043832.00,0.00,0.00,0.00),('1','177','919','257700',4904285,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257700',4904286,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257700',4904287,'2718','408',175027.35,175694.71,0.00,0.00,667.36,496515.84,0.00,0.00,0.00),('1','177','919','257700',4904288,'2719','408',389953.61,390913.05,0.00,0.00,959.44,713823.36,0.00,0.00,0.00),('1','177','919','257701',4904289,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257701',4904290,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257701',4904291,'2718','408',175694.71,175714.71,0.00,0.00,20.00,14880.00,0.00,0.00,0.00),('1','177','919','257701',4904292,'2719','408',390913.05,391633.62,0.00,0.00,720.57,536104.08,0.00,0.00,0.00),('1','177','919','257702',4904293,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257702',4904294,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257702',4904295,'2718','408',175714.71,175747.89,0.00,0.00,33.18,24685.92,0.00,0.00,0.00),('1','177','919','257702',4904296,'2719','408',391633.62,392527.58,0.00,0.00,893.96,665106.24,0.00,0.00,0.00),('1','177','919','257703',4904297,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257703',4904298,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257703',4904299,'2718','408',175747.89,176012.85,0.00,0.00,264.96,197130.24,0.00,0.00,0.00),('1','177','919','257703',4904300,'2719','408',392527.58,394075.34,0.00,0.00,1547.76,1151533.44,0.00,0.00,0.00),('1','177','919','257704',4904301,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257704',4904302,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257704',4904303,'2718','408',176012.85,176764.26,0.00,0.00,751.41,559049.04,0.00,0.00,0.00),('1','177','919','257704',4904304,'2719','408',394075.34,395611.89,0.00,0.00,1536.55,1143193.20,0.00,0.00,0.00),('1','177','919','257705',4904305,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257705',4904306,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257705',4904307,'2718','408',176764.26,176865.38,0.00,0.00,101.12,75233.28,0.00,0.00,0.00),('1','177','919','257705',4904308,'2719','408',395611.89,395940.45,0.00,0.00,328.56,244448.64,0.00,0.00,0.00),('1','177','919','257706',4904309,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257706',4904310,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257706',4904311,'2718','408',176865.38,177437.28,0.00,0.00,571.90,425493.60,0.00,0.00,0.00),('1','177','919','257706',4904312,'2719','408',395940.45,396677.78,0.00,0.00,737.33,548573.52,0.00,0.00,0.00),('1','177','919','257707',4904313,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257707',4904314,'2717','408',91671.25,91671.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257707',4904315,'2718','408',177437.28,177614.56,0.00,0.00,177.28,131896.32,0.00,0.00,0.00),('1','177','919','257707',4904316,'2719','408',396677.78,398346.66,0.00,0.00,1668.88,1241646.72,0.00,0.00,0.00),('1','177','919','257708',4904317,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257708',4904318,'2717','408',91671.25,91675.95,0.00,0.00,4.70,3496.80,0.00,0.00,0.00),('1','177','919','257708',4904319,'2718','408',177614.56,178864.31,0.00,0.00,1249.75,929814.00,0.00,0.00,0.00),('1','177','919','257708',4904320,'2719','408',398346.66,399302.72,0.00,0.00,956.06,711308.64,0.00,0.00,0.00),('1','177','919','257709',4904321,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257709',4904322,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257709',4904323,'2718','408',178864.31,179765.27,0.00,0.00,900.96,670314.24,0.00,0.00,0.00),('1','177','919','257709',4904324,'2719','408',399302.72,400386.55,0.00,0.00,1083.83,806369.52,0.00,0.00,0.00),('1','177','919','257710',4904325,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257710',4904326,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257710',4904327,'2718','408',179765.27,179770.27,0.00,0.00,5.00,3720.00,0.00,0.00,0.00),('1','177','919','257710',4904328,'2719','408',400386.55,402543.36,0.00,0.00,2156.81,1604666.64,0.00,0.00,0.00),('1','177','919','257711',4904329,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257711',4904330,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257711',4904331,'2718','408',179770.27,179784.97,0.00,0.00,14.70,10936.80,0.00,0.00,0.00),('1','177','919','257711',4904332,'2719','408',402543.36,403736.06,0.00,0.00,1192.70,887368.80,0.00,0.00,0.00),('1','177','919','257712',4904333,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257712',4904334,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257712',4904335,'2718','408',179784.97,179834.97,0.00,0.00,50.00,37200.00,0.00,0.00,0.00),('1','177','919','257712',4904336,'2719','408',403736.06,404198.46,0.00,0.00,462.40,344025.60,0.00,0.00,0.00),('1','177','919','257713',4904337,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257713',4904338,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257713',4904339,'2718','408',179834.97,179932.56,0.00,0.00,97.59,72606.96,0.00,0.00,0.00),('1','177','919','257713',4904340,'2719','408',404198.46,406735.68,0.00,0.00,2537.22,1887691.68,0.00,0.00,0.00),('1','177','919','257714',4904341,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257714',4904342,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257714',4904343,'2718','408',179932.56,180874.24,0.00,0.00,941.68,700609.92,0.00,0.00,0.00),('1','177','919','257714',4904344,'2719','408',406735.68,407927.74,0.00,0.00,1192.06,886892.64,0.00,0.00,0.00),('1','177','919','257715',4904345,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257715',4904346,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257715',4904347,'2718','408',180874.24,181025.74,0.00,0.00,151.50,112716.00,0.00,0.00,0.00),('1','177','919','257715',4904348,'2719','408',407927.74,410026.02,0.00,0.00,2098.28,1561120.32,0.00,0.00,0.00),('1','177','919','257716',4904349,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257716',4904350,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257716',4904351,'2718','408',181025.74,182615.84,0.00,0.00,1590.10,1183034.40,0.00,0.00,0.00),('1','177','919','257716',4904352,'2719','408',410026.02,411143.87,0.00,0.00,1117.85,831680.40,0.00,0.00,0.00),('1','177','919','257717',4904353,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257717',4904354,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257717',4904355,'2718','408',182615.84,182908.13,0.00,0.00,292.29,217463.76,0.00,0.00,0.00),('1','177','919','257717',4904356,'2719','408',411143.87,411174.85,0.00,0.00,30.98,23049.12,0.00,0.00,0.00),('1','177','919','257718',4904357,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257718',4904358,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257718',4904359,'2718','408',182908.13,184024.96,0.00,0.00,1116.83,830921.52,0.00,0.00,0.00),('1','177','919','257718',4904360,'2719','408',411174.85,411926.02,0.00,0.00,751.17,558870.48,0.00,0.00,0.00),('1','177','919','257719',4904361,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257719',4904362,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257719',4904363,'2718','408',184024.96,184068.44,0.00,0.00,43.48,32696.96,0.00,0.00,0.00),('1','177','919','257719',4904364,'2719','408',411926.02,414049.91,0.00,0.00,2123.89,1597165.28,0.00,0.00,0.00),('1','177','919','257720',4904365,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257720',4904366,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257720',4904367,'2718','408',184068.44,184071.51,0.00,0.00,3.07,2308.64,0.00,0.00,0.00),('1','177','919','257720',4904368,'2719','408',414049.91,414716.98,0.00,0.00,667.07,501636.64,0.00,0.00,0.00),('1','177','919','257721',4904369,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257721',4904370,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257721',4904371,'2718','408',184071.51,184071.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257721',4904372,'2719','408',414716.98,416307.78,0.00,0.00,1590.80,1196281.60,0.00,0.00,0.00),('1','177','919','257722',4904373,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257722',4904374,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257722',4904375,'2718','408',184071.51,184306.31,0.00,0.00,234.80,176569.60,0.00,0.00,0.00),('1','177','919','257722',4904376,'2719','408',416307.78,418110.62,0.00,0.00,1802.84,1355735.68,0.00,0.00,0.00),('1','177','919','257723',4904377,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257723',4904378,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257723',4904379,'2718','408',184306.31,185429.45,0.00,0.00,1123.14,844601.28,0.00,0.00,0.00),('1','177','919','257723',4904380,'2719','408',418110.62,418941.73,0.00,0.00,831.11,624994.72,0.00,0.00,0.00),('1','177','919','257724',4904381,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257724',4904382,'2717','408',91675.95,91675.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257724',4904383,'2718','408',185429.45,185551.95,0.00,0.00,122.50,92120.00,0.00,0.00,0.00),('1','177','919','257724',4904384,'2719','408',418941.73,421197.06,0.00,0.00,2255.33,1696008.16,0.00,0.00,0.00),('1','177','919','257725',4904385,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257725',4904386,'2717','408',91675.95,91725.95,0.00,0.00,50.00,37600.00,0.00,0.00,0.00),('1','177','919','257725',4904387,'2718','408',185551.95,186851.98,0.00,0.00,1300.03,977622.56,0.00,0.00,0.00),('1','177','919','257725',4904388,'2719','408',421197.06,422528.73,0.00,0.00,1331.67,1001415.84,0.00,0.00,0.00),('1','177','919','257726',4904389,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257726',4904390,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257726',4904391,'2718','408',186851.98,187275.73,0.00,0.00,423.75,318660.00,0.00,0.00,0.00),('1','177','919','257726',4904392,'2719','408',422528.73,422732.14,0.00,0.00,203.41,152964.32,0.00,0.00,0.00),('1','177','919','257727',4904393,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257727',4904394,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257727',4904395,'2718','408',187275.73,187275.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257727',4904396,'2719','408',422732.14,422732.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257728',4904397,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257728',4904398,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257728',4904399,'2718','408',187275.73,187947.86,0.00,0.00,672.13,505441.76,0.00,0.00,0.00),('1','177','919','257728',4904400,'2719','408',422732.14,423569.09,0.00,0.00,836.95,629386.40,0.00,0.00,0.00),('1','177','919','257729',4904401,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257729',4904402,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257729',4904403,'2718','408',187947.86,188053.91,0.00,0.00,106.05,79749.60,0.00,0.00,0.00),('1','177','919','257729',4904404,'2719','408',423569.09,425631.84,0.00,0.00,2062.75,1551188.00,0.00,0.00,0.00),('1','177','919','257730',4904405,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257730',4904406,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257730',4904407,'2718','408',188053.91,188370.01,0.00,0.00,316.10,235178.40,0.00,0.00,0.00),('1','177','919','257730',4904408,'2719','408',425631.84,426600.40,0.00,0.00,968.56,720608.64,0.00,0.00,0.00),('1','177','919','257731',4904409,'2716','408',35583.64,35583.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257731',4904410,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257731',4904411,'2718','408',188370.01,188610.15,0.00,0.00,240.14,178664.16,0.00,0.00,0.00),('1','177','919','257731',4904412,'2719','408',426600.40,426997.73,0.00,0.00,397.33,295613.52,0.00,0.00,0.00),('1','177','919','257732',4904413,'2716','408',35583.64,35586.66,0.00,0.00,3.02,2246.88,0.00,0.00,0.00),('1','177','919','257732',4904414,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257732',4904415,'2718','408',188610.15,188811.58,0.00,0.00,201.43,149863.92,0.00,0.00,0.00),('1','177','919','257732',4904416,'2719','408',426997.73,428606.82,0.00,0.00,1609.09,1197162.96,0.00,0.00,0.00),('1','177','919','257733',4904417,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257733',4904418,'2717','408',91725.95,91725.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257733',4904419,'2718','408',188811.58,190172.63,0.00,0.00,1361.05,1012621.20,0.00,0.00,0.00),('1','177','919','257733',4904420,'2719','408',428606.82,429715.52,0.00,0.00,1108.70,824872.80,0.00,0.00,0.00),('1','177','919','257734',4904421,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257734',4904422,'2717','408',91725.95,91727.29,0.00,0.00,1.34,996.96,0.00,0.00,0.00),('1','177','919','257734',4904423,'2718','408',190172.63,190485.30,0.00,0.00,312.67,232626.48,0.00,0.00,0.00),('1','177','919','257734',4904424,'2719','408',429715.52,431032.20,0.00,0.00,1316.68,979609.92,0.00,0.00,0.00),('1','177','919','257735',4904425,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257735',4904426,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257735',4904427,'2718','408',190485.30,191517.93,0.00,0.00,1032.63,768276.72,0.00,0.00,0.00),('1','177','919','257735',4904428,'2719','408',431032.20,432126.19,0.00,0.00,1093.99,813928.56,0.00,0.00,0.00),('1','177','919','257736',4904429,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257736',4904430,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257736',4904431,'2718','408',191517.93,192493.31,0.00,0.00,975.38,725682.72,0.00,0.00,0.00),('1','177','919','257736',4904432,'2719','408',432126.19,433197.23,0.00,0.00,1071.04,796853.76,0.00,0.00,0.00),('1','177','919','257737',4904433,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257737',4904434,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257737',4904435,'2718','408',192493.31,192518.48,0.00,0.00,25.17,18726.48,0.00,0.00,0.00),('1','177','919','257737',4904436,'2719','408',433197.23,434403.32,0.00,0.00,1206.09,897330.96,0.00,0.00,0.00),('1','177','919','257738',4904437,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257738',4904438,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257738',4904439,'2718','408',192518.48,192566.20,0.00,0.00,47.72,35503.68,0.00,0.00,0.00),('1','177','919','257738',4904440,'2719','408',434403.32,435163.32,0.00,0.00,760.00,565440.00,0.00,0.00,0.00),('1','177','919','257739',4904441,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257739',4904442,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257739',4904443,'2718','408',192566.20,192738.42,0.00,0.00,172.22,128131.68,0.00,0.00,0.00),('1','177','919','257739',4904444,'2719','408',435163.32,437030.96,0.00,0.00,1867.64,1389524.16,0.00,0.00,0.00),('1','177','919','257740',4904445,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257740',4904446,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257740',4904447,'2718','408',192738.42,192891.95,0.00,0.00,153.53,114226.32,0.00,0.00,0.00),('1','177','919','257740',4904448,'2719','408',437030.96,438651.47,0.00,0.00,1620.51,1205659.44,0.00,0.00,0.00),('1','177','919','257741',4904449,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257741',4904450,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257741',4904451,'2718','408',192891.95,193121.58,0.00,0.00,229.63,170844.72,0.00,0.00,0.00),('1','177','919','257741',4904452,'2719','408',438651.47,438855.43,0.00,0.00,203.96,151746.24,0.00,0.00,0.00),('1','177','919','257742',4904453,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257742',4904454,'2717','408',91727.29,91727.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257742',4904455,'2718','408',193121.58,193121.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257742',4904456,'2719','408',438855.43,438855.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257743',4904457,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257743',4904458,'2717','408',91727.29,91736.36,0.00,0.00,9.07,6748.08,0.00,0.00,0.00),('1','177','919','257743',4904459,'2718','408',193121.58,194673.47,0.00,0.00,1551.89,1154606.16,0.00,0.00,0.00),('1','177','919','257743',4904460,'2719','408',438855.43,439648.68,0.00,0.00,793.25,590178.00,0.00,0.00,0.00),('1','177','919','257744',4904461,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257744',4904462,'2717','408',91736.36,91748.86,0.00,0.00,12.50,9300.00,0.00,0.00,0.00),('1','177','919','257744',4904463,'2718','408',194673.47,196093.26,0.00,0.00,1419.79,1056323.76,0.00,0.00,0.00),('1','177','919','257744',4904464,'2719','408',439648.68,440625.63,0.00,0.00,976.95,726850.80,0.00,0.00,0.00),('1','177','919','257745',4904465,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257745',4904466,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257745',4904467,'2718','408',196093.26,196200.43,0.00,0.00,107.17,79734.48,0.00,0.00,0.00),('1','177','919','257745',4904468,'2719','408',440625.63,440898.66,0.00,0.00,273.03,203134.32,0.00,0.00,0.00),('1','177','919','257746',4904469,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257746',4904470,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257746',4904471,'2718','408',196200.43,196437.36,0.00,0.00,236.93,176275.92,0.00,0.00,0.00),('1','177','919','257746',4904472,'2719','408',440898.66,442447.64,0.00,0.00,1548.98,1152441.12,0.00,0.00,0.00),('1','177','919','257747',4904473,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257747',4904474,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257747',4904475,'2718','408',196437.36,196461.86,0.00,0.00,24.50,18228.00,0.00,0.00,0.00),('1','177','919','257747',4904476,'2719','408',442447.64,444712.61,0.00,0.00,2264.97,1685137.68,0.00,0.00,0.00),('1','177','919','257748',4904477,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257748',4904478,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257748',4904479,'2718','408',196461.86,197012.00,0.00,0.00,550.14,409304.16,0.00,0.00,0.00),('1','177','919','257748',4904480,'2719','408',444712.61,445673.29,0.00,0.00,960.68,714745.92,0.00,0.00,0.00),('1','177','919','257749',4904481,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257749',4904482,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257749',4904483,'2718','408',197012.00,197012.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257749',4904484,'2719','408',445673.29,446037.62,0.00,0.00,364.33,271061.52,0.00,0.00,0.00),('1','177','919','257750',4904485,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257750',4904486,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257750',4904487,'2718','408',197012.00,198915.37,0.00,0.00,1903.37,1416107.28,0.00,0.00,0.00),('1','177','919','257750',4904488,'2719','408',446037.62,446512.45,0.00,0.00,474.83,353273.52,0.00,0.00,0.00),('1','177','919','257751',4904489,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257751',4904490,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257751',4904491,'2718','408',198915.37,199361.19,0.00,0.00,445.82,331690.08,0.00,0.00,0.00),('1','177','919','257751',4904492,'2719','408',446512.45,447996.57,0.00,0.00,1484.12,1104185.28,0.00,0.00,0.00),('1','177','919','257752',4904493,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257752',4904494,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257752',4904495,'2718','408',199361.19,200248.42,0.00,0.00,887.23,660099.12,0.00,0.00,0.00),('1','177','919','257752',4904496,'2719','408',447996.57,448418.60,0.00,0.00,422.03,313990.32,0.00,0.00,0.00),('1','177','919','257753',4904497,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257753',4904498,'2717','408',91748.86,91748.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257753',4904499,'2718','408',200248.42,201166.61,0.00,0.00,918.19,683133.36,0.00,0.00,0.00),('1','177','919','257753',4904500,'2719','408',448418.60,448755.07,0.00,0.00,336.47,250333.68,0.00,0.00,0.00),('1','177','919','257754',4904501,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257754',4904502,'2717','408',91748.86,91758.27,0.00,0.00,9.41,7001.04,0.00,0.00,0.00),('1','177','919','257754',4904503,'2718','408',201166.61,202856.30,0.00,0.00,1689.69,1257129.36,0.00,0.00,0.00),('1','177','919','257754',4904504,'2719','408',448755.07,449402.73,0.00,0.00,647.66,481859.04,0.00,0.00,0.00),('1','177','919','257755',4904505,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257755',4904506,'2717','408',91758.27,91758.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257755',4904507,'2718','408',202856.30,204555.07,0.00,0.00,1698.77,1263884.88,0.00,0.00,0.00),('1','177','919','257755',4904508,'2719','408',449402.73,450164.99,0.00,0.00,762.26,567121.44,0.00,0.00,0.00),('1','177','919','257756',4904509,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257756',4904510,'2717','408',91758.27,91758.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257756',4904511,'2718','408',204555.07,204573.07,0.00,0.00,18.00,13392.00,0.00,0.00,0.00),('1','177','919','257756',4904512,'2719','408',450164.99,450777.34,0.00,0.00,612.35,455588.40,0.00,0.00,0.00),('1','177','919','257757',4904513,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257757',4904514,'2717','408',91758.27,91758.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257757',4904515,'2718','408',204573.07,204710.48,0.00,0.00,137.41,102233.04,0.00,0.00,0.00),('1','177','919','257757',4904516,'2719','408',450777.34,452182.48,0.00,0.00,1405.14,1045424.16,0.00,0.00,0.00),('1','177','919','257758',4904517,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257758',4904518,'2717','408',91758.27,91764.27,0.00,0.00,6.00,4464.00,0.00,0.00,0.00),('1','177','919','257758',4904519,'2718','408',204710.48,205145.09,0.00,0.00,434.61,323349.84,0.00,0.00,0.00),('1','177','919','257758',4904520,'2719','408',452182.48,453917.48,0.00,0.00,1735.00,1290840.00,0.00,0.00,0.00),('1','177','919','257759',4904521,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257759',4904522,'2717','408',91764.27,91769.31,0.00,0.00,5.04,3749.76,0.00,0.00,0.00),('1','177','919','257759',4904523,'2718','408',205145.09,206222.73,0.00,0.00,1077.64,801764.16,0.00,0.00,0.00),('1','177','919','257759',4904524,'2719','408',453917.48,454360.71,0.00,0.00,443.23,329763.12,0.00,0.00,0.00),('1','177','919','257760',4904525,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257760',4904526,'2717','408',91769.31,91769.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257760',4904527,'2718','408',206222.73,206872.04,0.00,0.00,649.31,483086.64,0.00,0.00,0.00),('1','177','919','257760',4904528,'2719','408',454360.71,454760.16,0.00,0.00,399.45,297190.80,0.00,0.00,0.00),('1','177','919','257761',4904529,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257761',4904530,'2717','408',91769.31,91769.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257761',4904531,'2718','408',206872.04,206932.36,0.00,0.00,60.32,44878.08,0.00,0.00,0.00),('1','177','919','257761',4904532,'2719','408',454760.16,456710.05,0.00,0.00,1949.89,1450718.16,0.00,0.00,0.00),('1','177','919','257762',4904533,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257762',4904534,'2717','408',91769.31,91769.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257762',4904535,'2718','408',206932.36,208398.57,0.00,0.00,1466.21,1090860.24,0.00,0.00,0.00),('1','177','919','257762',4904536,'2719','408',456710.05,457598.90,0.00,0.00,888.85,661304.40,0.00,0.00,0.00),('1','177','919','257763',4904537,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257763',4904538,'2717','408',91769.31,91775.36,0.00,0.00,6.05,4501.20,0.00,0.00,0.00),('1','177','919','257763',4904539,'2718','408',208398.57,208786.03,0.00,0.00,387.46,288270.24,0.00,0.00,0.00),('1','177','919','257763',4904540,'2719','408',457598.90,458845.80,0.00,0.00,1246.90,927693.60,0.00,0.00,0.00),('1','177','919','257764',4904541,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257764',4904542,'2717','408',91775.36,91775.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257764',4904543,'2718','408',208786.03,209161.44,0.00,0.00,375.41,279305.04,0.00,0.00,0.00),('1','177','919','257764',4904544,'2719','408',458845.80,460793.89,0.00,0.00,1948.09,1449378.96,0.00,0.00,0.00),('1','177','919','257765',4904545,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257765',4904546,'2717','408',91775.36,91775.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257765',4904547,'2718','408',209161.44,209481.61,0.00,0.00,320.17,238206.48,0.00,0.00,0.00),('1','177','919','257765',4904548,'2719','408',460793.89,461872.62,0.00,0.00,1078.73,802575.12,0.00,0.00,0.00),('1','177','919','257766',4904549,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257766',4904550,'2717','408',91775.36,91775.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257766',4904551,'2718','408',209481.61,209481.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257766',4904552,'2719','408',461872.62,461872.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257767',4904553,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257767',4904554,'2717','408',91775.36,91775.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257767',4904555,'2718','408',209481.61,209661.77,0.00,0.00,180.16,134039.04,0.00,0.00,0.00),('1','177','919','257767',4904556,'2719','408',461872.62,462601.48,0.00,0.00,728.86,542271.84,0.00,0.00,0.00),('1','177','919','257768',4904557,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257768',4904558,'2717','408',91775.36,91790.36,0.00,0.00,15.00,11160.00,0.00,0.00,0.00),('1','177','919','257768',4904559,'2718','408',209661.77,210823.07,0.00,0.00,1161.30,864007.20,0.00,0.00,0.00),('1','177','919','257768',4904560,'2719','408',462601.48,463269.68,0.00,0.00,668.20,497140.80,0.00,0.00,0.00),('1','177','919','257769',4904561,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257769',4904562,'2717','408',91790.36,91790.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257769',4904563,'2718','408',210823.07,211940.82,0.00,0.00,1117.75,831606.00,0.00,0.00,0.00),('1','177','919','257769',4904564,'2719','408',463269.68,464173.66,0.00,0.00,903.98,672561.12,0.00,0.00,0.00),('1','177','919','257770',4904565,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257770',4904566,'2717','408',91790.36,91793.76,0.00,0.00,3.40,2502.40,0.00,0.00,0.00),('1','177','919','257770',4904567,'2718','408',211940.82,212046.21,0.00,0.00,105.39,77567.04,0.00,0.00,0.00),('1','177','919','257770',4904568,'2719','408',464173.66,464246.11,0.00,0.00,72.45,53323.20,0.00,0.00,0.00),('1','177','919','257771',4904569,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257771',4904570,'2717','408',91793.76,91817.31,0.00,0.00,23.55,17332.80,0.00,0.00,0.00),('1','177','919','257771',4904571,'2718','408',212046.21,213123.25,0.00,0.00,1077.04,792701.44,0.00,0.00,0.00),('1','177','919','257771',4904572,'2719','408',464246.11,465339.23,0.00,0.00,1093.12,804536.32,0.00,0.00,0.00),('1','177','919','257772',4904573,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257772',4904574,'2717','408',91817.31,91821.39,0.00,0.00,4.08,3002.88,0.00,0.00,0.00),('1','177','919','257772',4904575,'2718','408',213123.25,214632.51,0.00,0.00,1509.26,1110815.36,0.00,0.00,0.00),('1','177','919','257772',4904576,'2719','408',465339.23,466433.17,0.00,0.00,1093.94,805139.84,0.00,0.00,0.00),('1','177','919','257773',4904577,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257773',4904578,'2717','408',91821.39,91821.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257773',4904579,'2718','408',214632.51,214772.73,0.00,0.00,140.22,103201.92,0.00,0.00,0.00),('1','177','919','257773',4904580,'2719','408',466433.17,466490.86,0.00,0.00,57.69,42459.84,0.00,0.00,0.00),('1','177','919','257774',4904581,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257774',4904582,'2717','408',91821.39,91821.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257774',4904583,'2718','408',214772.73,215245.55,0.00,0.00,472.82,347995.52,0.00,0.00,0.00),('1','177','919','257774',4904584,'2719','408',466490.86,466892.43,0.00,0.00,401.57,295555.52,0.00,0.00,0.00),('1','177','919','257775',4904585,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257775',4904586,'2717','408',91821.39,91867.52,0.00,0.00,46.13,33951.68,0.00,0.00,0.00),('1','177','919','257775',4904587,'2718','408',215245.55,216309.35,0.00,0.00,1063.80,782956.80,0.00,0.00,0.00),('1','177','919','257775',4904588,'2719','408',466892.43,467678.95,0.00,0.00,786.52,578878.72,0.00,0.00,0.00),('1','177','919','257776',4904589,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257776',4904590,'2717','408',91867.52,91881.60,0.00,0.00,14.08,10362.88,0.00,0.00,0.00),('1','177','919','257776',4904591,'2718','408',216309.35,217696.98,0.00,0.00,1387.63,1021295.68,0.00,0.00,0.00),('1','177','919','257776',4904592,'2719','408',467678.95,468416.63,0.00,0.00,737.68,542932.48,0.00,0.00,0.00),('1','177','919','257777',4904593,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257777',4904594,'2717','408',91881.60,91893.83,0.00,0.00,12.23,9001.28,0.00,0.00,0.00),('1','177','919','257777',4904595,'2718','408',217696.98,217949.50,0.00,0.00,252.52,185854.72,0.00,0.00,0.00),('1','177','919','257777',4904596,'2719','408',468416.63,468496.69,0.00,0.00,80.06,58924.16,0.00,0.00,0.00),('1','177','919','257778',4904597,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257778',4904598,'2717','408',91893.83,91893.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257778',4904599,'2718','408',217949.50,218987.07,0.00,0.00,1037.57,763651.52,0.00,0.00,0.00),('1','177','919','257778',4904600,'2719','408',468496.69,469429.63,0.00,0.00,932.94,686643.84,0.00,0.00,0.00),('1','177','919','257779',4904601,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257779',4904602,'2717','408',91893.83,91893.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257779',4904603,'2718','408',218987.07,220494.55,0.00,0.00,1507.48,1109505.28,0.00,0.00,0.00),('1','177','919','257779',4904604,'2719','408',469429.63,470235.25,0.00,0.00,805.62,592936.32,0.00,0.00,0.00),('1','177','919','257780',4904605,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257780',4904606,'2717','408',91893.83,91893.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257780',4904607,'2718','408',220494.55,221015.85,0.00,0.00,521.30,383676.80,0.00,0.00,0.00),('1','177','919','257780',4904608,'2719','408',470235.25,470551.14,0.00,0.00,315.89,232495.04,0.00,0.00,0.00),('1','177','919','257781',4904609,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257781',4904610,'2717','408',91893.83,91896.55,0.00,0.00,2.72,2001.92,0.00,0.00,0.00),('1','177','919','257781',4904611,'2718','408',221015.85,222486.39,0.00,0.00,1470.54,1082317.44,0.00,0.00,0.00),('1','177','919','257781',4904612,'2719','408',470551.14,471121.21,0.00,0.00,570.07,421085.52,0.00,0.00,0.00),('1','177','919','257782',4904613,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257782',4904614,'2717','408',91896.55,91921.55,0.00,0.00,25.00,18400.00,0.00,0.00,0.00),('1','177','919','257782',4904615,'2718','408',222486.39,223803.17,0.00,0.00,1316.78,969150.08,0.00,0.00,0.00),('1','177','919','257782',4904616,'2719','408',471121.21,471831.46,0.00,0.00,710.25,522744.00,0.00,0.00,0.00),('1','177','919','257783',4904617,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257783',4904618,'2717','408',91921.55,91921.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257783',4904619,'2718','408',223803.17,223988.43,0.00,0.00,185.26,136351.36,0.00,0.00,0.00),('1','177','919','257783',4904620,'2719','408',471831.46,472699.04,0.00,0.00,867.58,638538.88,0.00,0.00,0.00),('1','177','919','257784',4904621,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257784',4904622,'2717','408',91921.55,91921.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257784',4904623,'2718','408',223988.43,224146.92,0.00,0.00,158.49,116648.64,0.00,0.00,0.00),('1','177','919','257784',4904624,'2719','408',472699.04,473909.64,0.00,0.00,1210.60,891001.60,0.00,0.00,0.00),('1','177','919','257785',4904625,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257785',4904626,'2717','408',91921.55,91921.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257785',4904627,'2718','408',224146.92,224334.11,0.00,0.00,187.19,137771.84,0.00,0.00,0.00),('1','177','919','257785',4904628,'2719','408',473909.64,476032.94,0.00,0.00,2123.30,1562748.80,0.00,0.00,0.00),('1','177','919','257786',4904629,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257786',4904630,'2717','408',91921.55,91921.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257786',4904631,'2718','408',224334.11,224458.42,0.00,0.00,124.31,91492.16,0.00,0.00,0.00),('1','177','919','257786',4904632,'2719','408',476032.94,477456.15,0.00,0.00,1423.21,1047482.56,0.00,0.00,0.00),('1','177','919','257787',4904633,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257787',4904634,'2717','408',91921.55,91921.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257787',4904635,'2718','408',224458.42,224557.76,0.00,0.00,99.34,73114.24,0.00,0.00,0.00),('1','177','919','257787',4904636,'2719','408',477456.15,477923.06,0.00,0.00,466.91,343645.76,0.00,0.00,0.00),('1','177','919','257788',4904637,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257788',4904638,'2717','408',91921.55,91946.90,0.00,0.00,25.35,18657.60,0.00,0.00,0.00),('1','177','919','257788',4904639,'2718','408',224557.76,225803.21,0.00,0.00,1245.45,916651.20,0.00,0.00,0.00),('1','177','919','257788',4904640,'2719','408',477923.06,479087.02,0.00,0.00,1163.96,856674.56,0.00,0.00,0.00),('1','177','919','257789',4904641,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257789',4904642,'2717','408',91946.90,91946.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257789',4904643,'2718','408',225803.21,226063.65,0.00,0.00,260.44,191683.84,0.00,0.00,0.00),('1','177','919','257789',4904644,'2719','408',479087.02,480864.86,0.00,0.00,1777.84,1308490.24,0.00,0.00,0.00),('1','177','919','257790',4904645,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257790',4904646,'2717','408',91946.90,91953.09,0.00,0.00,6.19,4555.84,0.00,0.00,0.00),('1','177','919','257790',4904647,'2718','408',226063.65,226672.36,0.00,0.00,608.71,448010.56,0.00,0.00,0.00),('1','177','919','257790',4904648,'2719','408',480864.86,481243.12,0.00,0.00,378.26,278399.36,0.00,0.00,0.00),('1','177','919','257791',4904649,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257791',4904650,'2717','408',91953.09,91953.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257791',4904651,'2718','408',226672.36,227543.69,0.00,0.00,871.33,641298.88,0.00,0.00,0.00),('1','177','919','257791',4904652,'2719','408',481243.12,481871.08,0.00,0.00,627.96,462178.56,0.00,0.00,0.00),('1','177','919','257792',4904653,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257792',4904654,'2717','408',91953.09,91965.59,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','177','919','257792',4904655,'2718','408',227543.69,228963.07,0.00,0.00,1419.38,1044663.68,0.00,0.00,0.00),('1','177','919','257792',4904656,'2719','408',481871.08,482631.38,0.00,0.00,760.30,559580.80,0.00,0.00,0.00),('1','177','919','257793',4904657,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257793',4904658,'2717','408',91965.59,91968.65,0.00,0.00,3.06,2252.16,0.00,0.00,0.00),('1','177','919','257793',4904659,'2718','408',228963.07,229161.32,0.00,0.00,198.25,145912.00,0.00,0.00,0.00),('1','177','919','257793',4904660,'2719','408',482631.38,484326.50,0.00,0.00,1695.12,1247608.32,0.00,0.00,0.00),('1','177','919','257794',4904661,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257794',4904662,'2717','408',91968.65,91968.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257794',4904663,'2718','408',229161.32,229237.39,0.00,0.00,76.07,55987.52,0.00,0.00,0.00),('1','177','919','257794',4904664,'2719','408',484326.50,486838.10,0.00,0.00,2511.60,1848537.60,0.00,0.00,0.00),('1','177','919','257795',4904665,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257795',4904666,'2717','408',91968.65,91968.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257795',4904667,'2718','408',229237.39,229555.06,0.00,0.00,317.67,233805.12,0.00,0.00,0.00),('1','177','919','257795',4904668,'2719','408',486838.10,488180.46,0.00,0.00,1342.36,987976.96,0.00,0.00,0.00),('1','177','919','257796',4904669,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257796',4904670,'2717','408',91968.65,91975.44,0.00,0.00,6.79,4997.44,0.00,0.00,0.00),('1','177','919','257796',4904671,'2718','408',229555.06,230281.84,0.00,0.00,726.78,534910.08,0.00,0.00,0.00),('1','177','919','257796',4904672,'2719','408',488180.46,488779.54,0.00,0.00,599.08,440922.88,0.00,0.00,0.00),('1','177','919','257797',4904673,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257797',4904674,'2717','408',91975.44,91975.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257797',4904675,'2718','408',230281.84,230607.48,0.00,0.00,325.64,239671.04,0.00,0.00,0.00),('1','177','919','257797',4904676,'2719','408',488779.54,491498.80,0.00,0.00,2719.26,2001375.36,0.00,0.00,0.00),('1','177','919','257798',4904677,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257798',4904678,'2717','408',91975.44,91975.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257798',4904679,'2718','408',230607.48,231256.96,0.00,0.00,649.48,478017.28,0.00,0.00,0.00),('1','177','919','257798',4904680,'2719','408',491498.80,491641.87,0.00,0.00,143.07,105299.52,0.00,0.00,0.00),('1','177','919','257799',4904681,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257799',4904682,'2717','408',91975.44,92006.37,0.00,0.00,30.93,23630.52,0.00,0.00,0.00),('1','177','919','257799',4904683,'2718','408',231256.96,233081.70,0.00,0.00,1824.74,1394101.36,0.00,0.00,0.00),('1','177','919','257799',4904684,'2719','408',491641.87,493489.84,0.00,0.00,1847.97,1411849.08,0.00,0.00,0.00),('1','177','919','257800',4904685,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257800',4904686,'2717','408',92006.37,92006.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257800',4904687,'2718','408',233081.70,233108.66,0.00,0.00,26.96,20597.44,0.00,0.00,0.00),('1','177','919','257800',4904688,'2719','408',493489.84,494150.49,0.00,0.00,660.65,504736.60,0.00,0.00,0.00),('1','177','919','257801',4904689,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257801',4904690,'2717','408',92006.37,92006.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257801',4904691,'2718','408',233108.66,233108.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257801',4904692,'2719','408',494150.49,494150.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257802',4904693,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257802',4904694,'2717','408',92006.37,92006.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257802',4904695,'2718','408',233108.66,233108.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257802',4904696,'2719','408',494150.49,494150.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257803',4904697,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257803',4904698,'2717','408',92006.37,92021.94,0.00,0.00,15.57,11646.36,0.00,0.00,0.00),('1','177','919','257803',4904699,'2718','408',233108.66,234556.58,0.00,0.00,1447.92,1083044.16,0.00,0.00,0.00),('1','177','919','257803',4904700,'2719','408',494150.49,494741.74,0.00,0.00,591.25,442255.00,0.00,0.00,0.00),('1','177','919','257804',4904701,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257804',4904702,'2717','408',92021.94,92139.79,0.00,0.00,117.85,88151.80,0.00,0.00,0.00),('1','177','919','257804',4904703,'2718','408',234556.58,236046.78,0.00,0.00,1490.20,1114669.60,0.00,0.00,0.00),('1','177','919','257804',4904704,'2719','408',494741.74,496089.84,0.00,0.00,1348.10,1008378.80,0.00,0.00,0.00),('1','177','919','257805',4904705,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257805',4904706,'2717','408',92139.79,92142.86,0.00,0.00,3.07,2296.36,0.00,0.00,0.00),('1','177','919','257805',4904707,'2718','408',236046.78,237038.92,0.00,0.00,992.14,742120.72,0.00,0.00,0.00),('1','177','919','257805',4904708,'2719','408',496089.84,496995.91,0.00,0.00,906.07,677740.36,0.00,0.00,0.00),('1','177','919','257806',4904709,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257806',4904710,'2717','408',92142.86,92158.30,0.00,0.00,15.44,11549.12,0.00,0.00,0.00),('1','177','919','257806',4904711,'2718','408',237038.92,239139.76,0.00,0.00,2100.84,1571428.32,0.00,0.00,0.00),('1','177','919','257806',4904712,'2719','408',496995.91,498335.03,0.00,0.00,1339.12,1001661.76,0.00,0.00,0.00),('1','177','919','257807',4904713,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257807',4904714,'2717','408',92158.30,92158.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257807',4904715,'2718','408',239139.76,240522.16,0.00,0.00,1382.40,1034035.20,0.00,0.00,0.00),('1','177','919','257807',4904716,'2719','408',498335.03,499349.13,0.00,0.00,1014.10,758546.80,0.00,0.00,0.00),('1','177','919','257808',4904717,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257808',4904718,'2717','408',92158.30,92158.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257808',4904719,'2718','408',240522.16,240788.56,0.00,0.00,266.40,199267.20,0.00,0.00,0.00),('1','177','919','257808',4904720,'2719','408',499349.13,501491.93,0.00,0.00,2142.80,1602814.40,0.00,0.00,0.00),('1','177','919','257809',4904721,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257809',4904722,'2717','408',92158.30,92158.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257809',4904723,'2718','408',240788.56,240837.61,0.00,0.00,49.05,36689.40,0.00,0.00,0.00),('1','177','919','257809',4904724,'2719','408',501491.93,502211.85,0.00,0.00,719.92,538500.16,0.00,0.00,0.00),('1','177','919','257810',4904725,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257810',4904726,'2717','408',92158.30,92158.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257810',4904727,'2718','408',240837.61,241376.74,0.00,0.00,539.13,403269.24,0.00,0.00,0.00),('1','177','919','257810',4904728,'2719','408',502211.85,504119.06,0.00,0.00,1907.21,1426593.08,0.00,0.00,0.00),('1','177','919','257811',4904729,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257811',4904730,'2717','408',92158.30,92158.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257811',4904731,'2718','408',241376.74,242567.20,0.00,0.00,1190.46,904749.60,0.00,0.00,0.00),('1','177','919','257811',4904732,'2719','408',504119.06,505043.78,0.00,0.00,924.72,702787.20,0.00,0.00,0.00),('1','177','919','257812',4904733,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257812',4904734,'2717','408',92158.30,92178.04,0.00,0.00,19.74,15002.40,0.00,0.00,0.00),('1','177','919','257812',4904735,'2718','408',242567.20,243349.61,0.00,0.00,782.41,594631.60,0.00,0.00,0.00),('1','177','919','257812',4904736,'2719','408',505043.78,505639.87,0.00,0.00,596.09,453028.40,0.00,0.00,0.00),('1','177','919','257813',4904737,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257813',4904738,'2717','408',92178.04,92178.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257813',4904739,'2718','408',243349.61,243858.30,0.00,0.00,508.69,386604.40,0.00,0.00,0.00),('1','177','919','257813',4904740,'2719','408',505639.87,505864.77,0.00,0.00,224.90,170924.00,0.00,0.00,0.00),('1','177','919','257814',4904741,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257814',4904742,'2717','408',92178.04,92178.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257814',4904743,'2718','408',243858.30,245709.19,0.00,0.00,1850.89,1406676.40,0.00,0.00,0.00),('1','177','919','257814',4904744,'2719','408',505864.77,507193.57,0.00,0.00,1328.80,1009888.00,0.00,0.00,0.00),('1','177','919','257815',4904745,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257815',4904746,'2717','408',92178.04,92178.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257815',4904747,'2718','408',245709.19,247064.65,0.00,0.00,1355.46,1030149.60,0.00,0.00,0.00),('1','177','919','257815',4904748,'2719','408',507193.57,507826.58,0.00,0.00,633.01,481087.60,0.00,0.00,0.00),('1','177','919','257816',4904749,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257816',4904750,'2717','408',92178.04,92178.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257816',4904751,'2718','408',247064.65,247793.19,0.00,0.00,728.54,553690.40,0.00,0.00,0.00),('1','177','919','257816',4904752,'2719','408',507826.58,508195.48,0.00,0.00,368.90,280364.00,0.00,0.00,0.00),('1','177','919','257817',4904753,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257817',4904754,'2717','408',92178.04,92203.04,0.00,0.00,25.00,19000.00,0.00,0.00,0.00),('1','177','919','257817',4904755,'2718','408',247793.19,249948.00,0.00,0.00,2154.81,1637655.60,0.00,0.00,0.00),('1','177','919','257817',4904756,'2719','408',508195.48,509008.28,0.00,0.00,812.80,617728.00,0.00,0.00,0.00),('1','177','919','257818',4904757,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257818',4904758,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257818',4904759,'2718','408',249948.00,250437.43,0.00,0.00,489.43,371966.80,0.00,0.00,0.00),('1','177','919','257818',4904760,'2719','408',509008.28,509179.05,0.00,0.00,170.77,129785.20,0.00,0.00,0.00),('1','177','919','257819',4904761,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257819',4904762,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257819',4904763,'2718','408',250437.43,251320.64,0.00,0.00,883.21,671239.60,0.00,0.00,0.00),('1','177','919','257819',4904764,'2719','408',509179.05,509276.63,0.00,0.00,97.58,74160.80,0.00,0.00,0.00),('1','177','919','257820',4904765,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257820',4904766,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257820',4904767,'2718','408',251320.64,252956.80,0.00,0.00,1636.16,1243481.60,0.00,0.00,0.00),('1','177','919','257820',4904768,'2719','408',509276.63,510584.62,0.00,0.00,1307.99,994072.40,0.00,0.00,0.00),('1','177','919','257821',4904769,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257821',4904770,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257821',4904771,'2718','408',252956.80,254296.53,0.00,0.00,1339.73,1071784.00,0.00,0.00,0.00),('1','177','919','257821',4904772,'2719','408',510584.62,511242.65,0.00,0.00,658.03,526424.00,0.00,0.00,0.00),('1','177','919','257822',4904773,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257822',4904774,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257822',4904775,'2718','408',254296.53,254363.79,0.00,0.00,67.26,53808.00,0.00,0.00,0.00),('1','177','919','257822',4904776,'2719','408',511242.65,511413.53,0.00,0.00,170.88,136704.00,0.00,0.00,0.00),('1','177','919','257823',4904777,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257823',4904778,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257823',4904779,'2718','408',254363.79,256054.49,0.00,0.00,1690.70,1352560.00,0.00,0.00,0.00),('1','177','919','257823',4904780,'2719','408',511413.53,512069.19,0.00,0.00,655.66,524528.00,0.00,0.00,0.00),('1','177','919','257824',4904781,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257824',4904782,'2717','408',92203.04,92203.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257824',4904783,'2718','408',256054.49,257252.32,0.00,0.00,1197.83,958264.00,0.00,0.00,0.00),('1','177','919','257824',4904784,'2719','408',512069.19,512910.27,0.00,0.00,841.08,672864.00,0.00,0.00,0.00),('1','177','919','257825',4904785,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257825',4904786,'2717','408',92203.04,92215.54,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','177','919','257825',4904787,'2718','408',257252.32,257701.17,0.00,0.00,448.85,341126.00,0.00,0.00,0.00),('1','177','919','257825',4904788,'2719','408',512910.27,513247.12,0.00,0.00,336.85,256006.00,0.00,0.00,0.00),('1','177','919','257826',4904789,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257826',4904790,'2717','408',92215.54,92215.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257826',4904791,'2718','408',257701.17,258672.67,0.00,0.00,971.50,738340.00,0.00,0.00,0.00),('1','177','919','257826',4904792,'2719','408',513247.12,514003.83,0.00,0.00,756.71,575099.60,0.00,0.00,0.00),('1','177','919','257827',4904793,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257827',4904794,'2717','408',92215.54,92215.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257827',4904795,'2718','408',258672.67,260022.54,0.00,0.00,1349.87,1027641.20,0.00,0.00,0.00),('1','177','919','257827',4904796,'2719','408',514003.83,514560.80,0.00,0.00,556.97,423297.20,0.00,0.00,0.00),('1','177','919','257828',4904797,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257828',4904798,'2717','408',92215.54,92228.04,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','177','919','257828',4904799,'2718','408',260022.54,261226.11,0.00,0.00,1203.57,914713.20,0.00,0.00,0.00),('1','177','919','257828',4904800,'2719','408',514560.80,515078.00,0.00,0.00,517.20,393072.00,0.00,0.00,0.00),('1','177','919','257829',4904801,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257829',4904802,'2717','408',92228.04,92228.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257829',4904803,'2718','408',261226.11,261226.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257829',4904804,'2719','408',515078.00,515078.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257830',4904805,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257830',4904806,'2717','408',92228.04,92229.36,0.00,0.00,1.32,1003.20,0.00,0.00,0.00),('1','177','919','257830',4904807,'2718','408',261226.11,262505.35,0.00,0.00,1279.24,972222.40,0.00,0.00,0.00),('1','177','919','257830',4904808,'2719','408',515078.00,515898.78,0.00,0.00,820.78,623792.80,0.00,0.00,0.00),('1','177','919','257831',4904809,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257831',4904810,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257831',4904811,'2718','408',262505.35,263659.24,0.00,0.00,1153.89,876956.40,0.00,0.00,0.00),('1','177','919','257831',4904812,'2719','408',515898.78,516934.36,0.00,0.00,1035.58,787040.80,0.00,0.00,0.00),('1','177','919','257832',4904813,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257832',4904814,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257832',4904815,'2718','408',263659.24,264100.34,0.00,0.00,441.10,335236.00,0.00,0.00,0.00),('1','177','919','257832',4904816,'2719','408',516934.36,517353.95,0.00,0.00,419.59,318888.40,0.00,0.00,0.00),('1','177','919','257833',4904817,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257833',4904818,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257833',4904819,'2718','408',264100.34,264816.79,0.00,0.00,716.45,544502.00,0.00,0.00,0.00),('1','177','919','257833',4904820,'2719','408',517353.95,517756.06,0.00,0.00,402.11,305603.60,0.00,0.00,0.00),('1','177','919','257834',4904821,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257834',4904822,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257834',4904823,'2718','408',264816.79,265940.37,0.00,0.00,1123.58,853920.80,0.00,0.00,0.00),('1','177','919','257834',4904824,'2719','408',517756.06,518414.05,0.00,0.00,657.99,500072.40,0.00,0.00,0.00),('1','177','919','257835',4904825,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257835',4904826,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257835',4904827,'2718','408',265940.37,267025.24,0.00,0.00,1084.87,824501.20,0.00,0.00,0.00),('1','177','919','257835',4904828,'2719','408',518414.05,519115.23,0.00,0.00,701.18,532896.80,0.00,0.00,0.00),('1','177','919','257836',4904829,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257836',4904830,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257836',4904831,'2718','408',267025.24,267624.78,0.00,0.00,599.54,455650.40,0.00,0.00,0.00),('1','177','919','257836',4904832,'2719','408',519115.23,519208.26,0.00,0.00,93.03,70702.80,0.00,0.00,0.00),('1','177','919','257837',4904833,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257837',4904834,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257837',4904835,'2718','408',267624.78,267624.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257837',4904836,'2719','408',519208.26,519208.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257838',4904837,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257838',4904838,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257838',4904839,'2718','408',267624.78,268333.29,0.00,0.00,708.51,538467.60,0.00,0.00,0.00),('1','177','919','257838',4904840,'2719','408',519208.26,520114.00,0.00,0.00,905.74,688362.40,0.00,0.00,0.00),('1','177','919','257839',4904841,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257839',4904842,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257839',4904843,'2718','408',268333.29,269837.00,0.00,0.00,1503.71,1142819.60,0.00,0.00,0.00),('1','177','919','257839',4904844,'2719','408',520114.00,520660.83,0.00,0.00,546.83,415590.80,0.00,0.00,0.00),('1','177','919','257840',4904845,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257840',4904846,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257840',4904847,'2718','408',269837.00,271107.79,0.00,0.00,1270.79,965800.40,0.00,0.00,0.00),('1','177','919','257840',4904848,'2719','408',520660.83,521145.78,0.00,0.00,484.95,368562.00,0.00,0.00,0.00),('1','177','919','257841',4904849,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257841',4904850,'2717','408',92229.36,92229.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257841',4904851,'2718','408',271107.79,271107.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257841',4904852,'2719','408',521145.78,521145.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257842',4904853,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257842',4904854,'2717','408',92229.36,92236.33,0.00,0.00,6.97,5297.20,0.00,0.00,0.00),('1','177','919','257842',4904855,'2718','408',271107.79,271508.52,0.00,0.00,400.73,304554.80,0.00,0.00,0.00),('1','177','919','257842',4904856,'2719','408',521145.78,521250.21,0.00,0.00,104.43,79366.80,0.00,0.00,0.00),('1','177','919','257843',4904857,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257843',4904858,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257843',4904859,'2718','408',271508.52,272948.19,0.00,0.00,1439.67,1094149.20,0.00,0.00,0.00),('1','177','919','257843',4904860,'2719','408',521250.21,521619.88,0.00,0.00,369.67,280949.20,0.00,0.00,0.00),('1','177','919','257844',4904861,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257844',4904862,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257844',4904863,'2718','408',272948.19,274404.44,0.00,0.00,1456.25,1106750.00,0.00,0.00,0.00),('1','177','919','257844',4904864,'2719','408',521619.88,522364.57,0.00,0.00,744.69,565964.40,0.00,0.00,0.00),('1','177','919','257845',4904865,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257845',4904866,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257845',4904867,'2718','408',274404.44,274857.94,0.00,0.00,453.50,344660.00,0.00,0.00,0.00),('1','177','919','257845',4904868,'2719','408',522364.57,522744.55,0.00,0.00,379.98,288784.80,0.00,0.00,0.00),('1','177','919','257846',4904869,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257846',4904870,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257846',4904871,'2718','408',274857.94,275516.94,0.00,0.00,659.00,500840.00,0.00,0.00,0.00),('1','177','919','257846',4904872,'2719','408',522744.55,523143.28,0.00,0.00,398.73,303034.80,0.00,0.00,0.00),('1','177','919','257847',4904873,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257847',4904874,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257847',4904875,'2718','408',275516.94,276602.90,0.00,0.00,1085.96,825329.60,0.00,0.00,0.00),('1','177','919','257847',4904876,'2719','408',523143.28,523817.33,0.00,0.00,674.05,512278.00,0.00,0.00,0.00),('1','177','919','257848',4904877,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257848',4904878,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257848',4904879,'2718','408',276602.90,277975.70,0.00,0.00,1372.80,1043328.00,0.00,0.00,0.00),('1','177','919','257848',4904880,'2719','408',523817.33,524374.15,0.00,0.00,556.82,423183.20,0.00,0.00,0.00),('1','177','919','257849',4904881,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257849',4904882,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257849',4904883,'2718','408',277975.70,278334.41,0.00,0.00,358.71,272619.60,0.00,0.00,0.00),('1','177','919','257849',4904884,'2719','408',524374.15,524607.43,0.00,0.00,233.28,177292.80,0.00,0.00,0.00),('1','177','919','257850',4904885,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257850',4904886,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257850',4904887,'2718','408',278334.41,278909.86,0.00,0.00,575.45,437342.00,0.00,0.00,0.00),('1','177','919','257850',4904888,'2719','408',524607.43,525165.95,0.00,0.00,558.52,424475.20,0.00,0.00,0.00),('1','177','919','257851',4904889,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257851',4904890,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257851',4904891,'2718','408',278909.86,280046.02,0.00,0.00,1136.16,863481.60,0.00,0.00,0.00),('1','177','919','257851',4904892,'2719','408',525165.95,526219.57,0.00,0.00,1053.62,800751.20,0.00,0.00,0.00),('1','177','919','257852',4904893,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257852',4904894,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257852',4904895,'2718','408',280046.02,281340.03,0.00,0.00,1294.01,983447.60,0.00,0.00,0.00),('1','177','919','257852',4904896,'2719','408',526219.57,526773.41,0.00,0.00,553.84,420918.40,0.00,0.00,0.00),('1','177','919','257853',4904897,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257853',4904898,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257853',4904899,'2718','408',281340.03,282341.07,0.00,0.00,1001.04,760790.40,0.00,0.00,0.00),('1','177','919','257853',4904900,'2719','408',526773.41,527529.71,0.00,0.00,756.30,574788.00,0.00,0.00,0.00),('1','177','919','257854',4904901,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257854',4904902,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257854',4904903,'2718','408',282341.07,283284.57,0.00,0.00,943.50,717060.00,0.00,0.00,0.00),('1','177','919','257854',4904904,'2719','408',527529.71,528378.96,0.00,0.00,849.25,645430.00,0.00,0.00,0.00),('1','177','919','257855',4904905,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257855',4904906,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257855',4904907,'2718','408',283284.57,284268.68,0.00,0.00,984.11,747923.60,0.00,0.00,0.00),('1','177','919','257855',4904908,'2719','408',528378.96,528946.57,0.00,0.00,567.61,431383.60,0.00,0.00,0.00),('1','177','919','257856',4904909,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257856',4904910,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257856',4904911,'2718','408',284268.68,285572.73,0.00,0.00,1304.05,991078.00,0.00,0.00,0.00),('1','177','919','257856',4904912,'2719','408',528946.57,529483.39,0.00,0.00,536.82,407983.20,0.00,0.00,0.00),('1','177','919','257857',4904913,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257857',4904914,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257857',4904915,'2718','408',285572.73,286643.73,0.00,0.00,1071.00,813960.00,0.00,0.00,0.00),('1','177','919','257857',4904916,'2719','408',529483.39,530238.97,0.00,0.00,755.58,574240.80,0.00,0.00,0.00),('1','177','919','257858',4904917,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257858',4904918,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257858',4904919,'2718','408',286643.73,287776.17,0.00,0.00,1132.44,860654.40,0.00,0.00,0.00),('1','177','919','257858',4904920,'2719','408',530238.97,530727.51,0.00,0.00,488.54,371290.40,0.00,0.00,0.00),('1','177','919','257859',4904921,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257859',4904922,'2717','408',92236.33,92236.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257859',4904923,'2718','408',287776.17,288390.23,0.00,0.00,614.06,466685.60,0.00,0.00,0.00),('1','177','919','257859',4904924,'2719','408',530727.51,530815.51,0.00,0.00,88.00,66880.00,0.00,0.00,0.00),('1','177','919','257860',4904925,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257860',4904926,'2717','408',92236.33,92253.56,0.00,0.00,17.23,13094.80,0.00,0.00,0.00),('1','177','919','257860',4904927,'2718','408',288390.23,289827.11,0.00,0.00,1436.88,1092028.80,0.00,0.00,0.00),('1','177','919','257860',4904928,'2719','408',530815.51,531315.33,0.00,0.00,499.82,379863.20,0.00,0.00,0.00),('1','177','919','257861',4904929,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257861',4904930,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257861',4904931,'2718','408',289827.11,291893.32,0.00,0.00,2066.21,1570319.60,0.00,0.00,0.00),('1','177','919','257861',4904932,'2719','408',531315.33,531566.20,0.00,0.00,250.87,190661.20,0.00,0.00,0.00),('1','177','919','257862',4904933,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257862',4904934,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257862',4904935,'2718','408',291893.32,292021.96,0.00,0.00,128.64,97766.40,0.00,0.00,0.00),('1','177','919','257862',4904936,'2719','408',531566.20,531727.64,0.00,0.00,161.44,122694.40,0.00,0.00,0.00),('1','177','919','257863',4904937,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257863',4904938,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257863',4904939,'2718','408',292021.96,293367.79,0.00,0.00,1345.83,1022830.80,0.00,0.00,0.00),('1','177','919','257863',4904940,'2719','408',531727.64,532265.35,0.00,0.00,537.71,408659.60,0.00,0.00,0.00),('1','177','919','257864',4904941,'2716','408',35586.66,35586.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257864',4904942,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257864',4904943,'2718','408',293367.79,295326.95,0.00,0.00,1959.16,1488961.60,0.00,0.00,0.00),('1','177','919','257864',4904944,'2719','408',532265.35,532572.28,0.00,0.00,306.93,233266.80,0.00,0.00,0.00),('1','177','919','257865',4904945,'2716','408',35586.66,35599.16,0.00,0.00,12.50,9500.00,0.00,0.00,0.00),('1','177','919','257865',4904946,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257865',4904947,'2718','408',295326.95,296125.28,0.00,0.00,798.33,606730.80,0.00,0.00,0.00),('1','177','919','257865',4904948,'2719','408',532572.28,532675.33,0.00,0.00,103.05,78318.00,0.00,0.00,0.00),('1','177','919','257866',4904949,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257866',4904950,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257866',4904951,'2718','408',296125.28,297169.82,0.00,0.00,1044.54,793850.40,0.00,0.00,0.00),('1','177','919','257866',4904952,'2719','408',532675.33,532993.96,0.00,0.00,318.63,242158.80,0.00,0.00,0.00),('1','177','919','257867',4904953,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257867',4904954,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257867',4904955,'2718','408',297169.82,299063.07,0.00,0.00,1893.25,1438870.00,0.00,0.00,0.00),('1','177','919','257867',4904956,'2719','408',532993.96,533342.00,0.00,0.00,348.04,264510.40,0.00,0.00,0.00),('1','177','919','257868',4904957,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257868',4904958,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257868',4904959,'2718','408',299063.07,300263.94,0.00,0.00,1200.87,912661.20,0.00,0.00,0.00),('1','177','919','257868',4904960,'2719','408',533342.00,533651.67,0.00,0.00,309.67,235349.20,0.00,0.00,0.00),('1','177','919','257869',4904961,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257869',4904962,'2717','408',92253.56,92253.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257869',4904963,'2718','408',300263.94,301073.38,0.00,0.00,809.44,615174.40,0.00,0.00,0.00),('1','177','919','257869',4904964,'2719','408',533651.67,533844.24,0.00,0.00,192.57,146353.20,0.00,0.00,0.00),('1','177','919','257870',4904965,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257870',4904966,'2717','408',92253.56,92256.85,0.00,0.00,3.29,2500.40,0.00,0.00,0.00),('1','177','919','257870',4904967,'2718','408',301073.38,303069.24,0.00,0.00,1995.86,1516853.60,0.00,0.00,0.00),('1','177','919','257870',4904968,'2719','408',533844.24,534096.03,0.00,0.00,251.79,191360.40,0.00,0.00,0.00),('1','177','919','257871',4904969,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257871',4904970,'2717','408',92256.85,92259.48,0.00,0.00,2.63,1998.80,0.00,0.00,0.00),('1','177','919','257871',4904971,'2718','408',303069.24,304327.35,0.00,0.00,1258.11,956163.60,0.00,0.00,0.00),('1','177','919','257871',4904972,'2719','408',534096.03,534553.34,0.00,0.00,457.31,347555.60,0.00,0.00,0.00),('1','177','919','257872',4904973,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257872',4904974,'2717','408',92259.48,92259.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257872',4904975,'2718','408',304327.35,304561.72,0.00,0.00,234.37,178121.20,0.00,0.00,0.00),('1','177','919','257872',4904976,'2719','408',534553.34,534661.84,0.00,0.00,108.50,82460.00,0.00,0.00,0.00),('1','177','919','257873',4904977,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257873',4904978,'2717','408',92259.48,92271.48,0.00,0.00,12.00,9120.00,0.00,0.00,0.00),('1','177','919','257873',4904979,'2718','408',304561.72,305884.21,0.00,0.00,1322.49,1005092.40,0.00,0.00,0.00),('1','177','919','257873',4904980,'2719','408',534661.84,535302.88,0.00,0.00,641.04,487190.40,0.00,0.00,0.00),('1','177','919','257874',4904981,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257874',4904982,'2717','408',92271.48,92271.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257874',4904983,'2718','408',305884.21,307199.54,0.00,0.00,1315.33,999650.80,0.00,0.00,0.00),('1','177','919','257874',4904984,'2719','408',535302.88,535842.28,0.00,0.00,539.40,409944.00,0.00,0.00,0.00),('1','177','919','257875',4904985,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257875',4904986,'2717','408',92271.48,92271.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257875',4904987,'2718','408',307199.54,308079.14,0.00,0.00,879.60,668496.00,0.00,0.00,0.00),('1','177','919','257875',4904988,'2719','408',535842.28,536164.85,0.00,0.00,322.57,245153.20,0.00,0.00,0.00),('1','177','919','257876',4904989,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257876',4904990,'2717','408',92271.48,92271.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257876',4904991,'2718','408',308079.14,308246.16,0.00,0.00,167.02,126935.20,0.00,0.00,0.00),('1','177','919','257876',4904992,'2719','408',536164.85,536224.52,0.00,0.00,59.67,45349.20,0.00,0.00,0.00),('1','177','919','257877',4904993,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257877',4904994,'2717','408',92271.48,92271.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257877',4904995,'2718','408',308246.16,308464.28,0.00,0.00,218.12,165771.20,0.00,0.00,0.00),('1','177','919','257877',4904996,'2719','408',536224.52,538583.46,0.00,0.00,2358.94,1792794.40,0.00,0.00,0.00),('1','177','919','257878',4904997,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257878',4904998,'2717','408',92271.48,92271.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257878',4904999,'2718','408',308464.28,308603.31,0.00,0.00,139.03,105358.72,0.00,0.00,0.00),('1','177','919','257878',4905000,'2719','408',538583.46,538723.99,0.00,0.00,140.53,106802.80,0.00,0.00,0.00),('1','177','919','257879',4905001,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257879',4905002,'2717','408',92271.48,92277.48,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','177','919','257879',4905003,'2718','408',308603.31,309609.44,0.00,0.00,1006.13,740511.68,0.00,0.00,0.00),('1','177','919','257879',4905004,'2719','408',538723.99,539162.02,0.00,0.00,438.03,322390.08,0.00,0.00,0.00),('1','177','919','257880',4905005,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257880',4905006,'2717','408',92277.48,92277.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257880',4905007,'2718','408',309609.44,309935.04,0.00,0.00,325.60,239641.60,0.00,0.00,0.00),('1','177','919','257880',4905008,'2719','408',539162.02,539433.90,0.00,0.00,271.88,200103.68,0.00,0.00,0.00),('1','177','919','257881',4905009,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257881',4905010,'2717','408',92277.48,92277.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257881',4905011,'2718','408',309935.04,310743.01,0.00,0.00,807.97,594665.92,0.00,0.00,0.00),('1','177','919','257881',4905012,'2719','408',539433.90,540287.67,0.00,0.00,853.77,628374.72,0.00,0.00,0.00),('1','177','919','257882',4905013,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257882',4905014,'2717','408',92277.48,92277.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257882',4905015,'2718','408',310743.01,311863.25,0.00,0.00,1120.24,824496.64,0.00,0.00,0.00),('1','177','919','257882',4905016,'2719','408',540287.67,541167.12,0.00,0.00,879.45,647275.20,0.00,0.00,0.00),('1','177','919','257883',4905017,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257883',4905018,'2717','408',92277.48,92288.35,0.00,0.00,10.87,8000.32,0.00,0.00,0.00),('1','177','919','257883',4905019,'2718','408',311863.25,312772.23,0.00,0.00,908.98,669009.28,0.00,0.00,0.00),('1','177','919','257883',4905020,'2719','408',541167.12,541615.99,0.00,0.00,448.87,330368.32,0.00,0.00,0.00),('1','177','919','257884',4905021,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257884',4905022,'2717','408',92288.35,92288.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257884',4905023,'2718','408',312772.23,313226.39,0.00,0.00,454.16,334261.76,0.00,0.00,0.00),('1','177','919','257884',4905024,'2719','408',541615.99,541735.32,0.00,0.00,119.33,87826.88,0.00,0.00,0.00),('1','177','919','257885',4905025,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257885',4905026,'2717','408',92288.35,92288.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257885',4905027,'2718','408',313226.39,314828.78,0.00,0.00,1602.39,1179359.04,0.00,0.00,0.00),('1','177','919','257885',4905028,'2719','408',541735.32,541873.53,0.00,0.00,138.21,101722.56,0.00,0.00,0.00),('1','177','919','257886',4905029,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257886',4905030,'2717','408',92288.35,92288.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257886',4905031,'2718','408',314828.78,316092.04,0.00,0.00,1263.26,929759.36,0.00,0.00,0.00),('1','177','919','257886',4905032,'2719','408',541873.53,542812.52,0.00,0.00,938.99,691096.64,0.00,0.00,0.00),('1','177','919','257887',4905033,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257887',4905034,'2717','408',92288.35,92288.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257887',4905035,'2718','408',316092.04,316519.47,0.00,0.00,427.43,314588.48,0.00,0.00,0.00),('1','177','919','257887',4905036,'2719','408',542812.52,543190.35,0.00,0.00,377.83,278082.88,0.00,0.00,0.00),('1','177','919','257888',4905037,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257888',4905038,'2717','408',92288.35,92288.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257888',4905039,'2718','408',316519.47,317050.83,0.00,0.00,531.36,391080.96,0.00,0.00,0.00),('1','177','919','257888',4905040,'2719','408',543190.35,543743.59,0.00,0.00,553.24,407184.64,0.00,0.00,0.00),('1','177','919','257889',4905041,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257889',4905042,'2717','408',92288.35,92294.35,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','177','919','257889',4905043,'2718','408',317050.83,318798.39,0.00,0.00,1747.56,1286204.16,0.00,0.00,0.00),('1','177','919','257889',4905044,'2719','408',543743.59,544272.95,0.00,0.00,529.36,389608.96,0.00,0.00,0.00),('1','177','919','257890',4905045,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257890',4905046,'2717','408',92294.35,92294.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257890',4905047,'2718','408',318798.39,320053.97,0.00,0.00,1255.58,924106.88,0.00,0.00,0.00),('1','177','919','257890',4905048,'2719','408',544272.95,545355.25,0.00,0.00,1082.30,796572.80,0.00,0.00,0.00),('1','177','919','257891',4905049,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257891',4905050,'2717','408',92294.35,92294.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257891',4905051,'2718','408',320053.97,321478.47,0.00,0.00,1424.50,1048432.00,0.00,0.00,0.00),('1','177','919','257891',4905052,'2719','408',545355.25,546458.46,0.00,0.00,1103.21,811962.56,0.00,0.00,0.00),('1','177','919','257892',4905053,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257892',4905054,'2717','408',92294.35,92295.44,0.00,0.00,1.09,802.24,0.00,0.00,0.00),('1','177','919','257892',4905055,'2718','408',321478.47,322767.19,0.00,0.00,1288.72,948497.92,0.00,0.00,0.00),('1','177','919','257892',4905056,'2719','408',546458.46,547054.02,0.00,0.00,595.56,438332.16,0.00,0.00,0.00),('1','177','919','257893',4905057,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257893',4905058,'2717','408',92295.44,92295.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257893',4905059,'2718','408',322767.19,323456.51,0.00,0.00,689.32,507339.52,0.00,0.00,0.00),('1','177','919','257893',4905060,'2719','408',547054.02,547201.42,0.00,0.00,147.40,108486.40,0.00,0.00,0.00),('1','177','919','257894',4905061,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257894',4905062,'2717','408',92295.44,92295.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257894',4905063,'2718','408',323456.51,324399.98,0.00,0.00,943.47,694393.92,0.00,0.00,0.00),('1','177','919','257894',4905064,'2719','408',547201.42,547551.75,0.00,0.00,350.33,257842.88,0.00,0.00,0.00),('1','177','919','257895',4905065,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257895',4905066,'2717','408',92295.44,92307.94,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','177','919','257895',4905067,'2718','408',324399.98,325924.07,0.00,0.00,1524.09,1121730.24,0.00,0.00,0.00),('1','177','919','257895',4905068,'2719','408',547551.75,548767.99,0.00,0.00,1216.24,895166.64,0.00,0.00,0.00),('1','177','919','257896',4905069,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257896',4905070,'2717','408',92307.94,92307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257896',4905071,'2718','408',325924.07,326717.77,0.00,0.00,793.70,584163.20,0.00,0.00,0.00),('1','177','919','257896',4905072,'2719','408',548767.99,549170.66,0.00,0.00,402.67,296365.12,0.00,0.00,0.00),('1','177','919','257897',4905073,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257897',4905074,'2717','408',92307.94,92307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257897',4905075,'2718','408',326717.77,327363.95,0.00,0.00,646.18,475588.48,0.00,0.00,0.00),('1','177','919','257897',4905076,'2719','408',549170.66,549530.01,0.00,0.00,359.35,264481.60,0.00,0.00,0.00),('1','177','919','257898',4905077,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257898',4905078,'2717','408',92307.94,92307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257898',4905079,'2718','408',327363.95,328528.22,0.00,0.00,1164.27,856902.72,0.00,0.00,0.00),('1','177','919','257898',4905080,'2719','408',549530.01,550836.32,0.00,0.00,1306.31,961444.16,0.00,0.00,0.00),('1','177','919','257899',4905081,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257899',4905082,'2717','408',92307.94,92307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257899',4905083,'2718','408',328528.22,328794.56,0.00,0.00,266.34,196026.24,0.00,0.00,0.00),('1','177','919','257899',4905084,'2719','408',550836.32,550885.07,0.00,0.00,48.75,35880.00,0.00,0.00,0.00),('1','177','919','257900',4905085,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257900',4905086,'2717','408',92307.94,92307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257900',4905087,'2718','408',328794.56,329967.96,0.00,0.00,1173.40,863622.40,0.00,0.00,0.00),('1','177','919','257900',4905088,'2719','408',550885.07,551840.29,0.00,0.00,955.22,703041.92,0.00,0.00,0.00),('1','177','919','257901',4905089,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257901',4905090,'2717','408',92307.94,92307.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257901',4905091,'2718','408',329967.96,331101.32,0.00,0.00,1133.36,834152.96,0.00,0.00,0.00),('1','177','919','257901',4905092,'2719','408',551840.29,552889.41,0.00,0.00,1049.12,772152.32,0.00,0.00,0.00),('1','177','919','257902',4905093,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257902',4905094,'2717','408',92307.94,92320.44,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','177','919','257902',4905095,'2718','408',331101.32,331647.91,0.00,0.00,546.59,402290.24,0.00,0.00,0.00),('1','177','919','257902',4905096,'2719','408',552889.41,553281.87,0.00,0.00,392.46,288850.56,0.00,0.00,0.00),('1','177','919','257903',4905097,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257903',4905098,'2717','408',92320.44,92320.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257903',4905099,'2718','408',331647.91,332332.64,0.00,0.00,684.73,503961.28,0.00,0.00,0.00),('1','177','919','257903',4905100,'2719','408',553281.87,553415.20,0.00,0.00,133.33,98130.88,0.00,0.00,0.00),('1','177','919','257904',4905101,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257904',4905102,'2717','408',92320.44,92320.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257904',4905103,'2718','408',332332.64,333312.83,0.00,0.00,980.19,721419.84,0.00,0.00,0.00),('1','177','919','257904',4905104,'2719','408',553415.20,554314.30,0.00,0.00,899.10,661737.60,0.00,0.00,0.00),('1','177','919','257905',4905105,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257905',4905106,'2717','408',92320.44,92320.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257905',4905107,'2718','408',333312.83,334390.55,0.00,0.00,1077.72,793201.92,0.00,0.00,0.00),('1','177','919','257905',4905108,'2719','408',554314.30,554991.40,0.00,0.00,677.10,498345.60,0.00,0.00,0.00),('1','177','919','257906',4905109,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257906',4905110,'2717','408',92320.44,92320.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257906',4905111,'2718','408',334390.55,335185.80,0.00,0.00,795.25,585304.00,0.00,0.00,0.00),('1','177','919','257906',4905112,'2719','408',554991.40,555101.43,0.00,0.00,110.03,80982.08,0.00,0.00,0.00),('1','177','919','257907',4905113,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257907',4905114,'2717','408',92320.44,92320.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257907',4905115,'2718','408',335185.80,335496.98,0.00,0.00,311.18,229028.48,0.00,0.00,0.00),('1','177','919','257907',4905116,'2719','408',555101.43,555524.33,0.00,0.00,422.90,311254.40,0.00,0.00,0.00),('1','177','919','257908',4905117,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257908',4905118,'2717','408',92320.44,92332.94,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','177','919','257908',4905119,'2718','408',335496.98,336553.40,0.00,0.00,1056.42,777525.12,0.00,0.00,0.00),('1','177','919','257908',4905120,'2719','408',555524.33,556047.89,0.00,0.00,523.56,385340.16,0.00,0.00,0.00),('1','177','919','257909',4905121,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257909',4905122,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257909',4905123,'2718','408',336553.40,337880.50,0.00,0.00,1327.10,976745.60,0.00,0.00,0.00),('1','177','919','257909',4905124,'2719','408',556047.89,556614.96,0.00,0.00,567.07,417363.52,0.00,0.00,0.00),('1','177','919','257910',4905125,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257910',4905126,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257910',4905127,'2718','408',337880.50,338583.95,0.00,0.00,703.45,517739.20,0.00,0.00,0.00),('1','177','919','257910',4905128,'2719','408',556614.96,556950.78,0.00,0.00,335.82,247163.52,0.00,0.00,0.00),('1','177','919','257911',4905129,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257911',4905130,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257911',4905131,'2718','408',338583.95,338753.79,0.00,0.00,169.84,125002.24,0.00,0.00,0.00),('1','177','919','257911',4905132,'2719','408',556950.78,557111.43,0.00,0.00,160.65,118238.40,0.00,0.00,0.00),('1','177','919','257912',4905133,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257912',4905134,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257912',4905135,'2718','408',338753.79,340004.57,0.00,0.00,1250.78,920574.08,0.00,0.00,0.00),('1','177','919','257912',4905136,'2719','408',557111.43,557699.84,0.00,0.00,588.41,433069.76,0.00,0.00,0.00),('1','177','919','257913',4905137,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257913',4905138,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257913',4905139,'2718','408',340004.57,341344.59,0.00,0.00,1340.02,986254.72,0.00,0.00,0.00),('1','177','919','257913',4905140,'2719','408',557699.84,558503.66,0.00,0.00,803.82,591611.52,0.00,0.00,0.00),('1','177','919','257914',4905141,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257914',4905142,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257914',4905143,'2718','408',341344.59,342038.20,0.00,0.00,693.61,510496.96,0.00,0.00,0.00),('1','177','919','257914',4905144,'2719','408',558503.66,558631.73,0.00,0.00,128.07,94259.52,0.00,0.00,0.00),('1','177','919','257915',4905145,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257915',4905146,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257915',4905147,'2718','408',342038.20,342718.07,0.00,0.00,679.87,500384.32,0.00,0.00,0.00),('1','177','919','257915',4905148,'2719','408',558631.73,558780.75,0.00,0.00,149.02,109678.72,0.00,0.00,0.00),('1','177','919','257916',4905149,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257916',4905150,'2717','408',92332.94,92332.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257916',4905151,'2718','408',342718.07,343984.98,0.00,0.00,1266.91,932445.76,0.00,0.00,0.00),('1','177','919','257916',4905152,'2719','408',558780.75,559684.99,0.00,0.00,904.24,665520.64,0.00,0.00,0.00),('1','177','919','257917',4905153,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257917',4905154,'2717','408',92332.94,92338.94,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','177','919','257917',4905155,'2718','408',343984.98,345284.55,0.00,0.00,1299.57,956483.52,0.00,0.00,0.00),('1','177','919','257917',4905156,'2719','408',559684.99,560165.13,0.00,0.00,480.14,353383.04,0.00,0.00,0.00),('1','177','919','257918',4905157,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257918',4905158,'2717','408',92338.94,92344.37,0.00,0.00,5.43,3996.48,0.00,0.00,0.00),('1','177','919','257918',4905159,'2718','408',345284.55,345474.88,0.00,0.00,190.33,140082.88,0.00,0.00,0.00),('1','177','919','257918',4905160,'2719','408',560165.13,560297.15,0.00,0.00,132.02,97166.72,0.00,0.00,0.00),('1','177','919','257919',4905161,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257919',4905162,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257919',4905163,'2718','408',345474.88,346378.99,0.00,0.00,904.11,665424.96,0.00,0.00,0.00),('1','177','919','257919',4905164,'2719','408',560297.15,560821.98,0.00,0.00,524.83,386274.88,0.00,0.00,0.00),('1','177','919','257920',4905165,'2716','408',35599.16,35599.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257920',4905166,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257920',4905167,'2718','408',346378.99,347822.93,0.00,0.00,1443.94,1062739.84,0.00,0.00,0.00),('1','177','919','257920',4905168,'2719','408',560821.98,561180.31,0.00,0.00,358.33,263730.88,0.00,0.00,0.00),('1','177','919','257921',4905169,'2716','408',35599.16,35605.16,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','177','919','257921',4905170,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257921',4905171,'2718','408',347822.93,348908.99,0.00,0.00,1086.06,799340.16,0.00,0.00,0.00),('1','177','919','257921',4905172,'2719','408',561180.31,561988.34,0.00,0.00,808.03,594710.08,0.00,0.00,0.00),('1','177','919','257922',4905173,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257922',4905174,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257922',4905175,'2718','408',348908.99,349386.43,0.00,0.00,477.44,351395.84,0.00,0.00,0.00),('1','177','919','257922',4905176,'2719','408',561988.34,562400.89,0.00,0.00,412.55,304900.80,0.00,0.00,0.00),('1','177','919','257923',4905177,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257923',4905178,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257923',4905179,'2718','408',349386.43,349386.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257923',4905180,'2719','408',562400.89,562400.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257924',4905181,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257924',4905182,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257924',4905183,'2718','408',349386.43,349730.05,0.00,0.00,343.62,252904.32,0.00,0.00,0.00),('1','177','919','257924',4905184,'2719','408',562400.89,562918.51,0.00,0.00,517.62,380968.32,0.00,0.00,0.00),('1','177','919','257925',4905185,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257925',4905186,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257925',4905187,'2718','408',349730.05,350221.60,0.00,0.00,491.55,361780.80,0.00,0.00,0.00),('1','177','919','257925',4905188,'2719','408',562918.51,564022.98,0.00,0.00,1104.47,812889.92,0.00,0.00,0.00),('1','177','919','257926',4905189,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257926',4905190,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257926',4905191,'2718','408',350221.60,350941.12,0.00,0.00,719.52,529566.72,0.00,0.00,0.00),('1','177','919','257926',4905192,'2719','408',564022.98,565028.73,0.00,0.00,1005.75,740232.00,0.00,0.00,0.00),('1','177','919','257927',4905193,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257927',4905194,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257927',4905195,'2718','408',350941.12,351725.94,0.00,0.00,784.82,577627.52,0.00,0.00,0.00),('1','177','919','257927',4905196,'2719','408',565028.73,565539.73,0.00,0.00,511.00,376096.00,0.00,0.00,0.00),('1','177','919','257928',4905197,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257928',4905198,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257928',4905199,'2718','408',351725.94,351725.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257928',4905200,'2719','408',565539.73,565539.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257929',4905201,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257929',4905202,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257929',4905203,'2718','408',351725.94,351796.89,0.00,0.00,70.95,52219.20,0.00,0.00,0.00),('1','177','919','257929',4905204,'2719','408',565539.73,565840.52,0.00,0.00,300.79,221381.44,0.00,0.00,0.00),('1','177','919','257930',4905205,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257930',4905206,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257930',4905207,'2718','408',351796.89,353304.64,0.00,0.00,1507.75,1110468.00,0.00,0.00,0.00),('1','177','919','257930',4905208,'2719','408',565840.52,566371.11,0.00,0.00,530.59,390514.24,0.00,0.00,0.00),('1','177','919','257931',4905209,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257931',4905210,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257931',4905211,'2718','408',353304.64,354950.56,0.00,0.00,1645.92,1211397.12,0.00,0.00,0.00),('1','177','919','257931',4905212,'2719','408',566371.11,566928.65,0.00,0.00,557.54,410349.44,0.00,0.00,0.00),('1','177','919','257932',4905213,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257932',4905214,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257932',4905215,'2718','408',354950.56,355310.68,0.00,0.00,360.12,265048.32,0.00,0.00,0.00),('1','177','919','257932',4905216,'2719','408',566928.65,567030.59,0.00,0.00,101.94,75027.84,0.00,0.00,0.00),('1','177','919','257933',4905217,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257933',4905218,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257933',4905219,'2718','408',355310.68,356730.55,0.00,0.00,1419.87,1045024.32,0.00,0.00,0.00),('1','177','919','257933',4905220,'2719','408',567030.59,567512.00,0.00,0.00,481.41,354317.76,0.00,0.00,0.00),('1','177','919','257934',4905221,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257934',4905222,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257934',4905223,'2718','408',356730.55,358960.25,0.00,0.00,2229.70,1641059.20,0.00,0.00,0.00),('1','177','919','257934',4905224,'2719','408',567512.00,567690.91,0.00,0.00,178.91,131677.76,0.00,0.00,0.00),('1','177','919','257935',4905225,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257935',4905226,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257935',4905227,'2718','408',358960.25,359714.96,0.00,0.00,754.71,555466.56,0.00,0.00,0.00),('1','177','919','257935',4905228,'2719','408',567690.91,567826.15,0.00,0.00,135.24,99536.64,0.00,0.00,0.00),('1','177','919','257936',4905229,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257936',4905230,'2717','408',92344.37,92344.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257936',4905231,'2718','408',359714.96,361000.58,0.00,0.00,1285.62,946216.32,0.00,0.00,0.00),('1','177','919','257936',4905232,'2719','408',567826.15,568038.17,0.00,0.00,212.02,156046.72,0.00,0.00,0.00),('1','177','919','257937',4905233,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257937',4905234,'2717','408',92344.37,92354.56,0.00,0.00,10.19,7499.84,0.00,0.00,0.00),('1','177','919','257937',4905235,'2718','408',361000.58,362618.79,0.00,0.00,1618.21,1191002.56,0.00,0.00,0.00),('1','177','919','257937',4905236,'2719','408',568038.17,568170.87,0.00,0.00,132.70,97667.20,0.00,0.00,0.00),('1','177','919','257938',4905237,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257938',4905238,'2717','408',92354.56,92357.28,0.00,0.00,2.72,2001.92,0.00,0.00,0.00),('1','177','919','257938',4905239,'2718','408',362618.79,364002.85,0.00,0.00,1384.06,1018668.16,0.00,0.00,0.00),('1','177','919','257938',4905240,'2719','408',568170.87,568685.91,0.00,0.00,515.04,380633.44,0.00,0.00,0.00),('1','177','919','257939',4905241,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257939',4905242,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257939',4905243,'2718','408',364002.85,364414.63,0.00,0.00,411.78,303070.08,0.00,0.00,0.00),('1','177','919','257939',4905244,'2719','408',568685.91,568802.52,0.00,0.00,116.61,85824.96,0.00,0.00,0.00),('1','177','919','257940',4905245,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257940',4905246,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257940',4905247,'2718','408',364414.63,364414.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257940',4905248,'2719','408',568802.52,568802.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257941',4905249,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257941',4905250,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257941',4905251,'2718','408',364414.63,364811.26,0.00,0.00,396.63,291919.68,0.00,0.00,0.00),('1','177','919','257941',4905252,'2719','408',568802.52,570132.93,0.00,0.00,1330.41,979181.76,0.00,0.00,0.00),('1','177','919','257942',4905253,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257942',4905254,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257942',4905255,'2718','408',364811.26,366526.53,0.00,0.00,1715.27,1262438.72,0.00,0.00,0.00),('1','177','919','257942',4905256,'2719','408',570132.93,570410.54,0.00,0.00,277.61,204320.96,0.00,0.00,0.00),('1','177','919','257943',4905257,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257943',4905258,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257943',4905259,'2718','408',366526.53,368175.59,0.00,0.00,1649.06,1213708.16,0.00,0.00,0.00),('1','177','919','257943',4905260,'2719','408',570410.54,570428.89,0.00,0.00,18.35,13505.60,0.00,0.00,0.00),('1','177','919','257944',4905261,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257944',4905262,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257944',4905263,'2718','408',368175.59,368175.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257944',4905264,'2719','408',570428.89,570428.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257945',4905265,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257945',4905266,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257945',4905267,'2718','408',368175.59,368464.33,0.00,0.00,288.74,212512.64,0.00,0.00,0.00),('1','177','919','257945',4905268,'2719','408',570428.89,570428.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257946',4905269,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257946',4905270,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257946',4905271,'2718','408',368464.33,370236.65,0.00,0.00,1772.32,1304427.52,0.00,0.00,0.00),('1','177','919','257946',4905272,'2719','408',570428.89,570591.06,0.00,0.00,162.17,119357.12,0.00,0.00,0.00),('1','177','919','257947',4905273,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257947',4905274,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257947',4905275,'2718','408',370236.65,372029.10,0.00,0.00,1792.45,1319243.20,0.00,0.00,0.00),('1','177','919','257947',4905276,'2719','408',570591.06,570834.68,0.00,0.00,243.62,179304.32,0.00,0.00,0.00),('1','177','919','257948',4905277,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257948',4905278,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257948',4905279,'2718','408',372029.10,372911.81,0.00,0.00,882.71,651138.56,0.00,0.00,0.00),('1','177','919','257948',4905280,'2719','408',570834.68,571051.42,0.00,0.00,216.74,159520.64,0.00,0.00,0.00),('1','177','919','257949',4905281,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257949',4905282,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257949',4905283,'2718','408',372911.81,373675.18,0.00,0.00,763.37,561840.32,0.00,0.00,0.00),('1','177','919','257949',4905284,'2719','408',571051.42,571246.45,0.00,0.00,195.03,143542.08,0.00,0.00,0.00),('1','177','919','257950',4905285,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257950',4905286,'2717','408',92357.28,92357.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257950',4905287,'2718','408',373675.18,375400.49,0.00,0.00,1725.31,1269828.16,0.00,0.00,0.00),('1','177','919','257950',4905288,'2719','408',571246.45,571462.67,0.00,0.00,216.22,159137.92,0.00,0.00,0.00),('1','177','919','257951',4905289,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257951',4905290,'2717','408',92357.28,92363.39,0.00,0.00,6.11,4496.96,0.00,0.00,0.00),('1','177','919','257951',4905291,'2718','408',375400.49,376697.79,0.00,0.00,1297.30,954812.80,0.00,0.00,0.00),('1','177','919','257951',4905292,'2719','408',571462.67,572234.30,0.00,0.00,771.63,567919.68,0.00,0.00,0.00),('1','177','919','257952',4905293,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257952',4905294,'2717','408',92363.39,92363.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257952',4905295,'2718','408',376697.79,376964.83,0.00,0.00,267.04,196541.44,0.00,0.00,0.00),('1','177','919','257952',4905296,'2719','408',572234.30,572234.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257953',4905297,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257953',4905298,'2717','408',92363.39,92375.89,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','177','919','257953',4905299,'2718','408',376964.83,378274.27,0.00,0.00,1309.44,963747.84,0.00,0.00,0.00),('1','177','919','257953',4905300,'2719','408',572234.30,572428.83,0.00,0.00,194.53,143174.08,0.00,0.00,0.00),('1','177','919','257954',4905301,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257954',4905302,'2717','408',92375.89,92375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257954',4905303,'2718','408',378274.27,379703.29,0.00,0.00,1429.02,1051758.72,0.00,0.00,0.00),('1','177','919','257954',4905304,'2719','408',572428.83,572891.43,0.00,0.00,462.60,340473.60,0.00,0.00,0.00),('1','177','919','257955',4905305,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257955',4905306,'2717','408',92375.89,92375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257955',4905307,'2718','408',379703.29,381247.86,0.00,0.00,1544.57,1136803.52,0.00,0.00,0.00),('1','177','919','257955',4905308,'2719','408',572891.43,572959.92,0.00,0.00,68.49,50408.64,0.00,0.00,0.00),('1','177','919','257956',4905309,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257956',4905310,'2717','408',92375.89,92375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257956',4905311,'2718','408',381247.86,383140.95,0.00,0.00,1893.09,1393314.24,0.00,0.00,0.00),('1','177','919','257956',4905312,'2719','408',572959.92,573244.56,0.00,0.00,284.64,209495.04,0.00,0.00,0.00),('1','177','919','257957',4905313,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257957',4905314,'2717','408',92375.89,92375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257957',4905315,'2718','408',383140.95,384868.66,0.00,0.00,1727.71,1271594.56,0.00,0.00,0.00),('1','177','919','257957',4905316,'2719','408',573244.56,573432.82,0.00,0.00,188.26,138559.36,0.00,0.00,0.00),('1','177','919','257958',4905317,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257958',4905318,'2717','408',92375.89,92375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257958',4905319,'2718','408',384868.66,385998.43,0.00,0.00,1129.77,831510.72,0.00,0.00,0.00),('1','177','919','257958',4905320,'2719','408',573432.82,573588.69,0.00,0.00,155.87,114720.32,0.00,0.00,0.00),('1','177','919','257959',4905321,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257959',4905322,'2717','408',92375.89,92375.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257959',4905323,'2718','408',385998.43,386450.74,0.00,0.00,452.31,332900.16,0.00,0.00,0.00),('1','177','919','257959',4905324,'2719','408',573588.69,573821.82,0.00,0.00,233.13,171583.68,0.00,0.00,0.00),('1','177','919','257960',4905325,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257960',4905326,'2717','408',92375.89,92413.39,0.00,0.00,37.50,27600.00,0.00,0.00,0.00),('1','177','919','257960',4905327,'2718','408',386450.74,387663.83,0.00,0.00,1213.09,892834.24,0.00,0.00,0.00),('1','177','919','257960',4905328,'2719','408',573821.82,574334.90,0.00,0.00,513.08,377626.88,0.00,0.00,0.00),('1','177','919','257961',4905329,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257961',4905330,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257961',4905331,'2718','408',387663.83,389341.39,0.00,0.00,1677.56,1234684.16,0.00,0.00,0.00),('1','177','919','257961',4905332,'2719','408',574334.90,575487.20,0.00,0.00,1152.30,848092.80,0.00,0.00,0.00),('1','177','919','257962',4905333,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257962',4905334,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257962',4905335,'2718','408',389341.39,390821.43,0.00,0.00,1480.04,1089309.44,0.00,0.00,0.00),('1','177','919','257962',4905336,'2719','408',575487.20,576258.07,0.00,0.00,770.87,567360.32,0.00,0.00,0.00),('1','177','919','257963',4905337,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257963',4905338,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257963',4905339,'2718','408',390821.43,392534.03,0.00,0.00,1712.60,1260473.60,0.00,0.00,0.00),('1','177','919','257963',4905340,'2719','408',576258.07,576689.53,0.00,0.00,431.46,317554.56,0.00,0.00,0.00),('1','177','919','257964',4905341,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257964',4905342,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257964',4905343,'2718','408',392534.03,393082.23,0.00,0.00,548.20,403475.20,0.00,0.00,0.00),('1','177','919','257964',4905344,'2719','408',576689.53,576848.09,0.00,0.00,158.56,116700.16,0.00,0.00,0.00),('1','177','919','257965',4905345,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257965',4905346,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257965',4905347,'2718','408',393082.23,394206.87,0.00,0.00,1124.64,827735.04,0.00,0.00,0.00),('1','177','919','257965',4905348,'2719','408',576848.09,576962.89,0.00,0.00,114.80,84492.80,0.00,0.00,0.00),('1','177','919','257966',4905349,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257966',4905350,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257966',4905351,'2718','408',394206.87,395412.84,0.00,0.00,1205.97,887593.92,0.00,0.00,0.00),('1','177','919','257966',4905352,'2719','408',576962.89,577381.19,0.00,0.00,418.30,307868.80,0.00,0.00,0.00),('1','177','919','257967',4905353,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257967',4905354,'2717','408',92413.39,92413.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257967',4905355,'2718','408',395412.84,397009.02,0.00,0.00,1596.18,1174788.48,0.00,0.00,0.00),('1','177','919','257967',4905356,'2719','408',577381.19,578386.75,0.00,0.00,1005.56,740092.16,0.00,0.00,0.00),('1','177','919','257968',4905357,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257968',4905358,'2717','408',92413.39,92420.19,0.00,0.00,6.80,5004.80,0.00,0.00,0.00),('1','177','919','257968',4905359,'2718','408',397009.02,398619.60,0.00,0.00,1610.58,1185386.88,0.00,0.00,0.00),('1','177','919','257968',4905360,'2719','408',578386.75,579008.29,0.00,0.00,621.54,457453.44,0.00,0.00,0.00),('1','177','919','257969',4905361,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257969',4905362,'2717','408',92420.19,92432.69,0.00,0.00,12.50,9200.00,0.00,0.00,0.00),('1','177','919','257969',4905363,'2718','408',398619.60,400205.87,0.00,0.00,1586.27,1167494.72,0.00,0.00,0.00),('1','177','919','257969',4905364,'2719','408',579008.29,579544.83,0.00,0.00,536.54,394893.44,0.00,0.00,0.00),('1','177','919','257970',4905365,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257970',4905366,'2717','408',92432.69,92432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257970',4905367,'2718','408',400205.87,401177.34,0.00,0.00,971.47,715001.92,0.00,0.00,0.00),('1','177','919','257970',4905368,'2719','408',579544.83,579944.58,0.00,0.00,399.75,294216.00,0.00,0.00,0.00),('1','177','919','257971',4905369,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257971',4905370,'2717','408',92432.69,92432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257971',4905371,'2718','408',401177.34,401578.33,0.00,0.00,400.99,295128.64,0.00,0.00,0.00),('1','177','919','257971',4905372,'2719','408',579944.58,580054.04,0.00,0.00,109.46,80562.56,0.00,0.00,0.00),('1','177','919','257972',4905373,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257972',4905374,'2717','408',92432.69,92432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257972',4905375,'2718','408',401578.33,402774.03,0.00,0.00,1195.70,880035.20,0.00,0.00,0.00),('1','177','919','257972',4905376,'2719','408',580054.04,581447.16,0.00,0.00,1393.12,1025336.32,0.00,0.00,0.00),('1','177','919','257973',4905377,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257973',4905378,'2717','408',92432.69,92432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257973',4905379,'2718','408',402774.03,404637.62,0.00,0.00,1863.59,1371602.24,0.00,0.00,0.00),('1','177','919','257973',4905380,'2719','408',581447.16,581551.60,0.00,0.00,104.44,76867.84,0.00,0.00,0.00),('1','177','919','257974',4905381,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257974',4905382,'2717','408',92432.69,92432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257974',4905383,'2718','408',404637.62,406278.61,0.00,0.00,1640.99,1207768.64,0.00,0.00,0.00),('1','177','919','257974',4905384,'2719','408',581551.60,581883.09,0.00,0.00,331.49,243976.64,0.00,0.00,0.00),('1','177','919','257975',4905385,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257975',4905386,'2717','408',92432.69,92432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257975',4905387,'2718','408',406278.61,407380.67,0.00,0.00,1102.06,811116.16,0.00,0.00,0.00),('1','177','919','257975',4905388,'2719','408',581883.09,582883.03,0.00,0.00,999.94,735955.84,0.00,0.00,0.00),('1','177','919','257976',4905389,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257976',4905390,'2717','408',92432.69,92482.69,0.00,0.00,50.00,36800.00,0.00,0.00,0.00),('1','177','919','257976',4905391,'2718','408',407380.67,408215.71,0.00,0.00,835.04,614589.44,0.00,0.00,0.00),('1','177','919','257976',4905392,'2719','408',582883.03,583092.01,0.00,0.00,208.98,153809.28,0.00,0.00,0.00),('1','177','919','257977',4905393,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257977',4905394,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257977',4905395,'2718','408',408215.71,408631.37,0.00,0.00,415.66,305925.76,0.00,0.00,0.00),('1','177','919','257977',4905396,'2719','408',583092.01,584357.23,0.00,0.00,1265.22,931201.92,0.00,0.00,0.00),('1','177','919','257978',4905397,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257978',4905398,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257978',4905399,'2718','408',408631.37,410825.43,0.00,0.00,2194.06,1614828.16,0.00,0.00,0.00),('1','177','919','257978',4905400,'2719','408',584357.23,584719.34,0.00,0.00,362.11,266512.96,0.00,0.00,0.00),('1','177','919','257979',4905401,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257979',4905402,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257979',4905403,'2718','408',410825.43,411413.34,0.00,0.00,587.91,432701.76,0.00,0.00,0.00),('1','177','919','257979',4905404,'2719','408',584719.34,584868.96,0.00,0.00,149.62,110120.32,0.00,0.00,0.00),('1','177','919','257980',4905405,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257980',4905406,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257980',4905407,'2718','408',411413.34,412521.95,0.00,0.00,1108.61,815936.96,0.00,0.00,0.00),('1','177','919','257980',4905408,'2719','408',584868.96,585058.24,0.00,0.00,189.28,139310.08,0.00,0.00,0.00),('1','177','919','257981',4905409,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257981',4905410,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257981',4905411,'2718','408',412521.95,412527.95,0.00,0.00,6.00,4416.00,0.00,0.00,0.00),('1','177','919','257981',4905412,'2719','408',585058.24,585537.18,0.00,0.00,478.94,352499.84,0.00,0.00,0.00),('1','177','919','257982',4905413,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257982',4905414,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257982',4905415,'2718','408',412527.95,412848.85,0.00,0.00,320.90,224630.00,0.00,0.00,0.00),('1','177','919','257982',4905416,'2719','408',585537.18,585537.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257983',4905417,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257983',4905418,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257983',4905419,'2718','408',412848.85,414503.22,0.00,0.00,1654.37,1158059.00,0.00,0.00,0.00),('1','177','919','257983',4905420,'2719','408',585537.18,585754.82,0.00,0.00,217.64,152348.00,0.00,0.00,0.00),('1','177','919','257984',4905421,'2716','408',35605.16,35605.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257984',4905422,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257984',4905423,'2718','408',414503.22,415554.21,0.00,0.00,1050.99,735693.00,0.00,0.00,0.00),('1','177','919','257984',4905424,'2719','408',585754.82,585961.68,0.00,0.00,206.86,144802.00,0.00,0.00,0.00),('1','177','919','257985',4905425,'2716','408',35605.16,35606.59,0.00,0.00,1.43,1001.00,0.00,0.00,0.00),('1','177','919','257985',4905426,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257985',4905427,'2718','408',415554.21,415852.85,0.00,0.00,298.64,209048.00,0.00,0.00,0.00),('1','177','919','257985',4905428,'2719','408',585961.68,586018.86,0.00,0.00,57.18,40026.00,0.00,0.00,0.00),('1','177','919','257986',4905429,'2716','408',35606.59,35606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257986',4905430,'2717','408',92482.69,92482.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257986',4905431,'2718','408',415852.85,417592.17,0.00,0.00,1739.32,1217524.00,0.00,0.00,0.00),('1','177','919','257986',4905432,'2719','408',586018.86,586283.10,0.00,0.00,264.24,184968.00,0.00,0.00,0.00),('1','177','919','257987',4905433,'2716','408',35606.59,35606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257987',4905434,'2717','408',92482.69,92488.40,0.00,0.00,5.71,3997.00,0.00,0.00,0.00),('1','177','919','257987',4905435,'2718','408',417592.17,419604.97,0.00,0.00,2012.80,1408960.00,0.00,0.00,0.00),('1','177','919','257987',4905436,'2719','408',586283.10,586576.82,0.00,0.00,293.72,205604.00,0.00,0.00,0.00),('1','177','919','257988',4905437,'2716','408',35606.59,35606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257988',4905438,'2717','408',92488.40,92488.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257988',4905439,'2718','408',419604.97,419944.96,0.00,0.00,339.99,237993.00,0.00,0.00,0.00),('1','177','919','257988',4905440,'2719','408',586576.82,586662.68,0.00,0.00,85.86,60102.00,0.00,0.00,0.00),('1','177','919','257989',4905441,'2716','408',35606.59,35606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257989',4905442,'2717','408',92488.40,92488.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257989',4905443,'2718','408',419944.96,421090.24,0.00,0.00,1145.28,801891.48,0.00,0.00,0.00),('1','177','919','257989',4905444,'2719','408',586662.68,586769.47,0.00,0.00,106.79,74753.00,0.00,0.00,0.00),('1','177','919','257990',4905445,'2716','408',35606.59,35606.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257990',4905446,'2717','408',92488.40,92488.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('1','177','919','257990',4905447,'2718','408',421090.24,422496.60,0.00,0.00,1406.36,984452.00,0.00,0.00,0.00),('1','177','919','257990',4905448,'2719','408',586769.47,586956.33,0.00,0.00,186.86,130802.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730107 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('1','177','185575','408',323.00,356.00,0.00,139.35,45010.05,49608.60,4598.55,543175),('1','177','185703','408',323.00,356.00,0.00,224.00,72352.00,79744.00,7392.00,543510),('1','177','185892','408',323.00,356.00,0.00,162.00,52326.00,57672.00,5346.00,544015),('1','177','186122','408',323.00,356.00,0.00,77.92,25168.16,27739.52,2571.36,544623),('1','177','186332','408',323.00,356.00,0.00,91.64,29599.72,32623.84,3024.12,545171),('1','177','186531','408',323.00,356.00,0.00,163.01,52652.23,58031.56,5379.33,545708),('1','177','186773','408',323.00,356.00,0.00,233.43,75397.89,83101.08,7703.19,546323),('1','177','186983','408',323.00,356.00,0.00,209.57,67691.11,74606.92,6915.81,546852),('1','177','187197','408',323.00,356.00,0.00,294.43,95100.89,104817.08,9716.19,547421),('1','177','187339','408',323.00,356.00,0.00,139.75,45139.25,49751.00,4611.75,547803),('1','177','187597','408',323.00,356.00,0.00,178.76,57739.48,62923.52,5184.04,548474),('1','177','187799','408',323.00,352.00,0.00,309.26,99890.98,108859.52,8968.54,549016),('1','177','187998','408',323.00,352.00,0.00,0.00,0.00,0.00,0.00,549540),('1','177','188033','408',323.00,352.00,0.00,272.42,87991.66,95891.84,7900.18,549616),('1','177','188198','408',323.00,352.00,0.00,312.78,101027.94,110098.56,9070.62,550065),('1','177','188411','408',323.00,352.00,0.00,355.12,114703.76,125002.24,10298.48,550613),('1','177','188617','408',323.00,352.00,0.00,268.63,86767.49,94557.76,7790.27,551120),('1','177','188797','408',323.00,352.00,0.00,336.74,108767.02,118532.48,9765.46,551615),('1','177','189039','408',323.00,352.00,0.00,421.48,136138.04,148360.96,12222.92,552237),('1','177','189197','408',323.00,352.00,0.00,287.69,92923.87,101266.88,8343.01,552658),('1','177','189415','408',323.00,352.00,0.00,407.97,131774.31,143605.44,11831.13,553237),('1','177','189618','408',323.00,352.00,0.00,149.77,48375.71,52719.04,4343.33,553756),('1','177','189966','408',323.00,352.00,0.00,22.60,7299.80,7955.20,655.40,554662),('1','177','190042','408',323.00,352.00,0.00,281.16,90814.68,98968.32,8153.64,554844),('1','177','190206','408',323.00,352.00,0.00,382.69,123608.87,134706.88,11098.01,555289),('1','177','190437','408',323.00,352.00,0.00,755.39,243990.97,265897.28,21906.31,555884),('1','177','190664','408',323.00,352.00,0.00,620.89,200547.47,218553.28,18005.81,556499),('1','177','190888','408',323.00,352.00,0.00,421.79,136238.17,148470.08,12231.91,557080),('1','177','191073','408',323.00,352.00,0.00,444.26,143495.98,156379.52,12883.54,557565),('1','177','191291','408',323.00,352.00,0.00,585.59,189145.57,206127.68,16982.11,558137),('1','177','191492','408',323.00,352.00,0.00,471.46,152281.58,165953.92,13672.34,558673),('1','177','191716','408',323.00,352.00,0.00,625.31,201975.13,220109.12,18133.99,559262),('1','177','191953','408',323.00,352.00,0.00,277.26,89554.98,97595.52,8040.54,559891),('1','177','192130','408',323.00,352.00,0.00,231.58,74800.34,81516.16,6715.82,560369),('1','177','192344','408',323.00,352.00,0.00,383.00,123709.00,134816.00,11107.00,560925),('1','177','192567','408',323.00,352.00,0.00,466.84,150789.32,164327.68,13538.36,561506),('1','177','192777','408',323.00,352.00,0.00,605.08,195440.84,212988.16,17547.32,562045),('1','177','192957','408',323.00,352.00,0.00,583.80,188567.40,205497.60,16930.20,562525),('1','177','193157','408',323.00,352.00,0.00,508.59,164274.57,179023.68,14749.11,563068),('1','177','193410','408',323.00,352.00,0.00,306.41,98970.43,107856.32,8885.89,563722),('1','177','193634','408',323.00,352.00,0.00,377.46,121919.58,132865.92,10946.34,564301),('1','177','193857','408',323.00,352.00,0.00,280.36,90556.28,98686.72,8130.44,564855),('1','177','194093','408',323.00,352.00,0.00,395.14,127630.22,139089.28,11459.06,565439),('1','177','194295','408',323.00,352.00,0.00,203.46,65717.58,71617.92,5900.34,565978),('1','177','194499','408',323.00,352.00,0.00,685.77,221503.71,241391.04,19887.33,566485),('1','177','194678','408',323.00,352.00,0.00,247.80,80039.40,87225.60,7186.20,566947),('1','177','194813','408',323.00,352.00,0.00,114.03,36831.69,40138.56,3306.87,567309),('1','177','194887','408',323.00,352.00,0.00,580.82,187604.86,204448.64,16843.78,567506),('1','177','195088','408',323.00,352.00,0.00,370.40,119639.20,130380.80,10741.60,568022),('1','177','195308','408',323.00,352.00,0.00,412.07,133098.61,145048.64,11950.03,568597),('1','177','195534','408',323.00,352.00,0.00,599.10,193509.30,210883.20,17373.90,569170),('1','177','195793','408',323.00,352.00,0.00,756.48,244343.04,266280.96,21937.92,569810),('1','177','196020','408',323.00,352.00,0.00,502.29,162239.67,176806.08,14566.41,570393),('1','177','196243','408',323.00,352.00,0.00,522.67,168822.41,183979.84,15157.43,570950),('1','177','196467','408',323.00,352.00,0.00,370.78,119761.94,130514.56,10752.62,571531),('1','177','196668','408',323.00,352.00,0.00,545.61,176232.03,192054.72,15822.69,572044),('1','177','196885','408',323.00,352.00,0.00,86.20,27842.60,30342.40,2499.80,572628),('1','177','197038','408',323.00,352.00,0.00,288.18,93082.14,101439.36,8357.22,573009),('1','177','197333','408',323.00,352.00,0.00,264.10,85304.30,92963.20,7658.90,573798),('1','177','197336','408',323.00,352.00,0.00,163.09,52678.07,57407.68,4729.61,573801),('1','177','197396','408',323.00,352.00,0.00,426.99,137917.77,150300.48,12382.71,573885),('1','177','197524','408',323.00,352.00,0.00,445.95,144041.85,156974.40,12932.55,574180),('1','177','197885','408',323.00,352.00,0.00,587.43,189739.89,206775.36,17035.47,575153),('1','177','198131','408',323.00,352.00,0.00,480.98,155356.54,169304.96,13948.42,575780),('1','177','198363','408',323.00,352.00,0.00,369.89,119474.47,130201.28,10726.81,576383),('1','177','198581','408',323.00,352.00,0.00,625.47,202026.81,220165.44,18138.63,576952),('1','177','198784','408',323.00,352.00,0.00,848.07,273926.61,298520.64,24594.03,577453),('1','177','198999','408',323.00,352.00,0.00,545.83,176303.09,192132.16,15829.07,578009),('1','177','199227','408',323.00,352.00,0.00,537.45,173596.35,189182.40,15586.05,578578),('1','177','199447','408',323.00,352.00,0.00,102.30,33042.90,36009.60,2966.70,579118),('1','177','199526','408',323.00,352.00,0.00,351.38,113495.74,123685.76,10190.02,579321),('1','177','199716','408',323.00,352.00,0.00,503.79,160815.15,177334.08,16518.93,579772),('1','177','199901','408',317.00,352.00,0.00,526.44,166881.48,185306.88,18425.40,580234),('1','177','200134','408',317.00,352.00,0.00,520.91,165128.47,183360.32,18231.85,580850),('1','177','200289','408',317.00,352.00,0.00,736.24,233388.08,259156.48,25768.40,581267),('1','177','200499','408',317.00,352.00,0.00,522.08,165499.36,183772.16,18272.80,581803),('1','177','200685','408',317.00,352.00,0.00,630.40,199836.80,221900.80,22064.00,582301),('1','177','200934','408',317.00,352.00,0.00,491.15,155694.55,172884.80,17190.25,582922),('1','177','201109','408',317.00,352.00,0.00,581.32,184278.44,204624.64,20346.20,583376),('1','177','201337','408',317.00,352.00,0.00,547.84,173665.28,192839.68,19174.40,583951),('1','177','201513','408',317.00,352.00,0.00,80.49,25515.33,28332.48,2817.15,584413),('1','177','201531','408',317.00,352.00,0.00,550.54,174521.18,193790.08,19268.90,584453),('1','177','201778','408',317.00,352.00,0.00,32.84,10410.28,11559.68,1149.40,585118),('1','177','202034','408',317.00,352.00,0.00,591.79,187597.43,208310.08,20712.65,585798),('1','177','202234','408',317.00,352.00,0.00,781.69,247795.73,275154.88,27359.15,586308),('1','177','202449','408',317.00,352.00,0.00,589.29,186804.93,207430.08,20625.15,586856),('1','177','202635','408',317.00,352.00,0.00,631.93,200321.81,222439.36,22117.55,587341),('1','177','202863','408',317.00,352.00,0.00,791.62,250943.54,278650.24,27706.70,587922),('1','177','203140','408',317.00,352.00,0.00,517.16,163939.72,182040.32,18100.60,588636),('1','177','203317','408',317.00,352.00,0.00,892.83,283027.11,314276.16,31249.05,589114),('1','177','203519','408',317.00,352.00,0.00,718.50,227764.50,252912.00,25147.50,589623),('1','177','203693','408',317.00,352.00,0.00,709.78,225000.26,249842.56,24842.30,590082),('1','177','203739','408',317.00,352.00,0.00,726.97,230449.49,255893.44,25443.95,590188),('1','177','203960','408',317.00,352.00,0.00,629.07,199415.19,221432.64,22017.45,590762),('1','177','204208','408',317.00,352.00,0.00,689.09,218441.53,242559.68,24118.15,591404),('1','177','204387','408',317.00,352.00,0.00,577.20,182972.40,203174.40,20202.00,591879),('1','177','204665','408',317.00,352.00,0.00,600.79,190450.43,211478.08,21027.65,592574),('1','177','204838','408',317.00,352.00,0.00,429.22,136062.74,151085.44,15022.70,592990),('1','177','204948','408',317.00,352.00,0.00,660.38,209340.46,232453.76,23113.30,593273),('1','177','205048','408',317.00,352.00,0.00,477.44,151348.48,168058.88,16710.40,593526),('1','177','205216','408',317.00,352.00,0.00,858.25,272065.25,302104.00,30038.75,593981),('1','177','205465','408',317.00,352.00,0.00,810.25,256849.25,285208.00,28358.75,594612),('1','177','205713','408',317.00,352.00,0.00,671.38,212827.46,236325.76,23498.30,595263),('1','177','205951','408',317.00,352.00,0.00,816.75,258909.75,287496.00,28586.25,595867),('1','177','206131','408',317.00,352.00,0.00,733.01,232364.17,258019.52,25655.35,596333),('1','177','206377','408',317.00,352.00,0.00,560.80,177773.60,197401.60,19628.00,596948),('1','177','206466','408',317.00,352.00,0.00,444.58,140931.86,156492.16,15560.30,597175),('1','177','206627','408',317.00,352.00,0.00,559.01,177206.17,196771.52,19565.35,597580),('1','177','206792','408',317.00,352.00,0.00,777.51,246470.67,273683.52,27212.85,598023),('1','177','207037','408',317.00,352.00,0.00,790.86,250702.62,278382.72,27680.10,598647),('1','177','207317','408',317.00,352.00,0.00,665.08,210830.36,234108.16,23277.80,599377),('1','177','207489','408',317.00,352.00,0.00,818.63,259505.71,288157.76,28652.05,599820),('1','177','207718','408',317.00,352.00,0.00,963.44,305410.48,339130.88,33720.40,600395),('1','177','207904','408',317.00,352.00,0.00,178.65,56632.05,62884.80,6252.75,600875),('1','177','207990','408',317.00,352.00,0.00,822.51,260735.67,289523.52,28787.85,601100),('1','177','208115','408',334.00,364.00,0.00,727.40,242951.60,264773.60,21822.00,601415),('1','177','208323','408',334.00,364.00,0.00,916.10,305977.40,333460.40,27483.00,601949),('1','177','208547','408',334.00,364.00,0.00,900.91,300903.94,327931.24,27027.30,602530),('1','177','208794','408',334.00,364.00,0.00,887.13,296301.42,322915.32,26613.90,603143),('1','177','209007','408',334.00,364.00,0.00,586.96,196044.64,213653.44,17608.80,603688),('1','177','209205','408',334.00,364.00,0.00,268.74,89759.16,97821.36,8062.20,604212),('1','177','209280','408',334.00,364.00,0.00,646.77,232837.20,235424.28,2587.08,604393),('1','177','209443','408',360.00,364.00,0.00,806.92,290491.20,293718.88,3227.68,604800),('1','177','209632','408',360.00,364.00,0.00,881.70,317412.00,320938.80,3526.80,605302),('1','177','209850','408',360.00,364.00,0.00,1003.43,361234.80,365248.52,4013.72,605868),('1','177','210100','408',360.00,392.00,0.00,1109.88,399556.80,435072.96,35516.16,606513),('1','177','210330','408',360.00,392.00,0.00,691.54,248954.40,271083.68,22129.28,607096),('1','177','210484','408',360.00,392.00,0.00,499.49,179816.40,195800.08,15983.68,607516),('1','177','210530','408',360.00,392.00,0.00,1544.49,556016.40,605440.08,49423.68,607623),('1','177','210745','408',360.00,392.00,0.00,2245.46,808365.60,880220.32,71854.72,608193),('1','177','210956','408',360.00,392.00,0.00,923.04,332294.40,361831.68,29537.28,608737),('1','177','211084','408',360.00,392.00,0.00,655.68,242316.32,257026.56,14710.24,609069),('1','177','211182','408',376.00,392.00,0.00,1147.94,431625.44,449992.48,18367.04,609311),('1','177','211448','408',376.00,392.00,0.00,1127.73,424026.48,442070.16,18043.68,610010),('1','177','211668','408',376.00,392.00,0.00,472.47,177648.72,185208.24,7559.52,610571),('1','177','211811','408',376.00,392.00,0.00,893.22,335850.72,350142.24,14291.52,610930),('1','177','212010','408',376.00,392.00,0.00,860.33,323484.08,337249.36,13765.28,611447),('1','177','212190','408',376.00,392.00,0.00,625.00,235000.00,245000.00,10000.00,611942),('1','177','212442','408',376.00,392.00,0.00,1404.32,528024.32,550493.44,22469.12,612605),('1','177','212649','408',376.00,392.00,0.00,1738.01,653491.76,681299.92,27808.16,613155),('1','177','212681','408',376.00,392.00,0.00,990.34,372367.84,388213.28,15845.44,613222),('1','177','212896','408',376.00,392.00,0.00,473.48,178028.48,185604.16,7575.68,613775),('1','177','213092','408',376.00,392.00,0.00,1401.99,527148.24,549580.08,22431.84,614307),('1','177','213159','408',376.00,392.00,0.00,1733.67,651859.92,679598.64,27738.72,614465),('1','177','213412','408',376.00,392.00,0.00,1720.35,646851.60,674377.20,27525.60,615110),('1','177','213645','408',376.00,392.00,0.00,392.81,147696.56,153981.52,6284.96,615740),('1','177','213781','408',376.00,392.00,0.00,1549.93,582773.68,607572.56,24798.88,616103),('1','177','213926','408',376.00,392.00,0.00,2030.65,763524.40,796014.80,32490.40,616469),('1','177','214096','408',376.00,392.00,0.00,1431.98,538424.48,561336.16,22911.68,616923),('1','177','214357','408',376.00,392.00,0.00,1083.95,407565.20,424908.40,17343.20,617592),('1','177','214556','408',376.00,392.00,0.00,1750.49,658184.24,686192.08,28007.84,618100),('1','177','214784','408',376.00,392.00,0.00,1812.23,681398.48,710394.16,28995.68,618704),('1','177','215003','408',376.00,392.00,0.00,508.56,191218.56,199355.52,8136.96,619279),('1','177','215093','408',376.00,392.00,0.00,930.43,349841.68,364728.56,14886.88,619518),('1','177','215233','408',376.00,392.00,0.00,505.46,190052.96,199734.24,9681.28,619860),('1','177','215296','408',376.00,424.00,0.00,1059.35,398315.60,449164.40,50848.80,620032),('1','177','215447','408',376.00,424.00,0.00,1246.05,468514.80,528325.20,59810.40,620410),('1','177','215677','408',376.00,424.00,0.00,1352.36,508487.36,573400.64,64913.28,621013),('1','177','215869','408',376.00,424.00,0.00,150.56,56610.56,63837.44,7226.88,621507),('1','177','215906','408',376.00,424.00,0.00,1531.84,595964.04,649500.16,53536.12,621594),('1','177','216119','408',396.00,424.00,0.00,1272.68,503981.28,539616.32,35635.04,622147),('1','177','216334','408',396.00,428.00,0.00,1410.50,558558.00,603694.00,45136.00,622707),('1','177','216559','408',396.00,428.00,0.00,1022.16,404775.36,437484.48,32709.12,623304),('1','177','216794','408',396.00,428.00,0.00,333.15,131927.40,142588.20,10660.80,623924),('1','177','216866','408',396.00,428.00,0.00,1505.80,596296.80,644482.40,48185.60,624114),('1','177','217013','408',396.00,472.00,0.00,863.16,341811.36,407411.52,65600.16,624502),('1','177','217274','408',396.00,472.00,0.00,1362.07,539379.72,642897.04,103517.32,625184),('1','177','217443','408',396.00,472.00,0.00,349.16,138267.36,164803.52,26536.16,625635),('1','177','217507','408',431.00,472.00,0.00,908.04,391365.24,428594.88,37229.64,625793),('1','177','217728','408',431.00,472.00,0.00,1695.73,730859.63,800384.56,69524.93,626359),('1','177','217978','408',431.00,472.00,0.00,1650.82,711503.42,779187.04,67683.62,627031),('1','177','218231','408',431.00,472.00,0.00,634.58,273503.98,299521.76,26017.78,627691),('1','177','218329','408',431.00,472.00,0.00,1151.32,496218.92,543423.04,47204.12,627950),('1','177','218451','408',431.00,472.00,0.00,1380.90,595167.90,651784.80,56616.90,628272),('1','177','218682','408',431.00,472.00,0.00,966.99,416772.69,456419.28,39646.59,628871),('1','177','218905','408',431.00,472.00,0.00,994.77,428745.87,469531.44,40785.57,629458),('1','177','219124','408',431.00,472.00,0.00,102.29,44086.99,48280.88,4193.89,630017),('1','177','219168','408',431.00,472.00,0.00,868.49,374319.19,409927.28,35608.09,630131),('1','177','219325','408',431.00,472.00,0.00,353.93,152543.83,167054.96,14511.13,630557),('1','177','219471','408',431.00,440.00,0.00,563.70,242954.70,248028.00,5073.30,630933),('1','177','219605','408',431.00,440.00,0.00,1334.32,575091.92,587100.80,12008.88,631281),('1','177','219811','408',431.00,440.00,0.00,1686.25,726773.75,741950.00,15176.25,631826),('1','177','220055','408',431.00,440.00,0.00,549.50,236834.50,241780.00,4945.50,632471),('1','177','220159','408',431.00,440.00,0.00,974.59,419353.15,428819.60,9466.45,632757),('1','177','220260','408',430.00,440.00,0.00,1653.35,710940.50,727474.00,16533.50,633017),('1','177','220463','408',430.00,440.00,0.00,2498.09,1074178.70,1099159.60,24980.90,633554),('1','177','220692','408',430.00,440.00,0.00,288.16,123908.80,126790.40,2881.60,634140),('1','177','220742','408',430.00,440.00,0.00,1048.67,452498.10,461414.80,8916.70,634269),('1','177','220908','408',440.00,440.00,0.00,1502.13,660937.20,660937.20,0.00,634708),('1','177','221149','408',440.00,440.00,0.00,1694.24,738301.00,745465.60,7164.60,635325),('1','177','221402','408',430.00,440.00,0.00,1067.17,458883.10,469554.80,10671.70,635984),('1','177','221608','408',430.00,464.00,0.00,1399.74,601888.20,649479.36,47591.16,636538),('1','177','221841','408',430.00,464.00,0.00,1144.27,492036.10,530941.28,38905.18,637130),('1','177','222071','408',430.00,464.00,0.00,1957.73,841823.90,908386.72,66562.82,637734),('1','177','222286','408',430.00,464.00,0.00,669.51,287889.30,310652.64,22763.34,638277),('1','177','222417','408',430.00,464.00,0.00,384.82,165472.60,178556.48,13083.88,638626),('1','177','222524','408',430.00,464.00,0.00,1673.96,725867.60,776717.44,50849.84,638886),('1','177','222726','408',436.00,464.00,0.00,1772.87,772971.32,822611.68,49640.36,639435),('1','177','223029','408',436.00,464.00,0.00,696.44,303647.84,323148.16,19500.32,640247),('1','177','223073','408',436.00,464.00,0.00,837.48,365141.28,388590.72,23449.44,640368),('1','177','223261','408',436.00,464.00,0.00,1440.85,628210.60,668554.40,40343.80,640813),('1','177','223429','408',436.00,464.00,0.00,1190.31,518975.16,552303.84,33328.68,641230),('1','177','223628','408',436.00,464.00,0.00,481.11,209763.96,234781.68,25017.72,641753),('1','177','223724','408',436.00,488.00,0.00,0.00,0.00,0.00,0.00,641990),('1','177','223728','408',436.00,488.00,0.00,1072.35,467544.60,523306.80,55762.20,642000),('1','177','223844','408',436.00,488.00,0.00,0.00,0.00,0.00,0.00,642307),('1','177','223902','408',436.00,488.00,0.00,1102.61,496297.92,538073.68,41775.76,642445),('1','177','224065','408',459.00,488.00,0.00,1296.58,595130.22,632731.04,37600.82,642886),('1','177','224295','408',459.00,488.00,0.00,953.59,437697.81,484423.72,46725.91,643482),('1','177','224535','408',459.00,508.00,0.00,470.01,215734.59,238765.08,23030.49,644102),('1','177','224662','408',459.00,508.00,0.00,822.51,377532.09,417835.08,40302.99,644437),('1','177','224773','408',459.00,508.00,0.00,1600.68,734712.12,813145.44,78433.32,644717),('1','177','225001','408',459.00,508.00,0.00,1766.95,811030.05,897610.60,86580.55,645312),('1','177','225249','408',459.00,508.00,0.00,1076.22,493984.98,546719.76,52734.78,645957),('1','177','225387','408',459.00,508.00,0.00,1160.57,532701.63,589569.56,56867.93,646294),('1','177','225480','408',459.00,508.00,0.00,1286.54,590521.86,653562.32,63040.46,646536),('1','177','225679','408',459.00,508.00,0.00,1725.39,791954.01,876498.12,84544.11,647059),('1','177','226018','408',459.00,520.00,0.00,844.70,387717.30,439244.00,51526.70,647928),('1','177','226106','408',459.00,520.00,0.00,754.14,355963.38,392152.80,36189.42,648169),('1','177','226233','408',475.00,520.00,0.00,1626.30,772492.50,845676.00,73183.50,648498),('1','177','226463','408',475.00,520.00,0.00,1121.32,532627.00,583086.40,50459.40,649096),('1','177','226749','408',475.00,520.00,0.00,1349.52,641022.00,701750.40,60728.40,649812),('1','177','226944','408',475.00,520.00,0.00,342.02,162459.50,177850.40,15390.90,650342),('1','177','227062','408',475.00,520.00,0.00,1241.67,603451.62,645668.40,42216.78,650638),('1','177','227181','408',486.00,520.00,0.00,1190.24,578456.64,618924.80,40468.16,650951),('1','177','227409','408',486.00,520.00,0.00,1320.74,641879.64,686784.80,44905.16,651525),('1','177','227597','408',486.00,520.00,0.00,1167.34,567327.24,607016.80,39689.56,652024),('1','177','227813','408',486.00,520.00,0.00,234.89,114156.54,122142.80,7986.26,652586),('1','177','227840','408',486.00,520.00,0.00,2441.67,1186651.62,1269668.40,83016.78,652654),('1','177','228127','408',486.00,520.00,0.00,2518.32,1223903.52,1309526.40,85622.88,653402),('1','177','228351','408',486.00,520.00,0.00,1888.22,917674.92,1057403.20,139728.28,653983),('1','177','228529','408',486.00,560.00,0.00,1500.18,729087.48,840100.80,111013.32,654438),('1','177','228758','408',486.00,560.00,0.00,1480.95,719741.70,829332.00,109590.30,655020),('1','177','228938','408',486.00,560.00,0.00,87.49,42520.14,48994.40,6474.26,655480),('1','177','229013','408',486.00,560.00,0.00,1156.99,562297.14,647914.40,85617.26,655671),('1','177','229177','408',486.00,560.00,0.00,1860.25,904081.50,1041740.00,137658.50,656107),('1','177','229411','408',486.00,560.00,0.00,1305.66,634550.76,762505.44,127954.68,656715),('1','177','229664','408',486.00,584.00,0.00,578.97,281379.42,338118.48,56739.06,657360),('1','177','229724','408',486.00,584.00,0.00,1015.33,527072.78,592952.72,65879.94,657507),('1','177','229873','408',526.00,584.00,0.00,1830.51,962848.26,1069017.84,106169.58,657907),('1','177','230075','408',526.00,584.00,0.00,1442.32,758660.32,842314.88,83654.56,658429),('1','177','230273','408',526.00,584.00,0.00,998.22,525063.72,582960.48,57896.76,658936),('1','177','230473','408',526.00,584.00,0.00,164.07,86300.82,95816.88,9516.06,659455),('1','177','230544','408',526.00,584.00,0.00,661.85,348133.10,386520.40,38387.30,659617),('1','177','230703','408',526.00,584.00,0.00,536.71,282309.46,313438.64,31129.18,660059),('1','177','230780','408',526.00,584.00,0.00,1572.55,827161.30,918369.20,91207.90,660247),('1','177','231050','408',526.00,584.00,0.00,1090.83,573776.58,637044.72,63268.14,660974),('1','177','231358','408',526.00,584.00,0.00,1108.13,582876.38,647147.92,64271.54,661793),('1','177','231565','408',526.00,584.00,0.00,623.03,327713.78,363849.52,36135.74,662337),('1','177','231628','408',526.00,584.00,0.00,1634.18,859578.68,954361.12,94782.44,662497),('1','177','231875','408',526.00,584.00,0.00,1620.07,852156.82,946120.88,93964.06,663171),('1','177','232102','408',526.00,584.00,0.00,956.16,502940.16,558397.44,55457.28,663765),('1','177','232213','408',526.00,584.00,0.00,1247.05,655948.30,728277.20,72328.90,664054),('1','177','232301','408',526.00,526.00,0.00,0.00,0.00,0.00,0.00,664288),('1','177','232318','408',526.00,584.00,0.00,1428.36,751317.36,834162.24,82844.88,664325),('1','177','232559','408',526.00,584.00,0.00,0.00,0.00,0.00,0.00,664975),('1','177','232573','408',546.00,600.00,0.00,1497.66,817722.36,898596.00,80873.64,665008),('1','177','232827','408',546.00,600.00,0.00,1183.53,646207.38,710118.00,63910.62,665678),('1','177','233073','408',546.00,600.00,0.00,0.00,0.00,0.00,0.00,666323),('1','177','233107','408',546.00,600.00,0.00,1067.96,595691.76,640776.00,45084.24,666401),('1','177','233356','408',561.00,600.00,0.00,1513.76,849219.36,944006.16,94786.80,667060),('1','177','233591','408',561.00,624.00,0.00,1719.15,964443.15,1072749.60,108306.45,667673),('1','177','233824','408',561.00,624.00,0.00,1201.76,674187.36,749898.24,75710.88,668291),('1','177','233987','408',561.00,624.00,0.00,174.63,97967.43,108969.12,11001.69,668711),('1','177','234038','408',561.00,624.00,0.00,257.09,144823.02,160424.16,15601.14,668850),('1','177','234169','408',570.00,600.00,0.00,761.68,434157.60,457008.00,22850.40,669190),('1','177','234292','408',570.00,600.00,0.00,1391.51,793160.70,834906.00,41745.30,669525),('1','177','234567','408',570.00,600.00,0.00,1458.30,831231.00,874980.00,43749.00,670249),('1','177','234802','408',570.00,600.00,0.00,950.43,541745.10,570258.00,28512.90,670882),('1','177','235047','408',570.00,600.00,0.00,1795.87,1023645.90,1077522.00,53876.10,671548),('1','177','235282','408',570.00,600.00,0.00,1639.93,934760.10,983958.00,49197.90,672150),('1','177','235507','408',570.00,600.00,0.00,1165.57,664374.90,699342.00,34967.10,672729),('1','177','235735','408',570.00,600.00,0.00,494.55,281893.50,316512.00,34618.50,673320),('1','177','235889','408',592.00,624.00,0.00,816.59,483421.28,509552.16,26130.88,673710),('1','177','235995','408',592.00,624.00,0.00,1324.55,784133.60,826519.20,42385.60,674007),('1','177','236218','408',592.00,624.00,0.00,1073.99,635802.08,670169.76,34367.68,674594),('1','177','236486','408',592.00,624.00,0.00,1722.27,1019583.84,1074696.48,55112.64,675304),('1','177','236711','408',592.00,624.00,0.00,411.34,243513.28,256676.16,13162.88,675890),('1','177','236811','408',592.00,624.00,0.00,934.69,553336.48,583246.56,29910.08,676123),('1','177','236938','408',592.00,624.00,0.00,1666.46,986544.32,1039871.04,53326.72,676469),('1','177','237150','408',592.00,624.00,0.00,1233.59,730285.28,769760.16,39474.88,677016),('1','177','237362','408',592.00,624.00,0.00,1418.58,839799.36,885193.92,45394.56,677561),('1','177','237588','408',592.00,624.00,0.00,198.19,117328.48,123670.56,6342.08,678153),('1','177','237753','408',592.00,624.00,0.00,0.00,0.00,0.00,0.00,678569),('1','177','237755','408',592.00,624.00,0.00,1031.71,610772.32,643787.04,33014.72,678573),('1','177','237850','408',592.00,624.00,0.00,1237.12,732375.04,771962.88,39587.84,678837),('1','177','238104','408',592.00,624.00,0.00,1530.58,906103.36,955081.92,48978.56,679489),('1','177','238337','408',592.00,624.00,0.00,1478.38,875200.96,922509.12,47308.16,680082),('1','177','238596','408',592.00,624.00,0.00,1816.23,1090149.66,1133327.52,43177.86,680765),('1','177','238821','408',602.00,624.00,0.00,1432.42,862316.84,893830.08,31513.24,681340),('1','177','239055','408',602.00,624.00,0.00,1566.46,943008.92,977471.04,34462.12,681942),('1','177','239300','408',602.00,624.00,0.00,496.03,298610.06,309522.72,10912.66,682575),('1','177','239402','408',602.00,624.00,0.00,1109.70,668039.40,692452.80,24413.40,682848),('1','177','239539','408',602.00,624.00,0.00,2098.46,1263272.92,1309439.04,46166.12,683199),('1','177','239742','408',602.00,624.00,0.00,1578.55,950287.10,985015.20,34728.10,683745),('1','177','239990','408',602.00,624.00,0.00,444.85,267799.70,277586.40,9786.70,684378),('1','177','240072','408',602.00,624.00,0.00,1052.52,633617.04,656772.48,23155.44,684582),('1','177','240174','408',602.00,624.00,0.00,1468.17,883838.34,916138.08,32299.74,684860),('1','177','240432','408',602.00,624.00,0.00,1538.37,926098.74,959942.88,33844.14,685535),('1','177','240665','408',602.00,624.00,0.00,1180.36,710576.72,736544.64,25967.92,686101),('1','177','240898','408',602.00,624.00,0.00,216.27,130194.54,134952.48,4757.94,686713),('1','177','240948','408',602.00,624.00,0.00,1339.18,806186.36,835648.32,29461.96,686854),('1','177','241200','408',602.00,624.00,0.00,1642.61,988851.22,1024988.64,36137.42,687516),('1','177','241469','408',602.00,624.00,0.00,1453.37,874928.74,906902.88,31974.14,688232),('1','177','241712','408',602.00,624.00,0.00,664.30,399908.60,414523.20,14614.60,688869),('1','177','241852','408',602.00,624.00,0.00,1045.85,629601.70,652610.40,23008.70,689221),('1','177','241962','408',602.00,624.00,0.00,1604.35,965818.70,1001114.40,35295.70,689521),('1','177','242180','408',602.00,624.00,0.00,1591.20,957902.40,992908.80,35006.40,690086),('1','177','242408','408',602.00,624.00,0.00,1148.28,691264.56,716526.72,25262.16,690681),('1','177','242620','408',602.00,624.00,0.00,201.12,121074.24,125498.88,4424.64,691227),('1','177','242650','408',602.00,624.00,0.00,1857.07,1117956.14,1158811.68,40855.54,691304),('1','177','242899','408',602.00,624.00,0.00,1130.74,680705.48,705581.76,24876.28,691960),('1','177','243116','408',602.00,624.00,0.00,1205.49,725704.98,752225.76,26520.78,692528),('1','177','243338','408',602.00,624.00,0.00,1048.44,631160.88,654226.56,23065.68,693117),('1','177','243524','408',602.00,624.00,0.00,532.05,319318.00,331999.20,12681.20,693583),('1','177','243574','408',592.00,624.00,0.00,1940.94,1149036.48,1211146.56,62110.08,693718),('1','177','243807','408',592.00,624.00,0.00,1250.29,740171.68,780180.96,40009.28,694325),('1','177','244031','408',592.00,624.00,0.00,1439.60,852243.20,898310.40,46067.20,694896),('1','177','244266','408',592.00,624.00,0.00,164.82,97573.44,102847.68,5274.24,695517),('1','177','244383','408',592.00,624.00,0.00,1718.20,1017174.40,1072156.80,54982.40,695798),('1','177','244495','408',592.00,624.00,0.00,1478.52,875283.84,922596.48,47312.64,696103),('1','177','244731','408',592.00,624.00,0.00,1408.08,833583.36,878641.92,45058.56,696718),('1','177','244953','408',592.00,616.00,0.00,463.23,274232.16,285449.68,11217.52,697304),('1','177','245087','408',592.00,616.00,0.00,1458.17,836712.04,898232.72,61520.68,697622),('1','177','245194','408',572.00,616.00,0.00,1544.43,883413.96,951368.88,67954.92,697920),('1','177','245420','408',572.00,616.00,0.00,1289.96,737857.12,794615.36,56758.24,698500),('1','177','245663','408',572.00,616.00,0.00,859.10,491405.20,529205.60,37800.40,699128),('1','177','245858','408',572.00,616.00,0.00,395.14,225744.38,243406.24,17661.86,699625),('1','177','245890','408',562.00,616.00,0.00,0.00,0.00,0.00,0.00,699715),('1','177','245921','408',562.00,616.00,0.00,1546.77,869284.74,952810.32,83525.58,699806),('1','177','246168','408',562.00,616.00,0.00,1216.68,683774.16,749474.88,65700.72,700437),('1','177','246437','408',562.00,616.00,0.00,1818.32,1021895.84,1120085.12,98189.28,701149),('1','177','246686','408',562.00,616.00,0.00,350.97,197245.14,216197.52,18952.38,701804),('1','177','246761','408',562.00,616.00,0.00,1486.78,818548.46,915856.48,97308.02,701970),('1','177','246917','408',548.00,616.00,0.00,1835.65,1005936.20,1130760.40,124824.20,702395),('1','177','247152','408',548.00,616.00,0.00,1392.40,763035.20,857718.40,94683.20,703008),('1','177','247380','408',548.00,616.00,0.00,62.54,34271.92,38524.64,4252.72,703583),('1','177','247454','408',548.00,616.00,0.00,1622.14,888932.72,999238.24,110305.52,703743),('1','177','247651','408',548.00,616.00,0.00,526.47,288505.56,324305.52,35799.96,704292),('1','177','247751','408',548.00,592.00,0.00,1052.93,577005.64,623334.56,46328.92,704520),('1','177','247886','408',548.00,592.00,0.00,1778.93,974853.64,1053126.56,78272.92,704895),('1','177','248136','408',548.00,592.00,0.00,1899.49,1040920.52,1124498.08,83577.56,705545),('1','177','248391','408',548.00,592.00,0.00,1980.00,1085040.00,1172160.00,87120.00,706200),('1','177','248624','408',548.00,592.00,0.00,1422.55,779557.40,842149.60,62592.20,706799),('1','177','248741','408',548.00,592.00,0.00,729.11,399552.28,431633.12,32080.84,707077),('1','177','248896','408',548.00,592.00,0.00,911.46,499480.08,539584.32,40104.24,707482),('1','177','249094','408',548.00,592.00,0.00,1574.32,862727.36,931997.44,69270.08,708013),('1','177','249331','408',548.00,592.00,0.00,1044.58,572429.84,618391.36,45961.52,708609),('1','177','249575','408',548.00,592.00,0.00,996.53,546098.44,589945.76,43847.32,709230),('1','177','249772','408',548.00,592.00,0.00,285.60,156508.80,169075.20,12566.40,709740),('1','177','249839','408',548.00,592.00,0.00,1198.21,656619.08,709340.32,52721.24,709912),('1','177','250087','408',548.00,592.00,0.00,1379.55,755993.40,816693.60,60700.20,710540),('1','177','250324','408',548.00,592.00,0.00,1632.66,894697.68,966534.72,71837.04,711151),('1','177','250555','408',548.00,592.00,0.00,653.26,357986.48,386729.92,28743.44,711732),('1','177','250680','408',548.00,592.00,0.00,496.62,272147.76,293999.04,21851.28,712047),('1','177','250789','408',548.00,592.00,0.00,2087.79,1144108.92,1235971.68,91862.76,712345),('1','177','251003','408',548.00,592.00,0.00,1596.73,875008.04,945264.16,70256.12,712898),('1','177','251264','408',548.00,592.00,0.00,948.69,519882.12,561624.48,41742.36,713574),('1','177','251499','408',548.00,592.00,0.00,106.70,58471.60,63166.40,4694.80,714198),('1','177','251559','408',548.00,592.00,0.00,1383.75,758295.00,819180.00,60885.00,714324),('1','177','251748','408',548.00,592.00,0.00,1389.42,761402.16,822536.64,61134.48,714849),('1','177','251977','408',548.00,592.00,0.00,1419.65,777968.20,840432.80,62464.60,715449),('1','177','252225','408',548.00,592.00,0.00,1317.09,721765.32,779717.28,57951.96,716096),('1','177','252457','408',548.00,592.00,0.00,1276.83,699702.84,755883.36,56180.52,716697),('1','177','252700','408',548.00,592.00,0.00,1843.62,1010303.76,1091423.04,81119.28,717328),('1','177','252957','408',548.00,592.00,0.00,821.78,450335.44,486493.76,36158.32,717993),('1','177','253116','408',548.00,592.00,0.00,704.08,385835.84,416815.36,30979.52,718392),('1','177','253202','408',548.00,592.00,0.00,1315.86,721091.28,778989.12,57897.84,718635),('1','177','253461','408',548.00,592.00,0.00,1529.25,838029.00,905316.00,67287.00,719309),('1','177','253704','408',548.00,592.00,0.00,1869.91,1024710.68,1106986.72,82276.04,719931),('1','177','253940','408',548.00,548.00,0.00,0.00,0.00,0.00,0.00,720551),('1','177','253942','408',548.00,592.00,0.00,1820.53,997650.44,1077753.76,80103.32,720556),('1','177','254180','408',548.00,592.00,0.00,1652.65,905652.20,978368.80,72716.60,721174),('1','177','254429','408',548.00,592.00,0.00,1802.61,987830.28,1067145.12,79314.84,721824),('1','177','254687','408',548.00,592.00,0.00,1559.35,854523.80,923135.20,68611.40,722469),('1','177','254928','408',548.00,592.00,0.00,1774.06,972184.88,1050243.52,78058.64,723085),('1','177','255111','408',548.00,592.00,0.00,738.94,404939.12,437452.48,32513.36,723545),('1','177','255175','408',548.00,592.00,0.00,1993.73,1092564.04,1180288.16,87724.12,723724),('1','177','255452','408',548.00,592.00,0.00,1308.71,717173.08,774756.32,57583.24,724407),('1','177','255644','408',548.00,592.00,0.00,333.14,182560.72,197218.88,14658.16,724865),('1','177','255702','408',548.00,592.00,0.00,1788.86,980295.28,1059005.12,78709.84,725024),('1','177','255928','408',548.00,592.00,0.00,1348.71,739093.08,798436.32,59343.24,725606),('1','177','256208','408',548.00,592.00,0.00,154.58,84709.84,91511.36,6801.52,726282),('1','177','256264','408',548.00,592.00,0.00,1191.59,652991.32,705421.28,52429.96,726399),('1','177','256471','408',548.00,592.00,0.00,1290.62,707259.76,764047.04,56787.28,726984),('1','177','256705','408',548.00,592.00,0.00,1508.66,826745.68,893126.72,66381.04,727585),('1','177','256949','408',548.00,592.00,0.00,1571.11,860968.28,930097.12,69128.84,728224),('1','177','257167','408',548.00,592.00,0.00,267.11,146376.28,158129.12,11752.84,728786),('1','177','257221','408',548.00,592.00,0.00,1804.50,988866.00,1068264.00,79398.00,728932),('1','177','257472','408',548.00,592.00,0.00,1744.74,956117.52,1002098.40,45980.88,729588),('1','177','257473','408',548.00,568.00,0.00,1746.52,957092.96,992023.36,34930.40,729589),('1','177','257474','408',548.00,568.00,0.00,151.02,82758.96,85779.36,3020.40,729590),('1','177','257475','408',548.00,568.00,0.00,1645.99,865306.04,934922.32,69616.28,729591),('1','177','257476','408',500.00,568.00,0.00,1672.05,836025.00,949724.40,113699.40,729592),('1','177','257477','408',500.00,568.00,0.00,1959.85,979925.00,1113194.80,133269.80,729593),('1','177','257478','408',500.00,568.00,0.00,245.08,122540.00,139205.44,16665.44,729594),('1','177','257479','408',500.00,568.00,0.00,2091.21,1045605.00,1187807.28,142202.28,729595),('1','177','257480','408',500.00,568.00,0.00,1814.30,907150.00,1030522.40,123372.40,729596),('1','177','257481','408',500.00,568.00,0.00,1026.01,513005.00,582773.68,69768.68,729597),('1','177','257482','408',500.00,568.00,0.00,96.84,48420.00,55005.12,6585.12,729598),('1','177','257483','408',500.00,568.00,0.00,675.36,337680.00,383604.48,45924.48,729599),('1','177','257484','408',500.00,568.00,0.00,1494.47,747235.00,848858.96,101623.96,729600),('1','177','257485','408',500.00,568.00,0.00,1657.68,828840.00,941562.24,112722.24,729601),('1','177','257486','408',500.00,568.00,0.00,1531.32,765660.00,869789.76,104129.76,729602),('1','177','257487','408',500.00,568.00,0.00,351.86,175930.00,199856.48,23926.48,729603),('1','177','257488','408',500.00,568.00,0.00,1646.73,823365.00,935342.64,111977.64,729604),('1','177','257489','408',500.00,568.00,0.00,1937.87,968935.00,1100710.16,131775.16,729605),('1','177','257490','408',500.00,568.00,0.00,1455.17,727585.00,826536.56,98951.56,729606),('1','177','257491','408',500.00,568.00,0.00,1922.01,961005.00,1091701.68,130696.68,729607),('1','177','257492','408',500.00,568.00,0.00,1757.70,878850.00,998373.60,119523.60,729608),('1','177','257493','408',500.00,568.00,0.00,597.64,298820.00,339459.52,40639.52,729609),('1','177','257494','408',500.00,568.00,0.00,1288.22,644110.00,731708.96,87598.96,729610),('1','177','257495','408',500.00,568.00,0.00,1666.45,833225.00,946543.60,113318.60,729611),('1','177','257496','408',500.00,568.00,0.00,1586.75,793375.00,901274.00,107899.00,729612),('1','177','257497','408',500.00,568.00,0.00,920.39,460195.00,522781.52,62586.52,729613),('1','177','257498','408',500.00,568.00,0.00,1053.12,526560.00,598172.16,71612.16,729614),('1','177','257499','408',500.00,568.00,0.00,1835.02,917510.00,1042291.36,124781.36,729615),('1','177','257500','408',500.00,568.00,0.00,1782.39,891195.00,1012397.52,121202.52,729616),('1','177','257501','408',500.00,568.00,0.00,710.85,355425.00,403762.80,48337.80,729617),('1','177','257502','408',500.00,568.00,0.00,1205.21,602605.00,684559.28,81954.28,729618),('1','177','257503','408',500.00,568.00,0.00,1672.66,836330.00,950070.88,113740.88,729619),('1','177','257504','408',500.00,568.00,0.00,1502.65,751325.00,853505.20,102180.20,729620),('1','177','257505','408',500.00,568.00,0.00,839.36,419680.00,476756.48,57076.48,729621),('1','177','257506','408',500.00,568.00,0.00,0.00,0.00,0.00,0.00,729622),('1','177','257507','408',500.00,568.00,0.00,1074.78,537390.00,610475.04,73085.04,729623),('1','177','257508','408',500.00,568.00,0.00,1452.35,726175.00,824934.80,98759.80,729624),('1','177','257509','408',500.00,568.00,0.00,1484.41,742205.00,843144.88,100939.88,729625),('1','177','257510','408',500.00,568.00,0.00,1437.05,718525.00,816244.40,97719.40,729626),('1','177','257511','408',500.00,568.00,0.00,330.54,165270.00,187746.72,22476.72,729627),('1','177','257512','408',500.00,568.00,0.00,1573.19,786595.00,893571.92,106976.92,729628),('1','177','257513','408',500.00,568.00,0.00,2337.93,1168965.00,1327944.24,158979.24,729629),('1','177','257514','408',500.00,568.00,0.00,1009.74,504870.00,573532.32,68662.32,729630),('1','177','257515','408',500.00,568.00,0.00,699.96,349980.00,397577.28,47597.28,729631),('1','177','257516','408',532.00,580.00,0.00,1604.22,853445.04,930447.60,77002.56,729632),('1','177','257517','408',532.00,580.00,0.00,1742.43,926972.76,1010609.40,83636.64,729633),('1','177','257518','408',532.00,580.00,0.00,1202.94,639964.08,697705.20,57741.12,729634),('1','177','257519','408',532.00,580.00,0.00,563.09,299563.88,326592.20,27028.32,729635),('1','177','257520','408',532.00,580.00,0.00,1773.86,943693.52,1028838.80,85145.28,729636),('1','177','257521','408',532.00,580.00,0.00,1668.93,887870.76,967979.40,80108.64,729637),('1','177','257522','408',532.00,580.00,0.00,1192.24,634271.68,691499.20,57227.52,729638),('1','177','257523','408',532.00,580.00,0.00,0.00,0.00,0.00,0.00,729639),('1','177','257524','408',532.00,640.00,0.00,1626.32,865202.24,1040844.80,175642.56,729640),('1','177','257525','408',532.00,640.00,0.00,1801.66,958483.12,1153062.40,194579.28,729641),('1','177','257526','408',532.00,640.00,0.00,1387.01,737889.32,887686.40,149797.08,729642),('1','177','257527','408',532.00,640.00,0.00,386.83,205793.56,247571.20,41777.64,729643),('1','177','257528','408',532.00,640.00,0.00,2038.32,1084386.24,1304524.80,220138.56,729644),('1','177','257529','408',532.00,640.00,0.00,2024.42,1076991.44,1295628.80,218637.36,729645),('1','177','257530','408',532.00,640.00,0.00,1070.81,569670.92,685318.40,115647.48,729646),('1','177','257531','408',532.00,640.00,0.00,220.52,128342.64,141132.80,12790.16,729647),('1','177','257532','408',582.00,640.00,0.00,2280.77,1381814.94,1550923.60,169108.66,729648),('1','177','257533','408',606.00,680.00,0.00,1517.98,919895.88,1032226.40,112330.52,729649),('1','177','257534','408',606.00,680.00,0.00,1154.87,699851.22,785311.60,85460.38,729650),('1','177','257535','408',606.00,680.00,0.00,533.76,323458.56,362956.80,39498.24,729651),('1','177','257536','408',606.00,656.00,0.00,2022.89,1225871.34,1327015.84,101144.50,729652),('1','177','257537','408',606.00,656.00,0.00,2045.68,1239682.08,1341966.08,102284.00,729653),('1','177','257538','408',606.00,656.00,0.00,1031.29,624961.74,676526.24,51564.50,729654),('1','177','257539','408',606.00,656.00,0.00,590.24,357685.44,387197.44,29512.00,729655),('1','177','257540','408',606.00,656.00,0.00,1506.97,913223.82,988572.32,75348.50,729656),('1','177','257541','408',606.00,656.00,0.00,1855.54,1124457.24,1217234.24,92777.00,729657),('1','177','257542','408',606.00,656.00,0.00,1291.67,782752.02,847335.52,64583.50,729658),('1','177','257543','408',606.00,656.00,0.00,2013.33,1204314.46,1320744.48,116430.02,729659),('1','177','257544','408',598.00,656.00,0.00,1810.60,1082738.80,1187753.60,105014.80,729660),('1','177','257545','408',598.00,656.00,0.00,980.36,586255.28,643116.16,56860.88,729661),('1','177','257546','408',598.00,656.00,0.00,1115.68,667176.64,731886.08,64709.44,729662),('1','177','257547','408',598.00,656.00,0.00,411.87,244256.76,272364.32,28107.56,729663),('1','177','257548','408',568.00,688.00,0.00,1355.95,770179.60,932893.60,162714.00,729664),('1','177','257549','408',568.00,688.00,0.00,1638.51,930673.68,1127294.88,196621.20,729665),('1','177','257550','408',568.00,688.00,0.00,1543.77,876861.36,1062113.76,185252.40,729666),('1','177','257551','408',568.00,688.00,0.00,2026.98,1151324.64,1394562.24,243237.60,729667),('1','177','257552','408',617.00,664.00,0.00,1785.81,1101844.77,1185777.84,83933.07,729668),('1','177','257553','408',617.00,664.00,0.00,1239.08,764512.36,822749.12,58236.76,729669),('1','177','257554','408',602.00,664.00,0.00,391.17,235484.34,259736.88,24252.54,729670),('1','177','257555','408',602.00,664.00,0.00,2651.35,1596112.70,1760496.40,164383.70,729671),('1','177','257556','408',602.00,664.00,0.00,1976.33,1189750.66,1312283.12,122532.46,729672),('1','177','257557','408',602.00,664.00,0.00,271.96,163719.92,180581.44,16861.52,729673),('1','177','257558','408',602.00,664.00,0.00,1747.08,1051742.16,1160061.12,108318.96,729674),('1','177','257559','408',602.00,664.00,0.00,1796.75,1081643.50,1193042.00,111398.50,729675),('1','177','257560','408',602.00,664.00,0.00,1664.16,1001824.32,1105002.24,103177.92,729676),('1','177','257561','408',602.00,664.00,0.00,305.89,184145.78,203110.96,18965.18,729677),('1','177','257562','408',602.00,664.00,0.00,1209.81,728305.62,803313.84,75008.22,729678),('1','177','257563','408',602.00,664.00,0.00,1764.72,1062361.44,1171774.08,109412.64,729679),('1','177','257564','408',602.00,664.00,0.00,2119.82,1276131.64,1407560.48,131428.84,729680),('1','177','257565','408',602.00,664.00,0.00,18.50,11137.00,12284.00,1147.00,729681),('1','177','257566','408',602.00,664.00,0.00,2029.94,1222023.88,1347880.16,125856.28,729682),('1','177','257567','408',602.00,664.00,0.00,1921.31,1156628.62,1275749.84,119121.22,729683),('1','177','257568','408',602.00,664.00,0.00,1297.85,781305.70,861772.40,80466.70,729684),('1','177','257569','408',602.00,664.00,0.00,2013.43,1212084.86,1336917.52,124832.66,729685),('1','177','257570','408',602.00,664.00,0.00,1916.87,1153955.74,1272801.68,118845.94,729686),('1','177','257571','408',602.00,664.00,0.00,1261.70,759543.40,837768.80,78225.40,729687),('1','177','257572','408',602.00,664.00,0.00,542.65,326675.30,360319.60,33644.30,729688),('1','177','257573','408',602.00,664.00,0.00,1897.03,1142012.06,1259627.92,117615.86,729689),('1','177','257574','408',602.00,664.00,0.00,2060.30,1240300.60,1368039.20,127738.60,729690),('1','177','257575','408',602.00,664.00,0.00,835.82,503163.64,554984.48,51820.84,729691),('1','177','257576','408',602.00,664.00,0.00,1313.35,790636.70,872064.40,81427.70,729692),('1','177','257577','408',602.00,664.00,0.00,1752.29,1054878.58,1163520.56,108641.98,729693),('1','177','257578','408',602.00,664.00,0.00,2118.20,1275156.40,1406484.80,131328.40,729694),('1','177','257579','408',592.00,664.00,0.00,1685.51,997821.92,1119178.64,121356.72,729695),('1','177','257580','408',592.00,664.00,0.00,1879.40,1112604.80,1247921.60,135316.80,729696),('1','177','257581','408',592.00,664.00,0.00,1770.35,1048047.20,1175512.40,127465.20,729697),('1','177','257582','408',592.00,664.00,0.00,285.06,168755.52,189279.84,20524.32,729698),('1','177','257583','408',592.00,664.00,0.00,2501.50,1480888.00,1660996.00,180108.00,729699),('1','177','257584','408',592.00,664.00,0.00,1784.52,1056435.84,1184921.28,128485.44,729700),('1','177','257585','408',592.00,664.00,0.00,483.18,286042.56,320831.52,34788.96,729701),('1','177','257586','408',592.00,664.00,0.00,1181.75,699596.00,784682.00,85086.00,729702),('1','177','257587','408',592.00,664.00,0.00,1845.17,1092340.64,1225192.88,132852.24,729703),('1','177','257588','408',592.00,664.00,0.00,1847.96,1093992.32,1227045.44,133053.12,729704),('1','177','257589','408',592.00,664.00,0.00,530.22,313890.24,352066.08,38175.84,729705),('1','177','257590','408',592.00,664.00,0.00,1896.74,1122870.08,1259435.36,136565.28,729706),('1','177','257591','408',592.00,664.00,0.00,3213.83,1902587.36,2133983.12,231395.76,729707),('1','177','257592','408',592.00,664.00,0.00,1865.06,1104115.52,1238399.84,134284.32,729708),('1','177','257593','408',592.00,664.00,0.00,1341.37,794091.04,890669.68,96578.64,729709),('1','177','257594','408',592.00,664.00,0.00,1665.76,986129.92,1106064.64,119934.72,729710),('1','177','257595','408',592.00,664.00,0.00,513.31,303879.52,340837.84,36958.32,729711),('1','177','257596','408',592.00,664.00,0.00,1038.39,614726.88,689490.96,74764.08,729712),('1','177','257597','408',592.00,664.00,0.00,2110.27,1249279.84,1401219.28,151939.44,729713),('1','177','257598','408',592.00,664.00,0.00,2048.21,1212540.32,1360011.44,147471.12,729714),('1','177','257599','408',592.00,664.00,0.00,238.06,140931.52,158071.84,17140.32,729715),('1','177','257600','408',592.00,664.00,0.00,1980.70,1172574.40,1315184.80,142610.40,729716),('1','177','257601','408',592.00,664.00,0.00,1642.98,972644.16,1090938.72,118294.56,729717),('1','177','257602','408',592.00,664.00,0.00,1659.51,982429.92,1101914.64,119484.72,729718),('1','177','257603','408',592.00,664.00,0.00,889.78,526749.76,590813.92,64064.16,729719),('1','177','257604','408',592.00,664.00,0.00,479.09,283621.28,318115.76,34494.48,729720),('1','177','257605','408',592.00,664.00,0.00,2430.82,1439045.44,1614064.48,175019.04,729721),('1','177','257606','408',592.00,664.00,0.00,1707.89,1011070.88,1134038.96,122968.08,729722),('1','177','257607','408',592.00,664.00,0.00,2544.41,1506290.72,1689488.24,183197.52,729723),('1','177','257608','408',592.00,680.00,0.00,1686.64,998490.88,1146915.20,148424.32,729724),('1','177','257609','408',592.00,680.00,0.00,775.82,459285.44,527557.60,68272.16,729725),('1','177','257610','408',592.00,680.00,0.00,1976.42,1176913.64,1343965.60,167051.96,729726),('1','177','257611','408',602.00,680.00,0.00,1334.32,803260.64,907337.60,104076.96,729727),('1','177','257612','408',602.00,680.00,0.00,409.88,246747.76,278718.40,31970.64,729728),('1','177','257613','408',602.00,680.00,0.00,1973.08,1187794.16,1341694.40,153900.24,729729),('1','177','257614','408',602.00,680.00,0.00,1060.21,638246.42,720942.80,82696.38,729730),('1','177','257615','408',602.00,680.00,0.00,562.75,338775.50,382670.00,43894.50,729731),('1','177','257616','408',602.00,680.00,0.00,2377.51,1431261.02,1616706.80,185445.78,729732),('1','177','257617','408',602.00,680.00,0.00,1945.17,1170992.34,1322715.60,151723.26,729733),('1','177','257618','408',602.00,680.00,0.00,283.08,170414.16,192494.40,22080.24,729734),('1','177','257619','408',602.00,680.00,0.00,1457.17,877216.34,990875.60,113659.26,729735),('1','177','257620','408',602.00,680.00,0.00,2827.30,1702034.60,1922564.00,220529.40,729736),('1','177','257621','408',602.00,680.00,0.00,1533.62,1015256.44,1104206.40,88949.96,729737),('1','177','257622','408',662.00,720.00,0.00,2170.24,1436698.88,1562572.80,125873.92,729738),('1','177','257623','408',662.00,720.00,0.00,1729.56,1144968.72,1245283.20,100314.48,729739),('1','177','257624','408',662.00,720.00,0.00,2461.59,1629572.58,1772344.80,142772.22,729740),('1','177','257625','408',662.00,720.00,0.00,2049.30,1356636.60,1475496.00,118859.40,729741),('1','177','257626','408',662.00,720.00,0.00,394.47,261139.14,284018.40,22879.26,729742),('1','177','257627','408',662.00,720.00,0.00,841.88,557324.56,606153.60,48829.04,729743),('1','177','257628','408',662.00,760.00,0.00,1985.26,1314242.12,1508797.60,194555.48,729744),('1','177','257629','408',662.00,760.00,0.00,1239.74,820707.88,942202.40,121494.52,729745),('1','177','257630','408',662.00,760.00,0.00,754.68,499598.16,573556.80,73958.64,729746),('1','177','257631','408',662.00,760.00,0.00,1942.74,1286093.88,1476482.40,190388.52,729747),('1','177','257632','408',662.00,760.00,0.00,2001.18,1324781.16,1520896.80,196115.64,729748),('1','177','257633','408',662.00,760.00,0.00,410.46,271724.52,311949.60,40225.08,729749),('1','177','257634','408',662.00,760.00,0.00,852.56,564394.72,647945.60,83550.88,729750),('1','177','257635','408',662.00,760.00,0.00,1766.88,1169674.56,1342828.80,173154.24,729751),('1','177','257636','408',662.00,760.00,0.00,1833.99,1214101.38,1393832.40,179731.02,729752),('1','177','257637','408',662.00,760.00,0.00,2365.42,1565908.04,1797719.20,231811.16,729753),('1','177','257638','408',662.00,760.00,0.00,62.01,41050.62,47127.60,6076.98,729754),('1','177','257639','408',662.00,760.00,0.00,2217.84,1468210.08,1685558.40,217348.32,729755),('1','177','257640','408',662.00,760.00,0.00,1331.16,881227.92,1011681.60,130453.68,729756),('1','177','257641','408',662.00,760.00,0.00,1167.54,772911.48,887330.40,114418.92,729757),('1','177','257642','408',662.00,760.00,0.00,2233.04,1478272.48,1697110.40,218837.92,729758),('1','177','257643','408',662.00,760.00,0.00,1671.02,1106215.24,1269975.20,163759.96,729759),('1','177','257644','408',662.00,760.00,0.00,1300.09,860659.58,988068.40,127408.82,729760),('1','177','257645','408',662.00,760.00,0.00,2407.40,1593698.80,1829624.00,235925.20,729761),('1','177','257646','408',662.00,760.00,0.00,1430.41,946931.42,1087111.60,140180.18,729762),('1','177','257647','408',662.00,760.00,0.00,808.89,535485.18,614756.40,79271.22,729763),('1','177','257648','408',662.00,760.00,0.00,2573.01,1703332.62,1955487.60,252154.98,729764),('1','177','257649','408',662.00,760.00,0.00,1866.21,1235431.02,1418319.60,182888.58,729765),('1','177','257650','408',662.00,760.00,0.00,2453.52,1624230.24,1864675.20,240444.96,729766),('1','177','257651','408',662.00,760.00,0.00,2031.22,1344667.64,1543727.20,199059.56,729767),('1','177','257652','408',662.00,760.00,0.00,1434.52,949652.24,1090235.20,140582.96,729768),('1','177','257653','408',662.00,760.00,0.00,773.05,511759.10,587518.00,75758.90,729769),('1','177','257654','408',662.00,760.00,0.00,2292.49,1517628.38,1742292.40,224664.02,729770),('1','177','257655','408',662.00,760.00,0.00,1736.55,1149596.10,1319778.00,170181.90,729771),('1','177','257656','408',662.00,760.00,0.00,1713.19,1134131.78,1302024.40,167892.62,729772),('1','177','257657','408',662.00,760.00,0.00,484.06,320447.72,367885.60,47437.88,729773),('1','177','257658','408',662.00,760.00,0.00,2446.37,1619496.94,1859241.20,239744.26,729774),('1','177','257659','408',662.00,760.00,0.00,1793.27,1187144.74,1362885.20,175740.46,729775),('1','177','257660','408',662.00,760.00,0.00,797.30,527812.60,605948.00,78135.40,729776),('1','177','257661','408',662.00,760.00,0.00,744.33,492746.46,565690.80,72944.34,729777),('1','177','257662','408',662.00,760.00,0.00,2883.78,1909062.36,2191672.80,282610.44,729778),('1','177','257663','408',662.00,760.00,0.00,1815.25,1201695.50,1379590.00,177894.50,729779),('1','177','257664','408',662.00,760.00,0.00,466.84,309048.08,354798.40,45750.32,729780),('1','177','257665','408',662.00,760.00,0.00,1508.08,998348.96,1146140.80,147791.84,729781),('1','177','257666','408',662.00,760.00,0.00,2094.62,1386638.44,1591911.20,205272.76,729782),('1','177','257667','408',662.00,760.00,0.00,1493.50,988697.00,1135060.00,146363.00,729783),('1','177','257668','408',662.00,760.00,0.00,59.69,39514.78,45364.40,5849.62,729784),('1','177','257669','408',662.00,760.00,0.00,1660.14,1099012.68,1261706.40,162693.72,729785),('1','177','257670','408',662.00,760.00,0.00,2226.15,1473711.30,1691874.00,218162.70,729786),('1','177','257671','408',662.00,760.00,0.00,1948.14,1289668.68,1480586.40,190917.72,729787),('1','177','257672','408',662.00,760.00,0.00,605.48,400827.76,460164.80,59337.04,729788),('1','177','257673','408',662.00,760.00,0.00,1985.97,1314712.14,1509337.20,194625.06,729789),('1','177','257674','408',662.00,760.00,0.00,1745.51,1155527.62,1326587.60,171059.98,729790),('1','177','257675','408',662.00,760.00,0.00,741.59,490932.58,563608.40,72675.82,729791),('1','177','257676','408',662.00,760.00,0.00,1253.45,829783.90,952622.00,122838.10,729792),('1','177','257677','408',662.00,760.00,0.00,1700.30,1125598.60,1292228.00,166629.40,729793),('1','177','257678','408',662.00,760.00,0.00,2092.96,1385539.52,1590649.60,205110.08,729794),('1','177','257679','408',662.00,760.00,0.00,306.11,202644.82,232643.60,29998.78,729795),('1','177','257680','408',662.00,760.00,0.00,1982.68,1312534.16,1506836.80,194302.64,729796),('1','177','257681','408',662.00,760.00,0.00,1951.66,1291998.92,1483261.60,191262.68,729797),('1','177','257682','408',662.00,760.00,0.00,1465.55,970194.10,1113818.00,143623.90,729798),('1','177','257683','408',662.00,760.00,0.00,95.45,63187.90,72542.00,9354.10,729799),('1','177','257684','408',662.00,760.00,0.00,1157.39,766192.18,879616.40,113424.22,729800),('1','177','257685','408',662.00,760.00,0.00,1204.42,797326.04,915359.20,118033.16,729801),('1','177','257686','408',662.00,760.00,0.00,1866.43,1235576.66,1418486.80,182910.14,729802),('1','177','257687','408',662.00,760.00,0.00,1559.72,1032534.64,1185387.20,152852.56,729803),('1','177','257688','408',662.00,760.00,0.00,1555.43,1029694.66,1182126.80,152432.14,729804),('1','177','257689','408',662.00,760.00,0.00,2016.66,1335028.92,1532661.60,197632.68,729805),('1','177','257690','408',662.00,760.00,0.00,449.82,297780.84,341863.20,44082.36,729806),('1','177','257691','408',662.00,760.00,0.00,2121.14,1404194.68,1612066.40,207871.72,729807),('1','177','257692','408',662.00,760.00,0.00,1624.90,1079022.00,1234924.00,155902.00,729808),('1','177','257693','408',682.00,760.00,0.00,927.56,632595.92,704945.60,72349.68,729809),('1','177','257694','408',682.00,760.00,0.00,1131.93,771976.26,860266.80,88290.54,729810),('1','177','257695','408',682.00,760.00,0.00,1989.65,1356941.30,1512134.00,155192.70,729811),('1','177','257696','408',682.00,760.00,0.00,1782.19,1215453.58,1354464.40,139010.82,729812),('1','177','257697','408',682.00,760.00,0.00,405.03,276230.46,307822.80,31592.34,729813),('1','177','257698','408',682.00,760.00,0.00,1526.21,1040875.22,1159919.60,119044.38,729814),('1','177','257699','408',682.00,744.00,0.00,1797.47,1225874.54,1337317.68,111443.14,729815),('1','177','257700','408',682.00,744.00,0.00,1626.80,1109477.60,1210339.20,100861.60,729816),('1','177','257701','408',682.00,744.00,0.00,740.57,505068.74,550984.08,45915.34,729817),('1','177','257702','408',682.00,744.00,0.00,927.14,632309.48,689792.16,57482.68,729818),('1','177','257703','408',682.00,744.00,0.00,1812.72,1236275.04,1348663.68,112388.64,729819),('1','177','257704','408',682.00,744.00,0.00,2287.96,1560388.72,1702242.24,141853.52,729820),('1','177','257705','408',682.00,744.00,0.00,429.68,293041.76,319681.92,26640.16,729821),('1','177','257706','408',682.00,744.00,0.00,1309.23,892894.86,974067.12,81172.26,729822),('1','177','257707','408',682.00,744.00,0.00,1846.16,1259081.12,1373543.04,114461.92,729823),('1','177','257708','408',682.00,744.00,0.00,2210.51,1507567.82,1644619.44,137051.62,729824),('1','177','257709','408',682.00,744.00,0.00,1984.79,1353626.78,1476683.76,123056.98,729825),('1','177','257710','408',682.00,744.00,0.00,2161.81,1474354.42,1608386.64,134032.22,729826),('1','177','257711','408',682.00,744.00,0.00,1207.40,823446.80,898305.60,74858.80,729827),('1','177','257712','408',682.00,744.00,0.00,512.40,349456.80,381225.60,31768.80,729828),('1','177','257713','408',682.00,744.00,0.00,2634.81,1796940.42,1960298.64,163358.22,729829),('1','177','257714','408',682.00,744.00,0.00,2133.74,1455210.68,1587502.56,132291.88,729830),('1','177','257715','408',682.00,744.00,0.00,2249.78,1534349.96,1673836.32,139486.36,729831),('1','177','257716','408',682.00,744.00,0.00,2707.95,1846821.90,2014714.80,167892.90,729832),('1','177','257717','408',682.00,744.00,0.00,323.27,220470.14,240512.88,20042.74,729833),('1','177','257718','408',682.00,744.00,0.00,1868.00,1273976.00,1389792.00,115816.00,729834),('1','177','257719','408',682.00,752.00,0.00,2167.37,1478146.34,1629862.24,151715.90,729835),('1','177','257720','408',682.00,752.00,0.00,670.14,457035.48,503945.28,46909.80,729836),('1','177','257721','408',682.00,752.00,0.00,1590.80,1084925.60,1196281.60,111356.00,729837),('1','177','257722','408',682.00,752.00,0.00,2037.64,1389670.48,1532305.28,142634.80,729838),('1','177','257723','408',682.00,752.00,0.00,1954.25,1332798.50,1469596.00,136797.50,729839),('1','177','257724','408',682.00,752.00,0.00,2377.83,1621680.06,1788128.16,166448.10,729840),('1','177','257725','408',682.00,752.00,0.00,2681.70,1828919.40,2016638.40,187719.00,729841),('1','177','257726','408',682.00,752.00,0.00,627.16,427723.12,471624.32,43901.20,729842),('1','177','257727','408',682.00,752.00,0.00,0.00,0.00,0.00,0.00,729843),('1','177','257728','408',682.00,752.00,0.00,1509.08,1029192.56,1134828.16,105635.60,729844),('1','177','257729','408',682.00,752.00,0.00,2168.80,1479121.60,1630937.60,151816.00,729845),('1','177','257730','408',682.00,744.00,0.00,1284.66,876138.12,955787.04,79648.92,729846),('1','177','257731','408',682.00,744.00,0.00,637.47,434754.54,474277.68,39523.14,729847),('1','177','257732','408',682.00,744.00,0.00,1813.54,1236834.28,1349273.76,112439.48,729848),('1','177','257733','408',682.00,744.00,0.00,2469.75,1684369.50,1837494.00,153124.50,729849),('1','177','257734','408',682.00,744.00,0.00,1630.69,1112130.58,1213233.36,101102.78,729850),('1','177','257735','408',682.00,744.00,0.00,2126.62,1450354.84,1582205.28,131850.44,729851),('1','177','257736','408',682.00,744.00,0.00,2046.42,1395658.44,1522536.48,126878.04,729852),('1','177','257737','408',682.00,744.00,0.00,1231.26,839719.32,916057.44,76338.12,729853),('1','177','257738','408',682.00,744.00,0.00,807.72,550865.04,600943.68,50078.64,729854),('1','177','257739','408',682.00,744.00,0.00,2039.86,1391184.52,1517655.84,126471.32,729855),('1','177','257740','408',682.00,744.00,0.00,1774.04,1209895.28,1319885.76,109990.48,729856),('1','177','257741','408',682.00,744.00,0.00,433.59,295708.38,322590.96,26882.58,729857),('1','177','257742','408',682.00,744.00,0.00,0.00,0.00,0.00,0.00,729858),('1','177','257743','408',682.00,744.00,0.00,2354.21,1605571.22,1751532.24,145961.02,729859),('1','177','257744','408',682.00,744.00,0.00,2409.24,1643101.68,1792474.56,149372.88,729860),('1','177','257745','408',682.00,744.00,0.00,380.20,259296.40,282868.80,23572.40,729861),('1','177','257746','408',682.00,744.00,0.00,1785.91,1217990.62,1328717.04,110726.42,729862),('1','177','257747','408',682.00,744.00,0.00,2289.47,1561418.54,1703365.68,141947.14,729863),('1','177','257748','408',682.00,744.00,0.00,1510.82,1030379.24,1124050.08,93670.84,729864),('1','177','257749','408',682.00,744.00,0.00,364.33,248473.06,271061.52,22588.46,729865),('1','177','257750','408',682.00,744.00,0.00,2378.20,1621932.40,1769380.80,147448.40,729866),('1','177','257751','408',682.00,744.00,0.00,1929.94,1316219.08,1435875.36,119656.28,729867),('1','177','257752','408',682.00,744.00,0.00,1309.26,892915.32,974089.44,81174.12,729868),('1','177','257753','408',682.00,744.00,0.00,1254.66,855678.12,933467.04,77788.92,729869),('1','177','257754','408',682.00,744.00,0.00,2346.76,1600490.32,1745989.44,145499.12,729870),('1','177','257755','408',682.00,744.00,0.00,2461.03,1678422.46,1831006.32,152583.86,729871),('1','177','257756','408',682.00,744.00,0.00,630.35,429898.70,468980.40,39081.70,729872),('1','177','257757','408',682.00,744.00,0.00,1542.55,1052019.10,1147657.20,95638.10,729873),('1','177','257758','408',682.00,744.00,0.00,2175.61,1483766.02,1618653.84,134887.82,729874),('1','177','257759','408',682.00,744.00,0.00,1525.91,1040670.62,1135277.04,94606.42,729875),('1','177','257760','408',682.00,744.00,0.00,1048.76,715254.32,780277.44,65023.12,729876),('1','177','257761','408',682.00,744.00,0.00,2010.21,1370963.22,1495596.24,124633.02,729877),('1','177','257762','408',682.00,744.00,0.00,2355.06,1606150.92,1752164.64,146013.72,729878),('1','177','257763','408',682.00,744.00,0.00,1640.41,1118759.62,1220465.04,101705.42,729879),('1','177','257764','408',682.00,744.00,0.00,2323.50,1584627.00,1728684.00,144057.00,729880),('1','177','257765','408',682.00,744.00,0.00,1398.90,954049.80,1040781.60,86731.80,729881),('1','177','257766','408',682.00,744.00,0.00,0.00,0.00,0.00,0.00,729882),('1','177','257767','408',682.00,744.00,0.00,909.02,619951.64,676310.88,56359.24,729883),('1','177','257768','408',682.00,744.00,0.00,1844.50,1257949.00,1372308.00,114359.00,729884),('1','177','257769','408',682.00,744.00,0.00,2021.73,1378819.86,1504167.12,125347.26,729885),('1','177','257770','408',682.00,736.00,0.00,181.24,123605.68,133392.64,9786.96,729886),('1','177','257771','408',682.00,736.00,0.00,2193.71,1496110.22,1614570.56,118460.34,729887),('1','177','257772','408',682.00,736.00,0.00,2607.28,1778164.96,1918958.08,140793.12,729888),('1','177','257773','408',682.00,736.00,0.00,197.91,134974.62,145661.76,10687.14,729889),('1','177','257774','408',682.00,736.00,0.00,874.39,596333.98,643551.04,47217.06,729890),('1','177','257775','408',682.00,736.00,0.00,1896.45,1283278.50,1395787.20,112508.70,729891),('1','177','257776','408',670.00,736.00,0.00,2139.39,1433391.30,1574591.04,141199.74,729892),('1','177','257777','408',670.00,736.00,0.00,344.81,231022.70,253780.16,22757.46,729893),('1','177','257778','408',670.00,736.00,0.00,1970.51,1320241.70,1450295.36,130053.66,729894),('1','177','257779','408',670.00,736.00,0.00,2313.10,1549777.00,1702441.60,152664.60,729895),('1','177','257780','408',670.00,736.00,0.00,837.19,560917.30,616171.84,55254.54,729896),('1','177','257781','408',670.00,736.00,0.00,2043.33,1369031.10,1505404.88,136373.78,729897),('1','177','257782','408',670.00,736.00,0.00,2052.03,1374860.10,1510294.08,135433.98,729898),('1','177','257783','408',670.00,736.00,0.00,1052.84,705402.80,774890.24,69487.44,729899),('1','177','257784','408',670.00,736.00,0.00,1369.09,917290.30,1007650.24,90359.94,729900),('1','177','257785','408',670.00,736.00,0.00,2310.49,1548028.30,1700520.64,152492.34,729901),('1','177','257786','408',670.00,736.00,0.00,1547.52,1036838.40,1138974.72,102136.32,729902),('1','177','257787','408',670.00,736.00,0.00,566.25,379387.50,416760.00,37372.50,729903),('1','177','257788','408',670.00,736.00,0.00,2434.76,1631289.20,1791983.36,160694.16,729904),('1','177','257789','408',670.00,736.00,0.00,2038.28,1365647.60,1500174.08,134526.48,729905),('1','177','257790','408',670.00,736.00,0.00,993.16,665417.20,730965.76,65548.56,729906),('1','177','257791','408',670.00,736.00,0.00,1499.29,1004524.30,1103477.44,98953.14,729907),('1','177','257792','408',670.00,736.00,0.00,2192.18,1468760.60,1613444.48,144683.88,729908),('1','177','257793','408',670.00,736.00,0.00,1896.43,1270608.10,1395772.48,125164.38,729909),('1','177','257794','408',670.00,736.00,0.00,2587.67,1733738.90,1904525.12,170786.22,729910),('1','177','257795','408',670.00,736.00,0.00,1660.03,1112220.10,1221782.08,109561.98,729911),('1','177','257796','408',670.00,736.00,0.00,1332.65,892875.50,980830.40,87954.90,729912),('1','177','257797','408',670.00,736.00,0.00,3044.90,2040083.00,2241046.40,200963.40,729913),('1','177','257798','408',670.00,736.00,0.00,792.55,531008.50,583316.80,52308.30,729914),('1','177','257799','408',670.00,764.00,0.00,3703.64,2481438.80,2829580.96,348142.16,729915),('1','177','257800','408',670.00,764.00,0.00,687.61,460698.70,525334.04,64635.34,729916),('1','177','257801','408',670.00,764.00,0.00,0.00,0.00,0.00,0.00,729917),('1','177','257802','408',670.00,764.00,0.00,0.00,0.00,0.00,0.00,729918),('1','177','257803','408',670.00,748.00,0.00,2054.74,1376675.80,1536945.52,160269.72,729919),('1','177','257804','408',670.00,748.00,0.00,2956.15,1980620.50,2211200.20,230579.70,729920),('1','177','257805','408',670.00,748.00,0.00,1901.28,1273857.60,1422157.44,148299.84,729921),('1','177','257806','408',670.00,748.00,0.00,3455.40,2315118.00,2584639.20,269521.20,729922),('1','177','257807','408',670.00,748.00,0.00,2396.50,1605655.00,1792582.00,186927.00,729923),('1','177','257808','408',670.00,748.00,0.00,2409.20,1614164.00,1802081.60,187917.60,729924),('1','177','257809','408',670.00,748.00,0.00,768.97,515209.90,575189.56,59979.66,729925),('1','177','257810','408',670.00,748.00,0.00,2446.34,1639047.80,1829862.32,190814.52,729926),('1','177','257811','408',670.00,760.00,0.00,2115.18,1417170.60,1607536.80,190366.20,729927),('1','177','257812','408',670.00,760.00,0.00,1398.24,936820.80,1062662.40,125841.60,729928),('1','177','257813','408',670.00,760.00,0.00,733.59,491505.30,557528.40,66023.10,729929),('1','177','257814','408',670.00,760.00,0.00,3179.69,2130392.30,2416564.40,286172.10,729930),('1','177','257815','408',670.00,760.00,0.00,1988.47,1332274.90,1511237.20,178962.30,729931),('1','177','257816','408',670.00,760.00,0.00,1097.44,735284.80,834054.40,98769.60,729932),('1','177','257817','408',670.00,760.00,0.00,2992.61,2005048.70,2274383.60,269334.90,729933),('1','177','257818','408',670.00,760.00,0.00,660.20,442334.00,501752.00,59418.00,729934),('1','177','257819','408',670.00,760.00,0.00,980.79,657129.30,745400.40,88271.10,729935),('1','177','257820','408',670.00,760.00,0.00,2944.15,1972580.50,2237554.00,264973.50,729936),('1','177','257821','408',670.00,800.00,0.00,1997.76,1338499.20,1598208.00,259708.80,729937),('1','177','257822','408',670.00,800.00,0.00,238.14,159553.80,190512.00,30958.20,729938),('1','177','257823','408',670.00,800.00,0.00,2346.36,1572061.20,1877088.00,305026.80,729939),('1','177','257824','408',670.00,800.00,0.00,2038.91,1366069.70,1631128.00,265058.30,729940),('1','177','257825','408',670.00,800.00,0.00,798.20,534794.00,606632.00,71838.00,729941),('1','177','257826','408',670.00,760.00,0.00,1728.21,1157900.70,1313439.60,155538.90,729942),('1','177','257827','408',670.00,760.00,0.00,1906.84,1277582.80,1450938.40,173355.60,729943),('1','177','257828','408',670.00,760.00,0.00,1733.27,1161290.90,1317285.20,155994.30,729944),('1','177','257829','408',670.00,760.00,0.00,0.00,0.00,0.00,0.00,729945),('1','177','257830','408',670.00,760.00,0.00,2101.34,1407897.80,1597018.40,189120.60,729946),('1','177','257831','408',670.00,760.00,0.00,2189.47,1466944.90,1663997.20,197052.30,729947),('1','177','257832','408',670.00,760.00,0.00,860.69,576662.30,654124.40,77462.10,729948),('1','177','257833','408',670.00,760.00,0.00,1118.56,749435.20,850105.60,100670.40,729949),('1','177','257834','408',670.00,760.00,0.00,1781.57,1193651.90,1353993.20,160341.30,729950),('1','177','257835','408',670.00,760.00,0.00,1786.05,1196653.50,1357398.00,160744.50,729951),('1','177','257836','408',670.00,760.00,0.00,692.57,464021.90,526353.20,62331.30,729952),('1','177','257837','408',670.00,760.00,0.00,0.00,0.00,0.00,0.00,729953),('1','177','257838','408',670.00,760.00,0.00,1614.25,1096217.90,1226830.00,130612.10,729954),('1','177','257839','408',685.00,760.00,0.00,2050.54,1404619.90,1558410.40,153790.50,729955),('1','177','257840','408',685.00,760.00,0.00,1755.74,1202681.90,1334362.40,131680.50,729956),('1','177','257841','408',685.00,760.00,0.00,0.00,0.00,0.00,0.00,729957),('1','177','257842','408',685.00,760.00,0.00,512.13,350809.05,389218.80,38409.75,729958),('1','177','257843','408',685.00,760.00,0.00,1809.34,1239397.90,1375098.40,135700.50,729959),('1','177','257844','408',685.00,760.00,0.00,2200.94,1507643.90,1672714.40,165070.50,729960),('1','177','257845','408',685.00,760.00,0.00,833.48,570933.80,633444.80,62511.00,729961),('1','177','257846','408',685.00,760.00,0.00,1057.73,724545.05,803874.80,79329.75,729962),('1','177','257847','408',685.00,760.00,0.00,1760.01,1205606.85,1337607.60,132000.75,729963),('1','177','257848','408',685.00,760.00,0.00,1929.62,1321789.70,1466511.20,144721.50,729964),('1','177','257849','408',685.00,760.00,0.00,591.99,405513.15,449912.40,44399.25,729965),('1','177','257850','408',685.00,760.00,0.00,1133.97,776769.45,861817.20,85047.75,729966),('1','177','257851','408',685.00,760.00,0.00,2189.78,1499999.30,1664232.80,164233.50,729967),('1','177','257852','408',685.00,760.00,0.00,1847.85,1265777.25,1404366.00,138588.75,729968),('1','177','257853','408',685.00,760.00,0.00,1757.34,1203777.90,1335578.40,131800.50,729969),('1','177','257854','408',685.00,760.00,0.00,1792.75,1228033.75,1362490.00,134456.25,729970),('1','177','257855','408',685.00,760.00,0.00,1551.72,1062928.20,1179307.20,116379.00,729971),('1','177','257856','408',685.00,760.00,0.00,1840.87,1260995.95,1399061.20,138065.25,729972),('1','177','257857','408',685.00,760.00,0.00,1826.58,1251207.30,1388200.80,136993.50,729973),('1','177','257858','408',685.00,760.00,0.00,1620.98,1110371.30,1231944.80,121573.50,729974),('1','177','257859','408',685.00,760.00,0.00,702.06,480911.10,533565.60,52654.50,729975),('1','177','257860','408',685.00,760.00,0.00,1953.93,1338442.05,1484986.80,146544.75,729976),('1','177','257861','408',685.00,760.00,0.00,2317.08,1587199.80,1760980.80,173781.00,729977),('1','177','257862','408',685.00,760.00,0.00,290.08,198704.80,220460.80,21756.00,729978),('1','177','257863','408',685.00,760.00,0.00,1883.54,1290224.90,1431490.40,141265.50,729979),('1','177','257864','408',685.00,760.00,0.00,2266.09,1541477.50,1722228.40,180750.90,729980),('1','177','257865','408',670.00,760.00,0.00,913.88,612299.60,694548.80,82249.20,729981),('1','177','257866','408',670.00,760.00,0.00,1363.17,913323.90,1036009.20,122685.30,729982),('1','177','257867','408',670.00,760.00,0.00,2241.29,1501664.30,1703380.40,201716.10,729983),('1','177','257868','408',670.00,760.00,0.00,1510.54,1012061.80,1148010.40,135948.60,729984),('1','177','257869','408',670.00,760.00,0.00,1002.01,671346.70,761527.60,90180.90,729985),('1','177','257870','408',670.00,760.00,0.00,2250.94,1508129.80,1710714.40,202584.60,729986),('1','177','257871','408',670.00,760.00,0.00,1718.05,1151093.50,1305718.00,154624.50,729987),('1','177','257872','408',670.00,760.00,0.00,342.87,229722.90,260581.20,30858.30,729988),('1','177','257873','408',670.00,760.00,0.00,1975.53,1323605.10,1501402.80,177797.70,729989),('1','177','257874','408',670.00,760.00,0.00,1854.73,1242669.10,1409594.80,166925.70,729990),('1','177','257875','408',670.00,760.00,0.00,1202.17,805453.90,913649.20,108195.30,729991),('1','177','257876','408',670.00,760.00,0.00,226.69,151882.30,172284.40,20402.10,729992),('1','177','257877','408',670.00,760.00,0.00,2577.06,1726630.20,1958565.60,231935.40,729993),('1','177','257878','408',670.00,760.00,0.00,279.56,187305.20,212161.52,24856.32,729994),('1','177','257879','408',670.00,736.00,0.00,1450.16,971607.20,1067317.76,95710.56,729995),('1','177','257880','408',670.00,736.00,0.00,597.48,400311.60,439745.28,39433.68,729996),('1','177','257881','408',670.00,736.00,0.00,1661.74,1113365.80,1223040.64,109674.84,729997),('1','177','257882','408',670.00,736.00,0.00,1999.69,1339792.30,1471771.84,131979.54,729998),('1','177','257883','408',670.00,736.00,0.00,1368.72,912301.20,1007377.92,95076.72,729999),('1','177','257884','408',664.00,736.00,0.00,573.49,380797.36,422088.64,41291.28,730000),('1','177','257885','408',664.00,736.00,0.00,1740.60,1155758.40,1281081.60,125323.20,730001),('1','177','257886','408',664.00,736.00,0.00,2202.25,1462294.00,1620856.00,158562.00,730002),('1','177','257887','408',664.00,736.00,0.00,805.26,534692.64,592671.36,57978.72,730003),('1','177','257888','408',664.00,736.00,0.00,1084.60,720174.40,798265.60,78091.20,730004),('1','177','257889','408',664.00,736.00,0.00,2282.92,1515858.88,1680229.12,164370.24,730005),('1','177','257890','408',664.00,736.00,0.00,2337.88,1552352.32,1720679.68,168327.36,730006),('1','177','257891','408',664.00,736.00,0.00,2527.71,1678399.44,1860394.56,181995.12,730007),('1','177','257892','408',664.00,736.00,0.00,1885.37,1251885.68,1387632.32,135746.64,730008),('1','177','257893','408',664.00,736.00,0.00,836.72,555582.08,615825.92,60243.84,730009),('1','177','257894','408',664.00,736.00,0.00,1293.80,859083.20,952236.80,93153.60,730010),('1','177','257895','408',664.00,736.00,0.00,2752.83,1827879.12,2026096.88,198217.76,730011),('1','177','257896','408',664.00,736.00,0.00,1196.37,794389.68,880528.32,86138.64,730012),('1','177','257897','408',664.00,736.00,0.00,1005.53,667671.92,740070.08,72398.16,730013),('1','177','257898','408',664.00,736.00,0.00,2470.58,1640465.12,1818346.88,177881.76,730014),('1','177','257899','408',664.00,736.00,0.00,315.09,209219.76,231906.24,22686.48,730015),('1','177','257900','408',664.00,736.00,0.00,2128.62,1413403.68,1566664.32,153260.64,730016),('1','177','257901','408',664.00,736.00,0.00,2182.48,1449166.72,1606305.28,157138.56,730017),('1','177','257902','408',664.00,736.00,0.00,951.55,631829.20,700340.80,68511.60,730018),('1','177','257903','408',664.00,736.00,0.00,818.06,543191.84,602092.16,58900.32,730019),('1','177','257904','408',664.00,736.00,0.00,1879.29,1247848.56,1383157.44,135308.88,730020),('1','177','257905','408',664.00,736.00,0.00,1754.82,1165200.48,1291547.52,126347.04,730021),('1','177','257906','408',664.00,736.00,0.00,905.28,601105.92,666286.08,65180.16,730022),('1','177','257907','408',664.00,736.00,0.00,734.08,487429.12,540282.88,52853.76,730023),('1','177','257908','408',664.00,736.00,0.00,1592.48,1057406.72,1172065.28,114658.56,730024),('1','177','257909','408',664.00,736.00,0.00,1894.17,1257728.88,1394109.12,136380.24,730025),('1','177','257910','408',664.00,736.00,0.00,1039.27,690075.28,764902.72,74827.44,730026),('1','177','257911','408',664.00,736.00,0.00,330.49,219445.36,243240.64,23795.28,730027),('1','177','257912','408',664.00,736.00,0.00,1839.19,1221222.16,1353643.84,132421.68,730028),('1','177','257913','408',664.00,736.00,0.00,2143.84,1423509.76,1577866.24,154356.48,730029),('1','177','257914','408',664.00,736.00,0.00,821.68,545595.52,604756.48,59160.96,730030),('1','177','257915','408',664.00,736.00,0.00,828.89,550382.96,610063.04,59680.08,730031),('1','177','257916','408',664.00,736.00,0.00,2171.15,1441643.60,1597966.40,156322.80,730032),('1','177','257917','408',664.00,736.00,0.00,1785.71,1185711.44,1314282.56,128571.12,730033),('1','177','257918','408',664.00,736.00,0.00,327.78,217645.92,241246.08,23600.16,730034),('1','177','257919','408',664.00,736.00,0.00,1428.94,948816.16,1051699.84,102883.68,730035),('1','177','257920','408',664.00,736.00,0.00,1802.27,1196707.28,1326470.72,129763.44,730036),('1','177','257921','408',664.00,736.00,0.00,1900.09,1261659.76,1398466.24,136806.48,730037),('1','177','257922','408',664.00,736.00,0.00,889.99,590953.36,656296.64,65343.28,730038),('1','177','257923','408',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730039),('1','177','257924','408',664.00,736.00,0.00,861.24,571863.36,633872.64,62009.28,730040),('1','177','257925','408',664.00,736.00,0.00,1596.02,1059757.28,1174670.72,114913.44,730041),('1','177','257926','408',664.00,736.00,0.00,1725.27,1145579.28,1269798.72,124219.44,730042),('1','177','257927','408',664.00,736.00,0.00,1295.82,860424.48,953723.52,93299.04,730043),('1','177','257928','408',664.00,736.00,0.00,0.00,0.00,0.00,0.00,730044),('1','177','257929','408',664.00,736.00,0.00,371.74,246835.36,273600.64,26765.28,730045),('1','177','257930','408',664.00,736.00,0.00,2038.34,1353457.76,1500982.24,147524.48,730046),('1','177','257931','408',664.00,736.00,0.00,2203.46,1463097.44,1621746.56,158649.12,730047),('1','177','257932','408',664.00,736.00,0.00,462.06,306807.84,340076.16,33268.32,730048),('1','177','257933','408',664.00,736.00,0.00,1901.28,1262449.92,1399342.08,136892.16,730049),('1','177','257934','408',664.00,736.00,0.00,2408.61,1599317.04,1772736.96,173419.92,730050),('1','177','257935','408',664.00,736.00,0.00,889.95,590926.80,655003.20,64076.40,730051),('1','177','257936','408',664.00,736.00,0.00,1497.64,994432.96,1102263.04,107830.08,730052),('1','177','257937','408',664.00,736.00,0.00,1761.10,1169370.40,1296169.60,126799.20,730053),('1','177','257938','408',664.00,736.00,0.00,1901.82,1262808.48,1401303.52,138495.04,730054),('1','177','257939','408',664.00,736.00,0.00,528.39,345774.24,388895.04,43120.80,730055),('1','177','257940','408',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730056),('1','177','257941','408',640.00,736.00,0.00,1727.04,1105305.60,1271101.44,165795.84,730057),('1','177','257942','408',640.00,736.00,0.00,1992.88,1275443.20,1466759.68,191316.48,730058),('1','177','257943','408',640.00,736.00,0.00,1667.41,1067142.40,1227213.76,160071.36,730059),('1','177','257944','408',640.00,736.00,0.00,0.00,0.00,0.00,0.00,730060),('1','177','257945','408',640.00,736.00,0.00,288.74,184793.60,212512.64,27719.04,730061),('1','177','257946','408',640.00,736.00,0.00,1934.49,1238073.60,1423784.64,185711.04,730062),('1','177','257947','408',640.00,736.00,0.00,2036.07,1303084.80,1498547.52,195462.72,730063),('1','177','257948','408',640.00,736.00,0.00,1099.45,703648.00,810659.20,107011.20,730064),('1','177','257949','408',640.00,736.00,0.00,958.40,613376.00,705382.40,92006.40,730065),('1','177','257950','408',640.00,736.00,0.00,1941.53,1242579.20,1428966.08,186386.88,730066),('1','177','257951','408',640.00,736.00,0.00,2075.04,1328025.60,1527229.44,199203.84,730067),('1','177','257952','408',640.00,736.00,0.00,267.04,170905.60,196541.44,25635.84,730068),('1','177','257953','408',640.00,736.00,0.00,1516.47,970540.80,1116121.92,145581.12,730069),('1','177','257954','408',640.00,736.00,0.00,1891.62,1210636.80,1392232.32,181595.52,730070),('1','177','257955','408',640.00,736.00,0.00,1613.06,1032358.40,1187212.16,154853.76,730071),('1','177','257956','408',640.00,736.00,0.00,2177.73,1393747.20,1602809.28,209062.08,730072),('1','177','257957','408',640.00,736.00,0.00,1915.97,1226220.80,1410153.92,183933.12,730073),('1','177','257958','408',640.00,736.00,0.00,1285.64,822809.60,946231.04,123421.44,730074),('1','177','257959','408',640.00,736.00,0.00,685.44,438681.60,504483.84,65802.24,730075),('1','177','257960','408',640.00,736.00,0.00,1763.67,1128748.80,1298061.12,169312.32,730076),('1','177','257961','408',640.00,736.00,0.00,2829.86,1811110.40,2082776.96,271666.56,730077),('1','177','257962','408',640.00,736.00,0.00,2250.91,1440582.40,1656669.76,216087.36,730078),('1','177','257963','408',640.00,736.00,0.00,2144.06,1372198.40,1578028.16,205829.76,730079),('1','177','257964','408',640.00,736.00,0.00,706.76,452326.40,520175.36,67848.96,730080),('1','177','257965','408',640.00,736.00,0.00,1239.44,793241.60,912227.84,118986.24,730081),('1','177','257966','408',640.00,736.00,0.00,1624.27,1039532.80,1195462.72,155929.92,730082),('1','177','257967','408',640.00,736.00,0.00,2601.74,1665113.60,1914880.64,249767.04,730083),('1','177','257968','408',640.00,736.00,0.00,2238.92,1432908.80,1647845.12,214936.32,730084),('1','177','257969','408',640.00,736.00,0.00,2135.31,1366598.40,1571588.16,204989.76,730085),('1','177','257970','408',640.00,736.00,0.00,1371.22,877580.80,1009217.92,131637.12,730086),('1','177','257971','408',640.00,736.00,0.00,510.45,326688.00,375691.20,49003.20,730087),('1','177','257972','408',640.00,736.00,0.00,2588.82,1656844.80,1905371.52,248526.72,730088),('1','177','257973','408',640.00,736.00,0.00,1968.03,1259539.20,1448470.08,188930.88,730089),('1','177','257974','408',640.00,736.00,0.00,1972.48,1262387.20,1451745.28,189358.08,730090),('1','177','257975','408',640.00,736.00,0.00,2102.00,1345280.00,1547072.00,201792.00,730091),('1','177','257976','408',640.00,736.00,0.00,1094.02,700172.80,805198.72,105025.92,730092),('1','177','257977','408',640.00,736.00,0.00,1680.88,1075763.20,1237127.68,161364.48,730093),('1','177','257978','408',640.00,736.00,0.00,2556.17,1635948.80,1881341.12,245392.32,730094),('1','177','257979','408',640.00,736.00,0.00,737.53,472019.20,542822.08,70802.88,730095),('1','177','257980','408',640.00,736.00,0.00,1297.89,830649.60,955247.04,124597.44,730096),('1','177','257981','408',640.00,736.00,0.00,484.94,310361.60,356915.84,46554.24,730097),('1','177','257982','408',640.00,700.00,0.00,320.90,205376.00,224630.00,19254.00,730098),('1','177','257983','408',640.00,700.00,0.00,1872.01,1198086.40,1310407.00,112320.60,730099),('1','177','257984','408',640.00,700.00,0.00,1257.85,805024.00,880495.00,75471.00,730100),('1','177','257985','408',640.00,700.00,0.00,357.25,228640.00,250075.00,21435.00,730101),('1','177','257986','408',640.00,700.00,0.00,2003.56,1282278.40,1402492.00,120213.60,730102),('1','177','257987','408',640.00,700.00,0.00,2312.23,1479827.20,1618561.00,138733.80,730103),('1','177','257988','408',640.00,700.00,0.00,425.85,272544.00,298095.00,25551.00,730104),('1','177','257989','408',640.00,700.00,0.00,1252.07,801324.80,876644.48,75319.68,730105),('1','177','257990','408',640.00,700.00,0.00,1593.22,1019660.80,1115254.00,95593.20,730106);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=372 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('1',371,'177','PRODUCT TANKS','TANK CONTAINING LPG PRODUCT.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=920 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('1','177','371',919,1,'408','LPG TANK',6000.00,1.00,922.98,'TANK CONTAINING LPG PRODUCT.','479','2021-03-18 15:48:16','2021-03-18 15:48:16','479',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'1','177',919,2304.71,'2023-03-20 21:04:26');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2726921 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2107784,'1','177','919',408,'Retail Sale Id 1253915',12480.00,0.00,0.00,0.00,440.00,'2021-12-01 05:42:50','',''),(2107785,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 05:42:50','',''),(2107861,'1','177','919',408,'Retail Sale Id 1253955',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 06:00:40','',''),(2107862,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:00:40','',''),(2107887,'1','177','919',408,'Retail Sale Id 1253965',4368.00,0.00,0.00,0.00,154.00,'2021-12-01 06:03:14','',''),(2107888,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-01 06:03:14','',''),(2107893,'1','177','919',408,'Retail Sale Id 1253967',4992.00,0.00,0.00,0.00,176.00,'2021-12-01 06:03:50','',''),(2107894,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-01 06:03:50','',''),(2107920,'1','177','919',408,'Retail Sale Id 1253980',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 06:05:54','',''),(2107921,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:05:54','',''),(2108141,'1','177','919',408,'Retail Sale Id 1254092',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 06:27:15','',''),(2108142,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:27:15','',''),(2108371,'1','177','919',408,'Retail Sale Id 1254203',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 06:43:40','',''),(2108372,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 06:43:40','',''),(2108403,'1','177','919',408,'Retail Sale Id 1254221',998.40,0.00,0.00,0.00,35.20,'2021-12-01 06:46:43','',''),(2108404,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 06:46:43','',''),(2108416,'1','177','919',408,'Retail Sale Id 1254227',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 06:47:44','',''),(2108417,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 06:47:44','',''),(2108705,'1','177','919',408,'Retail Sale Id 1254359',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 07:01:10','',''),(2108706,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:01:10','',''),(2108733,'1','177','919',408,'Retail Sale Id 1254371',7176.00,0.00,0.00,0.00,253.00,'2021-12-01 07:02:51','',''),(2108734,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-01 07:02:51','',''),(2108835,'1','177','919',408,'Retail Sale Id 1254414',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 07:08:24','',''),(2108836,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 07:08:24','',''),(2109826,'1','177','919',408,'Retail Sale Id 1254850',3120.00,0.00,0.00,0.00,110.00,'2021-12-01 07:52:48','',''),(2109827,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 07:52:48','',''),(2109918,'1','177','919',408,'Retail Sale Id 1254900',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 07:57:36','',''),(2109919,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:57:36','',''),(2109947,'1','177','919',408,'Retail Sale Id 1254915',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 07:59:22','',''),(2109948,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 07:59:22','',''),(2110106,'1','177','919',408,'Retail Sale Id 1254989',1248.00,0.00,0.00,0.00,44.00,'2021-12-01 08:07:47','',''),(2110107,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 08:07:47','',''),(2110178,'1','177','919',408,'Retail Sale Id 1255025',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 08:12:36','',''),(2110179,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 08:12:36','',''),(2110198,'1','177','919',408,'Retail Sale Id 1255034',998.40,0.00,0.00,0.00,35.20,'2021-12-01 08:13:29','',''),(2110199,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 08:13:29','',''),(2110296,'1','177','919',408,'Retail Sale Id 1255084',7001.28,0.00,0.00,0.00,246.84,'2021-12-01 08:18:25','',''),(2110297,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-01 08:18:25','',''),(2110308,'1','177','919',408,'Retail Sale Id 1255092',3001.44,0.00,0.00,0.00,105.82,'2021-12-01 08:19:29','',''),(2110309,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-01 08:19:29','',''),(2110334,'1','177','919',408,'Retail Sale Id 1255103',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 08:20:40','',''),(2110335,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:20:40','',''),(2110358,'1','177','919',408,'Retail Sale Id 1255116',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 08:21:44','',''),(2110359,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:21:44','',''),(2110378,'1','177','919',408,'Retail Sale Id 1255124',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 08:22:38','',''),(2110379,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 08:22:38','',''),(2110409,'1','177','919',408,'Retail Sale Id 1255141',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 08:25:18','',''),(2110410,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:25:18','',''),(2110455,'1','177','919',408,'Retail Sale Id 1255168',998.40,0.00,0.00,0.00,35.20,'2021-12-01 08:28:43','',''),(2110456,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 08:28:43','',''),(2110657,'1','177','919',408,'Retail Sale Id 1255257',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 08:40:28','',''),(2110658,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:40:28','',''),(2110704,'1','177','919',408,'Retail Sale Id 1255282',9360.00,0.00,0.00,0.00,330.00,'2021-12-01 08:42:27','',''),(2110705,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-01 08:42:27','',''),(2110738,'1','177','919',408,'Retail Sale Id 1255296',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 08:44:03','',''),(2110739,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:44:03','',''),(2110792,'1','177','919',408,'Retail Sale Id 1255328',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 08:47:22','',''),(2110793,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 08:47:22','',''),(2110936,'1','177','919',408,'Retail Sale Id 1255407',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 08:56:09','',''),(2110937,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 08:56:09','',''),(2110981,'1','177','919',408,'Retail Sale Id 1255432',998.40,0.00,0.00,0.00,35.20,'2021-12-01 08:59:14','',''),(2110982,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 08:59:14','',''),(2111020,'1','177','919',408,'Retail Sale Id 1255449',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 09:01:16','',''),(2111021,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:01:16','',''),(2111054,'1','177','919',408,'Retail Sale Id 1255469',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 09:03:19','',''),(2111055,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 09:03:19','',''),(2111168,'1','177','919',408,'Retail Sale Id 1255521',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 09:10:27','',''),(2111169,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 09:10:27','',''),(2111366,'1','177','919',408,'Retail Sale Id 1255634',4998.24,0.00,0.00,0.00,176.22,'2021-12-01 09:22:31','',''),(2111367,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-01 09:22:31','',''),(2111436,'1','177','919',408,'Retail Sale Id 1255667',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 09:26:13','',''),(2111437,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:26:13','',''),(2111488,'1','177','919',408,'Retail Sale Id 1255693',2496.00,0.00,0.00,0.00,88.00,'2021-12-01 09:29:16','',''),(2111489,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 09:29:16','',''),(2111535,'1','177','919',408,'Retail Sale Id 1255716',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 09:33:17','',''),(2111536,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 09:33:17','',''),(2111587,'1','177','919',408,'Retail Sale Id 1255746',998.40,0.00,0.00,0.00,35.20,'2021-12-01 09:36:33','',''),(2111588,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 09:36:33','',''),(2111825,'1','177','919',408,'Retail Sale Id 1255870',998.40,0.00,0.00,0.00,35.20,'2021-12-01 09:52:54','',''),(2111826,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 09:52:54','',''),(2111888,'1','177','919',408,'Retail Sale Id 1255902',4998.24,0.00,0.00,0.00,176.22,'2021-12-01 09:57:21','',''),(2111889,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-01 09:57:21','',''),(2112053,'1','177','919',408,'Retail Sale Id 1255977',6864.00,0.00,0.00,0.00,242.00,'2021-12-01 10:08:37','',''),(2112054,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-01 10:08:37','',''),(2112108,'1','177','919',408,'Retail Sale Id 1255996',15600.00,0.00,0.00,0.00,550.00,'2021-12-01 10:12:04','',''),(2112109,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 10:12:04','',''),(2112178,'1','177','919',408,'Retail Sale Id 1256045',998.40,0.00,0.00,0.00,35.20,'2021-12-01 10:16:07','',''),(2112179,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 10:16:07','',''),(2112325,'1','177','919',408,'Retail Sale Id 1256108',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 10:27:44','',''),(2112326,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 10:27:44','',''),(2112341,'1','177','919',408,'Retail Sale Id 1256116',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 10:28:47','',''),(2112342,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:28:47','',''),(2112437,'1','177','919',408,'Retail Sale Id 1256160',24960.00,0.00,0.00,0.00,880.00,'2021-12-01 10:36:02','',''),(2112438,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-01 10:36:02','',''),(2112465,'1','177','919',408,'Retail Sale Id 1256179',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 10:37:11','',''),(2112466,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 10:37:11','',''),(2112477,'1','177','919',408,'Retail Sale Id 1256185',12480.00,0.00,0.00,0.00,440.00,'2021-12-01 10:38:30','',''),(2112478,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 10:38:30','',''),(2112534,'1','177','919',408,'Retail Sale Id 1256213',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 10:44:03','',''),(2112535,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 10:44:03','',''),(2112550,'1','177','919',408,'Retail Sale Id 1256222',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 10:45:22','',''),(2112551,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 10:45:22','',''),(2112763,'1','177','919',408,'Retail Sale Id 1256333',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 11:04:12','',''),(2112764,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:04:12','',''),(2112858,'1','177','919',408,'Retail Sale Id 1256385',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 11:10:29','',''),(2112859,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 11:10:29','',''),(2112958,'1','177','919',408,'Retail Sale Id 1256422',7488.00,0.00,0.00,0.00,264.00,'2021-12-01 11:15:45','',''),(2112959,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-01 11:15:45','',''),(2113012,'1','177','919',408,'Retail Sale Id 1256446',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 11:18:28','',''),(2113013,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:18:28','',''),(2113044,'1','177','919',408,'Retail Sale Id 1256460',998.40,0.00,0.00,0.00,35.20,'2021-12-01 11:19:49','',''),(2113045,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 11:19:49','',''),(2113054,'1','177','919',408,'Retail Sale Id 1256466',1797.12,0.00,0.00,0.00,63.36,'2021-12-01 11:21:06','',''),(2113055,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-01 11:21:06','',''),(2113096,'1','177','919',408,'Retail Sale Id 1256490',1797.12,0.00,0.00,0.00,63.36,'2021-12-01 11:23:54','',''),(2113097,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-01 11:23:54','',''),(2113140,'1','177','919',408,'Retail Sale Id 1256505',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 11:26:12','',''),(2113141,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:26:12','',''),(2113198,'1','177','919',408,'Retail Sale Id 1256536',10801.44,0.00,0.00,0.00,380.82,'2021-12-01 11:29:53','',''),(2113199,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.31,0.00,'2021-12-01 11:29:53','',''),(2113220,'1','177','919',408,'Retail Sale Id 1256546',1248.00,0.00,0.00,0.00,44.00,'2021-12-01 11:31:22','',''),(2113221,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 11:31:22','',''),(2113242,'1','177','919',408,'Retail Sale Id 1256561',998.40,0.00,0.00,0.00,35.20,'2021-12-01 11:34:03','',''),(2113243,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 11:34:03','',''),(2113357,'1','177','919',408,'Retail Sale Id 1256622',6240.00,0.00,0.00,0.00,220.00,'2021-12-01 11:42:02','',''),(2113358,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 11:42:02','',''),(2113439,'1','177','919',408,'Retail Sale Id 1256659',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 11:48:27','',''),(2113440,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 11:48:27','',''),(2113587,'1','177','919',408,'Retail Sale Id 1256745',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 12:01:09','',''),(2113588,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 12:01:09','',''),(2113889,'1','177','919',408,'Retail Sale Id 1256900',15600.00,0.00,0.00,0.00,550.00,'2021-12-01 12:24:47','',''),(2113890,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 12:24:47','',''),(2113907,'1','177','919',408,'Retail Sale Id 1256910',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 12:26:22','',''),(2113908,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:26:22','',''),(2113935,'1','177','919',408,'Retail Sale Id 1256923',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 12:28:17','',''),(2113936,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 12:28:17','',''),(2114021,'1','177','919',408,'Retail Sale Id 1256967',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 12:35:42','',''),(2114022,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 12:35:42','',''),(2114063,'1','177','919',408,'Retail Sale Id 1256987',998.40,0.00,0.00,0.00,35.20,'2021-12-01 12:40:53','',''),(2114064,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 12:40:53','',''),(2114140,'1','177','919',408,'Retail Sale Id 1257023',3001.44,0.00,0.00,0.00,105.82,'2021-12-01 12:49:35','',''),(2114141,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-01 12:49:35','',''),(2114274,'1','177','919',408,'Retail Sale Id 1257095',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 13:03:06','',''),(2114275,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:03:06','',''),(2114570,'1','177','919',408,'Retail Sale Id 1257281',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 13:23:06','',''),(2114571,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:23:06','',''),(2114580,'1','177','919',408,'Retail Sale Id 1257286',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 13:23:48','',''),(2114581,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 13:23:48','',''),(2114613,'1','177','919',408,'Retail Sale Id 1257297',998.40,0.00,0.00,0.00,35.20,'2021-12-01 13:26:06','',''),(2114614,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 13:26:06','',''),(2114621,'1','177','919',408,'Retail Sale Id 1257302',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 13:27:03','',''),(2114622,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 13:27:03','',''),(2114667,'1','177','919',408,'Retail Sale Id 1257324',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 13:31:19','',''),(2114668,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 13:31:19','',''),(2114820,'1','177','919',408,'Retail Sale Id 1257375',998.40,0.00,0.00,0.00,35.20,'2021-12-01 13:40:33','',''),(2114821,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 13:40:33','',''),(2115039,'1','177','919',408,'Retail Sale Id 1257450',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 13:52:25','',''),(2115040,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 13:52:25','',''),(2115461,'1','177','919',408,'Retail Sale Id 1257669',11544.00,0.00,0.00,0.00,407.00,'2021-12-01 14:17:26','',''),(2115462,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-01 14:17:26','',''),(2115528,'1','177','919',408,'Retail Sale Id 1257700',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 14:21:52','',''),(2115529,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 14:21:52','',''),(2115542,'1','177','919',408,'Retail Sale Id 1257706',6002.88,0.00,0.00,0.00,211.64,'2021-12-01 14:22:54','',''),(2115543,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-01 14:22:54','',''),(2115722,'1','177','919',408,'Retail Sale Id 1257803',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 14:35:52','',''),(2115723,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 14:35:52','',''),(2115762,'1','177','919',408,'Retail Sale Id 1257824',15000.96,0.00,0.00,0.00,528.88,'2021-12-01 14:38:30','',''),(2115763,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.04,0.00,'2021-12-01 14:38:30','',''),(2115803,'1','177','919',408,'Retail Sale Id 1257843',6302.40,0.00,0.00,0.00,222.20,'2021-12-01 14:42:03','',''),(2115804,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.10,0.00,'2021-12-01 14:42:03','',''),(2115815,'1','177','919',408,'Retail Sale Id 1257850',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 14:43:28','',''),(2115816,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 14:43:28','',''),(2116062,'1','177','919',408,'Retail Sale Id 1257938',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 14:56:40','',''),(2116063,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 14:56:40','',''),(2116076,'1','177','919',408,'Retail Sale Id 1257946',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 14:58:01','',''),(2116077,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:58:01','',''),(2116098,'1','177','919',408,'Retail Sale Id 1257957',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 14:59:11','',''),(2116099,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 14:59:11','',''),(2116144,'1','177','919',408,'Retail Sale Id 1257976',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 15:03:02','',''),(2116145,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:03:02','',''),(2116211,'1','177','919',408,'Retail Sale Id 1258014',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 15:08:31','',''),(2116212,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 15:08:31','',''),(2116330,'1','177','919',408,'Retail Sale Id 1258074',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 15:16:17','',''),(2116331,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 15:16:17','',''),(2116382,'1','177','919',408,'Retail Sale Id 1258099',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 15:20:01','',''),(2116383,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:20:01','',''),(2116454,'1','177','919',408,'Retail Sale Id 1258131',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 15:23:53','',''),(2116455,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:23:53','',''),(2116479,'1','177','919',408,'Retail Sale Id 1258140',15600.00,0.00,0.00,0.00,550.00,'2021-12-01 15:25:00','',''),(2116480,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-01 15:25:00','',''),(2116573,'1','177','919',408,'Retail Sale Id 1258185',3120.00,0.00,0.00,0.00,110.00,'2021-12-01 15:31:27','',''),(2116574,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 15:31:27','',''),(2116622,'1','177','919',408,'Retail Sale Id 1258213',3001.44,0.00,0.00,0.00,105.82,'2021-12-01 15:35:11','',''),(2116623,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-01 15:35:11','',''),(2116648,'1','177','919',408,'Retail Sale Id 1258228',998.40,0.00,0.00,0.00,35.20,'2021-12-01 15:36:49','',''),(2116649,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 15:36:49','',''),(2116814,'1','177','919',408,'Retail Sale Id 1258299',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 15:46:06','',''),(2116815,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:46:06','',''),(2116848,'1','177','919',408,'Retail Sale Id 1258319',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 15:47:30','',''),(2116849,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 15:47:30','',''),(2116874,'1','177','919',408,'Retail Sale Id 1258333',2502.24,0.00,0.00,0.00,88.22,'2021-12-01 15:48:53','',''),(2116875,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-01 15:48:53','',''),(2116911,'1','177','919',408,'Retail Sale Id 1258351',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 15:50:19','',''),(2116912,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 15:50:19','',''),(2116944,'1','177','919',408,'Retail Sale Id 1258364',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 15:51:24','',''),(2116945,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 15:51:24','',''),(2117287,'1','177','919',408,'Retail Sale Id 1258531',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 16:06:08','',''),(2117288,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:06:08','',''),(2117324,'1','177','919',408,'Retail Sale Id 1258546',3120.00,0.00,0.00,0.00,110.00,'2021-12-01 16:07:23','',''),(2117325,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:07:23','',''),(2117440,'1','177','919',408,'Retail Sale Id 1258588',3001.44,0.00,0.00,0.00,105.82,'2021-12-01 16:12:09','',''),(2117441,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-01 16:12:09','',''),(2117670,'1','177','919',408,'Retail Sale Id 1258698',998.40,0.00,0.00,0.00,35.20,'2021-12-01 16:21:17','',''),(2117671,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 16:21:17','',''),(2117702,'1','177','919',408,'Retail Sale Id 1258715',1797.12,0.00,0.00,0.00,63.36,'2021-12-01 16:22:28','',''),(2117703,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-01 16:22:28','',''),(2117730,'1','177','919',408,'Retail Sale Id 1258735',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 16:23:41','',''),(2117731,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:23:41','',''),(2117760,'1','177','919',408,'Retail Sale Id 1258749',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 16:25:15','',''),(2117761,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 16:25:16','',''),(2117788,'1','177','919',408,'Retail Sale Id 1258769',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 16:26:31','',''),(2117789,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 16:26:31','',''),(2117810,'1','177','919',408,'Retail Sale Id 1258789',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 16:27:36','',''),(2117811,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 16:27:36','',''),(2117832,'1','177','919',408,'Retail Sale Id 1258801',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 16:28:51','',''),(2117833,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:28:51','',''),(2117864,'1','177','919',408,'Retail Sale Id 1258814',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 16:30:04','',''),(2117865,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:30:04','',''),(2117892,'1','177','919',408,'Retail Sale Id 1258825',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 16:31:40','',''),(2117893,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:31:41','',''),(2117912,'1','177','919',408,'Retail Sale Id 1258840',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 16:32:38','',''),(2117913,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 16:32:38','',''),(2117950,'1','177','919',408,'Retail Sale Id 1258863',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 16:34:38','',''),(2117951,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 16:34:38','',''),(2118060,'1','177','919',408,'Retail Sale Id 1258918',3120.00,0.00,0.00,0.00,110.00,'2021-12-01 16:39:52','',''),(2118061,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 16:39:52','',''),(2118094,'1','177','919',408,'Retail Sale Id 1258940',624.00,0.00,0.00,0.00,22.00,'2021-12-01 16:41:15','',''),(2118095,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-01 16:41:15','',''),(2118140,'1','177','919',408,'Retail Sale Id 1258964',1497.60,0.00,0.00,0.00,52.80,'2021-12-01 16:43:59','',''),(2118141,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-01 16:43:59','',''),(2118164,'1','177','919',408,'Retail Sale Id 1258977',3900.00,0.00,0.00,0.00,137.50,'2021-12-01 16:45:09','',''),(2118165,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-01 16:45:09','',''),(2118230,'1','177','919',408,'Retail Sale Id 1259011',998.40,0.00,0.00,0.00,35.20,'2021-12-01 16:48:25','',''),(2118231,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 16:48:25','',''),(2118252,'1','177','919',408,'Retail Sale Id 1259021',1248.00,0.00,0.00,0.00,44.00,'2021-12-01 16:49:39','',''),(2118253,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 16:49:39','',''),(2118272,'1','177','919',408,'Retail Sale Id 1259033',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 16:50:41','',''),(2118273,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 16:50:41','',''),(2118300,'1','177','919',408,'Retail Sale Id 1259047',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 16:52:00','',''),(2118301,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 16:52:00','',''),(2118328,'1','177','919',408,'Retail Sale Id 1259061',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 16:53:18','',''),(2118329,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:53:18','',''),(2118373,'1','177','919',408,'Retail Sale Id 1259077',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 16:54:38','',''),(2118374,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 16:54:38','',''),(2118405,'1','177','919',408,'Retail Sale Id 1259094',6240.00,0.00,0.00,0.00,220.00,'2021-12-01 16:55:49','',''),(2118406,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 16:55:49','',''),(2118432,'1','177','919',408,'Retail Sale Id 1259107',2502.24,0.00,0.00,0.00,88.22,'2021-12-01 16:57:07','',''),(2118433,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-01 16:57:07','',''),(2118494,'1','177','919',408,'Retail Sale Id 1259141',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 16:59:46','',''),(2118495,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 16:59:46','',''),(2118546,'1','177','919',408,'Retail Sale Id 1259167',998.40,0.00,0.00,0.00,35.20,'2021-12-01 17:01:57','',''),(2118547,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-01 17:01:57','',''),(2118568,'1','177','919',408,'Retail Sale Id 1259180',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 17:02:52','',''),(2118569,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:02:52','',''),(2118588,'1','177','919',408,'Retail Sale Id 1259187',1248.00,0.00,0.00,0.00,44.00,'2021-12-01 17:04:08','',''),(2118589,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:04:08','',''),(2118622,'1','177','919',408,'Retail Sale Id 1259199',3120.00,0.00,0.00,0.00,110.00,'2021-12-01 17:05:48','',''),(2118623,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-01 17:05:48','',''),(2118648,'1','177','919',408,'Retail Sale Id 1259213',1248.00,0.00,0.00,0.00,44.00,'2021-12-01 17:07:02','',''),(2118649,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-01 17:07:02','',''),(2118900,'1','177','919',408,'Retail Sale Id 1259345',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 17:21:43','',''),(2118901,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 17:21:43','',''),(2118957,'1','177','919',408,'Retail Sale Id 1259371',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 17:26:10','',''),(2118958,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 17:26:10','',''),(2119021,'1','177','919',408,'Retail Sale Id 1259384',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 17:30:18','',''),(2119022,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:30:18','',''),(2119059,'1','177','919',408,'Retail Sale Id 1259420',2003.04,0.00,0.00,0.00,70.62,'2021-12-01 17:32:35','',''),(2119060,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-01 17:32:35','',''),(2119123,'1','177','919',408,'Retail Sale Id 1259436',21840.00,0.00,0.00,0.00,770.00,'2021-12-01 17:37:54','',''),(2119124,'1','177','919',408,'Retail sales',0.00,0.00,0.00,35.00,0.00,'2021-12-01 17:37:54','',''),(2119149,'1','177','919',408,'Retail Sale Id 1259467',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 17:39:33','',''),(2119150,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:39:33','',''),(2119173,'1','177','919',408,'Retail Sale Id 1259478',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 17:41:18','',''),(2119174,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 17:41:18','',''),(2119199,'1','177','919',408,'Retail Sale Id 1259493',6240.00,0.00,0.00,0.00,220.00,'2021-12-01 17:43:14','',''),(2119200,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 17:43:14','',''),(2119242,'1','177','919',408,'Retail Sale Id 1259512',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 17:46:21','',''),(2119243,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 17:46:21','',''),(2119266,'1','177','919',408,'Retail Sale Id 1259523',2496.00,0.00,0.00,0.00,88.00,'2021-12-01 17:49:00','',''),(2119267,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-01 17:49:00','',''),(2119298,'1','177','919',408,'Retail Sale Id 1259536',6240.00,0.00,0.00,0.00,220.00,'2021-12-01 17:53:16','',''),(2119299,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-01 17:53:16','',''),(2119321,'1','177','919',408,'Retail Sale Id 1259552',4499.04,0.00,0.00,0.00,158.62,'2021-12-01 17:56:05','',''),(2119322,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-01 17:56:05','',''),(2119341,'1','177','919',408,'Retail Sale Id 1259562',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 17:58:37','',''),(2119342,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 17:58:37','',''),(2119581,'1','177','919',408,'Retail Sale Id 1259678',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 18:31:36','',''),(2119582,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 18:31:36','',''),(2119656,'1','177','919',408,'Retail Sale Id 1259706',12480.00,0.00,0.00,0.00,440.00,'2021-12-01 18:43:47','',''),(2119657,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-01 18:43:47','',''),(2119676,'1','177','919',408,'Retail Sale Id 1259716',7800.00,0.00,0.00,0.00,275.00,'2021-12-01 18:46:56','',''),(2119677,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-01 18:46:56','',''),(2119688,'1','177','919',408,'Retail Sale Id 1259722',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 18:49:33','',''),(2119689,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 18:49:33','',''),(2119696,'1','177','919',408,'Retail Sale Id 1259726',3744.00,0.00,0.00,0.00,132.00,'2021-12-01 18:50:46','',''),(2119697,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-01 18:50:46','',''),(2119712,'1','177','919',408,'Retail Sale Id 1259734',1872.00,0.00,0.00,0.00,66.00,'2021-12-01 18:53:45','',''),(2119713,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-01 18:53:45','',''),(2119775,'1','177','919',408,'Return of Retail Sale Id 1259706',0.00,12480.00,20.00,0.00,-440.00,'2021-12-01 19:12:24','',''),(2119776,'1','177','919',408,'Retail Sale Id 1259753',8530.08,0.00,0.00,0.00,300.74,'2021-12-01 19:13:13','',''),(2119777,'1','177','919',408,'Retail sales',0.00,0.00,0.00,13.67,0.00,'2021-12-01 19:13:13','',''),(2120266,'1','177','919',408,'Retail Sale Id 1259787',23400.00,0.00,0.00,0.00,825.00,'2021-12-02 05:44:57','',''),(2120267,'1','177','919',408,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-02 05:44:57','',''),(2120361,'1','177','919',408,'Retail Sale Id 1259834',2502.24,0.00,0.00,0.00,88.22,'2021-12-02 06:02:11','',''),(2120362,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-02 06:02:11','',''),(2120383,'1','177','919',408,'Retail Sale Id 1259842',3001.44,0.00,0.00,0.00,105.82,'2021-12-02 06:03:42','',''),(2120384,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-02 06:03:42','',''),(2120419,'1','177','919',408,'Retail Sale Id 1259865',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 06:06:22','',''),(2120420,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 06:06:22','',''),(2120923,'1','177','919',408,'Retail Sale Id 1260082',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 06:41:08','',''),(2120924,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 06:41:08','',''),(2121326,'1','177','919',408,'Retail Sale Id 1260259',1248.00,0.00,0.00,0.00,44.00,'2021-12-02 07:04:00','',''),(2121327,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 07:04:00','',''),(2121362,'1','177','919',408,'Retail Sale Id 1260278',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 07:05:37','',''),(2121363,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:05:37','',''),(2121392,'1','177','919',408,'Retail Sale Id 1260292',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 07:07:09','',''),(2121393,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:07:09','',''),(2121410,'1','177','919',408,'Retail Sale Id 1260306',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 07:08:35','',''),(2121411,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:08:35','',''),(2121502,'1','177','919',408,'Retail Sale Id 1260329',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 07:11:40','',''),(2121503,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 07:11:40','',''),(2121518,'1','177','919',408,'Retail Sale Id 1260337',998.40,0.00,0.00,0.00,35.20,'2021-12-02 07:12:33','',''),(2121519,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 07:12:33','',''),(2121556,'1','177','919',408,'Retail Sale Id 1260357',31150.08,0.00,0.00,0.00,1098.24,'2021-12-02 07:14:45','',''),(2121557,'1','177','919',408,'Retail sales',0.00,0.00,0.00,49.92,0.00,'2021-12-02 07:14:45','',''),(2121611,'1','177','919',408,'Retail Sale Id 1260386',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 07:17:31','',''),(2121612,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:17:31','',''),(2121671,'1','177','919',408,'Retail Sale Id 1260412',5616.00,0.00,0.00,0.00,198.00,'2021-12-02 07:20:25','',''),(2121672,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-02 07:20:25','',''),(2121713,'1','177','919',408,'Retail Sale Id 1260429',6240.00,0.00,0.00,0.00,220.00,'2021-12-02 07:22:27','',''),(2121714,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 07:22:27','',''),(2121863,'1','177','919',408,'Retail Sale Id 1260512',3500.64,0.00,0.00,0.00,123.42,'2021-12-02 07:30:09','',''),(2121864,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-02 07:30:09','',''),(2121983,'1','177','919',408,'Retail Sale Id 1260592',499.20,0.00,0.00,0.00,17.60,'2021-12-02 07:37:33','',''),(2121984,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-02 07:37:33','',''),(2122029,'1','177','919',408,'Retail Sale Id 1260611',3999.84,0.00,0.00,0.00,141.02,'2021-12-02 07:39:08','',''),(2122030,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-02 07:39:08','',''),(2122064,'1','177','919',408,'Retail Sale Id 1260631',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 07:40:40','',''),(2122065,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:40:40','',''),(2122145,'1','177','919',408,'Retail Sale Id 1260672',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 07:44:16','',''),(2122146,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:44:16','',''),(2122213,'1','177','919',408,'Retail Sale Id 1260707',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 07:47:49','',''),(2122214,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 07:47:49','',''),(2122309,'1','177','919',408,'Retail Sale Id 1260745',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 07:50:42','',''),(2122310,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 07:50:42','',''),(2122555,'1','177','919',408,'Retail Sale Id 1260851',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 07:59:46','',''),(2122556,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 07:59:46','',''),(2122737,'1','177','919',408,'Retail Sale Id 1260940',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 08:08:26','',''),(2122738,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:08:26','',''),(2122932,'1','177','919',408,'Retail Sale Id 1261044',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 08:19:24','',''),(2122933,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 08:19:24','',''),(2122950,'1','177','919',408,'Retail Sale Id 1261054',7001.28,0.00,0.00,0.00,246.84,'2021-12-02 08:20:12','',''),(2122951,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-02 08:20:12','',''),(2123171,'1','177','919',408,'Retail Sale Id 1261163',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 08:31:28','',''),(2123172,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 08:31:28','',''),(2123617,'1','177','919',408,'Retail Sale Id 1261367',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 08:55:08','',''),(2123618,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 08:55:08','',''),(2123673,'1','177','919',408,'Retail Sale Id 1261396',17160.00,0.00,0.00,0.00,605.00,'2021-12-02 08:57:50','',''),(2123674,'1','177','919',408,'Retail sales',0.00,0.00,0.00,27.50,0.00,'2021-12-02 08:57:50','',''),(2123745,'1','177','919',408,'Retail Sale Id 1261430',3001.44,0.00,0.00,0.00,105.82,'2021-12-02 09:01:13','',''),(2123746,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-02 09:01:13','',''),(2123790,'1','177','919',408,'Retail Sale Id 1261466',6002.88,0.00,0.00,0.00,211.64,'2021-12-02 09:04:05','',''),(2123791,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-02 09:04:05','',''),(2123915,'1','177','919',408,'Retail Sale Id 1261532',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 09:09:57','',''),(2123916,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:09:57','',''),(2124198,'1','177','919',408,'Retail Sale Id 1261651',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 09:22:42','',''),(2124199,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:22:42','',''),(2124220,'1','177','919',408,'Retail Sale Id 1261665',3001.44,0.00,0.00,0.00,105.82,'2021-12-02 09:24:04','',''),(2124221,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-02 09:24:04','',''),(2124258,'1','177','919',408,'Retail Sale Id 1261681',7001.28,0.00,0.00,0.00,246.84,'2021-12-02 09:26:01','',''),(2124259,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-02 09:26:01','',''),(2124553,'1','177','919',408,'Retail Sale Id 1261827',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 09:44:45','',''),(2124554,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 09:44:45','',''),(2124610,'1','177','919',408,'Retail Sale Id 1261853',7001.28,0.00,0.00,0.00,246.84,'2021-12-02 09:48:12','',''),(2124611,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-02 09:48:12','',''),(2124717,'1','177','919',408,'Retail Sale Id 1261918',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 09:52:46','',''),(2124718,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 09:52:46','',''),(2124772,'1','177','919',408,'Retail Sale Id 1261941',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 09:55:36','',''),(2124773,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 09:55:36','',''),(2124791,'1','177','919',408,'Retail Sale Id 1261957',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 09:56:44','',''),(2124792,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 09:56:44','',''),(2124821,'1','177','919',408,'Retail Sale Id 1261972',998.40,0.00,0.00,0.00,35.20,'2021-12-02 09:57:58','',''),(2124822,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 09:57:58','',''),(2125448,'1','177','919',408,'Retail Sale Id 1262281',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 10:34:27','',''),(2125449,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 10:34:27','',''),(2125518,'1','177','919',408,'Retail Sale Id 1262322',10002.72,0.00,0.00,0.00,352.66,'2021-12-02 10:38:33','',''),(2125519,'1','177','919',408,'Retail sales',0.00,0.00,0.00,16.03,0.00,'2021-12-02 10:38:33','',''),(2125554,'1','177','919',408,'Retail Sale Id 1262334',4499.04,0.00,0.00,0.00,158.62,'2021-12-02 10:40:52','',''),(2125555,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-02 10:40:52','',''),(2125578,'1','177','919',408,'Retail Sale Id 1262348',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 10:42:13','',''),(2125579,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 10:42:13','',''),(2125610,'1','177','919',408,'Retail Sale Id 1262363',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 10:43:52','',''),(2125611,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 10:43:52','',''),(2125720,'1','177','919',408,'Retail Sale Id 1262402',3500.64,0.00,0.00,0.00,123.42,'2021-12-02 10:50:56','',''),(2125721,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-02 10:50:56','',''),(2126000,'1','177','919',408,'Retail Sale Id 1262563',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 11:09:34','',''),(2126001,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:09:34','',''),(2126082,'1','177','919',408,'Retail Sale Id 1262608',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 11:14:35','',''),(2126083,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 11:14:35','',''),(2126443,'1','177','919',408,'Retail Sale Id 1262788',998.40,0.00,0.00,0.00,35.20,'2021-12-02 11:33:27','',''),(2126444,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 11:33:27','',''),(2126749,'1','177','919',408,'Retail Sale Id 1262924',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 11:52:38','',''),(2126750,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 11:52:38','',''),(2126791,'1','177','919',408,'Retail Sale Id 1262949',998.40,0.00,0.00,0.00,35.20,'2021-12-02 11:55:46','',''),(2126792,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 11:55:46','',''),(2126899,'1','177','919',408,'Retail Sale Id 1263003',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 12:05:10','',''),(2126900,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:05:10','',''),(2126972,'1','177','919',408,'Retail Sale Id 1263039',3001.44,0.00,0.00,0.00,105.82,'2021-12-02 12:11:34','',''),(2126973,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-02 12:11:34','',''),(2127042,'1','177','919',408,'Retail Sale Id 1263074',1497.60,0.00,0.00,0.00,52.80,'2021-12-02 12:19:13','',''),(2127043,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-02 12:19:13','',''),(2127106,'1','177','919',408,'Retail Sale Id 1263108',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 12:23:26','',''),(2127107,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:23:26','',''),(2127166,'1','177','919',408,'Retail Sale Id 1263139',1797.12,0.00,0.00,0.00,63.36,'2021-12-02 12:27:16','',''),(2127167,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-02 12:27:16','',''),(2127220,'1','177','919',408,'Retail Sale Id 1263183',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 12:31:31','',''),(2127221,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 12:31:31','',''),(2127294,'1','177','919',408,'Retail Sale Id 1263222',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 12:37:22','',''),(2127295,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 12:37:22','',''),(2127314,'1','177','919',408,'Retail Sale Id 1263234',7488.00,0.00,0.00,0.00,264.00,'2021-12-02 12:38:50','',''),(2127315,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-02 12:38:50','',''),(2127672,'1','177','919',408,'Retail Sale Id 1263400',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 13:05:02','',''),(2127673,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 13:05:02','',''),(2127700,'1','177','919',408,'Retail Sale Id 1263413',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 13:07:56','',''),(2127701,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:07:56','',''),(2127772,'1','177','919',408,'Retail Sale Id 1263451',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 13:12:51','',''),(2127773,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 13:12:51','',''),(2128041,'1','177','919',408,'Retail Sale Id 1263555',11999.52,0.00,0.00,0.00,423.06,'2021-12-02 13:29:15','',''),(2128042,'1','177','919',408,'Retail sales',0.00,0.00,0.00,19.23,0.00,'2021-12-02 13:29:15','',''),(2128063,'1','177','919',408,'Retail Sale Id 1262606',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 13:30:54','',''),(2128064,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 13:30:54','',''),(2128214,'1','177','919',408,'Retail Sale Id 1263622',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 13:41:36','',''),(2128215,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 13:41:36','',''),(2128278,'1','177','919',408,'Retail Sale Id 1263651',998.40,0.00,0.00,0.00,35.20,'2021-12-02 13:45:41','',''),(2128279,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 13:45:41','',''),(2128586,'1','177','919',408,'Retail Sale Id 1263791',3900.00,0.00,0.00,0.00,137.50,'2021-12-02 14:03:03','',''),(2128587,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 14:03:03','',''),(2128626,'1','177','919',408,'Retail Sale Id 1263812',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 14:05:19','',''),(2128627,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:05:19','',''),(2128668,'1','177','919',408,'Retail Sale Id 1263833',998.40,0.00,0.00,0.00,35.20,'2021-12-02 14:07:28','',''),(2128669,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 14:07:28','',''),(2128965,'1','177','919',408,'Retail Sale Id 1263963',1497.60,0.00,0.00,0.00,52.80,'2021-12-02 14:23:49','',''),(2128966,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-02 14:23:49','',''),(2129033,'1','177','919',408,'Retail Sale Id 1263988',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 14:26:32','',''),(2129034,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:26:32','',''),(2129142,'1','177','919',408,'Retail Sale Id 1264025',998.40,0.00,0.00,0.00,35.20,'2021-12-02 14:30:15','',''),(2129143,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 14:30:15','',''),(2129202,'1','177','919',408,'Retail Sale Id 1264043',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 14:32:25','',''),(2129203,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 14:32:25','',''),(2129244,'1','177','919',408,'Retail Sale Id 1264060',9360.00,0.00,0.00,0.00,330.00,'2021-12-02 14:35:00','',''),(2129245,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-02 14:35:00','',''),(2129353,'1','177','919',408,'Retail Sale Id 1264092',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 14:39:38','',''),(2129354,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:39:38','',''),(2129384,'1','177','919',408,'Retail Sale Id 1264115',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 14:40:52','',''),(2129385,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 14:40:52','',''),(2129427,'1','177','919',408,'Retail Sale Id 1264137',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 14:42:41','',''),(2129428,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 14:42:41','',''),(2129453,'1','177','919',408,'Retail Sale Id 1264145',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 14:44:05','',''),(2129454,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 14:44:05','',''),(2129481,'1','177','919',408,'Retail Sale Id 1264161',1248.00,0.00,0.00,0.00,44.00,'2021-12-02 14:46:21','',''),(2129482,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 14:46:21','',''),(2129503,'1','177','919',408,'Retail Sale Id 1264174',624.00,0.00,0.00,0.00,22.00,'2021-12-02 14:47:49','',''),(2129504,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-02 14:47:49','',''),(2129602,'1','177','919',408,'Retail Sale Id 1264227',1497.60,0.00,0.00,0.00,52.80,'2021-12-02 14:53:30','',''),(2129603,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-02 14:53:30','',''),(2129659,'1','177','919',408,'Retail Sale Id 1264255',798.72,0.00,0.00,0.00,28.16,'2021-12-02 14:56:33','',''),(2129660,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-02 14:56:33','',''),(2129805,'1','177','919',408,'Retail Sale Id 1264331',1497.60,0.00,0.00,0.00,52.80,'2021-12-02 15:07:22','',''),(2129806,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-02 15:07:22','',''),(2129872,'1','177','919',408,'Retail Sale Id 1264362',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 15:11:20','',''),(2129873,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:11:20','',''),(2129890,'1','177','919',408,'Retail Sale Id 1264371',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 15:12:31','',''),(2129891,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:12:31','',''),(2129916,'1','177','919',408,'Retail Sale Id 1264383',10608.00,0.00,0.00,0.00,374.00,'2021-12-02 15:13:56','',''),(2129917,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-02 15:13:56','',''),(2129966,'1','177','919',408,'Retail Sale Id 1264411',998.40,0.00,0.00,0.00,35.20,'2021-12-02 15:16:06','',''),(2129967,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 15:16:06','',''),(2129986,'1','177','919',408,'Retail Sale Id 1264421',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 15:17:17','',''),(2129987,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:17:17','',''),(2130048,'1','177','919',408,'Retail Sale Id 1264454',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 15:20:45','',''),(2130049,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:20:45','',''),(2130146,'1','177','919',408,'Retail Sale Id 1264501',499.20,0.00,0.00,0.00,17.60,'2021-12-02 15:25:38','',''),(2130147,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-02 15:25:38','',''),(2130186,'1','177','919',408,'Retail Sale Id 1264522',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 15:27:24','',''),(2130187,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:27:24','',''),(2130303,'1','177','919',408,'Retail Sale Id 1264574',6801.60,0.00,0.00,0.00,239.80,'2021-12-02 15:32:05','',''),(2130304,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.90,0.00,'2021-12-02 15:32:05','',''),(2130335,'1','177','919',408,'Retail Sale Id 1264582',6002.88,0.00,0.00,0.00,211.64,'2021-12-02 15:33:49','',''),(2130336,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-02 15:33:49','',''),(2130380,'1','177','919',408,'Retail Sale Id 1264611',798.72,0.00,0.00,0.00,28.16,'2021-12-02 15:35:47','',''),(2130381,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-02 15:35:47','',''),(2130428,'1','177','919',408,'Retail Sale Id 1264633',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 15:37:34','',''),(2130429,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:37:34','',''),(2130444,'1','177','919',408,'Retail Sale Id 1264642',3001.44,0.00,0.00,0.00,105.82,'2021-12-02 15:38:47','',''),(2130445,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-02 15:38:47','',''),(2130472,'1','177','919',408,'Retail Sale Id 1264653',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 15:40:13','',''),(2130473,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 15:40:13','',''),(2130508,'1','177','919',408,'Retail Sale Id 1264673',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 15:41:41','',''),(2130509,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 15:41:41','',''),(2130528,'1','177','919',408,'Retail Sale Id 1264688',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 15:42:48','',''),(2130529,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 15:42:48','',''),(2130566,'1','177','919',408,'Retail Sale Id 1264714',1797.12,0.00,0.00,0.00,63.36,'2021-12-02 15:44:16','',''),(2130567,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-02 15:44:16','',''),(2130806,'1','177','919',408,'Retail Sale Id 1264847',3001.44,0.00,0.00,0.00,105.82,'2021-12-02 15:54:57','',''),(2130807,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-02 15:54:57','',''),(2130892,'1','177','919',408,'Retail Sale Id 1264886',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 15:58:49','',''),(2130893,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 15:58:49','',''),(2130920,'1','177','919',408,'Retail Sale Id 1264899',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 15:59:57','',''),(2130921,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 15:59:57','',''),(2130984,'1','177','919',408,'Retail Sale Id 1264928',24960.00,0.00,0.00,0.00,880.00,'2021-12-02 16:02:37','',''),(2130985,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-02 16:02:37','',''),(2131050,'1','177','919',408,'Retail Sale Id 1264955',2502.24,0.00,0.00,0.00,88.22,'2021-12-02 16:05:23','',''),(2131051,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-02 16:05:23','',''),(2131092,'1','177','919',408,'Retail Sale Id 1264975',3900.00,0.00,0.00,0.00,137.50,'2021-12-02 16:07:25','',''),(2131093,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-02 16:07:25','',''),(2131130,'1','177','919',408,'Retail Sale Id 1264990',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 16:08:39','',''),(2131131,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:08:39','',''),(2131188,'1','177','919',408,'Retail Sale Id 1265021',998.40,0.00,0.00,0.00,35.20,'2021-12-02 16:11:08','',''),(2131189,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 16:11:08','',''),(2131275,'1','177','919',408,'Retail Sale Id 1265067',2801.76,0.00,0.00,0.00,98.78,'2021-12-02 16:15:38','',''),(2131276,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.49,0.00,'2021-12-02 16:15:38','',''),(2131307,'1','177','919',408,'Retail Sale Id 1265083',1397.76,0.00,0.00,0.00,49.28,'2021-12-02 16:17:13','',''),(2131308,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-02 16:17:13','',''),(2131337,'1','177','919',408,'Retail Sale Id 1265096',6002.88,0.00,0.00,0.00,211.64,'2021-12-02 16:18:43','',''),(2131338,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-02 16:18:43','',''),(2131371,'1','177','919',408,'Retail Sale Id 1265117',1497.60,0.00,0.00,0.00,52.80,'2021-12-02 16:20:51','',''),(2131372,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-02 16:20:51','',''),(2131396,'1','177','919',408,'Retail Sale Id 1265132',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 16:21:58','',''),(2131397,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:21:58','',''),(2131426,'1','177','919',408,'Retail Sale Id 1265143',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 16:23:44','',''),(2131427,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 16:23:44','',''),(2131466,'1','177','919',408,'Retail Sale Id 1265163',998.40,0.00,0.00,0.00,35.20,'2021-12-02 16:25:43','',''),(2131467,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 16:25:43','',''),(2131510,'1','177','919',408,'Retail Sale Id 1265186',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 16:27:31','',''),(2131511,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:27:31','',''),(2131624,'1','177','919',408,'Retail Sale Id 1265224',3999.84,0.00,0.00,0.00,141.02,'2021-12-02 16:30:26','',''),(2131625,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-02 16:30:26','',''),(2131662,'1','177','919',408,'Retail Sale Id 1265246',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 16:31:54','',''),(2131663,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 16:31:54','',''),(2131734,'1','177','919',408,'Retail Sale Id 1265288',27144.00,0.00,0.00,0.00,957.00,'2021-12-02 16:35:33','',''),(2131735,'1','177','919',408,'Retail sales',0.00,0.00,0.00,43.50,0.00,'2021-12-02 16:35:33','',''),(2131770,'1','177','919',408,'Retail Sale Id 1265306',4992.00,0.00,0.00,0.00,176.00,'2021-12-02 16:38:15','',''),(2131771,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-02 16:38:15','',''),(2131859,'1','177','919',408,'Retail Sale Id 1265350',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 16:43:02','',''),(2131860,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 16:43:02','',''),(2131942,'1','177','919',408,'Retail Sale Id 1265389',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 16:46:16','',''),(2131943,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 16:46:16','',''),(2132010,'1','177','919',408,'Retail Sale Id 1265427',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 16:50:36','',''),(2132012,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 16:50:36','',''),(2132064,'1','177','919',408,'Retail Sale Id 1265453',1397.76,0.00,0.00,0.00,49.28,'2021-12-02 16:53:37','',''),(2132065,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-02 16:53:37','',''),(2132086,'1','177','919',408,'Retail Sale Id 1265467',1248.00,0.00,0.00,0.00,44.00,'2021-12-02 16:54:52','',''),(2132087,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 16:54:52','',''),(2132140,'1','177','919',408,'Retail Sale Id 1265496',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 16:58:39','',''),(2132141,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 16:58:39','',''),(2132201,'1','177','919',408,'Retail Sale Id 1265518',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 17:01:55','',''),(2132202,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:01:55','',''),(2132237,'1','177','919',408,'Retail Sale Id 1265534',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 17:04:06','',''),(2132238,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:04:06','',''),(2132257,'1','177','919',408,'Retail Sale Id 1265545',1497.60,0.00,0.00,0.00,52.80,'2021-12-02 17:05:31','',''),(2132258,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-02 17:05:31','',''),(2132276,'1','177','919',408,'Retail Sale Id 1265554',998.40,0.00,0.00,0.00,35.20,'2021-12-02 17:06:35','',''),(2132277,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 17:06:35','',''),(2132293,'1','177','919',408,'Retail Sale Id 1265562',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 17:07:31','',''),(2132294,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:07:31','',''),(2132346,'1','177','919',408,'Retail Sale Id 1265588',998.40,0.00,0.00,0.00,35.20,'2021-12-02 17:11:49','',''),(2132347,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 17:11:49','',''),(2132383,'1','177','919',408,'Retail Sale Id 1265601',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 17:14:12','',''),(2132384,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:14:12','',''),(2132466,'1','177','919',408,'Retail Sale Id 1265643',1198.08,0.00,0.00,0.00,42.24,'2021-12-02 17:18:13','',''),(2132467,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-02 17:18:13','',''),(2132491,'1','177','919',408,'Retail Sale Id 1265653',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 17:19:36','',''),(2132492,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:19:36','',''),(2132547,'1','177','919',408,'Retail Sale Id 1265677',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 17:22:07','',''),(2132548,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:22:07','',''),(2132583,'1','177','919',408,'Retail Sale Id 1265695',4998.24,0.00,0.00,0.00,176.22,'2021-12-02 17:24:32','',''),(2132584,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-02 17:24:32','',''),(2132605,'1','177','919',408,'Retail Sale Id 1265707',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 17:26:59','',''),(2132606,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:26:59','',''),(2132639,'1','177','919',408,'Retail Sale Id 1265718',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 17:30:24','',''),(2132640,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:30:24','',''),(2132661,'1','177','919',408,'Retail Sale Id 1265729',2003.04,0.00,0.00,0.00,70.62,'2021-12-02 17:32:14','',''),(2132662,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-02 17:32:14','',''),(2132671,'1','177','919',408,'Retail Sale Id 1265733',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 17:33:27','',''),(2132672,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:33:27','',''),(2132771,'1','177','919',408,'Retail Sale Id 1265784',1248.00,0.00,0.00,0.00,44.00,'2021-12-02 17:42:56','',''),(2132772,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-02 17:42:56','',''),(2132796,'1','177','919',408,'Retail Sale Id 1265797',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 17:46:14','',''),(2132797,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 17:46:14','',''),(2132827,'1','177','919',408,'Retail Sale Id 1265810',3120.00,0.00,0.00,0.00,110.00,'2021-12-02 17:48:13','',''),(2132828,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-02 17:48:13','',''),(2132855,'1','177','919',408,'Retail Sale Id 1265820',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 17:51:35','',''),(2132856,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:51:35','',''),(2132880,'1','177','919',408,'Retail Sale Id 1265828',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 17:53:41','',''),(2132881,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 17:53:41','',''),(2132919,'1','177','919',408,'Retail Sale Id 1265842',998.40,0.00,0.00,0.00,35.20,'2021-12-02 17:56:16','',''),(2132920,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-02 17:56:16','',''),(2132931,'1','177','919',408,'Retail Sale Id 1265847',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 17:58:27','',''),(2132932,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 17:58:27','',''),(2132945,'1','177','919',408,'Retail Sale Id 1265855',1872.00,0.00,0.00,0.00,66.00,'2021-12-02 18:00:52','',''),(2132946,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-02 18:00:52','',''),(2132974,'1','177','919',408,'Retail Sale Id 1265863',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 18:03:27','',''),(2132975,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 18:03:27','',''),(2133127,'1','177','919',408,'Retail Sale Id 1265915',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 18:18:59','',''),(2133128,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 18:18:59','',''),(2133165,'1','177','919',408,'Retail Sale Id 1265933',6240.00,0.00,0.00,0.00,220.00,'2021-12-02 18:25:00','',''),(2133166,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-02 18:25:00','',''),(2133198,'1','177','919',408,'Retail Sale Id 1265940',898.56,0.00,0.00,0.00,31.68,'2021-12-02 18:27:47','',''),(2133199,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.44,0.00,'2021-12-02 18:27:47','',''),(2133348,'1','177','919',408,'Retail Sale Id 1266001',7800.00,0.00,0.00,0.00,275.00,'2021-12-02 18:55:02','',''),(2133349,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-02 18:55:02','',''),(2133360,'1','177','919',408,'Retail Sale Id 1266007',3744.00,0.00,0.00,0.00,132.00,'2021-12-02 18:59:25','',''),(2133361,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-02 18:59:25','',''),(2133366,'1','177','919',408,'Retail Sale Id 1266010',1560.00,0.00,0.00,0.00,55.00,'2021-12-02 19:04:46','',''),(2133367,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-02 19:04:46','',''),(2133368,'1','177','919',408,'Retail Sale Id 1266011',6002.88,0.00,0.00,0.00,211.64,'2021-12-02 19:06:36','',''),(2133369,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-02 19:06:36','',''),(2133808,'1','177','919',408,'Retail Sale Id 1266063',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 05:35:20','',''),(2133809,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 05:35:20','',''),(2134067,'1','177','919',408,'Retail Sale Id 1266129',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 06:16:53','',''),(2134068,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 06:16:53','',''),(2134435,'1','177','919',408,'Retail Sale Id 1266307',4998.24,0.00,0.00,0.00,176.22,'2021-12-03 06:44:35','',''),(2134436,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-03 06:44:35','',''),(2134813,'1','177','919',408,'Retail Sale Id 1266493',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 07:05:17','',''),(2134814,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 07:05:17','',''),(2134835,'1','177','919',408,'Retail Sale Id 1266507',3001.44,0.00,0.00,0.00,105.82,'2021-12-03 07:06:48','',''),(2134836,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-03 07:06:48','',''),(2134958,'1','177','919',408,'Retail Sale Id 1266553',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 07:13:15','',''),(2134959,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 07:13:15','',''),(2135319,'1','177','919',408,'Retail Sale Id 1266739',40560.00,0.00,0.00,0.00,1430.00,'2021-12-03 07:34:16','',''),(2135320,'1','177','919',408,'Retail sales',0.00,0.00,0.00,65.00,0.00,'2021-12-03 07:34:16','',''),(2135396,'1','177','919',408,'Retail Sale Id 1266774',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 07:37:49','',''),(2135397,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 07:37:49','',''),(2135594,'1','177','919',408,'Retail Sale Id 1266867',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 07:48:54','',''),(2135595,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 07:48:54','',''),(2135637,'1','177','919',408,'Retail Sale Id 1266882',28080.00,0.00,0.00,0.00,990.00,'2021-12-03 07:50:40','',''),(2135638,'1','177','919',408,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-03 07:50:40','',''),(2135899,'1','177','919',408,'Retail Sale Id 1266986',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 08:02:36','',''),(2135900,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:02:36','',''),(2135954,'1','177','919',408,'Retail Sale Id 1267005',15600.00,0.00,0.00,0.00,550.00,'2021-12-03 08:04:49','',''),(2135955,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 08:04:49','',''),(2135976,'1','177','919',408,'Retail Sale Id 1267021',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 08:05:49','',''),(2135977,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:05:49','',''),(2136000,'1','177','919',408,'Retail Sale Id 1267035',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 08:06:53','',''),(2136001,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:06:53','',''),(2136062,'1','177','919',408,'Retail Sale Id 1267065',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 08:09:28','',''),(2136063,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:09:28','',''),(2136080,'1','177','919',408,'Retail Sale Id 1267074',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 08:10:28','',''),(2136081,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:10:28','',''),(2136210,'1','177','919',408,'Retail Sale Id 1267146',624.00,0.00,0.00,0.00,22.00,'2021-12-03 08:17:24','',''),(2136211,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 08:17:24','',''),(2136326,'1','177','919',408,'Retail Sale Id 1267200',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 08:24:08','',''),(2136327,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:24:08','',''),(2136376,'1','177','919',408,'Retail Sale Id 1267224',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 08:26:42','',''),(2136377,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:26:42','',''),(2136438,'1','177','919',408,'Retail Sale Id 1267251',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 08:31:36','',''),(2136439,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 08:31:36','',''),(2136489,'1','177','919',408,'Retail Sale Id 1267268',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 08:34:16','',''),(2136490,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 08:34:16','',''),(2136602,'1','177','919',408,'Retail Sale Id 1267292',11999.52,0.00,0.00,0.00,423.06,'2021-12-03 08:37:55','',''),(2136603,'1','177','919',408,'Retail sales',0.00,0.00,0.00,19.23,0.00,'2021-12-03 08:37:55','',''),(2136872,'1','177','919',408,'Retail Sale Id 1267395',3001.44,0.00,0.00,0.00,105.82,'2021-12-03 08:49:47','',''),(2136873,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-03 08:49:47','',''),(2136958,'1','177','919',408,'Retail Sale Id 1267438',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 08:54:46','',''),(2136959,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 08:54:46','',''),(2137072,'1','177','919',408,'Retail Sale Id 1267501',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 09:01:19','',''),(2137073,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:01:19','',''),(2137160,'1','177','919',408,'Retail Sale Id 1267549',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 09:05:15','',''),(2137161,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 09:05:15','',''),(2137302,'1','177','919',408,'Retail Sale Id 1267639',4998.24,0.00,0.00,0.00,176.22,'2021-12-03 09:12:24','',''),(2137303,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-03 09:12:24','',''),(2137326,'1','177','919',408,'Retail Sale Id 1267654',3999.84,0.00,0.00,0.00,141.02,'2021-12-03 09:13:23','',''),(2137327,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-03 09:13:23','',''),(2137344,'1','177','919',408,'Retail Sale Id 1267664',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 09:14:35','',''),(2137345,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:14:35','',''),(2137419,'1','177','919',408,'Retail Sale Id 1267708',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 09:17:44','',''),(2137420,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 09:17:44','',''),(2137444,'1','177','919',408,'Retail Sale Id 1267718',998.40,0.00,0.00,0.00,35.20,'2021-12-03 09:18:52','',''),(2137445,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-03 09:18:52','',''),(2137465,'1','177','919',408,'Retail Sale Id 1267725',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 09:20:16','',''),(2137466,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 09:20:16','',''),(2137597,'1','177','919',408,'Retail Sale Id 1267805',6240.00,0.00,0.00,0.00,220.00,'2021-12-03 09:28:31','',''),(2137598,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 09:28:31','',''),(2137970,'1','177','919',408,'Retail Sale Id 1267996',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 09:51:43','',''),(2137971,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 09:51:43','',''),(2138072,'1','177','919',408,'Retail Sale Id 1268046',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 09:58:24','',''),(2138073,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 09:58:24','',''),(2138179,'1','177','919',408,'Retail Sale Id 1268102',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 10:05:03','',''),(2138180,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 10:05:03','',''),(2138207,'1','177','919',408,'Retail Sale Id 1268116',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 10:06:26','',''),(2138208,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 10:06:26','',''),(2138231,'1','177','919',408,'Retail Sale Id 1268128',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 10:07:26','',''),(2138232,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:07:26','',''),(2138411,'1','177','919',408,'Retail Sale Id 1268217',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 10:17:06','',''),(2138412,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:17:06','',''),(2138432,'1','177','919',408,'Retail Sale Id 1268225',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 10:18:23','',''),(2138433,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:18:23','',''),(2138526,'1','177','919',408,'Retail Sale Id 1268272',1198.08,0.00,0.00,0.00,42.24,'2021-12-03 10:23:44','',''),(2138527,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-03 10:23:44','',''),(2138717,'1','177','919',408,'Retail Sale Id 1268367',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 10:36:04','',''),(2138718,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:36:04','',''),(2138761,'1','177','919',408,'Retail Sale Id 1268380',6240.00,0.00,0.00,0.00,220.00,'2021-12-03 10:37:53','',''),(2138762,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-03 10:37:53','',''),(2138791,'1','177','919',408,'Retail Sale Id 1268400',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 10:39:42','',''),(2138792,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:39:42','',''),(2138851,'1','177','919',408,'Retail Sale Id 1268439',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 10:44:12','',''),(2138852,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:44:12','',''),(2138878,'1','177','919',408,'Retail Sale Id 1268452',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 10:46:38','',''),(2138879,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 10:46:38','',''),(2139001,'1','177','919',408,'Retail Sale Id 1268513',1248.00,0.00,0.00,0.00,44.00,'2021-12-03 10:56:39','',''),(2139002,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 10:56:39','',''),(2139034,'1','177','919',408,'Retail Sale Id 1268531',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 10:59:30','',''),(2139035,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 10:59:30','',''),(2139161,'1','177','919',408,'Retail Sale Id 1268599',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 11:09:10','',''),(2139162,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:09:10','',''),(2139179,'1','177','919',408,'Retail Sale Id 1268608',1248.00,0.00,0.00,0.00,44.00,'2021-12-03 11:10:19','',''),(2139180,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 11:10:19','',''),(2139253,'1','177','919',408,'Retail Sale Id 1268645',6002.88,0.00,0.00,0.00,211.64,'2021-12-03 11:15:24','',''),(2139254,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-03 11:15:24','',''),(2139346,'1','177','919',408,'Retail Sale Id 1268691',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 11:21:38','',''),(2139347,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:21:38','',''),(2139390,'1','177','919',408,'Retail Sale Id 1268716',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 11:26:09','',''),(2139391,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 11:26:09','',''),(2139405,'1','177','919',408,'Retail Sale Id 1268722',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 11:27:23','',''),(2139406,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 11:27:23','',''),(2139429,'1','177','919',408,'Retail Sale Id 1268735',3700.32,0.00,0.00,0.00,130.46,'2021-12-03 11:29:25','',''),(2139430,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.93,0.00,'2021-12-03 11:29:25','',''),(2139467,'1','177','919',408,'Retail Sale Id 1268757',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 11:32:05','',''),(2139468,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:32:05','',''),(2139534,'1','177','919',408,'Retail Sale Id 1268791',1248.00,0.00,0.00,0.00,44.00,'2021-12-03 11:37:55','',''),(2139535,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 11:37:55','',''),(2139550,'1','177','919',408,'Retail Sale Id 1268804',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 11:39:20','',''),(2139551,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 11:39:20','',''),(2139901,'1','177','919',408,'Retail Sale Id 1268995',31200.00,0.00,0.00,0.00,1100.00,'2021-12-03 12:04:22','',''),(2139902,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 12:04:22','',''),(2140248,'1','177','919',408,'Retail Sale Id 1269199',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 12:33:44','',''),(2140249,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 12:33:44','',''),(2140274,'1','177','919',408,'Retail Sale Id 1269224',1098.24,0.00,0.00,0.00,38.72,'2021-12-03 12:36:32','',''),(2140275,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.76,0.00,'2021-12-03 12:36:32','',''),(2140307,'1','177','919',408,'Retail Sale Id 1269235',6864.00,0.00,0.00,0.00,242.00,'2021-12-03 12:38:43','',''),(2140308,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-03 12:38:43','',''),(2140417,'1','177','919',408,'Retail Sale Id 1269288',3500.64,0.00,0.00,0.00,123.42,'2021-12-03 12:47:05','',''),(2140418,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-03 12:47:05','',''),(2140767,'1','177','919',408,'Retail Sale Id 1269454',31200.00,0.00,0.00,0.00,1100.00,'2021-12-03 13:14:29','',''),(2140768,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-03 13:14:29','',''),(2140812,'1','177','919',408,'Retail Sale Id 1269474',4998.24,0.00,0.00,0.00,176.22,'2021-12-03 13:17:46','',''),(2140813,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-03 13:17:46','',''),(2140875,'1','177','919',408,'Retail Sale Id 1269496',998.40,0.00,0.00,0.00,35.20,'2021-12-03 13:21:55','',''),(2140876,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-03 13:21:55','',''),(2140897,'1','177','919',408,'Retail Sale Id 1269507',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 13:24:24','',''),(2140898,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 13:24:24','',''),(2141007,'1','177','919',408,'Retail Sale Id 1269554',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 13:32:12','',''),(2141008,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:32:12','',''),(2141037,'1','177','919',408,'Retail Sale Id 1269579',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 13:34:05','',''),(2141038,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 13:34:05','',''),(2141096,'1','177','919',408,'Retail Sale Id 1269609',10920.00,0.00,0.00,0.00,385.00,'2021-12-03 13:38:02','',''),(2141097,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-03 13:38:02','',''),(2141192,'1','177','919',408,'Retail Sale Id 1269651',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 13:43:13','',''),(2141193,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:43:13','',''),(2141433,'1','177','919',408,'Retail Sale Id 1269729',4499.04,0.00,0.00,0.00,158.62,'2021-12-03 13:51:31','',''),(2141434,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-03 13:51:31','',''),(2141467,'1','177','919',408,'Retail Sale Id 1269745',998.40,0.00,0.00,0.00,35.20,'2021-12-03 13:53:09','',''),(2141468,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-03 13:53:09','',''),(2141487,'1','177','919',408,'Retail Sale Id 1269753',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 13:54:47','',''),(2141488,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 13:54:47','',''),(2141516,'1','177','919',408,'Retail Sale Id 1269767',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 13:56:17','',''),(2141517,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 13:56:17','',''),(2141542,'1','177','919',408,'Retail Sale Id 1269780',7001.28,0.00,0.00,0.00,246.84,'2021-12-03 13:58:53','',''),(2141543,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-03 13:58:53','',''),(2141582,'1','177','919',408,'Retail Sale Id 1269799',3001.44,0.00,0.00,0.00,105.82,'2021-12-03 14:01:43','',''),(2141583,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-03 14:01:43','',''),(2141602,'1','177','919',408,'Retail Sale Id 1269806',798.72,0.00,0.00,0.00,28.16,'2021-12-03 14:02:38','',''),(2141603,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-03 14:02:38','',''),(2141645,'1','177','919',408,'Retail Sale Id 1269820',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 14:04:57','',''),(2141646,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 14:04:57','',''),(2141661,'1','177','919',408,'Retail Sale Id 1269829',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 14:06:00','',''),(2141662,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:06:00','',''),(2141719,'1','177','919',408,'Retail Sale Id 1269850',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 14:08:58','',''),(2141720,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:08:58','',''),(2141744,'1','177','919',408,'Retail Sale Id 1269860',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 14:10:40','',''),(2141745,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 14:10:40','',''),(2141766,'1','177','919',408,'Retail Sale Id 1269873',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 14:11:56','',''),(2141767,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:11:56','',''),(2141816,'1','177','919',408,'Retail Sale Id 1269897',22464.00,0.00,0.00,0.00,792.00,'2021-12-03 14:16:44','',''),(2141817,'1','177','919',408,'Retail sales',0.00,0.00,0.00,36.00,0.00,'2021-12-03 14:16:44','',''),(2141840,'1','177','919',408,'Retail Sale Id 1269907',4998.24,0.00,0.00,0.00,176.22,'2021-12-03 14:18:08','',''),(2141841,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-03 14:18:08','',''),(2141939,'1','177','919',408,'Retail Sale Id 1269935',14976.00,0.00,0.00,0.00,528.00,'2021-12-03 14:22:44','',''),(2141940,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-03 14:22:44','',''),(2141993,'1','177','919',408,'Retail Sale Id 1269957',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 14:25:13','',''),(2141994,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:25:13','',''),(2142018,'1','177','919',408,'Retail Sale Id 1269966',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 14:27:01','',''),(2142019,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:27:01','',''),(2142034,'1','177','919',408,'Retail Sale Id 1269977',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 14:28:03','',''),(2142035,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 14:28:03','',''),(2142052,'1','177','919',408,'Retail Sale Id 1269985',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 14:29:21','',''),(2142053,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:29:21','',''),(2142085,'1','177','919',408,'Retail Sale Id 1269994',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 14:31:28','',''),(2142086,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 14:31:28','',''),(2142115,'1','177','919',408,'Retail Sale Id 1270005',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 14:33:37','',''),(2142116,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 14:33:37','',''),(2142443,'1','177','919',408,'Retail Sale Id 1270137',1248.00,0.00,0.00,0.00,44.00,'2021-12-03 14:47:25','',''),(2142444,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 14:47:25','',''),(2142478,'1','177','919',408,'Retail Sale Id 1270156',9360.00,0.00,0.00,0.00,330.00,'2021-12-03 14:48:54','',''),(2142479,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-03 14:48:54','',''),(2142511,'1','177','919',408,'Retail Sale Id 1270175',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 14:50:47','',''),(2142512,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 14:50:47','',''),(2142553,'1','177','919',408,'Retail Sale Id 1270197',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 14:52:43','',''),(2142554,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 14:52:43','',''),(2142720,'1','177','919',408,'Retail Sale Id 1270269',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 15:01:11','',''),(2142721,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:01:11','',''),(2142751,'1','177','919',408,'Retail Sale Id 1270283',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 15:03:39','',''),(2142752,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 15:03:39','',''),(2142826,'1','177','919',408,'Retail Sale Id 1270313',998.40,0.00,0.00,0.00,35.20,'2021-12-03 15:08:42','',''),(2142827,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-03 15:08:42','',''),(2142895,'1','177','919',408,'Retail Sale Id 1270346',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 15:11:25','',''),(2142896,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:11:25','',''),(2142984,'1','177','919',408,'Retail Sale Id 1270405',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 15:15:26','',''),(2142985,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 15:15:26','',''),(2143022,'1','177','919',408,'Retail Sale Id 1270431',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 15:17:20','',''),(2143023,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:17:20','',''),(2143059,'1','177','919',408,'Retail Sale Id 1270452',18720.00,0.00,0.00,0.00,660.00,'2021-12-03 15:19:25','',''),(2143060,'1','177','919',408,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-03 15:19:25','',''),(2143177,'1','177','919',408,'Retail Sale Id 1270515',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 15:25:51','',''),(2143178,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 15:25:51','',''),(2143204,'1','177','919',408,'Retail Sale Id 1270528',1248.00,0.00,0.00,0.00,44.00,'2021-12-03 15:27:18','',''),(2143205,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 15:27:18','',''),(2143235,'1','177','919',408,'Retail Sale Id 1270537',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 15:28:47','',''),(2143236,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 15:28:47','',''),(2143417,'1','177','919',408,'Retail Sale Id 1270631',23400.00,0.00,0.00,0.00,825.00,'2021-12-03 15:36:27','',''),(2143418,'1','177','919',408,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-03 15:36:27','',''),(2143490,'1','177','919',408,'Retail Sale Id 1270671',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 15:39:26','',''),(2143491,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 15:39:26','',''),(2143962,'1','177','919',408,'Return of Retail Sale Id 1270631',0.00,23400.00,37.50,0.00,-825.00,'2021-12-03 16:00:09','',''),(2143983,'1','177','919',408,'Retail Sale Id 1270913',842.40,0.00,0.00,0.00,29.70,'2021-12-03 16:01:01','',''),(2143984,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.35,0.00,'2021-12-03 16:01:01','',''),(2144029,'1','177','919',408,'Retail Sale Id 1270934',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 16:02:53','',''),(2144030,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:02:53','',''),(2144059,'1','177','919',408,'Retail Sale Id 1270949',10608.00,0.00,0.00,0.00,374.00,'2021-12-03 16:03:54','',''),(2144060,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-03 16:03:54','',''),(2144250,'1','177','919',408,'Retail Sale Id 1271044',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 16:12:27','',''),(2144251,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:12:27','',''),(2144276,'1','177','919',408,'Retail Sale Id 1271060',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 16:14:13','',''),(2144277,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 16:14:13','',''),(2144290,'1','177','919',408,'Retail Sale Id 1271068',15600.00,0.00,0.00,0.00,550.00,'2021-12-03 16:15:20','',''),(2144291,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 16:15:20','',''),(2144340,'1','177','919',408,'Retail Sale Id 1271093',1248.00,0.00,0.00,0.00,44.00,'2021-12-03 16:18:01','',''),(2144341,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-03 16:18:01','',''),(2144380,'1','177','919',408,'Retail Sale Id 1271111',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 16:19:39','',''),(2144381,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 16:19:39','',''),(2144396,'1','177','919',408,'Retail Sale Id 1271121',15600.00,0.00,0.00,0.00,550.00,'2021-12-03 16:20:37','',''),(2144397,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 16:20:37','',''),(2144438,'1','177','919',408,'Retail Sale Id 1271141',2496.00,0.00,0.00,0.00,88.00,'2021-12-03 16:22:46','',''),(2144439,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-03 16:22:46','',''),(2144458,'1','177','919',408,'Retail Sale Id 1271151',199.68,0.00,0.00,0.00,7.04,'2021-12-03 16:23:44','',''),(2144459,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.32,0.00,'2021-12-03 16:23:44','',''),(2144479,'1','177','919',408,'Retail Sale Id 1271162',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 16:24:53','',''),(2144481,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 16:24:53','',''),(2144504,'1','177','919',408,'Retail Sale Id 1271176',1797.12,0.00,0.00,0.00,63.36,'2021-12-03 16:26:13','',''),(2144505,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-03 16:26:13','',''),(2144522,'1','177','919',408,'Retail Sale Id 1271183',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 16:27:29','',''),(2144523,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 16:27:29','',''),(2144550,'1','177','919',408,'Retail Sale Id 1271197',19344.00,0.00,0.00,0.00,682.00,'2021-12-03 16:29:04','',''),(2144551,'1','177','919',408,'Retail sales',0.00,0.00,0.00,31.00,0.00,'2021-12-03 16:29:04','',''),(2144598,'1','177','919',408,'Retail Sale Id 1271217',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 16:31:07','',''),(2144599,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:31:07','',''),(2144710,'1','177','919',408,'Retail Sale Id 1271270',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 16:36:54','',''),(2144711,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:36:54','',''),(2144738,'1','177','919',408,'Retail Sale Id 1271294',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 16:38:21','',''),(2144739,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 16:38:21','',''),(2144754,'1','177','919',408,'Retail Sale Id 1271303',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 16:39:17','',''),(2144755,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:39:17','',''),(2144799,'1','177','919',408,'Retail Sale Id 1271322',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 16:41:22','',''),(2144800,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 16:41:22','',''),(2144838,'1','177','919',408,'Retail Sale Id 1271341',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 16:42:38','',''),(2144839,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 16:42:38','',''),(2144969,'1','177','919',408,'Retail Sale Id 1271407',24148.80,0.00,0.00,0.00,851.40,'2021-12-03 16:50:20','',''),(2144970,'1','177','919',408,'Retail sales',0.00,0.00,0.00,38.70,0.00,'2021-12-03 16:50:20','',''),(2145078,'1','177','919',408,'Retail Sale Id 1271444',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 16:54:19','',''),(2145079,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 16:54:19','',''),(2145103,'1','177','919',408,'Retail Sale Id 1271452',798.72,0.00,0.00,0.00,28.16,'2021-12-03 16:55:21','',''),(2145104,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-03 16:55:21','',''),(2145151,'1','177','919',408,'Retail Sale Id 1271467',998.40,0.00,0.00,0.00,35.20,'2021-12-03 16:56:37','',''),(2145152,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-03 16:56:37','',''),(2145174,'1','177','919',408,'Retail Sale Id 1271477',2003.04,0.00,0.00,0.00,70.62,'2021-12-03 16:58:06','',''),(2145175,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-03 16:58:06','',''),(2145220,'1','177','919',408,'Retail Sale Id 1271500',2402.40,0.00,0.00,0.00,84.70,'2021-12-03 17:00:56','',''),(2145221,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.85,0.00,'2021-12-03 17:00:56','',''),(2145244,'1','177','919',408,'Retail Sale Id 1271513',599.04,0.00,0.00,0.00,21.12,'2021-12-03 17:02:37','',''),(2145245,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.96,0.00,'2021-12-03 17:02:37','',''),(2145264,'1','177','919',408,'Retail Sale Id 1271529',798.72,0.00,0.00,0.00,28.16,'2021-12-03 17:04:26','',''),(2145265,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-03 17:04:26','',''),(2145355,'1','177','919',408,'Retail Sale Id 1271573',5247.84,0.00,0.00,0.00,185.02,'2021-12-03 17:12:13','',''),(2145356,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.41,0.00,'2021-12-03 17:12:13','',''),(2145369,'1','177','919',408,'Retail Sale Id 1271581',35880.00,0.00,0.00,0.00,1265.00,'2021-12-03 17:13:14','',''),(2145370,'1','177','919',408,'Retail sales',0.00,0.00,0.00,57.50,0.00,'2021-12-03 17:13:14','',''),(2145389,'1','177','919',408,'Retail Sale Id 1271590',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 17:14:26','',''),(2145390,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:14:26','',''),(2145419,'1','177','919',408,'Retail Sale Id 1271606',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 17:18:02','',''),(2145420,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 17:18:02','',''),(2145427,'1','177','919',408,'Retail Sale Id 1271610',624.00,0.00,0.00,0.00,22.00,'2021-12-03 17:19:24','',''),(2145428,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-03 17:19:24','',''),(2145441,'1','177','919',408,'Retail Sale Id 1271617',1872.00,0.00,0.00,0.00,66.00,'2021-12-03 17:21:19','',''),(2145442,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-03 17:21:19','',''),(2145454,'1','177','919',408,'Retail Sale Id 1271624',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 17:22:25','',''),(2145455,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:22:25','',''),(2145465,'1','177','919',408,'Retail Sale Id 1271628',9122.88,0.00,0.00,0.00,321.64,'2021-12-03 17:23:48','',''),(2145466,'1','177','919',408,'Retail sales',0.00,0.00,0.00,14.62,0.00,'2021-12-03 17:23:48','',''),(2145477,'1','177','919',408,'Retail Sale Id 1271635',23400.00,0.00,0.00,0.00,825.00,'2021-12-03 17:25:05','',''),(2145478,'1','177','919',408,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-03 17:25:05','',''),(2145489,'1','177','919',408,'Retail Sale Id 1271641',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 17:26:08','',''),(2145490,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 17:26:08','',''),(2145503,'1','177','919',408,'Retail Sale Id 1271645',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 17:28:00','',''),(2145504,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 17:28:00','',''),(2145515,'1','177','919',408,'Retail Sale Id 1271654',3744.00,0.00,0.00,0.00,132.00,'2021-12-03 17:29:53','',''),(2145516,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-03 17:29:53','',''),(2145579,'1','177','919',408,'Retail Sale Id 1271698',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 17:39:38','',''),(2145580,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:39:38','',''),(2145605,'1','177','919',408,'Retail Sale Id 1271711',7800.00,0.00,0.00,0.00,275.00,'2021-12-03 17:43:08','',''),(2145606,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 17:43:08','',''),(2145621,'1','177','919',408,'Retail Sale Id 1271717',3120.00,0.00,0.00,0.00,110.00,'2021-12-03 17:46:11','',''),(2145622,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 17:46:11','',''),(2145656,'1','177','919',408,'Retail Sale Id 1271734',1497.60,0.00,0.00,0.00,52.80,'2021-12-03 17:52:38','',''),(2145657,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-03 17:52:38','',''),(2145750,'1','177',NULL,408,'Purchased from AA RANO NIG LTD.',0.00,1184000.00,2000.00,0.00,0.00,'2021-12-03 18:03:58','',''),(2145755,'1','177',NULL,408,'Reception corrector for bridging 126103',0.00,0.00,0.00,2000.00,0.00,'2021-12-03 18:04:48','',''),(2145756,'1','177','919',408,'Received from bridging 126103',0.00,0.00,2000.00,0.00,0.00,'2021-12-03 18:04:48','',''),(2145759,'1','177','919',408,'Retail Sale Id 1271768',7001.28,0.00,0.00,0.00,359.04,'2021-12-03 18:05:37','',''),(2145760,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-03 18:05:37','',''),(2145779,'1','177','919',408,'Retail Sale Id 1271777',3001.44,0.00,0.00,0.00,153.92,'2021-12-03 18:09:25','',''),(2145780,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-03 18:09:25','',''),(2145797,'1','177','919',408,'Retail Sale Id 1271786',3120.00,0.00,0.00,0.00,160.00,'2021-12-03 18:11:05','',''),(2145798,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-03 18:11:05','',''),(2145818,'1','177','919',408,'Retail Sale Id 1271795',4992.00,0.00,0.00,0.00,256.00,'2021-12-03 18:13:14','',''),(2145819,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-03 18:13:14','',''),(2145830,'1','177','919',408,'Retail Sale Id 1271801',15600.00,0.00,0.00,0.00,800.00,'2021-12-03 18:14:58','',''),(2145831,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-03 18:14:58','',''),(2146013,'1','177','919',408,'Retail Sale Id 1271867',7800.00,0.00,0.00,0.00,400.00,'2021-12-03 18:37:46','',''),(2146014,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-03 18:37:46','',''),(2146084,'1','177','919',408,'Retail Sale Id 1271903',19393.92,0.00,0.00,0.00,994.56,'2021-12-03 19:12:07','',''),(2146085,'1','177','919',408,'Retail sales',0.00,0.00,0.00,31.08,0.00,'2021-12-03 19:12:07','',''),(2146501,'1','177','919',408,'Retail Sale Id 1271953',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 05:48:19','',''),(2146502,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 05:48:19','',''),(2146563,'1','177','919',408,'Retail Sale Id 1271971',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 05:54:37','',''),(2146564,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 05:54:37','',''),(2146658,'1','177','919',408,'Retail Sale Id 1272007',998.40,0.00,0.00,0.00,51.20,'2021-12-04 06:11:19','',''),(2146659,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-04 06:11:19','',''),(2146793,'1','177','919',408,'Retail Sale Id 1272045',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 06:20:29','',''),(2146794,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:20:29','',''),(2146826,'1','177','919',408,'Retail Sale Id 1272058',15600.00,0.00,0.00,0.00,800.00,'2021-12-04 06:22:51','',''),(2146827,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 06:22:51','',''),(2146892,'1','177','919',408,'Retail Sale Id 1272073',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 06:25:37','',''),(2146893,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 06:25:37','',''),(2147008,'1','177','919',408,'Retail Sale Id 1272117',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 06:30:42','',''),(2147009,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:30:42','',''),(2147096,'1','177','919',408,'Retail Sale Id 1272157',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 06:35:43','',''),(2147097,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:35:43','',''),(2147142,'1','177','919',408,'Retail Sale Id 1272178',15600.00,0.00,0.00,0.00,800.00,'2021-12-04 06:38:21','',''),(2147143,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 06:38:21','',''),(2147166,'1','177','919',408,'Retail Sale Id 1272192',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 06:39:32','',''),(2147167,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 06:39:32','',''),(2147412,'1','177','919',408,'Retail Sale Id 1272301',1248.00,0.00,0.00,0.00,64.00,'2021-12-04 06:53:01','',''),(2147413,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 06:53:01','',''),(2147715,'1','177','919',408,'Retail Sale Id 1272442',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 07:08:23','',''),(2147716,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:08:23','',''),(2147740,'1','177','919',408,'Retail Sale Id 1272454',15000.96,0.00,0.00,0.00,769.28,'2021-12-04 07:10:33','',''),(2147741,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.04,0.00,'2021-12-04 07:10:33','',''),(2147766,'1','177','919',408,'Retail Sale Id 1272476',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 07:11:51','',''),(2147767,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 07:11:51','',''),(2147783,'1','177','919',408,'Retail Sale Id 1272483',31200.00,0.00,0.00,0.00,1600.00,'2021-12-04 07:12:55','',''),(2147784,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:12:55','',''),(2147823,'1','177','919',408,'Retail Sale Id 1272501',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 07:14:56','',''),(2147824,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:14:56','',''),(2147851,'1','177','919',408,'Retail Sale Id 1272529',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 07:16:11','',''),(2147852,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 07:16:11','',''),(2147900,'1','177','919',408,'Retail Sale Id 1272550',3001.44,0.00,0.00,0.00,153.92,'2021-12-04 07:18:32','',''),(2147901,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-04 07:18:32','',''),(2148036,'1','177','919',408,'Retail Sale Id 1272614',998.40,0.00,0.00,0.00,51.20,'2021-12-04 07:25:40','',''),(2148037,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-04 07:25:40','',''),(2148064,'1','177','919',408,'Retail Sale Id 1272635',6240.00,0.00,0.00,0.00,320.00,'2021-12-04 07:26:56','',''),(2148065,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 07:26:56','',''),(2148106,'1','177','919',408,'Retail Sale Id 1272650',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 07:28:58','',''),(2148107,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:28:58','',''),(2148130,'1','177','919',408,'Retail Sale Id 1272665',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 07:30:01','',''),(2148131,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 07:30:01','',''),(2148176,'1','177','919',408,'Retail Sale Id 1272691',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 07:32:18','',''),(2148177,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 07:32:18','',''),(2148210,'1','177','919',408,'Retail Sale Id 1272714',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 07:33:59','',''),(2148211,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 07:33:59','',''),(2148345,'1','177','919',408,'Retail Sale Id 1272792',6002.88,0.00,0.00,0.00,307.84,'2021-12-04 07:39:55','',''),(2148346,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-04 07:39:55','',''),(2148390,'1','177','919',408,'Retail Sale Id 1272822',31200.00,0.00,0.00,0.00,1600.00,'2021-12-04 07:42:00','',''),(2148391,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:42:00','',''),(2148494,'1','177','919',408,'Retail Sale Id 1272915',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 07:48:46','',''),(2148495,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 07:48:46','',''),(2148533,'1','177','919',408,'Retail Sale Id 1272941',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 07:51:05','',''),(2148534,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 07:51:05','',''),(2148570,'1','177','919',408,'Retail Sale Id 1272969',31200.00,0.00,0.00,0.00,1600.00,'2021-12-04 07:53:50','',''),(2148571,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-04 07:53:50','',''),(2148665,'1','177','919',408,'Retail Sale Id 1273030',28080.00,0.00,0.00,0.00,1440.00,'2021-12-04 07:59:05','',''),(2148666,'1','177','919',408,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-04 07:59:05','',''),(2148835,'1','177','919',408,'Retail Sale Id 1273115',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 08:05:59','',''),(2148836,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 08:05:59','',''),(2148912,'1','177','919',408,'Retail Sale Id 1273165',6240.00,0.00,0.00,0.00,320.00,'2021-12-04 08:09:41','',''),(2148913,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-04 08:09:41','',''),(2149013,'1','177','919',408,'Retail Sale Id 1273214',1248.00,0.00,0.00,0.00,64.00,'2021-12-04 08:13:37','',''),(2149014,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:13:37','',''),(2149174,'1','177','919',408,'Retail Sale Id 1273288',1248.00,0.00,0.00,0.00,64.00,'2021-12-04 08:20:12','',''),(2149175,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 08:20:12','',''),(2149505,'1','177','919',408,'Retail Sale Id 1273534',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 08:33:03','',''),(2149506,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 08:33:03','',''),(2149812,'1','177','919',408,'Retail Sale Id 1273680',6002.88,0.00,0.00,0.00,307.84,'2021-12-04 08:45:26','',''),(2149813,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-04 08:45:26','',''),(2149876,'1','177','919',408,'Retail Sale Id 1273714',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 08:47:56','',''),(2149877,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 08:47:56','',''),(2149918,'1','177','919',408,'Retail Sale Id 1273739',171600.00,0.00,0.00,0.00,8800.00,'2021-12-04 08:50:00','',''),(2149919,'1','177','919',408,'Retail sales',0.00,0.00,0.00,275.00,0.00,'2021-12-04 08:50:00','',''),(2149956,'1','177','919',408,'Retail Sale Id 1273760',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 08:52:07','',''),(2149957,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 08:52:07','',''),(2150521,'1','177','919',408,'Retail Sale Id 1274062',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 09:19:24','',''),(2150522,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:19:24','',''),(2150549,'1','177','919',408,'Retail Sale Id 1274075',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 09:20:28','',''),(2150550,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 09:20:28','',''),(2150575,'1','177','919',408,'Retail Sale Id 1274091',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 09:21:39','',''),(2150576,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 09:21:39','',''),(2150615,'1','177','919',408,'Retail Sale Id 1274109',998.40,0.00,0.00,0.00,51.20,'2021-12-04 09:23:22','',''),(2150616,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-04 09:23:22','',''),(2152428,'1','177','919',408,'Retail Sale Id 1274381',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 10:31:22','',''),(2152429,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:31:22','',''),(2152465,'1','177','919',408,'Retail Sale Id 1274332',62400.00,0.00,0.00,0.00,3200.00,'2021-12-04 10:33:33','',''),(2152466,'1','177','919',408,'Retail sales',0.00,0.00,0.00,100.00,0.00,'2021-12-04 10:33:33','',''),(2152472,'1','177','919',408,'Retail Sale Id 1274394',2496.00,0.00,0.00,0.00,128.00,'2021-12-04 10:34:18','',''),(2152473,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-04 10:34:18','',''),(2152521,'1','177','919',408,'Retail Sale Id 1274419',798.72,0.00,0.00,0.00,40.96,'2021-12-04 10:39:05','',''),(2152522,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-04 10:39:05','',''),(2152551,'1','177','919',408,'Retail Sale Id 1274349',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 10:41:40','',''),(2152552,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:41:40','',''),(2152561,'1','177','919',408,'Retail Sale Id 1274434',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 10:42:29','',''),(2152562,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 10:42:29','',''),(2152638,'1','177','919',408,'Retail Sale Id 1274445',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 10:46:13','',''),(2152639,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:46:13','',''),(2152688,'1','177','919',408,'Retail Sale Id 1274471',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 10:49:39','',''),(2152689,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:49:39','',''),(2152722,'1','177','919',408,'Retail Sale Id 1274492',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 10:51:20','',''),(2152723,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:51:20','',''),(2152742,'1','177','919',408,'Retail Sale Id 1274501',24960.00,0.00,0.00,0.00,1280.00,'2021-12-04 10:52:12','',''),(2152743,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 10:52:12','',''),(2152823,'1','177','919',408,'Retail Sale Id 1274534',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 10:56:33','',''),(2152824,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 10:56:33','',''),(2152839,'1','177','919',408,'Retail Sale Id 1274539',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 10:57:48','',''),(2152840,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 10:57:48','',''),(2152962,'1','177','919',408,'Retail Sale Id 1274597',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 11:03:59','',''),(2152963,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:03:59','',''),(2153040,'1','177','919',408,'Retail Sale Id 1274637',6901.44,0.00,0.00,0.00,353.92,'2021-12-04 11:08:05','',''),(2153041,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.06,0.00,'2021-12-04 11:08:05','',''),(2153070,'1','177','919',408,'Retail Sale Id 1274652',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 11:09:21','',''),(2153071,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 11:09:21','',''),(2153105,'1','177','919',408,'Retail Sale Id 1274669',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 11:11:10','',''),(2153106,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 11:11:10','',''),(2153259,'1','177','919',408,'Retail Sale Id 1274742',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 11:18:13','',''),(2153260,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:18:13','',''),(2153336,'1','177','919',408,'Retail Sale Id 1274782',24960.00,0.00,0.00,0.00,1280.00,'2021-12-04 11:22:26','',''),(2153337,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 11:22:26','',''),(2153387,'1','177','919',408,'Retail Sale Id 1274805',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 11:25:50','',''),(2153390,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:25:50','',''),(2153501,'1','177','919',408,'Retail Sale Id 1274874',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 11:31:49','',''),(2153502,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 11:31:49','',''),(2153509,'1','177','919',408,'Retail Sale Id 1274879',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 11:32:27','',''),(2153510,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 11:32:27','',''),(2153529,'1','177','919',408,'Retail Sale Id 1274890',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 11:33:16','',''),(2153530,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 11:33:16','',''),(2153543,'1','177','919',408,'Retail Sale Id 1274896',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 11:33:50','',''),(2153544,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 11:33:50','',''),(2153572,'1','177','919',408,'Retail Sale Id 1274907',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 11:35:21','',''),(2153573,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:35:21','',''),(2153621,'1','177','919',408,'Retail Sale Id 1274929',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 11:37:36','',''),(2153622,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:37:36','',''),(2153751,'1','177','919',408,'Retail Sale Id 1274953',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 11:44:51','',''),(2153752,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:44:51','',''),(2153774,'1','177','919',408,'Retail Sale Id 1274995',10002.72,0.00,0.00,0.00,512.96,'2021-12-04 11:46:14','',''),(2153775,'1','177','919',408,'Retail sales',0.00,0.00,0.00,16.03,0.00,'2021-12-04 11:46:14','',''),(2153819,'1','177','919',408,'Retail Sale Id 1275014',1248.00,0.00,0.00,0.00,64.00,'2021-12-04 11:48:39','',''),(2153820,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 11:48:39','',''),(2153944,'1','177','919',408,'Retail Sale Id 1275065',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 11:55:33','',''),(2153945,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 11:55:33','',''),(2153960,'1','177','919',408,'Retail Sale Id 1275070',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 11:56:26','',''),(2153961,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 11:56:26','',''),(2153982,'1','177','919',408,'Retail Sale Id 1275079',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 11:58:06','',''),(2153983,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 11:58:06','',''),(2154087,'1','177','919',408,'Retail Sale Id 1275106',3001.44,0.00,0.00,0.00,153.92,'2021-12-04 12:02:21','',''),(2154088,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-04 12:02:21','',''),(2154202,'1','177','919',408,'Retail Sale Id 1275130',698.88,0.00,0.00,0.00,35.84,'2021-12-04 12:06:18','',''),(2154203,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.12,0.00,'2021-12-04 12:06:18','',''),(2154285,'1','177','919',408,'Retail Sale Id 1275139',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 12:10:51','',''),(2154286,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 12:10:51','',''),(2154319,'1','177','919',408,'Retail Sale Id 1275190',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 12:13:08','',''),(2154320,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 12:13:08','',''),(2154341,'1','177','919',408,'Retail Sale Id 1275203',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 12:14:27','',''),(2154342,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:14:27','',''),(2154493,'1','177','919',408,'Retail Sale Id 1275274',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 12:25:27','',''),(2154494,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 12:25:27','',''),(2154525,'1','177','919',408,'Retail Sale Id 1275296',11544.00,0.00,0.00,0.00,592.00,'2021-12-04 12:26:47','',''),(2154526,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-04 12:26:47','',''),(2154571,'1','177','919',408,'Retail Sale Id 1275319',12480.00,0.00,0.00,0.00,640.00,'2021-12-04 12:29:30','',''),(2154572,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-04 12:29:30','',''),(2154625,'1','177','919',408,'Retail Sale Id 1275347',3001.44,0.00,0.00,0.00,153.92,'2021-12-04 12:32:26','',''),(2154626,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-04 12:32:26','',''),(2154659,'1','177','919',408,'Retail Sale Id 1275362',998.40,0.00,0.00,0.00,51.20,'2021-12-04 12:33:56','',''),(2154660,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-04 12:33:56','',''),(2154741,'1','177','919',408,'Retail Sale Id 1275404',4368.00,0.00,0.00,0.00,224.00,'2021-12-04 12:39:32','',''),(2154742,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.00,0.00,'2021-12-04 12:39:32','',''),(2154829,'1','177','919',408,'Retail Sale Id 1275447',998.40,0.00,0.00,0.00,51.20,'2021-12-04 12:47:00','',''),(2154830,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-04 12:47:00','',''),(2154946,'1','177','919',408,'Retail Sale Id 1275489',3001.44,0.00,0.00,0.00,153.92,'2021-12-04 12:53:24','',''),(2154947,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-04 12:53:24','',''),(2154966,'1','177','919',408,'Retail Sale Id 1275505',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 12:54:45','',''),(2154967,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 12:54:45','',''),(2155031,'1','177','919',408,'Retail Sale Id 1275742',1697.28,0.00,0.00,0.00,87.04,'2021-12-04 13:05:31','',''),(2155032,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-04 13:05:31','',''),(2155069,'1','177','919',408,'Retail Sale Id 1275773',10002.72,0.00,0.00,0.00,512.96,'2021-12-04 13:07:58','',''),(2155070,'1','177','919',408,'Retail sales',0.00,0.00,0.00,16.03,0.00,'2021-12-04 13:07:58','',''),(2155125,'1','177','919',408,'Retail Sale Id 1275796',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 13:11:38','',''),(2155126,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 13:11:38','',''),(2155244,'1','177','919',408,'Retail Sale Id 1275844',15600.00,0.00,0.00,0.00,800.00,'2021-12-04 13:19:22','',''),(2155245,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 13:19:22','',''),(2155262,'1','177','919',408,'Retail Sale Id 1275853',1248.00,0.00,0.00,0.00,64.00,'2021-12-04 13:20:35','',''),(2155263,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 13:20:35','',''),(2155461,'1','177',NULL,408,'Purchased from AA RANO NIG LTD.',0.00,1929920.00,3260.00,0.00,0.00,'2021-12-04 13:28:40','',''),(2155480,'1','177',NULL,408,'Reception corrector for bridging 126204',0.00,0.00,0.00,3260.00,0.00,'2021-12-04 13:29:57','',''),(2155481,'1','177','919',408,'Received from bridging 126204',0.00,0.00,3260.00,0.00,0.00,'2021-12-04 13:29:57','',''),(2155612,'1','177','919',408,'Retail Sale Id 1275989',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 13:37:22','',''),(2155613,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:37:22','',''),(2155656,'1','177','919',408,'Retail Sale Id 1276007',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 13:40:02','',''),(2155657,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:40:02','',''),(2155674,'1','177','919',408,'Retail Sale Id 1276019',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 13:41:07','',''),(2155675,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 13:41:07','',''),(2155812,'1','177','919',408,'Retail Sale Id 1276085',4998.24,0.00,0.00,0.00,256.32,'2021-12-04 13:47:58','',''),(2155813,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-04 13:47:58','',''),(2155884,'1','177','919',408,'Retail Sale Id 1276112',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 13:50:31','',''),(2155885,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 13:50:31','',''),(2156003,'1','177','919',408,'Retail Sale Id 1276166',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 13:57:07','',''),(2156004,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 13:57:07','',''),(2156021,'1','177','919',408,'Retail Sale Id 1276177',4998.24,0.00,0.00,0.00,256.32,'2021-12-04 13:58:02','',''),(2156022,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-04 13:58:02','',''),(2156130,'1','177','919',408,'Retail Sale Id 1276217',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 14:02:41','',''),(2156131,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:02:41','',''),(2156146,'1','177','919',408,'Retail Sale Id 1276227',7488.00,0.00,0.00,0.00,384.00,'2021-12-04 14:03:31','',''),(2156147,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 14:03:31','',''),(2156224,'1','177','919',408,'Retail Sale Id 1276255',3001.44,0.00,0.00,0.00,153.92,'2021-12-04 14:05:35','',''),(2156225,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-04 14:05:35','',''),(2156247,'1','177','919',408,'Retail Sale Id 1276267',1697.28,0.00,0.00,0.00,87.04,'2021-12-04 14:06:46','',''),(2156248,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-04 14:06:46','',''),(2156281,'1','177','919',408,'Retail Sale Id 1276288',3999.84,0.00,0.00,0.00,205.12,'2021-12-04 14:08:16','',''),(2156282,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-04 14:08:16','',''),(2156554,'1','177','919',408,'Retail Sale Id 1276422',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 14:21:32','',''),(2156555,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:21:32','',''),(2156639,'1','177','919',408,'Retail Sale Id 1276464',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 14:26:12','',''),(2156640,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 14:26:12','',''),(2156818,'1','177','919',408,'Retail Sale Id 1276551',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 14:36:34','',''),(2156819,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 14:36:34','',''),(2156906,'1','177','919',408,'Retail Sale Id 1276592',7001.28,0.00,0.00,0.00,359.04,'2021-12-04 14:42:02','',''),(2156907,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-04 14:42:02','',''),(2156938,'1','177','919',408,'Retail Sale Id 1276601',1697.28,0.00,0.00,0.00,87.04,'2021-12-04 14:43:11','',''),(2156939,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-04 14:43:11','',''),(2157148,'1','177','919',408,'Retail Sale Id 1276673',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 14:51:48','',''),(2157149,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 14:51:48','',''),(2157227,'1','177','919',408,'Retail Sale Id 1276698',998.40,0.00,0.00,0.00,51.20,'2021-12-04 14:55:49','',''),(2157228,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-04 14:55:49','',''),(2157285,'1','177','919',408,'Retail Sale Id 1276721',3999.84,0.00,0.00,0.00,205.12,'2021-12-04 14:58:35','',''),(2157286,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-04 14:58:35','',''),(2157357,'1','177','919',408,'Retail Sale Id 1276752',3999.84,0.00,0.00,0.00,205.12,'2021-12-04 15:02:24','',''),(2157358,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-04 15:02:24','',''),(2157516,'1','177','919',408,'Retail Sale Id 1276829',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:12:40','',''),(2157517,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:12:40','',''),(2157602,'1','177','919',408,'Retail Sale Id 1276868',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 15:16:26','',''),(2157603,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 15:16:26','',''),(2157642,'1','177','919',408,'Retail Sale Id 1276887',3999.84,0.00,0.00,0.00,205.12,'2021-12-04 15:18:35','',''),(2157643,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-04 15:18:35','',''),(2157694,'1','177','919',408,'Retail Sale Id 1276900',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:20:35','',''),(2157695,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:20:35','',''),(2157750,'1','177','919',408,'Retail Sale Id 1276926',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:23:24','',''),(2157751,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:23:24','',''),(2157814,'1','177','919',408,'Retail Sale Id 1276951',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 15:25:48','',''),(2157815,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 15:25:48','',''),(2157846,'1','177','919',408,'Retail Sale Id 1276970',6502.08,0.00,0.00,0.00,333.44,'2021-12-04 15:26:56','',''),(2157847,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.42,0.00,'2021-12-04 15:26:56','',''),(2157887,'1','177','919',408,'Retail Sale Id 1276986',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 15:28:26','',''),(2157888,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 15:28:26','',''),(2157943,'1','177','919',408,'Retail Sale Id 1277014',499.20,0.00,0.00,0.00,25.60,'2021-12-04 15:31:24','',''),(2157944,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-04 15:31:24','',''),(2158018,'1','177','919',408,'Retail Sale Id 1277048',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:34:42','',''),(2158019,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:34:42','',''),(2158156,'1','177','919',408,'Retail Sale Id 1277116',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:41:44','',''),(2158157,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:41:44','',''),(2158392,'1','177','919',408,'Retail Sale Id 1277222',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:52:56','',''),(2158393,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:52:56','',''),(2158460,'1','177','919',408,'Retail Sale Id 1277263',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 15:56:06','',''),(2158461,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 15:56:06','',''),(2158664,'1','177','919',408,'Retail Sale Id 1277379',15600.00,0.00,0.00,0.00,800.00,'2021-12-04 16:06:32','',''),(2158666,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 16:06:33','',''),(2158825,'1','177','919',408,'Retail Sale Id 1277460',7488.00,0.00,0.00,0.00,384.00,'2021-12-04 16:13:54','',''),(2158826,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-04 16:13:54','',''),(2158871,'1','177','919',408,'Retail Sale Id 1277484',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 16:15:34','',''),(2158872,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:15:34','',''),(2158943,'1','177','919',408,'Retail Sale Id 1277524',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 16:19:11','',''),(2158944,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:19:11','',''),(2158975,'1','177','919',408,'Retail Sale Id 1277539',1397.76,0.00,0.00,0.00,71.68,'2021-12-04 16:21:06','',''),(2158976,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-04 16:21:06','',''),(2159013,'1','177','919',408,'Retail Sale Id 1277559',1248.00,0.00,0.00,0.00,64.00,'2021-12-04 16:22:24','',''),(2159014,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-04 16:22:24','',''),(2159073,'1','177','919',408,'Retail Sale Id 1277595',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 16:25:07','',''),(2159074,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:25:07','',''),(2159115,'1','177','919',408,'Retail Sale Id 1277619',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 16:27:04','',''),(2159116,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 16:27:04','',''),(2159195,'1','177','919',408,'Retail Sale Id 1277660',13728.00,0.00,0.00,0.00,704.00,'2021-12-04 16:30:11','',''),(2159196,'1','177','919',408,'Retail sales',0.00,0.00,0.00,22.00,0.00,'2021-12-04 16:30:11','',''),(2159285,'1','177','919',408,'Retail Sale Id 1277700',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 16:35:15','',''),(2159286,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:35:15','',''),(2159461,'1','177','919',408,'Retail Sale Id 1277764',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 16:41:19','',''),(2159462,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:41:19','',''),(2159487,'1','177','919',408,'Retail Sale Id 1277795',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 16:44:12','',''),(2159488,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 16:44:12','',''),(2159608,'1','177','919',408,'Retail Sale Id 1277882',1896.96,0.00,0.00,0.00,97.28,'2021-12-04 16:49:34','',''),(2159609,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-04 16:49:34','',''),(2159706,'1','177','919',408,'Retail Sale Id 1277926',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 16:54:03','',''),(2159707,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 16:54:04','',''),(2159749,'1','177','919',408,'Retail Sale Id 1277944',15600.00,0.00,0.00,0.00,800.00,'2021-12-04 16:56:47','',''),(2159750,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-04 16:56:47','',''),(2159801,'1','177','919',408,'Retail Sale Id 1277977',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 16:59:54','',''),(2159802,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 16:59:54','',''),(2159893,'1','177','919',408,'Retail Sale Id 1278018',2502.24,0.00,0.00,0.00,128.32,'2021-12-04 17:04:59','',''),(2159894,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-04 17:04:59','',''),(2159987,'1','177','919',408,'Retail Sale Id 1278063',3999.84,0.00,0.00,0.00,205.12,'2021-12-04 17:10:59','',''),(2159988,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-04 17:10:59','',''),(2160037,'1','177','919',408,'Retail Sale Id 1278088',56784.00,0.00,0.00,0.00,2912.00,'2021-12-04 17:14:57','',''),(2160038,'1','177','919',408,'Retail sales',0.00,0.00,0.00,91.00,0.00,'2021-12-04 17:14:57','',''),(2160085,'1','177','919',408,'Retail Sale Id 1278112',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 17:17:45','',''),(2160086,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 17:17:45','',''),(2160103,'1','177','919',408,'Retail Sale Id 1278122',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 17:18:47','',''),(2160104,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:18:47','',''),(2160129,'1','177','919',408,'Retail Sale Id 1278135',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 17:20:39','',''),(2160130,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 17:20:39','',''),(2160197,'1','177','919',408,'Retail Sale Id 1278167',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 17:24:07','',''),(2160198,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:24:07','',''),(2160303,'1','177','919',408,'Retail Sale Id 1278196',1872.00,0.00,0.00,0.00,96.00,'2021-12-04 17:29:03','',''),(2160304,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-04 17:29:03','',''),(2160317,'1','177','919',408,'Retail Sale Id 1278210',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 17:30:19','',''),(2160318,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:30:19','',''),(2160329,'1','177','919',408,'Retail Sale Id 1278215',1497.60,0.00,0.00,0.00,76.80,'2021-12-04 17:31:37','',''),(2160330,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-04 17:31:37','',''),(2160461,'1','177','919',408,'Retail Sale Id 1278265',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 17:40:04','',''),(2160462,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 17:40:04','',''),(2160600,'1','177','919',408,'Retail Sale Id 1278301',24960.00,0.00,0.00,0.00,1280.00,'2021-12-04 17:45:21','',''),(2160601,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-04 17:45:21','',''),(2160733,'1','177','919',408,'Retail Sale Id 1278355',2003.04,0.00,0.00,0.00,102.72,'2021-12-04 17:55:21','',''),(2160734,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-04 17:55:21','',''),(2160827,'1','177','919',408,'Retail Sale Id 1278402',3001.44,0.00,0.00,0.00,153.92,'2021-12-04 18:05:57','',''),(2160828,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-04 18:05:57','',''),(2160861,'1','177','919',408,'Retail Sale Id 1278418',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 18:09:28','',''),(2160862,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 18:09:28','',''),(2160883,'1','177','919',408,'Retail Sale Id 1278431',7800.00,0.00,0.00,0.00,400.00,'2021-12-04 18:13:42','',''),(2160884,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-04 18:13:42','',''),(2160958,'1','177','919',408,'Retail Sale Id 1278470',3120.00,0.00,0.00,0.00,160.00,'2021-12-04 18:25:03','',''),(2160959,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-04 18:25:03','',''),(2161121,'1','177','919',408,'Retail Sale Id 1278536',3744.00,0.00,0.00,0.00,192.00,'2021-12-04 19:00:17','',''),(2161122,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-04 19:00:17','',''),(2161265,'1','177','919',408,'Return of Retail Sale Id 1278301',0.00,24960.00,40.00,0.00,-1280.00,'2021-12-04 19:29:13','',''),(2161266,'1','177','919',408,'Retail Sale Id 1278571',6314.88,0.00,0.00,0.00,323.84,'2021-12-04 19:30:02','',''),(2161267,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.12,0.00,'2021-12-04 19:30:02','',''),(2163880,'1','177','919',408,'Retail Sale Id 1279633',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 08:06:21','',''),(2163881,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 08:06:21','',''),(2163900,'1','177','919',408,'Retail Sale Id 1279651',31200.00,0.00,0.00,0.00,1600.00,'2021-12-05 08:07:29','',''),(2163901,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-05 08:07:29','',''),(2163936,'1','177','919',408,'Retail Sale Id 1279671',3993.60,0.00,0.00,0.00,204.80,'2021-12-05 08:08:47','',''),(2163937,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.40,0.00,'2021-12-05 08:08:47','',''),(2163956,'1','177','919',408,'Retail Sale Id 1279680',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 08:09:46','',''),(2163957,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 08:09:46','',''),(2163980,'1','177','919',408,'Retail Sale Id 1279690',9360.00,0.00,0.00,0.00,480.00,'2021-12-05 08:10:41','',''),(2163981,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-05 08:10:41','',''),(2166393,'1','177','919',408,'Retail Sale Id 1280962',998.40,0.00,0.00,0.00,51.20,'2021-12-05 10:19:10','',''),(2166394,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 10:19:10','',''),(2166411,'1','177','919',408,'Retail Sale Id 1280970',23400.00,0.00,0.00,0.00,1200.00,'2021-12-05 10:20:19','',''),(2166412,'1','177','919',408,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-05 10:20:19','',''),(2166443,'1','177','919',408,'Retail Sale Id 1280987',3999.84,0.00,0.00,0.00,205.12,'2021-12-05 10:22:09','',''),(2166444,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-05 10:22:09','',''),(2166459,'1','177','919',408,'Retail Sale Id 1280994',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:22:47','',''),(2166460,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:22:47','',''),(2166512,'1','177','919',408,'Retail Sale Id 1281020',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:27:00','',''),(2166513,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:27:00','',''),(2166537,'1','177','919',408,'Retail Sale Id 1281032',3999.84,0.00,0.00,0.00,205.12,'2021-12-05 10:28:14','',''),(2166539,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-05 10:28:14','',''),(2166582,'1','177','919',408,'Retail Sale Id 1281052',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:30:43','',''),(2166583,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:30:43','',''),(2166700,'1','177','919',408,'Retail Sale Id 1281118',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:37:51','',''),(2166701,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:37:51','',''),(2166813,'1','177','919',408,'Retail Sale Id 1281177',1497.60,0.00,0.00,0.00,76.80,'2021-12-05 10:44:39','',''),(2166814,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-05 10:44:39','',''),(2166871,'1','177','919',408,'Retail Sale Id 1281210',18720.00,0.00,0.00,0.00,960.00,'2021-12-05 10:47:46','',''),(2166872,'1','177','919',408,'Retail sales',0.00,0.00,0.00,30.00,0.00,'2021-12-05 10:47:46','',''),(2166903,'1','177','919',408,'Retail Sale Id 1281223',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 10:48:55','',''),(2166904,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:48:55','',''),(2166923,'1','177','919',408,'Retail Sale Id 1281236',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:49:47','',''),(2166924,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:49:47','',''),(2166971,'1','177','919',408,'Retail Sale Id 1281262',93600.00,0.00,0.00,0.00,4800.00,'2021-12-05 10:52:51','',''),(2166972,'1','177','919',408,'Retail sales',0.00,0.00,0.00,150.00,0.00,'2021-12-05 10:52:51','',''),(2167003,'1','177','919',408,'Retail Sale Id 1281280',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:55:13','',''),(2167004,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:55:13','',''),(2167037,'1','177','919',408,'Retail Sale Id 1281297',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 10:57:05','',''),(2167038,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 10:57:05','',''),(2167077,'1','177','919',408,'Retail Sale Id 1281312',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 10:58:26','',''),(2167078,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 10:58:26','',''),(2167222,'1','177','919',408,'Retail Sale Id 1281400',15600.00,0.00,0.00,0.00,800.00,'2021-12-05 11:08:02','',''),(2167223,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 11:08:02','',''),(2167252,'1','177','919',408,'Retail Sale Id 1281420',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 11:09:27','',''),(2167253,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:09:27','',''),(2167409,'1','177','919',408,'Retail Sale Id 1281492',2502.24,0.00,0.00,0.00,128.32,'2021-12-05 11:18:34','',''),(2167410,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-05 11:18:34','',''),(2167429,'1','177','919',408,'Retail Sale Id 1281500',6002.88,0.00,0.00,0.00,307.84,'2021-12-05 11:19:53','',''),(2167430,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-05 11:19:53','',''),(2167532,'1','177','919',408,'Retail Sale Id 1281552',998.40,0.00,0.00,0.00,51.20,'2021-12-05 11:26:16','',''),(2167533,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 11:26:16','',''),(2167709,'1','177','919',408,'Retail Sale Id 1281634',2003.04,0.00,0.00,0.00,102.72,'2021-12-05 11:35:08','',''),(2167710,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-05 11:35:08','',''),(2167765,'1','177','919',408,'Retail Sale Id 1281663',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 11:38:43','',''),(2167766,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 11:38:43','',''),(2167822,'1','177','919',408,'Retail Sale Id 1281736',3120.00,0.00,0.00,0.00,160.00,'2021-12-05 11:42:47','',''),(2167823,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 11:42:47','',''),(2167923,'1','177','919',408,'Retail Sale Id 1281787',1497.60,0.00,0.00,0.00,76.80,'2021-12-05 11:48:44','',''),(2167924,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-05 11:48:44','',''),(2167943,'1','177','919',408,'Retail Sale Id 1281805',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 11:49:47','',''),(2167944,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 11:49:47','',''),(2167953,'1','177','919',408,'Retail Sale Id 1281810',499.20,0.00,0.00,0.00,25.60,'2021-12-05 11:50:26','',''),(2167954,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-05 11:50:26','',''),(2168238,'1','177','919',408,'Retail Sale Id 1281957',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 12:06:24','',''),(2168239,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:06:24','',''),(2168287,'1','177','919',408,'Retail Sale Id 1281987',6002.88,0.00,0.00,0.00,307.84,'2021-12-05 12:08:54','',''),(2168288,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-05 12:08:54','',''),(2168309,'1','177','919',408,'Retail Sale Id 1281998',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:10:15','',''),(2168310,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:10:15','',''),(2168332,'1','177','919',408,'Retail Sale Id 1282009',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:11:19','',''),(2168333,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:11:19','',''),(2168480,'1','177','919',408,'Retail Sale Id 1282067',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:17:09','',''),(2168481,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:17:09','',''),(2168583,'1','177','919',408,'Retail Sale Id 1282128',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:21:28','',''),(2168584,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:21:28','',''),(2168752,'1','177','919',408,'Retail Sale Id 1282211',3500.64,0.00,0.00,0.00,179.52,'2021-12-05 12:28:06','',''),(2168753,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-05 12:28:06','',''),(2168802,'1','177','919',408,'Retail Sale Id 1282239',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:30:32','',''),(2168803,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:30:32','',''),(2168886,'1','177','919',408,'Retail Sale Id 1282283',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 12:35:11','',''),(2168887,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 12:35:11','',''),(2168957,'1','177','919',408,'Retail Sale Id 1282321',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:39:02','',''),(2168958,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:39:02','',''),(2168985,'1','177','919',408,'Retail Sale Id 1282336',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 12:40:28','',''),(2168986,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:40:28','',''),(2169023,'1','177','919',408,'Retail Sale Id 1282356',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:42:38','',''),(2169024,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:42:38','',''),(2169071,'1','177','919',408,'Retail Sale Id 1282381',624.00,0.00,0.00,0.00,32.00,'2021-12-05 12:44:58','',''),(2169072,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-05 12:44:58','',''),(2169095,'1','177','919',408,'Retail Sale Id 1282397',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:46:41','',''),(2169096,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:46:41','',''),(2169131,'1','177','919',408,'Retail Sale Id 1282423',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 12:49:10','',''),(2169132,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 12:49:10','',''),(2169183,'1','177','919',408,'Retail Sale Id 1282454',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:52:43','',''),(2169184,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:52:43','',''),(2169231,'1','177','919',408,'Retail Sale Id 1282472',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:55:10','',''),(2169232,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:55:10','',''),(2169249,'1','177','919',408,'Retail Sale Id 1282492',15600.00,0.00,0.00,0.00,800.00,'2021-12-05 12:56:10','',''),(2169250,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 12:56:10','',''),(2169289,'1','177','919',408,'Retail Sale Id 1282509',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 12:58:04','',''),(2169290,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 12:58:04','',''),(2169301,'1','177','919',408,'Retail Sale Id 1282516',1896.96,0.00,0.00,0.00,97.28,'2021-12-05 12:59:19','',''),(2169302,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-05 12:59:19','',''),(2169355,'1','177','919',408,'Retail Sale Id 1282539',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 13:01:10','',''),(2169356,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 13:01:10','',''),(2169391,'1','177','919',408,'Retail Sale Id 1282557',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 13:02:55','',''),(2169392,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:02:55','',''),(2169417,'1','177','919',408,'Retail Sale Id 1282569',1198.08,0.00,0.00,0.00,61.44,'2021-12-05 13:04:19','',''),(2169418,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-05 13:04:19','',''),(2169447,'1','177','919',408,'Retail Sale Id 1282578',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 13:05:45','',''),(2169448,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:05:45','',''),(2169465,'1','177','919',408,'Retail Sale Id 1282620',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 13:07:08','',''),(2169466,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:07:08','',''),(2169482,'1','177','919',408,'Retail Sale Id 1282629',998.40,0.00,0.00,0.00,51.20,'2021-12-05 13:08:07','',''),(2169483,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 13:08:07','',''),(2169508,'1','177','919',408,'Retail Sale Id 1282639',998.40,0.00,0.00,0.00,51.20,'2021-12-05 13:09:15','',''),(2169509,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 13:09:15','',''),(2169574,'1','177','919',408,'Retail Sale Id 1282672',4499.04,0.00,0.00,0.00,230.72,'2021-12-05 13:13:02','',''),(2169575,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-05 13:13:02','',''),(2169744,'1','177','919',408,'Retail Sale Id 1282757',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 13:24:01','',''),(2169745,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 13:24:01','',''),(2169881,'1','177','919',408,'Retail Sale Id 1282814',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 13:31:25','',''),(2169882,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 13:31:25','',''),(2169927,'1','177','919',408,'Retail Sale Id 1282843',7700.16,0.00,0.00,0.00,394.88,'2021-12-05 13:33:49','',''),(2169928,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.34,0.00,'2021-12-05 13:33:49','',''),(2170047,'1','177','919',408,'Retail Sale Id 1282895',2003.04,0.00,0.00,0.00,102.72,'2021-12-05 13:39:34','',''),(2170048,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-05 13:39:34','',''),(2170165,'1','177','919',408,'Retail Sale Id 1282928',1248.00,0.00,0.00,0.00,64.00,'2021-12-05 13:44:15','',''),(2170166,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 13:44:15','',''),(2170210,'1','177','919',408,'Retail Sale Id 1282950',1497.60,0.00,0.00,0.00,76.80,'2021-12-05 13:47:19','',''),(2170211,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-05 13:47:19','',''),(2170489,'1','177','919',408,'Retail Sale Id 1283065',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 14:01:36','',''),(2170490,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:01:36','',''),(2170505,'1','177','919',408,'Retail Sale Id 1283073',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 14:02:42','',''),(2170506,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:02:42','',''),(2170537,'1','177','919',408,'Retail Sale Id 1283092',6002.88,0.00,0.00,0.00,307.84,'2021-12-05 14:04:51','',''),(2170538,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-05 14:04:51','',''),(2170561,'1','177','919',408,'Retail Sale Id 1283099',2496.00,0.00,0.00,0.00,128.00,'2021-12-05 14:06:56','',''),(2170562,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-05 14:06:56','',''),(2170606,'1','177','919',408,'Retail Sale Id 1283123',5928.00,0.00,0.00,0.00,304.00,'2021-12-05 14:09:38','',''),(2170607,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.50,0.00,'2021-12-05 14:09:38','',''),(2170777,'1','177','919',408,'Retail Sale Id 1283182',15600.00,0.00,0.00,0.00,800.00,'2021-12-05 14:16:45','',''),(2170778,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-05 14:16:45','',''),(2170818,'1','177','919',408,'Retail Sale Id 1283202',3999.84,0.00,0.00,0.00,205.12,'2021-12-05 14:18:22','',''),(2170819,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-05 14:18:22','',''),(2170865,'1','177','919',408,'Retail Sale Id 1283222',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 14:20:05','',''),(2170866,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 14:20:05','',''),(2170919,'1','177','919',408,'Retail Sale Id 1283248',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 14:24:19','',''),(2170920,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:24:19','',''),(2171029,'1','177','919',408,'Retail Sale Id 1283298',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 14:30:27','',''),(2171030,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 14:30:27','',''),(2171083,'1','177','919',408,'Retail Sale Id 1283314',499.20,0.00,0.00,0.00,25.60,'2021-12-05 14:32:39','',''),(2171084,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-05 14:32:40','',''),(2171304,'1','177','919',408,'Retail Sale Id 1283383',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 14:43:26','',''),(2171305,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:43:26','',''),(2171339,'1','177','919',408,'Retail Sale Id 1283393',998.40,0.00,0.00,0.00,51.20,'2021-12-05 14:45:21','',''),(2171340,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 14:45:21','',''),(2171389,'1','177','919',408,'Retail Sale Id 1283421',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 14:49:31','',''),(2171390,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 14:49:31','',''),(2171425,'1','177','919',408,'Retail Sale Id 1283439',1497.60,0.00,0.00,0.00,76.80,'2021-12-05 14:51:22','',''),(2171426,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-05 14:51:22','',''),(2171639,'1','177','919',408,'Retail Sale Id 1283546',6240.00,0.00,0.00,0.00,320.00,'2021-12-05 15:07:58','',''),(2171640,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-05 15:07:58','',''),(2171649,'1','177','919',408,'Retail Sale Id 1283552',4992.00,0.00,0.00,0.00,256.00,'2021-12-05 15:08:59','',''),(2171650,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-05 15:08:59','',''),(2171776,'1','177','919',408,'Retail Sale Id 1283614',998.40,0.00,0.00,0.00,51.20,'2021-12-05 15:18:14','',''),(2171777,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 15:18:14','',''),(2171932,'1','177','919',408,'Retail Sale Id 1283693',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 15:29:51','',''),(2171933,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:29:51','',''),(2171987,'1','177','919',408,'Retail Sale Id 1283714',3120.00,0.00,0.00,0.00,160.00,'2021-12-05 15:31:16','',''),(2171988,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 15:31:16','',''),(2172221,'1','177','919',408,'Retail Sale Id 1283830',19999.20,0.00,0.00,0.00,1025.60,'2021-12-05 15:42:48','',''),(2172222,'1','177','919',408,'Retail sales',0.00,0.00,0.00,32.05,0.00,'2021-12-05 15:42:48','',''),(2172249,'1','177','919',408,'Retail Sale Id 1283849',499.20,0.00,0.00,0.00,25.60,'2021-12-05 15:44:42','',''),(2172250,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-05 15:44:42','',''),(2172273,'1','177','919',408,'Retail Sale Id 1283865',3999.84,0.00,0.00,0.00,205.12,'2021-12-05 15:45:39','',''),(2172274,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-05 15:45:39','',''),(2172295,'1','177','919',408,'Retail Sale Id 1283877',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 15:46:48','',''),(2172296,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:46:48','',''),(2172329,'1','177','919',408,'Retail Sale Id 1283895',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 15:48:05','',''),(2172330,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 15:48:05','',''),(2172363,'1','177','919',408,'Retail Sale Id 1283910',998.40,0.00,0.00,0.00,51.20,'2021-12-05 15:49:42','',''),(2172364,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 15:49:42','',''),(2172436,'1','177','919',408,'Retail Sale Id 1283955',3999.84,0.00,0.00,0.00,205.12,'2021-12-05 15:54:48','',''),(2172437,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-05 15:54:48','',''),(2172484,'1','177','919',408,'Retail Sale Id 1283978',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 15:57:26','',''),(2172485,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 15:57:26','',''),(2172584,'1','177','919',408,'Retail Sale Id 1284029',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 16:03:34','',''),(2172585,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:03:34','',''),(2172686,'1','177','919',408,'Retail Sale Id 1284076',3120.00,0.00,0.00,0.00,160.00,'2021-12-05 16:09:26','',''),(2172687,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 16:09:26','',''),(2172706,'1','177','919',408,'Retail Sale Id 1284091',798.72,0.00,0.00,0.00,40.96,'2021-12-05 16:10:57','',''),(2172707,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-05 16:10:57','',''),(2172726,'1','177','919',408,'Retail Sale Id 1284100',998.40,0.00,0.00,0.00,51.20,'2021-12-05 16:12:04','',''),(2172727,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 16:12:04','',''),(2172760,'1','177','919',408,'Retail Sale Id 1284108',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 16:14:04','',''),(2172761,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:14:04','',''),(2172850,'1','177','919',408,'Retail Sale Id 1284168',3001.44,0.00,0.00,0.00,153.92,'2021-12-05 16:20:28','',''),(2172851,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-05 16:20:28','',''),(2172886,'1','177','919',408,'Retail Sale Id 1284189',1248.00,0.00,0.00,0.00,64.00,'2021-12-05 16:22:46','',''),(2172887,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 16:22:46','',''),(2172934,'1','177','919',408,'Retail Sale Id 1284214',2502.24,0.00,0.00,0.00,128.32,'2021-12-05 16:25:24','',''),(2172935,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-05 16:25:24','',''),(2172975,'1','177','919',408,'Retail Sale Id 1284236',1797.12,0.00,0.00,0.00,92.16,'2021-12-05 16:28:34','',''),(2172976,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-05 16:28:34','',''),(2173075,'1','177','919',408,'Retail Sale Id 1284289',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 16:34:18','',''),(2173076,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:34:18','',''),(2173113,'1','177','919',408,'Retail Sale Id 1284308',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 16:36:28','',''),(2173114,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:36:28','',''),(2173141,'1','177','919',408,'Retail Sale Id 1284323',1697.28,0.00,0.00,0.00,87.04,'2021-12-05 16:38:00','',''),(2173142,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-05 16:38:00','',''),(2173171,'1','177','919',408,'Retail Sale Id 1284338',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 16:39:26','',''),(2173172,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:39:26','',''),(2173193,'1','177','919',408,'Retail Sale Id 1284350',1497.60,0.00,0.00,0.00,76.80,'2021-12-05 16:40:51','',''),(2173194,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-05 16:40:51','',''),(2173219,'1','177','919',408,'Retail Sale Id 1284364',1248.00,0.00,0.00,0.00,64.00,'2021-12-05 16:42:34','',''),(2173220,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-05 16:42:34','',''),(2173259,'1','177','919',408,'Retail Sale Id 1284382',3201.12,0.00,0.00,0.00,164.16,'2021-12-05 16:45:14','',''),(2173260,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.13,0.00,'2021-12-05 16:45:14','',''),(2173315,'1','177','919',408,'Retail Sale Id 1284413',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 16:48:52','',''),(2173316,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:48:52','',''),(2173343,'1','177','919',408,'Retail Sale Id 1284428',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 16:50:05','',''),(2173344,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 16:50:05','',''),(2173363,'1','177','919',408,'Retail Sale Id 1284436',998.40,0.00,0.00,0.00,51.20,'2021-12-05 16:51:13','',''),(2173364,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 16:51:13','',''),(2173379,'1','177','919',408,'Retail Sale Id 1284442',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 16:52:30','',''),(2173380,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:52:30','',''),(2173415,'1','177','919',408,'Retail Sale Id 1284464',998.40,0.00,0.00,0.00,51.20,'2021-12-05 16:55:01','',''),(2173416,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 16:55:01','',''),(2173453,'1','177','919',408,'Retail Sale Id 1284480',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 16:57:15','',''),(2173454,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 16:57:15','',''),(2173473,'1','177','919',408,'Retail Sale Id 1284497',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 16:58:32','',''),(2173474,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 16:58:32','',''),(2173502,'1','177','919',408,'Retail Sale Id 1284509',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 17:00:56','',''),(2173503,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:00:56','',''),(2173527,'1','177','919',408,'Retail Sale Id 1284521',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 17:02:40','',''),(2173528,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:02:40','',''),(2173551,'1','177','919',408,'Retail Sale Id 1284533',1497.60,0.00,0.00,0.00,76.80,'2021-12-05 17:04:15','',''),(2173552,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-05 17:04:16','',''),(2173582,'1','177','919',408,'Retail Sale Id 1284540',3120.00,0.00,0.00,0.00,160.00,'2021-12-05 17:05:11','',''),(2173583,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-05 17:05:11','',''),(2173614,'1','177','919',408,'Retail Sale Id 1284556',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 17:07:39','',''),(2173615,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:07:39','',''),(2173640,'1','177','919',408,'Retail Sale Id 1284568',3900.00,0.00,0.00,0.00,200.00,'2021-12-05 17:09:39','',''),(2173641,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-05 17:09:39','',''),(2173744,'1','177','919',408,'Retail Sale Id 1284615',998.40,0.00,0.00,0.00,51.20,'2021-12-05 17:18:34','',''),(2173745,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-05 17:18:34','',''),(2173760,'1','177','919',408,'Retail Sale Id 1284621',1872.00,0.00,0.00,0.00,96.00,'2021-12-05 17:20:13','',''),(2173761,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-05 17:20:13','',''),(2173814,'1','177','919',408,'Retail Sale Id 1284653',8698.56,0.00,0.00,0.00,446.08,'2021-12-05 17:25:06','',''),(2173815,'1','177','919',408,'Retail sales',0.00,0.00,0.00,13.94,0.00,'2021-12-05 17:25:06','',''),(2173960,'1','177','919',408,'Retail Sale Id 1284719',3001.44,0.00,0.00,0.00,153.92,'2021-12-05 17:36:01','',''),(2173961,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-05 17:36:01','',''),(2174008,'1','177','919',408,'Retail Sale Id 1284748',3744.00,0.00,0.00,0.00,192.00,'2021-12-05 17:43:21','',''),(2174009,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-05 17:43:21','',''),(2174060,'1','177','919',408,'Retail Sale Id 1284778',7800.00,0.00,0.00,0.00,400.00,'2021-12-05 17:51:23','',''),(2174061,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-05 17:51:23','',''),(2174402,'1','177','919',408,'Retail Sale Id 1284870',53445.60,0.00,0.00,0.00,2740.80,'2021-12-05 19:45:49','',''),(2174403,'1','177','919',408,'Retail sales',0.00,0.00,0.00,85.65,0.00,'2021-12-05 19:45:49','',''),(2174860,'1','177','919',408,'Retail Sale Id 1284935',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 06:16:44','',''),(2174861,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:16:44','',''),(2174931,'1','177','919',408,'Retail Sale Id 1284973',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 06:26:47','',''),(2174932,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:26:47','',''),(2174951,'1','177','919',408,'Retail Sale Id 1284981',12480.00,0.00,0.00,0.00,640.00,'2021-12-06 06:29:07','',''),(2174952,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 06:29:07','',''),(2175087,'1','177','919',408,'Retail Sale Id 1285021',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 06:39:51','',''),(2175088,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 06:39:51','',''),(2175095,'1','177','919',408,'Retail Sale Id 1285024',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 06:40:43','',''),(2175096,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 06:40:43','',''),(2175101,'1','177','919',408,'Retail Sale Id 1285026',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 06:42:14','',''),(2175102,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:42:14','',''),(2175161,'1','177','919',408,'Retail Sale Id 1285057',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 06:47:11','',''),(2175162,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 06:47:11','',''),(2175187,'1','177','919',408,'Retail Sale Id 1285069',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 06:49:09','',''),(2175188,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:49:09','',''),(2175219,'1','177','919',408,'Retail Sale Id 1285089',3313.44,0.00,0.00,0.00,169.92,'2021-12-06 06:52:01','',''),(2175220,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.31,0.00,'2021-12-06 06:52:01','',''),(2175234,'1','177','919',408,'Retail Sale Id 1285097',6240.00,0.00,0.00,0.00,320.00,'2021-12-06 06:52:53','',''),(2175235,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 06:52:53','',''),(2175256,'1','177','919',408,'Retail Sale Id 1285109',1297.92,0.00,0.00,0.00,66.56,'2021-12-06 06:54:48','',''),(2175257,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-06 06:54:48','',''),(2175334,'1','177','919',408,'Retail Sale Id 1285141',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 06:58:34','',''),(2175335,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 06:58:34','',''),(2175443,'1','177','919',408,'Retail Sale Id 1285175',4998.24,0.00,0.00,0.00,256.32,'2021-12-06 07:03:29','',''),(2175444,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-06 07:03:29','',''),(2175511,'1','177','919',408,'Retail Sale Id 1285208',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 07:09:54','',''),(2175512,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:09:54','',''),(2175862,'1','177','919',408,'Retail Sale Id 1285387',698.88,0.00,0.00,0.00,35.84,'2021-12-06 07:31:21','',''),(2175863,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.12,0.00,'2021-12-06 07:31:21','',''),(2176029,'1','177','919',408,'Retail Sale Id 1285469',9360.00,0.00,0.00,0.00,480.00,'2021-12-06 07:40:51','',''),(2176030,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 07:40:51','',''),(2176204,'1','177','919',408,'Retail Sale Id 1285558',7488.00,0.00,0.00,0.00,384.00,'2021-12-06 07:48:18','',''),(2176205,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.00,0.00,'2021-12-06 07:48:18','',''),(2176359,'1','177','919',408,'Retail Sale Id 1285616',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 07:54:51','',''),(2176360,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 07:54:51','',''),(2176460,'1','177','919',408,'Retail Sale Id 1285662',624.00,0.00,0.00,0.00,32.00,'2021-12-06 07:59:04','',''),(2176461,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-06 07:59:04','',''),(2176782,'1','177','919',408,'Retail Sale Id 1285836',3500.64,0.00,0.00,0.00,179.52,'2021-12-06 08:19:19','',''),(2176783,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-06 08:19:19','',''),(2176834,'1','177','919',408,'Retail Sale Id 1285864',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 08:24:28','',''),(2176835,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 08:24:28','',''),(2177187,'1','177','919',408,'Retail Sale Id 1286037',998.40,0.00,0.00,0.00,51.20,'2021-12-06 08:51:59','',''),(2177188,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 08:51:59','',''),(2177205,'1','177','919',408,'Retail Sale Id 1286046',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 08:53:40','',''),(2177206,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 08:53:40','',''),(2177235,'1','177','919',408,'Retail Sale Id 1286062',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 08:55:44','',''),(2177236,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 08:55:44','',''),(2177379,'1','177','919',408,'Retail Sale Id 1286127',998.40,0.00,0.00,0.00,51.20,'2021-12-06 09:05:40','',''),(2177380,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 09:05:40','',''),(2177430,'1','177','919',408,'Retail Sale Id 1286148',11544.00,0.00,0.00,0.00,592.00,'2021-12-06 09:08:07','',''),(2177431,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-06 09:08:07','',''),(2177610,'1','177','919',408,'Retail Sale Id 1286233',998.40,0.00,0.00,0.00,51.20,'2021-12-06 09:21:14','',''),(2177611,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 09:21:14','',''),(2177974,'1','177','919',408,'Retail Sale Id 1286381',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 09:41:10','',''),(2177975,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 09:41:10','',''),(2178295,'1','177','919',408,'Retail Sale Id 1286544',4998.24,0.00,0.00,0.00,256.32,'2021-12-06 10:03:08','',''),(2178296,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-06 10:03:08','',''),(2178368,'1','177','919',408,'Retail Sale Id 1286573',2502.24,0.00,0.00,0.00,128.32,'2021-12-06 10:06:44','',''),(2178369,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-06 10:06:44','',''),(2178402,'1','177','919',408,'Retail Sale Id 1286587',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 10:08:32','',''),(2178403,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 10:08:32','',''),(2178437,'1','177','919',408,'Retail Sale Id 1286600',998.40,0.00,0.00,0.00,51.20,'2021-12-06 10:09:43','',''),(2178438,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 10:09:43','',''),(2178936,'1','177','919',408,'Retail Sale Id 1286872',6864.00,0.00,0.00,0.00,352.00,'2021-12-06 10:44:26','',''),(2178937,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 10:44:26','',''),(2178988,'1','177','919',408,'Retail Sale Id 1286894',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 10:46:55','',''),(2178989,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 10:46:55','',''),(2179307,'1','177','919',408,'Retail Sale Id 1287087',998.40,0.00,0.00,0.00,51.20,'2021-12-06 11:06:41','',''),(2179308,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 11:06:41','',''),(2179473,'1','177','919',408,'Retail Sale Id 1287169',20592.00,0.00,0.00,0.00,1056.00,'2021-12-06 11:16:19','',''),(2179474,'1','177','919',408,'Retail sales',0.00,0.00,0.00,33.00,0.00,'2021-12-06 11:16:19','',''),(2179579,'1','177','919',408,'Retail Sale Id 1287219',6864.00,0.00,0.00,0.00,352.00,'2021-12-06 11:22:23','',''),(2179580,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 11:22:23','',''),(2179847,'1','177','919',408,'Retail Sale Id 1287375',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 11:43:29','',''),(2179848,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 11:43:29','',''),(2179960,'1','177','919',408,'Retail Sale Id 1287501',1497.60,0.00,0.00,0.00,76.80,'2021-12-06 11:52:25','',''),(2179961,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-06 11:52:25','',''),(2180138,'1','177','919',408,'Retail Sale Id 1287568',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 12:03:31','',''),(2180139,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:03:31','',''),(2180164,'1','177','919',408,'Retail Sale Id 1287599',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 12:04:37','',''),(2180165,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:04:37','',''),(2180190,'1','177','919',408,'Retail Sale Id 1287611',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 12:06:04','',''),(2180191,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 12:06:04','',''),(2180858,'1','177','919',408,'Retail Sale Id 1287973',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 12:47:35','',''),(2180859,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 12:47:35','',''),(2181055,'1','177','919',408,'Retail Sale Id 1288078',1248.00,0.00,0.00,0.00,64.00,'2021-12-06 12:59:01','',''),(2181056,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 12:59:01','',''),(2181100,'1','177','919',408,'Retail Sale Id 1288095',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 13:00:57','',''),(2181101,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:00:57','',''),(2181210,'1','177','919',408,'Retail Sale Id 1288150',6240.00,0.00,0.00,0.00,320.00,'2021-12-06 13:08:08','',''),(2181211,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-06 13:08:08','',''),(2181298,'1','177','919',408,'Retail Sale Id 1288204',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 13:12:40','',''),(2181299,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:12:40','',''),(2181320,'1','177','919',408,'Retail Sale Id 1288210',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 13:13:50','',''),(2181321,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 13:13:50','',''),(2181724,'1','177','919',408,'Retail Sale Id 1288374',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 13:36:47','',''),(2181725,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 13:36:47','',''),(2181750,'1','177','919',408,'Retail Sale Id 1288389',1497.60,0.00,0.00,0.00,76.80,'2021-12-06 13:38:17','',''),(2181751,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-06 13:38:17','',''),(2181770,'1','177','919',408,'Retail Sale Id 1288400',1248.00,0.00,0.00,0.00,64.00,'2021-12-06 13:39:37','',''),(2181771,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-06 13:39:37','',''),(2181812,'1','177','919',408,'Retail Sale Id 1288419',15600.00,0.00,0.00,0.00,800.00,'2021-12-06 13:41:08','',''),(2181813,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-06 13:41:08','',''),(2181879,'1','177','919',408,'Retail Sale Id 1288445',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 13:44:03','',''),(2181880,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 13:44:03','',''),(2181913,'1','177','919',408,'Retail Sale Id 1288463',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 13:45:49','',''),(2181914,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 13:45:49','',''),(2181967,'1','177','919',408,'Retail Sale Id 1288492',6864.00,0.00,0.00,0.00,352.00,'2021-12-06 13:48:48','',''),(2181968,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 13:48:48','',''),(2182055,'1','177','919',408,'Retail Sale Id 1288534',6864.00,0.00,0.00,0.00,352.00,'2021-12-06 13:53:14','',''),(2182056,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-06 13:53:14','',''),(2182105,'1','177','919',408,'Retail Sale Id 1288557',1397.76,0.00,0.00,0.00,71.68,'2021-12-06 13:55:27','',''),(2182106,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-06 13:55:27','',''),(2182139,'1','177','919',408,'Retail Sale Id 1288575',15300.48,0.00,0.00,0.00,784.64,'2021-12-06 13:57:24','',''),(2182140,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.52,0.00,'2021-12-06 13:57:24','',''),(2182225,'1','177','919',408,'Retail Sale Id 1288602',1697.28,0.00,0.00,0.00,87.04,'2021-12-06 14:00:36','',''),(2182226,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-06 14:00:36','',''),(2182275,'1','177','919',408,'Retail Sale Id 1288631',1797.12,0.00,0.00,0.00,92.16,'2021-12-06 14:03:11','',''),(2182276,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-06 14:03:11','',''),(2182307,'1','177','919',408,'Retail Sale Id 1288649',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 14:04:50','',''),(2182308,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:04:50','',''),(2182339,'1','177','919',408,'Retail Sale Id 1288659',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 14:06:21','',''),(2182340,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:06:21','',''),(2182375,'1','177','919',408,'Retail Sale Id 1288677',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 14:08:01','',''),(2182376,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 14:08:01','',''),(2182497,'1','177','919',408,'Retail Sale Id 1288724',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 14:12:39','',''),(2182498,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:12:39','',''),(2182720,'1','177','919',408,'Retail Sale Id 1288831',3500.64,0.00,0.00,0.00,179.52,'2021-12-06 14:23:54','',''),(2182721,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-06 14:23:54','',''),(2182764,'1','177','919',408,'Retail Sale Id 1288855',998.40,0.00,0.00,0.00,51.20,'2021-12-06 14:26:28','',''),(2182765,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 14:26:28','',''),(2182798,'1','177','919',408,'Retail Sale Id 1288871',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 14:28:16','',''),(2182799,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:28:16','',''),(2182942,'1','177','919',408,'Retail Sale Id 1288941',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 14:36:01','',''),(2182943,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 14:36:01','',''),(2183117,'1','177','919',408,'Retail Sale Id 1288997',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 14:44:29','',''),(2183118,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 14:44:29','',''),(2183226,'1','177','919',408,'Retail Sale Id 1289056',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 14:50:12','',''),(2183227,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 14:50:12','',''),(2183279,'1','177','919',408,'Retail Sale Id 1289081',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 14:52:43','',''),(2183280,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 14:52:43','',''),(2183327,'1','177','919',408,'Retail Sale Id 1289097',12480.00,0.00,0.00,0.00,640.00,'2021-12-06 14:54:55','',''),(2183328,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 14:54:55','',''),(2183433,'1','177','919',408,'Retail Sale Id 1289146',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 15:00:27','',''),(2183434,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:00:27','',''),(2183615,'1','177','919',408,'Retail Sale Id 1289243',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 15:10:53','',''),(2183616,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 15:10:53','',''),(2183651,'1','177','919',408,'Retail Sale Id 1289259',998.40,0.00,0.00,0.00,51.20,'2021-12-06 15:13:05','',''),(2183652,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 15:13:05','',''),(2183671,'1','177','919',408,'Retail Sale Id 1289268',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 15:14:07','',''),(2183672,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:14:07','',''),(2183750,'1','177','919',408,'Retail Sale Id 1289303',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 15:18:09','',''),(2183751,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:18:09','',''),(2183774,'1','177','919',408,'Retail Sale Id 1289318',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 15:19:33','',''),(2183775,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:19:33','',''),(2183824,'1','177','919',408,'Retail Sale Id 1289335',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 15:21:16','',''),(2183825,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:21:16','',''),(2183887,'1','177','919',408,'Retail Sale Id 1289359',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 15:23:26','',''),(2183888,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 15:23:26','',''),(2183955,'1','177','919',408,'Retail Sale Id 1289394',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 15:26:21','',''),(2183956,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 15:26:21','',''),(2183992,'1','177','919',408,'Retail Sale Id 1289414',43680.00,0.00,0.00,0.00,2240.00,'2021-12-06 15:28:40','',''),(2183993,'1','177','919',408,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-06 15:28:40','',''),(2184025,'1','177','919',408,'Retail Sale Id 1289430',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 15:30:46','',''),(2184026,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:30:46','',''),(2184047,'1','177','919',408,'Retail Sale Id 1289443',12480.00,0.00,0.00,0.00,640.00,'2021-12-06 15:31:45','',''),(2184048,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 15:31:45','',''),(2184075,'1','177','919',408,'Retail Sale Id 1289457',12480.00,0.00,0.00,0.00,640.00,'2021-12-06 15:33:07','',''),(2184076,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-06 15:33:07','',''),(2184111,'1','177','919',408,'Retail Sale Id 1289470',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 15:35:18','',''),(2184112,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 15:35:18','',''),(2184132,'1','177','919',408,'Retail Sale Id 1289484',998.40,0.00,0.00,0.00,51.20,'2021-12-06 15:36:35','',''),(2184133,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 15:36:35','',''),(2184187,'1','177','919',408,'Retail Sale Id 1289509',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 15:38:46','',''),(2184188,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 15:38:46','',''),(2184236,'1','177','919',408,'Retail Sale Id 1289520',1497.60,0.00,0.00,0.00,76.80,'2021-12-06 15:40:11','',''),(2184237,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-06 15:40:11','',''),(2184274,'1','177','919',408,'Retail Sale Id 1289531',1797.12,0.00,0.00,0.00,92.16,'2021-12-06 15:41:17','',''),(2184275,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-06 15:41:17','',''),(2184341,'1','177','919',408,'Retail Sale Id 1289546',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 15:43:24','',''),(2184342,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:43:24','',''),(2184385,'1','177','919',408,'Retail Sale Id 1289565',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 15:44:49','',''),(2184386,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:44:49','',''),(2184448,'1','177','919',408,'Retail Sale Id 1289587',199.68,0.00,0.00,0.00,10.24,'2021-12-06 15:47:01','',''),(2184449,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.32,0.00,'2021-12-06 15:47:01','',''),(2184475,'1','177','919',408,'Retail Sale Id 1289598',1560.00,0.00,0.00,0.00,80.00,'2021-12-06 15:48:42','',''),(2184476,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.50,0.00,'2021-12-06 15:48:42','',''),(2184506,'1','177','919',408,'Retail Sale Id 1289616',7500.48,0.00,0.00,0.00,384.64,'2021-12-06 15:50:06','',''),(2184507,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-06 15:50:06','',''),(2184534,'1','177','919',408,'Retail Sale Id 1289630',1797.12,0.00,0.00,0.00,92.16,'2021-12-06 15:51:35','',''),(2184535,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-06 15:51:35','',''),(2184572,'1','177','919',408,'Retail Sale Id 1289649',2502.24,0.00,0.00,0.00,128.32,'2021-12-06 15:53:44','',''),(2184573,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-06 15:53:44','',''),(2184594,'1','177','919',408,'Retail Sale Id 1289657',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 15:54:44','',''),(2184595,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 15:54:44','',''),(2184609,'1','177','919',408,'Retail Sale Id 1289663',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 15:55:40','',''),(2184610,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 15:55:40','',''),(2184636,'1','177','919',408,'Retail Sale Id 1289678',2496.00,0.00,0.00,0.00,128.00,'2021-12-06 15:57:03','',''),(2184637,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 15:57:03','',''),(2184675,'1','177','919',408,'Retail Sale Id 1289697',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 15:58:57','',''),(2184676,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 15:58:57','',''),(2184698,'1','177','919',408,'Retail Sale Id 1289708',2496.00,0.00,0.00,0.00,128.00,'2021-12-06 16:00:18','',''),(2184699,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-06 16:00:18','',''),(2184750,'1','177','919',408,'Retail Sale Id 1289732',1497.60,0.00,0.00,0.00,76.80,'2021-12-06 16:03:36','',''),(2184751,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-06 16:03:36','',''),(2184811,'1','177','919',408,'Retail Sale Id 1289757',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 16:06:47','',''),(2184812,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:06:47','',''),(2184932,'1','177','919',408,'Retail Sale Id 1289813',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 16:15:52','',''),(2184933,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:15:52','',''),(2184999,'1','177','919',408,'Retail Sale Id 1289843',998.40,0.00,0.00,0.00,51.20,'2021-12-06 16:19:07','',''),(2185000,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 16:19:07','',''),(2185018,'1','177','919',408,'Retail Sale Id 1289858',1497.60,0.00,0.00,0.00,76.80,'2021-12-06 16:20:07','',''),(2185019,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-06 16:20:07','',''),(2185039,'1','177','919',408,'Retail Sale Id 1289867',3500.64,0.00,0.00,0.00,179.52,'2021-12-06 16:21:11','',''),(2185040,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-06 16:21:11','',''),(2185063,'1','177','919',408,'Retail Sale Id 1289880',6.24,0.00,0.00,0.00,0.32,'2021-12-06 16:22:15','',''),(2185064,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.01,0.00,'2021-12-06 16:22:15','',''),(2185095,'1','177','919',408,'Retail Sale Id 1289893',998.40,0.00,0.00,0.00,51.20,'2021-12-06 16:23:37','',''),(2185096,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 16:23:37','',''),(2185139,'1','177','919',408,'Retail Sale Id 1289915',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 16:26:12','',''),(2185140,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:26:12','',''),(2185316,'1','177','919',408,'Retail Sale Id 1290003',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 16:34:52','',''),(2185317,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 16:34:52','',''),(2185344,'1','177','919',408,'Retail Sale Id 1290017',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 16:36:29','',''),(2185345,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 16:36:29','',''),(2185358,'1','177','919',408,'Retail Sale Id 1290023',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 16:37:25','',''),(2185359,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:37:25','',''),(2185397,'1','177','919',408,'Retail Sale Id 1290041',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 16:39:36','',''),(2185398,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 16:39:36','',''),(2185442,'1','177','919',408,'Retail Sale Id 1290059',3600.48,0.00,0.00,0.00,184.64,'2021-12-06 16:41:55','',''),(2185443,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.77,0.00,'2021-12-06 16:41:55','',''),(2185464,'1','177','919',408,'Retail Sale Id 1290071',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 16:43:34','',''),(2185465,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 16:43:34','',''),(2185551,'1','177','919',408,'Retail Sale Id 1290111',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 16:47:54','',''),(2185552,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:47:54','',''),(2185587,'1','177','919',408,'Retail Sale Id 1290126',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 16:49:25','',''),(2185588,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:49:25','',''),(2185670,'1','177','919',408,'Retail Sale Id 1290171',16997.76,0.00,0.00,0.00,871.68,'2021-12-06 16:53:37','',''),(2185671,'1','177','919',408,'Retail sales',0.00,0.00,0.00,27.24,0.00,'2021-12-06 16:53:37','',''),(2185680,'1','177','919',408,'Retail Sale Id 1290177',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 16:54:33','',''),(2185681,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 16:54:33','',''),(2185696,'1','177','919',408,'Retail Sale Id 1290192',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 16:55:39','',''),(2185697,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 16:55:39','',''),(2185710,'1','177','919',408,'Retail Sale Id 1290197',13416.00,0.00,0.00,0.00,688.00,'2021-12-06 16:56:41','',''),(2185711,'1','177','919',408,'Retail sales',0.00,0.00,0.00,21.50,0.00,'2021-12-06 16:56:41','',''),(2185730,'1','177','919',408,'Retail Sale Id 1290207',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 16:57:43','',''),(2185731,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 16:57:43','',''),(2185748,'1','177','919',408,'Retail Sale Id 1290215',5304.00,0.00,0.00,0.00,272.00,'2021-12-06 16:59:15','',''),(2185749,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.50,0.00,'2021-12-06 16:59:15','',''),(2185766,'1','177','919',408,'Retail Sale Id 1290228',9672.00,0.00,0.00,0.00,496.00,'2021-12-06 17:00:33','',''),(2185767,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-06 17:00:33','',''),(2185794,'1','177','919',408,'Retail Sale Id 1290244',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 17:02:19','',''),(2185795,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 17:02:19','',''),(2185808,'1','177','919',408,'Retail Sale Id 1290252',4499.04,0.00,0.00,0.00,230.72,'2021-12-06 17:03:37','',''),(2185809,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-06 17:03:37','',''),(2185832,'1','177','919',408,'Retail Sale Id 1290264',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 17:04:48','',''),(2185833,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 17:04:48','',''),(2185838,'1','177','919',408,'Retail Sale Id 1290267',31200.00,0.00,0.00,0.00,1600.00,'2021-12-06 17:05:42','',''),(2185839,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 17:05:42','',''),(2185865,'1','177','919',408,'Retail Sale Id 1290279',998.40,0.00,0.00,0.00,51.20,'2021-12-06 17:07:14','',''),(2185866,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 17:07:14','',''),(2185875,'1','177','919',408,'Retail Sale Id 1290284',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 17:08:05','',''),(2185876,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 17:08:05','',''),(2185889,'1','177','919',408,'Retail Sale Id 1290291',698.88,0.00,0.00,0.00,35.84,'2021-12-06 17:08:56','',''),(2185890,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.12,0.00,'2021-12-06 17:08:56','',''),(2185917,'1','177','919',408,'Retail Sale Id 1290307',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 17:10:32','',''),(2185918,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 17:10:32','',''),(2185929,'1','177','919',408,'Retail Sale Id 1290314',998.40,0.00,0.00,0.00,51.20,'2021-12-06 17:11:26','',''),(2185930,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 17:11:26','',''),(2185937,'1','177','919',408,'Retail Sale Id 1290319',15288.00,0.00,0.00,0.00,784.00,'2021-12-06 17:12:04','',''),(2185938,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.50,0.00,'2021-12-06 17:12:04','',''),(2185957,'1','177','919',408,'Retail Sale Id 1290330',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 17:12:59','',''),(2185958,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 17:12:59','',''),(2185971,'1','177','919',408,'Retail Sale Id 1290338',13104.00,0.00,0.00,0.00,672.00,'2021-12-06 17:14:02','',''),(2185972,'1','177','919',408,'Retail sales',0.00,0.00,0.00,21.00,0.00,'2021-12-06 17:14:02','',''),(2186025,'1','177','919',408,'Retail Sale Id 1290368',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 17:19:47','',''),(2186026,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:19:47','',''),(2186080,'1','177','919',408,'Retail Sale Id 1290391',1497.60,0.00,0.00,0.00,76.80,'2021-12-06 17:25:11','',''),(2186081,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-06 17:25:11','',''),(2186186,'1','177','919',408,'Retail Sale Id 1290440',998.40,0.00,0.00,0.00,51.20,'2021-12-06 17:35:13','',''),(2186187,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 17:35:13','',''),(2186249,'1','177','919',408,'Retail Sale Id 1290472',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 17:41:12','',''),(2186250,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:41:12','',''),(2186271,'1','177','919',408,'Retail Sale Id 1290501',3744.00,0.00,0.00,0.00,192.00,'2021-12-06 17:45:35','',''),(2186272,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-06 17:45:35','',''),(2186300,'1','177','919',408,'Retail Sale Id 1290517',1872.00,0.00,0.00,0.00,96.00,'2021-12-06 17:48:51','',''),(2186301,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-06 17:48:51','',''),(2186313,'1','177','919',408,'Retail Sale Id 1290523',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 17:50:26','',''),(2186314,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 17:50:26','',''),(2186323,'1','177','919',408,'Retail Sale Id 1290528',998.40,0.00,0.00,0.00,51.20,'2021-12-06 17:51:50','',''),(2186324,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 17:51:50','',''),(2186345,'1','177','919',408,'Retail Sale Id 1290537',998.40,0.00,0.00,0.00,51.20,'2021-12-06 17:54:39','',''),(2186346,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-06 17:54:39','',''),(2186364,'1','177','919',408,'Retail Sale Id 1290547',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 17:58:00','',''),(2186365,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 17:58:00','',''),(2186380,'1','177','919',408,'Retail Sale Id 1290553',70200.00,0.00,0.00,0.00,3600.00,'2021-12-06 18:00:50','',''),(2186381,'1','177','919',408,'Retail sales',0.00,0.00,0.00,112.50,0.00,'2021-12-06 18:00:50','',''),(2186454,'1','177','919',408,'Retail Sale Id 1290561',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 18:13:52','',''),(2186455,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 18:13:52','',''),(2186471,'1','177','919',408,'Retail Sale Id 1290564',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 18:16:09','',''),(2186472,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 18:16:09','',''),(2186491,'1','177','919',408,'Retail Sale Id 1290565',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 18:17:59','',''),(2186492,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 18:17:59','',''),(2186499,'1','177','919',408,'Retail Sale Id 1290568',9360.00,0.00,0.00,0.00,480.00,'2021-12-06 18:23:55','',''),(2186500,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-06 18:23:55','',''),(2186511,'1','177','919',408,'Retail Sale Id 1290570',2003.04,0.00,0.00,0.00,102.72,'2021-12-06 18:31:31','',''),(2186512,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-06 18:31:31','',''),(2186521,'1','177','919',408,'Retail Sale Id 1290573',7176.00,0.00,0.00,0.00,368.00,'2021-12-06 18:39:30','',''),(2186522,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.50,0.00,'2021-12-06 18:39:30','',''),(2186527,'1','177','919',408,'Retail Sale Id 1290577',7800.00,0.00,0.00,0.00,400.00,'2021-12-06 18:45:08','',''),(2186528,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-06 18:45:08','',''),(2186531,'1','177','919',408,'Retail Sale Id 1290578',3001.44,0.00,0.00,0.00,153.92,'2021-12-06 18:50:30','',''),(2186532,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-06 18:50:30','',''),(2186546,'1','177','919',408,'Retail Sale Id 1290581',4992.00,0.00,0.00,0.00,256.00,'2021-12-06 18:58:47','',''),(2186547,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-06 18:58:47','',''),(2186572,'1','177','919',408,'Retail Sale Id 1290590',31200.00,0.00,0.00,0.00,1600.00,'2021-12-06 19:07:45','',''),(2186573,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-06 19:07:45','',''),(2186590,'1','177','919',408,'Retail Sale Id 1290592',3120.00,0.00,0.00,0.00,160.00,'2021-12-06 19:29:36','',''),(2186591,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-06 19:29:36','',''),(2186609,'1','177','919',408,'Return of Retail Sale Id 1287973',0.00,7800.00,12.50,0.00,-400.00,'2021-12-06 19:43:27','',''),(2186619,'1','177','919',408,'Retail Sale Id 1290594',2371.20,0.00,0.00,0.00,121.60,'2021-12-06 19:44:16','',''),(2186620,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.80,0.00,'2021-12-06 19:44:16','',''),(2187041,'1','177','919',408,'Retail Sale Id 1290616',998.40,0.00,0.00,0.00,51.20,'2021-12-07 05:31:01','',''),(2187042,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 05:31:01','',''),(2187067,'1','177','919',408,'Retail Sale Id 1290624',499.20,0.00,0.00,0.00,25.60,'2021-12-07 05:44:08','',''),(2187068,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-07 05:44:08','',''),(2187194,'1','177','919',408,'Retail Sale Id 1290685',15600.00,0.00,0.00,0.00,800.00,'2021-12-07 06:05:16','',''),(2187195,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 06:05:16','',''),(2187456,'1','177','919',408,'Retail Sale Id 1290814',3500.64,0.00,0.00,0.00,179.52,'2021-12-07 06:28:15','',''),(2187457,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-07 06:28:15','',''),(2187621,'1','177','919',408,'Retail Sale Id 1290898',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 06:40:41','',''),(2187622,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:40:41','',''),(2187840,'1','177','919',408,'Retail Sale Id 1290994',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 06:53:58','',''),(2187841,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 06:53:58','',''),(2187912,'1','177','919',408,'Retail Sale Id 1291029',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 06:59:03','',''),(2187913,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 06:59:03','',''),(2188010,'1','177','919',408,'Retail Sale Id 1291081',4992.00,0.00,0.00,0.00,256.00,'2021-12-07 07:04:01','',''),(2188011,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-07 07:04:02','',''),(2188112,'1','177','919',408,'Retail Sale Id 1291126',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 07:08:49','',''),(2188113,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 07:08:49','',''),(2188208,'1','177','919',408,'Retail Sale Id 1291178',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 07:13:24','',''),(2188209,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 07:13:24','',''),(2188242,'1','177','919',408,'Retail Sale Id 1291191',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 07:14:53','',''),(2188243,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 07:14:53','',''),(2188593,'1','177','919',408,'Retail Sale Id 1291369',45177.60,0.00,0.00,0.00,2316.80,'2021-12-07 07:31:07','',''),(2188594,'1','177','919',408,'Retail sales',0.00,0.00,0.00,72.40,0.00,'2021-12-07 07:31:07','',''),(2189695,'1','177','919',408,'Retail Sale Id 1291933',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 08:33:33','',''),(2189696,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 08:33:33','',''),(2191732,'1','177','919',408,'Return of Retail Sale Id 1291933',0.00,7800.00,12.50,0.00,-400.00,'2021-12-07 10:33:33','',''),(2191743,'1','177','919',408,'Retail Sale Id 1292921',318.24,0.00,0.00,0.00,16.32,'2021-12-07 10:34:21','',''),(2191744,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.51,0.00,'2021-12-07 10:34:21','',''),(2191799,'1','177','919',408,'Retail Sale Id 1292950',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 10:38:03','',''),(2191800,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:38:03','',''),(2191867,'1','177','919',408,'Retail Sale Id 1292983',6240.00,0.00,0.00,0.00,320.00,'2021-12-07 10:41:32','',''),(2191868,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 10:41:32','',''),(2191933,'1','177','919',408,'Retail Sale Id 1293013',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 10:45:17','',''),(2191934,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 10:45:17','',''),(2191984,'1','177','919',408,'Retail Sale Id 1293031',2003.04,0.00,0.00,0.00,102.72,'2021-12-07 10:47:25','',''),(2191985,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-07 10:47:25','',''),(2192018,'1','177','919',408,'Retail Sale Id 1293041',8736.00,0.00,0.00,0.00,448.00,'2021-12-07 10:48:33','',''),(2192019,'1','177','919',408,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-07 10:48:33','',''),(2192052,'1','177','919',408,'Retail Sale Id 1293063',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 10:51:00','',''),(2192053,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 10:51:00','',''),(2192098,'1','177','919',408,'Retail Sale Id 1293090',4998.24,0.00,0.00,0.00,256.32,'2021-12-07 10:53:06','',''),(2192099,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-07 10:53:06','',''),(2192156,'1','177',NULL,408,'Purchased from AA RANO NIG LTD.',0.00,3001440.00,5070.00,0.00,0.00,'2021-12-07 10:56:25','',''),(2192177,'1','177',NULL,408,'Reception corrector for bridging 126460',0.00,0.00,0.00,5070.00,0.00,'2021-12-07 10:57:33','',''),(2192178,'1','177','919',408,'Received from bridging 126460',0.00,0.00,5070.00,0.00,0.00,'2021-12-07 10:57:33','',''),(2192185,'1','177','919',408,'Retail Sale Id 1293127',6240.00,0.00,0.00,0.00,320.00,'2021-12-07 10:58:09','',''),(2192186,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-07 10:58:09','',''),(2192528,'1','177','919',408,'Retail Sale Id 1293298',31200.00,0.00,0.00,0.00,1600.00,'2021-12-07 11:16:03','',''),(2192529,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 11:16:03','',''),(2192787,'1','177','919',408,'Retail Sale Id 1293455',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 11:35:03','',''),(2192788,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 11:35:03','',''),(2192873,'1','177','919',408,'Retail Sale Id 1293502',1248.00,0.00,0.00,0.00,64.00,'2021-12-07 11:41:05','',''),(2192874,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 11:41:05','',''),(2193021,'1','177','919',408,'Retail Sale Id 1293565',15600.00,0.00,0.00,0.00,800.00,'2021-12-07 11:51:02','',''),(2193022,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 11:51:02','',''),(2193059,'1','177','919',408,'Retail Sale Id 1293592',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 11:54:24','',''),(2193060,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:54:24','',''),(2193123,'1','177','919',408,'Retail Sale Id 1293623',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 11:59:47','',''),(2193124,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 11:59:47','',''),(2193169,'1','177','919',408,'Retail Sale Id 1293648',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 12:04:47','',''),(2193170,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:04:47','',''),(2193215,'1','177','919',408,'Retail Sale Id 1293680',4998.24,0.00,0.00,0.00,256.32,'2021-12-07 12:10:35','',''),(2193216,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-07 12:10:35','',''),(2193305,'1','177','919',408,'Retail Sale Id 1293726',998.40,0.00,0.00,0.00,51.20,'2021-12-07 12:16:49','',''),(2193306,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 12:16:49','',''),(2193317,'1','177','919',408,'Retail Sale Id 1293732',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 12:17:48','',''),(2193318,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:17:48','',''),(2193343,'1','177','919',408,'Retail Sale Id 1293751',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 12:19:26','',''),(2193344,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 12:19:26','',''),(2193361,'1','177','919',408,'Retail Sale Id 1293759',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 12:21:26','',''),(2193362,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 12:21:26','',''),(2193461,'1','177','919',408,'Retail Sale Id 1293811',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 12:31:15','',''),(2193462,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:31:15','',''),(2193557,'1','177','919',408,'Retail Sale Id 1293862',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 12:38:36','',''),(2193558,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 12:38:36','',''),(2193587,'1','177','919',408,'Retail Sale Id 1293878',17160.00,0.00,0.00,0.00,880.00,'2021-12-07 12:41:15','',''),(2193588,'1','177','919',408,'Retail sales',0.00,0.00,0.00,27.50,0.00,'2021-12-07 12:41:15','',''),(2193620,'1','177','919',408,'Retail Sale Id 1293892',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 12:43:56','',''),(2193621,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 12:43:56','',''),(2193633,'1','177','919',408,'Retail Sale Id 1293899',15600.00,0.00,0.00,0.00,800.00,'2021-12-07 12:45:11','',''),(2193634,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 12:45:11','',''),(2193705,'1','177','919',408,'Retail Sale Id 1293949',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 12:50:32','',''),(2193706,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 12:50:32','',''),(2193743,'1','177','919',408,'Retail Sale Id 1293970',14976.00,0.00,0.00,0.00,768.00,'2021-12-07 12:52:03','',''),(2193744,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-07 12:52:03','',''),(2193905,'1','177','919',408,'Retail Sale Id 1294049',3101.28,0.00,0.00,0.00,159.04,'2021-12-07 13:02:00','',''),(2193906,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.97,0.00,'2021-12-07 13:02:00','',''),(2193962,'1','177','919',408,'Retail Sale Id 1294076',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 13:06:23','',''),(2193963,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 13:06:23','',''),(2193982,'1','177','919',408,'Retail Sale Id 1294088',998.40,0.00,0.00,0.00,51.20,'2021-12-07 13:08:12','',''),(2193983,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 13:08:12','',''),(2194041,'1','177','919',408,'Retail Sale Id 1294115',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 13:11:53','',''),(2194042,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:11:53','',''),(2194163,'1','177','919',408,'Retail Sale Id 1294180',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 13:19:34','',''),(2194164,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 13:19:34','',''),(2194243,'1','177','919',408,'Retail Sale Id 1294215',79622.40,0.00,0.00,0.00,4083.20,'2021-12-07 13:25:01','',''),(2194244,'1','177','919',408,'Retail sales',0.00,0.00,0.00,127.60,0.00,'2021-12-07 13:25:01','',''),(2194282,'1','177','919',408,'Retail Sale Id 1294293',3999.84,0.00,0.00,0.00,205.12,'2021-12-07 13:26:08','',''),(2194283,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-07 13:26:08','',''),(2194313,'1','177','919',408,'Retail Sale Id 1294327',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 13:27:27','',''),(2194314,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:27:27','',''),(2194332,'1','177','919',408,'Retail Sale Id 1294341',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 13:28:31','',''),(2194333,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:28:31','',''),(2194381,'1','177','919',408,'Retail Sale Id 1294349',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 13:29:44','',''),(2194382,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 13:29:44','',''),(2194404,'1','177','919',408,'Retail Sale Id 1294361',28080.00,0.00,0.00,0.00,1440.00,'2021-12-07 13:31:14','',''),(2194405,'1','177','919',408,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-07 13:31:14','',''),(2194437,'1','177','919',408,'Retail Sale Id 1294374',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 13:33:33','',''),(2194438,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 13:33:33','',''),(2194465,'1','177','919',408,'Retail Sale Id 1294384',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 13:35:00','',''),(2194466,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 13:35:00','',''),(2194561,'1','177','919',408,'Retail Sale Id 1294425',998.40,0.00,0.00,0.00,51.20,'2021-12-07 13:40:00','',''),(2194562,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 13:40:00','',''),(2194589,'1','177','919',408,'Retail Sale Id 1294438',2502.24,0.00,0.00,0.00,128.32,'2021-12-07 13:41:40','',''),(2194590,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-07 13:41:40','',''),(2194635,'1','177','919',408,'Retail Sale Id 1294462',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 13:45:40','',''),(2194636,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 13:45:40','',''),(2194670,'1','177','919',408,'Retail Sale Id 1294476',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 13:47:45','',''),(2194671,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:47:45','',''),(2194722,'1','177','919',408,'Retail Sale Id 1294495',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 13:50:03','',''),(2194723,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 13:50:03','',''),(2194745,'1','177','919',408,'Retail Sale Id 1294501',3900.00,0.00,0.00,0.00,200.00,'2021-12-07 13:51:44','',''),(2194746,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-07 13:51:44','',''),(2194766,'1','177','919',408,'Retail Sale Id 1294514',1896.96,0.00,0.00,0.00,97.28,'2021-12-07 13:52:55','',''),(2194767,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-07 13:52:55','',''),(2194794,'1','177','919',408,'Retail Sale Id 1294531',15600.00,0.00,0.00,0.00,800.00,'2021-12-07 13:54:45','',''),(2194795,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 13:54:45','',''),(2194827,'1','177','919',408,'Retail Sale Id 1294548',43680.00,0.00,0.00,0.00,2240.00,'2021-12-07 13:57:07','',''),(2194828,'1','177','919',408,'Retail sales',0.00,0.00,0.00,70.00,0.00,'2021-12-07 13:57:07','',''),(2194925,'1','177','919',408,'Retail Sale Id 1294600',8998.08,0.00,0.00,0.00,461.44,'2021-12-07 14:04:11','',''),(2194926,'1','177','919',408,'Retail sales',0.00,0.00,0.00,14.42,0.00,'2021-12-07 14:04:11','',''),(2194939,'1','177','919',408,'Retail Sale Id 1294607',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 14:05:16','',''),(2194940,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:05:16','',''),(2195041,'1','177','919',408,'Retail Sale Id 1294657',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 14:10:49','',''),(2195042,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:10:49','',''),(2195089,'1','177','919',408,'Retail Sale Id 1294673',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 14:12:45','',''),(2195090,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 14:12:45','',''),(2195174,'1','177','919',408,'Retail Sale Id 1294694',31200.00,0.00,0.00,0.00,1600.00,'2021-12-07 14:16:16','',''),(2195175,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-07 14:16:16','',''),(2195199,'1','177','919',408,'Retail Sale Id 1294690',648.96,0.00,0.00,0.00,33.28,'2021-12-07 14:18:14','',''),(2195200,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.04,0.00,'2021-12-07 14:18:14','',''),(2195218,'1','177','919',408,'Retail Sale Id 1294713',6002.88,0.00,0.00,0.00,307.84,'2021-12-07 14:19:23','',''),(2195219,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-07 14:19:23','',''),(2195276,'1','177','919',408,'Retail Sale Id 1294740',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 14:22:49','',''),(2195277,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:22:49','',''),(2195320,'1','177','919',408,'Retail Sale Id 1294767',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 14:25:09','',''),(2195321,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:25:09','',''),(2195348,'1','177','919',408,'Retail Sale Id 1294777',798.72,0.00,0.00,0.00,40.96,'2021-12-07 14:26:25','',''),(2195349,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-07 14:26:25','',''),(2195380,'1','177','919',408,'Retail Sale Id 1294793',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 14:27:57','',''),(2195381,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:27:57','',''),(2195401,'1','177','919',408,'Retail Sale Id 1294804',17472.00,0.00,0.00,0.00,896.00,'2021-12-07 14:29:20','',''),(2195402,'1','177','919',408,'Retail sales',0.00,0.00,0.00,28.00,0.00,'2021-12-07 14:29:20','',''),(2195426,'1','177','919',408,'Retail Sale Id 1294811',7001.28,0.00,0.00,0.00,359.04,'2021-12-07 14:30:27','',''),(2195427,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-07 14:30:27','',''),(2195444,'1','177','919',408,'Retail Sale Id 1294820',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 14:31:44','',''),(2195445,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 14:31:44','',''),(2195471,'1','177','919',408,'Retail Sale Id 1294830',3999.84,0.00,0.00,0.00,205.12,'2021-12-07 14:33:26','',''),(2195472,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-07 14:33:26','',''),(2195507,'1','177','919',408,'Retail Sale Id 1294868',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 14:35:43','',''),(2195508,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 14:35:43','',''),(2195533,'1','177','919',408,'Retail Sale Id 1294881',3700.32,0.00,0.00,0.00,189.76,'2021-12-07 14:36:57','',''),(2195534,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.93,0.00,'2021-12-07 14:36:57','',''),(2195551,'1','177','919',408,'Retail Sale Id 1294891',11999.52,0.00,0.00,0.00,615.36,'2021-12-07 14:38:02','',''),(2195552,'1','177','919',408,'Retail sales',0.00,0.00,0.00,19.23,0.00,'2021-12-07 14:38:02','',''),(2195571,'1','177','919',408,'Retail Sale Id 1294901',2402.40,0.00,0.00,0.00,123.20,'2021-12-07 14:39:29','',''),(2195572,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.85,0.00,'2021-12-07 14:39:29','',''),(2195599,'1','177','919',408,'Retail Sale Id 1294918',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 14:41:29','',''),(2195600,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 14:41:29','',''),(2195635,'1','177','919',408,'Retail Sale Id 1294933',2402.40,0.00,0.00,0.00,123.20,'2021-12-07 14:42:48','',''),(2195636,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.85,0.00,'2021-12-07 14:42:48','',''),(2195696,'1','177','919',408,'Retail Sale Id 1294953',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 14:45:27','',''),(2195697,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:45:27','',''),(2195808,'1','177','919',408,'Retail Sale Id 1295021',39000.00,0.00,0.00,0.00,2000.00,'2021-12-07 14:51:02','',''),(2195809,'1','177','919',408,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 14:51:02','',''),(2195856,'1','177','919',408,'Retail Sale Id 1295038',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 14:53:15','',''),(2195857,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 14:53:15','',''),(2195904,'1','177','919',408,'Retail Sale Id 1295074',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 14:56:28','',''),(2195905,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 14:56:28','',''),(2195950,'1','177','919',408,'Retail Sale Id 1295097',998.40,0.00,0.00,0.00,51.20,'2021-12-07 14:59:46','',''),(2195951,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 14:59:46','',''),(2195980,'1','177','919',408,'Retail Sale Id 1295111',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 15:01:51','',''),(2195981,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:01:51','',''),(2196108,'1','177','919',408,'Retail Sale Id 1295168',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 15:09:02','',''),(2196109,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:09:02','',''),(2196138,'1','177','919',408,'Retail Sale Id 1295183',499.20,0.00,0.00,0.00,25.60,'2021-12-07 15:10:12','',''),(2196139,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-07 15:10:12','',''),(2196164,'1','177','919',408,'Retail Sale Id 1295195',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 15:11:18','',''),(2196165,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:11:18','',''),(2196224,'1','177','919',408,'Retail Sale Id 1295224',2003.04,0.00,0.00,0.00,102.72,'2021-12-07 15:14:08','',''),(2196225,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-07 15:14:08','',''),(2196256,'1','177','919',408,'Retail Sale Id 1295239',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 15:15:57','',''),(2196257,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:15:57','',''),(2196274,'1','177','919',408,'Retail Sale Id 1295249',2496.00,0.00,0.00,0.00,128.00,'2021-12-07 15:16:59','',''),(2196275,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-07 15:16:59','',''),(2196298,'1','177','919',408,'Retail Sale Id 1295260',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 15:18:18','',''),(2196299,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:18:18','',''),(2196318,'1','177','919',408,'Retail Sale Id 1295271',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 15:19:38','',''),(2196319,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:19:38','',''),(2196334,'1','177','919',408,'Retail Sale Id 1295278',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 15:20:36','',''),(2196335,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:20:37','',''),(2196358,'1','177','919',408,'Retail Sale Id 1295288',2003.04,0.00,0.00,0.00,102.72,'2021-12-07 15:21:40','',''),(2196359,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-07 15:21:40','',''),(2196378,'1','177','919',408,'Retail Sale Id 1295296',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 15:23:05','',''),(2196379,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 15:23:05','',''),(2196401,'1','177','919',408,'Retail Sale Id 1295319',998.40,0.00,0.00,0.00,51.20,'2021-12-07 15:24:16','',''),(2196402,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 15:24:16','',''),(2196420,'1','177','919',408,'Retail Sale Id 1295328',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 15:25:19','',''),(2196421,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:25:19','',''),(2196516,'1','177','919',408,'Retail Sale Id 1295375',7001.28,0.00,0.00,0.00,359.04,'2021-12-07 15:29:25','',''),(2196517,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.22,0.00,'2021-12-07 15:29:25','',''),(2196548,'1','177','919',408,'Retail Sale Id 1295392',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 15:31:00','',''),(2196549,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:31:00','',''),(2196584,'1','177','919',408,'Retail Sale Id 1295409',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 15:32:36','',''),(2196585,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:32:36','',''),(2196722,'1','177','919',408,'Retail Sale Id 1295478',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 15:39:11','',''),(2196723,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 15:39:11','',''),(2196761,'1','177','919',408,'Retail Sale Id 1295491',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 15:40:27','',''),(2196762,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:40:27','',''),(2196823,'1','177','919',408,'Retail Sale Id 1295521',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 15:43:52','',''),(2196824,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:43:52','',''),(2196851,'1','177','919',408,'Retail Sale Id 1295537',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 15:45:18','',''),(2196852,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:45:18','',''),(2196891,'1','177','919',408,'Retail Sale Id 1295556',998.40,0.00,0.00,0.00,51.20,'2021-12-07 15:46:50','',''),(2196892,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 15:46:50','',''),(2196909,'1','177','919',408,'Retail Sale Id 1295569',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 15:48:01','',''),(2196910,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 15:48:01','',''),(2196980,'1','177','919',408,'Retail Sale Id 1295603',4998.24,0.00,0.00,0.00,256.32,'2021-12-07 15:51:30','',''),(2196981,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-07 15:51:30','',''),(2197010,'1','177','919',408,'Retail Sale Id 1295619',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 15:52:33','',''),(2197011,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 15:52:33','',''),(2197037,'1','177','919',408,'Retail Sale Id 1295634',11999.52,0.00,0.00,0.00,615.36,'2021-12-07 15:53:54','',''),(2197038,'1','177','919',408,'Retail sales',0.00,0.00,0.00,19.23,0.00,'2021-12-07 15:53:54','',''),(2197056,'1','177','919',408,'Retail Sale Id 1295646',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 15:54:56','',''),(2197057,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 15:54:56','',''),(2197076,'1','177','919',408,'Retail Sale Id 1295655',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 15:55:53','',''),(2197077,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 15:55:54','',''),(2197103,'1','177','919',408,'Retail Sale Id 1295669',4998.24,0.00,0.00,0.00,256.32,'2021-12-07 15:57:00','',''),(2197104,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-07 15:57:00','',''),(2197127,'1','177','919',408,'Retail Sale Id 1295678',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 15:57:55','',''),(2197128,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 15:57:55','',''),(2197205,'1','177','919',408,'Retail Sale Id 1295723',4998.24,0.00,0.00,0.00,256.32,'2021-12-07 16:02:02','',''),(2197206,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-07 16:02:02','',''),(2197231,'1','177','919',408,'Retail Sale Id 1295730',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 16:03:14','',''),(2197232,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:03:14','',''),(2197282,'1','177','919',408,'Retail Sale Id 1295755',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 16:05:33','',''),(2197283,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 16:05:33','',''),(2197318,'1','177','919',408,'Retail Sale Id 1295782',1697.28,0.00,0.00,0.00,87.04,'2021-12-07 16:07:22','',''),(2197319,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.72,0.00,'2021-12-07 16:07:22','',''),(2197358,'1','177','919',408,'Retail Sale Id 1295796',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 16:09:11','',''),(2197359,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:09:11','',''),(2197392,'1','177','919',408,'Retail Sale Id 1295814',1297.92,0.00,0.00,0.00,66.56,'2021-12-07 16:11:18','',''),(2197393,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-07 16:11:18','',''),(2197420,'1','177','919',408,'Retail Sale Id 1295826',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 16:12:44','',''),(2197421,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:12:44','',''),(2197454,'1','177','919',408,'Retail Sale Id 1295849',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 16:14:48','',''),(2197455,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:14:48','',''),(2197562,'1','177','919',408,'Retail Sale Id 1295902',15600.00,0.00,0.00,0.00,800.00,'2021-12-07 16:19:01','',''),(2197563,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-07 16:19:01','',''),(2197611,'1','177','919',408,'Retail Sale Id 1295937',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 16:20:53','',''),(2197612,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:20:53','',''),(2197653,'1','177','919',408,'Retail Sale Id 1295956',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 16:22:48','',''),(2197654,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:22:48','',''),(2197711,'1','177','919',408,'Retail Sale Id 1295991',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 16:26:34','',''),(2197712,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:26:34','',''),(2197751,'1','177','919',408,'Retail Sale Id 1296008',2003.04,0.00,0.00,0.00,102.72,'2021-12-07 16:27:45','',''),(2197752,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-07 16:27:45','',''),(2197789,'1','177','919',408,'Retail Sale Id 1296029',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 16:29:21','',''),(2197790,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:29:21','',''),(2197825,'1','177','919',408,'Retail Sale Id 1296047',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 16:31:08','',''),(2197826,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:31:08','',''),(2197854,'1','177','919',408,'Retail Sale Id 1296064',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 16:32:37','',''),(2197855,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:32:37','',''),(2197908,'1','177','919',408,'Retail Sale Id 1296082',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 16:35:31','',''),(2197909,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:35:31','',''),(2197954,'1','177','919',408,'Retail Sale Id 1296118',6002.88,0.00,0.00,0.00,307.84,'2021-12-07 16:38:28','',''),(2197955,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-07 16:38:28','',''),(2198063,'1','177','919',408,'Retail Sale Id 1296178',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 16:45:36','',''),(2198064,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:45:36','',''),(2198096,'1','177','919',408,'Retail Sale Id 1296193',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 16:47:39','',''),(2198097,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 16:47:39','',''),(2198222,'1','177','919',408,'Retail Sale Id 1296255',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 16:54:27','',''),(2198223,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 16:54:27','',''),(2198266,'1','177','919',408,'Retail Sale Id 1296279',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 16:56:34','',''),(2198267,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 16:56:34','',''),(2198325,'1','177','919',408,'Retail Sale Id 1296309',2003.04,0.00,0.00,0.00,102.72,'2021-12-07 16:59:18','',''),(2198326,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-07 16:59:18','',''),(2198382,'1','177','919',408,'Retail Sale Id 1296337',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 17:02:04','',''),(2198383,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 17:02:04','',''),(2198417,'1','177','919',408,'Retail Sale Id 1296351',1198.08,0.00,0.00,0.00,61.44,'2021-12-07 17:04:06','',''),(2198418,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-07 17:04:06','',''),(2198433,'1','177','919',408,'Retail Sale Id 1296360',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 17:05:28','',''),(2198434,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 17:05:28','',''),(2198494,'1','177','919',408,'Retail Sale Id 1296388',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 17:09:31','',''),(2198495,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:09:31','',''),(2198577,'1','177','919',408,'Retail Sale Id 1296450',8736.00,0.00,0.00,0.00,448.00,'2021-12-07 17:16:07','',''),(2198578,'1','177','919',408,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-07 17:16:07','',''),(2198623,'1','177','919',408,'Retail Sale Id 1296474',3001.44,0.00,0.00,0.00,153.92,'2021-12-07 17:19:33','',''),(2198624,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-07 17:19:33','',''),(2198671,'1','177','919',408,'Retail Sale Id 1296497',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 17:23:29','',''),(2198672,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:23:29','',''),(2198734,'1','177','919',408,'Retail Sale Id 1296530',10608.00,0.00,0.00,0.00,544.00,'2021-12-07 17:30:28','',''),(2198735,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.00,0.00,'2021-12-07 17:30:28','',''),(2198756,'1','177','919',408,'Retail Sale Id 1296540',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 17:32:48','',''),(2198757,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:32:48','',''),(2198771,'1','177','919',408,'Retail Sale Id 1296546',1497.60,0.00,0.00,0.00,76.80,'2021-12-07 17:34:44','',''),(2198772,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-07 17:34:44','',''),(2198788,'1','177','919',408,'Retail Sale Id 1296554',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 17:36:12','',''),(2198789,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:36:12','',''),(2198815,'1','177','919',408,'Retail Sale Id 1296568',998.40,0.00,0.00,0.00,51.20,'2021-12-07 17:38:19','',''),(2198816,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-07 17:38:19','',''),(2198932,'1','177','919',408,'Retail Sale Id 1296614',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 17:48:59','',''),(2198933,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 17:48:59','',''),(2198985,'1','177','919',408,'Retail Sale Id 1296634',11544.00,0.00,0.00,0.00,592.00,'2021-12-07 17:53:27','',''),(2198986,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-07 17:53:27','',''),(2199052,'1','177','919',408,'Retail Sale Id 1296646',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 17:58:51','',''),(2199053,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 17:58:51','',''),(2199068,'1','177','919',408,'Retail Sale Id 1296661',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 18:01:48','',''),(2199069,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 18:01:48','',''),(2199090,'1','177','919',408,'Retail Sale Id 1296669',24960.00,0.00,0.00,0.00,1280.00,'2021-12-07 18:03:54','',''),(2199091,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-07 18:03:54','',''),(2199124,'1','177','919',408,'Retail Sale Id 1296681',39000.00,0.00,0.00,0.00,2000.00,'2021-12-07 18:08:53','',''),(2199125,'1','177','919',408,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-07 18:08:53','',''),(2199134,'1','177','919',408,'Retail Sale Id 1296685',698.88,0.00,0.00,0.00,35.84,'2021-12-07 18:14:08','',''),(2199135,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.12,0.00,'2021-12-07 18:14:08','',''),(2199152,'1','177','919',408,'Retail Sale Id 1296693',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 18:22:27','',''),(2199153,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 18:22:27','',''),(2199175,'1','177','919',408,'Retail Sale Id 1296704',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 18:33:59','',''),(2199176,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 18:33:59','',''),(2199181,'1','177','919',408,'Retail Sale Id 1296707',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 18:36:07','',''),(2199182,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 18:36:07','',''),(2199188,'1','177','919',408,'Retail Sale Id 1296710',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 18:38:38','',''),(2199189,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 18:38:38','',''),(2199198,'1','177','919',408,'Retail Sale Id 1296716',1248.00,0.00,0.00,0.00,64.00,'2021-12-07 18:43:23','',''),(2199199,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-07 18:43:23','',''),(2199236,'1','177','919',408,'Retail Sale Id 1296732',3744.00,0.00,0.00,0.00,192.00,'2021-12-07 18:56:36','',''),(2199237,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-07 18:56:36','',''),(2199248,'1','177','919',408,'Retail Sale Id 1296734',3120.00,0.00,0.00,0.00,160.00,'2021-12-07 19:02:23','',''),(2199249,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-07 19:02:23','',''),(2199256,'1','177','919',408,'Retail Sale Id 1296736',4998.24,0.00,0.00,0.00,256.32,'2021-12-07 19:04:20','',''),(2199257,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-07 19:04:20','',''),(2199261,'1','177','919',408,'Retail Sale Id 1296738',4680.00,0.00,0.00,0.00,240.00,'2021-12-07 19:06:48','',''),(2199262,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.50,0.00,'2021-12-07 19:06:48','',''),(2199267,'1','177','919',408,'Retail Sale Id 1296740',1872.00,0.00,0.00,0.00,96.00,'2021-12-07 19:10:19','',''),(2199268,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-07 19:10:19','',''),(2199270,'1','177','919',408,'Retail Sale Id 1296741',7800.00,0.00,0.00,0.00,400.00,'2021-12-07 19:12:07','',''),(2199271,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-07 19:12:07','',''),(2199281,'1','177','919',408,'Retail Sale Id 1296742',5197.92,0.00,0.00,0.00,266.56,'2021-12-07 19:18:30','',''),(2199282,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.33,0.00,'2021-12-07 19:18:30','',''),(2199324,'1','177','919',408,'Retail Sale Id 1296745',27362.40,0.00,0.00,0.00,1403.20,'2021-12-07 19:53:34','',''),(2199325,'1','177','919',408,'Retail sales',0.00,0.00,0.00,43.85,0.00,'2021-12-07 19:53:34','',''),(2199910,'1','177','919',408,'Retail Sale Id 1296855',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 06:27:19','',''),(2199911,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 06:27:19','',''),(2199942,'1','177','919',408,'Retail Sale Id 1296871',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 06:31:52','',''),(2199943,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 06:31:52','',''),(2200016,'1','177','919',408,'Retail Sale Id 1296907',1597.44,0.00,0.00,0.00,81.92,'2021-12-08 06:38:07','',''),(2200017,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.56,0.00,'2021-12-08 06:38:07','',''),(2200036,'1','177','919',408,'Retail Sale Id 1296918',1248.00,0.00,0.00,0.00,64.00,'2021-12-08 06:39:25','',''),(2200037,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 06:39:25','',''),(2200127,'1','177','919',408,'Retail Sale Id 1296956',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 06:44:59','',''),(2200128,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 06:44:59','',''),(2200290,'1','177','919',408,'Retail Sale Id 1297007',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 06:51:45','',''),(2200291,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 06:51:45','',''),(2200310,'1','177','919',408,'Retail Sale Id 1297014',624.00,0.00,0.00,0.00,32.00,'2021-12-08 06:53:26','',''),(2200311,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 06:53:26','',''),(2200322,'1','177','919',408,'Retail Sale Id 1297022',2502.24,0.00,0.00,0.00,128.32,'2021-12-08 06:54:35','',''),(2200323,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-08 06:54:35','',''),(2200367,'1','177','919',408,'Retail Sale Id 1297037',1248.00,0.00,0.00,0.00,64.00,'2021-12-08 06:56:14','',''),(2200368,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 06:56:14','',''),(2200441,'1','177','919',408,'Retail Sale Id 1297072',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 06:59:59','',''),(2200442,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:00:00','',''),(2200481,'1','177','919',408,'Retail Sale Id 1297083',12480.00,0.00,0.00,0.00,640.00,'2021-12-08 07:02:54','',''),(2200482,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 07:02:54','',''),(2200629,'1','177','919',408,'Retail Sale Id 1297166',798.72,0.00,0.00,0.00,40.96,'2021-12-08 07:13:34','',''),(2200630,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-08 07:13:34','',''),(2200754,'1','177','919',408,'Retail Sale Id 1297204',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 07:19:25','',''),(2200755,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 07:19:25','',''),(2200846,'1','177','919',408,'Retail Sale Id 1297265',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 07:23:47','',''),(2200847,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:23:47','',''),(2200893,'1','177','919',408,'Retail Sale Id 1297288',4992.00,0.00,0.00,0.00,256.00,'2021-12-08 07:26:53','',''),(2200894,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-08 07:26:53','',''),(2200918,'1','177','919',408,'Retail Sale Id 1297301',1797.12,0.00,0.00,0.00,92.16,'2021-12-08 07:28:53','',''),(2200919,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-08 07:28:53','',''),(2201031,'1','177','919',408,'Retail Sale Id 1297350',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 07:33:55','',''),(2201032,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:33:55','',''),(2201170,'1','177','919',408,'Retail Sale Id 1297410',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 07:40:57','',''),(2201171,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 07:40:57','',''),(2201198,'1','177','919',408,'Retail Sale Id 1297425',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 07:42:41','',''),(2201199,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 07:42:41','',''),(2201256,'1','177','919',408,'Retail Sale Id 1297455',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 07:46:50','',''),(2201257,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 07:46:50','',''),(2201426,'1','177','919',408,'Retail Sale Id 1297526',9984.00,0.00,0.00,0.00,512.00,'2021-12-08 07:53:47','',''),(2201427,'1','177','919',408,'Retail sales',0.00,0.00,0.00,16.00,0.00,'2021-12-08 07:53:47','',''),(2201527,'1','177','919',408,'Retail Sale Id 1297565',15600.00,0.00,0.00,0.00,800.00,'2021-12-08 07:58:47','',''),(2201528,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 07:58:47','',''),(2201545,'1','177','919',408,'Retail Sale Id 1297576',6864.00,0.00,0.00,0.00,352.00,'2021-12-08 07:59:53','',''),(2201546,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-08 07:59:53','',''),(2201699,'1','177','919',408,'Retail Sale Id 1297643',15600.00,0.00,0.00,0.00,800.00,'2021-12-08 08:08:15','',''),(2201700,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:08:15','',''),(2201716,'1','177','919',408,'Retail Sale Id 1297661',15600.00,0.00,0.00,0.00,800.00,'2021-12-08 08:10:03','',''),(2201717,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:10:03','',''),(2201766,'1','177','919',408,'Retail Sale Id 1297688',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 08:13:52','',''),(2201767,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:13:52','',''),(2201801,'1','177','919',408,'Retail Sale Id 1297707',3500.64,0.00,0.00,0.00,179.52,'2021-12-08 08:16:16','',''),(2201802,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-08 08:16:16','',''),(2201865,'1','177','919',408,'Retail Sale Id 1297741',499.20,0.00,0.00,0.00,25.60,'2021-12-08 08:20:05','',''),(2201866,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-08 08:20:05','',''),(2201897,'1','177','919',408,'Retail Sale Id 1297757',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 08:21:40','',''),(2201898,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:21:40','',''),(2201929,'1','177','919',408,'Retail Sale Id 1297774',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 08:23:52','',''),(2201930,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 08:23:52','',''),(2201967,'1','177','919',408,'Retail Sale Id 1297788',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 08:26:34','',''),(2201968,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:26:34','',''),(2202002,'1','177','919',408,'Retail Sale Id 1297807',5497.44,0.00,0.00,0.00,281.92,'2021-12-08 08:28:36','',''),(2202003,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.81,0.00,'2021-12-08 08:28:36','',''),(2202060,'1','177','919',408,'Retail Sale Id 1297832',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 08:32:06','',''),(2202061,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:32:06','',''),(2202120,'1','177','919',408,'Retail Sale Id 1297862',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 08:36:12','',''),(2202121,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:36:12','',''),(2202409,'1','177','919',408,'Retail Sale Id 1297958',1198.08,0.00,0.00,0.00,61.44,'2021-12-08 08:48:22','',''),(2202410,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-08 08:48:22','',''),(2202500,'1','177','919',408,'Retail Sale Id 1297990',15600.00,0.00,0.00,0.00,800.00,'2021-12-08 08:52:44','',''),(2202501,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 08:52:44','',''),(2202528,'1','177','919',408,'Retail Sale Id 1297998',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 08:54:13','',''),(2202529,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 08:54:13','',''),(2202580,'1','177','919',408,'Retail Sale Id 1298026',10920.00,0.00,0.00,0.00,560.00,'2021-12-08 08:56:41','',''),(2202581,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-08 08:56:41','',''),(2202628,'1','177','919',408,'Retail Sale Id 1298051',6240.00,0.00,0.00,0.00,320.00,'2021-12-08 09:00:23','',''),(2202629,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 09:00:23','',''),(2202682,'1','177','919',408,'Retail Sale Id 1298076',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 09:03:29','',''),(2202683,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 09:03:29','',''),(2202777,'1','177','919',408,'Retail Sale Id 1298133',11544.00,0.00,0.00,0.00,592.00,'2021-12-08 09:09:19','',''),(2202778,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-08 09:09:19','',''),(2202850,'1','177','919',408,'Retail Sale Id 1298165',33072.00,0.00,0.00,0.00,1696.00,'2021-12-08 09:12:54','',''),(2202851,'1','177','919',408,'Retail sales',0.00,0.00,0.00,53.00,0.00,'2021-12-08 09:12:54','',''),(2202930,'1','177','919',408,'Retail Sale Id 1298202',5796.96,0.00,0.00,0.00,297.28,'2021-12-08 09:17:40','',''),(2202931,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.29,0.00,'2021-12-08 09:17:40','',''),(2202976,'1','177','919',408,'Retail Sale Id 1298223',998.40,0.00,0.00,0.00,51.20,'2021-12-08 09:20:09','',''),(2202977,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 09:20:09','',''),(2202999,'1','177','919',408,'Retail Sale Id 1298235',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 09:21:51','',''),(2203000,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 09:21:51','',''),(2203067,'1','177','919',408,'Retail Sale Id 1298270',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 09:28:51','',''),(2203068,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:28:51','',''),(2203111,'1','177','919',408,'Retail Sale Id 1298292',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 09:32:56','',''),(2203112,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 09:32:56','',''),(2203125,'1','177','919',408,'Retail Sale Id 1298300',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 09:34:19','',''),(2203126,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 09:34:19','',''),(2203171,'1','177','919',408,'Retail Sale Id 1298318',3001.44,0.00,0.00,0.00,153.92,'2021-12-08 09:37:07','',''),(2203172,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-08 09:37:07','',''),(2203525,'1','177','919',408,'Retail Sale Id 1298484',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:03:16','',''),(2203526,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:03:16','',''),(2203592,'1','177','919',408,'Retail Sale Id 1298518',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 10:08:52','',''),(2203593,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:08:52','',''),(2203675,'1','177','919',408,'Retail Sale Id 1298552',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:13:15','',''),(2203676,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:13:15','',''),(2203749,'1','177','919',408,'Retail Sale Id 1298584',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 10:17:00','',''),(2203750,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:17:00','',''),(2203789,'1','177','919',408,'Retail Sale Id 1298604',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 10:20:25','',''),(2203790,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:20:25','',''),(2203801,'1','177','919',408,'Retail Sale Id 1298618',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 10:21:32','',''),(2203802,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 10:21:32','',''),(2203854,'1','177','919',408,'Retail Sale Id 1298639',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:24:06','',''),(2203855,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:24:06','',''),(2204047,'1','177','919',408,'Retail Sale Id 1298725',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:35:26','',''),(2204048,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:35:26','',''),(2204117,'1','177','919',408,'Retail Sale Id 1298765',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 10:41:52','',''),(2204118,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 10:41:52','',''),(2204178,'1','177','919',408,'Retail Sale Id 1298793',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:48:32','',''),(2204179,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:48:32','',''),(2204228,'1','177','919',408,'Retail Sale Id 1298807',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:52:51','',''),(2204229,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:52:51','',''),(2204308,'1','177','919',408,'Retail Sale Id 1298857',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 10:58:36','',''),(2204309,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 10:58:36','',''),(2204333,'1','177','919',408,'Retail Sale Id 1298871',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 11:00:33','',''),(2204334,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 11:00:33','',''),(2204341,'1','177','919',408,'Retail Sale Id 1298875',6240.00,0.00,0.00,0.00,320.00,'2021-12-08 11:01:26','',''),(2204342,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 11:01:26','',''),(2204394,'1','177','919',408,'Retail Sale Id 1298903',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 11:06:04','',''),(2204395,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 11:06:04','',''),(2204566,'1','177','919',408,'Retail Sale Id 1298995',6002.88,0.00,0.00,0.00,307.84,'2021-12-08 11:16:39','',''),(2204567,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-08 11:16:39','',''),(2204672,'1','177','919',408,'Retail Sale Id 1299047',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 11:24:29','',''),(2204673,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 11:24:29','',''),(2204816,'1','177','919',408,'Retail Sale Id 1299123',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 11:35:19','',''),(2204817,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 11:35:19','',''),(2204880,'1','177','919',408,'Retail Sale Id 1299146',2184.00,0.00,0.00,0.00,112.00,'2021-12-08 11:38:37','',''),(2204881,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.50,0.00,'2021-12-08 11:38:37','',''),(2204940,'1','177','919',408,'Retail Sale Id 1299185',12480.00,0.00,0.00,0.00,640.00,'2021-12-08 11:41:19','',''),(2204941,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 11:41:19','',''),(2205008,'1','177','919',408,'Retail Sale Id 1299221',998.40,0.00,0.00,0.00,51.20,'2021-12-08 11:45:03','',''),(2205009,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 11:45:03','',''),(2205040,'1','177','919',408,'Retail Sale Id 1299238',1198.08,0.00,0.00,0.00,61.44,'2021-12-08 11:47:50','',''),(2205041,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-08 11:47:50','',''),(2205047,'1','177','919',408,'Retail Sale Id 1299240',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 11:48:55','',''),(2205048,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:48:55','',''),(2205176,'1','177','919',408,'Retail Sale Id 1299295',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 11:59:07','',''),(2205177,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 11:59:07','',''),(2205277,'1','177','919',408,'Retail Sale Id 1299339',12480.00,0.00,0.00,0.00,640.00,'2021-12-08 12:05:29','',''),(2205278,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-08 12:05:29','',''),(2205303,'1','177','919',408,'Retail Sale Id 1299353',3999.84,0.00,0.00,0.00,205.12,'2021-12-08 12:08:24','',''),(2205304,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-08 12:08:24','',''),(2205321,'1','177','919',408,'Retail Sale Id 1299359',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 12:09:33','',''),(2205322,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 12:09:33','',''),(2205385,'1','177','919',408,'Retail Sale Id 1299388',1248.00,0.00,0.00,0.00,64.00,'2021-12-08 12:14:09','',''),(2205386,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 12:14:09','',''),(2205907,'1','177','919',408,'Retail Sale Id 1299627',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 12:50:03','',''),(2205908,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 12:50:03','',''),(2206112,'1','177','919',408,'Retail Sale Id 1299713',499.20,0.00,0.00,0.00,25.60,'2021-12-08 13:05:04','',''),(2206113,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-08 13:05:04','',''),(2206124,'1','177','919',408,'Retail Sale Id 1299722',2502.24,0.00,0.00,0.00,128.32,'2021-12-08 13:06:04','',''),(2206125,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-08 13:06:04','',''),(2206431,'1','177','919',408,'Retail Sale Id 1299872',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 13:27:11','',''),(2206432,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:27:11','',''),(2206618,'1','177','919',408,'Retail Sale Id 1299947',6240.00,0.00,0.00,0.00,320.00,'2021-12-08 13:37:55','',''),(2206619,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-08 13:37:55','',''),(2206700,'1','177','919',408,'Retail Sale Id 1299975',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 13:41:53','',''),(2206701,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 13:41:53','',''),(2206803,'1','177','919',408,'Retail Sale Id 1300014',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 13:46:40','',''),(2206804,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:46:40','',''),(2206902,'1','177','919',408,'Retail Sale Id 1300054',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 13:52:30','',''),(2206903,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 13:52:30','',''),(2206977,'1','177','919',408,'Retail Sale Id 1300084',624.00,0.00,0.00,0.00,32.00,'2021-12-08 13:56:48','',''),(2206978,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-08 13:56:48','',''),(2206995,'1','177','919',408,'Retail Sale Id 1300094',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 13:58:05','',''),(2206996,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 13:58:05','',''),(2207125,'1','177','919',408,'Retail Sale Id 1300150',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 14:07:33','',''),(2207126,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 14:07:33','',''),(2207171,'1','177','919',408,'Retail Sale Id 1300168',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 14:09:32','',''),(2207172,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:09:32','',''),(2207214,'1','177','919',408,'Retail Sale Id 1300184',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 14:12:25','',''),(2207215,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 14:12:25','',''),(2207279,'1','177','919',408,'Retail Sale Id 1300216',1397.76,0.00,0.00,0.00,71.68,'2021-12-08 14:16:44','',''),(2207280,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.24,0.00,'2021-12-08 14:16:44','',''),(2207506,'1','177','919',408,'Retail Sale Id 1300334',2496.00,0.00,0.00,0.00,128.00,'2021-12-08 14:29:03','',''),(2207507,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 14:29:03','',''),(2207533,'1','177','919',408,'Retail Sale Id 1300346',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 14:30:00','',''),(2207534,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:30:00','',''),(2207668,'1','177','919',408,'Retail Sale Id 1300395',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 14:35:10','',''),(2207669,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 14:35:10','',''),(2207700,'1','177','919',408,'Retail Sale Id 1300413',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 14:36:40','',''),(2207701,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:36:40','',''),(2207726,'1','177','919',408,'Retail Sale Id 1300428',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 14:38:31','',''),(2207727,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 14:38:31','',''),(2207776,'1','177','919',408,'Retail Sale Id 1300453',4499.04,0.00,0.00,0.00,230.72,'2021-12-08 14:41:38','',''),(2207777,'1','177','919',408,'Retail sales',0.00,0.00,0.00,7.21,0.00,'2021-12-08 14:41:38','',''),(2207861,'1','177','919',408,'Retail Sale Id 1300500',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 14:46:19','',''),(2207862,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:46:19','',''),(2207877,'1','177','919',408,'Retail Sale Id 1300517',998.40,0.00,0.00,0.00,51.20,'2021-12-08 14:47:22','',''),(2207878,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 14:47:22','',''),(2207911,'1','177','919',408,'Retail Sale Id 1300534',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 14:49:14','',''),(2207912,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:49:14','',''),(2207937,'1','177','919',408,'Retail Sale Id 1300547',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 14:50:57','',''),(2207938,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 14:50:57','',''),(2208001,'1','177','919',408,'Retail Sale Id 1300576',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 14:54:44','',''),(2208002,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 14:54:44','',''),(2208195,'1','177','919',408,'Retail Sale Id 1300655',31200.00,0.00,0.00,0.00,1600.00,'2021-12-08 15:08:21','',''),(2208196,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 15:08:22','',''),(2208225,'1','177','919',408,'Retail Sale Id 1300670',3500.64,0.00,0.00,0.00,179.52,'2021-12-08 15:10:20','',''),(2208226,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.61,0.00,'2021-12-08 15:10:20','',''),(2208247,'1','177','919',408,'Retail Sale Id 1300676',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:11:41','',''),(2208248,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:11:41','',''),(2208281,'1','177','919',408,'Retail Sale Id 1300697',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:13:14','',''),(2208282,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:13:14','',''),(2208303,'1','177','919',408,'Retail Sale Id 1300709',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:14:30','',''),(2208304,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:14:30','',''),(2208345,'1','177','919',408,'Retail Sale Id 1300729',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 15:17:23','',''),(2208346,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 15:17:23','',''),(2208373,'1','177','919',408,'Retail Sale Id 1300742',15600.00,0.00,0.00,0.00,800.00,'2021-12-08 15:18:21','',''),(2208374,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 15:18:21','',''),(2208518,'1','177','919',408,'Retail Sale Id 1300811',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:25:37','',''),(2208519,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:25:37','',''),(2208536,'1','177','919',408,'Retail Sale Id 1300820',7500.48,0.00,0.00,0.00,384.64,'2021-12-08 15:26:37','',''),(2208537,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.02,0.00,'2021-12-08 15:26:37','',''),(2208562,'1','177','919',408,'Retail Sale Id 1300831',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:28:11','',''),(2208563,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:28:11','',''),(2208619,'1','177','919',408,'Retail Sale Id 1300854',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:30:52','',''),(2208620,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:30:52','',''),(2208657,'1','177','919',408,'Retail Sale Id 1300884',1497.60,0.00,0.00,0.00,76.80,'2021-12-08 15:32:53','',''),(2208658,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-08 15:32:53','',''),(2208755,'1','177','919',408,'Retail Sale Id 1300929',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 15:37:24','',''),(2208756,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 15:37:24','',''),(2208833,'1','177','919',408,'Retail Sale Id 1300975',3700.32,0.00,0.00,0.00,189.76,'2021-12-08 15:41:28','',''),(2208834,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.93,0.00,'2021-12-08 15:41:28','',''),(2209027,'1','177','919',408,'Retail Sale Id 1301072',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 15:52:52','',''),(2209028,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 15:52:52','',''),(2209127,'1','177','919',408,'Retail Sale Id 1301115',6801.60,0.00,0.00,0.00,348.80,'2021-12-08 15:57:43','',''),(2209128,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.90,0.00,'2021-12-08 15:57:43','',''),(2209217,'1','177','919',408,'Retail Sale Id 1301163',6801.60,0.00,0.00,0.00,348.80,'2021-12-08 16:01:58','',''),(2209218,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.90,0.00,'2021-12-08 16:01:58','',''),(2209253,'1','177','919',408,'Retail Sale Id 1301129',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 16:03:34','',''),(2209254,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:03:34','',''),(2209269,'1','177','919',408,'Retail Sale Id 1301192',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 16:04:42','',''),(2209270,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:04:42','',''),(2209323,'1','177','919',408,'Retail Sale Id 1301216',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 16:07:12','',''),(2209324,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:07:12','',''),(2209612,'1','177','919',408,'Retail Sale Id 1301312',31200.00,0.00,0.00,0.00,1600.00,'2021-12-08 16:18:00','',''),(2209613,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-08 16:18:00','',''),(2209666,'1','177','919',408,'Retail Sale Id 1301366',24960.00,0.00,0.00,0.00,1280.00,'2021-12-08 16:20:23','',''),(2209667,'1','177','919',408,'Retail sales',0.00,0.00,0.00,40.00,0.00,'2021-12-08 16:20:23','',''),(2209698,'1','177','919',408,'Retail Sale Id 1301382',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 16:22:34','',''),(2209699,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:22:34','',''),(2209737,'1','177','919',408,'Retail Sale Id 1301407',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 16:24:16','',''),(2209738,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 16:24:16','',''),(2209761,'1','177','919',408,'Retail Sale Id 1301423',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 16:25:27','',''),(2209762,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 16:25:27','',''),(2209802,'1','177','919',408,'Retail Sale Id 1301478',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 16:29:00','',''),(2209803,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 16:29:00','',''),(2209843,'1','177','919',408,'Retail Sale Id 1301464',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 16:30:35','',''),(2209844,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 16:30:36','',''),(2209895,'1','177','919',408,'Retail Sale Id 1301601',948.48,0.00,0.00,0.00,48.64,'2021-12-08 16:33:29','',''),(2209896,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.52,0.00,'2021-12-08 16:33:29','',''),(2209927,'1','177','919',408,'Retail Sale Id 1301613',2496.00,0.00,0.00,0.00,128.00,'2021-12-08 16:34:51','',''),(2209928,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-08 16:34:51','',''),(2209953,'1','177','919',408,'Retail Sale Id 1301628',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 16:35:58','',''),(2209954,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 16:35:58','',''),(2210031,'1','177','919',408,'Retail Sale Id 1301665',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 16:39:27','',''),(2210032,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 16:39:27','',''),(2210097,'1','177','919',408,'Retail Sale Id 1301700',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 16:42:18','',''),(2210098,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 16:42:18','',''),(2210193,'1','177','919',408,'Retail Sale Id 1301749',34950.24,0.00,0.00,0.00,1792.32,'2021-12-08 16:47:21','',''),(2210194,'1','177','919',408,'Retail sales',0.00,0.00,0.00,56.01,0.00,'2021-12-08 16:47:21','',''),(2210298,'1','177','919',408,'Retail Sale Id 1301802',1248.00,0.00,0.00,0.00,64.00,'2021-12-08 16:52:55','',''),(2210299,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-08 16:52:55','',''),(2210314,'1','177','919',408,'Retail Sale Id 1301813',998.40,0.00,0.00,0.00,51.20,'2021-12-08 16:53:59','',''),(2210315,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 16:53:59','',''),(2210354,'1','177','919',408,'Retail Sale Id 1301830',998.40,0.00,0.00,0.00,51.20,'2021-12-08 16:56:18','',''),(2210355,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 16:56:18','',''),(2210515,'1','177','919',408,'Retail Sale Id 1301922',998.40,0.00,0.00,0.00,51.20,'2021-12-08 17:09:36','',''),(2210516,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 17:09:36','',''),(2210581,'1','177','919',408,'Retail Sale Id 1301960',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 17:15:11','',''),(2210582,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:15:11','',''),(2210599,'1','177','919',408,'Retail Sale Id 1301970',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 17:16:58','',''),(2210600,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 17:16:58','',''),(2210633,'1','177','919',408,'Retail Sale Id 1301992',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 17:19:58','',''),(2210634,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:19:58','',''),(2210660,'1','177','919',408,'Retail Sale Id 1302008',3744.00,0.00,0.00,0.00,192.00,'2021-12-08 17:23:32','',''),(2210661,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-08 17:23:32','',''),(2210672,'1','177','919',408,'Retail Sale Id 1302015',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 17:24:32','',''),(2210673,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:24:32','',''),(2210692,'1','177','919',408,'Retail Sale Id 1302027',3900.00,0.00,0.00,0.00,200.00,'2021-12-08 17:27:46','',''),(2210693,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-08 17:27:46','',''),(2210781,'1','177','919',408,'Retail Sale Id 1302072',1872.00,0.00,0.00,0.00,96.00,'2021-12-08 17:36:36','',''),(2210782,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-08 17:36:36','',''),(2210795,'1','177','919',408,'Retail Sale Id 1302078',15600.00,0.00,0.00,0.00,800.00,'2021-12-08 17:38:43','',''),(2210796,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-08 17:38:43','',''),(2210831,'1','177','919',408,'Retail Sale Id 1302098',3001.44,0.00,0.00,0.00,153.92,'2021-12-08 17:42:15','',''),(2210832,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-08 17:42:15','',''),(2210868,'1','177','919',408,'Retail Sale Id 1302103',998.40,0.00,0.00,0.00,51.20,'2021-12-08 17:44:14','',''),(2210869,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 17:44:14','',''),(2210930,'1','177','919',408,'Retail Sale Id 1302122',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 17:52:23','',''),(2210931,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 17:52:23','',''),(2210993,'1','177','919',408,'Retail Sale Id 1302146',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 18:04:05','',''),(2210994,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 18:04:05','',''),(2211002,'1','177','919',408,'Retail Sale Id 1302148',3120.00,0.00,0.00,0.00,160.00,'2021-12-08 18:06:16','',''),(2211003,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-08 18:06:16','',''),(2211021,'1','177','919',408,'Retail Sale Id 1302153',11856.00,0.00,0.00,0.00,608.00,'2021-12-08 18:11:12','',''),(2211022,'1','177','919',408,'Retail sales',0.00,0.00,0.00,19.00,0.00,'2021-12-08 18:11:12','',''),(2211039,'1','177','919',408,'Retail Sale Id 1302166',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 18:15:32','',''),(2211040,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 18:15:32','',''),(2211064,'1','177','919',408,'Retail Sale Id 1302173',4998.24,0.00,0.00,0.00,256.32,'2021-12-08 18:25:39','',''),(2211065,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-08 18:25:39','',''),(2211080,'1','177','919',408,'Retail Sale Id 1302178',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 18:28:06','',''),(2211081,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 18:28:06','',''),(2211096,'1','177','919',408,'Retail Sale Id 1302184',7800.00,0.00,0.00,0.00,400.00,'2021-12-08 18:30:40','',''),(2211097,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-08 18:30:40','',''),(2211102,'1','177','919',408,'Retail Sale Id 1302186',998.40,0.00,0.00,0.00,51.20,'2021-12-08 18:32:24','',''),(2211103,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-08 18:32:24','',''),(2211170,'1','177','919',408,'Retail Sale Id 1302208',2003.04,0.00,0.00,0.00,102.72,'2021-12-08 18:48:12','',''),(2211171,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-08 18:48:12','',''),(2211338,'1','177','919',408,'Retail Sale Id 1302250',3906.24,0.00,0.00,0.00,200.32,'2021-12-08 19:43:34','',''),(2211339,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.26,0.00,'2021-12-08 19:43:34','',''),(2211756,'1','177','919',408,'Retail Sale Id 1302265',1497.60,0.00,0.00,0.00,76.80,'2021-12-09 05:34:14','',''),(2211757,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-09 05:34:14','',''),(2212032,'1','177','919',408,'Retail Sale Id 1302391',15600.00,0.00,0.00,0.00,800.00,'2021-12-09 06:14:20','',''),(2212033,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 06:14:20','',''),(2212046,'1','177','919',408,'Retail Sale Id 1302397',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 06:15:04','',''),(2212047,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 06:15:04','',''),(2212300,'1','177','919',408,'Retail Sale Id 1302508',6002.88,0.00,0.00,0.00,307.84,'2021-12-09 06:31:32','',''),(2212301,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.62,0.00,'2021-12-09 06:31:32','',''),(2212438,'1','177','919',408,'Retail Sale Id 1302560',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 06:38:17','',''),(2212439,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 06:38:17','',''),(2212488,'1','177','919',408,'Retail Sale Id 1302584',998.40,0.00,0.00,0.00,51.20,'2021-12-09 06:41:18','',''),(2212489,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-09 06:41:18','',''),(2212571,'1','177','919',408,'Retail Sale Id 1302621',998.40,0.00,0.00,0.00,51.20,'2021-12-09 06:45:59','',''),(2212572,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-09 06:45:59','',''),(2212603,'1','177','919',408,'Retail Sale Id 1302637',15600.00,0.00,0.00,0.00,800.00,'2021-12-09 06:47:12','',''),(2212604,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 06:47:12','',''),(2213057,'1','177','919',408,'Retail Sale Id 1302843',9672.00,0.00,0.00,0.00,496.00,'2021-12-09 07:12:40','',''),(2213058,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-09 07:12:40','',''),(2213130,'1','177','919',408,'Retail Sale Id 1302872',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 07:15:46','',''),(2213131,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 07:15:46','',''),(2213402,'1','177','919',408,'Retail Sale Id 1303010',6801.60,0.00,0.00,0.00,348.80,'2021-12-09 07:26:51','',''),(2213403,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.90,0.00,'2021-12-09 07:26:51','',''),(2213578,'1','177','919',408,'Retail Sale Id 1303095',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 07:35:08','',''),(2213579,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 07:35:08','',''),(2213846,'1','177','919',408,'Retail Sale Id 1303222',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 07:48:38','',''),(2213847,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 07:48:38','',''),(2213878,'1','177','919',408,'Retail Sale Id 1303236',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 07:50:39','',''),(2213879,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 07:50:39','',''),(2213938,'1','177','919',408,'Retail Sale Id 1303263',1497.60,0.00,0.00,0.00,76.80,'2021-12-09 07:52:46','',''),(2213939,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-09 07:52:46','',''),(2214160,'1','177','919',408,'Retail Sale Id 1303382',23400.00,0.00,0.00,0.00,1200.00,'2021-12-09 08:06:49','',''),(2214161,'1','177','919',408,'Retail sales',0.00,0.00,0.00,37.50,0.00,'2021-12-09 08:06:49','',''),(2214206,'1','177','919',408,'Retail Sale Id 1303402',624.00,0.00,0.00,0.00,32.00,'2021-12-09 08:08:47','',''),(2214207,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 08:08:47','',''),(2214440,'1','177','919',408,'Retail Sale Id 1303518',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 08:20:57','',''),(2214441,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:20:57','',''),(2214590,'1','177','919',408,'Retail Sale Id 1303570',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 08:26:17','',''),(2214591,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 08:26:17','',''),(2214606,'1','177','919',408,'Retail Sale Id 1303578',3001.44,0.00,0.00,0.00,153.92,'2021-12-09 08:27:28','',''),(2214607,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-09 08:27:28','',''),(2214691,'1','177','919',408,'Retail Sale Id 1303604',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 08:31:00','',''),(2214692,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:31:00','',''),(2214855,'1','177','919',408,'Retail Sale Id 1303697',2202.72,0.00,0.00,0.00,112.96,'2021-12-09 08:39:13','',''),(2214856,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.53,0.00,'2021-12-09 08:39:13','',''),(2214881,'1','177','919',408,'Retail Sale Id 1303711',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 08:40:21','',''),(2214882,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 08:40:21','',''),(2214921,'1','177','919',408,'Retail Sale Id 1303731',9360.00,0.00,0.00,0.00,480.00,'2021-12-09 08:41:56','',''),(2214922,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-09 08:41:56','',''),(2215092,'1','177','919',408,'Retail Sale Id 1303806',3001.44,0.00,0.00,0.00,153.92,'2021-12-09 08:51:45','',''),(2215093,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-09 08:51:45','',''),(2215168,'1','177','919',408,'Retail Sale Id 1303843',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 08:56:39','',''),(2215169,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 08:56:39','',''),(2215244,'1','177','919',408,'Retail Sale Id 1303886',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 09:00:55','',''),(2215245,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:00:55','',''),(2215370,'1','177','919',408,'Retail Sale Id 1303949',15600.00,0.00,0.00,0.00,800.00,'2021-12-09 09:08:33','',''),(2215371,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 09:08:33','',''),(2215482,'1','177','919',408,'Retail Sale Id 1304007',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 09:15:49','',''),(2215483,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 09:15:49','',''),(2215569,'1','177','919',408,'Retail Sale Id 1304050',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 09:20:45','',''),(2215570,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 09:20:45','',''),(2215664,'1','177','919',408,'Retail Sale Id 1304098',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 09:25:02','',''),(2215665,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 09:25:02','',''),(2215686,'1','177','919',408,'Retail Sale Id 1304108',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 09:26:21','',''),(2215687,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:26:21','',''),(2215718,'1','177','919',408,'Retail Sale Id 1304120',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 09:28:09','',''),(2215719,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 09:28:09','',''),(2215742,'1','177','919',408,'Retail Sale Id 1304138',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 09:29:32','',''),(2215743,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 09:29:32','',''),(2215772,'1','177','919',408,'Retail Sale Id 1304155',5616.00,0.00,0.00,0.00,288.00,'2021-12-09 09:31:44','',''),(2215773,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 09:31:44','',''),(2216149,'1','177','919',408,'Retail Sale Id 1304292',998.40,0.00,0.00,0.00,51.20,'2021-12-09 09:48:24','',''),(2216150,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-09 09:48:24','',''),(2216207,'1','177','919',408,'Retail Sale Id 1304323',11544.00,0.00,0.00,0.00,592.00,'2021-12-09 09:51:45','',''),(2216208,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-09 09:51:45','',''),(2216336,'1','177','919',408,'Retail Sale Id 1304381',1497.60,0.00,0.00,0.00,76.80,'2021-12-09 09:57:13','',''),(2216337,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-09 09:57:13','',''),(2216368,'1','177','919',408,'Retail Sale Id 1304398',798.72,0.00,0.00,0.00,40.96,'2021-12-09 09:58:42','',''),(2216369,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-09 09:58:42','',''),(2216410,'1','177','919',408,'Retail Sale Id 1304412',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 10:00:25','',''),(2216411,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:00:25','',''),(2216597,'1','177','919',408,'Retail Sale Id 1304509',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 10:11:52','',''),(2216598,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:11:52','',''),(2216643,'1','177','919',408,'Retail Sale Id 1304536',1297.92,0.00,0.00,0.00,66.56,'2021-12-09 10:16:10','',''),(2216644,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.08,0.00,'2021-12-09 10:16:10','',''),(2216677,'1','177','919',408,'Retail Sale Id 1304554',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 10:18:02','',''),(2216678,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:18:02','',''),(2216745,'1','177','919',408,'Retail Sale Id 1304591',31200.00,0.00,0.00,0.00,1600.00,'2021-12-09 10:22:43','',''),(2216746,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 10:22:43','',''),(2216825,'1','177','919',408,'Retail Sale Id 1304623',3120.00,0.00,0.00,0.00,160.00,'2021-12-09 10:27:12','',''),(2216826,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 10:27:12','',''),(2216925,'1','177','919',408,'Retail Sale Id 1304684',1797.12,0.00,0.00,0.00,92.16,'2021-12-09 10:33:49','',''),(2216926,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-09 10:33:49','',''),(2217100,'1','177','919',408,'Retail Sale Id 1304779',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 10:46:06','',''),(2217101,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:46:06','',''),(2217174,'1','177','919',408,'Retail Sale Id 1304809',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 10:50:03','',''),(2217175,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 10:50:03','',''),(2217190,'1','177','919',408,'Retail Sale Id 1304824',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 10:50:58','',''),(2217191,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 10:50:58','',''),(2217309,'1','177','919',408,'Retail Sale Id 1304883',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 11:00:04','',''),(2217310,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:00:04','',''),(2217388,'1','177','919',408,'Retail Sale Id 1304921',1497.60,0.00,0.00,0.00,76.80,'2021-12-09 11:05:02','',''),(2217389,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-09 11:05:02','',''),(2217408,'1','177','919',408,'Retail Sale Id 1304931',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 11:06:05','',''),(2217409,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:06:05','',''),(2217500,'1','177','919',408,'Retail Sale Id 1304976',11544.00,0.00,0.00,0.00,592.00,'2021-12-09 11:13:28','',''),(2217501,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-09 11:13:28','',''),(2217534,'1','177','919',408,'Retail Sale Id 1304992',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 11:16:26','',''),(2217535,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:16:26','',''),(2217556,'1','177','919',408,'Retail Sale Id 1305007',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 11:17:45','',''),(2217557,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:17:45','',''),(2217578,'1','177','919',408,'Retail Sale Id 1305020',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 11:19:08','',''),(2217579,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 11:19:08','',''),(2217679,'1','177','919',408,'Retail Sale Id 1305058',9672.00,0.00,0.00,0.00,496.00,'2021-12-09 11:23:16','',''),(2217680,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.50,0.00,'2021-12-09 11:23:16','',''),(2217724,'1','177','919',408,'Retail Sale Id 1305081',1198.08,0.00,0.00,0.00,61.44,'2021-12-09 11:26:22','',''),(2217725,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-09 11:26:22','',''),(2217737,'1','177','919',408,'Retail Sale Id 1305088',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 11:27:31','',''),(2217738,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 11:27:31','',''),(2217763,'1','177','919',408,'Retail Sale Id 1305101',798.72,0.00,0.00,0.00,40.96,'2021-12-09 11:29:04','',''),(2217764,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.28,0.00,'2021-12-09 11:29:04','',''),(2217919,'1','177','919',408,'Retail Sale Id 1305178',5616.00,0.00,0.00,0.00,288.00,'2021-12-09 11:38:11','',''),(2217920,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 11:38:11','',''),(2218154,'1','177','919',408,'Retail Sale Id 1305291',2496.00,0.00,0.00,0.00,128.00,'2021-12-09 11:52:27','',''),(2218155,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-09 11:52:27','',''),(2218236,'1','177','919',408,'Retail Sale Id 1305339',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 11:58:31','',''),(2218237,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 11:58:31','',''),(2218282,'1','177','919',408,'Retail Sale Id 1305358',28080.00,0.00,0.00,0.00,1440.00,'2021-12-09 12:01:14','',''),(2218283,'1','177','919',408,'Retail sales',0.00,0.00,0.00,45.00,0.00,'2021-12-09 12:01:14','',''),(2218347,'1','177','919',408,'Retail Sale Id 1305396',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 12:06:29','',''),(2218348,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 12:06:29','',''),(2218371,'1','177','919',408,'Retail Sale Id 1305405',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 12:07:50','',''),(2218372,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:07:50','',''),(2218554,'1','177','919',408,'Retail Sale Id 1305494',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 12:18:37','',''),(2218555,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 12:18:37','',''),(2218932,'1','177','919',408,'Retail Sale Id 1305697',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 12:42:32','',''),(2218933,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:42:32','',''),(2218964,'1','177','919',408,'Retail Sale Id 1305716',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 12:44:37','',''),(2218965,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 12:44:37','',''),(2219235,'1','177','919',408,'Retail Sale Id 1305843',15600.00,0.00,0.00,0.00,800.00,'2021-12-09 12:58:04','',''),(2219236,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 12:58:04','',''),(2219536,'1','177','919',408,'Retail Sale Id 1305993',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 13:19:14','',''),(2219537,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:19:14','',''),(2219640,'1','177','919',408,'Retail Sale Id 1306038',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 13:26:51','',''),(2219641,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:26:51','',''),(2220092,'1','177','919',408,'Retail Sale Id 1306200',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 13:49:05','',''),(2220093,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 13:49:05','',''),(2220134,'1','177','919',408,'Retail Sale Id 1306223',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 13:51:47','',''),(2220135,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 13:51:47','',''),(2220221,'1','177','919',408,'Retail Sale Id 1306270',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 13:58:21','',''),(2220222,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 13:58:21','',''),(2220370,'1','177','919',408,'Retail Sale Id 1306330',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 14:09:20','',''),(2220371,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:09:20','',''),(2220427,'1','177','919',408,'Retail Sale Id 1306348',4998.24,0.00,0.00,0.00,256.32,'2021-12-09 14:11:33','',''),(2220428,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.01,0.00,'2021-12-09 14:11:33','',''),(2220468,'1','177','919',408,'Retail Sale Id 1306384',1497.60,0.00,0.00,0.00,76.80,'2021-12-09 14:14:14','',''),(2220469,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-09 14:14:14','',''),(2220546,'1','177','919',408,'Retail Sale Id 1306448',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 14:18:43','',''),(2220547,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 14:18:43','',''),(2220655,'1','177','919',408,'Retail Sale Id 1306504',11999.52,0.00,0.00,0.00,615.36,'2021-12-09 14:24:56','',''),(2220656,'1','177','919',408,'Retail sales',0.00,0.00,0.00,19.23,0.00,'2021-12-09 14:24:56','',''),(2220678,'1','177','919',408,'Retail Sale Id 1306518',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 14:26:08','',''),(2220679,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:26:08','',''),(2220726,'1','177','919',408,'Retail Sale Id 1306537',998.40,0.00,0.00,0.00,51.20,'2021-12-09 14:27:53','',''),(2220727,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-09 14:27:53','',''),(2220841,'1','177','919',408,'Retail Sale Id 1306593',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 14:33:50','',''),(2220842,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:33:50','',''),(2220913,'1','177','919',408,'Retail Sale Id 1306616',31200.00,0.00,0.00,0.00,1600.00,'2021-12-09 14:36:17','',''),(2220914,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 14:36:17','',''),(2220988,'1','177','919',408,'Retail Sale Id 1306652',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 14:38:43','',''),(2220989,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:38:43','',''),(2221012,'1','177','919',408,'Retail Sale Id 1306670',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 14:39:59','',''),(2221013,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 14:39:59','',''),(2221452,'1','177','919',408,'Retail Sale Id 1306829',2502.24,0.00,0.00,0.00,128.32,'2021-12-09 14:57:32','',''),(2221453,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.01,0.00,'2021-12-09 14:57:32','',''),(2221624,'1','177','919',408,'Retail Sale Id 1306924',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 15:07:02','',''),(2221625,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 15:07:02','',''),(2221642,'1','177','919',408,'Retail Sale Id 1306934',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 15:08:12','',''),(2221643,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:08:12','',''),(2221697,'1','177','919',408,'Retail Sale Id 1306964',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 15:10:25','',''),(2221698,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:10:25','',''),(2221831,'1','177','919',408,'Retail Sale Id 1307039',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 15:17:35','',''),(2221832,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:17:35','',''),(2221979,'1','177','919',408,'Retail Sale Id 1307110',15600.00,0.00,0.00,0.00,800.00,'2021-12-09 15:25:06','',''),(2221980,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 15:25:06','',''),(2222027,'1','177','919',408,'Retail Sale Id 1307136',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 15:27:06','',''),(2222028,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 15:27:06','',''),(2222055,'1','177','919',408,'Retail Sale Id 1307151',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 15:28:22','',''),(2222056,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 15:28:22','',''),(2222214,'1','177','919',408,'Retail Sale Id 1307230',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 15:36:44','',''),(2222215,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 15:36:44','',''),(2222284,'1','177','919',408,'Retail Sale Id 1307258',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 15:39:39','',''),(2222285,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:39:39','',''),(2222342,'1','177','919',408,'Retail Sale Id 1307290',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 15:43:23','',''),(2222343,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 15:43:23','',''),(2222397,'1','177','919',408,'Retail Sale Id 1307315',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 15:46:26','',''),(2222398,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 15:46:26','',''),(2222471,'1','177','919',408,'Retail Sale Id 1307351',12480.00,0.00,0.00,0.00,640.00,'2021-12-09 15:51:05','',''),(2222472,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 15:51:05','',''),(2222592,'1','177','919',408,'Retail Sale Id 1307410',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 15:56:58','',''),(2222593,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 15:56:58','',''),(2222632,'1','177','919',408,'Retail Sale Id 1307429',5616.00,0.00,0.00,0.00,288.00,'2021-12-09 15:59:24','',''),(2222633,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-09 15:59:24','',''),(2222676,'1','177','919',408,'Retail Sale Id 1307453',1797.12,0.00,0.00,0.00,92.16,'2021-12-09 16:01:40','',''),(2222677,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.88,0.00,'2021-12-09 16:01:40','',''),(2222702,'1','177','919',408,'Retail Sale Id 1307465',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 16:03:14','',''),(2222703,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 16:03:14','',''),(2222751,'1','177','919',408,'Retail Sale Id 1307484',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 16:05:38','',''),(2222752,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:05:38','',''),(2222777,'1','177','919',408,'Retail Sale Id 1307505',3001.44,0.00,0.00,0.00,153.92,'2021-12-09 16:07:06','',''),(2222778,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-09 16:07:06','',''),(2222823,'1','177','919',408,'Retail Sale Id 1307528',499.20,0.00,0.00,0.00,25.60,'2021-12-09 16:09:10','',''),(2222824,'1','177','919',408,'Retail sales',0.00,0.00,0.00,0.80,0.00,'2021-12-09 16:09:10','',''),(2222849,'1','177','919',408,'Retail Sale Id 1307540',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 16:10:25','',''),(2222850,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:10:25','',''),(2222881,'1','177','919',408,'Retail Sale Id 1307558',936.00,0.00,0.00,0.00,48.00,'2021-12-09 16:12:16','',''),(2222882,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.50,0.00,'2021-12-09 16:12:16','',''),(2222917,'1','177','919',408,'Retail Sale Id 1307573',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 16:14:10','',''),(2222918,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 16:14:10','',''),(2222939,'1','177','919',408,'Retail Sale Id 1307584',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 16:15:11','',''),(2222940,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:15:11','',''),(2223015,'1','177','919',408,'Retail Sale Id 1307626',1896.96,0.00,0.00,0.00,97.28,'2021-12-09 16:19:53','',''),(2223016,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.04,0.00,'2021-12-09 16:19:53','',''),(2223047,'1','177','919',408,'Retail Sale Id 1307637',3001.44,0.00,0.00,0.00,153.92,'2021-12-09 16:21:05','',''),(2223048,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-09 16:21:05','',''),(2223063,'1','177','919',408,'Retail Sale Id 1307645',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 16:22:20','',''),(2223064,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 16:22:20','',''),(2223083,'1','177','919',408,'Retail Sale Id 1307654',3001.44,0.00,0.00,0.00,153.92,'2021-12-09 16:23:25','',''),(2223084,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-09 16:23:25','',''),(2223099,'1','177','919',408,'Retail Sale Id 1307663',15600.00,0.00,0.00,0.00,800.00,'2021-12-09 16:24:29','',''),(2223100,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-09 16:24:29','',''),(2223245,'1','177','919',408,'Retail Sale Id 1307727',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 16:31:43','',''),(2223246,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 16:31:43','',''),(2223302,'1','177','919',408,'Retail Sale Id 1307755',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 16:34:53','',''),(2223303,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:34:53','',''),(2223432,'1','177','919',408,'Retail Sale Id 1307804',1497.60,0.00,0.00,0.00,76.80,'2021-12-09 16:41:14','',''),(2223433,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.40,0.00,'2021-12-09 16:41:14','',''),(2223453,'1','177','919',408,'Retail Sale Id 1307813',998.40,0.00,0.00,0.00,51.20,'2021-12-09 16:42:24','',''),(2223454,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-09 16:42:24','',''),(2223496,'1','177','919',408,'Retail Sale Id 1307828',29952.00,0.00,0.00,0.00,1536.00,'2021-12-09 16:44:12','',''),(2223497,'1','177','919',408,'Retail sales',0.00,0.00,0.00,48.00,0.00,'2021-12-09 16:44:12','',''),(2223548,'1','177','919',408,'Retail Sale Id 1307848',624.00,0.00,0.00,0.00,32.00,'2021-12-09 16:47:15','',''),(2223549,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-09 16:47:15','',''),(2223603,'1','177','919',408,'Retail Sale Id 1307876',3001.44,0.00,0.00,0.00,153.92,'2021-12-09 16:50:57','',''),(2223604,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.81,0.00,'2021-12-09 16:50:57','',''),(2223626,'1','177','919',408,'Retail Sale Id 1307886',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 16:51:57','',''),(2223627,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 16:51:57','',''),(2223639,'1','177','919',408,'Retail Sale Id 1307893',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 16:53:02','',''),(2223640,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 16:53:02','',''),(2223665,'1','177','919',408,'Retail Sale Id 1307906',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 16:54:42','',''),(2223666,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 16:54:42','',''),(2223699,'1','177','919',408,'Retail Sale Id 1307918',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 16:56:04','',''),(2223700,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 16:56:04','',''),(2223719,'1','177','919',408,'Retail Sale Id 1307928',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 16:57:15','',''),(2223720,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 16:57:15','',''),(2223733,'1','177','919',408,'Retail Sale Id 1307934',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 16:58:35','',''),(2223734,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:58:35','',''),(2223754,'1','177','919',408,'Retail Sale Id 1307946',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 16:59:53','',''),(2223755,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 16:59:53','',''),(2223778,'1','177','919',408,'Retail Sale Id 1307956',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 17:01:27','',''),(2223779,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:01:27','',''),(2223794,'1','177','919',408,'Retail Sale Id 1307964',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 17:02:31','',''),(2223795,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:02:31','',''),(2223832,'1','177','919',408,'Retail Sale Id 1307983',1248.00,0.00,0.00,0.00,64.00,'2021-12-09 17:04:07','',''),(2223833,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-09 17:04:07','',''),(2223851,'1','177','919',408,'Retail Sale Id 1307990',3120.00,0.00,0.00,0.00,160.00,'2021-12-09 17:05:02','',''),(2223852,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-09 17:05:02','',''),(2223873,'1','177','919',408,'Retail Sale Id 1307999',12480.00,0.00,0.00,0.00,640.00,'2021-12-09 17:06:44','',''),(2223874,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-09 17:06:44','',''),(2223893,'1','177','919',408,'Retail Sale Id 1308010',10296.00,0.00,0.00,0.00,528.00,'2021-12-09 17:08:17','',''),(2223894,'1','177','919',408,'Retail sales',0.00,0.00,0.00,16.50,0.00,'2021-12-09 17:08:17','',''),(2223912,'1','177','919',408,'Retail Sale Id 1308020',1198.08,0.00,0.00,0.00,61.44,'2021-12-09 17:10:22','',''),(2223913,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-09 17:10:22','',''),(2223930,'1','177','919',408,'Retail Sale Id 1308029',1198.08,0.00,0.00,0.00,61.44,'2021-12-09 17:11:42','',''),(2223931,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-09 17:11:42','',''),(2223948,'1','177','919',408,'Retail Sale Id 1308038',998.40,0.00,0.00,0.00,51.20,'2021-12-09 17:12:54','',''),(2223949,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.60,0.00,'2021-12-09 17:12:54','',''),(2223959,'1','177','919',408,'Retail Sale Id 1308048',2003.04,0.00,0.00,0.00,102.72,'2021-12-09 17:14:17','',''),(2223960,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.21,0.00,'2021-12-09 17:14:17','',''),(2223977,'1','177','919',408,'Retail Sale Id 1308058',1198.08,0.00,0.00,0.00,61.44,'2021-12-09 17:15:48','',''),(2223978,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.92,0.00,'2021-12-09 17:15:48','',''),(2223990,'1','177','919',408,'Retail Sale Id 1308062',4992.00,0.00,0.00,0.00,256.00,'2021-12-09 17:16:59','',''),(2223991,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.00,0.00,'2021-12-09 17:16:59','',''),(2224046,'1','177','919',408,'Retail Sale Id 1308091',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 17:23:37','',''),(2224047,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:23:37','',''),(2224154,'1','177','919',408,'Retail Sale Id 1308142',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 17:38:23','',''),(2224155,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 17:38:23','',''),(2224186,'1','177','919',408,'Retail Sale Id 1308160',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 17:45:22','',''),(2224187,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:45:22','',''),(2224195,'1','177','919',408,'Retail Sale Id 1308164',31200.00,0.00,0.00,0.00,1600.00,'2021-12-09 17:48:54','',''),(2224196,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-09 17:48:54','',''),(2224212,'1','177','919',408,'Retail Sale Id 1308180',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 17:51:16','',''),(2224213,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 17:51:16','',''),(2224329,'1','177','919',408,'Retail Sale Id 1308225',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 18:08:44','',''),(2224330,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 18:08:44','',''),(2224341,'1','177','919',408,'Retail Sale Id 1308231',7800.00,0.00,0.00,0.00,400.00,'2021-12-09 18:11:35','',''),(2224342,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-09 18:11:35','',''),(2224353,'1','177','919',408,'Retail Sale Id 1308237',3999.84,0.00,0.00,0.00,205.12,'2021-12-09 18:13:46','',''),(2224354,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.41,0.00,'2021-12-09 18:13:46','',''),(2224405,'1','177','919',408,'Retail Sale Id 1308260',39000.00,0.00,0.00,0.00,2000.00,'2021-12-09 18:21:31','',''),(2224406,'1','177','919',408,'Retail sales',0.00,0.00,0.00,62.50,0.00,'2021-12-09 18:21:31','',''),(2224416,'1','177','919',408,'Retail Sale Id 1308264',1872.00,0.00,0.00,0.00,96.00,'2021-12-09 18:25:43','',''),(2224417,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-09 18:25:43','',''),(2224438,'1','177','919',408,'Retail Sale Id 1308274',3900.00,0.00,0.00,0.00,200.00,'2021-12-09 18:30:09','',''),(2224439,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-09 18:30:09','',''),(2224494,'1','177','919',408,'Retail Sale Id 1308286',3744.00,0.00,0.00,0.00,192.00,'2021-12-09 18:45:25','',''),(2224495,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-09 18:45:25','',''),(2224573,'1','177','919',408,'Retail Sale Id 1308301',6177.60,0.00,0.00,0.00,316.80,'2021-12-09 19:10:11','',''),(2224574,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.90,0.00,'2021-12-09 19:10:11','',''),(2225317,'1','177','919',408,'Retail Sale Id 1308459',3498.88,0.00,0.00,0.00,136.32,'2021-12-10 06:27:28','',''),(2225318,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.68,0.00,'2021-12-10 06:27:28','',''),(2225347,'1','177','919',408,'Retail Sale Id 1308474',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 06:29:23','',''),(2225348,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 06:29:23','',''),(2225361,'1','177','919',408,'Retail Sale Id 1308482',997.92,0.00,0.00,0.00,38.88,'2021-12-10 06:31:12','',''),(2225362,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 06:31:12','',''),(2225373,'1','177','919',408,'Retail Sale Id 1308488',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 06:32:45','',''),(2225374,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:32:45','',''),(2225391,'1','177','919',408,'Retail Sale Id 1308496',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 06:33:50','',''),(2225392,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:33:50','',''),(2225491,'1','177','919',408,'Retail Sale Id 1308523',7800.00,0.00,0.00,0.00,400.00,'2021-12-10 06:40:31','',''),(2225492,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:40:31','',''),(2225517,'1','177','919',408,'Retail Sale Id 1308547',2002.00,0.00,0.00,0.00,78.00,'2021-12-10 06:42:29','',''),(2225518,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 06:42:29','',''),(2225529,'1','177','919',408,'Retail Sale Id 1308553',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 06:43:52','',''),(2225530,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:43:52','',''),(2225558,'1','177','919',408,'Retail Sale Id 1308570',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 06:46:27','',''),(2225559,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 06:46:27','',''),(2225578,'1','177','919',408,'Retail Sale Id 1308580',997.92,0.00,0.00,0.00,38.88,'2021-12-10 06:47:52','',''),(2225579,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 06:47:52','',''),(2225614,'1','177','919',408,'Retail Sale Id 1308590',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 06:49:51','',''),(2225615,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 06:49:51','',''),(2225664,'1','177','919',408,'Retail Sale Id 1308622',3850.00,0.00,0.00,0.00,150.00,'2021-12-10 06:52:51','',''),(2225665,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.25,0.00,'2021-12-10 06:52:51','',''),(2225688,'1','177','919',408,'Retail Sale Id 1308635',1503.04,0.00,0.00,0.00,58.56,'2021-12-10 06:54:33','',''),(2225689,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 06:54:33','',''),(2225737,'1','177','919',408,'Retail Sale Id 1308662',702.24,0.00,0.00,0.00,27.36,'2021-12-10 06:57:45','',''),(2225738,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.14,0.00,'2021-12-10 06:57:45','',''),(2225936,'1','177','919',408,'Retail Sale Id 1308768',5999.84,0.00,0.00,0.00,233.76,'2021-12-10 07:11:03','',''),(2225937,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.74,0.00,'2021-12-10 07:11:03','',''),(2225960,'1','177','919',408,'Retail Sale Id 1308779',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 07:12:42','',''),(2225961,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 07:12:42','',''),(2225974,'1','177','919',408,'Retail Sale Id 1308788',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 07:14:07','',''),(2225975,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:14:07','',''),(2226004,'1','177','919',408,'Retail Sale Id 1308804',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 07:15:44','',''),(2226005,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:15:44','',''),(2226062,'1','177','919',408,'Retail Sale Id 1308828',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 07:18:46','',''),(2226063,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:18:46','',''),(2226098,'1','177','919',408,'Retail Sale Id 1308852',1503.04,0.00,0.00,0.00,58.56,'2021-12-10 07:20:09','',''),(2226099,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 07:20:09','',''),(2226275,'1','177','919',408,'Retail Sale Id 1308935',6776.00,0.00,0.00,0.00,264.00,'2021-12-10 07:29:07','',''),(2226276,'1','177','919',408,'Retail sales',0.00,0.00,0.00,11.00,0.00,'2021-12-10 07:29:07','',''),(2226425,'1','177','919',408,'Retail Sale Id 1308999',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 07:37:44','',''),(2226426,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:37:44','',''),(2226551,'1','177','919',408,'Retail Sale Id 1309067',15400.00,0.00,0.00,0.00,600.00,'2021-12-10 07:45:43','',''),(2226552,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 07:45:43','',''),(2226613,'1','177','919',408,'Retail Sale Id 1309097',1232.00,0.00,0.00,0.00,48.00,'2021-12-10 07:48:35','',''),(2226614,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 07:48:35','',''),(2226635,'1','177','919',408,'Retail Sale Id 1309107',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 07:49:45','',''),(2226636,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 07:49:45','',''),(2226840,'1','177','919',408,'Retail Sale Id 1309182',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 07:59:11','',''),(2226841,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 07:59:11','',''),(2227034,'1','177','919',408,'Retail Sale Id 1309258',6160.00,0.00,0.00,0.00,240.00,'2021-12-10 08:07:02','',''),(2227035,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.00,0.00,'2021-12-10 08:07:02','',''),(2227104,'1','177','919',408,'Retail Sale Id 1309283',3080.00,0.00,0.00,0.00,120.00,'2021-12-10 08:11:05','',''),(2227105,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:11:05','',''),(2227205,'1','177','919',408,'Retail Sale Id 1309322',2002.00,0.00,0.00,0.00,78.00,'2021-12-10 08:16:00','',''),(2227206,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 08:16:00','',''),(2227523,'1','177','919',408,'Retail Sale Id 1309467',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 08:30:36','',''),(2227524,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:30:36','',''),(2227581,'1','177','919',408,'Retail Sale Id 1309498',7502.88,0.00,0.00,0.00,292.32,'2021-12-10 08:33:28','',''),(2227582,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.18,0.00,'2021-12-10 08:33:28','',''),(2227639,'1','177','919',408,'Retail Sale Id 1309530',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 08:36:45','',''),(2227640,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:36:45','',''),(2227700,'1','177','919',408,'Retail Sale Id 1309563',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 08:40:28','',''),(2227701,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 08:40:28','',''),(2227744,'1','177','919',408,'Retail Sale Id 1309580',5544.00,0.00,0.00,0.00,216.00,'2021-12-10 08:42:57','',''),(2227745,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 08:42:57','',''),(2227796,'1','177','919',408,'Retail Sale Id 1309605',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 08:45:06','',''),(2227797,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 08:45:06','',''),(2227886,'1','177','919',408,'Retail Sale Id 1309637',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 08:47:38','',''),(2227887,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 08:47:38','',''),(2227928,'1','177','919',408,'Retail Sale Id 1309658',9997.68,0.00,0.00,0.00,389.52,'2021-12-10 08:49:21','',''),(2227929,'1','177','919',408,'Retail sales',0.00,0.00,0.00,16.23,0.00,'2021-12-10 08:49:21','',''),(2227946,'1','177','919',408,'Retail Sale Id 1309668',997.92,0.00,0.00,0.00,38.88,'2021-12-10 08:50:23','',''),(2227947,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 08:50:23','',''),(2227984,'1','177','919',408,'Retail Sale Id 1309686',3080.00,0.00,0.00,0.00,120.00,'2021-12-10 08:51:57','',''),(2227985,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 08:51:57','',''),(2228403,'1','177','919',408,'Retail Sale Id 1309890',997.92,0.00,0.00,0.00,38.88,'2021-12-10 09:12:27','',''),(2228404,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 09:12:27','',''),(2228435,'1','177','919',408,'Retail Sale Id 1309903',997.92,0.00,0.00,0.00,38.88,'2021-12-10 09:14:21','',''),(2228436,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 09:14:21','',''),(2228628,'1','177','919',408,'Retail Sale Id 1309991',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 09:26:15','',''),(2228629,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:26:15','',''),(2228660,'1','177','919',408,'Retail Sale Id 1310004',12320.00,0.00,0.00,0.00,480.00,'2021-12-10 09:28:42','',''),(2228661,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 09:28:42','',''),(2228787,'1','177','919',408,'Retail Sale Id 1310060',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 09:34:55','',''),(2228788,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:34:55','',''),(2229161,'1','177','919',408,'Retail Sale Id 1310255',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 09:57:30','',''),(2229162,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 09:57:30','',''),(2229249,'1','177','919',408,'Retail Sale Id 1310294',8482.32,0.00,0.00,0.00,330.48,'2021-12-10 10:02:49','',''),(2229250,'1','177','919',408,'Retail sales',0.00,0.00,0.00,13.77,0.00,'2021-12-10 10:02:49','',''),(2229343,'1','177','919',408,'Retail Sale Id 1310331',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 10:07:45','',''),(2229344,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 10:07:45','',''),(2229395,'1','177','919',408,'Retail Sale Id 1310362',3080.00,0.00,0.00,0.00,120.00,'2021-12-10 10:10:49','',''),(2229396,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:10:49','',''),(2229431,'1','177','919',408,'Retail Sale Id 1310379',2464.00,0.00,0.00,0.00,96.00,'2021-12-10 10:12:27','',''),(2229432,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.00,0.00,'2021-12-10 10:12:27','',''),(2229523,'1','177','919',408,'Retail Sale Id 1310400',1232.00,0.00,0.00,0.00,48.00,'2021-12-10 10:16:22','',''),(2229524,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.00,0.00,'2021-12-10 10:16:22','',''),(2229555,'1','177','919',408,'Retail Sale Id 1310431',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 10:18:26','',''),(2229556,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:18:26','',''),(2229627,'1','177','919',408,'Retail Sale Id 1310447',5199.04,0.00,0.00,0.00,202.56,'2021-12-10 10:22:02','',''),(2229628,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.44,0.00,'2021-12-10 10:22:02','',''),(2229657,'1','177','919',408,'Retail Sale Id 1310476',616.00,0.00,0.00,0.00,24.00,'2021-12-10 10:23:51','',''),(2229658,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.00,0.00,'2021-12-10 10:23:51','',''),(2229733,'1','177','919',408,'Retail Sale Id 1310515',3080.00,0.00,0.00,0.00,120.00,'2021-12-10 10:28:10','',''),(2229734,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 10:28:10','',''),(2229775,'1','177','919',408,'Retail Sale Id 1310539',5544.00,0.00,0.00,0.00,216.00,'2021-12-10 10:31:04','',''),(2229776,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.00,0.00,'2021-12-10 10:31:04','',''),(2229797,'1','177','919',408,'Retail Sale Id 1310550',2002.00,0.00,0.00,0.00,78.00,'2021-12-10 10:32:48','',''),(2229798,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 10:32:48','',''),(2229860,'1','177','919',408,'Retail Sale Id 1310572',2999.92,0.00,0.00,0.00,116.88,'2021-12-10 10:35:55','',''),(2229861,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-10 10:35:55','',''),(2229879,'1','177','919',408,'Retail Sale Id 1310579',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 10:37:01','',''),(2229880,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:37:01','',''),(2229901,'1','177','919',408,'Retail Sale Id 1310591',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 10:38:37','',''),(2229902,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 10:38:37','',''),(2230947,'1','177','919',408,'Retail Sale Id 1311058',2999.92,0.00,0.00,0.00,116.88,'2021-12-10 11:39:55','',''),(2230948,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.87,0.00,'2021-12-10 11:39:55','',''),(2230957,'1','177','919',408,'Retail Sale Id 1311061',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 11:41:12','',''),(2230958,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 11:41:12','',''),(2230973,'1','177','919',408,'Retail Sale Id 1311071',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 11:43:04','',''),(2230974,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 11:43:04','',''),(2231151,'1','177','919',408,'Retail Sale Id 1311167',3899.28,0.00,0.00,0.00,151.92,'2021-12-10 11:56:12','',''),(2231152,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.33,0.00,'2021-12-10 11:56:12','',''),(2231427,'1','177','919',408,'Retail Sale Id 1311300',9240.00,0.00,0.00,0.00,360.00,'2021-12-10 12:16:26','',''),(2231428,'1','177','919',408,'Retail sales',0.00,0.00,0.00,15.00,0.00,'2021-12-10 12:16:26','',''),(2231459,'1','177','919',408,'Retail Sale Id 1311318',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 12:19:27','',''),(2231460,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:19:27','',''),(2231560,'1','177','919',408,'Retail Sale Id 1311372',12320.00,0.00,0.00,0.00,480.00,'2021-12-10 12:27:30','',''),(2231561,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 12:27:30','',''),(2231628,'1','177','919',408,'Retail Sale Id 1311408',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 12:36:12','',''),(2231629,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:36:12','',''),(2231668,'1','177','919',408,'Retail Sale Id 1311447',8624.00,0.00,0.00,0.00,336.00,'2021-12-10 12:40:11','',''),(2231669,'1','177','919',408,'Retail sales',0.00,0.00,0.00,14.00,0.00,'2021-12-10 12:40:11','',''),(2231775,'1','177','919',408,'Retail Sale Id 1311492',7700.00,0.00,0.00,0.00,300.00,'2021-12-10 12:48:38','',''),(2231776,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 12:48:38','',''),(2231810,'1','177','919',408,'Retail Sale Id 1311509',1503.04,0.00,0.00,0.00,58.56,'2021-12-10 12:50:49','',''),(2231811,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 12:50:49','',''),(2231838,'1','177','919',408,'Retail Sale Id 1311524',3696.00,0.00,0.00,0.00,144.00,'2021-12-10 12:51:50','',''),(2231839,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 12:51:50','',''),(2231876,'1','177','919',408,'Retail Sale Id 1311536',30800.00,0.00,0.00,0.00,1200.00,'2021-12-10 12:55:16','',''),(2231877,'1','177','919',408,'Retail sales',0.00,0.00,0.00,50.00,0.00,'2021-12-10 12:55:16','',''),(2231936,'1','177','919',408,'Retail Sale Id 1311572',1848.00,0.00,0.00,0.00,72.00,'2021-12-10 12:58:56','',''),(2231937,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 12:58:56','',''),(2232547,'1','177',NULL,408,'Purchased from AA RANO NIG LTD.',0.00,2951520.00,5160.00,0.00,0.00,'2021-12-10 13:36:35','',''),(2232617,'1','177',NULL,408,'Reception corrector for bridging 126887',0.00,0.00,0.00,5160.00,0.00,'2021-12-10 13:39:34','',''),(2232618,'1','177','919',408,'Received from bridging 126887',0.00,0.00,5160.00,0.00,0.00,'2021-12-10 13:39:34','',''),(2234623,'1','177','919',408,'Retail Sale Id 1312760',1503.04,0.00,0.00,0.00,107.36,'2021-12-10 15:12:17','',''),(2234624,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 15:12:17','',''),(2234715,'1','177','919',408,'Retail Sale Id 1312804',12320.00,0.00,0.00,0.00,880.00,'2021-12-10 15:16:05','',''),(2234716,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 15:16:05','',''),(2234761,'1','177','919',408,'Retail Sale Id 1312834',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 15:18:15','',''),(2234762,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:18:15','',''),(2234823,'1','177','919',408,'Retail Sale Id 1312865',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 15:20:49','',''),(2234824,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:20:49','',''),(2234872,'1','177','919',408,'Retail Sale Id 1312891',15400.00,0.00,0.00,0.00,1100.00,'2021-12-10 15:22:18','',''),(2234873,'1','177','919',408,'Retail sales',0.00,0.00,0.00,25.00,0.00,'2021-12-10 15:22:18','',''),(2234932,'1','177','919',408,'Retail Sale Id 1312928',12400.08,0.00,0.00,0.00,885.72,'2021-12-10 15:24:31','',''),(2234933,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.13,0.00,'2021-12-10 15:24:31','',''),(2234978,'1','177','919',408,'Retail Sale Id 1312951',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 15:26:14','',''),(2234979,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 15:26:14','',''),(2235052,'1','177','919',408,'Retail Sale Id 1312972',3696.00,0.00,0.00,0.00,264.00,'2021-12-10 15:28:10','',''),(2235053,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:28:10','',''),(2235161,'1','177','919',408,'Retail Sale Id 1313022',3696.00,0.00,0.00,0.00,264.00,'2021-12-10 15:32:53','',''),(2235162,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 15:32:53','',''),(2235235,'1','177','919',408,'Retail Sale Id 1313057',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 15:36:08','',''),(2235236,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:36:08','',''),(2235393,'1','177','919',408,'Retail Sale Id 1313124',2802.80,0.00,0.00,0.00,200.20,'2021-12-10 15:42:30','',''),(2235394,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.55,0.00,'2021-12-10 15:42:30','',''),(2235433,'1','177','919',408,'Retail Sale Id 1313151',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 15:44:08','',''),(2235434,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 15:44:08','',''),(2235481,'1','177','919',408,'Retail Sale Id 1313183',11396.00,0.00,0.00,0.00,814.00,'2021-12-10 15:46:34','',''),(2235482,'1','177','919',408,'Retail sales',0.00,0.00,0.00,18.50,0.00,'2021-12-10 15:46:34','',''),(2235519,'1','177','919',408,'Retail Sale Id 1313208',1503.04,0.00,0.00,0.00,107.36,'2021-12-10 15:48:41','',''),(2235522,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 15:48:41','',''),(2235544,'1','177','919',408,'Retail Sale Id 1313223',3080.00,0.00,0.00,0.00,220.00,'2021-12-10 15:49:58','',''),(2235545,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 15:49:58','',''),(2235591,'1','177','919',408,'Retail Sale Id 1313252',10780.00,0.00,0.00,0.00,770.00,'2021-12-10 15:52:33','',''),(2235592,'1','177','919',408,'Retail sales',0.00,0.00,0.00,17.50,0.00,'2021-12-10 15:52:33','',''),(2235682,'1','177','919',408,'Retail Sale Id 1313294',997.92,0.00,0.00,0.00,71.28,'2021-12-10 15:56:24','',''),(2235683,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 15:56:24','',''),(2235708,'1','177','919',408,'Retail Sale Id 1313307',1798.72,0.00,0.00,0.00,128.48,'2021-12-10 15:57:47','',''),(2235709,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.92,0.00,'2021-12-10 15:57:47','',''),(2235741,'1','177','919',408,'Retail Sale Id 1313323',1503.04,0.00,0.00,0.00,107.36,'2021-12-10 15:59:22','',''),(2235742,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 15:59:22','',''),(2235778,'1','177','919',408,'Retail Sale Id 1313344',2500.96,0.00,0.00,0.00,178.64,'2021-12-10 16:00:28','',''),(2235779,'1','177','919',408,'Retail sales',0.00,0.00,0.00,4.06,0.00,'2021-12-10 16:00:28','',''),(2235800,'1','177','919',408,'Retail Sale Id 1313357',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 16:01:50','',''),(2235801,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:01:50','',''),(2235818,'1','177','919',408,'Retail Sale Id 1313366',12320.00,0.00,0.00,0.00,880.00,'2021-12-10 16:03:04','',''),(2235819,'1','177','919',408,'Retail sales',0.00,0.00,0.00,20.00,0.00,'2021-12-10 16:03:04','',''),(2235861,'1','177','919',408,'Retail Sale Id 1313378',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 16:05:18','',''),(2235862,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:05:18','',''),(2235942,'1','177','919',408,'Retail Sale Id 1313411',1503.04,0.00,0.00,0.00,107.36,'2021-12-10 16:08:14','',''),(2235943,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 16:08:14','',''),(2235987,'1','177','919',408,'Retail Sale Id 1313427',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 16:10:00','',''),(2235988,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:10:00','',''),(2236037,'1','177','919',408,'Retail Sale Id 1313453',5999.84,0.00,0.00,0.00,428.56,'2021-12-10 16:12:22','',''),(2236038,'1','177','919',408,'Retail sales',0.00,0.00,0.00,9.74,0.00,'2021-12-10 16:12:22','',''),(2236079,'1','177','919',408,'Retail Sale Id 1313479',14784.00,0.00,0.00,0.00,1056.00,'2021-12-10 16:14:26','',''),(2236080,'1','177','919',408,'Retail sales',0.00,0.00,0.00,24.00,0.00,'2021-12-10 16:14:26','',''),(2236126,'1','177','919',408,'Retail Sale Id 1313510',997.92,0.00,0.00,0.00,71.28,'2021-12-10 16:16:40','',''),(2236127,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 16:16:40','',''),(2236174,'1','177','919',408,'Retail Sale Id 1313538',1848.00,0.00,0.00,0.00,132.00,'2021-12-10 16:19:03','',''),(2236175,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:19:03','',''),(2236213,'1','177','919',408,'Retail Sale Id 1313560',1848.00,0.00,0.00,0.00,132.00,'2021-12-10 16:20:41','',''),(2236214,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:20:41','',''),(2236266,'1','177','919',408,'Retail Sale Id 1313592',3696.00,0.00,0.00,0.00,264.00,'2021-12-10 16:22:41','',''),(2236267,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:22:41','',''),(2236361,'1','177','919',408,'Retail Sale Id 1313633',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 16:26:40','',''),(2236362,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 16:26:40','',''),(2236449,'1','177','919',408,'Retail Sale Id 1313680',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 16:30:55','',''),(2236450,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:30:55','',''),(2236491,'1','177','919',408,'Retail Sale Id 1313699',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 16:32:41','',''),(2236492,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:32:41','',''),(2236540,'1','177','919',408,'Retail Sale Id 1313722',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 16:35:22','',''),(2236541,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 16:35:22','',''),(2236563,'1','177','919',408,'Retail Sale Id 1313730',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 16:36:37','',''),(2236564,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 16:36:37','',''),(2236597,'1','177','919',408,'Retail Sale Id 1313745',3696.00,0.00,0.00,0.00,264.00,'2021-12-10 16:38:12','',''),(2236598,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 16:38:12','',''),(2236626,'1','177','919',408,'Retail Sale Id 1313756',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 16:39:32','',''),(2236627,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 16:39:32','',''),(2236655,'1','177','919',408,'Retail Sale Id 1313768',997.92,0.00,0.00,0.00,71.28,'2021-12-10 16:40:50','',''),(2236656,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 16:40:50','',''),(2236686,'1','177','919',408,'Retail Sale Id 1313777',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 16:42:21','',''),(2236687,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 16:42:21','',''),(2236714,'1','177','919',408,'Retail Sale Id 1313788',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 16:43:53','',''),(2236715,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 16:43:53','',''),(2236818,'1','177','919',408,'Retail Sale Id 1313849',1848.00,0.00,0.00,0.00,132.00,'2021-12-10 16:50:44','',''),(2236819,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 16:50:44','',''),(2236852,'1','177','919',408,'Retail Sale Id 1313868',5001.92,0.00,0.00,0.00,357.28,'2021-12-10 16:52:50','',''),(2236853,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-10 16:52:50','',''),(2236898,'1','177','919',408,'Retail Sale Id 1313883',1398.32,0.00,0.00,0.00,99.88,'2021-12-10 16:54:52','',''),(2236899,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.27,0.00,'2021-12-10 16:54:52','',''),(2236941,'1','177','919',408,'Retail Sale Id 1313908',997.92,0.00,0.00,0.00,71.28,'2021-12-10 16:58:25','',''),(2236942,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 16:58:25','',''),(2236968,'1','177','919',408,'Retail Sale Id 1313929',1848.00,0.00,0.00,0.00,132.00,'2021-12-10 17:00:06','',''),(2236969,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 17:00:06','',''),(2237072,'1','177','919',408,'Retail Sale Id 1313974',5001.92,0.00,0.00,0.00,357.28,'2021-12-10 17:05:34','',''),(2237073,'1','177','919',408,'Retail sales',0.00,0.00,0.00,8.12,0.00,'2021-12-10 17:05:34','',''),(2237098,'1','177','919',408,'Retail Sale Id 1313987',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 17:07:48','',''),(2237099,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:07:48','',''),(2237124,'1','177','919',408,'Retail Sale Id 1314000',997.92,0.00,0.00,0.00,71.28,'2021-12-10 17:10:17','',''),(2237125,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 17:10:17','',''),(2237136,'1','177','919',408,'Retail Sale Id 1314006',1503.04,0.00,0.00,0.00,107.36,'2021-12-10 17:11:24','',''),(2237137,'1','177','919',408,'Retail sales',0.00,0.00,0.00,2.44,0.00,'2021-12-10 17:11:24','',''),(2237168,'1','177','919',408,'Retail Sale Id 1314020',997.92,0.00,0.00,0.00,71.28,'2021-12-10 17:14:30','',''),(2237169,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 17:14:30','',''),(2237202,'1','177','919',408,'Retail Sale Id 1314037',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 17:17:24','',''),(2237203,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'2021-12-10 17:17:24','',''),(2237222,'1','177','919',408,'Retail Sale Id 1314051',702.24,0.00,0.00,0.00,50.16,'2021-12-10 17:19:25','',''),(2237223,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.14,0.00,'2021-12-10 17:19:25','',''),(2237246,'1','177','919',408,'Retail Sale Id 1314060',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 17:21:33','',''),(2237247,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:21:33','',''),(2237284,'1','177','919',408,'Retail Sale Id 1314075',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 17:23:58','',''),(2237285,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:23:58','',''),(2237327,'1','177','919',408,'Retail Sale Id 1314084',1848.00,0.00,0.00,0.00,132.00,'2021-12-10 17:26:15','',''),(2237328,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.00,0.00,'2021-12-10 17:26:15','',''),(2237343,'1','177','919',408,'Retail Sale Id 1314091',3080.00,0.00,0.00,0.00,220.00,'2021-12-10 17:27:29','',''),(2237344,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 17:27:29','',''),(2237349,'1','177','919',408,'Retail Sale Id 1314094',6468.00,0.00,0.00,0.00,462.00,'2021-12-10 17:28:59','',''),(2237350,'1','177','919',408,'Retail sales',0.00,0.00,0.00,10.50,0.00,'2021-12-10 17:28:59','',''),(2237380,'1','177','919',408,'Retail Sale Id 1314101',7700.00,0.00,0.00,0.00,550.00,'2021-12-10 17:31:14','',''),(2237381,'1','177','919',408,'Retail sales',0.00,0.00,0.00,12.50,0.00,'2021-12-10 17:31:14','',''),(2237394,'1','177','919',408,'Retail Sale Id 1314106',3696.00,0.00,0.00,0.00,264.00,'2021-12-10 17:33:26','',''),(2237395,'1','177','919',408,'Retail sales',0.00,0.00,0.00,6.00,0.00,'2021-12-10 17:33:26','',''),(2237415,'1','177','919',408,'Retail Sale Id 1314117',3080.00,0.00,0.00,0.00,220.00,'2021-12-10 17:35:57','',''),(2237416,'1','177','919',408,'Retail sales',0.00,0.00,0.00,5.00,0.00,'2021-12-10 17:35:57','',''),(2237528,'1','177','919',408,'Retail Sale Id 1314176',997.92,0.00,0.00,0.00,71.28,'2021-12-10 17:47:08','',''),(2237529,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 17:47:08','',''),(2237556,'1','177','919',408,'Retail Sale Id 1314214',997.92,0.00,0.00,0.00,71.28,'2021-12-10 17:51:15','',''),(2237557,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.62,0.00,'2021-12-10 17:51:15','',''),(2237572,'1','177','919',408,'Retail Sale Id 1314223',843.92,0.00,0.00,0.00,60.28,'2021-12-10 17:53:25','',''),(2237573,'1','177','919',408,'Retail sales',0.00,0.00,0.00,1.37,0.00,'2021-12-10 17:53:25','',''),(2237600,'1','177','919',408,'Retail Sale Id 1314236',2002.00,0.00,0.00,0.00,143.00,'2021-12-10 17:57:21','',''),(2237601,'1','177','919',408,'Retail sales',0.00,0.00,0.00,3.25,0.00,'